﻿USE sofia;
DROP TABLE IF EXISTS sofia.kyq_vpl;
CREATE TABLE kyq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kyq_vpl WRITE;
INSERT INTO kyq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kɛse ɓo mɛtjil Isa al‑Masige. Naan̰ *goon Daud ɔɔ goon *Abraam. ");
INSERT INTO kyq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam ooj Isak, Isak ooj *Yakub ɔɔ Yakub ooj Juda ute gɛnaan̰gen gaabge. ");
INSERT INTO kyq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ɓo ooj Pɛrɛz ute Zɛra ɔɔ gaangen se Tamar ɓo kon̰ɗe. Pɛrɛz ooj Esrom. Esrom ooj Aram. ");
INSERT INTO kyq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ooj Aminadab. Aminadab ooj Naason. Naason ooj Salmon. ");
INSERT INTO kyq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ooj Booz ɔɔ ko Booz se ron̰ Raab. Booz se ɓo ooj Obed ɔɔ ko Obed se ron̰ Rut. ");
INSERT INTO kyq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obed ooj Jɛsɛ. Jɛsɛ se ɓo ooj Gaar *Daud. Daud se ɓo ooj Salomon do mɛnd Uri ki. ");
INSERT INTO kyq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomon ooj Roboam. Roboam ooj Abiya. Abiya ooj Asa. ");
INSERT INTO kyq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ooj Yozapat. Yozapat ooj Yɔram. Yɔram ooj Ozias. ");
INSERT INTO kyq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozias ooj Yɔtam. Yɔtam ooj Akaz. Akaz ooj Ɛzɛkias. ");
INSERT INTO kyq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ɛzɛkias ooj Manase. Manase ooj Amon. Amon ooj Jɔsias. ");
INSERT INTO kyq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jɔsias ooj Yekonia ute gɛnaan̰gen gaabge ɔɔ kaaɗ kɛn se ɓo gaan *Israɛlge kꞋtɔs kꞋɓaanɗe ɓulu taa naaŋ Babilon ki. ");
INSERT INTO kyq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kɛn naaɗe ɓaa aan Babilon ki se jaay ɓo, Yekonia ooj Salatiɛl ɔɔ Salatiɛl ooj Zorobabɛl. ");
INSERT INTO kyq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛl ooj Abiud. Abiud ooj Ɛliakim. Ɛliakim ooj Azor. ");
INSERT INTO kyq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ooj Sadok. Sadok ooj Akim. Akim ooj Ɛliud. ");
INSERT INTO kyq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliud ooj Ɛliɛzɛr. Ɛliɛzɛr ooj Matan. Matan ooj Yakub. ");
INSERT INTO kyq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub ooj Yusup. Yusup se ɓo gaabm Mari ɔɔ Mari se ɓo ooj Isan kɛn kꞋdaŋin̰ al‑Masi se. ");
INSERT INTO kyq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mɛtjilɗegen iin̰ do Abraam ki bini aan do Daud ki se, aas mɛtjili sik‑kaar‑sɔɔ. Kɛn iin̰ do Daud ki bini kꞋtɔs kꞋɓaanɗen ɓulu taa naaŋ Babilon ki se, aas mɛtjili sik‑kaar‑sɔɔ. Kɛn naaɗe ɓaan Babilon ki jaay bini aan do al‑Masi ki se, kic ɓo aas mɛtjili sik‑kaar‑sɔɔ. ");
INSERT INTO kyq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Te ɗoobm gay jaay jꞋoojn̰ Isa al‑Masi: kon̰ Mari se mɛnd kɛɛsn Yusup, num kɛn naan̰ ɓaa te ron̰ ki ey sum ɓo, Mari tɛɗ mɛndkaama ute tɔɔgŋ *Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gaabm kɛɛsin̰ Yusup se, debm kɛn lee tɛɗ nakge te ɗoobin̰a ɔɔ je an̰ kɔɔɗn mɛtin̰ naan jeege tu eyo. Taa naan̰ se ɓo naan̰ je an̰ rɛsɛ taa nam Ꞌbooy taarɗe eyo. ");
INSERT INTO kyq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kaaɗ kɛn naan̰ utu iŋg saap saap do taar kɛn se, gaŋ *kɔɗn Mɛljege Raa maakŋ nin̰ ki se teec naanin̰ ki taaɗin̰ ɔɔ: «Yusup, naai se mɛtjil *Daud, ɔn̰te ɓeere Mari se ɔkin̰ Ꞌtɛɗn mɛndi, taa Mari se aam te Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naan̰ se utu Ꞌkoojn̰ goon gaaba ɔɔ goon se naai an̰ daŋ Isa, taa naan̰ ɓo debm utu kɔɔɗn do jeen̰ge maakŋ *kusin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nakgen paacn̰ tɛɗ se, taa taar Mɛljege Raa taaɗo do dɔkin̰ ute taar debm taaɗ taar teeco taar Raa ki ron̰ Ezayi se aanga ɗoobin̰ ki kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ꞋBooyki! Goon mɛnd kɛn gaaba ɓaa te ron̰ ki eyo, utu Ꞌtɛɗn mɛndkaama ɔɔ koojn̰ goono ɔɔ goon se jeege an̰ daŋ Emanuel. Ro Emanuel se je ɗeekŋ ɔɔ: *Raa ute naajege. ");
INSERT INTO kyq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kɛn Yusup jaay iin̰ maakŋ bin̰ ki se, naan̰ took taar kɔɗn Mɛljege Raa taaɗin̰o se. Gɔtn se, Mari se naan̰ ɔkin̰ tɛɗn mɛndin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Num gaŋ naan̰ baate ɓaa ron̰ ki bini Mari oojn̰ maak ki. Ɔɔ goon jꞋoojin̰ se, Yusup ɔndin̰ ron̰ Isa. ");
INSERT INTO kyq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isa se jꞋoojin̰ maakŋ gɛgɛr kɛn Betleem kɛn taa naaŋ Jude ki, do Gaar *Ɛrɔd ki. Kɛn Isa jaay jꞋoojin̰ se, jee jeel k‑dijge iin̰o kaam kaaɗa tookŋo ɔɔ ɓaa aan maakŋ gɛgɛr kɛn Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kɛn naaɗe jaay aan se, naaɗe tɔnd mɛtn jeege ɔɔ: «Goon kꞋjꞋoojin̰ jaay ute kɔsn gaar Yaudge se tap ɓo, gayo? Taa naaje se jꞋaako k‑dijin̰ kaam kaaɗa tookŋo ɔɔ naaje kꞋɓaaɗo kɛrgŋ naanin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kɛn Ɛrɔd jaay booy taar se, nirlin̰ teece taa gaarin̰a; bin se ɔl jee Jeruzalɛm ki paac se ɓeere ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gɔtn se Gaar Ɛrɔd daŋ tus magal *jee tɛɗn sɛrkɛ Raage tu paac ɔɔ ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa paac kɛn maakŋ jeen̰ge tu ɔɔ naan̰ tɔnd mɛtɗe ɔɔ: «*Al‑Masi do dɔkin̰ Raa taaɗ taa koojin̰ se tap ɓo, jꞋan̰ koojn̰ gayo?» ");
INSERT INTO kyq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gɔtn se, naaɗe tɛrlin̰ ɔɔ: «Naan̰ se jꞋan̰ koojn̰ maakŋ gɛgɛr kɛn Betleem kɛn taa naaŋ Jude ki, aan gɔɔ kɛn do dɔkin̰ debm taaɗ taar teeco taar Raa ki raaŋin̰o ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Gɛgɛr kɛn Betleem kɛn taa naaŋ Jude ki se, naai kic lɛ maakŋ gɛgɛrge tun magal magal kɛn taa naaŋ Jude ki. Taa maakŋ naaŋi ki se ɓo utu aɗe teecn̰ magal kɛn utu Ꞌtɔɔɗn *Israɛl jeemge aan gɔɔ debm gaama se.» ");
INSERT INTO kyq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Gɔtn jaay Ɛrɔd daŋ jee jeel k‑dijge kalɗe ki se, nam kic ɓo jeel eyo. Kɛn naaɗe aan ɔŋin̰ se, naan̰ tɔnd mɛtɗe ɔɔ: «Kɛn tap ki se, k‑dijn̰ se tap ɓo naase aakin̰ki nuŋ ki?» ");
INSERT INTO kyq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɔɔ naan̰ ɗeekɗen ɔɔ: «ꞋƁaaki Betleem ki je ɔŋumkiro gɔtn goono se tak. Kɛn jaay ɔŋin̰kiroga num, Ꞌtɛrl Ꞌɓaakiro Ꞌtaaɗumki gɔtin̰a taa maam kic ɓo mꞋɓaa kɛrgŋ naanin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kɛn naaɗe jaay booy taar gaarge aas sum se, gɔtn se naaɗe iin̰ ɓaa, ɔɔ kɛn naaɗe ɓaa ɓaa se, k‑dijn̰ kɛn naaɗe aakin̰o kaam gɔtn kaaɗa tookŋo se, tɛr teec naanɗe ki daala. K‑dijn̰ se tɔɔɗɗe bini ɓaa ɗaar do ɓee kɛn goon maak ki se. ");
INSERT INTO kyq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kɛn naaɗe aak k‑dijn̰ se maakɗe raap sakan̰. ");
INSERT INTO kyq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kɛn naaɗe aan se, ɛnd maakŋ ɓee ki ɔɔ ɔŋ goono ute kon̰ Mari. Naaɗe ɛrg naan goon ki ɔɔ tɔɔmin̰ jaay ɓo naaɗe tɔɔɗ taa ɓɔɔnɗege ɔɔ ɛɗin̰ nakgen bɛɛ bɛɛ: daab, nakŋ ooto, ute uubm ootn kꞋdaŋin̰ mir se. ");
INSERT INTO kyq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kɛn naaɗe iin̰ ɔn̰ Mari sum se, *Raa ɔɔjɗe maakŋ niɗe ki ɔɔ jꞋɔn̰ten tɛrl kaal gɔtn Gaar Ɛrɔd ki. Taa naan̰ se ɓo naaɗe uun ɗoobm kuuy ɔɔ tɛrl ɓaa taa naaŋɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɛn jee jeel k‑dijge jaay iin̰ ɓaa sum se, kɔɗn Mɛljege Raa kalaŋ ɓaaɗo taaɗ Yusup ki maakŋ nin̰ ki ɔɔ: «Iin̰ ute mɛndi ɔɔ uun goono aan̰ Ꞌɓaaki taa naaŋ Masar ki. Iŋg gɔtn naane bini maam mꞋai taaɗ jaay ɓo sɔm naai aɗe tɛrlɛ. Ɓɛrɛ, Gaar *Ɛrɔd se je je goono taa an̰ tɔɔlɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Maakŋ nɔɔr ki se sum ɓo, Yusup iin̰ ute mɛndin̰a uun goono ɔɔ aan̰ ɓaa taa naaŋ Masar ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naan̰ tiŋg gɔtn naane bini Gaar Ɛrɔd ooyo. Nakŋ se aan ɗoobin̰ ki aan gɔɔ kɛn Mɛljege Raa taaɗo ute taar debm taaɗ taar teeco taar Raa ki do dɔkin̰ ɔɔ: Maam mꞋdaŋ mꞋɔɔɗo goonum gaaba naatn taa naaŋ Masar ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kaaɗ kɛn se Ɛrɔd utu zɛɛrɛ; ɔɔ naan̰ kɛn se naan̰ ɓaaɗo jeel ɔkga mɛtin̰a kɛn jee jeel k‑dijge dɛrlin̰ dɛrl se, gɔtn se naan̰ maakin̰ taarin̰ makɔn̰ɔ. Naan̰ und kulu ɔɔ num gaangen gaabgen ɔndo do ɓaar di ki jaay bɔɔyɔ bɔɔy paacn̰ kɛn maakŋ gɛgɛr kɛn Betleem ki ute maakŋ naaŋgen cɛɛs ki cɛɛs ki se, kꞋtɔɔlɗe paac. Taa ɓaar di ese se tum te kaaɗn kɛn jee jeel k‑dijge taaɗ Ɛrɔd ki gɛn k‑dijn̰ naaɗe aakin̰o. ");
INSERT INTO kyq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bin ɓo, nakŋ se aanga ɗoobin̰ ki aan gɔɔ kɛn debm taaɗ taar teeco taar Raa ki, ron̰ Jeremi, taaɗɗeno do dɔkin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","KꞋbooy nɔɔ eem maakŋ naaŋ Rama ki jeege tɔɔyɔ ɔɔ eem nɔɔ dɛna. Kɛse Rasɛl ɓo eem taa gɛnin̰ge, naan̰ kꞋsɛlin̰ kic ɓo ɗaar eyo gɛn tɔɔyɔ, taa gɛnin̰ge utga. ");
INSERT INTO kyq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kɛn Gaar *Ɛrɔd jaay ooy sum se, kɔɗn Mɛljege Raa taaɗ Yusup ki maakŋ nin̰ ki kaaɗ kɛn naan̰ utu taa naaŋ Masar ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Naan̰ taaɗin̰ ɔɔ: «Iin̰ ute mɛndi ɔɔ uun goono ɔk Ꞌtɛrl Ꞌɓaaki taa naaŋ *Israɛl ki taa jeegen kɛn je tɔɔl goono se, naaɗe ooyga.» ");
INSERT INTO kyq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɔɔ Yusup iin̰ ute mɛndin̰a, uun goono ɔɔ ɔk tɛrl taa naaŋ Israɛl ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anum kɛn naan̰ booy ɔɔ Arkɛlɛɔs ɔsga gaar gɛn taa naaŋ Jude gɔɔ bubin̰ Ɛrɔd ki se, gɔtn se Yusup ɓeere ɔkin̰ gɛn tɛrl ɓaa taa naaŋ Jude ki. Ɔɔ Mɛljege Raa taaɗin̰ maakŋ nin̰ ki ɔɔ n̰Ꞌiin̰ ɓaa taa naaŋ Galile ki. ");
INSERT INTO kyq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naan̰ iin̰ ɓaa iŋg maakŋ gɛgɛr kɛn kꞋdaŋin̰ Nazarɛt. Nakgen se aan ɗoobin̰ ki aan gɔɔ kɛn jee taaɗ taar teeco taar Raa ki taaɗo do dɔkin̰ ɔɔ: Naan̰ se jꞋan̰ daŋin̰ kɔɗ Nazarɛt. ");
INSERT INTO kyq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kɛn kaaɗin̰ jaay aan sum se, Jan‑Batist naar teec naan jeege tu ɔɔ baag taaɗn taar *Raa do kɔɗ‑ɓaar kɛn taa naaŋ Jude ki. Naan̰ taaɗ jeege tu ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«ꞋTɛrlki maakse taa *maakŋ Gaar Raa se ɔɔpga gɔɔrɔ!» ");
INSERT INTO kyq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Taa Jan se ɓo, debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗo taarin̰ do dɔkin̰ kɛn ɔɔ: KꞋbooy mind deba taaɗ makɔn̰ do kɔɗ‑ɓaar ki ɔɔ: ꞋƊaapki ɗoobm Mɛljege ɔɔ Ꞌtɛɗin̰sin̰ki jiga Ꞌtooɗn tal. ");
INSERT INTO kyq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan uuso kal kꞋɗaapin̰ ute bɛɛkŋ gin̰ji ɔɔ dɔɔk maakin̰ te kɔl daara; nakŋ kɔsin̰ iimi ute teeje. ");
INSERT INTO kyq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gɔtn se jeegen iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki ute kɛngen taa naaŋ Jude ki paac ɔɔ ute kɛngen iin̰o taa ool Jordan ki paac, naaɗe ɓaaɗo gɔtn Jan ki. ");
INSERT INTO kyq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Naaɗe tɔɔɗ mɛtn *kusin̰ɗege naan jeege tu ɔɔ Jan‑Batist batizɗe maakŋ ool magal kɛn kꞋdaŋin̰ Jordan se. ");
INSERT INTO kyq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kɛn Jan aak *Parizige ute *Sadusege dɛna ɓaaɗo ɔŋin̰ taa naan̰ aɗen batiz se, naan̰ ɗeekɗen ɔɔ: «Aakumki tu wɔɔjgen ara! Naŋa jaay ɓo dɛjseno taa aki kaan̰ kɔtn maak‑taar Raa kɛn utu bɔɔy do jeege tu se? ");
INSERT INTO kyq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Naan ki se, Ꞌtɛɗki nakgen jiga kɛn Ꞌtaaɗn jeege tu ɔɔ naase se Ꞌtɛrlkiga maakse, ");
INSERT INTO kyq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ɔɔ ɔn̰te Ꞌtaaɗki ɔɔki: naaje se lɛ kꞋgaan *Abraamge. ꞋBooyki mꞋasen ɗeeke, kogen ese se kɛn Raa je kic ɓo an̰ dɛlin̰ Ꞌtɛɗn gaange Abraam ki. ");
INSERT INTO kyq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ɓɛrɛ, alpasa se lɛ kꞋɗaarin̰ga mɛtn ko kaag ki. Ko kaaggen paacn̰ jaay ooj jig ey se, jꞋaɗen tɔgŋ tuun naatn ɔɔ jꞋaɗen tɔɔcn pooɗn. ");
INSERT INTO kyq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Maam se, mꞋasen batizn ute maane ɔɔ kɛse je ɗeekŋ ɔɔ naase Ꞌtɛrlkiga kiŋgse; num gaŋ debm utu ɓaaɗo mɛtum ki se, naan̰ magal ciruma. Maam se saa jɛn̰ ki kic ɓo mꞋaas gɛn kɔɔɗin̰ eyo. Debm ese se ɓo utu asen *batizn ute Nirl Salal ɔɔ ute pooɗo. ");
INSERT INTO kyq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ute gɛrt magalin̰ se naan̰ utu tuuy teen̰in̰a ɔɔ kɛn naan̰ jaay tuuy aasga num, kaam teen̰in̰ se naan̰ utu an̰ tɔsn kɔmb maakŋ giijin̰ ki; num tɛsin̰ se, naan̰ utu an̰ kɔmb maakŋ pooɗ kɛn ooy eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gɔtn se Isa iin̰ taa naaŋ Galile ki ɔɔ ɓaaɗo maakŋ ool magal gɛn Jordan ki, ɓaaɗo ɔŋ Jan taa an̰ batizin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Num Jan se baate tooko, ɗeek Isa ki ɔɔ: «Maam se, naai ɓo am batiz ey ɓo, tɛr naai ɓo ɓaaɗo gɔtn maam ki la!» ");
INSERT INTO kyq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Isa tɛrlin̰ ɔɔ: «Ɓɔrse se naai Ꞌtooko, taa naajege se jꞋaki tɛɗn nakŋ kɛn Raa maakin̰ jen ro ki ute ɗoobin̰a.» Gɔtn se Jan tooko. ");
INSERT INTO kyq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kɛn Isa kꞋbatizin̰ jaay ooko maakŋ maane ki sum se, naan̰ kɛn se sum ɓo maakŋ raa ɔɔɗ waŋ ɔɔ naan̰ aak *Nirl Raa bɔɔyo don̰ ki tec aan gɔɔ dɛɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɔɔ gɔtn se kꞋbooy mind deba taaɗ maakŋ raa ki ɔɔ: «Naan̰ se Goon maak‑jema. Maam ɓo mꞋbɛɛr mꞋɔɔɗin̰o taa naan̰ tɔɔlumi.» ");
INSERT INTO kyq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gɔtn se *Nirl Raa tɔɔɗ ɓaan ute Isa do kɔɗ‑ɓaar ki, taa Bubm sitange an̰ ɓaa naama. ");
INSERT INTO kyq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Maakŋ ɓiige tun si‑sɔɔ se, nɔɔrɔ katara se Isa ɔs te ɗim eyo ɔɔ kɛn ɓii si‑sɔɔ jaay aas se, naan̰ ɓo tɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bubm sitange, naan̰ debm naam jeege se, ɓaaɗo ɔŋ Isa ɗeekin̰ ɔɔ: «Kɛn naai ꞋGoon *Raa ɗeer num, Ꞌtaaɗ koge tun se ai dɛl nakŋ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Isa tɛrlin̰ ɔɔ: «Taar se kꞋraaŋin̰ga raaŋ do dɔkin̰ kɛn ɔɔ: Kɛn tɛɗ debkilimi iŋg se kɔsɔ kalin̰ ki sum eyo, num ute taargen paacn̰ kɛn teeco taar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tɛr Bubm sitange ɓaan ute Isa maakŋ gɛgɛr kɛn *salal Jeruzalɛm ki, ɓaa uun ɔlin̰ do *Ɓee Raa ki raan lɛŋ lɛŋ, ");
INSERT INTO kyq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ɔɔ ɗeekin̰ ɔɔ: «Kɛn naai ꞋGoon Raa ɗeer num, do ɓee ki ara se, iin̰ aal naaŋ ki. Taa taara se kꞋraaŋin̰ga raaŋ do dɔkin̰ kɛn ɔɔ: Raa Ꞌkund Ꞌkulu kɔɗin̰ge tu ɔɔ naaɗe ai caapm kɔkŋ jiɗege tu, taa jɛige se Ꞌkɔŋ rɔɔkŋ ro ko kɛn gam eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isa tɛrlin̰ ɔɔ: «Taar se kic kꞋraaŋin̰ga raaŋ do dɔkin̰ kɛn ɔɔ: Ɓɛrɛ, naai se Ꞌkɔŋ Ꞌnaam Mɛli Raa eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tɛr Bubm sitange tɔɔɗ ɓaansin̰ do ko kɛn jɛrlɛ ɔɔ taaɗin̰ taa naaŋ gaarin̰gen do naaŋ ki paac ute nakŋ kaakŋ bɛɛɗege. ");
INSERT INTO kyq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gɔtn se naan̰ ɗeekin̰ ɔɔ: «Kɛn naai jaay Ꞌɓaaɗo ɛrgga naanum ki ɔɔ Ꞌdaanumga num, nakgen se paac maam mꞋaisin̰ kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Anum Isa tɛrlin̰ ɔɔ: «Iik naatn cɛɛm ki Bubm sitange! Taa taar se kꞋraaŋin̰ga raaŋ do dɔkin̰ kɛn ɔɔ: Mɛli Raa kalaŋ tak se ɓo naai Ꞌkɛrgŋ naanin̰ ki ɔɔ an̰ Ꞌtɛɗn naabin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Gɔtn se Bubm sitange iin̰ ɔn̰in̰a ɔɔ *kɔɗn Raage ɓaaɗo aakin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jan‑Batist se kꞋjꞋɔkin̰ga daŋgay ki ɔɔ kɛn Isa jaay booy ɔɔ Jan jꞋɔkin̰ga daŋgay ki se, naan̰ iin̰ tɛrl ɓaa taa naaŋ Galile ki. ");
INSERT INTO kyq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kɛn naan̰ aan sum se, ɔn̰ gɛgɛrin̰ Nazarɛt ɔɔ ɓaa tiŋg maakŋ gɛgɛr kɛn Kaparnayum ki kɛn taa baar ki, taa naaŋ Zabulon ki ute gɛn Nɛptali ki. ");
INSERT INTO kyq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Taa naan̰ se ɓo nakŋ kɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗno do dɔkin̰ se, aanga ɗoobin̰ ki kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Naase jee taa naaŋ Zabulon ki ute jee taa naaŋ Nɛptali ki kɛn sak kaam aak baar, naase ɓo jee kɛn iŋgki jɛŋ ool Jordan kaam naane kɛn taa naaŋ Galile kɛn jeen̰ge Yaudge ey se; ");
INSERT INTO kyq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","naase jeegen kɛn iŋgki maakŋ gɔt kɛn ɔɔɗɔ utu aki kaakŋ gɔtɔ asen wɔɔr kɛlɛŋ! Naasen kɛn iŋgki taa naaŋ kɛn ɔɔɗɔ aan gɔɔ jee ooyga kooy se, gɔtn wɔɔr, ɓɛrɛ, aanga. ");
INSERT INTO kyq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kaaɗ kɛn se sum ɓo Isa baag taaɗn taar Raa jeege tu ɔɔ: «ꞋTɛrlki maakse taa *maakŋ Gaar Raa se ɔɔpga gɔɔrɔ!» ");
INSERT INTO kyq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Isa jaay aan taa naaŋ Galile ki se, naan̰ ɓaa lee taa baar ki ɔɔ gɔtn se naan̰ aak gɛnaage dio: deb kalaŋ ron̰ Simon kɛn kꞋdaŋin̰ ute ro Piɛr kici ɔɔ gɛnaan̰ se ron̰ Andre, tund tund gɛndɗe maan. Naaɗe se jee toocn̰ kɛn̰jge. ");
INSERT INTO kyq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naan̰ ɗeekɗen ɔɔ: «ꞋƁaaɗo daanumki! Ɓɔrse maam mꞋasen tɛɗn naase jee ɓaa Ꞌje jikilimge aɗe ɓaa ɗoobm Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Naaɗe naar ɔn̰ gɛndɗege ɔɔ daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Utu iik naan ki cɔkɔ se, naan̰ aak gɛnaage di kuuy, Jak te gɛnaan̰ Jan, gaan Zebedege, naaɗe ute bubɗe se iŋg kiŋg maakŋ markabɗe ki ɗaap ɗaap gɛndɗege ɔɔ gɔtn se Isa daŋɗe. ");
INSERT INTO kyq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Naaɗe naar iin̰ ɔn̰ bubɗe te markabɗe ɔɔ naaɗe daan Isa. ");
INSERT INTO kyq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tɛr Isa lee dɔɔɗ taa naaŋ Galile se paac dooy jeege maakŋ *ɓeeɗege tun Yaudge lee tusn maak ki gɛn keem Raa. Naan̰ taaɗɗen Labar Jiga gɛn *maakŋ Gaar Raa ɔɔ jeegen ɔk kɔɔn̰ge paac ute jeegen kɛn kɔɔn̰ge tujɗenga tuju maakɗe ki se, naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gɔtn se *nookin̰ eem dɔɔɗ taa naaŋ Siri se paac. Ɔɔ jeege ɓaano ute jee kɔɔn̰ge paac kɛn dɔɔl kɔɔn̰ɗege kaam kalaŋ eyo ɔɔ lee dabarɗe aan gɔɔ: jee ɔk kɔɔn̰ sitange, jee ɔk kɔɔn̰ puputu ɔɔ jee kꞋruŋguyge, paac se, naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jeege dɔɔlɔ dɛna ɔk mɛtn Isa: naaɗe se iin̰o taa naaŋ Galile ki, jeegen iin̰o taa naaŋ kɛn kꞋdaŋin̰ te ro Gɛgɛrgen Sik, kɛngen iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki ute kɛngen taa naaŋ Jude ki ɔɔ jeegen iin̰o jɛŋ ool Jordan kɛn kaam kaaɗa tookŋo. ");
INSERT INTO kyq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kɛn Isa aak dɔɔl jeegen dɛn ese se jaay ɓaaɗo cɛɛn̰ ki se, naan̰ ookŋ iŋg do kɔs ki ɔɔ jeegen mɛtin̰ ki ɓaaɗo ɔŋin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gɔtn se Isa uun taara ɔɔ baagɗen dooyo ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Maak‑raapo jeege tun jeel roɗe ki naaɗe se jee daayge naan *Raa ki, taa *maakŋ Gaar Raa se naaɗe ki! ");
INSERT INTO kyq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Maak‑raapo jeege tun iŋg eem keeme, taa Raa utu aɗen sɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Maak‑raapo jeege tun dalul, taa do naaŋa se Raa utu aɗesin̰ kɛɗn naaɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Maak‑raapo jeege tun kɛn je nakŋ kɛn tɔɔl Raa ki ute maakɗe paac taa nakŋ naaɗe je se, Raa utu aɗesin̰ kɛɗn ute maraadin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maak‑raapo jeege tun kɛn ɛɛj do jeege tu, taa naaɗe kic Raa utu aɗen kɛɛjn̰ doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Maak‑raapo jeege tun maakɗe *salal taa naaɗe utu kaakŋ Raa. ");
INSERT INTO kyq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Maak‑raapo jeege tun je ano ɓaa ute tɔɔsɛ, taa naaɗe se Raa utu aɗen daŋ ɔɔ: gɛnin̰ge. ");
INSERT INTO kyq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maak‑raapo jeege tun kꞋdabarɗe taa nakŋ kɛn naaɗe lee tɛɗ jaay tɔɔl Raa ki, taa maakŋ Gaar Raa se naaɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Maak Ꞌraapo naase kɛn jeege jaay naajse, dabarse ɔɔ tɔlsen taar jig eyo ute taargen mɛt ki eyo dose ki, taa naase Ꞌtɛɗkiga jee maamge. ");
INSERT INTO kyq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɔn̰ki maakse Ꞌraapm dɛn aak eyo, taa maakŋ raa ki se, Raa utu asen kɔgŋ bɛɗse dɛn aak eyo. Bin ɓo jee taaɗ taar teeco taar Raa ki do dɔkin̰ ɓaaɗo naanse ki se kic, kꞋdabarɗeno bin kici.» ");
INSERT INTO kyq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Naase se ɓo aan gɔɔ kaatn gɛn do naaŋa. Num kɛn kaata jaay kiŋgin̰ nijim se gɔtɔga num, jꞋan̰ tɛɗn jꞋɔɔ ɗi jaay Ꞌtɛɗn nijim gɔtin̰ ki se? Kɛn nijimin̰ se jaay gɔtɔga num, naan̰ se tɛɗga nakŋ cɛrɛ, jꞋan̰ ɓaa si naata ɔɔ jeege lee do ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Naase se ɓo gɔtn wɔɔr gɛn *dunia. Gɛgɛr kɛn jaay jꞋɔndin̰ do kɔs ki raan se, jꞋaakin̰ tal. ");
INSERT INTO kyq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kɛn jꞋɔɔc lɔɔmpɔ se taa jꞋan̰ deebm dugul don̰ ki eyo, num jꞋan̰ kuun kɔl ro kaag ki raan taa wɔɔr gɔtɔ jeege tun maakŋ ɓee ki se paac. ");
INSERT INTO kyq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bin num ɔn̰ki gɔtn wɔɔrse se wɔɔr naan jeege tu paac, taa naan̰ se ɓo jeege kaakŋ naabsen jigan kɛn Ꞌlee tɛɗki se, naaɗe *Ꞌnookŋ Bubsen maakŋ raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Maakŋ Ko Taar kɛn Raa ɛɗo Musa ki ute taar jee taaɗ taar teeco taar Raa ki raaŋo ɔɔ dooyno jeege do dɔkin̰ se, ɔn̰ten Ꞌsaapki ɔɔki maam mꞋɓaaɗo se taa Ko Taar se tɛɗn gɔtɔ, naɓo maam mꞋɓaaɗo se taa mꞋan̰ tɛɗn Ꞌkaasn ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ꞋBooyki bɛɛ mꞋasen taaɗa: kaaɗ kɛn maakŋ raa ute do naaŋa utu deel te ey ɓɔrt se, taar kꞋraaŋin̰ do Ko Taar kɛn Raa ɛɗo Musa ki jaay naase iŋgki do ki se, maakŋ taar ki se ɗimin̰ cɔkɔ kic ɓo, Ꞌkɔŋ Ꞌkut eyo bini, nakgen se paac kaan ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Taa naan̰ se ɓo, maakŋ Ko Taarge tun kɛn Raa ɛɗo Musa ki taaɗ ɔɔ gɛn tɛɗa jaay debm baate tɛɗn kɛn kalaŋ cɔkɔ aan gɔɔ ɗi kic ɓo ɔɔ dooy jeege Ꞌtɛɗn aan gɔɔ kɛn naan̰ tɛɗ se, debm bin se, Ꞌkɔɔpm debm baata *maakŋ Gaar Raa ki. Num debm took do taarge tun se, tɛɗin̰ paac te ɗoobin̰a ɔɔ dooy jeege Ꞌtɛɗn aan gɔɔ naan̰ se, debm bin se utu Ꞌtɛɗn magala maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ꞋBooyki mꞋasen taaɗa: kɛn nakŋ naase Ꞌtɛɗki jaay tɔɔl te Raa ki cir te gɛn jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute *Parizige ey se, naase aki kɔŋ kɛnd maakŋ Gaar Raa ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Naase Ꞌbooykiroga taar kɛn kꞋtaaɗo bubsege tu do dɔkin̰ kɛn ɔɔ: Ɔn̰te tɔɔl nam murs, ɔɔ debm jaay tɔɔlga nam murs se jꞋan̰ kɔkŋ kɔlin̰ gɔtn kɔjn̰ bɔɔr ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Num maam se, mꞋɗeeksen mꞋɔɔ: debm kɛn jaay tɛɗ taamooyo ro gɛnaan̰ ki se jꞋutu jꞋan̰ kɔjn̰ bɔɔrɔ don̰ ki. Ɔɔ debm jaay naaj gɛnaan̰ ɔɔ: ‹Naai se Ꞌdala› debm bin se, bɛɛki num, jꞋan̰ kɔl naan Yaudge tun *jee kaakŋ mɛtn taarge se. Ɔɔ tɛr debm jaay naaj gɛnaan̰ ɔɔ: ‹Naai se debm dɛrlɛ› debm bin se, bɛɛki num, jꞋan̰ kɔkŋ kɔl pooɗn, gɔtn dubar kɛn gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Kɛn naai jaay Ꞌɓaa ɓaa kɛɗn *sɛrki gɔtn kɛn kꞋjꞋiin̰ gɛn lee tɛɗn sɛrkɛ Raa ki se ɔɔ gɔtn ese se naai Ꞌsaap jaay ɔk taara ute gɛnaai num, ");
INSERT INTO kyq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ɔn̰ sɛrki naai Ꞌɓaan̰ ɓaa kɛɗa se ram ɔɔ ɔk tɛrl ɓaa ɔk taasa te gɛnaai jaay ɓo Ꞌɓaaɗo kɛɗn sɛrki se Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Kɛn naai jaay ɔk taar ɗim te debm taamooyi se, kɛn utu Ꞌɓaaki ɓaa ɗoob ki sum ɓo, Ꞌnaar Ꞌɗaapin̰ki taarse se ute naapa; ey num, ɓɛrɛ, debm taamooyi se ai ɓaa kɔli gɔtn debm kɔjn̰ bɔɔr ki ɔɔ debm kɔjn̰ bɔɔrɔ se lɛ ai kɔkŋ kɛɗi ji magal asgarge tu ɔɔ naan̰ ai kɔli daŋgay ki. ");
INSERT INTO kyq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ꞋBooy bɛɛ mꞋai taaɗa: nakŋ doi ki paac se, bini kɔbɔrɔ kic ɓo ɔg naŋin̰ te ey se, naai Ꞌkɔŋ teecn̰ maakŋ daŋgay ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Naase Ꞌbooykiga kɛn *Ko Taar kɛn Raa ɛɗo Musa ki taaɗ ɔɔ: Ɔn̰te Ꞌkɛɛsn mɛnd nam, ɔn̰te Ꞌkɛɛsn gaaba nam. ");
INSERT INTO kyq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Num gaŋ maam se mꞋɗeeksen mꞋɔɔ: debm kɛn jaay aak mɛnd nam ɔɔ dɔŋin̰ te maakin̰ se, debm bin se aan gɔɔ tooɗnsin̰ga. ");
INSERT INTO kyq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Num kɛn Ꞌkaami do ji daama ɓo ai kɔli maakŋ *kusin̰ ki num, kaami se ɔɔɗ und naatn. Roi kaam kalaŋ se jaay gɔtɔ num, bɛɛ cir kɛn roi paac ɓo Ꞌɓaa maakŋ pooɗ kɛn gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Num kɛn naai aak ji daami jaay ɓo ai kɔli maakŋ kusin̰ ki num, naai Ꞌgaaŋ undin̰ naatn. Kɛn roi kaam kalaŋ se jaay gɔtɔ num, bɛɛ cir kɛn roi paac ɓo Ꞌɓaa maakŋ pooɗ kɛn gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Tɛr *Ko Taar kɛn Raa ɛɗo Musa ki taaɗsenga daala ɔɔ: Debm kɛn jaay piir mɛndin̰ se an̰ kɛɗn maktubm gɛn piirin̰ jaayo. ");
INSERT INTO kyq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Num gaŋ maam se mꞋɗeeksen mꞋɔɔ: debm jaay an piir te mɛndin̰ se, kɛn mɛndin̰ ɛɛs kɛɛs gaabge jaayo. Ey num debm jaay piir mɛndin̰ se, kɛse gɔɔ ɔɔɗin̰ kɔɔɗ ɗoobm gɛn kɛɛsn gaabm nam. Ɔɔ debm ɔk mɛnd nam kꞋpiirin̰ga piir se lɛ, kɛse naan̰ aan gɔɔ debm ɛɛs mɛnd nam kici.» ");
INSERT INTO kyq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Daala, naase Ꞌbooykiga taar kɛn kꞋtaaɗo bubsege tu kɛn ɔɔ: ‹Taar naai naam taari ro ki naan Raa ki gɛn tɛɗa se, ɔn̰te kuum kaalin̰ naaŋ ki. Num gaŋ do nakge tun paacn̰ naai Ꞌnaamga naam taari naan Mɛli Raa ki se, naai an̰ tɛɗin̰a.› ");
INSERT INTO kyq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Num gaŋ maam se mꞋɗeeksen mꞋɔɔ: ɔn̰ten Ꞌnaamki rose. Ɔn̰ten Ꞌnaamki rose ute maakŋ raa, taa maakŋ raa se ɓo gɔtn kaag do Raa ro ki; ");
INSERT INTO kyq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ɔn̰ten Ꞌnaamki rose ute do naaŋa, taa do naaŋa se gɔtn tɔɔbm jɛ Raa; ɔn̰ten Ꞌnaamki rose ute Jeruzalɛm, taa Jeruzalɛm se gɛgɛr gɛn Gaar Magala. ");
INSERT INTO kyq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ɔn̰ten Ꞌnaam roi ute daan doi, taa bɛɛki doi ki se kalaŋ tap ɓo, naai an̰ kɔŋ tɛɗin̰ raap eyo ey lɛ ilim eyo. ");
INSERT INTO kyq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kɛn taarse ɓo mɛt ki lɛ ɔɔki: yɛɛ mɛt ki; kɛn mɛt ki ey lɛ ɔɔki: gɔtɔ, mɛt ki eyo. Ey num taar kɛn kꞋziiɗin̰ ziiɗ do ki se iin̰o gɔtn *Ɓubm sitange tu.» ");
INSERT INTO kyq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Isa taaɗɗen daala ɔɔ: «Naase Ꞌbooykiga kɛn *Ko Taar Raa taaɗ ɔɔ: debm kɛn tɔɔkga kaam nam num jꞋan̰ tɔɔkŋ kaam naan̰ kici, ɔɔ debm kɛn jaay tɛrɛcga naaŋ nam lɛ, jꞋan̰ tɛrɛcn̰ naaŋ naan̰ kici. ");
INSERT INTO kyq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Num maam se mꞋɗeeksen mꞋɔɔ: debm jaay tɛɗsenga kusin̰ num ɔn̰ten Ꞌtɛrlin̰ki kusin̰a. Taa naan̰ se ɓo kɛn nam jaay ɔndiga mɛtn bi kɛn do ji daama num, Ꞌtɛrlin̰ kɛn do ji jeele ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kɛn nam jaay ɓaansiga naan debm kɔjn̰ bɔɔr ki taa Ꞌkuun kali baat se num, kali magal se kic, ɔn̰in̰sin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kɛn debm jaay ɔli taa tɔɔgɔ ɔɔ Ꞌlee kilɔmɛtir kalaŋ se, naai Ꞌleen̰ kilɔmɛtir dio sɔrɔk ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Debm kɛn jaay tɔnd mɛtn ɗim gɔti ki num, ɛɗin̰ ɔɔ debm jaay je dɛm ɗimi num, ɔn̰te Ꞌkɔɔgin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Naase Ꞌbooykiga kɛn *Ko Taar Raa taaɗ ɔɔ: Naai Ꞌje naapi ɔɔ naase ɔɔki: ‹Debm taamooyi se ɔɔɗ undin̰a.› ");
INSERT INTO kyq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Num gaŋ maam se, mꞋɗeeksen mꞋɔɔ: Ꞌjeki jee taamooysege ɔɔ eemki Raa taa jeegen kɛn dabarse se. ");
INSERT INTO kyq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bin jaay ɓo aki tɛɗn gaan Bubsen maakŋ raa ki. Taa Raa se naan̰ ɓo debm lee ooko kaaɗin̰ do jee kusin̰ge tu ɔɔ do jeege tun bɛɛ. Ɔɔ naan̰ ɓo lee eeɗ maane do jeege tun tɛɗn nakgen ute ɗoobin̰a ɔɔ do jeege tun kɛn tɛɗn nakgen ute ɗoobin̰ ey se kici. ");
INSERT INTO kyq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ɔɔ kɛn naase jaay Ꞌjeki jeegen jese sum num, ute naan̰ se Ꞌsaapki ɔɔ aki kɔŋ bɛɗse naan Raa ki ne? Kɛn bin num *jee tɔkŋ miirge kic ɓo ɔŋ tɛɗ bin kici. ");
INSERT INTO kyq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Num kɛn naase jaay Ꞌlee Ꞌtɛɗki tɔɔsɛ gɛnaase tu sum num, ɗim jaay naase Ꞌtɛɗki jaay Ꞌcir gɛn jeege se tap ɓo ne ɗi? Taa jeegen Yaudge ey kic lɛ lee tɛɗ tɔɔsɛ ute naapa kici. ");
INSERT INTO kyq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bin num aan gɔɔ Bubsen maakŋ raa ki debm mɛc se, naase kic Ꞌtɛɗki jeegen mɛc.» ");
INSERT INTO kyq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tɛr Isa ɗeek daala ɔɔ: «Kɛn aki Ꞌtɛɗn naabm *Raa num, ɔn̰ten Ꞌtɛɗin̰ki naan jeege tu taa naaɗe asen kaaka. Ey num naase aki kɔŋ bɛɗse gɔtn Bubse kɛn maakŋ raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kɛn naai Ꞌje kɛɗn ɗim jee daayge tu num, ɔn̰ten Ꞌtɛɗin̰ naan jeege tu taa naaɗe ai kaaka aan gɔɔ gɛn jeegen tɛɗ roɗe jee bɛɛ jaay lee tɛɗ maakŋ *ɓee kɛn Yaudge lee tusn maak ki ɔɔ daan ɗoobge tun gɔtn jeege lee tusni, taa jeege jaay aakɗega num aɗen tɔɔm se. ꞋBooyki bɛɛ mꞋasen taaɗa: naaɗe se ɔŋga bɛɗɗe do naaŋ ki ara sum. ");
INSERT INTO kyq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Num gaŋ kɛn naai se jaay Ꞌje kɛɗn ɗim jee daayge tu ute ji daama num, ɔn̰te kɔn̰ ji jeeli Ꞌjeele. ");
INSERT INTO kyq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bin num nakŋ naai ɛɗ nam ki jaay ɔyin̰ kɔy kꞋjeel gɔtin̰ ey se, Raa Bubi se aak nakŋ naai tɛɗin̰ se, naan̰ ɓo utu ai kɛɗn bɛɗi.» ");
INSERT INTO kyq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Kɛn naase jaay aki tɔnd mɛtn Raa num, ɔn̰ten Ꞌtɛɗki aan gɔɔ gɛn jeegen tɛɗ roɗe aan gɔɔ naaɗe ɓo jee bɛɛ se. Taa kɛn naaɗe jaay ɓaaga maakŋ *ɓee kɛn Yaudge lee tusn maak ki, ey lɛ daan ɗoobge tu se, naaɗe ɗaar ɗaar jaay eem Raa taa je jeege aɗen kaaka. ꞋBooyki bɛɛ mꞋasen taaɗa: jee bin se naaɗe ɔŋga bɛɗɗe ɓɔrse do naaŋ ki ara. ");
INSERT INTO kyq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Num gaŋ kɛn naai Ꞌje keem Raa num, ɛnd maakŋ pakar tooɗi ki, Ꞌgaas kaam taara doi ki ɔɔ gɔtn se Ꞌtɔnd mɛtn Bubi Raa kɛn iŋg cɛɛi kɛn naai ɔŋ aakin̰ ey se ɔɔ Bubi Raa se, aak nakŋ kɛn naai Ꞌtɛɗin̰ ɔyin̰ kɔy jaay nam jeel gɔtin̰ ey se, utu ai kɛɗn bɛɗi. ");
INSERT INTO kyq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Kɛn naase aki tɔnd mɛtn Raa num, ɔn̰ten Ꞌɗɔɔlki taargen rɛn̰ rɛn̰ se cɔk cɔk aan gɔɔ jeegen Yaudge ey lee tɛɗ se. Naaɗe saap ɔɔ ute taargen naaɗe ɗɔɔlɗen cɔk cɔk se sum ɓo Raa aɗen booyo. ");
INSERT INTO kyq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Anum naase ɔn̰te Ꞌtɛɗki aan gɔɔ gɛn naaɗe se, taa Bubsen Raa se jeele nakŋ naase Ꞌjeki kɛn naase utu Ꞌtɔndki te mɛtin̰ ey kic num. ");
INSERT INTO kyq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bin num kɛn naase jaay aki keem Raa num, Ꞌɗeekki ɔɔki: Bubjen maakŋ raa ki, ɔn̰ jeege paac ai jeeli naai kali ki sum ɓo Raa. ");
INSERT INTO kyq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɔn̰ naai ɓo kɔsn gaara do jeege tu paac. Ɔn̰ jeegen do naaŋ ki ara paac se, ai tɛɗn maak‑jei aan gɔɔ gɛn jeegen maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɛɗjeno kɔsn kɛn ajen kaasn jaaki. ");
INSERT INTO kyq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞋTɔɔljen *kusin̰jen naaje kꞋtujn̰ naani ki, aan gɔɔ naaje kic ɓo kꞋtɛɗn kalɗɛ jeege tun kɛn tujjenga naaje ki kici. ");
INSERT INTO kyq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɔn̰te Ꞌkɔn̰je kꞋkɛnd maakŋ nakŋ naam ki, num ɔɔɗjen doje maakŋ ji *Ɓubm sitange tu. Taa gaara, tɔɔgɔ ɔɔ *nooko se gɛn naai gɛn daayum daayum. *Amin.» ");
INSERT INTO kyq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kɛn Isa jaay dooyɗen gɛn keem Raa aas se, tɛr naan̰ taaɗɗen ɔɔ: «Kɛn naase jaay Ꞌtɛɗki kalɗɛ jeege tun tujsen rose ki se, Bubsen maakŋ raa ki asen tɔɔl kusin̰ naase kici. ");
INSERT INTO kyq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Num gaŋ kɛn naase jaay Ꞌbaateki Ꞌtɛɗn kalɗɛ jeege tu lɛ, Bubsen maakŋ raa ki se asen tɔɔl kusin̰se ey kici.» ");
INSERT INTO kyq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Kɛn naase uunki kuun siam num, ɔn̰te dɔɔkki naanse aan gɔɔ jeegen tɛɗ roɗe aan gɔɔ jee bɛɛ se. Kɛn naaɗe jaay uunga siam num, tɛɗ daan‑kaamɗe taa jeege aakɗega num Ꞌɗeekŋ ɔɔ: jee se uun kuun siam. Anum Ꞌbooyki bɛɛ mꞋasen taaɗa: naaɗe se ɓɔrse ɔŋga bɛɗɗe do naaŋ ki ara. ");
INSERT INTO kyq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Num naai, kɛn Ꞌkuun siam num, Ꞌtug daan‑kaami ɔɔ Ꞌtɛɗ uubu roi ki. ");
INSERT INTO kyq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bin ɓo jeege kaakŋ jeel eyo kɛn naai uun kuun siam. Num Bubi Raa kalin̰ kɛn iŋg cɛɛi kɛn naai ɔŋ aakin̰ ey se ɓo, Ꞌjeel sum. Ɔɔ Bubi Raa kɛn aak nakŋ kɛn naai Ꞌtɛɗin̰ ɔyin̰ kɔy nam jeel ey se ɓo, utu ai kɛɗn bɛɗi.» ");
INSERT INTO kyq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ɔn̰ten Ꞌdabarki rose gɛn Ꞌtusn maalse do naaŋ ki ara, taa maalsen Ꞌtusin̰ki do naaŋ ki ara se, k‑n̰ɔɔge ute kuurge an̰ kɔŋ tujn̰ naatn ɔɔ jee ɓoogge kic lɛ Ꞌkɛnd ɓeene ɔɔ an̰ kɔŋ ɓoogo. ");
INSERT INTO kyq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bin num Ꞌtuski maalse maakŋ raa ki, gɔtn kɛn k‑n̰ɔɔge ute kuurge aɗen kɔŋ tuj eyo ɔɔ jee ɓoogge kic kɔŋ Ꞌkɛnd jaay an̰ ɓoog eyo. ");
INSERT INTO kyq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Taa gɔtn maali ro ki se, gɔtn ese ɓo maak‑saapi iŋg ro ki kici.» ");
INSERT INTO kyq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Kaama se naan̰ ɓo lɔɔmpɔn gɛn roa. Bin num kɛn kaami jaay lapi se, roi te dɛnin̰ paac se, iŋg maakŋ gɔt kɛn wɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Num kɛn kaamige jaay lapi ey se, roi paac ɓo iŋg maakŋ gɔt kɛn ɔɔɗɔ. Kɛn nakŋ kɛn ai wɔɔr gɔtɔ se jaay tɛɗga ɔɔɗ dɔrɔɗ num, gɔtɔ ai kilim doi ki dib!» ");
INSERT INTO kyq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Deb kalaŋ se Ꞌkɔŋ tɛɗn naaba gɔtn mɛlge tu di eyo. Kɛn naan̰ ɓo tɛɗn naaba gɔtɔ kaam di num, deb kalaŋ naan̰ an̰ kɔɔɗn kundu ɔɔ deb kalaŋ naan̰ an̰ Ꞌjea; ey lɛ deb kalaŋ se, naan̰ an̰ kɔkŋ ɔɔn̰ɔ ɔɔ kɛn kuuy se, naan̰ an̰ kaal maak ki eyo. Taa naan̰ se ɓo naase aki Ꞌkɔŋ tɛɗn naabm Raa ɔɔ ute gɛn gurs taa naapki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Taa naan̰ se ɓo maam mꞋɗeeksen mꞋɔɔ: taa kose se ɔn̰ten Ꞌkuunki nirlse taa nakŋ naase aki kɔsɔ, aki kaaye ɔɔ taa rose se ɔn̰ten Ꞌkuunki nirlse do kal kɛn naase aki tuusu. Taa kose se, naan̰ cir nakŋ kɔsɔ ɔɔ rose se lɛ, naan̰ cir kala. ");
INSERT INTO kyq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aakki tu yeelge se, naaɗe lɛ ɔɔc eyo ɔɔ ɔk teen̰ gɛn kɔj eyo ɔɔ giiji lɛ, naaɗe ɔk eyo ɔɔ ɔmb ɗim maak ki eyo. Ute naan̰ se kic ɓo Bubsen maakŋ raa ki ulɗe. Num naase se mɛt kando yeelge se, naase Ꞌcirɗeki? ");
INSERT INTO kyq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maakse ki se, naŋa jaay ute kuun nirlin̰ sum ɓo Ꞌkɔŋ ziiɗn ɓii kiŋgin̰ do naaŋ ki ne? ");
INSERT INTO kyq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Num gɛn ɗi jaay naase uunki nirlse do kalge tun aki tuus se? Aakki tu pɔɔn̰ nakgen taak bɛɛ maakŋ kaag ki se; naaɗe se ɔɓ kuub eyo ɔɔ ɔnd cɛk eyo. ");
INSERT INTO kyq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ꞋBooyki mꞋasen taaɗa: Gaar Salomon do dɔkin̰ se ute maalin̰ dɛn paac se kic ɓo, ɓii kalaŋ ɔŋ uus te kal aak bɛɛ tec aan gɔɔ gɛn naaɗe se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mu jaaki ɗaar maakŋ kaag ki ɔɔ mɛtbeeki sum ɓo jꞋutu jꞋan̰ tɔɔc se kic Raa tamarin̰ aak bɛɛ bɛɛ se ɓo, mɛt kando asen kɔŋ kɛɗn kal tuusu naase ki ey ne? Ɓɛrɛ, naase se jee kɛn aalki te maakse paac do Raa ki eyo! ");
INSERT INTO kyq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bin num ɔn̰te Ꞌkuunki nirlse ɔɔki: naaje tap ɓo jꞋkɔsn ɗi, jꞋkaay ɗi, ey lɛ jꞋtuusn ɗi? ");
INSERT INTO kyq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nakgen bin se paac jee jeel Raa mal ey se ɓo daayum iŋg saap do ki. Ey num Bubsen maakŋ raa ki se jeele nakŋ kɛn naase Ꞌjeki. ");
INSERT INTO kyq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kɛn deet deet se, Ꞌjeki ɓo Raa kɔsn gaara dose ki ute nakŋ kɛn tɔɔlin̰ ɔɔ nakgen ɔɔp paac se, naan̰ asesin̰ kɛɗn do ki. ");
INSERT INTO kyq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bin num ɔn̰ten Ꞌkuunki nirlse do nakge tun Ꞌtɛɗn mɛtbeeki: taa nakŋ Ꞌtɛɗn mɛtbeeki se, naase Ꞌjeelki eyo. Dubar aan jaaki se ɓo aasga gɛn ɓii se sum.» ");
INSERT INTO kyq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tɛr Isa ɗeekɗen daala ɔɔ: «Ɔn̰ten Ꞌkɔjki bɔɔrɔ do jeege tu, bin se naase kic ɓo jꞋasen kɔjn̰ bɔɔrɔ dose ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Taa *Raa se utu asen kɔjn̰ bɔɔrɔ dose ki aan gɔɔ kɛn naase Ꞌlee ɔjki do jeege tu, ɔɔ bin ɓo nakŋ naase Ꞌlee Ꞌdɔɔjn̰ki nakge jeege tu se, naase kic jꞋutu jꞋasesin̰ dɔɔjn̰ bin kici. ");
INSERT INTO kyq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mu cɔkɔn kɛn kaam gɛnaai ki ɓo naai ɔŋ aakin̰a. Num gɛn ɗi jaay naai ɔŋ aak guɗum kaagŋ kaami ki ey se? ");
INSERT INTO kyq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ute naan̰ se ɓo naai Ꞌkɔŋ ɗeekŋ gɛnaai ki ɔɔ: Gɛnaama, Ꞌɓaaɗo mꞋai kɔɔɗn mu kaami ki. Ey num naai ɔk mɛt‑guɗum kaaga kaami ki se kici! ");
INSERT INTO kyq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nakŋ naai Ꞌtɛɗin̰ se, mɛt ki eyo. Bɛɛki num, ɔɔɗ mɛt‑guɗum kaagŋ kaami ki se ram, jaay naai Ꞌkaakŋ jiga ɔɔ tɛr kɔɔɗn mu cɔkɔn kɛn kaam gɛnaai ki kici! ");
INSERT INTO kyq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Ɔn̰ten Ꞌkɛɗki nakŋ *salal gɛn Raa se bɛsge tu, ɓɛrɛ sɔm ɓaa naaɗe asen tɛrl dose ki ɔɔ asen don̰ nɛɛpm cɛrɛk cɛrɛk. Ɔɔ meeɗgen te roɗe se ɔn̰te siɗeki kin̰zirge tu, sɔm ɓaa naaɗe lee do ki cɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«ꞋLee Ꞌtɔndki mɛta ɔɔ jꞋasen kɛɗa, Ꞌlee Ꞌjeki ɔɔ naase aki kɔŋɔ, Ꞌlee Ꞌtɔndki kaam‑taara ɔɔ jꞋasen kɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ɗeere, debm tɔnd mɛta se jꞋan̰ kɛɗɛ, debm je se Ꞌkɔŋɔ ɔɔ debm tɔnd kaam‑taara se lɛ, jꞋutu jꞋan̰ kɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ꞋSaapki tu, kɛn gooni jaay tɔnd mɛtn mappa gɔti ki se, maakse ki se naŋa jaay an̰ kɛɗn koa? ");
INSERT INTO kyq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lɔɓu kɛn gooni jaay tɔnd mɛtn kɛn̰je num, maakse ki se naŋa jaay an̰ kɛɗn wɔɔjɔ? ");
INSERT INTO kyq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Naasen jeegen kɛn jig ey se kic ɓo Ꞌjeelki kɛɗn nakŋ bɛɛ gɛnsege tu. Num mɛt kando Bubsen maakŋ raa ki Ꞌkɛɗn nakgen jiga jeege tun tɔnd mɛtin̰ ey ne! ");
INSERT INTO kyq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Taa naan̰ se ɓo, nakŋ paacn̰ jaay naase Ꞌjeki jeege asen tɛɗn naase ki se, naase kic Ꞌtɛɗki jeege tu bin kici. Kɛse ɓo *Ko Taar kɛn Raa ɛɗo Musa ki ute jee taaɗ taar teeco taar Raa ki dooyno jeege do dɔkin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tɛr Isa aal naagŋ taara ɗeek ɔɔ: «Ɛndki ute taa ɗoobm baata! Taa taa ɗoobm magal budul se, naan̰ ɓo kɛn ɔl jeege gɔtn kut ki ɔɔ jeege dɛna aal te ɗoobm magal ese se. ");
INSERT INTO kyq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gaŋ taa ɗoobm kɛn ɔl jeege gɔtn kaaj ki se, naan̰ se baata ɔɔ ɗoobin̰ kic baat n̰ɛlɛl, bin num jeegen jaay ɛnd te taa ɗoobm ese se, naaɗe baata.» ");
INSERT INTO kyq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ɔndki kɔnd te jeegen jig eyo tɛɗ roɗe aan gɔɔ jee taaɗ taar teeco taar Raa ki se. Naaɗe ɓaaɗo ɔŋse ɔɔ tɛɗ roɗe dalul aan gɔɔ baatge, num gaŋ te maakɗe se naaɗe jee *kusin̰ aan gɔɔ k‑sogsogige. ");
INSERT INTO kyq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Naase aɗeki kaakŋ jeel ro naabɗe ki aan gɔɔ kꞋjꞋaak kꞋjeel ko kaaga ute koojin̰ se. ꞋJeelki, koojn̰ mɔŋgɔ se jꞋan̰ tuugŋ do tɔndɔm ki eyo. Ɔɔ koojn̰ goyab se jꞋan̰ tuugŋ do mɛrɛn̰j ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kaagŋ jaay jiga se ooj koojin̰ kic ɓo jiga, ɔɔ kaagŋ jaay kɔɔn̰ se, ooj koojin̰ kic ɓo jig eyo. ");
INSERT INTO kyq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaagŋ jaay jiga se, kꞋkɔŋ koojn̰ kaagŋ jig ey se do ki eyo. Ɔɔ kaagŋ jaay kɔɔn̰ se lɛ kꞋkɔŋ koojn̰ kaagŋ jiga se do ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaagŋ paacn̰ kɛn ooj koojin̰ jig ey se, jꞋan̰ gaaŋa ɔɔ jꞋan̰ toocn̰ naata. ");
INSERT INTO kyq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bin num, jeegen jig ey jaay tɛɗ roɗe aan gɔɔ jee taaɗ taar teeco taar Raa ki se, ute naabɗen naaɗe tɛɗ se ɓo, naase aɗeki kaakŋ jeel ro ki bin kici.» ");
INSERT INTO kyq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Jeegen kɛn daŋum ɔɔ: Mɛluma, Mɛluma se, naaɗe se paac ɓo kɔŋ kɛnd *maakŋ Gaar Raa ki eyo, num jeegen kɛn tɛɗ maak‑je Bubum kɛn maakŋ raa ki se sum ɓo Ꞌkɛndɗe. ");
INSERT INTO kyq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɓii kɛn kaam mɔɔtn se jeege dɛna am ɗeekŋ ɔɔ: ‹Mɛluma, Mɛluma, ute ro naai se ɓo naaje kꞋtaaɗo taar Raa, ute ro naai se ɓo naaje kꞋtuuro sitange ro jeege tu, ɔɔ ute roi naai se ɓo, naaje kꞋtɛɗo nakŋ‑kɔɔɓge dɛna!› ");
INSERT INTO kyq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɓii kɛn se maam mꞋaɗen taaɗn mꞋɔɔ: naase se, maam mꞋjeelseno te eyo. Iikki naatn cɛɛm ki dɔkɔ, naasen paacn̰ jee tɛɗn kusin̰ge se!» ");
INSERT INTO kyq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tɛr Isa aal naagŋ taara ɔɔ: «Debm kɛn jaay booy taaruma ɔɔ iŋg do ki se, naan̰ se tec aan gɔɔ debm mɛtɛkŋ kɛn iin̰ ɓeen̰ do ko ki. ");
INSERT INTO kyq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɓee se, kɛn maane eeɗe ɔɔ oolge kic ɓo ɗooco ɔɔ kuul ɔl makɔn̰ɔ ɓaaɗo deeb ɓee se bat naɓo, ɔŋ ruin̰ te eyo, taa ɓee se kꞋjꞋiin̰in̰ do ko ki. ");
INSERT INTO kyq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Num gaŋ debm booy taaruma ɔɔ iŋg do ki ey se, naan̰ se tec aan gɔɔ debm dɛrl kɛn iin̰ ɓeen̰ do kɛɛs ki. ");
INSERT INTO kyq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɓee se kɛn maane eeɗe, oolge kic ɓo ɗooco ɔɔ kuul ɔl makɔn̰ɔ ɓaaɗo deeb ɓee se bat, ɔɔ ɓee se ru naŋ tak.» ");
INSERT INTO kyq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kɛn Isa jaay taaɗ naŋ taarin̰ge sum se, jee dɛngen tus se jaay booy taar naan̰ dooyɗen se, ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Taa dooy naan̰ se ɔk tɔɔgɔ ɔɔ tec aan gɔɔ gɛn jeeɗegen jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kɛn Isa bɔɔyo do kɔs ki se dɔɔl jeege dɛna ɔk mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Gɔtn se gaaba kalaŋ ɔk kɔɔn̰ bikiɗi ɓaaɗo cɛɛ Isa ki, ɛrg naanin̰ ki tɔnd mɛtin̰ ɔɔ: «Mɛlje, kɛn naai Ꞌje num, ɛɗum lapia taa rom se ɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰.» ");
INSERT INTO kyq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isa ɔl jin̰ utin̰a ɔɔ ɗeekin̰ ɔɔ: «Yɛɛ, maam mꞋjea, ɔn̰ roi Ꞌɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰!» Gɔtn se sum ɓo, debm kɔɔn̰ bikiɗn se ɔŋ lapia ɔɔ ron̰ ɗaap tooɗ kɔlɔn̰ kɔlɔn̰. ");
INSERT INTO kyq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tɛr Isa ɗeekin̰ ɔɔ: «Iin̰ Ꞌɓaao, naɓo ɔn̰te ɓaa taaɗn nam ki; num Ꞌɓaa Ꞌtaaɗ roi *debm tɛɗn sɛrkɛ Raa ki se ɔɔ Ꞌɓaa ɛɗ *sɛrkɛ Raa ki aan gɔɔ kɛn *Musa taaɗin̰o maakŋ Kitap ki. Bin ɓo jeege paac Ꞌjeele, naai se ɔŋga lapia.» ");
INSERT INTO kyq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kɛn Isa jaay ɛnd kɛnd maakŋ gɛgɛr kɛn Kaparnayum ki se ɔɔ gɔtn se bubm asgarge kalaŋ ɓaaɗo ɔŋin̰a ɔɔ eemin̰ nɔɔ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Mɛlje, maam se mꞋɔk debm tɛɗn naabum kalaŋ se kɔɔn̰ɔ dɛna tooɗ tooɗ ɓeene. Kɔɔn̰in̰ se tɛrɛcin̰ kꞋruŋguyu ɔɔ dabarin̰ dɛn aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Gɔtn se Isa tɛrlin̰ ɔɔ: «Maam mꞋɓaa ɓei ki ɔɔ mꞋan̰ ɓaa kɛɗn lapia.» ");
INSERT INTO kyq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gɔtn se bubm asgar *Rɔmɛge se ɗeekin̰ ɔɔ: «Mɛlje, ɓɛrɛ, maam se mꞋaas te debm naai Ꞌɓaa ɓeem ki eyo. Num gɔtn ɗaari ki se, naai Ꞌtaaɗ ute taari sum ɓo, debm tɛɗn naabum se Ꞌkɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taa maam se, kic mꞋkaam ji deb kuuy, naɓo mꞋɔk asgarge kaam ji maam kici. Ɔɔ kɛn maakɗe ki se jaay mꞋɗeek deb kalaŋ ki mꞋɔɔ: ‹ꞋƁaa se› naan̰ iin̰ Ꞌɓaa. Ɔɔ mꞋɗeek deb kuuy ki mꞋɔɔ: ‹ꞋƁaaɗo se› naan̰ iin̰ ɓaaɗo. Ɔɔ ɓulum ki se jaay, mꞋɗeekin̰ mꞋɔɔ: ‹ꞋTɛɗ nakŋ ese se› naan̰ iin̰ tɛɗin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kɛn Isa jaay booy taar gaabm ese se, taara se ɔkin̰ taaɗ eyo. Naan̰ ɗeek jeege tun daanin̰ se ɔɔ: «Naase Ꞌbooyki bɛɛ mꞋasen taaɗa: maakŋ gaan *Israɛlge tun ute dɛnɗe se kic ɓo, maam mꞋɔŋ te nam jaay aal maakin̰ do *Raa ki aan gɔɔ gaabm ara se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Anum mꞋɗeeksen mꞋɔɔ: jeege dɛna utu aɗe kiin̰ ɓaa gɔtn kaam kaaɗa tookŋo, ɔɔ kaam kaaɗa toocn̰ ni, naaɗe aɗe ɓaa utu tusn Ꞌkiŋg kɔsn ɓii laa ki ute maak‑raapo ute ɓugjege *Abraam, Isaka ɔɔ *Yakub *maakŋ Gaar Raa ki tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Num gaangen gɛn maakŋ Gaar Raa tap ɓo, naaɗe se ɓo jꞋutu jꞋaɗen kɔɔɗɔ ɔɔ jꞋutu jꞋaɗen kɔmb naatn maakŋ gɔt kɛn ɔɔɗ dɔrɔɗ. Gɔtn se ɓo naaɗe ɓaa keeme ɔɔ taan̰ naaŋɗege.» ");
INSERT INTO kyq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tɛr Isa ɗeek bubm asgar *Rɔmɛge tu se ɔɔ: «Ɔk Ꞌtɛrl Ꞌɓaa ɓei ki. Ute kaal maaki naai aal dom ki paac se, nakŋ naai Ꞌtɔnd mɛta ro ki se Ꞌkɔŋ tɛɗa.» Ɔɔ kaaɗ kɛn se sum ɓo, debm tɛɗn naabin̰ se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tɛr Isa iin̰ ɓaa ɓee Piɛr ki. Kɛn naan̰ jaay aan sum se, ɔŋ moom Piɛr mɛnda se kɔɔn̰ɔ tooɗ tooɗ daŋal ki ɔɔ naan̰ ron̰ ɔŋ kɛɗɛk. ");
INSERT INTO kyq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gɔtn se naan̰ ɔl jin̰ utin̰a ɔɔ ron̰ ɔŋg kɛɗɛk se tɛrɛc urlu ɔɔ gɔtn se naan̰ iin̰ ɗaara ɔɔ baag tɛɗn kɔsɔ Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kɛn kaaɗa ooc jaay gɔtɔ tɛɗ ilim se, jeege ɓaano ute jee kɔɔn̰ sitange se dɛna gɔtn Isa ki. Ute taarin̰ se sum ɓo, naan̰ tuur sitange naatn ro jeege tu ɔɔ jee kɔɔn̰ge se paac naan̰ ɛɗɗen lapia kici. ");
INSERT INTO kyq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nakŋ Isa tɛɗ se aanga ɗoobin̰ ki aan gɔɔ taar kɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗno do dɔkin̰ kɛn ɔɔ: Kɔɔn̰jegen tujjeki rojege se, naan̰ uunin̰ga paac don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kɛn Isa jaay aak jee dɛnge ɔl gurugin̰ se, gɔtn se naan̰ ɗeek jeege tun mɛtin̰ ki ɔɔ kꞋgaaŋ kꞋɓaaki jɛŋ baar kɛn kaam naane. ");
INSERT INTO kyq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gaŋ maakŋ jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, deb kalaŋ iiko cɛɛn̰ ki ɗeekin̰ ɔɔ: «Debm dooy jeege, gɔtn naai Ꞌɓaa gay gay kic ɓo, maam mꞋai daana.» ");
INSERT INTO kyq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isa tɛrlin̰ ɔɔ: «ꞋBooyo! K‑bukumbɔɔge kic ɓo ɔk ɓee tooɗɗege, ɔɔ yeelge kic lɛ ɔk kujɗege. Num gaŋ maam *Goon Deba se mꞋɔk gɔtn maam mꞋan kɔl dom eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Maakŋ jeege tun mɛtin̰ ki se, deb kalaŋ kuuy se ɗeekin̰ ɔɔ: «Mɛlje, ɔn̰um mꞋaɗe ɓaa duubm bubum jaayo.» ");
INSERT INTO kyq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Gaŋ Isa tɛrlin̰ ɔɔ: «Ɔn̰ jeegen aan gɔɔ ooyga kooy naan Raa ki se Ꞌduubm naapa, num naai se, Ꞌɓaaɗo Ꞌdaanuma.» ");
INSERT INTO kyq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gɔtn se Isa ook maakŋ markab ki ɔɔ jee mɛtin̰ ki ɓaa ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gɔtn se sum ɓo kuulu dɔɔbɔ ɔɔ ɔl makɔn̰ɔ do baar ki. Kuulu se tɛɗ maane aal walak walak ɔɔ iin̰ ɓaa ɓaa ɗoocn̰ markaba. Num naan̰ kɛn se, Isa tooɗ tooɗ bia. ");
INSERT INTO kyq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jee mɛtin̰ ki iiko cɛɛn̰ ki tɔnd durin̰a ɔɔ ɗeekin̰ ɔɔ: «Mɛlje, naakje! Ey num ɓɛrɛ, naajege jꞋaki kutu.» ");
INSERT INTO kyq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Isa ɗeekɗen ɔɔ: «Gɛn ɗi jaay naase Ꞌɓeerki bin se? Naase se aalki te maakse paac do Raa ki eyo.» Gɔtn se naan̰ iin̰ ɗaara, aac kaama kuul ki ute maane ki ɔɔ naan̰ kɛn se, gɔtɔ ɓaa tooɗ dil. ");
INSERT INTO kyq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kɛn naaɗe jaay aak nakŋ ese se, paac ɔkɗen taaɗ eyo ɔɔ ɗeek ɔɔ: «Aakki tu nakage! Kɛse tap ɓo naŋa bini kɛn taaɗ kuulu ute maane ki kic ɓo tookin̰ taarin̰ se?» ");
INSERT INTO kyq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kɛn Isa jaay aan jɛŋ baar kɛn kaam naane, taa naaŋ jee Gadarge tu se, gɔtn se gaabge dio ɔk kɔɔn̰ sitange teeco maakŋ iiɓge tun Yaudge tɛɗin̰o gɛn tɔl taal yoɗege se, ɓaaɗo dɔɔɗin̰a. Gaabgen di se naaɗe kusin̰a ɔɔ gɔtn naaɗe iŋg se nam ɔŋ aal te ɗoobm se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kɛn naaɗe jaay aakin̰ se, gɔtn se naaɗe baag tɔɔɗn tɔɔyɔ ɔɔ: «Goon Raa, naai Ꞌje ɗi roje ki? Kɛn kaaɗn Raa ɔndin̰ se aas te ey ɓɔrt sum ɓo, naai Ꞌɓaaɗo Ꞌje ajen dabar la?» ");
INSERT INTO kyq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naanɗe ki dɔk cɔkɔ se ɔk dɔɔl kin̰zirge dɛna kꞋgaamɗe gaama. ");
INSERT INTO kyq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sitange se eem nɔɔ mɛtn Isa ki, ɗeekin̰ ɔɔ: «Kɛn ajen tuur num, ɔlje naaje kꞋɓaa kɛnd maakŋ dɔɔl kin̰zirge tu se.» ");
INSERT INTO kyq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Isa ɗeekɗen ɔɔ: «ꞋTeec Ꞌɓaaki.» Gɔtn se sitange se teeco ro gaabge tun di se ɔɔ ɓaa ɛnd maakŋ kin̰zirge tu. Naan̰ kɛn se sum ɓo dɔɔl kin̰zirgen te dɛnɗe se dɔɔb rus ɔɔ naar aan̰o girdi girdi bɔɔy ɓaa si maakŋ baar ki ɔɔ naaɗe ooy ut kap. ");
INSERT INTO kyq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kɛn jee gaam kin̰zirge jaay aak nakŋ tɛɗ se, naaɗe dɔɔb aan̰ ɓaa maakŋ gɛgɛr ki ɔɔ ɓaa taaɗ mɛtn taar nakgen deel se paac jeege tu nakŋ aan do gaabge tun di kɛn ɔk kɔɔn̰ sitange se. ");
INSERT INTO kyq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gɔtn se jee maakŋ gɛgɛr ki se paac teec ɓaaɗo ɔŋ Isa. Kɛn naaɗe ɓaaɗo ɔŋin̰ sum se, naaɗe sɛlin̰ mɛtin̰a ɔɔ ɗeekin̰ ɔɔ: «Naai se iin̰ Ꞌteec ɔn̰jen naaŋje!» ");
INSERT INTO kyq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tɛr Isa ook maakŋ markab ki, gaaŋ baar ɓaa maakŋ gɛgɛrin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Gɔtn se jeege uuno debm kꞋruŋguyu do nakŋ tooɗin̰ ki, ɔɔ ɓaano gɔtn Isa ki. Kɛn Isa jaay aak naaɗe aal maakɗe don̰ ki se, ɗeek debm kꞋruŋguy ki se ɔɔ: «Aay kaami goonuma! *Kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn.» ");
INSERT INTO kyq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Gaŋ jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kandum se baag taaɗn ute maakɗe ɔɔ: «Gaabm ese se naan̰ naaj naaj *Raa.» ");
INSERT INTO kyq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kɛn Isa jaay jeel saapɗe sum se, ɗeekɗen ɔɔ: «Taa ɗi jaay naase Ꞌsaapki nakŋ jig eyo ute maakse bin se? ");
INSERT INTO kyq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gɛn naase ki num kɛn gay ɓo ɔɔn̰ ciri kɛn mꞋɗeekŋ mꞋɔɔ: ‹Kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn› lɔɓu kɛn mꞋɗeekŋ mꞋɔɔ: ‹Iin̰i ɔɔ Ꞌlea› se ɓo ɔɔn̰ cir lɛ? ");
INSERT INTO kyq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bin num, naase aki Ꞌjeele maam *mꞋGoon Deba se, do naaŋ ki ara se, mꞋɔk tɔɔgɔ gɛn tɔɔl kusin̰ jeege.» Gɔtn se, Isa ɗeek debm kꞋruŋguy ki ɔɔ: «Iin̰i, uun nakŋ tooɗi se ɔɔ Ꞌɓaa ɓei ki!» ");
INSERT INTO kyq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gɔtn se gaaba se iin̰i ɔɔ ɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kɛn dɔɔl jee dɛnge jaay aak nakŋ ese se, ɓeere ɓaa ɔkɗe ɔɔ gɔtn se naaɗe tɔɔm Raa kɛn ɛɗ tɔɔgŋ bin se jikilimge tu. ");
INSERT INTO kyq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kɛn Isa jaay deel deel naane se, naan̰ aak gaaba kalaŋ kꞋdaŋin̰ Matiye *debm tɔkŋ miiri iŋg kiŋg gɔtn tɛɗn naabin̰ ki. Naan̰ ɗeekin̰ ɔɔ: «Iin̰i Ꞌdaanuma!» Gɔtn se sum ɓo Matiye iin̰i ɔɔ daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɓii kalaŋ Isa ute jee mɛtin̰ ki iŋg ɔs kɔs ɓee Matiye ki se, *jee tɔkŋ miirge dɛna te jee kusin̰ge se ɓaaɗo iŋg ɔs te naaɗe kici. ");
INSERT INTO kyq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kɛn *Parizige jaay aak nakŋ ese se, naaɗe ɗeek jeege tun mɛtn Isa ki ɔɔ: «Gɛn ɗi jaay Debm dooyse se iŋg ɔs te jee tɔkŋ miirge ɔɔ jee tɛɗn kusin̰ge se?» ");
INSERT INTO kyq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kɛn Isa jaay booy taarɗe se, ɗeekɗen ɔɔ: «Jee roɗe kiji se, naaɗe je daptor eyo, num kɛn je daptor se, jee kɔɔn̰ge. ");
INSERT INTO kyq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bin num Ꞌɓaa Ꞌsaapki do taar kɛn Raa taaɗno se kɛn ɔɔ: Maam mꞋje amki tɔjn̰ *sɛrkɛ sum eyo, num nakŋ maam mꞋje se, Ꞌtɛɗki bɛɛ ɓo jeege tu. Maam mꞋɓaaɗo se gɛn daŋ jee kɛn saap ɔɔ naaɗe aak bɛɛ naan Raa ki se eyo, num maam mꞋɓaaɗo se gɛn jee jeel roɗe ki, naaɗe jee kusin̰ge se.» ");
INSERT INTO kyq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gɔtn se jee mɛtn Jan‑Batist ki ɓaaɗo tɔnd mɛtn Isa ɗeekin̰ ɔɔ: «Naaje jꞋute *Parizige se kꞋlee kꞋtuun siam; anum gɛn ɗi jaay jee mɛtn naai ki uun siam ey se?» ");
INSERT INTO kyq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isa tɛrlɗen ɔɔ: «Jeegen ɓaaɗo kɔkŋ mɛnda jaay gaabm mɛnda utu se, naaɗe Ꞌkɔŋ kiŋg maak‑tuj ki la? Mɛt ki eyo. Naaɗe se kɔŋ kuun siam eyo kɛn mɛl mɛnda jaay utu te naaɗe se. Num gaŋ ɓii kalaŋ kaaɗin̰ utu Ꞌkaana gaabm mɛnda jꞋan̰ kɔɔɗn naatn se jaay ɓo mɛɗin̰ge se Ꞌkuun siam. ");
INSERT INTO kyq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«ꞋBooyki: nam kɔŋ kaal kal kiji ro kal kɛn koon eyo. Ey num kal kiji se an nɛɛpm ute kal koono. Ɔɔ gɔtn nɛɛpin̰ se Ꞌtɛɗn magal cir kɛn do dɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɔɔ tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se jꞋan̰ kɔŋ maakŋ k‑lɛɛtɛrge tun koon eyo. Ey num tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se an dɔɔbm ute k‑lɛɛtɛrge. Ɔɔ tɔtɔ se lɛ kɔɔy naaŋ ki cɛrɛ, ɔɔ k‑lɛɛtɛrge se lɛ tujn̰ kici. Bin num, tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se jꞋan̰ kɔmbin̰ maakŋ k‑lɛɛtɛrge tun kiji; taa bin se, tɔtn maak ki se lɛ tuj eyo ɔɔ k‑lɛɛtɛrge se lɛ kɔŋ Ꞌdɔɔb eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kaaɗ kɛn Isa utu taaɗɗen taaɗ ɓɔrt sum ɓo, maakŋ magal Yaudge tu se deb kalaŋ ɓaaɗo ɔŋin̰a, ɛrg naanin̰ ki ɗeekin̰ ɔɔ: «Goonum mɛnda se te ooy kooy ɓɔrse sum, Ꞌɓaaɗo kɔnd ji don̰ ki taa naan̰ duru.» ");
INSERT INTO kyq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gɔtn se Isa ute jee mɛtin̰ ki iin̰ ɔk mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kɛn naaɗe utu ɓaa ɓaa ɗoob ki se, gɔtn se, mɛnda kalaŋ bin se gɔtn moosin̰ aan sum se ɔŋ ɗaar eyo bini tɛɗ ɓaar sik‑kaar‑dio, naan̰ ɔko mɛtn Isa ɔɔ taaɗ te maakin̰ ɔɔ: «Kɛn maam mꞋɓaa jaay mꞋutga taa kalin̰ sum ɓo, mꞋutu mꞋkɔŋ lapia.» Gɔtn se naan̰ ɓaaɗo naagŋ Isa ki ut taa kalin̰a ɔɔ naar ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isa ɔk tɛrl aakin̰a ɔɔ ɗeekin̰ ɔɔ: «Aay kaami goonuma! Taa naai aalga maaki dom ki se, kaal maaki se aajiga.» Ɔɔ kaaɗ kɛn se sum ɓo, mɛnda se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kɛn Isa jaay aan ɓee gaab kɛn magal Yaudge se, naan̰ ɔŋ jee tuuy kaage ɔɔ jee dɛnge se lɛ ɗaar tɔɔy tɔɔy makɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naan̰ ɗeekɗen ɔɔ: «ꞋTeecki naatn! Ɓɛrɛ, goon mɛnda se lɛ ooy te eyo, naan̰ tooɗ tooɗ bi sum.» Gaŋ gɔtn se naaɗe ooyin̰ koogo mɛtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kɛn jee dɛn jaay jꞋɔɔɗɗeno naatn se, Isa ɛnd maakŋ ɓee ki ɔɔ ɔk ji goon mɛnda ɔɔ gɔtn se goon mɛnda se iin̰i. ");
INSERT INTO kyq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gɔtn se labarin̰ se wɔɔk dɔɔɗ taa naaŋ gɔtn ese paac. ");
INSERT INTO kyq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kɛn Isa iin̰ gɔtn se jaay ɓaa ɓaa se, gɔtn se jee kaam‑tɔɔkge dio ɔk mɛtin̰a ɔɔ tɔɔɗ tɔɔy ɔɔ: «Ɛɛjjen doje ki, naai *Goon Daud!» ");
INSERT INTO kyq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kɛn Isa jaay aan ɓeen se, jee kaam‑tɔɔkge se ɓaaɗo ɔŋin̰a ɔɔ naan̰ ɗeekɗen ɔɔ: «Naase Ꞌtook aalki maakse dom ki la kɛn maam mꞋɔk tɔɔgɔ gɛn tɛɗn nakŋ ese se?» Naaɗe tɛrlin̰ ɔɔ: «Yɛɛ Mɛlje, naaje kꞋtooko.» ");
INSERT INTO kyq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gɔtn se Isa uun jin̰ tɔndɗen kaamɗege tu ɔɔ ɗeekɗen ɔɔ: «Aan gɔɔ naase aalkiga maakse dom ki se, nakŋ naase Ꞌjeki se Ꞌkaan̰ kaama.» ");
INSERT INTO kyq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naan̰ kɛn se sum ɓo, kaamɗege naar tɔɔɗ taaka. Num gɔtn ese se Isa aacɗen kaama ɔɔ ɗeekɗen ɔɔ: «Ɔndki kɔndɔ: taar se, ɔn̰te Ꞌɓaa taaɗin̰ki nam ki.» ");
INSERT INTO kyq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Num gaŋ kɛn naaɗe jaay iin̰ ɓaa ɓaa sum se, nakŋ Isa tɛɗɗen se, naaɗe ɓaa wɔɔkin̰ taa naaŋ kɛn ese paac. ");
INSERT INTO kyq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gaŋ kɛn jee kaam‑tɔɔkgen di se jaay teec ɓaa ɓaa sum se, naan̰ kɛn se, naaɗe ɓaano gɔtn Isa ki ute gaaba kalaŋ bin se, ɔk kɔɔn̰ sitan kɛn ɔlin̰ ɔŋ taaɗ taar eyo. ");
INSERT INTO kyq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Gɔtn se Isa tuur te sitan ro gaab kɛn ese se, ɔɔ gaabm ɔŋ taaɗ taar ey se, baag taaɗn taara cɛy. Ɔɔ kɛn jee dɛnge aak se nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo ɔɔ ɗeek ɔɔ: «Maakŋ *Israɛl ki paac se, nakŋ bin se ɓii kalaŋ kꞋjꞋaak te eyo!» ");
INSERT INTO kyq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gaŋ *Parizige se ɗeek ɔɔ: «Ute *Ɓubm sitange se ɓo naan̰ tuur sitange ro jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isa lee ɓaa maakŋ gɛgɛrge tu ɔɔ maakŋ naaŋge tu paac, lee dooy jeege maakŋ *ɓeege tun Yaudge lee tusn maak ki. Naan̰ lee taaɗɗen Labar Jiga gɛn *maakŋ Gaar Raa ɔɔ lee ɛɗ lapi jee kɔɔn̰ge tu paac ɔɔ jeegen paacn̰ kɔɔn̰ɔ tujɗenga tuju. ");
INSERT INTO kyq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kɛn naan̰ aak jee dɛnge se, naan̰ ɛɛjɗen doɗe ki taa naaɗe se ɔɔrga ɔɔ maakɗe tujga aan gɔɔ baatgen ɔk debm gaam eyo. ");
INSERT INTO kyq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gɔtn se Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: «Maakŋ‑gɔtn tɛɗga gɛn kɔjɔ se dɛna, naɓo jee tɛɗn naabge se, baata. ");
INSERT INTO kyq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bin num, Ꞌtɔndki mɛtn Mɛl maakŋ‑gɔtɔ taa aɗe kɔl jee tɛɗn naabge do ki gɛn kɔjn̰ maakŋ gɔtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tɛr Isa daŋo jee mɛtin̰ kɛn sik‑kaar‑dio. Naan̰ ɛɗɗen tɔɔgɔ gɛn tuur sitange ro jeege tu ɔɔ gɛn kɛɗn lapi jee kɔɔn̰ge tu paac ɔɔ jeegen paacn̰ kɛn kɔɔn̰ɔ tujɗenga tuju. ");
INSERT INTO kyq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kɛn ara ɓo ro jee kaan̰ naabm Isagen sik‑kaar‑dio: kɛn deet se, Simon kꞋdaŋin̰ Piɛr se ute gɛnaan̰ Andre; Jak ute gɛnaan̰ Jan, naaɗen di se gaan Zebedege; ");
INSERT INTO kyq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ɔɔ Bartelemi; Tɔma ɔɔ Matiye kɛn naabin̰ tɔkŋ miiri se; Jak goon Alpe ɔɔ Tade; ");
INSERT INTO kyq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon debm je kujn̰ naaŋin̰a ɔɔ Judas Iskariɔt, naan̰ ɓo debm utu kutn Isa se. ");
INSERT INTO kyq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Naaɗe se ɓo jee kaan̰ naabm Isagen sik‑kaar‑di kɛn naan̰ ɔlɗen naaba. Kɛn ɔlɗe kɔl se, naan̰ dɛjɗe ɔɔ taaɗɗen ɔɔ: «Ɔn̰te Ꞌɓaaki maakŋ naaŋge tun mɛlin̰ge Yaudge eyo ɔɔ maakŋ gɛgɛr *Samarige tu se kalaŋ kic ɓo ɔn̰te Ꞌkɛndki maak ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Num Ꞌɓaaki gɔtn gaan *Israɛlge tu, naaɗen tec aan gɔɔ baatgen iigga kiig se. ");
INSERT INTO kyq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kɛn Ꞌɓaaki ɓaa ɗoob ki se Ꞌtaaɗɗeki taar *Raa ɔɔki: ‹Ɓɛrɛ, *maakŋ Gaar Raa se ɔɔpga gɔɔrɔ!› ");
INSERT INTO kyq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɛɗki lapi jee kɔɔn̰ge tu, Ꞌdurki jeegen ooyga kooyo, ɛɗki lapi jee bikiɗge tu taa roɗe Ꞌɗaapm tɛɗn aak bɛɛ naan Raa ki ɔɔ Ꞌtuurki sitange ro jeege tu. Taa naase lɛ ɔŋki cɛrɛ ɗey se, naase kic ɓo ɛɗin̰ki jeege tu cɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","«Kɛn naase Ꞌɓaaki ɓaa se, ɔn̰te Ꞌkuunki daab, pudda ey lɛ gurs maakŋ pɔs ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ɔɔ kɛn Ꞌɓaaki ɓaa ɗoob ki se ɔn̰te Ꞌkuunki ɓɔɔnɔ, ɔn̰ten Ꞌtɔski kalge di dio, saage ɔɔ ɔn̰ten Ꞌkuunki sirɗi. Taa debm tɛɗn naaba se, bɛɛki num, jꞋan̰ kɛɗn kɔsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Kɛn naase jaay aki kɛnd maakŋ gɛgɛr ki ey lɛ maakŋ naaŋ ki se, Ꞌjeki debm bɛɛ kɛn asen dɔɔɗn kɔkŋ jiga. Naase iŋgki gɔtn deb kɛn ese sum bini anki kiin̰ ɓaa maak ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Maakŋ ɓee kɛn jaay naase ɛndkiga maak ki se, Ꞌtɛɗɗeki tɔɔsɛ. ");
INSERT INTO kyq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kɛn jee maakŋ ɓee ki se jaay dɔɔɗ ɔksenga lɛ, ɔn̰ tɔɔsɛ se kiŋg te naaɗe. Num kɛn naaɗe jaay dɔɔɗ ɔksen te ey lɛ, ɔn̰ tɔɔsɛ se asen tɛrl kɔŋ gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kɛn maakŋ gɛgɛr ki ey lɛ maakŋ ɓee kɛn naase aki kɛnd maak ki jaay, naaɗe baate dɔɔɗn kɔkse se, ɔɔ baate booy taarse num, naase Ꞌteec ɔn̰ɗenki ɓeeɗe ey lɛ maakŋ gɛgɛrɗe ɔɔ kɛn teec Ꞌɓaaki ɓaa se, kuɗn jɛsege tu se kic ɓo Ꞌtupɗeki naatn. ");
INSERT INTO kyq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ꞋBooyki bɛɛ mꞋasen taaɗa: ɓii kɛn Raa Ꞌkɔjn̰ bɔɔrɔ do jeege tu se, jee maakŋ gɛgɛr kɛn ese se bɔɔr koocn̰ do naaɗe ki se aɗen tɛɗn ɔɔn̰ cir gɛn jee taa naaŋ Sɔdɔm ute gɛn Gɔmɔr!» ");
INSERT INTO kyq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ꞋƁooyki! Maam mꞋɔlse aan gɔɔ baatge maakŋ k‑sogsogige tu; naɓo naase se iŋgki do mɛtɛkse ki aan gɔɔ wɔɔjge ɔɔ Ꞌtɛɗki rose miskinge aan gɔɔ dɛɛrge. ");
INSERT INTO kyq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɔndki kɔndɔ, taa jeege utu asen tɔkŋ ɓaa gɔtn kɔjn̰ bɔɔrge tu, naaɗe asen tɔnd ute mɛɛjɛ maakŋ *ɓeege tun Yaudge lee tusn maak ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Taa maam se naaɗe asen tɔkŋ ɓaa naan magalge tu ɔɔ naan gaarin̰ge tu, taa bin se naase aki tɛɗn saaɗumge naan naaɗe ki ɔɔ naan jeege tun Yaudge ey se kici. ");
INSERT INTO kyq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kɛn jaay jꞋɔk kꞋɓaansinga naan tɔɔgge tu num, gɔtn naane se ɔn̰te Ꞌɓeerki do taar kɛn naase aki ɓaa taaɗa ɔɔ ute raay naase aki kɔŋ jaay anki taaɗn taar se. Taa kaaɗ kɛn se, Raa ɓo asen kɛɗn taar kɛn naase aɗeki taaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taa taar naase aki taaɗ se, gɛn naase malin̰ge eyo, num taar se Nirl gɛn Bubse Raa ɓo asen kɔl naase aki taaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Naan̰ kɛn se, gɛnaa utu kɔl gɛnaan̰ jꞋan̰ ɓaa tɔɔlɔ ɔɔ bubu kici utu kɔl goonin̰a jꞋan̰ ɓaa tɔɔlɔ. Gaange utu tɛrl naaga bubɗege tu ɔɔ je yoɗe. ");
INSERT INTO kyq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taa maam se jeege paac utu asen kɔɔɗn kundu; naɓo debm jaay aayga kaamin̰ bini aanga do taar tɔɔlin̰ ki num, naan̰ se utu Ꞌkɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kɛn jaay kꞋdabarse maakŋ gɛgɛr kɛn kaam kalaŋ num, aan̰ Ꞌɓaaki maakŋ gɛgɛr kɛn kuuyu. ꞋBooyki bɛɛ mꞋasen taaɗa: gɛgɛrgen maakŋ naaŋ *Israɛl ki se, naase aɗeki lee dɔɔɗ ey sum ɓo, maam *Goon Deba se mꞋkaan ro ki. ");
INSERT INTO kyq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Debm lee mɛtn deb kɛn dooyin̰ se, Ꞌkɔŋ cir debm dooyin̰ eyo; ɔɔ debm tɛɗn naaba gɔtn deb ki se, naan̰ se Ꞌkɔŋ cir mɛlin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Anum debm lee mɛtn deb kɛn lee dooyin̰ se n̰Ꞌtɛɗ aan gɔɔ debm dooyin̰ se. Ɔɔ debm Ꞌtɛɗ naaba gɔtn deb ki se kic lɛ, n̰Ꞌtɛɗ aan gɔɔ mɛlin̰ se. Taa debm kɛn mɛl ɓee se kic naaɗe naajin̰a ɔɔ naan̰ ɓo Belzebul, bin num mɛt kando kꞋnaajn̰ jeegen maakŋ ɓeen̰ ki se cir gɛn naan̰ se daala!» ");
INSERT INTO kyq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Taa naan̰ se ɓo jeege se, ɔn̰ten Ꞌɓeerɗeki! Taa kaaɗin̰ jaay utu Ꞌkaan se, nakŋ paacn̰ jꞋɔyin̰ga kɔy se, utu Ꞌtooɗn tal. Ɔɔ nakŋ ɓɔrse kꞋjeelki mɛtin̰ ey se, jꞋutu jꞋan̰ki jeele. ");
INSERT INTO kyq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nakŋ paacn̰ maam mꞋtaaɗsesin̰ maakŋ nɔɔr ki se, Ꞌɓaa Ꞌtaaɗin̰ki jeege tu ute kaam kaaɗa. Nakŋ kɛn naase Ꞌbooyin̰ki kꞋtaaɗsen naaŋ ki mɛtn bisege tu se Ꞌwɔɔkin̰ki do ɓeege tu kici. ");
INSERT INTO kyq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɔn̰te Ꞌɓeerki jeege tun Ꞌtɔɔl daa roa, ey num kɔŋ tɔɔl ko ey se; num Ꞌɓeerki ɓo Raa ki, naan̰ ɓo debm kɛn ɔk tɔɔgɔ kɛn tɔɔl daa rose ɔɔ tɔɔl kose maakŋ pooɗ kɛn gɛn daayum se. ");
INSERT INTO kyq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yeelge sɛɛm sɛɛm di se kꞋdugin̰ ute kɔbɔrɔ kalaŋ sum ey la? Ute naan̰ se kic ɓo kɛn maakɗe ki se jaay kalaŋ Ꞌkoocn̰ naaŋ ki se kɛn Bubsen Raa tookga jaayo. ");
INSERT INTO kyq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Num gaŋ naase se bɛɛkŋ dosege kic ɓo Raa jeelin̰ kalaŋ kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bin se, ɔn̰te Ꞌɓeerki! Naan Raa ki se, naase se Ꞌcirki yeelge se dɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Debm jaay taaɗ naan jeege tu ɔɔ naan̰ debm maam se, maam kic mꞋtaaɗn naan Bubum kɛn maakŋ raa ki mꞋɗeekŋ mꞋɔɔ: naan̰ se debm maama. ");
INSERT INTO kyq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Num debm kɛn baatum naan jeege tu se, maam kic mꞋutu mꞋan̰ baatin̰ naan Bubum kɛn maakŋ raa ki kici.» ");
INSERT INTO kyq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Isa taaɗ ɔɔ: «Ɔn̰ten Ꞌsaapki ɔɔki maam se mꞋɓaano ute lapia ɓo do naaŋ ki. Maam se mꞋɓaano ɓo ute lapi eyo, num mꞋɓaano ute bɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ɗeere, maam se mꞋɓaaɗo gɛn: gaaŋ goon gaaba ute bubin̰a, goon mɛnda ute kon̰a, moom mɛnda ute mɛnd goonin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jeegen maakŋ ɓei ki se ɓo utu Ꞌtɛɗn jee wɔɔyige. ");
INSERT INTO kyq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Debm jaay je bubin̰ ute kon̰ cirum maam se, naan̰ se aas te gɛn tɛɗn debm maam eyo. Ɔɔ debm jaay je goonin̰ gaaba ute goonin̰ mɛnda cirum maam se, naan̰ se aas te gɛn tɛɗn debm maam eyo. ");
INSERT INTO kyq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɔɔ debm jaay baate kuun kaagŋ jꞋansin̰ tupm ro ki ɔɔ ɔk mɛtum ey se, naan̰ se aas te gɛn tɛɗn debm maam eyo. ");
INSERT INTO kyq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Debm jaay je kaajn̰ kon̰ se, naan̰ utu an̰ kutu, ɔɔ debm jaay ut kon̰a taa maam se, naan̰ utu an̰ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Debm jaay dɔɔɗ ɔksen naase se, aan gɔɔ naan̰ dɔɔɗ ɔkum maama ɔɔ debm dɔɔɗ ɔkum maam se lɛ, aan gɔɔ naan̰ dɔɔɗ ɔk debm kɛn ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Debm kɛn jaay dɔɔɗ ɔk debm taaɗ taar teeco taar Raa ki, taa naan̰ jeelin̰ naan̰ se debm taaɗ taar teeco taar Raa ki se, naan̰ Ꞌkɔŋ bɛɗin̰a aan gɔɔ gɛn debm taaɗ taar teeco taar Raa ki se kici. Debm jaay dɔɔɗ ɔk debm kɛn tɛɗ naka ute ɗoobin̰a, taa naan̰ jeelin̰ naan̰ debm daan ki se, naan̰ se Ꞌkɔŋ bɛɗin̰a aan gɔɔ gɛn debm daan ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ꞋBooyki bɛɛ mꞋasen taaɗa: maakŋ gaange tun sɛɛm sɛɛm se, debm jaay ɛɗga maan kurlu cɔkɔ deb kalaŋ ki, taa naan̰ jeelin̰ naan̰ debm maam se, debm bin se, bɛɛ naan̰ tɛɗ se Ꞌkutn cɛr eyo, num naan̰ utu Ꞌkɔŋ bɛɗin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kɛn Isa jaay dooy jee mɛtin̰ kɛn sik‑kaar‑di aas sum se, naan̰ iin̰ ɔn̰ gɔtn ese ɔɔ ɓaa lee taaɗ taar *Raa jeege tun maakŋ gɛgɛrge tun gɛn taa naaŋ gɔtn ese ɔɔ dooyɗe. ");
INSERT INTO kyq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kaaɗ kɛn Jan‑Batist utu maakŋ daŋgay ki se, naan̰ booyga nakŋ paacn̰ kɛn *al‑Masi tɛɗ se. Ɔɔ naan̰ daŋo maakŋ jeege tun mɛtin̰ ki se jeege kandum ɔɔ ɔlɗe gɔtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Naaɗe ɓaa tɔnd mɛtin̰ ɔɔ: «Naai ɓo debm kɛn jeege iŋg aak kaama jꞋɔɔ utu aɗe ɓaa se lɔɓu, kꞋbooy nam kuuy ne?» ");
INSERT INTO kyq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isa tɛrlɗen ɔɔ: «ꞋƁaa taaɗki Jan ki nakŋ naase mala aakin̰ki ute kaamse se ɔɔ booyin̰ki ute bise se: ");
INSERT INTO kyq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","jee kaam‑tɔɔkge lɛ, kaamɗege tɔɔɗ taakga, jee cɛkɛɗge lɛ, leega talam talam, jee bikiɗge lɛ, ɔŋga lapia ɔɔ roɗege tooɗga kɔlɔn̰ kɔlɔn̰, jee duguyge lɛ, ɓɔrse booy booyo, jee ooyga kooy kic lɛ, duroga daan yoge tu ɔɔ Labar Jiga se lɛ, kꞋtaaɗin̰ga jee daayge tu. ");
INSERT INTO kyq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Maak‑raapo deb kɛn jaay ai kaamin̰ ɔn̰te ɗoobm gɛn kaal maakin̰ do maam ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kɛn jee Jan ɔlɗeno naaba jaay ɔk tɛrl ɓaa se, Isa baag taaɗn taar Jan se jee dɛnge tu ɔɔ: «Do kɔɗ‑ɓaar ki se, naase tap ɓo iŋgkiro kaakŋ naŋa? Lɔɓu iŋgkiro kaakŋ mu taa baar kɛn kuul teen̰ ɓaansin̰ kaam ara kaam ara se la? ");
INSERT INTO kyq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A‑a! Bin num naase iŋgkiro kaakŋ naŋa? Lɔɓu iŋgkiro kaakŋ gaabm kɛn tus kal aak bɛɛ se ne? Gɔtɔ. Jee lee tus kalgen aak bɛɛ gɛn koono se tiŋg maakŋ ɓee gaarin̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lɔɓu naase tap ɓo iŋgkiro kaakŋ naŋa? Naase se iŋgkiro kaakŋ debm taaɗ taar teeco taar Raa ki se la? Ɗeere, Ꞌbooyki mꞋasen taaɗa: naan̰ se debm taaɗ taar teeco taar Raa ki naɓo naan̰ magal cir debm taaɗ taar teeco taar Raa ki se daala. ");
INSERT INTO kyq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Naan̰ se ɓo debm kɛn kꞋraaŋo mɛtn taarin̰ do dɔkin̰ jꞋɔɔ: ꞋBooyo, maam mꞋai kɔl debm kaan̰ naabum naani ki, taa ai ɗaapm ɗoobi. ");
INSERT INTO kyq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ꞋBooyki bɛɛ mꞋasen taaɗa: maakŋ jeege tun mɛndge toojɗen do naaŋ ki ara bini aan do Jan‑Batist ki se, debm kɛn magal cirin̰ Jan se, gɔtɔ. Anum debm *maakŋ Gaar Raa ki se baat aan gɔɔ ɗi kic ɓo, naan̰ se ɓo magal cir Jan. ");
INSERT INTO kyq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kaaɗ kɛn Jan‑Batist lee taaɗo Taar Raa jeege tu bini aan ɓɔrse se, maakŋ Gaar Raa se jeege je kɛnd ute taa tɔɔgɔ. Ɔɔ jeegen tɛɗ naka ute taa tɔɔgɔ se, je an̰ kuun maakŋ Gaar Raa se kaam jiɗe. ");
INSERT INTO kyq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Taar kɛn jee taaɗ taar teeco taar Raa ki taaɗo ute *Ko Taar kɛn Raa ɛɗo Musa ki do dɔkin̰ se, paac, bini aan do Jan ki se, taaɗo mɛtn taar Gaar Raa kɛn utu aɗe ɓaa se. ");
INSERT INTO kyq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kɛn naase jaay Ꞌje aki booy kɔkŋ num, *Ɛli kɛn naase ɔɔki utu aɗe ɓaa se, Jan se ɓo naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Debm jaay ɔk bi booyo num, booy ɔk taar se! ");
INSERT INTO kyq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jeegen ɓɔrse tap ɓo mꞋaɗen kɔmb bɛyɛ ute naŋge? Naaɗe tec aan gɔɔ gaangen iŋg bɔɔr ki jaay taaɗ ute naapa ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naaje kꞋtuuysen kaa naɓo naase Ꞌbaate daamki. Naaje kꞋjꞋaarsen kaa yoa naɓo naase Ꞌbaate keemki. ");
INSERT INTO kyq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«Ey num kɛn Jan ɓaaɗo se, naan̰ je kɔs dɛn eyo ɔɔ aay tɔtn koojn̰ bin̰ eyo ɔɔ jeege ɗeek ɔɔ: naan̰ se debm sitan! ");
INSERT INTO kyq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kɛn *Goon Deba jaay ɓaaɗo se ɔsɔ ɔɔ aaye, naɓo jeege ɗeek ɔɔ: naan̰ se debm kaam‑kɔsɔ ɔɔ debm kaay‑koono ɔɔ ɔk mɛɗɛ ute *jee tɔkŋ miirge ɔɔ ute jee *kusin̰ge! Num jeel‑taar gɛn Raa se jꞋaak kꞋjeelin̰ naan̰ mɛt ki se ute nakgen jikilimge tɛɗa, taa naaɗe se took aalga maakɗe do Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gɔtn se Isa mooy jeegen maakŋ gɛgɛrge tun ese dɛna taa naaɗe baate Ꞌtɛrl kiŋgɗe, ey num gɔtn ese se ɓo, gɔtn naan̰ tɛɗno nakŋ‑kɔɔɓin̰ge dɛna. ");
INSERT INTO kyq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naan̰ ɗeekɗen ɔɔ: «Utu asen kɔɔn̰ aak eyo naasen jee maakŋ gɛgɛr kɛn Kɔrɔzin ki! Utu asen kɔɔn̰ aak eyo naasen jee maakŋ gɛgɛr kɛn Betsaida ki! Taa nakŋ‑kɔɔɓgen tɛɗ gɔtse ki se jaay Ꞌtɛɗoga tɛɗ maakŋ gɛgɛrge tun Tir ki ute kɛn Sidɔŋ ki num, kaaɗn do dɔkin̰ naaɗe tɛrloga maakɗe do Raa ki, naaɗe tuusn kal kɔl doa ɔɔ bɔɔy burku doɗege tu ɔɔ kɔn̰ kusin̰ɗege. ");
INSERT INTO kyq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ꞋBooyki, mꞋasen taaɗa: ɓii kɛn Raa utu Ꞌkɔjn̰ bɔɔrɔ do jeege tu se, nakŋ utu Ꞌkaan dose ki se utu Ꞌkɔɔn̰ cir kɛn aano do jeege tun Tir ki ute kɛn Sidɔŋ ki se daala. ");
INSERT INTO kyq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɔɔ naase, jee maakŋ gɛgɛr kɛn Kaparnayum ki, gɛn naase ki num, ɔɔki nookse se Ꞌkeem kaan maakŋ raa ki la? Gɔtɔ! Naase se utu aki kooy Ꞌɓaa gɔtn jee ooyga kooy tusn ro ki se. Taa nakŋ‑kɔɔɓgen tɛɗo gɔti ki se jaay ɓo tɛɗoga tɛɗ Sɔdɔm ki num, kaaɗn naane gɛgɛr Sɔdɔm se ɓɔrse kic tɛɗn utu. ");
INSERT INTO kyq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taa naan̰ se ɓo, Ꞌbooyki mꞋasen taaɗa: ɓii kɔjn̰ bɔɔr ki se, nakŋ utu Ꞌkaan dose ki se utu Ꞌcir nakŋ kɛn utu kaan do jeege tun taa naaŋ Sɔdɔm ki se.» ");
INSERT INTO kyq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kaaɗ kɛn se Isa ɗeek ɔɔ: «Bua, naai ɓo Mɛl maakŋ raa ute gɛn do naaŋa, maam mꞋtɔɔmi taa nakgen se naai ɔyin̰ga kɔyɔ jee jeel‑taarge tu ute jee mɛtɛkge tu, ɔɔ ɓɔrse naai Ꞌtaaɗga mɛtin̰a gaan sɛɛmge tu. ");
INSERT INTO kyq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɗeere, Bua, kɛse ɓo nakŋ jigan kɛn naai maaki Ꞌjen ro ki. ");
INSERT INTO kyq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Nakge paac se Bubum ɛɗumsin̰ga kaam jima. Ey num Goono se nam tap ɓo jeelin̰ eyo; kɛn jeelin̰ se Raa Bubu kalin̰ ki sum. Ɔɔ Raa Bubu se kic ey num, nam tap ɓo jeelin̰ eyo num kɛn jeelin̰ se, Goonin̰ kalin̰ ki sum ɔɔ Goonin̰ se ɓo ɓaaɗo taaɗ Raa Bubu se jeege tu taa an̰ jeele. ");
INSERT INTO kyq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ꞋƁaakiro gɔtum ki, naasen paacn̰ kɛn ɔɔrkiga kɔɔrɔ ɔɔ daamse deerse se ɔɔ maam mꞋasen kɛɗn gɔtn tɔɔl maaka. ");
INSERT INTO kyq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uunki daamum se dose ki ɔɔ Ꞌbooy uunki taaruma. Taa maam se mꞋɔɔp rom baata ɔɔ mꞋdalul. Ute maam se, naase aki kɔŋ gɔtn tɔɔl maakse. ");
INSERT INTO kyq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɗeere, taarum mꞋɔɔ aki kuun se lɛ, naan̰ ɔɔn̰ eyo, ɔɔ daamum mꞋɔɔ aki kuun se kic lɛ, naan̰ cɛɛpɛ.» ");
INSERT INTO kyq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kaaɗ kɛn se Isa deel maakŋ gɔtn gɛm ki ɓii sebit ki ute jee mɛtin̰ ki. Kɛn naaɗe deel deel se, jee mɛtin̰ ki jaay, ɓo tɔɔlɗe se baag tɛrɛcn̰ do gɛmge ɔɔ ɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kɛn *Parizige jaay aak nakŋ ese se, naaɗe ɗeek Isa ki ɔɔ: «Aaka, jee mɛti ki se tɛɗ nakŋ kɛn jꞋund te kulu gɛn tɛɗ eyo ɓii sebit ki!» ");
INSERT INTO kyq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Isa tɛrlɗen ɔɔ: «Naase Ꞌdooyin̰ki te ey la, nakŋ kɛn *Daud tɛɗ ute jeen̰ge kaaɗ kɛn naaɗe ɓo tɔɔlɗe se? ");
INSERT INTO kyq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gɔtn se Daud ɛndo maakŋ *kɔrɔr magal gɛn *Raa ki ɔɔ tɔs mappan jꞋɛɗin̰ga kɛɗ *sɛrkɛ Raa ki, ɔsɔ ɔɔ ɛɗ jeen̰ge tun mɛtin̰ ki kici. Ey num mappan se naaɗe kɔŋ kɔs eyo; kɛn Ꞌkɔs se, *jee tɛɗn sɛrkɛ Raage tu kalɗe ki sum. ");
INSERT INTO kyq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lɔɓu naase Ꞌdooyin̰ki te ey la, maakŋ *Ko Taar kɛn Raa ɛɗo Musa ki se, ɓii sebit ki se jee tɛɗ sɛrkɛ Raage tu kɛn tɛɗ naaba maakŋ kɔrɔr magal gɛn Raa ki kic ɓo uum aal te ɓii sebit se naaŋ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ꞋBooyki mꞋasen taaɗa: nam utu gɔtn ara se, magal cir *Ɓee Raa se daala. ");
INSERT INTO kyq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Taar kɛn taaɗ ɔɔ: Maam se mꞋje amki tɔjn̰ sɛrkɛ eyo, num mꞋje se naase aki Ꞌkɛɛjn̰ ɓo do naapge tu ɔɔ kɛn taar se jaay Ꞌbooy ɔkkiga mɛtin̰ num, jee se, naase aɗeki tɔkŋ mindɗe eyo, taa naaɗe se tuj te ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Taa *Goon Deba se lɛ, naan̰ ɓo Mɛl gɛn ɓii sebit.» ");
INSERT INTO kyq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isa iin̰ ɔn̰ gɔtn se ɔɔ ɓaa ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki. ");
INSERT INTO kyq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gɔtn ese, naan̰ ɔŋ gaaba kalaŋ jin̰ ooyga kooyo. Taa *Parizige je ɗoobm an kɔkŋ mind Isa se, tɔnd mɛtin̰ ɔɔ: «Ɗoobm naajege tu se, *ɓii sebit ki nam ɔk ɗoobo kɛn kɛɗn lapia debm kɔɔn̰ ki la?» ");
INSERT INTO kyq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isa tɛrlɗen ɔɔ: «Maakse ki se nam ɔk baata kalaŋ sum, ɔɔ baatin̰ se jaay ooc maakŋ gɔɔ ki ɓii sebit ki num, an̰ ɓaa kɔɔɗin̰ ey ne? ");
INSERT INTO kyq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ꞋBooyki, debkilimi se naan̰ ɔɔn̰ cir baata! Bin num ɓii sebit ki se, jeege ɔk ɗoobo gɛn tɛɗn bɛɛ jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gɔtn se Isa ɗeek gaab kɛn se ɔɔ: «ꞋSɛɛj jii!» Gɔtn se naan̰ sɛɛj jin̰a ɔɔ gɔtn ese sum ɓo jin̰ se ɔŋ lapia aan gɔɔ naapin̰ se. ");
INSERT INTO kyq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Gɔtn se Parizige teeco naatn maakŋ ɓee kɛn Yaudge lee tusn maak ki se, ɓaa tus dɔɔk taarɗe gɛn je ɗoobm an Ꞌkutn Isa. ");
INSERT INTO kyq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kɛn Isa jaay booy ɔɔ naaɗe dɔɔkga taarɗe gɛn tɔɔlin̰ se, naan̰ iin̰ ɔn̰ gɔtn ese se ɔɔ jeege dɛna ɔk mɛtin̰a ɔɔ naan̰ ɛɗ lapi jee kɔɔn̰ge tu paac. ");
INSERT INTO kyq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Num naan̰ aacɗen kaama ɔɔ jꞋɔn̰te taaɗn jeege tu an̰ jeele. ");
INSERT INTO kyq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bin ɓo taar kɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗno do dɔkin̰ se aanga ɗoobin̰ ki, kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Kɛn ara ɓo debm tɛɗn naabum kɛn maam Raa mꞋbɛɛr mꞋɔɔɗin̰o. Naan̰ ɓo debm maak‑jema ɔɔ tɔɔlum jaay maam mꞋbɛɛr mꞋɔɔɗin̰o. Maam mꞋan̰ bɔɔy Nirlum se don̰ ki ɔɔ ɗoobm maam daan ki se, naan̰ an̰ taaɗin̰ jikilimge tu paac. ");
INSERT INTO kyq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naan̰ se lɛ mooy te nam eyo ɔɔ taaɗ te makɔn̰ eyo. Taar naan̰ se jꞋan̰ booyin̰ ɗoobge tun kaam ara kaam ara se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mu taa baar kɛn ɗug ɗug se kic ɓo, naan̰ an̰ tɛrɛc eyo. Ɔɔ lɔɔmpɔn pooɗin̰ ɓaa ɓaa kooyo se kic lɛ, naan̰ an̰ tɔɔl eyo. Naan̰ tɛɗ nakge ute ɗoobin̰ se bini Ꞌcir nakgen bɛɛ ey se paac. ");
INSERT INTO kyq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ɔɔ jee do naaŋ ki se paac kɔnd doɗe do naan̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gɔtn se jeege ɔk ɓaano gɔtn Isa ki ute gaaba kalaŋ ɔk kɔɔn̰ sitan ɔɔ kɔɔn̰ sitan se tɛɗin̰ gaabm se tɛɗ kaam‑tɔɔkɔ ɔɔ ɔŋ taaɗ taar eyo. Gaabm se Isa ɛɗin̰ lapia, kaamin̰ ɔɔɗ aaka ɔɔ naan̰ baag taaɗn taara cɛy. ");
INSERT INTO kyq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɔɔ gɔtn se jee dɛnge paac aak nakŋ se, deel doɗe ɔɔ ɔkɗen taaɗ eyo, ɗeek ɔɔ: «Gaabm ese se, teeco mɛtjil Gaar *Daud ki ey la?» ");
INSERT INTO kyq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Num gaŋ kɛn *Parizige jaay booy taar se, naaɗe ɗeek ɔɔ: «Gaabm se tuur sitange ro jeege tu ute tɔɔgŋ Belzebul, naan̰ kɛn Bubm sitange se.» ");
INSERT INTO kyq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gaŋ Isa jeel maak‑saapɗe ɗey se ɗeekɗen ɔɔ: «Maakŋ taa naaŋ gaar kɛn jeen̰ge taarɗe ɔk mɛtn naap eyo ɔɔ baagga tɛɗn bɔɔrɔ ute naapa se, naaŋ se utu tɛrɛcɛ. Maakŋ gɛgɛr, ey lɛ maakŋ ɓee kɛn malin̰ge tɛɗ taara ute naapa se kic ɓo, malin̰ge Ꞌkɔŋ kiŋg eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kɛn Bubm sitange jaay tuur naapin̰ Bubm sitange se, kɛse aan gɔɔ naan̰ tɛɗ bɔɔrɔ ute ro naan̰ malin̰a ɔɔ bin se naan̰ tɔpga ron̰a. Kɛn bin num, gaarin̰ se naan̰ an̰ kɔkŋ ɔɔ ɗio? ");
INSERT INTO kyq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naase ɔɔki maam mꞋtuur sitange ute ro Belzebul se; num jee mɛtse ki se, kɛn ɛɗɗen tɔɔgɔ jaay tuur sitange se, naŋa? Bin num naaɗe mala se ɓo asen kɔjn̰ bɔɔrɔ dose ki. ");
INSERT INTO kyq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kɛn ɗeer num, maam se mꞋtuur sitange ute *Nirl Raa, bin se Ꞌjeelki, *maakŋ Gaar Raa se aanga gɔtse ki. ");
INSERT INTO kyq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kɛn nam jaay je kɛnd kɔsn ɓee debm tɔɔg se, debm se naan̰ ɔk dɔɔkin̰ga jaay ɓo, kɔsn ɓeen̰a. ");
INSERT INTO kyq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Debm jaay ute maam ey se, naan̰ se debm taamooyuma ɔɔ debm jaay noogum gɛn tusn jeege ey se, debm bin se wɔɔkɗen wɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Taa naan̰ se ɓo Ꞌbooyki mꞋasen taaɗa: *kusin̰ paacn̰ kɛn jikilimge tɛɗa ute naajn̰ kɛn naaɗe lee naaj Raa se kic ɓo, Raa aɗesin̰ kɔŋ tɔɔlɔ. Num debm jaay naaj Nirl Raa se, kusin̰ naan̰ se Raa an̰sin̰ tɔɔl eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Anum debm jaay taaɗ taar iŋg kus ro maam *Goon Deb ki kic ɓo, Raa an̰ tɔɔl kusin̰in̰a. Num gaŋ debm jaay taaɗ taar iŋg kus ro *Nirl Salal ki se, Raa an̰ tɔɔl kusin̰in̰ do naaŋ ki ara ki eyo ɔɔ ɓii kɛn kaam mɔɔtn se ey kici.» ");
INSERT INTO kyq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Isa ɗeekɗen ɔɔ: «ꞋBooyki. Kaagŋ jiga se ooj koojin̰ kic ɓo jiga, num kaagŋ kɛn kɔɔn̰ɔ se, ooj koojin̰ kic ɓo jig eyo. Taa kaaga se jꞋaak kꞋjeelin̰ ute koojin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aakumki tu wɔɔjgen ara! Naase lɛ jee bɛɛki eyo, num te ɗoobm gay jaay naase aki taaɗn nakŋ bɛɛ se? Taa taar kɛn jikilimge lee taaɗ paac se iin̰o maakɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Debm bɛɛ se, bɛɛn̰ se iin̰o maakin̰ ki ɔɔ taar kɛn teec taarin̰ ki kic ɓo bɛɛ, ɔɔ debm *kusin̰ se, kusin̰in̰ se kic ɓo iin̰o maakin̰ ki ɔɔ taar kɛn teec taarin̰ ki kic ɓo iŋg kusu. ");
INSERT INTO kyq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ꞋBooyki mꞋasen taaɗa: ɓiin Raa kɔjn̰ bɔɔr do jeege tu se, taargen jeege taaɗin̰ rɛn̰ rɛn̰ paac se, Raa utu ɓaa tɔnd mɛtɗe. ");
INSERT INTO kyq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Taa ute taar kɛn Ꞌteec taari ki se jaay ɓo ai ɗaapa ey lɛ ai kutu.» ");
INSERT INTO kyq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gaŋ gɔtn se jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kandum ute *Parizige naaɗe ɗeek Isa ki ɔɔ: «Debm dooy jeege, naaje kꞋje jꞋai kaakŋ naai ajen tɛɗn nakŋ‑kɔɔɓm kɛn jꞋan kaakŋ jeel ro ki naai se iin̰o gɔtn Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naan̰ ɗeekɗen ɔɔ: «Jee ɓɔrse jig eyo ɔɔ Ꞌtuj ɔrmɗe naan Raa ki se je kaakŋ nakŋ‑kɔɔɓɔ, naɓo nakŋ‑kɔɔɓm naaɗe an kaakŋ jeel ro ki se, tecn̰ aan gɔɔ kɛn gɛn debm taaɗ taar teeco taar Raa ki kɛn kꞋdaŋin̰ Yunus se sum. ");
INSERT INTO kyq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Aan gɔɔ Yunus tɛɗo ɓii mɔtɔ maakŋ kɛn̰j kɛn magal se, *Goon Deba se kic ɓo Ꞌtɛɗn ɓii mɔtɔ maakŋ naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɓii kɛn jaay Raa an kɔjn̰ bɔɔrɔ do jeege tu se, jeegen Ninib ki se kic utu Ꞌkɔkŋ mind jeegen duni kɛn ɓɔrse. Taa naaɗe se booy uunga taar Yunus ɔɔ tɛrlga maakɗe do Raa ki, anum Ꞌbooyki debm ara se, cir Yunus se daala. ");
INSERT INTO kyq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɓii kɛn Raa an kɔjn̰ bɔɔrɔ do jeege tu se, nɛɛlgen iin̰o kaam kaam bɔɔyɔ gɔtn duni ɗaar ro ki se utu kɔkŋ mind jeegen duni kɛn ɓɔrse se. Taa naan̰ iin̰o gɔtn dɔkɔ gɛn booy taar Gaar Salomon debm jeel‑taara se, ɔɔ Ꞌbooyki, debm jeel‑taar ara se, cir Salomon se daala.» ");
INSERT INTO kyq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tɛr Isa taaɗɗen ɔɔ: «Kɛn sitan jaay teec ɔn̰ga nam se, naan̰ ɓaa leeɗo do kɔɗ‑ɓaarge tu je gɔtn kiŋgi, naɓo naan̰ ɔŋo te eyo. ");
INSERT INTO kyq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kɛn naan̰ jaay ɔŋ te ey num, baag taaɗn ute maakin̰ ɔɔ: maam se mꞋkɔkŋ mꞋtɛrl gɔtn kɛn mꞋiin̰no ro ki. Kɛn naan̰ jaay ɔk tɛrl aan se, ɔŋ ɓee se kꞋɗaapin̰ga aak bɛɛ aac walak ɔɔ nam maak ki se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gɔtn se naan̰ ɔk tɛrlɛ ɔɔ ɓaa ɔŋo sitangen kuuy cili kɛn kusin̰ cirin̰ naan̰ se daala. Naaɗe ɓaaɗo tɛlɛ ɛnd iŋg maakŋ gaab kɛn se ɔɔ kiŋg gaabm se tɛrl ɓaa tɛɗ kusin̰ cir kɛn deet se daala. Ɗeere, naan̰ se ɓo nakŋ kɛn utu kaan do jeegen do duni kɛn ɓɔrse jig ey se.» ");
INSERT INTO kyq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kaaɗ kɛn Isa utu taaɗ taaɗ jee dɛnge tu ɓɔrt sum ɓo, gɔtn se gɛnaan̰ge ute kon̰ɗe ɗaar naatn je taaɗn te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Deb kalaŋ ɓaaɗo taaɗin̰ ɔɔ: «ꞋƁooyo! Koi ute gɛnaaige se utu naatn ɔɔ naaɗe se je ai kaaka.» ");
INSERT INTO kyq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Gaŋ Isa tɛrl deb kɛn jꞋɔlin̰o se ɔɔ: «Koyuma ute gɛnaamge se tap ɓo naŋge?» ");
INSERT INTO kyq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tɛr gɔtn se, naan̰ uun jin̰ tɔj ro jeen̰ge tun mɛtin̰ ki ɔɔ ɗeekɗen ɔɔ: «Aakki jee se ɓo koyumge ute gɛnaamge. ");
INSERT INTO kyq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taa debm jaay tɛɗ nakŋ Bubum maakŋ raa ki maakin̰ jen ro ki se, naan̰ se ɓo gɛnaam gaaba, kɛn mɛnda ɔɔ koyuma.» ");
INSERT INTO kyq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ɓii kɛn se sum ɓo, Isa teec ɔn̰ ɓea ɔɔ ɓaa iŋg taa baar kɛn Galile ki. ");
INSERT INTO kyq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɔɔ gɔtn se dɔɔl jeege dɛna tus cɛɛn̰ ki ɔlin̰ naan̰ iin̰ ook iŋg maakŋ markab ki ɔɔ jee ute dɛnɗe se ɗaar do jɛŋ baar ki. ");
INSERT INTO kyq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gɔtn se naan̰ taaɗɗenga taarge dɛna ute ɗoobm kaal naagŋ taara ɗeekɗen ɔɔ: «ꞋBooyki, deb kalaŋ tɔs kupin̰a ɔɔ teec ɓaa kɔnd buru. ");
INSERT INTO kyq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kɛn naan̰ jaay ɔnd kɔnd burin̰ se, kupm mɛtin̰ si jɛŋ ɗoob ki ɔɔ yeelge bɔɔy ɓaaɗo tuun ɔsin̰ naatn paac. ");
INSERT INTO kyq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kupm mɛtin̰ si do naaŋ kɛn gɔtin̰ ɔk koa. Kupm se naar teeco yɔkɔɗɔ taa gɔtn se, naaŋin̰ cɛɛpɛ. ");
INSERT INTO kyq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Num gaŋ kɛn kaaɗa jaay baag tɔŋgɔ se, naan̰ lawaka ɔɔ tuutu, taa gɔtn se iirin̰ ɔŋ ɛnd ɓaa te dɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kupm mɛtin̰ se si maakŋ ji kaag kɛn ɔk kɔrɔndɔ. Ji kaagŋ ute kɔrɔndɔ se teepe ɔɔ aayin̰ taara. ");
INSERT INTO kyq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kupm mɛtin̰ si do naaŋ kɛn jiga. Kupm se am tɔɔk doa ɔɔ ɔk kaama. Kɛngen mɛtin̰ge se ɔk kaama bɛɛ bɛɛ, kɛngen kuuy ɔk kaama dɛna ɔɔ kɛngen kuuy se ɔk kaama dɛn ciri.» ");
INSERT INTO kyq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gɔtn se Isa ɗeekɗen ɔɔ: «Debm jaay ɔk bi booyo num, booy ɔk taar se.» ");
INSERT INTO kyq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jee mɛtn Isa ki ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «Gɛn ɗi jaay naai Ꞌtaaɗ jeege tu ute ɗoobm kaal naagŋ taara se?» ");
INSERT INTO kyq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naan̰ tɛrlɗen ɔɔ: «Nakŋ jꞋɔyin̰ga kɔy maakŋ *Gaar Raa ki se, naase se *Raa taaɗsenga naase Ꞌjeelin̰kiga. Gaŋ jee kuuy se, nakŋ se Raa ɔŋ taaɗɗen te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Taa naan̰ se debm kɛn ɔk se jꞋan̰ kɔmb do ki Ꞌtɛɗn dɛna, num debm kɛn ɔk ey se lɛ, kɛn cɔkɔn naan̰ ɔk se kic ɓo jꞋan tɔsn naatn. ");
INSERT INTO kyq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taa naan̰ se ɓo, maam mꞋtaaɗɗen ute kaal naagŋ taara se: taa naaɗe aaka ɔɔ ɔŋ aak ɔk eyo, naaɗe booyo ɔɔ ɔŋ booy ɔk taar se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bin ɓo taar kɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗɗen do dɔkin̰ se aanga ɗoobin̰ ki kɛn ɔɔ: Taar se naase utu aki booy ute bise, naɓo aki booy kɔk eyo ɔɔ naase utu aki kaakŋ ute kaamse, naɓo aki kaakŋ kɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ɗeere, jee se maakɗe mɔŋgɔ, naaɗe tɔlga kamba biɗege tu ɔɔ turumga kaamɗege, ey num naaɗe Ꞌkɔŋ kaaka, Ꞌkɔŋ booyo, ɔɔ ute maakɗe kic naaɗe Ꞌkɔŋ booy kuun jaay aɗe tɛrl ro maam ki, ɔɔ kaaɗn naane se, maam Raa mꞋaɗen kaaja.» ");
INSERT INTO kyq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Isa taaɗ ɔɔ: «Gaŋ naase maakse raapo taa kaamsege lɛ aak kaaka ɔɔ bisege lɛ booy booyo! ");
INSERT INTO kyq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ꞋBooyki bɛɛ mꞋasen taaɗa: jee taaɗ taar teeco taar Raa ki dɛna ute jeegen tɛɗ nakŋ ute ɗoobin̰ se, je ɔɔ aɗe kaakŋ nakŋ ɓɔrse naase aakki se, naɓo ɔŋ aakin̰ te eyo, ɔɔ je ɔɔ aɗe booy nakŋ ɓɔrse naase Ꞌbooyki se, naɓo ɔŋ booyin̰ te eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Naase Ꞌbooyki mɛtn taar gɛn kaal naaŋ taar gɛn debm kɔnd buru se. ");
INSERT INTO kyq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jeegen booy mɛtn taar Gaar Raa jaay ɔŋ booy ɔkin̰ ey se, tec aan gɔɔ kupm kɛn si jɛŋ ɗoob ki se. Taar naaɗe booyga se, *Ɓubm sitange ɓaaɗo ɔɔɗɗesin̰ naatn maakɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Num jee mɛtin̰ge se tec aan gɔɔ kupm si do naaŋ kɛn maakin̰ ɔk ko se; naaɗe se kɛn booyga taar Raa se, naar ɔkin̰ maakɗe ki ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Naɓo naaɗe se ɔŋ ɔn̰ taar Raa ɔl iiri maakɗe ki eyo, taa naaɗe ɔŋ ɔn̰ te maakɗe kaam kalaŋ eyo. Kɛn dubar ɔŋɗenga ey lɛ kꞋbaagɗenga dabar gɛn taar Raa sum ɓo, naaɗe naar rɛsn ute kaal maakɗen do Raa ki se naatn. ");
INSERT INTO kyq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kupm si maakŋ ji kaag ki se tec aan gɔɔ jeegen booy taar Raa, naɓo uun nirlɗe do nakge tun do duni ki ute je maala. Nakgen se ɓo, ɓaaɗo maakŋ saapɗe ki ɔɔ gaasin̰ taar Raa se ɔŋ tɛɗ naaba maakɗe ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kupm si do naaŋ kɛn jiga se tec jeegen booy taar Raa ɔɔ took aal maakɗe do ki. Ɔɔ taar Raa se ɔlɗe naaɗe tɛɗn nakgen bɛɛ bɛɛ. Jee mɛtin̰ge se tec aan gɔɔ gɛm kɛn ɔk kaama bɛɛ bɛɛ, kɛngen mɛtin̰ge tec aan gɔɔ gɛm kɛn ɔk kaama dɛna ɔɔ kɛngen kuuy se tec aan gɔɔ gɛm kɛn ɔk kaama dɛn cir se.» ");
INSERT INTO kyq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tɛr Isa taaɗɗen ute kaal naagŋ taar kuuy daala ɔɔ: «*Maakŋ Gaar Raa se tec aan gɔɔ gaabm tɔs kupm jiga ɔɔ ɓaa kɔɔcn̰ maakŋ‑gɔtin̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Num kaaɗ kɛn jeege tooɗ tooɗ bi nɔɔr se, debm wɔɔyin̰ ɓaaɗo ɔɔc dɛrɛŋgɛlɛ maakŋ teen̰ kɛn naan̰ ɔɔcin̰ se ɔɔ naan̰ teec ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kɛn teen̰e jaay ɓaa teepe ɔɔ tɔk do se, gɔtn se dɛrɛŋgɛlɛ kic ɓaa tɔk kici. ");
INSERT INTO kyq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gɔtn se jee tɛɗn naabge se ɓaaɗo ɔŋ mɛlɗe ɔɔ ɗeekin̰ ɔɔ: ‹Mɛlje, naai ɔɔco kupm jiga ɓo maakŋ‑gɔti ki ey la? Num dɛrɛŋgɛl maak ki se tap ɓo iin̰o gay?› ");
INSERT INTO kyq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Naan̰ tɛrlɗen ɔɔ: ‹Kɛse debm wɔɔyɔ ɓo tɛɗin̰ naan̰ se.› Jee tɛɗn naabge se tɔnd mɛtn mɛlɗe ɔɔ: ‹ꞋJe dɛrɛŋgɛlge se jꞋaɗen ɓaa tɔɔɗn si naatn la?› ");
INSERT INTO kyq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mɛlɗe ɗeekɗen ɔɔ: ‹Dɛrɛŋgɛlge se ɔn̰te Ꞌtɔɔɗɗeki, ey num sɔm aki tɔɔɗn teen̰gen maak ki se, cɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ɔn̰ɗeki naaɗe teepm kalaŋ bini kaan kaaɗn kɔj ki, ɔɔ kɛn kaaɗn kɔjɔ aanga jaay ɓo maam mꞋtaaɗn jee kɔjge tu mꞋɔɔ: Deet deet se dɛrɛŋgɛlge se Ꞌdɔɔk Ꞌtusɗeki kaam kalaŋ taa aɗeki tɔɔcn̰ pooɗo. Ɔɔ teen̰e se lɛ ɔj Ꞌtusɗeki kaam kalaŋ Ꞌɓaaɗo Ꞌtɔnd ɔmbin̰ki maakŋ giijum ki.›» ");
INSERT INTO kyq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tɛr Isa taaɗɗen ute kaal naagŋ taara kuuy daala ɔɔ: «*Maakŋ Gaar Raa se tec aan gɔɔ kaam nakŋ kꞋdaŋin̰ mutard, kɛn gaaba kalaŋ uun ɔɔcin̰ maakŋ‑gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kaam nakŋ kꞋdaŋin̰ mutard se, naan̰ baat cir kaam nakgen do naaŋ ki se paac. Num kɛn jꞋɔɔcin̰ga teecga se, naan̰ teepe tɛɗ magal cir nakgen teec maakŋ ɓar ki se paac bini yeelgen kic ɓo ɓaaɗo uj kujɗege tɛlɛtin̰ge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tɛr Isa taaɗɗen ute kaal naagŋ taar kuuy daala ɔɔ: «*Maakŋ Gaar Raa se tec aan gɔɔ ɔrɔm kɛn mɛnda jaay tɔsga rujn̰ gɛmɛ ɗooc gɔrn magala ɔɔ kɛn naan̰ jaay deepin̰ga ɔɔ ɔmbin̰ga maak ki num, iin̰in̰ paac se.» ");
INSERT INTO kyq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Taargen paac se Isa dooy jee dɛnge ute kaal naagŋ taara. Ɔɔ ɗim jaay naan̰ dooyɗen ute kaal naagŋ taar ey se, gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bin ɓo taar kɛn debm taaɗ taar teeco taar Raa ki taaɗo do dɔkin̰ se aanga ɗoobin̰ ki, kɛn ɔɔ: Maam mꞋutu mꞋaɗen taaɗn ute kaal naagŋ taara, do nakge tun ko kꞋkɔyin̰a do dɔkin̰ kaaɗ kɛn Raa utu aalo kaal do naaŋa se. ");
INSERT INTO kyq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gaŋ gɔtn se Isa iin̰ ɔn̰ jee dɛnge ɔɔ ɔk tɛrl ɓaa ɓeene. Jee mɛtin̰ ki ɓaaɗo ɔŋin̰a tɔnd mɛtin̰ ɔɔ: «ꞋTaaɗ tɔɔkjen tu mɛtn taar kaal naagŋ taar ro dɛrɛŋgɛl kɛn maakŋ‑gɔt ki se?» ");
INSERT INTO kyq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isa ɗeekɗen ɔɔ: «Debm ɔɔc kupm jiga se, kɛse maam *Goon Deba. ");
INSERT INTO kyq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maakŋ‑gɔtɔ se lɛ do naaŋa ɔɔ kupm jiga se lɛ, kɛse jeegen gɛn *maakŋ Gaar Raa, dɛrɛŋgɛlɛ se lɛ taaɗn ute jee *Ɓubm sitange. ");
INSERT INTO kyq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Debm wɔɔy ɔɔco dɛrɛŋgɛlɛ se, kɛse Bubm sitange, kɔjɔ se lɛ taaɗ te ɓiin dunia an naŋa, ɔɔ jee kɔjge se lɛ *kɔɗn Raage. ");
INSERT INTO kyq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aan gɔɔ dɛrɛŋgɛlɛ se kꞋtusin̰ jaay kꞋtɔɔcin̰ pooɗn se, ɓiin dunia naŋ se kic ɓo utu tɛɗn bin kici. ");
INSERT INTO kyq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bin ɓo maam Goon Deba mꞋaɗe mꞋkɔl kɔɗumge ɔɔ jeegen jaay ɔl jeege ɔn̰ ɗoobm Raa, ɔɔ ɔlɗe tɛɗ *kusin̰a se, kɔɗn Raage aɗen tuur naatn maakŋ gaarin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kɔɗn Raage aɗen tɔsn kɔmb maakŋ baal pooɗ ki, ɔɔ gɔtn se ɓo gɔtn naaɗe tɔɔyɔ ɔɔ taan̰ naaŋɗege. ");
INSERT INTO kyq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Anum jeegen jaay tɛɗ naka ute ɗoobin̰ naan Raa ki se, naaɗe se wɔɔr aan gɔɔ kaaɗa maakŋ gaar Bubɗe ki. Debm ɔk bi booyo num booy ɔk taar se jiga!» ");
INSERT INTO kyq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«*Maakŋ Gaar Raa se tec aan gɔɔ kɔrbɔtn kꞋjꞋɔyin̰ maakŋ‑gɔt ki ɔɔ deba ɓaaɗo rɛk ɔŋin̰a ɔɔ naan̰ ɔyin̰ gɔtin̰ ki ɔɔ iin̰ ɓaa. Ute maak‑raapm naan̰ ɔk se, naan̰ ɓaa dugŋ ute nakŋ naan̰ ɔk se paac, ɔɔ ɔk tɛrl ɓaaɗo dug maakŋ‑gɔtn ese se. ");
INSERT INTO kyq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Tɛr maakŋ Gaar Raa se tec aan gɔɔ debm tɛɗn suukŋ kɛn je meeɗgen zoɗe ɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kɛn naan̰ je ɔŋ meeɗn zon̰ ɔɔn̰ se, naan̰ ɔk tɛrl ɓaa dugno ute nakŋ naan̰ ɔk se paac, ɔɔ ɓaaɗo dug meeɗn ese se.» ");
INSERT INTO kyq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Tɛr *maakŋ Gaar Raa se tec aan gɔɔ gɛnd jꞋundin̰ maakŋ baar ki ɔɔ tɔso napar kɛn̰jge dɛna. ");
INSERT INTO kyq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kɛn gɛndɛ jaay tɔso kɛn̰jge ɗooc se, naaɗe iik teecsin̰ taar ki, iŋg naaŋ ki, bɛɛr kɛngen jiga jiga ɔmb maakŋ ɛɛs ki ɔɔ kɛngen naapak ey se naaɗe sin naatn. ");
INSERT INTO kyq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bin ɓo ɓiin dunia an naŋ se tecn̰ bini. *Kɔɗn Raage utu ɓaa nigŋ jeege kaam dio: jee *kusin̰ge gɛn doɗe ɔɔ jee tɛɗ nakŋ ute ɗoobin̰ se tɛɗn gɛn doɗe kici. ");
INSERT INTO kyq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jee kusin̰ge se kɔɗn Raage aɗen si maakŋ baal pooɗ ki ɔɔ gɔtn se ɓo, gɔtn naaɗe tɔɔyɔ ɔɔ taan̰ naaŋɗege.» ");
INSERT INTO kyq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isa tɔnd mɛtn jee mɛtin̰ ki ɔɔ: «Taar se, naase Ꞌbooy ɔkkiga la?» Naaɗe tɛrlin̰ ɔɔ: «Yɛɛ, kꞋbooy jꞋɔkga.» ");
INSERT INTO kyq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Isa ɗeekɗen ɔɔ: «Debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa jaay kꞋdooyin̰ga ute nakgen gɛn maakŋ Gaar Raa se, naan̰ se tec aan gɔɔ mɛl ɓee kɛn ɔɔɗ taa kɔrbɔtin̰ num ɔŋ nakgen kiji maak ki ɔɔ kɛngen do dɔkin̰ se kici.» ");
INSERT INTO kyq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kɛn Isa jaay dooy jee mɛtin̰ ki ute kaal naagŋ taarge aas se, naan̰ iin̰ ɔn̰ gɔtn se. ");
INSERT INTO kyq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gɔtn se naan̰ iin̰ ɓaa maakŋ naaŋin̰ ki ɔɔ kɛn naan̰ aan se, baag dooy jeege maakŋ ɓee kɛn Yaudge lee tus maak ki. Ɔɔ kɛn jee se jaay booy taar kɛn naan̰ dooyɗe se, tap ɓo ɔkɗen taaɗ eyo ɗeek ɔɔ: «Jeel‑taara ute nakŋ‑kɔɔɓgen naan̰ tɛɗ se tap ɓo, ɔŋin̰o gayo? ");
INSERT INTO kyq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naan̰ ɓo goon debm tirɗn lee cɔɔc ɗaap nakge se ey la? Kon̰ ron̰ Mari ey la? Gɛnaan̰ge ɓo Jak, Yusup, Simon ɔɔ Jud se ey la? ");
INSERT INTO kyq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Gɛnaan̰gen mɛndge ɓo utu tiŋg ute naajege ara ki ey la? Anum tap ɓo tɔɔgŋ se paac naan̰ ɔŋin̰o gayo?» ");
INSERT INTO kyq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kɛse ɓo nakŋ kɛn tɛɗɗen naaɗe ɔŋ aal maakɗe don̰ ki ey se. Gɔtn se Isa ɗeekɗen ɔɔ: «Debm taaɗ taar teeco taar Raa ki se jeege paac aalin̰ maak ki; anum jee maakŋ naaŋin̰ ki ute jee maakŋ ɓeen̰ ki se ɓo aalin̰ maak ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Taa naan̰ se ɓo, gɔtn se, Isa ɔŋ tɛɗ te nakŋ‑kɔɔɓge dɛn eyo taa naaɗe baate tookŋ kaal maakɗe don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kaaɗ kɛn se, Gaar *Ɛrɔd Antipas naan̰ ɓo magal taa naaŋ Galile se, booy jeege ɔɔs kɔɔs maan Isa. ");
INSERT INTO kyq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naan̰ ɗeek jee tɛɗn naabin̰ge tu ɔɔ: «Kɛse Jan‑Batist ɓo duroga daan yoge tu! Taa naan̰ se ɓo *Raa ɛɗin̰ga tɔɔgɔ gɛn tɛɗn nakŋ‑kɔɔɓge se.» ");
INSERT INTO kyq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ꞋJeelki do dɔkin̰ se, Ɛrɔd ɔl kꞋjꞋɔk kꞋdɔɔko Jan ute zin̰ziri ɔɔ ɔl kꞋɓaa kꞋjꞋɔlin̰ maakŋ daŋgay ki, taa Ɛrɔdiad mɛnd gɛnaan̰ Pilip kɛn naan̰ ɔkin̰ mɛnda se. ");
INSERT INTO kyq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Taa Jan taaɗin̰ga taaɗ ɔɔ gɛnaai utu te kaamin̰ se, naai ɔk ɗoobm jaay an kɔkŋ mɛndin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɛrɔd se je tɔɔl Jan, naɓo ɓeer jee dɛnge tu taa jee dɛnge se, Jan se naaɗe aakin̰ aan gɔɔ debm taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɓii kalaŋ gaar Ɛrɔd tɛɗ tɛɗ maak‑raapm gɛn ɓii koojin̰ se, goon Ɛrɔdiad mɛnda se daam naan jeege tun kꞋdaŋɗeno ɓaaɗo gɔtn tɛɗn maak‑raap ki se ɔɔ daamin̰ se tɔɔl Gaar Ɛrɔd ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Gɔtn se Gaar Ɛrɔd naam taarin̰ naan jeege tu ɔɔ ɗeekin̰ ɔɔ: «Nakŋ paacn̰ naai tɔndga mɛta ro ki ɓo, maam mꞋai kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kon̰ ɔlin̰ mɛtin̰ ɔɔ ɓaa ɗeekin̰ ɔɔ: «ꞋGaaŋ ɛɗumo maakŋ supura ki ara, do Jan‑Batist.» ");
INSERT INTO kyq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Do taar kɛn se gaarge maakin̰ tuju, naɓo naan̰ lɛ naamga naam taarin̰ naan jeege tu se, naan̰ took ɔl kꞋgaaŋo do Jan jꞋɛɗ goon mɛnd ki se. ");
INSERT INTO kyq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gɔtn se naan̰ ɔl deba ɓaa maakŋ daŋgay ki ɓaa gaaŋo do Jan. ");
INSERT INTO kyq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Do Jan se kꞋgaaŋ kꞋjꞋaalin̰o maakŋ supura ki, jꞋɛɗin̰ goon mɛnd ki se, ɔɔ goon mɛnd se uun ɓaa ɛɗin̰ kon̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jee mɛtn Jan ki ɓaaɗo uun ɓaa duubin̰a, jaay ɓo ɓaa taaɗ mɛtn taar nakŋ deel se Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kɛn Isa jaay booy naan̰ se, naan̰ iin̰ ook maakŋ markab ki ɔɔ gaaŋ ɓaa do kɔɗ‑ɓaar ki kalin̰ ki. Kɛn jee dɛnge jaay booy labar se, naaɗe teeco maakŋ gɛgɛrge tun cɛɛs ki cɛɛs ki ɔɔ uun jɛn̰a aal te taa baar. ");
INSERT INTO kyq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kɛn Isa aan jaay bɔɔyo maakŋ markab ki se, naan̰ aak jee dɛnge se, naan̰ ɛɛjɗen doɗe ki ɔɔ jee kɔɔn̰ɗege se naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aan tɛgɛr se jee mɛtn Isa ki ɓaaɗo ɔŋin̰a ɔɔ ɗeekin̰ ɔɔ: «Ɓɛrɛ, kaaɗa se ɓaaga, gɔtɔ se kic lɛ daanin̰ kɔɗ‑ɓaara dɔk ute ɓea. Jee dɛnge se ɔn̰ɗe wɔɔkŋ ɓaa maakŋ naaŋge tun cɛɛs ki cɛɛs ki ɓaa dugŋ nakŋ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Gaŋ Isa tɛrlɗen ɔɔ: «Jee se ɓaa eyo, naase mala ɓo ɛɗɗeki kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gɔtn se naaɗe tɛrlin̰ ɔɔ: «Naaje se jꞋɔk ɓo mappa mii ɔɔ kɛn̰jge di sum.» ");
INSERT INTO kyq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Isa ɗeekɗen ɔɔ: «ꞋƁaanɗekiro naanum ki ara ki.» ");
INSERT INTO kyq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tɛr Isa ɗeek jee dɛnge tu se ɔɔ jꞋiŋg naaŋ ki do mu ki ɔɔ gɔtn se, naan̰ tɔs mappan mii ute kɛn̰jgen di se jin̰ ki, uun kaamin̰ raan, tɔɔm Raa, dup mappa ɔɔ ɛɗin̰ jeege tun mɛtin̰ ki ɔɔ jee mɛtin̰ ki nigin̰ jee dɛnge tu. ");
INSERT INTO kyq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Naaɗe paac ɔs dɛrɛŋ te maraadɗe ɔɔ togŋ ɔɔp se kꞋtuunin̰ se ɗooc gɔrnɔ sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jeegen ɔs paac se gaabge kalɗe ki sum ɓo ɓaa ɓaa nakŋ dupu‑mii. Mɛndge ute gaange se maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Naan̰ kɛn se, Isa naar ɗeek jeege tun mɛtin̰ ki ɔɔ kꞋjꞋook maakŋ markab ki, kꞋgaaŋ kꞋdeel kꞋɓaa naan ki jɛŋ baar kɛn kaam naane kɔr naan̰ utu wɔɔk wɔɔk jeege ɓɔrt se. ");
INSERT INTO kyq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kɛn naan̰ jaay wɔɔk jee dɛnge aas sum se, naan̰ iin̰ ɓaa ook do kɔs ki kalin̰ ki gɛn keem Raa. Kɛn kaaɗa ooc sum se, Isa ɔɔp kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Markabm jee Isage maak ki se ɓaaga daan maan ki dɔkɔ ɔɔ kɛn kuulu jaay ɔl deeb doɗe ki se, uuno maane undin̰ ro markaba ki se das das. ");
INSERT INTO kyq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kɛn gɔtɔ ɔɔpga baata aki kiip se, Isa ɓaa kɔŋ jeen̰ge se, leeɗo do maane ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɛn jee mɛtin̰ ki jaay aakin̰ naan̰ leeɗo do maane ki se, naaɗe nirlɗe teece ɗeek ɔɔ: «Kɛse nirl nam!» Kɛn naaɗe jaay ɓeere ɔkɗen sum se, gɔtn se naaɗe baag tɔɔɗn tɔɔyɔ. ");
INSERT INTO kyq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gaŋ Isa naar taaɗɗen ɔɔ: «Ɔkki maakse tɔɔgɔ. Ɔn̰te Ꞌɓeerki, kɛse maama!» ");
INSERT INTO kyq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Gɔtn se Piɛr tɛrlin̰ ɔɔ: «Mɛluma, kɛn ɗeer naai num, ɔn̰um mꞋlee do maane ki mꞋai ɓaa kɔŋɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Isa ɗeekin̰ ɔɔ: «ꞋƁaaɗo.» Piɛr iin̰ bɔɔyo maakŋ markab ki ɔɔ lee do maane ki sak Isa. ");
INSERT INTO kyq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gaŋ kɛn naan̰ jaay aak kuulu ɔl dɛna ɔɔ kɛn ɓeere ɓaa ɔkin̰ sum se, naan̰ baag bɔɔy maan. Gɔtn se naan̰ ɔɔɗ ɔɔy ɔɔ: «Mɛluma Ꞌnaakuma!» ");
INSERT INTO kyq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gaŋ Isa naar ɔl jin̰ ɔkin̰a ɗeekin̰ ɔɔ: «Gɛn ɗi maaki naaja? Kɛn bin num naai aal te maaki paac dom ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gɔtn se naaɗe di paac ook maakŋ markab ki ɔɔ kuulu ɗaara. ");
INSERT INTO kyq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jeegen paacn̰ maakŋ markab ki se ɛrg naanin̰ ki ɔɔ ɗeekin̰ ɔɔ: «Ɗeere, naai se ꞋGoon Raa!» ");
INSERT INTO kyq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kɛn Isa ute jee mɛtin̰ ki gaaŋ baar jaay aan taa naaŋ Genezarɛt ki se, naaɗe ɓaa ɗaar jɛŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jee gɔtn se ɓaa aak jeel Isa, ɔɔ taa naaŋ kɛn se paac, naaɗe taaɗ labarin̰ jeege tu ɔɔ jeege ɓaano ute jee kɔɔn̰ge paac gɔtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gɔtn se naaɗe eem nɔɔ mɛtn Isa ki ɔɔ n̰Ꞌɔn̰ɗe naaɗe kutn taa kalin̰ sum. Ɔɔ jeegen paacn̰ ut taa kalin̰ se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","*Parizige mɛtin̰ge ute jee jeel taaɗ tɔɔkŋ mɛtn Ko Taar Raagen mɛtin̰ge iin̰o Jeruzalɛm ki ɓaaɗo ɔŋ Isa ɔɔ ɗeekin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Gɛn ɗi jaay jee mɛti ki baate tookŋ gɛn tɛɗn nakŋ bubjegen do dɔkin̰ se? Taa naaɗe tug te jiɗege aan gɔɔ gɛn bubgen do dɔkin̰ ey sum ɓo ɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isa tɛrlɗen ɔɔ: «Nakŋ kɛn *Raa taaɗ ɔɔ gɛn tɛɗa tap ɓo, naase ɔn̰in̰ki ɔɔ Ꞌtɛɗki nakŋ bubsege ɓo cir se, gɛn ɗi? ");
INSERT INTO kyq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ey num Raa se taaɗga taaɗa ɔɔ: ꞋSook koi ki te bubin̰ ki ɔɔ Debm jaay naam kon̰ te bubi se jꞋan̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Num gaŋ naase se, Ꞌtaaɗki ɔɔki: ‹Debm jaay ɗeek kon̰ ki ey lɛ bubin̰ ki ɔɔ: nakŋ maam mꞋai kɛɗ jaay ai noog se, maam mꞋɛɗin̰ga *sɛrkɛ Raa ki.› ");
INSERT INTO kyq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Naase ɔɔki debm bin se kɔŋ sookŋ kon̰ ki te bubin̰ ki eyo. Bin ɓo naase Ꞌrɛsŋki ute ɗoobm taar Raa ɔɔ Ꞌtɛɗki nakŋ bubsege ɓo ciri. ");
INSERT INTO kyq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naase maa jee maakse dio! Ezayi debm taaɗ taar teeco taar Raa ki se taaɗga taaɗ taar se ro naase ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jeegen ese se tɔɔmum ute taarɗe sum, ey num maakɗe se dom ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","«Kɛn naaɗe ɓaaɗoga kɛrgŋ naanum ki gɛn keemum kic ɓo, cɛr sum, taa nakŋ kɛn naaɗe lee dooy jeege se lɛ, dooyɗe ute nakŋ kɛn jikilimge lee tɛɗ se sum.» ");
INSERT INTO kyq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gɔtn se Isa daŋo jee dɛnge ɔɔ ɗeekɗen ɔɔ: «Uɗki bia ɔɔ Ꞌbooyki bɛɛ! ");
INSERT INTO kyq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kɛn tuj debkilimi naan Raa ki se, nakŋ kɛn naan̰ ɔs jaay booy maakin̰ ki se eyo, num gaŋ nakŋ kɛn naan̰ saapin̰a ɔɔ teec jig eyo taarin̰ ki se ɓo, tujin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Gaŋ gɔtn se jee mɛtn Isa ki ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «Naai Ꞌjeele ute taar naai Ꞌtaaɗ se, Parizige maakɗe tujga ɗaamo?» ");
INSERT INTO kyq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Isa tɛrlɗen ɔɔ: «Kaaggen paacn̰ Bubum maakŋ raa ki ɓo duubɗen ey se, jꞋutu jꞋaɗen tɔɔɗn naatn. ");
INSERT INTO kyq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɔn̰ɗeki naaɗe se jee kaam‑tɔɔkge ɔɔ tɔɔɗ jee kaam‑tɔɔkge. Kɛn debm kaam‑tɔɔkɔ jaay tɔɔɗ naapin̰ se, naaɗen di paac se Ꞌsi maakŋ gɔɔ ki!» ");
INSERT INTO kyq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Gɔtn se Piɛr tɔnd mɛtn Isa ɔɔ: «ꞋTaaɗ tɔɔkjen tu mɛtn kaal naagŋ taar se.» ");
INSERT INTO kyq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isa tɛrlɗen ɔɔ: «Naase kic taar se Ꞌbooy ɔkki mɛtin̰ ey ne? ");
INSERT INTO kyq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Naase Ꞌjeelki ey la nakŋ kɛn debkilimi ɔs paac jaay bɔɔy ɓaa maakin̰ ki se, tɛɗga num, naan̰ ɓaa naamin̰ ci naagŋ boog ki naatn. ");
INSERT INTO kyq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Num gaŋ nakŋ iin̰o saapin̰ ki jaay teecga taarin̰ ki se ɓo, kɛn tuj debkilimi naan Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Saapgen jig ey paac se iin̰o maak ki. Kɛse ɓo kɛn ɔl jeege tɔɔl jeege, lee ɛɛs naapa rɛn̰ rɛn̰, lee ɛɛs mɛnd jeege ɔɔ gaabm jeege, ɓoogo, taaɗ taargen mɛt ki eyo ro jeege tu ɔɔ naaj jeege. ");
INSERT INTO kyq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kɛse ɓo nakŋ kɛn tuj debkilimi naan Raa ki. Ey num kɛn ɓaa ɓaa kɔsɔ jaay tug te ji ey kic num, an̰ kɔŋ tujn̰ naan Raa ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Isa iin̰ ɔn̰ gɔtn se, ɔɔ ɓaa taa naaŋ kɛn Tir ute gɛn Sidɔŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Gɔtn se mɛnda kalaŋ mɛnd *Kanan iŋg taa naaŋ kɛn se ɓaaɗo ɔŋ Isa ɔɔ baag tɔɔy mɛtin̰ ki ɔɔ: «Ɛɛjum dom ki Mɛluma *Goon Daud! Goonum mɛnda se ɔk kɔɔn̰ sitan ɔɔ sitan se dabarin̰ dɛna.» ");
INSERT INTO kyq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gaŋ Isa tɛrlin̰ taar eyo. Jee mɛtin̰ ki iiko cɛɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: «Mɛnd se Ꞌtuurin̰ naatn, taa naan̰ lɛ tɔɔy ɔn̰ eyo ɔɔ ɔk mɛtjege tak kaam mɔɔtn.» ");
INSERT INTO kyq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isa tɛrlɗen ɔɔ: «Maam se, Raa ɔlumo taa gaan *Israɛlge iigga kiig aan gɔɔ gaan baatge se.» ");
INSERT INTO kyq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gaŋ mɛnda se ɓaaɗo ɛrg naanin̰ ki ɔɔ ɗeekin̰ ɔɔ: «Mɛluma, Ꞌnaakuma!» ");
INSERT INTO kyq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isa tɛrlin̰ ɔɔ: «Mɛt ki eyo kɛn gaange ɔs dɛrɛŋ te ey sum ɓo kꞋtɔsn kɛɗn kɔsn se gaan bɛsge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mɛnda tɛrlin̰ ɔɔ: «Mɛluma, taari mɛt ki, naɓo gaan bɛsge kic ɓo ɔs kɔsgen si mɛtn tabil mɛlɗege tu.» ");
INSERT INTO kyq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gaŋ Isa tɛrlin̰ ɔɔ: «Mɛnda, naai se aalga maaki paac dom ki! Ɔn̰ Raa ai kɛɗn nakŋ maaki jea.» Ɔɔ kaaɗ kɛn se sum ɓo goonin̰ se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isa iin̰ gɔtn se ɔɔ ɓaa taa baar kɛn kꞋdaŋin̰ Galile. Ɔɔ gɔtn se naan̰ ook ɓaa iŋg do kɔs ki. ");
INSERT INTO kyq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dɔɔl jeege dɛna ɓaaɗo ɔŋin̰a. Naaɗe ɓaaɗo ute jee cɛkɛɗge, jee kaam‑tɔɔkge, jee ɗukurge, jee ɔŋ taaɗ taar eyo ute jee kɔɔn̰ɗegen kuuy kic dɛna. Naaɗe ɓaanɗeno naan Isa ki ɔɔ naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gɔtn se dɔɔl jeege se jaay aak nakŋ se, paac ɓo ɔkɗen taaɗ eyo, kɛn naaɗe jaay aak jee ɔŋ taaɗ taar eyo baag taaɗa, ɔɔ jee ɗukurge ɔŋ lapia, jee cɛkɛɗge baaga lee talam talam ɔɔ jee kaam‑tɔɔkge baaga kaaka. Gɔtn se naaɗe *nook Raa gɛn *Israɛl. ");
INSERT INTO kyq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isa daŋo jee mɛtin̰ ki ɔɔ ɗeekɗen ɔɔ: «Jee se maam mꞋaakɗe ɔɔ mꞋɛɛjɗenga doɗe ki, taa naaɗe tɛɗga ɓii mɔtɔ ute maama ɔɔ ɗim kɔsɗe gɔtɔga. Maam mꞋaɗe kɔn̰ naaɗe ɓaa te ɓoɗe se eyo, ey num naaɗe ɓaa baatn ɗoob ki.» ");
INSERT INTO kyq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jee mɛtin̰ ki ɗeekin̰ ɔɔ: «Do kɔɗ‑ɓaar kɛn ara jꞋakiro kɔŋ mappa gay jaay jꞋaki kɛɗn jeege tun dɛn se kɔsn dɛrɛŋ se?» ");
INSERT INTO kyq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isa tɔnd mɛtɗe ɔɔ: «Naase ɔkki mappa kando?» Naaɗe tɛrlin̰ ɔɔ: «JꞋɔk cili ute kɛn̰jge sɛɛm sɛɛm kandum.» ");
INSERT INTO kyq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gɔtn se Isa ɗeek jee dɛnge tu ɔɔ jꞋiŋg naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naan̰ tɔs mappan cili se ute kɛn̰jge se jin̰ ki, tɔɔm Raa, dup ɛɗin̰ jeege tun mɛtin̰ ki ɔɔ jee mɛtin̰ ki nigin̰ jee dɛnge tu. ");
INSERT INTO kyq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɔɔ gɔtn se jeege paac se ɔs dɛrɛŋ ute maraadɗe. Ɔɔ jee mɛtin̰ ki se tɔs togŋ ɔɔp se, ɗooc gɔrnɔ cili. ");
INSERT INTO kyq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jeegen ɔs paac se gaabge kalin̰ ki dupu‑sɔɔ ɔɔ mɛndge ute gaange maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kɛn Isa jaay ɔl jee dɛnge ɓaa sum se, naan̰ ook maakŋ markab ki ɔɔ ɔmb gaaŋ baar ɓaa taa naaŋ Magadan ki. ");
INSERT INTO kyq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parizige ute Sadusege ɓaaɗo ɔŋ Isa. Naaɗe je an̰ goom kɔk se tɔnd mɛtin̰ ɔɔ: «Naaje kꞋje ajen tɛɗn nakŋ‑kɔɔɓm kɛn jꞋan kaakŋ jeel ro ki, kɛn iin̰o maakŋ *Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naan̰ tɛrlɗen ɔɔ: «Kɛn aanga tɛgɛr kaaɗa aki kooc jaay, naase aakki maakŋ raa aac aan gɔɔ pooɗo se, naase Ꞌtaaɗki ɔɔki gɔtɔ Ꞌtɛɗn jiga. ");
INSERT INTO kyq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɔɔ tanɔɔrin̰ jaay naase aakkiga maakŋ raa se aac ilim zum zum se, naase Ꞌtaaɗki ɔɔki: ‹Jaaki se gɔtɔ tɛɗn jig eyo.› Ute nakgen tɛɗ maakŋ raa ki se ɓo naase Ꞌjeelki nakgen utu Ꞌtɛɗa. Anum gɛn ɗi jaay naase aak Ꞌjeelki nakgen aan ɓɔrse ey se? ");
INSERT INTO kyq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jee ɓɔrsen jig eyo ɔɔ Ꞌtuj ɔrmɗe naan Raa ki se. Naaɗe je ɔɔ kaakŋ nakŋ‑kɔɔɓɔ, naɓo nakŋ‑kɔɔɓm naaɗe an kaakŋ jeel ro ki se, tecn̰ aan gɔɔ kɛn gɛn Yunus se sum.» Gɔtn se tɛr Isa iin̰ ɔn̰ɗe ɔɔ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kɛn jee mɛtn Isa ki jaay gaaŋ ɔmb baar ɓaa jɛŋ kɛn kaam naane se, kɛn naaɗe ɓaa ɓaa se dirigo tɔso te mapp eyo. ");
INSERT INTO kyq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gɔtn se Isa ɗeekɗen ɔɔ: «Ɔɔɗki dose ɔɔ ɔndki kɔnd ute ɔrɔm Parizige ute gɛn Sadusege se!» ");
INSERT INTO kyq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jee mɛtin̰ ki baag taaɗn ute naapa ɔɔ: «Naan̰ taaɗ bin se taa naaje kꞋtɔskiro te mappa eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gaŋ Isa se jeelga saapɗe ɔɔ ɗeekɗen ɔɔ: «Naase aalki te maakse paac dom ki eyo, ey num gɛn ɗi jaay naase Ꞌtaaɗki ute naapa ɔɔki: ‹Naan̰ taaɗ bin se taa naaje kꞋtɔskiro te mapp ey se?› ");
INSERT INTO kyq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɓɔrse kic naase Ꞌbooy ɔkki te ey rɔk la? Naase Ꞌsaapin̰ki tu, kɛn ute mappa mii sum ɓo gaabge dupu‑mii ɔso ɔɔ mɛt kɔɔpin̰ se, naase Ꞌtɔskiro gɔrnɔ kando? ");
INSERT INTO kyq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɔɔ gɛn mappan cili jaay gaabge dupu‑sɔɔ ɔso se, mɛt kɔɔpin̰ se naase Ꞌtɔskiro gɔrnɔ kando? ");
INSERT INTO kyq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taar maam mꞋtaaɗsen mꞋɔɔ: ɔndki kɔnd ute ɔrɔm Parizige ute gɛn Sadusege se, maam mꞋje mꞋtaaɗ te mappa eyo. Anum gɛn ɗi jaay naase Ꞌbooy ɔkumki ey se?» ");
INSERT INTO kyq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gɔtn se jee mɛtn Isa ki se ɓaa booy ɔkga taar Isan taaɗɗen se taa jꞋan kɔnd ɓo ute ɔrɔm kꞋtɛɗ mappa se eyo, num jꞋan kɔnd ɓo ute dooy gɛn Parizige ute gɛn Sadusegen lee dooy jeege se. ");
INSERT INTO kyq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kɛn Isa jaay aan taa naaŋ Sezare kɛn gɛn Pilip ki se, naan̰ tɔnd mɛtn jee mɛtin̰ ki ɔɔ: «Gɛn jeege tu num, *Goon Deba se tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Naaɗe tɛrlin̰ ɔɔ: «Jee mɛtin̰ge ɔɔ naai Jan‑Batist, jee mɛtin̰ge ɔɔ naai *Ɛli, kɛngen mɛtin̰ge ɔɔ naai Jeremi ey lɛ debm taaɗ taar teeco taar Raa kɛn gam.» ");
INSERT INTO kyq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Isa tɔnd mɛtɗe ɔɔ: «Gɛn naase ki num, ɔɔki maam tap ɓo mꞋnaŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piɛr tɛrlin̰ ɔɔ: «Naai se al‑Masi, Goon Raa zɛɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gaŋ Isa ɗeekin̰ ɔɔ: «Simon goon Jan, naai maaki raapo taa taar naai taaɗ se, debkilimi ɓo taaɗio mɛtin̰ eyo, num Bubum maakŋ raa ki ɓo taaɗio taar se. ");
INSERT INTO kyq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bin num Ꞌbooyo Piɛr: roi Piɛr se je ɗeekŋ ɔɔ dɛlbɛ ɔɔ do dɛlɛb kɛn ese ɓo, maam mꞋkiin̰ *eglizuma ɔɔ yoa ute tɔɔgin̰ se kic ɓo an̰ kɔŋ tɛɗn ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Maam mꞋai kɛɗn lɛkɛrlɛgen gɛn *maakŋ Gaar Raa. Nakŋ paacn̰ jaay naai Ꞌdɔɔkin̰ga do naaŋ ki se, maakŋ raa kic ɓo Raa dɔɔkin̰ga. Ɔɔ nakŋ paacn̰ jaay naai Ꞌtuutin̰ga do naaŋ ki ara ki se, maakŋ raa ki kic ɓo Raa an̰ tuutu.» ");
INSERT INTO kyq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Gɔtn se jee mɛtin̰ ki naan̰ aacɗen kaama ɔɔ taar kɛn naan̰ ɓo al‑Masi se ɔɔ jꞋɔn̰te taaɗn nam ki. ");
INSERT INTO kyq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naan̰ kɛn se, Isa baag taaɗn jeege tun mɛtin̰ ki tal ɔɔ: «Maam se, bɛɛki num mꞋɓaa Jeruzalɛm ki, ɔɔ magal taa ɓee Yaudge, magal jee tɛɗn *sɛrkɛ Raage tu, ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, naaɗe se utu am dabar dɛna, am tɔɔlɔ ɔɔ ɓii k‑mɔtɔge tu se mꞋaɗe Ꞌdur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piɛr daŋ ɓaansin̰ cɛɛs ki ɔɔ baagin̰ mooyo ɔɔ: «Mɛluma, Raa ai bɔɔbɔ! Ɔn̰ nakŋ se Ꞌkaan doi ki eyo! Ɔn̰ Raa ai bɔɔbɔ!» ");
INSERT INTO kyq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Num gaŋ Isa tɛrl aak Piɛr ɔɔ ɗeekin̰ ɔɔ: «*Ɓubm sitange iik naatn cɛɛm ki gam naane! Taa naai se Ꞌje am gaasn naabm kɛn Raa je ɔɔ mꞋan̰ tɛɗ se ɔɔ saapm naai se gɛn Raa eyo, kɛse saapm jikilimge.» ");
INSERT INTO kyq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tɛr Isa ɗeek jeege tun mɛtin̰ ki daala ɔɔ: «Debm jaay je am daan num, Ꞌbaatn ron̰ mala, Ꞌkuun kaagŋ yon̰a jaay ɓo am daana. ");
INSERT INTO kyq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taa debm je kaajn̰ kon̰ se utu an̰ kutu naan Raa ki ɔɔ debm ut kon̰a taa maam se, utu an̰ kaaja. ");
INSERT INTO kyq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kɛn debm jaay *duni ute magalin̰ ɓo kaam jin̰ kic num, kɛn naan̰ kutn kon̰ naan Raa ki se, naan̰ an kɔŋ ɗi ro ki? Lɔ debkilimi se kon̰a se, naan̰ an̰ dugin̰ ute ɗio? ");
INSERT INTO kyq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Taa naan̰ se ɓo, *Goon Deba utu aɗe ɓaa maakŋ gaar Bubin̰ ki ute kɔɗin̰ge ɔɔ naŋa naŋa kic ɓo naan̰ an̰ kɛɗn bɛɗin̰a ro naabin̰ kɛn naan̰ tɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɗeere, Ꞌbooyki bɛɛ mꞋasen taaɗa: maakŋ jeege tun ɓɔrse utu ara se, mɛtin̰ge se kooy ey sum ɓo utu kaakŋ Goon Deba aɗe ɓaa maakŋ gaarin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kɛn ɓii mɛcɛ jaay deel se, Isa daŋ Piɛr, Jak ute gɛnaan̰ Jan. Naaɗe ɓaa do ko ki jɛrlɛ kalɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kɛn naaɗe aan se, gɔtn se Raa ooj tɛrlin̰ ron̰a naanɗe ki. Daan kaamin̰ se ɓaa tɛɗ raap aan gɔɔ kaaɗa ɔɔ kalin̰ge kic ɓaa tɛɗ raap lak lak aan gɔɔ gɔtn wɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Gɔtn se jee mɛtin̰ kɛn mɔtɔ se naar aak *Musa ɔɔ *Ɛli, teec naanɗe ki. Ɔɔ kɛn naaɗe aakɗe se, naaɗe ɗaar taaɗ taaɗ ute Isa. ");
INSERT INTO kyq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gaŋ Piɛr ɗeek Isa ki ɔɔ: «Mɛluma, bɛɛki num, jꞋaki kiŋg gɔtn ara. Maam mꞋtaal daabge mɔtɔ: kalaŋ naai ki, kalaŋ Musa ki ɔɔ kɛn kalaŋ Ɛli ki.» ");
INSERT INTO kyq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kaaɗ kɛn naan̰ utu taaɗ taaɗ ɓɔrt sum ɓo, gapar wɔɔr gɔtɔ se ɓaaɗo naar deebɗe bat. Ɔɔ maakŋ gapar ki se kꞋbooy mind deba taaɗ ɔɔ: «Naan̰ se Goonuma, Goon maak‑jema ɔɔ naan̰ tɔɔlum jaay maam mꞋbɛɛr mꞋɔɔɗin̰o, Ꞌbooy uunki taarin̰a!» ");
INSERT INTO kyq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kɛn jee mɛtin̰ ki jaay booy taar se, nirlɗe teece, ɓeere ɔkɗe se ɔɔ naaɗe taal tooco ɔɔ tɔnd naanɗege naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isa ɓaaɗo iiko cɛɛɗe ki ɔl jin̰ tuutɗe ɔɔ ɗeekɗen ɔɔ: «Iin̰ Ꞌɗaarki! Naase ɔn̰te Ꞌɓeerki!» ");
INSERT INTO kyq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kɛn jee mɛtin̰ ki jaay uun kaamɗe aak se, ɔɔp Isa kalin̰ ki sum, nam kuuy gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kaaɗ kɛn naaɗe utu bɔɔyɔ bɔɔy kon se, Isa dɛjɗe ɔɔ: «Ɓɛrɛ, nakŋ naase aakkiro se, ɔn̰te Ꞌtaaɗki nam ki, bini *Goon Deba se aɗe dur daan yoge tu jaayo.» ");
INSERT INTO kyq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gaŋ jee mɛtn Isa ki tɔnd mɛtin̰ ɔɔ: «Gɛn ɗi jaay jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage taaɗ ɔɔ Ɛli aɗe ɓaa jaay *al‑Masi aɗe ɓaa se?» ");
INSERT INTO kyq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naan̰ tɛrlɗen ɔɔ: «Ɗeere, Ɛli utu aɗe ɓaao ɔɔ naan̰ ɓo utu tɔnd ɗaapm nakge paac ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Num Ꞌbooyki mꞋasen taaɗa: Ɛli se lɛ ɓaaɗoga, naɓo jeege jeelin̰ te eyo, tɛɗin̰ga nakŋ maakɗe je don̰ ki. Ɔɔ bin ɓo *Goon Deba kic naaɗe utu an̰ dabar bini.» ");
INSERT INTO kyq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Do taar kɛn se jaay jee mɛtin̰ ki se ɓaa booy ɔkga taar Isa taaɗɗen se, naan̰ taaɗ ute Jan‑Batist. ");
INSERT INTO kyq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kɛn Isa ute jee mɛtin̰ ki jaay aan cɛɛ jee dɛnge tu se, gaaba kalaŋ ɓaaɗo ɛrg naan Isa ki, ");
INSERT INTO kyq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ɔɔ ɗeekin̰ ɔɔ: «Mɛluma, goonum se ɛɛjin̰ don̰ ki. Naan̰ se ɔk kɔɔn̰ puputu ɔɔ lee dabarin̰ dɛna, daayum ɔlin̰ naan̰ tooc maakŋ pooɗ ki ey lɛ maakŋ maane ki. ");
INSERT INTO kyq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Maam mꞋɓaansin̰o gɔtn jeege tun mɛti ki, naɓo naaɗe ɔŋ ɛɗin̰o te lapi eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isa ɛɛp taarin̰a ɔɔ ɗeek ɔɔ: «Jee do naaŋ kɛn ɓɔrse se, jee naaj taarge ɔɔ jee bɛɛki eyo. Maam tap ɓo mꞋkiŋg ute naase bini nuŋ ki? Maam tap ɓo mꞋasen sɛrkŋ bini nuŋ ki? Goono se ɔk Ꞌɓaamsin̰kiro tu ara!» ");
INSERT INTO kyq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isa aac kaama sitan kɛn tɛɗ goono puputu se ɔɔ n̰Ꞌteec naatn ro goon ki se. Ɔɔ kaaɗ kɛn se sum ɓo goono se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tɛr jee mɛtn Isa ki daŋ ɓaansin̰ cɛɛs ki ɔɔ tɔnd mɛtin̰ ɔɔ: «Gɛn ɗi jaay ɓo sitan se naaje kꞋjꞋɔŋ kꞋtuurin̰ te ey se?» ");
INSERT INTO kyq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isa tɛrlɗen ɔɔ: «Taa naase kaal maakse baata. ꞋBooyki bɛɛ mꞋasen taaɗa: kɛn naase jaay ɔkki kaal maakŋ do Raa ki magal aan gɔɔ kaam koobi se num, naase aki ɗeekŋ ko kɛn ese se ɔɔ iin̰ ɗɛɛtɛ ɔɔ ko se kiin̰ ɗɛɛtɛ. Nakŋ jaay asen cir se gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tɛr Isa ɗeekɗen ɔɔ: «Napar sitan bin se kɛn naase jaay ɔŋ uunki te *siam gɛn tɔnd mɛtn Raa ey num, naan̰ se Ꞌkɔŋ teec eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ɓii kalaŋ jee mɛtn Isa ki tus paac taa naaŋ kɛn Galile ki ɔɔ gɔtn se, Isa ɗeekɗen ɔɔ: «*Goon Deba se jꞋutu jꞋan̰ kɔkŋ kɔl ji jeege tu. ");
INSERT INTO kyq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Naaɗe utu an̰ tɔɔlɔ ɔɔ ɓii k‑mɔtɔge tu se naan̰ aɗe dur daan yoge tu.» Kɛn jee mɛtin̰ ki jaay booy taar se, naaɗe roɗe oojɗe walak. ");
INSERT INTO kyq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kɛn Isa ute jee mɛtin̰ ki jaay aan maakŋ gɛgɛr kɛn Kaparnayum ki se, jeegen lee tɔk gursn miir gɛn Ɓee Raa se ɓaaɗo ɔŋ Piɛr ɔɔ tɔnd mɛtin̰ ɔɔ: «Mɛlse tap ɓo, lee ɔg miir taa gɛn Ɓee Raa lɔɓu gɔtɔ?» ");
INSERT INTO kyq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛr tɛrlin̰ ɔɔ: «Yɛɛ naan̰ ɔgɔ.» Kɛn jaay Piɛr ɓaa ɓeen se, Isa ɓo uun taara deete ɔɔ ɗeekin̰ ɔɔ: «Gɛn naai ki num saap ɔɔ ɗi, Simon Piɛr: gaarin̰gen do naaŋ ki se, kɛn lee ɔgɗen miiri tap ɓo naŋge? Jee maakŋ naaŋɗege tu lɔɓu mɛrtge?» ");
INSERT INTO kyq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piɛr tɛrlin̰ ɔɔ: «Mɛrtge.» Isa kic tɛrlin̰ ɔɔ: «Kɛn ɗeer num, gaan naaŋge se lee ɔg miiri eyo! ");
INSERT INTO kyq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naɓo, naaje se kꞋje jee se maakɗe tuj eyo, taa naan̰ se ɓo Piɛr, Ꞌɓaa taa baar ki und kuuyi maan, ɔɔ kɛn̰j kɛn naai an̰ kɔkŋ deet deet se, ɛɛpin̰ taarin̰a ɔɔ kɔŋ tamma kalaŋ aas kɔgŋ miir jeege dio. Uunin̰a ɔɔ Ꞌɓaa ɛɗɗen taa tɔɔl bɛɗ gɛn miir maama ɔɔ gɛn naai.» ");
INSERT INTO kyq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kaaɗ kɛn se jee mɛtn Isa ki ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «Naŋa ɓo Ꞌtɛɗn magal cir jeege paac *maakŋ Gaar Raa ki?» ");
INSERT INTO kyq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Isa daŋo goon cɔkɔ ɓaaɗo ɗaar daanɗe ki, ");
INSERT INTO kyq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɔɔ ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: kɛn naase Ꞌtɛrlki te maakse te eyo ɔɔ Ꞌtɛɗki te rose aan gɔɔ gɛn gaangen sɛɛm ey se, naase aki kɔŋ kɛnd maakŋ Gaar Raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taa naan̰ se ɓo debm jaay ɔɔp ron̰ baat aan gɔɔ goon cɔkɔn ese se, naan̰ ɓo debm Ꞌtɛɗn magal cir jeege paac maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Taa maam jaay, debm ɔkga goon cɔkɔ jiga aan gɔɔ goon ese se, kɛse aan gɔɔ naan̰ ɔkum maam mala.» ");
INSERT INTO kyq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Gaŋ maakŋ gaange tun sɛɛm kɛn aalga kaal maakɗe dom ki se jaay, nam ɔlga deb kalaŋ maakŋ kusin̰ ki se, debm kɛn ɔlin̰ se ɔn̰ bɛɛki num, jꞋuuno ko tootn magala ɔɔ kꞋdɔɔkin̰ mindin̰ ki ɔɔ jꞋuun jꞋundin̰ maakŋ baar kɛn jɛrlɛ. ");
INSERT INTO kyq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jeegen do duni ki se utu aɗen tɛɗn ɔɔn̰ aak eyo taa nakgen kɛn utu kɔl jeege maakŋ kusin̰ ki se utu Ꞌtɛɗn dɛn aak eyo. Ɗeere, nakgen bin se utu tap, naɓo ɔɔn̰ɔ deb kɛn Ꞌkɔl jeege maakŋ kusin̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kɛn jii ey lɛ jɛi jaay ɓo ai kɔl maakŋ kusin̰ ki num, gaaŋ siɗen dɔkɔ. Kɛn ɔɔpi jii kalaŋ ey lɛ jɛi kalaŋ jaay kɔŋ kaaja se, bɛɛ cir kɛn Ꞌkiŋg te jige dio ey lɛ jɛige dio ɔɔ ɓaa maakŋ pooɗ kɛn gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kɛn kaami jaay ɓo ai kɔli maakŋ kusin̰ ki num, kaami se ɔɔɗ und naata. Kɛn ɔɔpi kaami kalaŋ jaay kɔŋ *kaajn̰ gɛn daayum se, bɛɛ cir kɛn Ꞌkiŋg te kaamige dio ɔɔ ɓaa maakŋ pooɗ kɛn gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ɔndki kɔndɔ gaan sɛɛmgen ese se, nam kalaŋ kic ɓo ɔn̰te aakin̰ki aan gɔɔ nakŋ cɛrɛ! Anum Ꞌbooyki mꞋasen taaɗa: kɔɗɗegen iŋg cɛɛ Bubum ki maakŋ raa ki se, daayum utu aakɗen doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Taa maam *Goon Deba mꞋɓaaɗo se taa kaajn̰ jeegen iigga kiigi. ");
INSERT INTO kyq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Naase tap ɓo Ꞌsaapin̰ki ɔɔki ɗi? Kɛn deba jaay ɔk baatge kaaru ɔɔ maakɗe ki se kɛn kalaŋ iigga num, baatgen sik‑jɛrnaŋ‑kaar‑jɛrnaŋ kuuy se naan̰ aɗe kɔn̰ maakŋ ko ki taa Ꞌɓaa je kɛn kalaŋ iig kiig se ey la? ");
INSERT INTO kyq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ꞋBooyki bɛɛ mꞋasen taaɗa: kɛn naan̰ jaay je ɔŋin̰ga se, naan̰ maakin̰ raapm dɛna do baat kɛn se cir do kɛnge tun si‑jɛrnaŋ‑kaar‑jɛrnaŋ kɛn iig te ey se. ");
INSERT INTO kyq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Taa naan̰ se ɓo Bubsen maakŋ raa ki kic num, je ɔɔ maakŋ gaange tun sɛɛm se, nam kalaŋ tap ɓo kut eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Kɛn gɛnaai jaay tɛɗiga *kusin̰a num, Ꞌɓaa ɔŋin̰ kali ki ɔɔ Ꞌmooyin̰a. Kɛn naan̰ jaay booy uunga taari num, kɛse naai Ꞌɗaapin̰ga. ");
INSERT INTO kyq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɛn naan̰ jaay baate booy kuun taari se, ɔk Ꞌtɛrl Ꞌɓaa ɔŋo deb kalaŋ ey lɛ jeege dio taa naan jeege tun dio ey lɛ mɔtɔ se ɓo, ai tɛɗn saaɗige ɔɔ ute naaɗe se ɓo, naase aki naŋ taarse. ");
INSERT INTO kyq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɛn jee se jaay naan̰ baate booyɗe taarɗe kic num, Ꞌɓaa Ꞌtaaɗn mɛtn taar se *egliz ki. Ɔɔ kɛn jee egliz ki ɓaa ɔŋin̰ jaay naan̰ baate booy kuun taarɗe daal num, naai aakin̰ aan gɔɔ debm jeel *Raa mal eyo ey lɛ aan gɔɔ *debm tɔkŋ miiri. ");
INSERT INTO kyq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ꞋBooyki bɛɛ mꞋasen taaɗa: nakŋ paacn̰ jaay naase Ꞌdɔɔkin̰kiga do naaŋ ki se, maakŋ raa kic ɓo Raa an̰ dɔɔkɔ. Ɔɔ nakŋ paacn̰ jaay naase Ꞌtuutin̰ga do naaŋ ki ara ki se, maakŋ raa ki kic ɓo Raa an̰ tuutu. ");
INSERT INTO kyq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ꞋBooyki mꞋasen taaɗn daala: do naaŋ ki ara jaay jeege dio maakse ki taarɗe kalaŋ ɔɔ tɔnd mɛtn ɗim se, nakŋ naaɗe je se, Bubum kɛn maakŋ raa ki aɗesin̰ kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ɗeere, taa gɔtn jaay jeege dio ey lɛ mɔtɔ jaay tus ute ro maam se, maam mꞋutu daanɗe ki.» ");
INSERT INTO kyq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Gaŋ Piɛr ɓaaɗo ɔŋ Isa ɔɔ tɔnd mɛtin̰ ɔɔ: «Mɛluma, kɛn gɛnaam jaay tɛɗumga kusin̰a num, mꞋan̰ tɛɗn kalɗɛ mɛt kando? Bin num mꞋan̰ tɛɗn ɗɔɔl cili ne?» ");
INSERT INTO kyq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isa tɛrlin̰ ɔɔ: «Maam mꞋɗeeki mꞋɔɔ: ɗɔɔl cili sum eyo, num sik‑cili‑cili mɛt cili.» ");
INSERT INTO kyq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Taa naan̰ se ɓo Ꞌbooyki mꞋɔɔ: *maakŋ Gaar Raa se tec aan gɔɔ gaar kɛn tus jee tɛɗn naabin̰ge taa kaakŋ sɛɛn̰ do jeege tu. ");
INSERT INTO kyq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kɛn naan̰ utu baag baag kaakŋ gursin̰ sum ɓo, jꞋɔk kꞋɓaano ute gaaba kalaŋ kɛn an̰ kɔgŋ gurs dupu‑kaar kando kando. ");
INSERT INTO kyq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aan gɔɔ gaabm se ɔk ɗim naan̰ an kɔgŋ sɛɛn̰ gɔtɔ ɗey se, gaarge ɗeek ɔɔ: ‹ꞋƁaa Ꞌdugin̰ki naan̰a, mɛndin̰a, gɛnin̰ge ɔɔ nakŋ naan̰ ɔk paac se, kꞋdugin̰a ɔɔ gursin̰ se kꞋɓaaɗo kꞋjꞋɔgum sɛɛma.› ");
INSERT INTO kyq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Gɔtn se gaabm ese se ɓaaɗo ooc mɛtn jɛn̰ ki ɔɔ ɛrg naan mɛlin̰ ki ɔɔ ɗeekin̰ ɔɔ: ‹Aay kaami, uɗum bia, sɛɛi se paac mꞋutu mꞋaisin̰ kɔgɔ!› ");
INSERT INTO kyq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gɔtn se mɛlin̰ ɛɛjin̰ don̰ ki, ɔɔ tɔɔl te sɛɛn̰ se naata ɔɔ ɔn̰in̰ iin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kɛn gaabm ese jaay teec ɓaa ɓaa se, ɓaa dɔɔɗ ute mɛɗin̰ kalaŋ kɛn naaɗe tɛɗ naaba kalaŋ. Debm se ɔkoga kɔkŋ sɛɛn̰ tamma kaaru. Gɔtn se naan̰ ɔkin̰ bɔrlin̰ ki ai karat ɔɔ ɗeekin̰ ɔɔ: ‹Ɔgumo sɛɛma!› ");
INSERT INTO kyq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gɔtn se mɛɗin̰ se ooc mɛtn jɛn̰ ki ɔɔ eemin̰ nɔɔ mɛtin̰ ki ɔɔ: ‹Aay kaami, uɗum bia, sɛɛi se maam mꞋutu mꞋaisin̰ kɔgɔ!› ");
INSERT INTO kyq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gaabm se baate, ɔk mɛɗin̰ se ɓaa ɔlin̰ daŋgay ki kɔr naan̰ an̰ kɔgŋ naŋ sɛɛn̰ se. ");
INSERT INTO kyq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mɛɗɗegen kꞋtɛɗ naaba kalaŋ jaay aak nakŋ kɛn gaabm ese tɛɗ se, naaɗe paac maakɗe tuju ɔɔ ɓaa taaɗ taar se mɛlɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Gɔtn se mɛlɗe se ɔl kꞋdaŋo gaabm ese se ɔɔ ɗeekin̰ ɔɔ: ‹Naai se debm jig eyo! Ey num naai eemum nɔɔ sum ɓo sɛɛige se, maam mꞋtɔɔlin̰sin̰o naatn. ");
INSERT INTO kyq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aan gɔɔ maam mꞋɛɛji doi ki se, naai kic ɛɛj do mɛɗi ki ey la!› ");
INSERT INTO kyq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kɛn mɛlin̰ jaay maakin̰ tuj se, gaabm se naan̰ ɔk ɔlin̰ daŋgay ki taa jꞋan̰ ɓaa dabara bini kɔgŋ naŋ sɛɛn̰ se maak ki.» ");
INSERT INTO kyq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gɔtn se Isa ɗeekɗen ɔɔ: «Kɛn naase jaay debm ɔŋ tɛɗ te kalɗɛ gɛnaan̰ ki te maakin̰ paac ey se, Bubum maakŋ raa ki kic an̰ tɛɗn kalɗɛ ey bin kici.» ");
INSERT INTO kyq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kɛn Isa taaɗ naŋ taarin̰ se, naan̰ iin̰ ɔn̰ Galile ɔɔ ɓaa taa naaŋ Jude ki, kaam aak jɛŋ ool kꞋdaŋin̰ Jordan kɛn kaam naane. ");
INSERT INTO kyq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dɔɔl jeege dɛna ɔk mɛtin̰a ɔɔ gɔtn se naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Parizige mɛtin̰ge se ɓaaɗo ɔŋ Isa je ɗoobm an̰ goom kɔk se, naaɗe tɔnd mɛtin̰ ɔɔ: «Deba se, do taar ɗim kɛn gay kic ɓo, naan̰ ɔk ɗoobo kɛn Ꞌpiir mɛndin̰ la?» ");
INSERT INTO kyq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isa tɛrlɗen ɔɔ: «Naase Ꞌdooyin̰ki te ey la, taar kꞋraaŋin̰o maakŋ Kitap ki se? Do kupm mɛt ki se, *Raa Mɛl Kaala aalo gaaba ute mɛnda, ");
INSERT INTO kyq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ɔɔ ɗeek ɔɔ: Taa naan̰ se ɓo gaaba teecn̰ kɔn̰ kon̰ te bubin̰a, ɓaa tum te mɛndin̰a, ɔɔ naaɗen di se tum tɛɗga daa ro kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bin se naaɗe se tɛɗga aan gɔɔ jee di eyo, num aan gɔɔ deb kalaŋ sum. Nakŋ jaay Raa dɔɔkin̰ga dɔɔk se, debkilimi ɔn̰te tuutin̰a!» ");
INSERT INTO kyq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parizige tɔnd mɛtin̰ ɔɔ: «Gɛn ɗi jaay *Musa ɗeek ɔɔ gaaba raaŋ maktubm gɛn piiri, kɛɗn mɛndin̰ ki jaay an̰ piir se?» ");
INSERT INTO kyq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isa tɛrlɗen ɔɔ: «Kɛse taa do‑mɔŋgse ɓo, Musa ɔɔɗsen ɗoobm piir mɛndsege. Ey num do kupm mɛt ki se bin eyo. ");
INSERT INTO kyq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ꞋBooyki mꞋasen taaɗa: nam jaay Ꞌpiir mɛndin̰ se, kɛn mɛndin̰ ɛɛs kɛɛs gaabge jaayo, ɔɔ kɛn naan̰ jaay ɔkga mɛnd kuuy se, naan̰ se aan gɔɔ debm ɛɛs mɛnd nam.» ");
INSERT INTO kyq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jee mɛtn Isa ki ɗeekin̰ ɔɔ: «Kɛn daan gaaba ute mɛnda jaay kiŋgɗe bin num, naan̰ se kɛn debm ɔk te mɛnda ey kic num bɛɛ kaca!» ");
INSERT INTO kyq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isa tɛrlɗen ɔɔ: «Jeege paac se kɔŋ booy kɔkŋ taar se eyo. Jeegen an̰ booy kɔk se, jeegen kɛn Raa ɛɗɗenga jeele gɛn booy kɔkŋ mɛtn taar se jaayo. ");
INSERT INTO kyq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ɗeere, ɗoobm jaay gaasn gaabge gɛn tɔkŋ mɛndge se dɛna: jee mɛtin̰ge se jꞋoojɗe ɓo roɗe gɔtɔ, jee mɛtin̰ge se lɛ jikilimge ɓo tɛɗɗe roɗe tɛɗ gɔtɔ, ɔɔ kɛngen mɛtin̰ge se taa taar Raa ɓo naaɗe baate tɔkŋ mɛndge. Debm kɔŋ booy kɔkŋ taar se num, ɔn̰in̰ an̰ booy kɔkɔ!» ");
INSERT INTO kyq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gɔtn se jeege ɓaano ute gaangen sɛɛmɛ gɔtn Isa ki taa naan̰ aɗen tɔnd jin̰ doɗe ki ɔɔ tɔnd mɛtn Raa taa naaɗe, naɓo jee mɛtin̰ ki uunɗe kaamɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gaŋ Isa ɗeekɗen ɔɔ: «Ɔn̰ɗeki gaangen sɛɛm se aɗe ɓaa gɔtum ki, ɔn̰te Ꞌgaasɗeki, taa *maakŋ Gaar Raa se gɛn jeegen tec aan gɔɔ gaangen sɛɛm se.» ");
INSERT INTO kyq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kɛn naan̰ jaay tɔnd jin̰ doɗege tu aas se, naan̰ iin̰ ɔn̰ gɔtn se, ɔɔ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gaŋ gaaba kalaŋ ɓaaɗo ɔŋ Isa ɔɔ ɗeekin̰ ɔɔ: «Debm dooy jeege, bɛɛ maam mꞋtɛɗ jaay am kɛɗn *kaajn̰ gɛn daayum se, kɛn gay?» ");
INSERT INTO kyq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isa tɛrlin̰ ɔɔ: «Gɛn ɗi Ꞌtɔnd mɛtum ro nak kɛn bɛɛ se? Kɛn bɛɛ se, Raa kalin̰ ki sum. Kɛn naai jaay Ꞌje Ꞌkɔŋ kaajn̰ gɛn daayum num, Ꞌtɛɗn nakŋ kɛn Raa taaɗ ɔɔ gɛn tɛɗa se.» ");
INSERT INTO kyq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gaaba se ɗeekin̰ ɔɔ: «Kɛn gayo?» Isa tɛrlin̰ ɔɔ: «Ɔn̰te Ꞌtɔɔl nam, ɔn̰te Ꞌkɛɛsn mɛnd nam, ɔn̰te Ꞌkɛɛsn gaabm nam, ɔn̰te Ꞌɓoogo, ɔn̰te Ꞌtɔkŋ taar‑kɔɔɓɔ do nam ki, ");
INSERT INTO kyq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ꞌsook koi ki te bubi kiɔɔ Ꞌje naapi aan gɔɔ ro naai mala.» ");
INSERT INTO kyq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gaaba se tɛrlin̰ ɔɔ: «Nakgen se maam mꞋlee mꞋtɛɗin̰o tɛɗ paac tap, anum ɔɔpum kɛn gay daala?» ");
INSERT INTO kyq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isa ɗeekin̰ ɔɔ: «Kɛn naai jaay je tɛɗn debm bɛɛ mala mala naan Raa ki num, maali naai ɔk paac se, Ꞌɓaa Ꞌdugin̰ naatn ɔɔ gursin̰ se Ꞌnigin̰ jee daayge tu. Kɛn tɛɗin̰ga bin se, ai tooɗn kɔrbɔtɔ maakŋ raa ki. Ɔɔ naai lɛ, Ꞌɓaaɗo Ꞌdaanuma.» ");
INSERT INTO kyq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kɛn goon kɔɗɔ se jaay booy taar kɛn Isa taaɗin̰ se, ɔk tɛrl ɓaa ɓaa se maakin̰ tuj kasak kasak, taa naan̰ debm nak dɛna. ");
INSERT INTO kyq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: debm nak dɛna se kɛndin̰ kɔɔn̰ɔ *maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","MꞋɗeek mꞋɗɔɔlsen daala: kɛn gin̰ji jaay deel ute ɓee luppara se ɔɔn̰ɔ; naɓo debm nak dɛna jaay Ꞌkɛnd maakŋ Gaar Raa ki se, ɔɔn̰ cir naan̰ se daala!» ");
INSERT INTO kyq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kɛn jee mɛtin̰ ki jaay booy taar se, ɔkɗen taaɗ eyo ɗeek ɔɔ: «Kɛn bin num naŋa jaay Ꞌkɔŋ kaaja?» ");
INSERT INTO kyq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isa uun kaamin̰ aakɗe ɔɔ ɗeekɗen ɔɔ: «Gɛn jikilimge tu sum num nakŋ se ɔɔn̰ɔ, num Raa ki se, ne ɗim ɔɔn̰in̰ gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gɔtn se Piɛr ɗeek Isa ki ɔɔ: «ꞋBooyo, naaje se kꞋjꞋɔn̰oga nakge paac taa jꞋai daan naai, num naaje tap ɓo jꞋkɔŋ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: kaaɗ kɛn Raa utu tɛɗn nakge paac Ꞌtɛɗn kiji se, maam *Goon Deba mꞋutu mꞋkiŋg do kaag do kɛn iin̰o gɔtn Raa ki ɔɔ naasen sik‑kaar‑di kɛn lee daanumkiro se, utu aki kiŋg do kaag do kɛn sik‑kaar‑dio gɛn kɔjn̰ bɔɔrɔ do taa ɓee gaan *Israɛlge tun sik‑kaar‑di se. ");
INSERT INTO kyq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɔɔ debm jaay ɔn̰o ɓeen̰ge, gɛnaan̰gen gaabge ute kɛngen mɛndge, bubin̰a, kon̰a, gɛnin̰ge ey lɛ maakŋ‑gɔtin̰ge taa maam se, nakgen se paac se naan̰ utu aɗen kɔŋ dɛn cir kɛn naan̰ ɔn̰o, ɔɔ Ꞌkɔŋ kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Num maakŋ jeege tun ɓɔrse naan ki se, dɛnin̰ utu kɔɔpm mɔɔtn. Ɔɔ maakŋ jeege tun ɓɔrse mɔɔtn se, dɛnin̰ utu tɛɗn jee naan ki.» ");
INSERT INTO kyq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tɛr Isa ɗeek daala ɔɔ: «*Maakŋ Gaar Raa se tec aan gɔɔ mɛl ɓee kɛn iin̰ tanɔɔrin̰ nɔɔrin̰ je jeege taa aɗen kɔl ɓaa tɛɗn naaba maakŋ jinɛnin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mɛl jinɛnɛ se taaɗ dɔɔk taarin̰ ute jee tɛɗn naabge se kɛn naaɗe tɛɗ naaba lɛkga se, deba kic ɓo naan̰ an̰ kɛɗn tamma kalaŋ kalaŋ. Bin jaay ɓo naan̰ ɔlɗen maakŋ jinɛnin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kɛn aan kaaɗn mɛs ki se, naan̰ teeco ɓeen̰ ki ɔŋ jeege iŋg kiŋg cɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gɔtn se naan̰ ɗeekɗen ɔɔ: ‹Naase kic Ꞌɓaa Ꞌtɛɗki naaba maakŋ jinɛnum ki ɔɔ maam mꞋasen kɔgŋ te ɗoobin̰a.› ");
INSERT INTO kyq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gɔtn se jee tɛɗn naabge se iin̰ ɓaa maakŋ jinɛnɛ ki. Kɛn aan katar ki tir se, tɛr naan̰ teeco ɔɔ katar do tɛgɛr ki kic naan̰ teeco. Ɔɔ kɛn naan̰ teeco jaay ɔŋ jeegen kuuy iŋg kiŋg cɛrɛ daal se, naan̰ ɔlɗen ɔɔ kꞋɓaa tɛɗn naaba maakŋ jinɛnin̰ ki kici. ");
INSERT INTO kyq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kɛn aan tɛgɛr se, naan̰ teeco daala ɔɔ ɔŋ jeegen iŋg kiŋg cɛr se, naan̰ ɗeekɗen ɔɔ: ‹Gɛn ɗi jaay naase iŋg Ꞌlɛkki cɛr se?› ");
INSERT INTO kyq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Naaɗe tɛrlin̰ ɔɔ: ‹Nam ajen kuun gɛn naaba ɓo gɔtɔ.› Naan̰ ɗeekɗen ɔɔ: ‹Naase kic Ꞌɓaa Ꞌtɛɗki naaba maakŋ jinɛnum ki.› ");
INSERT INTO kyq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kɛn aan tɛgɛr kaaɗa ɓaa ɓaa kooco se, mɛl jinɛnɛ se ɗeek debm tɛɗn naabin̰ ki ɔɔ: ‹ꞋƁaa Ꞌdaŋo jee tɛɗn naabge se paac ɔɔ naŋa naŋa kic ɓo ɔgin̰ nakin̰ nakin̰a. ꞋBaag do jeege tun kaam mɔɔtn bini Ꞌkaan do jeege tun kɛn ɓaaɗo deete.› ");
INSERT INTO kyq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gɔtn se jeegen jaay baag tɛɗn naaba kaam mɔɔtn ɗɛs se, ɓaaɗo ɔɔ naŋa kic ɓo jꞋɛɗin̰ tamma kalaŋ kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kɛn gɛn kɔgŋ jeegen baag naaba deet se, naaɗe saap ɔɔ kaaɗn naane, naaɗe Ꞌkɔŋ cir naapɗege. Naɓo deba kic ɓo ɔŋ tamma kalaŋ kalaŋ sum. ");
INSERT INTO kyq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kɛn naaɗe jaay aak bɛɗɗen jꞋɛɗɗen se, maakɗe taarɗe mooy naaŋ ki dir dir do mɛl ɓee ki se. ");
INSERT INTO kyq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ɔɔ ɗeekin̰ ɔɔ: ‹Jee se ɓaaɗo kaam mɔɔtn ɔɔ naaba kic ɓo naaɗe tɛɗ lɛr kalaŋ sum, ɔɔ naai ɔgɗen aas kaas ute naajen kɛn kꞋdabar kꞋlɛk tɛc maakŋ kaaɗ ki.› ");
INSERT INTO kyq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Gaŋ mɛl jinɛnɛ se ɗeek deb kalaŋ ki ɔɔ: ‹Mɛɗuma, maam mꞋtuji te ɗim eyo ɔɔ taarje se lɛ kꞋtaaɗ kꞋtɔɔlin̰oga tɔɔlɔ mꞋɔɔ kɛn jaay naai Ꞌtɛɗn naaba lɛkga num, mꞋai kɔgŋ tamma kalaŋ se, naai Ꞌtookoga took ey la? ");
INSERT INTO kyq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ɓɔrse, ɔk bɛɗi ɔɔ Ꞌɓaa ɓei ki. Ɔɔ debm tɛɗn naabm baag kaam mɔɔtn se, kɛn maam mꞋje se maam mꞋan̰ kɛɗn bɛɗin̰ aan gɔɔ gɛn naai se sum kici. ");
INSERT INTO kyq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ute gursum se, nakŋ maam mꞋje ɓo mꞋan tɛɗn ro ki ey la? Lɔɓu do bɛɛ kɛn maam mꞋtɛɗ se, naai Ꞌmaaki ilim ro ki la?›» ");
INSERT INTO kyq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Taa naan̰ se ɓo Isa ɗeek ɔɔ: «Jeegen kaam mɔɔtn se, utu tɛɗn jeegen naan ki. Ɔɔ jeegen naan ki se lɛ, utu kɔɔpm kaam mɔɔtn.» ");
INSERT INTO kyq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isa ook ɓaa Jeruzalɛm ki ɔɔ kɛn naaɗe ɓaa ɓaa ɗoob ki se, naan̰ daŋ jee mɛtin̰ sik‑kaar‑di kalɗe ki ɔɔ ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ꞋBooyki, ɓɔrse naaje kꞋjꞋook kꞋɓaaki ɓaa Jeruzalɛm ki ɔɔ *Goon Deba se, jꞋutu jꞋan̰ kɔkŋ kɔl ji *magal jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa. Naaɗe utu an̰ kɔjn̰ bɔɔrɔ don̰ ki ɔɔ an̰ kɔl jꞋan̰ ɓaa tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Naaɗe an̰ kɔkŋ kɔl ji jeege tun Yaudge eyo, utu an̰ tooy koogo mɛtin̰ ki, an̰ tɔnd te mɛɛjɛ jaay an̰ tupm tɔɔl ro kaag ki. Ɔɔ ɓii k‑mɔtɔge tu se, naan̰ aɗe dur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gɔtn se gaan Zebedege ɓaaɗo ute kon̰ɗe naan Isa ki. Kon̰ɗe se ɛrg naaŋ ki taa tɔnd mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kɛn Isa aakin̰ se ɗeekin̰ ɔɔ: «Naai tap ɓo Ꞌje ɗi?» Mɛnda se tɛrlin̰ ɔɔ: «Ɔn̰ gɛnumgen di naani ki se maakŋ gaari ki se, ɔn̰ deb kalaŋ Ꞌkiŋg do ji daami ki ɔɔ kɛn kalaŋ do ji jeeli ki.» ");
INSERT INTO kyq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Isa tɛrlɗen ɔɔ: «Nakŋ naase Ꞌtɔndki mɛta ro ki se, naase Ꞌjeel ɔkki te mɛtin̰ eyo. *Kɔɔpm dubar maam mꞋutu mꞋkaay se, naase an̰ki kɔŋ kaasn gɛn kaayin̰ la?» Naaɗe tɛrlin̰ ɔɔ: «Yɛɛ, naaje jꞋan̰ kɔŋ kaasa.» ");
INSERT INTO kyq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isa ɗeekɗen ɔɔ: «Ɗeere, kɔɔpm dubarum se naase an̰ki kaayin̰a, naɓo gɛn gɔtn kiŋg jaay do ji daamum ki ey lɛ do ji jeelum ki se, ɔlum maam eyo. Gɔtn se Bubum ɗaapin̰ga ɗaap malin̰ge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kɛn jee mɛtn Isa kɛn sik jaay ɓaa booy taar ese se, naaɗe maakɗe tuj do gɛnaa naapge tun di se. ");
INSERT INTO kyq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gaŋ gɔtn se Isa daŋɗeno paac ɔɔ ɗeekɗen ɔɔ: «ꞋJeelki, jeegen kꞋtɔlɗe gaarge se iŋg do jeege tu ɔɔ magalgen kꞋtɔndɗe se tɛɗ jeege te taa tɔɔgɔ. ");
INSERT INTO kyq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Num naase se ɔn̰te Ꞌtɛɗki bini. Kɛn maakse ki jaay nam je tɛɗn magalse se, ɔn̰ ron̰ tɛɗn debm kaan̰ naabse. ");
INSERT INTO kyq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kɛn maakse ki se jaay nam je tɛɗn naanse se ɔn̰ ron̰ asen tɛɗn ɓulse. ");
INSERT INTO kyq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Taa *Goon Deba ɓaaɗo se, taa jeege ɓo an̰ tɛɗn naab eyo, num naan̰ ɓaaɗo se taa naan̰ ɓo tɛɗn naaba jeege tu ɔɔ kɛɗn kon̰ gɛn dugŋ do jee dɛna.» ");
INSERT INTO kyq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kɛn Isa ute jee mɛtin̰ ki jaay teec teec maakŋ gɛgɛr kɛn Jeriko ki se, jeege dɛna ɔk mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gɔtn se naaɗe ɔŋ jee kaam‑tɔɔkge di iŋg kiŋg jɛŋ ɗoob ki. Kɛn jee kaam‑tɔɔkge se booy jaay ɔɔ Isa ɓo deel deel se, naaɗe baag tɔɔɗn tɔɔyɔ ɔɔ: «Mɛlje, *Goon Daud ɛɛjjen doje ki!» ");
INSERT INTO kyq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gɔtn se jee dɛnge uunɗe kaamɗe ɔɔ ɗeekɗen ɔɔ: «ꞋƊoki!» Gaŋ jee kaam‑tɔɔkgen se tɛr tɔɔɗ tɔɔy makɔn̰ daala ɔɔ: «Mɛlje, Goon Daud ɛɛjjen doje ki!» ");
INSERT INTO kyq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gɔtn se Isa ɔk ɗaara, daŋɗeno ɔɔ ɗeekɗen ɔɔ: «Naase Ꞌjeki mꞋasen tɛɗn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Naaɗe tɛrlin̰ ɔɔ: «Mɛlje, ɔn̰ kaamjege Ꞌtɔɔɗn taaka!» ");
INSERT INTO kyq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Gɔtn se Isa ɛɛjɗen doɗe ki, uun jin̰ tɔndɗen kaamɗege tu ɔɔ kaamɗege naar tɔɔɗ taaka ɔɔ naaɗe ɔk mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kɛn Isa ute jee mɛtin̰ ki jaay aan gɔɔr ute Jeruzalɛm, cɛɛ naaŋ kɛn kꞋdaŋin̰ Bɛtpajɛ do *kɔsn ɔlib ki se, gɔtn se, maakŋ jeege tun mɛtin̰ ki se, Isa ɔl jeege di naaba. ");
INSERT INTO kyq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Naan̰ ɗeekɗen ɔɔ: «ꞋƁaaki maakŋ naaŋ kɛn naanse ki se, ɔɔ naase aki ɓaa naar kɔŋ ko buuru kꞋdɔɔkin̰ga dɔɔkɔ ute goonin̰ cɛɛn̰ ki. Kon̰ se Ꞌtuutin̰kiro ɔɔ naaɗe di paac Ꞌɓaamɗekiro. ");
INSERT INTO kyq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kɛn nam jaay ɗeeksenga taar ɗim num, Ꞌtɛrlin̰ki ɔɔki: Kɛse Mɛlje ɓo jeɗe. Ɔɔ naan̰ asesin̰ naar kɔn̰ɔ naase anɗekiro Ꞌɓaa.» ");
INSERT INTO kyq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nakŋ se paac jaay aan se taa taar kɛn debm taaɗ taar teeco taar Raa ki raaŋin̰o do dɔkin̰ se kaan ɗoobin̰ ki, kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ꞋƊeekki jeege tun maakŋ gɛgɛr kɛn Sionki ɔɔki: Aakki, gaarse te ɓaaseno kɔŋɔ, naan̰ se debm dalul ooko do ko buur ki, ɔɔ do goonin̰ ki kɛn kon̰ kꞋlee kꞋjꞋuun daama se. ");
INSERT INTO kyq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gɔtn se jee mɛtn Isa ki iin̰ ɓaa ɔɔ ɓaa tɛɗin̰ aan gɔɔ kɛn Isa taaɗɗeno ro ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Naaɗe tuut ko buuru ute goonin̰a ɔɔ ɓaanɗeno. Gɔtn se naaɗe tɔɔɗ taal kal magalɗege do buurge tu se jaay Isa iŋg do ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jeege dɛna tɔɔɗ taal kal magalɗege ɗoob ki ɔɔ jee mɛtin̰ge gaaŋo doomo ɓaaɗo tɔmbin̰ ɗoob ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jee te dɛnɗe paacn̰ daanin̰ se, jee naan ki, jee mɔɔtn ɗɔɔb ɔɔy ɔɔ: «Ozaana *Goon Daud!» «*Raa tɛɗn bɛɛn̰ do deb kɛn ɓaaɗo te ro Mɛljege Raa!» «Ozaana Raa kɛn raan maakŋ raa ki!» ");
INSERT INTO kyq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kɛn Isa jaay ɛnd maakŋ gɛgɛr kɛn Jeruzalɛm ki se, jee maakŋ gɛgɛr ki se paac taaɗ gajalaŋ ɔɔ taaɗ ute naapa ɔɔ: «Naan̰ se tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jee dɛngen ɔko mɛtin̰ se tɛrlin̰ ɔɔ: «Kɛse Isan debm taaɗ taar teeco taar Raa ki, kɛn iin̰o Nazarɛt kɛn taa naaŋ Galile ki.» ");
INSERT INTO kyq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Naan̰ kɛn se Isa ɓaa ɛnd daan bɔɔr Ɓee Raa ki ɔɔ gɔtn se naan̰ baag tuur jeegen ɓaano te nakɗege gɛn zoa ute jeegen ɓaaɗo dugu. Naan̰ tɔt tɔl tuun te tabil jee pɛlɛkŋ gursge naatn ɔɔ tɔt tɔl te nakgen jee tɛɗn zo dɛɛrge lee tiŋg do ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɔɔ ɗeekɗen ɔɔ: «Taar se kꞋraaŋin̰ga raaŋ maakŋ Kitap ki jꞋɔɔ: Ɓee maam se tɛɗn ɓee kɛn jeege ansum keeme, num gaŋ naase Ꞌtɛɗin̰ki tɛɗga gɔtn jee ɓoogge!» ");
INSERT INTO kyq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gɔtn se jee kaam‑tɔɔkge ute jee cɛkɛɗge ɓaaɗo ɔŋ Isa daan bɔɔr Ɓee Raa ki ɔɔ naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kɛn *magal jee tɛɗn sɛrkɛ Raage tu, ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage jaay aak nakŋ‑kɔɔɓgen Isa tɛɗo se, ɔɔ booy gaangen jaay tɔɔɗ tɔɔy daan bɔɔr Ɓee Raa ki ɔɔ: Ozaana, *kꞋnookki *Goon Daud se; gɔtn se naaɗe maakɗe tuj aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɔɔ naaɗe taaɗ Isa ki ɔɔ: «Taar gaangen taaɗ se, naai utu Ꞌbooy ɗey?» Isa tɛrlɗen ɔɔ: «Yɛɛ, mꞋutu mꞋbooyo. Num naase tap ɓo Ꞌdooyin̰ki te ey la, taar kɛn Kitap ɔɔ: Ute taar gaangen sɛɛmɛ ɔɔ kɛngen kꞋtaacege se ɓo, naai Ꞌnook roi aan gɔɔ kɛn naai maaki jen ro ki?» ");
INSERT INTO kyq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Gɔtn se Isa iin̰ ɔn̰ɗe ɔɔ ɓaa tooɗ naaŋ kɛn Bɛtani ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mɛtbeen̰ki tanɔɔrin̰ kɛn Isa iin̰ Bɛtani ki jaay ɔk tɛrlo ɓaaɗo ɓaa Jeruzalɛm ki se, naan̰ naam ɓo tɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naan̰ aak ko ba se ɗaar ɗaar cɛɛ ɗoob ki. Naan̰ ɓaaɗo mɛtn ko ba ki se, naɓo ɔŋ kamba sum. Gɔtn se naan̰ taaɗ ko ba ki se ɔɔ: «Naan ki se, mɔɔtn naai kooj ey sum!» Ɔɔ gɔtn se sum ɓo ko ba se naar tuutu. ");
INSERT INTO kyq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kɛn jee mɛtin̰ ki jaay aak nakŋ Isa tɛɗ se, ɔkɗen taaɗ eyo, ɗeek ɔɔ: «Tɛɗ ɔɔ ɗi jaay ko ba se naar tuut yɔkɔɗ bin se?» ");
INSERT INTO kyq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: kɛn naase jaay aalki maakse do Raa ki ɔɔ ɔkki naaja maakse ki ey se, naase aki kɔŋ tɛɗn nakŋ maam mꞋtɛɗ do ko ba ki se sum eyo, num aki ɗeekŋ kɔs ki ɔɔki: ‹Iin̰ ooc maakŋ baar ki› ɔɔ naan̰ Ꞌkiin̰ kooco. ");
INSERT INTO kyq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kɛn nakŋ paacn̰ naase Ꞌtɔndki mɛta ro ki jaay aalki maakse paac do Raa ki se, naase utu an̰ki kɔŋɔ.» ");
INSERT INTO kyq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isa ɓaaɗo ɛnd daan bɔɔr *Ɓee Raa ki ɔɔ baag dooy jeege. Gaŋ *magal jee tɛɗn sɛrkɛ Raage tu ɔɔ magal taa ɓee Yaudge ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «Naai tap ɓo tɔɔgi se ɔŋin̰o gay jaay ɔli Ꞌtɛɗ nakgen bin se? Kɛn undi kulu tɛɗ nakgen se tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isa tɛrlɗen ɔɔ: «Maam kic mꞋɔk taara kalaŋ mꞋje tɔnd mɛtse. Kɛn naase jaay ɔŋ Ꞌtɛrlumkiga num, maam kic mꞋasen taaɗn debm kɛn undum kulu gɛn tɛɗn nakgen se. ");
INSERT INTO kyq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ꞋTaaɗumki tu: kɛn ɔlo Jan‑Batist *batiz jeege se, Raa lɔɓu jikilimge lɛ?» Naaɗe baag taaɗ ute naapa ɔɔ: «Kɛn kꞋtaaɗkiga jꞋɔɔki: Raa ɓo ɔlin̰o lɛ, naan̰ ajeki ɗeekŋ ɔɔ: Gɛn ɗi jaay Ꞌbaate Ꞌkuunki taar Jan se? ");
INSERT INTO kyq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kɛn kꞋɗeekkiga jꞋɔɔki: ‹Jikilimge ɓo ɔlin̰o› lɛ, jee dɛnge ajeki kɔn̰ eyo, taa naaɗe jeel Jan se debm taaɗ taar teeco taar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gɔtn se naaɗe tɛrl Isa ki ɔɔ: «Naaje se kꞋjeel eyo.» Tɛr Isa kic ɗeekɗen ɔɔ: «Maam kic num, mꞋasen kɔŋ taaɗn debm kɛn undum kulu gɛn tɛɗn nakgen se eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tɛr Isa ɗeekɗen daala ɔɔ: «Saapm naase ki num ɔɔki ɗi: gaaba kalaŋ ɔk gaangen gaabge dio. Naan̰ ɓaa ɔŋ goonin̰ deet se ɔɔ ɗeekin̰ ɔɔ: ‹Goonuma, jaaki se Ꞌɓaa tɛɗo naaba maakŋ jinɛnɛ ki.› ");
INSERT INTO kyq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Goonin̰ tɛrlin̰ ɔɔ: ‹Maam mꞋɓaa eyo.› Naan̰ iŋg cɔkɔ se taar naan̰ taaɗ se saapin̰ jig eyo, ɔɔ naan̰ iin̰ ɓaa maakŋ jinɛnɛ ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tɛr bubɗe ɓaaɗo ɔŋ goonin̰ kuuy se taaɗin̰ aan gɔɔ kɛn naan̰ taaɗo goonin̰ kɛn deet se kici. Goonin̰ se tɛrlin̰ ɔɔ: ‹Yɛɛ, maam mꞋɓaao› naɓo gaŋ baate ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Maakŋ gaange tun di se kɛn gay ɓo took uunga taar bubin̰a?» Naaɗe tɛrlin̰ ɔɔ: «Goon deete.» Isa taaɗɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: *jee tɔkŋ miirge ute mɛnd kɛɛsn gaabge se, kɛnd *maakŋ Gaar Raa ki dose ki. ");
INSERT INTO kyq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ɗeere, Jan‑Batist se ɓaaɗo taaɗsenga ɗoobm gɛn tɛɗn nakgen ute ɗoobin̰a, naɓo naase Ꞌtookkiro te taarin̰ eyo. Ey num *jee tɔkŋ miirge, ute mɛnd kɛɛsn gaabge se kic ɓo, tookga taarin̰a. Gaŋ naase se, kɛn aakɗeki naaɗe took taarin̰ se kic ɓo, naase Ꞌbaate Ꞌtɛrlki maakse ɔɔ ɔŋ Ꞌtookki te taarin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tɛr Isa taaɗɗen ɔɔ: «ꞋBooyki kaal naagŋ taar kuuy daala! Gaaba kalaŋ tɛɗ jinɛn bin̰, iin̰ gurugin̰ te durdur, naan̰ uɗ gɔɔ do ko ki gɛn rii koojn̰ bin̰in̰a ɔɔ iin̰ gɔtɔ jɛrlɛ gɛn kiŋg bɔɔbm jinɛnin̰a. Gɔtn se maakŋ jinɛnin̰ se, naan̰ ɔn̰in̰ kaam ji jee tɛɗn naabge tu ɔɔ naan̰ iin̰ ɓaa mɛrtɛ. ");
INSERT INTO kyq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɛn kaaɗn kugŋ koojn̰ bin̰ jaay aan se, naan̰ ɔl jee tɛɗn naabin̰ge se gɔtn jeege tun naan̰ ɔn̰ɗe jinɛnin̰ kaam jiɗe se, taa an̰o kɔkŋ bɛɗin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Num gaŋ jee kɛn naan̰ ɔn̰ɗe jinɛnin̰ kaam jin̰ se tɔk jee kɛn naan̰ ɔlɗeno se. Deb kalaŋ naaɗe tɔnd dɛrɛŋin̰a ɔɔ deb kalaŋ kuuy se naaɗe tɔɔlin̰a ɔɔ kɛn kuuy kalaŋ se, kic naaɗe tund tɔɔlin̰ te koa. ");
INSERT INTO kyq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tɛr naan̰ ɔl jee tɛɗn naabgen kuuy dɛn cir jeegen deet se daala, naɓo naaɗe se kic ɓo, naaɗe tɛɗɗen bini. ");
INSERT INTO kyq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bin num kaam mɔɔtn se naan̰ ɔlɗeno goonin̰a, taa naan̰ saap ɔɔ: ‹Goonum mala se naaɗe utu tookŋ kuun taarin̰a.› ");
INSERT INTO kyq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gaŋ kɛn naaɗe jaay aak goonin̰ se, naaɗe taaɗ ute naapa ɔɔ: ‹Naan̰ se ɓo kɛn bubin̰ ooyga num utu Ꞌtɛɗn mɛl jinɛnɛ se! Bin num Ꞌɓaakiro kꞋtɔɔlin̰ki ɔɔ jinɛnɛ se lɛ, ajenki kɔɔpm naajege tu!› ");
INSERT INTO kyq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gɔtn se naaɗe ɔk ɔɔɗo goono se maakŋ jinɛn ki se naata ɔɔ ɓaa tɔɔlin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Gɔtn se Isa tɔnd mɛtɗe ɔɔ: «ꞋBooyki mɛtn taar se: kɛn mɛl jinɛnɛ se jaay ɓaaɗoga num, jee tɛɗn naabgen maakŋ jinɛn kɛn ese se naan̰ aɗen tɛɗn ɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Naaɗe tɛrlin̰ ɔɔ: «Jee tɛɗ bɛɛ ey bin se, naan̰ aɗen kɛɛjn̰ doɗe ki eyo ɔɔ aɗen tɔɔl naatn ɔɔ jinɛnɛ se lɛ, naan̰ an̰ kɛɗn ji jeege tun kuuy taa an̰sin̰ kaaka. Ɔɔ kɛn aanga kaaɗn koojn̰ bin̰ ki se, jee se an̰o kɔkŋ bɛɗin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isa tɛrlɗen ɔɔ: «Naase Ꞌdooyin̰ki te ey la taar kɛn Raa taaɗ maakŋ Kitap ki se ɔɔ: Ko kɛn jee kiin̰ ɓeege baatin̰ se, naan̰ se ɓo tɛɗga ko kɛn Ꞌgakŋ ɓea; kɛse ɓo naabm Mɛljege Raa ɔɔ naajege tu se jꞋaakin̰ki se ɔkjeki taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Taa naan̰ se ɓo Ꞌbooyki mꞋasen taaɗa: *maakŋ Gaar Raa se jꞋutu jꞋasesin̰ kɔɔɗ naatn jise ki ɔɔ Raa utu an̰ kɛɗin̰ jeege tun an̰ga tɛɗn naabin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nam jaay oocga do ko kɛn jee kiin̰ ɓeege baatin̰ se lɛ, Ꞌtɛrɛcɛ ɔɔ debm kɛn ko se oocga don̰ ki lɛ, an̰ daala.» ");
INSERT INTO kyq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Num *magal jee tɛɗn sɛrkɛ Raage tu ute *Parizige booy kaal naagŋ taar ese se, naaɗe ɓaa jeel ɔkga roɗe ki kaal naagŋ taar se taaɗ ute naaɗe se. ");
INSERT INTO kyq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gɔtn se naaɗe je ɗoobm an̰ kɔkɔ, naɓo naaɗe ɓeer jee dɛnge tu, taa jee dɛnge se jeel Isa se, naan̰ debm taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tɛr Isa baagɗen taaɗn ute kaal naagŋ taara daala ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«*Maakŋ Gaar Raa se tec aan gɔɔ gaar kɛn tɛɗ kɔsɔ dɛna ɓii kɔkŋ mɛnd goonin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naan̰ ɔl jee tɛɗn naabin̰ge taa aɗe ɓaa daŋ jeegen kꞋdaŋɗeno gɔtn kɔkŋ mɛnd ki se, naɓo jee se baate ɓaaɗo. ");
INSERT INTO kyq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tɛr naan̰ ɔl jee tɛɗn naabgen kuuy ɓaa ɗeek jeege tun kꞋdaŋɗeno se ɔɔ: ‹Ɓɔrse kɔsɔ se bɛɛga, kɔs taarumge ute maalumgen teer se mꞋtɔɔlɗenga. Ɔɔ ɓɛrɛ, kɔsɔ se ooyga, Ꞌɓaakiro aki kɔsɔ!› ");
INSERT INTO kyq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Naɓo jee se taar se naaɗe an ɗim eyo ɔɔ wɔɔk ɓaa naabɗege tu. Deb kalaŋ ɓaa maakŋ‑gɔtin̰ ki ɔɔ kɛn kalaŋ ɓaa gɔtn tɛɗn zo nakin̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jeegen kuuy se kic iin̰ tɔk jee tɛɗn naabge se dabarɗe ɔɔ tɔɔlɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gɔtn se gaarge maakin̰ taarin̰a, ɔl asgarin̰ge gɛn ɓaa tɔɔl jeegen tɔɔlo jee tɛɗn naabin̰ge se ɔɔ tɔɔcn̰ gɛgɛrɗe se naatn. ");
INSERT INTO kyq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gɔtn se naan̰ ɗeek jee tɛɗn naabin̰ge tu ɔɔ: ‹Kɔsɔ se ooyga, naɓo jeegen kꞋdaŋɗeno se ɔŋ aasin̰ te gɛn kɔsn kɔsn ese se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ꞋƁaaki gɔtn jeege tun lee tusn daan ɗoobge tu se, jeegen paacn̰ naase ɔŋɗekiga ɓo Ꞌdaŋɗekiro aɗe ɓaa gɔtn kɔkŋ mɛnd ki se.› ");
INSERT INTO kyq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jee tɛɗn naabge se ɓaa daan ɗoobge tu ɔɔ daŋ tuso jeegen naaɗe ɔŋɗeno paac se kaam kalaŋ, kɛn jee bɛɛ, kɛn jee bɛɛ eyo; ɔɔ ɓaanɗeno maakŋ ɓee kɛn jeege utu an kɔsn maak ki se ɔɔ maakŋ ɓee se jee kɛn kꞋdaŋɗeno se ɓaaɗo ɗoocin̰ tal. ");
INSERT INTO kyq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Gɔtn se gaarge ɛnd maakŋ ɓee ki gɛn kaakŋ jeegen maak ki se, gaŋ aak deb kalaŋ se uuso kal tec gɛn jeegen ɓaaɗo gɔtn kɔkŋ mɛnd ki se eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Gɔtn se gaarge ɗeekin̰ ɔɔ: ‹Mɛɗuma, tɛɗ ɔɔ ɗi jaay naai ɛndo gɔtn ara? Naai lɛ ɔk kal tec aan gɔɔ jeegen ɓaaɗo gɔtn kɔkŋ mɛnd ki ey se.› Num gaabm se ɔk taar kɛn an̰ tɛrl eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Gɔtn se gaarge ɗeek jee tɛɗn naabin̰ge tu ɔɔ: ‹Gaabm se, Ꞌdɔɔkin̰ki jin̰ge ute jɛn̰ge ɔɔ uun undin̰ki naatn maakŋ gɔt kɛn ɔɔɗɔ, ɔɔ gɔtn se ɓo gɔtn naan̰ an tɔɔyɔ ɔɔ an taan̰ naaŋin̰a.›» ");
INSERT INTO kyq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tɛr Isa ɗeek ɔɔ: «Ɗeere, *Raa se daŋga jeege dɛna, naɓo jeegen naan̰ bɛɛr tɔɔɗɗenga tɔɔɗ se baata.» ");
INSERT INTO kyq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gɔtn se *Parizige ɓaa tus dɔɔk taarɗe gɛn goom kɔkŋ Isa do taarin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Naaɗe ɔl maakŋ jeege tun mɛtn Parizige tu ute jee *Ɛrɔdge kandum se gɔtn Isa ki ɔɔ naaɗe ɓaa ɗeekin̰ ɔɔ: «Debm dooy jeege, naaje kꞋjeele naai se taaɗ taar mɛt ki. Ɔɔ ɗoobm Raa se naai Ꞌdooy jeege ute kɛn mɛt ki ɔɔ naai lɛ taar jeegen kuuy se naai Ꞌtɛɗn naaba ro ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maak‑saapm naai ki num, taaɗjen tu Sezar se jꞋɔk ɗoobm jꞋan̰ kɔgŋ miiri lɔɓu gɔtɔ?» ");
INSERT INTO kyq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Num gaŋ Isa se jeel saapɗen jig ey se ɗeekɗen ɔɔ: «Naase se jeegen Ꞌtɛɗki rose aan gɔɔ jee taaɗ taar mɛt ki se. Gɛn ɗi naase oomumki bin se? ");
INSERT INTO kyq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ꞋTaaɗumki tu tamman gɛn kɔgŋ miiri se, mꞋan̰ kaaka.» Gɔtn se naaɗe uun taaɗin̰ tamma kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Naan̰ tɔnd mɛtɗe ɔɔ: «Kaam‑nirl doa te ro kɛn kꞋraaŋin̰ ro ki se tap ɓo gɛn naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Naaɗe tɛrlin̰ ɔɔ: «Gɛn Sezar.» Gɔtn se Isa ɗeekɗen ɔɔ: «Kɛn bin num, nakŋ gɛn Gaar Sezar se ɛɗin̰ki nakin̰a ɔɔ gɛn Raa lɛ ɛɗin̰ki nakin̰ kici.» ");
INSERT INTO kyq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kɛn naaɗe jaay booy taar Isa taaɗ se, taar se ɔkɗen taaɗ eyo. Gɔtn se Isa se naaɗe ɔn̰in̰a ɔɔ iin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ɓii kɛn se sum ɓo, jeegen kꞋdaŋɗe *Sadusege kɛn taaɗ ɔɔ jeege ooyga num dur ey sum se ɓaaɗo ɔŋ Isa ɔɔ tɔnd mɛtin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Debm dooy jeege, *Musa se taaɗjenga taaɗ maakŋ Kitap ki ɔɔ: kɛn deba jaay ɔk mɛnda ɔɔ ooy ɔn̰ te goon ey se, ɔn̰ gɛnaan̰ kɔkŋ mɛndin̰a ɔɔ koojn̰ mɛtjili gɛnaan̰ kɛn ooy se. ");
INSERT INTO kyq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gaŋ maakjege tu se gɛnaage cili kon̰ɗe kalaŋ. Debm deet deet se ɔk mɛnda naɓo ooy ooj te goon eyo, ɔɔ mɛnda se ɔɔp gɛnaan̰ gɔɔsin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gɔɔsin̰ kic ɓaaɗo ɔk mɛnd se ɔɔ naan̰ kic ooy ooj te goon eyo. Tɛr debm gɛn k‑mɔtɔge tu se kic ɓo ɓaaɗo ɔk mɛnd se ɔɔ naan̰ ooyo ooj te goon eyo; bini aan do deb kɛn gɛn k‑cilige tu. ");
INSERT INTO kyq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kɛn naaɗen cili se jaay ooy paac se, kaam mɔɔtn se mɛnda se kic ɓaaɗo ooyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bin num ɓii kɛn jaay jeegen ooyga kooy aɗe dur daan yoge tu se, maakŋ gɛnaage tun cili se, mɛnd se tap ɓo Ꞌtɛɗn mɛnd naŋa? Taa naaɗe paac lɛ tɔk naamin̰ga naam mɛnd se.» ");
INSERT INTO kyq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isa tɛrlɗen ɔɔ: «Naase se, ɓɛrɛ, iigkiga, taa taar Raa se lɛ Ꞌjeelki eyo ɔɔ tɔɔgŋ Raa kic lɛ naase ɔndki te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Taa ɓii kɛn jaay jeegen ooyga kooy aɗe dur daan yoge tu se, gaabge te mɛndge se Ꞌtɔkŋ naap ey sum. Num naaɗe se tecn̰ aan gɔɔ *kɔɗn Raagen maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gɛn jeegen ooyga kooy jaay utu dur daan yoge tu se, taar Raa taaɗsen maakŋ Kitapin̰ ki se, naase Ꞌdooyin̰ki te ey la kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Maam se mꞋRaa gɛn *Abraam mꞋgɛn Isaka ɔɔ mꞋgɛn *Yakub. Raa se, naan̰ Raa jeegen ooyga kooy eyo, num naan̰ se, Raa jee zɛɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kɛn jee dɛnge jaay booy taar kɛn Isa dooyɗe se, taar se tap ɓo ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kɛn *Parizige jaay booy ɔɔ *Sadusege ɔŋ aasin̰ te ro Isa ki ey se, naaɗe daŋ tus naapa. ");
INSERT INTO kyq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Maakɗe ki se, deb kalaŋ se debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa, je ɗoobm an goom kɔkŋ Isa se, ɓaaɗo tɔnd mɛtin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Debm dooy jeege, maakŋ Ko Taar kɛn Raa ɛɗo Musa ki se taar gɛn tɛɗa kɛn cirɗe paac se, kɛn gay?» ");
INSERT INTO kyq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isa tɛrlin̰ ɔɔ: «Mɛli Raa se, Ꞌjen̰ ute maaki paac ute roi paac ɔɔ ute saapi paac. ");
INSERT INTO kyq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kɛse ɓo taar deet deetn gɛn tɛɗa kɛn cirɗe paac paac. ");
INSERT INTO kyq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tɛr kɛn mɛtin̰ ki tecin̰ tec se kɛn ɔɔ: ꞋJe naapi aan gɔɔ ro naai mala. ");
INSERT INTO kyq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Maakŋ Ko Taar Raa ki ute taargen jee taaɗ taar teeco taar Raa ki taaɗo paac se, don̰ ɓo ɔɔs do taarge tun di ese sum.» ");
INSERT INTO kyq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aan gɔɔ *Parizige lɛ tusga ɗey se, Isa tɔnd mɛtɗe ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Gɛn naase ki num, al‑Masi se tap ɓo naŋa? Naan̰ tap ɓo goon naŋa?» Naaɗe tɛrlin̰ ɔɔ: «Naan̰ se mɛtjil Daud.» ");
INSERT INTO kyq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Isa ɗeekɗen ɔɔ: «Num tɛɗ ɔɔ ɗi jaay *Nirl Raa ɔl Daud daŋin̰ ɔɔ: Mɛluma? Ɔɔ naan̰ mala taaɗga taaɗ maakŋ Kitap ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Mɛljege Raa taaɗo Mɛlum ki ɔɔ: ꞋƁaaɗo iŋg do ji daamum ki bini jee taamooyige se mꞋaɗen tɛɗn naai utu Ꞌkiŋg doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kɛn Daud jaay daŋ al‑Masi ɔɔ Mɛluma, anum tɛɗ ɔɔ ɗi jaay Mɛlin̰ Ꞌtɛɗn goon Daud se?» ");
INSERT INTO kyq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Maakɗe ki se, nam jaay an̰ tɛrl taara kalaŋ Isa ki kic ɓo gɔtɔ ɔɔ naan̰ kɛn se mɔɔtn nam tɔnd te mɛtin̰ do taar ɗim kɛn kuuy ey sum. ");
INSERT INTO kyq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Isa ɗeek jee dɛnge tu ute jeege tun mɛtin̰ ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, naaɗe se ɓo kɛn lee dooy jeege ute *Ko Taar kɛn Raa ɛɗo Musa ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kɛn bin num Ꞌtookɗeki taarɗe ɔɔ Ꞌtɛɗki nakgen paacn̰ naaɗe lee taaɗsen se. Naɓo ɔn̰ten Ꞌtɛɗki aan gɔɔ naaɗe, taa naaɗe nakgen naaɗe taaɗ paac se, naaɗe ɔŋ tɛɗin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Naaɗe dɔɔk daam deere ɔɔ tɔnd do jeege tu ɔɔ naaɗe malin̰ge tap ɓo baate kutin̰ te goon jiɗe. ");
INSERT INTO kyq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Naabɗen naaɗe tɛɗ paac se je taa jeege aɗen kaaka. Ɔɔ taar Raagen mɛtin̰gen kꞋraaŋ jaay naaɗe ɔɔsin̰ aan gɔɔ laaye ɔɔ lee dɔɔk do naanɗege tu ey lɛ kɛyɗege tu se, naaɗe tɛɗin̰ magal magal cir gɛn jeege. Ɔɔ taa kalɗege se, naaɗe tɔɔs ziiɗin̰ taar ki tɛɗn jɛrl cir gɛn jeege. ");
INSERT INTO kyq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kɛn kꞋdaŋɗenga gɔtn kɔs ki se, naaɗe je gɔtn kiŋg naan ki. Ɔɔ kɛn ɓaaga maakŋ ɓeege tun Yaudge lee tusn maak ki se, naaɗe je gɔtn kiŋg naan ki kici. ");
INSERT INTO kyq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kɛn aanga bɔɔr ki kic lɛ, naaɗe je jꞋaɗen tɛɗn tɔɔsɛ naaɗe ki ɓo deete ɔɔ je jꞋaɗen daŋ: jee dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Num naase ɔn̰ten Ꞌkɔn̰ki jꞋasen daŋ jee dooy jeege taa naase Ꞌpaacki se gɛnaage ɔɔ debm dooyse lɛ kalaŋ sum. ");
INSERT INTO kyq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Do naaŋ ki ara se ɔn̰ten Ꞌdaŋki nam ɔɔki: Bubje, taa naase ɔkki Bubu kalaŋ sum ɔɔ naan̰ kɛn iŋg maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ɔn̰ten Ꞌkɔn̰ki jꞋasen daŋ Debm dooy jeege, taa naase mɛl dooyse se *al‑Masi kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Debm jaay tɛɗn magala maakse ki se, ɔn̰ ron̰ tɛɗn debm tɛɗn naabse. ");
INSERT INTO kyq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Taa debm magal ron̰ se utu kɔɔpm baata, ɔɔ debm jaay ɔɔp ron̰ baat se, ron̰ utu kookŋ raan. ");
INSERT INTO kyq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizigen kɛn Ꞌtɛɗki rose aan gɔɔ jee taaɗn taar mɛt ki se utu asen tɛɗn ɔɔn̰ aak eyo; taa naase Ꞌgaaski ɗoobm *maakŋ Gaar Raa jeege tu. Ɔɔ naase mala kic lɛ baate kɛndki, ɔɔ jeegen je kɛndɛ se lɛ, naase Ꞌgaasɗeki ɗoobo. ");
INSERT INTO kyq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Naasen jee taaɗn tɔɔkŋ mɛtn taar Raage ute Parizigen kɛn Ꞌtɛɗki rose aan gɔɔ jee taaɗn taar mɛt ki se utu asen tɛɗn ɔɔn̰ aak eyo! Taa naase ɔski ji mɛnd daayge ɔɔ tɔndki mɛtn *Raa ɔn̰ki eyo taa jeege asen kaaka. Taa naan̰ se ɓo bɔɔrɔ utu koocn̰ dose ki se utu asen tɛɗn ɔɔn̰ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizige se, naasen kɛn Ꞌtɛɗki rose aan gɔɔ jee taaɗ taar mɛt ki utu asen tɛɗn ɔɔn̰ aak eyo. Naase Ꞌleeki do baarge tu ɔɔ gɔtɔ ɓaa se paac ɔɔ jeki aki tɛɗn jeege Ꞌtɛɗn Yaudge aan gɔɔ naase se ɔɔ kɛn naase ɔŋkiga deb kalaŋ jaay uunga ɗoobse se, debm se naase Ꞌtɛɗin̰ki debm aas gɛn ɓaa maakŋ pooɗ ki mɛt dio cirse naase se. ");
INSERT INTO kyq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Naasen jee kaam‑tɔɔkgen jee tɔɔɗn jeege utu asen tɛɗn ɔɔn̰ aak eyo! Naase taaɗki ɔɔki: ‹Kɛn nam jaay naam te ro *Ɓee Raa se tɛɗ ɗim eyo. Num nam jaay naam te ro daabm maakŋ Ɓee Raa ki se, kɛse ɓo kɛn ɔɔn̰ɔ.› ");
INSERT INTO kyq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Naase jee kaam‑tɔɔkgen jee dɛrlge ara! Kɛn gay ɓo ɔɔn̰ ciri? Daab lɔɓu Ɓee Raa kɛn kꞋɓaanoga te daab maak ki jaay daabm se, tɛɗ gɛn Raa se ne? ");
INSERT INTO kyq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tɛr naase Ꞌɗeeki ɔɔ: ‹Kɛn nam jaay naam ron̰ te *gɔtn kꞋjꞋiin̰ kꞋɗaapin̰ gɛn tɛɗn sɛrkɛ do ki se, tɛɗ ɗim eyo, num kɛn naan̰ jaay naam ron̰ te nakŋ kꞋɓaano do ki gɛn tɛɗn *sɛrkɛ Raa ki se, kɛse ɓo kɛn ɔɔn̰ɔ.› ");
INSERT INTO kyq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jee kaam‑tɔɔkge Ꞌtaaɗumki tu: nakŋ kꞋɓaano gɛn tɛɗn sɛrkɛ se ɓo cir lɔɓu, gɔtn kꞋjꞋiin̰ kꞋɗaapin̰ gɛn tɛɗn sɛrkɛ ɔɔ sɛrkŋ kꞋjꞋɔmbin̰ga do ki num, taaɗ ɔɔ sɛrkŋ se tɛɗga gɛn Raa se ɓo cir ne? ");
INSERT INTO kyq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bin num debm jaay naam ron̰ te gɔtn kꞋjꞋiin̰ ɗaapin̰ gɛn tɛɗn sɛrkɛ do ki se, kɛse naan̰ naam te ro nakgen paacn̰ kꞋɓaano gɛn tɛɗn sɛrkɛ do ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Debm kɛn naam ron̰ te Ɓee Raa se, kɛse naan̰ naam ron̰ te ro mɛlin̰ Raa kɛn iŋg maak ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Debm jaay naam ron̰ te maakŋ raa se naan̰ naam ron̰ ute kaag do Raa ɔɔ ute mɛlin̰ kɛn iŋg do ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizigen kɛn tɛɗki rose aan gɔɔ jee taaɗn taar mɛt ki se, utu asen tɛɗn ɔɔn̰ aak eyo! Nakgen naase ɔkki sɛɛm sɛɛm kɛn Ꞌlee Ꞌtɔmbki maakŋ taaɗsege tu kɛn tɛɗin̰ nijim se kic ɓo, naase Ꞌlee Ꞌnigin̰ki gɔtɔ kaam sik ɔɔ kɛn kaam kalaŋ se ɛɗki Raa ki. Naɓo taargen maakŋ Ko Taar kɛn Raa ɛɗo *Musa kɛn bɛɛ bɛɛ tap ɓo, naase aalin̰ki maak ki eyo kɛn taaɗsen ɔɔ Ꞌtɛɗki nakŋ ute ɗoobin̰a, kɛɛjn̰ do jeege tu ɔɔ gɛn tujn̰ ɔrm eyo. Kɛse ɓo nakgen, bɛɛki num, an̰ki lee tɛɗa ɔɔ nakgen kɛn naase lee gaaŋɗeki gɔtɔ kaam sik jaay kɛn kalaŋ ɛɗki Raa ki se kic ɓo ɔn̰ten Ꞌdirigin̰ki kici. ");
INSERT INTO kyq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jee kaam‑tɔɔkgen Ꞌlee tɔɔɗki jeege! Naase ɔɔyki maanse te rɛɛsɛ taa bɔtɔr kalaŋ bɔɔy maak ki eyo, gaŋ naase tap ɓo tulki gin̰jge. ");
INSERT INTO kyq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizigen Ꞌtɛɗki rose aan gɔɔ jee taaɗ taar mɛt ki se, asen Ꞌtɛɗn ɔɔn̰ aak eyo! Taa naase Ꞌtugki naagŋ nakgen naase Ꞌlee aayki ɔɔ ɔsnki se aac walak, num gaŋ maakin̰ tap ɓo, naase Ꞌɗoocin̰ki ute nakgen naase Ꞌɓoogkiro ɔɔ Ꞌtujkiro gɛn jeege. ");
INSERT INTO kyq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kɔɗ Parizi naai se debm kaam‑tɔɔkɔ! ꞋTug Ꞌɗaap maakŋ naki kɛn naai lee aay maak ki se jaay ɓo naagin̰ kic Ꞌtɛɗn aak bɛɛ. ");
INSERT INTO kyq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Naase jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizigen kɛn tɛɗki rose aan gɔɔ jee taaɗ taar mɛt ki se, asen tɛɗn ɔɔn̰ aak eyo! Taa naase Ꞌtecki do ɓaaɗgen kꞋtɛɗɗen raap kaar kaar aak bɛɛ kaam ki, gaŋ maakɗege ɗooc te cɛŋ jeegen ooyga kooyo ɔɔ ruumga ruumu maak ki se paac. ");
INSERT INTO kyq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Naase kic Ꞌtecki bini, taa naan jeege tu se, naase Ꞌtɛɗki rose jee bɛɛ, gaŋ maakse ɗooc te taar mɛt ki eyo ɔɔ te *kusin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizigen kɛn tɛɗki rose aan gɔɔ jee taaɗ taar mɛt ki se, asen tɛɗn ɔɔn̰ aak eyo! Naasen Ꞌlee iin̰ Ꞌɗaapki do ɓaaɗn jee taaɗ taar teeco taar Raa ki do dɔkin̰a, ɔɔ jeegen kɛn leeɗo ute kɛn mɛt ki se, naase Ꞌtamarɗeki do ɓaaɗɗege aak bɛɛ bɛɛ. ");
INSERT INTO kyq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ɔɔ tɛr naase Ꞌɗeekki ɔɔki: Kɛn do bubjege tu naane jaay naaje jꞋutu num, naaje kꞋtookɗe taarɗe eyo gɛn tɔɔl jee taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kɛn bin num naase mala ɓo Ꞌtaaɗki ɔɔki naase se ɓo mɛtjil jee kɛn tɔɔlo jee taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kɛn bin num Ꞌɓaaki ute naan se, naabm bubsege lee tɛɗo se, naase Ꞌtɛɗ naŋin̰ki sɔrɔk cir gɛn naaɗe se. ");
INSERT INTO kyq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Aakumki tu wɔɔjgen ara ɔɔ mɛtjil kꞋmɔrpɔpgen ara! Naase aki kɔŋ kaan̰ kɔtn dubar pooɗ kɛn gɛn daayum se ɔɔ ɗi? ");
INSERT INTO kyq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Taa naan̰ se ɓo Ꞌbooyki mꞋɗeekseni: maam mꞋaseno kɔl jee taaɗ taar teeco taar Raa ki, jee jeel‑taarge ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage. Num jee mɛtin̰ge utu aɗeki tɔɔlɔ ɔɔ jee mɛtin̰ge aɗeki tupm tɔɔl ro kaag ki, jee mɛtin̰ge utu aɗeki tɔnd te mɛɛjɛ maakŋ *ɓeege tun naase lee tusnki maak ki. Ɔɔ kɛngen mɛtin̰ge aɗeki tuuru ɔɔ aɗeki lee je maakŋ gɛgɛrge tu. ");
INSERT INTO kyq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɔɔ jee kɛn lee ute kɛn mɛt kɛn naase tɔɔlɗeki jaay moosɗe ɔɔy do naaŋ ki se, kɛn iin̰o do yo Abɛl ki bini aan do yo Zakari kɛn goon Baraci, kɛn naase Ꞌtɔɔlin̰ki daan Ɓee Raa ute *gɔtn kɛn kꞋlee kꞋtɛɗn sɛrkɛ Raa ki se asen kɔɔpm mindse ki. ");
INSERT INTO kyq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ꞋBooyki bɛɛ mꞋasen taaɗa: moosn jeegen kꞋtɔɔlɗe paac se utu kɔɔpm do jeege tun ɓɔrse utu se.» ");
INSERT INTO kyq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Isa ɗeek ɔɔ: «Waay Jeruzalɛm, waay Jeruzalɛm, naai kɛn debm tɔɔl jee taaɗ taar teeco taar Raa ki ɔɔ jee kɛn Raa ɔlɗeno gɔti ki kic ɓo, naai ɓo debm tund tɔɔlɗe! Mɛt kando, maam mꞋje mꞋtusn gɛnige aan gɔɔ ko kɔrɔn̰j kɛn lee tus gɛnin̰ge taa bɛɛkŋ kɛyin̰ ki tu, naɓo naase Ꞌjeki te eyo. ");
INSERT INTO kyq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ꞋBooyki, kɛn bin num *Ɓee Raase se utu Ꞌtooɗn kuuɗu. ");
INSERT INTO kyq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taa naan̰ se ɓo Ꞌbooyki mꞋasen taaɗa: naan ki se mɔɔtn naase amki kɔŋ kaak ey sum, bini kaan kaaɗ kɛn aki ɗeekŋ ɔɔki: Ɔn̰ Mɛlje Raa tɛɗn bɛɛn̰a do deb kɛn utu ɓaaɗo ute ro naan̰a!» ");
INSERT INTO kyq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kaaɗ kɛn se Isa teecoga naatn maakŋ Ɓee Raa ki ɔɔ kɛn ɓaa ɓaa se, jee mɛtin̰ ki ɓaaɗo ɔŋin̰a taa an̰ taaɗn Ɓee Raa kɛn kꞋjꞋiin̰in̰ga aak bɛɛ se. ");
INSERT INTO kyq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Isa tɛrlɗen ɔɔ: «Ɓee se paac aakin̰ki se jiga ɗaamo? Naɓo Ꞌbooyki bɛɛ mꞋasen taaɗa: ɓee ɗaar aak bɛɛ se jeege utu an̰ ru naŋ tak. Kon̰gen rɛɛs aak bɛɛ bɛɛ se, utu wɔɔkŋ kalaŋ kalaŋ ɔɔ ko tap ɓo Ꞌkɔŋ tooɗn do naapin̰ ko ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Naan̰ kɛn se, Isa iŋg do *kɔsn ɔlib ki. Gɔtn se jee mɛtin̰ ki ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «ꞋTaaɗjen tu nakgen se Ꞌkaan nuŋ ki? Ɔɔ naan̰ se Ꞌtɛɗn ɔɔ ɗi jaay ɓo naaje jꞋan kaakŋ jeel ro ki gɛn ɓii kaani ɔɔ ɓiin dunia an naŋ se?» ");
INSERT INTO kyq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isa tɛrlɗen ɔɔ: «Ɔndki kɔndɔ nam ɔn̰ten Ꞌdɛrlse!» ");
INSERT INTO kyq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Taa jeege dɛna utu aɗe ɓaa ute roma ɔɔ naŋa kic utu asen taaɗn ɔɔ: maam ɓo *al‑Masi! Ɔɔ kɛn naaɗe Ꞌtɛɗ bin se utu Ꞌdɛrl jeege dɛna. ");
INSERT INTO kyq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Naase utu aki booy gɔtn bɔɔrɔ ɔɔ jeege utu asen kɔɔsn maan bɔɔrɔ, anum ɓɛrɛ, ɔndki kɔndɔ, ɔn̰ten Ꞌɓeerki! Taa nakgen se utu Ꞌkaana, naɓo duni se Ꞌkɔŋ naŋ ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jee taa naaŋ kaam kalaŋ utu kiin̰ bɔɔrɔ ute jee taa naaŋ kuuy. Taa naaŋ gaar kaam kalaŋ utu kiin̰ bɔɔrɔ te taa naaŋ gaar kɛn kuuy. Maakŋ naaŋge tun mɛtin̰ naaŋa utu Ꞌtea ɔɔ gɔtn mɛtin̰ ɓo utu tɔɔl jeege. ");
INSERT INTO kyq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aan gɔɔ mɛnd kɛn maakin̰ tuunin̰ gɛn koojo se, nakgen se paac kic ɓo baaga kaana num, kɛse je taaɗn ɔɔ dunia ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Kaaɗ kɛn se jꞋutu jꞋasen dabar dɛna ɔɔ jꞋasen tɔɔlɔ. Ɔɔ taa maam se jee do naaŋ ki se paac utu asen kɔɔɗn kundu. ");
INSERT INTO kyq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gaŋ kaaɗ kɛn se jeege dɛna utu an rɛsn ute kaal maakɗen do *Raa ki. Naaɗe kutn naapge naan tɔɔgge tu ɔɔ tɔɔɗn tund naapa. ");
INSERT INTO kyq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jee tɛɗ roɗe aan gɔɔ jee taaɗ taar teeco taar Raa ki se, utu aɗe ɓaa dɛna ɔɔ dɛrl jeege dɛna. ");
INSERT INTO kyq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","*Kusin̰ se ziiɗn ɓaa ute naanin̰a ɔɔ jeege dɛna maakjeɗege utu tɛɗn baata do naapge tu. ");
INSERT INTO kyq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Naɓo debm jaay aayga kaamin̰ bini aanga do taar tɔɔlin̰ ki num, naan̰ se utu Ꞌkɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Labar Jigan gɛn *maakŋ Gaar Raa ese se jꞋutu jꞋan̰ taaɗin̰ jeege tun do naaŋ ki paac, kɛse tɛɗn saaɗa jeege tun ɓaa se paac jaay ɓo sɔm kaam mɔɔtn duni naŋa.» ");
INSERT INTO kyq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Naase utu aki kaakŋ Deb tuj deelga te gɔtin̰ se utu kɛnd kiŋg maakŋ *Ɓee Raa ki, gɔt kɛn *salal se, aan gɔɔ debm taaɗ taar teeco taar Raa ki, ron̰ Daniɛl, taaɗo do dɔkin̰ se. Bin num debm jaay dooy taar ese se n̰Ꞌbooy n̰Ꞌɔkin̰ jiga jaayo! ");
INSERT INTO kyq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kaaɗ kɛn se ɔn̰ jee kɛn iŋg taa naaŋ Jude ki se, kꞋjꞋaan̰ jꞋook maakŋ koge tu. ");
INSERT INTO kyq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Debm iŋg kiŋg do ɓeen̰ ki raan se, n̰Ꞌɔn̰te bɔɔyo naaŋ ki gɛn tɔsn nakin̰gen maakŋ ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Debm jaay ɓaaga maakŋ‑gɔtin̰ ki kic lɛ, n̰Ꞌɔn̰ten tɛrlo ɓeene gɛn kuun kalin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ɓii kɛn se, mɛndgen mɛndkaamge ute ko gaangen gɛnɗege aay kaay si se, aɗen tɛɗn ɔɔn̰ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eemki Raa taa nakgen se Ꞌkaan kaaɗn kuul ki eyo ey lɛ *ɓii sebit ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kaaɗ kɛn se jeege utu dabar dɛna ɔɔ dubar se gɔtn Raa aal dunia tap ɓo nam naam te eyo, ɔɔ mɔɔtn dubar naan ki jaay Ꞌkɔɔn̰ cir naan̰ ese se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Num Raa se ɓii dubar ese se, naan̰ gaaŋin̰ga duuku taa jeegen naan̰ bɛɛr tɔɔɗɗe se. Kɛn ɓiigen se jaay naan̰ gaaŋɗen te duuk ey num, nam Ꞌkɔŋ kaaja tap ɓo gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kaaɗ kɛn se jaay nam taaɗsenga ɔɔ: ꞋƁaaɗo aakki, *al‑Masi utu ara ey lɛ taaɗsen ɔɔ: Naan̰ utu naane! Ɔn̰ten Ꞌtookki taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ꞋBooyki! Jeegen kɛn tɛɗ roɗe ɔɔ naaɗe ɓo al‑Masige ute jeegen tɛɗ roɗe ɔɔ naaɗe jee taaɗ taar teeco taar Raa ki se utu aɗe ɓaao. Naaɗe utu Ꞌtɛɗn nakŋ‑kɔɔɓge ute nakgen deel doa, taa Ꞌkaan̰ jeege dala. Ɔɔ jee kɛn Raa bɛɛr tɔɔɗɗenga tɔɔɗ se kɛn naaɗe ɔŋga ɗoobo num, aɗen kaan̰ dal kici. ");
INSERT INTO kyq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ꞋBooyki! Ɓɛrɛ, taar se lɛ, maam mꞋaalsenga kaal bise ki. ");
INSERT INTO kyq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Kɛn kꞋtaaɗsenga jꞋɔɔ: Al‑Masi utu do kɔɗ‑ɓaar ki naane num, ɔn̰ten ɓaaki. Ey lɛ kɛn jꞋɔɔ: naan̰ utu oom ara! Num ɔn̰ten Ꞌtookki taarɗe. ");
INSERT INTO kyq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Taa ɓii kɛn *Goon Deba aɗe ɓaa se tecn̰ aan gɔɔ maan aalo kaam kooko wusuk bini dɔɔk te gɔtn kaaɗa toocn̰ni. ");
INSERT INTO kyq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ɓii kaanum kic tecn̰ aan gɔɔ gɔtn daa ɗim gam ooyga jaay ɓo marlge kic lee bɔɔy tus ro ki se. ");
INSERT INTO kyq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kɛn ɓiigen gɛn dubarge se jaay naar deelga num, kaaɗa se utu Ꞌtɛɗn ilim dib ɔɔ laapa se lɛ wɔɔr eyo. K‑dijgen maakŋ raa ki aɗe si naaŋ ki ɔɔ nakgen ɔk tɔɔgɔ maakŋ raa ki se utu Ꞌtea. ");
INSERT INTO kyq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Gɔtn se jeege an kaakŋ nakŋ jeel maakŋ raa ki kɛn taaɗ ɔɔ Goon Deba utu ɓaaɗo ɔɔ jeegen do naaŋ ki paac keem nɔɔ an kaakŋ Goon Deba aɗe bɔɔy maakŋ gapara ki ute tɔɔgŋ Raa ɔɔ gɔtɔ wɔɔr kɛlɛŋ. ");
INSERT INTO kyq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pulu Ꞌkeem makɔn̰ɔ maakŋ raa ki ɔɔ Goon Deba aɗe kɔl kɔɗin̰ge taa te Ꞌtusn jee kɛn naan̰ bɛɛr tɔɔɗɗe mɛtn naaŋ kɛn kaam sɔɔ ɔɔ kɛn iŋg mɛtn raa kɛn kaam gay gay kici.» ");
INSERT INTO kyq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Naase ɔndki doa te ko ba: kɛn naan̰ jaay baaga kɔɔɗn taa‑oomo ɔɔ dɔɔb kamba se, naase Ꞌjeelki ɔkki mɛt‑kijiri aanga ɔɔ ɓara ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bin num naase kic ɓo, kɛn aakkiga nakgen se paac jaay aanga num, Ꞌjeelki *Goon Deba se naan̰ aan ɔŋsega gɔɔr kaam taarse ki. ");
INSERT INTO kyq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ꞋBooyki bɛɛ mꞋasen taaɗa: jee duni kɛn ɓɔrse se Ꞌkooy naŋ ey sum ɓo nakgen se paac utu Ꞌkaana. ");
INSERT INTO kyq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maakŋ raa ute do naaŋa se utu Ꞌdeele, num taar maam se Ꞌkɔŋ deel eyo. ");
INSERT INTO kyq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Num gaŋ kɛn gɛn kaaɗin̰ ute ɓiin̰ *Goon Deba ano ɓaa se, nam tap ɓo jeel eyo. *Kɔɗn Raage maakŋ raa ki kic lɛ jeel eyo, ɔɔ Goono kic lɛ jeel eyo. Nam jeel ɓiin̰ se, gɔtɔ. Kɛn jeel se, Bubu kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ɓii kɛn Goon Deba aɗe ɓaa se, Ꞌtecn̰ aan gɔɔ nakgen deelo do Noe ki. ");
INSERT INTO kyq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Naan̰ kɛn naane se, kaaɗ kɛn maan magala bɔɔyo gɔɔb te jeege ey ɓɔrt se, jeege ɔsɔ, aaye, tɔk mɛndge, tɔk gaabge ɔɔ ɔl gɛnɗege kic ɓo tɔkŋ naapge bini aan ɓii kɛn Noe ɛnd maakŋ markab kɛn magala. ");
INSERT INTO kyq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gɔtn se jeege se, nakŋ utu kaan doɗe ki se, naaɗe ɔnd eyo bini maan magala ɓaaɗo gɔɔb tɔɔlɗe paac. Kɛn Goon Deba aɗe ɓaa se kic ɓo Ꞌtecn̰ bini. ");
INSERT INTO kyq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɓii kɛn se gaabge dio tɛɗ tɛɗ naaba maakŋ‑gɔtɗe ki se, deb kalaŋ jꞋan̰ kuunu ɔɔ deb kalaŋ Ꞌkɔɔpɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɔɔ mɛndgen di ɗaar uus kuus do toot ki se kic, deb kalaŋ jꞋan̰ kuunu ɔɔ deb kalaŋ Ꞌkɔɔpɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iŋgki zɛɛrɛ daayum, taa naase kic ɓo Ꞌjeelki eyo ɓiin Mɛlse aɗe ɓaa se. ");
INSERT INTO kyq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naase Ꞌjeelki kɛn mɛl ɓee jaay jeel kaaɗn debm ɓoogo ano ɓaa nɔɔr num, naan̰ tooɗn bi eyo ɔɔ kɔn̰ debm ɓoogo an̰ tɛrɛcn̰ ɓeen̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Taa naan̰ se ɓo naase kic Ꞌɗaapki rose, iŋgki do mɛtɛkse ki, taa Goon Deba jaay aɗe ɓaa se lɛ, kaaɗ kɛn naase Ꞌjeelki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Isa ɗeek ɔɔ: «Debm tɛɗn naabm mɛtɛkɛ ɔɔ tuj ɔrmin̰ ey se kɛn gay? Naan̰ ɓo debm kɛn mɛlin̰ ɔn̰in̰ jee tɛɗn naabgen kuuy kaam jin̰a, ɔɔ kɛn aanga kaaɗin̰ ki num, lee ɛɗɗen kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maak‑raapo debm tɛɗn naabm kɛn mɛlin̰ aan jaay ɔŋin̰ naan̰ utu tɛɗin̰ tɛɗn naabm kɛn naan̰ ɔn̰in̰sin̰ kaam jin̰ se. ");
INSERT INTO kyq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ꞋBooyki bɛɛ mꞋasen taaɗa: debm tɛɗn naabm bin se, mɛlin̰ utu an̰ kɔn̰ nakin̰ge paac kaam jin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Num gaŋ kɛn naan̰ ɓo debm tɛɗn naabm jig eyo ɔɔ taaɗ ute maakin̰ ɔɔ: Mɛlum se aɗe kɔŋ tɛrl yɔkɔɗ eyo, ");
INSERT INTO kyq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ɔɔ gɔtn se iin̰ baag tɔnd jeen̰gen kꞋtɛɗ naaba tɛl se, naan̰ ɔsɔ ɔɔ aay te jee kaay koonge. ");
INSERT INTO kyq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Gaŋ mɛl gaabm ese se, ɓiin jaay naan̰ ano tɛrl se, naan̰ ɔnd eyo ɔɔ kaaɗ kɛn naan̰ aan kaan kic lɛ, naan̰ saap do ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Debm tɛɗn naabm bin se, kɛn mɛlin̰ jaay aanga num, utu an̰ tuur naata ɔɔ an̰ kɔlin̰ Ꞌdabar ute jeegen tɛɗ roɗe aan gɔɔ jee taaɗ taar mɛt ki. Ɔɔ gɔtn se ɓo gɔtn naaɗe tɔɔyɔ ɔɔ taan̰ naaŋɗege.» ");
INSERT INTO kyq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tɛr Isa aal naagŋ taara ɗeek ɔɔ: «Maakŋ *Gaar Raa se, naan̰ tec aan gɔɔ gaan mɛndgen sik tɔs lɔɔmpɗege ɔɔ teec ɓaa dɔɔɗn gaabm ɓaa kɔkŋ mɛnda. ");
INSERT INTO kyq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Num maakŋ gaan mɛndge tun sik se, jee mii se mɛnd dɛrlge ɔɔ kɛngen kuuy mii se mɛnd mɛtɛkge. ");
INSERT INTO kyq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mɛnd dɛrlge se, tɔs ɓaan te lɔɔmpɗege ɔk uubu maak ki, naɓo uun te zaaɗn uubm kuuy ey sum. ");
INSERT INTO kyq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gaŋ mɛndgen mii mɛnd mɛtɛkge se tɔs ɓaan te lɔɔmpɗege ɔk uubu maak ki ɔɔ tɛr ɔk maakŋ nakge tun kuuy do ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aan gɔɔ gaabm mɛnda lɛ aan yɔkɔɗ ey ɗey se, gaan mɛndgen se bi ɓaa tɔɔlɗe ɔɔ naaɗe paac tooɗ bia. ");
INSERT INTO kyq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kɛn aan daan ɓee se kꞋbooy nam baag taaɗn makɔn̰ ɔɔ: ꞋBooyki! Gaabm mɛnda se, ɓɛrɛ, aanga. ꞋTeec ɓaa Ꞌdɔɔɗin̰ki! ");
INSERT INTO kyq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gɔtn se gaan mɛndgen sik se paac iin̰ duru ɔɔ tɔɔc tɔl tɔnd ɗaap lɔɔmpɗege. ");
INSERT INTO kyq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Num gaŋ mɛnd dɛrlge se tɔnd mɛtn mɛnd mɛtɛkge se ɔɔ: ‹Ɛɗjekiro uubsege se cɔkɔ, ey num lɔɔmpjege se uubin̰ ɓaa ɓaa naŋa.› ");
INSERT INTO kyq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gaŋ mɛnd mɛtɛkge se tɛrlɗen ɔɔ: ‹A‑a, uubu se ajenki kɔŋ kaasn kꞋpaacki eyo! Naase Ꞌɓaa Ꞌdugkiro gɔtn jee zoge tu.› ");
INSERT INTO kyq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kaaɗ kɛn mɛnd dɛrlge se iin̰ ɓaa gɛn dugŋ uubu se, gaŋ gaabm mɛnda se iin̰ aana. Ɔɔ naan̰ ɔŋ gaan mɛndgen mɛnd mɛtɛkge se iŋg aak kaak kaamin̰a. Naan̰ ɛnd ute naaɗe maakŋ ɓee mɛnd mɔrɔb ki se ɔɔ kɛn naaɗe jaay ɛnd se, kaam‑taara se kꞋgaasin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cɔkɔ se, mɛnd dɛrlge se aana ɔɔ baag tɔnd kaam taara ɗeek ɔɔ: Mɛlje, Mɛlje, ɔɔɗjen kaam taara! ");
INSERT INTO kyq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gaŋ naan̰ tɛrlɗen ɔɔ: ꞋBooyki bɛɛ mꞋasen taaɗa: ɓɛrɛ, maam se mꞋjeelsen eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tɛr Isa taaɗɗen ɔɔ: «Taa naan̰ se ɓo, iŋgki zɛɛrɛ! Taa ɓii ute kaaɗn maam mꞋano ɓaa se, naase Ꞌjeelki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Tɛr daala, kɛse tec aan gɔɔ debm ɓaa ɓaa mɛrtɛ jaay daŋ tus jee tɛɗn naabin̰ge ɔɔ ɔn̰ɗen maalin̰ paac se kaam jiɗe. ");
INSERT INTO kyq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Deb kalaŋ naan̰ ɛɗin̰ gɔkɔl daab magal magal mii, debm kuuy naan̰ ɛɗin̰ gɔkɔl daab magal magal dio, ɔɔ kɛn kuuy naan̰ ɛɗin̰ gɔkɔl daab magal kalaŋ. Naŋa kic ɓo naan̰ ɛɗin̰ kaam do ron̰ ron̰a, jaay ɓo naan̰ naar iin̰ ɓaa gɔtn mɛrtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Debm jꞋɛɗin̰ gɔkɔl daab magal magal mii se, naan̰ naar ɓaa tɛɗin̰ oojo gɔkɔl daab magal magal kuuy mii do ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Debm jꞋɛɗin̰ gɔkɔl daab magal magal di se, naan̰ kic ɓaa tɛɗin̰ oojo gɔkɔl daab magal magal kuuy di do ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Naɓo debm kɛn mɛlin̰ ɛɗin̰ gɔkɔl daab magal kalaŋ se, naan̰ ɓaa uɗ gɔɔ duubin̰ naaŋ ki, nam jeel gɔtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Gɔtn mɛrtin̰ ki se, mɛlɗe se ɓaa iŋgoga dɛn jaay ɔk tɛrl ɓaaɗo. Ɔɔ kɛn naan̰ jaay aan se, daŋ tɔnd mɛtɗe do gɔkɔl daabge tun magal magal kɛn naan̰ nigɗesin̰ se. ");
INSERT INTO kyq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Debm kɛn jꞋɛɗin̰ gɔkɔl daab mii se iiko cɛɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: ‹Mɛluma, naai ɛɗumo gɔkɔl daab mii ɔɔ maam mꞋtɛɗin̰ oojga kɛn kuuy mii do ki daala.› ");
INSERT INTO kyq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mɛlin̰ ɗeekin̰ ɔɔ: ‹Kɛse jiga. Naai se debm tɛɗn naabm bɛɛ ɔɔ tuj ɔrmi ey se. Ute nakŋ maam mꞋɛɗi cɔkɔ se kic, naai tuj te ɔrmi ey se; ɓɔrse maam mꞋai kɛɗn nakge dɛna kaam ji. ꞋƁaaɗo Ꞌtɛɗ maak‑raapo ute maama.› ");
INSERT INTO kyq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Debm kɛn jꞋɛɗin̰ gɔkɔl daab di se kic iiko cɛɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: ‹Mɛluma, naai ɛɗumo gɔkɔl daab dio ɔɔ maam mꞋtɛɗin̰ oojga kɛn kuuy di do ki daala.› ");
INSERT INTO kyq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mɛlin̰ ɗeekin̰ ɔɔ: ‹Kɛse jiga! Naai se debm tɛɗn naabm bɛɛ ɔɔ tuj ɔrmi ey se. Ute nakŋ maam mꞋɛɗi cɔkɔ se kic, naai tuj te ɔrmi ey se; ɓɔrse maam mꞋai kɛɗn nakge dɛna kaam ji. ꞋƁaaɗo Ꞌtɛɗ maak‑raapo ute maama.› ");
INSERT INTO kyq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Debm kɛn jꞋɛɗin̰ gɔkɔl daab kalaŋ se, naan̰ kic iiko cɛɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: ‹Mɛluma, maam mꞋjeele naai se debm aali ɔɔn̰ɔ. Maakŋ‑gɔtn naai ɔɔc te ey kic ɓo, naai ɔj naai ki ɔɔ gɔtn naai duub te ey kic ɓo, naai ɔjɔ. ");
INSERT INTO kyq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bin num maam se ɓeere ɔkuma. Taa naan̰ se ɓo gɔkɔl daabi kɛn naai ɛɗumsin̰ se, maam mꞋɓaa duubin̰o naaŋ ki ɔɔ ɓɔrse ara ɔk naki.› ");
INSERT INTO kyq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Gaŋ mɛlin̰ tɛrlin̰ ɔɔ: ‹Naai se debm tɛɗn naabm jig eyo ɔɔ debm kaar naaba! Naai Ꞌjeelum maam se maakŋ‑gɔtn maam mꞋɔɔc te ey kic ɓo, maam mꞋɔjɔ ɔɔ gɔtn maam mꞋduub te ɗim ey kic lɛ, maam mꞋɔj maam ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bɛɛki num, gɔkɔl daabum se, naai an̰o kɔmb maakŋ baŋki ki; ɔɔ kɔr maam mꞋaɗe tɛrl se, mꞋan̰ kɔŋin̰ am koojn̰ ziiɗn do ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Gɔkɔl daabm jin̰ ki se, uunin̰ki ɔɔ ɛɗin̰ki deb kɛn ɔk gɔkɔl daabge sik se. ");
INSERT INTO kyq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Taa, debm kɛn ɔk se, jꞋan̰ kɛɗn do ki, taa nakin̰ an̰ ziiɗn tɛɗn dɛna. Num gaŋ debm ɔk ey se lɛ, kɛn naan̰ ɔk cɔkɔn se kic ɓo, jꞋan kuun naatn. ");
INSERT INTO kyq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Num debm tɛɗn naabm jaay tɔɔl sɛr ey se, ɔk undin̰ki naatn maakŋ gɔt kɛn ɔɔɗɔ. Ɔɔ gɔtn se ɓo gɔtn tɔɔyɔ ɔɔ gɔtn taan̰ naaŋa.›» ");
INSERT INTO kyq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Isa ɗeek daala ɔɔ: «Ɓii kɛn maam *mꞋGoon Deba mꞋaɗe bɔɔy maakŋ gaarum ki ute kɔɗumge paac se, maam mꞋutu mꞋkiŋg do kaag do gaarum ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jee do naaŋ ki paac tus naanum ki ɔɔ maam mꞋaɗen nigŋ aan gɔɔ debm gaam nigŋ baatin̰ge ute bɛn̰in̰ge se. ");
INSERT INTO kyq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Baatge se, maam mꞋaɗen kɔl do ji daamum ki ɔɔ bɛn̰ge se lɛ, do ji jeelum ki. ");
INSERT INTO kyq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Gɔtn se maam gaarge mꞋɗeekŋ jeege tun do ji daamum ki mꞋɔɔ: ‹ꞋƁaakiro, naasen kɛn Bubum tɛɗsenga tɛɗn bɛɛn̰ se; ɛndki maakŋ gaarin̰ kɛn naan̰ ɗaapsesin̰ga ɗaap do dɔkin̰a, kaaɗ kɛn naan̰ utu aalo kaal do naaŋa se. ");
INSERT INTO kyq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Taa maam ɓo tɔɔlumo ɔɔ naase ɛɗumkiroga kɔsɔ; maane tɔɔlumo ɔɔ naase ɛɗumkiroga mꞋaayga; mꞋiŋgoga mɛrtɛ gɔtse ki ɔɔ naase ɔkumkiroga jiga. ");
INSERT INTO kyq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kɛn maam mɛt‑beere, naase ɛɗumkiroga kal kuusu. Kɛn maam mꞋkɔɔn̰o naase Ꞌɓaa aakumkiroga. Kɛn maam jꞋɔkum daŋgay ki, naase Ꞌɓaa aakumkiroga.› ");
INSERT INTO kyq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Gaŋ jeegen tɛɗo nakŋ ute ɗoobin̰ se utu an̰ tɛrl ɔɔ: ‹Mɛlje, nuŋ ki jaay naaje kꞋjꞋaakio naai ɓo tɔɔlio jaay kꞋjꞋɛɗio kɔsɔ se? Ey lɛ kɛn maane tɔɔlio jaay kꞋjꞋɛɗio maan kaaye se? ");
INSERT INTO kyq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naai iŋgo mɛrtɛ gɔtje ki nuŋ ki jaay naaje kꞋjꞋɔkkio jiga se? Ey lɛ nuŋ ki jaay naaje kꞋjꞋaakio naai Ꞌmɛt‑beere jaay naaje kꞋjꞋɛɗio kal tuusu se? ");
INSERT INTO kyq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nuŋ ki jaay naai ooco kɔɔn̰ɔ ey lɛ maakŋ daŋgay ki, jaay naaje kꞋɓaaɗo kꞋjꞋaakkiga se?› ");
INSERT INTO kyq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Gɔtn se gaarge aɗen tɛrl ɔɔ: ‹ꞋBooyki bɛɛ mꞋasen taaɗa: maakŋ gɛnaamge tun se debm baat aan gɔɔ ɗi kic jaay, naase Ꞌtɛɗin̰kiroga bɛɛ se, kɛse gɔɔ Ꞌtɛɗin̰kiro maam ki.› ");
INSERT INTO kyq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Tɛr gaarge utu ɗeekŋ jeege tun do ji jeelin̰ ki se ɔɔ: ‹Iikki naatn cɛɛm ki dɔkɔ, naasen jee *Raa naamsenga naam se! ꞋƁaaki maakŋ pooɗ kɛn gɛn daayum kɛn Raa tɛɗin̰ gɛn *Ɓubm sitange ute kɔɗin̰ge. ");
INSERT INTO kyq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Taa maam ɓo tɔɔlumo ɔɔ naase ɛɗumkiro te kɔs eyo; maane tɔɔlumo ɔɔ naase ɛɗumkiro te maan kaay eyo. ");
INSERT INTO kyq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Maam mꞋiŋgo mɛrtɛ gɔtse ki ɔɔ naase dɔɔɗ ɔkumkiro te eyo. Maam mɛt‑beere ɔsumo kic ɓo, naase ɛɗumkiro te kal kuus eyo; kɛn mꞋooco kɔɔn̰ɔ ɔɔ jꞋɔkumo daŋgay kic ɓo, naase Ꞌɓaa aakumkiro te eyo.› ");
INSERT INTO kyq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Gaŋ jee do ji jeelin̰ ki utu an̰ tɛrl ɔɔ: ‹Mɛlje, nuŋ ki jaay kɛn naaje kꞋjꞋaaki naai ɓo tɔɔlio, ey lɛ maane tɔɔlio, kɛn mɛrtɛ, kɛn mɛt‑beere, kɔɔn̰ɔ ey lɛ maakŋ daŋgay ki, jaay naaje kꞋɓaaɗo kꞋnaaki te ey se?› ");
INSERT INTO kyq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Gɔtn se naan̰ utu aɗen tɛrl ɔɔ: ‹ꞋBooyki bɛɛ mꞋasen taaɗa: maakŋ gaange tun sɛɛm se, debm baat aan gɔɔ ɗi kic jaay naase Ꞌtɛɗin̰kiro te bɛɛ ey se, kɛse gɔɔ naase Ꞌtɛɗumkiro te maam ki eyo.› ");
INSERT INTO kyq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jee do ji jeelin̰ ki se utu ɓaa tiŋg maakŋ dubar ki gɛn daayum, ɔɔ jeegen kɛn tɛɗ nakgen ute ɗoobin̰ se lɛ, kɔŋ *kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kɛn Isa jaay dooy jeege aas sum se, naan̰ taaɗ jeege tun mɛtin̰ ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ꞋJeelki *laa Paak gɛn Yaudge se ɔɔpga ɓii di sum ɓo Ꞌkaana ɔɔ *Goon Deba se jꞋutu jꞋan̰ kɔkŋ kɔl ji jeege tu ɔɔ naaɗe an̰ ɓaa tupm tɔɔl ro kaag ki.» ");
INSERT INTO kyq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu ɔɔ magal taa ɓee Yaudge tus maakŋ ɓee magal debm tɛɗn sɛrkɛ Raa ki kɛn ron̰ Kayip se, ");
INSERT INTO kyq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","naaɗe tus dɔɔk taarɗe je ɗoobm an̰ goon̰ kɔkŋ Isa taa an̰ ɓaa tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naaɗe taaɗ ute naapa ɔɔ: «JꞋɔn̰te kɔkin̰ki ɓii laa ki, ey num jeege kiin̰ gɛn tɛɗn taara ɔɔ gɔtɔ tuju.» ");
INSERT INTO kyq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kaaɗ kɛn Isa Betani ki maakŋ ɓee Simon kɛn kꞋdaŋin̰ debm bikiɗi se, ");
INSERT INTO kyq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mɛnda kalaŋ ɓaaɗo ɔŋin̰a. Naan̰ se ɔk naka kalaŋ aan gɔɔ k‑ɓɔkɔlɔ, nakŋ se ko ɓo kꞋcɔɔc kꞋɗaapin̰a. K‑ɓɔkɔl se kꞋdaŋin̰ albatir. Ɔɔ itir maak ki se itir salal ɔɔ ɔɔn̰ɔ. Naan̰ ɓaaɗo ɔɔyin̰ do Isa ki, kaaɗ kɛn Isa iŋg ɔs kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kɛn jee mɛtin̰ ki jaay aak nakŋ mɛnd se tɛɗ se, maakɗe tuju ɔɔ baag taaɗn ute naapa ɔɔ: «Gɛn ɗi jaay itir se naan̰ tujin̰ bin se? ");
INSERT INTO kyq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Itir se jꞋan̰ dugin̰ te zo ɔɔn̰ɔ ɔɔ gursin̰ se jꞋan̰ nigin̰ jee daayge tu.» ");
INSERT INTO kyq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kɛn Isa jaay booy taarɗe se, naan̰ ɗeekɗen ɔɔ: «Gɛn ɗi jaay naase Ꞌtɛrɛcki mind mɛnda se? Nakŋ naan̰ tɛɗum maam ki se, kɛse nakŋ jiga. ");
INSERT INTO kyq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jee daayge se daayum utu te naase. Num gaŋ maam se, daayum mꞋkɔŋ kiŋg te naase eyo. ");
INSERT INTO kyq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Itir mɛnd ɔɔyum rom ki se, ɗaapumga roma gɛn kɛnd maakŋ ɓaaɗ ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ꞋBooyki bɛɛ, mꞋasen taaɗa: do naaŋa ute magalin̰ se gɔtn gay gay kic ɓo, kɛn jeege utu Ꞌtaaɗn Labar Jiga se, nakŋ kɛn mɛnd se jaay tɛɗum se, jeege paac utu kɔɔsn maanin̰a ɔɔ saapm do nak kɛn naan̰ tɛɗ ese se.» ");
INSERT INTO kyq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tɛr Judas Iskariɔt, naan̰ maakŋ jee mɛtn Isa kɛn sik‑kaar‑di se, ɓaa ɔŋo *magal jee tɛɗn sɛrkɛ Raage tu, ");
INSERT INTO kyq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɔɔ ɗeekɗen ɔɔ: «Kɛn maam mꞋɔk mꞋɛɗsenga Isa num, naase amki kɛɗn ɗio?» Gɔtn se naaɗe mɛɗ ɛɗin̰ gurs tamma si‑mɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naan̰ kɛn se sum ɓo Judas baag je ɗoobm an kutn Isa. ");
INSERT INTO kyq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ɓii deet deetn gɛn laa mappan ɔk ɔrɔm ey se, jee mɛtn Isa ki ɓaaɗo tɔnd mɛtin̰ ɔɔ: «Kɔsn gɛn laa Paak se, naai Ꞌje jꞋaisin̰ tɛɗn kaam gay?» ");
INSERT INTO kyq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Isa ɗeekɗen ɔɔ: «ꞋƁaaki maakŋ gɛgɛr ki, gɔtn gaab ki kalaŋ bini ɔɔ ɗeekin̰ki ɔɔki: ‹Debm dooyje ɗeek ɔɔ ɓɛrɛ, kaaɗin̰ ɔɔpga gɔɔrɔ ɔɔ naan̰ ute jee mɛtin̰ ki se je ɓaa tɛɗn laa Paak se ɓei ki.›» ");
INSERT INTO kyq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jee mɛtin̰ ki ɓaa tɛɗin̰ aan gɔɔ kɛn Mɛlɗe taaɗɗeno ɔɔ naaɗe ɓaa tɛɗ kɔsn gɛn laa Paak se gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kɛn aan do tɛgɛr gɔtɔ ɓaa ɔk jin̰ se, Isa ute jee mɛtin̰ kɛn sik‑kaar‑di se ɓaaɗo iŋg ɔs do tabil ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kaaɗ kɛn naaɗe iŋg ɔs kɔs se, Isa ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: maakse ki se, deb kalaŋ utu am kutu.» ");
INSERT INTO kyq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gɔtn se jee mɛtin̰ ki se maakɗe tuj kasak kasak ɔɔ naŋa naŋa kic ɓo baag tɔnd mɛtn Isa ɔɔ: «Mɛluma, lɔ nakŋ se tɛɗn maam lɛ?» ");
INSERT INTO kyq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isa tɛrlɗen ɔɔ: «Debm kɛn ɔl jin̰ maakŋ baay ki ute maam se, naan̰ ɓo debm utu am kutu. ");
INSERT INTO kyq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɗeere, *Goon Deba se, utu Ꞌkooy aan gɔɔ kɛn *Raa taaɗno maakŋ Kitap ki, num gaŋ ɔɔn̰ deb kɛn an̰ kut se! Debm bin se kɛn jꞋoojin̰ te ey kic ɓo bɛɛ kaca.» ");
INSERT INTO kyq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, naan̰ ɓo debm kɛn utu kutn Isa se, tɔnd mɛtin̰ ɔɔ: «Debm dooyje, lɔ nakŋ se tɛɗn maam lɛ?» Ɔɔ Isa tɛrlin̰ ɔɔ: «Aan gɔɔ kɛn naai ɗeekin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaaɗ kɛn naaɗe ɔs kɔs se, Isa uun mappa jin̰ ki, tɔɔm Raa ɔɔ dup ɛɗin̰ jeege tun mɛtin̰ ki ɗeekɗen ɔɔ: «Ɔk ɔski, kɛse roma.» ");
INSERT INTO kyq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tɛr naan̰ uun *kɔɔp ɗooc te tɔtn koojn̰ kaagŋ kꞋdaŋin̰ bin̰ se jin̰ ki, tɔɔm Raa ɔɔ ɛɗɗesin̰a, ɗeekɗen ɔɔ: «Paacki se, naŋa naŋa kic ɓo ɔk aaye aaye, ");
INSERT INTO kyq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kɛse moosuma kɛn taaɗ ɔɔ *Raa dɔɔkga ute naase. Moosn se ɔɔy taa jee dɛna, taa Raa aɗen tɔɔl *kusin̰ɗege. ");
INSERT INTO kyq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ꞋƁooyki mꞋasen taaɗa: tɔtn ese se, mɔɔtn maam mꞋkaay ey sum, bini mꞋɓaa kaay tɔtn koojn̰ bin̰ kiji ute naase se maakŋ gaar Bubum ki jaay sum.» ");
INSERT INTO kyq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kɛn naaɗe aar kaa gɛn keem Raa aas se, naaɗe teec ɓaa ook do *kɔsn ɔlib ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kɛn naaɗe utu ɓaa ɓaa sum ɓo, Isa taaɗ jeege tun mɛtin̰ ki ɔɔ: «Maakŋ nɔɔr kɛn jaaki se, naase paacki utu amki kaan̰ rɛsɛ. Taa Raa taaɗga taaɗ maakŋ Kitapin̰ ki ɔɔ: Maam mꞋutu mꞋtɔɔl debm gaam baatge, ɔɔ baatin̰ge se lɛ utu Ꞌkaan̰ wɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Num kɛn maam jaay mꞋooy mꞋduroga num, maam mꞋkɔnd naana mꞋasen ɓaa booy taa naaŋ Galile ki.» ");
INSERT INTO kyq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gɔtn se Piɛr ɗeekin̰ ɔɔ: «Kɛn jee mɛti ki jaay rɛsi paac kic ɓo, maam se mꞋai kɔŋ rɛs eyo!» ");
INSERT INTO kyq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isa tɛrlin̰ ɔɔ: «ꞋƁooy bɛɛ mꞋai taaɗa: maakŋ nɔɔr kɛn jaaki se, kɔr kɔrɔn̰jɔ Ꞌkɔɔy ey sum ɓo, naai am Ꞌbaatn ɗɔɔl mɔtɔ Ꞌɗeekŋ ɔɔ Ꞌjeelum eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piɛr ɗeekin̰ ɔɔ: «Maam se kɛn am kaan te yoa kic ɓo, mꞋai baati eyo!» Ɔɔ jee mɛtin̰ kɛn kuuy se kic ɓo paac taaɗ aan gɔɔ gɛn Piɛr se. ");
INSERT INTO kyq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Gɔtn se Isa ute jeegen mɛtin̰ ki aan gɔt kɛn kꞋdaŋin̰ Getsemane ki se ɔɔ naan̰ ɗeekɗen ɔɔ: «Iŋgki gɔtn ara, kɔr maam mꞋkiikŋ cɔkɔ mꞋaɗe ɓaa tɔnd mɛtn Raa se.» ");
INSERT INTO kyq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naan̰ ɔk ɓaan ute Piɛr ɔɔ gaan Zebedege dio, gɔtn se maakin̰ baag tuju ɔɔ taar maakin̰ ki naŋ tak. ");
INSERT INTO kyq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gɔtn se naan̰ ɗeekɗen ɔɔ: «Maam se maakum tujga ɔɔ nirlum teecga aan gɔɔ mꞋaki kooyo. Anum naase se iŋgki gɔtn ara; ɔɔ ɔn̰ten Ꞌtooɗki bia, iŋgki zɛɛrɛ ute maama.» ");
INSERT INTO kyq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naan̰ iin̰ iik naan ki cɔkɔ se, ɓaa ɛrg ɔnd naanin̰ naaŋ ki ɔɔ baag tɔnd mɛtn Raa ɗeek ɔɔ: «Bubuma, kɛn naai Ꞌje num iikum *kɔɔpm dubar se rom ki naata! Naɓo Ꞌtɛɗ aan gɔɔ kɛn naai maaki jea, num aan gɔɔ kɛn maam ɓo mꞋje se eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kɛn naan̰ ɔk tɛrl ɓaaɗo ɔŋ jee mɛtin̰ kɛn mɔtɔ se, tooɗ tooɗ bia, ɔɔ naan̰ ɗeek Piɛr ki ɔɔ: «Lɛr kalaŋ kic ɓo naase ɔŋ aasin̰ki te gɛn kiŋg zɛɛr te maam ey ne? ");
INSERT INTO kyq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Naase iŋgki zɛɛrɛ, Ꞌtɔndki mɛtn Raa, taa naase aki koocn̰ maakŋ nakŋ naam ki eyo. Maakŋ debkilimi se je tɛɗn nakŋ bɛɛ, naɓo daa ron̰ ɓo ɔŋ aasin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tɛr naan̰ ɔk tɛrl gɛn k‑dige iik naan ki cɔkɔ daala ɔɔ ɓaa tɔnd mɛtn Raa ɔɔ: «Bubuma, kɔɔpm dubar se jaay naai amsin̰ kiik eyo ɔɔ kɛn mꞋan̰ kaay tak num ɔn̰ maakje naai ɓo Ꞌtɛɗa!» ");
INSERT INTO kyq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kɛn naan̰ ɔk tɛrlo daal se, ɓaaɗo ɔŋ jee mɛtin̰ ki tooɗ tooɗ bia ɔɔ kɛn bi ɔkɗe se, kaamɗe kic ɔŋ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Isa iin̰ ɔn̰ɗe kɛn naan̰ iik naan ki cɔkɔ se, naan̰ baag tɔnd mɛtn Raa gɛn k‑mɔtɔge, ɔɔ maakŋ tɔnd mɛtin̰ ki se naan̰ iŋg ɗɔɔl taar ese sum. ");
INSERT INTO kyq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tɛr naan̰ ɔk tɛrl ɓaaɗo ɔŋ jee mɛtin̰ ki ɔɔ ɗeekɗen ɔɔ: «Maakŋ tooɗn bise ki se naase utu Ꞌtooɗ Ꞌtɔɔlki tɔɔl kɔɔrse rɔk la? Bɛrɛ, bɛɛga, kaaɗin̰ aasga ɔɔ *Goon Deba se jꞋan̰ kɔkŋ kɔl ji jee tɛɗn kusin̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iin̰ki, kꞋɓaaki! Aakki, debm am kut se aanga.» ");
INSERT INTO kyq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kaaɗ kɛn Isa utu taaɗ naŋ te taarin̰ ey sum ɓo, gaŋ maakŋ jeege tun mɛtin̰ kɛn sik‑kaar‑di se, debm ron̰ Judas se aana. Naan̰ ɓaaɗo ute dɔɔl jeege dɛna mɛtin̰ ki kɛn ɔk gɔrɗ‑jɛrlɗege ɔɔ te sirɗɗege. Jee se *magal jee tɛɗn sɛrkɛ Raage tu ute magal taa ɓee Yaudge ɓo ɔlɗeno. ");
INSERT INTO kyq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, naan̰ ɓo debm utu kutn Isa se, taaɗoga taaɗ jeege tun ese se ɔɔ: «Debm jaay maam mꞋan̰ baam kɔkɔ ɔɔ mꞋkaay ciilin̰ se, kɛse ɓo naan̰a! Ɔkin̰ki.» ");
INSERT INTO kyq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas naar ɓaaɗo cɛɛ Isa ki ɔɔ ɗeekin̰ ɔɔ: «Debm dooyje, tɔɔsɛ!» Gɔtn se naan̰ baam ɔkin̰a ɔɔ aay ciilin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ɔɔ Isa tɛrlin̰ ɔɔ: «Mɛɗuma, nakŋ naai Ꞌɓaaɗo tɛɗa se, Ꞌtɛɗin̰a.» Gɔtn se jee dɛngen kꞋɓaaɗo tɛl se, iij‑ɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gaŋ kɛn Isa jaay jꞋɔkin̰ se, maakŋ jeege tun mɛtin̰ ki se, deb kalaŋ ɔɔɗo gɔrɗ‑jɛrlin̰a ɔɔ ɔg gaaŋ te bi debm tɛɗn naabm magal debm tɛɗn sɛrkɛ Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Gɔtn se Isa ɗeekin̰ ɔɔ: «Gɔrɗ‑jɛrli se Ꞌtɛrl ɔlin̰ maakŋ saapin̰ ki gɔtin̰ ki. Taa jeegen tɔɔl jeege ute gɔrɗ‑jɛrlɗege se, naaɗe jꞋutu jꞋaɗen tɔɔl ute gɔrɗ‑jɛrlɛge kici. ");
INSERT INTO kyq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Naai Ꞌjeel ey la, kɛn maam jaay mꞋtɔndga mɛtn Bubum num, naan̰ am naar naakŋ ute dɔɔl kɔɗin̰ge sik‑kaar‑di se? ");
INSERT INTO kyq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɛn bin ey num taar Kitap taaɗ se Ꞌkaan ɗoobin̰ ki ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naan̰ kɛn se Isa ɗeek jee dɛnge tu se ɔɔ: «Naase Ꞌteeckiro ute gɔrɗ‑jɛrlsege ɔɔ te sirɗsege jaay, Ꞌɓaamkiro kɔkɔ aan gɔɔ debm ɓoogo se. Ey num ɓii‑raa maam mꞋlee dooy jeege daan bɔɔr *Ɓee Raa ki se, naɓo naase ɔŋ ɔkumkiro te eyo. ");
INSERT INTO kyq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Num gaŋ nakŋ se jaay aan se, taa taar kɛn jee taaɗ taar teeco taar Raa ki raaŋin̰o maakŋ Kitap ki do dɔkin̰ se, Ꞌkaan ɗoobin̰ ki.» Gaŋ gɔtn se, jee mɛtin̰ ki paac baatin̰a ɔɔ aan̰ rɛsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jee ɔko Isa se ɓaansin̰o ɓee Kayip ki, naan̰ ɓo *magal debm tɛɗn sɛrkɛ Raa ki. Ɔɔ maakŋ ɓee naan̰ ki se ɓo jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal taa ɓee Yaudge ɓaaɗo tusn maak ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛr ɔko mɛtn Isa daanɗe goon dɔkɔ, daanin̰o bini aan daan bɔɔr ɓee magal debm tɛɗn sɛrkɛ Raa ki. Piɛr ɛndo ɓaa iŋg ute jee tɛɗn naabge, taa kaakŋ nakŋ kɛn utu Ꞌkaan do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anum magal jee tɛɗn sɛrkɛ Raage tu, ute magal Yaudgen kuuy paacn̰ jee kaakŋ mɛtn taarge se, naaɗe je tɔl taara do Isa ki taa an̰ kɔkŋ mindin̰ num jꞋan̰ ɓaa tɔɔlɔ, ");
INSERT INTO kyq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","naɓo naaɗe ɔŋ te taar ɗim eyo. Ey num saaɗge dɛna ɓaaɗo tɔlin̰ taar‑kɔɔɓɔ don̰ ki taa an̰ kɔkŋ mindin̰a. Cɔkɔ se maakŋ naaɗe ki se jeege di ɓaaɗo, ");
INSERT INTO kyq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɔɔ taaɗ ɔɔ: «Naaje kꞋbooyga gaabm ese se taaɗo ɔɔ: *Ɓee Raa se maam mꞋan̰ tɔɔkŋ naatn ɔɔ maakŋ ɓiige tun mɔtɔ sum ɓo mꞋan̰ kiin̰in̰ gɔtin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gɔtn se magal debm tɛɗn sɛrkɛ Raa ki se iin̰ ɗaara ɔɔ ɗeek Isa ki ɔɔ: «Naai tap ɓo Ꞌtɛrlɗen taar ɗim ey la do taarge tun naaɗe tɔli doi ki se?» ");
INSERT INTO kyq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Gaŋ Isa do ɗɛk ɔɔ tɛrlin̰ taar ɗim eyo. Tɛr magal debm tɛɗn sɛrkɛ Raa ki se taaɗin̰ daala ɔɔ: «Ute ro Raa zɛɛrɛ mꞋtɔnd mɛti, Ꞌtaaɗjen tu naai ɓo *al‑Masi, Goon Raa se la?» ");
INSERT INTO kyq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isa tɛrlin̰ ɔɔ: «Kɛse naai ɓo Ꞌɗeekin̰a. Naɓo Ꞌbooyki mꞋasen taaɗa: naan ki se, naase utu aki kaakŋ *Goon Deba se, iŋg kiŋg do ji daam Sidburku ki ɔɔ kɛn naan̰ aɗe bɔɔy se aɗe kiŋg do gapar ki.» ");
INSERT INTO kyq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gɔtn se magal debm tɛɗn sɛrkɛ Raa ki iin̰ nɛɛpm te kalin̰a ɔɔ ɗeek ɔɔ: «ꞋBooyki! Gaabm se naan̰ naaj Raa! Naase nakage kꞋjeki saaɗn nam kuuy se, gɛn ɗi daala! Naase lɛ Ꞌbooykiga te bise kɛn naan̰ naaj Raa se. ");
INSERT INTO kyq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anum naase Ꞌsaapki ɔɔki ɗi?» Jee dɛn se tɛrlin̰ ɔɔ: «Ɗeere, naan̰ se nakin̰ yoa!» ");
INSERT INTO kyq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Gɔtn se naaɗe tupin̰ ɓooro daan‑kaamin̰ ki ɔɔ tɔndin̰a. Jee kuuy se tɔndin̰ mɛtn bin̰ ki, ");
INSERT INTO kyq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɗeekin̰ ɔɔ: «Naai al‑Masi, debm kɛn taaɗ taar teeco taar Raa ki se, Ꞌtaaɗjen tu: debm kɛn tɔndi se, naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Naan̰ kɛn se, Piɛr ɔɔp iŋg naata daan bɔɔr ki. Gɔtn se mɛnda kalaŋ, mɛnd tɛɗn naaba, ɓaaɗo ɔŋin̰a ɔɔ ɗeekin̰ ɔɔ: «Ɓɛrɛ, naai kic ɓo debm Isan kɔɗ Galile.» ");
INSERT INTO kyq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gaŋ naan jeege tu paac se, naan̰ naaja ɗeek ɔɔ: «Taar naai Ꞌtaaɗ se lɛ, maam mꞋbooy mꞋɔk mɛtin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tɛr Piɛr iin̰ ɔn̰ gɔtn se ɔɔ ɓaa ɓaa kaam taa ɗoob kɛn magal se, mɛnd tɛɗn naabm kuuy aakin̰a ɔɔ ɗeek jeege tun gɔtn ese se ɔɔ: «Ɓɛrɛ, gaabm ese kic debm Isan kɔɗ Nazarɛt se!» ");
INSERT INTO kyq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gɔtn se Piɛr baag naaja daala ɔɔ naam taarin̰ ɔɔ: «Ɓɛrɛ, gaabm se maam mꞋjeelin̰ eyo!» ");
INSERT INTO kyq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kɛn naaɗe jaay iŋg cɔkɔ se, jeegen paacn̰ iŋg gɔtn ese se iiko cɛɛn̰ ki ɗeekin̰ ɔɔ: «Ɗeer ɗeer, naai se mɛtn naaɗe, taa taari taaɗ se kic ɓo tec gɛn naaɗe!» ");
INSERT INTO kyq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Gɔtn se Piɛr baag naam taarin̰ ɔɔ: «Ɓɛrɛ, maam mꞋnaam rom te Raa, mꞋtaaɗsen mꞋɔɔ: gaabm se maam mꞋjeelin̰ eyo!» Gaŋ gɔtn se sum ɓo kɔrɔn̰jɔ naar ɔɔɗ ɔɔyɔ. ");
INSERT INTO kyq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gɔtn se, Piɛr naar saap do taar kɛn Isa taaɗin̰o ɔɔ: «Kɔr kɔrɔn̰jɔ tɔɔy ey sum ɓo, naai am baatn ɗɔɔl mɔtɔ.» Gɔtn se naan̰ teeco ɔɔ baag keem gab gab. ");
INSERT INTO kyq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tanɔɔrin̰ nɔɔrin̰ se, *magal jee tɛɗn sɛrkɛ Raage tu paac, ute magal taa ɓee Yaudge tus dɔɔk taarɗe kalaŋ gɛn tɔɔl Isa. ");
INSERT INTO kyq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gɔtn se naaɗe ɔl jꞋɔk kꞋdɔɔk Isa ɔɔ naaɗe ɓaa ɛɗin̰ magal *Rɔmɛge tu, ron̰ Pilat. ");
INSERT INTO kyq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, debm kɛn ut Isa se, kɛn naan̰ jaay aak Isa jꞋɔkin̰ga gɛn ɓaa kutu se, gɔtn se naan̰ nirlin̰ teece. Gursn tamman si‑mɔtɔ kɛn jꞋɛɗin̰ se, naan̰ ɔk tɛrl ɓaa ɛɗin̰ *magal jee tɛɗn sɛrkɛ Raage tu ute magal taa ɓee Yaudge tu gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naan̰ ɗeekɗen ɔɔ: «Maam se mꞋtujga naan *Raa ki, kɛn mꞋkutn debm kɛn tuj te ɗim ey se!» Gaŋ naaɗe tɛrlin̰ ɔɔ: «ꞋƁaa tɛɗn gam naane, kɛse ɔljen naaje eyo!» ");
INSERT INTO kyq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Gɔtn se Judas ɓaa sin te gurs se maakŋ *Ɓee Raa ki ɔɔ naan̰ malin̰ ɓaa aal ooc ooyo. ");
INSERT INTO kyq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Magal jee tɛɗn sɛrkɛ Raage tu tɔs gursn se ɔɔ ɗeek ɔɔ: «Gursn se naaje jꞋɔkki ɗoobm jaay jꞋan̰ki kɔmb maakŋ Ɓee Raa ki eyo, taa gursn se, gursn ut ko debkilimi.» ");
INSERT INTO kyq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naaɗe tus dɔɔk taarɗe kalaŋ ɔɔ gursn se naaɗe ɓaa dugŋ maakŋ‑gɔtn debm kɔɓm dukulge ɔɔ maakŋ‑gɔtn se naaɗe ɔn̰in̰ gɔtn duubm mɛrtge. ");
INSERT INTO kyq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taa naan̰ se ɓo maakŋ‑gɔtn se ɓɔrse kic naaɗe utu daŋin̰ Maakŋ‑gɔtn ut ko debkilimi. ");
INSERT INTO kyq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bin ɓo taar kɛn debm taaɗ taar teeco taar Raa ki ron̰ Jeremi taaɗno do dɔkin̰ se, aanga ɗoobin̰ ki kɛn ɔɔ: Naaɗe took ɔkga tamman si‑mɔtɔ se, kɛse ɓo zo kɛn gaan *Israɛlge jen ro ki, ");
INSERT INTO kyq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɔɔ gursn se naaɗe dugŋ maakŋ‑gɔtn debm kɔɓ dukulge ɔɔ kɛse ɓo taar Mɛljege Raa ɔlum ɔɔ mꞋaɗen taaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isa kꞋjꞋɔk kꞋɓaansin̰ naan magal *Rɔmɛge tu ron̰ Pilat ɔɔ naan̰ tɔnd mɛtin̰ ɔɔ: «Naai ɓo Gaar Yaudge la?» Isa tɛrlin̰ ɔɔ: «Aan gɔɔ kɛn naai Ꞌɗeekin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu ute magal taa ɓee Yaudge ɔkin̰ mindin̰a, naɓo naan̰ tɛrlɗen taar ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gɔtn se Pilat se ɗeekin̰ ɔɔ: «Naai Ꞌbooy ey la taar naaɗe tɔli doi ki taa ai kɔkŋ mindi se?» ");
INSERT INTO kyq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naɓo do taarge tun kꞋtɔlin̰ don̰ ki se, taar ɗim tap ɓo Isa tɛrlin̰ te eyo. Kɛn magal Rɔmɛge jaay aakin̰ se paac ɓo, ɔkin̰ taaɗ ey paac paac. ");
INSERT INTO kyq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kɛn aanga *laa Paak gɛn Yaudge se tak ɓo, magal *Rɔmɛge se lee tɔɔɗ tɔlɗen tɔl debm daŋgay kalaŋ kɛn jee dɛnge jenga ro ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kaaɗ kɛn se, naaɗe ɔk debm daŋgay kalaŋ kɛn jeege jeelin̰ paac, ron̰ Isan Barabas. ");
INSERT INTO kyq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gɔtn se Pilat tɔnd mɛtn jee dɛngen tus se ɔɔ: «Naase Ꞌjeki mꞋasen kɔɔɗn kɔl naŋa: Isan Barabas lɔɓu Isan kꞋdaŋin̰ *al‑Masi se?» ");
INSERT INTO kyq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Taa Pilat se jeele kɛn naaɗe ɔk ɓaano ute Isa se, naaɗe tɛɗ tɛɗ maak‑kilimi ɓo ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kaaɗ kɛn Pilat utu gɔtn kɔjn̰ bɔɔr ki se, mɛndin̰ ɔlo jeege ɓaaɗo taaɗin̰ ɔɔ: «Gaabm ese se naan̰ debm bɛɛ ɔɔ tuj te ɗim eyo! Ɓɛrɛ, ɔn̰ten kɔl doi maakŋ taarin̰ ki taa maakŋ nɔɔr kɛn deel se, maakŋ nim ki se, maam mꞋdabarga dɛna taa naan̰a.» ");
INSERT INTO kyq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gaŋ *magal jee tɛɗn sɛrkɛ Raage tu ute magal taa ɓee Yaudge ɔl mɛtn jee dɛnge ɔɔ kꞋtɔnd mɛtn Pilat num aɗen kɔɔɗn kɔl Barabas ɔɔ Isa se lɛ, kꞋtɔɔlin̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Magal Rɔmɛge se ɛɛp taarin̰ daala ɔɔ: «Maakŋ naaɗe kɛn di se, Ꞌjeki mꞋasen kɔɔɗn kɔl naŋa?» Naaɗe tɛrlin̰ ɔɔ: «Barabasi.» ");
INSERT INTO kyq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat tɔnd mɛtɗe ɔɔ: «Num debm kꞋdaŋin̰ Isa al‑Masi se mꞋan̰ tɛɗn mꞋɔɔ ɗi?» Naaɗe paac tɛrlin̰ ɔɔ: «KꞋtup kꞋtɔɔlin̰ ro kaag ki!» ");
INSERT INTO kyq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat tɔnd mɛtɗe ɔɔ: «Naan̰ tap ɓo tujga ɗi?» Tɛr naaɗe dɔɔb ɔɔy makɔn̰ cir daala ɔɔ: «KꞋtup kꞋtɔɔlin̰ ro kaag ki!» ");
INSERT INTO kyq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kɛn Pilat jaay aak naan̰ Ꞌkɔŋ tɛɗn ɗim eyo, ɔɔ jeege lɛ tɔɔy dɔɔk taara ɔn̰ ey se, naan̰ uun maane, tug jin̰ naan jee dɛnge tu ɔɔ ɗeekɗen ɔɔ: «Yo gaabm se ɔlum maam eyo. Kɛse naase mala aakin̰ki!» ");
INSERT INTO kyq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jeege paac se tɛrlin̰ ɔɔ: «Ɔn̰ moosn naan̰ se ajen kɔɔpm mindje ki ɔɔ mind gɛnjege tu!» ");
INSERT INTO kyq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gɔtn se Pilat ɔl kꞋɓaa kꞋjꞋɔɔɗ jꞋɔlɗen Barabas. Gaŋ gɛn Isa se, naan̰ ɔl kꞋjꞋɔndin̰ ute mɛɛjɛ ɔɔ ɔk ɔlin̰ ji jeege tu taa jꞋan̰ ɓaa tupm tɔɔl ro kaag ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gɔtn se asgargen gɛn magal *Rɔmɛge ɔk ɓaan te Isa maakŋ ɓee magalɗe ki maak ki naane, ɔɔ gɔtn se dɔɔl asgarge paac ɓaaɗo tus ɔl gurugin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naaɗe tɔɔɗn te kalin̰ge naata ɔɔ uun uusin̰ kal kuuy aac boŋ. ");
INSERT INTO kyq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tɛr naaɗe uj ɗaapo jɛkɛ gɛn kɔrɔndɔ ɓaaɗo ɔndin̰ don̰ ki ɔɔ ɛɗin̰ naka aan gɔɔ naala ji daamin̰ ki. Gɔtn se naaɗe ɛrg naanin̰ ki ɔɔ tooyin̰ koogo mɛtin̰ ki ɔɔ: «ꞋTɔɔsɛ naai ki, Gaar Yaudge!» ");
INSERT INTO kyq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naaɗe tupin̰ ɓooro ron̰ ki ɔɔ uun kaagŋ tec naala se, tɔndin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kɛn naaɗe tooyin̰ koogo mɛtin̰ ki aas se, naaɗe ɔk ɔɔɗn naatn te kal aac boŋ kɛn naaɗe uusin̰o se, ɔɔ tuusin̰ kal naan̰ge gɔtin̰ ki, jaay ɔk ɓaansin̰ naata taa jꞋan̰ ɓaa tupm tɔɔl ro kaag ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kɛn asgarge ɔko Isa teecn̰sin̰o teec naatn maakŋ gɛgɛr ki se, naaɗe dɔɔɗ ute gaaba kalaŋ kɔɗ Sirɛn kꞋdaŋin̰ Simon. Naaɗe ɔkin̰ taa tɔɔgɔ gɛn kuun kaagŋ jꞋan̰ tupm Isa ro ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naaɗe ɔk ɓaansin̰ gɔt kɛn kꞋdaŋin̰ Golgota; Golgota se je ɗeekŋ ɔɔ: gɔtn kaaɗn do deba. ");
INSERT INTO kyq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Gɔtn se naaɗe ɛɗin̰ n̰Ꞌaay tɔtn koojn̰ bin̰ deep te ƴɔrlɔ, naɓo kɛn Isa jaay uum naamin̰ se, baate kaaye. ");
INSERT INTO kyq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kɛn naaɗe jaay tup tɔɔlo Isa ro kaag ki ɔɔ uun ɗaarin̰ raan se, kalin̰ge se naaɗe tɛɗin̰ salatia jaay ɓo nigin̰a ɔɔ debm oocin̰ga ɓo uunu uunu. ");
INSERT INTO kyq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tɛr naaɗe iŋg naaŋ ki gɔtn ese ɔɔ bɔɔb Isa. ");
INSERT INTO kyq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naaɗe raaŋ ɔlin̰ kaam don̰ ki mɛtn taar kɛn naaɗe tɔɔlsin̰ ro ki ɔɔ: Kɛse ɓo Isan, Gaar Yaudge se. ");
INSERT INTO kyq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Gɔtn se asgarge tup jee ɓoogge dio ro kaagge tu cɛɛ Isa ki se kici, deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji daamin̰ ki ɔɔ deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji jeelin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jee deel deel gɔtn se jaay ɗaar aakin̰ se, naaɗe siik doɗe ɔɔ naajin̰a, ");
INSERT INTO kyq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɗeek ɔɔ: «Naai ɓo kɛn ɔɔ tɔɔkŋ *Ɓee Raa ɔɔ an̰ kiin̰ kuuy daan ɓiige tun mɔtɔ se, aaj roi mala. Kɛn naai jaay Goon Raa num, Ꞌbɔɔyɔ do kaag ki se naata!» ");
INSERT INTO kyq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","*Magalgen jee tɛɗn sɛrkɛ Raage tu, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal taa ɓee Yaudge se kic, tooyin̰ koogo mɛtin̰ ki ɔɔ ɗeek ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Jee kuuy se, naan̰ aajɗenoga num ɔŋ aasin̰ gɛn kaajn̰ ro naan̰ malin̰ eyo! Naan̰ Gaar *Israɛlge ɗey se, n̰Ꞌbɔɔyɔ naatn ɓɔrse ro kaag ki ɔɔ naaje jꞋtookŋ kaal maakje don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Naan̰ ɔɔ aal maakin̰ do Raa ki, ɔɔ kɛn Raa jaay ɓo jen̰ ɗeer num, ɔn̰ ɓɔrse an̰ kaaja! Taa naan̰ taaɗga taaɗ ɔɔ: Maam se mꞋGoon Raa.» ");
INSERT INTO kyq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jee ɓooggen kꞋtup tɔɔlɗe do kaagge tun cɛɛsn Isa ki se kic ɓo naajin̰ bin kici. ");
INSERT INTO kyq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aan katar tir se, do naaŋa te magalin̰ se gɔtɔ ɓaa tɛɗ ilim dib bini aan katar do tɛgɛr ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aan katar do tɛgɛr ki se, Isa ɔɔɗ ɔɔy makɔn̰ ute taar naaŋin̰a ɔɔ: «Ɛli, Ɛli, lɛma sabaktani?» Taar se je ɗeekŋ ɔɔ: Raama Raama, naai Ꞌrɛsum gɛn ɗi? ");
INSERT INTO kyq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maakŋ jeege tun ɗaar gɔtn ese se kɛn booyin̰ naan̰ taaɗ bin se, jee mɛtin̰ge taaɗ ute naapa ɔɔ: «ꞋƁooyki tu, naan̰ daŋ daŋ *Ɛli.» ");
INSERT INTO kyq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Deb kalaŋ naar aan̰ ɓaa uuno naka kalaŋ kɛn uun maane, ɔlin̰ maakŋ tɔtn koojn̰ bin̰ kɛn mooyo jaay uun ɔlin̰ taa garɗ ki ɔɔ uun ɔlin̰ taar Isa ki taa n̰Ꞌsuubu. ");
INSERT INTO kyq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jee mɛtin̰ge ɔɔp se taaɗ ɔɔ: «Ɔn̰ki jaay sɔm jꞋutu jꞋan̰ kaaka kɛn Ɛli jaay utu aɗe ɓaa an̰ kaajin̰ se!» ");
INSERT INTO kyq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gɔtn se Isa ɔɔɗ ɔɔy makɔn̰ɔ daala ɔɔ ɔn̰ kon̰ teece. ");
INSERT INTO kyq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gɔtn se, kal deer kꞋgaaŋ maakŋ *Ɓee Raa se nɛɛpo raan bini aan naaŋ ki tak. Naaŋa tea ɔɔ liŋge tɔp pak pak. ");
INSERT INTO kyq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Taa ɓaaɗn jeegen *salal ooyga kooy do dɔkin̰ se tɔɔɗ kalɗe ki ɔɔ naaɗe duro daan yoge tu, ");
INSERT INTO kyq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ɔɔ teeco maakŋ ɓaaɗɗege tu. Ɔɔ kɛn Isa jaay ooy duro se, naaɗe ɓaa ɛnd maakŋ gɛgɛr kɛn salal Jeruzalɛm ki, ɔɔ jeege dɛna aakɗenga. ");
INSERT INTO kyq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kɛn bubm asgarge ute asgargen kuuy kɛn ɗaar bɔɔb Isa se, aak naaŋa tea ute nakgen deel paac se, ɓeere ɔkɗe taaɗ ɔɔ: «Ɗeer ɗeer, gaabm ara se Goon Raa!» ");
INSERT INTO kyq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gɔtn se mɛndge dɛna ɗaar dɔkɔ aak Isa. Mɛndgen se, baago kɔkŋ mɛtin̰ taa naaŋ Galile ki ɔɔ naaɗe tɛɗin̰o naaba. ");
INSERT INTO kyq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maakɗe ki se Mari kɛn iin̰o Magdala ki, Mari ko Jak ute gɛn Yusup ɔɔ ko gaan Zebedege. ");
INSERT INTO kyq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kɛn kaaɗa ɓaa ɓaa kooco se, gaaba kalaŋ debm maala, kɔɗ Arimate ron̰ Yusup ɓaaɗo. Naan̰ kic debm maakŋ jeege tun mɛtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Gaabm se ɓaa ɔŋ Pilat ɔɔ tɔnd mɛtin̰a taa an̰ kɔn̰ ro Isa se naan̰ an̰ ɓaa kɔl maakŋ iiɓ ki. Gɔtn se Pilat tooko undin̰ kulu ɔɔ kꞋbɔɔyin̰sin̰o. ");
INSERT INTO kyq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusup uun ro Isa se ɔɔ teelin̰ ute kal duubm kiji. ");
INSERT INTO kyq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naan̰ uun ɓaa ɔl aalin̰ maakŋ iiɓ kɛn jꞋɔŋ ko sum ɓo jꞋuɗ kꞋɗaapin̰a ɔɔ ɓaaɗn se lɛ kiji, ɔɔ dircil aalin̰ ko magal taar ki jaay ɓo naan̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari kɛn iin̰o Magdala ki ute Mari kuuy se, naaɗe utu iŋg dɔk cɔkɔ ute taa ɓaaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɓii kɛn Yaudge ɗaap ɗaap roɗe gɛn *ɓii sebit jaay deel se, mɛtbeen̰ki se, *magal jee tɛɗn sɛrkɛ Raage tu ute *Parizige tuso naapa ɓaaɗo ɔŋ Pilat, ");
INSERT INTO kyq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ɔɔ ɗeekin̰ ɔɔ: «Jaamus, naaje kꞋsaap jꞋɔŋga taar kɛn debm taar‑kɔɔɓm se taaɗo kaaɗ kɛn naan̰ utu zɛɛr se ɔɔ: ‹Maakŋ ɓiige tun mɔtɔ se maam mꞋutu mꞋaɗe dur daan yoge tu.› ");
INSERT INTO kyq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ꞋƊeek asgarge tu se, Ꞌbɔɔbm taa ɓaaɗa se bini kaan ɓii k‑mɔtɔge tu, ey num sɔm jee mɛtin̰ ki se aɗe ɓaa te an̰ ɓoogo ɔɔ taaɗn jeege tu ɔɔ: ‹Naan̰ duroga daan yoge tu!› Kɛn bin num taar‑kɔɔɓm naaɗe tɛɗ se Ꞌcir kɛn deete.» ");
INSERT INTO kyq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat ɗeekɗen ɔɔ: «Naase kic ɔkki asgarge kaam jise. Bin num ɔlɗeki asen bɔɔbm do ɓaaɗa aan gɔɔ kɛn naase Ꞌjenki ro ki.» ");
INSERT INTO kyq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naaɗe ɓaa ɗaap roɗe gɛn bɔɔbm do ɓaaɗa se, ɔɔ ko magal kɛn naaɗe dircil aalin̰ taa ɓaaɗ ki se, naaɗe gaasn taa ɓaaɗa tak tak tɛɗin̰ nakŋ kaakŋ jeele ro ko kɛn naaɗe gaasin̰ se ɔɔ ɔl asgarge ɗaar bɔɔbin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kɛn *ɓii sebit jaay deel se, ɓii dumas ki tanɔɔrin̰ nɔɔrin̰ se, Mari kɛn iin̰o Magdala ki ute Mari kɛn kuuy se, naaɗe ɓaa gɛn kaakŋ taa ɓaaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gɔtn ese sum ɓo naaŋa naar te makɔn̰ɔ ɔɔ kɔɗn Mɛljege bɔɔyo maakŋ raa ki ɓaaɗo dircil ko taa ɓaaɗ ki se ɔɔ iŋg do ki. ");
INSERT INTO kyq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naan̰ se ron̰ wɔɔr gɔtɔ aan gɔɔ maan aal wusuk wusuk ɔɔ kalin̰ kic ɓo raap lak lak aan gɔɔ kuubu. ");
INSERT INTO kyq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Anum asgargen ɗaar bɔɔb do ɓaaɗa gɔtn ese se, kɛn naaɗe aakin̰ se, ɓeere ɔkɗe se, roɗe ook marga jɛg jɛg ɔɔ si naaŋ ki aan gɔɔ jee ooyga kooyo. ");
INSERT INTO kyq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gaŋ *kɔɗn Raa se ɗeek mɛndge tu se ɔɔ: «Naase se, ɔn̰ten Ꞌɓeerki. Maam mꞋjeele naase Ꞌjeki je Isan kɛn kꞋtup kꞋtɔɔlin̰ ro kaag ki se. ");
INSERT INTO kyq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɓɛrɛ, gɔtn ara se naan̰ gɔtɔ! Naan̰ se duroga daan yoge tu aan gɔɔ kɛn naan̰ mala taaɗo. ꞋƁaaɗo aakki gɔtn kɛn jꞋɔl jꞋaalsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ꞋNaar Ꞌɓaa Ꞌtaaɗki jeege tun mɛtin̰ ki ɔɔki: naan̰ se duroga daan yoge tu ɔɔ ɔndga naana asen ɓaa booy taa naaŋ Galile ki. Gɔtn naane se ɓo naase an̰ki Ꞌɓaa kaaka.» Kɛse ɓo taar mꞋtaaɗseno. ");
INSERT INTO kyq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ey num mɛndge ɓeere ɔkɗega, naɓo maakɗe raap aak eyo. Naaɗe iin̰ taa ɓaaɗ ki naar aan̰ ɓaa taaɗ labar se jeege tun mɛtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kɛn naaɗe jaay ɓaa ɓaa se, naaɗe aak Isa naar teeco piris naanɗe ki, ɗeekɗen ɔɔ: «ꞋTɔɔsɛ ki.» Gɔtn se, naaɗe iiko cɛɛn̰ ki, baam ɔk jɛn̰a ɔɔ ɛrg naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gɔtn se, Isa taaɗɗen ɔɔ: «Ɔn̰te Ꞌɓeerki! ꞋƁaa Ꞌtaaɗki gɛnaamge tu kꞋɓaa taa naaŋ Galile ki. Gɔtn naane ɓo, naaɗe utu am kaakŋ te kaamɗe.» ");
INSERT INTO kyq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kaaɗ kɛn mɛndgen ese iin̰o taa ɓaaɗ ki jaay ɔk tɛrlo tɛrlɛ aan te ey sum ɓo, gaŋ asgargen jee bɔɔbm do ɓaaɗa se, mɛtin̰ge ɓaa maakŋ gɛgɛr ki, ɔɔ ɓaa taaɗ *magal jee tɛɗn sɛrkɛ Raage tu nakgen deel paac se. ");
INSERT INTO kyq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kɛn magal jee tɛɗn sɛrkɛ Raage tu jaay booy taar se, daŋ tuso magal taa ɓee Yaudge. Naaɗe dɔɔk taarɗe kalaŋ, uun gurs dɛna ɔɔ ɛɗ asgarge tu, ");
INSERT INTO kyq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dɛjɗe ɔɔ: «ꞋƁaa Ꞌtaaɗki ɔɔki num: ‹Nɔɔr kaamje ɔk bi sum ɓo, jee mɛtin̰ ki ɓaaɗo ɓoog ɔɔɗ uun ɓaansin̰ga.› ");
INSERT INTO kyq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɔɔ kɛn taar se jaay oocga bi magal *Rɔmɛge tu kic ɓo, naaje jꞋan̰ kurl maakin̰a ɔɔ taar ɗim tap ɓo Ꞌkoocn̰ dose ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gɔtn se asgarge took uun gurs ɔɔ ɓaa taaɗ jeege tu aan gɔɔ taar kꞋdɛjɗeno se. Anum taar se Yaudge paac ɓaa booyin̰a ɔɔ ɓɔrse kic ɓo taar se jꞋutu kꞋlee kꞋtaaɗin̰ taaɗa. ");
INSERT INTO kyq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anum jee mɛtn Isa kɛn sik‑kaar‑kalaŋ se, naaɗe iin̰ ɓaa taa naaŋ kɛn Galile ɔɔ ɓaa ook do ko kɛn Isa taaɗɗen ɔɔ kꞋɓaa do ki se. ");
INSERT INTO kyq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kɛn naaɗe jaay aan do ko ki se, gɔtn se naaɗe aak Isa ɔɔ ɛrg naanin̰ ki. Naɓo maakɗe ki se, jee mɛtin̰ge maakɗe naaja. ");
INSERT INTO kyq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gɔtn se, Isa iiko cɛɛɗe ki ɔɔ ɗeekɗen ɔɔ: «*Raa ɛɗumga tɔɔgɔ do nakge tu paac kɛn maakŋ raa ki ɔɔ kɛn do naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ꞋƁaa Ꞌtaaɗki mɛtjil jeege tun do naaŋ ki se paac ɔɔ Ꞌtɛɗɗeki naaɗe tɛɗn jee mɛtum ki. *ꞋBatizɗeki ute ro Bubu, Goono, te *Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ꞋDooyɗeki naaɗe tookŋ kuun taar kɛn maam mꞋdooyseno paac se ɔɔ kiŋg do ki. Maam se, daayum mꞋutu te naase, bini ɓii kɛn dunia an naŋ ro ki.»");
INSERT INTO kyq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kupm mɛtn Labar Jiga gɛn Isa *al‑Masi, Goon *Raa. ");
INSERT INTO kyq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aan gɔɔ kɛn Ezayi debm taaɗ taar teeco taar Raa ki taaɗno maakŋ Kitapin̰ ki do dɔkin̰ kɛn ɔɔ: ꞋBooyo, maam mꞋai kɔl debm kaan̰ naabum naani ki taa ai ɗaapm ɗoobi. ");
INSERT INTO kyq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tɛr Ezayi ɗeek ɔɔ: KꞋbooy mind deba taaɗ makɔn̰ do kɔɗ‑ɓaar ki ɔɔ: ꞋƊaapki ɗoobm Mɛljege ɔɔ Ꞌtɛɗin̰sin̰ki jiga Ꞌtooɗn tal. ");
INSERT INTO kyq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗn se, naan̰ ɓo Jan‑Batist. Naan̰ naar teec naan jeege tu do kɔɗ‑ɓaar ki se. Gɔtn se naan̰ taaɗɗen ɔɔ: «ꞋTɛrlki maakse ɔɔ ɔn̰ jꞋasen batizi ɔɔ Raa asen tɔɔl *kusin̰sege.» ");
INSERT INTO kyq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jee taa naaŋ Jude ki paac ute jee paacn̰ iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki se, naaɗe ɓaaɗo gɔtn Jan ki. Naaɗe tɔɔɗ mɛtn kusin̰ɗege naan jeege tu ɔɔ Jan‑Batist batizɗe maakŋ ool magal kɛn kꞋdaŋin̰ Jordan se. ");
INSERT INTO kyq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan uuso kal kꞋɗaapin̰ ute bɛɛkŋ gin̰ji ɔɔ dɔɔk maakin̰ te kɔl daara; nakŋ kɔsin̰ iimi ute teeje. ");
INSERT INTO kyq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naan̰ taaɗ jeege tu ɔɔ: «Debm utu aɗe ɓaa mɛtum ki se, naan̰ magal ciruma. Maam se kɔl saan̰ kic ɓo mꞋaas gɛn no tuutin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Maam se mꞋbatizsenga ute maane, num gaŋ naan̰ se ɓo utu asen *batizn ute Nirl Salal.» ");
INSERT INTO kyq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Anum, maakŋ ɓiige tun se, Isa iin̰o maakŋ gɛgɛr kɛn Nazarɛt, kɛn taa naaŋ Galile ki, ɓaa ɔŋ Jan‑Batist ɔɔ Jan *batizin̰ maakŋ ool Jordan ki. ");
INSERT INTO kyq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kɛn Isa jaay teeco naatn maakŋ maane ki sum ɓo, aak maakŋ raa ɔɔɗ waŋ ɔɔ *Nirl Raa bɔɔyo don̰ ki tec aan gɔɔ dɛɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naan̰ booy mindi taaɗ maakŋ raa ki, ɗeek ɔɔ: «Naai se ꞋGoon maak‑jema, mꞋbɛɛr mꞋɔɔɗio taa naai Ꞌtɔɔlumi.» ");
INSERT INTO kyq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gɔtn se Nirl Raa naar tɔɔɗ ɔlin̰ do kɔɗ‑ɓaar ki. ");
INSERT INTO kyq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Naan̰ tiŋg ɓii si‑sɔɔ do kɔɗ‑ɓaar ki. Maakŋ ɓiige tun se, Bubm sitange ɓaaɗo naamin̰a. Naan̰ iŋg ute daagen maakŋ kaag ki ɔɔ *kɔɗn Raage ɓaaɗo ɔŋin̰a ɔɔ naaɗe aakin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kɛn Jan‑Batist kꞋjꞋɔkin̰ga daŋgay ki jaay ɓo Isa iin̰ ɓaa taa naaŋ Galile ki ɔɔ baag wɔɔkŋ Labar Jiga gɛn Raa se jeege tu ");
INSERT INTO kyq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ɔɔ: «Kaaɗin̰ aasga, Gaar Raa se ɓaaɗoga gɔɔrɔ. ꞋTɛrlki maakse ɔɔ aalki maakse do Labar kɛn Jiga.» ");
INSERT INTO kyq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kaaɗ kɛn Isa deel deel taa baar kɛn Galile ki se, aak Simon ute gɛnaan̰ Andre tund tund gɛndɗe maan. Naaɗe se jee toocn̰ kɛn̰jge. ");
INSERT INTO kyq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isa ɗeekɗen ɔɔ: «ꞋƁaakiro Ꞌdaanumki! Ɓɔrse maam mꞋasen tɛɗn naase jee ɓaa Ꞌje jikilimge aɗe ɓaa ɗoobm Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Naaɗe naar ɔn̰ gɛndɗege ɔɔ daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Utu iik naan ki cɔkɔ se, naan̰ aak Jak te gɛnaan̰ Jan; naaɗe se gaan Zebedege iŋg kiŋg maakŋ markabɗe ki, ɗaap ɗaap gɛndɗege. ");
INSERT INTO kyq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gɔtn se Isa naar daŋɗe. Naaɗe iin̰ ɔn̰ bubɗe Zebede maakŋ markab ki ute jee tɛɗn naabin̰ge ɔɔ naaɗe ɓaa mɛtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Isa ɛnd maakŋ gɛgɛr kɛn Kaparnayum ute jee mɛtin̰ ki. Ɔɔ kɛn *ɓii sebit jaay aan se naan̰ ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki ɔɔ baag dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jeegen booy taar kɛn naan̰ dooyɗe se, ɔkɗen taaɗ eyo. Taa dooy naan̰ se ɔk tɔɔgɔ ɔɔ tec aan gɔɔ gɛn jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se eyo. ");
INSERT INTO kyq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maakŋ ɓee kɛn Yaudge lee tusn maak ki se, debm ɔk kɔɔn̰ sitan naar ɛndo gɔtn se ɔɔ ɔɔɗ ɔɔyɔ, ");
INSERT INTO kyq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ɔɔ: «Naai Isan Nazarɛt. Naai tap ɓo naaje jꞋɔŋ ɗi ute naai? Naai se Ꞌɓaaɗo gɛn kutje la? Maam se mꞋjeeli, naai se Debm *Salal kɛn Raa ɓo ɔlio.» ");
INSERT INTO kyq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gaŋ Isa aacin̰ kaama ɔɔ: «ꞋƊoa! ꞋTeec naatn ro gaab kɛn se!» ");
INSERT INTO kyq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gɔtn se sitan baag tiikŋ gaaba se zak zak, ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ teec naatn ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jeege paac taar se ɔkɗen taaɗ eyo ɔɔ naaɗe tɔnd mɛtn naapa ɔɔ: «Kɛse tap ɓo taar ɔɔ ɗio? Kɛse dooy kiji ɔɔ naan̰ dooy jeege ute tɔɔgin̰ mala. Naan̰ taaɗ sitange tu ɔɔ sitange kic ɓo tookin̰ taarin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Gɔtn se nookin̰ naar eem dɔɔɗ taa naaŋ Galile ute magalin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kɛn naaɗe iin̰ teec naatn maakŋ *ɓee kɛn Yaudge lee tusn maak ki se sum ɓo, Isa ɓaa ɓee Simon te gɛn Andre ki. Jak ɔɔ Jan daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gɔtn se moom Simon mɛnda se kɔɔn̰ɔ, tooɗ tooɗ daŋal ki, naan̰ ron̰ ɔŋ kɛɗɛk. Kɛn Isa jaay aan se, jeege naar taaɗin̰ taa mɛnd se. ");
INSERT INTO kyq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Naan̰ iik cɛɛn̰ ki, ɔk jin̰a, uun ɗaarin̰a. Gɔtn se ron̰ kɛn ɔŋg kɛɗɛk se tɛrɛc urlu, naan̰ iin̰i ɔɔ baagɗen tɛɗn kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kɛn kaaɗa ooc jaay gɔtɔ tɛɗ ilim se, jeege baag ɓaano te jee kɔɔn̰ge ute jee ɔk kɔɔn̰ sitange paac. ");
INSERT INTO kyq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jeegen maakŋ gɛgɛr ki se paac tus taa ɓee kɛn ese. ");
INSERT INTO kyq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gɔtn se Isa ɛɗ lapia jee kɔɔn̰ge tu dɛna ɔɔ kɔɔn̰ɗege se naparin̰ dɛna. Ɔɔ naan̰ tuur sitange dɛna ro jeege tu. Gaŋ sitange se Isa ɔn̰ɗen ɗoobo gɛn taaɗn taar eyo, taa naaɗe se jeelin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mɛtbeen̰ki tanɔɔrin̰‑nɔɔrin̰ gɔt utu ilim sum ɓo, Isa iin̰ teec naatn maakŋ naaŋ kɛn se, ɓaa do kɔɗ‑ɓaar ki gɔtɔ kaam kalaŋ. Gɔtn se, naan̰ iŋg eem *Raa. ");
INSERT INTO kyq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ute mɛɗin̰ge teec ɓaa lee jen̰a. ");
INSERT INTO kyq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kɛn naaɗe jaay ɔŋin̰ se, ɗeekin̰ ɔɔ: «Jeege paac jei jea.» ");
INSERT INTO kyq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Isa ɗeekɗen ɔɔ: «KꞋɓaaki maakŋ naaŋge tun kuuy kɛn cɛɛs ki cɛɛs ki, mꞋɓaa taaɗn Labar Jiga gɔtn naane kici. Anum, taa naan̰ se ɓo maam mꞋteecn̰ mꞋɓaaɗo se.» ");
INSERT INTO kyq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naan̰ lee dɔɔɗ taa naaŋ Galile ute magalin̰a, taaɗɗen taar Raa maakŋ *ɓeeɗege tun kɛn naaɗe lee tusn maak ki ɔɔ naan̰ tuur sitange ro jeege tu. ");
INSERT INTO kyq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gaaba kalaŋ ɔk kɔɔn̰ bikiɗi ɓaaɗo cɛɛ Isa ki, ɛrg naanin̰ ki, eemin̰ nɔɔ ɔɔ ɗeekin̰ ɔɔ: «Kɛn naai Ꞌje num, ɛɗum lapia taa rom se ɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰.» ");
INSERT INTO kyq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isa aakin̰ se, ɛɛjin̰ don̰ ki, ɔl jin̰ utin̰a ɔɔ ɗeekin̰ ɔɔ: «Yɛɛ, maam mꞋjea, ɔn̰ roi ɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰!» ");
INSERT INTO kyq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gɔtn se sum ɓo, gaabm se bikiɗin̰ ɔn̰in̰a ɔɔ ron̰ ɗaap tooɗ kɔlɔn̰ kɔlɔn̰. ");
INSERT INTO kyq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Gɔtn se, Isa aacin̰ kaama ɔɔ naar tuurin̰a, ");
INSERT INTO kyq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ɔɔ ɗeekin̰ ɔɔ: «ꞋBooy bɛɛ: ɔn̰te ɓaa taaɗn nam ki. Num gaŋ Ꞌɓaa Ꞌtaaɗ roi *debm tɛɗn sɛrkɛ Raa ki ɔɔ ɛɗ *sɛrkɛ Raa ki aan gɔɔ kɛn *Musa taaɗin̰o maakŋ Kitap ki, taa naai roi ɗaapga tooɗga kɔlɔn̰ kɔlɔn̰ se. Bin ɓo jeege paac Ꞌjeele, naai se ɔŋga lapia.» ");
INSERT INTO kyq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Num kɛn gaabm se jaay iin̰ ɓaa se ɔɔ gɔtɔ ɓaa se paac naan̰ baag taaɗn labar nakŋ aanin̰ don̰ ki se jeege tu. Taa naan̰ se ɓo, naan jeege tu se Isa ɔŋ ɛnd te maakŋ gɛgɛr ki eyo, num ɓaa tiŋg do kɔɗ‑ɓaar ki ɔɔ jeege iin̰o gɔtɔ ɓaa se paac, ɓaaɗo ɔŋin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kɛn tɛɗ ɓii kandum se, Isa ɔk tɛrl maakŋ gɛgɛr kɛn Kaparnayum ki, kꞋbooy jꞋɔɔ naan̰ utu ɓeene. ");
INSERT INTO kyq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jeege ɓaaɗo tus dɛna ɛnd ɗooc maakŋ ɓee se tak, bini aan kaam taar ki kic ɓo gɔtɔ gɔtɔ. Gɔtn se Isa taaɗɗen taar *Raa. ");
INSERT INTO kyq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kaaɗ kɛn Isa utu taaɗ taaɗ ɓɔrt se, jeege ɓaano ute debm kꞋruŋguyu. Daanɗe ki se gaabge sɔɔ ɓo uunin̰o. ");
INSERT INTO kyq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Taa jeegen dɛn dɛn se, naaɗe ɔŋ ɓaansin̰ te gɔtn Isa ki eyo. Gɔtn ese naaɗe ook do ɓee ki, uɗ buut do ɓee kɛn Isa iŋg maak ki ɔɔ uun bɔɔyo debm kꞋruŋguyu do nakŋ tooɗin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kɛn Isa jaay aak naaɗe aal maakɗe don̰ ki se, ɗeek debm kꞋruŋguy ki ɔɔ: «Goonuma, *kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn.» ");
INSERT INTO kyq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gɔtn se jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kandum utu iŋg gɔtn ese jaay booy taar Isa taaɗ se, naaɗe taaɗ ute maakɗe ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Gaabm se, je taaɗn ɔɔ ɗio? Naan̰ naaj naaj Raa. Kɛn Ꞌkɔŋ tɔɔl kusin̰ deba se Raa kalin̰ ki sum ey la?» ");
INSERT INTO kyq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Num gaŋ taar naaɗe taaɗ ute maakɗe se, Isa naar jeelga ɔɔ ɗeekɗen ɔɔ: «Taa ɗi jaay naase Ꞌtaaɗki ute maakse bin se? ");
INSERT INTO kyq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gɛn naase ki num, kɛn gay ɓo ɔɔn̰ ciri: kɛn mꞋɗeekŋ debm kꞋruŋguy ki mꞋɔɔ: ‹Kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn› lɔɓu mꞋɗeekŋ mꞋɔɔ: ‹Iin̰i, uun nakŋ tooɗi se ɔɔ Ꞌlea› se ɓo ɔɔn̰ cir lɛ? ");
INSERT INTO kyq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bin num, naase aki Ꞌjeele maam *mꞋGoon Deba se mꞋɔk tɔɔgɔ gɛn tɔɔl kusin̰ jeege do naaŋ ki ara.» Gɔtn se, Isa ɗeek debm kꞋruŋguy ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«MꞋɗeeki mꞋɔɔ: iin̰i, uun nakŋ tooɗi ɔɔ Ꞌɓaa ɓei ki.» ");
INSERT INTO kyq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gaaba se naar iin̰ uun nakŋ tooɗin̰a ɔɔ teec naan jeege tun te dɛnɗe se. Jeegen iŋg aakin̰ se, nakŋ se ɔkɗen taaɗ eyo. Naaɗe tɔɔm Raa ɗeek ɔɔ: «Nakŋ bin se ɓii kalaŋ jꞋaak te eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isa ɔk tɛrl jɛŋ baar kɛn Galile ki daala. Jeege dɛna ɓaaɗo ɔŋin̰a ɔɔ naan̰ dooyɗe ute taar Raa. ");
INSERT INTO kyq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kɛn naaɗe deel deel gɔtn ese se, Isa uun kaamin̰ aak Lɛbi goon Alpe, *debm tɔkŋ miiri, iŋg kiŋg gɔtn tɛɗn naabin̰ ki. Naan̰ ɗeekin̰ ɔɔ: «Iin̰i Ꞌdaanuma.» Gɔtn se sum ɓo Lɛbi iin̰i ɔɔ daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɓii kalaŋ Isa ute jee mɛtin̰ ki iŋg ɔs kɔs ɓee Lɛbi ki se; *jee tɔkŋ miirge dɛna te jee *kusin̰ge se ɓaaɗo iŋg ɔs te naaɗe, taa jeege dɛna ɔko mɛtn Isa. ");
INSERT INTO kyq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raagen maakŋ *Parizige tu se aakin̰ naan̰ iŋg ɔs kɔs ute jee kusin̰ge ɔɔ te jee tɛɗn miirge se, ɗeek jeege tun mɛtin̰ ki ɔɔ: «Aakki tu naan̰ iŋg ɔs kɔs te jee tɔkŋ miirge ute jee kusin̰ge!» ");
INSERT INTO kyq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kɛn Isa jaay booy taarɗe se, ɗeekɗen ɔɔ: «Jee roɗe kiji se, naaɗe je daptor eyo, num kɛn jee je daptor se, jee kɔɔn̰ge. Maam mꞋɓaaɗo se gɛn daŋ jee kɛn saap ɔɔ naaɗe aak bɛɛ naan Raa ki se eyo, num maam mꞋɓaaɗo se gɛn jee jeel roɗe ki, naaɗe jee kusin̰ge se.» ");
INSERT INTO kyq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ɓii kalaŋ se jee mɛtn Jan‑Batist ki ute Parizige uun kuun *siam. Naaɗe ɓaaɗo tɔnd mɛtn Isa ɔɔ: «Jee mɛtn Jan ki ute gɛn Parizige se uun siam; anum gɛn ɗi jaay jee mɛtn naai ki uun ey se?» ");
INSERT INTO kyq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isa tɛrlɗen ɔɔ: «Jeegen ɓaaɗo kɔkŋ mɛnda jaay gaabm mɛnda utu se, naaɗe kuun siam ɔɔ ɗio? Mɛt ki eyo. Naaɗe se kɔŋ kuun siam eyo kɛn mɛl mɛnda jaay utu te naaɗe se. ");
INSERT INTO kyq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Num gaŋ ɓii kalaŋ kaaɗin̰ utu Ꞌkaan se gaabm mɛnda jꞋutu jꞋan̰ kɔɔɗn naata. Kaaɗ kɛn se jaay ɓo, mɛɗin̰ge se Ꞌkuun siam. ");
INSERT INTO kyq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ꞋBooyki, nam Ꞌkɔŋ kaal kal kiji ro kal kɛn koono eyo. Ey num kal kiji se an nɛɛpm ute kal koono ɔɔ gɔtn nɛɛpin̰ se Ꞌtɛɗn magal cir kɛn do dɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɔɔ tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se, jꞋɔmbin̰ maakŋ k‑lɛɛtɛrge tun koono eyo. Ey num tɔtn koojn̰ bin̰ se an dɔɔbm ute k‑lɛɛtɛrge se naatn. Tɔtn se lɛ Ꞌkɔɔy naaŋ ki cɛrɛ ɔɔ k‑lɛɛtɛrge se lɛ, Ꞌdɔɔbm tuju. Num gaŋ bɛɛki num, tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se, kꞋjꞋɔmbin̰ maakŋ k‑lɛɛtɛrge tun kiji.» ");
INSERT INTO kyq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɓii kalaŋ ɓii sebit ki se, Isa ute jee mɛtin̰ ki deel maakŋ gɔtn gɛm ki. Kɛn naaɗe deel deel se jee mɛtin̰ ki baag tɛrɛcn̰ do gɛmge. ");
INSERT INTO kyq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kɛn *Parizige aak nakŋ ese se, taaɗ Isa ki ɔɔ: «Aaka, jee mɛti ki tɛɗ nakŋ kɛn jꞋund te kulu gɛn tɛɗ eyo ɓii sebit ki!» ");
INSERT INTO kyq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Isa tɛrlɗen ɔɔ: «Ɓii kalaŋ naase Ꞌdooyin̰ki te ey la, nakŋ kɛn *Daud tɛɗ ute jeen̰ge kaaɗ kɛn naaɗe ɔk nakŋ kɔs eyo ɔɔ ɓo tɔɔlɗe se? ");
INSERT INTO kyq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kaaɗ kɛn se, Abiatar ɓo *magal debm tɛɗn sɛrkɛ Raa ki. Gɔtn se Daud ɛndo maakŋ *kɔrɔr magal gɛn Raa ki, tɔs mappan jꞋɛɗin̰ga kɛɗ *sɛrkɛ Raa ki se ɔɔ ɔsɔ. Ey num, kɛn ɔk ɗoobm Ꞌkɔs se jee tɛɗn sɛrkge Raa ki sum. Gaŋ Daud tɔs ɛɗ jeege tun mɛtin̰ ki se kici.» ");
INSERT INTO kyq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tɛr Isa ɗeekɗen daala ɔɔ: «Ɓii sebit se, Raa tɛɗin̰ taa debkilimi ey num debkilimi ɓo Raa tɛɗin̰ taa ɓii sebit eyo. ");
INSERT INTO kyq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taa naan̰ se ɓo *Goon Deba se, naan̰ ɓo Mɛl gɛn ɓii sebit.» ");
INSERT INTO kyq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɓii kalaŋ Isa ɓaa ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki se daala. Gɔtn ese, ɔk gaaba kalaŋ jin̰ ooyga kooyo. ");
INSERT INTO kyq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jee iŋg gɔtn se ɔnd kaama Isa ki tak, taa naaɗe je an̰ kaaka kɛn n̰Ꞌkɛɗn lapia gaab kɛn se *ɓii sebit ki num, taa naaɗe an̰ kɔkŋ mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Isa taaɗ gaab kɛn jin̰ ooyga kooy se ɔɔ: «Iin̰i, Ꞌɗaar naan jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Isa tɔnd mɛtn jeegen iŋg aakin̰ se ɔɔ: «Ɓii sebit ki se, jꞋundsenga kulu gɛn tɛɗn bɛɛ lɔɓu, gɛn tɛɗn *kusin̰ lɛ? Ɔɔ ɔŋ deba num an̰ kaaj, lɔɓu an̰ tɔɔl lɛ?» Gaŋ naaɗe se do ɗɛk. ");
INSERT INTO kyq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gɔtn se Isa uun kaamin̰ aak dɔɔɗɗe paac. Naan̰ maakin̰ taarin̰ doɗe ki ɔɔ bɔɔbɗe makɔn̰ɔ. Ute do‑mɔŋgɗe se, naaɗe tuj naŋin̰ maakin̰ tak tak. Naan̰ ɗeek gaab kɛn jin̰ ooyga kooy se ɔɔ: «ꞋSɛɛj jii!» Ɔɔ gaabm se sɛɛj jin̰a ɔɔ gɔtn ese sum ɓo jin̰ ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kɛn *Parizige jaay teeco maakŋ ɓee kɛn Yaudge lee tusn maak ki sum se, naaɗe naar ɓaaɗo tus dɔɔk taarɗe ute jee *Ɛrɔdge taa naaɗe je ɗoobm an Ꞌkutn Isa. ");
INSERT INTO kyq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Isa iik tɔk ɓaa te jee mɛtin̰ ki jɛŋ baar Galile ki. Gɔtn se jeege dɔɔlɔ dɛna ɔko mɛtin̰a. Naaɗe se iin̰o taa naaŋ kɛn Galile. Kɛn dɔɔl jeege jaay booy nakgen naan̰ lee tɛɗ se, jee mɛtin̰ge iin̰o taa naaŋ Jude ki kɛngen mɛtin̰ge iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki, kɛngen se iin̰o taa naaŋ Idumɛ ki, ɔɔ kɛngen kuuy se iin̰o jɛŋ ool Jordan kɛn kaam naane ɔɔ kɛngen kuuy se iin̰o taa naaŋ Tir ute gɛn Sidɔŋ ki. Naaɗe ɓaaɗo ɔŋin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gɔtn se naan̰ taaɗ jeege tun mɛtin̰ ki ɔɔ kꞋɗaapin̰ markaba kaam jin̰a taa jee dɛnge se an̰ kɔtn kɔl kund eyo. ");
INSERT INTO kyq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Isa se ɛɗga lapia jee kɔɔn̰ge tu dɛna. Taa naan̰ se ɓo, jeegen paacn̰ ɔk kɔɔn̰ge se ɓaaɗo tooc ron̰ ki je an̰ kutn te jiɗe. ");
INSERT INTO kyq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kɛn jee ɔk kɔɔn̰ sitange jaay aakin̰ se, naaɗe taal tooc mɛtn jɛn̰ ki tɔɔɗ tɔɔy ɔɔ: «Naai se Goon *Raa.» ");
INSERT INTO kyq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Gaŋ Isa aacɗen kaama makɔn̰ɔ ɔɔ jꞋɔn̰te taaɗn jeege tu an̰ jeele. ");
INSERT INTO kyq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gɔtn se, Isa ɓaa ook do kɔs ki ɔɔ daŋ jee kɛn naan̰ jeɗe ɔɔ naaɗe ɓaaɗo ɔŋin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Maakɗe ki se naan̰ bɛɛr tɔɔɗ gaabge sik‑kaar‑dio, kɛn naan̰ daŋɗe jee kaan̰ naabin̰ge, taa Ꞌkiŋg te naan̰a ɔɔ aɗen kɔl gɛn lee taaɗn taar Raa jeege tu, ");
INSERT INTO kyq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ɔɔ naan̰ ɛɗɗen tɔɔgɔ gɛn tuur sitange. ");
INSERT INTO kyq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kɛse ɓo ro jee sik‑kaar‑di kɛn naan̰ bɛɛr tɔɔɗɗe: Simon naan̰ ɔndin̰ ron̰ Piɛr, ");
INSERT INTO kyq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jak te gɛnaan̰ Jan, naaɗe se gaan Zebedege kɛn Isa daŋɗe ute ro Bonɛrgɛs kɛn je ɗeekŋ ɔɔ: jeegen se tec aan gɔɔ raa taata. ");
INSERT INTO kyq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kɛngen kuuy se, Andre, Pilip, Bartelemi, Matiye, Tɔma, Jak goon Alpe, Tade, Simon debm je kujn̰ naaŋin̰a, ");
INSERT INTO kyq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ɔɔ Judas Iskariɔt, naan̰ ɓo debm utu kutn Isa. ");
INSERT INTO kyq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Isa tɛrl ɓaa ɓeene. Gɔtn se jeege ɓaaɗo tus dɛn daala, bini naan̰ ute jee mɛtin̰ ki se gɔtn naaɗe Ꞌkɔŋ jaay an kɔs kic ɓo gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kɛn taasin̰ge jaay booy bin se, naaɗe je ansin̰ kɔkŋ ɓaa ɓeene, taa naaɗe taaɗ ɔɔ: «Isa se don̰ biga.» ");
INSERT INTO kyq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raagen iin̰o Jeruzalɛm ki se, naaɗe taaɗ ɔɔ: «Naan̰ se ɔk Belzebul.» Ɔɔ: «Ute Bubm sitange se ɓo naan̰ tuur sitange ro jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kɛn Isa jaay booy taarɗe se, naan̰ daŋɗeno cɛɛn̰ ki ɔɔ taaɗɗen ute kaal naagŋ taara ɔɔ: «Bubm sitange jaay tuur ron̰ mala se, an̰ tuur ɔɔ ɗio? ");
INSERT INTO kyq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kɛn maakŋ taa naaŋ gaar kɛn jeen̰ge taarɗe ɔk mɛtn naap ey se, naaɗe Ꞌkɔŋ kiŋg kalaŋ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jee maakŋ ɓee ki jaay taarɗe ɔk mɛtn naap ey se, jil jee se kiŋgɗe kɔŋ ɓaa eyo. ");
INSERT INTO kyq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kɛn Bubm sitange jaay baagga tɛɗn bɔɔrɔ ute ro naan̰ malin̰ se bin se naan̰ tɔpga ron̰a, naan̰ se tɔɔgin̰ tɛɗn gɔtɔ ɔɔ gaarin̰ kic lɛ Ꞌtɛɗn gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Kɛn nam jaay je kɛnd kɔsn ɓee debm tɔɔg se, debm se naan̰ ɔk dɔɔkin̰ga jaay ɓo, Ꞌkɔsn ɓeen̰a. ");
INSERT INTO kyq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ꞋBooyki bɛɛ mꞋasen taaɗa: *kusin̰ kɛn jikilimge tɛɗ paac ute naajn̰ kɛn naaɗe naaj Raa se kic ɓo, Raa aɗesin̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Num gaŋ debm jaay naaj *Nirl Salal se, kusin̰ naan̰ se mɔɔtn Raa an̰sin̰ tɔɔl eyo, anum kusin̰ naan̰ se, an̰ tiŋg yɛmin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isa taaɗɗen bin se taa naaɗe taaɗga taaɗa ɔɔ naan̰ n̰Ꞌɔk sitan. ");
INSERT INTO kyq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gɔtn se gɛnaa Isage ute kon̰ɗe jaay aan se, naaɗe ɗaar naatn ɔl ɔɔ kꞋdaŋɗeno Isa. ");
INSERT INTO kyq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gɔtn ese jeege dɛna iŋg gurug Isa, kꞋɗeekin̰ jꞋɔɔ: «ꞋBooyo! Koi ute gɛnaaigen mɛndge ute kɛn gaabge utu naatn, je ai kaaka.» ");
INSERT INTO kyq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isa tɛrlɗen ɔɔ: «Koyuma ute gɛnaamge se tap ɓo naŋge?» ");
INSERT INTO kyq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɔɔ naan̰ uun kaamin̰a aak jee iŋg gurugin̰ se, ɗeek ɔɔ: «Aakki, jee se ɓo koyuma ute gɛnaamge. ");
INSERT INTO kyq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Taa debm jaay tɛɗ nakŋ Raa maakin̰ jen ro ki se, kɛse ɓo gɛnaam gaaba, kɛn mɛnda ɔɔ koyuma.» ");
INSERT INTO kyq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tɛr daala Isa baag dooy jeege taa baar kɛn Galile ki. Taa jeegen tus ron̰ ki dɛn se ɓo, ɔlin̰ naan̰ ook iŋg maakŋ markab kɛn do maane ki. Ɔɔ jee ute dɛnɗe se lɛ, ɗaar do jɛŋ baar ki. ");
INSERT INTO kyq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gɔtn se naan̰ dooyɗen te nakge dɛna ute ɗoobm kaal naagŋ taara. Maakŋ dooyin̰ ki se, naan̰ ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ꞋBooyki! Deba kalaŋ tɔs kupin̰a ɔɔ teec ɓaa kɔnd buru. ");
INSERT INTO kyq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Num kɛn naan̰ jaay ɔnd kɔnd burin̰ se, kupm mɛtin̰ si jɛŋ ɗoob ki ɔɔ yeelge bɔɔy ɓaaɗo naar tuun ɔsin̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kupm mɛtin̰ si do naaŋ kɛn gɔtn maakin̰ ɔk koa. Kupm se naar teeco yɔkɔɗɔ taa gɔtn se, naaŋin̰ cɛɛpɛ. ");
INSERT INTO kyq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Num gaŋ kɛn kaaɗa jaay baag tɔŋgɔ se, naan̰ lawaka ɔɔ tuutu, taa gɔtn se iirin̰ ɔŋ ɛnd ɓaa te dɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kupm mɛtin̰ se si maakŋ ji kaag kɛn ɔk kɔrɔndɔ. Ji kaagŋ ute kɔrɔndin̰ se teepe ɔɔ aayin̰ taara ɔɔ bur se, ɔŋ ooj te eyo. ");
INSERT INTO kyq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Num kupm mɛtin̰ se si do naaŋ kɛn jiga. Gɔtn se naan̰ teece, teepe, am tɔk doa ɔɔ ɔk kaama. Do kalaŋ ɔk kaama bɛɛ bɛɛ, kɛngen kuuy ɔk kaama dɛna ɔɔ kɛngen kuuy se ɔk kaama dɛn ciri.» ");
INSERT INTO kyq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gɔtn se Isa ɗeekɗen ɔɔ: «Debm ɔk bi booyo num, booy ɔk taar se!» ");
INSERT INTO kyq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kɛn Isa iik tɔk naatn cɛɛ jee dɛnge tu se, jee cɛɛn̰ ki ute jee mɛtin̰ kɛn sik‑kaar‑di se tɔnd mɛtin̰ ɔɔ n̰Ꞌaɗen taaɗn tɔɔkŋ mɛtn kaal naagŋ taargen se. ");
INSERT INTO kyq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naan̰ tɛrlɗen ɔɔ: «Nakŋ jꞋɔyin̰ga kɔy maakŋ *Gaar Raa ki se, *Raa taaɗsenga mɛtin̰ naase ki. Num gaŋ jee kuuy se taargen se paac, naaɗe booyin̰ aan gɔɔ kaal naagŋ taara, ");
INSERT INTO kyq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","taa naan̰ se ɓo: Naaɗe aaka naɓo ɔŋ aak ɔk eyo, naaɗe booyo naɓo ɔŋ booy ɔk eyo. Kɛn naaɗe booy ɔkga num, daan naane, naaɗe tɛrlga maakɗe do Raa ki ɔɔ naan̰ aɗen tɔɔl *kusin̰ɗe.» ");
INSERT INTO kyq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gɔtn se, Isa ɗeekɗen ɔɔ: «Kaal naagŋ taar maam mꞋtaaɗsesin̰ ese se jaay naase Ꞌbooy ɔkin̰ki ey se, num kaal naagŋ taar kɛn kuuy paac se, an̰ki Ꞌbooy kɔkŋ ɔɔ ɗi? ");
INSERT INTO kyq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Debm kɔnd buru se lɛ tec aan gɔɔ debm taaɗ taar Raa. ");
INSERT INTO kyq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jee mɛtin̰ge se tec aan gɔɔ kupm kɛn si jɛŋ ɗoob ki se. Kɛn naaɗe jaay booyga taar Raa se, *Ɓubm sitange naar ɓaaɗo ɔɔɗ taar se maakɗe ki naatn. ");
INSERT INTO kyq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Num jee mɛtin̰ge se, tec aan gɔɔ naaŋ maakin̰ ɔk koa. Jee se jaay booyga taar Raa se, naar ɔkin̰ maakɗe ki ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Naɓo naaɗe se ɔŋ ɔkin̰ tɔɔg eyo, ɔn̰ taar Raa ɔl iiri maakɗe ki eyo, taa naaɗe ɔŋ ɔn̰ te maakɗe kaam kalaŋ eyo. Kɛn dubar ɔŋɗenga ey lɛ kꞋbaagɗenga dabar gɛn taar Raa sum ɓo, naaɗe naar rɛsn ute kaal maakɗen do Raa ki se naatn. ");
INSERT INTO kyq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jee mɛtin̰ge se, tec aan gɔɔ gɔtn ɔk jii kaagŋ ute kɔrɔndin̰a. Naaɗe se booyga taar Raa, ");
INSERT INTO kyq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","naɓo naaɗe uun nirlɗe do nakge tun do *duni ki, je maala ute nakgen jeege lee dɔŋ se. Nakgen se ɓo, ɓaaɗo maak‑saapɗe ki ɔɔ gaasin̰ taar Raa se ɔŋ tɛɗ naaba maakɗe ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ꞋBooyki, kupm si do naaŋ kɛn jiga se tec aan gɔɔ jeegen booy taar Raa ɔɔ took aal maakɗe do ki. Ɔɔ taar Raa se ɔlɗe naaɗe tɛɗn nakgen bɛɛ bɛɛ. Jee mɛtin̰ge se tec aan gɔɔ gɛm kɛn ɔk kaama bɛɛ bɛɛ, kɛngen mɛtin̰ge tec aan gɔɔ gɛm kɛn ɔk kaama dɛna ɔɔ kɛngen kuuy se tec aan gɔɔ gɛm kɛn ɔk kaama dɛn cir se.» ");
INSERT INTO kyq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tɛr Isa ɗeekɗen daala ɔɔ: «Nam ɔɔcga lɔɔmpin̰ num, deebin̰ dukulu don̰ ki ne? Lɔ ɔndin̰ mɛtn daŋal ki la? Bɛɛki num, an̰ kuun kɔl raan ey la, taa wɔɔr gɔtɔ? ");
INSERT INTO kyq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Taa ɗi nakŋ ko kꞋkɔyin̰ se utu tooɗn tal, nakŋ kɛn jeege jeel mɛtin̰ ey se, jeege utu Ꞌjeel mɛtin̰ paac. ");
INSERT INTO kyq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ꞋBooyki bɛɛ. Debm ɔk bi booyo num, booy ɔk taar se!» ");
INSERT INTO kyq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Isa tɛrl ɗeekɗen daala ɔɔ: «Ɔndki kɔndɔ ute taar naase Ꞌlee Ꞌbooyki se. Taar kɛn Raa ɛɗsesin̰ se, utu asesin̰ dɔɔjɔ, ute nakŋ kɛn naase Ꞌlee Ꞌdɔɔjn̰ki nakge jeege tu se, naase kic jꞋutu jꞋasesin̰ dɔɔjn̰ ɗoocn̰ cirr cirr daala. ");
INSERT INTO kyq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Taa debm ɔk se jꞋan̰ kɔmb do ki, num debm ɔk ey lɛ, kɛn cɔkɔn naan̰ ɔk se kic ɓo, jꞋan tɔsn naatn.» ");
INSERT INTO kyq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isa tɛrl taaɗ daala ɔɔ: «*Maakŋ Gaar Raa se tec aan gɔɔ nakŋ ese: deba kalaŋ ɓaa kɔnd buru maakŋ gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kɛn maakŋ nɔɔr kɛn naan̰ tooɗ tooɗo lɔ, katar kɛn lɛk lɛkɛ, gɔtn se kupu teec kalin̰ ki ɔɔ teepe, gaŋ naan̰ jeel mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Naaŋ se, tɛɗ kupu teec kalin̰ ki, teepe, am tɔɔk doa ɔɔ do se ɔk kaama jiga. ");
INSERT INTO kyq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kɛn debm maakŋ‑gɔtɔ jaay aak nakin̰ aacga se, naan̰ uun gɔrɗɔ, baag kɔjn̰ nakin̰a, taa kaaɗn kɔjɔ se aanga.» ");
INSERT INTO kyq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tɛr Isa taaɗ ɔɔ: «*Maakŋ Gaar Raa se maam mꞋan̰ kɔmb bɛyɛ ute ɗi? Ɔɔ ute kaal naagŋ taar gay jaay maam mꞋan̰ taaɗin̰ jeege tu se? ");
INSERT INTO kyq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maakŋ Gaar Raa se tec aan gɔɔ kaam nakŋ kꞋdaŋin̰ mutard. Kɛn jꞋutu jꞋɔɔcin̰ kɔɔc naaŋ ki se, naan̰ baat cir kaam nakgen do naaŋ ki se paac. ");
INSERT INTO kyq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Num gaŋ kꞋjꞋɔɔcin̰ga num, naan̰ magal cir nakgen teec maakŋ ɓar ki se paac. Naan̰ teep tɛɗ magala, tɔp tɛɗ lɛtɛ ɔɔ bini yeelge kic ɓo ɓaaɗo uj kujɗege do ki.» ");
INSERT INTO kyq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Isa dooy jeege ute kaal naagŋ taarge dɛna tec aan gɔɔ napar naan̰gen ese se ɔɔ naan̰ taaɗɗen Taar Raa kɛn naaɗe an̰ kɔŋ kaasn gɛn booy kɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naan̰ dooy jeege ute kaal naagŋ taara salal. Num kɛn naan̰ ɔɔpga kalin̰ ki ute jee mɛtin̰ ki num, naan̰ iŋg tɔɔkɗen mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɓii kɛn se sum ɓo, aan tɛgɛr se, Isa ɗeek jee mɛtin̰ ki ɔɔ: «KꞋgaaŋ kꞋɓaaki jɛŋ baar kɛn kaam naane.» ");
INSERT INTO kyq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jee mɛtin̰ ki se iin̰ ɔn̰ jee dɛn se ɔɔ naaɗe uun markabm kɛn Isa iŋg maak ki se ɔɔ ɓaansin̰a. Gɔtn se markabgen kuuy kic ɓo ɓaa te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gɔtn se kuulu dɔɔbɔ makɔn̰ɔ, ɔl maane aal walak walak ɔɔ iin̰ ɗooc ɗooc maakŋ markaba. ");
INSERT INTO kyq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gaŋ Isa aal don̰ do wasad ki tooɗ tooɗ bia kaam mɔɔtn maakŋ markab ki. Jee mɛtin̰ ki tɔnd durin̰a ɗeekin̰ ɔɔ: «Debm dooyje, ɓɛrɛ, naajege jꞋaki kutu ɔɔ naai Ꞌtɔnd mɛt ey bin se gɛn ɗio?» ");
INSERT INTO kyq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Isa jaay dur se, iin̰ aac kaama kuul ki ɔɔ ɗeek maane ki ɔɔ: «ꞋDoa, Ꞌtooɗ kaam kalaŋ!» Gɔtn se kuulu ɗaara ɔɔ gɔtɔ do dil. ");
INSERT INTO kyq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Isa ɗeekɗen ɔɔ: «Gɛn ɗi jaay naase Ꞌɓeerki bin se? Ɓɔrse kic ɓo ɔŋ aalki te maakse dom ki ey la?» ");
INSERT INTO kyq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naaɗe aak nakŋ Isa tɛɗ se, nirlɗe teece ɔɔ gɔtn se naaɗe baag taaɗn ute naapa ɔɔ: «Kɛse tap ɓo naŋa bini, kɛn kuulu ute maane ki kic ɓo tookin̰ taarin̰ se?» ");
INSERT INTO kyq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gɔtn se naaɗe aan taa baar Galile kɛn kaam naane taa naaŋ jeege tun kꞋdaŋɗen Gɛrazɛnige. ");
INSERT INTO kyq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kɛn Isa ute jee mɛtin̰ ki jaay bɔɔyo naatn maakŋ markab ki sum se, gɔtn se gaaba kalaŋ naar teeco maakŋ iiɓge tun Yaudge tɛɗin̰o gɛn tɔl taal yoɗege se ɔɔ naan̰ ɓaa dɔɔɗ Isa. Gaabm se ɔk kɔɔn̰ sitan. ");
INSERT INTO kyq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Naan̰ tiŋg maakŋ iiɓge tun se ɔɔ gaabm se kꞋdɔɔkin̰ ute zin̰ziri kic ɓo, ɔŋ ɔkin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Daayum jꞋaalin̰ dɔkɔɗɔm maala jɛn̰ ki ɔɔ jin̰ kꞋdɔɔkin̰ te zin̰ziri, num gaŋ naan̰ gaaŋ ute dɔkɔɗɔm maala ɔɔ tɔnd tɛrɛcn̰ ute zin̰ziri se naatn. Nam nam tɔɔg jaay an̰ kɔkŋ ɗaar se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nɔɔrɔ katara, daayum, naan̰ tiŋg maakŋ iiɓge tu ɔɔ do kɔsge tu, naan̰ tɔɔɗ tɔɔyɔ ɔɔ tɔnd gaaŋ ron̰ ute koge. ");
INSERT INTO kyq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kɛn naan̰ aak Isa mɛt dɔk se, naan̰ aan̰ ɓaa ɛrg naanin̰ ki, ");
INSERT INTO kyq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ɔɔ naan̰ ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ: «Isa Goon *Raa Taaro, jꞋɔŋ ɗi ute naai? Ɓɛrɛ, mꞋaali Raa mindi ki, ɔn̰te Ꞌdabaruma.» ");
INSERT INTO kyq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kɛn naan̰ taaɗ bin se taa Isa taaɗin̰ga taaɗa ɔɔ: «Sitan, Ꞌteec naatn ro gaab kɛn se!» ");
INSERT INTO kyq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tɛr Isa tɔnd mɛtn gaaba se ɔɔ: «Naai roi naŋa?» Ɔɔ naan̰ tɛrlin̰ ɔɔ: «Maam se rom Dɔɔl asgarge, taa naaje kꞋro naap ki.» ");
INSERT INTO kyq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Naan̰ eemin̰ nɔɔ mɛtin̰ ki kɔni kɔni ɔɔ n̰Ꞌɔn̰te tuurɗe naatn maakŋ taa naaŋ kɛn ese se. ");
INSERT INTO kyq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kaam mɛtn kɔs ki se ɔk dɔɔl kin̰zirge dɛna gaam gaama. ");
INSERT INTO kyq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gɔtn se sitange eem nɔɔ mɛtn Isa ki ɗeekin̰ ɔɔ: «Ɔlje naaje se kꞋɓaa kɛnd maakŋ kin̰zirge tun ese se.» ");
INSERT INTO kyq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɔɔ naan̰ undɗen kulu. Gɔtn se sitange se teeco ro gaab kɛn se ɔɔ ɓaa ɛnd maakŋ kin̰zirge tu. Dɔɔl kin̰zirgen te dɛnɗe se dɔɔbɔ rus ɔɔ naar aan̰o girdi girdi bɔɔy ɓaa si maakŋ baar ki ɔɔ paac maane ɔsɗe. Kin̰zirge se ɓaa ɓaa nakŋ dupu‑dio. ");
INSERT INTO kyq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kɛn jee gaam kin̰zirge jaay aak nakŋ tɛɗ se, naaɗe dɔɔb an̰ ɓaa taaɗ nakŋ se jeege tun maakŋ gɛgɛr ki ute jeegen iŋg ɓee naatge tu. Ɔɔ jeege se ɓaaɗo aak nakŋ kɛn tɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kɛn naaɗe aan ɔŋ Isa se, naaɗe aak gaabm kɛn dɔɔl sitange iŋgo ron̰ ki se, naan̰ mɛtɛkga ɔɔ iŋg kiŋg ute kalin̰ ron̰ ki. Kɛn naaɗe aakin̰ se, ɓeere ɓaa ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jee kɛn aako nakŋ aan do gaab kɛn ɔk sitange ute gɛn kin̰zirge se, naaɗe ɔɔs maanin̰ jeege tu, ");
INSERT INTO kyq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ɔɔ jee se ɓaa eem nɔɔ mɛtn Isa ki ɔɔ n̰Ꞌiin̰ n̰Ꞌɔn̰ɗen taa naaŋɗe. ");
INSERT INTO kyq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kɛn Isa ook maakŋ markab ki ɓaa ɓaa se, gaabm tɛɗo kɔɔn̰ sitange se eemin̰ nɔɔ mɛtin̰ ki ɔɔ Ꞌɓaa te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Gɔtn se Isa undin̰ te kul eyo, gaŋ naan̰ ɗeekin̰ ɔɔ: «ꞋƁaa ɓei ki ɔŋ jeeige se, Ꞌtaaɗɗen nakgen paacn̰ Raa tɛɗi naai ki se, ɔɔ kɛɛjn̰ kɛn naan̰ ɛɛji doi ki se.» ");
INSERT INTO kyq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kɛn naan̰ jaay ɓaa ɓaa se, baag taaɗn jeege tun taa naaŋ kɛn kꞋdaŋin̰ Gɛgɛrgen‑Sik taa bɛɛ paacn̰ kɛn Isa tɛɗin̰ naan̰ ki se. Ɔɔ jeegen booy taar se, paac se, ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Isa iin̰ gɔtn se ook maakŋ markab ki ɔɔ ɔk tɛrl ɓaaɗo jɛŋ baar kɛn kaam naane. Kɛn naan̰ jaay aan se, jee dɛnge se ɓaaɗo tus cɛɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Gɔtn se gaaba kalaŋ kꞋdaŋin̰ Jayrus, naan̰ se magal gɛn ɓee Yaudgen lee tusn maak ki, ɓaaɗo jaay aak Isa se, ɛrg mɛtn jɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naan̰ eemin̰ nɔɔ mɛtin̰ ki kɔni kɔni ɔɔ ɗeekin̰ ɔɔ: «Maam se, goonum mɛnd baat se ɓaa ɓaa kooyo. ꞋƁaaɗo ɔnd ji ron̰ ki, taa naan̰ Ꞌkɔŋ lapia ɔɔ Ꞌkiin̰i.» ");
INSERT INTO kyq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Isa tooko ɔɔ ɓaa te naan̰a. Ɔɔ jee te dɛnɗe se ɔk mɛtin̰a ɔɔ tuurin̰ kaam ara kaam ara. ");
INSERT INTO kyq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gɔtn se mɛnda kalaŋ bini, gɔtn moosin̰ aan sum se ɔŋ ɗaar eyo. Moosin̰ se, ɔkga ɓaara sik‑kaar‑dio ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naan̰ lee dabarga ron̰ dɛna gɔtn jee dawage tu ɔɔ utga jin̰ paac naɓo ɔŋ te lapi eyo. Num gaŋ kɔɔn̰in̰ se cirin̰ cir do ki daala. ");
INSERT INTO kyq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Num naan̰ booyga kɛn jꞋɔɔs maan Isa se, taa naan̰ se ɓo, naan̰ taaɗ ute maakin̰ ɔɔ: «Kɛn maam mꞋɓaa jaay mꞋutga kalin̰ sum ɓo, mꞋutu mꞋkɔŋ lapia.» Naan̰ ɛnd daan jeege tu, ɓaaɗo naagŋ Isa ki ɔɔ ut kalin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naan̰ kɛn se sum ɓo, moosin̰ nɔŋ ɗaara ɔɔ naan̰ naam ɔk ron̰a. ");
INSERT INTO kyq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gɔtn se Isa naar naam tɔɔgɔ teec ron̰ ki se, naan̰ tɛrl aak jee dɛnge ɔɔ tɔnd mɛtɗe ɔɔ: «Naŋa jaay ut kalum se?» ");
INSERT INTO kyq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gaŋ jee mɛtin̰ ki tɛrlin̰ ɔɔ: «Aaka, jeege ɓo tuuri kaam ara kaam ara, jaay tɛrl naai Ꞌtɔnd mɛta ɔɔ: ‹Naŋa ɓo utum se?› Gɛn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Num gaŋ Isa tɛrl aak jeegen gurugin̰ se, taa kaakŋ nam jaay utin̰ se. ");
INSERT INTO kyq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gɔtn se mɛnda se ɓeer ɓaa ɔkin̰a ɔɔ ron̰ ook marga, taa naan̰ jeel nakŋ aan ron̰ ki se. Naan̰ ɓaaɗo ooc mɛtn jɛn̰ ki ɔɔ taaɗin̰ nakŋ kɛn aan don̰ ki se paac. ");
INSERT INTO kyq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Isa ɗeekin̰ ɔɔ: «Goonuma, taa naai aalga maaki dom ki se, kaal maaki se aajiga. ꞋƁaa ute lapia; kɔɔn̰i se ai tɛɗn ɗim ey sum.» ");
INSERT INTO kyq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kɛn Isa utu ɗaar taaɗ taaɗ ɓɔrt se sum ɓo, jeegen iin̰o ɓee Jayrus ki, naan̰ kɛn magal *ɓee kɛn Yaudge lee tusn maak ki se, ɓaaɗo taaɗin̰ ɔɔ: «Ɓɛrɛ, gooni mɛnda se lɛ, ooyga; Debm dooy jeege se ɔn̰in̰ kaam kalaŋ.» ");
INSERT INTO kyq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gaŋ taar naaɗe se Isa tɔnd mɛt eyo. Naan̰ ɗeek Jayrus ki ɔɔ: «Ɔn̰te Ꞌɓeere; ɔnd maaki kaam kalaŋ.» ");
INSERT INTO kyq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Isa ɔn̰ nam ɔk mɛtin̰ eyo ɔɔp Piɛr, Jak, ute gɛnaan̰ Jan sum. ");
INSERT INTO kyq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kɛn naaɗe jaay aan maakŋ ɓee kɛn gɛn magal ɓee kɛn Yaudge lee tusn maak ki se, Isa aak jeege se tɛɗ gaaja gaaja, jee mɛtin̰ge eem keeme, kɛngen mɛtin̰ge tɔɔy tɔɔyɔ se. ");
INSERT INTO kyq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isa ɛnd maakŋ ɓee ki se ɗeekɗen ɔɔ: «Gɛn ɗi jaay naase eemki ɔɔ Ꞌtɛɗki gaaja gaaja se? Bɛrɛ, goon se lɛ ooy te eyo; naan̰ tooɗ tooɗ bi sum.» ");
INSERT INTO kyq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gɔtn se naaɗe baagin̰ tooy koogo mɛtin̰ ki. Gaŋ Isa tuur ɔɔɗ jee se paac naatn, ɔɔp bubm goono ute kon̰a ɔɔ jeegen ɓaaɗo ute naan̰ se. Gɔtn se, Isa ɛnd maakŋ ɓee kɛn jꞋaal goono maak ki se. ");
INSERT INTO kyq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naan̰ ɔk ji goono ɔɔ ɗeekin̰ ɔɔ: «Talita kuum!» Taar se je ɗeekŋ ɔɔ: mꞋɗeeki mꞋɔɔ goon mɛnda, iin̰i! ");
INSERT INTO kyq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gɔtn se goon mɛnda naar iin̰i ɔɔ baag lea. Goon mɛnda se goon ɓaara sik‑kaar‑dio. Kɛn jeege jaay aak nakŋ se, ɓaa deel doɗe ɔɔ ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gaŋ Isa dɛjɗen ɔɔ: «Nakŋ se, jꞋɔn̰te taaɗn nam ki.» Tɛr ɗeekɗen ɔɔ: «Goon mɛnda se jꞋɛɗin̰ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Isa iin̰ ɔn̰ gɔtn se ɓaa maakŋ naaŋin̰ ki ɔɔ jee mɛtin̰ ki ɓaa te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Ɓii sebit jaay aan se, naan̰ ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki ɔɔ baag dooy jeege. Jee dɛn iŋg booy taar naan̰ iŋg taaɗ se, taar se tap ɓo ɔkɗen taaɗ eyo. Naaɗe taaɗ ɔɔ: «Nakgen se tap ɓo naan̰ ɔŋin̰o gay? Ɔɔ jeel‑taar se naŋa ɓo taaɗin̰o, jaay ɔlin̰ tɛɗ nakŋ‑kɔɔɓgen bin se? ");
INSERT INTO kyq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naan̰ se debm tirɗn goon Mari, kɛn lee cɔɔc ɗaap nakge se ey la? Naan̰ se gɛnaa Jak, gɛn Joos, gɛn Jud, ute gɛn Simon ey la? Ɔɔ gɛnaan̰gen mɛndge ɓo utu tiŋg te naajege ara ki ey la?» Kɛse ɓo nakŋ kɛn tɛɗɗen naaɗe ɔŋ aal maakɗe don̰ ki ey se. ");
INSERT INTO kyq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Gɔtn se Isa taaɗɗen ɔɔ: «Debm taaɗ taar teeco taar Raa ki se, jeege paac aalin̰ maak ki, num kɛn aalin̰ maak ki ey se, jee maakŋ naaŋin̰ ki, taasin̰ge, ute jee kɛn maakŋ ɓeen̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gɔtn se Isa ɔŋ tɛɗ te nakŋ‑kɔɔɓm gam eyo, naɓo tɔnd jin̰ ɓo do jee kɔɔn̰ge tu kandum bin sum ɔɔ naaɗe se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kɛn Isa jaay aakɗe naaɗe baate tookŋ kaal maakɗe don̰ ki se, tap ɓo, ɔkin̰ taaɗ eyo. Gɔtn se Isa iin̰ ɓaa lee dooy jeege maakŋ naaŋge tun cɛɛ gɛgɛr Nazarɛt ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naan̰ daŋo jee mɛtin̰ kɛn sik‑kaar‑di se baagɗe tɔl naaba jeege di dio. Gɔtn se naan̰ ɛɗɗen tɔɔgɔ gɛn cir sitange, ");
INSERT INTO kyq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ɔɔ dɛjɗen ɔɔ: «Ɔn̰te Ꞌkuunki ɗim gɛn kɔkŋ ɗoobo; ɔn̰te Ꞌkuunki kɔsɔ, ɔn̰te Ꞌkuunki ɓɔɔnɔ, ɔn̰te Ꞌkuunki gurs, num kɛn Ꞌɓaaki ɓaa se, Ꞌtɔski sirɗge ɓo jisege tu sum. ");
INSERT INTO kyq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ꞋTɔlki saasege jɛsege tu num gaŋ ɔn̰te Ꞌtɔski kalge di dio.» ");
INSERT INTO kyq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tɛr naan̰ ɗeekɗen daala ɔɔ: «Kɛn naase aankiga jaay, ɛndkiga ɓee nam ki num, iŋgki gɔtn ese sum bini anki kiin̰ ɓaa maak ki. Ɔn̰te ɓaaki ɓee nam kɛn kuuyu. ");
INSERT INTO kyq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gɔtn naase Ꞌɓaaki jaay jeege baate dɔɔɗn kɔkse se ɔɔ baate booy taarse num, naase Ꞌteec ɔn̰ɗeki naaŋɗe ɔɔ kɛn Ꞌteecki teec se, Ꞌkuɗn jɛsege tu kic ɓo Ꞌtupɗenki naatn. Taa kɛse aɗen tɛɗn saaɗa.» ");
INSERT INTO kyq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kɛn naaɗe jaay ɓaa se taaɗ taar *Raa jeege tu ɗeekɗen ɔɔ kꞋtɛrl maakɗe. ");
INSERT INTO kyq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Naaɗe tuur sitange dɛna ro jeege tu ɔɔ jee kɔɔn̰ge dɛna naaɗe ɔtɗen uubu roɗe ki ɔɔ naaɗe ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gaar Ɛrɔd se booy jeege ɔɔs maan Isa, taa nookin̰ eem dɔɔɗ gɔtɔ ɓaa se paac. Jee mɛtin̰ge ɔɔ: «Jan‑Batist ɓo duroga daan yoge tu. Taa naan̰ se ɓo Raa ɛɗin̰ga tɔɔgɔ gɛn tɛɗn nakŋ‑kɔɔɓge.» ");
INSERT INTO kyq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jee mɛtin̰gen kuuy se ɗeek ɔɔ: «Naan̰ ɓo *Ɛli.» Ɔɔ jeegen kuuy daala ɗeek ɔɔ: «Naan̰ se debm taaɗ taar teeco taar Raa ki tec deb kalaŋ maakŋ jeejege tun taaɗ taar teeco taar Raa kɛn do dɔkin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gaŋ kɛn Ɛrɔd booy jꞋɔɔsin̰ maan Isa se, ɗeek ɔɔ: «Kɛse Jan‑Batist kɛn maam mꞋɔl kꞋgaaŋ don̰ se ɓo duroga daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kɛn naan̰ taaɗ bin se taa naan̰ ɔkga kɔk Ɛrɔdiad, mɛnd gɛnaan̰ Pilip. Num gaŋ Jan ɓaaɗo ɗeekin̰ ɔɔ: «Kɔkŋ naai ɔk mɛnd gɛnaai se ɗoobin̰ eyo.» Taa naan̰ se ɓo, Ɛrɔd ɔl kꞋjꞋɔk kꞋdɔɔko Jan ɔɔ ɔl kꞋɓaa kꞋjꞋɔlin̰ maakŋ daŋgay ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Taa naan̰ se ɓo, Ɛrɔdiad kic ɓo ɔk Jan ute taar‑maaka. Naan̰ je ɗoobm an̰ tɔɔl ɓo, gaŋ ɔŋ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ɛrɔd se aal Jan maak ki taa naan̰ jeele Jan se tɛɗ nakge te ɗoobin̰a, naan̰ se debm *salal. Taa naan̰ se ɓo, Ɛrɔd aakin̰ don̰ ki. Kɛn Jan jaay baaga taaɗn taara num, ɗoobm ron̰ tap ɓo, naan̰ jeel eyo. Ute naan̰ se kic ɓo, kɛn Jan jaay baaga taaɗn taara num, Ɛrɔd booy se, maakin̰ raapo. ");
INSERT INTO kyq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gaŋ ɓii kalaŋ se, Ɛrɔdiad ɔŋ ɗoobm gɛn tɛɗn nakŋ kɛn naan̰ maakin̰ jen ro ki, kaaɗ kɛn Ɛrɔd tɛɗ tɛɗ maak‑raapm ɓii koojin̰ se. Ɛrɔd tɛɗ kɔsɔ te kaaye dɛna, daŋo jee magalgen cɛɛn̰ ki, magal asgarin̰ge ɔɔ magalgen taa naaŋ Galile ki kici. ");
INSERT INTO kyq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kɛn jeege jaay tus maakŋ ɓee ki gɛn tɛɗn maak‑raapɗe se, gɔtn se goon Ɛrɔdiad mɛnda se, ɓaaɗo ɛnd ɔŋɗe ɔɔ baag daama. Kɛn Ɛrɔd te jeen̰ge jaay aakin̰ naan̰ daam daama se, naaɗe paac maakɗe raapo. Taa naan̰ se, gaarge taaɗin̰ ɔɔ: «Nakŋ naai maaki je se, Ꞌtɔnd mɛtuma, mꞋaisin̰ kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naan̰ ɗeekin̰ ɔɔ: «Maam se mꞋnaam roma, nakŋ naai Ꞌje ɗi ɗi bini cɛɛsn taa naaŋum kic ɓo, mꞋaisin̰ kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɔɔ goono se teec ɓaa tɔnd mɛtn kon̰a ɔɔ: «Kaaya, maam se mꞋtɔnd mɛtn nakŋ gay?» Gaŋ kon̰ tɛrlin̰ ɔɔ: «ꞋƁaa Ꞌɗeek ɔɔ: maam se mꞋje do Jan‑Batist.» ");
INSERT INTO kyq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gɔtn se, goono naar ɛnd ɓaa ɔŋ gaarge, ɗeekin̰ ɔɔ: «ꞋGaaŋ ɛɗumo yɔkɔɗɔ do Jan‑Batist se maakŋ supura ki.» ");
INSERT INTO kyq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kɛn gaarge jaay booy taar se, maakin̰ tuju. Naɓo aan gɔɔ naan̰ naamga naam taarin̰ naan jeege tu se, ɗoobm naan̰ an kɔɔɗn don̰a se, gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Gɔtn se sum ɓo, gaarge naar ɔl asgar taa ano ɓaa ute do Jan‑Batist. Asgar se iin̰ ɓaa gaaŋo do Jan‑Batist maakŋ daŋgay ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Naan̰ uunin̰o do Jan se maakŋ supura ki, ɓaaɗo ɛɗin̰ goon mɛnd ki ɔɔ goon mɛnd se uun ɓaa ɛɗin̰ kon̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kɛn jee mɛtn Jan jaay booyo ɔɔ mɛlɗe ooyga se, naaɗe uun ɓaa duubin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","*Jee kaan̰ naabm Isage ɓaaɗo tus cɛɛn̰ ki ɔɔ taaɗin̰ nakgen paacn̰ naaɗe tɛɗo ɔɔ dooy kɛn naaɗe dooyo jeege. ");
INSERT INTO kyq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gɔtn se ɔk jeege dɛna, jee ɓaa ɓaao, jee tɛrlo tɛrlɛ, gɔtn naaɗe an kɔs kic ɓo gɔtɔ. Taa naan̰ se, Isa ɗeekɗen ɔɔ: «Naase se, iik Ꞌtɔɔk Ꞌɓaaki do kɔɗ‑ɓaar ki taa aki ɓaa tɔɔl kɔɔr se cɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gɔtn se naaɗe ook maakŋ markab ki ɔɔ gaaŋ ɓaa do kɔɗ‑ɓaar ki kalɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gaŋ naaɗe jaay ɓaa ɓaa se, jee dɛn se aak jeelɗega. Gɔtn se naaɗe naar teeco maakŋ gɛgɛrge tu paac, naaɗe aan̰ deel naan ki te jɛɗe. Gɔtn naaɗe ɓaa ɓaa se, naaɗe ɓo nɔŋ aan deete. ");
INSERT INTO kyq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kɛn Isa aan jaay bɔɔyo maakŋ markab ki se, naan̰ aak jee dɛnge se, naan̰ ɛɛjɗen doɗe ki, taa jeege se tec aan gɔɔ baatgen ɔk debm gaam eyo ɔɔ gɔtn se naan̰ baagɗe dooy ute taarge dɛna. ");
INSERT INTO kyq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gɔtn se, jee mɛtin̰ ki aak kaaɗa ɓaa se, ɓaaɗo ɔŋin̰a ɗeekin̰ ɔɔ: «Ɓɛrɛ, gɔtn ese daanin̰ kɔɗ‑ɓaara, dɔk ute ɓea ɔɔ kaaɗa lɛ kic ɓo ɓaaga. ");
INSERT INTO kyq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jeege se ɔn̰ɗe wɔɔkŋ ɓaa ɓee naatge tu ute maakŋ naaŋge tun gɔɔr gɔɔr ute gɔtn ese se, gɛn ɓaa je dugŋ nakŋ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Gaŋ Isa tɛrlɗen ɔɔ: «Jeege se, naase mala ɛɗɗeki kɔsɔ!» Gɔtn se naaɗe ɗeekin̰ ɔɔ: «ꞋJe jꞋaɗe ɓaa dugŋ mappa gɛn tamma kaaru di jaay jꞋaɗen kɛɗn naaɗe kɔs la?» ");
INSERT INTO kyq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Isa ɗeekɗen ɔɔ: «Naase ɔkki mappa kando? ꞋƁaa aakin̰ki tu!» Kɛn naaɗe ɓaa aakin̰ se, tɛrl ɓaaɗo taaɗin̰ ɔɔ: «Naaje se jꞋɔk mappa mii ute kɛn̰jge dio.» ");
INSERT INTO kyq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Gɔtn se Isa taaɗ jeege tun mɛtin̰ ki ɔɔ jee se paac gaaŋɗeki dɔɔlɔ dɔɔlɔ ɔɔ kꞋjꞋiŋg do mu zɛɛrge tu. ");
INSERT INTO kyq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naaɗe iŋg rɛɛs se: jee mɛtin̰gen kaaru kaaru, jee mɛtin̰gen si‑mii si‑mii. ");
INSERT INTO kyq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Gɔtn se Isa tɔs mappan mii ute kɛn̰jgen di se jin̰ ki, uun kaamin̰ raan, tɔɔm Raa, mappa se naan̰ dupin̰a ɔɔ ɛɗin̰ jeege tun mɛtin̰ ki ɔɔ naaɗe ɓaa nigin̰ jeege tu. Ɔɔ kɛn̰jgen di se kic, Isa gaaŋ nigin̰ jeege tu paac. ");
INSERT INTO kyq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɔɔ gɔtn se naaɗe paac ɔs dɛrɛŋ ute maraadɗe. ");
INSERT INTO kyq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Togŋ mappan naaɗe ɔs ɔɔp se, kꞋtuunin̰ se ɗooc gɔrnɔ sik‑kaar‑dio ɔɔ kɛn̰jgen naaɗe ɔs se kic ɓo ɔɔpga. ");
INSERT INTO kyq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jeegen ɔs paac se, naaɗe gaabge dupu‑mii. ");
INSERT INTO kyq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naan̰ kɛn se sum ɓo, Isa ɗeek jeege tun mɛtin̰ ki ɔɔ kꞋjꞋook maakŋ markab ki, kꞋgaaŋ kꞋdeel kꞋɓaa do jɛŋ kɛn naane kaam aak gɛgɛr Betsaida kɔr naan̰ utu wɔɔk wɔɔk jeege se. ");
INSERT INTO kyq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kɛn Isa wɔɔk jeege aas se, naan̰ iin̰ ɓaa ook do kɔs ki gɛn keem Raa. ");
INSERT INTO kyq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɛn markaba jaay aan daan maane ki se, kaaɗa ɓaaga ɔɔ Isa ɔɔp do jɛŋ ki kalin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kaaɗ kɛn Isa jaay aakɗe, naaɗe dabar gɛn deepm maane taa kuulu ɔl deeb doɗe ki se. Kɛn gɔtɔ ɔɔpga baata aki kiip se, Isa ɓaa kɔŋ jeen̰ge se, leeɗo do maane ki, sakɗe ɔmb bɛyɛ aan gɔɔ aɗega deele. ");
INSERT INTO kyq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kɛn naaɗe jaay aak Isa lee lee do maane ki se, naaɗe aakin̰ se saap ɔɔ nirl nam. Gɔtn se naaɗe baag tɔɔɗn tɔɔyɔ, ");
INSERT INTO kyq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","taa naaɗe paac aakin̰ga, kɛse ɓo teecɗen nirlɗe. Gaŋ Isa naar taaɗɗen ɔɔ: «Ɔkki maakse tɔɔgɔ. Ɔn̰te Ꞌɓeerki, kɛse maama.» ");
INSERT INTO kyq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naan̰ ook maakŋ markab ki ute naaɗe. Gɔtn se kuulu ɗaara, num nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Taa nakŋ‑kɔɔɓm naan̰ tɛɗ ro mappa ki se, naaɗe ɔnd te te mɛtin̰ eyo, taa biɗe ɔŋ booy ɔk mɛtn nakŋ se eyo. ");
INSERT INTO kyq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kɛn naaɗe gaaŋ baar jaay aan taa naaŋ Genezarɛt ki se, naaɗe ɓaa ɗaar jɛŋ ki ɔɔ dɔɔk markabɗe. ");
INSERT INTO kyq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kɛn naaɗe jaay bɔɔyo maakŋ markab ki naatn se, jee se naar ɓaa aak jeel Isa. ");
INSERT INTO kyq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jeege se aan̰ wɔɔk taa naaŋ kɛn se paac ɔɔ tuuno jee kɔɔn̰ge do nakŋ tooɗɗege tu ɔɔ ɓaano gɔtn naaɗe booy jꞋɔɔ Isa utu se. ");
INSERT INTO kyq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gɔtn naan̰ aanga tak se, kɛn maakŋ gɛgɛrge tu, maakŋ naaŋ baat ki, kɛn maakŋ naaŋ magal ki, lɔ kɛn ɓee naat ki, jeege ɓaano ute jee kɔɔn̰ɗege bɔɔr ki. Ɔɔ naaɗe sɛl mɛtn Isa ɔɔ n̰Ꞌɔn̰ɗe num naaɗe kutn taa kalin̰ sum. Ɔɔ jeegen paacn̰ ut taa kalin̰ se, ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kandum iin̰o Jeruzalɛm ki, ɓaaɗo tus gɔtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gɔtn se naaɗe aak jee mɛtin̰ kɛn mɛtin̰ge se, tug te jiɗege aan gɔɔ gɛn ɓugɗege ey sum ɓo, baag kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Taa Parizige ute Yaudge paac se uun nakŋ ɓugɗege. Kɛn naaɗe jaay tug te jiɗege aan gɔɔ gɛn ɓugɗege ey se, naaɗe ɔs ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kɛn naaɗe ɓaaga suuk ki jaay ɓaaɗoga num, naaɗe tug roɗe jaay baag kɔsɔ. Num naan̰ se sum eyo, tɛɗ nakŋ ɓugɗegen kuuy kic dɛna aan gɔɔ kɛn ɔɔp kɔɔpɗege, nakŋ takŋ maanɗege ɔɔ gidirɗege. ");
INSERT INTO kyq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se tɔnd mɛtn Isa ɔɔ: «Taa ɗi jaay jee mɛti ki baate kuun nakŋ ɓugjege se? Gɛn ɗi jaay naaɗe tug te jiɗege aan gɔɔ gɛn ɓugjege ey sum ɓo, baag kɔsɔ se?» ");
INSERT INTO kyq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Isa tɛrlɗen ɔɔ: «Naase maa jee maakse dio! Do dɔkin̰ kic se Ezayi debm taaɗ taar teeco taar Raa ki se taaɗga taaɗ taar se ro naase ki ɔɔ: Jeegen ese se tɔɔmum ute taarɗe sum, ey num maakɗe se dom ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kɛn naaɗe ɓaaɗoga kɛrgŋ naanum ki gɛn keemum kic ɓo, cɛr sum, taa nakŋ kɛn naaɗe lee dooy jeege se lɛ, dooyɗe ute nakŋ kɛn jikilimge lee tɛɗ se sum. ");
INSERT INTO kyq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nakŋ kɛn *Raa taaɗ ɔɔ gɛn tɛɗa tap ɓo, naase ɔn̰ki ɔɔ uunki nakŋ jikilimgen lee tɛɗ se ɓo ciri.» ");
INSERT INTO kyq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tɛr Isa taaɗɗen daala ɔɔ: «Nakŋ kɛn Raa taaɗ gɛn tɛɗa tap ɓo, naase Ꞌrɛsin̰ki naatn ɔɔ Ꞌtɛɗki ɓo nakŋ ɓugsege. ");
INSERT INTO kyq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ey num *Musa taaɗ ɔɔ ne: ꞋSook koi ki te bubi ki. «Tɛr naan̰ taaɗ daala ɔɔ: Debm jaay naam kon̰ te bubin̰ se kꞋtɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","«Num gaŋ naase se, Ꞌtaaɗki ɔɔki nakŋ kɛn deba kɛɗn kon̰ ki ey lɛ bubin̰ ki se, jaay ɗeekga ɔɔ: ‹Kɛse tɛɗga kɔrban.› Kɔrban se je ɗeekŋ ɔɔ: nakŋ se ɔɔpga gɛn Raa. Ɔɔki, debm bin se kɔŋ noogŋ kon̰ ute bubin̰ ey sum. Kɛn bin se naan̰ je tɛɗn bɛɛ kon̰ ki ute bubin̰ ki kic num, naase Ꞌgaasin̰ki. ");
INSERT INTO kyq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ꞋTɛɗki bin se, naase Ꞌtujki taar Raa, Ꞌdooyki jeege ɓo ute nakŋ ɓugsege. Ɔɔ naase utu Ꞌtɛɗki nakgen kuuy dɛna tec napar nakgen se.» ");
INSERT INTO kyq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gɔtn se Isa daŋo jee dɛnge daala ɔɔ ɗeekɗen ɔɔ: «Uɗki bia ɔɔ Ꞌbooy ɔkki taar kɛn maam mꞋasen taaɗ se! ");
INSERT INTO kyq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kɛn tuj debkilimi naan Raa ki se nakŋ naan̰ uun ɔl taarin̰ ki jaay ɓaa maakin̰ ki se eyo, num gaŋ nakŋ iin̰o saapin̰ ki jaay teec taarin̰ ki se ɓo, kɛn tujin̰ naan Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ꞋBooyki bɛɛ, debm ɔk bi booyo num, Ꞌbooy ɔk taar se. ");
INSERT INTO kyq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kɛn Isa jaay iin̰ ɔn̰ jee dɛnge ɔɔ ɓaa ɓeen se, gɔtn se jee mɛtin̰ ki tɔnd mɛtin̰a ɔɔ: «ꞋTaaɗjen tu mɛtn kaal naagŋ taar se.» ");
INSERT INTO kyq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɔɔ naan̰ tɛrlɗen ɔɔ: «Naase kic taar se Ꞌbooy ɔkki mɛtin̰ ey ne? Naase Ꞌjeelki ey la nakŋ kɛn debkilimi ɔs jaay bɔɔy ɓaa maakin̰ ki se an̰ kɔŋ tujin̰ naan Raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Taa nakŋ debkilimi jaay ɔs se, bɔɔy ɓaa maakin̰ ki ɔɔ tɛɗga num, ɓaa naamin̰ ci naatn.» Kɛn Isa taaɗ bin se ɔɔ nakŋ kɔsɔ paac se ɔk taar eyo, debkilimi Ꞌkɔŋ kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Isa tɛrl taaɗɗen daala ɔɔ: «Nakŋ iin̰o saapm debkilim ki jaay teec taarin̰ ki se ɓo, kɛn tujin̰ naan Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Taa saapgen jig ey paac se teeco maakŋ debkilim ki. Kɛse ɓo kɛn ɔl jeege lee ɛɛs naapa rɛn̰ rɛn̰, ɓoogo, tɔɔl jeege, ");
INSERT INTO kyq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɛɛs mɛnd jeege ɔɔ gaabm jeege, tɛɗ jee tamage, tɛɗ *kusin̰ ɓaa ute naanɗe, aan̰ jeege dala, tɛɗ nakŋ maakɗe jea, tɛɗ maak‑kilimi ro jeege tu, naaj jeege, nook roɗe ɔɔ ɔlɗe naaɗe tɛɗ jee dɛrlge. ");
INSERT INTO kyq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nakgen kusin̰ ese paac se teeco saapm debkilim ki, kɛse ɓo kɛn tujin̰ naan Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kɛn Isa taaɗ naŋ taarin̰ se, naan̰ iin̰ ɔn̰ gɔtn se ɔɔ ɓaa taa naaŋ Tir ki. Naan̰ aan se, ɛnd maakŋ ɓee ki. Naan̰ je nam jeel gɔtin̰ eyo, naɓo ɔŋ te gɔtn naan̰ an koom eyo. ");
INSERT INTO kyq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Gɔtn se mɛnda kalaŋ bini, mɛnd Yaud eyo. Naan̰ se mɛnd Penisi tiŋg taa naaŋ Siri ki ɔɔ naan̰ ɔk goon mɛnda ɔɔ goonin̰ se ɔk kɔɔn̰ sitan. Mɛnd se booyga jꞋɔɔs kɔɔs maan Isa, gɔtn se naan̰ naar ɓaaɗo ɔŋin̰a, ɛrg mɛtn jɛn̰ ki ɔɔ tɔnd mɛtin̰ ɔɔ n̰Ꞌtuurin̰ sitan ro goonin̰ ki se naatn. ");
INSERT INTO kyq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gaŋ Isa taaɗin̰ ɔɔ: «Ɔn̰ gaange se ɔs aasɗe jaayo. Mɛt ki eyo kɛn gaange ɔs dɛrɛŋ te ey sum ɓo kꞋtɔsn kɛɗn kɔsn se gaan bɛsge tu.» ");
INSERT INTO kyq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Num gaŋ mɛnda se tɛrlin̰ ɔɔ: «Ɗeere Mɛluma, kɔsn si ji gaange tu mɛtn tabil ki se ɓo gaan bɛsge tuun ɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Isa tɛrlin̰ ɔɔ: «ꞋƁaa, do taari ki se gooni sitan teec ɔn̰in̰ga.» ");
INSERT INTO kyq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kɛn mɛnda jaay tɛrl aan ɓeen̰ ki se, ɔŋ goonin̰ sitan teec ɔn̰in̰ga ron̰ tɔɔlin̰ga, tooɗ tooɗ daŋal ki. ");
INSERT INTO kyq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Naan̰ kɛn se, Isa iin̰ ɔn̰ taa naaŋ Tir ɔɔ tɛrl ɓaa taa naaŋ Sidɔŋ ki ɔɔ naan̰ aal kaam taa naaŋ kɛn kꞋdaŋin̰ Gɛgɛrgen Sik jaay ɔk tɛrlo kaam aak taa baar Galile. ");
INSERT INTO kyq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gɔtn se jꞋɔk kꞋɓaano ute debm duguyu ɔɔ debm duguy se kɛn taaɗ kic ɓo jꞋɔŋ kꞋbooy kꞋjꞋɔk mɛc eyo, jeege eem nɔɔ mɛtn Isa ki ɔɔ n̰Ꞌɔnd jin̰ don̰ ki taa an̰ kɛɗn lapia. ");
INSERT INTO kyq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isa ɔk gaabm se, ɓaansin̰ dɔk ute jee dɛnge, ɔl jin̰a bin̰ ki ɔɔ tɛrl tup ɓooro jin̰ ki ɔɔ ut rɔɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gɔtn se naan̰ uun kaamin̰ raan ɔɔ ɔl kon̰ pirr ɔɔ naan̰ ɗeek gaab kɛn se ɔɔ: «Eppata!» Eppata se je ɗeekŋ ɔɔ: ɔɔɗɔ! ");
INSERT INTO kyq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Gɔtn se gaaba naar booyo, rɔɔn̰in̰ tɛrlɛ ɔɔ naan̰ baag taaɗn cɛy. ");
INSERT INTO kyq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Isa taaɗɗen ɔɔ jꞋɔn̰te taaɗn nam ki. Gaŋ jee se taaɗ jeege tu uun sird sird. ");
INSERT INTO kyq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Naaɗe aak nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo, ɗeek ɔɔ: «Naan̰ se tɛɗn nakgen paacn̰ jig aak eyo. Tɛɗ jee duguyge booyo ɔɔ jee ɔŋ taaɗ taar ey kic ɓo taaɗa!» ");
INSERT INTO kyq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Maakŋ ɓiige tun se, jeege ɓaaɗo tus dɛn daala num ɗim naaɗe kɔs kic ɓo gɔtɔ. Gɔtn se Isa daŋo jee mɛtin̰ ki ɔɔ taaɗɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Jee dɛn ese maam mꞋaakɗe se mꞋɛɛjɗenga doɗe ki, taa naaɗe tɛɗga ɓii mɔtɔ ute maama ɔɔ ɗim kɔsɗe gɔtɔga. ");
INSERT INTO kyq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kɛn mꞋɔn̰ɗen naaɗe ɓaaga ute ɓoɗe num, naaɗe ɓaa baatn ɗoob ki, taa jee mɛtin̰ge se iin̰o gɔtn dɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jee mɛtin̰ ki tɛrlin̰ ɔɔ: «Gɔtɔ lɛ dɔk ute ɓea; gɔtn ara se jꞋaɗe kɔŋ mappa gay jaay jꞋaɗe kɛɗn naaɗe kɔsn dɛrɛŋ se?» ");
INSERT INTO kyq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isa tɔnd mɛtɗe ɔɔ: «Naase tap ɓo ɔkki mappa kando?» Ɔɔ naaɗe tɛrlin̰ ɔɔ: «Naaje kꞋjꞋɔk cili.» ");
INSERT INTO kyq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Gɔtn se Isa ɗeek jee dɛnge tu ɔɔ kꞋjꞋiŋg naaŋ ki. Naan̰ tɔs mappan cili se jin̰ ki, tɔɔm *Raa aas se, naan̰ dup ɛɗin̰ jeege tun mɛtin̰ ki ɔɔ naaɗe ɓaa nigin̰ jee dɛnge tu. ");
INSERT INTO kyq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naaɗe ɔk kɛn̰jge sɛɛm sɛɛm kandum bin kici. Taa naan̰ se Isa tɔɔm Raa kici ɔɔ ɗeek jee mɛtin̰ ki ɔɔ ɓaa nigɗesin̰ki kici. ");
INSERT INTO kyq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gɔtn se jeege ɔs dɛrɛŋ ute maraadɗe. Ɔɔ togŋ ɔɔp se, jee mɛtin̰ ki tɔs ɔmbin̰ maakŋ gɔrnge tu cili. ");
INSERT INTO kyq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jeegen ɔs se ɓaa ɓaa nakŋ dupu‑sɔɔ. Jaay Isa ɔlɗen kꞋwɔɔk kꞋɓaa. ");
INSERT INTO kyq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gɔtn se naan̰ naar ook maakŋ markab ki ute jee mɛtin̰ ki ɔɔ gaaŋ ɓaa taa naaŋ kɛn kꞋdaŋin̰ Dalmanuta. ");
INSERT INTO kyq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Parizige ɓaaɗo baag naajn̰ ute Isa. Naaɗe je an̰ goom kɔkŋ do taarin̰ ki, tɔnd mɛtin̰ ɔɔ n̰Ꞌtɛɗɗen nakŋ‑kɔɔɓm kɛn iin̰o gɔtn Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Isa ɔl kon̰ pirr, ɗeek ɔɔ: «Jee duni kɛn ɓɔrse jaay je nakŋ‑kɔɔɓɔ se gɛn ɗi? ꞋBooyki bɛɛ, mꞋasen taaɗa, jee se jꞋaɗen tɛɗn nakŋ‑kɔɔɓm gam eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Gɔtn se Isa ute jee mɛtin̰ ki iin̰ ɔn̰ɗe, ook maakŋ markab ki ɔɔ gaaŋ deel ɓaa jɛŋ kɛn kaam naane. ");
INSERT INTO kyq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kɛn naaɗe ɓaa ɓaa te markabɗe do maane ki se, jee mɛtin̰ ki aak se ɔɔpɗenga mappa kalaŋ sum, taa naaɗe dirigɗenoga tɔso te mapp eyo. ");
INSERT INTO kyq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gɔtn se Isa baagɗe dɛjɛ ɔɔ: «Ɔɔɗki dose ɔɔ ɔndki kɔndɔ ute ɔrɔm Parizige ɔɔ ute gɛn Ɛrɔd se.» ");
INSERT INTO kyq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gɔtn se jee mɛtin̰ ki baag naajn̰ ute naapa se, taa naaɗe tɔso te mapp eyo. ");
INSERT INTO kyq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gaŋ Isa jeelga maak‑saapɗe se ɗeekɗen ɔɔ: «Taa ɗi jaay naase Ꞌnaajki ute naapa ɔɔ kꞋjꞋuunkiro te mapp ey se? Ɓɔrse kic ɓo naase aak ɔkki te eyo ɔɔ Ꞌbooy ɔkki te ey rɔk la? Lɔɓu Ꞌbooy ɔkki te mɛtn taar se ey lɛ? ");
INSERT INTO kyq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nakŋ maam mꞋtɛɗ se, naase aakin̰kiga naɓo aak ɔkin̰ te eyo ɔɔ nakŋ maam mꞋtaaɗsen se Ꞌbooyki naɓo Ꞌbooy ɔkin̰ te eyo. Naase Ꞌsaapki tu, ");
INSERT INTO kyq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kɛn mꞋdup mappan mii jaay mꞋɛɗ gaabge tun dupu‑mii ɔs se, kɛn ɔɔp se naase Ꞌtuun Ꞌɗoockiro gɔrnɔ kando?» Naaɗe tɛrlin̰ ɔɔ: «Sik‑kaar‑dio.» ");
INSERT INTO kyq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ɔɔ kɛn mꞋdupo mappagen cili jaay mꞋɛɗ jeege tun dupu‑sɔɔ ɔs se, mɛt kɔɔpin̰ se naase Ꞌtɔskiro gɔrnɔ kando?» Naaɗe tɛrlin̰ ɔɔ: «Cili.» ");
INSERT INTO kyq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gɔtn se Isa tɛrl taaɗɗen daala ɔɔ: «Te naan̰ se kic ɓo, naase Ꞌbooy ɔkki te ey ɓɔrt la?» ");
INSERT INTO kyq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Isa ute jee mɛtin̰ ki jaay aan naaŋ kɛn Bɛtsaida ki se. Gɔtn se jeege ɔk ɓaan̰o ute debm kaam‑tɔɔkɔ ɔɔ eemin̰ nɔɔ ɔɔ n̰Ꞌɔl jin̰ n̰Ꞌutin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isa ɔk ji debm kaam‑tɔɔkɔ ɔɔ tɔɔɗ teecn̰sin̰ naata maakŋ naaŋ kɛn se. Ɔɔ naan̰ baagin̰ tupm ɓooro kaamin̰ ki ɔɔ ɔnd jin̰ don̰ ki ɔɔ tɔnd mɛtin̰a ɔɔ: «Naai aak ɗim lɔɓu gɔtɔ?» ");
INSERT INTO kyq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Debm kaam‑tɔɔkɔ se ɔɔɗ kaamin̰a ɔɔ ɗeek ɔɔ: «Yɛɛ, maam mꞋaak jeege lee lea, naɓo mꞋaakɗen tec aan gɔɔ kaagge.» ");
INSERT INTO kyq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gɔtn se, Isa tɛrl ɔnd jin̰ kaam gaab kɛn se daala ɔɔ gaabm se ɔŋ lapia, kaamin̰ ɔɔɗ aak kɛlɛŋ. ");
INSERT INTO kyq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Isa taaɗin̰ ɔɔ: «Ɔn̰te Ꞌkaal ute maakŋ ɓea ɔɔ uun ɗoobi, Ꞌɓaa ɓei ki.» ");
INSERT INTO kyq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isa iin̰ ɓaa ute jee mɛtin̰ ki, ɓaa maakŋ naaŋge tun cɛɛ gɛgɛr Sezare kɛn taa naaŋ Pilip ki. Kɛn naaɗe ɓaa ɓaa ɗoob ki se, Isa tɔnd mɛtɗe ɔɔ: «Gɛn jeege tu num, maam se tap ɓo mꞋnaŋa?» ");
INSERT INTO kyq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naaɗe tɛrlin̰ ɔɔ: «Jee mɛtin̰ge ɔɔ naai Jan‑Batist, jee kuuy ɔɔ naai *Ɛli; kɛngen kuuy taaɗ ɔɔ naai se deb kalaŋ maakŋ jeege tun taaɗ taar teeco taar Raa ki do dɔkin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Num Isa tɔnd mɛtɗe daala ɔɔ: «Gɛn naase ki num, ɔɔki maam tap ɓo mꞋnaŋa?» Piɛr tɛrlin̰ ɔɔ: «Naai ɓo al‑Masi.» ");
INSERT INTO kyq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Gɔtn se Isa aacɗen kaama ɔɔ taar se jꞋɔn̰te ɓaa taaɗn nam ki. ");
INSERT INTO kyq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gɔtn se, Isa baag dooy jee mɛtin̰ ki ɔɔ bɛɛki se, *Goon Deba se utu Ꞌdabar kusin̰ aak eyo. Magal taa ɓee Yaudge, *magal jee tɛɗn sɛrkɛ Raage tu, ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage, naaɗe se utu an̰ kɔɔɗn kundu ɔɔ utu an̰ tɔɔlɔ. Naan̰ ooy, tɛɗga ɓii mɔtɔ jaay ɓo sɔm, aɗe duru. ");
INSERT INTO kyq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Taar se naan̰ taaɗɗesin̰ tal tal. Gaŋ gɔtn se Piɛr daŋ ɓaansin̰ cɛɛs ki ɔɔ baagin̰ mooyo. ");
INSERT INTO kyq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Num gaŋ Isa tɛrl aak jee mɛtin̰ ki, aac kaama Piɛr ki, ɗeekin̰ ɔɔ: «*Ɓubm sitange, iik naatn cɛɛm ki gam naane! Taa saapm naai se gɛn Raa eyo, kɛse saapm jikilimge.» ");
INSERT INTO kyq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gɔtn se Isa daŋo jee dɛnge ute jee mɛtin̰ ki, taaɗɗen ɔɔ: «Debm jaay je am daan num, Ꞌbaatn ron̰ mala, Ꞌkuun kaagŋ yon̰a jaay ɓo am daana. ");
INSERT INTO kyq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Taa debm jaay je kaajn̰ kon̰ se utu an̰ kutu naan Raa ki, ɔɔ debm ut kon̰a taa maama ɔɔ taa Labar Jiga se utu an̰ kaaja. ");
INSERT INTO kyq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kɛn debm jaay *duni ute magalin̰ ɓo kaam jin̰ kic num, kɛn naan̰ kutn kon̰ naan Raa ki se, naan̰ an kɔŋ ɗi ro ki? ");
INSERT INTO kyq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ey num debkilimi se kon̰a se, naan̰ an̰ dugin̰ ute ɗio? ");
INSERT INTO kyq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɔɔ jee dunia kɛn ɓɔrse tɛɗga jee *kusin̰ge ɔɔ tujga ɔrmɗe naan Raa ki se, naan naaɗe ki se jaay debm tɛɗ sɔkɔn̰ɔ taa maama ɔɔ taa taarum se, maam *Goon Deba kic ɓo sɔkɔn̰ɔ utu am tɔɔl taa naan̰ kici, ɓiin mꞋaɗe ɓaa maakŋ Gaar Bubum ki ɔɔ ute gɛn kɔɗin̰gen *salal se.» ");
INSERT INTO kyq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Gɔtn se Isa ɗeekɗen daala ɔɔ: «Ɗeere, Ꞌbooyki bɛɛ, mꞋasen taaɗa: maakŋ jeege tun ɓɔrse utu ara se, mɛtin̰ge se kooy ey sum ɓo utu kaakŋ maakŋ *Gaar Raa kɛn aɗe bɔɔy te tɔɔgin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kɛn ɓii mɛcɛ jaay deel se, Isa daŋ Piɛr, Jak ute Jan ɔk ɓaanɗe do ko ki jɛrlɛ kalɗe ki. Kɛn naaɗe aan se, gɔtn se Raa ooj tɛrlin̰ ron̰a naanɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kalin̰ge ɓaa tɛɗ raap lak lak ɔɔ ɔmb mɛt ki birin̰ birin̰. Debm do naaŋ ki jaay kɛcn̰ kɔɔɗn kalin̰ aan gɔɔ naan̰ se, gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Gɔtn se, jee mɛtin̰ kɛn mɔtɔ se naar aak *Ɛli ute *Musa teec naanɗe ki, ɗaar taaɗ taaɗ ute Isa. ");
INSERT INTO kyq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piɛr ɗeek Isa ki ɔɔ: «Debm dooyje, bɛɛki num, jꞋaki kiŋg gɔtn ara ki ɓo jiga; ɔn̰ jꞋasen taal daabge mɔtɔ, kalaŋ naai ki, kalaŋ Musa ki ɔɔ kalaŋ Ɛli ki.» ");
INSERT INTO kyq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kɛn naaɗe ɓeere jaay ɓaa ɔkɗe se, taar kɛn Piɛr taaɗ se kic ɓo taaɗ rɛn̰ sum, jeel mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Gɔtn se, gapara naar ɓaaɗo deebɗe bat. Ɔɔ maakŋ gapar ki se, kꞋbooy mind deba taaɗ ɔɔ: «Naan̰ se Goonuma, kɛn maam jen̰a. ꞋBooy uunki taarin̰a!» ");
INSERT INTO kyq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gɔtn se, jee mɛtin̰ ki naar tɛrl aak cɛɛsɗe ki se, nam gɔtɔ ɔɔp Isa kalin̰ ki ɓo ute te naaɗe sum. ");
INSERT INTO kyq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kaaɗ kɛn naaɗe utu bɔɔyɔ bɔɔy kon se, Isa dɛjɗe ɔɔ: «Ɓɛrɛ, nakŋ naase aakkiro se, ɔn̰te Ꞌtaaɗki nam ki, bini *Goon Deba se aɗe dur daan yoge tu jaayo.» ");
INSERT INTO kyq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gɔtn se naaɗe uun taarin̰a, gaŋ naaɗe naaj ute naapa do taar kɛn naan̰ taaɗ ɔɔ utu aɗe dur daan yoge tu se, taar se tap ɓo, je taaɗn ɔɔ ɗi? ");
INSERT INTO kyq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Gɛn ɗi jaay jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage taaɗ ɔɔ Ɛli aɗe ɓaa jaay *al‑Masi aɗe ɓaa se?» ");
INSERT INTO kyq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Naan̰ tɛrlɗen ɔɔ: «Ɗeere, Ɛli utu aɗe ɓaao ɔɔ naan̰ ɓo utu tɔnd ɗaapm nakge paac ute ɗoobin̰ jaayo. Num Ꞌbooyki mꞋasen taaɗa: Ɛli se lɛ ɓaaɗoga, naɓo jeege tɛɗin̰ga nakŋ naaɗe maakɗe je don̰ ki, aan gɔɔ kɛn Kitap taaɗo do dɔkin̰a. Num tɛr maakŋ Kitap ki se, Raa taaɗga taaɗ kic ey la ɔɔ Goon Deba se, utu dabar kusin̰a ɔɔ jeege utu an̰ baate.» ");
INSERT INTO kyq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kɛn Isa ute jee mɛtin̰ kɛn mɔtɔ jaay ɓaaɗo ɔŋ jee mɛtin̰gen kuuy se, naaɗe aak jeege dɛna iŋg gurugɗe. Gɔtn se jee jeel taaɗ tɔɔkŋ mɛtn Ko Taar Raage kic ɓo utu daan jeege tun se. Naaɗe iŋg naaj naaj ute jee mɛtin̰ kɛn se. ");
INSERT INTO kyq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kɛn jeege jaay aak Isa utu ɓaaɗo se, naaɗe paac dɔrlɔ ɔɔ aan̰ ɓaaɗo tɛɗin̰ tɔɔsɛ. ");
INSERT INTO kyq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Isa tɔnd mɛtɗe ki ɔɔ: «Ɔŋki ɗi jaay naase iŋg Ꞌnaajki taara ute naaɗe se?» ");
INSERT INTO kyq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Deb kalaŋ maakŋ jee dɛnge tu se ɗeekin̰ ɔɔ: «Debm dooy jeege, maam se mꞋɓaano ute goonum gaaba ɔɔ goonum se ɔk kɔɔn̰ sitan gaasin̰ ɔŋ taaɗ taar eyo. ");
INSERT INTO kyq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gɔtn mɛtin̰ se kɛn sitan ɔkin̰ga tak ɓo, uun undin̰ naaŋ ki, tɛɗin̰ taarin̰ tiin̰ gupiyu, ɔlin̰ taan̰ naaŋin̰a, tɛɗga num, ron̰ buj biŋ. Maam mꞋtɔndo mɛtn jee mɛti ki mꞋɔɔ am tuur sitan ro goonum ki, naɓo naaɗe ɔŋ aasin̰ te eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Isa ɗeekɗen ɔɔ: «Naase jee do duni kɛn ɓɔrsen aalki maakse do Raa ki ey se, maam tap ɓo mꞋkiŋg ute naase bini nuŋ ki jaayo? Maam tap ɓo mꞋasen sɛrkŋ bini nuŋ ki? Goono se ɔk Ꞌɓaamsin̰kiro!» ");
INSERT INTO kyq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naaɗe jaay ɔk ɓaano ɓaa ute goono se ɔɔ kɛn sitan jaay aak Isa se, baag tiikŋ goono, uun undin̰ naaŋ ki ɔɔ dircilin̰a ɔɔ taarin̰ tiin̰ gupiyu. ");
INSERT INTO kyq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isa tɔnd mɛtn bubin̰a ɔɔ: «Kɔɔn̰in̰ se tɛɛsin̰ nuŋ ki?» Bubm goono se tɛrlin̰ ɔɔ: «Kɔɔn̰in̰ se tɛɛsin̰ baatin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gɔtn mɛtin̰ge sitan se iin̰ga num ɔlin̰ naan̰ tooc maakŋ pooɗ ki ey lɛ maakŋ maane ki taa je an̰ tɔɔlɔ. Ɛɛjjen doje ki, Ꞌnoogje kɛn naai jaay an̰ kaasin̰ num.» ");
INSERT INTO kyq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Gaŋ Isa tɛrlin̰ ɔɔ: «Gɛn ɗi jaay naai taaɗ ɔɔ: ‹Kɛn an̰ kaasin̰ num› se? ꞋBooyo, ne ɗim ɔɔn̰ cir deb kɛn aal maakin̰ do Raa ki se gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gɔtn se, bubm goono naar ɔɔɗ ɔɔyɔ ɔɔ: «Maam mꞋaal maakuma naɓo Ꞌɓaaɗo Ꞌnooguma taa maam mꞋkaal maakum paac don̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kɛn Isa jaay aak jeege dɛna aan̰ ɓaaɗo ɔŋɗe kɔŋ se, naan̰ aac kaama sitan ki ɔɔ: «Naai sitan debm tɛɗn jeege duguyu ɔɔ gaasɗe ɔŋ taaɗ taar ey se, mꞋɗeeki: Ꞌteec naatn ro goon ki se ɔɔ mɔɔtn Ꞌɓaaɗo eyo!» ");
INSERT INTO kyq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Num sitan se tɔɔy makɔn̰ɔ, tiikin̰ zak zak, jaay teece. Gɔtn se jeege baag taaɗn ɔɔ: «Goono se ooyga!» Taa naaɗe aakin̰ naan̰ tooɗ pɛyɛd. ");
INSERT INTO kyq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gaŋ Isa ɔk ji goono, uunin̰a ɔɔ goono se iin̰ ɗaar te jɛn̰a. ");
INSERT INTO kyq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɛn Isa jaay ɔk tɛrl ɓaa ɓeen se, ɔɔpin̰ kalin̰ ki ute jee mɛtin̰ ki sum se, naaɗe tɔnd mɛtin̰a ɔɔ: «Gɛn ɗi jaay ɓo sitan se naaje jꞋɔŋ kꞋtuurin̰ te ey se?» ");
INSERT INTO kyq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isa tɛrlɗen ɔɔ: «Napar sitangen bin se, kɛn kꞋtɔnd te mɛtn Raa ey num, ɔŋ teec eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naaɗe iin̰ ɔn̰ gɔtn se ɔɔ gaaŋ ɓaa taa naaŋ Galile ki. Naan̰ kɛn se, Isa je jeege Ꞌjeel gɔtin̰ eyo, ");
INSERT INTO kyq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","taa naan̰ dooy dooy jee mɛtin̰ ki ɔɔ taaɗɗen ɔɔ: «*Goon Deba se jꞋutu jꞋan̰ kɔkŋ kɔl ji jeege tu. Naaɗe utu an̰ tɔɔlɔ ɔɔ ɓii k‑mɔtɔge tu se naan̰ aɗe dur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Num gaŋ jee mɛtin̰ ki se, taar se, naaɗe ɔŋ booy ɔk te mɛtin̰ eyo, gaŋ naaɗe ɓeere gɛn tɔnd mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naaɗe aan Kaparnayum ki. Kɛn naaɗe jaay ɛnd ɓeen se, gɔtn se Isa tɔnd mɛtɗe ɔɔ: «Taa ɗi jaay naase Ꞌnaajkiro taara ɗoob ki se?» ");
INSERT INTO kyq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gaŋ naaɗe do ɗɛk, taa ɗoob ki se, naaɗe naajo ute naapa ɔɔ maakɗe ki se, naŋa ɓo magal ciri. ");
INSERT INTO kyq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gɔtn se, Isa iŋg naaŋ ki ɔɔ daŋo jee mɛtin̰ kɛn sik‑kaar‑dio ɗeekɗen ɔɔ: «Debm jaay je tɛɗn magal se, n̰Ꞌɔɔp ron̰ baata ɔɔ n̰Ꞌtɛɗ debm tɛɗn naabm jeege paac.» ");
INSERT INTO kyq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Isa uuno goon cɔkɔ ɓaano ɗaarin̰ daanɗe ki, uun ɔkin̰ kaaɗin̰ ki ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Taa maam jaay, debm ɔkga goon cɔkɔ jiga aan gɔɔ goon ese se, kɛse aan gɔɔ naan̰ ɔkum maam mala. Ɔɔ debm ɔkum maam se, ɔkum maam sum eyo, num ɔk debm kɛn ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Gɔtn se Jan ɗeek Isa ki ɔɔ: «Debm dooyje, naaje jꞋɔŋo deb kalaŋ bin se lee tuur tuur sitange ute roi. Num naaje kꞋje jꞋan̰o gaasa, taa naan̰ lɛ, lee ute naajege eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Gaŋ Isa tɛrlɗen ɔɔ: «Ɔn̰te Ꞌgaasin̰ki, taa debm jaay tɛɗ nakŋ‑kɔɔɓɔ te rom se, kɔŋ naar tɛrl taaɗn kusin̰ rom ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Debm jaay debm taamooyjege ey se, naan̰ se debm naajege. ");
INSERT INTO kyq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ꞋBooyki bɛɛ, mꞋasen taaɗa: debm jaay tak ɛɗsenga maan kaaye cɔkɔ taa naan̰ jeelin̰ naase Ꞌtɛɗkiga tɛɗ jee *al‑Masige se, debm bin se, bɛɛ naan̰ tɛɗ se Ꞌkutn cɛr eyo, num naan̰ utu Ꞌkɔŋ bɛɗin̰a.» ");
INSERT INTO kyq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Gaŋ maakŋ gaange tun sɛɛm kɛn aalga kaal maakɗe dom ki se jaay, nam ɔlga deb kalaŋ maakŋ kusin̰ ki se. Debm kɛn ɔlin̰ se, ɔn̰ bɛɛki num, jꞋuuno ko tootn magala kꞋdɔɔkin̰ mindin̰ ki ɔɔ jꞋuun jꞋundin̰ maakŋ baar ki. ");
INSERT INTO kyq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kɛn nakŋ naai Ꞌtɛɗ te jii sum ɓo ai kɔl maakŋ kusin̰ ki num, jii se Ꞌgaaŋ und naata. Ɔɔpi jii kalaŋ ɔɔ kɔŋ kaaja gɛn daayum, bɛɛ cir kɛn Ꞌkiŋg te jii dio ɔɔ Ꞌɓaa maakŋ pooɗ kɛn gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kɛn nakŋ naai Ꞌtɛɗ te jɛi jaay ai kɔl maakŋ kusin̰ ki num, jɛi se Ꞌgaaŋ und naata. Ɔɔpi jɛi kalaŋ ɔɔ kɔŋ kaaja gɛn daayum se, bɛɛ cir kɛn Ꞌlee te jɛi dio ɔɔ Ꞌɓaa maakŋ pooɗ kɛn gɛn daayum se. ");
INSERT INTO kyq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kɛn Ꞌkaami jaay ɓo ai kɔli maakŋ kusin̰ ki num, kaami se ɔɔɗ und naata. Ai kɔɔpm kaami kalaŋ ɔɔ Ꞌɓaa *maakŋ Gaar Raa ki bɛɛ cir kɛn Ꞌlee te kaami dio ɔɔ jꞋai Ꞌɓaa kundi maakŋ pooɗ kɛn gɛn daayum se. ");
INSERT INTO kyq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɔɔ gɔtn naane se: kuurge lee tɔs daayum jee roɗe tiŋg aan gɔɔ ruumga ruumu ɔɔ iŋg maakŋ pooɗ kɛn gɛn daayum se. ");
INSERT INTO kyq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ey num aan gɔɔ pooɗo ɗaap nakge se, Raa kic ɓo ɔn̰ dubar, taa ɗaapm debkilimi tɛɗn bɛɛ naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Kaata se naan̰ nakŋ jiga, num kɛn nijim kaata se naŋga num, jꞋan̰ tɛɗn jꞋɔɔ ɗi jaay nijim gɔtin̰ ki se? Bin se, naase kic ɓo Ꞌtɛɗki jee jiga aan gɔɔ kaatn iŋg bɛɛ se ɔɔ iŋgki lapia te naapa.» ");
INSERT INTO kyq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tɛr Isa iin̰ gɔt kɛn se ɔɔ ɓaa taa naaŋ Jude ki, kaam aak jɛŋ ool kꞋdaŋin̰ Jordan kɛn kaam naane. Jee dɛnge ɓaaɗo tus cɛɛn̰ ki daala ɔɔ naan̰ baagɗe dooyo aan gɔɔ kɛn naan̰ lee dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Gɔtn se *Parizigen mɛtin̰ge ɓaaɗo taa an̰ naama. Naaɗe tɔnd mɛtin̰ ɔɔ: «Deba se jꞋundin̰ga kulu gɛn piir mɛndin̰ la?» ");
INSERT INTO kyq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Naan̰ tɛrlɗen ɔɔ: «Do taar kɛn se, *Musa tap ɓo taaɗseno ɔɔ ɗi maakŋ Kitap ki?» ");
INSERT INTO kyq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Naaɗe tɛrlin̰ ɔɔ: «Musa se und kulu ɔɔ kꞋraaŋ maktubm gɛn piiri, jꞋɛɗ mɛnd ki jaay ɓo jꞋan̰ piiri.» ");
INSERT INTO kyq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Gaŋ Isa taaɗɗen ɔɔ: «Taa do‑mɔŋgse ɓo Musa raaŋsen taar se. ");
INSERT INTO kyq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ey num do kupm mɛt ki se, *Raa aalo gaaba ute mɛnda. ");
INSERT INTO kyq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Taa naan̰ se ɓo gaaba teecn̰ kɔn̰ kon̰ te bubin̰a, ɓaa tum te mɛndin̰a, ");
INSERT INTO kyq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɔɔ naaɗen di se tum tɛɗga daa ro kalaŋ.Bin se naaɗe se tɛɗga aan gɔɔ jee di eyo, num aan gɔɔ deb kalaŋ sum. ");
INSERT INTO kyq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nakŋ jaay Raa dɔɔkin̰ga dɔɔk se, debkilimi ɔn̰te tuutin̰a!» ");
INSERT INTO kyq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kɛn naaɗe jaay aan ɓeen se, jee mɛtin̰ ki tɔnd mɛtin̰ do taar kɛn se daala. ");
INSERT INTO kyq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naan̰ tɛrlɗen ɔɔ: «Kɛn deba jaay piir te mɛndin̰a ɔɔ ɔk mɛnd kuuy se, aan gɔɔ debm teec ɔn̰ mɛndin̰a ɔɔ ɓaa ɛɛs mɛnd nam. ");
INSERT INTO kyq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɔɔ mɛnda kic ɓo, kɛn piir te gaabin̰a ɔɔ ɔk gaabm kuuy se, naan̰ se aan gɔɔ mɛnd teec ɔn̰ gaabin̰a ɔɔ ɓaa ɛɛs gaabm nam.» ");
INSERT INTO kyq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gɔtn se, jeege ɓaano te gaangen sɛɛmɛ gɔtn Isa ki, taa aɗe tɔnd jin̰ doɗe ki, naɓo jee mɛtin̰ ki uunɗe kaamɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kɛn Isa jaay aak nakŋ naaɗe tɛɗ se, maakin̰ tuju, ɗeekɗen ɔɔ: «Ɔn̰ki gaangen sɛɛm se aɗe ɓaa gɔtum ki, ɔn̰te Ꞌgaasɗeki. Taa jeegen tec aan gɔɔ gaangen se ɓo utu Ꞌkɔŋ gɔtɔ *maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ꞋBooyki bɛɛ, mꞋasen taaɗa: debm jaay took te Raa kɔsn gaar don̰ ki aan gɔɔ goon cɔkɔ ey se, naan̰ se Ꞌkɔŋ kɛnd maakŋ Gaar Raa ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Gɔtn se naan̰ tuun tɔkɗe kaaɗin̰ ki, tɔnd jin̰ doɗege tu ɔɔ ɔɔɗɗen ɓooro. ");
INSERT INTO kyq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kɛn Isa jaay ɓaa ɓaa ɗoob ki se, gaaba kalaŋ aan̰ ɓaaɗo ɛrg naanin̰ ki ɔɔ tɔnd mɛtin̰a ɔɔ: «Debm dooy jeege, naai debm bɛɛ se, maam tap ɓo mꞋtɛɗn mꞋɔɔ ɗi jaay mꞋkɔŋ *kaajn̰ gɛn daayum se?» ");
INSERT INTO kyq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isa tɛrlin̰ ɔɔ: «Gɛn ɗi jaay naai ɔɔ maam debm bɛɛ se? Debkilim bɛɛ se tap ɓo gɔtɔ; kɛn bɛɛ se, Raa kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Naai lɛ Ꞌjeele nakŋ kɛn Raa taaɗ gɛn tɛɗ se, kɛn ɔɔ: Ɔn̰te Ꞌtɔɔl nam, ɔn̰te Ꞌkɛɛsn mɛnd nam, ɔn̰te Ꞌkɛɛsn gaabm nam, ɔn̰te Ꞌɓoogo, ɔn̰te Ꞌtɔkŋ taar‑kɔɔɓɔ do nam ki, ɔn̰te Ꞌkujun nam, Ꞌsook koi ki te bubi ki.» ");
INSERT INTO kyq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gaabm se tɛrl Isa ki ɔɔ: «Debm dooy jeege, nakgen se paac, gɔtn mꞋiin̰ baatum ki tap ɓo, maam mꞋlee mꞋtɛɗin̰ tɛɗ tap.» ");
INSERT INTO kyq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isa jaay aak gaabm se, maakin̰ jen̰a ɔɔ ɗeekin̰ ɔɔ: «Ɔɔpiga naka kalaŋ sum. Nakŋ naai ɔk paac se, Ꞌɓaa dugin̰ naatn ɔɔ gursin̰ se Ꞌɓaa Ꞌnigin̰ jee daayge tu, bin se ai tooɗn kɔrbɔtɔ maakŋ raa ki. Ɔɔ naai lɛ, Ꞌɓaaɗo Ꞌdaanuma.» ");
INSERT INTO kyq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Num gaŋ kɛn gaaba jaay booy taar se, ron̰ tɛrɛcin̰ bardak, ɔk tɛrl ɓaa ɓaa se maakin̰ tuj kasak kasak, taa naan̰ debm nak dɛna. ");
INSERT INTO kyq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isa uun don̰a aak jee mɛtin̰ kɛn iŋg cɛɛn̰ ki se, ɗeekɗen ɔɔ: «Kɛn jee nak dɛnge jaay, kɛnd *maakŋ Gaar Raa ki se ɔɔn̰ aak eyo!» ");
INSERT INTO kyq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jee mɛtin̰ ki jaay booy taar se ɔkɗen taaɗ eyo, num Isa tɛrl ɗeekɗen ɔɔ: «Gɛnumge, kɛnd maakŋ Gaar Raa ki se ɔɔn̰ aak eyo! ");
INSERT INTO kyq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɗeere, kɛn gin̰ji jaay deel ute ɓee luppara se ɔɔn̰ɔ; naɓo debm nak dɛna jaay Ꞌkɛnd maakŋ Gaar Raa ki se, ɔɔn̰ cir naan̰ se daala!» ");
INSERT INTO kyq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jee mɛtin̰ ki jaay booy taar se, ɔkɗen taaɗ eyo cir daala. Naaɗe taaɗ te naapa ɔɔ: «Kɛn bin num, naŋa ɓo Ꞌkɔŋ kaaja?» ");
INSERT INTO kyq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isa uun kaamin̰ aakɗe ɔɔ ɗeek ɔɔ: «Gɛn jikilimge tu sum num nakŋ se ɔɔn̰ɔ, num Raa ki se, ne ɗim ɔɔn̰in̰ gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gɔtn se Piɛr taaɗin̰ ɔɔ: «Anum Ꞌbooyo, naaje se kꞋjꞋɔn̰oga nakge paac taa jꞋai daan naai.» ");
INSERT INTO kyq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isa tɛrlin̰ ɔɔ: «ꞋBooyki bɛɛ, mꞋasen taaɗa. Kɛn nam jaay ɔn̰o ɓeege, gɛnaagen gaabge ute kɛngen mɛndge, koa, bubu, gaange ey lɛ maakŋ‑gɔtin̰ge taa maama ɔɔ taa Labar Jiga se, ");
INSERT INTO kyq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nakgen se paac se, naan̰ utu aɗen kɔŋ mɛt kaaru ɓeege, gɛnaagen gaabge ute kɛngen mɛndge, koge, gaange, maakŋ gɔtge, ɔɔ ute dubar kɛn jeege utu an̰ dabar taa maam se. Ɔɔ kɛn kaaɗin̰ jaay aanga num, naan̰ Ꞌkɔŋ kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Maakŋ jeege tun ɓɔrse naan ki se, dɛnin̰ utu kɔɔpm mɔɔtn. Ɔɔ maakŋ jeege tun ɓɔrse mɔɔtn se, dɛnin̰ utu Ꞌtɛɗn jee naan ki.» ");
INSERT INTO kyq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Naan̰ kɛn se, naaɗe uun ɗoobo gɛn kookŋ ɓaa Jeruzalɛm ki ɔɔ kɛn naaɗe jaay ɓaa ɓaa se, Isa deel naanɗe ki. Jee mɛtin̰ ki se nakŋ se deel doɗe ɔɔ jee dɛn ɔk mɛtin̰ se lɛ, ɓeere ɔkɗe. Gɔtn se naan̰ daŋ jee mɛtin̰ sik‑kaar‑di kalɗe ki ɔɔ baagɗen taaɗn nakŋ utu kaan don̰ ki se daala. ");
INSERT INTO kyq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naan̰ ɗeekɗen ɔɔ: «ꞋBooyki, ɓɔrse naaje kꞋjꞋook kꞋɓaaki ɓaa Jeruzalɛm ki ɔɔ *Goon Deba se, jꞋutu jꞋan̰ kɔkŋ kɔl ji *magal jee tɛɗn sɛrkɛ Raage tu ute ji jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage. Naaɗe utu an̰ kɔjn̰ bɔɔrɔ don̰ ki kɛn jꞋan̰ ɓaa tɔɔlɔ ɔɔ utu an̰ kɔkŋ kɔlin̰ ji jeege tun Yaudge eyo. ");
INSERT INTO kyq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Naaɗe se utu an̰ tooy koogo mɛtin̰ ki, an̰ tupm ɓooro ron̰ ki, an̰ tɔnd te mɛɛjɛ ɔɔ utu an̰ tɔɔlɔ. Anum, kɛn ooy tɛɗga ɓii mɔtɔ se, naan̰ utu aɗe dur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jak te Jan gaan Zebedege ɓaaɗo ɔŋ Isa ɔɔ tɔnd mɛtin̰a ɔɔ: «Debm dooyje, bɛɛki num, nakŋ naaje kꞋje kꞋtɔnd mɛti ro ki se, naai ajen tooko.» ");
INSERT INTO kyq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Isa tɛrlɗen ɔɔ: «Naase Ꞌjeki mꞋasen tɛɗn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Naaɗe tɛrlin̰ ɔɔ: «Kɛn naai aɗe tɛrl maakŋ gaari ki se, ɔn̰jen deb kalaŋ kiŋg do ji daami ki ɔɔ kɛn kalaŋ do ji jeeli ki.» ");
INSERT INTO kyq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Gaŋ Isa tɛrlɗen ɔɔ: «Nakŋ naase Ꞌtɔndki mɛta ro ki se, naase Ꞌjeel ɔkki te mɛtin̰ eyo.» Gɔtn se naan̰ ɗeekɗen ɔɔ: «*Kɔɔpm dubar maam mꞋutu mꞋkaay se, naase an̰ki kɔŋ kaasn gɛn kaayin̰ la? Lɔ *batɛm maam mꞋutu mꞋtɛɗ se, naase an̰ki Ꞌkɔŋ kaasn gɛn tɛɗin̰ la?» ");
INSERT INTO kyq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Naaɗe tɛrlin̰ ɔɔ: «Yɛɛ, naaje jꞋan̰ kɔŋ kaasa.» Naɓo Isa ɗeekɗen ɔɔ: «Ɗeere, naase utu aki kaay kɔɔpm kɛn maam mꞋutu mꞋkaay se ɔɔ utu aki tɛɗn batɛm aan gɔɔ kɛn maam mꞋutu mꞋtɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Naɓo gɛn gɔtn kiŋg jaay do ji daamum ki, ey lɛ do ji jeelum ki se, ɔlum maam eyo. Gɔtn se Raa ɗaapin̰ga ɗaap malin̰ge tu.» ");
INSERT INTO kyq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kɛn jee mɛtn Isa kɛn sik jaay ɓaa booy taar ese se, maakɗe tuju do Jak te Jan ki. ");
INSERT INTO kyq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Isa daŋɗeno paac ɔɔ ɗeekɗen ɔɔ: «ꞋJeelki, jeegen kꞋtɔlɗe gaarge do mɛtjil jeege tun ɓaa se paac se, naaɗe iŋg doɗe ki ɔɔ magalgen kꞋtɔndɗe se tɛɗ jeege te taa tɔɔgɔ. ");
INSERT INTO kyq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Num daan naase ki se ɔn̰te Ꞌtɛɗn bini. Kɛn maakse ki jaay nam je tɛɗn magalse se, ɔn̰ ron̰ tɛɗn debm kaan̰ naabse. ");
INSERT INTO kyq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɔɔ maakse ki se jaay nam je tɛɗn naanse se ɔn̰ ron̰ asen tɛɗn ɓulse paac. ");
INSERT INTO kyq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Taa *Goon Deba ɓaaɗo se, taa jeege ɓo an̰ tɛɗn naab eyo; num naan̰ ɓaaɗo se taa naan̰ ɓo tɛɗn naaba jeege tu ɔɔ kɛɗn kon̰ gɛn dugŋ do jee dɛna.» ");
INSERT INTO kyq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Isa te jee mɛtin̰ ki aan maakŋ gɛgɛr kɛn kꞋdaŋin̰ Jeriko ki. Kɛn naaɗe deel deel jaay aan taar ki se, jeege dɛna ɔk mɛtɗe. Gɔtn se naaɗe ɔŋ debm kaam‑tɔɔkɔ jɛŋ ɗoob ki iŋg baay baaya ron̰ Bartime, goon Time. ");
INSERT INTO kyq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kɛn naan̰ booy jaay jꞋɔɔ Isan Nazarɛt ɓo deel deel se, naan̰ baag tɔɔy ɔɔ: «Isa, naai *Goon Daud, ɛɛjum dom ki!» ");
INSERT INTO kyq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jeege dɛna uunin̰ kaamin̰a ɔɔ n̰Ꞌdoa, gaŋ naan̰ tɔɔɗ tɔɔy makɔn̰ɔ cir daala ɔɔ: «Goon Daud, ɛɛjum dom ki!» ");
INSERT INTO kyq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Isa ɔk ɗaara ɔɔ ɗeek ɔɔ: «ꞋDaŋumsin̰kiro.» Naaɗe ɓaa ɔŋin̰a, ɗeekin̰ ɔɔ: «Isa daŋi. Ɔk Ꞌmaaki tɔɔgɔ, iin̰i.» ");
INSERT INTO kyq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gɔtn ese debm kaam‑tɔɔkɔ ɔɔɗ und te kal magalin̰a, naar iin̰ kirit ɔɔ ɓaa gɔtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isa tɔnd mɛtin̰ ɔɔ: «ꞋJe mꞋai tɛɗn ɗi?» Debm kaam‑tɔɔkɔ tɛrlin̰ ɔɔ: «Debm dooyje, ɔɔɗum kaamuma.» ");
INSERT INTO kyq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Isa taaɗin̰ ɔɔ: «ꞋƁaa. Taa naai aalga maaki dom ki se, ɔŋga lapia.» Gɔtn se kaamin̰ naar ɔɔɗ aaka ɔɔ naan̰ ɔk ɗoobo ute Isa tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kɛn Isa te jee mɛtin̰ ki jaay aan gɔɔr te Jeruzalɛm se, naaɗe aan do *kɔsn ɔlib ki kɛn cɛɛ naaŋge tun kꞋdaŋɗe Bɛtpajɛ te Betani. Gɔtn se maakŋ jeen̰ge tun mɛtin̰ ki se, Isa ɔl jeege di naaba. ");
INSERT INTO kyq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Naan̰ ɗeekɗen ɔɔ: «ꞋƁaaki maakŋ naaŋ kɛn naanse ki se. Kɛn naase ɛndki kɛnd se, aki kɔŋ goon buuru kꞋdɔɔkin̰ga dɔɔkɔ ɔɔ nam ɓii kalaŋ ook te do ki eyo. ꞋTuut Ꞌɓaansin̰kiro. ");
INSERT INTO kyq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kɛn nam jaay ɗeeksenga ɔɔ: gɛn ɗi jaay naase Ꞌtɛɗki nakŋ se? ꞋTɛrlin̰ki ɔɔki: Mɛlje ɓo jen̰a ɔɔ tɛɗga sum ɓo, asesin̰o naar tɛrl gɔtin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kɛn naaɗe jaay ɓaa aan se, ɔŋ goon buuru ɗoob ki kꞋdɔɔkin̰ga dɔɔk taa ɓee ki ɔɔ naaɗe tuutin̰o. ");
INSERT INTO kyq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jee kɛn naaɗe ɔŋɗe gɔtn ese se, jee mɛtin̰ge aakɗe se ɗeekɗen ɔɔ: «Goon buuru se, Ꞌtuutin̰ki gɛn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Naaɗe tɛrlɗen aan gɔɔ kɛn Isa taaɗɗeno ɔɔ jee se ɔn̰ɗe naaɗe tuuto goon buuru se. ");
INSERT INTO kyq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Naaɗe ɔk ɓaansin̰ Isa ki, tɔɔɗ taal kal magalɗege do buur ki se jaay Isa iŋg do ki. ");
INSERT INTO kyq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jeege dɛna tɔɔɗ taal kal magalɗege ɗoob ki. Ɔɔ jee mɛtin̰ge gaaŋo doomo maakŋ kaag ki, ɓaaɗo tɔmbin̰ ɗoob ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jee deel naanin̰ ki ɔɔ jee ɔk mɛtin̰a ɗɔɔb ɔɔy ɔɔ: «Ozaana! Ozaana!» «*Raa tɛɗn bɛɛn̰ do deb kɛn ɓaaɗo te ro Mɛljege Raa!» ");
INSERT INTO kyq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","«Raa tɛɗn bɛɛn̰ do deb kɛn ɔs gaar gɛn bubjege *Daud!» «Ozaana Raa kɛn raan maakŋ raa ki!» ");
INSERT INTO kyq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Isa ɛnd maakŋ gɛgɛr kɛn Jeruzalɛm ki ɔɔ naan̰ ɓaa ɛnd maakŋ *Ɓee Raa ki. Kɛn naan̰ bɛɛr aak dɔɔɗ nakge paac aas se, kaaɗ kɛn se kaaɗa ɓaaga. Gɔtn se naan̰ teec ɓaa ute jee mɛtin̰ kɛn sik‑kaar‑di se Betani ki. ");
INSERT INTO kyq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mɛtbeen̰ki, kɛn naaɗe iin̰o Betani ki se, Isa naam ɓo tɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kɛn naan̰ jaay uun kaamin̰ aak ko ba ɗaar ɗaar te kambin̰ dɔk naane se ɔɔ kaaɗn naane kɔŋ koojin̰ kɔsɔ. Naɓo kɛn naan̰ jaay ɓaa mɛtin̰ ki se naan̰ ɔŋ kamba sum taa kaaɗn koojn̰ ko ba se ute ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Gɔtn se Isa taaɗ ko ba ki se ɔɔ: «Naan ki se mɔɔtn nam kɔsn naam kooji ey sum.» Gaŋ taar naan̰ taaɗ se jee mɛtin̰ ki se booyga. ");
INSERT INTO kyq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Naaɗe aan Jeruzalɛm ki ɔɔ gɔtn se, Isa ɓaa ɛnd daan bɔɔr Ɓee Raa ki ɔɔ naan̰ baag tuur jeegen ɓaano te nakɗege gɛn zoa ɔɔ jeegen ɓaaɗo dugu gɔtn ese se. Naan̰ tɔt tɔl tuun te tabil jee pɛlɛkŋ gursge naatn ɔɔ tɔt tɔl te nakgen jee tɛɗn zo dɛɛrge lee tiŋg do ki se kici. ");
INSERT INTO kyq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Naan̰ gaasɗe ɔɔ nam ɔn̰te deel ɓaano ute ne ɗim daan bɔɔr Ɓee Raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gɔtn se naan̰ dooyɗe, taaɗɗen ɔɔ: «Raa taaɗ maakŋ Kitap ki ɔɔ: Ɓee maam se tɛɗn ɓee kɛn mɛtjil jeegen ɓaa se paac ansum keeme. Num gaŋ naase Ꞌtɛɗin̰ki tɛɗga gɔtn jee ɓoogge!» ");
INSERT INTO kyq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","*Magal jee tɛɗn sɛrkɛ Raage tu ɔɔ ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage jaay booy nakŋ kɛn Isa tɛɗ se, naaɗe je ɗoobm an̰ tɔɔlɔ. Naɓo naaɗe ɓeerin̰ ɓeere, taa jee dɛngen tus se jaay booy taar Isa dooyɗen se, ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɛn aan tɛgɛr gɔtɔ ɔk jin̰ se, Isa te jee mɛtin̰ ki teec naatn maakŋ gɛgɛr kɛn Jeruzalɛm ki se. ");
INSERT INTO kyq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mɛtbeen̰ki tanɔɔrin̰‑nɔɔrin̰a, kɛn naaɗe tɛrlo tɛrl Jeruzalɛm ki se, naaɗe aak ko ba kɛn Isa naamin̰ se, tuutga n̰ɛs. ");
INSERT INTO kyq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Gɔtn se Piɛr saap do taar kɛn Isa taaɗo se, ɗeekin̰ ɔɔ: «Debm dooyje, aaka! Ko ba naai Ꞌnaamin̰ se, tuutga n̰ɛs.» ");
INSERT INTO kyq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isa tɛrl taaɗ jeege tun mɛtin̰ ki ɔɔ: «Naase se aalki maakse do Raa ki! ");
INSERT INTO kyq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ꞋBooyki bɛɛ, mꞋasen taaɗa. Kɛn deba jaay ɗeek ko ki ɔɔ: ‹Iin̰i ooc maakŋ baar ki› ɔɔ debm se jaay ɔk naaja maakin̰ ki eyo ɔɔ aal maakin̰ do taar kɛn naan̰ taaɗ se, nakŋ se Raa ansin̰ kɔŋ tɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Taa naan̰ se ɓo, maam ɗeeksen mꞋɔɔ: nakŋ paacn̰ naase Ꞌje aki tɔnd mɛta gɔtn Raa ki se, aalki maakse aan gɔɔ ɔŋin̰kiga ɔɔ Raa asesin̰ kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kɛn naase iin̰ ɗaarkiga raan Ꞌɓaaki Ꞌɓaa tɔnd mɛtn Raa jaay, ɔkki taar te nam num, Ꞌɓaa ɔkin̰ki naagin̰ jaayo. Bin jaay Bubsen maakŋ raa kic ɓo asen tɔɔl *kusin̰sege.» ");
INSERT INTO kyq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Isa ute jee mɛtin̰ ki tɛrl ɓaaɗo Jeruzalɛm ki daala. Kaaɗ kɛn naan̰ lee ɓaa kaam ara kaam ara daan bɔɔr *Ɓee Raa ki se ɓo, *magal jee tɛɗn sɛrkɛ Raa ki, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal taa ɓee Yaudge se ɓaaɗo ɔŋin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Naaɗe tɔnd mɛtin̰ ɔɔ: «Naai tap ɓo kɛn undi kulu gɛn tɛɗn nakgen se tap ɓo naŋa? Ey lɛ kɛn ɛɗi tɔɔgɔ gɛn tɛɗn nakgen se, tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isa tɛrlɗen ɔɔ: «Maam mꞋje tɔnd mɛtse naka kalaŋ sum. Kɛn naase jaay Ꞌtɛrlumkiga num, maam kic mꞋasen taaɗn debm kɛn undum kulu gɛn tɛɗn nakgen se. ");
INSERT INTO kyq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ꞋTaaɗumki tu, naŋa jaay ɔlo Jan‑Batist *batiz jeege se: Raa lɔɓu jikilimge lɛ?» ");
INSERT INTO kyq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɔɔ gɔtn se naaɗe baag saapa ɔɔ taaɗ te naapa ɔɔ: «Naan̰ se jꞋan̰ki tɛrl ɔɔ ɗio? Kɛn kꞋtaaɗkiga jꞋɔɔki: ‹Raa ɓo ɔlin̰o› lɛ, naan̰ ajeki ɗeekŋ ɔɔ: ‹Gɛn ɗi jaay baate tookŋ kuunki taar Jan se?› ");
INSERT INTO kyq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anum kɛn kꞋtaaɗkiga jꞋɔɔki: ‹Jikilimge ɓo ɔlin̰o› lɛ? A‑a.» Taa naaɗe se ɓeer ɓeer jeege tu, taa jeege paac se jeel maakɗe ki Jan se debm taaɗ taar teeco taar Raa kɛn mala mala. ");
INSERT INTO kyq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gɔtn se naaɗe tɛrl Isa ki ɔɔ: «Naaje se kꞋjeel eyo.» Tɛr Isa tɛrlɗen ɔɔ: «Maam kic num, mꞋasen kɔŋ taaɗn debm kɛn undum kulu gɛn tɛɗn nakgen se eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gɔtn se Isa baag taaɗn jeege tu ute kaal naagŋ taara ɔɔ: «Gaaba kalaŋ tɛɗ jinɛn bin̰, iin̰ gurugin̰ te durdur, uɗ gɔɔ do ko ki gɛn rii koojn̰ bin̰in̰a ɔɔ iin̰ gɔtɔ jɛrlɛ gɛn kiŋg bɔɔbm jinɛnin̰a. Gɔtn se maakŋ jinɛnin̰ se naan̰ ɔn̰in̰ kaam ji jee tɛɗn naabge tu ɔɔ jee tɛɗn naabge se tɛɗga num utu kɔŋ bɛɗɗe ɔɔ gɔtn se naan̰ iin̰ ɓaa mɛrtɛ. ");
INSERT INTO kyq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kɛn kaaɗn kugŋ koojn̰ bin̰ jaay aan se, naan̰ ɔl debm tɛɗn naabin̰ se gɔtn jeege tun naan̰ ɔn̰ɗe jinɛnin̰ kaam jiɗe se, taa an̰o kɔkŋ bɛɗin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Num kɛn debm tɛɗn naabin̰ jaay aan jinɛnɛ ki se, jee se ɔk tɔnd dɛrɛŋin̰a ɔɔ tuurin̰ ɔn̰in̰ ɓaa jin̰ sik. ");
INSERT INTO kyq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kɛn mɛl jinɛnɛ jaay aakin̰ naan̰ ɓaaɗo jin̰ sik se, naan̰ ɔl debm tɛɗn naabm kuuy daala. Naan̰ kic kɛn ɓaa aan se, naaɗe ɔk tɔndin̰ don̰ ki ɔɔ naajin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naan̰ kɛn se, tɛr debm jinɛnɛ ɔl debm tɛɗn naabm kuuy daala. Naan̰ se naaɗe ɔk tɔɔlin̰a. Tɛr debm jinɛnɛ se ɔlo jee tɛɗn naabgen kuuy dɛn daala. Naaɗe se kic ɓo jee mɛtin̰ge naaɗe tɔnd dɛrɛŋɗe ɔɔ kɛngen mɛtin̰ge naaɗe tɔɔlɗe. ");
INSERT INTO kyq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Debm kɛn ɔɔpin̰ se, kɛse goon maak‑jen̰a. Naan̰ saap ɔɔ: ‹Goonum mala se naaɗe utu tookŋ kuun taarin̰a.› Taa naan̰ se ɓo, naan̰ ɔlin̰o kaam mɔɔtn. ");
INSERT INTO kyq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gaŋ jee tɛɗn naabgen ese jaay aakin̰ se, baag taaɗn te naapa ɔɔ: ‹Naan̰ se ɓo kɛn bubin̰ ooyga num utu Ꞌtɛɗn mɛl jinɛnɛ se; kɛn bin num Ꞌɓaakiro, kꞋtɔɔlin̰ki ɔɔ jinɛnɛ se ajeki kɔɔpm naajege tu.› ");
INSERT INTO kyq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gɔtn se naaɗe ɔkin̰a, tɔɔlin̰a ɔɔ maakŋ jinɛn ki se, naaɗe uun undin̰ naatn.» ");
INSERT INTO kyq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Num Isa tɔnd mɛtɗe ɔɔ: «Kɛn mɛl jinɛnɛ jaay ɓaaɗoga num, jee se naan̰ aɗen tɛɗn ɔɔ ɗi? Kɛn naan̰ ɓaaɗoga num, jee se naan̰ aɗen tɔɔl naatn ɔɔ jinɛnin̰ se lɛ, naan̰ an̰ kɛɗn kaam ji jeege tun kuuy. ");
INSERT INTO kyq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Naase Ꞌdooyin̰kiga te ey la taar kɛn *Raa taaɗn maakŋ Kitap ki se ɔɔ: Ko kɛn jee kiin̰ ɓeege baatin̰ se, naan̰ se ɓo tɛɗga ko kɛn Ꞌgakŋ ɓea; ");
INSERT INTO kyq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","kɛse ɓo naabm Mɛljege Raa ɔɔ naajege tu se jꞋaakin̰ki se ɔkjeki taaɗ eyo!» ");
INSERT INTO kyq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Num magal Yaudge se jeelga kaal naagŋ taar kɛn Isa taaɗ se, taaɗ te naaɗe. Gɔtn se naaɗe je ɗoobm kɛn an̰ kɔkɔ, naɓo naaɗe ɓeer jee dɛnge tu. Gɔtn se naaɗe iin̰ ɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Magal Yaudge ɔl *Parizigen mɛtin̰ge te jee *Ɛrɔdgen mɛtin̰ge, taa ɓaa goom kɔkŋ Isa do taarin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Naaɗe ɓaaɗo taaɗin̰ ɔɔ: «Debm dooy jeege, naaje kꞋjeele naai se Ꞌtaaɗ taar mɛt ki ɔɔ taar jeegen kuuy se naai Ꞌtɛɗn naaba ro ki eyo ɔɔ jeegen jeege jeelɗe jee magalge se, taar naaɗege se naai ɔli ɗim maak ki eyo. Num naai dooy jeege te ɗoobm taar Raa mɛt ki. Ɓɔrse Ꞌtaaɗjen tu: jꞋɔk ɗoobo gɛn kɔgŋ miir Sezar ki lɔɓu gɔtɔ? JꞋan̰ kɔg lɔɓu jꞋan̰ kɔg ey lɛ?» ");
INSERT INTO kyq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Num gaŋ Isa jeele taar naaɗe taaɗ se, taar maakɗe eyo. Naan̰ ɗeekɗen ɔɔ: «Gɛn ɗi jaay naase oomumki bin se? Uun Ꞌɓaankiro te tamma kalaŋ, mꞋan̰ kaak tu.» ");
INSERT INTO kyq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naaɗe uun ɓaano te tamma kalaŋ ɔɔ Isa tɔnd mɛtɗe ɔɔ: «Kaam‑nirl doa te ro kɛn kꞋraaŋin̰ ro ki se tap ɓo gɛn naŋa?» Naaɗe tɛrlin̰ ɔɔ: «Gɛn Gaar Sezar.» ");
INSERT INTO kyq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Gɔtn se Isa tɛrlɗen ɔɔ: «Kɛn bin num, nakŋ gɛn Gaar Sezar se ɛɗin̰ki nakin̰a ɔɔ nakŋ gɛn Raa lɛ, ɛɗin̰ki nakin̰ kici.» Num kɛn naaɗe jaay booy taar Isa taaɗ se, ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jeegen kꞋdaŋɗe *Sadusege kɛn taaɗ ɔɔ jeege ooyga num dur ey sum se, ɓaaɗo gɔtn Isa ki ɔɔ tɔnd mɛtin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Debm dooy jeege, *Musa raaŋjeno maakŋ Kitap ki ɔɔ: kɛn deba ɔk mɛnda jaay ooy ɔn̰ te goon ey se, bɛɛki num, gɛnaan̰ se Ꞌkɔkŋ mɛndin̰a taa koojn̰ mɛtjili gɛnaan̰ kɛn ooy se. ");
INSERT INTO kyq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Num Ꞌbooyo, gɛnaage cili, kon̰ɗe kalaŋ. Debm deet deet se ɔk mɛnda naɓo ooy ooj te goon eyo. ");
INSERT INTO kyq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Debm mɛtin̰ ki ɓaaɗo ɔk mɛndin̰a ɔɔ naan̰ kic ooy ooj te goon eyo. Debm k‑mɔtɔge tu se kic ɓo ɓaaɗo ɔk mɛnd se, naan̰ kic ɓo ooy ooj te goon eyo kici. ");
INSERT INTO kyq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɔɔ naaɗen cili se paac tɔkŋ naamga mɛnd se, naɓo naaɗe paac ooyo ɔɔ goono kalaŋ kic ɓo nam ooj te eyo. Ɔɔ kaam mɔɔtn se, mɛnda se kic ɓaaɗo ooyo. ");
INSERT INTO kyq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bin num, ɓii kɛn jaay jeegen ooyga kooy aɗe dur daan yoge tu se, mɛnd se tap ɓo Ꞌtɛɗn mɛnd naŋa? Taa naaɗen cili se lɛ, tɔk naamin̰ga paac.» ");
INSERT INTO kyq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isa tɛrlɗen ɔɔ: «Naase se, ɓɛrɛ, iigkiga, taa taar Raa se lɛ Ꞌjeelki eyo ɔɔ tɔɔgŋ Raa kic lɛ, naase ɔndki te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ꞋBooyki, ɓii kɛn jaay jeegen ooyga kooy aɗe dur daan yoge tu se, gaabge te mɛndge se tɔkŋ naap ey sum. Num naaɗe se tecn̰ aan gɔɔ *kɔɗn Raagen maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gɛn mɛtn taar jeegen ooyga kooy jaay utu dur daan yoge tu se, taar maakŋ Kitapm Musa ki se, naase Ꞌdooyin̰ki te ey la kɛn ɔɔ: Musa aako pooɗo ɔk kɔk maakŋ ji kaag ki ɔɔ maakŋ pooɗ kɛn se Raa taaɗin̰ ɔɔ: Maam se mꞋRaa gɛn *Abraam mꞋgɛn Isaka ɔɔ mꞋgɛn *Yakub? ");
INSERT INTO kyq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Raa se, naan̰ Raa jeegen ooyga kooy eyo, num naan̰ se, Raa jee zɛɛrɛ. Naase se, ɓɛrɛ, ɗeer ɗeer iigkiga.» ");
INSERT INTO kyq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kaaɗ kɛn Isa naaj naaj ute *Sadusege se, debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa kalaŋ bini utu te naaɗe. Kɛn naan̰ jaay booy Isa taaɗ tɔɔk mɛtn taara nijim bin se, naan̰ iiko cɛɛn̰ ki ɔɔ tɔnd mɛtin̰ ɔɔ: «Maakŋ taarge tun kɛn Raa taaɗ ɔɔ kꞋtɛɗ paac se, kɛn gay ɓo cirɗe?» ");
INSERT INTO kyq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isa tɛrlin̰ ɔɔ: «Taar cirɗe paac se kɛn ɔɔ: ꞋBooyki gaan *Israɛlge, Mɛljege Raa se, naan̰ kalin̰ ki sum ɓo Raa. ");
INSERT INTO kyq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Naai Ꞌje Mɛli Raa se ute maaki paac, ute roi paac, ute saapi paac ɔɔ ute tɔɔgi paac.» ");
INSERT INTO kyq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tɛr kɛn mɛtin̰ ki ɔɔ: «ꞋJe naapi aan gɔɔ Ꞌje ro naai mala. Maakŋ taarge tun kɛn Raa taaɗ ɔɔ gɛn tɛɗa se, kɛn cir taargen ese se gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa ɗeek Isa ki ɔɔ: «Debm dooy jeege, kɛse jiga. Taar naai Ꞌtaaɗ se taar mɛt ki. Raa se naan̰ kalin̰ ki sum ɔɔ Raa kuuy se, gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Debkilimi je Raa se, an̰ je te maakin̰ paac, ute saapin̰ paac, ute tɔɔgin̰ paac ɔɔ je naapin̰ aan gɔɔ ro naan̰ mala. Taargen se cir *sɛrkŋ kɛn naan̰ ɛɗ Raa ki ɔɔ cir sɛrkŋ kɛn naan̰ tɔjɔ ɔɔ tɔɔcin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isa jaay booy taar gaabm tɛrlin̰ nijim bin se, naan̰ ɗeekin̰ ɔɔ: «Naai se Ꞌdɔk te *maakŋ Gaar Raa eyo.» Gɔtn se naaɗe mɔɔtn nam tɔnd te mɛtin̰ gɛn taar ɗim kuuy ey sum. ");
INSERT INTO kyq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gaŋ kɛn Isa dooy dooy jeege daan bɔɔr *Ɓee Raa ki se, naan̰ tɔnd mɛtɗe ɔɔ: «Gɛn ɗi jaay jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage taaɗ ɔɔ al‑Masi naan̰ goon Daud se? ");
INSERT INTO kyq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daud mala kic ɓo *Nirl Salal ɔlin̰ ɗeek ɔɔ: Mɛljege Raa taaɗo Mɛlum ki ɔɔ: ꞋƁaaɗo iŋg do ji daamum ki, bini jee taamooyige se mꞋaɗen tɛɗn naai utu Ꞌkiŋg doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud mala kic ɓo daŋin̰ ɔɔ: Mɛluma, anum Ꞌtɛɗn goonin̰ se, Ꞌtɛɗn ɔɔ ɗi daala?» Kɛn jee dɛn jaay booy taar se ɛɗɗen maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tɛr Isa ɗeek jeege tun naan̰ dooyɗe dooy se ɔɔ: «Ɔndki kɔndɔ te jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, taa naaɗe se je lee te kal magalɗege gɛn magal roɗe ɔɔ kɛn ɓaaga bɔɔr ki se, naaɗe je jeege aɗen tɛɗn tɔɔsɛ naaɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɔɔ kɛn naaɗe jaay aanga maakŋ *ɓee Yaudge lee tusn maak ki se, naaɗe je kiŋg gɔtn naan ki. Ɔɔ kɛn aanga gɔtn kɔs ki kic lɛ, naaɗe je gɔtn naan ki. ");
INSERT INTO kyq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naaɗe se ɓo kɛn baagga keem Raa num, eem lɛk tɛc tɛɗ aan gɔɔ naaɗe ɓo jee bɛɛ taa jeege aɗen kaaka ɔɔ naaɗe ɓo jee kɛn ɔs naŋ ji mɛnd‑daayge. Num gaŋ naaɗe se, bɔɔr utu koocn̰ doɗe ki se ɔɔn̰ aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Gɔtn se, daan bɔɔr *Ɓee Raa ki, Isa utu iŋg cɛɛ tukul kaag kɛn jeege lee tɔmb sɛrkɛ maak ki ɔɔ naan̰ aak jee dɛngen ɓaaɗo ɔmb sɛrkɛ Raa ki maakŋ tukul kaag ki se. Gɔtn se jee maalge ro naap ki ɓaaɗo ɔmb gurs dɛna. ");
INSERT INTO kyq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gɔtn se, mɛnd‑daay kalaŋ ɓaaɗo ɔmb tammage sɛɛm sɛɛm dio ɔɔ tammagen se kɔbɔrɔ kic ɓo aas eyo. ");
INSERT INTO kyq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gɔtn se Isa daŋ jee mɛtin̰ ki ɔɔ ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ, mꞋasen taaɗa. Mɛnd‑daay kɛn daay naŋ takŋ ese se, nakŋ naan̰ ɔmb maakŋ tukul kaag ki se dɛn cir gɛn jee ɓaa se paac. ");
INSERT INTO kyq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Taa jeegen se ɛɗ do nak dɛnɗege tu, gaŋ mɛnd‑daay se ute daayin̰ se kic ɓo, nakŋ naan̰ ɔkŋ kɛn an tiŋg se ɓo, naan̰ ɓaaɗo ɔmbin̰ paac.» ");
INSERT INTO kyq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kaaɗ kɛn Isa teeco teec maakŋ Ɓee Raa ki se, maakŋ jeen̰ge tun mɛtin̰ ki se, deb kalaŋ ɗeekin̰ ɔɔ: «Debm dooyje, aak tu kogen aak bɛɛ kɛn jꞋiin̰ ɓee se! Aak tu ɓee se jꞋiin̰in̰ga aak bɛɛ aak eyo!» ");
INSERT INTO kyq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isa tɛrlin̰ ɔɔ: «Aaka, ɓee magal ɗaar aak bɛɛ bɛɛ ese se, jeege utu an̰ ru naŋ tak. Kon̰gen rɛɛs aak bɛɛ bɛɛ se, utu wɔɔkŋ kalaŋ kalaŋ ɔɔ ko tap ɓo Ꞌkɔŋ tooɗn do naapin̰ ko ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Naan̰ kɛn se, Isa ook iŋg do *kɔsn ɔlib ki ɔɔ ɔl kaamin̰ aak kaam sak *Ɓee Raa. Gɔtn se jee mɛtin̰ ki se, Piɛr, Jak, Jan ɔɔ Andre naaɗe se sum ɓo ute te naan̰a ɔɔ naaɗe tɔnd mɛtin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ꞋTaaɗjen tu, nakgen se Ꞌkaan nuŋ ki? Ɔɔ naan̰ se Ꞌtɛɗn ɔɔ ɗi jaay ɓo naaje jꞋan kaakŋ jeel ro ki kɛn nakgen se jaay kaaɗin̰ Ꞌkaan se?» ");
INSERT INTO kyq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Gɔtn se Isa baagɗen taaɗa ɔɔ: «Ɔndki kɔndɔ, ɔn̰te Ꞌkɔn̰ki nam ɔn̰ten Ꞌdɛrlse. ");
INSERT INTO kyq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jeege dɛna utu aɗe ɓaa ute roma ɔɔ asen taaɗn ɔɔ: ‹Maam ɓo *al‑Masi!› Ɔɔ kɛn naaɗe Ꞌtɛɗ bin se utu Ꞌdɛrl jeege dɛna. ");
INSERT INTO kyq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kɛn Ꞌbooykiga jeege jaay baaga kɔɔsn maan bɔɔrge, kɛn gɔɔr utu naase lɔɓu Ꞌdɔkɔ, anum ɓɛrɛ, ɔn̰ten Ꞌɓeerki. Taa nakgen se utu Ꞌkaana, naɓo duni se Ꞌkɔŋ naŋ ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jee taa naaŋ kaam kalaŋ utu kiin̰ bɔɔrɔ ute jee taa naaŋ kuuy. Taa naaŋ gaar kaam kalaŋ utu kiin̰ bɔɔrɔ te taa naaŋ gaar kɛn kuuy. Maakŋ naaŋge tun mɛtin̰ naaŋa utu Ꞌtea ɔɔ gɔtn mɛtin̰ ɓo utu tɔɔl jeege. Aan gɔɔ mɛnd kɛn maakin̰ tuunin̰ gɛn koojo se, nakgen se kic ɓo baaga kaana num, kɛse je taaɗn ɔɔ dunia ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Num naase jee mɛtum ki se iŋgki do mɛtɛk se ki. Taa jeege se utu asen kɔnd bɔɔrɔ ɔɔ asen ɓaa tɔnd dɛrɛŋ maakŋ *ɓeege tun Yaudge lee tusn maak ki. Taa maam se naaɗe asen tɔkŋ ɓaa naan magalge tu ɔɔ naan gaarin̰ge tu. Taa bin se, naase aki tɛɗn saaɗumge naan naaɗe ki. ");
INSERT INTO kyq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Anum bɛɛki se Labar Jigan gɛn Isa al‑Masi se, jꞋutu jꞋan̰ taaɗn mɛtjil jeege tun do naaŋ ki se paac jaayo. ");
INSERT INTO kyq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kɛn jꞋɔk kꞋɓaanse ɓaa gɔtn kɔjn̰ bɔɔr ki se, nirlse ɔn̰te kaay se do taar kɛn naase aki ɓaa taaɗa, taa taar kɛn naase aki ɓaa taaɗ kaaɗ kɛn se naase mala eyo, num *Nirl Salal ɓo asen kɔl naase aki Ꞌtaaɗa. ");
INSERT INTO kyq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naan̰ kɛn se gɛnaa utu kɔl gɛnaan̰ jꞋan̰ ɓaa tɔɔlɔ ɔɔ bubu kici utu kɔl goonin̰a jꞋan̰ ɓaa tɔɔlɔ. Gaange utu tɛrl naaga bubɗege tu ɔɔ je yoɗe. ");
INSERT INTO kyq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Taa maam se jeege paac utu asen kɔɔɗn kundu; naɓo debm jaay aayga kaamin̰ bini aanga do taar tɔɔlin̰ ki num, naan̰ se utu Ꞌkɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Kaaɗin̰ utu kaan se naase utu aki kaakŋ Debm tuj deelga te gɔtin̰ se utu Ꞌkɛnd kiŋg maakŋ *Ɓee Raa ki, gɔt kɛn *salal se, kɛn bɛɛki num, naan̰ kɛnd eyo. Bin num debm jaay dooy taar ese se booy n̰Ꞌɔkin̰ jiga jaayo! Kɛn jaay aakkiga nakgen se num, ɔn̰ jee kɛn iŋg taa naaŋ Jude ki se, kꞋjꞋaan̰ jꞋook maakŋ koge tu. ");
INSERT INTO kyq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Debm iŋg kiŋg do ɓeen̰ ki raan se, kɛn naan̰ bɔɔy jaay aan̰ kaan̰ se, n̰Ꞌɔn̰te bɔɔyo gɛn tɔsn nakin̰gen maakŋ ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Debm jaay maakŋ gɔtin̰ ki kic lɛ n̰Ꞌɔn̰te tɛrlo ɓeene gɛn kuun kal magalin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ɓii kɛn se, mɛndgen mɛndkaamge ute ko gaangen gɛnɗege aay kaay si se, aɗen tɛɗn ɔɔn̰ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eemki *Raa taa nakgen se Ꞌkaan kaaɗn kuul ki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kaaɗ kɛn se jeege utu dabar dɛna ɔɔ dubar se gɔtn Raa aal dunia tap ɓo nam naam te eyo ɔɔ mɔɔtn dubar naan ki jaay Ꞌkɔɔn̰ cir naan̰ ese se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Num Mɛljege Raa, ɓii dubar se, naan̰ gaaŋin̰ga duuku taa jeegen naan̰ bɛɛr tɔɔɗɗe se, kɛn ɓiigen se jaay naan̰ gaaŋɗen te duuk ey num, nam kɔŋ kaaja tap ɓo gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kaaɗ kɛn se jaay nam taaɗsenga ɔɔ: ‹ꞋƁaaɗo aakki, *al‑Masi utu ara!› Ey lɛ taaɗsen ɔɔ: ‹Aakki! Naan̰ utu naane!› Naase, ɔn̰ten Ꞌtookki taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ꞋBooyki! Jeegen kɛn tɛɗ roɗe ɔɔ naaɗe ɓo al‑Masige ute jeegen tɛɗ roɗe ɔɔ naaɗe jee taaɗ taar teeco taar Raa ki se utu aɗe ɓaao. Naaɗe utu Ꞌtɛɗn nakŋ‑kɔɔɓge ute nakgen deel doa, taa Ꞌkaan̰ jeege dala. Ɔɔ jee kɛn Raa bɛɛr tɔɔɗɗenga tɔɔɗ se kɛn naaɗe ɔŋga ɗoobo num, aɗen kaan̰ dal kici. ");
INSERT INTO kyq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Num, naase se ɔndki kɔndɔ! Ɓɛrɛ, taar se lɛ, maam mꞋaalsenga kaal paac bise ki.» ");
INSERT INTO kyq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tɛr Isa taaɗɗen daala ɔɔ: «Kɛn ɓiigen gɛn dubarge se jaay deelga num, kaaɗa se utu Ꞌtɛɗn ilim dib ɔɔ laapa se lɛ wɔɔr eyo. ");
INSERT INTO kyq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","K‑dijgen maakŋ raa ki aɗe si naaŋ ki ɔɔ nakgen ɔk tɔɔgɔ maakŋ raa ki paac se, utu Ꞌtea. ");
INSERT INTO kyq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Gɔtn se jꞋkaakŋ *Goon Deba aɗe bɔɔy maakŋ gapara ki ute tɔɔgŋ Raa kɛn wɔɔr gɔtɔ kɛlɛŋ. ");
INSERT INTO kyq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɔɔ Goon Deba se aɗe kɔl *kɔɗn Raage ɔɔ naaɗe utu Ꞌtusn jee kɛn naan̰ bɛɛr tɔɔɗɗe, mɛtn naaŋ kɛn kaam sɔɔ, gɔtn do naaŋa iin̰ ro ki bini ɗaar ro ki ɔɔ bini gɔtn mɛtn raa ɗaar ro ki.» ");
INSERT INTO kyq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Naase ɔndki doa te ko ba: kɛn naan̰ jaay baaga kɔɔɗn taa‑oomo ɔɔ dɔɔb kamba se, naase Ꞌjeelki ɔkki mɛt‑kijiri aanga ɔɔ ɓara ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bin num naase kic ɓo, kɛn aakkiga nakgen se jaay aanga num, Ꞌjeelki *Goon Deba se, naan̰ aan ɔŋsega gɔɔr kaam‑taarse ki. ");
INSERT INTO kyq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ꞋBooyki bɛɛ, mꞋasen taaɗa: jee duni ki ɓɔrse se Ꞌkooy naŋ ey sum ɓo, nakgen se utu Ꞌkaana. ");
INSERT INTO kyq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maakŋ raa ute do naaŋa se utu Ꞌdeele, num taar maam se Ꞌkɔŋ deel eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Num gaŋ kɛn gɛn kaaɗin̰ ute ɓiin̰ Goon Deba ano ɓaa se, nam tap ɓo jeel eyo. Kɔɗgen maakŋ raa ki kic lɛ jeel eyo, ɔɔ Goono kic ɓo, jeel eyo. Nam jeel ɓiin̰ se, gɔtɔ. Kɛn jeel se, Bubu kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɔndki kɔndɔ, ɔn̰te Ꞌtooɗki bia, taa kaaɗn Goon Deba aɗe ɓaa se, naase Ꞌjeelki eyo. ");
INSERT INTO kyq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kɛse tec aan gɔɔ debm ɓaa ɓaa mɛrtɛ. Naan̰ ɔn̰ ɓeen̰ kaam ji jee tɛɗn naabin̰ge. Naŋa kic naan̰ taaɗin̰ naabin̰ naabin̰a ɔɔ debm bɔɔbm taa ɗoobo se naan̰ taaɗin̰ ɔɔ n̰Ꞌɔn̰te tooɗn bia. ");
INSERT INTO kyq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iŋgki zɛɛrɛ daayum, taa naase kic ɓo Ꞌjeelki eyo kaaɗn kɛn mɛl ɓee aɗe ɓaa se, kɛn naan̰ ɓo Ꞌkaan tɛgɛr, daan ɓea, do‑mɛtbɛɛki, lɔ tanɔɔrin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɔndki kɔnd ey num sɔm naan̰ asen kaan kɔŋ pirsil kaaɗ kɛn naase utu tooɗki tooɗ bia. ");
INSERT INTO kyq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taar kɛn maam mꞋtaaɗsen se, mꞋtaaɗin̰ jeege tu paac: daayum iŋgki zɛɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ɔɔpga ɓii di sum ɓo, Yaudge Ꞌtɛɗn *laa Paak ute laa mappan ɔk ɔrɔm eyo. Gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage je ɗoobm an goon̰ kɔkŋ Isa taa an̰ ɓaa tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naaɗe taaɗ ɔɔ: «JꞋɔn̰te Ꞌkɔkin̰ki ɓii laa ki, ey num jeege kiin̰ gɛn tɛɗn taara ɔɔ gɔtɔ tuju.» ");
INSERT INTO kyq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isa ɓaa maakŋ naaŋ kɛn Betani ki ɔɔ kaaɗ kɛn naan̰ iŋg ɔs kɔsɔ maakŋ ɓee Simon kɛn kꞋdaŋin̰ debm bikiɗi se, mɛnda kalaŋ ɓaaɗo uuno naka aan gɔɔ k‑ɓɔkɔlɔ kalaŋ ɔɔ nakŋ se ko ɓo kꞋcɔɔc kꞋɗaapin̰a. K‑ɓɔkɔl se kꞋdaŋin̰ albatir. Ɔɔ itir maak ki se itir salal ɔɔ ɔɔn̰ɔ ɔɔ kꞋdaŋin̰ nard. Mɛnd se ɓaaɗo tɔɔk k‑ɓɔkɔlɔ se ɔɔ ɔɔy itir maak ki se do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jee mɛtin̰gen iŋg gɔtn se aak se, maakɗe tuju ɔɔ baag taaɗn te naapa ɔɔ: «Gɛn ɗi jaay itir se naan̰ tujin̰ bin se? ");
INSERT INTO kyq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Itir se jaay kꞋɓaa kꞋdugin̰ga num, ano ɓaa te tamma cir kaar‑mɔtɔ ɔɔ gursn se jꞋan̰ nigin̰ jee daayge tu!» Taa naan̰ se ɓo naaɗe taaɗ taargen iŋg kusu ro mɛnd kɛn se. ");
INSERT INTO kyq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gaŋ Isa ɗeekɗen ɔɔ: «Mɛnda se ɔn̰in̰ki jɛlɛk, ɔn̰te Ꞌtɛrɛcin̰ki mindin̰a. Nakŋ naan̰ tɛɗum maam ki se, nakŋ jig aak eyo. ");
INSERT INTO kyq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jee daayge se daayum utu te naase ɔɔ kɛn naase Ꞌjeki num aɗeki kɔŋ tɛɗn bɛɛ. Num gaŋ maam se mꞋkɔŋ kiŋg te naase daayum eyo. ");
INSERT INTO kyq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ey num, mɛnd se naan̰ tɛɗga bɛɛ kɛn naan̰ kɔŋ tɛɗa. Ɔɔ itir naan̰ ɔtum se ɗaapumga roma kɛn tɛɗga num jꞋutu jꞋam kɔl maakŋ ɓaaɗ ki se. ");
INSERT INTO kyq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ꞋBooyki bɛɛ, mꞋasen taaɗa: do naaŋa ute magalin̰ se gɔtn gay gay kic ɓo, kɛn jeege utu Ꞌtaaɗn Labar Jiga se, nakŋ kɛn mɛnd se jaay tɛɗum se, jeege paac utu kɔɔsn maanin̰a ɔɔ saapm do nakŋ kɛn naan̰ tɛɗn ese se.» ");
INSERT INTO kyq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariɔt se, naan̰ maakŋ jee mɛtn Isa kɛn sik‑kaar‑dio. Naan̰ iin̰ ɓaa taaɗ *magal debm tɛɗn sɛrkɛ Raage tu taa naan̰ je aɗen taaɗn ɗoobm kɛn naaɗe an kɔkŋ Isa. ");
INSERT INTO kyq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kɛn naaɗe booy taar Judas se, maakɗe raapo ɔɔ naaɗe taaɗin̰ga taaɗ ɔɔ utu an̰ kɛɗn gurs. Naan̰ kɛn se, Judas baag je ɓo ɗoobm an kutn Isa sum. ");
INSERT INTO kyq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɓii deet deetn gɛn laa mappan ɔk ɔrɔm eyo jaay aan se, ɓii kɛn se ɓo kꞋtɔjn̰ gaan baatge gɛn laa Paak gɛn Yaudge. Jee mɛtn Isa ki tɔnd mɛtin̰ ɔɔ: «Kɔsn gɛn laa Paak se, naai Ꞌje jꞋaisin̰ tɛɗn kaam gay?» ");
INSERT INTO kyq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Gɔtn se Isa ɔl maakŋ jeege tun mɛtin̰ ki se jeege dio, ɗeekɗen ɔɔ: «ꞋƁaaki maakŋ gɛgɛr ki ɔɔ kɛn Ꞌɓaaki ɓaa se, naase aakki dɔɔɗn ute gaaba uuno kɔɔyɔ ɗooc te maane se. Ɔkki mɛtin̰a, ");
INSERT INTO kyq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ɔɔ gɔtn naan̰ an kɛnd maak ki se, Ꞌtaaɗki mɛl ɓee ki se ɔɔki debm dooy jeege ɔljeno, ɔɔ kꞋtɔnd mɛti ɔɔ ɓee gay jaay ɓo naan̰ an kɔsn kɔsn laa Paak te jee mɛtin̰ ki se? ");
INSERT INTO kyq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Gɔtn se naan̰ asen taaɗn ɓee magala kɛn do ɓee ki raan, ɔɔ maakŋ ɓee ki se, nakin̰ge paac aas kart. Gɔtn ese ɓo ajeki tɛɗn kɔsn gɛn laa Paak se.» ");
INSERT INTO kyq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kɛn jee mɛtin̰ ki jaay ɓaa aan maakŋ gɛgɛr kɛn ese se, naaɗe ɔŋ nakge se paac aan gɔɔ kɛn Isa taaɗɗeno. Gɔtn se ɓo naaɗe tɛɗ kɔsn gɛn laa Paak. ");
INSERT INTO kyq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kɛn aan tɛgɛr gɔtɔ ɓaa ɔk jin̰ se, Isa ɓaaɗo ute jee mɛtin̰ kɛn sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kɛn naaɗe jaay iŋg gɔtn kɔs ki baag kɔsɔ se, Isa ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ, mꞋasen taaɗa: maakse ki se, debm iŋg ɔs kɔs te maam se ɓo utu am kutu.» ");
INSERT INTO kyq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kɛn naaɗe jaay booy taar ese se, naaɗe maakɗe tuju. Gɔtn se naŋa naŋa kic ɓo baag tɔnd mɛtn Isa ɔɔ: «Lɔ, nakŋ se tɛɗn maam lɛ?» ");
INSERT INTO kyq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Isa tɛrlɗen ɔɔ: «Maakŋ naase kɛn sik‑kaar‑di se, debm ɔl kɔl jin̰ maakŋ baay ki ute maam se ɓo, naan̰a. ");
INSERT INTO kyq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɗeere, *Goon Deba se, utu Ꞌkooy aan gɔɔ kɛn *Raa taaɗno maakŋ Kitap ki, num gaŋ ɔɔn̰ deb kɛn an̰ kut se! Debm bin se kɛn jꞋoojin̰ te ey kic ɓo, bɛɛ kaca.» ");
INSERT INTO kyq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaaɗ kɛn naaɗe ɔs kɔs se, Isa uun mappa jin̰ ki, tɔɔm Raa ɔɔ dup ɛɗin̰ jeege tun mɛtin̰ ki ɗeekɗen ɔɔ: «Ɔk ɔski, kɛse roma.» ");
INSERT INTO kyq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tɛr naan̰ uun *kɔɔp ɗooc te tɔtn koojn̰ kaagŋ kꞋdaŋin̰ bin̰ se jin̰ ki, tɔɔm Raa, ɛɗɗesin̰a ɔɔ naaɗe paac naŋa kic ɓo ɔk aaye aaye. ");
INSERT INTO kyq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Isa ɗeekɗen ɔɔ: «Kɛse moosuma kɛn taaɗ ɔɔ *Raa dɔɔkga ute naase. Moosn se ɔɔy taa jee dɛna. ");
INSERT INTO kyq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ꞋBooyki bɛɛ, mꞋasen taaɗa: tɔtn koojn̰ bin̰ ese se, mɔɔtn maam mꞋkaay ey sum, bini mꞋɓaa kaay tɔtn koojn̰ bin̰ kiji se, *maakŋ Gaar Raa ki jaayo.» ");
INSERT INTO kyq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kɛn naaɗe aar kaa gɛn keem Raa aas se, naaɗe teec ɓaa ook do *kɔsn ɔlib ki. ");
INSERT INTO kyq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Gɔtn se Isa taaɗ jeege tun mɛtin̰ ki ɔɔ: «Naase Ꞌpaacki utu amki kaan̰ rɛsɛ, taa Raa taaɗga taaɗ maakŋ Kitap ki ɔɔ: Maam mꞋutu mꞋtɔɔl debm gaam baatge, ɔɔ baatin̰ge se lɛ utu Ꞌkaan̰ wɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Num kɛn maam jaay mꞋooy mꞋduroga num, maam mꞋkɔnd naana, mꞋasen ɓaa booy taa naaŋ Galile ki.» ");
INSERT INTO kyq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Gɔtn se Piɛr ɗeekin̰ ɔɔ: «Kɛn jee mɛti ki jaay aan̰ rɛsi paac kic ɓo, maam se mꞋai kɔŋ rɛs eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Gaŋ Isa tɛrlin̰ ɔɔ: «ꞋBooy bɛɛ, mꞋai taaɗa: maakŋ nɔɔr kɛn jaaki se, kɔr kɔrɔn̰jɔ Ꞌkɔɔy ɗɔɔl di ey sum ɓo, naai Ꞌnaajn̰ ɗɔɔl mɔtɔ Ꞌɗeekŋ ɔɔ naai Ꞌjeelum eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Gaŋ Piɛr ɗeekin̰ ɔɔ: «Gɔtɔ! Maam se kɛn am kaan te yoa kic ɓo, mꞋai baati eyo!» Ɔɔ jee mɛtin̰ kɛn kuuy se kic ɓo paac taaɗ aan gɔɔ gɛn Piɛr se. ");
INSERT INTO kyq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naan̰ kɛn se, naaɗe aan gɔt kɛn kꞋdaŋin̰ Getsemane. Kɛn naaɗe aan se, Isa taaɗn jee mɛtin̰ ki ɔɔ: «Iŋgki gɔtn ara, kɔr maam mꞋaɗe ɓaa tɔnd mɛtn Raa se.» ");
INSERT INTO kyq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Naan̰ ɔk ɓaan te Piɛr, Jak ɔɔ Jan. Gɔtn se nirlin̰ baag teece ɔɔ taar maakin̰ ki naŋ tak. ");
INSERT INTO kyq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Isa ɗeekɗen ɔɔ: «Maam se maakum tujga ɔɔ nirlum teecga aan gɔɔ mꞋaki kooyo. Anum naase se iŋgki gɔtn ara ɔɔ ɔn̰ten Ꞌtooɗki bia.» ");
INSERT INTO kyq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naan̰ iin̰ iik naan ki cɔkɔ, ooc naaŋ ki ɔɔ baag tɔnd mɛtn Raa ɗeek ɔɔ: «Kɛn naai Ꞌje num, kaaɗn dubar kɛn utu kaan dom ki se, iikin̰ naatn dɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Naan̰ tɛrl taaɗ daala ɔɔ: «Abba, Bua, nakŋ ɔɔn̰ ciri naai ki se, gɔtɔ. Iikum *kɔɔpm dubar se rom ki naata. Num gaŋ Ꞌtɛɗ aan gɔɔ kɛn naai maaki jen ro ki, aan gɔɔ kɛn maam ɓo mꞋje se eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kɛn naan̰ tɛrl ɓaaɗo ɔŋ jee mɛtin̰ ki se, kaamɗe ɔkga bia. Naan̰ ɗeek Simon Piɛr ki ɔɔ: «Simon, naai Ꞌtooɗ tooɗ bi la? Lɛr kalaŋ kic ɓo naai ɔŋ aasin̰ te gɛn kiŋg zɛɛr ey ne? ");
INSERT INTO kyq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Naase iŋgki zɛɛrɛ, Ꞌtɔndki mɛtn Raa, taa naase aki koocn̰ maakŋ nakŋ naam ki eyo. Maakŋ debkilimi se je tɛɗn nakŋ bɛɛ, naɓo daa ron̰ ɓo ɔŋ aasin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tɛr Isa iik naan ki cɔkɔ daala, ɓaa tɔnd mɛtn Raa, naan̰ iŋg ɗɔɔl taar ese sum. ");
INSERT INTO kyq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kɛn naan̰ ɔk tɛrlo daal se, ɓaaɗo ɔŋ jee mɛtin̰ ki tooɗ tooɗ bia ɔɔ kɛn bi ɔkɗe se, kaamɗe kic ɔŋ aak eyo. Gɔtn se taar naaɗe an̰ taaɗ kic ɓo jeel eyo. Isa ɔk tɛrl ɓaa tɔnd mɛtn Raa daala. ");
INSERT INTO kyq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kɛn naan̰ tɛrl ɓaaɗo ɔŋɗe gɛn k‑mɔtɔge se, ɗeekɗen ɔɔ: «Maakŋ tooɗn bise ki se naase utu Ꞌtooɗ Ꞌtɔɔlki tɔɔl kɔɔrse rɔk la? Bɛɛga, kaaɗin̰ aanga. ꞋBooyki, *Goon Deba se, jꞋutu jꞋan̰ kɔkŋ kɔl ji jee tɛɗn *kusin̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iin̰ki, kꞋɓaaki! Aakki, debm am kut se aanga!» ");
INSERT INTO kyq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kɛn Isa utu taaɗ naŋ te taarin̰ ey sum ɓo, gɔtn se Judas aana; naan̰ se maakŋ jeege tun mɛtn Isa kɛn sik‑kaar‑dio. Naan̰ ɓaaɗo ute dɔɔl jeege dɛna mɛtin̰ ki kɛn ɔk gɔrɗ‑jɛrlɗege ɔɔ te sirɗɗege. Jee se, *magal jee tɛɗn sɛrkɛ Raage tu, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal taa ɓee Yaudge ɓo ɔlɗeno. ");
INSERT INTO kyq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, naan̰ ɓo debm utu kutn Isa se, taaɗga taaɗ jeege tun ese se ɔɔ: «Debm jaay maam mꞋan̰ baam kɔkɔ ɔɔ mꞋkaay ciilin̰ se ɓo, kɛse ɓo naan̰a! Ɔk Ꞌɓaansin̰ki ɔɔ Ꞌbɔɔbin̰ki jiga.» ");
INSERT INTO kyq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kɛn Judas jaay ɓaaɗo aan se, naar ɓaa cɛɛ Isa ki ɔɔ ɗeekin̰ ɔɔ: «Debm dooyje!» Gɔtn se naan̰ baam ɔkin̰a ɔɔ aay ciilin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jee kuuy kꞋɓaaɗo tɛl se ɔɔ iij‑ɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Num maakɗe ki se, deb kalaŋ ɔɔɗo gɔrɗ‑jɛrlin̰a, ɔg gaaŋ te bi debm tɛɗn naabm magal debm tɛɗn sɛrkɛ Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Gaŋ Isa ɗeekɗen ɔɔ: «Naase Ꞌteeckiro ute gɔrɗ‑jɛrlsege ɔɔ te sirɗsege se, aan gɔɔ Ꞌɓaakiro kɔkŋ debm ɓoogo. ");
INSERT INTO kyq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ey num ɓii‑raa maam mꞋtiŋgo ute naase daan bɔɔr *Ɓee Raa ki mꞋlee dooy jeege, naɓo naase ɔŋ ɔkumkiro te eyo. Num jaaki jaay mꞋɓaamkiro kɔkɔ se, taa taar kꞋraaŋin̰o maakŋ Kitap ki do dɔkin̰ se, Ꞌkaan ɗoobin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Gaŋ gɔtn se, jee mɛtin̰ ki paac baatin̰a ɔɔ aan̰ rɛsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anum, gɔtn se goon kɔɗɔ kalaŋ bini ɔk mɛtn Isa ɔɔ naan̰ aal kal kuulu sum ɓo ron̰ ki. Jee se ɔkin̰a, ");
INSERT INTO kyq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","naɓo naan̰ an̰ ɔn̰ɗe kalin̰ jiɗe ki, aan̰ ɓaa mɛt‑beere. ");
INSERT INTO kyq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naaɗe ɔk ɓaan te Isa ɓee *magal debm tɛɗn sɛrkɛ Raa ki. Gɔtn se magal jee tɛɗn sɛrkɛ Raage tu, magal taa ɓee Yaudge ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, paac tus gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛr ɔko mɛtn Isa daanɗe goon dɔkɔ, ɛnd ɓaa bini aan daan bɔɔr ɓee magal debm tɛɗn sɛrkɛ Raa ki. Gɔtn se naan̰ iŋg riib riib pooɗo te jee tɛɗn naabge. ");
INSERT INTO kyq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anum magal jee tɛɗn sɛrkɛ Raage tu, ute magal Yaudgen kuuy paacn̰ jee kaakŋ mɛtn taarge se, naaɗe je tɔl taara do Isa ki taa an̰ kɔkŋ mindin̰ num, jꞋan̰ ɓaa tɔɔlɔ, naɓo naaɗe ɔŋ te taar ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ey num saaɗge dɛna ɓaaɗo tɔlin̰ taar‑kɔɔɓɔ don̰ ki, naɓo saaɗɗege ɔk mɛtn naap eyo. ");
INSERT INTO kyq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jee mɛtin̰ge uun taar mɛt ki eyo, ɔlin̰ don̰ ki taa an̰ kɔkŋ mindin̰a, ɗeek ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Naaje kꞋbooyo naan̰ taaɗ ɔɔ: ‹*Ɓee Raa kɛn jeege ɓo iin̰in̰ te jiɗe se, maam mꞋan̰ tɔɔkŋ naatn ɔɔ daan ɓiige tun mɔtɔ se, maam mꞋkiin̰ kɛn kuuy gɔtin̰ ki. Ɓee maam mꞋan̰ kiin̰ se, jikilimge ɓo an̰ kiin̰ te jiɗe eyo.›» ");
INSERT INTO kyq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ute naan̰ se kic ɓo, saaɗgen ɓaaɗo taaɗ taar se, taarɗe ɔk mɛtn naap eyo. ");
INSERT INTO kyq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Gɔtn se magal debm tɛɗn sɛrkɛ Raa ki se iin̰ ɗaar daan jeege tu ɔɔ tɔnd mɛtn Isa ɔɔ: «Naai tap ɓo Ꞌtɛrlɗen taar ɗim ey la do taarge tun naaɗe tɔli doi ki se?» ");
INSERT INTO kyq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gaŋ Isa do ɗɛk ɔɔ tɛrlin̰ taar ɗim eyo. Tɛr magal debm tɛɗn sɛrkɛ Raa ki tɔnd mɛtin̰ daala ɔɔ: «Naai ɓo *al‑Masi kɛn Goon Raa kɛn jeege lee tɔɔmin̰ se la?» ");
INSERT INTO kyq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isa tɛrlin̰ ɔɔ: «Yɛɛ, kɛse maama. Ɔɔ naase utu aki kaakŋ *Goon Deba se, iŋg kiŋg do ji daam Sidburku ki ɔɔ kɛn naan̰ aɗe bɔɔy se aɗe kiŋg do gapar ki.» ");
INSERT INTO kyq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gɔtn se magal debm tɛɗn sɛrkɛ Raa ki, iin̰ nɛɛpm te kalin̰ge ɔɔ ɗeek ɔɔ: «ꞋBooyki! Naase nakage kꞋjeki saaɗn nam kuuy se, gɛn ɗi daala! ");
INSERT INTO kyq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Naase lɛ Ꞌbooykiga te bise kɛn naan̰ naaj naaj Raa se! Anum naase Ꞌsaapki ɔɔki ɗi?» Jee gɔtn ese paac ɔjin̰ bɔɔrɔ don̰ ki ɔɔ: «Naan̰ se nakin̰ yoa!» ");
INSERT INTO kyq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jee mɛtin̰ge baagin̰ tupm ɓooro ron̰ ki, teelin̰ kaamin̰a, tɔndin̰ ute kutupu ɔɔ tɔnd mɛtin̰ ɔɔ: «ꞋTaaɗjen tu, debm taaɗ taar teeco taar Raa ki, kɛn tɔndi se, naŋa?» Gɔtn se asgarge kic ɓo ɔk ɓaansin̰a ɔɔ tɔndin̰ mɛtn bin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kaaɗ kɛn Piɛr jaay utu nɛŋ daan bɔɔr ki se, maakŋ mɛndge tun jee tɛɗn naabm *magal debm tɛɗn sɛrkɛ Raa ki se, deb kalaŋ ɓaaɗo. ");
INSERT INTO kyq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kɛn naan̰ aak Piɛr iŋg riib riib pooɗo se, gɔtn se naan̰ ɔndin̰ kaama tak, ɗeekin̰ ɔɔ: «Ɓɛrɛ, naai kic ɓo debm Isan kɔɗ Nazarɛt se.» ");
INSERT INTO kyq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Gɔtn se Piɛr baag naaja ɗeek ɔɔ: «Gaabm se maam mꞋjeelin̰ eyo ɔɔ taar naai Ꞌtaaɗ se lɛ, maam mꞋbooy mꞋɔk mɛtin̰ eyo.» Gɔtn se Piɛr iin̰ teec naatn ɓaa maakŋ ɓee kɛn taa ɗoob ki. Gaŋ gɔtn se sum ɓo kɔrɔn̰jɔ ɔɔɗ ɔɔyɔ. ");
INSERT INTO kyq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Num mɛnda se tɛrl aakin̰a ɔɔ baag taaɗn jeege tun iŋg gɔtn ese ɔɔ: «Gaabm ese kic ɓo mɛtn naaɗe!» ");
INSERT INTO kyq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Gaŋ Piɛr tɛrl naaj daala. Tɛr cɔkɔ sum ɓo, jee iŋg gɔtn ese ɗeekin̰ daala ɔɔ: «Ɗeer ɗeer, naai se mɛtn naaɗe, taa naai kic ɓo kɔɗ Galile.» ");
INSERT INTO kyq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Num Piɛr baag naam taarin̰ ɔɔ: «Ɓɛrɛ, maam mꞋnaam rom te Raa, mꞋtaaɗsen mꞋɔɔ: gaabm se maam mꞋjeelin̰ eyo ɔɔ kɛn mꞋtaaɗga taar‑kɔɔɓɔ kic ɓo ɔn̰ Raa am naama.» ");
INSERT INTO kyq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Gaŋ gɔtn se sum ɓo kɔrɔn̰jɔ ɔɔɗ ɔɔy gɛn k‑dige ɔɔ Piɛr naar saap do taar kɛn Isa taaɗin̰o ɔɔ: «Kɔr kɔrɔn̰jɔ kɔɔy ɗɔɔl di se, naai am baatn ɗɔɔl mɔtɔ.» Gɔtn se naan̰ saap do taar kɛn se, naar teeco ɔɔ baag keeme. ");
INSERT INTO kyq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tanɔɔrin̰ nɔɔrin̰ se, *magal jee tɛɗn sɛrkɛ Raage tu, ute magal taa ɓee Yaudge ɔɔ jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage, naaɗe se ɓo magal Yaudgen *jee kaakŋ mɛtn taarge, naaɗe paac tus taaɗ dɔɔk taarɗe kalaŋ. Kɛn naaɗe taarɗe tɛɗ kalaŋ se, gɔtn se ɔl kꞋjꞋɔk kꞋdɔɔk Isa ɔɔ ɔk ɓaa ɛɗin̰ Pilat ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kɛn naaɗe aan se, Pilat tɔnd mɛtn Isa ɔɔ: «Naai ɓo Gaar Yaudge la?» Isa tɛrlin̰ ɔɔ: «Yɛɛ aan gɔɔ kɛn naai Ꞌɗeekin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Magal jee tɛɗn sɛrkɛ Raage tu se tɔlin̰ taarge dɛna don̰ ki taa an̰ kɔkŋ mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tɛr Pilat tɔnd mɛtin̰ daala ɔɔ: «Naai Ꞌtɛrlɗen ey la? Naai Ꞌbooy ey la taar naaɗe tɔli doi ki taa ai kɔkŋ mindi se?» ");
INSERT INTO kyq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Num gaŋ Isa tɛrlin̰ te taar ɗim eyo. Kɛn Pilat aakin̰ se, ɔkin̰ taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kɛn aanga *laa Paak gɛn Yaudge se tak ɓo, jeege se ɓaaɗo tɔnd mɛtn Pilat ɔɔ jꞋɔɔɗ jꞋɔlɗen debm daŋgay kalaŋ kɛn naaɗe jenga ro ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naan̰ kɛn se, gaaba kalaŋ bini debm daŋgay kꞋdaŋin̰ Barabas, jꞋɔkin̰ daŋgay ki te sawarge. Kaaɗ kɛn jeege teec sawar se, naaɗe tɔɔlga deba. ");
INSERT INTO kyq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gaŋ ɓii kɛn se sum ɓo, jeege dɔɔlɔ ook ɔŋ Pilat ɔɔ tɔnd mɛtin̰ ɔɔ aɗe kɔɔɗn debɗe kalaŋ aan gɔɔ kɛn naan̰ n̰Ꞌlee n̰Ꞌtɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat tɛrlɗen ɔɔ: «ꞋJeki mꞋasen kɔɔɗn kɔl Gaar Yaudge se la?» ");
INSERT INTO kyq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Taa Pilat se jeele, kɛn *magal jee tɛɗn sɛrkɛ Raage tu jaay ɔk ɓaan̰o ute Isa se, naaɗe tɛɗ tɛɗ maak‑kilimi ɓo ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Anum magal jee tɛɗn sɛrkɛ Raage tu ɔl mɛtn jee dɛnge ɔɔ kꞋtɔnd mɛtn Pilat num, taa jꞋaɗen kɔɔɗn kɔl Barabasi. ");
INSERT INTO kyq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɔɔ jeege se, Pilat tɔnd mɛtɗe daala ɔɔ: «Num gaabm naase Ꞌdaŋin̰ki Gaar Yaudge se, mꞋan̰ tɛɗn mꞋɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gɔtn se, tɛr jeege ɗɔɔb ɔɔy caa ɔɔ: «Naan̰ se, Ꞌtup Ꞌtɔɔlin̰ ro kaag ki!» ");
INSERT INTO kyq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat tɛrlɗen ɔɔ: «Naan̰ tap ɓo tujga ɗi?» Num gaŋ jeege se tɔɔy dɔɔk taara ɔn̰ eyo ɔɔ: «Naan̰ se, Ꞌtup Ꞌtɔɔlin̰ ro kaag ki!» ");
INSERT INTO kyq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat je raapm maakŋ jee dɛnge se, ɔl kꞋɓaa kꞋjꞋɔɔɗ jꞋɔlɗen Barabas. Gaŋ gɛn Isa se, naan̰ ɔl kꞋjꞋɔndin̰ ute mɛɛjɛ ɔɔ ɔk ɔlin̰ asgarge tu taa jꞋan̰ ɓaa tupm tɔɔl ro kaag ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asgarge ɔk ɓaan te Isa daan bɔɔr ɓee kɛn maak ki ɔɔ ɓee se gɛn magal taa naaŋ gɔtn ese. Gɔtn se naaɗe daŋo dɔɔl asgarge paac. ");
INSERT INTO kyq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Naaɗe uun uusin̰ kal gaarin̰ge aac boŋ ɔɔ uj ɗaapo jɛkɛ gɛn kɔrɔndɔ, ɓaaɗo ɔndin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naaɗe baagin̰ tɛɗn tɔɔsɛ ɔɔ: «Tɔɔsɛ naai ki, Gaar Yaudge!» ");
INSERT INTO kyq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gaŋ gɔtn se, naaɗe tɔndin̰ don̰ ki te kaagŋ tec naala, tupin̰ ɓooro ron̰ ki, ɓaaɗo tɛrgɛ ɔɔ no naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kɛn naaɗe tooyin̰ koogo mɛtin̰ ki aas se, kal aac boŋ se naaɗe ɔɔɗin̰ naatn ɔɔ tuusin̰ kal naan̰ge gɔtin̰ ki jaay ɔk ɓaansin̰ naata, taa jꞋan̰ ɓaa tupm tɔɔl ro kaag ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gɔtn se, gaaba kalaŋ kꞋdaŋin̰ Simon kɔɗ Sirɛn. Naan̰ se bubm Alekzandɛr te gɛn Rupus. Naan̰ iin̰o naatn ɔɔ deel deel te ɗoobm se. Asgarge ɔkin̰ taa tɔɔgɔ gɛn kuun kaagŋ jꞋan̰ tupm Isa ro ki se. ");
INSERT INTO kyq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naaɗe ɔk ɓaan te Isa gɔt kɛn kꞋdaŋin̰ Golgota; Golgota se je ɗeekŋ ɔɔ: gɔtn kaaɗn do deba. ");
INSERT INTO kyq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Naaɗe ɛɗin̰ tɔtn koojn̰ bin̰ deep te dawa kꞋdaŋin̰ mir, gaŋ Isa baate kaaye. ");
INSERT INTO kyq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Gɔtn se, naaɗe tupin̰ ro kaag ki ɔɔ uun ɗaarin̰ raan ɔɔ kalin̰ge se, asgarge tɛɗin̰ salatia jaay ɓo nigin̰a ɔɔ debm oocin̰ga ɓo uunu uunu. ");
INSERT INTO kyq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Naaɗe tup Isa ro kaag ki se kaaɗn mɛs ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naaɗe tupin̰ aas se, raaŋ ɔlin̰ kaam don̰ ki mɛtn taar kɛn naaɗe ansin̰ tɔɔlɔ, naaɗe raaŋ ɔɔ: Kɛse ɓo Gaar Yaudge. ");
INSERT INTO kyq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Naaɗe iin̰ tup jee ɓoogge dio ro kaagge tu kici. Deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji daamin̰ ki ɔɔ deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji jeelin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jee deel deel gɔtn se jaay ɗaar aakin̰ se, naaɗe siik doɗe ɔɔ naajin̰ ɔɔ: «Waya! Naai ɓo debm ɔɔ Ꞌtɔɔkŋ *Ɓee Raa ɔɔ an̰ kiin̰ kuuy daan ɓiige tun mɔtɔ se, ");
INSERT INTO kyq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","aaj roi mala; Ꞌbɔɔy do kaag ki se naata!» ");
INSERT INTO kyq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","*Magalgen jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se kici, taaɗ te naapa ɔɔ tooyin̰ koogo mɛtin̰ ki ɔɔ: «Jee kuuy se, naan̰ aajɗenoga num, ɔŋ aasin̰ gɛn kaajn̰ ro naan̰ mal eyo. ");
INSERT INTO kyq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Naan̰ *al‑Masi kɛn Gaar *Israɛlge ɗey se, n̰Ꞌbɔɔyɔ naatn ɓɔrse ro kaag ki ɔɔ kɛn naaje jaay jꞋaakin̰ga naan̰ bɔɔyoga num, jꞋkaal maakje don̰ ki.» Jee ɓooggen kꞋtup kꞋtɔɔlɗe do kaagge tun cɛɛsn Isa ki se kic ɓo naajin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kɛn kaaɗa jaay aas katar tir se, do naaŋa te magalin̰ se gɔtɔ ɓaa tɛɗ ilim dib bini aan katar do tɛgɛr ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aan katar do tɛgɛr ki se, Isa ɔɔɗ ɔɔy makɔn̰ ute taar naaŋin̰a ɔɔ: «Eloyi, Eloyi, lɛma sabaktani?» Taar se je ɗeekŋ ɔɔ: Raama, Raama, naai Ꞌrɛsum gɛn ɗi? ");
INSERT INTO kyq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Maakŋ jeege tun ɗaar gɔtn ese se kɛn booyin̰ naan̰ taaɗ bin se, jee mɛtin̰ge taaɗ ute naapa ɔɔ: «ꞋƁooyki tu, naan̰ daŋ daŋ *Ɛli!» ");
INSERT INTO kyq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Gɔtn se deb kalaŋ aan̰ ɓaa uuno naka kalaŋ kɛn uun maane, ɔlin̰ maakŋ tɔtn koojn̰ bin̰ kɛn mooyo jaay, uun ɔlin̰ taa garɗ ki ɔɔ uun ɔlin̰ taar Isa ki taa n̰Ꞌsuubu. Tɛr ɗeek ɔɔ: «Ɔn̰ki jaay sɔm jꞋaakin̰ki, kɛn Ɛli jaay utu aɗe ɓaa an̰ bɔɔyin̰ naatn ro kaag ki se num.» ");
INSERT INTO kyq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gɔtn se, Isa ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ kon̰ teece. ");
INSERT INTO kyq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naan̰ kɛn se, kal deer kꞋgaaŋ maakŋ *Ɓee Raa se, nɛɛpo raan bini aan naaŋ ki tak. ");
INSERT INTO kyq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bubm asgarge kalaŋ kɛn ɗaar kaaɗn Isa ki se, jaay booy Isa ɔɔɗ ɔɔyɔ ɔɔ kaakŋ naan̰ aak kooyin̰ se, ɗeek ɔɔ: «Ɗeer ɗeer, gaabm ara se Goon *Raa!» ");
INSERT INTO kyq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gɔtn se mɛndge ɗaar dɔkɔ ɔɔ aakin̰a. Maakɗe ki se Mari kɛn iin̰o Magdala ki, Mari ko Jakŋ baata te gɛn Yozɛ ɔɔ ute mɛnda ron̰ Salome. ");
INSERT INTO kyq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kɛn Isa utu Galile ki se, naaɗe leeɗo te naan̰a ɔɔ tɛɗin̰o naaba. Gɔtn se mɛndgen kuuy kic dɛna ɓaaɗo te naan̰a Jeruzalɛm ki tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɓii kɛn se ɓo, Yaudge ɗaap ɗaap roɗe gɛn *ɓii sebitn kɛn Ꞌbaagŋ tɛgɛr kɛn gɔtɔ ɔkga jin̰ se. Kɛn kaaɗn tɛgɛr jaay aan se, ");
INSERT INTO kyq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","gaaba kalaŋ bini kɔɗ Arimate ron̰ Yusup ɓaaɗo. Maakŋ magal Yaudge tun jee lee kaakŋ mɛtn taarge se, naan̰ kic ɓo debm kꞋjeel jeel gɔtin̰a. Ɔɔ naan̰ kic iŋg aak kaak kaam *maakŋ Gaar Raa kɛn utu Ꞌkaan se. Naan̰ aay kaamin̰ ɓaa ɛnd ɔŋ Pilat ɔɔ tɔnd mɛtin̰a taa an̰ kɔn̰ ro Isa se naan̰ an̰ ɓaa kɔl maakŋ ɓaaɗ ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kɛn Pilat jaay booy jꞋɔɔ Isa ooyga se, ɔkin̰ taaɗ eyo. Naan̰ ɔl kꞋdaŋo bubm asgarge tɔnd mɛtin̰ ɔɔ: «Isa ooy se daanin̰ dɔkga la?» ");
INSERT INTO kyq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kɛn bubm asgarge jaay ɗeekin̰ ɔɔ: «Yɛɛ» naan̰ kɛn se jaay Pilat ɔn̰ Yusup ɓaa ɔɔɗ ro Isa. ");
INSERT INTO kyq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Num Yusup iin̰ dugo kal duubu, bɔɔyo ro Isa naatn ro kaag ki ɔɔ teelin̰ te kal se, uun ɔlin̰ maakŋ ɓaaɗ kɛn jꞋɔŋ ko ɓo jꞋuɗ kꞋɗaapin̰a ɔɔ dircil aalin̰ ko taar ki. ");
INSERT INTO kyq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari kɛn iin̰o Magdala ki ute Mari ko Yozɛ, naaɗe aak gɔtn jꞋɔl jꞋaalsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kɛn *ɓii sebit jaay deel se, Mari kɛn iin̰o Magdala ki, Mari ko Jak ute Salome dugo nakŋ oot nijimi gɛn ɓaa kɔtn ro Isa ki aan gɔɔ kɛn Yaudge lee tɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Num ɓii dumas ki tanɔɔrin̰ nɔɔrin̰, naaɗe iin̰ ɓaa ɓaa taa ɓaaɗ kɛn jꞋɔl jꞋaalo ro Isa maak ki se, taaɗ te naapa ɔɔ: «Naŋa jaay ajeki dircil ko taa ɓaaɗ ki se?» Kɛn naaɗe jaay aan taa ɓaaɗ ki se, kaaɗa utu ooko kooko. ");
INSERT INTO kyq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kɛn naaɗe jaay uun kaamɗe aak se, ko taa ɓaaɗ ki se nam dircilin̰ga, ey num, ko se magal bɛɛ eyo. ");
INSERT INTO kyq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kɛn naaɗe aan se, ɛnd maakŋ ɓaaɗ ki. Kaam do ji daamɗe ki se, aak goon kɔɗɔ iŋg ute kalin̰ raap raapo. Kɛn naaɗe aakin̰ se, dɔrlɔ ɔɔ nirlɗe teece. ");
INSERT INTO kyq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Gaŋ goon kɔɗɔ se taaɗɗen ɔɔ: «Ɔn̰ten Ꞌɓeerki! Naase se Ꞌjeki je Isan kɔɗ Nazarɛtn kɛn kꞋtup kꞋtɔɔlin̰ ro kaag ki se; naan̰ se duroga daan yoge tu; gɔtn ara se, naan̰ gɔtɔ. Aakki tu, kɛse ɓo gɔtn kɛn jꞋɔl jꞋaalsin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bin num, Ꞌɓaa Ꞌtaaɗki Piɛr ki te jee mɛtn Isa kɛn kuuy se ɔɔki: naan̰ se ɔndsenga naana, asen ɓaa booy taa naaŋ Galile ki. Gɔtn naane se ɓo, naase an̰ki Ꞌɓaa kaaka, aan gɔɔ kɛn naan̰ taaɗseno.» ");
INSERT INTO kyq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naaɗe teec aan̰ ɔn̰ taa ɓaaɗa taa naaɗe se nirlɗe teecga ɔɔ roɗe kic ɓo ɔk marga jɛg jɛg. Kɛn ɓeere ɔkɗe se, taar ɗim kic ɓo naaɗe ɔŋ taaɗ nam ki eyo.  ");
INSERT INTO kyq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Isa duro daan yoge tu se ɓii dumas ki tanɔɔrin̰ nɔɔrin̰. Deet deet se naan̰ teec naan Mari kɛn iin̰o Magdala ki, naan̰ ɓo kɛn Isa tuurin̰o sitange cili ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mɛnd se ɓaa taaɗ jeege tun tiŋgo te Isa ɔɔ kɛn naan̰ ɔŋɗe se, naaɗe maakŋ kɔl do ki ɔɔ iŋg eem keeme. ");
INSERT INTO kyq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kɛn naaɗe jaay booy taar naan̰ taaɗɗen ɔɔ Isa se duroga daan yoge tu ɔɔ naan̰ mala aakin̰oga ute kaamin̰ se, gaŋ jee se baate tookŋ taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kɛn nakgen se jaay deel se, jee mɛtin̰ kɛn dio ɓaa ɓaa ɓee naata. Kɛn naaɗe jaay ɓaa ɓaa ɗoob ki se, Isa teec naanɗe ki ute ro kuuy. ");
INSERT INTO kyq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jee se tɛrl ɓaaɗo taaɗ jeeɗege tun kuuy ɔɔ jee se kic ɓo naaɗe baate tookŋ taarɗe. ");
INSERT INTO kyq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tɛr Isa ɓaaɗo teec naan jee mɛtin̰ kɛn sik‑kaar‑kalaŋ, kaaɗ kɛn naaɗe iŋg ɔs kɔsɔ. Gɔtn se naan̰ mooyɗe taa naaɗe baate kaal maakɗe don̰ ki ɔɔ taa do‑mɔŋgɗen kɛn ɔlɗe naaɗe baate tookŋ taar jeegen ɓaaɗo taaɗɗen ɔɔ naan̰ duroga ɔɔ naaɗe aakin̰ga te kaamɗe se. ");
INSERT INTO kyq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naan̰ taaɗɗen ɔɔ: «ꞋƁaaki do naaŋ ki paac ɔɔ Ꞌtaaɗki Labar Jiga se jeege tu paac. ");
INSERT INTO kyq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Debm took aalga maakin̰ se jꞋan̰ *batizi ɔɔ naan̰ kɔŋ kaaja, num debm baate tookŋ kaal maakin̰ lɛ bɔɔr utu kɔjn̰ don̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","ꞋBooyki! Jee aalga maakɗe dom ki se, naaɗe kɔŋ tuur sitange te roma ɔɔ naaɗe kɔŋ taaɗn taar naaŋgen kuuy. Naaɗe tɔkŋ wɔɔjge te jiɗe ɔɔ kɛn aayga kaagŋ tɔɔlɔ kic ɓo, aɗe kɔŋ tɛɗn ɗim eyo. Naaɗe tɔnd jiɗege do jee kɔɔn̰ge tu ɔɔ jee kɔɔn̰ge Ꞌkɔŋ lapia. Kɛse ɓo nakŋ‑kɔɔɓgen naaɗe tɛɗa. ");
INSERT INTO kyq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kɛn Mɛljege Isa jaay taaɗ naŋ taarin̰ se, Raa uun ɓaansin̰ maakŋ raa ki ɔɔ naan̰ iŋg do ji daamin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɔɔ jee mɛtin̰ ki se ɓaa gɔtɔ ɓaa se paac taaɗ Labar Jiga gɛn Isa se jeege tu. Ɔɔ Mɛlje Isa noogɗe maakŋ naabɗe ki, naaɗe tɛɗga nakgen deel doa taa jeege jeele taar naaɗe taaɗ se, taar mɛt ki.");
INSERT INTO kyq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teopil, jeege dɛna raaŋoga mɛtn taar nakgen deel daanjege tu se. ");
INSERT INTO kyq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jeegen ɓaaɗo taaɗjeki mɛtn taar nakgen deel ese se ɔɔ naaɗe se ɓo jee saaɗgen mɛtn‑jiki aako ute kaamɗe, ɓɔrse naaɗe se ɓo kɛn tɛɗga jee lee wɔɔk taar *Raa se. ");
INSERT INTO kyq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Taa naan̰ se ɓo, Jaamus, gɔtn nakŋ se jaay uuno mɛtin̰ sum se, maam mꞋtuuro mɛtin̰ tak tak jaay ɓo maakin̰ tɔɔlumi ɔɔ mꞋje mꞋaisin̰ raaŋ te ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bin ɓo do nakge tun kꞋtaaɗio mɛtin̰ se, naai Ꞌjeele kɛse ɓo taar mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kaaɗ kɛn *Ɛrɔd iŋgo gaar taa naaŋ Jude se, gaaba kalaŋ, *debm tɛɗn sɛrkɛ Raa ki kꞋdaŋin̰ Zakari. Naan̰ se mɛtn jee Abiage ɔɔ mɛndin̰ se ron̰a Elizabet; naan̰ kic mɛtjil gɛn *Aarunge. ");
INSERT INTO kyq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Naaɗen di se paac jee bɛɛ naan Raa ki, naaɗe iŋg do *Ko Taar kɛn Raa ɛɗo *Musa ki ɔɔ nakgen kɛn Raa ɔɔ kꞋtɛɗ se, naaɗe paac tɛɗin̰ te ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gaŋ naaɗe se ɔk gaange eyo, taa mɛndin̰ Elizabet se mɛndkarta ɔɔ naaɗe di se lɛ paac gɔɔlga. ");
INSERT INTO kyq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɓii kalaŋ se, aan kaabm Zakari ki ute jeen̰ge gɛn ɓaa tɛɗn *sɛrkɛ maakŋ *Ɓee Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aan gɔɔ jee tɛɗn sɛrkgen naan Raage tu kɛn lee tɛɗ do dɔkin̰ se, kɛn kaaɗin̰ jaay aanga num, naaɗe bɛɛr ɔɔɗ deb kalaŋ te salatia gɛn ɓaa kɛnd ɓee Mɛljege tu Raa ki ɔɔ taa Ꞌɓaa tɔɔcn nakŋ oot nijim naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kaaɗ kɛn jaay Zakari ɛnd maakŋ Ɓee Raa ki gɛn tɔɔcn nakŋ oot nijim se, jee dɛn se iŋg naatn eem keem Raa. ");
INSERT INTO kyq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gɔtn se, kɔɗn Mɛljege Raa teec naan Zakari ki ɔɔ naan̰ ɗaar do ji daam ki gɔtn kɛn kꞋlee kꞋtɔɔcn nakŋ oot nijim se. ");
INSERT INTO kyq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kɛn Zakari jaay aakin̰ se, nirlin̰ teece ɔɔ ɓeere ɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gaŋ kɔɗn Raa ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌɓeere Zakari! Taa Raa se naan̰ booyiga keemi. Mɛndi Elizabet se utu ai koojn̰ goon gaaba ɔɔ naai an̰ kɔnd ron̰ Jan. ");
INSERT INTO kyq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Goon se ai tɛɗi naai maaki ute raapm dɛn aak eyo ɔɔ ɓii koojin̰ ki se, jeege dɛna maakɗe utu Ꞌraapm kici. ");
INSERT INTO kyq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Taa naan̰ se utu Ꞌtɛɗn debm magala naan Mɛljege tu. Tɔtn koojn̰ bin̰ ute tɔtn te ɔrɔmin̰ se, naan̰ Ꞌkaay eyo. Num kɛn naan̰ utu maakŋ kon̰ ki sum ɓo, Raa utu an̰ ɗoocin̰ te *Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naan̰ an tɔɔɗn ɓaa ute gaan *Israɛlge dɛna naan Mɛlɗe Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɔɔ naan̰ utu Ꞌlee naan Raa ki ute tɔɔgŋ *Ɛli ɔɔ ute Nirl Raa kɛn bɔɔyo don̰ ki se, taa naan̰ Ꞌtɛɗn bubge ute gaange se Ꞌkɔkŋ taasa ute naapa, ɔɔ jeegen kɛn baate tookŋ taar Raa se lɛ, naan̰ aɗen tɛrl maakɗe Ꞌtɛɗn jee kɛn tɛɗ nakge ute ɗoobin̰a. Bin jaay ɓo, naan̰ Ꞌtɛɗn jeege se Ꞌɗaap roɗe gɛn booy Mɛlɗe.» ");
INSERT INTO kyq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakari ɗeek kɔɗn Raa ki ɔɔ: «Naan̰ se maam mꞋan̰ mꞋjeelin̰ mꞋɔɔ ɗio? Taa maam lɛ mꞋgɔɔlga ɔɔ mɛndum kic lɛ gɔɔlga gɔɔlɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Gɔtn se kɔɗn Raa tɛrlin̰ ɔɔ: «Maam ɓo mꞋGabriɛl kɛn mꞋɗaar naan Raa ki gɛn tɛɗn naabin̰a. Naan̰ ɓo ɔlumo taa mꞋtaaɗn te naai ɔɔ mꞋai taaɗn labar jigan ese se. ");
INSERT INTO kyq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ꞋBooyo! Aan gɔɔ naai uun te taarum ey se, naan ki se, naai Ꞌbooyo, naɓo Ꞌkɔŋ taaɗn taar eyo bini, taar maam taaɗi se Ꞌkaan ɗoobin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kaaɗ kɛn se jee dɛn se iŋg aak kaamin̰a ɔɔ nakŋ se deel doɗe kɛn Zakari ɛnd maakŋ Ɓee Raa ki jaay teeco yɔkɔɗ ey se. ");
INSERT INTO kyq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kɛn naan̰ teeco sum se, naan̰ ɔŋ taaɗ taar eyo. Naan̰ kɛn se, jee dɛn se saap jeelga ɔɔ Zakari aakoga ne ɗim maakŋ Ɓee Raa ki. Kɛn naan̰ jaay teeco se, naan̰ taaɗ te jin̰a, ɔŋ taaɗga ute taarin̰ ey sum. ");
INSERT INTO kyq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kɛn ɓii tɛɗn naabin̰ jaay aas se, Zakari ɔk tɛrl ɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kɛn nakgen se jaay deel se, mɛndin̰ Elizabet tɛɗ mɛndkaama. Kɛn Elizabet jaay uun maaka sum se, maakŋ laap kɛn mii se, naan̰ ɔy ron̰ maak ki ɔɔ taaɗ te maakin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kɛse ɓo bɛɛ kɛn Mɛlum tɛɗum maam ki ɔɔ sɔkɔn̰um se, naan̰ ɔɔɗumsin̰ga naatn naan jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kɛn Elizabet jaay uun maaka ɔɔ ɔk laapa mɛcɛ se, tɛr Raa ɔlo kɔɗin̰ Gabriɛl daala taa naaŋ Galile ki, maakŋ gɛgɛr kɛn kꞋdaŋin̰ Nazarɛt, ");
INSERT INTO kyq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","gɔtn goon mɛnd ki. Ɔɔ goon mɛnd se jeel te gaab eyo. Naan̰ se ron̰ Mari, gaabm kɛɛsin̰ se ron̰ Yusup ɔɔ Yusup se, naan̰ mɛtjil *Daud. ");
INSERT INTO kyq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","*Kɔɗn Raa ɛnd ɔŋin̰ ɓeen̰ ki ɔɔ ɗeekin̰ ɔɔ: «Tɔɔsɛ Mari, naai se ɔn̰ maaki raapm sakan̰. Taa Mɛljege Raa se naan̰ tɛɗiga bɛɛ ɔɔ naan̰ utu te naai.» ");
INSERT INTO kyq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kɛn Mari jaay booy taar ese se, taar se deel don̰a ɔɔ naan̰ taaɗ te maakin̰ ɔɔ: «Kɛse ɓo tɛɗn tɔɔsn ɔɔ ɗio bini?» ");
INSERT INTO kyq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kɔɗn Raa tɛrlin̰ ɔɔ: «Mari, ɔn̰te gɛn ɓeere, taa naai se ɔŋga bɛɛ naan Raa ki! ");
INSERT INTO kyq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ꞋBooyo. Naai utu Ꞌtɛɗn mɛndkaama utu Ꞌkoojn̰ goon gaaba ɔɔ goon se an̰ kɔnd ron̰ Isa. ");
INSERT INTO kyq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naan̰ utu Ꞌtɛɗn magala naan Raa ki ɔɔ jꞋan̰ daŋin̰ Goon Raa Taaro. Mɛljege Raa utu an̰ kɛɗn gaar ɓugin̰ Daud. ");
INSERT INTO kyq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Naan̰ Ꞌkɔsn gaara gɛn daayum do gaan *Israɛlge tu ɔɔ gaar naan̰ se Ꞌkɔŋ naŋ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari tɔnd mɛtn kɔɗn Raa ɔɔ: «Nakŋ se tap ɓo Ꞌtɛɗn ɔɔ ɗio? Maam lɛ mꞋjeel te gaab ey ɓɔrtɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kɔɗn Raa tɛrlin̰ ɔɔ: «*Nirl Salal utu aɗe bɔɔy doi ki, ɔɔ tɔɔgŋ Raa Taaro se utu ai deebm ute Nirlin̰ bat. Taa naan̰ se ɓo, goon naai an̰ kooj se Ꞌtɛɗn goon *salal ɔɔ naan̰ se jꞋan̰ daŋin̰ Goon Raa. ");
INSERT INTO kyq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ꞋBooyo: taasi Elizabet kɛn mɛndkarta se kic ɓo do gɔɔlin̰ ki se, tɛɗga mɛndkaama ɓɔrse ɔkga laapa mɛcɛ. ");
INSERT INTO kyq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ɓɛrɛ, ne ɗim jaay ɔɔn̰ Raa ki se, gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Gɔtn se Mari ɗeek ɔɔ: «Maam se mꞋɓul gɛn Raa. Maam mꞋtooko do taari ki. Ɔn̰ Ꞌtɛɗn aan gɔɔ kɛn naai Ꞌtaaɗum ro ki se.» Ɔɔ gɔtn se kɔɗn Raa iin̰ ɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Naan̰ kɛn se, Mari naar ook ɓaa maakŋ koge tun taa naaŋ Jude ki maakŋ gɛgɛr ki kalaŋ bini. ");
INSERT INTO kyq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naan̰ ɓaa ɛnd ɓee Zakari ki ɔɔ tɛɗ tɔɔsɛ mɛndin̰ Elizabet ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kɛn Elizabet jaay booy tɛɗn tɔɔsn Mari se, goon maakin̰ ki kic ɓo baag tɔɔbm ron̰a ɔɔ *Nirl Salal se ɗooc maakŋ kon̰ Elizabet. ");
INSERT INTO kyq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Gɔtn se naan̰ ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ ɗeek Mari ki ɔɔ: «Maakŋ mɛndge tu se, naai sum ɓo kɛn Raa tɛɗiga bɛɛ cir paac ɔɔ goon kɛn maaki ki se kic ɓo, Raa tɛɗin̰ga bɛɛn̰a! ");
INSERT INTO kyq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maam ara ɓo mꞋnaŋa kaca jaay ɓo ko Mɛluma ɓaaɗo ɓaa gɔtum ki taa am kaak se! ");
INSERT INTO kyq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","«ꞋBooyo: kɛn jaay maam booy tɛɗn tɔɔsn naai sum se, goon maakum ki kic ɓo maakin̰ ɓaa raapo ɔɔ baag tɔɔbm maakum ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naai se Ꞌmaaki raapo taa naai Ꞌtookga taar kɛn Mɛljege taaɗi se, taa nakŋ naan̰ taaɗi se utu Ꞌkaan ɗoobin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Gɔtn se Mari ɗeek ɔɔ: «Maam se *mꞋnook Mɛlum Raa ute maakum paac. ");
INSERT INTO kyq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Maakum ɗooc te maak‑raapo do Raa ki; naan̰ se Mɛl Kaajuma. ");
INSERT INTO kyq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Maam mꞋɓulin̰ kɛn jeege aalum maak ey se, naan̰ saapga dom ki. Ɗeere, naan ki se, kɛngen jꞋutu jꞋaɗega tooj paac se, utu am daŋum mɛnd maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Taa Raa Sidburku se tɛɗumga nakgen bɛɛ dɛn aak eyo ɔɔ ro naan̰ se, ro kɛn *salal. ");
INSERT INTO kyq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Daayum naan̰ tɛɗ bɛɛn̰a do jeege tun ɓeerin̰. ");
INSERT INTO kyq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Raa se taaɗga tɔɔgin̰a ɔɔ jee kɛn magal roɗe se, naan̰ wɔɔkɗenga. ");
INSERT INTO kyq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gaarin̰gen tɔɔgŋ kꞋjeel jeel gɔtɗe se, naan̰ tuurɗege naatn maakŋ gaarɗege tu. Num gaŋ jee ɔɔp roɗe baat se, naan̰ uunɗega roɗe raan. ");
INSERT INTO kyq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jee ɓo tɔɔlɗe se, naan̰ ɛɗɗenga kɔsɔ ute maraadɗe ɔɔ jee maalge se lɛ, naan̰ tuurɗega te jiɗe sik. ");
INSERT INTO kyq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Raa se naan̰ dirig te gɛn tɛɗn bɛɛn̰ jeen̰ge tu eyo «ɔɔ naan̰ ɓaaɗoga noogŋ jee tɛɗn naabin̰gen gaan *Israɛlge. ");
INSERT INTO kyq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kɛse ɓo nakŋ kɛn naan̰ taaɗo bubjege tu ɔɔ utu Ꞌtɛɗn *Abraam ki ute mɛtjilin̰ ki gɛn daayum daayum se.» ");
INSERT INTO kyq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tɛr gɔtn se, Mari tiŋg te Elizabet se ɓaa ɓaa nakŋ laapa mɔtɔ jaay, ɔk tɛrl ɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɓii kɛn Elizabet an kooj jaay aan se, naan̰ ooj goon gaaba. ");
INSERT INTO kyq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kɛn jee do daamboogin̰ge ute taasin̰ge jaay booy bɛɛ kɛn Raa tɛɗin̰ se, naaɗe tɛɗ maak‑raapo ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kɛn ooj jaay ɔk ɓii marta se, naaɗe uun ɓaano ute goono taa jꞋan̰ *kɔjn̰ pɔndɔ. Gɔtn se jeege ɔɔ goono se jꞋan̰ daŋin̰ ute ro bubin̰ Zakari. ");
INSERT INTO kyq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gɔtn se kon̰a ɛɛp taarin̰a ɔɔ taaɗɗen ɔɔ: «Bin eyo! Goono se jꞋan̰ daŋin̰ Jan.» ");
INSERT INTO kyq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Naaɗe tɛrlin̰ ɔɔ: «Taa ɓeese ki se nam ron̰a bin se, ɓɛrɛ, gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɔɔ naaɗe tɔnd mɛtn bubin̰a ute jiɗe, taa n̰Ꞌaɗen taaɗa goono se tap ɓo naan̰ je jꞋan̰ daŋin̰ naŋa? ");
INSERT INTO kyq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bubin̰ taaɗɗen ute jin̰a ɔɔ kꞋɓaano ute kaaga paak paaka. Naan̰ raaŋ ro ki ɔɔ: goono se ron̰ Jan. Jeegen paacn̰ iŋg gɔtn ese jaay aak nakŋ se tap ɓo ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gaŋ gɔtn se sum ɓo, Zakari, Raa ɛɛpin̰ taarin̰a baag taaɗn taara ɔɔ naan̰ tɔɔm Raa. ");
INSERT INTO kyq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jee do daamboogɗege jaay booy se, ɓeere ɓaa ɔkɗe ɔɔ jeegen iŋg maakŋ koge tun kɛn taa naaŋ Jude ki paac se, naaɗe lee ɔɔs maana do nakge tun deel se. ");
INSERT INTO kyq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jeegen paacn̰ booy mɛtn taar nakgen ese se, taar se naaɗe ɔkin̰ maakɗe ki ɔɔ naaɗe taaɗ ute naapa ɔɔ: «Goon se tap ɓo Ꞌtɛɗn goon ɔɔ ɗi?» Anum goon se, ɗeere, Raa utu te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gɔtn se, Zakari bubm Jan se, maakin̰ ɗooc ute *Nirl Salal ɔɔ Nirl Salal se ɔlin̰ taaɗ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«KꞋtɔɔmki Mɛljege, naan̰ ɓo Raa gɛn gaan *Israɛlge, taa naan̰ ɓaaɗoga kaakŋ jeen̰ge ɔɔ dugɗenga doɗe. ");
INSERT INTO kyq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Maakŋ ɓee gɛn ɓulin̰ Gaar *Daud se, naan̰ ɛɗjekiga Debm Kaajn̰ tɔɔgɔ. ");
INSERT INTO kyq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kɛse ɓo taar kɛn jeegen *salal kɛn taaɗ taar teeco taar Raa ki taaɗo do dɔkin̰ jeege tu se. ");
INSERT INTO kyq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naan̰ taaɗjekiga ɔɔ naan̰ utu ajeki kɔɔɗn dojege maakŋ ji jee taamooyjege tu ɔɔ ji jeege tun paacn̰ jejeki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Taa naan̰ tɛɗga bɛɛ do bubjege tu ɔɔ naan̰ se saapga do *dɔɔk kɛn salal kɛn naan̰ dɔɔko ute naaɗe se, ");
INSERT INTO kyq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","aan gɔɔ kɛn naan̰ naamo taarin̰a bubjege tu *Abraam ki. ");
INSERT INTO kyq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kɛn naan̰ jaay ɔɔɗjekiga dojege ji jee taamooyjege tu se, naan̰ utu ajeki tɛɗn bɛɛ ɔɔ naajege jꞋan̰ki keem kic ɓo jꞋan̰ki ɓeer eyo, ");
INSERT INTO kyq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ɔɔ daayum naanin̰ ki se jꞋaki tɛɗn jee salal, jꞋaki kɔkŋ taarin̰ ɔɔn̰ɔ ɔɔ jꞋaki tɛɗn nakge ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anum, naai goonum se, jꞋutu jaay daŋi debm kɛn taaɗ taar teeco taar Raa kɛn Taaro. Taa naai se utu Ꞌlee naan Mɛli Raa ki taa an̰ ɗaapm ɗoobin̰a, ");
INSERT INTO kyq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ɔɔ naai Ꞌtɛɗn jeen̰ge Ꞌjeele, Raa se debm tɔɔl *kusin̰ɗe ɔɔ naan̰ ɓo debm aɗen kɛɗn kaaja. ");
INSERT INTO kyq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Taa Raa naajege se, naan̰ debm bɛɛ dɛn aak eyo. Taa bɛɛ naan̰ se ɓo, naan̰ utu ajekiro kɔl gɔtn wɔɔrɔ taa ajeki wɔɔr gɔtɔ aan gɔɔ bɔɔr kaaɗn utu ooko kook se. ");
INSERT INTO kyq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Naan̰ utu wɔɔr jeegen iŋg maakŋ gɔt kɛn ɔɔɗɔ ɔɔ jee kɛn iŋg taa yo ki, taa naan̰ ajeki tɔɔɗn te ɗoobm kɛn jꞋanki kɔŋ lapia.» Gɔtn se Zakari taaɗ naŋ taarin̰ bini. ");
INSERT INTO kyq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Goono se teepe ɔɔ mɛtɛk ɓaa te naanin̰a. Naan̰ ɓaa iŋg do kɔɗ‑ɓaar ki ɔɔ tiŋg bini aan ɓii kɛn naan̰ baag tɛɗn naabin̰ naan gaan *Israɛlge tu. ");
INSERT INTO kyq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kaaɗ kɛn se, Gaar magal iŋg *Rɔm ki kɛn kꞋdaŋin̰ Sezar Ogust se, ɔlo ɔɔ jee taa naaŋin̰ ki paac se jꞋaɗen Ꞌɓaa mɛɗɛ. ");
INSERT INTO kyq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mɛɗn deet deet bin se baag kaaɗ kɛn Kirinius ɓo magal jee taa naaŋ Siri ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jeege paac, naŋa naŋa kic ɓo iin̰ ɓaa maakŋ naaŋin̰ ki taa jꞋan̰ ɓaa mɛɗɛ. ");
INSERT INTO kyq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Taa naan̰ se ɓo Yusup iin̰o maakŋ gɛgɛr kɛn Nazarɛt kɛn taa naaŋ Galile ki, naan̰ kic ook ɓaa maakŋ gɛgɛr kɛn Betleem kɛn taa naaŋ Jude ki. Betleem se, gɔtn jꞋoojn̰ Gaar *Daud. Kɛn ɔlin̰ Yusup jaay ɓaa naane se, taa naan̰ kic iin̰o mɛtjil Daud ki ɔɔ teeco kaagŋ ɓee naan̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naan̰ ɓaa ute mɛnd kɛɛsin̰ Mari mɛndkaama maakin̰ magalga magala taa jꞋan̰ ɓaa mɛɗɛ. ");
INSERT INTO kyq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kɛn naaɗe aan Betleem ki se, kaaɗ kɛn naaɗe tiŋg naane se ɓo, ɓii kɛn Mari an kooj se, aasa. ");
INSERT INTO kyq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Gɔtn se Mari ooj goon paragin̰ gaaba. Naan̰ teelin̰ ute kala ɔɔ uun aalin̰ maakŋ kɔlay ki taa naaɗe ɔŋ te gɔt eyo maakŋ ɓee tooɗn mɛrtge tu se. ");
INSERT INTO kyq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maakŋ taa naaŋ gɔtn ese se naatn cɛɛs ki cɛɛs ki se, jee gaam baatge tiŋg lee gaam baatɗege nɔɔr. ");
INSERT INTO kyq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gɔtn se sum ɓo kɔɗn Raa naar teec naanɗe ki, ɔɔ Mɛljege *Raa tɛɗɗen gɔtɔ wɔɔr kɛlɛŋ ɔɔ naaɗe nirlɗe teece. ");
INSERT INTO kyq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Num kɔɗn Raa se ɗeekɗen ɔɔ: «Ɔn̰ten Ꞌɓeerki! ꞋBooyki: maam ɓaanseno ute Labar Jiga kɛn utu Ꞌraapm maakŋ jeege paac dɛn bɛɛ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Taa nɔɔr jaaki ara se, jꞋoojsega Debm Kaaja maakŋ gɛgɛr gɛn Gaar *Daud ki. Naan̰ ɓo *al‑Masi kɛn Raa taaɗo mɛtn taarin̰ do dɔkin̰a. Naan̰ se ɓo, Mɛljege. ");
INSERT INTO kyq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kɛn naase jaay ɓaa aankiga se, naase aki kɔŋ goon kꞋtaace se kꞋteelin̰ga teel ute kala ɔɔ jꞋaalin̰ga tooɗ tooɗ maakŋ kɔlay ki. Kɛse ɓo nakŋ kɛn naase anki kaakŋ jeel ro ki.» ");
INSERT INTO kyq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gɔt kɛn se sum ɓo kɔɗn Raagen kuuy dɔɔlɔ naar ɓaaɗo ɔŋ debɗe se ɔɔ baag tɔɔm Raa tɛlɛ ute kaa ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«*KꞋnookki Raa kɛn iŋg raan maakŋ raa ki. Naan̰ ɓo debm ɛɗ tɔɔsɛ jeege tun do naaŋ ki kɛn naan̰ jeɗe.» ");
INSERT INTO kyq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kɛn kɔɗn Raage jaay iin̰ ɔn̰ɗe ɔɔ ɔk tɛrl ɓaa maakŋ raa ki se, gɔtn se jee gaam baatge baag taaɗn ute naapa ɔɔ: «KꞋɓaaki ɓɔrse Betleem ki jꞋaki ɓaa kaakŋ nakŋ kɛn tɛɗ jaay Mɛljege taaɗjekiro mɛtin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gɔtn se naaɗe naar iin̰ ɓaa. Kɛn naaɗe aan se ɔŋ Mari, Yusup ɔɔ goon kꞋtaace tooɗ tooɗ maakŋ kɔlay ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kɛn naaɗe jaay aakin̰ se, naaɗe baag kɔɔsn maanin̰ jeege tu taar kɛn kɔɗn Raa taaɗɗeno ro goon ki se. ");
INSERT INTO kyq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɔɔ jee paacn̰ kɛn booy maan jee gaam baatge paac se, naaɗe booy taar se ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gaŋ Mari se, taargen deel paac se, naan̰ ɔkin̰ maakin̰ ki tak ɔɔ tiŋg saap do ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Gɔtn se jee gaam baatge ɔk tɛrl uun ɗoobm baatɗege. Kɛn naaɗe ɓaa ɓaa se, nook Raa ɔɔ tɔɔmin̰ ute kaa taa nakgen naaɗe aako ɔɔ booyo se, taa nakgen se paac, naaɗe ɓaa ɔŋin̰ te ɗoobin̰a aan gɔɔ kɛn kɔɗn Raa taaɗɗeno se. ");
INSERT INTO kyq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kɛn goono kꞋjꞋoojin̰ jaay ɔk ɓii marta se, kɛse ɓo ɓii kɛn jꞋɔjin̰ pɔndɔ. Goono se jꞋɔndin̰ ron̰ Isa, ro se ɓo kɛn kɔɗn Raa taaɗɗesin̰ kaaɗ kɛn kon̰a utu aam te ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kɛn nakgen se jaay deel paac se, kaaɗin̰ aas se naaɗe ɓaaɗo maakŋ gɛgɛr kɛn Jeruzalɛm ki ɛnd maakŋ Ɓee Raa ki gɛn tugŋ ɗaapm roɗe. Naaɗe tɛɗin̰ aan gɔɔ *Ko Taar kɛn Raa ɛɗo Musa ki taaɗno. Ɔɔ kaaɗ kɛn se ɓo naaɗe uun ɓaano ute goono ɓaaɗo taaɗin̰ naan Mɛljege tu Raa ki kici. ");
INSERT INTO kyq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Taa maakŋ Ko Taar kɛn Raa ɛɗo Musa ki se kꞋraaŋga raaŋ jꞋɔɔ: Gaan paragen gaabge paac se, jꞋɛɗin̰ Mɛljege tu Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Taa naan̰ se tɛr Ko Taar kɛn Raa ɛɗo Musa ki se taaɗ ɔɔ gɛn tɛɗn *sɛrkɛ Raa ki se jꞋano ɓaa ute: dɛɛrge dio ey lɛ napar gaan dɛɛrgen kuuy dio. ");
INSERT INTO kyq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Anum maakŋ Jeruzalɛm ki se, gaaba kalaŋ ron̰ Simɛon. Naan̰ se debm daan ki ɔɔ ɔk ɗoobm Raa ɔɔn̰ɔ. Naan̰ iŋg aak kaam debm kɛn utu Ꞌkaajn̰ gaan *Israɛlge ɔɔ *Nirl Salal utu te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nirl Salal taaɗin̰oga taaɗa ɔɔ: «Naai se Ꞌkooy eyo Ꞌtiŋg bini utu Ꞌkaakŋ ute kaami *al‑Masi kɛn Mɛljege Raa utu an̰o kɔl se jaayo.» ");
INSERT INTO kyq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nirl Salal ɔl Simɛon iin̰ ɓaa maakŋ *Ɓee Raa ki ɔɔ kaaɗ kɛn se ɓo bubm Isa ute kon̰a ɓaansin̰o naan Raa ki gɛn tɛɗn nakŋ kɛn *Ko Taar kɛn Raa ɛɗo Musa ki ɔɔ kꞋtɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Gɔtn se Simɛon uun Isa jin̰ ki ɔɔ tɔɔm Raa ɗeek ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ɓɔrse Mɛluma, taar naai Ꞌtaaɗum se aanga ɗoobin̰ ki, ɔn̰ ɓuli se Ꞌkooy ɓaa ute lapia. ");
INSERT INTO kyq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Taa kaamum se aakga Debm‑kaajn̰ kɛn naai ɔlin̰o se. ");
INSERT INTO kyq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kɛse ɓo Debm‑kaajn̰ kɛn naai ɔlo jeege tu paac. ");
INSERT INTO kyq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naan̰ ɓo debm kɛn utu wɔɔr gɔtɔ ɔɔ tɛɗn jeegen Yaudge eyo Ꞌjeel Raa ɔɔ ute ro naan̰ se, gaan Israɛlge roɗe utu Ꞌkookŋ raan.» ");
INSERT INTO kyq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taar kɛn Simɛon taaɗ ro goon ki, jaay bubin̰ ute kon̰ booy se, taar se tap ɓo ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gɔtn se Simɛon ɔɔɗɗen ɓooro ɔɔ ɗeek Mari kon̰ ki ɔɔ: «ꞋJeele, ute goon ese se gaan Israɛlgen dɛn mɛtin̰ge se, utu Ꞌkiigi ɔɔ jee mɛtin̰ge se utu Ꞌkaaja. Taa naan̰ ɓo Ꞌtɛɗn debm kɛn jeege an jeel Raa, naɓo jeegen mɛtin̰ge se Ꞌtook eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ute naan̰ se maak‑saapm naaɗe se, Raa utu an̰ Ꞌtɛɗin̰ Ꞌtooɗn tal ɔɔ naai, Mari kon̰ se, utu Ꞌdabara aan gɔɔ debm kꞋjꞋɔɔsin̰ ute gɔrɗ‑jɛrlɛ.» ");
INSERT INTO kyq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gɔtn se mɛnd gɔɔlɔ kalaŋ se, ron̰ Ann. Naan̰ se, goon Panuel, mɛtjil gɛn Asɛrge. Naan̰ se mɛnd taaɗ taar teeco taar Raa ki. Ute gaabin̰ se, naaɗe tiŋgo ɓaara cili sum. ");
INSERT INTO kyq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Gɔtn gaabin̰ ooy sum se, naan̰ ɔɔp mɛnd‑daaye ɔɔ kaaɗ kɛn se naan̰ ɓaarin̰ sik‑marta‑kaar‑sɔɔ naan̰ lee maakŋ Ɓee Raa ki daayum gɛn tɛɗn naabm Raa. Ɔɔ nɔɔrɔ katara naan̰ eem Raa ɔɔ iin̰ga num lee uun *siam. ");
INSERT INTO kyq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Num kaaɗ kɛn jaay kꞋɓaano ute goon Isa naan Raa ki se, naan̰ baag tɔɔm Raa ɔɔ taaɗ mɛtn taar goon se jeege tun paacn̰ kɛn iŋg aak kaak kaam debm kɛn utu Ꞌkɔɔɗn do jee kɛn Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kɛn naaɗe jaay tɛɗ aas nakŋ kɛn *Ko Taar kɛn Mɛljege Raa ɛɗo *Musa ki jaay aas se, naaɗe ɔk tɛrl ɓaa taa naaŋ Galile ki, maakŋ gɛgɛrɗe kɛn Nazarɛt ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Goono se teep ɓaa ute naanin̰a ɔɔ naan̰ mɛtɛkɛ ɔɔ jeel‑taara dɛna ɔɔ daayum Raa se tɛɗin̰ bɛɛn̰a. ");
INSERT INTO kyq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aanga ɓaara tak ɓo, ko Isa ute gaabin̰ se lee ɓaaɗo Jeruzalɛm ki gɛn tɛɗn *laa Paak gɛn Yaudge. ");
INSERT INTO kyq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kɛn Isa jaay ɓaarin̰ aas sik‑kaar‑di se, naaɗe ɔk ɓaansin̰ Jeruzalɛm ki gɛn tɛɗn Laaɗen kɛn naaɗe lee tɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kɛn ɓii Laa Paak jaay naŋ sum se, naaɗe ɔk tɛrl ɓaa Nazarɛt ki. Num goonɗe Isa se ɔɔp iŋg Jeruzalɛm ki, naɓo kon̰ ute bubin̰ se, gɔtn goonɗe ɔɔp se, naaɗe jeel te eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gɛn kon̰ te bubin̰ ki num ɔɔ kaaɗn naane, naan̰ utu ɓaaɗo ute jeeɗegen kꞋɓaaɗo ɓaa kalaŋ se. Kɛn naaɗe lee lɛk tɛc se jaay ɓo naaɗe ɓaa saap don̰ ki ɔɔ gɔtn se, naaɗe baagin̰ je gɔtn jee jeelɗege tu ɔɔ gɔtn taasɗege tu. ");
INSERT INTO kyq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kɛn naaɗe jaay je bini ɔŋin̰ ey se, naaɗe ɔk tɛrl ɓaan̰ je Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Naaɗe jen̰ ɓii mɔtɔ jaay ɓo ɓaa ɔŋin̰ maakŋ *Ɓee Raa ki iŋg kiŋg daan jee jeel tɔkŋ mɛtn Ko Taar Raage. Naan̰ iŋg booy booy taarɗe ɔɔ do taarɗege tu se naan̰ tɔnd mɛtɗe. ");
INSERT INTO kyq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jeegen paacn̰ iŋg uɗ bi do taar kɛn naan̰ tɛrlɗen se, naaɗe booy jeelin̰ se deel doɗe ɔɔ ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kɛn kon̰ge jaay ɔŋin̰ se, naaɗe aakin̰ se tap ɓo, ɔkɗen taaɗ eyo. Ɔɔ gɔtn se kon̰ ɗeekin̰ ɔɔ: «Goonuma, kɛse naai Ꞌtɛɗjen nakŋ‑kɔɔɓm ɗi bini? ꞋBooyo, maam ute bubi se, nirlje teecga kꞋlee kꞋjei jea.» ");
INSERT INTO kyq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Num gɔtn se Isa tɛrlɗen ɔɔ: «Naase Ꞌjemki gɛn ɗi? Naase Ꞌjeelki ey la kɛn maam mꞋɓaaɗo tap ɓo gɛn maakŋ ɓee Bubum se?» ");
INSERT INTO kyq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gaŋ taar kɛn naan̰ taaɗɗen se, naaɗe ɔŋ booy ɔk te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gɔtn se naan̰ iin̰ bɔɔy ɓaa ute naaɗe Nazarɛt ki ɔɔ daayum naan̰ lee took taarɗe. Anum nakgen deel paacn̰ ese se, kon̰ se ɔkin̰ maakin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ɔɔ Isa se teepe ɔɔ jeel‑taara ɓaa te naanin̰a. Kɛn Raa aakin̰ se, tɔɔlin̰ ɔɔ tɔɔl jeege tu kici. ");
INSERT INTO kyq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kaaɗ kɛn Tiber Sezar, Gaar magal iŋg *Rɔm ki, jaay ɔk ɓaara sik‑kaar‑mii maakŋ gaarin̰ ki se ɔɔ naan̰ kɛn se Pons Pilat ɓo magal gɛn taa naaŋ Jude ɔɔ *Ɛrɔd se gaar gɛn taa naaŋ Galile ɔɔ gɛnaan̰ Pilip se gaar gɛn taa naaŋ Iturɛ ute taa naaŋ Trakonitis ɔɔ Lisanias se gaar gɛn taa naaŋ Abilɛn. ");
INSERT INTO kyq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kaaɗ kɛn se Annan ute Kayip ɓo *magal jee tɛɗn sɛrkɛ Raage tu. Naan̰ kɛn se ɓo *Raa ɓaaɗo taaɗ Jan goon Zakari kɛn iŋg do kɔɗ‑ɓaar ki se. ");
INSERT INTO kyq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɔɔ Jan se ɓaa lee taa naaŋ ool magal kɛn Jordan ki se paac ɔɔ naan̰ taaɗ jeege tu ɔɔ: «ꞋTɛrlki maakse ɔɔ ɔn̰ jꞋasen *batizi ɔɔ Raa asen tɔɔl *kusin̰sege. ");
INSERT INTO kyq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aan gɔɔ kɛn Ezayi debm taaɗ taar teeco taar Raa ki raaŋo do dɔkin̰a maakŋ Kitapin̰ ki kɛn ɔɔ: KꞋbooy mind deba taaɗ makɔn̰ do kɔɗ‑ɓaar ki ɔɔ: ꞋƊaapki ɗoobm Mɛljege ɔɔ Ꞌtɛɗin̰sin̰ki jiga Ꞌtooɗn tal. ");
INSERT INTO kyq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gɔɔgen daan koge tu se, kꞋtuurumɗe naata ɔɔ koge ute kɔsge se kꞋtɔɔkɗe naatn. Ɔɔ ɗoobgen ɗug ɗug se kꞋtɛɗɗe Ꞌtɔɔjn̰ Ꞌtooɗn tal ɔɔ ɗoobm kɛn ɔk koge kɔrcɔm kɔrcɔm se kic lɛ kꞋɗaapɗe Ꞌtooɗn kɔlɔn̰. ");
INSERT INTO kyq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bin jaay jeege paac utu kaakŋ debm kɛn Raa utu aɗeno kɔlɔ jaay aɗen kaaj se.» ");
INSERT INTO kyq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gɔtn se jee dɛngen ɓaaɗo tɛɗn *batɛm gɔtn Jan ki se, naan̰ ɗeekɗen ɔɔ: «Aakumki tu wɔɔjgen ara! Naŋa jaay ɓo dɛjseno taa aki kaan̰ kɔtn maak‑taar gɛn Raa kɛn utu bɔɔy do jeege tu se? ");
INSERT INTO kyq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Naan ki se, Ꞌtɛɗki nakgen jiga kɛn Ꞌtaaɗn jeege tu ɔɔ naase se Ꞌtɛrlkiga maakse do Raa ki ɔɔ ɔn̰te Ꞌtaaɗki ɔɔki: naaje se lɛ kꞋgaan *Abraamge. ꞋBooyki mꞋasen ɗeeke: kogen ese se kɛn Raa je kic ɓo an̰ dɛlin̰ Ꞌtɛɗn gaange Abraam ki. ");
INSERT INTO kyq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ɓɛrɛ, alpasa se lɛ kꞋɗaarin̰ga mɛtn ko kaag ki. Ko kaaggen paacn̰ jaay ooj jig ey se, jꞋaɗen tɔgŋ tund naatn ɔɔ jꞋaɗen tɔɔcn̰ pooɗn.» ");
INSERT INTO kyq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gɔtn se jee dɛnge ɓaaɗo tɔnd mɛtn Jan ɔɔ: «Naaje tap ɓo kꞋtɛɗn roje ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jan tɛrlɗen ɔɔ: «Maakse ki se, debm ɔk kal di se uun ɛɗ kalaŋ se deb kɛn ɔk eyo ɔɔ debm ɔk nakŋ kɔsɔ kic ɓo nigin̰ ute debm kɛn ɔk eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gɔtn se, jee tɛɗn miirge kic ɓaaɗo taa jꞋaɗen batizi ɔɔ naaɗe tɔnd mɛtin̰ ɔɔ: «Debm dooy jeege, naaje tap ɓo kꞋtɛɗn roje ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naan̰ tɛrlɗen ɔɔ: «Miir kɛn kꞋtaaɗsen jꞋɔɔ aki kɔkŋ gɔtn jeege tu se, ɔn̰te Ꞌziiɗin̰ki ɗim do ki.» ");
INSERT INTO kyq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asgarge ɓaaɗo tɔnd mɛtin̰ ɔɔ: «Naaje kic ɓo kꞋtɛɗn roje jꞋɔɔ ɗio?» Jan tɛrlɗen ɔɔ: «Ɔn̰te Ꞌkuunki gursn nam ute taa tɔɔgɔ ɔɔ ɔn̰te Ꞌtɔlki taara do nam ki. Num iŋgki do gursn laapse ki sum.» ");
INSERT INTO kyq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aan gɔɔ kaaɗ kɛn se jeege iŋg aak kaak kaam nakŋ utu Ꞌtɛɗ se ɔɔ kɛn naaɗe jaay aak Jan se, gɔtn se naaɗe saap‑maakɗe ki ɔɔ: «Kɛse ɓo Ꞌtɛɗn *al‑Masi lɛ ɗaam?» ");
INSERT INTO kyq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jan tɛrlɗen naaɗe ki paac ɔɔ: «Maam se, mꞋasen *batizn ute maane, num gaŋ debm kɛn utu ɓaaɗo mɛtum ki se, naan̰ magal ciruma. Maam se kɔl saan̰ kic ɓo mꞋaas gɛn no tuutin̰ eyo. Debm ese se ɓo utu asen *batizn ute Nirl Salal ɔɔ ute pooɗo. ");
INSERT INTO kyq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ute gɛrt magalin̰ se naan̰ utu tuuy teen̰in̰a ɔɔ kɛn naan̰ jaay tuuy aasga num kaam teen̰in̰ se, naan̰ utu an̰ tɔsn kɔmb maakŋ giijin̰ ki, num tɛsin̰ se, naan̰ utu an̰ kɔmb maakŋ pooɗ kɛn ooy eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Do taarge tun naan̰ taaɗɗen se tɛr Jan dɛjɗenga ute taargen kuuy kic dɛna. Gɔtn ese se naan̰ taaɗɗen Labar Jiga se jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Num kɛn Gaar Ɛrɔd jaay ɔk Ɛrɔdiad mɛnd gɛnaan̰a ɔɔ do kɛn se tɛr tɛɗn nakgen kuuy kusin̰ kici, gɔtn se Jan taaɗin̰sin̰ tal. ");
INSERT INTO kyq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naɓo do *kusin̰ kɛn naan̰ lee tɛɗ se, tɛr do kɛn se naan̰ iij‑ɔk ɔl Jan daŋgay ki daala. ");
INSERT INTO kyq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kɛn jeege paac jaay kꞋbatizɗe aas se, Isa kic ɓo kꞋbatizin̰a. Kɛn naan̰ eem keem Raa se, gɔtn se maakŋ raa ɔɔɗ waŋ. ");
INSERT INTO kyq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Gɔtn se, *Nirl Salal se tec aan gɔɔ dɛɛrɛ ɓaaɗo bɔɔy do Isa ki. Gɔtn se kꞋbooy mind deba taaɗ maakŋ raa ki ɔɔ: «Naai se ꞋGoonuma. Maam ɓo mꞋbɛɛr mꞋɔɔɗio ute maak‑raapuma.» ");
INSERT INTO kyq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kaaɗ kɛn Isa baagŋ naabin̰ se, naan̰ ɔk ɓaara ɓaa ɓaa si‑mɔtɔ. Jeege se saap ɔɔ naan̰ goon Yusup, Yusup se goon Ɛli, ");
INSERT INTO kyq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ɛli se goon Matat, Matat se goon Lɛbi, Lɛbi se goon Mɛlki, Mɛlki se goon Yanay, Yanay se goon Yusup, ");
INSERT INTO kyq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup se goon Matatias, Matatias se goon Amɔs, Amɔs se goon Naum, Naum se goon Ɛsli, Ɛsli se goon Nagay, ");
INSERT INTO kyq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay se goon Maat, Maat se goon Matatias, Matatias se goon Semeyin, Semeyin se goon Yɔsɛk, Yɔsɛk se goon Yɔda, ");
INSERT INTO kyq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yɔda se goon Yɔanan, Yɔanan se goon Rɛsa, Rɛsa se goon Zorobabɛl, Zorobabɛl se goon Salatiɛl, Salatiɛl se goon Neri, ");
INSERT INTO kyq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri se goon Mɛlki, Mɛlki se goon Addi, Addi se goon Kɔsam, Kɔsam se goon Ɛlmadam, Ɛlmadam se goon Ɛr, ");
INSERT INTO kyq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛr se goon Jɛzu, Jɛzu se goon Ɛliɛzɛr, Ɛliɛzɛr se goon Yɔrim, Yɔrim se goon Matat, Matat se goon Lɛbi, ");
INSERT INTO kyq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛbi se goon Simɛon, Simɛon se goon Juda, Juda se goon Yusup, Yusup se goon Yɔnam, Yɔnam se goon Ɛliakim, ");
INSERT INTO kyq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliakim se goon Mɛlɛa, Mɛlɛa se goon Mɛnna, Mɛnna se goon Matata, Matata se goon Natan, Natan se goon *Daud, ");
INSERT INTO kyq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud se goon Jɛsɛ, Jɛsɛ se goon Obed, Obed se goon Booz, Booz se goon Sala, Sala se goon Naason, ");
INSERT INTO kyq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason se goon Aminadab, Aminadab se goon Admin, Admin se goon Arni, Arni se goon Ɛzrɔm, Ɛzrɔm se goon Pɛrɛz, Pɛrɛz se goon Juda, ");
INSERT INTO kyq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda se goon *Yakub, Yakub se goon Isak, Isak se goon *Abraam, Abraam se goon Tɛra, Tɛra se goon Naɔr, ");
INSERT INTO kyq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naɔr se goon Sɛruk, Sɛruk se goon Ragau, Ragau se goon Pɛlɛg, Pɛlɛg se goon Ɛbɛr, Ɛbɛr se goon Sala, ");
INSERT INTO kyq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala se goon Kaynam, Kaynam se goon Arpakzad, Arpakzad se goon Sɛm, Sɛm se goon Noe, Noe se goon Lɛmɛk, ");
INSERT INTO kyq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lɛmɛk se goon Matuzala, Matuzala se goon Ɛnɔk, Ɛnɔk se goon Yɛrɛd, Yɛrɛd se goon Maalalɛɛl, Maalalɛɛl se goon Kaynam, ");
INSERT INTO kyq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam se goon Ɛnɔs, Ɛnɔs se goon Sɛt, Sɛt se goon Adum, Adum se goon Raa. ");
INSERT INTO kyq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gɔtn se Isa ɗooc te *Nirl Salal se, iin̰o taa ool magal Jordan ki ɔɔ Nirl Salal se tɔɔɗ ɔlin̰ do kɔɗ‑ɓaar ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Maakŋ ɓiige tun si‑sɔɔ se, Bubm sitange ɓaaɗo naamin̰a. Nɔɔrɔ katara se Isa ɔs te ɗim eyo ɔɔ kɛn ɓiigen si‑sɔɔ jaay aas se, naan̰ ɓo tɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gɔtn ese se, Bubm sitange ɗeekin̰ ɔɔ: «Kɛn naai ꞋGoon *Raa ɗeer num, Ꞌtaaɗ ko ki se ai dɛl nakŋ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ɔɔ Isa tɛrlin̰ ɔɔ: «Taar se Kitap taaɗga taaɗa ɔɔ: Kɛn tɛɗ debkilimi iŋg se kɔsɔ kalin̰ ki sum eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tɛr Bubm sitange tɔɔɗ ɔlin̰ gɔtn raan. Gɔtn ese sum ɓo naan̰ naar taaɗin̰ taa naaŋ gaarin̰gen do naaŋ ki paac se. ");
INSERT INTO kyq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ɔɔ Bubm sitange ɗeekin̰ ɔɔ: «Maam mꞋai kɛɗn tɔɔgɔ paac ute nakgen aak bɛɛ kɛn do naaŋ ki kaam jii, taa nakgen se jꞋɛɗumsin̰ga kɛɗ maam ki ɔɔ maam mꞋan̰ kɛɗn deb kɛn maakum jen̰a. ");
INSERT INTO kyq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ɔɔ kɛn naai jaay Ꞌɓaaɗo ɛrgga naanum ki ɔɔ Ꞌdaanumga num, nakgen se paac maam mꞋaisin̰ kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isa tɛrlin̰ ɔɔ: «Taa Kitap taaɗga taaɗ ɔɔ: Mɛli Raa kalaŋ tak se ɓo naai Ꞌkɛrgŋ naanin̰ ki ɔɔ an̰ Ꞌtɛɗn naabin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tɛr Bubm sitange tɔɔɗ ɓaansin̰ maakŋ gɛgɛr kɛn Jeruzalɛm ki ɔɔ ɓaa uun ɔlin̰ do *Ɓee Raa ki raan lɛŋ lɛŋ ɔɔ ɗeekin̰ ɔɔ: «Kɛn naai ꞋGoon Raa ɗeer num, do ɓee ki ara se iin̰ aal naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Taa Kitap se taaɗga taaɗ ɔɔ: Raa Ꞌkund Ꞌkulu kɔɗin̰ge tu ai bɔɔbɔ ");
INSERT INTO kyq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ɔɔ naaɗe ai caapm kɔkŋ jiɗege tu taa jɛige se Ꞌkɔŋ rɔɔkŋ ro ko kɛn gam eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isa tɛrlin̰ ɔɔ: «Kitap taaɗga taaɗ ɔɔ: Ɓɛrɛ, naai se Ꞌkɔŋ Ꞌnaam Mɛli Raa eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɛn Bubm sitange naamin̰ kaam ara kaam ara jaay aas se, naan̰ iin̰ ɔn̰in̰a ɔɔ booy bini aan kaaɗ kɛn Raa mala ɔndin̰ se jaayo. ");
INSERT INTO kyq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gɔtn se Isa ɗooc te tɔɔgŋ *Nirl Salal, ɔk tɛrl ɓaa taa naaŋ Galile ki ɔɔ nookin̰ eem dɔɔɗ taa naaŋ gɔtn ese paac. ");
INSERT INTO kyq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naan̰ lee dooyɗe maakŋ *ɓeege tun kɛn Yaudge lee tus maak ki ɔɔ jeege paac tɔɔmin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Isa tɛrl maakŋ gɛgɛr kɛn Nazarɛt gɔtn naan̰ teepmno ro ki. Kɛn *ɓii sebit jaay aanga num, aan gɔɔ daayum naan̰ lee ɓaa maakŋ *ɓee kɛn Yaudge lee tusn maak ki gɛn keem Raa ɗey se, naan̰ ɛnd maak ki ɔɔ ɓii kɛn se ɓo, naan̰ iin̰ ɗaara gɛn dooy Kitap naan jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gɔtn se jꞋuun jꞋɛɗin̰ Kitapm gɛn debm taaɗ taar teeco taar Raa ki kɛn kꞋdaŋin̰ Ezayi. Naan̰ wɔrgin̰a, ɔɔ ɔŋ gɔtn kɛn kꞋraaŋin̰ jꞋɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nirl gɛn Mɛljege se, utu maakum ki, taa naan̰ bɛɛr ɔɔɗumo gɛn taaɗn Labar Jiga se jee daayge tu. Naan̰ ɔlumo taa mꞋtaaɗn ɓulge tu se jꞋutu jꞋaɗen kɔɔɗn doɗe ɔɔ jee kaam‑tɔɔkge se utu Ꞌkaaka ɔɔ jee kɛn jꞋɔɔɗɗe yɛɛɓɗe cɛrɛ se, jꞋutu jꞋaɗen kɔɔɗn doɗe, ");
INSERT INTO kyq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ɔɔ maam mꞋɓaaɗo se mꞋasen taaɗn ɓaar kɛn Raa tɛɗn bɛɛn̰ jeege tu kici. ");
INSERT INTO kyq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kɛn naan̰ jaay dooy Kitap aas se, naan̰ teelin̰a, ɔɔ ɛɗin̰ gaab kɛn tɛɗn naaba gɔtn ese se ɔɔ naan̰ tɛrl iŋg gɔtin̰ ki ɔɔ jee iŋg maakŋ ɓee kɛn gɔtn ese paac ɔndin̰ kaama. ");
INSERT INTO kyq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gɔtn se naan̰ baagɗen taaɗa ɔɔ: «ꞋBooyki, taar Kitapm kɛn naase Ꞌbooyin̰ki jaaki se, aanga ɗoobin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Gɔtn se jeegen paacn̰ iŋg booy taarin̰ se taaɗ taargen jiga ron̰ ki ɔɔ taarin̰ nijim kɛn naan̰ taaɗɗen se, ɔkɗen taaɗ eyo. Naaɗe ɗeek ɔɔ: «Kɛse tap ɓo goon Yusup ey la?» ");
INSERT INTO kyq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Gɔtn se Isa ɗeekɗen ɔɔ: «Ɗeere, kaan̰ kaa taar kɛn jeege lee taaɗ se utu amsin̰ki tɛɗn dom ki kɛn taaɗ ɔɔ: ‹Kɛn naai jaay daptor num, aaj roi mala.› Bin se naase kic utu amki taaɗn ɔɔ: nakŋ naaje kꞋbooy kɛn naai Ꞌtɛɗo maakŋ gɛgɛr kɛn Kaparnayum ki se, ɓɔrse naai Ꞌtɛɗin̰ maakŋ naaŋi ki ara kici.» ");
INSERT INTO kyq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tɛr naan̰ taaɗɗen ɔɔ: «Ɗeere, Ꞌbooyki mꞋasen taaɗa: ɓii kalaŋ debm taaɗ taar teeco taar Raa ki gam jꞋɔkin̰ te ɔɔn̰ maakŋ naaŋin̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ꞋBooyki bɛɛ mꞋasen taaɗa: do dɔkin̰ do *Ɛli ki se, *Israɛl ɔk mɛnd‑daayge dɛna ɔɔ kaaɗ kɛn se ɓaara mɔtɔ ute laapa mɛcɛ se, maane baate keeɗe ɔɔ ɓo tɔɔl tɛɗ daama maakŋ naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Num gaŋ Ɛli se, Raa ɔlin̰ te gɔtn mɛnd‑daay kɛn gam kɛn maakŋ taa naaŋ Israɛl ki se eyo; num ɔlin̰ gɔtn mɛnd‑daay kɛn iŋg maakŋ gɛgɛr kɛn kꞋdaŋin̰ Sarepta kɛn taa naaŋ Sidɔŋ ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Do dɔkin̰ do Ɛlizɛ ki kɛn debm taaɗ taar teeco taar Raa ki se kic ɓo, Israɛlge se ɔk jee bikiɗge dɛna. Naɓo maakɗe ki paac se, deb kalaŋ kic ɓo Ɛlizɛ ɛɗin̰ te lapi eyo; num gaŋ ɛɗ lapi ɓo gaab ki kalaŋ kɛn kꞋdaŋin̰ Naaman kɛn kɔɗ Siri.» ");
INSERT INTO kyq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kɛn jee maakŋ ɓee kɛn Yaudge lee tusn maak ki jaay booy taar kɛn naan̰ taaɗɗen se, naaɗe maakɗe taarɗe don̰ ki pirin̰. ");
INSERT INTO kyq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aan gɔɔ gɛgɛr se lɛ do ko ki se, naaɗe iin̰ iij‑ɔkin̰ teecn̰sin̰ naatn ɔɔ ɓaansin̰ taa an̰ Ꞌkɔtn kɔl ziri ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Num gɔtn se naan̰ iik uj jiɗe ki ɔɔ but aal daanɗe ki se ɔɔ uun ɗoobin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gɔtn se Isa bɔɔy ɓaa maakŋ gɛgɛr kɛn Kaparnayum kɛn taa naaŋ Galile ki. *Ɓii sebit jaay aan se, naan̰ ɓaa dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jeegen booy taar kɛn naan̰ dooyɗe se ɔkɗen taaɗ eyo, taa naan̰ dooyɗen ute tɔɔgin̰ mala. ");
INSERT INTO kyq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jee iŋg maakŋ *ɓee kɛn Yaudge lee tusn maak ki gɔtn ese se, gaaba kalaŋ se ɔk kɔɔn̰ sitan. Kɛn naan̰ aak Isa se ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Waay! Naai Isan Nazarɛt. Naai tap ɓo naaje jꞋɔŋ ɗi ute naai? Naai se Ꞌɓaaɗo gɛn kutje! Maam se mꞋjeeli, naai se Debm *Salal kɛn Raa ɓo ɔlio.» ");
INSERT INTO kyq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Gaŋ Isa aacin̰ kaama ɔɔ: «ꞋƊoa! ꞋTeec naatn ro gaab kɛn se!» Gɔtn se gaabm se ooc daan jeege tu ɔɔ sitan se teec naatn ron̰ ki ɔɔ tɛɗin̰ te ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jee paacn̰ aak nakŋ se, ɓeer ɔkɗe ɔɔ lee taaɗ ute naapa ɔɔ: «Kɛse taar ɔɔ ɗi ɓo bini! Gaabm se ute tɔɔgin̰ se, naan̰ taaɗ sitange tu ɔɔ naaɗe teec aan̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gɔtn se nookin̰ eem dɔɔɗ taa naaŋ gɔtn ese paac. ");
INSERT INTO kyq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kɛn Isa jaay teeco maakŋ *ɓee kɛn Yaudge lee tusn maak ki se, naan̰ ɓaa ɓee Simon ki ɔɔ ɔŋ moomin̰ mɛnda se ron̰ ɔŋg kɛɗɛk kɛɗɛk. Gɔtn ese naaɗe tɔnd mɛtn Isa ɔɔ n̰Ꞌsaapm don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isa ɓaaɗo no don̰ ki aac kaama kɔɔn̰ ki ɔɔ ron̰ ɔŋg kɛɗɛk se tɛrɛc urlu. Gɔtn ese sum ɓo mɛnda se naar iin̰ ɗaara ɔɔ baagɗen tɛɗn kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kaaɗ kɛn jaay kaaɗa ɓaa ɓaa kooco se, jeege dɛna ɓaano ute jee kɔɔn̰ge napar napar gɔtn Isa ki ɔɔ naŋa naŋa kic ɓo naan̰ ɔndin̰ jin̰ don̰ ki, ɔɔ jee kɔɔn̰gen se paac ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gɔtn ese kic sitange dɛna teec naatn ro jeege tu ɔɔ kɛn naaɗe teec teec se tɔɔɗ tɔɔy makɔn̰ ɔɔ: «Naai se, ꞋGoon Raa.» Gaŋ Isa aacɗen kaama ɔɔ jꞋɔn̰te taaɗa, taa naaɗe se jeelin̰a naan̰ ɓo *al‑Masi. ");
INSERT INTO kyq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tanɔɔrin̰‑nɔɔrin̰ se, Isa iin̰ teec ɓaa do kɔɗ‑ɓaar ki gɔtɔ kaam kalaŋ. Gɔtn se jee dɛnge se iin̰ taa jen̰a ɔɔ kɛn naaɗe jaay ɔŋin̰ se, jee se je naan̰ aɗe kɔn̰ɔ eyo, num Ꞌkɔɔpm kiŋg ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gaŋ Isa tɛrlɗen ɔɔ: «Bɛɛki se, mꞋɓaa taaɗn Labar Jigan gɛn Gaar Raa se, maakŋ gɛgɛrge tun kuuy kici. Taa naan̰ se ɓo Raa ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Isa lee taaɗ taar Raa maakŋ *ɓeege tun kɛn Yaudge lee tusn maak ki kɛn taa naaŋ Jude ki se paac. ");
INSERT INTO kyq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɓii kalaŋ, Isa ɗaar ɗaar taa baar kɛn kꞋdaŋin̰ Genezarɛt se ɔɔ gɔtn se jee dɛnge ɓaaɗo deebin̰ bat gɛn booy taar *Raa. ");
INSERT INTO kyq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Gɔtn se Isa aak markabge dio ɗaar ɗaar taa baar ki ɔɔ jee toocn̰ kɛn̰jgen bɔɔyo maak ki se ɗaar tug tug gɛndɗege. ");
INSERT INTO kyq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gɔtn se Isa ook maakŋ markab kɛn kalaŋ ɔɔ markabm ese se gɛn Simon. Naan̰ taaɗ Simon ki ɔɔ: «Iik Ꞌɓaa naan ki cɔkɔ.» Gɔtn se Isa iŋg maakŋ markab ki ɔɔ baag dooy jee dɛnge. ");
INSERT INTO kyq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kɛn naan̰ jaay taaɗ naŋ taarin̰ se, naan̰ ɗeek Simon ki ɔɔ: «Iik Ꞌɓaa gɔtn kɛn maanin̰ jɛrlɛ, ute jeeige se, Ꞌtuunki gɛndsege maan gɛn toocn̰ kɛn̰jge.» ");
INSERT INTO kyq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon tɛrlin̰ ɔɔ: «Debm dooy jeege, daan nɔɔr ki ute magalin̰ se, naaje kꞋdabarga dɛna naɓo jꞋɔŋ te ɗim eyo. Num gaŋ do taari ki se, gɛndge se maam mꞋaɗen tuun maan.» ");
INSERT INTO kyq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kɛn naaɗe jaay tuun gɛndɗege maan se, naaɗe uuno kɛn̰jge dɛna; bini gɛndɗege kic ɓo ɓaa ɓaa nɛɛpɛ! ");
INSERT INTO kyq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Naaɗe daŋ mɛɗɗegen maakŋ markab kɛn kuuy se te jiɗe taa aɗe ɓaa num, aɗen noogo. Mɛɗɗege jaay ɓaaɗo ɔŋɗe se, markabɗegen di se paac naaɗe ɗoocin̰ tal tal ute kɛn̰jge, bini ɓaa ɓaa duubm maan. ");
INSERT INTO kyq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kɛn Simon Piɛr jaay aak nakŋ ese se, naan̰ ɓaaɗo ooc mɛtn jɛ Isa ki ɗeekin̰ ɔɔ: «Mɛluma, iik naatn cɛɛm ki; taa maam se mꞋdebm *kusin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Taa kɛn̰jgen dɛn kɛn naaɗe uuno se, Piɛr ute mɛɗin̰ge se ɓeere ɓaa ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mɛɗin̰gen Jak ute Jan kɛn gaan Zebedege se aak se, ɓeere ɔkɗe kici. Gɔtn se Isa ɗeek Simon ki ɔɔ: «Ɔn̰te ɓeere! Naan ki se, naai Ꞌɓaa je jikilimge ɓo anɗeno ɓaa ɗoobm Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Markabɗege se naaɗe tiik ɓaano taa jɛŋ ki ɔɔ gɔtn ese sum ɓo, naaɗe rɛsn te nakɗege paac ɔɔ daanin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɓii kalaŋ Isa iin̰ ɓaa maakŋ gɛgɛr kɛn kalaŋ ɔɔ gɔtn se debm bikiɗi ɓaaɗo ɔŋin̰a. Gaabm se ron̰ paac taal aace. Kɛn naan̰ aak Isa se, naan̰ ooc mɛtn jɛn̰ ki ɔɔ tɔnd mɛtin̰ ɔɔ: «Mɛlje, kɛn naai Ꞌje num, ɛɗum lapia taa rom se ɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰.» ");
INSERT INTO kyq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isa ɔl jin̰ utin̰a ɔɔ ɗeekin̰ ɔɔ: «Yɛɛ, maam mꞋjea, ɔn̰ roi ɗaapm Ꞌtooɗn kɔlɔn̰ kɔlɔn̰!» Gɔtn se sum ɓo, gaabm se kɔɔn̰in̰ ɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gɔtn se Isa ɗeekin̰ ɔɔ: «Ɔn̰te ɓaa Ꞌtaaɗn nam ki. Taa naai ɔŋga lapi se Ꞌɓaa Ꞌtaaɗ roi *debm tɛɗn sɛrkɛ Raa ki se ɔɔ Ꞌɓaa ɛɗ *sɛrkɛ Raa ki aan gɔɔ kɛn *Musa taaɗin̰o maakŋ Kitap ki, taa naai se roi ɗaapga tooɗga kɔlɔn̰ kɔlɔn̰ se. Bin ɓo, jeege paac Ꞌjeele, naai se ɔŋga lapia.» ");
INSERT INTO kyq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gɔtn se jeege baag kɔɔsn maanin̰ gɔtɔ ɓaa se paac ɔɔ jeege dɛna lee tusu gɛn booy taarin̰a ɔɔ jee kɔɔn̰ge se lɛ ɓaaɗo se gɛn je lapia roɗe. ");
INSERT INTO kyq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gaŋ Isa se teec ɓaa do kɔɗ‑ɓaar ki kalin̰ ki gɛn tɔnd mɛtn Raa. ");
INSERT INTO kyq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɓii kalaŋ Isa dooy dooy jeege ɔɔ maakŋ jeege tun naan̰ dooyɗe dooy se ɔk *Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage. Naaɗe se iin̰o maakŋ naaŋge tun taa naaŋ Galile ki ute kɛngen taa naaŋ Jude ki ɔɔ ute kɛngen iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki. Gɔtn se Isa ute tɔɔgŋ Mɛljege se, ɛɗ lapi jee kɔɔn̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Gɔtn ese sum ɓo jeege uuno debm kꞋruŋguyu do nakŋ tooɗin̰ ki. Kɛn naaɗe aan se, naaɗe je ɗoobm an kɛnd kɔŋ Isa. ");
INSERT INTO kyq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naɓo taa jeege dɛn dɛn se naaɗe ɔŋ te ɗoobm an kɛnd kɔŋ Isa eyo. Taa naan̰ se ɓo naaɗe uun ookŋsin̰ do ɓee ki raan ɔɔ ɔɔɗ taa bɔlɔ ɔɔ naaɗe bɔɔyin̰o do nakŋ tooɗin̰ ki naan Isa ki daan jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɛn Isa jaay aak naaɗe aal maakɗe don̰ ki se, ɗeek ɔɔ: «Gaaba, *kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn.» ");
INSERT INTO kyq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kɛn jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizige jaay booy se, naaɗe baag naajn̰ te naapa ute mind naaŋ ki ɔɔ: «Naan̰ se tap ɓo naŋa jaay naaj Raa bin se? Kɛn Ꞌkɔŋ tɔɔl kusin̰ deba se, Raa kalin̰ ki sum ey la?» ");
INSERT INTO kyq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aan gɔɔ Isa jeel maak‑saapɗe se, naan̰ tɛrlɗen ɔɔ: «Taa ɗi jaay naase Ꞌtaaɗki ute maakse bin se? ");
INSERT INTO kyq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gɛn naase ki num, kɛn gay ɓo ɔɔn̰ ciri, kɛn mꞋɗeekŋ mꞋɔɔ: ‹Kusin̰ige se, maam mꞋtɔɔlisin̰ga naatn› lɔɓu mꞋɗeekŋ mꞋɔɔ: ‹Iin̰i ɔɔ Ꞌlee› se lɛ? ");
INSERT INTO kyq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bin num, naase aki Ꞌjeele maam *mꞋGoon Deba se mꞋɔk tɔɔgɔ gɛn tɔɔl kusin̰ jeege.» Gɔtn se, Isa ɗeek debm kꞋruŋguy ki ɔɔ: «MꞋɗeeki mꞋɔɔ: iin̰i, uun nakŋ tooɗi se ɔɔ Ꞌɓaa ɓei ki.» ");
INSERT INTO kyq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Gɔtn ese se sum ɓo, gaabm se, iin̰ ɗaara naan jeege tu, uun nakŋ tooɗin̰a ɔɔ ɓaa ɓeen̰ ki. Kɛn naan̰ ɓaa ɓaa se naan̰ tɔɔm Raa. ");
INSERT INTO kyq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jee gɔtn ese paac nakŋ se deel doɗe ɔɔ naaɗe tɔɔm Raa kici. Gɔtn se naaɗe ɓeere ɔkɗe se, taaɗ ute naapa ɔɔ: «Nakage, jaaki se, jꞋaakkiga nakgen kɛn deel do aak eyo!» ");
INSERT INTO kyq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kɛn nakgen se jaay deel se, Isa teec teec se aak *debm tɔkŋ miiri ron̰ Lɛbi iŋg kiŋg gɔtn tɛɗn naabin̰ ki. Naan̰ ɗeekin̰ ɔɔ: «Iin̰i Ꞌdaanuma!» ");
INSERT INTO kyq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gɔtn se sum ɓo Lɛbi iin̰i, ɔn̰ nakin̰ge paac ɔɔ daan Isa. ");
INSERT INTO kyq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gɔtn se Lɛbi tɛɗ kɔsɔ dɛna ɔɔ daŋ Isa ɓeen̰ ki gɛn ɓaa kɔsɔ. Ɔɔ jeege dɛna iŋg ɔs te naaɗe ɔɔ maakɗe ki se *jee tɔkŋ miirge ɔɔ jee kuuy se kici ute te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Gɔtn se, *Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se jaay aakɗe se mooy naaŋ ki dir dir ɔɔ taaɗ jeege tun mɛtn Isa ki se ɔɔ: «Gɛn ɗi jaay naase ɔski ɔɔ aayki ute jee tɔkŋ miirge ɔɔ jee *kusin̰ge se?» ");
INSERT INTO kyq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isa tɛrlɗen ɔɔ: «Jee roɗe kiji se, naaɗe je daptor eyo, num kɛn je daptor se, jee kɔɔn̰ge. ");
INSERT INTO kyq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Maam mꞋɓaaɗo se gɛn daŋ jee kɛn saap ɔɔ naaɗe aak bɛɛ naan Raa ki se eyo, num maam mꞋɓaaɗo se gɛn jee jeel roɗe ki naaɗe jee kusin̰ge, taa Ꞌtɛrl maakɗe do Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naan̰ kɛn se jeege ɓaaɗo taaɗ Isa ki ɔɔ: «Jee mɛtn Jan‑Batist ki ute jee mɛtn *Parizige se tɛɗga num lee tuun siam ɔɔ tɔnd mɛtn Raa. Num jee mɛtn naai ki se ɔsɔ ɔɔ aaye.» ");
INSERT INTO kyq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isa tɛrlɗen ɔɔ: «Jeegen ɓaaɗo kɔkŋ mɛnda jaay gaabm mɛnda utu te naaɗe se, kaaɗ kɛn se naaɗe Ꞌkɔŋ kuun siam la? Mɛt ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Num gaŋ ɓii kalaŋ kaaɗin̰ utu kaana gaabm mɛnda se jꞋutu jꞋan̰ kɔɔɗn naata ɔɔ naan̰ kɛn se jaay ɓo, mɛɗin̰ge se lee tuun siam gɛn tɔnd mɛtn Raa.» ");
INSERT INTO kyq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Isa taaɗɗen ute kaal naagŋ taara daala ɔɔ: «Nam ɔk kala koono nɛɛpga nɛɛp se, aɗe kɔŋ nɛɛpm taar kal kiji jaay an̰ kal do ki eyo; ey num taa kal kijin kɛn kꞋnɛɛpo se cɛrɛ sum, ɔɔ kɛn jꞋaalin̰ga kic num, naaɗe se kɔŋ tum eyo. ");
INSERT INTO kyq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɔɔ tɔtn koojn̰ bin̰ utu iin̰ kiin̰ se, jꞋɔmbin̰ maakŋ k‑lɛɛtɛrge tun koono eyo; ey num tɔtn koojn̰ bin̰ se, an dɔɔbm ute k‑lɛɛtɛrge se naatn. Ɔɔ tɔtn koojn̰ bin̰ se lɛ Ꞌkɔɔy naaŋ ki cɛrɛ ɔɔ k‑lɛɛtɛrge se lɛ, dɔɔbm tujn̰ kici. ");
INSERT INTO kyq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Num gaŋ bɛɛki num, tɔtn kaam ki se jꞋan̰ kɔmb maakŋ k‑lɛɛtɛrge tun kiji kici. ");
INSERT INTO kyq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɔɔ debm aayga kaay tɔtn cooɗi tɔɔlum se lɛ, tɔtn kaam ki se, ɓon̰ tɔɔlin̰ ey sum. Taa naan̰ ɗeek ɔɔ: kɛn nijim cir paac se tɔtn kɛn cooɗi tɔɔlum se.» ");
INSERT INTO kyq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ɓii kalaŋ ɓii sebit ki se, Isa ute jee mɛtin̰ ki deel maakŋ gɔtn gɛm ki. Gɔtn se jee mɛtin̰ ki tɛrɛc do gɛmge ɔɔ ɔɔɗ kaamin̰ maakŋ jiɗe ki ɔɔ taan̰e. ");
INSERT INTO kyq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Num *Parizigen kandum gɔtn ese taaɗɗen ɔɔ: «Gɛn ɗi jaay naase Ꞌtɛɗki nakŋ kɛn jꞋund te kulu eyo gɛn tɛɗ ɓii sebit ki se?» ");
INSERT INTO kyq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isa tɛrlɗen ɔɔ: «Naase Ꞌdooyin̰ki te ey la, nakŋ kɛn *Daud tɛɗ ute jeen̰ge kaaɗ kɛn naaɗe ɓo tɔɔlɗe se? ");
INSERT INTO kyq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Naan̰ ɛndo maakŋ *kɔrɔr gɛn *Raa ki, ɔɔ tɔs mappan jꞋɛɗin̰ga kɛɗ *sɛrkɛ Raa ki, ɔso ɔɔ ɛɗo jeen̰ge tun mɛtin̰ ki kici. Ey num, kɛn ɔk ɗoobm Ꞌkɔsn se jee tɛɗn sɛrkge Raa ki kalɗe ki sum.» ");
INSERT INTO kyq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ɔɔ tɛr Isa ɗeekɗen ɔɔ: «*Goon Deba se lɛ, naan̰ ɓo Mɛl gɛn ɓii sebit.» ");
INSERT INTO kyq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kɛn aan ɓii sebit kɛn kuuy se, Isa ɓaa ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki se ɔɔ dooy jeege. Gɔtn ese, naan̰ ɔŋ gaaba kalaŋ ji daamin̰ ooyga kooyo. ");
INSERT INTO kyq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizige se ɔnd kaama Isa ki tak taa naaɗe je an̰ kaaka kɛn n̰Ꞌkɛɗn lapia gaab kɛn se ɓii sebit ki num, bin se naaɗe an̰ kɔkŋ mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aan gɔɔ Isa jeel saapm‑maakɗe ki se, naan̰ ɗeek gaab kɛn jin̰ ooyga kooy se ɔɔ: «Iin̰i Ꞌɗaar naan jeege tu.» Ɔɔ gaabm se iin̰ ɗaara. ");
INSERT INTO kyq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gɔtn se Isa taaɗɗen ɔɔ: «Maam mꞋje tɔnd mɛtse: ɓii sebit ki se, jꞋundsenga kulu gɛn tɛɗn bɛɛ lɔɓu gɛn tɛɗn *kusin̰ lɛ? Ɔɔ ɔŋ deba jaay ɗim an don̰ ki num, an̰ kaaj lɔɓu an̰ kɔn̰in̰ naan̰ Ꞌkut lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Gɔtn se Isa uun kaamin̰ aak dɔɔɗɗe paac ɔɔ ɗeek gaabm kɛn jin̰ ooyga kooy se ɔɔ: «ꞋSɛɛj jii!» Ɔɔ gaabm se sɛɛj jin̰a ɔɔ gɔtn ese sum ɓo jin̰ ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kɛn Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage jaay aak nakŋ se, maakɗe taarɗe don̰ ki pirin̰ ɔɔ taaɗ ute naapa do nak kɛn naaɗe utu Ꞌtɛɗn do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kaaɗ kɛn se sum ɓo, ɓii kalaŋ Isa ɓaa ook do ko ki gɛn keem Raa ɔɔ maakŋ nɔɔr kɛn te magalin̰ se, naan̰ eem Raa. ");
INSERT INTO kyq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kɛn gɔtɔ jaay iip se, naan̰ daŋ jee mɛtin̰ ki ɔɔ maakɗe ki se, naan̰ bɛɛr tɔɔɗ jeege sik‑kaar‑dio kɛn naan̰ daŋɗe jee kaan̰ naabin̰ge. Kɛse ɓo ro jee se: ");
INSERT INTO kyq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon se, naan̰ daŋin̰ te ro Piɛr, Andre se gɛnaan̰a, Jak, Jan, Pilip, Bartelemi, ");
INSERT INTO kyq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Tɔma, Jak goon Alpe, Simon debm je kujn̰ naaŋin̰a, ");
INSERT INTO kyq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud goon Jak ɔɔ Judas Iskariɔt, naan̰ ɓo debm utu kutn Isa se. ");
INSERT INTO kyq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kɛn Isa jaay bɔɔy do ko ki ute jee mɛtin̰ kɛn sik‑kaar‑di se naan̰ ɔŋ gɔtn tooɗ tal jaay naan̰ ɗaara ɔɔ gɔtn se naan̰ ɔŋ jee dɛn mɛtin̰ ki ute jeege dɔɔlɔ dɛna iin̰o taa naaŋ Jude ki, kɛngen iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki, ɔɔ kɛngen kuuy se iin̰o taa naaŋ Tir ute gɛn Sidɔŋ ki kɛn iŋg maakŋ gɛgɛrge tun taa baar ki. ");
INSERT INTO kyq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Naaɗe ɓaaɗo se gɛn booy taarin̰a ɔɔ gɛn je lapi roɗe, ɔɔ jee ɔk kɔɔn̰ sitangen kɛn lee dabarɗe se kic ɓo ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jee dɛngen tus paac se naŋa naŋa kic ɓo je kutn ro Isa taa debm utga ron̰ num, tɔɔg Isan Ꞌteec ron̰ ki se, ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gɔtn se Isa uun kaamin̰a aak jee mɛtin̰ ki ɔɔ taaɗɗen ɔɔ: «Maak‑raapo naase jee daayge tu, taa *maakŋ Gaar Raa se naase ki. ");
INSERT INTO kyq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Maak‑raapo naase jee ɓo tɔɔlsen ɓɔrse se, taa naase utu aki kɔsn dɛrɛŋ te maraad se! Maak‑raapo naase kɛn ɓɔrse maakŋ kaa‑maan ki, taa naase se utu aki kooy koogo. ");
INSERT INTO kyq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Maak‑raapo naase kɛn jeege jese eyo, ɔɔɗ undse naatn, naajse ɔɔ tɔlsen taar jig eyo dose ki, taa naase aalki maakse do *Goon Deb ki. ");
INSERT INTO kyq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Kɛn nakgen se jaay aanga dose ki num, ɓii kɛn se ɔn̰ki maakse Ꞌraap sakan̰ ɔɔ Ꞌdaamki te maak‑raapo! Taa maakŋ raa ki se, Raa utu asen kɔgŋ bɛɗse dɛn aak eyo. Bin ɓo ɓugɗegen do dɔkin̰ se lee dabaro jee taaɗ taar teeco taar Raa ki se bin kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Num gaŋ asen kɔɔn̰ naasen jee nak dɛnge taa ɓɔrse naase ɔŋkiga dose. ");
INSERT INTO kyq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Asen kɔɔn̰ naasen kɛn ɓɔrse ɗim daaysen ey se, taa naase ɓo utu asen tɔɔlɔ. Asen kɔɔn̰ naasen jee iŋg Ꞌtooyki koogo ɓɔrse, taa naase se maakse utu Ꞌtuju ɔɔ utu aki keeme. ");
INSERT INTO kyq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Asen kɔɔn̰ naasen kɛn jeege paac taaɗ taargen nijim rose ki sum se, bin ɓo ɓugɗegen do dɔkin̰ se tɛɗo ute jeegen tɛɗ roɗe aan gɔɔ jee taaɗ taar teeco taar Raa ki bin kici.» ");
INSERT INTO kyq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Gaŋ maam mꞋtaaɗsen naase kɛn iŋg booyki taarum se, mꞋɔɔ: Ꞌjeki jee taamooysege, Ꞌtɛɗki bɛɛ jeege tun jese eyo. ");
INSERT INTO kyq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɔɔɗki ɓooro do jeege tun naamse ɔɔ eemki Raa taa jeegen kɛn dabarse se. ");
INSERT INTO kyq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kɛn nam jaay ɔndiga mɛtn bi ki num, Ꞌtɛrlin̰ kɛn do ji kuuy se kici. Kɛn nam jaay uunga kali magal se, kali baatn maak ki se kic num, ɔn̰te Ꞌkɔɔgin̰. ");
INSERT INTO kyq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Debm kɛn jaay tɔnd mɛtn ɗim gɔti ki num, ɛɗin̰ ɔɔ nam jaay uunga ɗimi num, ɔn̰te Ꞌɓaa baayin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bɛɛ kɛn naase Ꞌjeki jeege asen tɛɗse, naase kic num, Ꞌtɛɗki jeege tu bin kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Kɛn naase jaay Ꞌjeki jeegen jese sum num, bin se nakŋ jaay jꞋasen tɔɔm ro ki tap ɓo gɔtɔ. Taa jee *kusin̰ge kic lɛ je naapa bin kici! ");
INSERT INTO kyq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɔɔ kɛn naase jaay Ꞌtɛɗki bɛɛ jeege tun Ꞌtɛɗsen bɛɛ naase ki sum num, bin se nakŋ jaay jꞋasen tɔɔm ro ki se tap ɓo gɔtɔ. Taa jee kusin̰ge kic lɛ lee tɛɗ bɛɛ ute naapa kici! ");
INSERT INTO kyq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kɛn naase jaay ɛɗki sɛɛ ɓo jeege tun utu asesin̰ tɛrl kɔgŋ gɔtin̰ ki sum num, bin se nakŋ jaay jꞋasen tɔɔm ro ki se tap ɓo gɔtɔ. Taa jee kusin̰ge kic ɓo lee ɛɗ kɛɗ sɛɛ ute naapa, taa naaɗe jeele jꞋaɗesin̰ kɔgŋ gɔtin̰ ki! ");
INSERT INTO kyq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Num gaŋ naase se, Ꞌjeki jee taamooysege; Ꞌtɛɗki bɛɛ jeege tu ɔɔ kɛn ɛɗkiga sɛɛ jeege tu num, ɔn̰te Ꞌsaapki ɔɔki jꞋasesin̰ kɔgɔ. Bin ɓo Raa utu asen tɛɗn bɛɛn̰ dɛn aak eyo ɔɔ naase se jꞋutu jꞋasen daŋ gaan Raagen Taaro. Taa Raa se naan̰ debm jiga ɔɔ naan̰ tɛɗ bɛɛn̰a do jeege tun kꞋtɛɗɗen bɛɛ kic ɓo naaɗe jeel eyo ɔɔ tɛɗ bɛɛ jee kusin̰ge tu kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ꞋKɛrcɛlki aan gɔɔ Bubsen maakŋ raa ki, kɛrcɛl se.» ");
INSERT INTO kyq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ɔn̰ten Ꞌkɔjki bɔɔrɔ do jeege tu, ɔɔ naase kic ɓo jꞋasen kɔjn̰ bɔɔrɔ dose ki eyo. Ɔn̰ten Ꞌkɛndki tɛl nam gɛn kutin̰a, bin se naase kic jꞋasen kɔŋ kut eyo. Kɛn naase jaay Ꞌlee ɔkki naagŋ naapa num, Raa kici asen tɔɔl kusin̰se. ");
INSERT INTO kyq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ɛɗki naka jeege tu taa jꞋutu jꞋasen kɛɗn naase ki kici: ute gɔrn kɛn naase Ꞌlee Ꞌdɔɔjn̰ki jeege tu se, Raa utu asesin̰ dɔɔjn̰, ɗoocn̰ kɔnd gazagaza ɔɔ asesin̰ dɔɔjn̰ cir cir. Bin ɓo ute nakŋ kɛn naase Ꞌlee Ꞌdɔɔjn̰ki nakge jeege tu se, naase kic jꞋutu jꞋasesin̰ dɔɔjn̰ bin kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","«Tɛr Isa taaɗɗen ute kaal naagŋ taara kuuy daala ɔɔ: debm kaam‑tɔɔkɔ Ꞌkɔŋ tɔɔɗn naapin̰ debm kaam‑tɔɔkɔ la? Naaɗen di paac se Ꞌsi maakŋ gɔɔ ki ey ne? ");
INSERT INTO kyq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Debm lee mɛtn deb kɛn dooyin̰ se Ꞌkɔŋ cir debm dooyin̰ eyo. Num gaŋ debm mɛtn deb ki jaay mɛlin̰ dooy ɔkin̰ga se, naan̰ utu Ꞌtɛɗn aan gɔɔ mɛlin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Mu cɔkɔn kɛn kaam gɛnaai ki ɓo naai ɔŋ aakin̰a. Num gɛn ɗi jaay naai ɔŋ aak guɗum kaagŋ kaami ki ey se? ");
INSERT INTO kyq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ute naan̰ se ɓo, naai Ꞌkɔŋ ɗeekŋ gɛnaai ki ɔɔ: Gɛnaama, Ꞌɓaaɗo mꞋai kɔɔɗn mu kaami ki. Nakŋ naai Ꞌtɛɗin̰ se, mɛt ki eyo! Ey num naai ɔk mɛt‑guɗum kaagŋ kaami ki se kici! Bɛɛki num, ɔɔɗ mɛt‑guɗum kaagŋ kaami ki se ram, jaay ɓo kaami Ꞌkɔɔɗn kaakŋ jiga bin jaay Ꞌkɔɔɗn mu cɔkɔn kɛn kaam gɛnaai ki se!» ");
INSERT INTO kyq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kaagŋ jiga se koojin̰ aak kus eyo ɔɔ kaagŋ kɔɔn̰ɔ lɛ ɔŋ ooj koojin̰ jig ey kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Taa kaagge se jꞋaak kꞋjeelɗe ute koojɗege: taa naan̰ se ɓo jꞋkɔŋ tuugŋ koojn̰ mɔŋgɔ do kaag kɛn ute kɔrɔndin̰ eyo ɔɔ kɔŋ tuugŋ koojn̰ k‑ƴooko se do k‑lili ki ey kici. ");
INSERT INTO kyq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Debm bɛɛ se, bɛɛn̰ se iin̰o maakin̰ ki, ɔɔ debm *kusin̰ se, kusin̰in̰ se kic ɓo iin̰o maakin̰ ki. Taa taar kɛn jikilimge lee taaɗ paac se iin̰o maakɗe ki.» ");
INSERT INTO kyq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Naase iŋg Ꞌdaŋum ki: Mɛluma, Mɛluma. Num gɛn ɗi jaay ɓo naase Ꞌbaateki gɛn tɛɗn nakŋ kɛn maam mꞋtaaɗsen mꞋɔɔ aki tɛɗ se? ");
INSERT INTO kyq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Debm ɓaaɗo gɔtum ki, booy taaruma ɔɔ iŋg do ki se, Ꞌbooyki mꞋasen taaɗn nakŋ kɛn naan̰ tecin̰ tece. ");
INSERT INTO kyq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naan̰ se tec aan gɔɔ debm ɓaa kɔɓm ɓeen̰a: naan̰ uɗ gɔɔ jɛrlɛ bini aan do ko ki jaay ɓo ɔndo mɛtn ɓeen̰a. Kɛn naan̰ jaay iin̰in̰ aas sum se, maane eeɗ dɛna ɔɔ oolge kic ɓo ɗooco ɔɔ ɔɔy makɔn̰ɔ ɓaaɗo deeb ɓee se bat naɓo, ɔŋ tɛɗin̰ te ɗim eyo, taa ɓee se kꞋjꞋiin̰in̰ga jiga. ");
INSERT INTO kyq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Num gaŋ debm booy taaruma ɔɔ iŋg do ki ey se, naan̰ se tec aan gɔɔ debm kɛn uɗ te gɔɔ ey sum ɓo iin̰ ɓeen̰a. Kɛn oolge ɗooco jaay ɔɔyɔ makɔn̰ɔ ɔɔ ɓaaɗo deebin̰ bat se, ɓee se ru naŋ tak.» ");
INSERT INTO kyq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kɛn Isa jaay taaɗ naŋ taarin̰ naan jeege tu aas se, naan̰ ɓaa ɛnd maakŋ gɛgɛr kɛn Kaparnayum ki. ");
INSERT INTO kyq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gɔtn se bubm asgarge se ɔk ɓulu kalaŋ bin se naan̰ jen̰ dɛn aak eyo. Naɓo ɓulin̰ se ooc kɔɔn̰ɔ kaam yoa. ");
INSERT INTO kyq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kɛn gaabm se jaay booy jꞋɔɔs maan Isa se, gɔtn se naan̰ iin̰ ɔl magal Yaudge kandum taa ɓaa sɛl mɛtn Isa num, aɗe ɓaa utu kɛɗn lapia ɓulin̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kɛn magal Yaudge jaay aan gɔtn Isa ki se, naaɗe eemin̰ nɔɔ ɔɔ: «Bɛɛki num, gɛn tɛɗn bɛɛ se, Ꞌtɛɗn gaab kɛn se. ");
INSERT INTO kyq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Taa naaje Yaudge se, gaabm se jejeki dɛna ɔɔ naan̰ mala ɓo iin̰jeki ɓee kɛn kꞋlee kꞋtusn maak ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gɔtn se Isa ɓaa ute naaɗe. Num kɛn naan̰ aan te cɛɛ ɓee magal asgarge tu ey sum ɓo, bubm asgar *Rɔmɛge ɔlo mɛɗin̰ge taa an̰ taaɗn ɔɔ: «Mɛluma, ɔn̰te dabar roi gɛn ɓaaɗo ɓeem ki, taa maam se mꞋaas ɗim naani ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Taa naan̰ se ɓo, maam mꞋɔŋ mꞋɓaa te gɔti ki ey se. Num gɔtn ɗaari ki se, naai Ꞌtaaɗ ute taari sum ɓo, debm tɛɗn naabum se Ꞌkɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taa maam se, kic mꞋkaam ji deb kuuy, naɓo mꞋɔk asgarge kaam ji maam kici. Kɛn mꞋiŋgga num mꞋɗeek deb kalaŋ ki mꞋɔɔ: ꞋƁaa se, naan̰ iin̰ Ꞌɓaa. Ɔɔ mꞋɗeek deb kuuy ki mꞋɔɔ: ꞋƁaaɗo se, naan̰ iin̰ ɓaaɗo. Ɔɔ ɓulum ki se jaay, mꞋɗeekin̰ mꞋɔɔ: ꞋTɛɗn nakŋ ese se, naan̰ iin̰ tɛɗin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kɛn Isa jaay booy taar ese se, taara se ɔkin̰ taaɗ eyo. Gɔtn se naan̰ tɛrl aak jee dɛngen ɓaaɗo mɛtin̰ ki se ɔɔ naan̰ ɗeekɗen ɔɔ: «ꞋBooyki mꞋasen taaɗa: maakŋ gaan *Israɛlge tun ute dɛnɗe kic ɓo maam mꞋɔŋ te nam jaay aal maakin̰ do *Raa ki aan gɔɔ gaabm ara se eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kɔr jee naan̰ ɔlɗeno naaba jaay aan ɓeen se, naaɗe ɔŋ ɓul se ɔŋga lapia. ");
INSERT INTO kyq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naan̰ kɛn se jaay, Isa iin̰ ɓaa maakŋ gɛgɛr kɛn kꞋdaŋin̰ Nayn. Jee mɛtin̰ ki ute jeege dɛna ɓaa ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kɛn Isa ute jeege jaay aan taa ɗoob kɛn jꞋan kɛnd maakŋ gɛgɛr ki se, naaɗe aak jeege uuno yoa ɔɔ kɛn ooy se goon mɛnd‑daaye ɔɔ naan̰ kalin̰ ki sum ɓo maakŋ kon̰ ki. Gɔtn se jeege dɛna daan mɛnd se. ");
INSERT INTO kyq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kɛn Mɛljege jaay aak ko goono se, naan̰ ɛɛjin̰ don̰ ki ɔɔ ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌtɔɔyɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gɔtn se Isa iiko cɛɛ jeege tun uuno yo se, ɔnd jin̰ do baraŋgal ki ɔɔ gɔtn se, jee ɓaan ɓaa ute yo se ɗaara ɔɔ Isa ɗeek goon kɔɗ ki se ɔɔ: «MꞋɗeeki mꞋɔɔ, iin̰i!» ");
INSERT INTO kyq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Gɔtn se goon kɔɗn ooyga kooy se duru iin̰ iŋg ute mɛtin̰a ɔɔ baag taaɗn taara. Ɔɔ Isa ɔk ɛɗin̰ kon̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kɛn jeege jaay aak nakŋ se, ɓeere ɓaa ɔkɗe paac ɔɔ naaɗe *nook Raa ɔɔ: «Debm taaɗ taar teeco taar Raa ki magal se, ɓɛrɛ, ɓaaɗoga daanjege tu. Kɛse Raa mala ɓo ɓaaɗoga kaakŋ jeen̰ge!» ");
INSERT INTO kyq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Taa naan̰ se ɓo jee taa naaŋ Jude ki ute jee kɛn taa naaŋge tun cɛɛs ki se, paac se iŋg ɓo gɛn kɔɔsn maana do nakge tun kɛn Isa tɛɗo se. ");
INSERT INTO kyq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gɔtn se jee mɛtn Jan‑Batist ki ɓaaɗo taaɗ mɛlɗe ki. Kɛn Jan jaay booy taarɗe sum se, maakɗe ki se naan̰ daŋ jeege dio, ");
INSERT INTO kyq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ɔɔ ɔlɗe gɔtn Mɛlje Isa ki taa Ꞌɓaa tɔnd mɛtin̰ ɔɔ: «Naai ɓo debm kɛn jeege iŋg aak kaama jꞋɔɔ utu aɗe ɓaa se lɔɓu kꞋbooy nam kuuy lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kɛn naaɗe jaay aan gɔtn Isa ki se, jee se taaɗ ɔɔ: «Naaje se Jan‑Batist ɓo ɔljeno gɔti ki ɔɔ kꞋtɔnd mɛti: naai ɓo debm kɛn jeege iŋg aak kaama jꞋɔɔ utu aɗe ɓaa se lɔɓu kꞋbooy nam kuuy lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naanɗe ki se sum ɓo, Isa ɛɗ lapia jee kɔɔn̰ɗege tu dɛna. Maakɗe ki se jeegen kɛn kɔɔn̰ɔ tujɗenga tuju ute jee ɔk kɔɔn̰ sitange se kic naan̰ ɛɗɗen lapia ɔɔ jee kaam‑tɔɔkge dɛn se kic ɓo naan̰ ɔɔɗɗen kaamɗege. ");
INSERT INTO kyq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gɔtn se Isa ɗeek jeege tun Jan ɔlɗeno naaba se ɔɔ: «ꞋƁaa Ꞌtaaɗki Jan ki nakŋ naase mala aakin̰kiga ute kaamse ɔɔ booyin̰kiga ute bise: jee kaam‑tɔɔkge lɛ aakga, jee cɛkɛɗge lɛ leega talam talam, jee bikiɗge lɛ ɔŋga lapia ɔɔ roɗege lɛ tooɗga kɔlɔn̰ kɔlɔn̰, jee duguyge lɛ ɓɔrse booy booyo, jee ooyga kooy kic lɛ duroga daan yoge tu ɔɔ Labar Jiga se lɛ, kꞋtaaɗin̰ga jee daayge tu. ");
INSERT INTO kyq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Maak‑raapo debm kɛn jaay ai kaamin̰ ɔn̰te ɗoobm gɛn kaal maakin̰ do maam ki ey se.» ");
INSERT INTO kyq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kɛn jee Jan ɔlɗeno naaba jaay ɔk tɛrl ɓaa se, Isa baag taaɗn taar Jan se jee dɛnge tu ɔɔ: «Do kɔɗ‑ɓaar ki se naase tap ɓo iŋgkiro kaakŋ naŋa? Lɔɓu iŋgkiro kaakŋ mu taa baar kɛn kuul teen̰ ɓaansin̰ kaam ara kaam ara se la? ");
INSERT INTO kyq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A‑a! Bin num naase iŋgkiro kaakŋ naŋa? Lɔɓu iŋgkiro kaakŋ gaabm kɛn tus kalge aak bɛɛ se lɛ? Gɔtɔ. Jee lee tus kalgen aak bɛɛ gɛn koono se ute jee maalge se, naaɗe se tiŋg maakŋ ɓee gaarin̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lɔɓu naase tap ɓo iŋgkiro kaakŋ naŋa? Naase se iŋgkiro kaakŋ debm taaɗ taar teeco taar Raa ki se la? Ɗeere, Ꞌbooyki mꞋasen taaɗa: naan̰ se debm taaɗ taar teeco taar Raa ki naɓo naan̰ magal cir debm taaɗ taar teeco taar Raa ki se daala. ");
INSERT INTO kyq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Naan̰ se ɓo debm kɛn Raa taaɗo taarin̰ do dɔkin̰ maakŋ Kitap ki ɔɔ: ꞋBooyo, maam mꞋai kɔl debm kaan̰ naabum naani ki, taa ai Ꞌɗaapm ɗoobi. ");
INSERT INTO kyq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«ꞋBooyki mꞋasen taaɗa: maakŋ jeege tun mɛndge toojɗen do naaŋ ki ara bini aan do Jan ki se, debm kɛn magal cirin̰ Jan se, gɔtɔ. Anum debm *maakŋ Gaar Raa ki se baat aan gɔɔ ɗi kic ɓo, naan̰ se ɓo magal cir Jan. ");
INSERT INTO kyq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Jee dɛnge ute *jee tɔkŋ miirge jaay booy taarin̰ se, Jan *batizɗe taa naaɗe jeelga Raa se tɛɗ naka ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Num gaŋ *Parizige utu jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, naaɗe se baate tookŋ do nakge tun kɛn Raa je ɔɔ aɗen tɛɗn naaɗe ki se. Bin ɓo, naaɗe baate tookŋ kɛn Jan aɗen batizi.» ");
INSERT INTO kyq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tɛr Isa taaɗɗen ɔɔ: «Jee ɓɔrse tap ɓo, mꞋaɗen kɔmb bɛyɛ ute naŋge? Naaɗe tap ɓo tec naŋge? ");
INSERT INTO kyq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Naaɗe se tec aan gɔɔ gaangen iŋg bɔɔr ki jaay taaɗ ute naapa ɔɔ: Naaje kꞋtuuysen kaa naɓo naase Ꞌbaate daamki. Naaje kꞋjꞋaarsen kaa yoa naɓo naase Ꞌbaate keemki. ");
INSERT INTO kyq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Ey num Jan‑Batist ɓaaɗo se, naan̰ ɔs mapp eyo ɔɔ aay tɔtn koojn̰ bin̰ eyo ɔɔ naase ɔɔki num: naan̰ se debm sitan! ");
INSERT INTO kyq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kɛn *Goon Deba jaay ɓaaɗo se ɔsɔ ɔɔ aaye, naɓo naase ɔɔki num: naan̰ se debm kaam‑kɔsɔ ɔɔ debm kaay‑koono ɔɔ ɔk mɛɗɛ ute jee tɔkŋ miirge ɔɔ ute jee *kusin̰ge! ");
INSERT INTO kyq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Num gaŋ jee took aal maakɗe don̰ ki se, aak ɔkga jeel‑taar Raa se ute ɗoobin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɓii kalaŋ kɔɗ *Parizi kalaŋ bini, daŋ Isa ɓeen̰ ki, gɛn ɓaa kɔsn ute naan̰a. Kɛn Isa jaay ɓaa ɓeen̰ ki se, gɔtn se naaɗe tooɗ ute cɛɛsɗe jaay ɓo baag kɔsɔ do tabil ki. ");
INSERT INTO kyq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mɛnda kalaŋ iin̰o maakŋ gɛgɛr kɛn se ɔɔ jeege paac jeelin̰ naan̰ se, mɛnd tɛɗn kusin̰a. Naan̰ ɓaaɗo ɔŋɗe taa naan̰ booyga booy jꞋɔɔ Isa utu iŋg ɔs kɔs gɔtn kɔɗ Parizi ki se. Kɛn naan̰ ɓaaɗo ɓaa se, naan̰ uuno naka aan gɔɔ k‑ɓɔkɔlɔ kalaŋ ko ɓo kꞋcɔɔc kꞋɗaapin̰a. K‑ɓɔkɔl se kꞋɗaapin̰ ute nakŋ kɛn kꞋdaŋin̰ albatir, ɔɔ naan̰ se ɗooc ute itir. ");
INSERT INTO kyq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Naan̰ ɓaaɗo kaam jɛ Isa ki ɔɔ naan̰ eeme ɔn̰ kaa‑maanin̰ se neet jɛ Isa ɔɔ naan̰ ɔtin̰sin̰ ute bɛɛkin̰a ɔɔ baam ɔk aay jɛn̰ se ute maak‑raapo ɔɔ ɔɔyin̰ itir do jɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kɔɗ Parizi kɛn daŋ Isa ɓeen̰ ki jaay aak nakŋ bin se, taaɗ ute maakin̰ ɔɔ: «Kɛn gaabm se jaay debm taaɗ taar teeco taar Raa ki ɗeer num, mɛnd ɓaaɗo utin̰ se, naan̰ an̰ Ꞌjeelin̰ naan̰ se, mɛnd tɛɗn kusin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Gɔtn se Isa taaɗin̰ ɔɔ: «Simon, maam se mꞋɔk taara mꞋai ɗeeke.» Naan̰ tɛrlin̰ ɔɔ: «Debm dooy jeege, Ꞌtaaɗa.» ");
INSERT INTO kyq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Isa ɔɔ: «ꞋBooyo. Debm kalaŋ ɔk jee sɛɛge dio. Deb kalaŋ se ey num an̰ kɔgŋ tamma kaar‑mii ɔɔ debm kuuy se lɛ ey num an̰ kɔgŋ tamma si‑mii. ");
INSERT INTO kyq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Num gaŋ ɗim naaɗe aan kɔgŋ sɛɛɗe gɔtɔ se, naaɗe di se paac, naan̰ tɔɔlɗen sɛɛɗege se naata. Num maakŋ naaɗe kɛn di se, debm ɛɗɗen sɛɛ se kɛn gay ɓo an̰ Ꞌje ciri?» ");
INSERT INTO kyq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon tɛrlin̰ ɔɔ: «Gɛn maam ki num mꞋɔɔ, debm kɛn sɛɛn̰ dɛn jaay ɓo kꞋtɔɔlin̰sin̰ se.» Isa ɗeekin̰ ɔɔ: «Kɛse naai Ꞌtaaɗga taar mɛt ki.» ");
INSERT INTO kyq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gɔtn se Isa uun tɛrl aak mɛnd se, ɔɔ ɗeek Simon ki ɔɔ: «Naai aak mɛnd se ɗaamo! Gɔtn maam mꞋɛndo ɓei ki se, naai ɛɗum te maan tugŋ jɛm eyo; num gaŋ mɛnd se neetum jɛm ute kaa‑maanin̰a ɔɔ ɔtumsin̰ ute bɛɛkin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔɔ naai Ꞌbaam ɔk aay te taarum ute maak‑raap eyo; num mɛnd se kɛn maam mꞋaan sum se, gɔtn naan̰ baam ɔk aay jɛma ute maak‑raapo sum se, ɔn̰um te eyo. ");
INSERT INTO kyq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naai ɔtum te uubm oot dom ki eyo; num mɛnd se ɔtum itir jɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ꞋƁooyo mꞋai taaɗa: mɛnd se kusin̰in̰gen dɛn se, Raa tɔɔlisin̰ga naatn. Taa naan̰ se ɓo, naan̰ jem dɛn se. Gaŋ debm kꞋtɔɔlin̰ kusin̰in̰ baat se, naan̰ kic ɓo ɔk maak‑je baata.» ");
INSERT INTO kyq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tɛr Isa taaɗ mɛnd ki ɔɔ: «Kusin̰ige se maam mꞋtɔɔlisin̰ga naata.» ");
INSERT INTO kyq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jeegen iŋg ɔs ute naaɗe se, baag taaɗn ute naapa ɔɔ: «Kɛse tap ɓo naŋa jaay taaɗ taa Ꞌtɔɔl kusin̰ jeege se?» ");
INSERT INTO kyq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Isa ɗeek mɛnd ki ɔɔ: «Mɛnda, ute kaal maaki kɛn naai aal dom ki se, aajiga. Iin̰i, Ꞌɓaa ute lapia.» ");
INSERT INTO kyq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naan̰ kɛn se jaay Isa ɓaa lee maakŋ gɛgɛrge tu ɔɔ maakŋ naaŋge tu. Naan̰ taaɗ wɔɔk Labar Jigan gɛn Gaar Raa se jeege tu. Gɔtn se jee kaan̰ naabin̰gen sik‑kaar‑dio, ");
INSERT INTO kyq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ute mɛndge kandum se lee ute naan̰a. Mɛndgen se ɓo kɛn naan̰ ɛɗɗeno lapia gɛn kɔɔn̰ roɗege tu ɔɔ tuurɗeno sitange roɗege tu se. Maakɗe ki se, Mari iin̰o Magdala ɔɔ ro naan̰ ki se ɓo, Isa tuurin̰o sitange cili se. ");
INSERT INTO kyq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ɔɔ Yoanna kɛn mɛnd Kuza, gaabin̰ se Gaar *Ɛrɔd ɔn̰in̰ maalin̰ paac kaam jin̰a ɔɔ Suzaan ute mɛndgen kuuy dɛn kici. Naaɗe se ɓo kɛn lee noog Isa ute jee mɛtin̰ ki ute nakgen naaɗe ɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jeege dɛna iin̰o maakŋ gɛgɛrge tu paac ɔɔ ɓaaɗo tus gɔtn Isa ki ɔɔ naan̰ taaɗɗen ute kaal naagŋ taara ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɓii kalaŋ deba kalaŋ teec ɓaa kɔnd buru. Kɛn naan̰ jaay ɔnd kɔnd burin̰ se, kupm mɛtin̰ si jɛŋ ɗoob ki; gɔtn se jeege tuumin̰a ɔɔ yeelge ɓaaɗo tuun ɔsin̰ naatn paac. ");
INSERT INTO kyq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kupm mɛtin̰ge se si gɔt kɛn naaŋin̰ maakin̰ ɔk koa. Kɛn naan̰ jaay utu teec teec sum ɓo naar tuutu taa gɔtn se naaŋin̰ cɛɛpɛ. ");
INSERT INTO kyq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kupm mɛtin̰ se, si maakŋ ji kaag kɛn ɔk kɔrɔndɔ se, naan̰ teece naɓo aan gɔɔ teep maakŋ ji kaag ki se, ji kaaga aayin̰ taara. ");
INSERT INTO kyq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Num kupm kɛn si do naaŋ kɛn jiga se, gɔtn se naan̰ teece, teepe, tɔk doa ɔɔ ɔk kaama dɛn aak eyo.» Do taar kɛn se, Isa uun mindin̰ raan ɗeekɗen ɔɔ: «Debm jaay ɔk bi booyo num, booy ɔk taar se.» ");
INSERT INTO kyq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jee mɛtn Isa ki se tɔnd mɛtin̰ ɔɔ: «Kaal naagŋ taar kɛn naai Ꞌtaaɗ se tap ɓo je ɗeekŋ ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isa tɛrlɗen ɔɔ: «Nakŋ jꞋɔyin̰ga kɔy *maakŋ Gaar Raa ki se, naase se *Raa taaɗsenga naase Ꞌjeelin̰kiga. Num gaŋ jee kuuy se kꞋtaaɗɗen ute kaal naagŋ taara se, taa: Naaɗe Ꞌkaakŋ ute kaamɗe naɓo Ꞌkaakŋ kɔk eyo, Ꞌbooy ute biɗe naɓo Ꞌbooy kɔk eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«ꞋBooyki kaal naagŋ taar ese se je ɗeekŋ ɔɔ: kupm maam mꞋtaaɗn se, kɛse taar Raa. ");
INSERT INTO kyq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kupm kɛn si jɛŋ ɗoob ki se, kɛse taaɗ ute jeegen booy taar Raa naɓo *Ɓubm sitange ɓaaɗo ɔɔɗ taar se maakɗe ki naatn, taa sɔm naaɗe booy uunga num Ꞌkɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kupm kɛn si gɔtn naaŋin̰ ɔk ko maak ki se, kɛse taaɗ te jeegen mɛtn‑jiki booy uun taar Raa ute maak‑raapo naɓo naaɗe ɔŋ ɔkin̰ tɔɔg eyo. Kaaɗ kɛn gɔtɔ utu bɛɛ se naaɗe ɔk taar Raa se ɔɔn̰ɔ, gaŋ nakŋ naama jaay aanga doɗe ki num, naaɗe rɛsn naatn ute taar Raa se. ");
INSERT INTO kyq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kupm si maakŋ ji kaag kɛn ɔk kɔrɔndɔ se, kɛse taaɗ te jeegen booy ɔk taar Raa naɓo, naaɗe uun nirlɗe, je maal *dunia ɔɔ je nakŋ kɛn daa roɗe ɓo jea. Kɛse ɓo tɛɗɗen kaal maakɗe ɓaa tɛɗn nakŋ cɛrɛ sum se. ");
INSERT INTO kyq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Num kupm kɛn si do naaŋ kɛn jiga se, kɛse taaɗ te jeegen maakɗe bɛɛ, booy uun taar Raa ɔɔ ɔkin̰ maakɗe ki jiga ɔɔ jee se, naaɗe aay kaamɗe aal maakɗe do Raa ki ɔɔ tɛɗn nakgen jiga.» ");
INSERT INTO kyq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Nam Ꞌkɔɔcn̰ lɔɔmpɔ jaay an̰ deebm dukulu don̰ ki, ey lɛ an̰ kɔl kɔnd mɛtn daŋal ki se, gɔtɔ. Gaŋ lɔɔmpɔ se kꞋjꞋɔɔcin̰ga num, jꞋuun jꞋɔlin̰ raan ro kaag ki taa jee ɛnd gɔtn ese se, Ꞌkaakŋ gɔtn wɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Taa nakŋ jꞋɔyin̰ kɔy se jꞋutu jꞋan̰ kaakŋ Ꞌtooɗn tal ɔɔ nakŋ jeege jaay jeel mɛtin̰ ey se jeege utu Ꞌjeel mɛtin̰ paac ɔɔ jꞋutu jꞋan̰ kaakŋ kaam kaaɗ ki utu Ꞌtooɗn tal. ");
INSERT INTO kyq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Bin se kɛn aki booy taar Raa num, ɔndki kɔndɔ! Taa debm ɔk se jꞋan̰ kɔmb do ki, num debm ɔk ey se lɛ, kɛn nakŋ naan̰ saap ɔɔ ɔk se kic ɓo, jꞋan tɔsn naatn.» ");
INSERT INTO kyq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gɔtn se gɛnaa Isage ute kon̰ɗe ɓaan̰o kaaka, naɓo taa jeegen dɛn se, naaɗe ɔŋ aan te gɔtin̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nam ɓaaɗo taaɗ Isa ki ɔɔ: «Koi ute gɛnaaige se utu naatn ɔɔ naaɗe je ai kaaka.» ");
INSERT INTO kyq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isa tɛrlɗen ɔɔ: «Koyuma ute gɛnaamge se, kɛse jee kɛn booy taar Raa ɔɔ took iŋg do ki.» ");
INSERT INTO kyq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɓii kalaŋ se, Isa ook maakŋ markab ki ute jee mɛtin̰ ki ɔɔ naan̰ ɗeekɗen ɔɔ: «KꞋgaaŋ kꞋɓaaki jɛŋ baar kɛn kaam naane.» Ɔɔ gɔtn se naaɗe iin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kɛn naaɗe ɓaa ɓaa do maane ki se, gɔtn se Isa kaamin̰ ɓaa ɔk bia. Kaaɗ kɛn se guduray dɔɔbɔ do baar ki ɔɔ ɔl maane ɛnd ɗooc ɗooc maakŋ markaba se ɔɔ naan̰ kɛn se gɔtɔ ɓaa tɛɗɗen ɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Naaɗe iiko cɛɛ Isa ki, durin̰a ɔɔ ɗeekin̰ ɔɔ: «Debm dooyje, Debm dooyje, ɓɛrɛ, naajege jꞋaki kutu!» Kɛn naan̰ jaay iin̰ se, naan̰ aac kaama kuul ki ute maane ki ɔɔ gɔtn se, kuulu ute maan se ɔk ɗaara ɔɔ gɔtɔ do dil. ");
INSERT INTO kyq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gɔtn se naan̰ ɗeekɗen ɔɔ: «Kaal maaksen jaay naase aalki dom ki se, tap ɓo gay?» Kɛn naaɗe jaay aak nakŋ ese se, ɔkɗen taaɗ eyo ɔɔ ɓeere ɓaa ɔkɗe ɔɔ gɔtn se, naaɗe baag taaɗn ute naapa ɔɔ: «Kɛse tap ɓo naŋa bini, kɛn taaɗ kuul ki ute maane ki kic ɓo tookin̰ taarin̰ se?» ");
INSERT INTO kyq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gɔtn se naaɗe ɓaa aan taa naaŋ jeege tun kꞋdaŋɗen Gɛrazɛnige kɛn sak kaam taa naaŋ Galile ki. ");
INSERT INTO kyq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kɛn naaɗe aan taa jɛŋ ki jaay Isa bɔɔy bɔɔy naaŋ ki se, gɔtn se gaab kalaŋ bini ɔk kɔɔn̰ sitan iin̰o maakŋ gɛgɛr kɛn ese ɔɔ ɓaaɗo dɔɔɗ Isa. Ɔɔ gaabm se, naan̰ tiŋg ɓeen eyo ɔɔ lee ute kal ey se daanin̰ dɔkga, num naan̰ se tiŋg maakŋ iiɓge tun Yaudge tɛɗin̰o gɛn tɔl taal yoɗege se. ");
INSERT INTO kyq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kɛn naan̰ jaay aak Isa se, ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ ɓaaɗo ooc mɛtn jɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: «Isa Goon Raa Taaro, jꞋɔŋ ɗi ute naai? MꞋeemi nɔɔ mɛti ki, ɔn̰te gɛn dabaruma!» ");
INSERT INTO kyq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kɛn ɔlin̰ taaɗ bin se, taa Isa ɗeekin̰ga ɗeek ɔɔ n̰Ꞌteec naatn ro gaab kɛn se. Taa sitan se, iin̰ga num tɛɗ gaabm se kusin̰a ɔɔ ɔl kꞋdɔɔkin̰ ute sɛsɛrɛ ɔɔ jꞋaalin̰ dɔkɔɗɔm maala se kic ɓo, naan̰ gaaŋ naatn ɔɔ sitan se ɔlin̰ aan̰ teec ɓaa do kɔɗ‑ɓaar ki. ");
INSERT INTO kyq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɔɔ Isa tɔnd mɛtin̰ ɔɔ: «Naai, Ꞌroi naŋa?» Naan̰ tɛrlin̰ ɔɔ: «Maam rom Dɔɔl asgarge,» taa gaabm se ɔk sitange ron̰ ki dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gɔtn se sitange eem nɔɔ mɛtn Isa ki ɔɔ ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌtɔkŋ kɔmbje maakŋ gɔɔ kɛn jɛrl zuzu se.» ");
INSERT INTO kyq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gaŋ gɔtn se ɔk dɔɔl kin̰zirge dɛna lee gaam gaam do kɔs ki. Gɔtn se sitange se sɛl mɛtn Isa ɔɔ: «Ɔn̰je naaje kꞋɓaa kɛnd maakŋ kin̰zirge tu se.» Gɔtn se Isa tookɗen. ");
INSERT INTO kyq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɔɔ sitange se teeco ro gaab kɛn se ɓaa ɛnd maakŋ kin̰zirge tu se ɔɔ dɔɔl kin̰zirgen te dɛnɗe se dɔɔbɔ rus ɔɔ naar aan̰o girdi girdi bɔɔy ɓaa si maakŋ baar ki ɔɔ maane ɔsɗe paac. ");
INSERT INTO kyq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kɛn jee gaam kin̰zirge jaay aak nakŋ tɛɗ se, naaɗe dɔɔb aan̰ ɓaa taaɗ jeege tun maakŋ gɛgɛr ki ute jeege tun iŋg ɓee naatge tu. ");
INSERT INTO kyq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kɛn jeege jaay ɓaa booy se, naaɗe ɓaaɗo gɛn kaakŋ nakŋ tɛɗ se. Kɛn naaɗe jaay aan ɔŋ Isa se, ɔŋ gaabm debm sitan se, sitanin̰ge se teecga naatn ron̰ ki ɔɔ naan̰ iŋg kiŋg mɛtn jɛ Isa ki ɔɔ tusga kala ron̰ ki jiga jiga. Kɛn naaɗe jaay aakin̰ se, ɓeere ɓaa ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jeegen aako nakŋ se ute kaamɗe se, ɓaaɗo taaɗ jeege tu nakŋ kɛn Isa tɛɗo do gaabm kɛn debm sitan jaay ɓo ɔŋ lapi se. ");
INSERT INTO kyq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gɔtn se jee iŋg taa naaŋ Gɛrazɛ ki paac se, kɛn naaɗe jaay ɓeere ɓaa ɔkɗe se, naaɗe taaɗ Isa ki ɔɔ: «Iin̰ ɔn̰je, Ꞌɓaa dɔkɔ.» Gɔtn se Isa ook maakŋ markab ki gɛn tɛrl ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Gaabm kɛn sitange teec ɔn̰in̰ se, tɔnd mɛtn Isa ɔɔ: «Ɔn̰um mꞋɓaa ute naai.» Gaŋ Isa taaɗin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«ꞋTɛrl ɓaa ɓei ki ɔɔ taaɗ nakŋ paacn̰ kɛn Raa tɛɗi naai ki se.» Kɛn gaabm se jaay ɔk tɛrl ɓaa ɓeen̰ ki se, ɓaa taaɗin̰ jeege tun maakŋ gɛgɛr ki se paac nakŋ kɛn Isa tɛɗin̰o naan̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kɛn Isa jaay aan se, jee dɛnge dɔɔɗin̰a, taa naaɗe se iŋg aak kaak kaamin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gaaba kalaŋ kꞋdaŋin̰ Jayrus; naan̰ se magal *ɓee kɛn Yaudge lee tusn maak ki. Naan̰ ɓaaɗo ooc mɛtn jɛ Isa ki eemin̰ nɔɔ ɔɔ n̰Ꞌɓaaɗo ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Taa naan̰ ɔk goon mɛnda kalaŋ lak, ɓaarin̰ ɓaa ɓaa sik‑kaar‑dio ɔɔ goonin̰ se tooɗ kɔɔn̰ɔ kaam yoa. Kaaɗ kɛn Isa ɓaa ɓaa gɔtn goon mɛnd ki se, jeege dɛna tus ron̰ ki ɔɔ gɔtn lee kic naan̰ ɔŋ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Maakŋ jee dɛnge tu se, mɛnda kalaŋ bin se, gɔtn moosin̰ aan sum se ɔŋ ɗaar eyo ɔkga ɓaara sik‑kaar‑dio ron̰ ki. Naan̰ utga jin̰ paac gɔtn jee dawage tu, naɓo nam ɔŋ ɛɗin̰ te lapi eyo. ");
INSERT INTO kyq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mɛnd se ɓaaɗo naagŋ Isa ki ɔɔ ut taa kalin̰a ɔɔ gɔtn ese sum ɓo, moosin̰ naar ɗaara. ");
INSERT INTO kyq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isa tɔnd mɛta ɔɔ: «Kɛn ɔl jin̰ utum se naŋa?» Aan gɔɔ jeege paac baaga naaja se, gɔtn se Piɛr ɗeek Isa ki ɔɔ: «Mɛluma, aaka jeege ɓo lee uri mak mak se ɗey!» ");
INSERT INTO kyq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gaŋ Isa ɗeek ɔɔ: «Num nam ɔlga jin̰ utumga, taa maam mꞋnaamga tɔɔgŋ kɛn teec rom ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kɛn mɛnd se jaay jeel jeege an̰ jeel se, ɓeere ɓaa ɔkin̰ se ron̰ ook marga ɔɔ ɓaaɗo ooc mɛtn jɛ Isa ki. Gɔtn se naan̰ taaɗ naan jeege tu paac nakŋ kɛn ɔlin̰ jaay ɓo, naan̰ ɔl jin̰ ut taa kal Isa se. Mɛnd se taaɗɗen ɔɔ: «Maam mꞋnaar mꞋut kali sum ɓo, mꞋɔŋ lapia.» ");
INSERT INTO kyq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gɔtn se Isa ɗeekin̰ ɔɔ: «Goonuma, taa naai aalga maaki dom ki se, kaal maaki se aajiga. ꞋƁaa ute lapia.» ");
INSERT INTO kyq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kɛn Isa utu ɗaar taaɗ taaɗ ɓɔrt se sum ɓo, deb kalaŋ iin̰o gɔtn Jayrus ki ɔɔ ɓaaɗo taaɗin̰ ɔɔ: «Ɓɛrɛ, gooni mɛnda se lɛ ooyga. Ɔn̰te dabar Debm dooy jeege se cɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Num kɛn Isa jaay booy taar se, naan̰ taaɗ Jayrus ki ɔɔ: «Ɔn̰te ɓeere; ɔnd maaki kaam kalaŋ. Gooni mɛnda se utu Ꞌkaaja.» ");
INSERT INTO kyq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kɛn Isa jaay aan ɓee Jayrus ki se, jee dɛn se naan̰ gaasɗe naatn. Gɔtn se ɔɔp Piɛr, Jan, Jak ɔɔ ko goono ute bubm goono sum ɓo ɛnd ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jeege paac eeme ɔɔ tɔɔy makɔn̰ɔ do yo ki se. Num gaŋ Isa ɗeekɗen ɔɔ: «Ɔn̰te Ꞌkeemki. Goono se ooy te eyo; naan̰ lɛ tooɗ tooɗ bi sum.» ");
INSERT INTO kyq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kɛn naaɗe jaay booy taarin̰ se, naaɗe baag tooy koogo mɛtin̰ ki taa naaɗe jeele goon mɛnda se lɛ, ooyga ɗeere. ");
INSERT INTO kyq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gɔtn se Isa ɔk jin̰a, uun mindin̰ raan ɔɔ: «Goonuma, iin̰i!» ");
INSERT INTO kyq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gɔtn se sum ɓo goono se duru ɔɔ naar iin̰ ɗaara. Tɛr Isa taaɗɗen ɔɔ: «Goono se, jꞋɛɗin̰ kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kɛn bubin̰ ute kon̰ jaay aak nakŋ se, nakŋ se ɓaa deel doɗe ɔɔ ɔkɗen taaɗ eyo. Gɔtn se Isa dɛjɗen ɔɔ nakŋ deel se, jꞋɔn̰te ɓaa taaɗin̰ nam ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ɓii kalaŋ Isa tus jee kaan̰ naabin̰gen sik‑kaar‑dio ɔɔ naan̰ ɛɗɗen tɔɔgɔ do sitange tu paac ɔɔ ɛɗɗen tɔɔgŋ gɛn kɛɗn lapia jee kɔɔn̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naan̰ ɔlɗen naaba se taa Ꞌɓaa taaɗn labar gɛn *maakŋ Gaar Raa se jeege tu ɔɔ gɛn kɛɗn lapi jee kɔɔn̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naan̰ taaɗɗen ɔɔ: «Kɛn Ꞌɓaaki ɓaa mɛrtɛ se, ɔn̰te Ꞌkuunki ɗim, ɔn̰te Ꞌkuunki sirɗi, ɓɔɔnɔ, kɔsɔ ɔɔ ɔn̰te Ꞌkuunki gurs kici. Ɔɔ maakse ki se, nam ɔn̰te Ꞌtɔsn kalge dio. ");
INSERT INTO kyq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɓee kɛn naase Ꞌbɔɔykiga maak ki se, Ꞌtooɗki gɔtn ese, bini anki kiin̰ ɓaa maak ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gɔtn naase Ꞌɓaaki jaay jeege baate dɔɔɗn kɔkse num, kɛn naase Ꞌteecki teec maakŋ gɛgɛrɗe kɛn ese se, kuɗn jɛsege se kic ɓo Ꞌtupɗenki naatn, kɛse aɗen tooɗn saaɗa.» ");
INSERT INTO kyq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bin ɓo, *jee kaan̰ naabm Isage se ɓaa lee maakŋ naaŋge tu, taaɗ Labar Jiga jeege tu ɔɔ gɔtɔ ɓaa se paac, naaɗe ɛɗ lapia jee kɔɔn̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kɛn Gaar Ɛrɔd Antipas naan̰ ɓo magal taa naaŋ Galile se jaay booy jꞋɔɔs maan nakgen deel se, taar se ɓaa deel don̰a taa jee mɛtin̰ge ɗeek ɔɔ: «Kɛse Jan‑Batist ɓo duroga daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɔɔ jee mɛtin̰gen kuuy taaɗ ɔɔ: «*Ɛli do dɔkin̰ se ɓo, ɓaaɗoga.» Ɔɔ kɛngen kuuy kic taaɗ ɔɔ: «Kaaɗn naane maakŋ jeege tun taaɗ taar teeco taar Raa ki do dɔkin̰ se ɓo, deb kalaŋ duroga daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Taa naan̰ se ɓo ɔl Ɛrɔd taaɗ ɔɔ: «Nakage, ey num Jan‑Batist se lɛ maam mala ɓo mꞋɔl kꞋgaaŋo ute don̰a. Num kɛse tap ɓo debm gay daala jaay mꞋbooy tɛɗ nakgen bin se?» Gɔtn se naan̰ je Isa taa an̰ kaaka. ");
INSERT INTO kyq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kɛn *jee kaan̰ naabm Isage jaay tɛrl ɓaa ɔŋ Isa se, taaɗin̰ mɛtn nakgen naaɗe tɛɗo paac se. Gɔtn se naan̰ ɔk ɓaanɗe cɛɛs ki kaam gɛgɛr kɛn sak Betsaida. ");
INSERT INTO kyq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kɛn jee dɛnge jaay booy labar se, naaɗe ru ɓaa mɛtin̰ ki. Ɔɔ Isa dɔɔɗ ɔkɗe ɔɔ gɔtn se, naan̰ taaɗɗen taar *maakŋ Gaar Raa ɔɔ jee kɛn ɓaaɗo je lapi roɗe se, naan̰ ɛɗɗen lapia. ");
INSERT INTO kyq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gaŋ kɛn kaaɗa ɓaa ɓaa kooco se, jee kaan̰ naabm Isagen sik‑kaar‑di se, ɓaaɗo taaɗin̰ ɔɔ: «ꞋƊeek jeege tu se kꞋwɔɔk kꞋɓaa maakŋ naaŋge tu ɔɔ maakŋ ɓee naatge tun gɔɔr gɔɔr se. Taa gɔtn naane se, naaɗe Ꞌkɔŋ nakŋ kɔsɔ ɔɔ Ꞌkɔŋ gɔtn tooɗo kici. Ey num gɔtn ara se, naajege kꞋdo kɔɗ‑ɓaar ki.» ");
INSERT INTO kyq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gaŋ Isa tɛrlɗen ɔɔ: «Naase mala ɛɗɗeki kɔsɔ.» Gɔtn se naaɗe tɛrlin̰ ɔɔ: «Mappan jꞋɔk se lɛ cir mii eyo ɔɔ kɛn̰jge kic lɛ kꞋjꞋɔk di sum. Kɛn jee se jaay Ꞌkɔŋ kɔsɔ paac num, naan̰ se naaje jꞋaɗe ɓaa dugŋ kɔsɔ kuuy do ki.» ");
INSERT INTO kyq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jee tus gɔtn ese paac se, gaabge kalɗe ki sum ɓo ɓaa ɓaa nakŋ dupu‑mii. Gɔtn se Isa taaɗ jeege tun mɛtin̰ ki ɔɔ: «ꞋTaaɗki jeege tu kꞋjꞋiŋg naaŋ ki ɔɔ Ꞌgaaŋɗeki jeege se si‑mii si‑mii.» ");
INSERT INTO kyq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naaɗe tɛɗ jeege paac iŋg naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Num Isa tɔs mappan mii ute kɛn̰jgen di se jin̰ ki, naan̰ uun kaamin̰ raan, tɔɔm *Raa, dup mappa ɔɔ ɛɗin̰ jeege tun mɛtin̰ ki taa Ꞌkɛɗn jee dɛnge tu. ");
INSERT INTO kyq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Naaɗe paac ɔs dɛrɛŋ ute maraadɗe ɔɔ togŋ ɔɔp se kꞋtuun kꞋtusin̰ maakŋ gɔrnge tu sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɓii kalaŋ se, Isa iik took cɛɛs ki kalin̰ ki gɛn tɔnd mɛtn Raa. Naan̰ kɛn se, jee mɛtin̰ ki utu te naan̰a. Gɔtn se naan̰ tɔnd mɛtɗe ɔɔ: «Jee dɛnge tap ɓo taaɗ ɔɔ maam mꞋnaŋa?» ");
INSERT INTO kyq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Naaɗe tɛrlin̰ ɔɔ: «Jee mɛtin̰ge ɔɔ naai Jan‑Batist ɔɔ jee kuuy ɔɔ naai *Ɛli kɛn do dɔkin̰a ɔɔ kɛngen kuuy daala ɔɔ naai se kaaɗn naane maakŋ jeege tun taaɗ taar teeco taar Raa ki do dɔkin̰ se ɓo, deb kalaŋ duroga daan yoge tu ɗaam.» ");
INSERT INTO kyq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ɔɔ Isa ɗeekɗen ɔɔ: «Kɛn maak‑saap naase ki num ɔɔki maam mꞋnaŋa?» Piɛr ɛɛp taarin̰ ɔɔ: «Naai ɓo al‑Masi kɛn Raa ɔlo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Gɔtn se Isa aacɗen kaama ɔɔ taar se jꞋɔn̰te ɓaa taaɗn nam ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tɛr naan̰ taaɗɗen mɛtin̰ ɔɔ: «Bɛɛki num, *Goon Deba utu Ꞌdabar kusin̰a. Magal taa ɓee Yaudge, *jee magal tɛɗn sɛrkɛ Raa ki, ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage, naaɗe se utu an̰ kɔɔɗn kundu ɔɔ utu an̰ tɔɔlɔ ɔɔ daan ɓii k‑mɔtɔge tu se, naan̰ utu aɗe dur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gɔtn se naan̰ taaɗɗen paac ɔɔ: «Debm jaay je am daan maam se, naan̰ Ꞌbaatn ron̰ mala ɔɔ ɓii‑raa Ꞌkuun kaagŋ yon̰a jaay ɓo am daana. ");
INSERT INTO kyq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Taa debm je kaajn̰ kon̰ se utu an̰ kutu naan Raa ki ɔɔ debm ut kon̰a taa maam se, utu an̰ kaaja. ");
INSERT INTO kyq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kɛn debm jaay *duni ute magalin̰ ɓo kaam jin̰ kic num, kɛn naan̰ kutn kon̰ naan Raa ki se, an kɔŋ ɗi ro ki? ");
INSERT INTO kyq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Taa naan̰ se ɓo, debm jaay tɛɗ sɔkɔn̰ɔ taa maama ɔɔ ro taarum ki se, maam *Goon Deba kic ɓo, ɓiin mꞋaɗe ɓaa maakŋ *nookum ki gɛn Bubum ki ɔɔ ute gɛn kɔɗin̰gen *salal se, maam kic sɔkɔn̰ɔ utu am tɔɔl taa naan̰ kici. ");
INSERT INTO kyq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ɗeere, Ꞌbooyki mꞋasen taaɗa: maakŋ jeege tun ɓɔrse utu ara se, mɛtin̰ge se kooy ey sum ɓo, utu Ꞌkaakŋ Raa Ꞌkɔsn gaara doɗe ki.» ");
INSERT INTO kyq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kɛn Isa taaɗ aas taarin̰ jeege tu jaay ɔk nakŋ ɓaa ɓaa ɓii marta se, naan̰ ɔk Piɛr, Jan ɔɔ Jak ɔɔ naaɗe ook do ko ki gɛn ɓaa keem Raa. ");
INSERT INTO kyq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kaaɗ kɛn Isa eem keem Raa se, daan‑kaamin̰ ɓaa tɛrl kuuy ɔɔ kalin̰ se ɓaa tɛɗ raap lak lak ɔɔ ɔmb mɛt ki birin̰ birin̰. ");
INSERT INTO kyq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gɔtn se naaɗe aak gaabge dio ɗaar taaɗ taaɗ ute Isa ɔɔ jee di ese se, *Musa ute *Ɛli. ");
INSERT INTO kyq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɔɔ gɔtn Musa ute Ɛli ɗaar ro ki se, Raa tɛɗin̰ gɔtɔ wɔɔr kɛlɛŋ. Gɔtn se naaɗe taaɗ mɛtn taar kɛn tɛɗga num, Isa utu Ꞌkooy Jeruzalɛm ki se. ");
INSERT INTO kyq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Gaŋ Piɛr ute mɛɗin̰ge se bi ɓaa cirɗe. Num kɛn naaɗe duro maakŋ biɗe ki se, naaɗe aak Isa se ron̰ wɔɔr gɔtɔ kɛlɛŋ ɔɔ naaɗe aak jee di se ɗaar ɗaar cɛɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kɛn Musa ute Ɛli jaay iin̰ ɔn̰ kɔn̰ Isa se, Piɛr ɗeek Isa ki ɔɔ: «Debm dooyje, bɛɛki num, jꞋaki kiŋg gɔtn ara ki ɓo jiga; ɔn̰ jꞋasen taal daabge mɔtɔ, kalaŋ naai ki, kalaŋ Musa ki ɔɔ kalaŋ Ɛli ki.» Gaŋ taar naan̰ taaɗ se tap ɓo, ɔnd te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kɛn Piɛr utu taaɗ taaɗ sum ɓo, gapara naar ɓaaɗo deebɗe bat. Kɛn naaɗe jaay aak gapara ɓaa deebɗe se, ɓeere ɓaa ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tɛr naaɗe booy mind deba taaɗ maakŋ gapar ki ɔɔ: «Kɛse goonum kɛn maam mꞋbɛɛr mꞋɔɔɗin̰o. ꞋBooy uunki taarin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kaaɗ kɛn naaɗe booy mind deba utu taaɗ taaɗ se, kɔr naaɗe aak ɔk se, ɔɔp Isa kalin̰ ki sum. Nakŋ naaɗe aakin̰ paac se, kaaɗ kɛn se naaɗe taaɗin̰ te nam ki eyo, num naaɗe bɔɔbin̰ maakɗe ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɔɔ mɛtbeen̰ki se, kɛn naaɗe bɔɔyɔ bɔɔy do ko ki se, jeege dɛna ɓaaɗo dɔɔɗn Isa. ");
INSERT INTO kyq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Maakŋ jeege tu se, gaaba kalaŋ daŋin̰ makɔn̰ɔ ɔɔ: «Debm dooy jeege, mꞋeemi nɔɔ Ꞌɓaaɗo aakum tu goonum ara se. Ɓɛrɛ, goonum ɓo kalaŋ ese sum. ");
INSERT INTO kyq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gɔtn mɛtin̰ se kɛn sitan ɔkin̰ga tak ɓo, goono tɔɔy makɔn̰ɔ, uun undin̰ naaŋ ki, tiikin̰ zak zak ɔɔ taarin̰ kic ɓo tiin̰ gupiyu. Kɛn sitan se jaay ɔkin̰ga num, tɛɗin̰ ɔɔn̰ jaay teec ron̰ ki dabarin̰ bini naŋin̰ tɔɔgin̰ jaay ɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Maam mꞋtɔndo mɛtn jee mɛti ki mꞋɔɔ am tuur sitan ro goonum ki se naatn, naɓo naaɗe ɔŋ aasin̰ te eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isa ɗeekɗen ɔɔ: «Naase jee do naaŋ kɛn ɓɔrse aalki maakse do Raa ki ey se. Naase se jee naajn̰ taarge ɔɔ jee bɛɛki eyo! Maam tap ɓo mꞋkiŋg ute naase se bini nuŋ ki ɔɔ mꞋasen sɛrkŋ bini nuŋ ki? Ɔk ɓaano ute gooni se ara.» ");
INSERT INTO kyq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kɛn goono jaay kꞋɓaano ɓaa gɔtn Isa ki se, sitan uun undin̰ naaŋ ki ɔɔ naan̰ baag tiikŋ zak zak. Gaŋ kɛn Isa jaay aakin̰ se, naan̰ aac kaama sitan ki ɔɔ sitan teec ɔn̰ goono. Ɔɔ goono se, Isa uun ɛɗin̰ bubin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kɛn jeege jaay aak nakŋ tɛɗ se, ɓaa deel doɗe ɔɔ ɔkɗen taaɗ eyo ɔɔ ɗeek ɔɔ: «Ɗeere, Raa se magal aak eyo.» Kaaɗ kɛn jeege paac utu aak kaak nakŋ kɛn Isa tɛɗ jaay ɔkɗen taaɗ ey se, Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Uɗki bi jiga ro taar kɛn maam mꞋje mꞋasen taaɗse. *Goon Deba se, jꞋutu jꞋan̰ kɔkŋ kɔl ji jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Num gaŋ jee mɛtin̰ ki se, taar se, naaɗe ɔŋ booy ɔk te mɛtin̰ eyo; taa taar se mɛtin̰ ute don̰ naaɗe ɔnd te eyo. Ɔɔ gɛn tɔnd mɛtin̰ lɛ, naaɗe ɓeerin̰ ɓeere. ");
INSERT INTO kyq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jee mɛtn Isa ki baag naajn̰ ute naapa ɔɔ maakɗe ki se, naŋa ɓo Ꞌtɛɗn magalɗe. ");
INSERT INTO kyq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aan gɔɔ Isa jeel maak‑saapɗe se, naan̰ uuno goon cɔkɔ ɓaaɗo ɔndin̰ cɛɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ɔɔ naan̰ ɗeekɗen ɔɔ: «Goon ese se jaay debm ɔkin̰ jiga taa maam se, kɛse naan̰ ɔkum maam mala. Ɔɔ debm ɔkum maam se, naan̰ ɔk debm kɛn ɔlumo. Taa naan̰ se ɓo, maakŋ naase kɛn paac se, debm ɔɔp ron̰ baat se, naan̰ ɓo asen Ꞌtɛɗn magalse.» ");
INSERT INTO kyq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Gɔtn ese Jan ɛɛp taarin̰ ɗeekin̰ ɔɔ: «Debm dooyje, naaje jꞋɔŋo deb kalaŋ bin se lee tuur tuur sitange ute roi. Num naaje kꞋje jꞋan̰o gaasa, taa naan̰ lɛ lee ute naajege eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Gaŋ Isa ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌgaasin̰ki! Debm jaay debm taamooyse ey se, naan̰ se debm naase.» ");
INSERT INTO kyq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kaaɗn naan̰ aan kiin̰ kɔn̰ do naaŋa jaay aan se, Isa uun doa ute maakin̰ paac gɛn ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gɔtn se naan̰ ɔl jeege naanin̰ ki ɔɔ jee se jaay ɓaa aan maakŋ naaŋ kɛn kalaŋ gɛn taa naaŋ Samari ki se, naaɗe je an̰ ɗaapm gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Num gaŋ taa naan̰ ɓaa ɓaa Jeruzalɛm ki se, jee se baate kɔkin̰ gɔtɗe ki. ");
INSERT INTO kyq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kɛn naaɗe jaay aak nakŋ ese se, jee mɛtin̰ kɛn Jak ute Jan se ɗeekin̰ ɔɔ: «Mɛlje, kɛn naai je num jꞋaki Ꞌtɔnd mɛtn Raa aɗe bɔɔy pooɗo doɗe ki taa aɗen kɔsn naŋa.» ");
INSERT INTO kyq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kɛn Isa jaay booy taarɗe se, naan̰ ɔk tɛrl mooyɗe. ");
INSERT INTO kyq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gɔtn se naaɗe uun ɗoobm naaŋ kuuy. ");
INSERT INTO kyq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kɛn naaɗe ɓaa ɓaa ɗoob ki se, deb kalaŋ ɗeek Isa ki ɔɔ: «Gɔtn naai Ꞌɓaa gay gay kic ɓo, maam mꞋai daana.» ");
INSERT INTO kyq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isa tɛrlin̰ ɔɔ: «ꞋBooyo! K‑bukumbɔɔge kic ɓo ɔk ɓee tooɗɗege, ɔɔ yeelge kic lɛ ɔk kujɗege. Num gaŋ maam *Goon Deba se mꞋɔk gɔtn maam mꞋan kɔl dom eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naan̰ ɗeek deb kuuy ki ɔɔ: «ꞋDaanuma!» Gaabm se tɛrlin̰ ɔɔ: «Ɔn̰um mꞋaɗe ɓaa duubm bubum jaayo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Gaŋ Isa tɛrlin̰ ɔɔ: «Ɔn̰ jeegen aan gɔɔ ooyga kooy naan Raa ki se Ꞌduubm naapa. Num naai se, Ꞌɓaa taaɗ labar gɛn *maakŋ Gaar Raa se jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tɛr deb kuuy daala ɓaaɗo ɔŋin̰ ɗeekin̰ ɔɔ: «Mɛlje, maam se mꞋje mꞋai daana, naɓo ɔn̰um mꞋaɗe tɛɗn tɔɔsɛ jeemge tun maakŋ ɓeem ki jaayo.» ");
INSERT INTO kyq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isa tɛrlin̰ ɔɔ: «Debm kɛn naab naab ute maraŋge jaay tɛrl aak mɛtin̰ ki se, debm bin se aas gɛn Ꞌkɔŋ tɛɗn naaba maakŋ Gaar Raa ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kɛn nakgen se jaay deel se, Mɛljege bɛɛr tɔɔɗ jee kuuy sik‑cili‑kaar‑dio, nigɗe di dio ɔɔ ɔlɗen naaba maakŋ gɛgɛrge tu ɔɔ maakŋ naaŋge tun kɛn naan̰ mala utu ɓaa maak ki kici. ");
INSERT INTO kyq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gɔtn se Isa ɗeekɗen ɔɔ: «Maakŋ‑gɔtn tɛɗga gɛn kɔjɔ se utu dɛna, naɓo jee tɛɗn naabge se, baata. Bin num, Ꞌtɔndki mɛtn Mɛl maakŋ‑gɔtɔ taa aɗe kɔl jee tɛɗn naabge do ki gɛn kɔjn̰ maakŋ gɔtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Isa ɗeekɗen ɔɔ: «Iin̰ Ꞌɓaaki! Naɓo Ꞌbooyki: maam se mꞋɔlsen aan gɔɔ gaan baatge maakŋ k‑sogsogige tu. ");
INSERT INTO kyq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kɛn Ꞌɓaaki ɓaa se, ɔn̰te Ꞌkuunki kꞋbɔnd gurs, ɓɔɔnɔ, saa ɔɔ daan ɗoob ki se, ɔn̰te Ꞌɗaarki gɛn tɛɗn tɔɔsɛ nam ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Maakŋ ɓee kɛn naase ɛndkiga maak ki deet deet se, Ꞌtɛɗɗeki tɔɔsɛ. ");
INSERT INTO kyq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Maakŋ ɓee kɛn jaay ɔŋkiga debm jaay je tɔɔsɛ se, ɔn̰ki tɔɔsɛ se Ꞌkɔɔpm maakŋ ɓeen̰ ki; kɛn ɔŋki nam jaay je tɔɔsɛ ey num, tɔɔsɛ se Ꞌtɛrl ute naase. ");
INSERT INTO kyq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Maakŋ ɓee jaay mɛlin̰ge ɔksenga jiga num, iŋgki gɔtn ese; ɔski ɔɔ aayki, taa debm tɛɗn naaba se, bɛɛki num, jꞋan̰ kɔgŋ dal dubarin̰a. Ɔɔ iŋgki kaam kalaŋ, ɔn̰te Ꞌleeki ɓee jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Maakŋ gɛgɛr kɛn naase ɛndkiga jaay mɛlin̰ge ɔksenga jiga se, kɔsn kɛn naaɗe ɓaansenoga se ɔn̰te Ꞌbaatin̰ki, ɔski. ");
INSERT INTO kyq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jee kɔɔn̰gen gɔtn ese ɛɗɗeki lapia ɔɔ jee se Ꞌtaaɗɗeki ɔɔki: ɓɛrɛ, ɓɔrse *maakŋ Gaar Raa se aanga gɔtse ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Num gaŋ, maakŋ gɛgɛr kɛn naase ɛndkiga jaay, mɛlin̰ge baatsenga kɔkŋ num, Ꞌteecki naatn bɔɔr ki ɔɔ Ꞌɗeekɗeki ɔɔki: ");
INSERT INTO kyq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Kuɗn maakŋ gɛgɛr se kɛn uun naagŋ jɛje ki se kic ɓo, kꞋtupsesin̰ naatn naanse ki. Ɓɛrɛ Ꞌjeelki: maakŋ Gaar Raa se aanga gɔtse ki! ");
INSERT INTO kyq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ꞋBooyki mꞋasen taaɗa: ɓii kɛn *Raa Ꞌkɔjn̰ bɔɔrɔ do jeege tu se, jee ese se bɔɔr kɛn koocn̰ do naaɗe ki se aɗen tɛɗn ɔɔn̰ cir gɛn jee maakŋ gɛgɛr Sɔdɔm ki se dɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Isa ɗeekɗen ɔɔ: «Utu asen kɔɔn̰ aak eyo naasen jee maakŋ gɛgɛr kɛn Kɔrɔzin ki ɔɔ utu asen kɔɔn̰ aak eyo naasen jee maakŋ gɛgɛr kɛn Betsaida ki! Taa nakŋ‑kɔɔɓgen kɛn tɛɗo gɔtse ki se, jaay Ꞌtɛɗoga tɛɗ maakŋ gɛgɛrge tun Tir ki ute kɛn Sidɔŋ kɛn jee *kusin̰ge se num, kaaɗn do dɔkin̰ naaɗe tɛrlɗega maakɗe do Raa ki, naaɗe tuusn kal kɔl doa ɔɔ bɔɔy burku doɗege tu. ");
INSERT INTO kyq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ɗeere, ɓii kɛn Raa utu Ꞌkɔjn̰ bɔɔrɔ do jeege tu se, nakŋ utu Ꞌkaan dose ki se utu Ꞌkɔɔn̰ cir kɛn aano do jeege tun Tir ki ute Sidɔŋ ki se daala. ");
INSERT INTO kyq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɔɔ naase jee gɛgɛr kɛn Kaparnayum ki, gɛn naase ki num, ɔɔki nookse se Ꞌkeem kaan maakŋ raa ki la? Gɔtɔ! Naase se utu aki kooy Ꞌɓaa ɓee yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tɛr Isa taaɗɗen ɔɔ: «Debm booy uun taar naase se, booy uun taar maam kici ɔɔ debm baatse naase se, baatum maam kici. Anum debm kɛn baatum maam se, baate debm kɛn ɔlumo se kici.» ");
INSERT INTO kyq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kɛn jee mɛtn Isa kɛn sik‑cili‑kaar‑di jaay naŋo naabɗe se, naaɗe ɔk tɛrl ɓaaɗo ɔŋ Isa ute maak‑raapo ɔɔ ɗeekin̰ ɔɔ: «Mɛlje, kɛn naaje kꞋtuuro sitange ute ro naai se, naaɗe kic ɓo tookjeno taarje.» ");
INSERT INTO kyq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Gɔtn se Isa tɛrlɗen ɔɔ: «Maam mꞋaak *Ɓubm sitange bɔɔy ooco maakŋ raa ki aan gɔɔ maan kɛn aal wusuk wusuk se. ");
INSERT INTO kyq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ꞋBooyki, kɛse ɓo tɔɔgŋ kɛn maam mꞋɛɗsen taa anki tuum wɔɔjge ute iin̰ge ɔɔ ute tɔɔgŋ se, naase anki cir jee wɔɔysege ɔɔ naaɗe se paac asen Ꞌkɔŋ tɛɗn ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bin num maakse ɔn̰te raapo taa sitange ɓeersenoga ɔɔ booysenoga taarse, num gaŋ Ꞌtɛɗki maak‑raapo taa rosege se Raa raaŋin̰ga raaŋ maakŋ raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naan̰ kɛn se sum ɓo, Isa ɗooc ute *Nirl Salal, ɔɔ gɔtn se maakin̰‑raap sakan̰ ɔɔ baag tɔɔm Raa ɔɔ: «Bua, naai ɓo Mɛl maakŋ raa ute gɛn do naaŋa, maam mꞋtɔɔmi taa nakgen se naai ɔyin̰ga kɔyɔ jee jeel‑taarge tu ute jee mɛtɛkge tu, ɔɔ ɓɔrse naai Ꞌtaaɗga mɛtin̰a gaan sɛɛmge tu. Ɗeere, Bua, kɛse ɓo nakŋ jigan kɛn naai maaki jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nakge paac se Bubum ɛɗumsin̰ga kaam jima. Ey num Goono se nam tap ɓo jeelin̰ eyo; kɛn jeelin̰ se Raa Bubu kalin̰ ki sum. Ɔɔ Raa Bubu se kic ey num, nam tap ɓo jeelin̰ eyo num kɛn jeelin̰ se, Goonin̰ kalin̰ ki sum ɔɔ Goonin̰ se ɓo je an̰ taaɗn Raa Bubu se jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gɔtn se Isa tɛrl aak jee mɛtin̰ ki ɔɔ taaɗɗen naaɗe kalɗe ki sum ɔɔ: «Naase Ꞌmaakse raapo taa nakŋ kɛn naase aakin̰ki ute kaamse se. ");
INSERT INTO kyq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ꞋBooyki mꞋasen taaɗa: jee taaɗ taar teeco taar Raa ki dɛna ute gaarin̰gen do dɔkin̰ dɛn se, je ɔɔ aɗe kaakŋ nakŋ kɛn ɓɔrse naase aakki se, naɓo ɔŋ aakin̰ te eyo, ɔɔ je ɔɔ aɗe booy nakŋ ɓɔrse naase Ꞌbooyki se, naɓo ɔŋ booyin̰ te eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɓii kalaŋ debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa kalaŋ bini iin̰ ɗaar tɔnd mɛtn Isa taa an̰ naama ɔɔ ɗeekin̰ ɔɔ: «Debm dooy jeege, mꞋtɛɗn mꞋɔɔ ɗi jaay mꞋkɔŋ *kaajn̰ gɛn daayum se?» ");
INSERT INTO kyq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isa tɛrlin̰ ɔɔ: «Do *Ko Taar kɛn Raa ɛɗo Musa ki se kꞋraaŋo jꞋɔɔ ɗi? Kɛn naai Ꞌdooyin̰ se Ꞌbooy ɔkin̰ ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Gaaba se tɛrlin̰ ɔɔ: «Kɛn maam dooyin̰ se ɗeek ɔɔ: Naai Ꞌje Mɛli Raa se ute maaki paac, ute roi paac, ute tɔɔgi paac, ute saapi paac ɔɔ Ꞌje naapi se aan gɔɔ Ꞌje ro naai mala.» ");
INSERT INTO kyq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isa tɛrlin̰ ɔɔ: «Taar se, naai Ꞌtɛrlin̰ga ute ɗoobin̰a. ꞋƁaa Ꞌtɛɗn naan̰ se ɔɔ naai Ꞌkɔŋ kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Num gaaba je ɗaapm taarin̰ se tɔnd mɛtn Isa ɔɔ: «Naapum tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isa ɗeekin̰ ɔɔ: ꞋBooy mꞋai taaɗn mɛtn taara kalaŋ. Ɓii kalaŋ se, gaaba kalaŋ iin̰o maakŋ gɛgɛr kɛn Jeruzalɛm ki bɔɔy ɓaa ɓaa maakŋ gɛgɛr kɛn Jeriko ki. Kɛn naan̰ ɓaa ɓaa se, ɓaa ooc ji jee ɓoogge tu. Gɔtn se jee ɓoogge se ɔkin̰a, tɔɔɗn te kalin̰ naatn, ɔɔ tɔnd aalin̰ par kaam yoa; jaay ɓo naaɗe aan̰ rɛsin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Num gɔtn se, *debm tɛɗn sɛrkɛ Raa ki kalaŋ bini, ɓaaɗo ɓaa te ɗoobm se rɛn̰ sum ɓo, gaŋ kɛn naan̰ aak gaabm tooɗ par se, naan̰ aal cɛɛs ki dɔkɔ uun ɗoobin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tɛr kɔɗ Lɛbi kalaŋ bin kic, aalo te ɗoobm se. Num kɛn naan̰ jaay aan gɔtn se, naan̰ aak gaabm tooɗ par se ɔɔ naan̰ kic aal cɛɛs ki dɔkɔ ɔɔ uun ɗoobin̰ ɓaa kici. ");
INSERT INTO kyq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Num gaŋ kɔɗ Samari kalaŋ bin kic ɓaa ɓaa mɛrtɛ ute ɗoobm se. Kɛn naan̰ jaay aak gaabm tooɗ par se, naan̰ ɛɛjin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naan̰ ɓaaɗo ɔŋin̰a, tugin̰ taan‑dun̰a ute tɔtn koojn̰ bin̰, ɔtin̰ uubu ɔɔ saamin̰sin̰a; jaay ɓo uun ɔndin̰ do buurin̰ ki ɔɔ ɓaansin̰ ɓee bɔɔy mɛrtge tu ɔɔ iŋg don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mɛtbeen̰ki se, naan̰ ɔɔɗ tamma dio, ɛɗ debm tɛɗn mɛrtge tu se ɔɔ ɗeekin̰ ɔɔ: «Gaabm se, aakin̰ don̰ ki. Nakŋ naai utga cir naan̰ se num, maam mꞋtɛrloga se, mꞋutu mꞋaisin̰ kɔgŋ gɔtin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gɔtn se Isa tɔnd mɛtn debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa se ɔɔ: «Maakŋ naai ki num, maakŋ jeege tun mɔtɔ se, gaab kɛn jee ɓoogge tɔndin̰o se kɛn gay ɓo naapin̰a?» ");
INSERT INTO kyq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naan̰ tɛrl Isa ki ɔɔ: «Jaay debm kɛn tɛɗ bɛɛ deb kɛn jee ɓoogge tɔndin̰ se.» Gɔtn se Isa ɗeekin̰ ɔɔ: «Naai kic Ꞌɓaa Ꞌtɛɗ bin kici.» ");
INSERT INTO kyq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kɛn Isa jaay ɓaa ɓaa ɗoob ki ute jee mɛtin̰ ki se, naan̰ ɓaa ɛnd maakŋ naaŋ ki kalaŋ bini, ɔɔ gɔtn se mɛnda kalaŋ ron̰ Mart dɔɔɗ ɔkin̰ ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naan̰ ɔk gɛnaa ron̰ Mari ɔɔ Mari se, ɓaaɗo iŋg mɛtn jɛ Mɛljege tu ɔɔ naan̰ iŋg booy booy taar Mɛljege taaɗ se. ");
INSERT INTO kyq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kɛn Mart jaay naaba ɓaa deel don̰ se, naan̰ ɓaaɗo ɗeek Isa ki ɔɔ: «Mɛluma, aaka gɛnaam se. Naaba se paac ɔn̰umsin̰ dom ki. Kɛse tap ɓo naai an ɗim ey ne? ꞋƊeekin̰ Ꞌɓaaɗo utu am noogo!» ");
INSERT INTO kyq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Num Mɛljege tɛrlin̰ ɔɔ: «Mart, Mart, naai se uun nirli do nakge tun paacn̰ kɛn naai tɛɗ se; taa naan̰ se ɓo naai Ꞌbaate roi tak tak ɔɔ Ꞌtɛɗi ɓaa kaam ara kaam ara. ");
INSERT INTO kyq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Num Mart, Ꞌbooyo. Naka kalaŋ sum ɓo jiga cir paac. Kɛn se ɓo Mari bɛɛr uunga. Num nakŋ Mari bɛɛr uun se, nam an̰sin̰ kɔŋ kɔɔɗ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɓii kalaŋ Isa iŋg gɔtɔ kaam kalaŋ bini, gɛn keem Raa. Kɛn naan̰ jaay eem Raa aas se, maakŋ jeege tun mɛtin̰ ki se, deb kalaŋ ɓaaɗo tɔnd mɛtin̰a ɔɔ: «Mɛlje, Ꞌdooyje gɛn keem Raa aan gɔɔ kɛn Jan dooy jee mɛtin̰ ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isa taaɗɗen ɔɔ: «Kɛn naase jaay aki keem Raa num, Ꞌɗeekki ɔɔki: Bua, ɔn̰ jeege paac ai jeeli naai kali ki sum ɓo Raa. Ɔn̰ naai ɓo kɔsn gaara do jeege tu paac. ");
INSERT INTO kyq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɛɗjeno kɔsn kɛn ajen kaasn ɓii‑raa. ");
INSERT INTO kyq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ꞋTɔɔlje *kusin̰je taa naaje kic ɓo kꞋtɛɗn kalɗɛ jeege tun paacn̰ kɛn tujjenga naaje ki kici. Ɔn̰te Ꞌkɔn̰je kꞋkɛnd maakŋ nakŋ naam ki.» ");
INSERT INTO kyq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gɔtn se Isa ɗeekɗen daala ɔɔ: «Kɛn maakse ki se jaay, deb kalaŋ ɔk mɛɗɛ ɔɔ mɛɗin̰ se ɓaaɗo ɔŋin̰ daan nɔɔr ki ɔɔ tɔnd mɛtin̰ ɔɔ: ‹Mɛɗuma, ɛɗumo tu mappa mɔtɔ, ");
INSERT INTO kyq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","taa maakŋ mɛɗumge tu se, deb kalaŋ ɓaaɗoga mɛrtɛ gɔtum ki, naɓo maam mꞋɔk ɗim mꞋan̰ kɛɗ eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Num kɛn debm maak ki se jaay, tɛrlin̰ ɔɔ: ‹Ɔn̰um, mꞋtooɗn kaam kalaŋ. Ɓɔrse kaam taarum lɛ mꞋgaasin̰ga, ɔɔ maam mꞋute gɛnumge paac kic lɛ, kꞋtooɗga. Bin num, maam se mꞋkɔŋ kiin̰ jaay mꞋai kɛɗn mapp eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gaŋ Ꞌbooyki mꞋasen taaɗa: naan̰ Ꞌkiin̰ an̰ kɛɗ se taa gaaba se mɛɗin̰ sum eyo, num taa naan̰ dɔɔk taar tɔnd mɛta ɔn̰ ey se ɓo, naan̰ Ꞌkiin̰i an̰ kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Maam mꞋɗeeksen mꞋɔɔ: Ꞌlee Ꞌtɔndki mɛta ɔɔ jꞋasen kɛɗa, Ꞌlee Ꞌjeki ɔɔ naase aki kɔŋɔ, Ꞌlee Ꞌtɔndki kaam‑taara ɔɔ jꞋasen kɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ɗeere, debm tɔnd mɛta se jꞋan̰ kɛɗɛ, debm je se Ꞌkɔŋɔ ɔɔ debm tɔnd kaam‑taara se lɛ, jꞋutu jꞋan̰ kɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ꞋSaapki tu, maakse ki se bubm gay jaay, goonin̰ tɔnd mɛtn kɛn̰jɛ gɔtin̰ ki num, naan̰ an̰ kɔŋ kɛɗn wɔɔjɔ ne? ");
INSERT INTO kyq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ey lɛ, kɛn tɔnd mɛtn kaaɓm kɔrɔn̰jɔ se, an̰ kɔŋ kɛɗn iin̰i ne? ");
INSERT INTO kyq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Naasen jeegen kɛn jig ey se kic ɓo Ꞌjeelki kɛɗn nakŋ bɛɛ gɛnsege tu. Num mɛt kando Bubm kɛn maakŋ raa ki Ꞌkɛɗn *Nirl Salal jeege tun tɔnd mɛtin̰ ey ne!» ");
INSERT INTO kyq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gaaba kalaŋ bini ɔk kɔɔn̰ sitan ɔɔ naan̰ ɔŋ taaɗ taar eyo. Ɓii kalaŋ, Isa tuurin̰ sitan se naatn ron̰ ki. Kɛn sitan jaay teec ɔn̰in̰ se, gaabm ɔŋ taaɗ taar ey se baag taaɗn taara cɛy. Ɔɔ kɛn jee dɛnge aak se nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Num gaŋ maakɗe ki se jee kandum ɗeek ɔɔ: «Ute Belzebul, naan̰ kɛn Bubm sitange se ɓo, naan̰ tuur sitange ro jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mɛtin̰gen kuuy se je an̰ naam se, tɔnd mɛtin̰ ɔɔ n̰Ꞌaɗen tɛɗn nakŋ‑kɔɔɓm kɛn naaɗe an kaakŋ jeel ro ki, kɛn bɔɔyo maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gaŋ Isa jeel maak‑saapɗe ɗey se, ɗeekɗen ɔɔ: «Maakŋ taa naaŋ gaar kɛn jeen̰ge taarɗe ɔk mɛtn naap eyo ɔɔ baagga tɛɗn bɔɔrɔ ute naapa se, naaŋ se utu tɛrɛcɛ ɔɔ gɔtin̰ utu Ꞌtooɗn kuuɗu. ");
INSERT INTO kyq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Naase ɔɔki: ute tɔɔgŋ Bubm sitangen Belzebul se ɓo, maam mꞋtuur sitange ro jeege tu. Kɛn Bubm sitange tɛɗ bɔɔrɔ ute ro naan̰ malin̰ se, bin se naan̰ tɔpga ron̰a. Kɛn bin num, gaarin̰ se naan̰ an̰ kɔkŋ ɔɔ ɗio? ");
INSERT INTO kyq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Naase ɔɔki: maam mꞋtuur sitange ute ro Belzebul se; num jee mɛtse ki se, kɛn ɛɗɗen tɔɔgɔ jaay tuur sitange se, naŋa? Bin num naaɗe mala se ɓo asen kɔjn̰ bɔɔrɔ dose ki. ");
INSERT INTO kyq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Num gaŋ kɛn maam jaay mꞋtuur sitange ute tɔɔgŋ Raa ɗeer num, kɛse *maakŋ Gaar Raa se bɔɔy aanga gɔtse ki. ");
INSERT INTO kyq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kɛn debm gaabm bɔɔrɔ jaay iŋg ute bɔɔrin̰ ɓeen̰ ki ɔɔ kɛn naan̰ jaay bɔɔb ɓeen̰ jiga se, maalin̰ge se Ꞌkɔŋ kut eyo. ");
INSERT INTO kyq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Num gaŋ debm kuuy kɛn tɔɔg cirin̰ jaay ɓaaɗo oocin̰ga ɔɔ cirin̰a jaay tɔsn ute bɔɔrin̰gen naan̰ ɔndo do ki se num, maalin̰ge se, naan̰ an̰ tɔsn nigin̰ jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Debm jaay ute maam ey se, naan̰ se debm taamooyuma ɔɔ debm jaay noogum gɛn tusn jeege ey se, debm bin se wɔɔkɗen wɔɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tɛr Isa taaɗɗen ɔɔ: «Kɛn sitan jaay teec ɔn̰ga nam se, naan̰ ɓaa leeɗo do kɔɗ‑ɓaarge tu je gɔtn an tɔɔl maakin̰a naɓo naan̰ jaay ɔŋo te ey se. Kɛn naan̰ jaay ɔŋ te ey num, baag taaɗn ute maakin̰ ɔɔ: ‹Maam se mꞋkɔkŋ mꞋtɛrl gɔtn kɛn mꞋiin̰no ro ki.› ");
INSERT INTO kyq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kɛn naan̰ jaay ɔk tɛrl aan se, ɔŋ ɓee se jꞋɔtin̰ga aac walak ɔɔ nakin̰ge se kꞋrɛɛs kꞋɗaapin̰ga ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gɔtn se naan̰ ɔk tɛrlɛ ɔɔ ɓaa ɔŋo sitangen kuuy cili kɛn kusin̰ cirin̰ naan̰ se daala. Naaɗe ɓaaɗo tɛlɛ ɛnd iŋg maakŋ gaab kɛn se ɔɔ kiŋg gaabm se tɛrl ɓaa tɛɗ kusin̰ cir kɛn deet se daala.» ");
INSERT INTO kyq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kɛn Isa jaay utu taaɗ taaɗ taarin̰ se, mɛnda kalaŋ uun mindin̰ raan daan jee dɛnge tu ɔɔ ɗeekin̰ ɔɔ: «Mɛnd kɛn ooji naai ɔɔ kɛn naai aayo sin̰ se, ɔn̰ maakin̰ Ꞌraapm aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gaŋ Isa tɛrlin̰ ɔɔ: «Jeegen booy taar Raa ɔɔ ɔkin̰ maakɗe ki se ɓo ɔn̰ maakɗege Ꞌraapm cir daala.» ");
INSERT INTO kyq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aan gɔɔ jeege baag tus tɛɗn dɛn se, Isa baagɗen taaɗ ɔɔ: «Jeegen duni kɛn ɓɔrse se, jee jig eyo. Ɔɔ naaɗe je kaakŋ nakŋ‑kɔɔɓɔ, naɓo nakŋ‑kɔɔɓm naaɗe an kaakŋ jeel ro ki se, tecn̰ aan gɔɔ kɛn gɛn Yunus se sum. ");
INSERT INTO kyq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aan gɔɔ nakŋ aan do Yunus ki jaay taaɗ jeege tun Ninib ki taa an kaakŋ jeel ro ki Raa ɓo ɔlin̰o gɔtɗe ki se, *Goon Deba se utu Ꞌtɛɗn bin kici, taa Ꞌtaaɗn jeege tun duni kɛn ɓɔrse se, an Ꞌkaakŋ jeel ro ki naan̰ kic Raa ɓo ɔlin̰o. ");
INSERT INTO kyq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɓii kɛn Raa an kɔjn̰ bɔɔrɔ do jeege tu se, nɛɛlgen iin̰o kaam kaam bɔɔyɔ gɔtn duni ɗaar ro ki se utu kɔkŋ mind jeegen duni kɛn ɓɔrse se. Taa naan̰ iin̰o gɔtn dɔkɔ gɛn booy taar Gaar Salomon debm jeel‑taara se, ɔɔ Ꞌbooyki, debm jeel‑taar ara se, cir Salomon se daala. ");
INSERT INTO kyq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɓii kɛn jaay Raa an kɔjn̰ bɔɔrɔ do jeege tu se, jeegen Ninib ki se kic utu Ꞌkɔkŋ mind jeegen duni kɛn ɓɔrse. Taa naaɗe se booy uunga taar Yunus ɔɔ tɛrlga maakɗe do Raa ki, anum Ꞌbooyki, debm ara se cir Yunus se daala.» ");
INSERT INTO kyq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tɛr Isa taaɗɗen ɔɔ: «Nam jaay ɔɔcga lɔɔmpɔ num ɔyin̰ mɛtn ɗim ki eyo ey lɛ deebin̰ ute ɗim eyo, num jꞋuun jꞋɔlin̰ raan ro kaag ki taa jee ɛnd gɔtn ese Ꞌkaakŋ gɔtn wɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kaami se, naan̰ ɓo lɔɔmpɔn gɛn roi. Bin num kɛn kaami jaay lapi se, roi te dɛnin̰ paac kic iŋg maakŋ gɔt kɛn wɔɔrɔ. Num kɛn kaami jaay kɔɔn̰ɔ num, roi ute dɛnin̰ paac kic maakŋ gɔt kɛn ɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bin se, ɔnd kɔndɔ ute gɔtn wɔɔr kɛn naai ɔkse, ɔn̰te kɔn̰in̰ Ꞌtɛɗn gɔtn ɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kɛn kiŋgi jaay paac iŋg gɔt kɛn wɔɔr se ɔɔ kɛn ɗim ɔɔɗ cɔkɔ kic gɔtɔ roi ki num, bin se, kiŋgi ute dɛnin̰ paac se, Ꞌtɛɗn gɔtn wɔɔrɔ aan gɔɔ lɔɔmpɔn kɛn lee wɔɔri gɔtɔ kɛlɛŋ se.» ");
INSERT INTO kyq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kɛn Isa utu taaɗ taaɗ ɓɔrt sum ɓo, kɔɗ Parizi kalaŋ bini daŋin̰ ɔɔ kꞋɓaa kɔsn ɓeen̰ ki. Kɛn naaɗe jaay aan se, naaɗe tooɗ ute cɛɛsɗe jaay ɓo baag kɔsɔ do tabil ki. ");
INSERT INTO kyq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kɛn kɔɗ Parizi jaay aak Isa tug te jin̰ aan gɔɔ kɛn naaɗe lee tug se ey sum ɓo, baag kɔsɔ se, naan̰ aak se ɔkin̰ taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gɔtn se Mɛljege ɗeek kɔɗ Parizi ki ɔɔ: «Naase Parizige se, naase Ꞌtugki naagŋ nakgen naase Ꞌlee aayki ɔɔ ɔsnki se aac walak, num gaŋ maakin̰ tap ɓo ɔn̰in̰ki ɗooc ute saapm gɛn ɓoogo ute nakgen *kusin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kalɛ jee dɛrlge! Raa kɛn ɔɓo daa roi se, kɛn maak ki kic naan̰ ɓo debm kɔɓin̰ ey la? ");
INSERT INTO kyq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nakŋ naase ɔkki maakŋ baay kɔssege tu se, ɛɗin̰ki *sɛrkɛ jee daayge tu, bin jaay ɓo maakse Ꞌtɛɗn aak bɛɛ naan Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Num naasen Parizige utu asen tɛɗn ɔɔn̰ aak eyo, taa nakgen naase ɔkki sɛɛm sɛɛm kɛn Ꞌlee tɔmbki maakŋ taaɗsege tu kɛn tɛɗin̰ nijimi ute naksegen maakŋ jinɛn ki se kic ɓo, naase Ꞌlee Ꞌnigin̰ki gɔtɔ kaam sik ɔɔ kɛn kaam kalaŋ se, naase Ꞌlee ɛɗin̰ki Raa ki. Naɓo naase Ꞌtɛɗki nakge ute ɗoobin̰ eyo ɔɔ Ꞌjeki Raa eyo. Bɛɛki num, naase aki tɛɗn nakgen ute ɗoobin̰a ɔɔ aki je Raa jaay ɓo, naksegen kɛn naase Ꞌlee ɛɗki sɛrkɛ Raa ki sɛɛm sɛɛm se kic ɓo, ɔn̰ten Ꞌdirigin̰ki kici. ");
INSERT INTO kyq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Naasen Parizige utu asen tɛɗn ɔɔn̰ aak eyo, naasen kɛn Ꞌɓaakiga maakŋ *ɓee kɛn Yaudge lee tusn maak ki se, Ꞌjeki ɔɔki naase ɓo aki kiŋg naan ki. Ɔɔ kɛn aankiga bɔɔr ki kic lɛ, Ꞌjeki ɔɔki jeege ɓo asen tɛɗn tɔɔsɛ naase ki ɓo deete. ");
INSERT INTO kyq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Utu asen tɛɗn ɔɔn̰ aak eyo, naasen kɛn Ꞌtecki aan gɔɔ yogen kꞋduubɗe maakŋ ɓaaɗ ki kɛn jeege ɔŋ aakɗe eyo, jaay lee do ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gɔtn se debm jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raa kalaŋ bini ɗeek Isa ki ɔɔ: «Debm dooy jeege, taar kɛn naai iŋg Ꞌtaaɗ se, kɛse naai Ꞌnaajjen naaje kici.» ");
INSERT INTO kyq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Gaŋ Isa tɛrlin̰ ɔɔ: «Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se utu asen tɛɗn ɔɔn̰ aak ey kici, taa naase Ꞌtuun Ꞌtɔndki daam deer se do jeege tu, num naase, ute goon jisen baat se kic ɓo utin̰ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Utu asen tɛɗn ɔɔn̰ aak eyo naasen Ꞌlee iin̰ Ꞌɗaapki do ɓaaɗn jee taaɗ taar teeco taar Raa ki do dɔkin̰a ɔɔ naaɗe se ɓugsege ɓo kɛn tɔɔlɗeno. ");
INSERT INTO kyq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kɛn bin num, naase ute bubsege se taarse kalaŋ; jee taaɗ taar teeco taar Raa ki se, naaɗe ɓo jee tɔɔlɗeno ɔɔ naase ɓo jee kiin̰ do ɓaaɗɗege. ");
INSERT INTO kyq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Taa naan̰ se ɓo, Raa kɛn jeel‑taar mala mala se taaɗo ɔɔ: MꞋutu mꞋaseno kɔl jee taaɗ taar teeco taarum ki ute jee kaan̰ naabumge ɔɔ mɛtin̰ge naaɗe utu aɗen tɔɔlɔ ɔɔ mɛtin̰gen kuuy se, naaɗe utu aɗen dabara. ");
INSERT INTO kyq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Taa naan̰ se ɓo, jee duni kɛn ɓɔrse se, taa moosn jeegen taaɗ taar teeco taar Raa ki se, naan̰ utu aɗen kɔkŋ mindɗe do yoɗege tun baago kaaɗ kɛn Raa utu aalo kaal do dunia, ");
INSERT INTO kyq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kɛn iin̰o do yo Abɛl ki bini aan do yo Zakari, kɛn kꞋtɔɔlin̰o daan *gɔtn kɛn kꞋlee kꞋtɛɗn sɛrkɛ Raa ki ute *Ɓee Raa. Ɗeere, Ꞌbooyki mꞋasen taaɗa: jee duni kɛn ɓɔrse se Raa utu aɗen kɔkŋ mindɗe. ");
INSERT INTO kyq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Naasen jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se utu asen tɛɗn ɔɔn̰ aak eyo! Taa naase Ꞌgaaskiga ɗoobm kɛn Ꞌkɔl jeege gɔtn Raa ki ɔɔ naase malin̰ge lɛ Ꞌbaate kɛndki, ɔɔ jeegen je kɛndɛ se lɛ, naase Ꞌgaasɗeki ɗoobo.» ");
INSERT INTO kyq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kɛn Isa jaay taaɗ naŋ taarin̰a ɔɔ teeco teec gɔtn ese se, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute Parizige se iin̰ ron̰ ki cɛy ɔɔ naaɗe baag tɔnd mɛtin̰ do taarge tu dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Do taarge tun Isa taaɗ se, naaɗe goomin̰ kɛn naan̰ jaay taaɗ tujin̰ga num, naaɗe an̰ kɔkŋ mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kaaɗ kɛn se, jeege tus dupu kando kando bini baag tuum naapa. Gɔtn se Isa baag taaɗn jeege tun mɛtin̰ ki se ɓo deete ɗeekɗen ɔɔ: «Naase se, ɔndki kɔndɔ ute ɔrɔm *Parizige. Ɔrɔm naaɗe se je taaɗn ɔɔ naaɗe tɛɗ roɗe aan gɔɔ naaɗe ɓo jee taaɗ taar mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","«Taa kaaɗin̰ jaay utu Ꞌkaan se, nakŋ paacn̰ jꞋɔyin̰ga kɔy se, utu tooɗn tal. Ɔɔ nakŋ ɓɔrse kꞋjeelki mɛtin̰ ey se, jꞋutu jꞋan̰ki jeele. ");
INSERT INTO kyq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bin ɓo, nakŋ paacn̰ naase Ꞌtaaɗin̰ki maakŋ nɔɔr ki se, Ꞌɓaa Ꞌtaaɗin̰ki jeege tu ute kaam kaaɗa. Nakŋ kɛn naase Ꞌbooyin̰ki kꞋtaaɗsen naaŋ ki mɛtn bisege tu maakŋ ɓee ki se, Ꞌwɔɔkin̰ki do ɓeege tu kici. ");
INSERT INTO kyq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mɛɗumge, taar se maam mꞋtaaɗsen naase ki: ɔn̰te Ꞌɓeerki jeege tun Ꞌtɔɔl daa roa, num mɔɔtn asen kɔŋ tɛɗn ɗim ey se. ");
INSERT INTO kyq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Num Ꞌbooyki mꞋasen taaɗn debm kɛn naase an̰ki ɓeere: Ꞌɓeerki deb kɛn ooykiga kic ɓo, naan̰ ɔk tɔɔgŋ kɛn asen kɔl maakŋ pooɗ kɛn gɛn daayum. Ɗeere, Ꞌbooyki mꞋasen taaɗa: kɛse ɓo debm kɛn naase an̰ki ɓeere. ");
INSERT INTO kyq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«ꞋJeelki, yeelge sɛɛm sɛɛm mii se kꞋdugin̰ ute kɔbɔrɔ di sum ey la? Ute naan̰ se kic ɓo, *Raa ɔŋ dirig kalaŋ maakɗe ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Num gaŋ naase se bini bɛɛkŋ dosege se kic ɓo, Raa jeelin̰ kalaŋ kalaŋ. Bin se, ɔn̰te Ꞌɓeerki! Naan Raa ki se naase Ꞌcirki yeelge se dɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«ꞋBooyki mꞋasen taaɗa: debm taaɗ naan jeege tu ɔɔ naan̰ debm maam se, maam *Goon Deba kic ɓo maam mꞋtaaɗn naan *kɔɗn Raage tu mꞋɔɔ naan̰ se debm maama. ");
INSERT INTO kyq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Num debm kɛn baatum naan jeege tu se, maam kic mꞋutu mꞋan̰ baatin̰ naan kɔɗn Raage tu. ");
INSERT INTO kyq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɔɔ debm kɛn tuj taarin̰a ro Goon Deb ki se, Raa an̰ tɔɔl *kusin̰in̰ ese se; num debm kɛn jaay naaj *Nirl Salal se, naan̰ se Raa an̰ tɔɔl kusin̰in̰ se eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kɛn naase jaay kꞋtɔk kꞋɓaansenga maakŋ *ɓee kɛn Yaudge lee tusn maak ki se ey lɛ naan gaarin̰ge tu ɔɔ gɔtn tɔɔgge tu se num, naase ɔn̰te Ꞌɓeerki do taar kɛn naase aki ɓaa taaɗn naanɗe ki kɛn anki nakŋ kɔɔɗn dose. ");
INSERT INTO kyq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Taa kaaɗ kɛn se, Nirl Salal ɓo asen kɔl naase aki jeel taaɗn taara naanɗe ki.» ");
INSERT INTO kyq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Maakŋ jee dɛnge tu se, deb kalaŋ bini ɓaaɗo ɔŋ Isa ɔɔ ɗeekin̰ ɔɔ: «Debm dooy jeege, gɛnaam se ɔl nam ɓaa Ꞌtaaɗin̰, n̰Ꞌɓaaɗo num maal bubje se ɔn̰ naai ɓo ajesin̰ nigi.» ");
INSERT INTO kyq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Gɔtn se Isa tɛrlin̰ ɔɔ: «Debm kɛn ɔndum gɛn kaakŋ mɛtn taarsege ey lɛ gɛn nigŋ maalsege se, tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tɛr naan̰ taaɗ jeege tu paac ɔɔ: «Ɔndki kɔndɔ! Ɔɔ naase se ɔndki dose daan ki, bɔɔbki rose ro tama ki. Taa debkilim se, maalin̰ dɛn aan gɔɔ ɗi kic ɓo, kɛn ɔlin̰ iŋg se, maalin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gɔtn se tɛr Isa taaɗɗen ute kaal naagŋ taara ɔɔ: «Debm maala kalaŋ bin se, maakŋ gɔtin̰ ooj tuun karat karat. ");
INSERT INTO kyq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kɛn naan̰ aak nakin̰ jaay ooj dɛn se, naan̰ baag taaɗn ute maakin̰ ɔɔ: ‹Ɓaar jaaki tap ɓo, maam mꞋtɛɗn rom mꞋɔɔ ɗi? Ɓɛrɛ, gɔtn am kaasn mꞋan kɔmb nakumge se lɛ gɔtɔ.› ");
INSERT INTO kyq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tɛr naan̰ taaɗ ute maakin̰ ɔɔ: ‹Ɓɔrse, kɛse ɓo nakŋ maam mꞋutu mꞋtɛɗa: giijumge se mꞋaɗen tɔɔkŋ paac naatn ɔɔ mꞋkɔɓm kɛngen kuuy magala magala cir naaɗege se daala. Kɛn mꞋɔɓɗenga jaay aasga num, teen̰umge ute nakumge paac se, mꞋaɗen tusn kɔmb maak ki. ");
INSERT INTO kyq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Gɔtn se maam mꞋɗeekŋ rom ki mꞋɔɔ: ai roma, Ꞌtɔɔl kɔɔri gɛn ɓaara ɓaara, taa kɔsɔ ute kaayi lɛ, dɛna. Taa naan ki se maam mꞋkɔsɔ, mꞋkaaye ɔɔ mꞋtɛɗ nakgen kɛn maakum jea.› ");
INSERT INTO kyq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Num gaŋ Raa ɗeekin̰ ɔɔ: ‹Kalɛ debm dɛrlɛ, maakŋ nɔɔr kɛn ese sum ɓo, naai lɛ Ꞌkooyo; num nakigen naai Ꞌtusin̰ se, tap ɓo Ꞌkɔɔpm naŋ ki?› ");
INSERT INTO kyq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ꞋBooyki! Kɛse nakŋ kɛn utu Ꞌkaan do deb kɛn tusn maala dɛna do duni ki, naɓo naan Raa ki se, naan̰ ɔk ɗim ey se.» ");
INSERT INTO kyq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gɔtn se Isa taaɗ jeege tun mɛtin̰ ki ɔɔ: «Taa naan̰ se ɓo, maam mꞋɗeeksen mꞋɔɔ: taa kose se ɔn̰ten Ꞌkuunki nirlse taa nakŋ naase aki kɔsɔ ɔɔ taa rose se ɔn̰ten Ꞌkuunki nirlse do kal kɛn naase aki tuusu. ");
INSERT INTO kyq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Taa kose se, naan̰ cir nakŋ kɔsɔ ɔɔ rose se lɛ, naan̰ cir kala. ");
INSERT INTO kyq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aakki tu gaakge se; naaɗe lɛ ɔɔc eyo ɔɔ ɔk teen̰ gɛn kɔj eyo ɔɔ giiji lɛ, naaɗe ɔk eyo ɔɔ gɔtn kɔmb kɔrbɔtɗe kic ɓo, naaɗe ɔk eyo. Ute naan̰ se kic ɓo, Raa ulɗe. Num naase se mɛt kando yeelge se, naase Ꞌcirɗeki? ");
INSERT INTO kyq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maakse ki se, naŋa jaay ute kuun nirlin̰ sum ɓo Ꞌkɔŋ ziiɗn ɓii kiŋgin̰ do naaŋ ki ne? ");
INSERT INTO kyq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kɛn ese jaay naase ɔŋ aasin̰ki te ey num, gɛn ɗi jaay naase uunki nirlse do nakge tun ɔɔp ɓaa se? ");
INSERT INTO kyq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Aakki tu pɔɔn̰ nakgen taak bɛɛ maakŋ kaag ki se; naaɗe se ɔɓ kuubu eyo ɔɔ ɔnd cɛkɛ eyo. Naɓo Ꞌbooyki mꞋasen taaɗa: Gaar Salomon do dɔkin̰ se, ute maalin̰ dɛn paac se kic ɓo, ɓii kalaŋ ɔŋ uus te kal aak bɛɛ tec aan gɔɔ gɛn naaɗe se eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mu jaaki ɗaar maakŋ kaag ki ɔɔ mɛtbeeki sum ɓo jꞋutu jꞋan̰ tɔɔc se kic ɓo Raa tamarin̰ aak bɛɛ bɛɛ se, mɛt kando asen kɔŋ kɛɗn kal tuusu naase ki ey ne? Ɓɛrɛ, naase se jee kɛn aalki te maakse paac do Raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ɔɔ ɔn̰te Ꞌkuunki nirlse gɛn je nakŋ naase aki kɔsɔ ɔɔ aki kaaye. ");
INSERT INTO kyq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nakgen bin se paac, jee jeel Raa mal ey ɓo daayum iŋg saap do ki. Ey num, Bubsen maakŋ raa ki se jeele nakŋ kɛn naase Ꞌjeki. ");
INSERT INTO kyq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Num naase se Ꞌjeki ɓo Raa kɔsn gaara dose ki ɔɔ nakgen ɔɔp se, naan̰ asesin̰ kɛɗn do ki. ");
INSERT INTO kyq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Naasen dɔɔl baatgen cɔkɔ ara, ɔn̰te Ꞌɓeerki! Taa Bubsen maakŋ raa ki se, nakŋ kɛn tɔɔlin̰ naan̰ ki se, naase utu aki kiŋg ute naan̰a maakŋ gaarin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Bin se, nakŋ naase ɔkki se, dugin̰ki naatn ɔɔ gursin̰ se, ɛɗin̰ki *sɛrkɛ jee daayge tu. Bin se gɔɔ naase ɔmbkiga naksege gɔtn Ꞌkɔŋ Ꞌtuj eyo ɔɔ daayum asen tooɗn kɔrbɔtɔ maakŋ raa ki. Gɔtn naane se, debm ɓoogo gɔtɔ ɔɔ k‑n̰ɔɔ kic ɓo an̰ kɔŋ tuj eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Taa gɔtn maalse ro ki se, gɔtn ese ɓo maak‑saapse iŋg ro ki kici.» ");
INSERT INTO kyq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Iŋgki daayum ute kal tɛɗn naabse rose ki, ɔɔ ɔn̰te Ꞌkɔn̰ki lɔɔmpsege Ꞌkooyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ɔɔ naase iŋgki aan gɔɔ jeegen kɛn iŋg aak kaak kaam mɛlɗen kɛn utu aɗe tɛrl gɔtn kɔkŋ mɛnd ki se. Taa kɛn naan̰ jaay aanga ɔɔ tɔndga kaam taara num, naaɗe an̰ naar kɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maak‑raapo naaɗe kɛn mɛlɗe ɓaaɗo ɔŋɗega jaay naaɗe utu iŋg kiŋg zɛɛr se. ꞋƁooyki bɛɛ mꞋasen taaɗa: mɛlɗe se, naan̰ mala Ꞌkuun kuusn kal tɛɗn naabin̰a aɗen kɔŋ naaŋ ki ɔɔ naan̰ ɓo aɗen kɛɗn kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maak‑raapo naaɗe kɛn mɛlɗe Ꞌkaan daan nɔɔr ki lɔ do mɛtbeeki kɛn aɗen kɔŋ naaɗe utu iŋg zɛɛr se. ");
INSERT INTO kyq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Naase Ꞌjeelki, kɛn mɛl ɓee jaay jeel kaaɗn debm ɓoogo ano ɓaa num, naan̰ Ꞌkɔn̰ ɓeen̰ se debm ɓoogo an̰ tɛrɛc eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naase kic Ꞌɗaapki rose, iŋgki do mɛtɛkse ki, taa kaaɗn kɛn *Goon Deba jaay aɗe ɓaa se lɛ, naase Ꞌjeelki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Gɔtn se Piɛr tɔnd mɛtin̰ ɔɔ: «Mɛluma, kaal naagŋ taar kɛn naai taaɗ se, taaɗ ute naaje sum lɔɓu ute jeege paac lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mɛljege tɛrlin̰ ɔɔ: «Debm tɛɗn naabm mɛtɛkɛ ɔɔ tuj ɔrmin̰ ey se kɛn gay? Naan̰ ɓo debm kɛn mɛlin̰ utu an̰ kɔn̰ jee tɛɗn naabgen kuuy kaam jin̰a ɔɔ kɛn aanga kaaɗin̰ ki num, aɗen lee Ꞌnigŋ nakŋ kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maak‑raapo debm tɛɗn naab kɛn mɛlin̰ aan jaay ɔŋin̰ naan̰ utu tɛɗin̰ tɛɗn naabm kɛn naan̰ ɔn̰in̰sin̰ kaam jin̰ se. ");
INSERT INTO kyq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ꞋBooyki bɛɛ mꞋasen taaɗa: debm tɛɗn naabm bin se, mɛlin̰ utu an̰ kɔn̰ nakin̰ge paac kaam jin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Num gaŋ kɛn debm tɛɗn naabm se jaay taaɗ ute maakin̰ ɔɔ: Mɛlum se aɗe kɔŋ tɛrl yɔkɔɗ eyo, ɔɔ gɔtn se naan̰ iin̰ baag tɔnd jee tɛɗn naabgen mɛndge ute gaabge, jaay naan̰ ɔsɔ ɔɔ aay oono. ");
INSERT INTO kyq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Gaŋ mɛl gaabm ese se, ɓiin jaay naan̰ ano tɛrl se, naan̰ ɔnd eyo ɔɔ kaaɗ kɛn naan̰ aan kaan kic lɛ, naan̰ saap do ki eyo. Kɛn mɛlin̰ jaay aanga num, utu an̰ tuur naata ɔɔ an̰ kɔlin̰ Ꞌdabar ute jee kɛn baate kaal maakɗe do Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Debm tɛɗn naabm kɛn jeel naabm kɛn mɛlin̰ maakin̰ jen ro ki se, naɓo ɔŋ tɛɗin̰ te ey se, naan̰ se mɛlin̰ utu an̰ kɔnd dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","«Num gaŋ debm tɛɗn naabm jeel eyo naabm kɛn mɛlin̰ maakin̰ jen ro ki se, kɛn naabin̰ se jaay tujga kic num, jꞋan̰ kɔndin̰ kaam dɔɔɗin̰ki sum. «Taa naan̰ se ɓo, debm kɛn jꞋɛɗin̰ga nakge dɛn num, kꞋje gɔtin̰ ki kic ɓo dɛna ɔɔ debm kɛn jꞋɔn̰in̰ga nakge dɛn kaam jin̰ se, jꞋutu kꞋtɔnd mɛtn nakge dɛna gɔtin̰ ki kici.» ");
INSERT INTO kyq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Isa taaɗ ɔɔ: «Maam se mꞋɓaano ute pooɗo do naaŋ ki ɔɔ mꞋje pooɗn se Ꞌkɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kɔr naan̰ se kaan se, maam mꞋɔk *batɛm dubar kɛn maam mꞋutu mꞋbatizi. Naan̰ se ɓo, nakŋ deerum kɛn iŋg booyum bini mꞋutu mꞋan̰ tɛɗn Ꞌkaasn jaay se. ");
INSERT INTO kyq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Ɔn̰ten Ꞌsaapki ɔɔki maam se mꞋɓaano ute lapia ɓo do naaŋ ki. Gɔtɔ! ꞋBooyki, mꞋasen taaɗa: maam se mꞋɓaaɗo ɓo gɛn gaaŋ jeege ute naapa. ");
INSERT INTO kyq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Taa naan̰ se ɓo, naan ki se, jee maakŋ ɓeeɗe ki mii se utu gaaŋ ute naapa. Maakɗe ki se, jee mɔtɔ taarɗe Ꞌkɔŋ kɔkŋ mɛtn naapa ute jee di eyo ɔɔ jee di se kic ɓo taarɗe Ꞌkɔŋ kɔkŋ mɛtn naapa ute jee mɔtɔ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Naaɗe utu gaaŋ ute naapa: bubu se, utu Ꞌgaaŋ te goonin̰ gaaba ɔɔ goon gaaba se, utu Ꞌgaaŋ ute bubin̰ kici; ko se, utu Ꞌgaaŋ ute goonin̰ mɛnda ɔɔ goon mɛnda se, utu Ꞌgaaŋ ute kon̰a kici. Moom mɛnda se, utu Ꞌgaaŋ ute mɛnd goonin̰a ɔɔ mɛnd goono se, utu Ꞌgaaŋ ute moomin̰ mɛnda kici.» ");
INSERT INTO kyq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isa taaɗ jee dɛnge tu daala ɔɔ: «Kɛn naase jaay aakkiga gapara ɔsga mɛtn raa ki num, ɓɔrse sum ɓo naase naar ɔɔki maane utu aɗe ɓaao. Ɔɔ maane se ɓaaɗo ɗeere. ");
INSERT INTO kyq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kɛn naase jaay aakkiga kuulu baagga kɔl ɓaa kaam kaam bɛrɗe se, naase ɔɔki, jaaki se gɔtɔ utu Ꞌkɔŋgɔ ɔɔ gɔtɔ ɓaaɗo ɔŋg ɗeere. ");
INSERT INTO kyq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kɛn naase jaay Ꞌjeelki kaakŋ jeel kaaɗn nakgen kɛn tɛɗ do naaŋ ki, ute kɛn tɛɗn maakŋ raa ki num, Ꞌtɛɗ ɔɔ ɗi jaay Ꞌjeel ɔkki mɛtn nakgen kɛn deel daanse ki ey se? Naase se jee kɛn saap ɔkki mɛtn nakge eyo. ");
INSERT INTO kyq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Gɛn ɗi jaay naase ɔŋ aak ɔkki mɛtn nakgen gɛn tɛɗ ute ɗoobin̰ ey se? ");
INSERT INTO kyq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taa naan̰ se ɓo, kɛn naai Ꞌɓaa ɓaa gɔtn kɔjn̰ bɔɔr ki num, ɗoob ki se, ute debm taamooyi se naai ai kaami ɗaap taari. Ey num, ɓɛrɛ, naan̰ ai ɓaa kɔli gɔtn debm kɔjn̰ bɔɔr ki ɔɔ debm kɔjn̰ bɔɔrɔ se lɛ ai kɔli gɔtn asgarge tu ɔɔ asgarge se, ai kɔkŋ kɔli daŋgay ki. ");
INSERT INTO kyq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ꞋBooy mꞋai taaɗa: nakŋ doi ki paac se, bini kɔbɔrɔ kic ɓo ɔg naŋin̰ te ey se, naai Ꞌkɔŋ teecn̰ maakŋ daŋgay ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kaaɗ kɛn se, jee mɛtin̰ge ɓaaɗo taaɗ Isa ki taa Galilegen ɓaaɗo tɛɗn *sɛrkɛ jaay ɓo, Pilat tɔɔlɗe kaaɗ kɛn naaɗe tɛɗ tɛɗ sɛrkɛ se. ");
INSERT INTO kyq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Gɔtn se Isa tɛrlɗen ɔɔ: «Saapm naase ki num, ɔɔki Galilegen kɛn Pilat tɔɔlɗe se ɓo, tɛɗga jee *kusin̰ cir Galilegen ɓaa se paac la? ");
INSERT INTO kyq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gɔtɔ! ꞋBooyki mꞋasen taaɗa: kɛn naase jaay Ꞌtɛrlki te maakse do Raa ki te ey se, naase paac utu aki Ꞌkutn bin kici. ");
INSERT INTO kyq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lɔ jeegen sik‑kaar‑martn ɓee jɛrlɛ kꞋdaŋin̰ Siloe kɛn ooc doɗe ki jaay tɔɔlɗe se, gɛn naase ki num, jee Jeruzalɛm ki te dɛnɗe se, ɔɔki naaɗen kɛn ooy se ɓo, jee kusin̰ge cir jee ɓaa se paac la? ");
INSERT INTO kyq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gɔtɔ! ꞋBooyki mꞋasen taaɗa: kɛn naase jaay Ꞌtɛrlki te maakse do Raa ki ey se, naase paac utu aki Ꞌkutn bin kici.» ");
INSERT INTO kyq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gɔtn se Isa taaɗ ute kaal naagŋ taara ɔɔ: «Gaaba kalaŋ ɔk ko ba maakŋ jinɛnin̰ ki ɔɔ naan̰ ɓaaɗo je koojin̰a, naɓo ɔŋ te koojin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gaŋ naan̰ ɗeek deb kɛn tɛɗin̰ naaba maakŋ jinɛnin̰ ki se ɔɔ: ‹Aaka, ko kaagŋ se maam mꞋleega ɓaara mɔtɔ ɔɔ mꞋje koojin̰ naɓo mꞋɔŋ eyo. Ɓɔrse ɔg Ꞌgaaŋ undin̰ naatn, taa naan̰ lɛ ɗaar gaas gɔtɔ cɛrɛ sum.› ");
INSERT INTO kyq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Num debm tɛɗn naaba se tɛrlin̰ ɔɔ: ‹Mɛluma, ɔn̰umsin̰ gɛn ɓaara kalaŋ daala; maam mꞋan̰ kuɗn mɛtin̰a ɔɔ mꞋutu mꞋan̰ kɔmb yɛɛn̰ɛ. ");
INSERT INTO kyq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bin sum ɓo ute naan̰ se kɔr ɓaar kuuy se, sɔm utu Ꞌkoojo ɗaam; kɛn naan̰ jaay ooj te ey lɛ, an̰ kɔgŋ kund naatn.›» ");
INSERT INTO kyq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɓii kalaŋ, ɓii sebit ki se, maakŋ *ɓeege tun kɛn Yaudge lee tusn maak ki se, gɔtn se Isa ɓaa ɛnd maakŋ ɓee kɛn kalaŋ ɔɔ baag dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Gɔtn se, mɛnda kalaŋ ɔk kɔɔn̰ sitan ɔɔ gɔtn kɔɔn̰in̰ ɔkin̰ sum se, ɔkga ɓaara sik‑kaar‑marta. Ɔɔ kɔɔn̰in̰ se ɔkin̰ durunin̰ki tɛɗin̰ tap ɓo ɔŋ sɛɛj eyo. ");
INSERT INTO kyq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kɛn Isa jaay aakin̰ se, daŋin̰a ɔɔ taaɗin̰ ɔɔ: «Mɛnda Ꞌbooyo, maam se mꞋɔɔɗiga doi maakŋ kɔɔn̰i kɛn lee dabari se.» ");
INSERT INTO kyq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gɔtn se Isa ɔnd jin̰a do mɛnd kɛn se, ɔɔ mɛnd se naar ɔŋ lapia, iin̰ ɗaara sɛɛj tal ɔɔ baag *nookŋ Raa. ");
INSERT INTO kyq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gaŋ magal ɓee kɛn Yaudge lee tusn maak ki jaay aak Isa ɛɗ lapia mɛnd ki, ɓii sebit ki se, naan̰ maakin̰ taarin̰a. Gɔtn se naan̰ uun mindin̰ raan taaɗ jeege tu ɔɔ: «ꞋBooyki! Naajege se, jꞋɔkki ɓii mɛcɛ gɛn tɛɗn naaba. Bin se, debm je lapia ron̰ num, n̰Ꞌɓaaɗo daan ɓiige tun se. Ey num ɓii sebit se, ɓii tɛɗn naab eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Gaŋ Mɛljege tɛrlin̰ ɔɔ: «Aak jeegen kɛn tɛɗ roɗe aan gɔɔ jee taaɗ taargen mɛt ki ara! Maakse ki se, naŋa jaay aanga ɓii sebit ki num, kɔŋ kɔn̰ maraŋin̰a ey lɛ buurin̰a mɛtn bɛlɛn̰ ki ɔɔ an̰ tuutn gɛn ɓaa kɛɗn maan ey se? ");
INSERT INTO kyq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Num mɛnd se lɛ, naan̰ mɛtjil *Abraam mala, ɔɔ aaka, gɔtn *Ɓubm sitange ɔkin̰ sum se ɔkga ɓaara sik‑kaar‑marta. Bɛɛki num, ɓii sebit ki se ɓo, jꞋan̰ kɔɔɗn don̰a maakŋ ji Bubm sitange tu se ey la?» ");
INSERT INTO kyq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kɛn jee taamooyin̰ge jaay ɓaa booy taar se, sɔkɔn̰ɔ ɓaa tɔɔlɗe; gaŋ jee dɛngen aak nakŋ‑kɔɔɓgen paacn̰ naan̰ tɛɗ se, maakɗe raapo. ");
INSERT INTO kyq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gɔtn se, Isa tɛr taaɗɗen daala ɔɔ: «Kɛn Raa utu Ꞌkɔsn gaar do jeege tu tap ɓo Ꞌtecn̰ aan gɔɔ ɗi? Maam mꞋan̰ kɔmb bɛyɛ ute ɗi? ");
INSERT INTO kyq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","*Maakŋ Gaar Raa se, tecn̰ aan gɔɔ kaam nakŋ kꞋdaŋin̰ mutardn ese se, kɛn gaaba kalaŋ uun ɔɔcin̰ maakŋ jinɛnin̰ ki. Kɛn naan̰ jaay ɔɔcin̰ sum se, naan̰ teece ɔɔ teep tɛɗ ko kaaga. Bini yeelge kic ɓo ɓaaɗo uj kujɗege tɛlɛtin̰ge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Isa ɗeek daala ɔɔ: «*Maakŋ Gaar Raa se tap ɓo mꞋan̰ kɔmb bɛyɛ ute ɗi? ");
INSERT INTO kyq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Naan̰ se tec aan gɔɔ ɔrɔm kɛn mɛnda jaay tɔs rujn̰ gɛmɛ ɗooc gɔrn magala ɔɔ kɛn naan̰ jaay deepin̰ga ɔɔ ɔmbin̰ga maak ki num, iin̰in̰ paac se.» ");
INSERT INTO kyq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kɛn Isa jaay ɓaa ɓaa Jeruzalɛm ki se, naan̰ aal teeco maakŋ gɛgɛrge tu ɔɔ maakŋ naaŋge tu ɔɔ naan̰ kɛn se, naan̰ lee dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Gɔtn se nam kalaŋ bini tɔnd mɛtin̰ ɔɔ: «Mɛluma, jee kɛn utu kaaj se, baat ey ne?» Gɔtn se Isa tɛrlɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Aayki kaamse ɛndki ute taa ɗoobm baata, taa maam mꞋɗeeksen mꞋɔɔ: jeege dɛna utu Ꞌje ɗoobm Ꞌkɛndɛ naɓo naaɗe an̰ kɔŋ kaas eyo. ");
INSERT INTO kyq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kɛn kaaɗin̰ jaay utu kaan se, mɛl ɓee utu kiin̰i ɔɔ Ꞌgaasn kaam taarin̰a ɔɔ naasen aki kɔɔpm naatn se aki baagŋ tɔnd kaam taara aki ɗeekŋ ɔɔki: Mɛlje, ɔɔɗjen kaam taara! Gaŋ naan̰ maak ki se asen tɛrl ɔɔ: Naase tap ɓo, iin̰kiro gayo? Maam se, mꞋjeelsen eyo. ");
INSERT INTO kyq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kaaɗ kɛn naane se, naase an̰ki taaɗn ɔɔki: naaje se jꞋɔso ɔɔ jꞋaayo ute naai tɛlɛ ɔɔ naai dooy jeege daan ɗoobjege tu kici. ");
INSERT INTO kyq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gaŋ naan̰ utu asen tɛrl ɔɔ: Naase iin̰kiro gay gay se, maam mꞋjeelsen eyo. Iikki naatn cɛɛm ki dɔkɔ, naasen paacn̰ jee tɛɗn *kusin̰ge se! ");
INSERT INTO kyq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gɔtn naane se, naase aki ɓaa keeme ɔɔ aki taan̰ naaŋsege kɛn aki ɓaa kaakŋ *Abraam, Isak ɔɔ *Yakub ute jee taaɗ taar teeco taar Raa ki paac maakŋ Gaar Raa ki; naɓo naase se, jꞋasen tuur naatn. ");
INSERT INTO kyq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓii kɛn se, jee mɛtin̰ge se aɗe kiin̰ gɔtn kaaɗa tookŋo ɔɔ jee mɛtin̰ge se aɗe kiin̰ gɔtn kaaɗa toocn̰ni, ɔɔ kɛngen mɛtin̰ge aɗe kiin̰ kaam kaam kooko ɔɔ kɛngen kuuy se aɗe kiin̰ kaam kaam bɔɔyɔ, ɔɔ paac naaɗe aɗe ɓaa utu tusn Ꞌkiŋg kɔsn ɓii laa ki ute maak‑raapo maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ꞋBooyki! Bin ɓo, jee kaam mɔɔtn se ɓo, utu Ꞌtɛɗn jee deet deete ɔɔ jee deet deet se ɓo, utu Ꞌtɛɗn jee kaam mɔɔtn.» ");
INSERT INTO kyq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naan̰ kɛn se sum ɓo, *Parizige kandum bini ɓaaɗo ɔŋ Isa ɔɔ ɗeekin̰ ɔɔ: «Ɓɛrɛ, iin̰ gɔti ki se Ꞌɓaa; taa Ɛrɔd se lɛ je ai tɔɔlɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isa tɛrlɗen ɔɔ: «ꞋƁaa ɔŋki k‑bukumbɔɔ kɛn ese ɔɔ Ꞌtaaɗin̰ki ɔɔki: ꞋBooyo, maam se mꞋtuur tuur sitange ɔɔ mꞋɛɗ kɛɗ lapia jee kɔɔn̰ge tu jaaki ɔɔ mɛtbeeki; ɔɔ maakŋ ɓii k‑mɔtɔge tu se, maam mꞋnaŋ naabuma. ");
INSERT INTO kyq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bin num, jaaki, mɛtbeeki ɔɔ pɛlɛn̰ se, maam mꞋɓaa ute naanuma, taa ɗoobin̰ eyo kɛn debm taaɗ taar teeco taar Raa ki jaay Ꞌkooy Jeruzalɛm ki ey se.» ");
INSERT INTO kyq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Isa ɗeek ɔɔ: «Waay Jeruzalɛm, waay Jeruzalɛm, naai kɛn debm tɔɔl jee taaɗ taar teeco taar Raa ki ɔɔ jee kɛn Raa ɔlɗeno gɔti ki kic ɓo, naai ɓo debm tund tɔɔlɗe! Mɛt kando, maam mꞋje mꞋtusn gɛnige aan gɔɔ ko kɔrɔn̰j kɛn lee tus gɛnin̰ge taa bɛɛkŋ kɛyin̰ ki se, naɓo naase Ꞌjeki te eyo. ");
INSERT INTO kyq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ꞋBooyki! *Ɓee Raase se utu Ꞌtooɗn kuuɗu. ꞋBooyki mꞋasen taaɗa: naan ki se, naase Ꞌje amki kaak kic ɓo amki Ꞌkɔŋ eyo, bini utu Ꞌkaan kaaɗ kɛn naase utu aki ɗeekŋ ɔɔki: Ɔn̰ Mɛlje Raa tɛɗn bɛɛn̰a do debm kɛn utu ɓaaɗo ute ro naan̰a!» ");
INSERT INTO kyq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ɓii kalaŋ se, Isa ɓaa kɔsn maakŋ ɓee magal *Parizige tu kalaŋ bini, gaŋ ɓiin se, ɓii sebit. Ɔɔ jee iŋg gɔtn ese ɔndin̰ kaama tak. ");
INSERT INTO kyq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Gɔtn se gaaba kalaŋ mɔɔɓga mɔɔɓ se, ɓaaɗo ɗaar naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Naan̰ kɛn se, Isa taaɗ jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage tu ute Parizige tu ɔɔ: «Gɛn naase ki num, ɓii sebit ki se, debm kɔɔn̰ɔ se jꞋɔk ɗoobm jꞋan̰ kɛɗn lapia lɔɓu gɔtɔ lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gaŋ naaɗe do ɗɛk ɔɔ baate tɛrlin̰ taara. Gɔtn se Isa ɔk debm kɔɔn̰ɔ se, ɛɗin̰ lapia ɔɔ ɔn̰in̰ ɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tɛr Isa ɗeekɗen ɔɔ: «Maakse ki se jaay, debm kɛn goonin̰a ey lɛ maraŋin̰a ooc maakŋ buɗ ki ute ɓii sebit se, Ꞌbɔɔy an̰ naar kuun ey ne?» ");
INSERT INTO kyq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gɔtn ese, taar kɛn naaɗe Ꞌkɔŋ jaay an̰ tɛrl tap ɓo, ɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kɛn Isa aak jeegen kꞋdaŋɗeno gɔtn kɔs ki jaay je je gɔtn kiŋg naan ki se, naan̰ aan̰ɗen kaa taara ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kɛn naai jaay kꞋdaŋiga gɛn ɓaa kɔsn gɔtn kɔkŋ mɛnd ki num, ɔn̰te Ꞌɓaa kiŋg naan ki. Ey num sɔm, maakŋ jeege tun kꞋdaŋɗeno se, nam kuuy magal ciri naai se utu aɗe ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɔɔ debm kɛn daŋseno se, utu aɗe ɓaa, ai ɗeekŋ ɔɔ: ‹Mɛɗuma, iin̰ ɔn̰ gɔtn ese; kɛse gɔtn kiŋg naai eyo.› Kɛn naai Ꞌkiin̰ gɔtn ese jaay ɓo, Ꞌɓaa kiŋg gɔtn kaam mɔɔtn se, naan̰ kɛn se, naai sɔkɔn̰ɔ ai tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Num taa naan̰ se ɓo, kɛn kꞋdaŋiga num, Ꞌɓaa iŋg gɔt kɛn kaam mɔɔtn. Bin se debm daŋi se jaay aanga num ɔɔ aaki naai iŋg kiŋg kaam mɔɔtn se, gɔtn se naan̰ ai ɗeekŋ ɔɔ: ‹Mɛɗuma, iin̰ Ꞌɓaaɗo iŋg naan ki ara.› Naan̰ kɛn se, jee kɛn kꞋdaŋɗeno gɔtn kɔs ki se paac ute naai se, naaɗe ai kaaki se ai kaali maak ki. ");
INSERT INTO kyq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Taa debm nookŋ ron̰a raan se, utu Ꞌkɔɔpm baate ɔɔ debm ɔɔp ron̰a baat se, ron̰a utu Ꞌkookŋ raan.» ");
INSERT INTO kyq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gɔtn se Isa taaɗ gaab kɛn daŋin̰o ɓeen̰ ki se kici, ɗeekin̰ ɔɔ: «Kɛn naai jaay Ꞌdaŋ jeege katar ki ey lɛ tɛgɛr gɛn kɔsɔ, ɔn̰te daŋo mɛɗige, gɛnaaige, taasige ɔɔ ɔn̰te daŋ jee do daamboogigen jee maalge. Ey num sɔm, ɓiin kuuy se, naaɗe utu ai daŋ kici ɔɔ nakŋ naai ɛɗɗesin̰ga se lɛ, naaɗe aisin̰ tɛrl gɔɔn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Num gaŋ kɛn naai jaay Ꞌje kɛɗn kɔsn ɓii laa ki ute maak‑raapo num, Ꞌdaŋo jee daayge, jee kɛn kɔɔn̰ tujɗege tuju, jee cɛkɛɗge ɔɔ jee kaam‑tɔɔkge. ");
INSERT INTO kyq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bin se, ai Ꞌtɛɗi maaki Ꞌraapo, taa nakŋ naai ɛɗɗen se lɛ, naaɗe aisin̰ kɔŋ tɛrl gɔɔn̰ ki eyo. Num naan̰ se, *Raa mala ɓo aisin̰ tɛrl gɔɔn̰ ki, kaaɗ kɛn naan̰ utu Ꞌdur jee kɛn tɛɗ nakge ute ɗoobin̰a daan yoge tu se.» ");
INSERT INTO kyq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Maakŋ jeege tun kɛn ɓaaɗo kɔsn gɔtn ese se, deb kalaŋ jaay booy taar Isa taaɗ se, naan̰ ɗeek Isa ki ɔɔ: «ꞋMaak‑raapo deb kɛn jaay utu Ꞌɓaa kɔsn *maakŋ Gaar Raa ki se!» ");
INSERT INTO kyq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Gɔtn se Isa tɛrlin̰ ute kaal naagŋ taara ɔɔ: «Gaaba kalaŋ se, tɛɗ kɔsɔ dɛna ɔɔ naan̰ daŋo jeege kic ɓo dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɛn kaaɗn kɔsɔ jaay aas se, gaabm se ɔl debm tɛɗn naabin̰ gɛn ɓaa daŋ jeegen kꞋdaŋɗeno gɔtn kɔs ki se, ɗeekɗen ɔɔ: ‹ꞋƁaakiro ɓɔrse! Ɓɛrɛ, kɔsɔ se ooyga.› ");
INSERT INTO kyq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gaŋ gɔtn se, jee kɛn kꞋdaŋɗe paac se baag ɗaapm taarɗege. Debm deet deet se ɗeek debm kɛn jꞋɔlin̰o se ɔɔ: ‹Maam se, mꞋutu mꞋdugu dug maakŋ gɔtɔ. Bɛɛki num, mꞋan̰ mꞋɓaa kaakin̰ jaayo. Bin se Ꞌɓaa ɗeekin̰ n̰Ꞌmooyuma, maam se mꞋkɔŋ kaan eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɔɔ deb kuuy se ɗeekin̰ ɔɔ: ‹Maam se mꞋutu mꞋdugu dug maraŋge sik gɛn tɛɗn naaba ɔɔ maam mꞋje mꞋaɗen ɓaa naam gɛn tɛɗn naaba. Bin se Ꞌɓaa ɗeekin̰ n̰Ꞌmooyuma, maam se mꞋkɔŋ kaan eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tɛr deb kuuy ɗeekin̰ ɔɔ: ‹Maam se, mꞋutu mꞋɔk kɔk mɛnda. Taa naan̰ se ɓo, maam mꞋkɔŋ kaan eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kɛn debm tɛɗn naabm se jaay tɛrl ɓaa ɔŋ mɛlin̰ se, naan̰ taaɗin̰ mɛtn taargen kꞋtaaɗin̰o se paac. Kɛn mɛlin̰ jaay booy se, maakin̰ taarin̰a ɔɔ ɗeek debm tɛɗn naabin̰ ki se ɔɔ: ‹Yɔkɔɗɔ, Ꞌɓaa gɔtn jeege lee tusni daan ɗoobge tu maakŋ gɛgɛr ki, Ꞌɓaa daŋo jee daayge, jee kɛn kɔɔn̰ɔ tujɗeki tuju, jee kaam‑tɔɔkge ute jee cɛkɛɗge Ꞌɓaanɗeno gɔtn ara.› Gɔtn se debm tɛɗn naabin̰ se iin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kɛn naan̰ jaay tɛrl ɓaaɗo ɔŋ mɛlin̰ se ɗeekin̰ ɔɔ: ‹Mɛluma, naabm naai ɔlum taarin̰ se, maam mꞋtɛɗin̰oga, gaŋ ute naan̰ se kic ɓo, gɔtɔ utu tap.› ");
INSERT INTO kyq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Gɔtn se mɛlin̰ ɗeekin̰ ɔɔ: ‹ꞋƁaa daan ɗoobge tu ɔɔ naagŋ salige tu, jee se Ꞌɓaanɗeno ute taa tɔɔgɔ taa aɗe Ꞌɓaa utu Ꞌɗoocn̰ maakŋ ɓeem se.› ");
INSERT INTO kyq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Taa naan̰ se ɓo, maam mꞋɗeeksen mꞋɔɔ: maakŋ jeege tun kꞋdaŋɗeno paac jaay baate ɓaaɗo se, maakɗe ki se deb kalaŋ kic ɓo, Ꞌkɔŋ nam kɔsum se eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kɛn jee dɛnge jaay ɓaa ɓaa ɗoob ki ute Isa se, gɔtn se naan̰ tɛrl aakɗe ɔɔ ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Debm kɛn je aɗe ɓaa mɛtum ki jaay, je bubin̰a, kon̰a, mɛndin̰a, gɛnin̰ge, gɛnaan̰gen gaabge ute kɛngen mɛndge cir maama ɔɔ jem te maam cir ron̰ mal ey se, naan̰ Ꞌkɔŋ tɛɗn debm mɛtn maam ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Debm kɛn baate kuun kaagŋ jꞋansin̰ tupm ro ki ɔɔ ɔk mɛtum ey se, naan̰ se Ꞌkɔŋ tɛɗn debm mɛtn maam ki eyo kici. ");
INSERT INTO kyq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Taa naan̰ se ɓo, maakse ki se nam jaay je kiin̰ ɓee jɛrlɛ num n̰Ꞌiŋg naaŋ ki, mɛɗn kaakŋ gursin̰ kɛn an̰ kaasn kiin̰ ɓeen̰ se, jaay ey la? ");
INSERT INTO kyq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ey num, kɛn naan̰ jaay uunga mɛta ɔɔ ɔɓ naŋin̰ te ey se, jee deel deel gɔtn ese jaay aakga num, an̰ tɛrɛcn̰ mɛtin̰ ki, ");
INSERT INTO kyq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","an̰ ɗeek ɔɔ: ‹Aakki tu! Gaabm ara ɔɔ iin̰ kiin̰ ɓeen̰ kaca, naɓo ɔŋ aasin̰ te eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kɛn gaar gam jaay ɓaa tɛɗn bɔɔrɔ ute gaar kuuy num, naan̰ Ꞌkiŋg naaŋ ki, Ꞌkaakŋ asgarin̰gen dupu‑sik se, Ꞌkaasn tɛɗn bɔɔrɔ ute asgargen dupu‑si‑di jaay ey la? ");
INSERT INTO kyq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ey num, kɛn gaar naane utu dɔk sum ɓo, naan̰ Ꞌkɔl jeege gɔtin̰ ki taa jꞋkɔkŋ taasa. ");
INSERT INTO kyq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bin ɓo, maakse ki se debm jaay ɔn̰te nakin̰ge ey paac se, Ꞌkɔŋ tɛɗn debm mɛtn maam ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ɗeere, nakŋ nijim aan gɔɔ kaata se gɔtɔ. Num kɛn kaata jaay kiŋgin̰ nijim se gɔtɔga num, jꞋan̰ tɛɗn jꞋɔɔ ɗi jaay Ꞌtɛɗn nijim gɔtin̰ ki se? ");
INSERT INTO kyq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kɛn kaata jaay kiŋgin̰ teecga se, kꞋsin̰ naaŋ ki lɛ ɔŋ ɗaapm naaŋ eyo ɔɔ ɔŋ tɛɗ gɔtɔ gur eyo. Naan̰ se, bɛɛki num, nakin̰ si naatn sum.» Tɛr naan̰ ɗeekɗen ɔɔ: «Debm kɛn jaay ɔk bi gɛn booyo num, Ꞌbooy taar se.» ");
INSERT INTO kyq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gɔtn se *jee tɔkŋ miirge ute jeegen jeege paacn̰ jeelɗe naaɗe se jee *kusin̰ge se, paac utu ɓaaɗo gɔtn Isa ki gɛn booy taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Parizige ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kɛn gɔtn ese se, mooy naaŋ ki dir dir ɗeek ɔɔ: «Gaabm se tiŋg ɓo gɛn kɔkŋ jee kusin̰ge ron̰ ki sum ɔɔ tɔs ute naaɗe!» ");
INSERT INTO kyq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gɔtn se Isa taaɗɗen ute kaal naagŋ taara ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Aan gɔɔ maakse ki se, debm kɛn ɔk baatge kaaru jaay maakɗe ki se kalaŋ iigga num, baatgen sik‑jɛrnaŋ‑kaar‑jɛrnaŋ kuuy se naan̰ aɗe kɔn̰ kɔɗ‑ɓaar ki, taa Ꞌɓaa je kɛn kalaŋ iig kiig se, an̰ je bini an̰o kɔŋ jaay ey la? ");
INSERT INTO kyq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kɛn jaay ɓaa ɔŋin̰ga se, naan̰ an̰o kuun kaal daamin̰ ki ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔɔ kɛn naan̰ jaay tɛrl ɓaaɗoga ɓeen se, naan̰ Ꞌdaŋ tusn mɛɗin̰ge ute jee do daamboogin̰ge ɔɔ ɗeekɗen ɔɔ: ‹ꞋƁaakiro, jꞋaki tɛɗn maak‑raapo ute maama, taa baatum iigo se, maam mꞋɔŋin̰ga.› ");
INSERT INTO kyq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bin ɓo Ꞌbooyki mꞋasen taaɗa: maakŋ jee kusin̰ge tu se, deb kalaŋ jaay tɛrlga maakin̰a do *Raa ki num, taa debm ese se jee maakŋ raa ki paac se maakɗe‑raapm don̰ ki cir jee si‑jɛrnaŋ‑kaar‑jɛrnaŋ kɛn an ɗim eyo gɛn tɛrl maakɗe do Raa ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Lɔ aan gɔɔ mɛnd jaay ɔk tamma sik. Ɔɔ kɛn kalaŋ jaay oocga num, naan̰ utu Ꞌkɔɔcn̰ lɔɔmpɔ ɔɔ Ꞌkɔtn maakŋ ɓeen̰a se bini an̰ je kɔŋ jaay ey la? ");
INSERT INTO kyq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kɛn naan̰ jaay ɔŋin̰ga num, naan̰ aɗe daŋ tusn mɛɗin̰ge ute jee do daamboogin̰ge ɔɔ aɗen taaɗn ɔɔ: ‹ꞋƁaakiro, jꞋaki tɛɗn maak‑raapo ute maama, taa tamman iigo se, maam mꞋɔŋin̰ga.› ");
INSERT INTO kyq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bin ɓo, Ꞌbooyki mꞋasen taaɗa: kɛn debm *kusin̰ kalaŋ sum ɓo tɛrlga maakin̰ do Raa ki se, taa debm ese se, *kɔɗn Raage maakɗe raapo.» ");
INSERT INTO kyq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gɔtn se Isa tɛr taaɗɗen daala ɔɔ: «Gaaba kalaŋ ɔk gaangen gaabge dio. ");
INSERT INTO kyq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Goon baat se ɗeek bubin̰ ki ɔɔ: ‹Bua, maakŋ maalige tun kɛn naai ooyga num jꞋajesin̰ nig se, ɛɗumo bɛɗuma.› Gɔtn se bubin̰ tooko ɔɔ nigɗesin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kɛn jꞋɛɗin̰ bɛɗin̰ jaay tɛɗ ɓii kandum se, nakin̰ge se, naan̰ tɔs dugɗe naatn ɔɔ ute gursn se, naan̰ iin̰ ɓaa taa naaŋ dɔkɔ. Gɔtn naane se, naan̰ iŋg cɛɛpm te gursin̰ se cɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kɛn naan̰ jaay ut naŋ gursin̰ sum se, gɔtn se, ɓo ɛnd maakŋ naaŋ kɛn se ɔɔ tɔɔl tɛɗ daama jeege tu ɔɔ ɓo se, ɔlin̰ maakŋ daay ki. ");
INSERT INTO kyq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Gɔtn se, naan̰ iin̰ ɓaa tɛɗn naaba gɔtn gaab ki kalaŋ bini, gaabm se ɔlin̰ n̰Ꞌɓaa n̰Ꞌbɔɔbm kin̰zirin̰ge maakŋ‑gɔt ki. ");
INSERT INTO kyq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naan̰ je Ꞌkɔsn kɔjn̰ mɔrɔmb kɛn kin̰zirge lee ɔs se kic ɓo, gaŋ nam ɛɗin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Gɔtn se, naan̰ baag saapm do ron̰ ki ɔɔ taaɗ te maakin̰ ɔɔ: ‹Nakage, bubum se ɔk jee tɛɗn naabge kando kando kɛn ɔs ɔɔp taarɗe ki, naɓo maam mꞋkɔn̰ rom gɔtn ara mꞋkooy gɛn ɓo ne? ");
INSERT INTO kyq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ɓɔrse, maam mꞋkiin̰ tɛrl ɓaa gɔtn bubum ki, mꞋan̰ ɓaa ɗeekŋ mꞋɔɔ: bua, maam se mꞋtujga naan Raa ki ɔɔ mꞋtujga naai ki kici; ");
INSERT INTO kyq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ɔɔ maam se, mꞋaas te gɛn kɔŋ tɛɗn gooni ey sum; aakum aan gɔɔ jee tɛɗn naabige se sum.› ");
INSERT INTO kyq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gɔtn se naan̰ iin̰ uun ɗoobm ɓee bubin̰a. «Kɛn naan̰ ɓaa ɓaa jaay utu teeco dɔk naane sum ɓo, bubin̰ aakin̰ se, ɛɛjin̰ don̰ ki ɔɔ naan̰ aan̰ ɓaa dɔɔɗin̰a, baam ɔkin̰ kaaɗin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gɔtn se goonin̰ ɗeekin̰ ɔɔ: ‹Bua, maam se mꞋtujga naan Raa ki ɔɔ mꞋtujiga naai ki. Ɔn̰te Ꞌkaakum aan gɔɔ mꞋgooni sum.› ");
INSERT INTO kyq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Gaŋ bubin̰ ɗeek jee tɛɗn naabin̰ge tu ɔɔ: ‹ꞋƁaankiro ute kal aak bɛɛ se yɔkɔɗɔ, uusin̰sin̰ki ron̰ ki, ɔlin̰ki kɔɗɔkɔ jin̰ ki ɔɔ Ꞌtɔlin̰ki saa jɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɔk Ꞌɓaankiro ute goon maraŋ kɛn eer sal sal se, Ꞌtɔɔlin̰ki, ɔɔ Ꞌtɛɗjeki kɔsɔ, taa jꞋaki tɛɗn maak‑raapjege. ");
INSERT INTO kyq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taa goonum kɛn ey num ooyga kooy ɗɛl ɗɛl se, aajga ɔɔ naan̰ kɛn iigga kiig ɗɛl ɗɛl se, ɔk tɛrl ɓaaɗoga ɓeene.› Gɔtn se naaɗe baag tɛɗn maak‑raapɗe. ");
INSERT INTO kyq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Kaaɗ kɛn se, goonin̰ magal se utu maakŋ‑gɔt ki. Kɛn naan̰ ɓaaɗo ɓaa jaay aan gɔɔr ute ɓee se, naan̰ booy kaa ɔkga lɛt ɔɔ jeege daam daama. ");
INSERT INTO kyq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gɔtn se maakŋ jee tɛɗn naabm bubin̰ge tu se, naan̰ daŋo deb kalaŋ ɔɔ tɔnd mɛtin̰ ɔɔ: ‹Ɗi ɓo tɛɗa?› ");
INSERT INTO kyq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Gaabm se tɛrlin̰ ɔɔ: ‹Gɛnaai ɓo ɓaaɗoga. Taa naan̰ tɛrl ɓaaɗo ɔŋga bubi ute lapi se ɓo, bubi tɔɔlin̰ga goon maraŋ eer sal sal se.› ");
INSERT INTO kyq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Gɔtn se goon magal se maakin̰ tuju ɔɔ naan̰ baate kɛnd ɓeene. Naan̰ kɛn se, bubin̰ teec ɓaaɗo ɔŋin̰a ɔɔ sɛlin̰ mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naɓo naan̰ tɛrl bubin̰ ki ɔɔ: ‹ꞋBooyo! Ɓaara ɓaara ɓo, maam mꞋlee mꞋtɛɗi naabige se aan gɔɔ debm tɛɗn naabi sum ɔɔ ɓii kalaŋ tap ɓo, mꞋbaate te taari eyo. Ute naan̰ se kic ɓo, ɓii kalaŋ jaay naai am kɛɗn goon bin̰i kalaŋ taa mꞋan tɛɗn maak‑raapo ute mɛɗumge kic ɓo gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Num gaŋ gooni kɛn ut naŋo maalige ute mɛnd kɛɛsn gaabge jaay ɔk tɛrlo se, naai Ꞌtɔɔlin̰ goon maraŋ eer sal sal se!› ");
INSERT INTO kyq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Gɔtn se bubin̰ tɛrlin̰ ɔɔ: ‹Goonuma, naai se daayum utu te maama ɔɔ maal maam mꞋɔk se lɛ, paac gɛn naai. ");
INSERT INTO kyq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gaŋ bɛɛki num, ɓaaɗo jꞋaki kɔsɔ ɔɔ jꞋaki tɛɗn maak‑raapjege. Aaka! Gɛnaai se ey num ooyga kooy ɗɛl ɗɛl, naɓo aajga ɔɔ naan̰ kɛn iigga kiig ɗɛl ɗɛl se, ɔk tɛrl ɓaaɗoga ɓeene.›» ");
INSERT INTO kyq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gɔtn se Isa taaɗ jeege tun mɛtin̰ ki ɔɔ: «Debm maala kalaŋ bin se ɔk debm kɛn naan̰ ɔn̰in̰ maalin̰ kaam jin̰a. Ɓii kalaŋ kꞋɓaaɗo kꞋtaaɗin̰ jꞋɔɔ: ‹Debm tɛɗn naabi se, ɓɛrɛ, utn kut ute maalige.› ");
INSERT INTO kyq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naan̰ ɔl kꞋdaŋ kꞋɓaansin̰o ɔɔ tɔnd mɛtin̰ ɔɔ: ‹Taar kɛn kꞋtaaɗ roi ki se, maam mꞋbooyga. Bin se, Ꞌɓaaɗo mɛɗum maalumge se naanum ki. Taa naan ki se, maam mꞋai kɔŋ kɔn̰ maalum kaam ji ey sum.› ");
INSERT INTO kyq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Gɔtn se debm kɛn kꞋjꞋɔn̰in̰ maala kaam jin̰ se baag saapa ɔɔ taaɗ ute maakin̰ ɔɔ: ‹Maam se mꞋtɛɗn rom mꞋɔɔ ɗi? Mɛlum lɛ ɔkga te maalin̰ jim ki naatn. Ɓɔrse, gɛn kursu lɛ, maam tɔɔgum gɔtɔ ɔɔ kɛn mꞋɓaa lee baaya lɛ, sɔkɔn̰ am tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Maam se mꞋsaap mꞋɔŋga nakŋ maam mꞋtɛɗa. Kɛn mɛlum se jaay tɔsnga ute maalin̰ jim ki kic num, mꞋutu mꞋkɔŋ jeegen utu am kɔkŋ jiga.› ");
INSERT INTO kyq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Taa naan̰ se ɓo, naan̰ ɔl kꞋdaŋo jeegen ɔk sɛɛ mɛlin̰ se kalaŋ kalaŋ. Debm deet deet se, naan̰ tɔnd mɛtin̰ ɔɔ: ‹Gɔtn mɛlum ki se, naai tap ɓo uunga sɛɛ kando?› ");
INSERT INTO kyq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Gaabm se tɛrlin̰ ɔɔ: ‹Maam se mꞋuunga birmil uubu kaaru.› Num debm kɛn naan̰ ɔn̰in̰ maalin̰ kaam jin̰a se tɛrlin̰ ɔɔ: ‹ꞋBooyo: maktubm sɛɛi se utu jim ki ara. Iŋg naaŋ ki kɛskɛ, Ꞌnaar Ꞌraaŋ ɔɔ: maam se mꞋuunga birmil uubu si‑mii.› ");
INSERT INTO kyq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tɛr naan̰ ɗeek deb kuuy ki ɔɔ: ‹Naai uunga sɛɛ kando gɔtn mɛlum ki se?› Naan̰ tɛrlin̰ ɔɔ: ‹Maam mꞋuunga suwal teen̰ kaaru.› Num debm tɛɗn naabm se ɗeekin̰ ɔɔ: ‹ꞋBooyo: maktubm sɛɛi se utu jim ki ara. Ɓɔrse Ꞌraaŋ ɔɔ: maam mꞋuunga suwal sik‑marta.› ");
INSERT INTO kyq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Debm kɛn naan̰ ɔn̰in̰ maalin̰ kaam jin̰a kɛn dɛrl mɛlin̰ se, mɛlin̰ jaay booy nakŋ naan̰ tɛɗ se, naan̰ tɔɔmin̰a, taa naan̰ ɔŋin̰ naan̰ se debm mɛtɛkɛ. Taa naan̰ se ɓo, jee *duni ki ute naapa se, naaɗe mɛtɛk cir gaan gɔt kɛn wɔɔrɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tɛr Isa taaɗɗen ɔɔ: «ꞋBooyki mꞋasen taaɗa: ɔkki mɛɗge ute maalsegen ɔŋin̰ki do naaŋ ki kɛn tɛɗga sum ɓo utu Ꞌdeel se. Kɛn maalse se jaay ɓaaɗo utga kic ɓo, bɛɛ kɛn naase lee Ꞌtɛɗki jeege tu se an̰ki ɓaa kɔŋ maakŋ *Ɓee Raa ki gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Debm jꞋɔn̰in̰ nakŋ cɔkɔ kaam jin̰ jaay ɔkin̰ jiga se, kɛn jꞋɔn̰in̰ nakŋ dɛn kic ɓo naan̰ an̰ kɔkŋ jiga. Ɔɔ debm jꞋɔn̰in̰ nakŋ cɔkɔ kaam jin̰a jaay naan̰ ɔŋ ɔkin̰ te jig ey se, kɛn jꞋɔn̰in̰ nakŋ dɛn kic ɓo, naan̰ an̰ kɔŋ kɔkŋ jig ey kici. ");
INSERT INTO kyq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kɛn maal do naaŋ kɛn utu Ꞌdeel se jaay naase ɔŋ ɔkin̰ki te jig ey se, Raa se asen kɔŋ kɛɗn maal mala mala kɛn maakŋ raa ki ey se kici. ");
INSERT INTO kyq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kɛn maal naase ey jaay ɔkin̰ki te jig ey se, naŋa jaay ase kɛɗn maal naase maalin̰ge kaam jise se? ");
INSERT INTO kyq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Deb kalaŋ se Ꞌkɔŋ tɛɗn naaba gɔtn mɛlge tu kaam di eyo. Kɛn naan̰ ɓo tɛɗ naaba gɔtɔ kaam di num, deb kalaŋ naan̰ an̰ kɔɔɗn kundu ɔɔ deb kalaŋ naan̰ an̰ jea; ey lɛ deb kalaŋ se, naan̰ an̰ kɔkŋ ɔɔn̰ɔ ɔɔ kɛn kuuy se, naan̰ an̰ kaal maak ki eyo. Taa naan̰ se ɓo naase aki Ꞌkɔŋ tɛɗn naabm Raa ɔɔ ute gɛn gurs se taa naap ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gaŋ *Parizigen jee je gursge se jaay booy taar Isa taaɗ paac se, naaɗe tɛrɛcin̰ mɛtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isa ɗeekɗen ɔɔ: «Naase se Ꞌjeki Ꞌtaaɗn rose naan jeege tu aan gɔɔ jee kɛn tɛɗn nakge ute ɗoobin̰a; num gaŋ Raa se, jeel nakŋ maakse ki. Taa naan̰ se ɓo nakŋ aak bɛɛ naan jikilimge tu se, naan Raa ki se naan̰ aakin̰ se aakin̰ kus. ");
INSERT INTO kyq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Kaaɗn kɛn Raa ɛɗo *Ko Taarin̰ *Musa ki ute gɛn jeegen taaɗ taar teeco taar Raa ki se iŋg bini aan do Jan‑Batist ki. Num kɛn Jan‑Batist aan sum se, kꞋbaago taaɗ Labar Jiga gɛn *maakŋ Gaar Raa se jeege tu ɔɔ naan̰ kɛn se, naŋa naŋa kic ɓo aay kaamin̰ je kɛnd maak ki. ");
INSERT INTO kyq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maakŋ raa ute do naaŋa se deelin̰ Ꞌkɔɔn̰ eyo, naɓo taargen kꞋraaŋin̰o maakŋ Ko Taar kɛn Raa ɛɗo Musa ki se, ɗimin̰ cɔkɔ kic ɓo, Ꞌkoocn̰ naaŋ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Debm jaay piir te mɛndin̰ se ɔɔ ɔk mɛnd kuuy se, debm bin se aan gɔɔ debm teec ɔn̰ mɛndin̰a ɔɔ ɓaa ɛɛs mɛnd nam. Ɔɔ debm ɔk mɛnd gaabin̰ piirin̰ga piir se, naan̰ kic aan gɔɔ debm teec ɔn̰ mɛndin̰a ɔɔ ɓaa ɛɛs mɛnd gaaba.» ");
INSERT INTO kyq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Gaaba kalaŋ bin se ɔk maala dɛna. Naan̰ tuus kal ute ron̰a ɗɛrɛc ɔɔ ɓii‑raa ɔs bɛɛ ɔɔ iŋg ute maraadin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gaŋ gaaba kalaŋ bin se, kꞋdaŋin̰ Lazar. Naan̰ se debm daaye ɔɔ ron̰ se taan‑du sum. Naan̰ lee tooɗ taa ɗoobm gaab kɛn debm maala se. ");
INSERT INTO kyq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naan̰ je kɔsn kɛn si bɔɔr gaab kɛn se kic ɓo ɔŋ eyo. Num tɛr do naan̰ ki se, bɛsge ɓaaɗo tɔɔn taan‑dun̰a. ");
INSERT INTO kyq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kɛn debm daay jaay ooy se, *kɔɗn Raage uun ɓaansin̰ maakŋ raa ki cɛɛ *Abraam ki ɔɔ gɔtn se, debm maala se kic ɓo ooyo ɔɔ kꞋɓaa kꞋduubin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","«Maakŋ ɓee yoge tu se, debm maala baag kɔɔɗ yɛɛɓin̰a, ɔɔ maakŋ kɔɔɗ yɛɛɓin̰ ki se, naan̰ und kaamin̰ aak Abraam ute Lazar iŋg kiŋg cɛɛn̰ ki dɔk naane. ");
INSERT INTO kyq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kɛn naan̰ aak Abraam se, naan̰ ɔɔɗ ɔɔy daŋin̰ ɔɔ: ‹Abraam, bua, ɛɛjum dom ki. Ɔl Lazar Ꞌɓaa Ꞌkɔl goon‑jin̰ maan taa aɗe ɓaa am kaaɗn maane rɔɔn̰um ki, taa maakŋ pooɗ kɛn ara se, maam mꞋutu mꞋɔɔɗ yɛɛɓum kusin̰ aak eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Gɔtn se Abraam ɗeekin̰ ɔɔ: ‹Goonuma, Ꞌsaap tu. Do naaŋ ki se naai ɔŋoga bɛɛ, gaŋ Lazar se ɔɔɗoga yɛɛɓin̰a. Ɔɔ ɓɔrse gɔtn ara se, naan̰ ɔŋga gɔtn bɛɛ ɔɔ gaŋ naai lɛ ɔŋga gɔtn kɔɔɗn yɛɛɓɛ. ");
INSERT INTO kyq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ꞋJeele, daan naaje ute naase se, jꞋɔkki gɔɔ magala ɔɔ jɛrl zuzu, taa jee gɔtn ara jaay je ɓaa gɔtn naase ki se naaɗe Ꞌkɔŋ ɓaa eyo ɔɔ jee gɔtn naase ki jaay je ɔɔ aɗe ɓaa gɔtn naaje kic ara lɛ aɗe kɔŋ ɓaa ey kici.› ");
INSERT INTO kyq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Gɔtn se debm maala ɗeekin̰ ɔɔ: ‹Kɛn bin num, mꞋeemi nɔɔ mɛti ki, Bua, ɔl Lazar se Ꞌɓaa kɔŋ jee kɛn maakŋ ɓee bubum ki se. ");
INSERT INTO kyq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Taa maam se mꞋɔk gɛnaagen gaabge mii. Ɔn̰ naan̰ aɗen ɓaa taaɗa, taa naaɗe aɗe ɓaa gɔtn kɔɔɗ yɛɛɓ kɛn ara ey sum.› ");
INSERT INTO kyq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraam ɗeekin̰ ɔɔ: ‹Naaɗe ɔk *Ko Taar kɛn Raa ɛɗo Musa ki ute Kitapm gɛn jee taaɗ taar teeco taar Raa ki do dɔkin̰a; ɔn̰ɗe naaɗe Ꞌbooy taar naaɗen se.› ");
INSERT INTO kyq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Gaŋ debm maala se tɛrl Abraam ki ɔɔ: ‹Bin eyo, Abraam bua. Kɛn debm ooyga kooy jaay ɓaa ɔŋɗega ɔɔ taaɗɗenga se, naaɗe Ꞌtooko ɔɔ Ꞌtɛrl maakɗe do Raa ki.› ");
INSERT INTO kyq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naan̰ kɛn se Abraam tɛrlin̰ ɔɔ: ‹Kɛn naaɗe jaay took uun te Ko Taar kɛn Raa ɛɗo Musa ki eyo ɔɔ ute taar jee taaɗ taar teeco taar Raa ki do dɔkin̰ ey se, kɛn debm ooyga kooy jaay dur daan yoge tu ɔɔ ɓaa ɔŋɗe kic ɓo, naaɗe Ꞌkɔŋ tookŋ taarin̰ eyo.›» ");
INSERT INTO kyq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tɛr ɓii kalaŋ Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: «Nakŋ utu Ꞌtujn̰ jeege naan Raa ki se utu tap, naɓo ɔɔn̰ debm kɛn jaay ɓo Ꞌkɔl jeege Ꞌtujn̰ naan Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bɛɛki num, debm bin se, jꞋan̰ dɔɔkŋ ko tooto magala mindin̰ ki ɔɔ jꞋuun jꞋundin̰ naatn maakŋ baar ki kic ɓo kɛse ɔɔn̰ eyo. Num kɛn maakŋ gaan sɛɛmge tu se jaay naan̰ tujga deb kalaŋ naan Raa ki se, nakŋ utu kaan don̰ ki se, ɔɔn̰ cir kɛse daala. ");
INSERT INTO kyq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kɛn bin num, ɔndki kɔndɔ! Kɛn gɛnaai jaay tujiga num, Ꞌmooyin̰a. Kɛn naan̰ jaay jeelga *kusin̰in̰ se, Ꞌtɛɗin̰ kalɗɛ. ");
INSERT INTO kyq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kɛn maakŋ ɓii ki ɓo, naan̰ tuj ɗɔɔli mɛt cili kic ɓo kɛn naan̰ jaay ɓaaɗo taaɗi ɔɔ: ‹Gɛnaama, maam se mꞋtujn̰ga roi ki, mꞋɔki naagi.› Gɔtn se naai an̰ tɛɗn kalɗɛ.» ");
INSERT INTO kyq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Gɔtn se jee kaan̰ naabin̰ge tɛrlin̰ ɔɔ: «Mɛlje, Ꞌziiɗjen kaal maakje do Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Isa tɛrlɗen ɔɔ: «Kɛn naase jaay ɔkki kaal maakŋ do Raa ki magal aan gɔɔ kaam koobi se num, naase aki kɔŋ ɗeekŋ ko kaag kɛn magal ese se ɔɔki: ‹Iin̰ gɔtn se, Ꞌɓaa ɗaar maakŋ baar ki naane› ɔɔ naan̰ Ꞌtookŋ taar se.» ");
INSERT INTO kyq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tɛr Isa ɗeekɗen ɔɔ: «Maakse ki se, nam kɛn ɔk ɓulu jaay ɓulin̰ iŋgo naaba, ey lɛ iŋgo gaam maalge, kɛn naan̰ utu aan kaan ɓeen sum ɓo, naan̰ an̰ naar taaɗn ɔɔ: ‹ꞋƁaaɗo, yɔkɔɗɔ iŋg naaŋ ki ɔɔ Ꞌkɔsɔ› bin ne? ");
INSERT INTO kyq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Num bin eyo! Gaŋ naan̰ an̰ ɗeekŋ ɔɔ: ‹Kali se Ꞌɓaa tooɗin̰a, uusu kal tɛɗn naabi ɔɔ Ꞌɓaaɗo Ꞌtɛɗum kɔsɔ. Kɛn ɛɗumga maam mꞋɔsga ɔɔ mꞋaayga jaay ɓo sɔm, naai kic utu Ꞌkɔsɔ ɔɔ utu Ꞌkaaye.› ");
INSERT INTO kyq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Taa nakŋ naan̰ tɛɗ se, ɓul se mɛlin̰ an̰ kɔŋ tɔɔm eyo. ");
INSERT INTO kyq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Naase kic kɛn Ꞌtɛɗkiga naabm kɛn kꞋtaaɗsenoga se num Ꞌtaaɗki ɔɔki: ‹Naaje se, kꞋɓulge cɛrɛ sum ɔɔ naabm naaje kꞋtɛɗ se lɛ, naabm kɛn kꞋtaaɗjen taaɗ sum.›» ");
INSERT INTO kyq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kɛn Isa ɓaa ɓaa Jeruzalɛm ki se, naan̰ aal teec daan taa naaŋ *Samari ute taa naaŋ Galile ki. ");
INSERT INTO kyq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kɛn naan̰ jaay aan maakŋ naaŋ ki kalaŋ bin se, jee bikiɗge sik ɓaaɗo ɔŋin̰a. Gɔtn se, naaɗe ɗaar dɔkɔ, ");
INSERT INTO kyq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɔɔ uun mindɗe raan ɗeekin̰ ɔɔ: «Isa, Debm dooy jeege, ɛɛjjen doje ki.» ");
INSERT INTO kyq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kɛn Isa aakɗe se, ɗeekɗen ɔɔ: «ꞋƁaa Ꞌtaaɗki rosege se *jee tɛɗn sɛrkɛ Raage tu.» Ɔɔ kɛn naaɗe utu ɓaa ɓaa sum ɓo, naaɗe ɔŋ lapia ɔɔ roɗe ɗaap tooɗ kɔlɔn̰ kɔlɔn̰. ");
INSERT INTO kyq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Deb kalaŋ maakɗe ki jaay aak naan̰ ɔŋga lapia se, naan̰ ɔk tɛrl ɓaaɗo gɔtn Isa ki, uun mindin̰ raan ɔɔ *nook Raa. ");
INSERT INTO kyq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Gɔtn se naan̰ ɓaaɗo ooc mɛtn jɛ Isa ki ɔɔs don̰ naaŋ ki ɔɔ tɔɔmin̰a. Gaŋ gaabm se, naan̰ kɔɗ Samari. ");
INSERT INTO kyq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naan̰ kɛn se Isa ɗeekin̰ ɔɔ: «Naaɗen sik se ɔŋ te lapia paac ey la? Num jee ɔɔp jɛrnaŋ se gay? ");
INSERT INTO kyq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bini maakɗe ki se, mɛrtɛ jaay ɓaaɗo nook Raa se.» ");
INSERT INTO kyq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Anum Isa ɗeek kɔɗ Samari ki se ɔɔ: «Iin̰ Ꞌɓaa ute lapia. Kaal maaki kɛn naai aal dom ki se, aajiga.» ");
INSERT INTO kyq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɓii kalaŋ *Parizige tɔnd mɛtn Isa ɔɔ: «Nuŋ ki jaay Raa utu kɔsn gaara do jeege tu se?» Naan̰ tɛrlɗen ɔɔ: «Kɛn Raa jaay kɔsn gaara do jeege tu se jꞋan̰ kɔŋ kaakŋ ute kaam eyo. ");
INSERT INTO kyq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","JꞋaki kɔŋ ɗeekŋ jꞋɔɔki naan̰ utu ara ey lɛ utu naane eyo. Taa Raa se ɔsga gaara daanse ki.» ");
INSERT INTO kyq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Gɔtn se Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: «Kaaɗin̰ utu Ꞌkaan se, naase utu aki je gɛn kaakŋ Goon Deba, naɓo gɛn kaakŋ ɓii kalaŋ kic ɓo, an̰ki kɔŋ kaak eyo. ");
INSERT INTO kyq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","JꞋasen taaɗn jꞋɔɔ naan̰ utu naane ey lɛ naan̰ utu ara. Anum ɔn̰te Ꞌɓaaki ɔɔ ɔn̰te Ꞌnaarki rose. ");
INSERT INTO kyq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Taa ɓii kɛn Goon Deba aɗe ɓaa se tecn̰ aan gɔɔ maan aal wusuk jaay wɔɔr maakŋ raa bɛrɗ gɔtɔ lak se. ");
INSERT INTO kyq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Num kɔr nakgen se jaay Ꞌkaan se, naan̰ Ꞌdabar dɛna ɔɔ jee do duni kɛn ɓɔrse se, an̰ kɔɔɗn kundu. ");
INSERT INTO kyq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Ɓii kɛn Goon Deba aɗe ɓaa se, Ꞌtecn̰ aan gɔɔ nakgen deelo do Noe ki. ");
INSERT INTO kyq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kaaɗ kɛn naane se jeege ɔsɔ, aaye, tɔk mɛndge ɔɔ tɔk gaabge, bini aan ɓii kɛn Noe ɛnd maakŋ markab kɛn magala. Naan̰ kɛn se, maan magala bɔɔyɔ ɔɔ ɓaaɗo gɔɔb tɔɔl te jeege paac. ");
INSERT INTO kyq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Ey lɛ nakŋ utu Ꞌkaan se Ꞌtecn̰ aan gɔɔ nakgen kɛn aano do Lɔt ki se kici. Kaaɗ kɛn se jeege se ɔsɔ ɔɔ aaye, dugŋ nakge ɔɔ dugŋ ute nakɗege, duub jinɛnɛge ɔɔ iin̰ ɓeeɗege. ");
INSERT INTO kyq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Num gaŋ, ɓii kɛn jaay Lɔt teec ɔn̰ Sɔdɔm se, Raa bɔɔyɗen pooɗo ute kuɗn ɔŋg se doɗe ki tɔɔl utɗe kap. ");
INSERT INTO kyq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ɓiin Goon Deba aɗe ɓaa se, utu Ꞌtɛɗn bin kici. ");
INSERT INTO kyq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ɓii kɛn se, debm iŋg kiŋg do ɓeen̰ ki raan se, n̰Ꞌɔn̰te bɔɔyo gɛn Ꞌtɔsn nakin̰gen maak ki ɔɔ debm maakŋ gɔt ki se lɛ, n̰Ꞌɔn̰te tɛrl ɓeen̰ ki gɛn Ꞌtɔsn nakin̰ge kici. ");
INSERT INTO kyq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ꞋSaapki tu do mɛtn taar mɛnd Lɔt ki! ");
INSERT INTO kyq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Debm je kaajn̰ kon̰ se utu an̰ kutu ɔɔ debm utga kon̰ lɛ, utu Ꞌkaaja. ");
INSERT INTO kyq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ꞋBooyki mꞋasen taaɗa: maakŋ nɔɔr kɛn se, jeege di jaay tooɗ tooɗ do daŋal ki kalaŋ se, deb kalaŋ se, Raa an̰ kuun ɓaa ɔɔ debm kuuy se, naan̰ an̰ rɛsɛ. ");
INSERT INTO kyq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɔɔ mɛndgen di ɗaar uus kuus do toot ki se kic, deb kalaŋ se, Raa an̰ kuun ɓaa ɔɔ debm kuuy se, naan̰ an̰ rɛsɛ.» ");
INSERT INTO kyq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɔɔ gaabge di kɛn iŋg kiŋg maakŋ gɔt ki se kic lɛ, deb kalaŋ Raa an̰ kuun ɓaa ɔɔ deb kuuy se, naan̰ an̰ rɛsɛ. ");
INSERT INTO kyq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Gɔtn se jee mɛtn Isa ki tɔnd mɛtin̰ ɔɔ: «Mɛlje, nakgen se Ꞌdeel kaam gay?» Isa tɛrlɗen ɔɔ: «Gɔtn jaay daa ooy tooɗn se ɓo, gɔtn ese ɓo marlge kic lee bɔɔy tus ro ki.» ");
INSERT INTO kyq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tɛr Isa taaɗ jeege tun mɛtin̰ ki ute kaal naagŋ taara, taa naan̰ je aɗen taaɗn ɔɔ jꞋaay kaamɗe daayum jꞋeem *Raa ɔɔ jꞋɔn̰te kɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naan̰ taaɗɗen ɔɔ: «Maakŋ gɛgɛr ki kalaŋ bin se, ɔk gaaba kalaŋ, debm kɔjn̰ bɔɔrɔ ɔɔ gaabm se lɛ, ɓeer Raa ki eyo ɔɔ nam tap ɓo, naan̰ aalin̰ maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɔɔ gɔtn ese ɔk mɛnd‑daay kici, ɔɔ mɛnd‑daay se, ɓii‑raa ɓaaɗo gɔtin̰ ki ɗeekin̰ ɔɔ: ‹Aakum tu mɛtn taaruma ute debm taamooyum se.› ");
INSERT INTO kyq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mɛnd‑daay se lee ɗɔɔl gɔtin̰ ki cɔk cɔk, naɓo naan̰ baate kaakin̰ mɛtn taarin̰a. Gaŋ aan gɔɔ mɛnd se ɔn̰in̰ ey se, naan̰ taaɗ ute maakin̰ ɔɔ: ‹Ey num maam se, Raa kic ɓo mꞋɓeerin̰ eyo ɔɔ nam tap ɓo maam mꞋaalin̰ maak ki eyo, ");
INSERT INTO kyq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","naɓo mɛnd se lɛ, ɔn̰um ey ɗey se, maam mꞋan̰ kaakŋ mɛtn taarin̰ se. Kɛn mꞋaakin̰ te mɛtn taarin̰ ey num, mɛnd se sɔm am kaal kɔɔɗum cɛrɛ.›» ");
INSERT INTO kyq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tɛr Mɛljege taaɗɗen daala ɔɔ: «ꞋBooyki tu mɛtn taar debm kɔjn̰ bɔɔr kɛn bɛɛ ey se. ");
INSERT INTO kyq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anum Raa se, Ꞌkɔŋ koocn̰ mɛtn jeen̰gen kɛn tɔnd mɛtin̰ jaay eemin̰ nɔɔ nɔɔrɔ ɔɔ katara se ey ne? Naan̰ aɗe Ꞌkɔn̰ Ꞌkiŋg kaakŋ kaama bin sum ne? ");
INSERT INTO kyq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ꞋƁooyki, mꞋasen taaɗa: Raa se Ꞌnaar utu aɗen koocn̰ mɛtɗe! Naɓo kɛn *Goon Deba jaay utu aɗe tɛrl ɓaa do naaŋ ki se, naan̰ utu Ꞌkɔŋ jeegen aal maakɗe don̰ ki ɗey?» ");
INSERT INTO kyq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gɔtn se tɛr Isa taaɗɗen ute kaal naagŋ taara daala, do jee mɛtin̰ge tun aak roɗe aan gɔɔ naaɗe ɓo jee tɛɗ nakge ute ɗoobin̰a ɔɔ jee kuuy se naaɗe aalɗe maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naan̰ ɗeekɗen ɔɔ: «Gaabge dio ook ɓaa *Ɓee Raa ki gɛn keem Raa. Deb kalaŋ se, naan̰ kɔɗ Parizi ɔɔ debm kuuy se, naan̰ *debm tɔkŋ miiri. ");
INSERT INTO kyq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kɔɗ Parizi jaay iin̰ ɗaar gɛn keem Raa se, naan̰ taaɗ te maakin̰ ɔɔ: ‹Raama, maam se mꞋtɔɔmi, taa maam se mꞋtec aan gɔɔ jee mɛtin̰ge se eyo. Naaɗen kɛn jee kujun jeege ɔɔ jee tɛɗ naka ute ɗoobin̰ eyo, jee kɛɛsn mɛnd jeege ey lɛ maam aan gɔɔ debm tɔkŋ miir kɛn ɗaar se eyo. ");
INSERT INTO kyq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maakŋ ɓii cili ki se, maam mꞋuun *siam ɓii dio ɔɔ nakŋ kɛn mꞋɔk paac se nigin̰ gɔtɔ kaam sik, ɔɔ kɛn kaam kalaŋ se mꞋɔɔɗ mꞋɛɗi naai ki.› ");
INSERT INTO kyq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Num gaŋ debm tɔkŋ miiri se, iin̰ ɗaar dɔkɔ ɔɔ don̰ raan kic ɓo uun eyo. Gɔtn se naan̰ tɔnd tarkaaɗin̰a ɗeek ɔɔ: ‹Raama, ɛɛjum dom ki taa maam se mꞋdebm *kusin̰ naani ki.›» ");
INSERT INTO kyq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Isa ɗeekɗen ɔɔ: «ꞋBooyki mꞋasen taaɗa: debm tɔkŋ miiri se, kɛn naan̰ jaay tɛrl ɓaa ɓeen̰ ki se, tɛɗga debm aak bɛɛ naan Raa ki ɔɔ kɔɗ Parizi se lɛ ɔŋ tɛɗ te aak bɛɛ naan Raa ki eyo. Taa debm uun ron̰ raan se, ute Ꞌkɔɔpm baata ɔɔ debm jaay ɔɔp ron̰ baat se, Raa utu an̰ kuun ron̰ raan.» ");
INSERT INTO kyq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓii kalaŋ jeege ɓaano te gaangen utu aay kaay sia gɔtn Isa ki, taa Isa aɗen tɔnd jin̰ doɗe ki. Naɓo kɛn jee mɛtin̰ ki jaay aak kꞋɓaano ute gaange gɔtn Isa ki se, jee se naaɗe uunɗe kaamɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kɛn Isa jaay aak nakŋ naaɗe tɛɗ se, ɔl ɔɔ kꞋɓaano ute gaange se cɛɛn̰ ki ɔɔ gɔtn se naan̰ ɗeekɗen ɔɔ: «Ɔn̰ki gaangen sɛɛm se aɗe ɓaa gɔtum ki, ɔn̰te Ꞌgaasɗeki. Taa jeegen tec aan gɔɔ gaangen se ɓo utu Ꞌkɔŋ gɔtɔ *maakŋ Gaar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ꞋBooyki bɛɛ, mꞋasen taaɗa: debm jaay took te Raa kɔsn gaar don̰ ki aan gɔɔ goon cɔkɔn ey se se, naan̰ se Ꞌkɔŋ kɛnd maakŋ Gaar Raa ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɓii kalaŋ magal Yaudge kalaŋ bini ɓaaɗo tɔnd mɛtn Isa ɔɔ: «Debm dooy jeege, naai debm bɛɛ se, maam tap ɓo mꞋtɛɗn mꞋɔɔ ɗi jaay mꞋkɔŋ *kaajn̰ gɛn daayum se?» ");
INSERT INTO kyq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isa tɛrlin̰ ɔɔ: «Gɛn ɗi jaay naai ɔɔ maam debm bɛɛ se? Debkilim bɛɛ se tap ɓo gɔtɔ; kɛn bɛɛ se, Raa kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Naai lɛ Ꞌjeele nakŋ kɛn Raa taaɗ ɔɔ gɛn tɛɗa se, naan̰ ɔɔ: Ɔn̰te Ꞌkɛɛsn mɛnd nam, ɔn̰te Ꞌkɛɛsn gaabm nam, ɔn̰te Ꞌtɔɔl deba, ɔn̰te Ꞌɓoogo, ɔn̰te Ꞌtɔkŋ taar‑kɔɔɓɔ do nam ki, ɔɔ Ꞌsook koi ki ute bubi ki.» ");
INSERT INTO kyq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gaabm se tɛrl Isa ki ɔɔ: «Nakgen se, gɔtn mꞋiin̰ baatum ki kic ɓo, maam mꞋlee mꞋtɛɗin̰ tɛɗ paac tap.» ");
INSERT INTO kyq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kɛn Isa jaay booy taarin̰ se, ɗeekin̰ ɔɔ: «Ɔɔpiga naka kalaŋ sum. Nakŋ naai ɔk paac se, Ꞌɓaa dugin̰ naatn ɔɔ gursin̰ se Ꞌɓaa Ꞌnigin̰ jee daayge tu. Bin se, ai tooɗn kɔrbɔtɔ maakŋ raa ki; ɔɔ naai lɛ Ꞌɓaaɗo Ꞌdaanuma.» ");
INSERT INTO kyq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kɛn gaabm se jaay booy taar se, maakin̰ tuj kasak kasak, taa naan̰ debm maal mala mala. ");
INSERT INTO kyq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kɛn Isa jaay aakin̰ naan̰ ron̰ tɛrɛcin̰ bardak se, naan̰ ɗeek ɔɔ: «Kɛn jee nak dɛnge jaay, kɛnd *maakŋ Gaar Raa ki se ɔɔn̰ aak eyo! ");
INSERT INTO kyq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɗeere, kɛn gin̰ji jaay deel ute ɓee luppara se ɔɔn̰ɔ; naɓo debm nak dɛna jaay Ꞌkɛnd maakŋ Gaar Raa ki se, ɔɔn̰ cir naan̰ se daala!» ");
INSERT INTO kyq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jeegen iŋg booy taarin̰ se jaay, booy taar se ɗeekin̰ ɔɔ: «Kɛn bin num, naŋa jaay Ꞌkɔŋ kaaja?» ");
INSERT INTO kyq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isa tɛrlɗen ɔɔ: «Nakŋ ɔɔn̰ jikilimge tu se, Raa ki se ɔɔn̰in̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Gɔtn se Piɛr taaɗ Isa ki ɔɔ: «ꞋBooyo, naaje se kꞋjꞋɔn̰oga nakge paac taa jꞋai daan naai.» ");
INSERT INTO kyq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: taa maakŋ Gaar Raa jaay debm ɔn̰o ɓeen̰a, mɛndin̰a, gɛnaan̰gen gaabge, kon̰ te bubin̰a ey lɛ gɛnin̰ge se, ");
INSERT INTO kyq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","debm bin se, kɔr naan̰ utu do naaŋ ki ara sum ɓo, naan̰ utu kɔŋ dɛn cir nakgen kɛn naan̰ ɔn̰o; ɔɔ naan ki se, kɛn kaaɗin̰ jaay aanga num, naan̰ Ꞌkɔŋ kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gɔtn se Isa iik tɔɔk cɛɛs ki ute jee mɛtin̰ kɛn sik‑kaar‑di se ɔɔ naan̰ ɗeekɗen ɔɔ: «ꞋBooyki, ɓɔrse naaje kꞋjꞋook kꞋɓaaki ɓaa Jeruzalɛm ki ɔɔ taargen jee taaɗ taar teeco taar Raa ki raaŋo do dɔkin̰ paac kɛn taaɗ ro *Goon Deb ki se, utu Ꞌkaan ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naaɗe se utu an̰ kɔkŋ kɔl ji jeege tun Yaudge eyo, naaɗe utu an̰ tɛrɛcn̰ mɛtin̰ ki, an̰ naaja ɔɔ an̰ tupm ɓooro ron̰ ki, ");
INSERT INTO kyq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tɛr naaɗe utu an̰ tɔnd ute mɛɛjɛ ɔɔ utu an̰ tɔɔlɔ. Ɔɔ kɛn naan̰ jaay ooy tɛɗga ɓii mɔtɔ num, utu aɗe dur daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gaŋ jee mɛtin̰ ki se ɔnd te mɛtn taar se eyo, taa taar se lɛ, Raa taaɗɗen te mɛtin̰ eyo; ɔɔ taar Isa taaɗɗe se tap ɓo, naaɗe booy ɔk mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kɛn Isa jaay aan gɔɔr ute gɛgɛr Jeriko ki se, naan̰ ɔŋ ɔŋ debm kaam‑tɔɔkɔ jɛŋ ɗoob ki iŋg baay baaya. ");
INSERT INTO kyq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kɛn debm kaam‑tɔɔkɔ jaay booy jee dɛnge deel deel se, naan̰ tɔnd mɛta ɔɔ: «Ne ɗi ɓo tɛɗa?» ");
INSERT INTO kyq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Gɔtn se kꞋtaaɗin̰ jꞋɔɔ: «Kɛn deel se, Isan Nazarɛt.» ");
INSERT INTO kyq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kɛn naan̰ jaay booy bin se, ɔɔɗ ɔɔy makɔn̰ ɔɔ: «Isan, *Goon Daud, naai ɛɛjum dom ki!» ");
INSERT INTO kyq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jee kɛn deel naan ki se, uunin̰ kaamin̰a ɔɔ n̰Ꞌdoa, gaŋ naan̰ tɔɔɗ tɔɔy makɔn̰ cir daala ɔɔ: «Goon Daud, ɛɛjum dom ki!» ");
INSERT INTO kyq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kɛn Isa jaay booy taarin̰ se, naan̰ ɔk ɗaara ɔɔ ɔl kꞋdaŋ kꞋɓaansin̰o. Kɛn naan̰ jaay aan ɔŋ Isa se, naan̰ tɔnd mɛtin̰a ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Naai tap ɓo Ꞌje mꞋai tɛɗn ɗi?» Gaabm se tɛrlin̰ ɔɔ: «Mɛluma, maam mꞋje kaamum Ꞌkɔɔɗn kaaka.» ");
INSERT INTO kyq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isa tɛrlin̰ ɔɔ: «Ɔn̰ kaami Ꞌkɔɔɗn kaaka; taa kaal maaki naai aal dom ki se, aajiga.» ");
INSERT INTO kyq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Gɔtn se sum ɓo, kaamin̰ naar ɔɔɗ aaka, naan̰ ɔk mɛtn Isa ɔɔ *nook Raa. Kɛn jee dɛnge paac jaay aak nakŋ se, naaɗe tɔɔm Raa kici. ");
INSERT INTO kyq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kɛn Isa jaay ɛnd maakŋ gɛgɛr kɛn Jeriko ki se, naan̰ aal teec daan ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kɛn naan̰ aal teec teec daan ki se, gɔtn se gaaba kalaŋ kꞋdaŋin̰ Zaka. Gaabm se magal *jee tɔkŋ miirge ɔɔ naan̰ debm nak dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naan̰ je kaakŋ Isa naɓo naan̰ ɔŋ ɗoob eyo, taa jeege lɛ dɛna ɔɔ naan̰ kic lɛ debm duuku. ");
INSERT INTO kyq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naan̰ aan̰ deel naan ki ɔɔ ɓaa ook do kaag kɛn kꞋdaŋin̰ sikamor, gɛn kaakŋ Isan utu Ꞌdeel gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kɛn Isa jaay aan gɔt kɛn ese se, naan̰ uun kaamin̰ aakin̰a ɔɔ ɗeekin̰ ɔɔ: «Zaka, Ꞌbɔɔyɔ kɛskɛ! Jaaki se, maam mꞋje mꞋɓaa kiŋg ɓee naai ki.» ");
INSERT INTO kyq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaka naar aal bɔɔyo jɛs ɔɔ dɔɔɗ ɔkin̰ ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kɛn jee dɛnge paac jaay aak nakŋ se, naaɗe baag mooy naaŋ ki dir dir ɔɔ: «Aakki tu, gaabm se ɓaaga kiŋg ɓee debm tɛɗn *kusin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Num Zaka ɗaar naan Mɛljege tu, ɗeekin̰ ɔɔ: «ꞋBooyo, Mɛluma. Mɛtn maalum se, maam mꞋan̰ kɛɗn jee daayge tu ɔɔ kɛn maam ɓo mꞋuunga nakŋ nam lɛ, mꞋan̰sin̰ kɔgŋ mɛt sɔɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Gɔtn se Isa tɛrlin̰ ɔɔ: «Jaaki, jee maakŋ ɓee kɛn ese se ɔŋga kaaja, taa naai kic Ꞌteeco maakŋ mɛtjil *Abraam ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Taa *Goon Deba se, ɓaaɗo je jee kɛn iigga kiigi ɔɔ aɗen kaaja.» ");
INSERT INTO kyq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kɛn jeege jaay booy booy taarin̰ se, kaaɗ kɛn se naan̰ aanga gɔɔr te Jeruzalɛm. Gɔtn se, jeege saap ɔɔ kɛn naan̰ jaay aanga sum ɓo, *Raa utu kɔsn gaara do jeege tu. Taa naan̰ se ɓo, Isa taaɗɗen ute kaal naagŋ taara. ");
INSERT INTO kyq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naan̰ taaɗɗen ɔɔ: «Gaaba kalaŋ bin se, jꞋoojin̰ ɓo naan̰ deb gaara. Naan̰ iin̰ ɓaa taa naaŋ kɛn dɔkɔ, taa jꞋan̰ ɓaa kɔl gaara jaay ɓo sɔm aɗe tɛrlɛ. ");
INSERT INTO kyq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kɛn naan̰ iin̰ ɓaa ɓaa se, daŋo jee tɛɗn naabin̰ge sik ɔɔ nigɗen tammage gɛn daab; deba kic naan̰ ɛɗin̰ kalaŋ kalaŋ ɔɔ ɗeekɗen ɔɔ: ‹Tammagen se, oojin̰ki don̰a kɔr maam mꞋaɗe tɛrl se.› ");
INSERT INTO kyq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Gaŋ jee naaŋin̰ ki mala se, ɔɔɗ undin̰a ɔɔ naaɗe ɔl jeege ɓaa taaɗ deb kɛn an̰ kɔl gaara se ɔɔ: ‹Gaabm se naaje kꞋje ajen tɛɗn gaarje eyo.› ");
INSERT INTO kyq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Kɛn naan̰ jꞋɔlin̰o gaara jaay ɔk tɛrl ɓaaɗo naaŋin̰ ki se, naan̰ ɔl kꞋdaŋo jee tɛɗn naabin̰gen naan̰ nigɗen gurs se, taa Ꞌkaakŋ nakŋ kɛn naaɗe ɔŋ do ki se. ");
INSERT INTO kyq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Debm deet deet se, ɓaaɗo ɗeekin̰ ɔɔ: ‹Mɛluma, tammi gɛn daab kɛn naai ɛɗum se, maam mꞋtɛɗin̰ oojga kɛn kuuy sik do ki daala.› ");
INSERT INTO kyq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mɛlin̰ ɗeekin̰ ɔɔ: ‹Kɛse jiga! Naai se debm tɛɗn naabm mɛc; taa nakŋ cɔkɔn maam mꞋɛɗi jaay, naai ɔkin̰ga jiga se, ɓɔrse, do gɛgɛrge tun sik se, maam mꞋai kɔnd naai ɓo Ꞌtɛɗn magalin̰a.› ");
INSERT INTO kyq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Debm gɛn k‑dige jaay aan se, ɗeekin̰ ɔɔ: ‹Mɛluma, tammi gɛn daabm kɛn naai ɛɗum se, maam mꞋtɛɗin̰ oojga kɛn kuuy mii do ki daala.› ");
INSERT INTO kyq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naan̰ ɗeek deb kɛn se ɔɔ: ‹Kɛse jiga! Naai kic, mꞋai kɔnd magal do gɛgɛrge tun mii se.› ");
INSERT INTO kyq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Deb kuuy ɓaaɗo ɗeekin̰ ɔɔ: ‹Mɛluma, aaka! Kɛse ɓo tamman gɛn daabi se. Maam mꞋdɔɔk mꞋɔyisin̰ maakŋ koon kal ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Taa maam lɛ mꞋɓeeri ɓeere, naai lɛ tɛɗi ɔɔn̰ɔ. Kɛn nakŋ naai ey kic ɓo, naai uun naai ki ɔɔ maakŋ‑gɔtn kɛn naai ɔɔc te ey kic ɓo, naai ɓaa oojin̰ naai ki.› ");
INSERT INTO kyq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gaŋ mɛlin̰ se ɗeekin̰ ɔɔ: ‹Do taari kɛn naai taaɗum se sum ɓo, maam mꞋjeeli, naai se debm tɛɗn naabm jig eyo. Naai lɛ Ꞌjeelum maam se tɛɗum ɔɔn̰ɔ ɔɔ nakŋ maam ey kic lɛ, maam mꞋuun maam ki, ɔɔ maakŋ‑gɔtn maam mꞋɔɔc te ey kic lɛ, maam mꞋɔj maam ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Num gɛn ɗi jaay Ꞌbaate kɔmbum gursum baŋki ki se? Bin se, ɓii kɛn maam mꞋaɗe tɛrl se, mꞋan̰ kɔŋin̰ am koojn̰ ziiɗn do ki!› ");
INSERT INTO kyq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gɔtn se, tɛr naan̰ taaɗ jeege tun iŋg cɛɛn̰ ki gɔtn ese se ɔɔ: ‹Tammin̰ jin̰ ki se, uunin̰ki ɔɔ ɛɗin̰ki deb kɛn ɔk tamma sik se.› ");
INSERT INTO kyq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jee se ɗeekin̰ ɔɔ: ‹Mɛlje, naan̰ ɓo ɔk tammage siki!› ");
INSERT INTO kyq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gɔtn se mɛlɗe ɗeekɗen ɔɔ: ‹ꞋBooyki mꞋasen taaɗa: debm kɛn ɔk se, jꞋan̰ kɛɗn do ki. Num debm ɔk ey se lɛ, kɛn cɔkɔn naan̰ ɔk se kic ɓo jꞋan tɔsn naatn. ");
INSERT INTO kyq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Num jee taamooyumgen je ɔɔ maam mꞋaɗen tɛɗn gaarɗe ey se, Ꞌtɔk Ꞌɓaanɗekiro ara ɔɔ Ꞌtɔɔlɗeki naanum ki.›» ");
INSERT INTO kyq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ deel naan jeege tu ɔɔ uun ɗoobo gɛn kookŋ ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kɛn Isa aan gɔɔr ute Bɛtpajɛ ute Betani kɛn cɛɛsn *kɔsn ɔlib ki se, maakŋ jeege tun mɛtin̰ ki se, naan̰ ɔl jeege di naaba, ");
INSERT INTO kyq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ɔɔ naan̰ ɗeekɗen ɔɔ: «ꞋƁaaki maakŋ naaŋ kɛn naanse ki se. Kɛn naase ɛndki kɛnd se, aki kɔŋ goon buuru kꞋdɔɔkin̰ga dɔɔkɔ, kɛn ɓii kalaŋ nam ook te do ki eyo. ꞋTuut Ꞌɓaansin̰kiro. ");
INSERT INTO kyq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kɛn nam jaay tɔndga mɛtse ɔɔ: Goon buuru se, Ꞌtuut Ꞌɓaanki gay num, Ꞌtɛrlin̰ki ɔɔki: kɛse Mɛlje ɓo jen̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jee kɛn jꞋɔlɗe naaba se, ɓaa ɔŋ nakŋ se aan gɔɔ kɛn Isa taaɗɗeno. ");
INSERT INTO kyq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kɛn naaɗe jaay tuut tuut goon buuru se, mɛlin̰ge ɗeekɗen ɔɔ: «Goon buuru se, Ꞌtuut Ꞌɓaanki gay?» ");
INSERT INTO kyq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naaɗe tɛrlɗen ɔɔ: «Kɛse Mɛlje ɓo jen̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gɔtn se, naaɗe ɔk ɓaano ute goon buuru se Isa ki, ɔɔ naaɗe tɔɔɗ taal kal magalɗege do buur ki ɔɔ uun ɔnd Isa do ki. ");
INSERT INTO kyq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kɛn naan̰ jaay ɓaa ɓaa se, jeege tɔɔɗ taal kal magalɗege ɗoob kɛn naan̰ aan deel se. ");
INSERT INTO kyq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kɛn naan̰ bɔɔy bɔɔy do *kɔsn ɔlib ki se, jee mɛtin̰ kɛn te dɛnin̰ se, maakɗe raapo ɔɔ baag tɔɔm Raa makɔn̰ɔ taa nakŋ‑kɔɔɓgen kɛn naaɗe aako se. ");
INSERT INTO kyq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Naaɗe ɗeek ɔɔ: «Ɔn̰ Raa Ꞌtɛɗn bɛɛn̰a do Gaar kɛn ɓaaɗo ute ro Mɛljege Raa se! Ɔn̰ tɔɔsɛ Ꞌtɛɗn maakŋ raa ki ɔɔ Raa kɛn raan maakŋ raa ki se ɔn̰ jꞋan̰ *nooko.» ");
INSERT INTO kyq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Gɔtn se *Parizigen kandum maakŋ jee dɛnge tu se, ɗeek Isa ki ɔɔ: «Debm dooy jeege, jee mɛti ki se, uunɗen kaamɗe kꞋdoa!» ");
INSERT INTO kyq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Isa tɛrlɗen ɔɔ: «ꞋBooyki mꞋasen taaɗa: kɛn naaɗe jaay doga kic lɛ, kogen tooɗ ɓaa se ɓo Ꞌtɔɔɗn tɔɔyɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kɛn Isa aan cɛɛ Jeruzalɛm ki jaay uun kaamin̰ aak gɛgɛr se, naan̰ baag keeme, ");
INSERT INTO kyq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ɗeek ɔɔ: «Jeruzalɛm, bɛɛki num, ɓii jaaki se ɓo naai Ꞌjeel ɗoobm kɛn naai an Ꞌkɔŋ lapia naɓo aaca, nakŋ se naai ɔŋ aak ɔk te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɗeere, ɓiigen utu aɗe ɓaa naan ki se, jee wɔɔyige utu kiin̰ gurugŋ nakŋ kɛn Ꞌgaasn jeeige kɔŋ teec eyo, jaay ɓo naaɗe utu ai kooco. ");
INSERT INTO kyq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jee wɔɔyige se utu ai tɛrɛcɛ ɔɔ an tɔɔl ute jeeige ɔɔ ɓeigen jꞋiin̰in̰ se, naaɗe utu an̰ ru naŋ tak tak ɔɔ ko gam tap ɓo jꞋan̰ kɔŋ do naapin̰ ki eyo. Taa ɓii kɛn Raa ɓaayo kaaka se lɛ, naai Ꞌjeel te eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Naan̰ kɛn se, Isa ɓaa ɛnd daan bɔɔr Ɓee Raa ki, ɔɔ naan̰ baag tuur jeegen ɓaano te nakɗege gɛn zoa. ");
INSERT INTO kyq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naan̰ taaɗɗen ɔɔ: «Taar se kꞋraaŋin̰ga raaŋ maakŋ Kitap ki, jꞋɔɔ: Ɓee maam se tɛɗn ɓee kɛn jeege ansum keeme. Naɓo gaŋ naase, Ꞌtɛɗin̰ki tɛɗga: gɔtn jee ɓoogge.» ");
INSERT INTO kyq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ɓii‑raa, Isa se lee dooy jeege daan bɔɔr Ɓee Raa ki; gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal Yaudge se, je ɗoobm an̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Naɓo nakŋ jaay naaɗe an̰ tɛɗn don̰ ki se, naaɗe ɔŋ te ɗoobin̰ eyo, taa jeege paac je ɓo gɛn kiŋg booy taarin̰ kɛn naan̰ lee dooyɗe se sum. ");
INSERT INTO kyq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɓii kalaŋ kɛn Isa dooy dooy jeege daan bɔɔr *Ɓee Raa ki, ɔɔ taaɗɗen taaɗn Labar Jiga se, gɔtn se, *magal jee tɛɗn sɛrkɛ Raage tu, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute magal taa ɓee Yaudge se, ɓaaɗo ɔŋin̰a, ");
INSERT INTO kyq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɔɔ tɔnd mɛtin̰a ɔɔ: «ꞋTaaɗjen tu, naai tap ɓo tɔɔgi se ɔŋin̰o gay jaay ɔli Ꞌtɛɗ nakgen bin se? Ey lɛ, kɛn ɛɗi tɔɔgɔ jaay ɔɔ Ꞌtɛɗn naan̰ se, tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isa tɛrlɗen ɔɔ: «Maam kic mꞋɔk taara kalaŋ, mꞋje tɔnd mɛtse. ꞋTaaɗumki tu: ");
INSERT INTO kyq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kɛn ɔlo Jan‑Batist jaay *batiz jeege se, *Raa, lɔɓu jikilimge?» ");
INSERT INTO kyq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gɔtn se, naaɗe baag saapa ɔɔ taaɗ te naapa ɔɔ: «Naan̰ se, jꞋan̰ki tɛrl jꞋɔɔki ɗio? Kɛn kꞋtaaɗkiga jꞋɔɔki: ‹Raa› lɛ, naan̰ ajeki ɗeekŋ ɔɔ: ‹Gɛn ɗi jaay Ꞌbaate Ꞌkuunki taar Jan se?› ");
INSERT INTO kyq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Num kɛn kꞋtaaɗkiga jꞋɔɔki: ‹Jikilimge ɓo ɔlin̰o› lɛ, jee dɛnge se ajeki tund tɔɔl ute koa, taa jeege se lɛ paac jeel maakɗe ki Jan‑Batist se, naan̰ debm taaɗ taar teeco taar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gɔtn se, naaɗe tɛrlin̰ ɔɔ: «Gɔtn naan̰ ɓaano se, naaje kꞋjeel eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Isa tɛrlɗen ɔɔ: «Maam kic num, mꞋasen kɔŋ taaɗn debm kɛn ɛɗum tɔɔgɔ gɛn tɛɗn nakgen se eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gɔtn se, Isa baag taaɗn jeege tu ute kaal naagŋ taara ɔɔ: «Gaaba kalaŋ tɛɗ jinɛn bin̰, ɔn̰in̰ kaam ji jeege ɔɔ taaɗɗen ɔɔ: kɛn jinɛnɛ se jaay oojga num naase kic aki kɔŋ bɛɗse. Ɔɔ naan̰ iin̰ ɓaa mɛrtɛ se gɛn tɛrl kɛskɛ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kɛn kaaɗn kugŋ koojn̰ bin̰ jaay aan se, naan̰ ɔlo debm tɛɗn naabin̰ gɔtn jeege tun lee tɛɗin̰ naaba maakŋ jinɛnin̰ ki se, taa an̰o Ꞌkɔkŋ bɛɗin̰a. Num gaŋ jee se ɔk tɔnd dɛrɛŋ debm kɛn naan̰ ɔlin̰o naaba se ɔɔ ɔn̰in̰ ɓaa jin̰ sik. ");
INSERT INTO kyq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kɛn mɛl jinɛnɛ jaay aakin̰ naan̰ ɓaaɗo jin̰ sik se, naan̰ ɔl debm tɛɗn naabm kuuy daala. Naan̰ kic kɛn ɓaa aan se, naaɗe naajin̰a ɔɔ tɔnd dɛrɛŋin̰a tuurin̰ ɓaa jin̰ sik. ");
INSERT INTO kyq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tɛr naan̰ ɔl debm tɛɗn naabm kuuy gɛn k‑mɔtɔge. Naan̰ se, naaɗe tɔnd awarin̰a ɔɔ tuurin̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Gɔtn se, mɛl jinɛnɛ se baag taaɗ ute maakin̰ ɔɔ: ‹Kɛse tap ɓo mꞋan̰ tɛɗn mꞋɔɔ ɗi? Ɓɔrse maam mꞋaɗen kɔl goon maak‑jema; bin sum ɓo sɔm naaɗe Ꞌtookŋ kuun taarin̰a.› ");
INSERT INTO kyq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Num kɛn goon maak‑jen̰ jaay ɓaa ɔŋɗe se, ɔɔ jee tɛɗn naabge maakŋ jinɛnɛ ki jaay aakin̰ se, naaɗe baag taaɗn ute naapa ɔɔ: ‹Naan̰ se ɓo, kɛn bubin̰ ooyga num utu Ꞌtɛɗ mɛl jinɛnɛ se; iin̰ki kꞋtɔɔlin̰ki ɔɔ jinɛnɛ se, ajeki kɔɔpm naajege tu!› ");
INSERT INTO kyq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bin se, naaɗe ɔk teecn̰sin̰ naatn maakŋ jinɛnɛ ki se ɔɔ ɓaa tɔnd tɔɔlin̰a.» Isa tɔnd mɛtɗe ɔɔ: «Bin se, kɛn mɛl jinɛnɛ jaay ɓaaɗoga num, jee se naan̰ aɗen tɛɗn ɔɔ ɗi? ");
INSERT INTO kyq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kɛn naan̰ jaay ɓaaɗoga se, jee se naan̰ aɗen tɔɔl naatn, ɔɔ jinɛnin̰ se lɛ naan̰ an̰ kɛɗin̰ kaam ji jeege tun kuuy.» Kɛn jeege jaay booy taar kɛn Isa taaɗɗen bin se, naaɗe ɗeek ɔɔ: «Nakgen bin se, ɔn̰te Ꞌkaana!» ");
INSERT INTO kyq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Gɔtn se, Isa aakɗe daan kaamɗe ki tɛn̰ɛn̰ ɔɔ ɗeekɗen ɔɔ: «Taar kɛn Raa taaɗn maakŋ Kitap ki gɔtn ese, je ɗeekŋ ɔɔ ɗi kɛn ɔɔ: Ko kɛn jee kiin̰ ɓeege baatin̰ se, naan̰ se ɓo tɛɗga ko kɛn Ꞌgakŋ ɓea. ");
INSERT INTO kyq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɔɔ debm jaay oocga do ko kɛn jee kiin̰ ɓeege baatin̰ se lɛ, Ꞌtɛrɛcɛ, ɔɔ debm kɛn ko se oocga don̰ ki lɛ, an̰ daala.» ");
INSERT INTO kyq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gɔtn ese sum ɓo, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute *magal jee tɛɗn sɛrkɛ Raage tu jaay booy taar se, naaɗe naar je an̰ kɔkɔ, naɓo naaɗe ɓeer jeege tu. Ey num, kaal naagŋ taar kɛn Isa taaɗ se, naaɗe jeelga, kɛse naan̰ taaɗ ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Naan̰ kɛn se, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute *magal jee tɛɗn sɛrkɛ Raage tu se baagin̰ tɔnd baala; naaɗe ɔlin̰ jeege gɔtin̰ ki ɔɔ jee se aal raay aan gɔɔ naaɗe jee tɛɗn nakgen ute ɗoobin̰a. Naaɗe je kɛn Isa jaay taaɗ tujn̰ga num, naaɗe an̰ kɔkŋ kɔlin̰ kaam ji magal taa naaŋ gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Naaɗe ɓaaɗo taaɗin̰ ɔɔ: «Debm dooy jeege, naaje kꞋjeeli naai se Ꞌtaaɗ taara ɔɔ Ꞌdooy jeege ute ɗoobin̰a, ɔɔ naai lɛ Ꞌtaaɗ Ꞌbɛɛr nam ki eyo; ɗoobm Raa se naai Ꞌdooyin̰ jeege tu ute kɛn mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ɓɔrse, Ꞌtaaɗjen tu: do *Ko Taar naajege tu se, Sezar se jꞋan̰ kɔgŋ miiri, lɔɓu jꞋan̰ kɔg ey lɛ?» ");
INSERT INTO kyq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gaŋ Isa jeel raayɗe se, ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Uun Ꞌɓaankiro te tamma kalaŋ, mꞋan̰ kaak tu.» Naaɗe uun ɓaano ute tamma se Isa ki ɔɔ naan̰ tɔnd mɛtɗe ɔɔ: «Kaam‑nirl doa te ro kɛn kꞋraaŋin̰ maak ki se tap ɓo gɛn naŋa?» Naaɗe tɛrlin̰ ɔɔ: «Gɛn Gaar Sezar.» ");
INSERT INTO kyq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gɔtn se naan̰ tɛrlɗen ɔɔ: «Kɛn bin num, nakŋ gɛn Gaar Sezar se, ɛɗin̰ki nakin̰a, ɔɔ gɛn Raa lɛ, ɛɗin̰ki nakin̰ kici.» ");
INSERT INTO kyq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ute taar kɛn Isa jaay taaɗɗen naan jeege tu se, naaɗe ɔŋin̰ naan̰ taaɗ tujin̰ te eyo. Num taar kɛn naan̰ tɛrlɗesin̰ se, ɔkɗen taaɗ eyo ɔɔ gɔtn se ɔlɗe naaɗe do ɗɛk. ");
INSERT INTO kyq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gɔtn se jeegen kꞋdaŋɗe *Sadusege se, kandum bini, ɓaaɗo ɔŋ Isa. Ɔɔ naaɗe se ɓo kɛn naaj ɔɔ jeegen ooyga kooy se, aɗe kɔŋ dur daan yoge tu ey sum. Taa naan̰ se ɓo, naaɗe tɔnd mɛtn Isa ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Debm dooy jeege, *Musa raaŋjeno maakŋ Kitap ki ɔɔ: kɛn deba ɔk mɛnda jaay ooy ɔn̰ te goon ey se, bɛɛki num, gɛnaan̰ se Ꞌkɔkŋ mɛndin̰a taa koojn̰ mɛtjili gɛnaan̰ kɛn ooy se. ");
INSERT INTO kyq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ꞋƁooyo, gɛnaage cili, kon̰ɗe kalaŋ. Debm deet deet se ɔk mɛnda, naɓo ooy ooj te goon eyo. ");
INSERT INTO kyq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Debm k‑dige se kic ɓaaɗo ɔk mɛnd se. ");
INSERT INTO kyq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɔɔ debm gɛn k‑mɔtɔge tu se kic ɓo ɓaaɗo ɔk mɛnd se, bini ɔl naaɗen cili se tɔkŋ naamga mɛnd se paac. Naɓo maakɗe ki se, deb kalaŋ tap ɓo ooj te goon eyo. ");
INSERT INTO kyq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɔɔ kaam mɔɔtn se, mɛnda se kic ɓaaɗo ooyo. ");
INSERT INTO kyq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bin se, ɓii kɛn jaay jeegen ooyga kooy aɗe dur daan yoge tu se, mɛnd se tap ɓo Ꞌtɛɗn mɛnd naŋa? Taa naaɗen cili se lɛ, tɔk naamin̰ga paac.» ");
INSERT INTO kyq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Gaŋ Isa tɛrlɗen ɔɔ: «ꞋBooyki: jee do naaŋ ki ara se, gaabge ute mɛndge se lee tɔkŋ naapa. ");
INSERT INTO kyq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Num ɓii kɛn Raa dur jeegen ooyga kooy daan yoge tu se jee kɛn naan̰ bɛɛr tɔɔɗɗenga tɔɔɗn kɛn ɓaa tiŋg maakŋ duni kɛn kuuy se, naaɗe se Ꞌkɔŋ tɔkŋ naap ey sum. ");
INSERT INTO kyq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anum mɔɔtn naaɗe Ꞌkɔŋ kooy eyo, taa naaɗe se Ꞌtec aan gɔɔ *kɔɗn Raage. Ɔɔ naaɗe se Ꞌtɛɗga gaan Raage taa naaɗe duroga daan yoge tu se. ");
INSERT INTO kyq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ɔɔ mɛtn taar jeegen utu Ꞌdur daan yoge tu se, Musa mala, taaɗin̰ga taaɗ do dɔkin̰a, kaaɗ kɛn naan̰ aako pooɗo ɔk kɔk maakŋ ji kaag ki. Naan̰ kɛn se ɓo, Musa daŋ Mɛljege Raa ɔɔ Raa gɛn *Abraam, Raa gɛn Isaka ɔɔ Raa gɛn *Yakub. ");
INSERT INTO kyq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Raa se, naan̰ Raa jeegen ooyga kooy eyo, num naan̰ se, Raa jee zɛɛrɛ; gɔtn naan̰ ki se, jeege paac utu iŋg zɛɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Gɔtn ese, jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage kandum, ɗeekin̰ ɔɔ: «Debm dooy jeege, taari se, naai taaɗin̰ga jig aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Taa naan̰ se, gɛn tɔnd mɛtin̰ do taarge tun kuuy se, mɔɔtn nam tɔnd te mɛtin̰ ey sum. ");
INSERT INTO kyq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tɛr Isa tɔnd mɛtɗe ɔɔ: «ꞋTɛɗ ɔɔ ɗi jaay naase Ꞌtaaɗki ɔɔki al‑Masi, naan̰ Goon Daud se? ");
INSERT INTO kyq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Taa Daud mala, taaɗ maakŋ Kitapm Kaa Keem Raa ki ɗeek ɔɔ: Mɛljege Raa taaɗo Mɛlum ki ɔɔ: ꞋƁaaɗo iŋg do ji daamum ki, ");
INSERT INTO kyq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bini jee taamooyige se mꞋaɗen tɛɗn naai utu Ꞌkiŋg doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Kɛn Daud jaay ɓo daŋin̰ Mɛlum se, anum tɛɗ ɔɔ ɗi jaay Mɛlin̰ Ꞌtɛɗn goon Daud se?» ");
INSERT INTO kyq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaaɗ kɛn jee dɛnge paac iŋg booy booy taarin̰ se, Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ɔɔɗki dose ro jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, taa naaɗe se je lee te kal magalɗege gɛn magal roɗe, ɔɔ kɛn ɓaaga bɔɔr ki se, naaɗe je jeege aɗen tɛɗn tɔɔsɛ naaɗe ki. Ɔɔ kɛn naaɗe jaay aanga maakŋ *ɓee kɛn Yaudge lee tusn maak ki se, naaɗe je kiŋg gɔtn naan ki ɔɔ kɛn aanga gɔtn kɔs ki se, naaɗe je gɔtn naan ki kici. ");
INSERT INTO kyq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naaɗe se ɓo jee kɛn ɔs naŋ ji mɛnd‑daayge ɔɔ kɛn naaɗe jaay ɓaaga keem Raa num, naaɗe uulu uulu taa jeege aɗe kaaka. Num gaŋ naaɗe se, Raa utu aɗe dabar kusin̰ aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Gɔtn se, daan bɔɔr *Ɓee Raa ki se, Isa uun kaamin̰ aak jee maalgen ɔmb kɔmb sɛrkɛ Raa ki maakŋ tukul kaag ki se. ");
INSERT INTO kyq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Maakɗe ki se, naan̰ aak mɛnd‑daay kalaŋ kic kɛn ɔɔɗ kɔɔɗ yɛɛɓin̰a ɓaaɗo ɔmb tammage sɛɛm sɛɛm dio. ");
INSERT INTO kyq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ɔɔ Isa ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ, mꞋasen taaɗa: mɛnd‑daay kɛn daay naŋ takŋ ese se, ɔmbga dɛn cir jee ɓaa se paac. ");
INSERT INTO kyq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Taa jeegen se paac se ɛɗ do nak dɛnɗe ki, gaŋ mɛnd‑daay se nakŋ naan̰ ɔkŋ kɛn an tiŋg se ɓo, naan̰ ɓaaɗo ɔmbin̰ paac.» ");
INSERT INTO kyq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Gɔtn se jee mɛtin̰ge taaɗ ɔɔ: «*Ɓee Raa se, ute kogen jꞋiin̰in̰ga ute nakgen jeege ɓaano *sɛrkɛ Raa ki jaay kꞋtamarin̰ tɛɗ aak bɛɛ bɛɛ se.» Gaŋ Isa ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ɓii kalaŋ se, ɓee kɛn aakin̰ki ɗaar aak bɛɛ bɛɛ se, jeege utu an̰ ru naŋ tak. Kon̰gen rɛɛs aak bɛɛ bɛɛ se, utu wɔɔkŋ kalaŋ kalaŋ ɔɔ ko tap ɓo Ꞌkɔŋ tooɗn do naapin̰ ko ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gɔtn se, jee mɛtin̰ ki se tɔnd mɛtin̰a ɔɔ: «Debm dooyje, Ꞌtaaɗjen tu, nakgen se Ꞌkaan nuŋ ki? Ɔɔ naan̰ se Ꞌtɛɗn ɔɔ ɗi jaay ɓo naaje jꞋan kaakŋ jeel ro ki se?» ");
INSERT INTO kyq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isa taaɗɗen ɔɔ: «Ɔndki kɔndɔ! Ɔn̰te Ꞌkɔn̰ki jeege asen kaan̰ dala. Taa jeege dɛna utu aɗe ɓaa ute roma ɔɔ utu asen taaɗn ɔɔ: ‹Maam ɓo *al‑Masi› ɔɔ: ‹Ɓɛrɛ, kaaɗn dunia aan naŋ se, ɔɔpga gɔɔrɔ.› Jee bin se, ɔn̰te Ꞌtookki taarɗe. ");
INSERT INTO kyq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","«Kɛn Ꞌbooykiga jeege jaay baaga kɔɔsn maan bɔɔrɔ, ɔɔ jeege baagga tɛɗn pitini te naapa num, ɔn̰te Ꞌɓeerki. Taa nakgen se jaay utu Ꞌkaana naɓo, duni se Ꞌkɔŋ naŋ ey ɓɔrtɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tɛr Isa taaɗɗen ɔɔ: «Naase utu aki kaakŋ jee taa naaŋ kaam kalaŋ utu kiin̰ bɔɔrɔ ute jee taa naaŋ kuuy. Taa naaŋ gaar kaam kalaŋ utu kiin̰ bɔɔrɔ te taa naaŋ gaar kɛn kuuy. ");
INSERT INTO kyq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maakŋ naaŋge tun mɛtin̰ naaŋa utu Ꞌte makɔn̰ɔ ɔɔ gɔtgen mɛtin̰ge se ɓo utu Ꞌtɔɔlɔ ɔɔ kɔɔn̰gen ɗɛt ɗɛt se utu Ꞌkaan do jeege tu. Maakŋ raa ki se, naase utu aki kaakŋ nakŋ‑kɔɔɓgen magal magal kɛn utu Ꞌteecn̰ nirl jeege. ");
INSERT INTO kyq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Kɔr jaay nakgen se Ꞌkaan se, naase jꞋutu jꞋasen tɔkɔ, jꞋasen dabara ɔɔ jꞋutu jꞋasen kɔjn̰ bɔɔrɔ maakŋ *ɓee kɛn Yaudgen lee tusn maak ki se ɔɔ jꞋutu jꞋasen tɔl daŋgay ki. Ɔɔ taa maam se, jꞋutu jꞋasen ɓaa naan gaarin̰ge tu ute naan magal taa naaŋge tu. ");
INSERT INTO kyq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kɛn nakgen se jaay Ꞌkaan dose ki se, naase amki tɛɗn saaɗumge. ");
INSERT INTO kyq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kɛn Ꞌɓaaki ɓaa se ɔndin̰ki dose ki jiga ɔɔ ɔn̰te Ꞌsaapki do taar kɛn naase anki nakŋ dose, ");
INSERT INTO kyq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","num maam mala ɓo mꞋutu mꞋasen kɛɗn jeel‑taara ute taargen naase aki ɓaa taaɗa; kɛn naase jaay Ꞌbaagkiga taaɗa se, jee taamooysege se paac Ꞌkɔŋ naajn̰ do taarse ki eyo ɔɔ Ꞌkɔŋ ɗoobm kɛn asen Ꞌkɔŋ tɛrl taar eyo. ");
INSERT INTO kyq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɔɔ tɛr kɛn̰sege ute bubsege, gɛnaasege, taassegen gɔɔrɔ ute mɛɗsege se, utu asen tɔkŋ tɔl ji jee wɔɔysege tu ɔɔ maakse ki se, jee mɛtin̰ge jꞋutu jꞋaɗen tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","«Taa maam se, jeege paac utu asen kɔɔɗn kundu. ");
INSERT INTO kyq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naɓo bɛɛkŋ dose kic ɓo, kalaŋ Ꞌkɔŋ kut eyo. ");
INSERT INTO kyq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɔkki maakse tɔɔgɔ. Aayki kaamse ɔɔ naase aki kɔŋ *kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tɛr Isa taaɗɗen daala ɔɔ: «Kɛn naase jaay aakkiga asgarge ɓaaɗo ɔl gurugga Jeruzalɛm num, Ꞌjeelki kɛse kaaɗn tɛrɛcin̰, ɓɛrɛ aanga. ");
INSERT INTO kyq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bin se, jee kɛn iŋg taa naaŋ Jude ki se kꞋjꞋaan̰ kꞋjꞋook maakŋ koge tu ɔɔ jeegen iŋg maakŋ gɛgɛr kɛn Jeruzalɛm ki se, kꞋjꞋaan̰ kꞋteecn̰ naatn ɔɔ jeegen naatn lɛ, jꞋɔn̰te tɛrlo ɓeene. ");
INSERT INTO kyq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Taa ɓii kɛn se ɓo, *Raa utu Ꞌkɔjn̰ bɔɔrɔ do jeege tu aan gɔɔ kɛn Kitapm Raa taaɗno. ");
INSERT INTO kyq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɓii kɛn se, mɛndgen mɛndkaamge ute ko gaangen gɛnɗege aay kaay si se, aɗen tɛɗn ɔɔn̰ aak eyo. Taa Raa se, maakin̰ taarin̰ do jeege tun taa naaŋ kɛn gɔtn ese ɔɔ naaɗe se, utu Ꞌkɔɔɗn yɛɛɓɗe dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jee Jeruzalɛm ki se, jꞋutu jꞋaɗen tɔɔl ute gɔrɗ‑jɛrlɛ ɔɔ jꞋaɗen dirin̰ ɓulu ɔɔ jꞋaɗen wɔɔkŋ maakŋ naaŋge tu paac. Ɔɔ Jeruzalɛm se, jꞋutu jꞋan̰ kɔsɔ, ɔɔ jeegen Yaudge ey se utu kiŋg doɗe ki bini kaaɗɗe utu Ꞌkaas jaayo.» ");
INSERT INTO kyq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tɛr Isa taaɗɗen daala ɔɔ: «Naan̰ kɛn se, daan kaaɗ ki, laap ki ɔɔ maakŋ k‑dijge tu se utu aki kaakŋ nakŋ‑kɔɔɓge. Ɔɔ kuulu utu Ꞌkɔl do baar ki ɔɔ Ꞌtɛɗn maane Ꞌtɔnd te naapa Ꞌkeem makɔn̰ pum pum ɔɔ Ꞌtɛɗn jeegen do naaŋ ki paac se, ɓeere aɗen kɔkɔ ɔɔ nirlɗe utu Ꞌteece. ");
INSERT INTO kyq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jeege jaay Ꞌkaakŋ nakgen ɔɔn̰ utu ɓaaɗo do naaŋ ki se, jee mɛtin̰ge se ɓeere sum ɓo utu aɗen tɔɔlɔ, taa nakgen ɔk tɔɔgɔ maakŋ raa ki paac se, utu Ꞌtea. ");
INSERT INTO kyq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Gɔtn se, jeege Ꞌkaakŋ Goon Deba utu aɗe bɔɔy maakŋ gapara ki aɗe ɓaa ute tɔɔgŋ Raa, kɛn Ꞌtɛɗn gɔtɔ wɔɔr kɛlɛŋ. ");
INSERT INTO kyq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kɛn nakgen se jaay baagga kaan num, Ꞌɗaapki rose ɔɔ uunki dose raan, taa Raa se ɔɔpga gɔɔrɔ asen kɔɔɗn dose.» ");
INSERT INTO kyq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tɛr Isa aalɗen naagŋ taara ɔɔ: «Aakki tu ko ba ute kaaggen kuuy paac se. ");
INSERT INTO kyq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kɛn naaɗe jaay baagga dɔɔb kamba num, naase Ꞌjeelki ɔɔki mɛt‑kijiri aanga ɔɔ ɓara ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bin num, naase kic ɓo aakkiga nakgen se jaay baagga kaan se, Ꞌjeelki *maakŋ Gaar Raa se ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ꞋBooyki bɛɛ mꞋasen taaɗa: jee duni kɛn ɓɔrse se Ꞌkooy naŋ ey sum ɓo, nakgen se paac utu Ꞌkaana. ");
INSERT INTO kyq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maakŋ raa ute do naaŋa se utu Ꞌdeele, num taarumge se, Ꞌkɔŋ deel eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Isa taaɗɗen daala ɔɔ: «Ɔndki kɔndɔ. Ɔn̰te Ꞌdɛrlki rose gɛn kaay koono, ro kɔs magal ki ɔɔ ɔn̰te kuunki nirlse do nakge tun *duni ki; ey num ɓii kɛn *Goon Deba aɗe ɓaa se, asen kɔkŋ do jise ki, ");
INSERT INTO kyq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","aan gɔɔ gakala lee tɔnd daage se. Jeege paac do naaŋ ki se kic ɓo nakŋ se utu aɗen kaan doɗe ki bini. ");
INSERT INTO kyq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Num naase iŋgki do mɛtɛkse ki; eemki Raa daayum taa nakgen se kɛn aan dose kic ɓo asen tɛɗ ɗim eyo. Ɔɔ ɓii kɛn naane se, naase aki ɓaa ɗaar naan Goon Deb ki.» ");
INSERT INTO kyq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ɓii‑raa Isa lee dooy jeege daan bɔɔr *Ɓee Raa ki ɔɔ kɛn aanga nɔɔr num, naan̰ teec ɓaa lee tooɗ do *kɔsn ɔlib ki. ");
INSERT INTO kyq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kɛn gɔtɔ iipga num, jeege paac ɓaaɗo lee ɔŋin̰ daan bɔɔr Ɓee Raa ki gɛn booy taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɓii laa mappan ɔk ɔrɔm eyo kɛn kꞋdaŋin̰ *laa Paak jaay ɔɔp gɔɔr se, ");
INSERT INTO kyq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","gɔtn se, *magal jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage je ɗoobm an goon̰ kɔkŋ Isa taa an̰ ɓaa tɔɔlɔ, naɓo naaɗe ɓeer ɓeer jeege tu. ");
INSERT INTO kyq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Gɔtn se *Ɓubm sitange ɓaaɗo ɛnd maakŋ Judas, kɛn kꞋdaŋin̰ Iskariɔt se ɔɔ naan̰ kic mɛtn jee Isagen kɛn sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naan̰ ɓaa taaɗ ute magal jee tɛɗn sɛrkɛ Raage tu ute magal jee kɛn lee bɔɔb *Ɓee Raa se, taa Ꞌkɔŋ raay kɛn naan̰ an kɔkŋ Isa aɗesin̰ kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kɛn naaɗe booy taar se, maakɗe raapo ɔɔ naaɗe taaɗin̰ga taaɗ ɔɔ utu an̰ kɛɗn gurs. ");
INSERT INTO kyq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naan̰ kɛn se, Judas tooko ɔɔ baag toom Isa taa kɛn naan̰ jaay aak jeege gɔtɔ num, naan̰ aɗesin̰ taaɗa ɔɔ naaɗe an̰ kɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɓii gɛn laa mappan ɔk ɔrɔm ey jaay aan se, ɓii kɛn se ɓo bɛɛki num, kꞋtɔjn̰ gaan baatge gɛn laa Paak gɛn Yaudge. ");
INSERT INTO kyq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Taa naan̰ se ɓo, Isa ɔl Piɛr ute Jan ɗeekɗen ɔɔ: «ꞋƁaa Ꞌtɛɗjeki kɔsɔ gɛn laa Paak taa jꞋaki ɓaa kɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naaɗe tɔnd mɛtin̰ ɔɔ: «Naai Ꞌje jꞋaisin̰ tɛɗn kaam gay?» ");
INSERT INTO kyq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Isa tɛrlɗen ɔɔ: «ꞋƁooyki: kɛn Ꞌɓaaki ɓaa maakŋ gɛgɛr ki se, naase aki dɔɔɗn ute gaaba uuno kɔɔyɔ ɗooc te maane se. Ɔkki mɛtin̰a ɔɔ Ꞌɓaaki maakŋ ɓee kɛn naan̰ an kɛnd maak ki se. ");
INSERT INTO kyq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kɛn aankiga num, Ꞌtaaɗki mɛl ɓee ki se ɔɔki: ‹Debm dooy jeege ɔljeno ɔɔ kꞋtɔnd mɛti ɔɔ ɓee gay jaay ɓo naan̰ an kɔsn kɔsn laa Paak te jee mɛtin̰ ki se?› ");
INSERT INTO kyq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Num naan̰ asen taaɗn ɓee magala kɛn jꞋiin̰in̰ do ɓee ki raan, ɔɔ maakŋ ɓee se, nakin̰ge paac aas kart. Gɔtn ese ɓo ajeki tɛɗn kɔsn gɛn laa Paak.» ");
INSERT INTO kyq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kɛn naaɗe ɓaa aan se, ɔŋ nakge se paac aan gɔɔ kɛn Isa taaɗɗeno. Gɔtn se ɓo naaɗe tɛɗ kɔsn gɛn laa Paak. ");
INSERT INTO kyq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kɛn kaaɗn kɔsɔ jaay aan se, Isa ɓaaɗo iŋg kaaɗn tabil ki ute jee kaan̰ naabin̰ge. ");
INSERT INTO kyq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gɔtn se Isa ɗeekɗen ɔɔ: «Maam mꞋje ute maakum paac mꞋkɔsn *laa Paak ute naase jaay ɓo mꞋdabara. ");
INSERT INTO kyq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ꞋBooyki mꞋasen taaɗa: maam mɔɔtn tap ɓo Laa Paak se, mꞋkɔŋ kɔs ey sum, bini nakŋ kɛn Laa Paak je taaɗa se utu Ꞌkaan ɗoobin̰ ki *maakŋ Gaar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gɔtn se naan̰ uun *kɔɔpm kɛn ɔk tɔtn koojn̰ bin̰ se jin̰ ki, tɔɔm *Raa ɔɔ ɗeekɗen ɔɔ: «Ɔkki ɔɔ Ꞌnig aayin̰ki ute naapa. ");
INSERT INTO kyq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ꞋBooyki mꞋasen taaɗa: tɔtn koojn̰ bin̰ ese se, mɔɔtn mꞋan̰ kɔŋ kaaye ɗɔɔl ute naase ey sum, bini maakŋ Gaar Raa aɗe ɓaa.» ");
INSERT INTO kyq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tɛr naan̰ uun mappa jin̰ ki, tɔɔm Raa ɔɔ dup ɛɗɗesin̰a ɔɔ ɗeekɗen ɔɔ: «Kɛse ɓo roma kɛn mꞋɛɗin̰ *sɛrkɛ taa naase. Nakŋ se Ꞌlee Ꞌtɛɗin̰ki bini ɔɔ Ꞌsaapki dom ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kɛn naaɗe ɔs aas se, naan̰ uun kɔɔpm ɔk tɔtn koojn̰ bin̰ se ɔɔ tɛɗin̰ bin kici, taaɗɗen ɔɔ: «Tɔtn koojn̰ bin̰ kɛn maakŋ kɔɔpm ese se kɛse je taaɗn ɔɔ: *Raa dɔɔkga kiji ute naase ɔɔ kɛse ɓo moosum kɛn ɔɔy taa naase.» ");
INSERT INTO kyq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kɛn naaɗe iŋg ɔs kɔs se, Isa ɗeekɗen ɔɔ: «Aakki, debm am kut se ɔlga jin̰ maakŋ baay ki ute maam tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","*Goon Deba se, utu Ꞌkooy aan gɔɔ kɛn Raa taaɗni, num gaŋ ɔɔn̰ deb kɛn an̰ kut se!» ");
INSERT INTO kyq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kɛn naaɗe jaay booy taar se, naaɗe baag taaɗn ute naapa ɔɔ maakɗe ki se, naŋa ɓo Ꞌkɔŋ tɛɗn nakŋ se. ");
INSERT INTO kyq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Gɔtn se, jee mɛtn Isa ki baag tɛɗn dɛkɛn̰ɛ ɔɔ naaj ute naapa ɔɔ maakɗe ki se, naŋa ɓo Ꞌtɛɗn magala. ");
INSERT INTO kyq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gaŋ Isa ɗeekɗen ɔɔ: «ꞋJeelki, gaarin̰gen do naaŋ ki se iŋg do jeege tu tɛɗ jeege kusin̰a, ɔɔ magalgen tiŋg do jeege tu se, je jeege aɗen daŋ jee bɛɛ. ");
INSERT INTO kyq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Num naase se, ɔn̰te Ꞌtɛɗki bini. Anum maakse ki se, debm je Ꞌtɛɗn magal se, ɔn̰ Ꞌtɛɗ ron̰ aan goon cɔkɔ ɔɔ debm je tɛɗn naana se, ɔn̰ Ꞌtɛɗn debm kaan̰ naabse. ");
INSERT INTO kyq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Debm magal ɓo kɛn gay: debm kɛn iŋg ɔs kɔs lɔɓu debm kɛn kɔsɔ ooyga num lee ɓaaɗo tɔndin̰ jeege tu se ne? Debm ɔs kɔs se ɓo debm magal ey la? Anum maam mꞋiŋg maakse ki se aan gɔɔ mꞋdebm tɛɗn naabse. ");
INSERT INTO kyq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kɛn maam maakŋ dubar ki se, naase ɓo, jee daayum iŋgkiro ute maama. ");
INSERT INTO kyq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aan gɔɔ Bubum ɔn̰um gaara maam ki se, maam kic mꞋɔn̰sen gaara naase ki, ");
INSERT INTO kyq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","taa naase aki ɓaa kɔsɔ ɔɔ aki kaaye ute maama maakŋ gaarum ki. Ɔɔ naase utu aki kiŋg do kaag doge tu gɛn kɔjn̰ bɔɔrɔ do taa ɓee gaan *Israɛlge tun sik‑kaar‑di se.» ");
INSERT INTO kyq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gɔtn se Isa ɗeek Simon ki ɔɔ: «Simon, Simon, Ꞌbooyo! *Ɓubm sitange se tɔndga mɛta ɔɔ je ai lɔɔyɔ aan gɔɔ teen̰ kꞋlɔɔyin̰ maakŋ gɛrt ki se. ");
INSERT INTO kyq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gaŋ maam mꞋtɔndga mɛtn Raa taa naai, taa kaal maaki kɛn naai aal dom ki se, Ꞌtɛɗn cɛr eyo. Ɔɔ kɛn naai jaay tɛrloga gɔtum ki num, gɛnaaige se, ɛɗɗen kaay kaama taa Ꞌtɛɗn jee tɔɔgɔ naan maam ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Gaŋ Piɛr tɛrlin̰ ɔɔ: «Mɛluma, maam mꞋtookŋ mꞋɓaa daŋgay ki ute naai ɔɔ mꞋkooy ute naai.» ");
INSERT INTO kyq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tɛr Isa tɛrlin̰ ɔɔ: «ꞋBooyo, Piɛr, mꞋai taaɗa: jaaki se, kɔr kɔrɔn̰jɔ Ꞌkɔɔy ey sum ɓo, naai Ꞌnaajn̰ ɗɔɔl mɔtɔ ɔɔ Ꞌɗeekŋ ɔɔ Ꞌjeelum eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gɔtn se, Isa ɗeekɗen daala ɔɔ: «Kaaɗ kɛn mꞋɔlseno naaba jaay mꞋtaaɗsen mꞋɔɔ ɔn̰te Ꞌkuunki gursi, ɓɔɔnɔ ɔɔ saa se, ɗim baatsege la?» Naaɗe tɛrlin̰ ɔɔ: «Ɗim baatje te eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tɛr naan̰ ɗeekɗen daala ɔɔ: «Ɓɔrse se, debm ɔk gurs lɛ, uunu ɔɔ debm ɔk ɓɔɔnɔ kic lɛ, uunu; ɔɔ debm ɔk gɔrɗ‑jɛrlɛ ey lɛ dugŋ naatn ute kal magalin̰a ɔɔ n̰Ꞌdugŋ gɔrɗ‑jɛrlɛ. ");
INSERT INTO kyq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Taa naan̰ se, maam mꞋɗeekseni: taar kɛn Kitap taaɗ rom ki se, utu Ꞌkaan ɗoobin̰ ki kɛn ɔɔ: naan̰ se se jꞋaalga mun̰ maakŋ jee tujge tu. «Taar se ɓo ɓɔrse aanga ɗoobin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Gaŋ jee mɛtin̰ ki tɛrlin̰ ɔɔ: «Mɛlje, naaje jꞋɔk gɔrɗ‑jɛrlɛ di ara.» Naan̰ tɛrlɗen ɔɔ: «Kɛse bɛɛga sum, taarse se ɔn̰in̰ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Gɔtn se Isa teec ɓaa ook do kɔs ɔlib ki, gɔtn kɛn naan̰ lee ɓaan ro ki. Ɔɔ jee mɛtin̰ ki se, ɓaa ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kɛn naaɗe aan gɔtn ese se, naan̰ ɗeekɗen ɔɔ: «ꞋTɔndki mɛtn Raa taa naase aki koocn̰ maakŋ nakŋ naam ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tɛr Isa iik tɔɔk cɛɛs ki daanɗe ute jee mɛtin̰ ki se kaam kund koa; gɔtn se naan̰ ɛrg naaŋ ki ɔɔ baag tɔnd mɛtn Raa, ");
INSERT INTO kyq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ɗeek ɔɔ: «Bua, kɛn naai Ꞌje num, *kɔɔpm dubar utu Ꞌkaan dom ki se, naai iikin̰ naatn dɔkɔ rom ki. Num gaŋ Ꞌtɛɗ aan gɔɔ kɛn naai maaki jen ro ki, aan gɔɔ kɛn maam ɓo mꞋje se eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gɔtn ese *kɔɗn Raa bɔɔyo maakŋ raa ki ɓaaɗo ɛɗin̰ gaab tɔɔgɔ. ");
INSERT INTO kyq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kɛn Isa jaay maakin̰ tuj kasak kasak se, naan̰ tɔnd mɛtn Raa bini gɔtɔŋgin̰ teec ron̰ ki jaay taɗ naaŋ ki se tec aan gɔɔ mooso. ");
INSERT INTO kyq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kɛn naan̰ tɔnd mɛtn Raa jaay aas se, iin̰ ɓaaɗo ɔŋ jee mɛtin̰ ki ɔɔ ute maak‑tujɗe se ɔlɗen naaɗe tooɗ bia. ");
INSERT INTO kyq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naan̰ ɗeekɗen ɔɔ: «Gɛn ɗi jaay Ꞌtooɗki bi se? Iin̰ki raan ɔɔ Ꞌtɔndki mɛtn Raa, taa aki koocn̰ maakŋ nakŋ naam ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kɛn Isa utu taaɗ taaɗ ɓɔrt sum ɓo, jee dɛnge teeco ɔɔ debm tɔɔɗɗeno se ron̰ Judas. Naan̰ se mɛtn jee Isagen sik‑kaar‑di se. Naan̰ ɓaaɗo cɛɛ Isa ki, baam ɔkin̰a ɔɔ aay ciilin̰. ");
INSERT INTO kyq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɔɔ Isa tɛrlin̰ ɔɔ: «Judas, ute baam kɔkŋ kɛn naai Ꞌbaam ɔkuma ɔɔ aay ciilum se ɓo, naai an kutn *Goon Deba ne?» ");
INSERT INTO kyq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jee kɛn cɛɛ Isa ki jaay aak nakŋ kɛn utu Ꞌtɛɗ se, naaɗe ɗeekin̰ ɔɔ: «Mɛlje, jee ese jꞋaɗen tɔgŋ ute gɔrɗ‑jɛrljege se la?» ");
INSERT INTO kyq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Maakɗe ki se, deb kalaŋ ɔɔɗo gɔrɗ‑jɛrlin̰a ɔɔ ɔg gaaŋ te bi do ji daama gɛn debm tɛɗn naabm *magal debm tɛɗn sɛrkɛ Raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Num gaŋ Isa taaɗɗen ɔɔ: «Ɔn̰ki! Ɔn̰te Ꞌtɛɗki bini.» Ɔɔ Isa ɔl jin̰ ut bi gaabm se ɔɔ gaabm se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gɔtn se Isa taaɗ jeege tun ɓaan̰o kɔkɔ ɔɔ jee se, magal jee tɛɗn sɛrkɛ Raage tu, magal jee kɛn lee bɔɔb *Ɓee Raa ute magal taa Ɓee Yaudge ɔɔ ɗeekɗen ɔɔ: «Naase Ꞌteeckiro ute gɔrɗ‑jɛrlsege ɔɔ sirɗsege se, aan gɔɔ Ꞌɓaakiro kɔkŋ debm ɓoogo. ");
INSERT INTO kyq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ey num ɓii‑raa, maam mꞋtiŋgo ute naase daan bɔɔr Ɓee Raa ki ɔɔ nam tap ɓo ɔŋ ɔl te jin̰ rom ki eyo. Naɓo ɓɔrse se, kaaɗn naasen ɔkki tɔɔgɔ maakŋ gɔt kɛn ɔɔɗ se ɓo, aanga.» ");
INSERT INTO kyq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kɛn naaɗe jaay ɔk Isa se, naaɗe ɓaansin̰o maakŋ ɓee *magal debm tɛɗn sɛrkɛ Raa ki. Naan̰ kɛn se, Piɛr lee tɔl goosɗe kaam mɔɔtn dɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kɛn naaɗe jaay aan se, ɔŋ gɔtn se kꞋtuuyga tuuy pooɗo daan bɔɔr ki ɔɔ jeege iŋg riib riibi ɔɔ Piɛr ɓaaɗo iŋg riib ute naaɗe kici. ");
INSERT INTO kyq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mɛnd tɛɗn naabm gɔtn ese jaay aakin̰ naan̰ iŋg riib riib pooɗo se, naan̰ ɔndin̰ kaama tak ɔɔ ɗeek ɔɔ: «Gaabm se kic debm naan̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Gaŋ Piɛr naaj ɔɔ: «Mɛnd ara, ɓɛrɛ, gaabm se maam mꞋjeelin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tɛr cɔkɔ sum ɓo, deb kuuy aakin̰ se, ɗeekin̰ ɔɔ: «Naai kic Ꞌmɛtn naaɗe.» Ɔɔ Piɛr tɛrlin̰ ɔɔ: «A‑a, maam mɛtn naaɗe eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cɔkɔ sum se, deb kuuy ɓaaɗo ɗeekin̰ daala ɔɔ: «Ɗeer ɗeer, gaabm ese debm naan̰ kici, taa naan̰ se kic kɔɗ Galile.» ");
INSERT INTO kyq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gaŋ Piɛr tɛrlin̰ ɔɔ: «Taari se tap ɓo, naai Ꞌje ɗeekŋ ɔɔ ɗio?» Gaŋ kɔr naan̰ utu taaɗ taaɗ ɓɔrt se sum ɓo, kɔrɔn̰jɔ naar ɔɔɗ ɔɔyɔ. ");
INSERT INTO kyq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gɔtn se, Mɛljege tɛrl aak Piɛr, ɔɔ kɛn kaamɗe jaay dɔɔɗ se, Piɛr naar saap do taar kɛn Mɛljege taaɗin̰o, kɛn ɔɔ: «Jaaki, kɔr kɔrɔn̰jɔ tɔɔy ey sum ɓo, naai am baatn ɗɔɔl mɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gɔtn se naan̰ teeco ɔɔ baag keeme gab gab. ");
INSERT INTO kyq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jee iŋg bɔɔb Isa se, naaɗe tɛrɛcin̰ mɛtin̰a ɔɔ tɔndin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Naaɗe teelin̰ kaamin̰a, tɔndin̰a ɔɔ taaɗin̰ ɔɔ: «Debm taaɗ taar teeco taar Raa ki se, Ꞌtaaɗjen tu: debm kɛn tɔndi se tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Gɔtn ese, naaɗe naajin̰ rap rap. ");
INSERT INTO kyq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tanɔɔrin̰ nɔɔrin̰ se, magal taa ɓee Yaudge, *magal jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage, naaɗe se ɓo jee kɛn lee aak mɛtn taarge, naaɗe tusu paac ɔɔ ɔl jꞋɔk kꞋɓaano te Isa naanɗe ki. ");
INSERT INTO kyq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aan gɔtn se, naaɗe tɔnd mɛtin̰a ɔɔ: «Kɛn naai ɓo *al‑Masi lɛ, Ꞌɗeekjeni.» Isa tɛrlɗen ɔɔ: «Maam mꞋtaaɗsenga kic lɛ, naase aki Ꞌtookki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɔɔ kɛn mꞋtɔnd mɛtse kic lɛ, naase amki Ꞌkɔŋ tɛrl eyo. ");
INSERT INTO kyq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Num naan ki se, *Goon Deba se utu Ꞌɓaa kiŋg do ji daam Raa Sidburku ki.» ");
INSERT INTO kyq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naaɗe paac tɛrlin̰ ɔɔ: «Do taari ki se, naai je ɗeekŋ ɔɔ naai ɓo ꞋGoon Raa ɗaamo?» Isa tɛrlɗen ɔɔ: «Kɛse naase malin̰ge ɓo Ꞌtaaɗki ɔɔki maam Goon Raa.» ");
INSERT INTO kyq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gɔtn se naaɗe ɗeek ɔɔ: «Naase nakage kꞋjeki saaɗn nam kuuy se, gɛn ɗi daala! Naajege lɛ, kꞋbooyin̰kiga te bijege, naan̰ mala ɓo taaɗjeki ute taarin̰a.» ");
INSERT INTO kyq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jee se iin̰o paac taa naap ki, ɔko Isa ɔɔ ɓaansin̰ naan magal *Rɔmɛge tu kꞋdaŋin̰ Pilat. ");
INSERT INTO kyq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Gɔtn se, naaɗe baagin̰ tɔɔl taara don̰ ki ɔɔ: «Naaje kꞋjꞋɔŋo gaabm se tɛɗ tɛɗ pitini maakŋ naaŋje ki. Naan̰ gaas jeege ɔɔ jꞋɔn̰te kɔgŋ miiri Gaar magal iŋg Rɔm ki kɛn kꞋdaŋin̰ Sezar se ɔɔ ɗeek jeege tu ɔɔ naan̰ ɓo *al‑Masi, naan̰ ɓo gaarge.» ");
INSERT INTO kyq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gɔtn se Pilat tɔnd mɛtin̰ ɔɔ: «Naai ɓo Gaar Yaudge la?» Isa tɛrlin̰ ɔɔ: «Aan gɔɔ kɛn naai Ꞌɗeekin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ɔɔ Pilat tɛrl aak *magal jee tɛɗn sɛrkɛ Raage tu ute jee dɛnge se ɔɔ ɗeekɗen ɔɔ: «Gaabm se, maam mꞋɔŋin̰ tuj te ɗim kɛn aas kutin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gaŋ naaɗe dɔɔk taar ɔn̰ eyo ɔɔ ɗeek ɔɔ: «Gaabm se ɔɔs mɛtn jeege ute dooy kɛn naan̰ lee dooy jeege se. Naan̰ baago dooy jeege taa naaŋ Galile ki ute taa naaŋ Jude ki ɔɔ bini ɓɔrse aanga gɔtjege tu Jeruzalɛm ki ara kici.» ");
INSERT INTO kyq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kɛn Pilat jaay booy taarɗe se, tɔnd mɛta ɔɔ: «Gaabm se tap ɓo, Ꞌtɛɗn kɔɗ Galile la?» ");
INSERT INTO kyq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kɛn kꞋtaaɗin̰ jꞋɔɔ Isa se mɛtn jee Gaar Ɛrɔdge se, gɔtn se naan̰ ɔlin̰ gɔtn Ɛrɔd ki, taa ɓii kɛn se, Ɛrɔd kic utu Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kɛn Ɛrɔd jaay aak Isa se, maakin̰ raap aak eyo, taa do dɔkin̰ tap ɓo, naan̰ je an̰ kaaka taa naan̰ se, booyga booy jeege lee ɔɔs kɔɔs maanin̰a. Ɔɔ naan̰ je an̰ tɛɗn nakŋ‑kɔɔɓm gam naanin̰ ki ɔɔ naan̰ Ꞌkaaka. ");
INSERT INTO kyq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naan̰ tɔnd mɛtin̰ ɗɔɔl cɔk cɔk, naɓo Isa tɛrlin̰ taar ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kaaɗ kɛn se, *magal jee tɛɗn sɛrkɛ Raage tu ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se tɔlin̰ taargen deer deer don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ɔɔ Ɛrɔd ute asgarin̰ge se tɛɗin̰ rɛn̰ rɛn̰ ɔɔ tɛrɛcin̰ mɛtin̰ ki. Tɛr naaɗe uusin̰ kal ute ron̰a ɔmb birin̰ birin̰, jaay ɓo naaɗe ɔlin̰ gɔtn Pilat ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ey num, do dɔkin̰ Ɛrɔd te Pilat se taarɗe ɓaa eyo; num gaŋ ɓii kɛn se sum ɓo, naaɗe tɛɗn mɛɗn naapge. ");
INSERT INTO kyq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gɔtn ese Pilat daŋ tus *magal jee tɛɗn sɛrkɛ Raage tu, magalgen gɔtn ese ɔɔ ute jee dɛnge paac, ");
INSERT INTO kyq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ɔɔ naan̰ ɗeekɗen ɔɔ: «Naase ɔk Ꞌɓaamkiro te gaabm ese se ɔɔki naan̰ ɔɔs kɔɔs mɛtn jeege ɔɔ naanse ki se sum ɓo, maam tɔnd mɛtin̰a do taarge tun naase Ꞌtɔlin̰ki don̰ ki paac se, naɓo maam mꞋɔŋin̰ naan̰ tuj te ɗim kɛn aas kutin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Ɛrɔd kic ɓo ɔŋ te taar kɛn aas tɔɔlin̰ eyo jaay ɔlumsin̰o gɔtn ara se. Ɔɔ gaabm se ne ɗim naan̰ tuj jaay jꞋansin̰ tɔɔl ro ki se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ɓɔrse, maam mꞋan̰ kɔnd ute mɛɛjɛ ɔɔ mꞋan̰ kɔn̰ Ꞌɓaa.» ");
INSERT INTO kyq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kɛn *laa Paak jaay aanga tak ɓo, maakŋ jeeɗege tun kꞋtɔkɗe daŋgay ki se, Pilat lee tɔɔɗ tɔlɗe tɔl debm daŋgay kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gɔtn se naaɗe dɔɔb ɔɔɗ ɔɔy taa naapki caa ɔɔ: «Gaabm se, Ꞌtɔɔlin̰a ɔɔ ɔɔɗ ɔljeno Barabasi!» ");
INSERT INTO kyq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ey num Barabas se, jꞋɔkin̰ daŋgay ki taa pitin kɛn naan̰ tɛɗo maakŋ gɛgɛr kɛn Jeruzalɛm ki. Naan̰ kɛn se naan̰ tɔɔloga tɔɔl deba. ");
INSERT INTO kyq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tɛr Pilat tɔnd mɛtɗe daala, taa naan̰ je ɗoobm kɛn an̰ kɔɔɗn kɔl Isa. ");
INSERT INTO kyq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kɛn naaɗe jaay booy taar se, tɛr dɔɔb ɔɔy caa ɔɔ: «Naan̰ se, Ꞌtup Ꞌtɔɔlin̰ ro kaag ki! ꞋTup Ꞌtɔɔlin̰ ro kaag ki!» ");
INSERT INTO kyq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Gɔtn se Pilat tɔnd mɛtɗe gɛn k‑mɔtɔge tu ɔɔ: «Gaabm se tap ɓo tujga ɗi? Ey num maam mꞋɔŋ te ne ɗim kɛn aas tɔɔlin̰ eyo. Ɓɔrse, maam mꞋan̰ kɔnd te mɛɛjɛ ɔɔ mꞋan̰ kɔɔɗn kɔlɔ.» ");
INSERT INTO kyq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gaŋ naaɗe tɔɔy makɔn̰ɔ ɔn̰ eyo ɔɔ taaɗ ɔɔ: «Gaabm se kꞋtup kꞋtɔɔlin̰ ro kaag ki.» Kɛn naaɗe tɔɔy se, tɛɗ dir dir ɓaa deel doa. ");
INSERT INTO kyq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gɔtn se Pilat took gɛn tɛɗn nakgen kɛn naaɗe maakɗe jen ro ki se. ");
INSERT INTO kyq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naan̰ ɔl kꞋɓaa kꞋjꞋɔɔɗ jꞋɔlɗen gaabm kɛn naaɗe jen̰ se; ey num naan̰ ɓo debm pitin tɔɔlɔ deba jaay jꞋɔlin̰ daŋgay ki se. Gaŋ gɛn Isa se, naan̰ ɛɗɗesin̰ kaam jiɗe ɔɔ ɗeekɗen ɔɔ: «ꞋTɛɗin̰ki aan gɔɔ kɛn naase maakse jen ro ki.» ");
INSERT INTO kyq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kɛn naaɗe ɓaan ɓaa te Isa se, naaɗe dɔɔɗ ute gaaba kalaŋ kꞋdaŋin̰ Simon kɔɗ Sirɛn. Naan̰ iin̰o naatn ɔɔ deel deel te ɗoobm se. Naaɗe ɔkin̰ taa tɔɔgɔ gɛn kuun kaagŋ jꞋan̰ ɓaa tupm Isa ro ki se ɔɔ naan̰ uun kaagŋ se ɔɔ leen mɛtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kɛn Isa ɓaa ɓaa se, jeege dɛna ɔk mɛtin̰a. Maakɗe ki se mɛtin̰ge mɛndge ɔɔ mɛndgen se jaay aakin̰ se, tɔnd tarkaaɗɗege tɔɔyɔ eemin̰ nɔɔ. ");
INSERT INTO kyq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isa tɛrl aakɗe ɔɔ ɗeekɗen ɔɔ: «Mɛndgen Jeruzalɛm ki, ɔn̰te Ꞌkeemki taa maama. Num eemki ɓo taa naase malin̰ge ɔɔ taa gɛnsege. ");
INSERT INTO kyq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ꞋBooyki, kaaɗin̰ utu Ꞌkaan se kꞋɗeekŋ jꞋɔɔ: maak‑raapo mɛndkartge tu, mɛndgen ooj nam te te eyo ɔɔ kɛngen siɗege gaange aay nam te te eyo. ");
INSERT INTO kyq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ɓii kɛn naane se, jeege Ꞌtaaɗn koge tu ɔɔ: ‹ꞋToocki doje ki› ɔɔ Ꞌtaaɗn kɔsge tu ɔɔ: ‹ꞋDeebki doje ki›. ");
INSERT INTO kyq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Taa nakgen se jaay aan do ko kaag kɛn zɛɛrɛ se, do ko kaag kɛn tuutu se, tap ɓo Ꞌtɛɗn ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Gɔtn se kꞋtɔk kꞋɓaano ute jeege dio ɔɔ jee se, jee kɛn tujga tuj ɗim, taa jꞋaɗen ɓaa tɔɔl ute Isa. ");
INSERT INTO kyq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kɛn naaɗe jaay aan gɔtn kꞋdaŋin̰: kaaɗn do deba se, naaɗe tup Isa ro kaag ki ɔɔ jee kɛn tujga tuj ɗim se kic kꞋtupɗe ro kaagge tu. Deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji daamin̰ ki ɔɔ deb kalaŋ kꞋjꞋuun kꞋɗaarin̰ do ji jeelin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kɛn Isa jaay kꞋtup kꞋɗaarin̰ ro kaag ki se, ɗeek ɔɔ: «Bua, Ꞌtɔɔlɗe *kusin̰ɗe, taa nakŋ naaɗe tɛɗ se, naaɗe jeel eyo.» Gɛn nigŋ kal Isa se, naaɗe tɛɗin̰ salatia ɔɔ debm kɛn oocin̰ga ɓo uunu uunu. ");
INSERT INTO kyq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gɔtn se jee dɛnge ɗaar aakin̰a; ɔɔ jee magalge se, ɔɔyin̰ koogo mɛtin̰ ki ɔɔ ɗeek ɔɔ: «Jee kuuy se, naan̰ aajɗenoga; kɛn naan̰ ɓo *al‑Masi kɛn *Raa bɛɛr ɔɔɗin̰ ɗeer num, ɓɔrse n̰Ꞌaaj ron̰ mala.» ");
INSERT INTO kyq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asgarge kic ɓo tɛrɛcin̰ mɛtin̰ ki; naaɗe ɓaaɗo cɛɛn̰ ki ɔɔ ɛɗin̰ tɔtn koojn̰ bin̰ kɛn mooy se, ");
INSERT INTO kyq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ɔɔ ɗeekin̰ ɔɔ: «Kɛn naai jaay ꞋGaar Yaudge num, aaj roi mala!» ");
INSERT INTO kyq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kɛn naaɗe jaay utu tupin̰ tup ro kaag ki se ɓo, naaɗe raaŋ ɔlin̰ kaam don̰ ki ɔɔ: Kɛse ɓo Gaar Yaudge. ");
INSERT INTO kyq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Maakŋ jeege tun di kɛn tujga tuj ɗim jaay kꞋtup kꞋtɔɔlɗe ro kaagge tu ute naan̰ se, deb kalaŋ naajin̰ ɔɔ: «Naai ɓo al‑Masi ey la? Kɛn bin num, naai mala aaj roi ɔɔ aajje naaje kici.» ");
INSERT INTO kyq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gaŋ deb kalaŋ uunin̰ kaamin̰ ɗeekin̰ ɔɔ: «Naai se, Ꞌɓeer Raa ki eyo. Ey num, naai Ꞌmaakŋ dubar ki aan gɔɔ naan̰ kici. ");
INSERT INTO kyq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gɛn naaje se, kɛn kꞋdabarje kic ɗoobin̰a. Taa naaje se kꞋtujga tuju. Num gaŋ naan̰ se, tuj te ɗim eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gɔtn se naan̰ ɗeek Isa ki ɔɔ: «Isa, ɓiin naai aɗe ɓaa maakŋ gaari ki se, Ꞌsaap dom ki.» ");
INSERT INTO kyq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isa tɛrlin̰ ɔɔ: «ꞋBooy bɛɛ mꞋai taaɗa: jaaki sum ɓo, naai Ꞌɓaa te maam gɔtn Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kɛn kaaɗa jaay ɓaa kaasn katar tir se, do naaŋa te magalin̰ se gɔtɔ ɓaa ilim dib bini aan katar do tɛgɛr ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kaaɗa paac, jꞋɔŋ jꞋaakin̰ eyo. Naan̰ kɛn se, kal deer magal kɛn kꞋgaaŋ maakŋ *Ɓee Raa se, nɛɛpo raan daan ki bini aan naaŋ ki tak. ");
INSERT INTO kyq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gɔtn ese, Isa ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ: «Bua, kom se, mꞋɔn̰isin̰ kaam ji.» Kɛn naan̰ taaɗ taarin̰ aas se, ɔn̰ kon̰ teece. ");
INSERT INTO kyq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kɛn bubm asgarge jaay aak nakŋ deel se, naan̰ *nook Raa ɔɔ ɗeek ɔɔ: «Ɗeer ɗeer, gaabm se, naan̰ debm daan ki!» ");
INSERT INTO kyq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɔɔ jeegen kɛn ɓaaɗo aak nakŋ deel se, kɛn naaɗe jaay uun tɛrl ɓaa ɓaa se, maakɗe tuj se tɔnd tarkaaɗɗege. ");
INSERT INTO kyq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Num jee deelga deel ute naan̰a ɔɔ mɛndgen baago kɔkŋ mɛtin̰ taa naaŋ Galile ki se, naaɗe se paac ɗaar gɔtn dɔkɔ jaay ɓo aakin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gɔtn se, gaaba kalaŋ ron̰ Yusup ɔɔ naan̰ se, maakŋ magalge tun kɛn lee aak mɛtn taarge se. Naan̰ se debm bɛɛ ɔɔ debm daan ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Gaabm se iin̰o maakŋ gɛgɛr Yaudge tun kꞋdaŋin̰ Arimate. Ɔɔ nakŋ jeen̰ge tɛɗ paac se, naan̰ ɔl te taarin̰ maak ki eyo. Taa naan̰ iŋg aak kaak kaam *maakŋ Gaar Raa kɛn utu Ꞌkaan se. ");
INSERT INTO kyq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Gaabm se ɓaa ɔŋ Pilat ɔɔ tɔnd mɛtin̰a taa an̰ kɔn̰ ro Isa se, naan̰ an̰ ɓaa kɔl maakŋ iiɓ ki. ");
INSERT INTO kyq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat ɔn̰in̰sin̰a ɔɔ naan̰ ɓaa bɔɔy ro Isa naatn ro kaag ki. Gɔtn se Yusup teelin̰ ute kal duubu ɔɔ ɓaa ɔl aalin̰ maakŋ iiɓ kɛn jꞋɔŋ ko sum ɓo jꞋuɗ kꞋɗaapin̰a. Ɔɔ iiɓm se, ɓii kalaŋ jꞋɔl kꞋnaam te nam maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɓiin se, jeege ɗaap ɗaap roɗe taa tɛgɛr sum ɓo, *ɓii sebit se baaga. ");
INSERT INTO kyq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mɛndgen baago daan Isa Galile ki se, ɓaa te Yusup kalaŋ gɛn ɓaa kaakŋ iiɓm kɛn jꞋɔl jꞋaal ro Isa maak ki se. ");
INSERT INTO kyq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ɔɔ kɛn naaɗe jaay ɔk tɛrl ɓeen se, naaɗe ɓaa tɛɗo nakŋ oot nijimi ute itir gɛn ɓaa kɔtn ro Isa ki. Ɓii sebit ki se, naaɗe iŋg tɔɔl maakɗe taa *Ko Taar kɛn Raa ɛɗo Musa ki se gaasɗenga gaasa ɔɔ jꞋɔn̰te tɛɗn ɗim. ");
INSERT INTO kyq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ɓii dumas ki, tanɔɔrin̰ nɔɔrin̰ sum ɓo, mɛndgen se iin̰ ɓaa taa ɓaaɗ kɛn jꞋɔl jꞋaalo ro Isa maak ki se, ute nakŋ oot nijimi ɔɔ ute itir kɛn naaɗe tɛɗin̰o se. ");
INSERT INTO kyq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kɛn naaɗe jaay aan se, ɔŋ ko kɛn kꞋgaasn taa ɓaaɗa se, kꞋdircilin̰ga naatn. ");
INSERT INTO kyq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Num kɛn naaɗe jaay ɛnd maak ki se, ɔŋ te ro Mɛljege Isa eyo. ");
INSERT INTO kyq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Naaɗe aak nakŋ se, ɔkɗen taaɗ eyo. Gɔtn ese sum ɓo, naaɗe naar aak gaabge dio ute kalɗege raap lak lak. ");
INSERT INTO kyq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kɛn naaɗe aak jeegen se, dɔrlɔ ɔɔ nirlɗe teece ɔɔ gɔtn se naaɗe no doɗe naaŋ ki. Ɔɔ gaabgen se taaɗɗen ɔɔ: «Debm zɛɛrɛ jaay Ꞌjen̰ki daan jeege tun ooyga kooy se tap ɓo, gɛn ɗi? ");
INSERT INTO kyq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gɔtn ara se, naan̰ gɔtɔ! Gaŋ naan̰ se duroga daan yoge tu. Naase Ꞌsaapki tu do taar kɛn naan̰ taaɗseno taa naaŋ Galile ki, ");
INSERT INTO kyq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kɛn naan̰ ɗeekseno ɔɔ: ‹*Goon Deba se jꞋutu jꞋan̰ kɔkŋ kɔl ji jee *kusin̰ge tu. Naaɗe utu an̰ tupm ro kaag ki ɔɔ ɓii k‑mɔtɔge tu se, naan̰ utu Ꞌduru.›» ");
INSERT INTO kyq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Gɔtn ese se naaɗe naar saap do taar kɛn Isa taaɗɗeno se. ");
INSERT INTO kyq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Taa ɓaaɗ ki se, naaɗe ɔk tɛrlo ɓaaɗo taaɗ jee mɛtin̰ kɛn sik‑kaar‑kalaŋ ute jee kuuy paacn̰ iŋg te naaɗe se. ");
INSERT INTO kyq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɛndgen ɓaano ute labar se, naaɗe Mari kɛn iin̰o Magdala ki ute Jaan, Mari ko Jak ute mɛndgen mɛtin̰ge kuuy kici; naaɗe ɓaaɗo taaɗn nakŋ se *jee kaan̰ naabm Isage tu. ");
INSERT INTO kyq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kɛn jee kaan̰ naabm Isage jaay booy taar se, naaɗe baate tooko, booyɗesin̰ aan gɔɔ taar jee dɛrlge. ");
INSERT INTO kyq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Anum Piɛr se, iin̰ aan̰ ɓaa taa ɓaaɗ ki. Ɔɔ kɛn naan̰ jaay aan se, no aak maakŋ ɓaaɗa, aak kalge kalin̰ ki sum ɔɔ num nakŋ kɛn deel se, ɔkin̰ taaɗ eyo. Gɔtn se naan̰ ɔk tɛrl ɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ɓii kɛn se sum ɓo, jee mɛtn Isa kɛn di se, iin̰ ɓaa ɓaa maakŋ naaŋ kɛn kꞋdaŋin̰ Emaus. Emaus ute Jeruzalɛm se, daanin̰ dɔk cɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kɛn naaɗe ɓaa ɓaa se, uun maan nakgen kɛn deelo Jeruzalɛm ki se. ");
INSERT INTO kyq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kɛn naaɗe jaay maan maan ute naapa se, gɔtn se Isa mala ɔŋ mɛtɗe ɔɔ ɔk ɗoob ute naaɗe tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naaɗe aakin̰ ute kaamɗe, naɓo ɗim gaasɗe naaɗe ɔŋ aak ɔkin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Gɔtn se Isa tɔnd mɛtɗe ɔɔ: «Mɛtn taar ɗi jaay Ꞌɓaaki ɓaa jaay Ꞌlee Ꞌnaajki te naapa se?» Gɔtn se naaɗe ɔk ɗaar yip ɔɔ maakɗe tuju. ");
INSERT INTO kyq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Maakɗe ki se, deb kalaŋ kꞋdaŋin̰ Klɛopas se tɛrlin̰ ɔɔ: «Jee Jeruzalɛm ki paac booyga nakgen deel ɓiin naane se. Ɔɔ naai Ꞌkali ki sum ɓo, Ꞌbooy te ey ne!» ");
INSERT INTO kyq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isa tɔnd mɛtɗe ɔɔ «Ɗi ɓo tɛɗa?» Naaɗe tɛrlin̰ ɔɔ: «Nakŋ jaay aan do Isan iin̰o Nazarɛt ki se. Naan̰ se debm magal taaɗ taar teeco taar Raa ki. Naan *Raa ki ɔɔ naan jeege tu se, naan̰ taaɗ taara ute tɔɔgŋ Raa ɔɔ tɛɗ nakgen deel doa. ");
INSERT INTO kyq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gaŋ *magal jee tɛɗn sɛrkɛ Raajege tu, ute magaljege se ɔk ɔlin̰ ji jeege tu ɔɔ ɔjin̰ bɔɔrɔ don̰ ki taa jꞋan̰ ɓaa tɔɔlɔ ɔɔ naaɗe ɓaa tup tɔɔlin̰ ro kaag ki. ");
INSERT INTO kyq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ey num, naaje kꞋjꞋiŋg kꞋjꞋɔnd doje jꞋɔɔ, naan̰ ɓo debm kɛn utu kɔɔɗn do gaan *Israɛlge. Num nakgen se jaay deel sum se, ɓɔrse tɛɗga ɓii mɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɗeere, mɛndgen kandum maakje ki se, ɓaaɗo taaɗjen taar deel doa, taa naaɗe, tanɔɔrin̰ nɔɔrin̰ se, iin̰ iŋgo taa iiɓ ki, ");
INSERT INTO kyq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɔɔ naaɗe ɔŋ te ro Isa eyo. Naaɗe ɔk tɛrl ɓaaɗo taaɗjen ɔɔ naaɗe aako *kɔɗn Raage ɔɔ kɔɗn Raage se ɗeekɗeno ɔɔ: ‹Isa num, utu te kaamin̰a!› ");
INSERT INTO kyq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jeejegen mɛtin̰ge kic iin̰ iŋgo taa iiɓ ki ɔɔ ɔŋo nakge se aan gɔɔ kɛn mɛndge taaɗjeno se sum, naɓo yon̰ se, naaɗe aakin̰ te te eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gɔtn se Isa ɗeekɗen ɔɔ: «Naase se dose biga ɔɔ taargen jee taaɗ taar teeco taar Raa ki taaɗo se lɛ, naase booy ɔkki mɛtin̰ eyo ɔɔ naase lɛ Ꞌtook aalki maakse do ki yɔkɔɗ eyo! ");
INSERT INTO kyq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bɛɛki se, *al‑Masi Ꞌdabar, jaay ɓo Raa an̰ *nooko.» ");
INSERT INTO kyq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɔɔ naan̰ baagɗen tɔɔkŋ mɛtn taargen kɛn Kitap taaɗ ron̰ ki ɔɔ naan̰ uun mɛtin̰ ute Kitapm *Musa bini aan do Kitapm jee taaɗ taar teeco taar Raa ki paac. ");
INSERT INTO kyq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kɛn naaɗe jaay aan cɛɛ naaŋ kɛn naaɗe ɓaa ɓaa maak ki se, Isa ɓaa aan gɔɔ aki gaaŋ taaro. ");
INSERT INTO kyq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Num gaŋ naaɗe ɔk ɗaar mɛtin̰ ki tak ɗeekin̰ ɔɔ: «Ɔɔp te naaje, taa kaaɗa ɓaaga ɔɔ gɔtɔ kic lɛ, ɔkga jin̰a.» Ɔɔ naan̰ tooko ɛnd ɓaa iŋg ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kɛn naaɗe iŋg ɔs kɔs do tabil ki se, Isa uun mappa jin̰ ki, tɔɔm Raa, dupin̰a ɔɔ ɛɗɗesin̰a. ");
INSERT INTO kyq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Gɔtn se kaamɗe ɔɔɗ aaka ɔɔ naaɗe aak jeelin̰a; naɓo kaaɗ kɛn se sum ɓo, naan̰ iig naanɗe ki. ");
INSERT INTO kyq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naaɗe taaɗ ute naapa ɔɔ: «Kɛn kꞋɓaakiro ɓaa ɗoob ki jaay, naan̰ taaɗ tɔɔkjeki mɛtn taar maakŋ Kitap ki se, taarin̰ se ɔs maakjege aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naan̰ kɛn se sum ɓo, naaɗe naar iij‑ɔk tɛrl Jeruzalɛm ki; ɔɔ naaɗe ɓaa ɔŋ jeegen sik‑kaar‑kalaŋ se, tusga ute jee kɛn leeɗo ute naaɗe kalaŋ se. ");
INSERT INTO kyq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kɛn naaɗe jaay aan se, jee se dɔɔɗɗen ute taargen se ɔɔ ɗeekɗen ɔɔ: «Ɗeere, Mɛljege se, duroga daan yoge tu ɗeer ɗeer ɔɔ teecoga naan Simon ki!» ");
INSERT INTO kyq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɔɔ naaɗe kic taaɗɗen nakŋ kɛn aanɗeno ɗoob ki ɔɔ kaaɗ kɛn Isa uun mappa, tɔɔm Raa jaay ɓo, naaɗe aak jeelin̰ ro ki se. ");
INSERT INTO kyq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kɛn naaɗe utu taaɗ taaɗ sum ɓo, gɔtn se naaɗe aak Isa mala ɗaar ɗaar daanɗe ki. Ɔɔ naan̰ ɗeekɗen ɔɔ: «Ɔn̰ tɔɔsn Raa Ꞌtɛɗn te naase!» ");
INSERT INTO kyq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Num kɛn naaɗe aakin̰ se, nirlɗe teece ɔɔ ɓeere ɔkɗe ɔɔ naaɗe saap ɔɔ kaaɗn naane nirl nam. ");
INSERT INTO kyq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gɔtn se Isa ɗeekɗen ɔɔ: «Nirlse teec bin se gɛn ɗi? Gɛn ɗi jaay maakse naaj bin se? ");
INSERT INTO kyq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aakki jimge ute jɛmge. Kɛse maam mala. Aakki ɔɔ Ꞌɓaaɗo utu Ꞌnaamum ki ute jise. Nirl se, naan̰ ɔk cɛŋge ute daa ro aan gɔɔ gɛn maam se eyo.» ");
INSERT INTO kyq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kɛn naan̰ jaay taaɗɗen aas se, naan̰ taaɗɗen jin̰ge ute jɛn̰ge. ");
INSERT INTO kyq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kɛn naaɗe aakin̰ se, maakɗe‑raapo naɓo, maakɗe ɔk naaja taa nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo. Gɔtn se Isa ɗeekɗen ɔɔ: «Gɔtse ki ara se, ɔkki nakŋ kɔsɔ la?» ");
INSERT INTO kyq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɔɔ naaɗe ɛɛp ɛɗin̰ kɛn̰j kɛn naaɗe naaŋin̰ga naaŋ se. ");
INSERT INTO kyq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naanɗe ki se sum ɓo, naan̰ uun ɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tɛr Isa ɗeekɗen ɔɔ: «Kɛse ɓo taargen mꞋiŋg mꞋtaaɗseno, kaaɗ kɛn mꞋtiŋgo te naase. Bɛɛki num, taargen *Ko Taar kɛn Raa ɛɗo Musa ki, jee taaɗ taar teeco taar Raa ki ute Kaa Keem Raa taaɗo rom ki se, utu Ꞌkaan ɗoobin̰ ki paac.» ");
INSERT INTO kyq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gɔtn se, naan̰ ɔɔɗɗen biɗe gɛn booy kɔkŋ mɛtn taar maakŋ Kitap ki. ");
INSERT INTO kyq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tɛr naan̰ ɗeekɗen daala ɔɔ: «Taa naan̰ se ɓo, Kitap taaɗ ɔɔ: *al‑Masi se utu Ꞌdabara ɔɔ Ꞌkooyo ɔɔ daan ɓii k‑mɔtɔge tu se, naan̰ utu Ꞌdur daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Anum jꞋaɗe kupm mɛta Jeruzalɛm ki ɔɔ kꞋɓaa taaɗn mɛtjil jeege tun do naaŋ ki paac ute roma gɛn tɛrl maakɗe do Raa ki taa Raa se aɗen tɔɔl *kusin̰ɗege. ");
INSERT INTO kyq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɔɔ naase se ɓo amki Ꞌtɛɗn saaɗumge. ");
INSERT INTO kyq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ɔɔ maam mꞋutu mꞋaseno kɔl nakŋ kɛn Bubum taaɗ ɔɔ utu aseno Ꞌkɛɗ se. Bin num, naase se, iŋgki Jeruzalɛm ki ara bini aki kɔŋ tɔɔgŋ aɗe kiin̰ gɔtn Raa ki se.» ");
INSERT INTO kyq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gɔtn se Isa ɓaanɗe naatn kaam aak Betani ɔɔ kɛn naaɗe jaay aan gɔtn ese se, naan̰ uun jin̰ raan ɔɔ ɔɔɗɗen ɓooro. ");
INSERT INTO kyq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kɛn naan̰ utu ɔɔɗɗen kɔɔɗ ɓooro sum ɓo, gɔtn se naan̰ iik took ute naaɗe cɔkɔ ɔɔ Raa uun ɓaansin̰ maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kɛn naaɗe jaay ɛrgo naanin̰ ki ɔɔ tɔɔmin̰o aas se, naaɗe iij‑ɔk tɛrl ɓaa Jeruzalɛm ki ute maak‑raapo dɛna. ");
INSERT INTO kyq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɔɔ ɓii‑raa, naaɗe lee tɔɔm Raa daan bɔɔr *Ɓee Raa ki.");
INSERT INTO kyq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Do dɔkin̰ kɛn *Raa utu aalo kaal do naaŋa se, debm kɛn kꞋdaŋin̰ Taara se, naan̰ utu tap. Ɔɔ naan̰ tiŋg te Raa ɔɔ naan̰ mala kic ɓo Raa. ");
INSERT INTO kyq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Anum do dɔkin̰ kɛn Raa utu aalo kaal do naaŋa se, debm kꞋdaŋin̰ Taara se, naan̰ iŋg te Raa tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nakgen kɛn Raa aalɗe paac se, naan̰ aalɗe te debm kɛn kꞋdaŋin̰ Taara se ɔɔ ne ɗim kɛn Raa aalin̰ jaay te naan̰ ey se, gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Debm kɛn kꞋdaŋin̰ Taara se, naan̰ ɓo debm ɛɗ kaaja jeege tu. Ɔɔ kaajn̰ naan̰ ɛɗɗen se ɓo, wɔɔrɗen gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɔɔ gɔtn wɔɔr se, wɔɔr maakŋ gɔtn kɛn ɔɔɗɔ naɓo gɔtn ɔɔɗ se ɔŋ gaasin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɓii kalaŋ se Raa ɔlo debm kaan̰ naabin̰a ɔɔ naan̰ se ron̰ Jan. ");
INSERT INTO kyq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naan̰ ɓaaɗo gɛn tɛɗn saaɗa, taa taaɗn saaɗn gɔtn wɔɔr se jeege tu, kɛn bin se jeege paac jaay booy ɔkga taarin̰ num, Ꞌkuunu. ");
INSERT INTO kyq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jan se, naan̰ ɓo gɔtn wɔɔr eyo, num naan̰ se ɓaaɗo taaɗn saaɗn debm kɛn kꞋdaŋin̰ gɔtn wɔɔr se ɓo jeege tu. ");
INSERT INTO kyq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Debm kꞋdaŋin̰ Taara se, naan̰ se ɓo gɔtn wɔɔr mala mala, kɛn naan̰ jaay ɓaaɗo do naaŋ ki se, wɔɔr gɔtɔ jeege tu paac. ");
INSERT INTO kyq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Num debm kꞋdaŋin̰ Taara se, naan̰ ɓaaɗoga do naaŋ ki ɔɔ Raa aalo do naaŋa se utu ro naan̰a, naɓo jee do naaŋ ki se, ɔŋ jeelin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naan̰ ɓaaɗo gɔtn taasin̰ge tu, naɓo taasin̰ge mala kic ɓo baate dɔɔɗn kɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Num gaŋ jee mɛtin̰gen took uunga taarin̰a ɔɔ aalga maakɗe don̰ ki se, naan̰ ɔɔɗɗenga ɗoobo taa naaɗe tɛɗn gaan Raage. ");
INSERT INTO kyq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kɛn naaɗe jaay tɛɗ gaan Raage se, naaɗe se jikilimge ɓo toojɗe eyo ɔɔ kɛse ute maakje jikilimge eyo, num Raa mala ɓo tɛɗɗen naaɗe se tɛɗga gɛnin̰ge. ");
INSERT INTO kyq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Debm kɛn kꞋdaŋin̰ Taara se, tɛɗga debkilimi ɔɔ naan̰ ɓaaɗo iŋg daanjege tu ɔɔ naaje se jꞋaakga *nookin̰a; ɔɔ nookŋ naan̰ se Bubin̰ Raa ɓo ɛɗin̰o, naan̰ ɓo Goonin̰ kalaŋ lak se. Ɔɔ naan̰ se, debm bɛɛ aak eyo ɔɔ taaɗ taar mɛt ki ɔɔ kɛn taaɗ jeege tu jaay ɔlɗen naaɗe jeel Raa mala mala se kic ɓo, naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kɛn Jan jaay aakin̰ se naan̰ taaɗ saaɗn naan̰ se jeege tu ɔɔ: «Aakki! Kɛse ɓo gaabm maam taaɗseno taarin̰a mꞋɔɔ: ‹Debm utu ɓaaɗo mɛtum ki se, naan̰ magal cirum maama ɔɔ naan̰ se do dɔkin̰ kɛn jꞋoojum te ey kic ɓo, naan̰ utu tap.›» ");
INSERT INTO kyq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Taa naan̰ se ɓo aan gɔɔ naan̰ maakin̰ jiga do jeege tu se, tɛɗjekiga bɛɛ dɛn aak eyo. Ɔɔ bɛɛn̰ se ɓɔrse kic ɓo, utu tɛɗjeki tɛɗ rɔk. ");
INSERT INTO kyq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Do dɔkin̰ se Raa ɔlo *Musa ɓo ɓaaɗo taaɗ *Ko Taarin̰ jeege tu. Num kɛn ɓaaɗo taaɗ bɛɛ Raa ute taar mɛt ki se, Isa *al‑Masi. ");
INSERT INTO kyq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nam nam ɓii kalaŋ aak te Raa eyo. Num Goonin̰ kalaŋ lakŋ tiŋg te Bubin̰ tɛlɛ se ɓo, taaɗ jeege tu ɔlɗen naaɗe jeel Raa se. ");
INSERT INTO kyq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gɔtn se magal Yaudgen maakŋ gɛgɛr kɛn Jeruzalɛm ki ɔlo *jee tɛɗn sɛrkɛ Raage tu ute Lɛbige ɓaaɗo tɔnd mɛtn Jan ɔɔ: «Naai tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɔɔ Jan se ɔyɗen te taar ɗim eyo, ɗeekɗensin̰ naanɗe ki tal ɔɔ: «Maam se, *mꞋal‑Masi eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tɛr naaɗe tɔnd mɛtin̰ daala ɔɔ: «Bin se naai tap ɓo naŋa? Lɔ naai ɓo *Ɛli do dɔkin̰ se la?» Naan̰ tɛrlɗen ɔɔ: «Maam se mꞋnaan̰ eyo.» Tɛr naaɗe tɔnd mɛtin̰ kuuy daala ɔɔ: «Lɔ naai ɓo debm taaɗ taar teeco taar Raa ki kɛn taaɗo do dɔkin̰ se la?» Naan̰ tɛrlɗen ɔɔ: «Gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gɔtn se naaɗe ɗeekin̰ ɔɔ: «ꞋTaaɗjen tu naai tap ɓo naŋa? Taa naaje se, jꞋɔljeno kɔl naaba gɔti ki taa naaje kꞋɓaa taaɗn jeege tun ɔljeno se. Naai mala tap ɓo taaɗjen tu, naai tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jan‑Batist tɛrlɗen ute taar debm taaɗ taar teeco taar Raa ki kꞋdaŋin̰ Ezayi kɛn taaɗo do dɔkin̰ ɔɔ: Maam ɓo mind debm kɛn taaɗ do kɔɗ‑ɓaar ki mꞋɔɔ: Ɗoobm Mɛljege se Ꞌtɛɗin̰sin̰ki jiga tooɗn tal. ");
INSERT INTO kyq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gaŋ jeegen magal Yaudge ɔlɗeno gɔtn Jan‑Batist ki se jee mɛtin̰ge se, *Parizige. ");
INSERT INTO kyq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Gɔtn se naaɗe tɔnd mɛtin̰ ɔn̰ eyo ɔɔ: «Kɛn naai ɓo al‑Masi eyo, ɔɔ *Ɛli eyo, ɔɔ tɛr debm taaɗ taar teeco taar Raa ki kɛn utu aɗe ɓaa se eyo, num naŋa taa ɗi jaay ɔɔ *batiz jeege se?» ");
INSERT INTO kyq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Gaŋ Jan‑Batist tɛrlɗen ɔɔ: «Maam se mꞋbatiz jeege ute maane sum. Anum debm kalaŋ utu maakse ki se, naase Ꞌjeelin̰ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naan̰ ɓo debm kɛn utu ɓaaɗo mɛtum ki ɔɔ maam se, kɔl saan̰ kic ɓo mꞋaas gɛn no tuutin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nakgen se paac deel maakŋ naaŋ Betani ki do ool Jordan kɛn kaam naane, gɔtn se ɓo gɔtn kɛn Jan‑Batist lee batizn jeege. ");
INSERT INTO kyq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɛtbeen̰ki se, Jan‑Batist jaay aak Isa utu ɓaaɗo gɔtin̰ ki se, naan̰ ɗeek ɔɔ: «Aakki! Kɛse ɓo Goon Baatn Raa kɛn utu kɔɔɗn *kusin̰ jeegen do naaŋ ki se. ");
INSERT INTO kyq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taa naan̰ se ɓo maam mꞋtaaɗo mꞋɔɔ: debm utu ɓaaɗo mɛtum ki se, naan̰ magal cirum maama. Kɛn do dɔkin̰ jꞋoojum te ey ɓɔrt se, naan̰ utu tap. ");
INSERT INTO kyq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maam mala kic ɓo mꞋjeelin̰ eyo kɛn kɛse ɓo naan̰a se, anum mꞋɓaaɗo *mꞋbatiz jeege te maane se, taa mꞋan̰ taaɗin̰ gaan *Israɛlge tu an̰ jeele.» ");
INSERT INTO kyq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tɛr Jan‑Batist taaɗ saaɗn gɛn Isa ɗeek ɔɔ: «Maam mꞋaako *Nirl Raa bɔɔyɔ maakŋ raa ki aan gɔɔ dɛɛrɛ ɓaaɗo iŋg don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ey num maam se, mꞋjeelin̰ eyo naɓo debm ɔlumo ɔɔ mꞋbatiz jeege ute maane se, naan̰ ɓo debm taaɗumo ɔɔ: debm naai utu Ꞌkaakŋ Nirl Raa Ꞌbɔɔy ɓaaɗo kiŋg don̰ ki se, naan̰ se ɓo debm kɛn utu *batizn jeege ute Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nakŋ se maam mala mꞋaako te kaamuma ɔɔ maam se mꞋsaaɗa, naan̰ se Goon Raa ɗeere.» ");
INSERT INTO kyq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɛtbeen̰ki se, Jan‑Batist ɓaaɗo iŋg te jee mɛtin̰ kɛn di se gɔtn ese daala. ");
INSERT INTO kyq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kɛn jaay Isa deel deel se, Jan‑Batist ɔndin̰ kaama tak ɔɔ ɗeek ɔɔ: «Aakki! Kɛse ɓo *Goon Baatn Raa.» ");
INSERT INTO kyq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kɛn jee mɛtn Jan‑Batist kɛn di jaay booy naan̰ taaɗɗen se, naaɗe iin̰ ɔk mɛtn Isa. ");
INSERT INTO kyq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isa jaay tɛrl aakɗe naaɗe utu ɓaaɗo mɛtin̰ ki se, naan̰ ɗeekɗen ɔɔ: «Naase Ꞌjeki ɗio?» Naaɗe tɛrlin̰ ɔɔ: «Raabi, naai iŋg gay?» (Raabi se, je ɗeekŋ ɔɔ: Debm dooy jeege.) ");
INSERT INTO kyq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Gɔtn se Isa tɛrlɗen ɔɔ: «ꞋƁaakiro aki ɓaa kaaka.» Ɔɔ naaɗe tumo te naan̰ tɛlɛ ɔɔ ɓaaɗo aak gɔtn kɛn naan̰ iŋg. Ɔɔ naaɗe ɔɔp iŋg te naan̰a. Kaaɗ kɛn naaɗe aan gɔt kɛn ese se tɛgɛr. ");
INSERT INTO kyq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gaŋ maakŋ jeege tun di kɛn booyo taar Jan‑Batist, jaay ɔko mɛtn Isa se, deb kalaŋ se ron̰ Andre; naan̰ ɓo gɛnaa Simon Piɛr. ");
INSERT INTO kyq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kɛn Andre jaay iin̰ ɔn̰ Isa se, naan̰ ɓaa ɔŋ gɛnaan̰ Simon Piɛr ɓo deete. Gɔtn se naan̰ ɗeekin̰ ɔɔ: «Naaje se, jꞋɔŋoga *al‑Masi. (Al‑Masi ute taar Grɛk se je ɗeekŋ ɔɔ: *Krist).» ");
INSERT INTO kyq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andre se ɔk ɓaan te gɛnaan̰ gɔtn Isa ki. Kɛn naaɗe jaay aan se, Isa ɔnd kaama ro Simon ki ɔɔ ɗeekin̰ ɔɔ: «Naai se Simon goon Jan, num naan ki se jaay daŋi Sepas.» (Ro Sepas se, ute taar *Ɛbre se je ɗeekŋ ɔɔ: dɛlbɛ.) ");
INSERT INTO kyq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mɛtbeen̰ki se Isa uun doa gɛn ɓaa taa naaŋ Galile ki. Gɔtn se, naan̰ ɔŋ Pilip ɔɔ ɗeekin̰ ɔɔ: «Naai se ɔk mɛtuma.» ");
INSERT INTO kyq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip se, naan̰ goon jee Betsaida ɔɔ Betsaida se ɓo, maakŋ naaŋ Piɛr ute gɛn gɛnaan̰ Andre kici. ");
INSERT INTO kyq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tɛr Pilip se ɓaa ɔŋ Natanaɛl ɗeekin̰ ɔɔ: «Naaje jꞋɔŋoga debm kɛn Raa ɔl *Musa raaŋin̰o maakŋ *Ko Taar Raa ki ute kɛngen jee taaɗ taar teeco taar Raa ki raaŋo taarin̰ se kici. Naan̰ ɓo, Isan kɔɗ Nazarɛt kɛn goon Yusup se.» ");
INSERT INTO kyq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Gɔtn se Natanaɛl tɛrlin̰ ɔɔ: «Maakŋ naaŋ kɛn Nazarɛt ki se ɓo, aɗe kɔŋ teecn̰ nakŋ bɛɛ kic ɗey la?» Gaŋ Pilip ɗeekin̰ ɔɔ: «ꞋƁaaɗo aaka.» ");
INSERT INTO kyq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kɛn Isa jaay aak Natanaɛl utu ɓaaɗo gɔtin̰ ki se, naan̰ taaɗ jeege tu ɔɔ: «Aakki! Kɛse ɓo kɔɗ *Israɛl mala. Naan̰ taaɗ taar mɛt ki *salal.» ");
INSERT INTO kyq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Gɔtn se Natanaɛl tɛrlin̰ ɔɔ: «A‑a naka, naai Ꞌjeel ɔŋum gay?» Gaŋ Isa tɛrlin̰ ɔɔ: «Kɛn Pilip jaay utu ɓaai ɓaa daŋa se, maam mꞋaaki naai iŋg kiŋg mɛtn ko ba ki se.» ");
INSERT INTO kyq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaɛl tɛrlin̰ ɔɔ: «Debm dooy jeege, naai se Goon Raa; naai ɓo Gaar Israɛlge.» ");
INSERT INTO kyq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Gaŋ Isa tɛrlin̰ ɔɔ: «Taa maam taaɗiga taaɗ mꞋɔɔ mꞋaakiga kaak mɛtn ko ba ki se ɓo, naai aal maaki dom ki la? Naan ki se, naai utu kaakŋ nakgen magal cir naan̰ se daala.» ");
INSERT INTO kyq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tɛr Isa taaɗin̰ ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: utu aki kaakŋ maakŋ raa utu kɔɔɗ waŋ ɔɔ ute ɗoobm *Goon Deba se *kɔɗn Raage utu ano bɔɔyo ɔɔ an kooko.» ");
INSERT INTO kyq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kɛn ɓii di jaay deele ɔɔ aan ɓii k‑mɔtɔge tu se, jeege ɓaa kɔkŋ mɛnda maakŋ naaŋ kɛn Kana kɛn taa naaŋ Galile ki. Ɔɔ ɓiin se ko Isa kic ɓo utu gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Gɔtn se Isa kic ute jee mɛtin̰ ki, kꞋdaŋɗeno ɓaaɗoga gɔtn kɔkŋ mɛnd kɛn se kici. ");
INSERT INTO kyq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Gaŋ tɔtn koojn̰ bin̰ kɛn jꞋɛɗ jeege tun ɓaaɗo se ɓaa naŋa. Gɔtn se ko Isa ɓaa taaɗ goonin̰ Isa ki ɔɔ: «Ɓɛrɛ, tɔtɗe se naŋga.» ");
INSERT INTO kyq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Num gaŋ Isa tɛrl kon̰ ki ɔɔ: «Kaaya, naabm maam mꞋtɛɗ se, naai ɓo am taaɗ eyo, ɔɔ kaaɗn maam mꞋan tɛɗn naabm se lɛ, utu aan te ey ɓɔrtɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Gɔtn se ko Isa taaɗ jee tɛɗn naabge tu ɔɔ: «Nakŋ naan̰ utu asen taaɗ paac se, Ꞌtɛɗin̰sin̰ki.» ");
INSERT INTO kyq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Anum gɔtɗe ki se, ɔk dugulgen gɛn koa mɛcɛ kɛn Yaudge tɔmb maane gɛn lee tugŋ roɗe taa tɛɗn aak bɛɛ naan *Raa ki ɔɔ dugulɗege se ɔs kɔɔyɔ sɔɔ ey lɛ ɔs kɔɔyɔ mii. ");
INSERT INTO kyq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isa taaɗ jee tɛɗn naabge tu ɔɔ: «Dugulge se ɓaa ɗoocɗeki ute maane.» Ɔɔ jee tɛɗn naabge se, ɓaa tak ɗooc maane dugulge tun se cɛlɛl cɛlɛl. ");
INSERT INTO kyq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kɛn naaɗe ɗooc dugulge aas se, Isa taaɗ jee tɛɗn naabge tu ɔɔ: «Ɓɔrse se, Ꞌtak Ꞌɓaa ɛɗki debm kɛn jꞋɔndin̰ naan gɛn kɔsɔ se.» Ɔɔ naaɗe tak ɓaa ɛɗin̰. ");
INSERT INTO kyq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kɛn naan̰ jaay uum naam maane se, naamin̰ dɛlga tɔtn koojn̰ bin̰. Num tɔtn se naan̰ jeel gɔtn kꞋɓaansin̰ eyo. Anum jee tɛɗn naabgen tako maane se, naaɗe kalɗe ki sum ɓo jeel gɔtin̰a. Gɔtn se debm kɛn jꞋɔndin̰ naan gɛn kɔsɔ se, naar daŋo gaabm mɛnda se, ");
INSERT INTO kyq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɔɔ naan̰ ɗeekin̰ ɔɔ: «Jeege paac kɛn jaay ɓaaɗoga gɔtn kɔkŋ mɛnd ki num, jꞋɛɗɗen tɔtn koojn̰ bin̰ atak ɓo deete. Ɔɔ kɛn naaɗe aay dɛrɛŋga te maraadɗe jaay ɓo, jꞋɛɗɗen tɔtn kɛn atak baat se, kaam mɔɔtn. Gaŋ naai num ɛɗ tɔtn atak baat se ɓo deete ɔɔ ɔn̰ kɛn atak tap ɓo kaam mɔɔtn.» ");
INSERT INTO kyq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kana kɛn taa naaŋ Galile ki se ɓo, gɔtn kɛn Isa baag tɛɗn nakŋ‑kɔɔɓin̰gen deet deetn kɛn jꞋansin̰ kaakŋ jeele. Nakŋ‑kɔɔɓgen naan̰ tɛɗ se, naan̰ taaɗ *nookin̰ jeege tu ɔɔ jee mɛtin̰ ki se took aal maakɗe don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kɛn nakgen se jaay deel se, Isa iin̰ te kon̰a, jee mɛtin̰ ki ɔɔ te gɛnaan̰ge bɔɔy ɓaa maakŋ gɛgɛr kɛn Kaparnayum ki. Naɓo, Kaparnayum ki se, naaɗe tiŋgo ɓii kandum sum. ");
INSERT INTO kyq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kɛn Isa jaay aak *laa Paakŋ gɛn Yaudge ɔɔpga gɔɔr se, naan̰ iin̰ ook ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kɛn naan̰ aan Jeruzalɛm ki, jaay ɛnd daan bɔɔr Ɓee Raa ki se, ɔŋ jee tɛɗn zo maraŋge, gɛn baatge, ute gɛn dɛɛrge ɔɔ gɔtn se, naan̰ ɔŋ jee lee pɛlɛkŋ gursgen gɛn taa naaŋgen kuuy utu iŋg kiŋg gɔtn ese kici. ");
INSERT INTO kyq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kɛn Isa jaay aakɗe se naan̰ tɔs kɔlɔ ɔɔ tɛɗin̰ ria. Gɔtn se naan̰ tuurɗe paac daan bɔɔr Ɓee Raa ki se, baatɗege ute maraŋɗege. Naan̰ tɔt tɔɔl tund te tabil jee pɛlɛkŋ gursgen ese, ɔɔ gursɗege se kic ɓo si wɔɔk kalaŋ kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɔɔ naan̰ taaɗ jee tɛɗn zo dɛɛrge tu ɔɔ: «Naksege se ɔɔɗ teecɗeki naatn gɔtn ara! Ɔn̰te Ꞌtɛɗki ɓee Bubum se Ꞌtɛɗn gɔtn tɛɗn suuk!» ");
INSERT INTO kyq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jee mɛtin̰ ki jaay saap do nakŋ naan̰ tɛɗ se, naaɗe saap ɔŋ taar kɛn kꞋraaŋin̰o do dɔkin̰ kɛn ɔɔ: Raama, maam se mꞋje ɓei. Maakje kɛn maam mꞋɔk do ɓee naai ki se dɛn aak eyo ɔɔ tulum maakum ki aan gɔɔ pooɗo. ");
INSERT INTO kyq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gaŋ magal Yaudge taaɗin̰ ɔɔ: «Nakŋ kɔɔɓm gay kɛn naai ajen Ꞌtɛɗ jaay naaje jꞋan kaakŋ jeel ro ki ɔɔ ajen taaɗn ɔɔ naai se ɔk ɗoobo gɛn tɛɗn nakgen se?» ");
INSERT INTO kyq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isa tɛrlɗen ɔɔ: «Ɓee Raa ɗaar se, Ꞌtɔɔkin̰ki naatn, daan ɓiige tun mɔtɔ sum ɓo maam mꞋan̰ kiin̰in̰ gɔtin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Gɔtn ese magal Yaudge tɛrlin̰ ɔɔ: «Ɓee Raa se, naaje jꞋɔk ɓaara si‑sɔɔ‑kaar‑mɛcɛ jaay jꞋiin̰ jꞋaasin̰a. Gaŋ naai num ɔɔ daan ɓiige tun mɔtɔ ki sum ɓo an̰ Ꞌkiin̰ kaasn gɔtin̰ ki bin ne?» ");
INSERT INTO kyq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kɛn Isa jaay taaɗɗen taa ɓee bin se, naan̰ aalɗen kaal naagŋ taara. Ey num naan̰ taaɗ te ron̰ mala. ");
INSERT INTO kyq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Taa naan̰ se ɓo kɛn Isa jaay ooy duro daan yoge tu se, jee mɛtin̰ ki ɓaa saap ɔŋ taar kɛn naan̰ taaɗɗeno se ɔɔ tɛr naaɗe took do taar kɛn kꞋraaŋin̰o do dɔkin̰a ɔɔ ute taargen Isa taaɗɗeno. ");
INSERT INTO kyq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kaaɗ kɛn Isa utu Jeruzalɛm ki maakŋ *laa Paak gɛn Yaudge se, naan̰ tɛɗoga nakŋ‑kɔɔɓge dɛna kɛn taaɗ jeege tu an kaakŋ jeel ro ki ɔɔ kɛn jeege jaay aak nakŋ‑kɔɔɓgen naan̰ tɛɗ se, maakɗe ki se, jeege dɛna aal maakɗe don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gaŋ Isa aalɗe maak ki eyo, taa naan̰ se jeel naŋ maakɗe paac. ");
INSERT INTO kyq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nakŋ maakŋ debkilim ki se naan̰ je nam ɓo an̰ tɛɗn saaɗin̰ eyo, taa naan̰ mala se jeel naŋ nakŋ kɛn maakŋ debkilim ki. ");
INSERT INTO kyq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Maakŋ jeege tun kꞋdaŋɗe *Parizige se, gaaba kalaŋ kꞋdaŋin̰ Nikodem ɔɔ naan̰ se debm maakŋ magal Yaudge tu kici. ");
INSERT INTO kyq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɓii kalaŋ naan̰ ɓaaɗo ɔŋ Isa nɔɔr tɔnd mɛtin̰ ɔɔ: «Debm dooy jeege, naaje se kꞋjeeli naai se debm dooy jeege *Raa ɓo ɔlio, taa nakŋ‑kɔɔɓgen naai Ꞌtɛɗin̰ se, debm kɛn Raa te naan̰ ey num an̰ kɔŋ tɛɗin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Gaŋ Isa tɛrlin̰ ɔɔ: «ꞋBooy bɛɛ mꞋai taaɗa: debkilim jaay jꞋooj kꞋɗɔɔlin̰ te kuuy ey se, naan̰ kɔŋ kaakŋ *maakŋ Gaar Raa eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Gɔtn se Nikodem tɛrlin̰ ɔɔ: «Debkilimi gɔɔlga gɔɔl kic ɓo jꞋan̰ kɔŋ koojn̰ ɗɔɔl la? Naan̰ Ꞌkɔŋ kɛnd maakŋ kon̰ ki daal jaay jꞋan̰ koojn̰ ɗɔɔl ne?» ");
INSERT INTO kyq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isa tɛrlin̰ ɔɔ: «ꞋBooy bɛɛ mꞋai taaɗa: debm jaay jꞋoojin̰ te ute maane eyo ɔɔ te *Nirl Raa ey se, naan̰ Ꞌkɔŋ kɛnd maakŋ Gaar Raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Debm kɛn debkilimi ɓo oojin̰ se, naan̰ goon debkilimi, num gaŋ debm kɛn Nirl Raa ɓo oojin̰ se, naan̰ se gɛn Nirl Raa. ");
INSERT INTO kyq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taar kɛn maam mꞋtaaɗi mꞋɔɔ: bɛɛki num jꞋasen koojn̰ ɗɔɔl kuuy se, ɔn̰te deel doi. ");
INSERT INTO kyq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kɛn kuulu jaay baagga kɔlɔ se, naan̰ ɔl ɓaa gɔtn naan̰ jen ro ki; naai se Ꞌbooy booy ɓo gɔtin̰ sum, ey num gɔtn naan̰ iin̰no ɔɔ gɔtn naan̰ ɔl ɓaa se, naai Ꞌjeel eyo. Bin ɓo debm kɛn jꞋoojin̰ te Nirl Raa se, tec aan gɔɔ naan̰ se kici.» ");
INSERT INTO kyq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Gɔtn se Nikodem ɗeekin̰ ɔɔ: «Nakŋ se Ꞌtɛɗn ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isa tɛrlin̰ ɔɔ: «Naai debm dooy *Israɛlge kic ɓo, taar se naai Ꞌjeel ɔk mɛtin̰ ey la! ");
INSERT INTO kyq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ꞋBooy bɛɛ maam mꞋai taaɗa: naaje se kꞋtaaɗ nakgen naaje kꞋjeel jꞋɔk mɛtin̰a, ɔɔ kꞋtaaɗsen nakŋ naaje jꞋaako te kaamje, gaŋ naase se ɔŋ Ꞌtookki te do saaɗn naaje ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kɛn maam mꞋtaaɗsen te nakgen do naaŋ ki se kic ɓo, naase Ꞌtookki eyo. Ɔɔ kɛn mꞋbaagsega taaɗn te nakgen maakŋ raa ki se, naase aakki kuun taarum ɔɔki ɗio? ");
INSERT INTO kyq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Taa ɓii kalaŋ nam ook aan te maakŋ raa ki eyo; kɛn bɔɔyo maakŋ raa ki se, *Goon Deba kalin̰ ki sum. ");
INSERT INTO kyq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aan gɔɔ *Musa do kɔɗ‑ɓaar ki se, ɗaap wɔɔjn̰ maala ɔɔ uun ɗaarin̰ raan do kaag ki, maam Goon Deba kic ɓo jꞋutu jꞋam kuun kɔlum raan bini. ");
INSERT INTO kyq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Bin ɓo debm kɛn aalga maakin̰ do maam ki se, naan̰ Ꞌkɔŋ *kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Taa Raa se, naan̰ je jeege dɛn aak eyo, naan̰ ɔlo Goon naan̰ kalaŋ lak, taa debm jaay aal maakin̰ do naan̰ ki se, naan̰ Ꞌkɔŋ kut eyo, gaŋ naan̰ se kɔŋ kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Raa jaay ɔlo Goonin̰ do naaŋ ki se, gɛn kɔjn̰ bɔɔrɔ do jeege tu eyo. Num gaŋ naan̰ ɔlin̰o do naaŋ ki se gɛn kaajn̰ jeege. ");
INSERT INTO kyq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Debm jaay aalga maakin̰ do naan̰ ki se, bɔɔrɔ koocn̰ don̰ ki eyo. Num gaŋ debm baate kaal maakin̰ do naan̰ ki se, naan̰ se bɔɔrɔ oocga don̰ ki. Taa naan̰ baatega kaal maakin̰ do Goon Raa kalaŋ lak se. ");
INSERT INTO kyq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kɛse ɓo bɔɔr kɛn Raa utu kɔjn̰ do jeege tu. Taa debm kɛn kꞋdaŋin̰ gɔtn wɔɔr se ɓaaɗo do naaŋ ki, naɓo jikilimge se je gɔtn ɔɔɗ se ɓo cir gɔtn wɔɔrɔ taa nakgen naaɗe tɛɗ se, nakgen *kusin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Taa debm tɛɗn nakŋ kusin̰ se, naan̰ je gɔtn wɔɔr eyo ɔɔ je aɗe ɓaa gɔt kɛn wɔɔr eyo taa naan̰ ɓeere sɔm nakgen naan̰ tɛɗ se mɛtin̰ teece. ");
INSERT INTO kyq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gaŋ debm kɛn lee te kɛn mɛt ki se, naan̰ ɓaa gɔt kɛn wɔɔrɔ taa jꞋkaakŋ naabm naan̰ tɛɗ se Ꞌtooɗ tal ɔɔ naabin̰ naan̰ tɛɗin̰ se aan gɔɔ kɛn Raa jen ro ki.» ");
INSERT INTO kyq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kɛn nakgen se jaay paac deel se, Isa iin̰ ɓaa te jee mɛtin̰ ki taa naaŋ Jude ki. Naaɗe ɓaa tiŋg gɔtn ese ɔɔ Isa lee *batiz jeege. ");
INSERT INTO kyq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kaaɗ kɛn se Jan‑Batist kici utu iŋg Aynon ki kɛn cɛɛ Salim ki, naan̰ kic lee batiz jeege, taa gɔtn se ɔk maane dɛna. Gɔtn se jeege ɓaaɗo gɔtin̰ ki ɔɔ naan̰ batizɗe. ");
INSERT INTO kyq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Taa kaaɗ kɛn se, Jan‑Batist jꞋɔkin̰ te daŋgay ki ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gaŋ ɓii kalaŋ maakŋ jee mɛtn Jan‑Batist ki se, baag naajn̰ te kɔɗ Yaud kalaŋ bini taa tug ro kɛn debkilimi tɛɗn aak bɛɛ naan Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jee mɛtn Jan‑Batist ki se, ɓaa ɔŋ Jan ɗeekin̰ ɔɔ: «Debm dooy jeege, debm kɛn iŋgo te naai do jɛŋ ool Jordan kɛn kaam naane se, ɔɔ kɛn naai Ꞌtaaɗo saaɗin̰ jeege tu se, ɓɔrse naan̰ kic baagga batizn jeege ɔɔ jeege se paac ru ɓaa ɓaa gɔtn naan̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan‑Batist tɛrlɗen ɔɔ: «Debkilimi se, kɛn Raa jaay undin̰ te kul ɗim ey se, naan̰ kalin̰ ki kɔŋ tɛɗn ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Naase mala saaɗumge kɛn maam taaɗseno mꞋɔɔ: maam se, *mꞋal‑Masi eyo, num gaŋ maam Raa ɔlumo kɔl ɓo naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Naase kic Ꞌjeelki, debm ɔk mɛnda se, naan̰ ɓo gaabm mɛnd se ɔɔ mɛɗn gaabm mɛnd iŋg cɛɛn̰ ki se booy taarin̰a ɔɔ taarin̰ se ɛɗin̰ maak‑raap dɛn aak eyo. Maam kic maakum‑raapo ɔɔ maak‑raapm se dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bɛɛki se, ɔn̰ naan̰ magal ɓaa ute naanin̰a ɔɔ maam mꞋkɔɔpm baata mꞋbɔɔy mꞋɓaa ute naanuma.» ");
INSERT INTO kyq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jan taaɗ daala ɔɔ: «Debm kɛn bɔɔyo maakŋ raa ki se, naan̰ magal do nakge tun ɓaa se paac. Gaŋ debm kɛn jꞋoojin̰ do naaŋ ki se, naan̰ se debm do naaŋ ki ɔɔ naan̰ taaɗ kic ɓo te nakgen do naaŋ ki ese sum. Num debm kɛn bɔɔyo raan se, naan̰ magal do nakge tun ɓaa se paac. ");
INSERT INTO kyq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Naan̰ se saaɗa do nakŋ kɛn naan̰ aako te kaamin̰a ɔɔ kɛn naan̰ booyo te bin̰a, naɓo nam jaay tookŋ do saaɗn naan̰ ki se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gaŋ debm took do saaɗn naan̰ ki se, naan̰ jeel maakin̰ ki, Raa se taaɗ taar mɛt ki *salal. ");
INSERT INTO kyq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taa debm kɛn Raa ɔlin̰o se, naan̰ taaɗ taar Raa, taa Raa ɛɗin̰ Nirlin̰a ɔɔ ɛɗin̰sin̰ te maraadin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Raa Bubu se je Goonin̰a ɔɔ naan̰ ɔn̰in̰ nakge paac kaam jin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Debm jaay aalga maakin̰ do Goon ki se lɛ, naan̰ kɔŋ *kaajn̰ gɛn daayum. Ɔɔ debm jaay baate kaal maakin̰a do Goon kɛn se lɛ, naan̰ kɔŋ kaaj eyo, num gaŋ daayum Raa se maak‑taarin̰ iŋg don̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kɛn Isa jaay booy ɔɔ *Parizige booyga ɔɔ naan̰ jee mɛtin̰ ki tɛɗga dɛna ɔɔ naan̰ lee *batiz jeege dɛn cir gɛn Jan se, ");
INSERT INTO kyq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","kɛn tap se, Isa mala ɓo lee batiz jeege eyo, num jee mɛtin̰ ki ɓo lee batiz jeege. ");
INSERT INTO kyq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Gɔtn se Isa iin̰ ɔn̰ taa naaŋ Jude se ɔɔ ɔk tɛrl ɓaa taa naaŋ Galile ki daala. ");
INSERT INTO kyq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gɛn ɓaa Galile ki se, bɛɛki se, naan̰ utu Ꞌkaal taa naaŋ Samari ki jaayo. ");
INSERT INTO kyq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kɛn naan̰ jaay aal kaal taa naaŋ Samari ki se, naan̰ aan maakŋ naaŋ kɛn kꞋdaŋin̰ Siikar. Ɔɔ Siikar se, naan̰ cɛɛ maakŋ gɔt kɛn *Yakub ɛɗo do dɔkin̰ goonin̰ Yusup ki. ");
INSERT INTO kyq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Gɔtn ese ɔk buɗu ɔɔ buɗn se kꞋdaŋin̰ buɗn Yakub. Kɛn Isa jaay aan gɔtn ese se, kaaɗa aasga katara tir ɔɔ naan̰ jaay lee ɔɔr se ɓaa iŋg cɛɛ buɗ kɛn ese. ");
INSERT INTO kyq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Gɔtn se mɛnd Samari kalaŋ bini ɓaaɗo gɛn takŋ maane. Isa ɗeekin̰ ɔɔ: «Ɛɗumo tu maane mꞋkaaye.» ");
INSERT INTO kyq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kaaɗ kɛn se jee mɛtin̰ ki ɓaaga maakŋ gɛgɛr ki taa aɗeno ɓaa dugŋ nakŋ kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Gaŋ mɛnd kɛn mɛnd Samari se ɗeek Isa ki ɔɔ: «Naai lɛ kɔɗ Yaud, num Ꞌtɔnd mɛtn maan kaaye gɔtn maam mɛnd Samari ki se, gɛn ɗio?» (Taa Yaudge ute Samarige se lɛ, taarɗe ɓaa eyo.) ");
INSERT INTO kyq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Gɔtn se, Isa tɛrlin̰ ɔɔ: «Kɛn naai jaay Ꞌjeel nakŋ kɛn *Raa utu kɛɗn jeege tu se num, debm kɛn ɗeeki ɔɔ ɛɗumo maane mꞋkaay se, ey num naai ɓo Ꞌtɔnd mɛtn maan kaaye gɔtin̰ ki. Ɔɔ naan̰ se ai kɛɗn maan daayum tooɗ ɔɔy kɔl kɔl ɔɔ ɛɗ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Gaŋ mɛnda se ɗeekin̰ ɔɔ: «Naka, buɗu se lɛ jɛrlɛ ɔɔ naai lɛ ɔk dɛlɛ eyo. Num maan daayum tooɗ ɔɔy kɔl kɔl ɔɔ ɛɗ kaaja se an̰ kɔŋ gay? ");
INSERT INTO kyq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɓugje Yakub kɛn uɗjeno buɗn se, naan̰ mala, gɛnin̰ge ɔɔ te maalin̰ge kic ɓo aayo buɗ kɛn ara. Num naai se, magal cir ɓugje Yakub la?» ");
INSERT INTO kyq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isa tɛrlin̰ ɔɔ: «Debm kɛn aay maan buɗ kɛn ese se, tɛɗga sum ɓo maane utu an̰ tɔɔl kuuy daala. ");
INSERT INTO kyq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Num debm kɛn jaay Ꞌkaay maan maam mꞋan̰ kɛɗ se, mɔɔtn kuuy maane an̰ tɔɔl eyo, taa maan maam mꞋan̰ kɛɗ se, daayum tooɗn kɔɔy kɔl kɔl maakin̰ ki ɔɔ an̰ kɛɗn *kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Gɔtn se mɛnda ɗeekin̰ ɔɔ: «Naka, ɛɗumo maan se taa mɔɔtn kuuy maane am tɔɔlum eyo, ɔɔ maam lɛ mɔɔtn mꞋaɗe ɓaa ara gɛn takŋ maan ey sum.» ");
INSERT INTO kyq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isa ɗeekin̰ ɔɔ: «ꞋƁaa daŋo gaabi ɔɔ tum Ꞌɓaakiro kalaŋ gɔtn ara.» ");
INSERT INTO kyq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Gaŋ mɛnda se tɛrlin̰ ɔɔ: «Maam se mꞋɔk gaab eyo.» Gɔtn se, Isa tɛrlin̰ ɔɔ: «Taar kɛn naai Ꞌtaaɗ ɔɔ maam se mꞋɔk gaab ey se, kɛse mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Taa naai se Ꞌtɔkoga gaabge mii, num gaabm kɛn naai iŋg ɓɔrse se gaabi eyo. Taa naan̰ se, taar naai Ꞌtaaɗ se taar mɛt ki.» ");
INSERT INTO kyq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Gɔtn se mɛnda ɗeekin̰ ɔɔ: «Naka, maam mꞋaaki naai se, debm taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ey num bubm naajege se, eem Raa do ko kɛn ese, num naase Yaudge lɛ ɔɔki gɔtn keem Raa se, maakŋ gɛgɛr Jeruzalɛm ki kalin̰ ki sum.» ");
INSERT INTO kyq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isa ɗeekin̰ ɔɔ: «Ko naka, Ꞌtook taar kɛn maam mꞋtaaɗi se: kaaɗin̰ utu kaana gɛn keem Raa Bubu se, naase an̰ki ɓaa kɔŋ keem do ko kɛn ara ki eyo ɔɔ Jeruzalɛm ki eyo kici. ");
INSERT INTO kyq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Naase jee Samari ki se lɛ, eemki Raa kɛn naase Ꞌjeel ɔkki mɛtin̰ eyo. Num gaŋ naaje Yaudge se naaje kꞋjꞋeem Raa kɛn naaje kꞋjeel jꞋɔk mɛtin̰a, taa debm utu kaajn̰ jeege se aɗe teecn̰ daan Yaudge tu. ");
INSERT INTO kyq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Num kaaɗin̰ se utu Ꞌkaana ɔɔ ɓɔrse kaaɗin̰ se aasga, *Nirl Raa se utu tɛɗn jeege se Ꞌjeel keem Raa mala mala. Jeegen eem Raa bin se ɓo kɛn Raa Bubu jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Raa se naan̰ ɓo Mɛl‑kaaja ɔɔ jee jaay an̰ keemin̰ naan̰ mala mala se, jee se kɛn Nirlin̰ tɛɗɗenga naaɗe aasga jee an̰ lee keeme. Naaɗe se ɓo kɛn naan̰ ɛɗɗenga kaaja.» ");
INSERT INTO kyq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Gɔtn se mɛnda taaɗin̰ ɔɔ: «Maam se mꞋjeel debm kꞋdaŋin̰ *al‑Masi, kɛn ute taar Grɛk kꞋdaŋin̰ *Krist se, utu aɗe ɓaao. Kɛn naan̰ jaay ɓaaɗoga se utu ajen taaɗn tɔɔkŋ mɛtn nakgen se paac kalaŋ kalaŋ.» ");
INSERT INTO kyq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isa tɛrlin̰ ɔɔ: «Debm kɛn taaɗi se ɓo, maama.» ");
INSERT INTO kyq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Gɔtn se jee mɛtin̰ ki ɓaaɗo ɔŋin̰a. Kɛn naaɗe jaay aak Isa taaɗ taaɗ te mɛnda se, paac ɔkɗen taaɗ eyo. Num gaŋ debm kɛn jaay an̰ taaɗn ɔɔ naai Ꞌje ɗi? Lɔ taaɗ te mɛnd se, gɛn ɗi se gɔtɔ? ");
INSERT INTO kyq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Gɔtn ese mɛnda iin̰ ɔn̰ kɔɔyin̰a ɔɔ ɔk tɛrl ɓaa maakŋ gɛgɛr ki ɔɔ ɓaa taaɗ jeege tu ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ꞋƁaaɗo aakki tu. Maam mꞋɔŋo gaabm naane se, taaɗ tɔɔɗumo mɛtuma do nakge tun maam tɛɗo se paac. Naan̰ se ɓo Ꞌtɛɗn al‑Masi lɛ ɗaam?» ");
INSERT INTO kyq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jeege se teeco maakŋ gɛgɛr ki ɔɔ ɓaaɗo ɔŋ Isa. ");
INSERT INTO kyq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kaaɗ kɛn mɛnda jaay tɛrl ɓaa ɓeen se, jee mɛtn Isa ki taaɗ dɔɔkin̰ taara ɔɔ: «Debm dooyje, ɓaaɗo ɔs jaayo.» ");
INSERT INTO kyq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gaŋ naan̰ tɛrlɗen ɔɔ: «Nakŋ kɔsn kɛn maam mꞋlee mꞋɔs se naase Ꞌjeelki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gɔtn se jee mɛtin̰ ki taaɗ te naapa ɔɔ: «Kaaɗn naane nam ɛɗin̰ga nakŋ kɔsɔ lɛ ɗaam?» ");
INSERT INTO kyq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tɛr Isa taaɗɗen daala ɔɔ: «Kɛse ɓo nakŋ kɔsuma: maam Raa ɔlumo se, taa mꞋan̰ Ꞌtɛɗn nakŋ kɛn maakin̰ jen ro ki, ɔɔ naabm kɛn naan̰ ɛɗumsin̰ se mꞋan̰ tɛɗ kaas te ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Naase lee Ꞌtaaɗki ɔɔki: ‹Kaaɗn kɔjɔ se, ɔɔpga laapa sɔɔ jaayo.› Num maam mꞋɗeeksen mꞋɔɔ: uunki kaam se, aakki maakŋ‑gɔtɔ se tɛɗga gɛn kɔjɔ. ");
INSERT INTO kyq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Debm kɔjn̰ maakŋ gɔtɔ se ɓɔrse ɓo baagga kɔŋ bɛɗin̰a, taa naan̰ tus tus nakgen naan̰ ɔj se gɛn tiŋg gɛn daayum. Taa naan̰ se debm kɔɔcɔ ute debm kɔjn̰ maakŋ gɔtɔ se, naaɗe paac maakɗe raap aas kaasa. ");
INSERT INTO kyq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kaan̰ kaa taar ese se, taaɗ taar mɛt ki, kɛn ɗeek ɔɔ: ‹Deb kalaŋ ɓaaɗo ɔɔcɔ, debm kuuy ɓo ɓaaɗo ɔjɔ.› ");
INSERT INTO kyq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Maam se mꞋɔlse gɛn kɔjn̰ maakŋ gɔtn kɛn naase Ꞌnaamki te dubar naabin̰ eyo; jee kuuy naab dabaro, num gaŋ naase se, Ꞌɓaaɗo ɔŋki ɓo ɔjki kɔj sum.» ");
INSERT INTO kyq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Maakŋ gɛgɛr kɛn ese se *Samarige dɛna kɛn took aal maakɗe do Isa ki, do taar mɛnd kɛn ɗeekɗeno ɔɔ: «Naan̰ taaɗ tɔɔɗumo mɛtuma do nakge tun maam mꞋtɛɗo se paac.» ");
INSERT INTO kyq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kɛn Samarige jaay ɓaaɗo ɔŋ Isa se, naaɗe tɔnd mɛtin̰ ɔɔ: «Iŋg te naaje.» Gɔtn se Isa ɔɔp iŋg te naaɗe ɓii dio. ");
INSERT INTO kyq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gɔtn se do taar kɛn Isa taaɗɗen se, jee took aal maakɗe don̰ ki se dɛn cir daala. ");
INSERT INTO kyq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Gɔtn se naaɗe taaɗ mɛnd ki ɔɔ: «Naaje jꞋaal maakje don̰ ki se, do taar naai ki sum eyo. Num naaje mala kꞋbooyga te bije ɔɔ kꞋjeelin̰ga ɗeere, naan̰ se ɓo Debm Kaajn̰ jeegen do naaŋ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gɔtn se Isa tɛɗ ɓii dio, jaay ɓo iin̰ ɔn̰ gɔtn ese ɔɔ ɔk tɛrl ɓaa taa naaŋ Galile ki daala. ");
INSERT INTO kyq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Taa naan̰ mala taaɗga taaɗ te taarin̰a ɔɔ debm taaɗ taar teeco taar Raa ki se, jee maakŋ naaŋin̰ ki mala se aalin̰ maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Num kɛn naan̰ jaay aan taa naaŋ Galile ki se, jee Galile ki dɔɔɗ ɔkin̰ jiga taa naaɗe kic iŋgo Jeruzalɛm ki gɛn *laa Paak ɔɔ naaɗe kic aakkiga nakgen paacn̰ kɛn Isa tɛɗo se. ");
INSERT INTO kyq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gɔtn se Isa tɛrlo maakŋ naaŋ Kana ki kɛn taa naaŋ Galile ki; gɔtn se ɓo kɛn naan̰ dɛl maane tɛɗ tɔtn koojn̰ bin̰ se. Gaŋ maakŋ Kaparnayum ki se magala kalaŋ bin se goonin̰ gaaba kɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kɛn gaabm se jaay booy jꞋɔɔ Isa iin̰o taa naaŋ Jude ki ɔɔ ɓaaɗoga taa naaŋ Galile ki se, gɔtn se naan̰ ɓaaɗo ɔŋin̰a ɔɔ tɔnd mɛtin̰ ɔɔ: «Jaamus, Ꞌbɔɔy Ꞌɓaaɗo ɛɗum lapia goonum kɛn ɔɔpga baata ɓaa ɓaa kooyo se.» ");
INSERT INTO kyq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isa ɗeekin̰ ɔɔ: «Kɛn naase se, jaay aakki te nakŋ‑kɔɔɓ eyo, te nakŋ kɛn deel do debkilimi ey se, naase maakse Ꞌtook eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Magal se ɗeekin̰ ɔɔ: «Jaamus, kɔr goonum ooy te ey ɓɔrt se Ꞌbɔɔy Ꞌɓaaɗo.» ");
INSERT INTO kyq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isa tɛrlin̰ ɔɔ: «Iin̰ Ꞌɓaa, gooni gaaba se aajga.» Gaabm se aal maakin̰ do taar kɛn Isa taaɗin̰ se ɔɔ naan̰ uun ɗoobin̰a ɔk tɛrl ɓaa. ");
INSERT INTO kyq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kɛn gaabm se jaay uun ɗoobo tɛrl bɔɔy ɓaa ɓaa se, jee tɛɗn naabin̰ge an̰ ɓaaɗo dɔɔɗin̰a ɔɔ ɗeekin̰ ɔɔ: «Gooni gaaba se aajga.» ");
INSERT INTO kyq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naan̰ tɔnd mɛtɗe ɔɔ: «Goono se ɔŋ lapia kaaɗ ɗi?» Naaɗe tɛrlin̰ ɔɔ: «Tɛrko katar do tɛgɛr ki sum ɓo ron̰ ɔŋ kɛɗɛk se tɔɔlin̰.» ");
INSERT INTO kyq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Gɔtn se bubm goono saap ɔŋ kaaɗn ese ɓo, kaaɗn kɛn Isa taaɗin̰ ɔɔ: «Gooni kɛn gaaba se aajga.» Gɔtn ese se sum ɓo, naan̰ ute jee maakŋ ɓeen̰ ki se paac took aal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kɛse ɓo nakŋ‑kɔɔɓm gɛn k‑dige, kɛn Isa tɛɗin̰ taa naaŋ Galile ki kaaɗ kɛn naan̰ iin̰o taa naaŋ Jude ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kɛn nakgen se jaay deel se, ɓii kalaŋ Yaudge tɛɗ tɛɗ laaɗe, ɔɔ Isa ook ɓaa Jeruzalɛm ki taa laaɗe se. ");
INSERT INTO kyq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jeruzalɛm ki se ɔk taa ɗoobo, ɔɔ taa ɗoobm se kꞋdaŋin̰ taa ɗoobm baatge, ɔɔ gɔɔr te gɔtn ese ɔk gɔɔ kɛn jꞋiin̰ kꞋɗaapin̰ gɛn kɔkŋ maane. Gɔɔ se, kꞋdaŋin̰ te taar *Ɛbre Betzata, ɔɔ gɔtn se ɔk daabgen gɛn lɛkɛ, gɔtɔ kaam mii, kɛn ɔl gurug gɔɔ ese. ");
INSERT INTO kyq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɔɔ mɛtn daabgen se, jee kɔɔn̰ge tooɗ ɗooc tak tak, jee kaam‑tɔɔkge jee cɛkɛɗge ute jee kɛn jiɗege ute jɛɗege ooyga kooyo. Naaɗe se iŋg booy kaaɗn maane utu tɛɗ dagalec dagalec. ");
INSERT INTO kyq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Taa tɛɗga num *kɔɗn Raa kalaŋ lee bɔɔy bɔɔy maakŋ maan kɛn se, ɔɔ kɛn maane jaay baagga tɛɗn dagalec dagalec se, debm kɔɔn̰ jaay bɔɔy deet deet maakŋ maan kɛn se, kɛn kɔɔn̰in̰ se kɔɔn̰ ɔɔ ɗi kic ɓo, ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Taa naan̰ se ɓo gaaba kalaŋ bin se kꞋruŋguyu, ɔɔ gɔtn naan̰ tɛɗ kꞋruŋguyu sum se ɔkga ɓaara sik‑mɔtɔ‑kaar‑marta. ");
INSERT INTO kyq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kɛn Isa jaay aak gaabm se tooɗ tooɗo, ɔɔ Isa se jeele, gaabm se gɔtn naan̰ tɛrɛc kꞋruŋguyu sum se, daanin̰ dɔkga. Naan̰ ɗeekin̰ ɔɔ: «Naai Ꞌje kɔŋ lapi la?» ");
INSERT INTO kyq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Gaŋ debm kꞋruŋguyu se tɛrlin̰ ɔɔ: «Naka, kɛn maane jaay baagga tɛɗn dagalec dagalec se, nam am kuun kɔlum maak ki se gɔtɔ. Kɔr jaay mꞋɔɔ mꞋkiin̰ ɓaa se lɛ, deb kuuy naar booy deet naanum ki.» ");
INSERT INTO kyq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Gɔtn se Isa ɗeekin̰ ɔɔ: «Iin̰i! ꞋTeel raagi ɔɔ Ꞌlee Ꞌɓaa.» ");
INSERT INTO kyq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Gɔtn se sum ɓo gaaba se naar ɔŋ lapia, naan̰ uun raagin̰a ɔɔ baag lea. Gaŋ ɓii se, *ɓii sebit. ");
INSERT INTO kyq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gɔtn se magal Yaudge ɗeek gaab kɛn ɔŋ lapi se ɔɔ: «Jaaki se ɓii sebit; naai ɔk ɗoobm gɛn kuun raagi eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Gaŋ gaabm se tɛrlɗen ɔɔ: «Gaabm kɛn ɛɗum lapi se ɓo ɗeekumo ɔɔ: Uun raagi se, iin̰ Ꞌlee Ꞌɓaa.» ");
INSERT INTO kyq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Debm kɛn taaɗi ɔɔ: Uun raagi ɔɔ Ꞌlee Ꞌɓaa se, naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Num gaŋ gaabm se debm jaay ɛɗin̰ lapi se naan̰ jeelin̰ eyo. Taa Isa se, ɛndga maakŋ jeege tun dɛn se, naan̰ jeel te gɔtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Num gaŋ cɔkɔ se, Isa ɓaa ɔŋin̰ maakŋ bɔɔr *Ɓee Raa ki ɔɔ ɗeekin̰ ɔɔ: «ꞋBooyo, ɓɔrse naai ɔŋga lapia. Mɔɔtn ɔn̰te tɛɗn *kusin̰ sum, ey num naan ki se naai utu Ꞌkɔŋ nakŋ ɔɔn̰ cir naan̰ se daala.» ");
INSERT INTO kyq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɔɔ gaabm se ɓaa taaɗ magal Yaudge tu ɔɔ kɛn ɛɗin̰ lapi se, Isa. ");
INSERT INTO kyq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gɔtn se magal Yaudge baag je tɛɗn kusin̰ Isa ki, taa naan̰ tɛɗga tɛɗ nakŋ se ɓii sebit ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Num gaŋ Isa tɛrlɗen ɔɔ: «Bubum *Raa se ɓɔrse kic utu tɛɗ tɛɗ naabin̰ rɔk, ɔɔ maam kic mꞋtɛɗn naabm ese kici.» ");
INSERT INTO kyq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Taa naan̰ se ɓo magal Yaudge je ɔŋ ɗoobm taar kuuy kɛn Ꞌcir naan̰ se daala kɛn an tɔɔl Isa. Taa Isa se aal deelga do taarɗe, ɔŋ bɔɔb te ɓii sebit se eyo; naan̰ se sum eyo, num gaŋ naan̰ taaɗga taaɗ kici ɔɔ Raa se bubin̰ mala. Bin se naan̰ tɛɗ ron̰ aas te Raa mala. ");
INSERT INTO kyq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isa tɛrl taaɗɗen daala ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: goono se kɔŋ kuun do kalin̰ ki jaay Ꞌtɛɗn nakŋ gɛn don̰ eyo, num nakŋ kɛn Bubin̰ tɛɗ se ɓo, naan̰ aaka ɔɔ tɛɗin̰ kici. Taa nakŋ kɛn Bubu lee tɛɗ se ɓo, Goono kic lee tɛɗin̰ bin kici. ");
INSERT INTO kyq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taa Bubu se je Goonin̰a, ɔɔ taaɗin̰ nakgen naan̰ mala iŋg tɛɗ se paac ɔɔ naan̰ utu an̰ taaɗn nakgen magal cir kɛngen deel kɛn naase aakkiro se daala. Bin se naase utu aki kaak se asen kɔkŋ taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aan gɔɔ Bubu dur jee ooyga kooyo ɔɔ ɛɗɗen kaaja se, Goono kic ɛɗ kaaja jeege tun aan gɔɔ kɛn naan̰ jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bubu se naan̰ ɔj bɔɔrɔ do nam ki eyo, num gaŋ gɛn kɔjn̰ bɔɔr do jeege tu paac se, naan̰ ɔn̰in̰ kaam ji Goonin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taa naan̰ se ɓo jee paac aal Goono maak ki se, kɛse aan gɔɔ naaɗe aal Bubu ɓo maak ki ɔɔ debm jaay baate kaal Goono maak ki se, Bubm kɛn ɔlin̰o se kic ɓo naan̰ aalin̰ maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ꞋBooyki bɛɛ mꞋasen taaɗa: debm jaay booy uun taar maama ɔɔ aal maakin̰ do deb kɛn ɔlumo se, naan̰ ɔŋga *kaajn̰ gɛn daayum. Naan̰ se bɔɔrɔ koocn̰ don̰ ki eyo. Num gaŋ naan̰ se teecga naatn maakŋ yo ki ɔɔ ɔŋga kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«ꞋBooyki bɛɛ mꞋasen taaɗa: ɓii kalaŋ kaaɗin̰ utu Ꞌkaana ɔɔ ɓɔrse kaaɗin̰ se aasga kɛn jeegen aan gɔɔ jee ooyga kooy naan Raa ki se utu booy mind Goon Raa ɔɔ jee kɛn booy uunga se, utu Ꞌkɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taa aan gɔɔ Raa Bubu se naan̰ ɓo Mɛl‑kaaja, taa naan̰ se ɓo Goonin̰ kic naan̰ tɛɗin̰ tɛɗga Mɛl‑kaaja kici. ");
INSERT INTO kyq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gɛn kɔjn̰ bɔɔr do jeege tu se, naan̰ ɔn̰in̰sin̰ga kaam jin̰a taa naan̰ se *Goon Deba. ");
INSERT INTO kyq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Naase taar se ɔn̰te gɛn deel dose, ɓii kalaŋ kaaɗin̰ utu Ꞌkaan se jeegen ooyga kooy paac se utu Ꞌbooy mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jee kɛn tɛɗga nakŋ aak bɛɛ se, utu Ꞌduru ɔɔ utu Ꞌtiŋg gɛn daayum. Ɔɔ jee kɛn tɛɗ nakŋ aak kus se lɛ, naaɗe se kic utu Ꞌduru, naɓo bɔɔrɔ utu koocn̰ doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nakŋ maam tɛɗ se, mꞋuun dom ki kalum ki ɓo mꞋtɛɗ eyo, maam mꞋɔj bɔɔrɔ te kɛn maam mꞋbooyo ɔɔ kɔjn̰ bɔɔr maam se kɛn mɛt ki. Taa maam se, mꞋtɛɗ nakŋ do maak‑jem ki eyo, num gaŋ maam mꞋtɛɗ nakŋ kɛn do maak‑je deb kɛn ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Kɛn maam mala ɓo mꞋtɛɗ saaɗa gɛn dom sum num, saaɗ maam se Ꞌkɔsn kaay eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Num gaŋ deb kuuy ɓo tɛɗum saaɗuma, ɔɔ maam mꞋjeele saaɗn naan̰ se saaɗn kɛn mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɓii kalaŋ naase ɔlkiro jeege gɔtn Jan‑Batist ki ɔɔ saaɗn kɛn naan̰ taaɗseno ro maam ki paac se, kɛn mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Maam se mꞋje nam kuuy ɓo am taaɗn saaɗum eyo, num gaŋ kɛn ɔlum maam taaɗ bin se taa naase aki Ꞌkɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ɔɔ Jan‑Batist se, naan̰ tecn̰ aan gɔɔ lɔɔmpɔn kɛn jꞋɔɔcin̰ga num wɔɔr gɔtɔ se. Kaaɗ kɛn naane se, naase maakse raapo do gɔtn wɔɔr kɛn wɔɔrseno gɔtɔ se. ");
INSERT INTO kyq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Num gaŋ saaɗ maam se cir gɛn Jan‑Batist. Kɛse ɓo naabm kɛn Bubum ɛɗumo ɔɔ mꞋan̰ tɛɗn kaasn ute ɗoobin̰ se. Naabgen se ɓo kɛn taaɗ saaɗn maama, ɔɔ naaɗe se ɓo taaɗ ɔɔ maam se Bu ɓo ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bu kɛn ɔlumo se, naan̰ mala kic ɓo saaɗuma, naɓo naase se ɓii kalaŋ Ꞌbooyki te mindin̰ eyo ɔɔ aakin̰ki te te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɔɔ naase lɛ ɔkki taarin̰ maakse ki eyo, taa ɗi naase Ꞌbaate kaalki maakse do deb kɛn naan̰ ɔlin̰o se. ");
INSERT INTO kyq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Naase iŋg Ꞌdooyki taargen kꞋraaŋin̰o do dɔkin̰ ese, maakse ki se, Ꞌsaapki ɔɔki te naan̰ ese sum ɓo, naase aki Ꞌkɔŋ *kaajn̰ gɛn daayum. Gaŋ taar kɛn taaɗ taargen se, taaɗ te maama. ");
INSERT INTO kyq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kɛn akiro ɓaa gɔtum ki jaay, gɛn kɔŋ kaajn̰ gɛn daayum se lɛ, naase Ꞌbaateki. ");
INSERT INTO kyq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Maam mꞋje jeege ɓo am nook eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Anum maam se mꞋjeelse naase se Ꞌjeki Raa eyo. ");
INSERT INTO kyq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Maam ɓaaɗo se, te ro Bubuma, num gaŋ naase Ꞌbaate Ꞌtookki taaruma. Ɔɔ deb kuuy kɛn utu aɗe ɓaa gɛn don̰ se, naan̰ se naase utu aki tookŋ taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɔɔ naase se Ꞌjeki ɓo tɔɔm naapa sum. Ey num naase se Ꞌjeki Raa ɓo asen tɔɔm eyo. Bin se naase aki Ꞌkɔŋ kaal maakse dom ki ɔɔ ɗio? ");
INSERT INTO kyq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ɔn̰te Ꞌsaapki ɔɔki maam ɓo mꞋasen ɓaa kɔkŋ mindse naan Bu ki. Num kɛn asen ɓaa kɔkŋ mindse se, *Musan kɛn naase ɔndki dose don̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kɛn naase jaay aalki maakse do Musa ki ɗeer num, naase aki kɔŋ kaal maakse do maam ki kici. Taa Musa se taar kɛn naan̰ raaŋo se, taaɗ te maama. ");
INSERT INTO kyq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Num kɛn naase Ꞌtookki te taar kɛn naan̰ raaŋo do dɔkin̰ ey se, naase aki tookŋ taar maam taaɗsen se ɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kɛn nakgen se jaay deel paac se, Isa gaaŋ ɓaa taa baar Galile ki kɛn kaam naane ɔɔ baar Galile se ɓo kꞋdaŋin̰ baar Tiberiad se kici. ");
INSERT INTO kyq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gɔtn se jeege dɛna ɔk mɛtin̰a, taa naaɗe aakga kaak nakŋ‑kɔɔɓgen Isa tɛɗo do jee kɔɔn̰ge tu se. ");
INSERT INTO kyq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Taa naan̰ se ɓo, Isa ute jee mɛtin̰ ki se iin̰ ook ɓaa iŋg do kɔs ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kaaɗ kɛn se, laa Yaudgen kꞋdaŋin̰ *Paak se, ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gɔtn se, Isa uun kaamin̰a ɔɔ aak jee dɛnge utu ɓaaɗo gɔtin̰ ki. Naan̰ ɗeek Pilip ki ɔɔ: «ꞋJe jꞋakiro ɓaa dugŋ mappa kaam gay jaay Ꞌkaasn kɔsn jeegen se?» ");
INSERT INTO kyq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kɛn Isa jaay taaɗ bin se, naan̰ je naŋ taar maakŋ Pilip ki sum. Ey num Isa se jeele nakŋ kɛn jaay naan̰ ɓaan̰ tɛɗa se. ");
INSERT INTO kyq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Gɔtn se Pilip tɛrlin̰ ɔɔ: «Kɛn jꞋuuno tamma kaar‑dio jaay kꞋdugŋ mappa ɔɔ kꞋnigɗesin̰ cɔkɔ cɔkɔ kic ɓo aɗen kɔŋ kaas eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Maakŋ jeege tun mɛtin̰ ki se deb kalaŋ ron̰ Andre, naan̰ se ɓo gɛnaa Simon Piɛr ɗeekin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Goon gaaba utu ese se ɔk mappa mii kɛn kꞋtɛɗin̰ ute rujn̰ ɔrj ute kɛn̰jge sɛɛm sɛɛm dio. Num jee te dɛnɗe se kɛse aɗen kaasn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gɔtn se ɔk mu zɛɛrɛ dɛna; Isa ɗeek jee mɛtin̰ ki ɔɔ: «Jee se Ꞌtaaɗɗeki jꞋiŋg naaŋ ki.» Gɔtn se naaɗe taaɗɗen ɔɔ naaɗe iŋg naaŋ ki. Ɔɔ jee se gaabge kalin̰ ki ɓo ɓaa ɓaa nakŋ dupu‑mii. ");
INSERT INTO kyq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gɔtn se Isa tɔs mappa jin̰ ki, tɔɔm *Raa ɔɔ dup ɔl kꞋnigin̰ jeege tun se paac. Ɔɔ kɛn̰jge kic naan̰ tɛɗin̰ bini naaɗe ɔs dɛrɛŋ te maraadɗe. ");
INSERT INTO kyq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kɛn naaɗe jaay ɔs dɛrɛŋ te maraadɗe aas se, Isa ɗeek jeege tun mɛtin̰ ki ɔɔ: «Togŋ ɔɔp se Ꞌtuunin̰ki, ɔn̰te kɔn̰ki kalaŋ Ꞌkutn cɛrɛ.» ");
INSERT INTO kyq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Togŋ mappan mii ute kɛn̰jgen naaɗe ɔs ɔɔp se, kꞋtɔsin̰ se ɗooc gɔrnɔ sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kɛn jeege jaay aak nakŋ‑kɔɔɓm kɛn Isa tɛɗ se, naaɗe ɗeek ɔɔ: «Ɗeere, kɛse ɓo debm taaɗ taar teeco taar Raa ki mala mala, kɛn jꞋɔɔ te aɗe ɓaa do naaŋ ki se, kɛse ɓo naan̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Anum Isa se jeele, jee se utu an̰ kuun kɔl gaara taa tɔɔg se, gɔtn se naan̰ iin̰ iik cɛɛs ki ɓaa iŋg do ko ki kalin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kɛn kaaɗn tɛgɛr jaay aan se, jee mɛtn Isa ki se, iin̰ bɔɔy ɓaaɗo taa baar ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Naaɗe ook maakŋ markab ki, gɛn ɓaa Kaparnayum ki, jɛŋ baar kɛn kaam naane. Kaaɗ kɛn se gɔtɔ tɛɗga nɔɔrɔ, ɔɔ Isa se aan ɔŋɗen te ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gɔtn se kuulu dɔɔbɔ ɔɔ ɔl makɔn̰ɔ do maane ki. Ɔɔ ɔlin̰ maane se aal walak walak. ");
INSERT INTO kyq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kaaɗ kɛn se naaɗe ɓaaga nakŋ kilɔmɛtir mii lɔ mɛcɛ do maane ki kɛn jee mɛtn Isa ki jaay aak Isa lee do maane ki ɔɔ utu ɓaaɗo ɓaa cɛɛ markab ki se. Gɔtn se naaɗe ɓeere ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gaŋ Isa ɗeekɗen ɔɔ: «Ɔn̰te Ꞌɓeerki, kɛse maama.» ");
INSERT INTO kyq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gɔtn se naaɗe je an̰ kuunin̰ maakŋ markab ki, naɓo markaba se naar aanga jɛŋ ki, gɔt kɛn naaɗe ɓaan ɓaa ro ki se. ");
INSERT INTO kyq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɛtbeen̰ki se, jee dɛngen ɔɔpo do jɛŋ kɛn kaam naane se, naaɗe aako markaba se ɔɔpga kalaŋ sum, ɔɔ Isa ute jee mɛtin̰ ki se ook te maakŋ markab kɛn se eyo. Jee mɛtin̰ ki se ɓaaga kalɗe ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kaaɗ kɛn se, markabgen kuuy iin̰o Tiberiad ɔɔ ɓaaɗo gɔɔr ute gɔtn kɛn Isa tɔs mappa jin̰ ki, jaay tɔɔm Raa ɔɔ ɛɗ jeege tu ɔs se. ");
INSERT INTO kyq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kɛn jee dɛnge jaay aak Isa ute jee mɛtin̰ ki, gɔtɔ gɔtn ese se, naaɗe took maakŋ markabge tu ɔɔ ɓaa Kaparnayum ki taa ɓaa je Isa. ");
INSERT INTO kyq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kɛn naaɗe jaay ɓaa ɔŋin̰ naaŋ baar kɛn kaam naane se, naaɗe tɔnd mɛtin̰ ɔɔ: «Debm dooy jeege, naai tap ɓo aan gɔtn ara nuŋ ki?» ");
INSERT INTO kyq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Gɔtn se Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ maam mꞋasen taaɗa: naase Ꞌjemki se, taa nakŋ‑kɔɔɓm maam mꞋtɛɗ se ɓo naase Ꞌjeel ɔkkiga kɔk mɛtin̰ eyo, num gaŋ naase Ꞌjemki se, taa nakŋ kɔsn naase ɔs Ꞌdɛrɛŋkiro te maraadse se. ");
INSERT INTO kyq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ɔn̰te Ꞌtɛɗki naaba kalin̰ ki gɛn nakŋ kɔsn kɛn tɛɗga sum ɓo Ꞌruum se. Num Ꞌtɛɗki naaba taa nakŋ kɔsn kɛn Ꞌtiŋg gɛn daayum. Nakŋ kɔsn ese ɓo kɛn maam *Goon Deba mꞋutu mꞋasen kɛɗa, taa Raa Bubu mala se ɛɗga tɔɔgin̰ goonin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Naabm Raa se jꞋan̰ tɛɗn ɔɔ ɗi jaay ɓo jꞋaki tɛɗn aan gɔɔ kɛn naan̰ jen ro ki se?» ");
INSERT INTO kyq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isa tɛrlɗen ɔɔ: «Kɛse ɓo naabm kɛn Raa je ɔɔ naase aki tɛɗa; naan̰ je ɔɔ aki kaal maakse do deb kɛn naan̰ ɔlin̰o.» ");
INSERT INTO kyq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Naaɗe tɛrlin̰ ɔɔ: «Num naai tap ɓo ajen Ꞌtɛɗn nakŋ‑kɔɔɓm ɗi jaay naaje kꞋkaaka, jaay ɓo jꞋkaal maakje doi ki se? Nakŋ naai Ꞌɓaa Ꞌtɛɗa tap ɓo ne ɗi? ");
INSERT INTO kyq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Do kɔɗ‑ɓaar ki se, bubjege ɔso nakŋ kɔsn kɛn kꞋdaŋin̰ maan, kɛse ɓo taar kɛn kꞋraaŋin̰o taaɗo ɔɔ: Gɛn kɔsɗe se Raa ɛɗɗeno mappan bɔɔyɔ raan.» ");
INSERT INTO kyq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Gaŋ Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen ɗeeke: kɛn ɛɗseno mappan bɔɔyɔ raan se *Musa eyo, num mappan mala mala kɛn bɔɔyɔ raan se, Bubum ɓo, ɛɗseni. ");
INSERT INTO kyq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ɔɔ mappan gɛn Raa se, naan̰ ɓo debm kɛn bɔɔyɔ raan, ɔɔ naan̰ ɓo debm ɛɗ kaaja jeege tun do naaŋ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Gɔtn se naaɗe ɗeekin̰ ɔɔ: «Jaamus, ɓii‑raa ɛɗjen mappan ese.» ");
INSERT INTO kyq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isa tɛrlɗen ɔɔ: «Maam ɓo mappan kɛn ɛɗ kaaja se, debm kɛn jaay ɓaaɗo gɔtum ki se, mɔɔtn ɓo an̰ tɔɔl eyo; ɔɔ debm jaay aal maakin̰ do maam ki se, mɔɔtn maane an̰ tɔɔl eyo. ");
INSERT INTO kyq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ey num maam mꞋtaaɗsenoga, ɔɔ naase mala kic ɓo aakumkiroga naɓo naase Ꞌbaate Ꞌkaalki maakse dom ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jeegen paacn̰ Bu ɓo ɛɗumɗe se utu aɗe ɓaa gɔtum ki, ɔɔ debm kɛn ɓaaɗo gɔtn maam ki se, maam mꞋan̰ kɔŋ kɔɔɗn kund eyo. ");
INSERT INTO kyq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taa maam mꞋbɔɔyo raan se, gɛn tɛɗn nakŋ kɛn maam ɓo mꞋje eyo, num gaŋ mꞋɓaaɗo se, gɛn tɛɗn nakŋ kɛn debm ɔlumo se ɓo jea. ");
INSERT INTO kyq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Debm ɔlumo se, nakŋ naan̰ je se, jeegen naan̰ ɛɗumsin̰ paac se, mꞋɔn̰te kutn deb kalaŋ. Num naan̰ je ɓii kɛn kaam mɔɔtn se, maam mꞋaɗen dur daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kɛse ɓo nakŋ kɛn Bubum jea. Debm jaay aak Goono ɔɔ aal maakin̰ don̰ ki se, naan̰ se ɔŋga *kaajn̰ gɛn daayum. Ɓii kɛn kaam mɔɔtn se, maam mꞋan̰ durin̰ daan yoge tu.» ");
INSERT INTO kyq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gɔtn ese Yaudge baag mooy naaŋ ki dir dir utu naapa ro Isa ki, taa Isa taaɗga taaɗ ɔɔ: «Maam ɓo kɔsn kɛn bɔɔyo raan.» ");
INSERT INTO kyq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tɛr naaɗe taaɗ ɔɔ: «Kɛse Isan kɛn goon Yusup se ey la? Kɛn kon̰ ute Bubin̰ kꞋjeelɗeki se ey la? Tɛɗ ɔɔ ɗi jaay ɓɔrse num taaɗ ɔɔ: ‹Maam bɔɔyo raan se?›» ");
INSERT INTO kyq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Gɔtn se Isa tɛrlɗen ɔɔ: «Ɔn̰te Ꞌtaaɗki naaŋ ki ute naapa rom ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bu kɛn ɔlumo se, nam nam jaay naan̰ tiik ɔlin̰ te gɔtum ki ey se, aɗe kɔŋ ɓaa gɔtum ki eyo. Ɔɔ debm kɛn Bu ɔlumsin̰ga se, ɓii kɛn kaam mɔɔtn se maam mꞋan̰ durin̰ daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jee taaɗ taar teeco taar Raa ki raaŋo do dɔkin̰ ɔɔ: Raa se, utu dooy jeege paac. «Ɔɔ debm kɛn jaay ɔndga bin̰ do taar Bubum ki, ɔɔ booy ɔkga taarin̰ kɛn naan̰ dooy jeege se, aɗe kɔŋ ɓaa gɔtum ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taa nam, ɓii kalaŋ aak te Bu eyo. Debm kɛn iin̰o gɔtn Raa ki se naan̰ kalin̰ ki sum ɓo aakkiga Bua. ");
INSERT INTO kyq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ꞋBooyki bɛɛ mꞋasen taaɗa: debm jaay aalga maakin̰ do maam ki se, naan̰ ɔŋga kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taa maam ɓo mꞋmappan kɛn ɛɗ kaaja jeege tu. ");
INSERT INTO kyq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Do kɔɗ‑ɓaar ki, do dɔkin̰ naane se, bubsege ɔso nakŋ kɔsn kɛn kꞋdaŋin̰ maan. Te naan̰ se kic ɓo naaɗe ooyga. ");
INSERT INTO kyq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Num kɛse ɓo mappan bɔɔyo raan, debm jaay ɔsga naan̰ se num, naan̰ Ꞌkɔŋ kooy eyo. ");
INSERT INTO kyq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Maam ɓo kɔsn bɔɔyo raan ɔɔ kɛn ɛɗ kaaja. Debm jaay ɔsga kɔsn ese num, naan̰ utu tiŋg gɛn daayum daayum. Kɔsn kɛn maam mꞋutu mꞋasen kɛɗ se, kɛse daa rom mala; naan̰ se ɓo kɛn utu kɛɗn kaaja jeege tun do naaŋ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kɛn Yaudge jaay booy taar se, naaɗe baag naajn̰ te naapa makɔn̰ɔ ɔɔ: «Gaabm se jaay ɔɔ ajeki kɛɗn daa ron̰ ɓo jꞋaki kɔs se, jꞋan̰ki kɔsn ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Gɔtn se Isa ɗeekɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: kɛn naase jaay ɔski te daa ro maam Goon Deb eyo, ɔɔ aayki te moosum ey se, naase aki kɔŋ kaajn̰ mala eyo. ");
INSERT INTO kyq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Debm ɔs daa roma ɔɔ aay moosum se, naan̰ ɔŋga kaajn̰ gɛn daayum, ɔɔ kɛn naan̰ ooyga kic ɓo, ɓii kɛn kaam mɔɔtn se maam mꞋan̰ durin̰ daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ɗeere, daa rom se, kɛse ɓo nakŋ kɔsn mala mala, ɔɔ moosum se lɛ, naan̰ ɓo nakŋ kaay mala mala kici. ");
INSERT INTO kyq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɔɔ debm tiŋg tɔs daa roma, ɔɔ tiŋg taay moosum se, naan̰ se iŋg *dɔɔk ute maama, ɔɔ maam mꞋiŋg dɔɔk te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aan gɔɔ Bua kɛn ɛɗ kaaja nakge tun ɓaa se paac se, naan̰ ɓo debm kɛn ɔlumo ɔɔ naan̰ ɓo debm ɛɗum kaaja maam ki kici. Taa naan̰ se ɓo, debm kɛn ɔs daa ro maam se Ꞌkɔŋ kaaja gɔtum ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kɛse mappan kɛn bɔɔyo raan. Naan̰ se tec aan gɔɔ kɔsn kɛn bubsege ɔso do dɔkin̰ do kɔɗ‑ɓaar ki se eyo. Ute naan̰ se kic ɓo naaɗe ooyga, num gaŋ debm ɔs mappan ese se, naan̰ Ꞌkɔŋ kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Taargen se ɓo, Isa dooy jeege maakŋ *ɓee kɛn Yaudge lee tusn maak ki gɛn keem Raa kɛn maakŋ gɛgɛr kɛn Kaparnayum ki. ");
INSERT INTO kyq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jee mɛtin̰ ki, kɛn mɛtin̰ge se jaay booy taar Isa taaɗ bin se, maakɗe ki se jeege dɛna baag taaɗn ɔɔ: «Taar se, ɔɔn̰ aak eyo! Naŋa jaay Ꞌkɔŋ Ꞌbooy taar se?» ");
INSERT INTO kyq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Isa jeel maak‑saapɗe kɛn jee mɛtin̰ ki jaay baag mooy naaŋ ki ron̰ ki se, do taar kɛn naan̰ taaɗ se ɗeekɗen ɔɔ: «Naase maakse tujga do taar kɛn se la? ");
INSERT INTO kyq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Num kɛn naase amki kaakŋ maam *Goon Deba mꞋkookŋ ɓaa gɔtum kɛn deet se, naase tap ɓo aki taaɗn ɔɔki ɗi? ");
INSERT INTO kyq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kɛn ɛɗ kaaja jikilimge tu se, *Nirl Raa; ey num jikilimge kalɗe ki se, Ꞌkɔŋ kaajn̰ roɗe eyo. Taargen maam taaɗsesin̰o se, iin̰o gɔtn Nirl Raa kɛn lee ɛɗ kaaja jeege tu se. ");
INSERT INTO kyq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Num gaŋ maakse ki se, jee mɛtin̰ge aal maakɗe dom ki eyo.» Taa gɔtn do dɔkin̰ tap ɓo Isa se, naan̰ jeel jeegen aal maakɗe don̰ ki ey se, ɔɔ debm kɛn utu an̰ kutin̰ se kic ɓo, naan̰ jeelin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tɛr Isa taaɗɗen ɔɔ: «Taa naan̰ se ɓo maam taaɗseno mꞋɔɔ: debm kɛn Raa ɔɔɗin̰ te ɗoob ey se, naan̰ aɗe kɔŋ ɓaa gɔtum ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kɛn jee mɛtin̰ ki jaay booy taar bin se, dɛnin̰ iin̰ rɛsin̰a ɔɔ baate ɓaa ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gɔtn se Isa tɔnd mɛtn jee mɛtin̰ kɛn ɔɔp sik‑kaar‑di se ɔɔ: «Num naase se, Ꞌje aki ɓaa ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Gɔtn se Simon Piɛr tɛrlin̰ ɔɔ: «Mɛluma, naai ɓo ɔk taar kɛn ɛɗ *kaajn̰ gɛn daayum. Kɛn jaay kɔn̰ naai se kꞋɓaa gɔtn naŋ ki? ");
INSERT INTO kyq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Taa naaje se jꞋaalga maakje do naai ki ɔɔ kꞋjeeli naai se Debm *Salal kɛn iin̰o gɔtn Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tɛr Isa taaɗɗen ɔɔ: «Naasen sik‑kaar‑di ki se, maam ɓo mꞋbɛɛr tɔɔɗseno ey la? Num gaŋ maakse ki se, deb kalaŋ se, tec sitan te kaamin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kɛse naan̰ taaɗ te Judas goon Simon kɛn Iskariɔt; naan̰ ɓo debm kɛn maakŋ jeege tun sik‑kaar‑dio kɛn utu an̰ kut se. ");
INSERT INTO kyq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kɛn nakgen se paac jaay deel se kic ɓo, Isa utu lee lee taa naaŋ Galile ki rɔk. Ɔɔ naan̰ baate ɓaa lee taa naaŋ Jude ki taa magal Yaudge se je je ɗoobm an̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kaaɗ kɛn se, laa Yaudgen kɛn kꞋdaŋin̰ *laa Daabge se, ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Gɔtn se gɛnaan̰ge ɗeekin̰ ɔɔ: «Bɛɛki num, naai Ꞌkiin̰ ɓaa taa naaŋ Jude ki, taa nakŋ‑kɔɔɓgen naai Ꞌtɛɗ gɔtn ara se, Ꞌɓaa tɛɗin̰ naane kici taa jee mɛti ki Ꞌɓaa kaaka. ");
INSERT INTO kyq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kɛn debm jaay je ɔɔ jeege jeel gɔtin̰ se, naan̰ tɛɗ nakge tal tal, ɔyin̰ kɔy eyo. Taa ɗi nakŋ‑kɔɔɓgen naai Ꞌlee tɛɗ se, ɓaa tɛɗin̰ naan jeege tu, taa jeege paac ai kaakŋ jeele.» ");
INSERT INTO kyq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taa gɛnaa Isage mala kic ɓo, naaɗe aal maakɗe don̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Gɔtn se Isa ɗeekɗen ɔɔ: «Gɛn tɛɗn nakŋ ese se, kaaɗum aas te ey ɓɔrtɔ. Num gaŋ gɛn naase lɛ, kaaɗn gay gay kic ɓo jigsen naase ki. ");
INSERT INTO kyq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jee do naaŋ ki se asen kɔŋ kɔɔɗn kund naase eyo; num gaŋ maam se naaɗe ɔɔɗ undum naata. Taa maam mꞋlee mꞋtɔɔɗɗen tɔɔɗ mɛtn *kusin̰ɗege. ");
INSERT INTO kyq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gɛn ɓaa tɛɗn laa se, naase Ꞌɓaaki. Ɔɔ maam se mꞋɓaa eyo, taa kaaɗum aas te ey ɓɔrtɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ ɔɔp iŋg taa naaŋ Galile ki. ");
INSERT INTO kyq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kɛn gɛnaan̰ge jaay iin̰ ɓaa gɛn tɛɗn laa se, naan̰ kic iin̰ ɓaa. Naɓo kɛn naan̰ ɓaa ɓaa se goon̰ goon̰o ɔɔ kɛn aan naane se kic ɓo tɔy tɔy ron̰a. ");
INSERT INTO kyq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Maakŋ ɓiige tun Yaudge tɛɗ tɛɗ laa taal Daabge se, magal Yaudge lee je je Isa ɗeek ɔɔ: «Naan̰ tap ɓo gay?» ");
INSERT INTO kyq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jeege dɛna gɔtn se taaɗ naaŋ ki, ɔɔ naaj te naapa ro Isa ki. Jee mɛtin̰ge ɗeek ɔɔ: «Gaabm se, naan̰ debm jiga.» Ɔɔ kɛngen kuuy ɗeek ɔɔ: «Ɓɛrɛ naan̰ se, iig kiig ɓo jeege.» ");
INSERT INTO kyq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Num gaŋ debm jaay Ꞌtaaɗn taa Isa tal naan jeege tu se gɔtɔ, taa naaɗe se ɓeer ɓeer magal Yaudge tu. ");
INSERT INTO kyq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kaaɗ kɛn jeege tɛɗ tɛɗ laa gɛn taal Daabge jaay aan daanin̰ ki se, Isa ɓaaɗo ɛnd daan bɔɔr *Ɓee Raa ki ɔɔ baag dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kɛn Yaudge jaay booy naan̰ iŋg dooy dooy jeege se, ɔkɗen taaɗ eyo, ɗeek ɔɔ: «Gaabm se lɛ, iŋgo te gɛn dooyo gam eyo, num jeel nakge dɛn bin se ɔŋin̰o gay?» ");
INSERT INTO kyq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Num gaŋ Isa tɛrlɗen ɔɔ: «Taargen maam dooy jeege se, mꞋtɛrɛc daan dom ki eyo, num taargen se, debm kɛn ɔlumo se ɓo taaɗumsin̰o. ");
INSERT INTO kyq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Debm kɛn je tɛɗn nakŋ kɛn *Raa maakin̰ ɓo jen ro ki se, kɔŋ Ꞌjeele taargen maam dooy jeege se, mꞋtɛrɛc te daan dom ɓo mꞋtaaɗ eyo num taargen se iin̰o gɔtn Raa ki. ");
INSERT INTO kyq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Debm kɛn jaay tɛrɛc te daan don̰ sum ɓo, taaɗ se naan̰ je jeege ɓo an̰ *nooko. Num gaŋ debm je jeege nookŋ debm ɔlin̰o naaba se, naan̰ se taaɗ taar mɛt ki ɔɔ ɔk taar‑kɔɔɓ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kɛn ɓaaɗo taaɗsen *Ko Taar Raa se, *Musa ey la? Gaŋ maakse ki se, debm jaay ɔk Ko Taar Raa jiga se gɔtɔ, ey num kɛn naase jaay Ꞌje amki tɔɔl se taa ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gɔtn se jee dɛnge tɛrlin̰ ɔɔ: «Naai se ɔk sitan! Nam nam je aay tɔɔl naai se tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isa tɛrlɗen ɔɔ: «Ɓii kalaŋ se, maam tɛɗo nakŋ‑kɔɔɓɔ kalaŋ bini, ɔɔ nakŋ‑kɔɔɓm se deelo dose, ɔɔ ɔksen gɛn taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa se taaɗseno ɔɔ gaangen gaabge se Ꞌtɔjɗeki pɔndɔ, num gaŋ *kɔjn̰ pɔndɔ se iin̰o do bubge tun do dɔkin̰a, do Musa ki sum eyo. Taa naan̰ se ɓo kɛn aanga *ɓii sebit ki kic ɓo, naase lee Ꞌtɔjki pɔndɔ gɛnsege tu. ");
INSERT INTO kyq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Taa naan̰ se ɓo, naase Ꞌtɔjki pɔndɔ gɛnsege tu utu ɓii sebit kic ɓo tuj Ko Taar kɛn Raa ɛɗo Musa ki se eyo. Num gaŋ debkilimi ute magalin̰ ɓo maam mꞋɛɗin̰ lapi ɓii sebit ki jaay naase maakse taarse se taa ɗi? ");
INSERT INTO kyq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kɛn jaay aki kɔjn̰ bɔɔrɔ do nam ki num, ɔn̰te kɔjki do nakge tun, kɛn naase aki ute kaamse sum eyo, num ɔjki bɔɔrɔ ute ɗoobin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gɔtn se jee Jeruzalɛm kɛn mɛtin̰ge ɗeek ɔɔ: «Kɛse ɓo gaabm kɛn kꞋje jꞋan̰ tɔɔl se ey la? ");
INSERT INTO kyq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ꞋBooyki naan̰ ɗaar tal taaɗ taaɗ naan jeege tu, ɔɔ tɔɔgjege se, nam tap ɓo taaɗin̰ taar ɗim eyo. Lɔ bin se naaɗe jeelin̰ga naan̰ *al‑Masi ɗeer ne? ");
INSERT INTO kyq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Num al‑Masi jaay utu aɗe ɓaa se, gɔtn naan̰ ano kiin̰ tap ɓo nam jeel eyo. Gaŋ gaabm se lɛ, naaje kꞋjeelki gɔtn naan̰ iin̰no ro ki.» ");
INSERT INTO kyq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kaaɗ kɛn Isa dooy dooy jeege daan bɔɔr Ɓee Raa ki se, kɛn naan̰ jaay booy taarɗe se, uun mindin̰ raan ɗeekɗen ɔɔ: «Ɗeere, naase Ꞌjeelumki ɔɔ Ꞌjeelki gɔtn maam mꞋiin̰no. Anum, maam se mꞋiin̰o gɛn dom ɓo mꞋɓaaɗo eyo. Num deb kuuy ɓo ɔlumo, ɔɔ debm ɔlumo se taaɗ taar mɛt ki. Num gaŋ naan̰ se naase Ꞌjeelin̰ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Anum debm se maam mꞋjeelin̰a taa maam se mꞋiin̰o gɔtin̰ ki, ɔɔ naan̰ ɓo ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gɔtn se naaɗe je an̰ kɔkɔ naɓo nam ɔŋ ɔl te jin̰ ron̰ ki eyo, taa kaaɗin̰ aas te ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gaŋ maakŋ jee dɛnge tu se, jee mɛtin̰ge took aal maakɗe don̰ ki ɔɔ naaɗe ɗeek ɔɔ: «Kɛn al‑Masi utu aɗe ɓaa se Ꞌkɔŋ Ꞌtɛɗn nakŋ‑kɔɔɓgen dɛn cir gɛn gaabm ese tɛɗ se la?» ");
INSERT INTO kyq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gɔtn se *Parizige ɓaa booy taar kɛn jeege lee taaɗ naaŋ ki ro Isa ki se, naaɗe ute magal jee tɛɗn sɛrkge se, ɔl asgargen lee bɔɔb Ɓee Raa se, gɛn ɓaa kɔkŋ Isa. ");
INSERT INTO kyq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gaŋ Isa ɗeekɗen ɔɔ: «Maam se, ɔɔpumga baata kɛn mꞋkiŋg te naase ɔɔ tɛɗga ɓo maam ɓaa kɔŋ debm kɛn ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Naase utu amki jea, naɓo amki je kɔŋ eyo. Taa gɔtn maam ɓaan ɓaa se, naase aki kɔŋ kaan eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Gɔtn se Yaudge baag taaɗn te naapa ɔɔ: «Naan̰ tap ɓo ɓaa kaam gay, jaay naaje jꞋan̰ki kɔŋ kɔŋ ey se? Ɔɔ ɓaa tiŋg daan Yaudge tun wɔɔk maakŋ Grɛkge tu se la? Ɔɔ gɔtn naane se naan̰ ɓaa dooy Grɛkge la? ");
INSERT INTO kyq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ey num taar naan̰ taaɗ ɔɔ: ‹Naase utu amki jea, naɓo amki je kɔŋ eyo, taa gɔtn maam ɓaan ɓaa se, naase aki kɔŋ kaan eyo.› Taar se tap ɓo naan̰ je ɗeekŋ ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɓii magal cir paacn̰ gɛn *laa Daabge se, ɓiin kɛn kaam mɔɔtn. Ɓiin se ɓo Isa iin̰ ɗaara ɔɔ uun mindin̰ raan ɔɔ baag taaɗa ɔɔ: «Debm kɛn jaay maane tɔɔlin̰ se n̰Ꞌɓaaɗo gɔtum ki ɔɔ n̰Ꞌkaaye. ");
INSERT INTO kyq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aan gɔɔ taar kɛn kꞋraaŋo do dɔkin̰ taaɗ ɔɔ: debm jaay aalga maakin̰ dom ki se, Ꞌkɔŋ maan kɛn ɛɗ kaaja. Ɔɔ maan kɛn ɛɗ kaaja se, aɗe kiin̰ maakin̰ ki ɔɔ Ꞌtooɗn kɔɔy maakin̰ ki kɔl kɔl aan gɔɔ maan maakŋ oolge tu.» ");
INSERT INTO kyq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kɛn Isa jaay taaɗ taar se, naan̰ je taaɗn taa *Nirl Raa, kɛn tɛɗga num, jee aalga maakɗe don̰ ki se utu Ꞌkɔŋɔ. Taa kaaɗ kɛn se, Nirl Raa bɔɔy te ey ɓɔrtɔ; taa Isa se ook ɓaa te raan gɔtn jꞋansen nook ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kɛn jeege jaay booy taar se, jee mɛtin̰ge ɗeek ɔɔ: «Gaabm se, ɗeere naan̰ se debm taaɗ taar teeco taar Raa ki mala mala.» ");
INSERT INTO kyq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jee mɛtin̰ge taaɗ ɔɔ: «Naan̰ se ɓo *al‑Masi.» Gaŋ jee mɛtin̰gen kuuy taaɗ ɔɔ: «Al‑Masi ɓo aɗe kiin̰ taa naaŋ Galile ki ne? Kɛse gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ey num taargen do dɔkin̰ kꞋraaŋin̰ga raaŋ se ɗeek ɔɔ: Al‑Masi se, aɗe teecn̰ mɛtjil *Daud ki ɔɔ aɗe kiin̰ Betleem ki, kɛn maakŋ naaŋ Daud ki ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taa Isa se jee dɛn se, taarɗe ɓaa ɔk mɛtn naap eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Gɔtn se jeege kandum maakɗe ki se je an̰ kɔkɔ naɓo nam ɔŋ ɔl te jin̰ ron̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Asgargen lee bɔɔb *Ɓee Raa se ɔk tɛrlo ɓaaɗo ɔŋ *magal jee tɛɗn sɛrkɛ Raage tu ute *Parizige. Naaɗe taaɗ asgarge tu ɔɔ: «Gɛn ɗi jaay naase Ꞌbaate kɔkŋ ɓaansin̰kiro se?» ");
INSERT INTO kyq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gɔtn se asgarge tɛrlɗen ɔɔ: «Ɓii kalaŋ tap ɓo nam ɔŋ taaɗ te taara aan gɔɔ gɛn gaabm se eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Anum Parizige se, tɛrlɗen ɔɔ: «Naase kic gaabm se taaɗ bisenga dose kic la? ");
INSERT INTO kyq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maakŋ magalge tu ey lɛ maakŋ Parizige tu se aakkiga nam kalaŋ tookga taarin̰ la? ");
INSERT INTO kyq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Num gaŋ jee dɛn took taarin̰ se naaɗe jeel *Ko Taar kɛn Raa ɛɗo Musa ki se eyo, ɔɔ naaɗe se lɛ jee kɛn Raa naamɗega naama.» ");
INSERT INTO kyq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gaŋ maakŋ Parizige tu se gaaba kalaŋ ron̰ Nikodem, naan̰ se ɓii kalaŋ iŋgoga kiŋg gɔtn Isa ki kici ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ko Taar kɛn Raa ɛɗjekiro se, debkilimi jaay kꞋbooy te taarin̰ eyo, ɔɔ jꞋaak te nakŋ kɛn naan̰ tɛɗ ey se, jꞋan̰ kɔkŋ mindin̰ jꞋɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Gɔtn se naaɗe tɛrlin̰ ɔɔ: «Naai kic Ꞌtɛɗn kɔɗ Galile la? ꞋƁaa dooy ɔk taargen kꞋraaŋɗeno do dɔkin̰ se jiga jaayo, ɓii kalaŋ tap ɓo debm taaɗ taar teeco taar Raa ki gam teeco te taa naaŋ Galile ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gɔtn se, naŋa naŋa kic ɓo iin̰ uun ɗoobm ɓeen̰a ɓeen̰a. ");
INSERT INTO kyq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Naan̰ kɛn se Isa iin̰ ɓaa do *kɔsn ɔlib ki. ");
INSERT INTO kyq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mɛtbeen̰ki tanɔɔrin̰ nɔɔrin̰ se, naan̰ ɔk tɛrlo daan bɔɔr *Ɓee Raa ki ɔɔ jeege paac ɓaaɗo ɔŋin̰a. Gɔtn se naan̰ booy iŋg naaŋ ki ɔɔ baagɗen dooyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gɔtn se jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage ute *Parizige se ɔk ɓaano te mɛnd gaaba kalaŋ bin se jꞋɔkin̰o te gaabm kuuy. Naaɗe ɓaaɗo ɔndin̰ daan jeege tu. ");
INSERT INTO kyq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naaɗe ɗeek Isa ki ɔɔ: «Debm dooy jeege, mɛnd se tɛɗga nakŋ *kusin̰a jꞋɔŋin̰o tooɗ tooɗ te gaabm kuuy. ");
INSERT INTO kyq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Maakŋ *Ko Taar kɛn Raa ɛɗo Musa ki se taaɗjeki ɔɔ: ‹Mɛndgen bin se jꞋaɗen tund tɔɔl te koa.› Num gɛn naai ki num ɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kɛn naaɗe jaay taaɗ bin se, je kɛn naan̰ taaɗga taar ɗim cɔkɔ sum ɓo, naaɗe an̰ goom kɔkɔ taa an̰ kɔkŋ mindin̰a. Num gaŋ gɔtn se, Isa no don̰ naaŋ ki ɔɔ baag raaŋ naaŋ ki ute goon jin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aan gɔɔ naaɗe dɔɔk taara tɔnd mɛtin̰ ɔn̰ ey se, gɔtn se Isa uun don̰ ɗeekɗen ɔɔ: «Maakŋ naase kɛn Ꞌpaacki se, nam nam ɓii kalaŋ jaay tɛɗ te nakŋ kusin̰ ey num, uun koa und mɛnd se deete.» ");
INSERT INTO kyq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Gɔtn se tɛr naan̰ no don̰ naaŋ ki daala ɔɔ baag raaŋ naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kɛn naaɗe jaay booy taar ese se, naŋa naŋa kic ɓo uun ɗoobin̰ ɗoobin̰a. Jee magalge se ɓo baag kiin̰ ɓaa deet deet. Gɔtn se ɔɔp Isa kalin̰ ki te mɛnd kɛn naaɗe ɔk ɓaano daanɗe ki se. ");
INSERT INTO kyq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Num gɔtn se Isa uun don̰ daala ɗeek mɛnd ki se ɔɔ: «Mɛnda, jee se ɓaaga gay? Maakɗe ki se, nam nam Ꞌɗaar jaay Ꞌkɛnd teeli gɛn kuti se gɔtɔ ne?» ");
INSERT INTO kyq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mɛnda se ɗeekin̰ ɔɔ: «Jaamus, nam utum te eyo.» Gɔtn se Isa ɗeekin̰ ɔɔ: «Maam kic mꞋje kuti eyo. ꞋƁaao naɓo mɔɔtn ɔn̰te tɛɗn nakŋ kusin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isa ɗeek jeege tu daala ɔɔ: «Maam se, mꞋgɔtn wɔɔr gɛn jeege paac. Debm kɛn ɓaaɗoga mɛtum ki se, naan̰ se lee maakŋ gɔt kɛn ɔɔɗ eyo. Gaŋ naan̰ se Ꞌkɔŋ gɔtn wɔɔr kɛn an̰ tɔɔɗn kɔl gɔtn kɛn naan̰ an kɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Gɔtn se *Parizige ɗeekin̰ ɔɔ: «Naai ɓo Ꞌtɛɗn saaɗn gɛn naai mala se, saaɗn naai se ɔs aay eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isa tɛrlɗen ɔɔ: «Kɛn maam mꞋtɛɗn saaɗn maam mala kic ɓo, saaɗn maam se ɔs aaye. Taa maam mꞋjeel gɔtn maam mꞋiin̰no ɔɔ gɔtn maam mꞋan ɓaa. Num gaŋ naase gɔtn maam mꞋiin̰no lɛ, Ꞌjeelki eyo ɔɔ gɔtn maam ɓaan ɓaa ro ki kic ɓo, naase Ꞌjeelki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Naase ɔjki bɔɔrɔ do jeege tu aan gɔɔ kɛn jikilimge lee tɛɗa. Num maam lɛ mꞋɔj bɔɔrɔ do nam ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kɛn jaay aanumga gɛn kɔjn̰ bɔɔrɔ kic num, kɔjn̰ bɔɔr maam se kɛn mɛt ki. Taa maam se mꞋkalum ki eyo, num Bu kɛn ɔlumo se kic utu te maama. ");
INSERT INTO kyq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Maakŋ *Ko Taar kɛn Raa ɛɗseno se, kꞋraaŋin̰ga raaŋ jꞋɔɔ: kɛn jeege di jaay taaɗ taarɗe ɔk mɛtn naapa se saaɗn naaɗe se, ɔs aaye. ");
INSERT INTO kyq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Maam mala ɓo mꞋtaaɗn saaɗuma ɔɔ Bubum kɛn ɔlumo se kic taaɗ saaɗn maama.» ");
INSERT INTO kyq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Bubi naai Ꞌtaaɗn se gay?» Isa tɛrlɗen ɔɔ: «Naase lɛ Ꞌjeelumki eyo. Ɔɔ Bubum kic naase Ꞌjeelin̰ki eyo. Kɛn naase jaay Ꞌjeelumki maam num, Bubum kic ɓo naase an̰ki Ꞌkɔŋ jeel kici.» ");
INSERT INTO kyq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isa taaɗ taargen se, kaaɗ kɛn naan̰ dooy dooy jeege daan bɔɔr *Ɓee Raa ki. Naan̰ kɛn se, naan̰ iŋg cɛɛ nakŋ kɛn jeege lee tɔmb *sɛrkɛ maak ki; num gaŋ gɔtn se, nam ɔŋ ɔl te jin̰ ron̰ ki eyo taa kaaɗin̰ aas te ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isa taaɗɗen daala ɔɔ: «Maam se mꞋɓaa ɓaao ɔɔ naase utu amki jea, naɓo naase se utu aki kooy maakŋ *kusin̰se ki. Taa gɔtn maam mꞋan ɓaa se lɛ, naase aki kɔŋ ɓaa eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Gɔtn se magal Yaudge taaɗ te naapa ɔɔ: «Taar kɛn naan̰ taaɗ ɔɔ gɔtn maam mꞋɓaan ɓaa se naase aki kɔŋ ɓaa eyo. Bin se, naan̰ kalin̰ ki ɓo ɓaa ɓaa tɔɔl ron̰ la?» ");
INSERT INTO kyq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Isa tɛrlɗen ɔɔ: «Naase se, jee do naaŋ ki, num maam lɛ, mꞋiin̰o raan. Naase se, jee do naaŋ ki ara, num maam se, mꞋmɛtn jee do naaŋ ki ara ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Taa naan̰ se ɓo maam taaɗseno mꞋɔɔ, naase se utu aki kooy maakŋ kusin̰sege tu. Kɛn naase jaay Ꞌbaate Ꞌkaalki maakse do maam kɛn mꞋiŋg daayum se, naase se utu aki kooy maakŋ kusin̰sege tu.» ");
INSERT INTO kyq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Naai tap ɓo naŋa?» Isa tɛrlɗen ɔɔ: «Do kupm mɛt ki tap ɓo maam mꞋɔn̰ te eyo num mꞋtaaɗsenoga. ");
INSERT INTO kyq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Do naase ki se, maam mꞋɔk taarge dɛna kɛn mꞋasen taaɗa ɔɔ gɛn kɔjn̰ bɔɔrɔ dose ki. Num gaŋ Debm kɛn ɔlumo se, naan̰ taaɗ taar mɛt ki. Ɔɔ taar kɛn maam taaɗ jeege tu se, mꞋbooyo gɔtn naan̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Num taar jaay naan̰ taaɗɗen te *Raa Bubu se, naaɗe ɔnd te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Gɔtn se Isa ɗeekɗen daala ɔɔ: «Kɛn naase jaay Ꞌtup Ꞌtɔɔlkiga *Goon Deba ro kaag ki uun ɗaarin̰kiga raan se, kaaɗ kɛn se jaay naɓo naase aki jeele, maam se ɓo debm kɛn mꞋiŋg gɛn daayum. Ɔɔ maam se mꞋtɛɗ naka gɛn dom eyo, num maam taaɗ se mꞋtaaɗ te nakŋ kɛn Bubum dooyumo. ");
INSERT INTO kyq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Debm kɛn ɔlumo se, naan̰ utu te maama. Naan̰ ɔŋ ɔn̰um te kalum ki eyo, taa maam se daayum mꞋtɛɗ nakŋ kɛn tɔɔlin̰ naan̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Gɔtn se kɛn jeege jaay booy taar Isa taaɗ bin se, jeege dɛna took aal maakɗe don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Gɔtn se Isa taaɗ Yaudge tun aalga kaal maakɗe don̰ ki se ɔɔ: «Kɛn naase jaay ɔkki taarum maakse ki tɔɔg se, naase aki tɛɗn jee mɛtum kɛn mala mala. ");
INSERT INTO kyq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ute naan̰ se naase aki jeel taar mɛt ki, ɔɔ taar mɛt ki kɛn naase aki jeel se ɓo, asen kɔɔɗn dose maakŋ ɓul ki.» ");
INSERT INTO kyq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Naaɗe tɛrlin̰ ɔɔ: «Naaje se kꞋmɛtjil *Abraamge ɔɔ ɓii kalaŋ naaje kꞋtɛɗ te ɓul nam gam eyo. Naai Ꞌtaaɗjen ɔɔ: naase aki kɔŋ tɛɗn ɓul ey sum se, taa ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: debm jaay tɛɗ nakŋ *kusin̰ se, naan̰ ɔɔp tɛɗga ɓul gɛn kusin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɓulu se naan̰ kɔŋ kiŋg maakŋ ɓee ki gɛn daayum eyo, num goono ɓo debm Ꞌkiŋg maakŋ ɓee ki gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Taa naan̰ se ɓo kɛn Goon Raa jaay ɔɔɗsenga maakŋ ɓul ki num, naase aki kɔŋ dose ɗeer ɗeer. ");
INSERT INTO kyq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Maam mꞋjeele naase se mɛtjil Abraamge. Naɓo naase Ꞌbaate Ꞌkuunki taaruma ɔɔ taa naan̰ se ɓo naase Ꞌje amki tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Maam se mꞋtaaɗsen nakŋ kɛn maam mꞋaako gɔtn Bubum ki. Gaŋ naase se Ꞌtɛɗki nakŋ kɛn naase Ꞌbooykiro gɔtn bubse ki.» ");
INSERT INTO kyq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Naaɗe tɛrlin̰ ɔɔ: «Bubm naaje se, Abraam.» Isa tɛrlɗen ɔɔ: «Kɛn naase jaay gaan Abraamge ɗeer num, naase aki tɛɗn nakgen aan gɔɔ Abraam tɛɗo se. ");
INSERT INTO kyq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Num ɓɔrse naase Ꞌje amki tɔɔlɔ. Taa maam mꞋtaaɗsenga taaɗ taar mɛt ki kɛn maam booyo gɔtn Raa ki. Nakgen bin se Abraam ɔŋ tɛɗin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Num gaŋ naase se Ꞌtɛɗki nakgen kɛn bubse lee tɛɗa.» Naaɗe tɛrlin̰ ɔɔ: «Naaje se kꞋgaan bumige eyo. Naaje jꞋɔk Bubu kalaŋ sum, ɔɔ Bubm naaje se, Raa!» ");
INSERT INTO kyq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isa ɗeekɗen ɔɔ: «Kɛn Raa jaay Bubse num kaaɗn naane, naase amki jea. Maam mꞋiin̰o gɔtn Raa ki ɔɔ mꞋɓaaɗo kic ɓo taa naan̰a: maam se mꞋɓaaɗo gɛn dom eyo, num naan̰ ɓo debm kɛn ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gɛn ɗi naase Ꞌbooy ɔkki taarum ey se? Taa taar maam mꞋtaaɗsen se naase aasin̰ki gɛn booy kɔkin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bubm naase se, naan̰ Bubm sitange. Ɔɔ naase Ꞌjeki tɛɗn nakŋ kɛn bubse maakin̰ jea. Do dɔkin̰ kic ɓo, naan̰ ɓo debm tɛɛso gɛn tɔɔl jeege. Ɔɔ naan̰ se taaɗ taar mɛt ki eyo, taa nakŋ mɛt ki se gɔtn naan̰ ki gɔtɔ. Kɛn naan̰ baaga taaɗn taar‑kɔɔɓɔ se taargen se naan̰ uun don̰ ki ɓo taaɗa, taa naan̰ se debm taar‑kɔɔɓɔ ɔɔ bubm jee taar‑kɔɔɓge. ");
INSERT INTO kyq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Num gaŋ maam se mꞋtaaɗsen taar mɛt ki. Taa naan̰ se ɓo naase Ꞌbaate Ꞌtookki taaruma. ");
INSERT INTO kyq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Maakse ki se naŋa jaay am kɔŋ taaɗn kusin̰ kɛn maam tɛɗa ɔɔ kɛn maam mꞋtaaɗ taar mɛt ki num, naase Ꞌbaate kuunki taarum se gɛn ɗi? ");
INSERT INTO kyq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Debm gɛn Raa se, booy uun taar Raa. Num naase se, jee Raage eyo, taa naan̰ se ɓo naase Ꞌbaate Ꞌbooyki taaruma.» ");
INSERT INTO kyq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Gɔtn se magal Yaudge taaɗ Isa ki ɔɔ: «Kɛn kꞋɗeek jꞋɔɔ naai kɔɗ *Samari ɔɔ debm sitan se, taarje mɛt ki.» ");
INSERT INTO kyq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Gaŋ Isa tɛrlɗen ɔɔ: «Maam se debm sitan eyo. Num maam se *mꞋnook Bubuma, gaŋ naase aalumki maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Maam se mꞋje jeege ɓo am nook eyo, num deb kuuy ɓo je jeege am nooko, naan̰ ɓo debm utu Ꞌkɔjn̰ bɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ꞋBooyki bɛɛ mꞋasen taaɗa: debm jaay booy uun taar maam se, mɔɔtn naan̰ se Ꞌkɔŋ kooy eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Gɔtn se, magal Yaudge ɗeekin̰ ɔɔ: «Ɓɔrse naaje kꞋjeeliga naai se debm sitan! Ey num Abraam te jee taaɗ taar teeco taar Raa ki kɛn do dɔkin̰ se kic ɓo ooyga, gaŋ naai Ꞌtaaɗ ɔɔ debm jaay booy uunga taar naai num, mɔɔtn Ꞌkɔŋ kooy eyo. ");
INSERT INTO kyq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bin se bubjen Abraam kɛn ooyga se naai magal cirin̰ la? Ey num jee taaɗ taar teeco taar Raa ki se kic ɓo ooyga ɔɔ naai magal roi bin se Ꞌje kaasn te naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isa tɛrlɗen ɔɔ: «Kɛn maam ɓo mꞋnook rom mala sum num, nookŋ ro maam se nakŋ cɛrɛ. Kɛn nookum maam se, Bubuma, ɔɔ naan̰ ɓo kɛn naase Ꞌtaaɗki ɔɔki naan̰ ɓo Raase se. ");
INSERT INTO kyq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gaŋ naase Ꞌjeel ɔkin̰ki eyo ɔɔ maam se mꞋjeel mꞋɔkin̰ mala mala. Kɛn maam jaay mꞋtaaɗ mꞋɔɔ mꞋjeel mꞋɔkin̰ ey se, mꞋtɛɗn debm taar‑kɔɔɓɔ aan gɔɔ naase kici. Num maam se mꞋjeel mꞋɔkin̰a ɔɔ mꞋɔk taarin̰ se maakum ki. ");
INSERT INTO kyq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bubse Abraam se maakin̰ raapo ɔɔ naan̰ aak kaam ɓiin mꞋano Ꞌɓaa do naaŋ ki. Kɛn naan̰ jaay aak naan̰ se sum se, naan̰ maakin̰ raap dɛn aak eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Do taar kɛn naan̰ taaɗ se magal Yaudge ɗeekin̰ ɔɔ: «Naai kɛn ɓaari si‑mii kic aas te ey sum ɓo aakga Abraam ne?» ");
INSERT INTO kyq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isa tɛrlɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: kaaɗ kɛn jꞋooj te Abraam ey se, maam mꞋutu tap.» ");
INSERT INTO kyq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gɔtn se naaɗe tɔs koa je an̰ tundu, naɓo naan̰ ɛnd iig daan jeege tu ɔɔ iin̰ teec daan bɔɔr *Ɓee Raa ki se naatn. ");
INSERT INTO kyq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ɓii kalaŋ Isa deel deel se, aak gaaba kalaŋ bin se jꞋoojin̰ ɓo kaam‑tɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gɔtn se jee mɛtin̰ ki tɔnd mɛtin̰ ɔɔ: «Debm dooyje, kɛn tuj *Raa ki jaay ɔl gaabm se jꞋoojin̰ kaam‑tɔɔkɔ se, naan̰ mala lɔɓu bubin̰ te kon̰ lɛ?» ");
INSERT INTO kyq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isa tɛrlɗen ɔɔ: «Kɛn ɔl jaay kꞋjꞋoojin̰ kaam‑tɔɔkɔ se, taa *kusin̰ kon̰ te bubin̰ eyo, ɔɔ gɛn naan̰ mal eyo. Num ute naan̰ se, Raa ɓo Ꞌje taaɗn naabin̰ jeege tu! ");
INSERT INTO kyq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kɛn kaaɗa jaay utu se, bɛɛki se, kꞋtɛɗki naabm gɛn debm ɔlumo. Ey num kɛn nɔɔrɔ jaay aanga num, nam Ꞌkɔŋ tɛɗn naab ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kaaɗ kɛn maam mꞋutu do naaŋ ki ɓɔrt se, maam ɓo gɔtn wɔɔr gɛn jee do naaŋ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kɛn Isa jaay taaɗ naŋ taarin̰ se, tup ɓoorin̰ naaŋ ki, deepin̰ te naaŋa ɔɔ uun ɔtin̰sin̰ kaam gaab kɛn kaam‑tɔɔkɔ se. ");
INSERT INTO kyq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ɔɔ ɗeekin̰ ɔɔ: «Ɓaa tug kaami maakŋ gɔɔ kɛn ɔk maane ɔɔ gɔɔ se ɓo kɛn kꞋdaŋin̰ Siloam se.» Siloam se je ɗeekŋ ɔɔ: jꞋɔlin̰ga. Gɔtn se debm kaam‑tɔɔkɔ iin̰ ɓaa tug kaamin̰a ɔɔ kɛn naan̰ tɛrlo tɛrl se, naan̰ aak kaaka. ");
INSERT INTO kyq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jee do daamboogin̰ge ute jee jeelin̰ do dɔkin̰a jaay aakin̰o naan̰ lɛ, baayo baay se ɗeek ɔɔ: «Kɛse ɓo debm kaam‑tɔɔkŋ kɛn iŋg lɛ baayo se ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jee mɛtin̰ge ɗeek ɔɔ: «Kɛse ɓo naan̰a.» Kɛngen kuuy ɗeek ɔɔ: «Gɔtɔ! Kɛse naan̰ eyo. Nam ɓo tecin̰ tece.» Gaŋ gaabm kaam‑tɔɔkɔ se taaɗɗen ɔɔ: «Kɛse maam mala.» ");
INSERT INTO kyq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Gɔtn se naaɗe tɔnd mɛtin̰ ɔɔ: «Tɛɗ ɔɔ ɗi jaay kaami ɔɔɗ aak se?» ");
INSERT INTO kyq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naan̰ tɛrlɗen ɔɔ: «Gaabm kꞋdaŋin̰ Isa se ɓo deep ɓoorin̰ te naaŋa ɔɔ ɔtumsin̰ kaamum ki ɔɔ ɗeekum ɔɔ: ‹ꞋƁaa tug kaami maakŋ Siloam ki se.› Gɔtn se ɓo maam mꞋiin̰ ɓaa tug kaamuma ɔɔ kaamum ɔɔɗ aaka.» ");
INSERT INTO kyq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Naaɗe tɔnd mɛtin̰ ɔɔ: «Gaabm se utu gay?» Naan̰ tɛrlɗen ɔɔ: «Maam jeel gɔtin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gɔtn se jꞋɔk kꞋɓaan te gaabm, kɛn iŋgo kaam‑tɔɔkɔ se, gɔtn Parizige tu. ");
INSERT INTO kyq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gaŋ ɓii kɛn Isa deep naaŋa ute ɓoorin̰ jaay ɔt kaam gaab kɛn debm kaam‑tɔɔkɔ ɔɔ kaamin̰ ɔɔɗ aak se, ɓiin se *ɓii sebit. ");
INSERT INTO kyq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Taa naan̰ se ɓo Parizige kic tɔnd mɛtin̰ ɔɔ: «Tɛɗ ɔɔ ɗi jaay kaami ɔɔɗ aak se?» Naan̰ tɛrlɗen ɔɔ: «Gaabm kɛn kꞋdaŋin̰ Isa se ɓo, deep ɓoorin̰ ute naaŋa ɔɔ ɔtum kaamum ki ɔɔ mꞋɓaa mꞋtug kaamuma ɔɔ kaamum ɔɔɗ aaka.» ");
INSERT INTO kyq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Maakŋ Parizige tu se jee mɛtin̰ge ɗeek ɔɔ: «Gaabm se debm Raa eyo. Taa ɓii sebit kic ɓo naan̰ aalin̰ maak ki eyo.» Gaŋ jee kuuy ɗeek ɔɔ: «Debm *kusin̰ naan Raa ki sum ɓo, Ꞌkɔŋ tɛɗn nakŋ‑kɔɔɓgen deel do bin ne?» Gɔtn se taarɗe ɓaa ɔk mɛtn naap eyo. ");
INSERT INTO kyq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Gɔtn se tɛr naaɗe tɔnd mɛtn gaabm iŋgo kaam‑tɔɔkɔ se daala ɔɔ: «Maak‑saapm naai ki num, gaabm ɔɔɗio kaami se, naai ɔɔ ɗi?» Naan̰ tɛrlɗen ɔɔ: «Naan̰ se debm taaɗ taar teeco taar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gaŋ magal Yaudge se baate tooko kɛn gaabm se jaay jꞋoojin̰ ɓo kaam‑tɔɔkɔ ɔɔ ɓɔrse kaamin̰ ɔɔɗ aakga kaak se; taa naan̰ se ɓo, naaɗe daŋo kon̰ te bubin̰ se. ");
INSERT INTO kyq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Gɔtn se naaɗe tɔnd mɛtɗe ɔɔ: «Gaabm se ɓo kɛse goonsen ɔɔki oojin̰ki kaam‑tɔɔkɔ se ne? Ɔɔ ɓɔrse Ꞌtɛɗ ɔɔ ɗi jaay kaamin̰ ɔɔɗ aak se?» ");
INSERT INTO kyq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bubin̰ ute kon̰ tɛrlɗen ɔɔ: «Kɛse goonje mala. Naaje se ɗeere jꞋoojin̰ ɓo kaam‑tɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gaŋ tɛɗ ɔɔ ɗi jaay kaamin̰ ɔɔɗ aak se, naaje jꞋɔnd eyo ɔɔ nam nam ɔɔɗin̰ kaamin̰ se lɛ, naaje kꞋjeelin̰ eyo. Naan̰ lɛ debm magala, Ꞌtɔndki mɛtin̰a naan̰ mala asen taaɗn mɛtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kɛn ɔl kon̰ ute bubin̰ jaay taaɗ bin se, taa naaɗe ɓeer ɓeer magal Yaudge tu. Taa magal Yaudge se dɔɔkga dɔɔk taarɗe ɔɔ debm kɛn jaay taaɗga ɔɔ: «Isa ɓo *al‑Masi se» naaɗe an̰ tuurin̰ maakŋ *ɓee kɛn Yaudge lee tusn maak ki se naatn. ");
INSERT INTO kyq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Taa naan̰ se ɓo kon̰ te bubin̰ ɗeek ɔɔ: «Naan̰ lɛ debm magala, tɔndki mɛtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tɛr Parizige se daŋo gaabm kɛn iŋgo kaam‑tɔɔkɔ se, daala, ɗeekin̰ ɔɔ: «Naan Raa ki se, naai taaɗ taar mɛt ki. Gaabm se lɛ naaje kꞋjeelin̰ naan̰ se debm kusin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naan̰ tɛrlɗen ɔɔ: «Kɛn gaabm se ɓo debm kusin̰a, lɔ debm kusin̰ eyo, maam jeel eyo. Nakŋ maam jeel se, maam se jꞋoojum kaam‑tɔɔkɔ ɔɔ ɓɔrse kaamum ɔɔɗ aakga.» ");
INSERT INTO kyq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naaɗe taaɗ gaab kɛn se ɔɔ: «Naan̰ tap ɓo tɛɗi ɔɔ ɗi? Ɔɔ kaami se naan̰ tɛɗin̰ ɔɔ ɗi jaay ɔɔɗ aak se?» ");
INSERT INTO kyq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naan̰ tɛrlɗen ɔɔ: «Taar se maam taaɗsenga taaɗ mɛtin̰a. Naɓo naase mala, Ꞌbaate Ꞌtookki taar se! ꞋJeki mꞋasen taaɗ mɛtin̰ daal se gɛn ɗi? Lɔ naase Ꞌje aki tɛɗn jee mɛtin̰ ki kic lɛ?» ");
INSERT INTO kyq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gɔtn se Parizige baagin̰ naaja ɗeekin̰ ɔɔ: «Naai ɓo mɛtn gaabm se ey num! Naaje se kꞋjee mɛtn *Musa ki. ");
INSERT INTO kyq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Naaje kꞋjeel se Raa se taaɗo Musa ki. Num gaŋ naan̰ se iin̰o gɔtn gay gay se, naaje kꞋjeel eyo!» ");
INSERT INTO kyq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gɔtn se gaabm iŋgo kaam‑tɔɔkɔ se tɛrlɗen ɔɔ: «Kɛn naase jaay ɔɔki Ꞌjeelki gɔtn naan̰ iin̰o ey se taar se deel doa! Ey num gaabm se naan̰ ɓo debm ɔɔɗumo kaamuma. ");
INSERT INTO kyq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Naaje kꞋjeelki Raa se, booy keem nɔɔ jee kusin̰ge eyo. Num gaŋ Raa se booy keem nɔɔ debm kɛn aalin̰ maak ki ɔɔ tɛɗ nakŋ kɛn Raa maakin̰ jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɓii kalaŋ jaay kꞋbooy jꞋɔɔ nam ɔɔɗga kaam debm jꞋoojin̰ ɓo kaam‑tɔɔkɔ se gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kɛn gaabm se jaay debm Raa ey se, naan̰ Ꞌkɔŋ tɛɗn ɗim eyo!» ");
INSERT INTO kyq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Naaɗe tɛrlin̰ ɔɔ: «Naai ɓo jꞋooji maakŋ kusin̰ ki tappi ɔɔ gaŋ tɛr Ꞌje ajen dooy naaje ne?» Gɔtn se naaɗe tuur ɔɔɗin̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kɛn Isa jaay booy ɔɔ naaɗe tuurin̰ga naatn se, gɔtn se naan̰ ɓaa je ɔŋin̰a ɔɔ ɗeekin̰ ɔɔ: «*Goon Deba se, naai aal maaki don̰ ki la?» ");
INSERT INTO kyq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Gaabm se tɛrlin̰ ɔɔ: «Naka, Ꞌtaaɗum tu naan̰ naŋa jaay maam mꞋkaal maakum don̰ ki se?» ");
INSERT INTO kyq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isa ɗeekin̰ ɔɔ: «Aaka! Debm kɛn naai aakin̰ ɗaar naani ki jaay taaɗi se, kɛse ɓo naan̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Gaabm se ɗeek ɔɔ: «Mɛluma, maam mꞋaalga maakum doi ki.» Gɔtn se naan̰ no naaŋ ki ɔɔ ɛrg naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Gɔtn se Isa ɗeek ɔɔ: «Maam mꞋɓaaɗo do naaŋ ki se taa kɔjn̰ bɔɔrɔ, taa jee kaam‑tɔɔkge se kaamɗe kɔɔɗn kaaka, ɔɔ jeegen kaamɗe utu aak kaak se lɛ utu Ꞌtɛɗn jee kaam‑tɔɔkge.» ");
INSERT INTO kyq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parizigen utu te naan̰ se, kɛn naaɗe jaay booy taar ese se ɗeekin̰ ɔɔ: «Kɛn bin se naaje kic kꞋjee kaam‑tɔɔkge la?» ");
INSERT INTO kyq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isa tɛrlɗen ɔɔ: «Kɛn naase jaay Ꞌtɛɗkiga tɛɗ jee kaam‑tɔɔkge num, kaaɗn naane naase aki tɛɗn jee kusin̰ge eyo. Num gaŋ ɓɔrse naase Ꞌɗeekki ɔɔki: ‹Naaje se jee kaamje aak kaaka.› Taa naan̰ se ɓo naase utu iŋgki maakŋ kusin̰se ki se.» ");
INSERT INTO kyq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tɛr Isa taaɗɗen ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: debm ɛnd tɔrɗn baatge tu jaay aal te taa ɗoob eyo, gaaŋ aal gɔt kuuy se, naan̰ se debm ɓoogo ɔɔ debm tujn̰ jeege. ");
INSERT INTO kyq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Num gaŋ debm aal te taa ɗoobo se, naan̰ se ɓo debm gaam baatge. ");
INSERT INTO kyq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɔɔ debm kɛn iŋg bɔɔb taa ɗoobo se, ɔɔɗin̰ kaam taara ɔɔ baatge se booy mindin̰a. Ɔɔ baatn naan̰ge mala se, naan̰ daŋɗe te roɗe ɔɔ ɔɔɗ teecn̰ɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kɛn naan̰ jaay ɔɔɗ teecn̰ɗega naatn se, naan̰ lee naanɗe ki, ɔɔ naaɗe ɔk mɛtin̰a taa naaɗe booy jeel mindin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Num naaɗe se kɔŋ kɔkŋ mɛtn nam kuuy eyo. Kɛn naaɗe booyga mindin̰ kic ɓo aan̰in̰ kaan̰a, taa deb kuuy se naaɗe booy jeel mindin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isa se taaɗɗen te kaal naagŋ taara, num gaŋ jee se booy ɔk mɛtn taar kɛn naan̰ taaɗɗen se eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tɛr Isa taaɗɗen daala ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: maam se ɓo aan gɔɔ mꞋtaa ɗoobm baatge. ");
INSERT INTO kyq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jeegen ɓaaɗo paac deet naanum ki se, naaɗe se jee ɓoogge ɔɔ jee tujn̰ jeege, naɓo baatge se took te taarɗe eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɔɔ maam ɓo aan gɔɔ mꞋtaa ɗoobo. Kɛn debm jaay ɛnd te ɗoobm maam se, naan̰ Ꞌkɔŋ kaaja. Naan̰ kɔŋ kɛndɛ ɔɔ teecn̰ ɓaa gaam te maraadin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Debm ɓoogo ɓaaɗo se, gɛn ɓoogo, gɛn tɔɔlɔ, gɛn kutu. Num gaŋ maam mꞋɓaaɗo se, taa jeege Ꞌkɔŋ kaaja ɔɔ Ꞌkɔŋ kaajn̰ gɛn taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Maam se mꞋdebm gaam bɛɛ: debm gaam bɛɛ kɛn utu kutn kon̰a taa baatin̰ge. ");
INSERT INTO kyq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ɔɔ debm kɛn gaam gɛn gurs sum se, naan̰ se mɛl baatge eyo ɔɔ baatge se lɛ gɛn naan̰ eyo. Kɛn aakga k‑sogsogi utu ɓaaɗo se, naan̰ an̰ rɛsn te baatge. Ɔɔ k‑sogsogi se ɓaaɗo ooc baatge ɔɔ wɔɔkɗe naatn. ");
INSERT INTO kyq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Taa naan̰ lɛ tɛɗ naabm gɛn gurs sum, ɔlin̰ ɗim te baatge eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Num maam se mꞋdebm gaam bɛɛ, maam mꞋjeel baatumge ɔɔ baatumge kic ɓo jeelum maama ");
INSERT INTO kyq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","aan gɔɔ Bubum jeeluma ɔɔ maam jeelin̰ naan̰ se, maam mꞋutu kutn koma taa baatumge. ");
INSERT INTO kyq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ɔɔ maam mꞋɔk baatgen kuuy kɛn te naatn kici. Naaɗe se kic ɓo mꞋutu mꞋaɗeno kɔgŋ ɓaao. Naaɗe se kic utu Ꞌbooy jeel minduma. Bin se naaɗe utu tum tɛɗn dɔɔl baatgen kalaŋ ɔɔ debm gaamɗe kic ɓo Ꞌtɛɗn kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bu se jema taa maam mꞋutu mꞋkɛɗn koma ɔɔ tɛɗga num maam mꞋutu mꞋduru. ");
INSERT INTO kyq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nam nam jaay am kɔɔɗn kɔmb taa tɔɔgɔ se gɔtɔ. Maam mala ɓo mꞋkɛɗn koma taa maam se mꞋɔk tɔɔgɔ kɛn mꞋje lɛ mꞋkɛɗn koma ɔɔ mꞋɔk tɔɔgɔ kɛn mꞋutu mꞋduru. Kɛse ɓo nakŋ kɛn Bubum taaɗumo ɔɔ mꞋtɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gɔtn se Yaudge jaay booy taar Isa taaɗ bin se, taarɗe ɓaa ɔk mɛtn naap ey daala. ");
INSERT INTO kyq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Maakɗe ki se, jee dɛn taaɗ ɔɔ: «Naan̰ lɛ debm sitan ɔɔ do lɛ tɛɗga gɛn naan̰ eyo. Num iŋg Ꞌbooyki taarin̰ se gɛn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gaŋ jee mɛtin̰ge ɗeek ɔɔ: «Debm sitan Ꞌkɔŋ taaɗn taargen bin eyo; ɔɔ sitan se Ꞌkɔŋ tɔɔɗn kaam jee kaam‑tɔɔkge la?» ");
INSERT INTO kyq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kaaɗ kɛn se kaaɗn kuul ki, ɔɔ ɓii kɛn se Jeruzalɛm ki Yaudge tɛɗ tɛɗ maak‑raapɗe gɛn ɓii kɛn naaɗe ɗaapo *Ɓee Raa tɛɗo salal. ");
INSERT INTO kyq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gɔtn se daan bɔɔr Ɓee Raa ki mɛtn daabm kɛn kꞋdaŋin̰ daabm Salomon se, Isa lee ɓaa kaam ara kaam ara. ");
INSERT INTO kyq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yaudge ɓaaɗo ɔl gurugin̰a ɗeekin̰ ɔɔ: «Naaje tap ɓo jꞋai booy bini nuŋ ki jaay naai ajesin̰ taaɗn tal se? Kɛn naai ɓo al‑Masi lɛ, Ꞌtaaɗjesin̰a!» ");
INSERT INTO kyq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isa tɛrlɗen ɔɔ: «Ey num maam mꞋtaaɗsenga, naɓo naase Ꞌbaate Ꞌtookki taaruma. Nakgen maam mꞋtɛɗ te ro Bubum paac se kic ɓo, taaɗ saaɗn maama. ");
INSERT INTO kyq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gaŋ naase Ꞌbaate tookki taarum se, taa naase se baatn maamge eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baatn maamge se booy jeel minduma, maam jeelɗe ɔɔ naaɗe se ɔk mɛtuma. ");
INSERT INTO kyq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ɔɔ maam mꞋaɗen kɛɗn *kaajn̰ gɛn daayum. Ɔɔ naaɗe se Ꞌkɔŋ kut eyo ɔɔ nam kuuy aɗen kɔŋ kujn̰ jim ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bubum kɛn ɛɗumɗeno se naan̰ magal do nakge tu paac, nam Ꞌkɔŋ kujn̰ ne ɗim jin̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Maam te Bubum se, naaje kꞋkalaŋ.» ");
INSERT INTO kyq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kɛn Yaudge jaay booy taar se, naaɗe tɔso ko daala gɛn tund tɔɔlin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Gaŋ tɛr Isa taaɗɗen ɔɔ: «Nakgen jiga sum se, maam mꞋtɛɗga dɛna te ro Bubuma ɔɔ naase aakkiga te kaamse. Num taa nakŋ kɛn gay jaay naase je amki tund tɔɔl se?» ");
INSERT INTO kyq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yaudge tɛrlin̰ ɔɔ: «Taa nakŋ jigan naai tɛɗ se ɓo, naaje kꞋje jꞋai tund tɔɔl eyo. Num gaŋ naai ɓo naaj *Raa, taa naai debkilimi sum ɓo Ꞌtɛɗ roi aan gɔɔ Raa.» ");
INSERT INTO kyq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isa tɛrlɗen ɔɔ: «Maakŋ *Ko Taar Raa naase ki se, taar se kꞋraaŋin̰ga raaŋa jꞋɔɔ: Naase se raage.» ");
INSERT INTO kyq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","«ꞋBooyki, Raa jaay daŋ raage, jeegen kɛn naan̰ taaɗɗen taarin̰ se. Bin se, kꞋjeelki taar Raa kꞋraaŋin̰ga raaŋ se nam an̰ kɔŋ tɔɔl eyo. ");
INSERT INTO kyq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gaŋ maam kɛn Bu mala ɓo bɛɛr ɔɔɗumo ɔɔ ɔlumo do naaŋ ki, taa maam mꞋtaaɗga taaɗ mꞋɔɔ maam Goon Raa sum ɓo, naase ɔɔki maam mꞋnaaj naaj Raa. ");
INSERT INTO kyq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kɛn maam jaay mꞋtɛɗn naabm gɛn Bubum ey num, ɔn̰te Ꞌkaalki maakse dom ki. ");
INSERT INTO kyq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Num kɛn naabm maam mꞋtɛɗ se jaay gɛn Bubum num, kɛn naase Ꞌbaate Ꞌkaalki maakse do maam ki kic num, naase aalki maakse do naab kɛn maam mꞋtɛɗ se. Ute naan̰ se naase aki kɔŋ jeel Bubum se, utu te maama, ɔɔ maam mꞋiŋg te naan̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gɔtn se magal Yaudge iin̰ daala, je an̰ kɔkɔ, gaŋ naan̰ iik uj jiɗe ki. ");
INSERT INTO kyq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Naan̰ ɔk tɛrl ɓaa iŋg do ool gɛn Jordan kɛn kaam naane, gɔtn se ɓo kɛn Jan lee *batizno jeege. ");
INSERT INTO kyq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gɔtn se jeege dɛna ɓaaɗo ɔŋin̰a, naaɗe ɗeek ɔɔ: «Ɗeere, Jan‑Batist ɔŋ tɛɗ te nakŋ‑kɔɔɓm gam eyo, num gaŋ taargen paacn̰ naan̰ taaɗ ro gaab kɛn se, kalaŋ kic ooc te naaŋ ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gɔtn se jeege dɛna took aal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Gaaba kalaŋ kꞋdaŋin̰ Lazar, naan̰ se gɛnaa Mari te gɛn Mart ɔɔ naaɗe se tiŋg Betani ki. Mari ese ɓo kɛn ɔtɔ uubm oot koot jɛ Mɛlje Isa ki, ɔɔ ɔtin̰sin̰ te bɛɛkin̰a. Gaŋ ɓii kalaŋ gɛnaan̰ Lazar se ooc kɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gɛnaan̰gen mɛndge se ɔl deba ɓaa taaɗ Isa ki ɔɔ: «Mɛlje ɓɛrɛ, debm naai Ꞌjen̰ se oocga kɔɔn̰ɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kɛn Isa jaay booy taar se, naan̰ ɗeek ɔɔ: «Kɔɔn̰ Lazar se an̰ kɔŋ tɔɔl eyo, num naan̰ se utu Ꞌtaaɗn nookŋ *Raa. Ɔɔ ute kɔɔn̰ Lazar se, Goon Raa *nookin̰ ute Ꞌkeeme.» ");
INSERT INTO kyq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ey num Mart te gɛnaan̰ Mari ɔɔ Lazar se, Isa jeɗe aak eyo. ");
INSERT INTO kyq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gaŋ gɔtn ese kɛn Isa jaay booy ɔɔ Lazar kɔɔn̰ɔ se, naan̰ ɔɔp tɛɗ ɓii dio gɔt kɛn kꞋɓaaɗo jꞋɔŋin̰ se. ");
INSERT INTO kyq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kɛn ɓii di jaay deel se, naan̰ ɗeek jee mɛtin̰ ki ɔɔ: «JꞋiin̰ kꞋtɛrl kꞋɓaaki taa naaŋ Jude ki.» ");
INSERT INTO kyq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gɔtn se jee mɛtin̰ ki ɗeekin̰ ɔɔ: «Debm dooyje, gɔɔr gɔɔr ese sum ɓo Yaudge je ai tund tɔɔli te koa se ɓo, naai Ꞌje tɛrl ɓaa gɔtn naane daal ne?» ");
INSERT INTO kyq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isa tɛrlɗen ɔɔ: «Gɔtɔ jaay iipga ɔɔ kaaɗa jaay ookga se naan̰ lɛk bini aan tɛgɛr jaay ooc ey la? Taa naan̰ se ɓo debm lee te kaam kaaɗa se naan̰ rɔɔk eyo, taa te kaam kaaɗa se naan̰ aak nakgen do naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Anum debm lee nɔɔr se, naan̰ Ꞌrɔɔkŋ kooco taa gɔtn wɔɔr kɛn an̰ wɔɔr gɔtɔ se gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ tɛr ɗeekɗen ɔɔ: «Ɓɛrɛ, mɛɗjege Lazar se, kaamin̰ ɔkga bia, gaŋ maam mꞋutu mꞋan̰ ɓaa duru.» ");
INSERT INTO kyq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jee mɛtin̰ ki se ɗeekin̰ ɔɔ: «Mɛlje, kɛn naan̰ jaay tooɗga bi se, naan̰ utu Ꞌkɔŋ lapia.» ");
INSERT INTO kyq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ute naan̰ se Isa jeɗen taaɗn ɔɔ Lazar se ooyga. Gaŋ maak‑saapm naaɗe ki se, ɔɔ daan naane Isa taaɗɗen te tooɗn bi aan gɔɔ kɛn jeege lee tooɗ se sum. ");
INSERT INTO kyq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gɔtn se Isa taaɗɗesin̰ tal ɔɔ: «Ɓɛrɛ, Lazar se ooyga. ");
INSERT INTO kyq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Num kɛn Lazar ooy jaay maam gɔtɔ gɔtn naane se, maam maakum‑raapo taa naase. Taa bin se naase aki kaal maakse dom ki paac. Ɓɔrse jꞋiin̰ kꞋɓaa kꞋjꞋɔŋin̰ki.» ");
INSERT INTO kyq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Gɔtn se debm mɛtin̰ kɛn kꞋdaŋin̰ Tɔma ɔɔ ron̰ Tɔma se je ɗeekŋ ɔɔ rɔŋɔ, naan̰ ɗeek jee mɛtn Isa kɛn mɛtin̰ge se ɔɔ: «Naaje kic ɓo jꞋiin̰ kꞋɓaaki te naan̰a jꞋaki ɓaa kooy kalaŋ.» ");
INSERT INTO kyq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kɛn Isa jaay aan se, ɔŋ Lazar ɔkga ɓii sɔɔ maakŋ ɓaaɗ kɛn aan gɔɔ iiɓi se. ");
INSERT INTO kyq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aan gɔɔ Betani se gɔɔr te Jeruzalɛm, daanɗe se ɔk kilɔmɛtir ɓaa ɓaa nakŋ mɔtɔ sum se, ");
INSERT INTO kyq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","taa naan̰ se ɓo, Yaudge dɛna ɓaaɗo taa Ꞌɗaar ro Mari ute Mart ki taa yo gɛnaaɗe. ");
INSERT INTO kyq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kɛn Mart jaay booy ɔɔ Isa utu ɓaaɗo se, naan̰ iin̰ ɓaa ɔŋin̰a, gaŋ Mari se ɔɔp iŋg ɓeene. ");
INSERT INTO kyq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kɛn Mart jaay aan se ɗeek Isa ki ɔɔ: «Mɛluma, kɛn naai jaay utu gɔtn ara ki num, kaaɗn naane gɛnaam Ꞌkooy eyo. ");
INSERT INTO kyq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gaŋ ɓɔrse kɛn naan̰ ooyga kic ɓo maam mꞋjeele nakŋ paacn̰ kɛn naai Ꞌtɔndga mɛta gɔtn Raa ki se, Raa se naan̰ aisin̰ kɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isa ɗeekin̰ ɔɔ: «Gɛnaai se utu Ꞌduru.» ");
INSERT INTO kyq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Gɔtn se Mart tɛrlin̰ ɔɔ: «Mɛluma, maam mꞋjeele ɓiin dunia naŋ jaay jeege utu aɗe dur se, naan̰ kic utu aɗe duru.» ");
INSERT INTO kyq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isa ɗeekin̰ ɔɔ: «Maam ɓo debm dur jeege daan yoge tu ɔɔ kɛn ɛɗ kaaja jeege tu. Debm kɛn jaay aal maakin̰ do maam ki se, ooyga kic ɓo utu Ꞌkɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Debm jaay iŋg ɔɔ aal maakin̰ do maam ki se, naan̰ se mɔɔtn Ꞌkɔŋ kooy eyo. Num do taar kɛn se naai Ꞌtook la?» ");
INSERT INTO kyq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Gɔtn se Mart tɛrlin̰ ɔɔ: «Yɛɛ Mɛluma, maam se mꞋaal maakum doi ki taa naai ɓo *al‑Masi, Goon Raa, kɛn utu aɗe ɓaa do naaŋ ki se.» ");
INSERT INTO kyq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kɛn Mart jaay taaɗ naŋ taarin̰ se, naan̰ iin̰ ɓaa ɔŋ gɛnaan̰ Mari ɔɔ taaɗin̰ naaŋ ki ɔɔ: «Debm dooyje se ɓaaɗoga ɔɔ naan̰ daŋi.» ");
INSERT INTO kyq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kɛn Mari jaay booy taar se, naan̰ naar iin̰ ɓaa gɔtn Isa ki. ");
INSERT INTO kyq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Naan̰ kɛn se Isa ɛnd te Betani ki ey ɓɔrtɔ. Naan̰ utu iŋg kiŋg gɔt kɛn Mart ɔŋin̰o se. ");
INSERT INTO kyq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gaŋ Yaudge se iŋg kiŋg ɓeene ute Mari, naaɗe iŋg sɛlin̰ sɛlɛ. Kɛn naaɗe jaay aakin̰ naan̰ naar iin̰ teec se, naaɗe ɔk mɛtin̰a. Taa naaɗe saap ɔɔ: «Kaaɗn naane naan̰ ɓaa ɓaa taa ɓaaɗ ki se, gɛn ɓaa keeme.» ");
INSERT INTO kyq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kɛn Mari jaay aan ɔŋ Isa gɔt kɛn naan̰ iŋg se, jaay naan̰ aakin̰ se, ooc mɛtn jɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: «Mɛluma, kɛn naai jaay utu gɔtn ara ki num, kaaɗn naane gɛnaam se Ꞌkooy eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kɛn Isa aak Mari te Yaudgen ɔko mɛtin̰a jaay baag keeme se, gɔtn se Isa maakin̰ ɔŋ ɗaar eyo, gɔtn se maakin̰ tuju. ");
INSERT INTO kyq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naan̰ tɔnd mɛtɗe ɔɔ: «Naase aalin̰kiga kaam gay?» Naaɗe tɛrlin̰ ɔɔ: «Mɛlje, Ꞌɓaaɗo kaaka.» ");
INSERT INTO kyq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Gɔtn se Isa eeme. ");
INSERT INTO kyq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gaŋ Yaudge taaɗ ɔɔ: «Aakki tu! Lazar se naan̰ jen̰ dɛn aak eyo!» ");
INSERT INTO kyq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Anum maakɗe ki se, jee kandum ɗeek ɔɔ: «Debm kaam‑tɔɔkɔ kic naan̰ ɔɔɗin̰ kaamin̰a, num Lazar ɓo n̰Ꞌɔŋ gaasin̰ te yo ki ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Gɔtn se tɛr Isa maakin̰ ɔŋ ɗaar ey daala, naan̰ iin̰ ɓaa taa ɓaaɗ ki. Ɓaaɗn se aan gɔɔ iiɓi ɔɔ taarin̰ se naaɗe gaasin̰ te koa. ");
INSERT INTO kyq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Gɔtn se Isa ɗeekɗen ɔɔ: «Ko taar ki se ɔɔɗin̰ki naata.» Mart, gɛnaa debm ooy se, ɗeekin̰ ɔɔ: «Mɛluma, naan̰ se ɔkga ɓii sɔɔ maakŋ ɓaaɗ ki; ɓɔrse naan̰ tɛɗn ootga.» ");
INSERT INTO kyq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Gaŋ Isa ɗeekin̰ ɔɔ: «Maam taaɗiga taaɗa mꞋɔɔ kɛn naai jaay aalga maaki do maam ki num naai utu Ꞌkaakŋ *nookŋ Raa ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gɔtn se naaɗe ɔɔɗ und te ko taar ki se naata, Isa uun kaamin̰ raan ɔɔ ɗeek ɔɔ: «Bua, mꞋtɔɔmi taa naai Ꞌbooyumga. ");
INSERT INTO kyq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ɗeere, maam se mꞋjeele daayum nakŋ maam mꞋtɔndga mɛti ɓo, naai Ꞌlee Ꞌbooyum booyo. Anum mꞋtaaɗ se taa jee dɛn gurug aalum se, naaɗe Ꞌjeele naai ɓo ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ: «Lazar Ꞌteeco!» ");
INSERT INTO kyq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Gɔtn ese debm ooyga kooy se teeco, ɔɔ teeco se jin̰ge te jɛn̰ge se kꞋteelin̰ga teel te kala ɔɔ daan kaamin̰ se naaɗe deebin̰ kala. Gɔtn se Isa ɗeek jeege tu ɔɔ: «ꞋTuutin̰ki kalin̰gen ron̰ ki se naata ɔɔ ɔn̰in̰ki naan̰ ɓaa.» ");
INSERT INTO kyq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yaudgen ɓaaɗo ɗaar ro Mari ki se, naaɗe jaay aak nakŋ Isa tɛɗ se, dɛnin̰ took aal maakɗe don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gaŋ jee mɛtin̰ge se ɓaa ɔŋ *Parizige ɔɔ taaɗɗen nakŋ kɛn Isa tɛɗo se. ");
INSERT INTO kyq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu ute Parizige, naaɗen *jee kaakŋ mɛtn taargen Yaudge se paac tuso ɔɔ taaɗ ɔɔ: «Gaabm se jꞋan̰ki tɛɗn ɔɔ ɗi? Naan̰ lɛ tɛɗn nakŋ‑kɔɔɓge dɛna ɔn̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kɛn jaay jꞋɔn̰in̰ te naan̰ se lɛ, jeege paac utu Ꞌtookŋ taar naan̰a. Ɔɔ ɓɛrɛ sɔm *Rɔmɛge se utu aɗe ɓaao ɔɔ utu an tɔɔkŋ te Ɓee Raajege ɔɔ utu an tɛrɛcn̰ te naaŋjege.» ");
INSERT INTO kyq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maakɗe ki se gaaba kalaŋ kꞋdaŋin̰ Kayip. Ɓaar se, naan̰ ɓo magal jee tɛɗn sɛrkɛ Raage tu, naan̰ ɗeek ɔɔ: «Naase se Ꞌjeelki ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Naase Ꞌsaapki kic ɓo ɔŋin̰ki eyo, ey num bɛɛki se, deb kalaŋ ɓo Ꞌkooyo Ꞌkɔn̰ jee dɛna. Bin se naaŋjege se Ꞌkɔŋ tɛrɛcn̰ te magalin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Taa ɓaar se naan̰ ɓo magal jee tɛɗn sɛrkɛ Raage tu, bin se taar naan̰ taaɗ se iin̰o maak‑saapm naan̰ malin̰ ki eyo, gaŋ taar naan̰ taaɗ se, iin̰o gɔtn Raa ki. Ɔɔ taar naan̰ taaɗ se je taaɗn ɔɔ: Isa se utu kooy taa Yaudgen te dɛnin̰, ");
INSERT INTO kyq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ɔɔ naan̰ utu kooy se taa Yaudge kalin̰ ki sum eyo, num gaŋ kooy naan̰ se utu Ꞌtusn gaan Raagen gɔtn ɓaa se paac Ꞌtɛɗn kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ɓii kɛn se sum ɓo, magal Yaudge uun doa taa tɔɔl Isa. ");
INSERT INTO kyq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Taa naan̰ se mɔɔtn Isa baate lee maakŋ Yaudge tu, naan̰ iik tɔk ɓaa maakŋ naaŋ ki kalaŋ bini kꞋdaŋin̰ Epraim, kɛn gɔɔr te kɔɗ‑ɓaara. Gɔtn ese ɓo naan̰ ɓaa iŋg te jee mɛtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jeege dɛna iin̰o taa naaŋge tun kuuy ɔɔ ɓaaɗo Jeruzalɛm ki, gɛn tugŋ ɗaapm roɗe naan Raa ki, taa *laa Paakŋ gɛn Yaudge se ɔɔpga gɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Daan bɔɔr *Ɓee Raa ki se naaɗe lee je Isa ɔɔ gɔtn se naaɗe taaɗ te naapa ɔɔ: «Naase tap ɓo Ꞌsaapin̰ki ɔɔki ɗio? Ɓɛrɛ, ɗaam jaay ey num, Isa se aɗe kɔŋ ɓaa laa ki se eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Taa magal jee tɛɗn sɛrkɛ Raage tu ute Parizige se, taaɗga taaɗ jeege tu ɔɔ: «Debm kɛn jaay jeel gɔtn Isa num, aɗen taaɗn gɔtin̰a taa naaɗe an̰ ɓaa kɔkɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kɛn Isa jaay aan Betani ki gɔtn kɛn naan̰ duro Lazar daan yoge tu se, ɔɔpga ɓii mɛcɛ sum ɓo, Yaudge Ꞌtɛɗn *laa Paak. ");
INSERT INTO kyq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gɔtn se kꞋtɛɗ kɔsɔ taa naan̰a ɔɔ Mart uuno kɔsɔ se, ɓaaɗo tɔndɗesin̰a. Gaŋ maakŋ jeege tun iŋg ɔs kɔs te Isa se, Lazar kic utu maakɗe ki. ");
INSERT INTO kyq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gɔtn se Mari uuno itir aas kaam ɗoocn̰ kurku ɔɔ itir se kꞋdaŋin̰ nard ɔɔ naan̰ se itir salal ɔɔ ɔɔn̰ɔ. Naan̰ jɛɛr itir se do jɛ Isa ki ɔɔ ɔtin̰sin̰ ute bɛɛkin̰a ɔɔ ɓee naaɗe iŋg maak ki se, oot itir itir sum. ");
INSERT INTO kyq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Gɔtn ese maakŋ jee mɛtin̰ ki se, debm kɛn kꞋdaŋin̰ Judas Iskariɔt se, naan̰ ɓo kɛn tɛɗga num utu an̰ kut se, ɗeek ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Bɛɛki se, itir se jaay kꞋdugin̰ga utu tamma kaar‑mɔtɔ ɔɔ gursn se kꞋnigŋ jee daayge tu num bɛɛ ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kɛn Judas jaay taaɗ bin se, taa naan̰ saap ɓo do jee daayge tu eyo, num gaŋ taa naan̰ debm ɓoogo; aan gɔɔ naan̰ debm kɔkŋ gursɗe ɗey se, naan̰ iin̰ga num lee tuun tuun mɛtn gursn ese. ");
INSERT INTO kyq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gɔtn se Isa ɗeek ɔɔ: «Mɛnda se ɔn̰in̰ kaam kalaŋ! Nakŋ naan̰ tɛɗum se kɛse ɓo aasga gɛn ɓii duubuma. ");
INSERT INTO kyq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jee daayge se daayum utu te naase. Num gaŋ maam se, daayum mꞋkɔŋ kiŋg te naase eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kaaɗ kɛn se Yaudge dɛna kɛn booy jaay jꞋɔɔ, ɔɔ Isa utu Betani ki se, naaɗe iin̰ ɓaaɗo. Naaɗe ɓaaɗo se taa Isa sum eyo, num naaɗe ɓaaɗo se taa kaakŋ Lazar kɛn naan̰ durin̰o daan yoge tu se kici. ");
INSERT INTO kyq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gɔtn se *magal jee tɛɗn sɛrkɛ Raage tu uun doa gɛn tɔɔl Lazar kici. ");
INSERT INTO kyq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Taa Lazar se, Yaudge dɛna iin̰ rɛsɗe ɔɔ ɓaaɗo uun taar Isa. ");
INSERT INTO kyq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mɛtbeen̰ki se, jee dɛn ɓaaɗo gɛn tɛɗn *laa Paak se, booy ɔɔ Isa utu ɓaaɗo Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Naaɗe gaaŋo doomo jiɗege tu, ɔɔ teec ɓaaɗo dɔɔɗ Isa. Naaɗe dɔɔɗin̰ se, ɗɔɔb ɔɔy ɔɔ: «Ozaana, *Raa tɛɗn bɛɛn̰ do deb kɛn ɓaaɗo te ro Mɛljege Raa, naan̰ se ɓo Gaar *Israɛlge.» ");
INSERT INTO kyq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isa ɔŋ goon buur gaaba se ook iŋgo do ki, aan gɔɔ taar kɛn kꞋraaŋo do dɔkin̰a kɛn ɗeek ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jee maakŋ gɛgɛr kɛn Sion ki,ɔn̰te Ꞌɓeerki, aakki gaarse ookoga do goon buur kɛn gaaba utu ɓaaɗo. ");
INSERT INTO kyq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nakgen deel mɛtn‑jiki paac se kaaɗ kɛn se, jee mɛtin̰ ki se ɔŋ jeel ɔk te mɛtin̰ eyo. Num gaŋ kɛn Isa Raa *nookin̰ se jaay ɓo, naaɗe saap ɔŋin̰a nakŋ Isa tɛɗ se, taa nakŋ se kꞋraaŋin̰oga raaŋa do dɔkin̰a ɔɔ kɛse ɓo nakgen kɛn jeege tɛɗin̰sin̰ se. ");
INSERT INTO kyq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Anum jee dɛn iŋgo te Isa jaay aako kɛn naan̰ daŋo Lazar maakŋ ɓaaɗ ki jaay Lazar duro daan yoge tu se, naaɗe se ɓo ɓaaɗo ɔɔs maanin̰ jeege tu. ");
INSERT INTO kyq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aan gɔɔ naaɗe booyga booy nakŋ‑kɔɔɓm naan̰ tɛɗo se, taa naan̰ se ɓo jeege teec ɓaaɗo dɔɔɗ Isa. ");
INSERT INTO kyq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Gɔtn se *Parizige baag taaɗn te naapa ɔɔ: «Aakki! Naan̰ se lɛ cirga dojege, ɔɔ ɓɔrse se lɛ, jeege paac ɓaaga mɛtin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɓii *laa Paak ki se, Grɛkgen mɛtin̰ge ɓaaɗo Jeruzalɛm ki gɛn keem Raa. ");
INSERT INTO kyq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Naaɗe se ɓo ɓaaɗo ɔŋ Pilip kɛn iin̰o Betsaida kɛn taa naaŋ Galile ki se ɔɔ naaɗe tɔnd mɛtin̰ ɔɔ: «Naka, naaje se kꞋje kaakŋ Isa.» ");
INSERT INTO kyq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip ɓaa ɔŋ Andre ɔɔ taaɗin̰ ɔɔ naaɗen di se paac ɓaa taaɗ Isa ki. ");
INSERT INTO kyq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isa tɛrlɗen ɔɔ: «Ɓɔrse kaaɗn kɛn *Goon Deba *nookin̰ keem se, aanga. ");
INSERT INTO kyq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ꞋBooyki bɛɛ mꞋasen taaɗa: kaam teen̰e jaay jꞋɔɔcin̰ te ey se, naan̰ iŋg gɔtin̰ ki sum. Num gaŋ kɛn jꞋɔɔcin̰ga num, kaamin̰ se ut naatn, ɔɔ kɛn teeco se ɓaaɗo ooj dɛna. ");
INSERT INTO kyq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Debm je ron̰ se, utu kutn kon̰a ɔɔ debm do naaŋ ki ara jaay je Raa cir ron̰ se, naan̰ se utu Ꞌkɔŋ *kaajn̰ gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Debm jaay je tɛɗn naabm maam se, Ꞌkɔkŋ mɛtuma. Gɔtn maam mꞋutu se, debm tɛɗn naabum se kic Ꞌkiŋg te maama. Kɛn debm jaay tɛɗum naabm maam se, Bubum utu an̰ magala.» ");
INSERT INTO kyq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tɛr Isa taaɗ ɔɔ: «Ɓɔrse maam mꞋiŋg se nirlum aayuma, num gaŋ mꞋtaaɗn mꞋɔɔ ɗi? MꞋtaaɗn mꞋɔɔ: Bua, aajuma gɛn kaaɗn dubar utu Ꞌkaan dom ki se Ꞌsookumsin̰ naatn rom ki bin ne? Gɔtɔ! Maam ɓaaɗo tap ɓo taa naan̰ se. ");
INSERT INTO kyq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bua, *Ꞌnookŋ roi.» Gɔtn se kꞋbooy mindi taaɗ maakŋ raa ki ɔɔ: «Maam se mꞋnookin̰ga ɔɔ mꞋutu mꞋan̰ nookŋ daala.» ");
INSERT INTO kyq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jee dɛn iŋg gɔtn ese jaay booy se, taaɗ ɔɔ: «Kɛse Raa ɓo aata.» Gaŋ jee mɛtin̰ge ɗeek ɔɔ: «Kɛse *kɔɗn Raa gam ɓo taaɗin̰.» ");
INSERT INTO kyq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Gaŋ Isa tɛrl taaɗɗen daala ɔɔ: «Mind taaɗ se taaɗ te maam eyo, anum naan̰ se, taaɗ te naase. ");
INSERT INTO kyq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ɓɔrse kaaɗn kɛn Raa an kɔjn̰ bɔɔrɔ do jeege tun do naaŋ ki se aanga. Ɓiin se ɓo *Ɓubm sitange, naan̰ ɓo Gaar jee kusin̰gen do naaŋ ki se, jꞋan̰ tuurin̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kɛn maam se jaay jꞋuun kꞋɗaarumga raan se, maam mꞋtɛɗn jeege paac aɗe ɓaa gɔtum ki.» ");
INSERT INTO kyq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kɛn naan̰ jaay taaɗ taargen se, naan̰ je taaɗn ɔɔ te ɗoobm gay jaay naan̰ utu Ꞌkooyo. ");
INSERT INTO kyq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jee dɛnge se ɗeekin̰ ɔɔ: «Naaje kꞋbooy maakŋ *Ko Taar kɛn Raa ɛɗo Musa ki se ɔɔ: *al‑Masi se ɓaaɗoga num naan̰ se Ꞌtiŋg gɛn daayum. Anum gɛn ɗi jaay naai taaɗ ɔɔ: *Goon Debm jꞋan̰ tupm tɔɔl ro kaag ki ɔɔ jꞋan̰ kuun ɗaar raan se? Goon Debm ese kɛn gay daala?» ");
INSERT INTO kyq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isa tɛrlɗen ɔɔ: «Gɔtn wɔɔr kɛn lee wɔɔrsen gɔtɔ se, kaaɗin̰ ɔɔpga gɔɔrɔ. Kaaɗ kɛn naan̰ utu se, Ꞌleeki maakŋ gɔt kɛn wɔɔr se, taa bin se gɔtn ɔɔɗ se asen naar kɔkŋ do jise ki eyo. Taa debm lee maakŋ gɔt kɛn ɔɔɗ se lɛ, naan̰ jeel gɔtn naan̰ ɓaan se eyo. ");
INSERT INTO kyq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kaaɗn gɔtn wɔɔr utu se, Ꞌtookki Ꞌleeki utu gɔtn wɔɔr se. Taa bin se naase aki tɛɗn gaan gɔt kɛn wɔɔrɔ.» Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ iin̰ ɔn̰ɗe ɔɔ ɓaa oom gɔtn dɔk te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ute nakŋ‑kɔɔɓgen Isa tɛɗ dɛn naanɗe ki se kic ɓo, Yaudge baate kaal maakɗe don̰ ki rɔk. ");
INSERT INTO kyq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Taa naan̰ se ɓo taar kɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi taaɗno se aanga ɗoobin̰ ki kɛn ɔɔ: Mɛljege Raa, taari naaje jaay kꞋlee kꞋtaaɗ jeege tu se, naŋa took uunga ɔɔ Mɛljege Raa tap ɓo Ꞌtɔɔgin̰ se, naan̰ taaɗga naŋ ki? ");
INSERT INTO kyq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yaudge jaay ɔŋ aal maakɗe do Isa ki ey se, taa Ezayi se taaɗga taaɗ taar ese se kici kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ɗeere, jee se Raa turumɗenga kaamɗege ɔɔ tɛɗɗen naaɗe tɛɗga jee do‑mɔŋgge taa kaamɗe kaakŋ kɔkŋ gɔt eyo ɔɔ biɗe booy kɔkŋ taar eyo ɔɔ ute maakɗe kic naaɗe kɔŋ booy kuun jaay aɗe tɛrl ro maam ki, ey num kaaɗ kɛn naane se, maam Raa mꞋaɗen kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kɛn Ezayi jaay taaɗ bin se, taa naan̰ aakga kaak *nookŋ Isa ɔɔ taargen naan̰ taaɗo se, taaɗ ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ute naan̰ se kic ɓo maakŋ magal Yaudge tu se, jeege dɛna aal maakɗe do Isa ki. Naɓo taa *Parizige se, naaɗe ɔŋ taaɗin̰ tal naan jeege tu eyo, taa naaɗe ɓeer ɔɔ sɔm Parizige aɗen tuur naatn, maakŋ *ɓee kɛn Yaudge lee tusn maak ki se. ");
INSERT INTO kyq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Taa naaɗe je tɔɔm kɛn jikilimge lee tɔɔmɗe se ɓo, bɛɛ cir kɛn Raa ɓo aɗen tɔɔmɔ. ");
INSERT INTO kyq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gaŋ gɔtn se Isa uun mindin̰ raan taaɗ ɔɔ: «Debm jaay aal maakin̰ do maam ki se, naan̰ aal maakin̰ do maam ki sum eyo, num naan̰ se aal maakin̰ do Deb kɛn ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɔɔ debm kɛn aakumga maam se, aakga Debm kɛn ɔlumo se kici. ");
INSERT INTO kyq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Maam se mꞋgɔtn wɔɔr kɛn ɓaaɗo do naaŋ ki se, taa debm jaay aalga maakin̰ do maam ki se, naan̰ Ꞌkɔŋ kiŋg maakŋ gɔt kɛn ɔɔɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kɛn debm jaay booy taaruma ɔɔ ɔkin̰ maakin̰ ki ey se, maam ɓo mꞋan̰ kɔjn̰ bɔɔrɔ don̰ ki eyo. Taa maam mꞋɓaaɗo se, gɛn kɔjn̰ bɔɔrɔ do jeege tun do naaŋ ki eyo, num mꞋɓaaɗo se gɛn kaajn̰ jeegen do naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Debm jaay ɔɔɗ unduma ɔɔ baate tookŋ taarum se, bɔɔrɔ utu koocn̰ don̰ ki. Taa ɓiin dunia an naŋ se, taargen maam mꞋtaaɗin̰ se ɓo utu an̰ kɔjn̰ bɔɔrɔ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Taargen maam taaɗ se, mꞋtɛrɛc te dom eyo. Kɛse Bu kɛn ɔlumo se ɓo ɔlum mꞋtaaɗ taargen se ɔɔ mꞋdooy jeege. ");
INSERT INTO kyq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Maam mꞋjeele taar kɛn naan̰ taaɗumo gɛn tɛɗa se, kɛse ɓo taar kɛn ɛɗ kaaja gɛn daayum. Taar kɛn maam mꞋtaaɗ se, mꞋtaaɗin̰ aan gɔɔ kɛn Bu taaɗumsin̰o.» ");
INSERT INTO kyq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aan gɔɔ ɔɔpga ɓii kalaŋ sum ɓo Yaudge Ꞌtɛɗn *laa Paak se, Isa jeelga kaaɗn kɛn naan̰ Ꞌkiin̰ kɔn̰ do naaŋa an ɓaa gɔtn Bubin̰ ki se aasga. Ɔɔ jeen̰gen do naaŋ ki se daayum naan̰ jeɗen aak eyo. Ɔɔ naan̰ jeɗen ute maakin̰ paac. ");
INSERT INTO kyq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɛn aan kaaɗn kɔs ki jaay naaɗe baag kɔsɔ se, kaaɗ kɛn se *Ɓubm sitange ɛndga kɛnd maakŋ Judas goon Simon Iskariɔt ki, gɔtn se naan̰ saap je ɗoobm an kutn Isa. ");
INSERT INTO kyq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aan gɔɔ Isa se jeel Bu se ɛɗin̰ga nakge paac kaam jin̰a, taa naan̰ iin̰o gɔtn *Raa ki ɔɔ tɛɗga num utu Ꞌtɛrl ɓaa gɔtn Raa ki se, ");
INSERT INTO kyq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","kɛn naaɗe utu ɔs kɔs se Isa iin̰ ɔɔɗ aal kal magalin̰a ɔɔ uun dɔɔk maakin̰ ute kal kɛn kꞋlee kꞋjꞋɔtn jɛ jeege. ");
INSERT INTO kyq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tɛr naan̰ ɔmb maane maakŋ baay ki ɔɔ baag tugŋ jɛ jee mɛtin̰ ki ɔɔ ɔtɗesin̰ te kal kɛn naan̰ uun dɔɔkŋ maakin̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kɛn jaay aan do Simon Piɛr ki se, Simon Piɛr ɗeekin̰ ɔɔ: «Mɛluma, naai ɓo am tugŋ jɛ maam ne?» ");
INSERT INTO kyq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isa tɛrlin̰ ɔɔ: «Nakŋ maam tɛɗ se, ɓɔrse naai Ꞌkɔŋ jeel mɛtin̰ eyo, num gaŋ tɛɗga jaay sɔm naai utu Ꞌjeel kɔkŋ mɛtin̰ bɛɛ.» ");
INSERT INTO kyq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Gɔtn se Simon Piɛr ɗeekin̰ ɔɔ: «Naai ɓo am tugŋ jɛ maama! Gɔtɔ!» Isa tɛrlin̰ ɔɔ: «Kɛn maam jaay mꞋtugi te jɛi ey se, ɗim jaay ai tum te maam se gɔtɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Gɔtn se Simon Piɛr tɛrlin̰ ɔɔ: «Mɛluma, jɛm sum eyo, num tugum jimge ute dom paac kici.» ");
INSERT INTO kyq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isa ɗeekin̰ ɔɔ: «Debm jaay roogga roog se, kɔŋ roogŋ kuuy ey sum kɛn ɔɔpin̰ se Ꞌtugŋ jɛn̰ sum taa debm roogga se ron̰ paac aacga walak ɔɔ naan̰ tɛɗga aak bɛɛ naan Raa ki. Ɓɔrse naase Ꞌtɛɗkiga jee aak bɛɛ naan Raa ki, naɓo Ꞌpaacki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Taa debm kɛn jaay utu an̰ kut se, Isa jeelin̰a. Taa ɗi naan̰ ɗeek ɔɔ: «Naan Raa ki se naase aakki bɛɛ Ꞌpaacki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kɛn Isa jaay tug jɛ jeen̰ge aas se, naan̰ uun uus kal magalin̰a, ɔɔ ɓaaɗo iŋg gɔt kɛn naaɗe iŋg ɔs kɔs se. Gɔtn se naan̰ tɔnd mɛtɗe ɔɔ: «Nakŋ maam mꞋtɛɗsen se, naase Ꞌjeel ɔkki mɛtin̰ ɗey la? ");
INSERT INTO kyq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kɛn naase jaay Ꞌdaŋumki ɔɔki: ‹Debm Dooyje› ɔɔ ‹Mɛlje› se, taarse se mɛt ki. Ɗeere, maam ɓo mꞋDebm Dooyse ɔɔ Mɛlse. ");
INSERT INTO kyq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kɛn maam Mɛlse ɔɔ mꞋDebm Dooyse jaay ɓo mꞋtugsen jɛsege se, bɛɛki se, naase kic Ꞌlee Ꞌtugki jɛ naapge bin kici. ");
INSERT INTO kyq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kɛn maam jaay mꞋtɛɗsen naan̰ se, taa naase kic ɓo aki kɔŋ tɛɗn aan gɔɔ gɛn maam mꞋtɛɗseno se kici. ");
INSERT INTO kyq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ꞋBooyki bɛɛ mꞋasen taaɗa: debm tɛɗn naaba gɔtn deb ki se, naan̰ se magal cir debm kɛn naan̰ lee tɛɗin̰ naaba eyo ɔɔ debm aan̰ naaba deb ki se, naan̰ magal cir debm kɛn lee ɔlin̰ naaba eyo. ");
INSERT INTO kyq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nakgen se, ɓɔrse naase Ꞌjeel ɔkkiga mɛtin̰a kɛn naase jaay Ꞌtɛɗin̰kiga naan̰ se num, maakse Ꞌraapo. ");
INSERT INTO kyq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Taar kɛn maam mꞋtaaɗse, mꞋtaaɗ te naase paacki eyo, taa jeegen kɛn maam ɓo mꞋbɛɛr mꞋtɔɔɗɗe se, maam jeelɗe. Gaŋ taar kɛn kꞋraaŋin̰ do dɔkin̰ se, aanga ɗoobin̰ ki kɛn ɔɔ: Debm kɛn lee ɔs mappa te maam se, Ꞌtɛrlumga naaga. ");
INSERT INTO kyq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«Kɔr nakŋ se jaay ute kaan se, maam mꞋtaaɗsesin̰ ɓɔrse. Bin se nakŋ se jaay aanga kic num, naase aki Ꞌjeele maam se debm kɛn tiŋg gɛn daayum. ");
INSERT INTO kyq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ꞋBooyki bɛɛ mꞋasen taaɗa: debm dɔɔɗ ɔk debm kaan̰ naabum jiga se, naan̰ se dɔɔɗ ɔkum maam mala, ɔɔ debm dɔɔɗ ɔkum maam se dɔɔɗ ɔk Debm kɛn ɔlumo.» ");
INSERT INTO kyq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kɛn Isa jaay taaɗ naŋ taarin̰ se, gɔtn se maakin̰ tuju. Ɔɔ naan̰ taaɗɗesin̰ tal ɔɔ: «ꞋBooyki bɛɛ mꞋasen taaɗa: maakse ki se deb kalaŋ utu am kutu.» ");
INSERT INTO kyq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Gɔtn se jee mɛtin̰ ki baag tɛrl kaakŋ naapa ɔɔ saap maakɗe ki ɔɔ: «Naan̰ tap ɓo taaɗ te naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Deb kalaŋ maakŋ jee mɛtin̰ ki se, naan̰ se ɓo debm kɛn Isa jen̰ se utu iŋg cɛɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Gɔtn se Simon Piɛr tɛɗin̰ nakŋ kɛn naan̰ an kaakŋ jeel ro ki ɔɔ: «N̰Ꞌtɔnd mɛtin̰ naan̰ tap ɓo n̰Ꞌtaaɗ te naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gɔtn se debm kɛn mɛtn Isa kɛn ese se dɛj kaaɗn Isa ki tɔnd mɛtin̰ ɔɔ: «Mɛluma, kɛse tap ɓo naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isa tɛrlin̰ ɔɔ: «Kɛse debm kɛn maam mꞋutu mꞋdupm mappa ɔɔ mꞋkɔl maakŋ baay ki jaay mꞋan̰ kɛɗ se.» Gɔtn se Isa dup mappa ɔl maakŋ baay ki ɔɔ ɛɗ Judas goon Simon Iskariɔt ki. ");
INSERT INTO kyq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kɛn Judas jaay ɔk mappan ji Isa ki se, gɔtn ese sum ɓo *Ɓubm sitange ɓaaɗo ɛnd maakin̰ ki. Gɔtn se Isa ɗeekin̰ ɔɔ: «Nakŋ naai Ꞌje Ꞌtɛɗa se Ꞌnaar tɛɗin̰ yɔkɔɗɔ.» ");
INSERT INTO kyq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gaŋ jee iŋg gɔtn ese se maakɗe ki se, mɛtn taar kɛn naan̰ taaɗ se, nam tap ɓo booy jeel te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aan gɔɔ Judas ɓo debm bɔɔbm gursɗe ɗey se, jee mɛtin̰ge saap ɔɔ kaaɗn naane Isa jen̰ taaɗn ɔɔ n̰Ꞌɓaa n̰Ꞌdugo nakŋ tɛɗn laa, ey lɛ jen̰ taaɗn ɔɔ n̰Ꞌɓaa n̰Ꞌɛɗ naka jee daayge tu. ");
INSERT INTO kyq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gaŋ gɔtn se, Judas jaay ɔk mappan kꞋdup kꞋjꞋɛɗin̰sin̰ sum se, naan̰ naar teec naatn. Ɔɔ kaaɗ kɛn se gɔtɔ tɛɗga nɔɔrɔ. ");
INSERT INTO kyq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kɛn Judas jaay teec sum se, Isa ɗeek ɔɔ: «Ɓɔrse se *Goon Deba se *nookin̰ ute Ꞌkeeme ɔɔ ute ro Goon Deba se Raa kic nookin̰ ute keeme. ");
INSERT INTO kyq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aan gɔɔ Raa nookin̰a utu Ꞌkeem ute ɗoobm Goon Deba se, bin se Goon Deba kic ɔɔpga baata Raa utu an̰ nooko. ");
INSERT INTO kyq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gɛnumge maam se mꞋkɔŋ kiŋg dɛn ute naase ey sum. Naase utu amki jea naɓo aan gɔɔ kɛn mꞋtaaɗo Yaudge tu se, mꞋtaaɗsen naase ki kici, gɔtn maam mꞋan ɓaa se, naase aki kɔŋ ɓaa eyo. ");
INSERT INTO kyq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ɓɔrse maam mꞋtaaɗsen nakŋ naase utu aki tɛɗ se kɛn kiji: Ꞌjeki naapa. Aan gɔɔ kɛn maam mꞋjeseno se, bin se naase kic Ꞌjeki naapa. ");
INSERT INTO kyq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kɛn naase jaay Ꞌjeki naapa ɗeer num, ute naan̰ se jeege paac Ꞌjeele, naase se jee mɛtn maam ki.» ");
INSERT INTO kyq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Gɔtn se Simon Piɛr tɔnd mɛtin̰ ɔɔ: «Mɛluma, naai Ꞌɓaa gay?» Isa tɛrlin̰ ɔɔ: «Ɓɔrse gɔtn maam mꞋan ɓaa se, naai am kɔŋ daan eyo. Num kaaɗn naai am daan se, mɔɔtn kuuy jaayo.» ");
INSERT INTO kyq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piɛr tɛrlin̰ ɔɔ: «Mɛluma, gɛn ɗi jaay naai ɔɔ ɓɔrse maam mꞋai kɔŋ daan ey se? Taa naai se, maam mꞋkooyo!» ");
INSERT INTO kyq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isa tɛrlin̰ ɔɔ: «Naai se ɓo Ꞌkooy taa maam ne? ꞋBooy bɛɛ mꞋai taaɗa: kɔr kɔrɔn̰jɔ Ꞌkɔɔy ey sum ɓo, naai Ꞌnaajn̰ ɗɔɔl mɔtɔ ɔɔ naai Ꞌjeelum eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ɔn̰te Ꞌkuunki nirlse, naase aalki maakse do Raa ki ɔɔ aalki maakse do maam ki kici. ");
INSERT INTO kyq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gɔtn kiŋgi utu dɛna raan maakŋ ɓee Bubum ki. Kɛn jaay gɔtɔ num, kaaɗn naane maam mꞋtaaɗsenga. Maam ɓaa ɓaa se taa mꞋasen ɓaa ɗaapm gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kɛn jaay mꞋɓaa ɗaapsenoga gɔtɔ num, maam mꞋaɗe tɛrlɛ mꞋutu mꞋasen tɔsɔ taa jꞋaki ɓaa kiŋg tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Naase Ꞌjeelki ɗoobm kɛn maam mꞋan ɓaa se. ");
INSERT INTO kyq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Gɔtn se Tɔma ɗeekin̰ ɔɔ: «Mɛlje, gɔtn naai Ꞌɓaan ɓaa se naaje kꞋjeel eyo, ɔɔ ɗoobm se tap ɓo jꞋan̰ jeel ɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isa ɗeekin̰ ɔɔ: «Maam ɓo ɗoobo, mꞋtaar mɛt ki ɔɔ debm kɛn ɛɗ kaaja jeege tu. Ɔɔ debm jaay ɓaa gɔtn Bubum ki se kaal te ɗoobm maam jaayo. ");
INSERT INTO kyq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kɛn naase Ꞌjeelumki maam se, Bubum kic num naase an̰ki Ꞌjeele. Ɓɔrse, naase Ꞌjeelin̰ki ɔɔ aakin̰kiga te kaamse.» ");
INSERT INTO kyq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ɗeekin̰ ɔɔ: «Mɛlje, Ꞌtaaɗjen tu Bua, naɓo bɛɛjega sum.» ");
INSERT INTO kyq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isa ɗeekin̰ ɔɔ: «Do dɔkin̰ maam mꞋtiŋg ute naase se ɓo ɔɔ naai Ꞌjeelum ey ne Pilip? Debm aakumga maam se, naan̰ se aakga Raa Bubu. Gɛn ɗi jaay ɗeekum ɔɔ: ‹ꞋTaaɗjen tu Raa Bubu se?› ");
INSERT INTO kyq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Naai Ꞌtook ey la kɛn maam mꞋiŋg ute Bua ɔɔ Bu iŋg te maam se, taargen maam mꞋtaaɗsen se maam mꞋtɛrɛc ute dom eyo, gaŋ Bu kɛn naaje kꞋkalaŋ se ɓo lee tɛɗn naabin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ꞋTookki taaruma kɛn maam mꞋiŋg ute Bua ɔɔ Bu iŋg ute maam se, kɛn Ꞌtookki taarum ey kic num, Ꞌtookki taa nakŋ‑kɔɔɓgen maam mꞋlee mꞋtɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ꞋBooyki bɛɛ mꞋasen taaɗa: debm aal maakin̰ do maam ki se, Ꞌkɔŋ tɛɗn nakgen aan gɔɔ maam mꞋlee mꞋtɛɗ se, ɔɔ naan̰ se utu Ꞌtɛɗn nakgen cir gɛn maam se daala, taa maam ɓaa ɓaa gɔtn Bubum ki. ");
INSERT INTO kyq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nakgen paacn̰ naase utu aki tɔnd mɛta te ro maam se, maam mꞋutu mꞋan̰ tɛɗa bin ɓo maam Goono se mꞋtaaɗn *nookŋ Bubuma. ");
INSERT INTO kyq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nakŋ kɛn naase Ꞌtɔndki mɛta ute ro maam se, maam mꞋutu mꞋan̰ kɔŋ tɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Kɛn naase jaay Ꞌjemki num, naase aki kɔŋ tɛɗn nakŋ kɛn maam mꞋtaaɗsen gɛn tɛɗa se. ");
INSERT INTO kyq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Maam mꞋutu mꞋtɔnd mɛtn Bubuma, ɔɔ naan̰ utu aseno kɔl debm kɛn asen kiŋg noogŋ daayum. ");
INSERT INTO kyq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Debm kɛn naan̰ aɗe kɔl se, kɛse Nirl Raa mala kɛn taaɗ taar mɛt ki. Naan̰ se jee do naaŋ ki an̰ kɔŋ kɔŋ eyo, taa naaɗe se ɔŋ aakin̰ eyo ɔɔ jeelin̰ eyo. Gaŋ naase se Ꞌjeelin̰ki taa naan̰ utu te naase ɔɔ utu iŋg maakse ki. ");
INSERT INTO kyq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Maam mꞋasen kɔŋ kɔn̰ gɛnaalge eyo, maam mꞋutu mꞋasen tɛrl kɔŋɔ. ");
INSERT INTO kyq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɔɔpga baata jee do naaŋ ki se am kaak ey sum, gaŋ naase se utu amki kaakum mꞋiŋg zɛɛrɛ, ɔɔ naase kic num aki kɔŋ kaaja. ");
INSERT INTO kyq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ɓii kɛn se, naase aki Ꞌjeele maam mꞋiŋg te Bubuma ɔɔ Bubum iŋg ute maam se, naaje kꞋkalaŋ ɔɔ naase ute maam se, naaje kꞋkalaŋki kici. ");
INSERT INTO kyq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Taar kɛn maam mꞋtaaɗsen gɛn tɛɗa jaay debm tɛɗin̰ se kɛse ɓo debm jema, ɔɔ debm jem maam se, Bubum kic an̰ jea ɔɔ maam kic mꞋutu mꞋan̰ jea ɔɔ mꞋan̰ taaɗn roma, taa naan̰ am jeele.» ");
INSERT INTO kyq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judn kɛn Judas Iskariɔt ey se, ɗeekin̰ ɔɔ: «Mɛlje, naai ɔɔ ajen taaɗn roi naaje ki sum ɔɔ jee do naaŋ ki jaay ai kaak ey se ajensin̰ taaɗn ɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isa tɛrlin̰ ɔɔ: «Debm jem maam se Ꞌtookŋ kuun taaruma ɔɔ Bubum se utu an̰ jea maam te Bubum se kꞋɓaa gɔtin̰ ki, ɔɔ kꞋkiŋg tɛlɛ ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Debm kɛn jem ey se, naan̰ Ꞌtook taarum eyo. Taar kɛn naase iŋg Ꞌbooyki maam mꞋiŋg mꞋtaaɗsen se mꞋtɛrɛc te dom eyo, gaŋ naan̰ se Bubum ɔlumo se ɓo taaɗa. ");
INSERT INTO kyq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Maam mꞋtaaɗsen nakgen se kaaɗ kɛn maam mꞋutu te naase. ");
INSERT INTO kyq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bubu se utu aɗe kɔl *Nirl Salal ute ro maama, taa naan̰ asen noogo ɔɔ naan̰ asen dooy nakge paac, ɔɔ utu asen tɛɗn naase aki saapm jeel mɛtn taargen maam mꞋtaaɗseno se. ");
INSERT INTO kyq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Ɔn̰te Ꞌkuunki nirlse ɔɔ ɔn̰te Ꞌɓeerki. Maam mꞋɓaa ɓaa se mꞋasen kɔn̰ tɔɔsuma kɛn asen tɔɔgŋ maakse, ɔɔ tɔɔsn se ɓo kɛn utu maakŋ maam ki kici. Maam mꞋasesin̰ kɛɗse aan gɔɔ gɛn jee do naaŋ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naase Ꞌbooykiga taar kɛn maam mꞋtaaɗsen mꞋɔɔ mꞋɓaa ɓaao num mꞋutu mꞋaɗe tɛrl mꞋasen kɔŋɔ. Kɛn naase jaay Ꞌjemki num maam ɓaa ɓaa gɔtn Bubum ki se, bɛɛki num, maakse raapo taa Bubum se naan̰ magal cirum maama. ");
INSERT INTO kyq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Maam mꞋtaaɗsen ɓɔrse kɔr nakgen se aan te ey ɓɔrt se, kɛn naaɗe se jaay aanga kic num, naase aki tooko. ");
INSERT INTO kyq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naan ki se maam mꞋkɔŋ taaɗn dɛn te naase ey sum, taa gaar gɛn do naaŋa se utu Ꞌɓaaɗo. Naɓo ɗeere, naan̰ se ɔk tɔɔgɔ dom ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Num gaŋ taa jee do naaŋ ki Ꞌjeel maam se, mꞋje Bubuma ɔɔ mꞋtɛɗn nakŋ kɛn naan̰ taaɗumi. Iin̰ki gɔtn ara; kꞋɓaaki!» ");
INSERT INTO kyq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Isa taaɗ jeege tun mɛtin̰ ki daala ɔɔ: «Maam se aan gɔɔ ko bin̰ mala mala ɔɔ Bubum se, naan̰ ɓo mɛl ko bin̰ se. ");
INSERT INTO kyq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tɛlɛtgen paacn̰ dɔɔk ute maama ɔɔ kɛn ooj ey se, naan̰ gaaŋ tund naatn. Gaŋ tɛlɛtn kɛn ooj se naan̰ gaaŋ ɗaapin̰a taa koojn̰ dɛn cir kɛn se daala. ");
INSERT INTO kyq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Taargen kɛn maam mꞋtaaɗsen se, Ꞌɗaapsenga, akiga bɛɛ naan *Raa ki. ");
INSERT INTO kyq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iŋg Ꞌdɔɔkki ute maama aan gɔɔ kɛn maam mꞋutu mꞋiŋg mꞋdɔɔk te naase se. Aan gɔɔ tɛlɛtn ko bin̰ kꞋgaaŋ kꞋjꞋundga naatn num ɔŋ ooj ey se se bin ɓo kɛn naase jaay iŋg Ꞌdɔɔkki ute maam ey se, naase aki kɔŋ tɛɗn nakŋ aak bɛɛ eyo kici. ");
INSERT INTO kyq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Maam se mꞋko bin̰ ɔɔ naase se Ꞌtɛlɛtumge. Debm iŋg Ꞌdɔɔk te maama ɔɔ maam mꞋiŋg mꞋdɔɔk te naan̰ se, debm se utu Ꞌtɛɗn nakgen jiga dɛn aak eyo. Anum kɛn naase jaay Ꞌdɔɔkki te maam ey se aki kɔŋ tɛɗn ɗim eyo. ");
INSERT INTO kyq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Debm kɛn iŋg Ꞌdɔɔk te maam ey se jꞋutu jꞋan̰ gaaŋ kund naatn aan gɔɔ tɛlɛtn ko bin̰ kꞋgaaŋ jꞋundin̰ se naan̰ utu tuutu ɔɔ jꞋan̰ tɔsn tɔɔcɔ. ");
INSERT INTO kyq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kɛn naase jaay iŋg Ꞌdɔɔkki te maama ɔɔ taarum jaay iŋg maakse ki se, Ꞌtɔndki mɛtn nakŋ naase Ꞌjeki ɔɔ naase an̰ki kɔŋɔ. ");
INSERT INTO kyq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ꞋTɛɗki nakgen bɛɛ dɛna, bin se naase aki Ꞌtɛɗn jee mɛtum ki ɔɔ nakgen se *Ꞌnookŋ Bubuma. ");
INSERT INTO kyq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Maam mꞋjese aan gɔɔ kɛn Bubum Raa Ꞌjem maam se kici. Iŋg Ꞌdɔɔkki te maama, bin se naase aki Ꞌjeele maam se mꞋjese. ");
INSERT INTO kyq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kɛn naase jaay Ꞌtɛɗki nakŋ maam mꞋtaaɗsen gɛn tɛɗa se num, kɛse naase iŋg dɔɔkki ute maam maakŋ maak‑jem ki, aan gɔɔ maam mꞋtɛɗ nakgen kɛn Bubum taaɗum gɛn tɛɗa se jaay mꞋiŋg *dɔɔk ute Bubum maakŋ maak‑jen̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Maam mꞋtaaɗsen nakgen se taa naase aki kɔŋ maak‑raapuma, ɔɔ maak‑raapse se Ꞌtɛɗn maak‑raapm maraadin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ꞋBooyki! Nakŋ kɛn maam mꞋtaaɗsen gɛn tɛɗa se: Ꞌjeki naapa aan gɔɔ kɛn maam mꞋjese se. ");
INSERT INTO kyq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Debm kɛn jaay ɛɗ kon̰a taa mɛɗin̰ge se, naan̰ se jeɗe te maakin̰ cir paac. ");
INSERT INTO kyq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nakŋ maam mꞋtaaɗsen se jaay, naase Ꞌtɛɗin̰ki se, naase se ɓo mɛɗn maamge. ");
INSERT INTO kyq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maam se mɔɔtn mꞋasen kɔŋ daŋ ɓulumge ey sum, taa debm ɓulu se ɔŋ jeel nakŋ kɛn mɛlin̰ lee tɛɗ se eyo. Num naase se maam mꞋdaŋse mɛɗumge, taa maam mꞋtaaɗsenga nakgen paacn̰ kɛn maam booyo gɔtn Bubum ki. ");
INSERT INTO kyq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Naase ɓo Ꞌbɛɛr ɔɔɗumki eyo, anum maam ɓo mꞋbɛɛr mꞋtɔɔɗseno se taa mꞋasen kɔl naaba aki ɓaa tɛɗn nakŋ aak bɛɛ ɔɔ nakgen tiŋg gɛn daayum. Taa bin se nakŋ naase paac Ꞌtɔndkiga mɛta ute ro maam se, Bubum asen Ꞌkɔŋ kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nakŋ maam mꞋtaaɗsen mꞋɔɔ aki tɛɗ se: Ꞌjeki naapa.» ");
INSERT INTO kyq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Kɛn jee do naaŋ ki jaay ɔɔɗ undse se, Ꞌjeelki naaɗe ɔɔɗ undumoga maam ɓo deete. ");
INSERT INTO kyq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kɛn naase jaay mɛtn jee do naaŋ ki num, kaaɗn naane naaɗe asen jea, taa naase aki Ꞌtɛɗn mɛtn naaɗe. Gaŋ naase Ꞌtɛɗkiga mɛtn naaɗe eyo, ɔɔ maam se mꞋbɛɛr mꞋtɔɔɗseno maakŋ naaɗe ki se, naase Ꞌtɛɗkiga kalse ki, taa naan̰ se ɓo naaɗe ɔɔɗ undse naatn se. ");
INSERT INTO kyq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ꞋSaapki tu do taar kɛn maam mꞋtaaɗseno mꞋɔɔ: debm tɛɗn naaba gɔtn deb ki se, naan̰ se magal cir debm kɛn naan̰ tɛɗn naaba gɔtin̰ ki se eyo. Jee se jaay dabarumo maam se, naase kic, naaɗe utu asen dabara; ɔɔ naaɗe jaay uun taar maam se taar naase kic ɓo, naaɗe utu kuunu. ");
INSERT INTO kyq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Naaɗe utu asen tɛɗn nakgen se paac dose ki se taa maama, taa naaɗe lɛ jeel debm ɔlumo se eyo. ");
INSERT INTO kyq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kɛn maam mꞋɓaaɗo jaay mꞋtaaɗɗen te taargen se ey num, naaɗe Ꞌtɛɗn jee *kusin̰ge eyo, num ɓɔrse maam mꞋɓaaɗo mꞋtaaɗɗenga jaay naaɗe baate kuun se, naaɗe Ꞌkɔŋ ɗoobm kɛn naaɗe an kɔɔɗn doɗe eyo. ");
INSERT INTO kyq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Debm ɔɔɗ undum maam se, ɔɔɗ und Bubum kici. ");
INSERT INTO kyq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nakŋ kɔɔɓgen maam mꞋtɛɗ daanɗe ki kɛn ɓii kalaŋ nam tɛɗin̰ te ey se, kɛn maam jaay mꞋtɛɗin̰ te ey num, naaɗe kɔŋ Ꞌtɛɗn jee kusin̰ge eyo. Num ɓɔrse nakŋ‑kɔɔɓgen maam mꞋtɛɗɗesin̰ se naaɗe aakin̰ga ute kaamɗe. Ute naan̰ se kic ɓo naaɗe ɔɔɗ undum maam te Bubuma. ");
INSERT INTO kyq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nakŋ naaɗe tɛɗ se aanga ɗoobin̰ ki aan gɔɔ kꞋraaŋin̰ maakŋ *Ko Taar kɛn Raa ɛɗo Musa ki kɛn ɔɔ: Jee se ɔɔɗ undum se, cɛrɛ sum.» ");
INSERT INTO kyq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Tɛr Isa ɗeekɗen ɔɔ: «Debm utu aɗe ɓaa jaay asen noogse, aɗe kiin̰ gɔtn Bubum ki, ɔɔ kɛn maam mꞋɓaaga gɔtn Bubum ki num, mꞋasesin̰o kɔlɔ. Naan̰ se ɓo Nirl naan̰ Raa mala kɛn taaɗ taar mɛt ki ɔɔ kɛn iin̰o gɔtin̰ ki, kɛn naan̰ ɓaaɗoga se naan̰ mala utu am tɛɗn saaɗuma. ");
INSERT INTO kyq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Naase kic ɓo utu amki tɛɗn saaɗumge taa gɔtn maam mꞋbaag naabum sum se, naase utuki te maama.» ");
INSERT INTO kyq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Maam mꞋtaaɗsen taar ese se, taa kaal maaksen naase aalki do *Raa ki se an̰ki kɔn̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","JꞋutu jꞋasen tuur maakŋ *ɓee kɛn Yaudge lee tusn maak ki ɔɔ kɛn kaaɗin̰ utu kaan se, jeege utu asen tɔɔlɔ, maak‑saapm naaɗe ki num ɔɔ kaaɗn naane naaɗe tɛɗ tɛɗ naabm Raa. ");
INSERT INTO kyq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Naaɗe utu Ꞌtɛɗn naan̰ se, taa naaɗe jeelum maam eyo ɔɔ jeel Bubum eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Gaŋ maam mꞋtaaɗsen naan̰ se, kɛn kaaɗin̰ aanga kic num, naase aki saapm do taar kɛn maam taaɗseno se. Kaaɗ kɛn maam mꞋutu mꞋbaag baag naabum se, maam mꞋɔŋ mꞋtaaɗseno te naan̰ se eyo, taa maam mꞋutu te naase.» ");
INSERT INTO kyq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ɓɔrse maam taaɗga taaɗ mꞋɔɔ mꞋɓaa ɓaa gɔtn deb kɛn ɔlumo, naɓo maakse ki se, debm jaay Ꞌtɔnd mɛtum ɔɔ naai Ꞌɓaa gay kic ɓo gɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Num gaŋ taa taar maam mꞋtaaɗsen bin se, tujsenga maakse. ");
INSERT INTO kyq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ey num taar maam mꞋtaaɗsen se taar mɛt ki; kɛn maam mꞋɓaaga se asen tɛɗn jiga naase ki; kɛn maam jaay mꞋɓaa te ey num, Debm Noogo se aɗe kɔŋ ɓaa eyo. Num gaŋ kɛn maam mꞋɓaaga num mꞋutu mꞋan̰o kɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kɛn naan̰ ɓaaɗoga num, naan̰ utu Ꞌtaaɗn jeege tun do naaŋ ki se, naaɗe iigga do maak‑saapm kɛn naaɗe ɔkɔ do *kusin̰ ki, do nak kɛn ute ɗoobin̰a, ɔɔ tɛr do kɔjn̰ bɔɔr kɛn Raa utu kɔjn̰ do jeege tu se kici. ");
INSERT INTO kyq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Maak‑saap naaɗe ɔk do kusin̰ ki se lɛ taa naaɗe aal maakɗe dom ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɔɔ maak‑saapm kɛn naaɗe ɔk do nak kɛn ute ɗoobin̰ se lɛ, taa maam ɓaa ɓaa gɔtn Bubum ki ɔɔ mɔɔtn naase amki kɔŋ kaak eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ɔɔ maak‑saapm kɛn naaɗe ɔk do kɔjn̰ bɔɔr kɛn Raa utu kɔjn̰ do jeege tu se lɛ, taa gaar do naaŋ ki se bɔɔrɔ oocga don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«MꞋɔk nakge dɛna kɛn mꞋasen taaɗa, naɓo kɛn mꞋtaaɗsesin̰ga ɓɔrse kic ɓo, naase an̰ki kɔŋ booy kɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kɛn *Nirl Salal kɛn taaɗ taar mɛt ki utu aɗe ɓaa se, naan̰ utu asen tɔɔɗɔ taa naase aki jeel taar mɛt ki se mala mala. Taa taar naan̰ utu Ꞌtaaɗ se, Ꞌtɛrɛcn̰ don̰ ki ɓo Ꞌtaaɗ eyo, gaŋ naan̰ se utu asen taaɗn taar kɛn naan̰ utu aɗe booyo, ɔɔ utu asen taaɗn nakgen utu Ꞌkaan se. ");
INSERT INTO kyq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nirl Salal se utu am *nooko, taa nakgen jaay naan̰ aɗe booy gɔtum ki se utu asesin̰ taaɗn naase ki. ");
INSERT INTO kyq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nakgen paacn̰ Bubum ɔk se, nakgen se gɛn maam kici; taa naan̰ se ɓo maam mꞋtaaɗsen mꞋɔɔ: nakgen jaay naan̰ aɗe booy gɔtum ki se utu asesin̰ taaɗn naase ki.» ");
INSERT INTO kyq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ɔɔpga baata naase utu amki kaak eyo, ɔɔ tɛɗga cɔkɔ jaay sɔm utu amki kaaka.» ");
INSERT INTO kyq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Gɔtn ese maakŋ jeen̰ge tu se jee mɛtin̰ge se taaɗ te naapa ɔɔ: «Naan̰ tap ɓo je ɗeekŋ ɔɔ ɗio kɛn taaɗ ɔɔ: ɔɔpga baata naase utu amki kaak eyo, ɔɔ tɛɗga cɔkɔ jaay sɔm utu amki kaaka, tɛr ɗeek ɔɔ: maam ɓaa ɓaa gɔtn Bubum ki se? ");
INSERT INTO kyq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɔɔ taarin̰ kɛn ɔɔ ɔɔpga baata se, je ɗeekŋ ɔɔ ɗio? Taar naan̰ taaɗ se naaje jꞋɔnd te mɛtin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isa se jeele kɛn naaɗe je tɔnd mɛtin̰ se, naan̰ ɗeekɗen ɔɔ: «Naase je aki jeel ute naapa mɛtn taar kɛn maam mꞋɗeeksen mꞋɔɔ: Ɔɔpga baata naase utu amki kaak eyo, ɔɔ tɛɗga cɔkɔ jaay sɔm utu amki kaak se. ");
INSERT INTO kyq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ꞋBooyki bɛɛ mꞋasen taaɗa: naase maakse utu tuju ɔɔ aki keeme, gaŋ jee do naaŋ ki se maakɗe utu Ꞌraapo. Maakse utu tujn̰ ɗeere, naɓo tɛɗga num, maak‑tujse se Ꞌdɛl maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ꞋSaapki tu do mɛnd kɛn ɓaa ɓaa koojo se: kɛn kaaɗn koojin̰ jaay aanga se, naan̰ dabar bini jaay ooj goono. Kɛn naan̰ oojga num, dirigŋ te dubarin̰ se naatn ɔɔ naan̰ maakin̰ raapo taa goon naan̰ ooj se. ");
INSERT INTO kyq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Taa naan̰ se, naase kic ɓɔrse utuki maakŋ maak‑tuj ki, ɔɔ tɛɗga num, maam mꞋutu mꞋasen kaaka ɔɔ bin se maakse utu raapo ɔɔ maak‑raapm naase se, nam an̰ kɔŋ tuj eyo. ");
INSERT INTO kyq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Bin ɓo, ɓii kɛn se, naase aki tɔnd mɛtn ɗim gɔtum ki ey sum. ꞋBooyki bɛɛ mꞋasen taaɗa: nakŋ naase Ꞌtɔndki mɛta gɔtn Bubum ki te ro maam se, naan̰ utu asen kɛɗa. ");
INSERT INTO kyq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bini ɓɔrse kic ɓo, naase Ꞌtɔndki te mɛtn ɗim te ro maam eyo; ɓɔrse Ꞌtɔndki mɛta ɔɔ utu aki kɔŋɔ, bin se ɓo maakse Ꞌraap maraadin̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Taargen maam mꞋtaaɗseno paac se, mꞋtaaɗseno ute kaal naagŋ taara. Gaŋ kaaɗin̰ utu Ꞌkaan se, maam mꞋutu mꞋasen taaɗn ute kaal naagŋ taar ey sum. Num naan ki se nakgen taaɗ taa Bubum se mꞋutu mꞋasesin̰ taaɗn tal tal. ");
INSERT INTO kyq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ɓiin se naase aki tɔnd mɛtn nakge paac ute ro maama. Maam mꞋasen taaɗa taa naase se maam mꞋkɔŋ tɔnd mɛtn Bu ey sum; ");
INSERT INTO kyq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","taa Bu mala se jese taa naase Ꞌjemki maama ɔɔ naase Ꞌjeelkiga maam se mꞋiin̰o gɔtn Raa ki. ");
INSERT INTO kyq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Maam mꞋɓaaɗo do naaŋ ki se mꞋiin̰o gɔtn Bubum ki; ɓɔrse maam mꞋkiin̰ do naaŋ ki se mꞋɓaa gɔtn Bubum ki.» ");
INSERT INTO kyq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Gɔtn se jee mɛtin̰ ki ɗeekin̰ ɔɔ: «ꞋBooyo, ɓɔrse naai Ꞌtaaɗjen tal tal aaljen naagŋ taar ey sum. ");
INSERT INTO kyq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ɓɔrse naaje kꞋjeele, naai se Ꞌjeel nakge paac ɔɔ Ꞌje nam Ꞌtɔnd mɛti ey sum. Taa naan̰ se ɓo naaje kꞋjeele naai se iin̰o gɔtn Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isa tɛrlɗen ɔɔ: «Ɓɔrse naase Ꞌjeelkiga sum la? ");
INSERT INTO kyq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ꞋBooyki! Kaaɗin̰ utu Ꞌkaana, ɔɔ ɓɔrse kaaɗin̰ se aanga, naase utu aki Ꞌkaan̰ wɔɔkɔ ɔɔ naŋa kic ɓo Ꞌkuun ɗoobin̰ ɗoobin̰a ɔɔ utu amki kɔn̰ kalum ki, naɓo maam se mꞋkalum ki eyo, num Bu se utu te maama. ");
INSERT INTO kyq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Taargen maam mꞋtaaɗsesin̰ se, taa ute maam se naase aki Ꞌkɔŋ tɔɔsɛ. Ɗeere, naase utu aki Ꞌkɔŋ dubar do naaŋ ki, naɓo aayki kaamse taa maam cirga dunia.» ");
INSERT INTO kyq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ uun kaamin̰ raan ɗeek ɔɔ: «Bua, ɓɛrɛ, kaaɗin̰ se aasga naai *Ꞌnook Gooni, taa Gooni kic ai nooko. ");
INSERT INTO kyq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Naai ɛɗin̰ga jikilimge paac kaam jin̰a, taa naan̰ kɛɗn *kaajn̰ gɛn daayum jeege tun naai ɛɗin̰sin̰ga se. ");
INSERT INTO kyq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kaajn̰ gɛn daayum kɛn ese se taa naaɗe ai jeeli naai Raa mala kɛn kalaŋ lak ɔɔ am jeel maam Isa *al‑Masi kɛn naai ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Do naaŋ ki se maam nookiga ɔɔ naabi naai ɛɗum se, maam mꞋtɛɗ naŋin̰ga. ");
INSERT INTO kyq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ɓɔrse Bua, Ꞌnookum naani ki aan gɔɔ kɛn naai Ꞌnookumo kaaɗ kɛn naai aal te dunia ey ɓɔrt se. ");
INSERT INTO kyq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Maam mꞋtaaɗɗenga naaɗe jeeliga naai jeegen kɛn naai Ꞌbɛɛr tɔɔɗo do naaŋ ki jaay ɛɗumɗen se. Naaɗe se jee naaige, ɔɔ naai ɛɗumɗenga kaam jima, ɔɔ naaɗe booy uunga taar naai. ");
INSERT INTO kyq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ɓɔrse naaɗe jeele, nakŋ naai ɛɗumo paac se iin̰o gɔtn naai ki. ");
INSERT INTO kyq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Taar kɛn naai Ꞌtaaɗumo se, maam mꞋtaaɗɗesin̰ga kici. Ɔɔ naaɗe took uunga, naaɗe jeelga ɗeere, maam se mꞋiin̰o gɔtn naai ki ɔɔ naaɗe tookga naai ɓo ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Maam mꞋtɔnd mɛti se taa naaɗe sum, ey num gɛn jee do naaŋ kɛn ɓaa se paac eyo. Anum mꞋtɔnd mɛti se gɛn jee naai ɛɗumɗeno kaam jima, taa naaɗe se jee naaige. ");
INSERT INTO kyq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nakŋ maam mꞋɔk paac se gɛn naai ɔɔ nakŋ naai ɔk paac se lɛ, gɛn maama; ɔɔ ute ɗoobm naaɗe se ɓo, jeege Ꞌkaakŋ nookuma. ");
INSERT INTO kyq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naan ki se maam mꞋkɔŋ kiŋg do naaŋ ki ey sum. Gaŋ naaɗe se utu kiŋg do naaŋ ki ɔɔ maam lɛ mꞋtɛrl tɛrl gɔtn naai ki. Bua, naai Debm *Salal se, bɔɔbɗe ute tɔɔgi kɛn naai ɛɗum se. ꞋBɔɔbɗe taa naaɗe Ꞌtɛɗn kalaŋ aan gɔɔ maam ute naai naaje kꞋkalaŋ se. ");
INSERT INTO kyq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kaaɗ kɛn maam mꞋiŋgo te naaɗe se, maam lɛ mꞋbɔɔbɗeno ute tɔɔgŋ kɛn naai ɛɗumo se. Maam se mꞋbɔɔbɗenoga maakɗe ki se nam kalaŋ tap ɓo ut eyo, ɔɔ deb kalaŋ kɛn ut se lɛ, taa taar kꞋraaŋo do dɔkin̰ se Ꞌkaan te ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ɓɔrse maam mꞋtɛrl tɛrl gɔtn naai ki ɔɔ kɛn ɓɔrse mꞋutu do naaŋ ki jaay mꞋtaaɗɗen taargen se, taa naaɗe kɔŋ maak‑raapuma ɔɔ maak‑raapm naaɗe se, Ꞌtɛɗn maak‑raapm maraadin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Maam mꞋtaaɗɗenga taar naai, gaŋ jee do naaŋ ki se ɔɔɗ undɗenga taa naaɗe se mɛtn jee do naaŋ kɛn ɓaa se eyo, aan gɔɔ maam kic mɛtn jee do naaŋ kɛn ɓaa se ey se. ");
INSERT INTO kyq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Maam mꞋtɔnd mɛti se taa aɗen tɔsn naatn do naaŋ ki eyo, num taa aɗen bɔɔbm ro Deb kɛn iŋg ɓo gɛn tɛɗn *kusin̰ sum se. ");
INSERT INTO kyq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naaɗe se mɛtn jee do naaŋ kɛn ɓaa se eyo, aan gɔɔ maam kic mɛtn jee do naaŋ kɛn ɓaa se ey se. ");
INSERT INTO kyq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ute taar naai mɛt ki se, naai Ꞌtɛɗɗen naaɗe Ꞌtɛɗn jee naaigen mala mala; taa taar naai se taar mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aan gɔɔ kɛn naai ɔlumo do naaŋ ki se, maam kic mꞋɔlɗen do naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Taa naaɗe se, maam mꞋɛɗi rom paac, taa naaɗe kic ai kɛɗn roɗe paac ute taar mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Kɛn mꞋtɔnd mɛti se taa naaɗe sum eyo, num mꞋtɔnd mɛti, taa jeegen utu Ꞌtookŋ taarɗe ɔɔ utu Ꞌkaal maakɗe dom ki se kici. ");
INSERT INTO kyq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ɔn̰ɗe naaɗe paac Ꞌtɛɗn kalaŋ. Bua, Ꞌtɛɗɗen naaɗe Ꞌtɛɗn kalaŋ ute naaje kici, aan gɔɔ naai iŋg *dɔɔk ute maama ɔɔ maam mꞋiŋg dɔɔk te naai se. ꞋTɛɗɗe naaɗe Ꞌtɛɗn kalaŋ kici, jaay jee do naaŋ ki se Ꞌjeel naai ɓo ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Maam mꞋtaaɗɗenoga nookŋ naai ɛɗumo se, ute naan̰ se naaɗe tɛɗn kalaŋ aan gɔɔ maam mꞋutu naai kꞋkalaŋ se. ");
INSERT INTO kyq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Maam mꞋiŋg mꞋdɔɔk te naaɗe, aan gɔɔ naai iŋg dɔɔk te maam se. Bin se naaɗe Ꞌkɔŋ dɔɔkŋ tɛɗn kalaŋ, jaay jee do naaŋ ki se Ꞌjeele naai ɓo ɔlumo ɔɔ naai Ꞌjeɗe aan gɔɔ naai Ꞌjem maam se. ");
INSERT INTO kyq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bua, jee se naai ɓo ɛɗumɗeno ɔɔ mꞋje gɔtn maam mꞋiŋg se, naaɗe Ꞌkiŋg ute maam kici. Taa naaɗe kaakŋ nookuma, nookŋ kɛn naai ɛɗumo. Taa naai Ꞌjemoga kaaɗ kɛn naai aalo te do naaŋ ey ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bua, naai se debm daan ki, naɓo jee do naaŋ ki se jeeli te eyo, gaŋ maam se mꞋjeeli, ɔɔ jee se kic jeelga kɛn naai ɓo ɔlumo. ");
INSERT INTO kyq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Maam mꞋtaaɗɗen naaɗe jeelga roi, ɔɔ maam mꞋutu mꞋaɗen tɛɗn naaɗe ai jeel kɔkɔ, taa maak‑jei kɛn naai ɔk dom ki se Ꞌtɛɗn do naaɗe ki kici, bin se jaay maam mꞋkiŋg dɔɔkŋ te naaɗe.» ");
INSERT INTO kyq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ iin̰ te jee mɛtin̰ ki gaaŋ kaam maane kꞋdaŋin̰ Sedrɔn deel ɓaa jɛŋ kɛn kaam naane. Gɔtn se ɔk jinɛnɛ ɔɔ naan̰ ute jee mɛtin̰ ki se ɓaa ɛnd maak ki. ");
INSERT INTO kyq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Gaŋ Judas je kutn Isa se, jeel gɔtn ese kici taa Isa ute jee mɛtin̰ ki se, lee ɓaaɗo tus tus gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Naan̰ deelo naan dɔɔl asgar *Rɔmɛge tu, ute asgargen kɛn lee bɔɔb *Ɓee Raa. Naaɗe se *Parizige ute *magal jee tɛɗn sɛrkɛ Raage tu ɓo ɔlɗeno. Naaɗe ɓaaɗo jinɛnɛ ki se, ute jɛl pooɗge te lɔɔmpɗege ɔɔ ute nakŋ tɛɗn bɔɔrɗege. ");
INSERT INTO kyq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Num gaŋ Isa jeel paac nakŋ utu kaan don̰ ki se, naan̰ iiko cɛɛɗe ki ɗeekɗen ɔɔ: «Naase Ꞌjeki naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Naaɗe tɛrlin̰ ɔɔ: «Naaje kꞋje Isan kɔɗ Nazarɛt.» Gɔtn se Isa tɛrlɗen ɔɔ: «Kɛse ɓo maama.» Gaŋ Judas debm kɛn je kutin̰ se utu maakŋ jeege tun se kici. ");
INSERT INTO kyq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kɛn jee se jaay booy Isa ɗeekɗen ɔɔ: «Kɛse maam se,» jee se tɛr te mɛtɗe diwir ɔɔ naaɗe paac si naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tɛr Isa tɔnd mɛtɗe daala ɔɔ: «Naase tap ɓo, Ꞌjeki naŋa?» Naaɗe tɛrlin̰ ɔɔ: «Naaje kꞋje Isan kɔɗ Nazarɛt.» ");
INSERT INTO kyq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isa tɛrlɗen ɔɔ: «Maam mꞋtaaɗsenoga taaɗa mꞋɔɔ kɛse ɓo maama. Kɛn naase jaay, Ꞌjemki maam sum num, ɔn̰ki jee mɛtum ki se Ꞌɓaao.» ");
INSERT INTO kyq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Taar kɛn Isa taaɗo se aanga ɗoobin̰ ki kɛn ɔɔ: Maakŋ jeege tun kɛn naai ɛɗumɗeno kaam jim paac se, nam kalaŋ maam mꞋutin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Gɔtn se, Simon Piɛr ɔɔɗ gɔrɗ‑jɛrlin̰ se, ɔɔ ɔg gaaŋ te bi debm tɛɗn naabm magal debm tɛɗn sɛrkɛ Raa ki. Naan̰ gaaŋ te bin̰ do ji daama ɔɔ gaabm se kꞋdaŋin̰ Malkus. ");
INSERT INTO kyq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Gaŋ Isa taaɗ Piɛr ki ɔɔ: «Gɔrɗ‑jɛrli se ɔlin̰ saapin̰ ki gɔtin̰ ki! *Kɔɔpm dubar kɛn Bubum ɛɗumo se, maam mꞋan̰ kaayin̰ ey la?» ");
INSERT INTO kyq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gɔtn se dɔɔl asgar *Rɔmɛge, ute bubɗe ɔɔ te asgargen kɛn lee bɔɔb *Ɓee Raa kɛn Yaudge ɔlɗeno se, iij‑ɔk Isa ɔɔ dɔɔkin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Naaɗe ɔk ɓaansin̰o deet se gɔtn Annan ki. Ɔɔ Annan se ɓo moom Kayipm gaaba. Ɔɔ ɓaar kɛn ese Kayipm ɓo *magal debm tɛɗn sɛrkɛ Raa ki. ");
INSERT INTO kyq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayipm ese ɓo kɛn taaɗo magal Yaudge tu ɔɔ: kɛn asen tɛɗn jiga naase ki se, deb kalaŋ ɓo Ꞌkooyo ɔɔ Ꞌkɔn̰ jee dɛna. ");
INSERT INTO kyq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piɛr ute debm mɛtn Isa kɛn kuuy se, naaɗe ɔko mɛtn Isa. Num debm mɛtn Isa kɛn kuuy se, *magal debm tɛɗn sɛrkɛ Raa ki se jeelin̰a, gɔtn se naan̰ ɛnd te Isa kalaŋ ɓaa daan bɔɔr ɓee magal debm tɛɗn sɛrkɛ Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Gaŋ Piɛr se ɔɔp iŋg naatn taa ɗoob ki, anum debm mɛtn Isa kɛn kuuy, kɛn magal debm tɛɗn sɛrkɛ Raa ki jeelin̰ se teeco. Ɔɔ ɓaaɗo taaɗ mɛnd kɛn iŋg bɔɔb taa ɗoobo se, ɔɔ jꞋɔn̰ Piɛr se ɛndo. ");
INSERT INTO kyq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɔɔ mɛnd kɛn iŋg bɔɔb taa ɗoobo se, naan̰ ɗeek Piɛr ki ɔɔ: «Naai kic ɓo maakŋ jeege tun mɛtn gaab kɛn se la?» Piɛr tɛrlin̰ ɔɔ: «Maam se mɛtn naaɗe eyo!» ");
INSERT INTO kyq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɓii kɛn se kuulu ɔɔn̰ɔ, taa naan̰ se ɓo jee tɛɗn naabge ute asgargen kɛn lee bɔɔb *Ɓee Raa se, gɔtn se naaɗe tuuy pooɗo ɔɔ ɗaar riib riibi. Gɔtn se Piɛr kic ɗaar riib te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Gaŋ magal debm tɛɗn sɛrkɛ Raa ki se baag tɔnd mɛtn Isa se taa jee mɛtin̰ ki ɔɔ do taar kɛn naan̰ lee dooyɗe. ");
INSERT INTO kyq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isa tɛrlin̰ ɔɔ: «Jee te dɛnɗe se maam taaɗɗenga tal tal ɔɔ daayum maam mꞋlee dooyo jeege maakŋ *ɓee kɛn Yaudge lee tusn maak ki ɔɔ mꞋdooyo jeege daan bɔɔr *Ɓee Raa ki, gɔtn kɛn Yaudge paac lɛ tusn se taar ɗim kalaŋ tap ɓo maam mꞋɔyin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Naai tap ɓo Ꞌtɔnd mɛtum bin se taa ɗio? Naai Ꞌtɔnd mɛtn jeegen tiŋg booyo taar kɛn maam mꞋlee taaɗɗeno se. Ɔɔ mɛtn taar kɛn maam taaɗɗeno se lɛ, naaɗe jeelin̰ paac.» ");
INSERT INTO kyq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Do taar kɛn se sum ɓo maakŋ asgarge tun kɛn lee bɔɔb Ɓee Raa se deb kalaŋ kɛn cɛɛn̰ ki se, ɔndin̰ mɛtn bin̰ ki ɔɔ ɗeekin̰ ɔɔ: «Magal debm tɛɗn sɛrkɛ Raa ki ɓo kꞋtaaɗin̰ taar kɛn bin ne?» ");
INSERT INTO kyq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Gaŋ Isa tɛrlin̰ ɔɔ: «ꞋTaaɗum tu taar ɗi kɛn maam mꞋtaaɗ mꞋtujin̰ se! Ɔɔ kɛn maam jaay mꞋtaaɗga taar mɛt ki num, gɛn ɗi jaay naai ɔndum se?» ");
INSERT INTO kyq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Isa jaay Annan ɔlin̰ gɔtn Kayipm kɛn magal debm tɛɗn sɛrkɛ Raa ki se, Isa kꞋdɔɔkin̰ga dɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kaaɗ kɛn Simon Piɛr ɗaar riib riib pooɗo gɔtn ese se, naaɗe ɗeekin̰ ɔɔ: «Maakŋ jeege tun mɛtn gaab kɛn se, naai kic ɓo maakɗe ki la!» Gɔtn se Piɛr naaj ɔɔ: «Maam se mɛtn naaɗe eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gaŋ maakŋ jee tɛɗn naabm *magal debm tɛɗn sɛrkɛ Raa ki se, deb kalaŋ se taasn gaabm kɛn Piɛr ɔg gaaŋo te bin̰ se, naan̰ ɗeek Piɛr ki ɔɔ: «Naai se, maam mꞋaakioga te naan̰ maakŋ jinɛn ki ɗaamo?» ");
INSERT INTO kyq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Gaŋ tɛr gɔtn se Piɛr naaj daala ɔɔ kaaɗ kɛn se sum ɓo gaŋ kɔrɔn̰jɔ naar ɔɔɗ ɔɔyɔ. ");
INSERT INTO kyq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tanɔɔrin̰ nɔɔrin̰ se, naaɗe ɔko Isa gɔtn Kayip ki ɔɔ ɓaansin̰ ɓee magal *Rɔmɛge tu ron̰ Pilat. Gaŋ naaɗe baate kɛnd maak ki taa naaɗe ɗaapga ɗaap roɗe gɛn kɔsn *laa Paak, taa naaɗe je tɛɗn kusin̰a roɗe ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gɔtn se Pilat teec ɔŋɗe naatn ɔɔ ɗeekɗen ɔɔ: «Gaabm se naase ɔkin̰ki mindin̰ gɛn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Naaɗe tɛrlin̰ ɔɔ: «Gaabm se kɛn tuj te ɗim ey sum ɓo naaje jꞋansin̰o kɔkŋ ɓaa gɔti ki la?» ");
INSERT INTO kyq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Gɔtn se Pilat tɛrlɗen ɔɔ: «Naase mala ɔk ɓaansin̰ki, ɔɔ taar se, ɓaa aakin̰ki ute ɗoobm naase.» Gaŋ Yaudge tɛrlin̰ ɔɔ: «Naaje jꞋundjen te kulu gɛn tɔɔl deba eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bin ɓo taar kɛn Isa taaɗo ɔɔ te ɗoobm gay kɛn naan̰ utu an kooy se, aanga ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gɔtn se Pilat tɛrl ɛnd maak ki daala, ɔl kꞋdaŋo Isa, ɔɔ naan̰ tɔnd mɛtin̰ ɔɔ: «Naai ɓo Gaar Yaudge la?» ");
INSERT INTO kyq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Num Isa tɛrlin̰ ɔɔ: «Taar naai Ꞌtaaɗ se, naai mala ɓo saap ɔŋin̰ lɔɓu, jeegen kuuy ɓo taaɗi taa maam lɛ?» ");
INSERT INTO kyq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat tɛrlin̰ ɔɔ: «Naai aakum maam se, mꞋkɔɗ Yaud la? Kɛse jeeige mala naaɗen *jee magal tɛɗn sɛrkɛ Raa ki se ɓo ɔk ɓaansio gɔtum ki je ai kutu. Naai tap ɓo tujga ɗio?» ");
INSERT INTO kyq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Gɔtn se Isa tɛrlin̰ ɔɔ: «Gaar maam se gɛn do naaŋa ara eyo. Kɛn gaar maam jaay gɛn do naaŋa ara num, asgarumge am kɔŋ kɔn̰um Yaudge am kɔk eyo. Num ɓɔrse gaar maam se, gɛn do naaŋa ara eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Gɔtn se Pilat ɗeekin̰ ɔɔ: «Kɛn bin se, naai gaarge ɗaamo?» Isa tɛrlin̰ ɔɔ: «Yɛɛ aan gɔɔ kɛn naai Ꞌtaaɗin̰ se, maam se mꞋgaarge. Taa naan̰ se ɓo maam jꞋoojuma ɔɔ maam mꞋɓaaɗo do naaŋ ki se taa mꞋtɛɗn saaɗa do taar kɛn mɛt ki. Ɔɔ debm jaay iŋg ute taar mɛt ki se, booy kuun taaruma.» ");
INSERT INTO kyq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat tɛrl Isa ki ɔɔ: «Taar mɛt ki se, taar gayo?» Num kɛn Pilat jaay taaɗ taar ese se, naan̰ tɛrl teec ɓaa ɔŋ Yaudge daala ɔɔ ɗeekɗen ɔɔ: «Gaabm se, maam mꞋɔŋ te taar ɗim kusin̰ gɔtin̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aan gɔɔ aanga laa Paakŋ gɛn Yaudge tak ɓo, maam mꞋlee mꞋtɔɔɗ tɔlsen tɔl maakŋ jee daŋgayge tu deba kalaŋ se, ɓɔrse naase Ꞌjeki mꞋasen kɔɔɗn kɔl Gaar Yaudge se la?» ");
INSERT INTO kyq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tɛr gɔtn se naaɗe baag tɔɔyɔ ɔɔ: «Naaje kꞋje Barabas, ey num naan̰ se eyo!» Anum gaŋ Barabas se, naan̰ debm tujn̰ nakŋ jeege. ");
INSERT INTO kyq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gɔtn se, Pilat ɔl ɔɔ jꞋɔk kꞋɓaano te Isa ɔɔ kꞋtɔndin̰ ute mɛɛjɛ. ");
INSERT INTO kyq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɔɔ asgarge se, uj ɗaapo jɛkɛ gɛn kɔrɔndɔ ɓaaɗo ɔndin̰ don̰ ki, tɛr naaɗe uun uusin̰ kal gaarin̰ge aac boŋ. ");
INSERT INTO kyq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Naaɗe iiko cɛɛn̰ ki ɔɔ ɗeekin̰ ɔɔ: «Tɔɔsɛ naai ki, Gaar Yaudge!» Gɔtn se, naaɗe baagin̰ tɔnd mɛtn bin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tɛr Pilat teeco kuuy daala ɔɔ ɗeek Yaudge tu ɔɔ: «ꞋBooyki, gaabm se maam mꞋan̰o kɔɔɗn teecn̰ naatn. Taa naase aki jeele maam se mꞋɔŋ te taar ɗim kɛn naase ɔkin̰ki mindin̰ ro ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Gɔtn se Isa teeco naatn ute jɛkŋ kɔrɔndɔ don̰ ki ɔɔ te kal gaarin̰gen aac se ron̰ ki. Anum Pilat ɗeekɗen ɔɔ: «Kɛse ɓo gaabm se!» ");
INSERT INTO kyq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Num kɛn *magal jee tɛɗn sɛrkɛ Raa ki te jeeɗege jaay aakin̰ se, naaɗe baag tɔɔɗn tɔɔyɔ ɔɔ: «Naan̰ se tupu tɔɔlin̰ ro kaag ki! Tupu tɔɔlin̰ ro kaag ki!» Gaŋ Pilat taaɗɗen ɔɔ: «Naase mala ɔk ɓaa tupu Ꞌtɔɔlin̰ki ro kaag ki; ey num maam se mꞋɔŋ te taar ɗim kɛn naase ɔkin̰ki mindin̰ ro ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yaudge tɛrlin̰ ɔɔ: «Naaje se jꞋɔk *Ko Taar kɛn Raa ɛɗo Musa ki ɔɔ maakŋ Ko Taar naajege se taaɗ ɔɔ debm bin se jꞋan̰ tɔɔlɔ. Taa naan̰ tɛɗ ron̰ Goon *Raa.» ");
INSERT INTO kyq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kɛn Pilat jaay booy taarɗe se, ɓeere ɔkin̰ cir daala. ");
INSERT INTO kyq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilat tɛrl ɓaa ɔŋ Isa maak ki tɔnd mɛtin̰ ɔɔ: «Naai tap ɓo iin̰o gay?» Num gaŋ Isa baate tɛrlin̰ taara. ");
INSERT INTO kyq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Gɔtn se Pilat ɗeekin̰ ɔɔ: «Maam ara ɓo naai Ꞌbaate tɛrlum taara ne? Naai Ꞌjeel ey la kɛn maam mꞋɔk tɔɔgɔ ɔɔ kɛn mꞋje num, mꞋai kɔɔɗn kɔlɔ ɔɔ kɛn gɔtɔ lɛ mꞋɔk tɔɔgɔ kɛn mꞋai tupm tɔɔl ro kaag ki se?» ");
INSERT INTO kyq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Gaŋ Isa tɛrlin̰ ɔɔ: «Naai se kɛn Raa jaay ɛɗi eyo te tɔɔg ey se, naai ɔk tɔɔgɔ dom ki eyo. Taa naan̰ se ɓo debm ɔk ɔlum ji naai ki se, tɛɗga *kusin̰ ciri naai se daala.» ");
INSERT INTO kyq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Naan̰ kɛn se sum ɓo, Pilat je ɗoobm an kɔɔɗn kɔl Isa. Num gaŋ Yaudge baag tɔɔɗn tɔɔyɔ ɗeek ɔɔ: «Kɛn naai jaay ɔɔɗ ɔlin̰ga num, naai se mɛɗn Sezar eyo. Taa debm jaay tɛɗ ron̰ gaarge se, naan̰ se debm taamooy Sezar.» ");
INSERT INTO kyq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kɛn Pilat jaay booy taargen se naan̰ ɔl kꞋjꞋɔk kꞋjꞋɔɔɗo Isa naatn, naan̰ ɓaaɗo ɔndin̰ gɔt kɛn jꞋiin̰ kꞋɗaapin̰ga ɗaap te koa kɛn naan̰ lee ɔjn̰ bɔɔrɔ jeege tu. Gɔtn se kꞋdaŋin̰ te taar Ɛbre: Gabbata. ");
INSERT INTO kyq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aan gɔɔr te katar se, Pilat taaɗ Yaudge tu ɔɔ: «Aakki, kɛse ɓo gaarse!» Naan̰ kɛn se, naaɗe ɗaap ɗaap roɗe gɛn tɛɗn *laa Paak gɛn Yaudge tɛgɛr. ");
INSERT INTO kyq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Num gaŋ Yaudge tɛrl baag tɔɔɗn tɔɔyɔ ɔɔ: «Naan̰ se, nakin̰ yoa, naan̰ se nakin̰ yoa! ꞋƁaa tupu tɔɔlin̰ ro kaag ki gam naane!» Pilat tɛrlɗen ɔɔ: «Gaarse ɓo, naase Ꞌjeki mꞋan̰ tupm tɔɔl ro kaag ki la?» Magal jee tɛɗn sɛrkɛ Raage tu tɛrlin̰ ɔɔ: «Naaje se Gaarje Sezar sum, gaar kuuy se naaje kꞋjꞋɔk eyo!» ");
INSERT INTO kyq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gɔtn se sum ɓo, Pilat ɔk ɔlɗen Isa taa naaɗe an̰ ɓaa tupm tɔɔlin̰ ro kaag ki. Ɔɔ gɔtn se asgarge ɔk ɓaan te Isa. ");
INSERT INTO kyq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kɛn Isa teec teec maakŋ Jeruzalɛm ki se, naaɗe ɔn̰in̰ naan̰ mala uun kaagŋ jꞋansin̰ tupm ro ki se, daamin̰ ki. Ɔɔ naaɗe ɓaansin̰ gɔt kɛn kꞋdaŋin̰ kaaɗn do deba. Gɔtn se te taar *Ɛbre se, ron̰ Golgota. ");
INSERT INTO kyq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɔɔ gɔtn ese ɓo naaɗe tupin̰ ro kaag ki ɔɔ naaɗe tup jeege dio ro kaagge tu kici; deb kalaŋ jꞋuun kꞋɗaarin̰ cɛɛsin̰ kɛn kalaŋ ɔɔ deb kuuy se jꞋuun kꞋɗaarin̰ cɛɛsin̰ kɛn kuuy ɔɔ naaɗe ɔl Isa ɗaar daan ki. ");
INSERT INTO kyq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tɛr Pilat raaŋ ro kaag ki ɔl kꞋɓaa kꞋtupin̰ raan kaam do kaag kɛn kꞋtupm Isa ro ki. Ɔɔ taar naan̰ raaŋ se taaɗ ɔɔ: «Isan kɔɗ Nazarɛt se, naan̰ Gaar Yaudge». ");
INSERT INTO kyq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gaŋ dɛn Yaudge se dooyga taar se, taa gɔtn kꞋtupm Isa ro kaag ki se, naan̰ gɔɔr te Jeruzalɛm. Ɔɔ taar naan̰ raaŋin̰ se lɛ raaŋin̰ te taar Ɛbre, taar Laatin ɔɔ ute taar Grɛk kici. ");
INSERT INTO kyq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Num *magal jee tɛɗn sɛrkɛ Raa ki gɛn Yaudge se, ɗeek Pilat ki ɔɔ: «Ɔn̰te raaŋ ɔɔ: naan̰ se Gaar Yaudge, num raaŋ ɔɔ: naan̰ ɓo taaɗ ɔɔ naan̰ Gaar Yaudge.» ");
INSERT INTO kyq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Gaŋ Pilat tɛrlɗen ɔɔ: «Taar maam mꞋraaŋin̰ga se, mꞋraaŋin̰ga sum.» ");
INSERT INTO kyq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kɛn asgarge jaay tup Isa ro kaag ki aas se, naaɗe tɔs kalin̰ge ɔɔ nigin̰ gɔtɔ kaam sɔɔ. Deba kic ɓo uun bɛɗin̰ bɛɗin̰a. Ɔɔp kalin̰ kalaŋ kɛn naan̰ uusin̰ga num lee tuusin̰ kalgen kuuy do ki se, ɔɔ kal se ɔnd raan bini bɔɔy aan naaŋ ki se ɔk gɔtn kur eyo. ");
INSERT INTO kyq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Gɔtn se asgarge taaɗ te naapa ɔɔ: «Kal se jꞋɔn̰te Ꞌnɛɛpin̰ki, num gaŋ kꞋtɛɗin̰ salatia, debm kɛn oocin̰ga ɓo Ꞌkuun sum.» Anum nakŋ se aanga ɗoobin̰ ki aan gɔɔ taar kꞋraaŋo do dɔkin̰ kɛn ɔɔ: Naaɗe nigga kalumge ute naapa, ɔɔ kalum maak ki se lɛ, naaɗe tɛɗin̰ga salatia. Ɔɔ kɛse ɓo naabm kɛn asgarge tɛɗa. ");
INSERT INTO kyq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cɛɛ kaag kɛn kꞋtupm Isa se, ko Isa ute gɛnaan̰ mɛnda, ɔɔ Mari mɛnd Kleopas ute Mari kɛn iin̰o Magdala ki, naaɗe utu ɗaar gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gɔtn se, Isa aak kon̰a ɗaar ɗaar cɛɛ debm mɛtin̰ kɛn naan̰ jen̰ se, naan̰ ɗeek kon̰ ki ɔɔ: «Kaaya aaka, kɛse ɓo gooni.» ");
INSERT INTO kyq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tɛr naan̰ taaɗ deb kɛn mɛtin̰ ki se, ɔɔ: «Aaka, kɛse ɓo koi.» Ɓii kɛn se sum ɓo debm mɛtn Isa ki se ɔk ɓaansin̰ ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kɛn nakgen se jaay deel paac sum se, aan gɔɔ Isa jeel naabm kɛn naan̰ ɓaano ro ki se naŋga, num taa taar kꞋraaŋo do dɔkin̰ Ꞌkaan ɗoobin̰ ki se, naan̰ ɗeek ɔɔ: «Maam se, maane tɔɔluma.» ");
INSERT INTO kyq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gɔt kɛn se ɔk kꞋjɛlɛŋɛ ɗooc te tɔtn koojn̰ bin̰ kɛn mooyo se. Naaɗe uuno kaagŋ nakŋ kꞋdaŋin̰ isop ɔɔ uuno nakŋ uun maane se butin̰ taar ki. Naaɗe ɔlin̰ maakŋ tɔtn koojn̰ bin̰ kɛn mooy mooy se ɔɔ uun ɔlin̰ taar Isa ki taa n̰Ꞌsuubu. ");
INSERT INTO kyq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kɛn Isa jaay suub naam tɔtn koojn̰ bin̰ kɛn mooy mooy se, naan̰ taaɗ ɔɔ: «Naabum aasga.» Gɔtn se naan̰ no don̰a ɔɔ ɔn̰ kon̰ teece. ");
INSERT INTO kyq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aan gɔɔ ɓiin se Yaudge ɗaap ɗaap roɗe gɛn tɛɗn *laa Paak se, naaɗe je jee kꞋtupɗe ro kaage tu se, ɗaar bini kaan *ɓii sebit ki eyo. Taa ɓii sebit ese se, ɓii laa magala. Gɔtn se naaɗe ɓaa tɔnd mɛtn Pilat ɔɔ: «Jee kɛn kꞋtupɗe ro kaagge tun se, kꞋɓaa kꞋtɔnd kꞋtɛrɛcɗen jɛɗege taa ooyga num jꞋaɗeno tɔɔɗn bɔɔy ro kaagge tun kꞋtupɗeno ro ki se.» ");
INSERT INTO kyq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɔɔ gɔtn se asgarge ɓaaɗo tɔnd tɛrɛc jɛ gaabm kɛn deete ɔɔ tɛr tɔnd tɛrɛc jɛ gaabm kɛn kuuy se kici. Jee se ɓo kɛn kꞋtup kꞋtɔɔlɗe te Isa kalaŋ se. ");
INSERT INTO kyq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kɛn naaɗe jaay aan do Isa ki se, naaɗe ɔŋin̰ naan̰ ooyga. Taa naan̰ se ɓo naaɗe baate tɔnd tɛrɛcn̰ jɛn̰ge. ");
INSERT INTO kyq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gaŋ maakŋ asgarge tun se, deb kalaŋ uuno bɔɔrɔ ɔɔ ɔsin̰ cɛŋkɛn̰ ki. Gɔtn se mooso te maane naar teeco. ");
INSERT INTO kyq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Debm taaɗ taar ara se, naan̰ mala aakin̰ga te kaamin̰a ɔɔ saaɗn naan̰ se, taar mɛt ki. Ɔɔ naan̰ jeele saaɗn naan̰ se kɛn mɛt ki, taa bin se naase kic ɓo aki tookŋ do taar kɛn naan̰ taaɗ se. ");
INSERT INTO kyq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nakgen se paac jaay aan se, taa taar kꞋraaŋo do dɔkin̰ se, Ꞌkaan ɗoobin̰ ki kɛn ɔɔ: Naan̰ se jꞋan̰ kɔŋ tɛrɛcn̰ cɛŋgin̰ gam eyo. ");
INSERT INTO kyq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɔɔ tɛrl gɔt kuuy kic ɓo taar kꞋraaŋo do dɔkin̰ se taaɗga ɔɔ: Jee ɔsin̰o se, naaɗe utu an̰ kaakŋ ute kaamɗe. ");
INSERT INTO kyq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kɛn nakgen se jaay deel se, Yusup kɔɗ Arimate se, naan̰ kic maakŋ jeege tun mɛtn Isa ki naɓo taa Yaudge se, naan̰ ɓeere ɔɔ tɔy tɔy ron̰a. Naan̰ ɓo ɓaa tɔnd mɛtn Pilat taa ɓaa kɔɔɗn ro Isa ro kaag ki. Gɔtn se Pilat tookin̰, ɔn̰ Yusup ɓaa ɔɔɗ ro Isa. ");
INSERT INTO kyq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ɔɔ Nikodem kɛn ɓii kalaŋ iŋgo gɔtn Isa ki nɔɔr se, naan̰ kic ɓaano te itir kɛn kꞋtɛɗin̰ te maan kaagŋ kꞋdaŋin̰ mir ute alues se aas ɓaa ɓaa ɗoocn̰ kɔr sik‑kaar‑mii. ");
INSERT INTO kyq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yusup te Nikodem se uun bɔɔyɔ ro Isa se ro kaag ki. Ɔɔ uuno darkɔyɔ ɔɔ tɛɗin̰ nakŋ oot nijimi ute itir se ro ki ɔɔ naaɗe teelin̰ tec aan gɔɔ gɛn Yaudgen lee duubm yoɗege. ");
INSERT INTO kyq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gɔtn kꞋtupm Isa ro kaag ki se, gɔtn se ɔk jinɛnɛ ɔɔ maakŋ jinɛn kɛn se, ɔk ɓaaɗa ɔɔ ɓaaɗn se aan gɔɔ iiɓi, taarin̰ se naaɗe gaasin̰ ute koa. Ɓaaɗn se jꞋɔl kꞋnaam te nam maak ki eyo. ");
INSERT INTO kyq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aan gɔɔ Yaudge ɗaap ɗaap roɗe gɛn tɛɗn *laa Paak se, gɔtn ese kic lɛ, ɓaaɗa utu gɔɔr te naaɗe ɗey se, naaɗe uun ɔl ro Isa maak ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɓii dumas ki, tanɔɔrin̰ nɔɔrin̰ kɛn gɔtɔ utu ilim sum ɓo, Mari kɛn iin̰o Magdala ki iin̰ ɓaa taa ɓaaɗ ki. Kɛn naan̰ aan se, aak ko kɛn kꞋgaasn taa ɓaaɗ se, kꞋdircilin̰ga naatn. ");
INSERT INTO kyq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gɔtn se naan̰ ɔk tɛrl aan̰ ɓaa ɔŋ Simon Piɛr ute debm mɛtn Isa kɛn kuuy kɛn Isa jen̰ se, naan̰ ɗeekɗen ɔɔ: «Mɛljege se, nam ɔɔɗin̰ga naatn maakŋ ɓaaɗ ki, ɔɔ gɔtn kꞋɓaa jꞋɔlin̰ se naaje kꞋjeel gɔtin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kɛn Piɛr ute debm mɛtn Isa kɛn kuuy jaay booy taar se, gɔtn se naaɗe teeco ɔɔ iin̰ ɓaa taa ɓaaɗ ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kɛn naaɗe jaay ɓaa ɓaa se, naaɗe di paac aan̰ kaan̰a, naɓo debm mɛtn Isa kɛn kuuy se, aan̰ deel Piɛr ɔɔ naan̰ ɓo ɓaa aan deet taa ɓaaɗ ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɔɔ kɛn naan̰ jaay aan se no aak maakŋ ɓaaɗa, naan̰ aak kalgen kꞋteelsin̰ se, utu tooɗ gɔtin̰ ki gaŋ naan̰ baate kɛnd maak ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Anum kɛn Simon Piɛr kɛn aan̰o mɛtin̰ ki jaay aan se, naan̰ ɛnd maakŋ ɓaaɗ ki. Ɔɔ naan̰ kic aak kalgen kꞋteelsin̰ se tooɗ tooɗ gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɔɔ naan̰ aak kal kꞋteelin̰ kaamin̰ se ɓo, tooɗ te kalgen kꞋteelin̰ ron̰ ki se kalaŋ eyo. Kal kꞋteelin̰ kaamin̰ se, naan̰ aakin̰ kꞋteel jꞋaalin̰ga cɛɛs ki. ");
INSERT INTO kyq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naan̰ kɛn se jaay debm mɛtn Isa kɛn aan̰ aan deet se, naan̰ kic ɛnd maakŋ ɓaaɗ ki se. Naan̰ aaka ɔɔ took aal maakin̰ paac. ");
INSERT INTO kyq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ey num jee mɛtn Isa ki se, booy ɔk te ey ɓɔrtɔ taar kɛn kꞋraaŋin̰o do dɔkin̰ kɛn ɗeek ɔɔ: Isa se, bɛɛki num, aɗe dur daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gɔtn se sum ɓo jee mɛtn Isa kɛn di se ɔk tɛrl ɓaa ɓeeɗege tu. ");
INSERT INTO kyq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Gaŋ Mari ɗaar eem taa ɓaaɗ ki ɔɔ maakŋ keemin̰ ki se naan̰ no aak maakŋ ɓaaɗa. ");
INSERT INTO kyq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɔɔ naan̰ aak *kɔɗn Raage dio iŋg kiŋg te kalɗege raap raapo, gɔtn kꞋjꞋaalno ro Isa ro ki se. Deb kalaŋ iŋg kaam don̰ ki ɔɔ deb kalaŋ iŋg kaam gɔtn jɛn̰ge tu. ");
INSERT INTO kyq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Naaɗe ɗeek Mari ki ɔɔ: «Mɛnd ara, naai eem gɛn ɗio?» Naan̰ tɛrlɗen ɔɔ: «Mɛlum se nam ɔɔɗin̰ga naata ɔɔ gɔtn kꞋɓaa kꞋjꞋɔl kꞋjꞋaalsin̰ ro ki se lɛ, maam mꞋjeel eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kɛn naan̰ utu taaɗ taaɗ jaay tɛrl aak bin se, naan̰ aak Isa ɗaar ɗaar gɔtn ese. Naɓo naan̰ aak jeelin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Gɔtn se Isa tɔnd mɛtin̰ ɔɔ: «Mɛnd ara, naai eem gɛn ɗio? Naai Ꞌje naŋa?» Num gaŋ Mari jaay aakin̰ se, naan̰ saap ɔɔ daan debm bɔɔbm jinɛnɛ se lɛ ɗaam. Gɔtn se naan̰ taaɗin̰ ɔɔ: «Gaabm ara kɛn naai ɓo ɔɔɗin̰ga lɛ, taaɗum gɔtin̰ kɛn naai aalsin̰ ro ki se ɔɔ maam mꞋan̰ ɓaa kuunu.» ");
INSERT INTO kyq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Gaŋ Isa daŋin̰ ron̰ ki ɔɔ: «Mari.» Ɔɔ Mari tɛrl aakin̰a ɔɔ ɗeekin̰ te taar *Ɛbre ɔɔ: Raabuni. Kɛse je ɗeekŋ ɔɔ: Debm dooy jeege. ");
INSERT INTO kyq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Gɔtn se Isa ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌkɔkuma, taa maam mꞋookŋ mꞋɓaa te gɔtn Bubum ki ey ɓɔrtɔ. Num naai se, Ꞌɓaa ɔŋ gɛnaamge se Ꞌtaaɗɗen ɔɔ, maam se mꞋookŋ mꞋɓaa ɓaa gɔtn Bubum ki, ɔɔ Bubum se, Bubm naase kici, ɔɔ mꞋɓaa ɓaa gɔtn Raam ki ɔɔ mꞋRaam se *Raa naase kici.» ");
INSERT INTO kyq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Gaŋ naan̰ kɛn se jaay ɓo, Mari kɛn iin̰o Magdala ki se ɓaa ɔŋ jee mɛtn Isa ki se taaɗɗen ɔɔ: «Maam se mꞋaakiga Mɛljege utu kaamuma. Ɔɔ Ꞌbooyki kɛse ɓo taar kɛn naan̰ taaɗumo.» ");
INSERT INTO kyq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɓii dumas kɛn se sum ɓo aan tɛgɛrin̰ ki se, jee mɛtn Isa ki se, ɛnd maakŋ ɓee ki ɔɔ ɗɛkɛl taara doɗe ki, taa naaɗe ɓeer ɓeer magal Yaudge tu. Gɔtn se naaɗe aak Isa mala ɓaaɗo ɗaar daanɗe ki. Ɔɔ naan̰ ɗeekɗen ɔɔ: «Ɔn̰ tɔɔsn Raa se Ꞌtɛɗn te naase!» ");
INSERT INTO kyq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kɛn naan̰ utu ɗaar taaɗɗen taaɗ se, gɔtn se naan̰ tuun taaɗɗen jin̰ge ute gɔtn cɛŋkɛn̰a. Kɛn jee mɛtin̰ ki jaay aak Mɛljege se maakɗe raap aak eyo. ");
INSERT INTO kyq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tɛr Isa ɗeekɗen daala ɔɔ: «Raa asen kɛɗn tɔɔsin̰a. Aan gɔɔ Bu ɔlumo do naaŋ ki se, maam kic mꞋɔlsen naase.» ");
INSERT INTO kyq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kɛn Isa jaay taaɗ naŋ taarin̰ se, naan̰ iiɓɗen kuulu doɗe ki ɔɔ ɗeekɗen ɔɔ: «Ɔkki *Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jee kɛn tɛɗga nakŋ *kusin̰ jaay naase Ꞌtɛɗɗekiga kalɗɛ se, Raa kic aɗen tɔɔl kusin̰ɗege. Ɔɔ jeegen naase ɔŋ Ꞌtɛɗɗeki te kalɗɛ ey lɛ, Raa kic aɗen kɔŋ tɔɔl kusin̰ɗege ey kici.» ");
INSERT INTO kyq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Gaŋ ɓii kɛn Isa jaay ɓaaɗo ɔŋ jeen̰gen mɛtin̰ ki maakŋ ɓee ki se, Tɔma kɛn kꞋdaŋin̰ Didim kɛn maakŋ jee mɛtin̰ kɛn sik‑kaar‑di se, gɔtɔ te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jee mɛtn Isa kɛn kuuy se, ɓaa taaɗ Tɔma ki ɔɔ: «Naaje se jꞋaakkiga Mɛljege utu kaamje!» Gaŋ Tɔma tɛrlɗen ɔɔ: «Kɛn maam jaay mꞋaak te dɔl kɛn kꞋtupin̰ te ponto jin̰ ki eyo, ɔɔ mꞋɔl jim mꞋnaam te gɔtin̰ eyo ɔɔ tɛrl cɛŋkɛn̰ ki jaay mꞋɔl jim naamin̰ te ey se, maam kɔŋ tookŋ taarse se eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kɛn aan ɓii dumas kɛn kuuy se, jee mɛtn Isa ki ɓaaɗo tus maakŋ ɓee kɛn se daala. Ɓii kɛn se Tɔma kic ɓo utu te naaɗe. Kɛn Isa ɔŋɗe se kaam taarɗe kꞋɗɛkɛlin̰ga ɗɛkɛlɛ. Naan̰ naar ɗaar daanɗe ki ɔɔ ɗeekɗen ɔɔ: «Raa asen kɛɗn tɔɔsin̰a.» ");
INSERT INTO kyq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tɛr Isa ɗeek Tɔma ki ɔɔ: «Aak jimge, ɔɔ ɔl ji naam gɔtin̰a. Tɛr ɔl ji naam cɛŋkɛma. Ɔn̰te naajn̰ taara num aal maaki dom ki.» ");
INSERT INTO kyq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tɔma tɛrlin̰ ɔɔ: «Naai se Mɛluma ɔɔ Raama!» ");
INSERT INTO kyq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Gaŋ Isa tɛrlin̰ ɔɔ: «Naai aal maaki dom ki se taa naai aakumga kaaka. Num maak‑raapo jeege tun aakum te ey jaay ɓo, aal maakɗe dom ki se.» ");
INSERT INTO kyq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isa se tɛɗga nakŋ‑kɔɔɓgen kuuy dɛna naan jeege tun mɛtin̰ ki. Naɓo kɛngen mɛtin̰ge se jꞋɔŋ kꞋraaŋɗen te maakŋ Kitap kɛn ese se eyo. ");
INSERT INTO kyq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Num nakgen kꞋraaŋin̰ maakŋ Kitap kɛn ese se, taa asen kɔl naase aki jeele Isa se, naan̰ ɓo *al‑Masi, Goon Raa. Ɔɔ kɛn naase jaay aalki maakse don̰ ki se, naase aki kɔŋ kaaja ute ro naan̰a. ");
INSERT INTO kyq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kɛn nakgen se jaay deel se, Isa tɛrl ɓaaɗo teec naan jeen̰ge tun mɛtin̰ ki taa baar kɛn kꞋdaŋin̰ Tiberiad. ꞋBooyki tɛɗ ɔɔ ɗi jaay naan̰ teec naanɗe ki se. ");
INSERT INTO kyq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jee gɔtn ese se naaɗe Simon Piɛr ute Tɔma rɔŋɔ se, Natanaɛl kɔɗ Kana kɛn iin̰o taa naaŋ Galile ki, gaan Zebedege ute jee mɛtn Isa kɛn kuuy dio. Naaɗe se iŋg kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Num gaŋ Simon Piɛr ɗeekɗen ɔɔ: «Maam se mꞋɓaa ɓaa tɔkŋ kɛn̰jɛ.» Naaɗe tɛrlin̰ ɔɔ: «Bin num naaje kic kꞋɓaa te naai.» Naaɗe teec ɓaa ook maakŋ markab ki. Num kɛn naaɗe jaay aan se, maakŋ nɔɔr kɛn te magalin̰ se, naaɗe je kɛn̰jge bini ɔŋ te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kɛn gɔtɔ jaay iip tɔɔk se, naaɗe aak Isa ɗaar ɗaar do jɛŋ baar ki. Naɓo jee mɛtin̰ ki se aakin̰a ɔɔ aak jeelin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Gaŋ Isa ɗeekɗen ɔɔ: «Naase gaange, kɛn̰jɛ cɔkɔ kic naase ɔkki ey ɗaamo?» Naaɗe tɛrlin̰ ɔɔ: «JꞋɔk eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gɔtn se naan̰ ɗeekɗen ɔɔ: «Uun undki gɛndse se kaam do ji daam aak markaba. Gɔtn se ɓo naase aki kɔŋɔ.» Naaɗe und gɛndɗe ɔɔ tɔsɔ maakŋ gɛndɗe ki se, kɛn̰jɛ dɛna num gɛn kiikin̰ kic ɓo naaɗe ɔŋ iikin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Gɔtn se debm mɛtn Isa kɛn Isa jen̰ se, ɗeek Piɛr ki ɔɔ: «Kɛse Mɛljege!» Ɔɔ kɛn Simon Piɛr jaay booy jꞋɔɔ kɛse Mɛljege se, naan̰ ɔɔɗga kɔɔɗ kalin̰ kic ɓo, uun uusin̰ gɔtin̰ ki, dɔɔk maakin̰ jaay aal ooc maan taa an̰ ɓaa kɔŋɔ. ");
INSERT INTO kyq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kaaɗ kɛn se, jee mɛtn Isa kɛn kuuy se, naaɗe kic ɔɔpɗenga gɔɔr kaam tal cili‑kaar‑di sum ɓo, kookŋ kaan jɛŋ ki. Kɛn naaɗe jaay ɓaaɗo ɓaa te markabɗe se, tiiko gɛndɗen kɛn ɗooc te kɛn̰jɛ se. ");
INSERT INTO kyq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kɛn naaɗe jaay aan taa baar ki se, bɔɔy naaŋ ki ɔɔ gɔtn se naaɗe aak naal pooɗo, ɔɔ do naal pooɗ kɛn se kꞋnaŋ naŋ kɛn̰jɛ ɔɔ naaɗe aak mappa gɔtn ese kici. ");
INSERT INTO kyq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Num Isa ɗeekɗen ɔɔ: «Kɛn̰jgen naase Ꞌtɔkkiro se, Ꞌɓaankiro kandum.» ");
INSERT INTO kyq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Gɔtn se Simon Piɛr ook maakŋ markab ki ɔɔ tiiko gɛnd ɗooc te kɛn̰jɛ se ɓaano do jɛŋ ki. Ɔɔ kɛn̰j maakŋ gɛnd kɛn se, kꞋmɛt kꞋjꞋɔŋin̰ kɛn̰jgen magal magal salal ɓo kaar‑te‑si‑mii‑kaar‑mɔtɔ. Ɔɔ te dɛn kɛn̰jgen ese se kic ɓo, gɛndɗe nɛɛp te eyo. ");
INSERT INTO kyq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isa ɗeekɗen ɔɔ: «ꞋƁaakiro aki kɔsɔ.» Gɔtn se jee mɛtin̰ ki paac se, nam jaay Ꞌtɔnd mɛtin̰ ɔɔ: «Naai naŋa» kic ɓo gɔtɔ. Taa Mɛljege se, naaɗe paac aak jeelin̰ga. ");
INSERT INTO kyq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isa ɓaaɗo ɔŋɗe ɔɔ uun mappa se nigɗesin̰a, tɛr kɛn̰jɛ se kic naan̰ uun nigɗesin̰a. ");
INSERT INTO kyq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kɛn Isa jaay duro daan yoge tu se, te naan̰ se naan̰ teec ɗɔɔlga mɔtɔ naan jeege tun mɛtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kɛn naaɗe jaay ɔs aas sum se, Isa ɗeek Simon Piɛr ki ɔɔ: «Simon goon Jan, naai Ꞌjem te maaki cir jee se paac la?» Gɔtn se Simon tɛrlin̰ ɔɔ: «Yɛɛ Mɛluma, naai Ꞌjeele kɛn mꞋjei se.» Isa tɛrlin̰ ɔɔ: «ꞋGaamum gaan baatumge.» ");
INSERT INTO kyq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tɛr naan̰ ɗeekin̰ gɛn k‑dige ɔɔ: «Simon goon Jan, naai Ꞌjem te maaki paac la?» Naan̰ tɛrlin̰ ɔɔ: «Yɛɛ Mɛluma, naai Ꞌjeele kɛn maam mꞋjei se.» Isa ɗeekin̰ ɔɔ: «ꞋTɛɗn debm gaam baatumge.» ");
INSERT INTO kyq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tɛr Isa ɗeekin̰ gɛn k‑mɔtɔge tu daala ɔɔ: «Simon goon Jan, naai Ꞌjem la?» Gɔtn se Piɛr maakin̰ tuj se ro kɛn kɛn Isa tɔnd mɛtin̰ ɗɔɔlin̰ mɔtɔ ɔɔ: «Naai Ꞌjem la, Ꞌjem la se?» Gɔtn se Piɛr tɛrlin̰ ɔɔ: «Mɛluma, naai Ꞌjeel nakge paac ɔɔ Ꞌjeelum maam se, mꞋjei.» Tɛr Isa ɗeekin̰ ɔɔ: «ꞋGaamum baatumge. ");
INSERT INTO kyq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ꞋBooy bɛɛ mꞋai taaɗa: kɛn naai utu goon kɔɗɔ se, naai mala ɓo tuus kali ɔɔ Ꞌdɔɔk maaki ɔɔ gɔtn naai maaki je ɓo ɓaa sum. Num kɛn naai jaay ɓaaɗo gɔɔlga num, utu kuun ji raan nam kuuy ɓo utu ai dɔɔkŋ maaki ɔɔ ai ɓaa kɔli gɔt kɛn naai maaki je eyo.» ");
INSERT INTO kyq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kɛn Isa jaay taaɗ bin se je taaɗn ɔɔ Piɛr se ute ɗoobm gay jꞋutu jꞋan̰ tɔɔlɔ ɔɔ yo naan̰ se utu *nookŋ *Raa. Do taar kɛn se, tɛr Isa taaɗin̰ ɔɔ: «Naai se ɔk mɛtuma.» ");
INSERT INTO kyq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Gɔtn se Piɛr tɛrl aak mɛtin̰ ki se, naan̰ aak debm mɛtn Isa kɛn Isa jen̰ se utu ɓaaɗo mɛtɗe ki. Naan̰ se ɓo kaaɗ kɛn naaɗe ɔso kɔs jaay naan̰ dɛjo kaaɗn Isa ki ɔɔ ɗeekin̰o ɔɔ: «Mɛlje, kɛn utu ai kuti se naŋa?» ");
INSERT INTO kyq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kɛn Piɛr jaay aakin̰ se, ɗeek Isa ki ɔɔ: «Mɛlje, naan̰ se ɗi an̰ kaan don̰ ki kaca?» ");
INSERT INTO kyq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Gaŋ Isa tɛrlin̰ ɔɔ: «Naan̰ se, kɛn maam je mꞋan̰ kɔn̰in̰ Ꞌtiŋg bini maam mꞋutu mꞋaɗe ɓaa kic num, naai se ɔli ɗio? Naai se, Ꞌɓaaɗo Ꞌdaanuma.» ");
INSERT INTO kyq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Taar se jaay gɛnaage ɓaa booyin̰ se, naaɗe taaɗ ɔɔ: «Debm mɛtn Isa kɛn ese se Ꞌkooy ey sum.» Num gaŋ taar kɛn ɔɔ naan̰ Ꞌkooy ey sum se, ɗeer num, Isa taaɗ te bini eyo. Num naan̰ taaɗ ɔɔ: «Kɛn maam je mꞋan̰ kɔn̰in̰ tiŋg bini maam mꞋutu mꞋaɗe ɓaa kic num, naai se ɔli ɗi?» ");
INSERT INTO kyq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Debm kɛn taaɗ nakgen se ɔɔ jaay raaŋin̰ paac se, naan̰ se ɓo debm mɛtn Isa kɛn ese. Naaje kꞋjeele saaɗn naan̰ se, saaɗn mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isa se tɛɗga nakge kuuy kic ɓo dɛna. Nakgen se jaay kꞋraaŋin̰ paac kalaŋ kalaŋ ɔɔ kꞋdirig te kalaŋ ey se, maam mꞋjeele taargen kꞋraaŋo se do naaŋa te magalin̰ kic ɓo an̰ kɔŋ kɔk eyo.");
INSERT INTO kyq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopil, maakŋ kitapum kɛn deet deet se, maam mꞋraaŋio mɛtn taar nakgen paacn̰ kɛn Isa tɛɗo ute taargen naan̰ lee dooyno jeege do kupm mɛt ki se, ");
INSERT INTO kyq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bini ɓii kɛn Raa uun ɓaansin̰ maakŋ raa ki. Kɛn naan̰ ook ɓaa te maakŋ raa ki ey ɓɔrt se, naan̰ bɛɛr tɔɔɗo jeege kɛn an̰ tɛɗn jee kaan̰ naabin̰ge, ɔɔ ute tɔɔgŋ Nirl Salal se, naan̰ taaɗɗen nakŋ kɛn naaɗe Ꞌtɛɗa. ");
INSERT INTO kyq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kɛn naan̰ ooy jaay duro daan yoge tu se, daan ɓiige tun si‑sɔɔ se, naan̰ lee teec naan jeege tun mɛtin̰ ki ɔɔ taaɗɗen ute ɗoobm nakge dɛna ɔɔ taaɗ ron̰a ɔɔ naan̰ utu te kaamin̰a. Gɔtn se naan̰ taaɗɗen mɛtn taar *maakŋ Gaar Raa. ");
INSERT INTO kyq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɓii kalaŋ kɛn naan̰ jaay iŋg ɔs kɔs ute naaɗe se, naan̰ taaɗɗen ɔɔ jꞋɔn̰te teecn̰ kɔn̰ maakŋ gɛgɛr kɛn Jeruzalɛm se, num gaŋ kꞋjꞋaak kaam nakŋ kɛn Raa Bubu taaɗɗeno ɔɔ utu aɗeno kɛɗ se. Kɛse ɓo nakŋ kɛn naan̰ taaɗɗeno ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","«Jan se *batizo jeege te maane; num gaŋ naase se, ɔɔpga ɓii kandum se, jꞋutu jꞋasen *batizn ute Nirl Salal.» ");
INSERT INTO kyq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jee kɛn tus iŋg cɛɛ Isa ki se, tɔnd mɛtin̰ ɔɔ: «Mɛlje, ɓɔrse ɓo kaaɗn kɛn naai utu Ꞌkɛɗn gaara *Israɛlge tu gɔtin̰ ki la?» ");
INSERT INTO kyq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isa tɛrlɗen ɔɔ: «Gɛn kaaɗin̰ ute ɓiin̰ se, Raa Bubu ute tɔɔgin̰ se, naan̰ kalin̰ ki sum ɓo jeele. Num naase se, Raa undse te kulu gɛn jeel kaaɗn kɛn ese eyo. ");
INSERT INTO kyq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gaŋ Raa utu asen kɛɗn tɔɔgŋ *Nirl Salal kɛn utu aɗe bɔɔy dose ki. Gɔtn se aki tɛɗn saaɗumge maakŋ gɛgɛr kɛn Jeruzalɛm ki, taa naaŋ Jude te magalin̰a, taa naaŋ *Samari ɔɔ bini gɔtn duni Ꞌɗaar ro ki.» ");
INSERT INTO kyq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kɛn jaay Isa taaɗ naŋ taarin̰ se, Raa uun ɓaansin̰ maakŋ raa ki. Kaaɗ kɛn jaay naaɗe te ɗaar ɔnd doɗe raan utu aakin̰ kaak se, gapara naar ɓaaɗo ɔyin̰a ɔɔ gɔtn se naaɗe ɔŋ aakin̰ ey sum. ");
INSERT INTO kyq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kaaɗ kɛn naaɗe utu ɗaar aakin̰ kaak kɛn naan̰ ook kook maakŋ raa ki se, gɔtn se naaɗe naar aak gaabge dio ɗaar ɗaar cɛɛɗe ki ute kalɗege raap lak lak, ");
INSERT INTO kyq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ɔɔ naaɗe ɗeekɗen ɔɔ: «Naase, jee taa naaŋ Galile ki, taa ɗi jaay naase Ꞌɗaar aakki raan maakŋ raa ki se? Isan, Raa uunin̰ daanse ki jaay ɓaansin̰ maakŋ raa ki se, utu aɗe tɛrl aan gɔɔ kɛn naase Ꞌɗaar aakin̰ki naan̰ ook ɓaa ɓaa maakŋ raa ki se kici.» ");
INSERT INTO kyq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Gɔtn se, jee mɛtn Isa ki iin̰ ɔn̰ do *kɔsn ɔlib se ɔɔ naaɗe ɔk tɛrl ɓaaɗo Jeruzalɛm ki. Jeruzalɛm ute kɔsn ɔlib se, daanin̰ aas nakŋ kilɔmɛtir kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kɛn naaɗe jaay aan Jeruzalɛm ki se, naaɗe ɓaa ɓeene. Gɔtn se naaɗe ook ɓaa ɛnd maakŋ ɓee kɛn do ɓee ki raan. Gɔtn se ɓo, gɔtn naaɗe lee tusni. Naaɗe se Piɛr, Jan, Jak ute Andre, Pilip ute Tɔma, Bartelemi ute Matiye, Jakŋ goon Alpe, Simon kɛn je kujn̰ naaŋin̰a ute Judn kɛn goon Jak. ");
INSERT INTO kyq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naaɗe paac maakɗe kalaŋ ɔɔ ɓii‑raa naaɗe tus gɛn keem Raa ute mɛndge kandum, daanɗe ki se Mari ko Isa ɔɔ ute gɛnaa Isage kici. ");
INSERT INTO kyq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Maakŋ ɓiige tun ese se, ɓii kalaŋ gɛnaagen aalga kaal maakɗe do Isa ki, naaɗe tus jeege ɓaa ɓaa nakŋ kaar‑ute‑si‑dio. Gɔtn se Piɛr iin̰ ɗaar daanɗe ki ɔɔ taaɗɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","«Gɛnaage, Ꞌjeelki Judas se naan̰ debm naajege, ey num naan̰ kic ɔk naaba daanjege tu kici. Naɓo mɛtn taar Judas se, ɓugjege *Daud kic ɓo taaɗoga taaɗ taarin̰a do dɔkin̰a. Naan̰ ɓo debm deelo naan jeege tu ɔɔ ɓaaɗo ɔl kꞋjꞋɔk Isa se. Bin ɓo, taar kɛn *Nirl Salal ɔl Daud taaɗin̰o jaay kꞋraaŋin̰ maakŋ Kitap ki se, aanga ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas ute gursn kɛn jꞋɔgin̰ gɛn kutn Isa se, naan̰ ɓaa dugŋ maakŋ‑gɔtɔ. Ɔɔ gɔtn se, naan̰ ɓaa ooc uɗ te mindin̰a ɔɔ gɔtn se maakin̰ ɔɔp pak ɔɔ tiikin̰ge ru naaŋ ki. ");
INSERT INTO kyq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nakŋ aan do Judas ki se, jee Jeruzalɛm ki paac booyin̰ga. Taa naan̰ se ɓo maakŋ‑gɔtn ese se, naaɗe daŋin̰ ute taar naaŋɗe ɔɔ: Akeldama. Akeldama se je ɗeekŋ ɔɔ: maakŋ‑gɔtn gɛn mooso. ");
INSERT INTO kyq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kɛse ɓo taar kɛn ɓugjege Daud raaŋin̰o ro Judas ki maakŋ Kaa Keem Raa ki kɛn ɔɔ: Ɔn̰ ɓee naan̰ se Ꞌtooɗn kuuɗu ɔɔ mɔɔtn nam Ꞌkiŋg maak ki eyo, ɔɔ tɛr naan̰ raaŋo daala ɔɔ: Naabm naan̰ se ɔn̰ nam kuuy an̰ kuunu. ");
INSERT INTO kyq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Bin num, maakŋ jeege tun leeɗoga ute naajege kaaɗ kɛn kꞋleekiro mɛtn Mɛljege Isa ki, ");
INSERT INTO kyq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","jee kɛn baago lee ute naajege gɔtn kɛn Jan *batizno Isa bini aan ɓii kɛn Raa uun ɓaan̰sin̰ maakŋ raa ki se; ɔɔ jee se kɛn Isa jaay ooy duro daan yoge tu se, naaɗe aakin̰ga ute kaamɗe. Kɛn bin num maakɗe ki se, kꞋbɛɛr kꞋjꞋuunki deb kalaŋ kɛn utu kɛnd gɔɔ Judas ki, taa Ꞌtɛɗn saaɗa ute naajege.» ");
INSERT INTO kyq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kɛn naaɗe jaay booy taar Piɛr se, naaɗe tɔɔɗo jeege dio: deb kalaŋ ron̰ Yusupm kɛn kꞋdaŋin̰ Barsabas ɔɔ kɛn jeege lee daŋin̰ te ro Justus kici ɔɔ deb kuuy se kꞋdaŋin̰ Matias. ");
INSERT INTO kyq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gɔtn se naaɗe tɔnd mɛtn Raa ɔɔ: «Mɛlje, naai ɓo debm kɛn Ꞌjeel nakŋ maakŋ jeege tu paac. Maakŋ jeege tun di se, debm kɛn naai Ꞌbɛɛr ɔɔɗin̰ se, Ꞌtaaɗjesin̰a, ");
INSERT INTO kyq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","taa naan̰ Ꞌkɛnd gɔɔ Judas ki ɔɔ Ꞌtɛɗn *debm kaan̰ naabm Isa al‑Masi. Anum Judas se lɛ, naan̰ mala ɓo rɛs ɔn̰ naabin̰a ɔɔ ɓaaga gɔtn kɛn dɔɔɗin̰ naan̰ ki.» ");
INSERT INTO kyq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gɔtn se naaɗe tɛɗ salatia ɔɔ salatia se ooc do Matias ki. Naan̰ kɛn se sum ɓo, Matias se tum do *jee kaan̰ naabm Isage tun sik‑kaar‑kalaŋ se. ");
INSERT INTO kyq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kɛn ɓii gɛn tɛɗn laa kꞋdaŋin̰ Pantekɔt jaay aan se, ɓii kɛn se jee aal maakɗe do Isa *al‑Masi ki se tusga paac gɔtɔ kaam kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gɔtn se naaɗe naar booy naka maakŋ raa ki eemo uu uu aan gɔɔ kuul kɛn ɔl makɔn̰ɔ ɔɔ ɓaaɗo ɛnd maakŋ ɓee kɛn naaɗe tusn maak ki se ɔɔ gɔtɔ se, tɛɗ dir dir. ");
INSERT INTO kyq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tɛr naaɗe aak ne ɗimge se tec aan gɔɔ rɔɔn̰ pooɗge bɔɔy ɓaaɗo wɔɔk tis doɗege tu. ");
INSERT INTO kyq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Gɔtn se Nirl Salal ɓaaɗo ɛnd ɗooc maakɗe ɔɔ naaɗe baag taaɗn taar naaŋ jee kuuyu. Kɛse Nirl Salal ɓo ɔlɗe naaɗe taaɗ taar naaŋgen se. ");
INSERT INTO kyq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɓii kɛn se, Yaudgen ɔk ɗoobm taar Raaɗe ɔɔn̰ se iin̰o gɔtn ɓaa se paac ɔɔ ɓaaɗo Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kɛn jee se jaay booy nakŋ tɛɗ dir dir se, naaɗe ɓaaɗo tus dɛna gɔtn se. Ɔɔ kɛn naaɗe jaay booy jee aal maakɗe do Isa al‑Masi ki jaay taaɗ taar naaŋɗege se, gɔtn se ɗoobm roɗe tap ɓo, naaɗe jeel eyo. ");
INSERT INTO kyq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nakŋ se deel doɗe ɔɔ ɗoobm taaɗin̰ tap ɓo naaɗe jeel eyo ɔɔ naaɗe taaɗ ute naapa ɔɔ: «Jee taaɗ taargen se lɛ, naaɗe paac Galilege, ");
INSERT INTO kyq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tɛɗ ɔɔ ɗi jaay ɓo naŋa naŋa kic ɓo booy naaɗe taaɗin̰ ute taar naaŋin̰ naaŋin̰ se? ");
INSERT INTO kyq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ey num naajege se jee mɛtin̰ge iin̰o Paart ki, jee mɛtin̰ge iin̰o Mɛɗ ki ute Elamit ki ɔɔ jee mɛtin̰ge iin̰o Mɛzapotami ki, jee mɛtin̰ge iin̰o taa naaŋ Jude ki, jee mɛtin̰ge iin̰o taa naaŋ Kapados ki, jee mɛtin̰ge iin̰o taa naaŋ Pɔŋ ki ute taa naaŋ Azi ki, ");
INSERT INTO kyq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","jee mɛtin̰ge iin̰o taa naaŋ Prigi ki ute gɛn Pampili ki, jee mɛtin̰ge iin̰o taa naaŋ Masar ute gɛn Libi kɛn cɛɛ Sirɛnai ki ɔɔ jee mɛtin̰ge iin̰o *Rɔm ki, ");
INSERT INTO kyq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","paac naajen kɛn kꞋYaudge ɔɔ jeegen kɛn tɛɗga tɛɗ roɗe Yaudge, jee iin̰o Krɛt ki ute jee iin̰o taa naaŋ Suge tu, paac naaje kꞋbooyki naaɗe taaɗ nakgen magal magal kɛn *Raa tɛɗin̰ ute taar naaŋjege.» ");
INSERT INTO kyq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nakŋ se deel doɗe ɔɔ naaɗe jeel ɗoobm taaɗin̰ eyo. Naaɗe taaɗ ute naapa ɔɔ: «Kɛse tap ɓo je ɗeekŋ ɔɔ ɗio?» ");
INSERT INTO kyq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gaŋ jee mɛtin̰ge se tɛrɛc mɛtn jeege tun aalga kaal maakɗe do Isa al‑Masi ki ɔɔ ɗeek ɔɔ: «Naaɗe se lɛ, ɓɛrɛ, aay oonga koono.» ");
INSERT INTO kyq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kɛn Piɛr jaay booy taar se, naan̰ iin̰ ɗaar ute *jee kaan̰ naabm Isa al‑Masigen sik‑kaar‑kalaŋ kuuy se ɔɔ uun mindin̰ raan taaɗɗen ɔɔ: «Naase Yaudge ute naase jee kɛn iŋgki Jeruzalɛm ki se, uɗki bi jiga do taar kɛn maam mꞋasen taaɗa ɔɔ nakgen deel paac se Ꞌbooy ɔkin̰ki jiga jaayo. ");
INSERT INTO kyq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kɛn naase ɔɔki jee se jaay jee kaay koonge num kɛse mɛt ki eyo, taa ɓɔrse se naaje jꞋutuki maakŋ kaaɗn mɛs ki ɓɔrtɔ. ");
INSERT INTO kyq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Num gaŋ nakŋ aan se, kɛse taar kɛn debm taaɗ taar teeco taar Raa ki kꞋdaŋin̰ Jɔɛl kɛn taaɗo do dɔkin̰ se ɓo ɓɔrse aanga ɗoobin̰ ki, kɛn taaɗo ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Raa ɗeek ɔɔ: Ɓiigen kaam mɔɔtn se, maam mꞋutu mꞋaɗe kɔl Nirlum utu Ꞌbɔɔy do jeege tu paac. Bin se gɛnsegen gaabge ute kɛngen mɛndge se, utu Ꞌtaaɗn taargen teeco taarum ki ɔɔ gɛnsegen gaan kɔɗge se utu Ꞌkaakŋ nakgen kɛn maam mꞋteecn̰ naanɗe ki jaay mꞋaɗen taaɗn mɛtin̰a ɔɔ bubsege se kic mꞋutu mꞋaɗen taaɗn maakŋ niɗege tu. ");
INSERT INTO kyq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɗeere, ɓii kɛn se, maam mꞋaɗe kɔl Nirluma utu Ꞌbɔɔy do jee tɛɗn naabumge tun gaabge ute kɛngen mɛndge ɔɔ naaɗe utu taaɗ taargen teeco taarum ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Maam mꞋutu mꞋtɛɗn nakgen deel doa maakŋ raa ki ɔɔ mꞋutu mꞋtɛɗn nakŋ‑kɔɔɓge do naaŋ ki, jeege Ꞌkaakŋ mooso, pooɗo ɔɔ ute saa Ꞌkiin̰ tul tul. ");
INSERT INTO kyq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kɔr Mɛljege jaay aɗe ɓaa se, ɓii kɛn se kaaɗa Ꞌtɛɗn ilim dib ɔɔ laapa se Ꞌtɛɗn aac dɛŋ aan gɔɔ mooso. *Ɓii Mɛljege se Ꞌtɛɗn ɓii kalin̰ ki ɔɔ Ꞌtɛɗn ɓii bɛɛ dɛn aak eyo, naɓo ɓii se Ꞌkɔl ɓeere jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɓiin se jaay debm eemga Mɛljege num, naan̰ Ꞌkɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tɛr Piɛr taaɗ ɔɔ: «Naase gaan *Israɛlge, Ꞌbooyki taar maam mꞋasen taaɗa! Ute Isan kɛn iin̰o gɛgɛr kɛn Nazarɛt ki ɔɔ kɛn Raa ɔlin̰o gɔtse ki se, naase Ꞌjeelki Raase tɛɗga nakŋ‑kɔɔɓge ute nakgen deel doa daanse ki taa asen taaɗn tɔɔgŋ Raa. ");
INSERT INTO kyq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gaabm se, Raa mala ɓo ɔn̰sesin̰ jise ki. Taa do dɔkin̰ tap ɓo, Raa se jeele nakŋ naase utu an̰ki tɛɗn don̰ ki se. Taa naan̰ se ɓo, naase ɔk ɔlin̰ki ji jee *kusin̰ge tu ɔɔ naaɗe ɓaa tup tɔɔlin̰ ro kaag ki; ");
INSERT INTO kyq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","num gaŋ Raa se durin̰oga daan yoge tu ɔɔ ɔɔɗin̰ga don̰a naatn maakŋ yo ki taa yo se ɔk tɔɔgɔ don̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Taa naan̰ se ɓo ɓugjege *Daud taaɗo mɛtn taar naan̰a maakŋ Kitap ki ɔɔ: Daayum maam mꞋaak Mɛljege Raa naanum ki. Taa naan̰ utu cɛɛm ki se, maam tap ɓo mꞋɓeere ɗim ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɔɔ maam se maakum‑raapo ɔɔ mꞋaar kaa ute maak‑raapuma; kɛn mꞋooyga kic ɓo, maam se mꞋɔnd dom do Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Taa naai Mɛluma, naai se am kɔŋ kɔn̰um maakŋ yoge tu eyo, ɔɔ naai Ꞌkɔŋ kɔn̰ mɛɗn doi se Ꞌruum maakŋ ɓaaɗ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mɛluma, naai ɓo taaɗumga ɗoobm kaaja ɔɔ daayum naai utu cɛɛm ki se, maam maakum‑raap puk.» ");
INSERT INTO kyq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tɛr Piɛr taaɗ daala ɔɔ: «Gɛnaamgen Yaudge, Ꞌbooyki maam mꞋasen taaɗn tal. Ɓugjege Daud se ooyga do dɔkin̰a. Naan̰ jꞋuun jꞋɔlin̰ga maakŋ ɓaaɗ ki ɔɔ ɓaaɗin̰ se jaaki kic ɓo utu gɔtjege tu ara. ");
INSERT INTO kyq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Num gaŋ aan gɔɔ naan̰ debm taaɗ taar teeco taar Raa ki se, naan̰ jeele taa Raa se naamga naam taarin̰a ɔɔ tɛɗga num maakŋ mɛtjilin̰ ki se Ꞌkɔɔɗn deb kalaŋ se ɓaaɗo Ꞌkɔsn gaara gɔɔn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Taa naan̰ se ɓo, Daud se, naan̰ jeele *al‑Masi se ɓaaɗo ooyga kic ɓo utu duru daan yoge tu. Taa naan̰ se ɓo naan̰ ɗeek ɔɔ: ‹Raa se rɛsin̰ te maakŋ yoge tu eyo ɔɔ ron̰ lɛ, naan̰ ɔn̰in̰ ruum te maakŋ ɓaaɗ ki eyo.› ");
INSERT INTO kyq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Taa naan̰ se ɓo maam mꞋtaaɗseni: Raa se naan̰ duroga Isa daan yoge tu ɔɔ naaje se paac jꞋaakin̰ga ɔɔ naan̰ se utu te kaamin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Raa uun ɓaansin̰ga ute tɔɔgin̰a maakŋ raa ki. Ɔɔ Raa Bubu se ɛɗin̰ga *Nirl Salal kɛn naan̰ taaɗ ɔɔ utu kɛɗn jeege tu se. Ɔɔ Nirl se ɓo kɛn Isa ɔlin̰ ɓɔrse bɔɔy wɔɔk doje ki aan gɔɔ kɛn naase aakin̰ki ute kaamse ɔɔ Ꞌbooyin̰ki ute bise se. ");
INSERT INTO kyq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ey num ɓugjege Daud lɛ ook ɓaa te maakŋ raa ki eyo, gaŋ naan̰ taaɗ ɔɔ: Mɛljege Raa ɗeek Mɛlum ki ɔɔ: Naai se ɓaaɗo iŋg do ji daamum ki, ");
INSERT INTO kyq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ɓii kalaŋ maam mꞋai tɛɗi jee taamooyige paac se, naai utu kiŋg doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ɔn̰ gaan Israɛlge paac Ꞌjeel taar se: Isan naase Ꞌtup Ꞌtɔɔlin̰ki ro kaag ki se, naan̰ se ɓo Raa tɛɗin̰ tɛɗga Mɛljege ɔɔ naan̰ ɓo al‑Masi se.» ");
INSERT INTO kyq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kɛn jeege jaay booy taar ese se, naaɗe maakɗe tuj kasak kasak ɔɔ naaɗe tɔnd mɛtn Piɛr ute *jee kaan̰ naabm Isa al‑Masige gɛn kuuy se ɔɔ: «Gɛnaajege naaje tap ɓo kꞋtɛɗn roje jꞋɔɔ ɗi?» ");
INSERT INTO kyq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Gɔtn se Piɛr tɛrlɗen ɔɔ: «ꞋTɛrlki maakse ɔɔ naŋa naŋa kic ɓo ɔn̰ ron̰ jꞋan̰ *batizn ute ro Isa al‑Masi, taa Raa an̰ tɔɔl *kusin̰in̰a bin jaay Raa asen bɔɔy *Nirl Salal dose ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Taa naan̰ taaɗga taaɗ ɔɔ utu aɗe kɔl Nirl Salal dose ki, do gɛnsege tu ɔɔ do jeege tun iŋg dɔɔk te Raa ɔɔ do jeege tun dɛn kɛn Raa ute aɗeno daŋ se.» ");
INSERT INTO kyq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Gɔtn se tɛr Piɛr taaɗɗenga taarge dɛna taa aɗen tɛɗn naaɗe Ꞌtooko ɔɔ kaay kaamɗe. Naan̰ ɗeekɗen ɔɔ: «Jee duni kɛn ɓɔrse se, ɓɛrɛ, naaɗe se jee kɛn baate Raa! ꞋTeecki naatn maakɗe ki taa naase aki Ꞌkɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jee kɛn took uun taar Piɛr se, ɓii kɛn se sum ɓo kꞋbatizɗe. Naaɗe se ɓaa ɓaa nakŋ jeege dupu‑mɔtɔ ɔɔ naaɗe ɓaaɗo tum do jeege tun deetn kɛn aalga kaal maakɗe do Isa al‑Masi ki se. ");
INSERT INTO kyq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jee paacn̰ kɛn aalga kaal maakɗe do Isa *al‑Masi ki se, naaɗe daayum lee booy taargen *jee kaan̰ naabm Isa al‑Masige lee dooyɗe ɔɔ naaɗe iŋg aan gɔɔ gɛnaagen kon̰ɗe kalaŋ ɔɔ bubɗe kalaŋ. Naaɗe lee ɔs kalaŋ ɔɔ lee eem Raa taa naapki. ");
INSERT INTO kyq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ute jee kaan̰ naabm Isa al‑Masige se, Raa tɛɗ nakŋ‑kɔɔɓge dɛna ute nakgen kɛn taaɗ tɔɔgŋ Raa. Ute nakgen jaay naaɗe tɛɗse ɔl jeege paac ɓeer Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɔɔ jee kɛn aal maakɗe do Isa al‑Masi ki se, naaɗe ɔk taarɗe kalaŋ ɔɔ nakŋ paacn̰ jaay naaɗe ɔkse nig aakin̰ ute naapa. ");
INSERT INTO kyq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Naaɗe dugŋ naatn ute maakŋ‑gɔtɗege ɔɔ ute nakɗege ɔɔ gursn se naaɗe nig aakin̰ ute naapa ɔɔ naŋa naŋa kic ɓo jꞋɛɗin̰ nakŋ kɛn an̰ kaasn kiŋgin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Daayum ɓii‑raa naaɗe tus daan bɔɔr *Ɓee Raa ki ute maakŋ kalaŋ. Naaɗe lee ɔs kalaŋ ɓee naapge tu ɔɔ gɔtn kɔsɗe ki se, naaɗe lee tɔs ute maak‑raapo ɔɔ taar ɗim tap ɓo, naaɗe ɔk maakɗe ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kɛn jeege jaay aakɗe naaɗe tɛɗ bin se, naaɗe jeɗe. Ɔɔ jee kɛn aal maakɗe do Isa al‑Masi ki se naaɗe tɔɔm Raa, ɔɔ te naan̰ se ɓii‑raa Mɛljege Isa al‑Masi lee aaj jeege maakŋ *kusin̰ɗe ki ɔɔ daayum jeege ziiɗ do jeege tun aalga kaal maakɗe don̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɓii kalaŋ tɛgɛr aan kaaɗa mɔtɔ kɛn kꞋlee kꞋjꞋeem *Raa jaay aas se, Piɛr ute Jan ook ɓaa daan bɔɔr *Ɓee Raa ki gɛn keem Raa. ");
INSERT INTO kyq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gɔtn se kꞋjꞋuun kꞋɓaano ɓaa ute gaaba kalaŋ gɔtn kꞋjꞋoojin̰ tap ɓo naan̰ k‑ruŋguyu. Gaabm se, ɓii‑raa naaɗe ɓaaɗo lee tɔl tɔndin̰ cɛɛ taa ɗoobm Ɓee Raa kɛn kꞋdaŋin̰ taa Ɗoobm Aak Jiga se ɔɔ ɓii‑raa, naan̰ lee baay baay gɔtn jeege tun lee ɓaaɗo daan bɔɔr Ɓee Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kɛn naan̰ jaay aak Piɛr ute Jan ɛndo kɛnd daan bɔɔr Ɓee Raa ki se, naan̰ baay ɗim gɔtɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kɛn naaɗe jaay booy taarin̰ se, gɔtn se naaɗe ɔk ɗaara ɔɔ ɔndin̰ kaama tak ɔɔ Piɛr ɗeekin̰ ɔɔ: «ꞋTɛrl aakjen tu!» ");
INSERT INTO kyq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gɔtn se gaabm se tɛrl aakɗe ɔɔ naan̰ saap maakin̰ ki ɔɔ kaaɗn naane naaɗe an̰ kɛɗn ɗim. ");
INSERT INTO kyq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Gaŋ Piɛr ɗeekin̰ ɔɔ: «Daab ute pudda se maam mꞋɔk eyo, num nakŋ maam mꞋɔk se ɓo, mꞋaisin̰ kɛɗa. MꞋɔɔ ute ro Isa *al‑Masi kɛn kɔɗn Nazarɛt se, iin̰ Ꞌlea!» ");
INSERT INTO kyq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gɔtn se naan̰ ɔkin̰ ute ji daamin̰a ɔɔ uun ɗaarin̰a ɔɔ gɔtn ese sum ɓo kaam kiricin̰a ute kaam jɛn̰ se naar sɛɛj ɗaapa. ");
INSERT INTO kyq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Gɔtn se naan̰ iin̰ kirit ɔɔ ɗaara ɔɔ baag lea! Naan̰ ɛnd ute naaɗe daan bɔɔr Ɓee Raa ki, lea, taala ɔɔ tɔɔm Raa. ");
INSERT INTO kyq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jee ute dɛnɗe paac se aakin̰a kɛn naan̰ lea ɔɔ tɔɔm Raa se. ");
INSERT INTO kyq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jee se paac aak jeelin̰a naan̰ ɓo debm kɛn lee tiŋgo cɛɛ taa ɗoobm Ɓee Raa kɛn kꞋdaŋin̰ taa Ɗoobm Aak Jiga jaay lee baayo se. Kɛn naaɗe paac jaay aak nakŋ tɛɗ ese se, nakŋ se deel doɗe ɔɔ ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gɔtn se Piɛr ute Jan naaɗe ɗaar ɗaar mɛtn daab ki ɔɔ daabm se kꞋdaŋin̰ Daabm Salomon. Gaabm se kɔkŋ naan̰ tɔkɗe se ɔɔɗ ɔlɗen eyo. Gɔtn se jeege dɛna aan̰ ɓaaɗo ɔŋɗe taa nakŋ deel paac se ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kɛn Piɛr jaay aak jee dɛngen aan̰ ɓaaɗo gɔtɗe ki se, naan̰ ɗeekɗen ɔɔ: «Naase gaan *Israɛlge, gɛn ɗi jaay gaabm ese ɔŋ lapi sum ɓo jaay naase ɔksen taaɗ ey se? Naase aakjeki bin se gɛn ɗi? Gɛn naase ki num Ꞌsaapki ɔɔki gaabm kɛn iin̰ lee se ute tɔɔgje lɔɓu, ɔɔki jꞋɔk taar Raaje se ɓo ɔɔn̰ ɓo naan̰ ɔŋ lapi lɛ? ");
INSERT INTO kyq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Raa gɛn bubjege *Abraam, gɛn Isaka ɔɔ gɛn *Yakub se, naan̰ ɓo debm kɛn *nook Isan, debm tɛɗn naabin̰a, kɛn naase ɔk ɔlin̰ki kaam ji tɔɔgge tu ɔɔ ɔɔɗ undin̰ki naan Pilat ki. Ey num Pilat se, je an̰o kɔɔɗn kɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Naan̰ lɛ, debm *salal ɔɔ debm daan ki naan Raa ki, gaŋ naase Ꞌbaatin̰ki ɔɔ Ꞌjeki debm tɔɔl jeege se ɓo, jꞋasesin̰ kɔɔɗn kɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Num Mɛl‑kaaja tap ɓo, naase Ꞌtɔɔlin̰ki. Gaŋ Raa se durin̰oga daan yoge tu ɔɔ naaje se jꞋaakin̰ga ute kaamje. ");
INSERT INTO kyq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Anum gaabm naase aakin̰ki naanse ki ese se, naase paac Ꞌjeelin̰ki. Naan̰ jaay ɔŋ lapi se ute ro Isa, taa naaje jꞋaalga kaal maakje don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Num ɓɔrse, gɛnaamge, maam mꞋjeele nakŋ naase ute magalsege Ꞌtɛɗin̰kiro se, naase Ꞌjeel ɔkkiro te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gaŋ taar kɛn Raa ɔlo jee taaɗo taargen teeco taarin̰ ki taaɗo se ɓo, aanga ɗoobin̰ ki kɛn ɔɔ: *al‑Masi ɓaaɗoga num, utu Ꞌdabara. ");
INSERT INTO kyq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bin se naase Ꞌtɛrlki maakse ɔɔ Ꞌɓaakiro gɔtn Raa ki, taa naan̰ asen tɔɔl *kusin̰se. ");
INSERT INTO kyq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bin jaay Mɛljege Raa asen kɛɗn gɔtn tɔɔl maaka ɔɔ utu aseno kɔl Isa, naan̰ ɓo al‑Masi kɛn Raa bɛɛr ɔɔɗsesin̰o. ");
INSERT INTO kyq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kɔr se, Isa kiŋg maakŋ raa ki bini Ꞌkaan ɓii kɛn Raa Ꞌtɔnd ɗaapm nakge paac Ꞌtɛɗn kiji. Kɛse ɓo nakŋ kɛn jee salal kɛn taaɗo taargen teeco taar Raa ki taaɗo do dɔkin̰ se. ");
INSERT INTO kyq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ey num *Musa kic taaɗoga taaɗ ɔɔ: Maakŋ gɛnaasege tu se, Mɛlse Raa utu aseno bɛɛr kɔɔɗn debm taaɗ taar teeco taar Raa ki aan gɔɔ maama, ɔɔ taar kɛn naan̰ utu asen taaɗn paac se, Ꞌbooy uunin̰ki. ");
INSERT INTO kyq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɔɔ debm jaay baate booy kuun taarin̰ se, maakŋ jeen̰ge tu se jꞋan̰ kɔkŋ kutn naatn. ");
INSERT INTO kyq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Jee taaɗ taar teeco taar Raa ki paacn̰ iin̰o do Samuɛl ki ute jeegen ɓaaɗo mɛtn naan̰ ki se, taaɗoga taa nakgen kɛn ɓɔrse aanga se kici. ");
INSERT INTO kyq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gɛnaamge, naase se Ꞌgaan jee kɛn taaɗ taar teeco taar Raa ki do dɔkin̰a ɔɔ dɔɔkŋ kɛn *Raa dɔɔko ute bubsege se, dɔɔk ute naase kici. Taa naan̰ se ɓo, naan̰ taaɗ Abraam ki ɔɔ: Ute mɛtjil naai se, maam mꞋtɛɗn bɛɛ mɛtjil jeege tun do naaŋ ki paac. ");
INSERT INTO kyq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Deet deet se Raa ɔɔɗo debm tɛɗn naabin̰ Isa se naase gaan Israɛlge tu. Naan̰ ɔlin̰o se taa asen tɛɗn bɛɛ ɔɔ bin se naŋa naŋa kic ɓo Ꞌtɛrl naaga do nakge tun jig ey kɛn naan̰ lee tɛɗin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kaaɗ kɛn Piɛr ute Jan utu taaɗ taaɗ jee dɛnge tu ɓɔrt sum ɓo, *jee tɛɗn sɛrkɛ Raage tun mɛtin̰ge, magal jeegen iŋg bɔɔb *Ɓee Raa ɔɔ ute *Sadusegen mɛtin̰ge ɓaaɗo ɔŋɗe. ");
INSERT INTO kyq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gɔtn se naaɗe aak Jan ute Piɛr se maakɗe taarɗe doɗe ki pirin̰, taa naaɗe dooy dooy jee dɛnge ɔɔ taaɗɗen ɔɔ aan gɔɔ *Raa duro Isa daan yoge tu se, jee ooyga kooy kic ɓo, naan̰ utu aɗen dur bin kici. ");
INSERT INTO kyq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gɔtn se naaɗe tɔkɗe ɔɔ ɓaa ɔmbɗe tooɗ iip daŋgay ki taa kaaɗa se ɓaaga. ");
INSERT INTO kyq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ute naan̰ se kic ɓo, jeegen booy taar Piɛr ute Jan se maakɗe ki se jeege dɛna took uun taar se ɔɔ gɔtn se jee aal maakɗe do Isa ki se ziiɗ ɓaa ɓaa nakŋ gaabge dupu‑mii. ");
INSERT INTO kyq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gaŋ mɛtbeen̰ki se, magal Yaudge ɔɔ magal taa ɓeeɗege ute jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage se, naaɗe tus maakŋ gɛgɛr kɛn Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Maakɗe ki se gaabm kɛn kꞋdaŋin̰ Annan se, naan̰ ɓo *magal jee tɛɗn sɛrkɛ Raage tu, Kayip ute Jan ɔɔ Alekzandɛr ute jee kuuy se, naaɗe paac se jee maakŋ ɓee magal jee tɛɗn sɛrkɛ Raage tu ɔɔ naaɗe paac utu gɔtn ese kici. ");
INSERT INTO kyq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gɔtn se naaɗe ɔɔɗo Piɛr ute Jan se maakŋ daŋgay ki ɔɔ ɓaanɗeno naanɗe ki ɔɔ tɔnd mɛtɗe ɔɔ: «Gaabm se, naase ɛɗin̰ki lapi se ute ro naŋa ɔɔ tɔɔgŋ se tap ɓo, naase ɔŋin̰kiro gay?» ");
INSERT INTO kyq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Gɔtn se Piɛr, kɛn *Nirl Salal ɗoocga ɗooc maakin̰ se, taaɗɗen ɔɔ: «Naase magal Yaudge ute magal taa ɓee Yaudge se, ");
INSERT INTO kyq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jaaki naase Ꞌɓaanjekiro naanse ki se gɛn tɔnd mɛtje taa gaabm kɛn k‑ruŋguy jaay ɔŋ lapi se. Ɔɔ naase Ꞌje aki jeele ute ɗoobm gay jaay ɓo gaabm se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Naase jeege paac ɔɔ naasen paacn̰ gaan *Israɛlge se Ꞌjeelki ute ro Isa *al‑Masi kɛn kɔɗn Nazarɛt, kɛn naase Ꞌtup tɔɔlin̰ki ro kaag ki jaay, Raa durin̰oga daan yoge tu se, ute tɔɔgŋ Isan se ɓo, gaabm ɗaar naanse ki se ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Taar se kꞋraaŋin̰ga raaŋ maakŋ Kitap ki kɛn ɔɔ: Ko kɛn naase jee kiin̰ ɓeege baatin̰ki jaay ɔɔɗ undin̰ki naatn se, naan̰ se ɓo kɛn tɛɗga ko kɛn gakŋ ɓea. Ko ara se, taaɗ te Isa. ");
INSERT INTO kyq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Taa naan̰ se ɓo Ꞌbooyki mꞋasen taaɗa, kɛn ɛɗ kaaja se, Isa kalin̰ ki sum. Ey num, do naaŋa ute magalin̰ se, Raa ɔŋ ɔlo te nam gam kuuy kɛn Ꞌkaajn̰ jeege eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naan̰ kɛn se jee kɛn lee aak mɛtn taar jeege se booy taar kɛn Piɛr ute Jan jaay taaɗ ɓeer ey paac paac se, taar se ɔkɗen taaɗ eyo, gaŋ naaɗe saapm ɔŋin̰ Piɛr ute Jan se jee bin sum, ɔŋ dooy te dɛn eyo. Naɓo naaɗe jeele, naaɗe se jee leeɗoga ute Isa. ");
INSERT INTO kyq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɛn naaɗe jaay aak gaabm kɛn ɔŋ lapi jaay ɗaar ɗaar cɛɛɗe ki se, taar ɗim kɛn naaɗe aɗen tɛrl tap ɓo ɔŋ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gɔtn se naaɗe taaɗ ɔɔ: «Piɛr ute Jan se, kꞋjꞋɔɔɗ kꞋteecɗe naatn maakŋ ɓee kɛn kꞋlee kꞋjꞋaak mɛtn taarge se.» Ɔɔpɗen naaɗe Yaudgen jee kaakŋ mɛtn taarge se ɓo taaɗ dɔɔk taarɗe ute naapa. ");
INSERT INTO kyq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Gɔtn se naaɗe taaɗ ɔɔ: «Jee se tap ɓo jꞋaɗeki tɛɗn ɔɔ ɗi? Taa jee Jeruzalɛm ki paac se lɛ, booyga nakŋ‑kɔɔɓm naaɗe tɛɗ se. Ɔɔ nakŋ‑kɔɔɓm se lɛ tooɗ tal jꞋaki kɔŋ naaj do ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Num naaje se kꞋje eyo kɛn taar se jaay Ꞌwɔɔkŋ jeege an̰ booy paac se. Bin se jꞋaacɗeki kaama taa naaɗe mɔɔtn ro Isa se jꞋɔn̰te taaɗin̰ nam ki.» ");
INSERT INTO kyq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Gɔtn se naaɗe daŋo Piɛr ute Jan ɔɔ aacɗen kaama ɔɔ: «Naan ki se mɔɔtn ro Isa se ɔn̰te Ꞌtaaɗin̰ki nam ki ɔɔ ɔn̰te Ꞌdooyki jeege ute mɛtn taar se!» ");
INSERT INTO kyq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Gaŋ gɔtn se Piɛr ute Jan tɛrlɗen ɔɔ: «Gɛn naase ki num naan Raa ki se, kɛn gay ɓo ɗoobin̰a? KꞋbooy kuun taar naase lɔɓu kꞋbooy kuun taar Raa lɛ! ");
INSERT INTO kyq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ɗeer num, naaje se kꞋkɔŋ do eyo do nakge tun naaje jꞋaako ute kaamje ɔɔ kꞋbooyo ute bije se.» ");
INSERT INTO kyq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gɔtn se Piɛr ute Jan se jee kaakŋ mɛtn taargen Yaudge se tɛr aacɗen kaama daala jaay ɓo tɔɔɗ tɔlɗe. Naaɗe ɔŋ te ɗoobm kɛn aɗen dabar eyo, taa naaɗe ɓeer ɓeer jee dɛnge tu ɔɔ do nakge tun deel se jeege paac *nook Raa. ");
INSERT INTO kyq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anum gaabm kɛn Piɛr ute Jan tɛɗn nakŋ‑kɔɔɓɔ jaay naan̰ ɔŋ lapi se, naan̰ ɓaarin̰ cir si‑sɔɔ. ");
INSERT INTO kyq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kɛn Piɛr ute Jan jaay kꞋtɔɔɗ kꞋtɔlɗeno se, naaɗe ɓaaɗo ɔŋ jeeɗege ɔɔ taaɗɗen taargen kɛn *magal jee tɛɗn sɛrkɛ Raa ki ute magal taa ɓee Yaudge taaɗɗeno se. ");
INSERT INTO kyq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kɛn jeeɗege se jaay booy taar Piɛr ute Jan se, naaɗe iin̰ taa tɔnd mɛtn Raa ute maakŋ kalaŋ ɗeek ɔɔ: «Raa Sidburku, naai ɓo debm aalo maakŋ raa ute do naaŋa ɔɔ baarge ɔɔ ute nakgen maakɗe ki se paac. ");
INSERT INTO kyq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɓuli bubje *Daud se, naai ɓo debm ɛɗin̰o *Nirl salal ɔɔ Nirl Salal ese ɓo kɛn ɔlin̰ taaɗo ɔɔ: Jee do naaŋ ki ute mɛtjilɗege paac tap ɓo iŋg ɓo gɛn je taamooyo ɔɔ dɔɔk taarɗe kalaŋ gɛn tɛɗn nakŋ ɔs aay ey se tap ɓo, taa ɗi? ");
INSERT INTO kyq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gaarin̰gen do naaŋ ki ɗaap roɗe gɛn tɛɗn bɔɔrɔ; ɔɔ magalgen do naaŋ ki tusu taa baatn Mɛljege Raa ute gaar kɛn naan̰ bɛɛr ɔndin̰o se. ");
INSERT INTO kyq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ɗeere, taar se taar mɛt ki. Maakŋ gɛgɛr kɛn Jeruzalɛm ki se, *Ɛrɔd ute Pons Pilat, tus dɔɔk taarɗe kalaŋ ute jee kɛn Yaudge ute kɛngen Yaudge eyo taa baatn Isa debm tɛɗn naabi salal kɛn naai Ꞌbɛɛr ɔɔɗin̰o. ");
INSERT INTO kyq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bin se ute tɔɔgi se, naai uunoga doa ɔɔ naaɗe tɛɗin̰ga aan gɔɔ kɛn naai maaki jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mɛlje, naai aaka kiibm kaacn̰ kɛn naaɗe iiɓ aacje naajen kꞋɓulige se, ɓɔrse ɛɗjen gaab‑tɔɔgɔ taa kꞋtaaɗn taari kic ɓo kꞋɓeer eyo. ");
INSERT INTO kyq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ꞋTaaɗ tɔɔgi jeege tu, ute ro Isan debm tɛɗn naabi salal se, ɛɗ lapia jee kɔɔn̰ge tu ɔɔ Ꞌtɛɗn nakŋ‑kɔɔɓge ute nakgen deel doa.» ");
INSERT INTO kyq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kɛn naaɗe jaay eem Raa aas se, gɔtn naaɗe tusn ro ki se naaŋa tea. Gɔtn se naaɗe paac Raa ɗoocɗe ute Nirl Salal. Ɔɔ gɔtn se naaɗe baag taaɗn taar Raa jeege tu ɓeer eyo. ");
INSERT INTO kyq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jee kɛn aal maakɗe do Isa *al‑Masi ki ute dɛnɗe se, naaɗe iŋg ute maakŋ kalaŋ ɔɔ taarɗe kic ɓo kalaŋ. Maakɗe ki se nam jaay Ꞌtaaɗn ɔɔ nakŋ se gɛn maama se gɔtɔ. Num gaŋ nakŋ naaɗe ɔk paac se ɔmbin̰ taa naapki. ");
INSERT INTO kyq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ute tɔɔgŋ Raa se, *jee kaan̰ naabm Isa al‑Masige se taaɗ jeege tu tap ɓo ɓeer eyo ɔɔ: «Mɛlje Isa se duroga daan yoge tu ɔɔ naaje jꞋaakin̰ga ute kaamje.» Gɔtn se jee Raage paac se Raa tɛɗɗenga bɛɛ dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maakɗe ki se nam tap ɓo ɗim daayin̰ eyo. Taa jee ɔk maakŋ‑gɔtɔ ute ɓeege se dugin̰a ɔɔ ɓaano ute gursin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ɔɔ gursn ese se naaɗe ɓaaɗo ɛɗin̰ ji jee kaan̰ naabm Isa al‑Masige tu. Ɔɔ naŋa naŋa kic ɓo, jꞋɛɗin̰ nakŋ kɛn an̰ kaasn kiŋgin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Maakɗe ki se, gaaba kalaŋ ron̰ Yusup kɛn jee kaan̰ naabm Isa al‑Masige daŋin̰ ute ro Barnabas. (Barnabas se je ɗeekŋ ɔɔ: goon ɛɗ kaay kaama jeege tu.) Naan̰ se mɛtjil gɛn Lɛbige ɔɔ naan̰ jꞋoojin̰ taa naaŋ Sipir ki. ");
INSERT INTO kyq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Naan̰ se dugŋ ute maakŋ gɔtin̰a ɔɔ gursin̰ se, naan̰ ɓaaɗo ɛɗin̰ ji jee kaan̰ naabm Isa al‑Masige tu. ");
INSERT INTO kyq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Num gaŋ maakɗe ki se, debm kuuy ron̰ Ananias ute mɛndin̰ ron̰ Sapira, naaɗe se ɔk gɔtɔ. Ɔɔ naaɗe se dɔɔk taarɗe kalaŋ ɓaa dugŋ ute gɔtɗe se naata. ");
INSERT INTO kyq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Naan̰ ute mɛndin̰ se, gursn se naaɗe gaaŋ ute mɛtin̰a ɔɔ gɔtn se gaabin̰ ɓaan ute gursn ɔɔp se, ji *jee kaan̰ naabm Isa al‑Masige tu. ");
INSERT INTO kyq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Gɔtn se Piɛr ɗeekin̰ ɔɔ: «Ananias, gɛn ɗi jaay naai ɔn̰ *Ɓubm sitange ɓaaɗo ɛnd ɗooc maak ki bin se? Kɛn Ꞌgaaŋo mɛt kɔɔpm gursi gɔti ki se kɛse taar‑kɔɔɓm kɛn naai Ꞌtɛɗ se tɛɗn *Nirl Salal ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kɛn dugin̰ te ey lɛ gɔtɔ se gɛn naai tap ey la? Ɔɔ kɛn naai jaay dugin̰ga kic num, gursin̰ se gɛn naai ey la? Kɛn ɔli jaay taaɗ taar‑kɔɔɓɔ se gɛn ɗi? Taar‑kɔɔɓm kɛn naai tɛɗin̰ se, Ꞌtɛɗin̰ jikilimge tu eyo, gaŋ naai tɛɗin̰ *Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kɛn jaay Ananias booy taar se, naan̰ aal ooc ooyo ɔɔ jeegen paacn̰ jaay booy labar ese se, ɓeere ɓaa ɔkɗe tak tak. ");
INSERT INTO kyq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gɔtn se, gaan kɔɗge ɓaaɗo teelin̰ ute kala ɔɔ uun ɓaa ɔlin̰ maakŋ iiɓ ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kɛn nakŋ se deel jaay ɓaa ɓaa nakŋ lɛr mɔtɔ se, mɛnd Ananias ɓaaɗo ɛnd gɔtn jee kaan̰ naabm Isa al‑Masige tu se; naɓo nakŋ kɛn aan do gaabin̰ ki se, naan̰ jeel eyo. ");
INSERT INTO kyq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Gɔtn se Piɛr tɛɛsin̰ ɔɔ: «Gɔtsen naase Ꞌdugin̰ki se, kɛse ɓo gursin̰ paac sum ne?» Mɛnda took ɔɔ: «Yɛɛ. Kɛse ɓo gursin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Gɔtn se Piɛr tɛrlin̰ ɔɔ: «Gɛn ɗi jaay naai ute gaabi Ꞌdɔɔkki taarse gɛn naam *Nirl Raa se? ꞋBooyo! Jee kɛn ɔlo gaabi maakŋ iiɓ ki se aanga taa ɗoob ki. ꞋBooy gɔtn jɛɗe! Naaɗe utu ɓaaɗo ai ɓaa kuun kɔli naai kici.» ");
INSERT INTO kyq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Gɔtn ese sum ɓo, mɛnda se naar ooc ooy naan Piɛr ki. Kɛn gaan kɔɗge jaay aan se, naaɗe ɛnd se ɔŋin̰ naan̰ ooyga ɔɔ naaɗe uun ɓaa ɔlin̰ maakŋ iiɓ ki cɛɛ gaabin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gɔtn se jee *egliz ki paac ute jee kuuy paac jaay booy labar ese se, naaɗe ɓeere ɓaa ɔkɗe tak tak. ");
INSERT INTO kyq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Raa ɔl jee kaan̰ naabm Isa al‑Masige se tɛɗ nakŋ‑kɔɔɓge dɛna ute nakgen deel doa naan jeege tu. Naaɗe paac taarɗe kalaŋ ɔɔ lee tus mɛtn daabm Salomon ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Anum jee kuuy se nam tap ɓo took gɛn tum te naaɗe eyo; gaŋ jee dɛnge se lee tɔɔm jee aal maakɗe do Isa *al‑Masi ki se. ");
INSERT INTO kyq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ute naan̰ se kic ɓo jeege dɛna, mɛndge ute gaabge, took aal maakɗe do Isa al‑Masi ki ɔɔ ɓaaɗo ziiɗ do jeege tun aalga kaal maakɗe do Isa al‑Masi ki se. ");
INSERT INTO kyq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Taa nakŋ‑kɔɔɓgen jee kaan̰ naabm Isa al‑Masige lee tɛɗ se, ɔl jeege teecn̰no ute jee kɔɔn̰ge tuun taalɗeno do daŋalge tu ey lɛ do raagge tu; naaɗe ɓaaɗo tɔndɗen do ɗoobge tu, taa kɛn Piɛr deel deel jaay nirlin̰ deebga doɗe ki se, sɔm maakɗe ki se, nam kalaŋ utu Ꞌkɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gɔtn se jeegen kuuy kic ɓo dɛna kɛn iin̰o maakŋ naaŋge tun kɛn cɛɛ gɛgɛr kɛn Jeruzalɛm ki, naaɗe ɓaano ute jee kɔɔn̰ɗege ɔɔ jee kɛn ɔk kɔɔn̰ sitange. Gɔtn se naaɗe paac ɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Do nakge tun tɛɗ se, *magal jee tɛɗn sɛrkɛ Raa ki ute *Sadusegen ute naan̰ se, tɛɗn maak‑kilimi ro jee kaan̰ naabm Isa al‑Masige tu ɔɔ gɔtn se naaɗe iin̰ roɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gɔtn se naaɗe tɔk ɔmbɗen daŋgay kɛn kꞋlee kꞋtɔkŋ kꞋtɔl jeege. ");
INSERT INTO kyq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gaŋ maakŋ nɔɔr ki se, *kɔɗn Raa ɓaaɗo tɔɔɗn ute kaam taar daŋgayge se naatn ɔɔ ɔɔɗ teecɗeno naatn ɔɔ ɗeekɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«ꞋƁaaki daan bɔɔr *Ɓee Raa ki ɔɔ Ꞌtaaɗki taargen paacn̰ kɛn ɛɗ kaaja se jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gɔtn se naaɗe took do taar kɔɗn Raa ki ɔɔ tanɔɔrin̰ nɔɔrin̰ sum ɓo, naaɗe ɓaa daan bɔɔr Ɓee Raa ki ɔɔ naaɗe baag dooy jeege gɔtn ese. Kɛn *magal jee tɛɗn sɛrkɛ Raage tu ute jeen̰ge jaay aan gɔtn naaɗe lee aakŋ mɛtn taar jeege se, naaɗe daŋo magalgen taa ɓee *Israɛlge tu ɔɔ ute jeegen lee aak mɛtn taar Yaudge se, gɔtn se naaɗe tusu ɔɔ ɔl ɔɔ kꞋɓaa kꞋtɔɔɗo jee kaan̰ naabm Isa al‑Masige se naatn maakŋ daŋgay ki ɔɔ kꞋɓaanɗeno. ");
INSERT INTO kyq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Num jee kɛn jꞋɔlɗe naaba taa ɓaa kaakŋ jee daŋgayge se, naaɗe aan se ɔŋɗen te eyo. Gɔtn se naaɗe ɔk tɛrl ɓaaɗo ɔŋ jee ɔlɗeno se ɔɔ taaɗɗen mɛtn taar nakgen deel se paac ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Kɛn naaje jaay jꞋaan se, kꞋjꞋɔŋ kaam taar daŋgayge se kꞋgaasin̰ga gaas ute lɛkɛrlɛ ɔɔ jee kɛn lee bɔɔb jee daŋgayge se lɛ, ɗaar ɗaar taa‑ɗoob ki. Naɓo kɛn naaje jaay kꞋtɔɔɗ kaam taara se, jꞋɔŋ te nam maak ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kɛn magal jeegen lee bɔɔb Ɓee Raa ute magal jee tɛɗn sɛrkɛ Raage tu jaay booy taar se, gɔtn se taar naaɗe Ꞌtaaɗ tap ɓo jeel eyo. Anum naaɗe tɔnd mɛtn naapa do nakge tun deel se. ");
INSERT INTO kyq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gaŋ gɔtn se deb kalaŋ iin̰o daan bɔɔr Ɓee Raa ki ɓaaɗo taaɗɗen ɔɔ: «ꞋBooyki, ɓɛrɛ, jeegen naase tɔk ɔmbɗeki daŋgay ki se, ɓɔrse naaɗe utu daan bɔɔr Ɓee Raa ki ɔɔ ɗaar dooy dooy jeege.» ");
INSERT INTO kyq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gɔtn se magal jeegen lee bɔɔb Ɓee Raa se iin̰ ɓaa ute jeen̰ge tɔk ɓaanɗeno ute jee kaan̰ naabm Isa al‑Masige se, naɓo ute taa tɔɔg eyo, taa naaɗe ɓeer ɓeer jee dɛnge tu ɔɔ sɔm aɗen tund te ko cɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kɛn jee kɛn lee bɔɔb jee daŋgay ki jaay tɔk ɓaano ute jee kaan̰ naabm Isa al‑Masige naan Yaudge tun jee kaakŋ mɛtn taarge se, gɔtn se *magal debm tɛɗn sɛrkɛ Raa ki tɛɛsɗe ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Naaje kꞋgaassen jꞋɔɔ ɔn̰ten Ꞌdooyki jeege ute ro gaabm se bin ey la? Aakki nakŋ naase Ꞌtɛɗki se jaayo? Jeegen Jeruzalɛm ki se lɛ, naase Ꞌtaaɗ Ꞌdɔɔɗɗekiga paac. Naase Ꞌje aki kɔl moosn gaabm se Ꞌkɔɔpm mindje ki.» ");
INSERT INTO kyq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Gaŋ Piɛr ute jee kaan̰ naabm Isa al‑Masigen kuuy tɛrlɗen ɔɔ: «Bɛɛki num, nakŋ kɛn Raa maakin̰ jen ro ki se ɓo, jꞋan̰ tɛɗ jaay kꞋtɛɗn nakŋ kɛn jikilimge maakɗe jea. ");
INSERT INTO kyq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Naase ɓo jee kɛn tup tɔɔlki Isa ro kaag ki, gaŋ Raa bubjege, durin̰oga daan yoge tu, ");
INSERT INTO kyq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ɔɔ uun ɓaa ɔndin̰ga do ji daamin̰ ki, ɔɔ tɛɗin̰ naan̰ ɓo tɛɗga gaar jeege ɔɔ Debm Kaajn̰ jeege taa kɔɔɗn ɗoobo gaan *Israɛlge tu gɛn tɛrl maakɗe, ɔɔ Raa aɗen tɔɔl *kusin̰ɗege. ");
INSERT INTO kyq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Do nakge tun deel paac se, naaje kꞋsaaɗin̰ge ɔɔ *Nirl Salal kɛn Raa ɛɗ jeege tun tookga taarin̰ se, kic ɓo saaɗa.» ");
INSERT INTO kyq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kɛn naaɗe jaay booy taar se, maakɗe taarɗe pirin̰ aan gɔɔ aki ɗoobo, ɔɔ naaɗe je aɗen tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Num gaŋ gaaba kalaŋ naan̰ kɔɗ *Parizi, naan̰ maakŋ Yaudge tun jee kaakŋ mɛtn taarge se kici ɔɔ naan̰ se ron̰ Gamaliɛl. Naan̰ se debm jeel taaɗ tɔɔkŋ mɛtn Ko Taar Raa gɛn Yaudge ɔɔ gaan Israɛlge paac aalin̰ maak ki. Naan̰ iin̰ ɗaar naan jeege tun se ɔɔ taaɗɗen ɔɔ: «Jee se, ɔɔɗɗeki naatn jaayo.» ");
INSERT INTO kyq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kɛn jee kaan̰ naabm Isa al‑Masige jaay jꞋɔɔɗ kꞋteecɗen naatn sum se, naan̰ taaɗɗen ɔɔ: «Naase gɛnaamgen gaan Israɛlge, ɔndki kɔndɔ do nakge tun naase Ꞌje aki tɛɗn do jeege tun ese. ");
INSERT INTO kyq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ꞋJeelki, gɔɔr gɔɔr ara sum ɓo, gaaba kalaŋ kꞋdaŋin̰ Tedas. Naan̰ se tɛɗ ron̰ aan gɔɔ debm kꞋjeel jeel gɔtin̰a ɔl gaabge ɓaa ɓaa nakŋ kaar‑sɔɔ se ɓaa mɛtin̰ ki. Gɔtn kꞋtɔɔlin̰ sum se, gaabgen mɛtin̰ ki se aan̰ wɔɔkɔ ɔɔ naabɗe se lɛ ɗaara. ");
INSERT INTO kyq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tɛr kaaɗ kɛn magal jee taa naaŋ *Rɔm ki jaay iin̰ taa mɛɗn jeege se, naan̰ kɛn se, gaaba kalaŋ kɔɗ Galile kꞋdaŋin̰ Judas se, naan̰ kic tɛɗ jeege dɛna ɓaa mɛtin̰ ki. Kɛn naan̰ jaay kꞋtɔɔlin̰ se, jee mɛtn naan̰ ki se kic ɓo aan̰ wɔɔkɔ. ");
INSERT INTO kyq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ɓɔrse, maam mꞋje mꞋasen taaɗa: ɔɔɗki dose dɔkɔ ro jeege tun ese, ɔn̰ɗeki naaɗe ɓaa. Kɛn nakŋ naaɗe tɛɗ se jaay gɛn jikilimge sum lɛ, utu Ꞌɗaar kalin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Num, kɛn nakŋ naaɗe tɛɗ se jaay gɛn Raa lɛ, naase an̰ki kɔŋ ɗaar eyo! Ɔndki kɔndɔ, sɔm ɓaa naase aki tɛɗn jee taamooy Raage!» Gɔtn se naaɗe took uun taarin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Naaɗe ɔl kꞋdaŋ kꞋɓaano ute jee kaan̰ naabm Isa al‑Masige se ɔɔ gɔtn se naaɗe ɔl jꞋɔndɗen ute mɛɛjɛ ɔɔ gaasɗe ɔɔ jꞋɔn̰te taaɗn ro Isa *al‑Masi se nam ki, ɔɔ bin jaay ɓo naaɗe tɔɔɗ tɔlɗe. ");
INSERT INTO kyq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kɛn jee kaan̰ naabm Isa al‑Masige jaay teeco gɔtn ese se, maakɗe‑raap sakan̰ taa Raa se ɔŋɗe naaɗe se jee an̰ kaasin̰ gɛn dabar taa Isa. ");
INSERT INTO kyq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ute naan̰ se kic ɓo, ɓii‑raa daan bɔɔr *Ɓee Raa ki ɔɔ maakŋ ɓeege tu se, naaɗe daayum lee dooy jeege ɔɔ taaɗɗen Labar Jigan gɛn Isa se jeege tu. Ɔɔ jeege se, naaɗe lee taaɗɗen ɔɔ: Isa se ɓo, al‑Masi. ");
INSERT INTO kyq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Anum kaaɗ kɛn se jee aalga maakɗe do Isa *al‑Masi ki se ziiɗ tɛɗ dɛna, ɓaa ute naanɗe. Num gaŋ maakɗe ki se, Yaudgen taaɗ taar Grɛk se taaɗ naaŋ ki ro Yaudge tun taaɗ taar naaŋɗe mala se. Taa aanga gɔtn kꞋnigŋ naka mɛnd‑daayge tu se, mɛnd‑daaygen taaɗ taar Grɛk se, kꞋlee kꞋdirigɗe dirigi. ");
INSERT INTO kyq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Gɔtn se *jee kaan̰ naabm Isa al‑Masigen sik‑kaar‑di se, daŋ tus jee aalga kaal maakɗe do Isa al‑Masi ki se paac ɔɔ ɗeekɗen ɔɔ: «Naaje se jꞋkɔŋ kɔn̰ gɛn taaɗn taar *Raa jeege tu jaay ɓo kꞋɓaa lee nigŋ nakŋ kɔsɔ jeege tu eyo. ");
INSERT INTO kyq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Taa naan̰ se gɛnaamge, maakse ki se Ꞌbɛɛr Ꞌtɔɔɗki gaabge cili kɛn jeege aalɗe maak ki ɔɔ maakɗe ɗooc te *Nirl Salal ɔɔ jee jeel‑taara. Bin se naaje jee kaan̰ naabm Isa al‑Masige se, naabm se jꞋaɗesin̰ kɔn̰ kaam jiɗe. ");
INSERT INTO kyq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ɔɔ naaje se lɛ jꞋkɔn̰ roje paac gɛn keem Raa ɔɔ gɛn taaɗn taar Raa jeege tu.» ");
INSERT INTO kyq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jee aalga kaal maakɗe do Isa al‑Masi ki kɛn tus gɔtn ese paac se, took do taarɗe ki se. Gɔtn se jaay naaɗe bɛɛr ɔɔɗ Etien; naan̰ se debm kɛn aal maakin̰ paac do Raa ki ɔɔ maakin̰ ɗooc ute Nirl Salal. Naaɗe bɛɛr tɔɔɗo Pilip, Prokor, Nikanor, Timon, Parmenas ɔɔ Nikolas kɛn kɔɗ Antiɔs kɛn tɛɗga ron̰ kɔɗ Yaudge se kici. ");
INSERT INTO kyq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jee tus gɔtn ese ɓaano ute jeegen kꞋbɛɛr kꞋtɔɔɗɗen cili se naan jee kaan̰ naabm Isa al‑Masige tu ɔɔ naaɗe eemɗen Raa ɔɔ tɔndɗen jiɗege doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naan̰ kɛn se, jee aalga kaal maakɗe do Isa al‑Masi ki se, taaɗ wɔɔk taar Raa se jeege tu. Ɔɔ jee kɛn jaay aalga kaal maakɗe do Isa al‑Masi ki se ziiɗ tɛɗ dɛna maakŋ gɛgɛr kɛn Jeruzalɛm ki. Gɔtn se, *jee tɛɗn sɛrkɛ Raage tu se kic dɛna ɓaaɗo took aal maakɗe do Isa al‑Masi ki. ");
INSERT INTO kyq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etien se, Raa tɛɗin̰ga bɛɛn̰a ɔɔ ɛɗin̰ga tɔɔgɔ gɛn tɛɗn nakgen deel doa ute nakŋ‑kɔɔɓgen magal magala naan jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Gaŋ do nakge tun naan̰ tɛɗ se ɓii kalaŋ Yaudgen iin̰o gɛgɛr kɛn Sirɛn ki ute kɛngen iin̰o gɛgɛr Alekzandri ki, naaɗe lee tus tus maakŋ *ɓee kɛn Yaudge lee tusn maak ki se. Ɓee se kꞋdaŋin̰ Ɓee Yaudgen jꞋɔɔɗɗen̰ga kɔɔɗ doɗe maakŋ ɓul ki ɔɔ naaɗe lee tum ute Yaudgen iin̰o taa naaŋ Silisi ki ute gɛn Azi ki. Gɔtn se naaɗen jee gɔtɔ kaam sɔɔ se paac baag naajn̰ ute Etien, ");
INSERT INTO kyq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ɔɔ taar jaay *Nirl Salal ɔlin̰ naan̰ taaɗɗen se, taar naaɗe Ꞌkɔŋ jaay an̰ tɛrl tap ɓo, naaɗe ɔŋ eyo, taa jeel‑taar Etien se, Nirl Salal ɓo ɛɗin̰. ");
INSERT INTO kyq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aan gɔɔ taar naaɗe an̰ tɛrl kic ɓo ɔŋ ey se, gɔtn se naaɗe goon̰ ɓaa rɛjo jee taar‑kɔɔɓge ɔɔ naaɗe paac ɓaaɗo taaɗ ɔɔ: «Naaje se kꞋbooyga te bije taar kɛn jaay Etien lee taaɗ taar iŋg kus ro *Musa ki ɔɔ ro Raa ki se.» ");
INSERT INTO kyq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gɔtn se naaɗe ɔɔs mɛtn jeege dɛna, mɛtn magal taa ɓee Yaudge ute mɛtn jee jeel taaɗn tɔɔkŋ mɛtn Ko Taar Raage tu ɔɔ naaɗe ɓaaɗo ɔkin̰a ɔɔ ɓaansin̰ naan Yaudge tun *jee kaakŋ mɛtn taarge. ");
INSERT INTO kyq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Gɔtn se naaɗe taaɗ taar‑kɔɔɓɔ ro Etien ki daala ɔɔ: «Aakki gaabm ɗaar se, naan̰ ɓo debm kɛn lee taaɗ taargen iŋg kus ro *Ɓee Raa ki ɔɔ ro *Ko Taar kɛn Raa ɛɗo Musa ki.» ");
INSERT INTO kyq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naaɗe taaɗ ɔɔ: «Naaje se kꞋbooyga booy ute bije kɛn naan̰ ɗeek ɔɔ Isan kɔɗ Nazarɛt se utu an tɔɔkŋ ute Ɓee Raa se naata ɔɔ ro nakge tun Musa dooyjeki se lɛ, naan̰ utu an̰ tɛrl Ꞌtɛɗn kuuy.» ");
INSERT INTO kyq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kɛn jee paacn̰ iŋg maakŋ ɓee kɛn Yaudge lee aakŋ mɛtn taarge se, naaɗe paac ɔnd kaamɗe ten̰en̰ Etien ki ɔɔ naaɗe aak daan kaamin̰ se tec aan gɔɔ daan kaam *kɔɗn Raa. ");
INSERT INTO kyq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Gɔtn se *magal debm tɛɗn sɛrkɛ Raa ki tɔnd mɛtin̰ ɔɔ: «Taar kꞋtaaɗ roi ki se, mɛt ki ne?» ");
INSERT INTO kyq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etien tɛrlɗen ɔɔ: «Bubumge ute gɛnaamge, uɗki bi jiga do taar kɛn mꞋasen taaɗ se. Kaaɗ kɛn *Abraam utu iŋg kiŋg taa naaŋ kɛn Mɛzapotami ki se, naan̰ kɛn se naan̰ taaɗ te taa ɗɛɛtn gɛgɛr kɛn Aran ki ey ɓɔrtɔ, gɔtn se ɓo *Raa te magalin̰ teec naanin̰ ki, ");
INSERT INTO kyq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","naan̰ ɗeekin̰ ɔɔ: Iin̰ ɔn̰ naaŋi ute taasige ɔɔ Ꞌɓaa taa naaŋ kɛn maam mꞋai taaɗa. ");
INSERT INTO kyq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Gɔtn se Abraam iin̰ ɔn̰ taa naaŋ Kaldege ɔɔ ɓaa iŋg Aran ki. Kɛn bubin̰ jaay ooy se, Raa ɗeekin̰ ɔɔ: ‹Iin̰ ɔn̰ gɔtn ese,› ɔɔ naan̰ iin̰ ɓaa iŋg taa naaŋ kɛn ɓɔrse naase utu iŋgki maak ki se. ");
INSERT INTO kyq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kɛn naan̰ jaay aan gɔtn ese, Raa taaɗin̰ ɔɔ utu an̰ kɛɗn taa naaŋ ese ɔɔ naaŋ se Ꞌkɔɔpm mɛtjilin̰ ki. Gaŋ kaaɗ kɛn se gɔtɔ cɔkɔ kic ɓo, Raa ɛɗin̰ te eyo ɔɔ gɔtn naan̰ an kɔsn mɛtin̰ kic ɓo gɔtɔ. Tɛr naan̰ kɛn se, Abraam goono kic ɓo ɔk eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Raa taaɗin̰ ɔɔ: Mɛtjilin̰ se utu ɓaa kiŋg taa naaŋ jeege tu ɔɔ jee se utu aɗen tɛɗn ɓulu ɔɔ aɗen dabar gɛn ɓaara kaar‑sɔɔ. ");
INSERT INTO kyq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gaŋ jeegen utu aɗen tɛɗn ɓulu se, Raa ɗeek ɔɔ: Jee se, maam mꞋutu mꞋaɗen kɔjn̰ bɔɔrɔ doɗe ki ɔɔ kɛn nakgen se jaay deelga num, mɛtjili se utu aɗe teecn̰ maakŋ naaŋ kɛn se ɔɔ utu aɗe ɓaa am lee keem gɔtn ara. ");
INSERT INTO kyq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gɔtn se *Raa dɔɔk ute Abraam taaɗin̰ ɔɔ n̰Ꞌɔj pɔndɔ. Bin ɓo Abraam oojn̰ goonin̰ Isaka ɔɔ kɛn Isaka jaay jꞋoojin̰ ɔk ɓii marta se, naan̰ ɔjin̰ pɔndɔ. Ɔɔ Isaka kic ɓo ɔjn̰ pɔndɔ goonin̰ *Yakub ki ɔɔ Yakub tɔj pɔndɔ gɛnin̰ge tun gaabgen sik‑kaar‑dio. Naaɗe se ɓo ɓugjege. ");
INSERT INTO kyq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Gɔtn se ɓugjege se tɛɗ maak‑kilimi ro gɛnaaɗe Yusup ki ɔɔ naaɗe ɔk ɓaa dugin̰ ji jeege tu ɔɔ jee se uun ɓaansin̰ Masar ki. Gaŋ Raa se utu te naan̰a, ");
INSERT INTO kyq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ɔɔ naan̰ ɔɔɗin̰ naatn maakŋ nakge tun ɔɔn̰ kɛn aan don̰ ki se paac. Naan̰ ɛɗin̰ jeel‑taara ɔɔ tɛɗin̰ tɛɗ debm mɛtɛkɛ ɔɔ Gaar magal gɛn Masar se aakin̰ se tɔɔlin̰. Taa naan̰ se ɓo, naan̰ ɔndin̰ magala taa naaŋ Masar ki ɔɔ ɔn̰in̰ ɓeen̰ paac kaam jin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Gaŋ cɔkɔ se, ɓo ɛnd taa naaŋ kɛn Masar ute magalin̰a ɔɔ maakŋ taa naaŋ *Kanan ki kici. Ɓo se tɔɔl dabar jeege dɛna ɔɔ ɓugjege se je nakŋ kɔsɔ kic ɓo ɔŋ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kɛn Yakub jaay booy jꞋɔɔ nakŋ kɔsɔ utu Masar ki se, deet se naan̰ ɔl ɓugjege gɛn ɓaa dugŋ nakŋ kɔsɔ. ");
INSERT INTO kyq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tɛr naan̰ ɔlɗen gɛn k‑dige ɔɔ naan̰ kɛn se, Yusup tɛɗ gɛnaan̰ge aak jeelin̰a ɔɔ gɔtn se sum ɓo, kꞋɓaa kꞋtaaɗ mɛtjil Yusup se Gaar magal kɛn taa naaŋ Masar ki se. ");
INSERT INTO kyq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusup ɔl daŋo bubin̰ Yakub kɛn iŋg taa naaŋ Kanan ki ɔɔ naan̰ ɓaaɗo ute jeen̰gen maakŋ ɓeen̰ ki paac, ɔɔ naaɗe paac se jeege sik‑cili‑kaar‑mii. ");
INSERT INTO kyq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","«Kɛn Yakub jaay booy se, naan̰ iin̰ ɓaa ute jee maakŋ ɓeen̰ ki paac taa naaŋ Masar ki. Naan̰ ute ɓugjege se, naaɗe tiŋg gɔtn ese bini ooy maak ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yoɗege se, naaɗe tɔs ɓaanɗen gɛgɛr kɛn Sicem ki ɔɔ ɓaa tɔlɗen maakŋ iiɓ kɛn Abraam dugin̰ ji gaan Omorge tu ute pudda taa naaŋ Sicem ki se. ");
INSERT INTO kyq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Aan gɔɔ kaaɗn taar kɛn Raa taaɗ Abraam ki aan kaan ɗoobin̰ ki se, jeejegen iŋg taa naaŋ Masar ki se, dir ziiɗ tɛɗga dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naaɗe tiŋg bini aan do gaar kɛn kuuy gɛn Masar kɛn jeel Yusup eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gaar se, naan̰ deb pitini ɔɔ dɛrlo jeejege. Naan̰ dabarɗeno ɔɔ tɛɗɗen utu taa tɔɔgɔ ɔɔ ɔlɗen naaɗe bini ɔn̰ gɛnɗege naatn taa Ꞌkooyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Kaaɗ kɛn se ɓo, jꞋoojn̰ *Musa. Naan̰ se goon aak bɛɛ kɛn tɔɔl Raa ki. Naan̰ tiŋg ɓee bubin̰ ki se laapa mɔtɔ. ");
INSERT INTO kyq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kɛn bubin̰ ute kon̰ jaay ɓaa ɔndin̰o naatn ɔɔ rɛsin̰o se, gɔtn se goon Gaar magal Masar ki kɛn mɛnda se, ɓaa ɔŋin̰a. Naan̰ uun ɓaansin̰ ɓeen̰ ki ɔɔ ɔkin̰ kaaɗin̰ ki aan gɔɔ goonin̰ mala. ");
INSERT INTO kyq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kꞋdooyin̰ ute nakgen jee Masar ki jeel paac se, ɔɔ naan̰ tɛɗ debm jeel‑taara ɔɔ jeel tɛɗn nakgen jiga jiga. ");
INSERT INTO kyq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Kɛn Musa jaay ɓaarin̰ aas si‑sɔɔ se, naan̰ uun doa gɛn ɓaa kaakŋ gɛnaan̰gen, gaan *Israɛlge. ");
INSERT INTO kyq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kɛn naan̰ jaay iin̰ ɓaa kaakŋ gɛnaan̰gen gaan Israɛlge se, naan̰ ɔŋ kɔɗ Masar dabar dabar gɛnaan̰ kɔɗn Israɛl. Gɔtn se naan̰ ɓaan̰o naaka, oocin̰ mɛtin̰a ɔɔ tɔnd tɔɔl ute kɔɗn Masar se. ");
INSERT INTO kyq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Bin se Musa saap ɔɔ tɛɗn bin sum ɓo, gɛnaan̰gen gaan Israɛlge se Ꞌjeele, naan̰ se Raa ɓo ɔlin̰o taa aɗen kɔɔɗn doɗe. Num gaŋ naaɗe se ɔŋ jeel ɔk te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mɛtbeen̰ki se, naan̰ ɔŋ gɛnaan̰gen gaan Israɛlge dio tɛɗ tɛɗ taara ute naapa. Gɔtn se naan̰ je aɗen tɛɗn num naaɗe kɔkŋ taasa ute naapa ɗeekɗen ɔɔ: ‹Mɛɗumge, naase lɛ Ꞌgɛnaa naapge, num gɛn ɗi jaay naase Ꞌtɛɗki taara ute naapa se?› ");
INSERT INTO kyq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Num gaŋ debm kɛn dabar dabar debin̰ se ɔt ɔl Musa naatn ɔɔ ɗeekin̰ ɔɔ: ‹Naai se, kɛn ɔndi magala gɛn kɔjn̰ bɔɔrɔ doje ki tap ɓo, naŋa? ");
INSERT INTO kyq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Lɔ naai Ꞌje am tɔɔl aan gɔɔ kɛn tɛrko naai Ꞌtɔɔlo kɔɗ Masar se lɛ?› ");
INSERT INTO kyq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kɛn Musa jaay booy taar se, naan̰ ɓeere ɔkin̰a ɔɔ naan̰ iin̰ aan̰ ɓaa iŋg taa naaŋ Madian ki aan gɔɔ cɛkɛ. Ɔɔ gɔtn naane se ɓo, naan̰ toojo gaangen gaabge dio. ");
INSERT INTO kyq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Kɛn naan̰ jaay tiŋg aas ɓaara si‑sɔɔ se, ɓii kalaŋ naan̰ iin̰ ɓaa do kɔɗ‑ɓaar cɛɛ ko kɛn kꞋdaŋin̰ Sinai ɔɔ gɔtn se Raa teecin̰ naanin̰ ki aan gɔɔ *kɔɗn Raa ɔɔ naan̰ aakin̰ se aan gɔɔ rɔɔn̰ pooɗo ɔk kɔk maakŋ ji kaag ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","«Kɛn Musa jaay aak rɔɔn̰ pooɗo ɔk maakŋ ji kaag ki ɔɔ ji kaag se ɔs ey se, naan̰ aak se ɔkin̰ taaɗ eyo. Gɔtn se naan̰ iiko gɔɔrɔ taa an̰ kaakŋ kɔkɔ. Gaŋ naan̰ booy mind Mɛljege Raa kɛn taaɗin̰ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Maam ɓo mꞋRaa gɛn ɓugi, Abraam, Isaka ɔɔ Yakub. Gɔtn se, naan̰ nirlin̰ teece ɔɔ rɔɔn̰ pooɗn kɛn ɔk kɔk maakŋ ji kaag ki se kic ɓo, naan̰ je an̰ kaak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Gɔtn se Mɛljege Raa ɗeekin̰ ɔɔ: ꞋTɔɔɗn ute saai jɛi ki se naatn, taa gɔtn naai Ꞌɗaar se, naan̰ gɔtn *salal. ");
INSERT INTO kyq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɗeere, kɔɔɗn yɛɛɓm jeemge jaay lee ɔɔɗ yɛɛɓɗe Masar ki se, maam mꞋaakga ɔɔ daayɗen naaɗe iŋg daay ɗɛs ɗɛs se kic ɓo, maam mꞋbooyga. Ɔɔ mꞋbɔɔy mꞋɓaaɗo se taa mꞋje mꞋaɗen kɔɔɗn doɗe. Ɔɔ ɓɔrse naai iin̰ ɓaaɗo, maam mꞋje mꞋai kɔli taa naaŋ Masar ki.» ");
INSERT INTO kyq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tɛr Etien taaɗɗen daala ɔɔ: «Musan kɛn gaan Israɛlge ɔɔɗ undin̰ jaay ɗeekin̰ ɔɔ: Naai se kɛn ɔndi magal gɛn kɔjn̰ bɔɔrɔ doje ki tap ɓo naŋa? Naan̰ se ɓo kɛn Raa ute ɗoobm kɔɗn Raa teecin̰o naanin̰ ki maakŋ ji kaag ki se ɓo, kɛn tɛɗga magalɗe ɔɔ debm kɔɔɗn doɗe. ");
INSERT INTO kyq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musan ese ɓo ɔɔɗɗen naatn taa naaŋ Masarge tu ute nakŋ‑kɔɔɓge ɔɔ ute nakgen deel do kɛn naan̰ tɛɗo. Tɛr naan̰ tɛɗo nakŋ‑kɔɔɓge kaaɗ kɛn naan̰ gaaŋɗeno Baar Aace ute kɛn naaɗe tiŋgo do kɔɗ‑ɓaar ki ɓaara si‑sɔɔ se kici. ");
INSERT INTO kyq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musan ese ɓo kɛn tɛr taaɗo gaan Israɛlge tu daala ɔɔ: Raa utu aseno bɛɛr kɔɔɗn maakŋ gɛnaasege tu se, deb kalaŋ kɛn utu Ꞌtɛɗn debm taaɗ taar teeco taar Raa ki aan gɔɔ maama. ");
INSERT INTO kyq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musan se ɓo, kaaɗ kɛn gaan Israɛlge tus do kɔɗ‑ɓaar ki se, debm kɛn ɗaar daan ɓugjege tu ute kɔɗn Raa kɛn ɗaar taaɗin̰ do ko kɛn Sinai ki. Naan̰ ɓo debm kɛn Raa taaɗin̰o taargen ɛɗ kaaja jaay naan̰ ɓaaɗo taaɗjesin̰ki se. ");
INSERT INTO kyq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Num gaŋ ɓugjege se baate tookŋ kuun taarin̰a, ɔɔ naaɗe ɔɔɗ undin̰a. Ɔɔ maakŋ maak‑saapɗe ki se, naaɗe je kɔkŋ tɛrl Masar ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Gɔtn se naaɗe taaɗ *Aarun ki ɔɔ: ꞋTɛɗjeki raagen kɛn Ꞌlee naanjege tu taa Musan kɛn ɔɔɗjekiro naatn maakŋ taa naaŋ Masar ki se lɛ, ɗim jaay aanin̰ don̰ ki se, naaje jꞋɔndki te mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaaɗ kɛn se, naaɗe ɔɔy ɗaap naka tec aan gɔɔ goon maraŋa. Naaɗe ɓaaɗo tɔjin̰ *sɛrkɛ naanin̰ ki ɔɔ nakŋ naaɗe tɛɗin̰ ute jiɗen ese ɓo, naaɗe den̰ ute maak‑raapo aan gɔɔ raaɗe. ");
INSERT INTO kyq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Gɔtn se, Raa tɛrlɗen naaga ɔɔ rɛs ɔn̰ɗen naaɗe lee eem nakgen Raa tɔndɗen maakŋ raa ki gɛn wɔɔr gɔtɔ se. Kɛse aan ɗoobin̰ ki aan gɔɔ taar kɛn kꞋraaŋin̰ maakŋ Kitapm gɛn jeege tun taaɗ taar teeco taar Raa ki kɛn ɔɔ: Gaan Israɛlge, daagen naase Ꞌtɔjkiro sɛrkɛ maakŋ ɓaarge tun si‑sɔɔ do kɔɗ‑ɓaar ki se, naase Ꞌtɔjin̰kiro maam ki ne? ");
INSERT INTO kyq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gɔtɔ! Naase Ꞌlee Ꞌtuunkiro ɓee maragsen kꞋdaŋin̰ Mɔlɔk ɔɔ Ꞌlee Ꞌtuunkiro nakŋ kɛn tec aan gɔɔ k‑diji gɛn maragsen kꞋdaŋin̰ Rapan; nakgen kɛn naase Ꞌtɛɗin̰ki ute jisegen se ɓo tɛɗsenga raasegen naase Ꞌlee ɛrgki naanɗe ki. Taa naan̰ se ɓo, maam mꞋutu mꞋasen tuur kɔl naan taa naaŋ Babilon ki naane.» ");
INSERT INTO kyq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tɛr Etien taaɗ ɔɔ: «Kɛn ɓugjege tiŋgo do kɔɗ‑ɓaar ki se, naaɗe ɔk *kɔrɔr gɔtn kɛn naaɗe lee dɔɔɗn ute Raa. Kɔrɔr se Musa ɗaapin̰ aan gɔɔ kɛn Raa taaɗin̰o ɔɔ naan̰ tɛɗin̰ tec aan gɔɔ kɛn naan̰ aako gɔtn Raa ki se ra ra. ");
INSERT INTO kyq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Gaŋ ɓugjege se, ɓee se naaɗe ɔn̰in̰ gɛnɗege tu ɔɔ gɛnɗege se ɓee se naaɗe tuun ɓaan ute naaɗe ɔɔ kaaɗ kɛn se Jɔsuɛ ɓo naanɗe. Naaɗe ɛnd maakŋ naaŋ kɛn mɛlin̰ge Raa tuurɗe naatn ɔɔ ɔlɗen naaɗe cirɗe. Ɓee se iŋg daanɗe ki bini aan do Gaar *Daud ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Raa se maakin̰ raap do Daud ki ɔɔ Daud se tɔnd mɛtn Raa ɔɔ n̰Ꞌan̰ kɔn̰in̰ naan̰ an̰ kɔɓm ɓee naan̰ Raa gɛn Yakub se. ");
INSERT INTO kyq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Num gaŋ ɓee ese se goonin̰ Salomon ɓo ɓaaɗo iin̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Gaŋ Raa Taaro se ɓeegen kɛn jikilimge ɓo ɔɓ te jiɗe se, naan̰ iŋg maak ki eyo. Aan gɔɔ taar kɛn Raa taaɗo maakŋ Kitapm debm taaɗ taar teeco taar Raa ki, kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Maakŋ raa se gɔtn kɛn maam mꞋiŋg mꞋɔsn gaara ɔɔ do naaŋa lɛ gɔtn tɔɔbm jɛma. Ɓee naase amki kɔɓ tap ɓo ɓee tec ɔɔ ɗi? Ɔɔ gɔtn jaay am kaasn mꞋan jamak ɓo gayo? ");
INSERT INTO kyq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nakgen ɓaa se paac se, maam ɓo mꞋtɛɗin̰ ute jim ey la?» ");
INSERT INTO kyq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tɛr Etien taaɗɗen daala ɔɔ: «Naase lɛ jee naajn̰ taarge ɔɔ bi se lɛ booy taar eyo ɔɔ maakse lɛ, mɔŋgɔ. Naase lɛ Ꞌtecki bubsege ɔɔ taar *Nirl Salal taaɗsen lɛ, naase Ꞌtookki do ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jeegen taaɗo taar teeco taar Raa ki do dɔkin̰ se, ɓugsege lee dabarɗenoga. Naaɗe tɔɔlo jee kɛn taaɗo ɓii kaan *al‑Masi Debm Daan ki se. Kɛn naan̰ jaay aan se, naase ɔɔɗ undin̰ki ɔɔ ɔk tɔɔlin̰ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Raa taaɗseno *Ko Taar kɛn naan̰ ɛɗo Musa ki se utu ɗoobm kɔɗn Raage, num gaŋ Ko Taarin̰ se naase Ꞌtook iŋgki te do ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kɛn Yaudgen *jee kaakŋ mɛtn taarge jaay booy taar Etien taaɗ bin se, maakɗe taarɗe pirin̰ aan gɔɔ dɔɔbɔ. Gɔtn se naaɗe dɔɔn̰ taarɗege ɔɔ iin̰ ro Etien ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Gaŋ Etien, kɛn maakin̰ ɗooc te *Nirl Salal se, uun kaamin̰ aak maakŋ raa ki ten̰in̰ ɔɔ naan̰ aak *nookŋ Raa wɔɔr gɔtɔ kɛlɛŋ ɔɔ aak Isa ɗaar ɗaar do ji daam Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Naan̰ ɗeekɗen ɔɔ: «ꞋBooyki! Maam mꞋaak maakŋ raa ɔɔɗ waŋ ɔɔ mꞋaak *Goon Deba se ɗaar ɗaar do ji daam Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kɛn naaɗe jaay booy taar se, gɔtn se naaɗe tɔɔɗ tɔɔy makɔn̰ɔ ɔɔ turum biɗege. Tɛr naaɗe iin̰ taa naapm paac ɓaaɗo oocin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Gɔtn se, naaɗe ɔk teecn̰sin̰ naatn maakŋ gɛgɛr kɛn se ɔɔ baagin̰ tund te koa taa an̰ tɔɔlɔ. Jeegen saaɗge se tɔɔɗ kal magalɗege ɔɔ ɓaaɗo ɔmbin̰ mɛtn jɛ goon kɔɗ ki kalaŋ kꞋdaŋin̰ Sɔl. ");
INSERT INTO kyq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ɔɔ kaaɗ kɛn naaɗe ɗaar tundin̰ tund te ko se, Etien taaɗ ɔɔ: «Mɛlum Isa, kom se ɔkin̰ kaam ji.» ");
INSERT INTO kyq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Gɔtn se naan̰ ɛrg naaŋ ki ɔɔ ɔɔɗ ɔɔy makɔn̰ɔ ɔɔ: «Mɛluma, *kusin̰ naaɗe tɛɗ rom ki se, Ꞌtɛɗɗen kalɗɛ.» Kɛn Etien jaay taaɗ taar se aas sum ɓo, gɔtn se naan̰ ooyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔl took do taar jeege tun tɔɔl Etien se. Ɓii kɛn se sum ɓo, *eglizn maakŋ gɛgɛr kɛn Jeruzalɛm ki se, kꞋbaagɗen dabar dɛna. Jee Raagen paacn̰ gɔtn ese se aan̰ wɔɔk ɓaa taa naaŋ gɛn Jude ki ute gɛn *Samari ki ɔɔ ɔɔp *jee kaan̰ naabm Isa al‑Masige sum ɓo Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jee kɛn ɔk taar *Raa ɔɔn̰ se, kɛn naaɗe jaay ɓaa duubo Etien se, naaɗe tɔɔy dɔɔk taara ɔn̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Gaŋ Sɔl se je eglizn kɛn Jeruzalɛm ki se Ꞌtɛɗn gɔtɔ. Naan̰ ɓaa ɓee ute ɓea tɔko mɛndge ute gaabgen aalga kaal maakɗe do Isa al‑Masi ki se ɔɔ ɓaaɗo ɔmbɗen daŋgay ki. ");
INSERT INTO kyq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jeegen wɔɔk se, naaɗe ɓaa lee maakŋ naaŋge tun kaam ara kaam ara ɔɔ naaɗe taaɗ Labar Jiga gɛn Isa se jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Kɛn Pilip jaay bɔɔy aan maakŋ gɛgɛr kɛn kalaŋ bini taa naaŋ Samari ki se, naan̰ ɓaa taaɗɗen taar gɛn *al‑Masi se jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jee dɛn se paac taa naapki took uun taar Pilip, taa naaɗe booyga maan nakŋ‑kɔɔɓm kɛn naan̰ lee tɛɗ se ɔɔ naaɗe mala kic aakin̰ga ute kaamɗe. ");
INSERT INTO kyq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gɔtn se sitange dɛna teec ro jeege tu ɔɔ kɛn naaɗe teec teec se tɔɔɗ tɔɔy makɔn̰ɔ ɔɔ jee kɔɔn̰ sitange se ɔŋ lapia. Gɔtn se jee k‑ruŋguyge ute jee cɛkɛɗge dɛna ɔŋ lapia kici. ");
INSERT INTO kyq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taa naan̰ se ɓo, jee kɛn maakŋ gɛgɛr kɛn ese se, maakɗe raap dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kaaɗ kɛn se gaaba kalaŋ utu tiŋg maakŋ gɛgɛr kɛn ese tap ɔɔ gaabm se ron̰ Simon. Naan̰ se, do dɔkin̰ tap ɓo naan̰ debm kɔrɗɔ ɔɔ iin̰ga num tɛɗ nakgen kɛn jee Samari ki aak kic ɔkɗen taaɗ eyo. Naan̰ tɛɗ ron̰ aan gɔɔ debm kꞋjeel jeel gɔtin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ɔnd do gaange tun sɛɛmɛ bini aan do jee magalge tu se, naaɗe paac aalin̰ maak ki. Naaɗe ɗeek ɔɔ: «Gaabm se ɓo tɔɔgŋ Raa mala kɛn kꞋdaŋin̰ Tɔɔgŋ Magal se.» ");
INSERT INTO kyq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simon jaay baag tɛɗn kɔrɗin̰ sum se, daanin̰ dɔkga. Ute kɔrɗin̰ se, naan̰ iin̰ga num tɛɗɗen nakŋ‑kɔɔɓge ɔɔ kɛn naaɗe aak tap ɓo ɔkɗen taaɗ eyo ɔɔ tɛɗ jeege paac aalin̰ maak ki. ");
INSERT INTO kyq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Num kɛn naaɗe booy taar Pilipm taaɗɗen mɛtn taar gɛn Gaar Raa ɔɔ taar gɛn Isa al‑Masi se, gɔtn se mɛndge ute gaabge took uun taarin̰a ɔɔ naan̰ *batizɗe. ");
INSERT INTO kyq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Gɔtn se Simon kic ɓo took aal maakin̰ do Isa al‑Masi ki ɔɔ naan̰ kic kꞋbatizin̰a ɔɔ gɔtn se, naan̰ ɔk mɛtn Pilip tɛc. Kɛn naan̰ jaay aak nakŋ‑kɔɔɓge ute nakgen deel do kɛn Pilip lee tɛɗ se, naan̰ aak tap ɓo ɔkin̰ taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kɛn *jee kaan̰ naabm Isa al‑Masigen Jeruzalɛm ki jaay booy jꞋɔɔ jee Samari ki kic took uunga taar Raa se, naaɗe ɔlɗeno Piɛr ute Jan. ");
INSERT INTO kyq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kɛn naaɗe jaay aan se, naaɗe tɔnd mɛtn Raa taa jee Samari ki kɛn aalga kaal maakɗe do Isa al‑Masi ki se taa Raa aɗen kɛɗn *Nirl Salal, ");
INSERT INTO kyq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","taa maakɗe ki se nam kalaŋ tap ɓo ɔŋ te Nirl Salal ey ɓɔrtɔ, num naaɗe se kꞋbatizɗe ɓo ute ro Mɛljege Isa sum. ");
INSERT INTO kyq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Gɔtn se Piɛr ute Jan baagɗen tɔnd jiɗe do jee Samari kɛn aalga kaal maakɗe do Isa al‑Masi ki se ɔɔ naan̰ kɛn se sum ɓo, naaɗe ɔŋ Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɛn Simon jaay aak jee kaan̰ naabm Isa al‑Masigen tɔnd jiɗe do jeege tun aalga kaal maakɗe do Isa al‑Masi ki jaay Raa ɛɗɗen Nirl Salal se, gɔtn se Simon taaɗ Piɛr ki ute Jan ki ɔɔ aɗen kɛɗn gurs. ");
INSERT INTO kyq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Naan̰ taaɗɗen ɔɔ: «Ɛɗumkiro tɔɔgŋ se kici, taa debm jaay kɛn maam mꞋɔndga jim don̰ ki num, Ꞌkɔŋ Nirl Salal bin kici!» ");
INSERT INTO kyq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Gaŋ Piɛr tɛrlin̰ ɔɔ: «Naai ute gursi se, ɔn̰ Raa asen kutn kap, taa maaki ki se naai saap ɔɔ ute gursi se sum ɓo naai Ꞌkɔŋ dugŋ nakŋ kɛn Raa ɛɗ jeege tu cɛr se! ");
INSERT INTO kyq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maakŋ naab kɛn ese se, naai bɛɗi gɔtɔ ute naaje, taa maakŋ naai naan Raa ki se, tɛɗ nakŋ ute ɗoobin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nakŋ naai Ꞌtɛɗ jig ey se, naai ɔɔɗ doi ro ki naatn ɔɔ tɔnd mɛtn Raa. Bin sum ɓo sɔm daan Raa utu ai tɔɔl *kusin̰igen maaki ki se. ");
INSERT INTO kyq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Taa maam mꞋaaki naai se ɔɔ nakge paac se tɛɗn gɛn naai, ɔɔ naai se ɔɔpga ɓulu gɛn tɛɗn kusin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Piɛr ute Jan se, Simon tɛrlɗen ɔɔ: «Naase mala Ꞌtɔndki mɛtn Raa taa maama, taa nakŋ naase Ꞌtaaɗki se Ꞌkaan dom ki eyo!» ");
INSERT INTO kyq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kɛn Piɛr ute Jan jaay taaɗo nakŋ kɛn naaɗe aako ɔɔ booyo gɔtn Isa ki ɔɔ taaɗa taar Raa jee Samari ki jaay aas se, naaɗe ɔk tɛrl Jeruzalɛm ki. Kɛn naaɗe ɓaa ɓaa se, maakŋ naaŋ Samarige tun ute dɛnin̰ se, gɔtn naaɗe aal maak ki paac se, naaɗe taaɗɗen Labar Jiga gɛn Isa. ");
INSERT INTO kyq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kɛn nakgen se jaay deel se, *kɔɗn Raa kalaŋ taaɗ Pilip ki ɔɔ: «Iin̰ Ꞌɓaa kaam kaam bɔɔyɔ kɛn gɔtin̰ kɔɗ‑ɓaara kɛn ɗoobm kɛn iin̰o Jeruzalɛm ki jaay bɔɔy ɓaa Gaza ki se.» ");
INSERT INTO kyq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gɔtn se Pilip naar iin̰ ɓaa. Kɛn naan̰ ɓaa ɓaa se, naan̰ uun kaamin̰ aak magala kalaŋ, kɔɗ Etiopi ɔɔ naan̰ se kaasi. Ɔɔ Nɛɛl gɛn jee Etiopi kɛn kꞋdaŋin̰ Kandas se, naan̰ ɔn̰in̰ maalin̰ paac kaam jin̰a ɔɔ naan̰ ɓo debm kɛn aakin̰ do maalin̰ge tu se. Naan̰ iŋgo Jeruzalɛm ki se gɛn keem Raa. ");
INSERT INTO kyq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kɛn naan̰ tɛrl ɓaa ɓaa se, naan̰ ook iŋg maakŋ puusin̰ ki ɔɔ dooy makɔn̰ɔ taar kɛn maakŋ Kitapm gɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi se. ");
INSERT INTO kyq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Gɔtn se *Nirl Raa ɗeek Pilip ki ɔɔ: «Aan̰ ɔŋ mɛtn debm puus se.» ");
INSERT INTO kyq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gɔtn se Pilip aan̰ ɔŋ mɛtn debm puus se, ɔɔ naan̰ booy gaabm se iŋg dooy dooy maakŋ Kitapm gɛn debm taaɗ taar teeco taar Raa ki ron̰ Ezayi se. Gɔtn se naan̰ tɛɗin̰ tɔɔsɛ ɔɔ ɗeekin̰ ɔɔ: «Taar naai iŋg dooyin̰ se tap ɓo, naai Ꞌjeel ɔk mɛtin̰ ɗey la?» ");
INSERT INTO kyq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Gaabm se tɛrlin̰ ɔɔ: «Taar se jaay nam taaɗ tɔɔkum te mɛtin̰ ey se, mꞋan̰ jeel mꞋɔɔ ɗio?» Gɔtn se kɔɗ Etiopi se taaɗ Pilip ki ɔɔ: «ꞋƁaaɗo ook iŋg cɛɛm ki taa am taaɗ tɔɔkŋ mɛtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kɛse ɓo taar Kitapm kɛn naan̰ iŋg dooyin̰ se ɔɔ taar se taaɗ ɔɔ: Naan̰ se tec aan gɔɔ baatn kꞋjꞋɔk kꞋɓaan gɛn ɓaa tɔɔlɔ, ɔɔ naan̰ aan gɔɔ *goon baatn kɛn jꞋɔj bɛɛkin̰ kic tɔɔy ey se, naan̰ kic ɓo tec bini taa naan̰ ɛɛp te taarin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Naan̰ se jꞋaakin̰ aan gɔɔ nakŋ cɛrɛ ɔɔ gɔtn kɔjn̰ bɔɔr ki se, nam tap ɓo ɓaa te mɛtin̰ ki eyo; ɔɔ mɛtjil naan̰ se lɛ, nam tap ɓo mɔɔtn taaɗ te taarin̰ eyo. Ɔɔ do naaŋ ki se kiŋg naan̰ se kꞋgaaŋin̰sin̰ga duuku. ");
INSERT INTO kyq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Gaabm se tɔnd mɛtn Pilip ɔɔ: «ꞋMooyum tu, ara se debm taaɗ taar teeco taar Raa ki se tap ɓo, taaɗ ute naŋa? Ute naan̰ malin̰ lɔɓu ute nam nam kuuy lɛ?» ");
INSERT INTO kyq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Gɔtn se Pilip uun mindin̰a ɔɔ baagin̰ taaɗn do taar kɛn naan̰ dooyin̰ se ɔɔ ute taar se, naan̰ taaɗin̰ Labar Jiga gɛn Isa. ");
INSERT INTO kyq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kɛn naaɗe uun ɗoobo ɓaa ɓaa se, gɔtn se naaɗe aak maane ɔɔ gaabm se taaɗin̰ ɔɔ: «Aaka, ɓɛrɛ jꞋɔŋga maane! Ne ɗim jaay am gaasum am *batiz ey se utu la?» ");
INSERT INTO kyq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip ɗeekin̰ ɔɔ: «Kɛn naai jaay aal maaki do Isa *al‑Masi ki num, maam mꞋai batizi.» Gaabm se tɛrlin̰ ɔɔ: «Yɛɛ, maam se mꞋtookga Isa al‑Masi se Goon Raa.» ");
INSERT INTO kyq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gɔtn se naan̰ taaɗ ɔɔ puus se kꞋɗaarin̰a ɔɔ naaɗen di se paac bɔɔy tɛlɛ maakŋ maan kɛn se ɔɔ gɔtn se Pilip batizin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kɛn naaɗe jaay teeco maan sum se, Nirl Raa uun ɓaan ute Pilip se gam. Gaabm se jaay tɛrl aakin̰ se, aakin̰ naan̰ gɔtɔ. Num kɛn naan̰ jaay uun ɗoobin̰ ɓaa ɓaa se, ɓaa ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Gaŋ Pilip aak kaak se, naan̰ aanga kaam Azɔtɔs ki sum. Maakŋ gɛgɛrge tun naan̰ aalo maak ki paac bini aan maakŋ gɛgɛr Sezare ki se, naan̰ taaɗ Labar Jiga gɛn Isa al‑Masi se jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Gaŋ kaaɗ kɛn se, Sɔl iŋg ɓo gɛn tɛɗn *kusin̰a ɔɔ gɛn tɔɔl jeegen aalga kaal maakɗe do Mɛlje Isa ki. Gɔtn se naan̰ iin̰ ɓaa ɔŋ *magal jee tɛɗn sɛrkɛ Raa ki ");
INSERT INTO kyq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ɔɔ tɔnd mɛtin̰ ɔɔ an̰ kɛɗn maktubm kɛn an̰ kɔn̰ ɗoobo ɔɔ ute maktubm se naan̰ Ꞌɓaa kɛɗn magalge tun gɛn maakŋ *ɓeege tun kɛn Yaudge lee tusn maak ki maakŋ gɛgɛr kɛn Damas ki. Ute naan̰ se jaay, naan̰ Ꞌkɔŋ ɗoobo ɔɔ kɛn jaay ɔŋga mɛndge lɔ gaabgen gam kɛn aalga kaal maakɗe do Isa ki se, naan̰ aɗeno tɔkŋ dɔɔkŋ ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kɛn naan̰ ɓaa ɓaa ɗoob ki jaay aan gɔɔr ute Damas se, gɔtn se naan̰ naar aak pooɗo raap lak lak iin̰o maakŋ raa ki ɓaaɗo deebin̰ bat. ");
INSERT INTO kyq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Gɔtn se naan̰ bɔɔy ooc naaŋ ki ɔɔ booy mind deba daŋin̰ ɔɔ: «Sɔl, Sɔl, naai tap ɓo Ꞌdabarum bin se gɛn ɗi?» ");
INSERT INTO kyq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Gɔtn se Sɔl ɗeek ɔɔ: «Mɛluma, naai tap ɓo naŋa?» Ɔɔ mind debm se ɗeekin̰ ɔɔ: «Maam ɓo Isan kɛn naai Ꞌlee Ꞌdabarum se. ");
INSERT INTO kyq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gaŋ ɓɔrse se, naai iin̰ Ꞌɓaa maakŋ gɛgɛr kɛn Damas ki ɔɔ gɔtn naane se jꞋai ɓaa taaɗn nakŋ naai utu Ꞌtɛɗa.» ");
INSERT INTO kyq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gaŋ jee mɛtin̰ kɛn kꞋɓaa tɛl se ɓeere ɔkɗe se ɗaar yip ɔŋ taaɗ taar eyo. Naaɗe booy mind deba naɓo aak te mɛlin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Gɔtn se Sɔl iin̰ ɗaara ɔɔ kɛn naan̰ jaay ɔɔɗ kaamin̰ se, kaamin̰ ɔŋ aak eyo. Gɔtn se jeen̰ge ɔkin̰ jin̰ ki jaay ɓo tɔɔɗ ɓaansin̰ Damas ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Daan ɓiige tun mɔtɔn naan̰ tiŋg se, kaamin̰ lɛ ɔŋ aak eyo, ɔs ɗim eyo ɔɔ aay eyo. ");
INSERT INTO kyq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Gaaba kalaŋ bin se, ron̰ Ananias tiŋg maakŋ gɛgɛr kɛn Damas ki. Naan̰ se debm aalga kaal maakin̰ do Isa ki kici. Gɔtn se Mɛljege Isa teecin̰ naanin̰ ki ɔɔ daŋin̰ ɔɔ: «Ananias!» Ananias took ɔɔ: «Ɔɔy Mɛluma!» ");
INSERT INTO kyq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mɛljege Isa tɛrlin̰ ɔɔ: «Iin̰ Ꞌɓaa ɗoob kɛn kꞋdaŋin̰ ɗoobm sɛɛj Taal se ɔɔ Ꞌɓaa ɓee Judas ki se, Ꞌkɔŋ gaabm kɛn kꞋdaŋin̰ Sɔl kɛn kɔɗ Tars se. Naan̰ utu iŋg gɔtn se eemum keeme, ");
INSERT INTO kyq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ɔɔ aaki aan gɔɔ naai Ananias, ɛnd ɓaaɗo ɔŋin̰a ɔɔ naai ɔndin̰ ji don̰ ki ɔɔ kaamin̰ ɔɔɗ aaka.» ");
INSERT INTO kyq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Num gaŋ Ananias tɛrlin̰ ɔɔ: «Mɛluma, maam mꞋbooy jeege ɔɔsumga maan gaabm se, taa nakgen kusin̰ kɛn naan̰ lee tɛɗin̰ jeeige tun Jeruzalɛm ki se. ");
INSERT INTO kyq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Maam se mꞋbooyga jꞋɔɔ *magal jee tɛɗn sɛrkɛ Raage tu se undin̰ga kulu gɛn ɓaaɗo tɔkŋ dɔɔkŋ jeeigen gɔtn ara.» ");
INSERT INTO kyq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gaŋ Mɛljege taaɗin̰ ɔɔ: «Ute naan̰ se kic ɓo, iin̰ Ꞌɓaa ɔŋ gaabm se, taa gaabm se maam ɓo mꞋbɛɛr mꞋɔɔɗin̰o. Naan̰ ɓo debm kɛn am tɛɗn naabuma ɔɔ utu Ꞌtaaɗn roma jeege tun Yaudge eyo ute gaarɗege ɔɔ ɓaa taaɗn gaan *Israɛlge tu kici. ");
INSERT INTO kyq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Maam mala mꞋutu mꞋan̰ taaɗn dubar kɛn naan̰ utu kɔŋ taa maama.» ");
INSERT INTO kyq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Gɔtn se Ananias iin̰ ɓaa ɛnd ɓee Judas ki, ɔŋ Sɔl ɔɔ naan̰ ɔnd jin̰ don̰ ki, ɗeekin̰ ɔɔ: «Sɔl gɛnaama, kɛse Mɛlje Isan kɛn teecio naani ki kaaɗ kɛn naai ɓaaɗo ɓaa ɗoob ki se; naan̰ ɓo ɔlumo gɔti ki taa kaami kɔɔɗn kaaka ɔɔ *Nirl Salal ai ɗooc maaki.» ");
INSERT INTO kyq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Gɔtn ese sum ɓo nakge tec aan gɔɔ naagŋ kɛn̰j parpa se naar siɗo kaamin̰ ki ɔɔ gɔtn se kaamin̰ ɔɔɗ aak gɔtin̰ ki. Naan̰ iin̰ ɗaara ɔɔ gɔtn se *kꞋbatizin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kɛn naan̰ jaay ɔsɔ ɔɔ aay se, naan̰ ɔŋ tɔɔgɔ gɔtin̰ ki. Gɔtn se Sɔl tiŋgo ɓii kandum ute jee aalga kaal maakɗe do Isa al‑Masi ki, maakŋ gɛgɛr kɛn Damas ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gɔtn ese sum ɓo, naan̰ naar baag taaɗn jeege tun maakŋ *ɓeege tun kɛn Yaudge lee tusn maak ki se, ɗeekɗen ɔɔ: «Isa se, naan̰ ɓo Goon *Raa.» ");
INSERT INTO kyq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jeegen paacn̰ lee booy taarin̰ naan̰ lee taaɗɗen se, taar se ɔkɗen taaɗ eyo ɔɔ naaɗe taaɗ ute naapa ɔɔ: «Gaabm se ɓo kɛn lee dabaro jeegen aal kaal maakɗe do Isa al‑Masi kɛn iŋg Jeruzalɛm ki se ey la? Ɔɔ naan̰ ɓaaɗo tap ɓo taa anɗen tɔk dɔɔkŋ ɓaa naan *magal jee tɛɗn sɛrkɛ Raage tu ɗaamo?» ");
INSERT INTO kyq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Gaŋ Sɔl se, naan̰ ɓii‑raa taaɗ taar Raa ɓaa ute naanin̰ sak sak ɔɔ taaɗin̰ ute maakin̰ paac. Yaudgen Damas ki se, naan̰ taaɗɗesin̰ tal ɔɔ Isa se naan̰ ɓo al‑Masi. Ɔɔ Yaudge se taar naaɗe an̰ taaɗ kic ɓo jeel eyo. ");
INSERT INTO kyq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gɔtn se Sɔl tiŋgiga ɓii dɛna maakŋ gɛgɛr kɛn Damas ki ɔɔ kaaɗ kɛn se ɓo, Yaudge dɔɔk taarɗe taa an̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Num gaŋ deb kalaŋ ɓaaɗo ɔɔj Sɔl ɔɔ: «Jeege ɛnd kɛnd tɛli gɛn kuti, taa Yaudge se tiŋg bɔɔb nɔɔrɔ ɔɔ katara taa ɗoobm gɛn gɛgɛr Damas ki se; naaɗe je an̰ kɔkŋ tɔɔlɔ.» ");
INSERT INTO kyq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Gaŋ ɓii kalaŋ nɔɔr se, jee mɛtn Sɔl ki se ɔk ɓaansin̰a, ɔlin̰ maakŋ baar ki magala ɔɔ uun bɔɔyin̰ naatn naagŋ durdur ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kɛn Sɔl jaay aan Jeruzalɛm ki se, naan̰ je ɗoobm kɛn Ꞌtum ute jee aalga kaal maakɗe do Isa *al‑Masi ki, naɓo naaɗe se ɓeerin̰ ɓeere, taa kɛn Sɔl jaay aalga kaal maakin̰ do Isa al‑Masi ki aan gɔɔ naaɗe se, naaɗe maakɗe utu naaj naaj don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Gɔtn se Barnabas took ɔkin̰a ɔɔ ɓaansin̰ naan *jee kaan̰ naabm Isage tu ɔɔ taaɗɗen ɔɔ kɛn Sɔl ɓaa ɓaa Damas ki jaay aan ɗoob ki se, naan̰ aako Mɛljege ɔɔ Mɛljege se taaɗin̰o ute taarin̰ mala. Tɛr gɔtn se naan̰ ɗeekɗen ɔɔ Sɔl Damas ki se, taaɗo taa Isa jeege tu se, aalo don̰ sak ɓeer eyo. ");
INSERT INTO kyq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ute taar naan̰ taaɗɗen se, gɔtn se jee kaan̰ naabm Isage se ɔkin̰ cɛɛɗe ki. Ɔɔ kaaɗ kɛn se maakŋ Jeruzalɛm ki se, Sɔl lee ute jee kaan̰ naabm Isage se kaam ara kaam ara ɔɔ ute ro Mɛljege se naan̰ taaɗ taar Raa jeege tu aal don̰ sak ɓeer eyo. ");
INSERT INTO kyq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naan̰ iin̰ga num lee taaɗ ute Yaudgen taaɗ taar Grɛk ɔɔ daayum lee naaj ute naaɗe naɓo naaɗe se je ɗoobm an̰ tɔɔlɔ. ");
INSERT INTO kyq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kɛn gɛnaagen ɗoobm Isa al‑Masi ki jaay booy taar se, naaɗe ɔk ɓaan ute Sɔl se maakŋ gɛgɛr kɛn Sezare ki ɔɔ gɔtn naane se, naaɗe ɔlin̰ ɓaa maakŋ gɛgɛr kɛn Tars ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kaaɗ kɛn se *eglizn gɔtn ɓaa se paac kɛngen taa naaŋ Jude ki, Galile ki ɔɔ *Samari ki paac iŋg ute lapia. Naaɗe se ɔk tɔɔgɔ ro taar Raa ki, ɓeer Mɛljege tu ɔɔ *Nirl Salal noogɗe tɛɗ dɛn ɓaa ute naanɗe. ");
INSERT INTO kyq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kaaɗ kɛn se Piɛr lee daayum maakŋ naaŋge tu kaam ara kaam ara. Ɓii kalaŋ naan̰ iin̰ ɓaa kaakŋ jee Isagen iŋg maakŋ gɛgɛr kɛn Lida ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kɛn naan̰ jaay aan se, naan̰ ɔŋ gaaba kalaŋ kꞋruŋguyu kꞋdaŋin̰ Ene tooɗ tooɗ do nakŋ tooɗin̰ ki. Gɔtn naan̰ tɛrɛc kꞋruŋguyu sum se, ɔkga ɓaara marta. ");
INSERT INTO kyq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Gɔtn se Piɛr ɗeekin̰ ɔɔ: «Ene, naai se Isa *al‑Masi ɛɗiga lapia; iin̰i, naai mala Ꞌteel nakŋ tooɗi!» Gɔtn se Ene naar iin̰ ɗaar tal. ");
INSERT INTO kyq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jeegen paacn̰ iŋg Lida ki ute jeegen paacn̰ iŋg taa naaŋ Saron ki jaay aak nakŋ se, naaɗe took aal maakɗe do Mɛlje ki. ");
INSERT INTO kyq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Maakŋ gɛgɛr kɛn Japa ki se, ɔk mɛnda kalaŋ bin se, naan̰ aalga kaal maakin̰ do Isa ki ɔɔ mɛnd se ron̰ Tabita. (Tabita ute taar Grɛk se naaɗe daŋin̰ Dɔrkas). Mɛnd se daayum naan̰ tɛɗ bɛɛ jeege tu ɔɔ lee ɛɗ nakin̰ge *sɛrkɛ jee daayge tu. ");
INSERT INTO kyq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kaaɗ kɛn Piɛr utu Lida ki ɓɔrt se, Tabita ooc kɔɔn̰ɔ ɔɔ ooyo. Kɛn naan̰ jaay ooy sum se, naaɗe roogin̰a ɔɔ uun ook ɓaa aalin̰ maakŋ ɓee kɛn raan kɛn jꞋiin̰in̰ do naapin̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aan gɔɔ Lida gɔɔr ute Japa ɗey se, jee aalga kaal maakɗe do Isa ki, kɛn iŋg Lida ki se, booy ɔɔ Piɛr utu gɔtn ese se ɔɔ naaɗe ɔl gaabge dio ɓaa daŋin̰o ɗeekin̰ ɔɔ: «ꞋƁaaɗo ɔŋje kɛskɛ tu.» ");
INSERT INTO kyq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piɛr naar iin̰ ɓaa ute naaɗe. Kɛn naan̰ jaay aan se, naaɗe ɔk ɓaansin̰ maakŋ ɓee kɛn jꞋaal yo maak ki se. Ɔɔ mɛnd‑daayge se paac ɓaaɗo ɔŋin̰ ute keeme. Gɔtn se naaɗe taaɗin̰ kalɗegen Tabita tɔjɗeno kaaɗ kɛn naan̰ utu zɛɛrɛ se. ");
INSERT INTO kyq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Gɔtn se Piɛr ɗeek jeege tun gɔtn ese ɔɔ: «KꞋteec naatn.» Ɔɔ kɛn jeege jaay teec se, naan̰ ɛrg naaŋ ki ɔɔ eem Raa. Naan̰ tɛrl kaamin̰ aak debm ooyga kooy se ɗeek ɔɔ: «Tabita iin̰i!» Gɔtn se naan̰ ɔɔɗ kaamin̰a ɔɔ kɛn naan̰ jaay aak Piɛr se, naan̰ iin̰ iŋg ute mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛr ɔl jin̰ ɔkin̰a ɔɔ uun ɗaarin̰a. Gɔtn se naan̰ daŋo jee Raage ute mɛnd‑daayge. Kɛn naaɗe jaay ɓaaɗo se, Piɛr taaɗɗen ɔɔ Tabita se, naan̰ duroga. ");
INSERT INTO kyq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kɛn jeegen paacn̰ maakŋ gɛgɛr kɛn Japa ki jaay booy taar ese se, maakɗe ki se jeege dɛna took aal maakɗe do Mɛljege tu. ");
INSERT INTO kyq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Maakŋ gɛgɛr kɛn Japa ki se, Piɛr tiŋgga dɛna gɔtn gaab kɛn debm rujn̰ daar kꞋdaŋin̰ Simon se kici. ");
INSERT INTO kyq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Maakŋ gɛgɛr kɛn Sezare ki se, gaaba kalaŋ kꞋdaŋin̰ Kɔrney ɔɔ gaabm se asgargen kaaru se, naan̰ ɓo bubɗe. Naan̰ maakŋ dɔɔl asgarge tun kꞋdaŋɗe Italige. ");
INSERT INTO kyq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gaabm se ɔk taar *Raa ɔɔn̰ɔ ɔɔ naan̰ ute jee maakŋ ɓeen̰ ki paac se, ɓeer Raa ki. Naan̰ tɛɗ bɛɛ Yaudge tun jee daayge ɔɔ daayum naan̰ lee eem Raa. ");
INSERT INTO kyq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ɓii kalaŋ kaaɗn tɛgɛr ki se, Kɔrney aak kɔɗn Raa tal tal ɛndo kɛnd ɓeen̰ ki ɔɔ kɔɗn Raa se daŋin̰ ɔɔ: «Kɔrney!» ");
INSERT INTO kyq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɛn Kɔrney jaay aak kɔɗn Raa se, ɓeer ɔkin̰a ɔɔ naan̰ taaɗ kɔɗn Raa ki ɔɔ: «Kɛse ɗio, Jaamus?» Kɔɗn Raa tɛrlin̰ ɔɔ: «Keem Raa kɛn naai lee eeme ute tɛɗn bɛɛ kɛn naai lee tɛɗ jeege tu se, Raa dirigin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ɓɔrse, ɔl jeege Japa ki taa aɗe daŋ Simon kɛn kꞋdaŋin̰ Piɛr se. ");
INSERT INTO kyq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔɔ naan̰ utu iŋg ɓee gaab kɛn kꞋdaŋin̰ Simon kɛn debm rujn̰ daara se ɔɔ gaabm se, naan̰ ɓeen̰a taa baar ki.» ");
INSERT INTO kyq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ɔɔ kɛn kɔɗn Raa jaay taaɗ taarin̰ aas jaay ɓaa se, gɔtn se Kɔrney daŋo maakŋ jee tɛɗn naabin̰ge tu se, jeege dio ute asgar kɛn jꞋɛɗin̰sin̰ kaam jin̰ se, ɔɔ asgar se, ɔk taar Raa ɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Taar kɔɗn Raa taaɗin̰ se, Kɔrney taaɗɗen mɛtin̰ paac, jaay ɓo ɔlɗen kꞋɓaa Japa ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Gɔtn se jee kɛn Kɔrney ɔlɗen naaba se iin̰ ɓaa, ɔɔ mɛtbeen̰ kɛn naaɗe ɓaa ɓaa ɗoob ki jaay aan gɔɔr ute gɛgɛr Japa se, kaaɗ kɛn se kaaɗ aanga katara. Ɔɔ naan̰ kɛn se, Piɛr ook do ɓee ki raan gɛn keem Raa. ");
INSERT INTO kyq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Gaŋ gɔtn se Piɛr nam ɓo tɔɔlin̰a ɔɔ je kɔsɔ. Kaaɗ kɛn jaay kꞋtɛɗin̰ tɛɗ kɔsɔ se, naan̰ naar aak ne ɗim iin̰o gɔtn Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naan̰ aak maakŋ raa ɔɔɗ waŋ ɔɔ aak naka aan gɔɔ kala magala kꞋdɔɔkin̰ taarin̰ gɔtɔ kaam sɔɔ ɔɔ nakŋ se bɔɔyɔ bini aan naaŋ ki tak. ");
INSERT INTO kyq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Maakŋ nak kɛn aan gɔɔ kala se, naan̰ aak napar daage paac: kɛngen jɛɗege sɔɔ sɔɔ, kɛngen ɛrg kɛrgɛ ɔɔ ute napar yeelge paac. ");
INSERT INTO kyq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gɔtn se naan̰ booy mind deba ɗeekin̰ ɔɔ: «Piɛr iin̰i, daagen se Ꞌtɔk Ꞌtɔɔlɔ ɔɔ ɔsɔ.» ");
INSERT INTO kyq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piɛr tɛrlin̰ ɔɔ: «A‑a Mɛluma! Gɔtn maam tiŋg tap ɓo daagen gɛn kɔs ey se, ɓii kalaŋ maam mꞋɔs te eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tɛr naan̰ booy mind debm se taaɗin̰ kuuy daala ɗeekin̰ ɔɔ: «Nakŋ kɛn jaay Raa tɛɗin̰ tɛɗga jiga se, naai ɔn̰te kaakin̰ aan gɔɔ nakŋ aak kusu.» ");
INSERT INTO kyq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mind debm ese se taaɗ ɗɔɔlin̰ mɔtɔ, jaay ɓo nakŋ aan gɔɔ kala se tɛrl ook ɓaa maakŋ raa ki gɔtin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piɛr, nakŋ naan̰ aak se, deel don̰a ɔɔ saap mɛtn taar nakŋ se tap ɓo, naan̰ ɔnd ute mɛtin̰ eyo. Naɓo kaaɗ kɛn se sum ɓo, jee Kɔrney ɔlɗeno se, je je ɓee Simon ɔɔ kaaɗ kɛn se naaɗe aan taa ɗoobm Simon ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gɔtn se naaɗe daŋ jee maak ki ɔɔ tɔnd mɛtɗe ɔɔ: «Gaabm ron̰ Simon kɛn kꞋdaŋin̰ Piɛr se, utu gɔtn ara ki la?» ");
INSERT INTO kyq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kaaɗ kɛn Piɛr jaay utu iŋg saap saap ɓɔrtɔ do nakŋ kɛn naan̰ aako se, gɔtn se *Nirl Salal taaɗin̰ ɔɔ: «ꞋƁooyo Piɛr! Gaabge mɔtɔ utu ɗaar gɔtn ese jei jea. ");
INSERT INTO kyq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Iin̰ bɔɔy kɛskɛ Ꞌɓaa ɔŋɗe, ɔn̰te Ꞌnaaja ɔɔ Ꞌɓaaki kalaŋ taa jee se, maam ɓo mꞋɔlɗeno gɔti ki.» ");
INSERT INTO kyq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Gɔtn se Piɛr bɔɔy ɓaa ɔŋ jee se ɔɔ ɗeekɗen ɔɔ: «Maam ɓo debm kɛn naase Ꞌjen̰ki se. Num naase Ꞌɓaakiro gɔtum ki tap ɓo bɛɛ ɗey la?» ");
INSERT INTO kyq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Naaɗe tɛrlin̰ ɔɔ: «Naaje se bubm asgargen kꞋdaŋin̰ Kɔrney se ɓo ɔljeno. Naan̰ se debm daan ki ɔɔ ɓeer Raa ki ɔɔ Yaudge ute dɛnɗe paac se, tɔɔmin̰a. Naan̰ se, ɓii kalaŋ *kɔɗn Raa ɓaaɗo taaɗin̰ ɔɔ n̰Ꞌɔl kꞋɓaa kꞋdaŋo Piɛr aɗe ɓaa ɓeen̰ ki, taa an̰ taaɗn taar Raa naan̰ Ꞌbooyo.» ");
INSERT INTO kyq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Gɔtn se Piɛr ɓaanɗen ɓeene ɔɔ ɔndɗe mɛrtɛ ɔɔ naaɗe tooɗ iip gɔtin̰ ki. Mɛtbeen̰ki Piɛr iin̰ ɓaa ute naaɗe ɔɔ gɛnaage kandum kɛn ɗoobm Isa *al‑Masi kɛn Japa ki se, daan Piɛr. ");
INSERT INTO kyq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mɛtbeen̰ kɛn kuuy se, naan̰ ute jeen̰ge aan maakŋ gɛgɛr kɛn Sezare ki. Gaŋ kɔr naaɗe utu aan te ey se, Kɔrney daŋo taasin̰ge ute mɛɗn don̰ge, naaɗe tus iŋg aak kaamin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kaaɗ kɛn Piɛr aan jaay ɛnd kɛnd ɓeen se, gɔtn se Kɔrney ɓaaɗo dɔɔɗin̰a ɔɔ ooc mɛtn jɛn̰ ki aan gɔɔ debm kɛn ɓaa keem Raa se. ");
INSERT INTO kyq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gaŋ Piɛr ɔk jin̰a ɔɔ uun ɗaarin̰ ɗeekin̰ ɔɔ: «Ɔn̰te Ꞌtɛɗn bini; iin̰ raan! Ɓɛrɛ, maam kic mꞋdebkilimi aan gɔɔ naai sum.» ");
INSERT INTO kyq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piɛr ute Kɔrney jaay ɛnd kɛnd ɓeen se, naaɗe ɓaa ɓaao ɔɔ lee taaɗ taaɗ ute naapa. Kɛn naaɗe jaay aan se, ɔŋ jeege tusga dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Gɔtn se Piɛr ɗeekɗen ɔɔ: «ꞋJeelki, maakŋ *Ko Taar Raa naaje Yaudge tu se gaasje ɔɔ jꞋɔn̰te kiŋg ute jeegen Yaudge eyo ɔɔ jꞋɔn̰te lee ɓeeɗege tu. Gaŋ maam se, Raa taaɗumga tal ɔɔ mꞋɔn̰te kaakŋ jee kuuy se aan gɔɔ jee aak kusu naanin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Taa naan̰ se ɓo, kɛn naase ɔlki jaay kꞋdaŋumo se, maam naajo te eyo num mꞋɓaaɗoga. Ɓɔrse se Ꞌtaaɗumki tu, naase tap ɓo Ꞌdaŋumkiro se taa ɗi?» ");
INSERT INTO kyq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrney tɛrlin̰ ɔɔ: «Ɓɔrse tɛɗga ɓii mɔtɔ aan kaaɗn do tɛgɛr ki aan gɔɔ kaaɗn ara se, maam mꞋiŋg mꞋeem keem Raa maakŋ ɓeem ki mꞋaak kaak bin se, mꞋaak gaaba kalaŋ ɗaar ɗaar naanum ki ute kalin̰ raap lak lak. ");
INSERT INTO kyq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Naan̰ taaɗum ɔɔ: ‹Kɔrney! Keem Raa kɛn naai lee eem se, Raa booyiga ɔɔ bɛɛ kɛn naai lee tɛɗ jeege tu se lɛ, Raa dirigin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ɓɔrse, ɔl jeege Japa ki, taa aɗe daŋ Simon kɛn kꞋdaŋin̰ Piɛr se, taa aɗe ɓaa gɔtn ara. Naan̰ ute ɓee gaab kɛn kꞋdaŋin̰ Simon kɛn debm rujn̰ daar kɛn ɓeen̰ taa baar ki se.› ");
INSERT INTO kyq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gɔtn se maam mꞋnaar mꞋɔl jeege Japa ki, taa ai ɓaa daŋa ɔɔ kɛn naai aanga se, naaje maakje raap aak eyo. Taa naan̰ se, ɓɔrse naaje kꞋtusga paac naan Raa ki ɔɔ kꞋje kꞋbooy taar kɛn Mɛljege Raa taaɗio ɔɔ ajen taaɗ se.» ");
INSERT INTO kyq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Gɔtn se Piɛr ɛɛp taarin̰a ɗeekɗen ɔɔ: «Ɗeere, maam se mꞋjeelga Raa se naan̰ bɛɛr nam eyo. ");
INSERT INTO kyq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gaŋ maakŋ mɛtjil jikilimge tun gay gay kic ɓo, debm kɛn ɓeer Raa ki ɔɔ tɛɗn nakgen ute ɗoobin̰ se, naan̰ se ɓo kɛn tɔɔl Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Raa taaɗo taarin̰ gaan *Israɛlge tu ɔɔ ute ɗoobm Isa *al‑Masi se, naan̰ ɓaanoga te Labar Jiga kɛn Ꞌkɛɗn tɔɔsɛ jeege tu. Taa Isa se, naan̰ ɓo Mɛl jeege paac. ");
INSERT INTO kyq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Naase Ꞌjeelki nakgen ɓɔrse deel taa naaŋ Jude ki paac se, nakgen se baago taa naaŋ Galile ki, kaaɗ kɛn Jan‑Batist taaɗo mɛtn taar *batɛm kɛn naan̰ lee batizo jeege se. ");
INSERT INTO kyq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Naase Ꞌjeelki Raa kɛn bɛɛr ɔɔɗ Isan kɔɗn Nazarɛt se, ɛɗin̰ga tɔɔgŋ *Nirl Salal. Ɔɔ naase Ꞌjeelki kici, Isa se leeɗoga gɔtn ɓaa se paac ɔɔ naan̰ tɛɗ bɛɛ jeege tu ɔɔ ɛɗ lapia jeege tun kɛn *Ɓubm sitange tɔkɗega tɔk kaam jin̰a, taa Raa se utu te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Naaje, *jee kaan̰ naabm Isage se, jꞋaakga ute kaamje ɔɔ kꞋbooyga ute bije, nakŋ kɛn naan̰ tɛɗo maakŋ naaŋ Yaudge tu ɔɔ maakŋ gɛgɛr kɛn Jeruzalɛm ki se. Naan̰ se ɓo kɛn Yaudge ɔk tup tɔɔlin̰ ro kaag ki se. ");
INSERT INTO kyq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gaŋ kɛn tɛɗ ɓii mɔtɔ se, Raa durin̰oga daan yoge tu ɔɔ ɔlin̰ naan̰ teec naan jeege tu, ");
INSERT INTO kyq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","naɓo naan̰ se teec te naan jeege tu paac eyo. Gaŋ naan̰ se teec naan naaje kɛn Raa bɛɛr tɔɔɗjenoga tɔɔɗ do dɔkin̰a taa naaje kꞋtɛɗn saaɗin̰ge. Naaje se, kɛn naan̰ ooy duro se kic ɓo, naaje jꞋɔsoga ɔɔ jꞋaayoga ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Naan̰ taaɗjeno ɔɔ kꞋɓaa kꞋtaaɗ Yaudge tu nakŋ kɛn naaje kꞋjꞋaako ɔɔ kꞋbooyo se ɔɔ jꞋaɗen taaɗn jꞋɔɔ: Isa se ɓo, debm kɛn Raa bɛɛr ɔɔɗin̰o gɛn kɔjn̰ bɔɔrɔ do jeege tun ooyga kooyo ɔɔ kɛngen utu zɛɛrɛ. ");
INSERT INTO kyq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jee taaɗ taar teeco taar Raa ki do dɔkin̰ se paac taaɗoga saaɗn naan̰a; naaɗe ɗeek ɔɔ: ‹Debm jaay aalga maakin̰ do naan̰ ki num, Raa an̰ tɔɔl *kusin̰in̰ se paac naatn.›» ");
INSERT INTO kyq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaaɗ kɛn Piɛr jaay utu ɗaar taaɗɗen taaɗ ɓɔrt sum ɓo, gɔtn se Nirl Salal naar bɔɔy do jeege tun paac iŋg booy booy taarin̰ se. ");
INSERT INTO kyq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yaudgen took aalga kaal maakɗe do Isa *al‑Masi kɛn ɓaaɗo ute Piɛr jaay aak nakŋ se, ɔkɗen taaɗ eyo taa naaɗe aak Raa se jeegen Yaudge ey se kic ɓo, naan̰ took ɛɗɗen Nirl Salal! ");
INSERT INTO kyq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Taa naaɗe booy jee se taaɗ taaɗ taar naaŋ jeegen kuuy ɔɔ tɔɔm Raa ɔɔ: «Raa se, naan̰ debm magal aak eyo.» Gɔtn se Piɛr taaɗɗen ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɓɔrse, jee se lɛ, Raa ɛɗɗenga Nirl Salal aan gɔɔ naaje kici. Kɛn bin num jꞋɔn̰te gaasɗeki gɛn *batizn maan.» ");
INSERT INTO kyq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gɔtn se naan̰ taaɗɗen ɔɔ: «Jee se kꞋbatizɗe ute ro Isa al‑Masi.» Ɔɔ jee kɛn kꞋbatizɗe se taaɗ Piɛr ki ɔɔ: «JꞋɔɔp jꞋiŋg ute naaɗe gɛn ɓii kandum.» ");
INSERT INTO kyq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","*Jee kaan̰ naabm Isa al‑Masige ute gɛnaagen ɗoobm Isa *al‑Masi kɛn taa naaŋ Jude ki se, ɓaa booy ɔɔ jeegen Yaudge ey se kic ɓo booyga taar *Raa ɔɔ took aalga maakɗe do ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kɛn Piɛr jaay ɔk tɛrlo Jeruzalɛm ki se, Yaudgen ɗoobm Isa al‑Masi ki se ɓaaɗo tɛɛsin̰a, ɔɔ baagin̰ mooyo. ");
INSERT INTO kyq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Naaɗe ɗeekin̰ ɔɔ: «Naaje kꞋbooyga jꞋɔɔ naai iŋgoga ɓee jeege tun Yaudge eyo ɔɔ ɔsoga ute naaɗe!» ");
INSERT INTO kyq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Gɔtn se Piɛr uun mɛtn taar nakŋ deel se paac, taaɗɗesin̰ tak tak ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ɓii kalaŋ, maam maakŋ gɛgɛr kɛn Japa ki jaay mꞋeem keem Raa se, maam mꞋaak naka tal tal iin̰o maakŋ raa ki: nakŋ se magala tec aan gɔɔ kala kꞋdɔɔkin̰ taarin̰ gɔtɔ kaam sɔɔ; nakŋ se iin̰ raan bini bɔɔy aan naaŋ ki cɛɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kɛn maam jaay mꞋbil mꞋaakin̰ se, maam mꞋaak daagen ɓeene, daagen naata, kɛngen ɛrg kɛrgɛ ɔɔ yeelge. ");
INSERT INTO kyq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Gɔtn se, maam booy mind deba ɗeekum ɔɔ: ‹Piɛr iin̰i, daagen se Ꞌtɔk, Ꞌtɔɔlɔ ɔɔ ɔsɔ.› ");
INSERT INTO kyq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Gɔtn se maam tɛrlin̰ mꞋɔɔ: ‹A‑a Mɛluma! Gɔtn maam mꞋtiŋg tap ɓo, daagen gɛn kɔs ey se, ɓii kalaŋ maam mꞋɔs te eyo.› ");
INSERT INTO kyq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tɛr maam booy mind debm se taaɗum maakŋ raa ki kuuy daala ɔɔ: ‹Nakŋ kɛn jaay Raa tɛɗin̰ tɛɗga jiga se, naai ɔn̰te kaakin̰ aan gɔɔ nakŋ aak kusu.› ");
INSERT INTO kyq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mind debm se taaɗ ɗɔɔlum mɔtɔ, jaay ɓo nakŋ aan gɔɔ kala se, tɛrl ook ɓaa maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaaɗ kɛn se sum ɓo, gaabge mɔtɔ naar aan taa ɗoobm ɓee kɛn naaje kꞋmaak ki se. Naaɗe se iin̰o Sezare ki ɔɔ jꞋɔlɗeno gɔtum ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɔɔ *Nirl Salal taaɗum ɔɔ mꞋɓaa ute naaɗe, mꞋɔn̰te naaja. ꞋBooyki, gɛnaagen mɛcɛ kɛn ɗoobm Isa al‑Masi kɛn ɓaaɗo ute maam Jeruzalɛm ki ara se, naaɗe se ɓo kɛn iŋgo ute maam ɓee gaab kɛn ese. ");
INSERT INTO kyq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Gaabm se taaɗjen ɔɔ naan̰ aakga *kɔɗn Raa ɓaaɗo ɓeen̰ ki ɔɔ kɔɗn Raa se ɗeekin̰ ɔɔ: ‹Ɓɔrse ɔl jeege Japa ki, taa aio ɓaa daŋ gaabm ron̰ Simon kɛn kꞋdaŋin̰ Piɛr se. ");
INSERT INTO kyq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Naan̰ utu ai taaɗn taar Raa ɔɔ taar se ɓo ai kɛɗn kaaja naai ki ute jeegen maakŋ ɓee ki paac.› ");
INSERT INTO kyq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kɛn maam jaay mꞋaan mꞋutu mꞋtaaɗ taaɗ sum ɓo, gɔtn se Nirl Salal naar bɔɔy doɗe ki aan gɔɔ kɛn naan̰ bɔɔyɔ deet dojege tu se. ");
INSERT INTO kyq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Gɔtn ese sum ɓo, maam mꞋnaar mꞋsaap do taar kɛn Mɛljege Isa taaɗjekiro kɛn ɔɔ: Jan se *batizo jeege te maane, num gaŋ naase se jꞋutu jꞋasen *batizn ute Nirl Salal. ");
INSERT INTO kyq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jee se maam mꞋaakga Raa ɛɗɗenga Nirl Salal aan gɔɔ kɛn naan̰ ɛɗjekiro naajege tun jꞋaalkiga kaal maakjege do Isa al‑Masi ki se kici. Bin se, maam tap ɓo mꞋnaŋa jaay mꞋgaasn Raa do nak kɛn naan̰ ɓaa ɓaa tɛɗa se?» ");
INSERT INTO kyq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kɛn naaɗe jaay booy taar kɛn Piɛr taaɗɗen se, naaɗe paac ɓaa doa. Gɔtn se naaɗe *nook Raa ɗeek ɔɔ: «Ɗeere, Raa se ɔɔɗga ɗoobo jeege tun Yaudge ey se kici, gɛn tɛrl maakɗe do Raa ki taa kɔŋ *kaajn̰ gɛn daayum.» ");
INSERT INTO kyq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kɛn jaay kꞋtɔɔl Etien sum se, jee ɗoobm Isa *al‑Masi ki se, kꞋbaagɗe dabara. Taa naan̰ se ɓo, naaɗe aan̰ wɔɔk ɓaa taa naaŋge tun kuuy. Jee mɛtin̰ge ɓaa taa naaŋ Pɛnisi ki ɔɔ kɛngen mɛtin̰ge ɓaa taa naaŋ Sipir ki ɔɔ mɛtin̰gen kuuy ɓaa maakŋ gɛgɛr kɛn Antiɔs ki. Ɔɔ gɔtn kɛn naaɗe aanga ro ki se, naaɗe taaɗ taar Raa se Yaudge tu kalɗe ki sum. ");
INSERT INTO kyq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gaŋ maakɗe ki se, jee mɛtin̰ge iin̰o taa naaŋ Sipir ki ute maakŋ gɛgɛr kɛn Sirɛn ki jaay aan maakŋ gɛgɛr kɛn Antiɔs ki se, naaɗe taaɗ Labar Jiga gɛn Mɛljege Isa se jeege tun Yaudge ey kici. ");
INSERT INTO kyq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gɔtn se tɔɔgŋ Mɛljege Raa utu te naaɗe; taa naan̰ se ɓo jeege dɛna took taar Raa ɔɔ aal maakɗe do Mɛljege tu Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jee *eglizn Jeruzalɛm ki jaay, taar se ɓaa ooc biɗe ki se, gɔtn se naaɗe ɔl Barnabas taa aɗe ɓaa kaakŋ jee kɛn aal maakɗe do Isa al‑Masi kɛn maakŋ gɛgɛr kɛn Antiɔs ki se. ");
INSERT INTO kyq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas se, naan̰ debm jiga, aal maakin̰ paac do Isa al‑Masi ki, ɔɔ naan̰ se maakin̰ ɗooc ute *Nirl Salal. Kɛn naan̰ jaay aan Antiɔs ki jaay aak bɛɛ kɛn Raa tɛɗ jee Isa al‑Masige tun gɔtn ese se, naan̰ maakin̰ raapo ɔɔ dɛjɗe ɔɔ jꞋiŋg kꞋdɔɔk ute Mɛljege Isa al‑Masi se tɔɔgɔ. Gɔtn se jeege dɛna took taar Mɛljege ɔɔ ziiɗ do jee Isa al‑Masige tun gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Gɔtn se Barnabas iin̰ ɔn̰ɗe ɔɔ ɓaa gɛgɛr kɛn Tars ki gɛn ɓaa je Sɔl. ");
INSERT INTO kyq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kɛn naan̰ jaay ɓaa ɔŋin̰ se, naaɗe kꞋɓaaɗo kalaŋ maakŋ gɛgɛr kɛn Antiɔs ki. Maakŋ ɓaar kɛn ute magalin̰ paac se, naaɗe lee tus ute jee egliz kɛn gɔtn ese ɔɔ jeege dɛna naaɗe lee dooyɗe ute taar Raa. Maakŋ gɛgɛr kɛn Antiɔs ki sum ɓo, jeegen aalga kaal maakɗe do Isa al‑Masi ki se kꞋbaagɗe daŋ ute ro: jee al‑Masige. ");
INSERT INTO kyq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kaaɗ kɛn se, jee kɛn taaɗ taar teeco taar Raa ki iin̰o Jeruzalɛm ki, bɔɔy ɓaaɗo maakŋ gɛgɛr kɛn Antiɔs ki. ");
INSERT INTO kyq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Maakɗe ki se, deb kalaŋ kꞋdaŋin̰ Agabus, *Nirl Salal ɔlin̰ naan̰ iin̰ ɗaara ɔɔ taaɗ jeege tu ɔɔ: «Gɔtɔ ɓaa se paac, ɓo utu tɔɔl tɛɗn daama jeege tu.» Ɔɔ ɓo kɛn Agabus taaɗn ese se, tɔɔlo jeege do Gaar magal *Rɔm kɛn kꞋdaŋin̰ Klɔd. ");
INSERT INTO kyq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Gɔtn se jee aal maakɗe do Isa *al‑Masi kɛn gɔtn ese se jaay booy taar se, naaɗe uun doa taaɗ ɔɔ: «Naŋa naŋa kic ɓo, nakŋ naan̰ ɔk se ɓaano kaam do ron̰ ron̰a, taa jꞋan ɓaa noogŋ gɛnaagen ɗoobm Isa al‑Masi kɛn taa naaŋ Jude ki.» ");
INSERT INTO kyq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kɛn naaɗe jaay tusin̰ aas se, naaɗe ɛɗin̰ ji Barnabas ki ute Sɔl ki taa an̰ ɓaa kɛɗn ji jee naan jee *eglizge tun taa naaŋ Jude ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kaaɗ kɛn se, Gaar Ɛrɔd baag dabar jee *eglizgen mɛtin̰ge. ");
INSERT INTO kyq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naan̰ kɛn se Jak gɛnaa Jan se, Ɛrɔd ɔl kꞋgaaŋ don̰a ute gɔrɗ‑jɛrlɛ. ");
INSERT INTO kyq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kɛn naan̰ aak nakŋ naan̰ tɛɗ jaay tɔɔl Yaudge tu se, tɛr naan̰ ɔk Piɛr se ɔlin̰ daŋgay ki ɔɔ kaaɗ kɛn se, jeege tɛɗ tɛɗ Laa mappan ɔk ɔrɔm eyo. ");
INSERT INTO kyq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kɛn naan̰ jaay ɔk kɔl Piɛr daŋgay ki se, gɔtn se naan̰ tɔmb asgarge sɔɔ sɔɔ gɔtɔ kaam sɔɔ taa an̰ bɔɔbɔ. Naan̰ je ɓii *laa Paak se jaay deelga num, Piɛr se naan̰ an̰o kɔkŋ ɓaa naan Yaudge tu taa an̰ kɔjn̰ bɔɔrɔ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gaŋ kɛn Piɛr jaay daŋgay ki se, gɔtn se jee egliz ki se daayum tɔnd mɛtn *Raa ute maakɗe paac taa naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ey num, ɔɔp mɛtbeen̰ki sum ɓo *Ɛrɔd je utu Ꞌkɔjn̰ bɔɔrɔ do Piɛr ki naan jeege tu. Gaŋ maakŋ nɔɔrin̰ kɛn se, Piɛr se tooɗ tooɗ bia daan asgarge tu dio ɔɔ jin̰ge se, jꞋɔlin̰ zin̰ziri do jin̰ kɛn kaam ara ɔɔ do jin̰ kɛn kaam naane kici ɔɔ asgargen kuuy ɗaar bɔɔb bɔɔb taa ɗoobo. ");
INSERT INTO kyq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gaŋ gɔtn ese sum ɓo, kɔɗn Mɛljege Raa naar ɓaaɗo ɗaar cɛɛn̰ ki ɔɔ maakŋ daŋgay ute magalin̰ se wɔɔr kɛlɛŋ ɔɔ kɔɗn Raa tɔnd dur Piɛr ɗeekin̰ ɔɔ: «Iin̰ yɔkɔɗɔ!» Gɔtn se, zin̰zirgen jin̰ ki se tɔɔɗ si naatn kalɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ɔɔ kɔɗn Raa tɛrlin̰ ɔɔ: «ꞋDɔɔk maaki ɔɔ tɔɔl saai jɛi ki.» Piɛr took taar kɔɗn Raa ɔɔ tɛɗ aan gɔɔ kɛn naan̰ taaɗin̰. Tɛr kɔɗn Raa taaɗin̰ daala ɔɔ: «Uun uus kal magali se roi ki ɔɔ ɔk mɛtuma.» ");
INSERT INTO kyq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Gɔtn se Piɛr teeco naatn maakŋ daŋgay ki ɔɔ ɔk mɛtn kɔɗn Raa se. Maakŋ saapin̰ ki se ɔɔ daan naan̰ ni nia lɛ ɗaam; ey num, gɔtn se naan̰ jeel te eyo nakŋ kɔɗn Raa tɛɗ jaay ɗeer se. ");
INSERT INTO kyq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Gɔtn se, naaɗe deel ɔn̰ asgargen jꞋɔmbɗe deet deet se, ɔɔ kɛngen gɛn k‑dige se kic, naaɗe deel ɔn̰ɗe ɔɔ naaɗe aan cɛɛ kaam taar kɛn kꞋɗaapin̰ ute maala kɛn jꞋɔɔɗin̰ga num jꞋɛnd kꞋɓaa maakŋ gɛgɛr ki se. Kɛn naaɗe jaay aan gɔtn ese se, taa ɗoobo se ɔɔɗ kalin̰ ki sum. Kɛn naaɗe teec gɔtn ese jaay lee aan gam daan ɗoob ki sum se, naan̰ aak kaakŋ kɔɗn Raa se gɔtɔ cɛɛn̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Gɔtn se Piɛr nam ɔk ron̰a ɔɔ ɗeek ɔɔ: «Ɓɔrse jaay, maam mꞋjeel mꞋɔkga ɗeer ɗeer, Mɛljege Raa se ɔloga kɔɗin̰ ɓaaɗo ɔɔɗumga naatn kaam ji Gaar Ɛrɔd ɔɔ aajumga do nakge tun kɛn Yaudge je amsin̰ tɛɗn dom ki se.» ");
INSERT INTO kyq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kɛn naan̰ jaay jeel ɔk ron̰ sum se, naan̰ ɓaa ɓee mɛnd ki kalaŋ bini ron̰ Mari. Mari se naan̰ ɓo ko Jan kɛn kꞋdaŋin̰ Mark kici. Gɔtn ese se, jeege tusga dɛna tɔnd tɔnd mɛtn Raa taa naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kɛn naan̰ aan jaay baag tɔnd taa kaam taar se, gɔtn ese mɛnd tɛɗn naabm kɛn kꞋdaŋin̰ Roda se, booy Piɛr tɔnd tɔnd kaam taara se, naan̰ ɓaaɗo taa an̰ kɔɔɗn kaam taara. ");
INSERT INTO kyq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kɛn naan̰ jaay booy jeel mind Piɛr sum se, maakin̰ raapo, ɔɔ kaam taara se naan̰ baate kɔɔɗin̰a, gaŋ naan̰ ɔk tɛrl aan̰ ɓaa taaɗ jeege tun maak ki ɔɔ: «Ɓɛrɛ, Piɛr se ɓaaɗoga! Naan̰ utu ɗaar taa ɗoob ki naane.» ");
INSERT INTO kyq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Naaɗe tɛrlin̰ ɔɔ: «Naai se, doi Ꞌdɛrlga lɛ ɗaam!» Gaŋ naan̰ dɔɔk taara ɔn̰ eyo taaɗɗen ɔɔ: «Ɗeere.» Gɔtn se naaɗe taaɗin̰ ɔɔ: «Kaaɗn naane Ꞌtɛɗn kɔɗn Raan̰a lɛ ɗaam.» ");
INSERT INTO kyq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Gaŋ Piɛr se ɗaar tɔnd kaam taara se ɔn̰ eyo. Kɛn naaɗe ɓaaɗo ɔɔɗ kaam taara jaay ɔŋin̰ naan̰ se, paac tap ɓo ɔkɗen taaɗ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Gɔtn se Piɛr tɛɗɗen ute jin̰a ɔɔ kꞋdoa. Ɔɔ naan̰ taaɗɗen mɛtn taar kɛn tɛɗ ɔɔ ɗi jaay Mɛljege ɔɔɗin̰o maakŋ daŋgay ki naatn se. Gɔtn se naan̰ taaɗɗen ɔɔ: «KꞋɓaa kꞋtaaɗ Jak ki ute gɛnaagen kuuy ɗoobm Isa *al‑Masi ki.» Bin jaay, naan̰ teec ɔn̰ɗe ɔɔ ɓaa gɔt kuuy. ");
INSERT INTO kyq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kɛn mɛtbeen̰ki jaay asgarge aak Piɛr gɔtɔ maakŋ daŋgay ki se, gɔtn se naaɗe nirlɗe teece ɔɔ ɗoobm roɗe tap ɓo, naaɗe jeel eyo. Naaɗe taaɗ te naapa ɔɔ: «Piɛr tap ɓo, ɓaaga gay?» ");
INSERT INTO kyq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gɔtn se Ɛrɔd ɔl jeege gɛn je Piɛr; naɓo naaɗe je ɔŋin̰ eyo. Naan̰ daŋo asgargen iŋg bɔɔb Piɛr se, tɔnd mɛtɗe taa Piɛr. Kɛn naaɗe jaay ɔŋ tɛrlin̰ te taar ɗim ey se, naan̰ und kulu jeege tu ɔɔ jee se kꞋtɔɔlɗe naata. Naan̰ kɛn se, Gaar Ɛrɔd iin̰ taa naaŋ Jude ki se ɓaa tiŋg cɔkɔ maakŋ gɛgɛr kɛn Sezare ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jee Tir ute jee Sidɔŋ ki se, nakŋ kɔsɗe paac se iin̰o taa naaŋ Gaar Ɛrɔd ki. Ɓii kalaŋ, Gaar Ɛrɔd se maakin̰ taarin̰ doɗe ki. Taa naan̰ se, naaɗe je ɗoobm kɛn Ꞌkɔkŋ taasa ute naan̰a. Gɔtn se naaɗe ɓaa ɔŋ gaaba kalaŋ bini kꞋdaŋin̰ Blatus ɔɔ Blatus se, naan̰ ɓo debm kɛn lee bɔɔb ɓee kɛn gaarge lee tooɗn se. Naaɗe tɛɗin̰ naan̰ tooko ɔlɗe naaɗe ɓaa ɔŋ gaarge taa ɓaa kɔkŋ taasa ute naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Gɔtn se Gaar Ɛrɔd gaaŋɗen ɓiia ɔɔ kɛn ɓii naan̰ gaaŋɗen jaay aas se, naan̰ uun uus kal gaarin̰a ɔɔ ɓaaɗo iŋg do kaag do ki ɔɔ gɔtn se naan̰ baag taaɗn taara jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kɛn jee iŋg gɔtn ese jaay booy taar naan̰ taaɗ se, naaɗe taaɗ makɔn̰ɔ ɔɔ: «Kɛn taaɗ se debkilimi sum eyo; num kɛse aan gɔɔ Raa mala ɓo taaɗa.» ");
INSERT INTO kyq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kɛn Ɛrɔd jaay booy taar jeegen taaɗin̰ bin se, naan̰ don̰ oopo ɔɔ magal ron̰a ɔɔ gɔtn se naan̰ baate *nookŋ Raa. Kaaɗ kɛn se sum ɓo, *kɔɗn Raa tɛɗin̰ ooc kɔɔn̰ɔ ɔɔ ɔlin̰ kuuru maakin̰ ki ɔs tɔɔlin̰ naata. ");
INSERT INTO kyq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naan̰ kɛn se, jee kɛn booy taar Raa se ɓaa ziiɗ tɛɗ ro naapki dɛna ɔɔ gɔtn se jeege dɛna took aal maakɗe do taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naan̰ kɛn se, Barnabas ute Sɔl jaay naŋ naabɗe Jeruzalɛm ki sum se, naaɗe ɓaa ɓaa se ɔk ɓaan ute deb kalaŋ kꞋdaŋin̰ Jan‑Mark se ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Maakŋ jeege tun *egliz kɛn Antiɔs ki se, gɔtn se ɔk jee kɛn taaɗ taar teeco taar Raa ki ute jee kɛn lee dooy jeege ute taar *Raa: jee se naaɗe Barnabas, Simɛon kɛn kꞋdaŋin̰ Debm ilimi, Lusius kɛn kɔɗ Sirɛn, Sɔl ɔɔ Manaɛn kɛn teep ute *Ɛrɔd Antipas. ");
INSERT INTO kyq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ɓii kalaŋ jee se jaay eem keem Raa ɔɔ uun *siam se, maakɗe ki se, deb kalaŋ Nirl Salal ɔlin̰ ɗeekɗen ɔɔ: «Barnabas ute Sɔl se, Ꞌbɛɛr tɔɔɗɗeki maam ki taa mꞋaɗen kɛɗn naabm kɛn maam mꞋdaŋɗeno taarin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kɛn naaɗe jaay eem Raa aasa ɔɔ baag kɔsɔ se, gɔtn se naaɗe tɔndɗen jiɗe doɗe ki ɔɔ ɔlɗe gɛn ɓaa tɛɗn naabm kɛn Nirl Salal daŋɗeno taarin̰ se. ");
INSERT INTO kyq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aan gɔɔ *Nirl Salal ɓo ɔlɗen gɛn tɛɗn naabin̰ se, Barnabas ute Sɔl iin̰ bɔɔy ɓaaɗo Selusi ki. Gɔtn se naaɗe ook maakŋ markab ki ɔɔ gaaŋ baar ɓaa taa naaŋ Sipir ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kɛn naaɗe jaay aan maakŋ gɛgɛr kɛn Salamin kɛn taa naaŋ Sipir ki se, naaɗe baag taaɗn taar Raa jeege tu maakŋ *ɓeege tun kɛn Yaudge lee tusn maak ki. Kaaɗ kɛn se, Jan‑Markŋ kɛn debm noogɗe se utu te naaɗe. ");
INSERT INTO kyq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kɛn naaɗe jaay aal taa naaŋ Sipir ki bini aan taar ki se, naaɗe aan maakŋ gɛgɛr kɛn kꞋdaŋin̰ Papos. Gɔtn se naaɗe ɔŋ kɔɗ Yaud kalaŋ bini kꞋdaŋin̰ Bar‑Isa. Naan̰ debm kɔrɗɔ ɔɔ tɛɗ ron̰ aan gɔɔ debm taaɗ taar teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Naan̰ se tiŋg te magal gɛn taa naaŋ gɔtn ese. Magal ese se ron̰ Sirgus Pɔlus ɔɔ gaabm se debm jeel naka. Naan̰ daŋo Barnabas ute Sɔl ɓeen̰ ki. Naan̰ je naaɗe an̰ taaɗn taar Raa naan̰ Ꞌbooyo. ");
INSERT INTO kyq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Anum, debm kɔrɗŋ ese se ute taar Grɛk se kꞋdaŋin̰ Ɛlimas kici, naan̰ took Barnabas ki ute Sɔl ki eyo, taa naan̰ je eyo kɛn magal taa naaŋ gɔtn ese jaay Ꞌkaal maakin̰ do Isa ki se. ");
INSERT INTO kyq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Gɔtn se Sɔl, kꞋdaŋin̰ Pɔl, jaay Nirl Salal ɗooc maakin̰ se, gaabm se naan̰ aakin̰ ɔŋ ciu, ");
INSERT INTO kyq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɔɔ naan̰ ɗeekin̰ ɔɔ: «Naai lɛ, taar‑kɔɔɓɔ deeliga deele ɔɔ Ꞌlee Ꞌdɛrl dɛrl jeege. Naai lɛ, Ꞌgoon *Ɓubm sitange ɔɔ nakŋ ute ɗoobin̰ se lɛ, naai je eyo ɔɔ nakŋ kɛn Mɛljege jen̰ ro ki se lɛ, daayum naai je an̰ tujn̰ naatn. ");
INSERT INTO kyq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ɓɔrse Ꞌbooyo: Raa ai kɔki ute kaaka ɔɔ naai utu tɛɗn kaam‑tɔɔkɔ ɔɔ ɓii kando kando naai Ꞌkɔŋ kaakŋ kaaɗ eyo.» Gɔtn ese sum ɓo, gɔtɔ naar tɛɗin̰ ilim dib ɔɔ naan̰ ɔŋ aak ɗim eyo ɔɔ naan̰ tɛrl kaam ara kaam ara je nam an̰ kɔkŋ jin̰ ki ɔɔ an̰ tɔɔɗɔ. ");
INSERT INTO kyq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kɛn magal taa naaŋ gɔtn ese jaay aak nakŋ kɛn aan do gaab kɛn ese se, naan̰ took aal maakin̰ do Isa ki. Gɔtn se taar Mɛljege se ɛndga maakin̰ ki ɗeer ɗeer. ");
INSERT INTO kyq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Papos ki se, Pɔl ute jeen̰ge ook maakŋ markab ki, ɔɔ gaaŋ baar ɓaa maakŋ gɛgɛr kɛn kꞋdaŋin̰ Pɛrg kɛn taa naaŋ Pampili ki. Kɛn naaɗe jaay aan gɔtn ese se, Jan‑Mark iin̰ rɛsɗe ɔɔ ɔk tɛrl ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Gaŋ Pɔl ute jeen̰ge iin̰ Pɛrg ki, naaɗe uun ɗoobm Antiɔs kɛn taa naaŋ Pizidi ki. Kɛn naaɗe jaay aan gɔtn ese se, ɓii kalaŋ aan *ɓii sebit ki se, naaɗe ɓaa ɛnd iŋg maakŋ *ɓee kɛn Yaudge lee tusn maak ki gɛn keem Raa se. ");
INSERT INTO kyq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kɛn kꞋdooy *Ko Taar kɛn Raa ɛɗo Musa ki ute kɛn gɛn jee taaɗ taar teeco taar Raa ki jaay aas se, gɔtn se magalgen gɛn ɓee kɛn Yaudge lee tusn maak ki se ɔl deba ɓaa taaɗɗen ɔɔ: «Gɛnaajege, kɛn naase jaay ɔkki taar jaay anki dɛjn̰ jeege num, iin̰ Ꞌtaaɗɗeki.» ");
INSERT INTO kyq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Gɔtn se Pɔl iin̰ ɗaara tɛɗɗen ute jin̰a taa kꞋdoa ɔɔ ɗeekɗen ɔɔ: «Naase gaan *Israɛlge ɔɔ ute naasen kɛn jee ɓeer Raa ki se, Ꞌbooyki taar kɛn maam mꞋasen taaɗ se. ");
INSERT INTO kyq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Raa naajen Israɛlge se, bɛɛr tɔɔɗɔ bubjege; naan̰ dirɗe ooj tɛɗ dɛna taa naaŋ Masar ki, ɔɔ ute tɔɔgin̰ se, naan̰ ɔɔɗɗeno naatn maakŋ taa naaŋ Masar ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Do kɔɗ‑ɓaar ki se, nakŋ ɓaa ɓaa ɓaara si‑sɔɔ se, naan̰ ɓo aakɗeno doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tɛr, taa naaŋ kɛn *Kanan ki se mɛtjil jeegen kaam cili se, naan̰ utɗen naata ɔɔ naaŋɗe se, naan̰ ɛɗin̰ gaan Israɛlge tu ɔɔ naaŋ se tɛɗɗen naaŋɗe mala. ");
INSERT INTO kyq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kɛn nakgen se jaay daanin̰ deel paac se, ɔk nakŋ ɓaa ɓaa ɓaara kaar‑sɔɔ‑ute‑si‑mii. «Tɛr bubjege naan̰ tɔndɗen magalge daanɗe ki, gɛn kaakŋ mɛtn taarɗege. Magalgen ese se, naan̰ lee tɔndɗesin̰ bini aan do Samuɛl kɛn debm taaɗ taar teeco taar Raa ki se. ");
INSERT INTO kyq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aan do Samuɛl ki se, bubjege tɔnd mɛtn Raa, ɔɔ naaɗe je gaarge. Gɔtn se Raa ɔndɗen Saul, goon Kis, kɛn teeco taa ɓee Benjamin ki ɔɔ naan̰ se ɔs gaara gɛn ɓaara si‑sɔɔ. ");
INSERT INTO kyq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kɛn ɓaara si‑sɔɔ jaay aas se, Saul se Raa ɔɔɗin̰ maakŋ gaarin̰ ki naatn ɔɔ naan̰ bɛɛr ɔɔɗɗen *Daud ɓo tɛɗɗen gaarɗe. Do Daud ki se, Raa taaɗ ɔɔ: Maam mꞋɔŋga Daudn goon Jɛsɛ kɛn maam jen̰a. Naan̰ ɓo debm kɛn utu Ꞌtɛɗn nakgen paacn̰ kɛn maakum jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Maakŋ mɛtjil Daud ki se, Raa bɛɛr ɔɔɗo gaaba kalaŋ daan Israɛlge tu ron̰ Isa, taa aɗen kaaja. Bin ɓo, taar do dɔkin̰ Raa taaɗo Daud ki se, aanga ɗoobin̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kaaɗ kɛn Isa tɛɛs te naabin̰ ey ɓɔrt se, Jan‑Batist ɓaaɗo taaɗ gaan Israɛlge tu paac ɔɔ: ‹ꞋTɛrlki maakse do Raa ki ɔɔ Ꞌɓaakiro jꞋasen *batizi.› ");
INSERT INTO kyq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aan do naŋ naabin̰ ki se, Jan‑Batist taaɗo ɔɔ: ‹Maakŋ maak‑saapse ki se, naase tap ɓo ɔɔki maam se naŋa? Ɓɛrɛ, maam se *mꞋal‑Masi kɛn naase iŋg aakki kaamin̰ se eyo! ꞋƁooyki, naan̰ se utu ɓaaɗo mɛtum ki ɔɔ naan̰ se, gɛn tɔɔɗn saa jɛn̰ ki kic ɓo, maam mꞋaas eyo.› ");
INSERT INTO kyq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Gɛnaamge, naasen kɛn mɛtjil *Abraamge, ɔɔ naasen iŋgki maakɗe ki jaay Ꞌɓeerki Raa ki se, Ꞌbooyki, taa naajege ɓo Raa ɓaano ute taar se taa ajeki kaaja. ");
INSERT INTO kyq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kɛn Isa jaay aan se, jee Jeruzalɛm ki ute magalɗege se, Isa se naaɗe jeelin̰ te aan gɔɔ al‑Masi eyo. Ɔɔ taar kɛn jee taaɗ taar teeco taar Raa ki raaŋo do dɔkin̰ jaay, aanga ɓii sebit ki tak ɓo naaɗe lee dooyin̰ se, naaɗe tɛɗin̰ga aanga ɗoobin̰ ki. Taa naan̰ se ɓo, naaɗe ɔjin̰ bɔɔrɔ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ey num, naaɗe ɔŋ te taar ɗim kɛn aas tɔɔlin̰ eyo. Ute naan̰ se kic ɓo, naaɗe taaɗ Pilat ki ɔɔ: ‹KꞋtɔɔlin̰ naatn!› ");
INSERT INTO kyq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kɛn Yaudge jaay tɛɗin̰ nakge don̰ ki aas aan gɔɔ kɛn Kitap taaɗo do dɔkin̰ se, maakɗe ki se, jee mɛtin̰ge ɓaaɗo uun bɔɔyin̰ naatn ro kaag ki ɔɔ ɓaa ɔlin̰ maakŋ iiɓ ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Num gaŋ Raa se durin̰oga daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jee leeɗo ute naan̰ Galile ki bini aan Jeruzalɛm ki se, kɛn naan̰ ooy duro se maakŋ ɓiige tu dɛna, naan̰ lee teec naanɗe ki. Ɔɔ jee se ɓo ɓɔrse tɛɗga saaɗin̰ge naan jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Ɓɔrse naaje kꞋɓaaɗo se, taa jꞋasen taaɗn labar jiga se kici ɔɔ labar se ɓo, kɛn Raa taaɗo bubjege tu do dɔkin̰a ɔɔ tɛɗga num naan̰ utu aɗen kɛɗn nakŋ naan̰ taaɗga ɔɔ utu aɗen kɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Taar kɛn naan̰ taaɗo do dɔkin̰ ɔɔ an̰ tɛɗ se, ɓɔrse naan̰ tɛɗin̰ga do naaje gɛnɗege tu kɛn naan̰ duro Isa daan yoge tu se, aan gɔɔ taar kɛn kꞋraaŋin̰o do dɔkin̰ maakŋ Kaa Keem Raa gɛn k‑dige tu kɛn ɔɔ: Naai se ɓo Ꞌgoonuma. Gɔtn jaaki sum se, maam ɓo mꞋtɛɗga bubi. ");
INSERT INTO kyq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Raa se duroga Isa daan yoge tu, ron̰ se naan̰ ɔn̰in̰ ruum te maakŋ ɓaaɗ ki eyo. Kɛse ɓo taar kɛn naan̰ taaɗo Daud ki do dɔkin̰a kɛn taaɗin̰ ɔɔ: Maam mꞋutu mꞋasen tɛɗn bɛɛ dɛn aak eyo ɔɔ nakgen mɛt ki kɛn maam mꞋɗeeko mꞋɔɔ mꞋutu mꞋkɛɗn Daud ki se mꞋutu mꞋasesin̰ kɛɗn ɗeer ɗeer. ");
INSERT INTO kyq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Taa ɗi gɔt kuuy kic maakŋ Kitap ki se, Daud taaɗ Raa ki ɔɔ: Debm naai se, naai an̰ kɔŋ kɔn̰in̰ ruum maakŋ ɓaaɗ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Num kɛn naabm kɛn Raa jen ro ki jaay Daud tɛɗin̰ aas se, gɔtn se naan̰ ooyo ɔɔ jꞋuun jꞋɔl kꞋjꞋaalin̰ maakŋ iiɓ ki do bubin̰ge tu ɔɔ naan̰ kic ruumga aan gɔɔ naaɗe se kici. ");
INSERT INTO kyq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Gaŋ Isa jaay ooy se, ruum te maakŋ iiɓ ki eyo, num naan̰ se Raa durin̰oga daan yoge tu. ");
INSERT INTO kyq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Gɛnaamge, Ꞌjeelki, naaje kꞋɓaaɗo se kꞋje jꞋasen taaɗn nakŋ kɛn jaay Isa tɛɗo se. Ute nakŋ naan̰ tɛɗo se ɓo, Raa tɔɔlsenga *kusin̰sege. Ey num, ute Ko Taar kɛn Raa ɛɗo Musa ki se ɔŋ noogse Ꞌtɛɗki te aak bɛɛ naan Raa ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Num gaŋ debm jaay aal maakin̰ do Isa al‑Masi ki se, kusin̰in̰ paac se, Raa tɔɔlin̰sin̰ga naata. ");
INSERT INTO kyq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bin se, ɔndki kɔndɔ, ɓɛrɛ, taar se ɔn̰te Ꞌbaatin̰ki! Ey num, taar kɛn jee taaɗ taar teeco taar Raa ki raaŋo do dɔkin̰ maakŋ Kitap ki se, sɔm asen kaan dose ki cɛrɛ, kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ꞋƁooyki bɛɛ, naasen kɛn aalki Raa maak ki ey se, nakŋ se lɛ, deelga dose ɔɔ ɔksen taaɗ eyo! Taa naase se utu aki kutn kap! Taa do naase ki se, mꞋutu mꞋtɛɗn nakŋ kɛn deel doa ɔɔ nakŋ se kɛn nam kuuy jaay ɓaaɗo taaɗsen mɛtin̰ kic ɓo, naase lɛ aki Ꞌtook ey tap.» ");
INSERT INTO kyq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kɛn Pɔl ute Barnabas jaay teec teec naatn maakŋ ɓee Yaudge tun lee tusn maak ki se, gɔtn se jeege taaɗɗen ɔɔ: «Ɓii sebitn kuuy se, Ꞌtɛrl Ꞌɓaakiro ajeki taaɗn mɛtn taar se daala.» ");
INSERT INTO kyq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kɛn jeege wɔɔk naŋ se, maakɗe ki se Yaudge dɛna, ute jee kɛn tɛɗga tɛɗ roɗe Yaudge kɛn ɔk taar Raa ɔɔn̰ se ɓaa ute Pɔl ɔɔ Barnabas. Kɛn naaɗe jaay ɓaa ɓaa se, Pɔl ute Barnabas se taaɗ ute naaɗe, dɛjɗe ɔɔ bɛɛ Raa se, jꞋɔkin̰ ɔɔn̰ɔ. ");
INSERT INTO kyq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Anum, *ɓii sebit kɛn kuuy se, jee maakŋ gɛgɛr kɛn Antiɔs kɛn taa naaŋ Pizidi ki se, dɛnin̰ ɓaaɗo tus gɛn booy taar Mɛljege. ");
INSERT INTO kyq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Num kɛn Yaudge jaay aak jeege ɓaaɗo tus dɛn se, naaɗe tɛɗ maak‑kilimi ro Pɔl ute Barnabas ki ɔɔ naaɗe baag naajn̰ Pɔl ɔɔ taaɗ jeege tu ɔɔ: «Taar kɛn Pɔl taaɗ se, taar kɛn mɛt ki eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Gɔtn se Pɔl ute Barnabas se, taaɗ aal doɗe sɛn̰ ɗeekɗen ɔɔ: «Bɛɛki se, taar se jꞋasen taaɗn naase Yaudge tu ɓo jaayo. Aan gɔɔ naase lɛ Ꞌbaateki ɗey se, kɛse naase malin̰ge ɓo Ꞌtɛɗki murs rose ki gɛn kɔŋ *kaajn̰ gɛn daayum eyo. Ɓɔrse num, naaje se, kꞋɓaa taaɗn taar Raa se jeege tun Yaudge eyo. ");
INSERT INTO kyq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kɛse ɓo naabm kɛn Mɛljege ɔljeno ɔɔ taaɗjeno ɔɔ: Maam se mꞋtɛɗi naai Ꞌtɛɗga gɔtn wɔɔr gɛn wɔɔr mɛtjil jeege paac, taa naai aɗen ɓaa taaɗn taar Raa jeege tu bini Ꞌkaan gɔtn duni Ꞌɗaar ro ki ɔɔ aɗen taaɗn ɔɔ: Raa se aɗen kaaja.» ");
INSERT INTO kyq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kɛn jee kɛn Yaudge ey jaay booy taar se, naaɗe maakɗe raapo, *nook Raa ɗeek ɔɔ: «Taar Mɛljege Raa se jiga aak eyo.» Gɔtn se, jee kɛn Raa bɛɛr tɔɔɗɗenga tɔɔɗ gɛn kɔŋ kaajn̰ gɛn daayum se, took aal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gɔtn se, taar Mɛljege Raa se wɔɔk dɔɔɗ taa naaŋ gɔtn ese paac. ");
INSERT INTO kyq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Gaŋ Yaudge se ɔɔs mɛtn magalgen maakŋ gɛgɛr kɛn gɔtn ese ute mɛndgen jeeɗege jee nak dɛnge jaay ɓeer Raa ki se, naaɗe ɔlɗe mɛtɗe taa jꞋdabar Pɔl ute Barnabas ɔɔ naaɗe tuurɗe naatn maakŋ taa naaŋɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kɛn Pɔl ute Barnabas jaay ɓaa ɓaa se, tup kuɗn jɛɗege tu ɔɔ naaɗe iin̰ ɓaa Ikɔniɔm ki. ");
INSERT INTO kyq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Gaŋ jee kɛn aal maakɗe do Isa *al‑Masi kɛn gɔtn ese se, Raa ɗoocɗe maakɗe ute *Nirl Salal tɛɗɗe naaɗe se, maakɗe raap dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kɛn Pɔl ute Barnabas jaay aan maakŋ gɛgɛr kɛn Ikɔniɔm ki se, naaɗe ɓaa ɛnd maakŋ *ɓee kɛn Yaudge lee tusn maak ki aan gɔɔ kɛn naaɗe tɛɗo maakŋ gɛgɛr kɛn Antiɔs ki se. Gɔtn se, naaɗe taaɗɗen taar *Raa bini ɔl naaɗen Yaudge ute kɛngen Yaudge eyo dɛnin̰ took aal maakɗe do Isa *al‑Masi ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Gaŋ Yaudgen baate tookŋ taarɗe se ɔɔs mɛtn jeegen kɛn Yaudge eyo taa je taara ro jeege tun took aal maakɗe do Isa al‑Masi ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ute naan̰ se kic ɓo, Pɔl ute Barnabas tiŋgoga dɛna maakŋ gɛgɛr kɛn ese ɔɔ naaɗe taaɗ taar Mɛljege se jeege tu ɔɔ naaɗe taaɗɗen taa bɛɛ Raa kɛn naan̰ tɛɗɗen se, aal doɗe sɛn̰, ɓeer eyo. Ɔɔ gɔtn se, Raa ɔlɗen naaɗe tɛɗ nakŋ‑kɔɔɓge ute nakgen deel doa taa Ꞌtaaɗn jeege tu ɔɔ taar naaɗe taaɗ se, taar mɛt ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Do taarɗe ki se, jeegen maakŋ gɛgɛr kɛn ese se ɓaa gaaŋ naapa gɔtɔ kaam dio: jeegen mɛtin̰ge ɓaa mɛtn Yaudge ɔɔ kɛngen kuuy se lɛ ɓaa mɛtn jee kaan̰ naabm al‑Masige tu. ");
INSERT INTO kyq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gɔtn se Yaudge ute jeegen kɛn Yaudge eyo ute magalɗege se, dɔɔkga taarɗe gɛn ɓaa koocn̰ *jee kaan̰ naabm Isa al‑Masige taa aɗen tund tɔɔl ute koa. ");
INSERT INTO kyq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kɛn Pɔl ute Barnabas jaay booy taar ese se, bin se, naaɗe aan̰ ɓaa taa naaŋ Likaoni ki. Kɛn naaɗe jaay aan gɔtn naane se, naaɗe ɓaa tiŋg maakŋ gɛgɛr kɛn Listir ute kɛn Derbe ki ɔɔ ute naaŋge tun cɛɛs ki cɛɛs ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kɛn naaɗe jaay aan gɔtn naane se kic ɓo, naaɗe taaɗ Labar Jigan gɛn Isa al‑Masi se jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Maakŋ gɛgɛr kɛn Listir ki se, ɔk gaaba kalaŋ bin se gɔtn tiŋgin̰ ɓo naaŋ ki sum. Ɔɔ gaabm se, gɔtn kꞋjꞋoojin̰ tap ɓo k‑ruŋguyu; ɓii kalaŋ naan̰ lee te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɓii kalaŋ, naan̰ iŋg booy booy taar Raa kɛn Pɔl taaɗ se. Gɔtn se Pɔl ɔndin̰ kaama tak, taa naan̰ aak jeel gaabm se aalga maakin̰ do Isa *al‑Masi ki se, Ꞌkɔŋ lapia. ");
INSERT INTO kyq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Gɔtn se, Pɔl uun mindin̰ raan ɗeekin̰ ɔɔ: «Iin̰ Ꞌɗaara!» Ɔɔ gaabm se naar iin̰ ɗaar kirit ɔɔ baag lea. ");
INSERT INTO kyq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kɛn jee dɛnge jaay aak nakŋ Pɔl tɛɗ se, naaɗe paac baag kul taara gajalaŋ ute taar Likaoni kɛn taar naaŋɗe se, ɔɔ naaɗe taaɗ ɔɔ: «Ɓɛrɛ, raage se dɛlga jikilimge ɔɔ bɔɔy ɓaaɗoga gɔtjege tu!» ");
INSERT INTO kyq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gɔtn se Barnabas se naaɗe daŋin̰ Zeus. Zeus se je ɗeekŋ ɔɔ: gaar gɛn raage. Ɔɔ Pɔl lɛ, naaɗe daŋin̰ Ɛrmɛz. Ɛrmɛz se je ɗeekŋ ɔɔ: debm taaɗin̰ bɛɗin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Raaɗen Zeus se, ɓeen̰ cɛɛ taa ɗoob kɛn jꞋɛnd maakŋ gɛgɛr ki se, ɔɔ debm kɛn lee tɔj sɛrkŋ maakŋ ɓee kɛn se, tɔk ɓaano ute kɔs‑taarge dio ɔɔ tamarɗeno ute pɔɔn̰ kaagge jaay ɓo ɓaanɗeno taa ɓee kɛn ese, taa naan̰ ute jee dɛnge se dɔɔkga taarɗe je tɔjn̰ *sɛrkɛ Barnabas ute Pɔl ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Gaŋ kɛn *jee kaan̰ naabm Isage, Barnabas ute Pɔl, jaay booy taar ese se, naaɗe maakɗe tuju ɔɔ nɛɛpm te kalɗege ɔɔ gɔtn se, naaɗe naar aan̰ ɓaa ɔŋ jee dɛnge se, taaɗɗen makɔn̰ɔ ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ay, naase ara, kɛse naase Ꞌtɛɗki nakŋ‑kɔɔɓm ɗi bini! Ɓɛrɛ, naaje se k‑jikilimge aan gɔɔ naase se sum kici. Naaje kꞋtaaɗsen Labar Jiga se taa naase anki rɛsn ute raagen rɛn̰ rɛn̰ se. Ɓɔrse, Ꞌtɛrlkiro maakse do Raa ki naan̰ kɛn tiŋg zɛɛrɛ se! Naan̰ ɓo debm aalo maakŋ raa ute do naaŋa ɔɔ aalo baar ɔɔ nakgen ɓaa se paac. ");
INSERT INTO kyq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Do dɔkin̰ se, mɛtjil jeegen gay gay kic ɓo, Raa ɔn̰ɗen naaɗe uun ɗoobm kɛn naaɗe maakɗe jen ro ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ute naan̰ se kic ɓo, Raa se daayum tɛɗɗen bɛɛ ɔɔ bɛɛ kɛn naan̰ lee tɛɗɗen se, naan̰ eeɗɗen maane oojɗen nakɗege ɔɔ ɛɗɗen kɔsɔ ute maraadin̰a ɔɔ raapɗen maakɗe sakan̰.» ");
INSERT INTO kyq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ute taar kɛn naaɗe taaɗɗen se kic ɓo, Pɔl ute Barnabas tɛɗɗen bini jaay ɓo ɓaa gaas jee dɛnge gɛn tɔjn̰ sɛrkɛ se. ");
INSERT INTO kyq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kɛn nakgen se jaay deel se, Yaudgen iin̰o Antiɔs ki ɔɔ kɛngen mɛtin̰ge iin̰o Ikɔniɔm ki ɓaaɗo Listir ki ɔɔ ɔɔs mɛtn jee dɛngen gɔtn ese ɔɔ taaɗɗen taar Pɔl ute Barnabas taaɗ se, taar mɛt ki eyo. Gɔtn se, Pɔl naaɗe tundin̰ ute koa ɔɔ tiik teecn̰sin̰ naatn maakŋ gɛgɛr ki se ɔɔ ɓaa undin̰ naata, naaɗe saap ɔɔ kaaɗ naane, naan̰ ooyga. ");
INSERT INTO kyq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Num kɛn gɛnaagen ɗoobm Isa al‑Masi ki jaay ɓaaɗo tus gurugin̰ se, gɔtn se Pɔl iin̰ ɗaara ɔɔ ɔk tɛrl ɓaa maakŋ gɛgɛr kɛn Listir ki. Mɛtbeen̰ki se, naan̰ ute Barnabas iin̰ gɔtn ese ɔɔ ɓaa Derbe ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kɛn naaɗe jaay aan maakŋ gɛgɛr kɛn Derbe ki se, Pɔl ute Barnabas taaɗ Labar Jigan gɛn Isa *al‑Masi se jeege tu. Gɔtn se, jeege dɛna took aal maakɗe do Isa al‑Masi ki. Naaɗe iin̰ ɔn̰ gɔtn ese, ɔk tɛrl ɓaa maakŋ gɛgɛr kɛn Listir ki ɔɔ Listir ki se naaɗe iin̰ ɓaa maakŋ gɛgɛr kɛn Ikɔniɔm ki ɔɔ Ikɔniɔm ki se, naaɗe iin̰ ɓaa maakŋ gɛgɛr kɛn Antiɔs ki kɛn taa naaŋ Pizidi ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Maakŋ gɛgɛrge tun, naaɗe aanga tak ɓo naaɗe ɛɗɗen kaay kaama jeege tun aalga kaal maakɗe do Isa al‑Masi ki ɔɔ taaɗɗen ɔɔ ɗoobm Isa al‑Masi ki se jꞋɔkin̰ tɔɔgɔ ɔɔ tɛr taaɗɗen ɔɔ: «Naajege se, jꞋutu jꞋaki dabar dɛn jaay ɓo jꞋaki kɛnd *maakŋ Gaar Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Gɔtn kɛn naaɗe aanga jaay ɔŋga *egliz se, naaɗe bɛɛr tɔndɗen jeegen Ꞌtɛɗn naanɗege. Gɔtn se, naaɗe uun *siam ɔɔ eem Raa jaay ɓo, jee se naaɗe ɔn̰ɗen kaam ji Mɛljege Isa al‑Masi kɛn naaɗe aal maakɗe don̰ ki se. ");
INSERT INTO kyq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Gɔtn se, Pɔl ute Barnabas ɓaa ɓaa se, naaɗe aal teeco taa naaŋ Pizidi jaay ɓaaɗo taa naaŋ Pampili ki. ");
INSERT INTO kyq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kɛn naaɗe jaay aan maakŋ gɛgɛr kɛn Pɛrg ki se, naaɗe taaɗ taar Raa jeege tu jaay iin̰ ɔn̰ gɔtn ese ɔɔ ɓaa maakŋ gɛgɛr kɛn gɔtn kꞋlee kꞋɗaar markabge ɔɔ gɛgɛr se ron̰ Atalia. ");
INSERT INTO kyq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Naaɗe iin̰ maakŋ gɛgɛr kɛn ese, ook maakŋ markab ki uun ɗoobm gɛn tɛrl maakŋ gɛgɛr kɛn Antiɔs kɛn taa naaŋ Siri ki. Gɔtn se ɓo, mɛtn‑jiki naaɗe iin̰o ro ki ɔɔ maakŋ gɛgɛr kɛn ese ɓo, jee Raage ɔn̰ɗeno kaam ji Raa taa Ꞌtɛɗn naabm kɛn ɓɔrse naaɗe tɛɗ aasin̰oga se. ");
INSERT INTO kyq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kɛn naaɗe jaay aan Antiɔs kɛn taa naaŋ Siri ki se, Pɔl ute Barnabas daŋ tus jee egliz ki. Gɔtn se, naaɗe taaɗɗen mɛtn taar nakgen kɛn Raa ɔlɗen naaɗe tɛɗo se ɔɔ tɛr taaɗɗeno ɔɔ: «Ɓɔrse se, Raa ɔɔɗga ɗoobo jeege tun Yaudge eyo taa kaal maakɗe do Isa ki kici.» ");
INSERT INTO kyq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Gɔtn se, naaɗe tiŋgoga dɛna ute gɛnaagen aalga kaal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Gɔtn se jee mɛtin̰ge iin̰o taa naaŋ Jude ki ɔɔ ɓaaɗo maakŋ gɛgɛr kɛn Antiɔs ki. Naaɗe baag dooy gɛnaagen ɗoobm Isa *al‑Masi ki ɔɔ: «Kɛn naase jaay jꞋɔjsen te pɔndɔ aan gɔɔ kɛn *Ko Taar kɛn Raa ɛɗo Musa ki taaɗn ey se, naase aki Ꞌkɔŋ kaaj eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Gɔtn se Pɔl ute Barnabas took eyo do taar naaɗe ki se ɔɔ do taar kɛn se, naaɗe naajga dɛna ute jee se. Taa naan̰ se ɓo, jee gɔtn ese uun doa gɛn kɔl Barnabas ute Pɔl ɔɔ gɛnaage kandum kɛn ɗoobm Isa al‑Masi ki, taa ɓaa kɔŋ *jee kaan̰ naabm Isa al‑Masige ute jee naan jee *eglizge tun Jeruzalɛm ki gɛn ɓaa kaakŋ mɛtn taar se. ");
INSERT INTO kyq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Gɔtn se, eglizn Antiɔs ki ɛɗɗen ne ɗim kɛn naaɗe an ɓaa mɛrtɛ jaay ɓo ɔlɗen ɗoob ki. Kɛn naaɗe ɓaa ɓaa se, aal teec ute taa naaŋ Pɛnisi ɔɔ ute taa naaŋ *Samari. Gɔtn naaɗe aanga se, taaɗ gɛnaage tun ɗoobm Isa al‑Masi ki mɛtn taar jee kɛn Yaudge ey jaay tɛrlga maakɗe do Isa ki se. Kɛn gɛnaagen se jaay booy taar ese se, naaɗe paac maakɗe raap dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kɛn naaɗe jaay aan Jeruzalɛm ki se, jee egliz ki, jee kaan̰ naabm Isa al‑Masige ute jee naan jee eglizge tu se, dɔɔɗ ɔkɗe mɛrtɛ. Gɔtn se naaɗe taaɗɗen mɛtn taar nakgen kɛn *Raa ɔlɗeno naaɗe tɛɗo se. ");
INSERT INTO kyq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Num *Parizigen took aalga kaal maakɗe do Isa al‑Masi ki se, gɔtn se naaɗe iin̰ taaɗ jeege tu ɔɔ: «Bɛɛki num, jee kɛn Yaudge ey jaay took aalga maakɗe do Isa al‑Masi ki se, jꞋaɗen tɔjn̰ pɔndɔ ɔɔ Ko Taar kɛn Raa ɛɗo Musa ki se kꞋdooyɗe, naaɗe Ꞌkiŋg do ki.» ");
INSERT INTO kyq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tɛr gɔtn se, jee kaan̰ naabm Isa al‑Masige ute jee naan jee eglizge tu se tus gɛn kaakŋ mɛtn taar se. ");
INSERT INTO kyq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kɛn naaɗe naaj te naapa makɔn̰ɔ bini jaay ɓo, Piɛr iin̰ ɗaara ɔɔ taaɗɗen ɔɔ: «Gɛnaamge, naase Ꞌjeelki maam Raa bɛɛr ɔɔɗum daanse ki se do dɔkin̰a, taa mꞋtaaɗn Labar Jiga gɛn Isa al‑Masi se jeege tun Yaudge eyo, taa kɛn naaɗe jaay booyga num, naaɗe tookŋ kaal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Taa Raa se naan̰ jeel naŋ maak‑saapm jikilimge ɔɔ jee kɛn Yaudge ey se kic ɓo, naan̰ took ɔkɗega ɔɔ ɛɗɗenga *Nirl Salal aan gɔɔ kɛn naan̰ ɛɗjekiro naajege tu se kici. ");
INSERT INTO kyq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Raa se, aakjeki naanin̰ ki se naaje jꞋutu naaɗe se jꞋaaski kaasa. Taa naan̰ se ɓo, naaɗe kic aal maakɗe do Isa ki sum ɓo, Raa *tug ɗaapɗenga maakɗe. ");
INSERT INTO kyq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bin num, gɛn ɗi jaay naase Ꞌje aki tujn̰ maakŋ Raa se ɔɔ naase je aki kɔnd daam deer do jeege tun Yaudge eyo jaay took aal maakɗe do Isa al‑Masi ki se ey num daam se bubjege ute naajege se jꞋɔŋ jꞋaasin̰kiro te gɛn kuunin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bin num, kɛse mɛt ki eyo kɛn jꞋaki tɛɗn naan̰ se! KꞋjeelki naajege kic jꞋaalki maakjege do bɛɛ gɛn Mɛljege Isa ki aan gɔɔ naaɗen kɛn Yaudge ey se kici, jaay ɓo naaje jꞋɔŋki kaaja aan gɔɔ kɛn naaɗe ɔŋ se kici.» ");
INSERT INTO kyq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Gɔtn se jee tus ute dɛnɗe se do ɗɛk ɔɔ naaɗe ɔn̰ gɔtɔ Pɔl ute Barnabas ki taaɗɗen mɛtn taar nakŋ‑kɔɔɓge ute nakgen deel doa kɛn Raa ɔlɗeno naaɗe tɛɗo daan jeege tun Yaudge ey se. ");
INSERT INTO kyq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kɛn naaɗe jaay taaɗ naŋ taarɗe se, gɔtn se Jak uun taara ɔɔ ɗeekɗen ɔɔ: «Gɛnaamge, uɗumki bia! ");
INSERT INTO kyq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon taaɗjekiro ɔɔ mɛtn‑jiki tap ɓo Raa se bɛɛr tɔɔɗoga jeege daan jeege tun Yaudge eyo taa tɛɗn jee naan̰ge. ");
INSERT INTO kyq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nakgen deel ese se, aanga ɗoobin̰ ki aan gɔɔ taargen jee taaɗ taar teeco taar Raa ki raaŋɗeno do dɔkin̰ kɛn ɔɔ: ");
INSERT INTO kyq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mɛljege Raa ɗeek ɔɔ: Kɛn nakgen se jaay deelga num, maam mꞋutu mꞋaɗe ɓaao ɔɔ kaagŋ ɓee Gaar *Daudn kɛn tɛrɛc se, maam mꞋutu mꞋan̰ ɗaar gɔtin̰ ki ɔɔ gɔtn kɛn tujga aan gɔɔ ɗi kic ɓo, maam mꞋan̰ ɗaapin̰ Ꞌɗaar tɔɔgŋ gaŋ. ");
INSERT INTO kyq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Bin ɓo jeegen ɔɔp se utu am je maam Mɛlɗe. Ɗeere, jeegen kɛn maam mꞋutu mꞋaɗeno daŋ se utu Ꞌtɛɗn jee maamge. Kɛse ɓo nakŋ kɛn maakum jen ro ki, ");
INSERT INTO kyq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ɔɔ taar se ɓo kɛn maam mꞋtaaɗo mɛtin̰ jeege tun do dɔkin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tɛr Jak taaɗɗeno ɔɔ: «ꞋƁooyki! Gɛn maam ki num, jeegen Yaudge eyo jaay tɛrlga maakɗe do Raa ki se, jꞋɔn̰te kɔndɗeki nakŋ ɔɔn̰ doɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Num gaŋ ɓɔrse, kꞋraaŋɗeki maktub jꞋɔɔki: jꞋɔn̰te kɔsn daa maragge, jꞋɔn̰te kɛɛsn naapge rɛn̰ rɛn̰, jꞋɔn̰te kɔsn daagen moosɗe ɔɔy te naaŋ ki eyo ɔɔ jꞋɔn̰te kɔsn mooso kici. ");
INSERT INTO kyq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Taa do dɔkin̰ se, maakŋ gɛgɛr ki tak ɓo aanga *ɓii sebit ki ɓo, jeege lee taaɗ tɔɔk mɛtn Ko Taar kɛn Raa ɛɗo Musa ki se ɔɔ dooyin̰ maakŋ *ɓeege tun Yaudge lee tusn maak ki.» ");
INSERT INTO kyq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Gɔtn se jee egliz ki ute jee naanɗe ki ɔɔ jee kaan̰ naabm Isa al‑Masige dɔɔk taarɗe kalaŋ ɔɔ bɛɛr tɔɔɗ jeege daanɗe ki gɛn ɓaa ute Pɔl ɔɔ Barnabas Antiɔsn kɛn taa naaŋ Siri ki. Jee kɛn naaɗe bɛɛr tɔɔɗɗe se debm kalaŋ ron̰ Judas kɛn kꞋdaŋin̰ Barsabas se kici, ɔɔ kɛn kuuy se kꞋdaŋin̰ Silas. Naaɗe se gɛnaage paac aalɗe maak ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naaɗe raaŋ ɛɗɗen maktub jiɗe ki ɔɔ maakŋ maktub kɛn ese naaɗe ɗeek ɔɔ: Kɛse naaje kꞋjee kaan̰ naabm Isa al‑Masige, ute naajen naan jee eglizge tu, ute gɛnaagen gɔtn ara paac kꞋtɛɗsen tɔɔsɛ dɛna naase gɛnaajegen Yaudge eyo, kɛn took aalkiga maakse do Isa al‑Masi ki, naasen kɛn iŋgki taa naaŋ Siri ki ɔɔ maakŋ gɛgɛr kɛn Antiɔs ki ute kɛngen taa naaŋ Silisi ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Naaje kꞋbooyga kɛn jee mɛtin̰ iin̰ gɔtje ki ara jaay ɓaa gɔtse ki se, naaɗe utu taar naaɗen ɓaa taaɗsen se tujsega maakse ɔɔ teecsenga nirlse. Ɓɛrɛ, jee se naaɗe ɓaa gɛn doɗe, ey num naaje ɓo kꞋjꞋɔlɗen eyo. ");
INSERT INTO kyq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Taa naan̰ se, taar se naaje jꞋaakin̰ taa naapm jaay kꞋbɛɛr kꞋtɔɔɗ jeege maakje ki taa ɓaa ute gɛnaa kɔɔn̰ maakjege Pɔl ute Barnabas se gɔtse ki. ");
INSERT INTO kyq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Taa Pɔl ute Barnabas se, ɛɗga kɛɗ roɗe *sɛrkɛ taa Mɛljege Isa al‑Masi. ");
INSERT INTO kyq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bin num, naaje jꞋɔlsen Judas ute Silas se, taa naaɗe asen ɓaa taaɗn ute taarɗe mala taar kɛn naaje kꞋraaŋsen maakŋ maktub kɛn ese. ");
INSERT INTO kyq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nirl Salal ɔɔ naaje mala jꞋuun doa kꞋje nakŋ kɛn kꞋraaŋsen jꞋɔɔ aki tɛɗ se kꞋje jꞋasen ziiɗn ɗim kuuy do ki ey sum, ");
INSERT INTO kyq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kɛn ɔɔ: ɔn̰te kɔski daa maragge, ɔn̰te kɔski mooso, ɔn̰te kɔski daagen moosɗe ɔɔy te naaŋ ki eyo ɔɔ ɔn̰te kɛɛski naapge rɛn̰ rɛn̰. Kɛn nakgen se jaay naase Ꞌtɛɗin̰kiga num, kɛse naase Ꞌtɛɗkiga nakŋ jiga aak eyo. Naaje gɛnaagen gɔtn ara kꞋtɛɗsen tɔɔsɛ dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kɛn naaɗe jaay raaŋ ɛɗɗen maktub jiɗe ki se, gɔtn se naaɗe ɔlɗe ɔɔ naaɗe iin̰ ɓaa maakŋ gɛgɛr kɛn Antiɔs ki. Kɛn naaɗe jaay aan se, naaɗe daŋ tus gɛnaagen ɗoobm al‑Masi ki ɔɔ ɛɗɗen maktubm ese. ");
INSERT INTO kyq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kɛn jee ɗoobm al‑Masi kɛn gɔtn ese jaay booy taar kɛn kꞋdooyɗesin̰ maakŋ maktub kɛn se, maakɗe ɓaa raap aak eyo ɔɔ taargen se ɛɗɗen kaay kaama. ");
INSERT INTO kyq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ute Silas se, naaɗe jee taaɗ taar teeco taar Raa ki. Taa naan̰ se ɓo, naaɗe dɛjɗenga dɛna ɛɗɗen kaay kaama ɔɔ do kaal maakɗe ki se, jꞋɔk maakɗe tɔɔgɔ. ");
INSERT INTO kyq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Naaɗe ute gɛnaagen Antiɔs ki se, tiŋgoga dɛna gɔtn ese jaay ɓo, gɛnaagen ɗoobm Isa al‑Masi kɛn maakŋ gɛgɛr kɛn ese ɔlɗe ɔɔ kꞋɓaa lapia, ɔɔ naaɗe ɔk tɛrl ɓaa gɔtn jeege tun ɔlɗeno. ");
INSERT INTO kyq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Naɓo, Silas se je kiŋg gɔtn ara ɓii kandum. ");
INSERT INTO kyq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Anum Pɔl ute Barnabas se ɔɔp iŋg Antiɔs ki. Gɔtn ese, naaɗe ute jeegen kuuy se kic dɛna lee dooyɗen ute taar Mɛljege ɔɔ taaɗɗen Labar Jiga. ");
INSERT INTO kyq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kɛn naaɗe jaay tiŋg aas gɔtn ese se, Pɔl ɗeek Barnabas ki ɔɔ: «JꞋɔk kꞋtɛrl kꞋɓaa kaakŋ gɛnaagen ɗoobm *al‑Masi kɛn iŋg maakŋ gɛgɛrge tun paacn̰ gɔtn naaje kꞋlee kꞋtaaɗo taar Mɛljege ro ki se. KꞋɓaa kꞋjꞋaakɗen tu, naaɗe tap ɓo iŋg ɔɔ ɗi.» ");
INSERT INTO kyq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Gɔtn se, gɛn Barnabas ki num naan̰ je Jan kɛn kꞋdaŋin̰ Mark se kic ɓo Ꞌɓaa ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Num gaŋ Pɔl took eyo, taa Jan‑Mark se rɛs ɔn̰ɗenga kɔn̰ɔ taa naaŋ Pampili ki ɔɔ naan̰ ɔŋ aay ute kaamin̰ gɛn tɛɗn naaba ute naaɗe eyo. ");
INSERT INTO kyq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gɔtn se, naaɗe naajga taara dɛna, naɓo taarɗe ɓaa ɔk te mɛtn naap eyo. Bin se, Barnabas ute Jan‑Mark lɛ ook maakŋ markab ki gɛn ɓaa taa naaŋ Sipir ki; ");
INSERT INTO kyq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","num Pɔl se lɛ, bɛɛr uun Silas gɛn ɓaa ute naan̰a ɔɔ gɛnaagen ɗoobm al‑Masi kɛn gɔtn ese tɔndɗe mɛtn Raa ɔɔ daayum Mɛljege n̰Ꞌtɛɗɗen bɛɛn̰a. ");
INSERT INTO kyq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔl iin̰ gɔtn ese ɔɔ ɓaa lee taa naaŋ Siri ute gɛn Silisi ki ɔɔ gɔtn naan̰ aanga ro ki se, naan̰ ɛɗ kaay kaama *eglizge tu. ");
INSERT INTO kyq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tɛr Pɔl ute Silas jaay aan maakŋ gɛgɛr kɛn Derbe ute gɛn Listir ki se; gɔtn ese naan̰ ɔŋ gaaba kalaŋ debm aalga kaal maakin̰ do Isa ki, ron̰ Timote. Naan̰ se kon̰ mɛnd Yaud kɛn aalga kaal maakin̰ do Isa ki kici; gaŋ bubin̰ se, kɔɗ Grɛk. ");
INSERT INTO kyq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timote se, gɛnaagen ɗoobm al‑Masi kɛn maakŋ gɛgɛrge tun Listir ute kɛn Ikɔniɔm ki, paac se tɔɔmin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gɔtn se Pɔl je ɔɔ kꞋɓaa tɛlɛ, naɓo taa Yaudgen iŋg maakŋ gɛgɛrge tun ese se, naan̰ ɔjin̰ pɔndɔ, taa jeegen paacn̰ gɔtn ese se jeelin̰ naan̰ se bubin̰ kɔɗ Grɛk. ");
INSERT INTO kyq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kɛn naan̰ jaay ɔj pɔndɔ Timote ki aas se, naaɗe iin̰ gɔtn ese ɔɔ ɓaa lee maakŋ gɛgɛrge tu ɔɔ naaɗe taaɗ gɛnaage tu nakgen kɛn *jee kaan̰ naabm Isage ute jee naan jee *eglizge tu taaɗo taarin̰ Jeruzalɛm ki se ɔɔ naaɗe taaɗɗen ɔɔ: «JꞋiŋg do taar kɛn se.» ");
INSERT INTO kyq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ute taargen se, jee eglizgen gɔtn ese se tɛɗ jee al‑Masigen mɛc, ɔɔ ɓii‑raa naaɗe ziiɗ ɓaa ute naanɗe. ");
INSERT INTO kyq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔl ute Silas se je ɓaa taaɗn taar *Raa taa naaŋ Azi kɛn kaam kalaŋ; naɓo *Nirl Salal taaɗɗen maakɗe ki ɔɔ jꞋɔn̰te ɓaa. Num gɔtn se, naaɗe aal teec taa naaŋ Prigi ute gɛn Galati ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kɛn naaɗe jaay aan cɛɛ taa naaŋ Misi ki se, naaɗe je ɓaa taa naaŋ Bitini ki; naɓo gɔtn ese kic Nirl gɛn Isa gaasɗe. ");
INSERT INTO kyq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Taa naan̰ se ɓo, naaɗe aal teec taa naaŋ Misi ki ɔɔ bɔɔy ɓaa maakŋ gɛgɛr kɛn Troas ki gɔt kɛn kꞋlee kꞋɗaar markabge se. ");
INSERT INTO kyq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Maakŋ Troas ki jaay Pɔl tooɗ tooɗ nɔɔr se, naan̰ nia ɔɔ maakŋ nin̰ ki se, naan̰ aak aan gɔɔ kɔɗ Masedoan kalaŋ ɗaar ɗaar naanin̰ ki ɔɔ eemin̰ nɔɔ mɛtin̰ ki ɔɔ: «Iin̰ Ꞌɓaaɗo Masedoan ki ara taa ajen naaka.» ");
INSERT INTO kyq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kɛn Pɔl jaay taaɗɗen mɛtn taar nin̰ga sum se, gɔtn se sum ɓo naaje kꞋnaar kꞋje ɗoobm jꞋan ɓaa Masedoan ki, taa ute mɛtn taar nin̰ se, naaje kꞋjeelga maakje ki kɛse Raa ɓo daŋje gɛn ɓaa taaɗn Labar Jigan gɛn Isa *al‑Masi se, jeege tun gɔtn naane. ");
INSERT INTO kyq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Naaje jꞋiin̰ maakŋ gɛgɛr kɛn Troas ki se, gɔtn se naaje kꞋjꞋook maakŋ markab ki ɔɔ kꞋjꞋɔmb kꞋgaaŋ baar kꞋɓaa taa naaŋ Samotras kɛn maane gurug aalin̰ se. Tɛr mɛtbeen̰ki se, naaje kꞋjꞋiin̰ kꞋɓaa maakŋ gɛgɛr kɛn Neapoli ki gɔtn kɛn kꞋlee kꞋɗaar markabge se kici. ");
INSERT INTO kyq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Gɔtn se, naaje kꞋjꞋiin̰ kꞋɓaa maakŋ gɛgɛr kɛn Pilip ki ɔɔ maakŋ taa naaŋ Masedoan ki se, Pilip se naan̰ gɛgɛr magala ɔɔ ɔk *Rɔmɛge dɛna. Gɔtn ese se, naaje kꞋtiŋgga ɓii kandum. ");
INSERT INTO kyq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kɛn *ɓii sebit jaay aan se, naaje kꞋjꞋiin̰ kꞋteec maakŋ gɛgɛr kɛn se ɔɔ kꞋɓaa taa oolo ki kꞋsaap jꞋɔɔ kaaɗ naane jꞋkɔŋ gɔtn jeege lee eem Raa. Num gaŋ jꞋaan se jꞋɔŋ mɛndge kandum sum ɓo tusga, kꞋjꞋiŋg cɛɛɗe ki ɔɔ kꞋtaaɗɗen taara. ");
INSERT INTO kyq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Maakɗe ki se, mɛnda kalaŋ ron̰a Lidi ɔɔ naan̰ iin̰o maakŋ gɛgɛr kɛn Tiatir. Mɛnd se, naan̰ ɓeer Raa ki ɔɔ ɔk kalge gɛn zoa ɔɔ kalin̰ge se kalgen te roɗege ɔɔ aac kaace. Kɛn Pɔl jaay taaɗ taaɗ taar Raa se, naan̰ uɗ bi do ki taa Mɛljege tɛɗin̰ maakin̰ ki gɛn booy kɔkŋ taar Pɔl se ɔɔ naan̰ aal maakin̰ don̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Gɔtn se, naan̰ ute jeegen maakŋ ɓeen̰ ki se *kꞋbatizɗe. Kɛn kꞋbatizɗe aas se, naan̰ daŋje ɔɔ kꞋɓaa ɓeen̰ ki ɔɔ ɗeekjen ɔɔ: «Kɛn naase Ꞌjeelumki maam se jaay mꞋaalga maakum do Mɛljege tu ɗeer ɗeer num, Ꞌɓaakiro aki kiŋg ɓeem ki.» Gɔtn se, naan̰ ɗoje bini ɔlje naaje kꞋtook kꞋɓaa ɓeen̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gaŋ ɓii kalaŋ naaje kꞋɓaa ɓaa gɔt kɛn jeege lee tusn gɛn keem Raa se, goon mɛnda kalaŋ bin se ɓaaɗo ɔŋje ɔɔ naan̰ mɛnd dukaaka ɔɔ ute dukaakin̰ se iin̰ga num taaɗ nakgen ute aki kaan naan ki. Ute mɛnd se, mɛlin̰ge ɔŋ gurs ro ki dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naan̰ lee ɔk mɛtje naaje jꞋutu Pɔl ɔɔ tɔɔy mɛtje ki makɔn̰ɔ ɔɔ dɔɔk taara ɔn̰ eyo ɗeek ɔɔ: «Jee ese se, naaɗe jee tɛɗn naabm Raagen Taaro! Naaɗe ɓaaɗo se taa asen taaɗn ɗoobm kaaja!» ");
INSERT INTO kyq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mɛnd se ɔk mɛtje ɓii kando kando bini ɔl ɓii kalaŋ Pɔl ɔɔr se, tɛrl aakin̰a ɔɔ ɗeek sitan kɛn ron̰ ki se ɔɔ: «Ute ro Isa *al‑Masi se mꞋɔɔ: Ꞌteec naatn ro mɛnd kɛn se!» Gɔtn se sum ɓo, sitan se naar teec naatn ron̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kɛn mɛlin̰ge jaay aakin̰ naan̰ dukaakin̰ lɛ gɔtɔga ɔɔ ɗoobm naaɗe an kɔŋ gurs kic ɓo gɔtɔga se, naaɗe tɔk Pɔl ute Silas ɔɔ ɓaanɗen naan magalge tun gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tɛr naaɗe ɓaanɗen naan magalge tun *Rɔmɛge tɔndɗe se ɔɔ taaɗɗen ɔɔ: «Jee se lɛ, Yaudge ɔɔ ɓaaɗo se gɛn tujn̰ naaŋjege! ");
INSERT INTO kyq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Naaɗe lee dooy jeege ute ɗoobm kiŋg naaŋɗe kɛn naaje Rɔmɛge se ɔljeki ro ki eyo. Kɛse naaje se jꞋan̰ kɔŋ tɛɗ eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gɔtn se ɔl jee dɛnge se iin̰ ro Pɔl ute Silas ki. Ɔɔ magalgen Rɔmɛge tɔndɗe se iin̰ tɔɔɗn ute kalɗege taa tɔɔgɔ ɔɔ ɔl kꞋjꞋɔndɗe te mɛɛjɛ. ");
INSERT INTO kyq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kɛn naaɗe jaay tɔnd dɛrɛŋɗe aas se, naaɗe ɓaa ɔmbɗen maakŋ daŋgay ki ɔɔ taaɗ magal jee daŋgayge tu se ɔɔ jee se kꞋbɔɔbɗe jiga. ");
INSERT INTO kyq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kɛn magal jee daŋgayge jaay booy taar naaɗe taaɗin̰ se, naan̰ tɔk ɔmbɗen maakŋ daŋgay kɛn maak ki ɔɔ tɔndɗen poolo jɛɗege tu. ");
INSERT INTO kyq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kɛn aan gɔɔr ute daan ɓea se, Pɔl ute Silas se eem keem Raa ɔɔ tɔɔmin̰ tɔɔm ute kaa, kaaɗ kɛn se jee daŋgaygen kuuy se, iŋg booy kaaɗegen naaɗe iŋg aar kaar se. ");
INSERT INTO kyq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Gaŋ gɔtn ese sum ɓo, naaŋa naar te makɔn̰ɔ ɔɔ ɔl ɓee kɛn naaɗe iŋg maak ki se kic ɓo ute magalin̰ te rig rig. Gɔtn se kaam taargen gɛn ɓee se tɔɔɗ kalɗe ki, naan̰ kɛn se zin̰zir kꞋdɔɔkŋ jee daŋgayge se kic ɓo tɔɔɗ si kalɗe ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kɛn magal jee daŋgayge jaay dɔrl iin̰ maakŋ bin̰ ki se, naan̰ aak kaam taar jee daŋgayge se paac tooɗga waŋ waŋ. Gɔtn se naan̰ saap ɔɔ kaaɗ naane jee daŋgayge se aan̰ga. Taa naan̰ se ɓo, naan̰ ɔɔɗ gɔrɗ‑jɛrlin̰a je tɔɔl ron̰a. ");
INSERT INTO kyq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Gaŋ Pɔl ɔɔɗ ɔɔy makɔn̰ ɔɔ: «Ay ɔn̰ɔ, ɔn̰te tɔɔl roi, ɓɛrɛ naaje jꞋutu paac!» ");
INSERT INTO kyq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Gɔtn se magal jee daŋgayge se ɓeere ɔkin̰a ɔɔ ron̰ ook marga, taaɗ ɔɔ jꞋɔɔcin̰o pooɗo taa an kaakŋ gɔtɔ. Kɛn kꞋɓaano ute pooɗo sum se, naan̰ naar ɛnd ɓaa maakŋ daŋgay ki ɔɔ ɓaa ooc mɛtn jɛ Pɔl ute gɛn Silas ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Gɔtn se naan̰ ɔɔɗ teecɗeno naatn ɔɔ tɔnd mɛtɗe ɔɔ: «Nakage, maam tap ɓo mꞋtɛɗn rom mꞋɔɔ ɗi jaay mꞋkɔŋ kaaja se?» ");
INSERT INTO kyq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Naaɗe tɛrlin̰ ɔɔ: «Naai aal maaki do Mɛljege Isa ki ɔɔ ute naan̰ se, naai ute jeeigen maakŋ ɓei ki paac se, aki kɔŋ kaaja.» ");
INSERT INTO kyq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Gɔtn se naan̰ ute jee maakŋ ɓeen̰ ki se, naaɗe taaɗɗen taar Mɛljege Isa. ");
INSERT INTO kyq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Maakŋ nɔɔr kɛn ese sum ɓo, magal jee daŋgayge se ɓaanɗen gɔtn ɔk maane. Gɔtn ese naan̰ tug ɗaapɗen taan‑duɗege. Ɔɔ naan̰ kɛn ese sum ɓo, naan̰ ute jee maakŋ ɓeen̰ ki se, Pɔl ute Silas *batizɗe. ");
INSERT INTO kyq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gɔtn se Pɔl ute Silas se naan̰ daŋ ɓaanɗen ɓeen̰ ki ɔɔ ɛɗɗen kɔsɔ. Gaabm se, ute jeen̰gen maakŋ ɓeen̰ ki se, maakɗe raapo taa naaɗe aalga maakɗe do Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kɛn gɔtɔ jaay iip se, magalgen *Rɔmɛge tɔndɗe se, ɔlo asgarge ɓaa taaɗ magal jee daŋgayge tu ɔɔ: «Jee se, Ꞌtɔɔɗ tɔlɗe.» ");
INSERT INTO kyq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Magal jee daŋgayge ɓaaɗo taaɗ Pɔl ki ɔɔ: «Magalgen Rɔmɛge tɔndɗe se, ɔlo asgarge ɔɔ ɓaaɗo taaɗum ɔɔ kꞋtɔɔɗ kꞋtɔlse. Bin num Ꞌteeckiro naatn maakŋ daŋgay ki ɔɔ Ꞌɓaaki te lapia.» ");
INSERT INTO kyq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Gaŋ Pɔl ɗeek asgarge tu se ɔɔ: «Naaɗe aakjen te mɛtn taarje ey sum ɓo ɔl kꞋtɔndje naan jeege tu, ɔɔ ɓaa ɔlje daŋgay ki, ey num ɓɛrɛ, naaje kic kꞋRɔmɛge. Num gaŋ ɓɔrse num naaɗe je ajen tɔɔɗn tɔl nam Ꞌjeel gɔtje ey se mɛt ki eyo. Bin se, ɔn̰ɗe naaɗe malin̰ge ɓo aɗe ɓaa utu ajen tɔɔɗn naatn maakŋ daŋgay ki se.» ");
INSERT INTO kyq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Asgargen jꞋɔlɗeno jaay ɔk tɛrl ɓaa se ɓaa taaɗ taar se magalge tun Rɔmɛge tɔndɗe se. Kɛn magalgen se jaay booy ɔɔ Pɔl ute Silas kic ɓo Rɔmɛge se, gɔtn se ɓeere ɓaa ɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Naaɗe ɓaaɗo ɔŋɗe ɔɔ tɛɗɗen kalɗɛ jaay tɔɔɗ tɔlɗe ɔɔ taaɗɗen ɔɔ kꞋjꞋiin̰ kꞋjꞋɔn̰ɗe maakŋ gɛgɛrɗe se. ");
INSERT INTO kyq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kɛn Pɔl ute Silas jaay teeco maakŋ daŋgay ki se, naaɗe ɓaa gɔtn Lidi ki. Kɛn naaɗe aan se, ɔŋ gɛnaagen ɗoobm *al‑Masi ki. Gɔtn se, naaɗe ɛɗɗen kaay kaama, jaay ɓo iin̰ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kɛn Pɔl ute Silas jaay iin̰ ɔn̰o gɛgɛr Pilip se, naaɗe aal teeco maakŋ gɛgɛr kɛn Ampipolis ki ute kɛn Apoloni ki. Ɔɔ naaɗe ɓaaɗo maakŋ gɛgɛr kɛn Tɛsalonik ki. Gɔtn se, Yaudge ɔk ɓee kɛn naaɗe lee tusn maak ki. ");
INSERT INTO kyq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Aan gɔɔ nakŋ se, naan̰ deelga deel ro ki se, Pɔl ɓaa ɔŋ Yaudge ɔɔ daan suukge tun mɔtɔ se, aanga *ɓii sebit ki tak ɓo, naaɗe lee naaj ute naaɗe do taarge tun maakŋ Kitap ki. ");
INSERT INTO kyq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Naan̰ taaɗ tɔɔkɗen mɛtin̰a ɔɔ taaɗɗen mɛtn taar maakŋ Kitap kɛn taaɗ ɔɔ: «*Al‑Masi se ɓaaɗoga num utu dabara utu kooyo jaay naan̰ aɗe dur daan yoge tu. Al‑Masi kɛn naase iŋg aakki kaamin̰ se, naan̰ ɓo Isan kɛn maam mꞋtaaɗsen taarin̰ se.» ");
INSERT INTO kyq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Gɔtn se Yaudgen mɛtin̰ge se, taar se ɓaa ɛnd maakɗe ki ɔɔ took ɓaa tum ute Pɔl ɔɔ Silas. Naan̰ kɛn se Grɛkgen ɓeer *Raa ki se kic ɓo dɛna ute mɛndge dɛna kɛn gaabɗege jee magalge se kic, took ɓaa ute naaɗe. ");
INSERT INTO kyq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gaŋ Yaudgen baate kaal maakɗe do Isa ki se, tɛɗ maak‑kilimi ro Pɔl ute Silas ki ɔɔ ɔŋ jee mursgen lee daan ɗoobge tu se rɛjɗeno ute gurs. Naaɗe ɓaaɗo ɔɔs mɛtn jee dɛnge taa tujn̰ gɔtɔ. Gɔtn se, naaɗe iin̰ ɓaa tɛrɛc ɓee Jason gɛn je Pɔl ute Silas. Kɛn naaɗe jaay ɔŋɗenga num, anɗen tɔkŋ ɓaa naan jee dɛnge tun tusga se. ");
INSERT INTO kyq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kɛn naaɗe ɓaa jaay ɔŋɗen te ey se, naaɗe ɔk ɓaano ute Jason ute gɛnaage kandum kɛn ɗoobm al‑Masi ki naan tɔɔgge tun gɔtn ese. Gɔtn se, naaɗe tɔɔɗ tɔɔy ɔɔ: «Jee tuj *dunia te magalin̰ se, ɓɛrɛ, ɓɔrse naaɗe aanga ara! ");
INSERT INTO kyq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ɔɔ Jason se ɓo, debm kɛn ɔkɗen ɓeen̰ ki ɔɔ jee se lɛ, Sezar Gaar magal kɛn iŋg *Rɔm ki se, naaɗe ɔɔ ansin̰ ɗim eyo ɔɔ naaɗe taaɗ ɔɔ Gaar magal kuuy utu ɔɔ naan̰ se ɓo, kɛn ron̰ Isa se.» ");
INSERT INTO kyq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kɛn jee ute dɛnɗe ute tɔɔggen gɔtn ese jaay booy taar se, naaɗe maakɗe ɓaa tuju. ");
INSERT INTO kyq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Gɔtn se naaɗe ɔl Jason ute gɛnaagen ɗoobm al‑Masi ki se, ɓaaɗo dɔnd gurs dɛn jaay ɓo, naaɗe tɔɔɗ tɔlɗe. ");
INSERT INTO kyq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Maakŋ nɔɔr kɛn ese sum ɓo, gɛnaagen ɗoobm Isa *al‑Masi ki se, ɔl Pɔl ute Silas ɓaa gɛgɛr kɛn Bere ki. Kɛn naaɗe jaay aan se, naaɗe ɓaa maakŋ *ɓee kɛn Yaudge tun lee tusn maak ki se. ");
INSERT INTO kyq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Gaŋ naaɗe ɓaa ɔŋ Yaudgen Bere ki se jiga cir Yaudgen Tɛsalonik ki, taa naaɗe booy taar Raa se maakɗe raap do ki sakan̰. Ɓii‑raa naaɗe dooy aak taar maakŋ Kitap ki se taa naaɗe an kaakŋ jeel ro ki taar kɛn Pɔl lee dooyɗen se, mɛt ki lɔ mɛt ki ey lɛ. ");
INSERT INTO kyq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Maakɗe ki se, jeege dɛna took aal maakɗe do Isa ki ɔɔ mɛnd Grɛkgen gaabɗege jee magalge ute gaabge dɛna took aal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gaŋ Yaudgen maakŋ gɛgɛr kɛn Tɛsalonik ki jaay booy ɔɔ Pɔl ɓaaga taaɗn taar Raa maakŋ gɛgɛr kɛn Bere ki kic se, naaɗe ɓaaɗo ɔɔs mɛtn jeege taa tujn̰ gɔtɔ daala. ");
INSERT INTO kyq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Gɔtn ese, gɛnaagen ɗoobm Isa al‑Masi ki naar ɔl Pɔl ɓaa taa baar ki gɛn ɓaa kookŋ maakŋ markab ki. Num Silas ute Timote se lɛ ɔɔp iŋg Bere ki. ");
INSERT INTO kyq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jeegen ɓaa kɔl Pɔl se, naaɗe ook maakŋ markab ki ute naan̰a, bini ɔlin̰o maakŋ gɛgɛr kɛn Atɛn ki. Kɛn naaɗe tɛrlo tɛrl se, Pɔl taaɗɗen ɔɔ kɛn jꞋaanga num, kꞋtaaɗ Silas ki ute Timote ki se, kꞋɓaaɗo jꞋɔŋin̰ kɛskɛ. ");
INSERT INTO kyq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kɔr Pɔl utu booy booy Timote ute Silas maakŋ gɛgɛr kɛn Atɛn ki se, naan̰ aak maakŋ gɛgɛr ese se ɗooc ute maragge sum ɔɔ naan̰ aak se maakin̰ tuj kasak kasak. ");
INSERT INTO kyq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Gɔtn se, naan̰ iin̰ ɓaa maakŋ *ɓee kɛn Yaudge lee tusn maak ki se, naan̰ naaj ute Yaudge ɔɔ ute jee ɓeer Raa ki. Ɔɔ ɓii‑raa bɔɔr maakŋ gɛgɛr kɛn jeege lee tusn se, naan̰ lee naaj ute jeege kici. ");
INSERT INTO kyq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gɔtn se jaay jee dooy jeegen uun taar Epikirus ute jee dooy jeegen uun taar Zenon se iŋg naaj ute naan̰a. Jee mɛtin̰ge ɗeek ɔɔ: «Aakum tu, debm kul taar rɛn̰ rɛn̰ ara tap ɓo je ɗeekŋ ɔɔ ɗi?» Jee kuuy ɗeek ɔɔ: «Naan̰ ɓɛrɛ ɓaanoga ute taar raa jee kuuy.» Naaɗe taaɗ bin se, taa Pɔl se taaɗɗega taaɗ taa Isa ɔɔ ute mɛtn taar dur jeegen utu dur daan yoge tu se. ");
INSERT INTO kyq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Naaɗe ɔk ɓaansin̰ do ko kɛn naaɗe lee tusn aakŋ mɛtn taarɗege se, ɔɔ gɔtn se kꞋdaŋin̰ Areopag. Gɔtn se naaɗe taaɗin̰ ɔɔ: «Naaje kꞋje naai ajen taaɗn mɛtn taar dooy kijn̰ kɛn naai lee dooy jeege se, taa naaje kꞋbooy kɔkŋ mɛtin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ute mɛtn taarigen ɓii kalaŋ naaje kꞋbooy te ey jaay, naai lee taaɗ bijen doje se, ɓaaɗo taaɗjen mɛtin̰ tu, taa naaje kꞋje kꞋjeel kɔkŋ mɛtin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Naaɗe taaɗ bin se taa jee Atɛn ki ute mɛrtgen ɓaaɗo ɓaao ɔɔ kɛngen tiŋg tiŋg gɔtn ese se, naaɗe iŋg ɓo gɛn booyo ɔɔ gɛn taaɗn mɛtn taargen kiji kɛn naaɗe ɔŋga num ɓaaɗo lee taaɗ mɛtin̰ se). ");
INSERT INTO kyq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Gɔtn se, Pɔl iin̰ ɗaar daan jeege tun Areopag ki se ɔɔ ɗeekɗen ɔɔ: «Naase jee Atɛn ki, maam mꞋaakse naase se jee ɔkki maragge se ɔɔn̰ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kɛn maam mꞋleeɗo maakŋ gɛgɛrse ki se, maam mꞋaako gɔtn kɛn naase Ꞌlee eemki maragsege ɔɔ mꞋɔŋo gɔtn tɔjn̰ sɛrkɛ kaam kalaŋ bin se kꞋraaŋin̰ ro ki jꞋɔɔ: ‹Kɛse raa kꞋjeel mɛtin̰ eyo.› Taa naan̰ se ɓo, maam mꞋɓaaɗo se mꞋasen taaɗn Raa kɛn naase eemin̰ki jaay Ꞌjeelin̰ki ey se. ");
INSERT INTO kyq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Raa se, naan̰ ɓo debm aalo dunia ute nakgen maak ki paac se ɔɔ naan̰ ɓo mɛl maakŋ raa ute do naaŋa ɔɔ naan̰ se iŋg maakŋ ɓeege tun jikilimge ɓo iin̰in̰ ute jiɗe se eyo. ");
INSERT INTO kyq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɔɔ naan̰ lɛ, ɔlin̰ ɗim te naabm jikilimge eyo, taa naan̰ kalin̰ ki sum ɓo ɛɗ koa nakge tun iŋg ɓaa se paac ɔɔ naan̰ ɓo debm ɛɗjeki nakgen Ꞌkaasn tiŋgjege. ");
INSERT INTO kyq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Naan̰ aalo deb kalaŋ sum ɓo kɛn tooj dirl mɛtjil jikilimgen do naaŋ kɛn ɓaa se paac. Ɔɔ naan̰ ɓo debm tɔndɗeno kaaɗn toojɗege ɔɔ kaaɗn kooyɗege ɔɔ gaaŋ ɛɗɗen taa naaŋge ɔɔ tɔndɗesin̰ te naaŋ guurin̰ge. ");
INSERT INTO kyq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","«Raa tɛɗn naan̰ se taa naaɗe an̰ jea ɔɔ bin sum ɓo daan naane naaɗe an̰ kɔŋɔ lɛ ɗaam? Taa naan̰ lɛ dɔk ute naajege eyo. ");
INSERT INTO kyq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Taa naan̰ se ɓo, naaje jꞋiŋgki ɔɔ kꞋleeki se kic ɓo ute naan̰a ɔɔ ɓɔrse kɛn jꞋutuki zɛɛrɛ se kic lɛ ute naan̰a. Kɛse ɓo maakŋ jee kaar bal‑zɛɛrsege tu se, deb kalaŋ maakŋ kaan̰ki se taaɗ ɔɔ: ‹Naajege se kꞋgaan Raage.› ");
INSERT INTO kyq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Aan gɔɔ naajege kꞋgɛnin̰ge ɗey se, bin num naaje jꞋaki kɔŋ saapm jꞋɔɔki Raa se tec aan gɔɔ maraggen kɛn kꞋtɛɗɗen ute daab, pudda ey lɛ ute ko se eyo. Nakgen se jikilimge tɛɗɗen ute tirɗɗege sum. ");
INSERT INTO kyq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ꞋBooyki! Do dɔkin̰ kɛn naase Ꞌjeelkiro te Raa ey se, naan̰ kɛn se kic ɓo, Raa ɔŋ utsen te eyo. Num ɓɔrse se, naan̰ daŋ jeegen gɔtn ɓaa se paac taa tɛrl maakɗe aɗe ɓaa gɔtn naan̰ ki. ");
INSERT INTO kyq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Taa naan̰ se ɓo, Raa se ɔndga kɔnd ɓiin kɛn naan̰ an kɔjn̰ bɔɔrɔ ute ɗoobin̰ do jeege tun do naaŋ ki paac. Ute debm kɛn naan̰ bɛɛr ɔɔɗin̰ gɛn kɔjn̰ bɔɔrɔ do jeege tu se, debm se ɓo kɛn naan̰ durin̰ daan yoge tu taa jikilimge se an jeel ro ki.» ");
INSERT INTO kyq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kɛn naaɗe jaay booy Pɔl ɔɔ Raa duroga nam daan yoge tu se, gɔtn se jee mɛtin̰ge baagin̰ tɛrɛcin̰ mɛtin̰ ki. Gaŋ jee kuuy se taaɗin̰ ɔɔ: «Do taari ki se, ɓiin kuuy jꞋutu jꞋai daŋ ajen taaɗn aan gɔɔ kɛn ese daala.» ");
INSERT INTO kyq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Naan̰ kɛn se sum ɓo, Pɔl teec ɔn̰ɗe. ");
INSERT INTO kyq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Num gaŋ, jee mɛtin̰ge ɓaa ɔŋ Pɔl ɔɔ took aal maakɗe do Isa ki. Maakɗe ki se gaaba kalaŋ ron̰ Denis, naan̰ kic maakŋ jeege tun lee aak mɛtn taara Areopag ki se kici ɔɔ mɛnda kalaŋ ron̰ Damaris ute jeegen kuuy kic ɓaa te naan̰a. ");
INSERT INTO kyq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kɛn Pɔl jaay iin̰ ɔn̰ gɛgɛr Atɛn se, naan̰ iin̰ ɓaa maakŋ gɛgɛr kɛn Kɔrint ki. ");
INSERT INTO kyq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Gɔtn se naan̰ ɓaa dɔɔɗ ute kɔɗ Yaud kꞋdaŋin̰ Akilas utu aan kaana ɔɔ naan̰ jꞋoojin̰ taa naaŋ Pɔŋ ki. Naan̰ iin̰o taa naaŋ Itali ki ute mɛndin̰a ron̰a Prisil, taa Gaar magal gɛn *Rɔmɛgen kꞋdaŋin̰ Klɔd se ɔl kꞋtuur Yaudge naatn paac maakŋ gɛgɛr kɛn Rɔm ki se. Naan̰ kɛn se, Pɔl ɓaa deel ute naaɗe, ");
INSERT INTO kyq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","taa naabin̰ lɛ, tec gɔɔ gɛn naaɗe ɗey se. Naabm naaɗe se, lee uj nakgen kꞋɗaapm kɔrɔr. Taa naan̰ se ɓo, Pɔl ɓaa iŋg ute naaɗe ɔɔ naaɗe lee tɛɗ naaba tɛlɛ. ");
INSERT INTO kyq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aanga *ɓii sebit ki tak ɓo Pɔl ɓaa maakŋ *ɓee kɛn Yaudge lee tusn maak ki se. Gɔtn se, naan̰ lee taaɗ taar *Raa Yaudge tu ute Grɛkge tu taa naan̰ je naaɗe Ꞌtookŋ do taarin̰ kɛn naan̰ taaɗɗen se. ");
INSERT INTO kyq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Gaŋ kɛn Silas ute Timote kɛn iin̰o Masedoan ki jaay aan sum se, Pɔl ɔn̰ ron̰ paac gɛn taaɗn taar Raa. Naan̰ taaɗ Yaudge tu tal ɔɔ *al‑Masi kɛn naase iŋg aakki kaamin̰ se, naan̰ ɓo Isa se. ");
INSERT INTO kyq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Gaŋ gɔtn se, Yaudge se iin̰ ron̰ ki ɔɔ naajin̰a. Naan̰ kɛn se, Pɔl ɔk mind kalin̰a ɔɔ ɗeekɗen ɔɔ: «Ɓɛrɛ, naase se kɛn ɗim jaay aanga dose ki kic num, maam se ɔlum eyo ɔɔ jꞋam kɔkŋ mindum eyo. Naan ki se ɓɛrɛ, maam mꞋɓaa taaɗn taar Raa jeege tun Yaudge eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Naan̰ iin̰ teec gɔtn ese ɔɔ ɓaa ɓee gaab ki kalaŋ kꞋdaŋin̰ Titus Justus. Naan̰ se debm ɓeer Raa ki ɔɔ ɓeen̰ se ɔnd daamboogo ute ɓee kɛn Yaudge lee tusn maak ki se. ");
INSERT INTO kyq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Gɔtn se Krispus, naan̰ kɛn magal ɓee kɛn Yaudge lee tusn maak ki se, naan̰ ute jee maakŋ ɓeen̰ ki paac took aal maakɗe do Mɛlje ki, ɔɔ jee Kɔrint kɛn dɛn lee booy taar Pɔl se kic, took aal maakɗe do Isa ki kici ɔɔ *kꞋbatizɗe. ");
INSERT INTO kyq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kɛn aan nɔɔr se, Mɛljege Isa mala teec naan Pɔl ki ɔɔ taaɗin̰ ɔɔ: «Ɔn̰te ɓeer jeege tun se, num taaɗ taar Raa ɓaa ute naani sak sak, ɔn̰te doa. ");
INSERT INTO kyq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Taa maam mꞋutu te naai se nam kɔŋ kɔl jin̰ roi ki eyo. ꞋJeele, maakŋ gɛgɛr kɛn ese se, maam mꞋɔk jeege dɛna.» ");
INSERT INTO kyq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gɔtn se Pɔl ɔɔp tiŋg maakŋ gɛgɛr kɛn Kɔrint ki se ɓaara ute laapa mɛcɛ. Gɔtn se naan̰ lee dooy jeege ute taar Raa. ");
INSERT INTO kyq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kaaɗ kɛn Galion magal taa naaŋ Akayi se, naan̰ kɛn se Yaudge dɔɔk taarɗe ɓaa ɔk Pɔl ɔɔ ɓaansin̰ gɔtn kɔjn̰ bɔɔr ki. ");
INSERT INTO kyq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Gɔtn se, naaɗe ɗeek Galion ki ɔɔ: «Gaabm se ɔɔs mɛtn jeege ɔɔ jꞋɔn̰te keem Raa tec aan gɔɔ kɛn naaje kꞋlee kꞋjꞋeem se.» ");
INSERT INTO kyq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ey num Pɔl se je taaɗa, naɓo Galion naar taaɗ Yaudge tu ɔɔ: «Naase Yaudge, kɛn gaabm se jaay tɛɗ te nakŋ ute ɗoobin̰ eyo, lɔ tujga ɗim kuuy se, gɛn naan̰ se num, maam mꞋasen kaakŋ mɛtn taarse. ");
INSERT INTO kyq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Gaŋ naase lɛ, Ꞌlee naajki taara do *Ko Taar Raase ki ute ro jeesege tu. Bin num, kɛse nakŋ naase malin̰ge! Maam se, mꞋkɔŋ kɔjn̰ bɔɔrɔ do nakge tun bin eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gɔtn se, naan̰ tuur ɔɔɗɗeno naatn gɔtn kɔjn̰ bɔɔr ki se. ");
INSERT INTO kyq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Gɔtn se jeege paac iin̰ gɔtn ese, iij‑ɔk Sostɛn magal *ɓee kɛn Yaudge lee tusn maak ki ɔɔ tɔnd dɛrɛŋin̰a naan jeege tun gɔtn kɔjn̰ bɔɔr ki se. Naɓo Galion kɛn magal Rɔmɛge aak nakŋ kɛn naaɗe tɛɗ se, don̰ cɔkɔ kic ɓo dirin̰in̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Maakŋ gɛgɛr kɛn Kɔrint ki se, Pɔl tiŋgga dɛna, jaay ɓo naan̰ iin̰ ɔn̰ gɛnaagen ɗoobm Isa *al‑Masi kɛn gɔtn ese. Naan̰ iin̰ ɓaa ute Prisil ɔɔ Akilas maakŋ gɛgɛr kɛn Sankre ki gɔt kɛn kꞋlee kꞋɗaar markabge. Gɔtn se, naan̰ dɔs don̰a taa naan̰ naamga naam taarin̰a, jaay ɓo naaɗe ook maakŋ markab ki ɔɔ ɓaa taa naaŋ Siri ki. ");
INSERT INTO kyq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kɛn naaɗe jaay aan maakŋ gɛgɛr kɛn Ɛpɛz ki se, Prisil ute Akilas se Pɔl ɔn̰ɗen gɔtn ese ɔɔ naan̰ iin̰ ɓaa maakŋ *ɓee kɛn Yaudge lee tusn maak ki se. Gɔtn ese naan̰ naaj ute Yaudge taa Isa. ");
INSERT INTO kyq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Naaɗe tɔnd mɛtin̰ ɔɔ: «Ɔɔp iŋg ute naaje,» naɓo Pɔl baate. ");
INSERT INTO kyq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kɛn naan̰ iin̰ ɔn̰ɗe kɔn̰ se ɗeekɗen ɔɔ: «Kɛn Raa jaay je num, ɓiin kuuy jaay mꞋaɗe ɓaa gɔtse ki.» Gɔtn se naan̰ iin̰ maakŋ gɛgɛr kɛn Ɛpɛz ki se, ook maakŋ markab ki ɔɔ ɓaa. ");
INSERT INTO kyq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kɛn Pɔl jaay aan maakŋ gɛgɛr Sezare ki se, naan̰ ook ɓaa Jeruzalɛm ki gɛn tɛɗn tɔɔsɛ *egliz ki, jaay ɓo, naan̰ bɔɔy ɓaa maakŋ gɛgɛr kɛn Antiɔs kɛn taa naaŋ Siri ki. ");
INSERT INTO kyq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Gɔtn se, naan̰ tiŋgga ɓii kandum jaay iin̰ ɓaa leeɗo maakŋ gɛgɛrge tun taa naaŋ Galati ute gɛn Prigi. Gɔtn naan̰ aanga tak ɓo, naan̰ ɛɗ kaay kaama gɛnaage tun ɗoobm Isa al‑Masi ki. ");
INSERT INTO kyq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kaaɗ kɛn se gaaba kalaŋ, kɔɗ Yaud kꞋdaŋin̰ Apɔlɔs ɔɔ naan̰ se kꞋjꞋoojin̰ maakŋ gɛgɛr kɛn Alekzandri ki. Ɔɔ naan̰ iin̰ ɓaaɗo maakŋ gɛgɛr kɛn Ɛpɛz ki. Gaabm se jeel taaɗn taara aak eyo ɔɔ jeel ɔk mɛtn Kitap jiga. ");
INSERT INTO kyq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Naan̰ se kꞋdooyin̰ga ute mɛtn taar kɛn taaɗ taa Mɛljege. Naan̰ taaɗ taar Raa se maakin̰ raap do ki sakan̰, ɔɔ taar Isa se, naan̰ dooy jeege ute ɗoobin̰ tak tak. Naɓo, naan̰ se, jeel ɓo mɛtn taar *batɛm gɛn Jan‑Batist sum. ");
INSERT INTO kyq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Maakŋ *ɓee kɛn Yaudge lee tusn maak ki se, Apɔlɔs baag taaɗn taar Raa jeege tu kic ɓo, ɓeer eyo. Gaŋ kɛn Prisil ute Akilas jaay booy taar naan̰ taaɗ se, gɔtn se naaɗe ɔk ɓaansin̰ ute naaɗe ɔɔ taaɗin̰ Ɗoobm Raa se ute ɗoobin̰ tak tak do ki daala. ");
INSERT INTO kyq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apɔlɔs se, je ɓaa taa naaŋ Akayi ki gɛn ɓaa taaɗn taar Raa jeege tu. Taa naan̰ se ɓo, gɛnaagen ɗoobm Isa *al‑Masi ki se, ɛɗin̰ kaay kaama ɔɔ raaŋ ɛɗin̰ maktub jin̰ ki, taa n̰Ꞌɓaa kɛɗn gɛnaage tun gɔtn naane, taa kɛn naan̰ aanga num, naaɗe an̰ dɔɔɗn kɔkŋ jiga. Kɛn naan̰ jaay aan gɔtn naane se, ute bɛɛ kɛn Raa tɛɗin̰ se, gɛnaagen ɗoobm Isa al‑Masi kɛn gɔtn naane se, naan̰ noogɗen dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Anum, Yaudge tu se, naan̰ taaɗɗen tal tal gɔtn ese ɔɔ taar kɛn naaɗe an̰ tɛrl kic ɓo, naaɗe ɔŋ eyo. Ɔɔ ute taargen maakŋ Kitap ki se, naan̰ taaɗɗen ɔɔ: Isa se, naan̰ ɓo al‑Masi. ");
INSERT INTO kyq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kaaɗ kɛn Apɔlɔs utu maakŋ gɛgɛr kɛn Kɔrint ki se, Pɔl aal teeco taa naaŋ Azi kɛn maakŋ koge tu se ɔɔ ɓaaɗo maakŋ gɛgɛr kɛn Ɛpɛz ki. Gɔtn se, naan̰ ɔŋ jeege kandum se, aalga kaal maakɗe do Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ɔɔ naan̰ tɔnd mɛtɗe ɔɔ: «Ɓii kɛn naase aalki maakse do Isa ki se, *Nirl Salal tap ɓo bɔɔy te dose ki ey la?» Num gaŋ naaɗe tɛrlin̰ ɔɔ: «Nirl Salal kɛn naai taaɗn se, ɓii kalaŋ naaje kꞋbooy te maanin̰ eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tɛr Pɔl tɔnd mɛtɗe ɔɔ: «Naase tap ɓo *kꞋbatizse jꞋɔɔ ɗi?» Naaɗe tɛrlin̰ ɔɔ: «Naaje se, kꞋbatizjen aan gɔɔ kɛn Jan lee batizo jeege se.» ");
INSERT INTO kyq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔl taaɗɗen daala ɔɔ: «Jan se batizo jee kɛn tɛrloga tɛrl maakɗe do *Raa ki sum. Ɔɔ naan̰ taaɗ Yaudge tu ɔɔ jꞋaal maakɗe do deb kɛn utu ɓaaɗo mɛtin̰ ki se ɔɔ naan̰ ɓo debm kꞋdaŋin̰ Isa se.» ");
INSERT INTO kyq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kɛn naaɗe jaay booy taar Pɔl taaɗɗen se, gɔtn se naaɗe took kꞋbatizɗe kuuy ute ro Mɛljege Isa. ");
INSERT INTO kyq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Naan̰ kɛn se, Pɔl tɔnd jin̰ doɗege tu ɔɔ gɔtn se Nirl Salal bɔɔyo doɗe ki ɔɔ naaɗe baag taaɗn taar naaŋgen naaɗe jeel mɛtin̰ eyo ɔɔ naaɗe taaɗ taargen teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Naaɗe paac se, aas nakŋ gaabge ɓaa ɓaa sik‑kaar‑dio. ");
INSERT INTO kyq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Daan laap kɛn mɔtɔ se, daayum Pɔl lee ɓaaɗo maakŋ ɓee kɛn Yaudge lee tusn maak ki se. Gɔtn se, naan̰ taaɗɗen mɛtn taar Gaar Raa jeege tu ɔɔ naan̰ taaɗɗen kic ɓo ɓeer eyo. Naan̰ je taa jeegen iŋg booyin̰ taarin̰ se, Ꞌtookŋ do taarin̰ kɛn naan̰ taaɗɗen se. ");
INSERT INTO kyq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Gaŋ jee mɛtin̰ge se tɛɗ do mɔŋgɔ ɔɔ baate tookŋ taarin̰a. Do Ɗoobm Isa kɛn naan̰ taaɗɗen mɛtin̰ se, naaɗe tooyin̰ koogo naan jeege tu. Gɔtn se Pɔl iin̰ ɔn̰ɗe ɔɔ ɓaa ute jee mɛtin̰ ki ɓaa maakŋ lɔkɔl gɛn gaaba kalaŋ kꞋdaŋin̰ Tiranɔs ɔɔ gɔtn se ɓii‑raa, naan̰ lee dooyɗe ute taar Raa. ");
INSERT INTO kyq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gɔtn dooyin̰ kɛn ese se, naan̰ tɛɗ ɓaara dio, bini ɔl Yaudge ute Grɛkgen taa naaŋ Azi ki paac se, ɓaa booy taar Mɛljege. ");
INSERT INTO kyq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anum Raa ɔl Pɔl tɛɗ nakŋ‑kɔɔɓgen deel doa, ");
INSERT INTO kyq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","bini, ɔl jeege ɓaa tuuno kalge taal do Pɔl ki ey lɛ ɓaano ute kalge utn ron̰a ɔɔ naaɗe tɔs ɓaano ɔɔ taalin̰ do jee kɔɔn̰ge tu ɔɔ jee kɔɔn̰ge se ɔŋ lapia ɔɔ jee kɔɔn̰ sitange se kic ɓo, sitange teec ɔn̰ɗe. ");
INSERT INTO kyq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Gɔtn se, Yaudgen mɛtin̰gen lee maakŋ naaŋge tu gɛn tuur sitange ro jeege tu se, naaɗe baag tuur sitange ute ro Isa kici. Naaɗe taaɗ sitange tu ɔɔ: «Ute ro Isan kɛn Pɔl lee taaɗ taarin̰ jeege tu se, mꞋɔɔ: Ꞌteecki naatn ro jeege tu se!» ");
INSERT INTO kyq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jeegen tɛɗn naan̰ se, naaɗe cili. Naaɗe se, gaan kɔɗ Yaud kalaŋ bini kꞋdaŋin̰ Seba, ɔɔ naan̰ se maakŋ *magal jee tɛɗn sɛrkɛ Raage tu. ");
INSERT INTO kyq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gaŋ ɓii kalaŋ, gaabm ɔk sitan se taaɗɗen ɔɔ: «Isa se, maam mꞋjeelin̰a ɔɔ Pɔl kic lɛ maam mꞋjeelin̰a, num naase ara tap ɓo, Ꞌnaŋge?» ");
INSERT INTO kyq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Gɔtn se, gaabm kɛn ɔk kɔɔn̰ sitan se iin̰ oocɗe; kɛn naan̰ jaay ɓaa cirɗe sum se, naan̰ tɔnd awarɗe ɔɔ nɛɛpm ute kalɗege se naatn. Kɛn naaɗe ɗo bini ɔŋ doɗe jaay aan̰ teec se, kalɗege kic ɓo, nɛɛpɗen doɗe ki rɔsɔm rɔsɔm. ");
INSERT INTO kyq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɔɔ kɛn Yaudge ute jee kɛn Yaudge eyo iŋg maakŋ gɛgɛr kɛn Ɛpɛz ki jaay booy taar se, gɔtn se naaɗe ɓeere ɓaa ɔkɗe. Taa naan̰ se, naaɗe ɓaa *nook ro Mɛljege Isa se cir daala. ");
INSERT INTO kyq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Gɔtn se, jeege dɛna kɛn aaloga kaal maakɗe do Isa ki se, ɓaaɗo tɔɔɗ mɛtɗege naan jeege tu, do nakge tun jig ey kɛn naaɗe lee tɛɗ se. ");
INSERT INTO kyq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Maakɗe ki se, jee dɛn kɛn lee ooj roɗege se, ɓaano ute maktubɗegen ɔk mɛtn taargen naaɗe lee oojn̰ roɗe se ɔɔ gɔtn se naaɗe tɔɔcin̰ naan jeege tu ɔɔ maktubɗege se jaay jꞋaak zon̰ se aas tamma gɛn pudda dupu‑si‑mii. ");
INSERT INTO kyq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Bin ɓo, ute tɔɔgŋ Mɛljege se taar Raa se wɔɔk ziiɗ ɓaa ute naanin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kɛn nakgen se jaay deel paac se, *Nirl Salal ɔl Pɔl uun doa gɛn ɓaa Jeruzalɛm ki ɔɔ naan̰ aal teec ute ɗoobm taa naaŋ Masedoan ɔɔ ute gɛn Akayi ki. Gɔtn se, naan̰ ɗeek gɛnaage tun ɗoobm Isa *al‑Masi ki ɔɔ: «Bɛɛki num, kɛn mꞋaanga Jeruzalɛm ki jaay ɓo, sɔm mꞋutu mꞋɓaa *Rɔm ki kici.» ");
INSERT INTO kyq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jee noogin̰gen di Timote ute Erast se, naan̰ ɔlɗe ɔɔ jꞋɔnd naana ɔɔ kꞋɓaa Masedoan ki. Ɔɔ naan̰ mala se, ɔɔp iŋg cɔkɔ taa naaŋ Azi ki. ");
INSERT INTO kyq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kaaɗ kɛn se, jeegen maakŋ gɛgɛr kɛn Ɛpɛz ki se, jeege dɛna iin̰ ul taara gajalaŋ taa Ɗoobm Isa. ");
INSERT INTO kyq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Taa gɔtn se, ɔk kɔɗ kɔrɗn tɔɔlɔ ron̰ Demetrus. Naan̰ se lee ɔɔy pudda gɛn ɗaapm ɓeegen sɛɛm sɛɛm kɛn tec ɓee magal gɛn maragɗen naaɗe lee eemin̰ kɛn kꞋdaŋin̰ Artemis se. Ute naabɗen ese se, naan̰ ute jeegen kꞋtɛɗ naaba tɛlɛ ese, naaɗe lee ɔŋ gurs dɛna ro ki. ");
INSERT INTO kyq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ɓii kalaŋ, naan̰ daŋ tus jee kɛn naaɗe tɛɗn naaba tɛlɛ ute jee kɛn naabɗe tec aan gɔɔ gɛn naaɗe se, ɔɔ ɗeekɗen ɔɔ: «Mɛɗumge, naase Ꞌjeelki maal naaje kꞋjꞋɔkki se kꞋjꞋɔŋin̰ki ute naabm ese. ");
INSERT INTO kyq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Num gaŋ naase aakkiga ɔɔ Ꞌbooykiga nakŋ kɛn deel Ɛpɛz ki paac se ɔɔ Pɔl ese se ɗeek jeege tu ɔɔ raagen naaje mala kꞋtɛɗin̰ki ute jijege se, raagen ɗeer eyo. Do taar kɛn naan̰ lee taaɗ jeege tu se ɔl jeege dɛna took taarin̰a ɔɔ ɓaaga mɛtin̰ ki. Nakŋ se, naan̰ tɛɗin̰ Ɛpɛz ki sum eyo, num gaŋ taa naaŋ Azi ute magalin̰ paac kici. ");
INSERT INTO kyq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kɛn naan̰ jaay utu tɛɗn nakŋ se tak num, ɓɛrɛ, utu ajeki tujn̰ naabjege. Num naabjege sum eyo, num utu kɔl jeege maragjegen magal Artemis se kic ɓo, naaɗe utu an̰ kaal maak ki eyo ɔɔ ɓeen̰ se kic lɛ, naaɗe an̰ kaakŋ aan gɔɔ nakŋ cɛrɛ. Ey num, Artemis se ɓo, jee taa naaŋ Azi ki ute jee do naaŋ ki paac se lee eemin̰a.» ");
INSERT INTO kyq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kɛn jee tɛɗn naabgen gɔtn ese jaay booy taar Demetrus se, naaɗe maakɗe taarɗe pirin̰ ɔɔ baag tɔɔy dɔɔkŋ taara ɔɔ: «Artemis se, naan̰ ɓo maragŋ magal kɛn Ɛpɛz ki!» ");
INSERT INTO kyq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gɔtn se, jeege iin̰ ul taara gajalaŋ maakŋ gɛgɛr kɛn se, ɔɔ tɔko Gayus ute Aristark kɛn iin̰o Masedoan ki ɔɔ lee te Pɔl tɛlɛ se. Naaɗe naar ɓaanɗeno daan bɔɔr kɛn gɔtn kꞋlee kꞋjꞋɔjn̰ bɔɔrɔ se. ");
INSERT INTO kyq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ey num Pɔl se, je ɓaa gɔtn jeege tun tus se kici, naɓo gɛnaagen ɗoobm Isa al‑Masi ki se, gaasin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ɔɔ maakŋ magalge tun taa naaŋ Azi ki se, jee mɛtin̰ge se mɛɗn Pɔlge ɔɔ naaɗe ɔl nam ɓaa taaɗ Pɔl ki ɔɔ: «Ɓɛrɛ, ɔn̰te ɓaa gɔtn jeege tun tus se!» ");
INSERT INTO kyq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kaaɗ kɛn jeege tus gɔtn ese se, jee mɛtin̰ge ul gɛn doɗe ɔɔ jeegen kuuy se kic lɛ, taaɗ gɛn doɗe kici. Jee dɛn jaay ɓaaɗo gɔtn ese se, mɛtn taar jaay ɔlɗe naaɗe tusn ro ki se kic ɓo, naaɗe jeel mɛtin̰ eyo. ");
INSERT INTO kyq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Maakŋ jee dɛnge tu se, gaaba kalaŋ kɔɗ Yaud ron̰ Alekzandɛr. Maakɗe ki se, jee mɛtin̰ge ɓaa taaɗin̰ mɛtn taar se jaay ɓo Yaudge ɔlin̰ ɓaa naan jeege tu. Naan̰ uun jin̰ jeege tu je aɗen taaɗn mɛtn taar se. ");
INSERT INTO kyq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Naɓo kɛn jee Ɛpɛz ki jaay booy ɔɔ naan̰ kɔɗ Yaud se, gɔtn se naaɗe dɔɔb ɔɔy taa naapm caa ɔɔ: «Artemis se, naan̰ ɓo maragŋ magal kɛn Ɛpɛz ki!» Gɔtn se naaɗe tɔɔy dɔɔk taara ɔn̰ eyo ɓaa ɓaa nakŋ lɛr dio. ");
INSERT INTO kyq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kaam mɔɔtn se, gaabm kɛn debm raaŋ kɛn tɛɗ naaba daan Yaudge tun *jee kaakŋ mɛtn taargen gɔtn ese se, tɛɗ jeege bini ɓaa doa ɔɔ ɗeekɗen ɔɔ: «Naase jee Ɛpɛz ki, jeege paac se jeeljeki naajege ɓo kɛn kꞋjꞋɔkki ɓee maragŋ magal ron̰ Artemis se. Ɔɔ maragjege mala se lɛ, naan̰ ooco maakŋ raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Maragjege se, nam ɗɛmin̰ eyo, num ɔn̰ki ro se urlu ɔɔ nakŋ se Ꞌsaap ɔkin̰ki jiga jaayo. ");
INSERT INTO kyq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Jeegen naase Ꞌtɔk ɓaanɗekiro ara se lɛ, naaɗe uun te ɗim maakŋ ɓee maragjege tu se eyo. Ɔɔ naaɗe lɛ, taaɗ te taar iŋg kus ron̰ ki eyo. ");
INSERT INTO kyq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kɛn Demetrus ute jeen̰ge jaay ɔk taara ute nam lɛ, naaje jꞋɔkki ɓii gɛn kɔjn̰ bɔɔrɔ ɔɔ jee kɔjn̰ bɔɔrin̰ge kic lɛ utu. Bin num, taar se ɔn̰ kꞋɓaan gɔtn naane ɓo, naaɗe an̰ kaakŋ ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɔɔ kɛn naasen jee dɛnge se jaay ɔkki taar ɗim kuuy lɛ, ɓii kɛn jeege tusga sum ɓo, jꞋutu jꞋkaakŋ mɛtin̰ ute ɗoobin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Do nak kɛn naaje kꞋtɛɗki jaaki se, jꞋutu jꞋankiro ɓaa te nakŋ ɔɔn̰ dojege tu. Ɓɛrɛ Rɔmɛge se lɛ, utu ajeki kɔkŋ mindjege Ꞌɗeekŋ ɔɔ: naajege se ɓo, jee tujn̰ naaŋge. Taa kɛn Rɔmɛge jaay ɓaaɗo Ꞌtɔnd mɛtjege gɛn tusjegen jaaki se, naaje jꞋaki kɔŋ taar ɗim, jaay jꞋaɗeki kɔŋ taaɗ eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kɛn naan̰ jaay taaɗ naŋ taarin̰ se, jee se naan̰ wɔɔkɗe. ");
INSERT INTO kyq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kɛn mɛtn taar se jaay deel se, Pɔl ɔl kꞋdaŋ kꞋtuso jee aalga kaal maakɗe do Isa *al‑Masi ki ɔɔ naan̰ ɛɗɗen kaay kaama jaay ɓo ɗeekɗen ɔɔ iŋgki lapia ɔɔ naan̰ uun ɗoobm taa naaŋ Masedoan. ");
INSERT INTO kyq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kaaɗ kɛn naan̰ aal teeco teec taa naaŋ kɛn ese se, jee aalga kaal maakɗe do Isa al‑Masi ki se, naan̰ taaɗɗenga taarge dɛna kɛn ɛɗɗen kaay kaama, jaay ɓo naan̰ iin̰ ɓaa taa naaŋ Grɛkge tu. ");
INSERT INTO kyq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Gɔtn se, naan̰ tiŋg laapa mɔtɔ. Aan kaaɗ kɛn jaay naan̰ ɓaa kookŋ maakŋ markab ki gɛn ɓaa taa naaŋ Siri ki se, naan̰ booy ɔɔ Yaudge se, dɔɔkga dɔɔk taarɗe ron̰ ki gɛn kutin̰a. Taa naan̰ se ɓo, naan̰ uun doa gɛn tɛrl ɓaa taa naaŋ Masedoan ki. ");
INSERT INTO kyq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jeegen kɛn lee ute naan̰ se, naaɗe se ɓo: Sopatrɔs goon Pirus kɛn iin̰o maakŋ gɛgɛr kɛn Bere, Aristark ute Sekundus, naaɗe se iin̰o maakŋ gɛgɛr kɛn Tɛsalonik ki ɔɔ Gayusn kɛn iin̰o maakŋ gɛgɛr kɛn Derbe ɔɔ Tisik ute Tropim kɛn iin̰o taa naaŋ Azi kɛn kaam kalaŋ ɔɔ kɛse Timote. ");
INSERT INTO kyq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Jee se ɔnd naana ɓaa booyje maakŋ gɛgɛr kɛn Troas ki. ");
INSERT INTO kyq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gaŋ naaje se kꞋtɛɗ Laa mappan ɔk ɔrɔm eyo aas jaay ɓo, jꞋiin̰ Pilip ki se, jꞋook maakŋ markab ki kꞋtɛɗ ɓii mii jaay ɓo kꞋɓaa kꞋjꞋɔŋɗe maakŋ gɛgɛr kɛn Troas ki. Gɔtn se, naaje kꞋtiŋgo ɓii cili. ");
INSERT INTO kyq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kɛn aan *ɓii sebit ki tɛgɛr se, naaje kꞋtus kꞋjꞋɔs kalaŋ jaay ɓo kꞋjꞋuun sɛn‑sɛn. Gɔtn se Pɔl baag taaɗn gɛnaage tun ɗoobm Isa *al‑Masi kɛn tus gɔtn ese. Aan gɔɔ naan̰ mɛtbeeki sum ɓo ɓaa ɓaa se, naan̰ taaɗɗen taara bini aan daan ɓea. ");
INSERT INTO kyq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","9","Maakŋ ɓee kɛn kꞋjꞋɔɓin̰ do naapin̰ ki gɛn k‑mɔtɔge tu se, gɔtn se ɓo naaje kꞋtus maak ki ɔɔ maakŋ ɓee kɛn ese se, kꞋtɔɔc kꞋtɔndga lɔɔmpɔge dɛna. Gɔtn se, goon kɔɗɔ kalaŋ kꞋdaŋin̰ Utik se, naan̰ iŋg kiŋg taa pɛnɛtɛr ki. Aan gɔɔ Pɔl taaɗ ɔn̰ ey se, gɔtn se bi ɓaa ɔkin̰ se tooɗ sen̰. Gaŋ maakŋ tooɗn bin̰ ki se, naan̰ iik ujo ɔɔ aal ooc naaŋ ki. Kɛn deb kalaŋ bɔɔy ɓaa ɔŋin̰ jaay je an̰ kuun se, ɔŋin̰ naan̰ ooyga. ");
INSERT INTO kyq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Gɔtn se Pɔl bɔɔyo ɔɔ no uunin̰ ɔkin̰ kaaɗin̰ ki ɔɔ ɗeekɗen ɔɔ: «Naase ɔn̰ki rose urlu. Ɓɛrɛ, naan̰ utu zɛɛrɛ!» ");
INSERT INTO kyq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Gɔtn se, Pɔl ɔk tɛrl ook ɓaa maakŋ ɓee ki gɔtin̰ ki, naan̰ dup ɛɗɗen mappa ɔɔ kꞋjꞋɔs tɛlɛ. Tɛr, naan̰ baagɗen taaɗn daala bini gɔtɔ iipi, jaay ɓo naan̰ ɗeekɗen ɔɔ: «Iŋgki lapia. Maam se mꞋɓaaga jaayo!» ");
INSERT INTO kyq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Num, kɛn goon kɔɗn duro se lɛ, naaɗe ɔk ɓaansin̰ ɓeen̰ ki ɔɔ gɔtn se, jee paacn̰ kɛn aakin̰ se, maakɗe raapo. ");
INSERT INTO kyq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Naan̰ kɛn se, naaje kꞋjꞋook maakŋ markab ki jꞋɔnd naana gɛn ɓaa maakŋ gɛgɛr kɛn Asɔs, gɛn ɓaa kuun Pɔl gɔtn ese. Taa Pɔl se, uunga kuun doa gɛn ɓaa ute jɛn̰a. ");
INSERT INTO kyq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kɛn Pɔl jaay ɓaa ɔŋje maakŋ gɛgɛr kɛn Asɔs ki se, gɔtn se naaje kꞋjꞋuunin̰ maakŋ markab ki ɔɔ kꞋɓaa maakŋ gɛgɛr kɛn Mitɛlɛn ki. ");
INSERT INTO kyq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mɛtbeen̰ki kꞋjꞋiin̰ gɔtn ese ɔɔ kꞋɓaa maakŋ gɛgɛr kɛn Sio ki, ɔɔ mɛtbeen̰ kɛn kuuy se, naaje kꞋjꞋiin̰ kꞋɓaa maakŋ gɛgɛr kɛn Samɔs ki. Tɛr, ɓii kɛn kuuy se, jꞋiin̰ Samɔs ki se, kꞋɓaa maakŋ gɛgɛr kɛn Milɛ ki. ");
INSERT INTO kyq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Naaje kꞋjꞋuun ɗoobm se taa Pɔl se, bɛɛki num, je naar ɓaa Jeruzalɛm ki gɛn ɓaa tɛɗn Laa Pantekɔt. Taa naan̰ se ɓo, naan̰ deel cɛɛ gɛgɛr kɛn Ɛpɛz ki kic ɓo, baate kaal maak ki, taa naan̰ je takal ron̰a taa naaŋ Azi ki se eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kɛn naaje kꞋjꞋaan maakŋ gɛgɛr kɛn Milɛ ki se, Pɔl ɔl kꞋɓaa kꞋdaŋo jee naan eglizn Ɛpɛz ki, taa utu an̰ kɔŋ gɔtn ese. ");
INSERT INTO kyq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kɛn naaɗe jaay aan ɔŋin̰ se, Pɔl tɛɗɗen tɔɔsɛ ɔɔ ɗeekɗen ɔɔ: «Gɔtn maam mꞋaan gɔtse ki jaay mꞋtiŋgo maakse ki sum se, naase Ꞌjeelumki. ");
INSERT INTO kyq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kɛn maam mꞋtiŋgo maakse ki se, maam mꞋɔɔpo rom baat jaay ɓo mꞋtɛɗo naabm Mɛljege Isa se. Kaaɗ kɛn se, maam mꞋiŋgo maakŋ kaa‑maan ki ɔɔ mꞋdabarga dɛna taa Yaudgen dɔɔkga dɔɔk taarɗe jaay Ꞌje am tɔɔl se. ");
INSERT INTO kyq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ꞋJeelki, naan̰ kɛn se, maam mꞋdooyseno ɔɔ mꞋtaaɗseno taar *Raa naan jeege tu, ɔɔ maakŋ ɓeesege tu se, taargen jaay asen noogse, kalaŋ tap ɓo, maam mꞋdirigŋ te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Maam mꞋtaaɗ Yaudge tu ute jeegen Yaudge eyo mꞋɔɔ kꞋtɛrl maakɗe do Raa ki ɔɔ jꞋaal maakɗe do Mɛljege Isa ki. ");
INSERT INTO kyq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ɓɔrse, maam se mꞋɓaa ɓaa Jeruzalɛm ki. Kɛse *Nirl Salal ɓo ɔlum ɔɔ mꞋɓaa ɔɔ maam se mꞋjeel eyo nakŋ jaay utu kaan dom ki gɔtn naane se. ");
INSERT INTO kyq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Naɓo, maakŋ gɛgɛr kɛn maam mꞋaanga tak se, Nirl Salal ɔɔjum ɔɔ kɛn maam jaay mꞋɓaaga Jeruzalɛm ki se, jꞋutu jꞋam ɓaa kɔl daŋgay ki ɔɔ jꞋutu jꞋam dabar dɛna. ");
INSERT INTO kyq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Gaŋ maam se mꞋaak kiŋgum do naaŋ ki se, aan gɔɔ nakŋ cɛrɛ; nakŋ kɛn ɔɔn̰um maam ki tak se, mꞋje naabm kɛn Mɛljege Isa ɛɗumsin̰ kaam jim se, mꞋan̰ tɛɗn kaasin̰ ute ɗoobin̰a ɔɔ naabm kɛn Mɛljege ɛɗumsin̰ se taa mꞋtaaɗn Labar Jigan gɛn Isa *al‑Masi ɔɔ ute naan̰ se ɓo, Raa tɛɗn bɛɛn̰a jeege tu. ");
INSERT INTO kyq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ꞋBooyki, maam kɛn mꞋtiŋgo daanse ki jaay, mꞋtaaɗseno taar Gaar Raa se mɔɔtn naan ki se, naase amki kaak ey sum. ");
INSERT INTO kyq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Taa naan̰ se ɓo, jaaki maam mꞋɔk mind kaluma ɔɔ mꞋɗeekseni naan ki se, debm jaay utga num, maam se ɔlum eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Taa maam se mꞋtaaɗsenoga nakŋ kɛn paacn̰ Raa maakin̰ jen ro ki, taar ɗim kalaŋ tap ɓo, maam mꞋɔysesin̰ te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«Ɓɔrse, naase se iŋg ɔndki kɔndɔ ɔɔ Ꞌsaapki do egliz kɛn Nirl Salal ɛɗsesin̰ kaam jise se ɔɔ aakɗeki doɗe ki; bin se, Ꞌgaamɗeki aan gɔɔ dɔɔl baatge, taa egliz se Raa dugin̰ga dugu ute moosin̰a. ");
INSERT INTO kyq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","«Maam mꞋjeele, kɛn maam jaay mꞋɓaaga se, jeege se ute aɗe goon̰ kɛnd maakse ki aan gɔɔ k‑sogsogigen ɛndga maakŋ dɔɔl baatge tu num, lee wɔɔkɗe se. ");
INSERT INTO kyq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ɔɔ maakse ki se kic jee mɛtin̰ge utu dooy jeege ute taargen mɛt ki eyo. Naaɗe utu kɔl jeegen aalga kaal maakɗe do Isa ki se, kic ɓo utu kuun taarɗe. ");
INSERT INTO kyq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bin se, iŋgki do mɛtɛkse ki. ꞋJeelki maakŋ ɓaar kɛn mɔtɔ se, nɔɔrɔ katara, maam mꞋɔn̰ te eyo ɔɔ naŋa kic ɓo, maam mꞋdɛjin̰ga ɔɔ taa naase se, maam mꞋeemga dɛn aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ɓɔrse, maam mꞋɔn̰se kaam ji Raa ɔɔ naase Ꞌsaapki do taar Raa kɛn maam mꞋtaaɗseno mꞋɔɔ: Raa se naan̰ debm bɛɛ. Ute taar se ɓo, naan̰ asen kɛɗn tɔɔgɔ do kaal maakse kɛn naase aalki do Isa ki se. Ute naan̰ se, naase aki kɔŋ bɛɗse ute jee kɛn naan̰ tɛɗɗenga tɛɗga jee naan̰gen salal se. ");
INSERT INTO kyq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Gaŋ maam lɛ, mꞋjeɗe te gurs nam eyo ɔɔ daab ute kal nam kic lɛ, maam mꞋjeɗe te eyo. ");
INSERT INTO kyq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Naase Ꞌjeelki ute naabm kɛn maam mꞋtɛɗ ute jim mala se ɓo, maam mꞋute jeemge se aasjen kiŋgje. ");
INSERT INTO kyq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ute naabm daayum maam mꞋtɛɗ daanse ki se, maam mꞋje mꞋasen taaɗn mꞋɔɔ: Ꞌtɛɗki naaba jaay ɓo jꞋanki noogŋ jee daayge. Ɔɔ kꞋsaapki do taar Mɛljege Isa kɛn taaɗ ɔɔ: ‹Debm ɛɗ naka deb ki se, maakin̰ raap cir debm kɛn jꞋɛɗin̰ kɛɗa.›» ");
INSERT INTO kyq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kɛn Pɔl jaay taaɗ naŋ taarin̰ se, naan̰ ɛrg naaŋ ki ute naaɗe paac ɔɔ eem Raa. ");
INSERT INTO kyq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Gɔtn se naaɗe paac baag keeme ɔɔ naŋa naŋa kic ɓo ɓaaɗo baam ɔk Pɔl kaaɗin̰ ki kaaɗin̰ ki, ɔɔ nakŋ kɛn ɔl maakɗe tuj se, taa kɛn Pɔl taaɗɗenga taaɗ ɔɔ: «Naan ki se, mɔɔtn naase amki kaak ey sum.» Gɔtn se, naaɗe ɓaa ɔlin̰ mɛtn markab ki ɔɔ ɗeekin̰ ɔɔ: «ꞋƁaa te lapia.» ");
INSERT INTO kyq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kɛn naaje jaay kꞋjꞋiin̰ jꞋɔn̰ɗe Milɛ ki sum se, naaje jꞋook maakŋ markab ki ɔɔ kꞋgaaŋ kꞋɓaa maakŋ gɛgɛr Kɔs ki; ɔɔ mɛtbeen̰ki se, naaje kꞋjꞋiin̰ kꞋɓaa maakŋ gɛgɛr kɛn Rɔd ki. Kɛn naaje jaay kꞋjꞋiin̰ Rɔd ki se, kꞋɓaa maakŋ gɛgɛr kɛn Patara, gɔtn kɛn kꞋlee kꞋɗaar markabge. ");
INSERT INTO kyq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patara ki se, naaje jꞋɔŋ markabm kɛn ɓaa ɓaa taa naaŋ Pɛnisi ki, jꞋookŋ maak ki ɔɔ kꞋɓaa. ");
INSERT INTO kyq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kɛn naaje jaay kꞋɓaa ɓaa do baar ki se, naaje jꞋaak taa naaŋ Sipir se do ji jeelje ki ɔɔ naaje kꞋdeel kꞋɓaa taa naaŋ Siri ki. Kɛn naaje jaay jꞋaan maakŋ gɛgɛr kɛn Tir ki se, naaje kꞋbɔɔy gɔtn ese, taa gɔtn ese ɓo, nakŋ maakŋ markab ki se jꞋan̰ bɔɔy naatn. ");
INSERT INTO kyq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Maakŋ gɛgɛr kɛn Tir ki se, naaje jꞋɔŋ gɛnaagen aalga kaal maakɗe do Isa *al‑Masi ki, ɔɔ gɔtn se naaje kꞋtiŋg ɓii cili ute naaɗe. Gaŋ jee se, *Nirl Salal taaɗɗen nakŋ kɛn utu Ꞌkaan do Pɔl ki ɔɔ naaɗe taaɗ Pɔl ki ɔɔ: «N̰Ꞌɔn̰te ɓaa Jeruzalɛm ki.» ");
INSERT INTO kyq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kɛn kꞋtiŋg ute naaɗe ɓii cili aas jaay jꞋiin̰ kꞋɓaa ɓaa se, gɛnaagen ɗoobm Isa al‑Masi kɛn gɔtn ese ute mɛndge ɔɔ gaange paac ɔlje, bini kꞋteec kꞋjꞋɔn̰ maakŋ gɛgɛr se. Kɛn naaje jaay jꞋaan taa baar ki se, naaje kꞋjꞋɛrg naaŋ ki do kɛɛs kɛn taa baar ki se, ɔɔ gɔtn se, naaje kꞋtɔnd mɛtn *Raa. ");
INSERT INTO kyq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kɛn naaje jaay kꞋjꞋiin̰ kꞋɓaa ɓaa se, naaje kꞋtaaɗɗen jꞋɔɔ: «Iŋgki lapia.» Gɔtn se, naaje jꞋook maakŋ markab ki ɔɔ naaɗe lɛ ɔk tɛrl ɓaa ɓeeɗege tu. ");
INSERT INTO kyq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Naaje kꞋjꞋiin̰ Tir ki se, kꞋgaaŋ kꞋɓaa maakŋ gɛgɛr kɛn Putolemais ki. Ɔɔ kɛn naaje jaay jꞋaan se, kꞋɓaa kꞋtɛɗ tɔɔsɛ gɛnaage tun ɗoobm Isa al‑Masi kɛn gɔtn ese. Naaje kꞋtooɗ ɓii kalaŋ ute naaɗe ɔɔ gɔtn ese sum ɓo, naaje kꞋbɔɔy kꞋjꞋɔn̰ markaba. ");
INSERT INTO kyq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mɛtbeen̰ki se, naaje kꞋjꞋiin̰ kꞋɓaa maakŋ gɛgɛr kɛn Sezare ki ɔɔ kꞋɓaa kꞋbɔɔy ɓee Pilip kɛn lee wɔɔk Labar Jiga gɛn Isa al‑Masi jeege tu se. Pilipm se, debm maakŋ jeege tun cilin kɛn kꞋbɛɛr kꞋtɔɔɗɗeno Jeruzalɛm ki gɛn noogŋ *jee kaan̰ naabm Isa al‑Masige se. ");
INSERT INTO kyq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilip se, ɔk gaangen mɛndge sɔɔ kɛn tɔk te gaabge eyo, ɔɔ naaɗe se lee taaɗ taargen teeco taar Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gɔtn se, naaje kꞋtiŋgoga ɓii dɛna ɔɔ naan̰ kɛn se, gaaba kalaŋ iin̰o taa naaŋ Jude ki, ron̰ Agabus, ɓaaɗo ɔŋje. Naan̰ se lee taaɗ taargen teeco taar Raa ki kici. ");
INSERT INTO kyq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kɛn naan̰ jaay aan ɔŋje se, naan̰ uun nakŋ Pɔl lee dɔɔkŋ maakin̰ se, dɔɔkŋ jin̰ge ute jɛn̰ge, jaay taaɗɗen ɔɔ: «Aakki, Nirl Salal se taaɗum ɔɔ: nakŋ dɔɔkŋ maakŋ nam ese se, malin̰ jaay ɓaaga Jeruzalɛm ki num. Yaudge se utu an̰ dɔɔkŋ bin kici ɔɔ naaɗe utu an̰ kɔkŋ kɔl ji jeege tun Yaudge eyo.» ");
INSERT INTO kyq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kɛn naaje ute gɛnaagen ɗoobm Isa al‑Masi kɛn maakŋ gɛgɛr kɛn gɔtn ese jaay kꞋbooy taar se se, gɔtn se naaje kꞋjꞋeem nɔɔ mɛtn Pɔl ki jꞋɔɔ n̰Ꞌɔn̰te ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Gaŋ naan̰ tɛrljen ɔɔ: «Naase eemki bin se gɛn ɗi? Kɛse naase ɔjumki kɔj maakum ɓo maane. Maam se mꞋtook naaɗe am dɔɔk sum eyo, num maam mꞋtooko gɛn ɓaa kooy Jeruzalɛm ki taa Mɛljege Isa.» ");
INSERT INTO kyq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Aan gɔɔ, naan̰ lɛ took taarje ey ɗey se, naaje kic kꞋjꞋɔn̰in̰a ɔɔ kꞋbaate taaɗin̰ taar ɗim kuuy sum. Ɔɔ gɔtn se naaje kꞋtaaɗ jꞋɔɔ: «Ɔn̰ Mɛljege Ꞌtɛɗn nakŋ kɛn maakin̰ jen ro ki.» ");
INSERT INTO kyq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kɛn naaje jaay kꞋtiŋg Sezare ki ɓii kandum se, gɔtn se naaje kꞋɗaap roje gɛn kookŋ ɓaa Jeruzalɛm ki. ");
INSERT INTO kyq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kɛn kꞋjꞋiin̰ Sezare ki jaay kꞋɓaa ɓaa se, gɛnaagen aalga kaal maakɗe do Isa al‑Masi kɛn gɔtn ese se, ɓaa ute naaje. Kɛn naaje jaay jꞋaan Jeruzalɛm ki se, naaɗe ɔlje kꞋɓaa kꞋbɔɔy gɔtn gaab ki kalaŋ kꞋdaŋin̰ Mnason, kɛn iin̰o taa naaŋ Sipir ki. Gaabm se, gɔtn aal maakin̰ do Isa al‑Masi ki sum se, daanin̰ dɔkga. ");
INSERT INTO kyq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kɛn naaje jaay jꞋaan Jeruzalɛm ki sum se, gɛnaagen ɗoobm Isa *al‑Masi kɛn gɔtn ese, dɔɔɗ ɔkje ute maak‑raapo. ");
INSERT INTO kyq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mɛtbeen̰ki se, naaje jꞋutu Pɔl kꞋɓaa gɔtn Jak ki. Gɔtn se, naaje jꞋɔŋ jee naan *eglizge se tusga gɔtn ese kici. ");
INSERT INTO kyq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kɛn naaje kꞋtɛɗɗen tɔɔsɛ aas se, gɔtn se Pɔl taaɗɗen mɛtn nakgen kɛn Raa ɔlin̰ jaay naan̰ tɛɗo daan jeege tun Yaudge eyo se, kalaŋ kalaŋ. ");
INSERT INTO kyq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jee se jaay booy taar Pɔl taaɗɗen se, gɔtn se naaɗe *nook Raa ɔɔ taaɗ Pɔl ki ɔɔ: «ꞋBooyo gɛnaaje, ɓɔrse Yaudgen dupu kando kando se took aalga maakɗe do Isa al‑Masi ki, naɓo naaɗe se ɔk *Ko Taar kɛn Raa ɛɗo Musa ki se ɔɔn̰ aak eyo. ");
INSERT INTO kyq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɔɔ Ꞌjeele, naaɗe se lɛ booyga taar kɛn jeege lee taaɗ roi ki se, ɔɔ naai lee dooy Yaudgen kɛn iŋg maakŋ jeege tun Yaudge ey se, ɔɔ lee taaɗɗen ɔɔ: ‹JꞋɔn̰te kuun Ko Taar kɛn Raa ɛɗo Musa ki se ɔɔ gɛnɗege se lɛ, jꞋɔn̰te tɔjɗen pɔndɔ ɔɔ jꞋɔn̰te tɛɗn nakŋ bubɗege.› ");
INSERT INTO kyq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Gɔtn naai ɓaaɗo gɔtn ara sum se, ɓɛrɛ, naaɗe lɛ booyga. Bin se, jꞋaki tɛɗn jꞋɔɔki ɗi? ");
INSERT INTO kyq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bin num, Ꞌbooy taar naaje jꞋai taaɗ se. Naaje jꞋɔk gaabge sɔɔ, kɛn naamga naam taarɗege naan Raa ki. ");
INSERT INTO kyq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jee se Ꞌɓaanɗe ute naai daan bɔɔr *Ɓee Raa ki ɔɔ tug Ꞌɗaapki rose naan Raa ki ɔɔ ɔgɗen nakŋ kɛn naaɗe an tɛɗn *sɛrkɛ Raa ki se kici. Bin se, naaɗe kic Ꞌkɔŋ dosn doɗe ɔɔ ute naan̰ se, jeege paac Ꞌjeele taar kɛn kꞋlee kꞋtaaɗ roi ki se, mɛt ki eyo. Anum, naaɗe ai kaaki naai kic, iŋg do Ko Taar kɛn Raa ɛɗo Musa ki se. ");
INSERT INTO kyq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Gɛn jeegen Yaudge ey jaay aalga kaal maakɗe do Isa al‑Masi ki se lɛ, naajege kꞋraaŋɗeki raaŋ jꞋɔɔki: jꞋɔn̰te kɔsn daa maragge, jꞋɔn̰te kɔsn mooso, jꞋɔn̰te kɔsn daagen moosin̰ ɔɔy te naaŋ ki eyo ɔɔ jꞋɔn̰te kɛɛsn naapge rɛn̰ rɛn̰.» ");
INSERT INTO kyq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Gɔtn se, Pɔl took taarɗe ɔɔ mɛtbeen̰ki se, Pɔl ɓaa ute jee se gɛn ɓaa tugŋ ɗaapm roɗe naan Raa ki. Naan̰ kɛn se, Pɔl ɓaa daan bɔɔr ɓee Raa kɛn maak ki ɔɔ ɔŋ *debm tɛɗn sɛrkɛ Raa ki se, ɔndin̰ ɓiia, ɔɔ ɗeekin̰ ɔɔ: «Ɓii kɛn naaje *kꞋtug kꞋɗaapga roje naan Raa ki num, naŋa naŋa kic ɓo ano ɓaa ute sɛrkin̰ sɛrkin̰ naan Raa ki.» ");
INSERT INTO kyq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kɛn ɓii cili jaay ɔɔpga gɔɔr Ꞌnaŋ se, kaaɗ kɛn se Yaudgen iin̰o taa naaŋ Azi ki jaay aak Pɔl daan bɔɔr Ɓee Raa kɛn maak ki se. Gɔtn se, naaɗe ɔɔs mɛtn jee dɛnge ɓaaɗo iij‑ɔk Pɔl. ");
INSERT INTO kyq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Gɔtn se naaɗe dɔɔb ɔɔy ɔɔ: «Gaan *Israɛlge, ɓɛrɛ, jꞋoorjekiro! Gaabm kɛn lee dooy jeege gɔtn ɓaa se paac ute taargen jig ey se, ɓaaɗoga ara. Naan̰ ɓo debm kɛn lee taaɗ taargen jig eyo ro gaan Israɛlge tu, ro *Ko Taar kɛn Raa ɛɗo Musa ki ɔɔ ro Ɓee Raa ki. Ɓɔrse, naan̰ ɓaaɗoga daan bɔɔr Ɓee Raa kɛn maak ki se, ute jeegen Yaudge eyo ɔɔ Ɓee Raa se lɛ, naan̰ tujin̰ga.» ");
INSERT INTO kyq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Taa naaɗe aakga kaak Pɔl ute Tropim kɛn kɔɗ Ɛpɛz se, lee lee kalaŋ maakŋ gɛgɛr kɛn Jeruzalɛm ki. Taa naan̰ se ɓo, naaɗe saap ɔɔ kaaɗ naane Pɔl ɔk ɓaanoga ute Tropim daan bɔɔr Ɓee Raa kɛn maak ki se. ");
INSERT INTO kyq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Gɔtn se, jeegen maakŋ Jeruzalɛm ki paac se, iin̰ ul taar gajalaŋ ɔɔ jeege dɛna kɛn aan̰ ɓaaɗo gɔtn ese. Pɔl se, naaɗe iij‑ɔkin̰a ɔɔ tiik ɔɔɗin̰ naatn daan bɔɔr Ɓee Raa ki ɔɔ naaɗe naar gaasn ute kaam taarge se naatn. ");
INSERT INTO kyq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Gɔtn se, naaɗe je an tɔɔl ute Pɔl, gaŋ naan̰ kɛn se, nam ɓaa taaɗ bubm asgarge tu ɔɔ: «Ɓɛrɛ, maakŋ gɛgɛr Jeruzalɛm se, tujga!» ");
INSERT INTO kyq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Gɔtn se, bubm asgarge se naar tus asgarge ute magalɗege aan̰ ɓaa gɔtn jee dɛnge tu. Kɛn jee dɛnge jaay aak bubm asgarge ute asgarin̰ge se, Pɔl kɛn naaɗe tɔndin̰ tɔnd se kic ɓo, gɔtn se naaɗe ɔn̰in̰a. ");
INSERT INTO kyq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kɛn bubm asgarge jaay aan ɔŋ Pɔl se, naan̰ ɔl asgarge se ɔkin̰a ɔɔ naaɗe tɔso zin̰ziri dio ɓaaɗo dɔɔkin̰a. Gɔtn se, naan̰ tɔnd mɛtn jeege ɔɔ: «Gaabm se tap ɓo, iin̰o gay ɔɔ naan̰ tap ɓo tujga ɗi?» ");
INSERT INTO kyq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Gaŋ jee dɛngen tus gɔtn ese se, ul taara gajalaŋ ɔɔ bubm asgarge se lɛ, je booy kɔkŋ mɛtn taarɗe se, naɓo ɔŋ booy ɔk eyo. Maakŋ kul taarɗe ki se, naan̰ ɔl asgarge ɔk ɓaano ute Pɔl maakŋ *ɓee tɔɔgŋ kɛn naaɗe lee toom maak ki se. ");
INSERT INTO kyq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Aan gɔɔ ɓee se lɛ, do ɓee ki raan ɗey se, kɛn Pɔl jaay ook kook se, jee dɛnge se tuurin̰ kaam ara kaam ara. Kɛn asgarge jaay aak bin se, uunin̰ doɗe ki raan; 