﻿USE sofia;
DROP TABLE IF EXISTS sofia.kyf_vpl;
CREATE TABLE kyf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kyf_vpl WRITE;
INSERT INTO kyf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","-Zezu Klisɩɩ dʋkpasɩɩ ŋnɩ nɩ: ɔɔ -Zezu *Klisɩ mɩa, ɔ dʋkpasa -wa *-Davidɩ, 'ɩn *Ablaamʋ mɩa -Davidɩɩ dʋkpasa nya. ");
INSERT INTO kyf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaamʋ gwalɩa Izakɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda gwalɩa Pelɛsɩ -yɔ Zela, nɩɩ, wa 'nyaa -wa Tamaa. ");
INSERT INTO kyf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamʋ gwalɩa Aminadabʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salma gwalɩa -Boazɩ, nɩɩ, ɔ 'nyaa -wa *Wlaabʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","-Zesee gwalɩa nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔɔ gwalɩa Wloboamʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza gwalɩa Zozafatɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziasɩ gwalɩa Yotamʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiasɩ gwalɩa Manasee. ");
INSERT INTO kyf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","-Zoziasɩ gwalɩa Yekonia -yɔ ɔ bhelia. We bhla wa kpaa *Izlaɛlɩnyɩma, 'ɩn wa yia wa Babilɔnʋ kwa. ");
INSERT INTO kyf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","-Mʋʋ 'bɩgʋ, Yekonia gwalɩa Salatiɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolobabɛlɩ gwalɩa Abiudʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ gwalɩa Sadɔkʋ. ");
INSERT INTO kyf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudʋ gwalɩa Eleazaa. ");
INSERT INTO kyf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔbʋ gwalɩa Maliii 'lowli *-Zɛzɛfʋ. Nɩɩ, Malii gwalɩa -Zezu wa laa Klisɩ, -mʋʋ ji -wa -Lagɔɔ -Bhasanyɔ. ");
INSERT INTO kyf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɩɩ, we 'ka Ablaamʋ -gʋ 'bhʋ, we 'ka -Davidɩ ylɩ, dʋkpasɩ -zakpa kugbua lɛ -mnʋa -wa. We 'ka -Davidɩ -gʋ 'bhʋ, we 'ka wa kpakpɩe ylɩ, 'ɩn wa 'ka wa Babilɔnʋ kwa, we nyni dʋkpasɩ -zakpa kugbua lɛ -mnʋa. -Mʋʋ 'bɩgʋ, we 'ka wa Babilɔnʋ -kwakwɩe -gʋ 'bhʋ, we 'ka -Zezu Klisɩɩ gwalɩ bhla nyni, we nyni dʋkpasɩ -zakpa kugbua lɛ -mnʋa. ");
INSERT INTO kyf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nɩɩ, sanɛɛ wa gwalɩa -Zezu Klisɩ. Nɩɩ, ɔ 'nyaa -wa Malii, mɔ -yɔ -Zɛzɛfʋ 'kaa kʋkwalɩ, wa 'nɩ -slɔ ladɩ dabhlo, 'ɩn ɔ yia nʋkpla pla -Lagɔɔ Zuzu 'Pʋpaa 'tɩtɛ nya. ");
INSERT INTO kyf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nɩɩ, -Zɛzɛfʋ mɩa, nyɩmɛ tɩklɩɩ -wa. Ɔ 'nɩ 'yɩbha ɔ 'ka Malii gbʋ dɩlɩ -zejila 'wʋ. We 'dɛɛ 'gbʋ, bhoyi ɔ -yɔ ɔ yi yaa -dɩa zizewiemɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Da ɔ dlɩ mɩa we -gʋ, 'ɩn Jejitapɛɛ 'anzɩ yabhlo yia ɔ -gbɛ yi 'ylaa 'wʋ, 'ɩn we nɛɛ: «-Zɛzɛfʋ, -Davidɩɩ 'yuoyu, -ɩn 'na lʋlʋ dlɩ -nɩ, -ɩn 'ka Malii kwa, nɩɩ, 'yu ɔ yia gwalɩa, -Lagɔɔ Zuzu 'Pʋpaa 'tɩtɛ nya ɔ plaa nʋkpla. ");
INSERT INTO kyf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nɩɩ, nʋkpasuyu ɔ yia gwalɩa, 'ɩn -ɩn 'ka ɔ 'ŋnɩ zʋ -Zezu, 'ɩn ɔ 'ka ɔ nyɩma gbʋnyuu 'wʋsa.» ");
INSERT INTO kyf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","-We Jejitapɛ gbaa ɔ gbʋʋ -falɩpanyɔɔ ŋwɛ nya, we 'ka lɛnʋʋ 'gbʋ, we yi 'saa 'plɩ: ");
INSERT INTO kyf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Nɩɩ, 'yieslɔŋwnɔyu -ɔ 'nɩa nʋkpasu -yi, mɔ yia nʋkpasuyu gwalɩa, 'ɩn wa 'ka ɔ 'ŋnɩ zʋ Emanuɛlɩ.» -Mʋʋ ji -wa nɩɩ, -Lagɔ -yɔ -a 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɔ ganɔa, sa Jejitapɛɛ 'anzɩ gbaa, 'mʋ ɔ nʋa lɛ, 'ɩn ɔ yia Malii ɔ 'dɛɛ -gbɛ bɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɔ -yɔ ɔ 'nɩ -budu 'wʋdɩ, 'ɩn ɔɔ Malii yia ɔ nʋkpasuyu gwalɩ, 'ɩn -Zɛzɛfʋ yia -mɔɔ 'ŋnɩ zʋ -Zezu. ");
INSERT INTO kyf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","-Zezu wa gwalɩa Bɛtɩlɛmʋ, Zudee -dʋdʋ -gʋ, -zugba *Ewlodʋ mɩ nyɩmaa 'wlulapɩlɩnyɔ nya. Tɔʋn, gbʋyilonya 'bhʋa 'ylʋʋ 'wʋsɔlʋda, 'ɩn wa yia *-Zeluzalɛmʋ nyni. ");
INSERT INTO kyf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wa nɛɛ: «'Yu, -ɔ wa gwalɩa, 'ɩn ɔ 'ka *Zuifʋʋ 'wlulapɩlɩ, da ɔ mɩa? Nɩɩ, ɔ -zɛlɩya ka 'wlʋ 'ylʋʋ 'wʋsɔlʋda, 'ɩn -a yia we -yɔyɩ, we 'dɛɛ 'gbʋ, -a yia yi -a 'ka ɔ 'ŋnɩ 'ylimanɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nɩɩ, nyɩmaa 'wlulapɩlɩnyɔ Ewlodʋ 'nʋa we, 'ɩn ɔ plɛ yia sumanɩ, ɔ -yɔ -Zeluzalɛmʋ -nyɩma weee. ");
INSERT INTO kyf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","-Bha ɔ laa *-Lagɔbʋbɔnyaa -cɩan we -yɔ -Lagɔɔ titee gwesanya, 'ɩn da wa 'kaa -Lagɔɔ -Bhasanyɔ gwalɩ, ɔ 'ka we yibheli. ");
INSERT INTO kyf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wa nɛɛ ɔ -ylaɛ: «Nɩɩ, Bɛtɩlɛmʋ, Zudee -dʋdʋ -gʋ, -bha wa gwalɩa ɔ. Nɩɩ, -we *-Lagɔgbʋʋ -falɩpanyɔ cɛlɩa, mʋ nɩ: ");
INSERT INTO kyf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Amɩa, Bɛtɩlɛmʋ, Zudee -dʋdʋ -gʋ -nyɩma, amɩaa 'gbe 'nɩ 'kienyi -mɩ, Zudeegbe 'kadɩ glaa. Nyɩmaa 'Wlulapɩlɩnyɔ yabhlo yia amɩaa -gbɛ 'bhʋa, mɔ 'kaa Izlaɛlɩnyɩma -wa -wa na nyɩma, mɔ 'kaa wa 'yugalɩ.› » ");
INSERT INTO kyf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tɔʋn, 'ɩn Ewlodʋ yia waa gbʋyilonya la zizewiemɩ, 'ɩn ɔ yia wa layɩbha nɩɩ, labhla wa 'yɩ wee -zɛlɩya -yɔa. ");
INSERT INTO kyf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Ɩn ɔ nɛɛ wa -ylaɛ: «A mnɩ, a -talɩ ɔɔ 'yuu da 'nanʋʋ, a -ka ɔ 'yɩ, a yi 'mɩ 'dɩ -salɩa, 'ɩn, -amɩ, ɩn 'ka -mɔ mnɩ, ɩn 'ka ɔ bʋbɔ.» -Bha ɔ tiea wa Bɛtɩlɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Waa gbʋyilonya 'nʋa Ewlodʋ wɛlɩ, 'ɩn wa yia 'yoo bhli. 'Ɩn -zɛlɩya wa 'yɩ yaa 'ylʋʋ 'wʋsɔlʋda, wa yia we -yɔyɩ, 'ɩn we yia wa 'mʋna 'wʋla. Wee -zɛlɩya -galɩ wa 'yu, 'ɩn da ɔɔ 'yu mɩa, we nynia -bha, 'ɩn we yia 'yligbe. ");
INSERT INTO kyf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Da wa plaa -budu zɔ, 'ɩn wa yia 'yu -yɔ ɔ 'nyaa Malii -yɔyɩ. Wa yia ɔɔ 'yu bʋbɔ, ɔ 'yu 'kukolu sibhlie nya. -Mʋʋ 'bɩgʋ, wa yia wa 'gba 'wʋkalɩ, 'ɩn 'ŋnɩmnɩli wa cɛlɩa ɔ, mʋ nɩ: -can klaa, *milɩ klaa, we -yɔ 'wlɩ, 'mʋ wa 'nyɛa ɔ. ");
INSERT INTO kyf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Ylaa 'wʋ, -Lagɔ nɛɛ wa -yla nɩɩ, wa 'na 'plɩlɩ Ewlodʋʋ -gbɛ -nɩ. 'Ɩn wa yia 'yoo -putu 'wʋbhu, 'ɩn wa yia wa -zɔɔ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Waa gbʋyilonya ka mnɩ 'bhie, Jejitapɛɛ 'anzɩ yabhlo yia -Zɛzɛfʋʋ -gbɛ yi 'ylaa 'wʋ, 'ɩn we nɛɛ ɔ -ylaɛ: «Nɩɩ, Ewlodʋ yia ɔɔ 'yuu da -talɩa, ɔ 'ka ɔ 'bha. We 'dɛɛ 'gbʋ, -sɔ 'wʋ, -ɩn 'bhu ɔɔ 'yu -yɔ ɔ 'nyaa 'wʋ, -ɩn -yɔ wa 'sɔ mnɩ Ezipʋtʋ -gwagwɩe nya. -Ɩn -tʋ -mɔ, bhla -we nya a 'kaa yi, -amɩ yia we aɩn -yla gbaa.» ");
INSERT INTO kyf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","-Zɛzɛfʋ -sɔa 'wʋ, 'ɩn ɔ yia 'yu -yɔ ɔ 'nyaa 'wʋbhu. Wa 'bhʋa -bha sabɔ, ");
INSERT INTO kyf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'ɩn wa yia Ezipʋtʋ mnɩ. Wa -dɩ -mɔ la, 'ɩn Ewlodʋ yia tlɩ. 'Sa -mʋʋ 'plɩa sa, 'ɩn -we -Lagɔ gbaa ɔ gbʋʋ -falɩpanyɔɔ ŋwɛ nya, we 'ka gbʋzɔnʋ -zɛ, ɔ nɛɛ: «Ɩn ka na 'yu la, ɔ 'ka Ezipʋtʋ 'bhʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Da Ewlodʋ 'yɩa nɩɩ, gbʋyilonya ka ɔ -dawli 'wʋnʋ, 'ɩn ɔ yia 'cɛ 'pa bhabha. -Bha ɔ tiea nyɩma wa 'ka Bɛtɩlɛmʋ dʋdʋ -gʋ nʋkpasuyua 'bha. -Wa 'nɩa -zʋ 'sɔ ylɩ, we -yɔ -wa kaa -zʋ 'sɔ, -maa wa mnɩa 'bhaa. Nɩɩ, bhla -we nya -zɛlɩya 'wlʋa gbʋyilonya ka ɔ 'dɩ -salɩɩ 'gbʋ ɔ yi 'saa nʋ. ");
INSERT INTO kyf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nɩɩ, -we *-Lagɔgbʋʋ -falɩpanyɔ Zelemi gbaa mʋ nʋa lɛ: ");
INSERT INTO kyf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«-A ka 'wʋkpɩwɛlɩ 'nʋ mɔ Wlamaa, wa mɩ 'wʋkpɩda, wida wa mɩa. *Wlasɛlɩ -wa, ɔ 'yua ɔ mɩa wida, ɔ 'nɩ ŋwnu wa 'ka ɔ bhubhoe, nɩɩ, ɔ 'yua ka tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Da Ewlodʋ tlɩa, -zugba -Zɛzɛfʋ mɩ Ezipʋtʋ, 'ɩn Jejitapɛɛ 'anzɩ yabhlo yia ɔ -gbɛ yi 'ylaa 'wʋ, 'ɩn we nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«-Sɔ 'wʋ, -ɩn 'bhu ɔɔ 'yu -yɔ ɔ 'nyaa 'wʋ, -ɩn -yɔ wa 'sɔ mnɩ *Izlaɛlɩ -dʋdʋ -gʋ. Nɩɩ, -wa 'yɩbhaa wa 'ka ɔɔ yu 'bha, -maa ka tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tɔʋn, -Zɛzɛfʋ -sɔa 'wʋ, 'ɩn ɔ yia ɔɔ 'yu -yɔ ɔ 'nyaa 'wʋbhu, 'ɩn wa yia Izlaɛlɩ -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɔ 'nʋa nɩɩ, Alɩkelausɩ mɩ Zuifʋʋ 'wlulapɩlɩda ɔ dide Ewlodʋʋ 'bɩgʋ, -bha ɔ nʋa nyanɔ ɔ 'ka Zudee mnɩ. Mɔ ɔ 'kaa mnɩ, ɔ 'yɩa -bha 'ylaa 'wʋ, 'ɩn ɔ yia Galilee -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'Ɩn 'gbe -we wa laa Nazalɛtɩ, 'ɩn wa yia -bha ladɩ. Nɩɩ, 'sa we 'plɩa sa, 'ɩn -we -Lagɔgbʋʋ -falɩpanya gbaa we 'ka gbʋzɔnʋ -zɛ. Wa nɛɛ: «'Mɔ wa yia laa Nazalɛtɩyu.» ");
INSERT INTO kyf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","We bhla wa 'yɩa 'Zan *-Batisɩ -yɔ -mɔ da bɛblɛɛ Zudee -dʋdʋ -gʋ. Ɔ 'kpɩa 'wʋ, ");
INSERT INTO kyf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ɔ nɛɛ: «A 'bhiti amɩaa dlɩ, nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe ka cɩpa.» ");
INSERT INTO kyf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","-Lagɔgbʋʋ -falɩpanyɔ *Ezaii nɛɛ zlɩmɛ ɔ daa nɩɩ: «Nyɩmɛ yabhlo 'kpɩa 'wʋ -mɔ da bɛblɛɛ, ɔ nɛɛ: ‹Nɩɩ, a mnazɩ Nyɩmaa -Kanyɔɔ 'yloogblʋ -yɔ. A nʋ 'yoo tɩklɩɩ ɔ 'yu.› » ");
INSERT INTO kyf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nɩɩ, ɔɔ *Zaan mɩa, ɔ 'wʋ -bana mɩ *-nyɔmɛɛ nyanɩ nya, 'ɩn ɔ -cɛsli mɩa nɩmɛɛ ku nya. Lʋʋ 'kpɩ -yɔ -gangan ɔ lia. ");
INSERT INTO kyf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zudee -dʋdʋ -gʋ -nyɩma klaa, -Zeluzalɛmʋ -nyɩma klaa, we -yɔ -wa 'bhʋa Zudɛɛn nyu kwesi, ma yia Zaaan -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gbʋnyuu -we wa nʋa lɛ, 'mʋ wa gbaa -zejila 'wʋ, 'ɩn ɔ batizea wa Zudɛɛn nyu lʋ. ");
INSERT INTO kyf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zaan 'yɩa nɩɩ, *Falizɩnyɩma -yɔ *Sadusenyɩma mɩ ɔ -gbɛ yida, nɩɩ, -maa -zu 'wʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Amɩa mɩa dɛ, 'mʋnɩmɛɛ -gnʋ a -mɩa! Nyɔɔ -salɩ aɩn 'dɩ, 'ɩn a pʋpalɩ 'wlukʋʋn la nɩɩ, a mneni a 'ka -Lagɔɔ 'cɛ -we mɩa yida kwɛɛ 'tlaa? ");
INSERT INTO kyf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A -slolu amɩaa lɛnʋgbʋnya 'wʋ sazɔnʋ sa nɩɩ, a ka amɩaa dlɩ 'bhiti. ");
INSERT INTO kyf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A 'na gbalɩ amɩaa 'dɛ dlɩ zɔ -nɩɛ: ‹Nɩɩ, Ablaamʋ mɩ -amɩaa dʋkpasa nyaa 'gbʋ -a ka gbʋwʋbhʋ.› Nɩɩ, ɩn nɛɛ aɩn -yla, -Lagɔ mneni ɔ 'ka tʋkpanya nɩ, Ablaamʋʋ 'yua -zɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","-Lagɔɔ 'nɛnɔ gbee 'yli -dɩ sunyaa bhʋ -yɔ la pepe. Su weee -we'e 'paa 'bhue -zɔnʋnya nɩ, -dɩa ɔ yia we, ɔ 'ka we -kosu 'wʋ viteli. ");
INSERT INTO kyf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Nyu nya -amɩ na batizea aɩn, 'ɩn wa 'ka we 'jiyibheli nɩɩ, a ka amɩaa dlɩ 'bhiti. Nɩɩ, nyɩmɛ -ɔ yia 'mɩ 'bɩ yia, mɔ yia aɩn batizea Zuzu 'Pʋpa -yɔ -kosu nya. Ɔ 'tɩtɛ -zi na -nʋ, ɩn 'nɩ we 'klʋ -ka ɩn 'ka ɔ -sakwla 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔ ka ɔ bʋtɛ kwɛɛ, ɔ 'ka ɔ 'mnɔ 'wʋpʋ, ɔ 'ka we 'ya -yɔ we vavi -yɔsɩsalɩ. 'Ɩn ɔ 'ka we 'ya -zɔnʋnya -gbagbʋ 'wʋ slu, 'bhie, ɔ 'ka we vavinya -kosu we'e nyumoa 'wʋ viteli.» ");
INSERT INTO kyf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","-Zezu 'bhʋa Galilee -dʋdʋ -gʋ, 'ɩn ɔ yia Zudɛɛn nyu -yɔ mnɩ. Ɔ nynia -mɔ, 'ɩn ɔ yia Zaan kwesi bɛ, -mɔɔ 'ka ɔ batizee 'nyu nyaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zaan 'nɩ we ŋwnu, ɔ nɛɛ: «-Ɩnnya, we 'nɩ 'sa -mɩ. -Mɩ 'ka 'yaa 'mɩ batizee 'nyu nya, 'ɩn -ɩn yia yi, ɩn 'ka -mɩ 'nyu nya batizee yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","-Zezu nɛɛ: «Nɩɩ, we mɩ -Lagɔ 'yu tɩklɩɩɩ 'gbʋ, -a nʋ we lɛ.» -Bha Zaan ŋwnua we -yɔ, 'ɩn ɔ yia we lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zaan batizea -Zezu 'nyu nya, -Zezu mɩ 'nyu lʋ 'tlada, 'ɩn ɔ yia -Lagɔɔ 'gbe -yɔyɩ ŋwɛ -kalɩda. 'Ɩn ɔ yia -Lagɔɔ Zuzu, -ɔ 'wlʋa -kpakʋn, -yɔyɩ kwlida, 'ɩn -mɔɔ yia ɔ -gʋ lasibhli. ");
INSERT INTO kyf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Ɩn wa yia wɛlɩ yabhlo, -we 'bhʋa -Lagɔɔ -gbɛ 'nʋ, we nɛɛ: «Na 'Yu ɔ -mɩa, ɩn -kalɩ ɔ zɛ, 'mɔ ɩn 'nyɛa na dlɩ weee yoo.» ");
INSERT INTO kyf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tɔʋn, 'ɩn -Lagɔɔ Zuzu yia -Zezu da bɛblɛɛ kwa, *'Kuzu 'ka ɔ laylaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ɔ mɩa -mɔ da bɛblɛɛ, ɔ li -mɔ zlɩ glʋ 'sɔ, sabɔ glʋ 'sɔ, -zugba ɔ tɩ lililu, 'ɩn ŋwɔ yia ɔ -yɔkpa. ");
INSERT INTO kyf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","*Laylanyɔ bɛa ɔ kwesi, 'ɩn we nɛɛ ɔ -ylaɛ: «-Ɩn -ka -Lagɔɔ 'Yu nya -mɩ 'piɛɩn, -ɩn gba tʋkpanya nɩ -yla nɩɩ, we -zɛ 'floo.» ");
INSERT INTO kyf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Ɩn ɔ nɛɛ: «We mɩ cɛlɩda *-Lagɔsɛbhɛ 'wʋɛ: ‹We 'nɩ lililu -bhlogbɔɔ -gʋ nyɩmɛɛ 'yliyɔgagɩe tlili, nɩɩ, wɛlɩ -we -Lagɔ gbaa, 'ɩn we nyɛ 'yaa ɔ 'yliyɔgagɩe.› » ");
INSERT INTO kyf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tɔʋn, 'ɩn 'Kuzu yia ɔ -mɔwlʋ -gbe -Zeluzalɛmʋ 'wʋkwa. We dɩa ɔ *-Lagɔbudu 'kadʋ 'wlu la, ");
INSERT INTO kyf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'ɩn we nɛɛ: «-Ɩn -ka -Lagɔɔ 'Yu nya -mɩ 'piɛɩn, -blu 'wʋ -ɩn 'ka lasibhli, nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-Lagɔ yia ɔ 'anzɩnya tiea -na 'gbʋ, 'ɩn we 'ka we sɔnya -mɩ zɔ laslʋlʋ, -na bhʋ yi tʋkpa gozoo 'gbʋ.› » ");
INSERT INTO kyf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Ɩn ɔ nɛɛ: «We mɩ 'ya cɛlɩda -Lagɔsɛbhɛ 'wʋ: ‹Nɩɩ, Jejitapɛ, -ɔ -wa -na -Lagɔ, a 'na ylalɩ ɔ la -nɩ.› » ");
INSERT INTO kyf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","-Bha 'Kuzu kwa 'yaa ɔ 'wʋpa -gɔgɔ 'kadʋ 'wlu. 'Ɩn we yia dʋdʋʋ 'ŋnɩmnɩ -da weee -yɔ we 'ŋnɩmnɩli -yɔ we 'tɩtɛ ɔ 'klʋslolu. ");
INSERT INTO kyf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'Ɩn we nɛɛ: «-Ɩn -ka 'mɩ 'yu 'kukolu 'sibhli, 'ɩn -ɩn -ka 'mɩ bʋbɔ, nɩɩ, -we weee mɩa da, 'ɩn na nyɛa -mɩ we.» ");
INSERT INTO kyf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Ɩn ɔ nɛɛ we -ylaɛ: «Bɛ lʋ, 'Kuzu! We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-Ɩn bʋbɔ Jejitapɛ, -ɔ -wa -na -Lagɔ, 'ɩn -ɩn nʋ ɔ 'dɛbhlogbɔɔ -yla lubho.› » ");
INSERT INTO kyf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Kuzu 'bhʋa ɔ kwesi tɔʋn, 'ɩn 'anzɩnya yia ɔ 'wʋsa. ");
INSERT INTO kyf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","-Mʋʋ 'bɩgʋ, -Zezu 'nʋa nɩɩ, wa ka Zaan -kaslʋ 'wʋpa, 'ɩn ɔ yia Galilee mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɔ 'nɩ Nazalɛtɩ -tʋ, Kapɛnaumʋ ɔ -dɩa la. Nɩɩ, Kapɛnaumʋgbe mɩa Galilenyu kwesi, -we mɩa -mɔ Zabulɔn -yɔ Nɛfʋtalii -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'Mʋ ɔ nʋa lɛ, 'ɩn -we -Lagɔgbʋʋ -falɩpanyɔ Ezaii gbaa, we 'ka gbʋzɔnʋ -zɛ, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulɔn -yɔ Nɛfʋtali -nyɩma, nyɩma -wa mɩ 'nyuu -yɔ 'yloogblʋ, -mɔ Zudɛɛn nyuu kakpe yabhlo lʋ, Galilee da 'lakpanya mɩ! ");
INSERT INTO kyf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nyɩma -wa mɩa nikpise 'wʋ, zlɩ wa yia 'yɩa! -Wa mɩa tlɩtlɩee zuzu 'wʋ, zlɩ yia wa -gbɛ 'tlaa.» ");
INSERT INTO kyf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","-Bha -bhlokpadɛ, 'ɩn ɔ yia -Lagɔgbʋ gbagbɩe bhli, ɔ nɛɛ: «A 'bhiti amɩaa dlɩ, nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe ka cɩpa.» ");
INSERT INTO kyf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","'Ylɩ yabhlo nya, -Zezu mɩ Galilenyu kwesi nɔda, 'ɩn ɔ yia bhelia 'sɔ -yɔyɩ, 'Simɔɔ (-mɔɔ -baŋnɩ -wa Piɛlɩ), we -yɔ ɔ bheli Andlee. Wa mɩ wa 'sowli 'nyu lʋ vitelida, nɩɩ, zibhibhanya wa -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɔ nɛɛ wa -yla: «A yi 'mɩ 'bɩ, sa a kpaa zibhi, ɩn 'ka 'sa aɩn nyɩmaa 'ylibɩlanɔnʋnya -zɛlɩ, 'ɩn a 'ka 'mɩ wa 'bɩ -la.» ");
INSERT INTO kyf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tɔʋn, wa tɩa -bha wa 'sowli, 'ɩn wa yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɔ bɛa 'yu -sɛ, 'ɩn ɔ yia *'Zake -yɔ ɔ bheli *Zaan 'yɩ, nɩɩ, Zebedee 'yua -wa. Wa -yɔ wa dide mɩ wa 'sowli mnazɩda -mɔ 'glʋ 'wʋ, 'ɩn -Zezu yia wa la, ");
INSERT INTO kyf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'ɩn wa yia wa dide -yɔ ɔ 'glʋ -bha tɩ, 'ɩn wa yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","We bhla -Zezu 'plɩlɩa Galilee -dʋdʋ weee -gʋ, -zugba ɔ slolua nyɩma gbʋ *-Lagɔbudunya zɔ, 'ɩn ɔ gbaa *-Lagɔɔ nyɩmaa 'wlulapɩlɩe -zɔnʋʋ gbʋ, gu weee -yɔ sɩasɩe weee, -we mɩa nyɩma -yɔ jipejipɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","-Bha wa 'nʋa -Zezuu 'dɩ Silii -dʋdʋ weee -gʋ. Nɩɩ, -wa mɩa sɩada weee, -wa kaa gu -yɔ klaa, -wa ka ku glopoa klaa, -wa zuzu 'nyuu mɩa 'wʋ klaa, -wa kaa nɛʋn gu -yɔ klaa, we -yɔ zɔlaslonya, 'ma wa -laa -Zezu, 'ɩn ɔ yia wa jipe. ");
INSERT INTO kyf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'Ɩn nyɩmaa -zlo yia -Zezu 'bɩ yi. Tɔlʋa 'bhʋa Galilee, tɔlʋa 'bhʋa 'Gbe Kugbua -dʋdʋ -gʋ, tɔlʋa 'bhʋa -Zeluzalɛmʋ, tɔlʋa 'bhʋa Zudee -dʋdʋ -yɔ Zudɛɛɛn kakpe yabhlo -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Da -Zezu 'yɩa nyɩmaa -zlo -yɔ, ɔ -gblaa -gɔgɔ yabhlo 'wlu, 'ɩn ɔ yia -mɔ ladɩ. Ɔ 'bɩnɔnya gbelia ɔ, ");
INSERT INTO kyf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'ɩn ɔ yia wa slolue bhli, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nyɩma -wa'a laa wa 'dɛ nyɩma -Lagɔ 'yu, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ pɩlɩ wa 'wlu la. ");
INSERT INTO kyf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","-Wa mɩa wida, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ yia wa 'kʋayli 'paa. ");
INSERT INTO kyf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nyɩma -wa mɩa sa bhe, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, ma yia dʋdʋ 'wʋbhua 'bɩ -liliee saa. ");
INSERT INTO kyf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nyɩma -wa nyɩma tɩklɩɩ -zɛzɛ tʋ mɩa 'bhada ŋwɔ 'bhisa, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, lʋa wa yia. ");
INSERT INTO kyf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nyɩma -wa yɩlɩa wa -lima nyazɩ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ yia wa nyazɩ 'yɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nyɩma -wa ka dlɩ mɩa tɩklɩɩ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ wa yia 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nyɩma -wa bɩbɛlɩa nyɩma -yɔ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ yia wa laa ɔ 'yua. ");
INSERT INTO kyf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nyɩma -wa wa palɩa 'klɩyɩe 'wʋ, wa mɩ nyɩma tɩklɩɩ nyaa 'gbʋ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya, -we ka gbʋ -wa, -Lagɔ pɩlɩ wa 'wlu la. ");
INSERT INTO kyf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Nɩɩ, wa -ka amɩaa 'ŋnɩ -nyumɔ, wa -ka aɩn 'klɩyɩe 'wʋpalɩ, wa -ka aɩn yoyo gbʋ -gʋ la zʋlʋ na 'gbʋ, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","A li 'mʋna sa duun, -we ka gbʋ -wa, -tnʋʋ 'kadɩ a yia 'yɩa -Lagɔɔ -gbɛ. Nɩɩ, 'sa -bhlokpadɛ wa 'palɩa -Lagɔgbʋʋ -falɩpanya, -wa -galɩa aɩn 'yu, 'klɩyɩe 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Nɩɩ, amɩa, dʋdʋgʋ -nyɩmaa gumu 'bhisa a mɩa. Nɩɩ, gumu -ka 'nʋŋwɛ 'bhʋ, sa wa 'ka we namanɩa? We 'nɩ 'maslɛɛn -lu yabhlogbɔɔ 'wʋkʋ. Nɩɩ, 'pipee wa vitelia we, 'ɩn nyɩma nɔa we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Nɩɩ, amɩa, dʋdʋgʋ -nyɩmaa zlɩ 'bhisa a mɩa. 'Gbe wa zʋa -gɔgɔ 'wlu, wa 'nɩ mneni wa 'ka we zize. ");
INSERT INTO kyf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Ɩn wa -yɔ 'napɛ -ka yi, wa'a dɩ we -solu zɔ la. Yalɩ wa dɩa we la, 'ɩn we yɩa nyɩma weee -gʋ la, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Sa -bhlokpadɛ, amɩaa zlɩ 'kaa nyɩma 'yu lɩ, 'ɩn wa 'ka amɩaa lɛnʋgbʋ -zɔnʋ -yɔyɩ, 'ɩn wa 'ka amɩaa Dide -ɔ mɩa yalɩɩ 'ŋnɩ -mnɩnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«A 'na pʋpalɩ dlɩ zɔ la -nɩ, nɩɩ, *Moizɩɩ tite -yɔ -Lagɔgbʋʋ -falɩpanyaa wɛlɩ ɩn yia lasaa -nɩ. Ɩn 'nɩ we lasasɩee 'gbʋ yi. Yi ɩn yia, 'ɩn we 'ka gbʋzɔnʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","«Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, dʋdʋ -yɔ yalɩ 'nɩ -slɔ labhʋ, -Lagɔɔ titee cɛlɩlɩɩ 'ya 'kienyi -lɛ 'na 'ka labhʋ, 'ɩn dʋdʋ 'kaa bhɩa. ");
INSERT INTO kyf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","We 'dɛɛ 'gbʋ, nyɩmɛ -ɔ mɩa 'kienyi -lɛ, -wa -Lagɔ pɩlɩa 'wlu la glaa, mɔ -wa nyɩmɛ -ɔ'ɔ zʋa -Lagɔɔ tite 'kienyi -lɛ 'nʋŋwɛ, 'ɩn ɔ slolua ɔ -lima sa wa'a zʋa we 'nʋŋwɛ. Nɩɩ, -ɔ slolua ɔ -lima -Lagɔɔ tite 'nʋŋwɛzʋzʋe, mɔ -wa kpasa, nyɩma -wa -Lagɔ pɩlɩa 'wlu la glaa. ");
INSERT INTO kyf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ɩn nɛɛ aɩn -yla: a zʋ -Lagɔɔ tite 'nʋŋwɛ. A -zi -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, we 'nɩ -mʋʋʋ, nyɩma -wa -Lagɔ pɩlɩa 'wlu la, a 'na 'ka wa glaa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«A ka 'nʋ nɩɩ, wa nɛɛ amɩaa dʋkpasɩ -ylaɛ: ‹A 'na 'bhalɩ nyɩmɛ -nɩ. Nɩɩ, -ɔ ka ɔ bheli 'bha, gbʋwʋbhunya 'yu wa yia ɔ kwaa.› ");
INSERT INTO kyf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nɩɩ, ɩn nɛɛ aɩn -ylaɛ: -ɔ -ka ɔ bheli -yɔ 'cɛpalɩ, gbʋwʋbhunya 'yu wa kwaa ɔ. -Ɔ -ka gba ɔ bheli -yla, -mɔɔ mɩ nyɩmɛ -kpʋa nya, nyɩma kpasɩ 'yu wa kwaa ɔ, 'ɩn wa bhua ɔ -yɔgbʋ 'wʋ. -Ɔ -ka ɔ bheli -yla gba: ‹Nyɔgʋgʋ›, ɔ ka we 'klʋ wa 'ka ɔ -kosu -we'e nyumoa 'wʋ kwa. ");
INSERT INTO kyf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","We -ka nɩɩ, -na wlawlalu -ɩn mɩ -Lagɔ kwada 'slakagʋsalɩlu 'yu, 'ɩn -ɩn yi ligbe nɩɩ, -ɩn -yɔ -na bheli 'sɔ ka gbʋ, ");
INSERT INTO kyf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","-ɩn tɩ -bha wee wlawlalu 'slakagʋsalɩlu 'yu, -ɩn mnɩ, -ɩn -yɔ -na bheli 'ka gbʋ -bhɩa, 'bhie, -ɩn 'ka wee wlawlalu -Lagɔ -la. ");
INSERT INTO kyf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Nɩɩ, nyɩmɛ -ka -mɩ gbʋ 'wluladɩlɩ, 'ɩn -ɩn -yɔ ɔ 'sɔ 'ka gbʋwʋbhunya 'yu mnɩda -mɩ, -ɩn -yɔ ɔ 'sɔ -bhɩa gbʋ slʋɩ, da a mɩa -slɔ 'yloogblʋ. Nɩɩ, we 'nɩ -mʋʋ, 'ɩn ɔ kwaa -mɩ gbʋwʋbhunya 'yu, 'ɩn gbʋwʋbhunya nyɛa -mɩ 'slʋja yoo, 'ɩn wa paa -mɩ -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa: -ɩn 'nɩ -slɔ ɔ tama 'wʋbhlolu -nʋ wla, -ɩn 'na 'ka -mɔ 'tla. ");
INSERT INTO kyf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«A ka 'nʋ nɩɩ, wa nɛɛ: ‹-Ɩn -yɔ 'ŋwnɔ -putu 'na -dɩlɩ -budu 'wʋ -nɩ›. ");
INSERT INTO kyf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nɩɩ, -amɩ, ɩn nɛɛ aɩn -yla: nyɩmɛ -ka ɔ -libheyii 'ŋwnɔ yla, 'ɩn ɔ -budu 'wʋdɩ tʋ -ka ɔ 'bha, ɔ -yɔ ɔ ka -budu 'wʋdɩ ɔ dlɩ zɔ. ");
INSERT INTO kyf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","«We -ka nɩɩ, -na lilikwɛ -yliya kwa -mɩ gbʋnyuu lʋ, -sa -bha we, viteli we 'pɩpɩ. We nanɩ 'yli -ɩn 'ka -na kuu kibhe mnɔnʋ, we -zi wa 'ka -na ku weee viteli -kosu -we'e nyumoa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We -ka nɩɩ, -na lilikwɛ -sɔ kwa -mɩ gbʋnyuu lʋ, dɩ -bha we, viteli we 'pɩpɩ. We nanɩ 'yli -ɩn 'ka -na 'lali yabhlo mnɔnʋ, we -zi -ɩn 'ka -kosu -we'e nyumoa 'wʋpla -na -kpabhie nya. ");
INSERT INTO kyf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Wa nɛɛ 'ya aɩn -ylaɛ: ‹Nyɩmɛ -ɔ -ka ɔ 'ŋwnɔ 'kwnɛ -sa, ɔ 'nyɛ ɔ 'kwnɛ -sa -sɛbhɛ yoo.› ");
INSERT INTO kyf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Ɩn -amɩ, ɩn nɛɛ aɩn -ylaɛ: nyɩmɛ 'nɩ mneni ɔ 'ka ɔ 'ŋwnɔ 'kwnɛ -sa, 'mʋ we 'nɩ ɔ mʋtnɩ kwɛ -kakɩe 'wʋbhʋ. Nɩɩ, nyɩmɛ -ka ɔ 'ŋwnɔ 'kwnɛ -sa, ɔ gbʋnyuu lʋ -sulue -wa, -we ka gbʋ -wa, nʋkpasu -putu ɔ yia kwaa. 'Ɩn nyɩmɛ -mɔmɔ -ka 'kwnɛ -sa ŋwnɔ kwa, gbʋnyuu ɔ nʋa lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«A ka 'nʋ nɩɩ, wa nɛɛ amɩaa dʋkpasɩ -ylaɛ: ‹-Ɩn 'na bili yoyo sa -nɩ. -We -ɩn bia -Lagɔ 'yu, -ɩn nʋ we lɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nɩɩ, -amɩ, ɩn nɛɛ aɩn -ylaɛ: a 'na bili 'mnumnu -nɩ. A 'na bili yalɩ -nɩ, nɩɩ, mʋ -wa -Lagɔɔ 'ŋnɩmnɩkpe. ");
INSERT INTO kyf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A 'na bili dʋdʋ -nɩ, mʋ -gʋ ɔ dɩa bhʋ la. A 'na bili -Zeluzalɛmʋ -nɩ, nɩɩ, mʋ -wa -Lagɔnyɩma weee 'wlulapɩlɩnyɔɔ gbe. ");
INSERT INTO kyf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","-Ɩn 'na bili -na 'wlu -nɩ, nɩɩ, -ɩn 'nɩ mneni -ɩn 'ka -na 'wluo nyi -bhlogbɔɔ 'bhiti, we 'ka 'pʋpa -zɛ, we 'ka 'ylukpa -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","We -ka ‹ɩɩn›, a gba ‹ɩɩn›, we -ka ‹-ɩnnya›, a gba ‹-ɩnnya›. -We -na yia we 'bɩgʋ zʋa, gbʋnyuuu didee -gbɛ we bhʋa. ");
INSERT INTO kyf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«A ka 'nʋ nɩɩ, wa nɛɛ: ‹'Ylii 'lɛɛji -wa yli, 'ɩn glaa 'lɛɛji -wa gla.› ");
INSERT INTO kyf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nɩɩ, -amɩ nɛɛ aɩn -yla: -ɔ nʋa -mɩ -yla gbʋ lɛ, -ɩn 'na nʋnʋ we 'lɛɛji lɛ -nɩ. Nɩɩ, nyɩmɛ -ka -na lilikwɛ -yukwli 'kpa 'wʋsʋbha, -ɩn 'bhiti we -gʋdʋ, ɔ 'ka -bha yabhlo 'pa. ");
INSERT INTO kyf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nyɩmɛ -ka -mɩ gbʋwʋbhunya 'yu kwa, ɔ 'ka -na -bana 'wʋbhu, 'nyɛ ɔ 'yoo, ɔ 'ka -na -gʋslunaa 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","-Laide -ka -mɩ 'gba 'wludɩ -ɩn 'ka kilo -bhlo lɛnʋ, -ɩn nʋ kilo 'sɔ lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nyɩmɛ -ka -mɩ -lu -zlalɩ, 'nyɛ we ɔ. Nyɩmɛ -ka -na -lu -bhoa yi, -ɩn 'na palɩ ɔ -blɩgʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«A ka 'nʋ nɩɩ: ‹-Ɩn -kalɩ -na -libheyii zɛ, 'ɩn -na tʋnyɩmɛ mɩa, -ɩn 'ka -mɔɔ 'wʋnyɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nɩɩ, -amɩ, ɩn nɛɛ aɩn -yla: a -kalɩ amɩaa tʋnyɩmaa zɛ, 'ɩn -wa palɩa aɩn 'klɩyɩe 'wʋ, a bhubhoe -Lagɔ wa 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Bhie, a 'ka amɩaa Dide, -ɔ mɩa yalɩɩ 'yua -zɛ. Nɩɩ, -Lagɔ sɔlʋa ɔ 'ylʋ 'wʋ nyɩma -zɔnʋ -yɔ nyɩma 'nyii -gʋ, 'ɩn -wa nʋa gbʋzɔnʋ lɛ, we -yɔ -wa nʋa gbʋnyuu lɛ, 'ɩn ɔ lʋalɩa wa -gʋ 'nyu. ");
INSERT INTO kyf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","«-Wa -kalɩa amɩaa zɛ, we -ka -maa -bhloo 'dɛɛ zɛ a -kalɩ, a 'nɩ -lu yabhlogbɔɔ 'klʋ -ka -Lagɔ 'yu. Nɩɩ, *nisʋn -gwɛzisanyaa 'dɛbhie -gbolu, 'sa -bhlokpadɛ wa nʋa. ");
INSERT INTO kyf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A -ka amɩaa bheliaa 'dɛkpʋa fʋsa nɩ, gbʋ 'kadʋ a nʋa -bha lɛ yɩ? Nɩɩ, -wa 'nɩa -Lagɔ -yi, 'sa -bhlokpadɛ wa nʋa, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","We 'dɛɛ 'gbʋ, amɩa, a -mɩ tɩklɩɩ sa amɩaa Dide -ɔ mɩa yalɩ mɩa tɩklɩɩɩ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«A zʋ amɩaa 'dɛ 'yliyɔ, a 'na nʋnʋ amɩaa -Lagɔgbʋ lɛ -zejila 'wʋ, nyɩma 'ka aɩn 'ylaa 'gbʋ -nɩ. A -ka 'sa we nʋ, a 'na 'ka -tnʋʋ 'yɩ amɩaa Dide -ɔ mɩa yalɩ kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«-Ɩn -ka 'gwɛzi bobabhanya 'nyɛ, -ɩn 'na bhlɩlɩ we lɛglɛ nya -nɩ. Nɩɩ, 'sa wɛlɩ 'sɔ -nyɩma nʋa -mɔ -Lagɔbudunya zɔ, we -yɔ 'yloogblʋ, wa 'ka wa 'ŋnɩ -zɔnʋ gbaa 'gbʋ. Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: wa ka wa -tnʋʋ 'yɩ 'gamʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nɩɩ, -mɩ, -ɩn -ka -na 'gwɛzi bobabhanya 'nyɛ -na lilisɔ nya, -na kɔpɛsɔ 'na yibheli we 'ji -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sa -ɩn wlaa -lu zizeda, -na Dide -Lagɔ, -ɔ yɩa we -yɔ, mɔ kwɛɛ -na yia -na -tnʋʋ 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«A -ka -Lagɔ bhubhoeda -mɩ, a 'na nʋnʋ wɛlɩ 'sɔ -nyɩma 'bhisa -nɩ. Nɩɩ, wamɩa, wa 'yɩbha wa 'ka 'yligbe, 'ɩn wa 'ka -Lagɔ bhubhoe -Lagɔbudunya zɔ -yɔ 'yoo 'wʋgbelida. 'Mʋ wa nʋa lɛ, 'ɩn nyɩma weee 'ka wa -yɔyɩ. Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: wa ka wa -tnʋʋ 'yɩ 'gamʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nɩɩ, -mɩ, -ɩn -ka -Lagɔ bhubhoea yi, -ɩn pla -na -budu zɔ, -ɩn kla we, 'ɩn -ɩn bhubhoe -na Dide da wa'a 'yɩa -mɩ -yɔ. -Ɩn -ka 'sa nʋ, -na Dide -ɔ yɩa -mɩ -yɔ zizeda, mɔ yia -na -tnʋʋ wlaa. ");
INSERT INTO kyf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«A -ka -Lagɔ bhubhoeda -mɩ, a 'na mnanɩ ŋwɛ la -nɩ, nɛɛ -wa 'nɩa -Lagɔ -yi. We mɩ wamɩaa dlɩ zɔ nɩɩ, wa gbagbawɛlɩ duuun 'gbʋ -Lagɔ pʋlʋa wa yukwli. ");
INSERT INTO kyf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A 'na nʋnʋ wa 'bhisa -nɩ. Nɩɩ, a 'nɩ -slɔ ɔ -lu -zlalɩ, ɔ -yi amɩaa -yɔkpagbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Sa a 'kaa -Lagɔ bhubhoe mʋ nɩ: ‹-Amɩaa Dide -ɔ mɩ yalɩ, wa zʋ -bha -na -mɔwlʋ ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","-Na nyɩmaa 'wlulapɩlɩe yi. Nyɩma nʋ -na dʋmagbʋ lɛ dʋdʋ -gʋ, sa we mɩa yalɩ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'Nyɛ -zɛɛn nʋʋ lililu -aɩn. ");
INSERT INTO kyf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","-Wa nʋa -aɩn gbʋnyuu 'wluo, sa -a tɩa wa -yɔgbʋ 'wʋ, -ɩn tɩ 'sa -amɩaa -yɔgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","-Ɩn 'na kwalɩ -aɩn laylagbʋ lʋ -nɩ. -Ɩn -sa -aɩn gbʋnyuuu dide kwɛɛ.› Nɩɩ, nyɩmaa 'wlulapɩlɩe klaa, 'tɩtɛ klaa, we -yɔ 'ŋnɩmnɩe, we -mɩ -na -nʋ nya, bhla weee nya. *-Amɛnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nɩɩ, amɩaa -lima -wa nʋa aɩn -yla gbʋnyuu lɛ, a -ka we 'wʋtɩ, amɩaa Dide -ɔ mɩa yalɩ, 'ɩn ɔ tɩa amɩaa -yɔgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Ɩn a 'nɩ wa -yɔgbʋ 'wʋtɩ nɩ, amɩaa Dide -ɔ mɩa yalɩ, ɔ 'na 'ka amɩaa -yɔgbʋ 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«A -ka 'sun 'wʋ -mɩ, a 'na 'sulu 'klʋ wɛlɩ 'sɔ -cɩan 'bhisa -nɩ. 'Ɩn wa nʋa wa 'klʋ 'fuakaa, 'ɩn nyɩma weee 'ka we 'jiyibheli nɩɩ, wa mɩ 'sun 'wʋ. Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: wa ka wa -tnʋʋ 'yɩ 'gamʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nɩɩ, -mɩ, -ɩn -ka 'sun 'wʋ -mɩ, budo 'klʋ -yɔ, 'fla -na 'nyi, ");
INSERT INTO kyf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nyɩma yi we 'jiyibheli nɩɩ, -ɩn mɩ 'sun 'wʋ. -Na Dide, -ɔ wa'a 'yɩa -yɔ, -mɔ -bhlogbɔɔ yia we 'jiyibhelia. -We -ɩn nʋa zizeda lɛ, -na Dide, -ɔ yɩa we -yɔ, mɔ yia -na -tnʋʋ wlaa. ");
INSERT INTO kyf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«'Ŋnɩmnɩlu -we mɩa dʋdʋ -gʋ, da 'glɩ -yɔ ŋwɔnʋ nyumɔa we, 'ɩn 'wienya wlaa -budu, 'ɩn wa ylia we, a 'na dɩlɩ we -zlo dʋdʋ -gʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nɩɩ, a dɩlɩ 'ŋnɩmnɩlu -Lagɔɔ -gbɛ la, da 'glɩ -yɔ ŋwɔnʋ 'na 'kaa we -nyumɔ, 'ɩn 'wienya 'na 'kaa we yli. ");
INSERT INTO kyf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nɩɩ, mɔ -na 'ŋnɩmnɩli mɩa, -mɔ -na dlɩ mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«'Yli mɩ kuu 'napɛ nya. -Na 'yli -ka -yalɩ, -na ku weee mɩ zlɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nɩɩ, -na 'yli -ka gu -yɔ -ka, -na ku weee mɩ nikpise 'wʋ. -We mɩa -na zlɩ nya, we -ka nikpise 'bhisa -mɩ, -zugba nikpise -dlugba -wa. ");
INSERT INTO kyf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nyɩmɛ 'nɩ mneni ɔ 'ka -cɩan 'sɔ -yla lubho nʋ. We -ka 'sa -mɩ, 'yabhlo ɔ yia 'wʋnyɛa, 'ɩn ɔ 'ka 'yabhloo zɛkalɩ. 'Yabhlo -yɔ ɔ yia lanɛa, 'ɩn 'yabhlo 'ka ɔ dʋdʋnyumanɩ. A 'nɩ mneni a 'ka -Lagɔ -yɔ 'gwɛzi -yla lubho nʋ dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«We 'dɛɛ 'gbʋ, ɩn nɛɛ aɩn -yla: a 'na lʋlʋ dlɩ amɩaa 'yliyɔgagɩe -yɔ amɩaa kuu 'gbʋ -nɩ. A 'na gbalɩ amɩaa dlɩ zɔ -nɩɛ: ‹Lɛɛ -lu -a 'ka lia? Lɛɛ -lu -a 'ka 'maa? -A yi 'naa 'yɩ -a 'ka 'wʋplaa?› Nɩɩ, amɩaa 'yliyɔgagɩe -zi lililu, 'ɩn amɩaa ku -zi 'naa, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nɩɩ, zia mɩa, we'e 'pa 'mnɔ, we'e -dɩ we, 'ɩn we'e bʋblʋ we -zlo -gbagbʋ 'wʋ. Nɩɩ, amɩaa Dide -ɔ mɩa yalɩ, mɔ nyɛa we lililu. Nɩɩ, amɩa, a 'yli a -zi 'zia, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka ɔ 'yliyɔgagɩee 'ylɩ -gʋ palɩ ɔ dlɩlʋlʋe nya. ");
INSERT INTO kyf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Lɛɛ -lu ka 'gbʋ a lʋ dlɩ 'naa 'gbʋa? -Fliisuu -bʋɩ mɩa, a dɩ we dlɩ 'wʋ nɩɩ, we'e nʋ lubho, 'ɩn we'e lʋa 'naa. ");
INSERT INTO kyf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nɩɩ, ɩn nɛɛ aɩn -yla: *Salomɔɔɔ 'dɛɛ 'ŋnɩmnɩe 'kadʋ 'wʋ, ɔ 'nɩ 'ylinanɔ -bana -bhlogbɔɔ 'yɩ suu -bʋɩnya nɩɩ 'yabhlo 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Su -we mɩa -zɛɛn kpaa, 'ɩn wa 'kaa -kosu 'wʋ viteli cɩzɩ, we -ka nɩɩ, -Lagɔ ka we -bana -zɔnʋ 'nyɛ, -zugba -bana ɔ yia aɩn 'nyɛa, dlɩ 'kienyi -zʋnya! ");
INSERT INTO kyf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A 'na 'yɩbhalɩ amɩaa 'dɛ la dlɩ -lʋlʋe nya -nɩɛ: ‹Lɛɛ -lu -a 'ka lia? Lɛɛ -lu -a 'ka 'maa? -A yi -bana 'yɩ -a 'ka 'wʋpla -bhaa?› ");
INSERT INTO kyf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","-Lu weee mɩa da, -wa talɩa we da, 'ylɩ weee nya, nyɩma -wa 'nɩa -Lagɔ -yi, ma -wa. Amɩaa Dide -ɔ mɩa yalɩ, ɔ -yi we 'ji nɩɩ, -we mɩa dɛ, mʋ -wa amɩaa -yɔkpagbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tɩada, a 'tide -Lagɔ 'yi, ɔ 'ka aɩn 'wlulapɩlɩ, 'ɩn a 'ka gbʋ tɩklɩɩ lɛnʋ. We 'bɩgʋ, -Lagɔ 'ka aɩn -lu weee -mɩnɩ 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nɩɩ, a 'na lʋlʋ dlɩ cɩzɩ gbʋʋ 'gbʋ -nɩ. Nɩɩ, cɩzɩ 'bhie, a 'ka cɩzɩ nʋʋ gbʋ 'wʋpla. Nɩɩ, -zɛɛn nʋʋ sɩasɩe mɩa, we -tʋ 'sa, a 'na palɩ we 'ylɩ -putuu -nʋ -gʋ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«A 'na 'bhulu nyɩmaa -yɔgbʋ 'wʋ -nɩ, -Lagɔ yi amɩaa -yɔgbʋ 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nɩɩ, sa a bhua nyɩmaa -yɔgbʋ 'wʋ, 'sa -Lagɔ yia amɩaa -yɔgbʋ 'wʋbhua. -We a bhua 'wʋ, 'ɩn a yɩbhɔlʋa nyɩma, 'mʋ -Lagɔ yia 'wʋbhua ɔ 'ka aɩn yɩbhɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Bʋɛɛ gɔ -lɛ mɩa -na bhelii 'yliya 'wʋ, 'mʋ -na yɩa -yɔ, 'ɩn su -kibhe 'kadʋ -we mɩa -na 'yliya 'wʋ, -ɩ'ɩn 'yɩ we -yɔ. Lɛɛ -lu ka 'gbʋa? ");
INSERT INTO kyf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Su -kibhe 'kadʋ mɩ -na 'yliya 'wʋ, 'ɩn -ɩn nɛɛ -na bheli -yla: ‹Ŋwnu, ɩn 'ka -mɩ bʋɛɛ gɔ 'yliya 'wʋsaa?› We 'nɩ 'ylinanɩ. We 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɛlɩ 'sɔ -nyɩmɛ, -ɩn -sa -slɔ -na 'dɛ su -kibhe 'kadʋ 'yliya 'wʋ, -ɩn 'ka layɩ 'bhie, -ɩn 'ka bʋɛɛ gɔ -na bhelii 'yliya 'wʋsa. ");
INSERT INTO kyf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«A 'na 'nyɛnɩ -Lagɔɔ -lu gwɩ yoo -nɩ, we 'nɩ -mʋʋ, 'ɩn we bhitia la, 'ɩn we mua aɩn. A 'na viteli amɩaa -can gbʋa -bobo zɔ -nɩ, we 'nɩ -mʋʋ, 'ɩn we nɔa we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«A -zla -lu, 'ɩn wa 'ka we aɩn 'nyɛ. A -talɩ -luu da, 'ɩn a 'ka we 'yɩ. A bhlɩ -budu, 'ɩn wa 'ka -bha -kalɩ aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nɩɩ, -ɔ zlaa -lu, 'mɔ wa nyɛa we. -Ɔ talɩa -luu da, mɔ yɩa we. -Ɔ bhlɩa -budu, mɔ -yla wa kalɩa -bha. ");
INSERT INTO kyf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Amɩaa 'yu -ka aɩn 'floo -zlalɩ, a mneni a 'ka ɔ tʋkpa 'nyɛɛ? ");
INSERT INTO kyf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'Ɩn ɔ -ka aɩn zibhi -zlalɩ, a mneni a 'ka ɔ tɩbhɛ 'nyɛɛ? -Ɩnnya, we 'nɩ sa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɩɩ, amɩa -mama -wa nyɩma 'nyii, a -yi amɩaa 'yua -li -zɔnʋ 'nyɛ sa. We -ka 'sa -mɩ, a -mɩ we -gʋ nɩɩ, amɩaa Dide -ɔ mɩa yalɩ, -wa -ka ɔ -lu -zlalɩ, -lu -zɔnʋ ɔ yia wa 'nyɛa. ");
INSERT INTO kyf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«-We a 'yɩbhaa nyɩma nʋ aɩn -yla lɛ, amɩa nʋ 'ya we wa -yla lɛ. Mʋ -wa Moizɩɩ tite -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛɛ ji. ");
INSERT INTO kyf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«A plalɩ klolo ŋwɛɛ poo 'wʋ. 'Yoo -we kwaa nyɩmɛ tlɩtlɩe 'wʋ, we gbʋ 'nɩ -yɔ -kalɩ, 'ɩn we klolo ŋwɛɛ 'ylia 'wʋ la. 'Ɩn -wa bhlia wee 'yoo, wa -zu 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nɩɩ, 'yoo -we kwaa nyɩmɛ 'yliyɔgagɩe 'wʋ, we gbʋ -kalɩ -yɔ. 'Ɩn we ŋwɛɛ mɩa poo. -Wa yɩa we -yɔ, wa 'nɩ 'wʋzu. ");
INSERT INTO kyf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Nyɩma -wa laa wa 'dɛ -Lagɔgbʋʋ -falɩpanya, a zʋ amɩaa 'dɛ 'yliyɔ wa gbɛgbɛɩn. Wa -ka yi, wa mɩ sa -dlɔɔ bhlabhlɛ 'bhisa, 'ɩn wa nʋkplɛ mɩa, -mɔ 'wlʋ -fliigwɩ -we mɩa vla 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wa lɛnʋgbʋ -yɔ a yia wa yibhelia. Wa'a -sa *-dlɔya 'mnɛwia 'wlu, 'ɩn wa'a -sa magloo -kɔjɩ 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nɩɩ, su -zɔnʋ weee mɩa, 'bhue -zɔnʋ we paa, 'ɩn su 'nyuu mɩa, 'bhue 'nyuu we paa. ");
INSERT INTO kyf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Su -zɔnʋ mɩa, we 'nɩ mneni we 'ka 'bhue 'nyuu 'pa. 'Ɩn su 'nyuu mɩa, we 'nɩ mneni we 'ka 'bhue -zɔnʋ 'pa. ");
INSERT INTO kyf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Su weee nyɩdɩ, -we 'nɩ 'bhue -zɔnʋ 'pa, -dɩ wa -dɩa we, 'ɩn wa vitelia we -kosu 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Sa a yia waa yocɩan yibhelia wa lɛnʋgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«-Wa gbaa da: ‹Na -Kanyɔ, na -Kanyɔ›, we 'nɩ wa 'dɛ weee -Lagɔ yi 'sa 'wlulapɩlɩa. Nɩɩ, -wa nʋa ɔ dʋmagbʋ lɛ, ma 'wlu ɔ yia lapɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, -bha nyɩma duun yia 'mɩ -yla gbaaɛ: ‹-Amɩaa -Kanyɔ! -Amɩaa -Kanyɔ! Nɩɩ, -a ka -Lagɔgbʋ gba -na 'ŋnɩ nya, -a ka zuzu 'nyii vu -na 'ŋnɩ nya, 'ɩn -a ka gwɛdigbʋ lɛnʋ -na 'ŋnɩ nya, we 'nɩ mʋʋ?› ");
INSERT INTO kyf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tɔʋn, -bha na yia wa -yla gbaa -zejila 'wʋɛ: ‹Ɩn 'nɩ aɩn -yi 'mnumnu. Nyɩma 'nyii, a bɛ lʋ!› ");
INSERT INTO kyf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Nɩɩ, -we weee ɩn gbaa dɛ nɩ, -ɔ -ka we yukwli pʋlʋ, 'ɩn ɔ 'ka we -gʋgbʋ lɛnʋ, ɔ 'wlʋ gbʋyilonyɔ -ɔ 'sʋbha ɔ -budu tʋkpa -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Da 'nyu lʋa, 'nyu yea -bha, -pɩpɛ 'kadʋ 'plɩa, wee -budu 'nɩ bhli. -We ka gbʋ -wa, wa ka we 'sʋbha tʋkpa -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nɩɩ, nyɩmɛ -ɔ 'nʋa na wɛlɩ, 'ɩn ɔ 'nɩa we -gʋgbʋ lɛnʋ, ɔ 'wlʋ nyɔgʋgʋ, -ɔ 'sʋbhaa ɔ -budu -bʋsɛ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Da 'nyu lʋa, we yea -bha, 'ɩn -pɩpɛ 'kadʋ 'plɩa, 'ɩn we yia we la bhlɩ, 'ɩn we yia -nyumɔ weee.» ");
INSERT INTO kyf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","-Zezu bhɩa gbʋ nɩ gbagbɩe, 'ɩn we yia nyɩma weee ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nɩɩ, ɔ 'nɩ wa gbʋ -slolu -Lagɔɔ titee gwesanya 'bhisa, se -we -Lagɔ 'nyɛa ɔ, we nya ɔ -slolua wa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Da -Zezu mɩa -gɔgɔ kwlida, 'ɩn nyɩmaa -zlo yia ɔ 'bɩ yi. ");
INSERT INTO kyf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tɔʋn, *sɔlɩbhanyɔ yabhlo bɛa ɔ 'yu, 'ɩn ɔ yia 'kukolu 'sibhli, 'ɩn ɔ nɛɛ: «Na -kanyɔ, -na zukpa -wa: we -ka -mɩ dʋdʋ nanɩ, -ɩn mneni -ɩn 'ka 'mɩ jipe.» ");
INSERT INTO kyf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","-Zezu -gloa sɔ 'wʋ, ɔ zɩa ɔ kwɛ, ɔ nɛɛ: «We nanɩ 'mɩ dʋdʋ, -ɩn 'pʋ!» -Bha -bhlokpadɛ *sɔlɩ 'bhʋa ɔ ku -yɔ, ");
INSERT INTO kyf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'ɩn -Zezu nɛɛ ɔ -yla: «-Ɩn -ka mnɩ nɩ, -ɩn 'na -salɩ we 'dɩ nyɩmɛ yabhlogbɔɔ -nɩ. Mnɩ -na 'dɛ *-Lagɔbʋbɔnyɔ 'klʋslolua, 'ɩn -we Moizɩ gbaa nɩɩ, nyɩmɛ -ɔ -ka 'pʋ ɔ 'nyɛ -Lagɔ, -ɩn wla we, 'ɩn wa 'ka we 'jiyibheli nɩɩ, -ɩn ka 'pʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","We bhla -Zezu plaa Kapɛnaumʋgbe nʋkplɛ, 'ɩn *Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ yia ɔ -gbɛ yi. Nɩɩ, ɔ yia ɔ zukpa 'palɩ, -mɔɔ 'ka ɔ -yɔbɛ. ");
INSERT INTO kyf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ɔ nɛɛ: «Na -kanyɔ, na zɔyu ka gu -yɔ, ɔ ka 'kli, ɔ mɩ lapɩda -buduŋwɛɛ, ɔ mɩ sɩada duun.» ");
INSERT INTO kyf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","-Zezu nɛɛ ɔ -yla: «Ɩn mɩ yida, ɩn 'ka ɔ jipe.» ");
INSERT INTO kyf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Ɩn 'slʋjaa 'yugalɩnyɔ nɛɛ: «Na -kanyɔ, ɩn 'nɩ we 'klʋ -ka, -ɩn 'ka na -budu zɔ pla. Nɩɩ, gba wɛlɩ yabhlo, 'ɩn na zɔyu 'ka 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nɩɩ, -amɩ, ɩn mɩ na -cɩan zɔ, 'ɩn ɩn pɩlɩa 'slʋja tɔlʋa 'wlu la. Ɩn -ka 'yabhlo -yla gbaɛ: ‹-Ɩn mnɩ!› 'ɩn ɔ mnɩa. Ɩn -ka 'ya -bʋdʋ -yla gbaɛ: ‹-Ɩn yi!› 'ɩn -mɔɔ yia. 'Ɩn ɩn -ka na zɔlubhonʋnyɔ -yla gbaɛ: ‹-Ɩn nʋ -mɩnɩ lɛ!› 'ɩn ɔ nʋa we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","-Zezu 'nʋa we, 'ɩn we yia ɔ ŋwɛgaga -sʋbhalɩ, 'ɩn ɔ nɛɛ -wa mɩa ɔ 'bɩ -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ, -ɔ zʋa sa dlɩ nɩ, ɩn 'nɩ -slɔ we -kanyɔ 'yɩ Izlaɛlɩ -dʋdʋʋ 'dɛbhie -gbolu -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ɩn nɛɛ aɩn -yla: nyɩma -duun yia yia. Tɔlʋa yia 'ylʋʋ 'wʋsɔlʋda 'bhʋa, 'ɩn tɔlʋa yia 'ylʋʋ bhlilida 'bhʋa. *-Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ wa yia dabʋdʋ lia, wa -yɔ *Ablaamʋ klaa, *Izakɩ klaa, we -yɔ *Zakɔbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nɩɩ, 'yua -wa 'wlu -Lagɔ 'ka 'yaa lapɩlɩ, 'ma wa yia 'pipee vitelia, nikpise 'wʋ. -Mɔ wa yia wilia, 'ɩn -mɔ wa yia gla 'wʋ lia.» ");
INSERT INTO kyf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tɔʋn, -Zezu nɛɛ ɔɔ 'slʋjaa 'yugalɩnyɔ -yla: «Mnɩ -buduŋwɛɛ. -We -na dlɩ mɩa -gʋ we ka lɛnʋ.» -Bha -bhlokpadɛ ɔɔ zɔyu 'pʋa. ");
INSERT INTO kyf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","-Bha -Zezu mnɩa Piɛlɩɩ -buduŋwɛɛ. Ɔ nynia -mɔ, 'ɩn ɔ yia Piɛlɩɩ 'ŋwnɔɔ 'nyaa -yɔyɩ lapɩda. -Mɔɔ ku -su. ");
INSERT INTO kyf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","-Zezu zɩa ɔ sɔ kwɛ, 'ɩn -pɩpɛ yia ɔ ku zɔ 'plɩlɩ. Ɔ sɔa 'wʋ, 'ɩn ɔ yia wa -yla pipie bhli. ");
INSERT INTO kyf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jibhe 'ka zɔ, 'ɩn wa yia nyɩma duun -wa zuzu 'nyuu mɩa 'wʋ, ɔ -gbɛ -la. Ɔ wɛlɩ nya ɔ vua zuzu 'nyii, 'ɩn ɔ jipea guzʋnya weee. ");
INSERT INTO kyf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Mʋ ɔ nʋa lɛ, 'ɩn -we -Lagɔgbʋʋ -falɩpanyɔ Ezaii gbaa we 'ka gbʋzɔnʋ -zɛ: «Ɔ ka -amɩaa sɩasɩe 'wʋbhu, 'ɩn ɔ yia -aɩn gu -yɔsa.» ");
INSERT INTO kyf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","-Mʋʋ 'bɩgʋ, -Zezu 'yɩa nɩɩ, nyɩma duun mɩ ɔ kwesi, 'ɩn ɔ nɛɛ ɔ 'bɩnɔnya -yla nɩɩ, wa mnɩ 'nyuu kakpe -putu -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","-Lagɔɔ titee gwesanyɔ yabhlo bɛa ɔ -yɔ, 'ɩn ɔ nɛɛ: «-Slolunyɔ, da weee -na yia mnɩa, ɩn mɩ -mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Ɩn -Zezu nɛɛ ɔ -yla: «-Totonya ka 'bhʋka, 'ɩn zia kaa lʋlʋ. Nɩɩ, da *Nyɩmɛɛ 'Yu 'kaa ladɩlɩ, -bha 'nɩ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Ɩn ɔ 'bɩnɔnyɔ yabhlo nɛɛ ɔ -yla: «Nyɩmaa -Kanyɔ, -ɩn 'nyɛ 'mɩ 'yoo, ɩn 'ka na dide 'bhlua mnɩ 'bhie.» ");
INSERT INTO kyf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","-Zezu nɛɛ ɔ -yla: «-Ɩn yi 'mɩ 'bɩ, -ɩn 'tide tlɩtlɩnya 'yi, wa 'ka wa tlɩtlɩnya 'bhlu.» ");
INSERT INTO kyf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","-Zezu -bhoa 'glʋ 'wʋ, 'ɩn ɔ 'bɩnɔnya yia ɔ yoo kwa. ");
INSERT INTO kyf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tɔʋn, 'ɩn -pɩpɛ 'kadʋ yia 'plɩplɩe bhli, 'ɩn 'nyu -gbʋgbʋ yia 'glʋ 'wʋslo, -zugba -Zezu mɩ 'ylaa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɔ 'bɩnɔnya bɛa ɔ kwesi, wa ganɔa ɔ, 'ɩn wa nɛɛ ɔ -yla: «Nyɩmaa -Kanyɔ, -sa -aɩn gbʋ 'wʋ! -Amɩa tlɩa!» ");
INSERT INTO kyf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tɔʋn, -Zezu nɛɛ wa -yla: «Dlɩ 'kienyi -zʋnya, lɛɛ -lu ka 'gbʋ a nʋ 'sa nyanɔa?» Tɔʋn ɔ sɔa 'wʋ, 'ɩn ɔ yia -pɩpɛ -yɔ 'nyu 'wluo 'kpɩlɩ, 'ɩn -bha yia 'wʋtʋ blenyii. ");
INSERT INTO kyf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋwɛgaga -sʋbhalɩa wa 'dɛ weee, 'ɩn wa yia layɩbhalɩ -yɩbhalɩɛ: «Ɔɔ nyɩmɛ mɩa da, 'nyu -yɔ -pɩpɛ zʋa ɔ 'nʋŋwɛ, mɔɔ -nyɩmɛ nɩ da?» ");
INSERT INTO kyf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","We bhla -Zezu nynia 'nyuu kakpe yabhlo -gʋ, -mɔ -wa Gadale -nyɩmaa dʋdʋ -gʋ, 'ɩn nʋkpasia 'sɔ yia gbawla nyɩdɩ 'tla, 'ɩn wa yia ɔ yoo yi. Waa nʋkpasia mɩa, zuzu 'nyii mɩ wa 'wʋ. 'Cɛ wa paa -bhabha, 'ɩn wa bhɩtɩa nyɩma, we 'dɛɛ 'gbʋ nyɩma weee nʋa nyanɔ, 'ɩn wa'a 'plɩlɩa -slɛɛn wee 'yloogblʋ. ");
INSERT INTO kyf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tɔʋn wa 'kpɩa 'wʋ, wa nɛɛ: «-Mɩ, -Lagɔɔ 'Yu, -naa lɛɛ -gbʋ pɩlɩ -amɩaa gbʋ 'wʋla? We bhla 'nɩ -slɔ nyni, yi -ɩn yia, -ɩn 'ka -aɩn 'klɩyɩe 'wʋpa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nɩɩ, wa kwesi, -boboo -zlo mɩ -bha lililuu datalɩda. ");
INSERT INTO kyf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Ɩn zuzu 'nyii yia ɔ zukpa 'palɩ, we nɛɛ: «-Ɩn -ka gba -ɩn 'ka -aɩn vu nɩ, -ɩn kwa -aɩn -bobonya nɩ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","-Zezu nɛɛ: «A mnɩ.» 'Ɩn we yia waa nyɩma 'sɔ 'wʋtla, 'ɩn we yia -bobonya 'wʋpla. Tɔʋn, wee -bobonya yia -gɔgɔ kwli -gwagwɩe nya, we yia 'nyu lʋ slo, 'ɩn we yia 'nyu lʋ tlɩlɩ -nya. ");
INSERT INTO kyf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","-Bha -boboo 'yliyɔzʋnya mnɩa 'gbe 'kadʋ nʋkplɛ -gwagwɩe nya, 'ɩn -we weee ylɩa -bobonya -yɔ -wa kaa zuzu 'nyii 'wʋ, 'ɩn wa yia -mɔ we 'dɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wee 'gbe nʋkpla -nyɩma weee 'tlaa, da -Zezu mɩa, 'ɩn wa yia -mɔ mnɩ. Wa 'yɩa ɔ, 'ɩn wa yia ɔ bhubhoe, 'ɩn wa nɛɛ nɩɩ, ɔ 'bhʋ wa dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","-Zezu -bhoa 'glʋ 'wʋ, ɔ -dɩa 'nyu 'wʋ, 'ɩn ɔ yia Kapɛnaumʋ lʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Ɩn nyɩma -yɔ zɔlaslonyɔ yia yi, -zugba ɔ mɩ 'sowli 'wʋ. -Zezu 'yɩa nɩɩ, wa ka ɔ dlɩ -gʋ zʋ, 'ɩn ɔ nɛɛ ɔɔ zɔlaslonyɔ -yla: «Na 'yu, -ɩn 'tɛmanɩ dlɩ, ɩn ka -na gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","-Bha, -Lagɔɔ titee gwesanya pʋpalɩa 'wlukʋʋn laɛ: «Nɩɩ, nʋkpasu mɩa dɛ, -Lagɔ ɔ vɛlɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","'Ɩn -we wa pʋpalɩa 'wlukʋʋn la, -Zezu yia we yibheli, 'ɩn ɔ nɛɛ: «Lɛɛ -lu ka 'gbʋ a pʋpalɩ 'wlukʋʋn la sa 'nyumɛɛa? ");
INSERT INTO kyf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɩn 'ka gba: ‹Ɩn ka -na gbʋnyii 'wʋtɩ,› -mʋʋ -kalɩa -yɔ yaayɩɩ, ɩn 'ka gba: ‹-Ɩn -sɔ 'wʋ, -ɩn nɔ,› -mʋʋ -kalɩa -yɔ yɩ? ");
INSERT INTO kyf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","A yibheli we 'ji nɩɩ, Nyɩmɛɛ 'Yu ka se dʋdʋ -gʋ ɔ 'ka nyɩmaa gbʋnyii 'wʋtɩ.» -Bha -Zezu gbaa ɔɔ zɔlaslonyɔ -ylaɛ: «-Sɔ 'wʋ, 'bhu -na 'sɔwli 'wʋ, mnɩ -na -buduŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɔɔ nyɩmɛ -sɔa 'wʋ, 'ɩn ɔ yia -buduŋwɛɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Waa nyɩma 'yɩa we -yɔ, 'ɩn nyanɔ yia wa dlɩ 'wʋ slo, 'ɩn wa yia -Lagɔɔ 'ŋnɩ -mnɩnɩ, nɩɩ, -Lagɔ ka nyɩma 'tɩtɛ 'nyɛ wa 'ka 'sasʋkpa -gbʋ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'Ylɩ yabhlo nya -Zezu 'bhʋa -bhadɛ, ɔ mɩ 'plɩda, 'ɩn ɔ yia nyɩmɛ wa laa Matie -yɔyɩ, nɩɩ, ɔ -dɩ 'gwɛzisabudu zɔ la. Ɔ nɛɛ ɔ -yla: «Yi 'mɩ 'bɩ.» Matie -sɔa 'wʋ, 'ɩn ɔ yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","-Zezu -yɔ ɔ 'bɩnɔnya mɩ lida Matiee -budu zɔ, -zugba *nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan duun mɩ 'ya wa glaa. ");
INSERT INTO kyf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Falizɩnyɩma 'yɩa we -yɔ, 'ɩn wa nɛɛ -Zezuu 'bɩnɔnya -ylaɛ: «Amɩaa -Kanyɔ mɩa, lɛɛ -lu ka 'gbʋ ɔ -yɔ nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan lia?» ");
INSERT INTO kyf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","-Zezu 'nʋa we, ɔ nɛɛ wa -yla: «Nyɩma -wa -yalɩa, wa'a mnɩ -dɔtlɔɔ -gʋ. Nɩɩ, guzʋnya mnɩa -dɔtlɔɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","-We -Lagɔwɛlɩ nɩ gbaa, a mnɩ a 'ka we 'jii datalɩ, we nɛɛ: ‹-We ɩn 'yɩbhaa mʋ -wa nɩɩ, nyɩma 'ka nyazɩdlɩ -ka, we 'nɩ 'slaka -sasɩe.› Nɩɩ, ɩn 'nɩ nyɩma tɩklɩɩ laa yi, gbʋnyuu -lɛnʋnya ɩn yia laa.» ");
INSERT INTO kyf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'Zan -Batisɩɩ 'bɩnɔnya bɛa -Zezu kwesi, 'ɩn wa yia ɔ layɩbhaɛ: «Lɛɛ -lu ka 'gbʋ, -amɩa -yɔ Falizɩnyɩma pla 'sun 'ylɩ tɔlʋa nya, 'ɩn -nanʋʋ 'bɩnɔnya'a nʋ we lɛa?» ");
INSERT INTO kyf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Ɩn -Zezu nɛɛ wa -ylaɛ: «Nɩɩ, 'ŋwnɔ kwa zlɩ, ɔ 'lowlii 'talea mɩa, wa dlɩ 'nɩ mɛnɩ, gbʋzɔnʋ -wa yɩ? -Ɩnnya, yo -wa yo. Nɩɩ, 'ylɩ yabhlo yia nynia, 'ɩn wa saa wa 'ŋwnɔɔ 'lowli glaa. Nɩɩ, -mʋʋ zlɩ wa plaa 'sun. ");
INSERT INTO kyf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Nɩɩ, -bana sʋa -ka yla nɩ, nyɩmɛ -ka we pɩpɛda -mɩ, ɔ'ɔ zʋ we ylada 'naa lolu. Ɔ -ka 'sa we nʋ, 'ɩn 'naa lolu gbizea -bana sʋa 'wʋ, 'ɩn we ylada ylimanɩa 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Sa -bhlokpadɛ, wa'a palɩ nʋ lolu *bala sʋa 'wʋ. Wa -ka 'sa nʋ, 'ɩn bala wlɔa, 'ɩn nʋ jitea. Nɩɩ, nʋ -lolu kaa bala lolu, 'ɩn we 'dɛ 'sɔ gwlɛa.» ");
INSERT INTO kyf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Da -Zezu mɩa -slɔ gbʋ gbada, 'ɩn Zuifʋʋ 'yugalɩnyɔ yabhlo yia yi. Ɔ 'sibhlia ɔ 'yu 'kukolu, 'ɩn ɔ nɛɛ: «-Na zukpa -wa, na 'ŋwnɔyu ka tlɩ, we 'bɩ 'nɩ -slɔ 'wʋgwlɛ, nɩɩ, -ɩn yi, -ɩn 'ka ɔ sɔ -gʋ lapalɩ, 'ɩn ɔ 'ka 'yliyɔgagɩe 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","-Zezu -sɔa 'wʋ, 'ɩn ɔ -yɔ ɔ 'bɩnɔnya yia -mɔɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","-Bha 'ŋwnɔ yabhlo mɩ -bha, mɔ palɩa kwɛ, we li -zʋ kugbua lɛ 'sɔ ɔ -yɔ. Ɔ nɛɛ ɔ 'dɛɛ dlɩ zɔ: «Ɩn -ka ɔ -bana kwɛ -zɩzɩe mneni, 'ɩn na pʋa.» We 'dɛɛ 'gbʋ ɔ yia -Zezu lʋʋ 'plɩlɩ, 'ɩn ɔ yia ɔ -banaa ŋwɛ kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","-Zezu 'bhitia la, ɔ 'yɩa ɔɔ 'ŋwnɔ -yɔ, 'ɩn ɔ nɛɛ: «Na 'yu, a 'tɛmanɩ dlɩ, amaa dlɩ ka aɩn pue.» -Bha -bhlokpadɛ ɔ 'pʋa. ");
INSERT INTO kyf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tɔʋn, -Zezu nynia Zuifʋʋ 'yugalɩnyɔɔ -buduŋwɛɛ, 'ɩn ɔ yia -mɔ guzɔ -gɔfɩ -bhlɩnya -yɔyɩ, -zugba nyɩma duun zizli -bha -gʋ sɔ weee lʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ɔ nɛɛ: «A 'bhʋ -bha! Nɩɩ, ɔɔ 'ŋwnɔyu 'nɩ tlɩ, 'ylaa 'wʋ ɔ mɩa.» 'Ɩn wa yia ɔ gla palɩ. ");
INSERT INTO kyf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa ka wa wleli weee 'bhie, -Zezu yia komi lʋʋ pla. Ɔ kpalɩa ɔɔ 'ŋwnɔyu sɔ -yɔ, 'ɩn -mɔɔ yia 'wʋsɔ. ");
INSERT INTO kyf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","We dɩ mnenia wee dʋdʋ weee -gʋ la. ");
INSERT INTO kyf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","-Zezu 'bhʋa -mɔ, ɔ mɩ 'yloogblʋ, 'ɩn 'lɔlɔnya 'sɔ yia ɔ 'bɩ mnɩ. Wa 'kpɩa 'wʋ, wa nɛɛ: «-Davidɩɩ 'yuɔɔa, -ɩn 'yɩlɩ -aɩn nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Da ɔ plaa -budu zɔ, 'ɩn 'lɔlɔnya 'sɔ yia ɔ kwesi bɛ, 'ɩn ɔ nɛɛ wa -ylaɛ: «'Lee a zʋ dlɩ nɩɩ, ɩn mneni ɩn 'ka we lɛnʋʋ?» 'Ɩn wa nɛɛ: «Nyɩmaa -Kanyɔ, gbʋzɔnʋ -wa, -ɩn mneni we.» ");
INSERT INTO kyf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tɔʋn, -Zezu zɩa wa 'yli kwɛ, 'ɩn ɔ nɛɛ: «Sa a zʋa dlɩ, a 'yɩ 'sa we!» ");
INSERT INTO kyf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Ɩn wa 'yli yia -blo. -Zezu nɛɛ wa -yla 'klʋ 'cɩcɩ nya: «Nyɩmɛ yabhlogbɔɔ 'na yibheli we 'ji -nɩɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tɔʋn, wa mnɩa, 'ɩn wa yia -Zezuu 'dɩ -sa wee dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Da wa mɩa mnɩda, 'ɩn wa yia -Zezu nyɩmɛ yabhlo -la. Nɩɩ, ɔɔ nyɩmɛ mɩa nɩ, ɔ 'nɩ gbagbɩe mneni, zuzu 'nyuu mɩ ɔ 'wʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","-Zezu vua wee zuzu, -bha -bhlokpadɛ ɔɔ nyɩmɛ gbaa. 'Ɩn -wa mɩa -bha, ŋwɛgaga -sʋbhalɩ wa, 'ɩn wa nɛɛ: «Aya, -a 'nɩ -slɔ 'sasʋkpa -gbʋ -mʋnɩɩ da 'yɩ Izlaɛlɩ -dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nɩɩ, Falizɩnyɩma mɩa, -maa nɛɛ: «Zuzu 'nyiii -kanyɔ 'nyɛa ɔ 'tɩtɛ, 'ɩn ɔ 'ka zuzu 'nyii vu!» ");
INSERT INTO kyf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","-Zezu 'plɩlɩa -bha 'gbe 'kadɩ weee -yɔ 'gbe yua weee 'wʋ, ɔ plaa -Lagɔbudunya zɔ, 'ɩn ɔ yia -mɔ nyɩma gbʋ -slolu. -Lagɔgbʋ -we gbaa -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ, 'mʋ ɔ gbaa wa -yla, 'ɩn ɔ yia gu weee -yɔ sɩasɩe weee jipe. ");
INSERT INTO kyf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nyɩmaa -zlo -wa mɩa sɩada, 'ɩn wa dlɩ 'nɩa mɛnɩ, -wa 'wlʋa bhlabhlɛ -we 'nɩ 'yliyɔzʋnyɔ -ka, ɔ 'yɩa wa -yɔ, 'ɩn wa yia ɔ nyazɩ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Ɩn ɔ nɛɛ ɔ 'bɩnɔnya -yla: «'Mnɔ ka zalɩ duun, we kpaa 'yli, 'ɩn we -dɩdɩnya 'nɩ 'wʋzu. ");
INSERT INTO kyf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","We 'gbʋ, a bhubhoe kpaa -Kanyɔ ɔ 'ka lubhonʋnya yoo 'pa, wa 'ka wee -lu -dɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","-Zezu laa ɔ 'bɩnɔnya kugbua lɛ 'sɔ, 'ɩn ɔ yia wa 'tɩtɛ 'nyɛ wa 'ka zuzu 'nyii vu, 'ɩn wa 'ka gu weee -yɔ ku zɔ -sɩasɩe weee jipe. ");
INSERT INTO kyf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ɔ tietienya kugbua lɛ 'sɔɔ ŋnɩ nɩ: tɩada, 'Simɔɔ (-mɔɔ -baŋnɩ -wa Piɛlɩ), we -yɔ ɔ bheli Andlee klaa, Zebedee 'yua *'Zake -yɔ ɔ bheli *Zaan klaa, ");
INSERT INTO kyf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipʋ -yɔ Batlemii klaa, Toma -yɔ nisʋn -gwɛzisanyɔ Matie klaa, Alɩfeee 'yu 'Zake -yɔ Tadee klaa, ");
INSERT INTO kyf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'gbee *lʋpanyɔ 'Simɔɔ we -yɔ Zudasɩ Isɩkaliɔtʋ, nyɩmɛ -ɔ wlaa -Zezu ɔ tʋnyɩma -yla. ");
INSERT INTO kyf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","-Mʋʋ 'bɩgʋ, -Zezu 'kaa ɔ 'bɩnɔnya kugbua lɛ 'sɔ tie ɔ nɛɛ wa -ylaɛ: «Nɩɩ, nyɩma -wa 'nɩa Zuifʋ, a 'na mnɩnɩ wa dʋdʋ -gʋ -nɩ. A 'na mnɩnɩ 'ya Samalii -dʋdʋʋ 'gbe yabhlogbɔɔ 'wʋ -nɩ. Da a 'kaa mnɩ nɩ, mʋ -wa Izlaɛlɩnyɩmaa -gbɛ, ma 'wlʋa mnɔmnɔ -bhlabhlɛ. ");
INSERT INTO kyf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A -ka 'yloogblʋ -mɩ, a gbaɛ: -Lagɔɔ nyɩmaa 'wlulapɩlɩ bhla ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Guzʋnya mɩa, a jipe -maa. -Mama -ka tlɩ, a 'nyɛ -maa 'yliyɔgagɩe. Sɔlɩbhanya mɩa, a pue -maa, 'ɩn a vu zuzu 'nyuu. Bhe a 'yɩa wee 'tɩtɛ, we 'dɛɛ 'gbʋ, a -sa nyɩma 'wʋ bhe. ");
INSERT INTO kyf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A 'na 'bhulu -can klaa, 'gwɛzi klaa, we -yɔ tama yabhlogbɔɔ 'wʋ -nɩ. A 'na palɩ we amɩaa pɔsi 'wʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A -ka mnɩda -mɩ, *-bada klaa, -bana 'sɔnʋ klaa, -sakwla klaa, we -yɔ kɔɔsu, a 'na 'bhulu we 'yabhlogbɔɔ 'wʋ -nɩ. Lubhonʋnyɔ mɩa, ɔ ka ɔ lililuu 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Nɩɩ, a -ka 'gbe 'kadɩ -mʋmʋ 'wʋ nyni, a -ka 'gbe yua -mʋmʋ 'wʋ nyni, nyɩmɛ -ɔ 'kaa aɩn kpa 'nanʋʋ, a -talɩ ɔ da. A 'nɩ -slɔ wee 'gbe 'wʋbhʋ, a -dɩ -bha la. ");
INSERT INTO kyf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","-Budu -mʋmʋ ŋwɛɛ a -ka nyni, a ŋwna wa 'nyu la, 'ɩn wa 'ka 'wʋtʋtʋe -dlɔɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wee -buduŋwɛɛ -nyɩma -ka amɩaa 'lakpasu kpa, amɩaa 'wʋtʋtʋe -dlɔɔ -tʋ wa -gʋ. 'Ɩn wa 'nɩ amɩaa 'lakpasu kpa, a -yɔ amɩaa 'wʋtʋtʋe -dlɔɔ 'plɩ. ");
INSERT INTO kyf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","«Nɩɩ, -budu -mʋmʋ ŋwɛɛ we -yɔ 'gbe -mʋmʋ 'wʋ, wa 'nɩ amɩaa 'lakpasu kpa, wa 'nɩ aɩn yukwli pʋlʋ, a gbɔtɔ amɩaa bhʋ -yɔ *-bhubhui, 'ɩn a 'bhʋ -bha. ");
INSERT INTO kyf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, wee 'gbe -mʋnɩɩ nʋkpla -nyɩma yia sɩa bhabha, we 'ka *Sodɔmʋ -nyɩma -yɔ *-Gomɔlʋ -nyɩma -nʋ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«A pʋ yukwli: nɩɩ, bhlabhlɛ 'bhisa na tiea aɩn -mɔ gbi glaa. We 'dɛɛ 'gbʋ a mna 'yli tɩbhɛ 'bhisa, 'ɩn a 'ka mɩ -dlɔɔ -kpakʋn 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nɩɩ, gbʋwʋbhunya 'yu wa yia aɩn kwaa, 'ɩn wa 'ka aɩn sɛlɩ -mɔ -Lagɔbudunya zɔ. We 'dɛɛ 'gbʋ, a zʋ amɩaa 'dɛ 'yliyɔ. ");
INSERT INTO kyf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na 'gbʋ, wa yia aɩn dʋdʋʋ 'wlulapɩlɩnya -yɔ nyɩmaa 'wlulapɩlɩnya 'yu kwaa. Nɩɩ, -maa -yɔ -wa 'nɩa Zuifʋ, wa 'yu a yia na gbʋdayɩnya -zɛa. ");
INSERT INTO kyf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wa -ka aɩn gbʋwʋbhunya 'yu kwa, a 'na lʋlʋ dlɩ -nɩ, -we a 'kaa gba, 'ɩn sa a 'kaa we gba mʋ nɩ: wɛlɩ -we a 'kaa gba, we bhla a yɩa we. ");
INSERT INTO kyf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nɩɩ, wee wɛlɩ mɩa, we'e 'bhʋ amɩaa 'dɛ dlɩ zɔ, amɩaa Dide -Lagɔ yia we wlaa ɔ Zuzuu gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Nɩɩ, bhelia yia wa bhelia wlaa wa 'ka wa 'bha, 'ɩn 'sa -bhlokpadɛ didea yia wa 'yua wlaa. Yua yia wa didea -yɔwʋsɔlʋa, 'ɩn wa 'ka wa 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amɩa, na 'gbʋ nyɩma weee yia aɩn 'wʋnyɛa. -Ɔ ka dlɩ -ka 'mɩ -gʋ -tʋ, 'ɩn we 'ka we bhloluda nyni, 'ɩn -mɔɔ bhʋa gbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wa -ka aɩn 'klɩyɩe 'wʋpalɩda -mɩ 'gbe yabhlo 'wʋ, a mnɩ 'gbe -putu 'wʋ -gwagwɩe nya. Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: a 'nɩ -slɔ *Izlaɛlɩɩ 'gbe weee 'wʋplɩlɩe bhɩa, 'ɩn Nyɩmɛɛ 'Yu 'kaa lʋyi. ");
INSERT INTO kyf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«'Kpɩakpɩanyɔ yabhlogbɔɔ 'nɩ ɔ -slolunyɔ 'wʋzi, 'ɩn gaylo yabhlogbɔɔ 'nɩ ɔ -kanyɔ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nɩɩ, 'kpɩakpɩanyɔ -ka ɔ -slolunyɔ 'bhisa -mɩ, 'ɩn gaylo 'ka ɔ -kanyɔ 'bhisa -mɩ, we -tʋ sa. Wa -ka -buduŋwɛɛ -kanyɔ vɛlɩ, wa -ka ɔ 'ŋnɩ zʋ *Bɛlɩzebulɩ, ɔ -buduŋwɛɛ -nyɩma mɩa, -maa -nʋ yia -bha -zia! ");
INSERT INTO kyf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«A 'na sɔlʋ nyɩma -nɩ. Nɩɩ, -lu weee mɩa zizeda, zlɩ 'klʋ we yia 'tlaa, 'ɩn -we ka 'ji nyɩma 'nɩa -yi, 'ji wa yia we yibhelia. ");
INSERT INTO kyf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","-We ɩn gbaa aɩn -yla nikpise 'wʋ, a gba we zlɩ. -We ɩn gbaa aɩn -yla ŋwuŋweda, a wɩzɩ we nyɩma weee -yla. ");
INSERT INTO kyf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","-Wa mnenia wa 'ka nyɩmɛɛ ku 'bha, 'ɩn wa 'nɩa mneni wa 'ka nyɩmɛɛ zuzu 'bha, a 'na sɔlʋ wa -nɩ. Nɩɩ, -Lagɔ mɩa, ɔ mneni ɔ 'ka nyɩmɛɛ ku -yɔ ɔ zuzu 'bha -kosu 'wʋ, we 'gbʋ a sɔ ɔ. ");
INSERT INTO kyf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","«Nyɩmaa 'yliya 'wʋ, bhuyua 'nɩ -valɛ -ka. Tama -bhloo 'gbʋ wa paa we 'sɔ pɛlʋ. 'Ɩn -mʋʋ bhla, amɩaa Dide 'nɩ -slɔ we ŋwnu, we yabhlogbɔɔ'ɔ bhli dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Nɩɩ amɩa, a 'yli -Lagɔɔ 'yliya 'wʋ, a 'ka bhuyuaa -zlo 'wʋzi, nɩɩ, -Lagɔ -yi amɩaa 'wluo nyii ŋwɛ. We 'dɛɛ 'gbʋ a 'na nʋnʋ nyanɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Nɩɩ, nyɩmɛ, -ɔ -ka gba ɔ mɩ na -nʋ nya -zejila 'wʋ, 'ɩn na gbaa na Dide -ɔ mɩa yalɩ 'yu nɩɩ, ɔ mɩ na 'bɩnɔnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nɩɩ, -ɔ yia na gbʋ kpɛlɩa -zejila 'wʋ, 'ɩn -amɩ na kpɛlɩa ɔ gbʋ na Dide -ɔ mɩa yalɩ 'yu. ");
INSERT INTO kyf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Nɩɩ, ɩn 'nɩ 'wʋtʋtʋe -dlɔɔ -la dʋdʋ -gʋ. We 'nɩ -mʋʋ, ɩn 'nɩ 'wʋtʋtʋe -dlɔɔ -la, nɩɩ, tʋ ɩn -laa dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‹Nɩɩ, 'yu -yɔ ɔ dide klaa, 'ŋwnɔyu -yɔ ɔ 'nyaa klaa, we -yɔ 'ŋwnɔ -yɔ ɔ 'lowlii 'nyaa, 'yli ɩn yia wa pʋpalɩa. ");
INSERT INTO kyf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nyɩmɛɛ -buduŋwɛɛ -nyɩma yia ɔ tʋnyɩma -zɛa.› ");
INSERT INTO kyf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Nyɩmɛ -ɔ -ka ɔ dide -yɔ ɔ 'nyaa 'yɩbha we 'ka 'mɩ -zi, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ. 'Ɩn -ɔ -ka ɔ nʋkpasuyu -yɔ ɔ 'ŋwnɔyu 'yɩbha we 'ka 'mɩ -zi, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ɩn nyɩmɛ -ɔ 'nɩ ɔ sɩasɩee *su 'wʋbhu, ɔ 'ka 'mɩ 'bɩ yi, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɩɩ, -ɔ -ka gba, ɔ 'ka ɔ 'dɛɛ 'yliyɔgagɩe 'yɩ nɩ, tlɩa ɔ yia. 'Ɩn -ɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe wla na 'gbʋ, 'ɩn -mɔɔ yɩa 'yliyɔgagɩe -we 'nɩa bhloluda -ka. ");
INSERT INTO kyf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nyɩmɛ -ɔ -ka aɩn kpa 'nanʋʋ, -amɩ ɔ kpaa 'nanʋʋ. 'Ɩn nyɩmɛ -ɔ -ka 'mɩ kpa 'nanʋʋ, -ɔ tiea 'mɩ, 'mɔ ɔ kpaa 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nyɩmɛ -ɔ -ka -Lagɔgbʋʋ -falɩpanyɔ kpa 'nanʋʋ, ɔ mɩ -Lagɔgbʋʋ -falɩpanyɔ nyaa 'gbʋ, -we -Lagɔ 'kaa ɔ gbʋʋ -falɩpanya 'nyɛ, 'yɩa ɔ yia we. 'Ɩn -ɔ -ka nyɩmɛ mɩa tɩklɩɩ -Lagɔ 'yu kpa 'nanʋʋ, ɔ mɩ tɩklɩɩ -Lagɔ 'yuu 'gbʋ, -we -Lagɔ 'kaa nyɩma tɩklɩɩ 'nyɛ, 'yɩa ɔ yia we. ");
INSERT INTO kyf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, nyɩmɛ -ɔ -ka 'nyu -wɔtʋʋ 'kɔpʋ yabhlogbɔɔ 'nyɛnyɛyua nɩɩ 'yabhlo 'nyɛ, ɔ mɩ na 'bɩnɔnyɔ nyaa 'gbʋ, -Lagɔ yia we -tnʋʋ -mɔɔ 'nyɛa.» ");
INSERT INTO kyf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Da -Zezu bhɩa wee gbʋ gbagbɩe, ɔ 'bɩnɔnya kugbua lɛ 'sɔ -yla, 'ɩn ɔ yia -bha 'bhʋ. Ɔ mnɩa wee dʋdʋ -gʋʋ 'gbenya 'wʋ, ɔ gbaa -mɔ -Lagɔgbʋ, 'ɩn ɔ yia -mɔ nyɩma gbʋ -slolu. ");
INSERT INTO kyf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Zan -Batisɩ mɩa, ɔ mɩ -kaslʋ 'wʋ, 'ɩn ɔ yia -Zezu Klisɩɩ lɛnʋgbʋʋ 'dɩ 'nʋ. -Bha ɔ tiea ɔ 'bɩnɔnya tɔlʋa, wa 'ka ɔ layɩbhaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Nɩɩ, nyɩmɛ -ɔ 'kaa yi, -a mɩa wʋda, 'mɔ -ɩn -mɩa yɩ, yaayɩɩ, -a wʋ nyɩmɛ -putuu?» ");
INSERT INTO kyf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","-Zezu nɛɛ: «Nɩɩ, -we a 'nʋa, -we a 'yɩa -yɔ, a mnɩ, a -salɩ we Zaan lʋdɩ nya. ");
INSERT INTO kyf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Lɔlɔnya mɩ layɩda, 'tɩgɩtɩgɩnya mɩ nɔda 'nanʋʋ, sɔlɩbhanya ka 'pʋ. 'Sulonya mɩ 'nʋda, tlɩtlɩnya ka tlɩtlɩe lʋ 'wʋsɔ. Wa mɩ -Lagɔgbʋ gbada bobabhanya -yla. ");
INSERT INTO kyf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nyɩmɛ -ɔ 'nɩ 'mɩ dlɩ -gʋ -sa, 'wʋtʋtʋe -dlɔɔ mɩ ɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Da Zaaan 'bɩnɔnya 'bhitia lʋ, 'ɩn -Zezu yia Zaaan gbʋ gbagbɩe bhli nyɩma duun -yla. Ɔ nɛɛ: «Lɛɛ -lu a mnɩ ylaa da bɛblɛɛa? Gblee -we -pɩpɛ mɩa zukluda, mʋ -wa yɩ? -Ɩnnya! ");
INSERT INTO kyf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Ɩn lɛɛ -lu a mnɩ -slɛɛn -mɔ ylaa? Nyɩmɛ -ɔ kaa -bana 'nanʋʋ 'wʋ, mɔ -wa yɩ? Nɩɩ, nyɩma -wa kaa -bana -zɔnʋ 'wʋ, nyɩmaa 'wlulapɩlɩnyɔɔ -buduŋwɛɛ wa mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","We -ka 'sa -mɩ, lɛɛ -lu a mnɩ -mɔ ylaa tɛnyɩɩa? -Lagɔgbʋʋ -falɩpanyɔ -wa yɩ? Ɩɩn, ɩn nɛɛ aɩn -ylaɛ: ɔ 'yli, ɔ -zi -Lagɔgbʋʋ -falɩpanyɔɔ 'dɛgbolu. ");
INSERT INTO kyf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nɩɩ, -Lagɔ nɛɛ ɔ 'sɛbhɛ 'wʋ Zaaan daɛ: ‹-Mɩ 'yu na paa na tietienyɔ yoo, ɔ 'ka -na 'yoo -yɔmnazɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩma -wa 'ŋwnɩ gwalɩa, wa glaa, nyɩmɛ -ɔ 'kaa 'yli, ɔ 'ka 'Zan -Batisɩ -zi, -mɔɔ -kanyɔ 'nɩ -mɩ. We mɩ 'sa 'bhie, nyɩmɛ -ɔ mɩa 'kienyi -lɛ -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ, -mɔɔ 'yli ɔ 'ka Zaan -zi. ");
INSERT INTO kyf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","We 'ka 'Zan -Batisɩɩ -Lagɔgbʋ -gba bhla 'bhʋ we 'ka -zɛɛn ylɩ, *-Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ 'yugbɛɩn mnɩda 'tɩtɛ nya, 'ɩn nyɩma 'tɩtɛ bhua we 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","We 'ka Zaaan bhla nyni, -Lagɔgbʋʋ -falɩpanya weee -yɔ Moizɩɩ tite weee, -Lagɔɔ nyɩmaa 'wlulapɩlɩe gbʋ wa gbaa. ");
INSERT INTO kyf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A -ka na wɛlɩ 'wʋŋwnu, ɔɔ *Elii -ɔ -Lagɔsɛbhɛ gbaa nɩɩ, yia ɔ yia, Zaan -wa. ");
INSERT INTO kyf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we. ");
INSERT INTO kyf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Nyɩma -mama ɩn 'ka dɛslɛɛn -nyɩma nɩ 'wʋpalɩa? Wa 'wlʋ sa 'ylaasɩ -wa -dɩ -gblɔgblʋ 'wʋ la, -zugba tɔlʋa kpɩ 'wʋ wa -lima -yla, ");
INSERT INTO kyf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'ɩn wa gbaɛ: ‹-A ka aɩn -yla -lili bhlɩ, a 'nɩ lɩtɛ. 'Ɩn -a ka aɩn -yla guzɔlʋʋ bhlɩ, 'ɩn a 'nɩ -bhalɩ!› ");
INSERT INTO kyf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'Sa Zaan yia, ɔ ka 'sun pla, ɔ 'nɩ nʋ 'ma, 'ɩn wa nɛɛ nɩɩ, ɔ ka zuzu 'nyuu 'bɩ! ");
INSERT INTO kyf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nyɩmɛɛ 'Yu yia, ɔ mɩ lida, ɔ mɩ 'mada, 'ɩn wa nɛɛ: ‹A -talɩ, nyɩmɛ mɩa dɛ, liligbʋ -yɔ nʋmagbʋ ɔ kaa. Nɩɩ, *nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan, wa 'tale ɔ -mɩa.› Nɩɩ, -Lagɔɔ gbʋyiloo lɛnʋgbʋnya -yɔ wa yibhelia we 'ji nɩɩ, we tɩklɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Gbe -we 'wʋ ɔ nʋa gwɛdigbʋ lɛ, 'ɩn wa 'nɩa wa dlɩ 'bhiti, 'ɩn ɔ yia wa -yla gbʋ lapalɩe bhli: ");
INSERT INTO kyf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kolazɛn -nyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Bɛtɩsaida -nyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Nɩɩ, gwɛdigbʋ -Lagɔ nʋa da lɛ aɩn nyɩdɩ, we 'ka 'yaa 'mʋ ɔ nʋ lɛ Tilɩ -yɔ Sidɔɔn, -zugba wa ka wa dlɩ 'bhiti pepe, 'ɩn wa plaa -gbɛnaa 'wʋ, 'ɩn wa slua 'tʋtɔ 'wluo, mʋ yia we slolua mnɩa. ");
INSERT INTO kyf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","We 'dɛɛ 'gbʋ ɩn nɛɛ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, amɩaa -nʋ ɔ yia 'wʋbhua we 'ka Tilɩ -yɔ Sidɔɔɔn -nʋ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amɩa, Kapɛnaumʋ -nyɩma, amɩaa dlɩ 'wʋ nɩɩ, 'wʋ a yia -sɔa yalɩ yɩ? -Ɩnnya, we 'nɩ -mʋʋ, zɔ -Lagɔ yia aɩn bɛlɩa, tlɩtlɩnyaa dʋdʋ -gʋ. We -ka nɩɩ, gwɛdigbʋ ɩn nʋa da aɩn nyɩdɩ lɛ, mʋ nʋ Sodɔmʋ lɛ, wa 'na 'ka 'yaa labhʋ, -zugba wa mɩ -zɛɛn -bha. ");
INSERT INTO kyf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","We 'dɛɛ gbʋ ɩn nɛɛ zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, amɩaa -nʋ ɔ yia 'wʋbhua we 'ka *Sodɔmʋ -nyɩmaa -nʋ 'wʋzi.» ");
INSERT INTO kyf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","-Mʋʋ 'bɩgʋ, 'ɩn -Zezu nɛɛ: «Dide, -na 'ŋnɩ na mnɩnɩa, yalɩ -yɔ dʋdʋʋ -Kanyɔ, ɩn 'pa -mɩ fuo. -We ka gbʋ -wa, -lu -we -ɩn zizea gbʋyilonya -yɔ 'ylimnanya kwɛɛ, 'mʋ -ɩn -slolua 'nyɛnyɛyua 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gbʋzɔnʋ -wa, Dide, -na 'dɛ 'yɩbhaa we -mɩ 'sa. ");
INSERT INTO kyf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Nɩɩ, na Dide ka 'mɩ -lu weee 'nyɛ. Ɔɔ Yu mɩa, we 'nɩ ɔ Dide 'dɛbhlogbɔɔ 'wʋbhʋ, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ -yi. 'Ɩn ɔɔ Dide mɩa, we 'nɩ ɔ 'Yu 'wʋbhʋ, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ -yi. Nɩɩ, nyɩma -wa ɔɔ 'Yu -slolua ɔ Dide, ma -yia ɔ. ");
INSERT INTO kyf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«A 'dɛ weee kaa da 'gba 'kadɩ 'wlu, a yi na -gbɛ ɩn 'ka aɩn nyapɛda 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","-We ɩn 'bhua 'wʋ, amɩa 'bhu 'ya we 'wʋ, 'ɩn ɩn 'ka aɩn gbʋ -slolu. Nɩɩ, na dlɩ -dlɔɔ, 'ɩn ɩ'ɩn 'ylimanɩ na 'dɛ. -Bha a yia amɩaa 'dɛɛ 'wʋtʋtʋe -dlɔɔ 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa na yia aɩn 'yugalɩa, we 'nɩ 'tɛ, 'ɩn 'gba na yia aɩn 'wlu dɩa we 'nɩ 'wʋwɔlʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","-Mʋʋ 'bɩgʋ, Zuifʋʋ *Nyapɛylɩ yabhlo nya, -Zezu 'plɩlɩa blekpaa, 'ɩn ŋwɔ yia ɔ 'bɩnɔnya 'bha, 'ɩn wa yia bleya 'kwa wa 'ka we li. ");
INSERT INTO kyf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","-We wa mɩa lɛnʋda, Falizɩnyɩma 'yɩa we -yɔ, 'ɩn wa nɛɛ -Zezu -ylaɛ: «-Talɩ, -we -amɩaa tite gbaa wa 'na nʋnʋ Nyapɛylɩ nya lɛ -nɩ, 'mʋ -na 'bɩnɔnya nʋa lɛ!» ");
INSERT INTO kyf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","-Zezu nɛɛ wa -yla: «'Ylɩ yabhlo nya, da ŋwɔ mɩa *-Davidɩ -yɔ ɔ nɔnɔnya 'bhada, -we ɔ nʋa lɛ, a 'nɩ -slɔ we zɛlɩɩ? ");
INSERT INTO kyf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Ɩn ɔ yia -Lagɔɔ bʋbɔbudu zɔ pla, 'ɩn 'floo -we wa 'nyɛa -Lagɔ, 'ɩn ɔ -yɔ ɔ nɔnɔnya 'sɔ yia we li. Nɩɩ, wee 'floo mɩa, -Lagɔɔ tite nɛɛ wa 'nɩ mneni wa 'ka we li: *-Lagɔbʋbɔnyaa 'dɛkpʋa 'ka yaa we li. ");
INSERT INTO kyf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","We mɩ cɛlɩda Moizɩɩ tite 'wʋ nɩɩ, Nyapɛylɩ nya, -Lagɔbʋbɔnya -ka lubho nʋ *-Lagɔbudu 'kadʋ zɔ, -we wa 'na 'ka yaa lɛnʋ, a 'nɩ -slɔ we zɛlɩ nɩɩ, -Lagɔ 'na 'ka wa -yɔgbʋ 'wʋbhuu? ");
INSERT INTO kyf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nɩɩ, -we mɩa -seli we -zi -Lagɔbudu 'kadʋ! ");
INSERT INTO kyf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-We ɩn 'yɩbhaa, mʋ -wa nɩɩ, nyɩma 'ka nyazɩdlɩ -ka, we 'nɩ 'slaka -sasɩe.› «A -ka yaa we 'wʋlanʋ, a 'na 'ka yaa nyɩma -wa 'nɩa gbʋnyuu lɛnʋ gbʋ -dɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nɩɩ, Nyɩmɛɛ Yu mɩa, mɔ -wa Nyapɛylɩɩ -Kanyɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","-Zezu 'bhʋa -bha, 'ɩn ɔ yia *-Lagɔbudu zɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɩɩ, nyɩmɛ yabhlo mɩa -bha, ɔ sɔ ka 'ku. -Wa mɩa -bha, wa 'yɩbha wa 'ka -Zezu gbʋ 'wlu dɩ. We 'dɛɛ 'gbʋ wa yia ɔ layɩbhaɛ: «-Amɩaa tite nʋkplɛ, 'lee, nyɩmɛ mneni ɔ 'ka guzʋnyɔ jipe Nyapɛylɩ nyaa?» ");
INSERT INTO kyf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","-Zezu nɛɛ: «Aɩn glaa, nyɩmɛ yabhlo -ka bhlabhlɛ -bhlo -ka nɩ, 'ɩn we -ka 'wʋtɔlɔ -bhʋka 'wʋbho Nyapɛylɩ nya nɩ, -mɔ ɔ yia we -saa, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nɩɩ, nyɩmɛ mɩa, ɔ 'ylilo -zi bhlabhlɛ. We -ka 'sa -mɩ, nyɩmɛ mneni ɔ 'ka gbʋzɔnʋ lɛnʋ Nyapɛylɩ nya amɩaa tite 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Ɩn -Zezu nɛɛ -ɔ ka sɔ 'kua -yla: «-Glo -na sɔ 'wʋ.» Ɔ -gloa we 'wʋ, 'ɩn we yia 'pʋ, 'ɩn we yia 'wʋtʋ we -libheyi 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Falizɩnyɩma mɩa wa glaa, wa 'tlaa, 'ɩn wa yia gbʋ zʋa mnɩ, sa wa 'kaa -Zezu lasa, we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","-Zezu 'nʋa we, 'ɩn ɔ yia -bha 'bhʋ. -Slɛɛn -Zezu mnɩa, 'ɩn nyɩma duun yia ɔ 'bɩ mnɩ. Ɔ jipea guzʋnya weee, ");
INSERT INTO kyf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'ɩn ɔ nɛɛ wa -yla 'klʋ 'cɩcɩ nya nɩɩ, -ɔ ɔ -mɩa, wa 'na gbalɩ we -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'Sa we 'plɩa sa, 'ɩn -we -Lagɔgbʋʋ -falɩpanyɔ Ezaii gbaa, we 'ka gbʋzɔnʋ -zɛ. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nɩɩ, -Lagɔ nɛɛ: ‹Na lubhonʋnyɔ ɩn -saa -bha, mɔ nɩ. Ɔ zɛ ɩn -kalɩa, 'mɔ ɩn 'nyɛa na dlɩ weee yoo. 'Mɔ na yia na Zuzu 'nyɛa. Sa ɩn 'kaa nyɩmaa -yɔgbʋ 'wʋbhu, we gbʋ ɔ yia dʋdʋgʋ -nyɩma weee -yla lapalɩa. ");
INSERT INTO kyf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ -yɔ nyɩmɛ 'na 'ka kpɛlɩ. 'Ɩn ɔ 'na 'ka 'wʋkpɩ, 'ɩn nyɩmɛ yabhlogbɔɔ 'na 'ka ɔ wɛlɩ 'nʋ 'yloogblʋ. ");
INSERT INTO kyf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gblee -we mɩa 'wʋkwnada, ɔ 'na 'ka we 'kate, 'napɛ -we ka mɩɔ 'nɩa layɩda -mɩ 'nanʋʋ, ɔ 'na 'ka we nyumonu. 'Sa ɔ yia nʋa 'ɩn nyɩma 'ka na gbʋzɔnʋ gbʋ 'wʋŋwnu. ");
INSERT INTO kyf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dʋdʋgʋ -nyɩma weee yia ɔ dlɩ 'wʋdɩa.› » ");
INSERT INTO kyf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nɩɩ, 'lɔlɔ -bhobho yabhlo -ɔ zuzu 'nyuu mɩa 'wʋ, 'mɔ wa -laa -Zezu. -Zezu jipea ɔ, 'ɩn ɔɔ bhobho yia gba, 'ɩn ɔ yia layɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","We -sʋbhalɩa nyɩma weee ŋwɛgaga, 'ɩn wa nɛɛ: «Ɔɔ mɩa da nɩ, 'lee -Davidɩɩ 'yu ɔ -mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nɩɩ, Falizɩnyɩma 'nʋa we, wa nɛɛ: «Ɔɔ nyɩmɛ mɩa da nɩ, we 'nɩ zuzu 'nyiii -kanyɔ Bɛlɩzebulɩ 'nyɛ ɔ 'tɩtɛ nɩ, ɔ 'nɩ mneni ɔ 'ka zuzu 'nyii vu.» ");
INSERT INTO kyf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","-We wa pʋpalɩa 'wlukʋʋn la, -Zezu -yi we, we 'gbʋ ɔ nɛɛ: «Dʋdʋ -we ka -gʋ -nyɩma -ka tʋgʋda -mɩ wa 'dɛkpʋa nyɩdɩ, la wee dʋdʋ bhʋa. -Budu -bhlo ŋwɛɛ -nyɩma -yɔ 'gbe -bhlo 'wʋ -nyɩma -ka -yɔwʋsʋsɔlʋda -mɩ, we 'na 'ka -gwlɛ. ");
INSERT INTO kyf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","*-Saatan -ka -Saatan vu, we 'dɛ -yɔ we -sɔlʋa 'wʋ, we -ka 'sa -mɩ, we 'na 'ka -gwlɛ. ");
INSERT INTO kyf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amɩa nɛɛ Bɛlɩzebulɩ nyɛa 'mɩ see 'gbʋ, na vua zuzu 'nyii. We -ka 'sa -mɩ, nyɔɔ 'nyɛ amɩaa -lima se, 'ɩn wa vu zuzu 'nyiia? We 'gbʋ, amɩaa -limaa 'dɛbhiee lɛnʋgbʋ slolua nɩɩ, -we a gbaa, yo -wa. ");
INSERT INTO kyf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","-We -wa gbʋzɔnʋ, mʋ nɩ: nɩɩ, -Lagɔɔ Zuzuu 'tɩtɛ nya na vua zuzu 'nyii, -mʋʋ 'ji -wa nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ aɩn nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Nɩɩ, wa 'nɩ -slɔ latɛlɔnyɔ gbʋan, wa 'nɩ mneni wa 'ka ɔ -budu zɔ pla, wa 'ka ɔ 'gba labhu. Wa -ka ɔ gbʋan, 'bhie wa plaa ɔ -budu zɔ, 'ɩn wa bhua ɔ zʋzɔnʋ la. ");
INSERT INTO kyf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Nyɩmɛ -ɔ -yɔ 'mɩ 'nɩ -mɩ, na tʋnyɔ -wa. Nyɩmɛ -ɔ'ɔ -saa 'mɩ 'wʋ -a 'ka nyɩma -yɔbɩbɛlɩ, nyɩmaa lamumninyɔ ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","We 'dɛɛ 'gbʋ ɩn nɛɛ aɩn -ylaɛ: -Lagɔ yia gbʋnyuu weee -yɔ vɛlɩlɩ weee 'wʋtɩa. Nɩɩ, nyɩmɛ -ɔ -ka -Lagɔɔ Zuzu vɛlɩ, -Lagɔ 'na 'ka ɔ -yɔgbʋ 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nyɔɔ -ka *Nyɩmɛɛ 'Yu daa gbʋnyuu gbaa, -mɔɔ -yɔgbʋ -Lagɔ tɩa 'wʋ. Nɩɩ, nyɩmɛ -ka Zuzu 'Pʋpa daa gbʋnyuu gbaa, we 'dɛ yi dɛslɛɛn -zɛoo, we 'dɛ yi bhla -we mɩa yida nya -zɛoo, -Lagɔ 'na 'ka ɔ -yɔgbʋ 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Su -zɔnʋ paa 'bhue -zɔnʋ, 'ɩn su 'nyuu paa 'bhue 'nyuu. Suu 'bhue -yɔ wa yibhelia wee su. ");
INSERT INTO kyf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Amɩa mɩa dɛ, 'mʋnɩmɛ a -mɩa, a mneni a 'ka gbʋzɔnʋ gbaa? -Ɩnnya. -Lu -we yea nyɩmɛɛ dlɩ -zɔ, mʋ tlaa ɔ ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nyɩmɛ -zɔnʋ mɩa, ɔ gbʋzɔnʋ mɩa ɔ dibhe 'wʋ, 'mʋ ɔ wlelia. 'Ɩn nyɩmɛ 'nyuu mɩa, ɔ gbʋ 'nyuu mɩa ɔ dibhe 'wʋ, 'mʋ ɔ wlelia. ");
INSERT INTO kyf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ɩn nɛɛ aɩn -ylaɛ: wɛlɩ weee -we nyɩma yia gbaa, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, we 'ji wa yia gbaa. ");
INSERT INTO kyf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nɩɩ, -na gbagbawɛlɩ -gʋ, -Lagɔ yia -mɩ gbʋ dɩlɩa. 'Ɩn we -gʋ -na yia gbʋ 'wʋtlaa.» ");
INSERT INTO kyf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tɔʋn -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma nɛɛ -Zezu -yla: «-Slolunyɔ, -ɩn nʋ gwɛdigbʋ yabhlo lɛ, 'ɩn -a 'ka we 'jiyibheli zʋzɔnʋ sa nɩɩ, -Lagɔ tiea -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","-Zezu nɛɛ: «Dɛslɛɛn -nyɩma mɩa, nyɩma 'nyii wa -mɩa, 'ɩn wa'a zʋ -Lagɔ dlɩ -gʋ, 'ɩn wa yɩbhalɩa 'mɩ gwɛdigbʋ. Gwɛdigbʋ yabhlogbɔɔ 'na 'ka wa -yla lɛnʋ, 'mʋ we 'nɩ *Zonasɩɩ gbʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nɩɩ, Zonasɩ ka zlɩ ta sabɔ ta li, zibhi nʋkplɛ. 'Sa -bhlokpadɛ Nyɩmɛɛ 'Yu yia gwlu zlɩ ta sabɔ ta lia. ");
INSERT INTO kyf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","*Ninivʋ -nyɩma 'nʋa *Zonasɩɩ wɛlɩ, 'ɩn wa yia wa dlɩ 'bhiti. Nɩɩ, nyɩmɛ -ɔ 'ylia -ɔ -zia Zonasɩ, ɔ mɩ da. We 'dɛɛ 'gbʋ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, 'ɩn Ninivʋ -nyɩma sɔa 'wʋ dɛslɛɛn -nyɩma 'yu, 'ɩn wa dɩlɩa -maa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sebaa 'wlulapɩlɩŋwnɔ 'bhʋa dʋdʋʋ bhloluda, 'ɩn ɔ yia *Salomɔɔɔ gbʋyilo wɛlɩ yukwli pʋlʋa yi. Nɩɩ, nyɩmɛ -ɔ -zia Salomɔɔ, ɔ mɩ da. We 'dɛɛ 'gbʋ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, 'ɩn ɔɔ 'ŋwnɔ sɔa 'wʋ dɛslɛɛn -nyɩma 'yu, 'ɩn ɔ dɩlɩa -maa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Nɩɩ, zuzu 'nyuu 'tlaa nyɩmɛ yabhlo 'wʋ, we mnɩ, we yi, -mɔ yɛyɛ da, ladɩdaa datalɩe nya, we 'ka ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","We 'nɩ da 'yɩɩ 'gbʋ, we nɛɛ we 'dɛ -ylaɛ: ‹Na -budu we zɔ ɩn 'bhʋa, -mɔ na bhitia lʋ.› We 'bhitia -mɔ lʋ, 'ɩn we yia -bha wee -budu ylɩ klo nya, -zugba we nʋkplɛ mɩ laylipeda, 'ɩn -mɔ mɩ lamnazɩda. ");
INSERT INTO kyf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tɔʋn, zuzu 'nyii gbesɔ ka nʋkplɛ -nyua 'yli bhabha, -we -zia wemʋ, 'ɩn we yia -mʋʋ 'bʋmnɩ. 'Ɩn we -yɔ we 'sɔ yia wee -budu zɔ lʋyi, dabʋdʋ. 'Ɩn we yia -mɔ ladɩ duaa. -Slɛɛn, 'ɩn ɔɔ nyɩmɛɛ -kwɩkwɩ yia 'ylinyumanɩ, 'ɩn we yia we tɩanʋ 'wʋzi. Dɛslɛɛn -nyɩma -wa ka nʋkplɛ 'nyua 'yli, we 'sasʋkpa -gbʋ yia wa ylɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Da -Zezu mɩa nyɩma -yla gbʋ gbada nɩ, 'ɩn ɔ 'nyaa -yɔ ɔ bhelia yia yi, 'ɩn wa yia -buduŋwɛɛ 'yligbe. Wa 'yɩbha wa 'ka ɔ -yla gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Ɩn nyɩmɛ yabhlo nɛɛ ɔ -yla: «-Na 'nyaa -yɔ -na -bhelia mɩ 'pipee, wa 'yɩbha wa 'ka -mɩ -yla gbʋ gba.» ");
INSERT INTO kyf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","-Zezu nɛɛ ɔ -ylaɛ: «Nyɔɔ -wa na 'nyaa, nyɔɔ -wa na bhelia?» ");
INSERT INTO kyf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɔ 'bhua sɔ 'wʋ, 'ɩn ɔ yia ɔ 'bɩnɔnya wa 'klʋslolu. 'Ɩn ɔ nɛɛ: «-Wa mɩa da nɩ, ma -wa na 'nyaa -yɔ na bhelia. ");
INSERT INTO kyf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nɩɩ, -ɔ nʋa na Dide -ɔ mɩa yalɩɩ dʋmagbʋ lɛ, mɔ -wa na bheli, mɔ -wa na bhɔlɔ, mɔ -wa na 'nyaa.» ");
INSERT INTO kyf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wee 'ylɩ -bhlokpadɛ nya, -Zezu 'tlaa -budu zɔ, 'ɩn ɔ yia 'nyuu -gɔgɔ -gʋ ladɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nyɩmaa -zlo ka ɔ gbelii 'gbʋ, ɔ yia 'glʋ 'wʋbho, 'ɩn ɔ yia -mɔ ladɩ, -zugba nyɩmaa -zlo mɩ 'nyuu -gɔgɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gbʋʋ nine nya ɔ -slolua wa gbʋ duun, ɔ nɛɛ: «Nɩɩ, kpaapanyɔ yabhlo mnɩa 'mnɔ 'paa. ");
INSERT INTO kyf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɔ mɩa wee 'mnɔ 'mnida, 'yaa -zakpa -bhlo yia 'yoo ŋwɛ -yɔ bhli, 'ɩn 'zianya yia we li. ");
INSERT INTO kyf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tɔlʋa bhlilia tʋkpa -dʋdʋ -gʋ, da bla 'nɩa -zu. Bla 'nɩ -bha -zuu 'gbʋ, we yia mi sa slʋɩ. ");
INSERT INTO kyf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nɩɩ, 'ylʋ -sɔa 'wʋ, we yia we -sie, 'ɩn we yia yɛ, we somi 'nɩ -tlʋlʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","We 'ya tɔlʋa sloa -kpɔga glaa, 'ɩn -kpɔga yia we -gʋ palɩlɩ, 'ɩn we yia we 'tuntnu. We 'nɩ 'ya yabhlogbɔɔ 'pa. ");
INSERT INTO kyf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tɔlʋa yia dʋdʋ -zɔnʋ -gʋ bhlili, 'ɩn we yia zʋ. We lakpa tɔlʋa wla 'ya glʋ -bhlo 'ya kugbua, tɔlʋa wla 'ya glʋ ta, 'ɩn tɔlʋa wla 'ya glʋ gbu. ");
INSERT INTO kyf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ɔ 'bɩnɔnya bɛa ɔ kwesi, 'ɩn wa yia ɔ layɩbha: «Lɛɛ -lu ka 'gbʋ -na slolu wa gbʋʋ nine -papɩe nya?» ");
INSERT INTO kyf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɔ nɛɛ wa -yla: «-Lagɔ ka ɔ nyɩmaa 'wlulapɩlɩgbʋ mɩa zizeda aɩn 'klʋslolu, nɩɩ, ɔ 'nɩ we wamɩa 'klʋslolu. ");
INSERT INTO kyf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nɩɩ, -lukanyɔ mɩa, ɔ -nʋ wa yia -gʋpalɩa, 'ɩn we 'ka 'wʋzumanɩ. 'Ɩn nyɩmɛ -ɔ 'nɩa -lu duun -ka, we -sɛlɛ mɩa ɔ kwɛɛ, kwɛɛ wa yia we ɔ -saa. ");
INSERT INTO kyf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","«We 'dɛɛ 'gbʋ na gbaa wa -yla gbʋʋ nine -papɩe nya. Wa -ka ylada -mɩ, wa'a 'yɩ la. Wa -ka yukwli pʋda -mɩ, wa'a 'nʋ. Nɩɩ, wa'a 'nʋ gbʋ yabhlogbɔɔ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Sa -we -Lagɔgbʋʋ -falɩpanyɔ Ezaii gbaa, we -zɛa gbʋzɔnʋ wa gbɛgbɛɩn, ɔ nɛɛ: ‹Yukwli a yia pʋa 'nanʋʋ, 'ɩn a 'na 'ka we 'wʋlanʋ. Ylaa a yia 'nanʋʋ, 'ɩn a 'na 'ka -lu -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nɩɩ, waa nyɩma -manɩɩ 'wlukʋʋn ka 'wʋtʋ -dudluu. Wa ka wa yukwli 'sumanɩ, wa ka wa 'yli 'mu, wa yi layɩ, wa yi 'nʋ, wa yi gbʋ yibhelii 'gbʋ, wa yi wa dlɩ 'bhitii 'gbʋ, ɩn yi wa gbʋ 'wʋsa. 'Sa -Lagɔ gbaa.› ");
INSERT INTO kyf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amɩa, amɩaa 'yli yɩ la, 'ɩn amɩaa yukwli nʋa, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -Lagɔgbʋʋ -falɩpanya -yɔ -Lagɔnyɩma tɩklɩɩɩ -zlo 'yɩbha -we a yɩa -yɔ, wa 'ka we -yɔyɩ, 'ɩn wa 'nɩ we -yɔyɩ, -we a nʋa, wa 'ka we 'nʋ, 'ɩn wa 'nɩ we 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«We 'dɛɛ 'gbʋ, amɩa, a 'nʋ mnɔpanyɔɔ gbʋʋ ninee ji nɩ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","-Wa 'nʋa *-Lagɔɔ nyɩmaa 'wlulapɩlɩee wɛlɩ, 'ɩn wa'a 'nʋa we 'wʋla, wa 'wlʋ 'yoo ŋwɛ -yɔ da 'mnɔ bhlia. *Gbʋnyuuu dide -ka yi, -we wa faa wa dlɩ zɔ, 'ɩn we saa -mɔ we. ");
INSERT INTO kyf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","'Sa -bhlokpadɛ tɔlʋa mɩ -bha tʋkpa -dʋdʋ 'bhisa, da -Lagɔwɛlɩ bhlia. 'Ɩn wa -ka we 'nʋ nɩ, 'ɩn wa ŋwnua we gbʋ 'mʋna nya, 'ɩn wee 'mʋna'a -gwlɛ. ");
INSERT INTO kyf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nɩɩ, wa 'nɩ ŋwnu we 'ka somi fa wa dlɩ zɔ. Waa nyɩma mɩa, bhla -sɛlɛ nya wa ŋwnua we -yɔ, 'ɩn wa -ka wa sɩalɩda -mɩ, wa -ka wa 'klɩyɩe 'wʋpalɩda -mɩ -Lagɔwɛlɩɩ 'gbʋ, 'ɩn wa saa -Lagɔwɛlɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tɔlʋa 'wlʋ 'ya 'mnɔya -we -wa -Lagɔwɛlɩ -mɔ -kpɔga glaa. Wa 'nʋa wee wɛlɩ, 'ɩn dʋdʋ -gʋʋ dlɩlʋe klaa, wa 'gwɛzi -we nanɩa wa dʋdʋ, 'ɩn we nʋa wa -dawli 'wʋ klaa, mʋ palɩlɩa we -gʋʋ 'gbʋ, we'e tnʋa. ");
INSERT INTO kyf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'Ɩn nyɩma tɔlʋa mɩa, -maa 'wlʋa wee 'mnɔya -we -wa -Lagɔwɛlɩ -mɔ dʋdʋ -zɔnʋ -gʋ. Wa 'nʋa we, 'ɩn wa yia we -yɔŋwnu. Tɔʋn, wee wɛlɩ -we mɩa wa 'wʋ, 'ɩn we yia tnʋ. We lakpa yabhlo wla 'ya glʋ -bhlo 'ya kugbua, we tɔlʋa 'ya glʋ ta, 'ɩn we tɔlʋa wla 'ya glʋ gbu.» ");
INSERT INTO kyf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","-Zezu 'pa 'yaa wa -yla gbʋʋ nine yabhlo, ɔ nɛɛ: «-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa, 'mʋ na yia da aɩn -yla gbaa. Nɩɩ, nyɩmɛ yabhlo 'paa ɔ kpaa 'mnɔ -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","-Mʋʋ 'bɩgʋ, sabɔ, da nyɩma weee mɩa 'ylaa 'wʋ, ɔ tʋnyɩmɛ yia, 'ɩn ɔ yia -petuu 'ya glʋ wee 'mnɔ -kpaa, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Da wee 'mnɔ mia, 'ɩn we mɩa zʋda, -zugba wee -petu mi 'ya -mɔ we nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Wee kpaa -kanyɔɔ lubhonʋnya yia yi, 'ɩn wa nɛɛ ɔ -ylaɛ: ‹-Amɩaa -kanyɔ, 'lee, -ɩn 'nɩ zlɩmɛ da 'mnɔya -zɔnʋ 'paa? 'Ɩn da -petunya nɩ 'bhʋlʋa?› ");
INSERT INTO kyf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Ɔ nɛɛ wa -ylaɛ: ‹Na tʋnyɩmɛ nʋa we lɛ.› «'Ɩn ɔ lubhonʋnya nɛɛ ɔ -yla: ‹'Lee, -a mneni -a 'ka wee -petu 'tluu?› ");
INSERT INTO kyf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Ɔ nɛɛ: ‹-Ɩnnya, nɩɩ, a -ka wee -petu 'tlua yi, a mneni a 'ka 'mnɔ 'tlu -bha -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A 'tide we 'yi, we 'dɛ 'sɔ 'ka 'ylimanɩ. We -dɩdɩ bhla -ka bɛ, 'ɩn ɩn 'ka we -dɩdɩnya 'tʋlʋ nɩɩ, wa -dɩ -slɔ -petu, wa gbʋan we, 'ɩn wa 'ka we sie. -Mʋʋ 'bɩgʋ, wa 'ka 'mnɔ -dɩ, 'ɩn wa 'ka we na -gbagbʋ 'wʋkwa.› » ");
INSERT INTO kyf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","-Zezu 'pa 'yaa wa -yla gbʋʋ nine yabhlo, ɔ nɛɛ: «-Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wlʋ su -we wa laa *mutadɩ, we 'ya. 'Mʋ nyɩmɛ yabhlo 'bhua 'wʋ, 'ɩn ɔ yia we glʋ ɔ kpaa. ");
INSERT INTO kyf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","We 'kienyi we -zi dʋdʋ -gʋʋ su weee 'ya. Nɩɩ, we -ka mi, 'ɩn we ylimanɩa 'kadʋʋ, 'ɩn we zɛa su -we -zia su weee 'wʋ. Nɩɩ, 'zianya yia we lʋlʋ 'sʋbhaa we 'klɩya -nyɩdɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","-Zezu 'pa 'yaa wa -yla gbʋʋ nine yabhlo, ɔ nɛɛ: «-Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wlʋ *gɔɔ 'ŋwnɔ yabhlo slua 'floo -bhʋbhʋʋ kilo glʋ -bhlo 'ya gbu lʋ, ɔ bhɩtɩa we, 'ɩn we yia 'ylɩ, mʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nɩɩ, gbʋ weee mɩa dɛ, gbʋʋ nine -papɩe nya ɔ -slolua we nyɩmaa -zlo. We 'nɩ gbʋʋ nine -papɩe 'wʋbhʋ, ɔ'ɔ -slolu nyɩma gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","'Sa we 'plɩa sa, 'ɩn -we -Lagɔgbʋʋ -falɩpanyɔ gbaa, we 'ka gbʋzɔnʋ -zɛ, ɔ nɛɛ: «Nɩɩ, gbʋʋ nine -papɩe nya na yia wa -yla gbʋ gbaa. We 'ka dʋdʋʋ gwedɩda 'bhʋ, gbʋ -we -Lagɔ zizea, gbaa na yia we.» ");
INSERT INTO kyf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tɔʋn, -Zezu 'bhʋa nyɩma glaa, 'ɩn ɔ yia -buduŋwɛɛ mnɩ. Ɔ plaa -budu zɔ, 'ɩn ɔ 'bɩnɔnya yia ɔ kwesi bɛ, 'ɩn wa nɛɛ ɔ -ylaɛ: «Gba -aɩn -yla kpaa -petu 'nyuu nɩɩ gbʋʋ ninee 'ji.» ");
INSERT INTO kyf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ɔ nɛɛ wa -ylaɛ: «Nɩɩ, -ɔ 'paa 'mnɔya -zɔnʋ, Nyɩmɛɛ Yu -wa. ");
INSERT INTO kyf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","'Ɩn kpaa mɩa, mʋ -wa dʋdʋ -gʋ, 'ɩn 'mnɔya -zɔnʋ mɩa, mʋ -wa nyɩma -wa -Lagɔ pɩlɩa 'wlu la. -Petu mɩa, mʋ -wa nyɩma -wa gbʋnyuuu dide pɩlɩa 'wlu la. ");
INSERT INTO kyf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɔɔ tʋnyɩmɛ -ɔ glʋa wee -petu, -Saatan -wa. We -dɩdɩ bhla mɩa, -mʋʋ -wa dʋdʋʋ bhɩalɩ da. We -dɩdɩnya mɩa, -mʋʋ -wa 'anzɩnya. ");
INSERT INTO kyf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sa wa tlua -petu, 'ɩn wa vitelia we -kosu 'wʋ, 'sa -bhlokpadɛ we yia dʋdʋ -bhɩa bhla -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɔɔ Nyɩmɛɛ Yu yia ɔnʋʋ 'anzɩnya yoo 'paa. Nɩɩ, -wa kwaa wa -lima gbʋnyuu lʋ we -yɔ -wa ka dɛ nʋa gbʋnyuu lɛ, we 'ka wa 'wʋgbɩzɩ, -wa -Lagɔ pɩlɩa 'wlu la glaa. ");
INSERT INTO kyf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","'Ɩn we 'ka wa -kosu 'kadʋ 'wʋ viteli. -Mɔ wa wia, -mɔ wa lia gla 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","-Wa nʋa -Lagɔɔ dʋmagbʋ lɛ, ma yia lɩa 'ylʋ 'bhisa da wa Dide pɩlɩa nyɩma 'wlu la. -Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we. ");
INSERT INTO kyf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa mʋ -wa 'ŋnɩmnɩlu yabhlo -we mɩa zizeda kpaa. 'Mʋ nyɩmɛ yabhlo 'yɩa, 'ɩn ɔ yia we zize lʋ. Ɔ plɛ mɛnɩ, 'ɩn ɔ mnɩa, ɔ yia ɔ -lu weee pɛlʋ 'pa ɔ 'ka wee kpaa zɔ. ");
INSERT INTO kyf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa, mʋ -wa 'ya, -valɛpanyɔ -ɔ mɩa tʋkpa -zɔnʋ -we ka -valɛ 'tɛaa datalɩda. ");
INSERT INTO kyf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɔ 'yɩa wee 'ylinanʋ -tʋkpa, -we ka -valɛ 'tɛa -we -zia we -lima nɩ, ɔ mnɩa, 'ɩn ɔ yia ɔ -lu weee pɛlʋ 'pa ɔ 'ka we zɔ. ");
INSERT INTO kyf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlua, mʋ -wa 'ya, 'sowli -we wa viteli 'nyu lʋ, 'ɩn we yi zibhii 'yli -bhlo -bhlo kpa. ");
INSERT INTO kyf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","We yea, 'ɩn zibhibhanya yia we 'nyu lʋ gbize, 'ɩn wa yia we 'nyu -gɔgɔ -gʋ ladɩ, wa 'ka zibhi 'wʋgbɩzɩ. We zʋzɔnʋ wa gbɩzɩa 'wʋ, -mʋʋ wa slua wa -cɩcɛ 'wʋ, 'ɩn -we 'nɩa 'ylinanɩ, 'ɩn wa yia we kwnɛɛ viteli. ");
INSERT INTO kyf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Sa -bhlokpadɛ we yia -mɩa dʋdʋʋ bhɩa zlɩ. Nyɩma -wa nʋa gbʋnyuu lɛ -yɔ -wa nʋa gbʋ -zɔnʋ lɛ, 'anzɩnya yia yia we 'ka wa -yɔsɩsalɩ, ");
INSERT INTO kyf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'ɩn -wa nʋa gbʋnyuu lɛ, we 'ka -maa -kosu 'kadʋ 'wʋ viteli. -Mɔ wa yia wilia, -mɔ wa yia gla 'wʋ lia.» ");
INSERT INTO kyf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","-Zezu nɛɛ ɔ 'bɩnɔnya -yla: «A ka we 'dɛ weee 'wʋlanʋʋ?» Wa nɛɛ: «Ɩɩn, -a ka we 'wʋlanʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tɔʋn, -Zezu nɛɛ wa -yla: «Nɩɩ, -Lagɔɔ titee gwesanyɔ -ɔ yibhelia -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ, ɔ 'wlʋ nɩɩ, -buduŋwɛɛ -kanyɔ yabhlo -ɔ wleli 'ŋnɩmnɩlu sʋa -yɔ 'ŋnɩmnɩlu lolu, ɔ -luu lazʋda.» ");
INSERT INTO kyf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","-Zezu ka gbʋʋ nine -papɩe bhɩa 'bhie, ɔ yia -bhadɛ 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'Gbe -we 'wʋ ɔ 'ylimanɩa, ɔ mnɩa -mɔ, 'ɩn ɔ yia nyɩma -slolu -mɔ -Lagɔbudu zɔ. -Wa weee mɩa -bha, 'ɩn we yia wa ŋwɛgaga -sʋbhalɩ. 'Ɩn wa nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","«Ɔɔ nyɩmɛ mɩa da nɩ, -budukʋnyɔɔ yu -wa, we 'nɩ mʋʋ? Ɔ 'nyaa mɩa nɩ, Malii -wa. *'Zake klaa, *-Zɛzɛfʋ klaa, 'Simɔɔ klaa, we -yɔ Zudɩ, wa 'nɩ ɔ bheliaa? ");
INSERT INTO kyf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ɔ bhɔlɔa mɩ -aɩn glaa. Aya! Mɔ ɔ -salɩ gwɛdigbʋ lɛnʋ sea?» ");
INSERT INTO kyf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","We 'dɛɛ 'gbʋ, wa 'nɩ mneni wa 'ka ɔ dlɩ -gʋ zʋ. Tɔʋn, -Zezu nɛɛ wa -yla: «-Lagɔgbʋʋ -falɩpanyɔ -ka -mɩ, da weee wa zʋa -bha ɔ. Wa'a zʋ -bha ɔ, ɔ -zɔɔ we -yɔ ɔ -buduŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nyɩma 'nɩ ɔ dlɩ -gʋ zʋʋ 'gbʋ, ɔ 'nɩ -bha gwɛdigbʋ duun lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","We bhla, Galilee -dʋdʋʋ 'wlulapɩlɩnyɔ Ewlodʋ 'nʋa -Zezuu 'dɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ɔ nɛɛ ɔ zɔlubhonʋnya -yla: «'Zan -Batisɩ -wa! Nɩɩ, mɔ -sɔa tlɩtlɩnya glaa 'wʋ, we 'dɛɛ 'gbʋ ɔ mnenia ɔ 'ka gwɛdigbʋ lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nɩɩ, sa Zaaan tlɩtlɩgbʋ 'plɩa, mʋ mɩa da: Ewlodʋ kwaa ɔ bheli Filipʋʋ 'ŋwnɔ Ewlodiadɩ, 'ɩn Zaan nɛɛ ɔ -yla: «Nɩɩ, we 'nɩ 'ylinanɩ -Lagɔɔ tite 'wʋ, nyɩmɛ 'ka ɔ 'dɛɛ bheli 'ŋwnɔ glosa, 'ɩn ɔ 'ka ɔ kwa.» We 'dɛɛ 'gbʋ Ewlodʋ yia nyɩma tie, wa 'ka ɔ kpa, wa 'ka ɔ gbʋan, 'ɩn wa 'ka ɔ -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ewlodʋ 'yɩbha ɔ 'ka Zaan 'bha. Nɩɩ, ɔ mɩ Zuifʋ sɔda, -maa nɛɛ nɩɩ, Zaan mɩa, -Lagɔgbʋʋ -falɩpanyɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nɩɩ, Ewlodʋʋ gwalɩylɩɩ 'fɛtɩ nynia, 'ɩn Ewlodiadɩɩ 'ŋwnɔyu yia -wa mɩa 'fɛtɩ -gʋʋ 'yibadɩ lɩtɛ. 'Ɩn ɔ yia Ewlodʋ dʋdʋ namanɩ bhabha. ");
INSERT INTO kyf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Ɩn ɔ yia bi, ɔ nɛɛ: «-We a yia 'mɩ -zlalɩa, yoo na yia we aɩn 'nyɛa.» ");
INSERT INTO kyf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɔ 'nyaaa wɛlɩ -gʋ ɔ nɛɛ: «-Ɩn 'nyɛ 'mɩ 'Zan -Batisɩɩ 'wlu yoo -plaa -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","We wlaa Ewlodʋ 'kʋayli la, nɩɩ, ɔ ka bi ɔ -limaa 'yibadɩɩ 'gbʋ, ɔ nɛɛ: «-We ɔ -zlalɩa 'mɩ, a 'nyɛ we ɔ yoo.» ");
INSERT INTO kyf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Ɩn ɔ yia 'slʋjayu yabhlo tie -mɔ -kaslʋ 'wʋ, ɔ 'ka Zaan 'wlu -gʋ -dɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Ɩn wa -yɔ ɔ 'wlu yia yi -plaa -gʋ. Wa 'nyɛa we ɔɔ 'ŋwnɔyu yoo, 'ɩn -mɔɔ yia we ɔ 'nyaa yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tɔʋn, Zaaan 'bɩnɔnya yia, 'ɩn wa yia ɔ 'kwie 'bʋmnɩ, 'ɩn wa yia we 'bhʋka 'wʋfa, 'ɩn wa yia we 'dɩ -Zezu -salɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","-Zezu 'nʋa we 'dɩ, 'ɩn ɔ yia 'glʋ 'wʋbho, ɔ -dɩa 'nyu 'wʋ, 'ɩn ɔ yia da bɛblɛɛ mnɩ, da nyɩma 'nɩa -mɩ, ɔ 'ka 'wʋnya. Nyɩmaa -zlo 'nʋa we, wa 'tlaa wa 'gbe nʋkplɛ, 'ɩn wa yia ɔ 'bɩ mnɩ bhʋ -gʋ, 'nyu -gɔgɔ -gʋ yilie nya. ");
INSERT INTO kyf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","-Zezu 'tlaa 'glʋ 'wʋ, ɔ 'yɩa nyɩmaa -zlo -yɔ, 'ɩn wa yia ɔ nyazɩ 'wʋla, 'ɩn ɔ yia wa guzʋnya jipe. ");
INSERT INTO kyf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jibhe zɔa, ɔ 'bɩnɔnya bɛa ɔ kwesi, 'ɩn wa nɛɛ: «'Ylʋ ka -fla, 'ɩn da tlʋlʋ la. We 'dɛɛ 'gbʋ, 'nyɛ wa 'yoo wa 'ka 'gbenya 'wʋ lililu zɔa mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɔ nɛɛ wa -yla: «Wa 'na 'ka mnɩ. Amɩaa 'dɛ 'nyɛ wa lililu.» ");
INSERT INTO kyf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Ɩn wa nɛɛ: «We 'nɩ 'floo gbu -yɔ zibhii 'ya 'sɔ 'wʋbhʋ, -a 'nɩ lililu kwɛɛ -ka.» ");
INSERT INTO kyf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Ɩn ɔ nɛɛ: «A -yɔ we yi.» ");
INSERT INTO kyf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","-Mʋʋ 'bɩgʋ, ɔ nɛɛ nyɩmaa -zlo -yla nɩɩ, wa -dɩ -petu -gʋ la. Tɔʋn, ɔ bhua wee 'floo gbu -yɔ zibhii 'ya 'sɔ 'wʋ, ɔ ylaa yalɩ, 'ɩn ɔ yia -Lagɔ fuo 'pa. 'Bhie, ɔ dlilia wee 'floo, ɔ 'nyɛa we ɔ 'bɩnɔnya yoo, 'ɩn -maa yia we nyɩma 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wa 'dɛ weee lia, 'ɩn wa yia lʋ. We pnɩɩ -tʋa 'wʋ, -we nynia -cɩcɛ kugbua lɛ 'sɔ, 'ɩn ɔ 'bɩnɔnya -yɔ we yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyɩma -wa lia, wa nyni nʋkpasiaa 'wlu glʋ -bhlo 'wlu gbu (5.000). Wa 'nɩ 'ŋwnɩ -yɔ 'nyɛnyɛyua zɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tɔʋn, 'ɩn -Zezu yia wa tie, wa -galɩ ɔ 'yu, wa 'ka 'nyuu kakpe -putu -gʋ mnɩ, -zugba ɔ pa nyɩma wɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ɔ 'paa wa wɛlɩ, 'ɩn ɔ yia -gɔgɔ 'wlu mnɩ ɔ 'ka -Lagɔ bhubhoe. Ɔ mɩ -bha ɔ 'dɛ -bhlo, 'ɩn sabɔ yia bɛ. ");
INSERT INTO kyf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nɩɩ, 'glʋ ka -slɛɛn -gɔgɔ -yɔ la tlʋmanɩ. -Pɩpɛ mɩ wa 'klʋ -yɔ -gbɛɩn bhʋlʋdaa 'gbʋ, 'nyuu -gbʋgbʋ sloa 'glʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tɩatɩa -kʋkɔ gboa, 'ɩn -Zezu yia ɔ 'bɩnɔnya 'bɩ mnɩ 'nyu -gʋ -nɔnʋe nya. ");
INSERT INTO kyf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wa 'yɩa da ɔ -yɔ -nɔda -mɔ 'nyu -gʋ, 'ɩn wa yia nyanɔ nʋ, wa nɛɛ: «'Kuzu -wa!» Wa mɩ nyanɔ nʋdaa 'gbʋ, wa yia 'wʋkpɩ. ");
INSERT INTO kyf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɔʋn, 'ɩn ɔ nɛɛ wa -yla: «A 'na nʋnʋ nyanɔ -nɩ, -amɩ -wa, a palɩ dlɩ la.» ");
INSERT INTO kyf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Ɩn Piɛlɩ nɛɛ: «Na -Kanyɔ, we -ka -mɩ 'piɛɩn, 'nyɛ 'mɩ 'yoo, ɩn 'ka 'nyu -gʋ nɔ, ɩn 'ka -mɩ -yɔbɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ɔ nɛɛ ɔ -yla: «Yi!» Piɛlɩ 'tlaa 'glʋ 'wʋ, 'ɩn ɔ yia -Zezuu -gbɛ mnɩ 'nyu -gʋ -nɔnʋe nya. ");
INSERT INTO kyf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nɩɩ, ɔ 'yɩa -pɩpɛ mɩ 'plɩda, 'ɩn ɔ yia nyanɔ nʋ, 'ɩn ɔ yia 'nyu glu -plaplɩe bhli. Ɔ 'kpɩa 'wʋ, ɔ nɛɛ: «Na -Kanyɔ, kpa 'mɩ!» ");
INSERT INTO kyf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","-Bha -bhlokpadɛ, -Zezu -gloa sɔ 'wʋ, 'ɩn ɔ yia ɔ kpa, 'ɩn ɔ nɛɛ: «Dlɩ 'kienyi -zʋnyɔ, lɛɛ -lu ka 'gbʋ -na lʋ dlɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wa 'dɛ 'sɔ -bhoa 'glʋ 'wʋ, 'ɩn -pɩpɛ yia zɔbɛ. ");
INSERT INTO kyf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tɔʋn, ɔ 'bɩnɔnya -wa mɩa 'glʋ 'wʋ, 'ɩn wa yia ɔ 'yu 'kukolu 'sibhli, wa 'ka ɔ 'ylimanɩ, wa nɛɛ: «-Mɩ, -ɩn mɩ -Lagɔɔ 'Yuu 'dɛbhie -gbolu nya!» ");
INSERT INTO kyf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wa -dɩa 'nyu 'wʋ, 'ɩn wa yia Zenezalɛtɩ -dʋdʋ -gʋ nyni. ");
INSERT INTO kyf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","-Bha nyɩma weee yia -Zezu yibheli, 'ɩn ɔ 'dɩ yia wee dʋdʋ weee -gʋ lamneni. Wa yia ɔ guzʋnya weee -la. ");
INSERT INTO kyf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'Ɩn wa palɩa -Zezu zukpa nɩɩ, ɔ 'ka wa guzʋnya 'yoo 'nyɛ wa 'ka ɔ -banaa ŋwɛ kwɛzɩ. 'Ɩn -wa weee zɩa we kwɛ, -maa yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Falizɩnyɩma -yɔ -Lagɔɔ titee gwesanya 'bhʋa -Zeluzalɛmʋ, 'ɩn wa yia -Zezuu -gbɛ yi, 'ɩn wa nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«-Na 'bɩnɔnya mɩa, wa'a budo kwɛ -amɩaa titee sɔlʋ, 'ɩn wa lia. Nɩɩ, -we -amɩaa dʋkpasɩ gbaa -a 'na nʋnʋ lɛ -nɩ, 'mʋ wa nʋa lɛ. Lɛɛ -lu ka 'gbʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","-Zezu nɛɛ wa -yla: «Amɩa mɩa da, amɩaa bhlasabhla gbʋʋ 'gbʋ, a'a zʋa -Lagɔɔ tite 'nʋŋwɛ. Lɛɛ -lu ka 'gbʋa? ");
INSERT INTO kyf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nɩɩ, -Lagɔ nɛɛ: ‹Zʋ -na dide -yɔ -na 'nyaa 'nʋŋwɛ.› Ɔ nɛɛ 'yaɛ: ‹-Ɔ -ka ɔ dide -yɔ ɔ 'nyaa vɛlɩ, 'bha wa 'bhaa ɔ.› ");
INSERT INTO kyf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Ɩn amɩa, a nɛɛ: nyɩmɛ -ɔ -ka ɔ dide -yɔ ɔ 'nyaa -yla gba nɩɩ, -we ɔ 'ka yaa wa 'nyɛ, wa 'wʋsasɩe saa, ɔ ka we -Lagɔ 'nyɛ, ");
INSERT INTO kyf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ɔɔ nyɩmɛ'ɛ -sa ɔ dide 'wʋ. 'Sa a nʋa, 'ɩn a saa -Lagɔwɛlɩ la, amɩaa bhlasabhla gbʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wɛlɩ 'sɔ -nyɩma a -mɩa! -We Ezaii gbaa -benyi amɩaa daa, gbʋzɔnʋ -wa. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹-Lagɔ nɛɛ: waa nyɩma mɩa, ŋwɛɛ la wa nnanɩa 'mɩ, nɩɩ, wa dlɩ 'nɩ 'mɩ -gʋ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bhebhe wa ylimanɩa 'mɩ. Nɩɩ, tite wa slolua, -we wa laa -Lagɔɔ tite, nyɩmaa -gbɛ we bhʋa.› » ");
INSERT INTO kyf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","-Mʋʋ 'bɩgʋ, -Zezu nɛɛ nyɩmaa -zlo -yla: «A bɛ -seli, -we na yia gbaa, a 'ka we 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nɩɩ, -we plaa nyɩmɛ ŋwɛɛ, we'e -plalɩ ɔ pʋɩn. Nɩɩ, -we plalɩa nyɩmɛ pʋɩn nɩ, mʋ -wa we bhʋa ŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tɔʋn, ɔ 'bɩnɔnya bɛa ɔ -yɔ, 'ɩn wa nɛɛ ɔ -yla: «-Ɩn -yi we 'ji nɩɩ, wɛlɩ -ɩn gbaa dɛ -bha, we ka Falizɩnyɩma 'wʋ 'fnʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɔ nɛɛ: «Su, -we na Dide, -ɔ mɩa -yalɩ, 'nɩa fa nɩ, tlua wa yia we. ");
INSERT INTO kyf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","A 'tide wa 'yi nɩɩ, 'lɔlɔnya wa -mɩa, 'ɩn wa mɩa 'lɔlɔnya 'yoo da -sloluda. Nɩɩ, 'lɔlɔnyɔ -ka 'lɔlɔnyɔɔ su lakpa ɔ 'ka ɔ 'yoo da -slolu, 'ɩn wa 'dɛ 'sɔ bhlilia 'bhʋka 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piɛlɩ 'bhua wɛlɩ 'wʋ, ɔ nɛɛ: «Wee gbʋʋ nine mɩa da nɩ, sa we 'ji mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","-Zezu nɛɛ: «Amɩa, a 'nɩ 'ya -slɔ -mʋʋ 'wʋlanʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nɩɩ, -lu weee -we plalɩa nyɩmɛɛ ŋwɛɛ, ɔ nʋkplɛ we plɩlɩa. -Mʋʋ 'bɩgʋ, 'ɩn ɔ plaa 'kwla -yɔ. A'a 'nʋ 'ya -mʋʋ 'wʋlaa? ");
INSERT INTO kyf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nɩɩ, -we tlaa nyɩmɛ ŋwɛɛ, mʋ bhʋa ɔ dlɩ zɔ, 'ɩn -we plalɩa nyɩmɛ pʋɩn, mʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nɩɩ, 'wlukʋʋn lapʋpalɩe 'nyuu bhʋa nyɩmɛɛ dlɩ zɔ. Tɔʋn, 'ɩn nyɩma bhaa wa -lima, 'ŋwnɩ -yɔ nyɩma -putu dɩa -budu 'wʋ, wa kaa mʋtnɩ kwɛ, wa ylia 'wie, wa tʋbhʋa yo, 'ɩn wa saa wa -lima 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nɩɩ, -we plalɩa nyɩmɛ pʋɩn mʋ mɩa dɛ. Nɩɩ, nyɩmɛ 'nɩ kwɛ budo tɩklɩɩ ɔ 'ka li, -mʋʋ'ʋ -plalɩ nyɩmɛ pʋɩn.» ");
INSERT INTO kyf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","-Mʋʋ 'bɩgʋ, -Zezu 'bhʋa -bha, 'ɩn ɔ yia Tilɩ -yɔ Sidɔɔn -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanaa -ŋwnɔ yabhlo -dɩlɩa -mɔ la, 'ɩn ɔ yia ɔ -gbɛ mnɩ, -zugba ɔ wili ɔ -yɔ: «-Davidɩ 'yuoo, -ɩn 'yɩlɩ 'mɩ nyazɩoo! Na -Kanyɔ, zuzu 'nyuu ka na 'ŋwnɔyu kpa, ɔ 'nɩ 'kʋayli -ka.» ");
INSERT INTO kyf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","-Zezu 'nɩ ɔ -gʋ -sa. Ɔ 'bɩnɔnya bɛa ɔ -yɔ, 'ɩn wa nɛɛ ɔ -yla: «Vu ɔ, we 'nɩ -mʋʋ, ɔ mɩ -aɩn 'bɩ wiwie nya.» ");
INSERT INTO kyf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Ɩn -Zezu nɛɛ: «Izlaɛlɩnyɩma -wa 'wlʋa bhlabhlɛ -we mnɔ, wa 'dɛkpʋaa 'gbʋ ɩn yia yi.» ");
INSERT INTO kyf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nɩɩ, ɔɔ 'ŋwnɔ 'sibhlia ɔ 'yu 'kukolu, ɔ nɛɛ: «Na -Kanyɔ, bɛ 'mɩ -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Ɩn ɔ nɛɛ: «'Ylaaslɩ -ka lida -mɩ, we 'nɩ tɩklɩɩ -mɩ wa 'ka 'ylaaslɩ lililu zɔ -sa, wa 'ka we gwɩ zɔ viteli, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɔɔ 'ŋwnɔ nɛɛ: «Na -Kanyɔ, gbʋzɔnʋ -wa. Nɩɩ, 'ylaaslɩ -ka lida -mɩ, 'ɩn gwɩ -ka 'tabhle zɔ -mɩ, wee lililu -we bhlia, gwɩ lia we, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɔ nɛɛ: «Amaa dlɩzʋzʋe 'yli 'lɛ! -We a 'yɩbhaa, mʋ yia aɩn -yla lɛnʋa.» -Bha -bhlokpadɛ ɔ 'yu 'pʋa. ");
INSERT INTO kyf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","-Mʋʋ 'bɩgʋ, -Zezu 'bhʋa -bha, ɔ 'plɩlɩa Galilenyu kwesi, ɔ -gblaa -gɔgɔ 'wlu, 'ɩn ɔ yia -mɔ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tɔʋn, nyɩmaa -zlo -yɔ wa guzʋnya yia ɔ -gbɛ yi. Tɔlʋa tɩgɩa, tɔlʋa'a 'yɩ la, tɔlʋa 'kua, tɔlʋa'a 'nʋ, 'ɩn wa'a gba, we -yɔ guzʋnya duun -putu. 'Ɩn wa yia wa -Zezu -yɔ laslu, 'ɩn ɔ yia wa jipe. ");
INSERT INTO kyf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyɩmaa -zlo 'yɩa nɩɩ, -wa mɩa bhobhonya, wa ka gba, -wa 'kua, wa ka 'pʋ, -wa tɩgɩa, wa ka nɔ 'nanʋʋ, -wa 'lɔa, wa ka layɩ, we 'nɩ wa ŋwɛgaga -sʋbhalɩ -sɛ. 'Ɩn wa yia *Izlaɛlɩ -Lagɔɔ 'ŋnɩ -mnɩnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","-Zezu laa ɔ 'bɩnɔnya, 'ɩn ɔ nɛɛ: «Nɩɩ, nyazɩ nyɩma nɩ laa 'mɩ 'wʋ. Wa 'ylɩ ta nɩ, -zugba wa mɩ 'mɩ 'bɩ, 'ɩn lililu ka bhɩa. Nɩɩ, wa 'nɩ -slɔ li, ɩn -ka gba wa mnɩ lʋ nɩ, wa mneni wa 'ka 'yloogblʋ bhli sɩasɩe kwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","-Bha ɔ 'bɩnɔnya 'yɩbhaa ɔ laɛ: «-A mɩa -flii 'pɩpɩ, da -a ka 'floo 'yɩlɩ, 'ɩn -a 'ka nyɩmaa -zlo nɩ 'nyɛ, 'ɩn wa 'ka li, 'ɩn wa 'ka lʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","-Zezu nɛɛ wa -yla: «'Floo zuma mɩ aɩn kwɛɛa?» Wa nɛɛ: «'Floo gbesɔ, we -yɔ zibhi yua -sɛlɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tɔʋn, ɔ nɛɛ nyɩmaa -zlo -yla nɩɩ, wa -dɩ dʋdʋ la. ");
INSERT INTO kyf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Bhie, ɔ 'bhua 'floo gbesɔ -yɔ zibhi 'wʋ, ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we ladɩdlɩ, 'ɩn ɔ yia we ɔ 'bɩnɔnya yoo 'nyɛ, 'ɩn -maa yia we nyɩmaa -zlo 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wa 'dɛ weee lia, 'ɩn wa yia lʋ. -We wa sɩalɩa, we nyni -cɩcɛ gbesɔ, 'mʋ ɔ 'bɩnɔnya -yɔ we mnɩa. ");
INSERT INTO kyf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nɩɩ, -wa lia wa nyni nʋkpasiaa 'wlu glʋ -bhlo (4.000). Wa 'nɩ 'ŋwnɩ -yɔ 'nyɛnyɛyua zɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Da -Zezu 'nyɛa wa 'yoo, 'ɩn ɔ yia 'glʋ 'wʋbho ɔ 'ka Magadan -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Sadusenyɩma -yɔ Falizɩnyɩma bɛa -Zezu -yɔ, wa 'ka ɔ layla. Wa nɛɛ ɔ -yla: «-Ɩn nʋ gwɛdigbʋ yabhlo lɛ, 'ɩn -a 'ka we 'jiyibheli nɩɩ, -Lagɔ 'nyɛa -mɩ 'tɩtɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","-Zezu nɛɛ wa -yla: «'Ylʋ -ka bhli, yalɩ -ka lazamanɩ a nɛɛ da nanɩ 'yli. ");
INSERT INTO kyf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Ɩn zlʋkpɛ 'ylʋ -ka 'wʋsɔ, yalɩ -ka lazamanɩ, a nɛɛ 'nyu yia -zɛɛn lʋa. A -ka yalɩ yla, we -ka nɩɩ, 'nyu yi lʋa, 'ɩn a yibhelia we 'ji. 'Ɩn -we mɩa -zɛɛn 'plɩda, a 'nɩ mneni a 'ka we yla, 'ɩn -we mɩa yida a 'ka we yibheli. ");
INSERT INTO kyf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dɛslɛɛn -nyɩma ka 'nyii, 'ɩn wa'a zʋ -Lagɔ dlɩ -gʋ. Wa 'yɩbha ɩn nʋ wa -yla gwɛdigbʋ lɛ, we 'nɩ *Zonasɩɩ gwɛdigbʋ 'wʋbhʋ, wa 'na 'ka gwɛdigbʋ yabhlogbɔɔ 'yɩ.» Tɔʋn, ɔ tɩa -bha wa, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ɔ 'bɩnɔnya mɩa 'nyu 'wʋdɩda, wa ka 'floo 'wʋdlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tɔʋn, -Zezu nɛɛ wa -ylaɛ: «A zʋ amɩaa 'dɛ 'yliyɔ, a 'na 'tideli amɩaa 'dɛ 'yi Falizɩnyɩma -yɔ Sadusenyɩmaa 'flooo *gɔɔ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","-Bha ɔ 'bɩnɔnya gbʋgbalɩa -ylaɛ: «Nɩɩ, 'floo 'nɩ -aɩn kwɛɛ -mɩ, we 'gbʋ ɔ yi 'saa gba.» ");
INSERT INTO kyf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","-We mɩa wa dlɩ zɔ, -Zezu yibhelia we 'ji, ɔ nɛɛ wa -ylaɛ: «Dlɩ 'kienyi -zʋnya, 'lee, lɛɛ -lu ka 'gbʋ a gbʋgbalɩ -yla nɩɩ, a 'nɩ 'floo kwɛɛ -kaa? ");
INSERT INTO kyf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A 'nɩ -slɔ we 'wʋlanʋ nɩɩ, 'floo gbu ɩn dlilia nyɩmaa 'wlu glʋ -bhlo 'wlu gbu (5.000) 'wʋ laa? 'Ɩn -cɩcɛ a 'bhua 'wʋ, a ka we 'wʋdlʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'Ɩn 'floo gbesɔ ɩn dlilia nyɩmaa 'wlu glʋ -bhlo (4.000) 'wʋ la, 'ɩn -cɩcɛ a 'bhua 'wʋ, a ka we 'wʋdlʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɩn -ka aɩn -yla gba nɩɩ, a zʋ amɩaa 'dɛ 'yliyɔ Sadusenyɩma -yɔ Falizɩnyɩmaa gɔɔ kwɛɛ, ɩn 'nɩ 'floo gbʋ gba, sa a 'nʋ we 'wʋ laa?» ");
INSERT INTO kyf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","-Slɛɛn, ɔ 'bɩnɔnya yibhelia we 'ji nɩɩ, -Zezu 'nɩ 'flooo *gɔɔ gbʋ gba. Gbʋ -we Falizɩnyɩma -yɔ Sadusenyɩma slolua, 'mʋ ɔ saa 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","-Zezu mnɩa Sezalee Filipʋ -dʋdʋ -gʋ, ɔ nynia -mɔ, 'ɩn ɔ nɛɛ ɔ 'bɩnɔnya -ylaɛ: «'Lee, nyɩma nɛɛ *Nyɩmɛɛ 'Yuu daa nyɔɔ ɔ -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wa nɛɛ: «Nyɩma tɔlʋa nɛɛ, 'Zan -Batisɩ -ɩn -mɩa, 'ɩn tɔlʋa nɛɛ, Elii -ɩn -mɩa. 'Ɩn tɔlʋa nɛɛ 'ya nɩɩ, Zelemi -ɩn -mɩa, -Lagɔgbʋʋ -falɩpanyɔ -putu -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Ɩn ɔ nɛɛ: «'Ɩn amɩa, a nɛɛ, nyɔɔ ɩn -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔ Piɛlɩ nɛɛ: «-Lagɔɔ -Bhasanyɔ -ɩn -mɩa, -ɩn mɩ 'yliyɔga -Lagɔɔ 'Yu nya.» ");
INSERT INTO kyf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tɔʋn, -Zezu nɛɛ ɔ -ylaɛ: «'Simɔɔ, Zonasɩɩ 'yu, -ɩn -tʋ 'wʋ -dlɔɔ, nɩɩ, wee gbʋ mɩa, nyɩmɛ 'nɩ -mɩ we -slolu. Na Dide -ɔ mɩa yalɩ, mɔ -slolua -mɩ we. ");
INSERT INTO kyf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nɩɩ, -mɩ wa laa Piɛlɩ, we ji -wa tʋkpa. Wee tʋkpa -gʋ na yia na *Leglizɩ 'sʋbhaa. 'Ɩn tlɩtlɩee 'dɛbhie -gboluu 'tɩtɛ 'na 'ka we -wlɔ. ");
INSERT INTO kyf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","*-Lagɔɔ nyɩmaa 'wlulapɩlɩgbee -laklɩ na yia -mɩ yoo 'nyɛa. -We -na yia gbʋaan dʋdʋ -gʋ, gbʋaan wa yia we yalɩ. 'Ɩn -we -na yia -bloa dʋdʋ -gʋ, -bloa wa yia we yalɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Ɩn ɔ nɛɛ wa -yla 'klʋ 'cɩcɩ nya: «A 'na gbalɩ nyɩmɛ yabhlogbɔɔ -yla, ɩn mɩ -Lagɔɔ -Bhasanyɔ nya -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nɩɩ, we 'ka -bha 'bhʋ, -Zezu gbaa -slɛɛn ɔ 'bɩnɔnya -yla sa tɩklɩɩ, ɔ'ɔ zize 'maslɛɛn gbʋ, ɔ nɛɛ: «We mɩ nɩɩ, ɩn mnɩ -Zeluzalɛmʋ, -mɔ Zuifʋʋ nyɩma kpasɩ klaa, *-Lagɔbʋbɔnyaa -cɩan klaa, we -yɔ -Lagɔɔ titee gwesanya, ma kwɛɛ na yia sɩa bhabha. Ma yia 'mɩ wlaa wa 'ka 'mɩ 'bha. 'Ɩn 'ylɩ 'sɔ we tanʋ nya, tlɩtlɩnya glaa na yia 'wʋsɔa.» ");
INSERT INTO kyf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tɔʋn, 'ɩn Piɛlɩ yia ɔ -glima lalɩ, 'ɩn ɔ yia ɔ -yla gbʋ gba, ɔ nɛɛ: «Na -Kanyɔ, -Lagɔ 'na ŋwnunu we -nɩ. -Mʋʋ 'na nʋnʋ lɛ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","-Zezu 'bhitia la, ɔ nɛɛ Piɛlɩ -yla: «*-Saatan, bɛ lʋ! 'Bhʋ 'mɩ kwesi. -Ɩn mɩ 'mɩ 'yoo -kʋlʋda. Nɩɩ, -ɩ'ɩn pʋpalɩ 'wlukʋʋn la -Lagɔ 'bhisa, nyɩma 'bhisa -na pʋpalɩa 'wlukʋʋn la.» ");
INSERT INTO kyf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tɔʋn, ɔ nɛɛ ɔ 'bɩnɔnya -yla: «Nyɔɔo nyɔɔ -ka gba ɔ 'ka 'mɩ 'bɩ nɔ, ɔ -sa ɔ 'dɛ dlɩ, ɔ 'bhu ɔ sɩasɩee *su 'wʋ, 'ɩn ɔ 'ka 'mɩ 'bɩ yi. ");
INSERT INTO kyf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nɩɩ, nyɔɔo nyɔɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋgʋ nɩ, 'wʋ ɔ yia we bɔa. 'Ɩn -ɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋbɔ na 'gbʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ -mɔɔ yia 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɩɩ, nyɩmɛ -ka dʋdʋ -gʋʋ zʋzɔnʋ weee 'yɩ, 'ɩn ɔ -ka ɔ 'yliyɔgagɩe 'wʋbɔ nɩ, lɛɛ -lu ɔ 'yɩ we 'wʋa? Nɩɩ, -lu yabhlogbɔɔ 'nɩ mneni we 'ka nyɩmɛɛ 'yliyɔgagɩe zɔ. ");
INSERT INTO kyf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nɩɩ, Nyɩmɛɛ Yu yia yia ɔ Didee 'ŋnɩmnɩee san 'wʋ, ɔ -yɔ ɔ 'anzɩnya 'sɔ. 'Ɩn -we nyɩma nʋa lɛ, we ŋwɛɛ ɔ yia wa 'pɛnɩa. ");
INSERT INTO kyf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: amɩa -wa mɩa da -seli, aɩn glaa, nyɩma tɔlʋa ka Nyɩmɛɛ 'Yu 'yɩ yida, ɔ 'ka nyɩma 'wlulapɩlɩ, 'bhie wa 'kaa tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Ylɩ gbu, we gbelibhlonʋ nya, -Zezu 'bhua Piɛlɩ klaa, *'Zake klaa, we -yɔ 'Zakee bheli *Zaan 'wʋ, 'ɩn wa yia -gɔgɔ 'kadʋ 'wlu mnɩ. -Mɔ wa -nyaa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","-Mɔ, 'ɩn ɔ 'klʋ yia 'bhiti wa 'yliya 'wʋ, 'ɩn we yia lɩ 'ylʋ 'bhisa, 'ɩn ɔ -bana yia pɔmanɩ 'paɩnpaɩn zlɩ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tɔʋn, 'ɩn wa yia Moizɩ -yɔ *Elii 'sɔ -yɔyɩ, -zugba wa -yɔ -Zezu sa 'dɩ. ");
INSERT INTO kyf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","-Bha Piɛlɩ gbaa -Zezu -ylaɛ: «Na -Kanyɔ, -amɩaa -seli -mɩmɩe nanɩ 'yli! We -ka -mɩ dʋdʋ nanɩ, palʋ yua ta na yia -seli 'sʋbhaa. -Na -nʋ -bhlo, Moizɩɩ -nʋ -bhlo, Eliii -nʋ -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ɔ mɩ gbada, tɔʋn yalɩpʋpa -we lɩa, 'ɩn we yia wa 'wʋwɛlɩ. 'Ɩn wɛlɩ yabhlo yia wee yalɩpʋpa nyɩdɩ 'tla, we nɛɛ: «-Ɔ mɩa dɛ, na Yu -wa, ɩn -kalɩ ɔ zɛ. 'Mɔ ɩn 'nyɛa na dlɩ weee yoo, a pʋlʋ ɔ yukwli.» ");
INSERT INTO kyf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ɔ 'bɩnɔnya 'nʋa wee wɛlɩ, nyanɔ sloa wa 'wʋ, 'ɩn wa yia 'klʋ lagbli. ");
INSERT INTO kyf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","-Zezu bɛa wa -yɔ, ɔ zɩa wa kwɛ, ɔ nɛɛ: «A -sɔ 'wʋ, a 'na nʋnʋ nyanɔ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wa 'bhua 'klʋ 'wʋ, we 'nɩ -Zezu -bhlogbɔɔ 'wʋbhʋ, wa 'nɩ nyɩmɛ -putu -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Da wa mɩa wee -gɔgɔ kwlida, -Zezu zʋa wa 'dɩ, ɔ nɛɛ: «-We a 'yɩa da -yɔ nɩ, ɔɔ Nyɩmɛɛ 'Yu 'nɩ -slɔ tlɩtlɩnya glaa 'wʋsɔ, a 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tɔʋn, -Zezuu 'bɩnɔnya yia ɔ layɩbha: «'Lee, lɛɛ -lu ka 'gbʋ -Lagɔɔ titee gwesanya gba nɩɩ, Elii 'kaa yi tɩaa?» ");
INSERT INTO kyf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɔ nɛɛ: «Gbʋzɔnʋ -wa: Elii yia yia tɩa ɔ 'ka -lu weee we 'bɩ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nɩɩ, ɩn nɛɛ aɩn -yla: Elii ka yi pepe, 'ɩn wa 'nɩ ɔ yibheli. Sa wa 'yɩbhaa, 'ɩn wa yi 'saa ɔ nʋ. 'Sa -bhlokpadɛ wa yia Nyɩmɛɛ 'Yu sɩalɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","-Bha ɔ 'bɩnɔnya yibhelia we 'ji nɩɩ, 'Zan -Batisɩɩ gbʋ ɔ mɩa gbada. ");
INSERT INTO kyf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","-Bha -Zezu -yɔ ɔ 'bɩnɔnya nynia nyɩmaa -zlo kwesi, nyɩmɛ yabhlo 'tlaa -mɔ, ɔ 'sibhlia 'kukolu -Zezu 'yu, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Na -Kanyɔ, na yu mɩa, -ɩn 'yɩlɩ ɔ nyazɩ. Nɩɩ, ɔ 'wlukʋʋn ka -nyumɔ. 'Ylɩ tɔlʋa nya, ɔ bhlilia -kosu 'wʋ, ɔ bhlilia 'nyu lʋ. ");
INSERT INTO kyf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ɩn ka ɔ -na 'bɩnɔnya -la, wa 'nɩ mneni wa 'ka ɔ jipe.» ");
INSERT INTO kyf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","-Zezu nɛɛ: «Dɛslɛɛn -nyɩma -wa'a zʋ dlɩ, nyɩma 'nyii, 'ylɩ zuma ɩn -yɔ aɩn 'sɔ 'ka lia? 'Ylɩ zuma ɩn 'ka amɩaa 'gba zɔ 'yligbeda -tʋa? A -yɔ ɔ 'sɔ yi -seli.» ");
INSERT INTO kyf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","-Zezu 'kpɩlɩa wee zuzu 'nyuu 'wluo, 'ɩn we yia ɔɔ 'yu 'yitide, 'ɩn ɔ yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","'Bhie, -Zezu -yɔ ɔ 'bɩnɔnya -nyaa 'wʋ, wa bɛa ɔ kwesi, 'ɩn wa nɛɛ: «Lɛɛ -lu ka 'gbʋ -amɩa 'nɩ mneni -a 'ka wee zuzu 'nyuu nɩ vua?» ");
INSERT INTO kyf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","-Zezu nɛɛ: «-We ka gbʋ -wa, amɩaa dlɩzʋzʋe 'kienyi. Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: *mutadɩɩ 'ya -sɛ, amɩaa dlɩ 'ka yaa we 'bhisa -mɩ, a -ka gba -gɔgɔ -yla, ‹'Bhʋ da, mnɩ mɔ, 'ɩn we bhʋa -bha.› A mneni 'ya a 'ka -lu weee lɛnʋ.  ");
INSERT INTO kyf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Sasʋkpa -zuzu 'nyii mɩa dɛ, we 'nɩ -Lagɔbhubhoe -yɔ 'sun -plaplɩe 'wʋbhʋ, wa 'nɩ mneni wa 'ka we vu.» ");
INSERT INTO kyf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","'Ylɩ yabhlo nya, -Zezu -yɔ ɔ 'bɩnɔnya gbelia 'wlu -mɔ Galilee, 'ɩn ɔ nɛɛ wa -yla: «Ɔɔ Nyɩmɛɛ 'Yu wa yia nyɩma yoo 'nyɛa, wa 'ka ɔ 'bha. Nɩɩ, 'ylɩ 'sɔ, we tanʋ nya, ɔ yia tlɩtlɩnya glaa 'wʋsɔa.» 'Ɩn wee gbʋ yia wa -gʋ 'wʋtɩ yuoo. ");
INSERT INTO kyf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","-Zezu -yɔ ɔ 'bɩnɔnya nynia Kapɛnaumʋ, *-Lagɔbudu 'kadʋʋ nisʋn -gwɛzisanya bɛa Piɛlɩ -yɔ, 'ɩn wa yia ɔ layɩbhaɛ: «-Na -Kanyɔ mɩa, ɔ'ɔ plʋlʋ -Lagɔbuduu 'gwɛzi -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛlɩ nɛɛ: «Plʋlʋ ɔ plʋlʋ we.» Da Piɛlɩ plaa -budu zɔ, -Zezu gbaa tɩa, ɔ nɛɛ: «'Simɔɔ, -mɩ nɛɛ lɛa? Da nyɩmaa 'yugalɩnya mɩa 'gwɛzi -sada nɩ, nyɔɔ plʋlʋ wea? Wa yua -wa yaayɩɩ, 'lakpanya -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piɛlɩ nɛɛ: «'Lakpanya -wa.» -Zezu nɛɛ: «We -ka 'sa -mɩ, wa 'yua'a plʋlʋ we. ");
INSERT INTO kyf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nɩɩ, -a 'nɩ 'yɩbha -a 'ka wa nyeni. We 'dɛɛ 'gbʋ, mnɩ 'nyu -yɔ. -Ɩn -ka -mɔ nyni nɩ, -ɩn 'pa -kɔ. Zibhii tɩanʋ -ka we 'wʋbhua yi nɩ, gbize we 'wʋ. -Ɩn -ka we kpa, 'bha we ŋwɛɛ. -Mɔ -na yia tama yabhlo 'yɩa, -we 'kaa ɩn -yɔ -mɩ 'sɔɔ nʋ -Lagɔbuduu 'gwɛzi plʋlʋ. 'Bhu we 'wʋ, 'ɩn -ɩn 'ka -amɩaa -nʋ plʋlʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","We bhla, -Zezuu 'bɩnɔnya bɛa ɔ kwesi, 'ɩn wa yia ɔ layɩbha: «Nyɩma -wa -Lagɔ pɩlɩa 'wlu la, nyɔɔ 'yli wa glaaa?» ");
INSERT INTO kyf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","-Zezu laa 'yu yabhlo, 'ɩn ɔ yia wa 'yu ɔ 'yligbeli, ");
INSERT INTO kyf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'ɩn ɔ nɛɛ wa -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: a 'bhiti amɩaa 'dɛ, 'ɩn a 'ka 'ylaaslɩ 'bhisa -mɩ. We 'nɩ -mʋʋ, nyɩma -wa -Lagɔ pɩlɩa 'wlu la, a 'na 'ka wa glaa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","«Nyɩmɛ -ɔ tɩa ɔ 'dɛ 'wʋ 'nyɛnyɛyu 'bhisa, nɩɩ, nyɩma -wa -Lagɔ pɩlɩa 'wlu la, mɔ -wa wa kpasa. ");
INSERT INTO kyf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Yu -ɔ mɩa yu nɩ 'bhisa, nyɩmɛ -ɔ -ka ɔ kpa 'nanʋʋ na 'ŋnɩ nya, na 'dɛ ɔ kpaa 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Nɩɩ, 'ylaaslɩ -wa mɩa sa yu nɩ 'bhisa, 'ɩn wa zʋa 'mɩ dlɩ -gʋ, -ɔ -ka wa 'yabhlogbɔɔ gbʋnyuu lʋkwa, we nanɩ 'yli -mɔɔ -nʋ nya wa 'ka -mɔɔ tʋkpa 'kadʋ -blɩ -yɔ gbʋanɩ, 'ɩn wa 'ka ɔ 'nyu lʋ viteli. ");
INSERT INTO kyf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gbʋnyuu mɩ dʋdʋgʋ -nyɩmaa -nʋ nya, gbʋ -we kwaa nyɩma gbʋnyuu lʋʋ 'gbʋ. Nɩɩ, gbʋ -we kwaa nyɩma gbʋnyuu lʋ, we mɩ la 'kɔmʋʋ. Nɩɩ, nyɩmɛ -ɔ ka -gbɛ wee gbʋnyuu -ka 'bhʋ, gbʋnyuu mɩ ɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","We -ka -na bhʋ -yɔ -na sɔ 'ka -mɩ gbʋnyuu lʋ kwa nɩ, -dɩ -bha we, 'pa we kwnɛɛ. We nanɩ 'yli -ɩn 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩ sɔ -bhlo -yɔ bhʋ -bhlo nya, we -zi -ɩn 'ka -kosu -we'e nyumoa 'wʋ mnɩ sɔ 'sɔ -yɔ bhʋ 'sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","We -ka -na yli 'ka -mɩ gbʋnyuu lʋ kwa, -sa -mɔ we, 'pa we kwnɛɛ. We nanɩ 'yli -ɩn 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩ 'yliya -bhlo nya, we -zi wa 'ka -mɩ -kosu -we'e nyumoa 'wʋ viteli 'yli 'sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«A zʋ amɩaa 'dɛ 'yliyɔ 'ylaaslɩ nɩɩ gbɛgbɛɩn, a 'na gbalɩ -nɩ nɩɩ, 'ylaaslɩ glaa, 'yu -bhlo 'nɩ -lu yabhlogbɔɔ nya -mɩ. Nɩɩ, 'ylɩ weee nya, wa 'anzɩnya mɩ -bha yalɩ. 'Ɩn na Dide -ɔ mɩa yalɩ, mʋ 'yligbea ɔ 'yu wa 'gbʋ.  ");
INSERT INTO kyf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nɩɩ, ɔɔ Nyɩmɛɛ Yu mɩa, -wa mnɔa, 'ma ɔ yia gbʋ 'wʋsaa. ");
INSERT INTO kyf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Nɩɩ, a nɛɛ lɛa? Nyɩmɛ yabhlo -ka bhlabhlɛ glʋ gbu -ka, 'ɩn we 'yabhlo 'ka mnɔ, we glʋ -mnʋa 'ya kugbua lɛ gbomnʋa ɔ tɩa -gɔgɔ 'wlu, 'ɩn ɔ mnɩa we 'yabhloo datalɩa. We 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: ɔ -ka we 'yɩ, 'ɩn we laa ɔ 'mʋna 'wʋ, we -zi bhlabhlɛ glʋ -mnʋa 'ya kugbua lɛ gbomnʋa -we -tʋa -bha. ");
INSERT INTO kyf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Sa -bhlokpadɛ amɩaa Dide -ɔ mɩa yalɩ, ɔ'ɔ ŋwnu waa 'ylaaslɩ nɩɩ 'yabhlogbɔɔ 'ka mnɔ. ");
INSERT INTO kyf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«-Na bheli -ka -mɩ gbʋ -yɔkpalɩ, mnɩ ɔ 'yɩa, 'ɩn gbʋ ɔ nʋa lɛ, -ɩn -yɔ ɔ 'sɔ 'ka 'wʋ -nya, -ɩn 'ka we ɔ -yla lapalɩ. Ɔ -ka we ŋwnu nɩ, -zugba ɔ ka 'ya na bheli -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɔ 'nɩ we ŋwnu nɩ, -ɩn 'bhu nyɩmɛ -bhlo, nyɩma 'sɔ 'wʋ, 'ɩn sa -Lagɔsɛbhɛ gbaa nɩɩ, wa 'bhu gbʋ 'wʋ nyɩma 'sɔ, nyɩma ta 'yu, -ɩn nʋ 'sa. ");
INSERT INTO kyf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ɔ 'nɩ wa wɛlɩ 'wʋŋwnu nɩ, gba we -Lagɔnyɩma weee 'yu. 'Ɩn ɔ 'nɩ -maa 'wʋŋwnu nɩ, -ɩn 'bhu ɔ 'wʋ *nisʋn -gwɛzisanya -yɔ nyɩma -putu -wa 'nɩa -Lagɔ -yi 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, -we a yia gbʋan dʋdʋ -gʋ, gbʋan wa yia we -mɔ yalɩ -Lagɔɔ -gbɛ. 'Ɩn -we a yia -bhloa yia dʋdʋ -gʋ, -bhloa wa yia we -mɔ yalɩ -Lagɔɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Ɩn nɛɛ 'ya nɩɩ, amɩa mɩa dʋdʋ -gʋ, aɩn glaa, nyɩma 'sɔ -ka wɛlɩ bhlɩ, wa -ka -lu -mʋmʋ -zla, na Dide -ɔ mɩa yalɩ, 'nyɛa ɔ yia we aɩn. ");
INSERT INTO kyf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nɩɩ, da nyɩma 'sɔ, nyɩma ta -ka 'wlugbeli na 'ŋnɩ nya, ɩn mɩ wa glaa.» ");
INSERT INTO kyf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tɔʋn Piɛlɩ bɛa -Zezu -yɔ, 'ɩn ɔ yia ɔ layɩbhaɛ: «Na -Kanyɔ, na bheli -ka 'mɩ gbʋ -yɔkpalɩ, -zakpa zuma ɩn 'ka ɔ -yɔgbʋ 'wʋtɩa? We nyni -zakpa gbesɔ -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","-Zezu nɛɛ ɔ -yla: «-Ɩnnya, ɩn 'nɩ gba -zakpa gbesɔ. Ɩn nɛɛ: glʋ ta 'ya kugbua -zakpa gbesɔ (70 x 7). ");
INSERT INTO kyf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","We 'dɛɛ 'gbʋ, -we -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa mʋ nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dʋdʋʋ 'wlulapɩlɩnyɔ yabhlo 'yɩbha ɔ -yɔ ɔ lubhonʋnya 'ka wa kpagbʋ zɛlɩ. Ɔ bhlia we zɛlɩe, ɔ lubhonʋnyɔ yabhlo yia, -mɔɔ 'ka miniɔn kpagbʋ 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɔɔ nyɩmɛ 'nɩ -lu yabhlogbɔɔ kwɛɛ -ka, ɔ 'ka wee kpagbʋ -sa. We 'dɛɛ 'gbʋ ɔ -kanyɔ nɛɛ ɔ 'ka ɔ pɛlʋ 'pa, ɔ 'ka gaylo -zɛ, ɔ 'ŋwnɔ -yɔ ɔ 'yua klaa, we -yɔ ɔ -kakalu weee, 'ɩn ɔ 'ka ɔ kpagbʋ -sa. ");
INSERT INTO kyf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Ɩn ɔɔ lubhonʋnyɔ yia ɔ -kanyɔ 'yu 'kukolu -kʋlʋ, 'ɩn ɔ nɛɛ ɔ -yla: ‹-Na zukpa -wa, -ɩn nʋ dlɩtie lɛ na gbɛgbɛɩn, 'ɩn ɩn 'ka we 'dɛ weee 'pɛnɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Ɩn ɔ -kanyɔ yia ɔ nyazɩ 'yɩlɩ, 'ɩn ɔ yia we 'bɩ 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ɔɔ lubhonʋnyɔ 'tlaa, 'ɩn ɔ -yɔ ɔ -libheyi yabhlo yia gbeli. -Mɔɔ ka ɔnʋʋ kpagbʋ 'kienyi -lɛ 'wlu. Ɔ yia -mɔɔ -blɩ 'wʋbhli, 'ɩn ɔ yia ɔ 'tuntnu, ɔ nɛɛ: ‹-Sa na kpagbʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Ɔ -libheyi bhlia ɔ gbʋ -yɔ, ɔ nɛɛ: ‹-Na zukpa -wa, -ɩn nʋ dlɩtie lɛ na gbɛgbɛɩn, 'ɩn ɩn 'ka we 'dɛ weee 'pɛnɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Ɔ 'nɩ we ŋwnu, 'ɩn ɔ yia ɔ -kaslʋ 'wʋpa. Nɩɩ, -mɔɔ 'nɩ -slɔ ɔ 'gwɛzi wla, -mɔɔ 'na 'ka -mɔ 'tla. ");
INSERT INTO kyf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da ɔ -lima -manɩ 'nʋa we, we 'nɩ wa -yɔkpa -sɛ. 'Ɩn -maa yia wa -kanyɔ we 'dɩ -salɩ. ");
INSERT INTO kyf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tɔʋn, 'ɩn wa -kanyɔ yia ɔɔ lubhonʋnyɔ la, 'ɩn ɔ nɛɛ ɔ -yla: ‹Nyiikanyɔ, -ɩn ka 'mɩ zukpa 'palɩ we 'dɛɛ 'gbʋ ɩn yia na kpagbʋ 'bɩ 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sa ɩn 'yɩlɩa -mɩ nyazɩ, we mɩ nɩɩ, -ɩn 'yɩlɩ yaa 'sa -na -libheyi nyazɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɔ -kanyɔ 'paa 'cɛ bhabha, 'ɩn ɔ yia ɔɔ lubhonʋnyɔ -kaslʋ 'wʋkwa, wa 'ka ɔ sɩalɩ. Ɔ 'nɩ -slɔ ɔ kpagbʋ -sa, ɔ 'na 'ka -mɔ 'tla. ");
INSERT INTO kyf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Nɩɩ, 'sa we 'plɩa -sa. 'Sa -bhlokpadɛ, na Dide -ɔ mɩa yalɩ yia aɩn -yla nʋa, we -ka nɩɩ, aɩn glaa nyɩmɛ yabhlo 'nɩ ɔ -libheyii -yɔgbʋ 'wʋtɩ dlɩ weee nya.» ");
INSERT INTO kyf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","-Zezu bhɩa gbʋ nɩ gbagbɩe, ɔ 'bhʋa Galilee, Zudee -dʋdʋ -we mɩa Zudɛɛn nyu lʋʋ, 'ɩn ɔ yia -mɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nyɩmaa -zlo mnɩa ɔ 'bɩ, 'ɩn ɔ yia wa guzʋnya jipe. ");
INSERT INTO kyf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falizɩnyɩma tɔlʋa bɛa ɔ -yɔ wa 'ka ɔ layla, 'ɩn wa yia ɔ layɩbhaɛ: «-Amɩaa tite nʋkplɛ, nʋkpasu mneni ɔ 'ka ɔ 'ŋwnɔ kwnɛɛ -sa gbʋ -kpʋaa 'gbʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ɔ nɛɛ: «-We wa cɛlɩa -Lagɔwɛlɩ 'wʋ, a 'nɩ -slɔ we zɛlɩɩ? Nɩɩ, -lu weee gwedɩda, 'ɩn -Lagɔ yia nʋkpasu -yɔ 'ŋwnɔ lala. ");
INSERT INTO kyf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Ɩn ɔ nɛɛ: ‹We 'dɛɛ 'gbʋ -nʋkpasu yia ɔ dide -yɔ ɔ 'nyaa kwesi 'bhʋa, 'ɩn ɔ -yɔ ɔ 'ŋwnɔ 'ka 'wʋsuslolu, 'ɩn wa 'ka ku -bhlo -zɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","-Slɛɛn, wa 'nɩ 'maslɛɛn nyɩma sɔ, nɩɩ, nyɩmɛ -bhlo wa -mɩa. We 'dɛɛ 'gbʋ, -we -Lagɔ -ka 'ylijɩjlɩ, nyɩmɛ 'na sɩsalɩ we 'yli -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Falizɩnyɩma nɛɛ: «Nɩɩ, we -ka 'sa -mɩ, lɛɛ -lu ka 'gbʋ Moizɩ gba nɩɩ, -ɔ -ka ɔ 'ŋwnɔ kwnɛɛ -sa, ɔ 'nyɛ -mɔɔ kwnɛɛ -sa 'sɛbhɛ yooa? 'Ɩn ɔ 'tide ɔ 'yia?» ");
INSERT INTO kyf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ɔ nɛɛ: «Amɩaa yukwli -yɔ suloo 'gbʋ, Moizɩ yia aɩn 'yoo 'nyɛ a 'ka amɩaa 'ŋwnɩ kwnɛɛ -sa. Nɩɩ, we gwedɩda we 'nɩ 'sa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ɩn nɛɛ aɩn -yla: nɩɩ, nyɩmɛ -ka ɔ 'ŋwnɔ kwnɛɛ -sa, -zugba -mɔɔ 'nɩ nʋkpasu -putu nya -budu 'wʋdɩ, 'ɩn ɔ -ka 'ŋwnɔ -putu kwa, gbʋnyuu ɔ nʋa -mɔɔ -yla lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ɔ 'bɩnɔnya nɛɛ ɔ -yla: «Nʋkpasu -yɔ 'ŋwnɔɔ gbʋ -ka 'sa -mɩ, we nanɩ 'yli, nyɩmɛ 'na kwalɩ 'ŋwnɔ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ɔ nɛɛ wa -yla: «Nyɩma weee 'nɩ we kwɛyɔmneni. Nɩɩ, -wa -Lagɔ 'nyɛa we 'tɩtɛ, wa mneni we kwɛyɔ. ");
INSERT INTO kyf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nɩɩ, nyɩma -tɔlʋa mɩa, wa'a kwa 'ŋwnɩ. -We ka gbʋ -wa, we 'ka wa gwalɩ bhla 'bhʋ, wa 'nɩ we kwɛyɔmneni. 'Ɩn tɔlʋa mɩa, wa'a kwa 'ŋwnɩ, wa ka wa lɛlɩɩ 'gbʋ. Nɩɩ, tɔlʋa'a kwa 'ŋwnɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩee 'gbʋ. Nɩɩ, nyɩmɛ -ɔ -ka we 'wʋlanʋ, ɔ 'nʋ we 'wʋ la.» ");
INSERT INTO kyf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","-Bha nyɩma kwaa -Zezu 'ylaaslɩ ɔ 'ka wa kwɛ 'wluo lapalɩ, 'ɩn ɔ 'ka -Lagɔ bhubhoe wa 'ŋnɩ nya. 'Ɩn ɔ 'bɩnɔnya yia wa vuvue bhli wa 'wluo kpɩlɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","-Zezu nɛɛ: «A 'tide wa 'yi wa 'ka na -gbɛ yi, a 'na -kʋlʋ wa 'yoo -nɩ. Nɩɩ, nyɩma -wa 'wlu -Lagɔ yia lapɩlɩa, waa 'ylaaslɩɩ -sʋkpa -nyɩma -wa.» ");
INSERT INTO kyf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɔ palɩa wa sɔ 'wluo la, -mʋʋ 'bɩgʋ, 'ɩn ɔ yia -bha 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","-Bha nyɩmɛ yabhlo bɛa -Zezu kwesi, 'ɩn ɔ yia ɔ layɩbha: «-Slolunyɔ, lɛɛ -lu -zɔnʋ ɩn 'ka lɛnʋ, 'ɩn ɩn 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","-Zezu nɛɛ ɔ -yla: «-Lu -zɔnʋnya mɩa, lɛɛ -lu ka 'gbʋ -na yɩbha 'mɩ we gbʋ laa? -Lagɔ -bhlogbɔɔ mɩa nyɩmɛ -zɔnʋ nya. Nɩɩ, -ɩn 'ka 'yliyɔgagɩe 'yɩ, -ɩn zʋ ɔ *tite 'nʋŋwɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ɔ nɛɛ: «Tite -mʋmʋ we -maa?» -Zezu nɛɛ: «-Ɩn 'na 'bhalɩ nyɩmɛ -nɩ. -Ɩn -yɔ 'ŋwnɔ -putu 'na -dɩlɩ -budu 'wʋ -nɩ. -Ɩn 'na ylili 'wie -nɩ. -Ɩn 'na zʋlʋ nyɩmɛ yo -yɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","-Ɩn zʋ -bha -na dide -yɔ -na 'nyaa, 'ɩn -ɩn -kalɩ -na -libheyii zɛ -na 'dɛ 'bhisa.» ");
INSERT INTO kyf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɔɔ nyimeslɔyu nɛɛ ɔ -yla: «Ɩn ka wee titenya weee 'nʋŋwɛ zʋ, 'ɩn -mʋmʋ -tʋ 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","-Zezu nɛɛ ɔ -yla: «-Ɩn -ka gba -ɩn 'ka tɩklɩɩ -mɩ nɩ, -ɩn 'pa -na zʋzɔnʋ weee pɛlʋ, -ɩn 'nyɛ we -yɔ -gwɛzi bobabhanya, 'ɩn -ɩn 'ka 'ŋnɩmnɩe 'yɩ -Lagɔɔ -gbɛ. -Ɩn -ka we lɛnʋe bhɩa, -ɩn yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɔɔ nyimeslɔyu 'nʋa we, 'ɩn ɔ yia lʋbhiti, 'klʋ -susue nya, nɩɩ, 'ŋnɩmnɩnyɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tɔʋn, -Zezu nɛɛ ɔ 'bɩnɔnya -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: 'ŋnɩmnɩnyɔ 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ mnɩ, 'tɛ we 'tɛa. ");
INSERT INTO kyf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɩn nɛɛ 'ya aɩn -ylaɛ: 'ŋnɩmnɩnyɔ 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋpla, we -kalɩ -yɔ we -zi *-nyɔmɛɛ seenɩɩ 'bhʋka 'wʋplɩlɩe.» ");
INSERT INTO kyf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ɔ 'bɩnɔnya 'nʋa we, 'ɩn we yia wa -lʋɛlɩ. 'Ɩn wa nɛɛ: «Aya! We -ka 'sa -mɩ, nyɔɔ -mɔmɔ 'ka gbʋ 'wʋbhʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","-Zezu ylaa wa tenyii, ɔ nɛɛ: «Nyɩmɛ 'nɩ we mneni. Nɩɩ, -Lagɔ mɩa, ɔ mneni ɔ 'ka -lu weee lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piɛlɩ yia we 'bɩgʋpalɩɛ: «-Talɩ, -a ka -amɩaa -lu weee -bha tɩ, 'ɩn -a yia -mɩ 'bɩ yi. Lɛɛ -lu -a 'ka we 'wʋ 'yɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ɔ nɛɛ wa -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: dʋdʋ lolu yia yia, 'ɩn *Nyɩmɛɛ 'Yu 'ka ɔ 'ŋnɩmnɩkpe -zɔnʋ -gʋ ladɩ, ɔ 'ka nyɩma 'wlulapɩlɩ. We bhla, amɩa nyɩma kugbua lɛ sɔ nɔa 'mɩ 'bɩ, 'ŋnɩmnɩkpe -gʋ a yia ladɩa, a 'ka *Izlaɛlɩɩ *zʋa kugbua lɛ 'sɔɔ -yɔgbʋ 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","-Wa weee tɩa -bha wa -budu klaa, wa bhelia klaa, wa bhɔlɔa klaa, wa dide klaa, wa 'nyaa klaa, wa 'yua klaa, we -yɔ wa kpaa, na 'gbʋ, 'yɩa wa yia we -zakpa glʋ gbu, we -yɔ 'yliyɔgagɩe -we 'nɩa bhloluda -ka. ");
INSERT INTO kyf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nyɩmaa dumadu -wa -gaa 'yu, lʋ -maa yia -gaa. 'Ɩn -wa -gaa lʋ, 'yu -maa yia -gaa.» ");
INSERT INTO kyf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa, mʋ nɩ: nɩɩ, kpaapanyɔ yabhlo -wa, zlɩgʋ ɔ mnɩa 'ylɩwʋ -lubhonʋnyaa datalɩa, wa 'ka ɔ *-dlɔkpaaa lubho nʋ. ");
INSERT INTO kyf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɔ -yɔ wa 'sɔ, 'ɩn wa yia wɛlɩ bhlɩ, ɔ 'ka wa tama -bhlo 'nyɛ 'ylɩ -bhlo, 'ɩn ɔ yia wee kpaa wa kwa. ");
INSERT INTO kyf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zlʋkpa -ylʋ 'tɩtɛ nya, ɔ 'tlaa lʋ, 'ɩn ɔ yia nyɩma tɔlʋa 'yɩ, -zugba wa slu lɔkɔ 'wʋ la sa bhe. ");
INSERT INTO kyf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ɔ nɛɛ wa -yla: ‹Amɩa mɩa da nɩ, a mnɩ na kpaa lubho nʋa, 'ɩn -we mɩa tɩklɩɩ, 'ɩn ɩn 'ka we aɩn 'nyɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Ɩn wa yia mnɩ. «Ɔɔ kpaapanyɔ 'tlaa 'ylʋ -gbagbʋ, we -yɔ jibheza ylʋ nya, 'ɩn ɔ yi 'yaa we -bhlokpadɛ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jibheza ɔ 'tlaa, ɔ 'yɩa nyɩma, -zugba -maa mɩ 'ya lɔkɔ 'wʋ, ɔ nɛɛ wa -yla: ‹Lɛɛ -lu ka 'gbʋ a -dɩ -seli la bhe, 'ɩn a 'nɩ -lu yabhlogbɔɔ lɛnʋda -mɩa?› ");
INSERT INTO kyf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Wa nɛɛ ɔ -yla: ‹Nyɩmɛ yabhlogbɔɔ 'nɩ -aɩn 'wʋbhu.› «Ɔ nɛɛ wa -yla: ‹A mnɩ na kpaa.› ");
INSERT INTO kyf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Sabɔ bɛa, 'ɩn ɔ nɛɛ ɔ lubhonʋnyaa 'yugalɩnyɔ -ylaɛ: ‹La -na 'ylɩwʋ -lubhonʋnya. -Wa ɩn laa lʋgada, -ɩn 'pɛnɩ -maa tɩa, 'ɩn -wa ɩn laa tɩa, -ɩn 'ka -maa 'pɛnɩ lʋgada.› ");
INSERT INTO kyf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","-Wa ɔ 'bhua 'wʋ jibheza, -maa yia, 'ɩn wa yia tama -bhlo 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","-Wa ɔ 'bhua 'wʋ tɩa, -maa nɛɛ -maa 'dɛ dlɩ zɔ nɩɩ, -maa -nʋ yia tama -bhlo 'wʋzia. Nɩɩ, tama -bhlo -maa 'yɩ 'yaa. ");
INSERT INTO kyf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa 'yɩa we, 'ɩn wa yia ɔ -yɔ 'ŋwuŋweni. ");
INSERT INTO kyf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wa nɛɛ: ‹Nɩɩ, 'wʋbhlolu -nyɩma -wa nʋa lubho 'lɛlɩ -bhlo nya klaa, -amɩa -mama nʋa lubho 'ylɩ -bhlo 'ylʋ 'klʋ klaa, -a 'dɛ weee 'pɛnɩgwɛzi mɩa -bhlo yɩ? We 'nɩ 'ylinanɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Ɔɔ kpaapanyɔ nɛɛ wa yabhlo -yla: ‹'Tale, ɩn 'nɩ -mɩ -dawli 'wʋnʋ. -A 'dɛ 'sɔ ka yaa wɛlɩ bhlɩ, -ɩn 'ka lubho nʋ tama -bhloo -nʋ nya, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɩɩ, -ɩn 'bhu -na 'gwɛzi 'wʋ, -ɩn -yɔ we mnɩ. We nanɩ 'mɩ dʋdʋ, ɩn 'ka -we ɩn 'nyɛa -mɩ, ɩn 'ka we -ɔ yia 'wʋbhloluda 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na 'gwɛzi -wa. -We ɩn 'yɩbhaa, ɩn 'nɩ mneni ɩn 'ka we nya we lɛnʋʋ? Yaayɩɩ na 'nanɩɩ 'gbʋ -na nʋa zenyi yɩ?› ");
INSERT INTO kyf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«'Sa we mɩa sa, -wa -gaa lʋ, ma yia 'yu -gaa. 'Ɩn -wa -gaa 'yu, lʋ wa yia -gaa yia.» ");
INSERT INTO kyf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","-Zezu mɩ -Zeluzalɛmʋ mnɩda, ɔ nɛɛ ɔ 'bɩnɔnya kugbua lɛ 'sɔ -ylaɛ: «A bɛ -seli!» 'Ɩn da wa mɩa nɔda ɔ nɛɛ wa -yla: ");
INSERT INTO kyf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«A -talɩ, -Zeluzalɛmʋ -a mɩa da mnɩda, -mɔ wa yia ɔɔ Nyɩmɛɛ 'Yu wlaa -Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanyaa kwɛɛ. Ma yia ɔ -yɔgbʋ 'wʋbhua, 'ɩn wa 'ka gba wa 'bha ɔ. ");
INSERT INTO kyf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Ɩn wa 'ka ɔ 'lakpanya, -wa 'nɩa -Lagɔ -yi, yoo 'nyɛ, -maa 'ka ɔ gla palɩ, -maa 'ka ɔ sɛlɩ, 'ɩn wa 'ka ɔ *su -gʋ lakʋlʋ. 'Ɩn 'ylɩ 'sɔ we tanʋ nya, ɔ 'ka tlɩtlɩnya glaa 'wʋsɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tɔʋn, Zebedeee 'ŋwnɔ -yɔ ɔ nʋkpasuyua 'sɔ yia -Zezu -yɔbɛ. 'Ɩn ɔ yia ɔ 'yu 'wʋkwli, ɔ 'ka ɔ bhubhoe. -Zezu nɛɛ ɔ -yla: «-A 'nʋ -mɔ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ɔ nɛɛ: «Nɩɩ, na 'yua sɔ nɩ, zlɩ -ɩn -ka nyɩma 'wlulapɩlɩda -mɩ, -na zukpa -wa, -ɩn 'nyɛ wa 'yoo, yabhlo 'ka -na lilisɔlʋ ladɩ, 'ɩn yabhlo 'ka -na kɔpɛsɔlʋ ladɩlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","-Zezu nɛɛ wa -yla: «-We a zlalɩa da 'mɩ, a 'nɩ we -yi. 'Lee, sɩasɩe -we zɔ na yia 'yligbea, a mneni a 'ka we zɔ 'yligbee?» Wa nɛɛ: «Ɩɩn, -a mneni we!» ");
INSERT INTO kyf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ɔ nɛɛ: «Cɩɩn, gbʋzɔnʋ -wa. Sɩa a yia 'mɩ 'bhisa. Nɩɩ, na lilisɔlʋ ladɩdɩe mɩa, we 'nɩ -amɩ 'ka -bha we -sa. Wee 'bɩnya mɩa, -wa -yla na dide mnazɩa we la, wa -nʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wa -lima kugbua 'nʋa we, 'ɩn wa yia wa bhelia 'sɔ -yɔ 'cɛ 'palɩ. ");
INSERT INTO kyf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tɔʋn, -Zezu yia wa 'dɛ weee la, ɔ nɛɛ: «A -yi we 'ji nɩɩ, dʋdʋgʋ -nyɩmaa 'yugalɩnya mɩa, -cɩan 'bhisa wa pɩlɩa nyɩma 'wlu la. 'Ɩn wa nyɩma 'kadɩ sɩalɩa wa zɔlubhonʋnya wa 'tɩtɛ nya. ");
INSERT INTO kyf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nɩɩ, aɩn glaa, we 'na 'ka 'sa -mɩ. Nɩɩ, -ɔ -ka gba ɔ 'ka nyɩmɛ 'kadʋ -zɛ, ɔ -zɛ ɔ -limaa zɔlubhonʋnyɔ. ");
INSERT INTO kyf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Ɩn aɩn glaa, -ɔ -ka gba ɔ 'ka ɔ -lima 'yugalɩ, ɔ -zɛ ɔ -limaa gaylo. ");
INSERT INTO kyf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Sa -bhlokpadɛ, ɔɔ Nyɩmɛɛ 'Yu 'nɩ yi wa 'ka ɔ 'wʋsa. Nɩɩ, yi ɔ yia ɔ 'ka nyɩma 'wʋsa, 'ɩn ɔ 'ka tlɩ, nyɩma duun 'wʋzɩtɩee 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Da wa 'bhʋa Zelikoo, 'ɩn nyɩmaa -zlo yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Lɔlɔnya sɔ -dɩa 'yoo ŋwɛ -yɔ la, wa 'nʋa nɩɩ, -Zezu mɩ 'plɩda, 'ɩn wa yia 'wʋkpɩ: «-Amɩaa -Kanyɔ, -Davidɩɩ 'yuɔɔ, -ɩn 'yɩlɩ -aɩn nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Ɩn nyɩma duun yia wa 'wluo 'kpɩlɩ, wa nɛɛ wa -yla: «A 'mu ŋwɛ -nya!» Tɔʋn, -bha -maa 'kpɩa 'wʋ 'tɩtɛɛ: «-Amɩaa -Kanyɔ, -Davidɩɩ 'yu, -ɩn 'yɩlɩ -aɩn nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","-Zezu yia 'yligbe, ɔ laa wa, 'ɩn ɔ nɛɛ: «-A 'nʋ -mɔ, lɛɛ -lu a 'yɩbha ɩn nʋ lɛ aɩn -ylaa?» ");
INSERT INTO kyf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wa nɛɛ: «-Amɩaa -Kanyɔ, -blo -amɩaa 'yli!» ");
INSERT INTO kyf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wa -laa ɔ nyazɩ 'wʋ, 'ɩn ɔ yia wa 'yli kwɛ zɩ. -Bha -bhlokpadɛ wa 'dɛsɔbhie 'yɩa la, 'ɩn wa yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","-Zezu -yɔ ɔ 'bɩnɔnya 'sɔ, wa bɛa -Zeluzalɛmʋ, wa nynia 'gbe -we wa laa Bɛtɩfaze, -we mɩa *Olivʋsunyaa -gɔgɔ kwesi, -bha -Zezu tiea ɔ 'bɩnɔnya 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ɔ nɛɛ wa -yla: «'Gbe -we mɩa -mɛmɛ aɩn 'yu, a mnɩ -mɔ. A -ka -mɔ nyni, tɔʋn, -sokofalɩŋwnɔ a yia -mɔ 'yɩa, we mɩ lubhu -jɩda, we 'yu mɩ we kwesi. A -sa we lubhu, a -yɔ we 'dɛsɔbhie yi. ");
INSERT INTO kyf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wa -ka aɩn -yla gbʋ gba, a 'palɩ we 'bɩgʋɛ: ‹-Amɩaa -Kanyɔ 'yɩbha we.› -Bha -bhlokpadɛ wa yia we aɩn yoo 'nyɛa, a -yɔ we 'ka yi.» ");
INSERT INTO kyf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Sa we 'plɩa sa, 'ɩn -we -Lagɔgbʋʋ -falɩpanyɔ gbaa we 'ka gbʋzɔnʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Nɩɩ, a gba *Siɔngbe 'wʋ -nyɩma -ylaɛ: ‹A -talɩ, amɩaa 'wlulapɩlɩnyɔ mɩ amɩaa -gbɛ yida. Ɔ'ɔ 'ylimanɩ ɔ 'dɛ. Ɔ -dɩ -sokofalɩŋwnɔ -gʋ la, nɩɩ, -sokofalɩŋwnɔ -dɔgbʋ -wa.› » ");
INSERT INTO kyf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tɔʋn, ɔ 'bɩnɔnya 'sɔ mnɩa, -we -Zezu gbaa, 'mʋ wa nʋa lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wa -laa wee -sokofalɩ -yɔ we 'yu -Zezuu -gbɛ, 'ɩn wa yia wa 'naa we -gʋ slʋ, 'ɩn ɔ yia we -gʋ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nyɩmaa -zlo slʋa wa 'naa 'yloogblʋ, tɔlʋa -dɩa saʋn, 'ɩn wa yia we 'yloogblʋ lapalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nyɩma -wa nɔa ɔ 'yu we -yɔ wa nɔa ɔ lʋʋ, wa 'dɛ weee 'kpɩa 'wʋ, wa nɛɛ: «-A -mnɩnɩ -Davidɩɩ 'yuu 'ŋnɩ. -Ɔ mɩa Jejitapɛɛ 'ŋnɩ nya yida, -Lagɔ ŋwna ɔ 'nyu la. -Wa mɩa yalɩ, wa -mnɩnɩ -Lagɔɔ 'ŋnɩ!» ");
INSERT INTO kyf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","-Zezu plaa -Zeluzalɛmʋ, 'ɩn 'gbe 'wʋ -nyɩma weee yia gbugblolu. Wa nɛɛ: «Mɔɔ -nyɩmɛ ɔ -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tɔlʋa nɛɛ: «Galilee -dʋdʋ -gʋ, Nazalɛtɩyu -Zezu -wa. Nɩɩ, -Lagɔgbʋʋ -falɩpanyɔ ɔ -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nɩɩ, -Zezu mnɩa -Lagɔbudu 'kadʋ ŋwɛɛ, 'ɩn ɔ yia -valɛpanya -yɔ -valɛzɔnya -bha vu. Ɔ yia 'gwɛzi -bhitinyaa 'tabhle labhlɩ, we -yɔ -kpakʋn pɛlʋpanya kpenya. ");
INSERT INTO kyf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","'Ɩn ɔ nɛɛ wa -yla: «We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹Na -budu mɩa, 'mʋ wa yia laa -Lagɔbhubhoe -budu.› 'Ɩn 'mʋ amɩa nʋa 'wienyaa zizeda 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Lɔlɔnya -yɔ 'tɩgɩtɩgɩnya bɛa -Zezu -yɔ -mɔ -Lagɔbudu 'kadʋ ŋwɛɛ, 'ɩn ɔ yia wa jipe. ");
INSERT INTO kyf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","-Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya 'yɩa -Zezuu ŋwɛgaga -sʋbhalɩ gbʋ -yɔ, 'ɩn wa 'nʋa 'ylaaslɩɩ 'wʋkpɩwɛlɩ -Lagɔbudu 'kadʋ ŋwɛɛ: «-A -mnɩnɩ -Davidɩɩ 'yuu 'ŋnɩ,» 'ɩn wa yia 'cɛ 'pa. ");
INSERT INTO kyf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wa nɛɛ -Zezu -yla: «-We wa mɩa gbada, -ɩ'ɩn 'nʋ wee?» 'Ɩn -Zezu nɛɛ: «Ɩɩn, 'nʋ na nʋ we wa. Nɩɩ, -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, a 'nɩ -slɔ we zɛlɩɩ? We nɛɛ: ‹-Mɩ nʋa we lɛ, 'ɩn 'ylaaslɩ -yɔ 'nyɛnyɛyua mɩa -na 'ŋnɩ -mnɩnɩda.› » ");
INSERT INTO kyf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tɔʋn -Zezu 'bhʋa wa -yɔ, ɔ 'tlaa wee 'gbe 'wʋ, ɔ mnɩa Betani, 'ɩn ɔ yia -mɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Zlɩ zlɩa, -Zezu mɩ -Zeluzalɛmʋ lʋmnɩda, 'ɩn ŋwɔ yia ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ɔ mɩ nɔda, 'ɩn ɔ yia *figɩsu -yɔyɩ 'yoo ŋwɛ -yɔ. Ɔ bɛa we kwesi, we kpɩɩ 'dɛkpʋa mɩa we 'wlu, 'ɩn ɔ nɛɛ figɩsu -yla: «-Mɩ 'na 'palɩ 'maslɛɛn 'bhue -nɩ!» -Bha -bhlokpadɛ wee figɩsu yɛa. ");
INSERT INTO kyf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ɔ 'bɩnɔnya 'yɩa we -yɔ, 'ɩn we yia wa ŋwɛgaga -sʋbhalɩ, 'ɩn wa yia ɔ layɩbhaɛ: «Sa -mʋmʋ wee su yɛ 'sa sa slʋɩa?» ");
INSERT INTO kyf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","-Zezu nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: a -ka dlɩ zʋ, 'ɩn a 'nɩ dlɩ lʋ, -we ɩn nʋa da figɩsu nɩ -yla lɛ, a mneni a 'ka we lɛnʋ. A mneni a 'ka -gɔgɔ 'kadʋ -yla gba: -ɩn 'bhʋ da, viteli -na 'dɛ 'nyu lʋ, 'ɩn we nʋa we lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","-We a zlalɩa -Lagɔ dlɩ weee nya, 'yɩa a yia we.» ");
INSERT INTO kyf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","-Zezu mnɩa -Lagɔbudu 'kadʋ ŋwɛɛ lʋ, 'ɩn ɔ yia nyɩma gbʋ -slolu. -Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ bɛa -Zezu -yɔ, 'ɩn wa yia ɔ layɩbhaɛ: «Se -mʋmʋ nya -na nʋ gbʋnya nɩ lɛa? 'Ɩn nyɔɔ 'nyɛ -mɩ we lɛnʋ sea?» ");
INSERT INTO kyf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","-Zezu nɛɛ wa -yla: «Gbʋʋ gɔ -bhlo na yi 'yaa aɩn layɩbhaa, a -ka we 'bɩgʋpalɩ 'bhie, 'ɩn -ɔ 'nyɛa 'mɩ se, 'ɩn na gbaa ɔ 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nyɔɔ tie Zaan ɔ batizee nyɩma, -Lagɔ -wa yaayɩɩ, nyɩma -wa yɩ?» 'Ɩn wa yia we -gʋ kpɛlɩe bhli, 'ɩn wa nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","«-A -ka gba, ‹-Lagɔ tiea ɔ›, 'ɩn ɔ yɩbhaa -aɩn laɛ: ‹Lɛɛ ka 'gbʋ a 'nɩ ɔ wɛlɩ 'wʋŋwnua?› -A -ka gba nɩɩ, nyɩmɛ tiea ɔ, 'ɩn nyɩma sɔlʋa -aɩn -yɔ 'wʋ. Nɩɩ, wamɩa nɛɛ -Lagɔgbʋʋ -falɩpanyɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tɔʋn wa nɛɛ -Zezu -yla: «-Ɔ tiea *Zaan, -a 'nɩ ɔ -yi.» 'Ɩn -mɔɔ nɛɛ: «We -ka 'sa -mɩ, -ɔ 'nyɛa 'mɩ wee gbʋnya -mɩnɩɩ lɛnʋ se, -amɩ 'na 'ka 'ya -mɔɔ -kanyɔɔ 'ŋnɩ aɩn -yla gba.» ");
INSERT INTO kyf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","-Zezu nɛɛ: «Gbʋʋ nine -mʋnɩ, sa a gba we daa? Nɩɩ, nyɩmɛ yabhlo mɩa, ɔ ka nʋkpasuyua 'sɔ. Ɔ nɛɛ 'yabhlo -yla: ‹Na 'yu, -ɩn mnɩ -zɛɛn -dlɔkpaa lubho nʋa.› ");
INSERT INTO kyf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","«-Mɔɔ nɛɛ: ‹Ɩn 'nɩ mnɩda -mɩ.› -Bha bɛa, ɔɔ 'yu yia dlɩ 'bhiti, 'ɩn ɔ yia wee kpaa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Tɔʋn, 'ɩn ɔ dide yia wee wɛlɩ -bhlokpadɛ gba ɔ 'yu -putu -yla. 'Ɩn -mɔɔ nɛɛ: ‹-Ao, mnɩa na yia.› 'Ɩn -mɔɔ 'nɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Nɩɩ, waa 'yua 'sɔ nyɩdɩ, nyɔɔ nʋ ɔ didee dʋmagbʋ lɛa?» Wa nɛɛ: «Ɔ tɩanʋ -wa.» Tɔʋn, -Zezu nɛɛ wa -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: da -Lagɔ yia nyɩma 'wlulapɩlɩa, nisʋn -gwɛzisanya -yɔ 'naabɩzɩŋwnɩ yia aɩn 'yugalɩa. ");
INSERT INTO kyf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nɩɩ, 'Zan -Batisɩ yia amɩaa -gbɛ, 'ɩn ɔ yia aɩn 'yoo tɩklɩɩ da -slolu, 'ɩn a 'nɩ we -yɔŋwnu. Nɩɩ, nisʋn -gwɛzisanya -yɔ 'naabɩzɩŋwnɩ mɩa, -maa yia ɔ 'wʋŋwnu. 'Ɩn a 'yɩa we -yɔ, -mʋʋ 'bɩgʋ a 'nɩ -slɔ dlɩ 'bhiti, 'ɩn a 'ka ɔ 'wʋŋwnu.» ");
INSERT INTO kyf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","-Zezu nɛɛ: «A pʋlʋ gbʋʋ nine yabhlo nɩ yukwli. Nɩɩ, nyɩmɛ yabhlo 'paa -dlɔkpaa. Wee kpaa ɔ bibelia 'suo, 'ɩn ɔ yia -dlɔyaa 'wʋnyazɔlu lɛnʋ. 'Ɩn da wa 'kaa 'yligbe, 'ɩn wa 'kaa kpaa -gʋtalɩ, ɔ yia -mʋʋ 'sʋbha. 'Ɩn ɔ yia we -gʋ -busalubhonʋnya lapalɩ, 'ɩn ɔ yia 'lakpa 'wʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","-Dlɔya -sasa bhla bɛa, 'ɩn ɔ yia ɔ zɔlubhonʋnya tie ɔ -busalubhonʋnya 'bɩ, ɔ 'ka ɔnʋʋ kpaa -lu 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Waa -busalubhonʋnya kpaa ɔ tietienya, 'ɩn wa yia 'yabhlo bhɩtɩ, 'yabhlo wa 'bhaa, 'ɩn wa yia wa tanʋ gbɔkʋ 'wʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","-Mʋʋ 'bɩgʋ, ɔ yi 'yaa ɔ zɔlubhonʋnya tɔlʋa tie. -Maa -zu 'wʋ, -maa -zi wa tɩanʋ. Mʋ -bhlokpadɛ waa -busalubhonʋnya nʋ 'yaa wa -yla lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","-Mʋʋ 'bɩgʋ, ɔ yia ɔ 'dɛɛ 'yu tie, ɔ nɛɛ ɔ 'dɛ dlɩ zɔ: ‹Na yu mɩa, 'mɔ wa yia 'nʋŋwɛ zʋa.› ");
INSERT INTO kyf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Nɩɩ, waa -busalubhonʋnya 'yɩa ɔɔ 'yu -yɔ, wa nɛɛ wa 'dɛ nyɩdɩ: ‹-Ɔ 'kaa cɩ ɔɔ kpaaa -kanyɔ 'bɩ li, mɔ nɩ. -A mnɩ ɔ 'bhaa, 'ɩn -a 'ka ɔ 'bɩ li.› ");
INSERT INTO kyf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wa kpaa ɔ, 'ɩn wa yia ɔ kpaa lʋʋ viteli, 'ɩn wa yia ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Nɩɩ, ɔɔ kpaaa -kanyɔ -ka yi, lɛɛ -lu ɔ 'ka waa -busalubhonʋnya nʋnʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wa nɛɛ ɔ -yla: «Waa 'nyii -cɩan mɩa, 'nyii -sa ɔ yia wa 'bhaa. -Mʋʋ 'bɩgʋ, 'ɩn ɔ palɩa -busalubhonʋnya -putu ɔ -dlɔkpaa -gʋ la, 'ɩn we -dɩdɩ bhla -ka bɛ, 'ɩn ɔ yɩa ɔ kpaa -luu 'ya.» ");
INSERT INTO kyf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tɔʋn -Zezu nɛɛ wa -yla: «-We mɩa -Lagɔsɛbhɛ 'wʋ cɛlɩda, a 'nɩ -slɔ we zɛlɩɩ? We nɛɛ: ‹Tʋkpa -we -budusʋbhanya -saa kwnɛɛ, mʋ -zɛa -buduu gwɩgwɩyli -tʋkpa -zɔnʋ. -Ɔ nʋa gbʋ nɩ lɛ, Jejitapɛ -wa. 'Ɩn wee gbʋ mɩa, -a -ka we 'yɩ, 'ɩn we namanɩa -amɩaa dlɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«We 'dɛɛ 'gbʋ ɩn nɛɛ aɩn -yla, -Lagɔ 'na 'ka 'maslɛɛn aɩn 'wlulapɩlɩ, ɔ nyazɩdlɩ nya. -Wa nʋa ɔ dʋmagbʋ lɛ, 'ma ɔ yia 'wlulapɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wee tʋkpa mɩa, nyɔɔ -ka we -gʋ bhlili, la ɔ wʋwlalɩa. 'Ɩn -mɔmɔ -gʋ we -ka bhlili, ɔ tɔpʋ we saa.» ");
INSERT INTO kyf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","-Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma 'nʋa wee gbʋʋ ninenya nɩ, 'ɩn wa yia we 'jiyibheli nɩɩ, 'ma ɔ saa 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wa ka 'klɩ 'yɩ wa 'ka ɔ kpa, 'ɩn wa yia nyɩmaa -zlo sɔ. -We ka gbʋ -wa, -maa nɛɛ nɩɩ, -Lagɔgbʋʋ -falɩpanyɔ ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","-Zezu gbaa nyɩmaa -zlo -yla gbʋʋ nine -papɩe nya, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«-We -yɔ *-Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa mʋ nɩ: dʋdʋʋ 'wlulapɩlɩnyɔ yabhlo mɩa, ɔ yu kwaa 'ŋwnɔ. 'Ɩn ɔ 'yɩbha ɔ 'ka we 'fɛtɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɔ laa nyɩma, ɔ tiea ɔ zɔlubhonʋnya wa 'wʋ wa 'ka yi, wa nɛɛ nɩɩ, wa 'nɩ yida -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɔ yi 'yaa tɔlʋa tie, ɔ nɛɛ: ‹-Wa ɩn laa a gba wa -yla nɩɩ, ɩn ka wa -yla pi. Ɩn ka na 'bhlinya -yɔ na 'kpɩ -ka -nɩma 'bha wa -yla. We 'dɛ weee mɩ -bha. Wa yi 'ŋwnɔkwafɛtɩ 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","«Nɩɩ, -wa ɔ laa, wa 'nɩ we -yɔŋwnu. 'Ɩn wa yia wa dʋmagbʋ lɛnʋa mnɩ. Tɔlʋa mnɩa kpaa, tɔlʋa mnɩa -valɛ 'paa. ");
INSERT INTO kyf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'Ɩn tɔlʋa yia ɔ zɔlubhonʋnya kpa, wa sɩalɩa wa, 'ɩn wa yia wa 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Nɩɩ, ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ yia 'cɛ 'pa, 'ɩn ɔ yia ɔ 'slʋja tie, -wa 'bhaa da nyɩmɛ, wa 'ka wa 'bha, 'ɩn wa 'ka wa 'gbe 'yli fa. ");
INSERT INTO kyf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tɔʋn, ɔ nɛɛ ɔ zɔlubhonʋnya -yla: ‹'Ŋwnɔkwafɛtɩ -gʋ -lililu mɩ -bha. -Wa ɩn laa, wa 'nɩ we 'klʋ -ka wa 'ka we li. ");
INSERT INTO kyf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","We 'dɛɛ 'gbʋ, a 'plɩlɩ 'gbee 'yoo weee -gʋ, -wa a -ka 'yɩ, a la wa, wa 'ka yi.› ");
INSERT INTO kyf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","«Tɔʋn, ɔ zɔlubhonʋnya yia 'yoo weee 'wʋplɩlɩ, 'ɩn wa yia wa 'dɛ weee 'wlugʋgwlalɩ. 'Sa wa laa nyɩma duun, 'ɩn fɛtɩ -budu yia ye. ");
INSERT INTO kyf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tɔʋn, ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ plaa -mɔ ɔ 'ka -wa ɔ laa -gʋtalɩ, 'ɩn ɔ yia nyɩmɛ yabhlo 'yɩ -mɔɔ 'nɩ 'fɛtɩ -gʋ -bana 'wʋpla. ");
INSERT INTO kyf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Ɩn ɔ nɛɛ ɔ -yla: ‹'Tale, -ɩn 'nɩ 'fɛtɩ -gʋ -bana 'wʋpla. Sa -ɩn pʋplalɩ -seli 'wʋlaa?› Ɔ 'nɩ gbʋ -gʋ -sa. ");
INSERT INTO kyf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Tɔʋn, ɔɔ 'wlulapɩlɩnyɔ nɛɛ ɔ zɔlubhonʋnya -yla: ‹A gbʋan ɔ bhʋ -yɔ ɔ sɔ. A viteli ɔ 'pipee -mɔ nikpise 'wʋ. Da wa wia, 'ɩn wa lia gla 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«Nɩɩ, -Lagɔ laa nyɩma duun, 'ɩn -wa ɔ -saa -bha, -maa -sɛlɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falizɩnyɩma gbelia 'wlu, wa 'ka 'klɩ 'yɩ, 'ɩn wa 'ka -Zezu -dawli 'wʋnʋ, 'ɩn ɔ 'dɛɛ gbagbawɛlɩ 'ka ɔ gbʋan. ");
INSERT INTO kyf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Falizɩnyɩma tiea wa 'bɩnɔnya tɔlʋa -yɔ Ewlodʋʋ nyɩma tɔlʋa -Zezuu -gbɛ. -Maa nɛɛ ɔ -yla: «-Slolunyɔ, -a -yi we 'ji nɩɩ, gbʋzɔnʋ -na gbaa. 'Ɩn sa -Lagɔ 'yɩbhaa nyɩmɛ nʋ, 'mʋ -na slolua tɩklɩɩ. Nyɩmɛ -ka 'yli, -nanʋʋ -gbɛ, we bhe, we 'dɛɛ 'gbʋ, -ɩ'ɩn sɔ nyɩmɛ. ");
INSERT INTO kyf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","We -ka 'sa -mɩ, -ɩn nɛɛ lɛa? 'Lee, we mɩ tɩklɩɩ -amɩaa tite nʋkplɛ, -a plʋlʋ *Sezaa kwɛɛ *nisʋn -gwɛzii?» ");
INSERT INTO kyf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nɩɩ, -Zezu yibhelia wa 'wlukʋʋn lapʋpalɩ -gbʋ 'nyuu, 'ɩn ɔ nɛɛ wa -yla: «Wɛlɩ 'sɔ -nyɩma, lɛɛ -lu ka 'gbʋ a yla 'mɩ laa? ");
INSERT INTO kyf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'Gwɛzi -we a plʋlʋa Sezaa kwɛɛ, a -slolu 'mɩ we 'klʋ.» 'Ɩn wa yia ɔ tama yabhlo yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Ɩn ɔ nɛɛ: «'Lee, nyɔɔ ka 'wlu -yɔ ɔ ŋnɩ mɩ da we -gʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wa nɛɛ: «Sezaa -wa.» -Bha ɔ gbaɛ: «-We -ka Sezaaa -nʋ, a 'nyɛ we Sezaa yoo. 'Ɩn -we -ka -Lagɔɔ -nʋ, a 'nyɛ we -Lagɔ yoo.» ");
INSERT INTO kyf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wa 'nʋa wee wɛlɩ, 'ɩn we yia wa ŋwɛgaga -sʋbhalɩ, 'ɩn wa yia ɔ -yɔbhʋ, 'ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","*Sadusenyɩma mɩa, wa nɛɛ nɩɩ, tlɩtlɩnya 'nɩ mneni wa 'ka tlɩtlɩe lʋ 'wʋsɔ. Wee 'ylɩ -bhlokpadɛ nya, waa Sadusenyɩma tɔlʋa bɛa -Zezu kwesi. ");
INSERT INTO kyf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wa nɛɛ ɔ -ylaɛ: «-Slolunyɔ, Moizɩ nɛɛ: ‹Nɩɩ, nyɩmɛ -ka tlɩ, ɔ -yɔ ɔ 'ŋwnɔ 'nɩ 'yu gwalɩ, ɔ bheli kwa ɔ -dʋgbaŋwnɔ, 'ɩn ɔ -yɔ ɔɔ 'ŋwnɔ 'sɔ 'ka ɔ bhelii zʋa lala 'ɩn -mɔɔ 'ŋnɩ 'ka dʋdʋ -gʋ -tʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","«Nɩɩ, zlɩmɛ -amɩaa -gbɛ nyɩmɛ yabhlo ka nʋkpasuyua gbesɔ. Wa kpasa kwaa 'ŋwnɔ, ɔ -yɔ ɔ 'nɩ gwalɩ, 'ɩn ɔ yia tlɩ. 'Sa ɔɔ 'ŋwnɔ -tʋa ɔ bheli -yɔ. ");
INSERT INTO kyf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'Sa -bhlokpadɛ we nʋa ɔ bhelii 'sɔnʋ nya, ɔ bhelii tanʋ nya, 'sa -bhlokpadɛ we nʋa waa bhelia gbesɔɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wa 'dɛ weee 'bɩgʋ, 'ɩn ɔɔ 'ŋwnɔ yi 'yaa tlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","«'Ylɩ -we nya waa tlɩtlɩnya yia 'wʋsɔa, waa bhelia gbesɔ glaa, nyɔɔ ka 'ŋwnɔ ɔ -mɩa? Nɩɩ, wa 'dɛ gbesɔ kwaa ɔ -bhlo -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ɔ nɛɛ wa -yla: «Amɩaa 'dɛ a nʋa -dawli 'wʋ. -We ka gbʋ -wa, a 'nɩ -Lagɔsɛbhɛ -yɔ -Lagɔɔ 'tɩtɛ -yi. ");
INSERT INTO kyf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nɩɩ, tlɩtlɩnya -ka 'wʋsɔ, nʋkpasia -yɔ 'ŋwnɩ 'na 'ka kʋkwalɩ. Nɩɩ, 'anzɩnya -we mɩa yalɩ, we 'bhisa wa yia -tʋa. ");
INSERT INTO kyf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Lee, -we -Lagɔ gbaa aɩn -yla tlɩtlɩnyaa 'wʋsɔgbʋʋ daa, a 'nɩ -slɔ we zɛlɩɩ? Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹-Amɩ -wa *Ablaamʋʋ -Lagɔ, *Izakɩɩ -Lagɔ, *Zakɔbʋʋ -Lagɔ.› » 'Ɩn -Zezu yia we -gʋdɩɛ: «-Lagɔ mɩa, 'yliyɔganyaa -Lagɔ -wa. Ɔ 'nɩ tlɩtlɩnyaa -Lagɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nyɩmaa -zlo 'nʋa we nɩ, 'ɩn -we ɔ -slolua wa, 'ɩn we yia wa ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Da Falizɩnyɩma 'nʋa nɩɩ, -Zezu ka Sadusenyɩma lu, -bha wa gbelia 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wa 'yabhlo mɩa, -Lagɔɔ titee gwesanyɔ mɔ. Ɔ 'yɩbha ɔ 'ka -Zezu layla, 'ɩn ɔ yia ɔ layɩbhaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«-Slolunyɔ, -amɩaa tite weee glaa, -mʋmʋ -wa we 'kadʋa?» ");
INSERT INTO kyf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","-Zezu nɛɛ ɔ -yla: « ‹Jejitapɛ, -ɔ -wa -na -Lagɔ, -ɩn -kalɩ ɔ zɛ -na dlɩ weee nya, -na zuzu weee nya, -na 'wlukʋʋn lapʋpalɩe weee nya.› ");
INSERT INTO kyf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mʋ -wa wee titee tɩanʋ. 'Ɩn we 'kadʋ we -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Ɩn wee titee 'sɔnʋ -we mɩa we 'kadʋ -mɩnɩ 'bhisa, mʋ nɩ: ‹-Ɩn -kalɩ -na -libheyii zɛ -na 'dɛ 'bhisa.› ");
INSERT INTO kyf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nɩɩ, Moizɩɩ *tite weee -yɔ -we weee -Lagɔgbʋʋ -falɩpanya -slolua, mʋ -gʋ wa -saa we.» ");
INSERT INTO kyf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falizɩnyɩma mɩ 'wlugbelida -bhlokpadɛ, 'ɩn -Zezu yia wa layɩbhaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«A nɛɛ lɛa? -Lagɔɔ -Bhasanyɔ mɩa, nyɔɔ ka 'yu ɔ -mɩa?» Wa nɛɛ: «-Davidɩɩ yu -wa.» ");
INSERT INTO kyf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ɔ nɛɛ wa -yla: «-Lagɔɔ Zuzu 'sua -Davidɩ, 'ɩn ɔ yia ɔ la ‹Na -Kanyɔ›, lɛɛ -lu ka 'gbʋa? ");
INSERT INTO kyf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nɩɩ, -Davidɩ nɛɛ: ‹Jejitapɛ nɛɛ na -Kanyɔ -yla: «-Ɩn -dɩ da la na lilisɔlʋ. 'Ɩn ɩn 'ka -na tʋnyɩma -na bhʋ zɔ lapalɩ.» › ");
INSERT INTO kyf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","We -ka nɩɩ, -Davidɩ la ɔɔ -Lagɔɔ -Bhasanyɔ, ‹na -Kanyɔ›, ɔ 'nɩ mneni ɔ 'ka -Davidɩɩ 'yu -zɛ, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","-Ɔ mnenia ɔ 'ka ɔ wɛlɩɩ 'bɩgʋpalɩ, ɔ 'nɩ -mɩ. We 'bhʋ wee 'ylɩ 'wʋ, nyɩmɛ yabhlogbɔɔ'ɔ 'yɩbha -slɛɛn ɔ la. ");
INSERT INTO kyf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","-Mʋʋ 'bɩgʋ, -Zezu gbaa nyɩmaa -zlo -yɔ ɔ 'bɩnɔnya -yla, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma mɩa Moizɩɩ 'bɩgʋ, wa 'ka ɔ titee 'ji gba. ");
INSERT INTO kyf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","We 'dɛɛ 'gbʋ a zʋ wa 'nʋŋwɛ. 'Ɩn -we weee wa yia gbaa, a 'ka we lɛnʋ. Nɩɩ, -we wa nʋa lɛ, a 'na nʋnʋ we lɛ -nɩ. Nɩɩ, -we wa slolua, wa 'dɛ'ɛ nʋ we -gʋgbʋ lɛ. ");
INSERT INTO kyf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Gba 'kadʋ wa nʋa lɛ, 'ɩn wa dɩa we nyɩma 'wlu, 'ɩn -zugba wa -kwɩtaya -bhlogbɔɔ'ɔ 'tlili we. ");
INSERT INTO kyf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","-We weee wa nʋa lɛ, -zejila 'wʋ wa nʋa we lɛ, nyɩma 'ka wa -yɔyɩɩ 'gbʋ. -Lagɔwɛlɩ -kibhe wa gbʋan wa 'klɔɔ, wa sɔ -yɔ, -tʋkpʋ 'kadɩ 'wʋ wa zʋa we. Wa -banaa ŋwɛ wa lʋa, 'ɩn we tlʋmanɩa. ");
INSERT INTO kyf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","-Lagɔbudu zɔ -yɔ 'fɛtɩnya -gʋ, 'yugbɛɩn ladɩdɩe wa 'yɩbhaa kpe -zɔnʋnya -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nyɩma -ka wa fʋsa -zejila 'wʋ, wa 'nʋŋwɛzʋzʋe nya, wa -ka wa la ‹*Wlabi›, 'ɩn we namanɩa wa dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Nɩɩ, amɩa, a 'na ŋwnunu wa 'ka aɩn ‹Wlabi› la -nɩ. -We ka gbʋ -wa, bhelia a 'dɛkpʋa -mɩa, amɩaa -Slolunyɔ -bhlogbɔɔ. ");
INSERT INTO kyf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A 'na lalɩ dʋdʋgʋ -nyɩmɛ yabhlogbɔɔ ‹Dide› -nɩ. Nɩɩ, amɩaa Dide -bhlogbɔɔ, ɔ mɩ yalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amɩaa 'dɛkpʋa nyɩdɩ, a 'na lalɩ nyɩmɛ ‹-Kanyɔ› -nɩ. Amɩaa -Kanyɔ -bhlogbɔɔ, mɔ -wa -Lagɔɔ -Bhasanyɔ. ");
INSERT INTO kyf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","-Ɔ 'kaa aɩn 'yugalɩ, ɔ -mɩ amɩaa zɔlubhonʋnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","«Nɩɩ, nyɩmɛ -ɔ ylimanɩa ɔ 'dɛ, zɔ -Lagɔ yia ɔ bɛlɩa, 'ɩn nyɩmɛ -ɔ bɛlɩa ɔ 'dɛ zɔ, 'ylimanɩa -Lagɔ yia ɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ɔ nɛɛ 'ya: «-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa. -We ka gbʋ -wa, -Lagɔɔ nyɩmaa 'wlulapɩlɩgbee 'yoo a kɩklalɩa. Amɩaa 'dɛ'ɛ pla -mɔ, 'ɩn -wa 'yɩbhaa wa 'ka -mɔ pla, 'ɩn a kʋlʋa wa 'yoo.  ");
INSERT INTO kyf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa. -We ka gbʋ -wa, -dʋgbaŋwnɩ a saa -maa -lu weee kwɛɛ. 'Ɩn a bhubhoea -Lagɔ nyɩmaa 'yliya 'wʋ kpokpo, nyɩma tɩklɩɩ 'bhisa. We 'gbʋ, -Lagɔ yia amɩaa -yɔgbʋ 'wʋbhua, 'ɩn amɩaa -kaslʋ 'ka nyɩma tɔlʋaa -nʋ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa! -We ka gbʋ -wa, dʋdʋ weee -yɔ 'nyu weee -gʋ a plɩlɩa, a 'ka nyɩmɛ yabhlogbɔɔ 'yɩ, ɔ 'ka amɩaa gbʋ -yɔŋwnu. A -ka -mɔɔ 'yɩ, 'ɩn amɩaa lɛnʋgbʋ zɛlɩa -mɔɔ nyɩmɛ 'nyuu. 'Ɩn -Lagɔ paa ɔ -kaslʋ 'wʋ, we 'ka amɩaa -nʋ -zi -zakpa 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Amɩa, nyɩmaa 'yoo daslolunya, a ka 'lɔ, gbʋnyuu mɩ amɩaa -nʋ nya! A nɛɛ: ‹Nyɩmɛ -ka -Lagɔbudu 'kadʋ bi, we mɩ bhe. 'Ɩn -ɔ -ka -Lagɔbudu 'kadʋʋ -can bi, we mɩ nɩɩ, ɔ nʋ we lɛ tɛɩn.› ");
INSERT INTO kyf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","-Sabhɛ 'wlukʋʋn, 'lɔlɔnya! Nɩɩ, -Lagɔbudu 'yli we -zi -can, mʋ nʋa lɛ, 'ɩn -can yia -lu tɩklɩɩ -zɛ. A 'nɩ we 'ji -yii? ");
INSERT INTO kyf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A nɛɛ 'yaɛ: ‹Nyɩmɛ -ka 'slakagʋsalɩlu bi, we bhe. Nɩɩ, nyɩmɛ -ka wlawlalu -we mɩa 'slakagʋsalɩlu -gʋ bi, we mɩ nɩɩ, ɔ nʋ we lɛ teɩn.› ");
INSERT INTO kyf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'Lɔlɔnya, nɩɩ, 'slakagʋsalɩlu 'yli we -zi wlawlalu. Mʋ nʋa lɛ, 'ɩn wlawlalu yia -lu tɩklɩɩ -zɛ, a 'nɩ we 'ji -yii? ");
INSERT INTO kyf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nɩɩ, nyɩmɛ -ka 'slakagʋsalɩlu bi, 'slakagʋsalɩlu -yɔ -lu weee wa palɩa we -gʋ la, 'mʋ ɔ bia. ");
INSERT INTO kyf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nyɩmɛ -ka -Lagɔbudu 'kadʋ bi, -Lagɔbudu -yɔ -Lagɔ, -ɔ -dɩa -mɔ la, 'ma ɔ bia. ");
INSERT INTO kyf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nyɩmɛ -ka yalɩ bi, -Lagɔɔ 'ŋnɩmnɩkpe -yɔ -ɔ -dɩa we -gʋ la, 'ma ɔ bia. ");
INSERT INTO kyf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa! -We ka gbʋ -wa, -titikpɩ -we mɛnɩa: 'matɩ klaa, fɛnuwɩ klaa, we -yɔ kumɛ 'bhisa, we kugbuaa -gʋ -bhlo -nʋ a bhua 'wʋ, 'mʋ a nyɛa -Lagɔ. -Zugba a tide -Lagɔɔ titee gbʋ 'kadɩ 'yi, -we -wa: ‹A -mɩ tɩklɩɩ, a -ka nyazɩdlɩ, 'ɩn a zʋ -Lagɔ dlɩ -gʋ.› -We mɩa dɛ, 'mʋ a 'ka yaa lɛnʋ tɩa, 'ɩn a 'na dlʋlʋ -luu kugbua -gʋ -bhlo -nʋʋ wlawlɩe 'wʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amɩa, nyɩmaa 'yoo daslolunya, a ka 'lɔ! Amɩaa 'mama nyu a lloa 'wʋ, a 'ka -mɔ -knɩknɩ -saa 'gbʋ. Tɔʋn, 'ɩn a mnaa *-nyɔmɛɛ, -glu! ");
INSERT INTO kyf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa! -We ka gbʋ -wa, 'kɔpʋ -yɔ 'sɛtɩɩ ku -yɔ a wɔlʋa, 'ɩn -zugba 'wie -yliylie -yɔ 'nyii ye we. ");
INSERT INTO kyf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falizɩnyɩmɛ, -ɩn ka 'lɔ. Tɩada, -wɔlʋ -slɔ wee 'kɔpʋʋ nʋkplɛ we 'ka tɩklɩɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa! -We ka gbʋ -wa nɩ, -we -yɔ aɩn 'wʋwlʋa, mʋ -wa gbawla -we -yɔ wa 'paa pɛntlu 'pʋpa. We ku -yɔ mɩa, 'yli we nanɩa. We nʋkplɛ mɩa, we mɩ yeda 'kʋa klaa, 'kwie klaa, we -yɔ zɛnzɛn -lu weee nya. ");
INSERT INTO kyf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sa 'bhisa, nyɩma -ka aɩn 'yɩ nɩ, a mɩ tɩklɩɩ wa 'yliya 'wʋ, 'ɩn amɩaa nʋkplɛ mɩa, yo mɩ -mɔ, 'ɩn a 'nɩ tɩklɩɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«-Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Wɛlɩ 'sɔ -nyɩma a -mɩa! -We ka gbʋ -wa, -Lagɔgbʋʋ -falɩpanya -yɔ nyɩma tɩklɩɩɩ gbawla a sʋbhaa, 'ɩn a namanɩa we 'yli. ");
INSERT INTO kyf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ɩn a nɛɛ: ‹-A -ka yaa -amɩaa dʋkpasɩɩ bhla 'wlʋ, -a 'na 'ka yaa wa glaa -mɩ, -a 'ka -Lagɔgbʋʋ -falɩpanya lasa.› ");
INSERT INTO kyf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Sa a bhua amɩaa 'dɛɛ -yɔgbʋ 'wʋ. -Wa 'bhaa -Lagɔgbʋʋ -falɩpanya nɩ, wa 'yuaa 'dɛbhie -gbolu a -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","We -ka 'sa -mɩ, -we amɩaa dʋkpasɩ dɩa gwe, a bhɩa we. ");
INSERT INTO kyf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tɩbhɛnya, 'mʋnɩmɛɛ -gnʋ! Amɩaa dlɩ 'wʋ nɩɩ, a mneni a 'ka -Lagɔ amɩaa -Kosu 'wʋpapɩe kwɛɛ 'tlaa? -Ɩnnya, a 'nɩ we mneni. ");
INSERT INTO kyf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","We 'dɛɛ 'gbʋ, a pʋ yukwli. Nɩɩ, -Lagɔgbʋʋ -falɩpanya klaa, gbʋyilonya klaa, we -yɔ nyɩma -wa 'kaa aɩn gbʋ -slolu, 'ma na yia amɩaa -gbɛ tiea. Tɔlʋa a yia 'bhaa, tɔlʋa a yia *su -gʋ lakʋlʋa, tɔlʋa a yia sɛlɩa -Lagɔbudunya zɔ, 'ɩn a 'ka wa 'bɩ vu 'gbe -bhlo -bhlo 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gbʋ -we ka 'gbʋ ɩn yia wa tie, mʋ -wa nɩɩ, -Lagɔ yia aɩn -kaslʋ 'wʋpaa nyɩma tɩklɩɩ weee wa 'bhaa, wa 'gbʋ. Tɩada, wa 'bhaa *Abɛlɩ, nyɩmɛ tɩklɩɩ. We bhɩalɩda -wa, Balasii 'yu Zakalii 'bhabhɩe. 'Mɔ wa 'bhaa -Lagɔɔ -mɔwlʋda -yɔ 'slakagʋsalɩlu nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -we weee mɩa daa 'gbʋ, -Lagɔ yia dɛslɛɛn -nyɩma -kaslʋ 'wʋpaa. ");
INSERT INTO kyf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«-Zeluzalɛmʋ -nyɩma, -Zeluzalɛmʋ -nyɩma, amɩa -wa bhaa -Lagɔgbʋʋ -falɩpanya, 'ɩn nyɩma -Lagɔ paa aɩn yoo, -wa bhaa wa gbɔkʋ 'wʋ. Sa nynu gʋgwlalɩa we 'yua 'wlu we -kapue zɔ, 'ɩn we gblia we -gʋ la, ɩn 'yɩbha ɩn 'ka 'sa aɩn 'wlugʋgwlalɩ bhla weee nya, 'ɩn a 'nɩ we -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","We 'gbʋ, -Lagɔ yia amɩaa -budu 'kadʋ sɔlʋ lapalɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ɩn nɛɛ aɩn -ylaɛ: a 'na 'ka 'maslɛɛn 'mɩ 'yɩ, 'ɩn bhla -we nya a 'kaa gba nɩɩ, ‹Nyɩmɛ -ɔ yia Nyɩmaa -Kanyɔɔ 'ŋnɩ nya, -Lagɔ ŋwna ɔ 'nyu la›, 'ɩn we bhla 'kaa nyni.» ");
INSERT INTO kyf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","-Zezu 'tlaa -Lagɔbudu 'kadʋ zɔ, ɔ mɩa mnɩda, 'ɩn ɔ 'bɩnɔnya nɛɛ ɔ -yla: «Yla 'saa wee -budu nɩ wa!» ");
INSERT INTO kyf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","-Zezu nɛɛ wa -yla: «A yɩ we -yɔ, we 'nɩ mʋʋ? Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: tʋkpanya -mɩnɩ 'yabhlogbɔɔ 'na 'ka we -libheyi -gʋ -tʋ. Jitea we 'dɛ weee yia.» ");
INSERT INTO kyf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɔ -dɩa Olivʋsunyaa -gɔgɔ 'wlu la, da wa -nyaa 'wʋ, 'ɩn ɔ 'bɩnɔnya yia ɔ kwesi bɛ, 'ɩn wa yia ɔ layɩbha: «Lɛbhla -mʋʋ 'ka lɛnʋa? Lɛɛ -lu 'ka we -slolu nɩɩ, -na yiyibhla -yɔ dʋdʋ labhʋ bhla ka cɩpaa? Gba we -aɩn -yla.» ");
INSERT INTO kyf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɔ nɛɛ wa -yla: «A zʋ amɩaa 'dɛ 'yliyɔ, -mʋʋ yi 'wlʋ nɩɩ, wa nʋ aɩn -dawli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nɩɩ, nyɩma -duun yia na 'ŋnɩ -gʋ yia, 'ɩn wa 'ka gbaɛ: ‹-Amɩ -wa -Lagɔɔ -Bhasanyɔ!› 'Ɩn wa 'ka nyɩma duun -dawli 'wʋnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","«A -ka 'nʋ nɩɩ, wa mɩ tʋgʋda da -kwɛɩn, 'ɩn a -ka 'nʋ nɩɩ, wa mɩ tʋgʋda da 'pɩpɩ, a 'na nʋnʋ nyanɔ -nɩ. We mɩ nɩɩ, we nʋ lɛ, -mʋʋ 'nɩ -slɔ dʋdʋʋ bhɩalɩda. ");
INSERT INTO kyf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tʋ yia laga dʋdʋ 'sɔ nyɩdɩ 'wʋsɔa. 'Gbe yabhlo yia we -libheyi -yɔwʋsɔlʋa. Ŋwɔ yia yia da tɔlʋa, 'ɩn dʋdʋ 'ka zuklu. ");
INSERT INTO kyf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sa 'ŋwnɔ -ka gwalɩa yi ɔ sɩa, 'sa wee dʋdʋ bhɩabhɩee gwedɩda yia -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«We bhla kpaa wa yia aɩn, 'ɩn wa 'ka aɩn 'klɩyɩe 'wʋpalɩ, 'ɩn wa 'ka aɩn 'bha. Na 'gbʋ, dʋdʋgʋ -nyɩma weee yia aɩn 'wʋnyɛa. ");
INSERT INTO kyf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","-Mʋʋ bhla tɔlʋa yia 'mɩ dlɩ -gʋ -saa, 'ɩn wa 'ka wa -lima wla, wa 'ka wa kpa, 'ɩn wa 'ka wa -lima 'wʋnyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nɩɩ, nyɩma duun yia yia, 'ɩn wa 'ka gba nɩɩ, ma -wa -Lagɔgbʋʋ -falɩpanya. Yo -wa yo. 'Ɩn nyɩma duun wa yia -dawli 'wʋnʋa. ");
INSERT INTO kyf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Ylinyunogbʋ yia zumanɩa. We 'dɛɛ 'gbʋ, nyɩmaa zɛkalɩdlɩ yia -gʋdoa bhabha nyɩma duuun dlɩ zɔ. ");
INSERT INTO kyf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nɩɩ, nyɩmɛ -ɔ 'nɩ 'mɩ dlɩ -gʋ -sa, 'ɩn ɔ 'ka we bhloluda nyni, -Lagɔ yia ɔ gbʋ 'wʋsaa. ");
INSERT INTO kyf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nɩɩ, wɛlɩ -zɔnʋ -we gbaa -Lagɔɔ nyɩmaa 'wlulapɩlɩe gbʋ, 'mʋ wa yia gbaa dʋdʋ weee -gʋ, 'ɩn nyɩma weee 'ka we 'nʋ. Tɔʋn, 'ɩn dʋdʋʋ bhɩa bhla nynia. ");
INSERT INTO kyf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nɩɩ, -lu -we -Lagɔ 'nɩa 'yɩbha, 'ɩn we saa -lu weee la, 'mʋ a yia 'yɩa -mɔ -Lagɔɔ -mɔwlʋda. (Nyɩmɛ -ɔ -ka 'sɛbhɛ nɩ zɛlɩ, ɔ 'nʋ we 'wʋla.) Nɩɩ, -Lagɔgbʋʋ -falɩpanyɔ Daniɛlɩ gbaa wee gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nɩɩ, nyɩma -wa -ka Zudee -dʋdʋ -gʋ -mɩ, wa -yɔ -gwagwɩe mnɩ zizea -gɔgɔnya 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nyɩmɛ -ɔ -ka nyapɛda -mɩ 'pipee, ɔ 'na mnɩnɩ ɔ -lu 'wʋbhua -budu zɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'Ɩn -mɔmɔ -ka kpaa -mɩ, -mɔɔ 'na yili -mɔɔ -bana 'bʋ -zɔɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Lɛɛ gbʋnyuu yi 'sa nʋkplabhue ŋwnɩ -yɔ 'ŋwnɩ -wa mɩa 'yua 'nyɛnɩda ylɩa, wee 'ylɩnya -mɩnɩ nya! ");
INSERT INTO kyf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɩɩ, -a bhubhoe -Lagɔ, we yi lɛnʋ ŋwɔtlɔyibhla, we -yɔ *Nyapɛylɩ nya. ");
INSERT INTO kyf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nɩɩ, we bhla mɩa, sɩasɩe 'kadʋ wa yia 'yɩa. 'Lee, -a -ka bhaa 'wlʋ, we 'sasʋkpa -gbʋ ka -slɔ lɛnʋʋ, 'ɩn lɛ we yia nʋa yɩ? -Ɩnnya, we 'na 'ka lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","-Lagɔ 'nɩ yaa wee 'ylɩ -gʋsa, -zugba nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka 'pʋ. Nɩɩ, ɔ nyɩma ɔ -saa -bha, wa 'gbʋ ɔ yia wee 'ylɩ -gʋsa. ");
INSERT INTO kyf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nɩɩ, nyɩmɛ -ka gba -Lagɔɔ -Bhasanyɔ mɩ -seli, 'ɩn wa -ka gba nɩɩ, ɔ mɩ mɔ, a 'na zʋlʋ we dlɩ -gʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yocɩan yia yia, 'ɩn wa 'ka gba nɩɩ, ma -wa -Lagɔɔ -Bhasanya, 'ɩn tɔlʋa 'ka gba nɩɩ, -Lagɔgbʋʋ -falɩpanya wa -mɩa. Gwɛdigbʋ -yɔ gbʋ 'kadɩ wa yia lɛnʋa. 'Ɩn -wa -Lagɔ -saa -bha, 'ɩn wa 'ka wa -dawli 'wʋnʋ, 'ɩn wa 'nɩ we mneni. ");
INSERT INTO kyf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","«A pʋ yukwli ɩn 'ka aɩn 'dɩzʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nɩɩ, nyɩmɛ -ka gba: ‹Ɔ mɩ da bɛblɛɛ›, a 'na mnɩnɩ -mɔ -nɩ, 'ɩn wa -ka gba: ‹Ɔ mɩ zizeda da -putu›, a 'na lalɩ we gbʋzɔnʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa 'nyu -ka 'yɩka 'pa, 'ɩn we -nyumalɩɩ yalɩ 'wʋdɩdɩe bhʋa 'ylʋʋ 'wʋsɔlʋda, 'ɩn we nynia 'ylʋʋ bhlilida, 'sa *Nyɩmɛɛ 'Yu yia yia. ");
INSERT INTO kyf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Da 'kwie -ka -mɩ, -bha -ŋwaaa -zlo mɩa. ");
INSERT INTO kyf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Tɔʋn, wee sɩasɩee 'ylɩnya nɩɩ 'bɩgʋ, ‹Nikpise yia kpaa, 'ylʋ 'na 'ka 'pʋ. Nikpise yia kpaa, 'cʋ 'na 'ka lɩ. Nikpise yia kpaa, -zɛlɩ yia yalɩ 'bhʋa we 'ka bhli. -Lu weee mɩa yalɩ, zuklua we yia.› ");
INSERT INTO kyf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Tɔʋn, -we slolua nɩɩ, ɔɔ Nyɩmɛɛ 'Yu mɩ yida, 'ɩn nyɩma yɩa we -yɔ yalɩ. Tɔʋn, 'ɩn dʋdʋgʋ -nyɩma weee wazɛa, 'ɩn wa kpɩa 'wʋ. -Slɛɛn, Nyɩmɛɛ 'Yu wa yia -yɔyɩa yida yalɩpʋpa 'wʋ, 'tɩtɛ -yɔ zlɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nɩɩ, lɛglɛ 'kadʋ -ka gba, 'ɩn ɔ paa ɔ 'anzɩnya yoo dʋdʋ weee -gʋ, -wa -Lagɔ -saa -bha 'gbe weee 'wʋ, we 'ka wa la. ");
INSERT INTO kyf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«-We figɩsu slolua, a 'nʋ we 'wʋla. We 'klɩya -ka tlʋmanɩda -mɩ, 'ɩn we -ka tɔpɔda -mɩ, a yibheli we 'ji nɩɩ, 'nyu -lʋa bhla ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'Sa -bhlokpadɛ, a -ka 'sasʋkpa -gbʋ -mɩnɩ lɛnʋda 'yɩ, a yibheli we 'ji nɩɩ, ɔɔ Nyɩmɛɛ 'Yuu yiyibhla ka cɩpa. Ɔ 'nɩ -slɛɛn latlʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: dɛslɛɛn -nyɩmaa 'dɛ weee 'na 'ka tlɩ, 'ɩn wee gbʋnya -mɩnɩ 'kaa lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nɩɩ, la yalɩ -yɔ dʋdʋ yia 'bhʋa, na wɛlɩ 'na 'ka labhʋ 'mnumnu. ");
INSERT INTO kyf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Nɩɩ, nyɩmɛ yabhlogbɔɔ 'nɩ wee sɩasɩee bhla -yɔ we 'ylɩ -yi. Yalɩɩ 'anzɩnya -yɔ -Lagɔɔ 'Yuu 'dɛbhie, wa 'nɩ wee 'ylɩ -yi. Nɩɩ, na Dide -bhlogbɔɔ -yia wee 'ylɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","-We 'plɩa *Noweee bhla, zlɩ ɔɔ Nyɩmɛɛ 'Yu yia yia, mʋ yia lɛnʋa. ");
INSERT INTO kyf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Da 'nyu 'kadʋ 'nɩa -slɔ nyɩma lasa, -zugba wa mɩ lida, wa mɩ 'mada, wa mɩ kʋkwalɩda, wa mɩ wa 'ŋwnɩyua ylɩ zʋda. Tɔʋn, 'ɩn Nowee yia batoo 'kadʋ 'wʋgbla. ");
INSERT INTO kyf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Zezeguda 'kaa wa lasaa yi, waa nyɩma 'nɩ gbʋ yabhlogbɔɔ 'wʋlanʋ. 'Sa -bhlokpadɛ we yia -mɩa ɔɔ Nyɩmɛɛ 'Yuu yiyizlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Nyɩma 'sɔ -ka kpaa -mɩ, 'yabhlo wa yia 'wʋbhua, 'ɩn wa 'ka -bha ɔ -libheyi tɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","'Ŋwnɩ 'sɔ -ka bhuda -mɩ, 'yabhlo wa yia 'wʋbhua, 'ɩn wa 'ka -bha ɔ -libheyi tɩ. ");
INSERT INTO kyf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","We 'dɛɛ 'gbʋ, a -tʋ 'yliyɔgada. 'Ylɩ -we nya amɩaa -Kanyɔ 'kaa yi, a 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","«A yibheli we 'ji nɩɩ, bhla -we nya 'wienyɔ 'kaa -buduu -kanyɔɔ -gbɛ yi sabɔ, ɔ -ka we -yi, ɔ 'na 'ka 'ylaa ŋwɔ, 'ɩn ɔ kʋlʋa ɔ 'yoo, -mɔɔ yi -budu zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","We 'dɛɛ 'gbʋ, a mnazɩ amɩaa 'dɛ la. Nɩɩ, bhla -we a 'nɩa -tɔlʋ, we nya Nyɩmɛɛ 'Yu yia yia. ");
INSERT INTO kyf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Zɔlubhonʋnyɔ, -ɔ zʋa ɔ -kanyɔ 'nʋŋwɛ, 'ɩn ɔ -yia gbʋ, sa ɔ mɩa? Mɔ -wa, -ɔ, ɔ -kanyɔ tɩa ɔ -lima -yɔ, 'ɩn lilibhla -ka bɛ, ɔ 'ka wa lililu 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ɔ -kanyɔ -ka lʋyi, ɔ -ka 'yɩ nɩɩ, -mɔɔ mɩ ɔ lubho nʋda, 'wʋtʋtʋe -dlɔɔ mɩ ɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: ɔ -kanyɔ yia -mɔɔ zʋzɔnʋ weee ɔ yoo 'nyɛa ɔ 'ka we 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","We -ka nɩɩ, ɔɔ zɔlubhonʋnyɔɔ nʋkplɛ -nyu 'yli, 'ɩn ɔ gbaa ɔ 'dɛɛ dlɩ zɔɛ: ‹Na -kanyɔ yia -mɔ -gwlɛa.› ");
INSERT INTO kyf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'Ɩn ɔ bhlia ɔ -lima bhɩtɩe, ɔ -yɔ nʋmanya 'sɔ lia, 'ɩn wa maa. ");
INSERT INTO kyf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","'Ylɩ -we nya ɔ 'nɩa ɔ -kanyɔ wʋda -mɩ, 'ɩn bhla ɔ 'kaa yi, ɔ 'nɩa we -yi, we nya ɔ yia. ");
INSERT INTO kyf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɔ -kanyɔ yia ɔ vua, 'ɩn sa -Lagɔ paa wɛlɩ 'sɔ -nyɩma -kaslʋ 'wʋ, 'sa ɔ yia -mɔɔ -kaslʋ 'wʋpaa, mɔ wa wilia, 'ɩn wa lia gla 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Nɩɩ, -we -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'kaa 'wʋwlʋ, mʋ nɩ: mʋ -wa 'yiesia kugbua. 'Ŋwnɔkwafɛtɩɩ zlɩ, ma 'tlaa, wa 'ka 'ŋwnɔɔ 'lowli yoo mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Wa gbu 'nɩa 'ylimna, wa -yɔ wa 'napɛ mnɩa, wa 'nɩ wa 'napɛɛ 'nyu 'wʋbhu. Wa gbu -mama -yia gbʋ, -maa 'bhua -maa 'napɛ -yɔ -maa 'napɛɛ 'nyuu -tʋkpʋ 'sɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɔɔ 'ŋwnɔɔ 'lowli 'nɩ yida -mɩ -pa. 'Ɩn 'kʋa yia wa 'yli lawla. 'Ɩn wa yia 'ylaa ŋwɔ. ");
INSERT INTO kyf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Sabɔ -nyɩdɩ, 'ɩn nyɩmɛ yabhlo yia 'wʋkpɩ: ‹'Lowli ka yiɔɔ! A mnɩ ɔ yooɔɔ!› ");
INSERT INTO kyf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tɔʋn, waa 'yiesia ganɔa, 'ɩn wa yia wa 'napɛ lamnazɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","«-Wa 'nɩa 'ylimna, wa nɛɛ -wa -yia gbʋ -yla: ‹-Amɩaa 'napɛ mɩ nyumoda, a 'nyɛ -aɩn 'napɛɛ 'nyu.› ");
INSERT INTO kyf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«-Wa -yia gbʋ, -maa nɛɛ wa -yla: ‹-Ɩnnya, 'napɛɛ 'nyu 'nɩ 'wʋzu amɩaa -nʋ -yɔ -amɩaa -nʋ -yla. A mnɩ we pɛlʋpanyaa -gbɛ, a 'ka amɩaa -nʋ zɔ -bhlo.› ");
INSERT INTO kyf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Wa mnɩa 'napɛɛ 'nyu zɔa, wa -manɩ -mɔ, 'ɩn 'ŋwnɔɔ 'lowli yia yi. -Wa mnazɩa wa -nʋ la, 'ɩn wa -yɔ ɔɔ 'lowli yia 'fɛtɩɩ -budu zɔ pla. 'Ɩn wa yia -bha kla. ");
INSERT INTO kyf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«-Mʋʋ 'bɩgʋ, wa tɔlʋa -manɩ yia yi, 'ɩn wa nɛɛ: ‹-Amɩaa -kanyɔ, -amɩaa -kanyɔ, -kalɩ -bha, -a 'ka pla.› ");
INSERT INTO kyf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Ɔɔ 'lowli nɛɛ: ‹Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa: ɩn 'nɩ aɩn -yi.› » ");
INSERT INTO kyf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","-Bha -Zezu bhlɩa we -gʋɛ: «A -tʋ 'yliyɔgada, -we ka gbʋ -wa, a 'nɩ we 'ylɩ -yi -bhloo, 'ɩn a 'nɩ we bhla -yi.» ");
INSERT INTO kyf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«-We -yɔ *-Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa, mʋ -wa nyɩmɛ yabhlo. Mɔ mɩa 'lakpa 'wʋ mnɩda, 'ɩn ɔ yia ɔ zɔlubhonʋnya la, ɔ 'ka wa ɔ 'ŋnɩmnɩlu yoo 'nyɛ, wa 'ka we 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","-We nyɩmɛ yabhlo mnenia ɔ 'ka 'yliyɔzʋ, 'mʋ ɔ 'nyɛa ɔ. Ɔ 'nyɛa yabhlo -can bi gbu, wa 'sɔnʋ -can bi 'sɔ, 'ɩn ɔ yia tanʋ -can bi -bhlo 'nyɛ. Tɔʋn, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«-Ɔ 'yɩa -can bi gbu, ɔ tɩtalɩa we -gʋla -valɛpapɩe nya, 'ɩn ɔ yi 'yaa -can bi gbu we -gʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Sa -bhlokpadɛ, -ɔ 'yɩa -can bi 'sɔ, 'ɩn -mɔɔ yi 'yaa -can bi 'sɔ we -gʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","-Ɔ 'yɩa -can bi -bhlo, ɔ mnɩa, ɔ yia 'bhʋka 'bhlu, 'ɩn ɔ yia -mɔ ɔ -kanyɔɔ -can zize. ");
INSERT INTO kyf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«We 'bɩ -gwlɛa 'wʋ, 'ɩn wa -kanyɔ yia yi ɔ 'ka ɔ -lu zɛlɩ wa nya. ");
INSERT INTO kyf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","-Ɔ 'yɩa -can bi gbu, ɔ bɛa ɔ kwesi, 'ɩn ɔ yi 'yaa -mɔ -can bi gbu wleli. Ɔ nɛɛ: ‹Na -kanyɔ, -ɩn ka 'mɩ -yɔ -can bi gbu tɩ, ɩn 'ka we 'yliyɔzʋ. Ɩn ka -can bi gbu 'yɩ 'ya, mʋ mɩa da.› ");
INSERT INTO kyf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Ɔ -kanyɔ nɛɛ ɔ -yla: ‹We nanɩ 'yli, -ɩn mɩ zɔlubhonʋnyɔ -zɔnʋ nya, 'ɩn -na zʋa 'mɩ 'nʋŋwɛ. -Ɩn ka -lu -sɛlɛ 'yɩ, 'ɩn -ɩn yia we 'yliyɔzʋ tɩklɩɩ, we 'dɛɛ 'gbʋ na nyɛa -mɩ -lu duun, -ɩn 'ka we 'yliyɔzʋ. -Ɩn yi, ɩn -yɔ -mɩ 'sɔ 'ka 'mʋna li.› ");
INSERT INTO kyf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«-Ɔ 'yɩa -can bi 'sɔ, ɔ bɛa ɔ -kanyɔ -yɔ, 'ɩn ɔ nɛɛ: ‹Na -kanyɔ, -ɩn ka 'mɩ -yɔ -can bi 'sɔ tɩ, ɩn 'ka we 'yliyɔzʋ. Nɩɩ, ɩn ka -can bi 'sɔ 'yɩ 'ya, nɩɩ, mʋ mɩa da.› ");
INSERT INTO kyf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Ɔ -kanyɔ nɛɛ ɔ -yla: ‹We nanɩ 'yli, -ɩn mɩ zɔlubhonʋnyɔ -zɔnʋ nya, 'ɩn -na zʋa 'mɩ 'nʋŋwɛ. -Ɩn ka -lu -sɛlɛ 'yɩ, 'ɩn -ɩn yia we 'yliyɔzʋ tɩklɩɩ, we 'dɛɛ 'gbʋ, na nyɛa -mɩ -lu duun, -ɩn 'ka we 'yliyɔzʋ. -Ɩn yi, ɩn -yɔ 'mɩ 'sɔ 'ka 'mʋna li.› ");
INSERT INTO kyf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«-Ɔ 'yɩa -can bi -bhlo, ɔ bɛa ɔ -kanyɔ -yɔ, ɔ nɛɛ: ‹Na -kanyɔ, ɩn -yi we 'ji nɩɩ, -ɩn 'tɛ, da -ɩn 'nɩa -lu gwlʋ, -mɔ -na kwaa we. 'Ɩn da -ɩn 'nɩa 'mnɔ 'pa, -mɔ -na dɩa we. ");
INSERT INTO kyf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ɩn mɩ -mɩ sɔdaa 'gbʋ, ɩn mnɩa, 'ɩn ɩn yia -na -can zize 'bhʋka 'wʋ. Nɩɩ, wee -na -can nɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Ɔ -kanyɔ nɛɛ: ‹Na zɔlubhonʋnyɔ, -na nʋkplɛ -nyu 'yli, 'ya -ɩn 'yaa, -ɩn -yi we 'ji nɩɩ, da ɩn 'nɩa -lu gwlʋ, -mɔ na kwaa we, da ɩn 'nɩa 'mnɔ 'pa, -mɔ na dɩa we. ");
INSERT INTO kyf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","We -ka yaa 'sa -mɩ, -mʋmʋ ka 'gbʋ -ɩn 'nɩ na 'gwɛzi bankɩ 'wʋkwaa? 'Ɩn da ɩn -ka yi, 'ɩn ɩn 'ka -mɔ we -sa, -zugba we ka -gʋ -bhoa?› ");
INSERT INTO kyf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Tɔʋn, ɔ nɛɛ ɔ lubhonʋnya -yla: ‹A -sa wee -can bi -bhlo ɔ kwɛɛ, 'ɩn -ɔ kaa -can bi kugbua, a 'ka we ɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","-Wa weee kaa -lu duun, wa -nʋ wa yia -gʋpalɩa, 'ɩn wa -nʋ 'ka 'wʋzumanɩ. Nɩɩ, nyɩmɛ -ɔ 'nɩa -lu duun -ka, we -sɛlɛ mɩa ɔ kwɛɛ, kwɛɛ wa yia we ɔ -saa. ");
INSERT INTO kyf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ɔɔ zɔlubhonʋnyɔ -ɔ ka nʋkplɛ -nyua 'yli, -ɔ mɩa da nɩ, a viteli ɔ 'pipee, nikpise 'wʋ, mɔ wa wilia, 'ɩn wa lia gla 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ɔɔ Nyɩmɛɛ Yu yia yia, dʋdʋʋ 'wlulapɩlɩnyɔɔ 'tɩtɛ nya, ɔ -yɔ ɔ 'anzɩ weee 'sɔ. -Bha ɔ yia ɔ 'ŋnɩmnɩkpe -gʋ ladɩa, 'ɩn ɔ 'ka nyɩma 'wlulapɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Laga weee yia ɔ 'yu 'wlugbelia, 'ɩn mɔ yia nyɩma -yɔsɩsalɩa. Sa nɩmɛɛ 'yliyɔzʋnyɔ sɩsalɩa bhlabhlɛnya -yɔ wlinya -yɔ, ");
INSERT INTO kyf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'sa ɔɔ Nyɩmɛɛ 'Yu yia bhlabhlɛnya lilikwɛsɔlʋ zʋa, 'ɩn ɔ 'ka wlinya kɔpɛsɔlʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","-Slɛɛn, ɔɔ nyɩmaa 'wlulapɩlɩnyɔ yia gbaa -wa mɩa ɔ lilisɔlʋ -yla: ‹Amɩa, -mama na Dide palɩa sɔ -zɔnʋ -gʋ la, a yi. A yi, dʋdʋ -lolu na Dide mnazɩa la aɩn -yla, we 'ka dʋdʋʋ gwedɩda 'bhʋ, a yi a 'ka we -gʋladɩ. ");
INSERT INTO kyf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nɩɩ, ŋwɔ ka 'mɩ 'bha, 'ɩn a yia 'mɩ lililu 'nyɛ. 'Ɩn 'nyumatʋ yia 'mɩ 'bha, 'ɩn a yia 'mɩ 'nyu 'nyɛ. Ɩn mɩ zlɩmɛ 'lakpayu nya, 'ɩn a yia 'mɩ kpa sɔ 'sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ɩn mɩ zlɩmɛ kpanʋ nya, 'ɩn a yia 'mɩ 'naa ku 'wʋgbalɩ. Ɩn ka zlɩmɛ gu -yɔ, 'ɩn a yia 'mɩ 'yuo 'paa yi. Ɩn mɩ zlɩmɛ -kaslʋ 'wʋ, 'ɩn a yia 'mɩ -yɔbɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«'Ɩn -wa mɩa tɩklɩɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹-Amɩaa -Kanyɔ, nɩɩ, -ɩn nɛɛ, ŋwɔ mɩ -mɩ 'bhada, 'ɩn -a yia -mɩ lililu 'nyɛ, 'nyumatʋ mɩ -mɩ 'bhada, 'ɩn -a yia -mɩ 'nyu 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Da -a 'yɩlɩ -mɩ 'lakpayu nya, 'ɩn -a yi -mɩ kpa sɔ 'sɔ nya? -Ɩn mɩ kpanʋ nya, 'ɩn -a yi -mɩ 'naa ku 'wʋgbalɩa? ");
INSERT INTO kyf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","-Ɩn ka gu -yɔ, -ɩn mɩ -kaslʋ 'wʋ, 'ɩn -a yi -mɩ -yɔbɛa? Labhla -a 'yɩ -mɩ, 'ɩn -a yi we lɛnʋa?› ");
INSERT INTO kyf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Nyɩmaa 'wlulapɩlɩnyɔ yia gbaaɛ: ‹Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa, -we a nʋa lɛ na 'bɩsʋa bhelia -yla, na 'dɛ -yla a nʋa we lɛ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Tɔʋn, ɔɔ nyɩmaa 'wlulapɩlɩnyɔ yia -wa mɩa ɔ kɔpɛsɔlʋ -yla gbaɛ: ‹Amɩa -Lagɔ tɩa mɛ -yɔ la, a bɛ lʋ! Nɩɩ, -kosu -we'e nyumoa, -we -Lagɔ mnazɩa la *'Kuzu -yɔ we 'anzɩnya -yla, a mnɩ -mɔ. ");
INSERT INTO kyf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ŋwɔ ka 'mɩ 'bha, 'ɩn a 'nɩ 'mɩ lililu 'nyɛ. 'Nyumatʋ mɩ 'mɩ 'bhada, a 'nɩ 'mɩ 'nyu 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ɩn mɩa 'lakpayu nya, a 'nɩ 'mɩ kpa sɔ 'sɔ nya. Ɩn mɩa kpanʋ nya, a 'nɩ 'mɩ 'naa ku 'wʋgbalɩ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«'Ɩn we 'bɩgʋ wa yia 'palɩa yiaɛ: ‹-Amɩaa -Kanyɔ, nɩɩ, -ɩn nɛɛ, ŋwɔ mɩ -mɩ 'bhada, 'nyumatʋ mɩ -mɩ 'bhada, -ɩn mɩ 'lakpayu nya, -ɩn mɩ kpanʋ nya, -ɩn ka gu -yɔ, -ɩn mɩ -kaslʋ 'wʋ, 'ɩn -a 'nɩ -mɩ -yɔbɛ. Labhla -a 'yɩ -mɩa? Labhla -a 'nɩ we lɛnʋa?› ");
INSERT INTO kyf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ɔɔ nyɩmaa 'wlulapɩlɩnyɔ yia we 'bɩgʋpalɩaɛ: ‹Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -we a 'nɩa lɛnʋ -wa mɩa -sɛsɛ -yla, -amɩ -yla a 'nɩa we lɛnʋ.› ");
INSERT INTO kyf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Nɩɩ, wamɩa, da wa paa wa -kaslʋ 'wʋ, 'ɩn we'e bhɩa, -mɔ wa mnɩa. 'Ɩn -wa mɩa tɩklɩɩ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ wa yia 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","-Zezu bhɩa gbʋ weee nɩ gbagbɩe, 'ɩn ɔ nɛɛ ɔ 'bɩnɔnya -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«A -yi we 'ji nɩɩ, *'Wʋzɩtɩylɩɩ 'fɛtɩ ka cɩpa, we -tʋ 'wʋ 'ylɩ 'sɔ. Nɩɩ, ɔɔ Nyɩmɛɛ 'Yu, 'mɔ wa yia wlaa, wa 'ka ɔ *su -gʋ lakʋlʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nɩɩ, -Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ gbelia 'wlu *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Kaifʋʋ -buduŋwɛɛ, ");
INSERT INTO kyf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'ɩn wa yia wɛlɩ -bhlo bhlɩ, wa 'ka -Zezu kpa 'wiemɩ, 'ɩn wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wa nɛɛ: «-A 'na kpalɩ ɔ 'fɛtɩɩ 'ylɩ nya -nɩ, we 'nɩ -mʋʋ, 'ɩn nyɩma gbugblolua.» ");
INSERT INTO kyf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Da -Zezu mɩa Betani *sɔlɩbhanyɔ 'Simɔɔɔ -buduŋwɛɛ, ");
INSERT INTO kyf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'ɩn 'ŋwnɔ yabhlo yia ɔ -yɔbɛ. Ɔ ka -bhonyida kwɛɛ, *-lasiklɔ -zɔnʋ, -we 'ka -valɛ 'tɛa, we mɩ we 'wʋ. -Zezu mɩa lida, 'ɩn ɔ yia wee -lasiklɔ ɔ 'wluo slu. ");
INSERT INTO kyf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɔ 'bɩnɔnya 'yɩa we -yɔ, 'ɩn wa yia 'cɛ 'pa, wa nɛɛ: «Lɛɛ -lu ka 'gbʋ ɔ nyumɔ 'sa sa wea? ");
INSERT INTO kyf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A mneni yaa a 'ka wee -lasiklɔ -zɔnʋ pɛlʋ 'pa, 'ɩn a 'ka we 'gwɛzi bobabhanya yoo 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","-Zezu yibhelia we 'ji nɩɩ, wa ka 'cɛ 'pa, 'ɩn ɔ nɛɛ: «Lɛɛ -lu ka 'gbʋ a sɩalɩ ɔɔ ŋwnɔ nɩa? -We ɔ nʋa 'mɩ -yla lɛ, gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nɩɩ, bobabhanya -yɔ aɩn 'sɔ mɩ 'ylɩ weee nya. Nɩɩ, -amɩ mɩa, we 'nɩ 'ylɩ weee nya ɩn mɩ aɩn glaa. ");
INSERT INTO kyf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na gbawlaa 'gbʋ ɔ yia wee -lasiklɔ na 'wluo slu. ");
INSERT INTO kyf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: da wa yia -Lagɔgbʋ gba dʋdʋ weee -gʋ, -we ŋwnɔ nɩ nʋa da lɛ, gbaa wa yia we, 'ɩn ɔ lɛnʋgbʋ 'ka nyɩmaa dlɩ 'wʋ -tʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tɔʋn, -Zezuu 'bɩnɔnya kugbua lɛ 'sɔ glaa nyɩmɛ yabhlo wa laa Zudasɩ Isɩkaliɔtʋ, mɔ mnɩa -Lagɔbʋbɔnyaa -cɩan -gbɛ, ");
INSERT INTO kyf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'ɩn ɔ nɛɛ: «'Lee, ɩn -ka -Zezu wla nɩ, lɛɛ -lu a 'ka 'mɩ 'nyɛa?» 'Ɩn -maa yia ɔ tama glʋ -bhlo 'ya kugbua 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","We 'bhʋ wee 'ylɩ 'wʋ, sa ɔ 'kaa nʋ ɔ 'ka -Zezu wla, -bha ɔ bhlia we 'yooo datalɩe. ");
INSERT INTO kyf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nɩɩ, Zuifʋʋ *'floo 'nɩa gɔɔ -yɔ -kaa 'fɛtɩɩ 'ylɩɩ tɩanʋ nya, 'ɩn ɔ 'bɩnɔnya yia ɔ layɩbha: «Mɔ -ɩn 'yɩbha -a mnɩ -mɩ -yla 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu pia?» ");
INSERT INTO kyf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","-Zezu nɛɛ: «A mnɩ -zɔɔ nyɩmɛ nɩɩ -gbɛ, a gba ɔ -yla: ‹-Amɩaa -Kanyɔ nɛɛ: «Na bhla ka nyni. -Na -gbɛ na yia 'Wʋzɩtɩylɩɩ 'fɛtɩ -saa, ɩn -yɔ na 'bɩnɔnya 'sɔ.» › » ");
INSERT INTO kyf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","-We ɔ gbaa wa -yla, 'mʋ wa nʋa lɛ, 'ɩn wa yia wee 'fɛtɩ -gʋ -lililu pi. ");
INSERT INTO kyf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jibhe zɔa, 'ɩn -Zezu -yɔ ɔ 'bɩnɔnya yia ladɩ wa 'ka li. ");
INSERT INTO kyf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Da wa mɩa lida, 'ɩn ɔ nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, aɩn glaa, nyɩmɛ yabhlo yia 'mɩ wlaa.» ");
INSERT INTO kyf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Ɩn we yia wa -yɔkpa, 'ɩn wa yia ɔ layɩbhayɩbhɩe bhli -bhlo -bhlo: «Na -Kanyɔ, we 'nɩ -amɩ, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ɔ nɛɛ: «-Ɔ -yɔ 'mɩ 'sɔ -ka 'floo 'ŋwa zapʋ lʋ, mɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gbʋzɔnʋ -wa: sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ ɔ daa, 'sa ɔɔ *Nyɩmɛɛ 'Yu yia mnɩa. Nɩɩ, nyɩmɛ -ɔ 'kaa ɔ wla, 'ɩn wa 'ka ɔ 'bha, gbʋnyuu mɩ -mɔɔ -nʋ nya. Wa 'nɩ yaa -mɔɔ gwalɩ, we nanɩ 'yli.» ");
INSERT INTO kyf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudasɩ -ɔ 'kaa -Zezu wla yia ɔ layɩbha: «Wlabi, we 'nɩ -amɩ, we 'nɩ mʋʋ?» -Zezu nɛɛ: «-Mɩ gbaa dɛ -mʋʋ!» ");
INSERT INTO kyf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wa mɩa lida, 'ɩn -Zezu yia 'floo 'wʋbhu. Ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we ladɩdlɩ. Ɔ dlilia we ɔ 'bɩnɔnya 'wʋla, 'ɩn ɔ nɛɛ: «A 'bhu we 'wʋ a 'ka we li, na ku -wa.» ");
INSERT INTO kyf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","-Mʋʋ 'bɩgʋ, 'ɩn ɔ yia nʋ -kɔpʋ 'wʋbhu, ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we wa yoo 'nyɛ, ɔ nɛɛ: «A 'dɛ weee 'ma we. ");
INSERT INTO kyf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɩɩ, mʋ -wa na 'pɩɔn -we yia jitea nyɩma duuun 'gbʋ, 'ɩn we 'ka -Lagɔ -yɔ nyɩma 'wʋsuslolu. ");
INSERT INTO kyf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɩɩ, gbʋzɔnʋ -wa, zlɩ na Dide -ka dʋdʋ 'wlulapɩlɩ, we zlɩ na maa nʋ lolu. We 'nɩ -mʋʋ, we 'ka -zɛɛn 'wʋbhʋ, ɩn 'na 'ka nʋ 'ma.» ");
INSERT INTO kyf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wa bhlɩa -Lagɔ -lʋʋ 'bhie, wa yia 'tla, 'ɩn wa yia *Olivʋsunyaa -gɔgɔ 'wlu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tɔʋn, -Zezu nɛɛ wa -yla: «Nɩɩ, -zɛɛn sabɔɔ 'dɛbhie -gbolu, a 'dɛ weee yia 'mɩ 'bɩ 'bhʋa. Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹Bhlabhlɛɛ 'yliyɔzʋnyɔ na yia 'bhaa, 'ɩn bhlabhlɛ 'ka lamnɔ.› ");
INSERT INTO kyf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nɩɩ, ɩn -ka tlɩ, ɩn -ka 'wʋsɔ lʋ, Galilee na yia aɩn wʋlʋa mnɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Ɩn Piɛlɩ nɛɛ ɔ -yla: «Nyɩma weee -ka -mɩ 'bɩ 'bhʋ, -amɩ 'na 'ka we lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Ɩn -Zezu yia we 'bɩgʋpalɩɛ: «Ɩn nɛɛ -mɩ -yla gbʋzɔnʋ saɛ: -zɛɛn sabɔ mɩa, -na kpɛlɩ na gbʋ 'wʋla -zakpa ta, -zugba -kʋkɔ 'nɩ -slɔ gbo.» ");
INSERT INTO kyf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piɛlɩ nɛɛ: «-Ɩnnya, we 'nɩ -mʋʋ, we -ka 'bha wa 'ka ɩn -yɔ -mɩ 'sɔ 'bha, ɩn 'na 'ka -na gbʋ kpɛlɩ.» 'Sa -bhlokpadɛ, wa 'dɛ weee gbaa wee wɛlɩ -bhlo. ");
INSERT INTO kyf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","-Zezu -yɔ ɔ 'bɩnɔnya 'sɔ, 'ɩn wa yia da wa laa Gɛtɩsemanee mnɩ. -Bha ɔ gbaa wa -ylaɛ: «A -dɩ da la, ɩn 'ka mɔ mnɩ, ɩn 'ka -Lagɔ bhubhoe.» ");
INSERT INTO kyf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɔ -yɔ Piɛlɩ -yɔ Zebedee 'yua 'sɔ klaa, 'ɩn wa yia mnɩ. -Bha ɔ -gʋ yia, 'ɩn 'pɩɔn yia ɔ dlɩ 'wʋ slo. ");
INSERT INTO kyf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Ɩn ɔ nɛɛ wa -ylaɛ: «Na dlɩ sulo mɩ 'mɩ 'bhada, a -tʋ 'yliyɔgada, a -yɔ 'mɩ 'sɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɔ bɛa 'yu -sɛ, 'ɩn ɔ yia 'klʋ lagbli, 'ɩn ɔ yia -Lagɔ bhubhoe, ɔ nɛɛ: «Na Dide, -ɩn -ka we 'yɩbha, -ɩn vlalɩ 'mɩ sɩasɩe 'kadʋ -mɩnɩ gwe. Nɩɩ, we 'na -zɛlɩ na dʋmagbʋ -nɩ, we -zɛ -na dʋmagbʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Ɩn ɔ yia ɔ 'bɩnɔnyaa -gbɛ lʋyi, -zugba wa mɩ 'ylaa 'wʋ. Ɔ nɛɛ Piɛlɩ -yla: «A 'nɩ mneni a 'ka 'yliyɔgada -tʋ 'lɛlɩ -bhloo -kpʋa, a -yɔ 'mɩ 'sɔɔ? ");
INSERT INTO kyf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","A -tʋ 'yliyɔgada, a bhubhoe -Lagɔ, a yi laylagbʋ lʋ bhlili. Nɩɩ, nyɩmɛɛ dlɩ 'yɩbha we 'ka -lu -zɔnʋ lɛnʋ, 'ɩn ku 'nɩ we mneni.» ");
INSERT INTO kyf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tɔʋn, ɔ 'bhʋ 'yaa wa -yɔ lʋ, 'ɩn ɔ yia -Lagɔ bhubhoe. Ɔ nɛɛ: «We -ka nɩɩ, 'yoo -putu 'nɩ -mɩ, sɩasɩa -yoo 'nɩ ɩn 'ka bhli, -na dʋmagbʋ nʋ lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɔ yia lʋ, -zugba wa mɩ 'ya 'ylaa 'wʋ, wa 'yli ka 'wʋwɔmanɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɔ 'bhʋa wa -yɔ lʋ, 'ɩn ɔ yia 'yu bɛ, 'ɩn ɔ tanʋ yia -Lagɔ bhubhoe -zugba ɔ gbaa wee wɛlɩ -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Ɩn ɔ yia ɔ 'bɩnɔnyaa -gbɛ yi lʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «A mɩ 'ylaa 'wʋ -bhlokpadɛ, nyapɛda a mɩa yɩ? Da wa 'kaa Nyɩmɛɛ 'Yu wla gbʋnyuu -lɛnʋnya -yla, we bhla ka nyni. ");
INSERT INTO kyf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","A -sɔ 'wʋ, -a 'ka mnɩ! A -talɩ, nyɩmɛ -ɔ 'kaa 'mɩ wla, mɔ yia mɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Da -Zezu mɩa gbada, wɛlɩ mɩ ɔ ŋwɛɛ, tɔʋn Zudasɩ yia yi. Ɔɔ Zudasɩ mɩa, ɔ mɩ -Zezuu 'bɩnɔnya kugbua lɛ 'sɔ glaa. 'Ɩn ɔ -yɔ nyɩmaa -zlo yia yi, tʋgʋgblɛ -yɔ su kibhe nya kwɛɛ. Nɩɩ, -Lagɔbʋbɔnyaa -cɩan -yɔ nyɩma kpasɩ tiea wa. ");
INSERT INTO kyf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","-Ɔ 'kaa ɔ wla, sa ɔ 'kaa ɔ wla, ɔ ka wa -yla we gba. Ɔ nɛɛ: «Nyɩmɛ ɩn -ka gbleli nɩ, mɔ -wa, a kpa ɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tɔʋn, ɔ bɛa -Zezu -yɔ, ɔ nɛɛ: «*Wlabi» ɔ fʋsasɩe nya, 'ɩn ɔ yia ɔ gbleli. ");
INSERT INTO kyf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","-Zezu nɛɛ ɔ -ylaɛ: «'Tale, -we -ɩn yia lɛnʋa, -ɩn nʋ we lɛ slʋɩ.» -Bha tɔlʋa bɛa -Zezu -yɔ, 'ɩn wa yia ɔ kpa. ");
INSERT INTO kyf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nɩɩ, ɔ 'bɩnɔnyaa 'yabhlo -saa tʋgʋgblɛ tʋkpa 'wʋ, 'ɩn ɔ yia we -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋnyɔ 'pa, 'ɩn we yia ɔ yukwli 'wlu -dɩ. ");
INSERT INTO kyf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tɔʋn, -Zezu nɛɛ: «Fa -na -gblɛ we 'bɩgʋ. Nɩɩ, -ɔ -ka tʋgʋgblɛ 'wʋbhu, tʋgʋgblɛ 'yli ɔ mnɩnɩa. ");
INSERT INTO kyf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","-Ɩn yibheli we 'ji nɩɩ, ɩn mneni ɩn 'ka na Dide bhubhoe, -bha -bhlokpadɛ, ɔ 'ka 'mɩ 'anzɩnyaa -zakpa kugbua lɛ 'sɔ yoo 'pa, we 'ka gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","We -ka 'sa -mɩ nɩ, sa -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ 'ka gbʋzɔnʋ -zɛa? Nɩɩ, we nɛɛ 'sa we yia 'plɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","-Zezu nɛɛ wa -yla: «'Wienyɔ ɩn -mɩa, 'ɩn a yia 'mɩ kpaa yi tʋgʋgblɛ -yɔ su kibhe nya kwɛɛ -nya yɩ? -Ɩnnya! 'Ylɩ weee nya, ɩn mɩ ladɩda -Lagɔbudu 'kadʋ zɔ gbʋ -sloluda, 'ɩn a 'nɩ 'mɩ kpa. ");
INSERT INTO kyf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nɩɩ, 'sa we 'dɛ weee 'plɩa sa, 'ɩn -Lagɔgbʋʋ -falɩpanyaa wɛlɩ -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, we 'ka gbʋzɔnʋ -zɛ.» Tɔʋn, 'ɩn ɔ 'bɩnɔnya yia -bha ɔ tɩ -gwagwɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wa kpaa ɔ, 'ɩn wa yia ɔ -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ, -ɔ wa laa Kaifʋʋ -gbɛ kwa. Da -Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya klaa, wa -yɔ nyɩma kpasɩ gbelia 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛlɩ mɩ -Zezu 'bɩ, ɔ 'nɩ ɔ -yɔ cɩpa, 'ɩn ɔ yia -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ -buduŋwɛɛ plalɩ, ɔ 'ka -bha 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","-Lagɔbʋbɔnyaa -cɩan -yɔ gbʋwʋbhunya weee tɩtalɩa yoyogbʋ la -Zezu -yɔ, wa 'ka ɔ gbʋ 'wluladɩlɩ, 'ɩn wa 'ka ɔ 'bha, wa 'nɩ gbʋ yabhlogbɔɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nyɩma -wa yia -Zezu yo -gʋ la zʋlʋa, -maa -zu 'wʋ. Nɩɩ, nyɩmɛ -ɔ 'kaa wɛlɩ gba -we -yɔ wa 'kaa -Zezu 'bha, -mɔɔ 'nɩ -mɩ. -Slɛɛn, nyɩma 'sɔ -sɔa 'wʋ wa nyɩdɩ, ");
INSERT INTO kyf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","'ɩn -maa nɛɛ: «-Ɔ mɩa da nɩ, ɔ nɛɛ nɩɩ, ɔ mneni ɔ 'ka -Lagɔbudu 'kadʋ labhlɩ, 'ɩn ɔ 'ka we 'sʋbha 'yli ta zɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -sɔa 'wʋ, 'ɩn ɔ nɛɛ -Zezu -ylaɛ: «Nyɩma nɩ ka -mɩ gbʋ 'wluladɩlɩ, -ɩn 'nɩ mneni -ɩn 'ka gbʋ -gʋ -saa?» ");
INSERT INTO kyf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","-Zezu yia ŋwɛ -muda -tʋ. 'Ɩn -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ nɛɛ ɔ -ylaɛ: «-Ɩn bi 'mɩ -yla, 'yliyɔga -Lagɔɔ 'ŋnɩ nya: 'lee, -Lagɔɔ -Bhasanyɔ, -Lagɔɔ 'Yu -ɩn -mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","-Zezu nɛɛ: «'Mʋ -ɩn gbaa dɛ! Ɩn nɛɛ 'ya aɩn -yla nɩɩ, Nyɩmɛɛ Yu yia 'tɩtɛ -ka -Lagɔɔ lilisɔlʋ ladɩa. 'Yɩa a yia ɔ, yalɩpʋpa -gʋ -zugba ɔ -yɔ we kwli.» ");
INSERT INTO kyf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tɔʋn, -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ yia ɔ 'naa yla 'cɛ nya, 'ɩn ɔ nɛɛ: «Ɔ ka -Lagɔ vɛlɩ, a 'dɛ weee ka we 'nʋ. -A 'nɩ -slɛɛn gbʋdayɩnyɔɔ gbʋ -ka. ");
INSERT INTO kyf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'Ɩn amɩa, a nɛɛ lɛa?» Wa nɛɛ: «Ɔ -yɔgbʋ -wa, wa 'bha ɔ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tɔʋn, wa yia ɔ -dlɛ klɔɔ slu, 'ɩn wa yia ɔ -kwli 'pa, -zugba tɔlʋa sʋbhaa ɔ 'kpa yukwli, ");
INSERT INTO kyf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'ɩn wa nɛɛ: «-Lagɔɔ -Bhasanyɔ, nyɔɔ 'pa -mɩ -lua? -Ɩn gba ɔ 'ŋnɩ!» ");
INSERT INTO kyf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nɩɩ, Piɛlɩ -dɩ -bha la, 'pipee -buduŋwɛɛ, 'ɩn -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋŋwnɔ yabhlo yia ɔ -yɔbɛ, 'ɩn ɔ nɛɛ ɔ -yla: «-Mɩ, -ɩn -yɔ Galileyu -Zezu 'sɔ mɩ ya.» ");
INSERT INTO kyf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Ɩn ɔ yia nyɩma weee 'yibadɩ kpɛlɩ, ɔ nɛɛ: «-We a mɩa gbada, ɩn 'nɩ we -yi!» ");
INSERT INTO kyf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɔ mnɩa 'suoo klolo -yɔ, 'ɩn zɔlubhonʋŋwnɔ yabhlo yia ɔ 'yɩ, 'ɩn -mɔɔ nɛɛ nyɩma mɩa -bha -yla: «-Ɔ mɩa dɛ nɩ, ɔ -yɔ Nazalɛtɩyu -Zezu 'sɔ mɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Ɩn Piɛlɩ yia we kpɛlɩ -tapa, ɔ nɛɛ bibie nyaɛ: «Ɩn 'nɩ nyɩmɛ nɩ -yi!» ");
INSERT INTO kyf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","-Bha bɛa -sɛ, -wa mɩa -bha, wa nɛɛ ɔ -yla: «Nɩɩ, gbʋzɔnʋ -wa, -ɩn mɩ wa glaa. -Na gbagbawɛlɩ -gʋ -a yibhelia we 'ji.» ");
INSERT INTO kyf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tɔʋn, Piɛlɩ yia bi, ɔ nɛɛ: «Ɩn 'nɩ ɔɔ -nyɩmɛ nɩ -yi! Ɩn -ka yo 'tʋbhʋ, -Lagɔ 'pa 'mɩ -kaslʋ 'wʋ!» -Bha -bhlokpadɛ -kʋkɔ gboa. ");
INSERT INTO kyf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Ɩn Piɛlɩɩ dlɩ yia -we -Zezu gbaa ɔ -yla -gʋ -bho: «Nɩɩ, -na kpɛlɩ na gbʋ 'wʋla -zakpa ta, -zugba -kʋkɔ 'nɩ -slɔ gbo.» Piɛlɩ 'tlaa, 'ɩn ɔ yia nyazɩwie wida -tʋ kpokpo. ");
INSERT INTO kyf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zlʋkpɛ -papa, -Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ weee yia wɛlɩ bhlɩ, wa 'ka -Zezu 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wa gbʋan ɔ, *Wlɔmʋ -nyɩmɛ -ɔ pɩlɩa Zudee -dʋdʋ 'wlu la, wa laa Pilatɩ, 'ɩn wa yia ɔ -mɔɔ -gbɛ kwa. 'Ɩn wa yia ɔ -mɔɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudasɩ, -ɔ wlaa -Zezu, ɔ 'yɩa nɩɩ, wa ka ɔ -yɔgbʋ 'wʋbhu wa 'ka ɔ 'bha, 'ɩn ɔ dlɩ yia ɔ zukpa -sa. 'Ɩn wee tama glʋ -bhlo 'ya kugbua mɩa, ɔ yia we -Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ yoo 'nyɛ lʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɔ nɛɛ: «Nyɩmɛ -ɔ 'nɩa gbʋnyuu yabhlogbɔɔ 'ji -yi, ɩn ka ɔ wla wa 'ka ɔ 'bha, gbʋnyuu ɩn nʋa lɛ.» Wa nɛɛ ɔ -yla: «-Mʋʋ 'nɩ -amɩaa gbʋ. -Na 'dɛɛ gbʋ mʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zudasɩ vitelia wee 'gwɛzi -mɔ -Lagɔbudu 'kadʋ zɔ, ɔ mnɩa, 'ɩn ɔ yia ɔ 'dɛ bɩzɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","-Lagɔbʋbɔnyaa -cɩan 'bhua wee 'gwɛzi la, 'ɩn wa nɛɛ: «Wee 'gwɛzi mɩa da nɩ, nyɩmɛɛ 'pɩɔɔn 'gwɛzi -wa, nɩɩ, -a 'nɩ mneni -a 'ka we -Lagɔbuduu 'kadʋʋ 'kesu 'wʋzʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wa bhlɩa wɛlɩ, 'ɩn wa yia wee 'gwɛzi labhu, 'ɩn wa yia we nya nyidabhlanyɔɔ kpaa zɔ, we 'ka 'lakpanyaa 'bhluluda -zɛ. ");
INSERT INTO kyf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","We 'dɛɛ 'gbʋ wa laa -zɛɛn ylɩ nya we «nyɩmɛɛ 'pɩɔɔn kpaa». ");
INSERT INTO kyf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nɩɩ, -we -Lagɔgbʋʋ -falɩpanyɔ Zelemi gbaa, mʋ nʋa lɛ. «Nɩɩ, tama glʋ -bhlo 'ya kugbua, mʋ -wa -valɛ -we -gʋ *Izlaɛlɩ -ylaaslɩ bhlɩa wɛlɩ, wa 'ka ɔ 'wʋzɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'Mʋ wa 'bhua 'wʋ, 'ɩn wa yia we nyidabhlanyɔɔ kpaa 'wʋzɔlʋ. Sa na -Kanyɔ tiea 'mɩ, 'sa wa nʋa we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wa 'yligbelia -Zezu Pilatɩ 'yu, 'ɩn -mɔɔ nɛɛ ɔ -yla: «'Lee, Zuifʋʋ 'wlulapɩlɩnyɔ -ɩn -mɩa yɩ?» 'Ɩn -Zezu nɛɛ ɔ -yla: «'Mʋ -ɩn gbaa dɛ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","-Mʋʋ 'bɩgʋ, -Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ dɩlɩa ɔ gbʋ 'wlu la, ɔ 'nɩ gbʋ -gʋ -sa. ");
INSERT INTO kyf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tɔʋn, Pilatɩ nɛɛ ɔ -yla: «-We weee wa gbaa dɛ -na da nɩ, -ɩ'ɩn 'nʋ wee?» ");
INSERT INTO kyf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","-Zezu 'nɩ we 'yabhlogbɔɔ 'bɩgʋpalɩ, 'ɩn we yia Pilatɩ ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nɩɩ, Zuifʋʋ *'Wʋzɩtɩylɩɩ 'fɛtɩ -ka nyni nɩ, -ɔ nyɩmaa -zlo 'yɩbhaa, 'mɔ Wlɔmʋ -dʋdʋʋ 'wlulapɩlɩnyɔ saa -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","We bhla, nyɩmɛ -ɔ nyɩma weee -yia, wa laa -Zezu -Balabasɩ, mɔ mɩa -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Da nyɩma duun gbelia 'wlu Pilatɩɩ -gbɛ, 'ɩn ɔ yia wa layɩbhaɛ: «Nyɔɔ a 'yɩbha ɩn 'tide 'yia? -Zezu -Balabasɩ yaayɩɩ, -Zezu wa laa -Lagɔɔ -Bhasanyɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nɩɩ, Pilatɩɩ 'dɛ -yi we 'ji nɩɩ, zenyidlɩ nya wa wlaa ɔɔ -Zezu. ");
INSERT INTO kyf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatɩ -dɩa la, ɔ mɩ gbʋwʋbhuda, 'ɩn ɔ 'ŋwnɔ yia ɔ wɛlɩ yoo 'pa: «-Ɩn 'na plalɩ nyɩmɛ mɩa nɩɩ gbʋ 'wʋ -nɩ. Ɔ 'nɩ gbʋnyuu lɛnʋ. Nɩɩ, -zɛɛn sabɔ mɩa, -mɔ 'ylaa 'wʋ, ɩn ka ɔ 'gbʋ -zila 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","*-Lagɔbʋbɔnyaa -cɩan -yɔ nyɩma kpasɩ sumanɩa nyɩmaa -zlo -yɔla, wa 'ka gba nɩɩ, ɔ 'tide -Balabasɩ 'yi, 'ɩn ɔ 'ka -Zezu 'bha. ");
INSERT INTO kyf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ nɛɛ wa -yla: «Nɩɩ, nyɩmɛ yabhlo na yia 'yitidea. 'Lee, wa 'dɛsɔbhie glaa, nyɔɔ ɩn 'ka 'yitidea?» Wa nɛɛ: «-Balabasɩ!» ");
INSERT INTO kyf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatɩ nɛɛ: «We -ka 'sa -mɩ, -Zezu wa laa -Lagɔɔ -Bhasanyɔ, 'lee, lɛɛ -lu ɩn 'ka ɔ nʋnʋa?» 'Ɩn wa nɛɛ: «Kʋlʋ ɔ *su -gʋ la!» ");
INSERT INTO kyf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatɩ nɛɛ: «Gbʋnyuu -mʋmʋ ɔ nʋ lɛa?» 'Ɩn wa yia 'wʋkpɩ 'tɩtɛ: «Kʋlʋ ɔ su -gʋ la!» ");
INSERT INTO kyf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Da Pilatɩ 'yɩa nɩɩ, -we ɔ mɩa lɛnʋda we bhe, 'ɩn 'gbe mɩa gbugbloluda bhabha, ɔ 'bhua 'nyu 'wʋ, ɔ budoa kwɛ nyɩma weee 'yibadɩ, 'ɩn ɔ nɛɛ: «Nyɩmɛ nɩɩ tlɩtlɩee 'gba 'nɩ 'mɩ 'wlu -mɩ. Amɩaa 'dɛɛ gbʋ -wa!» ");
INSERT INTO kyf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wa 'dɛ weee nɛɛ: «Ɔ tlɩtlɩe mɩa, -amɩaa -yɔ -amɩaa 'ylaaslɩɩ 'wlu -gbʋ -wa!» ");
INSERT INTO kyf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tɔʋn, 'ɩn Pilatɩ yia -Balabasɩ -kaslʋ 'wʋsa. 'Ɩn ɔ nɛɛ 'slʋja -yla nɩɩ, wa sɛlɩ -Zezu, 'ɩn wa 'ka ɔ su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatɩɩ 'slʋja kwaa -Zezu dʋdʋʋ 'wlulapɩlɩnyɔɔ -buduŋwɛɛ. 'Slʋja weee bibea ɔ, ");
INSERT INTO kyf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'ɩn wa yia ɔ -bana 'wʋsa, 'ɩn wa yia ɔ 'naa zalʋ 'wʋpla. ");
INSERT INTO kyf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tɔʋn, wa maa 'wia -kloo, 'ɩn wa yia we ɔ 'wluo -pla, 'ɩn wa yia gblee ɔ lilisɔ 'wʋ zʋ. Wa 'sibhlia 'kukolu ɔ 'yu, 'ɩn wa yia ɔ nyanɩ. 'Ɩn wa nɛɛ: «Zuifʋʋ 'wlulapɩlɩnyɔ, -na fʋʋ!» ");
INSERT INTO kyf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'Ɩn wa yia ɔ -dlɛ -gʋ slu. Wa 'bhua gblee 'wʋ, 'ɩn wa yia we ɔ 'wluo 'pa. ");
INSERT INTO kyf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Da wa bhɩa ɔ nyanɩe, 'ɩn wa yia ɔ 'naa zalʋ 'wʋsa, 'ɩn wa yia ɔ 'dɛɛ -bana ɔ 'wʋpla, 'ɩn wa -yɔ ɔ yia mnɩ wa 'ka ɔ su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Da wa 'tlaa 'gbe, 'ɩn wa -yɔ Silɛnɩyu 'Simɔɔ yia gbeli. 'Slʋja nɛɛ ɔ -yla -gla nya nɩɩ, ɔ 'bhu -Zezuu su 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Ɩn wa yia da yabhlo wa laa zuifʋwɛlɩ 'wʋ Gɔlʋgota nyni, we ji -wa nɩɩ, 'wluu 'kʋaa da. ");
INSERT INTO kyf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","-Bha 'slʋja 'nyɛa -Zezu nʋ -we lʋ wa palɩa kalɔ -nyakpɔ. -Zezu 'yɩa we 'ŋwɛ, ɔ 'nɩ we 'ma. ");
INSERT INTO kyf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wa yia ɔ su -gʋ lakʋlʋ, 'ɩn wa yia -nɩgbɩ 'pa, -we wa 'kaa 'yɩ -bhlo -bhlo ɔ -bananya glaaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tɔʋn, wa yia -bha ladɩ, wa 'ka ɔ 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","-We ka 'gbʋ wa yia ɔ 'bha, wa ka we cɛlɩ, 'ɩn wa yia we ɔ 'wlubita lakʋlʋ: ");
INSERT INTO kyf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wa ka 'ya 'wienya 'sɔ su -gʋ lakʋlʋ ɔ kwesi. 'Yabhlo mɩ ɔ lilisɔlʋ, 'ɩn -gʋdʋ mɩa ɔ kɔpɛsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","-Wa plɩlɩa -bha, 'wlu wa bitea, 'ɩn wa vɛlɩa -ɔ, ");
INSERT INTO kyf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wa nɛɛ: «-Mɩ, -mɩ gbaa -ɩn 'ka -Lagɔbudu 'kadʋ -wlɔ, 'ɩn -ɩn 'ka we 'sʋbha 'ylɩ ta 'wʋ nɩ, -sa -na 'dɛ gbʋ 'wʋ. Nɩɩ, -ɩn -ka -Lagɔɔ 'Yu nya -mɩ, -ɩn 'bhʋ su -gʋ -ɩn 'ka lasibhli.» ");
INSERT INTO kyf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Sa -bhlokpadɛ, -Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya klaa, we -yɔ Zuifʋʋ nyɩma kpasɩ nyanɩa ɔ, wa nɛɛ: «Ɔ ka nyɩma tɔlʋa pue, ");
INSERT INTO kyf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ɔ 'nɩ -slɛɛn mneni ɔ 'ka ɔ 'dɛ pue. *Izlaɛlɩɩ 'Wlulapɩlɩnyɔ ɔ -mɩa yɩ? We -ka 'sa -mɩ, ɔ 'bhʋ su -gʋ ɔ 'ka lasibhli, 'ɩn -a 'ka ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","'Ɩn ɔ nɛɛ: ‹Ɩn mɩ -Lagɔɔ 'Yu nya.› Nɩɩ, -de -Lagɔ yi ŋwnu, ɔ 'ka ɔ gbʋ 'wʋsa, -bha -a yia 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Sa -bhlokpadɛ, 'wienya, -wa wa kʋlʋa su -gʋ la ɔ kwesi, -maa vɛlɩa ɔ. ");
INSERT INTO kyf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Ylʋ 'ka -glɔnyɩdɩ nynia yi, nikpise kpaa dʋdʋ weee -gʋ, we li 'lɛlɩ ta. ");
INSERT INTO kyf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","We bhɩalɩda -Zezu 'kpɩa 'wʋ 'tɩtɛɛ, ɔ nɛɛ: «Eli, Eli, lama sabakatani?» -Mʋʋ ji -wa nɩɩ: na -Lagɔ, na -Lagɔ, lɛɛ -lu ka 'gbʋ -ɩn yi 'mɩ 'bɩ 'bhʋa? ");
INSERT INTO kyf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nyɩma tɔlʋa -wa mɩa -bha, -wa 'nʋa we, wa nɛɛ: «Ɔ mɩ Elii lada!» ");
INSERT INTO kyf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wa 'yabhlo 'bhua -fuu 'wʋ -gwagwɩe nya, ɔ faa we kalɔ nʋ lʋ, 'ɩn ɔ yia we gblee 'yliya 'wʋ zʋ, 'ɩn ɔ yia we ɔ ŋwɛ -yɔdɩ ɔ 'ka 'ma. ");
INSERT INTO kyf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nɩɩ, wa tɔlʋa nɛɛ: «-Ɩn wʋ -slɔ. -De Elii yi yi -mɔɔ 'ka ɔ gbʋ 'wʋsa, -a 'ka -bha 'yɩ!» ");
INSERT INTO kyf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","-Zezu yia 'wʋkpɩ lʋ 'tɩtɛɛ, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","-Bha -bhlokpadɛ, 'naa bɩzɩa -Lagɔbudu 'kadʋ zɔ bhlia 'wʋylaylɩe we nyɩdɩ -mɔ yalɩ tɩklɩɩ, 'ɩn we yia zɔ nyni. Dʋdʋ yia zuklu, 'ɩn tʋkpanya yia 'wʋyla. ");
INSERT INTO kyf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gbawla yia ŋwɛ -kalɩ, 'ɩn -Lagɔnyɩma tɔlʋa -wa tlɩa, 'ɩn wa yia tlɩtlɩnya glaa 'wʋsɔ. ");
INSERT INTO kyf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Ɩn wa yia wa gbawla 'wʋtla. Da -Zezu -sɔa tlɩtlɩnya glaa 'wʋ, wa mnɩa -Zeluzalɛmʋ, 'ɩn nyɩma duun yia wa 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","*Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ -yɔ ɔ 'slʋja, -wa mɩa -Zezu 'yliyɔzʋda, wa 'yɩa dʋdʋ zukluda we -yɔ -lu weee -we 'plɩa, 'ɩn wa yia nyanɔ nʋ, wa nɛɛ: «-Lagɔɔ 'Yu ɔ -mɩa 'piɛɩn!» ");
INSERT INTO kyf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'Ŋwnɩ -duun mɩa -bha, -wa kwaa -Zezu yoo Galilee, 'ɩn -wa pia ɔ -yla, wa 'yligbe -mɔ 'pɩ, -zugba wa yla. ");
INSERT INTO kyf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wa glaa, Magɩdala -ŋwnɔ Malii klaa, *'Zake -yɔ *-Zɛzɛfʋʋ 'nyaa Malii klaa, we -yɔ Zebedeee 'yuaa 'nyaa mɩ -bha. ");
INSERT INTO kyf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jibhe mɩa zɔda, 'ɩn Alimategbe 'wʋʋ 'ŋnɩmnɩnyɔ yabhlo wa laa *-Zɛzɛfʋ, 'ɩn -mɔɔ yia yi. Nɩɩ, -mɔɔ mɩ -Zezuu 'bɩnɔnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɔ mnɩa Pilatɩɩ -gbɛ, 'ɩn ɔ yia -mɔɔ -Zezu 'kwie -zlalɩ. Tɔʋn, Pilatɩ yia ɔ 'yoo 'nyɛ ɔ -yɔ we 'ka mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɔ 'bhua -Zezuu 'kwie 'wʋ, 'ɩn ɔ yia we 'naa lolu -yɔ zʋ. ");
INSERT INTO kyf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'Bhʋka -we wa 'bhlua tʋkpa 'wʋ ɔ 'dɛɛ -yla, we nʋkplɛ ɔ faa wee 'kwie. We 'bɩgʋ, ɔ glipea tʋkpa -boklo 'kadʋ, ɔ klaa gbawla ŋwɛ, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magɩdala -ŋwnɔ Malii -yɔ Malii -putu -dɩ -bha gbawla 'yu la. ");
INSERT INTO kyf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zlɩ -ka zlɩ, mʋ -wa *Nyapɛylɩ. -Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma yia Pilatɩɩ -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wa nɛɛ: «-Amɩaa -kanyɔ, -we ɔɔ yokanyɔ nɩ gbaa, -zugba ɔ -ga 'yliyɔ, -amɩaa dlɩ ka we -gʋ lasibhli. Ɔ nɛɛ: ‹'Ylɩ 'sɔ, we tanʋ nya, na yia tlɩtlɩnya glaa 'wʋsɔa.› ");
INSERT INTO kyf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","We 'dɛɛ 'gbʋ, -na zukpa -wa, tie -na 'slʋja, wa 'ka ɔ gbawla ŋwɛkʋ tɩklɩɩ 'ylɩ ta. Wa -ka 'sa nʋ, ɔ 'bɩnɔnya 'nɩ mneni wa 'ka ɔ 'kwie yli, 'ɩn wa 'ka gba nɩɩ, ɔ ka tlɩtlɩnya glaa 'wʋsɔ. We 'nɩ -mʋʋ, yo -mʋmʋ wa yia tʋbhʋa, we -nyu 'yli we -zi tɩanʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatɩ nɛɛ: «'Slʋja nɩ, sa a -ka we ŋwɛkʋkʋe mneni, a mnɩ a 'ka 'sa we ŋwɛkʋ.» ");
INSERT INTO kyf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tɔʋn, wa yia mnɩ wa 'ka gbawla ŋwɛkʋ. Tʋkpa -we mɩa we ŋwɛɛ, 'ɩn wa yia we -yɔ 'pa, 'ɩn wa yia -bha 'slʋja 'yligbeli, wa ka we 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nyapɛylɩ 'plɩa, dimasɩɩ zlʋkpɛ -papa, Magɩdala -ŋwnɔ Malii -yɔ Malii -putu yia gbawla -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tɔʋn, 'ɩn dʋdʋ yia zuklu sa -gligli. -We ka gbʋ -wa, Jejitapɛɛ 'anzɩ 'bhʋa yalɩ, mʋ 'sibhlia la, we glipea tʋkpa -boklo 'kadʋ, 'ɩn we yia we gbawla ŋwɛɛ -sa, 'ɩn we yia we -gʋ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sa 'nyu 'kaa 'yɩka 'pa, 'sa we 'klʋ mɩa, 'ɩn we 'wʋ -bana lɩa 'paɩn 'paɩn. ");
INSERT INTO kyf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Waa 'slʋja nʋa nyanɔ, -zugba wa tɛlɩa, 'ɩn wa yia bhli tlɩtlɩnya 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nɩɩ, 'anzɩ nɛɛ 'ŋwnɩ -yla: «A 'na nʋnʋ nyanɔ -nɩ. Ɩn -yi we 'ji nɩɩ, -Zezu -ɔ wa kʋlʋa *su -gʋ la, ɔ da a mɩa -talɩda. ");
INSERT INTO kyf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ 'nɩ -seli -mɩ. Sa ɔ gbaa, ɔ ka tlɩtlɩnya glaa 'wʋsɔ, ɔ -ga 'yliyɔ. A yi, da ɔ pɩa zlɩmɛ la, a 'ka -bha 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A mnɩ -gwagwɩe nya, a 'tʋlʋ ɔ 'bɩnɔnya nɩɩ, ɔ ka tlɩtlɩnya glaa 'wʋsɔ, ɔ ka aɩn 'yugalɩ Galilee. -Mɔ a yia ɔ 'yɩa. Nɩɩ, 'mʋ ɩn gbaa dɛ aɩn -yla.» ");
INSERT INTO kyf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wa 'bhʋa gbawla -yɔ slʋɩ, wa mɩ nyanɔ nʋda, -zugba 'mʋna 'kadʋ mɩ wa dlɩ 'wʋ. 'Ɩn wa yia mnɩ -gwagwɩe nya, wa 'ka -Zezuu 'bɩnɔnya 'dɩ -salɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tɔʋn, 'ɩn -Zezu yia wa yoo yi, ɔ nɛɛ wa -yla: «Ka 'yuo 'pa!» Wa bɛa ɔ -yɔ, 'ɩn wa yia ɔ bhʋ lakpa, 'ɩn wa yia ɔ 'ylimanɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Ɩn ɔ nɛɛ wa -ylaɛ: «A 'na nʋnʋ nyanɔ -nɩ, a mnɩ, a gba na bhelia -yla wa mnɩ Galilee, -mɔ wa yia 'mɩ 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Da waa 'ŋwnɩ mɩa -slɔ 'yloogblʋ, 'slʋja -wa -kʋa gbawla ŋwɛ, 'ɩn wa tɔlʋa yia 'gbe nʋkplɛ lʋmnɩ. -We weee 'plɩa, 'mʋ wa gbaa -Lagɔbʋbɔnyaa -cɩan -yla. ");
INSERT INTO kyf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","-Maa -yɔ nyɩma kpasɩ gbelia 'wlu, 'ɩn wa yia wɛlɩ -bhlo bhlɩ. Wa 'nyɛa 'slʋja 'gwɛzii -zlo, ");
INSERT INTO kyf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'ɩn wa nɛɛ: «-We a 'kaa gba nɩ, mʋ nɩ da: ‹Nɩɩ, sabɔ, da -a mɩa 'ylaa 'wʋ, 'ɩn ɔ 'bɩnɔnya yia yi, 'ɩn wa yia ɔ 'kwie yli.› ");
INSERT INTO kyf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɩɩ, ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ -ka we 'nʋ, -we -a 'kaa gba, -a -yi we. Gbʋ 'na 'ka aɩn ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Slʋja -yɔ wa 'gwɛzi mnɩa, -we wa gbaa wa -yla, mʋ wa nʋa lɛ. Wee 'dɩ wa zʋa 'slʋja, 'ɩn we yia lamneni Zuifʋʋ -gbɛ. -Zɛɛn ylɩ nya, wa mɩ -slɔ we gbada. ");
INSERT INTO kyf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɔ 'bɩnɔnya kugbua lɛ -bhlo mnɩa Galilee, -gɔgɔ -we -Zezu -slolua wa 'klʋ, 'mʋ wa -gblaa. ");
INSERT INTO kyf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wa 'yɩa -Zezu -yɔ, 'ɩn wa yia ɔ 'ŋnɩ -mnɩnɩ. Nɩɩ, wa tɔlʋa lʋa dlɩ. ");
INSERT INTO kyf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","-Zezu bɛa wa -yɔ, 'ɩn ɔ nɛɛ: «-Lagɔ ka 'mɩ 'tɩtɛ weee 'nyɛ yalɩ -yɔ dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","A mnɩ laga -dʋdʋ weee -gʋ, a -zɛlɩ -mɔ -nyɩma na 'bɩnɔnya. A batizee wa 'nyu nya, Dide klaa, 'Yu klaa, we -yɔ Zuzu 'Pʋpa, wa 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tite weee ɩn 'nyɛa aɩn, a -slolu wa we 'nʋŋwɛzʋzʋe. A yibheli we 'ji nɩɩ, ɩn -yɔ aɩn 'sɔ mɩ 'ylɩ weee nya, 'ɩn dʋdʋ 'kaa labhʋ.»");
INSERT INTO kyf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","-Lagɔgbʋ -we gbaa -Lagɔɔ 'Yu -Zezu *Klisɩɩ gbʋ, we gwedɩda nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","*-Lagɔgbʋʋ -falɩpanyɔ *Ezaii cɛlɩa ɔ 'sɛbhɛ 'wʋɛ: «Nɩɩ, -Lagɔ nɛɛ: ‹-Mɩ 'yu na paa na *tietienyɔ yoo ɔ 'ka -na 'yoo -yɔmnazɩ.› ");
INSERT INTO kyf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nyɩmɛ yabhlo 'kpɩa 'wʋ -mɔ da bɛblɛɛ, ɔ nɛɛ: ‹Nɩɩ, a mnazɩ Nyɩmaa -Kanyɔɔ 'yloogblʋ -yɔ. A nʋ 'yoo tɩklɩɩ ɔ 'yu.› » ");
INSERT INTO kyf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Sa wa 'yɩa *Zaan -yɔ -mɔ da bɛblɛɛ, -zugba ɔ batizee nyɩma 'nyu nya, ɔ kpɩ 'wʋ nɩɩ, «A 'bhiti dlɩ, a yi ɩn 'ka aɩn batizee, 'ɩn -Lagɔ 'ka amɩaa gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zudee -dʋdʋ -gʋ -nyɩma weee -yɔ *-Zeluzalɛmʋ -nyɩma weee yia Zaaan -gbɛ. Gbʋnyuu, -we wa nʋa lɛ, 'mʋ wa gbaa -zejila 'wʋ, 'ɩn ɔ batizea wa, Zudɛɛn nyu lʋ. ");
INSERT INTO kyf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nɩɩ, ɔɔ Zaan mɩa, ɔ 'wʋ -bana mɩ *-nyɔmɛɛ nyanɩ nya, 'ɩn ɔ -cɛsli mɩa nɩmɛɛ ku nya. Lʋʋ 'kpɩ -yɔ -gangan ɔ lia. ");
INSERT INTO kyf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɔ 'kpɩa 'wʋ, ɔ nɛɛ: «Nyɩmɛ -ɔ yia 'mɩ 'bɩ yia, ɔ 'tɩtɛ -zi na -nʋ. Ɩn 'nɩ we 'klʋ -ka ɩn 'ka 'wʋkwli, 'ɩn ɩn 'ka ɔ -sakwlaa 'llukpe -blo. ");
INSERT INTO kyf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Nyu nya -amɩ na batizea aɩn. Mɔ yia aɩn batizea -Lagɔɔ Zuzu 'Pʋpa nya.» ");
INSERT INTO kyf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","-Bha -bhlokpadɛ -Zezu 'bhʋa Nazalɛtɩ Galilee -dʋdʋ -gʋ, 'ɩn Zaan yia ɔ batizee Zudɛɛn nyu lʋ. ");
INSERT INTO kyf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","-Zezu 'tlaa 'nyu lʋ, tɔʋn, ɔ yia -Lagɔɔ 'gbe -yɔyɩ ŋwɛ -kalɩda. 'Ɩn -Lagɔɔ Zuzu -ɔ 'wlʋa -kpakʋn, -mɔɔ yia -Zezu -gʋ lasibhli. 'Ɩn wa yia wɛlɩ yabhlo 'bhʋa -Lagɔɔ -gbɛ 'nʋ, we nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","«Na 'Yu -ɩn -mɩa, ɩn -kalɩ -na zɛ. -Mɩ ɩn 'nyɛa na dlɩ weee yoo.» ");
INSERT INTO kyf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tɔʋn, -Lagɔɔ Zuzu yia -Zezu da bɛblɛɛ 'sulu. ");
INSERT INTO kyf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɔ li -mɔ 'ylɩ glʋ 'sɔ, 'ɩn *-Saatan yia ɔ layla, -zugba -Zezu mɩ -mɔ -fliinɩma glaa, 'ɩn 'anzɩnya yia ɔ 'wʋsa. ");
INSERT INTO kyf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wa ka Zaan -kaslʋ 'wʋpa 'bhie, -Zezu yia Galilee -dʋdʋ -gʋ mnɩ. Ɔ nynia -mɔ, 'ɩn ɔ yia -Lagɔgbʋ gbagbɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ɔ nɛɛ: «'Ylɩ -we -Lagɔ -saa -bha, we ka nyni. *-Lagɔɔ nyɩmaa 'wlulapɩlɩ bhla ka cɩpa. A 'bhiti amɩaa dlɩ. A zʋ -Lagɔgbʋ dlɩ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","-Zezu mɩ Galilenyu kwesi 'plɩda, 'ɩn ɔ yia 'Simɔɔ -yɔ ɔ bheli Andlee 'yɩ. Wa mɩ -bha wa 'sowli 'nyu lʋ vitelida. Nɩɩ, zibhibhanya wa -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","-Zezu nɛɛ wa -ylaɛ: «A yi 'mɩ 'bɩ, sa a kpaa zibhi, ɩn 'ka 'sa aɩn nyɩmaa 'ylibɩlanɔnʋnya -zɛlɩ, 'ɩn a 'ka wa 'mɩ 'bɩla.» ");
INSERT INTO kyf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tɔʋn, wa tɩa -bha wa 'sowli, 'ɩn wa yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔ bɛa 'yu -sɛ, 'ɩn ɔ yia Zebedee -yɔ ɔ 'yua *'Zake -yɔ *Zaan -yɔyɩ, -zugba wa mɩ wa 'sowli mnazɩda, -mɔ 'glʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ɔ laa wa, 'ɩn wa yia -bha wa dide -yɔ ɔ lubhonʋnya tɩ, -mɔ 'glʋ 'wʋ, 'ɩn wa yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","-Zezu -yɔ ɔ *'bɩnɔnya mnɩa Kapɛnaumʋ *Nyapɛylɩ nya, 'ɩn ɔ yia wa gbʋ -slolu *-Lagɔbudu zɔ. ");
INSERT INTO kyf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɔ gbagba wɛlɩ ka wa ŋwɛgaga -sʋbhalɩ. Nɩɩ, ɔ 'nɩ wa gbʋ -slolu -Lagɔɔ titee gwesanya 'bhisa, se -we -Lagɔ 'nyɛa ɔ, we nya ɔ -slolua wa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tɔʋn, nyɩmɛ yabhlo, zuzu 'nyuu kpaa, 'mɔ wa 'yɩa -yɔ -mɔ -budu zɔ, 'ɩn ɔ yia 'wʋkpɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ɔ nɛɛ: «-Mɩ, Nazalɛtɩyu -Zezu, -naa lɛɛ -gbʋ pɩlɩ na gbʋ 'wʋla? -Amɩaa lasasɩee 'gbʋ -ɩn yia yi yɩ? Ɩn -yi -mɩ ŋwɛɛ ŋwɛɛ: -Lagɔɔ -Mɔwlʋnyɔ ɔ tiea, 'mɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","-Zezu yia we, we ŋwɛɛ labhalɩ -gla nya: «'Mu ŋwɛ! 'Bhʋ ɔ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tɔʋn, 'ɩn we yia ɔ lazuklu 'tɩtɛɛ, 'ɩn we yia ɔ 'wʋtla 'wʋkpɩkpɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ŋwɛgaga yia wa 'dɛ weee sʋbha, 'ɩn wa yia la 'yɩbhalɩ yɩbhalɩɛ: «Aya! Lɛɛ gbʋ nɩ daa? Wɛlɩ -lolu ɔ slolua nyɩma 'tɩtɛ nya. Nɩɩ, ɔ pɩlɩ zuzu 'nyii 'wlu la, 'ɩn we zʋa ɔ 'nʋŋwɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","-Bha -bhlokpadɛ ɔ 'ŋnɩ mnenia Galilee -dʋdʋ -gʋ la. ");
INSERT INTO kyf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wa 'tlaa tɔʋn, ɔmɔ klaa, 'Zake klaa, we -yɔ Zaan, wa yia Andlee -yɔ 'Simɔɔɔ -buduŋwɛɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wa 'kaa -mɔ nyni, -zugba 'Simɔɔɔ 'ŋwnɔɔ 'nyaa mɩ lapɩda. Ɔ ku -su. Wa yia we -Zezu -yla gba slʋɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɔ bɛa ɔ kwesi, 'ɩn ɔ yia ɔ sɔ -yɔ ɔ 'wʋbhulu, 'ɩn ɔ kusulo yia ɔ -gʋ 'bhʋ. 'Bhie, ɔ yia wa -yla pipie bhli. ");
INSERT INTO kyf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jibheza, da 'ylʋ bhlia, 'ɩn wa yia guzʋnya -yɔ nyɩma -wa zuzu 'nyuu mɩa 'wʋ -Zezuu -gbɛ -la. ");
INSERT INTO kyf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","'Ɩn, -zɔɔ -nyɩma weee yia -bha wee -buduŋwɛɛ 'wlugbeli. ");
INSERT INTO kyf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ɔ yia nyɩma, -wa kaa guu 'yli -bhlo -bhlo -yɔ jipe, 'ɩn ɔ yia zuzu 'nyii duun vu. Nɩɩ, -ɔ ɔ -mɩa, zuzu 'nyii -yi we, we 'dɛɛ 'gbʋ ɔ 'nɩ ŋwnu we 'ka gba. ");
INSERT INTO kyf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zlɩgʋ -papa, 'ɩn -Zezu yia 'wʋsɔ, 'ɩn ɔ yia -flii mnɩ. -Mɔ ɔ bhubhoea -Lagɔ. ");
INSERT INTO kyf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","'Bhie, 'Simɔɔ -yɔ ɔ -lima yia ɔ 'ylibɩlanɔnʋa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wa 'yɩa ɔ, wa nɛɛ ɔ -yla: «Nɩɩ, nyɩma weee mɩ -mɩ -yɔ layɩbhada.» ");
INSERT INTO kyf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɔ nɛɛ wa -yla: «-A mnɩ 'ya da -putu, kwesi -gbenya 'wʋ, ɩn 'ka -mɛmɛ -Lagɔgbʋ gba. Nɩɩ, we 'gbʋ ɩn yia yi.» ");
INSERT INTO kyf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɔ yia Galilee -dʋdʋ weee -gʋ 'plɩlɩ, -zugba ɔ gba -Lagɔgbʋ -Lagɔbudunya zɔ, 'ɩn ɔ vu zuzu 'nyii. ");
INSERT INTO kyf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","-Bha *sɔlɩbhanyɔ -bhlo bɛa ɔ 'yu, 'ɩn -mɔɔ yia 'kukolu 'sibhli. -Mɔɔ nɛɛ: «-Na zukpa -wa. We -ka -mɩ dʋdʋ nanɩ, -ɩn mneni -ɩn 'ka 'mɩ jipe.» ");
INSERT INTO kyf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","-Zezu 'yɩlɩa ɔ nyazɩ, 'ɩn ɔ yia ɔ kwɛzɩ, 'ɩn ɔ nɛɛ: «We nanɩ 'mɩ dʋdʋ we 'ka -mɩ -yɔ 'bhʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tɔʋn, 'ɩn we yia ɔ -yɔ 'bhʋ, 'ɩn ɔ yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","-Bha ɔ gbaa ɔ -yla 'klʋ 'cɩcɩ nyaɛ: ");
INSERT INTO kyf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«-Ɩn -ka mnɩ nɩ, -ɩn 'na -salɩ we 'dɩ nyɩmɛ yabhlogbɔɔ -nɩ. Mnɩ -na 'dɛ *-Lagɔbʋbɔnyɔ 'klʋslolua. 'Ɩn, -we *Moizɩ gbaa nyɩmɛ -ɔ -ka 'pʋ -ɔ 'nyɛ -Lagɔ, -ɩn wla we, wa 'ka we 'jiyibheli nɩɩ, *sɔlɩ ka -mɩ ku 'wʋ 'bhʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɔɔ nyɩmɛ mnɩa, 'ɩn ɔ yia we gba nyɩma weee -yla. We 'dɛɛ 'gbʋ -Zezu 'nɩ 'maslɛɛn mneni ɔ 'ka 'gbe nʋkplɛ pla. -Mɔ ɔ -dɩlɩa -flii la, -zugba wa bhʋ da weee, wa yi ɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","'Ylɩ 'sɔlɛ 'plɩa, 'ɩn -Zezu yia Kapɛnaumʋ lʋ yi. Wa ka 'nʋ nɩɩ, ɔ mɩ -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nyɩma duun yia -mɔ gbeli. Wa -zu 'wʋ -bhaa 'gbʋ, tɔlʋa 'nɩ mneni wa 'ka 'yligbeda 'yɩ -bha -buduŋwɛɛ. 'Ɩn, -zugba ɔ gbaa wa -yla -Lagɔwɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'Ɩn nyɩma -yɔ zɔlaslonyɔ yia yi. Ɔ mɩ nyɩma -mnʋa kwɛɛ 'sowli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nyɩma -zu 'wʋʋ 'gbʋ, wa 'nɩ mneni wa 'ka ɔ -Zezu 'klʋslolu. We 'dɛɛ 'gbʋ wa -gblaa -budu 'wlu, wa 'fitea -bha, 'ɩn wa yia -bha ɔɔ zɔlaslonyɔ -lalɩ, -zugba ɔ mɩ 'sowli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","-Zezu 'yɩa nɩɩ, wa ka ɔ dlɩ -gʋ zʋ, ɔ nɛɛ ɔɔ zɔlaslonyɔ -yla: «Na 'yu, ɩn ka -na gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","-Lagɔɔ titee gwesanya tɔlʋa -dɩa -bha la, -maa nɛɛ -maa 'dɛɛ dlɩ zɔɛ: ");
INSERT INTO kyf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Lɛɛ -lu ka 'gbʋ nyɩmɛ -mɔnɩ gba 'sa sa? -Lagɔ ɔ vɛlɩa. -Lagɔ -bhlogbɔɔ mnenia ɔ 'ka nyɩmɛɛ gbʋnyii 'wʋtɩ. We 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Ɩn gbʋ -we mɩa wa 'wlukʋʋn, -Zezu yibhelia we, 'ɩn ɔ nɛɛ wa -ylaɛ: «Lɛɛ -lu ka 'gbʋ a pʋpalɩ sa dlɩ laa? ");
INSERT INTO kyf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɩn 'ka gba: ‹Ɩn ka -na gbʋnyii 'wʋtɩ›, -mʋʋ -kalɩa -yɔ yaayɩɩ, ɩn 'ka gba: ‹-Sɔ 'wʋ, 'bhu -na 'sowli 'wʋ, mnɩ -buduŋwɛɛ› -mʋʋ -kalɩa -yɔ yɩ? ");
INSERT INTO kyf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A yibheli we 'ji nɩɩ, ɔɔ *Nyɩmɛɛ 'Yu ka se dʋdʋ -gʋ, ɔ 'ka nyɩmaa gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","-Bha ɔ gbaa ɔɔ zɔlaslonyɔ -yla: «-Sɔ 'wʋ, -ɩn 'bhu -na 'sowli 'wʋ, mnɩ -buduŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tɔʋn, nyɩma weee mɩ ɔ ylada, 'ɩn ɔ yia 'wʋsɔ. Ɔ 'bhua ɔ 'sowli 'wʋ, 'ɩn ɔ yia mnɩ. We sʋbhalɩa nyɩma ŋwɛgaga, 'ɩn wa yia -Lagɔɔ 'ŋnɩ -mnɩnɩ, wa nɛɛ: «-A -ka bhaa 'wlʋ, -a 'nɩ -slɔ 'sasʋkpa -gbʋ -mɩnɩɩ da 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","-Zezu mnɩa lʋ, -mɔ 'nyu kwesi, 'ɩn nyɩmaa -zlo yia ɔ 'bɩ yi, -zugba ɔ slolua wa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ɔ mɩ 'plɩda, 'ɩn ɔ yia Alɩfeee 'yu Levii -yɔyɩ, -mɔɔ -dɩ 'gwɛzisabudu zɔ la. 'Ɩn ɔ nɛɛ ɔ -ylaɛ: «Yi 'mɩ 'bɩ.» *Levii -sɔa 'wʋ, 'ɩn ɔ yia ɔ 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","-Zezu -yɔ ɔ 'bɩnɔnya mɩ lida *Leviii -budu zɔ, -zugba *nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan tɔlʋa mɩ 'ya wa glaa. Nɩɩ, -maa -zu 'wʋ, 'ɩn wa mɩa ɔ 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","-Lagɔɔ titee gwesanya 'yɩa -Zezu -yɔ nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan nya lida, 'ɩn wa nɛɛ ɔ 'bɩnɔnya -yla: «Lɛɛ -lu ka 'gbʋ ɔ -yɔ nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan lia?» ");
INSERT INTO kyf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ɔ 'nʋa we, ɔ nɛɛ wa -yla: «Nyɩma -wa -yalɩa, wa'a mnɩ -dɔtlɔɔ -gʋ. Nɩɩ, guzʋnya mnɩa -dɔtlɔɔ -gʋ. Nɩɩ, ɩn 'nɩ nyɩma tɩklɩɩ laa yi, gbʋkpʋa -nyɩma ɩn yia laa.» ");
INSERT INTO kyf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zaaan 'bɩnɔnya -yɔ *Falizɩnyɩma mɩ 'sun 'wʋ, 'ɩn wa yia -Zezu layɩbhaa mnɩ. Wa nɛɛ ɔ -yla: «Lɛɛ -lu ka 'gbʋ Zaaan 'bɩnɔnya -yɔ Falizɩnyɩma mɩ 'sun 'wʋ, 'ɩn -nanʋʋ 'bɩnɔnya 'nɩ 'sun 'wʋ -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","-Zezu yia we 'bɩgʋpalɩɛ: «'Ŋwnɔɔ kwa zlɩ, ɔ 'lowlii -lima mneni wa 'ka lililu tɩ ɔ 'lowlii 'yibadɩɩ? -Ɩnnya, we 'nɩ 'sa -mɩ. Ɔ 'lowli -ka -bha -mɩ, wa 'nɩ mneni wa 'ka 'sun pla. ");
INSERT INTO kyf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nɩɩ, 'ylɩ yabhlo yia nynia, 'ɩn wa saa wa 'ŋwnɔɔ 'lowli glaa. -Mʋʋ zlɩ wa plaa 'sun. ");
INSERT INTO kyf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Nɩɩ, -bana sʋa -ka yla nɩ, nyɩmɛ -ka we pɩpɛda -mɩ, ɔ'ɔ zʋ we ylada 'naa lolu. Ɔ -ka 'sa we nʋ, 'ɩn 'naa lolu gbizea -bana sʋa 'wʋ, 'ɩn we ylada ylimanɩa 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Nɩɩ, wa'a palɩ nʋ lolu *bala sʋa 'wʋ. Wa -ka 'sa nʋ, 'ɩn nʋ lolu wlaa wee bala, 'ɩn we 'dɛ 'sɔ nyumoa. Nɩɩ, nʋ -lolu kaa bala lolu.» ");
INSERT INTO kyf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Zuifʋʋ Nyapɛylɩ yabhlo nya, -Zezu mɩ blekpaa 'plɩda, 'ɩn ɔ 'bɩnɔnya yia bleya -kwakwɩe bhli 'yooŋwɛ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","-Bha Falizɩnyɩma gbaa ɔ -yla: «-We -amɩaa tite gbaa wa 'na nʋnʋ Nyapɛylɩ nya lɛ -nɩ, lɛɛ -lu ka 'gbʋ -na 'bɩnɔnya nʋ we lɛa?» ");
INSERT INTO kyf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɔ nɛɛ: «Da *-Davidɩ 'nɩa -lu -ka, 'ɩn ŋwɔ mɩa ɔ -yɔ ɔ nɔnɔnya 'bhada, -we ɔ nʋa lɛ, a 'nɩ -slɔ we zɛlɩɩ? ");
INSERT INTO kyf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","*-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Abiataa bhla, 'sa -Davidɩ plaa -Lagɔɔ bʋbɔbudu zɔ, 'ɩn 'floo wa 'nyɛa -Lagɔ, wee 'floo mɩa nɩ, -Lagɔbʋbɔnya 'dɛkpʋa 'ka yaa we li, 'ɩn -Davidɩ yia we li, 'ɩn ɔ yia ɔ nɔnɔnyaa -nʋ wla. ");
INSERT INTO kyf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","«-Lagɔ zʋa nyɩma Nyapɛylɩ, wa zʋzɔnʋʋ 'gbʋ ɔ yia we lala, we 'nɩ Nyapɛylɩɩ 'dɛkpʋaa 'nʋŋwɛzʋzʋee gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","We 'dɛɛ 'gbʋ, Nyɩmɛɛ Yu mɩa, mɔ -wa Nyapɛylɩɩ -Kanyɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","-Zezu yia -Lagɔbudu zɔ pla lʋ, -zugba nʋkpasu -ɔ ka sɔ 'kua ɔ mɩ -mɔ. ");
INSERT INTO kyf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","-Wa mɩa -bha, -zugba wa wʋ 'saa -Zezu tenyii, -de ɔ yi nyɩmɛ jipe Nyapɛylɩ nya, 'ɩn wa 'ka sa ɔ'ɔ zʋa titee 'nʋŋwɛ, wa 'ka we gbʋ ɔ 'wlu dɩ. ");
INSERT INTO kyf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ɔ nɛɛ -ɔ ka sɔ 'kua -ylaɛ: «-Sɔ 'wʋ nyɩma weee -zejila 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tɔʋn, ɔ yia wa layɩbha: «Sa tite gbaa? We nɛɛ wa nʋ gbʋ -zɔnʋ lɛ Nyapɛylɩ nya yaayɩɩ, wa nʋ gbʋ 'nyuu lɛɛ? Wa pue nyɩmɛ yaayɩɩ, wa 'bha nyɩmɛɛ?» 'Ɩn -bha yia 'wʋtʋ bhlenyii. ");
INSERT INTO kyf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Waa nyɩmaa nʋkplɛɛ 'ylinyunoo 'gbʋ -Zezuu dlɩ yia 'wʋsɔ, -zugba ɔ ylaa wa 'cɛ dlɩ nya. 'Ɩn ɔ nɛɛ -ɔ ka sɔ 'kua -yla: «-Glo -na sɔ 'wʋ.» Ɔ -gloa ɔ sɔ 'wʋ, 'ɩn we yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Falizɩnyɩma 'tlaa, wa -yɔ *Ewlodʋʋ nyɩma yia ylɩ pla, wa yia gbʋ zʋ. Nɩɩ, wa 'ka 'klɩ 'yɩ, wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","-Zezu yia 'nyuu ŋwɛ -yɔ mnɩ, ɔ -yɔ ɔ 'bɩnɔnya 'sɔ. Nyɩmaa -zlo yia ɔ 'bɩ, Galilee klaa, Zudee klaa, we -yɔ Idumee dʋdʋ -gʋ wa 'bhʋa. ");
INSERT INTO kyf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tɔlʋa 'bhʋa -Zeluzalɛmʋ, tɔlʋa 'bhʋa Idumee -dʋdʋ -gʋ, dʋdʋ -we mɩa Zudɛɛn nyu lʋʋ, tɔlʋa 'bhʋa we -gʋ, tɔlʋa 'bhʋ 'yaa Tilɩ -yɔ Sidɔɔn kwesi gbe 'wʋ. Nɩɩ, wa 'nʋa ɔ lɛnʋgbʋ, 'ɩn wa yia ɔ -gbɛ yi. ");
INSERT INTO kyf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ɔ nɛɛ ɔ 'bɩnɔnya -yla: «A mnazɩ 'glʋ yabhlo la 'mɩ -yla. Nɩɩ, nyɩmaa -zlo yi 'mɩ nɩnɛnɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nɩɩ, ɔ ka nyɩma duun jipe, we 'dɛɛ 'gbʋ -wa kaa gu -yɔ, 'ɩn wa suslua wa 'ka ɔ kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'Ɩn zuzu 'nyii -ka ɔ 'yɩ, 'ɩn we kwlia 'wʋ ɔ 'yu, 'ɩn we kpɩa 'wʋ: «Nɩɩ, -Lagɔɔ 'Yu -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Ɩn ɔ gbaa we -yla 'klʋ 'cɩcɩ nya nɩɩ, -ɔ ɔ -mɩa, we 'na gbalɩ we -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","-Mʋʋ 'bɩgʋ, 'ɩn -Zezu yia -gɔgɔ 'wlu mnɩ, 'ɩn nyɩma ɔ 'yɩbhaa, ɔ yia wa la. 'Ɩn -maa yia ɔ -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","'Ɩn ɔ yia -bha nyɩma kugbua lɛ 'sɔ -sa, 'ɩn ɔ yia -maa tie, -maa 'ka -Lagɔgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'Ɩn ɔ yia wa 'tɩtɛ 'nyɛ wa 'ka zuzu 'nyii vu. ");
INSERT INTO kyf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Waa nyɩma kugbua lɛ 'sɔ, ɔ -saa -bha, wa ŋnɩ nɩ: 'Simɔɔ, -mɔɔ -baŋnɩ ɔ zʋa Piɛlɩ, klaa, ");
INSERT INTO kyf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeee 'yu 'Zake -yɔ -mɔɔ 'bɩsʋa -bheli wa laa Zaan klaa, -maa -baŋnɩ ɔ zʋa Boanɛzɛsɩ, -mʋʋ ji -wa nyɩma -wa 'wlʋa -dɛ, we -yɔ ");
INSERT INTO kyf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andlee klaa, Filipʋ klaa, Batlemii klaa, Matie klaa, Toma klaa, Alɩfeee 'yu 'Zake klaa, Tadee klaa, 'gbee *lʋpanyɔ 'Simɔɔ klaa, ");
INSERT INTO kyf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","we -yɔ Zudasɩ Isɩkaliɔtʋ, nyɩmɛ -ɔ wlaa -Zezu, 'ɩn wa yia ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Ɩn wa yia -buduŋwɛɛ mnɩ lʋ. Nyɩma duun yi 'yaa wa -gbɛ yi, we 'dɛɛ 'gbʋ wa 'nɩ mneni wa 'ka li. ");
INSERT INTO kyf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɔ nyɩma 'nʋa da we, wa nɛɛ nɩɩ, -Zezu 'wlukʋʋn ka -nyumɔ. 'Ɩn wa yia ɔ 'bɩ yi. ");
INSERT INTO kyf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","-Lagɔɔ titee gwesanya, -wa 'bhʋa -Zeluzalɛmʋ, wa nɛɛ: «*Bɛlɩzebulɩ ka -Zezu kpa, wee zuzu 'nyiii -kanyɔɔ 'tɩtɛ nya ɔ vua zuzu 'nyii.» ");
INSERT INTO kyf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","-Zezu yia wa la, ɔ nɛɛ wa -yla gbʋʋ nine -papɩe nya: «Sa -Saatan 'ka we 'dɛ vua? ");
INSERT INTO kyf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Dʋdʋ -we ka -gʋ -nyɩma -ka tʋgʋda -mɩ wa 'dɛkpʋa nyɩdɩ, la wee dʋdʋ bhʋa. ");
INSERT INTO kyf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Ɩn -budu -bhlo ŋwɛɛ -nyɩma -ka -yɔwʋsʋsɔlʋda -mɩ, we 'na 'ka -gwlɛ. ");
INSERT INTO kyf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'Ɩn -Saatan -ka we 'dɛ -yɔwʋsɔlʋ, -zugba we ka we 'dɛ 'wʋdɩ, we 'na 'ka -gwlɛ, we -nʋ ka -mɔ bhɩa. ");
INSERT INTO kyf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Nɩɩ, wa 'nɩ -slɔ nyɩmɛ 'tɩtɛ gbʋan, wa 'nɩ mneni wa 'ka ɔ -budu zɔ pla, wa 'ka ɔ 'gba labhu. Wa -ka ɔ gbʋan 'bhie wa plaa ɔ -budu zɔ, 'ɩn wa bhua ɔ 'gba la. ");
INSERT INTO kyf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: gbʋnyuu weee klaa, vɛlɩlɩnya klaa, -Lagɔ yia we 'wʋtɩa. ");
INSERT INTO kyf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nɩɩ, nyɩmɛ -ka Zuzu 'Pʋpa vɛlɩ, -Lagɔ 'na 'ka ɔ -yɔgbʋ 'wʋtɩ. Gbʋnyuu -we 'nɩa bhloluda -ka, 'mʋ ɔ nʋa lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","-We ka 'gbʋ ɔ yi 'saa gbʋ nɩ gba, mʋ -wa nɩɩ: wa nɛɛ 'ya, zuzu 'nyuu ka -Zezu kpa. ");
INSERT INTO kyf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","-Zezuu 'nyaa -yɔ ɔ 'bɩsʋayua yia ɔ 'bɩ. Wa yia -buduŋwɛɛ 'yligbe, 'ɩn wa yia nyɩmɛ tie, -mɔɔ 'ka ɔ la. ");
INSERT INTO kyf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nɩɩ, nyɩma duun ka ɔ gbeli, wa -dɩ -bha la. 'Ɩn -maa nɛɛ ɔ -ylaɛ: «-Talɩ, nɩɩ, -na 'nyaa -yɔ -na bhelia 'yligbe 'pipee, wa mɩ -mɩ lada.» ");
INSERT INTO kyf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ɔ nɛɛ wa -yla: «Nyɔɔ -wa na 'nyaa -yɔ na bheliaa?» ");
INSERT INTO kyf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɔ ylaa -wa -dɩa ɔ -yɔ la, ɔ nɛɛ: «-Wa mɩa da nɩ, ma -wa na 'nyaa -yɔ na bhelia. ");
INSERT INTO kyf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nɩɩ, nyɩmɛ -ɔ nʋa -Lagɔɔ dʋmagbʋ lɛ, mɔ -wa na 'nyaa, mɔ -wa na bheli, mɔ -wa na bhɔlɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","-Zezu bhlia nyɩma slolue 'ya lʋ -mɔ 'nyu kwesi, 'ɩn nyɩmaa -zlo yia ɔ -gbɛ mnɩ. We 'dɛɛ 'gbʋ ɔ yia 'glʋ 'wʋgbla, 'ɩn ɔ yia -mɔ ladɩ 'nyu -gʋ, -zugba nyɩmaa -zlo mɩ 'nyuu -gɔgɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gbʋʋ nine -papɩe nya ɔ -slolua wa gbʋ duun. Ɔ mɩa wa -sloluda, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«A pʋ yukwli. Nɩɩ, kpaapanyɔ yabhlo mnɩa 'mnɔ 'paa. ");
INSERT INTO kyf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɔ mɩa 'mnɔ 'mnida, 'ɩn we 'yaa -zakpa -bhlo yia 'yoo ŋwɛ -yɔ bhli, 'ɩn 'zianya yia we li. ");
INSERT INTO kyf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tɔlʋa bhlilia tʋkpa -dʋdʋ -gʋ, da bla 'nɩa -zu. Bla 'nɩ -bha -zuu 'gbʋ, we yia mi sa slʋɩ. ");
INSERT INTO kyf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","'Ylʋ 'pʋa, we yia we -sie, 'ɩn we yia yɛ, we somi 'nɩ -tlʋlʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","-Zakpa -bhlo sloa -kpɔga glaa, 'ɩn -kpɔga yia we -gʋ palɩlɩ, 'ɩn we yia we 'tuntnu. We 'nɩ 'ya yabhlogbɔɔ 'pa. ");
INSERT INTO kyf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tɔlʋa yia dʋdʋ -zɔnʋ -gʋ bhlili, 'ɩn -mʋʋ yia mi, 'ɩn we yia 'ylimanɩ, 'ɩn we yia zʋ. We lakpa tɔlʋa wla 'ya glʋ -bhlo 'ya kugbua, tɔlʋa wla 'ya glʋ ta, 'ɩn tɔlʋa wla 'ya glʋ gbu. ");
INSERT INTO kyf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Da nyɩma duun mnɔa -Zezu -yɔla, -wa -tʋa -bha, 'ɩn wa yia ɔ gbeli we -yɔ ɔ 'bɩnɔnya kugbua lɛ 'sɔ, -maa yia wee gbʋʋ ninee 'ji layɩbha. ");
INSERT INTO kyf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɔ nɛɛ wa -yla: «-Lagɔ ka aɩn ɔ nyɩmaa 'wlulapɩlɩgbʋ -we mɩa zizeda 'klʋslolu. Nɩɩ, wa tɔlʋa -wa'a nʋa -Lagɔɔ dʋmagbʋ lɛ, gbʋ weee -maa nʋa gbʋʋ nine sɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","We 'dɛɛ 'gbʋ: ‹'Ɩn wa -ka ylada -mɩ, wa'a 'yɩ la. Wa -ka yukwli pʋda -mɩ, wa'a 'nʋ we 'wʋla. We 'nɩ yaa 'sa -mɩ nɩ, 'ɩn wa 'bhitia wa dlɩ, 'ɩn -Lagɔ tɩa wa -yɔgbʋ 'wʋ.› » ");
INSERT INTO kyf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Ɩn ɔ yia wa layɩbhaɛ: «A 'nɩ gbʋʋ nine -mɩnɩ 'wʋlanʋ 'lee, sa a 'ka we tɔlʋa 'wʋlanʋa?» -Zezu nɛɛ 'yaɛ: ");
INSERT INTO kyf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","«'Mnɔya -we kpaapanyɔ 'paa, we 'wlʋ -Lagɔwɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nyɩma tɔlʋa 'wlʋ 'yoo ŋwɛ -yɔ, da -Lagɔwɛlɩ bhlia. Wa -ka we 'nʋ tɔʋn, 'ɩn -Saatan yia, 'ɩn we saa -mɔ -Lagɔwɛlɩ wa faa wa dlɩ zɔ. ");
INSERT INTO kyf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'Sa -bhlokpadɛ tɔlʋa mɩa tʋkpa -dʋdʋ 'bhisa, da -Lagɔwɛlɩ bhlia. -Maa -ka we 'nʋ, 'ɩn -maa ŋwnua we gbʋ 'mʋna nya. 'Ɩn wee 'mʋna, we'e -gwlɛ. ");
INSERT INTO kyf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nɩɩ, wee wɛlɩ'ɩ fa somi -mɔ wa dlɩ zɔ. Waa nyɩma mɩa, bhla -sɛlɛ nya wa ŋwnua we -yɔ. 'Ɩn wa -ka wa sɩalɩda -mɩ, wa -ka wa 'klɩyɩe 'wʋpalɩda -mɩ -Lagɔwɛlɩɩ 'gbʋ, 'ɩn wa saa -Lagɔwɛlɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","'Ɩn tɔlʋa mɩ -kpɔga 'bhisa, -we glaa -Lagɔwɛlɩ 'mnia. Wa -ka we 'nʋ, ");
INSERT INTO kyf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dʋdʋ -gʋʋ dlɩlʋe klaa, wa 'gwɛzi wa -dawli 'wʋnʋnʋe klaa, we -yɔ wa dlɩwʋnynilu, mʋnya palɩlɩa -Lagɔwɛlɩ -gʋ, 'ɩn we'e tnʋa. ");
INSERT INTO kyf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'Ɩn tɔlʋa 'wlʋ dʋdʋ -zɔnʋ, da -Lagɔwɛlɩ bhlia. Ma 'nʋa -Lagɔwɛlɩ, 'ɩn wa yia we -yɔŋwnu, 'ɩn wee wɛlɩ -we mia wa 'wʋ, 'ɩn we yia tnʋ. We lakpa yabhlo wla glʋ -bhlo 'ya kugbua, 'yabhlo glʋ ta, 'ɩn lakpa yabhlo wla glʋ gbu.» ");
INSERT INTO kyf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","-Zezu nɛɛ wa -yla: «Nɩɩ, wa -yɔ 'napɛ -ka yi nɩ, 'lii zɔ wa faa we yɩ? -Solu zɔ wa faa we yɩ? -Ɩnnya: yalɩ wa dɩa we la, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nɩɩ, -lu -we mɩa zizeda, zlɩ 'klʋ we yia 'tlaa. 'Ɩn -lu -we mɩa nikpise 'wʋ, -yɔ wa yia we 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","'Ɩn ɔ yi 'yaa we 'bɩgʋpalɩɛ: «-We a 'nʋa da nɩ, a zʋlʋ we dlɩ zɔ la. -We a bhua 'wʋ, 'ɩn a yɩbhɔlʋa nyɩma, 'mʋ -Lagɔ yia 'wʋbhua ɔ 'ka aɩn yɩbhɔlʋ. Nɩɩ, -lukanyɔ mɩa, ɔ -nʋ wa yia -gʋpalɩa, 'ɩn we 'ka 'wʋzumanɩ. 'Ɩn nyɩmɛ -ɔ 'nɩa -lu duun -ka, we -sɛlɛ mɩa ɔ kwɛɛ, kwɛɛ wa yia we ɔ -saa.» ");
INSERT INTO kyf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","-Zezu nɛɛ wa -yla: «-We -yɔ -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋwlʋa, mʋ nɩ: nyɩmɛ yabhlo 'paa 'mnɔ ɔ kpaa. ");
INSERT INTO kyf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɔ yi ylaa 'wʋ -mɩ sabɔoo, ɔ yi 'yliyɔga zlɩoo, mi we mi, 'ɩn we ylimanɩa. 'Ɩn sa we mimnia 'wʋla, -zugba we ylimanɩ, we nacɩ 'nɩ ɔ dlɩ zɔ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","«Nɩɩ, dʋdʋ zʋlʋa 'mnɔ. Tɩatɩa, we kpɩ tlaa. We kpɩ -ka 'tla 'bhie, we lakpa tlaa. We lakpa -ka 'tla 'bhie, we zalɩa. ");
INSERT INTO kyf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","We -ka zalɩ, 'ɩn wa dɩa we -bhleka nya. -We ka gbʋ -wa, we -dɩdɩ bhla ka nyni.» ");
INSERT INTO kyf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","-Zezu nɛɛ 'yaɛ: «Ɩn 'ka aɩn -yla gbʋʋ nine yabhlo 'pa 'ya. Lɛɛ -lu -a 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋpalɩa? Gbʋʋ nine -mʋmʋ nya -a 'ka wee gbʋ gbaa? ");
INSERT INTO kyf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","We 'wlʋ su wa laa *mutadɩ, we 'ya. Wa -ka we 'pada -mɩ, we 'kienyi, we -zi dʋdʋ -gʋʋ su weee 'ya. ");
INSERT INTO kyf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wa -ka we glʋ nɩ, 'ɩn we mia. We -ka 'ylimanɩ 'kadʋʋ, 'ɩn we zia su weee 'wʋ, we paa 'klɩya 'kadɩ, 'ɩn 'zianya dɩa we zuzu 'wʋ la.» ");
INSERT INTO kyf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wee gbʋʋ nine nɩɩ 'wʋwlʋnʋ nya -Zezu gbaa wa -yla -Lagɔgbʋ. Sa wa 'kaa we 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","We 'nɩ gbʋʋ nine -papɩe 'wʋbhʋ, ɔ'ɔ gba gbʋ bhe. Nɩɩ, ɔ 'dɛ -bhlo -yɔ ɔ 'bɩnɔnya -ka ladɩda -mɩ, 'ɩn ɔ gbaa we 'ji weee wa -yla. ");
INSERT INTO kyf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wee 'ylɩ -bhlokpadɛɛ jibheza, -Zezu nɛɛ ɔ 'bɩnɔnya -yla: «-A 'plɩlɩ 'nyuu kakpe -putu -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wa 'bhʋa nyɩma duun glaa, 'ɩn -Zezu -yɔ ɔ 'bɩnɔnya yia 'glʋ 'wʋbho. Da ɔ -dɩa la, 'glʋ tɔlʋa mɩ ɔ kwesi. ");
INSERT INTO kyf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tɔʋn, -pɩpɛ 'kadʋ yia 'plɩplɩe bhli, 'ɩn 'nyuu -gbʋgbʋ yia 'glʋ 'wʋslo, -zugba we yeli we. ");
INSERT INTO kyf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","-Zezu -mɔɔ pɩ 'glʋʋ lʋgbɛɩn la. Ɔ 'wlu mɩ -sumu -gʋ. Ɔ mɩ 'ylaa 'wʋ. 'Ɩn ɔ 'bɩnɔnya yia ɔ ganɔ, wa nɛɛ ɔ -yla: «-Amɩaa -Kanyɔ, -amɩa tlɩa! We'e -la -mɩ -sɩan 'wʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ɔ -sɔa 'wʋ tɔʋn, 'ɩn ɔ yia -pɩpɛ 'wluo 'kpɩlɩ, 'ɩn ɔ nɛɛ 'nyu -yla: «'Yligbe! Bɛ zɔ!» Tɔʋn, -pɩpɛ yia zɔbɛ, 'ɩn 'nyu -gʋ yia 'wʋtʋ blenyii. ");
INSERT INTO kyf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ɔ nɛɛ wa -yla: «-Mʋmʋ ka 'gbʋ a nʋ 'sa nyanɔa? A 'nɩ -slɔ 'mɩ dlɩ -gʋ zʋ -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tɔʋn, nyanɔ 'kadʋ yia wa dlɩ 'wʋ slo. 'Ɩn wa yia layɩbhalɩ -yɩbhalɩɛ: «Mɔɔ -nyɩmɛ ɔɔ -mɔnɩ -mɩ, 'ɩn 'nyu -yɔ -pɩpɛ zʋ ɔ 'nʋŋwɛa?» ");
INSERT INTO kyf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Ɩn -Zezu -yɔ ɔ 'bɩnɔnya yia Galilenyuu kakpe -putu -gʋ nyni, Zelazɩ -nyɩmaa dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ɔ 'bhʋa 'glʋ 'wʋ, 'ɩn ɔ yia lasibhli. Nʋkpasu yabhlo 'tlaa gbawla nyɩdɩ, 'ɩn ɔ yia ɔ -yɔyɩ. Nɩɩ, ɔɔ nyɩmɛ mɩa, zuzu 'nyuu mɩ ɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gbawla -gʋ ɔ gʋa. Nɩɩ, wa 'nɩ -slɛɛn mneni wa 'ka ɔ gbʋan, wa 'dɛ yi nɛtɛ -llukpe 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wa ka bha ɔ sɔ -yɔ -pɛklɛɛ zʋ, wa yia ɔ bhʋ gbʋan nɛtɛ -llukpe nya, ɔ yia nɛtɛ -llukpe -dɩ, 'ɩn ɔ yia -pɛklɛɛ -nyumɔ. Nyɩmɛ 'nɩ -slɛɛn ɔ kwɛyɔmneni. ");
INSERT INTO kyf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sabɔoo, zlɩoo, 'ylɩ weee nya, ɔ mɩ -mɔ -gɔgɔnya 'wlu, -mɔ gbawla -gʋ 'wʋkpɩda, -zugba ɔ nʋ ɔ 'dɛ lɛ tʋkpa nya. ");
INSERT INTO kyf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɔ 'yɩa -Zezu -yɔ -mɔ 'pɩ, ɔ mnɩa ɔ -gbɛ -gwagwɩe nya, 'ɩn ɔ yia ɔ 'yu 'kukolu 'sibhli. ");
INSERT INTO kyf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","-Zezu nɛɛ ɔ -yla: «Zuzu 'nyuu, 'tide ɔ 'yi!» 'Ɩn ɔ yia 'wʋkpɩ 'tɩtɛɛ: «-Zezu, Yalɩ -Lagɔɔ 'Yu, -naa lɛɛ -gbʋ pɩlɩ na gbʋ 'wʋla? -Na zukpa -wa, 'na palɩ 'mɩ 'klɩyɩe 'wʋ -nɩ, -Lagɔɔ 'ŋnɩ nya.» ");
INSERT INTO kyf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'Ɩn -Zezu yia ɔ layɩbha: «'Lee, sa wa la -na 'ŋnɩa?» 'Ɩn we yia we 'bɩgʋpalɩɛ: «Na 'ŋnɩ wa laa ‹'Slʋjaa -zlo.› Nɩɩ, -a -zu 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","We yia ɔ zukpa 'palɩ bhabha nɩɩ, ɔ 'na vulu we dʋdʋ nɩ -gʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","-Zugba -boboo -zlo mɩ -bha lililuu datalɩda, -gɔgɔɔ 'klʋ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'Ɩn zuzu 'nyii yia -Zezu zukpa 'palɩ, we nɛɛ ɔ -yla: «Nɩɩ, kwa -aɩn -bobonya mɩa nɩ 'wʋ. 'Nyɛ -aɩn 'yoo -a 'ka we 'wʋpla.» ");
INSERT INTO kyf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɔ yia we 'yoo 'nyɛ. Tɔʋn, wee zuzu 'nyii 'tlaa ɔɔ nʋkpasu 'wʋ, 'ɩn we yia -bobonya 'wʋpla. We kwlia -gɔgɔ -gwagwɩe nya, 'ɩn we yia 'nyu lʋ slo, 'ɩn 'nyu yia we 'bha. Nɩɩ, wee -bobo ŋwɛɛ mneni we 'ka -bobo 'wlu kugbua nyni. ");
INSERT INTO kyf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tɔʋn, -boboo 'yliyɔzʋnya yia -gwa. Gbʋ -we ylɩa wa, 'ɩn wa yia we gba kʋdanya -yɔ 'gbe 'kadɩ nʋkplɛ. 'Ɩn we 'dɩ yia da weee nyni. Nyɩma yia -bha 'yɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wa nynia -Zezu kwesi, nyɩmɛ -ɔ kaa zuzu 'nyii duun 'wʋ wa 'yɩa -mɔɔ -yɔ, -zugba -mɔɔ -dɩ -bha la, -bana nya 'wʋ, 'ɩn -mɔɔ 'wlukʋʋn ka ladolu, 'ɩn wa yia nyanɔ nʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'Ɩn gbʋ ylɩa zuzu 'nyii 'wʋkanyɔ -yɔ -bobonya, nyɩma -wa 'yɩa -bha, 'ɩn wa yia we 'dɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wa yia -Zezu bhubhoe nɩɩ, ɔ 'bhʋ wa dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Da -Zezu mɩa 'glʋ 'wʋgblada, nyɩmɛ zuzu 'nyuu kpaa, ɔ yia ɔ zukpa 'palɩ nɩɩ, ɔ -yɔ ɔ 'sɔ 'ka -tʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","-Zezu 'nɩ we ŋwnu, 'ɩn ɔ nɛɛ ɔ -yla: «Mnɩ -na -buduŋwɛɛ, -na nyɩmaa -gbɛ, 'ɩn -we weee Nyɩmaa -Kanyɔ nʋa -mɩ -yla lɛ nyazɩdlɩ nya, -ɩn 'ka we 'dɩ wa -salɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Ɩn ɔ yia mnɩ. -We weee -Zezu nʋa ɔ -yla lɛ, ɔ yia we 'dɩ -sa 'Gbe Kugbua -dʋdʋ -gʋ, 'ɩn we yia wa 'dɛ weee ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","-Zezu mnɩa 'nyuu kakpe yabhlo -gʋ 'glʋ nya, 'ɩn nyɩma duun yia 'wlugbeli ɔ kwesi 'nyuu -gɔgɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","-Bha *-Lagɔbuduu -kanyɔ yabhlo yia, 'mɔ wa laa -Zalusɩ. Ɔ 'yɩa -Zezu, 'ɩn ɔ yia -mɔɔ bhʋ -yɔ bhlili, ");
INSERT INTO kyf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'ɩn ɔ yia ɔ bhubhoe bhabha: «Nɩɩ, -na zukpa -wa. Na 'ŋwnɔyulɛ mɩ tlɩda. Yi, -ɩn 'ka ɔ sɔ -gʋlapalɩ, ɔ 'ka 'pʋ, ɔ 'ka 'yliyɔgagɩe 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'Ɩn -Zezu -yɔ ɔ 'sɔ yia mnɩ. Nyɩmaa -zlo kwaa ɔ yoo, nɩnɛnɩ wa nɩnɛnɩa ɔ. ");
INSERT INTO kyf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nɩɩ, 'ŋwnɔ yabhlo mɩ wa glaa, -mɔɔ kwɛpalɩe li -zʋ kugbua lɛ 'sɔ -mɔɔ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","-Dɔtlɔɔ -zlo jipea ɔ, wa yia ɔ sɩalɩ. Ɔ ka ɔ 'gwɛzi weee -nyumɔ, ɔ 'nɩ 'pʋ. -Zugba we -yɔ ɔ sɩalɩe mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ɔ 'nʋa -Zezuu 'dɩ nɩ, 'ɩn ɔ nɛɛ ɔ 'dɛ dlɩ zɔɛ: «Ɩn -ka ɔ -bana kwɛzɩ, ɩn mneni ɩn 'ka 'pʋ.» Ɔ 'plɩlɩa nyɩma nyɩdɩ -Zezu lʋʋ, 'ɩn ɔ yia ɔ -bana kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","-Bha -bhlokpadɛ ɔ 'pɩɔn yia 'wʋkanɩ, 'ɩn ɔ yia we 'jiyibheli nɩɩ, ɔ ka 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","-Zezu yibhelia we 'ji nɩɩ, ɔ 'tɩtɛ ka lubho nʋ, 'ɩn ɔ yia labhiti -mɔ nyɩma nyɩdɩ, 'ɩn ɔ yia layɩbhaɛ: «Nyɔɔ zɩ na -bana kwɛa?» ");
INSERT INTO kyf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Ɩn ɔ 'bɩnɔnya yia we 'bɩgʋpalɩɛ: «Aya! Nyɩmaa -zlo mɩa da -mɩ nɩnɛnɩda nɩ, 'lee sa -na yɩbha la nɩɩ, nyɔɔ zɩ -mɩ kwɛa?» ");
INSERT INTO kyf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɔ yia ɔ 'dɛ -yɔ latɩtalɩ. Nyɩmɛ -ɔ nʋa we lɛ, ɔ 'ka ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɔɔ 'ŋwnɔ ka nyanɔ nʋ, -zugba ɔ tɛlɩa. -We ylɩa ɔ, -mɔɔ ka we 'jiyibhelii 'gbʋ, 'ɩn ɔ yia -mɔɔ bhʋ -yɔ bhlili, 'ɩn ɔ yia we 'bɩgʋ 'plɩlɩ -mɔɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","-Zezu nɛɛ ɔ -ylaɛ: «Na 'yu, amaa dlɩ ka aɩn pue. A mnɩ, 'wʋtʋtʋe -dlɔɔ -yɔ aɩn 'sɔ -mɩ! Amaa gu bhɩaoo!» ");
INSERT INTO kyf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Da -Zezu mɩa gbʋ -mɩnɩ gbada, nyɩma 'bhʋa -Zalusɩɩ -buduŋwɛɛ, wa yia, wa nɛɛ ɔ -ylaɛ: «-Ɩn 'na sɩalɩ Nyɩmaa -Kanyɔ -nɩ, -na 'ŋwnɔyu ka tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Ɩn wɛlɩ, wa mɩa gbada, -Zezu yia we yukwli -gʋlasalɩ, 'ɩn ɔ nɛɛ -Zalusɩ -ylaɛ: «-Ɩn 'na nʋnʋ nyanɔ -nɩ, -ɩn zʋ dlɩ!» ");
INSERT INTO kyf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","We 'nɩ Piɛlɩ -yɔ *'Zake -yɔ ɔ bheli *Zaan 'wʋbhʋ, ɔ 'nɩ ŋwnu nyɩmɛ -putu 'ka wa yoo kwa. ");
INSERT INTO kyf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wa nynia -Lagɔbuduu -kanyɔɔ -buduŋwɛɛ, 'ɩn ɔ yia nyɩmaa -zlo -yɔyɩ -gʋzizlida sɔ weee lʋ, wie -yɔ 'wʋkpɩkpɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɔ plaa -budu zɔ, 'ɩn ɔ nɛɛ wa -yla: «Lɛɛ -lu ka 'gbʋ a gbugblolu -nya? Lɛɛ -lu ka 'gbʋ a wi -nya? Ɔ 'nɩ tlɩ, 'ylaa 'wʋ ɔ mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Ɩn wa yia ɔ gla palɩ. -Bha ɔ wlelia wa 'dɛ weee. -Slɛɛn, ɔmɔ klaa, 'ŋwnɔyuu dide klaa, ɔ 'nyaa klaa, we -yɔ ɔ 'bɩnɔnya ta, 'ɩn wa yia komi lʋʋ mnɩ, mɔ 'ŋwnɔyu pɩa la. ");
INSERT INTO kyf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Ɩn ɔ yia ɔ sɔ lakpa, 'ɩn ɔ nɛɛ ɔ -yla: «Talita kumi.» (We ji -wa nɩɩ: «'Yieslɔŋwnɔyu, ɩn nɛɛ aɩn -ylaɛ, a -sɔ 'wʋ.») ");
INSERT INTO kyf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tɔʋn, ɔɔ 'ŋwnɔyu yia 'wʋsɔ, 'ɩn ɔ yia nɔ. We yia wa ŋwɛgaga -sʋbhalɩ. Nɩɩ, ɔ ka -zʋ kugbua lɛ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","-Zezu nɛɛ wa -yla 'klʋ 'cɩcɩ nya: «A 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ. A 'nyɛ ɔ lililu, ɔ 'ka li.» ");
INSERT INTO kyf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","-Zezu 'bhʋa -bhɛdɛ, 'ɩn ɔ -yɔ ɔ 'bɩnɔnya 'sɔ yia ɔ -zɔɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Wa *Nyapɛylɩ nya, 'ɩn -Zezu yia wa -Lagɔbudu zɔ mnɩ, 'ɩn ɔ yia -mɔ gbʋ -slolu. Nyɩma, -wa ɔ mɩa -sloluda, we -sʋbhalɩa wa ŋwɛgaga, 'ɩn wa nɛɛ: «Ɔɔ mɩa dɛ nɩ, ɔ 'nɩ Maliii yuu? 'Lee, ɔ 'nɩ 'Zake klaa, Zozee klaa, Zudɩ klaa, we -yɔ 'Simɔɔɔ bhelii? Ɔ bhɔlɔa 'nɩ da -aɩn glaa -mɩɩ? Ɔɔ mɩa dɛ nɩ, -budukʋnyɔ -wa. Wee gbʋ mɩa dɛ nɩ, da ɔ salɩ wea? Gbʋyilo -mʋmʋ -Lagɔ 'nyɛ ɔmɔ, ɔ 'ka -aɩn -slolua? Nyɔɔ 'nyɛ ɔ 'tɩtɛ, 'ɩn ɔ nʋ gwɛdigbʋ nɩ lɛa?» We 'dɛɛ 'gbʋ, wa 'nɩ ɔ wɛlɩ 'wʋŋwnu. ");
INSERT INTO kyf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","'Ɩn ɔ nɛɛ wa -ylaɛ: «-Lagɔgbʋʋ -falɩpanyɔ -ka -mɩ, da weee -bha wa zʋa ɔ. Nɩɩ, wa'a zʋ -bha ɔ ɔ -zɔɔ, ɔ zʋayli we -yɔ ɔ -buduŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","We 'nɩ, ɔ ka nyɩma -bhlo -bhlo jipe, wa sɔ -gʋ lapalɩe nya 'wʋbhʋ, ɔ 'nɩ mneni ɔ 'ka gwɛdigbʋ lɛnʋ, ");
INSERT INTO kyf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","'ɩn ɔ nɛɛ: «Aya! Ɩn 'nɩ -slɔ 'sasʋkpa -nyɩma, -wa'a zʋa -Lagɔ dlɩ -gʋ, 'yɩ.» -Mʋʋ 'bɩgʋ, 'ɩn -Zezu yia kwesi -gbenya 'wʋplɩlɩ nyɩma gbʋslolue nya. ");
INSERT INTO kyf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɔ laa ɔ 'bɩnɔnya kugbua lɛ 'sɔ, ɔ 'ka wa tie 'sɔ 'sɔ, 'ɩn ɔ yia wa 'tɩtɛ 'nyɛ, wa 'ka zuzu 'nyii vu. ");
INSERT INTO kyf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ɔ nɛɛ wa -yla: «We 'nɩ kɔɔsu -bhlogbɔɔ 'wʋbhʋ, a 'na 'bhulu -lu yabhlogbɔɔ 'wʋ -nɩ. A 'na 'bhulu 'floo 'wʋ -nɩ. A 'na 'bhulu *-bada 'wʋ -nɩ. A 'na 'bhulu 'gwɛzi 'wʋ -nɩ. Nɩɩ, a -pla -sakwla bhʋ 'wʋ, a -yɔ -banaa 'sɔnʋ 'na mnɩnɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","«A -ka 'gbe -mʋmʋ 'wʋ nyni, -budu -we ka ŋwɛɛ a -ka ladɩ, a -gʋ -bha. 'Ylɩ -we nya a 'nɩ -slɔ 'wʋsɔ, a 'na 'bhʋlʋ -bha -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Ɩn da -mʋmʋ wa 'nɩ amɩaa 'lakpasu kpa, wa 'nɩ aɩn yukwli pʋlʋ, a gbɔtɔ amɩaa bhʋ -yɔ *-bhubhui, 'ɩn nyɩma 'ka we 'jiyibheli nɩɩ, wa 'nɩ -Lagɔgbʋ -yɔŋwnu.» ");
INSERT INTO kyf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wa mnɩa, 'ɩn wa nɛɛ nyɩma -yla nɩɩ, wa 'bhiti wa dlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","-Zugba wa vua zuzu 'nyiii -zlo, 'ɩn wa slua guzʋnya duun 'kpɩ 'wluo, 'ɩn -maa pʋa. ");
INSERT INTO kyf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","-Zezuu 'ŋnɩ mnenia da weee la, 'ɩn dʋdʋʋ 'wlulapɩlɩnyɔ *Ewlodʋ yia we 'nʋ. Ɔ nɛɛ: «'Zan -Batisɩ -wa. Nɩɩ, mɔ -sɔa 'wʋ tlɩtlɩnya glaa. We 'dɛɛ 'gbʋ ɔ mneni ɔ 'ka gwɛdigbʋ lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nyɩma tɔlʋa nɛɛ: «*Elii -wa.» 'Ɩn tɔlʋa nɛɛ: «-Lagɔgbʋʋ -falɩpanyɔ -wa, bhlasabhla -Lagɔgbʋʋ -falɩpanyaa 'yabhlo 'bhisa.» ");
INSERT INTO kyf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nɩɩ, Ewlodʋ 'nʋa we, 'ɩn ɔ nɛɛ: «Zaan -wa. -Amɩ wlaa ɔ, 'ɩn wa yi bhaa ɔ 'wlu -gʋ -dɩ. Mɔ -sɔa tlɩtlɩnya glaa 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Nɩɩ, Ewlodʋ mɩa, ɔ ka bha ɔ bheli Filipʋʋ 'ŋwnɔ Ewlodiadɩ -mɔɔ -glosa, 'ɩn ɔ yia -mɔɔ kwa. 'Ɩn Zaan nɛɛ ɔ -yla: «Nɩɩ, we 'nɩ 'ylinanɩ -Lagɔɔ tite 'wʋ, nyɩmɛ 'ka ɔ 'dɛɛ bhelii 'ŋwnɔ kwa.» -Bha Ewlodiadɩ 'paa 'cɛ. Ɔ 'yɩbha ɔ 'ka Zaan 'bha. Nɩɩ, Ewlodʋ sɔa Zaan, 'ɩn ɔ -yi we 'ji nɩɩ, -Lagɔnyɩmɛ tɩklɩɩ -wa. 'Ɩn Zaan -ka gbada -mɩ, we nanɩ Ewlodʋ dʋdʋ, 'ɩn we bhitia ɔ 'wlukʋʋn. We 'dɛɛ 'gbʋ Ewlodʋ 'yɩbha ɔ 'ka Zaan 'wʋgʋ. 'Ɩn ɔ yia ɔ gbʋan, ɔ yia ɔ -kaslʋ 'wʋpa Ewlodiadɩ yi ɔ 'bhaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nɩɩ, 'ylɩ yabhlo nya, 'ɩn Ewlodiadɩ yia -jɔlʋ 'yɩ. We zlɩ mɩa, Ewlodʋʋ gwalɩylɩ -wa. 'Ɩn ɔ yia 'gbee -cɩan klaa, 'slʋjaa nyɩma 'kadɩ klaa, we -yɔ Galilee -nyɩma kpasɩ la, wa 'ka 'fɛtɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ewlodiadɩɩ 'ŋwnɔyu plaa, 'ɩn ɔ yia lɩtɛ, 'ɩn ɔ yia wa dʋdʋ namanɩ. -Bha ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ Ewlodʋ gbaa ɔ -yla: «Nɩɩ, -we a -ka 'yɩbha, a -zlalɩ 'mɩ we, 'ɩn ɩn 'ka we aɩn 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","'Ɩn ɔ yia ɔ -yla biɛ: «Nɩɩ, -lu weee a yia 'mɩ -zlalɩa, yoo na nyɛa we aɩn. We yi na dʋdʋ kibhe -zɛoo, 'nyɛa na yia we aɩn.» ");
INSERT INTO kyf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɔɔ 'ŋwnɔyu 'tlaa, 'ɩn ɔ yia ɔ 'nyaa layɩbha: «Lɛɛ -lu ɩn 'ka ɔ -zlalɩa?» 'Ɩn -mɔɔ nɛɛ: «A -zlalɩ ɔ 'Zan -Batisɩɩ 'wlu.» ");
INSERT INTO kyf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɔɔ 'ŋwnɔyu mnɩa lʋ -gwagwɩe nya, 'ɩn ɔ nɛɛ Ewlodʋ -yla: «-We ɩn 'yɩbhaa nɩ, mʋ -wa 'Zan -Batisɩɩ 'wlu. -Ɩn -la dɛslɛɛn 'mɩ we -plaa -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","We wlaa ɔ 'kʋayli la, ɔ ka bi ɔ -limaa 'yibadɩɩ 'gbʋ, ɔ 'nɩ mneni ɔ 'ka gba nɩɩ, ɔ 'nɩa we ŋwnu. ");
INSERT INTO kyf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɔ yia 'slʋjayu yabhlo la, ɔ nɛɛ ɔ -yla: «Mnɩ, -ɩn -dɩ -bha 'Zan -Batisɩɩ 'wlu, -ɩn -yɔ we yi.» ");
INSERT INTO kyf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɔ mnɩa -kaslʋ 'wʋ, ɔ yia Zaaan 'wlu -bha -dɩ, 'ɩn ɔ yia we -plaa -gʋ ladɩ, 'ɩn ɔ -yɔ we yia yi. Ɔ 'nyɛa we ɔɔ 'ŋwnɔyu yoo, 'ɩn -mɔɔ yia -mɔɔ 'nyaa we kwa. ");
INSERT INTO kyf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zaaan 'bɩnɔnya 'nʋa we 'dɩ, 'ɩn wa yia ɔ 'kwie 'bʋmnɩ, wa 'ka we gbawla 'wʋfa. ");
INSERT INTO kyf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","-Zezuu tietienya yia lʋ, 'ɩn wa -yɔ ɔ 'sɔ yia 'wlugbeli. Gbʋ weee wa nʋa lɛ, -we wa -slolua nyɩma, 'ɩn wa yia we 'dɩ ɔ -salɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nyɩmaa -zlo, -wa yia, -wa mnɩa, wa 'gbʋ, -Zezu -yɔ ɔ 'bɩnɔnya 'nɩ mneni wa 'ka li. ");
INSERT INTO kyf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","We 'gbʋ ɔ nɛɛ ɔ 'bɩnɔnya -yla: «-A mnɩ da mɩa blenyii, -a 'ka -mɔ ladɩ.» 'Ɩn wa 'dɛkpʋa yia 'glʋ 'wʋ -bho, 'ɩn da nyɩma 'nɩa -mɩ, wa yia -mɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nyɩma duun 'yɩa da wa -yɔ mnɩda, 'ɩn wa yia wa yibheli. 'Ɩn 'gbe weee 'wʋ -nyɩma yia ɔ 'yu zili bhʋ -gʋ -gwagwɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","-Zezu 'tlaa 'glʋ 'wʋ, 'ɩn ɔ yia nyɩmaa -zlo -yɔyɩ. Wa 'wlʋ bhlabhlɛ -we 'nɩ 'yliyɔzʋnyɔ -ka. We 'gbʋ wa laa ɔ nyazɩ 'wʋ, 'ɩn ɔ yia wa gbʋ duun -slolu. ");
INSERT INTO kyf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jibhe zɔa, ɔ 'bɩnɔnya bɛa ɔ kwesi, 'ɩn wa nɛɛ ɔ -yla: «Da -mɩnɩ -tlʋlʋ la, 'ɩn 'ylʋ ka -fla. ");
INSERT INTO kyf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gba wa -yla, wa mnɩ kʋdanya -yɔ 'gbenya mɩa da -aɩn kwesi 'wʋ, wa 'ka wa 'dɛɛ lililu zɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɔ nɛɛ wa -ylaɛ: «Amɩaa 'dɛ 'nyɛ wa lililu!» Wa nɛɛ: «'Cʋ gbetaa lubho -gwɛzi 'nɩ mneni we 'ka wa 'floo zɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Ɩn ɔ nɛɛ wa -yla: «'Floo zuma mɩ aɩn kwɛɛa? A mnɩ a 'ka we zɛlɩ.» Wa zɛlɩa we, 'ɩn wa nɛɛ ɔ -yla: «Nɩɩ, 'floo gbu -yɔ zibhii 'ya sɔ mɩa -bha.» ");
INSERT INTO kyf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","-Bha ɔ gbaa wa -yla, -maa 'tʋlʋ nyɩma nɩɩ, wa -dɩ la -zlo ŋwɛɛ -petu kɔlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Ɩn wa yia -zlo ŋwɛɛ ladɩ. -Zlo yabhlo ka nyɩma 'wʋ glʋ gbu, 'ɩn tɔlʋa ka 'wʋ glʋ 'sɔ 'ya kugbua. ");
INSERT INTO kyf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","-Zezu 'bhua wee 'floo gbu -yɔ zibhii 'ya 'sɔ 'wʋ, ɔ ylaa yalɩ, ɔ 'paa -Lagɔ fuo, ɔ dɩdlɩa wee 'floo la, 'ɩn ɔ yia we ɔ 'bɩnɔnya yoo 'nyɛ, wa 'ka we nyɩma 'wʋladlili. 'Sa -bhlokpadɛ ɔ dlilia nyɩma weee zibhi 'wʋ la. ");
INSERT INTO kyf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wa 'dɛ weee lia, 'ɩn wa yia lʋ. ");
INSERT INTO kyf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Floo pnɩɩ -yɔ zibhi -we wa sɩalɩa, we nyni -cɩcɛ kugbua lɛ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nyɩma -wa lia, wa nʋkpasia mɩa wa glaa, wa nyni nyɩmaa 'wlu glʋ bhlo 'wlu gbu (5.000). ");
INSERT INTO kyf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tɔʋn, -Zezu nɛɛ ɔ 'bɩnɔnya -yla: «A -bho 'glʋ 'wʋ, a -galɩ 'mɩ 'yu -mɔ Bɛtɩsaida mnɩda. 'Ɩn ɩn 'ka waa nyɩma wɛlɩ 'pa.» ");
INSERT INTO kyf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wa 'bhʋbhlʋa -yɔ, 'ɩn ɔ yia -gɔgɔ 'wlu mnɩ, ɔ 'ka -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","-Kwɩtatʋkpa ylumanɩa la, -zugba -Zezuu 'bɩnɔnya mɩ -mɔ 'nyu -nyɩdɩ 'glʋ 'wʋ, 'ɩn ɔmɔ mɩa dʋdʋ, ɔ 'dɛ -bhlo. ");
INSERT INTO kyf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","-Zezu 'yɩa nɩɩ, -maa mɩ sɩada, -pɩpɛ mɩ wa 'klʋ -yɔ -gbɛɩn bhʋlʋda, 'ɩn 'glʋ -papɩe kalɩ -yɔ, tɩatɩa -kʋkɔ gboa, 'ɩn ɔ yia wa 'bɩ mnɩ 'nyu -gʋ -nɔnʋe nya, ɔ 'ka wa -gʋ ylɩ. ");
INSERT INTO kyf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Wa 'yɩa ɔ -yɔ nɔda -mɔ 'nyu -gʋ, wamɩa nɛɛ 'sa 'kuzu -wa. Wa 'dɛ weee 'yɩa ɔ -yɔ, 'ɩn wa yia nyanɔ nʋ. Wa 'kpɩa 'wʋ, -Zezu nɛɛ: «A 'na nʋnʋ nyanɔ -nɩ, -amɩ -wa, a palɩ dlɩ la.» ");
INSERT INTO kyf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Ɩn ɔ yia wa lʋ -bho -mɔ 'glʋ 'wʋ, 'ɩn -pɩpɛ yia zɔbɛ. Wee gbʋ 'nɩ wa ŋwɛgaga -sʋbhalɩ -sɛ. ");
INSERT INTO kyf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nɩɩ, wa yukwli -yɔ 'tɛlaa 'gbʋ, -Zezu 'nyɛa nyɩmaa -zlo lililu gwɛdi sa, wa 'nɩ ɔ 'tɩtɛ yibheli. ");
INSERT INTO kyf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","-Zezu -yɔ ɔ 'bɩnɔnya -dɩa 'nyu 'wʋ, wa nynia Zenezalɛtɩ -dʋdʋ -gʋ, -mɔ wa jɩa 'glʋ lubhu. ");
INSERT INTO kyf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wa mɩ 'glʋ 'wʋ lasibhlida, 'ɩn nyɩma yia -Zezu yibheli. ");
INSERT INTO kyf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wa -yɔ 'pulo -pulue mɩ 'gbe weee 'wʋ 'plɩlɩda, 'ɩn da wa -ka 'nʋ nɩɩ, -Zezu mɩ -bha, 'ɩn wa mnɩa -mɔ, wa -yɔ wa guzʋnya 'sɔ, -zugba -maa mɩ 'sowli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Da ɔ -ka mnɩ, 'ɩn wa laa ɔ guzʋnya. We yi kʋda -zɛoo, we yi -zɔɔ -zɛoo, we yi 'gbe 'kadʋ 'wʋ -zɛoo, 'ɩn wa palɩa wa guzʋnya -zejila 'wʋ la. 'Ɩn wa palɩa -Zezu zukpa nɩɩ, ɔ 'ka wa guzʋnya 'yoo 'nyɛ wa 'ka ɔ -banaa ŋwɛ kwɛzɩ. 'Ɩn -wa weee zɩa we kwɛ, -maa yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Bha Zuifʋʋ -yɔ Falizɩnyɩmaa -gbɛ, wa 'nɩ -slɔ kwɛ budo 'nanʋʋ, wa'a li. Nɩɩ, wa dʋkpasɩɩ tite -wa, 'mʋ wa zʋa 'nʋŋwɛ. Nɩɩ, wa -ka lɔkɔ 'wʋbhʋ, wa 'nɩ -slɔ budo, wa'a li. Tite tɔlʋa wa dʋkpasɩ tɩa wa -yɔ, 'ɩn wa zʋ 'yaa -mʋʋ 'nʋŋwɛ. Sa 'bhisa, nyidanya klaa, -tʋkpʋnya klaa, we -yɔ 'wʋmanɩ -kɔpʋnyaa 'wʋ lawɔlʋe. 'Ylɩ yabhlo nya, Falizɩnyɩma -yɔ -Lagɔɔ titee gwesanya 'bhʋa -Zeluzalɛmʋ, 'ɩn wa yia -Zezuu -gbɛ 'wʋgbeli. -Bha wa 'yɩa nɩɩ, ɔ 'bɩnɔnya tɔlʋa mɩ kwɛ pʋɩn lilida. Nɩɩ, -maa 'nɩ kwɛ budo. ");
INSERT INTO kyf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wa nɛɛ -Zezu -ylaɛ: «-Na 'bɩnɔnya lilia kwɛ pʋɩn. Wa 'nɩ -amɩaa dʋkpasɩɩ tite 'nʋŋwɛ zʋ. Lɛɛ -lu ka 'gbʋ wa yi 'sa nʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ɔ yia we 'bɩgʋpalɩɛ: «Wɛlɩ 'sɔ -nyɩma! -We -Lagɔgbʋʋ -falɩpanyɔ Ezaii cɛlɩa ɔ 'sɛbhɛ 'wʋ, gbʋzɔnʋ -wa: ‹Waa nyɩma mɩa, ŋwɛɛ la wa nnanɩa 'mɩ, nɩɩ, wa dlɩ 'nɩ 'mɩ -gʋ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bhebhe wa ylimanɩa 'mɩ. Nɩɩ, tite wa slolua, 'ɩn wa laa -Lagɔɔ tite, nyɩmaa 'dɛkpʋaa -gbɛ we 'bhʋa.› ");
INSERT INTO kyf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɩɩ, a ka -slɛɛn -Lagɔɔ dʋmagbʋ 'yitide, 'ɩn a nʋa nyɩmaa dʋmagbʋ lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɔ nɛɛ 'ya wa -ylaɛ: «A mna 'yli! A 'yɩbha a 'ka amɩaa dʋkpasɩɩ tite 'nʋŋwɛ zʋʋ 'gbʋ, a yia -Lagɔɔ tite 'yitide. ");
INSERT INTO kyf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moizɩ nɛɛ: ‹Zʋ -na dide -yɔ -na 'nyaa 'nʋŋwɛ.› 'Ɩn: ‹-Ɔ -ka ɔ dide -yɔ ɔ 'nyaa vɛlɩ, 'bha wa bhaa ɔ.› ");
INSERT INTO kyf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Ɩn amɩa, a nɛɛ: nyɩmɛ -ɔ -ka ɔ dide -yɔ ɔ 'nyaa -yla gba nɩɩ, ‹-We ɩn 'ka yaa aɩn 'nyɛ, mʋ -wa «Kɔlʋban» › (we ji -wa ɔ ka we -Lagɔ 'nyɛ), ");
INSERT INTO kyf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","amɩa 'nyɛa ɔ 'yoo, ɔ'ɔ nʋ -slɛɛn -lu yabhlogbɔɔ lɛ ɔ dide -yɔ ɔ 'nyaa 'sɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A -ka 'sa nʋda -mɩ nɩ, 'ɩn a saa -Lagɔwɛlɩ la, amɩaa bhlasabhla gbʋʋ 'gbʋ. 'Ɩn a nʋa we 'gbʋ 'sasʋkpa -gbʋ duun tɔlʋa lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","-Mʋʋ 'bɩgʋ, 'ɩn -Zezu yia nyɩmaa -zlo la, 'ɩn ɔ nɛɛ wa -ylaɛ: «A pʋ yukwli, -we na yia gbaa a 'ka we 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lililu nyɩmɛ lia nɩ, we'e -plalɩ ɔ pʋɩn. Nɩɩ, gbʋ -we ɔ gbaa, -we 'bhʋa ɔ dlɩ zɔ, mʋ plalɩa ɔ pʋɩn.  ");
INSERT INTO kyf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Da -Zezu 'bhʋa nyɩma glaa, ɔ plaa -budu zɔ, 'ɩn ɔ 'bɩnɔnya yia ɔ wee gbʋʋ ninee 'ji layɩbha. ");
INSERT INTO kyf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Ɩn ɔ nɛɛ wa -ylaɛ: «Amɩa'a 'nʋ 'ya -mʋʋ 'wʋlaa? A yibheli we 'ji nɩɩ, -lu -we nyɩmɛ lia, we'e -plalɩ ɔ pʋɩn. ");
INSERT INTO kyf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nɩɩ, wee lililu mɩa, we'e mnɩ ɔ dibhe 'wʋ, ɔ nʋkplɛ we mnɩa. -Mʋʋ 'bɩgʋ, 'ɩn ɔ plaa 'kwla -yɔ.» -Bha ɔ gbaa nɩɩ, wa mneni wa 'ka lililu weee li. ");
INSERT INTO kyf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'Ɩn ɔ nɛɛ 'yaɛ: «Wee -lu -we bhʋa nyɩmɛɛ dlɩ zɔ, mʋ plalɩa ɔ pʋɩn. ");
INSERT INTO kyf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wee -lu -we bhʋa nyɩma 'wʋ, -mɔ wa dlɩ zɔ, mʋ -wa nɩɩ: wa pʋpalɩ 'wlukʋʋn la 'nyumɛɛ, wa ka mʋtnɩ kwɛ, wa yli 'wie, wa bha nyɩmɛ, ");
INSERT INTO kyf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'ɩn 'ŋwnɩ -yɔ nyɩma -putu dɩa -budu 'wʋ. Wa 'yɩbha wa 'ka -gʋgalɩ. Gbʋnyuu wa nʋa lɛ, wa -lima wa nʋa -dawli 'wʋ. Wa'a zʋ tite 'nʋŋwɛ. Wa ka zenyi, 'ɩn wa saa nyɩmɛ 'ŋnɩ. Wa ylimanɩa wa 'dɛ, wa 'wlukʋʋn ka -nyumɔ. ");
INSERT INTO kyf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wee gbʋnyii mɩa dɛ, mʋ tlaa nyɩmɛɛ dlɩ zɔ, 'ɩn mʋ plalɩa ɔ pʋɩn.» ");
INSERT INTO kyf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Da -Zezu 'bhʋa -bha, 'ɩn ɔ yia Tilɩ -dʋdʋ -gʋ mnɩ, -mɔ ɔ plaa -budu zɔ. Ɔ 'nɩ 'yɩbha nɩɩ, nyɩmɛ 'yɩ ɔ, 'ɩn ɔ 'nɩ mneni ɔ 'ka zize. ");
INSERT INTO kyf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nɩɩ, ɔ plaa -budu zɔ, tɔʋn, 'ŋwnɔ yabhlo yia ɔ -gbɛ yi. Ɔɔ ŋwnɔ mɩa, 'lakpaŋwnɔ -wa: Silii -dʋdʋ yabhlo wa laa Fenisi, -mɔ wa gwalɩa ɔ. Nɩɩ, ɔ ka 'ŋwnɔyu, 'mɔ zuzu 'nyuu kpaa. 'Ɩn ɔɔ 'ŋwnɔ yia -Zezu -yɔbɛ, 'ɩn ɔ yia ɔ bhʋ -yɔ bhlili, ɔ nɛɛ: «-Na zukpa -wa, zuzu 'nyuu -we kpaa na 'yu nɩ, -ɩn vu we.» ");
INSERT INTO kyf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ɔ nɛɛ ɔ -yla: «'Ylaaslɩ -ka lida -mɩ, we 'nɩ tɩklɩɩ -mɩ wa 'ka 'ylaaslɩ lililu zɔsa wa 'ka we gwɩ zɔ viteli, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɔɔ 'ŋwnɔ nɛɛ ɔ -yla: «Na -Kanyɔ, gbʋzɔnʋ -wa. Nɩɩ, gwɩ -ka 'tabhle zɔ -mɩ, 'ɩn 'ylaaslɩ -ka lida -mɩ, wee lililu -we bhlia, gwɩ lia we. We 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ɔ nɛɛ: «-We a gbaa, gbʋzɔnʋ -wa. We 'gbʋ a 'bhiti lʋ. Nɩɩ, zuzu 'nyuu -we kpaa amaa 'yu, ɩn ka we vu.» ");
INSERT INTO kyf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ɔ mnɩa lʋ, ɔ nynia ɔ -buduŋwɛɛ, -zugba ɔ 'yu pɩ lii -gʋ la, zuzu 'nyuu ka ɔ 'yitide. ");
INSERT INTO kyf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","-Zezu 'bhʋa Tilɩ -dʋdʋ -gʋ, ɔ -dɩa Sidɔɔn -yɔ 'Gbe Kugbua -dʋdʋ 'wʋ, 'ɩn ɔ yia Galilenyu kwesi lʋyi. ");
INSERT INTO kyf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nyɩmɛ -ɔ'ɔ 'nʋa, 'ɩn -ɔ'ɔ gbaa, -bha wa -yɔ ɔ yia, 'ɩn wa nɛɛ ɔ -ylaɛ: «-Na zukpa -wa, palɩ ɔ -na sɔ -gʋ la ɔ 'ka 'pʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","-Zezu -yɔ ɔ 'sɔ 'bhʋa nyɩma glaa, 'ɩn ɔ yia ɔɔ guzʋnyɔɔ yukwlii 'yoo 'wʋ -kwɛtɩya fa. -Bha -Zezu tlia -dlɛ ɔ -kwɛtɩya -yɔ, 'ɩn ɔ yia ɔ mɩɔ kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tɔʋn, 'ɩn ɔ yia yalɩ yla, 'ɩn ɔ yia -nyii slu, 'ɩn ɔ nɛɛ ɔɔ guzʋnyɔ -yla: «Efata», -mʋʋ ji -wa nɩɩ: «-Ɩn -kalɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","-Bha -bhlokpadɛ ɔ 'pʋa, 'ɩn ɔ yia gba, 'ɩn ɔ yia 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","-Zezu nɛɛ waa nyɩma -yla: «A 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» 'Ɩn sa ɔɔ -Zezu zʋa wa 'dɩ, nɩɩ, wa'a gbalɩ we -nɩ, wa 'nɩ 'sa nʋ. ");
INSERT INTO kyf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ɩn wa -yɔ we gbagbɩe yia da weee mnɩ. Ŋwɛgaga ka wa -sʋbhalɩ, 'ɩn wa nɛɛ: «Aya! Ɔ lɛnʋlu weee mɩa 'yli we nanɩa. -Wa'a 'nʋaoo, 'ɩn -maa nʋa, -wa'a gbaaoo, 'ɩn -maa gbaa!» ");
INSERT INTO kyf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","We bhla, 'ɩn nyɩma duun yi 'yaa -Zezu 'bɩ yi. Lililu 'nɩ -mɩ. -Bha -Zezu laa ɔ 'bɩnɔnya, 'ɩn ɔ nɛɛ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nɩɩ, nyazɩ nyɩma nɩ laa 'mɩ 'wʋ. Wa 'ylɩ ta nɩ -zugba wa mɩ 'mɩ 'bɩ, 'ɩn lililu ka bhɩa. ");
INSERT INTO kyf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa 'nɩ -slɔ li. Ɩn -ka gba, wa mnɩ lʋ nɩ, wa mneni wa 'ka 'yloogblʋ bhlili. Nɩɩ, tɔlʋa 'bhʋda -tlʋlʋ la.» ");
INSERT INTO kyf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ɔ 'bɩnɔnya yia we 'bɩgʋpalɩɛ: «Aya! -Amɩa -flii 'pɩpɩ, da -a 'ka 'floo 'yɩ -a 'ka wa 'nyɛ, 'ɩn wa 'ka lʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ɔ nɛɛ: «'Floo zuma mɩ aɩn kwɛɛa?» -Maa nɛɛ: «'Floo gbesɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Ɩn ɔ nɛɛ nyɩma -yla: «A -dɩ dʋdʋ la.» Ɔ 'bhua wee 'floo 'wʋ, ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we ladɩdlɩ. Ɔ 'nyɛa we ɔ 'bɩnɔnya yoo, 'ɩn -maa yia we nyɩma 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zibhi yua tɔlʋa mɩa -bha, ɔ 'bhua we 'wʋ, 'ɩn ɔ yia we -Lagɔ kwɛɛ zʋ. Ɔ 'nyɛa we ɔ 'bɩnɔnya yoo, -maa yia we nyɩma 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wa lia, 'ɩn wa yia lʋ. -We wa sɩalɩa, we yia -cɩcɛ gbesɔ ye. ");
INSERT INTO kyf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nɩɩ, -wa lia, wa mneni wa 'ka nyɩma 'wlu glʋ -bhlo (4.000) nyni. ");
INSERT INTO kyf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","-Zezu 'nyɛa wa 'yoo tɔʋn, ɔ yia 'glʋ 'wʋbho ɔ -yɔ ɔ 'bɩnɔnya 'sɔ, 'ɩn wa yia Dalɩmanuta -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falizɩnyɩma yia, 'ɩn wa yia -Zezu kpɛlɩ, wa nɛɛ ɔ -ylaɛ: «-Ɩn nʋ gwɛdigbʋ yabhlo lɛ, 'ɩn -a 'ka we 'jiyibheli nɩɩ, -na 'tɩtɛ mɩa, -Lagɔ 'nyɛa -mɩ we.» ");
INSERT INTO kyf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","-Zezu yia nyɔ laslu, 'ɩn ɔ nɛɛ: «Lɛɛ -lu ka 'gbʋ amɩa dɛslɛɛn -nyɩma 'yɩbha 'sa gwɛdigbʋa? Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: waa -manɩ 'na 'ka gwɛdigbʋ yabhlogbɔɔ 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","-Zezu yia -bha wa tɩ. Ɔ -yɔ ɔ 'bɩnɔnya 'sɔ, wa yia 'glʋ 'wʋ -gbla, 'ɩn wa yia 'nyuu kakpe yabhlo -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ɔ 'bɩnɔnya ka dlʋ, wa 'nɩ lililu 'wʋbhu. 'Floo yabhlo -tʋa -mɔ 'glʋ 'wʋ, mʋ -bhlogbɔɔ -tʋa wa kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","-Zezu yia wa gbʋ -yla lapalɩ: «A zʋ amɩaa 'dɛ 'yliyɔ. A 'na 'tideli amɩaa 'dɛ 'yi Falizɩnyɩmaa 'flooo *gɔɔ -yɔ Ewlodʋʋ nyɩmaa -nʋ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","-Bha ɔ 'bɩnɔnya gbʋgbalɩa -yla: «Nɩɩ, 'floo 'nɩ -aɩn kwɛɛ -mɩ. We 'gbʋ ɔ yi 'saa gba.» ");
INSERT INTO kyf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","-Zezu yibhelia we 'ji, 'ɩn ɔ nɛɛ wa -ylaɛ: «Lɛɛ -lu ka 'gbʋ a gba 'sa? A 'nɩ 'floo 'wʋbhu -wa yɩ? A 'nɩ -slɔ we 'wʋlanʋʋ? Amɩaa yukwli -yɔ 'tɛa la yɩ? ");
INSERT INTO kyf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A ka 'yli 'klʋ -yɔ, 'ɩn a'a 'yɩ la. A ka yukwli, 'ɩn a'a 'nʋ. Amɩaa dlɩɩ -bho we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɩɩ, ɩn ka zlɩmɛ 'floo gbu nyɩmaa 'wlu glʋ -bhlo 'wlu gbu (5.000) 'wʋladlili. -Cɩcɛɛ yeye -nʋ zuma -tʋ zlɩmɛ 'wʋa?» Wa nɛɛ: «-Cɩcɛ kugbua lɛ 'sɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","'Ɩn ɔ nɛɛ: «Ɩn dlili 'yaa 'floo gbesɔ nyɩmaa 'wlu glʋ -bhlo (4.000) 'wʋla naa?» Wa nɛɛ: «-Cɩcɛ gbesɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɔ nɛɛ wa -yla: «Aya! A 'nɩ -slɔ we 'wʋlanʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","-Zezu -yɔ ɔ 'bɩnɔnya nynia Bɛtɩsaida, 'ɩn wa yia ɔ 'lɔlɔnyɔ -la. Zukpa wa palɩ ɔ zukpa nɩɩ, ɔ zɩ -mɔɔ kwɛ. ");
INSERT INTO kyf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","-Zezu kpaa ɔ sɔ la, 'ɩn ɔ -yɔ ɔ 'sɔ yia 'gbe lʋʋ mnɩ. -Mʋʋ 'bɩgʋ, 'ɩn ɔ yia ɔ -dlɛ 'yli -gʋ tli, 'ɩn ɔ yia ɔ sɔ -gʋ lapalɩ. Ɔ nɛɛ ɔ -ylaɛ: «-Na yɩ -lu yabhlo -yɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ɔ -bloa 'yli, ɔ nɛɛ: «Nyɩma na yɩa -yɔ, wa 'wlʋ sunya. Nɩɩ, wa mɩ nɔda.» ");
INSERT INTO kyf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","-Zezu palɩa ɔ 'yli -gʋ sɔ la 'ya, 'ɩn ɔ 'yli yia -blo, 'ɩn ɔ yia layɩ 'vayɩɩ. ");
INSERT INTO kyf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɔ nɛɛ ɔ -yla: «Mnɩ -na -buduŋwɛɛ. -Ɩn 'na plalɩ -zɔɔ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","-Zezu -yɔ ɔ 'bɩnɔnya mnɩa 'gbenya -we mɩa Sezalee Filipʋ kwesi nʋkplɛ. Wa mɩ 'yloogblʋ nɔda, 'ɩn -Zezu yia wa layɩbha: «'Lee, nyɔɔ nyɩma palɩ 'mɩ 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wa 'palɩa we 'bɩgʋ, wa nɛɛ: «Nyɩma nɛɛ nɩɩ, 'Zan -Batisɩ -ɩn -mɩa. Tɔlʋa nɛɛ, Elii -ɩn -mɩa, 'ɩn tɔlʋa nɛɛ 'yaɛ, bhlasabhla -Lagɔgbʋʋ -falɩpanyaa 'yabhlo -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɔ nɛɛ wa -ylaɛ: «'Ɩn amɩa, a nɛɛ, nyɔɔ ɩn -mɩa?» 'Ɩn Piɛlɩ nɛɛ: «-Lagɔɔ -Bhasanyɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","-Zezu nɛɛ: «A 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nɩɩ, -Zezu bhlia ɔ 'bɩnɔnya gbʋslolue, ɔ nɛɛ wa -yla: «We mɩ nɩɩ, ɔɔ *Nyɩmɛɛ 'Yu sɩa bhabha. Nɩɩ, Zuifʋʋ nyɩma kpasɩ klaa, *-Lagɔbʋbɔnyaa -cɩan klaa, we -yɔ -Lagɔɔ titee gwesanya yia ɔ kwnɛɛ -saa. 'Bhaa wa yia ɔ, 'ɩn 'ylɩ 'sɔ, we tanʋ nya, tlɩtlɩnya glaa ɔ yia 'wʋsɔa.» ");
INSERT INTO kyf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Sa ɔ gbaa we sa bɛblɛɛ, 'ɩn Piɛlɩ yia ɔ -glima lalɩ, 'ɩn ɔ nɛɛ ɔ -yla: «-Ɩn 'na gbalɩ 'sa -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","-Zezu 'bhitia la, ɔ ylaa ɔ 'bɩnɔnya, 'ɩn ɔ nɛɛ ɔ -yla 'klʋ 'cɩcɩ nya: «*-Saatan, bɛ lʋ! 'Bhʋ 'mɩ kwesi. Nɩɩ, -ɩ'ɩn pʋpalɩ 'wlukʋʋn la -Lagɔ 'bhisa, nyɩma 'bhisa -na pʋpalɩa 'wlukʋʋn la.» ");
INSERT INTO kyf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ɔ laa nyɩma -yɔ ɔ 'bɩnɔnya, 'ɩn ɔ nɛɛ wa -ylaɛ: «Nyɔɔo nyɔɔ -ka gba ɔ 'ka 'mɩ 'bɩ nɔ, ɔ -sa ɔ 'dɛ dlɩ, ɔ 'bhu ɔ sɩasɩee *su 'wʋ, 'ɩn ɔ 'ka 'mɩ 'bɩ yi. ");
INSERT INTO kyf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nɩɩ, nyɔɔo nyɔɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋgʋ nɩ, 'wʋ ɔ yia we bɔa. 'Ɩn -ɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋbɔ -Lagɔgbʋ -yɔ na 'gbʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ -mɔɔ yia 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nɩɩ, nyɩmɛ -ka dʋdʋ -gʋʋ zʋzɔnʋ weee 'yɩ, 'ɩn ɔ -ka ɔ 'yliyɔgagɩe 'wʋbɔ nɩ, lɛɛ -lu ɔ 'yɩ we 'wʋa? ");
INSERT INTO kyf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nɩɩ, -lu yabhlogbɔɔ 'nɩ mneni we 'ka nyɩmɛɛ 'yliyɔgagɩe zɔ. ");
INSERT INTO kyf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nɩɩ, Nyɩmɛɛ Yu yia yia ɔ Didee 'ŋnɩmnɩee san 'wʋ, ɔ -yɔ ɔ -mɔwlʋ -anzɩnya 'sɔ, -wa nʋa -Lagɔɔ dʋmagbʋ lɛɛ -gbɛ. Nɩɩ, dɛslɛɛn -nyɩma, -wa 'nɩa tɩklɩɩ -mɩ, 'ɩn wa nʋa gbʋnyuu lɛ, wa glaa, -ɔ -ka ɩn -yɔ na wɛlɩɩ zʋ nʋ, -amɩ, zlɩ ɩn -ka yi nɩ, 'ɩn na nʋ 'yaa ɔnʋʋ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ɔ nɛɛ wa -yla: «Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: amɩa -wa mɩa da -seli, aɩn glaa, tɔlʋa ka *-Lagɔɔ nyɩmaa 'wlulapɩlɩe 'yɩ yida 'tɩtɛ nya, 'bhie, wa 'kaa tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'Ylɩ gbu 'plɩa, we gbelibhlonʋ nya, -Zezu laa Piɛlɩ klaa, *'Zake klaa, we -yɔ *Zaan, 'ɩn wa 'dɛ -mnʋa 'bhie yia -gɔgɔ 'kadʋ 'wlu mnɩ. -Mɔ ɔ 'klʋ 'bhitia wa 'yliya 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Ɩn ɔ 'wʋ -bana yia pɔmanɩ tenyii. Lɩ we lɩa. Nyɩmɛ -ɔ 'kaa 'sa -bana pɔmanɩ dʋdʋ -gʋ, -mɔɔ -kanyɔ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","-Bha wa 'yɩa Moizɩ -yɔ Elii 'sɔ -yɔ, -zugba -maa -yɔ -Zezu mɩ 'dɩ -sada. ");
INSERT INTO kyf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","'Ɩn nyanɔ yia wa dlɩ 'wʋ slo. Wɛlɩ -we Piɛlɩ 'kaa gba, ɔ 'nɩ we -yi. -Bha ɔ gbaɛ: «*Wlabi, -amɩaa -seli -mɩmɩe nanɩ 'yli! Palʋ yua ta -a yia 'sʋbha, -na -nʋ -bhlo, Moizɩɩ -nʋ -bhlo, Eliii -nʋ -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","-Bha yalɩpʋpa wɛlɩa wa 'wʋ, 'ɩn wɛlɩ yabhlo yia wee yalɩpʋpa nyɩdɩ 'tla, we nɛɛ: «-Ɔ mɩa dɛ, na Yu -wa, ɩn -kalɩ ɔ zɛ. A pʋlʋ ɔ yukwli.» ");
INSERT INTO kyf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tɔʋn, 'ɩn -Zezuu 'bɩnɔnya yia latɩtalɩ, we 'nɩ -Zezu 'wʋbhʋ, wa'a 'yɩ nyɩmɛ yabhlogbɔɔ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wa mɩa -gɔgɔ kwlida, 'ɩn -Zezu nɛɛ wa -yla: «-We a 'yɩa da nɩ, nɩɩ, ɔɔ Nyɩmɛɛ 'Yu 'nɩ -slɔ tlɩtlɩnya glaa 'wʋsɔ, a 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wɛlɩ -we -Zezu gbaa wa -yla, wa ka we 'nʋŋwɛ zʋ. 'Ɩn wa yɩbhalɩa -yɩbhalɩa la: nɩɩ, ɔ nɛɛ: «Nyɩmɛ 'ka tlɩtlɩnya glaa 'wʋsɔ. Sa -mʋʋ 'ji mɩa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'Ɩn wa yia ɔ layɩbha: «'Lee, lɛɛ -lu ka 'gbʋ -Lagɔɔ titee gwesanya gba nɩɩ, *Elii 'kaa yi tɩaa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɔ nɛɛ: «Gbʋzɔnʋ -wa: Elii 'kaa yi tɩa ɔ 'ka -lu weee we 'bɩ 'wʋ la. We mɩ cɛlɩda *-Lagɔsɛbhɛ 'wʋ, nɩɩ, ɔɔ Nyɩmɛɛ Yu yia sɩa bhabha, 'ɩn wa 'ka ɔ vɛlɩ. -We ka 'gbʋ we mɩa cɛlɩda, a -yi we 'jii? ");
INSERT INTO kyf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Ɩn ɩn nɛɛ aɩn -yla: Elii ka yi pepe. 'Ɩn sa wa 'yɩbhaa, 'sa wa sɩalɩa ɔ. Sa we mɩa -benyi cɛlɩda -Lagɔsɛbhɛ 'wʋ, 'sa we 'plɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","-Zezu klaa, Piɛlɩ klaa, 'Zakee klaa, Zaan klaa, da wa nynia wa -lima -gbɛ, wa -talɩa -mɔ, -zugba nyɩmaa -zlo ka -maa gbeli. -Lagɔɔ titee gwesanya mɩ wa glaa. Wa -yɔ wa 'sɔ mɩ gbʋ gbada. ");
INSERT INTO kyf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wa 'yɩa -Zezu, tɔʋn wa yia ŋwɛ -ga, 'ɩn wa yia ɔ -gbɛ mnɩ -gwagwɩe nya, wa 'ka ɔ fʋsa. ");
INSERT INTO kyf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","-Zezu yia ɔ 'bɩnɔnya layɩbha: «-A 'nʋ -seli? Lɛɛ gbʋ a gbaa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Nyɩmɛ yabhlo 'palɩa we 'bɩgʋɛ: «-Slolunyɔ, -mɩ ɩn -laa na 'yu. Nɩɩ, zuzu 'nyuu ka ɔ kpa. We ka ɔ wɛlɩ 'wʋbhu, ɔ'ɔ gba. Da we -ka ɔ kpalɩ, la we bhlɩa ɔ. 'Fufli tlaa ɔ ŋwɛɛ, ɔ lia gla 'wʋ, 'ɩn ɔ slɛlɩa. Ɩn ka -na 'bɩnɔnya bhubhoe, wa 'ka wee zuzu 'nyuu vu. Wa 'nɩ we mneni.» ");
INSERT INTO kyf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","-Zezu nɛɛ wa -yla: «Dɛslɛɛn -nyɩma, -wa'a zʋ dlɩ, 'ylɩ zuma ɩn -yɔ aɩn 'sɔ 'ka lia? 'Ylɩ zuma ɩn 'ka amɩaa 'gba zɔ 'yligbeda -tʋa? A -yɔ ɔɔ 'yu 'sɔ yi.» ");
INSERT INTO kyf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Ɩn wa -yɔ ɔ yia yi. Da ɔ 'yɩa -Zezu, 'ɩn wee zuzu 'nyuu yia ɔ lazuklu 'tɩtɛɛ, 'ɩn ɔ yia bhli, -zugba ɔ glipe, 'fufli tla ɔ ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","-Zezu yia ɔ dide layɩbha: «We dɩa gwe, we -zʋ zuma nɩa?» Ɔ dide nɛɛ: «Ɔ mɩ -sɛlɛ, 'ɩn we yia gwedɩ. ");
INSERT INTO kyf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","We 'ka ɔ 'bhaa 'gbʋ, 'ylɩ tɔlʋa zlɩ, 'ɩn we paa ɔ -kosu 'wʋ, 'ɩn we paa ɔ 'nyu lʋ. Nɩɩ, -ɩn -ka mneni -ɩn 'ka -aɩn 'wʋsa, 'yɩlɩ -aɩn nyazɩ. Bɛ -aɩn -yɔ.» -Zezu nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","«Lɛɛ -lu 'ka 'gbʋ -na gba nɩɩ, -ɩn -ka we mnenia? -Ɔ zʋa -Lagɔ dlɩ -gʋ, ɔ mneni ɔ 'ka -lu weee lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","-Bha ɔɔ 'yuu dide 'kpɩa 'wʋ, ɔ nɛɛ: «Ɩn ka dlɩ -sɛlɛ -Lagɔɔ gbɛgbɛɩn, -sa 'mɩ 'wʋ, 'ɩn ɩn 'ka dlɩ zʋ weee.» ");
INSERT INTO kyf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","-Zezu 'yɩa nɩɩ, nyɩmaa -zlo mɩ ɔ -gbɛ yida, 'ɩn ɔ yia wee zuzu 'nyuu 'wluo 'kpɩlɩ: «-Mɩ zuzu 'nyuu, -mɩ nʋa we lɛ, 'ɩn nyɩmɛ'ɛ gbaa, ɩn ɔ'ɔ 'nʋa. Ɩn nɛɛ: 'tide ɔ 'yi. -Ɩn 'na kpalɩ 'maslɛɛn ɔ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","We zuklua ɔɔ 'yu la 'tɩtɛɛ, 'ɩn we yia ɔ 'yitide 'wʋkpɩkpɩe nya, 'ɩn ɔ yia lapɩ 'kwie 'bhisa. We 'gbʋ tɔlʋa nɛɛ: «Ɔ ka tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","-Zezu yia ɔ sɔ -yɔ ɔ 'wʋbhulu. Ɔ -sɔa 'wʋ, 'ɩn ɔ yia 'yligbe. ");
INSERT INTO kyf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","-Zezu -yɔ ɔ 'bɩnɔnya plaa -budu zɔ, 'ɩn wa yia ɔ layɩbha: «Wee zuzu 'nyuu mɩa dɛ nɩ, lɛɛ -lu ka 'gbʋ -a yi we vuvue sɩalɩa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ɔ nɛɛ wa -ylaɛ: «'Sasʋkpa -zuzu 'nyii mɩa dɛ nɩ, we 'nɩ -Lagɔɔ bhubhoe -bhlogbɔɔ 'wʋbhʋ, wa 'nɩ mneni wa 'ka -mʋʋ vu.» ");
INSERT INTO kyf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa 'bhʋa -bha, 'ɩn wa yia Galilee -dʋdʋ -gʋ 'plɩlɩ. -Zezu 'yɩbha wa 'na yibheli ɔ da -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ɔ -slolua ɔ 'bɩnɔnya gbʋ, ɔ nɛɛ: «Ɔɔ Nyɩmɛɛ 'Yu wa yia nyɩma yoo 'nyɛa, 'ɩn wa 'ka ɔ 'bha. 'Ylɩ 'sɔ, we tanʋ nya ɔ yia tlɩtlɩnya glaa 'wʋsɔa.» ");
INSERT INTO kyf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nɩɩ, -we -Zezu gbaa, ɔ 'bɩnɔnya'a 'nʋ we 'wʋla. Wa mɩ nyanɔ nʋdaa 'gbʋ wa 'nɩ ɔ layɩbha. ");
INSERT INTO kyf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wa nynia Kapɛnaumʋ, wa plaa -budu zɔ, 'ɩn -Zezu yia wa layɩbha: «Mɔɔ -dɩ a -sa yaa 'yloogblʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Ɩn wa -gʋ yia lasʋbha. -We ka gbʋ -wa, wa mɩa nɔda, 'ɩn wa yia layɩbhalɩ -yɩbhalɩ: «'Lee, nyɔɔ 'yli -aɩn glaaa?» ");
INSERT INTO kyf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɔ yia ladɩ, 'ɩn ɔ nɛɛ ɔ 'bɩnɔnya -yla: «A bɛ -seli. Nɩɩ, -ɔ -ka gba ɔ 'ka amɩaa kpasa -zɛ, ɔ -zɛ nyɩma weee 'bɩsʋayu, 'ɩn ɔ 'ka wa zɔlubho nʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɔ 'bhʋa 'yu yabhlo 'wʋ, 'ɩn ɔ -yɔ ɔ 'sɔ yia ɔ 'bɩnɔnya nyɩdɩ ladɩ, ɔ gblelia -mɔɔ, 'ɩn ɔ yia -mɔɔ ɔ bhʋ -gʋ ladɩ. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«'Yu -ɔ mɩa yu nɩ 'bhisa, nyɩmɛ -ɔ -ka ɔ kpa 'nanʋʋ na 'ŋnɩ nya, na 'dɛ ɔ kpaa 'nanʋʋ. -Ɔ -ka 'mɩ kpa 'nanʋʋ, we 'nɩ na 'dɛ ɔ kpa 'nanʋʋ, nɩɩ, -ɔ tiea 'mɩ, 'mɔ ɔ kpaa 'nanʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zaan nɛɛ -Zezu -yla: «Na -Slolunyɔ, -a ka nyɩmɛ yabhlo 'yɩ, ɔ 'nɩ -aɩn glaa -nyɩmɛ, -zugba ɔ vua zuzu 'nyuu -na 'ŋnɩ nya. Ɔ 'nɩ -aɩn glaa -mɩɩ 'gbʋ, -a yia ɔ 'yligbeli.» ");
INSERT INTO kyf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","-Zezu nɛɛ: «-Ɩnnya, a 'na 'yligbeli ɔ -nɩ. 'Lee, -ɔ -ka gwɛdigbʋ lɛnʋ na 'ŋnɩ nya, ɔ mneni ɔ 'ka 'mɩ vɛlɩɩ? -Ɩnnya. ");
INSERT INTO kyf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɩɩ, nyɩmɛ -ɔ 'nɩ -amɩaa tʋnyɔ, ɔ -yɔ -aɩn 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","«Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ -ka aɩn 'nyu 'nyɛ -Lagɔɔ -Bhasanyɔɔ 'ŋnɩ nya, -Lagɔ yia ɔ -tnʋʋ 'nyɛa. ");
INSERT INTO kyf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","'Ylaaslɩ -wa mɩa sa yu nɩ 'bhisa, 'ɩn wa zʋa 'mɩ dlɩ -gʋ, -ɔ -ka wa 'yabhlogbɔɔ gbʋnyuu lʋkwa, we nanɩ 'yli -mɔɔ -nʋ nya, wa 'ka ɔ tʋkpa 'kadʋ -blɩ -yɔ gbʋanɩ, 'ɩn wa 'ka ɔ 'nyu lʋ viteli. ");
INSERT INTO kyf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","We -ka -na sɔ 'ka -mɩ gbʋnyuu lʋ kwa nɩ, -dɩ -bha we. We nanɩ 'yli -ɩn 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩ, sɔ -bhlo nya, we -zi -ɩn 'ka -kosu -we'e nyumoa 'wʋ mnɩ sɔ 'sɔ nya.  ");
INSERT INTO kyf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","-Mɛmɛ mɩa, ‹nɔnya -we lia nyɩmɛɛ yɩcɛ we'e tlɩ, 'ɩn -kosu'u nyumo -mɔ -gba›. ");
INSERT INTO kyf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","«'Ɩn we -ka -na bhʋ 'ka -mɩ gbʋnyuu lʋ kwa nɩ, -dɩ -bha we. We nanɩ 'yli -ɩn 'ka 'yliyɔgagɩe 'yɩ 'tɩgɩe nya, we -zi wa 'ka -mɩ -kosu -we'e nyumoa 'wʋ viteli -na bhʋ 'sɔ nya.  ");
INSERT INTO kyf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","-Mɛmɛ mɩa, ‹nɔnya -we lia nyɩmɛɛ yɩcɛ we'e tlɩ, 'ɩn -kosu'u nyumo -mɔ -gba›. ");
INSERT INTO kyf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","«We -ka -na yli 'ka -mɩ gbʋnyuu lʋ kwa, -ɩn -sa -mɔ we. We nanɩ 'yli -ɩn 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ mnɩ 'yliya -bhlo nya, we -zi wa 'ka -mɩ -kosu -we'e nyumoa 'wʋ viteli, da nɔ lia yɩcɛ 'ylɩ weee nya, 'yli 'sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Sa wa palɩa gumu lililu -yɔ, 'sa -bhlokpadɛ -Lagɔ yia nyɩma -gʋ -kosu slua. ");
INSERT INTO kyf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gumu nanɩ 'yli. Mɛnɩ we mɛnɩa. We 'nɩ -slɛɛn mɛnɩ nɩ, wa 'nɩ mneni wa 'ka we mɛnɩe we -yɔ zʋ. Nɩɩ, amɩa, a mɩ gumu 'bhisa, a -tʋ 'wʋ -dlɔɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","-Zezu -yɔ ɔ 'bɩnɔnya 'sɔ mnɩa Zudee -dʋdʋ -gʋ, 'ɩn wa yia Zudɛɛn nyu 'wʋdɩ. Nyɩmaa -zlo yia ɔ kwesi yi lʋ. Sa ɔ nʋa 'ylɩ weee nya, 'sa ɔ bhli 'yaa wa slolue lʋ. ");
INSERT INTO kyf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Falizɩnyɩma yia ɔ kwesi bɛ, wa 'ka ɔ layla. 'Ɩn wa yia ɔ layɩbhaɛ: «'Lee, -amɩaa tite nʋkplɛ, nʋkpasu mneni ɔ 'ka ɔ 'ŋwnɔ kwnɛɛ -saa?» ");
INSERT INTO kyf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɔ nɛɛ: «'Lee, tite -mʋmʋ Moizɩ 'nyɛ aɩn a?» ");
INSERT INTO kyf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wa nɛɛ: «Moizɩ cɛlɩa nɩɩ, nyɩmɛ -ka gba ɔ 'ka ɔ 'ŋwnɔ kwnɛɛ -sa, ɔ cɛlɩ wee gbʋ 'sɛbhɛ -gʋ, 'bhie ɔ 'ka ɔ kwnɛɛ -sa.» ");
INSERT INTO kyf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'Ɩn -Zezu nɛɛ wa -yla: «Amɩaa yukwli -yɔ suloo 'gbʋ, 'ɩn Moizɩ yia 'mʋ tite nɩ palɩ. ");
INSERT INTO kyf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","-Lu weee gwedɩda, ‹'Ɩn -Lagɔ yia nʋkpasu -yɔ 'ŋwnɔ lala.› ");
INSERT INTO kyf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹We 'dɛɛ 'gbʋ, nʋkpasu yia ɔ dide -yɔ ɔ 'nyaa -yɔbhʋa, 'ɩn ɔ -yɔ ɔ 'ŋwnɔ 'ka 'wʋsuslolu, ");
INSERT INTO kyf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'Ɩn wa 'ka ku -bhlo -zɛ.› -Slɛɛn, wa 'nɩ 'maslɛɛn nyɩma sɔ, nɩɩ, nyɩmɛ -bhlo wa -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","We 'dɛɛ 'gbʋ, -we -Lagɔ -ka 'ylijɩjlɩ, nyɩmɛ 'na sɩsalɩ we 'yli -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wa plaa -budu zɔ, 'ɩn ɔ 'bɩnɔnya yia ɔ wee gbʋ nɩ 'ji layɩbha. ");
INSERT INTO kyf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɔ nɛɛ wa -yla: «Nɩɩ, nyɩmɛ -ɔ -ka ɔ 'ŋwnɔ kwnɛɛ -sa, ɔ -ka 'ŋwnɔ -putu kwa, gbʋnyuu ɔ nʋa ɔ 'ŋwnɔɔ tɩanʋ -yla lɛ. ");
INSERT INTO kyf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Sa -bhlokpadɛ, 'ŋwnɔ -ka ɔ 'lowli -glʋbhʋ, 'ɩn ɔ -ka nʋkpasu -putu kwa, gbʋnyuu ɔ nʋa lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nyɩma mɩ -Zezuu -gbɛ 'ylaaslɩ kwada, ɔ 'ka wa 'nyulaŋwna wa kwɛ -gʋ lapalɩe nya, 'ɩn ɔ 'bɩnɔnya yia wa vuvue bhli wa 'wluo kpɩlɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","-Zezu 'yɩa wa -yɔ, 'ɩn we yia ɔ -yɔkpa. 'Ɩn ɔ nɛɛ ɔ 'bɩnɔnya -yla: «A 'tide 'ylaaslɩ 'yi wa 'ka na -gbɛ yi, a 'na -kʋlʋ wa 'yoo -nɩ. Nɩɩ, nyɩma mɩa sa 'ylaaslɩ nɩ 'bhisa, -Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ -maa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ, -ɔ 'nɩ -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ -yɔŋwnu 'yɩslɔkpilɛ 'bhisa, ɔ 'na 'ka -Lagɔɔ -gbɛ pla.» ");
INSERT INTO kyf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɔ 'bhua wa 'wʋ, ɔ yia wa sɔ 'wluo lapalɩ, 'ɩn ɔ yia wa 'nyulaŋwna. ");
INSERT INTO kyf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nɩɩ, -Zezu mɩ mnɩda, 'ɩn nyɩmɛ yabhlo yia ɔ 'bɩgwalɩ, 'ɩn ɔ yia 'kukolu 'sibhli ɔ 'yu, 'ɩn ɔ nɛɛ ɔ -yla: «Na -slolunyɔ -zɔnʋ, sa ɩn 'ka nʋ, zlɩ ɩn -ka tlɩ, 'ɩn ɩn 'ka -Lagɔ kwɛɛ 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩa?» ");
INSERT INTO kyf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","-Zezu nɛɛ ɔ -yla: «-Mʋmʋ ka 'gbʋ -na la 'mɩ nyɩmɛ -zɔnʋa? We 'nɩ -Lagɔɔ 'dɛbhlogbɔɔ 'wʋbhʋ, nyɩmɛ -zɔnʋ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nɩɩ, -na 'dɛ -yi -Lagɔɔ *titenya: ‹-Ɩn 'na 'bhalɩ nyɩmɛ -nɩ. -Ɩn -yɔ 'ŋwnɔ -putu 'na -dɩlɩ -budu 'wʋ -nɩ. -Ɩn 'na ylili 'wie -nɩ. -Ɩn 'na zʋlʋ nyɩmɛ yo -yɔ -nɩ. -Ɩn 'na lili nyɩma 'wlu -dawli nya -nɩ. -Ɩn zʋ -bha -na dide -yɔ -na 'nyaa.› » ");
INSERT INTO kyf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɔ nɛɛ: «-Slolunyɔ, ɩn mɩ nyimeslɔ nya, 'ɩn ɩn yia tite -mɩnɩ 'nʋŋwɛzʋzʋe bhli.» ");
INSERT INTO kyf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","-Zezu ylaa ɔ zɛkalɩdlɩ nya, 'ɩn ɔ nɛɛ ɔ -yla: «-Lu yabhlo -tʋa 'wʋ, -ɩn 'nɩ -slɔ -mʋʋ lɛnʋ. Mnɩ, -ɩn 'pa -na -kakali weee pɛlʋ, -ɩn 'nyɛ we 'gwɛzi bobabhanya yoo, 'ɩn -ɩn 'ka 'ŋnɩmnɩe 'yɩ -Lagɔɔ -gbɛ. -Ɩn -ka we lɛnʋe bhɩa, -ɩn yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɔ 'nʋa wee wɛlɩ nɩ, 'ɩn 'kʋa yia ɔ 'yli lawla, 'ɩn ɔ yia lʋbhiti 'klʋ -susue nya. Nɩɩ, 'ŋnɩmnɩnyɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","-Zezu ylaa ɔ 'bɩnɔnya -wa gbelia ɔ, 'ɩn ɔ nɛɛ wa -yla: «'Ŋnɩmnɩnya 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ pla -yɔ we -kalɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wee wɛlɩ yia -Zezu 'bɩnɔnya ŋwɛgaga -sʋbhalɩ. 'Ɩn ɔ nɛɛ 'ya wa -yla: «Na 'yua, nyɩmɛ 'ka *-Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ pla, we 'nɩ 'tɛ -sɛ. ");
INSERT INTO kyf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'Ŋnɩmnɩnyɔ 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ pla, we -kalɩ -yɔ we -zi *-nyɔmɛɛ seenɩɩ 'bhʋka 'wʋplɩlɩe.» ");
INSERT INTO kyf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","We yia ɔ 'bɩnɔnya -lʋɛlɩ. Wa nɛɛ: «Aya! We -ka 'sa -mɩ, nyɔɔ -mɔmɔ 'ka gbʋ 'wʋbhʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","-Zezu ylaa wa, 'ɩn ɔ nɛɛ: «Nyɩmɛ 'nɩ we mneni, nɩɩ, -Lagɔ mneni we. -Lagɔ mɩa, ɔ mneni ɔ 'ka -lu weee lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","-Bha Piɛlɩ gbaa: «-Talɩ, -a ka -amɩaa -lu weee -bha tɩ, 'ɩn -a yia -mɩ 'bɩ yi.» ");
INSERT INTO kyf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ -ka ɔ -lu weee -bha tɩ na 'gbʋ, 'ɩn ɔ 'ka -Lagɔgbʋ gba, we 'lɛɛji -mɔɔ yia 'yɩa -zakpa glʋ gbu. -Ɔ -ka ɔ -budu klaa, ɔ bhelia klaa, ɔ bhɔlɔa klaa, ɔ 'nyaa klaa, ɔ dide klaa, ɔ 'yua klaa, we -yɔ ɔ kpaa -bha tɩ, bhla -we 'wʋ -a mɩa da -budunya klaa, bhelia klaa, bhɔlɔa klaa, 'nyaanya klaa, didea klaa, 'yua klaa, we -yɔ kpaanya ɔ yia 'yɩa, -zugba nyɩma sɩalɩ ɔ. 'Ɩn bhla -we yia yia, we nya ɔ yɩa 'yliyɔgagɩe -we 'nɩa bhloluda -ka. ");
INSERT INTO kyf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","«Nyɩmaa dumadu -wa -gaa 'yu, lʋ -maa yia -gaa. 'Ɩn -wa -gaa lʋ, 'yu -maa yia -gaa.» ");
INSERT INTO kyf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","-Zezu -yɔ ɔ 'bɩnɔnya 'sɔ, wa mɩa -Zeluzalɛmʋ mnɩda, -Zezu -galɩ wa 'yu 'yloogblʋ, -zugba ɔ 'bɩnɔnya lʋ dlɩ. -Wa mɩa wa 'bɩ, -maa mɩ 'ya nyanɔ nʋda. Ɔ nɛɛ ɔ 'bɩnɔnya kugbua lɛ 'sɔ -yla: «A bɛ -seli.» 'Ɩn -we 'kaa lɛnʋ, ɔ yia we wa -yla gba. ");
INSERT INTO kyf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔ nɛɛ: «A -talɩ, -Zeluzalɛmʋ -a mnɩa da. Nɩɩ, -mɔ wa yia ɔɔ Nyɩmɛɛ 'Yu wlaa. -Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya kwɛɛ wa yia ɔ pɛlʋ 'paa. 'Ɩn wa 'ka ɔ gbʋ 'wluladɩlɩ, 'ɩn wa 'ka wɛlɩ -bhlo bhlɩ wa 'ka ɔ 'bha. 'Ɩn 'lakpanya -wa 'nɩa -Lagɔ -yi, wa 'ka ɔ -maa yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","-Maa yia ɔ gla palɩa, -maa yia ɔ -dlɛ -gʋ slua, -maa yia ɔ sɛlɩa, 'ɩn -maa 'ka ɔ 'bha. 'Ylɩ 'sɔ, we tanʋ nya, 'ɩn ɔ 'ka gbawla 'wʋtla.» ");
INSERT INTO kyf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","We 'bɩgʋ, Zebedeee 'yua *'Zake -yɔ Zaan yia -Zezu -yɔbɛ, 'ɩn wa nɛɛ ɔ -yla: «-Amɩaa -Slolunyɔ, -we -a yia -mɩ -zlalɩa, -a 'yɩbha -ɩn nʋ we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ɔ nɛɛ wa -yla: «Lɛɛ -lu a 'yɩbhaa ɩn nʋ aɩn -yla lɛa?» ");
INSERT INTO kyf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wa nɛɛ: «Da nyɩma weee -ka we 'jiyibheli nɩɩ, -ɩn pɩlɩ nyɩma 'wlu la, 'nyɛ -aɩn 'yoo -a 'ka -mɩ kwesi ladɩ. 'Yabhlo 'ka -na lilisɔlʋ ladɩ, 'ɩn 'yabhlo 'ka -na kɔpɛsɔlʋ ladɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ɔ nɛɛ wa -yla: «Nɩɩ, -we a -zlalɩa 'mɩ, a 'nɩ we -yi. 'Lee, sɩasɩe -we zɔ na yia 'yligbea, a mneni a 'ka we zɔ 'yligbee? Yaayɩɩ batizea wa yia 'mɩ sɩasɩe lʋ, a mneni a 'ka ŋwnu wa 'ka 'sa aɩn batizee?» ");
INSERT INTO kyf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Ɩn wa nɛɛ ɔ -yla: «Ɩɩn, -a mneni we.» -Zezu yia we 'bɩgʋpalɩɛ: «Gbʋzɔnʋ -wa. Sɩa a yia 'mɩ 'bhisa. Sɩasɩe -we lʋ wa yia 'mɩ batizea, we lʋ wa yia aɩn batizea. ");
INSERT INTO kyf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nɩɩ, we -ka na lilisɔlʋ -yɔ na kɔpɛsɔlʋʋ ladɩdɩe, -amɩ 'nɩ mneni ɩn 'ka we wla. Nɩɩ, wee ladɩda mɩa, -Lagɔ ka we lamnazɩ nyɩma tɔlʋaa -nʋ nya. Nɩɩ, ma yia -bha ladɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa -lima kugbua 'nʋa we, 'ɩn wa yia wa -yɔ 'cɛ 'palɩ. ");
INSERT INTO kyf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","-Zezu yia wa 'dɛ weee la, 'ɩn ɔ nɛɛ wa -ylaɛ: «Nɩɩ, dʋdʋgʋ -nyɩmaa 'wlulapɩlɩnya mɩa, wa 'tɩtɛ nya wa sɩalɩa wa zɔlubhonʋnya. ");
INSERT INTO kyf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aɩn glaa, we 'na -mɩnɩ 'sa -nɩ. -Ɔ -ka gba ɔ 'ka nyɩmɛ 'kadʋ -zɛ, ɔ -zɛ ɔ -limaa zɔlubhonʋnyɔ. ");
INSERT INTO kyf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Ɩn aɩn glaa, -ɔ -ka gba ɔ 'ka nyɩma 'yugalɩ, ɔ -zɛ ɔ -limaa gaylo. ");
INSERT INTO kyf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nɩɩ, ɔɔ *Nyɩmɛɛ 'Yu 'nɩ yi wa 'ka ɔ 'wʋsa. Yi ɔ yia ɔ 'ka nyɩma 'wʋsa, 'ɩn ɔ 'ka tlɩ nyɩma duuun 'wʋzɩtɩee 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","-Zezu -yɔ ɔ 'bɩnɔnya nynia Zelikoo, wa mɩ wee 'gbe 'tlada, 'ɩn nyɩma duun yia wa 'bɩ yi. 'Lɔlɔnyɔ yabhlo wa laa Batimee, Timeee 'yu nya, ɔ -dɩ 'yoo ŋwɛ -yɔ la. Nɩɩ, -zlazlanyɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ɔ 'nʋa nɩɩ, Nazalɛtɩyu -Zezu mɩ 'plɩda, 'ɩn ɔ yia 'wʋkpɩ, ɔ nɛɛ: «*-Davidɩɩ 'yu -Zezuɔɔ, -ɩn 'yɩlɩ 'mɩ nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","'Ɩn nyɩma duun yia ɔ 'wluo 'kpɩlɩ. Wa nɛɛ ɔ -yla: «'Mu ŋwɛ!» -Mʋʋ bhla ɔmɔ 'kpɩa 'wʋ 'tɩtɛɛ: «-Davidɩɩ 'yuɔɔ, -ɩn 'yɩlɩ 'mɩ nyazɩɔɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tɔʋn, -Zezu yia 'yligbe, 'ɩn ɔ nɛɛ: «A la ɔ.» 'Ɩn wa yia ɔ la, -zugba wa gba ɔ -yla: «-Na 'yuo. -Ɩn -sɔ wʋ, ɔ mɩ -mɩ lada.» ");
INSERT INTO kyf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Lɔlɔnyɔ vitelia ɔ 'naa, 'ɩn ɔ yia 'wʋsɔ -gwagwɩe nya, ɔ yia -Zezu -yɔbɛ. ");
INSERT INTO kyf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","'Ɩn -Zezu yia ɔ layɩbha: «Lɛɛ -lu -ɩn 'yɩbha ɩn nʋ -mɩ -yla lɛa?» 'Ɩn ɔ nɛɛ: «*Wlabi, -ɩn -blo na 'yli, ɩn 'ka layɩ lʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ɔ nɛɛ: «'Bhiti lʋ, -na dlɩzʋzʋe ka -mɩ pue.» Tɔʋn, ɔ 'yli yia -blo, 'ɩn ɔ yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","-Zezu -yɔ ɔ 'bɩnɔnya cɩpaa -Zeluzalɛmʋ -yɔ, -mɔ Bɛtɩfaze -yɔ Betani kwesi, 'ɩn wa yia *Olivʋsunyaa -gɔgɔ ylɩ, -bha -Zezu tiea ɔ 'bɩnɔnya 'sɔ, ");
INSERT INTO kyf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","'ɩn ɔ nɛɛ wa -ylaɛ: «'Gbe -we mɩa -mɛmɛɛ aɩn 'yu, a mnɩ -mɔ. Nɩɩ, lɛbhla a 'ka -mɔ nyni, -sokofalɩ -dɔgbʋ yabhlo a yia -bha ylɩa lubhu -jɩda. Wee -sokofalɩ mɩa, nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ we -gʋ ladɩ. A -sa we lubhu, a -yɔ we yi. ");
INSERT INTO kyf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɩɩ, wa -ka aɩn layɩbha: lɛɛ -lu ka 'gbʋ a nʋ 'sa? A gba wa -ylaɛ: -amɩaa -kanyɔ 'yɩbha ɔ 'ka we -gʋ ladɩ, nɩɩ, dɛslɛɛn ɔ laa we lʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wa mnɩa, 'ɩn wa yia -sokofalɩ -dɔgbʋ yabhlo 'yɩ lubhu -jɩda -bha 'yooo ŋwɛ -yɔ -bha 'pipee -budu yabhloo ŋwɛ -yɔ. 'Ɩn wa yia we lubhu -sa. ");
INSERT INTO kyf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nyɩma mɩa -bha, wa nɛɛ: «Lɛɛ -lu ka 'gbʋ a sa wee -sokofalɩ lubhua?» ");
INSERT INTO kyf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Ɩn sa -Zezu zʋa wa 'dɩ, 'ɩn wa yi 'saa gba. 'Ɩn wa yia wa kwɛ -yɔ -sa, 'ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wa -laa wee -sokofalɩ -dɔgbʋ -Zezu, wa slʋa wa 'naa we -gʋ, 'ɩn ɔ yia we -gʋ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tɔlʋa slʋa wa 'naa 'yloogblʋ, 'ɩn tɔlʋa -dɩa suu kpɩ -mɔ kpaa, 'ɩn -maa yia we 'yloogblʋ laslu. ");
INSERT INTO kyf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nyɩma nɔa ɔ 'yu we -yɔ -wa nɔa ɔ lʋʋ, wa 'dɛ weee 'kpɩa 'wʋ, wa nɛɛ: «-A -mnɩnɩ -Lagɔɔ 'ŋnɩ. -Ɔ mɩa Jejitapɛɛ 'ŋnɩ nya yida, -Lagɔ ŋwna ɔ 'nyu la. ");
INSERT INTO kyf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyɩmɛ -ɔ mɩa yida, ɔ 'ka -aɩn 'wlulapɩlɩ -Davidɩɩ 'bɩgʋ, -Lagɔ 'palɩ 'sa ɔ sɔ -zɔnʋ -gʋ la. -Wa mɩa yalɩ, wa -mnɩnɩ -Lagɔɔ 'ŋnɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","-Zezu plaa -Zeluzalɛmʋ, 'ɩn ɔ yia *-Lagɔbudu 'kadʋ zɔ mnɩ, 'ɩn ɔ yia da weee yla. Jibhe zɔa, we 'gbʋ ɔ -yɔ ɔ 'bɩnɔnya kugbua lɛ 'sɔ yia Betani mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Zlɩ zlɩa, -Zezu mɩ Betani 'bhʋda, 'ɩn ŋwɔ yia ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tɔʋn, ɔ yia *figɩsu -we kaa kpɩ 'wlu -yɔyɩ -mɔ 'yu, 'ɩn ɔ yia we -yɔ bɛ, -de ɔ yi we 'bhue 'wlu 'yɩɩ. Ɔ 'ka -bha nyni, we kpɩɩ 'dɛkpʋa mɩa we 'wlu. Nɩɩ, we 'bhue -pa bhla 'nɩ -slɔ nyni. ");
INSERT INTO kyf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","-Bha ɔ gbaa wee su -yla: «-Mɩ'ɩ 'palɩ -slɛɛn 'bhue -nɩ.» Ɩn ɔ 'bɩnɔnya yia we 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wa nynia -Zeluzalɛmʋ, tɔʋn -Zezu yia -Lagɔbudu 'kadʋ ŋwɛɛ mnɩ. -Wa mɩa -bha, -valɛpanya -yɔ -lizɔnya, 'ɩn -Zezu yia wa vuvue bhli. Ɔ yia 'gwɛzi -bhitinyaa 'tabhle -yɔ -kpakʋʋn pɛlʋpanyaa kpenya labhlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɔ 'nɩ ŋwnu nyɩmɛ yabhlogbɔɔ -yɔ -lu 'ka -Lagɔbudu 'kadʋ ŋwɛɛ 'plɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɔ -slolua wa gbʋ, ɔ nɛɛ: «We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹Na -budu mɩa, 'mʋ wa yia laa dʋdʋgʋ -nyɩma weee -Lagɔ bhubhoe -budu.› 'Ɩn 'mʋ amɩa nʋa 'wienyaa zizeda 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","-Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya 'nʋa ɔ 'dɩ, 'ɩn wa yia nyanɔ nʋ, -we ka gbʋ -wa, ɔ gbagbawɛlɩ ka nyɩma duun ŋwɛgaga -sʋbhalɩ. We 'dɛɛ 'gbʋ wa mɩa 'klɩ 'yɩda wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jibhe zɔa, 'ɩn -Zezu -yɔ ɔ 'bɩnɔnya yia 'gbe nʋkplɛ 'bhʋ, 'ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Zlɩ zlɩa, wa mɩ 'yloogblʋ 'plɩda, 'ɩn -Zezuu 'bɩnɔnya yia wee figɩsu -yɔyɩ, -zugba we ka yɛ weee. ");
INSERT INTO kyf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","-We -Zezu gbaa, Piɛlɩ dlɩ 'sibhlia we -gʋ la, ɔ nɛɛ: «Wlabi, -ɩn yla figɩsu -ɩn bhlɩa dɛ gwɛzɛ, we ka yɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","-Zezu nɛɛ wa -yla: «A zʋ -Lagɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ka -gɔgɔ -yla gba: ‹'Bhʋ da, viteli -na 'dɛ 'nyu lʋ,› 'ɩn ɔ dlɩ 'ka -we ɔ gbaa da lɛnʋee -gʋ -mɩ, 'ɩn ɔ 'nɩ dlɩ lʋ, 'ɩn we nʋa lɛ. ");
INSERT INTO kyf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","We 'dɛɛ 'gbʋ ɩn nɛɛ aɩn -yla, -we weee a yia -Lagɔ -zlalɩa yia bhubhoe nya, a zʋ we dlɩ -gʋ nɩɩ, 'yɩa a yia we, 'ɩn -Lagɔ 'ka we aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Nɩɩ, a -ka -Lagɔ bhubhoeda -mɩ, 'ɩn nyɩmɛ yabhloo gbʋ -ka aɩn dlɩɩ -mɩ, a tɩ ɔ -yɔgbʋ 'wʋ, 'ɩn amɩaa Dide -ɔ mɩa yalɩ, ɔ 'ka amɩaa gbʋnyuu 'wʋtɩ.  ");
INSERT INTO kyf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A 'nɩ nyɩmɛɛ -yɔgbʋ 'wʋtɩ, amɩaa Dide -ɔ mɩa yalɩ, ɔ 'na 'ka amɩaa -yɔgbʋ 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","-Zezu -yɔ ɔ 'bɩnɔnya mnɩ 'yaa -mɔ -Zeluzalɛmʋ lʋ. Wa mɩ -zieda -mɔ -Lagɔbudu 'kadʋ ŋwɛɛ, 'ɩn -Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya klaa, we -yɔ Zuifʋʋ nyɩma kpasɩ, wa yia -Zezu -yɔ bɛ. ");
INSERT INTO kyf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wa yia ɔ layɩbha: «Se -mʋmʋ nya -na nʋ gbʋnya nɩ lɛa? 'Ɩn nyɔɔ 'nyɛ -mɩ we lɛnʋ sea?» ");
INSERT INTO kyf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ɔ nɛɛ wa -ylaɛ: «Gbʋʋ gɔ -bhlo na yia aɩn layɩbhaa, a -ka we 'bɩgʋpalɩ 'bhie, -ɔ 'nyɛa 'mɩ se, 'ɩn na gbaa ɔ 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nyɔɔ tie *Zaan ɔ batizee nyɩma, -Lagɔ -wa yaayɩɩ, nyɩma -wa yɩ? A gba 'mɩ -yla we.» ");
INSERT INTO kyf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'Ɩn wa yia we -gʋ kpɛlɩe bhli, 'ɩn wa nɛɛ: «-A -ka gba, ‹-Lagɔ tiea ɔ›, 'ɩn ɔ yɩbhaa -aɩn laɛ: ‹Lɛɛ ka 'gbʋ a 'nɩ ɔ wɛlɩ 'wʋŋwnua?› » ");
INSERT INTO kyf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wa mɩ nyɩma sɔda, nɩɩ, -maa nɛɛ Zaan mɩa -Lagɔgbʋʋ -falɩpanyɔ -wa. We 'dɛɛ 'gbʋ wa 'nɩ mneni wa 'ka gba nɩɩ, nyɩma tiea ɔ. ");
INSERT INTO kyf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","We 'dɛɛ 'gbʋ, wa nɛɛ -Zezu -yla: «-Ɔ tiea Zaan, -a 'nɩ ɔ -yi.» 'Ɩn -Zezu nɛɛ: «We -ka 'sa -mɩ, -ɔ 'nyɛa 'mɩ wee gbʋnya -mɩnɩɩ lɛnʋ se, -amɩ 'na 'ka 'ya -mɔɔ -kanyɔɔ 'ŋnɩ aɩn -yla gba.» ");
INSERT INTO kyf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","-Mʋʋ 'bɩgʋ, 'ɩn -Zezu yia wa -yla gbʋ gbagbɩe bhli gbʋʋ nine -papɩe nya: «Nɩɩ, nyɩmɛ yabhlo 'paa *-dlɔkpaa. Wee kpaa mɩa, 'mʋ ɔ bibelia 'suo. Ɔ nʋa *-dlɔyaa 'wʋnyazɔlu lɛ, 'ɩn ɔ yia kpaagʋtalɩ -gbagbʋ 'sʋbhaa. Ɔ 'bhua -busalubhonʋnya 'wʋ, -zugba -maa lo wee kpaa. 'Ɩn ɔ yia 'lakpa 'wʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Tɔʋn, -dlɔya -sa bhla 'ka bɛ, 'ɩn ɔ yia ɔ zɔlubhonʋnyɔ yabhlo tie waa -busalubhonʋnya 'bɩ, wa 'ka ɔ -nʋ wla. ");
INSERT INTO kyf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wa sloa -mɔɔ 'wluo, wa bhɩtɩa -mɔɔ, 'ɩn wa yia -mɔɔ vu kwɛ klo nya. ");
INSERT INTO kyf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ɔɔ -dlɔkpaa -kanyɔ yi 'yaa ɔ zɔlubhonʋnyɔ -putu tie. -Mɔɔ mnɩa, -mɔɔ wa bhɩtɩlɩa 'wluo, 'ɩn wa yia -mɔɔ vɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɔɔ kpaa -kanyɔ yi 'yaa nyɩmaa tanʋ tie, 'ɩn wa yia -mɔɔ 'bha. 'Sa ɔ tiea nyɩmaa -zlo, tɔlʋa wa bhɩtɩa, 'ɩn wa yia tɔlʋa 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Nyɩmɛ -bhlogbɔɔ -tʋa ɔ kwesi, mɔ -wa ɔ 'yu -ɔ -ka zɛ ɔ -kalɩa. -Mɔɔ ɔ tiea wa -gbɛ lʋgada, -zugba ɔ pʋpalɩa dlɩ la nɩɩ, -mɔɔ wa yia 'nʋŋwɛ zʋa. ");
INSERT INTO kyf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","-Bha waa -busalubhonʋnya gbʋgbalɩa -ylaɛ: ‹-Ɔ 'kaa cɩ ɔɔ kpaa -kanyɔ 'bɩ li, mɔ nɩ. -A mnɩ ɔ 'bhaa, 'ɩn wee kpaa 'ka -amɩaa -nʋ -zɛ.› ");
INSERT INTO kyf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wa sloa ɔ 'wluo. Wa 'bhaa ɔ, 'ɩn wa yia ɔ 'kwie viteli kpaa lʋʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«'Lee, sa ɔɔ kpaa -kanyɔ 'ka nʋa? Ɔ 'dɛ yia yia, ɔ 'ka nyɩma tie, wa 'ka waa -busalubhonʋnya 'bha, 'ɩn ɔ 'ka kpaa nyɩma -putu yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","«-We mɩa -Lagɔsɛbhɛ 'wʋ cɛlɩda, a 'nɩ -slɔ we zɛlɩɩ? We nɛɛ: ‹Tʋkpa, -we -budusʋbhanya -saa kwnɛɛ, mʋ -zɛa gwɩgwɩyli -tʋkpa -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","-Ɔ nʋa gbʋ nɩ lɛ, Jejitapɛ -wa. 'Ɩn wee gbʋ mɩa, -a -ka we 'yɩ, 'ɩn we namanɩa -amɩaa dlɩ.› » ");
INSERT INTO kyf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wee gbʋʋ nine mɩa, Zuifʋʋ 'yugalɩnya -yi we 'ji nɩɩ, ma -yɔ -Zezu -saa we. Wa ka 'klɩ 'yɩ, wa 'ka ɔ kpa. Nɩɩ, nyɩmaa -zlo wa mɩa sɔdaa 'gbʋ, wa yia ɔ -yɔ 'bhʋ, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Falizɩnyɩma tɔlʋa -yɔ Ewlodʋʋ nyɩma, 'ma wa tiea -Zezu -gbɛ, wa 'ka ɔ zɔ bhli, 'ɩn ɔ 'dɛɛ gbagbawɛlɩ 'ka ɔ gbʋan. ");
INSERT INTO kyf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wa yia, 'ɩn wa nɛɛ ɔ -yla: «-Amɩaa -Slolunyɔ, -a -yi we 'ji nɩɩ, -we -na gbaa, gbʋzɔnʋ -wa. -Ɩ'ɩn sɔ gbʋʋ 'yli, 'ɩn -ɩ'ɩn sɔ nyɩmɛ 'ylilo -ŋwɛɛ. Nɩɩ, sa -Lagɔ 'yɩbhaa nyɩmɛ -mɩ, 'mʋ -na slolua gbʋzɔnʋ sa. We mɩ tɩklɩɩ nɩɩ, -amɩaa tite nʋkplɛ, -a plʋlʋ *Sezaa kwɛɛ *nisʋn -gwɛzii? -A plʋlʋ we yaayɩɩ, -a 'na plʋlʋ we -nɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","-Zezu -yi we 'ji nɩɩ, wa gbagbawɛlɩ -yɔ wa 'wlukʋʋn la pʋpalɩe 'nɩ -mɩ -bhlo. Ɔ nɛɛ wa -yla: «Lɛɛ -lu ka 'gbʋ a bhli 'mɩ zɔa? A -la 'mɩ *Wlɔmʋ -tama yabhlo, ɩn 'ka we 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wa 'nyɛa ɔ tama yabhlo yoo, 'ɩn ɔ yia wa layɩbha: «'Lee, nyɔɔ ka 'wlu -yɔ ɔ ŋnɩ mɩ da we -gʋa?» 'Ɩn wa nɛɛ ɔ -yla: «Sezaa -wa.» ");
INSERT INTO kyf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","-Bha ɔ gbaa wa -yla: «-We -ka Sezaaa -nʋ, a 'nyɛ we Sezaa yoo, 'ɩn -we -ka -Lagɔɔ -nʋ, a 'nyɛ we -Lagɔ yoo.» 'Ɩn ɔ gbʋʋ 'bɩgʋpalɩ wɛlɩ yia wa ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadusenyɩma mɩa, wa nɛɛ nɩɩ, tlɩtlɩnya 'nɩ mneni wa 'ka tlɩtlɩe lʋ 'wʋsɔ. Wa tɔlʋa yia -Zezuu -gbɛ, 'ɩn wa nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«-Slolunyɔ, -we mɩa cɛlɩda Moizɩɩ tite 'wʋ, mʋ mɩa da. Nɩɩ, nyɩmɛ -ka 'ŋwnɔ kwa, ɔ -yɔ ɔ 'nɩ gwalɩ, ɔ -ka tlɩ, ɔɔ ŋwnɔ -tʋa ɔ 'bɩgʋ, ɔ bheli kwaa ɔ, 'ɩn ɔ -yɔ ɔɔ 'ŋwnɔ 'sɔ 'ka ɔ bhelii zʋa lala, 'ɩn -mɔɔ 'ŋnɩ 'ka dʋdʋ -gʋ -tʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sa 'bhisa, nyɩmɛ yabhlo ka nʋkpasuyua gbesɔ, 'ɩn wa kpasa yia 'ŋwnɔ kwa. Ɔ -yɔ ɔ 'nɩ gwalɩ, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wa 'sɔnʋ kwaa ɔ bhelii -dʋgbaŋwnɔ, -mɔɔ -yɔ ɔ 'nɩ gwalɩ, 'ɩn -mɔɔ yi 'yaa tlɩ. Ɔɔ 'ŋwnɔ -bhlokpadɛ yia waa bheliaa tanʋ kwa. ");
INSERT INTO kyf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'Sa wa 'dɛ gbesɔ kwaa ɔɔ 'ŋwnɔ -bhlo -bhlo, wa -yɔ ɔ 'nɩ gwalɩ, 'ɩn wa yia tlɩ. Wa 'bɩgʋ, ɔɔ 'ŋwnɔ yi 'yaa tlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","«'Lee, 'ylɩ -we nya tlɩtlɩnya yia 'wʋsɔa, nyɔɔ ka 'ŋwnɔ ɔ -maa? Nɩɩ, wa 'dɛ gbesɔ kwaa ɔ -bhlo -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","-Zezu nɛɛ wa -yla: «A ka 'yoo mnɔ, -we ka gbʋ -wa, a 'nɩ -Lagɔsɛbhɛ -yi, 'ɩn a 'nɩ -Lagɔɔ 'tɩtɛ -yi. ");
INSERT INTO kyf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tlɩtlɩnya -ka 'wʋsɔ, nʋkpasia -yɔ 'ŋwnɩ 'na 'ka kʋkwalɩ, nɩɩ, 'anzɩnya -we mɩa yalɩ, we 'bhisa wa yia -tʋa. ");
INSERT INTO kyf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Lee, we -ka tlɩtlɩnyaa 'wʋsɔgbʋ, -we mɩa cɛlɩda Moizɩɩ 'sɛbhɛ 'wʋ, a 'nɩ -slɔ we zɛlɩɩ? Da misagʋsu pilɛɛ -bhoa 'yli, 'ɩn -Lagɔ nɛɛ Moizɩ -ylaɛ: ‹-Amɩ -wa *Ablaamʋʋ -Lagɔ, *Izakɩɩ -Lagɔ, *Zakɔbʋʋ -Lagɔ.› » ");
INSERT INTO kyf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Ɩn -Zezu yia we -gʋdɩɛ: «-Lagɔ mɩa, 'yliyɔganyaa -Lagɔ ɔ -mɩa. Ɔ 'nɩ tlɩtlɩnyaa -Lagɔ. A ka mnɔ bhabha.» ");
INSERT INTO kyf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wa mɩ -Zezu laylada, 'ɩn -Lagɔɔ titee gwesanyɔ yabhlo yia we 'nʋ. Ɔ 'yɩa nɩɩ, -Zezu mɩ wa wɛlɩ 'bɩgʋpalɩda 'nanʋʋ, ɔ bɛa ɔ -yɔ, 'ɩn ɔ yia ɔ layɩbhaɛ: «-Lagɔɔ tite weee glaa, -mʋmʋ -wa we 'kadʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","-Zezu yia we 'bɩgʋpalɩɛ: «Tite weee glaa, -we -wa we 'kadʋ mʋ mɩa da: ‹*Izlaɛlɩnyɩma, a pʋ yukwli. Nɩɩ, Jejitapɛ mɩa, -amɩaa -Lagɔ -wa, ɔ -bhlogbɔɔ. ");
INSERT INTO kyf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jejitapɛ, -ɔ -wa -na -Lagɔ, -ɩn -kalɩ ɔ zɛ -na dlɩ weee nya, -na zuzu weee nya, -na 'wlukʋʋn lapʋpalɩe weee nya, -na 'tɩtɛ weee nya.› ");
INSERT INTO kyf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wee titee 'sɔnʋ nɩ: ‹-Ɩn -kalɩ -na -libheyii zɛ -na 'dɛ 'bhisa.› Tite, -we 'kaa tite sɔ nɩ 'wʋzi, we 'nɩ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɔɔ titee gwesanyɔ nɛɛ: «Gbʋzɔnʋ -wa. -Lagɔ -bhlogbɔɔ, ɔ 'nɩ 'sɔ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nyɩmɛ -ka -Lagɔɔ zɛkalɩ ɔ dlɩ weee nya, ɔ 'wlukʋʋn lapʋpalɩe weee nya, ɔ 'tɩtɛ weee nya, ɔ 'dɛ weee nya, 'ɩn ɔ -ka ɔ -limaa zɛkalɩ ɔ 'dɛ 'bhisa, -mʋʋ nanɩ 'yli we -zi 'slaka weee, we -zi nyɩmɛ 'ka wlawlalu sie -Lagɔ -yla.» ");
INSERT INTO kyf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ɔ 'palɩa we 'bɩgʋ gbʋyilo nya, -Zezu 'yɩa we -yɔ, 'ɩn ɔ nɛɛ ɔ -yla: «-Lagɔɔ -na 'wlulapɩlɩe 'nɩ -slɛɛn latlʋlʋ.» -Mʋʋ 'bɩgʋ, nyɩmɛ, -ɔ 'kaa 'tɩtɛ 'yɩ ɔ -yɔ -Zezu 'ka kpɛlɩ, -mɔɔ 'nɩ 'yɩe. ");
INSERT INTO kyf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","-Zezu mɩ nyɩma gbʋsloluda -Lagɔbudu 'kadʋ ŋwɛɛ, 'ɩn ɔ nɛɛ: «Waa -Lagɔɔ titee gwesanya nɛɛ nɩɩ, -Lagɔɔ -Bhasanyɔ mɩa, -Davidɩɩ yu -wa. Lɛɛ -lu ka 'gbʋ wa yi 'sa gbaa? ");
INSERT INTO kyf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nɩɩ, -Davidɩɩ 'dɛbhie -gbolu, -ɔ Zuzu 'Pʋpa 'nyɛa 'tɩtɛ, ɔ nɛɛ: ‹Jejitapɛ nɛɛ na -Kanyɔ -yla: «-Ɩn -dɩ da la na lilisɔlʋ. 'Ɩn ɩn 'ka -na tʋnyɩma -na bhʋ zɔ lapalɩ.» › ");
INSERT INTO kyf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nɩɩ, -Davidɩɩ 'dɛ -ka ɔɔ -Lagɔɔ -Bhasanyɔ la ‹na -Kanyɔ›, sa ɔ mneni ɔ 'ka ɔ 'yu -zɛa?» Nyɩmaa -zlo mɩa -bha, 'ɩn ɔ gbagbawɛlɩ yia wa 'mʋna 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ɔ mɩa wa -sloluda, ɔ nɛɛ: «A zʋ amɩaa 'dɛ 'yliyɔ -Lagɔɔ titee gwesanyaa gbɛgbɛɩn. Wa 'yɩbha tlʋlo -bana 'kadɩ 'wʋplaplɩe, -zugba wa zie we nya. Wa 'yɩbha wa -sa wa fʋ wa 'nʋŋwɛzʋzʋe nya -zejila 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","-Lagɔbudu zɔ -yɔ 'fɛtɩnya -gʋ, 'yugbɛɩn ladɩdɩe wa 'yɩbhaa kpe -zɔnʋnya -gʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","-Dʋgbaŋwnɩ wa saa -maa -lu weee kwɛɛ. 'Ɩn wa bhubhoea -Lagɔ nyɩma 'ylia 'wʋ kpokpo, nyɩma tɩklɩɩ 'bhisa. We 'gbʋ, -Lagɔ yia wa -yɔgbʋ 'wʋbhu, 'ɩn wanʋʋ -kaslʋ 'ka nyɩma tɔlʋaa -nʋ 'wʋzi.» ");
INSERT INTO kyf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","-Zezu -dɩ 'gwɛzii -gbo kwesi la, -zugba ɔ yla nyɩma -maa palɩ -mɔ 'gwɛzi -dɔlʋ -gʋ. Nɩɩ, 'ŋnɩmnɩnyaa -zlo palɩa -mɔ 'gwɛzi duun. ");
INSERT INTO kyf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bobabha -dʋgbaŋwnɔ yabhlo yia, ɔ palɩ -mɔ tamayua 'sɔ -we 'nɩa -valɛ -ka. ");
INSERT INTO kyf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","-Bha -Zezu gbaa ɔ 'bɩnɔnya -yla: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: bobabha -dʋgbaŋwnɔ mɩa dɛ nɩ, 'gwɛzi ɔ wlaa dɛ, we -zi nyɩma weee -nʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","'Ŋnɩmnɩnya mɩa, 'gwɛzi -we wa gbʋ 'nɩa 'wʋ -mɩ, 'mʋ wa wlaa. Nɩɩ, ɔɔ ŋwnɔ mɩa, ɔ boba 'wʋ, 'gwɛzi -we ɔ 'kaa lili, 'mʋ ɔ wlaa.» ");
INSERT INTO kyf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","-Zezu 'tlaa -Lagɔbudu 'kadʋ zɔ, 'ɩn ɔ 'bɩnɔnyɔ yabhlo nɛɛ ɔ -ylaɛ: «Na -Slolunyɔ: yi 'saa wa, tʋkpa -zɔnʋ, we -budu nanɩ 'yli 'lɛ!» ");
INSERT INTO kyf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Ɩn ɔ yia we 'bɩgʋpalɩɛ: «Gbʋzɔnʋ -wa, tʋkpanya -na yɩa dɛ -yɔ -gʋladɩdlɩda, we 'yabhlogbɔɔ 'na 'ka we -libheyi -gʋ -tʋ. Jitea we 'dɛ weee yia.» ");
INSERT INTO kyf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wa mnɩa Olivʋsunyaa -gɔgɔ 'wlu, -mɔ wa -dɩa la, -zugba wa yla -Lagɔbudu 'kadʋ. Da wa -nyaa 'wʋ, Piɛlɩ klaa, 'Zake klaa, Zaan klaa, we -yɔ Andlee, 'ɩn wa yia ɔ layɩbha: ");
INSERT INTO kyf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Lɛbhla -mʋʋ 'ka lɛnʋa? 'Ɩn lɛɛ -lu 'ka we -aɩn -slolu, nɩɩ, we bhla ka cɩpaa?» ");
INSERT INTO kyf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ɔ nɛɛ wa -yla: «A zʋ amɩaa 'dɛ 'yliyɔ, -mʋʋ yi 'wlʋ nɩɩ, wa nʋ aɩn -dawli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nyɩma -duun yia na 'ŋnɩ -gʋ yia, 'ɩn wa 'ka gbaɛ: ‹-Amɩ -wa -Lagɔɔ -Bhasanyɔ!› 'ɩn wa 'ka nyɩma duun -dawli 'wʋnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","«A -ka 'nʋ nɩɩ, wa mɩ tʋgʋda da -kwɛɩn, 'ɩn a -ka 'nʋ nɩɩ, wa mɩ tʋgʋda da 'pɩpɩ, a 'na nʋnʋ nyanɔ -nɩ. We mɩ nɩɩ, we nʋ lɛ, -mʋʋ 'nɩ -slɔ dʋdʋʋ bhɩalɩda. ");
INSERT INTO kyf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tʋ yia laga 'sɔ nyɩdɩ 'wʋsɔa. 'Ɩn nyɩmaa 'wlulapɩlɩnyɔ yabhlo 'ka nyɩmaa 'wlulapɩlɩnyɔ -gʋdʋ -yɔwʋsɔlʋ. Dʋdʋ yia zuklua da tɔlʋa, 'ɩn ŋwɔ 'ka yi. Sa 'ŋwnɔ -ka gwalɩa yi ɔ sɩa, 'sa wee dʋdʋʋ bhɩabhɩee gwedɩda yia -mɩa. ");
INSERT INTO kyf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Amɩa mɩa dɛ, a zʋ amɩaa 'dɛ 'yliyɔ. Gbʋwʋbhunya 'yu wa yia aɩn kwaa. Bhɩtɩa wa yia aɩn -Lagɔbudunya zɔ. Dʋdʋʋ 'wlulapɩlɩnya -yɔ nyɩmaa 'wlulapɩlɩnya 'yu wa yia aɩn laa na 'gbʋ, 'ɩn na gbʋdayɩnya a yia -zɛa wa 'yu. ");
INSERT INTO kyf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tɩada, -Lagɔgbʋ wa yia gbaa 'lakpanya weee -yla. ");
INSERT INTO kyf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wa -ka aɩn gbʋwʋbhunya 'yu kwa, a 'na lʋlʋ dlɩ -nɩ, -we a 'kaa gbaa 'gbʋ. -Mʋʋ bhla, wɛlɩ -we a 'kaa gba, -Lagɔ yia we aɩn ŋwɛɛ zʋa. We'e 'bhʋ amɩaa 'dɛɛ 'wlukʋʋn, Zuzu 'Pʋpa wlaa we. ");
INSERT INTO kyf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Nyɩmɛ yia ɔ bheli wlaa wa 'ka ɔ 'bha. 'Sa -bhlokpadɛ, dide yia ɔ 'yu wlaa. 'Yua yia wa didea -yɔwʋsɔlʋa wa 'ka wa 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na 'gbʋ, nyɩma weee yia aɩn 'wʋnyɛa. Nyɩmɛ -ɔ 'nɩ 'mɩ dlɩ -gʋ -sa, 'ɩn ɔ 'ka we bhloluda nyni, -Lagɔ yia ɔ gbʋ 'wʋsaa. ");
INSERT INTO kyf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nyɩmɛ -ɔ -ka 'sɛbhɛ nɩ zɛlɩ, ɔ 'nʋ we 'wʋla. Nɩɩ, -lu -Lagɔ 'nɩa 'yɩbha, 'ɩn -we saa -lu weee la, -ɔ -ka we -yɔyɩ ladɩda, da we 'na 'ka yaa -mɩ, -ɔ -ka 'sɛbhɛ nɩ zɛlɩ, ɔ 'nʋ we 'wʋla. Nyɩma -wa -ka Zudee -dʋdʋ -gʋ -mɩ, wa -yɔ -gwagwɩe mnɩ zizea -gɔgɔnya 'wlu. ");
INSERT INTO kyf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nyɩmɛ, -ɔ -ka nyapɛda -mɩ 'pipee, ɔ 'na mnɩnɩ ɔ -lu 'wʋbhua -budu zɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Ɩn -mɔmɔ -ka kpaa -mɩ, -mɔɔ 'na yili -mɔɔ -bana 'bhʋ -zɔɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lɛɛ gbʋnyuu yi 'sa nʋkplabhue ŋwnɩ -yɔ 'ŋwnɩ -wa mɩa 'yua 'nyɛnɩda ylɩa, wee 'ylɩnya -mɩnɩ nya! ");
INSERT INTO kyf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","A bhubhoe -Lagɔ, we yi lɛnʋ ŋwɔtlɔyibhla. ");
INSERT INTO kyf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","We bhla mɩa, sɩasɩe 'kadʋ wa yia 'yɩa. 'Lee, -a -ka 'bhaa 'wlʋ, we 'sasʋkpa -nʋ ka -slɔ lɛnʋʋ? 'Ɩn lɛ we yia nʋa yɩ? -Ɩnnya, we 'na 'ka lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","«-Lagɔ 'nɩ yaa wee 'ylɩ -gʋsa, -zugba nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka we kwɛɛ -dɩ. Nɩɩ, nyɩma ɔ -saa -bha, wa 'gbʋ ɔ yia wee 'ylɩ -gʋsaa. ");
INSERT INTO kyf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wa -ka gba nɩɩ, -Lagɔɔ -Bhasanyɔ mɩ -seli, 'ɩn wa -ka gba nɩɩ, ɔ mɩ mɔ, a 'na lalɩ we gbʋzɔnʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yocɩan yia yia, wa 'ka gba, nɩɩ, ma -wa -Lagɔgbʋʋ -falɩpanya -yɔ ɔ -Bhasanya. Gwɛdigbʋ -yɔ gbʋ 'kadɩ wa yia lɛnʋa, 'ɩn -wa -Lagɔ -saa -bha, wa 'ka wa -dawli nʋ. Nɩɩ, wa 'na 'ka we mneni. ");
INSERT INTO kyf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'Mʋ ɩn gbaa da aɩn -yla 'gamʋ. Nɩɩ, amɩa mɩa dɛ, a zʋ amɩaa 'dɛ 'yliyɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","'Ɩn -Zezu nɛɛ: «We bhla, wee sɩasɩee 'bɩgʋ, ‹Nikpise yia kpaa, 'ylʋ 'na 'ka 'pʋ. Nikpise yia kpaa, 'cʋ 'na 'ka lɩ. Nikpise yia kpaa, -zɛlɩ yia yalɩ 'bhʋa we 'ka bhli. -Lu weee mɩa yalɩ, zuklua we yia.› ");
INSERT INTO kyf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«-Mʋʋ 'bɩgʋ wa yia ɔɔ Nyɩmɛɛ 'Yu -yɔyɩa yida -mɔ yalɩpʋpa 'wʋ, 'tɩtɛ -yɔ zlɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","-Bha ɔ yia 'anzɩnya yoo 'paa, dʋdʋ weee -gʋ. 'Ɩn, -wa -Lagɔ -saa -bha 'gbe weee 'wʋ, wa 'ka wa la. ");
INSERT INTO kyf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«-We figɩsu slolua aɩn, a 'nʋ we 'wʋla. We 'klɩya -ka tlʋmanɩda -mɩ, 'ɩn we -ka tɔpɔda -mɩ, a -yi we 'ji nɩɩ, 'nyu -lʋa bhla ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Sa -bhlokpadɛ a -ka 'sasʋkpa -gbʋ -mɩnɩ 'yɩ lɛnʋda, a yibheli we 'ji nɩɩ, ɔɔ *Nyɩmɛɛ 'Yu ka cɩpa, ɔ 'nɩ -slɛɛn latlʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","«Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: dɛslɛɛn -nyɩmaa 'dɛ weee 'na 'ka tlɩ, 'ɩn wee gbʋnya -mɩnɩ 'kaa lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yalɩ -yɔ dʋdʋ mɩa, la we yia 'bhʋa, nɩɩ, na wɛlɩ 'na 'ka labhʋ 'mnumnu. ");
INSERT INTO kyf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nyɩmɛ yabhlogbɔɔ 'nɩ wee sɩasɩee bhla -yɔ we 'ylɩ -yi. Yalɩ -anzɩnya -yɔ -Lagɔɔ 'Yuu 'dɛbhie 'nɩ wee 'ylɩ -yi. Nɩɩ, na Dide -bhlogbɔɔ -yia we 'ylɩ. ");
INSERT INTO kyf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","«We 'dɛɛ 'gbʋ, a zʋ amɩaa 'dɛ 'yliyɔ. A -tʋ 'yliyɔgada. 'Ylɩ -we nya gbʋ nɩ 'kaa lɛnʋ, a 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","We 'wlʋ saɛ, nyɩmɛ yabhlo -ɔ mɩ 'lakpa 'wʋ mnɩda. Ɔ 'kaa mnɩ, ɔ yia ɔ zɔ -nyɩma lubho 'wʋladlili. 'Ɩn ɔ nɛɛ kloloo ŋwɛkʋnyɔ -yla: ‹-Ɩn 'na ŋwɔnʋ 'ylaa -nɩ.› ");
INSERT INTO kyf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","We 'dɛɛ 'gbʋ, a -tʋ 'yliyɔgada, a 'na ŋwɔnʋ 'ylaa -nɩ. Bhla -we nya -buduu -kanyɔ 'kaa yi, -de jibhezaoo, -de sabɔoo, -de zlɩgʋoo, -de zlʋkpɛoo, a 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɔ -ka aɩn 'tlalɩ, ɔ 'na ylɩlɩ aɩn ylaa ŋwɔda -nɩ. ");
INSERT INTO kyf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","-We ɩn mɩa da aɩn -yla gbada, mʋ na gbaa nyɩma weee -yla. A -tʋ 'yliyɔgada.» ");
INSERT INTO kyf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nɩɩ, we -tʋ 'wʋ 'ylɩ 'sɔ *'Wʋzɩtɩylɩɩ 'fɛtɩ -yɔ Zuifʋʋ 'floo 'nɩa *gɔɔ -yɔ -kaa 'fɛtɩ 'ka nyni. -Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya yia -Zezuu -yɔylɩ pla wa 'ka ɔ kpa -dawli nya, 'ɩn wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wa nɛɛ: «-A 'na kpalɩ ɔ 'fɛtɩɩ 'ylɩ nya -nɩ. We 'nɩ -mʋʋ, 'ɩn 'gbe gbugblolua.» ");
INSERT INTO kyf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","-Zezu mɩa Betani, sɔlɩbhanyɔ 'Simɔɔɔ -budu zɔ, da ɔ mɩa lida, 'ɩn 'ŋwnɔ yabhlo yia -mɔ pla. Ɔɔ 'ŋwnɔ, ɔ ka -bhonyida kwɛɛ. *-Lasiklɔ -zɔnʋ, -we ka -valɛ 'tɛa, we mɩ we 'wʋ. Ɔ -dɩa wee -bhonyida -blɩ ŋwɛɛ, 'ɩn ɔ yia wee -lasiklɔ -Zezuu 'wluo slu. ");
INSERT INTO kyf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nyɩma tɔlʋa mɩa -bha, 'ɩn -maa yia 'cɛ 'pa, -zugba wa 'yɩbhalɩ yɩbhalɩ la: «Lɛɛ -lu ka 'gbʋ ɔ nyumɔ -lasiklɔ nɩa? ");
INSERT INTO kyf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa mneni yaa wa 'ka we pɛlʋ 'pa 'gwɛzi duun lʋ, -we nyɩmɛ 'kaa 'yɩ -zʋ ŋwɛɛ, 'ɩn wa 'ka we bobabhanya 'nyɛ.» 'Ɩn wa yia ɔɔ 'ŋwnɔ -yɔ 'cɛpalɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","-Zezu nɛɛ wa -yla: «Lɛɛ -lu ka 'gbʋ a sɩalɩ ɔa? A 'tide ɔ 'yi. -We ɔ nʋa 'mɩ -yla lɛ, gbʋ -zɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nɩɩ, bobabhanya mɩ aɩn glaa 'ylɩ weee nya. Da a -ka 'yɩbhalɩ, a mneni a 'ka wa 'nanɩ 'wʋnʋ. Nɩɩ, -amɩ mɩa, ɩn 'nɩ aɩn glaa -mɩ 'ylɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","-We ɔ mnenia, 'mʋ ɔ nʋa 'mɩ -yla lɛ. Nɩɩ, -lasiklɔ ɔ tlia 'mɩ -yɔ gbawlaa 'gbʋ 'gamʋ. ");
INSERT INTO kyf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: da wa yia -Lagɔgbʋ gbaa dʋdʋ weee -gʋ, -we ŋwnɔ nɩ nʋa da lɛ, gbaa wa yia we, 'ɩn ɔ lɛnʋgbʋ 'ka nyɩmaa dlɩ 'wʋ -tʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","-Zezuu 'bɩnɔnya kugbua lɛ 'sɔ glaa, nyɩmɛ yabhlo, wa laa Zudasɩ Isɩkaliɔtʋ, mɔ mnɩa -Lagɔbʋbɔnyaa -cɩan -gbɛ, ɔ 'ka -Zezu wla. ");
INSERT INTO kyf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wa 'nʋa we, 'ɩn we yia wa 'mʋna 'wʋla. 'Ɩn wa nɛɛ ɔ -yla: «'Gwɛzi -a yia -mɩ 'nyɛa.» Sa ɔ 'kaa nʋ ɔ 'ka -Zezu wla, -bha ɔ bhlia we 'yooo datalɩe. ");
INSERT INTO kyf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","'Floo 'nɩa gɔɔ -yɔ -kaa 'fɛtɩ ka nyni. We 'ylɩɩ tɩanʋ -we nya wa bhaa *bhlabhlɛyua 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu nya, wee 'ylɩ nya -Zezuu 'bɩnɔnya 'yɩbhaa ɔ laɛ: «Mɔ -ɩn 'yɩbha -a mnɩ -mɩ -yla 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu pia?» ");
INSERT INTO kyf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","-Zezu tiea ɔ 'bɩnɔnya 'sɔ, 'ɩn ɔ nɛɛ wa -yla: «A mnɩ -zɔɔ. A -ka -mɔ nyni, nyɩmɛ -ɔ 'nyunyida mɩa 'wlu, a -yɔ ɔ yia 'wʋgbelia, a mnɩ ɔ 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ɔ -ka -budu -mʋmʋ zɔ pla, a gba wee -buduu -kanyɔ -yla: ‹-Amɩaa -Kanyɔ nɛɛ, «'Lee, -buduu 'yu -we zɔ -a 'kaa -amɩaa 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu li nɩ, mɔ we mɩa?» › ");
INSERT INTO kyf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Ɩn ɔ slolua aɩn -buduu 'yu 'kadʋ yabhlo 'klʋ, -mɔ -budu 'wlu, -we zɔ -gʋladɩ -li -zɔnʋ mɩa. -Mɔ a 'kaa -amɩaa 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu pili.» ");
INSERT INTO kyf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wa mnɩa, wa nynia -zɔɔ, 'ɩn sa -Zezu gbaa wa -yla, 'ɩn wa yi 'saa we ylɩ. 'Ɩn wa yia wa 'fɛtɩ -gʋ -lililu pi. ");
INSERT INTO kyf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jibhe zɔa, 'ɩn -Zezu -yɔ ɔ 'bɩnɔnya kugbua lɛ 'sɔ yia yi. ");
INSERT INTO kyf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Da wa mɩa lida 'tabhle -gʋ, -Zezu nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: aɩn glaa, nyɩmɛ yabhlo ɩn -yɔ ɔ mɩa da lida nɩ, mɔ yia 'mɩ wlaa.» ");
INSERT INTO kyf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tɔʋn, wa plɛ sumanɩa, 'ɩn wa yia ɔ layɩbha -bhlo -bhlo. «We 'nɩ -amɩ, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ɔ nɛɛ wa -yla: «Amɩa kugbua lɛ 'sɔ glaa nyɩmɛ yabhlo -wa. Ɩn -yɔ ɔ 'sɔ mɩ 'floo 'ŋwada zapʋ -bhlo lʋ. ");
INSERT INTO kyf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gbʋzɔnʋ -wa: sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ ɔ daa, 'sa ɔɔ Nyɩmɛɛ 'Yu yia mnɩa. Nɩɩ, nyɩmɛ -ɔ 'kaa ɔ wla, 'ɩn wa 'ka ɔ 'bha, gbʋnyuu mɩ -mɔɔ -nʋ nya. Wa 'nɩ yaa -mɔɔ gwalɩ, we nanɩ 'yli.» ");
INSERT INTO kyf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wa mɩa lida, 'ɩn -Zezu yia 'floo 'wʋbhu. Ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we ladɩdlɩ. Ɔ dlilia we ɔ 'bɩnɔnya 'wʋla, 'ɩn ɔ nɛɛ: «A 'bhu we 'wʋ, na ku -wa.» ");
INSERT INTO kyf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","-Mʋʋ 'bɩgʋ, 'ɩn ɔ yia nʋ -kɔpʋ 'wʋbhu, ɔ 'paa -Lagɔ fuo, 'ɩn ɔ yia we wa yoo 'nyɛ -bhlo -bhlo, 'ɩn wa 'dɛ weee yia we 'ma. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","«-We mɩa da nɩ, mʋ -wa na 'pɩɔn -we yia jitea nyɩma duuun 'gbʋ, 'ɩn we 'ka -Lagɔ -yɔ nyɩma 'sɔ 'wʋsuslolu. ");
INSERT INTO kyf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: zlɩ -Lagɔ -ka dʋdʋ 'wlulapɩlɩ, we zlɩ na maa nʋ lolu. We 'ylɩ 'nɩ -slɔ nyni, ɩn 'na 'ka nʋ 'ma.» ");
INSERT INTO kyf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wa bhlɩa -Lagɔ -lʋʋ 'bhie, wa yia 'tla, 'ɩn wa yia *Olivʋsunyaa -gɔgɔ 'wlu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","-Zezu nɛɛ wa -yla: «'Bɩ a yia 'mɩ 'bhʋa. Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋ: ‹Bhlabhlɛɛ 'yliyɔzʋnyɔ na yia 'bhaa, 'ɩn bhlabhlɛnya 'ka lamnɔ.› ");
INSERT INTO kyf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nɩɩ, ɩn -ka tlɩ, ɩn -ka 'wʋsɔ lʋ, Galilee na yia aɩn wʋlʋa mnɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piɛlɩ nɛɛ ɔ -yla: «Nyɩma weee -ka -mɩ 'bɩ 'bhʋ, -amɩ 'na 'ka we lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Ɩn -Zezu yia we 'bɩgʋpalɩɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -zɛɛn sabɔ mɩa, -na kpɛlɩ na gbʋ 'wʋla -zakpa ta, -zugba -kʋkɔ 'nɩ -slɔ -zakpa 'sɔnʋ gbo.» ");
INSERT INTO kyf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piɛlɩ nɛɛ -bhlokpadɛɛ: «-Ɩnnya, we 'nɩ -mʋʋ! We -ka 'bha wa 'ka -ɩn -yɔ 'mɩ 'sɔ 'bha, ɩn 'na 'ka -na gbʋ kpɛlɩ.» Tɔʋn, wa 'dɛ weee yia wee wɛlɩ -bhlo gba. ");
INSERT INTO kyf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","-Mʋʋ 'bɩgʋ, -Zezu -yɔ ɔ 'bɩnɔnya 'sɔ nynia Gɛtɩsemanee, 'ɩn ɔ nɛɛ wa -yla: «A -dɩ dɛ la. Ɩn 'ka -Lagɔ bhubhoe.» ");
INSERT INTO kyf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɔ -yɔ Piɛlɩ klaa, *'Zake klaa, we -yɔ *Zaan, wa yia mnɩ. -Bha ɔ -gʋ yia, 'ɩn 'pɩɔn yia ɔ dlɩ 'wʋ slo. ");
INSERT INTO kyf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɔ nɛɛ wa -ylaɛ: «Na dlɩ ka sumanɩ bhabha. A -tʋ -seli, a -tʋ 'yliyɔgada.» ");
INSERT INTO kyf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ɔ bɛa 'yu -sɛ, ɔ -gblia dʋdʋ la, 'ɩn ɔ yia -Lagɔ bhubhoe, ɔ nɛɛ: «*Aba! Dide! -Ɩn mneni -ɩn 'ka -lu weee lɛnʋ. -Ɩn -ka we 'yɩbha nɩ, -ɩn vlalɩ 'mɩ sɩasɩe 'kadʋ -mɩnɩ gwe. Nɩɩ, we 'na -zɛlɩ na dʋmagbʋ -nɩ: we -zɛ -na dʋmagbʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɔ yia ɔ 'bɩnɔnyaa -gbɛ lʋ, -zugba wa mɩ 'ylaa 'wʋ. Ɔ nɛɛ Simɔ Piɛlɩ -yla: «'Ylaa -na ŋwɔa yɩ? -Ɩn 'nɩ mneni -ɩn 'ka 'yliyɔgada -tʋ 'lɛlɩ -bhloo -kpʋaa? ");
INSERT INTO kyf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A -tʋ 'yliyɔgada, a bhubhoe -Lagɔ, a yi laylagbʋ lʋ bhlili. Nɩɩ, nyɩmɛɛ dlɩ 'yɩbha we 'ka -lu -zɔnʋ lɛnʋ, 'ɩn ɔ ku 'nɩ we mneni.» ");
INSERT INTO kyf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tɔʋn, ɔ 'bhʋ 'yaa wa -yɔ lʋ, 'ɩn ɔ yia -Lagɔ bhubhoe wɛlɩ -bhlokpadɛ nya. ");
INSERT INTO kyf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɔ yia lʋ, -zugba wa mɩ 'ya 'ylaa 'wʋ, wa 'yli ka 'wʋwɔmanɩɩ 'gbʋ. Wɛlɩ -we wa 'kaa ɔ -yla gba, we 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ɔ yia lʋ -zakpa tanʋ nya, ɔ nɛɛ wa -ylaɛ: «A mɩ 'ylaa 'wʋ -bhlokpadɛ, nyapɛda a mɩa yɩ? We -tʋ 'sa. Da wa 'kaa Nyɩmɛɛ 'Yu wla gbʋnyuu -lɛnʋnya -yla, we bhla ka nyni. ");
INSERT INTO kyf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A -sɔ 'wʋ, -a 'ka mnɩ. A -talɩ, nyɩmɛ -ɔ 'kaa 'mɩ wla, mɔ yia mɔ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Da -Zezu mɩa gbada, wɛlɩ mɩ ɔ ŋwɛɛ, tɔʋn Zudasɩ yia yi. Ɔɔ Zudasɩ mɩa, ɔ mɩ -Zezuu 'bɩnɔnya kugbua lɛ 'sɔ glaa. 'Ɩn ɔ -yɔ nyɩmaa -zlo yia yi, tʋgʋgblɛ -yɔ su kibhe nya kwɛɛ. Nɩɩ, -Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya klaa, we -yɔ nyɩma kpasɩ, ma tiea wa. ");
INSERT INTO kyf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudasɩ, -ɔ 'kaa -Zezu wla, sa ɔ 'kaa ɔ wla, ɔ ka we wa -yla gba. Ɔ nɛɛ: «Nyɩmɛ ɩn -ka gbleli nɩ, mɔ -wa. A kpa ɔ, a -yɔ ɔ 'sɔ mnɩ, a zʋ ɔ 'yliyɔ 'nanʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zudasɩ nynia -Zezu kwesi, 'ɩn ɔ nɛɛ: «*Wlabi.» 'Ɩn ɔ yia ɔ gbleli. ");
INSERT INTO kyf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","-Bha wa yibhelia -Zezu, 'ɩn wa yia ɔ kpa. ");
INSERT INTO kyf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɔ 'bɩnɔnyɔ yabhlo -saa tʋgʋgblɛ tʋkpa 'wʋ tɔʋn, ɔ yia *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋnyɔ yabhlo yukwli 'wlu -dɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","-Zezu nɛɛ wa -yla: «'Wienyɔ ɩn -mɩa, 'ɩn a yia 'mɩ kpaa yi tʋgʋgblɛ -yɔ su kibhe nya kwɛɛ -nya yɩ? ");
INSERT INTO kyf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","-Ɩnnya, 'ylɩ weee nya, ɩn mɩ aɩn glaa gbʋ -sloluda -mɔ -Lagɔbudu 'kadʋ zɔ, 'ɩn a 'nɩ 'mɩ kpa. Sanɛɛ a kpaa 'mɩ, 'ɩn -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, we 'ka gbʋzɔnʋ -zɛɛ 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tɔʋn, 'ɩn ɔ 'bɩnɔnya yia -bha ɔ tɩ -gwagwɩe nya. ");
INSERT INTO kyf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nyimeslɔyu yabhlo yia ɔ 'bɩ, ɔ ka 'naa -bhlogbɔɔ -gʋ. Wa kpaa wee 'naa, 'ɩn ɔ yia we wa kwɛɛ tɩ, 'ɩn ɔ yia -gwa kpanʋ nya. ");
INSERT INTO kyf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wa yia -Zezu -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ -gbɛ kwa. Da -Lagɔbʋbɔnyaa -cɩan klaa, nyɩma kpasɩ klaa, we -yɔ -Lagɔɔ titee gwesanya weee, wa gbelia 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛlɩ mɩ -Zezu 'bɩ, ɔ 'nɩ ɔ -yɔ cɩpa. Ɔ plalɩa -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ -buduŋwɛɛ, 'ɩn ɔ yia -kosu -yɔ ladɩ, ɔ -yɔ 'slʋja 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","-Lagɔbʋbɔnyaa -cɩan -yɔ gbʋwʋbhunya weee tɩtalɩa -Zezu -yɔ la wa 'ka ɔ gbʋ -dɩlɩ, 'ɩn wa 'ka ɔ 'bha, wa 'nɩ gbʋ yabhlogbɔɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nyɩma -duun zʋlʋa ɔ yo -yɔ, 'ɩn -maa wɛlɩ 'nɩ bhli -bhlo. ");
INSERT INTO kyf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tɔlʋa -sɔa 'wʋ, -maa dɩlɩa ɔ yo gbʋ 'wlu la, 'ɩn -maa nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Gbʋ ɔ gbaa, -a ka we 'nʋ. Ɔ nɛɛ nɩɩ, -Lagɔbudu 'kadʋ, -we nyɩma 'sʋbhaa da nɩ, -wlɔa ɔ yia we. 'Ɩn 'ylɩ ta zɔ we -putu -we nyɩmɛɛ sɔ 'nɩa 'tlili, ɔ 'ka -mʋʋ 'sʋbha.» ");
INSERT INTO kyf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wee gbʋ nɩ -gʋ, wa'a gba wɛlɩ -bhlo. ");
INSERT INTO kyf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -sɔa 'wʋ wa nyɩdɩ, 'ɩn ɔ yia -Zezu layɩbha: «Nyɩma nɩ mɩ -mɩ gbʋ 'wluladɩlɩda. -Ɩn 'nɩ mneni -ɩn 'ka we -gʋ -saa?» ");
INSERT INTO kyf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","-Zezu 'nɩ ŋwɛ gba. Ɔ -sɔ yaa 'wʋ, 'ɩn ɔ yia ɔ layɩbha: «'Lee, -Lagɔɔ -Bhasanyɔ -ɩn -mɩa yɩ? -Lagɔ ka 'ŋnɩ -a mnɩnɩa, ɔ 'Yu -ɩn -mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","-Zezu yia we 'bɩgʋpalɩ: «Cɩɩn, 'mɔ ɩn -mɩa. Nyɩmɛɛ Yu yia 'tɩtɛ -ka -Lagɔɔ lilisɔlʋ ladɩa. 'Yɩa a yia ɔ yalɩpʋpa -gʋ we nya kwlida.» ");
INSERT INTO kyf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ yia ɔ 'naa yla 'cɛ nya. Ɔ nɛɛ: «Ɔ ka -Lagɔ vɛlɩ, a 'dɛ weee ka we 'nʋ. -A 'nɩ -slɛɛn gbʋdayɩnyɔɔ gbʋ -ka.» Ɔ nɛɛ wa -yla: «Amɩa nɛɛ lɛa?» Wa nɛɛ: «Ɔ ka gbʋnyuu lɛnʋ.» -Zugba wa kpɩa 'wʋ: «A 'bha ɔ! A 'bha ɔ! A 'bha ɔ!» ");
INSERT INTO kyf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nyɩma tɔlʋa slua ɔ -dlɛ -gʋ. Wa -gblia ɔ 'naa 'yli -gʋ, 'ɩn wa yia ɔ bhɩtɩ -kwli nya, wa nɛɛ ɔ -yla: «Nyɔɔ 'pa -mɩ -lua? -Ɩn gba ɔ 'ŋnɩ!» 'Ɩn 'slʋja yia ɔ 'kpa yukwli 'wʋ sʋbha. ");
INSERT INTO kyf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Nɩɩ, da Piɛlɩ mɩa 'wɔlɔda -mɔ wee -buduŋwɛɛ, 'ɩn -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋŋwnɔ yia yi. Ɔ 'yɩa Piɛlɩ, 'ɩn ɔ yia ɔ yla tenyii, 'ɩn ɔ nɛɛ ɔ -yla: «-Mɩ mɩa da, -ɩn -yɔ Nazalɛtɩyu -Zezu 'sɔ mɩ -benyi.» ");
INSERT INTO kyf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piɛlɩ nɛɛ: «Yo -wa yo, ɩn 'nɩ ɔ -yi. -We a gbaa dɛ nɩ, ɩ'ɩn 'nʋ we 'wʋla.» Tɔʋn, 'ɩn ɔ yia 'wʋsɔ, ɔ yia klolo ŋwɛɛ 'yligbe. 'Ɩn -kʋkɔ yia gbo. ");
INSERT INTO kyf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɔɔ 'ŋwnɔ 'yɩ 'yaa ɔ, -wa mɩa -bha, ɔ nɛɛ wa -yla: «Ɔɔ nʋkpasu mɩa da nɩ, ɔ mɩ waa nyɩma nɩ glaa.» ");
INSERT INTO kyf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piɛlɩ nɛɛ: «Yo -wa yo.» Tɔʋn, -wa mɩa -bha, wa nɛɛ Piɛlɩ -yla: «Gbʋzɔnʋ -wa, -ɩn mɩ wa glaa. Nɩɩ, Galilee -nyɩmɛ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Ɩn Piɛlɩ yia bi, ɔ nɛɛ: «Nyɩmɛ a saa dɛ 'ŋnɩ, ɩn 'nɩ ɔ -yi, ɩn -ka yo 'tʋbhʋ, -Lagɔ 'pa 'mɩ -kaslʋ 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","-Bha -bhlokpadɛ, -kʋkɔ yia -zakpaa 'sɔnʋ gbo, 'ɩn Piɛlɩɩ dlɩ yia -Zezuu wɛlɩ -gʋ -bho, nɩɩ, ɔ kpɛlɩ -Zezu gbʋ 'wʋla -zakpa ta, -zugba -kʋkɔ 'nɩ -slɔ -zakpaa 'sɔnʋ gbo. 'Ɩn Piɛlɩ yia wie bhli. ");
INSERT INTO kyf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zlʋkpɛ -papa, *-Lagɔbʋbɔnyaa -cɩan klaa, nyɩma kpasɩ klaa, we -yɔ -Lagɔɔ titee gwesanya, waa gbʋwʋbhunya weee, ma bhlɩa wɛlɩ -bhlo. Wa gbʋan -Zezu, *Wlɔmʋ -nyɩmɛ -ɔ pɩlɩa Zudee -dʋdʋ 'wlu la, wa laa Pilatɩ, 'ɩn wa yia ɔ -mɔɔ -gbɛ kwa, 'ɩn wa yia ɔ -mɔɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","-Bha Pilatɩ 'yɩbhaa ɔ la: «'Lee, Zuifʋʋ 'wlulapɩlɩnyɔ -ɩn -mɩa yɩ?» -Zezu nɛɛ ɔ -yla: «'Mʋ -ɩn gbaa dɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","-Lagɔbʋbɔnyaa -cɩan dɩlɩa -Zezu gbʋ duun 'wlu la. ");
INSERT INTO kyf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Ɩn Pilatɩ yia ɔ -zakpa 'sɔnʋ layɩbha: «'Lee, gbʋʋ -zlo wa dɩlɩa dɛ -mɩ 'wlu la nɩ, -na nʋ we, 'ɩn -ɩ'ɩn -sa we -gʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","-Zezu 'nɩ we 'yabhlogbɔɔ 'bɩgʋpalɩ, 'ɩn we yia Pilatɩ ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nɩɩ, Zuifʋʋ 'fɛtɩ -ka nyni nɩ, -kaslʋnyɩmɛ -ɔ nyɩmaa -zlo 'yɩbhaa, 'mɔ Pilatɩ tidea 'yi. ");
INSERT INTO kyf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","-Mɔ wee -kaslʋ 'wʋ, nyɩmɛ yabhlo wa laa -Balabasɩ -yɔ ɔ -lima mɩ -mɔ. Ma -yɔ dʋdʋʋ 'wlulapɩlɩnya gʋ bhaa tʋ, 'ɩn wa yia nyɩmɛ 'bha. ");
INSERT INTO kyf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","-Bha wa gbaa Pilatɩ -yla: «-We -na nʋ bhaa 'fɛtɩɩ 'ylɩ nya lɛ, -ɩn nʋ we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatɩ nɛɛ wa -ylaɛ: «Zuifʋʋ 'wlulapɩlɩnyɔ mɩa, 'mɔ ɩn 'kaa 'yitide yɩ?» ");
INSERT INTO kyf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatɩɩ 'dɛ -yi we 'ji nɩɩ, zenyidlɩ nya -Lagɔbʋbɔnyaa -cɩan wlaa -Zezu. ");
INSERT INTO kyf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma zʋlʋa nyɩma ŋwɛ nɩɩ, wa sumanɩ we 'wʋ Pilatɩ 'ka -Balabasɩ -kaslʋ 'wʋsa. ");
INSERT INTO kyf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","-Bha Pilatɩ gbaɛ: «'Lee, Zuifʋʋ 'wlulapɩlɩnyɔ mɩa dɛ nɩ, lɛɛ -lu ɩn 'ka ɔ nʋnʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wa 'kpɩa 'wʋ, wa nɛɛ: «Kʋlʋ ɔ *su -gʋ la!» ");
INSERT INTO kyf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatɩ nɛɛ: «Gbʋnyuu -mʋmʋ ɔ nʋ lɛa?» 'Ɩn wa yia 'wʋkpɩ 'tɩtɛɛ: «Kʋlʋ ɔ su -gʋ la!» ");
INSERT INTO kyf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nɩɩ, Pilatɩ 'yɩbha ɔ 'ka nyɩmaa -zloo dʋmagbʋ lɛnʋ, we 'dɛɛ 'gbʋ ɔ yia -Balabasɩ 'yitide. Tɔʋn, ɔ nɛɛ 'slʋja -yla: «A sɛlɩ -Zezu.» 'Ɩn ɔ yia wa 'yoo 'nyɛ, wa 'ka -Zezu su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Slʋja kwaa -Zezu yoo -mɔ dʋdʋʋ 'wlulapɩlɩnyɔɔ gbʋwʋbhu -buduŋwɛɛ, 'ɩn wa yia wa -lima weee la ");
INSERT INTO kyf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","wa 'ka ɔ nyanɩ. Wa yia ɔ nyɩmaa 'wlulapɩlɩnyɔɔ -bana zalʋ 'wʋpla, 'ɩn wa yia 'wia -kloo ma, 'ɩn wa yia we ɔ 'wluo -pla, ");
INSERT INTO kyf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'ɩn wa yia ɔ fʋsa ɔ glapalɩe nya: «Zuifʋʋ 'wlulapɩlɩnyɔ, -na fʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wa bhɩtɩa ɔ 'wlu gblee nya, -zugba wa slua ɔ -dlɛ -gʋ, 'ɩn wa sibhlia 'kukolu ɔ 'yu, wa tɩa wa 'dɛ 'wʋ 'kienyi. ");
INSERT INTO kyf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Da wa bhɩa ɔ nyanɩe, wa -saa ɔ -bana zalʋ 'wʋ, 'ɩn wa yia ɔ 'dɛɛ -bana ɔ 'wʋpla. 'Ɩn wa -yɔ ɔ yia mnɩ, wa 'ka ɔ su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wa mɩa mnɩda, 'ɩn wa -yɔ Silɛnɩyu 'Simɔɔ yia gbeli, -zugba ɔ bhʋ kpaa. Nɩɩ, Alɛzandlɩ -yɔ Wlufusɩɩ dide -wa. -Bha 'slʋja gbaa ɔ -yla -gla nya nɩɩ, ɔ 'bhu -Zezuu su 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wa yia -Zezu da wa laa Gɔlʋgota kwa. (-Mʋʋ ji -wa 'wluu kʋaa da.) ");
INSERT INTO kyf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wa 'nyɛa ɔ nʋ -we lʋ wa slua *milɩ, ɔ 'nɩ we 'ma. ");
INSERT INTO kyf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tɔʋn, wa yia ɔ su -gʋ lakʋlʋ, 'ɩn wa yia -nɩgbɩ 'pa, -we wa 'kaa 'yɩ -bhlo -bhlo ɔ -bananya glaaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Zlʋkpa ylʋ nya wa kʋlʋa ɔ su -gʋ la. ");
INSERT INTO kyf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","-We ka 'gbʋ wa yia ɔ 'bha, wa cɛlɩa we, 'ɩn wa yia we ɔ 'wlu -bita lakʋlʋ. 'Mʋ wa cɛlɩa: ");
INSERT INTO kyf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wa ka 'ya 'wienya 'sɔ su -gʋ lakʋlʋ. 'Yabhlo mɩ ɔ lilisɔlʋ, 'ɩn -gʋdʋ mɩa ɔ kɔpɛsɔlʋ.  ");
INSERT INTO kyf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɩɩ, sanɛɛ 'sa -Lagɔsɛbhɛɛ bɛta yabhlo gbaa, bɛta -we gbaaɛ: «Wa ka ɔ gbʋnyuuu kwɛ -cɩan glaa zɛlɩ». ");
INSERT INTO kyf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nyɩma mɩa 'plɩda, -zugba wa bite 'wlu, wa vɛlɩa ɔ, wa nɛɛ: «Aya, -mɩ gbaa -ɩn 'ka -Lagɔbudu 'kadʋ -wlɔ, 'ɩn -ɩn 'ka we 'sʋbha 'ylɩ ta zɔ nɩ, ");
INSERT INTO kyf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","-sa -na 'dɛ gbʋ 'wʋ, 'bhʋ su -gʋ -ɩn 'sibhli la.» ");
INSERT INTO kyf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","-Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya klaa, ma gbʋgbalɩ 'yaa -yla ɔ nyanɩe nya, -maa nɛɛ: «Nɩɩ, ɔ ka nyɩma tɔlʋa pue, ɔ 'nɩ -slɛɛn mneni ɔ 'ka ɔ 'dɛ pue! ");
INSERT INTO kyf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ɔmɔ, -Lagɔɔ -Bhasanyɔ, *Izlaɛlɩɩ 'Wlulapɩlɩnyɔ, ɔ -ka su -gʋ 'bhʋ ɔ -ka lasibhli nɩ, -a -ka ɔ -yɔyɩ, 'ɩn -a zʋa ɔ dlɩ -gʋ.» -Wa mɩa su -gʋ ɔ kwesi, -maa ka 'ya ɔ vɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Ylʋ 'ka -glɔnyɩdɩ nynia yi, nikpise yia kpa dʋdʋ weee -gʋ, we li 'lɛlɩ ta. ");
INSERT INTO kyf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","We bhla -bhlokpadɛ, -Zezu 'kpɩa 'wʋ 'tɩtɛɛ, ɔ nɛɛ: «Eloi, Eloi, lama sabakatani?» -Mʋʋ ji -wa: «Na -Lagɔ, na -Lagɔ, lɛɛ -lu ka 'gbʋ -ɩn yi 'mɩ 'bɩ 'bhʋa?» ");
INSERT INTO kyf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nyɩma tɔlʋa -wa mɩa -bha, -wa 'nʋa we, wa nɛɛ: «Aya, ɔ mɩ Elii lada!» ");
INSERT INTO kyf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wa lʋ nyɩmɛ yabhlo -yɔ -gwagwɩe mnɩa, ɔ 'bhua -fuu 'wʋ, ɔ yia we kalɔ nʋ lʋ fa. Ɔ zʋa we gbleee 'yliya 'wʋ, 'ɩn ɔ yia we ɔ ŋwɛ -yɔdɩ, -de -mɔɔ yi we ŋwʋŋwɔnʋʋ, 'ɩn ɔ nɛɛ: «A wʋ -slɔ. -De Elii yi yi, -mɔɔ 'ka ɔ lasibhlii, -a 'ka -bha 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","-Zezu 'kpɩa 'wʋ 'tɩtɛɛ, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","'Naa bɩzɩa -Lagɔbudu 'kadʋ zɔ, mʋ bhlia 'wʋylaylɩe we nyɩdɩ -mɔ yalɩ tɩklɩɩ, 'ɩn we yia zɔ nyni. ");
INSERT INTO kyf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ -ɔ 'yligbea -Zezu 'yu, 'ɩn ɔ yia ɔ 'wʋkpɩwɛlɩ 'nʋ, 'ɩn sa ɔ tɩtlɩa 'wʋla, 'ɩn ɔ yia -bha 'yɩ, ɔ nɛɛ: «Ɔɔ nyɩmɛ mɩa da nɩ, -Lagɔɔ Yu -wa 'piɛɩn.» ");
INSERT INTO kyf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Magɩdala -ŋwnɔ Malii klaa, 'Zake -yulɛ -yɔ Zozee 'nyaa Malii klaa, we -yɔ Salomee, ma mɩa ɔ 'bɩ. Nɩɩ, ma pia -benyi ɔ -yla da wa mɩa Galilee. Wa -yɔ 'ŋwnɩ duun tɔlʋa -yɔ -Zezu ka bha -Zeluzalɛmʋ mnɩ. Wa 'yligbe -mɔ 'pɩpɩ, -zugba wa yla ɔ. ");
INSERT INTO kyf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jibheza ylʋ nya, Alimateyu *-Zɛzɛfʋ yia yi. Ɔ mɩ *Zuifʋʋ gbʋwliwʋdɩnyaa glaa -nyɩmɛ yabhlo, -ɔ wa zʋa -bha nya. Bhla -we nya -Lagɔ 'kaa dʋdʋ 'wlulapɩlɩ, ɔ mɩ we wʋda. We zlɩ mɩa, Zuifʋ mɩ wa -lu lamnazɩda, 'ɩn zlɩ -ka zlɩ, mʋ -wa wa *Nyapɛylɩ. We 'dɛɛ 'gbʋ -Zɛzɛfʋ yia dlɩ 'tɛmanɩ, ɔ yia Pilatɩɩ -gbɛ mnɩ ɔ 'ka -Zezuu 'kwie -mɔɔ -zlalɩ. ");
INSERT INTO kyf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatɩ nɛɛ ɔ dlɩ zɔ: «Aya! Ɔ ka tlɩ -papa -bhlo.» 'Ɩn ɔ yia Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ la, 'ɩn ɔ yia ɔ layɩbha: «'Lee, ɔ tlɩtlɩ bɩ ka 'wʋgwlɛɛ?» ");
INSERT INTO kyf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","-Mɔɔ ŋwnua we -yɔ, 'ɩn ɔ yia -Zɛzɛfʋ ɔ 'kwie yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","-Zɛzɛfʋ zɔa 'naa -zɔnʋ, ɔ -saa -Zezuu 'kwie su -gʋ, ɔ zʋa we 'naa -yɔ, 'ɩn ɔ yia we 'bhʋka 'wʋ fa. Wee 'bhʋka mɩa, wa ka bha we 'bhlu tʋkpa 'wʋ. Tɔʋn, ɔ glipea tʋkpa -boklo, 'ɩn ɔ yia wee gbawla ŋwɛkla. ");
INSERT INTO kyf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Da wa zʋa -Zezuu 'kwie gbawla nʋkplɛ, Magɩdala -ŋwnɔ Malii -yɔ Zozee 'nyaa Malii ka -bha 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nyapɛylɩ 'plɩa, Magɩdala -ŋwnɔ Malii klaa, *'Zakee 'nyaa Malii we -yɔ Salomee, ma zɔa -lasiklɔ, -we ka ŋnɛ mɛnɩa, wa 'ka we -Zezuu 'kwie -yɔtli. ");
INSERT INTO kyf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dimasɩɩ zlʋkpɛ -papa, da 'ylʋ -sɔa 'wʋ, 'ɩn wa yia gbawla -gʋ mnɩ, ");
INSERT INTO kyf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","-zugba wa 'yɩbhalɩa yɩbhalɩa laɛ: «'Lee, tʋkpa 'kadʋ mɩa da gbawla ŋwɛɛ, nyɔɔ 'ka we glipe -aɩn -yla?» ");
INSERT INTO kyf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wa -talɩa -mɔ, 'ɩn wa yia wee tʋkpa -boklo 'kadʋ -yɔyɩ. Nɩɩ, wa ka 'cɩn we glipe. ");
INSERT INTO kyf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wa plaa gbawla nʋkplɛ, ɩn wa yia -mɔ nyimeslɔyu yabhlo 'yɩ. Ɔɔ nyimeslɔyu -dɩlɩ lilisɔlʋ la. Ɔ -bana pɔlʋ. Nyanɔ yia wa dlɩ 'wʋslo. ");
INSERT INTO kyf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɔ nɛɛ wa -yla: «A 'na nʋnʋ nyanɔ -nɩ. Nazalɛtɩyu -Zezu, -ɔ wa kʋlʋa *su -gʋ la, ɔ da a talɩa yɩ? Nɩɩ, ɔ ka 'wʋsɔ tlɩtlɩnya glaa. Ɔ 'nɩ -seli -mɩ. A -talɩ, da wa palɩa ɔ la, -bha nɩ da. ");
INSERT INTO kyf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɩɩ, ɔ ka aɩn 'yugalɩ Galilee. -Mɔ a yia ɔ 'yɩa, saa 'dɛ ɔ gbaa zlɩmɛ aɩn -yla, 'sa. Nɩɩ, a mnɩ, a 'tʋlʋ ɔ 'bɩnɔnya -yɔ Piɛlɩ.» ");
INSERT INTO kyf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","-Bha wa 'tlaa gbawla nʋkplɛ -gwagwɩe nya, -zugba wa tɛlɩa nyanɔ nya. Wa mɩ nyanɔ nʋdaa 'gbʋ, wa 'nɩ nyɩmɛ yabhlogbɔɔ -yla gbʋ gba.  ");
INSERT INTO kyf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","-Zezu -sɔa tlɩtlɩnya glaa 'wʋ dimasɩɩ zlʋkpɛ. Magɩdala -ŋwnɔ Malii, -ɔ 'wʋ ɔ vua zuzu 'nyii gbesɔ, ɔ yia ɔ 'dɛ -mɔɔ 'klʋslolu tɩa. ");
INSERT INTO kyf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","-Wa -yɔ -Zezu 'sɔ mɩa 'cɩn, -bha Malii mnɩa wa -gbɛ. Wa mɩ wida. Ɔ 'tʋlʋa wa nɩɩ, ɔ ka -Zezu 'yɩ, ɔ -ga 'yliyɔ. Wa 'nɩ we la gbʋzɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","-Mʋʋ 'bɩgʋ, -Zezuu 'bɩnɔnyaa glaa -nyɩma 'sɔ mɩa kpaa -yloogblʋ nɔda, 'ɩn ɔ yia ɔ 'dɛ -maa 'klʋslolu sa -putu sa. ");
INSERT INTO kyf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wa 'bhitia lʋ, 'ɩn wa yia wa -lima 'tʋlʋ, -maa 'nɩ 'ya we la gbʋzɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","-Slɛɛn, ɔ 'bɩnɔnya kugbua lɛ -bhlo mɩ lida, 'ɩn -Zezu yia ɔ 'dɛ wa 'klʋslolu. Ɔ nɛɛ wa -ylaɛ: «Nyɩma nɛɛ aɩn -yla nɩɩ, ɩn ka 'wʋsɔ tlɩtlɩnya glaa, 'ɩn wa yia 'mɩ 'yɩ. A 'nɩ we la gbʋzɔnʋ. Lɛɛ ka 'gbʋ a 'nɩ 'mɩ dlɩ -gʋ zʋa? Lɛɛ ka 'gbʋ a su sa yukwli -yɔa?» ");
INSERT INTO kyf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tɔʋn, 'ɩn ɔ nɛɛ wa -yla: «A 'plɩlɩ dʋdʋ weee -gʋ, a 'ka -mɔ -Lagɔgbʋ gba nyɩma weee -yla. ");
INSERT INTO kyf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nyɩmɛ, -ɔ -ka 'mɩ dlɩ -gʋ zʋ, 'ɩn wa -ka ɔ batizee, -Lagɔ yia ɔ gbʋ 'wʋsaa. Nɩɩ nyɩmɛ, -ɔ 'nɩ 'mɩ dlɩ -gʋ zʋ, -Lagɔ yia ɔ gbʋ dɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","-Wa zʋa 'mɩ dlɩ -gʋ, gwɛdigbʋ wa yia lɛnʋa, mʋ nɩ: na 'ŋnɩ nya wa yia zuzu 'nyuu vua. Wɛlɩ -we wa 'nɩa -yi, 'mʋ wa yia gbaa. ");
INSERT INTO kyf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wa yi tɩbhɛ 'wʋbhuoo, wa yi gu 'maoo, gbʋ yabhlogbɔɔ 'na 'ka wa ylɩ. Wa yi nyɩma sɔ -gʋlapalɩoo, 'ɩn -maa pʋa.» ");
INSERT INTO kyf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nyɩmaa -Kanyɔ -Zezu bhɩa gbʋ gbagbɩe, -Lagɔ 'bhua ɔ 'wʋ, ɔ mnɩa yalɩ, 'ɩn ɔ yia -Lagɔɔ lilisɔlʋ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'Ɩn ɔ 'bɩnɔnya yia -Lagɔgbʋ gbaa mnɩ, da weee. 'Ɩn Nyɩmaa -Kanyɔ saa wa 'wʋ wa lubho 'wʋ. Ɔ yia wa 'tɩtɛ 'nyɛ wa 'ka gwɛdigbʋ lɛnʋ. Mʋ yia we -slolua, 'ɩn nyɩma weee 'ka we 'jiyibheli nɩɩ, wa wɛlɩ mɩ gbʋzɔnʋ nya.");
INSERT INTO kyf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilɩ 'kadʋ, -na fʋʋ! -We plɩa -seli -aɩn glaa, nyɩma duun ka we cɛlɩcɛlɩe layla. ");
INSERT INTO kyf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nyɩma, -wa 'yɩa wee gbʋʋ gwedɩlɩda, 'ɩn wa yia -Lagɔwɛlɩɩ gbagbanya -zɛ nɩ, -we wa gbaa -aɩn -yla nɩ, 'mʋ wamɩa cɛlɩa. ");
INSERT INTO kyf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na 'dɛbhie -gbolu, da wee gbʋ dɩlɩa gwe, sa we 'pɩplɩa 'wʋla, 'ɩn ɩn yia we layɩbha. Sa we mɩmnɩa 'wʋla, 'ɩn ɩn yia we yibheli ŋwɛɛ ŋwɛɛ. We 'gbʋ, Teofilɩ, we nanɩ 'mɩ dʋdʋ, 'mʋ ɩn cɛlɩa da 'sɛbhɛ 'wʋ, 'ɩn ɩn yia -mɩ we yoo 'pa. ");
INSERT INTO kyf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ɩn 'nɩ -mɩ 'wʋcɛlɩ bhebhe. -Zezuu wɛlɩ wa -slolua -mɩɩ, sa we -zɛa wɛlɩ -zɔnʋ, -ɩn 'ka we 'jiyibhelii 'gbʋ, ɩn yia -mɩ 'wʋcɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bhla -we nya dʋdʋʋ 'wlulapɩlɩnyɔ *Ewlodʋ pɩlɩ bhaa Zudee -dʋdʋ 'wlu la nɩ, *-Lagɔbʋbɔnyɔ yabhlo, -ɔ mɩ bhaa -bha, 'mɔ wa laa Zakalii. *-Lagɔbʋbɔnyaa zʋa wa laa Abia, -mɔ wa nyɩdɩ ɔ mɩa. Ɔ 'ŋwnɔɔ 'ŋnɩ wa laa Elizabɛtɩ. 'Ɩn ɔ yia -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ *-Awlɔɔɔn zʋayli 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakalii -yɔ Elizabɛtɩ 'sɔɔ nɔnɔbhʋ tɩklɩɩ -Lagɔ 'yliya 'wʋ. 'Ɩn wa zʋa -bha -Lagɔɔ tite sazɔnʋ sa, we -yɔ ɔ wɛlɩ 'dɛ weee 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","-Gblo Elizabɛtɩ -tʋaa 'gbʋ, wa 'nɩ 'yu -ka, 'ɩn wa 'dɛ 'sɔ yia gɔ. ");
INSERT INTO kyf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","'Ylɩ yabhlo nya, 'ɩn Zakaliii nʋ -Lagɔbʋbɔ zʋaa 'ylɩ yia nyni. 'Ɩn Zakalii yia ɔ -Lagɔbʋbɔ -lubho nʋa mnɩ, -mɔ *-Lagɔbudu 'kadʋ zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","-Lagɔbʋbɔnyaa lɛnʋgbʋ 'cɩn 'wʋ, wa -ka gba wa 'ka wa libho dlili nɩ, -nɩgbɩ wa paa. -Mʋʋ zlɩ mɩa, wa 'paa wee -nɩgbɩ nɩ, Zakalii -gʋ we bhlilia, ɔ 'ka -mɔ -Lagɔbudu 'kadʋ zɔ pla, ɔ 'ka -mɔ 'wlɩ -siee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wee 'wlɩɩ -sie bhla nynia nɩ, -zugba -Lagɔɔ nyɩmaa -zlo -dɩ -bha 'pipee la, wa mɩ -Lagɔ bhubhoeda. ");
INSERT INTO kyf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zakalii mɩ -Lagɔ bʋbɔda, Jejitapɛɛ 'anzɩ yabhlo yia ɔ 'klʋtlalɩ. We 'yligbe -bha 'slakagʋsalɩlu, -we -gʋ wa siea 'wlɩnya, we lilisɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Da Zakalii 'yɩa wee 'anzɩ -yɔ, 'pɩɔn sloa ɔ dlɩɩ, 'ɩn -nyanɩgbɔ yia ɔ -kpalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Anzɩ nɛɛ ɔ -ylaɛ: «Zakalii, -ɩn 'na nʋnʋ nyanɔ -nɩ. -Lagɔ ka -na -Lagɔ -bhubhoewɛlɩ 'wʋŋwnu. Nʋkpasuyu -na 'ŋwnɔ Elizabɛtɩ yia gwalɩa -mɩ -yla. Ɔ -ka ɔ gwalɩ, 'ɩn -ɩn 'ka ɔ 'ŋnɩ zʋ *Zaan. ");
INSERT INTO kyf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɔɔ 'yuu 'gbʋ, 'mʋna 'kadʋ yia -mɩ 'wʋ yia. Nyɩma -duun ɔ gwalɩgwalɩe yia 'mʋna 'wʋlaa. ");
INSERT INTO kyf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","-We ka gbʋ -wa nɩ, -bha Jejitapɛ 'yu, nyɩmɛ 'kadʋ ɔ yia -zɛa. Ɔ 'na 'ka -dlɔ zalʋ 'ma, ɔ 'na 'ka nʋ kalo 'ma. Ɔ mɩ -mɔ ɔ 'nyaaa nʋkplɛ nɩ, 'ɩn -Lagɔɔ Zuzu 'Pʋpa 'kaa ɔ ye. ");
INSERT INTO kyf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","*Izlaɛlɩnyɩma -duun ɔ yia Jejitapɛ, -ɔ -wa wa -Lagɔɔ -gbɛ lʋlaa. ");
INSERT INTO kyf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nyɩmaa -Kanyɔɔ 'yugalɩnyɔ ɔ -mɩa, 'ɩn zuzu -yɔ 'tɩtɛ, -we mɩ bhaa *Elii -gʋ nɩ, mʋ yia ɔ -gʋ yia. Ɔ 'ka we lɛnʋ, 'ɩn didea -yɔ 'yua 'sɔ 'ka 'yɩbhalɩ -yɩbhalɩ. 'Bhie, -wa'a zʋa -Lagɔ 'nʋŋwɛ, ɔ 'ka wa nyɩma tɩklɩɩɩ gbʋyilo 'nyɛ. Ɔ 'ka 'sa wa -yɔmnazɩ Nyɩmaa -Kanyɔɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","-Lagɔɔ 'anzɩ gba 'saa, Zakalii nɛɛ: «-Amɩ ka gɔ, 'ɩn na 'ŋwnɔ mɩ ŋwnɔkaa nya, -na wɛlɩ -ɩn gbaa da 'lee, sa we 'ka 'wʋlapɩplɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Anzɩ yia we 'bɩgʋpalɩ, we nɛɛ: «-Amɩ -wa Gablie. -Lagɔ -ɔ 'yu na yligbea, mɔ tiea 'mɩ, nɩɩ, ɩn yi, ɩn 'ka -mɩ -yla wɛlɩ nɩ -yɔ gbʋzɔnʋ -gbʋ nɩ gba. ");
INSERT INTO kyf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wɛlɩ -we ɩn gbaa dɛ -mɩ -yla, -ɩn 'nɩ we dlɩ 'wʋdɩɩ 'gbʋ nɩ, we 'bhʋ -zɛɛn 'wʋ, bhobho -na yia -zɛa, wɛlɩ 'na 'ka -mɩ ŋwɛɛ 'tla. 'Ylɩ -we -Lagɔ 'paa ŋwɛɛ, we -ka nyni 'bhie, 'ɩn -ɩn 'kaa gba.» ");
INSERT INTO kyf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zakalii mɩ -Lagɔbudu 'kadʋ zɔ -gwlɛda kplokploo 'gbʋ, -Lagɔɔ nyɩma -wa mɩa -bha 'pipee ɔ wʋlʋda, ŋwɛgaga ka wa sʋbha. ");
INSERT INTO kyf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nɩɩ, ɔ 'tlaa, ɔ 'nɩ mneni ɔ 'ka wa -yla gba. 'Ɩn nyɩma yia we -yɔyɩ nɩɩ, -lu yabhlo ka ɔ 'klʋ 'tlalɩ -mɔ -Lagɔbudu 'kadʋ zɔ. 'Ɩn -zugba ɔ paa wa -yla sɔ. Ɔ 'nɩ mneni ɔ 'ka gbʋ -gʋsa. ");
INSERT INTO kyf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɔnʋʋ -Lagɔɔ bʋbɔ ylɩ bhɩa nɩ, 'ɩn ɔ yia ɔ -zɔɔ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'Ylɩ 'sɔ -lɛ 'plɩa, 'ɩn Zakaliii 'ŋwnɔ Elizabɛtɩ yia nʋkpla pla. 'Cʋ gbu 'wʋ, -zugba ɔ zize ɔ 'dɛ. 'Ɩn ɔ nɛɛ ɔ 'dɛɛ dlɩ zɔɛ: ");
INSERT INTO kyf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«-Aa! -Lagɔ ka 'mɩ nyazɩ 'yɩlɩ, ɔ ka 'mɩ zʋ 'klʋ -sa nyɩma 'yliya 'wʋ. 'Ɩn ɩn yia gwalɩ ŋwnɔ -zɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛtɩ plaa nʋkpla, ɔ ka 'cʋ gbelibhlo, 'ɩn -Lagɔ yia ɔ 'anzɩ Gablie tie -mɔ Nazalɛtɩ, Galilee -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","-Mɔ 'yieslɔŋwnɔyuu -gbɛ ɔ tiea we. Ɔ 'ŋnɩ wa laa Malii. Ɔ 'nɩ -slɔ nʋkpasu -yi. Nɩɩ, nyɩmɛ yabhlo wa laa *-Zɛzɛfʋ, ɔ bhoyi -wa. Nyɩmaa 'wlulapɩlɩnyɔ *-Davidɩɩ zʋayli -nyɩmɛ yabhlo -wa. ");
INSERT INTO kyf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","-Lagɔɔ 'anzɩ plaa ɔ -gbɛ, 'ɩn we nɛɛ ɔ -ylaɛ: «Malii, a fʋʋ! A li 'mʋna. Ama -Lagɔ 'nyɛa ɔ zʋzɔnʋ, ama na saa fʋ, -Lagɔ -yɔ aɩn 'sɔ mɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malii 'nʋa wɛlɩ -mɩnɩ, we ka ɔ dlɩ sumanɩ. 'Ɩn ɔ yia ɔ 'dɛ layɩbha 'lee: «Fʋ -mʋmʋ we -saa dɛ 'mɩ, sa -mʋʋ 'ji mɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'Anzɩ nɛɛ ɔ -ylaɛ: «Malii, nyanɔ 'na slolu aɩn dlɩɩ -nɩ. -Lagɔ ka ɔ zʋzɔnʋ aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A -talɩ, nʋkpla a yia plaa, a 'ka nʋkpasuyu gwalɩ, 'ɩn a 'ka ɔ 'ŋnɩ zʋ -Zezu. ");
INSERT INTO kyf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nyɩmɛ 'kadʋ ɔ yia -zɛa, 'ɩn wa 'ka ɔ la Yalɩ -Lagɔɔ 'Yu. 'Mɔ Jejitapɛ yia ɔ dʋkpasa -Davidɩɩ 'ŋnɩmnɩkpe 'wʋladɩa, 'ɩn ɔ 'ka nyɩma 'wlulapɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mɔ yia Izlaɛlɩnyɩma weee 'wlulapɩlɩa 'kɔmʋʋ, 'ɩn ɔ nyɩmaa 'wlulapɩlɩe 'nɩ bhloluda -ka.» ");
INSERT INTO kyf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malii nɛɛ 'anzɩ -ylaɛ: «Ɩn 'nɩ nʋkpasu -yi, sa we 'ka 'wʋlanʋnnʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Anzɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Zuzu 'Pʋpa yia aɩn -gʋ yia, 'ɩn Yalɩ -Lagɔɔ 'tɩtɛ yia aɩn -gʋgblia zuzu 'bhisa. We 'gbʋ, ɔɔ 'yu a yia gwalɩa, ɔ mɩ -mɔwlʋda, 'mɔ wa yia laa -Lagɔɔ 'Yu. ");
INSERT INTO kyf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ama zʋayli ŋwnɔ Elizabɛtɩ mɩ nʋkpla, nɩɩ, ɔ ka gɔ. Nʋkpasuyu ɔ yia gwalɩa, -ɔ wa laa zlɩmɛ -gblotʋ ŋwnɔ, ɔ 'cʋ gbelibhlo mɩa da. ");
INSERT INTO kyf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","-We ka gbʋ -wa nɩ, -lu yabhlogbɔɔ 'kaa -Lagɔ sɩalɩ, we 'nɩ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tɔʋn, 'ɩn Malii nɛɛ: «Jejitapɛɛ lubhonʋŋwnɔ ɩn -mɩa. Sa -ɩn gbaa dɛ, we nʋ 'sa na -nʋ nya.» 'Ɩn 'anzɩ yia ɔ kwesi 'bhʋ, 'ɩn we yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wee bhla -bhloo 'dɛ nya, Malii -sɔa 'wʋ -gwagwɩe nya, 'ɩn ɔ yia Zudee -dʋdʋʋ da -gɔgɔ -zuaa 'gbe yabhlo 'wʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ɔ plaa Zakaliii -budu zɔ, 'ɩn ɔ yia Elizabɛtɩ fʋsa. ");
INSERT INTO kyf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Da Elizabɛtɩ 'nʋa Maliii fʋsawɛlɩ nɩ, yu mɩa ɔ nʋkplɛ, 'ɩn ɔ yia lazuklu. 'Ɩn Zuzu 'Pʋpa yia Elizabɛtɩ ye. ");
INSERT INTO kyf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'Ɩn ɔ yia 'wʋkpɩ 'tɩtɛɛ: «Malii! -Lagɔ ka aɩn 'nyulaŋwna, we 'ka 'ŋwnɩ weee -zi. 'Ɩn ɔ ka 'ya 'yu -ɔ mɩa aɩn nʋkplɛ 'nyulaŋwna. ");
INSERT INTO kyf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aya! Nyɔɔ ɩn -mɩa, 'ɩn na -Kanyɔɔ 'nyaa yi na -gbɛ yia? ");
INSERT INTO kyf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nɩɩ, a yɩ -yɔɔ! Ɩn 'nʋa amaa na fʋsawɛlɩ, tɔʋn, 'yu -ɔ mɩa 'mɩ nʋkplɛ, 'ɩn ɔ yia lazuklu 'mʋna 'kadʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gbʋ Jejitapɛ gbaa aɩn -yla, a ka we dlɩ 'wʋdɩ nɩɩ, lɛ we yia nʋaa 'gbʋ, 'wʋtʋtʋe -dlɔɔ mɩ amaa -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elizabɛtɩ gba 'saa, -bha -bhlokpadɛ Malii nɛɛ: «Cɩɩn, Jejitapɛ 'yli, ɔ 'ŋnɩ na yia -mnɩnɩa. ");
INSERT INTO kyf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'Mʋna ka na dlɩ ye, na Gbʋwʋsanyɔ -Lagɔɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","-We ka gbʋ -wa, -Lagɔ ka 'mɩ 'yli -gʋ 'pa, ɔ nyazɩdlɩ nya. -Amɩ, ɔ lubhonʋŋwnɔ, -ɔ 'nɩa -lu yabhlogbɔɔ nya -mɩ. We 'gbʋ, we 'bhʋ -zɛɛn 'wʋ, bhla weee nya, nyɩma yia na daa gbaa: ‹'Ŋwnɔ, -ɔ -Lagɔ ŋwna 'nyu la.› ");
INSERT INTO kyf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","-Lagɔ -ɔ ka 'tɩtɛ pɩlɩa 'tɩtɛ weee 'wlu la, ɔ ka 'mɩ gbʋ 'kadɩ -yla lɛnʋ. Ɔ 'ŋnɩ mɩ -mɔwlʋda. ");
INSERT INTO kyf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nyɩma -wa zʋa ɔ 'nʋŋwɛ, bhla weee nya ɔ yɩlɩa wa nyazɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔ sɔɔ 'tɩtɛ ɔ -slolua, 'ɩn -wa ka dlɩ zɔ, 'dɛɛ 'ylimanɩe mɩa, ɔ yia wa -yɔsɩsalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","-Lagɔ ka dʋdʋʋ 'wlulapɩlɩnya wa 'ŋnɩmnɩkpe -gʋ -sa. 'Ɩn ɔ yia nyɩma -sɛ -sɛ 'bɩ 'kadʋ 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nyɩma -wa 'klɩ mɩa 'bhada, ɔ ka wa -lu -zɔnʋ 'nyɛ duun, 'ɩn ɔ yia 'ŋnɩmnɩnya vu, wa kwɛ klo nya. ");
INSERT INTO kyf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ɔ ka ɔ lubhonʋnyɔ *Izlaɛlɩ -yɔbɛ. 'Ɩn ɔ 'nɩ ɔ nyazɩdlɩɩ lɛnʋgbʋ 'wʋdlʋ, *Ablaamʋ -yɔ ɔ 'yuoyuaa gbɛgbɛɩn, -zʋ weee nya. Sa ɔ gbaa -amɩaa dʋkpasɩ -yla, 'sa ɔ mɩa we nʋda.» ");
INSERT INTO kyf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malii -dɩlɩa Elizabɛtɩɩ -gbɛ la, we li sa 'cʋ ta, 'bhie, ɔ yia ɔ -zɔɔ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bhla -we nya Elizabɛtɩ 'kaa 'wlusa we nynia, 'ɩn ɔ yia nʋkpasuyu gwalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabɛtɩɩ kwesinyɩma -yɔ ɔ zʋayli -nyɩma 'nʋa nɩɩ, Jejitapɛ ka Elizabɛtɩ nyazɩ 'kadʋ 'yɩlɩ, 'ɩn wa -yɔ ɔ 'sɔ yia we 'mʋna li. ");
INSERT INTO kyf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Da 'yu lia lɔkɔwlu -bhlo, wa yia ɔ knɩ 'wʋ 'paa, 'ɩn wa nɛɛ, wa 'ka ɔ dide Zakaliii 'ŋnɩ ɔ zʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Ɩn ɔ 'nyaa nɛɛ: «-Ɩnnya! 'Mɔ wa laa Zaan.» ");
INSERT INTO kyf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wa nɛɛ ɔ -ylaɛ: «'Ŋnɩ -mɩnɩ 'nɩ amaa zʋayli -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Ɩn wa yia ɔ dide layɩbha sɔ nyaɛ: «Sa -ɩn 'ka ɔ 'ŋnɩ zʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalii 'yɩbhalɩa wa -boklo falʋ nɩ, 'ɩn ɔ yia we -gʋ cɛlɩ nɩɩ: «'Yuu ŋnɩ -wa Zaan.» 'Ŋnɩ -we ɔ cɛlɩa, wa 'yɩa we -yɔ nɩ, 'ɩn ŋwɛgaga yia wa 'dɛ weee sʋbha. ");
INSERT INTO kyf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","-Bha -bhlokpadɛ Zakaliii mɩɔ -bloa, 'ɩn ɔ yia gbagbɩe bhli, -zugba ɔ mnɩnɩ -Lagɔɔ 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tɔʋn, nyanɔ yia ɔ kwesinyɩma weee 'wʋslo, -zugba nyɩma weee, -wa mɩa Zudee -gɔgɔ -dʋdʋ -gʋ, gbʋgbalɩ we -yla. ");
INSERT INTO kyf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","-Wa weee 'nʋa wee gbʋ -mɩnɩ, dlɩ zɔ wa dɩlɩa we la, 'ɩn wa yɩbhalɩ -yɩbhalɩa laɛ: «'Ao! Nyɔɔ 'yu -mɔnɩ 'ka cɩ -zɛa?» Nɩɩ, -Lagɔɔ 'tɩtɛ -yɔ ɔ 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zuzu 'Pʋpa yea ɔɔ 'yuu dide Zakalii, 'ɩn ɔ yia gbʋʋ -falɩpapɩe bhli: ");
INSERT INTO kyf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Jejitapɛ, -ɔ -wa Izlaɛlɩnyɩmaa -Lagɔ, -a -mnɩnɩ ɔ 'ŋnɩ. Mɔ bɛa ɔ nyɩma -yɔ, 'ɩn ɔ yia wa gbʋ 'wʋsa. ");
INSERT INTO kyf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nyɩmaa Gbʋwʋsanyɔ 'kadʋ, -ɔ 'bhʋa -Lagɔɔ lubhonʋnyɔ -Davidɩɩ zʋayli, ɔ ka ɔ -aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","-Lagɔ ka 'cɩn we gba ɔ -mɔwlʋ gbʋʋ -falɩpanyaa ŋwɛ nya. ");
INSERT INTO kyf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nɩɩ, mɔ yia -aɩn -amɩaa tʋnyɩma kwɛɛ -saa, 'ɩn ɔ 'ka -aɩn -wa weee nyɛa -aɩn 'wʋ, wa 'tɩtɛ zɔ -sa. ");
INSERT INTO kyf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'Sa -Lagɔ -slolua sa ɔ nyazɩdlɩ -amɩaa dʋkpasɩ 'klʋ. 'Ɩn ɔ ligbea ɔ -yɔ ɔ nyɩma 'sɔɔ -mɔwlʋ *'wʋsuslolugbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","-Lagɔ ka zlɩmɛ -amɩaa dʋkpasa Ablaamʋ -yla bi, nɩɩ, ");
INSERT INTO kyf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","-amɩaa tʋnyɩma kwɛɛ ɔ yia -aɩn -saa, 'ɩn ɔ 'ka -aɩn nyanɔ dlɩɩ -sa, -a 'ka ɔ lubho nʋ, ");
INSERT INTO kyf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","-mɔwlʋwlʋe -yɔ 'wʋtʋtʋe tɩklɩɩ nya ɔ 'yu, bhla -a -gaa 'yliyɔ. ");
INSERT INTO kyf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Ɩn -mɩ, na 'yu, wa yia laa, Yalɩ *-Lagɔgbʋʋ -falɩpanyɔ. Nɩɩ, -mɩ yia Nyɩmaa -Kanyɔ 'yu nɔa, 'ɩn -ɩn 'ka ɔ 'yloogblʋnya -yɔ mnazɩ. ");
INSERT INTO kyf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Ɩn -ɩn 'ka ɔ nyɩma -yla we 'wʋyleli nɩɩ, -Lagɔ -ka wa -yɔgbʋ 'wʋtɩ, mʋ slolua wa 'pʋpʋe. ");
INSERT INTO kyf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","-Amɩaa -Lagɔɔ nyazɩdlɩ 'kadʋʋ 'gbʋ, ɔ yia yalɩɩ san -we -yɔ zlʋkpa ylʋʋ san 'wʋwlʋa, -aɩn -gʋ 'mnia, ");
INSERT INTO kyf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","we 'ka -wa mɩa nikpise 'wʋ ladɩda -yɔ -wa mɩa tlɩtlɩee zuzu 'wʋ ladɩda, glaa layɩ. 'Ɩn we 'ka -aɩn 'wʋtʋtʋe -dlɔɔɔ 'yloogblʋ dasloluu 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Yulɛ mɩ 'ylimanɩda, 'ɩn ɔ 'wlukʋʋn mɩ ladoluda. 'Ɩn ɔ yia da bɛblɛɛ ladɩlɩa mnɩ ɔ 'dɛ -bhlo tɩklɩɩ 'bhie, 'ylɩ -we nya ɔ -slolua ɔ 'dɛ Izlaɛlɩnyɩma 'klʋ, 'ɩn we yia nyni. ");
INSERT INTO kyf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","-Mʋʋ bhla, nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ *Sezaa Ogusɩ palɩa tite yabhlo, nɩɩ, wa zɛlɩ ɔ nyɩma weee, dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bhla -we nya Kiliniusʋ mɩa Siliii -dʋdʋ -gʋ nyɩmaa 'wlulapɩlɩnyɔ nya, we bhla wa zɛlɩa nyɩma tɩanʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nyɩma weee yia wa 'dɛɛ -zɔɔ wa 'ŋnɩ cɛlɩa mnɩ -bhlo -bhlo. ");
INSERT INTO kyf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","*-Zɛzɛfʋ -mɔɔ yi 'yaa Nazalɛtɩgbe 'wʋ 'bhʋ, Galilee -dʋdʋ -gʋ, 'ɩn ɔ yia -Davidɩɩ 'gbe wa laa Bɛtɩlɛmʋ nʋkplɛ mnɩ, Zudee -dʋdʋ -gʋ. -Davidɩɩ zʋayli -yɔ ɔ -budu zɔ -nyɩmɛ ɔ -mɩa, -Davidɩɩ -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɔ -yɔ ɔ bhoyi Malii, -ɔ mɩa 'wlʋwlʋ -nʋkpla 'sɔ, 'ɩn wa yia mnɩ, wa 'ka wa 'ŋnɩ cɛlɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wa mɩ Bɛtɩlɛmʋ, 'bhie, Maliii 'wlusabhla yia nyni. ");
INSERT INTO kyf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Ɩn ɔ yia ɔ 'wʋkpɩalɩ yu gwalɩ, nʋkpasuyu nya. Ɔ bibelia ɔ 'naa -yɔla nɩ, 'ɩn ɔ yia ɔ nɩmaa 'wʋlili -gbo 'wʋ lapɩlɩ. Nɩɩ, wa 'nɩ 'bɩ 'yɩ 'lakpanyaa -budu zɔɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","-Mɔ wee dʋdʋ -bhlokpadɛ -gʋ nɩ, kpaa bhlabhlɛɛ 'yliyɔzʋnya gʋa. Sabɔ, -zugba wa kʋ wa bhlabhlɛɛ -zlo ŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","-Jejitapɛɛ 'anzɩ yabhlo yia wa 'klʋtlalɩ, 'ɩn -Lagɔɔ 'ŋnɩmnɩee san 'kadʋ yia wa gbeli. 'Ɩn -nyanɩgbɔ yia wa -kpalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Anzɩ nɛɛ wa -ylaɛ: «A 'na nyamanɩ -nɩ, nɩɩ, 'dɩzɔnʋ ɩn -laa aɩn. Mʋ yia nyɩma weee 'mʋna 'kadʋ dlɩ zɔ slua. ");
INSERT INTO kyf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","-Zɛɛn sabɔ, wa ka amɩaa Gbʋwʋsanyɔ gwalɩ, -mɔ -Davidɩɩ -zɔɔ. Mɔ -wa -Lagɔɔ -Bhasanyɔ, 'ɩn mɔ -wa Nyɩmaa -Kanyɔ. ");
INSERT INTO kyf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","-Lu -we 'kaa ɔ -slolu, 'bhie, a 'ka ɔ yibheli mʋ nɩ: 'yuyolu yabhlo a yia 'yɩa, 'naa mɩ ɔ -yɔlabibelida, -zugba ɔ pɩ nɩmaa 'wʋlili -gbo 'wʋ la.» ");
INSERT INTO kyf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tɔʋn, yalɩ 'anzɩɩ -zlo yia 'anzɩ -gʋbho, -Lagɔɔ 'ŋnɩmnɩnɩe nya, -zugba we gbaa: ");
INSERT INTO kyf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«-Lagɔɔ 'ŋnɩ 'yli -mɔ yalɩ 'pɩpɩ, 'ɩn nyɩma -wa -Lagɔ 'yɩbhaa, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Da -Lagɔɔ 'anzɩnya 'bhʋa wa kwesi, 'ɩn we 'dɛ weee yia yalɩ mnɩ nɩ, -bha bhlabhlɛɛ 'yliyɔzʋnya zʋzlʋa 'dɩ, wa nɛɛ: «-A mnɩ Bɛtɩlɛmʋ, gbʋ -we nʋa -mɔ lɛ, Jejitapɛ -slolua -aɩn 'klʋ, -a 'ka we 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wa -sɔa 'wʋ -gwagwɩe nya, 'ɩn wa yia -mɔ mnɩ. 'Ɩn wa yia -mɔ Malii -yɔ -Zɛzɛfʋ ylɩ. 'Yuyolu pɩ nɩmaa 'wʋlili -gbo 'wʋ la, 'ɩn wa yia ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Da wa 'yɩa ɔɔ 'yuyolu nɩ, -we 'anzɩ gbaa wa -yla ɔɔ 'yuu daa, 'ɩn wa yia we 'dɩsasɩe bhli nyɩma tɔlʋa -yla. ");
INSERT INTO kyf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Gbʋ -we bhlabhlɛɛ 'yliyɔzʋnya gbaa, -wa weee 'nʋa we, ŋwɛgaga sʋbhaa wa. ");
INSERT INTO kyf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gbʋ weee 'plɩa, Malii yia we dlɩ zɔ ladɩlɩ. Ɔ -ka ladɩ, -zugba ɔ pʋpalɩ we -gʋ 'wlukʋʋn la. ");
INSERT INTO kyf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","-Mʋʋ 'bɩgʋ, 'ɩn bhlabhlɛɛ 'yliyɔzʋnya yia lʋmnɩ, -Lagɔɔ 'ŋnɩ ylimanɩe -yɔ ɔ 'ŋnɩ mnɩnɩe nya. -We wa 'nʋa klaa, 'ɩn wa 'yɩa -yɔ klaa, nɩɩ, sa 'anzɩ gbaa we wa -yla, 'sa we nʋa. ");
INSERT INTO kyf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","'Yuu lɔkɔwlu -bhlo nynia, 'ɩn wa yia ɔ knɩ 'wʋpa. 'Ɩn wa yia ɔ 'ŋnɩ zʋ -Zezu. Wa 'nɩ -slɔ ɔ nʋkpla pla, 'ŋnɩ -we 'anzɩ gbaa ɔ 'nyaa -yla nɩ, 'mʋ wa zʋa ɔ. ");
INSERT INTO kyf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","'Ɩn da Maliii -yɔwɔlʋ ylɩ nynia, sa we mɩa cɛlɩda *Moizɩɩ tite 'wʋ, 'sa -Zɛzɛfʋ -yɔ Malii kwaa 'yu *-Zeluzalɛmʋ, wa 'ka ɔ Jejitapɛ 'klʋslolu. ");
INSERT INTO kyf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nɩɩ, we mɩ cɛlɩda Jejitapɛɛ tite 'wʋɛ: «'Wʋkpɩalɩ nʋkpasuyu wa yia -bha -saa Jejitapɛɛ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wee tite -bhlokpadɛ gbaa wa bʋbɔ -Lagɔ, -de gbele sɔɔ, -de -kpakʋn yua sɔɔ, we nya, 'ɩn Malii -yɔ -Zɛzɛfʋ -yɔ we yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nɩɩ, nyɩmɛ yabhlo mɩ bhaa -Zeluzalɛmʋ, 'mɔ wa laa 'Simeɔɔ. Nyɩmɛ tɩklɩɩ -wa, 'ɩn ɔ zʋa -Lagɔ 'nʋŋwɛ, 'ɩn ɔ mɩa *Izlaɛlɩɩ Gbʋwʋsanyɔ wʋda. Zuzu 'Pʋpa mɩ ɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","-Mɔɔ nɛɛ ɔ -yla 'cɩɛn, nɩɩ, -Lagɔɔ -Bhasanyɔ ɔ yia yoo 'paa, ɔ 'nɩ -slɔ -mɔɔ 'yɩ, ɔ 'na 'ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","-Lagɔɔ Zuzu 'bhua 'Simeɔɔ 'wʋ, 'ɩn ɔ yia -Lagɔbudu 'kadʋ zɔ mnɩ. We bhla, -Zezuu didea ka wa 'yu -Lagɔbudu 'kadʋ zɔ kwa. 'Ɩn -we Jejitapɛɛ tite gbaa, wa 'ka we lɛnʋ ɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Simeɔɔ 'bhua 'yu 'wʋ, ɔ 'paa -Lagɔ fuo, 'ɩn ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Jejitapɛ, -we -ɩn gbaa, we ka lɛnʋ. -Slɛɛn -ɩn mneni -ɩn 'ka -na lubhonʋnyɔ 'yitide, ɔ 'ka tlɩ -dlɔɔ. ");
INSERT INTO kyf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nɩɩ, *nyɩmaa Gbʋwʋsanyɔ -ɩn 'paa yoo, ɩn ka ɔ 'yɩ na 'yli 'sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nɩɩ, nyɩmɛ -ɔ -ɩn nʋa lɛ, nyɩmaa Gbʋwʋsanyɔ nya, nyɩma weee 'yu, ɩn ka ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mɔ -wa, zlɩ -we 'kaa dʋdʋgʋ -nyɩma weee nikpise 'wʋsa. Izlaɛlɩnyɩma -ɩn -saa -bha, wa 'ŋnɩ 'ka mnɩ ɔ 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Gbʋ 'Simeɔɔ mɩa gbada -Zezuu daa, we ka ɔ 'nyaa -yɔ ɔ dide 'sɔ ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Simeɔɔ ŋwnaa wa 'nyu la, 'ɩn ɔ nɛɛ -Zezuu 'nyaa Malii -ylaɛ: «A -talɩ, 'yu -mɔnɩɩ 'gbʋ, nyɩma -duun yia bhlia, 'ɩn nyɩma -duun yia 'wʋsɔa *Izlaɛlɩ -dʋdʋ -gʋ. Mɔ yia -Lagɔ -slolua, 'ɩn nyɩma tɔlʋa 'na 'ka ɔ gbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Ɩn nyɩma duuun dlɩ zɔ lapʋpalɩgbʋnya mɩa, wa dlɩ zɔ zizeda, sanɛɛ ɔ yia we zlɩ 'klʋ wlelia bɛblɛɛ. 'Ɩn ama, Malii, gbʋ -we yia aɩn ylɩa, -yɔ we yia aɩn 'cɔnɔa, nɛɛ 'yli 'sɔ tʋgʋgblɛ wa fa amaa dibhe 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","We bhla, Fanuɛlɩɩ 'yu Anɩ, -ɔ -wa -Lagɔgbʋʋ -falɩpaŋwnɔ, Asɛlɩɩ zʋayli, -mɔɔ mɩ 'ya wee -Lagɔbudu 'kadʋ zɔ, -zugba ɔ ka gɔ. Ɔ -dɔgbʋ bhla, ɔ -kʋa ylɩ, we li -zʋ gbesɔ, 'ɩn ɔ 'lowli yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɔ ka -zʋʋ glʋ -mnʋa -zʋ -mnʋa, 'ɩn -zugba ɔ mɩ -dʋgbaŋwnɔ nya. Ɔ mɩ -Lagɔbudu 'kadʋ zɔ 'kɔmʋʋ, 'ɩn ɔ nʋa -mɔ -Lagɔɔ lubho zlʋkpɛ, jibheza, -zugba ɔ pla 'sun, 'ɩn ɔ bhubhoe -Lagɔ. ");
INSERT INTO kyf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Da 'Simeɔɔ mɩa Malii -yɔ -Zɛzɛfʋ 'sɔ -yla gbʋ gbada, we bhla Anɩ plaa -Lagɔbudu 'kadʋ zɔ, ɔ 'yɩa -Zezu nɩ, 'ɩn ɔ yia -Lagɔɔ 'ŋnɩ mnɩnɩe bhli. 'Ɩn -zugba nyɩma weee -wa mɩa -Zeluzalɛmʋʋ 'wʋzɩtɩylɩ wʋda, ɔ gba -maa -yla -Zezuu gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gbʋ -we Jejitapɛɛ tite gbaa, -Zezuu nyɩma bhɩa we lɛnʋe, 'ɩn wa yia wa 'gbe nʋkplɛ lʋbhiti, Nazalɛtɩ, Galilee -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wa mɩ -mɔ, -zugba 'yu ylimanɩ, ɔ tɛmanɩ la. 'Ɩn gbʋyilo yia ɔ ye, 'ɩn -Lagɔɔ 'nanɩ yia ɔ nya -tʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","-Zʋ weee nya, -Zezuu 'nyaa -yɔ ɔ dide mnɩa *Zuifʋʋ *'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -Zeluzalɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","-Zʋ yabhlo nya, da -Zezu 'yɩa -zʋ kugbua lɛ 'sɔ, sa wa mnɩa 'cɩn 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ nɩ, 'ɩn ɔ -yɔ ɔ nyɩma 'sɔ yi 'saa -mɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'Fɛtɩ bhɩa, wa mɩ Nazalɛtɩ lʋyida, 'ɩn wa 'yu -Zezu yia -Zeluzalɛmʋ -tʋ. Ɔ didea 'nɩ we 'jiyibheli. ");
INSERT INTO kyf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wamɩa dlɩɩ nɩɩ, -Zezu mɩ wa nɔnɔnya glaa. Wa nɔa 'ylɩ -bhlo, 'ɩn wa yia ɔ datalɩe bhli wa nyɩma -yɔ wa 'talea nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nɩɩ, wa 'nɩ ɔ 'yɩda -mɩɩ 'gbʋ, 'ɩn wa yia -Zeluzalɛmʋ lʋbhiti, wa 'ka -mɔ ɔ datalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","We 'ylɩ tanʋʋ zlɩ, 'ɩn wa yia ɔ 'yɩ -Lagɔbudu 'kadʋ zɔ. -Zugba ɔ -dɩ titee gwesanya nyɩdɩ la, ɔ pʋlʋ wa yukwli, 'ɩn ɔ yɩbha wa gbʋnya la. ");
INSERT INTO kyf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nyɩma -wa pʋlʋa ɔ wɛlɩ yukwli ŋwɛgaga ka wa sʋbha, ɔ 'ylimnee -yɔ ɔ gbʋʋ 'bɩgʋpalɩee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Da ɔ nyɩma 'yɩa ɔ nɩ, 'ɩn ŋwɛgaga yia wa sʋbha. 'Ɩn ɔ 'nyaa nɛɛ ɔ -ylaɛ: «Na 'yu, lɛ ka 'gbʋ -ɩn yi 'sa -aɩn -yla nʋa? -Ɩn -talɩ, ɩn -yɔ -na dide mɩa -na datalɩda, -amɩaa dlɩ ka sumanɩ bhabha.» ");
INSERT INTO kyf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Ɩn ɔ yia we 'bɩgʋpalɩ wa -ylaɛ: «Lɛɛ ka 'gbʋ a nɔnʋ 'mɩ 'ylibɩla? A 'nɩ we 'ji -yi nɩɩ, na Didee -budu zɔ ɩn 'kaa -mɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nɩɩ, ɔ nyɩma 'nɩ gbʋ -we ɔ gbaa wa -yla 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","-Zezu -yɔ ɔ nyɩma 'sɔ yia Nazalɛtɩ lʋbhiti, 'ɩn ɔ yia wa 'nʋŋwɛ zʋ. 'Ɩn ɔ 'nyaa yia gbʋnya -mɩnɩ dlɩ zɔ lazʋ. ");
INSERT INTO kyf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","-Zezu mɩ 'ylimanɩda, -zugba ɔ gbʋyilo ylimanɩ -gʋwʋla, 'ɩn ɔ namanɩ -Lagɔ -yɔ nyɩma dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Nɩɩ, Tibɛɛ Sezaaa nyɩmaa 'wlulapɩlɩee -zʋ kugbua lɛ gbunʋ nya nɩ, we bhla, Pɔnsɩ Pilatɩ mɩ dʋdʋʋ 'wlulapɩlɩnyɔ nya Zudee. Ewlodʋ mɩ nyɩmaa 'wlulapɩlɩnyɔ nya Galilee, 'ɩn ɔ bheli Filipʋ mɩa Itulee -yɔ Tlakonitɩ -dʋdʋ -gʋ, -zugba Lizaniasɩ -mɔɔ mɩ Abilɛnɩ -nyɩmaa 'wlulapɩlɩnyɔ nya. 'Ɩn Anasɩ -yɔ Kaifʋ 'sɔ mɩ *-Lagɔbʋbɔnyaa -cɩan 'kadɩ nya. We bhla, Zakaliii 'yu *Zaan -ɔ dɩlɩa da bɛblɛɛ la, 'ɩn -Lagɔ yia ɔ -yla gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'Ɩn Zaan yia Zudɛɛn gbʋa dʋdʋ weee -gʋ 'plɩlɩe bhli, -zugba ɔ gba nyɩma -ylaɛ: «A 'bhiti dlɩ, a yi ɩn 'ka aɩn batizee, 'ɩn -Lagɔ 'ka amɩaa -yɔgbʋ 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa *-Lagɔgbʋʋ -falɩpanyɔ *Ezaii cɛlɩa ɔ 'sɛbhɛ nʋkplɛ, 'sa we nʋa. Ɔ nɛɛ: «Nyɩmɛ yabhlo kpɩa 'wʋ da bɛblɛɛ, ɔ nɛɛ: ‹Nɩɩ, a mnazɩ Nyɩmaa -Kanyɔɔ 'yloogblʋ -yɔ, a nʋ ɔ 'yu 'yoo tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'Gbiwlu weee yia klaa, -gɔgɔ weee -yɔ 'kpida weee yia sloa. 'Yloogblʋ 'wʋkanɔdanya yia 'wʋslamanɩa, 'ylinyuno -yloogblʋnyaa -gʋ yia 'wʋmnenia ylɔɔylɔɔ. ");
INSERT INTO kyf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Ɩn *Nyɩmaa Gbʋwʋsanyɔ -Lagɔ 'paa yoo, dʋdʋgʋ -nyɩma weee yia ɔ 'yɩa.› » ");
INSERT INTO kyf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nyɩmaa -zlo mɩ Zaaan -gbɛ yida, ɔ 'ka wa batizee, 'ɩn ɔ nɛɛ wa -ylaɛ: «Tɩbhɛ -gnʋ! -Dawlicɩan! -Lagɔɔ gbʋwʋbhuylɩ ka cɩpa. Nyɔɔ -salɩ aɩn 'dɩ, 'ɩn a pʋpalɩ 'wlukʋʋn la nɩɩ, a mneni a 'ka -Lagɔɔ 'cɛ -we mɩa yida kwɛɛ 'tlaa? ");
INSERT INTO kyf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","A 'bhiti amɩaa dlɩ, 'ɩn a -slolu we amɩaa lɛnʋgbʋnya 'wʋ sazɔnʋ sa. A 'na gbalɩ amɩaa 'dɛɛ dlɩ zɔ -nɩɛ: ‹Nɩɩ, Ablaamʋ mɩ -amɩaa dʋkpasa nyaa 'gbʋ, -a ka gbʋwʋbhʋ -nɩ›. Nɩɩ, ɩn nɛɛ aɩn -ylaɛ, -Lagɔ mneni, ɔ 'ka tʋkpanya nɩ Ablaamʋʋ 'yua -zɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","-Lagɔɔ 'nɛnɔ gbee 'yli -dɩ sunyaa bhʋ -yɔ la pepe. Su weee -we'e 'paa 'bhue -zɔnʋnya nɩ, -dɩa ɔ yia we, ɔ 'ka we -kosu 'wʋ viteli.» ");
INSERT INTO kyf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tɔʋn, 'ɩn waa nyɩmaa -zlo yia Zaan layɩbhaɛ: «Sa -a 'ka -ylɛɛ nʋ ya?» ");
INSERT INTO kyf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zaan yia we 'bɩgʋpalɩ wa -ylaɛ: «-Ɔ -ka -bana 'sɔ -ka, ɔ 'nyɛ 'yabhlo nyɩmɛ -ɔ 'nɩa -bana -ka. 'Ɩn -ɔ -ka lililu duun -ka, ɔ dlili we.» ");
INSERT INTO kyf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Nisʋn -gwɛzisanya tɔlʋa yia Zaaan -gbɛ, ɔ 'ka wa batizee. 'Ɩn wa yia Zaan layɩbhaɛ: «-Amɩaa -kanyɔ, sa -a 'ka nʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Ɩn Zaan yia we 'bɩgʋpalɩ wa -ylaɛ: «'Gwɛzi -we a 'kaa -sa, amɩaa 'dɛ -yi we, a 'na palɩ we -gʋ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Ɩn 'slʋja yia ɔ layɩbha 'yaɛ: «Sa -amɩa 'ka nʋa?» Ɔ nɛɛ wa -ylaɛ: «A 'na -salɩ nyɩma 'gwɛzi kwɛɛ -gla nya -nɩ, a 'na lili wa -bi 'wʋ -nɩ. Amɩaa 'pɛnɩgwɛzi namanɩ aɩn dʋdʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nyɩma, -wa mɩa wʋda, maa yɩbhaa -maa 'dɛ la dlɩ zɔ, «Zaan mɩa dɛ, -Lagɔɔ -Bhasanyɔ 'kaa yi, -de mɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nɩɩ, Zaan nɛɛ wa 'dɛ weee -ylaɛ: «-Amɩ, 'nyu nya na batizea aɩn. Nɩɩ, -ɔ mɩa yida, ɔ 'tɩtɛ -zi na -nʋ. Ɩn 'nɩ we 'klʋ -ka, ɩn 'ka ɔ -sakwlaa 'llukpe -blo. Mɔ yia aɩn batizea Zuzu 'Pʋpa -yɔ -kosu nya. ");
INSERT INTO kyf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔ ka ɔ bʋtɛ kwɛɛ, ɔ 'ka ɔ 'mnɔ 'wʋpʋ, 'ɩn, ɔ 'ka we 'ya -yɔ we vavi -yɔsɩsalɩ. 'Ɩn ɔ 'ka we 'ya -zɔnʋnya -gbagbʋ 'wʋ slu, 'bhie, ɔ 'ka we vavinya -kosu we'e nyumoa 'wʋ viteli.» ");
INSERT INTO kyf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zaan mɩ nyɩma 'dɩ duun zʋda, -zugba ɔ gba wa -yla -Lagɔwɛlɩ -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nɩɩ, we bhla Zaan palɩa dʋdʋʋ 'wlulapɩlɩnyɔ Ewlodʋ -yla gbʋ la, ɔ bhelii 'ŋwnɔ Ewlodiadɩ ɔ -saa -mɔɔ -glo, 'ɩn ɔ yia ɔ kwa, we -yɔ gbʋnyuu -duun ɔ nʋa lɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nɩɩ, 'ɩn Ewlodʋ yi 'yaa gbʋnyuu yabhlo lɛnʋ -tapa: ɔ ka Zaan -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Da wa 'nɩa -slɔ Zaan -kaslʋ 'wʋpa, we bhla ɔ batizea nyɩma duun -yɔ -Zezuu 'dɛbhie -gbolu. Ɔ batizee bhla, -Zezu mɩ -Lagɔ bhubhoeda, 'ɩn yalɩ yia ŋwɛ -kalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'Ɩn Zuzu 'Pʋpa yia ɔ -gʋ lasibhli, ɔ 'wlʋ sa -kpakʋn. 'Ɩn wa yia wɛlɩ yabhlo 'bhʋa -Lagɔɔ -gbɛ 'nʋ, we nɛɛ: «Na 'Yu -ɩn -mɩa, ɩn -kalɩ -na zɛ. -Mɩ ɩn 'nyɛa na dlɩ weee yoo.» ");
INSERT INTO kyf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","-Zezu ka sa -zʋ glʋ -bhlo -zʋ kugbua, 'bhie, ɔ yia ɔ lubhoo nʋnʋe gwedɩ. Ɔ dʋkpasɩɩ ŋnɩ nɩ: ");
INSERT INTO kyf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zuzu 'Pʋpa yea -Zezu tɔʋn, 'ɩn ɔ yia Zudɛɛɛn -gɔgɔ -gʋ 'bhʋ, 'ɩn ɔɔ Zuzu 'Pʋpa yia ɔ da bɛblɛɛ kwa. ");
INSERT INTO kyf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Ɩn *'Kuzu yia -mɔ ɔ layla, 'ylɩ glʋ 'sɔ nʋkplɛ. Wee 'ylɩnya -mɩnɩ nya, ɔ 'nɩ -lu yabhlogbɔɔ li. Wee 'ylɩnya 'plɩa, 'ɩn ŋwɔ yia ɔ -yɔkpa. ");
INSERT INTO kyf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Kuzu nɛɛ ɔ -ylaɛ: «-Ɩn -ka -Lagɔɔ 'Yu nya -mɩ 'piɛɩn, -ɩn gba tʋkpa mɩa nɩ -yla, we -zɛ 'floo.» ");
INSERT INTO kyf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'Ɩn -Zezu yia we 'bɩgʋpalɩ we -ylaɛ: «We mɩ cɛlɩda *-Lagɔsɛbhɛ 'wʋɛ: ‹We 'nɩ lililu -bhlogbɔɔ -gʋ nyɩmɛɛ 'yliyɔgagɩe tlili.› » ");
INSERT INTO kyf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Kuzu yia -Zezu 'wʋpa -gɔgɔ 'kadʋ 'wlu kwa, -bha -bhlokpadɛ we -slolua ɔ dʋdʋʋ 'ŋnɩmnɩ -da weee 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","'Ɩn we nɛɛ ɔ -ylaɛ: «'Tɩtɛ weee nɩ klaa, 'ɩn dʋdʋ -gʋʋ 'ŋnɩmnɩe weee klaa, ɩn 'ka -mɩ we 'nyɛ. Wa ka 'mɩ we 'dɛ weee yoo 'nyɛ. Nyɩmɛ -ɔ ɩn -ka 'yɩbha, 'mɔ ɩn mnenia ɩn 'ka we 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","-Ɩn -ka 'mɩ 'yu 'kukolu 'sibhli, -ɩn -ka 'mɩ bʋbɔ nɩ, 'ɩn we 'dɛ weee zɛa -na -nʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Ɩn -Zezu yia we 'bɩgʋpalɩ we -ylaɛ: «We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-Ɩn bʋbɔ Jejitapɛ, -ɔ -wa -na -Lagɔ, 'ɩn -ɩn nʋ ɔ 'dɛbhlogbɔɔ -yla lubho.› » ");
INSERT INTO kyf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Kuzu yia -Zezu -Zeluzalɛmʋ kwa. We dɩa ɔ -Lagɔbudu 'kadʋ 'wlu la, 'ɩn we nɛɛ ɔ -ylaɛ: «-Ɩn -ka -Lagɔɔ 'Yu nya -mɩ 'piɛɩn, -ɩn -blu 'wʋ, -ɩn 'ka lasibhli. ");
INSERT INTO kyf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-Na 'gbʋ, gbaa ɔ yia ɔ 'anzɩnya -yla we zʋ -mɩ 'yliyɔ. ");
INSERT INTO kyf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","'Ɩn we 'ka we sɔnya -mɩ zɔ laslʋlʋ, -na bhʋ yi tʋkpa gozoo 'gbʋ.› » ");
INSERT INTO kyf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Ɩn -Zezu yia we 'bɩgʋpalɩ 'Kuzu -ylaɛ: «-Lagɔsɛbhɛ nɛɛ, ‹Jejitapɛ -ɔ -wa -na -Lagɔ, -ɩn 'na ylalɩ ɔ la -nɩ.› » ");
INSERT INTO kyf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'Kuzu bhɩa -Zezuu laylaylɩe sɔ weee lʋ nɩ, 'ɩn we yia ɔ gwevla -sɛ. ");
INSERT INTO kyf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","-Lagɔɔ Zuzuu 'tɩtɛ mɩ -Zezu yeda, 'ɩn ɔ yia Galilee lʋyi. 'Ɩn ɔ 'ŋnɩ yia lamneni Galilee -dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nyɩma ɔ slolua *-Lagɔbudunya zɔ, 'ɩn nyɩma weee kwalɩa ɔ 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","-Zezu ka Nazalɛtɩ mnɩ, -mɔ wa zʋa ɔ. *Nyapɛylɩ nya nɩ, sa ɔ plaa 'cɩn -Lagɔbudu zɔ nɩ, 'ɩn ɔ yi 'saa -mɔ pla. Ɔ yia 'wʋsɔ -Lagɔsɛbhɛɛ zɛlɩzɛlɩee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Ɩn wa yia ɔ -Lagɔgbʋʋ -falɩpanyɔ Ezaiii 'sɛbhɛ yoo 'nyɛ glɩda, ɔ yia we 'wʋkalɩ, da wɛlɩ nɩ mɩa cɛlɩda nɩ, 'ɩn ɔ yia we 'yɩ, 'ɩn ɔ yia we zɛlɩɛ: ");
INSERT INTO kyf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Jejitapɛɛ Zuzu mɩ 'mɩ -gʋ. Ɔ ka -bha 'mɩ -sa, ɩn 'ka nyazɩnya -yla -Lagɔgbʋ gba. Ɔ ka 'mɩ tie, ɩn 'ka -kaslʋnyɩma -yla gba nɩɩ: ‹Amɩaa -kaslʋ ka -zɛɛn bhɩa.› ‹Lɔlɔnya, amɩaa 'yli ka -zɛɛn -blo.› ‹Amɩa wa nyɛa 'wʋ, a ka -zɛɛn gbʋ 'wʋbhʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Ɩn, -zʋ -we nya Jejitapɛ 'kaa ɔ zʋzɔnʋ lɛnʋ, ɩn 'ka we 'dɩ wa -salɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","-Zezu glɩa wee 'sɛbhɛ, 'ɩn ɔ yia we -Lagɔbudu zɔɔ lubhonʋnyɔ yoo 'nyɛ, 'ɩn ɔ yia ladɩ. Nyɩma weee -wa mɩa -bha, -maa yia ɔ ylada -tʋ sa tenyii. ");
INSERT INTO kyf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tɔʋn, 'ɩn ɔ nɛɛ wa -ylaɛ: «-We 'sɛbhɛɛ 'ya gbaa, we ka -zɛɛn lɛnʋ, amɩa pʋlʋa da 'mɩ yukwli, amɩaa 'yibadɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","-We wa 'dɛ weee yɩa -yɔ -Zezuu gbɛgbɛɩn, 'ɩn wa yia we gbagbɩe bhli. 'Ɩn gbʋzɔnʋ -gbʋnya ɔ mɩa gbada, we ka wa ŋwɛgaga -sʋbhalɩ. 'Ɩn wa nɛɛ: «Nyɩmɛ mɩa dɛ, ɔ 'nɩ -Zɛzɛfʋʋ yuu?» ");
INSERT INTO kyf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","-Zezu nɛɛ wa -ylaɛ: «Nine 'nɩ a yia 'mɩ -yla 'paa, gbʋzɔnʋ sa. Gbaa a yia: ‹-Dɔtlɔɔ, -ɩn jipe -na 'dɛ.› 'Ɩn gbaa a yi 'yaa 'mɩ -ylaɛ: ‹-We weee -ɩn nʋa lɛ Kapɛnaumʋ nɩ, -a ka we 'dɩ 'nʋ. -Ɩn nʋ wee gbʋnya -bhloo 'dɛ lɛ -na 'dɛɛ dʋdʋ -gʋ -seli.› » ");
INSERT INTO kyf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","-Zezu nɛɛ wa -yla 'yaɛ: «Cɩɩn, gbʋzɔnʋ -wa, wa'a -tɔlʋ -Lagɔgbʋʋ -falɩpanyɔ nyɩmɛ, ɔ 'dɛɛ dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gbʋzɔnʋ na gbaa da aɩn -yla. -Dʋgbaŋwnɩ duun mɩ Izlaɛlɩ -dʋdʋ -gʋ zlɩmɛ, -Lagɔgbʋʋ -falɩpanyɔ Eliii bhla. -Zugba 'nyu'u lʋa -zʋ ta 'cʋ gbelibhlo, 'ɩn ŋwɔ 'kadʋ yabhlo yia wee dʋdʋ weee -gʋ yi. ");
INSERT INTO kyf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'Ɩn -mʋʋ bhla, -Lagɔ 'nɩ Elii tie -dʋgbaŋwnɩ mɩa Izlaɛlɩ -dʋdʋ -gʋʋ -gbɛ, 'ɩn ɔ 'ka wa 'yabhlo 'wʋsa. Nɩɩ, -dʋgbaŋwnɔ -ɔ mɩa Salɛpʋtagbe nʋkplɛ, Sidɔɔn -dʋdʋ -gʋ, ɔ -gbɛ -Lagɔ tiea Elii. ");
INSERT INTO kyf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","-Lagɔgbʋʋ -falɩpanyɔ Elizeee bhla, -zugba *sɔlɩbhanya duun mɩ Izlaɛlɩ -dʋdʋ -gʋ. Elizee 'nɩ wa 'yabhlogbɔɔ jipe, nɩɩ, Silii -yu Naamaa ɔ jipea.» ");
INSERT INTO kyf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nyɩma weee -wa mɩa -Lagɔbudu zɔ, wa 'nʋa wee wɛlɩnya -mɩnɩ, 'ɩn we yia wa 'cɛdlɔ la. ");
INSERT INTO kyf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wa 'dɛ weee -sɔa 'wʋ, 'ɩn wa -yɔ -Zezuu 'susue yia 'gbe -glima mnɩ. 'Ɩn -gɔgɔ -we kwesi wa 'gbe mɩa 'sʋbhada, 'ɩn wa yia we 'wlu ɔ kwa, wa 'ka ɔ zɔ vitelii 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nɩɩ, 'ɩn -Zezu yia wa nyɩdɩ 'plɩlɩ, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tɔʋn, -Zezu mnɩa Kapɛnaumʋ, Galilee -dʋdʋʋ 'gbe yabhlo nʋkplɛ, 'ɩn ɔ yia nyɩma -Lagɔgbʋ -slolu Nyapɛylɩ weee nya, -Lagɔbudu zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɔ nyɩma -slolu sɔ ka wa ŋwɛgaga -sʋbhalɩ. Nɩɩ, se -we -Lagɔ 'nyɛa -Zezu, we nya ɔ gbaa. ");
INSERT INTO kyf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","-Mɔ -Lagɔbudu zɔ, nyɩmɛ yabhlo kaa pʋɩn -ka -zuzu 'nyuu 'bɩ, mɔ 'kpɩa 'wʋ 'tɩtɛɛ, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«'Aaa! Nazalɛtɩyu -Zezu, -naa lɛɛ -gbʋ pɩlɩ -amɩaa gbʋ 'wʋ la? -Amɩaa lasasɩee 'gbʋ -ɩn yia yi yɩ? Ɩn -yi -mɩ ŋwɛɛ ŋwɛɛ: -Lagɔɔ -Mɔwlʋnyɔ ɔ tiea, 'mɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","-Zezu yia we, we ŋwɛɛ labhalɩ -gla nya. Ɔ nɛɛ we -ylaɛ: «'Mu ŋwɛ, 'bhʋ ɔ 'wʋ!» Zuzu 'nyuu yia ɔɔ nʋkpasu labhlɩ dʋdʋ, nyɩma weee -zejila 'wʋ, 'ɩn we yia ɔ 'wʋtla, we 'nɩ ɔ gbʋnyuu yabhlogbɔɔ -yla lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ŋwɛgaga yia wa 'dɛ weee sʋbha, 'ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «Mɔɔ -wɛlɩ mʋ dɛa? Se -yɔ 'tɩtɛ nya ɔɔ nyɩmɛ gbaa zuzu 'nyii -yla gbʋ, 'ɩn we tlaa nyɩma 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Ɩn -Zezuu 'ŋnɩ yia lamneni wee dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","-Zezu 'bhʋa -Lagɔbudu zɔ nɩ, 'ɩn ɔ yia 'Simɔɔɔ -budu zɔ mnɩ. -Zugba 'Simɔɔɔ 'ŋwnɔɔ 'nyaaa ku -su sa -glagla, 'ɩn wa nɛɛ ɔ -yla, ɔ zukpa -wa, ɔ jipe ɔ. ");
INSERT INTO kyf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","-Zezu kwlia ɔ -gʋ 'wʋ, 'ɩn ɔ nɛɛ ɔ kusulo -yla wɛlɩ 'tɩtɛ nyaɛ: «-Ɩn 'bhʋ ɔ -gʋ la.» Ɔ gba 'saa tɔʋn, 'ɩn we yia ɔ -gʋ labhʋ. -Bha -bhlokpadɛ ɔɔ 'ŋwnɔ -sɔa 'wʋ, 'ɩn ɔ yia wa -yla pipie bhli. ");
INSERT INTO kyf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jibheylʋ nya, -wa kaa guzʋnyaa 'yli -bhlo -bhlo nɩ, 'ɩn -maa -yɔ -maa guzʋnya yia -Zezuu -gbɛ yi. Ɔ yia wa kwɛzɩ -bhlo -bhlo, 'ɩn ɔ yia wa jipe. ");
INSERT INTO kyf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zuzu 'nyii yi 'yaa guzʋnya duun 'wʋtla 'wʋkpɩkpɩe nya: «-Lagɔɔ 'Yu -ɩn -mɩa!» -We ka gbʋ -wa, wa -yi we 'ji -nya nɩɩ, -Zezu mɩa, -Lagɔɔ -Bhasanyɔ -wa. 'Ɩn -Zezu yia we wa ŋwɛɛ labhalɩ -nya, ɔ 'nɩ ŋwnu wa 'ka gba. ");
INSERT INTO kyf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Zlɩ 'ka 'wʋladolua mnɩ tɔʋn, 'ɩn -Zezu yia 'gbe nʋkplɛ 'tla, 'ɩn ɔ yia da yabhlo mnɩ -flii. 'Ɩn nyɩmaa -zlo yia ɔ 'yli 'bɩ lanɔnʋe bhli, da ɔ mɩa nɩ, 'ɩn wa yia -bha nyni. Wa 'yɩbha ɔ 'na 'bhʋlʋ wa -yɔ -nɩ, 'ɩn wa yia ɔ lakpʋkpalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Ɩn -Zezu nɛɛ wa -ylaɛ: «We mɩ 'ya nɩɩ, ɩn gba *-Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ 'gbe tɔlʋa 'wʋ. We 'gbʋ, -Lagɔ yia 'mɩ tie.» ");
INSERT INTO kyf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","'Ɩn ɔ gbaa -Lagɔgbʋ, -Lagɔbudunya zɔ, dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Ylɩ yabhlo nya, -Zezu mɩ Zenezalɛtɩ -nyu 'kadʋ yabhloo -gɔgɔ -gʋ, 'ɩn nyɩma duun yia ɔ gbeli, wa 'ka -Lagɔwɛlɩ 'nʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","'Ɩn 'glʋ sɔ mɩa 'nyuu -gɔgɔ ŋwɛ -yɔ, -Zezu yia we -yɔyɩ, -zugba zibhi -bhanya ka we 'wʋtla, wa mɩ wa 'sowlinya -wɔlʋda. ");
INSERT INTO kyf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wee 'glʋ sɔbhie glaa, 'yabhlo -wa 'Simɔɔɔ -nʋ. -Zezu -gblaa we 'wʋ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «'Simɔɔ, -ɩn vla gwe 'nyuu -gɔgɔ -yɔ -sɛ.» -Zezu mɩ wee 'glʋ nʋkplɛ, -zugba ɔ slolu nyɩma -Lagɔwɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Da ɔ bhɩa gbagbɩe, ɔ nɛɛ 'Simɔɔ -ylaɛ: «-Ɩn bɛ 'nyuu 'wʋtɔlʋda 'glʋ nya, 'bhie, a 'ka amɩaa 'sowlinya viteli.» ");
INSERT INTO kyf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Ɩn 'Simɔɔ nɛɛ ɔ -ylaɛ: «Na -Slolunyɔ, -a ka sɩada -tʋ sabɔ weee, -a 'nɩ -lu yabhlogbɔɔ 'yɩ. Nɩɩ, -mɩ gbaa -a nʋ we lɛɛ 'gbʋ, vitelia na yia wee 'sowlinya.» ");
INSERT INTO kyf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wa vitelia wee 'sowlinya, 'ɩn wa yia zibhii -zlo 'pli, wa 'nɩ we 'wʋgbizee mneni, 'ɩn wa 'sowli yia ylaylɩe gwedɩ. ");
INSERT INTO kyf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","We 'dɛɛ 'gbʋ, wa -lima mɩa 'glʋ yabhlo 'wʋ, 'ɩn wa yia wa la sɔ -papɩe nya, -maa 'ka wa 'wʋsa. 'Ɩn wa -yɔ wa 'glʋ yia yi. 'Ɩn wa yia wee zibhi wee 'glʋ sɔbhie 'wʋslu. We ka we ye kɛkɛɛ 'gbʋ, we fɛlɩ 'nyu glu mnɩa. ");
INSERT INTO kyf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nɩɩ, Simɔ Piɛlɩ 'yɩa gbʋ -mɩnɩ -yɔ nɩ, 'ɩn ɔ yia 'kukolu 'sibhli -Zezu 'yu, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn vla gwe 'mɩ -yɔ, na -Kanyɔ! -We ka gbʋ -wa, gbʋnyuu -lɛnʋnyɔ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Zibhi -duun wa 'bhaa, da wa 'yɩa we -yɔ nɩ, 'ɩn -nyanɩgbɔ yia Simɔ Piɛlɩ -kpalɩ, we -yɔ ɔ nɔnɔnya 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nɩɩ, Zebedeee 'yua *'Zake -yɔ Zaan -wa mɩa 'Simɔɔɔ nɔnɔnya nya, 'sa -bhloo 'dɛ -nyanɩgbɔ -kpalɩa -maa. 'Ɩn -Zezu nɛɛ 'Simɔɔ -ylaɛ: «-Ɩn 'na nʋnʋ nyanɔ -nɩ, nɩɩ, sa na kpaa da zibhi nɩ, -slɛɛn, nyɩmaa -zlo -na yia -Lagɔɔ -gbɛ laa.» ");
INSERT INTO kyf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nɩɩ, wa -laa wa 'glʋ 'nyuu -gɔgɔ -yɔ lʋ, 'ɩn wa yia -bha -lu weee tɩ, 'ɩn wa yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'Ylɩ yabhlo nya, -Zezu mɩ 'gbe yabhlo nʋkplɛ, nyɩmɛ -ɔ ka ku sɔlɩ 'bhua la sa -kan, 'ɩn ɔ yia -Zezu 'yɩ. Ɔ bɛa ɔ -yɔ, 'ɩn ɔ yia dʋdʋ lagbli ɔ 'yu. Ɔ nɛɛ ɔ -ylaɛ: «-Na zukpa -wa, na -Kanyɔ. -Ɩn -wɔlʋ 'mɩ -yɔ. Nɩɩ, we -ka -mɩ dʋdʋ nanɩ, -ɩn mneni -ɩn 'ka 'mɩ jipe.» ");
INSERT INTO kyf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","-Zezu -gloa sɔ 'wʋ, 'ɩn ɔ yia ɔɔ sɔlɩbhanyɔɔ ku kwɛzɩ, 'ɩn ɔ nɛɛ: «We nanɩ 'mɩ dʋdʋ, we 'ka -mɩ -yɔ 'bhʋ!» -Zezu gba 'saa tɔʋn, -bha -bhlokpadɛ wee sɔlɩ 'bhʋa ɔɔ nyɩmɛɛ ku -yɔ. ");
INSERT INTO kyf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","-Zezu nɛɛ ɔɔ nyɩmɛ -ylaɛ: «-Ɩn -ka mnɩ nɩ, -ɩn 'na -salɩ we 'dɩ nyɩmɛ yabhlogbɔɔ -nɩ. Nɩɩ, -ɩn mnɩ -na 'dɛ -Lagɔbʋbɔnyɔ 'klʋslolua. Ɔ -ka -mɩ 'yɩ, 'ɩn 'slaka Moizɩ gbaa -na -sʋkpa -nyɩmɛ wla nɩ, -ɩn 'ka we wla. 'Ɩn nyɩma 'ka we 'jiyibheli nɩɩ, sɔlɩ ka -mɩ ku 'wʋ 'bhʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nɩɩ, -Zezu gba 'saa da ɔ -ylaoo, -mʋʋ bhla ɔ 'ŋnɩ -yɔ lamnenie mnɩa bhabha. 'Ɩn nyɩmaa -zlo yia ɔ gbeli, wa 'ka ɔ wɛlɩ yukwli pʋlʋ, 'ɩn ɔ 'ka 'ya wamɩa jipe. ");
INSERT INTO kyf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Ɩn -Zezu bhʋa wa glaa 'kɔmʋʋ, 'ɩn ɔ mnɩa -Lagɔ bhubhoea da bɛblɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Ylɩ yabhlo nya, -Zezu mɩ -Lagɔgbʋ nyɩma -sloluda, -zugba *Falizɩnyɩma -yɔ titee -cɩan -dɩ ɔ kwesi la, wa pʋlʋ ɔ yukwli. Waa nyɩma -manɩ, Galilee -yɔ Zudee -dʋdʋʋ 'gbe weee nʋkplɛ wa 'bhʋa. Tɔlʋa 'bhʋa -Zeluzalɛmʋ. Jejitapɛɛ 'tɩtɛ -yɔ -Zezu 'sɔ mɩ, -zugba ɔ jipe 'sa we nya guzʋnya. ");
INSERT INTO kyf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nyɩmaa -zakpa -bhlo -yɔ zɔlaslonyɔ yabhlo yia yi, -zugba ɔ mɩ 'sowli 'wʋ. -Budu -we zɔ -Zezu mɩa, wa 'yɩbha wa -yɔ zɔlaslonyɔ 'ka -mɔ pla, 'ɩn wa 'ka ɔ -Zezu 'yu ladɩ. ");
INSERT INTO kyf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nyɩmaa -zloo 'gbʋ, da wa 'kaa 'plɩlɩ -bha 'nɩ -mɩ. Tɔʋn, 'ɩn wa yia wee -budu 'wlu -gbla. Wa yia -bha ŋwɛ -dɩ, wa -lalɩa -bha ɔ, 'ɩn wa yia wee -budu zɔ ɔ lasibhli nyɩmaa -zlo nyɩdɩ -Zezu 'yu tɛɩn. ");
INSERT INTO kyf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","-Zezu 'yɩa nɩɩ, wa ka ɔ dlɩ -gʋ zʋ, ɔ nɛɛ ɔɔ guzʋnyɔ -ylaɛ: «'Tale, ɩn ka -na gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","-Zezu gba 'saa da tɔʋn, -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma yia 'ŋwuŋwue ŋwuŋwue bhli: «Nyɔɔ ɔɔ nyɩmɛ -mɔnɩ -mɩa, 'ɩn ɔ vɛlɩ -Lagɔa? Nyɔɔ mneni ɔ 'ka nyɩmaa gbʋnyii 'wʋtɩa? -Lagɔɔ 'dɛbhlogbɔɔ mnenia we, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Gbʋ -we wa mɩa dlɩ zɔ lapʋpalɩda, -Zezu yibhelia we 'ji nɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Lɛɛ ka 'gbʋ a pʋpalɩ sa gbʋ -mɩnɩ dlɩ zɔ la? ");
INSERT INTO kyf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɩn 'ka gba: ‹Ɩn ka -na gbʋnyii 'wʋtɩ›, -mʋʋ -kalɩa -yɔ yaayɩɩ ɩn 'ka gba: ‹-Ɩn -sɔ 'wʋ, -ɩn 'ka nɔ›, -mʋʋ -kalɩa -yɔ yɩ? ");
INSERT INTO kyf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ɩn 'yɩbha a yibheli we 'ji nɩɩ, *Nyɩmɛɛ 'Yu ka we se dʋdʋ -gʋ, ɔ 'ka nyɩmaa gbʋnyii 'wʋtɩ.» Tɔʋn, 'ɩn ɔ nɛɛ zɔlaslonyɔ -ylaɛ: «-Sɔ 'wʋ, 'bhu -na 'sowli 'wʋ, mnɩ -buduŋwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","-Bha -bhlokpadɛ, zɔlaslonyɔ -sɔa 'wʋ nyɩma weee 'yibadɩ. Ɔ 'sowli -we -gʋ ɔ pɩ yaa la, ɔ 'bhua we 'wʋ, 'ɩn ɔ yia ɔ -buduŋwɛɛ mnɩ, -Lagɔɔ 'ŋnɩ mnɩnɩe nya. ");
INSERT INTO kyf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nyɩma weee -wa mɩa -bha, ŋwɛgaga yia wa sʋbha, 'ɩn -nyanɩgbɔ yia wa -kpalɩ. Wa yia -Lagɔɔ 'ŋnɩ -mnɩnɩ, 'ɩn wa nɛɛ: «-Yɩa! -A ka -zɛɛn gwɛdigbʋnyaa da 'yɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","-Mʋʋ 'bɩgʋ, -Zezu 'tlaa, ɔ mɩ sa -zieda, 'ɩn ɔ yia *nisʋn -gwɛzisanyɔ yabhlo 'yɩ, -zugba -mɔɔ -dɩ -mɔɔ lubhonʋ -budu zɔ la. 'Mɔ wa laa Levii. 'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «Yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tɔʋn, *Levii -sɔa 'wʋ, ɔ tɩa -bha ɔ -lu weee, 'ɩn ɔ yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","-Mʋʋ 'bɩgʋ, 'ɩn Levii yia -Zezu -yla lililu 'kadʋ pi ɔ -budu zɔ. -Zugba nisʋn -gwɛzisanya duun -yɔ nyɩma tɔlʋa mɩ -bha, 'ɩn wa yia li dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Falizɩnyɩma -yɔ wa -Lagɔɔ titee gwesanya 'yɩa we -yɔ, 'ɩn wa yia wa zɔ ŋwuŋwenie bhli. 'Ɩn wa nɛɛ -Zezuu 'bɩnɔnya -ylaɛ: «Lɛɛ ka 'gbʋ a -yɔ nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan tɔlʋa 'sɔ li, 'ɩn a -yɔ wa 'sɔ maa?» ");
INSERT INTO kyf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","-Zezu 'bhua wɛlɩ 'wʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Nyɩma -wa -yalɩa, wa'a mnɩ -dɔtlɔɔ -gʋ, nɩɩ, guzʋnya mnɩa -dɔtlɔɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɩn 'nɩ nyɩma -wa laa wa 'dɛ nyɩma tɩklɩɩ lalɩee 'gbʋ yi. Nɩɩ, gbʋnyuu -lɛnʋnyaa 'gbʋ ɩn yia yi, wa 'ka wa dlɩ 'bhiti.» ");
INSERT INTO kyf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'Ɩn nyɩma tɔlʋa nɛɛ -Zezu -ylaɛ: «Zaaan 'bɩnɔnya plaa 'sun, 'ɩn wa bhubhoea -Lagɔ, 'sa Falizɩnyɩmaa 'bɩnɔnya nʋ 'yaa. 'Ɩn -nanʋʋ 'bɩnɔnya mɩ lida, -zugba wa ma!» ");
INSERT INTO kyf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Nyɩmɛ -ka ɔ 'ŋwnɔ -kwa -fɛtɩ -sada -mɩ, ɔ -ka ɔ 'talea la, a mneni a 'ka gba wa -yla wa pla 'sun, -zugba ɔɔ 'ŋwnɔɔ 'lowli mɩ wa glaa? ");
INSERT INTO kyf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bhla yabhlo yia nynia, 'ɩn wa 'ka 'ŋwnɔkwanyɔ wa glaa -sa. Wee 'ylɩnya -mɩnɩ nya, wamɩa 'kaa 'sun pla.» ");
INSERT INTO kyf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Ɩn -Zezu yi 'yaa wa gbʋʋ nine -mɩnɩ 'palɩ. Ɔ nɛɛ wa -ylaɛ: «Nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka 'naa lolu yla, 'ɩn ɔ 'ka we 'pɩ 'naa sʋa -yɔlanɛnɩ, 'ɩn ɔ 'ka we pɩpɛ. We -ka -mʋʋ, -zugba yla wa ylaa wee 'naa lolu bhe. We 'yli 'na 'ka 'wʋwlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Ɩn nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka nʋ lolu *bala sʋa 'wʋ slu. Ɔ -ka 'sa nʋ, 'ɩn we wlɔa. 'Ɩn wee nʋ jitea dʋdʋ, -zugba wee balanya ka -nyumɔ. ");
INSERT INTO kyf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","We 'gbʋ, a slu nʋ lolu bala lolu 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'Ɩn nyɩmɛ -ɔ -ka nʋ sʋa 'ma, nʋ loluu 'ma tʋ'ʋ 'bha ɔ. -We ka gbʋ -wa, gbaa ɔ yia nɩɩ: ‹Nʋ sʋa nanɩ 'yli.› » ");
INSERT INTO kyf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zuifʋʋ Nyapɛylɩ yabhlo nya, -Zezu -yɔ ɔ 'bɩnɔnya mɩ blekpaanya 'plɩda, ɔ 'bɩnɔnya -ka bleya 'kwa, wa -ka we 'titli, -zugba wa li we. ");
INSERT INTO kyf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wa mɩ 'sa nʋda, Falizɩnyɩma tɔlʋa 'yɩa wa -yɔ nɩ, 'ɩn wa yia wa layɩbhaɛ: «-We -amɩaa tite gbaa, wa 'na nʋnʋ Nyapɛylɩ nya lɛ -nɩ, lɛɛ ka 'gbʋ a nʋ we lɛa?» ");
INSERT INTO kyf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «-We nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ nʋa lɛ, -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, a 'nɩ -slɔ we zɛlɩɩ? 'Ylɩ yabhlo nya, 'ɩn ŋwɔ yia ɔ -yɔ ɔ 'bɩnɔnya 'bha, ");
INSERT INTO kyf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","-Davidɩ plaa -Lagɔɔ bʋbɔbudu zɔ, 'floo wa 'nyɛa -Lagɔ, ɔ 'bhua we 'wʋ, ɔ lia we, 'ɩn ɔ yia ɔ nɔnɔnyaa -nʋ wla, 'ɩn -maa yia we li. Wee 'floo -mɩnɩ, -amɩaa tite nɛɛ, -Lagɔbʋbɔnyaa 'dɛkpʋa 'ka yaa we li.» ");
INSERT INTO kyf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","-Zezu nɛɛ 'ya wa -ylaɛ: «Nyɩmɛɛ Yu mɩa, mɔ -wa Nyapɛylɩɩ -Kanyɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nyapɛylɩ yabhlo nya 'ya, -Zezu plaa -Lagɔbudu zɔ, 'ɩn ɔ yia -Lagɔwɛlɩɩ -sloluslolue bhli. -Zugba nyɩmɛ -ɔ ka lilikwɛsɔ 'kua, ɔ mɩ wee -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","-Zugba -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma wʋa -Zezu tenyii, -de ɔ yi nyɩmɛ jipe Nyapɛylɩ nya, 'ɩn sa ɔ'ɔ zʋa tite 'nʋŋwɛ, wa 'ka we gbʋ ɔ 'wlu dɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nɩɩ, -Zezu -yi wa 'wlukʋʋn lapʋpalɩgbʋ, we 'gbʋ, ɔ nɛɛ ɔɔ nyɩmɛ ka sɔ 'kua -ylaɛ: «-Ɩn -sɔ 'wʋ, -ɩn 'yligbe nyɩma weee -zejila 'wʋ.» Ɔɔ nyɩmɛ yia 'wʋsɔ, 'ɩn ɔ yia 'yligbe. ");
INSERT INTO kyf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","-Zezu nɛɛ wa -ylaɛ: «Wɛlɩ 'nɩ na yɩbhaa sa aɩn la. Sa tite gbaa? We nɛɛ wa nʋ gbʋ -zɔnʋ lɛ *Nyapɛylɩ nya yaayɩɩ, wa nʋ gbʋ 'nyuu lɛɛ? Wa pue nyɩmɛ yaayɩɩ, wa 'bha ɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","-Zezu ylaa wa 'dɛ weee -gʋ -ylilii, 'ɩn ɔ nɛɛ ɔɔ nyɩmɛ -ylaɛ: «-Glo -na sɔ 'wʋ.» -Mɔɔ nʋ 'saa -Zezuu wɛlɩ -gʋ, 'ɩn -mɔɔ sɔ yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","-We -Zezu nʋa lɛ, 'ɩn we yia -Lagɔ titee gwesanya -yɔ Falizɩnyɩma 'cɛ 'nyuu dlɔ la. 'Ɩn -we wa 'kaa -Zezu 'wluo nʋ, 'ɩn wa yia we pʋpalɩ wa 'dɛkpʋa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","We bhla, -Zezu yia -Lagɔ bhubhoee 'gbʋ -gɔgɔ 'wlu mnɩ, 'ɩn ɔ yia -Lagɔ bhubhoeda -tʋ zlɩ yia ɔ -zlɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zlɩ zlɩa, ɔ yia ɔ 'bɩnɔnya la. Wa glaa, 'ɩn ɔ yia nyɩma kugbua lɛ 'sɔ -bha -sa. 'Ɩn ɔ yia wa la ɔ tietienya. ");
INSERT INTO kyf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wa ŋnɩ nɩ: 'Simɔɔ (-ɔ ka -baŋnɩ ɔ zʋa Piɛlɩ) -yɔ -mɔɔ bheli Andlee, 'Zake -yɔ *Zaan, Filipʋ -yɔ Batlemii, ");
INSERT INTO kyf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie -yɔ Toma, Alɩfeee 'yu 'Zake -yɔ 'Simɔɔ wa laa *Zelɔtʋ, ");
INSERT INTO kyf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","'Zakee 'yu Zudasɩ -yɔ Zudasɩ Isɩkaliɔtʋ, -ɔ 'kaa -Zezu wla ɔ tʋnyɩma kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","-Zezu -yɔ ɔ tietienya kugbua lɛ 'sɔ 'bhʋa -gɔgɔ 'wlu, 'ɩn ɔ yia da ylalaa yabhlo 'yligbe, -zugba ɔ 'bɩnɔnya tɔlʋaa -zlo mɩ -bha dɛ. Nyɩma -duun 'bhʋa Zudee -yɔ -Zeluzalɛmʋ -dʋdʋ -gʋ, we -yɔ Tilɩ -yɔ Sidɔɔn -gbenya mɩa gumunyuu -gɔgɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wa 'dɛ weee yia, -Zezuu wɛlɩɩ yukwli pʋlʋe -yɔ ɔ 'ka wa jipee 'gbʋ. Nɩɩ, -wa zuzu 'nyii mɩa sɩalɩda, -Zezu ka wa jipe. ");
INSERT INTO kyf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nyɩma duun 'yɩbha wa 'ka ɔ kwɛzɩ, -we ka gbʋ -wa, 'tɩtɛ bhʋa ɔ 'wʋ, we mɩ wa 'dɛ weee jipeda. ");
INSERT INTO kyf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","-Zezu ylaa ɔ 'bɩnɔnya, 'ɩn ɔ nɛɛ wa -ylaɛ: «Amɩa bobabhanya, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya, nɩɩ, -Lagɔ pɩlɩ aɩn 'wlu la. ");
INSERT INTO kyf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amɩa ŋwɔ mɩa da 'bhada, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya, -we ka gbʋ -wa, lʋa a yia. Amɩa mɩa da wida, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya, -we ka gbʋ -wa, nyaa a yia. ");
INSERT INTO kyf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nyɩma -ka aɩn 'wʋnyɛ, wa -ka aɩn kwnɛɛ -sa, wa -ka aɩn vɛlɩ, 'ɩn wa -ka amɩaa daa gbʋnyuu gba Nyɩmɛɛ 'Yuu 'gbʋ, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«-Mʋʋ 'sasʋkpa -gbʋnya -ka aɩn ylɩ, a lɩtɛ 'mʋna nya. Nɩɩ, amɩaa -tnʋʋ 'kadɩ mɩ -mɔ aɩn wʋda -Lagɔɔ -gbɛ. Nɩɩ, 'sa wa dʋkpasɩ palɩ bhaa -Lagɔgbʋʋ -falɩpanya 'klɩyɩe 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amɩa, 'ŋnɩmnɩnya, gbʋnyuu mɩ amɩaa -nʋ nya, a ka amɩaa zʋzɔnʋnya kwɛɛ -seli dʋdʋ -gʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amɩa -wa lʋa da, gbʋnyuu mɩ amɩaa -nʋ nya, -we ka gbʋ -wa, ŋwɔ yia aɩn 'bhaa yia. Amɩa -wa mɩa da nyada, gbʋnyuu mɩ amɩaa -nʋ nya, -we ka gbʋ -wa, gu yia aɩn 'wʋwlʋa, 'ɩn a 'ka wi. ");
INSERT INTO kyf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nyɩma weee -ka amɩaa gbʋzɔnʋ gbada -mɩ, -zugba gbʋnyuu mɩ amɩaa -nʋ nya. Nɩɩ, 'sa wa dʋkpasɩ nʋ bhaa yoyogbʋʋ -falɩpanya. ");
INSERT INTO kyf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Amɩa -wa pʋlʋa da 'mɩ yukwli, ɩn nɛɛ aɩn -ylaɛ: a -kalɩ amɩaa tʋnyɩmaa zɛ, -wa nyɛa aɩn 'wʋ, a nʋ wa zʋzɔnʋ 'wluo. ");
INSERT INTO kyf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","-Wa bhlɩa aɩn gwɛzɛ, a ŋwna wa 'nyu la, -wa palɩa aɩn 'klɩyɩe 'wʋ, a bhubhoe -Lagɔ wa 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nyɩmɛ -ka -na yukwli yabhlo 'kpa 'wʋsʋbha, -ɩn 'bhiti ɔ -yla we -bʋdʋ. 'Ɩn ɔ -ka -na -gʋslunaa 'wʋbhu, -ɩn 'na 'tʋtɔlʋ -na -bana ɔ kwɛɛ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nyɔɔo nyɔɔ -ka -mɩ -lu -zlalɩ, -ɩn 'nyɛ we ɔ. 'Ɩn nyɔɔ -ka -na -lu 'wʋbhu, -ɩn 'na 'yɩbhalɩ we -yɔ la -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","-We a 'yɩbhaa nyɩma nʋ aɩn -yla lɛ, amɩa nʋ 'ya we lɛ wa -yla. ");
INSERT INTO kyf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«-Wa -kalɩa amɩaa zɛ, we -ka -maa -bhloo 'dɛɛ zɛ a -kalɩ, a 'na pʋpalɩ 'wlukʋʋn la -nɩ nɩɩ, -Lagɔ yia aɩn 'pɛnɩa we 'gbʋ -nɩ. Gbʋnyuu -lɛnʋnya -kalɩ 'ya -wa -kalɩa wamɩaa zɛ, we 'nɩ saa? ");
INSERT INTO kyf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","-Wa nʋa aɩn 'nanɩ 'wʋ, a -ka maa -bhloo 'dɛ 'nanɩ 'wʋnʋ, -Lagɔ 'nɩa aɩn 'pɛnɩa yi. 'Sa gbʋnyuu -lɛnʋnya -maa nʋ 'ya, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nyɩma -wa saa amɩaa kpagbʋ, a -ka -maa -bhloo 'dɛ kpagbʋ -yɔfa, lɛɛ -lu a 'ka 'yɩ we 'pɛnɩe nya -Lagɔɔ kwɛɛa? Gbʋnyuu -lɛnʋnya mɩa nɩ, gbʋnyuu -lɛnʋnya wa fa kpagbʋ -yɔ. 'Ɩn wa 'ka we 'bɩgʋpalɩ -nʋ 'yɩɩ 'gbʋ! ");
INSERT INTO kyf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","We 'gbʋ, ɩn nɛɛ aɩn -ylaɛ, a -kalɩ amɩaa tʋnyɩmaa zɛ. A nʋ zʋzɔnʋ lɛ. A fa kpagbʋ, amɩaa dlɩ 'na -tʋlʋ we 'bɩgʋpalɩ -nʋ -yla -nɩ. Nɩɩ, Yalɩ -Lagɔ yia aɩn 'pɛnɩa, 'ɩn a 'ka ɔ 'yua -zɛ. -Lagɔ mɩ zʋzɔnʋʋ lɛnʋnyɔ nya, -wa 'nɩa 'nanɩ -yi -yɔ nyɩma 'nyiii gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sa amɩaa Dide -Lagɔ kaa nyazɩdlɩ nɩ, amɩa -ka 'ya 'sa nyazɩdlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«A 'na 'bhulu nyɩma -putuu -yɔgbʋ 'wʋ -nɩ, -Lagɔ yi amɩaa -yɔgbʋ 'wʋbhu. A 'na dɩlɩ nyɩma wa gbʋnyuuu 'gba 'wlu -nɩ, -Lagɔ yi amɩaa -nʋ aɩn 'wlu dɩ. A tɩ nyɩmaa -yɔgbʋ 'wʋ, 'ɩn -Lagɔ 'ka amɩaa -yɔgbʋ 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","A 'nyɛ nyɩma, 'ɩn -Lagɔ 'ka aɩn 'nyɛ. A -ka 'sa nʋ, 'ɩn -Lagɔ slua amɩaa bi 'wʋ -lu, 'ɩn wa bhua we, 'ɩn we kʋa, 'bhie, we sloa gwe -yɔ la. Sa a nyɛa nyɩma, 'sa -Lagɔ yia aɩn 'nyɛa.» ");
INSERT INTO kyf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Ɩn -Zezu yi 'yaa wa gbʋʋ nine yabhlo 'palɩ: «'Lɔlɔnyɔ mneni ɔ 'ka 'lɔlɔnyɔɔ su lakpa, 'ɩn ɔ 'ka ɔ 'yoo da -sloluu? Wa -ka 'sa nʋ, 'ɩn wa 'dɛ 'sɔ bhlilia 'bhʋka 'wʋ, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","«Nɩɩ, 'kpɩakpɩanyɔ yabhlogbɔɔ 'nɩ ɔ -slolunyɔ 'wʋzi. 'Kpɩakpɩanyɔ -ɔ -ka 'wʋsibhli, ɔ -kanyɔ ɔ -yɔ ɔ mnenia 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Bʋɛɛ gɔ -lɛ mɩa -na bhelii 'yliya 'wʋ, 'mʋ -na yɩa -yɔ, 'ɩn su -kibhe 'kadʋ -we mɩa -na 'yliya 'wʋ, -ɩ'ɩn 'yɩ we -yɔ. Lɛɛ -lu ka 'gbʋa? ");
INSERT INTO kyf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","-Mɩ, -mɔmɔ kaa su -kibhe 'kadʋ 'yliya 'wʋ, 'ɩn -ɩ'ɩn 'yɩa we -yɔ, sa -na gba -na bheli -ylaɛ: ‹Na bheli, -ɩn 'tide 'mɩ 'yi, ɩn 'ka -mɩ wee bʋɛɛ gɔ 'yliya 'wʋ -saa?› Wɛlɩ 'sɔ -nyɩmɛ, -ɩn -sa -slɔ -na 'dɛ su -kibhe 'kadʋ 'yliya 'wʋ, -ɩn 'ka layɩ, 'bhie, -ɩn 'ka bʋɛɛ gɔ -na bhelii 'yliya 'wʋ -sa. ");
INSERT INTO kyf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Su -zɔnʋ'ʋ tnʋ 'bhue 'nyuu, 'ɩn su 'nyuu'u tnʋ 'bhue -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Suu 'bhue -yɔ wa yibhelia we. Wa'a -sa magloo mnɛwia 'wlu, 'ɩn wa'a -sa *-dlɔya 'ylɩlɩɩ su 'wlu. ");
INSERT INTO kyf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nyɩmɛ -zɔnʋ mɩa, gbʋzɔnʋ mɩa ɔ dibhe 'wʋ, 'mʋ ɔ nʋa lɛ. 'Ɩn nyɩmɛ 'nyuu mɩa, gbʋnyuu mɩa ɔ dibhe 'wʋ, 'mʋ ɔ nʋa lɛ. Nɩɩ, gbʋnya bhʋa nyɩmɛɛ dibhe 'wʋ, mʋ tlaa ɔ ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Lɛɛ ka 'gbʋ, a la 'mɩ ‹-amɩaa -Kanyɔ, -amɩaa -Kanyɔ›, 'ɩn -we na gbaa aɩn -yla, 'ɩn a'a nʋ we lɛa? ");
INSERT INTO kyf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nyɩmɛ -ɔ yia na -gbɛ, -ɔ pʋlʋa na wɛlɩ yukwli, 'ɩn ɔ nɔa we -gʋ, ɔ 'wʋwlʋ na yia aɩn 'klʋslolua. ");
INSERT INTO kyf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔ 'wlʋ sa nyɩmɛ -ɔ yia ɔ -budu 'sʋbhaa, 'ɩn ɔ yia 'wʋtɔlɔ -bhʋka 'bhlu, 'ɩn ɔ yia we gwe glu palɩ tʋkpa -gʋ, mɔ. 'Nyu 'kadʋ lʋa, we -gbligbli yilia wee -budu -yɔ, we 'nɩ we -wlɔ, wee -budu mɩ 'sʋbhada 'nanʋʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Ɩn nyɩmɛ -ɔ pʋlʋa na wɛlɩ yukwli, 'ɩn ɔ'ɔ nɔa we -gʋ nɩ, ɔ 'wlʋ sa nyɩmɛ -ɔ 'sʋbhaa ɔ -budu dʋdʋ klo -gʋ, 'ɩn ɔ 'nɩa we gwe glu 'pa, mɔ. 'Nyu 'kadʋ lʋa, we -gbligbli yia, 'ɩn we yia we -wlɔ -bha -bhlokpadɛ. 'Ɩn wee -budu yia lamumni weee.» ");
INSERT INTO kyf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Da -Zezu bhɩa wɛlɩnya -mɩnɩ gbagbɩe, nyɩmaa -zlo -wa mɩa ɔ yukwli pʋlʋda -yla, 'ɩn ɔ yia Kapɛnaumʋ gbe nʋkplɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","-Mɔ Kapɛnaumʋ, *Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ ka zɔlubhonʋnyɔ yabhlo ɔ 'yɩbhaa bhabha. Ɔɔ zɔlubhonʋnyɔ ka gu -yɔ, we -tʋ 'wʋ -sɛ, ɔ 'ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Da ɔɔ 'slʋjaa 'yugalɩnyɔ 'nʋa -Zezuu 'dɩ, 'ɩn ɔ yia Zuifʋʋ nyɩma kpasɩ tɔlʋa ɔ 'wʋtie, nɩɩ, ɔ yi ɔ 'ka ɔ zɔlubhonʋnyɔ jipe. ");
INSERT INTO kyf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wa mnɩa, 'ɩn wa yia -Zezuu -gbɛ nyni, wa bhubhoea ɔ bhabha, 'ɩn wa nɛɛ ɔ -ylaɛ: «Nyɩmɛ mɩa da, nyɩmɛ -zɔnʋ -wa, ɔ ka we 'klʋ, -ɩn 'ka ɔ -yɔbɛ. ");
INSERT INTO kyf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ɔ kalɩ -amɩaa nyɩma weee zɛ, 'ɩn mɔ 'sʋbhaa -amɩaa -Lagɔbudu.» ");
INSERT INTO kyf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Ɩn -Zezu -yɔ wa 'sɔ yia mnɩ. Wa 'ka ɔ -budu -yɔ cɩpaa yi, 'ɩn ɔɔ 'slʋjaa 'yugalɩnyɔ yia ɔ 'talea tie, nɩɩ, wa mnɩ -Zezu yoo wa gbaɛ: «Na -Kanyɔ, -ɩn 'na sɩalɩ -na 'dɛ -nɩ, ɩn 'nɩ we 'klʋ -ka, -ɩn 'ka na -budu zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɩn 'nɩ we 'klʋ -kaa 'gbʋ, na 'dɛ 'nɩa -na -gbɛ mnɩ. -Mʋʋ 'gbʋ, -ɩn gba wɛlɩ yabhlogbɔɔ, 'ɩn na zɔyu 'ka 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nɩɩ, ɩn ka 'wlulapɩlɩnya, 'ɩn na zʋa wa 'nʋŋwɛ. Ɩn ka 'slʋja, -wa 'wlu ɩn pɩlɩa la. Ɩn -ka 'yabhlo -yla gbaɛ: ‹-Ɩn mnɩ!›, 'ɩn ɔ mnɩa. Ɩn -ka 'ya -bʋdʋ -yla gbaɛ: ‹-Ɩn yi!›, 'ɩn -mɔɔ yia. 'Ɩn ɩn -ka na zɔlubhonʋnyɔ -yla gbaɛ: ‹-Ɩn nʋ -mɩnɩ lɛ!›, 'ɩn ɔ nʋa we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Da -Zezu 'nʋa wɛlɩnya -mɩnɩ, 'ɩn ɔ yia ɔɔ 'slʋja glʋ gbuu 'yugalɩnyɔ 'ŋnɩ kwalɩ. 'Ɩn nyɩmaa -zlo mɩa ɔ 'bɩ, ɔ 'bhitia wa -gbɛ la, ɔ nɛɛ wa -ylaɛ: «Ɩn nɛɛ aɩn -ylaɛ: nyɩmɛ, -ɔ zʋa sa dlɩ nɩ, ɩn 'nɩ -slɔ we -kanyɔ 'yɩ Izlaɛlɩ -dʋdʋʋ 'dɛbhie -gbolu -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","-Zezu gba 'saa tɔʋn, 'slʋja glʋ gbuu 'yugalɩnyɔɔ tietienya yia ɔ -gbɛ lʋbhiti, wa 'kaa yi, -zugba ɔ zɔlubhonʋnyɔ kaa gu -yɔ, ɔ ka 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","-Mʋʋ 'bɩgʋ, 'ylɩ yabhlo nya, 'gbe yabhlo wa laa Nainɩ, 'ɩn -Zezu yia -mɔ mnɩ, -zugba ɔ 'bɩnɔnya -yɔ nyɩmaa -zlo -yɔ ɔ 'sɔ mɩ nɔda. ");
INSERT INTO kyf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ɔ 'ka wee 'gbee 'suo ŋwɛ -yɔ cɩpaa mnɩ, -dʋgba -ŋwnɔ yabhloo nʋkpasuyu yabhlogbɔɔ tlɩa, wa mɩ ɔ 'bhluda mnɩda. -Zugba wee 'gbee nʋkpla -nyɩma duun -yɔ ɔɔ -dʋgba ŋwnɔ nɔ, wa mnɩ 'bhʋka -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Da Nyɩmaa -Kanyɔ 'yɩa ɔɔ -dʋgba -ŋwnɔ -mɔnɩ -yɔ, 'ɩn -mɔɔ yia ɔ nyazɩ 'wʋla bhabha. Ɔ nɛɛ ɔ -ylaɛ: «A -gɔlʋ 'wʋ, a 'na wili -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Bhie, ɔ bɛa -bha, 'ɩn ɔ yia 'kwiee -gbo kwɛzɩ. 'Ɩn we 'wʋbhunya yia 'yligbe. -Zezu nɛɛ: «Nyimeslɔyu, ɩn nɛɛ, -ɩn -sɔ 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","-Zezu gbaa 'sa tɔʋn, 'ɩn ɔɔ tlɩtlɩnyɔ yia 'wʋsɔ, 'ɩn ɔ yia gbagbɩe bhli. 'Ɩn -Zezu yia ɔ 'nyaa ɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","-Nyanɩgbɔ yia nyɩma weee -kpalɩ. 'Ɩn wa yia -Lagɔɔ 'ŋnɩ ylimanɩe bhli, wa nɛɛ: «-Lagɔgbʋʋ -falɩpanyɔ 'kadʋ yabhlo ka -aɩn glaa yi. -Lagɔ ka ɔ nyɩma 'wʋsaa yi.» ");
INSERT INTO kyf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","-Zezuu 'ŋnɩ -zɔnʋ yia lamneni Zudee -dʋdʋ weee -yɔ we kwesi -gbe weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","-We weee 'plɩa, 'Zan -Batisɩɩ 'bɩnɔnya yia we ɔ -salɩ lʋdɩ nya. 'Ɩn 'Zan -Batisɩ yia wa glaa nyɩma 'sɔ la. ");
INSERT INTO kyf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'Ɩn ɔ yia wa Nyɩmaa -Kanyɔ -Zezuu -gbɛ tie, wa 'ka ɔ layɩbha 'lee: «Nyɩmɛ -ɔ 'kaa yi, -a mɩa wʋda, 'mɔ -ɩn -mɩa yɩ, yaayɩɩ, -a wʋ nyɩmɛ -putuu?» ");
INSERT INTO kyf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ɔɔ 'Zan -Batisɩɩ 'bɩnɔnya nynia -Zezuu -gbɛ, wa nɛɛ ɔ -ylaɛ: «'Zan -Batisɩ tiea -aɩn -na -gbɛ, -a 'ka -mɩ layɩbha 'lee: ‹-Lagɔɔ -Bhasanyɔ -ɔ 'kaa yi, -a mɩa wʋda, 'mɔ -ɩn -mɩa yɩ, yaayɩɩ, -a wʋ nyɩmɛ -putuu?› » ");
INSERT INTO kyf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wee bhla -bhloo 'dɛ nya, -Zezu jipea guzʋnya duun -yɔ 'kukunya, 'ɩn nyɩma -wa kaa zuzu 'nyii 'bɩ, ɔ yia we wa 'bɩ vu, 'ɩn ɔ yia 'lɔlɔnya duuun 'yli -blo. ");
INSERT INTO kyf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Bhie, ɔ nɛɛ 'Zan -Batisɩɩ tietienya 'sɔ -ylaɛ: «A mnɩ, -we a 'yɩa -yɔ, 'ɩn a 'nʋa, a -salɩ we 'Zan -Batisɩ lʋdɩ nya: ‹Nɩɩ, 'lɔlɔnya mɩ layɩda, 'tɩgɩtɩgɩnya mɩ nɔda 'nanʋʋ, *sɔlɩbhanya ka 'pʋ, 'sulonya mɩ 'nʋda, tlɩtlɩnya ka tlɩtlɩe lʋ 'wʋsɔ, 'ɩn wa mɩ -Lagɔgbʋ gbada bobabhanya -yla.› ");
INSERT INTO kyf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nyɩmɛ -ɔ 'nɩ 'mɩ dlɩ -gʋ -sa, 'wʋtʋtʋe -dlɔɔ mɩ ɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Da 'Zan -Batisɩɩ tietienya 'bhitia lʋ, -bha -Zezu bhlia 'Zan -Batisɩɩ gbʋ gbagbɩe nyɩmaa -zlo -yla. Ɔ nɛɛ: «Lɛɛ -lu a mnɩ ylaa da bɛblɛɛa? Gblee -we -pɩpɛ mɩa zukluda, mʋ -wa yɩ? -Ɩnnya! ");
INSERT INTO kyf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Ɩn lɛɛ -lu a mnɩ -slɛɛn -mɔ ylaa? Nyɩmɛ -ɔ -plaa 'ŋnɩmnɩ naa 'wʋ, mɔ -wa yɩ? A -yi we 'ji nɩɩ, nyɩma -wa plaa 'ŋnɩmnɩ -naa -zɔnʋnya 'wʋ, 'ɩn wa mɩa 'ŋnɩmnɩ -li nyɩdɩ nɩ, nyɩmaa 'wlulapɩlɩnyaa -budu zɔ wa -dɩlɩa la. ");
INSERT INTO kyf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lɛɛ -lu a mnɩ -mɔ ylaa tɛnyɩɩa? -Lagɔgbʋʋ -falɩpanyɔ -wa yɩ? Ɩɩn, ɩn nɛɛ aɩn -ylaɛ: ɔ 'yli, ɔ -zi -Lagɔgbʋʋ -falɩpanyɔɔ 'dɛgbolu. ");
INSERT INTO kyf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nɩɩ, -Lagɔ nɛɛ ɔ 'sɛbhɛ 'wʋ 'Zan -Batisɩɩ daaɛ: ‹-Mɩ 'yu na paa na *tietienyɔ yoo, 'ɩn ɔ 'ka -na 'yoo -yɔmnazɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ɩn nɛɛ aɩn -ylaɛ: nyɩma -wa 'ŋwnɩ gwalɩa, wa glaa, nyɩmɛ -ɔ 'kaa 'yli, ɔ 'ka 'Zan -Batisɩ -zi, -mɔɔ 'nɩ -mɩ. -Zugba, nyɩma -wa -Lagɔ pɩlɩa 'wlu la glaa, nyɩmɛ 'kienyilɛ 'yli, -mɔɔ -zi ɔ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nyɩma weee -yɔ nisʋn -gwɛzisanya -wa pʋlʋa 'Zan -Batisɩɩ wɛlɩ yukwli, wa ka we 'jiyibheli nɩɩ, -Lagɔ tɩklɩɩ, 'ɩn wa yia wa 'dɛ 'Zan -Batisɩ yoo 'nyɛ, 'ɩn -mɔɔ yia wa batizee. ");
INSERT INTO kyf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nɩɩ, Falizɩnyɩma -yɔ -Lagɔɔ titee gwesanya ka zʋzɔnʋ -Lagɔ 'kaa wa -yla lɛnʋ kwnɛɛ -sa, 'ɩn wa 'nɩ ŋwnu 'Zan -Batisɩ 'ka wa batizee. ");
INSERT INTO kyf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","-Zezu nɛɛ 'yaɛ: «Waa dɛslɛɛn -nyɩma, nyɔɔ ɩn 'ka wa 'wʋpalɩa? Nyɔɔ wa -yɔ ɔ 'wʋwlʋa? ");
INSERT INTO kyf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wa 'wlʋ sa 'ylaasɩ -dɩa la -gblɔgblʋ 'wʋ, ma. -Zugba wa lɩlalɩ, 'ɩn wa gba wa -lima -ylaɛ: ‹-A ka aɩn -yla -lili bhlɩ, a 'nɩ lɩtɛ! 'Ɩn -a yia aɩn -yla guzɔ -lʋʋ bhlɩ, a 'nɩ wi!› ");
INSERT INTO kyf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nɩɩ, 'Zan -Batisɩ yia, ɔ'ɔ lia lililu -zɔnʋ, ɔ'ɔ 'maa nʋ, 'ɩn a nɛɛ: ‹Ɔ ka zuzu 'nyuu 'bɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","*Nyɩmɛɛ 'Yu yia nɩ, ɔ li, 'ɩn ɔ maa. 'Ɩn a nɛɛ: ‹A -talɩ, nyɩmɛ mɩa dɛ, liligbʋ -yɔ nʋmagbʋ ɔ kaa. *Nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan, wa 'tale ɔ -mɩa.› ");
INSERT INTO kyf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nɩɩ, -wa ŋwnua -Lagɔgbʋ -yɔ, ma yibhelia we 'ji, -Lagɔɔ gbʋyilo mɩa, we tɩklɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falizɩnyɩmɛ yabhlo laa -Zezu, wa 'ka li dabʋdʋ. 'Ɩn -Zezu yia ɔɔ Falizɩnyɩmɛɛ -budu zɔ pla, 'ɩn ɔ yia lililu gwe ladɩ. ");
INSERT INTO kyf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","-Mʋʋ bhla, gbʋnyuuu lɛnʋ -ŋwnɔ yabhlo mɩ wee 'gbe -mʋʋ nʋkplɛ. Ɔ 'nʋa nɩɩ, -Zezu mɩ Falizɩnyɩmɛɛ -gbɛ lida, ɔ -yɔ *-lasiklɔ -zɔnʋʋ -bhonyidaa yeyenʋ yia -mɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Ɩn ɔ yia -Zezu lʋʋ ladɩ, -mɔɔ bhʋnya -yɔ, -zugba ɔ wi. 'Ɩn ɔ 'mɩɔ yia -Zezuu bhʋ wɔtɔlʋ. 'Bhie, ɔ yia we -yɔsɛ ɔ 'nyi nya, ɔ yia we gbleli, 'ɩn ɔ yia -lasiklɔ ɔ bhʋ -yɔ slu. ");
INSERT INTO kyf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Falizɩnyɩmɛ, -ɔ laa -Zezu wa 'ka li dabʋdʋ, ɔ 'yɩa we -yɔ, ɔ nɛɛ ɔ 'dɛɛ dlɩ zɔɛ: «Ɔɔ nyɩmɛ -mɔnɩ -ka yaa -Lagɔgbʋʋ -falɩpanyɔ 'piɛɩn, 'ŋwnɔ -ɔ mɩa dɛ ɔ kwɛzɩda, sa ɔ mɩa, -zugba, ɔ ka yaa ɔ yibheli gbʋnyuu lɛnʋ ŋwnɔ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","-Zezu 'bhua wɛlɩ 'wʋ, ɔ nɛɛ ɔɔ Falizɩnyɩmɛ -ylaɛ: «'Simɔɔ, ɩn 'yɩbha ɩn 'ka -mɩ -yla gbʋ yabhlo gba.» 'Simɔɔ nɛɛ: «Na -Kanyɔ, -ɩn gba.» ");
INSERT INTO kyf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Ɩn -Zezu nɛɛ: «Nyɩmɛ yabhloo kpagbʋ mɩa nyɩma 'sɔ -yɔ. 'Yabhlo ka tamaa 'wlu glʋ gbu -zakpa gbu 'wlu (500.000), 'ɩn -gʋdʋ kaa 'wlu glʋ 'sɔ 'wlu kugbua 'wlu (50.000). ");
INSERT INTO kyf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nɩɩ, waa nyɩma 'sɔ 'na 'ka wee kpagbʋ -saa 'gbʋ, 'ɩn ɔɔ nyɩmɛ yi 'saa we tɩ. 'Lee wa 'dɛ 'sɔ glaa nɩɩ, nyɔɔ 'ka ɔɔ nyɩmɛ 'yɩbha bhabha?» ");
INSERT INTO kyf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'Ɩn 'Simɔɔ yia we 'bɩgʋpalɩɛ: «-Amɩ dlɩɩ nɩ, -ɔ kaa 'gwɛzi 'kadʋ 'wlu, mɔ 'kaa ɔ 'yɩbha bhabha.» 'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «Gbʋ -zɔnʋ -ɩn gbaa.» ");
INSERT INTO kyf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tɔʋn, -Zezu 'bhitia la 'ŋwnɔɔ -gbɛ, 'ɩn ɔ nɛɛ 'Simɔɔ -ylaɛ: «-Na yɩ 'mɔ ŋwnɔ nɩ -yɔɔ? Ɩn plaa -na -budu zɔ, -ɩn 'nɩ 'mɩ 'nyu 'nyɛ, ɩn 'ka bhʋ -yɔ budo. Nɩɩ, mɔ budoa na bhʋ -yɔ ɔ 'mɩɔ nya, 'ɩn ɔ yia we -yɔ sɛ ɔ 'nyi nya. ");
INSERT INTO kyf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","-Ɩn 'nɩ 'mɩ gbleli, nɩɩ, ɔ plaa, mɔ -tʋa na bhʋ gblelida. ");
INSERT INTO kyf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","-Ɩn 'nɩ 'mɩ 'kpɩ 'wluo slu, nɩɩ, mɔ slua na bhʋ -yɔ -lasiklɔ. ");
INSERT INTO kyf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","We 'gbʋ, ɩn nɛɛ -mɩ -ylaɛ: -Lagɔɔ zɛ ɔ kalɩa bhabhaa 'gbʋ, -Lagɔ ka ɔ gbʋnyuu duun 'wʋtɩ. Nɩɩ, nyɩmɛ -ɔ nʋa gbʋnyuu 'kienyi lɛ, 'ɩn -Lagɔ yia ɔ -yɔgbʋ 'wʋtɩ, ɔ -Lagɔɔ zɛkalɩdlɩ -sɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Ɩn -Zezu nɛɛ ɔɔ 'ŋwnɔ -ylaɛ: «Ɩn ka amaa gbʋnyii 'wʋtɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","-Wa -yɔ ɔ 'sɔ mɩa lida, -maa nɛɛ -mɔ dlɩ zɔɛ: «Mɔɔ -nyɩmɛ mɔa, 'ɩn -mɔɔ tɩ nyɩmɛɛ gbʋnyuu 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Ɩn -Zezu nɛɛ ɔɔ 'ŋwnɔ -ylaɛ: «Amaa dlɩ ka aɩn pue, a mnɩ, 'wʋtʋtʋe -dlɔɔ -yɔ aɩn 'sɔ -mɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","-Mʋʋ 'bɩgʋ, -Zezu yia 'gbe 'kadɩ -yɔ 'gbe yua 'wʋ mnɩ, *-Lagɔɔ nyɩmaa 'wlulapɩlɩee gbʋzɔnʋnyaa gbagbɩe nya, -zugba ɔ 'bɩnɔnya kugbua lɛ 'sɔ -yɔ ɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","'Ɩn, 'ŋwnɩ tɔlʋa ɔ vua zuzu 'nyii 'bɩ, -yɔ ɔ jipea, -maa mɩ 'ya -bha. Wa ŋnɩ nɩ: Magɩdalaa -ŋwnɔ Malii zuzu 'nyii gbesɔ 'tlaa 'wʋ, ");
INSERT INTO kyf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ewlodʋʋ lubhonʋnyɔ 'kadʋ Kuzaa 'ŋwnɔ Zanɩ, -yɔ 'Suzanɩ -yɔ 'ŋwnɩ dumadu, -wa -saa -Zezu -yɔ ɔ 'bɩnɔnya 'wʋ, wa zʋzɔnʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nyɩmaa -zlo 'bhʋa 'gbe -bhlo -bhlo 'wʋ, 'ɩn wa yia -Zezu -yɔ 'wlugbeli. 'Ɩn ɔ yia gbʋʋ nine -mɩnɩ wa 'palɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Nɩɩ, kpaapanyɔ mnɩa ɔ 'mnɔ 'paa. Ɔ mɩ ɔ 'mnɔ 'pada, ɔ 'mnia we, 'ɩn we -zakpa -bhlo yia 'yoo ŋwɛ -yɔ bhli. 'Plɩplɩnya nɔa we -gʋ, 'ɩn 'zianya yia we li. ");
INSERT INTO kyf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tɔlʋa yia tʋkpa -dʋdʋ -gʋ bhli, we mia, -bhaa bla 'nɩ 'nyu 'wʋlakaa 'gbʋ, 'ɩn we yia yɛ. ");
INSERT INTO kyf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tɔlʋa yia -kpɔga glaa bhli, 'ɩn -mʋʋ -yɔ we 'sɔ yia 'wʋsɔ, 'ɩn -mʋʋ yia we -gʋ palɩlɩ, 'ɩn we yia we 'tuntnu. ");
INSERT INTO kyf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tɔlʋa yia dʋdʋ -zɔnʋ -gʋ bhli, 'ɩn we yia mi, we 'paa lakpa, we lakpa -bhlo -sa -mɔ 'yaa glʋ gbu.» 'Ɩn -Zezu yia we -gʋ dɩ wɛlɩ 'tɩtɛ nyaɛ: «-Ɔ -ka 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɔ 'bɩnɔnya ka ɔ wee gbʋʋ nine -mɩnɩɩ 'ji layɩbha. ");
INSERT INTO kyf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Ɩn ɔ yia we 'bɩgʋpalɩ wa -ylaɛ: «-Lagɔ ka ɔ nyɩmaa 'wlulapɩlɩgbʋ mɩa zizeda aɩn 'klʋslolu. 'Ɩn nyɩma tɔlʋa -nʋ mɩa, gbʋʋ nine nya wa 'paa we wa -yla. ‹Wa -ka -lu yla, wa'a 'yɩ we -yɔ, 'ɩn wa -ka gbʋ 'nʋ, wa'a 'nʋ we 'wʋla.› ");
INSERT INTO kyf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Wee gbʋʋ ninee ji nɩ: 'mnɔya mɩa, we 'wlʋ -Lagɔwɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nyɩma tɔlʋa 'wlʋ 'yoo ŋwɛ -yɔ da 'mnɔya bhli: wa -ka -Lagɔwɛlɩ 'nʋ nɩ, 'ɩn *'Kuzu yia, 'ɩn we saa we wa dibhe 'wʋ, wa yi we dlɩ -gʋ zʋ, 'ɩn wa yi gbʋ 'wʋbhʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","-Mʋmʋnya mia tʋkpa -bita -gʋ: -mʋʋ 'wlʋ nyɩma -tɔlʋa, -wa nʋa -Lagɔwɛlɩ, 'ɩn wa ŋwnua -bha we -yɔ 'mʋna nya nɩ, wa'a 'tide we 'yi, we'e fa wa 'wʋ somi. Bhla -sɛlɛ nya, wa ŋwnua we -yɔ, 'ɩn laylagbʋnya -ka yi, 'ɩn wa dlɩ bhʋa we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nyɩma tɔlʋa 'wlʋ 'mnɔya -we bhli -kpɔga glaa: wa -ka -Lagɔwɛlɩ 'nʋ, bhla -gʋdʋ -ka nyni, 'ɩn wa tidea wa 'dɛ 'yi -sɛ -sɛ, 'ɩn dlɩlʋe -yɔ 'ŋnɩmnɩ -li, dʋdʋ -gʋʋ 'mʋna -li tuntnua wa, 'ɩn wa'a wla 'ya, -mʋʋ'ʋ zalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Mnɔya -we bhlia dʋdʋ -zɔnʋ -gʋ, -mʋʋnya 'wlʋ nyɩma -wa nʋa -Lagɔwɛlɩ dlɩ -zɔnʋ nya, 'ɩn wa zʋa we la, wa dlɩ weee nya, 'ɩn wa paa 'ya bhla weee nya. ");
INSERT INTO kyf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Nyɩmɛ -ka 'napɛ -nyuma, ɔ'ɔ -gbli we -solu 'wluo, 'ɩn ɔ'ɔ fa we 'lii zɔ. Nɩɩ, yalɩ ɔ dɩa we la -budu zɔ, 'ɩn -wa -ka pla, wa 'ka we san -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nɩɩ, -we weee mɩa zizeda, zlɩ 'klʋ we yia 'tlaa, 'ɩn -we weee mɩa 'wiemɩ -lu nya, 'ji wa yia we yibhelia, 'ɩn we 'ka 'bhlewlʋ weee. ");
INSERT INTO kyf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","We 'gbʋ, a zʋ amɩaa gbʋʋ yukwli pʋlʋ sɔ 'yliyɔ. Nɩɩ, -lukanyɔ mɩa, ɔ -nʋ wa yia -gʋpalɩa, 'ɩn nyɩmɛ -ɔ 'nɩa -lu duun -ka, we -sɛlɛ -we -gʋ ɔ dlɩ mɩa, kwɛɛ wa yia we ɔ -saa.» ");
INSERT INTO kyf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","-Zezuu bhelia -yɔ ɔ 'nyaa 'sɔ yia ɔ 'yɩa nɩ, nyɩma duuun 'gbʋ, wa 'nɩ mneni wa 'ka ɔ ylɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Ɩn wa yia -Zezu 'dɩ kwaɛ: «-Na 'nyaa -yɔ -na bhelia mɩ 'pipee. Wa 'yɩbha wa 'ka -mɩ 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Ɩn -Zezu nɛɛ wa 'dɛ weee -ylaɛ: «-Wa pʋlʋa -Lagɔwɛlɩ yukwli, 'ɩn wa nɔa we -gʋ nɩ, ma -wa, na 'nyaa -yɔ na bhelia.» ");
INSERT INTO kyf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","'Ylɩ yabhlo nya, -Zezu -yɔ ɔ 'bɩnɔnya -gblaa 'glʋ yabhlo 'wʋ nɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «-A 'plɩlɩ 'nyuu kakpe -putu -gʋ.» 'Ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Da wa mɩa 'nyu 'wʋdɩda, 'ɩn -Zezu yia 'ylaa ŋwɔ. Tɔʋn, -pɩpɛ 'kadʋ yia 'nyu -gʋ 'plɩplɩe bhli. 'Nyu mɩ 'glʋ yeda, we -tʋ 'wʋ -sɛ, wa 'ka 'nyu glu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","-Zezuu 'bɩnɔnya bɛa ɔ kwesi, 'ɩn wa yia ɔ ganɔ. 'Ɩn wa nɛɛ 'wʋkpɩkpɩe nya: «-Slolunyɔ, -Slolunyɔ, -amɩa tlɩa!» -Zezu ganɔa, 'ɩn ɔ yia -pɩpɛ 'wluo 'kpɩlɩ. 'Ɩn 'nyuu -gbʋgbʋ yia zɔbɛ, we yia 'yligbe blenyii. 'Ɩn -bha yia 'wʋku. ");
INSERT INTO kyf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","-Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «Mɔ amɩaa dlɩzʋzʋe mɩa?» -Nyanɩgbɔ -kpalɩa wa nɩ, 'ɩn ŋwɛgaga yia wa sʋbha. 'Ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «Mɔɔ -nyɩmɛ ɔɔ -mɔnɩ -mɩa, 'ɩn ɔ gba 'nyu -yɔ -pɩpɛ -yla, 'ɩn we zʋ ɔ 'nʋŋwɛa?» ");
INSERT INTO kyf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","-Zezu -yɔ ɔ 'bɩnɔnya -dɩa 'nyu 'wʋ, Zelazɩ -nyɩmaa dʋdʋ mɩa nyuu kakpe yabhlo -gʋ, Galilee 'klʋ, -mɔ wa nynia. ");
INSERT INTO kyf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Da -Zezu 'bhʋa 'glʋ 'wʋ ɔ 'sibhlia la, 'ɩn wee 'gbee nʋkpla -nyɩmɛ yabhlo yia ɔ yoo yi. Ɔɔ nyɩmɛ mɩa, zuzu 'nyii mɩa ɔ 'wʋ. 'Bɩ ka 'wʋgwlɛ, ɔ'ɔ -pla -bana 'wʋ, 'ɩn ɔ'ɔ -gʋ -budu zɔ, nɩɩ, gbawla -nyɩdɩ ɔ gʋa. ");
INSERT INTO kyf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Da ɔ 'yɩa -Zezu -yɔ, 'ɩn ɔ yia 'wʋkpɩ, 'ɩn ɔ yia ɔ bhʋ -yɔ bhlili. 'Ɩn ɔ nɛɛ wɛlɩ 'tɩtɛ nyaɛ: «-Naa lɛɛ -gbʋ pɩlɩ na gbʋ 'wʋla, -Zezu, Yalɩ -Lagɔɔ 'Yu? -Mɩ na bhubhoea, -ɩn 'na palɩ 'mɩ 'klɩyɩe 'wʋ -nɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","-We ka 'gbʋ ɔɔ nyɩmɛ yi 'saa gba, zuzu 'nyuu mɩa ɔ 'wʋ, 'mʋ -Zezu gbaa we 'tla ɔ 'wʋ. Wee zuzu 'nyuu mɩa, 'wʋ we bhua ɔ -zakpa duun nya. Wa -ka ɔ sɔnya gbʋan nɛtɛllikpe nya, 'ɩn wa -ka ɔ gbloko bhʋ 'wʋ fa, 'ɩn ɔ dɩa we 'dɛ weee. 'Ɩn wee zuzu 'nyuu kwaa ɔ -flii. ");
INSERT INTO kyf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","-Zezu yia ɔ layɩbhaɛ: «Sa wa la -na 'ŋnɩa?» 'Ɩn ɔ nɛɛ: «Na 'ŋnɩ wa laa ‹'Slʋjaa -zlo› ». -We ka gbʋ -wa, zuzu 'nyii duun mɩ ɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","'Ɩn wee zuzu 'nyii nɛɛ -Zezu -ylaɛ: «-Na zukpa -wa, -ɩn 'na kwalɩ -aɩn *glukaslʋ 'wʋ -nɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","-Zugba -boboo -zlo mɩ we lililuu datalɩda -gɔgɔɔ nʋkpla -gʋ. 'Ɩn wee zuzu 'nyii nɛɛ -Zezu -ylaɛ: «-Na zukpa -wa, -ɩn kwa -aɩn -bobonya mɩa nɩ 'wʋ!» 'Ɩn -Zezu yia we 'yoo 'nyɛ nɩɩ, we pla we 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tɔʋn, zuzu 'nyii yia ɔɔ nyɩmɛ 'wʋ 'tla, 'ɩn we yia -bobonya 'wʋ pla. 'Ɩn wee -bobo weee yia -gɔgɔ kwli -gwagwɩe nya, 'ɩn we yia 'nyu lʋ slo, 'ɩn we yia tlɩ -nya. ");
INSERT INTO kyf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Da wee -boboo 'yliyɔzʋnya 'yɩa gbʋ 'plɩa nɩ -yɔ, 'ɩn wa -yɔ -gwagwɩe yia 'gbe 'kadɩ -yɔ kʋdanya 'wʋ we 'dɩ lamneni. ");
INSERT INTO kyf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Da wee gbʋ -mɩnɩ 'plɩa, 'ɩn nyɩma yia -mɔ 'yɩa mnɩ. Wa nynia -Zezu kwesi, nyɩmɛ -ɔ 'wʋ zuzu 'nyii 'tlaa, 'ɩn wa yia ɔ 'yɩ, -zugba ɔ -dɩ -Zezuu bhʋ -yɔ la, -bana mɩ ɔ 'wʋ, 'ɩn ɔ 'wlukʋʋn ka ladolu. 'Ɩn -nyanɩgbɔ yia wa -kpalɩ weee. ");
INSERT INTO kyf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sa ɔɔ zuzu 'nyii 'wʋ -nyɩmɛ 'pʋa nɩ, -wa 'yɩa wee gbʋ weee da, 'ɩn -maa yia we 'dɩ -sa wa -yla. ");
INSERT INTO kyf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tɔʋn, Zelazɩ -nyɩma weee nɛɛ -Zezu -yla, ɔ 'bhʋ wa dʋdʋ -gʋ. Nɩɩ, -nyanɩgbɔ ka wa -kpalɩ. 'Ɩn -Zezu yia 'glʋ 'wʋgbla, ɔ 'ka lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nyɩmɛ -ɔ zuzu 'nyii 'tlaa 'wʋ, bhubhoea -Zezu, ɔ nɛɛ ɔ -ylaɛ: «Ɩn -yɔ -mɩ 'sɔ 'ka mnɩ.» 'Ɩn -Zezu yia ɔ lʋlabhitili, ɔ nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Mnɩ -na -buduŋwɛɛ. -We weee -Lagɔ nʋa -mɩ -yla lɛ, -ɩn gba we nyɩma -yla.» Ɔɔ nyɩmɛ mnɩa, -we weee -Zezu nʋa ɔ -yla lɛ, 'ɩn ɔ yia we 'dɩ lamneni, wee 'gbe 'kadʋ nʋkplɛ weee. ");
INSERT INTO kyf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Da -Zezu yia lʋ 'nyuu kakpe -putu -gʋ, 'ɩn nyɩmaa -zlo yia ɔ yoo -sa, wa mɩ ɔ wʋdaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","We bhla, nyɩmɛ -ɔ wa laa -Zalusɩ nynia -Zezuu -gbɛ. -Lagɔbuduu -kanyɔ yabhlo ɔ -mɩa. 'Ɩn ɔ yia -Zezuu bhʋ -yɔ bhlili, ɔ yia ɔ bhubhoe nɩɩ, ɔ yi ɔ -buduŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","-We ka gbʋ -wa, ɔ 'ŋwnɔyu yabhlogbɔɔ kaa -zʋ kugbua lɛ 'sɔ, mɔ mɩa tlɩda. Da -Zezu mɩa -mɔ mnɩda, -zugba nyɩmaa -zlo tuntnu 'saa ɔ sɔ weee lʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wa nyɩdɩ, 'ŋwnɔ yabhlo mɩa -bha, ɔ kwɛpalɩe li ɔ -yɔ -zʋ kugbua lɛ 'sɔ. 'Ɩn ɔ yia 'gwɛzi weee -nyumɔ. -Dɔtlɔɔ yabhlogbɔɔ 'nɩ ɔ jipe. ");
INSERT INTO kyf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɔ 'plɩlɩa -Zezu lʋʋ, 'ɩn ɔ yia ɔ -banaa ŋwɛ kwɛzɩ. -Bha -bhlokpadɛ ɔ 'pɩɔn yia 'wʋkanɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Ɩn -Zezu yia layɩbhaɛ: «Nyɔɔ zɩ 'mɩ kwɛa?» Wa 'dɛ weee mɩ we kpɛlɩdaa 'gbʋ, 'ɩn Piɛlɩ nɛɛ: «Na -Slolunyɔ, nyɩma -wa gbelia -mɩ, ma tuntnua -mɩ sɔ weee lʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Ɩn -Zezu nɛɛ: «Nyɩmɛ yabhlo ka 'mɩ kwɛzɩ, ɩn ka we 'jiyibheli nɩɩ, na 'tɩtɛ ka lubho nʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ɔɔ 'ŋwnɔ 'yɩa we -yɔ nɩɩ, wa ka we 'jiyibheli, 'ɩn ɔ -yɔ tɛlɩtɛlɩe yia -Zezuu bhʋ -yɔ bhlia mnɩ. 'Ɩn -we ka 'gbʋ, ɔ yia ɔ kwɛzɩ, 'ɩn sa ɔ 'pʋa -bha -bhlokpadɛ, ɔ yia we gba ɔ -yla, nyɩma weee 'yibadɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","-Zezu nɛɛ ɔ -ylaɛ: «Na 'yu, amaa dlɩ ka aɩn pue, a mnɩ, 'wʋtʋtʋe -dlɔɔ -yɔ aɩn 'sɔ -mɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Da -Zezu mɩa gbʋ -mɩnɩ gbada, nyɩmɛ yabhlo 'bhʋa -Zalusɩɩ -buduŋwɛɛ, ɔ yia 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn 'na sɩalɩ Nyɩmaa -Kanyɔ -nɩ, -na 'ŋwnɔyu ka tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","-Zezu 'nʋa we nɩ, ɔ nɛɛ -Zalusɩ -ylaɛ: «-Ɩn 'na nʋnʋ nyanɔ -nɩ, -ɩn zʋ dlɩ! 'Pʋa ɔ yia.» ");
INSERT INTO kyf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","-Zezu nynia wee -buduŋwɛɛ, ɔ 'nɩ ŋwnu nyɩma -putu 'ka wee -budu zɔ pla, 'mʋ we 'nɩ Piɛlɩ klaa, *Zaan klaa, *'Zake klaa, we -yɔ 'yuu dide -yɔ ɔ 'nyaa 'wʋbhʋ. ");
INSERT INTO kyf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nyɩma weee mɩ wida, -zugba wa bhalɩ ɔɔ 'ŋwnɔyuu 'gbʋ. 'Ɩn -Zezu nɛɛ wa -ylaɛ: «A 'na wili -nɩ, ɔ 'nɩ tlɩ, 'ylaa 'wʋ ɔ mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Ɩn wa -yi we 'ji nɩɩ, 'yu ka tlɩɩ 'gbʋ, wa yia ɔ gla palɩ. ");
INSERT INTO kyf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","-Zezu kpalɩa ɔ sɔ -yɔ, 'ɩn ɔ yia 'wʋkpɩ, ɔ nɛɛ: «Na 'yu, a -sɔ 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɔ zuzu 'sibhlia ɔ -gʋ la, 'ɩn ɔ yia 'wʋsɔ -bha -bhlokpadɛ. -Zezu nɛɛ wa -ylaɛ: «A 'nyɛ ɔ lililu.» ");
INSERT INTO kyf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","-We 'plɩa, 'ɩn we yia ɔɔ 'ŋwnɔyuu 'nyaa -yɔ ɔ dide ŋwɛgaga -sʋbhalɩ. 'Ɩn -Zezu nɛɛ wa -ylaɛ: «A 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","'Ylɩ yabhlo nya, -Zezu gbelia ɔ 'bɩnɔnya kugbua lɛ 'sɔ 'wlu, 'ɩn ɔ yia wa se -yɔ 'tɩtɛ 'nyɛ, wa 'ka zuzu 'nyii vu, 'ɩn wa 'ka gu nyɩma -yɔ -sa. ");
INSERT INTO kyf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'Bhie, ɔ yia wa tie, wa 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ gba. 'Ɩn wa 'ka guzʋnya jipe. ");
INSERT INTO kyf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'Ɩn ɔ nɛɛ wa -ylaɛ: «A -ka nɔa mnɩa yi nɩ, a 'na 'bhulu -lu yabhlogbɔɔ 'wʋ -nɩ: kɔɔsu, *-bada, 'floo -yɔ 'gwɛzi 'na -mɩnɩ aɩn kwɛɛ -nɩ. 'Ɩn nyɩmɛ yabhlogbɔɔ 'na 'bhulu -bana 'sɔ 'wʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","-Budu -we ŋwɛɛ a -ka mnɩ, wa -ka amɩaa 'lakpasu kpa, a -tʋ -bha tɩklɩɩ, 'ɩn amɩaa lʋbhiti ylɩ 'ka nyni. ");
INSERT INTO kyf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","-Budu -we ŋwɛɛ a -ka mnɩ, wa 'nɩ amɩaa 'lakpasu kpa, a 'tla wee 'gbe nʋkplɛ. A gbɔtɔ amɩaa bhʋ -yɔ *-bhubhui, 'ɩn nyɩma 'ka we 'jiyibheli nɩɩ, wa 'nɩ -Lagɔgbʋ -yɔŋwnu.» ");
INSERT INTO kyf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","-Zezuu 'bɩnɔnya yia mnɩ. 'Ɩn wa yia 'gbe weee 'wʋ 'plɩlɩ, -Lagɔgbʋʋ gbagbɩe -yɔ guzʋnyaa jipee nya da weee. ");
INSERT INTO kyf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","We bhla, -we weee mɩa 'plɩda, 'ɩn Galileee 'wlulapɩlɩnyɔ Ewlodʋ yia we 'nʋ. -We ɔ 'kaa 'wlukʋʋn lapʋpalɩ, we 'nɩ -mɩ. Nɩɩ, nyɩma -tɔlʋa nɛɛ: «'Zan -Batisɩ -sɔa 'wʋ tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","'Ɩn nyɩmaa -zakpa -bhlo nɛɛ: «Elii yia lʋ dʋdʋ -gʋ.» 'Ɩn tɔlʋa nɛɛ 'yaɛ: «Bhabenyii -Lagɔgbʋʋ -falɩpanyaa 'yabhlo -sɔa 'wʋ tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ewlodʋ nɛɛ: «Na wɛlɩ -gʋ, wa ka Zaan 'wlu -gʋ -dɩ. 'Ɩn nyɩmɛ -ɔ ka -gʋgbʋ na nʋa dɛ, nyɔɔ mɔa?» 'Ɩn ɔ yia -Zezu 'ylibɩlanɔnʋ, ɔ 'ka ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","-Zezuu tietienya yia ɔ -gbɛ lʋ, -we wa nʋa lɛ, 'ɩn wa yia we 'dɩ ɔ -salɩ. Ɔ -yɔ wa 'sɔ vlaa gwe, 'ɩn wa yia 'gbe -we wa laa Bɛtɩsaida kwesi mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nyɩmaa -zlo 'nʋa we, 'ɩn wa yia ɔ 'bɩ mnɩ. -Zezu yia wa kpa sɔ 'sɔ nya, 'ɩn ɔ yia wa -yla -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ gba. Nyɩma -wa 'yɩbhaa ɔ jipe wa, 'ɩn ɔ yia -maa jipe. ");
INSERT INTO kyf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Da jibhe mɩa zɔda, 'ɩn -Zezuu 'bɩnɔnya kugbua lɛ 'sɔ yia ɔ kwesi bɛ. 'Ɩn wa nɛɛ ɔ -ylaɛ: «Da -a mɩa -seli, -bha tlʋlʋ la. -Ɩn gba nyɩma -manɩ -yla, wa mnɩ 'gbenya -yɔ kʋdanya mɩa kwesi 'wʋ, wa 'ka lililunya -yɔ lapɩda 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Ɩn -Zezu nɛɛ wa -ylaɛ: «Amɩaa 'dɛ 'nyɛ wa lililu!» 'Ɩn wa yia we 'bɩgʋpalɩɛ: «'Floo gbu -yɔ zibhii 'ya 'sɔ -a kaa kwɛɛ. -Ɩn 'yɩbha, nɩɩ, -amɩa mnɩ nyɩmaa -zlo -manɩɩ lililu zɔaa?» ");
INSERT INTO kyf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Nɩɩ, sa, nyɩmaa 'wlu glʋ -bhlo 'wlu gbu mɩa -bha (5.000) ). 'Ɩn -Zezu nɛɛ ɔ 'bɩnɔnya -yla, wa dɩ wa la sa glʋ 'sɔ 'ya kugbua, kugbua ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wa nʋ 'saa, 'ɩn wa yia wa 'dɛ weee ladɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","-Zezu 'bhua wee 'floo gbu -yɔ zibhii 'ya 'sɔ 'wʋ, ɔ ylaa yalɩ, 'ɩn ɔ yia -Lagɔ fuo 'pa. Ɔ dɩdlɩa we la, 'ɩn ɔ yia we ɔ 'bɩnɔnya yoo 'nyɛ, wa 'ka we nyɩmaa -zlo 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wa 'dɛ weee lia, 'ɩn wa yia lʋ. 'Ɩn -we -tʋa 'wʋ, wa -yɔ we -cɩcɛɛ yeye -nʋ kugbua lɛ 'sɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Ylɩ yabhlo nya, -Zezu mɩ -Lagɔ bhubhoeda, ɔ 'dɛ -bhlo, -zugba ɔ 'bɩnɔnya mɩ ɔ kwesi. 'Ɩn ɔ yia wa layɩbhaɛ: «Nyɔɔ nyɩmaa -zlo palɩ 'mɩ 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Ɩn wa yia we 'bɩgʋpalɩɛ: «-Zakpa -bhlo nɛɛ, 'Zan -Batisɩ -ɩn -mɩa. Tɔlʋa nɛɛ, Elii -ɩn -mɩa, 'ɩn tɔlʋa nɛɛ 'yaɛ, -Lagɔgbʋʋ -falɩpanya mɩ bhaa bhlasabhla, wa 'yabhlo -sɔa 'wʋ tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Ɩn -Zezu yia wa layɩbhaɛ: «'Ɩn amɩa, a nɛɛ, nyɔɔ ɩn -mɩa?» 'Ɩn Piɛlɩ yia we 'bɩgʋpalɩɛ: «-Lagɔɔ -Bhasanyɔ -ɔ ka gbʋ ɔ gbaa, 'mɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Ɩn -Zezu nɛɛ wa -yla 'klʋ 'cɩcɩ nyaɛ: «A 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'Ɩn ɔ yia we -gʋdɩɛ: «We mɩ nɩɩ, ɔɔ Nyɩmɛɛ 'Yu sɩa bhabha. 'Ɩn Zuifʋʋ nyɩma kpasɩ klaa, *-Lagɔbʋbɔnyaa -cɩan klaa, we -yɔ -Lagɔɔ titee gwesanya yia ɔ kwnɛɛ -saa. 'Bhaa wa yia ɔ, 'ɩn 'ylɩ 'sɔ we tanʋ nya, tlɩtlɩnya glaa ɔ yia 'wʋsɔa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","'Bhie, ɔ nɛɛ wa 'dɛ weee -ylaɛ: «Nyɔɔo nyɔɔ -ka gba ɔ 'ka 'mɩ 'bɩ nɔ, ɔ -sa ɔ 'dɛ dlɩ, ɔ 'bhu ɔ sɩasɩee *su 'wʋ, 'ylɩ weee nya, 'ɩn ɔ 'ka 'mɩ 'bɩ yi. ");
INSERT INTO kyf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nɩɩ, nyɔɔo nyɔɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋgʋ nɩ, 'wʋ ɔ yia we bɔa. 'Ɩn -ɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe 'wʋbɔ na 'gbʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ -mɔɔ yia 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nyɩmɛ -ka dʋdʋ -gʋʋ zʋzɔnʋ weee 'yɩ, 'ɩn ɔ -ka ɔ 'yliyɔgagɩe 'wʋbɔ, ɔ -ka ɔ 'dɛ lasa dʋdʋ -gʋ, lɛɛ -lu ɔ 'ka we 'wʋ 'yɩa? ");
INSERT INTO kyf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nyɩmɛ -ɔ -ka ɩn -yɔ na wɛlɩ 'sɔ zʋ nʋ, zlɩ Nyɩmɛɛ 'Yu yia yia ɔ -yɔ ɔ Dide -yɔ -mɔɔ -mɔwlʋ -anzɩnyaa 'ŋnɩmnɩe 'wʋ, we zlɩ -mɔɔ nʋ 'yaa ɔnʋʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -wa mɩa da -seli, wa tɔlʋa ka -Lagɔɔ nyɩmaa 'wlulapɩlɩe da 'yɩ, 'bhie, wa 'kaa tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","-Zezu gbaa wɛlɩ -mɩnɩ, we 'bɩgʋ, lɔkɔwlu -bhlo 'plɩa sa, -Zezu -yɔ Piɛlɩ, Zaan -yɔ 'Zake 'sɔ mnɩa, 'ɩn ɔ yia -gɔgɔ 'wlu -Lagɔ bhubhoea mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Da -Zezu mɩa -Lagɔ bhubhoeda, 'ɩn ɔ 'klʋ yia 'bhiti, 'ɩn ɔ 'wʋ -bana yia pɔmanɩ, -zugba we lɩ 'bɩbɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","-Bha -bhloo 'dɛ, 'ɩn nyɩma 'sɔ yia ɔ 'klʋ 'tlalɩ, -zugba ɔ -yɔ wa 'sɔ gba. Moizɩ -yɔ Elii sɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma 'tlaa -Lagɔɔ 'ŋnɩmnɩee san -nyɩdɩ. Sa -Zezu 'kaa ɔ lubho 'wlubha -Zeluzalɛmʋ, ɔ tlɩtlɩe nya, 'ɩn wa -yɔ ɔ 'sɔ yia we -gʋgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piɛlɩ -yɔ ɔ -lima 'sɔ ka -gblo 'ylaa nya. Da wa ganɔa, 'ɩn wa yia -Zezuu 'ŋnɩmnɩee san -yɔyɩ, we -yɔ nyɩma sɔ mɩa ɔ kwesi. ");
INSERT INTO kyf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Da waa nyɩma mɩa -Zezu kwesi 'bhʋda, 'ɩn Piɛlɩ nɛɛ ɔ -ylaɛ: «Na -Slolunyɔ, -a -ka -seli -tʋ we nanɩ 'yli. Palʋ yua ta -a yia 'sʋbhaa, -na -nʋ -bhlo, Moizɩɩ -nʋ -bhlo, Eliii -nʋ -bhlo.» (Nɩɩ, -we Piɛlɩ mɩa gbada, ɔ 'nɩ we -yi.) ");
INSERT INTO kyf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Da ɔ mɩ 'saa gbada nɩ, 'ɩn yalɩpʋpa yia wa -gʋgbli. We -gblia wa -gʋ, 'ɩn -nyanɩgbɔ yia wa -kpalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Ɩn wɛlɩ yabhlo yia wee yalɩpʋpa nyɩdɩ 'tla, we nɛɛ: «-Ɔ mɩa dɛ, na Yu -wa, 'mɔ ɩn -saa -bha, a pʋlʋ ɔ yukwli!» ");
INSERT INTO kyf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Da wa 'nʋa wɛlɩ -mɩnɩ, -mʋʋ 'bɩgʋ, -Zezuu 'dɛbhlogbɔɔ wa 'yɩa -yɔ. 'Ɩn ɔ 'bɩnɔnya yia ŋwɛ 'mu 'cɛ, -we wa 'yɩa -yɔ, wa 'nɩ we 'dɩ -sa nyɩmɛ yabhlogbɔɔ -yla, we bhla. ");
INSERT INTO kyf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zlɩ zlɩa, 'ɩn wa yia -gɔgɔ 'wlu 'bhʋ. Nyɩmaa -zlo yia -Zezu yoo yi. ");
INSERT INTO kyf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","-Mɔ nyɩmaa -zlo nyɩdɩ, nyɩmɛ yabhlo yia 'wʋkpɩ: «Na -Kanyɔ, -mɩ na bhubhoe, -ɩn yla na 'yu, mɔ -wa na 'yu yabhlogbɔɔ! ");
INSERT INTO kyf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","-Ɩn -talɩ, zuzu 'nyuu -ka ɔ kpa, 'ɩn ɔ kpɩa 'wʋ, -bha -bhlokpadɛ, we zuklua ɔ 'tɩtɛɛ, 'ɩn we wlelia ɔ 'fufli gbʋa ŋwɛɛ. We -ka ɔ sɩalɩ kplokplo, 'bhie, we bhʋa ɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ɩn ka -na 'bɩnɔnya bhubhoe nɩɩ, wa vu wee zuzu 'nyuu ɔ 'bɩ, wa 'nɩ we kwɛ -yɔ mneni.» ");
INSERT INTO kyf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","-Zezu yia 'wʋkpɩ: «Dɛslɛɛn -nyɩma -wa'a zʋ dlɩ, nyɩma 'nyii, 'ylɩ zuma ɩn -yɔ aɩn 'sɔ 'ka lia? 'Ylɩ zuma ɩn 'ka amɩaa 'gba zɔ 'yligbeda -tʋa? -Ɩn -yɔ -na 'yu yi -seli.» ");
INSERT INTO kyf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bhla -we nya 'yu mɩa -Zezu kwesi bɛda, 'ɩn zuzu 'nyuu yia ɔ labhlɩ, we yia ɔ lazuklu 'tɩtɛɛ. 'Ɩn -Zezu yia wee zuzu 'nyuu 'wluokpɩlɩ. 'Ɩn ɔ yia ɔɔ 'yu jipe, ɔ yia ɔ dide ɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Ɩn -wa weee mɩa -bha, -Lagɔɔ 'tɩtɛ 'kadʋ yia wa ŋwɛgaga -sʋbhalɩ. -We weee -Zezu nʋa lɛ, we ka wa ŋwɛgaga -sʋbhalɩ -bhlo -bhloo 'gbʋ, ɔ nɛɛ ɔ 'bɩnɔnya -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Amɩa, -we na gbaa da a 'nʋ we, *Nyɩmɛɛ 'Yu wa yia nyɩma yoo 'nyɛa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","-Zezu gbaa wɛlɩ -mɩnɩ, ɔ 'bɩnɔnya 'nɩ we 'wʋlanʋ. We 'ji mɩ zizeda wa -yla, wa yi we 'wʋlanʋʋ 'gbʋ. 'Ɩn wa 'ka we -Zezu layɩbha, nyanɔ mɩ wa dlɩɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","'Ylɩ yabhlo nya, -Zezuu 'bɩnɔnya yia kpɛlɩe bhli wa 'dɛkpʋa nyɩdɩ. 'Ɩn wa nɛɛ 'lee: «Nyɔɔ 'yli -aɩn glaa?» ");
INSERT INTO kyf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","-Zezu yibhelia -we -gʋ wa mɩa kpɛlɩdaa 'ji, 'ɩn ɔ yia 'yulɛ 'wʋbhu, 'ɩn ɔ yia -mɔɔ ɔ 'dɛ kwesi 'yligbeli. ");
INSERT INTO kyf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ɔ nɛɛ wa -ylaɛ: «-Ɔ -ka 'yu -mɔnɩ kpa 'nanʋʋ na 'ŋnɩ nya, na 'dɛ ɔ kpaa 'nanʋʋ. 'Ɩn -ɔ -ka 'mɩ kpa 'nanʋʋ, -ɔ tiea 'mɩ, 'mɔ ɔ kpaa 'ya 'nanʋʋ. Nɩɩ, -ɔ -ka ɔ 'dɛ 'wʋbhu 'kienyi, mɔ -wa nyɩmɛ 'kadʋ aɩn glaa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zaan 'bhua wɛlɩ 'wʋ, ɔ nɛɛ: «-Amɩaa -Slolunyɔ, -a ka nyɩmɛ yabhlo 'yɩ, zuzu 'nyuu ɔ vua -na 'ŋnɩ nya. -A 'yɩbha yaa -a 'ka ɔ 'yligbeli, ɔ -yɔ -aɩn 'sɔ 'nɩ -mɩɩ 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nɩɩ, -Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «A 'na 'yligbeli ɔ -nɩ. -We ka gbʋ -wa, -ɔ 'nɩ amɩaa tʋnyɩmɛ, amɩaa nyɩmɛ -wa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Da -Zezuu dʋdʋ -gʋ -bhʋ -ylɩnya cɩpaa, 'ɩn ɔ nɛɛ, -Zeluzalɛmʋ ɔ mnɩa -kpɔ. ");
INSERT INTO kyf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɔ yia nyɩma tie ɔ 'dɛ 'yu. -Maa mnɩa, 'ɩn -maa yia Samalii -gbe yabhlo nʋkplɛ pla, wa 'ka da ɔ 'kaa -gʋ lamnazɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɔ mɩ -Zeluzalɛmʋ mnɩdaa 'gbʋ, *Samalii -nyɩma 'nɩ ɔ gbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","-Zezuu 'bɩnɔnya 'Zake -yɔ Zaan 'nʋa we, 'ɩn wa nɛɛ -Zezu -ylaɛ: «-Amɩaa -Kanyɔ, -ɩn 'yɩbha -a gba -kosu 'bhʋ yalɩ, we 'ka wa lasaa?» ");
INSERT INTO kyf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","-Zezu 'bhitia la wa -gbɛ, 'ɩn ɔ yia wa -yla gba 'klʋ 'cɩcɩ nyaɛ: «Dlɩ -we zʋa wɛlɩ -mɩnɩ aɩn ŋwɛɛ, a 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nɩɩ, Nyɩmɛɛ 'Yu 'nɩ dʋdʋ -gʋ yi nyɩmaa lasasɩee 'gbʋ. Nyɩmaa puepuee 'gbʋ ɔ yia yi.» 'Ɩn -Zezu -yɔ ɔ 'bɩnɔnya yia 'gbe -putu 'wʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Da wa mɩa mnɩda 'yloogblʋ, 'ɩn nyɩmɛ yabhlo nɛɛ -Zezu -ylaɛ: «Dao da -ɩn -ka mnɩda -mɩ, ɩn mɩ -mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","-Zezu nɛɛ ɔ -ylaɛ: «-Totonya ka 'bhʋka, 'ɩn 'zianya kaa lʋlʋ. Nɩɩ, da Nyɩmɛɛ 'Yu 'kaa ladɩlɩ, -bha 'nɩ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Ɩn -Zezu nɛɛ nyɩmɛ yabhlo -ylaɛ: «-Ɩn yi 'mɩ 'bɩ.» 'Ɩn -mɔɔ nɛɛ: «Nyɩmaa -Kanyɔ, -ɩn 'nyɛ 'mɩ 'yoo, ɩn 'ka na dide 'bhlua mnɩ 'bhie.» ");
INSERT INTO kyf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","-Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Ɩn 'tide tlɩtlɩnya 'yi, wa 'ka wa tlɩtlɩnya 'bhlu. Nɩɩ -mɩ, -ɩn mnɩ -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ gbaa.» ");
INSERT INTO kyf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Yabhlo nɛɛ 'ya ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, 'bɩ na yia -mɩ nɔa, nɩɩ, -ɩn 'tide -slɔ 'mɩ 'yi, ɩn 'ka na nyɩma wɛlɩ 'paa mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","-Zezu nɛɛ ɔ -ylaɛ: «Nyɩmɛ -ɔ kpaa gʋgwlɛɛ kʋkʋ la, 'ɩn ɔ dɩa lubhoo gwe, 'bhie ɔ -talɩa lʋ, ɔ 'nɩ mneni ɔ 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩe zɔ pla.» ");
INSERT INTO kyf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","-Mʋʋ 'bɩgʋ, Nyɩmaa -Kanyɔ -Zezu laa ɔ 'bɩnɔnya, 'ɩn ɔ yia wa glaa glʋ ta 'ya kugbua lɛ 'sɔ -bhasa. 'Ɩn 'gbenya -yɔ da ɔ 'dɛ 'ka yaa mnɩ, 'ɩn ɔ yia -mɔ wa tie 'sɔ 'sɔ ɔ 'dɛ 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","-Zezu nɛɛ wa -ylaɛ: «'Mnɔ ka zalɩ duun, we kpaa 'yli, 'ɩn we -dɩdɩnya 'nɩ 'wʋzu. We 'gbʋ, a bhubhoe kpaa -kanyɔ, 'ɩn ɔ 'ka lubhonʋnya yoo 'pa, wa 'ka ɔ 'mnɔ -dɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","A mnɩ, bhlabhlɛyua 'bhisa na tiea aɩn gbi glaa. ");
INSERT INTO kyf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A 'na 'bhulu 'gwɛzi klaa, -bada klaa, we -yɔ -sakwla 'wʋ -nɩ. 'Ɩn a 'na -gwlɛlɩ 'yloogblʋ fʋsasɩee 'gbʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","A -ka -budu -mʋmʋ ŋwɛɛ nyni, a gba tɩaɛ: ‹'Wʋtʋtʋe -dlɔɔ -mɩ -budu -mɩnɩ ŋwɛɛ.› ");
INSERT INTO kyf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We -ka 'wʋtʋtʋe -dlɔɔ -nyɩmɛ yabhlo mɩ wee -buduŋwɛɛ, amɩaa 'wʋtʋtʋe -dlɔɔ a gbaa ɔ -yla, we -tʋ ɔ -gʋ. We 'nɩ -mʋʋʋ, amɩaa 'wʋtʋtʋe -dlɔɔ yi amɩaa -gbɛ lʋ. ");
INSERT INTO kyf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A -tʋ wee -budu -mɩnɩ ŋwɛɛ, -we wa -ka aɩn 'nyɛ a li, 'ɩn a 'ma. Nɩɩ, lubhonʋnyɔ mɩa, ɔ 'pɛnɩlu ɔ yɩa. A 'na 'plɩlɩ -budu -bhlo -bhlo ŋwɛɛ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Da a -ka 'gbe -mʋmʋ 'wʋ pla, wa -ka aɩn kpa 'nanʋʋ wa 'lakpanya nya, -we wa -ka aɩn 'nyɛ, a li we. ");
INSERT INTO kyf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A jipe wee 'gbee guzʋnya. 'Ɩn a gba -mɔ -nyɩma -ylaɛ: ‹*-Lagɔɔ nyɩmaa 'wlulapɩlɩe ka aɩn -yɔ cɩpa.› ");
INSERT INTO kyf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nɩɩ, 'gbe -we 'wʋ a -ka mnɩ, -mɔ -nyɩma 'nɩ amɩaa 'lakpasu kpa, a 'tla -gblɔgblʋ 'kadʋ 'wʋ. A gba wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Amɩaa 'gbee nʋkpla -bhubhui -we sloa -aɩn bhʋ -yɔ, 'mʋ -a yia aɩn -gʋ gbɔtɔlʋa. 'Ɩn a yibheli we 'ji nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe ka cɩpa.› ");
INSERT INTO kyf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ɩn nɛɛ aɩn -ylaɛ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, 'gbe -mɩnɩɩ nʋkpla -nyɩma yia sia bhabha, we 'ka *Sodɔmʋ -nyɩmaa -nʋ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Kolazɛn -nyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Bɛtɩsaida -nyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Ninee 'ŋnɩpalɩgbʋ -Lagɔ nʋa lɛ amɩaa -gbɛ, we -ka yaa nɩɩ, Tilɩ -yɔ Sidɔɔn 'sɔ ɔ nʋ we lɛ, -zugba -mɔ -nyɩma ka yaa wa dlɩ 'bhiti pepe. 'Ɩn wa ka yaa we -slolu, -gbɛnaa 'wʋplaplɩe -yɔ 'tʋtɔɔ 'wluo -sluslue nya. ");
INSERT INTO kyf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","We 'gbʋ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, amɩaa -nʋ ɔ yia 'wʋbhua, we 'ka Tilɩ -yɔ Sidɔɔɔn -nʋ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Ɩn amɩa, Kapɛnaumʋ -nyɩma, amɩa dlɩɩ nɩɩ, 'wʋ a yia -sɔa yalɩ yɩ? -Ɩnnya, we 'nɩ -mʋʋ, zɔ -Lagɔ yia aɩn bɛlɩa tlɩtlɩnyaa dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","-Zezu nɛɛ 'ya ɔ 'bɩnɔnya -ylaɛ: «Nyɩmɛ -ɔ -ka aɩn yukwli pʋlʋ, -amɩ ɔ pʋlʋa yukwli. -Ɔ 'nɩ aɩn kpa 'nanʋʋ, -amɩ ɔ 'nɩa kpa 'nanʋʋ. 'Ɩn -ɔ 'nɩ 'mɩ kpa 'nanʋʋ, -zugba, -ɔ tiea 'mɩ, 'mɔ ɔ 'nɩa kpa 'nanʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","-Mʋʋ 'bɩgʋ, waa tietienyaa glʋ ta 'ya kugbua lɛ 'sɔ yia lʋyi 'mʋna nya. 'Ɩn wa nɛɛ -Zezu -ylaɛ: «-Amɩaa -Kanyɔ, -a -ka gbʋ gba zuzu 'nyii -yla, -na 'ŋnɩ -gʋ, 'ɩn we zʋa -aɩn 'nʋŋwɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Ɩn ka *-Saatan -yɔyɩ yalɩ -bhʋda nɛɛ nyu 'pa 'yɩka, 'ɩn we yia bhli. ");
INSERT INTO kyf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A yla, ɩn ka aɩn se 'nyɛ, a 'ka tɩbhɛ -yɔ -klagbeta -gʋ nɔ. 'Ɩn a 'ka 'ya amɩaa tʋnyɩmɛɛ 'tɩtɛ lawlalɩ, 'ɩn -lu yabhlogbɔɔ 'nɩ mneni we 'ka aɩn gbʋnyuu 'wluo nʋ. ");
INSERT INTO kyf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","A 'na lili 'mʋna zuzu 'nyii ka aɩn 'nʋŋwɛ zʋʋ 'gbʋ -nɩ. Nɩɩ, amɩaa 'ŋnɩ -Lagɔ cɛlɩa yalɩ, a li -mʋʋ 'gbʋ 'mʋna.» ");
INSERT INTO kyf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wee bhla -bhloo 'dɛ nya, Zuzu 'Pʋpa yia -Zezu 'mʋna yeli. 'Ɩn ɔ yia 'wʋkpɩ: «Dide, -na 'ŋnɩ na mnɩnɩa, yalɩ -yɔ dʋdʋʋ -Kanyɔ, ɩn 'pa -mɩ fuo. -We ka gbʋ -wa, -lu -we -ɩn zizea gbʋyilonya -yɔ 'ylimnanya kwɛɛ, 'mʋ -ɩn -slolua 'nyɛnyɛyua 'klʋ. Gbʋzɔnʋ -wa, Dide, -na 'dɛ 'yɩbhaa we -mɩ 'sa. ");
INSERT INTO kyf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Na Dide ka 'mɩ -lu weee 'nyɛ. Ɔɔ Yu mɩa, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ -yi, we 'nɩ ɔ Didee 'dɛbhlogbɔɔ 'wʋbhʋ. 'Ɩn ɔ Dide mɩa, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ -yi, we 'nɩ ɔ 'Yu 'wʋbhʋ, we -yɔ -wa ɔ 'Yu -slolua ɔ 'klʋ, ma -yia ɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Bhie, -Zezu 'bhitia ɔ 'bɩnɔnyaa -gbɛ la, 'ɩn ɔ nɛɛ -maa 'dɛkpʋa -ylaɛ: «'Wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya, -we a mɩa da -yɔyɩda, a ka we -yɔyɩɩ 'gbʋ! ");
INSERT INTO kyf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nɩɩ, ɩn nɛɛ aɩn -ylaɛ: -Lagɔgbʋʋ -falɩpanya duun -yɔ dʋdʋʋ 'wlulapɩlɩnya 'yɩbha bhaa, -we a yɩa -yɔ, wa 'ka we -yɔyɩ, 'ɩn wa 'nɩ we -yɔyɩ. -We a nʋa, wa 'ka we 'nʋ, 'ɩn wa 'nɩ we 'nʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","-Bha -Lagɔɔ titee gwesanyɔ yabhlo -sɔa 'wʋ, ɔ 'ka -Zezu laylaa 'gbʋ. 'Ɩn ɔ yia ɔ layɩbhaɛ: «-Slolunyɔ, sa ɩn 'ka nʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'ɩn ɩn 'ka we 'yɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","-Zezu nɛɛ ɔ -ylaɛ: «Sa we mɩ cɛlɩda titee 'sɛbhɛ 'wʋa, 'ɩn -ɩn -ka we zɛlɩ sa -na nʋ we 'wʋla?» ");
INSERT INTO kyf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Ɩn ɔɔ nyɩmɛ yia we 'bɩgʋpalɩɛ: «Jejitapɛ, -ɔ -wa -na -Lagɔ, -ɩn -kalɩ ɔ zɛ -na dlɩ weee nya, -na zuzu weee nya, -na 'tɩtɛ weee nya, -na 'wlukʋʋn lapʋpalɩe weee nya. 'Ɩn -ɩn -kalɩ -na -libheyii zɛ -na 'dɛ 'bhisa.» ");
INSERT INTO kyf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","-Zezu nɛɛ ɔ -ylaɛ: «-Ɩn ka we 'bɩgʋpalɩ tɩklɩɩ. -Ɩn nʋ 'sa, 'ɩn -ɩn 'ka 'yliyɔgagɩe 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nɩɩ, ɔɔ -Lagɔɔ titee gwesanyɔ 'yɩbha ɔ 'ka zukpa 'yɩɩ 'gbʋ, 'ɩn ɔ yia -Zezu layɩbhaɛ: «Nyɔɔ -wa na -libheyia?» ");
INSERT INTO kyf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","-Zezu yia we 'bɩgʋpalɩɛ: «Nyɩmɛ yabhlo 'bhʋa -Zeluzalɛmʋ, ɔ mɩ Zelikogbe 'wʋ mnɩda, 'ɩn 'wienya yia ɔ 'yligbeli. Wa 'bhua ɔ -lu weee 'wʋ, wa bhɩtɩa ɔ, ɔ -gbloa, 'ɩn wa yia -bha ɔ tɩ, 'ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sa 'bhisa, -Lagɔbʋbɔnyɔ yabhlo bhlia wee 'yloogblʋ, ɔ 'yɩa ɔɔ nyɩmɛ -yɔ lapɩda, 'ɩn ɔ yia ɔ -yɔlabhlɩlɩ, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Sa -bhlokpadɛ *Leviii zʋaylinyɩmɛ yabhlo nynia 'ya -bha. Ɔ 'yɩa ɔɔ nyɩmɛ -yɔ, 'ɩn ɔ yia ɔ -yɔlabhlɩlɩ, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Nɩɩ, Samalii -nyɩmɛ yabhlo mɩa 'lakpa 'wʋ mnɩda. Ɔ nynia ɔɔ nyɩmɛ -yɔ, ɔ 'yɩa -mɔɔ -yɔ, 'ɩn -mɔɔ yia ɔ nyazɩ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔ nynia -mɔɔ -yɔla -tapa, 'ɩn ɔ yia -mɔɔ danya lɛ nʋa, 'kpɩ -yɔ nyakpɔ palɩ, 'ɩn ɔ yia we gbʋan. 'Bhie, ɔ yia ɔ 'wʋbhu ɔ -sokofalɩ -gʋ, 'ɩn ɔ yia ɔ 'lakpanyaa -budu zɔ kwa. -Mɔ ɔ gwlʋlʋa ɔ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","We zlɩ zlɩa, ɔ -saa -mɔ 'gwɛzi , 'ɩn ɔ yia we wee -buduu -kanyɔ yoo 'nyɛ. 'Ɩn ɔ nɛɛ -mɔɔ -ylaɛ: ‹-Ɩn gwlʋ nyɩmɛ nɩ -yɔ, da ɩn -ka -seli lʋyi, -na 'gwɛzi -we -ɩn -ka we -gʋpalɩ, ɩn 'ka we kpagbʋ -sa na 'dɛ nya.› » ");
INSERT INTO kyf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","-Zezu yia we -gʋdɩɛ: «Waa nyɩma ta -manɩ glaa, -mɩ dlɩɩ, nyɔɔ -wa nyɩmɛ 'wienya bhɩtɩaa -libheyia?» ");
INSERT INTO kyf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","-Lagɔɔ titee gwesanyɔ yia we 'bɩgʋpalɩɛ: «Nyɩmɛ -ɔ 'yɩlɩa ɔ nyazɩ, mɔ -wa.» 'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «-Ɩn mnɩ, -ɩn nʋ 'sa». ");
INSERT INTO kyf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","-Zezu -yɔ ɔ 'bɩnɔnya mɩ 'yloogblʋ, 'ɩn ɔ yia 'gbe yabhlo nʋkplɛ pla. 'Ŋwnɔ yabhlo mɩa -bha, wa laa Maatɩ, mɔ kpaa ɔ 'lakpasu ɔ 'dɛɛ -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maatɩɩ bhɔlɔ wa laa Malii, mɔ -dɩa Nyɩmaa -Kanyɔɔ bhʋ -yɔ la, -zugba ɔ pʋlʋ ɔ nyɩmaa gbʋslolu wɛlɩ yukwli. ");
INSERT INTO kyf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maatɩɩ 'yligwe -su la pipie nya. Ɔ yia -Zezu kwesi, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, na bhɔlɔ tɩlɩa na 'dɛ -bhlo lubho weee, we'e -la -mɩ -sɩan 'wʋ? -Ɩn gba ɔ -yla nɩɩ, ɔ -sa 'mɩ 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nyɩmaa -Kanyɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Maatɩ, Maatɩ, amaa 'dɛɛ dlɩ a sumanɩa bhe, 'ɩn a palɩa amaa 'dɛ -bɩabɩ 'yligwe gbʋ duuun 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nɩɩ, -lu yabhlogbɔɔ mɩ -lu -zɔnʋ nya. -We nanɩa 'yli, 'mʋ Malii -saa -bha. 'Ɩn nyɩmɛ 'nɩ mneni ɔ 'ka we ɔ kwɛɛ -sa.» ");
INSERT INTO kyf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Ylɩ yabhlo nya, -Zezu mɩ -Lagɔ bhubhoeda da yabhlo. Da ɔ bhɩa, ɔ 'bɩnɔnyaa 'yabhlo nɛɛ ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, -ɩn -slolu -aɩn -Lagɔbhubhoe, sa 'Zan -Batisɩ -slolua ɔ 'bɩnɔnya.» ");
INSERT INTO kyf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","-Zezu nɛɛ wa -ylaɛ: «A -ka -Lagɔ bhubhoeda -mɩ, a gbaɛ: ‹Dide, wa zʋ -bha -na -mɔwlʋ ŋnɩ, -na nyɩmaa 'wlulapɩlɩe yi. ");
INSERT INTO kyf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'Ylɩ -we -ka -mɩ, -ɩn 'nyɛ we lililu -aɩn. ");
INSERT INTO kyf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","-Ɩn tɩ -amɩaa -yɔgbʋ 'wʋ. -Wa nʋa -aɩn gbʋnyuu 'wluo, sa -a tɩa wa -yɔgbʋ 'wʋ, 'sa. -Ɩn 'na kwalɩ -aɩn laylagbʋ lʋ -nɩ.› » ");
INSERT INTO kyf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","-Zezu nɛɛ 'ya wa -ylaɛ: «Sa 'bhisa, aɩn glaa, 'yabhlo ka 'tale yabhlo. Ɔ -ka ɔ -gbɛ mnɩ zlɩ -nyɩdɩ, ɔ 'ka ɔ -yla gbaɛ: ‹'Tale, -ɩn fa 'mɩ 'floobhakʋ taa kpagbʋ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nɩɩ, dɛslɛɛn, na 'tale yabhlo 'bhʋa 'lakpa 'wʋ, 'ɩn ɔ yia na -gbɛ yi. Ɩn 'nɩ -lu yabhlogbɔɔ -ka, 'ɩn ɩn 'ka we ɔ 'nyɛ.› ");
INSERT INTO kyf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«'Ɩn sa 'bhisa, ɔ 'tale -mɔɔ yia we 'bɩgʋpalɩ -budu zɔɛ: ‹-Ɩn 'tide 'mɩ 'yi 'cɛ! Ɩn ka -budu kla -laklɩ nya, we 'bɩ ka 'wʋgwlɛ. Ɩn -yɔ na 'yua mɩ lapɩda, ɩn 'nɩ mneni ɩn 'ka 'wʋsɔ, 'ɩn ɩn 'ka -mɩ 'floo yoo 'nyɛ!› ");
INSERT INTO kyf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ɩn nɛɛ aɩn -yla, ɔ 'na 'ka 'wʋsɔ, ɔ 'ka wee 'floonya wla ɔ 'tale -ŋwɛɛ. Nɩɩ, -mɔɔ mɩ we -zlazlagbʋ kpada sɔ 'sɔ nya -klii 'gbʋ, 'wʋ ɔ yia -sɔa, -we weee -mɔɔ -ka 'yɩbha, ɔ 'ka we -mɔɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«We 'gbʋ, -amɩ nɛɛ aɩn -ylaɛ: a -zla -lu, 'ɩn wa 'ka we aɩn 'nyɛ. A -talɩ -luu da, 'ɩn a 'ka we 'yɩ. A bhlɩ -budu, 'ɩn wa 'ka -bha -kalɩ aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nɩɩ, -ɔ zlaa -lu, 'mɔ wa nyɛa we. -Ɔ talɩa -luu da, mɔ yɩa we. -Ɔ bhlɩa -budu, mɔ -yla wa kalɩa -bha. ");
INSERT INTO kyf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Aɩn glaa, 'yabhlo -ka 'yuu dide nya -mɩ, ɔ 'yu -ka ɔ 'floo -zlalɩ, ɔ yi ɔ tʋkpa 'nyɛɛ? Yaayɩɩ, ɔ -ka ɔ zibhi -zlalɩ, ɔ yi ɔ tɩbhɛ 'nyɛɛ? ");
INSERT INTO kyf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'Ɩn ɔ 'yu -ka ɔ nynugan -zlalɩ, ɔ yi ɔ -klagbeta 'nyɛɛ? ");
INSERT INTO kyf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nɩɩ, amɩa -mama -wa nyɩma 'nyii, a -yi amɩaa 'yua -li -zɔnʋ 'nyɛ sa. We -ka 'sa -mɩ, amɩaa Dide -ɔ mɩa yalɩ, -ɔ kaa 'nanɩ, -wa zlalɩa ɔ Zuzu 'Pʋpa, ɔ 'na 'ka we wa 'nyɛɛ?» ");
INSERT INTO kyf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'Ylɩ yabhlo nya, zuzu 'nyuu -we -zɛlɩa nyɩmɛ yabhlo bhobho, -Zezu mɩ we vuda, da wee zuzu 'tlaa -mɔɔ 'wʋ, 'ɩn -mɔɔ yia gbagbɩe bhli -bha -bhlokpadɛ. Tɔʋn, nyɩmaa -zlo -wa mɩa -bha, 'ɩn ŋwɛgaga yia wa sʋbha. ");
INSERT INTO kyf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nɩɩ, nyɩma -tɔlʋa -wa mɩa -bha, wa nɛɛ: «Zuzu 'nyiii -kanyɔ *Bɛlɩzebulɩ nyɛa ɔ se, ɔ 'ka zuzu 'nyii vu.» ");
INSERT INTO kyf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tɔlʋa 'yɩbha wa 'ka ɔ laylaa 'gbʋ, wa nɛɛ ɔ -yla, ɔ nʋ gwɛdigbʋ yabhlo lɛ, 'ɩn wa 'ka we 'jiyibheli nɩɩ, -Lagɔɔ -gbɛ ɔ bhʋa. ");
INSERT INTO kyf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","'Ɩn -Zezu -yi wa 'wlukʋʋn lapʋpalɩee 'gbʋ, ɔ nɛɛ wa -ylaɛ: «Dʋdʋ -we ka -gʋ -nyɩma -ka tʋ -gʋ wa 'dɛkpʋa nyɩdɩ, la wee dʋdʋ bhʋa. 'Ɩn -budu -bhlo ŋwɛɛ -nyɩma -ka -yɔwʋsʋsɔlʋda -mɩ, bhlia wee -budu yia. ");
INSERT INTO kyf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A nɛɛ, zuzu 'nyii na vua, Bɛlɩzebulɩ nyɛa 'mɩ we se. -Saatan -ka we 'dɛ -yɔwʋsɔlʋ, sa we dʋdʋ 'ka 'wʋlatʋtlʋa? ");
INSERT INTO kyf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bɛlɩzebulɩ -ka -amɩ se 'nyɛ, ɩn -ka zuzu 'nyii vu, nyɔɔ nyɛ amɩaa -lima se, 'ɩn -maa vu wee zuzu 'nyiia? We 'gbʋ, amɩaa -limaa 'dɛbhiee lɛnʋgbʋ slolua nɩɩ, -we a gbaa yo -wa. ");
INSERT INTO kyf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gbʋzɔnʋ sa, -Lagɔɔ sɔ nya na vua zuzu 'nyii, we ji -wa nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ aɩn nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Latɛlɔnyɔ -ɔ kaa 'li -yɔ -gblɛ kwɛɛ, ɔ -ka ɔ kʋda 'wʋkʋda -mɩ nɩ, ɔ zʋzɔnʋ weee mɩ 'wʋpada 'cɛ. ");
INSERT INTO kyf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Ɩn, nyɩmɛ 'tɛa la, -ɔ zia ɔ, -mɔɔ -ka yi, 'ɩn -mɔɔ -ka ɔ ŋwɛ -zi, 'ɩn ɔ 'li -yɔ -gblɛ -we ɔ dɩ yaa dlɩ 'wʋ, 'ɩn -mɔɔ saa we ɔ kwɛɛ. 'Ɩn -we weee -mɔɔ -saa ɔ kwɛɛ, 'ɩn -mɔɔ dlilia we. ");
INSERT INTO kyf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nyɩmɛ -ɔ -yɔ 'mɩ 'nɩ -mɩ, na tʋnyɔ -wa. Nyɩmɛ ɔ'ɔ -saa 'mɩ 'wʋ, -a 'ka nyɩma -yɔbɩbɛlɩ, la ɔ mumnia wa. ");
INSERT INTO kyf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Nɩɩ, zuzu 'nyuu 'tlaa nyɩmɛ yabhlo 'wʋ, we mnɩ, we yi, -mɔ yɛyɛ da, ladɩdaa datalɩe nya, we 'ka ladɩ. We 'nɩ da 'yɩɩ 'gbʋ, we nɛɛ we 'dɛ -ylaɛ: ‹Na -budu -we zɔ ɩn 'bhʋa, -mɔ na bhitia lʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Ɩn da we 'bhitia -mɔ lʋ, we yia -bha wee -budu ylɩ, -zugba we nʋkplɛ mɩ laylipeda, 'ɩn -mɔ mɩ lamnazɩda. ");
INSERT INTO kyf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tɔʋn, zuzu 'nyii gbesɔ ka nʋkplɛ -nyua 'yli bhabha, -we -zia wemʋ, 'ɩn we yia -mʋʋ 'bʋmnɩ. 'Ɩn we -yɔ we 'sɔ yia wee -budu zɔ lʋyi, dabʋdʋ. 'Ɩn we yia -mɔ ladɩ duaa. -Slɛɛn, 'ɩn ɔɔ nyɩmɛɛ -kwɩkwɩ yia 'ylinyumanɩ, 'ɩn we yia we tɩanʋ 'wʋzi.» ");
INSERT INTO kyf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Da -Zezu gba 'saa, 'ɩn 'ŋwnɔ yabhlo nɛɛ ɔ -yla, -mɔ nyɩma -nyɩdɩ wɛlɩ 'tɩtɛ nyaɛ: «'Ŋwnɔ -ɔ plaa -na nʋkpla, 'ɩn ɔ yia -mɩ 'nyɛnɩ, 'wʋtʋtʋe -dlɔɔ mɩ ɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Ɩn -Zezu yia we 'bɩgʋpalɩɛ: «A gba saɛ: nyɩma -wa pʋlʋa -Lagɔwɛlɩ yukwli, 'ɩn wa zʋa we 'nʋŋwɛ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Da nyɩmaa -zlo gbelia -Zezu, 'ɩn ɔ yia gbagbɩe bhli wa -ylaɛ: «Dɛslɛɛn -nyɩma mɩ nyɩma 'nyii nya. Ma yɩbhalɩa 'mɩ gwɛdigbʋ. Gwɛdigbʋ yabhlogbɔɔ 'na 'ka wa -yla lɛnʋ, 'mʋ we 'nɩ *Zonasɩɩ gbʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sa *Zonasɩ -zɛa we 'yli -slolunyɔ *Ninivʋ -nyɩma -yla, 'sa Nyɩmɛɛ 'Yu yia we 'yli -slolunyɔ -zɛa dɛslɛɛn -nyɩmaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sebaa 'wlulapɩlɩŋwnɔ 'bhʋa dʋdʋʋ bhloluda, 'ɩn ɔ yia *Salomɔɔɔ gbʋyilowɛlɩ yukwli pʋlʋa yi. Nɩɩ, nyɩmɛ -ɔ zia Salomɔɔ, ɔ mɩ da. We 'dɛɛ 'gbʋ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, 'ɩn ɔɔ 'ŋwnɔ sɔa 'wʋ dɛslɛɛn -nyɩma 'yu, 'ɩn ɔ dɩlɩa -maa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivʋ -nyɩma 'nʋa Zonasɩɩ wɛlɩ, 'ɩn wa yia wa dlɩ 'bhiti. Nɩɩ, nyɩmɛ -ɔ 'ylia -ɔ -zia Zonasɩ, ɔ mɩ da. We 'dɛɛ 'gbʋ, zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhua, 'ɩn Ninivʋ -nyɩma sɔa 'wʋ dɛslɛɛn -nyɩma 'yu, 'ɩn wa dɩlɩa -maa gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","-Zezu 'paa wa -yla gbʋʋ nine yabhlo 'ya, ɔ nɛɛ: «Nyɩmɛ -ka 'napɛ -nyuma, ɔ'ɔ zize we, 'ɩn ɔ'ɔ zʋ we -solu zɔ. Nɩɩ, yalɩ ɔ dɩa we la, 'ɩn -wa -ka -budu zɔ pla, 'ɩn wa yɩa we san -yɔ. ");
INSERT INTO kyf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","-Na 'yli mɩ -na kuu 'napɛ nya. We -ka nɩɩ, -na 'yli -yalɩ, -na ku -kpabhie mɩ zlɩ 'wʋ. We -ka -na 'yli ka gu -yɔ, -na ku mɩ nikpise 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɩɩ, -ɩn zʋ -na 'dɛ 'yliyɔ, zlɩ -we mɩa -mɩ 'wʋ, we 'na -zɛlɩ nikpise -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","-Na ku weee -ka zlɩ 'klʋ -mɩ, we kibhe 'nɩ nikpise 'wʋ -mɩ, we -kpabhie mɩa zlɩ 'klʋ. Sa 'napɛɛ san dolua -mɩ -yɔ la bɛblɛɛ, 'sa.» ");
INSERT INTO kyf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","-Zezu bhɩa gbagbɩe, Falizɩnyɩmɛ yabhlo yia ɔ la, ɔ -yɔ ɔ 'ka li. -Zezu plaa ɔ -budu zɔ, 'ɩn wa yia lilie bhli. ");
INSERT INTO kyf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falizɩnyɩmɛ 'yɩa nɩɩ, -Zezu 'nɩ kwɛ budo, 'ɩn ɔ yia lilie bhli, we yia ɔ ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nɩɩ, Nyɩmaa -Kanyɔ nɛɛ ɔ -ylaɛ: «Sa amɩa Falizɩnyɩma mɩa, mʋ nɩ: 'kɔpʋ -yɔ 'wʋliliknaa ku -yɔ a wɔlʋa, -zugba 'wie -yliylie -yɔ 'nyii mɩ amɩaa dibhe yeda. ");
INSERT INTO kyf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","-Gʋwʋtʋnya! -Lagɔ -ɔ nʋa -luu ku -yɔ lɛ, mɔ nʋa we nʋkplɛ lɛ 'ya, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","-Lu -we mɩa amɩaa 'kɔpʋ -yɔ amɩaa knanya 'wʋ, a 'nyɛ we bobabhanya. 'Ɩn we 'dɛ weee 'ka -mɔwlʋ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Amɩa Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! Amɩaa -titikpɩ weee -we mɛnɩa, 'matɩ -yɔ wluu 'bhisa, we kugbua -gʋ -bhlo a nyɛa -Lagɔ. 'Ɩn gbʋ tɩklɩɩnya -we nanɩa -Lagɔ dʋdʋ -yɔ amɩaa -Lagɔɔ zɛkalɩe, a ka we 'yli latlili, 'mʋ a 'ka yaa lɛnʋ tɩa. 'Ɩn a 'na dlʋlʋ -luu kugbua -gʋ -bhloo wlawlɩe 'wʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Amɩa Falizɩnyɩma, gbʋnyuu mɩ amɩaa -nʋ nya! -We ka gbʋ -wa, 'yugbɛɩn ladɩdɩe a 'yɩbhaa -Lagɔbudu zɔ. 'Ɩn a 'yɩbha, wa -sa aɩn fʋ -zejila 'wʋ amɩaa 'nʋŋwɛzʋzʋe nya. ");
INSERT INTO kyf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Gbʋnyuu mɩ amɩaa -nʋ nya! A 'wlʋ sa gbawla wa'a 'yɩ -yɔ, wa -ka we -gʋ nɔda -mɩ, wa 'nɩ we 'ji -yi.» ");
INSERT INTO kyf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","-Lagɔɔ titee gwesanyaa 'yabhlo nɛɛ -Zezu -ylaɛ: «Na -Slolunyɔ, -ɩn -ka 'sa gbada -mɩ, -amɩa -ɩn mɩ 'yaa vɛlɩda!» ");
INSERT INTO kyf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","-Zezu yia we 'bɩgʋpalɩɛ: «Titee gwesanya, gbʋnyuu mɩ 'ya amɩaa -nʋ nya! -We ka gbʋ -wa, 'gba 'kadʋ -we ka dɩdɩe -kalɩa -yɔ, 'mʋ a dɩa nyɩma 'wlu, 'ɩn amɩaa 'dɛɛ -kwɩtaya -bhlogbɔɔ'ɔ 'tlili we. ");
INSERT INTO kyf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Gbʋnyuu mɩ amɩaa -nʋ nya! -We ka gbʋ -wa, -Lagɔgbʋʋ -falɩpanyaa gbawla a paa, 'ɩn amɩaa didea 'bhaa wa. ");
INSERT INTO kyf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","-We a mɩa lɛnʋda, mʋ slolua we nɩɩ, -we amɩaa didea nʋa lɛ, we nanɩ aɩn dʋdʋ. Amɩaa dʋkpasɩ 'bhaa -Lagɔgbʋʋ -falɩpanya, 'ɩn amɩa mɩa wa gbawla 'pada. ");
INSERT INTO kyf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","We 'gbʋ, -Lagɔɔ Gbʋyilo nɛɛ: ‹Wa -gbɛ na yia gbʋʋ -falɩpanya -yɔ tietienya tiea. 'Ɩn -maa glaa tɔlʋa wa yia 'bhaa, 'ɩn wa 'ka tɔlʋa 'klɩyɩe 'wʋpalɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nɩɩ, we 'ka dʋdʋʋ gwedɩlɩda -yɔ 'bhʋ, -Lagɔgbʋʋ -falɩpanya wa 'bhaa, -wa ka 'pɩɔn wa jitea, wa 'pɩɔn -Lagɔ yia dɛslɛɛn -nyɩma layɩbhaa. ");
INSERT INTO kyf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tɩa, wa ka *Abɛlɩ 'bha, 'ɩn 'wʋbhloluda wa yia Zakalii 'bha, 'slakagʋsalɩlu -yɔ -Lagɔɔ -mɔwlʋda nyɩdɩ. Cɩɩn, ɩn nɛɛ aɩn -ylaɛ: dɛslɛɛn -nyɩma -Lagɔ yia we 'gba 'wlu dɩa. ");
INSERT INTO kyf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Amɩa titee gwesanya, gbʋnyuu mɩ amɩaa -nʋ nya! -We ka gbʋ -wa, -laklɩ -we kalɩa gbʋyilo ŋwɛɛ, 'mʋ a 'bhua 'wʋ, 'ɩn amɩaa 'dɛ 'nɩ -mɔ pla. 'Ɩn -mama 'yɩbhaa -maa 'ka -mɔ pla, 'ɩn a yia -maa 'yoo -kʋlʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Da -Zezu 'tlaa wee -budu zɔ, -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma yia ɔ -yɔ 'cɛ 'nyuu 'palɩ. 'Ɩn wa yia gbʋ duun ɔ layɩbha. ");
INSERT INTO kyf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ɔ zɔbhlibhlie nya, 'ɩn gbʋ -kpʋa wɛlɩ -ka ɔ ŋwɛɛ 'tla, wa 'ka we nya ɔ gbʋ -lueli. ");
INSERT INTO kyf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","We bhla, nyɩmaa 'wlu -nyacɩɩn yia 'wlugbeli -Zezu kwesi. Wa 'wʋzuloo 'gbʋ, bhʋ ladɩda'a 'yɩ. -Zezu nɛɛ ɔ 'bɩnɔnya -yla tɩaɛ: «A zʋ amɩaa 'dɛ 'yliyɔ Falizɩnyɩmaa 'flooo *gɔɔɔ gbɛgbɛɩn. Nɩɩ, wa wɛlɩ 'sɔ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nɩɩ, -we weee mɩa zizeda, zlɩ 'klʋ we yia 'tlaa, 'ɩn -we ka 'ji nyɩma 'nɩa -yi, 'ji wa yia we yibhelia. ");
INSERT INTO kyf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","We 'gbʋ, -we weee a gbaa nikpise 'wʋ, 'nʋa wa yia we zlɩ 'klʋ. 'Ɩn -we weee a ŋwuŋwea nyɩmɛ -yla komi lʋʋ, -budu 'wlu wa yia we wɩzɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","'Ɩn -Zezu nɛɛ 'yaɛ: «Na 'talea, ɩn nɛɛ amɩa -ylaɛ: -wa mnenia wa 'ka nyɩmɛɛ ku 'bha, 'ɩn wa 'nɩa we 'bɩgʋ gbʋ yabhlogbɔɔ lɛnʋe mneni, a 'na sɔlʋ wa -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","-Ɔ a 'kaa sɔ, 'mɔ na yia aɩn 'klʋslolua: a sɔ -Lagɔ, amɩaa tlɩtlɩe 'bɩgʋ, mɔ kaa we se, ɔ 'ka aɩn -kosu 'wʋ viteli. Cɩɩn, ɩn nɛɛ aɩn -ylaɛ: 'mɔ a 'kaa sɔ! ");
INSERT INTO kyf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Nyɩma 'yliya 'wʋ, bhuyua 'nɩ -valɛ -ka. Tama 'sɔ lʋ wa paa we gbu pɛlʋ. 'Ɩn -mʋʋ bhla, -Lagɔ'ɔ dlʋ we 'yabhlogbɔɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","-Lagɔ -yi amɩaa 'wluo nyii ŋwɛɛ. We 'gbʋ, a 'na nʋnʋ nyanɔ -nɩ. A 'yli -Lagɔ 'yliya 'wʋ, a 'ka bhuyuaa -zlo 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ɩn nɛɛ aɩn -ylaɛ: -ɔ -ka gba na daa -zejila 'wʋ, nɩɩ, ɔ mɩ na -nʋ nya, gbaa *Nyɩmɛɛ 'Yu yia ɔ daa, -Lagɔɔ 'anzɩnya 'yu, ɔ mɩ ɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","-Ɔ yia na gbʋ kpɛlɩa -zejila 'wʋ, nɩɩ, Nyɩmɛɛ Yu yia ɔ gbʋ kpɛlɩa -Lagɔɔ 'anzɩnya 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nyɔɔ -ka Nyɩmɛɛ 'Yuu daa wɛlɩ 'nyuu gba, -mɔɔ -yɔgbʋ -Lagɔ tɩa 'wʋ. Nɩɩ, -ɔ -ka Zuzu 'Pʋpa vɛlɩ, -Lagɔ 'na 'ka -mɔɔ -yɔgbʋ 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Wa -ka amɩaa -yɔgbʋ 'wʋbhua yi, wa -ka aɩn -Lagɔbudunya zɔ kwa, 'ɩn wa -ka aɩn nyɩmaa 'yugalɩnya -yɔ 'gbee 'wlulapɩlɩnya 'yu kwa, sa a 'kaa we amɩaa 'dɛ -gʋ -sa, 'ɩn -we a 'kaa gba, a 'na lʋlʋ we 'gbʋ dlɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nɩɩ, -we a 'kaa gba, we bhla, Zuzu 'Pʋpa yia we aɩn ŋwɛɛ zʋa.» ");
INSERT INTO kyf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","-Mɔ waa nyɩmaa -zlo nyɩdɩ, nyɩmɛ yabhlo nɛɛ -Zezu -ylaɛ: «Na -Slolunyɔ, -ɩn gba na bheli -yla, 'bɩ -amɩaa dide tɩa, ɔ dlili we, ɔ 'ka na -nʋ wla.» ");
INSERT INTO kyf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","-Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «'Tale, nyɔɔ palɩ 'mɩ la amɩaa gbʋwʋbhunyɔ -yɔ amɩaa zʋzɔnʋʋ dlinyɔ nya?» ");
INSERT INTO kyf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","-Mʋʋ 'bɩgʋ, ɔ nɛɛ wa 'dɛ weee -ylaɛ: «A zʋ amɩaa 'dɛ 'yliyɔ, 'ŋnɩmnɩluu dlɩ 'wʋnyninyniee gbɛgbɛɩn. Nɩɩ, 'yliyɔgagɩee 'dɛgbolu mɩa, we'e 'bhʋ nyɩmɛɛ 'ŋnɩmnɩluu -gbɛ, saa 'dɛ ɔ yi 'ŋnɩmnɩnyɔ 'kadʋ -zɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Ɩn -Zezu yia wa gbʋʋ nine yabhlo 'palɩɛ: «'Ŋnɩmnɩnyɔ yabhlo mɩ -bha, ɔ ka kpaanya -we tnʋa ɔ -yla duun. ");
INSERT INTO kyf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɔ pʋpalɩa 'wlukʋʋn la, ɔ yia ɔ 'dɛ layɩbhaɛ: ‹Sa ɩn 'ka da we nʋa? Da ɩn 'kaa na kpaa -li slu, -bha 'nɩ -mɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Ɩn ɔ yia we -gʋdɩɛ: ‹-We ɩn 'kaa lɛnʋ, mʋ nɩ! Na wlʋnya na yia -yɔmnazɩa, 'ɩn ɩn 'ka we 'wʋlaylimanɩ. 'Ɩn ɩn 'ka -mɔ na 'mnɔ -yɔ na -lu -zɔnʋʋ tɔlʋa slu. ");
INSERT INTO kyf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Ɩn na yia na 'dɛ -yla gbaaɛ: «Na nyɩmɛ, -ɩn ka zʋzɔnʋʋ -zlo, -zʋ duuun -nʋ nya. -Ɩn -dɩ la, -ɩn nyapɛ, -ɩn li, -ɩn 'ma, -ɩn li 'mʋna!» › ");
INSERT INTO kyf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Ɩn -Lagɔ nɛɛ ɔ -ylaɛ: ‹-Gʋwʋtʋnyɔ, -zɛɛn sabɔ -na tlɩa. 'Ɩn -we weee -ɩn gʋgwlalɩa 'wlu -na 'dɛ -yla, nyɔɔ -yla we 'ka -tʋa?› » ");
INSERT INTO kyf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","-Zezu yia we -gʋdɩɛ: «Nyɩmɛ -ɔ gʋgwlalɩa zʋzɔnʋnya 'wlu ɔ 'dɛ -yla, 'sa we mɩa ɔ -nʋ nya. 'Ɩn -mɔɔ 'nɩ 'ŋnɩmnɩnyɔ nya -mɩ -Lagɔ 'yliya 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Ɩn -Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «We 'gbʋ, ɩn nɛɛ aɩn -ylaɛ: -we a 'kaa li, 'ɩn a 'ka 'yliyɔgagɩe 'yɩ, a 'na lʋlʋ we 'gbʋ dlɩ -nɩ. 'Naanya a 'kaa 'wʋpla, a 'na lʋlʋ we 'gbʋ dlɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","-We ka gbʋ -wa, nyɩmɛɛ 'yliyɔgagɩe -zi lililu, 'ɩn nyɩmɛɛ ku -zi 'naa. ");
INSERT INTO kyf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","A yla 'ŋwaa: we'e 'pa 'mnɔ, 'ɩn we'e -dɩ we, 'ɩn we'e bʋblʋ we wlʋ 'wʋ. Nɩɩ, -Lagɔ nyɛa we lililu. Amɩa 'yli a -zi 'zianya! ");
INSERT INTO kyf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aɩn glaa, nyɔɔ mneni ɔ 'ka ɔ dlɩlʋe nya, ɔ 'yliyɔgagɩee 'ylɩ -gʋ palɩa? ");
INSERT INTO kyf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'Ɩn amɩa 'nɩa mneni, a 'ka wee -lu 'kienyilɛ -mɩnɩ lɛnʋ, lɛɛ ka 'gbʋ a lʋ we pnɩɩ 'gbʋ dlɩa? ");
INSERT INTO kyf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«A yla -fliisuu -bʋɩ: we'e nʋ lubho, 'ɩn we'e lʋa 'naa. Ɩn nɛɛ aɩn -yla nɩɩ: *Salomɔɔɔ 'dɛɛ 'ŋnɩmnɩe 'kadʋ 'wʋ, ɔ 'nɩ 'ylinanɔ -bana -bhlogbɔɔ 'yɩ suu -bʋɩnya nɩɩ 'yabhlo 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dlɩ 'kienyi -zʋnya! Su -we mɩa -flii -zɛɛn, 'ɩn wa 'kaa -kosu 'wʋ viteli cɩzɩ, -Lagɔ -ka sa -mʋʋ -kpeli, -zakpa zuma ɔ 'na 'ka 'sa amɩa -kpelia! ");
INSERT INTO kyf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","-We a 'kaa li, 'ɩn -we a 'kaa 'ma, a 'na sumanɩ amɩaa 'dɛɛ dlɩ -mʋʋ 'gbʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nɩɩ, dʋdʋgʋ -nyɩma weee, -wa 'nɩa -Lagɔ -yi, ma talɩa -luu da 'kɔmʋʋ. 'Ɩn amɩa mɩa, amɩaa Dide -Lagɔ -yi -we -wa amɩaa -yɔkpagbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","A -talɩ -Lagɔɔ amɩaa 'wlulapɩlɩe da tɩa, 'bhie, -Lagɔ 'ka aɩn -lu weee -mɩnɩ 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Na kwiiyua, a 'na nʋnʋ nyanɔ -nɩ. Nɩɩ, we nanɩ amɩaa Dide -Lagɔ dʋdʋ, ɔ 'ka aɩn ɔ nyɩmaa 'wlulapɩlɩe zɔ kwa. ");
INSERT INTO kyf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A 'pa amɩaa zʋzɔnʋnya pɛlʋ, 'ɩn a 'nyɛ we -yɔ -gwɛzi bobabhanya. 'Gwɛzi -bhɔtɔ -we'e -nyumɔa, a nʋ we lɛ. A gʋgwlalɩ amɩaa 'ŋnɩmnɩli 'wlu -Lagɔ kwesi, da we 'na 'kaa mnɔ. 'Wienya 'nɩ mneni wa 'ka we 'wʋbhu, 'ɩn ŋwɔnʋ 'nɩ mneni we 'ka we li. ");
INSERT INTO kyf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","-We ka gbʋ -wa, mɔ -na 'ŋnɩmnɩli mɩa, -mɔ -na dlɩ mɩa. ");
INSERT INTO kyf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«A mnazɩ amɩaa 'dɛ la, a jɩ -jlaa, amɩaa 'napɛ -tʋ -nyumada. ");
INSERT INTO kyf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Zɔlubhonʋnya mɩa wa -kanyɔ mnɩa 'ŋwnɔkwafɛtɩ -gʋ wʋda, a mɩ wa 'bhisa. Da ɔ -ka lʋyi, ɔ -ka kɔkɔ bhlɩ, 'ɩn wa 'ka -bha -kalɩ ɔ -yla -bha -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Zɔlubhonʋnya -manɩɩ -kanyɔ -ka wa 'yliyɔgada ylɩ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya! Ɩn nɛɛ aɩn -yla, gbʋzɔnʋ -wa: ɔ -jlaa ɔ yia jɩa, ɔ 'ka wa ladɩ, lililuu 'gbʋ. 'Ɩn ɔ 'ka we wa 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ɔ -ka lʋyi, -de zlɩ -nyɩdɩɩ, -de zlɩ -gʋʋ, ɔ -ka wa 'yliyɔgada ylɩ, 'wʋtʋtʋe -dlɔɔ mɩ wa -nʋ nya! ");
INSERT INTO kyf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","-We mɩa da, a 'nʋ we 'wʋla: bhla -we nya 'wienyɔ 'kaa yi, -buduu -kanyɔ -ka yaa we -yi, ɔ 'na 'ka ɔ 'yitide, ɔ 'ka ɔ -budu zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Amɩa, a mnazɩ amɩaa 'dɛ la 'yaɛ. Nɩɩ, bhla -we a 'nɩa -tɔlʋ, we nya Nyɩmɛɛ 'Yu yia yia.» ");
INSERT INTO kyf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piɛlɩ yia ɔ layɩbhaɛ: «Nyɩmaa -Kanyɔ, -amɩa -bhlo -na palɩa wee gbʋʋ nine yaayɩɩ, nyɩma weee -ɩn mɩa we 'palɩda yɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nyɩmaa -Kanyɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Ɔ -wa zɔlubhonʋnyɔ tɩklɩɩ, 'ɩn ɔ -yia gbʋ, sa ɔ mɩa? Mɔ -wa, -ɔ, ɔ -kanyɔ tɩa -budu -yɔ, ɔ 'ka we 'yliyɔzʋ. 'Ɩn lilibhla -ka bɛ, ɔ 'ka zɔlubhonʋnya tɔlʋa lililu 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Wʋtʋtʋe -dlɔɔ mɩ ɔɔ zɔlubhonʋnyɔɔ -nʋ nya. Ɔ -kanyɔ -ka lʋyi, 'ɩn ɔ 'ka ɔ 'yɩ, -zugba ɔ mɩ wee lubho nʋda. ");
INSERT INTO kyf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: ɔ -kanyɔ yia -mɔɔ zʋzɔnʋ weee ɔ yoo 'nyɛa, ɔ 'ka we 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","We -ka nɩɩ, ɔɔ zɔlubhonʋnyɔ nɛɛ dlɩ zɔɛ: ‹Na -kanyɔ mɩ -mɔ -gwlɛda.› 'Ɩn ɔ yia zɔlubhonʋnya -yɔ lubhonʋŋwnɩ tɔlʋa bhɩtɩe bhli, ɔ yia li, ɔ yia 'ma, 'ɩn ɔ yia ɔ 'dɛ nʋ 'bhalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'Ylɩ -we nya ɔɔ zɔlubhonʋnyɔ -mɔnɩ 'nɩa ɔ -kanyɔ wʋda -mɩ, 'ɩn bhla -we ɔ 'nɩa -tɔlʋ, we nya -mɔɔ yia yia. Vua ɔ -kanyɔ yia ɔ, 'ɩn ɔ 'ka ɔ -kaslʋ 'wʋpa. Sa -Lagɔ paa wa'a ŋwnua ɔ gbʋ -yɔ -kaslʋ 'wʋ, 'sa. ");
INSERT INTO kyf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Zɔlubhonʋnyɔ -ɔ -yia ɔ -kanyɔɔ dʋmagbʋ, 'ɩn ɔ'ɔ mnazɩa ɔ 'dɛ la, ɔ 'ka we lɛnʋ, gan -duun wa yia ɔ 'paa. ");
INSERT INTO kyf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Zɔlubhonʋnyɔ -ɔ 'nɩa ɔ -kanyɔɔ dʋmagbʋ -yi, 'ɩn ɔ nʋa gbʋnyuu lɛ, gan -sɛ wa paa ɔ. 'Ɩn nyɩmɛ -ɔ wa 'nyɛa -lu duun yoo, 'mɔ wa yia -lu duun layɩbhaa. 'Ɩn nyɩmɛ -ɔ kwɛɛ wa zʋa -lu duun la, 'mɔ wa yia -lu duun layɩbhaa bhabha. ");
INSERT INTO kyf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«-Kosu ɩn -laa dʋdʋ -gʋ, 'ɩn na dlɩ 'yɩbha 'yaa nɩɩ, we -nyuma -bha -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sɩasɩe -we -wa na batizee -gbʋ, we lɛnʋe ɩn mɩa wʋda dlɩlʋe nya. ");
INSERT INTO kyf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amɩa dlɩɩ nɩɩ, dʋdʋgʋ -nyɩma nyɩdɩ ɩn -laa 'wʋtʋtʋe -dlɔɔ yɩ? -Ɩnnya, ɩn nɛɛ aɩn -ylaɛ, -yɔbhʋbhlʋe ɩn -laa wa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","We 'bhʋ -zɛɛn 'wʋ, nyɩma gbu -ka -budu yabhlo zɔ -mɩ, -yɔ wa yia 'bhʋbhlʋa. Ta yia 'sɔ -yɔ gwe 'paa, 'ɩn 'sɔ 'ka ta -yɔ gwe 'pa. ");
INSERT INTO kyf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dide yia ɔ 'yu -yɔwʋsɔlʋa, 'ɩn 'yu 'ka ɔ dide -yɔwʋsɔlʋ. 'Nyaa yia ɔ 'ŋwnɔyu -yɔwʋsɔlʋa, 'ɩn 'ŋwnɔyu 'ka ɔ 'nyaa -yɔwʋsɔlʋ. 'Lowlii 'nyaa yia ɔ 'yuu 'ŋwnɔ -yɔwʋsɔlʋa, 'ɩn 'yuu 'ŋwnɔ 'ka ɔ 'lowlii 'nyaa -yɔwʋsɔlʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","-Zezu nɛɛ 'ya nyɩmaa -zlo -ylaɛ: «Da yalɩ -ka laylumanɩ, 'ɩn a gbaa -bha -bhlokpadɛ nyu yia lʋa, 'ɩn we lʋa 'saa 'piɛɩn . ");
INSERT INTO kyf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Ɩn da 'ylʋ -ka 'wʋsɔ zlʋkpɛ -papa, a nɛɛ: ‹Sloo yia yia›, 'ɩn we yi 'saa 'piɛɩn, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wɛlɩ 'sɔ -nyɩma! -We weee plɩa dʋdʋ -gʋ -yɔ yalɩ, a -yi we 'ji. 'Ɩn -we mɩa dɛslɛɛn 'plɩda, a'a 'nʋ -mʋʋ 'wʋ la! ");
INSERT INTO kyf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Lɛɛ ka 'gbʋ, gbʋ mɩa tɩklɩɩ a 'nɩ we 'wʋsɩsalɩda dayia? ");
INSERT INTO kyf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nyɩmɛ -ka -mɩ gbʋ 'wlu ladɩlɩ, ɔ -yɔ -mɩ 'sɔ -ka gbʋwʋbhunya 'yu mnɩda -mɩ, da a mɩa -slɔ 'yloogblʋ, -ɩn 'yɩ 'klɩ, -ɩn -yɔ ɔ 'sɔ 'ka gbʋ -bhɩa. Ɔ yi -mɩ gbʋwʋbhunyɔ 'yu kwa, 'ɩn -mɔɔ yi -mɩ 'slʋja yoo 'nyɛ, 'slʋja yi -mɩ -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ɩn nɛɛ -mɩ -ylaɛ: -ɩn 'nɩ -slɔ ɔ 'wʋbhlolu -su wla, -ɩn 'na 'ka -mɔ 'tla.» ");
INSERT INTO kyf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","We bhla, Galilee -nyɩma -wa mɩa 'slaka -sada, sa dʋdʋʋ 'wlulapɩlɩnyɔ Pilatɩ 'bhaa wa, 'ɩn nyɩma tɔlʋa yia we gbaa yi -Zezu -yla. ");
INSERT INTO kyf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Amɩa dlɩɩ nɩɩ, waa Galilee -nyɩma wa 'bhaa, ma -wa gbʋnyuu -lɛnʋnya, we 'ka Galilee -nyɩma tɔlʋa 'wʋzi yɩ? ");
INSERT INTO kyf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","-Ɩnnya, ɩn nɛɛ aɩn -ylaɛ, a 'nɩ amɩaa dlɩ 'bhiti, a 'dɛ weee yia tlɩa wa 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Ɩn nyɩma kugbua lɛ gbeta, -wa -gʋ Siloe we -wa tlʋlobudu 'kadʋ bhlilia, 'ɩn we yia wa 'bha, amɩa dlɩɩ nɩɩ, ma nʋa gbʋnyuu lɛ, ma -zia -Zeluzalɛmʋ -nyɩma tɔlʋa yɩ? ");
INSERT INTO kyf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","-Ɩnnya, ɩn nɛɛ aɩn -ylaɛ, a 'nɩ amɩaa dlɩ 'bhiti, a 'dɛ weee yia tlɩa wa 'bhisa.» ");
INSERT INTO kyf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","-Zezu 'pa 'yaa wa -yla gbʋʋ nine, ɔ nɛɛ: «Nʋkpasu yabhlo faa ɔ *-dlɔkpaa *figɩsu. 'Ylɩ yabhlo nya, ɔ yia we 'bhuee da mnɩ, 'ɩn ɔ 'nɩ we 'bhue yabhlogbɔɔ 'wlu ylɩ. ");
INSERT INTO kyf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tɔʋn, ɔ nɛɛ ɔ kpaaa lubhonʋnyaa -kanyɔ -ylaɛ: ‹-Ɩn yla, we -zʋ ta nɩ, -zugba na yi figɩsu -mɩnɩɩ 'bhuee da, ɩ'ɩn 'yɩ we 'bhue yabhlogbɔɔ. -Ɩn -dɩ we -gʋ! Lɛɛ ka 'gbʋ we klalɩ dʋdʋ 'wʋ bhea?› ");
INSERT INTO kyf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Ɔ kpaaa lubhonʋnyaa -kanyɔ nɛɛ ɔ -ylaɛ: ‹Na -kanyɔ, -ɩn tɩ -bha we, -zʋ -mɩnɩ nya -slɔ, ɩn 'ka we -yɔ 'bhlu, 'ɩn ɩn 'ka -ylikpee zɛnzɛnnʋ we gwe -yɔ slu. ");
INSERT INTO kyf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","-De we yi 'sa -mɔ tnʋ lʋgadaa. We 'nɩ tnʋ, 'ɩn -ɩn 'ka 'mɩ -yla gba, ɩn -dɩ we -gʋ.› » ");
INSERT INTO kyf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zuifʋʋ Nyapɛylɩ yabhlo nya, -zugba -Zezu mɩ nyɩma gbʋ -sloluda -Lagɔbudu yabhlo zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","We bhla, 'ŋwnɔ yabhlo kaa gu -yɔ, ɔ mɩ -bha. -Zʋ kugbua lɛ gbeta 'wʋ 'kwɛzuzu 'kwnaa ɔ 'wʋ, 'ɩn ɔ 'nɩ mneni ɔ 'ka 'wʋglo tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Da -Zezu 'yɩa ɔɔ 'ŋwnɔ -yɔ, ɔ yia ɔ la, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «A ka amaa gu kwɛɛ 'tla!» ");
INSERT INTO kyf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","-Zezu palɩa ɔ sɔ -gʋ la, -bha -bhlokpadɛ ɔ -gloa 'wʋ tɩklɩɩ, 'ɩn ɔ yia -Lagɔɔ 'ŋnɩ mnɩnɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","-Zezu ka 'ŋwnɔ -mɔnɩ jipe Zuifʋʋ *Nyapɛylɩ nyaa 'gbʋ, -Lagɔbuduu 'yugalɩnyɔ yia 'cɛ 'pa. Ɔ nɛɛ nyɩmaa -zlo -ylaɛ: «-A ka 'ylɩ gbelibhlo -a 'ka we nya lubho nʋ. A yi -mʋʋ nya amɩaa 'dɛ jipea. We 'na -zɛlɩ Nyapɛylɩ nya -nɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nyɩmaa -Kanyɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Wɛlɩ 'sɔ -nyɩma, Nyapɛylɩ nya a'a -sa amɩaa 'bhli -yɔ amɩaa -sokofalɩ lubhu we 'wʋlili -gbo -yɔ -bhlo -bhloo, 'ɩn a'a kwa we 'madaa, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Ɩn Ablaamʋʋ zʋayliŋwnɔ -mɔnɩ, 'mɔ -Saatan gbʋan, we -zʋ kugbua lɛ gbeta nɩ, ɩn nɛɛ aɩn -yla 'lee, we mɩ nɩɩ, wa 'ka ɔ -blo Nyapɛylɩ nyaa?» ");
INSERT INTO kyf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","-Zezu gbaa wɛlɩ -mɩnɩ, tɔʋn, zʋ yia ɔ tʋnyɩma weee 'bha. 'Ɩn -zugba gbʋ 'kadɩ weee ɔ mɩa lɛnʋda, nyɩmaa -zlo li we 'mʋna. ");
INSERT INTO kyf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","-Mʋʋ 'bɩgʋ, -Zezu nɛɛ: «Lɛɛ -lu -Lagɔɔ nyɩmaa 'wlulapɩlɩe -yɔ we 'wʋwlʋa, 'ɩn lɛɛ ɩn 'ka we 'wʋpalɩa? ");
INSERT INTO kyf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Su wa laa *mutadɩ, -we ka 'ya nyɩmɛ yabhlo glʋa ɔ kpaa, 'mʋ we -yɔ we 'wʋwlʋa: we mia, we yia su -zɛ, 'ɩn 'zianya yia we 'klɩya -nyɩdɩ lʋlʋ 'sʋbha.» ");
INSERT INTO kyf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","-Zezu nɛɛ 'yaɛ: «Lɛɛ -lu ɩn 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'wʋpalɩa? ");
INSERT INTO kyf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gɔɔ 'ŋwnɔ yabhlo slua 'floo -bhʋbhʋʋ kilo glʋ -bhlo 'ya gbu lʋ, ɔ bhɩtɩa we, 'ɩn we yia 'ylɩ, 'mʋ *-Lagɔɔ nyɩmaa 'wlulapɩlɩe -yɔ we 'wʋwlʋa.» ");
INSERT INTO kyf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","-Zezu mɩ -Zeluzalɛmʋ -gbɛɩn mnɩda, -zugba ɔ -yɔ nyɩmaa -sloluslolue mnɩ 'gbe 'kadɩ -yɔ 'gbe yua nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Ɩn nyɩmɛ yabhlo yia ɔ layɩbhaɛ: «Nyɩmaa -Kanyɔ, nyɩma -wa 'kaa gbʋ 'wʋbhʋ, wa 'na 'ka 'wʋzuu?» -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«A 'tɛmanɩ amɩaa 'dɛ la, a 'ka plalɩda poo 'wʋ 'plɩlɩ. Ɩn nɛɛ aɩn -yla, nɩɩ, nyɩma -duun yia -bhaa 'plɩlɩe laylaa, 'ɩn wa 'na 'ka we mneni. ");
INSERT INTO kyf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Da -buduu -kanyɔ -ka 'wʋsɔ, ɔ -ka ɔ -budu -gbalɩ, 'ɩn a tʋa 'pipee. A bhlia -buduu bhlɩbhlɩe, 'ɩn a gbaaɛ: ‹Nyɩmaa -Kanyɔ, -ɩn -kalɩ -bha -aɩn -yla.› We 'bɩgʋ ɔ yia 'palɩa aɩn -ylaɛ: ‹Ɩn 'nɩ amɩaa 'bhʋlʋda da -yi!› ");
INSERT INTO kyf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tɔʋn, 'ɩn a gbaa ɔ -ylaɛ: ‹-A -yɔ -mɩ 'sɔ ka li, 'ɩn -a yia 'ma dabʋdʋ, 'ɩn -ɩn yia -amɩaa 'gbee -gblɔgblʋ 'wʋ nyɩma -slolu!› ");
INSERT INTO kyf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gbaa ɔ yi 'yaa aɩn -ylaɛ: ‹Ɩn 'nɩ amɩaa 'bhʋlʋda da -yi. Amɩa weee nʋa gbʋnyuu lɛ, a vla 'mɩ gwe!› ");
INSERT INTO kyf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Da a yia *Ablaamʋ, *Izakɩ, *Zakɔbʋ -yɔ -Lagɔgbʋʋ -falɩpanya weee 'yɩa, -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ, 'ɩn wa 'ka amɩa 'pipee viteli, -bha a yia wia, 'ɩn a 'ka gla 'wʋli! ");
INSERT INTO kyf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","'Ylʋʋ 'wʋsɔlʋda, 'ylʋʋ bhlilida, 'ylʋʋ 'wʋsɔlʋdaa lilisɔlʋ -yɔ kɔpɛsɔlʋ, -mɔ nyɩma yia 'bhʋa, 'ɩn wa 'ka dabʋdʋ li -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","'Ɩn -slɛɛn da, -wa -gaa lʋ, tɔlʋa yia 'yuganya -zɛa, 'ɩn -wa -gaa 'yu, -maa tɔlʋa yia lʋganya -zɛa.» ");
INSERT INTO kyf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","We bhla, Falizɩnyɩma tɔlʋa bɛa -Zezu kwesi, 'ɩn wa nɛɛ ɔ -ylaɛ: «-Ɩn 'bhʋ da, -ɩn mnɩ da -putu. Nɩɩ, Ewlodʋ 'yɩbha ɔ 'ka -mɩ 'bha.» ");
INSERT INTO kyf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «A mnɩ, a gba -totoo -bho -nyɩmɛ mɩa nɩ -ylaɛ: zuzu 'nyii na vua, 'ɩn na jipea guzʋnya -zɛɛn -yɔ cɩzɩ. 'Ɩn we 'ylɩ taa zlɩ na bhɩa na lubho. ");
INSERT INTO kyf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nɩɩ, -zɛɛn, cɩzɩ -yɔ cɩzɩelʋ, we mɩ nɩɩ, ɩn zʋ na nɔnʋe 'yliyɔ. Nɩɩ, wa 'ka -Lagɔgbʋʋ -falɩpanyɔ 'bha 'gbe -putu -gʋ, we 'nɩ 'yli nanɩ, 'mʋ we 'nɩ -Zeluzalɛmʋ 'wʋbhʋ. ");
INSERT INTO kyf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«-Zeluzalɛmʋ -nyɩma, -Zeluzalɛmʋ -nyɩma, amɩa -wa bhaa -Lagɔgbʋʋ -falɩpanya, 'ɩn nyɩma -Lagɔ paa aɩn yoo, -wa bhaa wa gbɔkʋ 'wʋ. Bhla weee nya, sa nynu gʋgwlalɩa we 'yua 'wlu we -kapue zɔ, 'ɩn we gblia we -gʋ la, ɩn 'yɩbha ɩn 'ka 'sa aɩn 'wlugʋgwlalɩ, 'ɩn a 'nɩ we -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","We 'gbʋ, -Lagɔ yia amɩaa -budu 'kadʋ sɔlʋ lapalɩlɩa. 'Ɩn ɩn nɛɛ aɩn -ylaɛ: a 'na 'ka 'maslɛɛn 'mɩ 'yɩ tɩklɩɩ, 'ɩn bhla -we nya a 'kaa gba nɩɩ, ‹Nyɩmɛ -ɔ yia Nyɩmaa -Kanyɔɔ 'ŋnɩ nya, -Lagɔ ŋwna ɔ 'nyu la›, 'ɩn we bhla 'kaa nyni.» ");
INSERT INTO kyf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zuifʋʋ Nyapɛylɩ yabhlo nya, Falizɩnyɩmaa 'yugalɩnyaa 'yabhlo laa -Zezu ɔ 'dɛɛ -gbɛ, ɔ -yɔ ɔ 'ka li dabʋdʋ. -Zezu plaa ɔ -budu zɔ, -zugba Falizɩnyɩma -wa mɩa -bha, -maa yla ɔ tenyii. ");
INSERT INTO kyf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","-Zugba nyɩmɛ yabhlo kaa 'ylɩylɩgu -yɔ, -mɔɔ 'yligbe ɔ 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Ɩn -Zezu yia -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma layɩbhaɛ: «'Lee, -amɩaa tite nyɛ nyɩmɛ 'yoo yaayɩɩ, we'e 'nyɛ ɔ 'yoo, ɔ 'ka nyɩmɛ jipe Nyapɛylɩ nyaa?» ");
INSERT INTO kyf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Ɩn wa 'nɩ 'yɩbha wa 'ka we 'bɩgʋpalɩ. -Zezu 'bhitia ɔɔ guzʋnyɔɔ -gbɛ la, 'ɩn ɔ yia ɔ jipe. 'Ɩn ɔ nɛɛ ɔ -yla: -ɩn mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'Bhie, ɔ nɛɛ wa -ylaɛ: «Aɩn glaa -nyɩmɛ yabhlo, -de ɔ yuu, ɔ -ka -klɔ 'wʋbho, ɔ 'na 'ka -mɔ ɔ -saa, yaayɩɩ -de ɔ bhlii, we -ka -klɔ 'wʋbho, ɔ 'na 'ka -mɔ we -sa Nyapɛylɩ nyaa?» ");
INSERT INTO kyf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Da -Zezu gba 'saa, wa 'nɩ mneni wa 'ka we 'bɩgʋpalɩ ɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","-Wa wa laa wee 'fɛtɩ -gʋ, -wa mɩa 'bɩ -zɔnʋ 'wʋbhuda, -Zezu 'yɩa wa -yɔ, 'ɩn ɔ yia wa gbʋʋ nine -mɩnɩ 'palɩ: ");
INSERT INTO kyf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Da nyɩmɛ yabhlo -ka -mɩ la 'ŋwnɔkwafɛtɩ -gʋ, -ɩn -ka -mɔ nyni, -ɩn 'na -dɩlɩ 'bɩ -zɔnʋ mɩa 'yugbɛɩn -gʋ la -nɩ. -We ka gbʋ -wa, nyɩmɛ -ɔ ka -vacɩ -zia -mɩ, -de wa ka -mɔɔ laa! ");
INSERT INTO kyf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'Ɩn nyɩmɛ -ɔ laa a 'dɛ 'sɔ wee 'fɛtɩ -gʋ, ɔ -ka yi, 'ɩn ɔ 'ka -mɩ -yla gbaɛ: ‹-Ɩn 'nyɛ ɔ 'bɩ -mɩnɩ›, zʋ nya -na yia 'wʋsɔa, 'ɩn -ɩn 'ka lʋgbɛɩn ladɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nɩɩ, da nyɩmɛ -ka -mɩ la 'fɛtɩ -gʋ, -ɩn -ka -mɔ nyni, -ɩn mnɩ -ɩn -dɩ lʋgbɛɩn la. 'Ɩn -ɔ laa -mɩ da ɔ -ka yi, 'ɩn ɔ 'ka -mɩ -yla gba: ‹'Tale, yi, -ɩn 'ka 'bɩ -zɔnʋ -gʋ ladɩ.› Tɔʋn, 'ɩn -mʋʋ ylimanɩa -na 'ŋnɩ, nyɩma -wa -ɩn -yɔ wa 'sɔ mɩa lililu gwe 'yliya 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nɩɩ, nyɩmɛ -ɔ ylimanɩa ɔ 'dɛ, zɔ -Lagɔ yia ɔ bɛlɩa, 'ɩn nyɩmɛ -ɔ bɛlɩa ɔ 'dɛ zɔ, 'ylimanɩa -Lagɔ yia ɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","'Bhie -Zezu nɛɛ -ɔ laa ɔ -ylaɛ: «Da -ɩn -ka lililu lɛnʋ, -ɩn 'na lalɩ -na 'talea, -na bhelia, -na zʋaylinyɩma -yɔ -na -lima 'ŋnɩmnɩnyaa 'dɛkpʋa -nɩ. Nɩɩ, zlɩ wanʋʋ 'ylɩ -ka nyni wa -ka -mɩ la, -zugba -we -ɩn nʋa lɛ we 'bɩgʋ wa 'palɩa. ");
INSERT INTO kyf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nɩɩ, -ɩn -ka 'fɛtɩɩ lililu lɛnʋ, -ɩn la bobabhanya, 'kukunya, 'tɩgɩtɩgɩnya -yɔ 'lɔlɔnya. ");
INSERT INTO kyf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nɩɩ, -ɩn -ka 'sa nʋ, -zugba, 'wʋtʋtʋe -dlɔɔ mɩ -na -nʋ nya. Wa 'nɩ mneni wa 'ka -mɩ -lu yabhlogbɔɔ 'nyɛ we 'bɩgʋ. Nɩɩ, -Lagɔ yia we 'bɩgʋpalɩa -mɩ -yla. Da nyɩma tɩklɩɩ yia tlɩtlɩnya glaa 'wʋsɔa, we zlɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","-Mʋʋ 'bɩgʋ, nyɩma -wa mɩa lililu gwe, wa glaa -nyɩmɛ yabhlo 'nʋa wɛlɩnya -mɩnɩ, ɔ nɛɛ -Zezu -ylaɛ: «Nyɩmɛ -ɔ yia lia -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ, 'wʋtʋtʋe -dlɔɔ mɩ -mɔɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","-Zezu nɛɛ ɔ -ylaɛ: «Nyɩmɛ yabhlo -saa 'fɛtɩ 'kadʋ, 'ɩn ɔ yia nyɩma duun la. ");
INSERT INTO kyf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lilibhla bɛa, 'ɩn ɔ yia ɔ zɔlubhonʋnyɔ yabhlo tie, ɔ gba -wa ɔ laa -ylaɛ: ‹A yi, nɩɩ, lililuu pipie ka bhɩa.› ");
INSERT INTO kyf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«'Ɩn wa 'dɛ weee yia gbagbɩe bhli -bhlo -bhlo nɩɩ, ‹-Ɩn tɩ -amɩaa -yɔgbʋ 'wʋ›. Tɩanʋ nɛɛ ɔɔ zɔlubhonʋnyɔ -ylaɛ: ‹Ɩn ka kpaa yabhlo zɔ, 'mʋ na mnɩa 'yɩa -kpɔ. We 'gbʋ, -mɩ na bhubhoe, -ɩn tɩ na -yɔgbʋ 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Ɩn 'yabhlo nɛɛ ɔ -ylaɛ: ‹Ɩn ka 'bhli kugbua zɔ, 'mʋ na mnɩa laylalɩa. -Mɩ na bhubhoe, -ɩn tɩ na -yɔgbʋ 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","-Bʋdʋ nɛɛ 'ya ɔ -ylaɛ: ‹Dɛslɛɛn na bhʋa da 'ŋwnɔ kwada. We 'gbʋ, ɩn 'nɩ mneni ɩn 'ka mnɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Zɔlubhonʋnyɔ 'bhitia lʋ ɔ -kanyɔɔ -gbɛ, 'ɩn ɔ yia we 'bɩgʋ -dɩnya ɔ -salɩ. 'Ɩn -buduu -kanyɔ yia 'cɛ -papɩe bhli. 'Ɩn ɔ nɛɛ ɔ zɔlubhonʋnyɔ -yla: ‹-Ɩn mnɩ 'gbe nʋkplɛ slʋɩ, -mɔ we -gblɔgblʋnya -yɔ we -gwelenya -gʋ, -ɩn -yɔ bobabhanya, 'kukunya, 'lɔlɔnya -yɔ 'tɩgɩtɩgɩnya yi.› ");
INSERT INTO kyf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","-Mʋʋ 'bɩgʋ, zɔlubhonʋnyɔ yia, 'ɩn ɔ nɛɛ: ‹Na -kanyɔ, -we -ɩn gbaa ɩn nʋ lɛ, ɩn ka we lɛnʋ. 'Ɩn 'bɩɩ tɔlʋa yi 'yaa 'wʋtʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Ɩn -buduu -kanyɔ nɛɛ ɔ zɔlubhonʋnyɔ -ylaɛ: ‹-Ɩn mnɩ, -ɩn 'plɩlɩ -gwelenya -gʋ, we -yɔ kpaa -yoonya 'wʋ, 'ɩn -wa -ɩn -ka 'yɩ, -ɩn gba wa -yla -gla nya, wa yi na -gbɛ. 'Ɩn na -budu 'ka ye. ");
INSERT INTO kyf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ɩn nɛɛ aɩn -ylaɛ: waa tɩanyɩma -wa ɩn laa, wa 'yabhlogbɔɔ 'na 'ka na 'fɛtɩ -gʋ -lu li.› » ");
INSERT INTO kyf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nyɩmaa -zlo -yɔ -Zezu mɩ 'yloogblʋ nʋda, ɔ 'bhitia wa -gbɛ, 'ɩn ɔ nɛɛ wa 'dɛ weee -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nyɩmɛ -ɔ -ka 'mɩ 'bɩ yi, ɩn namanɩ ɔ dʋdʋ, we 'ka ɔ dide, ɔ 'nyaa, ɔ 'ŋwnɔ, ɔ 'yua, ɔ bhelia, ɔ bhɔlɔa -yɔ ɔ 'dɛbhie -gbolu 'wʋzi. We 'nɩ -mʋʋʋ, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ɩn nyɩmɛ -ɔ 'nɩ ɔ sɩasɩee *su 'wʋbhu, ɔ 'ka 'mɩ 'bɩ yi, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Nɩɩ, amɩaa lʋ -nyɩmɛ -mɔmɔ, -ɔ gba ɔ 'ka -budu 'kadʋ 'sʋbha, 'ɩn ɔ'ɔ -dɩ la, ɔ'ɔ zɛlɩ 'gwɛzi -we mɩa ɔ kwɛɛa? 'Ɩn -de wee 'gwɛzi mneni we 'ka wee -budu bhɩaa? 'Ɩn ɔ'ɔ yibheli we 'jia? ");
INSERT INTO kyf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","We 'nɩ -mʋʋʋ, ɔ -ka wee -buduu gwe glu palɩ, ɔ sɔ -ka we 'sʋbhasʋbhee -yɔbhɩalɩ, -wa weee yia -bha 'yɩa, 'ɩn wa bhlia ɔ nyanɩe? ");
INSERT INTO kyf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Gbaa wa yiaɛ: ‹Nyɩmɛ -mɔnɩ bhlia -buduu sʋbhasʋbhee, 'ɩn ɔ sɔ yia we -yɔbhɩalɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«'Sa -bhlokpadɛ, nyɩmaa 'wlulapɩlɩnyɔ yabhlo kaa 'slʋja 'wlu glʋ 'sɔ 'wlu kugbua, ɔ -ka gba, ɔ 'ka nyɩmaa 'wlulapɩlɩnyɔ -putu -ɔ kaa ɔnʋʋ 'slʋja -zakpa 'sɔɔ -gbɛ tʋ kwa, la ɔ dɩa, 'ɩn ɔ yɩbhaa ɔ 'dɛ la: ‹'Lee, ɩn mneni ɩn -yɔ ɔ 'ka tʋ gʋʋ?› ");
INSERT INTO kyf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","We -ka ɔ 'nɩ we mneni, 'ɩn ɔ tiea nyɩma, nyɩmaa 'wlulapɩlɩnyɔ -mɔnɩɩ -gbɛ. Da -mɔɔ -tlʋlʋa -slɔ ɔ -yɔ la, 'ɩn ɔ 'ka -mɔɔ -yla gba 'wʋtʋtʋe -dlɔɔ -tʋ wa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","«'Sa -bhlokpadɛ, nyɔɔo nyɔɔ -ka amɩaa lʋ -nyɩmɛ nya -mɩ, ɔ 'nɩ ɔ -kakalu weee -blɩ -gʋ 'palɩ, ɔ 'nɩ mneni ɔ 'ka na 'bɩnɔnyɔ -zɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Ɩn -Zezu yia we -gʋdɩɛ: «Gumu mɩa, -lu -zɔnʋ -wa. 'Ɩn gumu -ka 'nʋŋwɛ 'bhʋ, sa wa 'ka we namanɩa? ");
INSERT INTO kyf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","We 'nɩ 'ylinanɩ, dʋdʋʋ -nʋ nya, we 'nɩ 'ylinanɩ -ylikpeduduu -nʋ nya. 'Pipee wa vitelia we. «-Ɔ -ka we 'nʋnʋ -yukwli 'wlu -ka, ɔ 'nʋ we.» ");
INSERT INTO kyf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Ylɩ yabhlo nya, *nisʋn -gwɛzisanya -yɔ gbʋnyuuu kwɛ -cɩan tɔlʋa bɛa -Zezu kwesi, wa 'ka ɔ wɛlɩ yukwli pʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Falizɩnyɩma -yɔ -Lagɔɔ titee gwesanya saa -Zezuu 'ŋnɩ, wa nɛɛ: «Nyɩmɛ -mɔnɩ kpaa gbʋnyuuu kwɛ -cɩan sɔ 'sɔ nya, 'ɩn ɔ -yɔ wa lia dabʋdʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Ɩn -Zezu yia wa gbʋʋ nine -mɩnɩ 'palɩ: ");
INSERT INTO kyf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Amɩaa lʋ -nyɩmɛ yabhlo -ka bhlabhlɛɛ glʋ gbu -ka, we lʋ -bhlabhlɛ yabhlo -ka mnɔ, ɔ 'nɩ mneni ɔ 'ka we glʋ -mnʋa 'ya kugbua lɛ gbomnʋa lida tɩɩ? Ɔ 'ka wee -bhlo mnɔa 'ylibɩlanɔnʋa mnɩ, 'ɩn ɔ ka we 'yɩɩ? ");
INSERT INTO kyf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Ɩn da ɔ 'yɩa wee bhlabhlɛ, ɔ dlɩ namanɩa, ɔ yia we -blɩ gba lapalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔ nynia ɔ -buduŋwɛɛ, tɔʋn, ɔ laa ɔ 'talea -yɔ ɔ ladɩnya, 'ɩn ɔ nɛɛ wa -ylaɛ: ‹A -yɔ 'mɩ 'sɔ li 'mʋna. Nɩɩ, na bhlabhlɛ mnɔa, ɩn ka we 'yɩ!› ");
INSERT INTO kyf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","«Ɩn nɛɛ aɩn -yla, 'sa -bhlokpadɛ, gbʋnyuu -lɛnʋnyɔ yabhlogbɔɔ 'bhʋa ɔ gbʋnyuu 'bɩɩ 'gbʋ, 'mʋna 'kadʋ mɩ yalɩ. Nyɩma tɩklɩɩɩ glʋ -mnʋa 'ya kugbua lɛ gbomnʋa, -wa pʋpalɩa 'wlukʋʋn la nɩɩ, wa gbʋ 'nɩ dlɩɩ 'bhiti gbʋ 'wʋlapɩlɩ, wee 'mʋna -zi wa -nʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Yaayɩɩ, 'ŋwnɔ yabhlo kaa 'gwɛzi tama kugbua, 'ɩn we 'yabhlo -ka mnɔ, ɔ 'nɩ mneni ɔ 'ka 'napɛ -nyuma, 'ɩn ɔ 'ka -budu zɔ laylipe, ɔ 'ka we datalɩ ylɛlɛɛ, 'ɩn ɔ 'ka we 'yɩɩ? ");
INSERT INTO kyf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Ɩn da ɔ 'yɩa wee 'gwɛzii tama -bhlo, ɔ laa ɔ 'talea -yɔ ɔ ladɩnya, 'ɩn ɔ nɛɛ wa -ylaɛ: ‹A -yɔ 'mɩ 'sɔ li 'mʋna. Nɩɩ, na 'gwɛzi tama -bhlo mnɔa, ɩn ka we 'yɩ!› ");
INSERT INTO kyf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","«Ɩn nɛɛ aɩn -yla 'sa -bhlokpadɛ, gbʋnyuu -lɛnʋnyɔ yabhlogbɔɔ 'bhʋa ɔ gbʋnyuu 'bɩɩ 'gbʋ, 'mʋna 'kadʋ mɩ -Lagɔɔ 'anzɩ nyɩdɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","-Zezu nɛɛ 'yaɛ: «Nyɩmɛ yabhlo ka nʋkpasiyua 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Bɩsʋbhayu nɛɛ ɔ dide -ylaɛ: ‹Dide, -na 'bɩ -ɩn 'ka yaa -aɩn -yɔ tɩ nɩ, -ɩn dlili we, 'ɩn -ɩn 'ka na -nʋ wla.› 'Ɩn wa dide yia wee 'bɩ ɔ 'yua sɔbhie 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«'Ylɩ 'sɔ -lɛ 'plɩa, 'ɩn ɔɔ nyimeslɔyu yia ɔnʋʋ wee 'bɩ pɛlʋ 'pa. Ɔ 'bhua we 'gwɛzi 'wʋ, 'ɩn ɔ yia dʋdʋ -putu -gʋ mnɩ 'pɩpɩ. -Mɔ ɔ -nyumɔnʋa wee 'gwɛzi, pʋɩnplagbʋʋ lɛnʋe nya. ");
INSERT INTO kyf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Da ɔ bhɩa ɔ 'gwɛzi weee nyumoe, 'ɩn ŋwɔ 'kadʋ yia wee dʋdʋ -gʋ yi. Tɔʋn, ɔ 'nɩ lililu -kaa 'gbʋ, 'ɩn ŋwɔ yia ɔ 'bhabhɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","-Bha ɔ mnɩa -slɛɛn wee dʋdʋ -gʋʋ nyɩmɛ yabhloo -gbɛ lubho nʋa. 'Ɩn -mɔɔ yia ɔ -mɔɔ kpaa kwa, ɔ 'ka -bobo ŋwɛkʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ɔ 'yɩbha yaa gwesi -we -bobo lia, ɔ 'ka we li. 'Ɩn nyɩmɛ yabhlogbɔɔ'ɔ 'nyɛ we ɔ. ");
INSERT INTO kyf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Tɔʋn, ɔ dlɩ -saa ɔ zukpa, 'ɩn ɔ nɛɛ: ‹Na didee lubhonʋnya ka lililu duun, wa 'nɩ mneni, wa 'ka we li. 'Ɩn, -zugba, -amɩ, na tlɩ ŋwɔ nya -seli. ");
INSERT INTO kyf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Didee -gbɛ na yia lʋbhitia, 'ɩn ɩn 'ka ɔ -yla gbaɛ: «Dide, ɩn ka gbʋnyuu lɛnʋ -Lagɔ -yla, 'ɩn ɩn yia -mɩ -yla we lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ɩn 'nɩ -slɛɛn we 'klʋ -ka, -ɩn 'ka 'mɩ la -na 'yu. Nɩɩ, 'bhu 'mɩ 'wʋ -na lubhonʋnyaa 'yabhlo 'bhisa.» › ");
INSERT INTO kyf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ɔ -sɔa 'wʋ, 'ɩn ɔ yia ɔ didee -gbɛ lʋbhiti. «Da ɔ -tlʋlʋa -slɔ -buduŋwɛɛ -yɔ la, ɔ dide yia ɔ -yɔyɩ. 'Ɩn nyazɩ yia ɔ 'wʋ yi bhabha, ɔ -yɔ -gwagwɩe mnɩa ɔ yoo, 'ɩn ɔ yia ɔ gbleli. ");
INSERT INTO kyf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tɔʋn, ɔ 'yu nɛɛ ɔ -ylaɛ: ‹Dide, ɩn ka -Lagɔ -yla gbʋnyuu lɛnʋ, 'ɩn, ɩn yia -mɩ -yla we lɛnʋ. Ɩn 'nɩ -slɛɛn we 'klʋ -ka, -ɩn 'ka 'mɩ la -na 'yu.› ");
INSERT INTO kyf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«'Ɩn ɔ dide nɛɛ ɔ zɔlubhonʋnya -yla: ‹A 'pulo! A -la ɔ 'ylinanɔ -bana yabhlo. A -pla we ɔ 'wʋ, a fa ɔ sɔwʋlu sɔ 'wʋ, a -pla ɔ -sakwla bhʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'Bhli -dɔgbʋ palɩa dɛ 'kpɩ, a -yɔ we yi. A 'bha we, 'fɛtɩ -wa! -A 'ka li! ");
INSERT INTO kyf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nɩɩ, na yu mɩa da, ɔ ka tlɩ, 'ɩn ɔ yia ganɔ, ɔ ka mnɔ, 'ɩn ɩn yia ɔ 'yɩ.› 'Ɩn wa yia 'fɛtɩ -sasɩee gwedɩ. ");
INSERT INTO kyf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«We bhla, -zugba ɔ 'yu kpasa mɩ lubho nʋda kpaa. Ɔ mɩ -zɔɔ yida, da ɔ cɩpaa -buduŋwɛɛ, 'ɩn ɔ yia lʋʋ -yɔ -lilii wɛlɩ 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɔ laa zɔlubhonʋnyɔ yabhlo, 'ɩn ɔ yia ɔ layɩbha: ‹'Lee, lɛɛ -lu nʋ lɛa?› ");
INSERT INTO kyf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Zɔlubhonʋnyɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹-Na bheli yia lʋ, we 'gbʋ, 'kpɩkabhlii -dɔgbʋ -a 'sialɩa, 'ɩn -na dide yia we 'bha. -We ka gbʋ -wa, ɔ ka 'kʋayli, 'ɩn ɔ yia ɔ 'yɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«'Ɩn ɔɔ 'yu kpasa yia 'cɛ 'pa, ɔ nɛɛ ɔ 'nɩa -buduŋwɛɛ nyni. Ɔ dide 'tlaa, 'ɩn ɔ yia ɔ bhubhoe nɩɩ, ɔ mnɩ -buduŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Ɩn 'yu yia we 'bɩgʋpalɩ ɔ dide -ylaɛ: ‹-Talɩ, ɩn ka -mɩ -yla lubho nʋ -zʋ duun nya. Ɩn 'nɩ -slɔ -na wɛlɩ yabhlogbɔɔ 'nʋŋwɛ -sa. 'Ɩn -zugba, -ɩn 'nɩ -slɔ -amɩ wliyu yabhlogbɔɔ 'nyɛ, ɩn -yɔ na -lima 'ka 'fɛtɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","-Na 'yu -ɔ -nyumɔa -na -li 'naabɩzɩŋwnɩ nya nɩ, mɔ yia lʋʋ 'gbʋ, 'ɩn -ɩn yia 'kpɩkabhlii -dɔgbʋ 'kadʋ -a 'sialɩa nɩ 'bha!› ");
INSERT INTO kyf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Ɔ dide nɛɛ ɔ -ylaɛ: ‹Na 'yu, -mɩ -yɔ 'mɩ mɩ 'ylɩ weee nya. -Lu weee ɩn kaa, we mɩ 'ya -na -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nɩɩ, -na bheli -na yɩa da -yɔ, ɔ ka tlɩ, 'ɩn ɔ yia ganɔ. Ɔ ka mnɔ, 'ɩn ɩn yia ɔ 'yɩ. We 'gbʋ, -a mneni, -a 'ka 'fɛtɩ 'kadʋ -sa 'mʋna nya.› » ");
INSERT INTO kyf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","-Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «'Ylɩ yabhlo nya, 'ŋnɩmnɩnyɔ yabhlo ka ɔ zʋzɔnʋʋ 'yliyɔzʋnyɔ yabhlo, 'ɩn nyɩma yia ɔ -yla fɛn 'tʋbhʋa mnɩ nɩɩ: ‹-Na zʋzɔnʋʋ 'yliyɔzʋnyɔ mɩ -na zʋzɔnʋ -nyumɔda.› ");
INSERT INTO kyf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tɔʋn, ɔ yia ɔ zʋzɔnʋʋ 'yliyɔzʋnyɔ la, 'ɩn ɔ nɛɛ ɔ -ylaɛ: ‹Ɩn ka 'dɩ 'nyuu 'nʋ -na gbɛgbɛɩn. Lubho -we -ɩn nʋa, -ɩn -slolu 'mɩ we 'klʋ. -We ka gbʋ -wa, -ɩn 'na 'ka -slɛɛn na zʋzɔnʋʋ 'yliyɔzʋnyɔ -zɛ.› ");
INSERT INTO kyf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«'Ɩn ɔɔ lubhonʋnyɔ nɛɛ ɔ 'dɛ dlɩ zɔɛ: ‹Na -kanyɔ -ka 'mɩ kwnɛɛ -sa, sa ɩn 'ka we nʋa? Ɩn 'nɩ latɛ, ɩn 'ka kpaalubho nʋ. 'Ɩn, ɩn 'ka -kʋn, zʋ -mʋʋ bhalɩa 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa! Da na -kanyɔ -ka 'mɩ kwnɛɛ -sa, -we ɩn 'kaa lɛnʋ, 'ɩn nyɩma tɔlʋa 'ka 'mɩ 'bɩ 'nyɛ, ɩn -yi we!› ");
INSERT INTO kyf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«'Ɩn -wa ɔ -kanyɔɔ kpagbʋ mɩa 'wlu, ɔ yia wa la -bhlo -bhlo. Ɔ yia tɩanʋ la, 'ɩn ɔ nɛɛ -mɔɔ -ylaɛ: ‹Na -kanyɔɔ kpagbʋ zuma mɩ -mɩ 'wlua?› ");
INSERT INTO kyf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«-Mɔɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹'Kpɩ -balii glʋ gbu mɩa 'mɩ 'wlu.› «'Ɩn ɔ nɛɛ -mɔɔ -ylaɛ: ‹-Na 'sɛbhɛ nɩ, -ɩn -dɩ la slʋɩ, -ɩn cɛlɩ glʋ 'sɔ 'ya kugbua.› ");
INSERT INTO kyf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«-Mʋʋ 'bɩgʋ, 'ɩn ɔɔ lubhonʋnyɔ yia 'yabhlo layɩbhaɛ: ‹'Ɩn -mɩ, kpagbʋ zuma -ɩn ka 'wlua?› «'Ɩn -mɔɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹'Mnɔ bii glʋ gbu.› «Ɔ nɛɛ ɔ -ylaɛ: ‹-Na 'sɛbhɛ nɩ, -ɩn cɛlɩ glʋ -mnʋa.› ");
INSERT INTO kyf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Nɩɩ, -luu 'yliyɔzʋnyɔ 'nyuuu -kanyɔ yia ɔ 'ŋnɩ kwalɩ ɔ nacɩkakɩe 'gbʋ.» 'Ɩn -Zezu yia we 'wlubha, gbagbɩe nyaɛ: «Nɩɩ, dʋdʋ nɩ -gʋ -nyɩma ka nacɩ 'nyuu wa 'dɛkpʋa nyɩdɩ, we 'ka zlɩ 'klʋ -nyɩma -zi.» ");
INSERT INTO kyf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","-Zezu yia we -gʋdɩɛ: «Ɩn nɛɛ aɩn -ylaɛ: a dɩlɩ nyɩma 'tale, dʋdʋgʋʋ 'ŋnɩmnɩlu nya. Zlɩ we yia aɩn 'wʋbɔa, 'ɩn wa 'ka amɩaa 'lakpasu kpa, -Lagɔɔ -zɔɔ. ");
INSERT INTO kyf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Nyɩmɛ -ɔ mɩa tɩklɩɩ -li yua -sɛsɛɛ lɛnʋda, ɔ tɩklɩɩ 'ya -li 'kadɩɩ lɛnʋda. Nyɩmɛ -ɔ 'nɩa -mɩ tɩklɩɩ -li yua -sɛsɛɛ lɛnʋda, ɔ 'nɩ 'ya tɩklɩɩ -mɩ -li 'kadɩɩ lɛnʋda. ");
INSERT INTO kyf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A 'nɩ -mɩ tɩklɩɩ, 'ɩn a 'ka dʋdʋ -gʋʋ 'ŋnɩmnɩli -we bhʋa la kpa, nyɔɔ 'ka aɩn 'ŋnɩmnɩlu -zɔnʋ yoo 'nyɛa? ");
INSERT INTO kyf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Ɩn a 'nɩ -mɩ tɩklɩɩ, a 'ka nyɩma -putuu -lu kpa sa -yibheli, -we -wa amɩaa -nʋ, nyɔɔ 'ka we aɩn 'nyɛa? ");
INSERT INTO kyf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Lubhonʋnyɔ yabhlogbɔɔ 'nɩ mneni ɔ 'ka -cɩan 'sɔ -yla lubho nʋ. Nɩɩ, 'yabhlo ɔ yia 'wʋnyɛa, 'ɩn ɔ 'ka -bhloo zɛkalɩ. 'Yabhlo -yɔ ɔ yia lanɛa, 'ɩn -bhlo 'ka ɔ dʋdʋnyumanɩ. A 'nɩ mneni a 'ka -Lagɔ -yɔ 'gwɛzi -yla lubho nʋ dabʋdʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","'Gwɛzi nanɩ Falizɩnyɩma dʋdʋʋ 'gbʋ, wa 'nʋa wɛlɩnya -mɩnɩ, -zugba wa palɩ -Zezu gla. ");
INSERT INTO kyf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","-Zezu nɛɛ wa -ylaɛ: «Amɩa nʋa amɩaa 'dɛ nyɩma tɩklɩɩ 'wʋ nyɩma 'yliya 'wʋ, 'ɩn -Lagɔ -yi amɩaa dlɩ. Nɩɩ, -we mɩa 'kadʋʋ nyɩma 'yliya 'wʋ, 'wʋ -Lagɔ nyɛa we. ");
INSERT INTO kyf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«We 'ka 'Zan -Batisɩɩ bhla ylɩ, -zugba Moizɩɩ titee 'sɛbhɛ -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ mɩ la. We 'ka wee bhla 'wʋbhʋ, -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ wa gba. 'Ɩn nyɩma duun gʋa la, wa 'ka we zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nɩɩ, yalɩ -yɔ dʋdʋ mneni we 'ka labhʋ. 'Ɩn titee cɛlɩlɩɩ 'ya yabhlogbɔɔ 'nɩ mneni we 'ka 'sa labhʋ. ");
INSERT INTO kyf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Nyɩmɛ -ɔ -ka ɔ 'ŋwnɔ kwnɛɛ -sa, ɔ -ka 'ŋwnɔ -putu kwa, gbʋnyuu ɔ nʋa lɛ. 'Ɩn -ɔ -ka kwnɛɛsaŋwnɔ kwa, gbʋnyuu -mɔɔ nʋa lɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","-Mʋʋ 'bɩgʋ, -Zezu yia wa gbʋʋ nine -mɩnɩ 'palɩ: «'Ŋnɩmnɩnyɔ yabhlo mɩ bhaa, 'ylinanɔ -naanya ka -valɛ 'tɛa, 'mʋ ɔ plaa 'wʋ. 'Ɩn 'ylɩ weee zlɩ, ɔ saa 'fɛtɩ 'mʋna nya. ");
INSERT INTO kyf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","-Mʋʋ bhla, bobabhanyɔ yabhlo wa laa -Lazalɩ, -ɔ ka ku 'gbia 'bhua la, -mɔɔ pɩ ɔɔ 'ŋnɩmnɩnyɔɔ -buduŋwɛɛ la. ");
INSERT INTO kyf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","'Ɩn lililunya -we bhlia ɔɔ 'ŋnɩmnɩnyɔɔ 'tabhle zɔ, -Lazalɩ 'yɩbha yaa ɔ 'ka we li. 'Ɩn -zugba gwɩnya mɛnɩ ɔ 'gbia 'yli la. ");
INSERT INTO kyf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«'Ylɩ yabhlo nya, bobabhanyɔ yia tlɩ. 'Ɩn -Lagɔɔ 'anzɩnya yia ɔ Ablaamʋ kwesi kwa. 'Ŋnɩmnɩnyɔ -mɔɔ yi 'yaa tlɩ, 'ɩn wa yia ɔ 'bhlu. ");
INSERT INTO kyf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Ŋnɩmnɩnyɔ mɩ sɩada -mɔ tlɩtlɩnyaa dʋdʋ -gʋ, ɔ 'bhua 'wlu 'wʋ, 'ɩn ɔ yia Ablaamʋ -yɔyɩ 'pɩpɩ, -zugba -Lazalɩ mɩ -mɔɔ kwesi. ");
INSERT INTO kyf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tɔʋn, 'ɩn ɔ yia 'wʋkpɩ: ‹Dide Ablaamʋ, -ɩn 'yɩlɩ 'mɩ nyazɩ, -ɩn tie -Lazalɩ, ɔ 'ka ɔ -kwɩtayaa 'mnɛ 'nyu lʋ fa, 'ɩn ɔ 'ka na mɩɔ -gʋ lawɔtɔlʋ. Nɩɩ, ɩn mɩ sɩada bhabha -seli -kosu 'wʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«'Ɩn Ablaamʋ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹Na 'yu, -ɩn 'pa -bha dlɩ nɩɩ, -ɩn ka -nanʋʋ zʋzɔnʋ weee 'yɩ zlɩmɛ dʋdʋ -gʋ, -zugba -Lazalɩ sɩa. -Slɛɛn, wa mɩ -Lazalɩɩ dlɩ -bɛlʋ -yɔpalɩda -seli, -zugba -mɩ -na sɩa. ");
INSERT INTO kyf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Ɩn 'ya, 'gbiwlu 'kadʋ mɩ a -yɔ -aɩn 'sɔ nyɩdɩ. We 'gbʋ, nyɩma -wa 'yɩbhaa wa 'ka -amɩaa -gbɛ 'bhʋ, wa 'ka amɩaa -gbɛ mnɩ, wa 'nɩ we mneni. 'Sa -bhloo 'dɛ, da -ɩn mɩa, nyɩmɛ yabhlogbɔɔ 'nɩ mneni -mɔɔ 'ka 'ya -mɔ 'bhʋ, 'ɩn -mɔɔ 'ka -amɩaa -gbɛ yi.› ");
INSERT INTO kyf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«'Ɩn ɔɔ 'ŋnɩmnɩnyɔ nɛɛ: ‹Dide, -mɩ na bhubhoe, we -ka 'sa -mɩ, -ɩn tie -Lazalɩ na didee -buduŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nɩɩ, ɩn ka bhelia gbu, -Lazalɩ kwa wa wɛlɩ, wamɩa yi 'ya sɩasɩada -mɩnɩ yi.› ");
INSERT INTO kyf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Ablaamʋ yia we 'bɩgʋpalɩ ɔ -ylaɛ: ‹-Na bhelia ka Moizɩɩ titee 'sɛbhɛ -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ kwɛɛ, -we we gbaa wa -yla, wa zʋ we 'nʋŋwɛ!› ");
INSERT INTO kyf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«'Ɩn ɔɔ 'ŋnɩmnɩnyɔ nɛɛ: ‹Dide Ablaamʋ, gbʋzɔnʋ -wa, mʋ -nanʋ -wa 'bhie, nɩɩ, nyɩmɛ yabhlo -ka -seli 'bhʋ tlɩtlɩnyaa -gbɛ, ɔ -ka wa wɛlɩ kwa, 'ɩn wa 'bhitia wa dlɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«'Ɩn Ablaamʋ nɛɛ ɔ -ylaɛ: ‹-We Moizɩɩ titee 'sɛbhɛ -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ gbaa, wa 'nɩ we 'nʋŋwɛ zʋ, nyɩmɛɛ 'dɛ yi 'wʋsɔ tlɩtlɩnya glaa, ɔ yi wa wɛlɩ kwaoo, wa 'na 'ka ɔ wɛlɩ 'wʋŋwnu.› » ");
INSERT INTO kyf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","-Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «Gbʋ -we 'kaa nyɩma gbʋnyuu lʋkwa, we mɩ la 'kɔmʋʋ. Nyɩmɛ -ɔ ka -gbɛ wee gbʋnyuu -ka 'bhʋ, gbʋnyuu mɩ ɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Ɩn wa -ka ɔ tʋkpa 'kadʋ -blɩ -yɔ gbʋanɩ, wa -ka ɔ gumunyu lʋ viteli, we nanɩ 'yli ɔ -nʋ nya. Ɔ yi 'ylaasɩ -manɩɩ 'yabhlo gbʋnyuu lʋkwa. ");
INSERT INTO kyf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","A zʋ amɩaa 'dɛ 'yliyɔ! «-Na bheli -ka gbʋnyuu lɛnʋ, -ɩn palɩ we ɔ -yla la. Ɔ -ka we yibheli, -ɩn tɩ ɔ -yɔgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","-Na bheli -ka -mɩ -yla gbʋnyuu lɛnʋ -zakpa gbesɔ 'ylɩ -bhlo nʋkplɛ, 'ɩn ɔ -ka -na -gbɛ yi, ɔ -ka we yibheli, wee 'ylɩ -bhloo 'dɛ nya -zakpa gbesɔ, -ɩn tɩ ɔ -yɔgbʋ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Ylɩ yabhloo zlɩ, -Zezuu tietienya nɛɛ ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, -ɩn 'ylimanɩ -amɩaa dlɩzʋzʋe -gʋwʋla.» ");
INSERT INTO kyf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Ɩn Nyɩmaa -Kanyɔ yia we 'bɩgʋpalɩɛ: «Amɩaa dlɩzʋzʋe -ka -mɩ 'kienyi mutadɩɩ 'ya 'bhisa, a mneni a 'ka su -mɩnɩ -yla gba: ‹-Ɩn 'tlu, -ɩn 'ka -na 'dɛ faa mnɩ gumunyu lʋ›, 'ɩn we zʋa aɩn 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Sa 'bhisa: aɩn glaa, nyɩmɛ yabhlo ka lubhonʋnyɔ yabhlo, kpaapanyɔ nya, 'nɔɔluu 'yliyɔzʋnyɔ nya. Da -mɔɔ -ka kpaa 'bhʋ, ɔ -ka -mɔɔ -yɔyɩ, ɔ yi -mɔɔ -yla gba: ‹-Ɩn yi slʋɩ, -ɩn 'ka lii›? ");
INSERT INTO kyf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","-Ɩnnya, nɩɩ, gbaa ɔ yia ɔ -ylaɛ: ‹-Ɩn pi na lililu, -ɩn 'bhiti -na -bana. -Ɩn wla na lililu, ɩn -ka lilie bhɩa 'bhie, -ɩn 'ka -na -nʋ li.› ");
INSERT INTO kyf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɔ 'nɩ mneni ɔ 'ka ɔ lubhonʋnyɔ fuo 'pa, -we ɔ gbaa -mɔɔ -yla, -we -mɔɔ nʋa lɛɛ 'gbʋ, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'Sa we mɩ 'yaa amɩaa -nʋ nya: -we weee -Lagɔ gbaa a nʋ lɛ, a -ka we lɛnʋ, a gbaɛ: ‹Lubhonʋnya -kpʋa -amɩa -mɩa, -we -Lagɔ gbaa -a nʋ lɛ, 'mʋ -a nʋa lɛ.› » ");
INSERT INTO kyf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Da -Zezu mɩa -Zeluzalɛmʋ mnɩda, 'ɩn ɔ yia Samalii -yɔ Galileee 'wʋgbelida 'plɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Da ɔ plaa 'gbe yabhlo nʋkplɛ, 'ɩn *sɔlɩbhanya kugbua yia ɔ yoo yi. ");
INSERT INTO kyf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wa -tlʋlʋ ɔ -yɔla, 'ɩn wa yia 'wʋkpɩkpɩe bhli: «-Zezu, -Slolunyɔ, -ɩn 'yɩlɩ -aɩn nyazɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","-Zezu 'yɩa wa -yɔ, 'ɩn ɔ nɛɛ wa -ylaɛ: «A mnɩ amɩaa 'dɛ -Lagɔbʋbɔnya 'klʋslolua.» Da wa mɩa mnɩda, 'ɩn wa yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wa glaa, 'yabhlo yibhelia we 'ji nɩɩ, ɔ ka 'pʋ, 'ɩn ɔ yia lʋbhiti, -zugba ɔ mnɩnɩ -Lagɔɔ 'ŋnɩ, 'wʋkpɩkpɩe nya. ");
INSERT INTO kyf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɔ bhlia -Zezuu bhʋ -yɔ, ɔ yia ɔ 'wlu zɔfa, 'ɩn ɔ yia ɔ fuo 'pa. Ɔɔ nyɩmɛ mɩa, *Samalii -nyɩmɛ -wa. ");
INSERT INTO kyf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tɔʋn, -Zezu nɛɛ: «'Lee, nyɩma kugbua 'nɩ 'pʋʋ, wa gbomnʋa pnɩɩ 'na? ");
INSERT INTO kyf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Mʋ we 'nɩ 'lakpayu -mɔnɩ 'wʋbhʋ, nyɩmɛ yabhlogbɔɔ 'nɩ 'wlukʋʋn lapʋpalɩ, ɔ 'ka -Lagɔ fuo 'paa yii?» ");
INSERT INTO kyf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Bhie, -Zezu nɛɛ ɔ -ylaɛ: «-Ɩn -sɔ 'wʋ, -ɩn mnɩ. -Na dlɩzʋzʋe ka -mɩ pue.» ");
INSERT INTO kyf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Falizɩnyɩma yia -Zezu layɩbha 'lee: «Lɛbhla -Lagɔɔ nyɩmaa 'wlulapɩlɩbhla 'ka nynia?» 'Ɩn -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «-Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩa, wa'a 'yɩ we -yɔ 'yli nya. ");
INSERT INTO kyf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wa 'na 'ka gba nɩɩ, ‹A -talɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ -seli!› 'ɩn ‹We mɩ mɔ!› A yibheli we 'ji nɩɩ, *-Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ aɩn nyɩdɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Bhie, -Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «Bhla yabhlo yia nynia, 'ɩn a 'ka gba, a 'ka *Nyɩmɛɛ 'Yu 'yɩ, 'ylɩ -bhlogbɔɔ nya, 'ɩn a 'na 'ka ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nyɩma -ka gba: ‹Ɔ mɩ -seli›, 'ɩn wa -ka gba, ‹Ɔ mɩ mɔ›, a 'na dɩlɩ we dlɩ 'wʋ -nɩ, 'ɩn a 'na mnɩnɩ -mɔ -gwagwɩe nya -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa 'nyu -ka 'yɩka 'pa, we -nyumalɩ bhʋa yalɩɩ gwedɩlɩda, 'ɩn we mnɩa we bhɩalɩda, zlɩ Nyɩmɛɛ 'Yu yia yia, 'sa ɔ yia -mɩa. ");
INSERT INTO kyf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","We mɩ nɩɩ, ɔ sɩa -slɔ bhabha, 'ɩn dɛslɛɛn -nyɩma 'ka ɔ sɔlʋ lapalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«-We 'plɩa *Noweee bhla, Nyɩmɛɛ Yuu yiyizlɩ, mʋ -bhloo dɛ yia lɛnʋa. ");
INSERT INTO kyf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noweee bhla, nyɩma mɩ lida, wa mɩ 'mada, wa mɩ kʋkwalɩda, wa mɩ wa 'ŋwnɩyua ylɩ zʋda, 'ɩn Noweee batoo 'wʋ -gbla ylɩ yia nyni. Nowee -gblaa batoo 'wʋ, tɔʋn, zezeguda lʋa, 'ɩn 'nyu yia nyɩma lasa. ");
INSERT INTO kyf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«*Lɔtʋʋ bhla 'sa -bhlokpadɛ we nʋa: nyɩma mɩ lida, wa mɩ 'mada, -zugba, wa zɔ lu, 'ɩn wa pa -valɛ, wa pa kpaa, 'ɩn wa sʋbha -budu. ");
INSERT INTO kyf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Ɩn 'ylɩ -we nya Lɔtʋ 'bhʋa *Sodɔmʋ, wee 'ylɩ nya -Lagɔ kwlilia -kosu -yɔ -bhubhui slo, 'ɩn we yia wa lasa. ");
INSERT INTO kyf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«'Ylɩ -we nya Nyɩmɛɛ 'Yu yia 'bhlewlʋa, 'sa -bhlokpadɛ we yia nʋa. ");
INSERT INTO kyf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Wee 'ylɩ nya, -ɔ -ka nyapɛda -mɩ 'pipee, ɔ 'na mnɩnɩ ɔ 'gba 'wʋbhua -budu zɔ -nɩ. 'Sa -bhlokpadɛ, -ɔ -ka kpaa -mɩ, -mɔɔ 'na bhitili lʋ -zɔɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","A 'pa Lɔtʋʋ 'ŋwnɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nyɩmɛ -ɔ -ka ɔ 'yliyɔgagɩe 'wʋgʋ, 'wʋ ɔ yia we bɔa. 'Ɩn -ɔ -ka ɔ 'yliyɔgagɩe 'wʋbɔ, kwɛɛ we yia ɔ -tʋa. ");
INSERT INTO kyf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: wee 'ylɩ -mɩnɩɩ sabɔ, nyɩma 'sɔ -ka lapɩda -mɩ, 'yabhlo wa yia 'wʋbhua, 'ɩn wa 'ka -bha -gʋdʋ tɩ. ");
INSERT INTO kyf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","'Ŋwnɩ 'sɔ -ka -lu bhuda -mɩ, 'yabhlo wa yia 'wʋbhua, 'ɩn wa 'ka -bha ɔ -libheyi tɩ.  ");
INSERT INTO kyf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nyɩma 'sɔ -ka kpaa -bhlo 'wʋ -mɩ, 'yabhlo wa yia 'wʋbhua, wa 'ka -bha ɔ -libheyi tɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Ɩn -Zezuu 'bɩnɔnya yia ɔ layɩbha 'lee: «Nyɩmaa -Kanyɔ, da gbʋ -mɩnɩ 'ka lɛnʋa?» 'Ɩn -Zezu yia we 'bɩgʋpalɩɛ: «Da 'kwie -ka -mɩ, -bha -ŋwaaa -zlo mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","-Mʋʋ 'bɩgʋ, -Zezu yia wa gbʋʋ nine 'palɩ, ɔ 'ka we wa 'klʋslolu nɩɩ, -Lagɔ wa 'kaa bhubhoeda -tʋ 'kɔmʋʋ, 'kʋa 'na wlalɩ wa 'ylila -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Gbʋwʋbhunyɔ yabhlo mɩa 'gbe yabhlo 'wʋ, ɔ'ɔ sɔ -Lagɔ, 'ɩn ɔ'ɔ zʋ nyɩmɛ yabhlogbɔɔ 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wee 'gbe -bhloo 'dɛ 'wʋ, -dʋgbaŋwnɔ yabhlo mɩ -bha 'ya. 'Kɔmʋʋ ɔ mnɩa ɔɔ gbʋwʋbhunyɔɔ -gbɛ, 'ɩn ɔ gbaa ɔ -ylaɛ: ‹-Ɩn 'bhu ɩn -yɔ na tʋnyɔ 'sɔɔ nyɩdɩ gbʋ 'wʋ›. ");
INSERT INTO kyf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","«'Ylɩ weee nya, ɔɔ gbʋwʋbhunyɔ'ɔ ŋwnu we -yɔ. 'Bhie, 'ylɩ yabhlo nya, 'ɩn ɔ yia 'wlukʋʋn lapʋpalɩ, ɔ nɛɛ ɔ 'dɛɛ dlɩ zɔɛ: ‹Ɩ'ɩn sɔ -Lagɔ, 'ɩn ɩ'ɩn zʋ nyɩmɛ yabhlogbɔɔ 'nʋŋwɛ, gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nɩɩ, -dʋgbaŋwnɔ -mɔnɩ mɩ 'mɩ sɩalɩda duuun 'gbʋ, ɔ gbʋ na yia 'wʋbhua. We 'nɩ -mʋʋʋ, 'ɩn ɔ yia 'mɩ sɩalɩa 'ylɩ weee nya.› » ");
INSERT INTO kyf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Bhie, Nyɩmaa -Kanyɔ yia we -gʋdɩɛ: «-We ɔɔ gbʋwʋbhunyɔ 'nyuu gbaa, a pʋlʋ we yukwli! ");
INSERT INTO kyf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Ɩn -Lagɔ naa, -mɔɔ -bhasanya -ka ɔ gbɛgbɛɩn 'wʋkpɩda -mɩ zlʋkpɛ -yɔ jibheza, -mɔɔ 'na 'ka wa -yɔgbʋ 'wʋbhu tɩklɩɩ? 'Lee, we 'bɩ ɔ yia 'wʋgwlɛlɩa yɩ? ");
INSERT INTO kyf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ɩn nɛɛ aɩn -ylaɛ: -ɩnnya, wa gbʋ ɔ yia 'wʋbhua slʋɩ. 'Ɩn da Nyɩmɛɛ 'Yu -ka yi, ɔ yi dlɩzʋnya dʋdʋ -gʋ ylɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nyɩma -wa yɩa wa 'dɛ tɩklɩɩ -Lagɔ 'yliya 'wʋ, 'ɩn wa tlilia nyɩma tɔlʋa 'ylila, ma -yla -Zezu 'paa gbʋʋ nine -mɩnɩ: ");
INSERT INTO kyf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nyɩma sɔ mnɩa -Lagɔbudu 'kadʋ zɔ -Lagɔ bhubhoea. 'Yabhlo -wa Falizɩnyɩmɛ, 'ɩn -bʋdʋ -wa nisʋn -gwɛzisanyɔ. ");
INSERT INTO kyf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«'Ɩn Falizɩnyɩmɛ -mɔnɩ yia -Lagɔ bhubhoe ɔ 'dɛɛ dlɩ zɔɛ: ‹'Oo -Lagɔ, nyɩma -tɔlʋa -wa 'wienya, tɔlʋa 'nɩ -mɩ tɩklɩɩ, 'ɩn tɔlʋa -yɔ 'ŋwnɩ -putu dɩa -budu 'wʋ. -Amɩ 'nɩ -maa 'bhisa -mɩ, 'ɩn 'dɛbhie, ɩn 'nɩ nisʋn -gwɛzisanyɔ -mɔnɩ 'bhisa mɩɩ 'gbʋ, na paa -mɩ fuo. ");
INSERT INTO kyf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lɔkɔwlu -bhlo 'wʋ na pla 'sun 'ylɩ 'sɔ, 'ɩn -lu weee na yɩa, 'ɩn na nyɛa -mɩ we kugbua -gʋ -bhlonʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Nisʋn -gwɛzisanyɔ -mɔɔ vlaa gwe, ɔ 'nɩ 'yɩbha ɔ 'ka yalɩ yla, ɔ kpaa 'wlu la, 'ɩn ɔ nɛɛ: ‹'Oo -Lagɔ, -ɩn 'yɩlɩ -amɩ gbʋnyuu -lɛnʋnyɔ nyazɩ.› » ");
INSERT INTO kyf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Ɩn -Zezu yia we -gʋdɩɛ: «Ɩn nɛɛ aɩn -ylaɛ: ɔɔ nyɩmɛ -mɔnɩ, da ɔ mɩa ɔ -buduŋwɛɛ mnɩda, ɔ -yɔ -Lagɔ ka wɛlɩ -bhlo, we 'ka Falizɩnyɩmɛ -zi, -Lagɔ ka ɔ -yɔgbʋ 'wʋtɩɩ 'gbʋ. Nɩɩ, nyɩmɛ -ɔ ylimanɩa ɔ 'dɛ, zɔ -Lagɔ yia ɔ bɛlɩa, 'ɩn nyɩmɛ -ɔ bɛlɩa ɔ 'dɛ zɔ, 'ylimanɩa -Lagɔ yia ɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Ylɩ yabhlo nya, nyɩma yia -Zezu 'yuyolua -la, ɔ 'ka wa 'nyulaŋwna, wa kwɛ -gʋ lapalɩe nya. -Zezuu 'bɩnɔnya 'yɩa we -yɔ, 'ɩn wa yia waa nyɩma vuvue bhli wa 'wluo kpɩlɩe nya. ");
INSERT INTO kyf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Ɩn -Zezu yia waa 'yuyolua ɔ 'dɛ -yɔbɛlɩ, 'ɩn ɔ nɛɛ: «A 'tide 'yua 'yi, wa 'ka na -gbɛ yi, a 'na -kʋlʋ wa 'yoo -nɩ. Nɩɩ, nyɩma mɩa sa 'ylaasɩ nɩ 'bhisa, -Lagɔɔ nyɩmaa 'wlulapɩlɩe mɩ -maa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -ɔ 'nɩ -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ -yɔŋwnu 'yɩslɔkpilɛ 'bhisa, ɔ 'na 'ka -Lagɔɔ -gbɛ pla.» ");
INSERT INTO kyf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","'Ylɩ yabhlo nya, Zuifʋʋ 'yugalɩnyɔ yabhlo 'yɩbhaa -Zezu laɛ: «Na -slolunyɔ -zɔnʋ, lɛɛ -lu ɩn 'ka lɛnʋ, 'bhie, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'ɩn ɩn 'ka we 'yɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","-Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Lɛɛ -lu ka 'gbʋ -na la 'mɩ nyɩmɛ -zɔnʋa? We 'nɩ -Lagɔɔ 'dɛbhlogbɔɔ 'wʋbhʋ, nyɩmɛ -zɔnʋ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","-Ɩn -yi -Lagɔɔ *titenya: ‹-Ɩn -yɔ 'ŋwnɔ -putu 'na -dɩlɩ -budu 'wʋ -nɩ , -ɩn 'na 'bhalɩ nyɩmɛ -nɩ, -ɩn 'na ylili 'wie -nɩ, -ɩn 'na zʋlʋ nyɩmɛ yo -yɔ -nɩ, -ɩn zʋ -bha -na dide -yɔ -na 'nyaa.› » ");
INSERT INTO kyf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɔɔ nyɩmɛ nɛɛ: «Na -kanyɔ, ɩn mɩ nyimeslɔ nya, 'ɩn ɩn yia tite -mɩnɩ 'nʋŋwɛzʋzʋe bhli.» ");
INSERT INTO kyf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","-Zezu 'nʋa gbʋ -mɩnɩ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Lu -we -ɩn 'kaa lɛnʋ, we -tʋ 'wʋ -bhlo: -ɩn 'pa -na zʋzɔnʋ weee pɛlʋ, 'ɩn -ɩn 'ka we 'gwɛzi bobabhanya 'wʋladlili. 'Ɩn -ɩn 'ka 'ŋnɩmnɩe 'yɩ -Lagɔɔ -gbɛ. -Ɩn -ka we lɛnʋe bhɩa, -ɩn yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nɩɩ, ɔɔ nyɩmɛ 'nʋa wɛlɩ -mɩnɩ, ɔ mɩ 'ŋnɩmnɩnyɔ 'kadʋ nyaa 'gbʋ, 'ɩn we yia ɔ dlɩ sumanɩ. ");
INSERT INTO kyf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","-Zezu 'yɩa we -yɔ nɩɩ, ɔɔ nyɩmɛɛ dlɩ ka sumanɩ, 'ɩn ɔ nɛɛ: «'Ŋnɩmnɩnya 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ pla, -yɔ we -kalɩa! ");
INSERT INTO kyf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Ŋnɩmnɩnyɔ 'ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbe 'wʋ pla, we -kalɩ -yɔ we -zi *-nyɔmɛɛ seenɩɩ 'bhʋka 'wʋplɩlɩe.» ");
INSERT INTO kyf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nyɩma -wa mɩa -Zezu yukwli pʋlʋda, wa nɛɛ ɔ -ylaɛ: «Aya! We -ka 'sa -mɩ, nyɔɔ -mɔmɔ 'ka gbʋ 'wʋbhʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","-Zezu yia we 'bɩgʋpalɩɛ: «-We ka lɛnʋe nyɩma 'nɩa mneni, -Lagɔ mneni we lɛnʋe.» ");
INSERT INTO kyf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tɔʋn, Piɛlɩ nɛɛ -Zezu -yla: «-Ɩn -talɩ, -a ka -amɩaa -lu weee -bha tɩ, 'ɩn -a yia -mɩ 'bɩ yi.» ");
INSERT INTO kyf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","-Zezu nɛɛ wa -ylaɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: *-Lagɔɔ nyɩmaa 'wlulapɩlɩee 'gbʋ, nyɔɔo nyɔɔ -ka ɔ -budu klaa, ɔ 'ŋwnɔ klaa, ɔ bhelia klaa, ɔ didea -yɔ ɔ 'yua -bha tɩ, ");
INSERT INTO kyf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","-lu -duun ɔ yia 'yɩa bhla -mɩnɩ nya, we 'ka -bha 'wʋzi. 'Ɩn -mʋʋ 'bɩgʋ, bhla -we yia yia, 'ɩn ɔ yɩa 'yliyɔgagɩe -we 'nɩa bhloluda -ka.» ");
INSERT INTO kyf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","-Zezu -yɔ ɔ 'bɩnɔnya kugbua lɛ 'sɔ mɩ mnɩda, 'ɩn ɔ nɛɛ wa -ylaɛ: «A -talɩ, -Zeluzalɛmʋ -a mnɩa da. Gbʋ -we -Lagɔgbʋʋ -falɩpanya cɛlɩa Nyɩmɛɛ 'Yuu daa, -mɔ we yia lɛnʋa. ");
INSERT INTO kyf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Nɩɩ, nyɩma -wa 'nɩa -Lagɔ -yi, -maa -yla wa yia ɔ wlaa. 'Ɩn -maa 'ka ɔ gla palɩ, -maa 'ka ɔ vɛlɩ, 'ɩn -maa 'ka ɔ -dlɛ -gʋ slu. Sɛlɩa wa yia ɔ, 'ɩn wa 'ka ɔ 'bha, we 'ylɩ taa zlɩ, 'ɩn ɔ 'ka 'wʋsɔ tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nɩɩ, wɛlɩ -we -Zezu gbaa, we 'ji mɩ zizedaa 'gbʋ, ɔ 'bɩnɔnya 'nɩ we 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","-Zezu 'ka Zelikoo kwesi bɛa yi, 'lɔlɔnyɔ -dɩ yoo ŋwɛ -yɔ la, -zugba ɔ zla. ");
INSERT INTO kyf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ɔɔ 'lɔlɔnyɔ 'nʋa 'plɩplɩnyaa wɛlɩ, 'ɩn ɔ yia layɩbha, lɛɛ nʋ lɛa? ");
INSERT INTO kyf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Ɩn -maa nɛɛ ɔ -yla: «Nazalɛtɩyu -Zezu mɩa 'plɩda.» ");
INSERT INTO kyf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tɔʋn, ɔ yia 'wʋkpɩ: «*-Davidɩɩ 'Yu -Zezuɔɔ, -ɩn 'yɩlɩ 'mɩ nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nyɩma -wa mɩa -Zezu 'yu nɔda, 'ɩn -maa yia ɔ 'wluo 'kpɩlɩ, wa nɛɛ ɔ -yla: «'Mu ŋwɛ!» 'Ɩn ɔ yi 'yaa 'wʋkpɩ 'tɩtɛɛ: «-Davidɩɩ 'Yuɔɔ, -ɩn 'yɩlɩ 'mɩ nyazɩɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","-Zezu 'yligbea, 'ɩn ɔ nɛɛ nyɩma -yla, wa -yɔ ɔ 'sɔ yi. Da 'lɔlɔnyɔ bɛa ɔ kwesi, 'ɩn -Zezu yia ɔ layɩbha: ");
INSERT INTO kyf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Lɛɛ -lu -ɩn 'yɩbha ɩn nʋ lɛ -mɩ -ylaa?» -Mɔɔ yia we 'bɩgʋpalɩɛ: «Na -Kanyɔ, -ɩn -blo na 'yli, ɩn 'ka layɩ lʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","-Zezu nɛɛ ɔ -ylaɛ: «-Na 'yli -bloɛ, -na dlɩzʋzʋe ka -mɩ pue.» ");
INSERT INTO kyf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","-Bha -bhlokpadɛ, ɔ bhlia layɩyɩe, 'ɩn ɔ yia -Zezu 'bɩ mnɩ, -Lagɔɔ 'ŋnɩ mnɩnɩe nya. Nyɩmaa -zlo 'yɩa we -yɔ, 'ɩn -maa yi 'yaa -Lagɔɔ 'ŋnɩ mnɩnɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Ylɩ yabhlo nya, -Zezu plaa Zelikoo, ɔ mɩ wee 'gbe 'wʋdɩda, ");
INSERT INTO kyf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'ŋnɩmnɩnyɔ yabhlo mɩa -bha, *nisʋn -gwɛzisanyaa -kanyɔ nya, 'mɔ wa laa -Zasee. ");
INSERT INTO kyf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɔ mɩ 'klɩ 'yɩda, -de nyɔɔ -wa -Zezuu, ɔ 'ka ɔ -yɔyɩɩ 'gbʋ. Ɔ mɩ nyɩmɛ kibhe nya, nyɩmaa -zloo 'gbʋ, ɔ 'nɩ mneni ɔ 'ka ɔ -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Yoo -we -Zezu mɩa kwada, -Zasee tlia -gwagwɩe la, su wa laa sikomɔlʋ -we 'yligbea wee 'yoo ŋwɛ -yɔ, 'ɩn ɔ yia we -gbla. -Zezu yia -bha 'plɩlɩa, ɔ 'ka ɔ 'yɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","-Zezu nynia wee su zɔ, ɔ ylaa yalɩ, 'ɩn ɔ nɛɛ -Zasee -ylaɛ: «-Ɩn 'sibhli la slʋɩ, -na -gbɛ ɩn 'kaa -zɛɛn -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","-Zasee 'sibhlia la -gwagwɩe nya, 'ɩn ɔ -yɔ -Zezu 'sɔ yia ɔ -buduŋwɛɛ mnɩ 'mʋna nya. ");
INSERT INTO kyf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","-Wa weee 'yɩa -bha, 'ɩn -maa yia -Zezu zɔ ŋwuŋwenie bhli, wa nɛɛ: «Ɔɔ nyɩmɛ ka gbʋnyuuu kwɛ -kanyɔɔ -gbɛ -gʋa mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Ɩn -Zasee yia Nyɩmaa -Kanyɔ 'yu bɛ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «Na -Kanyɔ, ɩn 'yɩbha ɩn 'ka bobabhanya na zʋzɔnʋʋ kibhe 'nyɛ. 'Ɩn nyɔɔ ɩn -ka 'gwɛzi duun kwɛɛ -sa, ɩn 'ka -mɔɔ we -zakpa -mnʋa 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «'Pʋpʋe ka -zɛɛn -budu -mɩnɩ zɔ pla. -We ka gbʋ -wa, -mɩ mɩ 'ya Ablaamʋʋ zʋaylinyɩmɛ nya. ");
INSERT INTO kyf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nɩɩ, nyɩma -wa mnɔa, 'ma Nyɩmɛɛ 'Yu yia 'ylibɩlanɔnʋa, 'ɩn ɔ 'ka wa gbʋ 'wʋsa.» ");
INSERT INTO kyf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Da nyɩma mɩa -Zezuu wɛlɩ yukwli pʋlʋda, 'ɩn ɔ yi 'yaa wa -yla gbʋʋ nine yabhlo 'pa. -We ka gbʋ -wa, da ɔ cɩpaa -Zeluzalɛmʋ -yɔ, 'ɩn wa yia we 'wlukʋʋn lapʋpalɩ nɩɩ, dɛslɛɛn -Lagɔ slolua ɔ nyɩmaa 'wlulapɩlɩe. ");
INSERT INTO kyf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɔ nɛɛ wa -ylaɛ: «'Ŋnɩmnɩnyaa zʋaylinyɩmɛ yabhlo mnɩa dʋdʋ -putu -gʋ, wa 'ka ɔ nyɩmaa 'wlulapɩlɩnyɔ -zɛlɩ, 'ɩn ɔ 'ka lʋyi. ");
INSERT INTO kyf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Da ɔ 'kaa mnɩ, 'ɩn ɔ yia ɔ zɔlubhonʋnya glaa nyɩma kugbua la. 'Ɩn ɔ yia wa -can gbʋa -bhlo -bhlo 'wʋladlili. Ɔ nɛɛ wa -ylaɛ: ‹A 'palɩ we -valɛ, 'ɩn na lʋyibhla 'ka 'sa nyni.› ");
INSERT INTO kyf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«'Ɩn ɔ dʋdʋ -gʋ nyɩma mɩ ɔ 'wʋnyɛdaa 'gbʋ, wa yia nyɩma ɔ 'bɩ tie, 'ɩn wa nɛɛ: ‹-A 'nɩ 'yɩbha nyɩmɛ -mɔnɩ pɩlɩ -aɩn 'wlu la.› ");
INSERT INTO kyf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Wa -zɛlɩa ɔ nyɩmaa 'wlulapɩlɩnyɔ, 'ɩn ɔ yia ɔ dʋdʋ -gʋ lʋyi. Tɔʋn, ɔ zɔlubhonʋnya ɔ 'nyɛa zlɩmɛ 'gwɛzi yoo, 'ɩn ɔ yia wa la. 'Ɩn -we wa 'yɩa, ɔ 'ka we ŋwɛɛ yibheli. ");
INSERT INTO kyf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Ɔ zɔlubhonʋnyaa tɩanʋ yia, 'ɩn ɔ nɛɛ: ‹Na -Kanyɔ, 'gwɛzi -we -ɩn 'nyɛa 'mɩ yoo, we -zakpa kugbua ka we -gʋbho.› ");
INSERT INTO kyf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Nyɩmaa 'wlulapɩlɩnyɔ nɛɛ ɔ -ylaɛ: ‹We nanɩ 'yli, zɔlubhonʋnyɔ -zɔnʋ -ɩn -mɩa. -Ɩn ka -lu -sɛlɛɛ lɛnʋe 'yliyɔzʋʋ 'gbʋ, 'gbe kugbua na yia -mɩ yoo 'nyɛa, -ɩn 'ka we 'wlulapɩlɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ɔ zɔlubhonʋnyaa 'sɔnʋ yia, 'ɩn -mɔɔ nɛɛ: ‹Na -kanyɔ, 'gwɛzi -we -ɩn 'nyɛa 'mɩ yoo, we -zakpa gbu ka we -gʋbho.› ");
INSERT INTO kyf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Nyɩmaa 'wlulapɩlɩnyɔ nɛɛ ɔ -ylaɛ: ‹-Mɩ -mɔnɩ, 'gbe gbu na yia -mɩ yoo 'nyɛa, -ɩn 'ka we 'wlulapɩlɩ.› ");
INSERT INTO kyf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ɔ zɔlubhonʋnyaa tanʋ yia, 'ɩn -mɔɔ nɛɛ: ‹Na -kanyɔ, -na 'gwɛzi ɩn zizea 'naa pɩ 'wʋ mʋ nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ɩn mɩ -mɩ sɔdaa 'gbʋ, ɩn yi 'saa nʋ. Nɩɩ, -ɩn mɩ dlɩtɛlɔnyɔ nya. -Lu -we -ɩn 'nɩ ladɩ, 'mʋ -na bhua 'wʋ. 'Ɩn da -ɩn 'nɩ 'mnɔ 'pa, -bha -na dɩa 'mnɔ.› ");
INSERT INTO kyf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Nyɩmaa 'wlulapɩlɩnyɔ nɛɛ ɔ -ylaɛ: ‹Zɔlubhonʋnyɔ 'nyuu -ɩn -mɩa. -Na 'dɛɛ ŋwɛɛ wɛlɩ -gʋ, na yia -na -yɔgbʋ 'wʋbhua. -Ɩn yi we 'ji nɩɩ, dlɩtɛlɔnyɔ ɩn -mɩa, 'ɩn -lu -we ɩn 'nɩ ladɩ, 'mʋ na bhua 'wʋ, 'mnɔ -we ɩn 'nɩ 'pa, 'mʋ na dɩa. ");
INSERT INTO kyf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lɛɛ ka 'gbʋ -ɩn 'nɩ na 'gwɛzi bankɩ 'wʋ kwa, we 'ka -gʋbhoa? 'Ɩn ɩn -ka lʋyi, ɩn 'ka -mɔ we -saa?› ");
INSERT INTO kyf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«-Mʋʋ 'bɩgʋ, nyɩma -wa mɩa -bha, ɔ nɛɛ wa -ylaɛ: ‹A -sa 'gwɛzi ɔ kwɛɛ, -ɔ 'yɩa we -zakpa kugbua a 'nyɛ we -mɔɔ yoo.› ");
INSERT INTO kyf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Wa nɛɛ ɔ -ylaɛ: ‹-Amɩaa -kanyɔ, -mɔɔ ka 'cɩn we kugbua kwɛɛ!› ");
INSERT INTO kyf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«'Ɩn ɔ yia we 'bɩgʋpalɩ wa -ylaɛ: ‹Ɩn nɛɛ, -wa weee kaa -lu duun, wa -nʋ wa yia -gʋpalɩa. 'Ɩn nyɩmɛ -ɔ 'nɩa -lu duun -ka, we -sɛlɛɛ dɛ mɩa ɔ kwɛɛ, kwɛɛ wa yia we ɔ -saa. ");
INSERT INTO kyf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","-Slɛɛn, na tʋnyɩma 'nɩa 'yɩbha ɩn pɩlɩ wa 'wlu la, a -yɔ wa yi -seli, 'ɩn a -dɩ wa -blɩɩ na 'yibadɩ.› » ");
INSERT INTO kyf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","-Zezu bhɩa sa gbagbɩe, -mʋʋ 'bɩgʋ, ɔ yia nyɩmaa -zlo 'yugalɩ, 'ɩn ɔ yia -Zeluzalɛmʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Da ɔ mɩa Bɛtɩfazee -yɔ Betani kwesi bɛda, -gɔgɔ wa laa *Olivʋsunyaa -gɔgɔ kwesi, 'ɩn ɔ yia ɔ 'bɩnɔnya 'sɔ tie ɔ 'dɛ 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ɔ nɛɛ wa -ylaɛ: «'Gbe -we mɩa -mɛmɛ -aɩn 'yu, da a -ka -mɔ nyni nɩ, -sokofalɩ -dɔgbʋ a yia lubhu -jɩda ylɩa, nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ we -gʋ ladɩ, a -sa we lubhu, a -yɔ we yi -seli. ");
INSERT INTO kyf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We -ka nyɩmɛ yabhlo ka aɩn layɩbhaɛ: ‹Lɛɛ -lu ka 'gbʋ a sa we lubhua?› A gba ɔ -ylaɛ: ‹-Amɩaa -Kanyɔ 'yɩbha we.› » ");
INSERT INTO kyf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Waa tietienya mnɩa, saa 'dɛ -Zezu gbaa we wa -yla, 'ɩn wa yi 'saa we ylɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wa mɩ wee -sokofalɩ -dɔgbʋ lubhu -sada, 'ɩn we -cɩan yia wa layɩbhaɛ: «Lɛɛ -lu ka 'gbʋ a sa we lubhua?» ");
INSERT INTO kyf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Ɩn wa yia we 'bɩgʋpalɩɛ: «-Amɩaa -Kanyɔ 'yɩbha we.» ");
INSERT INTO kyf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Bhie, wa -yɔ wee -sokofalɩ yia -Zezuu -gbɛ yi. 'Ɩn wa yia we wa 'naanya -gʋ lapalɩ. 'Ɩn wa yia -Zezu we -gʋ -gblalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Da -Zezu mɩa mnɩda, -zugba nyɩma -yɔ 'naa -slʋslʋe mnɩ 'yloogblʋ ɔ 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ɔ 'plɩlɩa Olivʋsunyaa -gɔgɔɔ yoo 'wʋ, ɔ 'ka -Zeluzalɛmʋ cɩpaa yi, 'mʋna yea ɔ 'bɩnɔnyaa -zlo, 'ɩn wa yia -Lagɔɔ 'ŋnɩmnɩnɩe bhli, wɛlɩ 'tɩtɛ nya, ninee 'ŋnɩpalɩgbʋ weee ka da wa 'yɩaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","'Ɩn wa nɛɛ: «Nyɩmaa 'wlulapɩlɩnyɔ mɩa yida Jejitapɛɛ 'ŋnɩ nya, -Lagɔ ŋwna ɔ 'nyu la. 'Wʋtʋtʋe -dlɔɔ -mɩ yalɩ, 'ɩn -Lagɔɔ 'ŋnɩ 'ylimanɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Falizɩnyɩma -tɔlʋa mɩa nyɩmaa -zlo glaa, wa nɛɛ -Zezu -ylaɛ: «-Slolunyɔ, -ɩn gba -na 'bɩnɔnya -yla wa 'mu ŋwɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","-Zezu yia we 'bɩgʋpalɩɛ: «Ɩn nɛɛ aɩn -ylaɛ, wa -ka ŋwɛ 'mu, 'ɩn tʋkpanya kpɩa 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","-Zezu nynia -Zeluzalɛmʋ kwesi, ɔ -talɩa wee 'gbe -gʋ, 'ɩn ɔ yia we 'gbʋ wi. ");
INSERT INTO kyf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ɔ nɛɛ: «Cɩɩn, -Zeluzalɛmʋ, -we 'kaa -mɩ 'wʋtʋtʋe -dlɔɔ 'nyɛ, -ɩn -ka yaa -zɛɛn ylɩ nya we yibheli, we nanɩ 'yli. Nɩɩ, -slɛɛn we mɩ zizeda -mɩ kwɛɛɛ 'gbʋ, -ɩn 'nɩ mneni -ɩn 'ka we 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","-We ka gbʋ -wa, bhlanya yia nynia -na -nʋ nya, 'ɩn -na tʋnyɩma 'ka -mɩ 'suo bibeli. 'Ɩn wa 'ka -mɩ 'wʋkla sɔ weee lʋ. ");
INSERT INTO kyf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nɩɩ, la wa yia -ɩn -yɔ -na nyɩma 'sɔ -saa. -Na -budunya wa yia wlaa, we tʋkpa 'na 'ka -gʋ ladɩdlɩda -tʋ. -We ka gbʋ -wa, bhla -we nya -Lagɔ 'yɩlɩa -mɩ nyazɩ, 'ɩn ɔ yia -mɩ 'wʋsaa yi, -ɩn 'nɩ we yibheli.» ");
INSERT INTO kyf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","-Zezu mnɩa -Lagɔbudu 'kadʋ ŋwɛɛ, 'ɩn ɔ yia -valɛpanyaa vuvue bhli. ");
INSERT INTO kyf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ɔ nɛɛ wa -ylaɛ: «We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹Na -budu mɩa, -Lagɔ -bhubhoe -budu -wa›. 'Ɩn 'mʋ amɩa nʋa 'wienyaa zizeda 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","'Kɔmʋʋ, -Zezu slolua nyɩma -Lagɔbudu 'kadʋ zɔ, -zugba, *-Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya -yɔ Zuifʋʋ 'yugalɩnya yɩa 'klɩ, wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Ɩn sa wa 'kaa nʋ, wa 'ka ɔ 'bha, 'sa 'nɩ -mɩ. -We ka gbʋ -wa, nyɩma duun ka ɔ ŋwɛɛ wɛlɩ -zɔnʋʋ yukwli pʋlʋe -manɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Ylɩ yabhlo nya, -Zezu mɩ nyɩma gbʋ -sloluda -Lagɔbudu 'kadʋ zɔ, -zugba ɔ gba wa -yla -Lagɔgbʋ. 'Ɩn -Lagɔbʋbɔnyaa -cɩan klaa, -Lagɔɔ titee gwesanya -yɔ Zuifʋʋ nyɩma kpasɩ yia ɔ -gbɛ yi. ");
INSERT INTO kyf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Ɩn wa yia ɔ layɩbhaɛ: «Se -mʋmʋ nya -na nʋ gbʋnya -mɩnɩ lɛa, -ɩn gba we -aɩn -yla. 'Ɩn nyɔɔ 'nyɛ -mɩ we lɛnʋ sea?» ");
INSERT INTO kyf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Gbʋʋ gɔ -bhlo na yi 'yaa amɩa layɩbhaa. ");
INSERT INTO kyf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nyɔɔ tie *Zaan ɔ batizee nyɩma, -Lagɔ -wa yaayɩɩ, nyɩma -wa yɩ? A gba 'mɩ -yla we.» ");
INSERT INTO kyf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Ɩn wa yia we -gʋ kpɛlɩe bhli wa 'dɛkpʋa nyɩdɩ, 'ɩn wa nɛɛ: «-A -ka gba, ‹-Lagɔ tiea ɔ›, 'ɩn ɔ yɩbhaa -aɩn laɛ: ‹Lɛɛ ka 'gbʋ a 'nɩ Zaaan wɛlɩ 'wʋŋwnua?› ");
INSERT INTO kyf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Ɩn -a -ka gba: ‹Nyɩmɛ tiea ɔ›, 'ɩn nyɩmaa -zlo bhaa -aɩn gbɔkʋ 'wʋ. -We ka gbʋ -wa, nyɩma -yi we 'ji nɩɩ, Zaan mɩ -Lagɔgbʋʋ -falɩpanyɔ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","We 'gbʋ, wa yia we 'bɩgʋpalɩ -Zezu -ylaɛ: «-Ɔ tiea Zaan, -a 'nɩ ɔ -yi.» ");
INSERT INTO kyf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Ɩn -Zezu nɛɛ wa -ylaɛ: «-Aa. We -ka 'sa -mɩ, -ɔ 'nyɛa 'mɩ wee gbʋnya -mɩnɩɩ lɛnʋ se, -amɩ 'na 'ka 'ya -mɔɔ -kanyɔɔ 'ŋnɩ aɩn -yla gba.» ");
INSERT INTO kyf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","-Mʋʋ 'bɩgʋ, -Zezu yia nyɩmaa -zlo gbʋʋ nine -mɩnɩ 'palɩ: «Nyɩmɛ yabhlo 'paa -dlɔkpaa, 'ɩn ɔ yia we -gʋ -busalubhonʋnya lapalɩ. 'Ɩn ɔ yia -mɔ -gwlɛ -lakpa 'wʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da -dlɔya -sa bhla nynia, 'ɩn ɔ yia ɔ zɔlubhonʋnyɔ yabhlo tie -busalubhonʋnya 'bɩ, wa 'ka ɔ -nʋ wla. 'Ɩn waa -busalubhonʋnya -manɩ yia ɔɔ zɔlubhonʋnyɔ -mɔnɩ bhɩtɩ, 'bhie, wa yia ɔ vu kwɛ klo nya. ");
INSERT INTO kyf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Ɩn ɔɔ kpaaa -kanyɔ yi 'yaa ɔ zɔlubhonʋnyɔ -putu tie. 'Ɩn waa -busalubhonʋnya yi 'yaa -mɔɔ bhɩtɩ, wa yia ɔ vɛlɩ, 'ɩn wa yia ɔ vu kwɛ klo nya. ");
INSERT INTO kyf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɔ yi 'yaa ɔ zɔlubhonʋnyaa tanʋ tie. Wa nʋ 'yaa -mɔɔ lɛ, 'ɩn wa yia -mɔɔ kpaa -gnima viteli. ");
INSERT INTO kyf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Ɔɔ -dlɔkpaa -kanyɔ nɛɛ: ‹Sa ɩn 'ka nʋa? Na yu, -ɔ ka zɛ ɩn -kalɩa, 'mɔ na yia tiea. Na dlɩ zɔ nɩɩ, -bha wa yia ɔ zʋa.› ");
INSERT INTO kyf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Nɩɩ, da -busalubhonʋnya 'yɩa ɔɔ 'yu, wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: ‹-Ɔ 'kaa cɩ ɔɔ kpaaa -kanyɔɔ 'bɩ li, mɔ nɩ. -A 'bha ɔ, 'ɩn wee kpaa 'ka -amɩaa -nʋ -zɛ.› ");
INSERT INTO kyf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Ɩn wa yia ɔ kpaa -gnima viteli, 'ɩn wa yia ɔ 'bha.» 'Ɩn -Zezu yia layɩbhaɛ: «'Lee, sa ɔɔ -dlɔkpaa -kanyɔ 'ka wa nʋa? ");
INSERT INTO kyf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yia ɔ yia, ɔ 'ka ɔ -busalubhonʋnya -manɩ 'bha, 'ɩn ɔ 'ka wee kpaa nyɩma -putu yoo 'nyɛ.» Da nyɩma 'nʋa wee wɛlɩ -mɩnɩ, 'ɩn wa nɛɛ: «-Gbaa! -Mʋʋ 'na 'ka lɛnʋ!» ");
INSERT INTO kyf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Ɩn -Zezu ylaa wa, ɔ nɛɛ: «Wɛlɩ mɩa da cɛlɩda, sa we 'ji mɩa? ‹Tʋkpa -we -budusʋbhanya -saa kwnɛɛ, mʋ -zɛa -buduu gwɩgwɩyli -tʋkpa -zɔnʋ›. ");
INSERT INTO kyf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nyɔɔo nyɔɔ -ka wee tʋkpa -mɩnɩ -gʋ bhlili, la ɔ wʋwlalɩa. 'Ɩn wee tʋkpa -ka nyɔɔ -gʋ bhlili, ɔ tɔpʋ we saa.» ");
INSERT INTO kyf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","-Lagɔɔ titee gwesanya klaa, -Lagɔbʋbɔnyaa -cɩan klaa, wa ka we 'jiyibheli nɩɩ, ma -yɔ -Zezu -saa wee gbʋʋ nine. Wa mɩ 'klɩ 'yɩda, wa 'ka -Zezu kpa -bha -bhlokpadɛ, 'ɩn wa yia nyɩmaa -zlo sɔ. ");
INSERT INTO kyf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wa mɩ sa -Zezu -kʋda, -mʋʋ 'bɩgʋ, 'ɩn wa yia ɔ 'wiemɩ gbʋʋ lɛnʋnya yoo 'pa, -wa nʋa wa 'dɛ nyɩma tɩklɩɩ 'bhisa. Waa nyɩma -manɩ 'ka ɔ zɔbhli, ɔ layɩbhɩe nya. 'Ɩn wɛlɩ -kpʋa -ka ɔ ŋwɛɛ 'tla, wa 'ka ɔ gbʋ 'wlu dɩ, 'ɩn dʋdʋʋ 'wlulapɩlɩnyɔ kaa 'tɩtɛ -yɔ se, wa 'ka ɔ -mɔɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Ɩn wa yia ɔ gbʋ -mɩnɩ layɩbhaɛ: «-Amɩaa -Slolunyɔ, -we -na gbaa, 'ɩn -na slolua, -a -yi we 'ji nɩɩ, we tɩklɩɩ. -Ɩ'ɩn yla nyɩmɛɛ -kwɩkwɩ. Sa -Lagɔ 'yɩbhaa nyɩmɛ -mɩ, 'mʋ -na slolua gbʋzɔnʋ sa. ");
INSERT INTO kyf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","'Yoo -amɩaa tite nyɛ -aɩn, -a plʋlʋ *Sezaa kwɛɛ nisʋn -gwɛzi yaayɩɩ, -a 'na plʋlʋ we -nɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","-Zezu yibhelia wa -dawlii 'ji, 'ɩn ɔ nɛɛ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«A -slolu 'mɩ *Wlɔmʋ -tama yabhlo 'klʋ. Nyɔɔ ka 'wlu -yɔ ɔ ŋnɩ mɩ we -gʋa?» 'Ɩn wa nɛɛ: «Sezaa -wa.» ");
INSERT INTO kyf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Ɩn ɔ nɛɛ wa -ylaɛ: «-We -ka *Sezaaa -nʋ, a 'nyɛ we Sezaa yoo. 'Ɩn -we -ka -Lagɔɔ -nʋ, a 'nyɛ we -Lagɔ yoo.» ");
INSERT INTO kyf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wɛlɩ -we ɔ mɩa gbada nyɩmaa -zlo 'yu, we -mʋmʋ -gʋ wa 'kaa ɔ kpalɩ, -mʋʋ 'nɩ 'yɩ. Nɩɩ, ɔ gbʋʋ 'bɩgʋpalɩ wɛlɩ ka wa ŋwɛgaga -sʋbhalɩɩ 'gbʋ, wa yia ŋwɛ 'muda -tʋ. ");
INSERT INTO kyf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadusenyɩma, -wa gbaa tlɩtlɩnya 'nɩ mneni wa 'ka tlɩtlɩe lʋ 'wʋsɔ, ma bɛa -Zezu kwesi, 'ɩn wa nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«-Amɩaa -kanyɔ, Moizɩ ka we cɛlɩ -aɩn -yla titee 'sɛbhɛ 'wʋɛ: ‹Nyɩmɛ -ka 'ŋwnɔ -ka, ɔ -ka tlɩ, ɔ 'nɩ 'yu -ka, ɔ bheli kwa ɔ -dʋgbadaa. 'Ɩn ɔ -yɔ ɔɔ 'ŋwnɔ 'sɔ 'ka ɔ bhelii zʋa lala, 'ɩn -mɔɔ 'ŋnɩ 'ka dʋdʋ -gʋ -tʋ.› ");
INSERT INTO kyf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɩɩ, zlɩmɛ nyɩmɛ yabhlo ka nʋkpasuyua gbesɔ. Wa kpasa kwaa 'ŋwnɔ, ɔ 'nɩ gwalɩ, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wa 'sɔnʋ yia ɔɔ 'ŋwnɔ kwa. ");
INSERT INTO kyf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Bhie, wa tanʋ yia ɔ kwa. 'Sa we nʋa waa bhelia gbesɔɔ -nʋ nya, wa 'dɛ weee -yɔ ɔ 'nɩ gwalɩ, 'ɩn wa yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wanʋʋ 'bɩgʋ, 'ɩn ɔɔ 'ŋwnɔ -mɔɔ yi 'yaa tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nɩɩ, waa bhelia gbesɔ ka ɔɔ 'ŋwnɔ -mɔnɩ kwa -bhlo -bhlo. 'Ɩn 'ylɩ -we nya tlɩtlɩnya yia 'wʋsɔa, nyɔɔ ka 'ŋwnɔ ɔ -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Ɩn -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Bhla -mɩnɩɩ nyɩma mɩ kʋkwalɩda. ");
INSERT INTO kyf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nɩɩ, nyɩma -wa -Lagɔ -saa -bha, 'ɩn -wa kaa we 'klʋ, wa 'ka 'wʋsɔ tlɩtlɩnya glaa, 'ɩn wa 'ka dʋdʋ lolu -gʋ mnɩ, wa 'na 'ka kʋkwalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nɩɩ, wa 'nɩ -slɛɛn mneni wa 'ka tlɩ, -we ka gbʋ -wa, wa 'wlʋ -Lagɔɔ 'anzɩnya. Wa mɩ -Lagɔɔ 'yua nya. -Lagɔ ka wa 'wʋbhu tlɩtlɩnya lʋ, 'ɩn wa yia 'yliyɔgagɩe 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moizɩ ka we -slolu vaa, nɩɩ, tlɩtlɩnya yia 'wʋsɔa, 'ɩn wa 'ka 'yliyɔgagɩe 'yɩ. Da misagʋsu pilɛɛ -bhoa 'yli, 'ɩn ɔ yia Jejitapɛ la: ‹Ablaamʋʋ -Lagɔ, Izakɩɩ -Lagɔ, Zakɔbʋʋ -Lagɔ.› » ");
INSERT INTO kyf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","'Ɩn -Zezu yia we -gʋdɩɛ: «Wɛlɩ -mɩnɩ slolua nɩɩ, -Lagɔ mɩa, 'yliyɔganyaa -Lagɔ -wa, ɔ 'nɩ tlɩtlɩnyaa -Lagɔ. Nɩɩ, wa 'dɛ weee mɩ 'yliyɔganya nya -Lagɔ 'yliya 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","-Lagɔɔ titee gwesanya tɔlʋa nɛɛ -Zezu -ylaɛ: «-Amɩaa -slolunyɔ, -we -ɩn gbaa, gbʋzɔnʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Ɩn waa nyɩma 'nɩ 'maslɛɛn 'yɩbha, wa 'ka gbʋ -putu ɔ layɩbha. ");
INSERT INTO kyf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","-Zezu nɛɛ wa -ylaɛ: «Lɛɛ ka 'gbʋ wa gba -Lagɔɔ -Bhasanyɔ mɩa, -Davidɩɩ yu -wa? ");
INSERT INTO kyf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nɩɩ, -Davidɩɩ 'dɛbhie -gbolu nɛɛ Lʋʋsɛbhɛ 'wʋɛ: ‹Jejitapɛ nɛɛ na -Kanyɔ -ylaɛ: «-Ɩn -dɩ da la na lilisɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'Ɩn ɩn 'ka -na tʋnyɩma -na bhʋ zɔ lapalɩ, -ɩn 'ka wa -gʋ nɔ.» › ");
INSERT INTO kyf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nɩɩ, sa ɔɔ -Lagɔɔ -Bhasanyɔ 'ka 'ya -Davidɩɩ 'yu -zɛa?» ");
INSERT INTO kyf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Da nyɩma weee -wa mɩa -bha, wa mɩa -Zezu yukwli pʋlʋda, 'ɩn ɔ nɛɛ ɔ 'bɩnɔnya -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«A zʋ amɩaa 'dɛ 'yliyɔ -Lagɔɔ titee gwesanyaa gbɛgbɛɩn. Wa 'yɩbha tlʋlo -bana 'kadɩ 'wʋplaplɩe, -zugba wa zie we nya. 'Ɩn wa 'yɩbha wa -sa wa fʋ, wa 'nʋŋwɛzʋzʋe nya -zejila 'wʋ. -Lagɔbudu zɔ -yɔ 'fɛtɩnya -gʋ, 'yugbɛɩn ladɩdɩe wa 'yɩbhaa kpe -zɔnʋnya -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","-Dʋgbaŋwnɩ wa saa -maa -lu weee kwɛɛ. 'Ɩn wa bhubhoea -Lagɔ nyɩma 'yliya 'wʋ kpokpo, nyɩma tɩklɩɩ 'bhisa. We 'gbʋ, -Lagɔ yia wa -yɔgbʋ 'wʋbhua, 'ɩn wanʋʋ -kaslʋ 'ka nyɩma tɔlʋaa -nʋ 'wʋzi.» ");
INSERT INTO kyf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","-Zezu ylaa ɔ 'dɛ kwesi, 'ŋnɩmnɩnya mɩa 'gwɛzi -gbo 'wʋ palɩda -bhlo -bhlo, -Lagɔbudu 'kadʋ zɔ, 'ɩn ɔ yia wa -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wee bhla -bhlokpadɛ nya, bobabha -dʋgbaŋwnɔ mɩa wee -gbo 'wʋ tamayua 'sɔ palɩda, 'ɩn ɔ yi 'yaa -mɔɔ -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","-Bha -Zezu gbaa: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ, bobabha -dʋgbaŋwnɔ -mɔnɩ wlaa duun, mɔ -zia wa 'dɛ weee 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","'Ŋnɩmnɩnya mɩa, 'gwɛzi -we wa gbʋ 'nɩa 'wʋ -mɩ, 'mʋ wa wlaa. 'Ɩn ɔmɔ, ɔ boba 'wʋ, 'gwɛzi -we ɔ 'kaa lili, 'mʋ ɔ wlaa.» ");
INSERT INTO kyf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","-Mʋʋ 'bɩgʋ, nyɩma tɔlʋa mɩ -Lagɔbudu 'kadʋʋ 'ylinanɔ gbʋ gbada. Tʋkpa 'nanɩ wa 'sʋbhalɩa we klaa, 'ɩn -lu 'nanɩ wa 'nyɛa -Lagɔ, -we nya wa namanɩa we zɔ 'yli, we 'gbʋ. 'Ɩn -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«'Ylɩnya yia yia, -buduu tʋkpanya a yɩa dɛ -yɔ -gʋladɩdlɩda, we 'yabhlogbɔɔ 'na 'ka we -libheyi -gʋ -tʋ. Jitea we 'dɛ weee yia.» ");
INSERT INTO kyf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'Ɩn wa yia ɔ layɩbhaɛ: «-Amɩaa -slolunyɔ, lɛbhla -mʋʋ 'ka lɛnʋa? Lɛɛ -lu 'ka wee -li -mɩnɩɩ lɛnʋbhla -slolua?» ");
INSERT INTO kyf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Ɩn -Zezu yia we 'bɩgʋpalɩɛ: «A zʋ amɩaa 'dɛ 'yliyɔ, nyɩmɛ 'na nʋnʋ aɩn -dawli -nɩ. Nɩɩ, nyɩma -duun yia na 'ŋnɩ -gʋ yia, 'ɩn wa 'ka gbaɛ: ‹-Amɩ -wa -Lagɔɔ -Bhasanyɔ!› 'Ɩn: ‹We bhla ka nyni!› Nɩɩ, a 'na nɔnʋ wa 'bɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Da a -ka tʋgʋgʋe -yɔ -yɔwʋsʋsɔlʋee 'dɩ 'nʋ, a 'na nʋnʋ nyanɔ -nɩ. We mɩ nɩɩ, we nʋ lɛ tɩa. Nɩɩ, -mʋʋ 'nɩ dɛslɛɛn dʋdʋʋ bhɩalɩda.» ");
INSERT INTO kyf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Bhie, ɔ yia we -gʋdɩɛ: «Tʋ yia laga 'sɔ nyɩdɩ 'wʋsɔa. 'Ɩn nyɩmaa 'wlulapɩlɩnyɔ yabhlo 'ka nyɩmaa 'wlulapɩlɩnyɔ -gʋdʋ -yɔwʋsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dʋdʋ yia zuklua, ŋwɔ yia yia, 'ɩn gu 'kadɩ yia nyɩma -yɔbhoa dʋdʋʋ da weee. -Nanagbʋnya -yɔ gwɛdigbʋnya wa yia -yɔyɩa yalɩ, 'ɩn we 'ka nyɩma -nyanɩgbɔ -gʋ -la. ");
INSERT INTO kyf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«'Ɩn -mʋʋ weee 'yu, kpaa wa yia aɩn, wa 'ka aɩn 'klɩyɩe 'wʋpalɩ, wa 'ka aɩn -Lagɔbudunya zɔ kwa, wa 'ka amɩaa -yɔgbʋ 'wʋbhu, 'ɩn wa 'ka aɩn -kaslʋ 'wʋpa. Nyɩmaa 'wlulapɩlɩnya -yɔ dʋdʋʋ 'wlulapɩlɩnya 'yu wa yia aɩn kwaa na 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","-We weee mɩa dɛ yia lɛnʋa, 'ɩn na gbʋnya ka da a 'yɩa, a 'ka we gba. ");
INSERT INTO kyf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","-We a 'kaa gba, a 'ka amɩaa 'dɛ gbʋ -gʋ -sa, a 'na pʋpalɩ we 'wlukʋʋn la -nɩ. 'Ɩn a 'na lʋlʋ we 'gbʋ dlɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nɩɩ, na 'dɛbhie -gbolu yia aɩn gbʋyilo wɛlɩ ŋwɛɛ zʋa. Sa amɩaa tʋnyɩma 'na 'kaa we kpɛlɩ, 'ɩn wa 'na 'kaa we 'bɩgʋpalɩ wɛlɩ 'yɩ, 'sa. ");
INSERT INTO kyf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nɩɩ, amɩaa didea -yɔ amɩaa 'nyaanya, amɩaa bhelia, amɩaa nyɩma -yɔ amɩaa 'talea yia aɩn wlaa. 'Ɩn wa 'ka aɩn glaa nyɩma duun 'bha. ");
INSERT INTO kyf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na 'gbʋ, nyɩma weee yia aɩn 'wʋnyɛa. ");
INSERT INTO kyf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nɩɩ, amɩaa 'wluonyii gɔ yabhlogbɔɔ 'nɩa mnɔa yi. ");
INSERT INTO kyf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","We 'dɛɛ 'gbʋ, a kpa amɩaa 'dɛ la -kli, 'ɩn a 'ka 'yliyɔgagɩe -zɔnʋ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Da a -ka we -yɔyɩ, -Zeluzalɛmʋʋ tʋnyɩmaa 'slʋja ka we gbeli, -zugba a yibheli we 'ji nɩɩ, -Zeluzalɛmʋ gbee labhʋbhla ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","-Mʋʋ bhla, -wa -ka Zudee -dʋdʋ -gʋ -mɩ, -maa -yɔ -gwagwɩe mnɩ zizea -gɔgɔnya 'wlu. -Wa -ka -Zeluzalɛmʋgbe nʋkplɛ -mɩ, -maa 'tla wee 'gbe nʋkplɛ. 'Ɩn -wa -ka kpaa -mɩ, -maa 'na yili -zɔɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sa -Lagɔ 'kaa ɔ nyɩmaa -yɔgbʋ 'wʋbhu, wee 'ylɩnya nʋkplɛ mʋ nɩ. We mɩ cɛlɩda, 'ɩn lɛ we yia nʋa. ");
INSERT INTO kyf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lɛɛ gbʋnyuu yi 'sa, nʋkplabhue ŋwnɩ -yɔ -wa mɩa 'yua 'nyɛnɩda ylɩa, wee 'ylɩnya -mɩnɩ nya! Nɩɩ, sɩasɩe 'kadʋ yia wee dʋdʋ -gʋ yia. 'Ɩn -Lagɔɔ 'cɛ 'ka -mɔ -nyɩma -yɔwʋsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Bhaa wa yia tɔlʋa tʋgʋgblɛ nya, 'ɩn wa 'ka tɔlʋa dʋdʋ -putunya -gʋ kwa galɩ nya. Nyɩma -wa 'nɩa Zuifʋ, -gʋ wa yia -Zeluzalɛmʋ nɔa, wa 'ka we su, 'bhie, wanʋʋ bhla 'ka 'saa bhɩa. ");
INSERT INTO kyf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Gwɛdili wa yia -yɔyɩa, 'ylʋ klaa, 'cʋ -yɔ -zɛlɩ klaa, we -gʋ. Gumunyuu saju -pa -jiji 'kadʋ yia lɛnʋa, 'ɩn dʋdʋgʋ -nyɩma weee dlɩ 'ka sumanɩ, nyanɔ 'ka wa 'wʋslo. ");
INSERT INTO kyf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","'Ɩn -we weee yia lɛnʋa dʋdʋ -gʋ, 'mʋ nyɩma mɩa 'wlukʋʋn lapʋpalɩda, we dlɩ -sulo yia wa 'bhaa. Nɩɩ, yalɩɩ 'tɩtɛ weee yia zuklua. ");
INSERT INTO kyf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɩɩ, Nyɩmɛɛ 'Yu wa yia -yɔyɩa yida yalɩpʋpa -gʋ, ɔ 'tɩtɛ -yɔ ɔ 'ŋnɩmnɩe nya. ");
INSERT INTO kyf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Da wee gbʋnya -mɩnɩ lɛnʋe -ka gwedɩ, a 'yligbe gege, 'ɩn a 'bhu 'wlu 'wʋ. Nɩɩ, -Lagɔɔ amɩaa gbʋwʋsaylɩ ka cɩpa -kwɛɩn.» ");
INSERT INTO kyf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Ɩn ɔ yia wa gbʋʋ nine -mɩnɩ 'palɩ. Ɔ nɛɛ wa -ylaɛ: «A yla figɩsu -yɔ su -tɔlʋa weee -mɩnɩ! ");
INSERT INTO kyf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Da a -ka we -yɔyɩ nɩɩ, we mɩ tɔpɔda, a yibheli we 'ji nɩɩ, 'nyu -lʋa bhla ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Sa -bhlokpadɛ, da a -ka gbʋnya -mɩnɩɩ lɛnʋe -yɔyɩ, a yibheli we 'ji nɩɩ, -Lagɔɔ nyɩmaa 'wlulapɩlɩe ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: dɛslɛɛn -nyɩmaa 'dɛ weee 'na 'ka tlɩ, 'ɩn wee gbʋnya -mɩnɩ 'kaa lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nɩɩ, la yalɩ -yɔ dʋdʋ yia 'bhʋa, na wɛlɩ 'na 'ka labhʋ 'mnumnu. ");
INSERT INTO kyf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«A zʋ amɩaa 'dɛ 'yliyɔ! A 'na yeli amɩaa dibhe 'fɛtɩnya -yɔ nʋ bhabhaa mamɩe -nɩ, 'ɩn a 'na lʋlʋdlɩ dʋdʋ -gʋʋ -lii 'gbʋ -nɩ. We 'nɩ -mʋʋʋ, 'ɩn Nyɩmɛɛ 'Yuu yiyiylɩ tlalɩa aɩn. ");
INSERT INTO kyf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nɩɩ, sa 'sowli tlalɩa zibhi, 'sa -bhlokpadɛ wee ylɩ -mɩnɩ yia dʋdʋgʋ -nyɩma weee 'tlalɩa. ");
INSERT INTO kyf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","We 'dɛɛ 'gbʋ, a -tʋ 'yliyɔgada, a 'na ŋwɔnʋ 'ylaa -nɩ. A -tʋ -Lagɔ bhubhoeda 'kɔmʋʋ, a 'ka 'tɩtɛ 'yɩ, 'ɩn gbʋ weee yia yia, a 'ka we lu. 'Ɩn a 'ka Nyɩmɛɛ 'Yu 'klʋ 'yligbee mneni.» ");
INSERT INTO kyf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Zlɩ, -Zezu slolua nyɩma -Lagɔbudu 'kadʋ zɔ. 'Ɩn jibheza, ɔ mnɩa lapɩa -gɔgɔ wa laa *Olivʋsunyaa -gɔgɔ 'wlu. ");
INSERT INTO kyf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Zlʋkpɛ 'tutu, 'ɩn nyɩmaa -zlo yia -Lagɔbudu 'kadʋ zɔ, ɔ wɛlɩ yukwli pʋlʋa. ");
INSERT INTO kyf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","*'Floo -we 'nɩa gɔɔ -yɔ -ka, -we ka 'fɛtɩ dɩa gwe *'Wʋzɩtɩylɩɩ 'fɛtɩɩ zlɩ, we ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","-Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya 'yɩa 'klɩ, wa 'ka -Zezu 'bha. Nyɩmaa -zlo gbelia -Zezu, wa sɔsʋee 'gbʋ, wa 'nɩ we mneni. ");
INSERT INTO kyf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nɩɩ, -Zezuu 'bɩnɔnya kugbua lɛ 'sɔɔ lʋ -nyɩmɛ yabhlo wa laa Zudasɩ Isɩkaliɔtʋ, -Saatan ka ɔ 'wʋ pla. ");
INSERT INTO kyf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sa Zudasɩ 'kaa -Zezu wla, 'ɩn ɔ yia we gbaa mnɩ -Lagɔbʋbɔnyaa -cɩan -yɔ 'slʋja kʋa -Lagɔbudu 'kadʋ ŋwɛɛ -cɩan -yla. ");
INSERT INTO kyf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","We yia wa 'mʋna 'wʋla. 'Ɩn wa nɛɛ ɔ -yla, wa 'ka ɔ 'gwɛzi 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zudasɩ ŋwnua we -yɔ, 'ɩn sa ɔ 'kaa wa -Zezu yoo 'nyɛ, 'ɩn nyɩmaa -zlo 'na 'kaa we 'jiyibheli, -zugba ɔ talɩa we 'yoo da. ");
INSERT INTO kyf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ylɩ -we nya wa 'kaa 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ *bhlabhlɛyua 'bha, we -yɔ 'Floo -we 'nɩa gɔɔ -yɔ -kaa 'fɛtɩ, we 'ylɩ ka nyni. ");
INSERT INTO kyf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Ɩn -Zezu yia Piɛlɩ -yɔ Zaan tie, ɔ nɛɛ wa -ylaɛ: «A mnɩ -aɩn -yla 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu pia, -a 'ka we li.» ");
INSERT INTO kyf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Ɩn wa yia ɔ layɩbhaɛ: «Mɔ -ɩn 'yɩbha -a mnɩ we pilia?» ");
INSERT INTO kyf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","-Zezu nɛɛ wa -ylaɛ: «Bhla -we nya a -ka -zɔɔ plaa yi nɩ, nyɩmɛ yabhlo a -yɔ ɔ yia gbelia, ɔ ka 'nyunyida 'wlu. -Budu -we zɔ ɔ yia plaa, a pla ɔ 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A gba -buduu -kanyɔ -ylaɛ: ‹-Amɩaa -slolunyɔ nɛɛ, -buduu 'yu -we zɔ ɔ -yɔ ɔ 'bɩnɔnya 'kaa 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu li, da we mɩa?› ");
INSERT INTO kyf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","-Buduu 'yu 'kadʋ mɩa we 'wlu, -we kaa -gʋladɩ -li -zɔnʋ zɔ, 'ɩn ɔ slolua we aɩn da. -Bha a yia wee -amɩaa lililu pia.» ");
INSERT INTO kyf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Ɩn wa yia mnɩ, 'ɩn sa -Zezu gbaa wa -yla, 'ɩn wa yi 'saa we ylɩ. 'Ɩn wa yia 'fɛtɩ -gʋ lililu pi. ");
INSERT INTO kyf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Da lilibhla nynia, 'ɩn -Zezu -yɔ ɔ tietienya yia lililu gwe ladɩ. ");
INSERT INTO kyf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɔ nɛɛ wa -ylaɛ: «Ɩn 'yɩbha ɩn -yɔ aɩn 'ka 'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lililu li dlɩ weee nya, 'bhie, na sɩasɩa ylɩ 'ka nyni! ");
INSERT INTO kyf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɩɩ, ɩn nɛɛ aɩn -ylaɛ: we 'bhʋ -zɛɛn 'wʋ, ɩn 'nɩa lililu nɩɩ -putu lia yi. Zlɩ a -ka wee lililuu 'ji 'wʋlanʋ kpɛɛn kpɛɛn, -mɔ -Lagɔɔ 'wlulapɩlɩgbe 'wʋ, we zlɩ na lia we.» ");
INSERT INTO kyf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","-Zezu 'bhua nʋ -kɔpʋ 'wʋ, 'ɩn ɔ yia -Lagɔ fuo 'pa. 'Ɩn ɔ nɛɛ: «A 'bhu 'kɔpʋ nɩ 'wʋ, a dlili we nʋkpla -lu a 'dɛkpʋa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nɩɩ, ɩn nɛɛ aɩn -ylaɛ: we 'bhʋ -zɛɛn 'wʋ, ɩn 'na 'ka 'maslɛɛn nʋ 'ma, 'ɩn -Lagɔɔ nyɩmaa 'wlulapɩlɩe 'kaa yi.» ");
INSERT INTO kyf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","-Mʋʋ 'bɩgʋ, ɔ 'bhua 'floo 'wʋ, 'ɩn ɔ yia -Lagɔ fuo 'pa. Ɔ dɩdlɩa we la, 'ɩn ɔ yia we wa 'wʋladlili. 'Ɩn ɔ nɛɛ: «-We mɩa da na ku -wa, 'mʋ ɩn wlaa amɩaa 'gbʋ. A li wee 'floo -mɩnɩ, 'ɩn a 'ka 'mɩ ligbeda -tʋ bhla weee nya.» ");
INSERT INTO kyf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wa bhɩa lilie, 'ɩn -Zezu yi 'yaa 'sa wa nʋ -kɔpʋ yoo 'nyɛ. 'Ɩn ɔ nɛɛ: «Wee 'kɔpʋ -mɩnɩ -wa -Lagɔ -yɔ nyɩma 'sɔɔ *'wʋsuslolue -lolu, -we ka 'gbʋ na 'pɩɔn yia jite amɩaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«'Ɩn a yla: -ɔ 'kaa 'mɩ pɛlʋ 'pa nyɩma kwɛɛ, ɔ mɩ da. Na sɔ -yɔ ɔ sɔ mɩ lililu lʋ kna -bhlogbɔɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gbʋzɔnʋ -wa, sa -Lagɔ 'yɩbhaa we, 'sa Nyɩmɛɛ 'Yu yia mnɩa. Nɩɩ, nyɩmɛ -ɔ 'kaa ɔ wla, 'ɩn wa 'ka ɔ 'bha, gbʋnyuu mɩ -mɔɔ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'Ɩn wa yia layɩbhalɩe bhli: «-Aɩn glaa nyɔɔ 'ka -mʋʋ lɛnʋa?» ");
INSERT INTO kyf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","-Zezuu 'bɩnɔnya nyɩdɩ kpɛlɩe 'kadʋ yia -bha -bho. Wa 'yɩbha, -ɔ -wa wa glaa 'kadʋ, wa 'ka ɔ yibheli. ");
INSERT INTO kyf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","-Zezu nɛɛ wa -ylaɛ: «Dʋdʋgʋ -nyɩmaa 'wlulapɩlɩnya pɩlɩ wa 'wlu la, 'tɩtɛ weee nya. 'Ɩn -wa kaa wa, -maa 'yɩbha wa la -maa gbʋzɔnʋʋ lɛnʋnya.» ");
INSERT INTO kyf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Ɩn amɩa 'na nʋnʋ 'sa -maa 'bhisa -nɩ. Nɩɩ, -ɔ -wa 'kadʋ aɩn glaa, ɔ -mɩ 'yɩslɔkpilɛ 'bhisa. 'Ɩn -ɔ -wa amɩaa -kanyɔ, ɔ -mɩ amɩaa zɔlubhonʋnyɔ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nɩɩ, nyɩmɛ -ɔ -dɩa lililu gwe la, mɔ 'ylia yaayɩɩ, -ɔ mɩa lililu dlilida -mɔɔ 'ylia yɩ? -Ɔ -dɩa lililu gwe la mɔ 'ylia. We 'nɩ mʋʋ? We nanɩ 'yli! -Mʋʋ bhla, -amɩ mɩ aɩn nyɩdɩ nyɩmɛɛ zɔlubhonʋnyɔ 'bhisa! ");
INSERT INTO kyf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Da wa mɩa 'mɩ sɩalɩda, amɩa mɩa da, amɩa -tʋa 'mɩ kwesi 'ylɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sa na Dide 'nyɛa 'mɩ nyɩmaa 'wlulapɩlɩe se, 'sa -bhlokpadɛ -amɩ na nyɛa 'ya we amɩa. ");
INSERT INTO kyf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","-Mɔ na 'wlulapɩlɩgbe 'wʋ, lia a -yɔ 'mɩ 'sɔ yia, 'ɩn a -yɔ 'mɩ 'sɔ 'ka 'ma. 'Ɩn 'ŋnɩmnɩkpe -gʋ a yia ladɩa, 'ɩn a 'ka *Izlaɛlɩɩ *zʋa kugbua lɛ 'sɔɔ -yɔgbʋ 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«'Simɔɔ, 'Simɔɔ, -ɩn pʋ yukwli! *-Saatan 'yɩbha ɔ 'ka aɩn 'wʋbhlɩ, sa wa bhlɩa 'mnɔ 'wʋ, 'ɩn sa wa sɩsalɩa we 'ya -yɔ we flɩ 'wʋ, 'sa. ");
INSERT INTO kyf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɩn ka -Lagɔ bhubhoe -na 'gbʋ, dlɩzʋzʋe yi -mɩ 'wʋbɔɔ 'gbʋ. 'Ɩn 'ylɩ -we nya -ɩn -ka lʋbhiti na -gbɛ, -ɩn 'tɛmanɩ -na bheliaa dlɩ la.» ");
INSERT INTO kyf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piɛlɩ nɛɛ ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, ɩn ka dlɩ -sa, -ɩn 'ka -kaslʋ 'wʋ mnɩoo, ɩn -yɔ -mɩ 'sɔ. -Ɩn -ka tlɩoo, ɩn -yɔ -mɩ 'sɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Ɩn -Zezu yia we 'bɩgʋpalɩ: «Ɩn nɛɛ -mɩ -ylaɛ: -zɛɛn -ylɩ -mɩnɩ nya, -kʋkɔ 'na 'ka gbo, 'ɩn -na kpɛlɩa na gbʋ -zakpa ta. 'Ɩn -na gbaa, -ɩn 'nɩ 'mɩ -yi.» ");
INSERT INTO kyf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","-Zezu nɛɛ wa -ylaɛ: «Da ɩn tiea aɩn, 'ɩn a 'nɩa 'gwɛzi -bhɔtɔ, -bada -yɔ -sakwla 'wʋbhu, -lu ka aɩn 'wʋbɔɔ?» 'Ɩn -maa yia we 'bɩgʋpalɩ: «-Ɩnnya, -lu yabhlogbɔɔ 'nɩ -aɩn 'wʋbɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'Ɩn ɔ nɛɛ wa -ylaɛ: «Nɩɩ, -slɛɛn -ɔ -ka 'gwɛzi -ka, ɔ 'bhu we 'wʋ. -Ɔ -ka -bada -ka, ɔ 'bhu we 'wʋ. 'Ɩn -ɔ 'nɩ tʋgʋgblɛ -ka, -mɔɔ 'pa -mɔɔ -bana 'kadʋ pɛlʋ, 'ɩn ɔ 'ka we 'yabhlo zɔ. ");
INSERT INTO kyf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ɩn nɛɛ aɩn -ylaɛ: wɛlɩ -we wa cɛlɩa -Lagɔsɛbhɛ 'wʋ, -we gbaa: ‹Wa ka ɔ gbʋnyuuu kwɛ -cɩan glaa zɛlɩ,› na 'gbʋ wa yia we cɛlɩ. Nɩɩ, -we wa cɛlɩa na 'gbʋ, we mɩ nɩɩ, we nʋ lɛ, -bha -tʋ 'wʋ -sɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɔ 'bɩnɔnya nɛɛ ɔ -ylaɛ: «Nyɩmaa -Kanyɔ, tʋgʋgblɛ sɔ nɩ.» 'Ɩn ɔ nɛɛ wa -ylaɛ: «We -tʋ sa!» ");
INSERT INTO kyf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","-Zezu 'tlaa, 'ɩn ɔ yia *Olivʋsunyaa -gɔgɔ 'wlu mnɩ, ɔ -yɔ ɔ 'bɩnɔnya 'sɔ. Sa ɔ nʋa -benyi 'sa. ");
INSERT INTO kyf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Da ɔ nynia wee da, 'ɩn ɔ nɛɛ wa -ylaɛ: «A bhubhoe -Lagɔ, a yi laylagbʋ lʋ bhlili.» ");
INSERT INTO kyf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'Bhie, sa nyɩmɛ -ka gbɔkʋ viteli da we bhlia, 'ɩn ɔ yi 'saa wa gwevla. Ɔ 'sibhlia 'kukolu, 'ɩn ɔ yia -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ɔ nɛɛ: «Dide, -ɩn -ka we 'yɩbha, -ɩn vlalɩ 'mɩ sɩasɩe 'kadʋ -mɩnɩ gwe. We 'na -zɛlɩ nanʋʋ dʋmagbʋ -nɩ, we -zɛ -na dʋmagbʋ.»  ");
INSERT INTO kyf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tɔʋn, -Lagɔɔ 'anzɩ yabhlo 'bhʋa yalɩ, 'ɩn we yia ɔ 'klʋtlalɩ, we 'ka ɔ dlɩ latɛmanɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","-Zezuu dlɩ sumanɩa tenyi tenyii, 'ɩn ɔ yi 'yaa -Lagɔ bhubhoe 'tɩtɛɛ. 'Ɩn ɔ -yɔɔ sloo 'wlʋa 'pɩɔn, we yia bhlida -tʋ dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Da ɔ bhɩa -Lagɔ bhubhoe, ɔ -sɔa 'wʋ, 'ɩn ɔ yia ɔ 'bɩnɔnyaa -gbɛ lʋyi. 'Ɩn ɔ yia wa 'ylaa -ŋwɔda ylɩ, -we ka gbʋ -wa, wa dlɩ -su. ");
INSERT INTO kyf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ɔ nɛɛ wa -ylaɛ: «Lɛɛ ka 'gbʋ a ŋwɔ 'ylaa? A -sɔ 'wʋ, 'ɩn a bhubhoe -Lagɔ, a yi laylagbʋ lʋ bhlili.» ");
INSERT INTO kyf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","-Zezu mɩ ɔ 'bɩnɔnya -yla gbʋ gbada, 'ɩn nyɩmaa -zlo yia ɔ 'tlalɩ. Ɔ 'bɩnɔnya kugbua lɛ 'sɔɔ 'yabhlo wa laa Zudasɩ, mɔ -galɩa wa 'yu. 'Ɩn ɔ yia -Zezu kwesi bɛ, ɔ 'ka ɔ gbleli. ");
INSERT INTO kyf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «Zudasɩ, -ɩn 'ka *Nyɩmɛɛ 'Yu pɛlʋ 'paa 'gbʋ -na gblelia ɔ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gbʋ -we 'kaa -Zezu ylɩ, da ɔ 'bɩnɔnya 'yɩa we -yɔ, 'ɩn wa yia ɔ layɩbhaɛ: «Nyɩmaa -Kanyɔ, -a 'pa waa nyɩma nɩ tʋgʋgblɛɛ?» ");
INSERT INTO kyf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tɔʋn, 'ɩn wa lʋ -nyɩmɛ yabhlo yia -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋnyɔɔ lilikwɛ -yukwli ɔ 'wlu -dɩ. ");
INSERT INTO kyf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Ɩn -Zezu nɛɛ: «A 'tide we 'yi, we -tʋ 'sa!» Ɔ zɩa ɔɔ nyɩmɛɛ yukwli kwɛ, 'ɩn ɔ yia ɔ jipe. ");
INSERT INTO kyf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'Bhie, -Lagɔbʋbɔnyaa -cɩan, -Lagɔbudu 'kadʋʋ ŋwɛkʋnyaa -cɩan, -yɔ -Lagɔbudu zɔɔ nyɩma kpasɩ, -wa yia -Zezu kpaa, -Zezu nɛɛ wa -ylaɛ: «'Wienyɔ ɩn -mɩa, 'ɩn a yia 'mɩ kpaa yi tʋgʋgblɛ -yɔ su kibhe nya kwɛɛ -nya yɩ? ");
INSERT INTO kyf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ɩn -yɔ aɩn 'sɔ mɩ 'kɔmʋʋ -Lagɔbudu 'kadʋ zɔ, a 'nɩ 'mɩ kpa. Nɩɩ, wee bhla -mɩnɩ mɩ amɩaa -nʋ nya, 'ɩn we mɩa -Saataan 'tɩtɛ mɩa nikpise 'wʋʋ -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wa kpaa -Zezu, wa -yɔ ɔ mnɩa, 'ɩn wa yia ɔ *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ -budu zɔ 'pa, -zugba Piɛlɩ mɩ -Zezu 'bɩ, ɔ 'nɩ ɔ -yɔ cɩpa. ");
INSERT INTO kyf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wa -dɩa -kosu 'yi wee -buduŋwɛɛ, nyɩma -wa mɩa 'wɔlɔda, 'ɩn Piɛlɩ yia wa nyɩdɩ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Zɔlubhonʋŋwnɔ 'yɩa ɔ -kosu ŋwɛ -yɔ ladɩda, ɔ ylaa ɔ tenyii, 'ɩn ɔ nɛɛ: «Ɔɔ nyɩmɛ -mɔnɩ mɩ 'ya -Zezuu 'bɩnɔnyɔ nya zlɩmɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Ɩn Piɛlɩ yia we 'bɩgʋpalɩ ɔɔ 'ŋwnɔ -ylaɛ: «We 'nɩ gbʋzɔnʋ, ɩn 'nɩ ɔ -yi.» ");
INSERT INTO kyf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","-Bha bɛa -sɛ, nyɩmɛ yabhlo mɩa -bha, ɔ ylaa Piɛlɩ tenyii, ɔ nɛɛ: «-Mɩ mɩa dɛ, -ɩn mɩ 'ya ɔ 'bɩnɔnyaa glaa -nyɩmɛ yabhlo nya.» 'Ɩn Piɛlɩ yia we 'bɩgʋpalɩ ɔɔ nyɩmɛ -ylaɛ: «-Ɩnnya, -amɩ 'nɩ ɔ 'bɩnɔnyɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","-Mʋʋ 'bɩgʋ, 'lɛlɩ -bhlo 'plɩa sa, 'ɩn nyɩmɛ yabhlo yi 'yaa we ŋwɛ -yɔkpalɩɛ: «Cɩɩn, gbʋzɔnʋ -wa, ɔɔ nyɩmɛ mɩa dɛ, ɔ -yɔ ɔ 'sɔ mɩ zlɩmɛ, nɩɩ, Galilee -nyɩmɛ -wa.» ");
INSERT INTO kyf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Ɩn Piɛlɩ yia we 'bɩgʋpalɩ ɔɔ nyɩmɛ -ylaɛ: «'Tale, lɛɛ -ɩn 'yɩbha -ɩn 'ka gba -bha? Ɩ'ɩn 'nʋ -na wɛlɩ 'wʋla.» Piɛlɩ mɩ -slɔ gbada, tɔʋn, 'ɩn -kʋkɔ yia gbo. ");
INSERT INTO kyf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nyɩmaa -Kanyɔ 'bhitia, 'ɩn ɔ yia Piɛlɩ yla tenyii. Tɔʋn, wɛlɩ -we Nyɩmaa -Kanyɔ gbaa, 'ɩn Piɛlɩɩ dlɩ yia we -gʋ -bho, ɔ nɛɛ ɔ -ylaɛ: «Piɛlɩ, nyɩma -yla -na yia gbaa nɩɩ, -ɩn 'nɩ 'mɩ -yi, -zakpa ta, 'bhie, -kʋkɔ 'kaa -zɛɛn gbo.» ");
INSERT INTO kyf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piɛlɩ 'tlaa, 'ɩn ɔ yia nyazɩwie wida -tʋ kpokpo. ");
INSERT INTO kyf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nyɩma -wa mɩa -Zezu ŋwɛkʋda, -zugba wa palɩ ɔ gla, 'ɩn wa bhɩtɩ ɔ. ");
INSERT INTO kyf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wa -gblia ɔ 'naa 'yli -gʋ, 'ɩn wa yia ɔ layɩbha: «Nyɔɔ 'pa -mɩ -lua? -Ɩn gba ɔ 'ŋnɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Ɩn wa yi 'yaa ɔ vɛlɩ, wɛlɩɩ 'yli -bhlo -bhlo nya. ");
INSERT INTO kyf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Da zlɩ zlɩa, Zuifʋʋ nyɩma kpasɩ, -Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya yia 'wlu gbeli. 'Ɩn wa yia -Zezu gbʋwliwʋdɩnya 'yu kwa. ");
INSERT INTO kyf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","'Ɩn wa yia ɔ layɩbha: «-Lagɔɔ -Bhasanyɔ -ɩn -mɩa yɩ? -Ɩn gba we -aɩn -yla.» -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Ɩn -ka we gba aɩn -yla, a 'nɩa we gbʋzɔnʋ laa yi. ");
INSERT INTO kyf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɩn -ka aɩn layɩbha, a 'na 'ka we 'bɩgʋpalɩ 'mɩ -yla. ");
INSERT INTO kyf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nɩɩ, dɛslɛɛn 'dɛbhie -gbolu, Nyɩmɛɛ 'Yu dɩa 'tɩtɛ -ka -Lagɔɔ lilisɔlʋ la.» ");
INSERT INTO kyf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tɔʋn, 'ɩn wa 'dɛ weee yia 'wʋkpɩ: «-Zugba, -Lagɔɔ 'Yu -ɩn -mɩa yɩ?» 'Ɩn ɔ yia we 'bɩgʋpalɩ wa -ylaɛ: «'Mʋ a gbaa dɛ: 'mɔ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Ɩn wa nɛɛ: «-A 'nɩ we dayɩnyaa gbʋ -ka! -A ka -amɩaa 'dɛ nya ɔ ŋwɛɛ wɛlɩ 'nʋ feifei.» ");
INSERT INTO kyf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nyɩma weee -sɔa 'wʋ, 'ɩn wa yia -Zezu Pilatɩ 'yu kwa. ");
INSERT INTO kyf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Ɩn wa yia ɔ gbʋ 'wluladɩlɩe bhli -mɔ. Wa nɛɛ: «-A 'kaa nyɩmɛ -mɔnɩ 'yɩ, -zugba ɔ mɩ -amɩaa nyɩma mnɔnʋda. Ɔ nɛɛ -aɩn -yla, -a 'na 'pɛnɩ Sezaa *nisʋn -gwɛzi -nɩ. 'Ɩn ɔ nɛɛ, ɔ dɛ -wa -Lagɔɔ -Bhasanyɔ, mɔ -wa nyɩmaa 'wlulapɩlɩnyɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatɩ yia ɔ layɩbhaɛ: «'Lee, Zuifʋʋ 'wlulapɩlɩnyɔ -ɩn -mɩa yɩ?» -Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «'Mʋ -ɩn gbaa dɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'Ɩn Pilatɩ nɛɛ -Lagɔbʋbɔnyaa -cɩan -yɔ nyɩmaa -zlo -ylaɛ: «Gbʋ -we ka 'gbʋ ɩn 'kaa nyɩmɛ -mɔ nɩ -kaslʋ 'wʋpa, ɩ'ɩn 'yɩ we -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Ɩn wa nɛɛ 'ya wɛlɩ 'tɩtɛ nyaɛ: «Ɔ gbʋslolu wɛlɩ -gʋ nyɩmaa -zlo sɔlʋa nyɩmaa 'wlulapɩlɩnya -yɔ 'wʋ. Galilee dʋdʋ -gʋ ɔ dɩlɩa we gwe, 'ɩn ɔ -yɔ we yia Zudee -dʋdʋ -gʋ 'plɩlɩ, 'bhie, ɔ -yɔ we 'sɔ yia -zɛɛn da -seli nyni -Zeluzalɛmʋ -dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatɩ 'nʋa wa ŋwɛɛ Galileee 'ŋnɩ, 'ɩn ɔ yia layɩbha: «Ɔɔ nyɩmɛ -mɔ nɩ, Galilee -nyɩmɛ -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ɔ 'nʋa nɩɩ, dʋdʋ -we Ewlodʋ pɩlɩa 'wlu la, -mɔ -Zezu 'bhʋa, 'ɩn ɔ nɛɛ, wa kwa ɔ Ewlodʋ. -Mʋʋ bhla, -zugba Ewlodʋ mɩ -slɔ -Zeluzalɛmʋ -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ewlodʋ 'yɩa -Zezu, 'ɩn ɔ yia 'mʋna li. Nɩɩ, wa ka -Zezuu gbʋ -gbada -gwlɛ, -zugba ɔ nʋ we. Ɔ 'yɩbha ɔ 'ka ɔ 'yɩ, -mʋʋ 'bɩ ka 'wʋgwlɛ. 'Ɩn ɔ 'yɩbha ɔ 'ka ɔ gwɛdigbʋ yabhloo lɛnʋda 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɔ yia ɔ gbʋ duun layɩbha, 'ɩn -Zezu 'nɩ we 'yabhlogbɔɔ 'bɩgʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","-Mʋʋ bhla, -Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔɔ titee gwesanya mɩ -bha, -zugba wa dɩlɩ -Zezu gbʋ 'wlu la -gla nya. ");
INSERT INTO kyf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ewlodʋ -yɔ 'slʋja palɩa -Zezu gla, 'ɩn wa yia ɔ gbʋ -kpʋa -nyɩmɛ 'wʋnʋ. 'Ɩn ɔ nɛɛ, wa -pla ɔ 'ylinanɔ -bana 'wʋ, wa kwa ɔ Pilatɩɩ -gbɛ lʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","-Benyi, Ewlodʋ -yɔ Pilatɩ 'sɔ mɩ tʋnyɩma nya. Wee 'ylɩ -bhlokpadɛ nya, wa -zɛa 'tale -yɔ 'tale. ");
INSERT INTO kyf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","-Lagɔbʋbɔnyaa -cɩan klaa, nyɩmaa 'yugalɩnya kpasɩ -yɔ 'gbee nʋkpla -nyɩma weee, Pilatɩ gbelia 'wlu. ");
INSERT INTO kyf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'Ɩn ɔ nɛɛ wa -ylaɛ: «A -laa 'mɩ nyɩmɛ -mɔ nɩ, 'ɩn a nɛɛ, ɔ mɩ nyɩma mnɔnʋda. Mʋ mɩa! 'Mɔ ɩn yɩbhaa dɛ la aɩn 'yu. 'Ɩn gbʋnyii a dɩlɩa ɔ 'wlu la, ɩn 'nɩ ɔ 'yɩ we 'yabhlogbɔɔ lɛnʋnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'Ɩn Ewlodʋ -mɔɔ 'nɩ 'ya ɔ 'yɩ we lɛnʋnyɔ nya. We 'gbʋ, ɔ yia ɔ lʋla -amɩaa -gbɛ. -Mʋʋ 'bɩgʋ, nyɩmɛ -mɔ nɩ, gbʋnyuu -we ɔ nʋa lɛ, -we ka 'gbʋ ɔ 'kaa tlɩ, -mʋʋ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","We 'gbʋ, gbaa na yia wa sɛlɩ ɔ -pnɩ nya bhabha, 'bhie, ɩn 'ka ɔ 'yitide.»  ");
INSERT INTO kyf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sa *'Wʋzɩtɩylɩɩ 'fɛtɩ nynia -bhlo, 'sa Zuifʋʋ tite gbaa Pilatɩ 'tide wa -yla -kaslʋnyɩmɛ yabhlo 'yi. ");
INSERT INTO kyf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Ɩn Pilatɩ 'yɩbha ɔ 'ka -Zezu 'yitidee 'gbʋ, wa 'dɛ weee yia 'wʋkpɩ: «-Ɩn 'bha ɔɔ nyɩmɛ -mɔ nɩ, 'ɩn 'tide -aɩn -yla -Balabasɩ 'yi!» ");
INSERT INTO kyf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Zlɩmɛ -Balabasɩ -sɔlʋa dʋdʋʋ 'wlulapɩlɩnya -yɔ 'wʋ -Zeluzalɛmʋgbe nʋkplɛ, 'ɩn ɔ yia nyɩmɛ 'bha. We 'gbʋ, wa yia ɔ -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɩ 'yɩbha ɔ 'ka -Zezu 'yitidee 'gbʋ, ɔ yi 'yaa wɛlɩ 'wʋbhu 'sɔ, 'ɩn ɔ yia waa nyɩmaa -zlo -yla gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Ɩn wa yia 'wʋkpɩ 'tɩtɛɛ ɔ -yla: «Kʋlʋ ɔ *su -gʋ la! Kʋlʋ ɔ su -gʋ la!» ");
INSERT INTO kyf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatɩ 'bhua wɛlɩ -zakpa tanʋ 'wʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Gbʋnyuu -mʋmʋ ɔ nʋ lɛa? Gbʋnyuu -we ɔ nʋa lɛ, -we ka 'gbʋ ɔ 'kaa tlɩ, ɩ'ɩn 'yɩ we -yɔ. We 'gbʋ, gbaa na yia wa sɛlɩ ɔ -pnɩ nya bhabha, 'bhie, ɩn 'ka ɔ 'yitide.» ");
INSERT INTO kyf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Ɩn wa yia 'wʋkpɩ, -zugba wa kpalɩ wee gbʋ -bhloo 'dɛ ŋwɛ, wa kʋlʋ -Zezu su -gʋ la. 'Ɩn wa ŋwɛ -yɔtɛlɔ yia Pilatɩ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","We 'gbʋ, -we wa 'yɩbhaa, 'ɩn Pilatɩ yia we lɛnʋgbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nyɩmɛ -ɔ -sɔlʋa nyɩmaa 'wlulapɩlɩnya -yɔ 'wʋ, 'ɩn ɔ yia nyɩmɛ 'bha, 'mɔ wa 'yɩbhaa wa tide 'yi. 'Ɩn Pilatɩ yia -mɔɔ 'yitide. 'Ɩn ɔ yia wa -Zezu yoo 'nyɛ, 'ɩn -we wa -ka 'yɩbha, wa 'ka we ɔ nʋnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Da wa -yɔ -Zezu mɩa mnɩda, 'ɩn Silɛnɩyu 'Simɔɔ, wa -yɔ -mɔɔ yia gbeli, -zugba ɔ bhʋ kpaa. 'Slʋja yia ɔ kpa, 'ɩn wa yia ɔ -Zezuu su -blɩgba 'wʋlapalɩ, ɔ 'ka we ɔ 'bɩ kwa. ");
INSERT INTO kyf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nyɩmaa -zlo mɩ ɔ 'bɩ. 'Ɩn ŋwnɩ mɩa wa glaa, -zugba -maa bhɩtɩ kɩklɩ, 'ɩn wa bhalɩ ɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","-Zezu 'bhitia la wa gbɛgbɛɩn, ɔ nɛɛ wa -ylaɛ: «-Zeluzalɛmʋ -ŋwnɩ, a 'na wili na 'gbʋ -nɩ, a wi amɩaa 'dɛ -yɔ amɩaa 'yuaa 'gbʋ! ");
INSERT INTO kyf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nɩɩ, we bhla yia nynia, 'ɩn wa 'ka gbaɛ: ‹'Ŋwnɩ -wa 'nɩa mneni wa 'ka 'yu gwalɩ, -wa 'nɩa -slɔ gwalɩ, 'ɩn -wa 'nɩa -slɔ 'yu 'nyɛnɩ, 'wʋtʋtʋe -dlɔɔ mɩ -maa -nʋ nya!› ");
INSERT INTO kyf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nɩɩ, nyɩma yia gbaa -gɔgɔnya -yla: ‹A bhlili -aɩn -gʋ!› 'Ɩn wa 'ka gba 'kpidanya -yla: ‹A zize -aɩn!› ");
INSERT INTO kyf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nɩɩ, we -ka 'sa wa nʋ sa su yalʋ, 'ɩn lɛɛ -lu 'ka suu yɛyɛnʋ ylɩa?» ");
INSERT INTO kyf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wee bhla -bhlokpadɛ nya, nyɩma sɔ mɩa gbʋnyuu -lɛnʋnya nya, 'ɩn 'slʋja -yɔ -maa yi 'yaa yi, wa 'ka wa -yɔ -Zezu 'bha dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Da wa nynia da ka 'ŋnɩ wa laa «'Wluu 'kʋa», -bha 'slʋja kʋlʋa -Zezu su -gʋ la. 'Ɩn wa yi 'yaa -bha gbʋnyuu -lɛnʋnya 'sɔ su -gʋ lakʋlʋ. 'Yabhlo mɩ ɔ lilisɔlʋ, 'ɩn -gʋdʋ mɩa ɔ kɔpɛsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tɔʋn, -Zezu nɛɛ, «Dide, -ɩn tɩ wa -yɔgbʋ 'wʋ, -we wa mɩa lɛnʋda, wa 'nɩ we -yi.» 'Ɩn wa yia -nɩgbɩ 'pa, -zugba wa dlili ɔ -bana, wa 'dɛkpʋa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nyɩmaa -zlo mɩa -bha, -zugba wa yla -we mɩa 'plɩda. Zuifʋʋ 'yugalɩnya yia ɔ gla palɩ, -zugba wa gbaɛ: «Ɔ ka nyɩma tɔlʋa pue, ɔ pue -slɛɛn ɔ 'dɛ, -zugba *Klisɩ -ɔ -wa -Lagɔɔ -Bhasanyɔ, ɔ -ka ɔ nya -mɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Slʋja yi 'yaa -Zezu gla palɩ. Wa bɛa ɔ kwesi, 'ɩn wa yia ɔ kalɔ nʋ 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'Ɩn wa nɛɛ: «We -ka Zuifʋʋ 'wlulapɩlɩnyɔ -ɩn -mɩ, -ɩn -sa -na 'dɛ gbʋ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɔ 'wlu -bita, wa yia -bha cɛlɩ: ");
INSERT INTO kyf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Ɩn waa gbʋnyuu -lɛnʋnyaa 'yabhlo mɩa su -gʋ lakʋlʋda, -mɔɔ yia -Zezu vɛlɩ. Ɔ nɛɛ: «-Ɩn 'nɩ -Lagɔɔ -Bhasanyɔɔ? -Ɩn pue -na 'dɛ, 'ɩn -ɩn 'ka -amɩa pue!» ");
INSERT INTO kyf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Ɩn, ɔɔ gbʋnyuu -lɛnʋnyɔ -gʋdʋ yia ɔ -libheyi -yla gbʋ lapalɩ. Ɔ nɛɛ ɔ -ylaɛ: «-Ɩ'ɩn sɔ -Lagɔɔ? Nyɩmɛ -ɔ -a -yɔ ɔ 'sɔ mɩa da tlɩtlɩ -kaslʋ -bhlo 'wʋ, ɔmɔ 'nɩ gbʋnyuu yabhlogbɔɔ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","We klʋ -wa -amɩa 'ka -kaslʋ -mɩnɩ pla, gbʋnyii -a nʋa lɛ, we 'pɛnɩe -wa. 'Ɩn ɔmɔ 'nɩ gbʋnyuu yabhlogbɔɔ lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Bhie, ɔ yia we -gʋdɩɛ: «-Zezu, zlɩ -ɩn -ka -na nyɩma 'wlulapɩlɩa yi, -ɩn ligbe 'mɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","-Zezu yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Ɩn nɛɛ -mɩ -yla gbʋzɔnʋ saɛ: -zɛɛn -ylɩ -mɩnɩ nya, -ɩn -yɔ 'mɩ 'sɔ mɩ -Lagɔɔ dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","'Ylʋ 'ka -glɔnyɩdɩ nynia yi, we nyumoa 'wʋ, 'ɩn nikpise yia kpa dʋdʋ weee -gʋ. We li 'lɛlɩ ta. ");
INSERT INTO kyf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Ɩn 'naa bɩzɩa -Lagɔbudu 'kadʋ zɔ, we yia 'wʋyla 'sɔ we nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","-Zezu 'kpɩa 'wʋ wɛlɩ 'tɩtɛ nya, 'ɩn ɔ nɛɛ: «Dide, -mɩ kwɛɛ na zʋa na zuzu.» Ɔ bhɩa 'saa gbagbɩe, tɔʋn, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","-We weee 'plɩa, *Wlɔmʋ -slʋja glʋ gbuu 'yugalɩnyɔ 'yɩa we -yɔ, 'ɩn ɔ yia -Lagɔɔ 'ŋnɩ -mnɩnɩ, 'ɩn ɔ nɛɛ: «Gbʋzɔnʋ -wa, ɔɔ nyɩmɛ -mɔnɩ, nyɩmɛ tɩklɩɩ -wa 'piɛɩn!» ");
INSERT INTO kyf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nyɩma -duun -wa yia gbʋ -mɩnɩ ylaa, -we weee 'plɩa, 'ɩn wa yia we -yɔyɩ. 'Ɩn ŋwɔtlɔ yia wa -gʋ slu, 'ɩn wa -yɔ kɩklɩ bhɩtɩe yia nyazɩ nya wa -zɔɔ lʋbhiti. ");
INSERT INTO kyf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","-Zezuu 'talea weee -yɔ 'ŋwnɩ -wa -yɔ ɔ 'bhʋa Galilee, 'ɩn wa yia ɔ yoo kwaa, wa 'yligbe 'pɩpɩ, -zugba wa yla -we weee mɩa 'plɩda. ");
INSERT INTO kyf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Zuifʋʋ 'gbe yabhlo wa laa Alimatee, we nyɩmɛ yabhlo wa laa *-Zɛzɛfʋ, -mɔɔ mɩ 'ya -bha. Nyɩmɛ -zɔnʋ -yɔ nyɩmɛ tɩklɩɩ -wa. Ɔ mɩ -Lagɔɔ nyɩmaa 'wlulapɩlɩe wʋda, 'ɩn ɔ mɩa Zuifʋʋ gbʋwliwʋdɩnyaa glaa -nyɩmɛ yabhlo nya. -We gbʋwliwʋdɩnya tɔlʋa pʋpalɩa, 'ɩn wa nʋa lɛ, ɔ -yɔ wa 'sɔ 'nɩ we -gʋ wɛlɩ -bhlo -ka. ");
INSERT INTO kyf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɔɔ -Zɛzɛfʋ mnɩa Pilatɩɩ -gbɛ, 'ɩn ɔ yia -mɔɔ -Zezuu 'kwie -zlalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","-Mʋʋ 'bɩgʋ, 'ɩn ɔ yia wee 'kwie su -gʋ -sa, 'ɩn ɔ yia we 'naa -yɔ zʋ. 'Bhʋka -we wa 'bhlua tʋkpa 'wʋ, 'ɩn wa 'nɩa -slɔ 'kwie nʋkplɛ fa, we nʋkplɛ ɔ faa wee 'kwie. ");
INSERT INTO kyf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","'Ylɩ -we nya wa mnazɩa wa 'dɛ la, wee 'ylɩ nya -Zɛzɛfʋ faa wee 'kwie 'bhʋka 'wʋ. 'Ɩn we nya *Nyapɛylɩ dɩa gwe. ");
INSERT INTO kyf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Ŋwnɩ -wa -yɔ -Zezu 'bhʋa Galilee -dʋdʋ -gʋ, -maa -yɔ -Zɛzɛfʋ yia 'bhʋka -gʋ mnɩ. Wa yia wee 'bhʋka 'wʋ -talɩ, 'ɩn sa wa palɩa -Zezuu 'kwie la, 'ɩn wa yia we -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","-Mʋʋ 'bɩgʋ, 'ɩn wa yia wa -zɔɔ lʋbhiti. 'Ɩn ŋnɛ -ka kpɩ -yɔ -lasiklɔ -we ka ŋnɛ mɛnɩa, wa yia we pi, -we wa 'kaa 'kwiee ku -yɔ 'pa. Wa tite nɛɛ, Zuifʋʋ Nyapɛylɩ nya, wa 'na nʋnʋ lubho -nɩ. We 'gbʋ, wa yia nyapɛda -tʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dimasɩɩ zlʋkpɛ -papa, 'ɩn 'ŋwnɩ yia kpɩ -we ka ŋnɛ mɛnɩa wa pia, we nya gbawla -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhla waa 'ŋwnɩ 'ka -bha nyni, -zugba tʋkpa -boklo 'kadʋ 'nɩ gbawla ŋwɛɛ -mɩ, wa ka we glipe. ");
INSERT INTO kyf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wa -talɩa gbawla nʋkplɛ, wa 'nɩ Nyɩmaa -Kanyɔ -Zezuu 'kwie 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","-We waa 'ŋwnɩ 'kaa 'wlukʋʋn lapʋpalɩ, wa 'nɩ we -yi. Tɔʋn, nyɩma sɔ kaa lɩlɩbana 'pʋpa 'ylɩylɩ 'wʋ, -maa yia wa 'klʋtlalɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nyanɔ sloa 'ŋwnɩ 'wʋ, 'ɩn wa yia 'wlu lagbli. Waa nyɩma 'sɔ nɛɛ wa -ylaɛ: «Lɛɛ -lu ka 'gbʋ a talɩ 'yliyɔganyɔɔ da tlɩtlɩnya glaa? ");
INSERT INTO kyf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ 'nɩ -seli -mɩ. Ɔ ka 'wʋsɔ tlɩtlɩnya glaa. Da ɔ mɩa zlɩmɛ Galilee, -we ɔ gbaa aɩn -yla, a ligbe we: ");
INSERT INTO kyf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹We mɩ nɩɩ, wa 'nyɛ *Nyɩmɛɛ 'Yu gbʋnyuu -lɛnʋnya yoo. Wa 'ka ɔ su -gʋ lakʋlʋ, 'ɩn 'ylɩ 'sɔ we taa zlɩ, ɔ 'ka tlɩtlɩnya glaa 'wʋsɔ.› » ");
INSERT INTO kyf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Ɩn waa 'ŋwnɩ yia -Zezuu wɛlɩnya ligbe. ");
INSERT INTO kyf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wa 'bhʋa gbawla -gʋ, 'ɩn wa yia we gbaa mnɩ -Zezuu 'bɩnɔnya kugbua lɛ -bhlo -yla, we -yɔ nyɩma -tɔlʋa -yɔ wa 'sɔ mɩa. ");
INSERT INTO kyf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","'Ŋwnɩ -wa -laa wee 'dɩ -mɩnɩ -Zezuu tietienya, wa ŋnɩ nɩ: Magɩdala -ŋwnɔ Malii, Zanɩ, *'Zakee 'nyaa Malii -yɔ 'ŋwnɩ -tɔlʋa -yɔ wa 'sɔ mɩa. ");
INSERT INTO kyf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Ɩn waa -Zezuu tietienya nɛɛ wa 'dɛɛ dlɩ zɔɛ, -we waa 'ŋwnɩ mɩa gbada, gbʋ -kpʋa -waa 'gbʋ, wa 'nɩ wa dlɩ 'wʋdɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","-Bha Piɛlɩ -sɔa 'wʋ, 'ɩn ɔ -yɔ -gwagwɩe yia gbawla -gʋ mnɩ. Ɔ kwlia 'wʋ, ɔ -talɩa 'bhʋka 'wʋ, 'naapɩnya wa bibelia 'kwie -yɔ la, we 'dɛkpʋa ɔ 'yɩa -yɔ. 'Ɩn ŋwɛgaga yia ɔ sʋbha, -we weee 'plɩaa 'gbʋ. 'Ɩn ɔ yia ɔ -buduŋwɛɛ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","14","'Gbe -we wa laa Emausɩ, we -yɔ -Zeluzalɛmʋ 'sɔ, kilo kugbua lɛ -bhlo mɩa we nyɩdɩ. Wee 'ylɩ -bhlokpadɛ nya, -Zezuu 'bɩnɔnya glaa -nyɩma 'sɔ mɩa -mɔ mnɩda. -We weee 'plɩa, -zugba wa -yɔ we 'dɩsasɩe mnɩ 'yloogblʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bhla -we nya wa mɩa gbada, 'ɩn wa mɩa kpɛlɩda, -Zezuu 'dɛbhie -gbolu yia wa kwesi bɛ, 'ɩn ɔ -yɔ wa yia bhʋ 'wʋ mnɩ dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","-Zezuu 'bɩnɔnya 'yɩa ɔ -yɔ, 'ɩn -lu yabhlo'o ŋwnu, wa 'ka ɔ yibheli. ");
INSERT INTO kyf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Ɩn -Zezu yia wa layɩbha: «'Lee, lɛɛ gbʋ -gʋ a kpɛlɩ nɔda 'yloogblʋa?» Tɔʋn, wa dlɩ yia sumanɩ, 'ɩn wa yia 'yligbe. ");
INSERT INTO kyf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wa 'dɛ 'sɔ glaa 'yabhlo wa laa Kleopasɩ, -mɔɔ nɛɛ ɔ -ylaɛ: «-Na 'dɛ -bhlo -wa -Zeluzalɛmʋ -nyɩmɛ, -ɔ 'nɩa gbʋ 'plɩa 'wʋbhlolu -ylɩnya nɩ nyaa 'ji -yi yɩ?» ");
INSERT INTO kyf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Ɩn ɔ yia wa layɩbhaɛ: «Mɔɔ -gbʋ we -ma?» 'Ɩn wa yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Gbʋ -we 'ylɩa Nazalɛtɩyu -Zezu, mʋ -wa! -Lagɔgbʋʋ -falɩpanyɔ 'tɩtɛ ɔ -mɩa. Ɔ ka we -slolu ɔ lɛnʋgbʋnya -yɔ ɔ wɛlɩnya 'wʋ, -Lagɔ -yɔ nyɩma 'yu. ");
INSERT INTO kyf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","-Amɩaa *-Lagɔbʋbɔnyaa -cɩan -yɔ -amɩaa 'yugalɩnya ka -Zezu wla, wa 'bha ɔ, 'ɩn wa yia ɔ *su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","-Amɩa dɩ we dlɩ 'wʋ nɩɩ, mɔ 'ka yaa Izlaɛlɩnyɩma gbʋ 'wʋsa. 'Ɩn -mʋʋ weee -gʋ, gbʋnya 'plɩa, we 'ylɩ taa zlɩ mɩa -zɛɛn. ");
INSERT INTO kyf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gbʋzɔnʋ -wa, -amɩa glaa ŋwnɩ tɔlʋa ka -aɩn ŋwɛgaga -sʋbhalɩ. Zlʋkpɛ -papa, 'ɩn wa yia gbawla -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Wa 'nɩ ɔ 'kwie 'yɩ. 'Ɩn wa yia lʋyi, -bha wa gbaa -aɩn -ylaɛ, -Lagɔɔ 'anzɩnya ka wa 'klʋtlalɩ, 'ɩn we nɛɛ wa -ylaɛ: ‹-Zezu -ga 'yliyɔ!› ");
INSERT INTO kyf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","-Amɩa lʋ -nyɩma tɔlʋa ka gbawla -gʋ mnɩ, 'ɩn gbʋ -we 'ŋwnɩ gbaa, wa yi 'saa we ylɩ. Wa 'nɩ -Zezuu 'dɛ 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","'Ɩn -Zezu nɛɛ wa -ylaɛ: «Nyɩma -wa 'nɩ 'ylimna, 'ɩn gbʋ -we -Lagɔgbʋʋ -falɩpanya gbaa, -wa'a 'nʋ we 'wʋla -pa! ");
INSERT INTO kyf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","We mɩ nɩɩ, -Lagɔɔ -Bhasanyɔ sɩa sa, 'bhie, -Lagɔ 'ka ɔ 'ŋnɩmnɩe ɔ yoo 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","-Mʋʋ 'bɩgʋ, -we wa cɛlɩa ɔ daa, -Lagɔsɛbhɛ 'wʋ, ɔ yia we gwe -sa wa -yla. Ɔ dɩa we gwe Moizɩɩ 'sɛbhɛ -gʋ, 'ɩn ɔ -yɔ we yia -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ weee 'wʋ pla. ");
INSERT INTO kyf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","'Gbe -we 'wʋ ɔ 'bɩnɔnya 'sɔ mɩa mnɩda, da wa nynia we kwesi, 'ɩn -Zezu yia nʋ nɛɛ, da 'pɩpɩ ɔ mɩ mnɩda. ");
INSERT INTO kyf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Ɩn wa yia ɔ -klolu, 'ɩn wa nɛɛ ɔ -ylaɛ: «-Ɩn -yɔ -aɩn 'sɔ -tʋ! Jibhe ka zɔ, 'ɩn sabɔ ka bɛbee bhɩa.» 'Ɩn ɔ yia -budu zɔ pla, ɔ -yɔ wa 'sɔ 'ka -tʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ɔ -yɔ wa -dɩa lililu gwe la, ɔ 'bhua 'floo 'wʋ, 'ɩn ɔ yia -Lagɔ fuo 'pa. -Mʋʋ 'bɩgʋ, ɔ dɩdlɩa we la, 'ɩn ɔ yia we wa 'wʋladlili. ");
INSERT INTO kyf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tɔʋn, wa 'yli -bloa, 'ɩn wa yia ɔ yibheli. -Bha -bhlokpadɛ, ɔ yia wa 'yligwe mnɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","'Ɩn wa nɛɛ, wa 'dɛkpʋa nyɩdɩɛ: «Da -a mɩa 'yloogblʋ, ɔ mɩa -aɩn -yla gbʋ gbada, -zugba ɔ sa -aɩn -yla -Lagɔsɛbhɛ gwe, 'mʋna ka -aɩn dlɩ zɔ ye, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wa -sɔa 'wʋ -bha -bhlokpadɛ, 'ɩn wa yia -Zeluzalɛmʋ lʋmnɩ, -mɔ wa ylɩa -Zezuu tietienya kugbua lɛ -bhlo -yɔ wa -lima 'wlu gbelida. ");
INSERT INTO kyf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'Ɩn -maa nɛɛ wa -ylaɛ: «Gbʋzɔnʋ -wa, Nyɩmaa -Kanyɔ ka tlɩtlɩnya glaa 'wʋsɔ. Nɩɩ, ɔ ka 'Simɔɔ 'klʋtlalɩ.» ");
INSERT INTO kyf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'Ɩn -maa 'sɔ yia -we 'plɩa 'yloogblʋʋ 'dɩ -sa wa -yla. Sa wa yibhelia -Zezu, -zugba ɔ mɩ 'floo ladɩdlɩda, 'ɩn wa yi 'yaa -mʋʋ gba wa -yla. ");
INSERT INTO kyf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Da wa mɩa -slɔ gbada, 'ɩn -Zezu yia ɔ 'dɛ -slolu wa nyɩdɩ. 'Ɩn ɔ nɛɛ wa -ylaɛ: «'Wʋtʋtʋe -dlɔɔ -yɔ aɩn 'sɔ -mɩ!» ");
INSERT INTO kyf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","-Nyanɩgbɔ -kpalɩa wa, 'ɩn wa yia nyanɔ nʋ. Wamɩa nɛɛ yaa 'sa nɩɩ, nyɩmɛzuzu -wa. ");
INSERT INTO kyf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","-Zezu nɛɛ wa -ylaɛ: «Lɛɛ -lu sumanɩ amɩaa dlɩa? 'Ɩn lɛɛ ka 'gbʋ a lʋ sa dlɩa? ");
INSERT INTO kyf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","A yla na -kwɩtɛ -yɔ na bhʋpatʋnya, -amɩ -wa, gbʋzɔnʋ sa! A zɩ 'mɩ kwɛ, 'ɩn a yla, nɩɩ, nyɩmɛzuzu 'nɩ yɩcɛ -yɔ 'kʋa -ka. Sa a yɩa dɛ 'mɩ -yɔ 'bhisa.» ");
INSERT INTO kyf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɔ gba 'saa, 'bhie, ɔ yia ɔ -kwɩtɛ -yɔ ɔ bhʋpatʋnya wa 'klʋslolu. ");
INSERT INTO kyf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","'Mʋna ka wa ye, 'ɩn ŋwɛgaga yia wa sʋbhaa 'gbʋ, -we -Zezu mɩa wa -yla gbada, wa 'nɩ mneni wa 'ka we dlɩ 'wʋdɩ. 'Ɩn ɔ yia wa layɩbhaɛ: «-Lu -we a 'kaa li, we mɩ -seli aɩn kwɛɛ?» ");
INSERT INTO kyf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Ɩn wa yia ɔ llalla -zibhii kibhe 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɔ 'bhua we 'wʋ, 'ɩn ɔ yia we li wa 'yibadɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","-Mʋʋ 'bɩgʋ, ɔ nɛɛ wa -ylaɛ: «Da ɩn -yɔ aɩn 'sɔ mɩa -benyi, ɩn nɛɛ aɩn -ylaɛ: we mɩ nɩɩ, -we weee wa cɛlɩa na daa, Moizɩɩ titee 'sɛbhɛ 'wʋ, -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ -yɔ Lʋʋsɛbhɛ 'wʋ, we nʋ lɛ.» ");
INSERT INTO kyf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Ɩn ɔ yia wa 'wlukʋʋn ladolu, wa 'ka -Lagɔsɛbhɛ 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Ɩn ɔ nɛɛ wa -ylaɛ: «-We mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ mʋ nɩ: we mɩ nɩɩ, -Lagɔɔ -Bhasanyɔ sɩa, 'ɩn ɔ 'ka tlɩ. Wa -ka ɔ gbawla 'wʋfa, 'ylɩ 'sɔ we taa zlɩ, 'ɩn ɔ 'ka 'wʋsɔ tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɔ 'ŋnɩ nya, -Lagɔgbʋ -we 'kaa nyɩmaa dlɩ 'bhiti, 'ɩn -Lagɔ 'ka wa -yɔgbʋ 'wʋtɩ, a bhli we gbagbɩe -Zeluzalɛmʋ, 'ɩn a -yɔ we 'ka dʋdʋ weee -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɩɩ, amɩa -wa we dayɩnya. ");
INSERT INTO kyf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Ɩn Zuzu -ɔ Dide gbaa ɔ 'ka aɩn 'nyɛ, -amɩ yia we aɩn yoo 'paa. We 'dɛɛ 'gbʋ, amɩa, a -tʋ wee gbe nɩ nʋkplɛ tɩklɩɩ, 'ɩn -Lagɔɔ 'tɩtɛ 'ka aɩn -gʋ lasibhli.» ");
INSERT INTO kyf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","-Mʋʋ 'bɩgʋ, -Zezu -yɔ ɔ 'bɩnɔnya yia Betani kwesi mnɩ, ɔ yia sɔ 'wʋbhu, 'ɩn ɔ yia wa 'nyulaŋwna. ");
INSERT INTO kyf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Da ɔ mɩa wa 'nyulaŋwnada, ɔ yia wa gwevla, 'ɩn -Lagɔ yia ɔ 'wʋbhu, ɔ yia yalɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wa 'ylimanɩa ɔ, 'bhie, wa yia -Zeluzalɛmʋ lʋbhiti 'mʋna 'kadʋ nya. ");
INSERT INTO kyf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Kɔmʋʋ, wa mɩ -Lagɔbudu 'kadʋ zɔ, -zugba wa mnɩnɩ -Lagɔɔ 'ŋnɩ.");
INSERT INTO kyf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","-Lagɔ 'nɩa -slɔ -lu weee lala, -ɔ wa laa Wɛlɩ ɔ mɩ la. Wee Wɛlɩ -yɔ -Lagɔ 'sɔ mɩ. Wee Wɛlɩ -yɔ -Lagɔ mɩ -bhlo. ");
INSERT INTO kyf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","-Lu weee gwedɩda, ɔ -yɔ -Lagɔ 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɔ gbɛgbɛɩn -Lagɔ -laa -lu weee la. -Lu -we mɩa lalada ɔ 'bɩgʋ we 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nɩɩ, ɔ -gʋ 'yliyɔgagɩe 'bhʋa, 'ɩn wee 'yliyɔgagɩe mɩa, we ka nyɩma zlɩ -la. ");
INSERT INTO kyf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Wee zlɩ mɩ lɩda nikpise 'wʋ, 'ɩn nikpise 'nɩ we nyumonu. ");
INSERT INTO kyf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","-Lagɔ ka nyɩmɛ yabhlo tie, 'mɔ wa laa *Zaan, ");
INSERT INTO kyf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","mɔ -wa gbʋdayɩnyɔ, mɔ yia ɔ 'ka zlɩɩ -gʋgbʋ gba. Yi ɔ yia nyɩma -ka ɔ wɛlɩ 'nʋ, 'ɩn wa 'ka dlɩ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɔ 'dɛ 'nɩ wee zlɩ nya -mɩ, nɩɩ, yi ɔ yia ɔ 'ka wee zlɩɩ -gʋgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","-We mɩa da nɩ, mʋ -wa zlɩɩ 'zayli, wee zlɩ yia dʋdʋ -gʋ, we san mɩ 'mnida nyɩma weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɔɔ Wɛlɩ ka dʋdʋ -gʋ yi. Ɔ gbɛgbɛɩn -Lagɔ -laa dʋdʋ la, we mɩ 'sa 'bhie, dʋdʋgʋ -nyɩma 'nɩ ɔ yibheli. ");
INSERT INTO kyf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ yia ɔ 'dɛɛ nyɩmaa -gbɛ nɩ, wa 'nɩ ɔ kpa 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nɩɩ, tɔlʋa 'paa ɔ yi, 'ɩn wa yia ɔ dlɩ -gʋ zʋ. -Maa mɩa, -maa ɔ 'nyɛa 'yoo wa 'ka -Lagɔɔ 'yua -zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sa nyɩma gwalɩa wa 'yua dʋdʋ -gʋ, we 'nɩ 'sa -manɩ -zɛ -Lagɔɔ 'yua. We 'nɩ nyɩmɛ mɩ wa dide nya. Nɩɩ, -Lagɔ 'nyɛa wa 'yliyɔgagɩe. ");
INSERT INTO kyf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɔɔ Wɛlɩ ka nyɩmɛ -zɛ, 'ɩn ɔ yia -aɩn glaa ladɩ. Ɔ 'gbʋ -a yia 'nanɩdlɩ -yɔ -Lagɔɔ gbʋzɔnʋ yibheli. -A ka ɔ yla, 'ɩn sa ɔ 'ŋnɩ mnɩa -Lagɔɔ 'ŋnɩ 'bhisa, -a ka we -yɔyɩ. Nɩɩ, 'ŋnɩmnɩe -we -Lagɔɔ 'Yu -bhlo 'yɩa ɔ Dide kwɛɛ, mʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zaan mɩ ɔ gbʋdayɩnyɔ nya, ɔ 'kpɩa 'wʋ, ɔ nɛɛ: «Da ɩn gbaa: ‹-Ɔ yia na 'bɩgʋ, ɔ 'ŋnɩmnɩe -zi na -nʋ, -we ka gbʋ -wa, bhla ɩn 'ka 'wlʋ ɔ mɩ -bha› 'mɔ ɩn saa 'ŋnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","'Nanɩdlɩ duun ɔ kaa, we nya ɔ ŋwnaa -a 'dɛ weee 'nyu la. Ɔ palɩa -aɩn sɔ -zɔnʋ -gʋ la, 'ɩn ɔ yia we -gʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nɩɩ, -Lagɔ palɩa ɔ tite *Moizɩɩ gbɛgbɛɩn, nɩɩ, -Zezu *Klisɩɩ gbɛgbɛɩn -a yibhelia ɔ 'nanɩdlɩ -yɔ ɔ gbʋzɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ -Lagɔ 'yɩ, nɩɩ, ɔ 'Yu -bhlogbɔɔ -ɔ -yɔ ɔ mɩa -bhlo, 'ɩn -ɔ mɩa ɔ Dide kwesi, mɔ slolua -aɩn -Lagɔ. ");
INSERT INTO kyf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","*Zuifʋʋ 'yugalɩnya -wa mɩa *-Zeluzalɛmʋ, ma tiea -Lagɔbʋbɔnya -yɔ wa -yɔbɛnya *Leviii zʋaylinyɩma tɔlʋa, wa 'ka Zaan layɩbha nyɔɔ ɔ -mɩa. Zaan 'nɩ kalɩ 'pa, 'sa ɔ 'palɩa we 'bɩgʋ sa tɩklɩɩ. -We ka da ɔ 'yɩa, 'mʋ ɔ gbaa, mʋ -wa nɩɩ: «-Amɩ, ɩn 'nɩ -Lagɔɔ -Bhasanyɔ nya -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Ɩn wa yi 'yaa ɔ layɩbha: «We -ka 'sa -mɩ, nyɔɔ -ɩn -mɩa? *-Lagɔgbʋʋ -falɩpanyɔ *Elii -ɩn -mɩa yɩ?» Ɔ nɛɛ: «-Ɩnnya, ɩn 'nɩ -mɔɔ.» Wa nɛɛ 'yaɛ: «Ɔɔ -Lagɔgbʋʋ -falɩpanyɔ -putu -a mɩa wʋda nɩ, 'mɔ -ɩn -mɩa yɩ?» Ɔ nɛɛ: «-Ɩnnya.» ");
INSERT INTO kyf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","We 'dɛɛ 'gbʋ wa nɛɛ ɔ -yla: «Nyɔɔ -ɩn -mɩa? -A -ka mnɩ, -wa tiea -aɩn, -a 'ka wa 'dɩ -salɩ, -ɩn nɛɛ -na 'dɛɛ daa lɛa?» ");
INSERT INTO kyf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wɛlɩ -we -Lagɔgbʋʋ -falɩpanyɔ *Ezaii gbaa, 'mʋ Zaan palɩa: « ‹Nyɩmɛ yabhlo -ɔ 'kpɩa 'wʋ -mɔ da bɛblɛɛ: a nʋ Nyɩmaa -Kanyɔɔ 'yoo tɩklɩɩ ɔ 'yu›, 'mɔ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nyɩma -wa wa tiea Zaaan -gbɛ, *Falizɩnyɩma mɩ wa glaa. ");
INSERT INTO kyf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wa 'yɩbhaa ɔ la: «Nɩɩ, -ɩn 'nɩ -Lagɔɔ -Bhasanyɔ nya -mɩ, -ɩn 'nɩ -Lagɔgbʋʋ -falɩpanyɔ Elii, 'ɩn -Lagɔgbʋʋ -falɩpanyɔ -putu -a mɩa wʋda, -ɩn 'nɩ -mɔɔ, we -ka 'sa -mɩ, lɛɛ -lu ka 'gbʋ -na batizee nyɩma?» ");
INSERT INTO kyf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ɔ nɛɛ: «Gbʋzɔnʋ -wa, -amɩ mɩa, nyɩma na batizea 'nyu nya. Nɩɩ, aɩn nyɩdɩ, nyɩmɛ yabhlo mɩ -bha, a 'nɩ ɔ -yi. ");
INSERT INTO kyf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mɔ yia 'mɩ 'bɩ yia, ɩn 'nɩ mneni ɩn 'ka ɔ -sakwlaa 'llukpe -blo.» ");
INSERT INTO kyf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","-We weee mɩa da, Betani we nʋa lɛ, -mɔ Zudɛɛn nyu 'ylʋʋ 'wʋsɔlʋda, da Zaan batizea nyɩma. ");
INSERT INTO kyf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Zlɩ zlɩa, -Zezu mɩ Zaaan gbɛgbɛɩn yilida, 'ɩn Zaan yia ɔ -yɔyɩ, 'ɩn ɔ nɛɛ: «A yla, -Lagɔɔ *Bhlabhlɛyu nɩ, ɔ mɩ dʋdʋgʋ -nyɩma gbʋnyuu -bhasada. ");
INSERT INTO kyf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Da ɩn gbaa nɩɩ, nyɩmɛ yia 'mɩ 'bɩ yia, ɔ 'tɩtɛ -zi na -nʋ, nɩɩ, wa 'nɩa -slɔ 'mɩ gwalɩ, ɔ mɩ la, 'mɔ ɩn saa 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Zlɩmɛ, ɩn 'nɩ ɔ -yi, ɩn 'ka ɔ *Izlaɛlɩnyɩma -slolu wa 'ka ɔ yibheli, we 'gbʋ ɩn yia nyɩma batizea yi 'nyu nya.» ");
INSERT INTO kyf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Zaan ka 'ya ɔ gbʋʋ da 'yɩ, ɔ nɛɛ: «Nɩɩ, zlɩmɛ, ɩn 'nɩ ɔ -yi, nɩɩ, -Lagɔ -ɔ tiea 'mɩ ɩn 'ka nyɩma batizee 'nyu nya, ɔ nɛɛ 'mɩ -yla: ‹-Ɔ -gʋ -ɩn -ka -Lagɔɔ Zuzu 'yɩ kwlida, 'ɩn we 'ka bha -tʋ, mɔ -wa nyɩmɛ -ɔ 'kaa nyɩma batizee -Lagɔɔ Zuzu 'Pʋpa nya. Nɩɩ, -amɩ -wa ɔ gbʋdayɩnyɔ. Ɩn ka -Lagɔɔ Zuzu -yɔyɩ. Ɔ 'bhʋa yalɩ, ɔ 'sibhlia ɔ -gʋ la -kpakʋn 'bhisa, 'ɩn ɔ yia -bha -tʋ.› ");
INSERT INTO kyf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","-Amɩ, ɩn ka ɔ -yɔyɩ, mʋ 'gbʋ ɩn yia gba nɩɩ, ɔɔ nyɩmɛ mɩa da, -Lagɔɔ 'Yu ɔ -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Zlɩ zlɩa, Zaan -yɔ ɔ 'bɩnɔnya 'sɔ mɩ 'ya -bha, ");
INSERT INTO kyf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'ɩn -Zezu yia 'plɩa yi. Zaan ylaa ɔ, ɔ nɛɛ: «A -talɩ, -Lagɔɔ Bhlabhlɛyu nɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ɔ 'bɩnɔnya 'sɔ 'nʋa -we ɔ gbaa, 'ɩn wa yia -Zezu 'bɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","-Zezu 'bhitia la, ɔ 'yɩa nɩɩ, wa mɩ ɔ 'bɩ, 'ɩn ɔ nɛɛ wa -yla: «Lɛɛ -lu ka da a talɩa?» Wa nɛɛ ɔ -yla: «*Wlabi, mɔ -ɩn -dɩlɩ la?» (Nɩɩ, Wlabii ji -wa zuifʋwɛlɩ 'wʋ: «Gbʋslolunyɔ».) ");
INSERT INTO kyf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɔ nɛɛ: «A yi, 'ɩn a 'ka -bha 'yɩ.» Wa mnɩa da ɔ -dɩlɩa la, 'ɩn wa yia -bha 'yɩ, -zugba jibhezaa -lɛlɩ -mnʋanʋ ka nyni. 'Ɩn wa yia wee 'ylɩɩ pnɩɩ bhɩa ɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wa 'dɛsɔbhie glaa, -wa 'nʋa Zaaan wɛlɩ, 'ɩn wa yia -Zezu 'bɩ mnɩ, wa 'yabhlo -wa Simɔ Piɛlɩɩ bheli Andlee. ");
INSERT INTO kyf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tɩada, mɔ yia ɔ bheli 'Simɔɔ laa, 'ɩn ɔ nɛɛ: «-A ka Mesi 'yɩ.» (We ji -wa «-Lagɔɔ -Bhasanyɔ».) ");
INSERT INTO kyf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Ɩn ɔ -yɔ -mɔɔ 'sɔ yia -Zezuu -gbɛ mnɩ. -Zezu ylaa ɔ, 'ɩn ɔ nɛɛ: «-Mɩ -wa 'Simɔɔ, -na dide wa laa Zaan. -Na 'ŋnɩ wa yia zʋa Sefasɩ.» ('Mʋ wa bhitia 'wʋla Piɛlɩ, -mʋʋ ji -wa tʋkpa.) ");
INSERT INTO kyf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Zlɩ zlɩa, -Zezu 'yɩbha ɔ 'ka Galilee -dʋdʋ -gʋ mnɩ. Ɔ -yɔ Filipʋ gbelia, ɔ nɛɛ ɔ -yla: «Yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ mɩa, Bɛtɩsaida -dʋdʋ -gʋ ɔ 'bhʋa, Andlee -yɔ Piɛlɩ klaa 'ya. ");
INSERT INTO kyf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","-Mʋʋ 'bɩgʋ, Filipʋ -yɔ Natanaɛlɩ yia 'wʋgbeli, 'ɩn ɔ nɛɛ ɔ -yla: «-Lagɔɔ titee 'sɛbhɛ 'wʋ, Moizɩ ka nyɩmɛ yabhloo gbʋ gba, -Lagɔgbʋʋ -falɩpanya ka 'ya ɔ gbʋ gba wee 'sɛbhɛ 'wʋ. -A ka ɔ 'yɩ. Nɩɩ, mɔ -wa *-Zɛzɛfʋʋ 'yu -Zezu, Nazalɛtɩgbe 'wʋ ɔ 'bhʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","-Mɔɔ nɛɛ ɔ -yla: «'Lee, -lu -zɔnʋ mneni we 'ka Nazalɛtɩ 'bhʋʋ?» Filipʋ nɛɛ: «Yi -na 'dɛ 'ka -bha 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nɩɩ, Natanaɛlɩ yia -Zezuu -gbɛ yi. Ɔ bɛa ɔ -yɔ, -Zezu 'yɩa ɔ -yɔ, 'ɩn ɔ nɛɛ ɔ daa: «A yla, *Izlaɛlɩnyɩmɛɛ 'dɛbhie -gbolu nɩ, ɔɔ nyɩmɛ mɩa, kalɩ 'nɩ ɔ dlɩ 'wʋ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaɛlɩ nɛɛ: «Sa -ɩn yibheli 'mɩ 'wʋ la?» Ɔ nɛɛ: «Da Filipʋ 'nɩa -slɔ -mɩ la nɩ, ɩn ka -mɩ 'yɩ, -zugba -ɩn mɩ *figɩsu zɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","-Bha Natanaɛlɩ gbaɛ: «Wlabi, -ɩn mɩ -Lagɔɔ 'Yu nya, Izlaɛlɩnyɩmaa 'wlulapɩlɩnyɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Ɩn gbaa nɩɩ, ɩn ka -mɩ 'yɩ figɩsu zɔ, we 'gbʋ -ɩn yia 'mɩ dlɩ -gʋ zʋ, mʋ -wa yɩ? -Li 'kadɩ -we -zia -mʋnɩ 'yɩa -na yia we. ");
INSERT INTO kyf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ, yalɩ a yia 'yɩa ŋwɛ -kalɩda. 'Anzɩnya a yia 'yɩa kwlida -yɔ -gblada *Nyɩmɛɛ 'Yu -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","-Mʋʋ 'bɩgʋ, 'ylɩ 'sɔ 'plɩa, 'ɩn wa yia 'ŋwnɔkwafɛtɩ -sa Galilee 'gbe wa laa Kana, we 'wʋ. -Zezuu 'nyaa mɩ -bha. ");
INSERT INTO kyf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'Ɩn wa yi 'yaa -Zezu -yɔ ɔ 'bɩnɔnya la wee 'fɛtɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","-Bha bɛa, 'ɩn nʋ yia bhɩa, 'ɩn -Zezuu 'nyaa nɛɛ ɔ -yla: «Nʋ ka bhɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «'Maa, amaa nʋ gbʋ -wa yaayɩɩ, na nʋ gbʋ -wa yɩ? Bhla -we nya wa 'kaa na 'tɩtɛɛ 'dɛbhie -gbolu 'yɩ, we 'nɩ -slɔ nyni.» ");
INSERT INTO kyf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","-Zezuu 'nyaa nɛɛ lililuu dlilinya -yla: «-We weee ɔ yia aɩn -yla gbaa, a nʋ we lɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","'Ɩn tʋkpa nyida 'kadɩ gbelibhlo mɩ -bha wa kwesi. -Mʋʋ 'wʋ wa plia 'nyu, 'ɩn wa budoa: 'sa Zuifʋʋ tite gbaa. Nɩɩ, we 'yabhlo bhu 'wʋ litlɩ glʋ gbu. ");
INSERT INTO kyf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","-Zezu nɛɛ waa lililuu dlilinya -yla: «Nyidanya mɩa da nɩ, a yeli we 'nyu.» 'Sa wa yelia we sa kɛ! kɛ! kɛ! ");
INSERT INTO kyf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","-Zezu nɛɛ: «A 'pli -slɛɛn we, a 'ka we 'fɛtɩɩ 'yugalɩnyɔ kwa.» 'Ɩn wa yia we ɔ kwa. ");
INSERT INTO kyf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɔɔ 'fɛtɩɩ 'yugalɩnyɔ 'yɩa wee 'nyu ŋwɛ, -zugba we ka nʋ 'wʋlabhitili. Da wee nʋ 'bhʋlʋa, ɔ 'nɩ -bha da -yi, nɩɩ, -wa 'plia 'nyu, wa -yi -bha da. 'Ɩn ɔɔ 'fɛtɩɩ 'yugalɩnyɔ yia 'ŋwnɔ -kwanyɔ la. ");
INSERT INTO kyf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'Ɩn ɔ nɛɛ: «Da weee, nʋ -zɔnʋ wa wlaa -slɔ tɩa, wa -ka 'ma duun 'bhie, wa wlaa kalɔ nʋ. 'Ɩn -mɩ, -ɩn yia nʋ -zɔnʋ ladɩ, 'ɩn sɛnɛɛ bhla yia we ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nɩɩ, gwɛdigbʋʋ tɩanʋ -we -slolua ɔ 'ŋnɩmnɩee 'tɩtɛ, Galilee 'gbe wa laa Kana, we 'wʋ ɔ nʋa we lɛ. 'Sa ɔ -slolua ɔ 'ŋnɩmnɩee 'tɩtɛ, 'ɩn ɔ 'bɩnɔnya yia ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","We 'bɩgʋ, 'ɩn ɔ yia Kapɛnaumʋ mnɩ, ɔ -yɔ ɔ 'nyaa klaa, ɔ bhelia klaa, we -yɔ ɔ 'bɩnɔnya. 'Ɩn wa yia -mɔ 'ylɩ ya 'sɔlɛ li. ");
INSERT INTO kyf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nɩɩ, Zuifʋʋ *'Wʋzɩtɩylɩɩ 'fɛtɩ ka cɩpa, 'ɩn -Zezu yia -Zeluzalɛmʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɔ plaa *-Lagɔbudu 'kadʋ ŋwɛɛ, nyɩma -wa paa 'bhli klaa, bhlabhlɛ klaa, we -yɔ -kpakʋn pɛlʋ, 'ma ɔ ylɩa -bha, 'ɩn ɔ yi 'yaa 'gwɛzi -bhitinya -bha ylɩ, wa -dɩ wa 'tabhle -yɔ la. ");
INSERT INTO kyf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ɔ 'pnaa 'llukpe -yɛlɩpɛ 'bhisa, 'ɩn ɔ yia nyɩma weee vu -mɔ -Lagɔbudu 'kadʋ ŋwɛɛ, we -yɔ wa 'bhli -yɔ wa bhlabhlɛnya 'sɔ. Ɔ 'mnia 'gwɛzi -bhitinyaa 'gwɛzi, 'ɩn ɔ yia wa 'tabhle labhlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɔ nɛɛ -kpakʋʋn pɛlʋpanya -yla: «A -sa da we, a 'na nʋnʋ na Didee -budu -valɛ -budu 'wʋ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","-We *-Lagɔsɛbhɛ gbaa, 'ɩn ɔ 'bɩnɔnyaa dlɩ yia we -gʋ -bho: «'A! Na -Lagɔ, -na -budu ɩn 'yɩbhaa, we 'tʋ mɩ 'mɩ 'bhada.» ");
INSERT INTO kyf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tɔʋn, 'ɩn Zuifʋʋ 'yugalɩnya yia ɔ layɩbha: «Sanɛɛ -na nʋa yɩ? -Ɩn nʋ gwɛdigbʋ yabhlo lɛ, 'ɩn -a 'ka we 'jiyibheli nɩɩ, -Lagɔ ka -mɩ 'yoo 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Wee -Lagɔbudu 'kadʋ mɩa, a -sa we la, 'ɩn ɩn 'ka we 'yligbeli 'ylɩ ta nya.» ");
INSERT INTO kyf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wa nɛɛ ɔ -yla: «Aya! Wa 'kaa -budu nɩ 'sʋbha, wa li -zʋ glʋ 'sɔ -zʋ gbelibhlo, 'ɩn -mɩ, -ɩn nɛɛ -ɩn 'ka we 'sʋbha 'ylɩ ta nyaa?» ");
INSERT INTO kyf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nɩɩ, -budu -zɔnʋ -Zezu saa 'ŋnɩ, ɔ 'dɛɛ kuu gbʋ ɔ gbaa. ");
INSERT INTO kyf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","We 'dɛɛ 'gbʋ, da -Zezu -ka tlɩtlɩnya glaa 'wʋsɔ, ɔ 'bɩnɔnyaa dlɩ yia we -gʋ -bhoa, -we ɔ gbaa we -yɔ -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, 'mʋ wa zʋa dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zuifʋʋ 'Wʋzɩtɩylɩɩ 'fɛtɩ nya -Zezu mɩ -Zeluzalɛmʋ. Ɔ gwɛdigbʋnya -we slolua ɔ 'tɩtɛ, 'mʋ ɔ nʋa lɛ, nyɩma duun 'yɩa we -yɔ, 'ɩn wa yia ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","-Zezu 'nɩ wa dlɩ -gʋ zʋ, -we ka gbʋ -wa, ɔ -yi wa 'dɛ weee dlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nɩɩ, nyɩmɛ -ɔ -ka ɔ -limaa gbʋ lapalɩ ɔ -yla, -Zezu 'nɩ -mʋʋ gbʋ -ka, nɩɩ, -we mɩa nyɩmɛɛ dlɩ zɔ, ɔ 'dɛ -yi we. ");
INSERT INTO kyf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nɩɩ, nyɩmɛ yabhlo wa laa 'Nikodɛmʋ, -ɔ mɩa Falizɩnyɩmaa sɔ lʋ, 'ɩn ɔ mɩa Zuifʋʋ 'yugalɩnyɔ yabhlo nya, ");
INSERT INTO kyf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","mɔ yia -Zezuu -gbɛ sabɔ, 'ɩn ɔ nɛɛ: «Wlabi, -a -yi we 'ji nɩɩ, -Lagɔ ka -mɩ tie, -ɩn 'ka -aɩn gbʋ -slolu. -Lagɔ -yɔ -mɩ 'sɔ 'nɩ -mɩ nɩ, -ɩn 'nɩ mneni -ɩn 'ka 'sasʋkpa -gwɛdigbʋnya nɩ lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɔ nɛɛ 'Nikodɛmʋ -ylaɛ: «Ɩn nɛɛ -mɩ -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ ka 'lulolu wa 'nɩ gwalɩ, ɔ 'nɩ mneni ɔ 'ka nyɩma -wa -Lagɔ pɩlɩa 'wlu la glaa -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Nikodɛmʋ nɛɛ: «Sa wa 'ka nyɩmɛ kpasaa 'lulolu gwalɩa? Nɩɩ, ɔ mneni ɔ 'ka ɔ 'nyaa nʋkplɛ pla, wa 'ka ɔ 'sɔnʋ gwalɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Nɩɩ, ɩn nɛɛ -mɩ -yla gbʋzɔnʋ saɛ: we -ka nɩɩ, wa 'nɩ nyɩmɛɛ 'lulolu gwalɩ, 'nyu -yɔ -Lagɔɔ Zuzu nya, -mɔɔ 'nɩ mneni -mɔɔ 'ka -wa -Lagɔ pɩlɩa 'wlu la glaa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","-We ka gbʋ -wa, -wa 'nyaa -yɔ dide gwalɩa, wa mɩ nyɩmaa nyɩma nya, 'ɩn -wa -Lagɔɔ Zuzu gwalɩa, wa mɩ -Lagɔɔ Zuzuu nyɩma nya. ");
INSERT INTO kyf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","We -ka 'sa -mɩ, ɩn -ka gba nɩɩ, wa gwalɩ amɩaa 'lulolu, we 'na sʋbhalɩ -mɩ ŋwɛgaga -nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nɩɩ, da -pɩpɛ 'yɩbhaa we 'ka 'plɩ, -bha we plɩlɩa, 'ɩn -na nʋa we -jiji, nɩɩ, da we bhʋlʋa, mɔ we mnɩa, -ɩn 'nɩ -bha da -yi. Sa -pɩpɛ mɩa, -wa -Lagɔɔ Zuzu gwalɩa, 'sa wa mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Nikodɛmʋ nɛɛ: «Sa -mʋʋ 'ka 'wʋ la 'pɩplɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'Ɩn -Zezu nɛɛ: «Gbʋslolunyɔ, -ɔ ka 'ŋnɩ wa -yia *Izlaɛlɩ -dʋdʋ -gʋ, 'mɔ -ɩn -mɩa, 'ɩn -ɩn 'nɩ wee gbʋ nɩ -yii? ");
INSERT INTO kyf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nɩɩ, ɩn nɛɛ -mɩ -yla gbʋzɔnʋ saɛ: -we ka 'ji -a -yia, we -gʋgbʋ -a gbaa. -We ka da -a 'yɩa, we 'dɩ -a saa. 'Ɩn a 'nɩ 'yɩbha a 'ka -amɩaa -bhayɩgbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ɩn ka aɩn -yla dʋdʋgʋ gbʋ gba, a 'nɩ we -yɔŋwnu. We -ka 'sa -mɩ nɩ, da na yia aɩn -yla yalɩ gbʋ gbaa, a 'na 'ka we -yɔŋwnu, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nɩɩ, nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ -Lagɔɔ -gbɛ -gbla, we 'nɩ ɔɔ Nyɩmɛɛ 'Yu 'wʋbhʋ, mɔɔ 'bhʋa yalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Nɩɩ, Moizɩ ka nɛtɛ -tɩbhɛ 'wʋbhu yalɩ da bɛblɛɛ nyɩma weee 'yu, 'sa -bhlokpadɛ wa yia Nyɩmɛɛ 'Yu 'wʋbhua yalɩ, ");
INSERT INTO kyf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'ɩn -wa weee -ka ɔ dlɩ -gʋ zʋ, wa 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","We 'dɛɛ 'gbʋ, 'sa -Lagɔ -kalɩa dʋdʋgʋ -nyɩmaa zɛ, 'ɩn ɔ yia ɔ 'Yu yabhlogbɔɔ wla, 'ɩn -wa -ka ɔ dlɩ -gʋ zʋ, wa 'na 'ka labhʋ. 'Yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ wa yia 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nɩɩ, -Lagɔ 'nɩ ɔ 'Yu tie dʋdʋ -gʋ ɔ 'ka nyɩma gbʋ dɩlɩ, nɩɩ, ɔ 'ka wa gbʋ 'wʋsa, we 'gbʋ ɔ yia ɔ tie. ");
INSERT INTO kyf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","-Ɔ -ka ɔɔ 'Yu dlɩ -gʋ zʋ, -Lagɔ 'na 'ka ɔ gbʋ dɩlɩ, 'ɩn -ɔ 'nɩ ɔ dlɩ -gʋ zʋ, -Lagɔ ka ɔ gbʋ dɩlɩ pepe. -We ka gbʋ -wa, ɔ 'nɩ -Lagɔɔ 'Yu -bhlogbɔɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sanɛɛ -Lagɔ bhua nyɩmaa -yɔgbʋ 'wʋ, nɩɩ, zlɩ ka dʋdʋ -gʋ yi, 'ɩn nyɩma 'nɩ we -yɔŋwnu, nɩɩ, wa 'yɩbha nikpise, -we ka gbʋ -wa, gbʋnyuu wa nʋa lɛ. ");
INSERT INTO kyf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","-Wa weee nʋa gbʋnyuu lɛ, zlɩ wa nyɛa 'wʋ, 'ɩn wa'a 'tla zlɩ 'klʋ. -We ka gbʋ -wa, wa mɩ nyanɔ nʋda, nyɩmɛ yi wa lɛnʋgbʋ yibheli. ");
INSERT INTO kyf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nɩɩ, -wa nʋa -Lagɔɔ dʋmagbʋ lɛ, zlɩ 'klʋ wa tlaa. 'Sa nyɩma yɩa wa lɛnʋgbʋ -yɔ sa tenyii, 'ɩn wa yibhelia we 'ji nɩɩ, wa mɩ -Lagɔ 'nʋŋwɛ zʋda.» ");
INSERT INTO kyf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","-Mʋʋ 'bɩgʋ, -Zezu -yɔ ɔ 'bɩnɔnya yia Zudee -dʋdʋ -gʋ mnɩ, 'ɩn ɔ yia wa -gbɛ 'ylɩ 'sɔlɛ li, -zugba ɔ batizea nyɩma. ");
INSERT INTO kyf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","'Ɩn Zaan mɩa, -mɔɔ mɩ 'ya nyɩma batizeda: ɔ mɩ Enɔɔ, Salimʋ kwesi, da 'nyu -zua, -zugba nyɩma yi ɔ -gbɛ ɔ batizee wa. ");
INSERT INTO kyf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nɩɩ, wa 'nɩ -slɔ Zaan -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","-Bha kpɩkpɛlɩe -bhoa Zaaan 'bɩnɔnya -yɔ Zuifʋ yabhlo nyɩdɩ, sa Zuifʋʋ tite gbaa wa budo wa 'ka -mɔwlʋ, we -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","We 'gbʋ wa bɛa Zaan -yɔ, 'ɩn wa nɛɛ: «Wlabi, nyɩmɛ -ɔ -yɔ -mɩ 'sɔ mɩa Zudɛɛn nyu lʋ, 'ɩn -ɩn yia ɔ -gʋgbʋ gba -aɩn -yla, ɔmɔ, ɔ mɩ nyɩma batizeda, 'ɩn nyɩma weee mɩ ɔ -gbɛ mnɩda.» ");
INSERT INTO kyf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'Ɩn Zaan nɛɛ: «-Lagɔ 'nɩ nyɩmɛ -lu 'nyɛ, ɔ 'nɩ mneni ɔ 'ka we 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amɩaa 'dɛ mɩ na gbʋdayɩnya nya, a ka 'mɩ ŋwɛɛ 'nʋ nɩɩ, -amɩ, ɩn 'nɩ -Lagɔɔ -Bhasanyɔ, nɩɩ, -Lagɔ tiea 'mɩ ɔ 'yu. ");
INSERT INTO kyf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","-We ka gbʋ -wa, we -ka nanʋʋ gbʋ, nɩɩ, nyɩmɛ -ɔ mɩa 'ŋwnɔ kwada, ɔ 'tale -ɔ mnazɩa -lu weee, 'ɩn 'fɛtɩ 'ka nna, 'mɔ ɩn -mɩa. 'Ɩn da ɔɔ 'ŋwnɔkwanyɔ -ka wee fɛtɩ 'wʋ yi nɩ, ɔ 'tale -ka ɔ yiyi dɩ 'nʋ nɩ, 'ɩn 'mʋna bhaa ɔ. -Amɩ mɩa, ɩn mɩ 'mʋna lida sa duun, 'sa nanʋʋ gbʋ mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɔmɔ, ɔ 'bhu 'bɩ 'wʋ, 'ɩn -amɩ 'ka zɔbɛ. ");
INSERT INTO kyf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Nɩɩ, -ɔ bhʋa -Lagɔɔ -gbɛ, ɔ -galɩ nyɩma weee 'yu. -Ɔ bhʋa dʋdʋ -gʋ, dʋdʋgʋ -nyɩmɛ ɔ -mɩa, 'ɩn ɔ gbaa dʋdʋgʋ gbʋ. Ɔmɔ, -ɔ bhʋa -Lagɔɔ -gbɛ, ɔ -galɩ nyɩma weee 'yu. ");
INSERT INTO kyf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","-We ɔ 'yɩa, -we ɔ 'nʋa, we -gʋgbʋ ɔ gbaa. 'Ɩn nyɩmɛ yabhlogbɔɔ'ɔ ŋwnu ɔ gbʋʋ dayɩgbʋ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","-Ɔ -ka ɔ gbʋʋ dayɩgbʋ -yɔŋwnu, mɔ slolua nɩɩ, -we -Lagɔ gbaa, gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nɩɩ, -ɔ -Lagɔ -ka tie, -Lagɔwɛlɩ ɔ gbaa, -we ka gbʋ -wa, -Lagɔ nyɛa ɔ ɔ Zuzu kplo! kplo! ");
INSERT INTO kyf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dide -Lagɔ -kalɩ ɔ 'Yuu zɛ, 'ɩn ɔ ka ɔ 'tɩtɛ ɔ kwɛɛ zʋ -lu weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","-Ɔ -ka ɔ 'Yu dlɩ -gʋ zʋ, ɔ ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka. Nɩɩ, -ɔ'ɔ zʋa ɔ 'Yu 'nʋŋwɛ, ɔ 'na 'ka 'yliyɔgagɩe 'yɩ. -Lagɔɔ 'cɛ zɔ ɔ tʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","-Mʋʋ 'bɩgʋ, Falizɩnyɩma ka 'nʋ nɩɩ, nyɩma duun mɩ -Zezu 'bɩyida ɔ 'ka wa batizee we -zi Zaan. ");
INSERT INTO kyf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Nɩɩ, we 'nɩ ɔ dɛ, ɔ 'bɩnɔnya batizea nyɩma). Da -Zezu yibhelia we 'ji, ");
INSERT INTO kyf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","-bha ɔ 'bhʋa Zudee, 'ɩn ɔ yia Galilee lʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɔ 'ka Galilee mnɩ, we mɩ nɩɩ, ɔ -dɩ Samalii -dʋdʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Da ɔ mɩa Samalii -dʋdʋ -gʋ 'plɩlɩda, 'gbe yabhlo wa laa Sikaa, -bha ɔ nynia we nʋkplɛ. Wee gbe mɩa, da *Zakɔbʋ ka bhaa dʋdʋ kibhe, 'ɩn ɔ yia -bha -klɔ 'bhlu, wee dʋdʋ -we ɔ 'nyɛa ɔ 'yu *-Zɛzɛfʋ, we kwesi we mɩa. -Zezu sɩa nɔnʋe kwɛɛ, 'ɩn ɔ yia wee -klɔ -yɔ ladɩ. Nɩɩ, 'ylʋgbagbʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","-Bha Samaliŋwnɔ yabhlo yia 'nyu 'plia, 'ɩn -Zezu nɛɛ ɔ -yla: «A 'nyɛ 'mɩ 'nyu ɩn 'ka 'ma.» ");
INSERT INTO kyf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Nɩɩ, ɔ 'bɩnɔnya ka lililu zɔa mnɩ 'gbe nʋkplɛ.) ");
INSERT INTO kyf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɔɔ 'ŋwnɔ nɛɛ ɔ -yla: «Aya! -Mɩ Zuifʋ zlalɩa -amɩ Samaliŋwnɔ 'nyu yɩ?» Nɩɩ, Zuifʋ -yɔ *Samalii -nyɩma'a 'nʋnnʋ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","-Zezu nɛɛ ɔ -yla: «A 'nɩ -Lagɔɔ wlawlalu -yi, 'ɩn a 'nɩ -ɔ mɩa aɩn 'nyu -zlalɩda -yi. A -ka yaa we 'ji -yi, ama yi yaa ɔ 'wlʋwlʋnyu -zlalɩa, 'ɩn ɔ 'ka we aɩn 'nyɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɔ nɛɛ: «Na -Kanyɔ, -ɩn 'nɩ floko kwɛɛ -ka, 'ɩn -klɔ -tɔ 'wʋ, sa -ɩn 'ka 'mɩ wee 'wlʋwlʋnyu 'nyɛa? ");
INSERT INTO kyf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","-Amɩaa dʋkpasa Zakɔbʋ 'bhlua wee -klɔ, ɔ 'dɛ ka we 'nyu 'ma, we -yɔ ɔ 'yua -yɔ ɔ 'nɔɔlii -gnʋʋ -zlo. -Mɩ dlɩ 'wʋ nɩɩ, -mɩ 'ylia -mɩ -zia ɔ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","-Zezu nɛɛ ɔ -yla: «Nyɩmɛ -ɔ -ka nyu nɩ 'ma, 'nyumatʋ yia ɔ 'bhaa lʋ. ");
INSERT INTO kyf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nɩɩ, 'nyu -we na yia wlaa, nyɩmɛ -ɔ -ka we 'ma, 'nyumatʋ 'na 'ka 'maslɛɛn ɔ 'bha. 'Ɩn wee 'nyu zɛa ɔ 'wʋ 'wlʋwlʋnyu, da 'yliyɔgagɩe -we 'nɩa bhloluda -ka, we bhʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɔɔ 'ŋwnɔ nɛɛ ɔ -yla: «Na -Kanyɔ, 'nyɛ 'mɩ wee 'nyu, 'nyumatʋ yi -slɛɛn 'mɩ 'bha, ɩn yi 'maslɛɛn -seli 'nyu 'plia yi.» ");
INSERT INTO kyf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","-Zezu nɛɛ ɔ -ylaɛ: «A mnɩ amaa 'lowli laa, a -yɔ ɔ 'sɔ 'ka yi.» ");
INSERT INTO kyf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɔ nɛɛ: «Ɩn 'nɩ 'lowli -ka.» Ɔ nɛɛ: «Gbʋzɔnʋ a gbaa, nɩɩ, a 'nɩ 'lowli -ka. ");
INSERT INTO kyf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nɩɩ, a 'yɩ 'lowlia gbu. -Mɔmɔ a -yɔ ɔ 'sɔ mɩa dɛ nɩ, ɔ 'nɩ amaa 'lowli. Gbʋzɔnʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɔɔ 'ŋwnɔ nɛɛ: «Cɩɩn, na -Kanyɔ, ɩn -yi we 'ji nɩɩ, -Lagɔgbʋʋ -falɩpanyɔ -ɩn -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","-Gɔgɔ 'kadʋ nɩ 'wlu -amɩaa dʋkpasɩ bʋbɔ bhaa -Lagɔ, 'ɩn amɩa nɛɛ: -Zeluzalɛmʋ wa 'kaa -Lagɔ bʋbɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","-Zezu nɛɛ ɔ -yla: «Bhɔlɔ, a zʋ 'mɩ dlɩ -gʋ. Bhla yabhlo yia bɛa, we 'nɩ -gɔgɔ 'kadʋ 'wlu, 'ɩn we 'nɩ -Zeluzalɛmʋ wa 'ka Dide -Lagɔ bʋbɔ. ");
INSERT INTO kyf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nɩɩ, amɩa *Samalii -nyɩma, -we a bʋbɔa, a 'nɩ we -yi. 'Ɩn -we -amɩa Zuifʋ bʋbɔa, -a -yi we. -We ka gbʋ -wa, Gbʋwʋsanyɔ mɩa, Zuifʋʋ -gbɛ ɔ bhʋa. ");
INSERT INTO kyf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nɩɩ, bhla -we nya -wa bʋbɔa Dide -Lagɔ tɩklɩɩ, wa 'kaa ɔ bʋbɔ Zuzu nya sazɔnʋ sa, we bhla ka cɩpa, 'ɩn we ka nyni. Nɩɩ, we 'sasʋkpa -nyɩmaa da -Lagɔ talɩa, wa 'ka ɔ bʋbɔ. ");
INSERT INTO kyf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","-Lagɔ mɩ Zuzu nya. -Wa 'kaa ɔ bʋbɔ, wa bʋbɔ ɔ Zuzu nya sazɔnʋ sa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɔɔ 'ŋwnɔ nɛɛ ɔ -yla: «Ɩn -yi we 'ji nɩɩ, Mesi yia yia. (We ji -wa -Lagɔɔ -Bhasanyɔ.) Ɔ -ka yi nɩ, mɔ yia we 'dɛ weee 'wʋsɩsalɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ɔ nɛɛ ɔ -yla: «Mɔ mɩa da aɩn -yla gbada.» ");
INSERT INTO kyf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","-Bha -bhlokpadɛ ɔ 'bɩnɔnya yia lʋ. 'Ɩn wa yia -Zezu -yɔ 'ŋwnɔ yabhlo -yɔyɩ 'dɩ -sada. 'Ɩn we yia wa ŋwɛgaga -sʋbhalɩ, -zugba wa gba -mɔ dlɩ zɔɛ: «Lɛɛ -lu ɔ yɩbhalɩ ɔɔ 'ŋwnɔa? Lɛɛ -gbʋ ɔ gba ɔ -yla?» Nɩɩ, 'sasʋkpa -layɩbhawɛlɩ nɩ 'nɩ nyɩmɛ yabhlogbɔɔ ŋwɛɛ 'tla. ");
INSERT INTO kyf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tɔʋn, ɔɔ 'ŋwnɔ tɩa -bha ɔ 'nyu -nyida, 'ɩn ɔ yia 'gbe nʋkplɛ pla. Ɔ nɛɛ nyɩma -yla: ");
INSERT INTO kyf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«A yi! A yi -nya, a 'ka nyɩmɛ yabhlo 'yɩ! Mɔ gbaa na lɛnʋgbʋ weee. We 'wlʋ sa mɔ -wa -Lagɔɔ -Bhasanyɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tɔʋn, wa yia 'gbe nʋkplɛ 'tla, 'ɩn wa yia -Zezuu gbɛgbɛɩn mnɩnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","We bhla, ɔ 'bɩnɔnya mɩ ɔ bhubhoeda ɔ 'ka li. ");
INSERT INTO kyf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Ɩn ɔ nɛɛ wa -ylaɛ: «Lililu -we ɩn 'kaa li, a 'nɩ we -yi.» ");
INSERT INTO kyf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Ɩn ɔ 'bɩnɔnya nɛɛ wa 'dɛkpʋa nyɩdɩ: «Aya! Nyɔɔ 'nyɛ ɔ lililua?» ");
INSERT INTO kyf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ɔ nɛɛ wa -yla: «Na yoopanyɔɔ dʋmagbʋʋ 'nʋŋwɛzʋzʋe -yɔ ɔ lubhoo 'wlubhabhɩe, mʋ -wa na lililu. ");
INSERT INTO kyf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Amɩa, a nɛɛ nɩɩ, we -tʋ 'wʋ 'cʋ -mnʋa, 'ɩn -luu -dɩdɩ bhla 'ka nyni, -amɩ nɛɛ aɩn -yla, nɩɩ, we -dɩdɩ bhla ka -slɛɛn nyni. A -talɩ kpaa -gʋ, we 'ya ka zalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","-Ɔ -ka -luu -dɩdɩnyɔ nya -mɩ, ɔ ka ɔnʋʋ -tnʋʋ 'yɩ. Nɩɩ, ɔ mɩ nyɩma 'wlugʋgwlalɩda, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, -Lagɔ 'ka we wa 'nyɛ. 'Ɩn we glʋglʋnyɔ -yɔ we -dɩdɩnyɔ 'ka 'mʋna li dabhlo. ");
INSERT INTO kyf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nɩɩ, nine yabhlo nɛɛ: ‹Nyɩmɛ yabhlo glʋa, 'ɩn nyɩmɛ -putu dɩa.› Gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kpaa -we 'wʋ a 'nɩa lubho nʋ, -mɔ ɩn tiea aɩn we -luu -dɩdɩ bhla. Tɔlʋa ka -mɔ lubho nʋ, 'ɩn wa yia sɩa. 'Ɩn -amɩa yɩa we 'wʋ -tnʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","-Mʋʋ 'bɩgʋ, ɔɔ 'ŋwnɔɔ gbagbawɛlɩ -gʋ Samalii -nyɩma duun zʋa -Zezu dlɩ -gʋ. Ɔ nɛɛ wa -yla: «Ɔɔ nyɩmɛ nɩ gbaa 'mɩ -yla na lɛnʋgbʋ weee.» ");
INSERT INTO kyf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","We 'dɛɛ 'gbʋ, Samalii -nyɩmaa -zlo yia -Zezuu -gbɛ yi. 'Ɩn wa yia ɔ -bɛlʋ -yɔpalɩ, ɔ -yɔ wa 'ka -tʋ. Ɔ li -bha 'ylɩ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","'Ɩn tɔlʋa yia wa -gʋ -bho dlɩzʋzʋe nya, ɔ 'dɛɛ ŋwɛɛ wɛlɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wa nɛɛ ɔɔ 'ŋwnɔ -yla: «We 'nɩ -slɛɛn amaa wɛlɩ -bhlogbɔɔ 'gbʋ -a yi ɔ dlɩ -gʋ zʋ. Nɩɩ, -amɩaa 'dɛ ka ɔ ŋwɛɛ wɛlɩ 'nʋ. Nɩɩ, -a -yi -slɛɛn we 'ji nɩɩ, mɔ -wa dʋdʋgʋ -nyɩma weee Gbʋwʋsanyɔɔ 'dɛbhie.» ");
INSERT INTO kyf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","-Zezu li -bha 'ylɩ 'sɔ, we tanʋʋ zlɩ, 'ɩn ɔ yia ɔ 'yoo bhli, ɔ 'ka Galilee -dʋdʋ -gʋ lʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Nɩɩ, -Zezuu 'dɛ ka gba nɩɩ, wa'a zʋ -bha -Lagɔgbʋʋ -falɩpanyɔ ɔ 'dɛɛ -zɔɔ.) ");
INSERT INTO kyf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tɔʋn, ɔ nynia Galilee, 'ɩn nyɩmaa -zlo yia ɔ yoo -saa yi. -We ka gbʋ -wa, gwɛdigbʋ ɔ nʋa lɛ -Zeluzalɛmʋ 'Wʋzɩtɩylɩɩ 'fɛtɩɩ bhla, wa ka -bha 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","'Bhie ɔ yia Kana lʋ mnɩ, Galilee -dʋdʋ -gʋ, da ɔ 'bhitilia 'nyu nʋ 'wʋla. Nɩɩ, *Ewlodʋʋ nyɩmɛ 'kadʋ yabhlo mɩa Kapɛnaumʋ, ɔ 'yu ka gu -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɔ 'nʋa nɩɩ, -Zezu ka Zudee 'bhʋ, ɔ ka Galilee mnɩ, 'ɩn ɔɔ nyɩmɛ yia Kana mnɩ, ɔ 'ka ɔ 'yɩ. Ɔ nynia ɔ -gbɛ, ɔ nɛɛ ɔ -yla: «-Na zukpa -wa! -A mnɩ Kapɛnaumʋ, -ɩn 'ka na 'yu jipe, ɔ yi tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","-Zezu nɛɛ ɔ -yla: «We 'nɩ gwɛdigbʋnya 'wʋbhʋ, a 'nɩ mneni a 'ka 'mɩ dlɩ -gʋ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɔɔ nyɩmɛ 'kadʋ nɛɛ ɔ -yla: «Na -Kanyɔ, -a mnɩ -mɔ, na 'yu yi tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɔ nɛɛ: «Mnɩ -buduŋwɛɛ, nɩɩ, -na 'yu ka 'pʋ.» 'Ɩn ɔɔ nyɩmɛ yia -Zezuu wɛlɩ dlɩ -gʋ zʋ, 'ɩn ɔ yia ɔ -buduŋwɛɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɔ mɩ mnɩda, 'ɩn ɔ -yɔ ɔ zɔyua yia gbeli 'yloogblʋ. -Maa nɛɛ ɔ -yla: «-Na 'yu ka 'pʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Ɩn ɔ yia wa layɩbhaɛ: «'Lee, bhla -mʋmʋ nya ɔ yili 'wʋa?» Wa nɛɛ: «Zʋbha 'ylʋgbagbʋʋ 'lɛlɩɩ tɩanʋ nya ɔ 'pʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɔɔ 'yuu dide yia we 'jiyibheli nɩɩ, wee bhla -bhlokpadɛ nya, -Zezu gbaa ɔ -ylaɛ: «-Na 'yu ka 'pʋ.» -Bha ɔ -yɔ ɔ -buduŋwɛɛ -nyɩma weee zʋa -Zezu dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wee gwɛdigbʋʋ 'sɔnʋ ɔ nʋa dɛ lɛ ɔ Zudee -bhʋda, ɔ 'ka Galilee mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","-Mʋʋ 'bɩgʋ, Zuifʋʋ 'fɛtɩ yabhlo nynia, 'ɩn -Zezu yia 'wʋsɔ, ɔ 'ka -Zeluzalɛmʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nɩɩ, -mɔ -Zeluzalɛmʋ, klolo 'kadʋ yabhlo mɩ -bha, 'mʋ wa laa Bhlabhlɛɛ Klolo. -Bha wee klolo kwesi, 'nyu yabhlo mɩ -bha, 'mʋ wa laa zuifʋwɛlɩ 'wʋ Betɛsɩda. Nɩɩ, palʋʋ bhʋ gbu gbelia we. ");
INSERT INTO kyf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nɩɩ, guzʋnyaa -zlo slu we -yɔ la: 'lɔlɔnya klaa, 'tɩgɩtɩgɩnya klaa, we -yɔ zɔlaslonya mɩ -bha. Nɩɩ, 'nyuu zuklue wa mɩa wʋda. ");
INSERT INTO kyf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","-We ka gbʋ -wa, bhla tɔlʋa nya, 'anzɩ sibhlia wee 'nyu lʋ la, 'ɩn we zuklua we 'klʋ. 'Ɩn -ɔ -ka -mɔ -bho tɩa, guo gu -we -ka ɔ -yɔ -mɩ, 'ɩn ɔ pʋa. ");
INSERT INTO kyf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nɩɩ, wa glaa, nyɩmɛ yabhlo ka gu -yɔ, we -zʋ glʋ -bhlo 'ya kugbua lɛ gbeta nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Da -Zezu 'plɩlɩa -mɔ, ɔ 'yɩa ɔ, 'ɩn ɔ yia 'nʋ nɩɩ, wee gu ka ɔ -yɔ -gwlɛ. Ɔ bɛa ɔ -yɔ, 'ɩn ɔ yia ɔ layɩbha: «-Ɩn 'yɩbha -ɩn 'ka 'pʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Ɩn ɔɔ guzʋnyɔ yia we 'bɩgʋpalɩɛ: «Na -kanyɔ, 'nyu -ka zuklu, nyɩmɛ -ɔ 'kaa -mɔ 'mɩ 'pa, ɔ 'nɩ -mɩ. Bhla ɩn 'ka 'wʋsɔ, nyɩmɛ yabhlo ka 'mɩ 'yugalɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","-Zezu nɛɛ ɔ -yla: «-Sɔ 'wʋ! -Ɩn 'bhu -na -bita 'wʋ, -ɩn mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","-Bha -bhlokpadɛ, ɔɔ nyɩmɛ 'pʋa, ɔ -sɔa 'wʋ, ɔ 'bhua -bita 'wʋ, 'ɩn ɔ yia mnɩ. Nɩɩ, *Nyapɛylɩ nya we nʋa lɛ. ");
INSERT INTO kyf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","-Bha Zuifʋʋ 'yugalɩnya gbaa -ɔ wa jipea -yla: «Nɩɩ, -zɛɛn mɩa, Nyapɛylɩ -wa. 'Ɩn -amɩaa tite nɛɛ, -ɩn 'nɩ mneni -ɩn 'ka -na -bita 'wʋbhu, -ɩn 'ka nɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɔ nɛɛ wa -yla: «Nyɩmɛ -ɔ jipea 'mɩ, ɔ nɛɛ 'mɩ -yla: ‹-Ɩn 'bhu -na -bita 'wʋ, -ɩn 'ka mnɩ.› » ");
INSERT INTO kyf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","-Bha wa 'yɩbhaa ɔ laɛ: «Nyɔɔ gba -mɩ -yla, 'bhu -na -bita 'wʋ -ɩn mnɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nɩɩ, ɔɔ nyɩmɛ -ɔ jipea ɔ, ɔ 'nɩ ɔ -yi. Nɩɩ, -Zezu ka ɔ 'yligwe lamnɔnʋ, nyɩma -zu -bhaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","-Mʋʋ 'bɩgʋ, -Zezu plaa -Lagɔbudu 'kadʋ zɔ, ɔ 'yɩa ɔ -yɔ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn ka -slɛɛn 'pʋ, -ɩn 'na nʋnʋ 'maslɛɛn gbʋnyuu lɛ -nɩɛ. We 'nɩ -mʋʋʋ, -we yia -mɩ ylɩa, we -nyu 'yli.» ");
INSERT INTO kyf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","-Bha ɔɔ nyɩmɛ mnɩa, 'ɩn ɔ nɛɛ Zuifʋ -ylaɛ: «-Ɔ puea 'mɩ nɩ, -Zezu -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nɩɩ, Nyapɛylɩ nya ɔ jipea nyɩmɛ, we 'dɛɛ 'gbʋ wa yia ɔ -yɔwʋsɔlʋ, wa 'ka ɔ sɩalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nɩɩ, -Zezu nɛɛ wa -yla: «Bhla weee nya, na Dide mɩ lubho nʋda, ɔ 'bhisa -amɩ mɩ 'yaa lubho nʋda.» ");
INSERT INTO kyf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","We 'dɛɛ 'gbʋ Zuifʋʋ 'yugalɩnya yia ɔ -yɔwʋsɔlʋ, wa 'ka ɔ 'bha. We 'nɩ wa Nyapɛylɩ -bhlogbɔɔ ɔ 'nɩ 'nʋŋwɛ zʋʋ gbʋ, ɔ nɛɛ 'ya nɩɩ, -Lagɔ -wa ɔ Dide, 'ɩn ɔ yɩbhɔlʋa ɔ 'dɛ -Lagɔ. ");
INSERT INTO kyf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","-Zezu 'palɩa we 'bɩgʋ ɔ nɛɛ: «Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: 'Yuu 'dɛbhlo 'nɩ mneni ɔ 'ka -lu yabhlogbɔɔ lɛnʋ, nɩɩ, -we ɔ 'yɩa ɔ Dide lɛnʋda, we 'dɛkpʋa ɔ nʋa lɛ. -We Dide nʋa lɛ, 'mʋ 'Yu nʋ 'yaa lɛ. ");
INSERT INTO kyf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nɩɩ, Dide -kalɩ ɔ 'Yuu zɛ, 'ɩn ɔ slolua ɔ ɔ lɛnʋgbʋ weee. Cɩɩn, gbʋ 'kadɩ -we 'ylia -we -zia -we a 'yɩa, 'mʋ ɔ yia ɔ -slolua, 'ɩn we 'ka aɩn ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sa Dide ganɔa tlɩtlɩnya, 'ɩn ɔ nyɛa wa 'yliyɔgagɩe, 'sa -bhlokpadɛ 'Yu nyɛa 'yliyɔgagɩe nyɩma -wa ɔ 'yɩbhaa ɔ 'ka we 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dide'e 'bhu nyɩmɛɛ -yɔgbʋ 'wʋ, ɔ ka we 'dɛ weee ɔ 'Yu yoo 'nyɛ, ");
INSERT INTO kyf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'ɩn nyɩma weee 'ka 'Yu 'nʋŋwɛ zʋ ɔ Dide 'bhisa. -Ɔ 'nɩ 'Yu 'nʋŋwɛ zʋ nɩ, ɔ Dide, -ɔ tiea ɔ, ɔ 'nɩ -mɔɔ 'nʋŋwɛ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -ɔ -ka na wɛlɩ yukwli pʋlʋ, 'ɩn -ɔ tiea 'mɩ, ɔ 'ka ɔ dlɩ -gʋ zʋ, ɔ ka 'yliyɔgagɩe -we 'nɩa -bhloluda -ka. Gbʋdɩlɩe 'na 'ka ɔ -nʋ nya -mɩ. Nɩɩ, ɔ ka tlɩtlɩe 'wʋbhʋ, 'ɩn ɔ yia 'yliyɔgagɩe 'wʋplɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: da tlɩtlɩnya 'kaa -Lagɔɔ 'Yuu wɛlɩ 'nʋ, 'ɩn -wa yia we 'nʋa, 'yliyɔgagɩe wa yia 'yɩa, we bhla ka cɩpa, 'ɩn we ka nyni. ");
INSERT INTO kyf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sa Dide kaa 'yliyɔgagɩe 'wʋ, 'sa 'Yu kaa 'yliyɔgagɩe 'wʋ. Nɩɩ, Dide 'nyɛa we ɔ 'Yu. ");
INSERT INTO kyf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'Ɩn ɔ yia ɔ 'Yu se 'nyɛ, ɔ 'ka nyɩmaa -yɔgbʋ 'wʋbhu. -We ka gbʋ -wa nɩ, ɔ mɩ *Nyɩmɛɛ 'Yu nya. ");
INSERT INTO kyf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Gbʋnya nɩ 'na sʋbhalɩ aɩn ŋwɛgaga -nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","We bhla mɩ yida, da tlɩtlɩnya weee -wa wa 'bhlua, wa yia ɔ wɛlɩ 'nʋa, 'ɩn wa 'ka wa gbawla 'wʋtla. -Wa nʋa gbʋ -zɔnʋ lɛ, wa -ka tlɩtlɩnya glaa 'wʋsɔ, 'yliyɔgagɩe wa yia 'yɩa. 'Ɩn -wa 'nɩa gbʋ -zɔnʋ lɛnʋ, wa -ka 'wʋsɔ, gbʋdɩlɩe yia wa -nʋ nya -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Nɩɩ, ɩn 'nɩ mneni ɩn 'ka -lu yabhlogbɔɔ lɛnʋ na 'dɛ nya. Sa Dide gbaa, 'sa na bhua nyɩmaa -yɔgbʋ 'wʋ, we 'gbʋ, na gbʋwʋbhubhue mɩa tɩklɩɩ. -We ka gbʋ -wa, ɩ'ɩn -talɩ na 'dɛɛ dʋmagbʋʋ da, -ɔ tiea 'mɩ, ɔ dʋmagbʋʋ da na talɩa. ");
INSERT INTO kyf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«We -ka na dɛ mɩ na gbʋdayɩnyɔ nya, -we na yia gbaa, a 'na 'ka we la gbʋzɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nɩɩ, na gbʋdayɩnyɔ yabhlo mɩ -bha. 'Ɩn, ɩn -yi we 'ji nɩɩ, -we ɔ gbaa na daa gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Na 'gbʋ a yia nyɩma tie Zaaan -gbɛ, wa 'ka ɔ layɩbha. -We ɔ gbaa aɩn -yla na daa, gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","-Amɩ, ɩn 'nɩ we gbʋ -ka, nyɩmɛ 'ka na gbʋdayɩnyɔ -zɛ. Nɩɩ, Zaaan gbʋ na gbaa aɩn -yla, a 'ka gbʋ 'wʋbhʋʋ gbʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zaan 'wlʋa lɩlɩnapɛ, 'ɩn a yia ŋwnu a 'ka 'mʋna li ɔ san 'wʋ, bhla -bhlo nya. ");
INSERT INTO kyf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nɩɩ, ɩn ka gbʋdayɩnyɔ yabhlo -ɔ 'ylia -ɔ -zia Zaan. Sa wa 'kaa we 'jiyibheli nɩɩ, Dide tiea 'mɩ, mʋ -wa nɩɩ, lubho -we ka 'gbʋ ɔ yia 'mɩ tie, ɩn mɩ we nʋda. ");
INSERT INTO kyf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Ɩn ɔɔ Dide -ɔ tiea 'mɩ, ɔ 'dɛ mɩ na gbʋdayɩnyɔ nya. Nɩɩ, a 'nɩ -slɔ ɔ wɛlɩ 'nʋ, 'ɩn a 'nɩ -slɔ ɔ 'klʋ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɔ wɛlɩ 'nɩ aɩn 'wʋ -mɩ, -ɔ ɔ tiea, a'a zʋ ɔ dlɩ -gʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","-Lagɔsɛbhɛ 'wʋ a talɩa, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, a 'ka we 'yɩ we nʋkplɛ. Nɩɩ, gbʋzɔnʋ -wa, wee wɛlɩɩ dɛ gbaa na -gʋgbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'Ɩn a'a yi na -gbɛ, a 'ka 'yliyɔgagɩe -zɔnʋ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ɩn 'nɩ nyɩmaa 'ŋnɩ kwalɩe datalɩda -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nɩɩ, ɩn -yi aɩn, ɩn -yi we 'ji nɩɩ, -Lagɔɔ zɛkalɩe 'nɩ aɩn 'wʋ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","-Amɩ -mɔmɔ yia na Didee 'ŋnɩ nya, a'a ŋwnu na gbʋ -yɔ, 'ɩn nyɩmɛ -putu -ka yi, ɔ 'dɛɛ 'ŋnɩ nya, ɔ gbʋ a ŋwnua -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'Ŋnɩ kʋkwalɩe da a talɩa, nɩɩ, -Lagɔ -bhlogbɔɔ 'ka amɩaa 'ŋnɩ 'ylimanɩ, a'a -talɩ -mʋʋ da. -We mɩa daa 'gbʋ, a'a zʋa 'mɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Lee, -amɩ yia aɩn gbʋ dɩlɩa -Lagɔ 'yu yɩ? -Ɩnnya, we 'nɩ -amɩ yi aɩn gbʋ dɩlɩa -Lagɔ 'yu, nɩɩ, a ka Moizɩ dlɩ 'wʋ dɩ, mɔ yia aɩn gbʋ dɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","47","A -ka yaa Moizɩ dlɩ -gʋ zʋ nɩ, -zugba a ka 'mɩ dlɩ -gʋ zʋ. Lɛɛ -lu ka 'gbʋa? -We ka gbʋ -wa nɩ, Moizɩ ka na daa cɛlɩ -Lagɔsɛbhɛ 'wʋ nɩɩ, -we ɔ cɛlɩa a 'nɩ we dlɩ -gʋ zʋ, we 'dɛɛ 'gbʋ a'a zʋa na 'dɛɛ wɛlɩ dlɩ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","-Mʋʋ 'bɩgʋ, -Zezu mnɩa Galilenyu kwesi, 'ɩn ɔ yia wee 'nyu 'wʋdɩ. (Nɩɩ, wee nyu mɩa, 'mʋ wa la 'yaa Tibeliadɩ). ");
INSERT INTO kyf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","'Ɩn nyɩmaa -zlo yia -Zezu 'bɩ yi, nɩɩ, gwɛdigbʋ ɔ nʋa lɛ nyɩmaa jipee nya, wa ka we -yɔyɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","-Bha ɔ -gblaa -gɔgɔ yabhlo 'wlu, 'ɩn ɔ yia -mɔ ladɩ, ɔ -yɔ ɔ 'bɩnɔnya 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nɩɩ, Zuifʋʋ *'Wʋzɩtɩylɩɩ 'fɛtɩ ka cɩpa. ");
INSERT INTO kyf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","-Zezu -talɩa -bha tɔʋn, 'ɩn ɔ yia nyɩmaa -zlo -yɔyɩ ɔ -gbɛ yida, 'ɩn ɔ nɛɛ Filipʋ -ylaɛ: «Da -a 'ka 'floo zɔ, 'ɩn nyɩma nɩ 'ka lia?» ");
INSERT INTO kyf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","-We -Zezu 'kaa lɛnʋ, ɔ 'dɛ -yi we. Nɩɩ, la ɔ ylaa Filipʋ, we 'gbʋ ɔ yia we ɔ layɩbha. ");
INSERT INTO kyf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipʋ nɛɛ: «Aya! 'Cʋ gbetaa lubhoo 'pɛnɩgwɛzii 'dɛbhie nya, -a 'nɩ mneni -a 'ka 'floo zɔ, 'ɩn wa 'dɛ weee 'ka li -sɛsɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","-Zezuu 'bɩnɔnyɔ yabhlo mɩ -bha, 'mɔ wa laa Andlee, Simɔ Piɛlɩɩ bheli -wa. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Nʋkpasuyu yabhlo mɩa da, ɔ ka *lɔzɩfloo gbu -yɔ zibhi 'sɔ kwɛɛ. Zibhinya -yɔ 'floonya nɩ 'nɩ 'wʋzu, wa 'dɛ weee 'ka li. We 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","-Zezu nɛɛ ɔ 'bɩnɔnya -yla: «A 'tʋlʋ wa, wa -dɩ la.» Nɩɩ, wee da mɩa, -petu -zu -bha. Waa nyɩma -dɩa la, wa nyni nʋkpasiaa 'wlu glʋ -bhlo 'wlu gbu (5.000). ");
INSERT INTO kyf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ɔ 'bhua 'floo 'wʋ, ɔ 'paa -Lagɔ fuo, -wa mɩa ladɩda, 'ɩn ɔ yia we wa 'wʋla dlili. 'Sa ɔ dlili 'yaa wa zibhi 'wʋla, 'ɩn wa yia li wa dlɩɩ da. ");
INSERT INTO kyf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Da wa 'dɛ weee lʋa nɩ, 'ɩn -Zezu nɛɛ ɔ 'bɩnɔnya -yla: «A 'bhu we pnɩɩ la, a -yɔ we yi, we 'ya yabhlogbɔɔ yi mnɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wee 'floo gbu nyɩma lia, 'ɩn wa yia lʋ. We pnɩɩ -we -tʋa 'wʋ, 'mʋ ɔ 'bɩnɔnya 'bhua la, mʋ yea -cɩcɛ kugbua lɛ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gwɛdigbʋ ɔ nʋa lɛ, wa 'yɩa we -yɔ, 'ɩn wa nɛɛ: «Gbʋzɔnʋ -wa, -Lagɔgbʋʋ -falɩpanyɔ -ɔ 'kaa yi nɩ, 'mɔ ɔ -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","-Zezu -yi we 'ji nɩɩ, wa 'yɩbha wa 'ka ɔ 'wʋbhu -gla nya, wa 'ka ɔ wa 'wlulapɩlɩnyɔ -zɛlɩ. We 'dɛɛ 'gbʋ ɔ yia wa gwevla, 'ɩn ɔ 'dɛbhlo yia -gɔgɔ 'wlu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jibhe zɔa, -bha ɔ 'bɩnɔnya kwlia -gɔgɔ 'nyu kwesi. ");
INSERT INTO kyf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","-Bha wa -bhoa 'glʋ 'wʋ, wa 'ka 'nyu 'wʋdɩ, 'ɩn wa 'ka Kapɛnaumʋ mnɩ, -zugba -Zezu 'nɩ -slɔ wa glaa -mɩ, 'ɩn sabɔ yia bɛ. ");
INSERT INTO kyf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nɩɩ, 'nyuu -gbʋgbʋ yia zuklue bhli, -pɩpɛ 'kadʋ mɩ 'plɩdaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","We bhla, kilomɛtlɩ gbu, kilomɛtlɩ gbelibhlo wa nʋa lɛ -mɔ 'nyu -gʋ. Nɩɩ, wa mɩ 'nyu 'wʋdɩda, 'ɩn wa yia -Zezu -yɔyɩ yida wa gbɛgbɛɩn 'nyu -gʋ -nɔnʋe nya. -Bha wa nʋa nyanɔ. ");
INSERT INTO kyf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Ɩn -Zezu nɛɛ wa -ylaɛ: «-Amɩ -wa. A 'na nʋnʋ nyanɔ -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɔ 'bɩnɔnya 'yɩbha wa 'ka ɔ 'wʋbhu 'glʋ 'wʋ. Tɔʋn, mɔ wa mɩa mnɩda, 'ɩn wa 'glʋ yia -bhaa dʋdʋ ylɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zlɩ zlɩa, nyɩmaa -zlo -wa -tʋa 'nyuu kakpe yabhlo -gʋ, 'ɩn wa yia we 'jiyibheli nɩɩ, 'glʋ -bhlogbɔɔ mɩa -bha. 'Ɩn nyɩma -yi we 'ji nɩɩ, -Zezuu 'bɩnɔnya ka 'glʋ 'wʋbho, 'ɩn wa yia mnɩ, -zugba ɔ 'nɩ wa glaa -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","-Slɛɛn, nyɩma -wa 'bhʋa Tibeliadɩgbe nʋkplɛ, 'ɩn wa yia 'glʋ tɔlʋa 'wʋbho, 'ɩn wa yia mnɩ. Wa mnɩa, da Nyɩmaa -Kanyɔ bhubhoea -Lagɔ, 'ɩn nyɩmaa -zlo yia 'floo li, 'ɩn wa yia -bha nyni. ");
INSERT INTO kyf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nyɩmaa -zlo mɩa -bha, wa yibhelia we 'ji nɩɩ, -Zezu -yɔ ɔ 'bɩnɔnya 'nɩ -bha -mɩ, wa -bhoa 'glʋnya 'wʋ, 'ɩn wa yia -Zezu 'yli 'bɩ lanɔnʋa mnɩ Kapɛnaumʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wa ylɩa -Zezu kakpe -putu -gʋ, 'ɩn wa nɛɛ ɔ -yla: «*Wlabi, 'lee, lɛbhla -ɩn nyni -selia?» ");
INSERT INTO kyf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: a ka 'floo li, 'ɩn a 'nɩ lʋ -sɛ, we 'gbʋ a talɩa na da. We 'nɩ nɩɩ, na gwɛdigbʋnya ɩn nʋa lɛ, we 'ji a 'nʋ 'wʋlaa gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lililu -we nyumɔa, a 'na nʋnʋ we 'gbʋ lubho -nɩ. Nɩɩ, lililu -we gwlɛa, 'ɩn we nyɛa nyɩmɛ 'yliyɔgagɩe -we 'nɩa bhloluda -ka, a nʋ we 'gbʋ lubho. Wee lililu nɩ, Nyɩmɛɛ Yu yia we aɩn 'nyɛa. Nɩɩ, 'mɔ Dide -Lagɔ zʋa ɔ yibhelida -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","-Bha wa 'yɩbhaa ɔ laɛ: «'Lee, sa -a 'ka nʋ, lubho -we nanɩa -Lagɔ dʋdʋ, 'ɩn -a 'ka we nʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","-Zezu nɛɛ wa -ylaɛ: «Lubho -we -Lagɔ 'yɩbhaa a nʋ, mʋ -wa -ɔ ɔ tiea, a zʋ ɔ dlɩ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wa nɛɛ ɔ -yla: «Gwɛdigbʋ -mʋmʋ -ɩn 'ka lɛnʋ, -a 'ka -yɔyɩ, 'ɩn -a 'ka -mɩ dlɩ -gʋ zʋa? Sa -ɩn 'ka nʋa? ");
INSERT INTO kyf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nɩɩ, da -amɩaa dʋkpasɩ -dɩlɩ bhaa da bɛblɛɛ la -bhlo -bhlo, wa ka *manɩ li. 'Sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹'Floo -we 'bhʋa yalɩ, ɔ ka we wa 'nyɛ, wa 'ka we li.› » ");
INSERT INTO kyf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɔ nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -ɔ 'nyɛa aɩn yalɩɩ 'floo nɩ, we 'nɩ Moizɩ: nɩɩ, na Dide nyɛa aɩn yalɩɩ 'flooo 'zayli. ");
INSERT INTO kyf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nɩɩ, -we ka gbʋ -wa, -Lagɔɔ nʋ 'floo mɩa, mʋ -wa -ɔ 'bhʋa yalɩ, 'ɩn ɔ nyɛa dʋdʋgʋ -nyɩma 'yliyɔgagɩe.» ");
INSERT INTO kyf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","-Slɛɛn, wa nɛɛ ɔ -yla: «-Amɩaa -Kanyɔ, wee 'floo mɩa nɩ, 'nyɛ we -aɩn 'ylɩ weee nya.» ");
INSERT INTO kyf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","-Bha -Zezu gbaa wa -ylaɛ: «Nɩɩ, 'floo -we nyɛa nyɩmɛ 'yliyɔgagɩe, -amɩ -wa. -Ɔ -ka na -gbɛ yi, ŋwɔ 'na 'ka 'maslɛɛn ɔ 'bha. 'Ɩn -ɔ -ka 'mɩ dlɩ -gʋ zʋ, 'nyumatʋ 'na 'ka 'maslɛɛn ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nɩɩ, ɩn ka we aɩn -yla gba: amɩa, a ka 'mɩ 'yɩ, 'ɩn a'a zʋ 'mɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","-Wa weee na Dide nyɛa 'mɩ, na -gbɛ wa yia yia. 'Ɩn nyɔɔo nyɔɔ yia na -gbɛ, ɩn 'na 'ka ɔ 'pipee viteli. ");
INSERT INTO kyf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nɩɩ, ɩn 'nɩ yalɩ 'bhʋ ɩn 'ka na 'dɛɛ dʋmagbʋ lɛnʋa yi, -ɔ tiea 'mɩ, -mɔɔ dʋmagbʋ ɩn yia lɛnʋa. ");
INSERT INTO kyf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","-Ɔ tiea 'mɩ, ɔ dʋmagbʋ -wa nɩɩ, nyɩma ɔ 'nyɛa 'mɩ yoo, ɩn 'na mnɔnʋ wa 'yabhlogbɔɔ -nɩ. Nɩɩ, dʋdʋʋ bhɩa zlɩ, ɩn -sɔlʋ wa 'wʋ tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cɩɩn, na Didee dʋmagbʋ nɩ: -wa -ka 'Yu 'yɩ, 'ɩn wa -ka ɔ dlɩ -gʋ zʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ wa yɩa, 'ɩn dʋdʋʋ bhɩa zlɩ, ɩn -sɔlʋ wa 'wʋ tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tɔʋn, Zuifʋ yia -Zezu -yɔ ŋwuŋwenie bhli, -we ka gbʋ -wa, ɔ nɛɛ nɩɩ, ɔ mɩ 'floo -we 'bhʋa yalɩ nya. ");
INSERT INTO kyf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wamɩa nɛɛ: «-Ɔ mɩa dɛ nɩ, -Zezu -wa. We 'nɩ mʋʋ? -A -yi ɔ dide -yɔ ɔ 'nyaa. Nɩɩ, *-Zɛzɛfʋʋ 'yu ɔ -mɩa. Sa ɔ gba -slɛɛn nɩɩ, yalɩ ɔ 'bhʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","-Bha -Zezu 'palɩa wa wɛlɩɩ 'bɩgʋɛ: «A 'na 'ŋwuŋweni a 'dɛkpʋa nyɩdɩ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɩɩ, nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka na -gbɛ yi, 'mʋ we 'nɩ nɩɩ, na Dide -ɔ tiea 'mɩ, mɔ gbize ɔ 'wʋ. 'Ɩn -ɔ -ka na -gbɛ yi nɩ, dʋdʋʋ bhɩa zlɩ, 'ɩn na sɔlʋa ɔ 'wʋ tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","-We mɩa cɛlɩda -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ 'wʋ, mʋ nɩ: ‹-Lagɔ yia wa 'dɛ weee gbʋ -slolua.› Nyɩma weee -wa nʋa na Didee wɛlɩ, 'ɩn -we ɔ slolua, 'ɩn wa ŋwnua we -yɔ, ma yia na -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nɩɩ, -ɔ 'bhʋa -Lagɔɔ -gbɛ ɔ 'dɛbhlogbɔɔ 'yɩa Dide. We 'nɩ ɔmɔ 'wʋbhʋ, nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ Dide 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ zʋa 'mɩ dlɩ -gʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, we mɩ ɔ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nɩɩ, 'floo -we nyɛa nyɩmɛ 'yliyɔgagɩe, -amɩ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Da bɛblɛɛ mɩa, amɩaa dʋkpasɩ ka -mɔ *manɩ li, we mɩ 'sa 'bhie, 'ɩn wa yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nɩɩ, -mʋʋ -ka wee 'floo -we bhʋa yalɩ nɩ, nyɩmɛ -ɔ -ka we li, ɔ 'nɩa tlɩa yi. ");
INSERT INTO kyf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɩn nɛɛ, 'floo -we 'bhʋa yalɩ, -we wlaa 'yliyɔgagɩe, -amɩ -wa. Wee 'floo mɩa, nyɩmɛ -ɔ -ka we li nɩ, 'ɩn ɔ yɩa 'yliyɔgagɩe -we 'nɩa bhloluda -ka. Nɩɩ, 'floo na yia wlaa, mʋ -wa na yɩcɛ, 'mʋ na yia wlaa dʋdʋgʋ -nyɩmaa 'yliyɔgagɩee 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","-Bha Zuifʋʋ kpɩkpɛlɩe sumanɩa 'wʋ, 'ɩn wa nɛɛ: «'Lee, sa nyɩmɛ nɩ 'ka ɔ yɩcɛ -aɩn 'nyɛ lililu 'bhisaa?» ");
INSERT INTO kyf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tɔʋn, -Zezu nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, a 'nɩ Nyɩmɛɛ 'Yuu yɩcɛ li, 'ɩn a 'ka ɔ 'pɩɔn 'ma, 'yliyɔgagɩe 'na 'ka aɩn 'wʋ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nyɩmɛ -ɔ lia na yɩcɛ, 'ɩn -ɔ maa na 'pɩɔn, ɔ ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka. 'Ɩn dʋdʋʋ bhɩa zlɩ nɩ, -amɩ na sɔlʋa ɔ 'wʋ tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nɩɩ, na yɩcɛ mɩa lililu -zɔnʋ -wa, 'ɩn na 'pɩɔn mɩa, 'mamalu -zɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nyɩmɛ -ɔ -ka na yɩcɛ li, 'ɩn ɔ -ka na 'pɩɔn 'ma, ɔ mɩ 'mɩ 'wʋ, 'ɩn -amɩ mɩ ɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sa Dide -ɔ tiea 'mɩ, ɔ -gaa 'yliyɔ, 'ɩn ɩn yia 'yliyɔgagɩe 'yɩ ɔ 'gbʋ, 'sa -bhlokpadɛ -ɔ -ka 'mɩ lida -tʋ, 'ɩn -mɔɔ yɩa 'yliyɔgagɩe na 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nɩɩ, -we -wa 'floo -we 'bhʋa yalɩ nɩ, mʋ nɩ: wee 'floo mɩa, we -yɔ amɩaa dʋkpasɩɩ lilifloo 'nɩ 'wʋwlʋ. Nɩɩ, wamɩa ka tlɩ. 'Ɩn nyɩmɛ -ɔ -ka wee 'floo nɩ li, ɔ mɩ 'yliyɔgada 'ylɩ weee nya.» ");
INSERT INTO kyf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nɩɩ, gbʋ weee -we mɩa dɛ, -mɔ Kapɛnaumʋʋ *-Lagɔbudu zɔ ɔ -slolua we. ");
INSERT INTO kyf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Da -Zezuu 'bɩnɔnya 'nʋa ɔ wɛlɩ, 'ɩn wa glaa nyɩma duun nɛɛ: «Nyɔɔ mneni ɔ 'ka ɔ wɛlɩ nɩ -yɔŋwnua? Wee wɛlɩ nɩ 'nɩ 'tɛ -sɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Da -Zezu yibhelia we 'ji nɩɩ, -we ɔ gbaa, ɔ 'bɩnɔnya mɩ we 'gbʋ 'ŋwuŋweda, ɔ nɛɛ wa -yla: «-We mɩa da nɩ, mʋ dɩa amɩaa 'kʋa 'wʋ yɩ? ");
INSERT INTO kyf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Ɩn da a -ka -slɛɛn *Nyɩmɛɛ 'Yu -yɔyɩ yalɩ lʋmnɩda, sa a 'ka gbaa? ");
INSERT INTO kyf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nɩɩ, -Lagɔɔ Zuzu wlaa 'yliyɔgagɩe, we 'nɩ -mʋʋ nɩ, nyɩmɛɛ 'dɛ -bhlo 'nɩ we mneni. Wɛlɩ -we ɩn gbaa da aɩn -yla, -Lagɔɔ Zuzu nya ɩn gbaa we, 'ɩn we nyɛa nyɩmɛ 'yliyɔgagɩe. ");
INSERT INTO kyf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","We mɩ 'sa 'bhie, nyɩma tɔlʋa mɩ aɩn glaa, wa'a zʋ 'mɩ dlɩ -gʋ.» Nɩɩ, we bhlili we gwedɩda, nyɩma -wa 'nɩa ɔ dlɩ -gʋ zʋ, we -yɔ nyɩmɛ -ɔ 'kaa ɔ wla, wa 'ka ɔ 'bha, -Zezuu 'dɛ -yi wa. ");
INSERT INTO kyf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","-Bha ɔ gba 'yaɛ: «We 'gbʋ ɩn yia da aɩn -yla gba nɩɩ, nyɩmɛ -ɔ Dide 'nɩ 'yoo 'nyɛ ɔ 'ka na -gbɛ yi, ɔ 'nɩ we mneni.» ");
INSERT INTO kyf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","We 'bhʋ we bhla nɩ 'wʋ, ɔ 'bɩnɔnya glaa, nyɩma duun yia ɔ 'bɩ 'bhʋ. Wa -yɔ ɔ'ɔ bhli -slɛɛn 'yoo -bhlo. ");
INSERT INTO kyf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","-Slɛɛn, -Zezu nɛɛ ɔ 'bɩnɔnya kugbua lɛ 'sɔ -yla: «'Ɩn amɩa naa, amɩa 'nɩ 'ya 'yɩbha a 'ka mnɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔ Piɛlɩ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Na -Kanyɔ, 'lee, nyɔɔ ka -gbɛ -a 'ka mnɩa? Nɩɩ, wɛlɩ -we nyɛa nyɩmɛ 'yliyɔgagɩe -we 'nɩa bhloluda -ka, -mɩ kwɛɛ we mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nɩɩ, -amɩa mɩa, -a ka dlɩ zʋ, 'ɩn -a yia we 'jiyibheli nɩɩ, -Lagɔɔ -Mɔwlʋnyɔ ɔ tiea, 'mɔ -ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","-Zezu nɛɛ wa -ylaɛ: «Amɩa nyɩma kugbua lɛ sɔ mɩa dɛ nɩ, -amɩ -saa -bha aɩn, we 'nɩ mʋʋ? Nɩɩ, aɩn glaa, nyɩmɛ yabhlo mɩa *'Kuzuu -nʋ mɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ɔ mɩa we gbada, Simɔ Isɩkaliɔtʋʋ 'yu Zudasɩ ɔ saa 'ŋnɩ. Nɩɩ, ɔɔ Zudasɩ mɩa, ɔ mɩ -Zezuu 'bɩnɔnya kugbua lɛ 'sɔ glaa, 'bhie, mɔ yia ɔ wlaa. ");
INSERT INTO kyf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","-Mʋʋ 'bɩgʋ, -Zezu yia Galilee -dʋdʋ -gʋ mnɩ, -zugba ɔ plɩlɩ 'gbenya 'wʋ. Nɩɩ, ɔ 'nɩ 'yɩbha ɔ 'ka Zudee -dʋdʋ -gʋ nyni, Zuifʋʋ 'yugalɩnya mɩ ɔ 'bhabhɩee 'klɩ 'yɩdaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Zuifʋ -fɛtɩ -we wa laa -fa -fɛtɩ, we ka cɩpa, ");
INSERT INTO kyf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'ɩn ɔ bhelia nɛɛ ɔ -yla: «-Ɩn 'bhʋ -seli, -ɩn 'ka Zudee mnɩ, 'ɩn -na 'bɩnɔnya 'ka -na lɛnʋgbʋ -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nyɩmɛ -ɔ 'yɩbhaa nɩɩ, wa yibheli ɔ, ɔ'ɔ zize ɔ lɛnʋgbʋ. -Slɛɛn, -ɩn mɩ gbʋnya nɩ lɛnʋdaa 'gbʋ, -ɩn -slolu -na 'dɛ dʋdʋgʋ -nyɩma 'klʋ wa 'ka -mɩ -yɔyɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nɩɩ, -Zezuu bheliaa 'dɛbhie 'nɩ ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Ɩn -Zezu nɛɛ: «-Amɩ mɩa, nanʋ 'ylɩ -zɔnʋ 'nɩ -slɔ nyni. Amɩa, 'ylɩ weee nanɩ 'yli amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dʋdʋgʋ -nyɩma 'nɩ mneni wa 'ka aɩn 'wʋnyɛ, nɩɩ, -amɩ wa nyɛa 'wʋ, -we ka gbʋ -wa, ɩn ka wa lɛnʋgbʋ 'yliyɔlabhlɩ, 'ɩn ɩn nɛɛ nɩɩ, wa lɛnʋgbʋ -nyu 'yli. ");
INSERT INTO kyf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɩɩ, amɩa, a mnɩ 'fɛtɩ nɩ -gʋ. Nanʋʋ 'ylɩ 'nɩ -slɔ nynii 'gbʋ, -amɩ 'na 'ka mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ɔ bhɩa -we mɩa dɛɛ gbagbɩe, 'ɩn ɔ yia Galilee -tʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nɩɩ, ɔ bhelia mnɩa wee 'fɛtɩ -gʋ, 'ɩn -Zezuu 'dɛbhie yia -mɔ mnɩ zizewiemɩ. Ɔ 'nɩ -zejila 'wʋ 'tla. ");
INSERT INTO kyf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wa mɩ 'fɛtɩ -sada, -zugba Zuifʋʋ 'yugalɩnya nɔnʋ ɔ 'ylibɩla, 'ɩn wa gbaa: «Da ɔɔ nyɩmɛ nɩ mɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","-Bha nyɩma duun kpɛlɩa ɔ -gʋ, tɔlʋa nɛɛ: «Gbʋ -zɔnʋ ɔ nʋa lɛ», tɔlʋa nɛɛ: «-Ɩnnya, we 'nɩ 'sa -mɩ, nyɩma ɔ nʋa -dawli 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nɩɩ, wa mɩ Zuifʋʋ 'yugalɩnya sɔdaa 'gbʋ, -ɔ 'kaa -Zezuu gbʋ gba -zejila 'wʋ, we -kanyɔ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Da 'fɛtɩɩ 'ylɩ ya 'sɔlɛ 'plɩa, -Zezu plaa -Lagɔbudu 'kadʋ zɔ, 'ɩn ɔ yia -mɔ nyɩma gbʋslolue bhli. ");
INSERT INTO kyf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","-Bha ŋwɛgaga -sʋbhalɩa Zuifʋ, 'ɩn wa nɛɛ: «Ɔmɔ nyɩmɛ 'nɩa 'sɛbhɛ 'kpɩa, 'lee, sa ɔ nʋ, 'ɩn ɔ -yi 'sɛbhɛa?» ");
INSERT INTO kyf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ɔ nɛɛ: «Na gbʋslolue mɩa, we'e 'bhʋ na 'dɛɛ -gbɛ. Nɩɩ, -ɔ tiea 'mɩ, ɔ -gbɛ we bhʋa. ");
INSERT INTO kyf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nɩɩ, nyɩmɛ -ɔ -saa dlɩ ɔ 'ka -Lagɔɔ dʋmagbʋ lɛnʋ, 'ji ɔ yia we yibhelia nɩɩ, wee gbʋslolue mɩa, -de -Lagɔɔ -gbɛ we bhʋʋ, 'ɩn -de na 'dɛɛ 'ŋnɩ nya na gbaa. ");
INSERT INTO kyf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nyɩmɛ -ɔ gbaa ɔ 'dɛɛ 'ŋnɩ nya, ɔ 'dɛɛ 'ylimanɩee da ɔ talɩa. Nɩɩ, nyɩmɛ -ɔ talɩa -ɔ tiea ɔ, -mɔɔɔ 'ŋnɩɩ 'ylimanɩee da, gbʋzɔnʋ ɔ gbaa, ɔ'ɔ 'tʋbhʋ yo. ");
INSERT INTO kyf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moizɩ palɩa tite aɩn -yla, we 'nɩ mʋʋ? 'Ɩn wee tite mɩa, aɩn glaa nyɩmɛ yabhlogbɔɔ 'nɩ we 'nʋŋwɛ zʋda -mɩ. Nɩɩ, lɛɛ -lu ka 'gbʋ a 'ka 'mɩ 'bhaa?» ");
INSERT INTO kyf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","-Bha waa nyɩmaa -zlo gbaa: «Zuzu 'nyuu kpaa -mɩ yɩ? 'Lee, nyɔɔ gba ɔ 'ka -mɩ 'bhaa?» ");
INSERT INTO kyf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Gwɛdigbʋ -bhlogbɔɔ ɩn nʋa lɛ, mʋ sʋbhalɩa dɛ a 'dɛ weee ŋwɛgaga. ");
INSERT INTO kyf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nɩɩ, Moizɩ ka aɩn knɩ -plaplɩe -slolu. ('Ɩn wee knɩ -plaplɩe mɩa, we 'nɩ Moizɩ -la we la, ɔ dʋkpasɩ -wa.) We 'gbʋ, amɩa, *Nyapɛylɩ nyaoo, 'ɩn a paa nʋkpasu knɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amɩa -ka nyɩmɛ *knɩ 'wʋpa Nyapɛylɩ nya, Moizɩɩ tite 'nʋŋwɛzʋzʋee saa nɩ, -slɛɛn, -amɩ -ka nyɩmɛ -kpabhie jipe Nyapɛylɩ nya nɩ, 'lee, lɛɛ -lu ka 'gbʋ a palɩ 'mɩ -yɔ 'cɛa? ");
INSERT INTO kyf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sa a yɩa -lu -yɔ, a 'na 'bhulu 'sa we -yɔgbʋ 'wʋ -nɩ, a 'bhu gbʋ 'wʋ sa tɩklɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","-Bha -Zeluzalɛmʋ -nyɩma tɔlʋa gbaɛ: «Nyɩmɛ -ɔ ka da wa mɩa -talɩda wa 'ka ɔ 'bha, mɔ 'nɩ da -mɩɩ? ");
INSERT INTO kyf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mɔɔ gbaa -slɛɛn dɛ gbʋ -zejila 'wʋ, 'ɩn wa'a -sa ɔ -gʋ! 'Ji -amɩaa 'yugalɩnya yibhelia we nɩɩ, mɔ -wa -Lagɔɔ -Bhasanyɔ -zɔnʋ yɩ? ");
INSERT INTO kyf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nɩɩ, ɔmɔ, -ɔ mɩa da, -a -yi ɔ 'bhʋlʋda da. 'Ɩn -Lagɔɔ -Bhasanyɔ mɩa, ɔ -ka yi, da ɔ yia 'bhʋa, nyɩmɛ 'nɩ -bha da -yi.» ");
INSERT INTO kyf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Da ɔ mɩa nyɩma gbʋ -sloluda -Lagɔbudu 'kadʋ zɔ, -bha ɔ 'kpɩa 'wʋ 'tɩtɛɛ: «A nɛɛ nɩɩ, a -yi 'mɩ, 'ɩn da ɩn 'bhʋa a -yi -bha da. We mɩ 'sa 'bhie, we 'nɩ na 'dɛ nya ɩn yi. Nɩɩ, -ɔ tiea 'mɩ, ɔ mɩ tɩklɩɩ. Amɩa 'nɩ ɔ -yi, ");
INSERT INTO kyf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","-amɩ ɩn -yi ɔ, -we ka gbʋ -wa, ɔ -gbɛ na bhʋa, 'ɩn mɔ tiea 'mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","We 'dɛɛ 'gbʋ wa 'yɩbha wa 'ka ɔ kpa. Nɩɩ, ɔ 'ylɩ 'nɩ -slɔ nynii 'gbʋ, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Waa nyɩma glaa, nyɩma duun ka ɔ dlɩ -gʋ zʋ. -Maa nɛɛ: «-Lagɔɔ -Bhasanyɔ mɩa, ɔ -ka yi nɩ, gwɛdigbʋ nyɩmɛ nɩ nʋa dɛ lɛ, ɔmɔ -nʋ 'na 'ka -mɔɔ -zi.» ");
INSERT INTO kyf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","-We nyɩma duun mɩa 'ŋwuŋweda ɔ daa, Falizɩnyɩma 'nʋa we, -bha *-Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma tiea -mɔ -Lagɔbudu 'kadʋʋ ŋwɛkʋnya wa 'ka ɔ kpa. ");
INSERT INTO kyf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","-Zezu nɛɛ 'yaɛ: «Ɩn -yɔ aɩn 'sɔ mɩ -slɔ da bhla -sɛlɛ nya, -mʋʋ 'bɩgʋ, -ɔ tiea 'mɩ, ɔ -gbɛ na yia lʋ 'bhitia. ");
INSERT INTO kyf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɩɩ, na da a yia -talɩa yia, 'ɩn a 'nɩa 'mɩ 'yɩa yi, -we ka gbʋ -wa, da na mnɩa, amɩa, a 'nɩ mneni a 'ka -mɔ mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","-Bha Zuifʋ gbʋgbalɩa -ylaɛ: «Mɔ ɔ 'ka mnɩa, 'ɩn -a 'na 'ka ɔ 'yɩa? 'Lee, Zuifʋ mɩa -glɔgʋ -mɔ *Glɛkɩ glaa, wa glaa ɔ yia mnɩa yɩ? 'Lee, waa Glɛkɩ ɔ yia -slolua mnɩa yɩ? ");
INSERT INTO kyf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wɛlɩ -we mɩa da nɩ, sa we 'ji mɩa? Ɔ nɛɛ: ‹Na da a yia -talɩa, 'ɩn a 'nɩa 'mɩ 'yɩa yi,› 'ɩn: ‹Da ɩn mɩa mnɩda, amɩa, a 'nɩ mneni a 'ka -mɔ mnɩ.› » ");
INSERT INTO kyf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nɩɩ, 'fɛtɩɩ 'wʋbhlolu -ylɩ mɩa, -we -wa wee 'ylɩɩ 'kadʋ, we nya -Zezu bɛa nyɩma 'yu, 'ɩn ɔ nɛɛ wɛlɩ 'tɩtɛ nyaɛ: «Nyɩmɛ -ɔ 'nyumatʋ -ka 'bha, ɔ yi na -gbɛ, 'ɩn ɔ 'ka 'ma. ");
INSERT INTO kyf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nyɩmɛ -ɔ -ka 'mɩ dlɩ -gʋ zʋ, 'wlʋwlʋnyu -we wlaa 'yliyɔgagɩe, mʋ yia ɔ dlɩ zɔ 'wlʋa, 'sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","'Nyu -we ka gbʋ ɔ gbaa, -Lagɔɔ Zuzu -wa. Nyɩma -wa zʋa ɔ dlɩ -gʋ nɩ, 'mʋ -Lagɔ yia wa 'nyɛa. Nɩɩ, -Lagɔ 'nɩ -slɔ Zuzu yoo 'pa, ɔ 'nɩ -slɔ -Zezu 'ŋnɩylilo 'nyɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nɩɩ, nyɩma duun 'nʋa -Zezuu wɛlɩ, wa tɔlʋa nɛɛ: «-Ɔ mɩa dɛ, -Lagɔgbʋʋ -falɩpanyɔ -a mɩa wʋda, mɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nyɩma tɔlʋa nɛɛ 'ya: «-Lagɔɔ -Bhasanyɔ mɩa, mɔ -wa,» nɩɩ, tɔlʋa nɛɛ: «-Lagɔɔ -Bhasanyɔ 'na 'ka Galilee 'bhʋ, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","-Lagɔsɛbhɛ nɛɛ nɩɩ, -Lagɔɔ -Bhasanyɔ mɩa, *-Davidɩɩ zʋayli ɔ yia 'bhʋa. Bɛtɩlɛmʋ -Davidɩɩ -zɔɔ mɩa, -mɔ ɔ yia 'bhʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɔɔ -Zezuu 'gbʋ waa nyɩma nɩ yia -yɔ 'bhʋbhlʋ. Wa 'nɩ 'maslɛɛn wɛlɩ -bhlo -ka. ");
INSERT INTO kyf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nyɩma tɔlʋa 'yɩbha wa 'ka ɔ kpa. Nɩɩ, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ kwɛzɩ. ");
INSERT INTO kyf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Da waa -Lagɔbudu 'kadʋʋ ŋwɛkʋnya 'bhʋa we ŋwɛɛ, 'ɩn wa yia -Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩmaa -gbɛ lʋ mnɩ. -Bha -maa 'yɩbhaa wa laɛ: «Lɛɛ -lu ka 'gbʋ a 'nɩ -Zezu kpa, 'ɩn a -yɔ ɔ 'ka yia?» ");
INSERT INTO kyf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wa nɛɛ: «-A -ka bhaa 'wlʋ, nyɩmɛ 'nɩa -slɔ nyɩmɛ nɩ 'bhisa gba.» ");
INSERT INTO kyf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'Ɩn Falizɩnyɩma nɛɛ wa -yla: «Amɩa, ɔ ka 'ya aɩn -dawli 'wʋnʋ, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Zuifʋʋ 'yugalɩnya -yɔ Falizɩnyɩma glaa, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Ɩn waa nyɩma mɩa dɛ, wa 'nɩ -amɩaa tite -yi, 'ɩn -Lagɔ ka wa mɛ -yɔ la tɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nɩɩ, Falizɩnyɩmɛ yabhlo mɩ wa glaa, 'mɔ wa laa 'Nikodɛmʋ. (Ɔɔ 'Nikodɛmʋ, -ɔ mnɩa -Zezu 'yɩa zlɩmɛ, mɔ -wa.) Ɔ nɛɛ wa -yla: ");
INSERT INTO kyf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«-Amɩaa tite 'nɩ gba nɩɩ, -a 'bhu sa nyɩmɛɛ -yɔgbʋ 'wʋ. -A 'nʋ -slɔ ɔ wɛlɩ, 'ɩn -we ɔ nʋa lɛ, -a 'ka we yibheli 'bhie, -a 'ka ɔ gbʋ dɩlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɩɩ, tɔlʋa palɩa ɔ ŋwɛɛ, wa nɛɛ: «-Mɩ mɩa dɛ, Galilee -nyɩmɛ -mɩ mɩ 'yaa yɩ? -Ɩn -talɩ -slɔ -Lagɔwɛlɩ zɔ, 'ɩn -na yɩa nɩɩ, -Lagɔgbʋʋ -falɩpanyɔ yabhlogbɔɔ 'na 'ka Galilee 'bhʋ.»  ");
INSERT INTO kyf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","-Slɛɛn, -mɔmɔ -ka 'wʋsɔ, 'ɩn -mɔɔ mnɩa -mɔɔ -buduŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nɩɩ, -Zezu mnɩa *Olivʋsunyaa -gɔgɔ 'wlu, ");
INSERT INTO kyf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","zlɩ zlɩa, we zlʋkpɛ -papa, -bha ɔ mnɩa -Lagɔbudu 'kadʋ zɔ lʋ, 'ɩn nyɩma weee yia ɔ -gbɛ yi. 'Ɩn -Zezu yia ladɩ ɔ 'ka nyɩma gbʋ -slolu. ");
INSERT INTO kyf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","-Slɛɛn, -Lagɔɔ titee gwesanya -yɔ Falizɩnyɩma -laa ylɩkwʋŋwnɔ yabhlo -Zezu 'yu. Ɔɔ ŋwnɔ mɩa, 'mɔ wa kpaa, -zugba ɔ -yɔ nʋkpasu -putu mɩ -budu 'wʋdɩda. -Bha wa 'yligbelia ɔ wa 'dɛ weee nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","-Maa nɛɛ -Zezu -ylaɛ: «-Slolunyɔ, nɩɩ, 'ŋwnɔ -ɔ mɩa da nɩ, ɔ -yɔ nʋkpasu -putu mɩ -budu 'wʋdɩda, 'ɩn wa yia ɔ kpa. ");
INSERT INTO kyf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moizɩ nɛɛ tite 'wʋ nɩɩ, 'sasʋkpa -ŋwnɔ mɩa, wa 'bha ɔ gbɔkʋ 'wʋ. 'Ɩn -mɩ, -ɩn nɛɛ saa?» ");
INSERT INTO kyf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɔ zɔbhlilie nya wa gbaa dɛ wɛlɩ nɩ, ɔ 'dɛɛ wɛlɩ 'ka ɔ kpa, 'ɩn wa 'ka ɔ gbʋ dɩlɩ. Nɩɩ, -Zezu kwlia 'wʋ, 'ɩn ɔ yia -di la tli dʋdʋ ɔ -kwɩtɛya nya. ");
INSERT INTO kyf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wa mɩ ɔ layɩbhadaa 'gbʋ, ɔ -sɔa 'wʋ, ɔ nɛɛ: «Aɩn glaa, nyɩmɛ -ɔ 'nɩa -slɔ gbʋnyuu yabhlogbɔɔ lɛnʋ, -mɔɔ 'pa ŋwnɔ nɩ gbɔkʋ tɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'Bhie, ɔ yi 'yaa 'wʋkwli, -zugba ɔ cɛlɩ dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Da wa 'nʋa ɔ wɛlɩ, 'ɩn wa yia mnɩmnɩe bhli -bhlo -bhlo, we bhlili nyɩma kpasɩ -gʋ, 'ɩn -Zezuu 'dɛbhlo yia -bha -tʋ we -yɔ ɔɔ 'ŋwnɔ. ");
INSERT INTO kyf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","-Slɛɛn, -Zezu -sɔa 'wʋ, ɔ nɛɛ: «Bhɔlɔ, da wa mɩa? Da amaa gbʋdɩlɩnyaa 'dɛbhie mɩa? 'Lee, nyɩmɛ yabhlogbɔɔ 'nɩ -tʋ ɔ 'ka aɩn gbʋ -dɩlɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɔ nɛɛ: «Na -Kanyɔ, nyɩmɛ yabhlogbɔɔ 'nɩ da -tʋ ɔ 'ka 'mɩ gbʋ -dɩlɩ.» 'Ɩn -Zezu nɛɛ: «'Ɩn -amɩ, ɩ'ɩn -dɩlɩ 'ya aɩn gbʋ. Nɩɩ, a mnɩ -buduŋwɛɛ. We 'bhʋ -zɛɛn 'wʋ, ama -putu 'na nʋnʋ gbʋnyuu lɛ -nɩɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","-Slɛɛn, -Zezu nɛɛ 'ya nyɩma -yla: «-Amɩ -wa dʋdʋgʋ -nyɩmaa zlɩ. Nyɩmɛ -ɔ yia 'mɩ 'bɩ nɔa, ɔ 'nɩa nikpise 'wʋ nɔa yi. Nɩɩ, zlɩ -we wlaa 'yliyɔgagɩe, 'mʋ ɔ yia 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","-Bha Falizɩnyɩma gbaɛ: «-Na 'dɛ -wa -na gbʋdayɩnyɔ, wɛlɩ -we -na yia gbaa, -a 'na 'ka we gbʋzɔnʋ la.» ");
INSERT INTO kyf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Nɩɩ, na 'dɛ yi na gbʋdayɩnyɔ nya -mɩoo, gbʋzɔnʋ -wa. -We ka gbʋ -wa, mɔ na bhʋa, we -yɔ mɔ na mnɩa, ɩn -yi -bha da. We mɩ 'sa 'bhie, amɩa, da na bhʋa, a 'nɩ -bha da -yi, 'ɩn mɔ na mnɩa, a 'nɩ -bha da -yi. ");
INSERT INTO kyf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sa dʋdʋgʋ -nyɩma bhua gbʋ 'wʋ, 'sa a bhua nyɩmaa -yɔgbʋ 'wʋ. Nɩɩ, -amɩ mɩa, ɩ'ɩn 'bhu nyɩmɛ yabhlogbɔɔɔ -yɔgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nɩɩ, we -ka nyɩmɛɛ -yɔgbʋ ɩn 'ka 'wʋbhu, na gbʋwʋbhubhue mɩ tɩklɩɩ. -We ka gbʋ -wa, we 'nɩ na 'dɛbhlogbɔɔ bhu wee gbʋ 'wʋ, Dide -ɔ tiea 'mɩ, ɩn -yɔ ɔ 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","We mɩ amɩaa tite 'wʋ cɛlɩda nɩɩ, -we gbʋdayɩnya 'sɔ -ka gba wɛlɩ -bhlo nya, a mneni a 'ka we dlɩ -gʋ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","-Amɩ mɩ na gbʋdayɩnyɔ nya, 'ɩn Dide, -ɔ tiea 'mɩ, -mɔɔ mɩ 'yaa na gbʋdayɩnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wa nɛɛ ɔ -yla: «Da -na Dide mɩa?» -Zezu nɛɛ: «Amɩa, a 'nɩ 'mɩ -yi, 'ɩn a 'nɩ na Dide -yi, a -ka yaa 'mɩ -yi, -zugba a -yi yaa na Dide.» ");
INSERT INTO kyf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nɩɩ, wee gbʋ nɩ -Zezu gbaa, -zugba ɔ mɩ nyɩma gbʋ -sloluda -Lagɔbudu 'kadʋ zɔ, da wa palɩa -Lagɔgwɛzi, we kwesi. Ɔnʋʋ 'ylɩ 'nɩ -slɔ nynii 'gbʋ, nyɩmɛ yabhlogbɔɔ 'nɩ ɔ kpa. ");
INSERT INTO kyf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","-Zezu nɛɛ 'ya wa -yla: «Mnɩa na yia, 'ɩn na da a yia -talɩa. Nɩɩ, amɩaa gbʋnyuu lʋ a yia tlɩlɩa. Da ɩn mɩa mnɩda a 'nɩ mneni a 'ka -mɔ mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","-Slɛɛn, Zuifʋʋ 'yugalɩnya nɛɛ: «Ɔ 'dɛ ɔ yia 'bhaa yɩ? -We ka gbʋ -wa, ɔ nɛɛ: ‹Da ɩn mɩa mnɩda, a 'nɩ mneni a 'ka -mɔ mnɩ.› » ");
INSERT INTO kyf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Amɩa, dʋdʋʋ -nʋ a -mɩa, 'ɩn -amɩ, yalɩɩ -nʋ ɩn -mɩa. Dʋdʋgʋ -nyɩma a -mɩa, 'ɩn -amɩ 'nɩ dʋdʋgʋ -nyɩmɛ. ");
INSERT INTO kyf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","We 'dɛɛ 'gbʋ ɩn yia gba nɩɩ, amɩaa gbʋnyii lʋ a yia tlɩlɩa. 'Ɩn tlɩa a yia amɩaa gbʋnyii lʋ, we -ka nɩɩ, a 'nɩ we dlɩ -gʋ zʋ nɩɩ, -ɔ ɩn -mɩa, 'mɔ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","-Bha wa 'yɩbhaa ɔ laɛ: «Nyɔɔ -ɩn -mɩa?» Ɔ nɛɛ: «We 'bhʋ we gwedɩda, ɩn mɩ we aɩn -yla gbada. ");
INSERT INTO kyf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ɩn mneni ɩn 'ka gbʋ duun gba amɩaa daa, 'ɩn ɩn 'ka aɩn gbʋ dɩlɩ. Nɩɩ, -ɔ tiea 'mɩ, ɔ mɩ tɩklɩɩ, 'ɩn -we ɩn 'nʋa ɔ -gbɛ, 'mʋ na gbaa dʋdʋgʋ -nyɩma -yla.» ");
INSERT INTO kyf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wa 'nɩ we 'wʋ la 'nʋ nɩɩ, ɔ Didee gbʋ ɔ mɩa gbada. ");
INSERT INTO kyf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","We 'gbʋ, ɔ nɛɛ wa -yla: «A -ka Nyɩmɛɛ 'Yu 'wʋbhu yalɩ 'bhie, a yibhelia we 'ji nɩɩ, -ɔ ɩn -mɩa, 'mɔ ɩn -mɩa. 'Ji a yia we yibhelia nɩɩ, ɩ'ɩn nʋ -lu yabhlogbɔɔ lɛ na 'dɛ -bhlo, nɩɩ, -we Dide -slolua 'mɩ, 'mʋ na gbaa. ");
INSERT INTO kyf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nɩɩ, -ɔ tiea 'mɩ ɔ -yɔ 'mɩ 'sɔ mɩ. 'Ylɩ weee nya, -we nanɩa ɔ dʋdʋ 'mʋ na nʋa lɛ, we 'dɛɛ 'gbʋ, ɔ 'nɩ na 'dɛ -bhlo tɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Da ɔ gbaa gbʋ nɩ, -bha nyɩma duun zʋa ɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","-Zezu nɛɛ Zuifʋ -wa zʋa ɔ dlɩ -gʋ -ylaɛ: «A -ka na wɛlɩ -gʋ nɔ, a mɩ na 'bɩnɔnya -zɔnʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Ɩn a yibhelia gbʋzɔnʋ, 'ɩn wee gbʋzɔnʋ saa aɩn gaylo 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wa nɛɛ: «Nɩɩ, *Ablaamʋʋ 'yuoyua -a -mɩa, -amɩaa klu -ka bhaa 'wlʋ, nyɩmɛ yabhlogbɔɔ 'nɩ -slɔ -aɩn galɩ -zɛlɩ. Lɛɛ -lu ka 'gbʋ -na gba -slɛɛn nɩɩ, -ɩn 'ka -aɩn gayloflii -saa?» ");
INSERT INTO kyf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","-Zezu -saa wa -gʋ, ɔ nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, -ɔ nʋa gbʋnyuu lɛ, gbʋnyuu gaylo ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gaylo mɩa, yiyinyɔ -wa, ɔ 'nɩ -buduŋwɛɛ -nyɩmɛ 'ylɩ weee -nʋ nya. 'Ɩn, -buduŋwɛɛɛ -kanyɔɔ 'yu mɩa, -buduŋwɛɛ -nyɩmɛ ɔ -mɩa 'ylɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nɩɩ, -Lagɔɔ 'Yu -ka aɩn gayloflii -sa nɩ, gayloflii a 'bhʋaa 'dɛbhie -gbolu. ");
INSERT INTO kyf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ablaamʋʋ 'yuoyua a -mɩa, ɩn -yi we 'ji. Nɩɩ, a 'yɩbha a 'ka 'mɩ 'bha, -we ka gbʋ -wa, a'a ŋwnu na wɛlɩ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","-Amɩ mɩa, -we ɩn 'yɩa Didee -gbɛ, 'mʋ na gbaa. 'Ɩn amɩa, -we a 'nʋa amɩaa didee -gbɛ, 'mʋ a nʋa lɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wa nɛɛ: «-Amɩaa dide mɩa, Ablaamʋ -wa.» Ɔ nɛɛ wa -ylaɛ: «A -ka Ablaamʋʋ 'yua nya -mɩ gbʋzɔnʋ saa, -we ɔ nʋa lɛ, a ka yaa we lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nɩɩ, -slɛɛn mɩa, na 'bhabhɩee da a mɩa -talɩda, 'ɩn ɩn ka -nanʋ aɩn -yla gbʋzɔnʋ gba, gbʋzɔnʋ -we ɩn 'nʋa -Lagɔɔ -gbɛ. Wee gbʋ mɩa, Ablaamʋ 'nɩ we 'sasʋkpa -nʋ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nɩɩ, amɩa mɩ amɩaa didee lɛnʋgbʋ lɛnʋda.» -Bha wa gbaɛ: «-A 'nɩ bhoyi -gʋ yua nya -mɩ. -A 'dɛ weee ka Dide -bhlo, -Lagɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ɔ nɛɛ wa -yla: «-Lagɔ -ka yaa amɩaa Dide, -zugba a -kalɩ yaa na zɛ. -We ka gbʋ -wa, ɔ -gbɛ na bhʋa, 'ɩn ɔ 'gbʋ ɩn mɩa -seli. We 'nɩ na 'dɛ nya ɩn yi, mɔ tiea 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","A 'nɩ na wɛlɩ 'wʋlanʋda -mɩ, lɛɛ -lu ka 'gbʋa? -We ka gbʋ -wa, a 'nɩ mneni a 'ka na wɛlɩ 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɩɩ, amɩaa dide -wa 'Kuzu, 'ɩn a 'yɩbha a 'ka 'Kuzuu dʋmagbʋ lɛnʋ. We 'bhʋ we gwedɩda, we mɩ nyɩmɛbhanyɔ nya. Gbʋzɔnʋ 'nɩ -slɔ we ŋwɛɛ 'wlʋ. Gbʋzɔnʋ 'nɩ we 'wʋ -mɩɩ 'gbʋ. We 'dɛɛ wɛlɩ mɩa, mʋ -wa yoyowɛlɩ. We mɩ *yokanyɔ nya, 'ɩn we mɩa *yoo dide nya. ");
INSERT INTO kyf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Ɩn -amɩ, gbʋzɔnʋ na gbaa 'gbʋ, a'a ŋwnu na gbʋ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aɩn glaa, nyɔɔ 'ka we -slolu nɩɩ, ɩn ka gbʋnyuu lɛnʋa? Nɩɩ, ɩn -ka gbʋzɔnʋ gba nɩ, lɛɛ -lu ka 'gbʋ a'a ŋwnu we -yɔa? ");
INSERT INTO kyf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nɩɩ, nyɩmɛ -ka -Lagɔɔ -nʋ nɩ, -Lagɔɔ wɛlɩ ɔ nʋa. A 'nɩ -Lagɔɔ -nʋ, we 'dɛɛ 'gbʋ a 'nɩa wee wɛlɩnya 'nʋda -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","-Slɛɛn, Zuifʋ nɛɛ: «-A -ka gba nɩɩ, Samaliyu -ɩn -mɩa, 'ɩn zuzu 'nyuu mɩ -mɩ 'wʋ, -a 'nɩ yo 'tʋbhʋ, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","-Zezu nɛɛ: «-Ɩnnya, we 'nɩ nɩɩ, zuzu 'nyuu mɩ 'mɩ 'wʋ. Nɩɩ, na Dide na zʋa -bha. Amɩa'a zʋ -bha 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɩ'ɩn 'ylimanɩ na 'dɛ, -ɔ 'yɩbhaa na 'ŋnɩ 'ylimanɩ, ɔ mɩ -bha, mɔ bhua gbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ zʋa na wɛlɩ 'nʋŋwɛ, ɔ 'na 'ka tlɩtlɩe 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zuifʋ nɛɛ: «Nɩɩ, -a -yi -slɛɛn we 'ji nɩɩ, zuzu 'nyuu mɩ -mɩ 'wʋ. Ablaamʋ -yɔ -Lagɔgbʋʋ -falɩpanya ka tlɩ. 'Ɩn -mɩ, -ɩn nɛɛ, nyɩmɛ -ɔ -ka -na wɛlɩ 'nʋŋwɛ zʋ, ɔ 'na 'ka tlɩtlɩe 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nɩɩ, -amɩaa dide Ablaamʋ ka tlɩ. 'Lee, -mɩ 'ylia -mɩ -zia -amɩaa dide Ablaamʋ yɩ? -Lagɔgbʋʋ -falɩpanya ka 'ya tlɩ. Sa -na bhu -na 'dɛ 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","-Zezu nɛɛ: «Ɩn -ka na 'dɛ 'ylimanɩ, -mʋʋ 'nɩ 'ji -ka. Nɩɩ, na Dide 'ylimanɩa na 'ŋnɩ, na Dide -ɔ ka daa a gbaa: ‹Mɔ -wa -amɩaa -Lagɔ.› ");
INSERT INTO kyf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Ɩn, a 'nɩ ɔ -yi, -amɩ -yi ɔ. Ɩn -ka gba nɩɩ, ɩn 'nɩ ɔ -yi, -zugba amɩa 'bhisa ɩn mɩa yokanyɔ nya. Nɩɩ, ɩn -yi ɔ, 'ɩn na nɔa ɔ wɛlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Mʋna ka amɩaa dide Ablaamʋ ye, nɩɩ, 'ylɩ -we nya ɩn 'kaa yi, ɔ 'ka -bha 'yɩɩ 'gbʋ. Ɔ 'yɩa wee 'ylɩ -yɔ, 'ɩn ɔ yia 'mʋna li.» ");
INSERT INTO kyf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zuifʋ nɛɛ ɔ -yla: «Aya! -Ɩn 'nɩ -slɔ -zʋ glʋ 'sɔ 'ya kugbua li, 'ɩn -ɩn yia Ablaamʋ 'yɩ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","-Zezu nɛɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: Ablaamʋ 'nɩa -slɔ 'wlʋ, -amɩ mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","-We mɩa daa 'gbʋ, wa yia gbɔkʋ labhu, wa 'ka we ɔ 'wʋbha. Nɩɩ, -Zezu zizea, 'ɩn ɔ yia -Lagɔbudu 'kadʋ zɔ 'tla. ");
INSERT INTO kyf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Da -Zezu mɩa mnɩda, nyɩmɛ yabhlo wa 'kaa gwalɩ, -ɔ 'lɔa, 'ɩn ɔ yia ɔ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","-Bha ɔ 'bɩnɔnya 'yɩbhaa ɔ laɛ: «Wlabi, nyɩmɛ mɩa dɛ nɩ, wa 'kaa ɔ gwalɩ, ɔ mɩ 'lɔda. 'Lee, mɔ nʋa gbʋnyuu lɛ yaayɩɩ, ɔ 'nyaa -yɔ ɔ dide -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Ɔmɔ klaa, ɔ 'nyaa klaa, we -yɔ ɔ dide, we 'nɩ wa gbʋnyuuu gbʋ. Nɩɩ, 'lɔ ɔ 'lɔa da nɩ, -Lagɔɔ lubho 'ka we 'dɛ -slolu ɔ gbɛgbɛɩɩn gbʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Da zlɩ mɩa -slɔ da, we mɩ nɩɩ, -ɔ tiea 'mɩ -a 'ka ɔ lubho nʋ. Nɩɩ, sabɔ mɩ yida, da nyɩmɛ yabhlogbɔɔ 'nɩa mneni ɔ 'ka lubho nʋ. ");
INSERT INTO kyf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Da ɩn mɩa -slɔ dʋdʋ -gʋ, dʋdʋgʋ -nyɩmaa zlɩ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","-Zezu bhɩa gbʋ nɩ gbagbɩe, ɔ 'paa -dlɛ dʋdʋ, ɔ nʋa plaplɩ lɛ we nya, 'mʋ ɔ tlia 'lɔlɔnyɔɔ 'yli -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'Ɩn ɔ nɛɛ: «Mnɩ budoa 'nyu -we wa laa Siloe lʋ. (Siloee ji -wa: pa yoo.) Ɔ mnɩa -mɔ, ɔ budoa wee 'nyu lʋ, ɔ 'kaa lʋyi, -zugba ɔ mɩ la 'yɩda sa 'vayɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɔ -zɔɔ -bhelia -yɔ -wa yɩa 'cɩn ɔ zlada, -maa nɛɛ: «-Ɔ mɩa da nɩ, nyɩmɛ -ɔ zladaa mɔ, we 'nɩ mɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nyɩma tɔlʋa nɛɛ: «Mɔ -wa mɔ!» Tɔlʋa nɛɛ 'ya: «-Ɩnnya, we 'nɩ ɔmɔ, ɔ 'wʋwlʋ -wa.» -Bha ɔ 'dɛ gbaɛ: «-Amɩ -wa gbʋzɔnʋ sa.» ");
INSERT INTO kyf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wa nɛɛ ɔ -yla: «Sa -na 'yli -bhlolu 'wʋlaa?» ");
INSERT INTO kyf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɔ nɛɛ: «Nyɩmɛ wa laa -Zezu, ɔ nʋa plaplɩ lɛ, 'mʋ ɔ tlia na 'yli -gʋ. 'Ɩn ɔ nɛɛ nɩɩ, ɩn mnɩ budoa Siloe lʋ. Ɩn mnɩa -mɔ, ɩn budoa, 'ɩn na 'yli yia -blo.» ");
INSERT INTO kyf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wa nɛɛ: «Da ɔɔ nyɩmɛ mɩa?» Ɔ nɛɛ: «Ɩn 'nɩ ɔ da -yi!» ");
INSERT INTO kyf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","-Slɛɛn, 'lɔlɔnyɔ -ɔ ka 'yli -Zezu -bloa, 'mɔ wa kwaa Falizɩnyɩmaa 'yu. ");
INSERT INTO kyf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nɩɩ, 'ylɩ -we nya -Zezu nʋa plaplɩ lɛ ɔ -dlɛ nya, 'ɩn ɔ yia 'lɔlɔnyɔɔ 'yli -blo nɩ, Nyapɛylɩ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","We 'dɛɛ 'gbʋ, da wa kwaa ɔɔ 'lɔlɔnyɔ Falizɩnyɩmaa 'yu, sa ɔ 'yli -blolua 'wʋla, 'ɩn -maa yi 'yaa we ɔ la 'yɩbha. Ɔ nɛɛ: «Ɔ tlia na 'yli -gʋ plaplɩ, ɩn budoa, 'ɩn ɩn yia layɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Waa Falizɩnyɩma glaa, tɔlʋa nɛɛ: «Nyɩmɛ mɩa da nɩ, ɔ 'nɩ -Lagɔɔ -gbɛ 'bhʋ, we 'dɛɛ 'gbʋ ɔ'ɔ zʋa Nyapɛylɩɩ tite 'nʋŋwɛ.» Nɩɩ, tɔlʋa nɛɛ 'ya: «Nyɩmɛ -ɔ nʋa gbʋnyuu lɛ, ɔ 'nɩ mneni ɔ 'ka 'sasʋkpa -gwɛdigbʋ lɛnʋ.» Gbʋ nɩ -gʋ wa 'nɩ wɛlɩ -bhlo -ka. ");
INSERT INTO kyf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","-Slɛɛn, wa yi 'yaa ɔɔ 'lɔlɔnyɔ layɩbhaɛ: «'Ɩn -mɩ naa, -ɔ -bloa -na 'yli, sa -na gba ɔ daa?» Ɔ nɛɛ: «-Lagɔgbʋʋ -falɩpanyɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nɩɩ, waa Zuifʋʋ 'yugalɩnya 'nɩ we -yɔŋwnu nɩɩ, ɔɔ nyɩmɛ ka zlɩmɛ 'lɔ, 'ɩn -slɛɛn, ɔ mɩ layɩda. -We mɩa da, we 'dɛɛ 'gbʋ wa yia ɔ dide -yɔ ɔ 'nyaa la. ");
INSERT INTO kyf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'Ɩn wa yia wa layɩbhaɛ: «'Lee, nyɩmɛ nɩ mɩ amɩaa 'yu nya gbʋzɔnʋ saa? A nɛɛ nɩɩ, a 'kaa ɔ gwalɩ, ɔ mɩ 'lɔdaa? Lɛɛ -lu nʋ lɛ 'ɩn ɔ yɩ -slɛɛn laa?» ");
INSERT INTO kyf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","-Maa nɛɛ: «-A -yi we 'ji nɩɩ, -amɩaa yu -wa, nɩɩ, -a 'kaa ɔ gwalɩ, ɔ mɩ 'lɔda. ");
INSERT INTO kyf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","-We nʋa lɛ 'ɩn ɔ yɩa -slɛɛn la, 'ɩn -ɔ -bloa ɔ 'yli, -a 'nɩ we -yi. A 'yɩbha ɔ 'dɛ la. Sa we 'plɩa ɔ gbɛgbɛɩn ɔ 'dɛ 'ka we gba, nɩɩ, ɔ 'nɩ 'nyɛnyɛyu.» ");
INSERT INTO kyf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɔ dide -yɔ ɔ 'nyaa mɩ Zuifʋʋ 'yugalɩnya sɔdaa 'gbʋ, wa yi 'saa gba. -Maa ka we zʋ nɩɩ, nyɩmɛ -ɔ -ka gba nɩɩ, -Zezu -wa -Lagɔɔ -Bhasanyɔ, wa 'ka ɔ -Lagɔbudu zɔ vu. ");
INSERT INTO kyf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","We 'dɛɛ 'gbʋ ɔ dide -yɔ ɔ 'nyaa nɛɛ: «Ɔ 'nɩ 'nyɛnyɛyu, a 'yɩbha ɔ 'dɛ la.» ");
INSERT INTO kyf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Falizɩnyɩma laa ɔ -zakpa 'sɔnʋ, wa nɛɛ ɔ -yla: «-Ɩn gba gbʋzɔnʋ -Lagɔ 'yu, -amɩa -yi we 'ji nɩɩ, ɔɔ nyɩmɛ mɩa, gbʋnyuu -lɛnʋnyɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɔ nɛɛ: «Ɔ -ka gbʋnyuu -lɛnʋnyɔ, ɩn 'nɩ we 'ji -yi. Gbʋ -we ɩn -yia 'ji, we -bhlogbɔɔ: ɩn ka 'lɔ, 'ɩn -slɛɛn, ɩn mɩ layɩda.» ");
INSERT INTO kyf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","-Maa nɛɛ: «Mɔɔ -lu ɔ nʋ -mɩ -yla lɛa? Sa ɔ nʋ, 'ɩn ɔ yi -na 'yli -bloa?» ");
INSERT INTO kyf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɔ 'palɩa wa wɛlɩɩ 'bɩgʋ, ɔ nɛɛ: «Ɩn ka yaa we aɩn -yla gba, 'ɩn a 'nɩ na wɛlɩ yukwli pʋlʋ, lɛɛ -lu ka 'gbʋ a 'yɩbha 'ya a ka we 'nʋa? 'Lee a 'yɩbha a 'ka ɔ 'bɩnɔnya -zɛ -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wa vɛlɩa ɔ, wa nɛɛ: «-Mɩ -wa ɔ 'bɩnɔnyɔ. -Amɩa mɩa, Moizɩɩ 'bɩnɔnya -a -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","-We ka 'ji -a -yia, mʋ -wa nɩɩ, -Lagɔ ka Moizɩ -yla gbʋ gba. 'Ɩn ɔmɔ mɩa, da ɔ bhʋlʋa, -a 'nɩ -bha da -yi.» ");
INSERT INTO kyf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɔɔ nyɩmɛ nɛɛ wa -yla: «-We sʋbhalɩa nyɩmɛ ŋwɛgaga mʋ nɩ: amɩa 'nɩ ɔ 'bhʋlʋda da -yi, 'ɩn ɔ yia na 'yli -blo! ");
INSERT INTO kyf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nɩɩ, -a -yi we 'ji nɩɩ, -Lagɔ'ɔ 'nʋ gbʋnyuu -lɛnʋnyɔɔ wɛlɩ. Nyɩmɛ -ɔ mɩa -Lagɔnyɩmɛɛ 'zayli nya, 'ɩn ɔ nʋa ɔ dʋmagbʋ lɛ, ɔ wɛlɩ -Lagɔ nʋa. ");
INSERT INTO kyf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","-A 'nɩ -slɔ 'nʋ -gba nɩɩ, nyɩmɛ wa 'kaa gwalɩ, -ɔ 'lɔa, nyɩmɛ yabhlo ka ɔ 'yli -blo. ");
INSERT INTO kyf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nyɩmɛ -ɔ nʋa gbʋ nɩ lɛ, -Lagɔɔ -gbɛ ɔ bhʋa, we 'nɩ yaa we gbʋ, ɔ 'nɩ -lu yabhlogbɔɔ mneni.» ");
INSERT INTO kyf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Waa Falizɩnyɩma nɛɛ: «We 'bhʋ -na gwalɩ bhla, -na -kpabhie mɩ gbʋnyuu lʋ. -Mɩ 'nɩ mneni -ɩn 'ka -amɩa gbʋ -slolu!» -Bha Falizɩnyɩma vua ɔ. ");
INSERT INTO kyf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nɩɩ, -Zezu ka 'nʋ nɩɩ, wa ka ɔɔ nyɩmɛ vu. Ɔ 'yɩa -mɔɔ, 'ɩn ɔ nɛɛ ɔ -yla: «'Lee -mɩ, Nyɩmɛɛ 'Yu -na zʋ dlɩ -gʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɔɔ nyɩmɛ nɛɛ: «Na -kanyɔ, nyɔɔ ɔ -mɩa? Gba we, 'ɩn ɩn 'ka ɔ dlɩ -gʋ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","-Zezu nɛɛ ɔ -yla: «'Mɔ -na yɩa da -yɔ, 'ɩn mɔ mɩa da -mɩ -yla gbada.» ");
INSERT INTO kyf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","-Bha ɔ gbaɛ: «Na -Kanyɔ, dlɩ na zʋa -mɩ -gʋ.» 'Ɩn ɔ yia ɔ bʋbɔ ɔ 'yu 'kukolu sibhlie nya. ");
INSERT INTO kyf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","We 'bɩgʋ, -Zezu nɛɛ: «-We -wa nyɩmaa -yɔgbʋ 'wʋbhubhue, -we ka 'gbʋ ɩn yia dʋdʋ -gʋ yi nɩ, mʋ -wa nɩɩ, nyɩma -wa'a 'yɩa la, wa 'ka layɩ, 'ɩn -wa yɩa la, wa 'ka 'lɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Falizɩnyɩma tɔlʋa -wa mɩa -bha, wa 'nʋa we, 'ɩn wa nɛɛ: «-Amɩa naa, 'lɔlɔnya -a -mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","-Zezu nɛɛ: «A -ka yaa 'lɔlɔnya nɩ, a 'na 'ka ya gbʋnyuu 'wlu -ka. -Slɛɛn, a nɛɛ: ‹-A yɩ la› we 'dɛɛ 'gbʋ amɩaa gbʋnyuu mɩ aɩn 'wlu.» ");
INSERT INTO kyf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Nɩɩ, ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ 'nɩa 'suoo ŋwɛɛ plalɩ, -ɔ -gblalɩa 'suoo da -putu, 'wienyɔ -yɔ nyɩmɛ 'nyuu ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nɩɩ, nyɩmɛ -ɔ plalɩa 'suoo ŋwɛɛ, mɔ -wa bhlabhlɛɛ 'yliyɔzʋnyɔ. ");
INSERT INTO kyf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'Ɩn bhlabhlɛɛ 'suoo ŋwɛkʋnyɔ kalɩa klolo ɔ -yla, 'ɩn bhlabhlɛ nʋa we 'yliyɔzʋnyɔɔ wɛlɩ. Bhlabhlɛ -mʋʋ -ka -mɩ, we 'ŋnɩ -yɔ ɔ lalɩa we, 'ɩn ɔ kwaa wee bhlabhlɛnya 'pipee. ");
INSERT INTO kyf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɔ -ka we 'dɛ weee wleli, 'ɩn ɔ nɔa we 'yu. Ɔ mɩ -slɛɛn we 'yu, 'ɩn we nɔa ɔ 'bɩ, -we ka gbʋ -wa, we -yi ɔ wɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","We'e nɔ nyɩmɛ -putu 'bɩ. Nɩɩ, kwɛɛ we gwaa ɔ, we 'nɩ ɔ wɛlɩ -yii 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gbʋʋ nine ɔ 'paa da -zugba ɔ mɩ gbada, nyɩma 'nɩ we 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","-Bha -Zezu gba 'yaɛ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, -amɩ -wa bhlabhlɛɛ 'suoo ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɩn 'nɩa -slɔ yi, -wa weee yia, 'wienya wa -mɩa, 'ɩn wa mɩa nyɩma 'nyii nya. Nɩɩ, bhlabhlɛ 'nɩ wa wɛlɩ 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Ɩn bhlabhlɛɛ 'suoo ŋwɛɛ mɩa, -amɩ -wa. Nɩɩ, nyɩmɛ -ɔ -ka na -gbɛ plalɩ, 'ɩn ɔ bhʋa gbʋ 'wʋ. Wee 'suoo ŋwɛɛ ɔ yia plalɩa, 'ɩn -bha ɔ yia 'tlalɩa 'bhie, ɔ 'ka lililu 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'Wienyɔ mɩa, ɔ -ka yi nɩ, 'wie klaa, 'bhabhɩe klaa, we -yɔ lasasɩe, we 'gbʋ ɔ yia. -Amɩ mɩa, nyɩma 'ka 'yliyɔgagɩe 'yɩɩ 'gbʋ ɩn yia yi. 'Ɩn wee 'yliyɔgagɩe mɩa, wa 'ka we 'yɩ duun. ");
INSERT INTO kyf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Nɩɩ, -amɩ -wa bhlabhlɛɛ 'yliyɔzʋnyɔ -zɔnʋ. Bhlabhlɛɛ 'yliyɔzʋnyɔ -zɔnʋ mɩa, ɔ 'dɛɛ 'yliyɔgagɩe ɔ saa dlɩ -gʋ ɔ bhlabhlɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nɩɩ, lubhonʋnyɔ -ɔ 'nɩa bhlabhlɛɛ 'yliyɔzʋnyɔ, 'ɩn bhlabhlɛ 'nɩa ɔ -nʋ, -fliigwɩ -ka yida -mɩ, ɔ -ka we -yɔyɩ, 'ɩn ɔ tɩa -bha wee bhlabhlɛ -gwagwɩe nya. We -ka bhlabhlɛ tɔlʋa kpa, 'ɩn we pnɩɩ mumnia la. ");
INSERT INTO kyf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","-We ka gbʋ -wa, lubhonʋnyɔ -ɔ mɩa 'gwɛzii datalɩda, ɔ'ɔ sɩalɩ ɔ 'dɛ bhlabhlɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nɩɩ, -amɩ -wa bhlabhlɛɛ 'yliyɔzʋnyɔ -zɔnʋ. Sa ɩn -yia na bhlabhlɛ, 'ɩn na bhlabhlɛ -yia 'mɩ nɩ, ");
INSERT INTO kyf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","'sa Dide -yia 'mɩ, 'ɩn, ɩn -yia na Dide. 'Ɩn na palɩa na 'yliyɔgagɩe la na bhlabhlɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bhlabhlɛ tɔlʋa ɩn kaa, -mʋmʋnya mɩa da suo nɩ 'wʋ, we 'nɩ -slɔ -mʋʋ glaa -mɩ. We mɩ nɩɩ, ɩn gʋgwlalɩ we 'wlu. Na wɛlɩ we yia 'nʋa, 'ɩn we 'dɛ weee 'ka -zlo -bhlo -we kaa 'yliyɔzʋnyɔ -bhlo -zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Nɩɩ, na Dide -kalɩ na zɛ. -We ka gbʋ -wa, ɩn ka na 'yliyɔgagɩe lapalɩ. 'Ɩn 'wʋ na yia we 'bhua. ");
INSERT INTO kyf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wee na 'yliyɔgagɩe mɩa, nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka 'mɩ we kwɛɛ -sa, na dlɩɩ da ɩn palɩa we la. Ɩn ka we se ɩn 'ka we lapalɩ, 'ɩn, ɩn ka we se ɩn 'ka 'ya we 'wʋbhu. Tite na Dide tɩa 'mɩ -yɔ, mʋ mɩa dɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","-Zezuu wɛlɩ nɩ sɩsalɩa Zuifʋ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wa glaa, nyɩma duun nɛɛ: «Zuzu 'nyuu mɩ ɔ 'wʋ, -sabhɛ mɩ ɔ 'bhada, lɛɛ -lu ka 'gbʋ a pʋlʋ ɔ yukwlia?» ");
INSERT INTO kyf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tɔlʋa nɛɛ: «Wɛlɩ -we ɔ gbaa dɛ nɩ, Zuzu 'nyuuu 'wʋmɩnyɔɔ wɛlɩ 'nɩ 'sa -mɩ. 'Lee, zuzu 'nyuu mneni we 'ka 'lɔlɔnyɔɔ 'yli -bloo?» ");
INSERT INTO kyf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nɩɩ, -Lagɔbudu 'kadʋʋ -kalɩylɩɩ 'fɛtɩ ka nyni -Zeluzalɛmʋ. -Zʋo -zʋ, -sa wa saa we. 'Ɩn, ŋwɔtlɔyibhla -wa. ");
INSERT INTO kyf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","-Lagɔbudu 'kadʋ ŋwɛɛ, da wa laa Salomɔɔɔ palʋ 'kadʋ, we bhʋnya -yɔ -Zezu mɩa -zieda. ");
INSERT INTO kyf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","-Slɛɛn, Zuifʋ gbelia ɔ, 'ɩn wa nɛɛ: «Lɛbhla -ɩn 'ka -amɩaa dlɩ yalɩ -saa? Nɩɩ, -mɩ, ɩn -ka -Lagɔɔ -Bhasanyɔ, gba we -aɩn -yla sa 'vayɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","-Zezu nɛɛ wa -ylaɛ: «Ɩn ka we aɩn -yla gba, 'ɩn a 'nɩ we dlɩ -gʋ zʋ. Nɩɩ, gbʋ na nʋa lɛ na Didee 'ŋnɩ nya, mʋ -wa na gbʋdayɩnya. ");
INSERT INTO kyf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nɩɩ, a 'nɩ na bhlabhlɛ glaa -mɩ, we 'dɛɛ 'gbʋ a'a zʋa 'mɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na bhlabhlɛ mɩa, na wɛlɩ we nʋa. -Amɩ -yi we, 'ɩn we nɔa 'mɩ 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ na nyɛa we. We 'na 'ka labhʋ -bhlɔkɔɔ -gba, 'ɩn nyɩmɛ yabhlogbɔɔ 'na 'ka 'mɩ we kwɛɛ -sa. ");
INSERT INTO kyf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Dide -ɔ 'nyɛa 'mɩ we yoo, ɔ 'yli ɔ -zi -lu weee. 'Bhie, nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka we na Dide kwɛɛ -sa. ");
INSERT INTO kyf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","-Amɩ -yɔ na Dide 'sɔ, -a -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","-Bha, Zuifʋ 'bhu 'yaa gbɔkʋ la wa 'ka we ɔ 'wʋbha. ");
INSERT INTO kyf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","We 'dɛɛ 'gbʋ -Zezu nɛɛ wa -ylaɛ: «Libho -zɔnʋʋ -zlo, -we 'bhʋa na Didee -gbɛ, ɩn nʋa lɛ amɩaa 'yibadɩ, a 'yɩa -yɔ, we glaa, -mʋmʋ ka 'gbʋ a 'ka 'mɩ 'bha gbɔkʋ nyaa?» ");
INSERT INTO kyf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zuifʋ nɛɛ ɔ -yla: «We 'nɩ lubho -zɔnʋʋ 'gbʋ -a 'yɩbha -a 'ka -mɩ 'bha gbɔkʋ nya, nɩɩ, -Lagɔ -ɩn vɛlɩa, we gbʋ -wa. Nɩɩ, nyɩmɛ -ɩn -mɩa, 'ɩn -na bhua -na 'dɛ 'wʋ -Lagɔ 'bhisa!» ");
INSERT INTO kyf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","-Zezu nɛɛ: «We mɩ cɛlɩda amɩaa tite 'wʋ nɩɩ, -Lagɔ nɛɛ: ‹-lagɔnya a -mɩa.› ");
INSERT INTO kyf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","-A -yi we 'ji nɩɩ, -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, nyɩmɛ 'nɩ mneni ɔ 'ka we lasa. -Wa ka -nʋ nya -Lagɔwɛlɩ mɩa cɛlɩda, ɔ -ka -maa la ‹-lagɔnya› nɩ, 'ɩn -amɩ, -Lagɔ -ka -bha 'mɩ -sa, 'ɩn ɔ -ka 'mɩ tie dʋdʋ -gʋ nɩ, 'lee, sa a mneni a 'ka gba nɩɩ, ɩn ka -Lagɔ vɛlɩa, nɩɩ, ɩn nɛɛ ɩn mɩ -Lagɔɔ 'Yu nyaa 'gbʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɩɩ, ɩn 'nɩ na Didee lubho nʋ nɩ, a 'na zʋlʋ 'mɩ dlɩ -gʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nɩɩ, ɩn -ka we lɛnʋ nɩ, 'ɩn a 'nɩ yaa 'mɩ dlɩ -gʋ zʋa yioo, wee libho -zɔnʋ mɩa, a zʋ we dlɩ -gʋ. 'Ɩn a 'ka we 'jiyibheli 'nanʋʋ nɩɩ, Dide mɩ 'mɩ 'wʋ, 'ɩn ɩn mɩ ɔ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wee gbʋ nɩɩ 'gbʋ, wa 'yɩbha 'ya wa 'ka ɔ kpa, 'ɩn ɔ yia wa kwɛɛ 'tla. ");
INSERT INTO kyf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","-Slɛɛn, -Zezu yia Zudɛɛn nyuu -kakpe yabhlo -gʋ mnɩ. Da Zaan batizee bhaa nyɩma, -bha ɔ -dɩa la. ");
INSERT INTO kyf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nyɩma duun yia ɔ -gbɛ, wa nɛɛ: «Zaan 'nɩ gwɛdigbʋ yabhlogbɔɔ lɛnʋ, nɩɩ, -we weee ɔ gbaa nyɩmɛ nɩɩ daa, we mɩ gbʋzɔnʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","-We mɩa nɩ -gʋ, nyɩma duun zʋa ɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Nɩɩ, nyɩmɛ yabhlo wa laa -Lazalɩ, ɔ -zɔɔ -wa Betani. Malii -yɔ Maatɩ 'sɔ mɩ 'ya Betani, ɔ bhɔlɔa wa -mɩa. (Malii -ɔ 'kaa Nyɩmaa -Kanyɔ *-lasiklɔ bhʋ -yɔ tli, 'ɩn ɔ 'kaa we -yɔsɛ ɔ 'dɛɛ 'nyi nya nɩ, ɔɔ Malii -wa.) Nɩɩ, 'ylɩ yabhlo nya, 'ɩn -Lazalɩ yia gu bhli. ");
INSERT INTO kyf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","We 'dɛɛ 'gbʋ, ɔ bhɔlɔa yia nyɩmɛ tie, wa 'ka -Zezu la. Ɔ mnɩa -Zezuu -gbɛ, 'ɩn ɔ nɛɛ: «Na -Kanyɔ, -na jijli -tale ka gu -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Da -Zezu 'nʋa we, ɔ nɛɛ: «Nɩɩ, gu -we yia -Lazalɩ -yɔ, we 'nɩ ɔ 'bhabhɩee 'gbʋ we yi ɔ -yɔyi, we 'ka -Lagɔɔ 'ŋnɩmnɩee 'tɩtɛ -sloluu gbʋ -wa. -Bha wa yia -Lagɔɔ 'Yuu 'ŋnɩ -mnɩnɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nɩɩ, -Zezu 'nɩ Maatɩ klaa, ɔ bhɔlɔ klaa, we -yɔ -Lazalɩɩ zɛkalɩ -sɛ. ");
INSERT INTO kyf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'Ɩn ɔ 'nʋa nɩɩ, -Lazalɩ ka gu -yɔ, wa laa ɔ, ɔ 'nɩ -mɔ mnɩ. Da ɔ mɩa, ɔ li -bha 'ylɩ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Ɩn ɔ nɛɛ ɔ 'bɩnɔnya -yla: «-A mnɩ Zudee lʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɔ 'bɩnɔnya nɛɛ: «*Wlabi, daylɩda, Zuifʋ 'yɩbha wa 'ka -mɩ 'bha gbɔkʋ nya, 'ɩn -na gbaa -ɩn 'ka -mɔ lʋmnɩ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɔ nɛɛ: «We bhlili zlɩgʋ, jibhe 'ka zɔ, mʋ -wa 'ylɩɩ zlɩ. Nyɩmɛ -ɔ nɔa zlɩ, ɔ'ɔ gozo, -we ka gbʋ -wa, zlɩɩ san mɩ -bha. ");
INSERT INTO kyf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nɩɩ, we -ka sabɔ ɔ nɔ, 'ɩn ɔ gozoa, -we ka gbʋ -wa, san 'nɩ -bha -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wɛlɩnya nɩɩ 'bɩgʋ, ɔ nɛɛ: «-Amɩaa 'tale -Lazalɩ ka 'ylaa ŋwɔ, nɩɩ, mnɩda ɩn mɩa ɩn 'ka ɔ ganɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ɔ 'bɩnɔnya nɛɛ ɔ -yla: «-Amɩaa -Kanyɔ, we -ka 'ylaa ɔ ŋwɔ, 'pʋa ɔ yia.» ");
INSERT INTO kyf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","-We -Zezu 'yɩbhaa ɔ 'ka gba, mʋ -wa nɩɩ, -Lazalɩ ka tlɩ. Nɩɩ, ɔ 'bɩnɔnya nɛɛ 'sa nɩɩ, 'ylaa 'dɛbhie ɔ saa 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","-Bha -Zezu gbaa wa -yla sa tɩklɩɩɛ: «-Lazalɩ ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nɩɩ, ɔ ka tlɩ, 'ɩn ɩn 'nɩ -mɔ -mɩ, we 'dɛɛ 'gbʋ na lia 'mʋna amɩaa daa. 'Ɩn, a 'ka 'mɩ dlɩ -gʋ zʋʋ gbʋ -wa. Nɩɩ, -a mnɩ ɔ -gbɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","-We mɩa nɩ -gʋ, Toma wa laa -Zluya nɛɛ -Zezuu 'bɩnɔnya tɔlʋa -yla: «-A -yɔ ɔ 'sɔ mnɩ, 'ɩn -a 'ka dabhlo tlɩlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nɩɩ, da -Zezu mnɩa -mɔ, 'ɩn ɔ yia 'nʋ nɩɩ, wa ka -Lazalɩɩ 'kwie gbawla 'wʋfa, we li 'ylɩ -mnʋa. ");
INSERT INTO kyf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nɩɩ, Betani mɩ -Zeluzalɛmʋ kwesi, we nyɩdɩ mneni we 'ka kilomɛtlɩ ta nyni. ");
INSERT INTO kyf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","We 'dɛɛ 'gbʋ Zuifʋ duun yia Maatɩ -yɔ Malii -gbɛ yi, wa 'ka wa 'yuo 'pa wa bhelii tlɩtlɩee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Da Maatɩ 'nʋa nɩɩ, -Zezu mɩ yida, 'ɩn ɔ yia ɔ yoo -saa mnɩ, -zugba Malii -mɔɔ -dɩ -budu zɔ la. ");
INSERT INTO kyf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maatɩ -yɔ ɔ gbelia 'wʋ, 'ɩn ɔ nɛɛ ɔ -yla: «Na -Kanyɔ, nɩɩ, -ɩn -ka yaa -seli -mɩ, na bheli 'na 'ka yaa tlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nɩɩ, ɩn -yi -slɛɛn we 'ji nɩɩ, -we -na yia -Lagɔ -zlalɩa, 'nyɛa ɔ yia -mɩ we.» ");
INSERT INTO kyf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ɔ nɛɛ ɔ -yla: «'Wʋ amaa bheli yia -sɔa.» ");
INSERT INTO kyf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","-Mɔɔ nɛɛ: «Ɩn -yi we 'ji nɩɩ, dʋdʋʋ bhɩa zlɩ mɩa, ɔ -yɔ tlɩtlɩnya yia 'wʋsɔa.» ");
INSERT INTO kyf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","-Zezu nɛɛ ɔ -yla: «Tlɩtlɩnyaa 'wʋsɔlʋnyɔ mɩa, -amɩ -wa, 'ɩn -ɔ nyɛa nyɩma 'yliyɔgagɩe, -amɩ -wa. Nyɩmɛ -ɔ -ka 'mɩ dlɩ -gʋ zʋ, ɔ 'dɛ yi tlɩoo, 'yliyɔ ɔ yia -gaa. ");
INSERT INTO kyf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'Ɩn nyɩmɛ -ɔ -gaa 'yliyɔ, 'ɩn -ɔ zʋa 'mɩ dlɩ -gʋ, ɔ 'na 'ka tlɩ. -We ɩn gbaa dɛ, 'lee, a zʋ we dlɩ -gʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɔ nɛɛ: «Ɩɩn, na -Kanyɔ, ɩn ka we dlɩ -gʋ zʋ nɩɩ, -ɩn mɩ -Lagɔɔ -Bhasanyɔ nya, 'ɩn -ɩn mɩ -Lagɔɔ 'Yu -ɔ 'kaa dʋdʋ -gʋ yi nya.» ");
INSERT INTO kyf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wɛlɩ nɩ -gʋ ɔ mnɩa ɔ bhɔlɔ Malii laa, 'ɩn ɔ yia ɔ ŋwuŋweniɛ: «-Amɩaa -Slolunyɔ mɩ da, ɔ nɛɛ a mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malii 'nʋa we, -bha ɔ -sɔa 'wʋ sa slʋɩ, 'ɩn ɔ yia ɔ -gbɛ mnɩ, ");
INSERT INTO kyf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","-zugba -Zezu 'nɩ -slɔ wee -zɔɔ pla, da Maatɩ tɩa ɔ, -bha ɔ mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zuifʋ tɔlʋa -yɔ Malii -dɩ -mɔ -budu zɔ la, -zugba wa pa ɔ 'yuo. Malii -sɔa 'wʋ sa slʋɩ, ɔ 'tlaa, wa 'yɩa ɔ -yɔ, 'ɩn wa yia yɩylalɩ, 'ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩ nɩɩ, gbawla -gʋ ɔ mnɩa ɔ 'ka -mɔ wili, -bha wa mnɩa ɔ 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Da -Zezu mɩa, Malii nynia -bha, ɔ 'yɩa ɔ -yɔ, 'ɩn ɔ yia ɔ bhʋ -yɔ bhlili, -bha ɔ gbaɛ: «Na -Kanyɔ, -ɩn 'ka yaa -seli -mɩ nɩ, na bheli 'na 'ka yaa tlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Da -Zezu 'yɩa ɔ wida, 'ɩn Zuifʋnya -wa -laa ɔ yoo, -maa mɩ 'yaa wida, -bha -gbagbɩ sloa ɔ 'wʋ, 'ɩn ɔ dlɩ yia sumanɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ɔ nɛɛ: «Da a zʋ ɔ 'kwiea?» Wa nɛɛ: «-Amɩaa -Kanyɔ, -ɩn yi -ɩn 'ka -bha 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","-Bha -Zezu wia. ");
INSERT INTO kyf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'Ɩn Zuifʋ nɛɛ: «A -talɩ, ɔ 'nɩ ɔ zɛkalɩ -sɛ!» ");
INSERT INTO kyf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nɩɩ, wa glaa nyɩma tɔlʋa nɛɛ: «Nyɩmɛ -ɔ -bloa 'lɔlɔnyaa 'yli, lɛɛ -lu ka 'gbʋ ɔ 'nɩ mneni ɔ 'ka yaa -Lazalɩɩ tlɩtlɩe 'yoo -kʋlʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Ya -bhlokpadɛ, -gbagbɩ sloa -Zezuu kuzɔ, 'ɩn ɔ yia gbawla -gʋ mnɩ. Nɩɩ, wee gbawla mɩa, tʋkpaa gbacɩzɔ we mɩa, 'ɩn tʋkpa -boklo 'kadʋ mɩa we ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ɔ nɛɛ: «A -sa -bha wee tʋkpa.» 'Ɩn -ɔ tlɩa, ɔ bhɔlɔ Maatɩ nɛɛ: «Na -Kanyɔ, ɔ 'nɩ -bha ŋnɛ 'pa -slɛɛn? Ɔ tlɩa, we 'ylɩ -mnʋanʋ nɩ -zɛɛn.» ");
INSERT INTO kyf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nɩɩ, -Zezu nɛɛ ɔ -yla: «'Lee, ɩn 'nɩ aɩn -yla gba nɩɩ, a -ka 'mɩ dlɩ -gʋ zʋ, 'ɩn a yɩa -Lagɔɔ 'ŋnɩmnɩe -yɔɔ?» ");
INSERT INTO kyf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","-Bha wa -saa -bha tʋkpa. -Zezu 'bhua 'klʋ 'wʋ yalɩ, ɔ nɛɛ: «Dide, -Mɩ na paa fuo, -we ka gbʋ -wa, -ɩn ka na wɛlɩ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɩɩ, ɩn -yi we 'ji nɩɩ, 'wʋ -na ŋwnua na wɛlɩ 'ylɩ weee nya. Gbʋzɔnʋ mʋ, nyɩma duun -wa gbelia da 'mɩɩ 'gbʋ na gbaa we, wa 'ka dlɩ zʋ nɩɩ, -mɩ tiea 'mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɔ gbaa wɛlɩ nɩ, 'ɩn ɔ nɛɛ wɛlɩ 'tɩtɛ nyaɛ: «-Lazalɩ, 'tla -mɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","-Lazalɩ, -ɔ tlɩ yaa, ɔ 'tlaa -mɔ, -zugba ɔ bhʋ -yɔ ɔ sɔnya mɩ gbʋanda 'naa kibhe nya. 'Naa mɩ ɔ 'klʋ -yɔ bibeda. -Bha -Zezu gbaa nyɩma -yla: «-We weee mɩa dɛ ɔ -yɔ, a -blo we, a 'tide ɔ 'yi, ɔ 'ka mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zuifʋnya -wa yia Malii -gbɛ, 'ɩn -we -Zezu nʋa lɛ, -wa 'yɩa we -yɔ, wa glaa, nyɩma duun yia ɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nɩɩ, tɔlʋa mnɩa Falizɩnyɩmaa -gbɛ, -we -Zezu nʋa lɛ, 'ɩn wa yia -maa 'dɩ -salɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","-Bha -Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma laa wa -lima gbʋwʋbhunya wa 'dɛ weee 'ka 'wlugbeli, 'ɩn wa nɛɛ: «Nyɩmɛ nɩ mɩ gwɛdigbʋ duun lɛnʋda, 'lee, sa -a 'ka ɔ nʋa? ");
INSERT INTO kyf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nɩɩ, -a -ka ɔ 'yitide, ɔ -yɔ we lɛnʋe 'ka mnɩda -mɩ, 'ɩn nyɩma weee zʋa ɔ dlɩ -gʋ. Wa -ka ɔ dlɩ -gʋ zʋ, 'ɩn *Wlɔmʋ -nyɩmaa 'wlulapɩlɩnya yia, 'ɩn wa saa -amɩaa bʋbɔlʋda -yɔ -amɩaa klu la.» ");
INSERT INTO kyf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Waa Zuifʋ glaa, yabhlo mɩ -bha, 'mɔ wa laa Kaifʋ. *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ ɔ -mɩa wee -zʋ nɩ nya. Ɔ nɛɛ: «A'a 'nʋ -lu yabhlogbɔɔ 'wʋla! ");
INSERT INTO kyf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","We 'dɛɛ 'gbʋ a pʋpalɩ 'wlukʋʋn la 'nanʋʋ! We nanɩ 'yli amɩaa -nʋ nya nɩɩ, nyɩmɛ -bhlo tlɩ -amɩaa kluu 'gbʋ. -A -ka 'sa nʋ, -Zuifʋ weee 'na 'ka labhʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nɩɩ, wɛlɩ -we Kaifʋ gbaa, we 'nɩ ɔ 'dɛɛ -gbɛ 'bhʋ. Nɩɩ, wee -zʋ nɩ nya, mɔ -wa -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ. -Bha -Lagɔ zʋa ɔ wɛlɩ ŋwɛɛ, 'ɩn ɔ nɛɛ nɩɩ, -Zezu yia tlɩa Zuifʋ weee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","We 'nɩ Zuifʋ -bhlogbɔɔ 'gbʋ ɔ 'ka tlɩ, nɩɩ, -Lagɔɔ 'yua weee mɩa dʋdʋ weee -gʋ, ɔ 'ka wa 'wlugʋgwlalɩ, 'ɩn ɔ 'ka wa nyɩma -bhlo -zɛlɩɩ gbʋ -wa 'ya. ");
INSERT INTO kyf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nɩɩ, we 'bhʋ wee 'ylɩ 'wʋ, -bha Zuifʋʋ 'yugalɩnya pʋpalɩa -slɛɛn gbʋ nɩɩ, wa 'ka -Zezu 'bha. ");
INSERT INTO kyf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","-We mɩa 'dɛɛ 'gbʋ, ɔ'ɔ -zie -slɛɛn Zuifʋ glaa zlɩ 'klʋ. Nɩɩ, 'gbe -we wa laa Eflaimʋ, -we mɩa -mɔ da bɛblɛɛ, -mɔ ɔ mnɩa, 'ɩn ɔ -yɔ ɔ 'bɩnɔnya 'sɔ yia -mɔ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zuifʋʋ *'Wʋzɩtɩylɩɩ 'fɛtɩ ka cɩpa. Wee 'fɛtɩ 'nɩ -slɔ nyni, 'ɩn nyɩma duun yia da weee 'bhʋ, 'ɩn wa yia -Zeluzalɛmʋ yi. Nɩɩ, wa 'ka wa 'dɛ lamnazɩlɩ, 'ɩn wa 'ka -mɔwlʋ, wa 'ka wee 'fɛtɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wa mɩ -mɔ -Lagɔbudu 'kadʋ zɔ, -zugba wa talɩa -Zezuu da, 'ɩn wa gbʋgbalɩ -ylaɛ: «'Lee, nyɩmɛ nɩ 'nɩa fɛtɩ 'wʋ yia yi -wa yɩ? Sa amɩa yɩ wea?» ");
INSERT INTO kyf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","-Slɛɛn, -Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma zʋa gbʋ, 'mʋ wa gbaa nyɩma -yla: «Nɩɩ, nyɩmɛ -ɔ -ka -Zezu da -yi, ɔ yi ɔ 'ka we gba, 'ɩn wa 'ka ɔ kpa.» ");
INSERT INTO kyf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nɩɩ, we -tʋ 'wʋ 'ylɩ gbelibhlo, 'ɩn 'Wʋzɩtɩylɩɩ 'fɛtɩ 'ka nyni. -Bha -Zezu -sɔa 'wʋ, 'ɩn ɔ yia Betani mnɩ. Wee Betani -Lazalɩ mɩa, nyɩmɛ -ɔ -Zezu -sɔlʋa zlɩmɛ tlɩtlɩnya glaa 'wʋ, mɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","-Bha wa pia ɔ -yla, 'ɩn Maatɩ mɩa we dlilida. -Wa -yɔ -Zezu 'sɔ mɩa lida, ɔɔ -Lazalɩ mɩ wa glaa. ");
INSERT INTO kyf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wa mɩ lida nɩ, Malii bɛa -Zezu -yɔ, -lasiklɔ -zɔnʋʋ litlɩ -kibhe -we ka -valɛ 'tɛa, ɔ 'bhua we 'wʋ, ɔ tlia we -mɔɔ bhʋ -yɔ, 'ɩn ɔ yia we -yɔsɛ ɔ 'nyi nya. 'Ɩn wee -lasiklɔɔ ŋnɛ yia -budu zɔ ye. ");
INSERT INTO kyf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nɩɩ, -Zezuu 'bɩnɔnyɔ yabhlo wa laa Zudasɩ Isɩkaliɔtʋ, -ɔ 'kaa cɩ ɔ wla, ɔ 'bhua gbʋ 'wʋ, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«-Lasiklɔ nɩɩ -valɛ 'tɛ, we -valɛ mneni we 'ka lubhonʋnyɔɔ -zʋ -bhloo 'pɛnɩgwɛzi nyni. Lɛɛ -lu ka 'gbʋ -a 'nɩ we pɛlʋ 'pa -a 'ka we 'gwɛzi bobabhanya 'nyɛa?» ");
INSERT INTO kyf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","-We ɔ gbaa da nɩ, we 'nɩ nɩɩ, bobabhanyaa daa ɔ ka nyazɩdlɩ, nɩɩ, 'wienyɔ ɔ -mɩaa gbʋ -wa. Nɩɩ, 'gwɛzii lazʋnyɔ ɔ -mɩa, 'ylɩ weee nya -zugba ɔ sa -bha zizewiemɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Ɩn -Zezu nɛɛ ɔ -ylaɛ: «'Bhʋ ɔ -yɔ! Nɩɩ, -we ɔ tlia da 'mɩ -yɔ nɩ, na ku ɔ mnazɩa la zlɩ wa 'kaa 'mɩ gbawla 'wʋ fa, we 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bobabhanya mɩa nɩ, -maa -yɔ aɩn 'sɔ mɩ 'ylɩ weee nya. Nɩɩ, -amɩ mɩa nɩ, ɩn 'na 'ka aɩn glaa -tʋ 'ylɩ weee nya.» ");
INSERT INTO kyf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuifʋʋ -zlo 'nʋa nɩɩ, -Zezu mɩ Betani, 'ɩn wa yia -mɔ mnɩ. -We ka 'gbʋ wa yia -mɔ mnɩ nɩ, we 'nɩ ɔ 'dɛbhloo gbʋ, nɩɩ, wa 'yɩbha 'ya wa 'ka -Lazalɩ 'yɩ, -ɔ ɔ -sɔlʋa tlɩtlɩnya glaa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","We 'dɛɛ 'gbʋ -Lagɔbʋbɔnyaa -cɩan yi 'yaa -Lazalɩɩ 'bhabhɩe pʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nɩɩ, nyɩmaa -zlo mɩ wa -gbɛ 'bhʋda ɔ 'gbʋ, -zugba wa zʋ -Zezu dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zlɩ zlɩa, nyɩmaa -zlo, -wa yia 'fɛtɩ nɩ -gʋ, wa 'nʋa nɩɩ, -Zezu mɩ -Zeluzalɛmʋ yida, ");
INSERT INTO kyf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","wa 'tlaa wee 'gbe 'wʋ, yoo wa mnɩa ɔ -saa saʋn nya kwɛɛ. Wa 'kpɩa 'wʋ, wa nɛɛ: «-A -mnɩnɩ -Lagɔɔ 'ŋnɩ! -Ɔ mɩa Jejitapɛɛ 'ŋnɩ nya yida, -Lagɔ ŋwna ɔ 'nyu la. -Lagɔ ŋwna Izlaɛlɩnyɩmaa 'Wlulapɩlɩnyɔ 'nyu la.» ");
INSERT INTO kyf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","-Zezu 'yɩa -sokofalɩ -dɔgbʋ, 'ɩn ɔ yia we -gʋ -gbla, 'sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ");
INSERT INTO kyf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«A 'na nʋnʋ nyanɔ -nɩ, *Siɔn -gbe! A -talɩ, amaa 'wlulapɩlɩnyɔ mɩ yida! Ɔ -dɩ -sokofalɩ -dɔgbʋ -gʋ la.» ");
INSERT INTO kyf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","We gwedɩda, -we mɩa 'plɩda, ɔ 'bɩnɔnya 'nɩ -slɔ we 'wʋla 'nʋ. Nɩɩ, -Zezu -ka -slɛɛn ɔ 'ŋnɩylilo 'yɩ 'bhie, wa dlɩ bhlilia -bha nɩɩ, -we weee mɩa dɛ nɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋ, 'ɩn ɔ -gʋgbʋ we gbaa. ");
INSERT INTO kyf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nyɩmaa -zlo, -wa -yɔ -Zezu 'sɔ mɩa gbawla ŋwɛɛ, da ɔ gbaɛ: «-Lazalɩ, 'tla -mɔ», 'ɩn ɔ yia ɔ 'wʋsɔlʋ tlɩtlɩnya glaa, -we wa 'yɩa -yɔ, wa mɩ we 'dɩ -sada. ");
INSERT INTO kyf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","We 'dɛɛ 'gbʋ nyɩmaa -zlo ka -Zezu yoo -saa yi. Nɩɩ, wa ka 'nʋ nɩɩ, ɔ ka wee gwɛdigbʋ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tɔʋn, Falizɩnyɩma nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «'Lee, a 'nɩ mneni a 'ka -lu yabhlogbɔɔ lɛnʋʋ? Mʋ mɩa dɛ, nyɩma weee mɩ ɔ 'bɩbholuda!» ");
INSERT INTO kyf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nɩɩ, Glɛkɩ tɔlʋa yia -Zeluzalɛmʋ wa 'ka -Lagɔ bʋbɔ 'fɛtɩɩ bhla. ");
INSERT INTO kyf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ma yia Filipʋʋ -gbɛ, -Zezuu 'bɩnɔnyɔ -ɔ 'bhʋa Bɛtɩsaida, Galilee -dʋdʋ -gʋ, mɔ -wa. 'Ɩn wa nɛɛ ɔ -ylaɛ: «-Na zukpa -wa, -a 'yɩbha -a 'ka -Zezu 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipʋ gbaa we Andlee -yla, 'ɩn -mʋʋ 'bɩgʋ, wa 'dɛsɔbhie yia we -Zezu -yla gbaa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ɔ nɛɛ: «-Slɛɛn, we bhla ka nyni, bhla -we nya -Lagɔ 'kaa *Nyɩmɛɛ 'Yuu 'ŋnɩ 'ylimanɩ, we ka nyni. ");
INSERT INTO kyf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɩɩ, bleya -we bhlia dʋdʋ, tlɩ we tlɩa, we 'nɩ -mʋʋ, 'ɩn we tʋa 'wʋ -bhlo. We -ka tlɩ nɩ, 'ɩn we wlaa 'yaa -zlo. ");
INSERT INTO kyf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ -ka ɔ 'yliyɔgagɩe 'yɩbha, kwɛɛ we yia ɔ 'tlaa. Nɩɩ, nyɩmɛ -ɔ nyɛa ɔ 'yliyɔgagɩe 'wʋ dʋdʋ nɩ -gʋ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, mʋ yia ɔ -nʋ nya -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","-Ɔ -ka gba ɔ 'ka na lubho nʋ, ɔ nɔ 'mɩ 'bɩ, 'ɩn da ɩn -ka -mɩ, na lubhonʋnyɔ mɩ 'ya -bha. Nyɩmɛ -ɔ -ka na lubho nʋ nɩ, na Dide yia ɔ -bha zʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«-Slɛɛn, na dlɩ ka sumanɩ bhabha. 'Lee, sa ɩn 'ka gbaa? 'Sa ɩn 'kaa gba: ‹Dide, -ɩn -sa 'mɩ sɩasɩa bhla nɩ 'wʋ yɩ?› -Ɩnnya! Nɩɩ, we 'dɛɛ 'gbʋ ɩn yia yi. ");
INSERT INTO kyf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dide, 'ylimanɩ -na 'dɛɛ 'ŋnɩ!» Wɛlɩ yabhlo 'bhʋa yalɩ, we nɛɛ: «Ɩn ka we 'ylimanɩ pepe, 'ɩn 'ylimanɩa na yia we lʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nyɩmaa -zlo -wa mɩa -bha, 'ɩn -wa 'nʋa wee wɛlɩ, wa nɛɛ: «Dɛɛ -gangan -jiji -wa!» Tɔlʋa nɛɛ: «'Anzɩ ka ɔ -yla gba!» ");
INSERT INTO kyf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","-Zezu nɛɛ wa -ylaɛ: «We 'nɩ na 'dɛɛ 'gbʋ wɛlɩ nɩ yi gba, nɩɩ, amɩaa gbʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bhla -we nya -Lagɔ 'kaa dʋdʋgʋ -nyɩmaa -yɔgbʋ 'wʋbhu, we bhla ka nyni. 'Ɩn bhla -we nya ɔ 'kaa dʋdʋgʋ -nyɩmaa 'yugalɩnyɔ 'nyuu vu, we bhla ka nyni. ");
INSERT INTO kyf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","«'Ɩn -amɩ mɩa, wa -ka 'mɩ 'wʋsɔlʋ dʋdʋ -gʋ, 'ɩn na gbizea nyɩma weee 'wʋ na gbɛgbɛɩn.» ");
INSERT INTO kyf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wee wɛlɩnya ɔ gbaa da nɩ, nɩɩ, sa ɔ 'kaa tlɩ 'mʋ ɔ mɩa -sloluda. ");
INSERT INTO kyf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nyɩmaa -zlo nɛɛ ɔ -ylaɛ: «Titee 'sɛbhɛ nɛɛ nɩɩ, -Lagɔɔ -Bhasanyɔ mɩa, 'ylɩ weee nya ɔ yia -bha -tʋa, we nɩ mʋʋ? Nɩɩ, sa -ɩn mneni -ɩn ka gba nɩɩ, Nyɩmɛɛ 'Yu wa yia 'wʋsɔlʋa? Ɔɔ Nyɩmɛɛ 'Yu, nyɔɔ ɔ -maa?» ");
INSERT INTO kyf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɔ nɛɛ wa -ylaɛ: «Bhla -sɛlɛ nɩ nya, zlɩ mɩ -slɔ aɩn glaa. A nɔ -nya, da zlɩ mɩa -slɔ -bha, nikpise yi aɩn -kpalɩ. -We ka gbʋ -wa, nyɩmɛ -ɔ nɔa nikpise 'wʋ, mɔ ɔ mnɩa, ɔ 'nɩ -bha da -yi. ");
INSERT INTO kyf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Da a kaa da zlɩ, a zʋ we dlɩ -gʋ, 'ɩn a 'ka zlɩɩ 'yua -zɛ.» Da ɔ bhɩa gbagbɩe, 'ɩn ɔ yia wa kwɛɛ zizea mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","-Zezu ka gwɛdigbʋ duun lɛnʋ Zuifʋʋ 'yibadɩ, 'ɩn wa'a zʋ ɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sa -Lagɔgbʋʋ -falɩpanyɔ Ezaii gbaa, 'sa we 'plɩa, ɔ nɛɛ: «Nɩɩ, Jejitapɛ, nyɔɔ zʋ -amɩaa wɛlɩ dlɩ -gʋa? 'Ɩn nyɔɔ Jejitapɛ -slolu ɔ 'tɩtɛ 'klʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","We 'gbʋ Zuifʋ 'nɩ mneni wa 'ka ɔ dlɩ -gʋ zʋ. Sa Ezaii gbaa we da -putu sa -wa: ");
INSERT INTO kyf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«-Lagɔ ka wa 'lɔlʋ. Ɔ ka wa dlɩ 'wʋkla, -mʋʋ yi 'wlʋ nɩɩ, wa 'yli 'yɩ la, 'ɩn wa dlɩ 'nʋ gbʋ 'wʋla. We 'dɛɛ 'gbʋ wa'a 'bhitia -Lagɔɔ -gbɛ la ɔ 'ka wa pue.» ");
INSERT INTO kyf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","-We ka 'gbʋ Ezaii yia wee wɛlɩ nɩ gba, mʋ -wa nɩɩ, ɔ ka -Zezuu 'ŋnɩmnɩe -yɔyɩ, 'ɩn ɔ mɩa ɔ gbʋ gbada. ");
INSERT INTO kyf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nɩɩ, -mɔ Zuifʋʋ 'yugalɩnya glaa, nyɩma duun ka -Zezu dlɩ -gʋ zʋ. Nɩɩ, wa'a 'wlʋ 'klʋla we gbagbɩe nya Falizɩnyɩmaa 'gbʋ. Wa mɩ sɔda wa yi wa vu -Lagɔbudu zɔ. ");
INSERT INTO kyf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wa 'yɩbha nyɩma kwalɩ wa 'ŋnɩ we -zi -Lagɔ 'ka wa 'ŋnɩ kwalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","-Zezu 'kpɩa 'wʋ, ɔ nɛɛ: «Nyɩmɛ -ɔ -ka 'mɩ dlɩ -gʋ zʋ, we 'nɩ na 'dɛbhlo ɔ zʋ dlɩ -gʋ, nɩɩ, -ɔ tiea 'mɩ, 'mɔ ɔ zʋ 'yaa dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'Ɩn nyɩmɛ -ɔ yɩa 'mɩ -yɔ, -yɔ ɔ yɩa -ɔ tiea 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nɩɩ, zlɩ ɩn -mɩa, ɩn ka dʋdʋ -gʋ yi, 'ɩn nyɩmɛ -ɔ -ka 'mɩ dlɩ -gʋ zʋ, ɔ 'na 'ka nikpise 'wʋtʋ. ");
INSERT INTO kyf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nɩɩ, nyɩmɛ -ɔ nʋa na wɛlɩ, 'ɩn ɔ'ɔ zʋa we 'nʋŋwɛ, -amɩ, ɩ'ɩn dɩlɩ ɔ gbʋ. Nɩɩ, we 'nɩ nyɩmaa gbʋdɩlɩee 'gbʋ ɩn yi yi, ɩn 'ka wa gbʋ 'wʋsaa 'gbʋ ɩn yia yi. ");
INSERT INTO kyf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nɩɩ, nyɩmɛ -ɔ 'nɩ 'mɩ -yɔŋwnu, 'ɩn ɔ -ka na wɛlɩ kpɛla 'wʋnʋ, ɔ gbʋwʋbhunyɔ mɩ -bha. Dʋdʋʋ bhɩa zlɩ, wɛlɩ -we ɩn gbaa, mʋ yia ɔ -yɔgbʋ 'wʋbhua. ");
INSERT INTO kyf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wɛlɩ ɩn gbaa, we 'nɩ na 'dɛɛ -gbɛ 'bhʋ. Nɩɩ, Dide -ɔ tiea 'mɩ, ɔ -gbɛ we 'bhʋa. Gbʋ ɩn 'kaa gba, 'ɩn sa ɩn 'kaa we gba, ɔ 'dɛ ka 'mɩ we -slolu. ");
INSERT INTO kyf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'Ɩn, ɩn -yi we 'ji nɩɩ, Didee tite mɩa, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ we wlaa. Wɛlɩ weee na gbaa, sa Dide gbaa 'mɩ -yla we, 'sa na gbaa we.» ");
INSERT INTO kyf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nɩɩ, we -tʋ 'wʋ 'ylɩ -bhlo, Zuifʋʋ 'Wʋzɩtɩylɩɩ 'fɛtɩ 'ka nyni. -Zezu -yi we 'ji nɩɩ, 'ylɩ -we nya ɔ 'kaa dʋdʋ -gʋ 'bhʋ, 'ɩn ɔ 'kaa ɔ Didee -gbɛ mnɩ, we 'ylɩ ka nyni. Ɔ -kalɩ ɔ dʋdʋ -gʋ -bheliaa zɛ, 'ɩn -slɛɛn, ɔ -kalɩ wa zɛ ɔ dlɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nɩɩ, jibhe ka zɔ, 'ɩn -Zezu -yɔ ɔ 'bɩnɔnya 'sɔ mɩ lida. *'Kuzu ka 'cɩn Zudasɩ, Simɔ Isɩkaliɔtʋʋ 'yuu dlɩ zɔ -Zezuu wlawlɩe zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","-Zezu -yi we 'ji nɩɩ, ɔ Dide ka ɔ -lu weee kwɛɛ zʋ. 'Ɩn ɔ -yi we 'ji nɩɩ, Didee -gbɛ ɔ 'bhʋa, 'ɩn ɔ -gbɛ ɔ yia lʋmnɩa. ");
INSERT INTO kyf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Da wa mɩa lida, ɔ -sɔa 'wʋ, ɔ -saa ɔ -bana 'wʋ, ɔ 'bhua 'naa 'wʋ, 'ɩn ɔ yia we zleti -gba. ");
INSERT INTO kyf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","-Mʋʋ 'bɩgʋ, ɔ slua 'nyu kna 'wʋ, ɔ -wɔlʋa ɔ 'bɩnɔnyaa bhʋ -yɔ, 'naa -we ɔ -gbaa zleti, 'ɩn ɔ yia we -yɔ sɛ we nya. ");
INSERT INTO kyf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tɔʋn, ɔ nynia Simɔ Piɛlɩ -gʋ, 'ɩn -mɔɔ nɛɛ ɔ -ylaɛ: «Aya! Na -Kanyɔ, nanʋʋ bhʋ -yɔ -mɩ na yia -wɔlʋa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ɔ nɛɛ: «-We ɩn mɩa lɛnʋda, -ɩ'ɩn 'nʋ -slɔ we 'wʋla. Nɩɩ, cɩcɩ -ɩn 'kaa we 'wʋlanʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piɛlɩ nɛɛ ɔ -ylaɛ: «-Ɩnnya, -ɩn 'na 'ka na bhʋ -yɔwɔlʋ -gba!» Ɔ nɛɛ ɔ -ylaɛ: «Ɩn 'nɩ -na bhʋ -yɔwɔlʋ, -ɩn 'na 'ka -lu 'yabhlogbɔɔ 'yɩ 'mɩ kwɛɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔ Piɛlɩ nɛɛ: «Na -Kanyɔ, we -ka 'sa -mɩ nɩ, -ɩn 'na -wɔlʋ na bhʋ -bhlo -yɔ -nɩ. Nɩɩ, -ɩn -wɔlʋ 'ya na sɔ -yɔ na 'wlu -yɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ɔ nɛɛ ɔ -ylaɛ: «Nyɩmɛ -ɔ -ka budo nɩ, ɔ 'nɩ -yɔwɔlʋe gbʋ -ka, we 'bhʋ ɔ bhʋ 'wʋ, ɔ ka -mɔwlʋ 'lɩlɩ. We 'dɛɛ 'gbʋ, amɩa, a mɩ -mɔwlʋda, 'ɩn, we 'nɩ a 'dɛ weee.» ");
INSERT INTO kyf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nɩɩ, -ɔ 'kaa ɔ wla, ɔ -yi ɔ, we 'dɛɛ 'gbʋ ɔ yia gba nɩɩ: «A 'dɛ weee 'nɩ -mɔwlʋda -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Da -Zezu bhɩa ɔ 'bɩnɔnyaa bhʋ -yɔwɔlʋe, ɔ -plaa ɔ -bana 'wʋ, 'ɩn ɔ yia ladɩ. Ɔ nɛɛ wa -ylaɛ: «'Lee, -we ɩn nʋa da aɩn -yla lɛ, a nʋ we 'wʋlaa? ");
INSERT INTO kyf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","-Amɩ a laa ‹-Slolunyɔ› we -yɔ ‹-Kanyɔ›, 'ɩn amɩaa gbʋ mɛnɩ, nɩɩ, 'mɔ ɩn -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɩɩ, -amɩ -wa amɩaa -Kanyɔ, we -yɔ amɩaa -Slolunyɔ, 'ɩn ɩn ka amɩaa bhʋ -yɔ -wɔlʋ, we 'dɛɛ 'gbʋ a 'dɛkpʋa 'kaa bhʋ -yɔ wʋwɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ɩn ka we 'yli aɩn -slolu: sa ɩn nʋa aɩn -yla, a nʋ 'sasʋkpa -gbʋ lɛ. ");
INSERT INTO kyf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, lubhonʋnyɔ 'nɩ 'nʋŋwɛ -ka ɔ 'ka ɔ -kanyɔ -zi, tietienyɔ 'nɩ 'lɛ -ka -ɔ tiea ɔ, ɔ 'ka -mɔɔ -zi. ");
INSERT INTO kyf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","-Slɛɛn, a -yi we 'dɛ weee 'ji. Nɩɩ, a -ka we lɛnʋ nɩ, 'wʋtʋtʋe -dlɔɔ mɩ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Nɩɩ, ɩn 'nɩ a 'dɛ weee 'ŋnɩ sa -nya. -Wa ɩn -saa -bha, ɩn -yi wa. Wɛlɩ -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, lɛ we yia nʋa. We nɛɛ: ‹Nyɩmɛ -ɔ -yɔ 'mɩ 'sɔ lia, ɔ ka na tʋnyɩmɛ -zɛ.› ");
INSERT INTO kyf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Da we 'nɩa -slɔ da 'plɩ nɩ, gba na gbaa -slɛɛn we aɩn -yla. Nɩɩ, we bhla -ka nyni nɩ, 'ɩn a 'ka dlɩ zʋ nɩɩ, -amɩ mɩa, ‹-ɔ ɩn -mɩa, 'mɔ ɩn -mɩa.› ");
INSERT INTO kyf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: nyɩmɛ -ɔ -ka na tietienyɔ kpa 'nanʋʋ, -amɩ ɔ kpaa 'nanʋʋ. 'Ɩn nyɩmɛ -ɔ -ka 'mɩ kpa 'nanʋʋ, -ɔ tiea 'mɩ, 'mɔ ɔ kpaa 'nanʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","-Zezu bhɩa gbʋnya nɩ gbagbɩe, 'ɩn ɔ dlɩ yia sumanɩ, 'ɩn ɔ nɛɛ wa -yla sa tɩklɩɩ: «Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: aɩn glaa, nyɩmɛ yabhlo yia 'mɩ wlaa.» ");
INSERT INTO kyf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nɩɩ, -Zezuu 'bɩnɔnya yia yɩylalɩ, -ɔ ɔ saa 'ŋnɩ, wa 'nɩ ɔ -yi. ");
INSERT INTO kyf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Da wa mɩa lida, ɔ 'bɩnɔnyɔ yabhlo, -ɔ ka zɛ ɔ -kalɩa, -mɔɔ mɩ ɔ kwesi. ");
INSERT INTO kyf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔ Piɛlɩ yia ɔ -yla 'yɩka 'pa, ɔ 'ka -Zezu layɩbha nɩɩ, nyɔɔ ɔ sa 'ŋnɩa. ");
INSERT INTO kyf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","-Mɔɔ pɩa -Zezuu gbɛgbɛɩn 'wʋ, 'ɩn ɔ yia ɔ layɩbha 'ŋwuŋwe wɛlɩ 'wʋɛ: «Na -Kanyɔ, nyɔɔ 'ka -mɩ wlaa?» ");
INSERT INTO kyf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «'Floo -kibhe na yia zapʋ lʋ 'ŋwaa, -ɔ ɩn -ka we yoo 'nyɛ, mɔ 'kaa 'mɩ wla.» Tɔʋn, ɔ 'ŋwaa 'floo -kibhe zapʋ lʋ, 'ɩn ɔ yia we Simɔ Isɩkaliɔtʋʋ 'yu Zudasɩ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Da -mɔɔ 'bhua wee 'floo -kibhe 'wʋ, -bha -bhlokpadɛ *-Saatan plaa -mɔɔ 'wʋ. -Mʋʋ 'bɩgʋ, -Zezu nɛɛ ɔ -yla: «-We -ɩn 'kaa lɛnʋ, -ɩn nʋ we lɛ slʋɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","-Wa mɩa -bha lida, wa 'nɩ we 'wʋlanʋ. -We ka 'gbʋ -Zezu yia we ɔ -yla gba, wa glaa, nyɩmɛ yabhlogbɔɔ 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","-Zezu gbaa wɛlɩ mɩa dɛ nɩ, -zugba nyɩma tɔlʋa pʋpalɩa 'wlukʋʋn laɛ: «'Sa ɔ 'yɩbhaa ɔ 'ka gba nɩɩ, ɔ mnɩ 'fɛtɩgʋli zɔa yaayɩɩ, ɔ mnɩ bobabhanya 'gwɛzi 'nyɛa yɩ?» Zudasɩ mɩ 'gwɛzii lazʋnyɔ nyaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zudasɩ 'bhua wee 'floo -kibhe 'wʋ, -bha -bhlokpadɛ ɔ 'tlaa -budu zɔ, -zugba sabɔ ka bɛ. ");
INSERT INTO kyf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zudasɩ mnɩa 'bhie, -Zezu nɛɛ: «-Slɛɛn, Nyɩmɛɛ 'Yu ka 'ŋnɩylilo 'yɩ. Ɔ 'wʋ wa yia -Lagɔɔ 'ŋnɩylilo yibhelia.  ");
INSERT INTO kyf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Ɩn wa -ka -Lagɔɔ 'ŋnɩylilo yibheli ɔ 'wʋ nɩ, Nɩɩ, ɔɔ 'Yu -ka -Lagɔɔ 'ŋnɩ 'ylimanɩ nɩ, 'ɩn -Lagɔɔ 'dɛbhie slolua ɔɔ 'Yuu 'ŋnɩylilo ɔ 'dɛ 'wʋ, 'ɩn daylɩ ɔ slolua we. ");
INSERT INTO kyf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na 'ylaaslɩɩ, ɩn -yɔ aɩn 'sɔ mɩ -slɔ bhla -sɛlɛɛ -nʋ nya. 'Ɩn -mʋʋ 'bɩgʋ, na da a yia -talɩa. -We ka gbʋ -wa, da na yia mnɩa, a 'nɩ mneni a 'ka -mɔ mnɩ. Nɩɩ, ɩn ka zlɩmɛ we Zuifʋ -yla gba. 'Ɩn, 'mʋ na gbaa -slɛɛn aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nɩɩ, tite lolu na palɩa aɩn -yla, mʋ nɩ: a kɩkalɩ zɛ. Cɩɩn, sa ɩn -kalɩa amɩaa zɛ, a kɩkalɩ 'sa zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We -ka 'sa -mɩ, a -ka zɛkɩkalɩ, 'ɩn nyɩma weee yibhelia we 'ji nɩɩ, a mɩ na 'bɩnɔnya nya.» ");
INSERT INTO kyf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔ Piɛlɩ nɛɛ -Zezu -yla: «Na -Kanyɔ, mɔ -na mnɩa?» Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «'Mɔ na mnɩa, -ɩn 'nɩ -slɔ mneni -ɩn 'ka 'mɩ 'bɩ yi, nɩɩ, cɩcɩ -ɩn 'kaa 'mɩ 'bɩ yi.» ");
INSERT INTO kyf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piɛlɩ nɛɛ ɔ -yla: «Na -Kanyɔ, ɩn 'nɩ -slɛɛn mneni ɩn 'ka -mɩ 'bɩ yii? 'Lee, lɛɛ -lu ka 'gbʋa? Nɩɩ, ɩn mneni ɩn 'ka na 'dɛɛ 'yliyɔgagɩe wla -na 'gbʋ!» ");
INSERT INTO kyf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ɔ nɛɛ ɔ -yla: «-Ɩn mneni -ɩn 'ka -na 'dɛɛ 'yliyɔgagɩe wla na 'gbʋ 'piɛɩn? Ɩn nɛɛ -mɩ -yla gbʋzɔnʋ sa nɩɩ, -kʋkɔ 'na 'ka gbo, 'ɩn -na kpɛlɩa na gbʋ -zakpa ta.» ");
INSERT INTO kyf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","-Zezu nɛɛ ɔ 'bɩnɔnya -ylaɛ: «A 'na lʋlʋ dlɩ -nɩ. A zʋ -Lagɔ dlɩ -gʋ, 'ɩn a zʋ 'ya 'mɩ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","-Buduu -zlo mɩ na Didee -buduŋwɛɛ. We 'nɩ ya 'sa -mɩ nɩ, ɩn 'na 'ka aɩn -yla gba nɩɩ, amɩaa ladɩda na mnɩa la mnazɩa, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'Ɩn, ɩn -ka aɩn -yla ladɩda la mnazɩ nɩ, lʋ na yia yia ɩn -yɔ aɩn 'sɔ 'ka mnɩ, 'ɩn da ɩn mɩa, a 'ka -bha -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Ɩn da na mnɩa, 'yoo -we mnɩa -mɔ, a -yi we.» ");
INSERT INTO kyf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma nɛɛ ɔ -yla: «Na -Kanyɔ, da -na mnɩa -a 'nɩ -bha da -yi! 'Lee, sa -a mneni -a 'ka -bhaa 'yoo da -yia?» ");
INSERT INTO kyf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ɔ nɛɛ: «Nɩɩ, -amɩ -wa yoo, gbʋzɔnʋ we -yɔ 'yliyɔgagɩe. Nyɩmɛ -ɔ 'nɩ 'mɩ 'wʋplɩlɩ nɩ, ɔ 'na 'ka Didee -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","A -ka 'mɩ -yi, -zugba a -yi na Dide. 'Ɩn we 'bhʋ -slɛɛn 'wʋ, a -yi ɔ, 'ɩn a ka ɔ 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipʋ nɛɛ ɔ -ylaɛ: «Na -Kanyɔ, -na zukpa -wa, -slolu -aɩn -na Dide 'klʋ. -Ɩn -ka we lɛnʋ, 'ɩn -amɩaa dlɩ pɩa la.» ");
INSERT INTO kyf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","-Zezu nɛɛ ɔ -yla: «Filipʋ, 'ylɩɩ -zlo ɩn -yɔ aɩn 'sɔ lia da nɩ, 'lee, -ɩn 'nɩ 'mɩ -yii? Nyɩmɛ -ɔ -ka 'mɩ 'yɩ, ɔ ka na Dide 'yɩ. 'Ɩn, -mɩ nɛɛ: ‹-Slolu -aɩn -na Dide 'klʋ!› ");
INSERT INTO kyf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nɩɩ, ɩn mɩ Dide 'wʋ, 'ɩn Dide mɩ 'mɩ 'wʋ. 'Lee, -ɩ'ɩn zʋ we dlɩ -gʋʋ? Wɛlɩnya na gbaa da aɩn -yla, we'e 'bhʋ na 'dɛɛ -gbɛ, nɩɩ, na Dide -ɔ -dɩlɩa 'mɩ 'wʋla, mɔ nʋa ɔ lubho. ");
INSERT INTO kyf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","«Ɩn -ka aɩn -yla gba nɩɩ, ɩn mɩ Dide 'wʋ, 'ɩn Dide mɩ 'mɩ 'wʋ, a zʋ 'mɩ dlɩ -gʋ. We 'nɩ -mʋʋ nɩ, a zʋ -ylɛɛ dlɩ na gwɛdigbʋnyaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, -ɔ -ka 'mɩ dlɩ -gʋ zʋ nɩ, 'ɩn ɔ nʋa na lɛnʋgbʋnya lɛ. Cɩɩn, ɔ lɛnʋgbʋnya yia na -nʋ -zia, -we ka gbʋ -wa, Didee -gbɛ na mnɩa. ");
INSERT INTO kyf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","-Lu weee a -ka na 'ŋnɩ nya -zla, lɛ na yia we nʋa. We -ka 'sa -mɩ nɩ, 'ɩn 'Yu mnɩnɩa ɔ Didee 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɩɩ, -lu -mʋʋ a -ka 'mɩ -zlalɩ na 'ŋnɩ nya, lɛ na yia we nʋa. ");
INSERT INTO kyf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Nɩɩ, a -ka na zɛkalɩ -nya nɩ, 'ɩn a zʋa na titenya 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'Ɩn ɩn 'ka Dide -yɔbhubhoe ɔ 'ka aɩn -Yɔbɛnyɔ -putu 'nyɛ. Mɔ 'kaa aɩn -yɔbɛ, 'ɩn mɔ -yɔ aɩn 'sɔ 'kaa -tʋ 'ylɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nɩɩ, mɔ -wa Zuzu -ɔ 'kaa aɩn -Lagɔɔ gbʋzɔnʋ 'wʋkwa. Ɔɔ Zuzu mɩa nɩ, dʋdʋgʋ -nyɩma 'nɩ mneni wa 'ka ɔ -yɔŋwnu, -we ka gbʋ -wa, wa'a 'yɩ ɔ -yɔ, 'ɩn wa 'nɩ ɔ -yi. Nɩɩ, amɩa mɩa, a -yi ɔ, ɔ -yɔ aɩn 'sɔ -dɩ dabhlo la, 'ɩn aɩn 'wʋ ɔ yia ladɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Ɩn 'na 'ka aɩn 'wʋtɩ kwiiyua 'bhisa, nɩɩ, amɩaa -gbɛ na yia yia. ");
INSERT INTO kyf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Ɩn bhla -sɛlɛ -ka 'plɩ nɩ, dʋdʋgʋ -nyɩma 'na 'ka 'mɩ 'yɩ. Nɩɩ, amɩa mɩa nɩ, 'yɩa a yia 'mɩ. 'Ɩn a yɩa 'yliyɔgagɩe, -amɩ ka 'yliyɔgagɩee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Zlɩ we 'ylɩ -ka nyni nɩ, 'ɩn a yibhelia we 'ji nɩɩ, ɩn mɩ Dide 'wʋ, a mɩ 'mɩ 'wʋ, 'ɩn ɩn mɩ aɩn 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Nyɩmɛ -ɔ -ka na titenya -yɔŋwnu, 'ɩn ɔ -ka we 'nʋŋwɛ zʋ nɩ, -zugba -mɔɔ -kalɩ na zɛ. Ɔɔ nyɩmɛ -ɔ -kalɩa na zɛ, ɔ zɛ na Dide yia -kalɩa. -Amɩ, ɔ zɛ na yia -kalɩa, 'ɩn ɩn 'ka ɔ na 'dɛ -slolu.» ");
INSERT INTO kyf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Zudasɩ (-ɔ 'nɩa Zudasɩ Isɩkaliɔtʋ) nɛɛ ɔ -ylaɛ: «Na -Kanyɔ, 'lee, lɛɛ -lu ka 'gbʋ -ɩn 'ka -aɩn -na 'dɛ -slolu, 'ɩn, -ɩ'ɩn -slolu -na 'dɛ dʋdʋgʋ -nyɩma weeea?» ");
INSERT INTO kyf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ɔ nɛɛ: «Nyɩmɛ -ɔ -ka na zɛkalɩ nɩ, na wɛlɩ ɔ zʋa 'nʋŋwɛ. 'Ɩn na Dide kalɩa ɔ zɛ, 'ɩn -amɩ -yɔ na Dide sɔ yia ɔ 'wʋ la -dɩlɩa. ");
INSERT INTO kyf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nyɩmɛ -ɔ 'nɩa na zɛkalɩ, ɔ'ɔ zʋ na wɛlɩ 'nʋŋwɛ. -We na gbaa da aɩn -yla, we 'nɩ na 'dɛɛ wɛlɩ, nɩɩ, na Dide -ɔ tiea 'mɩ, ɔ -gbɛ we bhʋa. ");
INSERT INTO kyf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Wee wɛlɩ na gbaa aɩn -yla, da ɩn mɩa -slɔ aɩn glaa. ");
INSERT INTO kyf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nɩɩ, ɩn -ka mnɩ nɩ, 'ɩn na Dide paa aɩn Zuzu 'Pʋpa yoo na 'ŋnɩ nya, mɔ 'kaa aɩn 'wʋsa. Ɔɔ Zuzu 'kaa aɩn gbʋ weee -slolu, 'ɩn ɔ ligbea aɩn gbʋ weee -we ɩn gbaa aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«'Wʋtʋtʋe -dlɔɔ na tɩa aɩn -yɔ. Na 'wʋtʋtʋe -dlɔɔ na nyɛa aɩn. Sa ɩn kaa 'wʋtʋtʋe -dlɔɔ nɩ, 'sa na nyɛa we aɩn. Ɩ'ɩn wla we dʋdʋgʋ -nyɩmaa -luwla sɔlʋ. A palɩ dlɩ la, a 'na nʋnʋ nyanɔ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A ka 'mɩ ŋwɛɛ 'nʋ nɩɩ: ‹Mnɩa na yia, 'ɩn amɩaa -gbɛ na yia lʋ yia.› A -ka yaa na zɛkalɩ nɩ, -zugba a ka yaa 'mʋna li, nɩɩ, na Didee -gbɛ na mnɩa. -We ka gbʋ -wa, Dide 'yli ɔ -zi 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Da -we -nya mɩa dɛ 'nɩa -slɔ 'plɩ nɩ, gba na gbaa we aɩn -yla 'gamʋ. Nɩɩ, we bhla -ka nyni, a 'ka we dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ɩn -yɔ aɩn 'sɔ 'na 'ka gba duun, -we ka gbʋ -wa, dʋdʋgʋ -nyɩmaa 'yugalɩnyɔ 'nyuu mɩ yida. Ɔ 'nɩ 'mɩ kwɛyɔmneni. ");
INSERT INTO kyf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","We -ka 'sa -mɩ nɩ, dʋdʋgʋ -nyɩma 'ka we 'jiyibheli nɩɩ, ɩn -kalɩ na Didee zɛ. Ɩn -kalɩ ɔ zɛ, we 'dɛɛ 'gbʋ -lu weee ɔ gbaa ɩn nʋ lɛ, 'ɩn na nʋa we lɛ. A -sɔ 'wʋ, -a 'ka mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Nɩɩ, *-dlɔsuu 'zayli, -amɩ -wa. 'Ɩn na Dide mɩa, we kpaapanyɔ ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na 'klɩya -we'e tnʋa, 'mʋ ɔ dɩa, 'ɩn 'klɩya -we tnʋa, ɔ mnazɩa we -yɔ, 'ɩn we 'ka tnʋ duun. ");
INSERT INTO kyf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wɛlɩ -we ɩn gbaa aɩn -yla, we ka aɩn -yɔmnazɩ, 'ɩn we yia aɩn -mɔwlʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","«A -dɩlɩ 'mɩ 'wʋla, sa ɩn -dɩlɩa aɩn 'wʋla 'bhisa. Sa suu 'klɩya -we 'nɩa suu 'gblʋ -yɔ -mɩ, we 'nɩa mneni we 'ka tnʋ we 'dɛ -bhlo nɩ, 'sa -bhlokpadɛ, a 'nɩ 'mɩ 'wʋladɩlɩ, a 'na 'ka tnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Nɩɩ, -amɩ -wa -dlɔsu, 'ɩn amɩa -wa we 'klɩya. Nyɩmɛ -ɔ -ka 'mɩ 'wʋladɩlɩ, sa -amɩ -dɩlɩa ɔ 'wʋla 'bhisa nɩ, ɔɔ nyɩmɛ, tnʋa ɔ yia duun. -We ka gbʋ -wa, ɩn 'nɩ aɩn -yɔbɛ, a 'nɩ mneni a 'ka -lu yabhlogbɔɔ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nyɩmɛ -ɔ 'nɩ 'mɩ 'wʋladɩlɩ nɩ, suu 'klɩya 'bhisa wa vitelia ɔ. Wee suu 'klɩya -ka yɛ nɩ, 'mʋ wa bhua la, 'ɩn wa paa we -kosu 'wʋ, 'ɩn we sia. ");
INSERT INTO kyf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","A -ka 'mɩ 'wʋladɩlɩ, 'ɩn na wɛlɩnya -ka amɩaa dlɩ 'wʋtʋ nɩ, -lu weee a -ka 'yɩbha, a -zlalɩ we Dide, 'ɩn ɔ nyɛa we aɩn. ");
INSERT INTO kyf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","A -ka tnʋ duun, mʋ slolua na Didee 'ŋnɩmnɩe -yɔ a mɩ na 'bɩnɔnya -zɔnʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Nɩɩ, sa Dide -kalɩa na zɛ, 'sa -bhlokpadɛ ɩn -kalɩa amɩaa zɛ. A -tʋ na zɛkalɩe 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ɩn ka na Didee titenya 'nʋŋwɛ zʋ, 'ɩn ɩn yia ɔ zɛkalɩe 'wʋtʋ. 'Sa -bhlokpadɛ, a -ka na titenya 'nʋŋwɛ zʋ nɩ, 'ɩn a tʋa na zɛkalɩe 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«-We mɩa dɛ, 'mʋ ɩn gbaa aɩn -yla, 'ɩn sa 'mʋna mɩa 'mɩ dlɩ 'wʋ, we 'ka 'sa aɩn dlɩ 'wʋ -mɩ. Cɩɩn, 'ɩn amɩaa 'mʋna 'ka -bha -gʋ zi. ");
INSERT INTO kyf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na tite nɩ: sa ɩn -kalɩa amɩaa zɛ, a kɩkalɩ 'sa zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nɩɩ, nyɩmɛ -ɔ -ka ɔ 'dɛɛ 'yliyɔgagɩe wla ɔ -limaa 'gbʋ, zɛkalɩe -we -zia -mʋʋ, we 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","-We ɩn gbaa a nʋ lɛ, a -ka we 'nʋŋwɛ zʋ, a mɩ na 'talea nya. ");
INSERT INTO kyf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ɩ'ɩn la 'maslɛɛn aɩn na lubhonʋnya, -we ka gbʋ -wa, lubhonʋnyɔ 'nɩ ɔ -kanyɔɔ gbʋnya -yi. 'Ɩn amɩa mɩa, na 'talea na laa aɩn, -we ka gbʋ -wa, gbʋ weee ɩn 'nʋa Didee -gbɛ, ɩn ka we aɩn -slolu. ");
INSERT INTO kyf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Lee, amɩa -saa -bha 'mɩ yɩ? -Ɩnnya, we 'nɩ -mʋʋ, -amɩ -saa -bha aɩn. Nɩɩ, ɩn ka aɩn 'yoo 'nyɛ a 'ka tnʋa mnɩ, 'ɩn we 'ya 'ka -gwlɛ. 'Ɩn -lu weee a -ka Dide -zla na 'ŋnɩ nya, ɔ 'ka we aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nɩɩ, tite ɩn palɩa aɩn -yla, mʋ nɩ: a kɩkalɩ zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Nɩɩ, dʋdʋgʋ -nyɩma -ka aɩn 'wʋnyɛ nɩ, a 'na dlʋlʋ -nɩ nɩɩ, wa ka 'mɩ 'wʋnyɛ tɩa. ");
INSERT INTO kyf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","A -yɔ dʋdʋgʋ -nyɩma 'sɔ 'nɩ -mɩ -bhlo. A -ka yaa -mɩ -bhlo, 'ɩn wa yɩbhaa aɩn, wa 'dɛɛ nyɩma wa 'yɩbhaa 'gbʋ. Nɩɩ, ɩn ka -bha aɩn -sa dʋdʋgʋ -nyɩma glaa, 'ɩn a -yɔ wa 'sɔ 'nɩ -mɩ -bhlo, we 'dɛɛ 'gbʋ wa nyɛa aɩn 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","A ligbe na wɛlɩ, nɩɩ, lubhonʋnyɔ 'nɩ 'yli ɔ 'ka ɔ -kanyɔ -zi. Dʋdʋgʋ -nyɩma ka 'mɩ 'klɩyɩe 'wʋpalɩ. 'Ɩn wa -ka 'mɩ 'klɩyɩe 'wʋpalɩ nɩ, 'klɩyɩe 'wʋ wa yia aɩn palɩa. 'Ɩn wa -ka na wɛlɩ 'nʋŋwɛ zʋ, 'ɩn wa zʋa amɩaa -nʋ 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nɩɩ, 'sa wa yia aɩn kpaa na 'gbʋ. -We ka gbʋ -wa, -ɔ tiea 'mɩ, wa 'nɩ ɔ -yi. ");
INSERT INTO kyf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ɩn 'nɩ yaa yi, 'ɩn ɩn 'ka wa -yla gba nɩ, -zugba wa 'nɩ yaa gbʋnyuuu 'gba 'wlu -ka. Nɩɩ, -slɛɛn wa 'nɩ zizeda -ka wa gbʋnyuu 'yu. ");
INSERT INTO kyf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyɩmɛ -ɔ -ka 'mɩ 'wʋnyɛ, na Dide ɔ nyɛa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Gwɛdigbʋnya -we nyɩmɛ yabhlogbɔɔ 'nɩa -slɔ lɛnʋ, ɩn ka -mʋʋ lɛnʋ wa 'yibadɩ. We 'nɩ yaa 'sa -mɩ, -zugba wa 'na 'ka yaa gbʋnyuu 'gba 'wlu -ka. Nɩɩ, -slɛɛn, gwɛdigbʋnya ɩn nʋa lɛ, wa ka we -yɔyɩ, 'ɩn wa nyɛa ɩn -yɔ na Dide 'sɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","-We mɩa cɛlɩda wa tite 'wʋ, nɛɛ: ‹Wa ka 'mɩ 'wʋnyɛ bhe.› 'Wʋ wa nyɛa -aɩn, -we mɩa cɛlɩda we 'ka lɛnʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Nɩɩ, -Yɔbɛnyɔ yia yia. Mɔ -wa Zuzu -ɔ 'kaa aɩn gbʋzɔnʋ 'wʋkwa. Didee -gbɛ ɔ bhʋa, yoo na yia ɔ aɩn 'paa. Nɩɩ, ɔ -ka yi nɩ, mɔ yia na gbʋdayɩnyɔ -zɛa. ");
INSERT INTO kyf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Ɩn amɩa yi 'yaa na gbʋdayɩnya -zɛa, -we ka gbʋ -wa, we bhlili we gwedɩda, a -yɔ 'mɩ 'sɔ mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Nɩɩ, a yi 'yoo -zɔnʋ -gʋ labhʋlʋ, we 'gbʋ ɩn yia aɩn -yla gbʋ -mɩnɩ gba. ");
INSERT INTO kyf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","-Lagɔbudunya zɔ wa yia aɩn vua. 'Ɩn we bhla ka cɩpa, da nyɩma -wa mnenia wa 'ka aɩn 'bha, wa yia gbaa wa 'dɛɛ dlɩ 'wʋ nɩɩ, 'sa wa nʋa -Lagɔɔ lubho. ");
INSERT INTO kyf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","'Sa wa yia nʋa, -we ka gbʋ -wa, wa 'nɩ Dide -yi, 'ɩn wa 'nɩ 'mɩ -yi. ");
INSERT INTO kyf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Da we bhla 'nɩa -slɔ nyni, gbʋnya nɩ na gbaa aɩn -yla 'gamʋ. 'Ɩn we bhla -ka nyni nɩ, a 'ka ligbe nɩɩ, ɩn ka we aɩn -yla gba. «Nɩɩ, ɩn 'nɩ we aɩn -yla gba we gwedɩda, -we ka gbʋ -wa, ɩn -yɔ aɩn 'sɔ mɩ -slɔ. ");
INSERT INTO kyf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«-Slɛɛn, -ɔ tiea 'mɩ, ɔ -gbɛ na mnɩa. 'Ɩn aɩn glaa, nyɩmɛ yabhlogbɔɔ'ɔ 'yɩbha 'mɩ laɛ: ‹Mɔ -na mnɩa?› ");
INSERT INTO kyf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nɩɩ, -slɛɛn ɩn 'tʋlʋa da aɩn nɩ, we 'dɛɛ 'gbʋ amɩaa -gʋ yia 'wʋtʋ yuo. ");
INSERT INTO kyf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Ɩn gbʋzɔnʋ -nanʋ ɩn mɩa aɩn -yla gbada: Ɩn -ka mnɩ nɩ, -mʋʋ nanɩ 'yli amɩaa 'gbʋ. -We ka gbʋ -wa, ɩn 'nɩ mnɩ, -Yɔbɛnyɔ 'na 'ka aɩn -yla yi. Nɩɩ, ɩn -ka mnɩ nɩ, 'ɩn na paa ɔ aɩn yoo. ");
INSERT INTO kyf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Ɩn, ɔ -ka yi nɩ, 'ɩn ɔ slolua dʋdʋgʋ -nyɩma sa wa nʋa wa 'dɛ -dawli 'wʋ wa gbʋnyuu klaa, -we mɩa tɩklɩɩ klaa, we -yɔ -Lagɔɔ gbʋwʋbhubhuee daa. ");
INSERT INTO kyf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nɩɩ, dʋdʋgʋ -nyɩma mɩ wa 'dɛ -dawli 'wʋnʋda tɩada gbʋnyuuu daa, wa'a zʋ 'mɩ dlɩ -gʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Ɩn, we 'sɔnʋ nya, wa mɩ wa 'dɛ -dawli 'wʋnʋda, -we mɩa tɩklɩɩɩ daa. -We ka gbʋ -wa, Didee -gbɛ na mnɩa, 'ɩn a 'na 'ka 'mɩ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dʋdʋgʋ -nyɩma mɩ wa 'dɛ -dawli 'wʋnʋda we tanʋ nya, -Lagɔɔ gbʋwʋbhubhuee daa. -We ka gbʋ -wa, -Lagɔ ka dʋdʋgʋ -nyɩmaa 'yugalɩnyɔ 'nyuuu -yɔgbʋ 'wʋbhu pepe. ");
INSERT INTO kyf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Nɩɩ, ɩn ka -slɔ wɛlɩ duun ɩn 'ka we aɩn -yla gba. 'Ɩn a 'nɩ -slɛɛn mneni a 'ka we zɔ 'yligbe. ");
INSERT INTO kyf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gbʋzɔnʋ -Zuzu -ka yi nɩ, mɔ 'kaa aɩn gbʋzɔnʋʋ 'dɛbhie 'wʋkwa. -We ka gbʋ -wa, ɔ 'na 'ka ɔ 'dɛɛ 'ŋnɩ nya gba, nɩɩ, -we weee ɔ 'nʋa, 'mʋ ɔ gbaa, 'ɩn -we 'nɩa -slɔ 'plɩ nɩ, 'mʋ ɔ palɩa aɩn zlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","-We mɩa na -nʋ nya, 'mʋ Zuzu yia 'yɩa, 'ɩn ɔ palɩa aɩn zlɩ. 'Sa ɔ mnɩnɩa na 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","-We weee na Dide kaa, we mɩ 'ya na -nʋ nya. We 'dɛɛ 'gbʋ, ɩn yia aɩn -yla gba nɩɩ, -we mɩa na -nʋ nya, 'mʋ Zuzu yia 'yɩa, 'ɩn we zlɩ ɔ yia aɩn 'palɩa. ");
INSERT INTO kyf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Bhla -sɛlɛ nya, a 'na 'ka 'mɩ 'yɩ, 'bhie, bhla -sɛlɛ nya, 'ɩn a yɩa 'mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","-Zezuu 'bɩnɔnya glaa, tɔlʋa gbʋgbalɩa -ylaɛ: «Ɔ nɛɛ -aɩn -yla: ‹Bhla -sɛlɛ nya, a 'na 'ka 'mɩ 'yɩ, 'bhie, bhla -sɛlɛ nya, 'ɩn a yɩa 'mɩ.› Ɔ nɛɛ 'ya -aɩn -ylaɛ: ‹Na Didee -gbɛ na mnɩaa 'gbʋ,› 'lee, sa we 'ji mɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Ɩn wa nɛɛ 'yaɛ: «Ɔ -ka gba ‹Bhla -sɛlɛ› nɩ, 'lee, sa -mʋʋ 'ji mɩa? -We ɔ gbaa, -a'a 'nʋ we 'wʋla.» ");
INSERT INTO kyf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","-Zezu -yi we 'ji nɩɩ, ɔ 'bɩnɔnya 'yɩbha wa 'ka ɔ layɩbha, tɔʋn, ɔ nɛɛ wa -yla: «Ɩn nɛɛ aɩn -yla: ‹Bhla -sɛlɛ nya, a 'na 'ka 'mɩ 'yɩ, 'bhie, bhla -sɛlɛ nya, 'ɩn a yɩa 'mɩ.› We 'jii da a mɩa -talɩda a 'dɛkpʋa nyɩdɩ, we 'nɩ mʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ɩn nɛɛ aɩn -yla gbʋzɔnʋ sa nɩɩ, wia a yia, 'ɩn -gle a yia 'paa. Nɩɩ, dʋdʋgʋ -nyɩma yia 'mʋna lia, -zugba amɩaa dlɩ sumanɩ, 'ɩn amɩaa dlɩɩ sumanɩe yia 'mʋna -zɛa. ");
INSERT INTO kyf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Ŋwnɔ -ka luzi -bho, ɔ dlɩ -su, -we ka gbʋ -wa, ɔ sɩasɩa bhla ka nyni. Nɩɩ, ɔ -ka gwalɩ nɩ, 'ɩn ɔ dlʋa ɔ sɩasɩe 'wʋ. 'Ɩn ɔ lia 'mʋna, ɔ ka 'yu gwalɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Sasʋkpa sa, -slɛɛn amɩaa dlɩ -su, nɩɩ, ɩn -ka aɩn 'yɩ lʋ nɩ, 'ɩn a lia 'mʋna. 'Ɩn, nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka wee 'mʋna aɩn kwɛɛ -sa. ");
INSERT INTO kyf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nɩɩ, wee 'ylɩ -ka nyni nɩ, a 'na 'ka 'maslɛɛn 'mɩ gbʋ yabhlogbɔɔ layɩbha. Ɩn nɛɛ aɩn -yla gbʋzɔnʋ saɛ: -lu weee a -ka Dide -zlalɩ na 'ŋnɩ nya, 'nyɛa ɔ yia we aɩn. ");
INSERT INTO kyf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A 'nɩ -slɔ -lu na Dide -zlalɩ na 'ŋnɩ nya. Nɩɩ, a -zla, a -ka -zla nɩ, 'ɩn a yɩa we, 'ɩn amɩaa 'mʋna 'ka -bha -gʋ zi. ");
INSERT INTO kyf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Nɩɩ, -we weee mɩa dɛ, ɩn ka we aɩn -yla gba gbʋʋ nine nya. We bhla ka cɩpa, bhla -we nya ɩn 'na 'kaa gbʋ gba gbʋʋ nine nya, 'ɩn ɩn 'kaa aɩn -yla Didee gbʋ gba sa 'vayɩ. ");
INSERT INTO kyf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wee 'ylɩ -ka nyni nɩ, 'ɩn a bhubhoea na Dide na 'ŋnɩ nya. 'Ɩn, ɩn 'nɩ gba aɩn -yla nɩɩ, bhubhoea na yia ɔ amɩaa 'gbʋ. -Ɩnnya, we 'nɩ -mʋʋ. ");
INSERT INTO kyf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","-We ka gbʋ -wa, Didee 'dɛbhie -kalɩ amɩaa zɛ. A -kalɩ na zɛ, 'ɩn a zʋa dlɩ nɩɩ, Dide -Lagɔɔ -gbɛ na bhʋa, we 'gbʋ ɔ -kalɩa amɩaa zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nɩɩ, Didee -gbɛ ɩn 'bhʋa, 'ɩn ɩn yia dʋdʋ -gʋ yi. -Slɛɛn, dʋdʋ -gʋ na yia 'bhʋa ɩn 'ka Didee -gbɛ lʋmnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Ɩn ɔ 'bɩnɔnya nɛɛ ɔ -ylaɛ: «Mʋ mɩa dɛ, -slɛɛn -ɩ'ɩn gba gbʋʋ nine nya, nɩɩ, sa tɩklɩɩ -na gbaa. ");
INSERT INTO kyf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","-Slɛɛn, -a -yi we 'ji nɩɩ, -ɩn -yi gbʋ weee 'ji. Nɩɩ, -a 'nɩ -slɔ -mɩ gbʋ yabhlogbɔɔ layɩbha, 'ɩn -ɩn -yia -we -a 'kaa -mɩ layɩbha. We 'gbʋ -a zʋa dlɩ nɩɩ, -Lagɔɔ -gbɛ -na bhʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ wa -ylaɛ: «Dlɩ a zʋ -slɛɛn 'mɩ -gʋʋ? ");
INSERT INTO kyf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ɩn nɛɛ, we bhla mɩ bɛda, 'ɩn we ka nyni, da a 'kaa lamumni, 'ɩn -ɔ -ka -mɩ, ɔ 'kaa ɔ da lʋmnɩ, 'ɩn a 'kaa -bha na 'dɛ -bhlo tɩ. Nɩɩ, we 'nɩ na 'dɛbhlo mɩ, Dide -yɔ 'mɩ 'sɔ mɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«-We mɩa dɛ ɩn gbaa aɩn -yla a 'ka 'wʋtʋtʋe -dlɔɔ 'yɩ 'mɩ 'wʋ. Sɩa a yia dʋdʋ -gʋ. Nɩɩ, a 'tɛmanɩ dlɩ: ɩn ka dʋdʋ lu.» ");
INSERT INTO kyf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nɩɩ, -Zezu bhɩa -we weee mɩa dɛɛ gbagbɩe, ɔ ylaa yalɩ, 'ɩn ɔ yia -Lagɔ bhubhoe. Ɔ nɛɛ: «Dide, we bhla ka nyni. -Slolu -na 'Yuu 'ŋnɩylilo, 'ɩn -na 'Yu 'ka -na 'ŋnɩylilo -slolu. ");
INSERT INTO kyf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nɩɩ, -ɩn ka ɔ 'yoo 'nyɛ nyɩma weee -gʋ. 'Ɩn waa nyɩma weee -wa -ɩn 'nyɛa ɔ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, ɔ 'ka we -maa 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nɩɩ, nyɩma -ka -mɩ -yi, -mɩ, -ɔ ka 'dɛ -bhlo mɩa -Lagɔɔ 'zayli nya, 'ɩn wa -ka -Zezu Klisɩ, -ɔ -ɩn tiea -yi nɩ, mʋ -wa 'yliyɔgagɩe -we 'nɩa bhloluda -ka. ");
INSERT INTO kyf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ɩn ka -na 'ŋnɩmnɩe -slolu dʋdʋ -gʋ, 'ɩn lubho, -we -ɩn 'nyɛa 'mɩ, ɩn ka we bhɩa. ");
INSERT INTO kyf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dide, dʋdʋ 'nɩa -slɔ la -mɩ, na 'ŋnɩ mnɩa 'cɩn -na -gbɛ. Nɩɩ, 'nyɛ -slɛɛn 'mɩ wee 'ŋnɩmnɩe -bhlokpadɛ -mɩ kwesi. ");
INSERT INTO kyf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Nɩɩ, nyɩma -wa -ɩn -saa -bha dʋdʋgʋ -nyɩma glaa, 'ɩn -ɩn yia 'mɩ wa 'nyɛ, ɩn ka -maa -na 'ŋnɩ -slolu. Wa mɩ -na -nʋ nya, 'ɩn -ɩn yia wa 'mɩ 'nyɛ, 'ɩn wa yia -na wɛlɩ 'nʋŋwɛ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","-Slɛɛn, wa -yi we 'ji nɩɩ, -we weee -ɩn 'nyɛa 'mɩ, -na -gbɛ we bhʋa. ");
INSERT INTO kyf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","-We ka gbʋ -wa, wɛlɩ -ɩn zʋa 'mɩ ŋwɛɛ, ɩn gbaa we wa -yla, 'ɩn wa yia we -yɔŋwnu. 'Ɩn wa ka we yibheli sazɔnʋ sa nɩɩ, -na -gbɛɛ na bhʋa, 'ɩn wa yia dlɩ zʋ nɩɩ, -mɩ tiea 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Nɩɩ, wa 'gbʋ na bhubhoea -mɩ. Ɩn 'nɩ dʋdʋgʋ -nyɩmaa 'gbʋ -mɩ bhubhoeda -mɩ, nɩɩ, -wa -ɩn 'nyɛa 'mɩ, wa 'gbʋ na bhubhoea -mɩ. -We ka gbʋ -wa, wa mɩ -na -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nɩɩ, -wa weee mɩa na -nʋ nya, wa mɩ -na -nʋ nya. 'Ɩn nyɩma weee mɩa -na -nʋ nya, wa mɩ na -nʋ nya, 'ɩn wa mnɩnɩa na 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wamɩa mɩa, dʋdʋ -gʋ wa yia -slɔ -gwlɛa, nɩɩ, -amɩ mɩa, ɩn 'na 'ka dʋdʋ -gʋ -gwlɛ: -na -gbɛ na yia mnɩa. -Mɔwlʋ -Dide, zʋ wa 'yliyɔ -na 'ŋnɩɩ 'tɩtɛ nya, 'ŋnɩ -we -ɩn 'nyɛa 'mɩ, wa 'ka 'wʋtʋ -bhlo, sa -amɩ -yɔ -mɩ 'sɔ mɩa -bhlo 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bhla -we nya ɩn mɩa wa glaa, ɩn ka wa 'yliyɔzʋ -na 'ŋnɩɩ 'tɩtɛ nya, 'ŋnɩ -we -ɩn 'nyɛa 'mɩ. Ɩn ka wa 'yliyɔzʋ, 'ɩn nyɩmɛ yabhlogbɔɔ 'nɩ mnɔ wa glaa, we 'nɩ -ɔ 'kaa mnɔ 'wʋbhʋ. Mɔ 'kaa mnɔ, 'ɩn -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, we 'ka lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«'Ɩn -slɛɛn, ɩn mɩ -na -gbɛ mnɩda. Da ɩn mɩa -slɔ dʋdʋ -gʋ, wɛlɩnya nɩ na gbaa, wa 'ka na 'mʋna dlɩ 'wʋ -ka, 'ɩn we 'ka -bha -gʋzi. ");
INSERT INTO kyf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɩn ka wa -na wɛlɩ 'nyɛ, 'ɩn dʋdʋgʋ -nyɩma yia wa 'wʋnyɛ. -Maa -yɔ wa 'sɔ 'nɩ -mɩ -bhlo, 'sa -bhlokpadɛ ɩn -yɔ dʋdʋgʋ -nyɩma 'nɩa -mɩ -bhlo, we 'dɛɛ 'gbʋ wa yia -maa 'wʋnyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ɩn 'nɩ -mɩ bhubhoeda -mɩ nɩɩ, -ɩn 'ka wa dʋdʋ -gʋ -sa. -Ɩnnya, nɩɩ, bhubhoe na bhubhoea -mɩ -ɩn 'ka wa 'yliyɔzʋ gbʋnyuuu dide kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wa -yɔ dʋdʋgʋ -nyɩma 'sɔ 'nɩ -mɩ -bhlo, -amɩ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","-Sa wa dʋdʋgʋ -nyɩma kwesi -na 'dɛ -yla gbʋzɔnʋ nya. Nɩɩ, -na wɛlɩ mɩ gbʋzɔnʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sa -ɩn tiea 'mɩ dʋdʋgʋ -nyɩmaa -gbɛ, 'sa -bhlokpadɛ na tiea na 'bɩnɔnya dʋdʋgʋ -nyɩmaa -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na 'dɛ na wlaa -mɩ -yla wa 'gbʋ, 'ɩn wa 'ka 'ya -mɩ -yla -mɩ 'piɛɩn. ");
INSERT INTO kyf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Nɩɩ, ɩn 'nɩ -maa 'dɛbhloo 'gbʋ bhubhoeda -mɩ. Bhubhoe na bhubhoe 'yaa nyɩma -wa yia -maa wɛlɩɩ 'gbʋ 'mɩ dlɩ -gʋ zʋa, wa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bhubhoeda ɩn mɩa wa 'dɛ weee 'ka -mɩ -bhlo, nɛɛ -mɩ -amɩ 'wʋ, 'ɩn -amɩ -mɩ 'wʋ, nɩɩ, Dide, wa -yɔ -aɩn 'sɔ -mɩ -bhlo. We -ka 'sa -mɩ nɩ, 'ɩn dʋdʋgʋ -nyɩma zʋa dlɩ nɩɩ, -mɩ tiea 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Ŋnɩmnɩe -we -ɩn 'nyɛa 'mɩ, ɩn ka we wa 'nyɛ, wa 'ka -mɩ -bhlo, -amɩ -yɔ -mɩ 'sɔ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","-Amɩ mɩ wa 'wʋ, 'ɩn -mɩ mɩ -amɩ 'wʋ, we -ka 'sa -mɩ nɩ, -bhlo wa yia -mɩa sazɔnʋ sa. 'Ɩn wa -ka -slɛɛn -bhlo -mɩ, 'ɩn dʋdʋgʋ -nyɩma yibhelia we 'ji nɩɩ, -ɩn ka 'mɩ tie, 'ɩn sa -ɩn -kalɩa na zɛ, 'sa -ɩn -kalɩa wa zɛ. ");
INSERT INTO kyf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Dide, dʋdʋ 'nɩa -slɔ la -mɩ, -ɩn -kalɩ na zɛ, we 'dɛɛ 'gbʋ -ɩn yia 'mɩ 'ŋnɩmnɩe 'nyɛ. -Slɛɛn, ɩn 'yɩbha nɩɩ, -maa -ɩn 'nyɛa 'mɩ, wa -yɔ 'mɩ 'sɔ -mɩ 'ya da na mnɩa, wa 'ka wee 'ŋnɩmnɩe -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Dide tɩklɩɩ, dʋdʋgʋ -nyɩma 'nɩ -mɩ -yi, nɩɩ, -amɩ -yi -mɩ, 'ɩn na 'bɩnɔnya -yia we 'ji nɩɩ, -mɩ tiea 'mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ɩn ka wa -na 'ŋnɩ -slolu, 'ɩn -sloluda na yia we -tʋa, 'ɩn sa -ɩn -kalɩa na zɛ, wee zɛkalɩe 'ka wa 'wʋ -mɩ, 'ɩn -amɩ 'ka wa 'wʋ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","-Zezu bhɩa -Lagɔ bhubhoe, ɔ -yɔ ɔ 'bɩnɔnya -sɔa 'wʋ, 'ɩn wa yia mnɩ. Wa mɩa mnɩda, -gbʋa -we wa laa Sedlɔn, 'ɩn wa yia we 'wʋdɩ. Nɩɩ, su -kpaa yabhlo mɩ -mɔ, -bha -Zezu -yɔ ɔ 'bɩnɔnya plaa. ");
INSERT INTO kyf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudasɩ, -ɔ mɩa -Zezu wlada, ɔ -yi -mɔ da, -we ka gbʋ -wa, -mɔ -Zezu -yɔ ɔ 'bɩnɔnya gbelia 'wlu zlɩ tɔlʋaa zlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nɩɩ, -Lagɔbudu 'kadʋʋ ŋwɛkʋnya -wa *-Lagɔbʋbɔnyaa -cɩan -yɔ Falizɩnyɩma tiea, we -yɔ Wlɔmʋ -slʋja, Zudasɩ -galɩ wa 'yu, 'ɩn wa yia wee su -kpaa mnɩ. Wa 'kaa -mɔ nyni nɩ, wa -yɔ 'napɛ -yɔ ylɔ yia yi, -zugba 'slʋja ka tʋgʋgblɛ kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","-We weee 'kaa -Zezu ylɩ, ɔ 'dɛ -yi we, we 'dɛɛ 'gbʋ ɔ yia wa gbɛgbɛɩn mnɩ, 'ɩn ɔ yia wa layɩbhaɛ: «'Lee, nyɔɔ ka da a talɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wa nɛɛ: «Nazalɛtɩyu -Zezu, ɔ da -a mɩa -talɩda.» Ɔ nɛɛ wa -ylaɛ: «-Amɩ -wa.» (-Zugba Zudasɩ, -ɔ mɩa ɔ wlada, mɩ -maa glaa.) ");
INSERT INTO kyf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Da -Zezu gbaa wa -yla: «-Amɩ -wa» nɩ, waa 'slʋja yilia gwe tɔʋn, 'ɩn wa yia bhli. ");
INSERT INTO kyf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɔ yia wa layɩbha -zakpa 'sɔɛ: «Nyɔɔ ka da a talɩa?» 'Ɩn wa nɛɛ: «Nazalɛtɩyu -Zezu, ɔ da -a mɩa -talɩda.» ");
INSERT INTO kyf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'Ɩn -Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «Ɩn ka we aɩn -yla gba pepe, -amɩ -wa. Nɩɩ, we -ka na da a mɩ -talɩda, a 'tide -maa mɩa dɛ 'yi, wa 'ka mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","-We mɩa da, 'mʋ ɔ gbaa, ɔ wɛlɩ -we ɔ gbaa 'cɩn we 'ka lɛnʋʋ 'gbʋ: «Dide, nyɩma -wa -ɩn 'nyɛa 'mɩ, nyɩmɛ yabhlogbɔɔ 'nɩ mnɔ wa glaa.» ");
INSERT INTO kyf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nɩɩ, Simɔ Piɛlɩ ka tʋgʋgblɛ kwɛɛ. Ɔ -saa we we tʋkpa 'wʋ, 'ɩn ɔ yia -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zɔlubhonʋnyɔ we pa, 'ɩn ɔ yia -mɔɔ lilikwɛ -yukwli -bha -dɩ. (Ɔɔ zɔlubhonʋnyɔ wa laa Malɩkusɩ.) ");
INSERT INTO kyf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nɩɩ, -Zezu nɛɛ ɔ -yla: «Fa -na tʋgʋgblɛ we tʋkpa 'wʋ. -Mɩ dlɩ 'wʋ, sɩasɩe 'kadʋ -we Dide dɩa 'mɩ -yla la, ɩn 'nɩa we zɔ 'yligbea yi -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Waa 'slʋja -yɔ wa 'yugalɩnyɔ, we -yɔ Zuifʋʋ -Lagɔbudu 'kadʋʋ ŋwɛkʋnya kpaa -Zezu, 'ɩn wa yia ɔ gbʋan. ");
INSERT INTO kyf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nɩɩ, Anasɩɩ -gbɛ wa kwaa -ɔ tɩa. -We ka gbʋ -wa, Anasɩ -wa Kaifʋʋ 'ŋwnɔɔ dide. Wee -zʋ nya, Kaifʋ -wa *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ. ");
INSERT INTO kyf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nɩɩ, Kaifʋ zʋa Zuifʋʋ 'yugalɩnya 'dɩ, ɔ nɛɛ: «We nanɩ 'yli nɩɩ, nyɩmɛ -bhlo tlɩ -amɩaa nyɩmaa 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔ Piɛlɩ -yɔ -Zezuu 'bɩnɔnyɔ yabhlo yia -Zezu 'bɩ mnɩ. Nɩɩ, -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yi ɔɔ -Zezuu 'bɩnɔnyɔ yabhlo -mɔnɩ, we 'dɛɛ 'gbʋ -mɔɔ -yɔ -Zezu 'sɔ yia ɔɔ -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ -buduŋwɛɛ pla. ");
INSERT INTO kyf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nɩɩ, Piɛlɩ yia 'pipee -tʋ, 'yoo ŋwɛɛ. Tɔʋn, ɔɔ -Zezuu 'bɩnɔnyɔ yabhlo, -ɔ -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yia, 'ɩn -mɔɔ yia 'tla. Ɔ gbaa 'yoo ŋwɛkʋŋwnɔ -yla gbʋ, 'ɩn ɔ yia Piɛlɩ -plalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɔɔ 'yoo ŋwɛkʋŋwnɔ nɛɛ Piɛlɩ -ylaɛ: «Ɔɔ nyɩmɛɛ 'bɩnɔnyɔ yabhlo -ɩn -mɩa, we 'nɩ mʋʋ?» Piɛlɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Ɩnnya, -gba! -gba!» ");
INSERT INTO kyf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nɩɩ, ŋwɔtlɔ mɩ yida. We 'dɛɛ 'gbʋ lubhonʋnya -yɔ -Lagɔbudu 'kadʋʋ ŋwɛkʋnya yia -kosu 'yidɩ, -zugba wa wɔlɔ. Piɛlɩ mɩ 'ya wa glaa 'wɔlɔda -kosu -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nɩɩ, -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ mɩ -Zezu layɩbhada, ɔ 'bɩnɔnya -yɔ -we ɔ slolua -gʋ. ");
INSERT INTO kyf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ɔ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Ɩn ka nyɩma weee -yla gba -zejila 'wʋ. Nɩɩ, 'ylɩ weee nya na slolua -Lagɔbudunya zɔ we -yɔ -Lagɔbudu 'kadʋ zɔ da Zuifʋ weee gbelia 'wlu. Ɩ'ɩn gba gbʋ yabhlogbɔɔ 'wiemɩ. ");
INSERT INTO kyf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'Lee, -amɩ -na yɩbhaa la yɩ? Nyɩma -wa ɩn -slolua, wa -yi -we ɩn gbaa, 'yɩbha we wa la.» ");
INSERT INTO kyf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","-Zezu gbaa -we mɩa dɛ nɩ, -Lagɔbudu 'kadʋʋ ŋwɛkʋnyɔ yabhlo mɩa -bha, ɔ bɛa ɔ -yɔ, 'ɩn ɔ yia ɔ 'kpa yukwli 'wʋ sʋbha. 'Ɩn ɔ nɛɛ -Zezu -ylaɛ: «'Lee, sanɛɛ -na gbaa -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yla yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ɔ nɛɛ -buduu ŋwɛkʋnyɔ -ylaɛ: «'Lee, gbʋ 'nyuu -mʋmʋ ɩn gbaa, -slolu 'mɩ we 'klʋ, 'ɩn we -ka nɩɩ, ɩn 'nɩ gbʋ 'nyuu gba nɩ, lɛɛ -lu ka 'gbʋ -na pa 'mɩ -lua?» ");
INSERT INTO kyf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tɔʋn, 'ɩn Anasɩ yia 'slʋja 'yoo 'nyɛ, wa 'ka -Zezu -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Kaifʋʋ -gbɛ kwa, -zugba ɔ mɩ gbʋanda. ");
INSERT INTO kyf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nɩɩ, Simɔ Piɛlɩ mɩ wee -buduŋwɛɛ 'wɔlɔda. Wa nɛɛ ɔ -ylaɛ: «-Mɩ mɩa 'dɛ ɔɔ nyɩmɛɛ 'bɩnɔnyɔ yabhlo -ɩn -mɩa, we 'nɩ mʋʋ?» Ɔ kpɛlɩa we, ɔ nɛɛ: «-Ɩnnya, yo -wa yo!» ");
INSERT INTO kyf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","-Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ gaylo yabhlo mɩ -bha, nyɩmɛ -ɔ ka yukwli Piɛlɩ -dɩa -bha, ɔ kʋda -nyɩmɛ yabhlo -wa. Ɔɔ lubhonʋnyɔ nɛɛ Piɛlɩ -yla: «Nɩɩ, -mɩ ɩn 'yɩa da su -kpaa, -ɩn -yɔ -Zezu 'sɔ, we 'nɩ mʋʋ?» ");
INSERT INTO kyf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nɩɩ, 'ɩn Piɛlɩ yia we -zakpa tanʋ kpɛlɩ. Wee kpɛlɩe mɩ ɔ ŋwɛɛ, 'ɩn -kʋkɔ yia -bha -bhlokpadɛ gbogboe bhli. ");
INSERT INTO kyf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nɩɩ, we 'bɩgʋ, wa -yɔ -Zezu yia Kaifʋʋ -gbɛ 'bhʋ. *Wlɔmʋ -nyɩmɛ Pilatɩ, -ɔ pɩlɩa Zuifʋʋ dʋdʋ 'wlu la, -mɔɔ -buduŋwɛɛ wa kwaa ɔ. Zlʋkpɛ tutu -wa, Zuifʋʋ 'yugalɩnya 'nɩ wee -budu zɔ pla. Wa -ka -mɔ pla, -zugba wa ka pʋɩn pla wa tite 'yu. 'Ɩn wa -ka pʋɩn -ka nɩ, wa 'nɩ mneni wa 'ka *'Wʋzɩtɩylɩɩ 'fɛtɩ -gʋ -lu li. ");
INSERT INTO kyf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","We 'dɛɛ 'gbʋ wa yia 'pipee -tʋ, 'ɩn Pilatɩ, -ɔ pɩlɩa Zuifʋ 'wlu la yia 'tla. Ɔ nynia wa -yɔ la, 'ɩn ɔ yia wa layɩbha: «'Lee, gbʋ -mʋmʋ a dɩlɩ nyɩmɛ nɩa?» ");
INSERT INTO kyf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wa 'palɩa we 'bɩgʋ, wa nɛɛ ɔ -ylaɛ: «-A -ka -mɩ nyɩmɛ mɩa dɛ -la nɩ, -zugba gbʋnyumonyɔ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatɩ nɛɛ wa -ylaɛ: «Amɩaa 'dɛ 'bhu ɔ 'wʋ, 'ɩn a 'ka ɔ -yɔgbʋ 'wʋbhu amɩaa titee sɔlʋ.» Tɔʋn, 'ɩn wa nɛɛ: «We -ka nyɩmɛɛ -yɔgbʋ -a 'bhu 'wʋ, -a 'nɩ we 'klʋ -ka, -a 'ka ɔ tlɩtlɩe -dɩlɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","'Sa -mʋʋ 'plɩa, -Zezuu wɛlɩ 'ka gbʋzɔnʋ -zɛɛ 'gbʋ. Sa ɔ 'kaa tlɩ, wee wɛlɩ ka we -slolu. ");
INSERT INTO kyf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatɩ plaa -budu zɔ, 'ɩn ɔ yia -Zezu la. -Mɔɔ bɛa ɔ 'yu, 'ɩn ɔ nɛɛ ɔ -yla: «'Lee, Zuifʋʋ 'wlulapɩlɩnyɔ -ɩn -mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","-Zezu 'palɩa we 'bɩgʋ, ɔ nɛɛ: «Lɛɛ -lu ka 'gbʋ -na yɩbha 'mɩ we laa? 'Lee, -na 'dɛ yɩbhaa 'mɩ we la yaayɩɩ, nyɩma -putu la 'saa 'mɩ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatɩ nɛɛ: «'Lee, Zuifʋ ɩn -mɩa yɩ? Nɩɩ, -na 'dɛɛ Zuifʋbhelia -yɔ -Lagɔbʋbɔnyaa -cɩan ka -mɩ 'mɩ -la. 'Lee, lɛɛ -lu -ɩn nʋ lɛa?» ");
INSERT INTO kyf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ɔ nɛɛ: «Na 'wlulapɩlɩee se mɩa, we'e 'bhʋ dʋdʋgʋ -nyɩmaa -gbɛ. We -ka yaa wa -gbɛ we 'bhʋ nɩ, -zugba na lubhonʋnya ka yaa jɛlɩgba gʋ, -mʋʋ yi 'wlʋ nɩɩ, Zuifʋʋ 'yugalɩnya kpa 'mɩ. Nɩɩ, -ɩnnya, we'e 'bhʋ dʋdʋgʋ -nyɩmaa -gbɛ.» ");
INSERT INTO kyf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatɩ nɛɛ ɔ -ylaɛ: «Nɩɩ, nyɩmaa 'wlulapɩlɩnyɔ -ɩn -mɩa, we 'nɩ mʋʋ?» Ɔ nɛɛ: «'Mʋ -ɩn gbaa dɛ. We 'dɛɛ 'gbʋ wa yia 'mɩ gwalɩ. Ɩn 'ka gbʋzɔnʋʋ dayɩnyɔ nya -mɩɩ 'gbʋ ɩn yia dʋdʋ -gʋ yi. -Wa weee mɩa gbʋzɔnʋʋ -nʋ nya, na wɛlɩ wa pʋlʋa yukwli.» ");
INSERT INTO kyf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatɩ nɛɛ: «Gbʋzɔnʋ, lɛɛ -lu we -mɩa?» Pilatɩ bhɩa -we mɩa dɛ gbagbɩe, 'ɩn ɔ yia -budu zɔ 'tla. Ɔ mnɩa 'pipee Zuifʋʋ -gbɛ, ɔ nɛɛ wa -ylaɛ: «Nɩɩ, -we ka 'gbʋ ɩn 'kaa nyɩmɛ nɩ gbʋ dɩlɩ, ɩ'ɩn 'yɩ we -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amɩaa lɛnʋgbʋ 'cɩn 'yɩbha nɩɩ, ɩn 'tide -kaslʋnyɩmɛ yabhlo 'yi 'Wʋzɩtɩylɩɩ 'fɛtɩɩ bhla. 'Lee, a 'yɩbha nɩɩ, ɩn 'tide aɩn -yla Zuifʋʋ 'Wlulapɩlɩnyɔ 'yii?» ");
INSERT INTO kyf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wa 'kpɩa 'wʋ, wa nɛɛ: «-Ɩnnya! -Ɩn 'na 'tide -mɔɔ mɩa dɛ 'yi -nɩ. 'Tide -Balabasɩ 'yi -aɩn -yla!» -Zugba ɔɔ -Balabasɩ mɩa, nyɩmɛ 'nyuuu 'dɛbhie -wa. ");
INSERT INTO kyf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tɔʋn, 'ɩn Pilatɩ nɛɛ wa -yla nɩɩ, wa 'bhu -Zezu 'wʋ wa 'ka ɔ sɛlɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'Slʋja maa 'wia -kloo, 'ɩn wa yia we -Zezu 'wluo -pla. 'Ɩn wa yi 'yaa ɔ -bana zalʋ 'wʋpla, nyɩmaa 'wlulapɩlɩnyɔ 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wa -ka ɔ -yɔ lanyni -bhlo, -zugba wa nyanɩa ɔ. Wa nɛɛ ɔ -ylaɛ: «Zuifʋʋ 'wlulapɩlɩnyɔ, -na fʋʋ.» 'Ɩn wa sʋbhaa ɔ 'kpa yukwli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatɩ 'tlaa lʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «A pʋ yukwli -nya, nɩɩ, lʋ na laa ɔ aɩn 'pipee, 'ɩn a 'ka we 'wʋlanʋ nɩɩ, -we ka 'gbʋ ɩn 'kaa nyɩmɛ nɩ gbʋ dɩlɩ, ɩ'ɩn 'yɩ we -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tɔʋn, 'ɩn -Zezu yia 'tla, ɔ ka wee -bana zalʋ 'wʋ, 'ɩn 'wia -kloo mɩa ɔ 'wluo. 'Ɩn Pilatɩ nɛɛ wa -ylaɛ: «Ɔɔ nyɩmɛ nɩ!» ");
INSERT INTO kyf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","-Lagɔbʋbɔnyaa -cɩan -yɔ -Lagɔbudu 'kadʋʋ ŋwɛkʋnya 'yɩa -Zezu -yɔ, 'ɩn wa yia 'wʋkpɩkpɩe bhli. Wa nɛɛ: «Kʋlʋ ɔ *su -gʋ la! Kʋlʋ ɔ su -gʋ la!» Pilatɩ nɛɛ wa -ylaɛ: «Amɩaa 'dɛ 'bhu ɔ 'wʋ, 'ɩn a 'ka ɔ su -gʋ lakʋlʋ. Nɩɩ, -we ka 'gbʋ ɩn 'kaa ɔ gbʋ dɩlɩ, ɩ'ɩn 'yɩ we -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zuifʋ nɛɛ ɔ -yla: «-A ka tite yabhlo, 'ɩn wee tite nɛɛ nɩɩ, wa 'bha ɔ, -we ka gbʋ -wa, ɔ nɛɛ nɩɩ, -Lagɔɔ 'Yu ɔ -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Da Pilatɩ 'nʋa wa wɛlɩ nɩ, 'ɩn ɔ nyanɔ yia -gʋbho. ");
INSERT INTO kyf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɔ plaa -budu zɔ, 'ɩn ɔ yia -Zezu layɩbha: «Mɔ -na bhʋa?» Nɩɩ, -Zezu 'nɩ we 'yabhlogbɔɔ 'bɩgʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tɔʋn, 'ɩn Pilatɩ nɛɛ ɔ -ylaɛ: «-Ɩ'ɩn sɩsalɩ ŋwɛ -gʋ -amɩ -ylaa? -Amɩ, ɩn ka we se ɩn 'ka -mɩ 'yitide, 'ɩn ɩn ka 'ya we se ɩn 'ka -mɩ su -gʋ la kʋlʋ, 'lee, -ɩn 'nɩ we 'ji -yi -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","-Zezu nɛɛ ɔ -yla: «-Ɩn 'nɩ -lu yabhlogbɔɔ se -ka 'mɩ -gʋ, we 'nɩ -we ka se -Lagɔ 'nyɛa -mɩ 'wʋbhʋ. We 'dɛɛ 'gbʋ -mɔmɔ -laa 'mɩ -mɩ 'yu, ɔ gbʋnyuu 'yli we 'ka -na -nʋ -zi.» ");
INSERT INTO kyf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wee wɛlɩ nɩɩ 'bɩgʋ, Pilatɩ 'yɩbha yaa ɔ 'ka -Zezu 'yitide, 'ɩn Zuifʋ yia 'wʋkpɩkpɩe bhli. Wa nɛɛ: «-Ɩn -ka nyɩmɛ mɩa dɛ 'yitide nɩ, -zugba -ɩn 'nɩ Wlɔmʋʋ 'wlulapɩlɩnyɔ 'kadʋʋ 'tale! Nɩɩ, nyɩmɛ -ɔ -ka gba: ‹Nyɩmaa 'wlulapɩlɩnyɔ ɩn -mɩa› -zugba -mɔɔ mɩ nyɩmaa 'wlulapɩlɩnyɔ 'kadʋʋ tʋnyɩmɛ nya.» ");
INSERT INTO kyf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatɩ 'nʋa wɛlɩnya nɩ, 'ɩn ɔ yia -Zezu la ɔ 'ka 'tla. We 'bɩgʋ, 'ɩn Pilatɩ yia gbʋwʋbhukpe -gʋ ladɩ. -Buduŋwɛɛɛ da -lɛ wa mnazɩa la tʋkpa nya, -bha -wa. 'Mʋ wa laa «Gabata» zuifʋwɛlɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nɩɩ, 'ylɩ -we nya wa mnazɩa wa 'dɛ la 'Wʋzɩtɩylɩɩ 'fɛtɩɩ 'gbʋ, wee ylɩ -wa. 'Ylʋ nynia -glɔnyɩdɩ, 'ɩn Pilatɩ nɛɛ Zuifʋ -yla: «Amɩaa 'wlulapɩlɩnyɔ nɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'Ɩn wa yia 'wʋkpɩkpɩe bhli. Wa nɛɛ: «'Bha ɔ! 'Bha ɔ! Kʋlʋ ɔ su -gʋ la!» Pilatɩ nɛɛ wa -ylaɛ: «'Lee, ɩn kʋlʋ amɩaa 'wlulapɩlɩnyɔ su -gʋ laa?» 'Ɩn -Lagɔbʋbɔnyaa -cɩan yia we 'bɩgʋpalɩɛ: «-Amɩaa 'wlulapɩlɩnyɔ -bhlogbɔɔ, Wlɔmʋʋ 'wlulapɩlɩnyɔ 'kadʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tɔʋn, 'ɩn ɔ yia wa -Zezu yoo 'nyɛ, wa 'ka ɔ su -gʋ lakʋlʋ. 'Ɩn wa -yɔ -Zezu 'sɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wa 'kaa 'gbe 'tla nɩ, su -we -gʋ wa 'kaa ɔ la kʋlʋ, ɔ 'dɛ ka we -blɩgba. Wa mɩ mnɩda, 'ɩn wa yia da -we wa laa 'Wluu 'Kʋaa da nyni. (-Bha wa laa «Gɔlʋgota» zuifʋwɛlɩ 'wʋ.) ");
INSERT INTO kyf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","-Bha 'slʋja kʋlʋa -Zezu su -gʋ la. 'Ɩn wa yi 'yaa nyɩma -putu 'sɔ su -gʋ lakʋlʋ. 'Yabhlo mɩ -Zezuu lilisɔlʋ, 'ɩn 'yabhlo mɩa ɔ kɔpɛsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɩ nʋa su falʋ lɛ, 'ɩn wa yia we -Zezuu su -gʋ lakʋlʋ. Wee su falʋ -gʋ ɔ cɛlɩa: ");
INSERT INTO kyf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nɩɩ, Zuifʋ duun zɛlɩa -we mɩa wee su falʋ -gʋ cɛlɩda. -We ka gbʋ -wa, da wa zʋa -Zezu su -gʋ, -bha cɩpa 'gbe 'kadʋ -yɔ, 'ɩn wa cɛlɩ we -zakpa ta: tɩa zuifʋwɛlɩ 'wʋ, we 'bɩgʋ wlɔmʋwɛlɩ 'wʋ, 'bhie glɛkɩwɛlɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","*-Lagɔbʋbɔnyaa -cɩan zɛlɩa we, -bha wa mnɩa Pilatɩɩ -gbɛ, 'ɩn wa nɛɛ ɔ -ylaɛ: «-Mɩ cɛlɩa: ‹Zuifʋʋ 'Wlulapɩlɩnyɔ› nɩɩ, we 'nɩ mneni we 'ka 'sa -tʋ! -Ɩn cɛlɩ nɩɩ: ‹Nyɩmɛ nɩ nɛɛ: -Amɩ -wa Zuifʋʋ 'wlulapɩlɩnyɔ.› » ");
INSERT INTO kyf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatɩ 'palɩa we 'bɩgʋ, ɔ nɛɛ: «-We ɩn cɛlɩa, cɛlɩda we tʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Da 'slʋja kʋlʋa -Zezu su -gʋ la, 'ɩn wa yia ɔ 'wʋplali dlili. Wa dlili we 'wʋ la -mnʋa, 'slʋjayu -mɔmɔ -ka -mɩ, -mɔɔ ka -mɔɔ -nʋ. 'Ɩn wa yi 'yaa ɔ -banaa zɔbana -zɔnʋ 'wʋbhu. Nɩɩ, wee -bana mɩ lʋada 'naa kibhe -bhlo nya, we 'bhʋ -blɩ -yɔ we 'ka bhʋ -yɔ nyni. We 'nɩ pɩpɛda -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «-A 'na ylalɩ wee -bana -zɔnʋ -nɩ, nɩɩ, -a 'pa -nɩgbɩ, 'ɩn -ɔ ka -nʋ -yɔ we -ka -tʋ nɩ, -mɔɔ 'ka we 'wʋbhu.» Nɩɩ, 'sa -we mɩa -Lagɔsɛbhɛ 'wʋ cɛlɩda 'kaa sa 'plɩ. We nɛɛ: «Wa ka na 'wʋplali dlili wa 'dɛkpʋa nyɩdɩ. 'Ɩn wa yia -nɩgbɩ 'pa, -ɔ yia na -bana 'bhaa, wa 'ka ɔ yibheli.» Nɩɩ, -we 'slʋja nʋa lɛ, mʋ mɩa dɛ. ");
INSERT INTO kyf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","-Zugba -Zezuu 'nyaa klaa, ɔ 'nyaa bhɔlɔ klaa, Klopasɩɩ 'ŋwnɔ Malii klaa, we -yɔ Magɩdala -ŋwnɔ Malii mɩ -bha wee *su kwesi. ");
INSERT INTO kyf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nɩɩ, 'ɩn -Zezu yia ɔ 'nyaa -yɔyɩ. Ɔ 'bɩnɔnyɔ yabhlo -ɔ ka zɛ ɔ -kalɩa, -mɔɔ mɩ ɔ 'nyaa kwesi. 'Ɩn ɔ nɛɛ: «'Maa, amaa yu nɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","We 'bɩgʋ, ɔ nɛɛ 'bɩnɔnyɔ -ylaɛ: «-Na 'nyaa nɩ.» Tɔʋn, we 'bhʋ -bha 'wʋ, 'ɩn ɔɔ 'bɩnɔnyɔ yia ɔ, ɔ 'dɛɛ -gbɛ bɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","We 'bɩgʋ, -Zezu -yi -slɛɛn we 'ji nɩɩ, -lu weee ka gba. 'Ɩn -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, we 'ka lɛnʋʋ 'gbʋ, ɔ nɛɛ: «Ɩn 'ka 'ma.» ");
INSERT INTO kyf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wee da mɩa, kalɔ nʋʋ nyida mɩ -bha. Wa faa -fuu wee kalɔ nʋ lʋ, wa bɩzɩa we suu 'yliya 'wʋ, 'ɩn wa yia we -Zezuu ŋwɛ -yɔ bɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nɩɩ, ɔ 'maa wee kalɔ nʋ nɩ, we 'bɩgʋ, ɔ nɛɛ: «We ka bhɩa!» Ɔ -laa 'wlu zɔ tɔʋn, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nɩɩ, 'ylɩ -we nya wa mnazɩa wa 'dɛ la wa Nyapɛylɩɩ 'gbʋ, wee ylɩ -wa. Wee *Nyapɛylɩ mɩa, 'ylɩ -zɔnʋʋ 'dɛbhie -wa. We 'dɛɛ 'gbʋ Zuifʋ 'nɩ 'yɩbha nɩɩ, 'kwie -tʋ su -gʋ wee Nyapɛylɩ nya. We 'gbʋ wa 'yugalɩnya yia Pilatɩ 'yoo -zlalɩa mnɩ, wa 'ka waa nyɩmaa bhʋ 'kate, 'ɩn wa 'ka wa 'kwie su -gʋ -sa. ");
INSERT INTO kyf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tɔʋn, wee da wa kʋlʋa waa nyɩma su -gʋ la, 'ɩn 'slʋja yia -mɔ mnɩ. Wa nynia -mɔ nɩ, 'ɩn wa yia waa nyɩma sɔ 'sɔ lʋ mɩa -Zezu kwesi bɛ. Wa 'katea yabhloo bhʋnya, 'bhie, wa yia 'sɔnʋʋ -nʋ 'kate. ");
INSERT INTO kyf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wa nynia -Zezu -yɔ la, 'ɩn wa yia we -yɔyɩ nɩɩ, ɔ ka tlɩ, we 'dɛɛ 'gbʋ wa 'nɩ ɔ bhʋnya 'kate. ");
INSERT INTO kyf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nɩɩ, 'ɩn 'slʋjayu yabhlo yia -Zezuu gbacɩ zɔ tnʋ ɔ 'li nya. -Bha -bhlokpadɛ 'pɩɔn -yɔ 'nyu 'tlaa ɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nyɩmɛ -ɔ mɩa -bha we zlɩ, 'ɩn -we 'plɩa, -ɔ 'yɩa we -yɔ, -mɔɔ -wa we dayɩnyɔ. Nɩɩ, wee gbʋnya nɩ ɔ gbaa, 'ɩn a 'ka 'ya we dlɩ -gʋ zʋ. Ɔ gbʋdayɩwɛlɩ mɩ gbʋzɔnʋ nya, 'ɩn ɔ -yi we 'ji nɩɩ, -we ɔ gbaa gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","-We weee mɩa dɛ 'plɩa, 'ɩn -we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋ, we 'ka lɛnʋ. We nɛɛ: «Wa 'na 'ka ɔ 'kʋa yabhlogbɔɔ 'kate.» ");
INSERT INTO kyf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","'Ɩn wee 'sɛbhɛɛ kibhe yabhlo nɛɛ: «'Ɩn, ylaa wa yia -ɔ ka gbacɩ -zɔ wa tnʋa.» ");
INSERT INTO kyf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nɩɩ, nyɩmɛ yabhlo wa laa *-Zɛzɛfʋ, Alimateyu -wa, ɔ mɩ -Zezuu 'bɩnɔnyɔ yabhlo nya zizewiemɩ. -We ka gbʋ -wa, ɔ mɩ Zuifʋʋ 'yugalɩnya sɔda. Ɔɔ nyɩmɛ nɩ mnɩa Pilatɩ 'yoo -zlalɩa ɔ 'ka -Zezuu 'kwie 'wʋbhu. 'Ɩn Pilatɩ yia we -yɔŋwnu. Tɔʋn, -Zɛzɛfʋ yia lʋ nɩ, 'ɩn ɔ yia -Zezuu 'kwie 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nyɩmɛ yabhlo wa laa 'Nikodɛmʋ, -mɔɔ yi 'yaa ɔ 'bɩ mnɩ. Nɩɩ, nyɩmɛ -ɔ mnɩa zlɩmɛ -Zezu 'yɩa sabɔ, mɔ -wa. Ɔ mɩa mnɩda, ɔ -yɔ -lasiklɔɔ bɔtɔlʋ -nʋ 'sɔ, 'ɩn wa yia mnɩ. 'Mʋ wa laa *milɩ -yɔ aluɛsɩ. We 'wʋwɔlʋe mneni we 'ka kilo glʋ -bhlo 'ya kugbua nyni. ");
INSERT INTO kyf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","-Zɛzɛfʋ -yɔ 'Nikodɛmʋ yia -Zezuu 'kwie 'wʋbhu. 'Ɩn wa yia ɔ 'naapɩnya -we wa slua wee bɔtɔlʋ -lasiklɔ -gʋ, -yɔ labibeli. Nɩɩ, 'sa Zuifʋ mnazɩa 'kwie -yɔ, 'bhie wa faa we gbawla 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Da wa kʋlʋa -Zezu *su -gʋ la, su -kpaa mɩ -bha. Wee su -kpaa, 'bhʋka -lolu, -we 'wʋ wa 'nɩa -slɔ 'kwie yabhlogbɔɔ fa, we mɩ -bha. ");
INSERT INTO kyf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nɩɩ, 'ylɩ -we nya Zuifʋ mnazɩa wa 'dɛ la wa Nyapɛylɩɩ 'gbʋ, wee ylɩ -waa 'gbʋ, 'ɩn wee 'bhʋka cɩpa -bhaa 'gbʋ, wa yia -Zezuu 'kwie -mɔ fa. ");
INSERT INTO kyf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nɩɩ, 'ylɩ 'plɩ -bhlo, we 'sɔnʋʋ zlɩgʋ, dimasɩɩ nya, da zlɩ 'nɩa -slɔ ladolu, 'ɩn Magɩdala -ŋwnɔ Malii yia gbawla -gʋ mnɩ. Nɩɩ, wa ka zlɩmɛ we kla tʋkpa -boklo 'kadʋ nya, 'ɩn Malii -talɩa -bha nɩ, ɔ 'nɩ wee tʋkpa -yɔyɩ we ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tɔʋn, 'ɩn ɔ -yɔ -gwagwɩe yia Simɔ Piɛlɩ -yɔ 'bɩnɔnyɔ yabhlo, -ɔ ka zɛ -Zezu -kalɩa, 'dɩ kwa. Ɔ nɛɛ wa -ylaɛ: «Wa ka -amɩaa -Kanyɔ gbawla 'wʋsa, 'ɩn da wa zʋa ɔ, -a 'nɩ -bha da -yi.» ");
INSERT INTO kyf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piɛlɩ -yɔ ɔɔ -Zezuu 'bɩnɔnyɔ yabhlo nɩ -sɔa 'wʋ, 'ɩn wa yia wee gbawla -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","-Gwagwɩe nya wa 'dɛsɔbhie mɩa -mɔ mnɩda. 'Ɩn ɔɔ 'bɩnɔnyɔ -mɔnɩɩ -gwagwɩe -zi Piɛlɩ. Mɔɔ nynia -mɔ tɩa. ");
INSERT INTO kyf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɔ kwlia 'wʋ, 'ɩn ɔ yia 'naapɩnya -yɔyɩ -bha lasluda, nɩɩ, ɔ 'nɩ -mɔ pla. ");
INSERT INTO kyf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ Piɛlɩ yia ɔ 'bɩ, ɔ nynia, ɔ plaa gbawla nʋkplɛ, 'ɩn ɔ yia -mɔ 'naapɩnya -yɔyɩ, -bha lasluda. ");
INSERT INTO kyf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɔ ka 'ya 'naa -we wa gbʋanɩa -Zezuu 'wlu -yɔla -yɔyɩ. Nɩɩ, wee 'naapɩ 'nɩ we -lima glaa -mɩ, we mɩ glɩda we 'dɛɛ saa da -putu. ");
INSERT INTO kyf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","-Mʋʋ 'bɩgʋ, 'bɩnɔnyɔ -ɔ nynia tɩa, ɔ yi 'yaa gbawla nʋkplɛ pla. Ɔ 'yɩa we -yɔ, 'ɩn ɔ yia dlɩ zʋ. ");
INSERT INTO kyf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nɩɩ, -we mɩa -Lagɔsɛbhɛ 'wʋ cɛlɩda, wa 'nɩ -slɔ we 'wʋlanʋ: nɩɩ, 'wʋ -Zezu yia -sɔa tlɩtlɩnya glaa.) ");
INSERT INTO kyf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tɔʋn, 'bɩnɔnya sɔbhie yia -buduŋwɛɛ lʋbhiti. ");
INSERT INTO kyf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nɩɩ, Malii mɩ -bha gbawla kwesi -zugba ɔ wi. Ɔ mɩ wida, 'ɩn ɔ yia 'wʋkwli ɔ 'ka gbawla nʋkplɛ 'ylilabhlɩ. ");
INSERT INTO kyf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'Ɩn ɔ yia -mɔ 'anzɩ 'sɔ -yɔyɩ ladɩda da wa palɩa -Zezuu 'kwie la. Yabhlo mɩ ɔ 'wluu 'bɩgʋ, 'ɩn yabhlo mɩa ɔ bhʋnyaa 'bɩgʋ. 'Wʋplalu 'pʋpa mɩa we 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nɩɩ, 'ɩn wee 'anzɩ yia Malii layɩbha. We nɛɛ: «Bhɔlɔ, lɛɛ -lu wili aɩn a?» Ɔ nɛɛ we -yla: «Wa ka na -Kanyɔ -bha lasalɩ, 'ɩn da wa zʋa ɔ, ɩn 'nɩ -bha da -yi.» ");
INSERT INTO kyf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɔ mɩ -we mɩa dɛ gbada, ɔ 'bhitia la, 'ɩn ɔ yia -Zezu -yɔyɩ, ɔ 'nɩ we 'jiyibheli nɩɩ, -Zezu -wa. ");
INSERT INTO kyf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Ɩn -Zezu yia ɔ layɩbha: «Bhɔlɔ, lɛɛ -lu ka 'gbʋ a wia? Nyɔɔ a nɔnʋ 'ylibɩla?» Maliii dlɩ 'wʋ nɩɩ, su -kpaaa lubhonʋnyɔ -wa. Tɔʋn, ɔ nɛɛ ɔ -ylaɛ: «-Na zukpa -wa, we -ka nɩɩ, -mɩ 'bhu ɔ 'kwie 'wʋ, gba 'mɩ -yla da -ɩn zʋa ɔ, 'ɩn ɩn 'ka ɔ 'bʋmnɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","-Zezu nɛɛ ɔ -ylaɛ: «Malii!» Malii 'bhitia ɔ gbɛgbɛɩn la, 'ɩn ɔ nɛɛ ɔ -yla zuifʋwɛlɩ 'wʋɛ: «Wlaboni!» We ji -wa: «-Slolunyɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ɔ nɛɛ ɔ -yla: «A 'na kpalɩ 'mɩ la -nɩ, ɩn 'nɩ -slɔ Didee -gbɛ mnɩɩ 'gbʋ. Nɩɩ, a mnɩ a 'ka na bhelia -yla gbaɛ: na Dide, -ɔ mɩa amɩaa Dide nya, na -Lagɔ, -ɔ mɩ 'yaa amɩaa -Lagɔ nya, ɔ -gbɛ na mnɩa.» ");
INSERT INTO kyf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tɔʋn, 'ɩn Magɩdala -ŋwnɔ Malii yia -Zezuu 'bɩnɔnyaa -gbɛ mnɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Ɩn ka -amɩaa -Kanyɔ 'yɩ!» 'Ɩn ɔ yia -we -Zezu gbaa ɔ -yla, we 'dɩ wa -salɩ. ");
INSERT INTO kyf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wee 'ylɩ -bhlokpadɛɛ jibheza, 'bɩnɔnya yia 'wlugbeli -budu zɔ. Nɩɩ, wa ka -buduu klolo -gbalɩ, wa mɩ Zuifʋʋ 'yugalɩnya sɔdaa 'gbʋ. 'Ɩn -Zezu yia wa glaa yi. Ɔ 'yligbe wa nyɩdɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «-Lagɔ 'nyɛ aɩn 'wʋtʋtʋe -dlɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɔ bhɩa we gbagbɩe, 'ɩn ɔ yia ɔ -kwɩtɛ wa 'klʋslolu, we -yɔ ɔ gbacɩ zɔ. Wa 'yɩa Nyɩmaa -Kanyɔ -yɔ, 'ɩn wa yia 'mʋna li. ");
INSERT INTO kyf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɔ nɛɛ wa -yla -zakpa 'sɔnʋ nyaɛ: «-Lagɔ 'nyɛ aɩn 'wʋtʋtʋe -dlɔɔ! Nɩɩ, sa Dide tiea 'mɩ, 'sa -bhlokpadɛ na tiea aɩn.» ");
INSERT INTO kyf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wee wɛlɩnya nɩɩ 'bɩgʋ, ɔ 'paa wa -pɩpɛ -gʋ, 'ɩn ɔ nɛɛ wa -yla: «Zuzu 'Pʋpa -mɩ amɩaa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A -ka nyɩmaa gbʋnyuu 'wʋtɩ nɩ, 'ɩn we 'gba bhʋa wa 'wlu. Nɩɩ, a 'nɩ nyɩmaa gbʋnyuu 'wʋtɩ nɩ, 'ɩn we tʋa wa 'wlu.» ");
INSERT INTO kyf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Da -Zezu yia wee -budu zɔ, -zugba ɔ 'bɩnɔnya kugbua lɛ 'sɔ glaa yabhlo wa laa Toma (-ɔ ka 'ŋnɩɩ -yɔgbalɩŋnɩ -wa -Zluya), ɔ 'nɩ -bha -mɩ. ");
INSERT INTO kyf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tɔʋn, 'bɩnɔnyaa pnɩɩ nɛɛ ɔ -yla: «-A ka -amɩaa -Kanyɔ 'yɩ.» Nɩɩ, Toma nɛɛ wa -ylaɛ: «We -ka nɩɩ, ɩn 'nɩ poɛndee 'bɩ 'yɩ ɔ -kwɩtɛ, 'ɩn ɩn 'nɩ we 'bɩ 'wʋ na -kwɩtaya fa, 'ɩn ɩn 'nɩ ɔ gbacɩ zɔ na sɔ fa nɩ, ɩn 'na 'ka we dlɩ -gʋ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Lɔkɔwlu 'plɩ -bhlo, 'ɩn -Zezuu 'bɩnɔnya yi 'yaa 'wlugbeli -budu zɔ. Nɩɩ, Toma mɩ -bha. Wa ka -buduu klolonya -gbalɩ, 'ɩn -Zezu yia wa glaa yi. Ɔ nɛɛ wa -yla: «-Lagɔ 'nyɛ aɩn 'wʋtʋtʋe -dlɔɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Ɩn ɔ nɛɛ Toma -ylaɛ: «Dɩ da -na -kwɩtaya, 'ɩn yla da na -kwɩtɛ: bɛlɩda -na sɔ, 'ɩn fa we na gbacɩ zɔ. 'Bhʋ dlɩlʋlʋe 'bɩ, 'ɩn -ɩn 'ka dlɩ zʋ!» ");
INSERT INTO kyf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma nɛɛ ɔ -ylaɛ: «Na -Kanyɔ, na -Lagɔ!» ");
INSERT INTO kyf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","-Zezu nɛɛ ɔ -yla: «-Ɩn ka 'mɩ 'yɩ, we 'gbʋ -na zʋa dlɩ, we 'nɩ mʋʋ? -Wa 'nɩa 'mɩ 'yɩ, 'ɩn wa zʋa dlɩ, 'wʋtʋtʋe -dlɔɔ mɩ -maa -nʋ nya.» ");
INSERT INTO kyf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","-Zezu ka gwɛdigbʋnya tɔlʋaa -zlo lɛnʋ ɔ 'bɩnɔnyaa 'yibadɩ, nɩɩ, -mʋʋ 'nɩ cɛlɩda -mɩ 'sɛbhɛ nɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nɩɩ, -we -nya mɩa da cɛlɩda nɩ, -bha we mɩa a 'ka dlɩ zʋ nɩɩ, -Zezu -wa -Lagɔɔ -Bhasanyɔ -yɔ -Lagɔɔ Yu. 'Ɩn, a -ka ɔ dlɩ -gʋ zʋ, a 'ka 'yliyɔgagɩe 'yɩ ɔ 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","-Mʋʋ 'bɩgʋ, 'ɩn -Zezu yi 'yaa ɔ 'dɛ ɔ 'bɩnɔnya 'klʋslolu Tibeliadɩnyu kwesi. Sa we 'plɩa mʋ nɩ: ");
INSERT INTO kyf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ Piɛlɩ klaa, Toma (-ɔ wa laa -Zluya) klaa, Natanaɛlɩ (Galileee Kanagbe 'wʋ yu) klaa, Zebedeee 'yua klaa, we -yɔ -Zezuu 'bɩnɔnya -putu 'sɔ mɩ -bha. ");
INSERT INTO kyf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔ Piɛlɩ nɛɛ wa -yla: «'Nyu na mnɩa -dɔa.» Wa nɛɛ ɔ -ylaɛ: «-Amɩa mɩ 'ya yida -a -yɔ -mɩ 'sɔ 'ka mnɩ.» Wa mnɩa, 'ɩn wa yia 'glʋ 'wʋbho. Nɩɩ, sabɔ weee 'plɩa nɩ, wa 'nɩ zibhi yabhlogbɔɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Zlɩ bhlia zlɩzlɩe, -zugba -Zezu mɩ -bha wee 'nyuu ŋwɛ -yɔ. Nɩɩ, ɔ 'bɩnɔnya 'nɩ we 'jiyibheli nɩɩ, mɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɔ nɛɛ wa -ylaɛ: «Ɩn! Nyimesia, a 'nɩ zibhi 'bha -nyaa?» Wa 'palɩa we 'bɩgʋ, wa nɛɛ: «Ɩɩn, -a 'nɩ zibhi yabhlogbɔɔ 'yɩ!» ");
INSERT INTO kyf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ɔ nɛɛ wa -yla: «A viteli 'sowli amɩaa 'glʋʋ lilisɔlʋ, 'yɩa a yia.» Wa vitelia 'sowli, tɔʋn, zibhii -zlo -we wa 'bhaa, we 'wʋzuloo 'gbʋ, wa 'nɩ 'maslɛɛn 'sowli 'nyu lʋ -sasɩe mneni. ");
INSERT INTO kyf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'Bɩnɔnyɔ -ɔ ka zɛ -Zezu -kalɩa nɛɛ Piɛlɩ -yla: «-Amɩaa -Kanyɔ -wa!» Simɔ Piɛlɩ 'nʋa «-Amɩaa -Kanyɔ -wa!» tɔʋn, 'ɩn ɔ yia ɔ -banaa -gʋbana 'wʋpla, nɩɩ, ɔ ka we 'wʋsaa 'gbʋ, 'ɩn ɔ yia 'nyu lʋ -bho. ");
INSERT INTO kyf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","'Ɩn 'bɩnɔnyaa pnɩɩ -yɔ 'glʋ yia yi, -zugba 'sowli mɩa yeda zibhi nya, wa gbize we 'wʋ. Nɩɩ, wa 'nɩ yaa 'nyuu ŋwɛ -yɔ latlʋlʋ, sa 'bhisa 'mɛtlɩ glʋ gbu sɩsalɩa wa -yɔ. ");
INSERT INTO kyf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wa 'tlaa -gɔgɔ -gʋ, 'ɩn wa yia -bha -kapʋ 'yɩ. Zibhi mɩ 'yli, 'ɩn 'floo mɩa -bha. ");
INSERT INTO kyf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","-Zezu nɛɛ wa -yla: «Zibhi -we a 'bhaa da nɩ, a -yɔ we tɔlʋa yi.» ");
INSERT INTO kyf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔ Piɛlɩ -gblaa 'glʋ 'wʋ tɔʋn, 'ɩn ɔ yia 'sowli 'wʋgbize dʋdʋ. We mɩ yeda zibhi 'kadɩ nya, we ŋwɛ nyni zibhi glʋ gbesɔ 'ya kugbua lɛ ta (153). Nɩɩ, wee zibhi -zu 'wʋ, 'ɩn wee sowli'i yla. ");
INSERT INTO kyf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","-Zezu nɛɛ wa -yla: «A yi a 'ka li!» Waa 'bɩnɔnya glaa nyɩmɛ yabhlogbɔɔ 'nɩ ŋwɛ -ka ɔ 'ka ɔ layɩbhaɛ: «Nyɔɔ -ɩn -mɩa?» Wa -yi we 'ji nɩɩ, Nyɩmaa -Kanyɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","-Zezu bɛa wa kwesi, ɔ 'bhua 'floo 'wʋ, ɔ dlilia we wa 'wʋla, 'ɩn ɔ yia wa zibhi 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nɩɩ, -Zezu -sɔa tlɩtlɩnya glaa 'wʋ, ɔ 'dɛɛ slolue ɔ 'bɩnɔnya -ylaa -zakpa tanʋ mɩa dɛ. ");
INSERT INTO kyf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wa bhɩa lilie, -Zezu nɛɛ Simɔ Piɛlɩ -yla: «Zaaan 'yu 'Simɔɔ, 'lee, -ɩn -kalɩ na zɛ we -zi waa?» Ɔ nɛɛ ɔ -yla: «Ɩɩn, na -Kanyɔ, -ɩn -yi we 'ji nɩɩ, ɩn -kalɩ na zɛ.» -Mɔɔ nɛɛ ɔ -ylaɛ: «'Nyɛ na bhlabhlɛyua.» ");
INSERT INTO kyf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɔ nɛɛ ɔ -yla -zakpa 'sɔnʋ nyaɛ: «Zaaan 'yu 'Simɔɔ, 'lee, -ɩn -kalɩ na zɛɛ?» -Mɔɔ nɛɛ ɔ -yla: «Ɩɩn, na -Kanyɔ, -ɩn -yi we 'ji nɩɩ, ɩn -kalɩ -na zɛ.» -Zezu nɛɛ ɔ -ylaɛ: «-Zɛ na bhlabhlɛɛ 'yliyɔzʋnyɔ.» ");
INSERT INTO kyf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Ɩn ɔ yia ɔ layɩbha -zakpa tanʋ nyaɛ: «Zaaan 'yu 'Simɔɔ, 'lee, -ɩn -kalɩ na zɛɛ?» Piɛlɩɩ -gʋ yia 'wʋ -tʋ -kɔʋn, nɩɩ, ɔ ka ɔ layɩbha -zakpa ta: «'Lee, -mɩ, -ɩn -kalɩ na zɛɛ?» We 'gbʋ, ɔ nɛɛ ɔ -ylaɛ: «Na -Kanyɔ, -ɩn -yi -lu weee 'ji: -ɩn -yi we 'ji nɩɩ, ɩn -kalɩ -na zɛ.» -Zezu nɛɛ ɔ -yla: «'Nyɛ na bhlabhlɛ. ");
INSERT INTO kyf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ɩn nɛɛ -mɩ -yla gbʋzɔnʋ sa nɩɩ, da -ɩn mɩa nyimeslɔyu nya nɩ, -na dɛ gbaa -na -cɛsli, 'ɩn -na mnɩa mɔ -ɩn 'yɩbhaa. Nɩɩ, -ɩn -ka gɔ nɩ, -na sɔ -na yia 'wʋbhua, 'ɩn nyɩma -putu yia -na -cɛsli -gbaa, 'ɩn wa kwaa -mɩ da -ɩn 'nɩa 'yɩbha.» ");
INSERT INTO kyf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(-We -Zezu gbaa dɛ nɩ, sa Piɛlɩ 'kaa tlɩ, 'ɩn ɔ 'kaa -Lagɔɔ 'ŋnɩ -mnɩnɩ ɔ -tlɩtlɩe 'wʋ, 'mʋ ɔ mɩa -sloluda.) 'Bhie, -Zezu nɛɛ Piɛlɩ -ylaɛ: «Yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛlɩ 'bhitia la, 'ɩn ɔ yia wa 'lʋʋ -gbɛɩn 'bɩnɔnyɔ -ɔ ka zɛ -Zezu -kalɩa -yɔyɩ wa 'bɩyida. (Nyɩmɛ -ɔ, wa mɩa zlɩmɛ lida, -ɔ pɩlɩa -Zezuu gbɛgbɛɩn 'wʋ, 'ɩn ɔ yia ɔ layɩbha nɩɩ, nyɔɔ 'ka ɔ wla nɩ, mɔ -wa.) ");
INSERT INTO kyf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛlɩ 'yɩa ɔɔ 'bɩnɔnyɔ -yɔ, 'ɩn ɔ yia -Zezu layɩbhaɛ: «'Ɩn -mɔɔ mɩa da na?» ");
INSERT INTO kyf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","-Zezu nɛɛ ɔ -ylaɛ: «Ɩn -ka 'yɩbha nɩɩ, ɔ -tʋ -bha, 'ɩn ɩn 'ka lʋ yi nɩ, 'lee, lɛɛ -lu -mʋʋ 'ka -mɩ nʋnʋa? -Mɩ, nɔ 'mɩ 'bɩ!» ");
INSERT INTO kyf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tɔʋn, 'ɩn we 'dɩ yia 'mni 'bɩnɔnya glaa nɩɩ, ɔɔ 'bɩnɔnyɔ -mɔnɩ 'na 'ka tlɩ. Nɩɩ, -Zezu 'nɩ gbaɛ: «Ɔ 'na 'ka tlɩ.» Nɩɩ, ɔ nɛɛ: «Ɩn -ka 'yɩbha nɩɩ, ɔ -tʋ -bha, 'ɩn ɩn 'ka lʋ yi nɩ, 'lee, lɛɛ -lu -mʋʋ 'ka -mɩ nʋnʋa?» ");
INSERT INTO kyf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nɩɩ, ɔɔ 'bɩnɔnyɔ -bhlokpadɛ -wa we dayɩnyɔ, 'ɩn mɔ cɛlɩa we. -A -yi we 'ji nɩɩ, -we ɔ gbaa, gbʋzɔnʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","-Zezu ka gbʋʋ -zloo tɔlʋa lɛnʋ. Nɩɩ, sa we 'plɩa, we -ka 'sa wa cɛlɩ we -bhlo -bhlo nɩ, we 'wʋzuloo 'gbʋ, wee 'sɛbhɛnya 'na 'ka yaa dʋdʋ weee -gʋ mneni.");
INSERT INTO kyf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Na bheli Teofilɩ, -na fʋʋ! Na 'sɛbhɛ tɩanʋ 'wʋ, -we weee -Zezu nʋa lɛ, 'ɩn ɔ -slolua, we 'ka we gwedɩda 'bhʋ, we 'ka ɔ yalɩmnɩbhla ylɩ, ɩn ka we cɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nyɩma -wa ɔ -saa -bha ɔ tietienya nya ɔ 'kaa yalɩ mnɩ, -we ɔ gbaa wa -yla Zuzu 'Pʋpaa 'tɩtɛ nya, mʋ nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","-Zezu tlɩa, we 'bɩgʋ, ɔ yia ɔ 'dɛ ɔ tietienya 'klʋslolu -zakpa duun, wa we slolue nya nɩɩ, ɔ 'nɩ tlɩ, ɔ -ga 'yliyɔ. Ɔ li 'ylɩ glʋ 'sɔ, -zugba ɔ tlalɩ wa 'klʋ, ɔ gba *-Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ wa -yla. ");
INSERT INTO kyf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","'Ylɩ yabhlo nya, -Zezu -yɔ ɔ tietienya 'sɔ mɩ lida, 'ɩn ɔ nɛɛ wa -ylaɛ: «A 'na 'bhʋlʋ *-Zeluzalɛmʋgbe nʋkplɛ -nɩ. -We Dide gbaa ɔ 'ka aɩn yoo 'pa, -we ka gbʋ ɩn gbaa zlɩmɛ aɩn -yla, a wʋ we. ");
INSERT INTO kyf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nɩɩ, *Zaan -mɔɔ ka nyɩma batizee 'nyu nya, -bha -tʋ 'wʋ -sɛ, 'ɩn -Lagɔ 'ka aɩn batizee Zuzu 'Pʋpa nya.» ");
INSERT INTO kyf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","-Mʋʋ 'bɩgʋ, -wa gbelia 'wlu -Zezu kwesi, wa yia ɔ layɩbha, wa nɛɛ ɔ -ylaɛ: «-Amɩaa -Kanyɔ, wee bhla -mɩnɩ nya, -na yia *Izlaɛlɩnyɩma wa dʋdʋʋ 'wlulapɩlɩe yoo 'nyɛa lʋ yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","-Zezu yia we 'bɩgʋpalɩ wa -ylaɛ: «We bhla -yɔ we ylɩ mɩa nɩ, we 'nɩ amɩanʋʋ gbʋ. Na Dide ka we zʋ. 'Ɩn ɔ 'dɛbhlogbɔɔ mnenia ɔ 'ka we lɛnʋ ɔ 'dɛɛ se nya. ");
INSERT INTO kyf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nɩɩ, amɩa yia 'tɩtɛ 'yɩa, Zuzu 'Pʋpa yia aɩn -gʋ lasibhlia, 'ɩn a zɛa na gbʋdayɩnya -Zeluzalɛmʋgbe nʋkplɛ, Zudee -yɔ Samalii -dʋdʋ -gʋ, 'ɩn we 'ka dʋdʋʋ bhloluda nyni.» ");
INSERT INTO kyf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Da ɔ bhɩa wee gbʋnya -mɩnɩ gbagbɩe, 'ɩn -Lagɔ yia ɔ 'wʋbhu yalɩ, -zugba ɔ tietienya mɩ ɔ 'bɩ ylada sa tenyii. -Mʋʋ 'bɩgʋ, yalɩpʋpa yia ɔ 'wʋzize. Wa'a 'yɩ 'maslɛɛn ɔ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Da -Zezu mɩa -mɔ 'yu bɛda, 'ɩn ɔ tietienya mɩa ɔ 'bɩtalɩda yalɩ, -bha -bhlokpadɛ, nʋkpasia sɔ kaa -bana 'pʋpa 'wʋ, 'tlalɩa wa 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","-Maa nɛɛ wa -ylaɛ: «Galilee -nyɩma, -bhadɛ a 'yligbea, -zugba a yla yalɩ yɩ, lɛɛ ka 'gbʋa? Ɔɔ -Zezu, -Lagɔ ka ɔ 'wʋbhu aɩn glaa, ɔ ka yalɩ mnɩ. Sa a 'yɩa da ɔ mnɩda yalɩ, 'sa -bhlokpadɛ ɔ yia lʋyia.» ");
INSERT INTO kyf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tɔʋn, -Zezuu tietienya 'bhʋa -gɔgɔ wa laa *Olivʋsunyaa -gɔgɔ 'wlu, 'ɩn wa yia -Zeluzalɛmʋ lʋmnɩ. Wee -gɔgɔ mɩ -Zeluzalɛmʋ kwesi, we 'dɛ 'sɔ nyɩdɩ ka sa kilo -bhloo -kpʋa nyni. ");
INSERT INTO kyf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wa plaa -Zeluzalɛmʋ nɩ, 'ɩn wa yia komi yabhlo, -we mɩa -budu 'wlu zɔ mnɩ. -Mɔ wa dɩlɩa la -benyi. Piɛlɩ klaa, *Zaan klaa, *'Zake -yɔ Andlee klaa, Filipʋ -yɔ Toma klaa, Batlemii -yɔ Matie klaa, Alɩfeee 'yu 'Zake klaa, 'Simɔ *Zelɔtʋ -yɔ 'Zakee 'yu Zudasɩ klaa, -maa mɩ 'ya wee -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wamɩa klaa, 'ŋwnɩ klaa, -Zezuu 'nyaa Malii -yɔ -Zezuu bhelia klaa, 'zlabhue zɔ wa 'dɛ weee gbelia 'wlu, 'ɩn wa bhubhoea -Lagɔ dlɩ -bhlogbɔɔ nya dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'Ylɩ yabhlo nya, -Lagɔbhelia gbelia 'wlu, wa mneni wa 'ka nyɩmaa glʋ gbelibhlo nyni. Piɛlɩ -sɔa 'wʋ, ɔ 'yligbea wa nyɩdɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Na bhelia, wɛlɩ -we Zuzu 'Pʋpa gbaa 'cɩn, 'ɩn wa cɛlɩa *-Lagɔsɛbhɛ 'wʋ, we mɩ nɩɩ, we nʋ lɛ. Zuzu 'Pʋpa ka Zudasɩɩ gbʋ gba nyɩmaa 'wlulapɩlɩnyɔ *-Davidɩɩ ŋwɛ nya 'cɩn. Nyɩma -wa kpaa -Zezu, ɔɔ Zudasɩ -galɩa wa 'yu. ");
INSERT INTO kyf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudasɩ mɩ zlɩmɛ -amɩaa lʋnyɩmɛ yabhlo nya. Tietie -lubho -a nʋa, ɔ yia ɔ -nʋ 'yɩ.» ( ");
INSERT INTO kyf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'Gwɛzi wa 'pɛnɩa ɔ, ɔ gbʋnyuuu 'gbʋ, 'ɩn ɔ yia we kpaa yabhlo 'wʋzɔlʋ, 'ɩn ɔ yia ɔ 'dɛ 'bha. Ɔ 'sibhlia 'wlu, ɔ nʋkpla yia ŋwanɩ, 'ɩn ɔ 'mʋɩ weee yia 'pipee 'mni. ");
INSERT INTO kyf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","-Zeluzalɛmʋ -nyɩma weee yia we 'nʋ. We 'gbʋ, wa yia wee kpaaa 'ŋnɩ zʋ wa wɛlɩ 'wʋ, «Akɛlɩdama.» We ji -wa «'Pɩɔn -Kpaa.») ");
INSERT INTO kyf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Nɩɩ, we mɩ Lʋʋsɛbhɛ 'wʋ cɛlɩdaɛ: ‹Ɔ -budu -tʋ klo nya, nyɩmɛ yabhlogbɔɔ 'na -dɩlɩ we zɔ la -nɩ.› 'Ɩn we mɩ 'ya cɛlɩdaɛ: ‹Nyɩmɛ -putu nʋ ɔ 'bɩgʋ lubho.› ");
INSERT INTO kyf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","We 'gbʋ, nyɩmɛ yabhlo -bho -aɩn glaa, 'ɩn sa Nyɩmaa -Kanyɔ -Zezu -sɔa 'wʋ tlɩtlɩe lʋ, -a -yɔ ɔ 'sɔ 'ka we dayɩnya -zɛ. Nyɩma -wa -yɔ -aɩn 'sɔ nɔa, -zugba -amɩaa -Kanyɔ -Zezu -yɔ -aɩn 'sɔ mɩ dʋdʋ weee -gʋ 'plɩlɩda, ɔɔ nyɩmɛ -zɛ wa lʋnyɩmɛ yabhlo, ");
INSERT INTO kyf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","'ylɩ -we nya Zaan batizea -Zezu, we 'bhʋ we -yɔ, 'ɩn we 'ka -Zezuu yalɩ -mnɩ bhla ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Ɩn wa yia nyɩma 'sɔ wla: Matiasɩ -yɔ *-Zɛzɛfʋ wa laa Balɩsabasɩ, 'ɩn wa la 'yaa Zutusɩ. ");
INSERT INTO kyf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Bhie, 'ɩn wa 'dɛ weee yia -Lagɔ bhubhoe dabʋdʋ, wa nɛɛ: «Jejitapɛ, -mɩ -yia nyɩma weee dlɩ, waa nyɩma sɔ nɩ glaa, -ɔ -ɩn -saa -bha, -ɩn -slolu ɔ -aɩn 'klʋ, ");
INSERT INTO kyf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ɔ 'ka *tietienyɔ -zɛ Zudasɩɩ 'bɩgʋ. 'Ɩn lubho -we -mɔɔ 'tidea 'yi, ɔ 'ka we nʋ. Nɩɩ, 'bɩ -we ka 'klʋ Zudasɩ kaa, 'ɩn ɔ yia -mʋʋ -gʋ mnɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","-Mʋʋ 'bɩgʋ, wa yia -nɩgbɩ 'pa, we yia Matiasɩ -gʋ bhlili. 'Ɩn ɔ yia -Zezuu tietienya kugbua lɛ -bhlo glaa -bho. ");
INSERT INTO kyf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","*Pantɩkɔtʋʋ 'ylɩ nynia nɩ, 'ɩn -Lagɔnyɩma weee yia 'wlugbeli da yabhlo. ");
INSERT INTO kyf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tɔʋn, -jiji yabhlo yia yalɩ gba. We 'wlʋ sa -pɩpɛ 'kadʋ -we mɩ 'plɩda, 'ɩn we yia -budu -we ka zɔ wa -dɩa la ye weee. ");
INSERT INTO kyf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","-Bha -bhlokpadɛ, -we wa 'yɩa -yɔ, we 'wlʋ sa -kosuu mɩɔnya. We 'bhʋbhlʋa -yɔ, 'ɩn we yia wa -gʋ ladɩ -bhlo -bhlo. ");
INSERT INTO kyf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Ɩn Zuzu 'Pʋpa yia wa ye. Wa yia wɛlɩ -putunya gbagbɩe bhli. Sa Zuzu zʋa we wa ŋwɛɛ, 'sa wa gbaa we. ");
INSERT INTO kyf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nɩɩ, Zuifʋ -wa zʋa -bha -Lagɔ, -wa 'bhʋa dʋdʋ weee -gʋ, -Zeluzalɛmʋ wa -dɩa la. ");
INSERT INTO kyf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","-Jiji -we gbaa yalɩ da wa 'nʋa we, wa -zlo -yɔ -gwagwɩe yia -mɔ 'wlugbelia mnɩ, -we nʋa lɛ, wa 'ka we 'yɩ. Wa nynia -mɔ, we ka wa ŋwɛgaga -sʋbhalɩ. -We ka gbʋ -wa, -Lagɔnyɩma mɩ wa wɛlɩ gbada -bhlo -bhlo, -zugba wa nʋ we. ");
INSERT INTO kyf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","We ka wa -lʋɛlɩ, 'ɩn wa yia -folu. 'Ɩn wa nɛɛ: «Aya, -mʋʋ 'nɩ -slɔ gbʋzɔnʋ! Nyɩma -wa mɩa dɛ -amɩaa wɛlɩ gbada -nya, wa 'nɩ Galilee -nyɩmaa? ");
INSERT INTO kyf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sa we nʋ, 'ɩn wa gba -amɩaa wɛlɩ -bhlo -bhlo, -zugba -a nʋ wea? ");
INSERT INTO kyf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","-Aɩn glaa, nyɩma -tɔlʋa mɩ Paati -nyɩma nya, tɔlʋa mɩa Medi -yɔ Elamʋ -nyɩma nya. 'Ɩn tɔlʋa bhʋa Mezopotami, Zudee -yɔ Kapadɔsʋ -dʋdʋ -gʋ, Pɔɔn -yɔ -Azii -dʋdʋ -gʋ, ");
INSERT INTO kyf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Flizii -yɔ Panfilii, Ezipʋtʋ -dʋdʋ -gʋ, we -yɔ Silɛnɩgbe 'wʋ Libii -dʋdʋ -gʋ. Nyɩma -tɔlʋa 'bhʋa *Wlɔmʋ, ");
INSERT INTO kyf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Zuifʋ -yɔ nyɩma -wa zʋa Zuifʋʋ -Lagɔ dlɩ -gʋ. Klɛtɩ -nyɩma -yɔ Alabʋnya mɩ -bha, 'ɩn -zugba -a nʋ -Lagɔɔ lɛnʋgbʋ 'kadɩ wa ŋwɛɛ -amɩaa 'dɛɛ wɛlɩ 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","We ka wa -lʋɛlɩ. Sa wa 'kaa 'wlukʋʋn lapʋpalɩ, 'sa 'nɩ -mɩ. 'Ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «Sa -mʋʋ 'ji mɩa?» ");
INSERT INTO kyf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Ɩn nyɩma tɔlʋa yia wa glapalɩe bhli, 'ɩn wa nɛɛ: «Nʋ wa lʋa 'wʋ, mʋ mɩa wa 'bhada!» ");
INSERT INTO kyf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piɛlɩ -yɔ tietienya kugbua lɛ -bhlo -sɔa 'wʋ, 'ɩn ɔ yia nyɩmaa -zlo -yla gbʋ -gbagbɩe bhli wɛlɩ 'tɩtɛ nyaɛ: «Amɩa Zuifʋ, 'ɩn amɩa weee dɩlɩa -Zeluzalɛmʋ la, -we mɩa 'plɩda, a 'nʋ we 'wʋla. 'Ɩn -we na yia gbaa, a pʋlʋ we yukwli 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sa a pʋpalɩa dɛ we 'wlukʋʋn la, we 'nɩ 'sa -mɩ. Nʋ 'nɩ nyɩma nɩ 'bhada -mɩ, nɩɩ, zlʋkpa -lɛlɩ gbomnʋanʋ 'wʋ -a mɩa da. ");
INSERT INTO kyf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nɩɩ, -we *-Lagɔgbʋʋ -falɩpanyɔ -Zowɛlɩ gbaa, mʋ mɩa -slɛɛn da lɛnʋda. Ɔ nɛɛ nɩɩ, -Lagɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹-We 'kaa lɛnʋ 'wʋbhlolu -ylɩnyaa zlɩ mʋ nɩ. Na Zuzu na yia nyɩma weee -gʋ lamnenia. Amɩaa nʋkpasiyua -yɔ amɩaa 'ŋwnɩyua yia gbʋʋ -falɩ 'paa. Amɩaa nyimesia yia -li -yɔyɩa wa 'yli 'wʋ, 'ɩn amɩaa nyɩsʋɩ 'ka 'ylaanya yla. ");
INSERT INTO kyf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Cɩɩn, wee 'ylɩnya -mɩnɩ nya, na Zuzu na yia na lubhonʋnya -yɔ na lubhonʋŋwnɩ -gʋ slua, 'ɩn wa 'ka gbʋʋ -falɩ 'pa. ");
INSERT INTO kyf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gbʋ 'kadɩ na yia lɛnʋa yalɩ. 'Ɩn ɩn 'ka gwɛdigbʋ lɛnʋ dʋdʋ -gʋ. 'Pɩɔn klaa, -kosu klaa, gbeylo -ylukpa klaa, mʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nikpise yia 'ylʋ 'yliya 'wʋ kpaa, 'ɩn 'cʋ 'ka zamanɩ nɛɛ 'pɩɔn. -Mʋʋ 'bɩgʋ, 'bhie, Nyɩmaa -Kanyɔɔ yiyiylɩ 'kadʋ ka 'ŋnɩmnɩa 'kaa yi. ");
INSERT INTO kyf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'Ɩn nyɔɔo nyɔɔ -ka Nyɩmaa -Kanyɔɔ 'ŋnɩ la, -Lagɔ 'ka ɔ gbʋ 'wʋsa.› » ");
INSERT INTO kyf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piɛlɩ nɛɛ 'yaɛ: «Izlaɛlɩɩ nyɩma, -we na yia aɩn -yla gbaa, a pʋlʋ we yukwli: -Lagɔ ka Nazalɛtɩyu -Zezuu 'tɩtɛ aɩn 'klʋslolu. -Zezuu gbɛgbɛɩn -Lagɔ nʋa ninee 'ŋnɩpalɩgbʋ klaa, gbʋ 'kadɩ klaa, we -yɔ gwɛdigbʋ lɛ aɩn nyɩdɩ. Amɩaa 'dɛ -yi we 'ji. ");
INSERT INTO kyf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wa 'kaa aɩn -Zezu yoo 'nyɛ -Lagɔ -yi we 'ji, 'ɩn ɔ dʋmagbʋ -wa, ɔ ka we 'wlukʋʋn lapʋpalɩ 'cɩn. A ka -Zezu 'bha, a ka ɔ gbʋnyuu -lɛnʋnya yoo 'nyɛ, 'ɩn wa yia ɔ *su -gʋ lakʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","-Lagɔ ka -Zezu 'wʋbhu tlɩtlɩe lʋ, 'ɩn ɔ yia ɔ tlɩtlɩee sɩasɩee 'llukpe -yɔdɩ, we se 'nɩ -mɩ, ɔ 'ka tlɩtlɩee 'tɩtɛ zɔ -tʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ nɛɛ -Zezu daaɛ: ‹'Kɔmʋʋ na yɩa Nyɩmaa -Kanyɔ -yɔ na 'dɛ 'yu. Ɔ mɩ na lilisɔlʋ, ɩn yi bhlii 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","We 'gbʋ, na dlɩ 'wlʋ gumu, 'ɩn na ŋwɛɛ wɛlɩ mɩ yeda 'mʋna nya. 'Ɩn na ku -ka tlɩ, -zugba nyapɛda we mɩa: na dlɩ 'tɛ 'wʋ -Lagɔ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nɩɩ, na -kanyɔ, -ɩn 'na 'ka 'mɩ tlɩtlɩe lʋtɩ tlɩtlɩnyaa dʋdʋ -gʋ. -Ɩn 'na 'ka -na -mɔwlʋnyɔ 'yitide ɔ 'ka 'bhʋka 'wʋ zɛnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","-Ɩn ka 'mɩ 'yliyɔgagɩe -we 'nɩa bhloluda -kaa 'yoo daslolu. Ɩn -ka -mɩ 'yu -mɩ, 'mʋna -na yia 'mɩ yelia.› » ");
INSERT INTO kyf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piɛlɩ nɛɛ 'yaɛ: «Na bhelia, amɩaa zukpa -wa, a 'nyɛ 'mɩ 'yoo, ɩn 'ka -amɩaa dʋkpasa -Davidɩɩ -gʋgbʋ gba kpɛɛn kpɛɛn. Ɔ ka tlɩ, wa ka ɔ 'bhlu. 'Ɩn ɔ gbawla mɩ -zɛɛn ylɩ nya -aɩn nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bhla -we nya, nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ -gaa 'yliyɔ nɩ, ɔ mɩ -Lagɔgbʋʋ -falɩpanyɔ nya. 'Ɩn ɔ -yi we 'ji, -Lagɔ ka ɔ -yla bi: nɩɩ, ɔ 'yuoyu -kpɔ yia ɔ 'ŋnɩmnɩbɩ 'wʋbhua. ");
INSERT INTO kyf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ ka we -yɔyɩ -mɔ 'yugbɛɩn nɩɩ, *Klisɩ, -Lagɔɔ -Bhasanyɔ yia 'wʋsɔa tlɩtlɩe lʋ. We 'gbʋ, ɔ nɛɛ nɩɩ, -Lagɔ 'nɩa ɔ tlɩtlɩnyaa dʋdʋ -gʋ 'wʋbanɩa yi. 'Ɩn ɔ ku 'na 'ka zɛn gbawla nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ɔɔ -Zezu, -ɔ ka gbʋ ɩn mɩa da gbada, -Lagɔ ka ɔ 'wʋbhu tlɩtlɩe lʋ, -amɩa -mama mɩa da, -a 'dɛ weee mɩ we -bhayɩnya nya. ");
INSERT INTO kyf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","-Lagɔ ka ɔ 'wʋbhu ɔ lilisɔlʋ, 'ɩn ɔ yia Zuzu 'Pʋpa 'yɩ, -ɔ Dide -Lagɔ gbaa zlɩmɛ ɔ 'ka yoo 'pa. 'Ɩn ɔ yia ɔ Zuzu -aɩn -gʋ slu, 'mʋ a mɩa -yɔyɩda, 'ɩn 'mʋ a mɩa 'nʋda -slɛɛn. ");
INSERT INTO kyf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Nɩɩ, nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ 'nɩ cɩ yalɩ mnɩ, 'ɩn ɔ nɛɛ ɔ 'dɛ nyaɛ: ‹Jejitapɛ nɛɛ na -Kanyɔ -ylaɛ: «-Ɩn -dɩ na lilisɔlʋ la, 'ɩn ɩn 'ka -na tʋnyɩma -na bhʋ zɔ lapalɩ, -ɩn 'ka wa -gʋ nɔ.» › ");
INSERT INTO kyf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Izlaɛlɩnyɩma weee yibheli we 'ji sazɔnʋ sa: nɩɩ, ɔɔ -Zezu a kʋlʋa su -gʋ la, 'mɔ -Lagɔ nʋa Nyɩmaa -Kanyɔ -yɔ -Bhasanyɔ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Da wa 'nʋa wɛlɩnya -mɩnɩ, 'ɩn we yia wa dlɩ kwɛzɩ bhabha. 'Ɩn wa nɛɛ Piɛlɩ -yɔ tietienya tɔlʋa -ylaɛ: «Bhelia, sa -a 'ka we nʋa?» ");
INSERT INTO kyf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piɛlɩ nɛɛ wa -ylaɛ: «A 'bhiti amɩaa dlɩ, 'ɩn wa batizee a 'dɛ weee -bhlo -bhlo -Zezu Klisɩɩ 'ŋnɩ nya. 'Ɩn -Lagɔ 'ka amɩaa gbʋnyii 'wʋtɩ, 'ɩn ɔ 'ka ɔ Zuzu 'Pʋpa aɩn 'nyɛ, ɔ kwɛlu nya. ");
INSERT INTO kyf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nɩɩ, -we -Lagɔ gbaa ɔ 'ka wla, we mɩ amɩa -yɔ amɩaa 'yuaa -nʋ nya. We mɩ 'ya nyɩma -wa mɩa 'pɩpɩɩ -nʋ nya, we mɩ nyɩma weee -nʋ nya, -wa Jejitapɛ, -amɩaa -Lagɔ 'kaa la.» ");
INSERT INTO kyf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛlɩ ka wa -yla wɛlɩ tɔlʋa gba duun, ɔ 'ka wa lu, 'ɩn ɔ 'ka wa dlɩ latɛmanɩɩ 'gbʋ. Ɔ nɛɛ wa -ylaɛ: «A ŋwnu 'pʋpʋee gbʋ -yɔ, a vla mnɔmnɔnya gwe.» ");
INSERT INTO kyf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wa glaa nyɩma duun yia Piɛlɩɩ wɛlɩ -yɔŋwnu, 'ɩn wa yia wa batizee. Wee 'ylɩ nya, nyɩma -wa 'nyɛa wa 'dɛ -Lagɔ yoo, wa yi sa nyɩmaa 'wlu kugbua lɛ gbu nyni (3.000), 'ɩn wa yia -Lagɔnyɩma 'cɩn -gʋbhlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","'Kɔmʋʋ, wa pʋlʋa tietienyaa gbʋ -sloluwɛlɩ yukwli, 'ɩn wa tʋa dabʋdʋ, bhelia -yɔ bhɔlɔa 'bhisa. Dabʋdʋ wa lia, 'ɩn wa dɩa wa 'floo 'wʋ, 'ɩn wa bhubhoea -Lagɔ dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","-Nyanɩgbɔ ka wa -kpalɩ -bhlo -bhlo, gbʋ 'kadɩ -yɔ gwɛdigbʋ -duunnya tietienya mɩa lɛnʋdaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","-Wa weee plaa -Lagɔ, we bhla dabhlo wa mɩa, 'ɩn dabʋdʋ wa -lu weee mɩa. ");
INSERT INTO kyf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wa -kakali -yɔ wa zʋzɔnʋnya wa paa pɛlʋ, 'ɩn wa dlilia we 'gwɛzi wa 'dɛkpʋa nyɩdɩ. Sa -mɔmɔ ka -yɔgbʋ -ka -mɩ, 'sa wa nyɛa -mɔɔ. ");
INSERT INTO kyf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Ylɩ weee nya, *-Lagɔbudu 'kadʋ zɔ wa gbelia 'wlu. 'Ɩn wa lia ladɩdlɩfloo wa -buduŋwɛɛ dabʋdʋ, 'ɩn wa lia wa 'sukwe 'mʋna -yɔ dlɩ -dlɔɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","-Lagɔɔ 'ŋnɩ wa mnɩnɩa, 'ɩn -zugba nyɩma weee -wa mɩa wee 'gbe nʋkplɛ, kwalɩ wa 'ŋnɩ. 'Ɩn 'ylɩ weee nya, Jejitapɛ saa nyɩma gbʋ 'wʋ, 'ɩn ɔ palɩa wa -Lagɔnyɩma -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","'Ylɩ yabhlo nya, -Lagɔ -bhubhoe bhla bɛa, Piɛlɩ -yɔ Zaan 'sɔ yia dabʋdʋ -Lagɔbudu 'kadʋ zɔ mnɩ, wa 'ka -Lagɔ bhubhoe jibheylʋʋ 'lɛlɩɩ tanʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","-Lagɔbudu 'kadʋʋ plalɩda wa laa Plalɩda -Zɔnʋ, we kwesi nʋkpasu yabhlo ɔ 'nyaa gwalɩa, -zugba ɔ mɩ 'kuda, -bha ɔ dɩa la. 'Ylɩ weee nya, ɔ nyɩma -yɔ ɔ yia -bha, 'ɩn wa dɩa -bha ɔ la, ɔ 'ka nyɩma -wa plaa -Lagɔbudu 'kadʋ zɔ 'gwɛzi -zlalɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ɔ 'yɩa Piɛlɩ -yɔ Zaan 'sɔ plada -Lagɔbudu 'kadʋ zɔ, 'ɩn ɔ yia wa -lu -zlalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛlɩ -yɔ Zaan 'sɔ 'bhitia la, wa ylaa ɔ tenyii, 'ɩn Piɛlɩ nɛɛ: «Yla -aɩn.» ");
INSERT INTO kyf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Ɩn ɔɔ nʋkpasu yia wa ylada -tʋ. Ɔmɔ dlɩɩ nɩɩ, -lu yabhlo wa yia ɔ 'nyɛa. ");
INSERT INTO kyf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Ɩn Piɛlɩ nɛɛ ɔ -ylaɛ: «Ɩn 'nɩ 'gwɛzi -ka, ɩn 'nɩ -can -ka. Nɩɩ, -we ɩn kaa, 'mʋ na yia -mɩ 'nyɛa: Nazalɛtɩyu -Zezu Klisɩɩ 'ŋnɩ nya, -sɔ 'wʋ, nɔ!» ");
INSERT INTO kyf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","'Ɩn ɔ yia ɔ lilisɔ -yɔ kpalɩ, ɔ yia ɔ 'wʋbhu. -Bha -bhlokpadɛ, ɔɔ 'kukunyɔɔ bhʋnya -yɔ we -kwɩkwɩanya 'tɛmanɩa la. ");
INSERT INTO kyf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɔ -blu 'wʋ -bhlogbɔɔ, 'ɩn ɔ yia ɔ bhʋ 'sɔ -gʋ 'yligbe, ɔ yia nɔnʋe bhli. 'Ɩn ɔ -yɔ wa 'sɔ yia -Lagɔbudu 'kadʋ zɔ pla, nɔnʋe nya, 'wʋblublue nya, we -yɔ -Lagɔɔ 'ŋnɩ -zɔnʋʋ mnɩnɩe nya. ");
INSERT INTO kyf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","'Ɩn nyɩma weee mɩa -bha, 'ɩn wa yia ɔ -yɔyɩ nɔda, -zugba ɔ mnɩnɩ -Lagɔɔ 'ŋnɩ -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wa ka ɔɔ nʋkpasu yibheli. Mɔ -dɩa -benyi -Lagɔbudu 'kadʋʋ Plalɩda -Zɔnʋ la, -zugba ɔ zla -li. 'Ɩn nyanɔ yia wa 'wʋslo, 'ɩn we yia wa -lʋɛlɩ, -we ylɩa ɔɔ nʋkpasuu 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɔɔ nyɩmɛ 'nɩ Piɛlɩ -yɔ Zaan 'bɩ 'bhʋda -mɩ, 'ɩn nyɩma weee ŋwɛgaga sʋbhaa, -maa -yɔ gwagwɩe yia wa gbɛgbɛɩn mnɩ, -Lagɔbudu 'kadʋʋ -kapue kaa bhʋ, wa lalɩa *Salomɔɔɔ 'ŋnɩ, we zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Da Piɛlɩ 'yɩa gbʋ -mɩnɩ -yɔ, 'ɩn ɔ nɛɛ nyɩmaa -zlo -ylaɛ: «Izlaɛlɩɩ nyɩma, lɛɛ ka 'gbʋ nyɩmɛ -mɔnɩɩ 'pʋpʋe sʋbhalɩ aɩn ŋwɛgaga? Lɛɛ ka 'gbʋ a yla -aɩn nɛɛ -amɩaa 'dɛɛ 'tɩtɛ -yɔ -amɩaa -Lagɔɔ -yɔlanɛnɩe nya -a jipe ɔɔ nyɩmɛ -mɔnɩa? ");
INSERT INTO kyf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","*Ablaamʋ, *Izakɩ -yɔ *Zakɔbʋʋ -Lagɔ, -amɩaa dʋkpasɩɩ -Lagɔ ka ɔ lubhonʋnyɔ -Zezuu 'ŋnɩ 'ylimanɩ. Amɩaa 'dɛ ka ɔ wla nyɩmaa 'wlulapɩlɩnya -yla, 'ɩn a yia ɔ kwnɛɛ -sa Pilatɩ 'yu, -zugba -mɔɔ 'yɩbha yaa -mɔɔ 'ka ɔ 'yitide. ");
INSERT INTO kyf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A ka -Mɔwlʋnyɔ mɩa Nyɩmɛ Tɩklɩɩ nya kwnɛɛ -sa, 'ɩn a nɛɛ Pilatɩ -yla, ɔ 'tide nyɩmɛbhanyɔ 'yi aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sanɛɛ 'sa, a 'bhaa 'yliyɔgagɩee -Kanyɔ. 'Ɩn -Lagɔ ka ɔ 'wʋbhu tlɩtlɩnya glaa, -a mɩ we dayɩnya nya. ");
INSERT INTO kyf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nyɩmɛ a yɩa dɛ -yɔ, 'ɩn a -yia, -Zezuu 'ŋnɩɩ 'tɩtɛ -yɔ ɔ dlɩ -gʋzʋzʋe 'nyɛa ɔ latɛlɔ. -Zezuu dlɩ 'wʋzʋzʋe jipea ɔɔ nyɩmɛ -mɔnɩ kpɛɛn kpɛɛn, sa a 'dɛ weee yɩa dɛ we -yɔ. ");
INSERT INTO kyf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«'Ɩn -slɛɛn, na bhelia, ɩn -yi we 'ji zʋzɔnʋ sa nɩɩ, a -yɔ amɩaa 'yugalɩnya 'sɔ, gbʋ -we a nʋa lɛ -Zezuu gbɛgbɛɩn, a 'nɩ we 'wʋyii 'gbʋ, a yia we lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Ɩn gbʋ -we -Lagɔ gbaa zlɩmɛ ɔ gbʋʋ -falɩpanya weee ŋwɛ nya, ɔ ka 'sa we lɛnʋ. Ɔ nɛɛ zlɩmɛ nɩɩ, sɩa -Lagɔɔ -Bhasanyɔ yia. ");
INSERT INTO kyf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ɩn nɛɛ, a 'bhiti amɩaa dlɩ, a yi -Lagɔɔ -gbɛ lʋ, 'ɩn ɔ 'ka amɩaa gbʋnyii lamumni. ");
INSERT INTO kyf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'Ɩn Jejitapɛ 'ka aɩn nyapɛbhla 'nyɛ, -pɩpɛ 'ka aɩn -yɔplɩlɩ. 'Ɩn Klisɩ, -Lagɔ -saa -benyi -bha amɩaa -nʋ nya, ɔ 'ka ɔ aɩn yoo 'pa, mɔ -wa -Zezu. ");
INSERT INTO kyf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","We mɩ nɩɩ, yalɩ -Zezu Klisɩ yia -slɔ -tʋa, 'ɩn -lu weee lamnazɩ bhla 'kaa nyni. Sa -Lagɔ gbaa we zlɩmɛ, ɔ gbʋʋ -falɩpanyaa -mɔwlʋ nʋʋ ŋwɛ nya, 'sa. ");
INSERT INTO kyf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","«'Ɩn, *Moizɩ nɛɛ: ‹Jejitapɛ -ɔ -wa amɩaa -Lagɔ, mɔ yia aɩn glaa ɔ gbʋʋ -falɩpanyɔ yabhlo -bha -saa, -amɩ 'bhisa. Amɩaa 'dɛɛ bheli yabhlo ɔ yia -zɛa. -We weee ɔ yia aɩn -yla gbaa, yukwli a yia we pʋlʋa. ");
INSERT INTO kyf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nyɔɔo nyɔɔ 'nɩ ɔɔ -Lagɔgbʋʋ -falɩpanyɔ -mɔnɩɩ wɛlɩ yukwli pʋlʋ, -Lagɔɔ nyɩma glaa wa yia ɔ -saa, 'ɩn ɔ 'ka labhʋ.› ");
INSERT INTO kyf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Ɩn we 'ka Samuɛlɩ -gʋ gwedɩ, -Lagɔgbʋʋ -falɩpanya -wa gbaa -bhlo -bhlo, wa 'dɛ weee ka 'ylɩnya -mɩnɩɩ gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","-Lu -we -Lagɔ 'kaa wla, ɔ gbaa ɔ gbʋʋ -falɩpanyaa ŋwɛ nya, we mɩ amɩaa -nʋ nya. 'Ɩn *'wʋsuslolue -we ka wɛlɩ -Lagɔ -yɔ amɩaa dʋkpasɩ bhlɩa, -mʋʋ mɩ 'ya amɩaa -nʋ nya. Da ɔ gbaa Ablaamʋ -ylaɛ: ‹-Na 'yuoyuaa 'gbʋ na yia dʋdʋgʋ -nyɩma weee 'nyulaŋwnaa.› ");
INSERT INTO kyf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'Ɩn tɩa -Lagɔ ka ɔ lubhonʋnyɔ yoo 'pa amɩaa 'gbʋ. Ɔ ka ɔ tie, ɔ 'ka aɩn 'nyulaŋwna, 'ɩn ɔ 'ka aɩn amɩaa lɛnʋgbʋ 'nyii 'bɩsa -bhlo -bhlo.» ");
INSERT INTO kyf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Da Piɛlɩ -yɔ Zaan mɩa nyɩmaa -zlo -yla gbʋ gbada, 'ɩn -Lagɔbʋbɔnya klaa, -Lagɔbudu 'kadʋʋ ŋwɛkʋnyaa -kanyɔ -yɔ *Sadusenyɩma yia -bha wa ylɩ. ");
INSERT INTO kyf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","'Ɩn wa yia 'cɛ 'pa, da Piɛlɩ -yɔ Zaan 'sɔ mɩa nyɩmaa -zlo -sloluda nɩɩ, -Zezu ka tlɩtlɩnya glaa 'wʋsɔ, mʋ slolua we nɩɩ, tlɩtlɩnya mneni wa 'ka tlɩtlɩe lʋ 'wʋsɔ. ");
INSERT INTO kyf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wa kpaa wa, jibhe ka zɔɔ 'gbʋ, wa yia wa -kaslʋbudu zɔ -gueli. ");
INSERT INTO kyf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","-Mʋʋ bhla, nyɩmaa -zlo -wa 'nʋa -Lagɔgbʋ, yia we -yɔŋwnu. Wa nyni sa nyɩmaa 'wlu glʋ -bhlo 'wlu gbu. (5.000) ");
INSERT INTO kyf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","-Mʋʋ zlɩ zlɩa, Zuifʋʋ 'yugalɩnya klaa, nyɩma kpasɩ -yɔ -Lagɔɔ titee gwesanya yia 'wlugbeli -Zeluzalɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nyɩma -wa mɩa -bha wa ŋnɩ nɩ: *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Anasɩ, Kaifʋ, Zaan, Alɛzandlɩ we -yɔ -Lagɔbʋbɔnyaa -kanyɔ 'kadʋʋ zʋaylinyɩma weee. ");
INSERT INTO kyf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","'Ɩn wa yia Piɛlɩ -yɔ Zaan kwa wa 'yu, 'ɩn wa yia wa layɩbhaɛ: «Se -mʋmʋ nya a jipe ɔɔ 'kukunyɔa? 'Ɩn nyɔɔ ka 'ŋnɩ -gʋ a nʋ we lɛa?» ");
INSERT INTO kyf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Zuzu 'Pʋpa yea Piɛlɩ, ɔ nɛɛ wa -ylaɛ: «'Yugalɩnya, nyɩma kpasɩ, ");
INSERT INTO kyf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","-a ka guzʋnyɔ -mɔnɩ zʋzɔnʋ -yla lɛnʋʋ 'gbʋ, wa yɩbhaa -zɛɛn ylɩ nya -aɩn la, sa -a jipeli ɔɔ nyɩmɛ 'wʋla? ");
INSERT INTO kyf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","A 'dɛ weee yibheli we 'ji, 'ɩn Izlaɛlɩnyɩma yibheli we 'jiɛ: Nazalɛtɩyu -Zezu Klisɩ a kʋlʋa su -gʋ la, 'ɩn -Lagɔ 'bhua 'wʋ tlɩtlɩnya glaa, ɔ 'ŋnɩ nya nyɩmɛ -mɔnɩ 'pʋa, 'ɩn ɔ 'yligbea da aɩn 'yu. ");
INSERT INTO kyf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋ -Zezuu daaɛ: ‹Tʋkpa -we amɩa -budusʋbhanya -saa kwnɛɛ, mʋ -zɛa -buduu gwɩgwɩyli -tʋkpa -zɔnʋ.› » ");
INSERT INTO kyf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Piɛlɩ nɛɛ 'yaɛ: «Ɔ 'dɛbhlogbɔɔɔ -gbɛ wa yɩa 'pʋpʋe. Nɩɩ, dʋdʋ weee -gʋ, nyɩma weee glaa, -Lagɔ 'nɩ nyɩmɛ -putuu 'ŋnɩ wla, ɔ 'ka -aɩn gbʋ 'wʋsa.» ");
INSERT INTO kyf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Da *Zuifʋʋ gbʋwliwʋdɩnya 'yɩa Piɛlɩ -yɔ Zaaan dlɩ tɛlɔ -yɔ, 'ɩn ŋwɛgaga yia wa sʋbha. 'Ɩn wa yia we -yɔyɩ nɩɩ, nyɩma -kpʋa -yɔ -wa 'nɩa 'sɛbhɛ -yi, ma -wa. 'Ɩn wa -yi 'ya wa -Zezuu nɔnɔnya 'cɩn nya. ");
INSERT INTO kyf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","'Ɩn wa yi 'yaa nyɩmɛ -ɔ wa jipea -yɔyɩ 'yligbeda wa kwesi. 'Ɩn wa 'nɩ wɛlɩ -ka, wa 'ka we 'bɩgʋpalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'Ɩn wa nɛɛ wa -ylaɛ: «A 'tla gbʋwʋbhu -budu zɔ!» 'Ɩn wa 'dɛkpʋa yia kpɛlɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wa nɛɛ: «Sa -a 'ka waa nyɩma -manɩ nʋa? Wa ka gwɛdigbʋ lɛnʋ, -Zeluzalɛmʋ -nyɩma weee ka -bha 'yɩ, 'ɩn -a 'nɩ mneni -a 'ka we kpɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nɩɩ, wee gbʋ -mɩnɩ yi lamneni nyɩma -nyɩdɩ -tapaa 'gbʋ, -a 'yligbeli wa -glawɛlɩ nya! Nyɔɔo nyɔɔ -ɔ -ka -mɩ, wa yi ɔ -yla gbʋ gba -Zezuu 'ŋnɩ nya.» ");
INSERT INTO kyf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wa laa Piɛlɩ -yɔ Zaan, 'ɩn wa nɛɛ wa -ylaɛ: «A 'na gbalɩ nyɩma -yla gbʋ -Zezuu 'ŋnɩ nya -nɩ, 'ɩn a 'na -slolu wa gbʋ we nya 'mnumnu -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'Ɩn Piɛlɩ -yɔ Zaan nɛɛ wa -ylaɛ: «A 'yɩbha -slɔ amɩaa 'dɛ la. We nanɩ 'yli, -Lagɔ 'yu, -a zʋ amɩa 'nʋŋwɛ yaayɩɩ, -a zʋ -Lagɔ 'nʋŋwɛɛ? ");
INSERT INTO kyf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","'A! Gbʋ -we ka da -a 'yɩa, 'ɩn -a 'nʋa, -a 'nɩ mneni, -a 'ka gba -a 'nɩa we gba.» ");
INSERT INTO kyf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gbʋwliwʋdɩnya yia wa 'cɛ -yɔ 'palɩ 'ya 'sɔ. -Mʋʋ 'bɩgʋ, 'ɩn wa yia wa 'yitide. Gbʋ -we ka 'gbʋ wa 'kaa wa 'klɩyɩe 'wʋpalɩ, wa 'nɩ we 'yɩ. Nyɩma weee mɩ -Lagɔɔ 'ŋnɩ -mnɩnɩda, -we nʋa lɛɛ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nyɩmɛ -ɔ 'pʋa gwɛdi sa, ɔ -zʋ mneni we 'ka -zʋʋ glʋ 'sɔ -gʋzi. ");
INSERT INTO kyf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Da wa 'tidea Piɛlɩ -yɔ Zaan 'yi, 'ɩn wa yia wa bheliaa -gbɛ mnɩ. 'Ɩn -we *-Lagɔbʋbɔnyaa -cɩan -yɔ nyɩma kpasɩ gbaa wa -yla, wa yia we -sa lʋdɩ nya. ");
INSERT INTO kyf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Da waa -Lagɔbhelia 'nʋa gbʋ -mɩnɩ, 'ɩn -maa yia -Lagɔ bhubhoe bhli dabʋdʋ. 'Ɩn wa nɛɛ: «-Amɩaa -Kanyɔ, -mɩ nʋa yalɩ -yɔ dʋdʋ -yɔ gumunyu lɛ, 'ɩn -we weee mɩa we -gʋ -yɔ we nʋkplɛ, -mɩ nʋa we lɛ. ");
INSERT INTO kyf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","-Mɩ gbaa, Zuzu 'Pʋpa nya, -amɩaa dʋkpasa -Davidɩ -ɔ -wa -na lubhonʋnyɔ, ɔ ŋwɛ nyaɛ: ‹Lɛɛ ka 'gbʋ dʋdʋgʋ -nyɩma weee dɩ -zlɛ la 'dɛɛ 'ylimanɩe nya? Lɛɛ ka 'gbʋ wa pʋpalɩ gbʋ -kpʋa gbʋa? ");
INSERT INTO kyf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dʋdʋʋ 'wlulapɩlɩnya -sɔa 'wʋ tʋ nya, 'ɩn nyɩmaa 'yugalɩnya yia gwe 'pa, Jejitapɛ -yɔ ɔ -Bhasanyɔ -yɔ.› ");
INSERT INTO kyf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nɩɩ, gbʋzɔnʋ -wa, -na lubhonʋnyɔ -Zezu -ɔ mɩa -mɔwlʋda, -ɩn -saa -bha, 'ɩn -ɩn slua 'kpɩ 'wluo, *Ewlodʋ klaa, Pɔnsɩ Pilatɩ klaa, 'lakpanya -yɔ *Izlaɛlɩɩ zʋaylinyɩma ka ɔ -yɔ gwe 'palɩ, wee dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","-We weee -ɩn gbaa -na 'tɩtɛ -yɔ -na dʋmagbʋ nya pepe, 'mʋ wa nʋa dɛ lɛ. ");
INSERT INTO kyf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","'Ɩn Jejitapɛ, sa wa 'palɩa -aɩn 'cɛ -yɔ, -ɩn yla we. 'Ɩn -ɩn 'tɛmanɩ -na lubhonʋnyaa dlɩ la, wa 'ka -na gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","-Ɩn -glo -na sɔ 'wʋ, 'ɩn nyɩmaa jipee -yɔ gwɛdigbʋ -yɔ gbʋ 'kadɩ 'kadɩ nʋ lɛ, -na lubhonʋnyɔ -Zezu mɩa -mɔwlʋdaa 'ŋnɩ nya. We -mɩ 'sa.» ");
INSERT INTO kyf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bhla -we nya wa bhɩa -Lagɔ bhubhoe, da wa -dɩa la, 'ɩn -bha yia zuklu. 'Ɩn Zuzu 'Pʋpa yia wa 'dɛ weee ye, tɔʋn, wa yia -Lagɔwɛlɩ gbagbɩe bhli, dlɩ tɛlɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nyɩma weee -wa zʋa -Zezu dlɩ -gʋ, wa dlɩ -yɔ wa 'wlukʋʋn lapʋpalɩe -bhlo. 'Ɩn nyɩmɛ yabhlogbɔɔ'ɔ gba nɩɩ, ɔnʋʋ zʋzɔnʋnya mɩa, ɔ 'dɛ -bhloo -nʋ -wa. Nɩɩ, wa zʋzɔnʋ weee mɩa, 'wʋ wa suslolua we da yabhlo. ");
INSERT INTO kyf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Tɩtɛ 'kadʋ yabhlo nya, -Zezuu tietienya gbaa Nyɩmaa -Kanyɔ -Zezuu 'wʋsɔgbʋ tlɩtlɩnya glaa. 'Ɩn -Lagɔɔ 'nanɩ 'kadʋ yia wa 'dɛ weee -gʋ kwlili. ");
INSERT INTO kyf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wa glaa bobabhanyɔ 'nɩ -mɩ. -Wa weee kaa kpaa -yɔ -budunya, pɛlʋ wa paa we, 'ɩn wa -yɔ we -yɔgwɛzi yia. ");
INSERT INTO kyf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'Ɩn wa -yɔ wee 'gwɛzi yia, -zugba wa nyɛ we -Zezuu tietienya yoo. -Mʋʋ 'bɩgʋ, 'ɩn -maa dlilia we wa 'wʋla -bhlo -bhlo, sa wa -yɔgbʋ -ka -mɩ, 'ɩn wa bhɩa we. ");
INSERT INTO kyf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Siplʋyu *-Zɛzɛfʋ, -ɔ -wa *Leviii zʋaylinyɩmɛ, -ɔ ka 'ŋnɩ -Zezuu tietienya zʋa Banabasɩ, 'sa ɔ mɩa. (Wee Banabasɩɩ ji -wa, nyɩmaa dlɩ latɛmanɩnyɔ.) ");
INSERT INTO kyf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kpaa yabhlo ɔ kaa, 'ɩn ɔ yia we pɛlʋ 'pa. Ɔ -yɔ we 'gwɛzi yia -Zezuu tietienyaa -gbɛ mnɩ, 'ɩn ɔ yia we wa yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Cɩɩn, nyɩmɛ yabhlo -ɔ ka ŋnɩ -wa Ananiasɩ -yɔ ɔ 'ŋwnɔ Safilaa 'paa wa kpaa pɛlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'Ɩn ɔ -yɔ ɔ 'ŋwnɔ bhlɩa wɛlɩ -bhlo, ɔ yia we 'gwɛzii kibhe 'wʋtɩ ɔ -nʋ nya, 'ɩn ɔ -yɔ we tɔlʋa yia -Zezuu tietienyaa -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Ɩn Piɛlɩ nɛɛ ɔ -ylaɛ: «Ananiasɩ, lɛɛ ka 'gbʋ *-Saatan yi -na dlɩ yea? -Ɩn ka Zuzu 'Pʋpa -yla yotʋbhʋ, 'ɩn -ɩn yia wee kpaa 'gwɛzi tɔlʋa 'wʋtɩ -na -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Da -ɩn 'nɩa -slɔ wee kpaa pɛlʋ 'pa, we mɩ -na -nʋ nya. 'Ɩn -ɩn 'paa we pɛlʋoo, we 'gwɛzi mɩa, -na -nʋ -wa, we 'nɩ mʋʋ? Lɛɛ ka 'gbʋ -ɩn yi sanɛɛ -sʋkpa gbʋ pʋpalɩa? We 'nɩ nyɩma -yla -ɩn 'tʋbhʋ yo, -Lagɔ -yla -ɩn 'tʋbhʋa we.» ");
INSERT INTO kyf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasɩ 'nʋa wee wɛlɩnya -mɩnɩ, ɔ bhlia, -bha ɔ tlɩlɩa. -Wa weee 'nʋa we, -nyanɩgbɔ yia wa -kpalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nyimesia yia 'wʋsɔ, 'ɩn wa yia ɔ 'naa -yɔzʋ, wa -yɔ ɔ yia mnɩ, 'ɩn wa yia ɔ lazʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'Lɛlɩ ta 'plɩa, 'ɩn ɔ 'ŋwnɔ Safilaa yia pla, -zugba -we nʋa lɛ, ɔ 'nɩ we 'ji -yi. ");
INSERT INTO kyf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piɛlɩ yia ɔ layɩbha, ɔ nɛɛ ɔ -ylaɛ: «A gba 'mɩ -yla gbʋzɔnʋ, -valɛ nɩ nya a 'paa amɩaa kpaa pɛlʋ yɩ?» 'Ɩn ɔ nɛɛ: «Ɩɩn, we nya -a 'paa we pɛlʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tɔʋn, Piɛlɩ nɛɛ ɔ -ylaɛ: «Sa we mɩa, 'ɩn a -yɔ amaa 'lowli yi wɛlɩ -bhlo bhlɩa, 'ɩn a yi -Lagɔɔ Zuzu laylaa? A -talɩ, -wa 'bhʋa amaa 'lowli lazʋda, wa 'yligbe -buduŋwɛɛ, ma yi 'yaa ama yoo kwaa.» ");
INSERT INTO kyf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","-Bha -bhlokpadɛ, ɔ bhlia Piɛlɩɩ bhʋ -yɔ, ɔ yia tlɩ. Nyimesia 'kaa pla, -zugba ɔ ka tlɩ, wa 'bhua ɔ 'wʋ, wa -yɔ ɔ 'sɔ mnɩa, 'ɩn wa yia ɔ lazʋ ɔ 'lowli kwesi. ");
INSERT INTO kyf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","*Leglizɩ weee -yɔ nyɩma -tɔlʋa weee, -wa 'nʋa wee gbʋ -mɩnɩ, -nyanɩgbɔ yia wa -kpalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","-Zezuu tietienya ka gwɛdigbʋ -yɔ gbʋ 'kadɩ duun lɛnʋ nyɩma nyɩdɩ. -Lagɔbudu 'kadʋʋ -kapue wa lalɩa Salomɔɔɔ palʋ 'kadʋ, we zɔ -Lagɔnyɩma gbelia 'wlu, we bhla wa ka dlɩ -bhlo. ");
INSERT INTO kyf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'Ɩn nyɩmɛ yabhlogbɔɔ'ɔ 'yɩ dlɩ ɔ 'ka wa lʋbho, 'ɩn -zugba nyɩma duun mnɩnɩ wa 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","'Ɩn nyɩmaa -zlo, nʋkpasia -yɔ 'ŋwnɩ, -wa ŋwnua Nyɩmaa -Kanyɔɔ gbʋ -yɔ, 'ɩn -maa yia -Lagɔnyɩma -gʋbho. ");
INSERT INTO kyf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","'Ɩn nyɩma yia guzʋnya 'yloogblʋ wlelie bhli. Wa yia wa -gbato -yɔ -bitanya -gʋ lapɩlɩ. 'Ɩn bhla -we nya Piɛlɩ -ka 'plɩa yi, ɔ zuzu 'ka -ylɛɛ 'yabhloo -kpʋa -gʋ 'plɩlɩ wa glaa. ");
INSERT INTO kyf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nyɩmaa -zlo yi 'yaa 'gbenya mɩa -Zeluzalɛmʋ kwesi 'bhʋ, 'ɩn wa -yɔ guzʋnya -yɔ nyɩma -wa zuzu 'nyii mɩa 'klɩyɩe 'wʋpalɩda yia yi, 'ɩn wa 'dɛ weee yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yɔ -wa mɩa ɔ kwesi -wa weee -wa *Sadusenyɩma, zenyidlɩ yia wa 'wʋbho -Zezuu tietienyaa gbɛgbɛɩn. 'Ɩn -we wa 'kaa lɛnʋ, wa yia we wɛlɩ bhlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wa kpaa -Zezuu tietienya, 'ɩn wa yia wa -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nɩɩ, sabɔ, -Jejitapɛɛ 'anzɩ yabhlo yia, 'ɩn we yia -Zezuu tietienya ŋwɛ -kaslʋbudu -kalɩ. We wlelia wa, 'ɩn we nɛɛ wa -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«A mnɩ -Lagɔbudu 'kadʋ zɔ. 'Ɩn -we weee -wa 'yliyɔgagɩe loluu gbʋ, a gba we nyɩma -yla.» ");
INSERT INTO kyf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","-Zezuu tietienya zʋa we wɛlɩ 'nʋŋwɛ, 'ɩn zlʋkpɛ -papa, wa yia -Lagɔbudu 'kadʋ zɔ mnɩ, 'ɩn wa yia nyɩma slolue bhli. -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yɔ -wa mɩa ɔ kwesi, wa yia gbʋwliwʋdɩnya -yɔ Zuifʋʋ nyɩma kpasɩ la, gbʋwʋbhubhue 'kadʋ -yɔ. 'Bhie, wa yia nyɩma tie -kaslʋbudu zɔ, wa mnɩ -Zezuu tietienya 'bʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Ɩn da 'slʋja nynia -kaslʋbudu zɔ, -maa 'nɩ -mɔ wa ylɩ. 'Ɩn -maa yia gbʋwʋbhunyaa -gbɛ lʋbhiti, wa yia lʋdɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Wa nɛɛ: «-A ka -kaslʋbudu klada ylɩ 'nanʋʋ, -zugba we ŋwɛkʋnya 'yligbe we ŋwɛɛ. Nɩɩ, da -a -kalɩa we, -a 'nɩ -mɔ nyɩmɛ yabhlogbɔɔ ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Da -Lagɔbudu 'kadʋʋ ŋwɛkʋnyaa -kanyɔ -yɔ -Lagɔbʋbɔnyaa -cɩan 'nʋa gbʋnya -mɩnɩ, -we wa 'kaa 'wlukʋʋn lapʋpalɩ, wa 'nɩ we -yi. 'Ɩn wa yia wa 'dɛ layɩbhaɛ: «Lɛɛ -lu ylɩ -Zezuu tietienya?» ");
INSERT INTO kyf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tɔʋn, nyɩmɛ yabhlo 'tlalɩa -bha, 'ɩn -mɔɔ nɛɛ wa -ylaɛ: «A -talɩ! Nyɩma -wa a 'paa -kaslʋ 'wʋ, wa mɩ -Lagɔbudu 'kadʋ zɔ nyɩma gbʋ -sloluda.» ");
INSERT INTO kyf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","'Bhie, -Lagɔbudu 'kadʋʋ ŋwɛkʋnyaa -kanyɔ -yɔ ɔ 'slʋja yia -Zezuu tietienya 'bʋmnɩ sa -dlɔɔ, wa 'nɩ we nʋ -gla nya, nyɩma yi wa gbɔkʋ 'wʋbhaa 'gbʋ, nyanɔ mɩ wa dlɩɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Da wa -yɔ wa yia lʋ, 'ɩn wa yia wa gbʋwliwʋdɩnya 'yu kwa. -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yɔ -wa mɩa ɔ kwesi, yia wa layɩbhayɩbhɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ɔ nɛɛ wa -ylaɛ: «-A ka aɩn -yla gba 'klʋ 'cɩcɩ nya da nɩɩ, a 'na -slolu nyɩma gbʋ nyɩmɛ -mɔnɩɩ 'ŋnɩ nya -nɩ. 'Ɩn -mʋmʋ a nʋ dɛ lɛa? A ka amɩaa nyɩmaa gbʋslolue lamneni -Zeluzalɛmʋ -gbe -kpabhie nʋkplɛ. 'Ɩn a 'yɩbha a 'ka -aɩn ɔ 'bhabhagbʋ 'wludɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piɛlɩ -yɔ -Zezuu tietienya tɔlʋa yia we 'bɩgʋpalɩɛ: «-Lagɔ -a 'kaa 'nʋŋwɛ zʋ, we 'ka nyɩma -zi. ");
INSERT INTO kyf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Amɩa 'bhaa -Zezu, ɔ su -gʋ lakʋlʋe nya. 'Ɩn -amɩaa dʋkpasɩɩ -Lagɔ yia ɔ 'wʋbhu tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nɩɩ, -Lagɔ ka ɔ 'wʋbhu ɔ lilisɔlʋ, 'ɩn ɔ yia ɔ 'yligbeli nyɩmaa 'Yugalɩnyɔ -yɔ wa Gbʋwʋsanyɔ nya. 'Ɩn ɔ 'ka *Izlaɛlɩ 'yoo 'nyɛ, wa 'ka wa dlɩ 'bhiti, 'ɩn -Lagɔ 'ka wa gbʋnyii 'wʋtɩ. ");
INSERT INTO kyf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wee gbʋnya -mɩnɩ, -amɩa mɩ we dayɩnya nya, 'ɩn Zuzu 'Pʋpa -ɔ -Lagɔ 'nyɛa -wa zʋa ɔ 'nʋŋwɛ, ɔ mɩ 'ya we dayɩnyɔ nya.» ");
INSERT INTO kyf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Gbʋwliwʋdɩnya 'nʋa gbʋnya -mɩnɩ, 'ɩn we yia wa 'cɛ dlɔ la. Wa 'yɩbha wa 'ka -Zezuu tietienya 'bha we 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wa glaa, *Falizɩnyɩmɛ yabhlo wa laa Gamaliɛlɩ, -Lagɔɔ titee gwesanyɔ -wa, nɩɩ, nyɩma weee zʋa ɔ 'nʋŋwɛ, ɔ -sɔa 'wʋ gbʋwliwʋdɩnya nyɩdɩ, 'ɩn ɔ nɛɛ, wa wleli -slɔ -Zezuu tietienya -sɛ. ");
INSERT INTO kyf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","-Mʋʋ 'bɩgʋ, ɔ nɛɛ waa gbʋwliwʋdɩnya -ylaɛ: «Izlaɛlɩɩ nyɩma, gbʋ -we a 'kaa lɛnʋ waa nyɩma -manɩɩ gbɛgbɛɩn, a zʋ amɩaa 'dɛ 'yliyɔ we 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɩɩ, nyɩmɛ yabhlo wa laa Tedasɩ, ɔ 'tlaa, we 'bɩ 'nɩ 'wʋgwlɛ, ɔ yia ɔ 'dɛ la nyɩmɛ -zɔnʋ. Sa 'bhisa, nyɩmaa 'wlu 'sɔ yia ɔ 'bɩ -bholu. Wa yia ɔ 'bha, 'ɩn -wa weee -bholua ɔ 'bɩ, -maa yia lamnɔ. 'Ɩn gbʋ -we ɔ 'kaa lɛnʋ, we yia 'wʋtʋ bhe. ");
INSERT INTO kyf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","-Mɔɔ 'bɩgʋ, nyɩmaa zɛlɩbhla, Galileyu Zudasɩ yia 'tla, 'ɩn nyɩmaa -zlo yia ɔ 'bɩbholu. 'Ɩn wa yi 'yaa -mɔɔ 'bha. 'Ɩn -wa weee -bholua ɔ 'bɩ, -maa yia lamnɔ. ");
INSERT INTO kyf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","-Slɛɛn, ɩn nɛɛ aɩn -ylaɛ: a 'na ylalɩ nyɩma -manɩ 'maslɛɛn -nɩ, a 'tide wa 'yi, wa 'ka mnɩ. We -ka wa 'wlukʋʋn lapʋpalɩgbʋ -yɔ wa lɛnʋgbʋ mɩa, nyɩmaa -gbɛ we bhʋ, la we yia 'bhʋa. ");
INSERT INTO kyf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nɩɩ, we -ka -Lagɔɔ -gbɛ we bhʋ 'piɛɩn, a 'nɩ mneni a 'ka we lasa. A zʋ amɩaa 'dɛ 'yliyɔ, a -yɔ -Lagɔ 'na gʋlʋ tʋ -nɩ!» 'Ɩn gbʋwliwʋdɩnya yia Gamaliɛlɩɩ wɛlɩ 'wʋŋwnu. ");
INSERT INTO kyf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wa laa -Zezuu tietienya, 'ɩn wa yia wa sɛlɩ, 'ɩn wa nɛɛ wa -yla, wa 'na gbalɩ 'maslɛɛn -Zezuu 'ŋnɩ nya gbʋ -nɩ. 'Bhie, wa yia wa 'yitide. ");
INSERT INTO kyf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","'Ɩn -Zezuu tietienya -yɔ 'mʋna yia gbʋwliwʋdɩnyaa -gbɛ 'bhʋ, -we ka gbʋ -wa, -Lagɔ ka we -yɔyɩ nɩɩ, wa ka we 'klʋ, wa 'ka wa 'klɩyɩe 'wʋpalɩ -Zezuu 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Ɩn sa zlɩ zlɩa, 'sa wa tʋa -Lagɔwɛlɩ -sloluda, 'ɩn wa tʋa -Lagɔɔ -Bhasanyɔ -Zezuu Gbʋzɔnʋ -gbada -Lagɔbudu 'kadʋ -yɔ wa -budunya zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","We bhla, 'ɩn -Zezuu *'bɩnɔnya yia -gʋbho. -Lagɔnyɩma -wa gbaa *glɛkɩwɛlɩ, ma palɩa -Lagɔnyɩma -wa gbaa zuifʋwɛlɩ -yla gbʋ laɛ: «'Ylɩ weee nya, wa -ka lililu dlilia yi, 'ɩn wa dlʋa -amɩaa -dʋgbaŋwnɩ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","-Zezuu tietienya kugbua lɛ 'sɔ gbelia -Zezuu 'bɩnɔnya weee 'wlu, 'ɩn wa nɛɛ wa -ylaɛ: «-A -ka -Lagɔwɛlɩɩ sloluee 'yitide lililuu dliliee 'gbʋ, we 'nɩ 'ylinanɩ. ");
INSERT INTO kyf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","We 'dɛɛ 'gbʋ, bheliaɩn, a -sa -bha -mɔ aɩn glaa nyɩma gbesɔ, -wa ka 'ŋnɩ -zɔnʋ nyɩma gbaa, -wa -Lagɔɔ Zuzu yea, -wa -yia gbʋ, 'ɩn -a 'ka wa wee lubho kwɛɛ zʋ. ");
INSERT INTO kyf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'Ɩn -amɩa 'ka -Lagɔ bhubhoe -yɔ -Lagɔwɛlɩ -sloluda -tʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","-We wa gbaa, -wa weee mɩa -bha, 'ɩn -maa yia we -yɔŋwnu. 'Ɩn Etiɛnɩ -ɔ zʋa dlɩ, Zuzu 'Pʋpa mɩa yeda, 'ɩn wa yia -bha ɔ -sa, we -yɔ Filipʋ, Plokɔɔ, Nikanɔɔ, Timɔ, Palɩmenasɩ -yɔ Antiɔsʋ -yu 'Nikolaa, -ɔ zʋ bhaa Moizɩɩ tite 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","'Bhie, wa yia wa -Zezuu tietienya 'yu kwa. 'Ɩn -maa yia wa sɔ 'wluo lapalɩ, 'ɩn wa yia -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","'Ɩn -Lagɔgbʋ -yɔ lamnenie yia mnɩ -tapa. 'Ɩn -Zezuu 'bɩnɔnya yia -gʋbho duun -Zeluzalɛmʋ. 'Ɩn *-Lagɔbʋbɔnyaa -zlo yia -Zezuu gbʋ -yɔŋwnu dlɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiɛnɩ, -ɔ kaa -Lagɔɔ 'nanɩ -yɔ ɔ 'tɩtɛ 'wʋ, mɔ nʋa gbʋ 'kadɩ 'kadɩ -yɔ gwɛdigbʋ lɛ nyɩma -nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","*-Lagɔbudu wa lalɩa «Galɩ wa 'tidea 'yii» 'ŋnɩ nya, we zɔ nyɩma tɔlʋa -sɔlʋa Etiɛnɩ -yɔ 'wʋ. Waa nyɩma -yɔ Etiɛnɩ kpɛlɩa, ma nɩ: Silɛnɩ -yɔ Alɛzandlii gbee Zuifʋ, we -yɔ 'ya Silisi -yɔ -Aziii Zuifʋ. ");
INSERT INTO kyf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nɩɩ, gbʋyilo -Lagɔɔ Zuzu 'nyɛa ɔ, we nya ɔ gbaaa 'gbʋ, wa 'nɩ mneni wa 'ka ɔ lu. ");
INSERT INTO kyf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","'Ɩn wa yia nyɩma 'wʋplalɩ nɩɩ, wa gbaɛ: «Ɔ mɩ Moizɩ -yɔ -Lagɔ vɛlɩda, 'ɩn -a yia we 'nʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Sa wa 'bhua sa nyɩmaa -zlo, nyɩma kpasɩ -yɔ -Lagɔɔ titee gwesanyaa dlɩ 'wʋ, 'ɩn -maa yia Etiɛnɩ kwesi bɛ, wa yia ɔ kpa. 'Ɩn wa yia ɔ gbʋwliwʋdɩnya 'yu kwa. ");
INSERT INTO kyf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yogbʋʋ dayɩnya wa -yɔ wa yi 'yaa, 'ɩn -maa nɛɛ: «Ɔɔ nyɩmɛ -mɔ nɩ, -amɩaa -mɔwlʋ -Lagɔbudu 'kadʋ -yɔ Moizɩɩ titee da ɔ gbaa gbʋnyuu 'kɔmʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","-A ka 'nʋ ɔ ŋwɛɛ nɩɩ, ɔɔ Nazalɛtɩyu -Zezu yia -amɩaa -Lagɔbudu 'kadʋ lamumnia, 'ɩn tite Moizɩ 'nyɛa -aɩn, ɔ 'ka we 'bhiti.» ");
INSERT INTO kyf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gbʋwliwʋdɩnya weee -wa -dɩa -bha la, wa ylaa Etiɛnɩ tenyii, 'ɩn wa yia ɔ 'klʋ -yɔyɩ nɛɛ -Lagɔɔ 'anzɩ yabhloo klʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ yia Etiɛnɩ layɩbhaɛ: «-We weee wa gbaa da -na daa, gbʋzɔnʋ -wa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","'Ɩn Etiɛnɩ yia we 'bɩgʋpalɩɛ: «Na bhelia -yɔ na didea, a pʋlʋ 'mɩ yukwli! 'Ŋnɩmnɩ -Lagɔ ka -amɩaa dʋkpasa Ablaamʋ 'klʋtlalɩ Mezopotami -dʋdʋ -gʋ. We ka lɛnʋ 'bhie, Ablaamʋ yia Alaan -dʋdʋ -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","-Lagɔ nɛɛ ɔ -ylaɛ: ‹-Ɩn 'bhʋ -na nyɩmaa -gbɛ, -na dʋdʋ -gʋ, 'ɩn dʋdʋ -we na yia -mɩ 'klʋslolua, -ɩn mnɩ we -gʋ.› ");
INSERT INTO kyf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ablaamʋ 'bhʋa Kalɩdee -dʋdʋ -gʋ, 'ɩn ɔ yia Alaan mnɩ. «Ɔ dide tlɩa, -mʋʋ 'bɩgʋ, 'ɩn -Lagɔ yia ɔ 'wʋbhu Alaan -dʋdʋ -gʋ, 'ɩn dʋdʋ -we -gʋ a dɩa -zɛɛn da la, 'ɩn ɔ yia -bha ɔ -la. ");
INSERT INTO kyf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","-Mʋʋ bhla, -Lagɔ 'nɩ Ablaamʋ -lu yabhlogbɔɔ 'nyɛ. Dʋdʋʋ kibhe 'kienyilɛ -we 'wlʋa bhʋʋ 'bɩ, ɔ 'nɩ 'dɛbhie -gbolu we ɔ 'nyɛ. 'Ɩn -Lagɔ nɛɛ Ablaamʋ -yla, wee dʋdʋ ɔ yia ɔ 'nyɛa, 'ɩn we 'ka ɔ 'yuoyua 'lʋʋ -yuoyuaa -nʋ -zɛ, ɔ 'bɩgʋ. 'Ɩn -zugba Ablaamʋ 'nɩ 'yu yabhlogbɔɔ -ka. ");
INSERT INTO kyf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","-Lagɔ nɛɛ ɔ -ylaɛ: ‹-Na 'yuoyua yia 'lakpa -dʋdʋ -gʋ ladɩa. 'Ɩn wa 'ka -mɔ galɩ -zɛ, wa 'ka wa 'klɩyɩe 'wʋpalɩ -zʋʋ 'wlu 'sɔ nʋkplɛ.› ");
INSERT INTO kyf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Ɩn -Lagɔ nɛɛ 'yaɛ: ‹Nyɩma -wa ka galɩ wa yia -zɛa, -maa -yɔgbʋ na yia 'wʋbhua. -Mʋʋ 'bɩgʋ, lʋ wa yia yia, 'ɩn wa 'ka 'mɩ bʋbɔ -seli.› ");
INSERT INTO kyf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","'Bhie, -Lagɔ yia *'wʋsuslolue ɔ -yɔ Ablaamʋ nyɩdɩ zʋ. -We -slolua we mʋ -wa *knɩ 'wʋpapɩe. 'Sa Ablaamʋ gwalɩa ɔ 'yu Izakɩ, we 'ylɩ gbetaa zlɩ, 'ɩn ɔ yia ɔ knɩ 'wʋpa, 'ɩn Izakɩ yia -mɔɔ 'yu Zakɔbʋ knɩ 'wʋpa, 'ɩn Zakɔbʋʋ 'yua kugbua lɛ sɔ mɩa -amɩaa dʋkpasɩ nya, 'ɩn ɔ yia wa knɩ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«-Amɩaa dʋkpasɩ nʋa *-Zɛzɛfʋʋ zenyi, 'ɩn wa yia ɔ pɛlʋ 'pa gaylo nya Ezipʋtʋ -dʋdʋ -gʋ. 'Ɩn -Lagɔ -yɔ -Zɛzɛfʋ 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","-Lagɔ ka -Zɛzɛfʋ sɩasɩe 'wʋsa, 'ɩn ɔ yia ɔ gbʋyilo 'nyɛ, ɔ 'ka Ezipʋtʋʋ dʋdʋʋ 'wlulapɩlɩnyɔ *Falaɔn dʋdʋnamanɩ. 'Ɩn -mɔɔ yia ɔ Ezipʋtʋʋ zʋzɔnʋ weee -yɔ -mɔɔ 'dɛɛ -buduu 'yliyɔzʋnyɔ 'wʋnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Ŋwɔ 'kadʋ ka Ezipʋtʋ weee -yɔ Kanaa -dʋdʋ -gʋ yi. We mɩ sɩasɩe 'kadʋ nya. -Amɩaa dʋkpasɩ'ɩ 'yɩ lililu wa'a li. ");
INSERT INTO kyf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Da Zakɔbʋ 'nʋa nɩɩ, lililu mɩ Ezipʋtʋ -dʋdʋ -gʋ, 'ɩn ɔ yia -mɔ -amɩaa dʋkpasɩ tie tɩa -bhlo. ");
INSERT INTO kyf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Da wa -zakpa 'sɔnʋ mnɩa, 'ɩn -Zɛzɛfʋ yia ɔ 'dɛ -slolu ɔ bhelia -yla. -Bha Falaɔn yibhelia -Zɛzɛfʋʋ zʋaylinyɩma. ");
INSERT INTO kyf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","'Ɩn -Zɛzɛfʋ yia nyɩma tie, wa mnɩ ɔ dide Zakɔbʋ -yɔ ɔ zʋaylinyɩma 'bʋ. Wa nyɩmaa glʋ ta 'ya kugbua lɛ gbu. ");
INSERT INTO kyf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","'Ɩn Zakɔbʋ yia Ezipʋtʋ mnɩ, -mɔ ɔ tlɩlɩa, 'ɩn -mɔ -amɩaa dʋkpasɩ tɔlʋa tlɩlɩ 'yaa. ");
INSERT INTO kyf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","'Ɩn wa yia wa 'kwie Sisɛmʋgbe 'wʋ kwa, 'ɩn 'bhʋka -we Ablaamʋ zɔa 'gwɛzi nya Amɔɔɔ 'yua kwɛɛ, 'ɩn wa yia we 'wʋ wa 'bhlulu -mɔ Sisɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Gbʋ -Lagɔ gbaa zlɩmɛ Ablaamʋ -yla, da we lɛnʋ bhla nynia, 'ɩn Zuifʋ yia zumanɩ Ezipʋtʋ -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nyɩmaa 'wlulapɩlɩnyɔ -lolu -ɔ 'nɩa -Zɛzɛfʋ yibheli, 'ɩn -mɔɔ yia Ezipʋtʋ -dʋdʋ 'wlulapɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","'Ɩn ɔɔ nyɩmaa 'wlulapɩlɩnyɔ -mɔnɩ yia -amɩaa nyɩma -dawli 'wʋnʋ. Ɔ nɛɛ -gla nya, wa 'tide wa 'yuyolua 'yi -maa 'ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«We bhla wa gwalɩa Moizɩ. Ɔ nanɩ 'yli, 'ɩn ɔ nanɩa -Lagɔ dʋdʋ bhabha. Wa 'nyɛnɩ ɔ 'cʋ ta ɔ didee -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Da ɔ didea palɩa ɔ la, wa 'bhʋa ɔ lʋʋ, Falaɔɔn 'ŋwnɔyu yia ɔ 'wʋbhu. 'Ɩn ɔ yia ɔ zʋ ɔ 'dɛɛ 'yu 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","'Sa wa -slolua Moizɩ gbʋ weee Ezipʋtʋ -nyɩma -yia. 'Ɩn ɔ yia nyɩmɛ 'tɩtɛ -zɛ, ɔ ŋwɛɛ wɛlɩ -yɔ ɔ lɛnʋgbʋnya 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Da ɔ 'yɩa -zʋʋ glʋ 'sɔ, 'ɩn ɔ nɛɛ, ɔ bhelia Izlaɛlɩnyɩma ɔ mnɩa 'yɩa. ");
INSERT INTO kyf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Moizɩ 'yɩa Ezipʋtʋ -nyɩmɛ yabhlo, -zugba ɔ mɩ Izlaɛlɩnyɩmɛ yabhlo 'klɩyɩe 'wʋpada, 'ɩn ɔ yia -mɔɔ lʋpa, 'ɩn ɔ yia Ezipʋtʋ -nyɩmɛ 'bha. ");
INSERT INTO kyf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ɔmɔ dlɩɩ, 'wʋ ɔ bhelia yia we lanʋa nɩɩ, 'mɔ -Lagɔ yia 'wʋbhua, 'ɩn ɔ 'ka wa gbʋ 'wʋsa. 'Ɩn wa 'nɩ we 'wʋlanʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","-Mʋʋ 'bɩgʋ, zlɩ zlɩa, 'ɩn Moizɩ yia Izlaɛlɩ -ylaasɩ 'sɔ gʋda ylɩ. 'Ɩn ɔ 'yɩbha ɔ 'ka wa 'wʋsuslolu, 'ɩn ɔ nɛɛ wa -ylaɛ: ‹Na 'talea, amɩa mɩ bhelia nya, lɛɛ ka 'gbʋ a pʋpalɩ 'klɩyɩe 'wʋa?› ");
INSERT INTO kyf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«'Ɩn -ɔ mɩa ɔ -libheyi 'klɩyɩe 'wʋpalɩda, 'ɩn -mɔɔ yia Moizɩ 'su, 'ɩn ɔ nɛɛ Moizɩ -ylaɛ: ‹-Ɩn 'bhʋlʋ 'mɩ 'yula! Nyɔɔ palɩ -mɩ la -amɩaa 'yugalɩnyɔ -yɔ -amɩaa gbʋwʋbhunyɔ nya? ");
INSERT INTO kyf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Sa -ɩn 'bhaa Ezipʋtʋyu zʋbha, -ɩn 'yɩbha -ɩn 'ka 'sa -amɩ 'bhaa?› ");
INSERT INTO kyf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moizɩ 'nʋa wɛlɩnya -mɩnɩ, tɔʋn, ɔ yia -flii -bho, 'ɩn ɔ yia Madian -dʋdʋ -gʋ mnɩ. -Mɔ ɔ gwalɩa nʋkpasia 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«-Zʋʋ glʋ 'sɔ 'plɩa, da bɛblɛɛ *Sinaii -gɔgɔ mɩa -bha -Lagɔɔ 'anzɩ yabhlo 'tlalɩa Moizɩ 'klʋ, misa -gʋ -su tɛklɛɛ mɩa sida we -kosuu mɩɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Da Moizɩ 'yɩa we -yɔ, 'ɩn ŋwɛgaga yia ɔ sʋbha. Ɔ mɩ -bha bɛda ɔ 'ka we yla, 'ɩn ɔ yia Jejitapɛɛ wɛlɩ 'nʋ, mʋ nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹-Amɩ -wa -na dʋkpasɩɩ -Lagɔ. -Amɩ -wa Ablaamʋ, Izakɩ -yɔ Zakɔbʋʋ -Lagɔ.› 'Ɩn Moizɩ yia tɛlɩe bhli nyanɔ nya ɔ 'nɩ 'maslɛɛn 'yɩbha ɔ 'ka -bha -talɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jejitapɛ nɛɛ ɔ -ylaɛ: ‹-Ɩn -sa -na -sakwla bhʋ 'wʋ. Da -ɩn mɩa dɛ, -mɔwlʋ -da -wa. ");
INSERT INTO kyf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɩn ka na nyɩmaa sɩasɩe -yɔyɩ Ezipʋtʋ -dʋdʋ -gʋ. 'Ɩn ɩn yia wa wiewɛlɩ 'nʋ, 'ɩn ɩn yia lasibhli, ɩn 'ka wa gbʋ 'wʋsa. -Ɩn yi, ɩn 'ka -mɩ tie Ezipʋtʋ -dʋdʋ -gʋ.› ");
INSERT INTO kyf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Ɔɔ Moizɩ -ɔ Izlaɛlɩnyɩma -saa zlɩmɛ kwnɛɛ, 'ɩn wa yia ɔ -yla gbaɛ: ‹Nyɔɔ palɩ -mɩ la -amɩaa 'yugalɩnyɔ -yɔ -amɩaa gbʋwʋbhunyɔ nya?›, 'mɔ Jejitapɛ tiea wa 'yugalɩnyɔ -yɔ wa gbʋwʋsanyɔ nya, -Lagɔɔ 'anzɩ -ɔ 'tlalɩa ɔ 'klʋ misa -gʋ -su tɛklɛɛ nyɩdɩ, ɔ sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moizɩ -saa Izlaɛlɩnyɩma Ezipʋtʋ -dʋdʋ -gʋ. 'Ɩn ɔ yia gbʋ 'kadɩ -yɔ gwɛdigbʋnya lɛnʋ Ezipʋtʋ -dʋdʋ -gʋ, *gumunyu Zalʋ -gʋ, we -yɔ da bɛblɛɛ zʋʋ glʋ 'sɔ nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Ɔɔ Moizɩ gba 'yaa Izlaɛlɩnyɩma -ylaɛ: ‹-Lagɔ yia aɩn ɔ gbʋʋ -falɩpanyɔ yabhlo yoo 'paa, 'mɩ 'bhisa. Amɩaa zʋaylinyɩmɛ yabhlo ɔ yia -mɩa.› ");
INSERT INTO kyf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Da Izlaɛlɩnyɩma gbelia 'wlu da bɛblɛɛ, ɔɔ Moizɩ mɩ -bha. Mɔ -zɛa 'kɔlʋ, -Lagɔɔ 'anzɩ gbaa ɔ -yla gbʋ Sinaii -gɔgɔ 'wlu -yɔ -amɩaa dʋkpasɩ nyɩdɩ. Mɔ -yla -Lagɔ gbaa 'yliyɔgawɛlɩ, 'ɩn ɔ yia we -aɩn -yla gba. ");
INSERT INTO kyf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«'Ɩn -amɩaa dʋkpasɩ 'nɩ 'yɩbha wa 'ka ɔ 'nʋŋwɛ zʋ. 'Ɩn wa yia ɔ kwnɛɛ -sa, wa dlɩ 'yɩbha wa 'ka Ezipʋtʋ -dʋdʋ -gʋ lʋbhiti. ");
INSERT INTO kyf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wa nɛɛ *-Awlɔɔn -ylaɛ: ‹-Ɩn nʋ -aɩn -yla -Lagɔnya lɛ, we 'ka -aɩn 'yugalɩ. Nɩɩ, ɔɔ Moizɩ -ɔ -saa -aɩn Ezipʋtʋ -dʋdʋ -gʋ, -we ylɩa ɔ, -a 'nɩ we -yi.› ");
INSERT INTO kyf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tɔʋn, wa yia 'bhliyu bhla, 'ɩn wa yia we bʋbɔ. Wa sɔɔ lɛnʋlu ka wa 'mʋna 'wʋlaa 'gbʋ, 'ɩn wa yia we 'fɛtɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","'Ɩn -Lagɔ yia wa -blɩgʋ palɩ. Ɔ yia wa kwɛ -yɔsa, wa 'ka yalɩli bʋbɔ. We mɩ 'sa cɛlɩda -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ 'wʋɛ: ‹Izlaɛlɩnyɩma, 'lee -amɩ a 'nyɛa 'nɔɔlunya -yɔ -zila bʋbɔluu tɔlʋa, -zʋʋ glʋ 'sɔ nʋkplɛ da bɛblɛɛ yɩ? ");
INSERT INTO kyf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","-Ɩnnya! A ka amɩaa -lagɔ wa laa Molɔkʋʋ 'naabudu -yɔ -lagɔ wa laa Wlefanɩɩ zuzu 'wʋbhu. Nɩɩ, -li a nʋa lɛ, a 'ka we bʋbɔ, mʋ -wa. We 'gbʋ na yia aɩn galɩ -zɛlɩa dʋdʋ -putu -gʋ, Babilɔnʋgbe lʋʋ 'pɩpɩ.› » ");
INSERT INTO kyf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiɛnɩ nɛɛ 'yaɛ: «-Amɩaa dʋkpasɩ ka bhaa *'naabudu yabhlo kaa 'wʋlanʋnnʋee 'sɛbhɛɛ 'gba zɔ, -mɔ da bɛblɛɛ. Sa -Lagɔ 'paa we ŋwɛɛ Moizɩ -yla, 'sa wa nʋa we. Nɩɩ, ɔ nɛɛ Moizɩ -yla, we 'yli -we ɔ 'yɩa -yɔ, ɔ nʋ we lɛ. ");
INSERT INTO kyf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","-Mʋʋ 'bɩgʋ, 'ɩn -amɩaa dʋkpasɩɩ 'yua yia wee *'naabudu 'wʋbhu -maanʋ nya. *-Zozue -galɩ wa 'yu, nyɩma -Lagɔ vua wa 'yu, 'ɩn wa yia -maa dʋdʋ -gʋ ladɩa mnɩ. 'Ɩn wa -yɔ wee 'naabudu yia -mɔ mnɩ. 'Ɩn we yia -bha -tʋ tɩklɩɩ, 'bhie, nyɩmaa 'wlulapɩlɩnyɔ -Davidɩɩ nʋ bhla yia nyni. ");
INSERT INTO kyf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","-Davidɩ ka -Lagɔɔ 'nanɩ 'yɩ, 'ɩn ɔ yia -Lagɔ 'yoo -zlalɩ ɔ 'ka Zakɔbʋʋ -Lagɔɔ -budu 'sʋbha. ");
INSERT INTO kyf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","'Ɩn nyɩmaa 'wlulapɩlɩnyɔ *Salomɔɔ 'sʋbhaa wee -budu -Lagɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«'Ɩn, -zugba, Yalɩ -Lagɔ'ɔ -dɩlɩ nyɩmɛ 'sʋbha 'sʋbha -budu zɔ la. Sa -Lagɔgbʋʋ -falɩpanyɔ gbaa we 'sa. ");
INSERT INTO kyf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jejitapɛ nɛɛ: ‹Yalɩ -wa na 'ŋnɩmnɩkpe, 'ɩn dʋdʋ -gʋ na dɩa na bhʋ la. -Budu -mʋmʋ a mneni a 'ka 'mɩ -yla 'sʋbha? 'Ɩn da ɩn mneni ɩn 'ka ladɩa? ");
INSERT INTO kyf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","'Lee -amɩ 'nɩ we 'dɛ weee lalaa?› » ");
INSERT INTO kyf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiɛnɩ nɛɛ 'yaɛ: «-Glacɩaan yukwliyɔsulonya, amɩaa dlɩ -yɔ amɩaa yukwli mɩ 'wʋsuluda -Lagɔɔ lalawɛlɩ -yla. 'Ɩn a zʋa -gla Zuzu 'Pʋpa -yla 'kɔmʋʋ. A 'wlʋ sa amɩaa dʋkpasɩ! ");
INSERT INTO kyf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","-Lagɔgbʋʋ -falɩpanyɔ -mɔmɔ amɩaa dʋkpasɩ 'nɩ 'klɩyɩe 'wʋpalɩa? 'Ɩn -wa gbaa zlɩmɛ Nyɩmɛ Tɩklɩɩ yabhlogbɔɔɔ yiyigbʋ, wa ka -maa 'bha. 'Ɩn -slɛɛn, 'mɔ a wlaa, 'ɩn a yia ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","-Lagɔ ka ɔ tite aɩn yoo 'nyɛ -Lagɔɔ 'anzɩɩ sɔ nya. 'Ɩn a 'nɩ we 'nʋŋwɛ zʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Da gbʋwliwʋdɩnya 'nʋa wɛlɩnya -mɩnɩ, 'ɩn 'cɛ yia wa dlɔ yi. Wa lia gla 'wʋ, 'ɩn wa yia Etiɛnɩ 'cɛ -yɔ 'palɩ. ");
INSERT INTO kyf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Zuzu 'Pʋpa mɩ Etiɛnɩ yedaa 'gbʋ, ɔ ylaa yalɩ, 'ɩn ɔ yia -Lagɔɔ 'ŋnɩmnɩe 'kadʋ -yɔyɩ, -zugba -Zezu 'yligbe -Lagɔɔ lilisɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","'Ɩn ɔ nɛɛ: «A -talɩ, na yɩ yalɩ -yɔ ŋwɛ -kalɩda, 'ɩn, -zugba, *Nyɩmɛɛ 'Yu 'yligbe -Lagɔɔ lilisɔlʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tɔʋn, wa yia 'wʋkpɩ 'tɩtɛɛ, 'ɩn wa yia yukwli 'wʋsulu. 'Ɩn wa 'dɛ weee yia ɔ -gʋslo dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","'Ɩn wa -yɔ ɔ 'susue yia 'gbe -gnima mnɩ, -zugba wa bha ɔ gbɔkʋ 'wʋ. 'Ɩn -bhayɩnya yia -maa -bananya nyimeslɔyu yabhlo wa laa Sɔlʋ -yɔtɩ, -mɔɔ 'ka we 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Da wa mɩa Etiɛnɩ gbɔkʋ 'wʋbhada, 'ɩn ɔ yia -Lagɔ bhubhoe, ɔ nɛɛ: «Na -Kanyɔ -Zezu, -ɩn 'bhu na zuzu 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","-Mʋʋ 'bɩgʋ, ɔ yia 'kukolu 'sibhli, 'ɩn ɔ yia 'wʋkpɩ 'tɩtɛɛ: «Jejitapɛ, -ɩn 'na dɩlɩ gbʋnyuu -mɩnɩɩ 'gba wa 'wlu -nɩ!» Ɔ bhɩa 'sa gbagbɩe tɔʋn, ɔ yia 'yli 'mu. ");
INSERT INTO kyf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔlʋ -yɔ -wa 'bhaa Etiɛnɩ ka dlɩ -bhlo. Wee 'ylɩ -bhloo 'dɛ nya, wa bhlia -Zeluzalɛmʋʋ leglizɩ 'klɩyɩe 'wʋpalɩe. 'Ɩn -Lagɔnyɩma weee yia lamneni Zudee -yɔ Samalii -dʋdʋ -gʋ. -Zezuu tietienya 'dɛkpʋa -tʋa -Zeluzalɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","'Ɩn nyɩma -wa zʋa -bha -Lagɔ, yia Etiɛnɩɩ 'kwie -gʋ wili bhabha, 'ɩn wa yia ɔ 'bhlu. ");
INSERT INTO kyf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔlʋ 'tɛmanɩa 'kʋa la, ɔ 'ka leglizɩ lasa, -zugba ɔ mnɩ -budunya zɔ -bhlo -bhlo, 'ɩn ɔ kpa -Lagɔnyɩma, nʋkpasia -yɔ 'ŋwnɩ ɔ pa wa -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","-Lagɔnyɩma -wa mnenia la dʋdʋ weee -gʋ, wa mnɩ mɔ, wa yi mɔ, -Lagɔgbʋʋ gbagbɩe nya. ");
INSERT INTO kyf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipʋ yia Samaliii 'gbe 'kadʋ yabhlo nʋkplɛ mnɩ, 'ɩn ɔ yia -mɔ nyɩma -yla -Lagɔɔ -Bhasanyɔɔ gbʋ -gbagbɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nyɩmaa -zlo pʋlʋa Filipʋʋ wɛlɩ yukwli flɩlɩɩ, -we wa 'nʋa, 'ɩn gwɛdigbʋ ɔ nʋa lɛ, wa yɩa -yɔɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nɩɩ, zuzu 'nyii yia guzʋnyaa -zlo 'wʋtla 'wʋkpɩkpɩe nya, 'ɩn 'kukunya -yɔ 'tɩgɩtɩgɩnya duun yi 'yaa 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Ɩn we yia 'mʋna 'kadʋ -zɛ, wee 'gbe -mɩnɩ nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","We bhla, nyɩmɛ yabhlo mɩ 'cɩn wee 'gbe nʋkplɛ, 'mɔ wa laa 'Simɔɔ. -Dlabhia -nyakpɔɔ nʋnyɔ -wa. 'Ɩn ɔ sʋbhalɩa *Samalii -nyɩma weee ŋwɛgaga. 'Ɩn ɔ laa ɔ 'dɛ nyɩmɛ -zɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","'Ɩn we 'ka 'nyɛnyɛyua -yɔbhu, we 'ka nyɩma kpasɩ ylɩ, wa 'dɛ weee pʋlʋa ɔ yukwli flɩlɩɩ. Wa nɛɛ: «Ɔɔ nyɩmɛ -mɔnɩ, -Lagɔɔ 'tɩtɛ -wa, -we wa laa 'Tɩtɛ 'Kadʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɔ ka -dlabhia -nyakpɔ nʋda -gwlɛ, -zugba we sʋbhalɩ nyɩma ŋwɛgagaa 'gbʋ, wa pʋlʋa ɔ wɛlɩ yukwli flɩlɩɩ. ");
INSERT INTO kyf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'Ɩn -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ -yɔ -Zezu Klisɩɩ gbʋ -zɔnʋ Filipʋ gbaa. -Wa weee ŋwnua we -yɔ, nʋkpasia -yɔ 'ŋwnɩ, 'ɩn ɔ yia wa batizee. ");
INSERT INTO kyf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","'Simɔɔɔ 'dɛ ka we -yɔŋwnu, 'ɩn wa yia ɔ batizee. Ɔ yia Filipʋ kwesi -tʋ. Gwɛdigbʋ -yɔ gbʋ 'kadɩ mɩa lɛnʋda, -we ɔ yɩa -yɔ, 'ɩn we yia ɔ ŋwɛgaga -sʋbhalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","-Zezuu tietienya mɩa -Zeluzalɛmʋ 'nʋa nɩɩ, Samalii -nyɩma ka -Lagɔgbʋ -yɔŋwnu, 'ɩn wa yia wa -gbɛ Piɛlɩ -yɔ *Zaan tie. ");
INSERT INTO kyf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Da Piɛlɩ -yɔ Zaan nynia Samalii -dʋdʋ -gʋ, 'ɩn -maa yia -Lagɔ bhubhoe, -wa ŋwnua -Lagɔgbʋ -yɔ, wa 'ka Zuzu 'Pʋpa 'yɩɩ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nɩɩ, Zuzu 'Pʋpa 'nɩ wa glaa nyɩmɛ yabhlogbɔɔ -gʋ lasibhli -slɔ. Nyɩmaa -Kanyɔ -Zezuu 'ŋnɩ nya -bhlogbɔɔ wa batizea wa. ");
INSERT INTO kyf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Ɩn Piɛlɩ -yɔ Zaan 'sɔ yia wa sɔ 'wluo lapalɩ, 'bhie, wa yia Zuzu 'Pʋpa 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Da 'Simɔɔ 'yɩa we -yɔ nɩɩ, -Zezuu tietienya -ka nyɩma -wa ŋwnua -Lagɔgbʋ -yɔ sɔ 'wluo lapalɩ, 'ɩn wa yɩa -Lagɔɔ Zuzu nɩ, 'ɩn ɔ yia Piɛlɩ -yɔ Zaan 'gwɛzi -la. ");
INSERT INTO kyf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","'Ɩn ɔ nɛɛ: «A 'nyɛ 'ya -amɩ wee se -mɩnɩ, 'ɩn -ɔ ɩn -ka sɔ 'wluo lapalɩ, -mɔɔ 'ka Zuzu 'Pʋpa 'yɩ!» ");
INSERT INTO kyf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'Ɩn Piɛlɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Ɩn -yɔ -na 'gwɛzi 'bhʋ la dabʋdʋ! -We ka gbʋ -wa, -mɩ dlɩɩ, -Lagɔɔ wlawlalu mɩa, wa mneni wa 'ka we zɔ 'gwɛzi nya! ");
INSERT INTO kyf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","-Na dlɩ 'nɩ 'ylinanɩ -Lagɔ 'yliya 'wʋʋ 'gbʋ, -ɩn 'nɩ -lu yabhlogbɔɔ -ka gbʋ -mɩnɩ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","-Ɩn 'bhiti -na dlɩ, -ɩn bhubhoe Jejitapɛ, -de ɔ mneni ɔ 'ka -na 'wlukʋʋn lapʋpalɩe 'nyuu -yɔgbʋ 'wʋtɩɩ? ");
INSERT INTO kyf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na yɩ we -yɔ nɩɩ, -ɩn 'tɛ dlɩ kalɔ, 'ɩn -ɩn mɩ gbʋnyuuu gaylo nya.» ");
INSERT INTO kyf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","'Ɩn 'Simɔɔ nɛɛ Piɛlɩ -yɔ Zaan -ylaɛ: «Amɩaa 'dɛ bhubhoe -Lagɔ na -nʋ nya. -Delee gbʋ -we a gbaa da, we yi 'mɩ ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","-Mʋʋ 'bɩgʋ, wa bhɩa -we ka da wa 'yɩa, we -yɔ -Lagɔgbʋʋ gbagbɩe, 'ɩn waa -Zezuu tietienya 'sɔ yia lʋbhiti -Zeluzalɛmʋ. Wa mɩ mnɩda, -zugba wa -yɔ -Lagɔgbʋʋ gbagbɩe mnɩa Samaliii 'gbe duun nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jejitapɛɛ 'anzɩ yabhlo nɛɛ Filipʋ -ylaɛ «'Ylʋʋ 'wʋsɔlʋda lilisɔlʋ, 'yoo -we 'bhʋa -Zeluzalɛmʋ, 'ɩn we yia -Gazaagbe 'wʋ mnɩ, -ɩn -sɔ 'wʋ, -ɩn mnɩ -mɔ.» -Bʋsɛ -dʋdʋ bɛblɛɛ -gʋ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","-Bha -bhlokpadɛ, Filipʋ -sɔa 'wʋ, 'ɩn ɔ yia mnɩ. 'Ɩn ɔ -yɔ nyɩmɛ yabhlo yia gbeli, lɛlɩlɛlɩnyɔ yabhlo -wa. Etiopii -dʋdʋ -gʋʋ 'wlulapɩlɩŋwnɔ Kandasɩɩ lubho ɔ nʋa, 'ŋnɩmnɩlii 'yliyɔzʋnyɔ 'kadʋ -wa. -Zeluzalɛmʋ ɔ yia, ɔ 'ka -Lagɔ bʋbɔ, ");
INSERT INTO kyf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","'ɩn ɔ mɩa ɔ dʋdʋ -gʋ lʋmnɩda. Ɔ mɩ ɔ nɩmɛsʋʋn -wotloo 'wʋ, -zugba ɔ zɛlɩ 'sɛbhɛ -we -Lagɔgbʋʋ -falɩpanyɔ *Ezaii cɛlɩa. ");
INSERT INTO kyf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","-Lagɔɔ Zuzu nɛɛ Filipʋ -ylaɛ «-Ɩn mnɩ, -ɩn nyni -wotloo mɩa nɩ -yɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipʋ -yɔ -gwagwɩe yia we -yɔnyni, ɔ 'nʋa -Lagɔgbʋʋ -falɩpanyɔ Ezaiii 'sɛbhɛ Etiopiyu mɩa zɛlɩda nɩ, 'ɩn ɔ yia ɔ layɩbha. Ɔ nɛɛ ɔ -ylaɛ: «-We -na zɛlɩa dɛ, -na nʋ we 'wʋlaa?» ");
INSERT INTO kyf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","-Mɔɔ nɛɛ ɔ -ylaɛ: «Nyɩmɛ 'nɩ 'mɩ -yla we gwe -sa, sa ɩn 'ka we 'wʋlanʋa?» 'Ɩn ɔ nɛɛ Filipʋ -ylaɛ: «-Ɩn -gbla -wotloo 'wʋ, -ɩn -dɩ 'mɩ kwesi la.» ");
INSERT INTO kyf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","-Lagɔsɛbhɛɛ 'ya -we ɔ mɩa zɛlɩda mʋ nɩ: «Ɔ 'wlʋ sa bhlabhlɛ -we wa kwa we 'bhalɩda, ɔ 'nɩ ŋwɛ gba. 'Ɩn ɔ 'wlʋ sa *bhlabhlɛyu -we'e gba, we nyanɩɩ -gʋdɩnyɔ 'yu, ɔ 'nɩ ŋwɛ gba. ");
INSERT INTO kyf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wa ka ɔ 'wʋtɩ 'kienyi, ɔ 'nɩ -gʋgbʋgbanyɔ tɩklɩɩ 'yɩ. Nyɔɔ 'ka ɔnʋʋ 'yuaa 'dɩ -sa? Nɩɩ, wa ka ɔ lasa dʋdʋ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopiyu nɛɛ Filipʋ -ylaɛ: «-Na zukpa -wa, nyɔɔ ka gbʋ -Lagɔgbʋʋ -falɩpanyɔ gba sa? Ɔ 'dɛɛ gbʋ -wa yaayɩɩ, nyɩmɛ -putuu gbʋ ɔ gbaa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tɔʋn Filipʋ yia we -gʋsa. 'Ɩn ɔ yia wee -Lagɔsɛbhɛɛ 'ya kibhe -mɩnɩ -gʋ -Zezuu gbʋ -zɔnʋʋ gbagbɩe bhli ɔ -yla. ");
INSERT INTO kyf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wa mɩ sa mnɩda, 'ɩn wa yia 'yloogblʋʋ da yabhlo 'nyu ylɩ, 'ɩn Etiopiyu nɛɛ: «Nyu mɩa da! Lɛɛ -lu ka 'gbʋ -ɩn 'na 'ka 'mɩ batizea?»  ");
INSERT INTO kyf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipʋ nɛɛ ɔ -yla: «Wa mneni wa 'ka -mɩ batizee, -zugba -ɩn -ka -Zezu dlɩ -gʋ zʋ dlɩ weee nya.» Etiopiyu nɛɛ: «Ɩn zʋ we dlɩ -gʋ nɩɩ, -Zezu Klisɩ mɩ -Lagɔɔ 'Yu nya.» ");
INSERT INTO kyf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tɔʋn, ɔ yia -wotloo 'yligbeli, 'ɩn Filipʋ -yɔ ɔ 'sɔ yia 'nyu lʋ -bho, 'ɩn Filipʋ yia ɔ batizee. ");
INSERT INTO kyf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Da wa 'tlaa 'nyu lʋ nɩ, 'ɩn -Lagɔɔ Zuzu yia Filipʋ -bha lasalɩ, Etiopiyu 'nɩ 'maslɛɛn ɔ 'yɩ. Tɔʋn, 'ɩn ɔ yia ɔ 'yloogblʋ 'wʋbhu 'mʋna nya. ");
INSERT INTO kyf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipʋ mɩa nɩ, -mɔɔ mɩ Azɔtʋ! -Lagɔgbʋ -zɔnʋ ɔ gbaa 'gbenya nʋkplɛ. Danya ɔ plɩlɩa tɩklɩɩ, ɔ 'ka Sezalee nyni. ");
INSERT INTO kyf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","We bhla, Sɔlʋ gbaa 'kɔmʋʋ ɔ 'ka Nyɩmaa -Kanyɔɔ 'bɩnɔnya 'bha, 'ɩn ɔ yia *-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ 'yɩa mnɩ -Zeluzalɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'Ɩn ɔ nɛɛ -mɔɔ -yla, -mɔɔ cɛlɩ 'sɛbhɛnya *-Lagɔbudunya 'wʋ -Damasɩgbe nʋkplɛ. Nyɩma -wa mɩa -Zezuu 'Yloogblʋ -gʋ, ɔ -ka -mɔ wa ylɩ, ɔ kpa wa, we yi nʋkpasia -zɛoo, we yi 'ŋwnɩ -zɛoo, ɔɔ Sɔlʋ 'ka wa 'llukpe palɩ, 'ɩn ɔ 'ka wa -Zeluzalɛmʋ kwa. ");
INSERT INTO kyf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ɔ mɩ sa -Damasɩ mnɩda, ɔ 'ka wee 'gbee ŋwɛ -yɔbɛa yi, tɔʋn, san yabhlo yia yalɩ 'bhʋ, 'ɩn we -nyumalɩ yia ɔ gbeli. ");
INSERT INTO kyf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","'Ɩn ɔ yia bhli dʋdʋ, 'ɩn ɔ yia wɛlɩ yabhlo 'nʋ. -Mʋʋ nɛɛ ɔ -ylaɛ: «Sɔlʋ, Sɔlʋ, lɛɛ ka 'gbʋ -na palɩ 'mɩ 'klɩyɩe 'wʋa?» ");
INSERT INTO kyf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","'Ɩn ɔ yia we 'bɩgʋpalɩ: «Na -Kanyɔ, nyɔɔ -ɩn -mɩa?» «-Amɩ -Zezu, -ɩn mɩa 'klɩyɩe 'wʋpalɩda, -amɩ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","-Ɩn -sɔ 'wʋ, -ɩn pla gbe nɩ 'wʋ, 'ɩn -we -ɩn 'kaa lɛnʋ, wa 'ka we -mɩ -yla gba.» ");
INSERT INTO kyf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nyɩma -wa -yɔ Sɔlʋ 'sɔ mɩa, wa yia 'yligbe, wa'a -sa gbʋ -gʋ nyanɔ nya. Wɛlɩ -we gbaa 'nʋ wa nʋ we, 'ɩn wa'a 'yɩ nyɩmɛ yabhlogbɔɔ -yɔ. ");
INSERT INTO kyf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔlʋ 'kaa dʋdʋ 'wʋsɔ, ɔ 'yli mɩ -bloda, -zugba ɔ'ɔ 'yɩ -lu yabhlogbɔɔ -yɔ. Ɔ sɔ wa kpaa la, 'ɩn wa -yɔ ɔ 'sɔ yia -Damasɩ pla. ");
INSERT INTO kyf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ɔ li 'ylɩ ta, ɔ'ɔ 'yɩ la, 'ɩn ɔ'ɔ li, ɔ'ɔ 'ma. ");
INSERT INTO kyf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","-Zugba -Zezuu 'bɩnɔnyɔ yabhlo wa laa Ananiasɩ ɔ mɩ -Damasɩ. Nyɩmaa -Kanyɔ nɛɛ ɔ -yla -mɔ ɔ 'yli 'wʋ: «Ananiasɩ!» 'Ɩn ɔ yia ŋwnu, ɔ nɛɛ: «Nyɩmaa -Kanyɔ, -amɩ nɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nyɩmaa -Kanyɔ nɛɛ ɔ -ylaɛ: «-Ɩn -sɔ 'wʋ dɛslɛɛn, -gwele wa laa 'Wʋsna -Gwele, -ɩn 'plɩlɩ we -gʋ. -Ɩn mnɩ Zudasɩɩ -budu zɔ, Talɩsɩyu yabhlo wa laa Sɔlʋ, ɔ mɩ -Lagɔ bhubhoeda, -ɩn 'yɩbha ɔ -yɔla. ");
INSERT INTO kyf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","'Ɩn -mɔ ɔ 'yli 'wʋ, ɔ ka nʋkpasu yabhlo wa laa Ananiasɩ -yɔyɩ plada, 'ɩn -mɔɔ yia ɔ sɔnya -gʋ lapalɩ, 'ɩn ɔ 'ka lalolu 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasɩ yia we 'bɩgʋpalɩ: «'A! Na -Kanyɔ, ɩn ka 'nʋ nyɩma duun ŋwɛɛ nɩɩ, nyɩmɛ nɩ ka -na nyɩma tɩklɩɩ gbʋnyuu 'wluo nʋ -Zeluzalɛmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","'Ɩn -seli ɔ yia da, -Lagɔbʋbɔnyaa -cɩan ka we se ɔ 'nyɛ, nɩɩ, nyɩma weee, -wa gbaa -na 'ŋnɩ, ɔ kpa wa, 'ɩn ɔ 'ka wa 'llukpe palɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nyɩmaa -Kanyɔ nɛɛ ɔ -ylaɛ: «-Ɩn mnɩ! Nɩɩ, ɩn ka -bha nyɩmɛ -mɔnɩ -sa na lubhonʋlu yabhlo nya. Nyɩma -wa 'nɩa Zuifʋ klaa, wa dʋdʋʋ 'wlulapɩlɩnya klaa, Izlaɛlɩnyɩma klaa, ɔ 'ka wa na 'ŋnɩ -slolu. ");
INSERT INTO kyf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Sa ɔ 'kaa sɩa na 'ŋnɩɩ 'gbʋ, na dɛ yia -mʋʋ ɔ -slolua.» ");
INSERT INTO kyf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tɔʋn, Ananiasɩ yia mnɩ. Ɔ nynia wee -budu zɔ, 'ɩn ɔ yia Sɔlʋ sɔnya -gʋ lapalɩ. 'Ɩn ɔ nɛɛ ɔ -ylaɛ: «Sɔlʋ, na bheli, da -ɩn mɩa yida nɩ, Nyɩmaa -Kanyɔ -Zezu ka -mɩ 'klʋtlalɩ 'yloogblʋ. Mɔ tiea 'mɩ, -ɩn 'ka lalolu 'yɩ, 'ɩn Zuzu 'Pʋpa 'ka -mɩ ye.» ");
INSERT INTO kyf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","-Bha -bhlokpadɛ, -lu yabhlo 'bhʋa Sɔlʋ 'yliya 'wʋ gaza -kwɩkwɩ 'bhisa, we yia bhli, 'ɩn ɔ yia layɩyɩe lolu bhli. Ɔ -sɔa 'wʋ, 'ɩn wa yia ɔ batizee. ");
INSERT INTO kyf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tɔʋn, ɔ bhɩa lilie, 'ɩn 'kʋa yia ɔ 'yli yi. Sɔlʋ -yɔ -Zezuu 'bɩnɔnya ka -tʋ 'ylɩ sanɩmɛ nya -Damasɩ. ");
INSERT INTO kyf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ɔ yia -bha -bhlokpadɛ -Zezuu gbʋʋ gbagbɩe bhli *-Lagɔbudu zɔ. Ɔ nɛɛ: «-Zezu mɩ -Lagɔɔ 'Yu nya.» ");
INSERT INTO kyf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nyɩma -wa 'nʋa ɔ wɛlɩ, ŋwɛgaga yia wa sʋbha, 'ɩn wa nɛɛ: «Nyɩmɛ -ɔ palɩdaa nyɩma -wa gba -Zezuu 'ŋnɩ 'klɩyɩe 'wʋ, mɔ 'nɩ dɛ mɩɩ? 'Ɩn gbʋ -gble sa, ɔ 'nɩ dɛ wa kpaa yi, 'ɩn ɔ 'ka wa -Lagɔbʋbɔnyaa -cɩan kwaa?» ");
INSERT INTO kyf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'Ylɩ weee nya, Sɔlʋ gbaa -Zezuu gbʋ 'tɩtɛ nya. Da ɔ gbaa -Zezu -wa -Lagɔɔ -Bhasanyɔ nɩ, Zuifʋnya mɩa -Damasɩ, -we wa 'kaa gba, we 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'Ylɩ sanɩmɛ plɩa, 'ɩn Zuifʋ yia 'wʋlanʋnnʋ, wa 'ka Sɔlʋ 'bha. ");
INSERT INTO kyf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Ɩn Sɔlʋ yia we 'nʋ. 'Ylɩ weee nya, zlɩ -yɔ sabɔ, -zugba wa mɩ gbee plalɩdanya ŋwɛgʋda, wa 'ka ɔ 'bhaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","'Ylɩ yabhlo nya, sabɔ, nyɩma -wa -yɔ Sɔlʋ 'sɔ mɩa, wa yia ɔ -cɩcɛ 'wʋ ladɩ. 'Ɩn wa yia ɔ 'suo -we gbelia 'gbe, we 'wlubita -lalɩ, 'ɩn wa yia ɔ we lʋʋ lasibhli. ");
INSERT INTO kyf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔlʋ nynia -Zeluzalɛmʋ nɩ, 'ɩn ɔ yia -Zezuu 'bɩnɔnya lʋbhobhoe layla. -Maa weee yia ɔ sɔsʋe bhli. Wa 'yabhlo 'nɩ we dlɩ 'wʋdɩ nɩɩ, Sɔlʋ mɩ -Zezuu 'bɩnɔnyɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabasɩ yia ɔ 'wʋbhu, 'ɩn ɔ -yɔ ɔ 'sɔ yia tietienyaa -gbɛ mnɩ. 'Ɩn ɔ yia wa -yla Sɔlʋʋ gbʋ gba. Sa Sɔlʋ -yɔ Nyɩmaa -Kanyɔ 'sɔ gbelia, 'ɩn ɔ yia ɔ -yla gbʋ gba klaa, 'ɩn sa Sɔlʋ gbaa -Lagɔgbʋ -Zezuu 'ŋnɩ nya -Damasɩ, -zugba nyanɔ 'nɩ ɔ dlɩɩ -mɩ, Banabasɩ yi 'yaa -mʋʋ gba wa -yla. ");
INSERT INTO kyf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","-Mʋʋ bhla, Sɔlʋ -yɔ tietienya mɩ. Ɔ mnɩ, 'ɩn ɔ yia wa -gbɛ -Zeluzalɛmʋ, -zugba ɔ gba -Lagɔgbʋ Nyɩmaa -Kanyɔɔ 'ŋnɩ nya, nyanɔ 'nɩ ɔ dlɩɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zuifʋ -wa gbaa glɛkɩwɛlɩ, ɔ -yɔ wa yia 'wʋgbeli, 'ɩn wa yia wɛlɩ 'wʋsɩsalɩ. Nɩɩ, -maa mɩ ɔ dideda, wa 'ka ɔ 'bha. ");
INSERT INTO kyf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","-Lagɔnyɩma 'nʋa sa we, 'ɩn wa yia Sɔlʋ Sezalegbe 'wʋ kwa. 'Bhie, wa yia ɔ yoo 'pa Talɩsɩgbe nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","-Mʋʋ bhla -leglizɩɩ -yɔ -dlɔɔ, Zudee -yɔ Galilee -yɔ Samalii -dʋdʋ weee -gʋ. -Zugba wa tɛmanɩ dlɩ, 'ɩn wa zʋ Nyɩmaa -Kanyɔ 'nʋŋwɛ. 'Ɩn Zuzu 'Pʋpa yia wa 'wʋsa, 'ɩn wa yia 'wʋzumanɩe bhli. ");
INSERT INTO kyf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","We -ka Piɛlɩ, -mɔɔ mɩa dʋdʋ weee -gʋ 'plɩlɩda -Lagɔnyɩma 'wʋtalɩe nya. 'Ylɩ yabhlo nya, 'ɩn ɔ yia -Lagɔnyɩma -wa mɩa Lidaagbe nʋkplɛɛ -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","'Ɩn ɔ yia -mɔ nyɩmɛ yabhlo wa laa Enee 'yɩ, -zugba -mɔɔ pɩ -mɔɔ -bita -gʋ la -zʋ gbeta, ɔ 'kukuee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piɛlɩ nɛɛ ɔ -ylaɛ: «Enee! -Zezu Klisɩ ka -mɩ pue. -Ɩn -sɔ 'wʋ, -ɩn glɩ -na -bita -na 'dɛ nya.» -Bha -bhlokpadɛ Enee -sɔa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidaa -nyɩma weee -yɔ Salɔɔn -dʋdʋ -gʋ -nyɩma weee 'yɩa ɔ -yɔ nɔda nɩ, 'ɩn wa yia -Lagɔ pla. ");
INSERT INTO kyf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nɩɩ, 'ŋwnɔ yabhlo mɩ -Zopeegbe 'wʋ, -Zezuu 'bɩnɔŋwnɔ ɔ mɩa. 'Mɔ wa laa Tabitaa, we ji -wa «lue» glɛkɩwɛlɩ 'wʋ. 'Ylɩ weee nya, ɔ nʋa gbʋzɔnʋ gbʋ lɛ, 'ɩn ɔ bɛa bobabhanya -yɔ. ");
INSERT INTO kyf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","'Ylɩ yabhlo nya, 'ɩn ɔ yia gu bhli, 'ɩn ɔ yia tlɩ. Wa budoa ɔ 'kwie, wa yia we lapalɩ -budu 'wlu, -mɔ komi yabhlo zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","-Zezuu 'bɩnɔnya -wa mɩa -Zopee, wa ka 'nʋ nɩɩ, Piɛlɩ mɩ Lidaagbe 'wʋ, -we mɩa -Zopee kwesi. Wa yia nyɩma 'sɔ tie, nɩɩ, wa mnɩ ɔ laa wɛlɩ nɩ nya: «-Na zukpa -wa, -ɩn 'na -gwlɛlɩ -mɔ -nɩ. -Ɩn yi!» ");
INSERT INTO kyf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tɔʋn, Piɛlɩ -sɔa 'wʋ, 'ɩn ɔ -yɔ wa yia mnɩ. Da ɔ nynia -mɔ, 'ɩn wa yia ɔ wee komi -we mɩa -budu 'wlu zɔ kwa. -Dʋgbaŋwnɩ weee bɛa ɔ kwesi wie nya. Zɔbana -yɔ -bana -we Tabitaa nʋa lɛ, -zugba ɔ -ga 'yliyɔ, 'mʋ wa -slolua ɔ 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piɛlɩ wlelia nyɩma weee -budu zɔ, ɔ kʋlʋa 'kukolu 'yli, 'ɩn ɔ yia -Lagɔ bhubhoe. Ɔ 'bhitia 'kwiee gbɛgbɛɩn, 'ɩn ɔ nɛɛ: «Tabitaa, a -sɔ 'wʋ!» Tabitaa -bloa 'yli, ɔ 'yɩa Piɛlɩ -yɔ, 'ɩn ɔ yia 'wʋsɔ, ɔ yia ladɩ. ");
INSERT INTO kyf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛlɩ kpalɩa ɔ sɔ -yɔ, 'ɩn ɔ yia ɔ 'wʋbhu. Ɔ laa -Lagɔnyɩma -yɔ -dʋgbaŋwnɩ, 'ɩn ɔ yia ɔ wa 'klʋslolu, -zugba ɔ -ga 'yliyɔ. ");
INSERT INTO kyf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","-Zopeegbe 'wʋ -nyɩma weee yia we 'nʋ. -Bha nyɩma duun zʋa Nyɩmaa -Kanyɔ dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛlɩ ka 'ylɩ sanɩmɛ li -mɔ -Zopee, -zelibhanyɔ yabhlo wa laa 'Simɔɔɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","-Mɔ Sezalee, nʋkpasu yabhlo mɩ -mɔ, 'mɔ wa laa Kɔlʋnɛɩ. Wlɔmʋʋ 'slʋjaa 'wlu ta lʋ -slʋja glʋ gbu -zakpa -bhlo wa laa Italii -nyɩma, wa 'yugalɩnyɔ ɔ -mɩa. ");
INSERT INTO kyf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nʋkpasu -mɔnɩ, -Lagɔ ɔ zʋa -bha. 'Ɩn ɔ -yɔ ɔ -buduŋwɛɛ -nyɩma sɔ sɔa -Lagɔ. Zuifʋʋ bobabhanya duun ɔ saa 'wʋ. 'Ɩn ɔ bhubhoea -Lagɔ 'kɔmʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","'Ylɩ yabhlo nya, jibheza, lɛlɩɩ tanʋ nya, -Lagɔɔ 'anzɩ yabhlo yia ɔ 'klʋtlalɩ ɔ 'yli 'wʋ. Kɔlʋnɛɩ yia we -yɔyɩ vaa. 'Ɩn -mʋʋ yia ɔ -gbɛ pla. 'Ɩn we nɛɛ ɔ -ylaɛ: «Kɔlʋnɛɩ!» ");
INSERT INTO kyf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ɔ ylaa -Lagɔɔ 'anzɩ tenyii, 'ɩn -nyanɩgbɔ yia ɔ -kpalɩ. Ɔ nɛɛ we -ylaɛ: «Na -Kanyɔ, lɛɛ -lu we -ma?» -Lagɔɔ 'anzɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Na -Lagɔɔ bhubhoe wɛlɩ -yɔ zʋzɔnʋnya -ɩn nʋa bobabhanya -yla lɛ, -Lagɔ ka we gbʋ -yɔŋwnu. Ɔ 'nɩ -mɩ 'wʋdlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","-Ɩn tie dɛslɛɛn nyɩma -Zopee, nyɩmɛ yabhlo mɩ -bha, 'mɔ wa laa Simɔ Piɛlɩ. Wa -yɔ ɔ 'ka yi. ");
INSERT INTO kyf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","-Zelibhanyɔ wa laa 'Simɔɔ, -ɔ ka -budu mɩa gumunyuu -gɔgɔ -gʋ nɩ, ɔ -gbɛ Piɛlɩ mɩa.» ");
INSERT INTO kyf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Da -Lagɔɔ 'anzɩ -we -laa ɔ wɛlɩ mnɩa, tɔʋn, 'ɩn Kɔlʋnɛɩ yia ɔ zɔlubhonʋnya 'sɔ -yɔ ɔ 'slʋjayu yabhlo mɩa ɔ lubho nʋda la. Nɩɩ, ɔɔ 'slʋjayu mɩa, -Lagɔ -mɔɔ zʋ 'yaa -bha. ");
INSERT INTO kyf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Gbʋ -we 'plɩa, ɔ gbaa we 'bɩgʋ wa -yla weee 'bhie, ɔ yia wa tie -Zopee. ");
INSERT INTO kyf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","We zlɩ zlɩa, da wa mɩa -slɔ 'yloogblʋ, 'ɩn wa mɩ -Zopee -yɔ cɩpada, -bha Piɛlɩ -gblaa -budu 'wlu . Midiii gbɛgbɛɩn, ɔ -gblaa -mɔ, 'ɩn ɔ 'ka -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","-Slɛɛn, ŋwɔ 'bhaa ɔ, ɔ 'yɩbha ɔ 'ka li. Da wa mɩa ɔ -yla lililu pida, -bha -lu yabhlo -Lagɔ 'paa yoo yia ɔ 'yli -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɔ 'yɩa yalɩ -yɔ ŋwɛ -kalɩda, -bha -lu yabhlo 'bhʋa -mɔ. Wee -lu mɩa, we 'wlʋ sa 'naa 'kadʋ, mʋ 'bhʋa yalɩ, nɛɛ -lu wa kpa la gwɩgwɩ -mnʋa 'yli, 'ɩn we yia kwli. ");
INSERT INTO kyf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","'Ɩn nɩma weee -we kaa 'lali -mnʋa klaa, lagbizeli -nɩma klaa, we -yɔ zia weee mɩ we 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wɛlɩ yabhlo nɛɛ ɔ -ylaɛ: «Piɛlɩ, -ɩn -sɔ 'wʋ, -ɩn 'bha, 'ɩn -ɩn 'ka li!» ");
INSERT INTO kyf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nɩɩ, Piɛlɩ 'palɩa we 'bɩgʋ: «'Ao! -Ɩnnya! Na -Kanyɔ, -we ka gbʋ -wa, ɩn 'nɩa -slɔ pʋɩnkanɩmɛ -yɔ -na -gba li.» ");
INSERT INTO kyf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wee wɛlɩ -bhlokpadɛ -zakpa 'sɔnʋ yia gba, we nɛɛ: «-We -Lagɔ tɩa 'wʋ 'wlalaa nɩ, -mɩ 'na 'yɩlɩ we pʋɩnkalu 'bhisa -nɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","We 'plɩlɩ 'wʋ la -zakpa ta, 'ɩn wee -lu yia yalɩ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nɩɩ, -we ɔ 'yɩa dɛ ɔ 'yli 'wʋ, we 'ji Piɛlɩ 'yɩbhaa ɔ 'dɛ la, 'lee sa -mʋʋ 'ji 'ka -mɩa? Wee bhla nɩ nya, nyɩma -wa Kɔlʋnɛɩ tiea, wa yia 'Simɔɔɔ -budu -yɔlayɩbha. Nɩɩ, -slɛɛn wa mɩ ɔ -buduu klolo ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wa laa, 'ɩn wa yia layɩbha: «'Lee -budu nɩ ŋwɛɛ Simɔ Piɛlɩ mɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piɛlɩ mɩ -slɔ -we ɔ 'yɩa ɔ 'yli 'wʋ, we 'ji -gʋ 'wlukʋʋn lapʋpalɩda, -bha -Lagɔɔ Zuzu gbaa ɔ -ylaɛ: «-Ɩn -talɩ, nyɩma ta mɩ -na da -talɩda. ");
INSERT INTO kyf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","-Ɩn -sɔ 'wʋ, -ɩn 'sibhli la. 'Ɩn -ɩn 'na kpekeli -nɩ, -ɩn -yɔ wa 'sɔ mnɩ, -amɩ tiea wa.» ");
INSERT INTO kyf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piɛlɩ 'sibhlia la, 'ɩn ɔ nɛɛ waa nyɩma -ylaɛ: «Nyɩmɛ yabhloo da a mɩa -talɩda yɩ? -Amɩ -wa. -A 'nʋ -mɔ? Lɛɛ gbʋ 'wʋ a yi -nya?» ");
INSERT INTO kyf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wa nɛɛ ɔ -ylaɛ: «Kɔlʋnɛɩ -ɔ -wa Wlɔmʋʋ 'slʋjaa glʋ gbuu 'yugalɩnyɔ nɩ, mɔ tiea -aɩn. Nyɩmɛ tɩklɩɩ -wa, 'ɩn ɔ zʋa -Lagɔ 'nʋŋwɛ. Zuifʋʋ dʋdʋ -gʋ -nyɩma weee saa ɔ zʋzɔnʋʋ 'dɩ. 'Ylɩ yabhlo nya, -Lagɔɔ 'anzɩ yabhlo yia ɔ 'tʋlʋa yi. Nɩɩ, ɔ tie -mɩ nyɩma 'wʋ. Wa la -mɩ, -ɩn yi ɔ -gbɛ, 'ɩn wɛlɩnya -ɩn 'kaa gba, ɔ 'ka we yukwli pʋlʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tɔʋn, Piɛlɩ yia wa 'wʋbhu ɔ 'lakpanya nya, 'ɩn wa yia ɔ -gbɛ -gʋ. Zlɩ zlɩa, 'ɩn Piɛlɩ yia 'wʋsɔ. 'Ɩn ɔ -yɔ wa 'sɔ yia mnɩ. -Lagɔbhelia -tɔlʋa -wa mɩa -Zopee, -maa yia wa yoo kwa. ");
INSERT INTO kyf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","We zlɩɩ 'sɔnʋ zlɩa nɩ, 'ɩn wa yia Sezalee nyni. Kɔlʋnɛɩ ka ɔ -buduŋwɛɛ -nyɩma -yɔ ɔ jijli -talea la. Wa ka 'wlugbeli ɔ -budu zɔ, -zugba wa wʋ Piɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Da Piɛlɩ nynia Kɔlʋnɛɩɩ -buduŋwɛɛ, ɔ 'ka plaa yi, -bha Kɔlʋnɛɩ yia ɔ yoo -saa. 'Ɩn ɔ yia 'wʋkwli tenyii, ɔ 'ka Piɛlɩ fʋsa, -mɔɔ 'nʋŋwɛzʋzʋe nya. ");
INSERT INTO kyf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","'Ɩn Piɛlɩ yia ɔ 'wʋbhu. Ɔ nɛɛ ɔ -ylaɛ: «-Ɩn -sɔ 'wʋ, nɩɩ, nyɩmɛ -amɩ -mɩ 'ya.» ");
INSERT INTO kyf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","'Bhie, ɔ yia gbada -tʋ Kɔlʋnɛɩ nya. 'Ɩn ɔ yia -budu zɔ pla. Piɛlɩ yia nyɩmaa -zlo -yɔyɩ 'wlugbelida. ");
INSERT INTO kyf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ɔ nɛɛ wa -ylaɛ: «A -yi we 'ji nɩɩ, we se 'nɩ Zuifʋ -yla -mɩ, ɔ -yɔ -ɔ 'nɩa -Lagɔ -yi 'ka ladɩ. 'Ɩn ɔ 'nɩ we se -ka, ɔ 'ka -mɔɔ -budu zɔ pla. -Lagɔ ka 'mɩ we 'klʋslolu nɩɩ, ɩn 'na ylalɩ nyɩmɛ yabhlogbɔɔ pʋɩnkanyɔ -yɔ titinanyɔ 'bhisa -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","We 'dɛɛ 'gbʋ, da a laa 'mɩ, 'ɩn ɩn yia yi, 'ɩn ɩn 'nɩa -gla zʋ. -We ka 'gbʋ a yia 'mɩ la, ɩn 'yɩbha ɩn 'ka we 'nʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔlʋnɛɩ yia we 'bɩgʋpalɩ: «We 'ylɩ -mnʋa nɩ, wee lɛlɩ -bhlokpadɛ nya, 'ylʋgbagbʋ lɛlɩɩ tanʋ nya, ɩn mɩ -Lagɔ bhubhoeda na 'dɛɛ -gbɛ. -Bha -bhlokpadɛ nyɩmɛ yabhlo kaa lɩlɩbana 'wʋ tlalɩa 'mɩ 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","'Ɩn ɔ nɛɛ 'mɩ -ylaɛ: ‹Kɔlʋnɛɩ, -Lagɔ ka -na -Lagɔɔ bhubhoe wɛlɩ -yɔŋwnu. Ɔ 'nɩ zʋzɔnʋ -we -ɩn nʋa bobabhanya -yla lɛ 'wʋdlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","-Ɩn tie nyɩma -Zopee, Simɔ Piɛlɩɩ -gbɛ wa -yɔ ɔ 'ka yi. -Zelibhanyɔ wa laa 'Simɔɔ, -ɔ ka -budu mɩa gumunyuu -gɔgɔ -gʋ nɩ, ɔ -gbɛ Piɛlɩ mɩa.› ");
INSERT INTO kyf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","-Bha -bhlokpadɛ ɩn tiea nyɩma, wa mnɩ -mɩ 'bʋ, 'ɩn -ɩn yia yiyigbʋ -yɔŋwnu. -A 'dɛ weee mɩ -slɛɛn -seli -Lagɔ 'yu, -a 'ka -we Nyɩmaa -Kanyɔ zʋa -mɩ ŋwɛɛ yukwli pʋlʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tɔʋn, Piɛlɩ 'bhua wɛlɩ 'wʋ, 'ɩn ɔ nɛɛ: «-Slɛɛn, ɩn ka we 'jiyibheli gbʋzɔnʋ sa nɩɩ, -Lagɔ'ɔ gbɩzɩ nyɩma 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nɩɩ, wɛlɩɩ -gnʋ -bhlo -bhlo 'wʋ, nyɩmɛ -ɔ zʋa -Lagɔ 'nʋŋwɛ, 'ɩn ɔ nʋa gbʋ tɩklɩɩ lɛ, mɔ nanɩa -Lagɔ dʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","-Lagɔ ka ɔ wɛlɩ Izlaɛlɩnyɩma yoo 'pa. Nɩɩ, wɛlɩ -zɔnʋ -wa. 'Ɩn -Zezu Klisɩɩ 'gbʋ, -a 'ka 'wʋtʋtʋe -dlɔɔ 'yɩ -Lagɔɔ -gbɛ. Ɔɔ -Zezu -wa nyɩma weee -Kanyɔ. ");
INSERT INTO kyf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bhla -we nya 'Zan *-Batisɩ gbaa nyɩma -yla: ‹A yi, ɩn 'ka aɩn batizee›, we bhla wee wɛlɩ -mɩnɩ dɩa gwe Galilee. 'Ɩn, -mʋʋ 'bɩgʋ, -we nʋa lɛ Zudee -dʋdʋ -gʋ da weee, amɩaa 'dɛ -yi we 'ji. ");
INSERT INTO kyf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Sa -Lagɔ ŋwnaa Nazalɛtɩyu -Zezu Zuzu 'Pʋpaa 'tɩtɛ nya, a -yi we 'ji. Sa -Zezu 'plɩlɩa dʋdʋ weee -gʋ gbʋzɔnʋʋ lɛnʋe nya, 'ɩn sa ɔ jipea nyɩma weee -wa *'Kuzu mɩa 'klɩyɩe 'wʋpalɩda, a -yi 'ya -mʋʋ 'ji. -We ka gbʋ -wa, -Lagɔ -yɔ ɔ 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«-We weee ɔ nʋa lɛ Zuifʋʋ dʋdʋ -gʋ -yɔ -Zeluzalɛmʋ, -amɩa mɩ we dayɩnya nya. Wa ka 'ya ɔ 'bha ɔ *su -gʋ lakʋlʋe nya. ");
INSERT INTO kyf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","'Ɩn 'ylɩ 'sɔ we taa zlɩ, -Lagɔ yia ɔ 'wʋbhu tlɩtlɩnya lʋ. 'Ɩn ɔ yia we lɛnʋ, ɔ 'ka -amɩa ɔ tietienya 'klʋtlalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","We 'nɩ nyɩma weee 'yɩ ɔ, -amɩa -Lagɔ -saa -bha 'cɩn ɔ gbʋʋ dayɩnya nya, -amɩa -wa. Da -Lagɔ 'bhua ɔ 'wʋ tlɩtlɩnya lʋ, -amɩa -yɔ ɔ lia, 'ɩn -a -yɔ ɔ yia 'ma. ");
INSERT INTO kyf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","-Zezu nɛɛ -aɩn -yla, -a gba -Lagɔgbʋ nyɩma -yla, 'ɩn -a gba nɩɩ, 'mɔ -Lagɔ palɩa la, ɔ 'ka tlɩtlɩnya -yɔ 'yliyɔganyaa -yɔgbʋ 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","-Lagɔgbʋʋ -falɩpanya weee ka ɔ gbʋʋ dayɩgbʋ gba. Wa nɛɛ: ‹Nyɩmɛ -ɔ -ka -Zezu dlɩ -gʋ zʋ, 'ɩn -Lagɔ tɩa -mɔɔ -yɔgbʋ 'wʋ, -Zezuu 'ŋnɩɩ 'tɩtɛɛ 'gbʋ.› » ");
INSERT INTO kyf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bhla -we nya Piɛlɩ mɩa gbada, -wa mɩa ɔ wɛlɩ yukwli pʋlʋda, 'ɩn Zuzu 'Pʋpa yia wa -gʋ lasibhli. ");
INSERT INTO kyf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zuifʋʋ -Lagɔnyɩma -wa -yɔ Piɛlɩ 'sɔ nɔa, -maa 'yɩa we -yɔ nɩɩ, -Lagɔ ka -wa 'nɩa Zuifʋ Zuzu 'Pʋpa -gʋ lamneni, 'ɩn ŋwɛgaga yia wa sʋbha. ");
INSERT INTO kyf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","'Ɩn -Lagɔnyɩma yia waa nyɩma ŋwɛɛ wɛlɩ -putunya 'nʋ, -zugba wa mnɩnɩ -Lagɔɔ 'ŋnɩ 'kadʋ. ");
INSERT INTO kyf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","'Ɩn Piɛlɩ nɛɛ: «Nyɩma Zuzu 'Pʋpa 'sibhlia -gʋ la -aɩn 'bhisa, -a mneni -a 'ka gba wa 'na batizeli wa 'nyu nya -nɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","'Ɩn Piɛlɩ nɛɛ, wa batizee wa -Zezu Klisɩɩ 'ŋnɩ nya. 'Ɩn wa 'dɛ weee nɛɛ Piɛlɩ -yla, ɔ -yɔ wa 'sɔ -tʋ 'ylɩ sanɩmɛ nya. ");
INSERT INTO kyf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","-Zezuu tietienya -yɔ -Lagɔbhelia -wa mɩa Zudee -dʋdʋ -gʋ ka 'nʋ nɩɩ, nyɩma -wa 'nɩa Zuifʋ, wa ka -Lagɔgbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Da Piɛlɩ yia lʋ -Zeluzalɛmʋ, -Lagɔnyɩma -wa mɩa Zuifʋ nya, 'ɩn -maa yia ɔ tʋ dɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wa nɛɛ: «-Ɩn ka nyɩma 'nɩa knɩ 'wʋ mɩɩ -gbɛ pla , 'ɩn -ɩn -yɔ wa 'sɔ yia li!» ");
INSERT INTO kyf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","-Bha Piɛlɩ gbaa wa -yla, -we 'plɩa -bhlo -bhlo, we bhlili we gwedɩda, ɔ nɛɛ wa -yla: ");
INSERT INTO kyf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«'Ylɩ yabhlo nya, ɩn mɩ -Zopeegbe 'wʋ, da ɩn mɩa -Lagɔ bhubhoeda, 'ɩn -lu yabhlo -Lagɔ 'paa yoo yia na 'yli -gʋ yi. Wee 'yli 'wʋ, ɩn 'yɩa -lu yabhlo -yɔ, -zugba we sibhli la na gbɛgbɛɩn. Wee -lu 'wlʋ sa 'naa 'kadʋ. We mɩ lakpada we gwɩgwɩ -mnʋa 'yli, -zugba we bhʋ yalɩ, 'ɩn we yia 'mɩ kwesi nyni. ");
INSERT INTO kyf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ɩn ylaa we nʋkplɛ tenyii, 'ɩn ɩn yia nɩma kaa 'lali -mnʋa klaa, -fliinɩma klaa, lagbizeli -nɩma klaa, 'zianya klaa -yɔyɩ. ");
INSERT INTO kyf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tɔʋn, 'ɩn ɩn yia wɛlɩ yabhlo 'nʋ, we nɛɛ 'mɩ -yla: ‹Piɛlɩ, -ɩn -sɔ 'wʋ, -ɩn 'bha, 'ɩn -ɩn 'ka li!› ");
INSERT INTO kyf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«'Ɩn ɩn nɛɛ: ‹'Ao, na -Kanyɔ, -ɩnnya! Ɩn -ka bhaa 'wlʋ, pʋɩnkalu -yɔ -na -gba 'nɩ -slɔ na ŋwɛɛ pla.› ");
INSERT INTO kyf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«'Ɩn we 'sɔnʋ nya, wee wɛlɩ yia yalɩ 'bhʋ, 'ɩn we nɛɛ 'mɩ -yla: ‹-We -Lagɔ tɩa 'wʋ 'wlalaa nɩ, -mɩ 'na 'yɩlɩ we pʋɩnkalu 'bhisa -nɩ.› ");
INSERT INTO kyf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","We nʋ 'sa -zakpa ta. 'Bhie, we 'dɛ weee yia yalɩ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«We bhla tɔʋn, nyɩma ta -wa 'bhʋa Sezalee, -wa wa tiea 'mɩ 'wʋ, -budu -we ŋwɛɛ ɩn mɩa, 'ɩn wa yia -bha nyni. ");
INSERT INTO kyf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","-Lagɔɔ Zuzu nɛɛ 'mɩ -ylaɛ: ‹-Ɩn 'na gbɩzɩlɩ nyɩma 'wʋ -nɩ, -ɩn -yɔ wa 'sɔ mnɩ.› -Amɩaa -Lagɔbhelia gbelibhlo -wa -yɔ 'mɩ 'sɔ yia da -seli nɩ, ma kwaa 'mɩ yoo Sezalee. 'Ɩn -a 'dɛ weee yia Kɔlʋnɛɩɩ -budu zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","-We ylɩa Kɔlʋnɛɩ nɩ, ɔ yia we gba -aɩn -yla. Sa ɔ 'yɩa ɔ -budu zɔ -Lagɔɔ 'anzɩ 'yligbeda, 'ɩn -mʋʋ yia ɔ -yla gba: ‹-Ɩn tie nyɩma -Zopee, nyɩmɛ wa laa Simɔ Piɛlɩ, wa -yɔ ɔ 'sɔ 'ka yi. ");
INSERT INTO kyf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Sa -ɩn 'kaa nʋ, 'ɩn -ɩn -yɔ -na -buduŋwɛɛ -nyɩma 'kaa gbʋ 'wʋbhʋ, ɔ 'ka -mɩ -yla we gba.› ");
INSERT INTO kyf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Da ɩn bhlia wa -yla gbʋ -gbagbɩe, 'ɩn Zuzu 'Pʋpa yia wa -gʋ lasibhli. Sa we 'sibhlia -amɩa -gʋ la we gwedɩlɩda, 'sa. ");
INSERT INTO kyf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tɔʋn, Nyɩmaa -Kanyɔɔ wɛlɩ ɔ gbaa zlɩmɛ, 'ɩn we yia 'mɩ dlɩɩ lasibhli: ‹*Zaan ka batizee 'nyu nya, nɩɩ, -Lagɔ 'ka aɩn batizee Zuzu 'Pʋpa nya.› ");
INSERT INTO kyf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Zlɩ -a ŋwnua Nyɩmaa -Kanyɔ -Zezu Klisɩɩ gbʋ -yɔ, 'ɩn -Lagɔ yia ɔ Zuzu 'Pʋpa -aɩn 'nyɛ. 'Sa -Lagɔ 'nyɛ 'yaa wamɩa ɔ Zuzu 'Pʋpa. Nyɔɔ -amɩ mɩa, 'ɩn ɩn 'ka gba -we -Lagɔ 'kaa lɛnʋ, ɔ 'na nʋnʋ we lɛ -nɩa?» ");
INSERT INTO kyf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","-Lagɔnyɩma 'nʋa wɛlɩnya -mɩnɩ, 'ɩn we yia wa dlɩ zɔbɛlɩ -dlɔɔ. Wa -mnɩnɩa -Lagɔɔ 'ŋnɩ, 'ɩn wa nɛɛ: «Gbʋzɔnʋ -wa, nyɩma -wa 'nɩa Zuifʋ, -Lagɔ ka se wa 'nyɛ, wa 'ka wa dlɩ 'bhiti, 'ɩn wa 'ka 'yliyɔgagɩe -zɔnʋ 'yɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Etiɛnɩɩ tlɩtlɩe 'bɩgʋ, 'ɩn wa yia -Lagɔnyɩma 'klɩyɩe 'wʋpalɩe bhli. 'Ɩn -maa yia lamneni da weee. Tɔlʋa mnɩ Fenisi, Siplʋ -yɔ Antiɔsʋ. 'Ɩn wa -ka -Lagɔgbʋ gbaa mnɩ, Zuifʋʋ 'dɛkpʋa -yla wa gbaa we. ");
INSERT INTO kyf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","-Mʋʋ bhla, Siplʋ -yɔ Silɛnɩɩ -Lagɔnyɩma tɔlʋa ka Antiɔsʋ yi, -zugba wa gba Nyɩmaa -Kanyɔ -Zezuu gbʋzɔnʋ gbʋ, nyɩma -wa 'nɩa Zuifʋ -yla. ");
INSERT INTO kyf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","-Lagɔɔ 'tɩtɛ -yɔ wa 'sɔ mɩɩ 'gbʋ, nyɩma duun yia wa wɛlɩ -gʋ laŋwnunu. 'Ɩn wa yia wa 'dɛ -Lagɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","-Zeluzalɛmʋʋ *leglizɩ 'nʋa gbʋnya -mɩnɩ, tɔʋn, wa yia Banabasɩ tie Antiɔsʋ. ");
INSERT INTO kyf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Da ɔ nynia -mɔ, sa -Lagɔ nʋa -Lagɔnyɩma 'nanɩ 'wʋ, ɔ 'yɩa we -yɔ, ɔ yia we 'mʋna li. 'Ɩn ɔ yia wa 'dɛ weee 'kʋayli 'pa, nɩɩ, wa -tʋ -Lagɔ 'wʋ dlɩ weee nya tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasɩ mɩ nyɩmɛ -zɔnʋ nya, Zuzu 'Pʋpa ka ɔ ye, 'ɩn ɔ kaa dlɩ. 'Ɩn we 'gbʋ nyɩmaa -zlo yi 'yaa -maa 'dɛ -Lagɔ yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","-Mʋʋ 'bɩgʋ, Banabasɩ yia Sɔlʋʋ datalɩa mnɩ Talɩsɩ. ");
INSERT INTO kyf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Da ɔ 'yɩa ɔ, 'ɩn ɔ -yɔ ɔ 'sɔ yia Antiɔsʋ yi. Wa 'dɛ 'sɔ li -bha -zʋ -bhlo waa -Lagɔnyɩmaa -gbɛ, -zugba wa slolu nyɩmaa -zlo dlɩ -zʋ gbʋ. Nɩɩ, Antiɔsʋgbe 'wʋ wa laa -Zezuu 'bɩnɔnya Kletiɛn tɩatɩa. ");
INSERT INTO kyf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","We bhla, -Lagɔgbʋʋ -falɩpanya tɔlʋa 'bhʋa -Zeluzalɛmʋ, 'ɩn wa yia Antiɔsʋ yi. ");
INSERT INTO kyf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wa 'yabhlo wa laa Agabusɩ -sɔa 'wʋ -Lagɔɔ Zuzu nya, ɔ nɛɛ, ŋwɔ 'kadʋ yia daylɩ yia dʋdʋ weee -gʋ. 'Ɩn wee ŋwɔ yia yi bhla -we nya Klodʋ mɩa nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","'Ɩn, -Zezuu 'bɩnɔnya yia gbʋ pʋpalɩ nɩɩ, -ɔ -ka -mɩ -we ɔ -ka 'yɩ, ɔ wla we, wa 'ka we yoo 'pa, -Lagɔnyɩma mɩa Zudeee dʋdʋ -gʋ wa 'wʋsalu nya. ");
INSERT INTO kyf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","'Sa waa -Zezuu 'bɩnɔnya nʋa we. -We wa 'yɩa, 'ɩn wa yia we Banabasɩ -yɔ Sɔlʋ yoo 'nyɛ, 'ɩn -maa yia we leglizɩɩ nyɩma kpasɩ kwa Zudee. ");
INSERT INTO kyf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","We bhla, nyɩmaa 'wlulapɩlɩnyɔ Ewlodʋ bhlia leglizɩɩ nyɩma tɔlʋa 'klɩyɩe 'wʋpalɩe. ");
INSERT INTO kyf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","'Ɩn ɔ yia Zaaan bheli *'Zake 'bha tʋgʋgblɛ nya. ");
INSERT INTO kyf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","'Ɩn da ɔ 'yɩa we -yɔ nɩɩ, we nanɩ Zuifʋ dʋdʋ, 'ɩn ɔ yi 'yaa Piɛlɩ kpa, *'Floo -we 'nɩa gɔɔ -yɔ -kaa 'fɛtɩɩ bhla. ");
INSERT INTO kyf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ewlodʋ kpaa Piɛlɩ, 'ɩn ɔ yia ɔ -kaslʋ 'wʋpa. 'Ɩn ɔ nɛɛ 'slʋja -mnʋaa -zakpa -mnʋa -yla, -maa -kʋ ɔ ŋwɛ. Ɔ 'yɩbha ɔ 'ka ɔ -yɔgbʋ 'wʋbhu nyɩma 'yu, *'Wʋzɩtɩylɩɩ 'fɛtɩɩ bhɩa zlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","'Slʋja mɩ Piɛlɩ ŋwɛkʋda -kaslʋbudu zɔ, 'ɩn leglizɩ yia -Lagɔ bhubhoeda -tʋ tɩklɩɩ ɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ylɩ -we nya Ewlodʋ 'kaa Piɛlɩɩ -yɔgbʋ 'wʋbhu, we sabɔ, -zugba Piɛlɩ mɩ 'ylaa 'wʋ 'slʋja 'sɔ nyɩdɩ. Ɔ mɩ nɛtɛllukpe 'sɔ 'wʋ gbʋanda, -zugba -kaslʋbuduu ŋwɛkʋnya 'yligbe -kaslʋbudu ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","-Bha -bhlokpadɛ Jejitapɛɛ 'anzɩ 'tlalɩa -bha -kaslʋbudu zɔ, 'ɩn zlɩ yia -mɔ slo. Ɔ zɩa Piɛlɩɩ bɛta yabhlo kwɛ, ɔ ganɔa ɔ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn -sɔ 'wʋ slʋɩ!» Tɔʋn, nɛtɛllukpenya yia Piɛlɩɩ sɔ 'wʋbhʋ, 'ɩn we yia laslo. ");
INSERT INTO kyf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","'Ɩn -Lagɔɔ 'anzɩ nɛɛ ɔ -ylaɛ: «-Ɩn jɩ -na -jlaa, -ɩn -pla -na -sakwla 'bhʋ 'wʋ, -ɩn -gba we 'llukpe!» Piɛlɩ yia we 'nʋŋwɛ zʋ. 'Ɩn -Lagɔɔ 'anzɩ yia we -gʋdɩ ɔ -ylaɛ: «-Ɩn -pla -na -bana 'wʋ, 'ɩn -ɩn yi 'mɩ 'bɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piɛlɩ mɩ -Lagɔɔ 'anzɩ 'bɩ, 'ɩn ɔ yia -kaslʋbudu zɔ 'tla. -We -Lagɔɔ 'anzɩ mɩa lɛnʋda, ɔmɔ dlɩɩ we 'nɩ gbʋzɔnʋ, 'ylaa -ylada ɔ mɩa. ");
INSERT INTO kyf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wa zia -kaslʋbuduu ŋwɛkʋnyaa tɩanʋ -yɔ 'sɔnʋ -gʋ, 'ɩn nɛtɛ -klolo -we -galɩa 'gbe, 'ɩn wa yia we -yɔ nyni. Wee klolo -kalɩa we 'dɛ nya wa 'yu, 'ɩn wa yia 'tla. Wa kwaa yoo yabhlo -sɛ, tɔʋn, 'ɩn -Lagɔɔ 'anzɩ yia Piɛlɩ kwesi 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tɔʋn, -we 'plɩa Piɛlɩ yibhelia we 'ji, 'ɩn ɔ nɛɛ ɔ dlɩ zɔɛ: «-Slɛɛn na yɩ we -yɔ nɩɩ, gbʋzɔnʋ -wa: Jejitapɛ ka ɔ 'anzɩ tie, 'ɩn ɔ yia 'mɩ Ewlodʋʋ 'tɩtɛ kwɛɛ -sa. Gbʋnyuu Zuifʋ pʋpalɩa na 'gbʋ, 'ɩn ɔ yi 'yaa 'mɩ -mʋʋ zɔ -sa.» ");
INSERT INTO kyf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Da Piɛlɩ 'nʋa wee gbʋ 'wʋla, 'ɩn ɔ yia Zaan wa laa Malɩkɩɩ 'nyaa Maliii -buduŋwɛɛ mnɩ. Da -Lagɔnyɩma duun gbelia 'wlu, -zugba wa bhubhoe -Lagɔ ɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piɛlɩ bhlɩa -buduu klolo, lubhonʋŋwnɔ wa laa Wlodʋ, 'ɩn -mɔɔ yia -bha -talɩa yi. ");
INSERT INTO kyf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ɔ yibhelia Piɛlɩɩ wɛlɩ, ɔ mɩ 'mʋna lidaa 'gbʋ, ɔ 'nɩ -budu -kalɩ. 'Ɩn ɔ -yɔ gwagwɩe yia gbaa mnɩ nyɩma tɔlʋa -ylaɛ: «Piɛlɩ mɩ -buduŋwɛɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wa nɛɛ ɔ -ylaɛ: «-Sabhɛ bhaa aɩn yɩ?» 'Ɩn ɔ nɛɛ wa -yla: «Gbʋzɔnʋ -wa!» Tɔʋn, 'ɩn wa nɛɛ: «-Zugba ɔ zuzu -wa!» ");
INSERT INTO kyf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","-Mʋʋ bhla, -zugba Piɛlɩ bhlɩa klolo -bhloo 'dɛ. Da wa -kalɩa -bha, wa 'yɩa ɔ -yɔ, 'ɩn ŋwɛgaga yia wa sʋbha. ");
INSERT INTO kyf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","'Ɩn Piɛlɩ yia wa -yla sɔ 'pa, a 'mu ŋwɛ. 'Ɩn sa Jejitapɛ wlelia ɔ -kaslʋbudu zɔ, 'ɩn ɔ yia we 'bɩgʋ gba wa -yla. 'Ɩn ɔ nɛɛ 'ya wa -ylaɛ: «A gba we 'Zake -yɔ -Lagɔbhelia tɔlʋa -yla.» 'Bhie, ɔ 'tlaa, 'ɩn ɔ yia da -putu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Da zlɩ zlɩa, 'ɩn 'slʋja yia gbugblolu, -zugba wa yɩbhalɩa yɩbhalɩa laɛ, lɛɛ -lu ylɩ Piɛlɩa. ");
INSERT INTO kyf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ewlodʋ nɛɛ wa -talɩ ɔ da. Wa -talɩa ɔ da, wa 'nɩ ɔ 'yɩ. 'Ɩn Ewlodʋ yia waa -buduu ŋwɛkʋ -slʋja layɩbha, 'ɩn ɔ nɛɛ wa 'bha wa. -Mʋʋ 'bɩgʋ, ɔ 'bhʋa Zudee, 'ɩn ɔ yia Sezalee ladɩa mnɩ bhla -sɛlɛɛ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tilɩ -yɔ Sidɔɔn -nyɩmaa lililu mɩa, Ewlodʋʋ dʋdʋ -gʋ we bhʋa. -Mʋʋ bhla, Ewlodʋ ka wa -yɔ 'cɛ 'palɩ. Wa bhlɩa wɛlɩ -bhlo, 'ɩn wa yia ɔ komii ŋwɛkʋnyɔ Blasɩtusɩ ɔ 'wʋkulu. 'Ɩn wa nɛɛ Ewlodʋ -ylaɛ: «'Wʋtʋtʋe -dlɔɔ -tʋ -aɩn nyɩdɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","'Ɩn Ewlodʋ yia wa -yla 'ylɩ zʋ. Wee 'ylɩ nynia, ɔ yia ɔ 'ŋnɩmnɩ -bana 'wʋpla, 'ɩn ɔ yia ɔ gbʋwʋbhukpe 'wʋ ladɩ. 'Bhie, ɔ yia wa -yla gbʋ lapalɩ -zejila 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","'Ɩn nyɩma yia 'wʋkpɩ: «-Lagɔ yabhlo mɩa dɛ gbada, -mɔɔ 'nɩ nyɩmɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wee bhla -bhloo 'dɛ nya, Jejitapɛɛ 'anzɩ yia Ewlodʋ bhɩtɩ, ɔ 'nɩ -Lagɔɔ 'ŋnɩ -mnɩnɩɩ 'gbʋ. 'Ɩn -mna yia ɔ li, 'ɩn ɔ yia tlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","We bhla, -zugba -Lagɔwɛlɩ -yɔ -gʋwʋlaylimanɩe mnɩ, 'ɩn nyɩma nyɛ wa 'dɛ -Lagɔ yoo. ");
INSERT INTO kyf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Da Banabasɩ -yɔ Sɔlʋ bhɩa wa lubho, 'ɩn wa yia -Zeluzalɛmʋ lʋbhiti. Wa yia 'Zan Malɩkɩ 'wʋbhu, 'ɩn wa -yɔ ɔ 'sɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiɔsʋʋ leglizɩ 'wʋ, -Lagɔgbʋʋ -falɩpanya -yɔ nyɩmaa gbʋslolunya mɩa -bha. Wa ŋnɩ nɩ: Banabasɩ, 'Simeɔɔ wa laa nyɩmɛ -ylukpa, Silɛnɩyu Lusiusʋ, nyɩmaa 'wlulapɩlɩnyɔ Ewlodʋ Antipasɩɩ jijli -tale Manaɛɛ -yɔ Sɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","'Ylɩ yabhloo zlɩ, da wa mɩa -Lagɔ bhubhoeda, -zugba wa pla 'sun, Zuzu 'Pʋpa nɛɛ wa -ylaɛ: «A -sa -bha Banabasɩ -yɔ Sɔlʋ wa 'dɛ saa, lubho -we ka 'gbʋ ɩn yia wa la, wa 'ka we nʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wa yia 'sun -plada -yɔ -Lagɔ -bhubhoeda -tʋ. -Mʋʋ 'bɩgʋ, 'ɩn wa yia Banabasɩ -yɔ Sɔlʋ sɔ 'wluo lapalɩ, 'bhie, wa yia wa 'yitide, 'ɩn wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Zuzu 'Pʋpa tiea Banabasɩ -yɔ Sɔlʋ, 'ɩn wa yia Selusii mnɩ, -bha wa 'bhua 'glʋ 'wʋ. 'Ɩn 'nyunyɩdɩdʋdʋ wa laa Siplʋ, wa yia -mɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Da wa nynia Salaminɩ, 'ɩn wa yia -Lagɔgbʋʋ gbagbɩe bhli Zuifʋʋ -Lagɔbudunya zɔ. 'Zan Malɩkɩ -yɔ wa 'sɔ mɩ, -zugba ɔ sa wa 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wa -dɩa 'nyunyɩdɩdʋdʋ 'wʋ, 'ɩn wa yia Pafɔsʋgbe nʋkplɛ nyni. -Mɔ wa -yɔ -dlabhia -lɛnʋnyɔ yabhlo wa laa Baalɩ -Zezu gbelia. Zuifʋ, -ɔ laa ɔ 'dɛ -Lagɔgbʋʋ -falɩpanyɔ, mɔ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'Nyunyɩdɩdʋdʋʋ 'wlulapɩlɩnyɔ Sɛlɩjiusʋ Pɔlusʋʋ -gbɛ ɔ -dɩlɩa la, 'ylimnanyɔ mɔ. Ɔɔ dʋdʋʋ 'wlulapɩlɩnyɔ laa Banabasɩ -yɔ Sɔlʋ, ɔ 'yɩbha ɔ 'ka -Lagɔwɛlɩ 'nʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nɩɩ, -dlabhia -lɛnʋnyɔ wa laa glɛkɩwɛlɩ 'wʋ Elimasɩ, -mɔɔ 'nɩ 'yɩbha, 'nyunyɩdɩdʋdʋʋ 'wlulapɩlɩnyɔ ŋwnu -Lagɔgbʋ -yɔ, we 'gbʋ ɔ yia Banabasɩ -yɔ Sɔlʋ tʋ dɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Zuzu 'Pʋpa yea Sɔlʋ wa la 'yaa *Pɔlʋ, ɔ ylaa ɔɔ Elimasɩ 'yliya 'wʋ tenyii, 'ɩn ɔ nɛɛ ɔ -ylaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«-Dawli bhabha -yɔ 'nyii -kanyɔ, 'Kuzuu 'yu, -ɔ -wa gbʋzɔnʋ weee tʋnyɩmɛ! -Ɩn 'nɩa -Lagɔɔ lɛnʋgbʋʋ da 'wʋlasalɩe 'yligbelia yii? ");
INSERT INTO kyf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","-Slɛɛn -ɩn pʋ yukwli: Jejitapɛ yia -mɩ bhɩtɩa, -ɩn 'ka 'lɔ. 'Ɩn -ɩn 'na 'ka 'ylʋ -yɔyɩ bhla yabhlo nya.» -Bha -bhlokpadɛ, Elimasɩ 'lɔa, 'ɩn ɔ yia nikpise 'wʋ -tʋ, -zugba ɔ bhubhuli sɔ la, nyɩmɛ -ɔ 'kaa ɔ sɔ lakpaa datalɩe nya. ");
INSERT INTO kyf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Da 'nyunyɩdɩdʋdʋʋ 'wlulapɩlɩnyɔ 'yɩa -we 'plɩa -yɔ, 'ɩn ɔ yia -Lagɔ -plagbʋ -yɔŋwnu. 'Ɩn -Lagɔgbʋ wa mɩa -sloluda, we yia ɔ dlɩ kwɛzɩ bhabha. ");
INSERT INTO kyf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafɔsʋgbe 'wʋ, Pɔlʋ -yɔ ɔ nɔnɔnya -bhoa 'glʋ 'wʋ, 'ɩn wa yia Pɛlɩzɩgbe nʋkplɛ mnɩ, Panfilii -dʋdʋ -gʋ. -Bha 'Zan Malɩkɩ 'bhʋa wa 'bɩ, 'ɩn ɔ yia -Zeluzalɛmʋ lʋmnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","-Mʋʋ 'bɩgʋ, wa 'bhʋa Pɛlɩzɩ, 'ɩn wa yia Antiɔsʋ mnɩ Pisidii -dʋdʋ -gʋ, bhʋ -gʋ. Zuifʋʋ *Nyapɛylɩ nya, 'ɩn wa yia -Lagɔbudu zɔ pla, 'ɩn wa yia ladɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Da wa bhɩa tite -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ zɛlɩzɛlɩe, 'bhie, -Lagɔbuduu -cɩan nɛɛ Pɔlʋ -yɔ Banabasɩ -yla: «Bheliaɩn, we -ka gbʋ a 'ka gba, 'ɩn a 'ka nyɩmaa dlɩ latɛmanɩ, a mneni a 'ka we gba!» ");
INSERT INTO kyf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔlʋ -sɔa 'wʋ, ɔ 'paa sɔ, 'ɩn ɔ nɛɛ: «Izlaɛlɩɩ nyɩma, amɩa bʋbɔa -Lagɔ, a pʋlʋ 'mɩ yukwli! ");
INSERT INTO kyf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izlaɛlɩnyɩmaa -Lagɔ -sa -bha -amɩaa dʋkpasɩ, 'ɩn ɔ yia wa zumanɩ da laga 'wʋ Ezipʋtʋ -dʋdʋ -gʋ. 'Bhie, ɔ yia wa Ezipʋtʋ -sa ɔ 'tɩtɛ nya. ");
INSERT INTO kyf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","'Ɩn ɔ yia wa zʋ dʋdʋ bɛblɛɛ -gʋ, we mneni we 'ka -zʋʋ glʋ 'sɔ ŋwɛɛ nyni. ");
INSERT INTO kyf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","'Ɩn ɔ yia zʋa gbesɔ lasa Kanaa -dʋdʋ -gʋ. 'Ɩn ɔ yia -maa dʋdʋ ɔ nyɩma 'wʋladlili, 'ɩn we yia -maanʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","-Mʋʋ li -zʋʋ 'wlu sɔ -zʋʋ glʋ 'sɔ 'ya kugbua (450). «'Bhie, ɔ yia -amɩaa dʋkpasɩ gbʋwʋbhunya 'nyɛda -tʋ tɩklɩɩ, 'ɩn we yia -Lagɔgbʋʋ -falɩpanyɔ Samuɛlɩɩ bhla ylɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«-Mʋʋ 'bɩgʋ, -amɩaa dʋkpasɩ yia -Lagɔ wa 'wlulapɩlɩnyɔ -zlalɩ. 'Ɩn -Lagɔ yia wa Kisɩɩ 'yu Saulʋ 'nyɛ, Bɛzamɛɛɛ zʋaylinyɩmɛ nya. -Mɔɔ pɩlɩ wa 'wlu la -zʋʋ glʋ 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","-Mʋʋ 'bɩgʋ, -Lagɔ -saa Sɔlʋ kwnɛɛ, 'ɩn ɔ yia -Davidɩ ɔ 'bɩgʋpalɩ. 'Ɩn -Lagɔ nɛɛ -Davidɩɩ daaɛ: ‹Ɩn ka -Zeseee 'yu -Davidɩ 'yɩ na dlɩɩ da -nyɩmɛ nya. -We weee ɩn 'yɩbhaa, lɛ ɔ yia we nʋa.› ");
INSERT INTO kyf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«-Davidɩɩ zʋaylinyɩmɛ yabhlo -wa -Zezu, 'mɔ -Lagɔ -saa -bha *Izlaɛlɩɩ Gbʋwʋsanyɔ nya. Sa ɔ gbaa zlɩmɛ we 'sa. ");
INSERT INTO kyf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","-Zezuu yiyie 'yu, Zaan yia Izlaɛlɩnyɩma weee la. Ɔ nɛɛ wa -yla: ‹A 'bhiti amɩaa dlɩ, 'ɩn wa 'ka aɩn batizee.› ");
INSERT INTO kyf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Da Zaan mɩa ɔ lubhoo 'wlu 'bhada, 'ɩn ɔ nɛɛ: ‹Amɩa dlɩɩ, nyɔɔ ɩn -mɩa? -Lagɔɔ -Bhasanyɔ, -ɔ a mɩa wʋda we 'nɩ -amɩ. A -talɩ, yia ɔ yia 'mɩ lʋʋ, 'ɩn, ɩn 'nɩ we 'klʋ -ka ɩn 'ka ɔ -sakwlaa 'llukpe -blo.› ");
INSERT INTO kyf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Na bhelia, amɩa Ablaamʋʋ zʋaylinyɩma, 'ɩn amɩa mɩa -seli -Lagɔ bʋbʋee 'gbʋ, -a 'dɛ weee -yla -Lagɔ 'paa nyɩmaa gbʋwʋsawɛlɩ -mɩnɩ yoo. ");
INSERT INTO kyf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nɩɩ, -Zeluzalɛmʋ -nyɩma -yɔ wa 'yugalɩnya 'nɩ -Zezu yibheli *nyɩmaa Gbʋwʋsanyɔ nya. 'Ɩn -Lagɔgbʋʋ -falɩpanyaa wɛlɩ -we wa zɛlɩa Zuifʋʋ Nyapɛylɩ weee nya, wa 'nɩ -mʋʋ 'wʋlanʋ. 'Ɩn wa yia we lɛnʋe gbalɩ -Zezuu 'bhabhɩe nya. ");
INSERT INTO kyf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","'Ɩn wɛlɩ -we -gʋ wa 'kaa ɔ 'bha wa 'nɩ we 'yɩ. 'Ɩn wa nɛɛ Pilatɩ -yla, -mɔɔ 'bha ɔ. ");
INSERT INTO kyf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","-We -Lagɔsɛbhɛ gbaa -Zezuu daa, wa bhɩa we lɛnʋe, wa -saa ɔ *su -gʋ, 'ɩn wa yia ɔ gbawla 'wʋ ladɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Ɩn -Lagɔ yia ɔ 'wʋbhu tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'Ɩn nyɩma -wa -yɔ -Zezu 'sɔ 'bhʋa Galilee -dʋdʋ -gʋ, 'ɩn wa yia -Zeluzalɛmʋ mnɩ, ɔ ka ɔ 'dɛ -maa 'klʋslolu 'ylɩ duun nya. -Maa mɩa -slɛɛn ɔ gbʋdayɩnya, -zugba wa -yɔ ɔ gbʋ -gbagbɩe mnɩ Izlaɛlɩnyɩma -yla. ");
INSERT INTO kyf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«'Ɩn gbʋzɔnʋ -we -Lagɔ gbaa zlɩmɛ -amɩaa dʋkpasɩ -yla, 'mʋ -a yia aɩn -yla gbaa. ");
INSERT INTO kyf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","-Amɩa, wa 'yuoyua -yla -Lagɔ nʋa -slɛɛn we lɛ, -Zezuu 'wʋbhubhue nya tlɩtlɩnya glaa. We mɩ cɛlɩda Lʋʋsɛbhɛɛ lʋʋʋ 'sɔnʋ 'wʋɛ: ‹-Mɩ -wa na yu, 'ɩn we 'bhʋ -zɛɛn 'wʋ, -amɩ -wa -na dide.› ");
INSERT INTO kyf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","-Lagɔ ka zlɩmɛ we gba. Nɩɩ, -Zezu ɔ yia 'wʋbhua tlɩtlɩnya glaa, 'ɩn ɔ 'na 'ka 'maslɛɛn tlɩ. 'Ɩn ɔ nɛɛ wee gbʋ -mɩnɩ daɛ: ‹-Mɔwlʋlu -zɔnʋnya ɩn gbaa ɩn 'ka -Davidɩ 'nyɛ, 'mʋ na yia aɩn 'nyɛa.› ");
INSERT INTO kyf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","We 'gbʋ, we mɩ 'ya cɛlɩda Lʋʋsɛbhɛɛ da yabhloɛ: ‹-Ɩn 'na 'ka -na -mɔwlʋnyɔ 'yitide ɔ 'ka 'bhʋka 'wʋ zɛnɩ.› ");
INSERT INTO kyf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Da nyɩmaa 'wlulapɩlɩnyɔ -Davidɩ -gaa 'yliyɔ, sa -Lagɔ 'yɩbhaa, 'ɩn ɔ yi 'saa ɔ lubho nʋ. Ɔ tlɩa, wa 'bhlua ɔ, ɔ dʋkpasɩ kwesi, 'ɩn ɔ yia zɛn. ");
INSERT INTO kyf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","«-Zezu 'nɩ glu zɛnɩ, -Lagɔ ka ɔ 'wʋbhu tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Amɩa, bhelia, -a nɛɛ aɩn -ylaɛ: -Zezuu 'gbʋ -Lagɔ tɩa nyɩmaa -yɔgbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nɩɩ, nyɔɔo nyɔɔ -ka -Zezuu gbʋ -yɔŋwnu, ɔ 'gbʋ -na gbʋnyuuu 'gba bhʋa -mɩ 'wlu. Moizɩɩ tite 'nɩ mneni we 'ka we aɩn 'wlu -sa. ");
INSERT INTO kyf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","A zʋ amɩaa 'dɛ 'yliyɔ, gbʋ -we -Lagɔgbʋʋ -falɩpanya gbaa, we yi aɩn ylɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","-Lagɔ nɛɛ: ‹A -talɩ gbʋʋ 'ylilatlilinya, ŋwɛgaga sʋbha aɩn, 'ɩn a 'bhʋ la. Nɩɩ, gwɛdigbʋ na yia lɛnʋa amɩaa bhla. Wa -ka we 'dɩ aɩn -salɩ, a 'na 'ka we la gbʋzɔnʋ.› » ");
INSERT INTO kyf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Da Pɔlʋ -yɔ Banabasɩ mɩa -Lagɔbudu zɔ 'tlada, 'ɩn wa nɛɛ wa -ylaɛ: «Amɩa -a bhubhoe, Zuifʋʋ Nyapɛylɩ -putu -ka nyni, a yi a 'ka wee gbʋ -bhloo 'dɛ gba -aɩn -yla!» ");
INSERT INTO kyf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wa bhɩa 'wlugbelie, Zuifʋʋ -zlo -yɔ nyɩma -putu -wa bʋbɔa Zuifʋʋ -Lagɔ, 'ɩn wa yia Pɔlʋ -yɔ Banabasɩ yoo kwa. Pɔlʋ -yɔ Banabasɩ mɩ wa -yla gbʋ -gbada, -zugba wa tɛmanɩ wa dlɩ la nɩɩ, wa 'na 'tideli -Lagɔɔ 'nanɩ 'yi -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zuifʋʋ Nyapɛylɩ -putu nynia, -wa yia -Lagɔwɛlɩ yukwli pʋlʋa, we -tʋ 'wʋ -sɛ, wa 'ka wee 'gbee nʋkpla -nyɩma ŋwɛɛ nyni. ");
INSERT INTO kyf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zuifʋ 'yɩa nyɩmaa -zlo -manɩ -yɔ, 'ɩn zenyidlɩ yia wa 'wʋbho. 'Ɩn -we Pɔlʋ mɩa gbada, wa bhitia we saputu sa, -zugba wa vɛlɩ ɔ. ");
INSERT INTO kyf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔlʋ -yɔ Banabasɩ nɛɛ wa -yla dlɩ 'tɩtɛ nyaɛ: «We mɩ nɩɩ, amɩa Zuifʋ -yla wa 'ka yaa -Lagɔgbʋ gba tɩa. 'Ɩn a mɩ we kwnɛɛ -sada, 'ɩn a nɛɛ amɩaa 'dɛ nya nɩɩ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, a 'nɩ we 'yɩyɩe 'klʋ -kaa 'gbʋ, nyɩma -wa 'nɩa Zuifʋ, wa gbɛgbɛɩn -a yia mnɩa! ");
INSERT INTO kyf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","«-We Jejitapɛ gbaa -aɩn -yla, mʋ nɩ: ‹Ɩn ka -mɩ 'yligbeli, dʋdʋgʋ -nyɩma weee zlɩ nya. 'Ɩn, -ɩn 'ka nyɩma gbʋwʋsa wɛlɩ gba dʋdʋʋ da weee.› » ");
INSERT INTO kyf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Da nyɩma -wa 'nɩa Zuifʋ 'nʋa wɛlɩnya -mɩnɩ, 'ɩn wa yia 'mʋna li, wa yia -Lagɔɔ 'ŋnɩ -mnɩnɩ ɔ wɛlɩ -zɔnʋʋ 'gbʋ. 'Ɩn -wa -Lagɔ -saa -bha 'cɩn, wa 'ka 'yliyɔgagɩe -we 'nɩa bhloluda -ka 'yɩ, 'maa yia -Lagɔ dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","'Ɩn Nyɩmaa -Kanyɔɔ wɛlɩ yia wee dʋdʋ weee -gʋ lamneni. ");
INSERT INTO kyf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Zuifʋ 'paa 'ŋnɩmnɩ -ŋwnɩ -wa zʋa -Lagɔ -bha -yɔ 'gbee nyɩma 'kadɩɩ dlɩ yalɩ nɩɩ, wa palɩ Pɔlʋ -yɔ Banabasɩ 'klɩyɩe 'wʋ. 'Ɩn wa yia -maa vu wa dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Da Pɔlʋ -yɔ Banabasɩ 'kaa wee 'gbe nʋkplɛ 'bhʋ, 'ɩn -maa yia -maa bhʋ -yɔ *-bhubhui gbɔtɔ wa 'gbʋ. 'Bhie, wa yia Ikoniumʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","'Ɩn 'mʋna -yɔ Zuzu 'Pʋpa yia -Zezuu 'bɩnɔnya ye -mɔ Antiɔsʋ -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Da Pɔlʋ -yɔ Banabasɩ nynia Ikoniumʋ, 'ɩn wa yi 'yaa -mɛmɛ Zuifʋʋ -Lagɔbudu zɔ pla. Wa gbaa -mɔ -Lagɔgbʋ sa kpɛɛn kpɛɛn, Zuifʋ duun -yɔ -wa 'nɩa Zuifʋ, -maa yia -Lagɔ pla. ");
INSERT INTO kyf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Zuifʋ -wa 'nɩa -Lagɔgbʋ -yɔŋwnu, -maa 'bhua nyɩma -tɔlʋa -wa 'nɩa Zuifʋʋ dlɩ 'wʋ, 'ɩn wa 'ka -Lagɔbhelia -yla gbʋnyuu lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Ɩn Pɔlʋ -yɔ Banabasɩ yia -mʋʋ bhla Ikoniumʋ -tʋ -daan, -zugba wa gba -Lagɔgbʋ, nyanɔ yabhlogbɔɔ 'nɩ wa 'wʋ -mɩ. 'Ɩn -Lagɔ yia wa se 'nyɛ, wa 'ka gwɛdigbʋnya -yɔ gbʋ 'kadɩ lɛnʋ. Wa gbaa ɔ 'nanɩɩ -gʋ gbʋ, 'ɩn -Lagɔ yia we -slolu nɩɩ, wa wɛlɩ mɩ gbʋzɔnʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","'Ɩn wee 'gbee nʋkpla -nyɩma yia 'wʋdɩ 'sɔ: tɔlʋa -zɛa Zuifʋʋ -nʋ, 'ɩn tɔlʋa yia -Zezuu tietienyaa -nʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zuifʋ -yɔ -wa 'nɩa Zuifʋ, we -yɔ wa 'yugalɩnya pʋpalɩa gbʋ, wa 'ka Pɔlʋ -yɔ Banabasɩ 'klɩyɩe 'wʋpa, 'ɩn wa 'ka wa gbɔkʋ 'wʋbha. ");
INSERT INTO kyf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Da waa nyɩma 'sɔ 'nʋa gbʋ -mɩnɩ, 'ɩn wa yia -flii -bho. 'Ɩn wa yia Likaoni -dʋdʋʋ 'gbenya wa laa Lisɩtlɩ -yɔ Dɛlɩbʋ mnɩ, we -yɔ we kwesi -gbenya 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","'Ɩn wa yi 'yaa -mɛmɛ -Lagɔgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nyɩmɛ yabhlo mɩ Lisɩtlɩ, ladɩda ɔ tʋa 'kɔmʋʋ, -we ka gbʋ -wa, ɔ bhʋ ka 'ku. 'Ɩn wee 'kukue wa gwalɩlɩa ɔ, ɔ tɩanʋ 'nɩ -slɔ nɔ. ");
INSERT INTO kyf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","'Ylɩ yabhlo nya, -zugba ɔ pʋlʋ Pɔlʋʋ wɛlɩ yukwli. 'Ɩn Pɔlʋ yia we -yɔyɩ nɩɩ, ɔ dlɩ mɩ -Zezu -gʋʋ 'gbʋ, ɔ mneni ɔ 'ka 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pɔlʋ nɛɛ ɔ -yla wɛlɩ 'tɩtɛ nyaɛ: «-Ɩn sɔ 'wʋ, -ɩn 'yligbe -na bhʋ -gʋ tɩklɩɩ!» 'Ɩn ɔɔ nyɩmɛ yia 'wʋblu, ɔ yia nɔnʋe bhli -bha -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gbʋnya Pɔlʋ nʋa lɛ da, nyɩmaa -zlo 'yɩa we -yɔ, 'ɩn wa yia 'wʋkpɩ Likaoni -nyɩmaa wɛlɩ nya: «-Lagɔnya ka nyɩma -zɛ, we ka -amɩaa -gbɛ lasibhli!» ");
INSERT INTO kyf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasɩ wa laa -Zeusʋ, 'ɩn Pɔlʋ -wa gbʋgbanyɔɔ 'gbʋ, wa yia -mɔɔ la Ɛlɩmɛsɩ. ");
INSERT INTO kyf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","-Lagɔ wa laa -Zeusʋ, we -budu 'yligbe wee 'gbee ŋwɛ -yɔ. 'Ɩn we bʋbɔnyɔ -yɔ bhligblɔnya yia yi, 'ɩn ɔ yia we -kpeli suu -bʋɩ nya. Ɔ -yɔ ɔ nyɩmaa -zlo 'yɩbha wa 'ka Banabasɩ -yɔ Pɔlʋ -zila -yɔ bʋbɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","'Ɩn da -Zezuu tietienya Banabasɩ -yɔ Pɔlʋ 'nʋa wee gbʋ -mɩnɩ, 'ɩn wa yia wa 'wʋ *-bananya yla. 'Ɩn wa -yɔ gwagwɩe yia nyɩmaa -zlo glaa mnɩ 'wʋkpɩkpɩe nyaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«'Oo! Bheliaɩn, lɛɛ -lu ka 'gbʋ a nʋ 'sa? Nɩɩ, nyɩma -amɩa -mɩa 'ya amɩa 'bhisa. -Lagɔgbʋ -a yia aɩn -yla gbaa. Nɩɩ, a 'bhʋ -sini -kpʋanya -mɩnɩ 'bɩ, a 'bhiti 'yliyɔga -Lagɔɔ gbɛgbɛɩn! Mɔ nʋa yalɩ klaa, dʋdʋ klaa, gumunyu -yɔ we lʋ -lu weee lɛ. ");
INSERT INTO kyf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bha, bhlasabhla, -Lagɔ ka dʋdʋgʋ -nyɩma weee 'yitide, 'ɩn wa yia wa 'dɛɛ nʋʋ 'yoo bhli. ");
INSERT INTO kyf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","'Ɩn -mʋʋ bhla, -Lagɔ yia ɔ 'dɛ -slolu aɩn -yla, ɔ zʋzɔnʋlɛnʋe nya 'kɔmʋʋ: ɔ lʋalɩ yalɩnyu, 'ɩn amɩaa kpaa -li zʋa. 'Ɩn ɔ nyɛa aɩn lililu duun, ɔ yelia 'mʋna aɩn dlɩ zɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Banabasɩ -yɔ Pɔlʋ ka 'klɩ 'yɩ, 'ɩn wa yia gbʋ weee 'bɩgʋ 'plɩlɩ waa nyɩma -zlo -yla, nɩɩ, wa 'na bʋbɔlʋ wamɩa -nɩ, 'bhie -maa yia we -yɔŋwnu lʋgada. ");
INSERT INTO kyf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","We bhla Zuifʋnya 'bhʋa Antiɔsʋ Pisidii -yɔ Ikoniumʋ -dʋdʋ -gʋ, wa nynia Lisɩtlɩ, 'ɩn wa yia nyɩmaa -zlo lʋbho. 'Ɩn wa yia -maa dlɩ 'wʋbhu, 'ɩn wa yia Pɔlʋ gbɔkʋ 'wʋbha, wa 'ka ɔ 'bhaa 'gbʋ. 'Bhie, wa yia ɔ 'gbe -gnima kwa, wa mɩa dlɩɩ nɩɩ, ɔ ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","'Ɩn da -Lagɔnyɩma gbelia Pɔlʋ, ɔ yia 'wʋsɔ, 'ɩn ɔ yia wee 'gbe nʋkplɛ lʋmnɩ. -Mʋʋ zlɩ zlɩa, 'ɩn ɔ -yɔ Banabasɩ 'sɔ yia Dɛlɩbʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔlʋ -yɔ Banabasɩ gbaa -Lagɔgbʋ Dɛlɩbʋgbe nʋkplɛ, 'ɩn nyɩma duun yia -mɔ -Lagɔ pla. 'Bhie, wa yia lʋbhiti Lisɩtlɩ, Ikoniumʋ, we -yɔ Antiɔsʋ Pisidii -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","'Ɩn wa tɛmanɩa -Lagɔnyɩmaa dlɩ la, -zugba wa pa wa 'kʋayli, nɩɩ, wa zʋ dlɩ gege. 'Ɩn wa nɛɛ wa -ylaɛ: «We mɩ nɩɩ, -a 'plɩlɩ sɩasɩe duun lʋ 'bhie, -a 'ka *-Lagɔɔ nyɩmaa 'wlulapɩlɩe zɔ pla.» ");
INSERT INTO kyf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","'Ɩn Pɔlʋ -yɔ Banabasɩ yia nyɩma kpasɩ lapalɩ *leglizɩ -bhlo -bhlo zɔ. Wa plaa 'sun, wa bhubhoea -Lagɔ, 'bhie, wa yia waa -Lagɔnyɩma -wa zʋa -Lagɔ dlɩ -gʋ, -Lagɔ kwɛɛ zʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","-Mʋʋ 'bɩgʋ, wa 'plɩlɩa Pisidii -dʋdʋ -gʋ, 'ɩn wa yia Panfilii nyni. ");
INSERT INTO kyf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wa gbaa -Lagɔgbʋ Pɛlɩzɩgbe nʋkplɛ, -mʋʋ 'bɩgʋ, 'ɩn wa yia Atalii mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","-Mɔ wa -gblaa 'glʋ 'wʋ Atalii, 'ɩn wa yia Antiɔsʋ lʋbhiti Silii -dʋdʋ -gʋ. -Mɔ wa zʋa zlɩmɛ wa -Lagɔɔ 'nanɩ kwɛɛ, lubho -we wa bhɩa da nʋnʋee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Da wa nynia Antiɔsʋ, 'ɩn wa yia leglizɩ weee 'wlugbeli. -We weee -Lagɔ nʋa lɛ wa sɔ nya, 'ɩn sa -Lagɔ -kalɩa -wa 'nɩa Zuifʋ -yla 'yoo, 'ɩn -maa 'ka 'ya -Lagɔ pla, wa yia we -sa 'bɩgʋ dɩ nya. ");
INSERT INTO kyf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","'Ɩn Pɔlʋ -yɔ Banabasɩ yia Antiɔsʋ -tʋ -daan -Zezuu 'bɩnɔnya nya. ");
INSERT INTO kyf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","We bhla -bhlokpadɛ nya, nyɩma -tɔlʋa 'bhʋa Zudee -dʋdʋ -gʋ, 'ɩn wa yia Antiɔsʋ mnɩ. Da wa nynia -mɔ, wa yia -Lagɔbhelia gbʋ -mɩnɩɩ slolue bhli, wa nɛɛ: «Sa Moizɩɩ tite gbaa, wa 'pa nyɩma knɩ 'wʋ, a 'nɩ 'sa knɩ pla, a 'nɩ mneni a 'ka gbʋ 'wʋbhʋ!» ");
INSERT INTO kyf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔlʋ -yɔ Banabasɩ 'nɩ wa wɛlɩ -yɔŋwnu -gbaa, 'ɩn wa -yɔ wa 'sɔ yia wee gbʋ -mɩnɩ -gʋ kpɛlɩ bhabha. We 'gbʋ, wa yia Pɔlʋ, Banabasɩ -yɔ Antiɔsʋ -nyɩma tɔlʋa tie -Zeluzalɛmʋ, 'ɩn wa -yɔ -Zezuu tietienya -yɔ nyɩma kpasɩ 'ka wee gbʋ -mɩnɩ gba. ");
INSERT INTO kyf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","We 'gbʋ, wa mɩ mnɩmnɩe -gʋ, 'ɩn leglizɩ yia wa -yɔbɛ, 'ɩn wa yia wa yoo kwa. 'Ɩn wa yia Fenisi -yɔ Samalii -dʋdʋ -gʋ 'plɩlɩ, sa nyɩma -wa 'nɩa Zuifʋ plaa -Lagɔ, -zugba wa -yɔ we gbagbɩe mnɩ. 'Ɩn wee 'dɩzɔnʋ -mɩnɩ yia -Lagɔbhelia weee 'mʋna 'kadʋ 'wʋla. ");
INSERT INTO kyf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Da wa nynia -Zeluzalɛmʋ, 'ɩn leglizɩ klaa, -Zezuu tietienya klaa, we -yɔ nyɩma kpasɩ yia wa 'lakpasu kpa. 'Ɩn -we -Lagɔ nʋa lɛ wa sɔ nya, wa yia we -sa 'bɩgʋdɩ nya -maa -yla. ");
INSERT INTO kyf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Zuifʋʋ -zakpa -bhlo wa laa Falizɩnyɩma wa glaa -nyɩma tɔlʋa, -wa zʋa -Zezu dlɩ -gʋ -sɔa 'wʋ, 'ɩn wa nɛɛ: «-Lagɔnyɩma -wa 'nɩa Zuifʋ, wa 'pa wa knɩ 'wʋ, 'ɩn wa gba wa -yla, wa zʋ Moizɩɩ tite 'nʋŋwɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","'Ɩn -Zezuu tietienya -yɔ nyɩma kpasɩ yia 'wlugbeli, wa 'ka wee gbʋ -mɩnɩ 'wʋsɩsalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wa kpɛlɩa kpokpo, Piɛlɩ -sɔa 'wʋ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Na bhelia, amɩaa 'dɛ -yi we 'ji nɩɩ, -Lagɔ ka -bha 'mɩ -sa aɩn glaa, we 'bɩ ka 'wʋgwlɛ, 'ɩn -wa 'nɩa Zuifʋ, ɩn 'ka wa -yla -Lagɔgbʋ gba, wa -ka we 'nʋ, wa 'ka -Zezu dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","-Lagɔ -ɔ -yia nyɩmaa dlɩ, ɔ ka we -slolu nɩɩ, -wa 'nɩa Zuifʋ, ɔ ka wa gbʋ -yɔŋwnu, 'ɩn ɔ yi 'yaa wamɩa Zuzu 'Pʋpa 'nyɛ, -amɩa 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","-Lagɔ 'nɩ nyɩmɛ 'wʋgbɩzɩ, -a -yɔ wa 'sɔ nyɩdɩ. -We ka gbʋ -wa, ɔ ka wa dlɩ -yɔwɔlʋ, wa ka -Zezu dlɩ -gʋ zʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","'Ɩn -slɛɛn, lɛɛ -lu ka 'gbʋ a yla -Lagɔ la? 'Ɩn 'gba 'kadʋ -amɩaa dʋkpasɩ -yɔ -amɩaa 'dɛ 'nɩa mneni -a 'ka 'wʋbhu, 'ɩn a dɩ we -Zezuu 'bɩnɔnya 'wlua? ");
INSERT INTO kyf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","-Ɩnnya! -A dɩ we dlɩ 'wʋ nɩɩ, Nyɩmaa -Kanyɔ -Zezuu 'nanɩɩ 'gbʋ, -a yia 'pʋ, wamɩa 'bhisa!» ");
INSERT INTO kyf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tɔʋn, nyɩma weee yia ŋwɛ 'mu, -zugba wa pʋlʋ Banabasɩ -yɔ Pɔlʋ 'sɔ yukwli. Gwɛdigbʋ -yɔ gbʋ 'kadɩ -Lagɔ nʋa lɛ wa sɔ nya -wa 'nɩa Zuifʋ nyɩdɩ, -zugba wa gba we waa nyɩma -yla. ");
INSERT INTO kyf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Da wa bhɩa gbagbɩe, 'ɩn *'Zake yia wɛlɩ 'wʋbhu, ɔ nɛɛ: «Na bhelia, a pʋlʋ 'mɩ yukwli. ");
INSERT INTO kyf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sa -Lagɔ ylaa tɩatɩa nyɩma 'nɩa Zuifʋ, 'ɩn ɔ yia -bha nyɩmaa -zakpa -bhlo -sa wa glaa, -maa 'ka ɔ -nʋ -zɛ, we gbʋ 'Simɔɔ gbaa -aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","'Ɩn wee wɛlɩ -mɩnɩ -yɔ -Lagɔgbʋʋ -falɩpanyaa wɛlɩ yia bhli -bhlo. Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ");
INSERT INTO kyf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Jejitapɛ nɛɛ: «-Mʋʋ 'bɩgʋ, lʋ na yia yia cɩ, 'ɩn -Davidɩɩ -budu bhlia, ɩn 'ka we 'sʋbha lʋ. Ɩn 'ka we 'sʋbha lʋ we 'ku -gʋ, 'ɩn ɩn 'ka we 'yligbeli. ");
INSERT INTO kyf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","'Ɩn nyɩmaa pnɩɩ weee yia Jejitapɛɛ 'yoo datalɩa. Cɩɩn, nyɩma -wa 'nɩa Zuifʋ ɩn laa wa 'ka na -nʋ -zɛ, ma -wa.» ");
INSERT INTO kyf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","-We Jejitapɛ gbaa mʋ mɩa dɛ. Ɔ ka wee gbʋnya -mɩnɩ -slolu 'cɩn, -mʋʋ 'bɩ ka 'wʋgwlɛ, 'ɩn 'sa ɔ mɩa we lɛnʋda.› » ");
INSERT INTO kyf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","'Zake yia we -gʋdɩɛ: «We 'gbʋ, -we na yɩa -yɔ, nyɩma -wa 'nɩa Zuifʋ, -wa plaa -Lagɔ, -a 'na sɩalɩ wa -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nɩɩ, -a cɛlɩ wa 'wʋɛ: wa 'na lili -zila -bʋbɔnɩmɛ -nɩ, we ka pʋɩn. 'Ɩn wa 'na nʋnʋ mʋtnɩgbʋ lɛ -nɩ. Nɩmɛ -we 'pɩɔn 'nɩa 'wʋtla, we -yɔ nɩmɛɛ 'pɩɔn -tʋkpa, wa 'na lili we -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","-We ka gbʋ -wa, bha bhlasabhla, nyɩma slolua Moizɩɩ tite 'gbe -bhlo -bhlo 'wʋ, -zugba wa zɛlɩ we -Lagɔbudunya zɔ, *Nyapɛylɩ weee nya.» ");
INSERT INTO kyf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tɔʋn, -Zezuu tietienya -yɔ nyɩma kpasɩ -yɔ leglizɩ weee yia wɛlɩ -bhlo bhlɩ nɩɩ, wa -sa -bha nyɩma wa glaa, 'ɩn wa 'ka wa -yɔ Pɔlʋ -yɔ Banabasɩ tie Antiɔsʋ. 'Ɩn wa yia -bha Zudasɩ wa laa Balɩsabasɩ -yɔ Silasɩ -sa. Wamɩa nyɩma 'sɔ -manɩ, -bha -Lagɔbhelia zʋa wa. ");
INSERT INTO kyf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","'Sɛbhɛ wa cɛlɩa wa zʋa wa kwɛɛ we nʋkpla -wɛlɩ nɩ: Amɩa, -amɩaa bhelia -Lagɔnyɩma 'nɩa Zuifʋ, -wa mɩa Antiɔsʋgbe nʋkplɛ, Silii -yɔ Silisi -dʋdʋ -gʋ, -amɩa -Zezuu tietienya -yɔ nyɩma kpasɩ saa aɩn fʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","-A ka 'nʋ nɩɩ, nyɩma ka -amɩaa -gbɛ 'bhʋ, 'ɩn wa yia amɩaa dlɩ sumanɩa mnɩ wa ŋwɛɛ wɛlɩnya nya. -Amɩa 'nɩ wa tie -mʋʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","We 'gbʋ, -a yia wɛlɩ -bhlo bhlɩ, 'ɩn -a yia -bha nyɩma -sa, -a 'ka wa tie. 'Ɩn wa 'ka -amɩaa jijli -talea Banabasɩ -yɔ Pɔlʋ yoo kwa amɩaa -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Waa nyɩma 'sɔ ka wa 'pʋpʋe dlɩ -sa, -amɩaa -Kanyɔ -Zezu Klisɩɩ lubhoo nʋnʋee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","We 'gbʋ, -a yia Zudasɩ -yɔ Silasɩ tie amɩaa -gbɛ. 'Ɩn -we -a cɛlɩa aɩn 'wʋ da, wa 'ka we 'wʋsɩsalɩ aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nɩɩ, Zuzu 'Pʋpa -yɔ -aɩn 'sɔ 'nɩ 'yɩbha wa dɩ 'gba 'kadʋ aɩn 'wlu. Nɩɩ, titenya mɩa da, a zʋ we 'nʋŋwɛ, -gla -wa: ");
INSERT INTO kyf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","a 'na lili -zila -bʋbɔnɩmɛ -nɩ, we ka pʋɩn. Nɩmɛɛ 'pɩɔn -tʋkpa -yɔ nɩmɛ -we 'pɩɔn 'nɩa 'wʋtla, a 'na lili we -nɩ. 'Ɩn a 'na nʋnʋ mʋtnɩgbʋ lɛ -nɩ. A -ka we 'nʋŋwɛ zʋ, -zugba gbʋzɔnʋ a nʋa lɛ. -A -sa aɩn fʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wa 'tidea waa nyɩma -mnʋa -manɩ 'yi, 'ɩn -maa yia Antiɔsʋ mnɩ. Wa yia -Lagɔnyɩma weee 'wlugbeli, 'ɩn wa yia wee 'sɛbhɛ -maa yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wa zɛlɩa wee 'sɛbhɛ, we yia wa 'mʋna 'wʋla, we nʋkplawɛlɩ ka wa 'kʋayli 'paa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zudasɩ -yɔ Silasɩ -wa ka dɛ mɩa -Lagɔgbʋʋ -falɩpanya nya, wa zʋa -Lagɔbhelia 'dɩ kpokpo, 'ɩn wa yia wa 'kʋayli 'pa, 'ɩn wa yia wa dlɩ latɛmanɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","'Ylɩ sanɩmɛ 'plɩa, 'ɩn -Lagɔbhelia yia wa 'yoo 'nyɛ -dlɔɔ. Wa yia -wa tiea zlɩmɛ wa -gbɛ lʋbhiti.  ");
INSERT INTO kyf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nɩɩ, we nanɩ Silasɩ dʋdʋ ɔ 'ka wa -gbɛ -tʋ, 'ɩn ɔ yia -bha -tʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","We bhla, Pɔlʋ -yɔ Banabasɩ ka Antiɔsʋ -tʋ. Wa -yɔ nyɩmaa -zlo 'sɔ, -zugba wa slolu nyɩma, 'ɩn wa gba -Lagɔgbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","'Ylɩ sanɩmɛ 'plɩa, 'ɩn Pɔlʋ nɛɛ Banabasɩ -ylaɛ: «'Gbe weee -we nʋkplɛ -a -yɔ -Lagɔgbʋʋ gbagbɩe 'plɩa -a 'bhiti -mɔ lʋ. -A 'ka -amɩaa bhelia 'yɩ, -de sa wa mɩ -mɔɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Da wa mɩa mnɩda, *Zaan wa laa Malɩkɩ, Banabasɩ 'yɩbha wa -yɔ ɔ 'sɔ 'ka mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","'Ɩn Pɔlʋ 'nɩ we -yɔŋwnu, -we ka gbʋ -wa, Malɩkɩ ka zlɩmɛ wa 'bɩbhʋ Panfilii -dʋdʋ -gʋ, 'ɩn ɔ 'nɩ wa kwalɩ, wa -Lagɔlubho 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kpɛlɩe 'kadʋ yia Pɔlʋ -yɔ Banabasɩ nyɩdɩ -bho, 'ɩn wa yia -yɔbhʋbhlʋ. Banabasɩ yia Malɩkɩ 'wʋbhu, 'ɩn wa yia 'glʋ 'wʋbho, 'ɩn 'nyunyɩdɩdʋdʋ wa laa Siplʋ, wa yia we -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","'Ɩn, Pɔlʋ -mɔɔ yia -bha Silasɩ -sa. 'Ɩn -Lagɔnyɩma yia -Lagɔ bhubhoe wa 'dɛ 'sɔɔ -nʋ nya, nɩɩ, Nyɩmaa -Kanyɔ nʋ wa 'nanɩ 'wʋ, 'bhie, wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","'Ɩn wa yia Silii -yɔ Silisi -dʋdʋ -gʋ 'plɩlɩ, -zugba wa -yɔ leglizɩnyaa 'kʋaylipapɩe mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔlʋ nynia Dɛlɩbʋ -yɔ Lisɩtlɩ -gbenya nʋkplɛ, -Zezuu 'bɩnɔnyɔ yabhlo wa laa Timotee, -zugba ɔ mɩ -mɔ. Zuifʋŋwnɔ -ɔ zʋa -Zezu dlɩ -gʋ, ɔ yu -wa, 'ɩn ɔ dide mɩa *Glɛkɩyu nya. ");
INSERT INTO kyf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","-Lagɔnyɩma mɩa Lisɩtlɩ -yɔ Ikoniumʋ -gbenya nʋkplɛ, ma gbaa Timotee gbʋzɔnʋ gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔlʋ 'yɩbha ɔ -yɔ ɔ 'sɔ 'ka mnɩ. Ɔ 'bhua ɔ 'wʋ, 'ɩn ɔ yia ɔ *knɩ 'wʋpa, Zuifʋ -wa mɩa wee dʋdʋ -gʋʋ 'gbʋ. -We ka gbʋ -wa, -maa weee -yi ɔ dide Glɛkɩyu nya. ");
INSERT INTO kyf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Da wa mɩa 'gbenya -gʋ 'plɩda -bhlo -bhlo, gbʋnya -Zezuu tietienya -yɔ -Zeluzalɛmʋʋ -Lagɔnyɩma kpasɩ pʋpalɩa, -zugba wa -yɔ we gbagbɩe mnɩ -Lagɔnyɩma -yla nɩɩ, wa zʋ we 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","'Ɩn leglizɩnya yia latɛmanɩ dlɩzʋzʋe 'wʋ. 'Ɩn sa zlɩ zlɩa, -zugba wa bho -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Da Zuzu 'Pʋpa gbaa wa 'na gbalɩ -Lagɔgbʋ -Azii -dʋdʋ -gʋ -nɩ, 'ɩn wa yia Flizii -yɔ -Galasii -dʋdʋ -gʋ 'plɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Da wa nynia Mizii -yɔ Bitiniii 'wʋgbelida, wa ka Bitiniii dʋdʋ -gʋ -mnɩmnɩe layla. 'Ɩn -Zezuu Zuzu 'nɩ we ŋwnu wa -yla. ");
INSERT INTO kyf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","We 'gbʋ, wa 'plɩlɩa Mizii -dʋdʋ -gʋ, 'ɩn wa yia Tloasɩgbe nʋkplɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Sabɔ, Pɔlʋ yia Masedʋanɩ -nyɩmɛ yabhlo -yɔyɩ 'yligbeda ɔ 'yli 'wʋ. 'Ɩn -mɔɔ nɛɛ ɔ -yla: «-Na zukpa -wa, -ɩn 'plɩlɩ Masedʋanɩ -dʋdʋ -gʋ, -ɩn 'ka -aɩn 'wʋsa.» ");
INSERT INTO kyf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wee gbʋ -mɩnɩ 'bhʋa Pɔlʋ 'yli -gʋ, -bha -bhlokpadɛ -a gbaa -a 'ka Masedʋanɩ mnɩ. -We ka gbʋ -wa, -a ka we -yɔyɩ nɩɩ, -Lagɔ ka -aɩn la, -a 'ka -mɔ -nyɩma -yla -Lagɔgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","-A -gblaa 'glʋ 'wʋ Tloasɩ, 'ɩn -a yia 'nyunyɩdɩdʋdʋ wa laa Samotlasɩ -gʋ mnɩ tɩklɩɩ. -Mʋʋ 'bɩgʋ zlɩ zlɩa, 'ɩn -a yia Neapoli nyni. ");
INSERT INTO kyf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","-Mɔ -a 'bhʋa, 'ɩn Masedʋanɩ -dʋdʋ -gʋʋ 'gbe 'kadʋ wa laa Filipʋ, -we Wlɔmʋ -nyɩma pɩlɩa 'wlu la, 'ɩn -a yia -mɔ mnɩ. -A ka 'ylɩ duun li wee 'gbe nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nyapɛylɩ nynia, 'ɩn -a yia 'gbe nʋkplɛ 'tla, -a yia -gbʋa ŋwɛ -yɔ mnɩ. Da -a zʋa we dlɩ -gʋ nɩɩ, -mɔ Zuifʋ bhubhoelia 'cɩn -Lagɔ. 'Ŋwnɩ -wa gbelia -bha 'wlu, -a -dɩa la, 'ɩn -a yia wa -yla gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Waa 'ŋwnɩ glaa 'yabhlo wa laa Lidii, Tiatilɩgbe 'wʋ wa gwalɩlɩa ɔ, 'naa -zalʋ ka -valɛ 'tɛa, 'mʋ ɔ paa pɛlʋ, 'ɩn ɔ bʋbɔa -Lagɔ. Ɔ mɩ -aɩn yukwli pʋlʋda, 'ɩn Nyɩmaa -Kanyɔ yia ɔ dlɩ 'wʋkalɩ, -zugba -we Pɔlʋ mɩa gbada ɔ nʋ we. ");
INSERT INTO kyf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Da -a batizea ɔ -yɔ ɔ nyɩma 'sɔ, 'ɩn ɔ nɛɛ -aɩn -ylaɛ: «We -ka aɩn dlɩɩ -mɩ, nɩɩ, ɩn ka -Lagɔgbʋ -yɔŋwnu 'piɛɩn, a yi na -gbɛ ladɩlɩa.» 'Ɩn ɔ nɛɛ -a ŋwnu we -yɔ -kpɔ. ");
INSERT INTO kyf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","'Ylɩ yabhlo nya, da wa bhubhoelia -Lagɔ, -a mɩ -mɔ mnɩda, 'ɩn gayloŋwnɔ yabhlo yia -aɩn yoo yi. Ɔ ka -zatɩbhɛ -zuzu -gʋ, mʋ nya ɔ bhlɩa kwɛ la. Wee ɔ kwɛ labhlɩlɩe -yɔ ɔ yɩa 'gwɛzi duun ɔ -cɩan -yla. ");
INSERT INTO kyf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","'Ɩn ɔ yia -a -yɔ Pɔlʋ 'sɔ 'bɩ -bholu, 'wʋkpɩkpɩe nya: «Waa nyɩma mɩa da, Yalɩ -Lagɔɔ lubhonʋnya -wa. Sa -Lagɔ 'kaa aɩn gbʋ 'wʋsa, we 'yoo wa mɩa da aɩn dasloluda.» ");
INSERT INTO kyf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","'Sa ɔɔ 'ŋwnɔ nʋa 'kɔmʋʋ. We bhɩalɩda, 'cɛ yia Pɔlʋ dɔlɔ, ɔ 'bhitia, 'ɩn ɔ nɛɛ wee zuzu -ylaɛ: «-Zezu Klisɩɩ 'ŋnɩ nya, ɩn nɛɛ -mɩ -ylaɛ, -ɩn 'tla ɔ 'wʋ!» -Bha -bhlokpadɛ, 'ɩn wee zuzu yia ɔ 'wʋtla. ");
INSERT INTO kyf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɔɔ gayloŋwnɔɔ -cɩan yia we -yɔyɩ nɩɩ, ɔ 'nɩ 'maslɛɛn mneni, ɔ 'ka wa -yla 'gwɛzi 'yɩ. 'Ɩn wa yia Pɔlʋ -yɔ Silasɩ kpa, 'ɩn wa yia wa -zejila 'wʋ kwa nyɩmaa 'yugalɩnyaa -gbɛ, -gla nya. ");
INSERT INTO kyf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wa kwaa wa Wlɔmʋʋ gbʋwʋbhunya 'yu, wa nɛɛ -maa -ylaɛ: «Nyɩma mɩa da, wa ka -amɩaa 'gbe gbugblolu. Zuifʋnya -wa, ");
INSERT INTO kyf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","'ɩn wa zʋayli -gbʋ, -amɩa Wlɔmʋ -nyɩmaa tite gbaa -a 'na ŋwnunu -yɔ -nɩ, 'ɩn -a 'na nʋnʋ lɛ nɩ, 'mʋ wa slolua.» ");
INSERT INTO kyf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","'Ɩn nyɩmaa -zlo yi 'yaa wa 'cɛ -yɔ 'palɩ. Wlɔmʋ -nyɩmaa gbʋwʋbhunya nɛɛ wa -sa Pɔlʋ -yɔ Silasɩ -bana 'wʋ, 'ɩn wa 'ka wa sɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wa sɛlɩa wa bhabha, 'bhie, wa yia wa -kaslʋ 'wʋpa. 'Ɩn wa nɛɛ -kaslʋbuduu ŋwɛkʋnyɔ -yla, ɔ zʋ wa 'yliyɔ 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wa gbaa sa wɛlɩ -mɩnɩ ɔɔ -kaslʋbuduu ŋwɛkʋnyɔ -yla, 'ɩn -mɔɔ yia wa -kaslʋbuduu nyɩdɩ -komi zɔ 'pa. 'Ɩn ɔ yia wa gbloko bhʋ 'wʋ palɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","-Mɔ zlɩ -nyɩdɩ, Pɔlʋ -yɔ Silasɩ 'sɔ mɩ -Lagɔ bhubhoeda, wa mnɩnɩ -Lagɔɔ 'ŋnɩ lʋʋ nya, -zugba -kaslʋnyɩma tɔlʋa pʋlʋ wa yukwli. ");
INSERT INTO kyf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","-Bha -bhlokpadɛ, dʋdʋ yia zuklu 'tɩtɛɛ, 'ɩn -kaslʋbuduu -klu yia lazuklu. Tɔʋn, 'ɩn we klolo weee yia -kalɩ, 'ɩn -kaslʋnyɩma weee gbloko yia ladɩdlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Da ɔɔ -kaslʋbuduu ŋwɛkʋnyɔ ganɔa, 'ɩn ɔ yia klolonya -yɔyɩ -kalɩda. Ɔmɔ dlɩɩ nɩɩ, waa -kaslʋnyɩma ka -gwa. 'Ɩn ɔ yia -mɔ ɔ tʋgʋgblɛ -sa, ɔ 'ka ɔ 'dɛ 'bha. ");
INSERT INTO kyf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","'Ɩn Pɔlʋ yia 'wʋkpɩ 'tɩtɛɛ, ɔ nɛɛ: «-Ɩn 'na nʋnʋ -na 'dɛ gbʋnyuu -yla lɛ -nɩ, -a 'dɛ weee mɩ -bha!» ");
INSERT INTO kyf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tɔʋn, -kaslʋbuduu ŋwɛkʋnyɔ yia 'napɛ -yɔlayɩbha, 'ɩn ɔ yia gwagwɩe -yɔ tɛlɩtɛlɩe nya -buduu komi zɔ pla, 'ɩn ɔ yia Pɔlʋ -yɔ Silasɩ 'sɔ 'yu 'kukolu 'sibhli. ");
INSERT INTO kyf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","-Mʋʋ 'bɩgʋ, ɔ wlelia wa, 'ɩn ɔ yia wa layɩbha: «Na -cɩan, sa ɩn 'ka nʋ, 'ɩn ɩn 'ka gbʋ 'wʋbhʋa?» ");
INSERT INTO kyf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","'Ɩn Pɔlʋ -yɔ Silasɩ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-Ɩn zʋ Nyɩmaa -Kanyɔ -Zezuu dlɩ -gʋ, 'ɩn -ɩn -yɔ -na zʋaylinyɩma 'sɔ 'ka gbʋ 'wʋbhʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","'Ɩn wa yia ɔ -yɔ ɔ zʋaylinyɩma weee -yla -Lagɔgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sabɔ, bhla -bhloo 'dɛ nya, 'ɩn ɔɔ -kaslʋbuduu ŋwɛkʋnyɔ -yɔ Pɔlʋ -yɔ Silasɩ 'sɔ yia ɔ 'dɛɛ -gbɛ mnɩ. 'Ɩn ɔ yia wa 'gbia glʋ, 'ɩn -maa yia -bha -bhlokpadɛ ɔ -yɔ ɔ zʋaylinyɩma weee batizee. ");
INSERT INTO kyf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ɔ -yɔ Pɔlʋ -yɔ Silasɩ mnɩa ɔ -buduŋwɛɛ, 'ɩn ɔ yia wa lililu 'nyɛ. 'Ɩn ɔɔ nyɩmɛ -yɔ ɔ zʋaylinyɩma yia 'mʋna li, -Lagɔɔ dlɩ -gʋzʋzʋee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Da zlɩ zlɩa, Wlɔmʋ -nyɩmaa gbʋwʋbhunya yia 'slʋja tie -kaslʋbuduu ŋwɛkanyɔɔ -gbɛ nɩɩ, wa 'tide waa nyɩma -manɩ 'yi. ");
INSERT INTO kyf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","'Ɩn -kaslʋbuduu ŋwɛkʋnyɔ yia we wɛlɩ Pɔlʋ kwa, 'ɩn ɔ nɛɛ: «Gbʋwʋbhunya ka nyɩma tie, wa nɛɛ, ɩn 'tide aɩn 'yi. We 'gbʋ, a mneni a 'ka 'tla, 'ɩn a 'ka mnɩ -dlɔɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","'Ɩn Pɔlʋ nɛɛ waa 'slʋja -ylaɛ: «-Amɩa -wa Wlɔmʋ -nyɩma, wa 'nɩ -amɩaa -yɔgbʋ 'wʋbhu sazɔnʋ sa, 'ɩn wa yia -aɩn bhɩtɩ -zejila 'wʋ, 'bhie, 'ɩn wa yia -aɩn -kaslʋ 'wʋpa. 'Ɩn -slɛɛn wa 'yɩbha wa 'ka -aɩn -kaslʋ 'wʋ -sa 'wiemɩɩ? -Ɩnnya, we 'na 'ka lɛnʋ. Wa yi, wa 'ka -aɩn wleli wa 'dɛ nya!» ");
INSERT INTO kyf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","'Ɩn 'slʋja yia we 'dɩ Wlɔmʋ -nyɩmaa gbʋwʋbhunyaa -gbɛ kwa. -Maa 'nʋa nɩɩ, Pɔlʋ -yɔ Silasɩ mɩ Wlɔmʋ -nyɩma nya, 'ɩn we yia -maa nyanɔ dlɩ 'wʋslu. ");
INSERT INTO kyf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","'Ɩn wa yia wa bhubhoea yi, 'bhie, wa yia wa -kaslʋ 'wʋ -sa. 'Ɩn wa nɛɛ: «Amɩa zukpa -wa, a 'tla 'gbe nʋkplɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Da Pɔlʋ -yɔ Silasɩ 'tlaa -kaslʋ 'wʋ, 'ɩn wa yia Lidiii -buduŋwɛɛ mnɩ. Wa 'yɩa -Lagɔbhelia, 'ɩn wa yia wa 'kʋayli 'pa, 'bhie, wa yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔlʋ -yɔ Silasɩ 'sɔ 'plɩlɩa Anfipolisɩ -yɔ Apoloni -gbenya nʋkplɛ, 'ɩn wa yia Tɛsalonikɩ nyni. -Mɔ Zuifʋʋ *-Lagɔbudu mɩa. ");
INSERT INTO kyf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","'Ɩn Pɔlʋ yia -mɔ pla sa ɔ nʋa 'cɩn 'sa. 'Ɩn Zuifʋʋ Nyapɛylɩ ta nya, 'ɩn ɔ -yɔ wa yia -Lagɔsɛbhɛ -gʋ kpɛlɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","'Ɩn ɔ yia we 'ji gba, 'bhie, ɔ yia we wa 'klʋslolu nɩɩ, wee 'sɛbhɛ nɛɛ, we mɩ nɩɩ, -Lagɔɔ -Bhasanyɔ sɩa, ɔ 'ka tlɩ, 'ɩn ɔ 'ka 'wʋsɔ tlɩtlɩnya glaa. Ɔ nɛɛ nɩɩ: «Ɔɔ -Zezu -ɔ ka gbʋ na gbaa da aɩn -yla, mɔ -wa -Lagɔɔ -Bhasanyɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wee wɛlɩ zɩa wa lʋ Zuifʋ tɔlʋʋ dlɩ kwɛ, wa yia we -yɔŋwnu, 'ɩn wa yia Pɔlʋ -yɔ Silasɩ 'bɩbholu. 'Sa -bhlokpadɛ, *Glɛkɩ -duun -wa bʋbɔa Zuifʋʋ -Lagɔ nʋa, we -yɔ 'ŋnɩmnɩ zʋayliŋwnɩɩ -zlo. ");
INSERT INTO kyf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","'Ɩn Zuifʋ yia we zenyi nʋ, wa yia gbʋkpʋa -nyɩma labhu 'yloogblʋ, 'ɩn wa yia -zlɛ ladɩ 'gbe nʋkplɛ. 'Ɩn wa yia Pɔlʋ -yɔ Silasɩɩ da mnɩ, Zasɔɔn -buduŋwɛɛ, wa 'ka wa -zejila 'yu kwa. ");
INSERT INTO kyf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","'Ɩn wa 'nɩ Pɔlʋ -yɔ Silasɩ 'yɩɩ 'gbʋ, wa yia Zasɔn -yɔ -Lagɔbhelia tɔlʋa 'gbee 'wlulapɩlɩnya 'yu kwa. 'Ɩn wa yia 'wʋkpɩkpɩe bhli: «Nyɩma -manɩ ka dʋdʋ weee gbugblolu, 'ɩn wa yi 'yaa -slɛɛn -seli yi! ");
INSERT INTO kyf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zasɔn ka wa 'bɩ 'nyɛ ɔ 'dɛɛ -gbɛ! Waa nyɩma wee'e zʋ nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ *Sezaaa titenya 'nʋŋwɛ, 'ɩn wa nɛɛ, nyɩmaa 'wlulapɩlɩnyɔ -putu mɩ, 'mɔ wa laa -Zezu.» ");
INSERT INTO kyf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","'Ɩn wee wɛlɩnya -mɩnɩ yia nyɩmaa -zlo -yɔ gbee 'wlulapɩlɩnyaa dlɩ 'wʋbhu, ");
INSERT INTO kyf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","'ɩn wa nɛɛ Zasɔn -yɔ -Lagɔbhelia tɔlʋa -yla, wa plʋlʋ 'gwɛzi 'kadʋ yabhlo. Wa wlaa we, 'bhie, wa yia wa 'yitide. ");
INSERT INTO kyf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Da sabɔ bɛa, 'ɩn -Lagɔnyɩma yia -bha -bhlokpadɛ Pɔlʋ -yɔ Silasɩ yoo kwa Belee. Da wa nynia -mɔ, 'ɩn wa yia Zuifʋʋ -Lagɔbudu zɔ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Belee -Zuifʋʋ dlɩ nanɩ 'yli, we 'ka Tɛsalonikɩ -Zuifʋ 'wʋzi. Wa ka -Lagɔgbʋ yukwli pʋlʋ, 'ɩn wa yia we -yɔŋwnu gwagwɩe nya slʋɩ 'mʋna nya. 'Ylɩ weee nya, wa kpɩa -Lagɔsɛbhɛ, 'ɩn wa 'ka we -yɔyɩ nɩɩ, -de -we Pɔlʋ gbaa gbʋzɔnʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","'Ɩn waa Zuifʋ glaa -nyɩma duun yia -Lagɔgbʋ -yɔŋwnu. 'Ɩn Glɛkɩ glaa 'ŋnɩmnɩ zʋayliŋwnɩ -yɔ nʋkpasia duun yi 'yaa -Lagɔgbʋ -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Da Tɛsalonikɩ -Zuifʋ 'nʋa nɩɩ, Pɔlʋ mɩ Belee -nyɩma -yla -Lagɔgbʋ gbada 'ya, tɔʋn, 'ɩn wa yia wee gbee nʋkpla -nyɩmaa dlɩɩ yalɩ 'paa mnɩ, 'ɩn -maa yia gbugblolu. ");
INSERT INTO kyf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","'Ɩn -bha -bhlokpadɛ -Lagɔbhelia yia Pɔlʋ yoo kwa gumunyu -yɔ -gbɛɩn. 'Ɩn Silasɩ -yɔ Timotee yia Belee -tʋ. ");
INSERT INTO kyf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","-Wa kwaa Pɔlʋ yoo, wa -yɔ ɔ 'sɔ yia Atɛnɩgbe nʋkplɛ nyni. Wa 'bhitia lʋ la, 'ɩn Pɔlʋ yia wa wɛlɩ zʋ, nɩɩ, Silasɩ -yɔ Timotee ylɩ -mɔ ɔ slʋɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Da Pɔlʋ mɩa Silasɩ -yɔ Timotee wʋda Atɛnɩ, ɔ 'yɩa we -yɔ nɩɩ, wee 'gbee nʋkpla -nyɩma, yoyolagɔ wa bʋbɔa duun, 'ɩn ɔ dlɩ yia 'wʋsɔ. ");
INSERT INTO kyf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","'Ɩn Zuifʋ -yɔ -wa 'nɩa Zuifʋ, -wa bʋbɔa -Lagɔ, 'ma ɔ -yɔ wa kpɛlɩa -Lagɔgbʋ -gʋ -Lagɔbudu zɔ. 'Ɩn sa zlɩ zlɩa -bhlo, 'sa ɔ gbaa -Lagɔgbʋ 'plɩplɩnya -yla -gblɔgblʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","'Sɛbhɛ -yilonya 'kadɩ wa laa Epikulɩɩ 'bɩnyɩma -yɔ Sɩtoisɩnyɩma, -maa -yɔ ɔ bhlia kpɛlɩkpɛlɩe 'ya. Tɔlʋa nɛɛ: «Zlɛsanyɔ mɩa nɩ nɛɛ -bha saa?» Tɔlʋa nɛɛ: «We 'wlʋ sa 'lakpa -Lagɔnyaa gbʋ ɔ mɩ gbada.» Nɩɩ, -Zezuu gbʋ -yɔ tlɩtlɩnya glaa 'wʋsɔgbʋ Pɔlʋ mɩa gbada, 'mʋ wa 'nʋa. ");
INSERT INTO kyf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Da wa kpaa Pɔlʋ, 'ɩn wa -yɔ ɔ yia wa gbʋwʋbhunya 'yu mnɩ, -gɔgɔ wa laa Aleopazɩ 'wlu. 'Ɩn wa yia ɔ layɩbhaɛ: «Gbʋ -lolu -ɩn mɩa dɛ -sloluda, -ɩn mneni -ɩn 'ka we 'ji gba -aɩn -ylaa? ");
INSERT INTO kyf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","-We ka gbʋ -wa, -nanagbʋnya -na gbaa dɛ -aɩn -yla, -a 'yɩbha -a 'ka we 'ji 'wʋlanʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nɩɩ, Atɛnɩ -nyɩma weee -yɔ wa 'lakpanya tʋa -bha bhla duun nya, 'wʋbhlolugbʋnyaa kpɛlɩe -yɔ we yukwli pʋlʋe nya. ");
INSERT INTO kyf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","-Mɔ Aleopazɩ 'wlu Pɔlʋ -sɔa 'wʋ, 'ɩn ɔ nɛɛ: «Atɛnɩ -nyɩma, na yɩ we -yɔ nɩɩ, amɩaa bʋbɔli nanɩ aɩn dʋdʋ bhabha. ");
INSERT INTO kyf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Da ɩn mɩa amɩaa 'gbe nʋkplɛ -zieda, ɩn ka amɩaa bʋbɔlii *-bada 'yɩ. Amɩaa -zilagʋbʋbɔlʋlu yabhlo ɩn 'yɩa -bha wa cɛlɩaɛ: -LAGƆ -Ɔ NYƖMA 'NƖA -YI. 'Ɩn -we a 'nɩa -yi, a bʋbɔa, we gbʋ ɩn yia da aɩn -yla gbaa. ");
INSERT INTO kyf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","'Ɩn -Lagɔ -ɔ nʋa dʋdʋ -yɔ we -gʋ -lu weee lɛ, mɔ -wa yalɩ -yɔ dʋdʋʋ -Kanyɔ. Ɔ'ɔ -dɩlɩ nyɩmaa 'sʋbha 'sʋbha zilabʋbɔ -budu zɔ la. ");
INSERT INTO kyf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","-Lagɔ 'nɩ 'yɩbha nyɩma 'nyɛ ɔ -lu yabhlogbɔɔ, nɩɩ, mɔ nyɛa nyɩma 'yliyɔgagɩe, nyapɛlɩ, we -yɔ -lu weee. ");
INSERT INTO kyf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nyɩmɛ yabhlogbɔɔ ɔ -laa la, 'ɩn wɛlɩ weee yia layi -mɔɔ 'gbʋ, 'ɩn wa yia dʋdʋ weee -gʋ ladɩ. 'Ɩn ɔ yia -zʋʋ 'wʋsɩsalɩda lɛnʋ wa -yla, 'ɩn ɔ yia dʋdʋ wa 'kaa -gʋ ladɩɩ bɔlʋ palɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nyɩma 'ka -Lagɔɔ datalɩɩ 'gbʋ, ɔ yi 'saa nʋ. Wa -ka sɩada -mɩ, ɔ datalɩe nya, 'ɩn wa 'ka ɔ 'yɩ. 'Ɩn -zugba -Lagɔ 'nɩ -aɩn -yɔbhʋda -mɩ 'pɩpɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‹Ɔ 'gbʋ -a -gaa 'yliyɔ, -a nɔa, 'ɩn -a mɩa la.› Amɩaa gbalɩnyaa tɔlʋa ka we gba: ‹-Amɩa mɩ 'ya ɔ 'yua nya.› ");
INSERT INTO kyf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«-A mɩ -Lagɔɔ 'yua nyaa 'gbʋ, -a 'na palɩlɩ -can, 'gwɛzi -yɔ tʋkpa -we nyɩma tɛlɩa wa 'ylimnee nya -Lagɔ 'wʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Da nyɩma 'nɩa gbʋ yabhlogbɔɔ -yi, 'sa wa nʋa, 'ɩn -Lagɔɔ gbʋ 'nɩ -mʋʋnya 'wʋlapɩlɩ. Nɩɩ, -slɛɛn, dʋdʋgʋ -nyɩma weee ɔ laa, da wa -ka -mɩ, wa 'ka wa dlɩ 'bhiti. ");
INSERT INTO kyf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ɔ ka 'ylɩ yabhlo zʋ, ɔ 'ka nyɩmɛ yabhlo ɔ -saa -bha, ɔ 'ka ɔ -gʋ 'plɩlɩ, 'ɩn ɔ 'ka dʋdʋgʋ -nyɩmaa -yɔgbʋ 'wʋbhu tɩklɩɩ. Ɔ ka we nyɩma weee 'klʋslolu, ɔɔ nyɩmɛɛ 'wʋbhubhue nya tlɩtlɩnya glaa.» ");
INSERT INTO kyf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Da wa 'nʋa tlɩtlɩe lʋʋ 'wʋsɔ gbʋ, Pɔlʋ ŋwɛɛ, 'ɩn -zakpa -bhlo yia ɔ gla palɩ, 'ɩn tɔlʋa nɛɛ: «'Ylɩ -putu nya, 'bhie, -a 'ka -mɩ yukwli pʋlʋ, wee gbʋ -mɩnɩɩ 'gbʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","'Ɩn Pɔlʋ yia wa glaa 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nyɩma -tɔlʋa -wa ŋwnua -Lagɔgbʋ -yɔ, 'ɩn -maa yia Pɔlʋ 'bɩ mnɩ. Wa glaa Atɛnɩɩ gbʋwʋbhunyaa lʋnyɩmɛ yabhlo wa laa Denisɩ klaa, 'ŋwnɔ yabhlo wa laa Damalisɩ, we -yɔ nyɩma tɔlʋa, ma -wa. ");
INSERT INTO kyf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","-Mʋʋ 'bɩgʋ, Pɔlʋ 'bhʋa Atɛnɩ, 'ɩn ɔ yia Kolɛntɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Zuifʋ yabhlo wa laa Akilasɩ, wa gwalɩa Pɔɔn -dʋdʋ -gʋ, 'ɩn ɔ yia -mɔ ɔ ylɩ, -zugba ɔ -yɔ ɔ 'ŋwnɔ Plisilɩ ka Italii -dʋdʋ -gʋ 'bhʋ 'lulolu. -We ka gbʋ -wa, nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ Klodʋ nɛɛ, Zuifʋ 'bhʋ Wlɔmʋgbe nʋkplɛ. 'Ɩn Pɔlʋ yia wa -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nɩɩ, wa nʋnʋ -lubhoo 'yli -bhlo, *'naabuduu 'naa wa lʋa, we 'gbʋ, ɔ yia wa -gbɛ ladɩlɩa mnɩ, -zugba wa nʋa lubho dabʋdʋ. ");
INSERT INTO kyf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sa *Nyapɛylɩ nynia -bhlo, 'sa Pɔlʋ bhua wɛlɩ 'wʋ -Lagɔbudu zɔ, 'ɩn ɔ gbaa, ɔ yɩa 'klɩ, ɔ 'ka Zuifʋ -yɔ Glɛkɩ lu. ");
INSERT INTO kyf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Da Silasɩ -yɔ Timotee 'bhʋa Masedʋanɩ, Pɔlʋ yia bhla weee nya -Lagɔgbʋ gbada -tʋ, -zugba ɔ gba Zuifʋnya -yla, nɩɩ, -Zezu -wa -Lagɔɔ -Bhasanyɔ. ");
INSERT INTO kyf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","'Ɩn Zuifʋ yia Pɔlʋ -yɔwʋsɔlʋ, -zugba wa vɛlɩ ɔ. 'Ɩn ɔ yia ɔ -bana 'wʋvu wa -gʋ , ɔ nɛɛ wa -ylaɛ: «A -ka mnɔ, amɩaa 'dɛɛ 'bɩgʋ -wa, we 'nɩ na gbʋ. Nɩɩ, we 'bhʋ -zɛɛn 'wʋ, -wa 'nɩa Zuifʋ, wa -gbɛ na yia mnɩa.» ");
INSERT INTO kyf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔlʋ 'tlaa -Lagɔbudu zɔ, 'ɩn nyɩmɛ yabhlo wa laa Titiusɩ Zutusɩ -ɔ bʋbɔa -Lagɔ, 'ɩn -ɔ ka -budu mɩa -Lagɔbudu kwesi, 'ɩn ɔ yia -mɔɔ -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","-Lagɔbuduu 'yugalɩnyɔ Klisɩpusɩ zʋa Nyɩmaa -Kanyɔ dlɩ -gʋ, we -yɔ ɔ zʋaylinyɩma. Kolɛntɩ -nyɩmaa -zlo -wa pʋlʋa Pɔlʋʋ wɛlɩ yukwli, 'ɩn -maa yi 'yaa -Lagɔ dlɩ -gʋ zʋ, 'ɩn wa yia wa batizee. ");
INSERT INTO kyf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sabɔ yabhlo nya, Nyɩmaa -Kanyɔ 'tlalɩa Pɔlʋ 'klʋ ɔ 'yli 'wʋ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn 'na nʋnʋ nyanɔ -nɩ, -ɩn -tʋ gbada. -Ɩn 'na 'munu ŋwɛ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nɩɩ, ɩn -yɔ -mɩ 'sɔ mɩ. Nyɩmɛ yabhlogbɔɔ 'na 'ka -mɩ kwɛzɩ, 'ɩn ɔ 'na 'ka -mɩ -yla gbʋnyuu lɛnʋ. -We ka gbʋ -wa, gbe nɩ nʋkplɛ, -wa mɩa na -nʋ nya wa -zu 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔlʋ li Kolɛntɩ -zʋ -bhlo 'cʋ gbelibhlo, -zugba ɔ slolu -mɔ nyɩma -Lagɔwɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bhla -we nya Wlɔmʋ -nyɩmɛ Galiɔɔn pɩlɩa Akai 'wlu la, 'ɩn Zuifʋnya yia Pɔlʋ -yɔ gwe 'pa, 'ɩn wa -yɔ ɔ yia gbʋwʋbhu -zejila 'yu mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","'Ɩn wa nɛɛ: «Ɔɔ nyɩmɛ -mɔnɩ, sa -amɩaa tite 'nɩa gba, 'sa ɔ gbaa nyɩma bʋbɔ -Lagɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔlʋ 'ka ŋwɛ gbaa yi, 'ɩn Galiɔɔn nɛɛ Zuifʋ -ylaɛ: «We -ka nɩɩ, ɔɔ nyɩmɛ ka tite mnɔ, 'ɩn ɔ yi gbʋ 'kadʋ -nyumɔ, -zugba ɩn ka yaa dlɩ lapalɩ, 'ɩn ɩn ka amɩa Zuifʋ yukwli pʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","-We ka gbʋ -wa, wɛlɩ klaa, 'ŋnɩ klaa, we -yɔ amɩaa 'dɛɛ tite -gʋ a mɩa kpɛlɩlɩdaa 'gbʋ, amɩaa 'dɛɛ gbʋ mʋ. Ɩn 'nɩ 'yɩbha ɩn 'ka sanɛɛ -sʋkpa gbʋwʋbhunyɔ -zɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","'Ɩn Galiɔɔn yia wa vu gbʋwʋbhu -zejila 'yu. ");
INSERT INTO kyf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tɔʋn, Zuifʋ weee kpaa -Lagɔbuduu 'yugalɩnyɔ Sɔsɩtɛnɩ, 'ɩn wa yia ɔ bhɩtɩ -bha gbʋwʋbhu -zejila 'yu. 'Ɩn Galiɔɔn 'nɩ we 'yabhlogbɔɔ -gʋsa. ");
INSERT INTO kyf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔlʋ ka 'ya Kolɛntɩ -gwlɛ kplokplo. 'Bhie, ɔ yia -Lagɔbhelia wɛlɩ 'pa, 'ɩn ɔ yia 'glʋ 'wʋ -gblaa, ɔ yia Silii -dʋdʋ -gʋ mnɩ, ɔ -yɔ Plisilɩ -yɔ Akilasɩ 'sɔ. Da wa 'kaa 'glʋ 'wʋ -gbla, 'ɩn ɔ yia ɔ 'nyi kpla Sankleegbe nʋkplɛ. -We ka gbʋ -wa, ɔ ka -Lagɔ -yla bi. ");
INSERT INTO kyf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wa nynia Efɛzɩ, -bha Pɔlʋ tɩa Plisilɩ -yɔ Akilasɩ. 'Ɩn ɔ yia -Lagɔbudu zɔ mnɩ, 'ɩn ɔ -yɔ Zuifʋ yia kpɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","'Ɩn -maa nɛɛ ɔ -yla, ɔ -tʋ wa -gbɛ -slɔ, ɔ 'nɩ we -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ɔ 'paa wa wɛlɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «-Lagɔ -ka ŋwnu, 'ɩn na yia amɩaa -gbɛ lʋ.» 'Ɩn ɔ yia 'glʋ 'wʋ -gbla Efɛzɩ, ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","-Mʋʋ 'bɩgʋ, ɔ nynia Sezalee, 'ɩn ɔ yia -Lagɔnyɩma fʋsaa mnɩ -Zeluzalɛmʋ. 'Bhie, ɔ yia Antiɔsʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɔ lia -bha 'ylɩ sanɩmɛ Antiɔsʋ, 'bhie, ɔ yia lʋmnɩ. Ɔ 'plɩlɩa -Galasii -yɔ Flizii -dʋdʋ -gʋ -bhlo -bhlo, -zugba ɔ pa -Zezuu 'bɩnɔnya weee 'kʋayli. ");
INSERT INTO kyf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zuifʋ -ɔ wa gwalɩa Alɛzandli, wa laa Apolɔsʋ, yia Efɛzɩ yi. Gbagbanyɔ -zɔnʋ -wa, 'ɩn ɔ -yia -Lagɔsɛbhɛ 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nyɩmaa -Kanyɔɔ 'Yloogblʋ wa -slolua zlɩmɛ ɔ, -slɛɛn dlɩ weee nya ɔ gbaa, 'ɩn ɔ slolua -Zezuu gbʋ kpɛɛn kpɛɛn. 'Ɩn Zaaan nyɩmaa batizee -gbʋ -bhlo ɔ -yia. ");
INSERT INTO kyf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","'Ɩn Apolɔsʋ yia -Lagɔgbʋʋ gbagbɩe bhli dlɩ tɛlɔ nya, Zuifʋʋ -Lagɔbudu zɔ. Da Plisilɩ -yɔ Akilasɩ pʋlʋa ɔ yukwli, wa yia ɔ 'wʋbhu, wa -yɔ ɔ 'sɔ yia wa 'dɛɛ -gbɛ mnɩ. 'Ɩn wa yia ɔ -Lagɔɔ 'Yloogblʋ -slolu kpɛɛn kpɛɛn. ");
INSERT INTO kyf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","-Mʋʋ 'bɩgʋ, Apolɔsʋ 'yɩbha ɔ 'ka Akai mnɩ. 'Ɩn -Lagɔbhelia yia ɔ 'kʋayli 'pa, 'ɩn -maa yia wee dʋdʋ -mʋʋ -gʋ -Lagɔnyɩma 'sɛbhɛ yoo 'pa nɩɩ, wa kpa ɔ 'nanʋʋ wa 'lakpa yu nya. Da ɔ nynia -mɔ, -wa plaa -Lagɔ, -Lagɔɔ 'nanɩ nya, 'ɩn ɔ yia wa 'wʋsa bhabha. ");
INSERT INTO kyf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ɔ ka -Lagɔsɛbhɛ zɛlɩ Zuifʋ -yla, 'ɩn ɔ yia wa -slolu tɩklɩɩ nɩɩ, -Zezu mɩ -Lagɔɔ -Bhasanyɔ nya, 'ɩn ɔ 'nɩ Zuifʋʋ wɛlɩ -yɔŋwnu, ɔ yia wa lu -zejila 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Bhla -we nya Apolɔsʋ mɩa Kolɛntɩ, 'ɩn Pɔlʋ yia -Aziii -gɔgɔ -ka -dʋdʋʋ yalɩ -gbɛɩn 'plɩlɩ, 'ɩn ɔ yia Efɛzɩ nyni. 'Ɩn ɔ yia -mɔ -Zezuu 'bɩnɔnya tɔlʋa ylɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","'Ɩn ɔ yia wa layɩbhaɛ: «Da a zʋa dlɩ -Zezu -gʋ, Zuzu 'Pʋpa ka aɩn -gʋ kwlilii?» 'Ɩn wa yia we 'bɩgʋpalɩ ɔ -ylaɛ: «-A 'nɩ -slɔ 'nʋ nɩɩ, Zuzu 'Pʋpa mɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","'Ɩn Pɔlʋ yia wa layɩbhaɛ: «-Zugba, sa wa batizee aɩan?» 'Ɩn wa yia we 'bɩgʋpalɩ: «Zaaan nyɩmɛɛ batizee batizee sɔlʋ wa batizea -aɩn.» ");
INSERT INTO kyf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔlʋ nɛɛ wa -ylaɛ: «Nyɩma -wa ŋwnua wa dlɩ 'bhitigbʋ, 'ma *Zaan batizea. 'Ɩn ɔ nɛɛ wa -ylaɛ: ‹Nyɩmɛ -ɔ yia 'mɩ lʋʋ yia, a zʋ ɔ dlɩ -gʋ, mɔ -wa -Zezu.› » ");
INSERT INTO kyf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Da waa Efɛzɩ -nyɩma 'nʋa wɛlɩ -mɩnɩ, 'ɩn wa yia wa 'dɛ wla, wa batizee wa Nyɩmaa -Kanyɔ -Zezuu 'ŋnɩ nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔlʋ palɩa wa sɔ -gʋ la, 'ɩn Zuzu 'Pʋpa yia wa -gʋ kwlili. 'Ɩn wa yia wɛlɩ -putunyaa gbagbɩe bhli, -zugba wa paa -Lagɔgbʋʋ -falɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wa 'dɛ weee mneni wa 'ka sa nyɩma kugbua lɛ 'sɔ ŋwɛɛ nyni. ");
INSERT INTO kyf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","-Mʋʋ 'bɩgʋ, Pɔlʋ plaa -Lagɔbudu zɔ, 'ɩn ɔ yia -Lagɔgbʋ gbada -tʋ 'cʋ ta nʋkplɛ dlɩ tɛlɔ nya, -zugba ɔ gba -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ, 'ɩn ɔ yɩ 'klɩ, -wa mɩa ɔ yukwli pʋlʋda ɔ 'ka wa lu. ");
INSERT INTO kyf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","'Ɩn duun yia yukwli -yɔsumanɩ, -maa 'nɩ -Lagɔgbʋ -yɔŋwnu, 'ɩn wa yia -Zezuu 'Yloogblʋ gla palɩ -zejila 'wʋ. 'Ɩn Pɔlʋ yia wa -yɔ 'bhʋ, ɔ -yɔ -Zezuu 'bɩnɔnya yia mnɩ, -zugba ɔ slolu wa -Lagɔgbʋ 'kɔmʋʋ, Tilanusɩɩ lakɔnɩ -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","'Sa ɔ -tʋa nʋda -zʋ 'sɔ nʋkplɛ. 'Ɩn Zuifʋ -yɔ Glɛkɩ sɔ mɩa -Azii -dʋdʋ -gʋ, -maa yia Nyɩmaa -Kanyɔɔ gbʋ 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","'Ɩn -Lagɔ yia gwɛdigbʋ 'kadɩ 'kadɩ lɛnʋ, Pɔlʋʋ sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","'Ɩn 'klʋɔ -sɛlɩ -mislɔ -yɔ 'naa -kibhenya bhlɩa ɔ ku ŋwɛ, 'mʋ wa kwaa guzʋnya. 'Ɩn -maa gu yia -maa -yɔ 'bhʋ, zuzu 'nyii -we -dɩlɩa wa 'wʋ la, 'ɩn we yia wa 'wʋ 'tla. ");
INSERT INTO kyf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Zuifʋ tɔlʋa -wa jɩjlɩa 'gbe, zuzu 'nyii vuvue nya guzʋnya 'wʋ, -maa yi 'yaa Nyɩmaa -Kanyɔ -Zezuu 'ŋnɩ laylalɩ, we vuvue nya. 'Ɩn wa nɛɛ zuzu 'nyii -yla: «-Zezu ka gbʋ Pɔlʋ gbaa da, -a nɛɛ, ɔ 'ŋnɩ nya a 'tla wa 'wʋ!» ");
INSERT INTO kyf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Zuifʋʋ -Lagɔbʋbɔnyaa -kanyɔ mɩ -bha, 'mɔ wa laa Sevaa. Ɔ ka nʋkpasuyua gbesɔ, ma nʋ 'saa. ");
INSERT INTO kyf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","'Ɩn zuzu 'nyuu yia we 'bɩgʋpalɩ wa -yla: «Ɩn -yi -Zezu, 'ɩn -ɔ Pɔlʋ -mɩa, ɩn -yi -mɔɔ. 'Ɩn amɩa naa, nyɔɔ amɩa -mɩa?» ");
INSERT INTO kyf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nyɩmɛ kaa zuzu 'nyuu 'wʋ, -mɔɔ yia wa -gʋbho. 'Ɩn ɔ yia we -slolu nɩɩ, ɔ 'tɛla, ɔ -zi wa. Ɔ nʋa wa lɛ, 'ɩn ɔ yia wa -bana yla, 'ɩn wa -yɔ gwagwɩe yia ɔ -budu zɔ 'tla kpanʋ nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Zuifʋ -yɔ Glɛkɩ mɩa Efɛzɩ 'nʋa gbʋ -mɩnɩ, 'ɩn nyanɔ yia wa 'wʋslo. 'Ɩn wa yia Nyɩmaa -Kanyɔ -Zezuu 'ŋnɩ 'ylimanɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nyɩma -duun -wa ŋwnua -Lagɔgbʋ -yɔ, 'ɩn wa yia wa gbʋnyuu gbaa yi 'tɩtɛɛ nyɩma -zejila 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","-Dlabhia -lɛnʋnya duun -yɔ wa 'sɛbhɛɛ -zlo yia yi, 'ɩn wa yia we -sie nyɩma weee 'yu. Wa zɛlɩa we -valɛ we nyni 'gwɛzii 'wlu glʋ ta 'wlu kugbua lɛ gbu . ");
INSERT INTO kyf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","'Sa -Lagɔgbʋ mnenia la, 'ɩn we yia -gʋwʋlaylimanɩ, Jejitapɛɛ 'tɩtɛ slolue nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gbʋnya -mɩnɩɩ 'bɩgʋ, Pɔlʋ nɛɛ Masedʋanɩ -yɔ Akai ɔ plɩlɩa ɔ 'ka -Zeluzalɛmʋ mnɩ. Ɔ nɛɛ: «-Mʋʋ 'bɩgʋ, ɩn -ka -mɔ nyni, we mɩ nɩɩ, ɩn mnɩ 'ya *Wlɔmʋ 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Timotee -yɔ Elasɩtɩ -wa -wa ɔ 'wʋsanya, 'ɩn ɔ yia -maa sɔbhie tie Masedʋanɩ, 'ɩn ɔ 'dɛ yia -Azii -tʋ 'ylɩ yasɔlɛ nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","-Mʋʋ bhla, 'ɩn gbʋ 'kadʋ yia bhli -Zezuu 'Yloogblʋʋ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nyɩmɛ yabhlo wa laa Demetliusʋ, 'gwɛzi nya ɔ bhlaa -lu yua -sɛsɛ. Nyɩmaa -lagɔ wa laa Atemisɩ we -buduu 'wʋwlʋ -yua -sɛsɛ ɔ bhlaa. Mʋ -yɔ, ɔ -yɔ ɔ lubhonʋnya yɩa 'gwɛzi duun. ");
INSERT INTO kyf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","'Ylɩ yabhlo nya, Demetliusʋ gbelia ɔ lubhonʋnya -yɔ -wa -yɔ ɔ kaa lubhoo 'yli -bhlo 'wlu, 'ɩn ɔ nɛɛ wa -ylaɛ: «'Taleaɩn, amɩaa 'dɛ -yi we 'ji nɩɩ, 'mʋ lubho nɩ -yɔ -a yɩlɩa -amɩanʋʋ 'gwɛzi. ");
INSERT INTO kyf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","-We mɩa 'plɩda, a yɩ we -yɔ, 'ɩn a nʋ we. Ɔɔ Pɔlʋ nɛɛ nɩɩ, -lagɔ -we nyɩma tɛlɩa, we 'nɩ -lagɔ -zɔnʋnya. Ɔ ka nyɩma duuun 'wlu -nyumɔ. We 'nɩ -seli Efɛzɩ -bhlo, we -tʋ 'wʋ -sɛ, we 'ka -Azii -dʋdʋ weee -gʋ lamneni. ");
INSERT INTO kyf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","-Mʋʋ mneni we 'ka -amɩaa lubho -nyumɔ, 'ɩn we 'ka Atemisɩ 'kadʋʋ -budu -yɔ we 'ŋnɩ lasa. 'Ɩn nyɩma 'na 'ka -slɛɛn we 'ylimanɩ. 'Ɩn 'mʋ wa bʋbɔa -Azii -yɔ -dʋdʋ weee -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Da nyɩma 'nʋa wee gbʋ -mɩnɩ, wa 'paa 'cɛ, 'ɩn wa yia 'wʋkpɩkpɩe bhli: «Efɛzɩ -nyɩmaa Atemisɩ 'ylia! » ");
INSERT INTO kyf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","'Ɩn 'gbe -kpabhie yia gbugblolu. 'Ɩn Masedʋanɩ -nyɩma 'sɔ wa laa Gayusɩ -yɔ Alisɩtakɩ, -wa -wa Pɔlʋʋ nɔnɔnya, 'ɩn wa yia -maa kpa, 'ɩn wa -yɔ wa 'sɔ yia -gblɔgblʋ 'wʋ mnɩ gwagwɩe nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔlʋ 'yɩbha ɔ 'ka wa nyɩdɩ 'tla -zejila 'wʋ, 'ɩn -Zezuu 'bɩnɔnya nɛɛ ɔ -yla, ɔ 'na nʋnʋ we lɛ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","-Aziii lubhonʋnya 'kadɩ -tɔlʋa -wa mɩa Pɔlʋʋ 'talea nya, -maa yi 'yaa wee wɛlɩ -bhlokpadɛ ɔ yoo 'pa, nɩɩ, ɔ 'na 'sibhli wee -zejila 'wʋ la -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","-Mʋʋ bhla, nyɩma yiyli -gʋ, -zugba gbʋ bidi -bidi bidi wa nʋa lɛ. Nyɩma tɔlʋa kpɩ 'wʋ wɛlɩ yabhlo nya, 'ɩn tɔlʋa kpɩa 'wʋ 'ya wɛlɩ -putu nya. 'Ɩn -we ka 'gbʋ wa yia 'wlugbeli, wa glaa -nyɩma duun 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","We bhla Zuifʋ yabhlo wa laa Alɛzandlɩ mɩ -bha. 'Ɩn nyɩma tɔlʋa yia we 'ji gba ɔ -yla, -zugba Zuifʋ tɔlʋa sua ɔ, ɔ 'ka gba. 'Ɩn Alɛzandlɩ yia sɔ 'wʋbhu, ɔ 'yɩbha ɔ 'ka waa nyɩmaa -zlo -yla gbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wa yibhelia ɔ Zuifʋ nya, 'ɩn wa 'dɛ weee yia 'wʋkpɩda -tʋ wɛlɩ -bhlogbɔɔ nya 'lɛlɩ 'sɔ nʋkplɛɛ: «Efɛzɩ -nyɩmaa Atemisɩ 'ylia! Atemisɩ 'ylia!» ");
INSERT INTO kyf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","'Ɩn wee 'gbee fɛngblɛ yia nyɩma weee ŋwɛ 'munu. 'Ɩn ɔ nɛɛ: «Efɛzɩ -nyɩma, nyɩma weee -yi we 'ji nɩɩ, Efɛzɩ -gbe -wa Atemisɩɩ bʋbɔ -budu 'kadʋ -yɔ we tɛlɩtɛlɩ -tʋkpa, -we 'bhʋa yalɩɩ ŋwɛkʋnyɔ. ");
INSERT INTO kyf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka gbʋ -mɩnɩ kpɛlɩ. We 'gbʋ, a 'mu ŋwɛ, a 'na slolu gbʋ lʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","'Ɩn nyɩma -wa a -laa -seli, wa 'nɩ we -budu zɔ -lu yabhlogbɔɔ yli, 'ɩn wa 'nɩ -amɩaa -Lagɔ vɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","We -ka Demetliusʋ -yɔ ɔ lubhonʋnya 'yɩbha wa 'ka nyɩmɛ 'klamanɩ, wa mnɩ gbʋwʋbhunya 'yu, gbʋwʋbhu ylɩ nya. Mɔ wa 'kaa nyɩmɛ 'klamanɩ -mɔ mɩa dɛ. ");
INSERT INTO kyf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","We -ka nɩɩ, a ka 'ya gbʋ yabhlo, a 'ka we layɩbha, -a mneni -a 'ka -mʋʋ gba -a 'dɛ weee 'wlugbeliylɩ nya. ");
INSERT INTO kyf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","-A fɛlɩ -amɩaa 'dɛ gbʋ 'nyɛa, 'ɩn wa 'ka -aɩn gbʋ 'wludɩ, nɩɩ, -amɩa sɔlʋa -amɩaa 'wlulapɩlɩnya -yɔ 'wʋ, gbʋ -we 'plɩa -zɛɛn daa 'gbʋ. Wee 'wlugbelie -mɩnɩ 'nɩ 'ji tɩklɩɩ -ka, 'ɩn gbʋ -we -a 'kaa gba, -mʋʋ 'nɩ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Da ɔɔ fɛngblɛ gba 'saa, 'ɩn ɔ nɛɛ nyɩma -yla, wa mnɩ wa -buduŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Da -zlɛ bhɩa, -mʋʋ 'bɩgʋ, Pɔlʋ yia -Zezuu 'bɩnɔnya 'wlugbeli. Ɔ zʋa wa 'dɩ, 'bhie, ɔ yia wɛlɩ 'pa, 'ɩn ɔ yia Masedʋanɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɔ 'plɩlɩa wee dʋdʋ -mɩnɩ -gʋ, 'ɩn ɔ yia -Lagɔnyɩma 'dɩ duun zʋ. -Mʋʋ 'bɩgʋ, ɔ yia *Glɛsɩ nyni, ");
INSERT INTO kyf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","'ɩn ɔ li -mɔ Glɛsɩ -dʋdʋ -gʋ 'cʋ ta. Da ɔ mɩa 'glʋ 'wʋ -gblada, ɔ 'ka Silii mnɩ, 'ɩn ɔ yia 'nʋ nɩɩ, Zuifʋ mɩ ɔ -yɔgbʋ zʋda, wa 'ka ɔ 'bha. Tɔʋn, ɔ yia ɔ 'dɛɛ dlɩ zɔ lapʋpalɩ nɩɩ, ɔ 'ka Masedʋanɩ -dʋdʋ -gʋ lʋbhiti. ");
INSERT INTO kyf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","-Wa -yɔ Pɔlʋ mnɩa, wa ŋnɩ nɩ: Belee -nyɩmɛ Pilusɩɩ 'yu Sopatɛɛ, Tɛsalonikɩ -nyɩma Alisɩtakɩ -yɔ Sekɔndusɩ, Dɛlɩbʋ -nyɩmɛ Gayusɩ, 'ɩn Timotee, we -yɔ 'ya -Azii -dʋdʋ -gʋ -nyɩma Tisikɩ -yɔ Tlofimʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nyɩma -manɩ -galɩa -aɩn 'yu, 'ɩn wa yia -aɩn wʋ Tloasɩgbe nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","*'Floo -we 'nɩa gɔɔ -yɔ -ka, we 'fɛtɩ 'plɩa, 'ɩn -amɩa yia Filipʋgbe nʋkplɛ 'glʋ 'wʋ -gbla. -A li 'nyu 'klʋɔ 'ylɩ gbu, 'ɩn -a yia wa -gbɛ nyni Tloasɩ, -a li -mɔ lɔkɔwlu -bhlo. ");
INSERT INTO kyf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Samidii jibheza, -a gbelia 'wlu, -a 'ka 'floo ladɩdlɩ dabʋdʋ, 'ɩn Pɔlʋ yia gbʋ -gbagbɩe bhli -Lagɔnyɩma -yla. 'Ɩn zlɩ -ka zlɩ mnɩa ɔ yiaa 'gbʋ, 'ɩn ɔ yia gbada -tʋ tɩklɩɩ, 'ɩn zlɩ -gʋ yia bɛ. ");
INSERT INTO kyf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","-Buduu yu mɩa yalɩ, -we zɔ -a gbelia 'wlu, 'napɛɛ -zlo mɩ -mɔ -nyumada. ");
INSERT INTO kyf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nyimeslɔyu wa laa Etikɩ -dɩa fɩnɛtlɩɩ ŋwɛ -gʋ la. Pɔlʋ ka gbagbɩe latlʋmanɩɩ 'gbʋ, Etikɩ yia 'ylaa ŋwɔ. Ɔ zilia 'ylaa 'wʋ, 'ɩn ɔ yia 'tazɩ tanʋʋ fɩnɛtlɩ 'yli 'bhʋ, 'ɩn ɔ yia bhli. Wa 'ka ɔ 'wʋbhu, -zugba ɔ ka tlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔlʋ 'sibhlia la, ɔ kwlia ɔ -gʋ 'wʋ, 'ɩn ɔ yia ɔ 'wʋbhu, ɔ nɛɛ: «Amɩaa dlɩ 'na sumanɩ -nɩ, ɔ -ga 'yliyɔ!» ");
INSERT INTO kyf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","-Mʋʋ 'bɩgʋ, Pɔlʋ -gblaa 'tazɩ 'wlu, ɔ dɩdlɩa 'floo la, 'ɩn ɔ yia we li. Ɔ gba 'yaa kplokplo, zlɩ dolua 'wʋla, 'ɩn ɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","'Ɩn wa -yɔ ɔɔ nyimeslɔyu yia mnɩ, -zugba ɔ -ga 'yliyɔ, we yia wa 'dɛ weee dlɩ lapalɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","-A -gaa 'yu, -a yia 'glʋ 'wʋ -gbla, 'ɩn -a yia Asɔsʋ mnɩ. -Mɔ -a 'kaa Pɔlʋ 'wʋbhu, -we ka gbʋ -wa, ɔ nɛɛ ɔ 'ka -mɔ mnɩ bhʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pɔlʋ ylɩa -aɩn Asɔsʋ, 'ɩn -a yia ɔ 'wʋbhu 'glʋ 'wʋ, 'ɩn -a -yɔ ɔ 'sɔ yia Mitilɛnɩ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","-Bha -a -gblaa 'glʋ 'wʋ, 'ɩn -a yia lʋbhiti gumunyu -gʋ. -Mʋʋ zlɩ zlɩa, 'ɩn -a yia Kio 'klʋ nyni. -Mʋʋ 'bɩgʋ zlɩ zlɩ 'yaa, 'ɩn -a yia Samɔsʋ nyni, -mʋʋ 'bɩgʋ zlɩ zlɩa, 'ɩn -a yia Milee nyni. ");
INSERT INTO kyf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nɩɩ, Pɔlʋ nɛɛ, Efɛzɩ ɔ plɩlɩa, ɔ 'nɩa -bha 'yligbea yi, ɔ yi bhla lanyumɔnʋ -Azii -dʋdʋ -gʋ. Ɔ 'yɩbha ɔ 'ka *Pantɩkɔtʋʋ 'ylɩ nya -Zeluzalɛmʋ -mɩ, sao sa we -ka -mɩ. We 'gbʋ, ɔ yia kwɛlapulo. ");
INSERT INTO kyf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔlʋ mɩ Milee, 'ɩn ɔ yia nyɩma Efɛzɩ tie nɩɩ, wa 'ka *leglizɩɩ nyɩma kpasɩ laa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Da wa nynia Pɔlʋ kwesi, ɔ nɛɛ wa -ylaɛ: «Na tɩanʋ nynia -Azii -dʋdʋ -gʋ, sa ɩn -yɔ aɩn 'sɔ -dɩa la, amɩaa 'dɛ -yi we. ");
INSERT INTO kyf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ɩn ka Nyɩmaa -Kanyɔɔ lubho nʋ na 'dɛɛ 'wʋtɩtɩe nya 'kienyi, sɩasɩe -yɔ 'mɩɔ nya 'yliya 'wʋ, na -yɔgbʋ Zuifʋ zʋaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Amɩaa 'dɛ -yi we 'ji nɩɩ, ɩn 'nɩ gbʋ yabhlogbɔɔ aɩn -yɔ zizeli. -We weee 'kaa aɩn 'wʋsa, ɩn ka we aɩn -yla gba, 'ɩn ɩn ka we aɩn -slolu -zejila 'wʋ we -yɔ amɩaa -budu zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ɩn ka Zuifʋ -yɔ -wa 'nɩa Zuifʋ la, wa 'ka wa dlɩ 'bhiti -Lagɔ 'yu, 'ɩn wa 'ka -amɩaa -Kanyɔ -Zezu dlɩ -gʋ zʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«'Ɩn -slɛɛn, -Zeluzalɛmʋ na mnɩa. -Lagɔɔ Zuzu gbaa, ɩn nʋ 'sa -gla nya. -We 'kaa -mɔ 'mɩ ylɩ, ɩn 'nɩ we -yi. ");
INSERT INTO kyf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nɩɩ, -we ka 'ji ɩn -yia -bhlogbɔɔ, 'gbe -bhlo -bhlo 'wʋ, Zuzu 'Pʋpa ka 'mɩ 'tʋlʋ nɩɩ, -kaslʋ -yɔ sɩasɩe mɩ 'mɩ wʋda. ");
INSERT INTO kyf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ɩn 'ka tlɩoo, ɩn 'ka 'pʋoo, -mʋʋ 'nɩ 'mɩ dlɩɩ gbʋ yabhlogbɔɔ. -We -wa 'mɩ dlɩɩ gbʋ, mʋ -wa nɩɩ, lubho -we Nyɩmaa -Kanyɔ -Zezu tɩa 'mɩ -yɔ, ɩn nʋ we, ɩn 'ka we bhɩa. Wee lubho mɩa, -Lagɔɔ 'nanɩɩ gbʋzɔnʋ gbʋʋ gbagbɩe -wa. ");
INSERT INTO kyf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ɩn ka -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋʋ gbagbɩe nya aɩn glaa 'plɩlɩ. 'Ɩn -slɛɛn, ɩn -yi we 'ji nɩɩ, amɩaa 'yabhlogbɔɔ 'na 'ka 'maslɛɛn na 'klʋ 'yɩ. ");
INSERT INTO kyf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","We 'gbʋ, ɩn nɛɛ aɩn -yla -zɛɛn ɛ: amɩaa 'yabhlo -ka mnɔ, we 'nɩ na 'wlu -gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nɩɩ, ɩn ka -Lagɔɔ dʋmagbʋ weee aɩn -yla gba. Ɩn 'nɩ we 'yabhlogbɔɔ aɩn -yɔ zizeli. ");
INSERT INTO kyf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","A zʋ amɩaa 'dɛ 'yliyɔ, 'ɩn a zʋ leglizɩ weee 'yliyɔ. Wa 'wlʋ sa bhlabhlɛnya, -wa Zuzu 'Pʋpa 'nyɛ aɩn yoo, a 'ka wa 'yliyɔzʋnya -zɛ. -Lagɔ ka wa 'wʋzɩtɩ ɔ 'Yuu 'pɩɔn nya, wa 'ka ɔ -nʋ -zɛ. ");
INSERT INTO kyf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na mnɩmnɩee 'bɩgʋ, gɔbhɛɛ -bho -nyɩma yia aɩn glaa plaa, 'ɩn wa 'ka wee bhlabhlɛnya gbʋnyuu -yla lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","'Ɩn 'dɛbhie aɩn nyɩdɩ, nyɩma -tɔlʋa yia yotʋbhʋa, 'ɩn -Zezuu 'bɩnɔnya 'ka wa 'bɩbholu. ");
INSERT INTO kyf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","A -tʋ 'yliyɔgada, 'ɩn a ligbe we nɩɩ, ɩn ka aɩn 'dɩzʋda -tʋ zlʋkpɛ -yɔ jibheza, -zʋ ta 'wʋ, 'mɩɔ nya 'yli. ");
INSERT INTO kyf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«'Ɩn -slɛɛn, -Lagɔ -yɔ ɔ 'nanɩwɛlɩ kwɛɛ na zʋa aɩn. 'Ɩn ɔ ka we se, ɔ 'ka aɩn 'ylimanɩ dlɩzʋzʋe 'wʋ, 'ɩn 'bɩ -we ɔ zʋa la, -wa weee mɩa ɔ -nʋ nya -yla, ɔ 'ka we aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Na dlɩ 'nɩ nyɩmɛ yabhlogbɔɔɔ 'gwɛzi, ɔ -can -yɔ ɔ 'naanya 'wʋnyni. ");
INSERT INTO kyf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Amɩaa 'dɛ -yi we 'ji nɩɩ, -li -we ka 'tʋ mɩa ɩn -yɔ na nɔnɔnya -yɔ, na 'dɛɛ sɔɔ lubho nya na yɩa we. ");
INSERT INTO kyf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Sa a 'kaa lubho nʋ, 'ɩn a 'ka bobabhanya 'wʋyi, ɩn ka we aɩn -slolu. 'Ɩn -a 'ka wɛlɩ -we Nyɩmaa -Kanyɔ -Zezuu 'dɛ gbaa ligbe: ‹Nyɩmɛ -lu -nyɛnyɩɛ ka 'mʋna, we -zi -lu 'yɩyɩe nyɩmɛ kwɛɛ.› » ");
INSERT INTO kyf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔlʋ bhɩa gbagbɩe, -mʋʋ 'bɩgʋ, ɔ -yɔ wa 'dɛ weee 'sibhlia 'kukolu, 'ɩn wa yia -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wa 'dɛ weee bhlia wie, wa gblelia Pɔlʋ, 'ɩn wa yia ɔ wɛlɩ 'pa. ");
INSERT INTO kyf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","'Ɩn wa -gʋ yia 'wʋtʋ -kɔʋn, -we ka gbʋ -wa, ɔ nɛɛ wa -yla wa -putu 'na 'ka 'maslɛɛn ɔ 'klʋ 'yɩ. Wa kwaa ɔ yoo, 'ɩn wa yia ɔ 'glʋ -yɔ -nyneni -kpɔ. ");
INSERT INTO kyf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","-A 'bhʋa Efɛzɩɩ -Lagɔnyɩma kpasɩɩ -gbɛ, -a -gblaa 'glʋ 'wʋ, 'ɩn -a yia 'nyunyɩdɩdʋdʋ wa laa Kɔsʋ -gʋ mnɩ tɩklɩɩ. -Mʋʋ zlɩ zlɩa, -a nynia Wlodʋ, 'bhie, -a yia Patalaa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","'Glʋ yabhlo mɩa Fenisi dʋdʋ -gʋ mnɩda, -mɔ -a ylɩa we. Tɔʋn, -a -gbla we 'wʋ, 'ɩn -a yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","-A nynia gumunyuu nyɩdɩ, 'ɩn -a yia 'nyunyɩdɩdʋdʋ wa laa Siplʋ -yɔyɩ kɔpɛsɔlʋ. -A mnɩa Silii -dʋdʋ -gʋ -gbɛɩn, 'ɩn -a yia Tilɩgbe nʋkplɛ lasibhli, -bha 'glʋ 'kaa we nʋkpla -gba weee lasibhli. ");
INSERT INTO kyf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","-Mɔ Tilɩ -a ylɩa -Zezuu 'bɩnɔnya, 'ɩn -a yia wa -gbɛ -tʋ lɔkɔwlu -bhlo. Gbʋ -we 'kaa Pɔlʋ ylɩ, -Lagɔɔ Zuzu gbaa we wa -yla, 'ɩn wa nɛɛ ɔ -yla, ɔ 'na mnɩnɩ -Zeluzalɛmʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Da wee lɔkɔwlu -bhlo bhɩa, 'ɩn -a yia 'yoo 'wʋbhu, wa 'dɛ weee yia -aɩn yoo kwa. Wa -yɔ wa 'ŋwnɩ -yɔ wa 'yua, 'ɩn -a yia 'gbe nʋkplɛ 'tla, 'bhie, -a yia 'kukolu 'sibhli gumunyuu -gɔgɔ -gʋ, 'ɩn -a yia -Lagɔ bhubhoe. ");
INSERT INTO kyf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","-Mʋʋ 'bɩgʋ, -a 'pʋpalɩa wɛlɩ, 'bhie, -amɩa -gblaa 'glʋ 'wʋ, 'ɩn -Zezuu 'bɩnɔnya yia -buduŋwɛɛ lʋbhiti. ");
INSERT INTO kyf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","-A 'bhʋa Tilɩgbe 'wʋ 'glʋ nya, 'ɩn -a yia Pʋtolemaisɩ -amɩaa nɔnʋe 'wlubha. -A -saa wee 'gbe nʋkplɛɛ -Lagɔbhelia fʋ, 'ɩn -a yia 'ylɩ -bhlo li wa nya. ");
INSERT INTO kyf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","-Mʋʋ 'bɩgʋ zlɩ zlɩa, -a 'bhitia lʋ, 'ɩn -a yia Sezalee nyni. -Bha -a plaa -Lagɔɔ gbʋgbanyɔ Filipʋʋ -budu zɔ, 'ɩn -a yia ɔ -gbɛ ladɩlɩ. Nɩɩ, ɔɔ Filipʋ mɩ nyɩma gbesɔ -wa -a -saa zlɩmɛ -bha -Zeluzalɛmʋ, wa lʋnyɩmɛ yabhlo nya. ");
INSERT INTO kyf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ɔ ka 'ŋwnɩyua -mnʋa, 'yieslɔŋwnɩ nya, wa 'nɩ ylɩ -mɩ. -Lagɔgbʋʋ -falɩ wa paa. ");
INSERT INTO kyf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","-A ka -bha 'ylɩ duun li, 'bhie, -Lagɔgbʋʋ -falɩpanyɔ yabhlo 'bhʋa Zudee, wa laa Agabusɩ, 'ɩn ɔ yia -bha yi. ");
INSERT INTO kyf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɔ yia -aɩn 'yɩa, ɔ 'bhua Pɔlʋʋ -jlaa 'wʋ, ɔ gbʋan ɔ 'dɛɛ bhʋ 'sɔ -yɔ sɔ 'sɔ, 'ɩn ɔ nɛɛ: «Wɛlɩ Zuzu 'Pʋpa gbaa, mʋ nɩ: ‹Nyɩmɛ ka -jlaa mɩa da, sa ɩn gbʋan da na 'dɛ, 'sa Zuifʋ yia ɔ gbʋaan -Zeluzalɛmʋ. 'Ɩn wa 'ka ɔ nyɩma -wa 'nɩa Zuifʋ yoo 'nyɛ.› » ");
INSERT INTO kyf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Da -a 'nʋa gbʋ -mɩnɩ, 'ɩn -amɩaa 'dɛ -yɔ Sezaleee -Lagɔbhelia yia Pɔlʋ bhubhoe, nɩɩ, ɔ 'na mnɩnɩ -Zeluzalɛmʋ -nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","'Ɩn Pɔlʋ yia we 'bɩgʋpalɩɛ: «Lɛɛ ka 'gbʋ a wi, 'ɩn a sumanɩ na dlɩa? Wa 'ka 'mɩ gbʋan -Zeluzalɛmʋoo, wa 'ka 'mɩ 'bha 'dɛbhie -gbolu Nyɩmaa -Kanyɔ -Zezuu 'ŋnɩɩ 'gbʋoo, ɩn mɩ 'cɩn lamnazɩda.» ");
INSERT INTO kyf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nɩɩ, ɔ 'nɩ -amɩaa wɛlɩ 'wʋŋwnuda -mɩɩ 'gbʋ, -a yia ɔ bhubhoe 'yitide. 'Ɩn -a nɛɛ: «Nyɩmaa -Kanyɔɔ dʋmagbʋ nʋ lɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","-A lia 'ylɩ sanɩmɛ wee da, 'ɩn -a yia -amɩaa 'gbanya -mɔzʋ, -a yia -Zeluzalɛmʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","-Zezuu 'bɩnɔnya tɔlʋa mɩa Sezalee, -maa yia -aɩn yoo kwa. 'Ɩn wa yia -aɩn Siplʋ -nyɩmɛ yabhlo, -ɔ 'kaa -aɩn -gʋda 'nyɛ, -ɔ wa laa Mnasɔɔɔn -buduŋwɛɛ kwa. -Zezuu 'bɩnɔnyɔ -wa, we 'bɩ ka 'wʋgwlɛ. ");
INSERT INTO kyf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Da -a nynia -Zeluzalɛmʋ, -Lagɔbhelia yia -amɩaa 'lakpasu kpa 'mʋna nya. ");
INSERT INTO kyf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","-Mʋʋ 'bɩgʋ zlɩ zlɩa, Pɔlʋ -yɔ -aɩn 'sɔ yia *'Zakee -gbɛ mnɩ. -Mɔ leglizɩɩ nyɩma kpasɩ weee gbelia 'wlu. ");
INSERT INTO kyf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔlʋ -saa wa fʋ, 'bhie, -we weee -Lagɔ nʋa lɛ nyɩma 'nɩa Zuifʋʋ -gbɛ, 'ɩn ɔ yia we 'dɩ -sa wa -yla kpɛɛn kpɛɛn. ");
INSERT INTO kyf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Da wa 'dɛ weee 'nʋa wɛlɩ -mɩnɩ, 'ɩn wa yia -Lagɔɔ 'ŋnɩ -mnɩnɩ. 'Ɩn wa nɛɛ Pɔlʋ -ylaɛ: «Bheli -ɩn -talɩ, Zuifʋʋ 'wlu sanɩmɛ ka -Zezu dlɩ -gʋ zʋ, 'ɩn wa mɩa Moizɩɩ tite -yɔlanɛda. ");
INSERT INTO kyf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","-We wa mɩa gbada wa -yla -na daa mʋ nɩ: Zuifʋ -wa mɩa 'lakpanya glaa, -ɩn nɛɛ wa -yla wa palɩ Moizɩɩ tite -blɩgʋ, wa 'na 'palɩ wa 'yua knɩ 'wʋ -nɩ, 'ɩn wa 'bhʋ -Zuifʋʋ lɛnʋgbʋ 'cɩn 'bɩ. ");
INSERT INTO kyf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sa -a 'ka we nʋa? 'Nʋa wa yia we -kpɔ, nɩɩ, -ɩn ka yi. ");
INSERT INTO kyf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","We 'gbʋ, -we -a yia da -mɩ -yla gbaa, -ɩn nʋ we lɛ. Nʋkpasia -mnʋa -wa bia -Lagɔ -yla mɩ -aɩn glaa -seli. ");
INSERT INTO kyf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","-Ɩn -yɔ wa mnɩ, -ɩn -yɔ wa 'ka wa -yɔwɔlʋgbʋ lɛnʋ, -ɩn plʋlʋ wa 'wlu, 'ɩn wa 'ka wa 'nyi -sa. -Ɩn -ka 'sa nʋ, 'ɩn nyɩma weee yibhelia we 'ji nɩɩ, -we wa gbaa -na daa, we 'nɩ gbʋzɔnʋ. 'Ɩn wa 'ka we -yɔyɩ, nɩɩ, Moizɩɩ tite -mɩ -na zʋ 'ya 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","We -ka nyɩma -wa 'nɩa Zuifʋ, -wa zʋa -Zezu dlɩ -gʋ, gbʋ -we ka wɛlɩ -a bhlɩa, -a ka we cɛlɩ, 'ɩn -a yia we wa yoo 'pa: ‹A 'na lili -zila -bʋbɔnɩmɛ -nɩ, we ka pʋɩn. Nɩmɛɛ 'pɩɔn -tʋkpa -yɔ nɩmɛ -we 'pɩɔn 'nɩa 'wʋtla, a 'na lili we -nɩ. 'Ɩn a 'na nʋnʋ mʋtnɩgbʋ lɛ -nɩ.› » ");
INSERT INTO kyf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","-Mʋʋ zlɩ zlɩa, tɔʋn, Pɔlʋ -yɔ waa nyɩma -mnʋa yia mnɩ. 'Ɩn ɔ -yɔ wa yia -yɔwɔlʋgbʋ lɛnʋ dabʋdʋ. -Mʋʋ 'bɩgʋ, 'ɩn ɔ mnɩa -Lagɔbudu 'kadʋ zɔ, 'ɩn 'ylɩ -we nya wee -yɔwɔlʋgbʋ 'kaa bhɩa, ɔ yia we gba. We ji -wa nɩɩ, bhla -we nya wa 'kaa wa -zila bʋbɔ -bhlo -bhlo. ");
INSERT INTO kyf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wee -yɔwɔlʋ ylɩ gbesɔ 'ka bhɩa mnɩ, 'ɩn -Azii -dʋdʋ -gʋʋ Zuifʋ yia Pɔlʋ -yɔyɩ -Lagɔbudu 'kadʋ zɔ. Tɔʋn, wa 'paa nyɩma -zloo dlɩ yalɩ, 'ɩn wa yia ɔ kpa, 'wʋkpɩkpɩe nyaɛ: ");
INSERT INTO kyf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Izlaɛlɩɩ nyɩma, a bɛ -aɩn -yɔ! Nyɩmɛ -ɔ mɩa da, da weee -yɔ nyɩma weee ɔ slolua gbʋ -we -wa Izlaɛlɩnyɩma klaa, we -yɔ Moizɩɩ tite -yɔ -Lagɔbudu 'kadʋʋ -yɔ -tʋ. 'Ɩn -slɛɛn, nyɩma -wa 'nɩa Zuifʋ, ɔ ka wa -Lagɔbudu 'kadʋ zɔ -la, sanɛɛ 'sa ɔ plalɩa wee -mɔwlʋ da pʋɩn -llɛllɛ!» ");
INSERT INTO kyf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","-We ka 'gbʋ, wa yia 'sa nʋ, wa ka Efɛzɩyu Tlofimʋ 'yɩ Pɔlʋ nya -Zeluzalɛmʋgbe nʋkplɛ. Nɩɩ, wamɩa dlɩɩ, Pɔlʋ -yɔ ɔ 'sɔ ka -Lagɔbudu 'kadʋ zɔ pla. ");
INSERT INTO kyf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","'Ɩn wee 'gbee nʋkpla -nyɩma weee gbugblolua, 'ɩn wa -yɔ -gwagwɩe yia da weee 'bhʋ. 'Ɩn wa yia Pɔlʋ kpa, wa -yɔ ɔ lagbizelie yia -Lagɔbudu 'kadʋ zɔ 'tla, 'ɩn wa yia -bha kla, -bha -bhlokpadɛ. ");
INSERT INTO kyf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Zuifʋ mɩ 'klɩ 'yɩda, wa 'ka Pɔlʋ 'bha, 'ɩn nyɩma yia wɛlɩ Wlɔmʋʋ 'slʋjaa -zloo -kanyɔ 'kadʋ kwa, nɩɩ, -Zeluzalɛmʋ -nyɩma weee ka gbugblolu. ");
INSERT INTO kyf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","-Bha -bhlokpadɛ, ɔ 'bhua 'slʋja -yɔ 'slʋjaa glʋ gbuu 'yugalɩnya 'wʋ, 'ɩn ɔ -yɔ -gwagwɩe yia nyɩmaa -zloo gbɛgbɛɩn mnɩ. Da wa 'yɩa ɔ -yɔ 'slʋja 'sɔ -yɔ, 'ɩn wa yia Pɔlʋʋ bhɩtɩe 'yitide. ");
INSERT INTO kyf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ɔɔ 'slʋjaa -kanyɔ 'kadʋ bɛa Pɔlʋ -yɔ, ɔ kpaa ɔ, 'ɩn ɔ nɛɛ, wa gbʋan ɔ nɛtɛllukpe 'sɔ nya. 'Bhie, ɔ yia wa layɩbhaɛ: «Nyɔɔ nyɩmɛ -mɔnɩ -mɩa? Lɛɛ -lu ɔ nʋ lɛa?» ");
INSERT INTO kyf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","'Ɩn nyɩmaa -zloo glaa, -zakpa -bhlo kpɩ 'wʋ -maa 'dɛɛ sa, 'ɩn tɔlʋa kpɩa 'wʋ, wɛlɩ -putu nya. Nɩɩ, 'slʋjaa -kanyɔ 'kadʋ 'nɩ mneni ɔ 'ka wɛlɩ yabhlogbɔɔ 'wʋlanʋ, wee -zlɛ duun glaa. 'Ɩn ɔ nɛɛ, wa -yɔ Pɔlʋ 'sɔ mnɩ 'slʋjaa -budu 'kadʋ zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Da Pɔlʋ -yɔ wa nynia wee -buduu sɩkalie kwesi, 'ɩn 'slʋja yia ɔ 'wʋbhu nyɩma 'wlu yalɩ, nyɩmaa -zlo glaa, 'cɛ 'kadʋ wa mɩa 'padaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nɩɩ, nyɩma weee mɩ ɔ 'bɩ, 'wʋkpɩkpɩe nya: «A 'bha ɔ!» ");
INSERT INTO kyf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Bhla -we nya wa -yɔ Pɔlʋ 'kaa 'slʋjaa -budu 'kadʋ zɔ pla, ɔ nɛɛ 'slʋjaa -kanyɔ 'kadʋ -ylaɛ: «Ɩn mneni ɩn 'ka -mɩ -yla wɛlɩ yabhlo gbaa?» 'Ɩn -mɔɔ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Ɩ'ɩn, aya! Glɛkɩwɛlɩ -na gbaa? ");
INSERT INTO kyf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ezipʋtʋyu -ɔ 'bhua nyɩmaa dlɩ 'wʋ, nyɩmaa 'wlulapɩlɩnyɔ -yɔ, we 'bɩ 'nɩ -slɔ 'wʋgwlɛ, 'ɩn ɔ -yɔ 'bɩnɔnya 'wlu glʋ -bhlo (4.000) yia da bɛblɛɛ ladɩlɩa mnɩ, we 'nɩ -mɩɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔlʋ yia we 'bɩgʋpalɩɛ: «Zuifʋ ɩn -mɩa, Talɩsɩgbe nʋkplɛ, Silisi -dʋdʋ -gʋ. Gbe ka 'ŋnɩ mɩa mnɩda, we nʋkpla -nyɩmɛ ɩn -mɩa. -Mɩ na bhubhoea, -ɩn 'nyɛ 'mɩ 'yoo, ɩn 'ka nyɩma -yla gbʋ gba.» ");
INSERT INTO kyf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","'Slʋjaa -kanyɔ 'kadʋ yia ɔ 'yoo 'nyɛ. Pɔlʋ 'yligbea sɩkalie 'wlu, 'ɩn ɔ yia sɔ 'pa nyɩma -yla, nɩɩ, wa 'mu ŋwɛ. Da wa 'dɛ weee 'mua ŋwɛ blenyii, 'ɩn Pɔlʋ yia wa -yla gbʋ gba zuifʋwɛlɩ 'wʋ: ");
INSERT INTO kyf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Na bhelia -yɔ na didea, a pʋ yukwli, na 'dɛɛ gbʋ 'wʋsawɛlɩ na yia -slɛɛn da aɩn -yla gbaa.» ");
INSERT INTO kyf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Da Pɔlʋ mɩa gbada wa -yla, wa 'nʋa we zuifʋwɛlɩ 'wʋ, 'ɩn wa yia ŋwɛ 'mu blenyii. Tɔʋn, 'ɩn Pɔlʋ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Zuifʋ ɩn -mɩa, Talɩsɩgbe 'wʋ wa gwalɩa 'mɩ, Silisi -dʋdʋ -gʋ. 'Ɩn -seli wa zʋa 'mɩ -Zeluzalɛmʋ. Gamaliɛlɩ -wa na -slolunyɔ, mɔ -slolua 'mɩ -amɩaa dʋkpasɩɩ tite kpɛɛn kpɛɛn. -Lagɔɔ gbʋ mɩ 'ya -amɩ dlɩɩ 'kadʋʋ, a 'dɛ weee 'bhisa -zɛɛn. ");
INSERT INTO kyf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nyɩma -wa mɩa -Zezuu 'Yloogblʋ -gʋ, ɩn ka wa 'klɩyɩe 'wʋpalɩ, ɩn ka wa 'bha. 'Ɩn ɩn yia wa 'llukpe palɩ, we yi nʋkpasia -zɛoo, we yi 'ŋwnɩ -zɛoo, -zugba na pa wa -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","*-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -yɔ Zuifʋʋ nyɩma kpasɩ weee mneni wa 'ka gba, nɩɩ, gbʋzɔnʋ na gbaa. Wa ka 'mɩ 'sɛbhɛnya yoo 'nyɛ, na bhelia Zuifʋ mɩa -Damasɩgbe nʋkplɛɛ 'gbʋ. 'Ɩn ɩn yia wee 'gbe nʋkplɛ mnɩ, waa -Lagɔnyɩma mɩa -mɔ, ɩn 'ka wa 'llukpe 'palɩ, ɩn 'ka wa -mɔ -Zeluzalɛmʋ kwa, 'ɩn wa 'ka wa -kaslʋ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«'Ɩn, ɩn mɩ 'yloogblʋ, ɩn 'ka -Damasɩgbe -yɔ cɩpaa yi, 'ylʋgbagbʋ ylʋ nya tɔʋn, san 'kadʋ yabhlo 'bhʋa yalɩ, 'ɩn we yia 'mɩ gbeli. ");
INSERT INTO kyf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ɩn bhlia dʋdʋ, 'ɩn ɩn yia wɛlɩ yabhlo 'nʋ, we nɛɛ 'mɩ -ylaɛ: ‹Sɔlʋ, Sɔlʋ, lɛɛ ka 'gbʋ -na palɩ 'mɩ 'klɩyɩe 'wʋa?› ");
INSERT INTO kyf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","«'Ɩn ɩn yia layɩbhaɛ: ‹Na -Kanyɔ, nyɔɔ -ɩn -mɩa?› «'Ɩn wee wɛlɩ yia we 'bɩgʋpalɩɛ: ‹-Amɩ Nazalɛtɩyu -Zezu, -ɩn mɩa 'klɩyɩe 'wʋpalɩda, -amɩ -wa.› ");
INSERT INTO kyf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Na nɔnɔnya ka wee san -yɔyɩ, 'ɩn -ɔ mɩa 'mɩ -yla gbʋ gbada, wa'a 'nʋ -mɔɔ wɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Tɔʋn, ɩn yia layɩbhaɛ: ‹Na -Kanyɔ, sa ɩn 'ka nʋa?› «'Ɩn Nyɩmaa -Kanyɔ nɛɛ 'mɩ -ylaɛ: ‹-Ɩn -sɔ 'wʋ, -ɩn mnɩ -Damasɩgbe nʋkplɛ, 'ɩn -we weee -Lagɔ gbaa, -ɩn nʋ lɛ, -mɔ wa yia -mɩ -yla we gbaa.› ");
INSERT INTO kyf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɩn ka 'lɔ wee saan 'tɩtɛ -mɩnɩɩ 'gbʋ, na nɔnɔnya kpaa na sɔ la, 'ɩn wa yia 'mɩ -Damasɩ kwa. ");
INSERT INTO kyf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«-Mɔ -Damasɩ, nyɩmɛ yabhlo mɩ -bha, 'mɔ wa laa Ananiasɩ. Nyɩmɛ -ɔ zʋa -bha -Lagɔ, 'mɔ ɔ -mɩa, 'ɩn ɔ zʋa Moizɩɩ tite 'nʋŋwɛ. -Damasɩgbee Zuifʋ weee gbaa gbʋzɔnʋ gbʋ ɔ daa. ");
INSERT INTO kyf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananiasɩ yia na -gbɛ, ɔ 'yligbea 'mɩ kwesi, 'ɩn ɔ nɛɛ 'mɩ -ylaɛ: ‹Sɔlʋ, na bheli, -na 'yli -blo!› -Bha -bhlokpadɛ, na 'yli -bloa, 'ɩn ɩn yia ɔ -yɔyɩ vaa. ");
INSERT INTO kyf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«'Ɩn ɔ yia we -gʋdɩ 'mɩ -ylaɛ: ‹-Amɩaa dʋkpasɩɩ -Lagɔ ka -bha -mɩ -sa 'cɩn, -ɩn 'ka ɔ dʋmagbʋ yibheli, 'ɩn -ɔ -wa Nyɩmɛ Tɩklɩɩ, -ɩn 'ka ɔ -yɔyɩ, -ɩn 'ka ɔ 'dɛɛ wɛlɩ 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nɩɩ, ɔ gbʋdayɩnyɔ -na yia -zɛa. 'Ɩn -we -ɩn 'yɩa -yɔ, 'ɩn -ɩn 'nʋa, -ɩn 'ka we gba dʋdʋgʋ -nyɩma weee -yla. ");
INSERT INTO kyf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","'Ɩn -slɛɛn, lɛɛ ka 'gbʋ -na wʋa? -Ɩn -sɔ 'wʋ, -ɩn yi, -ɩn la Nyɩmaa -Kanyɔɔ 'ŋnɩ, wa 'ka -mɩ batizee, -Lagɔ 'ka -mɩ -yɔwɔlʋ, -na gbʋnyii 'ka -mɩ kwɛyli 'bhʋ.› ");
INSERT INTO kyf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«-Mʋʋ 'bɩgʋ, ɩn yia lʋbhiti -Zeluzalɛmʋ. 'Ylɩ yabhlo nya, ɩn mɩ -Lagɔ bhubhoeda -Lagɔbudu 'kadʋ zɔ, 'ɩn Nyɩmaa -Kanyɔ yia 'mɩ 'klʋtlalɩ na 'yli 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","'Ɩn, ɩn 'yɩa Nyɩmaa -Kanyɔ -yɔ, 'ɩn ɔ nɛɛ 'mɩ -ylaɛ: ‹-Ɩn 'pulo kwɛ la, -ɩn 'bhʋ -Zeluzalɛmʋ slʋɩ! Nɩɩ, na gbʋ -na yia gbaa, -mɔ -nyɩma 'na 'ka we -yɔŋwnu.› ");
INSERT INTO kyf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Ɩn yia we 'bɩgʋpalɩɛ: ‹Nyɩmaa -Kanyɔ, wa 'dɛ -yi we 'ji nɩɩ, ɩn ka -Lagɔbudunya zɔ 'plɩlɩ, 'ɩn nyɩma -wa ŋwnua -na gbʋ -yɔ, -zugba na pa wa -kaslʋ 'wʋ, 'ɩn na sɛlɩ wa. ");
INSERT INTO kyf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","'Ɩn da wa 'kaa -na gbʋdayɩnyɔ Etiɛnɩ 'bha, -amɩ mɩ 'ya -bha. -Wa mɩa ɔ 'bhada, ɩn ka wa ŋwnunu, 'ɩn ɩn yia wa -bananya 'yliyɔzʋ.› ");
INSERT INTO kyf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«'Ɩn Nyɩmaa -Kanyɔ nɛɛ 'mɩ -ylaɛ: ‹-Ɩn mnɩ, nɩɩ, tiea na yia -mɩ 'pɩpɩ, nyɩma -wa 'nɩa Zuifʋʋ gbɛgbɛɩn!› » ");
INSERT INTO kyf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nyɩmaa -zlo pʋlʋa Pɔlʋ yukwli tɩklɩɩ, tɔʋn, ɔ yia wɛlɩnya -mɩnɩɩ gbagbɩe bhɩa. 'Ɩn wa yia 'wʋkpɩkpɩe bhliɛ: «A -sa nyɩmɛ nɩ la! A 'bha ɔ! Ɔ 'nɩ we 'klʋ -ka, ɔ 'ka 'yliyɔgada -tʋ, dʋdʋ nɩ -gʋ!» ");
INSERT INTO kyf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wa 'kpɩa 'wʋ 'tɩtɛɛ, wa vitelia wa -bananya, 'ɩn wa yia bla yalɩ 'mni. ");
INSERT INTO kyf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Wlɔmʋʋ 'slʋjaa -kanyɔ 'kadʋ nɛɛ, wa 'pa Pɔlʋ 'slʋjaa -budu 'kadʋ zɔ. Wa 'ka ɔ sɛlɩ, 'ɩn gbʋ -we ka 'gbʋ nyɩmaa -zlo mɩa sa ɔ 'wluo 'kpɩlɩda, ɔ 'ka we gba, 'ɩn -mɔɔ 'ka we 'nʋ. ");
INSERT INTO kyf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","'Ɩn da wa gbʋan Pɔlʋ wa 'ka ɔ sɛlɩa yi, tɔʋn, 'slʋjaa glʋ gbuu 'yugalɩnyɔ mɩa -bha, Pɔlʋ yia ɔ layɩbha 'lee: «We se mɩ aɩn -yla, a 'ka *Wlɔmʋ -dʋdʋwlakpɛ sɛlɩ, -zugba a 'nɩ -slɔ ɔ -yɔgbʋ 'wʋbhuu?» ");
INSERT INTO kyf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Da ɔɔ 'slʋjayu 'nʋa wɛlɩ -mɩnɩ, 'ɩn ɔ yia 'slʋjaa -kanyɔ 'kadʋ wɛlɩ kwa, ɔ nɛɛ ɔ -ylaɛ: «Lɛɛ -lu -na yi yaa dɛ lɛnʋa? Ɔɔ nyɩmɛ -mɔnɩ, Wlɔmʋ -dʋdʋwlakpɛ -wa!» ");
INSERT INTO kyf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","'Slʋjaa -kanyɔ 'kadʋ yia Pɔlʋ 'yɩa, ɔ bɛa ɔ -yɔ. Ɔ yia ɔ layɩbhaɛ: «Gba gbʋzɔnʋ, Wlɔmʋ -dʋdʋwlakpɛ -ɩn -mɩa 'piɛɩn yɩ?» Pɔlʋ yia we 'bɩgʋpalɩ: «Ɩɩn, 'mɔ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","'Ɩn 'slʋjaa -kanyɔ 'kadʋ nɛɛ: «'Gwɛzi 'kadʋ ɩn plʋlʋa 'bhie, ɩn yia Wlɔmʋ -dʋdʋwlakpɛ -zɛ.» 'Ɩn Pɔlʋ yia we 'bɩgʋpalɩ: «-Amɩ mɩa, gwalɩ wa gwalɩlɩa 'mɩ we.» ");
INSERT INTO kyf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","-Bha -bhlokpadɛ, -wa 'ka yaa Pɔlʋ sɛlɩ, 'ɩn ɔ 'ka gba, -maa yia ɔ gwevla. Da 'slʋjaa -kanyɔ 'kadʋ yibhelia we 'ji nɩɩ, Pɔlʋ -ɔ ɔ gbʋan, -mɔɔ mɩ Wlɔmʋ -dʋdʋwlakpɛ nya, 'ɩn ɔ 'dɛ yia nyanɔ nʋ. ");
INSERT INTO kyf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Gbʋ -we Zuifʋ dɩa Pɔlʋ 'wlu, 'slʋjaa -kanyɔ 'kadʋ 'yɩbha ɔ 'ka we 'wʋlanʋ kpɛɛn kpɛɛn. We 'gbʋ, zlɩ zlɩa, 'ɩn ɔ yia ɔ gbʋan -llukpe 'wʋsa. 'Ɩn ɔ yia -Lagɔbʋbɔnyaa -cɩan -yɔ gbʋwliwʋdɩnya 'wlugbeli. 'Bhie, ɔ -yɔ Pɔlʋ yia wa 'yu yi. ");
INSERT INTO kyf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔlʋ ylaa gbʋwliwʋdɩnya flɩlɩɩ, ɔ nɛɛ: «Bheliaɩn, ɩn ka -Lagɔ 'yu nɔ 'nanʋʋ, na dlɩ 'nɩ 'mɩ gbʋ 'nyɛ, 'ɩn we yia -zɛɛn ylɩ -mɩnɩ ylɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","'Ɩn -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Ananiasɩ nɛɛ -wa mɩa Pɔlʋ kwesi -ylaɛ: «A 'pa ɔ ŋwɛ -gʋ -lu!» ");
INSERT INTO kyf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tɔʋn, Pɔlʋ nɛɛ ɔ -ylaɛ: «Wɛlɩ 'sɔ -nyɩmɛ, -mɩ -Lagɔ yia bhɩtɩa! -Bha -ɩn -dɩa la, -zugba -na bhu na -yɔgbʋ 'wʋ titee sɔlʋ, 'ɩn -ɩn nɛɛ, wa bhɩtɩ 'mɩ. Tite 'nɩ 'sa gba.» ");
INSERT INTO kyf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","-Wa mɩa Pɔlʋ kwesi, -maa nɛɛ ɔ -ylaɛ: «-Lagɔbʋbɔnyaa -kanyɔ 'kadʋ -na vɛlɩa yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔlʋ yia we 'bɩgʋpalɩɛ: «Na bhelia, ɩn 'nɩ we 'ji -yi nɩɩ, -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ ɔ -mɩa. Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: ‹-Ɩn 'na gbalɩ gbʋnyuu -na nyɩmaa 'yugalɩnyɔ -yla -nɩ!› » ");
INSERT INTO kyf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔlʋ -yi we 'ji nɩɩ, nyɩmaa -zakpa sɔ -wa gbʋwliwʋdɩnya. -Zakpa -bhlo -wa *Sadusenyɩma, 'ɩn -zakpa 'sɔnʋ -wa Falizɩnyɩma. We 'dɛɛ 'gbʋ ɔ yia 'wʋkpɩ 'tɩtɛɛ wa 'yuɛ: «Bhelia, Falizɩnyɩmɛ ɩn -mɩa, 'ɩn Falizɩnyɩmɛɛ 'yu ɩn -mɩa. Tlɩtlɩnyaa 'wʋsɔsʋe ɩn dɩa dlɩ 'wʋʋ 'gbʋ, wa mɩa da na -yɔgbʋ 'wʋbhuda.» ");
INSERT INTO kyf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Da Pɔlʋ gba 'saa, Falizɩnyɩma -yɔ Sadusenyɩma yia kpɛlɩe bhli, 'ɩn wa yia 'wʋdo 'sɔ. ");
INSERT INTO kyf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nɩɩ, Sadusenyɩma nɛɛ, tlɩtlɩnyaa 'wʋsɔsʋe 'nɩ -mɩ, 'anzɩnya -yɔ zuzu 'nɩ la -mɩ, 'ɩn -zugba Falizɩnyɩma yibhelia we nɩɩ, we 'dɛ weee mɩ la. ");
INSERT INTO kyf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","'Ɩn nyɩmaa -zlo mɩ 'wʋkpɩda 'tɩtɛɛ, 'ɩn Falizɩnyɩmaa tɔlʋa -wa -wa -Lagɔɔ titee gwesanya, -maa yia Pɔlʋ lʋpa 'kʋa 'tɩtɛ nya. Wa nɛɛ: «-A yɩ we -yɔ nɩɩ, nyɩmɛ -mɔnɩ 'nɩ gbʋnyuu yabhlogbɔɔ lɛnʋ. -De zuzu yabhloo, -de 'anzɩ yabhlo gba ɔ -yla gbʋʋ, nyɔɔ -yi we 'jia?» ");
INSERT INTO kyf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Wee -zlɛ kpʋkpalɩa 'wʋ, wa yi Pɔlʋ 'ylisɩsalɩɩ 'gbʋ, nyanɔ yia 'slʋjaa -kanyɔ 'kadʋ dlɩɩ slo. 'Ɩn ɔ nɛɛ ɔ 'slʋja -ylaɛ, -maa -sa Pɔlʋ wa nyɩdɩ, wa kwa ɔ 'slʋjaa -budu 'kadʋ zɔ lʋ. ");
INSERT INTO kyf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","-Mʋʋ 'bɩgʋʋ sabɔ bɛa, Nyɩmaa -Kanyɔ yia Pɔlʋ 'klʋtlalɩ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn 'tɛmanɩ dlɩ! -Ɩn ka na gbʋ gba -seli -Zeluzalɛmʋ, we mɩ nɩɩ, -ɩn gba 'ya we Wlɔmʋgbe nʋkplɛ.» ");
INSERT INTO kyf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","-Mʋʋ zlɩ zlɩa zlʋkpɛ, Zuifʋʋ -zakpa -bhlo yia wɛlɩ -bhlo bhlɩ, 'ɩn wa yia bi -Lagɔ 'yu nɩɩ, wa 'nɩ -slɔ Pɔlʋ 'bha, wa 'na 'ka li 'ɩn wa 'na 'ka 'ma. ");
INSERT INTO kyf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nyɩma -wa bhlɩa wɛlɩ -mɩnɩ, wa ka nyɩmaa glʋ 'sɔ -gʋzi. ");
INSERT INTO kyf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","'Ɩn wa yia -Lagɔbʋbɔnyaa -cɩan -yɔ nyɩma kpasɩɩ -gbɛ mnɩ. 'Ɩn wa nɛɛ -maa -ylaɛ: «-A ka bi -Lagɔ 'yu, nɩɩ, -a 'nɩ -slɔ Pɔlʋ 'bha, -a 'na 'ka -lu yabhlogbɔɔ li. ");
INSERT INTO kyf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","'Ɩn -slɛɛn, amɩa -yɔ gbʋwliwʋdɩnya bhlɩ wɛlɩ -bhlo, 'ɩn a 'ka 'slʋjaa -kanyɔ 'kadʋ -yla gba nɩɩ, ɔ -la aɩn Pɔlʋ -dawli nya, a 'yɩbha a 'ka ɔ -yɔgbʋ 'wʋsɩsalɩ tɩklɩɩ. We -ka -amɩa, -a ka -amɩaa 'dɛ lamnazɩ -a 'ka ɔ 'bha, 'bhie, ɔ 'ka -seli nyni.» ");
INSERT INTO kyf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","'Ɩn wɛlɩ wa bhlɩa Pɔlʋ daa, ɔ bhɔlɔɔ 'yu 'nʋa we, 'ɩn ɔ yia 'slʋjaa -budu 'kadʋ zɔ Pɔlʋ 'dɩ -salɩa mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tɔʋn, Pɔlʋ laa 'slʋjaa glʋ gbuu 'yugalɩnyɔ yabhlo, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Ɩn kwa nyimeslɔyu nɩ 'slʋjaa -kanyɔ 'kadʋʋ -gbɛ, nɩɩ, ɔ ka gbʋ yabhlo ɔ 'ka we gba ɔ -yla.» ");
INSERT INTO kyf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ɔɔ 'slʋja -yɔ ɔɔ nyimeslɔyu yia 'slʋjaa -kanyɔ 'kadʋʋ -gbɛ mnɩ, 'ɩn ɔ nɛɛ ɔ -ylaɛ: «-Kaslʋnyɩmɛ Pɔlʋ laa 'mɩ, ɔ nɛɛ: ɩn -la -mɩ nyimeslɔyu nɩ. -Mɔɔ ka gbʋ yabhlo ɔ 'ka -mɩ -yla we gba.» ");
INSERT INTO kyf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","'Slʋjaa -kanyɔ 'kadʋ kpaa nyimeslɔyuu sɔ la, ɔ -yɔ ɔ vlaa gwe -sɛ, 'ɩn ɔ yia ɔ layɩbhaɛ: «Lɛɛ -gbʋ -ɩn 'yɩbha -ɩn 'ka 'mɩ -yla gbaa?» ");
INSERT INTO kyf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","'Ɩn nyimeslɔyu yia we 'bɩgʋpalɩɛ: «Zuifʋ ka wɛlɩ -bhlo bhlɩ nɩɩ, -ɩn kwa cɩzɩ Pɔlʋ gbʋwliwʋdɩnya 'yu. Gbaa wa yia -dawli nya nɩɩ, gbʋwliwʋdɩnya 'yɩbha wa 'ka ɔ -yɔgbʋ 'wʋsɩsalɩ tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","'Ɩn -ɩn 'na 'nʋnʋ wa wɛlɩ -nɩ! Nɩɩ, -wa zizea ɔ 'bhabhɩee 'gbʋ, wa mneni nyɩmaa glʋ 'sɔ -gʋzi. Wa ka bi -Lagɔ 'yu, wa nɛɛ, wa 'nɩ -slɔ Pɔlʋ 'bha, wa 'na 'ka li, 'ɩn wa 'na 'ka 'ma. Nɩɩ, -slɛɛn, wa ka lamnazɩ, -na wɛlɩ wa mɩa wʋda.» ");
INSERT INTO kyf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Da ɔɔ 'slʋjaa -kanyɔ 'kadʋ gbaa nyimeslɔyu -yla nɩɩ: «-We -ɩn gbaa da 'mɩ -yla, -ɩn 'na gbalɩ we nyɩmɛ yabhlogbɔɔ -yla -nɩ.» 'Bhie, ɔ yia -mɔɔ 'yitide, 'ɩn -mɔɔ yia mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","-Mʋʋ 'bɩgʋ, 'slʋjaa -kanyɔ 'kadʋ laa ɔ 'slʋjaa glʋ gbuu 'yugalɩnya 'sɔ, 'ɩn ɔ nɛɛ wa -ylaɛ: «'Slʋjaa 'wlu -bhlo (200) klaa, nɩmɛsʋʋn -gʋʋ 'slʋjaa glʋ ta 'ya kugbua (70) -yɔ 'slʋjaa 'wlu -bhlo kaa 'li kwɛɛ, a gbeli da wa 'wlu. 'Ɩn a 'dɛ weee mnazɩ la, jibheza lɛlɩɩ gbomnʋanʋ nya, a 'ka Sezalegbe nʋkplɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A mnazɩ nɩmasʋʋn -yɔ, 'ɩn a 'ka Pɔlʋ 'wʋbhu we -gʋ, 'ɩn a 'ka ɔ dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩɩ -gbɛ kwa -dlɔɔ.» ");
INSERT INTO kyf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","'Ɩn ɔ yia 'sɛbhɛ cɛlɩɛ: ");
INSERT INTO kyf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩ 'kadʋ, -amɩ Klodʋ Liziasɩ saa -mɩ fʋ. ");
INSERT INTO kyf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nyɩmɛ -ɔ ɩn 'paa dɛ -mɩ yoo, Zuifʋ ka ɔ kpa, wa 'ka ɔ 'bha. 'Ɩn da ɩn 'nʋa nɩɩ, Wlɔmʋ -dʋdʋwlakpɛ -wa, 'ɩn ɩn -yɔ na 'slʋja yia mnɩ, ɩn yia ɔ wa kwɛɛ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ɩn 'yɩbha gbʋ -we Zuifʋ dɩa ɔ 'wlu, ɩn 'ka we 'ji 'nʋ. We 'gbʋ, ɩn yia ɔ wa gbʋwliwʋdɩnya 'yu kwa. ");
INSERT INTO kyf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ɩn ka we -yɔyɩ nɩɩ, wa 'dɛɛ titee 'gbʋ, wa dɩa ɔ gbʋ 'wlu. 'Ɩn wa 'nɩ mneni wa 'ka ɔ gbʋ yabhlogbɔɔ -yla lapalɩ, -we ka 'gbʋ wa 'kaa ɔ 'bha, 'ɩn wa 'kaa ɔ -kaslʋ 'wʋpa, we 'nɩ 'yɩe. ");
INSERT INTO kyf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","'Bhie, wa yia 'mɩ wɛlɩ kwaɛ, Zuifʋ ka ɔ -yɔgbʋ zʋ. -Bha -bhlokpadɛ, ɩn 'paa ɔ yoo -na -gbɛ. 'Ɩn ɩn nɛɛ ɔ gbʋwludɩnya -ylaɛ, wa 'kla ɔ -na -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","-We 'slʋjaa -kanyɔ 'kadʋ gbaa, ɔ 'slʋja ka we lɛnʋ. Wa 'bhua Pɔlʋ 'wʋ sabɔ, 'ɩn wa -yɔ ɔ yia Antipatlisɩgbe nʋkplɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","-Mʋʋ zlɩ zlɩa, 'ɩn 'slʋja mɩa bhʋ -gʋ nɔda, -maa yia 'slʋjaa -budu 'kadʋ zɔ lʋbhiti. 'Ɩn wa yia 'slʋja mɩa nɩmasʋʋn -gʋ 'yitide, -maa -yɔ Pɔlʋ yia 'yoo 'yliyɔzʋ. ");
INSERT INTO kyf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","'Slʋja mɩa nɩmasʋʋn -gʋ nynia Sezalee, 'ɩn wa yia dʋdʋʋ 'wlulapɩlɩnyɔ 'sɛbhɛ yoo 'nyɛ, 'bhie, wa yia ɔ Pɔlʋ 'klʋslolu. ");
INSERT INTO kyf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Dʋdʋʋ 'wlulapɩlɩnyɔ zɛlɩa wee 'sɛbhɛ, 'ɩn ɔ yia Pɔlʋ layɩbha: «Dʋdʋ -mʋmʋ ka nyɩmɛ -ɩn -mɩa?» 'Ɩn Pɔlʋ yia we 'bɩgʋpalɩɛ: «Silisi -nyɩmɛ ɩn -mɩa.» ");
INSERT INTO kyf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","'Ɩn ɔ nɛɛ ɔ -ylaɛ: «-Wa dɩa -mɩ gbʋ 'wlu, wa -ka yi, 'ɩn na yɩbhaa -mɩ la.» 'Ɩn ɔ nɛɛ, wa kwa Pɔlʋ Ewlodʋʋ gbʋwʋbhubudu 'kadʋ zɔ. ");
INSERT INTO kyf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","'Ylɩ gbu 'plɩa, -Lagɔbʋbɔnyaa -kanyɔ 'kadʋ Ananiasɩ yia Sezalee nyni. Ɔ -yɔ nyɩma kpasɩ tɔlʋa -yɔ *lʋpanyɔ yabhlo wa laa Tɛlɩtulɩ. 'Ɩn wa yia Pɔlʋ 'klaa yi dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩ 'yu. ");
INSERT INTO kyf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wa laa ɔ, 'ɩn Tɛlɩtulɩ yia ɔ gbʋ 'wludɩdɩe bhli dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩ 'yu: «Felisɩ 'kadʋ! -Na 'gbʋ -a kaa da 'wʋtʋtʋe -dlɔɔ weee. 'Ɩn gbʋnya -ɩn 'bhitia gbʋyilo nya, mʋ saa -amɩaa nyɩma 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","-Lu -zɔnʋ weee -a yɩa, da weee, 'ylɩ weee nya, we 'gbʋ -a paa -mɩ fuo dlɩ weee nya. ");
INSERT INTO kyf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","'Ɩn ɩn 'nɩ 'yɩbha, ɩn 'ka -na 'bɩ 'wʋgwlɛlɩ, we 'dɛɛ 'gbʋ, -mɩ na bhubhoe, -ɩn 'nyɛ -aɩn bhla -sɛlɛ, -na dlɩ -zɔnʋ nya, -ɩn 'ka -aɩn yukwli pʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","«-A ka we -yɔyɩ nɩɩ, nyɩmɛ -mɔnɩ, nyɩmɛ 'nyuuu 'dɛgbolu -wa. Nyɩmaa -zakpa -bhlo wa laa Nazalɛtɩ -nyɩma, wa 'yugalɩnyɔ -wa. Zuifʋ weee ɔ pʋpalɩa 'wʋ dʋdʋ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","'Ɩn ɔ ka we layla 'dɛbhie nɩɩ, ɔ 'ka -amɩaa -mɔwlʋ -Lagɔbudu 'kadʋʋ 'ŋnɩ -nyumɔ, 'ɩn -a yia ɔ kpa. -A 'yɩbha -a 'ka ɔ -yɔgbʋ 'wʋbhu -amɩaa titee sɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","'Ɩn 'slʋjaa -kanyɔ 'kadʋ Liziasɩ yia yi, 'ɩn ɔ yia ɔ -aɩn kwɛɛ -sa -gla nya. ");
INSERT INTO kyf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","'Bhie, Liziasɩ nɛɛ Pɔlʋʋ gbʋwludɩnya -yla, wa yi -mɩ 'yu. We -ka -na dɛ 'yɩbha ɔ la, 'ɩn -ɩn 'kaa we 'jiyibheli nɩɩ, gbʋ -we -a dɩa ɔ 'wlu, gbʋzɔnʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","'Ɩn Zuifʋ -maa yi 'yaa Tɛɛtulusɩɩ wɛlɩ -gʋ 'yligbe, 'ɩn wa nɛɛ: «Cɩɩn, -we ɔ gbaa dɛ, gbʋzɔnʋ -wa.» ");
INSERT INTO kyf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","'Ɩn dʋdʋʋ 'wlulapɩlɩnyɔ yia Pɔlʋ -yla sɔ 'pa, nɩɩ, ɔ gba. 'Ɩn Pɔlʋ nɛɛ: «Ɩn -yi we 'ji, -ɩn ka -zʋ duun li, -zugba -na bhu -amɩaa nyɩmaa -yɔgbʋ 'wʋ. We 'gbʋ, na dlɩ 'tɛ 'wʋ, ɩn 'ka na 'dɛɛ -gʋgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","«-Ɩn mneni -ɩn 'ka we 'wʋsɩsalɩ -na 'dɛ nya, nɩɩ, -amɩ nynia -Zeluzalɛmʋ, ɩn 'ka -Lagɔ bʋbɔ, we 'ylɩ kugbua lɛ 'sɔ 'nɩ -slɔ 'plɩ. ");
INSERT INTO kyf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nyɩmɛ yabhlogbɔɔ 'nɩ 'mɩ 'yɩ, -zugba na -yɔ nyɩmɛ kpɛlɩ -Lagɔbudu 'kadʋ zɔ. 'Ɩn nyɩmɛ yabhlogbɔɔ 'nɩ 'mɩ 'wʋtlalɩ, -zugba na bhu nyɩmaa -zloo dlɩ 'wʋ -Lagɔbudunya zɔ -yɔ daputu, 'gbe nʋkplɛ. ");
INSERT INTO kyf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","'Ɩn -slɛɛn, gbʋ -we nyɩma -manɩ dɩa da 'mɩ 'wlu, wa 'nɩ mneni wa 'ka we 'wʋyleli -mɩ -yla. ");
INSERT INTO kyf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","-Mʋʋ bhla, -we ɩn ŋwnua -yɔ -mɩ 'yu, mʋ nɩ: -amɩaa dʋkpasɩɩ -Lagɔ na bʋbɔa, 'Yloogblʋ -lolu -we ka gbʋ wa'a laa gbʋzɔnʋ, we -gʋ -nɔnʋe nya. 'Ɩn -we weee mɩa cɛlɩda Moizɩɩ titee 'sɛbhɛ -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ 'wʋ, 'ɩn na zʋa we dlɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sa wamɩa dɩa -Lagɔ dlɩ 'wʋ, 'sa -amɩ na dɩa -Lagɔ dlɩ 'wʋ. Nɩɩ, nyɩma tɩklɩɩ -yɔ nyɩma 'nyii 'sɔ, 'wʋ wa yia -sɔa tlɩtlɩnya glaa. ");
INSERT INTO kyf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","We 'gbʋ na gʋa la 'ylɩ weee nya, 'ɩn na dlɩ yi 'mɩ gbʋ 'nyɛ -Lagɔ 'yliya 'wʋ, 'ɩn 'ya nyɩma 'yliya 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Da ɩn lia -zʋ duun daputu, 'ɩn ɩn yia -Zeluzalɛmʋ lʋyi 'gwɛzi nya, na nyɩma 'wʋsasɩe -yɔ 'slaka -lii wlawlɩe -Lagɔ -ylaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Da ɩn mɩa -Lagɔbudu 'kadʋ zɔ, 'ɩn -Aziii Zuifʋ yia -mɔ 'mɩ ylɩ, -we ɩn mɩa lɛnʋda mʋ nɩ, ɩn mɩ -mɔwlʋgbʋ lɛnʋda. Nyɩmaa -zlo 'nɩ 'mɩ 'bɩ -mɩ, 'ɩn -zlɛ 'nɩ 'mɩ kwesi -mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","'Ɩn we -ka yaa nɩɩ, -Aziii Zuifʋ -tɔlʋa mɩa zlɩmɛ -bha, -maa ka yaa na gbɛgbɛɩn gbʋ dlɩɩ, ma 'kaa 'mɩ 'kla -na -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Da wa kwaa 'mɩ gbʋwliwʋdɩnya 'yu, gbʋnyuu ɩn nʋa lɛ wa 'yɩa -yɔ, nyɩma -wa 'yligbea dɛ, wa gba we -mɩ -yla. ");
INSERT INTO kyf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ɩn 'yligbea gbʋwliwʋdɩnya 'yu, 'ɩn ɩn nɛɛ wa -yla wɛlɩ 'tɩtɛ nyaɛ: ‹Tlɩtlɩnya yia 'wʋsɔa tlɩtlɩe lʋ! We nya wa -laa 'mɩ aɩn 'yu, a 'ka na -yɔgbʋ 'wʋbhu.› -De mʋʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩ -yia -Zezuu 'Yloogblʋʋ -gʋgbʋ 'ji kpɛɛn kpɛɛn, 'ɩn ɔ yia we 'wʋlanʋ, -mɔɔ yia wee gbʋwʋbhu ylɩ lʋbɛlɩ. 'Ɩn ɔ nɛɛ wa -ylaɛ: «'Slʋjaa -kanyɔ 'kadʋ Liziasɩ -ka yi 'bhie, ɩn 'ka amɩaa gbʋ 'wʋbhu.» ");
INSERT INTO kyf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ɔ nɛɛ 'slʋjaa glʋ gbuu 'yugalɩnyɔ -ylaɛ: «-Ɩn dɩ Pɔlʋ la -kaslʋbudu zɔ. -Ɩn 'tide ɔ 'yi, ɔ 'ka ɔ 'dɛ -yla -tʋ. -Ɩn 'nyɛ ɔ 'talea 'yoo, wa 'ka ɔ -yla -li lɛnʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","'Ylɩ sanɩmɛ 'plɩa, Felisɩ -yɔ ɔ 'ŋwnɔ Dlusilɩ yia yi, Zuifʋŋwnɔ -wa. Ɔ nɛɛ wa -yɔ Pɔlʋ yi, 'ɩn ɔ 'ka ɔ -Zezu Klisɩɩ dlɩ -gʋzʋ wɛlɩ yukwli pʋlʋ. ");
INSERT INTO kyf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","'Ɩn da Pɔlʋ bhlia nyɩmɛɛ nɔnɔbhʋ tɩklɩɩ klaa, 'dɛɛ dlɩ lakpakpɩe -yɔ -Lagɔɔ nyɩmaa -yɔgbʋ 'wʋbhubhuee gbʋ gbagbɩe, 'ɩn Felisɩ yia nyanɔ nʋ. 'Ɩn ɔ nɛɛ Pɔlʋ -ylaɛ: «-Ɩn mneni, -ɩn 'ka -slɛɛn mnɩ. 'Ɩn da ɩn -ka bhɩa, ɩn 'ka -mɩ la lʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dʋdʋʋ 'wlulapɩlɩnyɔ Felisɩ dɩ yaa we dlɩ 'wʋ nɩɩ, 'gwɛzi Pɔlʋ yi yaa ɔ 'nyɛa. We 'gbʋ, ɔ laa Pɔlʋ bhla weee nya, ɔ -yɔ ɔ 'ka 'dɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","-Zʋ 'sɔ 'plɩa, Pɔsiusʋ Fɛsɩtusʋ yia Felisɩɩ 'bɩgʋplɩlɩ. 'Ɩn Felisɩ 'yɩbha ɔ 'ka Zuifʋ dʋdʋnamanɩɩ 'gbʋ, ɔ yia Pɔlʋ -kaslʋ 'wʋ tɩ. ");
INSERT INTO kyf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Da ɔ nynia wee dʋdʋ -gʋ, we 'ylɩ ta 'plɩa, Fɛsɩtusʋ 'bhʋa Sezalee, 'ɩn ɔ yia -Zeluzalɛmʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","-Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ yia Pɔlʋ 'kla ɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wa nɛɛ Fɛsɩtusʋ -yla, ɔ nʋ wa 'nanɩ 'wʋ, 'ɩn wa yia we ŋwɛ -yɔkpalɩ nɩɩ, ɔ -la Pɔlʋ -Zeluzalɛmʋ lʋ. Nɩɩ, wa ka Pɔlʋʋ -yɔgbʋ zʋ, wa 'yɩbha wa 'ka ɔ 'bha 'yloogblʋ. ");
INSERT INTO kyf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","'Ɩn Fɛsɩtusʋ yia we 'bɩgʋpalɩ wa -ylaɛ: «Pɔlʋ mɩ -kaslʋ 'wʋ Sezalee, 'ɩn daylɩ na 'dɛgbolu bhitia -mɔ lʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","'Ɩn ɔ yia we -gʋdɩɛ: «Amɩaa -cɩan kwa 'mɩ yoo, we -ka nɩɩ, nyɩmɛ -mɔnɩ ka gbʋnyuu lɛnʋ, wa 'ka -mɔ we gba.» ");
INSERT INTO kyf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛsɩtusʋ li wa -gbɛ sa 'bhisa 'ylɩ gbomnʋa. 'Bhie, ɔ yia Sezalee lʋbhiti. -Mʋʋ zlɩ zlɩa, 'ɩn ɔ yia gbʋwʋbhu -zejila 'yu ladɩ, 'ɩn ɔ nɛɛ wa -yɔ Pɔlʋ yi. ");
INSERT INTO kyf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Da Pɔlʋ yia, Zuifʋ -wa 'bhʋa -Zeluzalɛmʋ, -maa yia ɔ gbeli. 'Ɩn wa yia ɔ gbʋnyii 'kadɩɩ -zlo 'wludɩ, 'ɩn wa 'dɛ 'nɩ mneni wa 'ka we 'wʋsɩsalɩ tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔlʋ mɩa ɔ 'dɛɛ -gʋgbʋ gbada, ɔ nɛɛ: «Ɩn 'nɩ gbʋnyuu yabhlogbɔɔ lɛnʋ, Zuifʋʋ tite -yɔ -Lagɔbudu 'kadʋ -yɔ nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ *Sezaa gbɛgbɛɩn.» ");
INSERT INTO kyf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛsɩtusʋ 'yɩbha ɔ 'ka Zuifʋ dʋdʋ namanɩɩ 'gbʋ, 'ɩn ɔ nɛɛ Pɔlʋ -ylaɛ: «-Ɩn 'yɩbha -ɩn 'ka -Zeluzalɛmʋ mnɩɩ? Wa 'ka -mɔ -na -yɔgbʋ 'wʋbhu 'mɩ 'yuu?» ");
INSERT INTO kyf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔlʋ yia we 'bɩgʋpalɩɛ: «Sezaaa gbʋwʋbhu -zejila 'yu ɩn 'yligbea da, 'ɩn -bha wa 'kaa na -yɔgbʋ 'wʋbhu. Ɩn 'nɩ Zuifʋ -yla gbʋnyuu yabhlogbɔɔ lɛnʋ, 'ɩn -na 'dɛ -yi we 'ji zʋzɔnʋ sa. ");
INSERT INTO kyf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","We -ka na -yɔgbʋ, 'ɩn gbʋ -we ka 'gbʋ wa 'kaa nyɩmɛ 'bha, ɩn -ka we lɛnʋ, ɩn 'na 'ka tlɩtlɩee daa gba ‹-ɩnnya›. 'Ɩn we -ka nɩɩ, gbʋ nyɩma -manɩ mɩa da 'mɩ 'wludɩda, we 'nɩ gbʋzɔnʋ, nyɩmɛ yabhlogbɔɔ 'nɩ mneni ɔ 'ka 'mɩ wa yoo 'nyɛ. Ɩn ka na gbʋ Sezaa 'yu kwa.» ");
INSERT INTO kyf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nɩɩ, Fɛsɩtusʋ -yɔ ɔ gbʋwliwʋdɩnya bhɩa gbagbɩe, 'ɩn ɔ nɛɛ Pɔlʋ -ylaɛ: «-Ɩn ka -na gbʋ Sezaa 'yu kwa, we 'gbʋ, Sezaa 'yu -na yia mnɩa!» ");
INSERT INTO kyf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","'Ylɩ sanɩmɛ 'plɩa, nyɩmaa 'wlulapɩlɩnyɔ Aglipa -yɔ ɔ bhɔlɔ Belenisɩ yia Fɛsɩtusʋ fʋsaa yi Sezalee. ");
INSERT INTO kyf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wa mɩ -bha 'ylɩ duun lida, 'ɩn Fɛsɩtusʋ yia nyɩmaa 'wlulapɩlɩnyɔ Aglipa -yla Pɔlʋʋ gbʋ gba. Ɔ nɛɛ ɔ -ylaɛ: «Nyɩmɛ yabhlo Felisɩ tɩa -kaslʋ 'wʋ, ɔ mɩ da. ");
INSERT INTO kyf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Da ɩn mnɩa -Zeluzalɛmʋ, *-Lagɔbʋbɔnyaa -cɩan -yɔ Zuifʋʋ nyɩma kpasɩ yia ɔ 'kla nɩɩ, ɩn 'pa ɔ -kaslʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","«'Ɩn ɩn yia we 'bɩgʋpalɩ wa -ylaɛ: ‹-Amɩa, Wlɔmʋ -nyɩma 'nɩ we bhlabhʋ, -a 'ka nyɩmɛ ɔ gbʋwludɩnya yoo 'nyɛ, -zugba ɔ 'nɩ ɔ 'dɛɛ -gʋgbʋ gba gbʋwʋbhunyɔ 'yu.› ");
INSERT INTO kyf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","'Ɩn waa nyɩma -yɔ 'mɩ 'sɔ yia -seli yi dabʋdʋ. 'Ɩn ɩn 'nɩ kpeke, -mʋʋ zlɩ zlɩa, ɩn -dɩa gbʋwʋbhu -zejila 'wʋ la, 'ɩn ɩn nɛɛ na 'slʋja -yla, wa -yɔ ɔɔ nyɩmɛ yi. ");
INSERT INTO kyf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ɔ gbʋwludɩnya yia yi. 'Ɩn gbʋnyii ɩn pʋpalɩ yaa 'wlukʋʋn la, nɩɩ, 'mʋ wa yi ɔ 'wlu dɩa, wa 'nɩ -mʋʋ ɔ 'wlu dɩ. ");
INSERT INTO kyf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nɩɩ, wa 'dɛɛ -Lagɔbʋbʋe -yɔ nyɩmɛ yabhlo wa laa -Zezuu gbʋ -gʋ wa -yɔ ɔ 'sɔ kpɛlɩa. Ɔɔ nyɩmɛ ka tlɩ, 'ɩn Pɔlʋ nɛɛ, ɔ 'nɩ tlɩ, ɔ -ga 'yliyɔ. ");
INSERT INTO kyf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sa ɩn 'kaa gba gbʋ -mɩnɩ 'wʋ, ɩn 'nɩ we -yi. Tɔʋn, 'ɩn ɩn nɛɛ Pɔlʋ -yla, ɔ -ka 'yɩbha ɔ 'ka -Zeluzalɛmʋ mnɩ, 'ɩn wa 'ka -mɔ ɔ -yɔgbʋ 'wʋbhulu, gbʋ -mɩnɩ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","'Ɩn Pɔlʋ yia ɔ gbʋ nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ Sezaa 'yu kwa. Ɔ 'yɩbha nɩɩ, -mɔɔ 'bhu ɔ -yɔgbʋ 'wʋ. 'Ɩn ɩn nɛɛ, wa tɩ ɔ -kaslʋbudu zɔ bhla -sɛlɛ nya. -Mʋʋ 'bɩgʋ, ɩn 'ka ɔ Sezaa 'yu kwa.» ");
INSERT INTO kyf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aglipa nɛɛ Fɛsɩtusʋ -ylaɛ: «Na 'dɛ 'yɩbha ɩn 'ka ɔɔ nyɩmɛ -mɔnɩɩ wɛlɩ 'nʋ.» Fɛsɩtusʋ yia we 'bɩgʋpalɩɛ: «Cɩzɩ -na nʋa ɔɔ nyɩmɛ -mɔnɩɩ wɛlɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","-Mʋʋ zlɩ zlɩa, Aglipa -yɔ Belenisɩ -yɔ nyɩmaa -dɔlʋ yia -budu 'kadʋ zɔ pla, we -yɔ 'slʋjaa -cɩan -yɔ wee 'gbee nyɩma kpasɩ. 'Ɩn Fɛsɩtusʋʋ wɛlɩ -gʋ, wa -yɔ Pɔlʋ yia yi. ");
INSERT INTO kyf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","'Ɩn Fɛsɩtusʋ nɛɛ: «Nyɩmaa 'wlulapɩlɩnyɔ Aglipa, 'ɩn amɩa weee -yɔ -aɩn mɩa da, a yla 'mɔ nyɩmɛ nɩ. Zuifʋ weee ka ɔ 'klaa yi na -gbɛ -Zeluzalɛmʋ, 'ɩn wa yi 'yaa -seli 'mɩ 'bɩ yi, -zugba wa kpɩ 'wʋ, wa 'bha ɔ. ");
INSERT INTO kyf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","-Amɩ ka we -yɔyɩ nɩɩ, ɔ 'nɩ gbʋnyuu yabhlogbɔɔ lɛnʋ, 'ɩn wa 'ka -mʋʋ 'gbʋ ɔ 'bha. 'Ɩn ɔ 'dɛ yia ɔ gbʋ Sezaa 'yu kwa. We 'gbʋ, ɩn nɛɛ wa kwa ɔ -mɔɔ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","'Ɩn -we ɩn 'kaa cɛlɩ -kpɔ na -kanyɔ 'wʋ ɔ 'gbʋ, we 'nɩ -mɩ. We 'gbʋ, ɩn -yɔ ɔ yia aɩn 'yu yi, we -yɔ -mɩ nyɩmaa 'wlulapɩlɩnyɔ Aglipaa 'dɛbhie 'yu. -Ɩn 'yɩbha ɔ la, 'ɩn -we ɔ -ka gba, ɩn 'ka we cɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nɩɩ, we 'nɩ 'ylinanɩ -amɩ 'yliya 'wʋ, ɩn 'ka -kaslʋnyɩmɛ Wlɔmʋ kwa, -zugba gbʋ -we ɔ nʋa lɛ, wa dɩa ɔ 'wlu, ɩn 'nɩ mneni ɩn 'ka we gba tɩklɩɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Aglipa nɛɛ Pɔlʋ -ylaɛ: «-A ka -mɩ 'yoo 'nyɛ, -ɩn 'ka -na 'dɛɛ -gʋgbʋ gba.» Tɔʋn, Pɔlʋ 'paa sɔ, 'ɩn ɔ yia ɔ 'dɛɛ -gʋgbʋ gba, ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Nyɩmaa 'wlulapɩlɩnyɔ Aglipa, na dlɩ mɛnɩ -zɛɛn bhabha. Nɩɩ, gbʋ weee Zuifʋ dɩa 'mɩ 'wlu, ɩn 'ka we na 'dɛ 'wlu -sa -mɩ 'yu. ");
INSERT INTO kyf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","-We ka gbʋ -wa, -ɩn -yi Zuifʋʋ lɛnʋgbʋ 'cɩn 'nanʋʋ, we -yɔ gbʋ -we -gʋ wa kpɛlɩlɩa. We 'gbʋ, -mɩ na bhubhoea, -ɩn pʋlʋ 'mɩ yukwli dlɩtie nya. ");
INSERT INTO kyf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Sa ɩn mɩmnɩa 'wʋla na nyɩma weee nyɩdɩ, we -yɔ -Zeluzalɛmʋ, 'ɩn we 'ka gwedɩ na nyimeslɔ bhla na lɛnʋgbʋ mɩa, Zuifʋ weee -yi we. ");
INSERT INTO kyf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wa -yi 'mɩ -mʋʋ 'bɩ ka 'wʋgwlɛ, wa mneni wa 'ka we gba, -zugba wa -ka we 'yɩbha. Falizɩnyɩma ka kwɛɛ -amɩaa -Lagɔɔ gbʋ -sua 'wʋ, wa lʋnyɩmɛ yabhlo ɩn -mɩa. ");
INSERT INTO kyf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","'Ɩn -lu -Lagɔ gbaa ɔ 'ka -amɩaa dʋkpasɩ 'nyɛ, ɩn dɩa dlɩ 'wʋʋ 'gbʋ, wa mɩa na -yɔgbʋ 'wʋbhuda -slɛɛn. ");
INSERT INTO kyf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","-Amɩaa nyɩmaa *zʋa kugbua lɛ 'sɔɔ dlɩ mɩ we -gʋ, wa 'ka wɛlɩ nɩɩ lɛnʋda 'yɩ. 'Ɩn wa bhubhoea -Lagɔ 'kʋa 'tɩtɛ nya, zlʋkpɛ jibheza. Nyɩmaa 'wlulapɩlɩnyɔ Aglipa, wee wɛlɩ -mɩnɩ ɩn dɩa dlɩ 'wʋʋ 'gbʋ, Zuifʋ yia 'mɩ gbʋ 'wludɩ! ");
INSERT INTO kyf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Lɛɛ ka 'gbʋ, we mɩ amɩa Zuifʋ dlɩɩ nɩɩ, -Lagɔ 'nɩ mneni ɔ 'ka tlɩtlɩnya 'wʋbhu tlɩtlɩe lʋa? ");
INSERT INTO kyf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Na 'dɛgbolu ka 'wlukʋʋn lapʋpalɩ nɩɩ, ɩn mneni ɩn 'ka Nazalɛtɩyu -Zezuu 'ŋnɩ lasa sɔ weee lʋ. ");
INSERT INTO kyf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","'Mʋ ɩn nʋa lɛ -Zeluzalɛmʋ. -Lagɔbʋbɔnyaa -cɩan ka 'mɩ 'yoo 'nyɛ, 'ɩn ɩn 'ka -Lagɔnyɩmaa -zlo -kaslʋ 'wʋpa. 'Ɩn -wa gbaa wa 'ka wa 'bha, 'ɩn na -yɔ -maa paa gwe. ");
INSERT INTO kyf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Zlɩ tɔlʋa zlɩ, 'ɩn na plɩlɩa -Lagɔbudu zɔ. 'Ɩn na palɩa wa 'klɩyɩe 'wʋ, 'ɩn na gbaa -gla nya, wa vɛlɩ -Zezu. 'Cɛ na palɩ bhaa wa -yɔ 'nyumɛɛ 'gbʋ mʋ nʋa lɛ, 'ɩn na mnɩa wa 'klɩyɩe 'wʋpalɩa laga -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«-Mʋʋ 'gbʋ, 'ylɩ yabhloo zlɩ, 'ɩn ɩn yia -Damasɩ mnɩ. -Lagɔbʋbɔnyaa -cɩan 'nyɛa 'mɩ we se, 'ɩn wa yia 'mɩ tie nɩɩ, ɩn kpa -Lagɔnyɩma. ");
INSERT INTO kyf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nyɩmaa 'wlulapɩlɩnyɔ Aglipa, 'ylʋgbagbʋ ɩn mɩ 'yloogblʋ, 'ɩn ɩn yia san bhʋa yalɩ -yɔyɩ. We -nyumalɩ -zi 'ylʋ, 'ɩn we -nyumalɩ yia 'mɩ gbeli, we -yɔ na nɔnɔnya. ");
INSERT INTO kyf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","-A 'dɛ weee ka bhli dʋdʋ, 'ɩn ɩn yia wɛlɩ yabhlo 'nʋ, -mʋʋ nɛɛ 'mɩ -yla zuifʋwɛlɩ 'wʋɛ: ‹Sɔlʋ, Sɔlʋ, lɛɛ -lu ka 'gbʋ -na palɩ 'mɩ 'klɩyɩe 'wʋa? Lɛɛ -lu ka 'gbʋ -na zʋ -gla bhea, nɛɛ bhli zʋ -gla we -kanyɔɔ 'pa 'pa -pnɩ zɔa?› ");
INSERT INTO kyf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«'Ɩn ɩn yia layɩbhaɛ: ‹Na -Kanyɔ, nyɔɔ -ɩn -mɩa?› «'Ɩn Nyɩmaa -Kanyɔ yia we 'bɩgʋpalɩ 'mɩ -ylaɛ: ‹-Amɩ -Zezu, -ɩn mɩa 'klɩyɩe 'wʋpalɩda, -amɩ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","-Ɩn -sɔ 'wʋ, -ɩn 'yligbe -bhadɛ! -We ka 'gbʋ ɩn yia na 'dɛ -mɩ 'klʋslolu, mʋ nɩ: ɩn ka -bha -mɩ -sa, -ɩn 'ka na lubhonʋnyɔ -zɛ. 'Ɩn -ɩn 'ka 'ya na gbʋdayɩnyɔ -zɛ. 'Ɩn -we -ɩn 'yɩa -zɛɛn -yɔ klaa, we -yɔ -we na yia cɩ -mɩ 'klʋslolua klaa, -ɩn 'ka we gba. ");
INSERT INTO kyf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Zuifʋ -yɔ -wa 'nɩa Zuifʋ -wa ka -gbɛ ɩn tiea -mɩ, na 'dɛ yia -mɩ 'yliyɔzʋa wa gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Wa -gbɛ na tiea -mɩ, -ɩn 'ka wa 'yli -blo, -ɩn 'ka wa nikpise 'wʋsa, -ɩn 'ka wa zlɩ 'klʋ -la. -Ɩn 'ka wa -Saataan 'tɩtɛ zɔ -sa, 'ɩn -ɩn 'ka wa -Lagɔɔ -gbɛ -la. 'Ɩn wa -ka 'mɩ dlɩ -gʋ zʋ, -Lagɔ 'ka wa gbʋnyuu 'wʋtɩ, 'ɩn wa 'ka 'bɩ 'yɩ -Lagɔɔ -mɔwlʋ -nyɩma glaa.› ");
INSERT INTO kyf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«We 'gbʋ, nyɩmaa 'wlulapɩlɩnyɔ Aglipa, 'ylikakɩe -we 'bhʋa -Lagɔɔ -gbɛ, ɩn 'nɩ we 'nʋŋwɛ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","'Ɩn -Damasɩ -nyɩma -yɔ -Zeluzalɛmʋ -nyɩma -yla ɩn gbaa -Lagɔgbʋ tɩa. 'Bhie, ɩn yia Zudee -dʋdʋ weee -gʋ -nyɩma -yɔ nyɩma -wa 'nɩa Zuifʋ we -yla gba. Ɩn nɛɛ wa -yla, wa 'bhiti wa dlɩ, wa yi -Lagɔɔ -gbɛ, 'ɩn wa lɛnʋgbʋ -slolu wa 'bhitibhitie sazɔnʋ sa. ");
INSERT INTO kyf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","-We ka 'gbʋ Zuifʋ yia 'mɩ kpa, -zugba ɩn mɩ -Lagɔbudu 'kadʋ zɔ, 'ɩn wa yia 'klɩ 'yɩ, wa 'ka 'mɩ 'bha, mʋ nɩ. ");
INSERT INTO kyf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","'Ɩn -Lagɔ zʋa 'mɩ 'yliyɔ, 'ɩn we yia -zɛɛn ylɩ. Ɩn mɩ -slɔ -bha, ɩn 'ka ɔ gbʋdayɩnyɔ -zɛ nyɩma weee 'yu, nyɩma -kpʋa -yɔ nyɩma 'kadɩ. Gbʋ -we -Lagɔgbʋʋ -falɩpanya -yɔ Moizɩ gbaa nɩɩ, lɛ we yia nʋa, mʋ -bhloo 'dɛ -amɩ na gbaa. ");
INSERT INTO kyf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ɩn nɛɛ sa bheɛ, sɩa -Lagɔɔ -Bhasanyɔ yia. Mɔ yia tlɩtlɩnya glaa 'wʋsɔa tɩa, 'ɩn mɔ yia -Lagɔɔ zlɩɩ gbʋ gbaa Zuifʋ -yɔ -wa 'nɩa Zuifʋ -yla.» ");
INSERT INTO kyf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔlʋ mɩ sa ɔ 'dɛɛ -gʋgbʋ gbada, 'ɩn dʋdʋʋ 'wlulapɩlɩnyɔ Fɛsɩtusʋ yia 'wʋkpɩ: «Pɔlʋ, -sabhɛ bhaa -mɩɩ! -Ɩn ka 'sɛbhɛ 'kpɩa duun, we ka -mɩ -sabhɛ 'wlu palɩ!» ");
INSERT INTO kyf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pɔlʋ yia we 'bɩgʋpalɩ ɔ -ylaɛ: «Fɛsɩtusʋ 'kadʋ, -sabhɛ 'nɩ 'mɩ 'wlu -mɩ. Wɛlɩnya ɩn mɩa da gbada, gbʋzɔnʋ -yɔ gbʋyilo -wɛlɩ -wa. ");
INSERT INTO kyf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nyɩmaa 'wlulapɩlɩnyɔ Aglipa -yi we 'dɛ weee 'ji. 'Ɩn we 'gbʋ, ɩn mneni ɩn 'ka ɔ -yla wee gbʋ gba dlɩ tɛlɔ nya. Na dlɩ mɩ we -gʋ nɩɩ, ɔ -yi wee gbʋ weee 'ji, -we ka gbʋ -wa, we 'nɩ lɛnʋ da yabhlo zizewiemɩ. ");
INSERT INTO kyf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nyɩmaa 'wlulapɩlɩnyɔ Aglipa, gbʋ -Lagɔgbʋʋ -falɩpanya gbaa, -na zʋ we dlɩ -gʋʋ? Dlɩ -na zʋ we -gʋ, ɩn -yi we 'ji!» ");
INSERT INTO kyf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Aglipa yia we 'bɩgʋpalɩ Pɔlʋ -ylaɛ: «-Mɩ dlɩɩ nɩɩ, -Lagɔ 'wʋ -na yia 'mɩ 'paa bhla -sɛ nɩ nya yɩ?» ");
INSERT INTO kyf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","'Ɩn Pɔlʋ yia we 'bɩgʋpalɩɛ: «We yi dɛslɛɛn -zɛoo, we yi cɩ -zɛoo, -Lagɔ na bhubhoea, we 'nɩ -na 'dɛ -bhloo gbʋ, 'ɩn 'ya amɩa weee -wa mɩa da 'mɩ yukwli pʋlʋda -zɛɛn, sa ɩn mɩa da, amɩa 'ka 'sa -mɩ, we 'bhʋ 'llukpenya -mɩnɩ 'wʋ. Nɩɩ, ɩn 'nɩ 'yɩbha wa gbʋan aɩn -amɩ 'bhisa!» ");
INSERT INTO kyf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nyɩmaa 'wlulapɩlɩnyɔ klaa, dʋdʋʋ 'wlulapɩlɩnyɔ klaa, Belenisɩ -yɔ -wa weee -yɔ wa dɩa -bha la, 'ɩn wa yia 'wʋsɔ. ");
INSERT INTO kyf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Wa 'tlaa, 'ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «Nyɩmɛ -mɔnɩ 'nɩ gbʋ yabhlogbɔɔ mnɔ, 'ɩn wa 'ka -mʋʋ 'gbʋ ɔ -kaslʋ 'wʋpa, 'ɩn wa 'ka ɔ 'bha.» ");
INSERT INTO kyf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","'Ɩn Aglipa nɛɛ Fɛsɩtusʋ -ylaɛ: «Nyɩmɛ -mɔnɩ 'nɩ yaa ɔ gbʋ nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ Sezaaa -gbɛ kwa, -zugba -ɩn ka ɔ 'yitide.» ");
INSERT INTO kyf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Da wa gbaa, 'glʋ 'kadʋ 'wʋ -a yia -gblaa -a 'ka Italii -dʋdʋ -gʋ mnɩ, 'ɩn Wlɔmʋʋ 'slʋjaa glʋ gbuu 'yugalɩnyɔ yabhlo wa laa Zuliusʋ , 'mɔ wa 'nyɛa Pɔlʋ -yɔ -kaslʋnyɩma tɔlʋa yoo. ");
INSERT INTO kyf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adlamitɩɩ 'glʋ 'kadʋ yabhlo 'kaa -Azii -dʋdʋ -gʋʋ 'glʋʋ 'yligbedanya 'plɩlɩ, -a -gblaa we 'wʋ, 'ɩn -a yia mnɩ. Tɛsalonikɩyu Alisɩtakɩ 'bhʋa Masedʋanɩ, ɔ -yɔ -aɩn 'sɔ mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","-Mʋʋ zlɩ zlɩa, 'ɩn -a yia Sidɔɔngbe nʋkplɛ nyni. Zuliusʋ -ɔ mɩa Pɔlʋ kpada 'nanʋʋ, -mɔɔ yia Pɔlʋ 'yoo 'nyɛ, ɔ 'ka ɔ 'talea 'yɩa mnɩ, 'ɩn -we Pɔlʋ -ka 'yɩbha, wa 'ka we ɔ 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Da -a 'bhʋa -bha dɛ, -a nynia 'nyunyɩdɩdʋdʋ wa laa Siplʋ kwesi, 'ɩn -a yia we kakpe yabhlo -gʋ 'plɩlɩ, -pɩpɛ mɩ -aɩn yoo yidaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","'Bhie, -a -dɩa Silisi -dʋdʋ -yɔ Panfilii -dʋdʋʋ gumunyu 'wʋ, 'ɩn a yia Milaa nyni, Lisii -dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","-Bha Wlɔmʋʋ 'slʋjaa glʋ gbuu 'yugalɩnyɔ ylɩa Alɛzandlii gbee 'glʋ 'kadʋ mɩa Italii mnɩda, 'ɩn ɔ yia -mɔ -aɩn 'pa. ");
INSERT INTO kyf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","'Ylɩ duun nya, -a -tʋa 'nyu -gʋ nɔda ylɛlɛɛ 'glʋ nya, 'ɩn -a yia sɩa bhabha, 'bhie, -a yia 'gbe wa laa Sinidɩ 'klʋ nyni. -Pɩpɛ 'nɩ ŋwnu, -a 'ka -mɔ -gbɛɩn mnɩɩ 'gbʋ, -a yia Salɩmonee 'plɩlɩ, 'ɩn -a yia 'nyunyɩdɩdʋdʋ wa laa Klɛtɩɩ zɔgbɛɩn mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Sɩasɩe duun nya -a nɔnʋa wee 'nyuu kakpe, 'ɩn da wa laa «'Glʋʋ 'yligbelida -zɔnʋnya», -a yia -bha dɛ nyni, Lazegbe kwesi. ");
INSERT INTO kyf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","-Amɩaa bhla duun ka lanyumɔnʋ, 'ɩn 'glʋʋ 'wʋ -nɔnʋe yia 'ylinyumanɩ -aɩn -yla, -we ka gbʋ -wa, Zuifʋʋ 'sun -pla bhla ka 'plɩplɩe bhɩa, pepe . We 'gbʋ, Pɔlʋ yia glʋʋ nʋkplɛɛ -lubhonʋnya tɔlʋa -yla gbʋ lapalɩ: ");
INSERT INTO kyf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Na 'talea, ɩn ka we -yɔyɩ nɩɩ, -amɩaa nɔnʋe yia -ylinyumanɩa, nɩɩ, 'glʋ -yɔ we nʋkplɛɛ 'gbanya yia -nyumɔa. 'Ɩn -a 'nɩ nʋ 'nanʋʋ, -amɩaa 'dɛbhie -gbolu yɩa -bha tlɩtlɩe.» ");
INSERT INTO kyf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","'Ɩn Wlɔmʋʋ 'slʋjaa 'yugalɩnyɔ yia 'glʋ 'kadʋʋ 'papanyɔ -yɔ 'glʋʋ -kanyɔɔ wɛlɩ dlɩ 'wʋdɩ, we 'ka Pɔlʋʋ wɛlɩ 'wʋzi. ");
INSERT INTO kyf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nɩɩ, wee 'glʋʋ 'yligbelidaa ladɩlɩe 'nɩ 'ylinanɩ ŋwɔtlɔyibhla. We 'gbʋ, nyɩma duun nɛɛ, wa 'bhʋ -bhadɛ. Wa 'yɩ 'klɩ, wa 'ka 'glʋʋ 'yligbelida Fenisɩ mnɩ, -mɔ 'nyunyɩdɩdʋdʋ wa laa Klɛtɩ -gʋ. Wee dʋdʋʋ 'klʋ mɩ 'ylʋʋ bhlilidaa sɔ 'sɔ lʋ. -Mɔ wa yia ladɩa ŋwɔtlɔyibhla. ");
INSERT INTO kyf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","'Ylʋʋ bhlilida kɔpɛsɔlʋ, -pɩpɛ yia 'plɩplɩe bhli -dlɔɔ. -Wa mɩa 'glʋ 'kadʋ 'wʋ, we mɩ wa dlɩɩ nɩɩ, -we wa pʋpalɩa, lɛ we yia nʋa. Wa 'bhua 'glʋʋ 'yligbelinɛtɛ 'wʋ yalɩ, wa mnɩa, 'ɩn wa yia 'nyunyɩdɩdʋdʋ wa laa Klɛtɩ -gʋ 'plɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","'Ɩn 'bɩ 'nɩ 'wʋgwlɛ, tɔʋn, -pɩpɛ 'kadʋ yabhlo wa laa Elakilɔɔn, we yia 'nyunyɩdɩdʋdʋʋ -gɔgɔ 'wlu 'bhʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","-Pɩpɛ yia 'glʋ kwa, 'ɩn nyɩmɛ 'nɩ mneni ɔ 'ka we layligbeli tɩklɩɩɩ 'gbʋ, -a yia -amɩaa 'dɛ 'yitide, 'ɩn -pɩpɛ yia -aɩn kwa. ");
INSERT INTO kyf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","-A 'plɩlɩa 'nyunyɩdɩdʋdʋ 'kienyi wa laa Kodaaa zɔgbɛɩn, 'ylʋʋ bhlilida kɔpɛsɔlʋ, 'ɩn -a nynia -bha, we yia -aɩn 'wʋpa -sɛ. 'Ɩn -a 'yɩa sa 'klɩɩ -zlo, 'ɩn -a yia gbʋwʋsaglʋ -yulɛ yabhlo bɩzɩa 'glʋ 'kadʋ 'wlu 'wʋbhu. ");
INSERT INTO kyf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","'Ɩn 'glʋ 'kadʋʋ nʋkplɛɛ lubhonʋnya yia we -gblalɩ. 'Ɩn wa yia 'glʋ 'kadʋ gbʋan nyɩmaa -yɔbɛ -llukpe nya. Wa mɩ sɔda, wa yi Libii -dʋdʋ -gʋʋ -bʋsɛ -kakpe -gʋ bhlii 'gbʋ, 'ɩn wa yia 'glʋ 'kadʋʋ 'naa 'wʋyɔglɔlʋ, 'ɩn wa yia 'sa wa 'dɛ 'yitide, -pɩpɛ yia wa kwa. ");
INSERT INTO kyf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","-Mʋʋ zlɩ zlɩa, -pɩpɛ 'kadʋ mɩ -aɩn lazukluda 'tɩtɛɛ -bhloo 'dɛ, 'glʋʋ nʋkpla -nyɩma yia gbanyaa vitelivitelie bhli, gumunyu lʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","We 'ylɩɩ tanʋʋ zlɩ, wa yia 'glʋ 'kadʋ 'dɛɛ -yɔlunyaa vitelie bhli gumunyu lʋ, wa 'dɛɛ sɔ nya. ");
INSERT INTO kyf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","'Ylɩ duun nya, -a'a 'yɩ 'ylʋ -yɔ -zɛlɩ -yɔ, -zugba wee -pɩpɛ 'kadʋ plɩ 'saa 'tɩtɛɛ. 'Ɩn -a yia -amɩaa 'dɛɛ tlɩtlɩe dlɩ -sa. ");
INSERT INTO kyf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","'Bɩ ka 'wʋgwlɛ, 'ɩn -wa mɩa 'glʋ 'kadʋ nʋkplɛ, wa 'nɩ -lu yabhlogbɔɔ li. Tɔʋn, Pɔlʋ 'yligbea wa nyɩdɩ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Na 'talea, ɩn nɛɛ yaa, -a 'na 'bhʋlʋ Klɛtɩ -nɩ. A -ka yaa na wɛlɩ 'wʋŋwnu, -zugba -li 'na 'ka yaa sa -nyumɔ. ");
INSERT INTO kyf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","'Ɩn -slɛɛn, 'kʋa na paa aɩn 'yli, a 'tɛmanɩ dlɩ. Nɩɩ, amɩaa lʋnyɩmɛ yabhlogbɔɔ 'na 'ka tlɩ, 'glʋ 'kadʋʋ 'dɛbhlogbɔɔ yia -nyumɔa. ");
INSERT INTO kyf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","-We ka gbʋ -wa, -Lagɔ -ɔ ka -nʋ ɩn -mɩa, 'ɩn -ɔ ka lubho na nʋa, ɔ 'anzɩ ka 'mɩ 'klʋtlalɩ -zɛɛn sabɔ. ");
INSERT INTO kyf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","'Ɩn we nɛɛ 'mɩ -ylaɛ: ‹Pɔlʋ, -ɩn 'na nʋnʋ nyanɔ -nɩ! Nɩɩ, we mɩ nɩɩ, -ɩn 'tla *Sezaa 'yu, wa 'ka -na -yɔgbʋ 'wʋbhu. 'Ɩn -Lagɔ ka -mɩ 'nanɩ 'wʋnʋ, -na 'gbʋ, -wa weee -ɩn -yɔ wa mɩa 'glʋ 'kadʋ 'wʋ, -Lagɔ yia wa puea.› ");
INSERT INTO kyf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","We 'gbʋ, na 'talea, a 'tɛmanɩ dlɩ! Nɩɩ, na dlɩ mɩ -Lagɔ -gʋ. Gbʋ -we -Lagɔ gbaa 'mɩ -yla, lɛ we yia nʋa. ");
INSERT INTO kyf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nɩɩ, bhlia -a yia, 'nyunyɩdɩdʋdʋ yabhloo -gɔgɔ -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","'Ylɩ kugbua lɛ -mnʋanʋʋ sabɔ, -zugba -pɩpɛ 'kadʋ mɩ -aɩn kwada -bhlokpadɛ Adliatikɩ -gumunyu -gʋ. -Mɔ zlɩ -nyɩdɩ, 'ɩn we yia 'glʋʋ nʋkplɛɛ lubhonʋnya dlɩɩ lasibhli nɩɩ, -a ka dʋdʋ -yɔcɩpa. ");
INSERT INTO kyf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","'Ɩn wa vitelia 'nyuu yɩbhɔlʋ -llukpe 'nyu glu, we -tɔ 'wʋ 'mɛtlɩ glʋ -bhlo 'ya kugbua lɛ gbesɔ. Wa bɛa 'yugbɛɩn -sɛ, wa viteli 'yaa we, we -tɔ 'wʋ 'mɛtlɩɩ glʋ -bhlo 'ya gbeta. ");
INSERT INTO kyf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","'Ɩn wa mɩ nyanɔ nʋda nɩɩ, -amɩaa 'glʋ 'kadʋ yi tʋkpa -gɔgɔ 'kadʋ 'wlu bhuu 'gbʋ, wa yia 'glʋʋ 'yligbelinɛtɛ -mnʋa 'nyu lʋ viteli 'glʋʋ lʋgbɛɩn, 'ɩn wa yia zlɩɩ zlɩzlɩe wʋda -tʋ dlɩ sulo nya. ");
INSERT INTO kyf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","'Ɩn -mʋʋ bhla, 'glʋ nʋkplɛɛ lubhonʋnya 'yɩbha wa 'ka -flii -bho. 'Ɩn wa yia gbʋwʋsaglʋ -yulɛ kwlili 'nyu lʋ. 'Ɩn wa nɛɛ -dawli nya, 'glʋ 'kadʋʋ 'yligbelinɛtɛ wa vitelia we 'yugbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","'Ɩn Pɔlʋ nɛɛ Wlɔmʋʋ 'slʋjaa glʋ gbuu 'yugalɩnyɔ -yɔ 'slʋja -ylaɛ: «Nyɩma -manɩ 'nɩ 'glʋ 'kadʋ nʋkplɛ -tʋ, a 'na 'ka 'pʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tɔʋn, 'slʋja yia 'glʋ -yulɛ 'llukpenya -yɔdɩ, 'ɩn wa yia we 'yitide, we 'ka gumunyu -gʋ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Zlɩɩ zlɩzlɩe 'yu, Pɔlʋ laa wa 'dɛ weee lililu -yɔ, 'ɩn ɔ nɛɛ wa -ylaɛ: «Amɩaa 'ylɩ kugbua lɛ -mnʋa nɩ -zɛɛn, dlɩ sulo nya, -zugba a'a 'bhu lililu yabhlogbɔɔ 'wʋ, a'a li we. ");
INSERT INTO kyf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","We 'gbʋ na laa aɩn, a 'ka li. Nɩɩ, we nanɩ 'yli a 'ka li, 'bhie, a 'ka 'pʋ. Amɩaa lʋnyɩmɛ yabhlogbɔɔɔ 'nyii gɔ yabhlo 'nɩa mnɔa yi!» ");
INSERT INTO kyf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wɛlɩnya -mɩnɩɩ 'bɩgʋ, Pɔlʋ 'bhua 'floo 'wʋ, 'ɩn ɔ yia -Lagɔ fuo 'pa wa 'dɛ weee 'yibadɩ. 'Bhie, ɔ -dɩa we 'wʋ, 'ɩn ɔ yia lilie bhli. ");
INSERT INTO kyf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tɔʋn, wa 'dɛ weee 'tɛmanɩa dlɩ, 'ɩn wamɩa yi 'yaa li. ");
INSERT INTO kyf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","-Amɩa mɩa wee 'glʋ 'kadʋ nʋkplɛ, -a 'dɛ weee nyni nyɩmaa 'wlu -bhlo glʋ ta 'ya kugbua lɛ gbelibhlo. ");
INSERT INTO kyf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Da wa lʋa, 'ɩn wa yia bleyanya 'nyu lʋ viteli 'glʋ 'ka 'wʋtʋ fefee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Da zlɩ zlɩa, 'glʋʋ nʋkplɛɛ lubhonʋnya 'nɩ dʋdʋ yibheli, 'ɩn wa yia gumunyuu sɔ yabhlo -yɔ -bʋsɛ -gɔgɔ -yɔyɩ. 'Ɩn wa nɛɛ wa 'ka -mɔ 'glʋ 'yligbelia mnɩ, -de wa yi we mnenii. ");
INSERT INTO kyf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wa -bloa 'glʋʋ 'yligbelinɛtɛnya, 'ɩn wa yia we 'yitide gumunyu lʋ. 'Ɩn 'payli -we nya wa paa 'glʋ, wa yia we 'llukpe -blo. 'Bhie, wa yia 'naa wee 'glʋʋ 'yugbɛɩn zʋ, -pɩpɛ 'ka we kwaa 'gbʋ, 'ɩn wa yia -bʋsɛ -gɔgɔ -gʋ -gbɛɩn mnɩnɩ. ");
INSERT INTO kyf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","'Ɩn wa nynia gumunyuu sɔ 'sɔɔ nyɩdɩ -bʋsɛɛ -zlo -gʋ, 'ɩn 'glʋ yia -bha zɩ. 'Ɩn wee 'glʋʋ 'yugbɛɩn yia -bʋsɛ 'wʋ pla, we 'nɩ mneni we 'ka nɔ, -zugba gumunyuu -gbʋgbʋ 'tɩtɛ wla we lʋgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","'Ɩn 'slʋja 'yɩbha wa 'ka -kaslʋnyɩma 'bha, -maa 'yabhlogbɔɔ yi -flii -bho llolloe nyaa 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","'Ɩn wa 'yugalɩnyɔ 'yɩbha ɔ 'ka Pɔlʋ gbʋ 'wʋsaa 'gbʋ, gbʋ 'slʋja pʋpalɩa, ɔ nɛɛ wa 'na nʋnʋ we lɛ -nɩ. 'Ɩn -wa -yia llo sa, ɔ nɛɛ -maa -yla, -maa -bho 'nyu lʋ tɩa, 'ɩn wa 'ka -gɔgɔ -gʋ mnɩ, ");
INSERT INTO kyf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","'ɩn tɔlʋ mnɩ wa 'bɩ, sufalʋnya -yɔ 'glʋʋ falʋ -yɔlanɛnɩe nya. Sanɛɛ 'sa, wa 'dɛ weee 'tlaa -gɔgɔ -gʋ -dlɔɔ, 'ɩn wa yia 'pʋ. ");
INSERT INTO kyf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Da -a 'pʋa, 'ɩn -a yia 'nʋ nɩɩ, wee 'nyunyɩdɩdʋdʋ wa laa Malɩtɩ. ");
INSERT INTO kyf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wee 'gbee nʋkpla -nyɩma ka -amɩaa 'lakpasu kpa 'nanʋʋ. 'Nyu mɩ lʋada, 'ɩn ŋwɔtlɔ mɩɩ 'gbʋ, wa -dɩa -kosu 'kadʋ 'yi, 'ɩn wa yia -a 'dɛ weee 'bɩ 'nyɛ, we kwesi. ");
INSERT INTO kyf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔlʋ 'bhua -gbalɩ pipi 'wʋ, ɔ yia we -kosu 'wʋ 'pa. 'Ɩn 'mʋnɩmɛ yia -kosuu sloo 'gbʋ -gbalɩ pipi 'wʋ 'tla! We yia Pɔlʋʋ sɔ mu, 'ɩn we yia we -yɔlanɛ! ");
INSERT INTO kyf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Da 'nyunyɩdɩdʋdʋ -gʋ -nyɩma 'yɩa wee 'mʋnɩmɛ -yɔ bɩzɩda Pɔlʋʋ sɔ -yɔ, 'ɩn wa nɛɛ wa 'dɛkpʋa nyɩdɩɛ: «Ɔɔ nyɩmɛ -mɔnɩ, nyɩmɛbhanyɔ -wa 'piɛɩn. Ɔ ka gumunyu kwɛɛ -dɩ, 'ɩn -Lagɔ 'nɩ ɔ 'pʋpʋgbʋ -yɔŋwnu.» ");
INSERT INTO kyf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tɔʋn, Pɔlʋ vua sɔ 'wʋ, 'ɩn wee tɩbhɛ yia -kosu 'wʋ -bho, ɔ ku 'nɩ glopo. ");
INSERT INTO kyf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tɔlʋa dlɩɩ nɩɩ, 'ylɩa Pɔlʋ yia, 'ɩn bhlia ɔ yia -bha -bhlokpadɛ, ɔ 'ka tlɩ. 'Ɩn wa yia we -yɔyɩ nɩɩ, 'bɩ mɩ 'wʋgwlɛda, gbʋ yabhlogbɔɔ 'nɩ Pɔlʋ ylɩda -mɩ. Tɔʋn, wa yia wɛlɩ 'bhiti, 'ɩn wa nɛɛ: «-Lagɔ yabhlo -wa.» ");
INSERT INTO kyf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","'Nyunyɩdɩdʋdʋ -mɩnɩɩ 'wlulapɩlɩnyɔ wa laa Publiusʋ, ɔ dʋdʋ mɩ wee da -mɩnɩ kwesi. Mɔ kpaa -amɩaa 'lakpasu 'ylɩ ta, 'ɩn ɔ yia -aɩn ɔ -budu zɔ -gueli, ɔ 'talea 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiusʋʋ dide mɩ lapɩda, ɔ ku -su, 'ɩn ɔ kaa kakpa -yɔ. Pɔlʋ mnɩa ɔ 'yɩa, 'ɩn ɔ yia ɔ sɔ ɔ 'wluo lapalɩ, ɔ yia ɔ 'gbʋ -Lagɔ bhubhoe, 'ɩn ɔ yia ɔ jipe. ");
INSERT INTO kyf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","-Mʋʋ 'bɩgʋ, wee 'nyunyɩdɩdʋdʋ -gʋʋ guzʋnya tɔlʋa yia yi, 'ɩn Pɔlʋ yia wa jipe. ");
INSERT INTO kyf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wa ka -aɩn 'ylimanɩ sɔ weee lʋ. 'Ɩn -amɩaa mnɩbhla bɛa, -a -gblaa 'glʋ 'wʋ, -we weee -a 'nɩa -ka, 'ɩn wa yia we -aɩn 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","'Cʋ ta 'plɩa, 'ɩn -a yia Alɛzandlii 'glʋ yabhlo wa laa «-Zluya -Lagɔ» 'wʋ -gbla. 'Nyunyɩdɩdʋdʋʋ 'glʋʋ 'yligbelida yabhlo wee 'glʋ -tʋa 'yligbeda ŋwɔtlɔyibhla. ");
INSERT INTO kyf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","-A nynia Silakuzɩgbe 'wʋ, 'ɩn -a yia -bhadɛ -tʋ 'ylɩ ta. ");
INSERT INTO kyf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","-A 'bhʋa -bhadɛ, -a mɩ 'nyu -gɔgɔ nɔnʋda, 'ɩn -a yia Wleziogbe nʋkplɛ nyni. -Mʋʋ 'bɩgʋ, zlɩ zlɩa, 'ylʋʋ bhlilida kɔpɛsɔlʋʋ -pɩpɛ yia 'plɩplɩe bhlii 'gbʋ, -a li 'ylɩ 'sɔ 'yloogblʋ, 'bhie, -a yia Puzɔlʋgbe nʋkplɛ nyni. ");
INSERT INTO kyf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wee 'gbe nʋkplɛ -a ylɩa -Lagɔnyɩma, 'ɩn -maa nɛɛ, -a li wa -gbɛ lɔkɔwlu -bhlo. Sanɛɛ 'sa, -a mnɩa Wlɔmʋ. ");
INSERT INTO kyf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wlɔmʋʋ -Lagɔnyɩma 'nʋa nɩɩ, -a mɩ -mɔ yida, 'ɩn wa yia -aɩn yoo -saa yi tɩklɩɩ Apiusʋʋ lɔkɔ 'wʋ, we -yɔ wee 'gbee da wa laa 'Lakpanyaa Zɔgʋbudu Ta. Da Pɔlʋ 'yɩa wa -yɔ, ɔ 'paa -Lagɔ fuo, 'ɩn we yia ɔ 'kʋayli 'pa. ");
INSERT INTO kyf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Da -a nynia Wlɔmʋ, wa yia Pɔlʋ 'yoo 'nyɛ nɩɩ, ɔ -yɔ 'slʋjayu mɩa ɔ ŋwɛkʋda -dɩlɩ -budu yabhlo zɔ la wa 'dɛɛ sa. ");
INSERT INTO kyf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","'Ylɩ ta 'plɩa, 'ɩn Pɔlʋ yia Zuifʋ mɩa Wlɔmʋ, wa 'yugalɩnya la. Da wa gbelia 'wlu, 'ɩn ɔ nɛɛ wa -ylaɛ: «Na bheliaɩn, ɩn 'nɩ gbʋ yabhlogbɔɔ lɛnʋ, -amɩaa nyɩma -yɔ -amɩaa dʋkpasɩɩ lɛnʋgbʋ 'cɩnnyaa gbɛgbɛɩn, 'ɩn wa yia 'mɩ kpa -Zeluzalɛmʋ, 'ɩn wa yia 'mɩ Wlɔmʋ -nyɩma yoo 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Da -maa 'yɩbhaa 'mɩ la, -maa 'yɩbha yaa -maa 'ka 'mɩ 'yitide. -We ka gbʋ -wa, gbʋ -we ɩn nʋa lɛ, -we ka 'gbʋ wa 'kaa 'mɩ -kaslʋ 'wʋpa, 'ɩn wa 'ka 'mɩ 'bha, we 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Da -maa gbaa -maa 'ka 'mɩ 'yitide, Zuifʋ yia we -yɔwʋsɔlʋʋ 'gbʋ, mʋ 'sua 'mɩ, 'ɩn ɩn yia na gbʋ -nyɩmaa 'wlulapɩlɩnyɔ 'kadʋ 'yu kwa. 'Ɩn -zugba, ɩn 'nɩ 'yɩbha ɩn 'ka na nyɩma gbʋ 'wlu ladɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","-We ka 'gbʋ, ɩn yia aɩn la, 'ɩn ɩn 'ka aɩn -yla gbʋ gba, mʋ nɩ. Nɩɩ, nyɩmɛ -ɔ Izlaɛlɩnyɩma mɩa wʋda, ɔ 'gbʋ ɩn mɩa da gbʋan -llukpe -mɩnɩ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","'Ɩn Zuifʋ nɛɛ ɔ -ylaɛ: «-Na -yɔsɛbhɛ yabhlogbɔɔ 'nɩ -slɔ Zudee -dʋdʋ -gʋ 'bhʋ, 'ɩn we 'ka -amɩaa -gbɛ yi. 'Ɩn -amɩaa bheli yabhlogbɔɔ 'nɩ -slɔ mɔ 'bhʋ, ɔ 'ka -na gbʋnyuu gbaa yi -aɩn -yla. ");
INSERT INTO kyf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","-Mʋʋ bhla, -a 'yɩbha gbʋnya -na pʋpalɩa 'wlukʋʋn la, -ɩn gba we, -a 'ka we 'nʋ. -A -yi we 'ji nɩɩ, da weee, nyɩma sɔlʋa -na zʋa -yɔ 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Wa -yɔ Pɔlʋ yia 'ylɩ yabhlo zʋ, 'ɩn wee 'ylɩ nynia, da ɔ -gʋa, 'ɩn wa -zlo yia -bha yi. We 'ka zlʋkpɛ -yɔbhʋ, we 'ka jibhe ylɩ, Pɔlʋ yia -Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ gba wa -yla, 'ɩn ɔ yia wa -yla we 'ji gba. Ɔ 'yɩbha ɔ 'ka wa lu -Zezuu gbʋ nyaa 'gbʋ, ɔ yia Moizɩɩ tite -yɔ -Lagɔgbʋʋ -falɩpanyaa 'sɛbhɛ zɛlɩ wa -yla. ");
INSERT INTO kyf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Gbʋ ɔ mɩa gbada, we ka -zakpa -bhlo lu, 'ɩn tɔlʋa nɛɛ -maa 'nɩa we -yɔŋwnu. ");
INSERT INTO kyf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","'Ɩn wa mɩ kpɛlɩda, -zugba wa mnɩ. Pɔlʋ nɛɛ wa -yla bheɛ: «Zuzu 'Pʋpa ka zlɩmɛ zukpa, da ɔ gbaa amɩaa dʋkpasɩ -yla gbʋ -Lagɔgbʋʋ -falɩpanyɔ Ezaiii ŋwɛ nya! Ɔ nɛɛ nɩɩ: ");
INSERT INTO kyf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹-Ɩn mnɩ, -ɩn gba nyɩma nɩ -ylaɛ: «Gbʋnya a yia 'nʋa sa 'nanʋʋ, 'ɩn a 'na 'ka we 'ji 'wʋlanʋ. -Li a yia ylaa sa 'nanʋʋ, 'ɩn a 'na 'ka we -yɔyɩ.» ");
INSERT INTO kyf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Cɩɩn, waa nyɩma -manɩ ka wa dlɩ 'tɛmanɩ, wa ka wa yukwli 'wʋsulu, 'ɩn wa yia wa 'yli 'mu. Wa yi layɩ wa 'yli nya, wa yi 'nʋ wa yukwli nya, 'ɩn wa yi gbʋ 'wʋlanʋ wa dlɩ nya. Wa 'nɩ 'yɩbha wa 'ka na -gbɛ lʋbhiti, ɩn 'ka wa pue.› » ");
INSERT INTO kyf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","'Ɩn Pɔlʋ yi 'yaa we -gʋdɩɛ: «A yibheli we 'ji nɩɩ, nyɩma -wa 'nɩa Zuifʋ, -Lagɔ ka wa nyɩmaa gbʋwʋsawɛlɩ yoo 'pa. 'Nʋa -maa yia we.»  ");
INSERT INTO kyf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Da Pɔlʋ gbaa wɛlɩnya -mɩnɩ, Zuifʋ -yɔ kpɛlɩkpɛlɩe 'tɩtɛ yia mnɩ wa 'dɛkpʋa nyɩdɩ. ");
INSERT INTO kyf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","-Budu -we Pɔlʋ 'pɛnɩa, ɔ li we zɔ zʋ 'sɔ, 'ɩn -wa weee yia ɔ 'yɩa wee -budu zɔ, sɔ 'sɔ nya ɔ kpaa wa. ");
INSERT INTO kyf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","-Lagɔɔ nyɩmaa 'wlulapɩlɩgbʋ Pɔlʋ gbaa, 'ɩn ɔ slolua Nyɩmaa -Kanyɔ -Zezu Klisɩɩ gbʋ, dlɩ -tɛlɔ weee nya, sa -dlɔɔ.");
INSERT INTO kyf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","-Amɩ, -Zezu Klisɩɩ lubhonʋnyɔ, *Pɔlʋ, -amɩ cɛlɩa aɩn 'wʋ. -Lagɔ laa 'mɩ, ɩn 'ka ɔ *tietienyɔ -zɛ, mɔɔ -saa -bha 'mɩ ɔ gbʋʋ gbada. ");
INSERT INTO kyf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Wee -Lagɔgbʋ mɩa dɛ nɩ, -Lagɔ ka bha we gba ɔ gbʋʋ -falɩpanyaa gbɛgbɛɩn, 'ɩn wa yia we cɛlɩ *-Lagɔsɛbhɛ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ɔ 'Yuu -gʋgbʋ we gbaa. Nɩɩ, 'mɔ wa gwalɩa ɔ dʋkpasa, nyɩmaa 'wlulapɩlɩnyɔ *-Davidɩɩ zʋayli, nyɩmɛ -kpʋa 'bhisa. ");
INSERT INTO kyf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Zuzu 'Pʋpa -slolua 'tɩtɛ nya nɩɩ, mɔ -wa -Lagɔɔ Yu, ɔ ka tlɩtlɩnya glaa 'wʋsɔɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ɔɔ -amɩaa -Kanyɔ -Zezu Klisɩ mɩa nɩ, ɔ gbɛgbɛɩn -Lagɔ nʋa -aɩn 'nanɩ 'wʋ, 'ɩn -a yia ɔ tietienya -zɛ ɔ 'ŋnɩɩ 'gbʋ -a 'ka dʋdʋgʋ -nyɩma weee ɔ 'tɩtɛ -slolu, 'ɩn wa 'ka ɔ wɛlɩ 'nʋŋwɛ zʋ dlɩzʋzʋe nya. ");
INSERT INTO kyf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","-Wa ɔ -saa -bha wa 'ka ɔ wɛlɩ 'nʋŋwɛ zʋ, a mɩ wa glaa, -we ka gbʋ -wa, ɔ ka 'ya amɩa la -Zezu Klisɩɩ -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Amɩa weee, -mɔ *Wlɔmʋ, amɩa -wa ka zɛ -Lagɔ -kalɩ, 'ɩn amɩa -wa ɔ laa a 'ka -mɩ tɩklɩɩ, nɩɩ, -amɩaa Dide -Lagɔ -yɔ -amɩaa -Kanyɔ -Zezu Klisɩ ŋwna aɩn 'nyu la, 'ɩn wa 'nyɛ aɩn 'wʋtʋtʋe -dlɔɔ. ");
INSERT INTO kyf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tɩatɩa mɩa, -Lagɔ na paa fuo -Zezu Klisɩɩ 'ŋnɩ nya, a 'dɛ weee 'gbʋ. -We ka gbʋ -wa, dlɩ a zʋa, we 'dɩ ka 'gbe weee -gʋlamneni. ");
INSERT INTO kyf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","-Lagɔ, -ɔ ka lubho ɩn mɩa nʋda na dlɩ weee nya -Lagɔgbʋʋ gbagbɩe nya, ɔ -yi we 'ji nɩɩ, -we na gbaa gbʋzɔnʋ -wa. We 'gbʋ, ɩn -ka -Lagɔ bhubhoeda -mɩ, amɩaa 'ŋnɩ'ɩ bɔ -mɔ. ");
INSERT INTO kyf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Zlabhuezɔ, na bhubhoea ɔ, ɔ 'ka 'mɩ 'yoo 'nyɛ, ɩn 'ka amɩaa -gbɛ mnɩ. ");
INSERT INTO kyf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nɩɩ, amɩaa 'yɩyɩee 'tʋ mɩ 'mɩ 'bhada. Ɩn -ka amɩaa -gbɛ yi, -Lagɔɔ Zuzuu wlawlalu a yia 'yɩa na gbɛgbɛɩn, 'ɩn a 'ka dlɩ 'tɛmanɩ. ");
INSERT INTO kyf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nɩɩ, ɩn 'yɩbha ɩn -mɩ aɩn glaa, 'ɩn -a 'ka 'kʋayli 'pʋpalɩ nanʋʋ dlɩzʋzʋe -yɔ amɩaa -nʋ 'sɔɔ gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bheliaɩn, -we ɩn 'yɩbhaa a yibheli 'ji, mʋ -wa nɩɩ, amɩaa -gbɛ na yi yaa yia -zakpa duun, 'ɩn ɩn 'nɩ -slɔ we 'yoo 'yɩ. Ɩn -ka -mɔ nyni nɩ, ɩn 'yɩbha nɩɩ, na lubho mɩa, sa we 'yɩa -tnʋʋ laga -dʋdʋ -putu -gʋ, we nʋ 'ya 'sa amɩanʋʋ -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","-We ɩn 'kaa lɛnʋ, mʋ -wa nɩɩ, ɩn mnɩ dʋdʋ weee -gʋ, -wa ka 'yli -bloa klaa, -wa ka 'yli 'nɩa -blo klaa, -wa -yia 'sɛbhɛ we -yɔ -wa 'nɩa we -yi, wa -gbɛ. ");
INSERT INTO kyf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","We mɩ 'saa 'gbʋ nɩ, na dlɩ mɩ amɩaa -gbɛ nynida -mɔ Wlɔmʋ, ɩn 'ka aɩn -yla -Lagɔgbʋ gba. ");
INSERT INTO kyf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nɩɩ, ɩn -ka -Lagɔgbʋ gbada -mɩ, we'e 'bhalɩ 'mɩ zʋ. -Lagɔɔ 'tɩtɛ -wa, 'ɩn -wa zʋa ɔ dlɩ -gʋ, 'ma ɔ saa gbʋ 'wʋ: *Zuifʋ ɔ saa gbʋ 'wʋ tɩa, 'bhie ɔ saa nyɩmaa pnɩɩ gbʋ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","-We wee -Lagɔgbʋ slolua, mʋ nɩ: nyɩma -wa zʋa ɔ dlɩ -gʋ, nyɩma tɩklɩɩ nya ɔ bhua wa 'wʋ. Dlɩzʋzʋe -bhlogbɔɔ nya nyɩmɛ bhʋa gbʋ 'wʋ. We mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: «-Ɔ -Lagɔ yibhelia nyɩmɛ tɩklɩɩ nya dlɩzʋzʋee 'gbʋ, 'yliyɔgagɩe -mɔɔ yia 'yɩa.» ");
INSERT INTO kyf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nɩɩ, -Lagɔ mɩ ɔ 'cɛ -we bhʋa yalɩ -sloluda, -we ka gbʋ -wa, dʋdʋgʋ -nyɩma mɩ gbʋnyuu lɛnʋda, 'ɩn -we wa nʋa lɛ, we 'nɩ tɩklɩɩ -mɩ. 'Ɩn wa lɛnʋgbʋ 'nyii nya wa tuntnua -Lagɔɔ gbʋzɔnʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nɩɩ, -we -yɔ wa mnenia wa 'ka -Lagɔɔ gbʋ yibheli, we mɩ wa 'yu: -Lagɔ ka we wa 'klʋslolu 'nanʋʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","-Lagɔɔ 'tɩtɛ, we'e bhɩa, 'ɩn wa'a 'yɩ we -yɔ, 'ɩn sa -Lagɔ mɩa, wa 'nɩ mneni wa 'ka 'sa ɔ -yɔyɩ. Nɩɩ, da -Lagɔ -laa dʋdʋ la, wa mneni wa 'ka wee gbʋ yibheli. -A -ka -Lagɔɔ lalalu yla, -amɩaa 'wlukʋʋn mneni we 'ka -Lagɔ -yɔ ɔ 'tɩtɛ -yɔyɩ. We 'gbʋ nyɩma 'nɩ zizelida -ka. ");
INSERT INTO kyf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Wa yibhelia -Lagɔ, wa 'nɩ ɔ 'ŋnɩ -mnɩnɩ, 'ɩn wa 'nɩ ɔ fuo 'pa. 'Ɩn, 'mʋ nyɩmɛ 'ka yaa -Lagɔ -yla lɛnʋ. -Slɛɛn, wa 'wlukʋʋn lapʋpalɩe bhe, wa 'nɩ gbʋyilo dlɩ -ka, we mɩ nikpise 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wamɩa nɛɛ, wa -yi gbʋ, 'ɩn -zugba wa nʋ -sabhɛbhagbʋ lɛ. ");
INSERT INTO kyf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","-Lagɔ, -ɔ'ɔ tlɩa, -ɔ ka 'ŋnɩ wa 'kaa -mnɩnɩ, wa tɩ -bha -mɔɔ, 'ɩn wa bʋbɔa tɛlɩtɛlɩli -we 'wlʋa nyɩma -wa tlɩtlɩe mnenia -yɔ blublunɩma klaa, 'lalimnʋanɩma klaa, we -yɔ dlɩɩnɔnʋnɩma. ");
INSERT INTO kyf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","-We mɩa dɛɛ 'gbʋ, -Lagɔ yia wa kwɛbɩsa wa dlɩwʋnynili 'bɩ, 'ɩn wa plalɩa wa 'dɛ pʋɩn, zʋbhalɩgbʋʋ lɛnʋe nya. ");
INSERT INTO kyf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wa ka -Lagɔɔ gbʋzɔnʋ -blɩgʋpalɩ, 'ɩn wa yia yonya -yɔŋwnu. 'Ɩn -Lagɔ -ɔ ka 'ŋnɩ nyɩma 'kaa 'ylimanɩ sazɔnʋ sa 'ylɩ weee nya, wa yia -bha -mɔɔ 'dɛ tɩ, -zugba wa bʋbɔ ɔ lalali ɔ 'bɩgʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","We 'dɛɛ 'gbʋ -Lagɔ yia wa kwɛbɩsa wa zʋbhalɩ gbʋʋ 'tʋ 'bɩ. Nɩɩ, wa 'ŋwnɩ -yɔ wa 'lowlia'a -dɩ -slɛɛn -budu 'wʋ, 'ŋwnɩ -putu wa -yɔ wa dɩa -budu 'wʋ. 'Sasʋkpa gbʋʋ lɛnʋe mɩa, we 'nɩ 'ylinanɩ dʋdʋ -gʋ. ");
INSERT INTO kyf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","'Sa -bhlokpadɛ nʋkpasia -yɔ wa 'ŋwnɩ'ɩ -dɩa -budu 'wʋ. Nʋkpasiaa tʋ bhaa wa. Wa -lima wa -yɔ wa dɩa -budu 'wʋ, zʋ we kaa. -We mɩa dɛɛ 'gbʋ, -lu -we ka 'klʋ wa lɛnʋgbʋ 'nyuu kaa, 'mʋ wa yɩa. ");
INSERT INTO kyf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nɩɩ, wa 'nɩ ŋwnu wa 'ka -Lagɔ yibhelii 'gbʋ, ɔ yia wa kwɛbɩsa wa 'ka wa 'dɛɛ 'wʋkanɔ gbʋ lɛnʋ. 'Ɩn -we nyɩmɛ 'na 'kaa lɛnʋ, 'ɩn wa nʋa we lɛ. ");
INSERT INTO kyf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","'Ylinyunogbʋʋ 'yli -bhlo -bhlo yea wa: nyɩma 'nyii wa -mɩa, wa -limaa kwɛlu wa dlɩ nynia 'wʋ, wa nʋkplɛ -nyu 'yli. Zenyi yea wa dlɩ zɔ, 'ɩn nyɩma -bhabhɩe nanɩa wa dʋdʋ. Wa ka -zlɛ, wa -lima wa nʋa -dawli 'wʋ, gbʋkpʋa -gbʋ wa nʋa lɛ. Nyɩma wa saa 'ŋnɩ, ");
INSERT INTO kyf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","gbʋnyuu wa gbaa wa -limaa gbɛgbɛɩn, -Lagɔɔ tʋnyɩma wa -mɩa, wa -lima wa vɛlɩa, wa 'dɛ wa ylimanɩa, wa 'dɛ wa ylɩlɩa, nacɩ weee da wa talɩa wa 'ka gbʋnyuu lɛnʋ. Wa'a zʋ wa dide -yɔ wa 'nyaa 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Wa 'nɩ 'wlukʋʋn -ka, wa'a nɔ wa 'dɛɛ gbagbawɛlɩ -gʋ, wa 'tɛ, wa 'nɩ nyazɩdlɩ -ka. ");
INSERT INTO kyf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wa -yi -Lagɔɔ gbʋwʋbhubhue 'ji: -wa nʋa we 'sasʋkpa -gbʋ nɩ lɛ, tlɩtlɩe -wa wa -nʋ. We mɩ 'sa 'bhie, -zugba wa nʋ we lɛ, 'ɩn 'dɛbhie, tɔlʋa -ka we lɛnʋda -mɩ, 'ɩn wa ŋwnunu 'yaa -maa. ");
INSERT INTO kyf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","We 'dɛɛ 'gbʋ, -mɩ bhua dɛ -na nyɩmaa -yɔgbʋ 'wʋ, nyɔɔo nyɔɔ -ɩn -ka -mɩ, -ɩn 'nɩ zizelida -ka. Nyɩmaa -yɔgbʋ -na bhua 'wʋ, 'ɩn -we wa nʋa lɛ, mʋ -bhlokpadɛ -na nʋa lɛ. Nɩɩ, -ɩn -ka wa -yɔgbʋ 'wʋbhu, -na 'dɛ -ɩn -luelia gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","'Ɩn -a -yi we 'ji nɩɩ, -wa nʋa 'sasʋkpa gbʋ lɛ, -Lagɔ bhua wa -yɔgbʋ 'wʋ sazɔnʋ sa. ");
INSERT INTO kyf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","-Mɩ, -mɩ bhua -wa nʋa we 'sasʋkpa gbʋ lɛɛ -yɔgbʋ 'wʋ, 'ɩn -we wa nʋa lɛ, 'mʋ -na nʋa lɛ. Nɩɩ, -mɩ dlɩ 'wʋ nɩɩ, -Lagɔɔ gbʋwʋbhubhue yia -mɩ -gʋzia yɩ? ");
INSERT INTO kyf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","-Lagɔ ka 'nanɩ bhabha, ɔ dlɩ tie, ɔ yi wʋsa. 'Lee, nyanɩ -na nyanɩa ɔ yɩ? 'Lee, -ɩn 'nɩ we 'ji -yi nɩɩ, -Lagɔ -ka sa 'nanɩ -ka -na daa, nɩɩ, -ɩn 'ka -na dlɩ 'bhitii gbʋ -waa? ");
INSERT INTO kyf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","-Ɩn -su yukwli -yɔ, -ɩn 'nɩ 'yɩbha -ɩn 'ka -na dlɩ 'bhiti. We 'dɛɛ 'gbʋ -na zumanɩa -Lagɔɔ 'cɛ 'wʋ -na 'dɛ -yɔ. Wee cɛ mɩa, -Lagɔɔ nyɩmaa -yɔgbʋ 'wʋbhu -zlɩ, -na yɩa we. Nɩɩ, we zlɩ -Lagɔ yia nyɩmaa -yɔgbʋ 'wʋbhubhue -slolua sazɔnʋ sa. ");
INSERT INTO kyf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","-We nyɩmɛ -ka lɛnʋ, we -tnʋʋ ɔ yia 'yɩa -Lagɔ kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nɩɩ, nyɩma tɔlʋa -wa tɛmanɩa dlɩ gbʋzɔnʋʋ lɛnʋe 'bɩ, -wa talɩa 'ŋnɩmnɩe klaa, 'ŋnɩkwalɩe klaa, we -yɔ 'yliyɔgagɩee da -Lagɔ kwɛɛ, 'yliyɔgagɩe -we 'nɩa bhloluda -ka, 'mʋ -Lagɔ yia wa 'nyɛa. ");
INSERT INTO kyf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","'Ɩn, nyɩma -putu -wa sɔlʋa -Lagɔ -yɔ 'wʋ, -wa'a zʋa ɔ gbʋzɔnʋ 'nʋŋwɛ, 'ɩn wa zʋa 'ylinyunogbʋ 'nʋŋwɛ, ma -yɔ -Lagɔ yia ɔ 'cɛ 'kadʋ 'paa. ");
INSERT INTO kyf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Sɩasɩe 'kadʋ -yɔ dlɩsulo yia nyɩma weee -wa nʋa gbʋnyuu lɛ bhɩtɩa. Zuifʋ -gʋ we yia gwedɩlɩa, 'bhie we 'ka -wa 'nɩa Zuifʋ -gʋ nyni. ");
INSERT INTO kyf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","'Ɩn -wa nʋa gbʋzɔnʋ lɛ, wa 'ŋnɩ -Lagɔ yia -mnɩnɩa, 'ɩn ɔ 'ka wa 'ŋnɩ kwalɩ, 'bhie ɔ 'ka wa 'wʋtʋtʋe -dlɔɔ 'nyɛ. Zuifʋ -gʋ we yia gwedɩlɩa, 'bhie we 'ka -wa 'nɩa Zuifʋ -gʋ nyni. ");
INSERT INTO kyf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nɩɩ, -Lagɔ mɩa, ɔ'ɔ gbɩzɩ nyɩma 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","-Wa 'nɩa *Moizɩɩ tite -yi, 'ɩn wa nʋa gbʋnyuu lɛ nɩ, wa 'nɩ we -yioo, tlɩa -maa yi 'yaa. 'Ɩn -wa weee -yia wee tite, 'ɩn wa nʋa gbʋnyuu lɛ, wee titee gbɛgbɛɩn -Lagɔ yia wa -yɔgbʋ 'wʋbhua. ");
INSERT INTO kyf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nɩɩ, -wa mɩa tɩklɩɩ -Lagɔ 'yu, ma -wa nyɩma -wa zʋa tite 'nʋŋwɛ, we 'nɩ nɩɩ, -wa pʋlʋa we yukwli, 'ɩn wa'a nʋa we -gʋgbʋ lɛ. ");
INSERT INTO kyf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","'Ɩn, -wa 'nɩa Zuifʋ, wa 'nɩ tite -yi. We mɩ 'sa 'bhie, -we wee tite gbaa, tɔlʋa nɔa we -gʋ. Waa nyɩma mɩa, wa 'nɩ tite -ka. Wa 'dɛ -wa wa 'dɛɛ tite. ");
INSERT INTO kyf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Wa nɔnɔbhʋ slolua nɩɩ, lɛnʋgbʋ -we tite 'yɩbhaa, we mɩ cɛlɩda -mɔ wa dlɩ zɔ. Wa 'wlukʋʋn mɩ we dayɩnyɔ nya. Mʋ nya wa 'dɛɛ 'wlukʋʋn lapʋpalɩe bhua wa -yɔgbʋ 'wʋ, nɩɩ, wa ka gbʋnyuu lɛnʋ, nɩɩ, wa ka gbʋzɔnʋ lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Gbʋwʋbhu zlɩ, wa yia we -yɔyɩa. Nɩɩ, -Lagɔgbʋ ɩn mɩa da gbada, we nɛɛ nɩɩ, we zlɩ, -we weee nyɩma zizea, -Lagɔ yia we gbʋ 'wʋbhua -Zezu Klisɩɩ gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nɩɩ, -mɩ, -mɩ laa -na 'dɛ Zuifʋ, 'ɩn -na dɩa tite dlɩ 'wʋ, 'ɩn -na bhua -na 'dɛ 'wʋ 'kadʋʋ, -na -Lagɔɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","-Ɩn -yi -Lagɔɔ dʋmagbʋ, 'ɩn tite ka -mɩ -slolu nɩɩ, -we mɩa 'nanʋʋ -ɩn yibheli we. ");
INSERT INTO kyf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","'Ɩn -na bhua -na 'dɛ 'wʋ 'lɔlɔnyaa 'yoo da -slolunyɔ nya, we -yɔ -wa mɩa nikpise 'wʋ wa zlɩ nya. ");
INSERT INTO kyf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","-Ɩn nɛɛ nɩɩ, -wa 'nɩa 'sɛbhɛ -yi, -mɩ -wa wa -slolunyɔ, 'ɩn -ɩn mɩa 'nyɛnyɛyuaa 'yliyɔzʋnyɔ nya, -we ka gbʋ -wa, -ɩn mɩ we -gʋ nɩɩ, tite slolua -mɩ gbʋzɔnʋ -yɔ -luyilo sa tɩklɩɩ. ");
INSERT INTO kyf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nɩɩ, -mɩ slolua nyɩma. Lɛɛ -lu ka 'gbʋ, -ɩ'ɩn -slolu -na 'dɛa? -Ɩn nɛɛ wa -ylaɛ: «A 'na ylili 'wie -nɩ», 'ɩn -zugba -mɩ, -na 'dɛ -na yli 'wiee? ");
INSERT INTO kyf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","-Ɩn nɛɛ: «-Ɩn -yɔ 'ŋwnɔ -putu 'na -dɩlɩ -budu 'wʋ -nɩ », 'ɩn -mɩ -na nʋa we lɛ yɩ? Yoyolagɔ -na nyɛa 'wʋ, 'ɩn -na ylia -we mɩa wa yoyolagɔɔ -budu zɔ yɩ? ");
INSERT INTO kyf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","-Na 'dɛ -na bhua 'wʋ titee yilonyɔ nya, 'ɩn -ɩ'ɩn zʋ we 'nʋŋwɛ. -Ɩn -ka 'sa nʋda -mɩ nɩ, -Lagɔɔ 'ŋnɩ -na bɛlɩa zɔ. ");
INSERT INTO kyf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: «Amɩaa 'gbʋ, -wa 'nɩa Zuifʋ, 'ɩn wa gbaa -Lagɔɔ 'ŋnɩ 'nyuu.» ");
INSERT INTO kyf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Knɩ 'wʋpapɩe mɩa, -ɩn -ka Moizɩɩ tite 'nʋŋwɛ zʋ, we ka 'ji. 'Ɩn -ɩn 'nɩ wee tite 'nʋŋwɛ zʋ, we 'wlʋ sa wa 'nɩ yaa -mɩ *knɩ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Sa 'bhisa, wa 'nɩ nyɩmɛ yabhlo knɩ 'wʋpa, 'ɩn -zugba ɔ zʋ -we tite yɩbhalɩa nyɩmɛ 'nʋŋwɛ, 'lee, -Lagɔ 'na 'ka ɔ 'wʋbhu nyɩmɛ wa 'paa knɩ 'wʋ 'bhisaa? ");
INSERT INTO kyf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nyɩmɛ, -ɔ wa 'nɩa knɩ 'wʋpa ku -yɔ, 'ɩn ɔ zʋa tite 'nʋŋwɛ sazɔnʋ sa, -mɩ'ɩ zʋa da tite 'nʋŋwɛ, mɔ yia -na -yɔgbʋ 'wʋbhua. 'Ɩn -zugba wa ka -mɩ knɩ 'wʋpa, 'ya tite -we mɩa cɛlɩda, we mɩ -mɩ kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nɩɩ, -ɔ mɩa Zuifʋʋ 'zayli nya, we 'nɩ nyɩmɛ -ɔ wa yibheli ku -yɔ, 'ɩn wa 'pa knɩ 'wʋ ku -yɔ, mɔ. ");
INSERT INTO kyf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Zuifʋʋ 'zayli mɩa nɩ, -mɔ ɔ 'wʋ wa yibhelia we. -We -wa *knɩ 'wʋpapɩee 'zayli nɩ, mʋ -wa dlɩɩ -nʋ, -Lagɔɔ Zuzuu -gbɛ we bhʋa, nɩɩ, we'e 'bhʋ tite -we mɩa cɛlɩdaa -gbɛ. Ɔɔ nyɩmɛ mɩa nɩ, we 'nɩ nyɩma kwalɩ ɔ 'ŋnɩ, -Lagɔ kwalɩa ɔ 'ŋnɩ. ");
INSERT INTO kyf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","'Lee, Zuifʋ mɩa, lɛɛ -lu -zɔnʋ ɔ ka, -we -zi -ɔ 'nɩa Zuifʋa? 'Lee, knɩ 'wʋpapɩe ka 'jii? ");
INSERT INTO kyf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Cɩɩn, we nanɩ 'yli da weee. Tɩada mɩa, Zuifʋ -yla -Lagɔ wlaa ɔ wɛlɩ. ");
INSERT INTO kyf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Zuifʋ tɔlʋa 'nɩ yaa -Lagɔɔ wɛlɩ -gʋ nɔ, 'lee, -a yi yaa gba nɩɩ, -Lagɔ 'na 'ka ɔ wɛlɩ -gʋ -tʋʋ? ");
INSERT INTO kyf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","-Ɩnnya, we 'nɩ sa -mɩ. -A yibheli we 'ji nɩɩ, -Lagɔ mɩa, gbʋzɔnʋ -gbanyɔ -wa, -zugba nyɩma weee ka yo. -Lagɔsɛbhɛ ka we -gʋgbʋ gba -Lagɔɔ daɛ: «Wa yibheli -mɩ tɩklɩɩ -na gbagbawɛlɩ 'wʋ, 'ɩn wa -ka -mɩ gbʋwʋbhuda kwa, 'ɩn -na galɩa wa -gʋ.» ");
INSERT INTO kyf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Gbʋnyuu -we -a nʋa lɛ, mʋ slolua nɩɩ, -Lagɔ tɩklɩɩ. We -ka 'sa -mɩ, -Lagɔ -ka -aɩn 'cɛ -yɔpalɩ nɩ, 'lee, -a mneni -a 'ka gba nɩɩ, -Lagɔ 'nɩ tɩklɩɩ -mɩɩ? (Ɩn -ka 'sa gba, dʋdʋgʋ -nyɩma 'bhisa ɩn gbaa we.) ");
INSERT INTO kyf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","-Ɩnnya, we 'nɩ 'sa -mɩ. -Lagɔ 'nɩ yaa tɩklɩɩ -mɩ, sa ɔ 'ka nyɩmaa -yɔgbʋ 'wʋbhua? ");
INSERT INTO kyf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","'Ɩn na yotʋbhʋe -ka -slolu nɩɩ, -Lagɔ gbaa gbʋzɔnʋ, 'ɩn nyɩma -ka ɔ 'ŋnɩ -mnɩnɩ we 'gbʋ, lɛɛ -lu ka 'gbʋ ɔ dɩlɩ 'mɩ gbʋ, gbʋnyuu -lɛnʋnyɔ 'bhisaa? ");
INSERT INTO kyf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","'Sa tɔlʋa vɛlɩa -aɩn, 'ɩn wa gbaa nɩɩ, -amɩa nɛɛ: «-A nʋ gbʋnyuu lɛ, 'ɩn zʋzɔnʋ -nʋ 'ka -bha 'tlalɩ!» Nɩɩ, -maa -cɩan mɩa dɛ, -kaslʋ 'wʋpapɩe mɩ wa -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Saa nya? 'Lee, -amɩa Zuifʋ 'ylia, -amɩa -zia nyɩma tɔlʋa yɩ? -Ɩnnya, we 'nɩ 'sa -mɩ. Ɩn ka 'cɩn we -slolu nɩɩ, Zuifʋ -yɔ nyɩma -putu, gbʋnyuu ka 'tɩtɛ wa 'dɛ weee -gʋ. ");
INSERT INTO kyf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nɩɩ, we mɩ cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: «Nyɩmɛ -ɔ mɩa tɩklɩɩ, ɔ 'nɩ -mɩ. Nyɩmɛ yabhlogbɔɔ 'nɩ tɩklɩɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nyɩmɛ yabhlogbɔɔ 'nɩ gbʋyilonyɔ nya -mɩ. Nyɩmɛ yabhlogbɔɔ'ɔ -talɩ -Lagɔɔ da. ");
INSERT INTO kyf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Nyɩma weee ka 'yoo -zɔnʋ -gʋlabhʋlʋ, wa ka -nyumo. Nyɩmɛ -ɔ 'kaa gbʋzɔnʋ lɛnʋ, ɔ 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","-We tlaa wa ŋwɛɛ we 'wlʋ, gbawla -kalɩ ŋwɛ. Wa mɩɔ nya wa nʋa wa -lima -dawli 'wʋ. -We tlaa wa ŋwɛɛ, 'mʋnɩmɛɛ -dlɛ -wa. ");
INSERT INTO kyf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Mɛlatɩwɛlɩ 'nyuu yea wa ŋwɛɛ. 'Ɩn wa wɛlɩ nʋa nyɩmɛ lɛ. ");
INSERT INTO kyf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","-Gwagwɩe nya wa mnɩa nyɩmɛ 'bhaa. ");
INSERT INTO kyf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Da wa -ka 'plɩlɩ, -lu wa saa la, 'ɩn wa tɩa -bha sɩasɩe. ");
INSERT INTO kyf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Wa 'nɩ 'wʋtʋtʋe -dlɔɔɔ 'yoo -yi. ");
INSERT INTO kyf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","-Lagɔɔ sɔsʋe 'nɩ wa dlɩ zɔ -mɩ.» ");
INSERT INTO kyf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","-A -yi we 'ji nɩɩ, -we weee tite gbaa, -wa -yia tite, wa -nʋ nya we mɩa. We -ka 'sa -mɩ nɩ, nyɩmɛ yabhlogbɔɔ 'nɩ zizelida -ka. Nɩɩ, nyɩma weee ka gbʋnyuuu 'gba 'wlu -Lagɔ 'yu. ");
INSERT INTO kyf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","We 'dɛɛ 'gbʋ, -Lagɔ 'na 'ka nyɩmɛ yabhlogbɔɔ 'yɩ nyɩmɛ tɩklɩɩ nya titee 'nʋŋwɛzʋzʋee 'ylibɩlanɔnʋe nya. -We tite nʋa lɛ, mʋ slolua nɩɩ, gbʋnyuu -lɛnʋnya nyɩma -mɩa. ");
INSERT INTO kyf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","'Ɩn -slɛɛn mɩa, sa -Lagɔ 'kaa -aɩn nyɩma tɩklɩɩ -zɛlɩ, ɔ ka we -aɩn 'klʋslolu. Ɔ -ka -aɩn nyɩma tɩklɩɩ -zɛlɩa yi, ɔ'ɔ yla -amɩaa titee 'nʋŋwɛzʋzʋee 'ylibɩlanɔnʋe. Nɩɩ, tite -yɔ *-Lagɔgbʋʋ -falɩpanya mɩ we gbʋdayɩnya nya, wa ka bha we gba: ");
INSERT INTO kyf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","-Zezu Klisɩɩ dlɩgʋzʋzʋee gbɛgbɛɩn -Lagɔ nʋa nyɩmɛ tɩklɩɩ. -Wa weee zʋa Klisɩ dlɩ -gʋ, 'ma ɔ nʋ 'saa. -We ka gbʋ -wa, 'wʋgbɩzɩe 'nɩ wa nyɩdɩ -mɩ: ");
INSERT INTO kyf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","nɩɩ, nyɩma weee ka gbʋnyuu lɛnʋ. Nyɩmɛ yabhlogbɔɔ 'nɩ -Lagɔɔ 'ŋnɩmnɩe -yɔcɩpa. ");
INSERT INTO kyf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nɩɩ, -Lagɔ mɩa, ɔ zʋzɔnʋ nya, ɔ nʋa nyɩmɛ tɩklɩɩ sa bhe, -Zezu Klisɩɩ gbɛgbɛɩn. Mɔ saa nyɩma gbʋnyuuu gaylo 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","-Lagɔ 'yɩbha nɩɩ, -Zezu slu ɔ 'pɩɔn la 'slaka 'bhisa. 'Ɩn ɔ 'slaka nya, -Zezu yia nyɩmaa gbʋnyuu lamumni, 'ɩn -wa zʋa ɔ dlɩ -gʋ, wa 'ka tɩklɩmɩmɩe 'yɩ. Sanɛɛ -Lagɔ 'yɩbhaa ɔ 'ka -slolu nɩɩ, ɔ mɩ tɩklɩɩ. Nɩɩ, ɔ ka dlɩtie lɛnʋ bha, 'ɩn ɔ 'nɩ we bhla nyɩma -kaslʋ 'wʋpa wa gbʋnyuu lɛnʋee 'gbʋ. 'Ɩn -slɛɛn mɩa, -Lagɔ slolua nyɩma nɩɩ, ɔ mɩ tɩklɩɩ, 'ɩn ɔ 'ka nyɩma, -wa zʋa -Zezu dlɩ -gʋ, tɩklɩɩ nʋ. ");
INSERT INTO kyf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","'Ɩn -amɩa ka -bha wɛlɩ yabhlo -a 'ka -amɩaa 'dɛ 'ylimanɩɩ? -Ɩnnya, we 'nɩ 'sa -mɩ. Lɛɛ -lu ka 'gbʋa? -We ka gbʋ -wa, -we nanɩa 'yli, we 'nɩ titee 'nʋŋwɛzʋzʋee 'ylibɩlanɔnʋe -amɩaa 'dɛɛ lagʋgʋe nya, nɩɩ, -Zezu dlɩgʋzʋzʋe -wa. ");
INSERT INTO kyf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","-We -gʋ -a pʋpalɩa 'wlukʋʋn la, mʋ nɩ: nyɩma mɩ tɩklɩɩ -Lagɔ 'yu, -we ka gbʋ -wa, wa ka -Zezu dlɩ -gʋ zʋ. We 'nɩ titee 'nʋŋwɛzʋzʋee 'gbʋ -Lagɔ yi wa 'yɩ nyɩma tɩklɩɩ nya ɔ 'dɛ 'yu. ");
INSERT INTO kyf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Nɩɩ, -Lagɔ mɩa, Zuifʋ -bhlogbɔɔɔ -nʋ ɔ -mɩa yaayɩɩ 'lakpanyaa -Lagɔ ɔ -mɩ 'yaa yɩ? 'Lakpanyaa -Lagɔ ɔ -mɩ 'yaa: ");
INSERT INTO kyf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","nɩɩ, -Lagɔ mɩ -bhlogbɔɔɔ 'gbʋ nɩ, mɔ yia Zuifʋ nyɩma tɩklɩɩ -zɛlɩa wa dlɩzʋzʋee 'gbʋ, 'ɩn mɔ -bhlokpadɛ yia 'lakpanya nyɩma tɩklɩɩ -zɛlɩa wa dlɩzʋzʋee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","'Lee, we -ka 'sa -mɩ nɩ, dlɩzʋzʋe -gʋ, tite mɩ bhee? -Ɩnnya, we 'nɩ 'sa -mɩ, mʋ nʋa we lɛ, 'ɩn tite kaa 'nʋŋwɛ. ");
INSERT INTO kyf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","We -ka 'sa -mɩ, sa -a 'ka -amɩaa dʋkpasa *Ablaamʋʋ daa gbaa? Lɛɛ -lu ɔ 'yɩ ɔ lɛnʋgbʋ 'wʋa? ");
INSERT INTO kyf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nɩɩ, -Lagɔ -ka yaa Ablaamʋ yibheli nyɩmɛ tɩklɩɩ nya ɔ lɛnʋgbʋ 'wʋ, ɔ mneni ɔ 'ka ɔ 'dɛ 'ylimanɩ. 'Bhie, we 'nɩ -Lagɔ yu. ");
INSERT INTO kyf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nɩɩ, -Lagɔwɛlɩ nɛɛ: «Ablaamʋ ka -Lagɔ dlɩ -gʋ zʋ. Ɔ dlɩzʋzʋee 'gbʋ -Lagɔ yia ɔ yibheli nyɩmɛ tɩklɩɩ nya.» ");
INSERT INTO kyf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nɩɩ, nyɩmɛ -ka lubho nʋ nɩ, 'pɛnɩ wa pɛnɩa ɔ, 'ɩn -we ɔ 'yɩa, we 'nɩ bhe ɔ 'yɩ we, ɔ ka we 'klʋ. ");
INSERT INTO kyf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nɩɩ, nyɩmɛ -ɔ'ɔ dɩa ɔ lɛnʋ -lubho dlɩ 'wʋ, -Lagɔ, -ɔ zɛlɩa gbʋnyuu -lɛnʋnya nyɩma tɩklɩɩ, 'ɩn ɔ zʋa dlɩ -gʋ nɩ, ɔɔ nyɩmɛ mɩa, -Lagɔ yibhelia ɔ nyɩmɛ tɩklɩɩ nya ɔ dlɩzʋzʋee 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","'Sa -bhlokpadɛ, -Davidɩ gbaa ɔɔ 'wʋtʋtʋe -dlɔɔ -nyɩmɛɛ gbʋ, 'mɔ -Lagɔ yɩa nyɩmɛ tɩklɩɩ nya, we 'nɩ ɔ lɛnʋgbʋʋ gbʋ. Ɔ nɛɛ: ");
INSERT INTO kyf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«'Wʋtʋtʋe -dlɔɔ -nyɩma, ma nɩ: -wa ka -yɔgbʋ -Lagɔ tɩa 'wʋ, 'ɩn ɔ yia wa gbʋnyuu lamumni, ma -wa. ");
INSERT INTO kyf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","'Wʋtʋtʋe -dlɔɔ -nyɩmɛ mɩa, mɔ nɩ: Jejitapɛ'ɛ yla -slɛɛn ɔ gbʋnyuu.» ");
INSERT INTO kyf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Wee 'wʋtʋtʋe -dlɔɔ mɩa nɩ, 'lee, Zuifʋ -bhlogbɔɔɔ -nʋ -wa yɩ? -Ɩnnya, -wa 'nɩa Zuifʋ wa -nʋ -wa 'ya . -A nɛɛ nɩɩ: «Ablaamʋ ka -Lagɔ dlɩ -gʋ zʋ, 'ɩn -Lagɔ yia ɔ yibheli nyɩmɛ tɩklɩɩ nya.» ");
INSERT INTO kyf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Lɛɛ -bhla -Lagɔ gba nɩɩ, Ablaamʋ mɩ nyɩmɛ tɩklɩɩ nyaa? Da wa 'nɩa -slɔ ɔ *knɩ 'wʋpa -wa yaayɩɩ da wa 'paa ɔ knɩ wʋ -wa yɩɩ? We 'nɩ nɩɩ, da wa 'paa ɔ knɩ wʋ. Da wa 'nɩa -slɔ ɔ knɩ 'wʋpa, we bhla -wa. ");
INSERT INTO kyf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Nɩɩ, da wa 'nɩa -slɔ ɔ knɩ 'wʋpa nɩ, Ablaamʋ mɩ nyɩmɛ tɩklɩɩ nya -Lagɔ 'yu, ɔ ka -Lagɔ dlɩ -gʋ zʋʋ 'gbʋ. -Mʋʋ 'bɩgʋ, 'ɩn ɔ yia knɩ 'wʋpapɩe 'yɩ -luu -slolulu nya. Wee knɩɩ bɩ -slolua nɩɩ, -Lagɔ ka ɔ 'yɩ nyɩmɛ tɩklɩɩ nya. Nyɩma weee -wa zʋa -Lagɔ dlɩ -gʋ, -bha Ablaamʋ -zɛa wa dide: wa 'dɛ 'nɩ knɩ 'wʋ -mɩoo, ɔ mɩ wa dide nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ɔ yi 'yaa nyɩma -wa wa 'paa knɩ 'wʋʋ dide -zɛ. We 'nɩ nɩɩ, -wa wa 'paa knɩ 'wʋ ku -yɔ -bhlogbɔɔ, nɩɩ, -wa zʋa -Lagɔ dlɩ -gʋ Ablaamʋ 'bhisa -zugba wa 'nɩ -slɔ wa knɩ 'wʋpa, ma -wa. Ɔmɔ, ɔ ka -Lagɔ dlɩ -gʋ zʋ, 'bhie wa yia ɔ knɩ 'wʋpa. ");
INSERT INTO kyf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","-Lagɔ nɛɛ Ablaamʋ -yɔ ɔ 'yua -yla nɩɩ, 'ma ɔ yia dʋdʋ 'nyɛa. -We -Lagɔ gbaa dɛ nɩ, we 'nɩ nɩɩ, Ablaamʋ zʋa tite 'nʋŋwɛɛ 'gbʋ, nɩɩ, -we ka gbʋ -wa, ɔ dlɩzʋzʋee 'gbʋ ɔ yia ɔ 'yɩ nyɩmɛ tɩklɩɩ nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","We -ka yaa nɩɩ, zʋzɔnʋ -Lagɔ gbaa ɔ 'ka wla, titee 'nʋŋwɛzʋzʋee 'gbʋ -amɩa -bhlogbɔɔ yɩ we nɩ, -zugba, dlɩzʋzʋe mɩa, bhe -wa, 'ɩn -we -Lagɔ gbaa ɔ 'ka nyɩmɛ 'nyɛ, we 'nɩ 'ji -ka. ");
INSERT INTO kyf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tite laa -Lagɔɔ 'cɛ la, nɩɩ, tite 'nɩ -mɩ nɩ, we 'nʋŋwɛzʋzʋe 'nɩ -mɩ. ");
INSERT INTO kyf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","We 'gbʋ dlɩzʋzʋe nya -a yɩa -lu -we -Lagɔ gbaa ɔ 'ka -aɩn 'nyɛ. Nɩɩ, wla ɔ wlaa we bhe. -Wa weee mɩa Ablaamʋʋ 'yua nya, ma yɩa we. 'Ɩn -wa mɩa Ablaamʋ 'yua nya, we 'nɩ nɩɩ, -wa zʋa tite 'nʋŋwɛ -bhlogbɔɔ, nɩɩ, -wa zʋa dlɩ Ablaamʋ 'bhisa, ma -wa. Nɩɩ, Ablaamʋ mɩ -a 'dɛ weee dide nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","'Sa we mɩa cɛlɩda -Lagɔsɛbhɛ 'wʋɛ: «Nɩɩ, -mɩ mɩa, -mɩ ɩn -zɛlɩa laga -nyɩmaa -zloo dide.» Sanɛɛ Ablaamʋ mɩa -amɩaa dide nya, -Lagɔ -ɔ ɔ zʋa dlɩ -gʋ, -mɔɔ 'yu. -Lagɔ -ɔ nyɛa tlɩtlɩnya 'yliyɔgagɩe, 'ɩn -we 'nɩa lamɩ, 'ɩn ɔ laa we la, mɔ. ");
INSERT INTO kyf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ablaamʋʋ dlɩ 'tɛ -Lagɔ -gʋ 'wʋ, da wa 'nɩa mneni wa 'ka -lu yabhlogbɔɔ wʋ, 'ɩn ɔ yia wʋ. Ɔ mɩa wʋda, ɔ dlɩ mɩ -Lagɔ -gʋ. We 'dɛɛ 'gbʋ ɔ yia laga -nyɩmaa -zloo dide -zɛ. Nɩɩ, -Lagɔwɛlɩ nɛɛ: «-Wa -na yia gwalɩa nɩ, wa -zu 'wʋ.» ");
INSERT INTO kyf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ablaamʋ ka -Lagɔ dlɩ -gʋ zʋ, 'ɩn ɔ yia dlɩ 'tɛmanɩ. Nɩɩ, ɔ -zʋ glʋ gbu, 'ɩn ɔ zɛlɩa ɔ ku tlɩtlɩli glaa, 'ɩn ɔ 'ŋwnɔ *Sala mɩ -gblotʋ ŋwnɔ nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","We mɩ 'sa 'bhie, ɔ 'nɩ dlɩ -Lagɔɔ gbagbawɛlɩ -gʋsa. Nɩɩ, ɔ dlɩzʋzʋe 'tɛmanɩa ɔ la, 'ɩn ɔ yia -Lagɔɔ 'ŋnɩ 'ylimanɩ. ");
INSERT INTO kyf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ɔ mɩ we -gʋ nɩɩ, -Lagɔ ka 'tɩtɛ, 'ɩn -we ɔ gbaa, ɔ mneni ɔ 'ka we lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","-We mɩa dɛɛ 'gbʋ -Lagɔ yia Ablaamʋ 'yɩ nyɩmɛ tɩklɩɩ nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","-Lagɔwɛlɩ nɛɛ: «-Lagɔ ka ɔ 'yɩ nyɩmɛ tɩklɩɩ nya», 'ya we 'nɩ ɔ 'dɛbhlogbɔɔɔ 'gbʋ we mɩ cɛlɩda. ");
INSERT INTO kyf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","-Amɩa ka dlɩzʋzʋe -gʋ, -Lagɔ -ɔ -sɔlʋa -amɩaa -Kanyɔ -Zezu 'wʋ tlɩtlɩnya glaa yia -aɩn yibhelia nyɩma tɩklɩɩ nya, 'sa -bhlokpadɛ we mɩa -amɩa weee -nʋ nya. ");
INSERT INTO kyf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","-Amɩaa gbʋnyuuu 'gbʋ wa yia ɔ 'bha, 'ɩn -Lagɔ 'ka -aɩn 'yɩ nyɩma tɩklɩɩ nyaa 'gbʋ ɔ yia ɔ tlɩtlɩnya glaa 'wʋsɔlʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","We 'dɛɛ 'gbʋ -Lagɔ yia -aɩn 'yɩ nyɩma tɩklɩɩ nya -amɩaa dlɩzʋzʋee 'gbʋ. -Slɛɛn, -a -yɔ ɔ 'sɔ mɩ 'wʋtʋtʋe -dlɔɔ 'wʋ, -amɩaa -Kanyɔ -Zezu Klisɩɩ gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","-A -ka -Lagɔ dlɩ -gʋ zʋ, -Zezuu gbɛgbɛɩn -a mneni -a 'ka 'nanɩdlɩ -ka -Lagɔ -yɔlanyni. 'Ɩn -slɛɛn, -a mɩ ɔ 'nanɩdlɩ 'wʋ. -A mɩ 'mʋna lida, -we ka gbʋ -wa, -amɩaa dlɩ mɩ we -gʋ nɩɩ, -Lagɔɔ 'ŋnɩmnɩe -a yia 'yɩa ɔ kwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","We bhlɩ -mʋʋ -gʋ, -amɩaa 'dɛ yi sɩada -mɩoo, -a mɩ 'mʋna 'wʋ. -We ka gbʋ -wa, -a -yi we 'ji nɩɩ, -a -ka sɩada -mɩ, 'bhie -a zɛa dlɩtie -cɩan. ");
INSERT INTO kyf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","-A -ka dlɩtie -ka, 'bhie -a tɛmanɩa la 'yɩyɩgbʋ 'wʋ. -A -ka latɛmanɩ 'yɩyɩgbʋ 'wʋ, -we -a wʋa, mʋ -wa -we -Lagɔ yia -aɩn -yla lɛnʋa. ");
INSERT INTO kyf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","-A -ka -Lagɔɔ kwɛlu wʋda -mɩ, we 'na 'ka -aɩn -dawli 'wʋnʋ, -we ka gbʋ -wa, -Lagɔ ka -aɩn ɔ Zuzu 'Pʋpa 'nyɛ, 'ɩn mʋ 'kaa ɔ zɛkalɩe -amɩaa dlɩ zɔ yeli. ");
INSERT INTO kyf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Cɩɩn, bhla -we nya -a 'nɩa 'tɩtɛ yabhlogbɔɔ -ka, 'ɩn Klisɩ yia tlɩ gbʋnyuu -lɛnʋnyaa 'gbʋ, wee bhla mɩa, -Lagɔ 'paa we ŋwɛɛ. ");
INSERT INTO kyf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Wa 'ka nyɩmɛ tɩklɩɩɩ 'gbʋ tlɩtlɩe -yɔŋwnu we -kalɩ -yɔ. Nyɩmɛ yabhlo -ɔ nʋa 'nanɩ, wa mneni yaa wa 'ka tlɩ ɔ 'gbʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nɩɩ, Klisɩ yia tlɩ -amɩaa 'gbʋ, da -a mɩ bhaa gbʋnyuu lɛnʋda, mʋ -slolua -aɩn sa -Lagɔ -kalɩa -amɩaa zɛ. ");
INSERT INTO kyf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","-Slɛɛn, ɔ 'pɩɔɔn 'gbʋ -Lagɔ yɩa -aɩn nyɩma tɩklɩɩ nya. We -ka 'sa -mɩ nɩ, -a mɩ we -gʋ nɩɩ, mɔ yia -aɩn -Lagɔɔ 'cɛ 'wʋsaa. ");
INSERT INTO kyf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nɩɩ, da -a mɩ bhaa -Lagɔɔ tʋnyɩma nya, 'ɩn ɔ yia -a -yɔ ɔ 'sɔ 'wʋsuslolu ɔ 'Yuu tlɩtlɩe nya. Ɔ -ka -a -yɔ ɔ 'sɔ 'wʋsuslolu sanɛɛ, sa we -ka -mɩ, mɔ yi 'yaa -aɩn gbʋ 'wʋsaa ɔ 'Yuu 'yliyɔgagɩe -gʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","We 'nɩ 'sa -tʋ. -A mɩ 'mʋna lida -Lagɔ 'wʋ, -amɩaa -Kanyɔ -Zezu Klisɩɩ gbɛgbɛɩn, -we ka gbʋ -wa, mɔɔ suslolua -a -yɔ -Lagɔ 'sɔ 'wʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Gbʋnyuu yia la dʋdʋ -gʋ nyɩmɛ yabhlogbɔɔɔ 'gbʋ, mɔ -wa *-Adan. 'Ɩn wee gbʋnyuu yia tlɩtlɩe lala, tɔʋn, 'ɩn tlɩtlɩe yia lamneni nyɩma weee -gʋ, -we ka gbʋ -wa, dʋdʋgʋ -nyɩma weee ka gbʋnyuu lɛnʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Da -Lagɔ 'nɩa -slɔ Moizɩ tite 'nyɛ, wemʋ gbʋnyuu mɩ la dʋdʋ -gʋ see. Nɩɩ, tite 'nɩ bha -slɔ lamɩɩ 'gbʋ, -Lagɔ 'nɩ gbʋnyuuu 'gba nyɩmɛ 'wlu dɩ. ");
INSERT INTO kyf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","'Ɩn tlɩtlɩe -nanʋ yia nyɩma 'wlulapɩlɩ, we 'bhʋ -Adan -gʋ we 'ka Moizɩ ylɩ. -Adan -ɔ 'nɩa -Lagɔɔ wɛlɩ 'nʋŋwɛ zʋ, -mama 'nɩa ɔ -bho -gbʋnyuu lɛnʋ, 'ɩn tlɩtlɩe yia -maa 'bha. Nɩɩ, -Adan -wa -ɔ 'kaa yii nʋ 'wʋwlʋ. ");
INSERT INTO kyf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","'Ɩn, -Lagɔɔ wlawlalu bhe -yɔ -Adaan gbʋnyuu mɩ -yɔbhʋbhlʋda tenyi tenyii. Nyɩmaa -zlo yia tlɩ nyɩmɛ -bhlogbɔɔɔ gbʋnyuuu 'gbʋ, gbʋzɔnʋ -wa. Nɩɩ, -Lagɔɔ wlawlalu bhe kaa 'ŋnɩ tenyi tenyii, -Lagɔ wlaa we nyɩmɛ -bhlogbɔɔɔ gbɛgbɛɩn, mɔ -wa -Zezu Klisɩ. 'Sa -Lagɔ bʋbanɩa ɔ zʋzɔnʋ lɛnʋe la sa bhe, nyɩmaa -zlo glaa. ");
INSERT INTO kyf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","-Lagɔɔ wlawlalu, we -yɔ ɔɔ nyɩmɛ -bhlogbɔɔɔ gbʋnyuu, we 'nɩ -tnʋʋ -bhlo -ka. Ɔɔ nyɩmɛɛ gbʋnyuuu -tnʋʋ -wa nyɩmaa -kaslʋ 'wʋpapɩe -Lagɔɔ gbʋwʋbhubhuee gbɛgbɛɩn. Nɩɩ, ɔ wlawlalu bhee -tnʋʋ -wa -Lagɔ yɩa nyɩma nyɩma tɩklɩɩ nya. ");
INSERT INTO kyf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Gbʋzɔnʋ sa, nyɩmɛ -bhlogbɔɔɔ 'gbʋ, nyɩmɛ -bhlogbɔɔɔ 'wlu -gbʋnyuuu 'gbʋ, 'ɩn tlɩtlɩe yia dʋdʋ weee bhɩtɩ. Nɩɩ, ɔɔ -Zezu Klisɩɩ 'dɛbhloo gbɛgbɛɩn nyɩma yɩa -lu duun -Lagɔ kwɛɛ. Mɔ nyɛa wa zʋzɔnʋ sa duun, 'ɩn ɔ gbaa nɩɩ, wa mɩ nyɩma tɩklɩɩ nya. 'Yliyɔgagɩe wa yia 'yɩa -Zezu Klisɩɩ 'gbʋ, 'ɩn wa -yɔ ɔ 'sɔ 'ka -lu weee 'wlulapɩlɩ. ");
INSERT INTO kyf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nɩɩ, nyɩmɛ -bhlogbɔɔɔ gbʋnyuu 'paa nyɩma weee -kaslʋ 'wʋ. 'Sa -bhlokpadɛ, -bhlogbɔɔɔ lɛnʋgbʋ tɩklɩɩ tɩa nyɩma weee 'wʋ tɩklɩɩ, 'ɩn we yia wa 'yliyɔgagɩe 'nyɛ. ");
INSERT INTO kyf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Bha -benyi, nyɩmɛ -bhlogbɔɔ 'nɩa -Lagɔ 'nʋŋwɛ zʋ, -bha nyɩmaa -zlo -zɛa gbʋnyuu -lɛnʋnya. 'Sa -bhlokpadɛ, nyɩmɛ -bhlogbɔɔ zʋa ɔ 'nʋŋwɛ, 'ɩn -Lagɔ yia nyɩma duun 'yɩ nyɩma tɩklɩɩ nya. ");
INSERT INTO kyf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tite ka yi, 'ɩn gbʋnyuu yia 'wʋzumanɩ tenyii. 'Ɩn gbʋnyuu -ka 'wʋzumanɩ tenyii nɩ, -Lagɔɔ 'nanɩdlɩ ka -gʋwʋlaylimanɩ, 'ɩn we yia we ŋwɛlazili. ");
INSERT INTO kyf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nɩɩ, gbʋnyuu ka tlɩtlɩe la, 'ɩn we yia nyɩma 'wlulapɩlɩ. 'Sa -bhlokpadɛ, -Lagɔɔ zʋzɔnʋ pɩlɩa nyɩma 'wlu la, 'ɩn we yia wa nyɩma tɩklɩɩ -zɛlɩ. 'Sa -a yɩa 'yliyɔgagɩe -we 'nɩa bhloluda -ka -amɩaa -Kanyɔ -Zezu Klisɩɩ gbɛgbɛɩn. ");
INSERT INTO kyf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Wee gbʋ mɩa, sa -a 'ka we daa gba? 'Lee, -a zʋ gbʋnyuu lɛnʋe 'yliyɔ, 'bhie -Lagɔɔ 'nanɩdlɩ 'ka -gʋwʋlaylimanɩɩ? ");
INSERT INTO kyf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","-Ɩnnya, we 'nɩ 'sa -mɩ. Tlɩtlɩe yabhlo -we 'wʋ -a 'plɩlɩa, we ka -a -yɔ gbʋnyuu 'sɔ -yɔsɩsalɩ. We -ka 'sa -mɩ, -a 'nɩ mneni -a 'ka gbʋnyuu lɛnʋda -tʋ. ");
INSERT INTO kyf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Amɩaa 'dɛ -yi we 'ji nɩɩ, da wa batizea -aɩn, -a -yɔ -Zezu Klisɩ ka 'wʋtʋ -bhlo, 'ɩn -a -yɔ ɔ 'sɔ mɩ -bhlo ɔ tlɩtlɩe 'w