﻿USE sofia;
DROP TABLE IF EXISTS sofia.kyb_vpl;
CREATE TABLE kyb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kyb_vpl WRITE;
INSERT INTO kyb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Annachaja nan listaan nan nerpugwan Hesu Kristu gway nerpu san kana' Ali Dabid gway nerpu ahos san kana' Abraham. ");
INSERT INTO kyb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Sa'ad as Abraham aman Isaac, as Isaac aman Jacob, as Jacob aman Juda ja chanan susunudna. ");
INSERT INTO kyb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sa'ad as Juda aman cha Fares an Zara gway as Tamar nan inacha, as Fares aman Esrom, ad as Esrom aman Aram. ");
INSERT INTO kyb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa'ad as Aram aman Aminadab, ad as Aminadab aman Naason. Sa'ad as Naason aman Salmon, ");
INSERT INTO kyb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","as Salmon gway asagwan Rahab aman Boaz, as Boaz gway asagwan Ruth aman Obed, as Obed aman Jesse. ");
INSERT INTO kyb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ad sa'ad as Jesse aman Ali Dabid. Sa'ad as Dabid aman Solomon gway sa'ad nan inana Batsiba gway sikuchay asagwan Urias. ");
INSERT INTO kyb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa'ad as Solomon aman Roboam, as Roboam aman Abias ad as Abias aman Asa. ");
INSERT INTO kyb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sa'ad as Asa aman Jehosafat, as Jehosafat aman Joram ad as Joram nerpugwan Ozias. ");
INSERT INTO kyb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sa'ad as Ozias aman Jotam, as Jotam aman Acaz, ad as Acaz aman Hezekias. ");
INSERT INTO kyb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sa'ad as Hezekias aman Manases, as Manases aman Amon ad as Amon aman Josias. ");
INSERT INTO kyb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sa'ad as Josias apun cha Jeconias ja chanan susunudnaay lallaya'i gway nijana' san chimpun nan napapilit niijoy chanan ijIsrael ad Babilonia. ");
INSERT INTO kyb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nappung ad niijoy chanan ijIsrael ad Babilonia, nijana' as Sealtiel gway Jeconias nan amana, ad as Sealtiel apun Zerubabel. ");
INSERT INTO kyb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sa'ad as Zerubabel aman Abiud, as Abiud aman Eliakim, ad as Eliakim aman Azor. ");
INSERT INTO kyb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sa'ad as Azor aman Zadoc, as Zadoc aman Akim, ad as Akim aman Eliud. ");
INSERT INTO kyb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sa'ad as Eliud aman Eliazar, as Eliazar aman Matan, ad as Matan aman Jacob. ");
INSERT INTO kyb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ad sa'ad as Jacob aman Josep gway asagwan Maria. Sa'ad as Maria inan Hesus gway maagwakan as Kristu. ");
INSERT INTO kyb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sija nan nasagwayan as opat nan lunap gway malluki an Abraham ingkana an Dabid. Ad malluki ad an Dabid ingkana san chimpuway napapilit niijoy chanan ijIsrael ad Babilonia, agwad nan nasagwayan as opatay lunap. Ad malluki ad ahos san nappungcha niijoy ad Babilonia ingkanas nijana'an Kristu, agwad nan nasagwayan as opatay lunap. ");
INSERT INTO kyb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Amasna nan ininon Hesu Kristu gway nijana': Ni'awherjan kun as Maria gway inan Hesus an Josep gway chaancha man'atum, naakammugwanay mahukis Maria kapu san ayobhongan nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sa'ad as Josep gway ni'awherjanana, kapu tan nalintokay taku lagwingonaay miwhawhain as Maria kun simsimmo'naay achina asawwon as Maria gway achina kun impaakammu sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Gwon sa'ad san manom'asom'ana san annaja, nampaila nan anghel Apudyus an sija san ininop gway anana, “Josep gway kana' Dabid, achi'a umogjatay mangasagwa an Maria tan nan nahukiyana kapu san Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ijana'na nan laya'i ad nginadnam as sija as Hesus tan takuwona chanan takuna sasan whersucha.” ");
INSERT INTO kyb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na'gwa nan annaja tot matungper nan ingwhakan Apudyus an profeta Isaias gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Chongyonju, sa'ad nan osa whawhallasay chaan pabog mahuki ad ijana'na nan osa laya'i, ad mangadnan as Immanuel gway sa'ad nan pijaona anan, ‘Anna as Apudyus an chita'u.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gwot humangon kus Josep, pinatina nan ingwhakan nan anghel Apudyus kun inasagwana as Maria. ");
INSERT INTO kyb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gwon achina kun ini''ibog as sija ingkanas iyana'na nan ana'. Kun nginadnan Josep nan ana' as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nijana' kus Hesus ad Betlehem gway sa'up nan Judea san chimpun nan nan'aliyan Herod, iningkaw chanan man'alaingay taku gway nangacher sasan whituwon gway ummoy ad Jerusalem gway nerpucha san iliyay chumungitan nan init. ");
INSERT INTO kyb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kun inimuscha sasan taku gway manggwanaon, “Agwan nan agwachan nan sachi ana'ay nijana' gway mangngachan alin chanan Hudyu? Inilami nan whituwon gway nampaila san chumungitan nan init gway nangipailaay nijana' as sija. Sija nan ummali ami tot chajagwonmis sija.” ");
INSERT INTO kyb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chingngorn kun Ali Herod nan mipangkop san nanimusancha, nakuyu nan somsomo'na ja ama ahos chanan angsanay taku ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gwot impaajagna chanan papangat nan papachi ja chanan mangaagkammu san lintog Apudyus kun inimusna an chicha gway manggwana, “Agwan nan mijana'an nan Kristu?” ");
INSERT INTO kyb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kun anancha an sija, “Ad Betlehem gway sa'up nan Judea tan annaja nan illistan nan profeta san agwi gway anan Apudyuson: ");
INSERT INTO kyb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Cha'ajuway takud Betlehem san ilid Judea, wha'on kus anan chanan mangituyay ad Judea gway mangudchi aju ili tan merpu an cha'aju nan mangituyay gway mangijamuut sasan taku' gway ijIsrael.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sachi kun inajakan Herod chachay man'alaingay taku gway nangacher san mipangkop sasan whituwon kun nanimus an chicha san maid mangakammus taku. Kun naakammugwana an chicha nan ustu'ustuway chimpu gway lummosgwaan chay whituwon. ");
INSERT INTO kyb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kun ingwhaunna chicha ad Betlehem gway pinuyungna chichaay manggwana, “I'aju ad inammanju anapon nan sachi ana'. Ad sa'ad nu ochasanjus sija umaliju ipaakammu an sa'on tot iya' ahos chajagwon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Sachi kunay chingngorcha nan puyung chay ali, lummiggwatcha. Agwadcha kus chayan inilacha chay whituwon gway nampaila an chicha san chamu san chumungitan nan init kun nallaylajadchas amod. Kun impupujut chay whituwon chicha ingkana san summinong san whatug nan agwachan chay ana'. ");
INSERT INTO kyb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kummatongcha kun nilumno'cha san hoyoy gwot inilacha nan ana' ja as Maria gway inana. Nampalintumongcha kun chinajawchas sija. Kun asichaot o'aton nan atchoncha gway man'apapatog gway huyagwan, whangwhangyu gway insenso ja lana gway ma'gwaniyon mirra kun inatodcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lummajawcha kun ayasi nan inoycha tan ingwhakan Apudyus an chicha san ininop gway achicha managkulin an Herod. ");
INSERT INTO kyb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aysan kun chachay man'alaingay taku, nampaila nan osa anghel Apudyus an Josep san ininop gway manggwana, “Humangon'a ta ijagwidnu nan manina ad Egipto. Ingkaw ajud aschi ingkana san iwhaka' gway managkulin aju tan paanap Herod nan ana' tot ipaotoyna.” ");
INSERT INTO kyb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gwot hummangon as sija san sachiyay lawhi kun iyagwidna nan manina gway ummoy ad Egipto. ");
INSERT INTO kyb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kun iniingkawchad aschi ingkana san natoy as Herod. Na'gwa nannaja tot tumuttuwa nan ingwhakan Apudyus san profeta gway anana, “Manipud ad Egipto inajaka' nan ana''u.” ");
INSERT INTO kyb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naakammugwan kun Herod gway sini'apan chachay man'alaingay taku as sija, amod nan huchu'na kun ingwhilinna gway otojoncha nan losanay laya'iyay ana' ad Betlehem ja sasan losanay whija'cha gway mantagwon as chugwa gwinnu uyang as chugwa. Ad san nangakammugwana sasay man'alaingay taku gway nerpu san chumungitan nan init, chugwan tagwon nan lummaus malluki san ummuna nangillancha san whituwon. ");
INSERT INTO kyb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kun tummuttuwa nan ingwhakan profeta Jeremias gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Agwad nan kinga gway mamagngor ad Rama gway amochay akaag ja iwhil. Iwhiiwhilan Raquel chanan ana'na ja lagwingonaay paliwligwa kapu tan namincha natoy.” ");
INSERT INTO kyb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Natoy kus Herod, nampaila nan osa anghel Apudyus san ininop an Josep ad Egipto ");
INSERT INTO kyb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","gway manggwana, “Humangon'a ta ijagkulinnu nan manina ad Israel. Tan sa'ad chachay mangtoy otjan san ana' natoycha.” ");
INSERT INTO kyb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gwot hummangon kus Josep iyagkulinna nan manina kun ummoychad Israel. ");
INSERT INTO kyb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gwon naakammugwana kunay as Arkelao nan nan'ali ad Judea gway nipasu an amana Herod, ummogjat gway umoy ad aschi. Kapu tan niwhaka an sija san ininop, ummod Galili as sija. ");
INSERT INTO kyb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kun ummoycha na'aumili san iliyay ma'gwaniyon Nazaret tot tumuttuwa nan ingwhakan chanan profeta mipangkop san Mesias gway anancha, “Maagwakan as sija as iNazaret.” ");
INSERT INTO kyb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lummaus ad nan amanaay tagwon, nampaila as Juan gway Manghohonjag san luta gway maid kun ingkaw as taku ad Judea. ");
INSERT INTO kyb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","San naayusan chanan taku, impaakammuna gway manggwana, “Manchu'kanju chanan whersuju tan takangay nan mangituyajan Apudyus sasan takuna.” ");
INSERT INTO kyb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","As Juan nan iwhagwhakan Isaias gway profetan Apudyus san manggwanaana, “Agwad nan osa taku mampa'upa'uy san luta gway maid kun ingkaw as taku gway manggwana, ‘Isakanaju nan ajon nan Apu! Pawhayugwonju nan manadchayanana!’ ” ");
INSERT INTO kyb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa'ad nan silup Juan inahor gway chutchut nan kamel ja sa'ad nan ayapawna kadchang ancha sa'ad nan aannona chuchun ja chilu. ");
INSERT INTO kyb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kun ummoy an sija nan chachama taku gway nerpud Jerusalem ja nerpu san losanay sa'upon nan iliyay Judea ancha nerpu sasan ikid nan Gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kun ingwhawhagkacha nan whersuchaot whinonjakan Juan chicha san gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Inilan kun Juan chanan angsanay Pariseo ja Saduceo gway umoy mampahonjag an sija, anana an chicha, “Sa'ad as cha'aju isuju chanan nasi'ap gway uyog! Ngachan nan nangiwhaka an cha'ajuway malisiyanju nan umaliyay chusan Apudyus nu achiju manchu'kan nan whersuju? ");
INSERT INTO kyb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Maserpu ipailaju kapu san kidkichuju gway tuttuwa nanchu'kanju chanan whersuju. ");
INSERT INTO kyb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ad achiju somsom'on gway milisi aju san chusa kapu san ananjuwon kana' cha'aju an Abraham. Iwhaka' an cha'ajuway sa'ad nannachaja whatu ma'gwaay oon Apudyus as kana' Abraham. ");
INSERT INTO kyb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na'asakana as Apudyus gway manusa san taku nu achicha manchu'kan nan lagwingay o'ooncha, isun nan taku gway na'asakanaay mangikupung san gwasayna san lamut nan aju. Ad losanay aju gway achi kun humkas as whayu makupung ad niwhallu san apuy. ");
INSERT INTO kyb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Honjaka' cha'aju san chanum as mangipailaay nanchu'kanju chanan whersuju. Gwon agwad nan umali mipasu an sa'on gway nangatngatu an sa'on, amod nangatu gway achiya' kun miwhilang as mansilwhi an sija uyay nan mangaan san sinilasna. Honjakana cha'aju san apuy gway Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ad nu umali ichersinna nan whayuway taku san lagwing gway isun nan takuway anna nan ayay'aynaay mallaid san chakami san kerkergwit. Igkana san ayangna nan kerkergwit gwon sa'ad nan chakami puuyana san apuy gway achi kun mapatajan.” ");
INSERT INTO kyb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sa'ad san sachi chimpu gway nanghonjakan Juan kummatong as Hesus gway nerpud Galili gway ummoy san gwanggwangay Jordan ta mampahonjag an Juan. ");
INSERT INTO kyb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gwon ijachin otjan Juan gway manggwana, “Sa'on otjan nan maserpuway mampahonjag an si'a, kunja ka si'a nan umali an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gwon anan Hesus gway summungwhat an sija, “Taakunay ma'gwa nan annaja san sana tan annaja nan whayuway oonta tot ma'gwa nan losanay whayugwon Apudyus.” Kun intachun Juan. ");
INSERT INTO kyb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gwot nappung kun nahonjakan as Hesus, lummosgwa san chanum. Kun niibwhat nan langit gwot inilana nan Ispilitun Apudyus gway isun chi kaob nan kalapati chummo''oya gway ummoy inumpa an sija. ");
INSERT INTO kyb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kun anan nan kingaay nerpud langit, “Annaja nan ana''u gway ipatpatog'u, mamasoma' an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sachi kun impujut nan Ispilitun Apudyus as Hesus san luta gway maid kun ingkaw as taku ta sulisukan Satanas. ");
INSERT INTO kyb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kun nallaun as opat puyuway erkaw ja lawhi gwot nappung kun, nawhitil as sija. ");
INSERT INTO kyb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kun ummoy ummachayug as Satanas kun anana an sija, “Nu si'a nan Ana' Apudyus iwhakam sannachaja whatu ta mangngachancha tinapay.” ");
INSERT INTO kyb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Gwon summungwhat as Hesus gway manggwana, “Nilista san Ukud Apudyus gway anana, ‘Wha'on kus ahus nan tinapay as i'atakun nan taku gwon maserpuna nan gwaschi ukud Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gwot iyoy Satanas as Hesus ad Jerusalem gway iliyay niit'on as ugwan Apudyus kun impasi'adnas sija san tu'tu' nan Templo ");
INSERT INTO kyb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kun anana an sija, “Nu si'a nan Ana' Apudyus lumajug'a. Tan nilista san Ukud Apudyus gway anana, ‘Sa'ad chanan a'anghel Apudyus whilinona chicha san mipangkop an si'a.’ Anana hos, ‘Tapajaon cha'a san imacha tot achi chanan i'im miserser san whatu.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Anan Hesus an sija, “Nilista ahos san Ukud Apudyus gway anana, ‘Achim sulisukon nan Apu gway Apudyusnu.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iyoy ahos Satanas as Hesus san nangatu' amod gway whilig kun impailana an sija nan losanay mantuyajan san luhung ja nan ina'erjadcha. ");
INSERT INTO kyb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kun anana an sija, “Atcho' losan nannachaja an si'a nu mampalintumong'a gway manchajaw an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kun anan Hesus an sija, “Lumajaw'a Satanas! Tan nilista san Ukud Apudyus gway anana, ‘As Apu gway Apudyusnu nan manchajagwam ad ahus as sija as mansilwhiyam.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Gwot tinaynan Satanas as sija kun kummatong chanan a'anghel gwot nansilwhicha an sija. ");
INSERT INTO kyb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chingngorn kun Hesus gway niwhayud as Juan nanagkulin as sija ad Nazaret gway sa'up nan Galili. ");
INSERT INTO kyb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gwon wha'on kus iningkaw ad Nazaret, ummoy iningkaw ad Capernaum gway osa ili san ikid nan whaywhay gway Galili san sa'up nan kana' Zabulon an Neftali. ");
INSERT INTO kyb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na'gwa nannaja tot tumuttuwa nan ingwhakan profeta Isaias gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sa'ad nan lutan cha Zabulon an Neftali agwad san chayan gway umoy san whaywhay san chomang nan gwanggwangay Jordan. Sa'ad nan annachaja ili sa'up nan Galili gway iingkagwan chanan wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nawhiwhijag san manghulingot chanan taku ad aschi gwon ma'ailacha san amod gway padcha. Ta'on nu agwadcha san manghulingot ja umogjatcha matoy mapadchaancha san silaw.” ");
INSERT INTO kyb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Malluki san sachi chimpu illukin Hesus gway mangipaakammu gway manggwana, “Manchu'kanju chanan whersuju tan takangay nan mangituyajan Apudyus sasan takuna.” ");
INSERT INTO kyb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sa'ad san manadchadchayanan Hesus san tayantag nan whaywhay gway Galili, inilana nan chugwa mansunud gway Simon gway mangngachan Pedro ja Andres. Ikaokaobcha nan akaidcha san whaywhay tan mangii'ancha. ");
INSERT INTO kyb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kun anana an chicha, “Gwayyu ta mitunud aju an sa'on ad nangngachano' cha'aju as mangii'an sasan taku gway mamatiyonju chicha an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kun nanitaynancha san akaidchaot nitunudcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ummachajucha kusan nanadchadchayanancha inilana nan chugwa mansunud gway Santiago an Juan gway ana' Zebedeo. Iniingkawcha san whang'a gway huyunchas Zebedeo gway amacha gway iperroperrogcha nan akaidcha kun inajakan Hesus chicha. ");
INSERT INTO kyb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kun nanitaynancha san whang'a ja as amacha kun nitunudcha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kinagka'ay Hesus nan ailiili ad Galili gway nansuyus sija sasan sinagogacha. Impaakammuna nan Whayuway Chamag gway mipangkop san mangituyajan Apudyus sasan takuna. Kun inaanna chanan na'aya'ayasiyay sa'it ja li'li'naon chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kun nanchinamag nan mipangkop an Hesus san losanay ilid Siria. Kun iyoycha an sija nan losanay nasa'it, chanan maliglikatan san losanay ayasin nan sa'it ja li'li'naon, chanan nilno' nan chimunju, chanan na'or'orchas ancha chanan napalalais. Kun impawhayun Hesus chicha. ");
INSERT INTO kyb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kun nitunud an sija nan chachama takuway nerpud Galili, Decapolis, Jerusalem, uchumay ili ad Judea ja san chomang nan gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Inilan kun Hesus nan angsanay taku ummoy san whilig kun tummu'chu kun ummoy chanan pasuyutna an sija. ");
INSERT INTO kyb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kun sinuyuwana chicha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Piyan chanan takuway sija ekay ahus as panu'choncha as Apudyus tan mitapicha sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Piyan chanan takuway mansasanga kapu san whersu tan liwligwaon Apudyus chicha. ");
INSERT INTO kyb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Piyan chanan takuway achicha kun mantayo' san ugwachaay ayobhongan tan ila'suncha nan luta. ");
INSERT INTO kyb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Piyan chanan takuway amod nan mamayuchaay manggwa san whayugwon Apudyus gway amachas mawhiwhittil ja mauuwaw tan mapno'cha. ");
INSERT INTO kyb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Piyan chanan takuway mangachaku tan achakugwan Apudyus chicha. ");
INSERT INTO kyb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Piyan chanan takuway por'as nan somsomo'cha tan ilancha as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Piyan chanan takuway mallilintog tan maagwakancha as anana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Piyan chanan takuway mapalpalikatan kapu san manggwaancha san whayugwon Apudyus tan mitapicha sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Piyan aju nu pawhainan cha'aju sasan taku, palpalikatan cha'aju ja iwhakacha nan losanay ayasin nan lagwingay mihursu an cha'aju gway tuli kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tan amasna nan namalpalikatancha sasan profeta gway ummuna an cha'aju. Sija nan lumagsa' ajus amod tan cha'or nan makanabju ad langit.” ");
INSERT INTO kyb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Intuyuy kun Hesus gway mansuyu anana, “Mijisu aju san asin gway maserpun chanan taku sanna luhung. Gwon nu ma'aan nan tamtamna ininona ma misubli nan tamtamna? Nangngachan maid kun kutu'na ad niwhallu ad chinamchampit chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mijisu aju san silaw gway mamadcha san somsomo' chanan taku san luhung. Sa'ad nan cha'or iliyay agwad san tu'tu' nan whilig wha'on kus milingob. ");
INSERT INTO kyb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Maid kuhos takus mangngotog san silaw ad tinangwhana san timba gwon igkana san mipatangana ad pinadchaana nan losanay taku san hoyoy. ");
INSERT INTO kyb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Isuna hosay mawhijag ajuway maid mitatayu an cha'aju tot ilancha nan whayuway o'oonju ad inchaychajawchas Apudyus gway Amaju gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Achiju somsom'onay ummaliya' ta lu'aja' nan lintog Moses ja nan sussuyun chanan profeta. Wha'on kus ummaliya' ta lu'aja' chana gwon ummaliya' ta ipaagwat'u ja ipatungper' chana. ");
INSERT INTO kyb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tuttuwa iwhaka' an cha'aju gway ingkana san mumaid nan langit ja luta, maid kun uyay osas lista gwinnu awha''ijutanay ukit as ma'aan san lintog ingkanas ma'gwa losan nan pangkop Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sija nan nu ngachan nan mallabsing san osa sasan japaw gway whilin san lintog Apudyus ja isuyuna san uchumay labsingoncha, miwhilang as sija as awhawhaan sasan takuway ituyajan Apudyus. Gwon nu ngachan nan mangi'gwa san lintog ja isuyuna san uchum tot ooncha hos, miwhilang as sija as napatog sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iwhaka' an cha'ajuway achi aju kun mitapi sasan takuway ituyajan Apudyus nu wha'on aju kus nalinlintog sasan Pariseo ja chanan mangaagkammu san lintog.” ");
INSERT INTO kyb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Intuyuy Hesus gway manggwana, “Chingngorju gway niwhaka sasan nerpugwan ta'u san agwi gway anana, ‘Achi'a pumatoy. Nu ngachan nan pumatoy mayodchonganay mau'um.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gwon iwhaka' an cha'aju gway nu ngachan nan malingu san huyunna, na'awhersu ja lobhongnaay mau'um. Nu ngachan nan manggwana san huyunnaon, ‘Maid kun akammum,’ na'awhersu ja lobhongnaay mau'um sasan papangat nan Hudyu. Ad nan manggwana san huyunnaon, ‘Katkatung'a,’ na'awhersu ja lobhongnaay umoy san apuy ad ingwhilnu. ");
INSERT INTO kyb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sija nan nu ijoynu nan chatunnu an Apudyus san chachattunan ja somsom'omay agwad isil nan huyunnu an si'a, ");
INSERT INTO kyb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taynam nan chatunnu san sangun nan chachattunan ad umuna janay i'a aapapat nan huyunnu ta mansubli nan manghubuyunanju ad asimot umoy igka nan chatunnu. ");
INSERT INTO kyb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu agwad mangijoy an si'a san chachalluman tot ichayum cha'a, kanasom gway ma'alinnisut an sija san agwachanju san chayan. Tan sa'ad nu achi'a ichayum cha'a san manguu'um ad sa'ad nan manguu'um ipawhijang cha'a san pulis ad impisu' cha'a san whawhalluchan. ");
INSERT INTO kyb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tuttuwa iwhaka' an si'a gway achi'a kun lumallagwa ad aschi ingkanas ijahusnu aminon iwhajad nan pila'nu. ");
INSERT INTO kyb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Chingngorju nan niwhaka san agwi gway anana, ‘Achi'a ma'assuy san wha'on kus asagwam.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gwon iwhaka' an cha'ajuway nu ngachan nan laya'i mangila san osa huwhai gway sa'ad san somsomo'na whayugwona ibog as sija, naahus ma'awhersu san somsomo'na san whersun nan mangibog an sija. ");
INSERT INTO kyb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ad sa'ad nu chigwananay atam nan kapun nan ma'awhasuyam, u'atom ad ingwhallum. Unayna ekay ma'aan nan osa san pertin nan longagnu nu nan mitoper nan losanay longagnu ad ingwhilnu. ");
INSERT INTO kyb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ad nu chigwananay imam nan kapun nan ma'awhasuyam, kumpuyam ad ingwhallum. Unayna ekay maid nan osa imam nu nan umoy nan losanay longagnu ad ingwhilnu.” ");
INSERT INTO kyb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Niwhaka ahos san agwi gway anana, ‘Nu ngachan nan laya'i gway mangichang san asagwana, maserpu atchona an sija nan impapilna gway mangichangana an sija.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gwon iwhaka' an cha'ajuway nu ngachan nan laya'iyay mangichang san asagwana maya'sig nu na'assuy san uchumay laya'i, sija nan nangkapu as mallaya'iyana nu mangasagwa asin. Ad nu ngachan nan laya'iyay mangasagwa san huwhaiyay naichangan miwhilang as sija as namuwhai.” ");
INSERT INTO kyb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Chingngorju hosay niwhaka sasan taku san agwi gway anana, ‘Achim labsingon nan lausnu ingwhaka gwon oom nan lausnu ingwhaka an Apudyus gway oom.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gwon iwhaka' an cha'ajuway achi aju mansapsapata. Achi aju mansapata ad langit tan sija nan mantukagwan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gwinnu achi aju mansapata san luta tan sija nan mipapattangan nan i'ina gwinnu achi aju mansapata san Jerusalem tan sija nan ilin nan napatokay Ali. ");
INSERT INTO kyb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gwinnu achim isapata gway manggwana, ‘Matoja',’ tan uyay osa sasan huu'nu achim pun lobhongay paputa'on gwinnu pangititon. ");
INSERT INTO kyb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gwon iwhakam ekay ‘Oon,’ nu oon gwinnu ‘Wha'on,’ nu wha'on. Nu ngachan sinat nan ijutupju sannaja merpu an Satanas.” ");
INSERT INTO kyb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Chingngorju nan niwhaka san agwi gway anana, ‘Nu agwad mangano''a san osa atam maserpu ano''om ahos nan osa atana. Nu agwad mangano''a san whawham maserpu ano''om ahos nan whawhana.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gwon iwhaka' an cha'ajuway achi aju humayus san takuway manggwa san lagwing an cha'aju. Nu agwad mallipa' san machigwananay apingnu itajam ahos nan whisa'. ");
INSERT INTO kyb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ad sa'ad nu agwad mangichayum an si'a ta ayana nan silupnu, atchom kahos itapi nan kotap nan silupnu. ");
INSERT INTO kyb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu agwad surchachus mangipapilit mangipadon san ochonna an si'a san achaju ituyuynus mamidgwa nan aachajuna. ");
INSERT INTO kyb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu agwad man'ochaw an si'a atcham ja nu agwad manghuyud an si'a pahuyucham.” ");
INSERT INTO kyb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Chingngorju nan apapat san agwiyay anana, ‘Ipatognu nan asintatakum gwon kuyaom nan ahursum.’ ");
INSERT INTO kyb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gwon nan iwhaka' an cha'aju san sana ipatogju chanan ahursuju ja ilugwayuwanju chanan mamalpalikat an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nu oonju chi cha'aju nan kadto'ay anana' Apudyus gway Amajud langit. Tan manisugwona initan chanan lagwing nan oona ja chanan whayu nan oona taku ja manisugwona hos uchanan chanan manggwa san ustu ja uyay chanan manggwa san wha'on kus ustu. ");
INSERT INTO kyb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tan nu sija ekay ipatogju nan mangipatog an cha'aju ngachamma makanabju an Apudyus? Uyay chanan manchachakup san hugwis amaschi kahos nan o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ad nu sija ekay kingaanju chanan huyunju ngachamma ummayasiyanju san uchum? Tan amasnat kahos nan o'oon chanan wha'on kus Hudyu! ");
INSERT INTO kyb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sija nan maserpu maid man'uyanganju as isun Amajud langit gway maid kun man'uyangana.” ");
INSERT INTO kyb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Intuyuy Hesus gway nansuyu kun anana, “Ilanju pay ta wha'on ku sasan taku nan mangila an cha'aju ja mangichajaw an cha'aju san manggwaanju san ustu. Tan nu amasnat nan oonju maid kun atchon Amajud langit an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sija nan nu agwad iwhachangju san wha'sigwot achiju iwhakawhaka gway isun nan o'oon chanan taku gway an'annancha mampawhayu san chayo' nan sinagoga ja san aerseersa. Amasna nan o'ooncha tot chajagwon chanan taku chicha. Akammuju, nan inatuttugwaana, naahuscha ayan nan michajagwancha. ");
INSERT INTO kyb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gwon nu humachang aju san wha'sigwot achiju ipaakammus uchum uyay nan apatkanay huyunnu ");
INSERT INTO kyb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tot achi maakammugwan nan inatodnu. Ad as Amam ad langit gway nangila san inggwam nan mangatod an si'a san kanahom. ");
INSERT INTO kyb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ad nu mallugwayu aju achiju oon nan isun nan o'oon chanan an'annancha mampawhayu tan whayugwoncha mallugwayu san sinagoga ja san whayangna chayan tot ilan chanan taku chicha. Nan inatuttugwaana naahuscha ayan nan kanahoncha. ");
INSERT INTO kyb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gwon sa'ad as si'a nu mallugwayu'a lumno''a san ugwertu ad inongwham ja nallugwayu'a an Apudyus gway Amam gway achi kun maila. Ad as Amam gway sija nan mangiila san achi kun maila nan mangatod an si'a san kanahom. ");
INSERT INTO kyb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ad sa'ad nu mallugwayu aju achiju angsanon nan maid kutu'naay apapat gway isun nan o'oon chanan wha'on kus Hudyuway achi mangakammu an Apudyus tan anancha kunnu sachi nan mangngoyan Apudyus san lugwayucha nan angsan ekay whayangnaay iwhakacha. ");
INSERT INTO kyb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Achiju agwaton chicha tan uyay san chaanju chumagwatan an sija aagkammun Amaju nu ngachan nan maserpuju. ");
INSERT INTO kyb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sija nan amasna nan oonju mallugwayu: ‘Amami gway agwad ad langit machaychajaw nan ngachannu. ");
INSERT INTO kyb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umali nan Mantuyajam. Ma'gwa nan whayugwom ad asna luta as isunad langit. ");
INSERT INTO kyb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Atchan cha'ami as anonmi san sana erkaw. ");
INSERT INTO kyb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ad ligwatam chanan whersumi as isun nan malligwatanmi sasan whersun chanan na'awhersu an cha'ami. ");
INSERT INTO kyb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Achi cha'ami ituyung san masulisukanmi jon iligtas cha'ami san lagwingay o'oon Satanas.’ ");
INSERT INTO kyb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Tan nu ligwatanju nan whersun chanan na'awhersu an cha'aju ligwatan ahos Amajud langit nan whersuju. ");
INSERT INTO kyb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gwon nu achiju ligwatan nan whersucha achin kuhos Amaju ligwatan nan whersuju. ");
INSERT INTO kyb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nu mallaun aju kapu an Apudyus achi aju amas mansasanga gway isun chanan takuway an'annancha mampawhayu tan an'annancha mansasanga tot mailan chanan takuway nallauncha. Akammuju, nan inatuttugwaana, naahuscha ayan nan makanabcha. ");
INSERT INTO kyb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gwon sa'ad as si'a nu mallaun'a kapu an Apudyus mancherrup'a ja mansagkay'a ");
INSERT INTO kyb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tot achin chanan taku maakammugwanay nallaun'a. Gwon ahus ekas Amaju gway achi maila as mangakammu. Ad as Amaju gway mangiila san inggwam nan mangatod an si'a san makanabnu. ");
INSERT INTO kyb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Achi aju mansonson as whina'nangju sanna luta tan nan whina'nang sanna luta tangkaan nan la'oy ja lati ancha lon'on chanan manaa'aw ad ina'awcha. ");
INSERT INTO kyb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mansonson ajuwot as whina'nangjud langit tan ad aschi achin kunan la'oy tangkaan ja achi kun mallati ancha achin kunan manaa'aw lon'on ja a'agwon. ");
INSERT INTO kyb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tan nu agwan nan agwachan nan whina'nangnu sachi hos nan agwachan nan somsomo'nu. ");
INSERT INTO kyb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sa'ad ahos nan ata isun chi silaw nan longag gway mangatod as lobhong gway mangila san losan. Sa'ad nu whawhalluwan nan atam isun chi napadchaan nan somsomo'nu ad naakammugwam losan nan whayugwon Apudyus gway ipaakammu an si'a. ");
INSERT INTO kyb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gwon nu lagwing nan mantollongam achim pun maila nan losan. Isun chi manghulingot nan somsomo'nu gway maid kun akammum san ustu. Sija nan, nan mansilwhi as silawnu nu maid atchonas padcha kadto'ay manghulingot nan asasaadnu. ");
INSERT INTO kyb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid kun osas taku as chugwa nan amu as isilwhiyana. Tan kuyaona nan osa ad impatogna nan osa. Ipapatinaay mansilwhi san osa ad nilagwingna nan osa. Wha'on kus mawhalinay mangkisanju nan Apudyus ja nan whina'nang mansilwhiyan. ");
INSERT INTO kyb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sija nan iwhaka' an cha'ajuway achi aju machanakan san iwhijagju nu ngachan nan anonju ja inumonju gwinnu isilupju. Tan jo'o sija napatog nan ma'an san whijag ja luput san longag? ");
INSERT INTO kyb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilanju chanan mammanu', achicha kun mammuya gwinnu manani gwinnu manterpon as anoncha san ayang. Ta'on nu amaschi pa'apa'anan Amajud langit chicha. Jo'o achi aju napatpatog sasan mammanu'? ");
INSERT INTO kyb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aychuuda'ay nu agwad mangipaanchu san whijagna uyay a'it kapu san machanchanakana! ");
INSERT INTO kyb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ka aju machanakan san silup? Ilanju chanan tabwha' gway maag ekay chuma'orcha'or san whibilig. Achicha kun manunger manterwhasu ja manahor. ");
INSERT INTO kyb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gwon iwhaka' an cha'ajuway uyay as Ali Solomon san losanay whina'nangna, maid kun silupnas isun nan ina'erjad nan osa sannachaja tabwha'. ");
INSERT INTO kyb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nu ipawhayun Apudyus chanan hokaw san tayun gway mawhiwhijag a' awniyanna ja whikat ad niwhallu maskob, kanuya ajuman as achina silupan? Whawhang ekay pammatiju! ");
INSERT INTO kyb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ad sija nan achiju som'osom'on ana'ananon, ‘Ngachamman ekay anonmischi ancha inumonmi gwinnu isilupmi?’ ");
INSERT INTO kyb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Annachaja nan anaanapon chanan takuway achi mangakammu an Apudyus. Aagkammun Amajud langit gway maserpuju losan chana. ");
INSERT INTO kyb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sijaot sosom'onju nan Mantuyajan Apudyus ja oonju nan pa'gwana an cha'aju ad inatodna hos nan losanay maserpuju. ");
INSERT INTO kyb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sija nan achi aju machanakan san mipangkop san maserpuju san umaliyay erkaw tan asita hos ekay chi somsom'on san umaliyay erkaw. Umanay as somsom'on nan oon san osa erkaw.” ");
INSERT INTO kyb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Achi aju mangu'um san uchum ta achi cha'aju ahos u'umon an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tan nu ngachan nan ininonjuway nangu'um san huyunju sachi hos nan oon Apudyus gway mangu'um an cha'aju. Ad nu ngachan nan kisong nan i'amanjuway mangisong san huyunju sachi hos nan mangisong Apudyus an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kammoot sija iillan nan a'itay whersun nan huyunnu ja achim sija ilan nan cha'or whersum? Isun nan mangiillam san a''iyutay huyaw san atan nan huyunnu gwon achim pun ilan nan amod cha'orray huyaw san atam. ");
INSERT INTO kyb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ininomma manggwana san huyunnuwon, ‘Chota aano' nan huyawnu nu agwad amod cha'or as huyawnu’? ");
INSERT INTO kyb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Si'aay an'annam mampawhayu san longagnu, aanom janay umuna nan amod cha'or huyawnu tot chata' nan mangilamay mangaan san huyaw nan huyunnu. ");
INSERT INTO kyb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ad achiju hos ipapilit isuyu nan ukud Apudyus sasan takuway iwhilangcha nan ukudna as maid kun patogna. Na mijalikana, nu atchonju san umtowhay asu nan napatog otwhan cha'aju ahos. Ad nu itoperju sasan hoyo' nan a'erjad gway ongongju gway ma'gwaniyon perlas igwalischa kammakamma'on. ");
INSERT INTO kyb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Man'ochaw aju an Apudyus ad inatchan cha'aju. Anaponju an sija nu ngachan nan anaponju ad inchasanju. Man'ab'ab aju an sija ad inigkatna cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tan gwaschi osa man'ochaw maatchan. Na mananap ochasana anapona ja nu ngachan nan man'ab'ab miigkat nan onob an sija. ");
INSERT INTO kyb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngachanna an cha'ajuway ama nan man'ochaw ad nan ana'na as tinapajon sija atchona whatu? ");
INSERT INTO kyb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Gwinnu man'ochaw ad ahos as i'anon sija atchona uyog? ");
INSERT INTO kyb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anna pat cha'ajuway lagwingay takuwot akammuju mangatod as whayu san anana'ju. Kanuyamas Amajud langit as achi mangatod as whayu sasan man'ochaw an sija. ");
INSERT INTO kyb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sija nan oonju san asintatakuju nan whayugwonjuway ooncha an cha'aju tan sijana nan mungimung nan lintog Moses ja nan sussuyun chanan profeta san agwi.” ");
INSERT INTO kyb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gwot asin as Hesus nangijagwat gway manggwana, “Mangoy aju san wha''iyutay sagwang gway umoy san Mantuyajan Apudyus tan ergwa nan sagwang ja ergwa nan chayan gway umoy san misiyanan an Apudyus as ingkaingkana. Ad angsan nan mangoy san sachiyay sagwang. ");
INSERT INTO kyb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gwon wha''iyut nan sagwang ja asisikab nan chayan gway umoy san ma'awhijakan an Apudyus as ingkaingkana. Ad aa''itan ekay ma'a'chas sina. ");
INSERT INTO kyb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ammanju ilan chanan wha'wha''onay profeta. Umalicha an cha'aju gway amas kernero nan ilachaay amu. Gwon nan inatuttugwaana isucha nan atapay asu umtob. ");
INSERT INTO kyb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kapu san o'ooncha maakammugwanju chicha. Jo'o mahuyasan nan hokas nan ubas san chawchagwor gwinnu igos san sassait. ");
INSERT INTO kyb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gwaschi whayuway aju whayu nan ibkasna gwon nan lagwingay aju lagwing nan ibkasna. ");
INSERT INTO kyb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Achi kun mawhalinay mangkas as lagwing nan whayuway aju ja achi kuhos mawhalinay mangkas as whayu nan lagwingay aju. ");
INSERT INTO kyb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Losanay aju gway achi mangkas as whayu masipur ad naskob. ");
INSERT INTO kyb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ad isuna hosay maakammugwanju chanan wha'wha''onay profeta kapu san o'ooncha.” ");
INSERT INTO kyb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Intuyuy Hesus gway manggwana, “Wha'on kus losan chanan manggwana an sa'onon, ‘Apu, Apu,’ mawhalinay mitapi san Mantuyajan Apudyus jon ahus as mitapi chanan manggwa san whayugwon Ama gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","San erkaw gway mangu'uman Apudyus angsan chanan manggwana an sa'onon, ‘Apu, Apu! Jo'o achimi impaakammu nan ukudnu kapu san ayobhongam ja jo'o achi ami namperjaw sasan chimunju kapu san ayobhongam ancha jo'o achi ami nanggwa sasan mataakan kapu san ayobhongam.’ ");
INSERT INTO kyb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ad iwhaka' an chicha gway manggwana, ‘Maid kun agakammu' an cha'aju! Umachaju aju an sa'on, cha'ajuway manggwamanggwa san lagwing.’ ");
INSERT INTO kyb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sija nan nu ngachan nan mangngor sasan ukud'u ja oona mijisu san nasilib gway taku gway san nanggwaana san hoyoyna insaadna nan tu'udna san whatu. ");
INSERT INTO kyb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ummuchan kun nanina'or nan gwanggwang kun nanungnin as pigsa gwot inano''ana nan sachi hoyoy gwot achi kun natugwad tan nisaad nan tu'udna san whatu. ");
INSERT INTO kyb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gwon nan manchochongngor san iwhagwhaka' ja achina patiyon mijisu san osa taku gway katkatung nan somsomo'na gway nangisaad san hoyoyna san kakallis. ");
INSERT INTO kyb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ummuchan kun nanina'or nan gwanggwang kun nanungnin as pigsa gwot nachapyut nan sachi hoyoy kun natugwad gwot amod nan nigwa''iyana.” ");
INSERT INTO kyb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nappung kun Hesus iwhaka chana, nataag nan angsanay taku san insussuyuna ");
INSERT INTO kyb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tan nansuyuway anna nan ayobhongana gway wha'on kus isun chanan mangaagkammu san Lintog. ");
INSERT INTO kyb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sa'ad san nanoskan Hesus gway nerpu san whilig nitunud chanan amochay taku an sija. ");
INSERT INTO kyb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ad sa'ad nan osa laya'iyay naleprosi ummachayug ku an Hesus nampalintumong san sanguna kun anana, “Apu, nu whayugwomay pawhayugwon sa'on akammu'ay lobhongnu.” ");
INSERT INTO kyb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kun inognan Hesus chay laya'i kun anana, “Whayugwo', humayu'a!” Kun nawhanayu chay laya'i san leprosina. ");
INSERT INTO kyb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kun anan Hesus an sija, “Achim pay iwhagwhaka na san uchum gwon i'a manchachawwos mampaila san pachi ta ilana gway hummayu'a. Manchatun'a nu ngachan nan nisuyu san lintog gway inatod Apudyus an Moses as mangakammugwan chanan taku gway hummayu'a.” ");
INSERT INTO kyb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hummu'nag kus Hesus ad Capernaum ummachayug an sija nan osaay apitan chanan surchachun nan Roma kun nampa'pa''aasi an sija ");
INSERT INTO kyb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","gway manggwana, “Apu, sa'ad nan mudchachu' niwhawhannat ad ugwami gway napalalais, maliglikatan as amod.” ");
INSERT INTO kyb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kun anan Hesus, “Umali' pawhayugwon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gwon anan chay apitan, “Apu, achiya' kun miwhilang gway mangajag an si'a san hoyoy'u. Iwhakam ekay ad hummayu nan mudchachu'. ");
INSERT INTO kyb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tan sa'ad ahos as sa'on agwacha' san tuyay nan nangatngatu an sa'on ad anna ahos nan ituyaja'ay susurchachu'. Ana' ad san osaon, ‘I'ad aschi,’ ummoy, ana' ad san uchumon, ‘Gwaynu,’ ummali. Ad ana' ad san mudchachu'on, ‘Oom nannaja,’ inggwana.” ");
INSERT INTO kyb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chingngorn kun Hesus chi nataag as sija kun anana sasan takuway nitunud an sija, “Tuttuwa iwhaka' an cha'ajuway maid kun osa as ini''ila' as amasna nan pammatina sasan ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iwhaka' an cha'aju gway angsan chanan wha'on kus Hudyu gway merpu san hu'nakon nan init ja merpu san si'uton nan init ad na'atu'chucha san oo''anan gway ma'a'an ancha Abraham, Isaac ja Jacob san Mantuyajan Apudyus ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gwon angsan chanan Hudyu gway mitapi otjan san Mantuyajan Apudyus nan miwhallu san lasin nan ingwhilnu gway amod nan hulingotna. Ad ad aschi, asijiiwhilcha ja asingangayotngot nan whawhacha san likatcha.” ");
INSERT INTO kyb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kun anan Hesus san apitan, “Cho lumajaw'a, ma'gwa an si'a nan sanatay pinatim.” Kun hummayu nan mudchachun chay apitan san sachi hos eka uyas. ");
INSERT INTO kyb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ummoy kus Hesus san hoyoy Pedro inilana nan atukangan Pedro huwhai gway inuumhog gway naangod. ");
INSERT INTO kyb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kun inognan Hesus nan imana gwot na'aan nan atungna kun hummangonot pina'anana as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Anna ku mumaschom iyoy chanan taku an Hesus nan angsanay nilno' nan chimunju. Kun pinerjawna chanan chimunju san hosgwayna ekay ad sa'ad nan losanay nasa'it impawhayuna. ");
INSERT INTO kyb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Inggwana na tot tumuttuwa chay ingwhakan profeta Isaias gway anana, “Inaanna chanan sa'it ta'u ja impawhayuna chita'u.” ");
INSERT INTO kyb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","San namingsan inilan ad Hesus nan amochay taku gway namaligwonggwong an sija, ingwhakana sasan pasuyutna gway manggwana, “Inta'u chumormang.” ");
INSERT INTO kyb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gwon chaancha kun umoy ummachayug nan osa mangaagkammu san lintog kun anana an sija “Mistuyu, mitunucha' an si'a uyay nu ngachan nan ajam.” ");
INSERT INTO kyb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kun summungwhat as Hesus gway manggwana, “Sa'ad chanan mutit anna nan luhucha ja sa'ad chanan mammanu' anna nan ubhucha gwon as sa'on gway Ana' nan Taku, maid kun hoyoy'u as masuypa'.” ");
INSERT INTO kyb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ad sa'ad nan osa sasan pasuyutna anana an sija, “Apu, ijujamay iya' jan ilhon as ama.” ");
INSERT INTO kyb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Gwon anan Hesus an sija, “Mitunud'a an sa'on ad nangamung chanan maid ku pammaticha gway anigcha natoy gway mangilhon san isucha natoy.” ");
INSERT INTO kyb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gwot namang'a kus Hesus nihuyog chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ad sa'ad san mamawhang'aancha maag ekay nawhanu'nag nan amod na pigsanaay whali kun choo ekay matabunan nan whang'a sasan tapiya' gwon nanassuy ekay as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ummachayugcha kun an sija whinangonchaay manggwana, “Apu, humachang'a! Anna malinong ta'u!” ");
INSERT INTO kyb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kun anan Hesus an chicha, “Ka'aju umogjat, cha'ajuway whawhang nan pammatina? Hummangon kun pinakino'na nan tungnin ja tapiya' kun kummino' nan tungnin ja tapiya' gwot ummino' nan whaywhay.” ");
INSERT INTO kyb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kun nataagcha gway manggwana, “Ngachamma atakun nina tuwa? Uyay nan tungnin ja tapiya' pakin'ona achon nakakino'!” ");
INSERT INTO kyb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hummu'nag kus Hesus san chomang nan whaywhay san ilin chanan iGerasa, inahot chanan chugwa laya'iyay lumagwa san lijangay loyobhonan gway nilno' chanan chimunju. A'oogjatchas amod sija nan maid kun lumaus san sachiyay chayan. ");
INSERT INTO kyb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kun inip'awchaay manggwana an Hesus, “Achim whijangan cha'ami, si'aay Ana' Apudyus. Achim cha'ami palikatan san chaanan nan chimpuna.” ");
INSERT INTO kyb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kun iningkaw chanan angsanay hoyo' san achani san sachi agwachanchaay asijaayab. ");
INSERT INTO kyb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kun nampa'pa''aasi chachay chimunju an sijaay manggwana, “Nu perjagwom cha'ami, ipooy cha'ami sanchichaja angsanay hoyo'.” ");
INSERT INTO kyb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kun anan Hesus, “I'aju!” Lummagwacha kun ummoycha sasay hoyo'. Kun asitotodcha' losan chachay hoyo'ay ummoy nanotchag san chopyas gway nantubungcha san whaywhay kun nalinongcha. ");
INSERT INTO kyb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gwot sa'ad chachay mamapa''an sasay hoyo' ummagwidcha kun ummoycha kusan hobyoy, impachamagcha nan losanay na'gwa sasay hoyo' ja sasay chugwa laya'iyay nilno' chanan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gwot losanay umili ummoycha inahot as Hesus. Inilacha kus sija nampa'pa''aasicha gway lumajaw as sija san ilicha. ");
INSERT INTO kyb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Namang'a kus Hesus chummormang san whaywhay kun ummoy san ilina. ");
INSERT INTO kyb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kun iningkaw chanan taku nangijoy an sija san napalalaisay laya'i gway inuumhog san oogkana. Inilan ad Hesus nan pammaticha anana san napalalais, “Papigsaom nan somsomo'nu sunud. Niligwata' chanan whersum.” ");
INSERT INTO kyb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ad sa'ad chanan uchumay mangaagkammu san lintog anancha san somsomo'cha, “Sa'ad nan osaanna taku manapapat as maamamangan Apudyus gway ijisuna nan longagna an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Gwon akammun Hesus nan somsomo'cha kun anana, “Ka'aju manomsomo' as lagwing? ");
INSERT INTO kyb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngachan nan lanuy as iwhaka, ‘Niligwata' chanan whersum,’ gwinnu ‘Humangon'a ad nanadchayan'a?’ ");
INSERT INTO kyb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta maakammugwanjuway sa'ad as sa'on gway Ana' nan Taku anna nan ayobhonga'ay malligwat san whersu ad asna luta, ilanju nanna oo'.” Sija nan anana say napalalais, “Humangon'a, ayam nan inogkam ad lummajaw'a ad ugwaju!” ");
INSERT INTO kyb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hummangon kun chay napalalais lummajaw ad ugwacha. ");
INSERT INTO kyb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Inilan ku chanan taku nan sachi ummogjatcha kun chinajawchas Apudyus gway nangatod san amaschi ayobhongan sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lummajaw kus Hesus ad aschi inilana nan osa laya'iyay tummutu'chu san sisingngilan san hugwis gway mangngachan Mateo. Kun anan Hesus an sija, “Tunuchona'.” Lummiggwat kus sija nitunud an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Namingsan ad ummoy cha Hesus san hoyoy Mateo. Ad sa'ad san mangamanganan cha Hesus ummoy na'a'an an chicha nan angsanay manchachakup san hugwis ja chanan humersuwhersu. ");
INSERT INTO kyb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Inilan ku chanan Pariseo na sachi anancha sasan pasuyut Hesus, “Ka ma'a'an nan mistuyuju sasan manchachakup san hugwis ja sasan humersuwhersu?” ");
INSERT INTO kyb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chingngorn kun Hesus chi iyagwatnaay nanungwhat an chicha gway manggwana, “Sa'ad nan takuway maid sa'itna wha'on kus maserpuna nan manaakas. Sija manserpu san manaakas chanan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sijaot achayonju nan pijaona anan nan Ukud Apudyus gway anana, ‘Sija whayugwo' nan achakugwanju nan asintatakuju, wha'on kusan mangichatunanju san ajam.’ Tan wha'on kus sija ummaliya' nan manajaka' sasan whayuway taku, sija ajaka' chanan humersuwhersu.” ");
INSERT INTO kyb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gwot ummoy ummachayug an sija chanan pasuyut Juan gway manggwana, “Kamas cha'ami ja chanan Pariseo nadnachi mallaun kunja kamma chanan pasuyutnu achi oon?” ");
INSERT INTO kyb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kun summungwhat as Hesus gway manggwanaay nangijagwat, “Jo'o mansimo' chanan ma'abyay nu agwad an chicha nan laya'iyay mangibyay. Ayawniyot humu'nag nan chimpuway milajaw an chicha nan laya'iyay mangibyay ad asichaot mallaun.” ");
INSERT INTO kyb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kun intuyuy Hesus iyagwat gway manggwana, “Maid kun mangiter'up san a''opgwa luput san chachaanay silup, tan akusuton nan a''opgwa niter'up nan niter'upana ad ummamamod nan whis'in nan nichaitana gway chachaanay luput. ");
INSERT INTO kyb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ad sa'ad ahos nan whilung achita kun igka san chachaanay mangiigkaanay kadchang tan sa'ad nu amaschi nan ma'gwa awni ad hota'on nan whilung nan chachaanay kadchang ad niwhallu nan whilung. Igkaot san a''opgwa kadchang ta manisu nan mawhajakancha.” ");
INSERT INTO kyb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sa'ad san mangiwhagawhaganasna an chicha hummu'nag nan osaay pangat nan Hudyu gway nampa'yob san sangun Hesus gway manggwana, “Sa'ad nan ana''u huwhai a''ootoy. Gwon umalim ipatay nan imam an sija ad nataku.” ");
INSERT INTO kyb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Summi'ad kus Hesus nitunud an sija kun na'ooy ahos chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sachi ad sa'ad nan osa huwhai nanchaya as nasagwayan as chugwa tagwon, ummachayug kusan ochog Hesus sinakidna nan pagpag nan lagkoyloy gway silup Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tan anana san somsomo'na, “Uyay otjan ekay sakicho' nan lagkoyloy gway silup Hesus, humayuwa'.” ");
INSERT INTO kyb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nantulili kus Hesus gwot inilana chay huwhai, inammana anan, “Papigsaom nan somsomo'nu, kapu san pammatim hummayu'a.” Kun nawhanayu chay huwhai. ");
INSERT INTO kyb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hummu'nag kus Hesus san hoyoy chay pangat nan Hudyu gwot inilana chanan manutungali ancha chanan takuway sumitong, ");
INSERT INTO kyb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","anana, “Lumagwa aju. Achi kun natoy nan ana'ay huwhai, nassuy ekas sija.” Kun inamamangchas sija. ");
INSERT INTO kyb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lummagwa ku chachay takuwot nilumno' as Hesus inognana nan iman chay ana' kun nataku. ");
INSERT INTO kyb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kun nanchinamag nannaja san losanay sa'upon nan sachi ili. ");
INSERT INTO kyb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lummajaw kus Hesus ad aschi nitunud an sija nan chugwa laya'iyay na'uyap kun impa'uychaay manggwana, “Kana' Dabid, achakugwamud cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nilumno' kus Hesus san hoyoy ummoy an sija chachay chugwa na'uyap. Kun anan Hesus an chicha, “Ad mamati ajuway lobhong'u aanon nan uyapju?” Anancha an sija, “Oon, Apu.” ");
INSERT INTO kyb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kun inognan Hesus nan atacha gway manggwana, “Kapu san pammatiju, ma'gwa an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kun na'aan nan uyapcha. Gwot inamman Hesus puyungon chicha gway manggwana, “Ilanju ta maid mangakammu.” ");
INSERT INTO kyb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gwon lummajawcha kun impachamagcha nan mipangkop an sija san losanay sa'upon nan sachi ili. ");
INSERT INTO kyb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aysan ad chachay chugwa na'uyap iyoy chanan taku nan laya'i gway nakigki gway nilno' nan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pinerjaw kun Hesus nan chimunju, kumminga chay nakigki. Kun nataag chanan amochay taku gway manggwana, “Natto, jo'o ekay agwad na'na'gwa' amasna ad Israelanna.” ");
INSERT INTO kyb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gwon anan chanan Pariseo, “Pangat chanan chimunju nan nangatod an sija san ayobhonganay mamerjaw sasan chimunju.” ");
INSERT INTO kyb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kinagka'ay Hesus nan ailiili kun nansuyus sija sasan sinagogacha. Kun impaakammuna nan Whayuway Chamag gway mipangkop san Mantuyajan Apudyus ja impawhayuna chanan nasa'it ja inaanna nan lagwingay li'li'naoncha. ");
INSERT INTO kyb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Inilan ad Hesus chanan taku nachaku as sija an chicha tan malilihu'ancha ja maid kun takus humachang an chicha. Isucha chanan kernero gway maid mangipastur an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gwot iyagwatna sasan pasuyutna gway manggwana, “Tuttuwa angsan chanan taku na'asakana mangagwat san sussuyu gwon a'it nan mangisuyu san ukud'u. Isucha nan minuyaay nerrum gway maapit gwon a'it nan umoy manapit. ");
INSERT INTO kyb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sija nan ilugwayuju an Apudyus gway sin'ugwa san apit ta mangiwhaun as angsan as umoy mangayus sasan taku ad sinuyuwancha san ukud'u, isun nan sin'ugwa san tayun gway iwhaunna chanan umoy manapit tot chakuponcha nan apit.” ");
INSERT INTO kyb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inajakan kun Hesus nan nasagwayan as chugwaay apostolesna, inatchana chicha as ayobhonganay mamerjaw sasan chimunju ja mangaan sasan sa'it ja lagwingay li'li'naon chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Annachaja nan ngachan chanan nasagwayan as chugwaay apostoles: Umuunna ad ekas Simon (gway ma'gwaniyon Pedro) asiyot as Andrew gway sunudna, Santiago gway ana' Zebedeo ja as Juan gway sunudna. ");
INSERT INTO kyb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Asiyot cha Felipe an Bartolome, Tomas, Mateo gway manchachakup san hugwis, Santiago gway ana' Alfeo ja as Tadeo, ");
INSERT INTO kyb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","as Simon gway ananchaon Patriota ja as Judas Iscariote gway nangijiwhit an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sa'ad nannachaja nasagwayan as chugwa, ingwhaunna chicha gway anana nangiwhilin, “Achi aju umoy san ilin chanan wha'on kus ijIsrael ja achi aju lumno' san ilin chanan iSamaria. ");
INSERT INTO kyb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gwon i'ajuwot sasan ijIsrael gway summiyan an Apudyus gway isucha chanan kerneroway nataya'. ");
INSERT INTO kyb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","San umajanju, ipaakammuju gway manggwana, ‘Takangay nan Mantuyajan Apudyus.’ ");
INSERT INTO kyb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ipawhayuju chanan anna sa'itna, takuwonju chanan natoy, ipawhayuju chanan naleprosi ja sa'ad chanan chimunju perjagwonju. Maid kun whajad nan inagwatjuwanna ayobhongan. Sija nan achiju pawhajad nan iwhachangju. ");
INSERT INTO kyb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Achi aju managwit as pila' – gway huyagwan, wha'yaw gwinnu hulinsi. ");
INSERT INTO kyb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Achi aju managwit as mangigkaan san ochonju san mangwhaatanju gwinnu managwit as adgwan chanan silupju gwinnu sinilasju gwinnu sur'udju. Tan nan manterwhasu lobhongna maatchan as maserpuna. ");
INSERT INTO kyb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ad ngachan manay ili nan hu'nakonju, mananap ajus mamayu mammangili an cha'aju ad iningkaw ajud aschi ingkanas lumajaw aju. ");
INSERT INTO kyb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ad sa'ad nu mangiliyon cha'aju, kingaanju chicha ananon, ‘Pawhayugwon Apudyus nan whijagju.’ ");
INSERT INTO kyb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu amman cha'aju mangiliyon san singhoyoy ilugwayuju gway pawhayugwon Apudyus nan wherjancha. Gwon nu achi cha'aju mangiliyon whawhagwiyonju nan sachi ingwhakaju. ");
INSERT INTO kyb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ad nu ngachan nan achi mammangili an cha'aju gwinnu achi manchongor san iwhakaju, lumajaw aju ad pinu'pu'anju nan chapur san i'iju san sanatay hoyoy gwinnu ili. ");
INSERT INTO kyb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tuttuwa iwhaka' an cha'aju gway san erkaw gway mangu'uman Apudyus, ununnayna nan chusan chanan iSodoma ja iGomora san chusan nan sanatay ili.” ");
INSERT INTO kyb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Intuyuy Hesus gway manggwana, “Chongyonju, iwhaun'u cha'aju sasan naujungay taku gway isuju chanan kernero gway umoy san agwachan chanan mangajam gway asu. Maserpu naannad ajuway isun nan uyog ja naanus gway isun nan kalapati gway amu. ");
INSERT INTO kyb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ammanju ilan chanan uchumay taku tan ipawhijang cha'aju san papangat ad sinaplitan cha'aju sasan sinagogacha. ");
INSERT INTO kyb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ijoy cha'aju sasan kuwhinnachur ja chanan ali kapu an sa'on ad sachi nan mangiwhaganju an chicha ja chanan uchumay wha'on kus ijIsrael san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ad sa'ad nu sumerjaoncha cha'aju achi aju machanakan nu ngachan nan iwhakaju tan mipaakammu an cha'aju san sanatay chimpu nan iwhakaju. ");
INSERT INTO kyb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tan wha'on ku an cha'aju nan kadto'ay mangiwhaka gwon nan Ispilitun nan Amaju gway Apudyus nan mangipaakammu san iwhakaju. ");
INSERT INTO kyb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ad san sachi chimpu sa'ad nan osa sunud ipuyangna nan sunudna ipaotoy. Sa'ad ahos chanan ummaana' ipuyangcha nan ana'cha ipaotoy ja isuna hos chanan anana' gway kuyanoncha chanan sinana' an chicha ad impaotoycha chicha. ");
INSERT INTO kyb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ad as cha'aju kuyaon cha'aju san losanay taku kapu an sa'on. Gwon sa'ad nan mangijattom san pammatina gway achina kun isussu'u mataku. ");
INSERT INTO kyb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu palikatan cha'aju san osa ili umagwid aju san sawhali ili. Tuttuwa iwhaka' an cha'ajuway chaanju ad pungpungon nan terwhasuju san losanay ili ad Israel, sa'ad as sa'on gway Ana' nan Taku umaliya' managkulin. ");
INSERT INTO kyb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maid kun pasuyut as nangatngatu san mistuyuna. Maid kuhos mudchachu as nangatngatu san amuna. ");
INSERT INTO kyb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sija nan mapno' otjan nan pasuyut nu mijisu nan mapachasana san mistuyuna. Isuna hos gway mapno' otjan nan mudchachu nu mijisu nan mapachasana san amuna. Anna pas sa'onay mijalig as aman nan singwherjanot ananchaon sa'on as Beelzebub, kanuya ajuman as achi amamod lagwing nan iwhakacha an cha'ajuway mi'a'ahumerjan an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sija nan achi aju umogjat an chicha tan maid kun mitatayu as achi mallotaw ja maid kuhos misulib as achi kun maakammugwan. ");
INSERT INTO kyb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nan ingwhaka' an cha'aju gway ahus ajus nangngor, iwhakaju san losan ad nu ngachan nan nijakakaas an cha'aju, ipaakammuju gway nayagwag sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Achi aju umogjat sasan mangtoy san longag tan achicha kun ma'a'toy san alichodgwa. Gwon sijaot umogjatanju as Apudyus gway sija nan sillobhongay manusa san alichodgwa ja longag ad ingwhilnu. ");
INSERT INTO kyb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Akammuju gway ta'on nu simpipisil ekay la'un nan chugwa u'i'i maid kun osa an chicha as maotchag san luta nu wha'on kus ijujan Apudyus gway Amaju. ");
INSERT INTO kyb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ad sa'ad as cha'aju uyay nan huu'ju akammuna nan whilangcha. ");
INSERT INTO kyb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sija nan achi aju umogjat. Napatpatog ajus amod sasan angsanay u'i'i. ");
INSERT INTO kyb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sija nan nu ngachan nan mangiwhawhagka sasan taku gway mamatis sija an sa'on, ta'choya' as sija san sangun Apudyus gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gwon nu ngachan nan mangisulib an sa'on san sangun chanan taku, isulib'u hos as sija san sangun Ama gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Achiju ananon sija iyali' nan maurnusan chanan taku ad asna luta. Sija iyali' nan mangwhiwhinnusuyan chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tan kapu an sa'on mangkikinnuya chanan manaama ja maniina ancha manatatukanga gway huwhai. ");
INSERT INTO kyb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ad sa'ad nan akuyan nan osa taku chanan ahumerjanna. ");
INSERT INTO kyb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nu ngachan nan mangipatog san amana, inana gwinnu ana'na gway amamod san mangipatokana an sa'on, achi kun miwhilang as pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu ngachan nan achi ma'iijattom san likat ta'on nu sija nan iliglikatna ja i'atoyna san mitunuchana an sa'on, achi kun miwhilang as pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nu ngachan nan ahus nan whijagnas patpatkona, achi kun ma'awhijag an Apudyus as ingkaingkana. Gwon nu ngachan nan achi mangipatog san whijagna kapu an sa'on ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nu ngachan nan mangajag an cha'aju sa'on nan inajakana. Ad nu ngachan nan mangajag an sa'on inajakana hos nan nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu ngachan nan mangajag san profeta kapu tan profetas sija kanahona nan isun nan makanab nan profeta. Ad nu ngachan nan mangajag san nalintokay taku kapu tan nalintog as sija kanahona nan isun nan makanab nan nalintokay taku. ");
INSERT INTO kyb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ad nu ngachan nan mampainum as uyay ekay sintasa chanumay mantagling san osa sasan awhawhaan san pasuyut'u kapu tan pasuyut'us sija, tuttuwa iwhaka' an cha'aju gway maorsan ekajay maorsan.” ");
INSERT INTO kyb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nappung kun Hesus puyungon chanan nasagwayan as chugwaay apostolesna, lummajaw san sachiyay ili tot umoyna isuyu ja ipaakammu nan Whayuway Chamag sasan iliyay achani san sachi. ");
INSERT INTO kyb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chingngorn ad Juan gway Manghohonjag gway agwad san whawhalluchan nan o'oon Kristu, ingwhaunna chanan pasuyutna ");
INSERT INTO kyb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta umoycha imuson an Hesus ananon, “Si'a chay ingwhakan Juan gway umali gwinnu agwad sawhalis uullajonmi?” ");
INSERT INTO kyb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kun sinungwhatan Hesus chicha gway manggwana, “I'aju iwhaka an Juan nan chingngorju ja inilaju. ");
INSERT INTO kyb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ananjuwon sa'ad chanan na'uyap anna nan ilancha ja sa'ad chanan napilay manadchayancha, sa'ad chanan naleprosi hummayucha ja sa'ad chanan natuyong anna nan chongyoncha, sa'ad chanan natoy natakucha ja sa'ad chanan whawha'sigwot nipaakammu nan Whayuway Chamag an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ad ananju hoson piyan chanan takuway achi kun manchugwachugwa san mipangkop an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lummajaw kun chanan pasuyut Juan illukin Hesus iwhaka sasan amochay taku nan mipangkop an Juan gway manggwana, “San ummajanju nangilan an Juan san luta gway maid kun ingkaw as taku, ngachan nan ummoyyu iniila? Jo'o sija ummoyyu iniila nan osa takuway maymaju'u gway isun nan lunu gway ujuujukon nan tungnin? ");
INSERT INTO kyb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nu wha'on, ngachan nan ummoyyu iniila? Osa takuway nansisillup as a'erjad? Wha'on kun tan sa'ad chanan a'erjad nan silupcha iingkawcha san hoyoy chanan ali. ");
INSERT INTO kyb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Iwhakajuud an sa'on nu ngachan nan ummoyyu iniila? Osa profeta? Sija, gwon iwhaka' an cha'aju gway nangatngatu san profeta nan inilaju. ");
INSERT INTO kyb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tan as Juan nan ingwhakan nan annaja Ukud Apudyus gway anana, ‘Anna iwhaun'u nan umuna an si'a gway umoy mangisakana san ajom.’ ");
INSERT INTO kyb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Tuttuwa iwhaka' an cha'ajuway san losanay nijana' gway taku, maid kun nangatngatu an Juan gway Manghohonjag. Gwon nan awhawhaan sasan takuway ituyajan Apudyus nangatngatu an Juan. ");
INSERT INTO kyb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Malluki san nangipaakammugwan Juan gway Manghohonjag mipangkop san Whayuway Chamag ingkana san sana, agwad chanan mangipapatiyay mangipaakammu san mangituyajan Apudyus sasan takuna ja agwad ahos chanan mangipapilitay mitapi sasan takuway ituyajana. ");
INSERT INTO kyb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tan sa'ad chanan losanay profeta ja nan Lintog Moses impaakammucha nan mipangkop san Mantuyajan Apudyus ingkana san chimpun Juan. ");
INSERT INTO kyb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ad nu tuttugwaonju nan ingwhakan nan osa profeta, as Juan tuwa nan Elias gway umali. ");
INSERT INTO kyb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu ngachan nan naingaan maserpu manchongor. ");
INSERT INTO kyb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ad ngachan nan mangijisugwa' san annaja lunap? Isucha nan anana'ay mananannangu san sowhan. Ingwhakan nan uchum san uchumay huyuncha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nantu'er ami san nayagsa' gwon achi aju kun nansaya! Naniwhil ami gwon achi aju kun na'aiwhil.’ ");
INSERT INTO kyb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Kaman iwhaka' gway a'ammaschi chanan taku? Kapu tan ummalis Juan gway achi kun nangnangan ja achi kun ummi''inum san whajas, kun ananchaon agwad nan chimunju an sija. ");
INSERT INTO kyb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ummaliya' kun gway Ana' nan Taku gway mangamangan ja uminiinum, ananjuwon, ‘Ilanju nan osa takuwanna! Lagwotan ja huttongan, hubuyun chanan manchachakup san hugwis ja chanan humersuwhersu!’ Ta'on nu amaschi sa'ad nan laing Apudyus mapano'no'anay tuttuwa kapu san o'oonmi an Juan.” ");
INSERT INTO kyb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gwot jinangjangan Hesus chanan taku san iliyay nanggwaana san aachugwanay mataakan kapu tan achin ku chanan taku nanchu'kan chanan whersucha. ");
INSERT INTO kyb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Anana, “Cha'ajuway iCorasin ja iBetsaida, achagchaku aju! Tan sa'ad otjan nu na'gwad Tiro ja Sidon nan mataakan gway inggwa' an cha'aju, nawhajag otjanay impailacha nan nanu'kancha sasan whersucha san nangisilupancha san sa'u ja chinapuyancha nan wha''agcha. ");
INSERT INTO kyb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iwhaka' an cha'aju gway san erkaw gway mangu'uman Apudyus, ununnayna nan chusan nan iTiro ja iSidon san chusaju. ");
INSERT INTO kyb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ad sa'ad as cha'ajuway iCapernaum, adja ananjuwon mipangatu ajud langit gway machajaw? Wha'on, mitoper aju ad ingwhilnu. Sa'ad otjan nu ad Sodoma nan na'gwaan chanan mataakan gway na'gwa san iliju, sissija otjan san sana na sachi ili. ");
INSERT INTO kyb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gwon iwhaka' an cha'aju gway san erkaw gway mangu'uman Apudyus, ununnayna nan chusan nan iSodoma san chusaju.” ");
INSERT INTO kyb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","San sachi uyas nallugwayus Hesus gway manggwana, “Manjamana' an si'a Ama gway Apun nan losanay agwad ad langit ja anna san luta tan sa'ad nan achim pun impaakammu sasan man'asilib ja naacher taku impaakammum sasan takuway wha'on kus naacher. ");
INSERT INTO kyb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tuttuwa, Ama, inggwam nan amasna kapu tan annaja nan masomam.” ");
INSERT INTO kyb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nappung kus Hesus nallugwayu anana sasan taku, “Sa'ad nan losan inatod Ama an sa'on ad maid kun mangakammu an sa'on gway Ana'na nu achi ahus as Ama. Ad maid kuhos mangakammu an Ama nu achi ahus as sa'on gway Ana'na ja chanan whayugwo'ay piliyon gway mangipaakammugwa' an sija. ");
INSERT INTO kyb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Umali aju an sa'on, cha'aju losanay naunger manommosommo' san whijagju ja machachagsonan ad impaillong'u cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chumngor aju an sa'on ja manacher aju an sa'on tan lumoja' ja wha'on kus nangatu nan somsomo''u ad inchasanju nan umillongan nan somsomo'ju. ");
INSERT INTO kyb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tan nan isuyu' an cha'aju wha'on kus nalikat ja sa'ad nan pa'gwa' an cha'aju wha'on kus nalikat as suyuton.” ");
INSERT INTO kyb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sa'ad san namingsanay Erkaw gway Umillongan nangoy cha Hesus ja chanan pasuyutna san tayun gway namullan san kerkergwit. Ad sa'ad chanan pasuyut Hesus nawhitilcha gwot nangkatucha san kerkergwit as utimancha. ");
INSERT INTO kyb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gwon sa'ad chanan Pariseo inilacha kun chicha man'utim, anancha an Hesus, “Ilam ad nan inggwan chanan pasuyutnu. Mijachi nan sachi san Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kun anan Hesus an chicha, “Jo'o achiju whinasa nan inggwan Dabid san agwi san nawhitilancha sasan takuna. ");
INSERT INTO kyb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nilumno' as Dabid san hoyoy Apudyus kun nangan san tinapay gway nichatun an Apudyus kun pina'anana hos chanan huhuyunna ta'on nu mijachi an sija gway anona gwinnu sasan huhuyunna, maya'sig san papachi gway ahuschas mijujaay mangan. ");
INSERT INTO kyb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jo'o achiju hos whinasa san lintog Moses gway sa'ad san Erkaw gway Umillongan, sa'ad chanan papachi san Templo labyabsingoncha nan Erkaw gway Umillongan tan manterwhasucha san sachi gwon achicha kun ma'awhersu. ");
INSERT INTO kyb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iwhaka' an cha'aju gway annad asna nan osa gway napatpatog san Templo. ");
INSERT INTO kyb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sa'ad otjan nu inakammuju nan pijaona anan nannaja ukud Apudyus gway ananaon, ‘Sija whayugwo' nan achakugwanju nan asintatakuju, wha'on kusan mangichatunanju san ajam,’ achiju otjan inu'um chanan maid whersuna. ");
INSERT INTO kyb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tan as sa'on gway Ana' nan Taku nan sillobhong gway mangijachi nu ngachan nan mijachi san Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lummajaw kus Hesus san sachi tayun ummoy san sinagogacha. ");
INSERT INTO kyb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Awni kun iningkaw nan osa laya'i ad aschiyay napalalais nan imana. Ad kapu tan whayugwoncha mananap as mangichayumancha an Hesus inimuscha gway manggwana, “Ad ijujan nan lintog ta'u gway mangipawhayu san masa'it san Erkaw gway Umillongan?” ");
INSERT INTO kyb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gwot anan Hesus an chicha, “Nu agwad osa an cha'aju as anna nan kernerona gway naotchag san ahut san Erkaw gway Umillongan, jo'o achina umoy ipata'chang. ");
INSERT INTO kyb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Napatpatog as achaju nan taku san kernero! Sija nan mijuja san Erkaw gway Umillongan nan manggwa san whayu.” ");
INSERT INTO kyb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gwot anana say laya'i, “Ujachom nan imam.” Kun inujad chay laya'i nan imana kun hummayu as isun nan osa imana. ");
INSERT INTO kyb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lummajaw ku chachay Pariseo nanuukuchancha nu ngachan nan ininoncha mangipaotoy an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Akammun Hesus nan pangkop chanan Pariseo, sija nan lummajaw ad aschi. Kun nitunud an sija nan angsanay taku gwot impawhayuna losan chanan namin nasa'it. ");
INSERT INTO kyb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kun pinuyungna chicha tot achicha ipaakammu nan mipangkop an sija ");
INSERT INTO kyb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tot ma'gwa nan impaiwhakan Apudyus an profeta Isaias gway anana: ");
INSERT INTO kyb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Annaja nan mansilsilwhiyo' gway pinili', sija nan ipatpatog'u ja mamasoma'. Payo' nan Ispilitu' gway ingkaw an sija, ad impailana nan ustu i'aman'uway mangu'um san losanay taku. ");
INSERT INTO kyb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Achi kus sija ma'aisi' gwinnu mampa'uy, achina kun towhakon nan kingana mansuyu sasan ersa. ");
INSERT INTO kyb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lumoy as sija sasan takuway apsut nan pammatina, ja naanus sasan takuway achicha kun matuyungan nan longagcha. Ituttuyuynaay manggwasna ingkanas mangawha' nan whayu san lagwing. ");
INSERT INTO kyb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ad as sija nan namnamaon chanan atakutaku.” ");
INSERT INTO kyb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sachi kun iyoycha an Hesus nan osa laya'iyay na'uyap ja nakigki gway nilno' nan chimunju. Kun impawhayuna gway pinerjawna nan chimunju an sija, sija nan kumminga ja anna ilana. ");
INSERT INTO kyb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kun nataag losan nan taku nangila kun anancha, “Annaja nin nan Mesias gway kana' Dabid!” ");
INSERT INTO kyb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gwon chingngorn kun chanan Pariseo nan ingwhakan chanan taku, anancha, “Sa'ad nan sanatay taku ma'aperjaw sasan chimunju kapu tan inatchan Beelzebub gway pangat chanan chimunju as ayobhongana.” ");
INSERT INTO kyb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Akammun Hesus nu ngachan nan som'osom'oncha kun anana, “Gwaschi mantuyajan gway mangwhiwhinnursu mampatingka. Ad gwaschi ili gway mangkukuwhat gwinnu wherjan gway maniisi' achi kun humajag. ");
INSERT INTO kyb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isuna hos an Satanas gway nu perjagwona chanan chimunjuna, pijaona ukuchon labyawhanona nan longagna ad nan mantuyajana mampatingka. ");
INSERT INTO kyb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nu ananjuwon perjagwo' chanan chimunju kapu san ayobhongan Beelzebub, ngachan nan sin'ayobhongan san usayon chanan pasuyutjuway mamerjaw sasan chimunju nu'? Nu amasnat, uyay as chicha pano'no'ancha gway nipa'hot nan iwhagwhakaju. ");
INSERT INTO kyb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gwon sa'ad tan Ispilitun Apudyus nan nangatod an sa'on san ayobhongan gway mamerjaw sasan chimunju, sijana nan mangipaila gway hummu'nag nan mangituyajan Apudyus an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nan agwatna, maid kun ma'erno' san hoyoy nan pigsaay taku tot mana'aw san a'unna nu achina jan unaon ita'od nan pigsaay taku ad asinaot ayan nan a'unna. ");
INSERT INTO kyb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nan achi umannatup san o'oo' lagwingonas sa'on. Ad nan achi humachang gway mangajag sasan taku tot sumuyutcha an sa'on, chicha nan manibsibta' an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Sija nan iwhaka' an cha'aju gway losanay ayasin nan whersu ja apapat gway maamamangan Apudyus, mawhalinay ligwatan Apudyus gwon nan manapapat san maamamangan nan Ispilitun Apudyus achin ku Apudyus ligwatan nan whersuna. ");
INSERT INTO kyb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ad nu ngachan nan manapapat as mihursu an sa'on gway Ana' nan Taku mawhalinay ligwatan Apudyus nan whersuna. Gwon nan manapapat as mihursu san Ispilitun Apudyus achin ku Apudyus puyus ligwatan nan whersuna san sana gwinnu ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nu agwatna lagwa gway whayu nan aju, sa'ad nan ibkasna whayu gwon nu lagwing nan aju lagwing ahos nan ibkasna. Tan milasin nan aju kapu san hokasna. ");
INSERT INTO kyb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Isuju chanan nasi'ap gway uyog! Sa'ad tan lagwing ajuway taku maid kun ininonjuway manapapat as whayu. Tan nu ngachan nan iwhakan nan tupo' sachi nan merpu san somsomo'. ");
INSERT INTO kyb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nan whayu taku whayu nan apapatona gway merpu san whayuway somsomo'na gwon nan lagwingay taku apapatona nan lagwing gway merpu san lagwingay somsom'ona. ");
INSERT INTO kyb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iwhaka' an cha'aju gway gwaschi maid silwhina apapaton chanan taku sungwhatancha san chimpun nan mangu'uman Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tan sa'ad chachay ingwhakaju sachi nan mau'umanju nu nalintog aju gwinnu sachi nan mayodchonganju.” ");
INSERT INTO kyb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iningkaw chanan uchumay mangaagkammu san lintog ja chanan Pariseo gway manggwana an Hesus, “Mistuyu, whayugwonmiyay mangipaila'a as imatunay mataakan.” ");
INSERT INTO kyb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Gwon summungwhat as sija gway manggwana an chicha, “Sa'ad nan lunap san sana lummagwing ja mijisu san huwhai whinerjan gway mallaya'i tan wha'on kus napudnu an Apudyus. Man'ochawcha as mataakanay mangimatunan gwon maid kun mipaila as mataakan an chicha nu achi ahus nan mangimatunanay na'gwa an Jonas gway profeta. ");
INSERT INTO kyb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tan as Jonas inso'mern nan cha'orray i'an kun iningkaw as sija san husug chay i'an san tuyu erkaw ja tuyu lawhi, isuna hos an sa'onay Ana' nan Taku gway ingkagwa' as tuyu erkaw ja tuyu lawhi san lohon'u. ");
INSERT INTO kyb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa'ad chanan iNineve mitapicha san annaja lunap sumangu san erkaw gway mangu'uman Apudyus ad tina'choyancha cha'aju gway na'awhersu aju ad nilodchongancha cha'aju kapu tan nanchu'kancha nan whersucha san nangngoyancha san sussuyun Jonas. Gwon ta'on nu agwad an cha'aju nan nangatngatu an Jonas sissija achiju kun tuttugwaon as sija. ");
INSERT INTO kyb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","San erkaw gway mangu'uman Apudyus, sa'ad as cha'ajuway taku san annaja lunap ta'choyan cha'aju hos san reyna ad Seba gway na'awhersu aju ad nilodchongan cha'aju. Kaman? Tan sa'ad as sija nerpu san adadchajuwanay ili ta umoyna chongyon nan inalaing gway sussuyun Ali Solomon. Gwon ta'on nu agwad an cha'aju nan nangatngatu an Solomon sissija achiju kun tuttugwaon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Intuyuy Hesus gway manggwana, “Nu lummajaw nan chimunju san taku umoy mangoy san luta gway maid kun ingkaw as taku mananap as umillongana. Ad nu maid ochasana, ");
INSERT INTO kyb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Anana san somsomo'na, ‘Iya' managkulin san ikaw'uway nerpugwa'.’ Managkulin ad inchasana gway maid ingkaw, por'as ja naurnus. ");
INSERT INTO kyb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Managkulin ad nangihuyog as sija as pitu chimunju gway amod lagwing an sija ad nu lumno'cha ingkawcha ad aschi. Ad sa'ad nan mangudchi asasaad nan sachi taku amod lagwing say chamu. Sija nan amaschi ahos nan ma'gwa san annaja lagwingay lunap.” ");
INSERT INTO kyb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sa'ad san kumingakingaan Hesus san amochay taku, sa'ad nan inana ja susunudna laya'i hummu'nagcha. Summi'adcha san sowhan gway whayugwoncha ma'aapapat an sija. ");
INSERT INTO kyb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kun anan nan osa taku an sija, “Sa'ad cha inam ja chanan susunudnu agwadchas sowhan gway whayugwoncha ma'aapapat an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Anan Hesus gway summungwhat say na'aapapat an sija, “Iwhaka' an si'a nu ngachan nan ina' ja susunud'u.” ");
INSERT INTO kyb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Intuchuna kunan imana sasan pasuyutna, anana, “Annachaja nan iwhilang'us ina' ja susunud'u. ");
INSERT INTO kyb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tan sa'ad chanan manggwa san whayugwon Ama gway agwad ad langit, sija nan iwhilang'us susunud'u ja ina'.” ");
INSERT INTO kyb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sa'ad san sachi hos eka erkaw, lummagwa as Hesus san hoyoy kun ummoy tummu'chu san ikid nan whaywhay. ");
INSERT INTO kyb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kun naayus nan amochay taku an sija, sija nan ummoy as sija tummu'chu san whang'a ad sa'ad nan losanay taku summi'adcha san tayantag. ");
INSERT INTO kyb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kun angsan nan iyagwatna an chicha gway manggwana, “Chongyonju nanna! Iningkaw nan osa takuway ummoy nawwakagwag san whini. ");
INSERT INTO kyb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mawwakagwakagwag kun ummoy nan uchumay gwakagwag san chayan gwot ummoy ku chanan mammanu' timpo'cha. ");
INSERT INTO kyb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sa'ad nan uchum ummoycha san whattuwhattuway a'it nan lutana kun nallasu nan summimitancha kapu san maymayyapit nan lutana. ");
INSERT INTO kyb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gwon ummamod kunan init na'yuy chachay minuya kun na'kingcha tan achicha kun lummamut. ");
INSERT INTO kyb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sa'ad nan uchumay gwakagwag ummoycha san agwachan nan sassait. Kun chummacha''or chanan sait gwot sinjungcha chanan minuya. ");
INSERT INTO kyb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sa'ad nan uchumay gwakagwag ummoycha san lumong kun chumma'orcha gwot whinumkascha. Anna nan whinumkas as singkasut, anna ahos nan onompuyu ja anna ahos nan tuyumpuyu.” ");
INSERT INTO kyb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kun pinungpung Hesus gway manggwana, “Nu ngachan nan naingaan maserpu manchongor!” ");
INSERT INTO kyb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ummachayug ku chanan apostoles anancha an Hesus, “Kaman agwat nan usayom gway kuminga an chicha?” ");
INSERT INTO kyb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Summungwhat kus sija anana an chicha, “Nipaakammu an cha'aju nan chaan kun maakammugwan gway mipangkop san Mantuyajan Apudyus jon sa'ad san uchum achi kun. ");
INSERT INTO kyb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tan nu ngachan nan takuway anna nan naagwatana san mipangkop an Apudyus ja Mantuyajana, achu pay nan maagwatana. Gwon nu ngachan nan takuway maid maagwatana uyay nan a'it gway naagwatana ma'aan an sija. ");
INSERT INTO kyb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ususayo' nan agwat an chicha gway manapapat kapu tan nu iillancha achicha kun milasin ja nu chochongyoncha achicha kun magngor gwinnu maagwatan. ");
INSERT INTO kyb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kun tummuttuwa an chicha nan ingwhakan profeta Isaias gway anana, ‘Manchochongngor aju gwon achiju kun maagwatan. Ad ta'on nu iillanju achiju kun maimatunan ");
INSERT INTO kyb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kapu tan hummatu nan somsomo' nannachaja taku ad achicha kun pijaonay manchongor ja lagwingonchaay masuyuwan. Nu achicha inggwa nan amaschi mailacha nu ngachan nan ma'ma'gwa ja maagwatancha nan chongyoncha ancha ma'aagwat nan somsomo'cha ad nanulincha an sa'on ad impawhayu' chicha.’ ");
INSERT INTO kyb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gwon sa'ad as cha'aju piyan aju tan mailaju nan o'oo' ja magngorju nan iwhaka'! ");
INSERT INTO kyb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tuttuwa iwhaka' an cha'aju gway angsan chanan profeta ancha nalintokay taku gway mamayu mangila san iillanju gwon achicha kun inila ja whayugwonchaay chongyon nan chochongyonju gwon achicha kun chingngor.” ");
INSERT INTO kyb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sija nan sa'ad as cha'aju, chongyonju nan pijaona anan nan agwat gway mipangkop san nawwakagwag. ");
INSERT INTO kyb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Sa'ad nan manchongor san Whayuway Chamag gway mipangkop san Mantuyajan Apudyus ja achina kun maagwatan, umalis Satanas ad pillosna nan ukud gway chingngorna. Annaja nan pijaona anan nan gwakagwag gway ummoy san chayanay nigwakagwakana. ");
INSERT INTO kyb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ad sa'ad nan na'gwa say gwakagwag gway ummoy san whattuwhattuway a'it nan lutana mijagwat sasan taku gway chingngorcha kun ekay ukud Apudyus nallaylajadchaay nangagwat. ");
INSERT INTO kyb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gwon isucha chachay minuya gway achi kun lummamut sija nan chadchaan kun na'yuycha. Ad isuna hos nu humu'nag nan likat an chicha gwinnu matupotupo'cha kapu san mamatiyancha ad chadchaan ad nanchu'kancha nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ad sa'ad nan uchumay gwakagwag gway ummoy san agwachan nan sassait, isun chachay nangngor san ukud Apudyus. Gwon kapu san somsomo'cha san whijagcha ja mauyawcha san atchon nan whayangna mampawha'nang ancha mayapancha san whayangna ekasnat, sija nan sachi nan nasjungan nan ukud Apudyus san whijagcha ad achi kun nangkas nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ad sa'ad chachay gwakagwag gway ummoy san lumong, mijagwat sasan takuway nangngor san ukud Apudyus kun inagwatcha ja tinuttuwacha. Ad isucha hos chanan minuya gway humkascha as singkasut, onompuyu ja tuyumpuyu.” ");
INSERT INTO kyb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Annaja hos nan sawhali agwat gway ingwhakan Hesus an chicha gway anana, “Mijagwat san Mantuyajan Apudyus nan osa taku ummoy nawwakagwag san whayu whini san tayunna. ");
INSERT INTO kyb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gwon lawhi kun, sa'ad san anna masusujop chanan taku, ummoy nan ahursuna kun iwwakagwagna chanan lukam san hoyahoyaat nan minuyanaay kerkergwit kun lummajaw. ");
INSERT INTO kyb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chumma'or kunan minuya gwot mamushus, naimatunan ahos chanan lukam gway tummuhu. ");
INSERT INTO kyb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ummoy ku ummachayug chachay mudchachun nan sin'ugwa san tayun anancha an sija, ‘Apu, tan sija ka iwwakagwagnu nan whayu whini san tayunnu ja. Kunja agwamma nerpugwan chanan lukam?’ ");
INSERT INTO kyb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kun anana an chicha, ‘Nan ahursu nan nanggwa sa sachi.’ “Kun anan chachay mudchachu an sija, ‘Whayugwomay i'ami lukaman?’ ");
INSERT INTO kyb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Gwon anana, ‘Achi tot achi mitapi mau'put nan kerkergwit an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Taakun mangkisancha chuma'or ingkanas iya''ani. Ad iya''ani ad, ingwhaka' sasan mananiyay unaoncha u'puton chanan lukam ad whinohodcha ad singkobcha. Mappung ad chinakupcha nan kerkergwit ijoy san ayang'u.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sawhali hosay agwat nan ingwhakan Hesus an chicha gway manggwana, “Mijagwat nan Mantuyajan Apudyus san hu'orn nan mustard gway iyoso' nan osa taku san tayunna. ");
INSERT INTO kyb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sijana nan awha''ijutan san losanay hu'or gwon nu chuma'or, sija nan acha'yan san losanay minuya san kerchin ad nangngachan isun chi aju nan acha'orna ad ummoy nangubhu chanan mammanu' sasan pangana.” ");
INSERT INTO kyb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sawhali hos nan iyagwatna an chicha gway manggwana, “Mijagwat nan Mantuyajan Apudyus san yeast gway inayan kunan osa huwhai, in'ayutna san sillataay alina ingkana san whinumter losan.” ");
INSERT INTO kyb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Losan nannachaja iyagwat Hesus sasan taku ad maid kun uchum as ingwhakana an chicha nu achi ahus nan agwat. ");
INSERT INTO kyb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Inggwana nan amasna tot tumuttuwa nan ingwhakan nan profetan Apudyus gway anana, “Usayo' nan agwat nu kumingaa' an chicha, ipaakammu' an chicha nan chaan kun maakammugwan malluki san na'gwaan nan luhung.” ");
INSERT INTO kyb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pinerjaw ku Hesus chanan taku, nilumno' as sija san hoyoy. Kun ummoy ummachayug an sija chanan pasuyutna gway manggwana, “Ipaagwatnu an cha'ami nan agwat gway mipangkop san lukam san tayun.” ");
INSERT INTO kyb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kun anan Hesus gway summungwhat, “Nan mangigwakagwag san whayu whini, as sa'on gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sa'ad nan tayun sija nan luhung ad nan whayu whini chicha nan taku ituyajan Apudyus. Ad sa'ad chachay lukam chicha nan takuway ituyajan Satanas. ");
INSERT INTO kyb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ad nan ahursu gway sija nan nangigwakagwag sasan lukam, as Satanas. Nan iya''ani, sija nan pungpung nan chimpu ja sa'ad chanan manani, chicha nan a'anghel. ");
INSERT INTO kyb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nu ngachan nan i'aman gway mangu'put sasan lukam ad pinuuyan san apuy, amaschi ahos nan ma'gwa san pungpung nan chimpu. ");
INSERT INTO kyb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sa'ad as sa'on gway Ana' nan Taku, iwhaun'u chanan a'anghel'u ad inaancha san Mantuyaja' nan losanay mangkapugwan nan whersu ja losanay manggwamanggwa san lagwing. ");
INSERT INTO kyb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ad intopercha chicha san kumilakilab gway apuy. Ad aschi nan asijiiwhilancha ja mangngilngiltoncha nan whawhacha. ");
INSERT INTO kyb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ad sa'ad chanan nalintog gway taku pumapadchacha san Mantuyajan Amacha as isun nan init. Nu ngachan nan naingaan maserpu manchongor. ");
INSERT INTO kyb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mijisu san Mantuyajan Apudyus nan whina'nang gway ni'aub san tayun gway inchasan kunan osa laya'i tinabunana. Ad kapu san lagsa'na lummajaw kun illa'una nan losanay u'ugwana kun nila'uwana nan sachi tayun. ");
INSERT INTO kyb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mijisu ahos san Mantuyajan Apudyus nan osa taku mangamusanti gway mananaanap as man'awhawhayu perlas. ");
INSERT INTO kyb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Inchasana kunan osa amod nan patogna perlas, lummajaw kun illa'una nan losanay u'ugwana gwot nila'uwana nan sachi perlas. ");
INSERT INTO kyb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Mijisu ahos san Mantuyajan Apudyus nan chuliit gway nipa'at kusan whaywhay nangna san nan'aya'ayasiyay i'an. ");
INSERT INTO kyb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Napnu kunot ino'ascha san tayantag tummu'chucha kun inayacha chanan maischa inigka sasan mangigkaan ad sa'ad chanan achicha kun ischa ingwhallucha. ");
INSERT INTO kyb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amasna nan ma'gwa sa mapungpungan nan luhung. Umali chanan a'anghel ad tin'oncha chanan lagwingay taku sasan nalintokay taku ");
INSERT INTO kyb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ad ingwhallucha chanan lagwingay taku san kumilakilab gway apuy. Aschi nan asijiiwhilancha ja mangngilngiltoncha nan whawhacha.” ");
INSERT INTO kyb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kun inimus Hesus an chicha gway manggwana, “Ad naagwatanju losan nannachaja?” Anancha an sija, “Oon.” ");
INSERT INTO kyb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kun anan Hesus an chicha, “Sija nan gwaschi mangaagkammu san lintog gway mangngachan pasuyut san Mantuyajan Apudyus, mijisu san taku gway sin'ugwa san osa hoyoy gway mang'at san chachaan ja a''opgwaay whina'nangna san mangiterterponana.” ");
INSERT INTO kyb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nappung kun Hesus iwhaka chanan agwat, lummajaw as sija ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ummoy kus sija san iliyay chumma'yana, nansuyu sasan taku san sinagogacha. Sija nan nataagcha kun anancha, “Agwamma nangallan nannaja taku san laingna ja agwamma nangallana san ayobhongana gway manggwa san mataakan? ");
INSERT INTO kyb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tan ana' kayna nan apantilu ja. Jo'o wha'on an Maria nan inana ja jo'o wha'on an cha Santiago, Josep, Simon ja Judas nan susunudna. ");
INSERT INTO kyb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tan asna kanan ingkagwan nan susunudna hubhuwhai ja. Kunja agwamma nangallana san laingna ja ayobhongana gway manggwa san mataakan?” ");
INSERT INTO kyb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ad sija nan achicha kun patkon as sija. Gwon anan Hesus an chicha, “Ngachammanay iliyay umajan nan profetan Apudyus, whigwhikonchas sija. Gwon nan kadto'ay ailijana ja chanan chochogkana, achicha kun whigwhikon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kun achi kun nanggwas angsanay mataakan san sachiyay ili kapu tan achicha kun tuttugwaon as sija. ");
INSERT INTO kyb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sa'ad san sachi chimpu chingngorn Herod gway mangituyay ad Galili nan mipangkop an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kun anana sasan mansilsilwhiyona, “Na sachi taku as Juan gway Manghohonjag. Nataku san natojana, sija nan agwad an sija nan ayobhonganay manggwa san mataakan.” ");
INSERT INTO kyb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tan sa'ad san nugwan sa'ad as Herod impatiliwnaot sija kus Juan asinaot ipawhayud kapu an Herodias gway in'ahoyoyna gway asagwan Felipe gway sunudna. ");
INSERT INTO kyb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tan inna'innanan sija Juan gway Manghohonjag san agwi an Herochon, “Achi kun ma'gwa nan i'ahoyoynu as Herodias.” ");
INSERT INTO kyb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ad ta'on nu whayugwon Herod gway ipaotoy as Juan ummogjat sasan taku tan ingwhilangchaay profeta as sija. ");
INSERT INTO kyb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Niwhatug kunan erkaw gway nijana'an Herod nansaya nan whawhallasay ana' Herodias san sangun chanan mangili kun pinayagsa'na as Herod. ");
INSERT INTO kyb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kapu san sachi insapatana an sija gway atchona nan ngachammanay whayugwona ochagwon. ");
INSERT INTO kyb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kun iningkaw nan ingwhakan inana an sija gwot anan nan whawhallas, “Atchom an sa'on nan wha''ag Juan gway Manghohonjag gway napapallangkan.” ");
INSERT INTO kyb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kun amod nan sangan Ali Herod gwon kapu san lausna ingwhaka an sija san sangun chanan mangilina, ingwhilinna gway maatod nan wha''ag. ");
INSERT INTO kyb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gwot nangwhaun kus sija impakungsurna as Juan san whawhalluchan. ");
INSERT INTO kyb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kun niijoy chay wha''ag gway napapallangkan kun naatod say whawhallas gwot asinaot atchon an inana. ");
INSERT INTO kyb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kun ummoy chanan pasuyut Juan gwot inayacha nan lachagna kun inilhoncha. Lummajawcha kun ummoycha ingwhaka an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chingngorn ad Hesus nan na'gwa an Juan lummajaw gway namang'a kun ummoy tumma'iyan san luta gway maid kun ingkaw as taku. Chingngorn kunan amochay taku nisu'nubcha an sija gway nanadchadchayan gway nerpu sasan ili. ");
INSERT INTO kyb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nilumsa kus Hesus san whang'a inilana chachay amochay taku kun nachaku an chicha gwot impawhayuna chanan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Anna kunay mumaschom ummoy chanan apostolesna an sija gway manggwana, “Maid kun hohoyoy sannaja ja takangay mumaschom. Perjagwom chanan taku tot umoycha sasan hobyoy malla'u as anoncha.” ");
INSERT INTO kyb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Gwon anan Hesus an chicha, “Wha'on kus maserpu lumajawcha, atchanju chichas anoncha.” ");
INSERT INTO kyb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gwon anancha an sija, “Ahus ekay lima tinapay ja chugwa i'an as anna.” ");
INSERT INTO kyb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kun anan Hesus, “Ijaliju an sa'on sannaja.” ");
INSERT INTO kyb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ingwhakana kusan amochay taku gway tu'chucha san ap'api'ap gwot inayana nan lima tinapay ja chugwa i'an gwot nantangad ad langit, nanjaman. Pini'pi''ina kunan tinapay inatodna sasan pasuyutna kun impaigwatgwatna an chicha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kun nangancha losanot nabsugcha. Kun chinakup chanan pasuyut Hesus chanan nasergwa san napi'pi''iyay tinapay gway napnu nan nasagwayan as chugwaay langngay. ");
INSERT INTO kyb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ad sa'ad chanan nangan gway lallaya'i ummoy as limallihu, wha'on kus niwhilang nan hubhuwhai ja anana'. ");
INSERT INTO kyb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sachi kun nanipooy Hesus sasan apostolesna san whang'a ta umunacha chumormang an sija. Anna kunay umoycha pinerjaw Hesus chachay taku. ");
INSERT INTO kyb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nappungna kun perjagwon chanan taku nanakacha as sija gway osossa''an san whilig tot mallugwayu. Lummawhi kun ummoossas sija ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ad sa'ad nan whang'a san sachi uyas ummachaju san tayantag gway ichu'yachu'yang nan tapiya' tan abton nan tungnin. ");
INSERT INTO kyb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Anna ku mumachani ummoy as Hesus an chicha gway manadchadchayan san lawhaw nan chanum. ");
INSERT INTO kyb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Inilan ku chachay pasuyut as sijaay manadchadchayan san lawhaw nan chanum nakuyus amod nan somsomo'cha gway manggwana, “Ayan!” Ad kapu san ogjatcha nampa'uycha. ");
INSERT INTO kyb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gwon nakaninga as Hesus gway manggwana, “Sa'on na, achi aju umogjat. Papigsaonju somsomo'ju.” ");
INSERT INTO kyb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Summungwhat kus Pedro an sija, anana, “Apu, nu tuttuwa si'a nat iwhakam an sa'on ta umaliya' an si'a san chanum.” ");
INSERT INTO kyb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kun anan Hesus, “Gwaynu.” Lumsa kus Pedro san whang'a nanadchayan san chanumay umoy an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gwon naki'nana kunan pigsa tungnin ummogjat as sija gwot malinong kus sija, nampo'aw gway manggwana, “Apu, takuwona'!” ");
INSERT INTO kyb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nanijadchang kun Hesus san imana impukodnas Pedro gwot anana an sija, “Whawhang nan pammatim! Ka'a manchugwachugwa?” ");
INSERT INTO kyb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sachi kunot ummoychas whang'a kummino' nan tungnin. ");
INSERT INTO kyb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ad sa'ad chachay iningkaw san whang'a nanchajawcha an Hesus gway manggwana, “Tuttuwa Ana' Apudyus as si'a.” ");
INSERT INTO kyb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chummormangcha kun san whaywhay hummu'nagcha ad Genesaret. ");
INSERT INTO kyb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Naimatunan ku chanan takus Hesus nangiwhauncha as umoy mangipachamag san awhijawhija' kun iyoycha an Hesus nan losanay nasa'it. ");
INSERT INTO kyb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kun nampa'pa''aasi chanan taku an sijaay uyay ognancha otjan ekay nan pagpag nan lagkoyloy gway silupna. Ad sa'ad nan losanay nangognan san pagpag nan silupna hummayucha. ");
INSERT INTO kyb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sachi ad ummoy ummachayug an Hesus chanan nerpud Jerusalem gway Pariseo ja chanan mangaagkammu san lintog gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kama chanan pasuyutnu labsingon nan ukalin nan chacha''or ta'u gway achicha kun manghuyu nu mangancha?” ");
INSERT INTO kyb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kun summungwhat as Hesus an chichaay manggwana, “Kaju hos achi chongyon nan whilin Apudyus kapu ekay san ukaliju? ");
INSERT INTO kyb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tan anan Apudyus, ‘Chumngor'a an cha amam an inam,’ ja ‘Nan manapapat as lagwing san amana ja inana lobhongna mapatoy.’ ");
INSERT INTO kyb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Gwon ayasi nan isuyuju tan ananju, ‘Nu ngachan nan manggwana san amana ja inanaon, “Ngachan manay maatod'u an cha'aju, naahus'u ingwhakaay atcho' an Apudyus,” ");
INSERT INTO kyb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","maserpu achina atchon nan sachi atchona an amana ja inana.’ San amasna nilagwingju nu ngachan nan ingwhilin Apudyus sasan taku gway ooncha kapu san mangiwhagam an chichaay patiyoncha nu ngachan nan insuyun chanan aammaju. ");
INSERT INTO kyb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Cha'ajuway an'annanju mampawhayu, ustu nan nangijununnaan profeta Isaias nangiwhagan san mipangkop an cha'aju gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Sa'ad nannachaja taku, chajagwona' san tupo'cha gwon achaju nan somsomo'cha an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maid kun silwhin nan manaychajagwancha an sa'on, isussuyucha nan lintog gway inggwan chanan taku ad ingwhilangcha as lintog Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Inajakan kun Hesus chanan taku, anana an chicha, “Chongyonju nannaja iwhaka' tot maagwatanju. ");
INSERT INTO kyb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wha'on kusan iperno' nan taku san tupo'na nan mangipergwing an sija gwon sija mangipergwing an sija nan lagwingay ipayagwan nan tupo'na.” ");
INSERT INTO kyb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ummoy ku chanan pasuyutna, anancha an sija, “Achim akammuway sa'ad chanan Pariseo lummagwing nan somsomo'cha san chingngorcha nan ingwhakam?” ");
INSERT INTO kyb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kun summungwhat as Hesus gway manggwana, “Losanay minuya gway wha'on kus immuyan Ama gway agwad ad Langit, mawhakut.” ");
INSERT INTO kyb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nangamungcha. Ichayancha chanan taku gwon isucha chanan na'uyap gway ipujutcha nan isucha na'uyap. Ad nu na'uyap nan mangipujut san na'uyap, losancha maotchag san ahut. ");
INSERT INTO kyb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Summungwhat kus Pedro anana an Hesus, “Ipaagwatnu an cha'ami chay agwat gway mipangkop san mangipergwing san taku.” ");
INSERT INTO kyb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kun anan Hesus, “Jo'o sissija ahosay achiju ekay maagwatan. ");
INSERT INTO kyb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sissijaay achiju kun maagwatan gway losanay ma'an gway lumno' san tupo' nan taku umoy san hota' ad awni ad nijattay. ");
INSERT INTO kyb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gwon nan lagwingay ihungangay nan tupo' merpu san somsomo' ad sachi nan mangipergwing san taku. ");
INSERT INTO kyb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tan sa'ad nan lagwingay somsomo' nan taku sachi nan merpugwan nan lagwing. Ad nan mangwhanakana lagwingay kidkichu gway isun chi pumatoy, ma'assuy san wha'on kus asagwana, manggwas whayangna awhawhain ja ina'aisaw gway pijaon nan longag, mana'aw, mangita'chor san wha'on kus tuttuwa ja manapapat as lagwing san osa taku. ");
INSERT INTO kyb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Annachaja nan mangipergwing san taku gwon nan achi kun manghuyugwan san manganan wha'on kus sachi nan mangipergwing san taku.” ");
INSERT INTO kyb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lummajaw kus Hesus san sachi ili ummoy sasan ili gway sa'upon nan Tiro ja Sidon. ");
INSERT INTO kyb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ad sa'ad nan osa huwhaiyay iCanaan gway nerpu san sachi ili, inip'awna gway manggwana, “Achakugwana'ud, Apu, gway kana' Dabid! Sa'ad nan ana''u huwhai mapalpalikatan as amod tan nilno' nan chimunju.” ");
INSERT INTO kyb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gwon achin ku Hesus sinungwhatan as sija. Ummachayug ku chanan pasuyutna nampa'pa''aasicha an sija gway manggwana, “Perjagwom as sija tan mampo'apo'aw gway mituntunud an chita'u.” ");
INSERT INTO kyb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gwon summungwhat kus Hesus, anana, “Niwhauna' ekay gway humachang san ijIsrael gway isun nan kerneroway nataya'.” ");
INSERT INTO kyb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gwon ummoy chay huwhai nampa'yob san sangun Hesus gway manggwana, “Apu, whachangana'ud!” ");
INSERT INTO kyb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kun iyagwat Hesus gway manggwana, “Wha'on kus mawhalinay ipa'anta nan anon nan ana' sasan asu.” ");
INSERT INTO kyb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Anan chay huwhai, “Tuttuwa nan sanat gway anam, Apu, gwon uyay chanan asu anoncha nan hugtaay maja'aja' san mamangnganan nan amucha.” ");
INSERT INTO kyb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gwot summungwhat kus Hesus, anana say huwhai, “Cha'or nan pammatim! Ma'gwa an si'a nan whayugwom.” Kun hummayu nan ana'na san sachiyay uyas. ");
INSERT INTO kyb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Lummajaw kus Hesus san sachi ili ummoy san ikid nan Whaywhay gway Galili. Kun ummoy nanakacha san whilig gwot tummu'chu ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kun ummoy nan amochay taku an sija gway inagwitcha chanan napilay, chanan na'uyap, chanan achi kun ma'akichu, chanan nakigki ja uchumay anna sa'itna. Kun inigkacha chicha san sanguna gwot impawhayuna chicha. ");
INSERT INTO kyb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kun nataag chanan taku san inilacha chachay nakigki gway kuminga, chachay achi kun ma'akichu gway hummayu, chachay napilay gway manadchayan ja chachay na'uyap gway anna ilancha. Kun chinaychajawcha nan Apudyus chanan ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Inajakan kun Hesus chanan pasuyutna, anana, “Machakuwa' sannachaja amochay taku tan tuyu erkaw nan iniingkagwancha an sa'on ad maid kun anoncha. Ad lagwingo'ay perjagwon chicha gway nawhiwhittil tan tugwakay maagcha ekay matugwad san chayan.” ");
INSERT INTO kyb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kun anan chachay pasuyut an sija, “Agwamma inta'u mangallan as angsan as tinapay as ipa'an san amasnaay aachun nan taku san maid kun hohoyoy ad asna?” ");
INSERT INTO kyb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kun anan Hesus an chicha, “Aman nan tinapay gway agwad an cha'aju?” Anancha, “Pitu ja a'itay wha'iyut gway i'an.” ");
INSERT INTO kyb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gwot impatu'chun kun Hesus chanan taku san luta, ");
INSERT INTO kyb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","inayana chachay pituway tinapay ja chachay i'an gwot nanjaman ku an Apudyus, pini'pi''ina. Kun inatodna sasan pasuyutna gwot iwwatgwatcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kun nangancha losanot nabsugcha. Nappungcha kun, chinakup chanan pasuyut nan nasergwa sasan napi'pi''i, kun napnu nan pitu langngay. ");
INSERT INTO kyb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sa'ad nan whilang chanan taku gway nangan, opat lihu, achi kun niwhilang nan hubhuwhai ja anana'. ");
INSERT INTO kyb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sachi kunot pinerjaw Hesus chachay taku namang'as sija kun ummoy san ili gway sa'upon nan Magadan. ");
INSERT INTO kyb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ummachayug kun chanan Pariseo ja Saduceo an Hesus pinadpadchascha ochagwon an sija ta mangipaila an chicha as imatunay mataakan as mamatiyancha nu tuttuwaay Apudyus nan nangiwhaun an sija. ");
INSERT INTO kyb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gwon summungwhat as sija gway manggwana an chicha, “Nu mumaschom ja maninag nan langit, ananjuwon malikat nan tayun as whikat. ");
INSERT INTO kyb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ad nu ilanjuway maninag ja mamuhunot nan langit san whigwhikat, ananjuwon umuchan as awni. Akammuju gway mangimatun san ilan nan langit gwon achiju kun maimatunan nan ma'ma'gwa san sana chimpu. ");
INSERT INTO kyb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sa'ad nan lunap san sana lummagwing ja mijisu san huwhai whinerjan gway mallaya'i tan wha'on kus napudnu an Apudyus. Man'ochawcha as mataakanay mangimatunan gwon maid kun mipaila as mataakan an chicha nu achi ahus nan mangimatunanay na'gwa an Jonas.” Nappung kun chi tinaynana chichaot aysan. ");
INSERT INTO kyb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chummakus kun chachay pasuyut san chomang nan whaywhay, simsimmo'chaay naligwatancha nansongot as tinapay. ");
INSERT INTO kyb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kun anan Hesus an chicha, “Ammanju ilan nan yeast chanan Pariseo ja Saduceo.” ");
INSERT INTO kyb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kun asijaapatcha gway manggwana, “Amasnat nan ingwhakana tan maid kun songot ta'us tinapay.” ");
INSERT INTO kyb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Inakammun kun Hesus nan apaapatoncha anana an chicha, “Ka whawhang ekay pammatiju! Kajuman sija apaapaton nan inamaid nan tinapayyu. ");
INSERT INTO kyb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jo'o achiju ekay maagwatan gwinnu masmasmo' nan lima eka tinapay gway nipa'an sasan limallihu taku kun amanaay langngay nan nasergwaay chinakupju. ");
INSERT INTO kyb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jo'o achiju hos masmasmo' nan pitu tinapay gway nipa'an sasay opat lihuway taku kun amanaay langngay nan nasergwaay chinakupju. ");
INSERT INTO kyb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Achiju eka maagwatanay wha'on kus mipangkop san tinapay nan anna iwhakawhaka' an cha'aju. Ammanju ilan nan yeast chanan Pariseo ja Saduceo!” ");
INSERT INTO kyb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gwot naagwatan chachay pasuyut gway wha'on kus mipangkop san yeast gway mampahoter san tinapay nan iwhagwhakana gwon mipangkop san lagwingay sussuyun chanan Pariseo ja Saduceo gway naya'a chumayait. ");
INSERT INTO kyb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hummu'nag kus Hesus san ili gway Cesarea Filipos, anana sasan pasuyutna, “Ngachan nan anan chanan taku san mipangkop an sa'on gway Ana' nan Taku?” ");
INSERT INTO kyb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kun anancha, “Anan nan uchum si'a as Juan gway Manghohonjag. Anan nan uchum si'a as Elias, anan ahos nan uchum si'a as Jeremias gwinnu osa sasan uchumay profeta san agwi.” ");
INSERT INTO kyb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Anana an chicha, “As cha'aju kay ngachan nan mangngachanju an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gwot summungwhat as Pedro gway manggwana, “Si'a nan Kristu, nan Ana' nan mawhiwhijakay Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kun anan Hesus an sija, “Piyan'a, Simon gway ana' Jonas tan wha'on kus taku nan nangipaakammu an si'a gwon as Ama gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ad iwhaka' ahos an si'a gway si'a nan ma'gwaniyon Pedro gway nan pijaona anan whatu. Sannaja whatu, isaad'u nan singwhaan'u gway chicha chanan mamati an sa'on ad sa'ad chanan ayobhongan nan otoy achi kun ma'aawha' an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Atcho' an si'a nan chursi' san Mantuyajan Apudyus. Ad nu ngachan nan ijachim gway oon chanan takud asna luta, naahus Apudyus gway agwad ad langit tachunan. Ja nu ngachan nan ijujam ad asna luta, naahus Apudyus gway agwad ad langit tachunan.” ");
INSERT INTO kyb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sachi kun pinuyung Hesus chanan pasuyutna gway maid kun mangiwhagancha gway sija nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Malluki san sachi illukin Hesus gway mangipaagwat sasan pasuyutna gway maserpu umoy as sija ad Jerusalem ad napalikatan as amod sasan chacha''orn nan Hudyu, sasan papangat nan papachi ja sasan mangaagkammu san lintog. Ad impaotoychas sija ad mi'atlu achay erkaw nataku. ");
INSERT INTO kyb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Inta'iyan kun Pedro as sija ingwhakana an sija gway manggwana, “Achin ku Apudyus ijuja nat, Apu! Achi kun puyus ma'gwa an si'a nan amasna.” ");
INSERT INTO kyb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gwon nansakung kus Hesus, anana an Pedro, “Umachaju'a an sa'on, Satanas! Tumitiper'a an sa'on tan wha'on kus somsomo' Apudyus nan sosom'om gwon somsomo' chanan taku.” ");
INSERT INTO kyb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sachi kun anan Hesus sasan pasuyutna, “Nu ngachan nan mamayu mitunud an sa'on, maserpu achina sija somsom'on nan longagna, isimo'naay mamati ta'on nu sija nan iliglikatna ja i'atoyna ad nitunud an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tan nu ngachan nan ahus nan whijagnas patpatkona, achi kun ma'awhijag an Apudyus as ingkaingkana. Gwon nu ngachan nan achi mangipatog san whijagna kapu an sa'on, ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Maid kun kutu' nan man'ugwan nan osa taku nan losanay agwad san luhung nu achi ma'awhijag an Apudyus as ingkaingkana. Maid kun mawhalin nan osa taku atchon an Apudyus as iwhajadna tot ma'awhijag an sija as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ad sa'ad ahos as sa'onay Ana' nan Taku managkulina' ad asna luta gway anna an sa'on nan ayobhongan Ama gway huyun'u chanan a'anghel ad sinuwhalita' nan gwaschi taku san whatug nan inggwana. ");
INSERT INTO kyb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tuttuwa iwhaka' an cha'aju gway anna nan uchum an cha'aju san annaja gway achi kun matoy ingkanas ilancha as sa'on gway Ana' nan Taku gway umali mantuyay.” ");
INSERT INTO kyb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lummaus ad nan onom gway erkaw inghuyog Hesus as Pedro ja cha Santiago an Juan gway mansunud kun iyoyna chicha san nata'nang gway whilig gway ahuscha ekay. ");
INSERT INTO kyb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gwot nanohos nan ilan Hesus san sakkangcha. Kun summiling nan hoserna as isun nan init ad sa'ad nan silupna sumiling gway putputtaa'. ");
INSERT INTO kyb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Awni kun nampaila an chicha cha Moses an Elias gway ma'aapaapat an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kun summayampitaw as Pedro gway manggwana an Hesus, “Apu, whayu nan annaan ta'ud asna. Nu whayugwom manggwaa' as tuyu sikay as manghubhugwa''anju ancha Moses an Elias.” ");
INSERT INTO kyb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sa'ad san manapaapatan Pedro, sa'ad nan hunotay sumiling inichungana chicha. Ad iningkaw nan kingaay nerpu san hunot gway manggwana, “Annaja nan ana''uway patpatko', mamasoma' an sija. Chumngor aju an sija!” ");
INSERT INTO kyb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chingngorn ku chanan apostoles na sachi kinga nallu'hubcha san luta san amod gway ogjatcha. ");
INSERT INTO kyb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kun ummachayug as Hesus an chicha gwot inognana ku chicha, anana, “Sumi'ad aju, achi aju umogjat.” ");
INSERT INTO kyb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mantollongcha kun maid ku uchum as inilacha nu achi ahus as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ad sa'ad san manoskancha san whilig pinuyungna chicha gway manggwana, “Ilanju ta agwad mangiwhaganju sannaja inilaju ingkanas sa'ad as sa'on gway Ana' nan Taku matakuwa' san matoja'.” ");
INSERT INTO kyb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kun inimus chanan pasuyutna an sija gway manggwana, “Kamma chanan mangaagkammu san lintog ananon maserpu managkulin jan as Elias ad asiyot umali nan Kristu?” ");
INSERT INTO kyb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kun summungwhat gway manggwana, “Tuttuwa kajay umuna managkulin as Elias ta isakanana nan losan. ");
INSERT INTO kyb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gwon iwhaka' an cha'ajuway naahus umali nan isun Elias gwon achicha kun whinigwhig as sija kun inggwacha nan whayugwonchaay oon an sija. Ad isuna hosay sa'ad as sa'onay Ana' nan Taku palikatana' an chicha.” ");
INSERT INTO kyb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sachi kun naagwatan chanan pasuyut gway mipangkop an Juan gway Manghohonjag nan ingwhakana an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ummoy ku cha Hesus san agwachan nan amochay taku, ummoy an sija nan osa laya'i gway nampalintumong san sanguna ");
INSERT INTO kyb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kun anana, “Apu, achakugwamud nan ana''u laya'i tan na'or'orchas as sija ja mapalpalikatan as amod. Nadnachi matugwad as sija san apuy ja maotchag san chanum. ");
INSERT INTO kyb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kun iyali' as sija sasan pasuyutnu gwon achicha kun ma'iipawhayu an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Summungwhat kus Hesus anana, “Ina'ay aju mahosay takuwanna maid pammatina ja nasama somsomo'na! Anaman ekay awhajag nan iingkagwa' an cha'aju ja mangaannusa' an cha'aju! Ijaliju an sa'on nan ana' sannaja.” ");
INSERT INTO kyb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kun inamujuwan Hesus nan chimunju gwot lummagwa say ana'. Kun hummayu chay ana' san sachi uyas. ");
INSERT INTO kyb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ummahus kun cha Hesus ja chanan pasuyutna ummachayugcha an sija kun anancha, “Ka'ami man achi ma'aperjaw san sachi chimunju?” ");
INSERT INTO kyb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Anana an chicha, “Kapu san inawhawhang nan pammatiju. Tuttuwa iwhaka' an cha'ajuwanna gway nu agwad pammatijus isun nan inawhanog nan hu'orn nan mustard, mawhalinay ananju sanna whilikon, ‘Manatun'a sanchi, ad nanatun.’ Ad maid kun achiju ma'gwa.” ");
INSERT INTO kyb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Gwon sa'ad nan amaschiyay ayasin nan chimunju achi kun maperjaw nu achi ahus nan lugwayu ja mallaunan. ");
INSERT INTO kyb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Naayus kun cha Hesus ja chanan pasuyutna ad Galili, anana an chicha, “Takangaja' gway Ana' nan Taku mipawhijang sasan taku ");
INSERT INTO kyb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ad intoychas sa'on gwon mi'atlu ad gway erkaw matakuwa'.” Kun mansasanga ekay as amod chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ummoy ku cha Hesus ad Capernaum ummachayug chanan manchachakup san hugwis nan Templo an Pedro kun anancha, “Ad mangwhajad nan mistuyuju san hugwis nan Templo?” ");
INSERT INTO kyb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Anan Pedro, “Oon.” Ummoy kus Pedro san hoyoy inunnaan Hesus imuson as sija gway manggwana, “Ngachan nan anam Pedro? Agwan nan manchakupan chanan ali san luta san hugwis? Chanan umili gwinnu sasan ikaja'?” ");
INSERT INTO kyb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ingwhakan ku Pedro ananon, “Sasan ikaja'.” Anan Hesus an sija, “Nu amasnat achi kun mangwhajad chanan umili. ");
INSERT INTO kyb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gwon sa'ad tot achicha malingu an chita i'a ad san whaywhay mamunggwit, sa'ad nan umuna i'anay onom, ta'angom ad nan tupo'na inchasam nan pila'ay umanay as iwhajadtaay chugwa. Ayam ad ingwhajadnu san hugwistaay chugwa.” ");
INSERT INTO kyb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa'ad san sachiyay chimpu ummachayug an Hesus chanan pasuyut gway manggwana, “Ad ngachamma nan angatuwan san Mantuyajan Apudyus?” ");
INSERT INTO kyb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inajakan kun Hesus nan osa ana' impasi'adna san agwachancha. ");
INSERT INTO kyb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kun anana, “Tuttuwa iwhaka' an cha'ajuway nu achi aju mangwhaliw ja achiju agwaton nan kidkichun chanan anana', achi aju kun mitapi sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nu ngachan nan mangiwhawha san longagna as isun nannaja ana', sija nan angatuwan san Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ad nu ngachan nan mangajag san amasna ana' kapu an sa'on, sa'on nan inajakana. ");
INSERT INTO kyb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nu ngachan nan manggwa as ma'awhasuyan nan mernus nan pammatina an sa'on gway isun nannaja ana', unayna ekay mita'od nan cha'or kikillinganay whatu san whakangna ad nitubung san aachayo'anay whaywhay. ");
INSERT INTO kyb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Achachaku chanan taku sanna luhung kapu san whayangnaay mangkapus ma'awhasuyancha. Tuttuwaay angsan nan kapun nan ma'awhasuyan gwon achagchaku nan osa takuway sija nan merpugwan nan mangkapus ma'awhasuyan. ");
INSERT INTO kyb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ad sa'ad nu whayangnas imam ja i'im nan kapun nan ma'awhasuyam, kumpuyam ad ingwhallum. Unayna ekay kumpur'a gwinnu pilay'a gway mawhijag as ingkaingkana nu nan gwachagwad nan imam gwinnu i'im gway mitoper'a san apuy gway maid kun pungpungna. ");
INSERT INTO kyb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ad nu atam nan kapun nan ma'awhasuyam, u'atom ad ingwhallum. Unayna ekay piso''a gway mawhijag as ingkaingkana nu nan gwachagwad nan atam gway mitoper'a san apuy ad ingwhilnu. ");
INSERT INTO kyb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ilanju ta achiju ungsan nan isun nannachaja anana'. Tan iwhaka' an cha'ajuway sa'ad chanan a'anghel gway mangiila an chicha, patinajunay agwadcha san agwachan Ama gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tan as Sa'onay Ana' nan Taku ummaliya' ta takuwo' chanan nataya' gway taku. ");
INSERT INTO kyb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ngachan nan ananju nu agwad osas takuway anna kernerona singkasut ja nataya' nan osa? Jo'o ja achina taynan chanan sijampuyu ja sijam san whibilig ad ummoyna inanap nan osa nataya'. ");
INSERT INTO kyb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ad nu ochasana tuttuwa iwhaka' an cha'ajuway nayagsa' as sijas amod sannaja kernero nu sasay sijampuyu ja sijamay achi nataya'. ");
INSERT INTO kyb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ad isuna hos an Amajud langit gway lagwingonaay misiyan an sija nan osa sasan namati an sa'on isun nannachaja anana'. ");
INSERT INTO kyb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu ma'awhersu nan sunud san pammati an si'a i'a an sija ad ingwhakam nan whersuna gway chugwa aju ekay. Nu chongyona nansubliyom nan whayu manghubuyunanju ja nansubliyom an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Gwon nu achina chongyon manajag'as osa gwinnu chugwa sasan susunud san pammati tot sa'ad nan gwaschi mipawhersu mata'choyan nan chugwa gwinnu tuyu. ");
INSERT INTO kyb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Gwon nu lagwingonaay chongyon chicha iwhakam sasan maayuayusay namati. Ad sa'ad ahos nu achina chongyon iwhilangjus sija as osa paganu gwinnu manaa'nut gway manchachakup san hugwis. ");
INSERT INTO kyb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tuttuwa iwhaka' an cha'ajuway nu ngachan nan ijachiju gway oon chanan takud asna luta, naahus Apudyus gway agwad ad langit tachunan. Ja nu ngachan nan ijujaju ad asna luta, naahus Apudyus gway agwad ad langit tachunan. ");
INSERT INTO kyb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Iwhaka' ahos an cha'aju nannaja: Nu chugwa an cha'aju ad asna luta nan mantinnachun san whayangnasnatay ochagwonju san lugwayu, atchon Ama gway agwad ad langit an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tan nu agwan nan agwad nan chugwa gwinnu tuyuway namati an sa'on gway maayus mallugwayu an sa'on, agwacha' ad aschi an chicha.” ");
INSERT INTO kyb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ummachayug kus Pedro an Hesus anana an sija, “Apu, mangimman'u ligwatan nan whersun nan huyun'u namati gway assi'assin humersu an sa'on? Mangimpittu?” ");
INSERT INTO kyb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Anan Hesus an sija, “Wha'on kus iwhaka' an si'aay mangimpittu gwon mangimpitumpuyu gway pitu. ");
INSERT INTO kyb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sija nan mijisu san Mantuyajan Apudyus nan osa ali gway simsimmo'na mansingil san utang chanan mansilsilwhi an sija. ");
INSERT INTO kyb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ilukina kunay mansingil iyoycha an sija nan osa mansilsilwhiyay nanutang an sijas alihulihu pila'ay wha'yaw. ");
INSERT INTO kyb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gwon kapu tan achi kun ma'awhajad ingwhilin nan amuna gway mila'us sija ja nan asagwana ancha anana'na ja losanay u'ugwana tot mawhajachan nan utangna. ");
INSERT INTO kyb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Sija nan nallu'hub chay mansilsilwhi san sangun chay ali gway manggwana, ‘Anusam sa'on ad nan losanay utang'u an si'a whajacha'.’ ");
INSERT INTO kyb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nachaku kun chay amuna pinerjawna chay mansilsilwhi kun niligwatana nan utangna. ");
INSERT INTO kyb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lummagwa ad nan sachi mansilsilwhi inchasana nan osaay isuna mansilsilwhi gway nanutang an sijas a''itanay pila' gway wha'yaw. Impukodna kus sija pinsorna gway manggwana, ‘Whajacham nan inutangnu an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Nallu'hub pun chay huyunnaay mansilsilwhi nampa'pa''aasi an sijaay manggwana, ‘Anusam sa'on ad awniyot whajacha' nan utang'u an si'a.’ ");
INSERT INTO kyb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Gwon achina kun pinatkan, tinaynana kun impaiwhayudnas sija ingkanas whajachana nan inutangna. ");
INSERT INTO kyb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Inilan ku chanan huyunnaay mansilsilwhi nan na'gwa lummagwing nan somsomo'cha kun ummoycha ingwhaka san amucha nan losanay na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Impaajag kunan amuna anana an sija, ‘Nayangkat'a mansilsilwhi! Losanay utangnu niligwata' kapu tan nampa'pa''aasi'a an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Inachakugwam otjan nan huyunnu mansilsilwhi as isun nan nangachakugwa' an si'a.’ ");
INSERT INTO kyb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nalingu ku chay amuna impuyangnas sija impaiwhayud sasan mangijaachug san whawhalluchan tot mapalikatan as sija ingkanas mawhajachana mawhajachan nan losanay inutangna. ");
INSERT INTO kyb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ad amasna ahos nan oon Ama gway agwad ad langit an cha'aju nu wha'on kus kadto' gway ligwatanju nan whersun nan asintatakuju.” ");
INSERT INTO kyb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nappung kus Hesus nansuyu lummajaw as sijad Galili kun ummoy san iliyay sa'upon nan Judea gway agwad san chomang nan Gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kun nitunud an sija nan amochay taku gwot impawhayuna chanan nasa'it ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kun ummoy ummachayug an Hesus chanan Pariseo ta padpadchasoncha gway manggwana, “Ad mijuja san lintog ta'u nan ichangan nan laya'i nan asagwana san whayangna ekay kapuna?” ");
INSERT INTO kyb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Summungwhat kus sija anana, “Jo'o achiju whinasa san Ukud Apudyus gway anana, ‘Sa'ad san chamuchamu inggwan Apudyus nan taku as laya'i ja huwhai.’ ");
INSERT INTO kyb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kun anana, ‘Kapu sannaja taynan nan laya'i cha amana an inana ad nan'atumcha san asagwana. Ad nan chugwa longag mangngachancha osossa''an.’ ");
INSERT INTO kyb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ad wha'oncha kus chugwa gwon nangngachancha osossa''an. Sija nan nu ngachan nan nan'atumon Apudyus, wha'on kus mawhalinay manichangon nan taku.” ");
INSERT INTO kyb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Anancha an sija, “Kammaangka Moses ijuja gway ipapil nan laya'i nan mangichangana san asagwana?” ");
INSERT INTO kyb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Anan Hesus an chicha, “Kapu tan hummatu nan somsomo'ju iyujan Moses cha'ajuway ichanganju asagwaju. Gwon san chamuchamu wha'on kus amasnat nan pangkop Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iwhaka' an cha'aju gway nu ngachan nan laya'i mangichang san asagwana san whayangna kapuna maya'sig nu na'assuy san wha'on kus asagwana ad nangasagwa san sawhali, niwhilangay namuwhai as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Anan chanan pasuyutna an sija, “Nu amasnat gway mijachi nan ichang unayna ekay achita mangasagwa.” ");
INSERT INTO kyb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gwon anan Hesus an chicha, “Wha'on kus losanay taku agwatoncha nannaja sussuyu, ahus chanan naatchan as ayobhongan gway achi kun mangasagwa. ");
INSERT INTO kyb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tan na'aya'ayasi nan achin chanan laya'i mangasawwan. Anna nan uchumay nijana'ay wha''uwa, anna nan uchumay inapun nan asintatakucha ja anna nan uchumay achicha manga''asagwa kapu san mansilwhiyancha san Mantuyajan Apudyus. Nan sillobhong gway mangagwat sina maserpu agwatona.” ");
INSERT INTO kyb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iningkaw chanan anana' gway iyoy chanan taku an Hesus ta ipatayna nan imana an chicha ja ilugwayuwana chicha. Gwon chinogjajan chanan pasuyutna chachay nangijoy. ");
INSERT INTO kyb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gwon anan Hesus, “Ijujaju chanan anana'ay umali an sa'on ja achiju ijachi chicha tan nan isun nan a'ammasna anana' mitapicha sasan takuway ituyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gwot impatayna nan imana sasan anana' asiyot lumajaw as sijad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iningkaw nan osa ummoy ummachayug an Hesus gway manggwana, “Mistuyu, ngachan nan whayuway oo' ta ma'awhijaka' an Apudyus as ingkaingkana?” ");
INSERT INTO kyb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kun anan Hesus an sija, “Kaman sa'on nan manimusam san mipangkop san whayu? Ahus as Apudyus as whayu. Gwon nu whayugwom nan ma'awhijag'a an Apudyus as ingkaingkana, patiyom chanan whilin Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Anana an Hesus, “Ngachan chanan whilin?” Kun anan Hesus, “Achi'a pumatoy. Achi'a ma'assuy san wha'on kus asagwam. Achi'a mana'aw. Achim ta'choyan nan tuli gway mihursu san osa taku. ");
INSERT INTO kyb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chumngor'a an cha amam an inam ja ipatognu nan asintatakum as isun nan mangipatognu san longagnu.” ");
INSERT INTO kyb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Anan chay mernus gway laya'i an sija, “Losan chanat inggwa'. Ngachanna pay nan'uyanga'?” ");
INSERT INTO kyb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Anan Hesus an sija, “Nu whayugwomay maid man'uyangam i'a ila'u chanan u'ugwam ad inatodnu nan la'una san whawha'sigwot ad agwad nan whina'nangnu ad langit. Ad ummali'a nitunud an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chingngorn ku chay laya'i nan sachi lummajaw gway mansasanga tan amod nan whina'nangna. ");
INSERT INTO kyb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kun anan Hesus sasan pasuyutna, “Tuttuwa iwhaka' an cha'aju gway sa'ad nan taku sija ekay ipatogna nan inawha'nang mansikab as mitapi sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Asino' iwhaka an cha'aju gway amod mansikab nan mitapijan nan osa taku sasan takuway ituyajan Apudyus gway sija ekay ipatogna nan inawha'nang nu san lumno'an nan kamel san ahut nan chakum.” ");
INSERT INTO kyb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chingngorn ku chanan pasuyutna chi nataagchas amod gway manggwana, “Ad ngachan maangkay mataku nu'?” ");
INSERT INTO kyb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Intollong kun Hesus chicha anana, “Wha'on kus ma'a'gwa nan taku san annaja gwon as Apudyus ma'gwana nan losan.” ");
INSERT INTO kyb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gwot summungwhat as Pedro an sijaay manggwana, “As cha'ami kay tinaynanmi nan losanay u'ugwami kun nitunud ami an si'a. Ad ngachamma maayami?” ");
INSERT INTO kyb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kun anan Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway san humu'nag gway assahu luhung, sa'ad as Sa'onay Ana' nan Taku tumu'chuwa' san inachajaw nan mantuyaja' ad sa'ad as cha'ajuway nitunud an sa'on, tumu'chu aju hos san nasagwayan as chugwa tukaw gway mangituyay sasan kana' chachay nasagwayan as chugwaay ana' Israel. ");
INSERT INTO kyb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ad gwaschi osa manaynan san hoyoyna, susunudna, sinana' an sija, anana'na ja lutana kapu an sa'on, maayana nan manginsingkasutay oyosna ad na'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Gwon angsan chanan ummuna gway mangudchi ad angsan ahos chanan mangudchiyay umuna.” ");
INSERT INTO kyb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Intuyuy Hesus gway manggwana, “Mijagwat nan Mantuyajan Apudyus san osa taku gway anna nan mumullana san ubas gway nasapa lummagwa san gwisnit kun ummoy nananap as tangchanana as manterwhasu san mumullana san ubasna. ");
INSERT INTO kyb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nantinnachuncha kun sasan mallabhu gway tangchanana chichas ustuway labhu san osa erkaw, impooyna chicha san mumullana san ubas. ");
INSERT INTO kyb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Lummagwa kus sija san suminer inilana chanan takuway nasi'asi'ad san merketay maid ooncha. ");
INSERT INTO kyb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kun anana an chicha, ‘I'aju hos manterwhasu san mumulla' san ubas ad nilabhuwa' cha'aju san ustuway labhuju.’ ");
INSERT INTO kyb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Kun aysancha. Asin kuhos lummagwa san mamatu' ja singwhattang as anchu, amaschi ahos nan inggwana. ");
INSERT INTO kyb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Anna kunay singwhattang as ahowha lummagwa kuhos inilana chanan nasi'asi'ad gway taku maid kun ooncha. Kun anana an chicha, ‘Ka'aju maag ekay masi'asi'ad gway mangerkaw gway maid oonju?’ ");
INSERT INTO kyb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Anancha an sija, ‘Tan maid ka mampayabhu an cha'ami.’ “Kun anana an chicha, ‘I'aju hos manterwhasu san mumulla' san ubas.’ ");
INSERT INTO kyb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mummaschom pun anan chay sin'ugwa san mumullan san ubas san mangipangpangu sasan manterwhasu, ‘Ajakam chanan nanterwhasu ad inatodnu nan labhucha malluki sasan nangudchi nanterwhasu ingkana sasan namangu.’ ");
INSERT INTO kyb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ummoy ku chachay nalluki san singwhattang as ahowha inagwatcha nan labhucha ustu gway sinumerkaw. ");
INSERT INTO kyb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ummoy ku chachay namangu anancha kunnu adachu nan agwatoncha gwon annaotay isuna hos ekajay tangchan nan inagwatcha. ");
INSERT INTO kyb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inagwatcha kunan labhucha nallilicha san sin'ugwa san mumullan san ubas ");
INSERT INTO kyb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","gway manggwana, ‘Kama nannachaja nangudchi gway osa kun eka uyas nan nanterwhasuwancha kunja mijisu nan labhucha an cha'amiyay nangerkaw nanterwhasu ja nangijattom san atung nan init?’ ");
INSERT INTO kyb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Gwon summungwhat kun san osa an chicha, anana, ‘Huyun, achi' ku nilu'us si'a. Jo'o achim tinachunan nan sinumerkaw gway tangchannu an sa'on ta. ");
INSERT INTO kyb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ayam nan labhum ta i'a. Whayugwo' gway atchon sannaja nangudchi nan isun ahos nan inatod'u an si'a. ");
INSERT INTO kyb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Jo'o achi mijuja an sa'on gway oo' nan whayugwo'ay oon san pila''u? Gwinnu maapos'a tan manga''atocha'?’ ” ");
INSERT INTO kyb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kun iyanungus Hesus gway manggwana, “Sija nan sa'ad chanan umuna chicha nan mangudchi ja sa'ad chanan mangudchi chicha nan umuna.” ");
INSERT INTO kyb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sa'ad san umajan Hesus ad Jerusalem inta'iyanna chanan nasagwayan as chugwaay pasuyutna kun anana an chicha san chayan, ");
INSERT INTO kyb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Chongyonju na, anna inta'ud Jerusalem ad sa'ad as sa'onay Ana' nan Taku mipawhijanga' sasan papangat nan papachi ja chanan mangaagkammu san lintog ad nilodchongana' gway matoy. ");
INSERT INTO kyb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ad impawhijanga' sasan wha'on kus Hudyu tot amamangona' ja saplitana' ancha ilansaa' san krus. Ad sa'ad nu mi'atlu erkaw matakuwa'.” ");
INSERT INTO kyb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kun ummachayug an Hesus nan asagwan Zebedeo chicha sasan ana'na kun nampalintumong an Hesus gway agwad nan ochagwona an sija. ");
INSERT INTO kyb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kun anan Hesus an sija, “Ngachan nan whayugwom?” Anana an Hesus, “Iwhakamud gway patu'chugwom san mantuyajam nanna chugwa ana''u, ingkaw nan osa san machigwanannu ja ingkaw nan osa san machigwikim.” ");
INSERT INTO kyb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Anan Hesus sasay chugwa mansunud, “Achiju kun akammu nan od'ochagwonju. Jo'o ja ma'iijattom aju san likat gway isun nan likat gway ma'gwa an sa'on.” Anancha an sija, “Ma'aijattom ami.” ");
INSERT INTO kyb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Anana an chicha, “Tuttuwa sa'ad nan likatay ma'gwa an sa'on ma'iijattom aju gwon nan tumu'chu san machigwanan'u ja san machigwiki', wha'on kus sa'on nan mampili, sija ingkaw chanan insakanaan Ama.” ");
INSERT INTO kyb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chingngorn kun chachay simpuyu pasuyut nan inchaw chay chugwa mansunud, nalingucha an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gwon inajakan kun Hesus chicha, anana, “Akammuju gway sa'ad chanan mangituyay sasan wha'on kus Hudyu ilajusancha chicha ad sa'ad chanan pangatcha mansuwoncha chicha. ");
INSERT INTO kyb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wha'on kus amasnat nan oonju. Gwon nu ngachan nan mamayu an cha'aju gway mampangatu, maserpu mansilwhi an cha'aju losan. ");
INSERT INTO kyb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ad nu ngachan nan mamayu an cha'aju gway mangngachan apatkan, maserpu mampamudchachu an cha'aju losan. ");
INSERT INTO kyb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Isu' gway Ana' nan Taku, wha'on kus ummaliya' ta mansilwhiyana' gwon ummaliya' ta mansilwhiya' ja atcho' nan whijag'u as oyos nan whijag nan aachugwanay taku ta magwajagwajaancha san ayobhongan nan whersu.” ");
INSERT INTO kyb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sa'ad san lumajagwan cha Hesus ad Jerico nitunud an sija nan amochay taku. ");
INSERT INTO kyb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ad iningkaw nan chugwa na'uyap gway tummutu'chu san ikid nan chayan. Chingngorcha kunay lumaus as Hesus impa'uychaay manggwana, “Apu gway kana' Dabid, achakugwamud cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gwon sa'ad chanan taku chinogjajancha chicha gway kumino'cha. Gwon iyamamodchaot nampa'uy gway manggwana, “Apu gway kana' Dabid, achakugwamud cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Summinong kus Hesus inajakana chicha gwot anana, “Ngachan nan whayugwonjuway oo' an cha'aju?” ");
INSERT INTO kyb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Anancha an sija, “Apu, aanomud nan uyapmi.” ");
INSERT INTO kyb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nachaku kus Hesus inognana nan atacha kun maag ekay anna nan ilancha gwot nitunudcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sa'ad san takangay cha Hesus chumakusan ad Jerusalem gwot hummu'nagchad Betfage san whilig gway ma'gwaniyon Olibu, impaunan Hesus nan chugwa sasan pasuyutna ");
INSERT INTO kyb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","gway manggwana an chicha, “I'aju sanchi iliyay chomangonju ad humu'nag aju ad ekay agwad nan ochasanju osa asno gway niwhawhawwod ja nan uyhunna. U'whachonju ad chicha iyaliju an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ad nu agwad mangimus san oonju ananjuwon maserpun nan Apu chana ad nanijatodna.” ");
INSERT INTO kyb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na'gwa na tot tumuttuwa nan ingwhakan Apudyus an profeta Isaias gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Iwhakaju san umilid Jerusalem gway manggwana: Chongyonju na, sa'ad nan Aliju umali an cha'ajuway ingwhawhana nan longagna gway nangaabwhaju san uyhun nan asno.” ");
INSERT INTO kyb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ummoy kun chachay chugwa pasuyut gwot inggwacha nan ingwhilin Hesus ");
INSERT INTO kyb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","iyoycha chay asno ja nan uyhunna kun inap'apancha san kotap nan silupcha gwot nangawhajus Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ad sa'ad nan amochay taku iyap'apcha nan kotap nan silupcha san chayan ad nan uchum nangayacha sasan pangan chanan aju kun iyap'apcha san chayan. ");
INSERT INTO kyb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ad sa'ad chanan taku gway namangu ja chanan misu'su'nub an Hesus asipopo'awchaay manggwana, “Machaychajaw nan kana' Dabid! Piyan as sija gway umali san ayobhongan Apudyus! Machaychajaw as Apudyus ad langit!” ");
INSERT INTO kyb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hummu'nag kus Hesus ad Jerusalem nakuyu nan losanay umili gway manggwana, “Ngachan ma nina?” ");
INSERT INTO kyb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kun anan chanan angsanay taku, “Sijana nan profeta gway as Hesus gway iNazaret gway sa'up nan Galili.” ");
INSERT INTO kyb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ummoy as Hesus san sowhan nan Templo kun pinerjawna losan chanan malla'ya'u ja chanan mallaya'u san sachi. Kun inaminna tugwachon nan lamisaan chanan manooyos san pila' ja tutu'chugwan chanan mangila'ya'u san kalapati. ");
INSERT INTO kyb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kun anana an chicha, “Nilista san Ukud Apudyus gway anana, ‘Sa'ad nan hoyoy'u maagwakan as luyuwwayuwan.’ Gwon sa'ad as cha'aju nangngachanonju tatalluwan chanan mamayangkat.” ");
INSERT INTO kyb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kun ummoy ummachayug an sija chanan na'uyap ancha napilay san Templo kun impawhayuna chicha. ");
INSERT INTO kyb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gwon inilan ku chanan papangat nan papachi ja mangaagkammu san lintog nan mataakan gway inggwan Hesus ja chanan anana'ay mampo'apo'aw san Templo gway manggwanaon, “Machaychajaw nan Kana' Dabid,” nalingucha. ");
INSERT INTO kyb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kun anancha an sija, “Chochongyom nan iwhagwhakacha?” Anan Hesus an chicha, “Oon. Jo'o achiju whinasa san Ukud Apudyus gway anana, ‘Apudyus, sinuyuwam chanan anana' ja ungngaa' gway mangichajaw as ustu'ustu an si'a?’ ” ");
INSERT INTO kyb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tinaynana kun chicha lummajaw sa sachi ili gway ummoy ad Betania kun ummijan ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mawhikat kun san manulinan cha Hesus ad Jerusalem nawhitil as sija. ");
INSERT INTO kyb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Inilana kunan igos san ikid nan chayan ummoyna inachayug gwot maid kun inchasanas hokasna, ahus eka chanan tuhu. Kun anana say aju, “Achi'a kun puyus humkas!” Kun maag ekay nayangu chay igos. ");
INSERT INTO kyb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Inilan ku chachay pasuyutna nataagcha gway manggwana, “Ininona maag ekay nernangu nan ajuway igos?” ");
INSERT INTO kyb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kun anan Hesus gway summungwhat an chicha, “Tuttuwa iwhaka' an cha'ajuway nu agwad pammatiju ja achi aju manchugwachugwa, wha'on kun ekas ahus nan na'gwa san aju igos as mawhalinay oonju. Gwon mawhalin kahos gway iwhakaju sannaja whilig gway, ‘Mita'nang'a ad nitoper'a san whaywhay,’ ad na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ad losanay ochagwonju san lugwayu nu tuttugwaonju, maayaju.” ");
INSERT INTO kyb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nanagkulin kus Hesus san sowhan nan Templo ummoy ummachayug an sija chanan papangat nan papachi ja chanan chacha''orn chanan Hudyu san mansuyusuyuwana kun anancha, “Agwan nan nangallam san ayobhongam gway manggwa san o'oom ja ngachan nan nangatod an si'a san ayobhongam?” ");
INSERT INTO kyb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kun summungwhat as Hesus gway manggwana an chicha, “Manimusa' ahos an cha'aju. Nu masungwhatanju iwhaka' ahos an cha'aju nu ngachan nan nangalla' san ayobhonga' gway manggwa san o'oo'. ");
INSERT INTO kyb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sa'ad nan ayobhongan Juan gway manghonjag agwan nan nerpugwana? Nerpu an Apudyus gwinnu nerpu sasan taku?” Kun nanuukuchanchaay manggwana, “Nu anan ta'uwon, ‘Nerpu an Apudyus’, anana an chita'uwon, ‘Kajuman angkay achi tinuttuwa as sija?’ ");
INSERT INTO kyb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gwon nu anan ta'uwon, ‘Nerpu sasan taku’, umogjat ta'u sasan taku tan losancha iwhilangay osa profeta as Juan.” ");
INSERT INTO kyb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kun sinungwhatancha as Hesus gway manggwana, “Maid kun akammumi.” Anana hos an chicha, “Sa'ad nu amasnat achi' kuhos iwhaka nu ngachan nan nerpugwan nan ayobhonga' gway manggwa san o'oo'. ");
INSERT INTO kyb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ngachan ma ananju sannaja? Iningkaw nan osa ama gway anna nan chugwa ana'na laya'i. Ad ummachayug kus sija san panguyu anana, ‘Ana''u, i'a san sana erkaw manterwhasu san mumullan san ubas.’ ");
INSERT INTO kyb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Gwon summungwhat gway manggwana, ‘Lagwingo' gway umoy.’ Gwon nanohos kunan somsomo'na ummoy. ");
INSERT INTO kyb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ummachayug kus sija san whanog ingwhakana nan isuna. Summungwhat ku chay ana'na, anana, ‘Iya', ama’ gwon achi kun ummoy. ");
INSERT INTO kyb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ngachanna sasay chugwa nan nanggwa san whayugwon amacha?” Anancha, “Chay panguyu.” Anan Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway sa'ad chanan manchachakup san hugwis ja chanan naukor, umunacha an cha'aju umoy san Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tan ummalis Juan an cha'aju tot ipailana an cha'aju nan ustu i'aman gway mawhijag. Kun achiju kun tinuttuwas sija gwon chanan manchachakup san hugwis ja chanan naukor nan namati an sija. Ta'on nu nappungju inila chicha gway namati achiju kun nanchu'kan nan whersuju ad namati otjan aju an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Intuyuy Hesus gway manggwana, “Chongyonju nan osa pay gway agwat: Iningkaw nan osa taku nammuya as angsanay ubas san lutana kun nili'gwosna a'upon. Kun nanggwas uussutan san ubas kun nampata'chor as nata'nang as allangan gway whinatu as ingkagwan nan mangijaachug. Kun impasamerna sasan mansasamer gwot nangwhaat. ");
INSERT INTO kyb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Takangay kunan inghubhuyas ingwhaunna chanan mudchachuna sasay mansasamer ta umoycha ayan nan huwana. ");
INSERT INTO kyb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Inayan ku chachay mansasamer chachay mudchachuna inabchoycha nan osa, intoycha nan osa ja whininwhintugcha nan osa. ");
INSERT INTO kyb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Asin ahos nangwhaun as uchumay mudchachu as angsan sasay ummunaay ingwhaunna kun inggwacha an chicha nan isuna. ");
INSERT INTO kyb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anunu kun ingwhaunna an chicha nan ana'na tan anana kunnu ananaon, ‘Whigwhikoncha nan ana''u.’ ");
INSERT INTO kyb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Gwon inilan ku chachay mansasamer nan ana' nan sin'ugwa asi'a'anancha, ‘Annaja nan mangila'sun. Gwayyu ta otojon ta'us sija ad nan'ugwa ta'u nan la'sunna.’ ");
INSERT INTO kyb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Inayacha kus sija ingwhallucha san lasin nan mumullan san ubas gwot intoycha. ");
INSERT INTO kyb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ad sija nan sa'ad nu managkulin chay sin'ugwa san mumullan san ubas ngachan nan oona sasay mansasamer?” ");
INSERT INTO kyb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Anancha an sija, “Sa'ad chachay nayangkatay mansasamer otojona chicha ad sa'ad chay mumullana san ubas ipasamerna san uchumay mansasamer gway mangatod an sija as huwana san inghubhuyas.” ");
INSERT INTO kyb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Anan Hesus an chicha, “Jo'o achiju whinasa nan nilista san Ukud Apudyus gway anana, ‘Sa'ad chay whatuway nampiliyan chanan mamanggwas hoyoy, sachiyot nan kadto'ay nisaachan nan hoyoy. As Apudyus nan nanggwa sannaja ad amod mataakan nan mangilan ta'u!’ ");
INSERT INTO kyb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Sija nan iwhaka' an cha'aju gway achin ku Apudyus itapi cha'aju sasan takuway ituyajana gwon chanan taku gway tumungper san whayugwona. ");
INSERT INTO kyb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ad sa'ad chanan maotchag sannaja whatu mayumo'. Ad nu ngachan nan mitu'nukana mamo'mo'.” ");
INSERT INTO kyb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chingngorn ku chanan papangat nan papachi ja chanan Pariseo nan iyagwatna, naagwatanchaay chicha nan iwhakawhakana. ");
INSERT INTO kyb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kun nananapchas ininonchaay mangipachopap an sija gwon ummogjatcha san amochay taku tan iwhilangchas sija as osaay profeta. ");
INSERT INTO kyb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kun asin ahos as Hesus nanagwat an chicha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mijisu nan Mantuyajan Apudyus san amasna: Iningkaw nan osa ali gway insakanana nan hoyay nan ana'na laya'i. ");
INSERT INTO kyb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kun ingwhaunna chanan mudchachuna ta umoycha ajakan chanan naajakan san hoyay gwon lagwingon chachay naajakanay umoy. ");
INSERT INTO kyb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nangiwhaun ahos san uchumay mudchachuna gway anana, ‘Iwhakaju sasan naajakanay insakana' nan hoyay, sa'ad chanan napapunor wha'a' naperticha ad nisakana nan losan, iwhakaju ta umalicha.’ ");
INSERT INTO kyb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Gwon achicha kun ekay chongyon aysancha gway ummoy nan osa san tayunna, ummoy ahos nan osa nangamusanti. ");
INSERT INTO kyb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ad sa'ad nan uchum chimpapcha ku chanan mudchachuna gway nangajag an chicha, pinalikatancha chicha gwot intoycha chicha. ");
INSERT INTO kyb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sija nan nalingu chay ali gwot ingwhaunna ku chanan surchachuna, impaotoyna chachay nangtoy sasay mudchachu kun impaskobna nan ilicha. ");
INSERT INTO kyb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kun anana sasay mudchachuna, ‘Nappung nisakana nan hoyay gwon sa'ad chachay naajakan achicha kun miwhilangay ma'ayagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sija nan i'aju sasan ersa ad nu ngachan nan ochasanju, ajakanju chicha san hoyay.’ ");
INSERT INTO kyb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ummoy ku chachay mudchachu sasan ersa inajakancha losan nan takuway inchasancha, whayu gwinnu lagwingay taku. Kun napnu nan mallagyagsa'an sasan naajakan. ");
INSERT INTO kyb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nilumno' kunan ali ta ilana chanan naajakan inilana nan osa takuway achi kun nansilup san silup nan ma'abyay. ");
INSERT INTO kyb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kun anan chay ali, ‘Sunud, ininom gway nilumno' ad asna gway achi'a kun nansilup san silup nan ma'abyay?’ Gwon kummikinno' chay taku. ");
INSERT INTO kyb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kun anan chay ali sasan mansilsilwhiyona, ‘Ta'chonju ad nan ima ja i'ina iwhalluju san whawhalluchan gway manghulingot. Maniwhil as sija ja mangngilngiltona nan whawhana as isun chanan uchumay iingkaw ad aschi.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pinungpung Hesus gway manggwana, “Angsan nan maajakan gwon a''itan nan mapili.” ");
INSERT INTO kyb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lummajaw kun chachay Pariseo nanuukuchancha nu ngachan nan ininoncha mani'ap an Hesus kapu san iwhakana. ");
INSERT INTO kyb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kun ingwhauncha an sija chanan pasuyutcha ja chanan takun Herod gway manggwana, “Mistuyu, akammumiyay achi'a kun mantuli ja isuyum nan atuttugwaan gway mipangkop san whayugwon Apudyus ja wha'on kus somsom'om nu ngachan nan anan nan taku tan manisisugwom nan taku uyay nu ngachan nan asasaadcha. ");
INSERT INTO kyb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ad iwhakamud an cha'ami nu ngachan nan anam sina. Ad mijuja san lintog gway mangwhajadta san hugwis san Emperador gwinnu achi?” ");
INSERT INTO kyb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gwon akammun Hesus nan lagwingay pangkopcha, sija nan anana, “Cha'ajuway an'annanju mampawhayu, kaju padpadchason as sa'on? ");
INSERT INTO kyb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipailaju an sa'on nan aka pila'ay miwhajad san hugwis!” Kun inatodcha an sija nan dinario. ");
INSERT INTO kyb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kun anana an chicha, “Ngachan nan singhoser sannaja ja singngachan?” ");
INSERT INTO kyb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Anancha an sija, “Emperador.” Kun anana an chicha, “Nu amasnat atchonju san Emperador nan ugwan nan Emperador ad inatodju an Apudyus nan ugwan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chingngorcha kun chi nataagcha gwot tinaynancha kus sija lummajawcha. ");
INSERT INTO kyb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ad sa'ad san sachi erkaw ummoy ummachayug an Hesus chanan Saduceo gway achicha kun mamati gway mataku nan matoy. Kun inimuscha an sija ");
INSERT INTO kyb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","gway manggwana, “Mistuyu, ingwhakan Moses gway nu matoy nan osa laya'iyay maid ana'na, asawwon nan sunudna chay nawhayu tot umana'chas miwhilang as ana' chay sunudna natoy. ");
INSERT INTO kyb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iningkaw nan pitu mansusunud gway lallaya'i ailijanmi. Nangasagwa kunan panguyu natoy gway maid kun ana'na. Kun inasagwan nan umaggwa sunudna chay nawhayu. ");
INSERT INTO kyb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Amaschi ahos nan na'gwa say umaggwa ja umatlu ingkana san mi'apitu. ");
INSERT INTO kyb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Anunu kun natoy chay huwhai. ");
INSERT INTO kyb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sija nan nu umali nan erkaw gway matakuwan nan natoy ngachanna sasay pitu nan sinasagwa say huwhai tan inasagwacha losan as sija?” ");
INSERT INTO kyb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kun anan Hesus gway summungwhat an chicha, “Nasama nan somsomo'ju, achijuwot sija akammu nan nilistaay Ukud Apudyus gwinnu ayobhongana. ");
INSERT INTO kyb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tan sa'ad san matakuwan chanan natoy maid kun manasasagwa tan isucha chanan a'anghel ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nu mipangkop san matakuwan chanan natoy, jo'o achiju whinasa nan ingwhakan Apudyus an cha'aju gway anana, ");
INSERT INTO kyb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sa'on nan Apudyus Abraham, Apudyus Isaac ja Apudyus Jacob.’ Ingwhakana nan amaschi ta'on nu natoy cha Abraham san agwi. Nan pijaon nina anan, wha'on kus Apudyus chanan natoy as sija gwon Apudyus chanan mawhiwhijag.” ");
INSERT INTO kyb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chingngorn ku chanan taku nataagcha san sussuyuna. ");
INSERT INTO kyb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chingngorn kun chanan Pariseo gway achi kun ma'asungwhat chanan Saduceo san ingwhakan Hesus, naayuscha losan kun ummoycha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kun inimus nan osa an chicha gway mangipappaagwat san lintog gway pinadpadchasna gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistuyu, ngachan nan apatkan gway whilin san lintog?” ");
INSERT INTO kyb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kun anan Hesus an sija, “Patkom nan Apu gway Apudyusnu san losan gway agwad an si'a gway somsomo'nu, alichodgwam ja losanay laingnu. ");
INSERT INTO kyb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Annaja nan apatkanay whilin san losan. ");
INSERT INTO kyb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ad amaschi ahos gway sa'ad nan mi'aggwa gway apatkan amasna, ‘Ipatognu nan asintatakum as isun nan mangipatognu san longagnu.’ ");
INSERT INTO kyb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Annachaja chugwa whilin nan mungimung nan losanay lintog Moses ja sussuyun chachay profeta.” ");
INSERT INTO kyb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naayus ku chanan Pariseo nanimus as Hesus an chicha, ");
INSERT INTO kyb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","gway manggwana, “Ngachan nan ananju san mipangkop san Kristu? Ngachan nan singkana' an sija?” Anancha an sija, “Kana' Dabid.” ");
INSERT INTO kyb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Anana an chicha, “Nu kana' Dabid nan Kristu kammaangka Dabid agwakan sija as Apu? Tan nan ingwhakan Dabid gway impaiwhakan nan Ispilitun Apudyus anana, ");
INSERT INTO kyb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anan Apudyus san Apu', tumu'chu'a san machigwanan'u ingkanas ipaawha''u an si'a chanan ahursum?’ ");
INSERT INTO kyb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ad kapu tan inagwakan Dabid as sija as Apu ininon nan Kristu gway nangngachan kana' Dabid?” ");
INSERT INTO kyb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gwot maid kun osas nanungwhat an sija gwinnu nangituyod mamachas an sija mani'ap manipud san sachi erkaw. ");
INSERT INTO kyb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Anan Hesus sasan taku ja chanan pasuyutna ");
INSERT INTO kyb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","gway manggwana, “Anna nan alintokan chanan mangaagkammu san Lintog ja chanan Pariseo gway mangipaagwat san lintog Moses. ");
INSERT INTO kyb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sija nan ngachan manay iwhakacha an cha'aju oonju ja chongyonju gwon sa'ad nan o'ooncha achiju oon. Tan nan isuyucha achicha kun oon. ");
INSERT INTO kyb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ipa'gwacha sasan taku nan angsanay lintog gway mansikab as suyuton gway ama ekas pahu'udcha an chicha nan chagsonay ochon ad achicha kun ekas a'it whadngan chicha. ");
INSERT INTO kyb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ad sa'ad nan losanay ooncha, ooncha tot ilan chanan taku. Ilanju nan ooncha gway pachacha''oyoncha nan iigkaan san Ukud Apudyus gway ijahungutcha san itungcha ja iwhichiwhidcha san ta'yaycha ja oonchas chacha''or chanan tamtamoy nan lagkoyloy gway silupcha. ");
INSERT INTO kyb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja whayugwoncha ingkaw san igkagwan chanan nangangatu taku san lagyagsa' ja san tu'chugwan chanan nangangatu taku san sinagoga. ");
INSERT INTO kyb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Whayugwonchaay makingakingaan sasan merket ja agwakan chanan taku chichas ‘Mistuyu.’ ");
INSERT INTO kyb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Gwon sa'ad as cha'aju wha'on aju kus paagwag as ‘Mistuyu’ tan osossa''an nan mistuyuju ja manisisu aju losan gway isun chi mansusunud. ");
INSERT INTO kyb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ad achiju agwakan as ‘Ama’ nan whayangna taku sanna luta tan osossa''an nan Amaju gway agwad ad langit. ");
INSERT INTO kyb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Gwinnu achi aju paagwag as ‘Apu’ tan sa'ad as sa'on gway Kristu ahusa' as Apuju. ");
INSERT INTO kyb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ad sa'ad nan angatuwan an cha'aju sija nan mansilwhi an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nu ngachan nan mangipangatu san longagna ipawhawhan Apudyus ja nu ngachan nan mangipawhawha san longagna ipangatun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Amod a'oogjat nan ma'gwa an cha'aju gway mangaagkammu san lintog ja Pariseo. An'annanju mampawhayu! Ijachiju chanan taku gway mampaituyay an Apudyus. Sija nan uyay as cha'aju lagwingonjuway mampaituyay an Apudyus ja ijachiju pay chanan mamayu paituyay. ");
INSERT INTO kyb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo. An'annaju mampawhayu! Isi'asi'apjuway mangaya san u'ugwan chanan nawhayu ad an'annanju anchugwon nan lugwayuju. Ad awni ad nachusa ajus amod! ");
INSERT INTO kyb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo gway an'annanju mampawhayu tan whijasiyonju nan whaywhay ja ailiili tot managwis ajus wha'on kus Hudyu as manuyut san pammatiju. Ad nu agwad maagwisju amamod gway manggwas lagwing san o'oonju tot sa'ad nan machusaana ad ingwhilnu amamod an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Amod a'oogjat nan ma'gwa an cha'ajuway isun chi na'uyap gway mangipangpangu. Ananjuwon nu agwad mangisapata san ingkagwan Apudyus san chayo' nan Templo, maid kun ma'gwa nu achicha oon. Gwon nu ngachan nan mangisapata san huyagwanay agwad san ingkagwan Apudyus san chayo' nan Templo maserpu oona. ");
INSERT INTO kyb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Isuju chanan na'uyap gway taku! Maid kun akammuju! Jo'o napatpatog nan huyagwanay agwad san ingkagwan Apudyus nu san chayo' nan Templo gway aschi nan miit'onan nan huyagwan as mauser an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ingwhakaju hosay nu ngachan nan mangisapata san chachattunan maid kun ma'gwa nu achina oon. Gwon nu ngachan nan mangisapata san chatun san chachattunan maserpu oona. ");
INSERT INTO kyb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Isuju chanan takuway na'uyap! Jo'o napatpatog nan chatun san chachattunan gway sachi nan miit'onan nan chatun as mauser an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sija nan nu mansapata nan osa taku san chachattunan isapatana nan chachattunan ja nan losanay chatunay agwad. ");
INSERT INTO kyb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ad sa'ad nan mansapata san Templo mansapata ahos san ingkagwan Apudyus san chayo' nan Templo ja an Apudyus gway iingkaw ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ad sa'ad nan mansapata ad langit mansapata san mantuyajan Apudyus ja an Apudyus gway mantuyay sa sachi. ");
INSERT INTO kyb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo. An'annanju mampawhayu! Atchonju an Apudyus nan mi'asimpuyu whillay san apitju uyay chanan awha''ijutanay minuya gway muyaju gwon achiju kun chongyon nan napatpatog gway lintog – gway manisisugwonta nan taku, mangachakuta ja napudnuta an Apudyus. Annachaja nan maserpu oonju gway achiju hos ligwatan nan uchumay lintog. ");
INSERT INTO kyb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cha'ajuway isun chi na'uyap gway mangipangpangu! Ammanju ekay tungpayon chanan whilin gway a'it nan patogna ad achiju ekay chongyon chanan napatog gway whilin. Isuju nan osa taku sakatona nan tip'an san inumona gwon u'munona nan kamel. ");
INSERT INTO kyb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo. An'annanju mampawhayu! Ammanju ekay suyuton nan ukaliju gway manuyas san lawhaw nan langkaw ja chujasju gwon pungwonju chicha san ma'an ja mainum gway inayaju kapu san puyos ja kamkam. ");
INSERT INTO kyb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Cha'ajuway Pariseo isuju chi na'uyap! Umuna janay ammanju ilan nu por'as nan inigkaju san langkawju ja chujasju gway wha'on kus naaya kapu san kamkam ad pummor'as ahos nan lawhaw nan nangigkaanju. ");
INSERT INTO kyb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo. An'annanju mampawhayu! Isuju chanan lohon gway napintuyan san puta' gway sa'ad nan lawhawcha a'erjad gwon sa'ad nan chayo'cha napnu san tungern chanan natoy ja losanay ayasin nan aisaw. ");
INSERT INTO kyb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amasnat aju hos gway ipailajuway nalintog aju sasan taku gwon napnu nan somsomo'ju san an'annanay inawhayu ja lagwingay ayanggwa. ");
INSERT INTO kyb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Amod a'oogjat nan ma'gwa an cha'ajuway mangaagkammu san lintog ja Pariseo. An'annanju mampawhayu! Inggwaju nan lohon chanan profeta ja ineertiyanju nan pusantun chanan nalintog gway taku. ");
INSERT INTO kyb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ad ananjuwon, ‘Nu iningkaw ami otjan san chimpun chanan aammami, achi ami otjan nitapi an chichaay nangipaotoy sasan profeta.’ ");
INSERT INTO kyb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","San nangiwhaganjusnat tuttuwa ipailajuway cha'aju nan kana' chachay nangtoy sasay profeta! ");
INSERT INTO kyb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Cho, pungpungonju nan illukin chanan aammaju. ");
INSERT INTO kyb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Isuju chanan uyog! Maniiwhit aju ja a'oogjat ajuway taku! Ininonju manay mangilisi san chusa ad ingwhilnu? ");
INSERT INTO kyb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sija nan chongyonju na, iwhaun'u an cha'aju chanan profeta ja man'alaing ancha mangisussuyu san ukud'u. Sa'ad nan uchum an chicha otojonju ja ilansaju san krus ja saplitanju chicha sasan sinagoga ancha chogchokonju chicha palikatan san ailiili. ");
INSERT INTO kyb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Kapu sannaja i'ayuju nan chusa san nangtojancha san losanay nalintokay taku sanna luta, manipud san natojan Abel gway nalintog ingkana san natojan Zacarias gway ana' Barakias gway intoyyu san nanghoyaatan nan ingkagwan Apudyus san chayo' nan Templo ja chachattunan. ");
INSERT INTO kyb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tuttuwa iwhaka' an cha'aju gway losan nannachaja chusa humu'nag sannaja lunap kapu sannachaja lagwingay inggwacha!” ");
INSERT INTO kyb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sachi ad anan Hesus, “Ina'ay ajuway iJerusalem, cha'aju nan nangtoy sasay profeta ja naminwhintug san ingwhaun Apudyus an cha'aju! Nadnachi whayugwo'ay umali asinuton cha'aju as isun nan manga'owhan nan angnga' san isiwna gwon lagwingonju! ");
INSERT INTO kyb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chongyonju, taynan Apudyus nan Temploju ad maid kun ingkaw. ");
INSERT INTO kyb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iwhaka' an cha'ajuway achiju kun maila asin as sa'on ingkanas ananjuwon, ‘Piyan as sija gway umali san ayobhongan Apudyus!’ ” ");
INSERT INTO kyb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sa'ad san lumajagwan Hesus san Templo ummachayug chanan pasuyutna tot ipailacha an sija chanan pata'chor gway chokan nan Templo. ");
INSERT INTO kyb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kun summungwhat as sija gway manggwana an chicha, “Mailaju losan nannachaja inawhayuna. Gwon tuttuwa iwhaka' an cha'aju gway maid kun osas matchay san whatu gway natuutuun as achi ku mi'uurb.” ");
INSERT INTO kyb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gwot ummoy as Hesus san Whilig gway Olibu. Sa'ad san tummutu'chugwana ad aschi ahus as ummachayug an sija chanan pasuyutna gway manggwana, “Iwhakamud an cha'ami nu ma'anu nan migwa''iyan nan Templo ja ngachan nan mangimatunan san umaliyam asin ancha anungus nan chimpu?” ");
INSERT INTO kyb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Summungwhat kus Hesus anana an chicha, “Ammanju ilan ta maid mangallilaw an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tan angsan nan umali manguser san ngachan'u gway manggwana, ‘Sa'on nan Kristu’ ad angsan nan allilagwoncha. ");
INSERT INTO kyb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ad magngorju nan kukuwhat ja chamag mipangkop san kukuwhat. Ilanju ta achi aju ma'og'og. Maserpu ma'gwa jan nannaja gwon wha'on kus pijaona anan nan sanat nan pungpung nan luhung. ");
INSERT INTO kyb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tan mangwhiwhinnursu nan ailiili ja chanan kuwhilnu san luta. Ad humu'nag nan uyat ja mangita hos nan na'aya'ayasiyay ili. ");
INSERT INTO kyb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gwon sa'ad nannachaja lukin ekay nan likat gway isun nan sikab nan mangkumut. ");
INSERT INTO kyb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nu ma'gwa chana ipawhijang cha'aju tot palikatan cha'aju ja otojon cha'aju. Kuyaon cha'aju san losanay taku kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ad angsan nan mangijakay gway mamati an sa'on ja sa'ad nan uchum ijiwhitcha ancha kuyaoncha nan huyuncha namati. ");
INSERT INTO kyb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ad angsan chanan wha'wha''onay profeta gway lumosgwa ad inallilawcha nan angsanay taku. ");
INSERT INTO kyb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ad kapu san ummangsan nan lagwingay ma'ma'gwa tumamnay nan lajad nan angsanay taku. ");
INSERT INTO kyb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gwon sa'ad nan mangituttuyuy san pammatina ingkana san mapungpungana sija chadlu nan mataku. ");
INSERT INTO kyb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ad nipaakammu nan Whayuway Chamag gway mipangkop san Mantuyajan Apudyus san losanay luhung tot maakammugwan nan losanay taku ad asiyot nan pungpung nan luhung.” ");
INSERT INTO kyb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Intuyuy Hesus gway manggwana, “Sa'ad nu ilanju nan ingwhakan profeta Daniel gway amod a'oogjat gway mawwa''i gway summisi'ad san ikaw gway manchajagwan chanan taku an Apudyus, (sa'ad nan mangwhasasna maserpu maagwatana,) ");
INSERT INTO kyb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","sa'ad chanan ingkaw ad Judea, maserpu umagwidcha san whibilig. ");
INSERT INTO kyb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sa'ad nan nijaspur gway iningkaw san otop nan hoyoyna a''agwaynaay manosog ad achi kun lumno' gway mangayas whayangna as ijagwidna. ");
INSERT INTO kyb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ad sa'ad nan nijaspur gway agwad san tayun achi kun manulin san hoyoyna gway mangayas kotap nan silupna. ");
INSERT INTO kyb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Ad achagchaku chanan mahuki ja chanan mantatakiwhi san sanat gway chimpu. ");
INSERT INTO kyb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ad ilugwayuju an Apudyus ta achi mijaspur nan umagwichanju san chimpuway amod nan tagling gwinnu san Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kapu tan mapalikatan as amod chanan taku gway maid kun mijisugwana san ikad nan na'gwaan nan luhung ingkana san sana, achi kun puyus ma'gwa nan amasna asin. ");
INSERT INTO kyb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ad sa'ad nu achin Apudyus ipaa'it nan whilang nan erkaw san sanatay chimpu maid kun osas taku as mataku. Gwon kapu sasan pinilinaay takuna inaanana nan whilang nan erkaw san sanatay chimpu. ");
INSERT INTO kyb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ad sa'ad nu agwad manggwana an cha'ajuwon, ‘Ilanju ad, annaja nan Kristu!’ gwinnu ‘Anchiya nan Kristu!’ achiju tuttugwaon. ");
INSERT INTO kyb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tan lumosgwa chanan wha'wha''onay Kristu ja wha'wha''onay profeta ad nangipailacha as amochay mangimatunan ja mataakan ad nu agwad awhalinana uyay chanan takun Apudyus gway pinilina allilagwoncha chicha. ");
INSERT INTO kyb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chongyonju na! Anna inunnaunna' iwhaka an cha'aju losan nan annachaja ma'gwa. ");
INSERT INTO kyb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Sija nan nu ananchaon ‘Chongyonju, agwad as sija san luta gway maid kun ingkaw as taku!’ achi aju umoy ad aschi. Ad nu ananchaon, ‘Agwad as sija san chayo' nan ugwertu!’ achiju tuttugwaon chicha. ");
INSERT INTO kyb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kapu tan as sa'on gway Ana' nan Taku managkulina' gway isun nan ilat gway sumlit manipud san chumungitan nan init ingkana san masi'utan nan init. ");
INSERT INTO kyb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Isun nan ananchaon nu agwad natoy as ajam, maakammugwan kapu san angsanay hu'aw gway maayus gway umoy mangan.” ");
INSERT INTO kyb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Intuyuy Hesus gway manggwana, “Mappung ad ekay chimpun nan mapalpalikatan as amod chanan taku, humulingot nan init ad achi kun sumyag nan huyan. Ad sa'ad chanan whituwon maotchagcha ja sa'ad chanan ayobhonganay agwad ad langit majugjug. ");
INSERT INTO kyb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ad lumosgwa ad langit nan mangimatunan gway managkulina' gway Ana' nan Taku. Ad maniwhil nan losanay taku sannaja luta san ogjatcha. Ad ilanchas sa'onay Ana' nan Taku gway umali gway nangkakagwa san hunot gway anna nan amochay ayobhonga' ja inachajaw'u. ");
INSERT INTO kyb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ad mipakingas towhag nan tangkujub ad ingwhaun'u chanan a'anghel'u gway merpu san intilu luhung ad inasinutcha chanan pinilin Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kun intuyuy Hesus gway manggwana, “Achayonju hos nan acher gway atchon nan aju gway igos. Sa'ad nu luminsi nan pangana ja sumimit akammuju gway takangay nan chakun. ");
INSERT INTO kyb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Isuna hos gway sa'ad as cha'aju nu ilanju gway ma'gwa chana aagkammujuway umachani gway umachani nan chimpuway managkulina'. ");
INSERT INTO kyb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tuttuwa iwhaka' an cha'ajuway sa'ad nannachaja takuway matattaku san sana achicha kun losan matoy ingkanas ma'gwa losan nannachajaay ingwhaka'. ");
INSERT INTO kyb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sa'ad nan langit ja luta maumas gwon sa'ad nan ukud'u sissija iingkaw.” ");
INSERT INTO kyb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Anan Hesus, “Sa'ad nan mipangkop san sanat gway erkaw ja uyas gway managkulina' maid kun mangakammu. Uyay chanan a'anghel ad langit achicha kun akammu gwinnu as sa'on gway Ana' Apudyus achi' kun akammu. Ahus as Ama as mangakammu. ");
INSERT INTO kyb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sa'ad nan na'gwa san chimpun Noe amasna ahos nan ma'gwa nu managkulina' gway Ana' nan taku. ");
INSERT INTO kyb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tan sa'ad sasay sachi erkaw san chaan humu'nag nan itap nanganangan ja umminiinum chanan taku, nanasasagwacha ingkana san erkaw gway nilumno' as Noe san papur. ");
INSERT INTO kyb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ad achicha kun akammu nan ma'ma'gwa ingkana san hummu'nag nan itap kun iyanudna chicha losan. Amasna ahos nan ma'gwa nu managkulina' gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ad san sachi chimpu agwad ad chugwas laya'is manterwhaterwhasu san tayun, sa'ad nan osa maaya mipangatu ad nan osa mataynan. ");
INSERT INTO kyb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Agwad ad chugwas huwhais mangkilikiling san kikillingan, sa'ad nan osa maaya mipangatu ad nan osa mataynan. ");
INSERT INTO kyb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sija nan patinajunay na'asakana aju tan achiju kun akammu nan umaliyan Apuju. ");
INSERT INTO kyb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sosom'onjuway nu akammun nan sin'ugwa san hoyoy nan uyas san lawhi nan umaliyan nan manaa'aw, achi otjan massuy ja achina ijujaay lon'on nan manaa'aw nan hoyoyna. ");
INSERT INTO kyb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sija nan patinajunay na'asakana aju hos tan achiju kun akammu nan chimpun nan managkulina' gway Ana' nan Taku.” ");
INSERT INTO kyb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anan Hesus, “Nan mantayo'an ja naangsan gway mansilsilwhi chinutu'an nan singhoyoy gway mangiila san uchumay mansilsilwhi san hoyoyna tot sija nan mangatod san whillaycha san anoncha san ustuway chimpu. ");
INSERT INTO kyb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Piyan na sanatay mansilsilwhi nu humu'nag nan amuna gway ochasanas sija gway manggwamanggwa san terwhasuway nitayo' an sija. ");
INSERT INTO kyb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tuttuwa iwhaka' an cha'aju gway chutu'anas sija as mangiila san losanay u'ugwana. ");
INSERT INTO kyb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gwon nu lagwing nan sanatay mansilsilwhi anana san somsomo'naon, ‘Mawhajag nan managkulinan nan amu'.’ ");
INSERT INTO kyb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ad ilukinaay saplitan nan huhuyunna mansilsilwhi ja umoy ma'a'an ja ma'iinum sasan huttongan. ");
INSERT INTO kyb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ad humu'nag ad nan amuna san erkaw gway achi kun na'asakana ja uyas gway achina kun akammu, ");
INSERT INTO kyb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","chusaon nan amunas sija as amod ad iyoynas sija san agwachan chanan an'annancha mampawhayu. Ad aschi nan agwachan nan maniwhiiwhil ja mangngillongillotan chanan whawha.” ");
INSERT INTO kyb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Intuyuy Hesus gway manggwana, “San chimpun nan managkulina' sa'ad nan Mantuyajan Apudyus mijagwat sasan simpuyu whabwhawhallas gway nangagwitchas silawcha kun ummoycha inahot nan laya'iyay mamyay. ");
INSERT INTO kyb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sa'ad chanan lima an chicha katkatung ja sa'ad chanan lima nasilib. ");
INSERT INTO kyb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sa'ad chachay katkatung nanagwitchas silawcha gwon achicha kun nanagwit as lana. ");
INSERT INTO kyb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gwon sa'ad chachay nasilib nanagwitchas lana as utup nan silawcha. ");
INSERT INTO kyb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gwot nawhajag kunan humu'nakan chay mamyay losan nanchu'chu'jop chachay whabwhawhallas kun nassuycha. ");
INSERT INTO kyb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kagwan kunan lawhi iningkaw nan nampo'aw gway manggwana, ‘Chongyonju, annaja nan laya'i mamyay! Umaliju abton as sija!’ ");
INSERT INTO kyb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Gwot hummangon losan chachay whabwhawhallas kun insakanacha nan silawcha. ");
INSERT INTO kyb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gwon anan chachay katkatung sasay nasilib, ‘Atchan cha'amiyud san lanaju tanna matmatoy nan silawmi.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Gwon anan chachay nasilib gway summungwhat, ‘Tugwakay achi umanay an chita'u losan. I'aju sasan malla'ya'u ad nalla'u ajus ugwaju.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Sa'ad san umajancha malla'uwan hummu'nag chay laya'i mamyay. Ad sa'ad chachay na'asakana nihuyogcha an sijaay nilumno' san hoyay kun naongwhan nan onob. ");
INSERT INTO kyb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Awawni kun hummu'nag chachay katkatung gway manggwana, ‘Apu, Apu! Perno'on cha'amiyud!’ ");
INSERT INTO kyb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Gwon summungwhat chay mamyay gway manggwana, ‘Tuttuwa iwhaka' an cha'aju gway achi' kun akammus cha'aju.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pinungpung Hesus gway manggwana, “Sija nan ammanju ilan tan achiju kun akammu nan erkaw gwinnu uyas gway umaliya'.” ");
INSERT INTO kyb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Intuyuy Hesus gway manggwana, “Mijagwat ahos nan Mantuyajan Apudyus san isun nan osa taku ummoy nangwhaat san uchumay ili, inajakana chanan mudchachuna kun impawhijangna an chicha nan u'ugwana. ");
INSERT INTO kyb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nan osa inatchanas lima lihu as ag'aka pila', inatodna san osa nan chugwa lihu ja inatodna san osa nan sillihu. Inatodna chi san gwaschi osa an chicha insikun san lobhongcha. Kun aysan nangwhaat. ");
INSERT INTO kyb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aysan ku chay mudchachuway nangagwat san lima lihu illa'ya'una kun ummana' as lima lihu. ");
INSERT INTO kyb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Isuna hos say osa nangagwat san chugwa lihu gway impaana'nas chugwa lihu. ");
INSERT INTO kyb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gwon chay osaay nangagwat san sillihu ummoyna in'aub san luta nan pila' chay amuna. ");
INSERT INTO kyb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nawhajawhajag kun hummu'nag chay amun chachay mudchachu tot ilana chay pila'na an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ummoy ku ummachayug chay nangagwat san lima lihu anana, ‘Apu, lima lihu nan inatodnu an sa'on. Ilam, lima lihu hos nan nangipaana'a'.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kun anan chay amuna, ‘Whayu nan inggwam. Whayu'a ja mantayo'an'aay mudchachu! Kapu tan mantayo'an'a san a'itay nitayo' an si'a chutu'a' si'a as nangamung san adachu. Gwaynu ta ma'ayagsa''a an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ummoy kuhos ummachayug chay nangagwat san chugwa lihu anana, ‘Apu, chugwa lihu nan inatodnu an sa'on. Ilam, chugwa lihu hos nan nangipaana'a'.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Anan chay amuna an sija, ‘Whayu nan inggwam. Whayu'a ja mantayo'an'a mudchachu! Kapu tan mantayo'an'a san a'itay nitayo' an si'a chutu'a' si'a as nangamung san adachu. Gwaynu ta ma'ayagsa''a an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ummoy kuhos ummachayug chay nangagwat san sillihu anana, ‘Apu, akammu'ay asisingon'a taku, apitom nan wha'on kus immuyam ja chakupom nan wha'on kus iwwakagwagnu. ");
INSERT INTO kyb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ummogjata' kunot ummachajuwa' in'aub'u nan pila'nu san luta. Ilam, annaja ipagkulin'u nan ugwam.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Summungwhat ku chay amuna anana an sija, ‘Katkatung'a ja masachut'a mudchachu! Annatcha ka akammum gway apito' nan wha'on kus immuya' ja chakupo' nan wha'on kus iwwakagwag'u ja. ");
INSERT INTO kyb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Imbangkum otjan nan pila''u tot annaja ad gway kummatonga' aya' nan pila''u gway agwad nan ana'na.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sija nan anana sasan uchumay mudchachu, ‘Ayanju an sija nan sillihu ad inatodju say agwachan nan simpuyu lihu. ");
INSERT INTO kyb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tan nan usayona nan u'ugwana gway ustu machogwan as amod achu gwon nan takuway wha'on kus ustu nan mangusayana san u'ugwana, uyay nan a'itay agwad an sija ma'aan an sija. ");
INSERT INTO kyb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ad sa'ad nannaja maid silwhina mudchachu itoperjus lasin san agwachan nan manghulingot. Ad ad aschi nan maniwhiiwhilana ja mangngillongillotan nan whawhana.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Intuyuy Hesus gway manggwana, “As sa'on gway Ana' nan Taku managkulina' as osa ali gway sumiling as amod ad inghuyog'u nan losanay a'anghel ad sachi nan mangituyaja' ja mangu'uma' san losan.” ");
INSERT INTO kyb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ad naayus san sangu' nan losanay taku ad nan'aggwao' koggwaon chicha san isun nan o'oon nan mampaspastur sasan ajam gway pinasigna chanan kernero sasan erching. ");
INSERT INTO kyb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ad igka' chanan nalintokay taku san machigwanan'u gway mijagwat sasan kernero gwon sa'ad chanan lagwingay taku igka' san machigwiki' gway mijagwat sasan erching. ");
INSERT INTO kyb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ad as sa'on gway Ali ana' sasan ingkaw san machigwanan'u, ‘Gwayyu, cha'ajuway pinawhayun Ama nan whijagcha! Ad tagwichonju nan whayu gway atchon Apudyus sasan ituyajana gway nisakana an cha'aju manipud san na'gwaan nan luhung. ");
INSERT INTO kyb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tan nawhitila' kun pina'ananjus sa'on. Nauwagwa' kun pinainumanjus sa'on. Mangiliya' kun minangilijus sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Maid kun silup'u kun inatchanjus sa'on as insilup'u. Nasa'ita' kun ummalijus sa'on nilagwa. Niwhayucha' kun ummalijus sa'on inila.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ad sumungwhat chanan nalintog gway manggwana, ‘Apu, ma'anu nan nangilanmi an si'aay nawhitil kun pina'ananmi si'a gwinnu nauwaw kun pinainumanmi si'a? ");
INSERT INTO kyb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma'anu nan nangilanmi an si'aay mangili'a kun minangilimi si'a gwinnu maid kun silupnu kun inatchanmi si'as silupnu? ");
INSERT INTO kyb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma'anu nan nangilanmi an si'aay nasa'it gwinnu niwhayud kun ummalimi inila si'a?’ ");
INSERT INTO kyb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ad sumungwhata'ay Ali gway manggwana an chicha, ‘Tuttuwa iwhaka' an cha'aju gway nu inggwaju san osa sasan awhawhaan sannachaja susunud'u, inggwaju an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ad asiyot anan sasan ingkaw san machigwiki', ‘Umachaju aju an sa'on, cha'ajuway machusa. I'aju san apuy gway maid pungpungna gway nisakana an Satanas ja sasan huhuyunna chimunju. ");
INSERT INTO kyb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tan nawhitila' kun achiju kus sa'on pina'anan. Nauwagwa' kun achiju kus sa'on pinainuman. ");
INSERT INTO kyb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Osaa'ay mangili gwon achiju kus sa'on minangili. Maid ku silup'u kun achiju kus sa'on inatchan as silup'u. Nasa'ita' kun ja niwhayucha' achiju kus sa'on ummali inila.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ad sumungwhatcha hos gway manggwana, ‘Apu, ma'anu nan nangilanmi an si'a gway nawhitil, nauwaw, osaay mangili, maid kun silupna, nasa'it gwinnu niwhayud kun achimi si'a whinachangan?’ ");
INSERT INTO kyb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ad sumungwhata' an chichaay manggwana, ‘Tuttuwa iwhaka' an cha'aju gway nu achiju inggwa san osa sannachaja awhawhaan gway susunud'u, achiju kun inggwa an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ad ummoy nannachaja san maid pungpungnaay chusa gwon sa'ad chanan nalintokay taku ma'awhijagcha an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nappung kun Hesus isuyu losan chachi anana sasan pasuyutna, ");
INSERT INTO kyb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Akammuju gway mappung ad nan chugwa erkaw pijasta gway ma'gwaniyon Lumaus. Ad as Sa'onay Ana' nan Taku mipawhijanga' tot milansaa' san krus.” ");
INSERT INTO kyb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ad san sachi hosay uyas naayus chanan papangat nan papachi ja chanan chacha''or san ili san hoyoy Caiafas gway angatuwanay pachi. ");
INSERT INTO kyb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kun nanuukuchancha nan ininonchaay manpap an Hesus gway maid kun mangakammus taku ad asichaot otojon. ");
INSERT INTO kyb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gwon anancha, “Achi ta'u ijaspur san chimpun nan pijasta tan tugwakay makuyu chanan taku.” ");
INSERT INTO kyb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sa'ad san agwachan Hesus ad Betania san hoyoy Simon gway naleprosi, ");
INSERT INTO kyb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ummoy ummachayug an sija nan huwhaiyay nanangchon san whangwhangyu gway nangina gway niigka san iigkaan gway na'gwa san whatuway alabaster. Kun insiitna san wha''ag Hesus san mangamanganan Hesus san oo''anan. ");
INSERT INTO kyb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Inilan ku chanan pasuyut Hesus nalinguchaay manggwana, “Ka aynga ekay chi! ");
INSERT INTO kyb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mila'u otjan chi as achuway pila' ad naatod sasan whawha'sigwot!” ");
INSERT INTO kyb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Inakammun kun Hesus nan ana'anancha anana an chicha, “Kajuman whijangan nannaja huwhai san inggwana? Whayu nan inggwana an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tan patinajunay iingkaw chanan whawha'sigwot an cha'aju gwon as sa'on wha'ona' kus patinajunay iingkaw an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tan nan nangisiitan nannaja huwhai san whangwhangyu san longag'u, inggwana chi as misakanaan nan miilhona'. ");
INSERT INTO kyb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tuttuwa iwhaka' an cha'aju gway agwanna man sinatay mipaakammugwan nannaja Whayuway Chamag san intilu luhung, machamag ahos nan inggwan nannaja huwhai as manomsom'an an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ad sa'ad nan osa sasan nasagwayan as chugwaay apostoles gway Judas Iscariote nan ngachanna, ummoy sasan papangat nan papachi. ");
INSERT INTO kyb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Anana, “Ngachan nan atchonju an sa'on nu ijiwhit'u as Hesus an cha'aju?” Kun whinajachanchas sija as tuyumpuyu pila' gway wha'yaw. ");
INSERT INTO kyb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Malluki san sachi nananap as sija as chimpu gway mangijiwhit an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa'ad san chamun nan erkaw nan pijasta gway ma'gwaniyon Tinapay Gway Maid Kun Yeastna, ummoy ummachayug an Hesus chanan pasuyutnaay manggwana, “Agwan nan whayugwomay mangisakanaanmi san manganam san pijasta gway ma'gwaniyon Lumaus?” ");
INSERT INTO kyb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kun anan Hesus, “I'ajud Jerusalem san taku gway akammu ta'u ad ananju an sija, ‘Anan nan Mistuyu takangay nan chimpu' gway whintong Apudyus. Ad ugwaju nan mangana' san pijasta gway ma'gwaniyon Lumaus gway huyun'u chanan pasuyut'u.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kun inggwan chanan pasuyut nan whilin Hesus an chicha gwot insakanacha nan anoncha san pijasta. ");
INSERT INTO kyb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mummaschom pun tummu'chu as Hesus gway nangan gway huyunna chanan nasagwayan as chugwa pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ad sa'ad san mangamanganancha anana, “Tuttuwa iwhaka' an cha'aju gway osa an cha'aju nan mangijiwhit an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lummagwing nan angoscha losan kun nasinnossachaay manggwana an sija, “Apu, sa'on lagwa nan anam?” ");
INSERT INTO kyb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Gwon summungwhat gway manggwana, “Sa'ad nan na'atuyno' an sa'on san tinapayna san chujug sija nan mangijiwhit an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sa'ad as sa'on gway Ana' nan Taku matoja' gway sachi nan nilista san Ukud Apudyus gwon amod a'oogjat nan ma'gwa san sanatay takuway mangijiwhit an sa'on gway Ana' nan Taku! Unayna ekay achi nijana' nan sanatay taku.” ");
INSERT INTO kyb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kun anan Judas gway mangijiwhit an sija, “Mistuyu, sa'on lagwa nan anam?” Anan Hesus an sija, “Si'a ka annat nan nangiwhaka.” ");
INSERT INTO kyb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sa'ad san mangamanganancha nangaya as Hesus san tinapay gwot nanjaman an Apudyus kun pini'pi''inaot inatodna sasan pasuyutna kun anana, “Ayanju nannaja ad inanju, annaja nan longag'u.” ");
INSERT INTO kyb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Inayana kunan sintasa whajas gwot nanjaman an Apudyus, inatodna an chichaay manggwana, “Annaja, uminum aju losan. ");
INSERT INTO kyb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Annaja nan chaya' gway umigwang tot ligwatan Apudyus nan whersun nan angsanay taku. Annaja nan mamagchot san assahu tuyag Apudyus sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iwhaka' an cha'aju gway malluki san sana achiya' kun asin uminum san whajas nan ubas ingkana san erkaw gway ma'ainuma' an cha'aju san assahu whajas san Mantuyajan Ama.” ");
INSERT INTO kyb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nappungcha ad nan'anta san chaychajaw an Apudyus lummagwachaay ummoy san whilig gway Olibu. ");
INSERT INTO kyb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sa'ad san agwachancha san chayan anan Hesus sasan pasuyutna, “Taynana' an cha'aju losan san sana lawhi tan nilista san Ukud Apudyus gway anana, ‘Otojo' nan mampaspastur ad nasibsibta' chanan kernero.’ ");
INSERT INTO kyb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Gwon matakuwa' ad ummunaa' an cha'aju umoy ad Galili.” ");
INSERT INTO kyb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kun anan Pedro gway summungwhat an sija, “Ta'on nu losancha taynan si'a achi' kun puyus taynan si'a.” ");
INSERT INTO kyb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Anan Hesus an sija, “Tuttuwa iwhaka' an si'a gway san sana lawhi mamitlum sa'on isulib san chaanan nan awwit mangu''uu'an.” ");
INSERT INTO kyb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Anan Pedro an sija, “Ta'on nu maserpu mitapiya' matoy an si'a achi' kun si'a isulib.” Amaschi hos nan ingwhakan nan losanay pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ummoy as Hesus ja chanan pasuyutna san ikaw gway ma'gwaniyon Getsemani kun anana sasan pasuyutna, “Tu'chu aju jan sannaja ta iya' sanchi mallugwayu.” ");
INSERT INTO kyb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inghuyogna kun cha Pedro ja nan chugwaay ana' Zebedeo illukinaay sumanga ja nakuyu nan somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gwot anana an chicha, “Lumagwilagwing as amod nan angos'u gway amaa' ekas matoy. Ainnugwanju sanna ta ma'asuyap aju an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ummachaju kus a'it as Hesus nallu'hub gway nallugwayu kun anana, “Ama, nu mawhalin ilisiya' otjan sannaja likat gway humu'nag. Gwon ta'o mampay nu amaschi wha'on kusan whayugwo' nan ma'gwa, sija ma'gwa nan whayugwom.” ");
INSERT INTO kyb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Manulin kus Hesus sasan pasuyutna inchasana chichaay nanassuy. Kun anana an Pedro, “Jo'o achi aju ekay ma'aituyod gway ma'asuyap an sa'on as osa uyas? ");
INSERT INTO kyb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Achi aju massuy ja mallugwayu aju tot achi aju masulisukan. Tuttuwa whayugwon nan somsomo'ju nan ustu gwon achi kun ma'a'gwa nan longagju.” ");
INSERT INTO kyb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mipidgwa kunay ummachaju as Hesus nallugwayu gway manggwana, “Ama, nu maid awhalinana ja nu maserpu mapalikatana' as amod ma'gwa nan whayugwom.” ");
INSERT INTO kyb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nanagkulin kuhos as sija inchasana hos chichaay nanassuy tan ma'asuysujopcha. ");
INSERT INTO kyb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tinaynana kuhos asin chicha gwot ummoy ummachaju, nallugwayu san mipitlu as isun ahos chay ingwhakana. ");
INSERT INTO kyb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gwot nanagkulin sasan pasuyutna kun anana an chicha, “Ka'aju patho' ekay mamassuy ja umiillong? Ilanju ad takangay nan uyas ad as sa'on gway Ana' nan Taku mijiwhita' sasan humersuwhersu. ");
INSERT INTO kyb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Humangon aju ta inta'u mijahot. Ilanju ad annaja umachayug nan mangijiwhit an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sa'ad san manapaapatan Hesus hummu'nag as Judas gway osa sasan nasagwayan as chugwa pasuyutna gway huyogna nan angsanay taku gway naniispada ja namperpertu. Ingwhaun chanan papangat nan papachi ja chanan chacha''orn nan Hudyu chicha. ");
INSERT INTO kyb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ad sa'ad nan mangijiwhit an Hesus inununnana ingwhaka an chicha nan mangimatunancha an Hesus gway manggwana, “Nu ngachan nan sin'aping san mangichooma' san aping'u sija nan chopaponju.” ");
INSERT INTO kyb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nanijachayug kun Judas an Hesus anana, “Anna'a kay, Mistuyu!” Kun inchoomna nan apingna san aping Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kun anan Hesus an sija, “Huyun, oom nu ngachan nan iyalim.” Ummachayug kun chanan taku chimpapcha as Hesus kun impukodchas sija. ");
INSERT INTO kyb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ad sa'ad nan osa sasan huyun Hesus nilu'pusna nan ispadana gwot whina'agna kunan mudchachun nan angatuwanay pachi napingasan nan ingana. ");
INSERT INTO kyb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kun anan Hesus an sija, “Ijusu'nu nan ispadam san horjanna. Tan nan losanay manguser san ispada ispada nan i'atoycha. ");
INSERT INTO kyb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Jo'o achim akammuway mawhalinay mampawhachanga' an Ama ad ingwhaunna an sa'on nan alihulihuway anghel? ");
INSERT INTO kyb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gwon nu ma'gwa nan amaschi ininon manan Ukud Apudyus gway mipatungper gway anana annaja nan maserpu ma'gwa?” ");
INSERT INTO kyb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sachi kun anan Hesus sasan taku, “Jo'o tulisana' ta umali ajuway naniispada ja namperpertu gway manpap an sa'on. Awhikawhikat peekay iniingkagwa' tumutu'chugwan san Templo gway mansuyu gwon achiya' kun chimpap. ");
INSERT INTO kyb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gwon ma'gwa chana losan ta mipatungper nan Ukud Apudyus gway illistan chanan profeta.” Gwot losanay pasuyutna tinaynancha as sija kun iyagwidcha. ");
INSERT INTO kyb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sa'ad chachay nanpap an Hesus iyoychas sija san hoyoy Caifas gway angatuwanay pachi gway sachi nan naayusan chanan mangaagkammu san lintog ja chanan chacha''orn nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ad sa'ad as Pedro ummaadchajang gway misu'su'nub an sija ingkana san sowhan nan hoyoy nan angatuwanay pachi. Kun ummoy kun na'atu'tu'chu sasan mangwhawhantay ta ilana nu ngachan nan ma'gwa. ");
INSERT INTO kyb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ad sa'ad chanan papangat nan papachi ja chanan losanay papangatay naayus, nananapcha as taku as mangiwhakas tuli as ipawhersucha an Hesus tot ipa'toychas sija. ");
INSERT INTO kyb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gwon maid kun inchasancha ta'on nu angsan chanan ummoy nangiwhaka san tuli. Anunu kun ummoy ummachayug nan chugwaay ");
INSERT INTO kyb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","manggwana, “Anan nan sanatay Hesus, ‘Igwa''i' nan Templon Apudyus ad impata'chor' asin san tuyu erkaw.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Summi'ad kunan angatuwanay pachi anana an Hesus, “Ad maid isungwhatnu san ingwhakan nannachaja taku gway mihursu an si'a?” ");
INSERT INTO kyb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Gwon kummikinno' as Hesus. Kun anan nan angatuwanay pachi an sija, “Mansapatao' si'a an Apudyus gway mawhiwhijag. Iwhakamud an cha'ami nu si'a nan Kristu gway Ana' Apudyus?” ");
INSERT INTO kyb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Anan Hesus an sija, “Si'a nan nangiwhaka sinat. Gwon iwhaka' an cha'aju gway malluki san sana ilanju as sa'onay Ana' nan Taku gway tumutu'chuwa' san machigwanan Apudyus gway anna ayobhongana ad ummaliya' gway nangkakagwa san hunot ad langit.” ");
INSERT INTO kyb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gwot sa'ad nan angatuwanay pachi whinis'ina nan kotap nan silupnaay manggwana, “Ingwhakana nan maamamangan Apudyus! Ad ngachan manan uchum as anapon ta'u as mangiwhaka san whersuna. Ilanju, chingngorju nan ingwhakanaay maamamangan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ad ngachamma ananju?” Kun summungwhatcha gway manggwana, “Lobhongna matoy as sija.” ");
INSERT INTO kyb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Gwot tinubwhaancha nan hosern Hesus kun sinuntu'chas sija. Kun nilipa'cha gway ");
INSERT INTO kyb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","manggwana, “Imatunama Kristu nu ngachan nan nallipa' an si'a?” ");
INSERT INTO kyb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","San sachi chimpu tummutu'chu as Pedro san sowhan nan hoyoy nan angatuwanay pachi. Kun ummachayug an sija nan osa huwhai mudchachu gway manggwana, “Si'a hos nan nihuyohuyog an Hesus gway iGalili.” ");
INSERT INTO kyb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gwon insulib Pedro san sangucha losan gway manggwana, “Achi' kun akammu nan iwhagwhakam.” ");
INSERT INTO kyb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ummoy ad as Pedro san aayyon gway umoy san sachi sowhan inilan nan osa huwhai mudchachu as sija kun anana sasan takud aschi, “Sa'ad nan osa takuwanna nihuyohuyog an Hesus gway iNazaret.” ");
INSERT INTO kyb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kun asin ahos Pedro insulib gway nansapata gway manggwana, “Achi' kun akammu nan sanatay taku.” ");
INSERT INTO kyb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Awawni kus a'it gwot ummachayug chanan nasi'asi'ad anancha an Pedro, “Tuttuwa osa'a sasan huhuyun Hesus, uyay nan iya''apapatnu maimatunan an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Gwon insapatan Pedro gway manggwana, “Machusaa' nu akammu' nan sanatay taku!” Sachi kun ekay nangu''uu' nan awwit. ");
INSERT INTO kyb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kun simsimmo' Pedro chay ingwhakan Hesus gway manggwana, “Chaan ad mangu''uu' nan awwit namitlum sa'on isulib.” Lummagwa kus Pedro naniwhil san amod gway somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gwisnigwisnit kun nanuukuchan chanan losanay papangat nan papachi ja chanan chacha''orn chanan Hudyu nu ngachan nan ininonchaay mangipaotoy an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pinungucha kus Hesus iyoycha impawhijang an Pilato gway kuwhinnachur. ");
INSERT INTO kyb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Naakammugwan kun Judas gway nangijiwhit an sija gway nayodchonganay matoy as Hesus, nangwhawhagwi kus sija impagkulinna chay tuyumpuyu pila'ay wha'yaw sasan papangat chanan papachi ja chacha''orn chanan Hudyu ");
INSERT INTO kyb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","gway manggwana, “Hummersuwa' tan iyiwhit'u nan maid whersuna taku.” Gwon anancha, “Ngachamma whijangmisnat? Nangamung'a peekay.” ");
INSERT INTO kyb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Intopern kun Judas nan pila' san ingkagwan Apudyus san chayo' nan Templo aysan as sija kun ummoy namposor. ");
INSERT INTO kyb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gwon sa'ad chanan papangat nan papachi inam'amcha kunan pila'ay wha'yaw anancha, “Mijachi san lintog ta'u gway miigka nannachaja san mangiigkaan san pila' san Templo kapu tan whajad nan whijag nan osa taku.” ");
INSERT INTO kyb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gwot nanuukudcha ku losan illa'ucha chay pila' san lutan nan mamanggwa san whanga as loyobhonan sasan ikaja' gway matoy ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sija nan naagwakan na sachi tayun as “Lutan nan Chaya” ingkana san sana. ");
INSERT INTO kyb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gwot tummuttuwa nan inukud profeta Jeremias gway anana, “Kun inayacha nan tuyumpuyu pila' gway wha'yaw, nan katad gway nanuukuchan chanan ijIsrael as miwhajad san whijagna. ");
INSERT INTO kyb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kun illa'ucha san tayun chay manghohoser san whanga gway sachi nan ingwhilin Apudyus an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sachi kun impasanguchas Hesus an Pilato gway kuwhinnachur kun inimus nan kuwhinnachur as sija gway manggwana, “Si'a nan Alin chanan Hudyu?” Kun anan Hesus, “Si'a nan nangiwhaka gway aliya'.” ");
INSERT INTO kyb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gwon pinawhersun ku chanan papangat nan papachi ja chanan chacha''orn chanan Hudyu as sija, achi kun summungwhat. ");
INSERT INTO kyb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gwot anan Pilato an sija, “Maid chongyom sannachaja angsanay ipabpawhersucha an si'a?” ");
INSERT INTO kyb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gwon achi kun summungwhat as Hesus uyay osa ekas apapat, sija nan nataag as amod nan kuwhinnachur. ");
INSERT INTO kyb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","San tinagwonay pijasta nisikud san kuwhinnachur gway mangipayagwas osas whayud nu ngachan nan whayugwon chanan taku paipayagwa. ");
INSERT INTO kyb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ad sa sachi chimpu iningkaw nan osa whayud gway nanchinamag nan lagwingay inggwana gway mangngachan Hesus Barrabas. ");
INSERT INTO kyb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naayus ku chanan taku anan Pilato an chicha, “Ngachan nan whayugwonju ipayagwa' an cha'aju, as Hesus Barrabas gwinnu as Hesus gway ma'gwaniyon Kristu?” ");
INSERT INTO kyb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sachi nan ingwhakan Pilato tan akammuna gway kapu san aposcha, sachi nan kapuway impawhijang chanan papangat nan Hudyu as Hesus an sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sa'ad san tummutu'chugwan Pilato san uu''uman niijoy an sija nan suyat asagwana gway anana, “Achim whijangan nan sanatay taku gway maid kun whersuna tan napalikatana' as amod ad kanad san lawhi san ininop'u kapu an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gwon sa'ad chanan papangat nan papachi ja chacha''orn chanan Hudyu, inagwischa chanan taku ta sija chagwatonchas Barrabas ad impaotoychas Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nanimus ku asin chay kuwhinnachur anana an chicha, “Ngachan nan whayugwonju sasan chugwa gway ipayagwa' an cha'aju?” Kun anancha, “Barrabas!” ");
INSERT INTO kyb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Anan Pilato an chicha, “Ad ngachamma oo' an Hesus gway ma'gwaniyon Kristu?” Anancha losan, “Pailansam as sija san krus!” ");
INSERT INTO kyb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gwon anan Pilato, “Kaman, ngachan nan lagwingay inggwana?” Gwon impaamamodchaot ipa'uy gway manggwana, “Pailansam as sija san krus!” ");
INSERT INTO kyb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Inilan kun Pilato gway maid ma'gwana ja malluki nan kuyu, nangaya kus chanum whinuyugwana nan imana san sangun chanan taku gway manggwana, “Maid kun whijang'u san matojan nannaja osa taku. Cha'aju nan nangamung.” ");
INSERT INTO kyb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Summungwhat ku losan chanan taku anancha, “Nangamung ami sasan kana'mi nu machusaanmi nan matojana.” ");
INSERT INTO kyb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sachi kun impayagwana as Barrabas gwon sa'ad as Hesus impasaplitna kun impawhijangna sasan surchachu tot milansa san krus. ");
INSERT INTO kyb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gwot sa'ad chanan surchachun nan kuwhinnachur iyoycha kus Hesus san agwachan Pilato, whinaligwonggwongan chanan huyuncha surchachu as sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pinonasancha kus sija sinilupancha san chayakay luput gway lagkoyloy. ");
INSERT INTO kyb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nalli'uscha kusan sait iyakipurcha an sija. Kun impaognancha nan tannuhung san machigwananay imana. Nampalintumongcha kusan sanguna nansansannuyanchas sijaay manggwana, “Mawhiwhijag nan Alin nan Hudyu!” ");
INSERT INTO kyb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tinubwhaancha kus sija inayacha nan tannuhung san imanaot iyabchoycha san wha''agna. ");
INSERT INTO kyb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nappungcha kun nansansannuyan as sija inaancha nan chayakay luput gway lagkoyloy an sija kun inigkacha nan sikud gway silupna kun asichaot ilagwa ta umoycha ilansa san krus. ");
INSERT INTO kyb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lummagwacha kusan ili inchasancha nan osa laya'iyay iCirene gway mangngachan Simon. Impapilitcha pahu'ud an sija nan krus Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hummu'nagcha kusan ikaw gway ma'gwaniyon Golgota gway nan pijaona anan ikaw nan Tungern nan Wha''ag, ");
INSERT INTO kyb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","inatchanchas Hesus as inumona san whajasay na'ayutan san apku. Inippongna kun achina kun ininum. ");
INSERT INTO kyb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Illansacha kus sija san krus nangwhiwhinnunutchaay namiwhillay san luputna. ");
INSERT INTO kyb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kun tummu'chuchaay mangijachug an sija ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kun inigkacha san ngatugwon nan wha''agna nan nilistaay nipawhersu an sija gway anana, “Annaja as Hesus gway Alin nan Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Gwot illansacha nan chugwaay mamayangkat san chapat Hesus, osa san machigwananna ja osa san machigwikina. ");
INSERT INTO kyb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ad sa'ad chanan asilayaus gway taku inamamangchas sijaay mawwiggwikigwig ");
INSERT INTO kyb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gway manggwana, “Si'a ku chay manggwanaon igwa''im nan Templon Apudyus ad impata'chorm san tuyu ekajay erkaw. Ay chuud takuwom nan longagnu nu si'a nan Ana' Apudyus ad nilumsa'a san krus.” ");
INSERT INTO kyb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ad isun ahos chanan papangat nan papachi chicha sasan mangaagkammu san lintog ja chanan chacha''orn nan Hudyu gway na'aamamangcha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tinakuna nan uchum gwon achi kun ma'ataku san longagna. Sija nan alin chanan kana' Israel, ay lumsaud san sana san krus ad namati ta'u an sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mantayo' as sija an Apudyus, ayta iligtas ka Apudyus as sija san sana nu whayugwona tan anana, ‘Sa'on nan Ana' Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kun ama ahos chanan mamayangkat gway huyunna nilansa san krus gway inamsiwchas sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mamatu' kun hummulingot nan losanay luta ingkana san singwhattang as anchu. ");
INSERT INTO kyb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Anna kunay singwhattang as anchu nampa'uy as towhag as Hesus gway manggwana, “Eli, Eli, lema sabaktani?” Na pijaona anan, “Apudyus'u, Apudyus'u, kamman ekay manchu'kan sa'on?” ");
INSERT INTO kyb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ad sa'ad chachay uchumay nasi'asi'ad ad aschi chingngorcha nan ingwhakan Hesus kun anancha, “Ajakana as profeta Elias!” ");
INSERT INTO kyb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kun nachanu'yus nan osa an chicha kun nangaya san ispongha gwot insagnongna san na'ilomay whajas kun iyipitna san tannuhung kun inatodna an Hesus ta inumona. ");
INSERT INTO kyb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gwon anan nan uchum, “Awni jan ta ilan ta'u nu umalis Elias gway manaku an sija.” ");
INSERT INTO kyb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nampa'uy kus Hesus asin as towhag na'anut nan angosna. ");
INSERT INTO kyb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ad san sachi ekay sa'ad nan kurtinaay nanorcha' san ingkagwan Apudyus san chayo' nan Templo, nawhis'i kun nan'aggwa gway mallukid ngatu ingkanad choya. Kun nangitakita nan luta gwot nabnabta' chanan whatu. ");
INSERT INTO kyb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ad sa'ad chanan lohon niibwhat gwot nataku chanan angsanay natoy gway takun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lummagwacha kusan lohoncha ummoychad Jerusalem san nappung nataku as Hesus kun nampailacha san angsanay taku ad aschi. ");
INSERT INTO kyb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ad sa'ad nan apitan nan surchachu ja chanan surchachuna nangijachug an Hesus gway nangi'na san kitakita ja nangiila san na'na'gwa, ummogjatchas amod gway manggwana, “Tuttuwa tuwaay Ana' Apudyus nannaja taku!” ");
INSERT INTO kyb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ad iningkaw ad aschi nan angsanay hubhuwhai san akag achaju gway nangiila san na'na'gwa. Chicha chachay nitunud an Hesus manipud ad Galili gway nansilwhi an sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iningkaw an chicha cha Maria gway iMagdala ja Maria gway inan cha Santiago an Jose ja nan inan cha Santiago an Juan gway anana' Zebedeo. ");
INSERT INTO kyb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mummaschom pun hummu'nag nan osa wha'nangay laya'i gway ijArimatea gway mangngachan Jose gway osa ahos as sijaay pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ummoy as sija an Pilato gway nangchaw san lachag Hesus. Gwot ingwhilin Pilato sasan surchachu gway maatod nan lachag an sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inayana kunan lachag Hesus whinichiwhichana san por'asay luput. ");
INSERT INTO kyb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kun inigkana san a''opgwa lohonna gway lijang gwot inalikadna kunan cha'or whatu iyonobna san lohon. Nappung kun lummajaw as sija. ");
INSERT INTO kyb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kun iningkaw as Maria gway iMagdala ja chay osa Maria gway tummutu'chu san sakkang nan lohon. ");
INSERT INTO kyb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mawhikat kun san Erkaw gway Umillongan ummoy chanan papangat nan papachi ja chanan Pariseo an Pilato ");
INSERT INTO kyb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kun anancha, “Apu, simsimmo'mi nan manggwanaan chay sachi taku mangalallilaw say matattakuwana gway anana, ‘Mappung ad nan tuyu erkaw matakuwa'.’ ");
INSERT INTO kyb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sija nan iwhilinnuud gway mawhantajan nan lohon ingkana san mi'atlu erkaw tan tugwakay umoy chanan pasuyutna a'agwon ad anancha sasan takuwon, ‘Nataku as sija san otoy.’ Ad amamochot lagwing nan mangudchiyay manallilagwana say ummuna.” ");
INSERT INTO kyb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Anan Pilato an chicha, “Manajag ajus susurchachu ta i'aju san lohon ad inigkaju nan lobhongjuway mangijachug gway ustu.” ");
INSERT INTO kyb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kun ummoycha san lohon gwot miner'aancha nan whatuway onob nan lohon tot maakammugwancha nu agwad mangigkat kun impaijachugcha. ");
INSERT INTO kyb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nappung kunan Erkaw gway Umillongan gwot gwisnigwisnit san chumingku, ummoy cha Maria gway iMagdala ja chay osaay Maria inila nan lohon. ");
INSERT INTO kyb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kun maag ekay nangitakitas napigsa tan nanosog nan osaay anghel Apudyus gway nerpud langit gwot ummachayug kun inalikadna nan whatu nijonob san lohon kun tinu'chugwana. ");
INSERT INTO kyb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ad sa'ad nan ilana sumiling gway isun nan ilat ja sa'ad nan silupna putputtaa'. ");
INSERT INTO kyb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ad kapu san ogjat chanan mangijaachug an sija mamaypajogpogcha kun nangngachancha isun nan natoy. ");
INSERT INTO kyb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kun anan chay anghel sasay hubhuwhai, “Achi aju umogjat tan akammu'ay as Hesus gway chay nilansa san krus nan anaanaponju. ");
INSERT INTO kyb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Maid kus sijad asna tan nataku gway sija chay ingwhakana. Gwayyu ta ilanju nan niwhanatana. ");
INSERT INTO kyb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ad a''agwayyuway umoy mangiwhaka sasan pasuyutna gway natakus sija ad chongyonju na, umoy as sija umuna an cha'ajud Galili. Aschi nan mangilanju an sija. Sosom'onju nanna ingwhaka' an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ina''agwaycha kunay lummajaw san lohon gway agwad nan ogjatcha ja amod nan lagsa'cha, nanu'yuschaay ummoy nangiwhaka sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kun maag eka nijahot as Hesus an chicha gway manggwana, “Anna aju kay!” Ummachayugcha kun an sija inagworcha nan i'ina kun nanchajawcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kun anan Hesus an chicha, “Achi aju umogjat. I'aju iwhaka sasan susunud'u ta umoychad Galili ad ad aschi nan mangilancha an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sa'ad san lumajagwan chanan hubhuwhai, sa'ad chanan uchumay surchachu mangijaachug san lohon gway ummoy san ili, impachamagcha sasan papangat nan papachi nan losanay na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naayus ku chanan papangat nan papachi ja chanan chacha''or gwot nanuukudcha inatodcha sasan surchachu nan cha'or katad nan pila' ");
INSERT INTO kyb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kun anancha, “Iwhakaju sasan taku gway sa'ad chanan pasuyutna gway ummoy san lawhi ina'awchas sija san nanassujanju. ");
INSERT INTO kyb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ad sa'ad nu chongyon nan kuwhinnachur na cha'ami nan nangamung gway ma'aapapat an sija ad sa'ad as cha'aju maid kun i'aju manchanakan.” ");
INSERT INTO kyb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ad sa'ad chachay nangagwat san pila' inggwacha chay nipa'gwa an chicha. Kun nigwayas nan ingwhakachaay ina'aw chanan pasuyut nan lachag Hesus sasan Hudyu ingkana san sana. ");
INSERT INTO kyb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sa'ad chanan nasagwayan as osaay pasuyut Hesus ummoycha ad Galili san whilig gway ingwhakan Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Inilacha kus sija chinajawchas sija gwon sa'ad chanan uchum nanchugwachugwacha. ");
INSERT INTO kyb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ummachayug kus Hesus anana an chicha, “Naatod an sa'on nan losanay ayobhongan ad langit ja ad asna luta. ");
INSERT INTO kyb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sija nan i'aju ad nangngachanonju pasuyut'u nan losanay taku san losanay ili gway honjakanju chicha san ngachan Ama ja sa'on gway Ana'na ja nan Ispilituna ");
INSERT INTO kyb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ja suyuwanju chicha gway chumngor san ngachan manay ingwhilin'u an cha'aju. Ad iingkagwa' an cha'aju san losanay chimpu ingkana san mappungan nan luhung.”");
INSERT INTO kyb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Annaja nan Whayuway Chamag mipangkop an Hesu Kristu gway Ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sa'ad nan nallukijan nannaja chamag sachi nan tummuttugwaan nan illistan Isaias gway profetan Apudyus gway anan Apudyus, “Anna iwhaun'u nan umuna an si'a gway umoy mangisakana san ajom. ");
INSERT INTO kyb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sija nan mampa'upa'uy san luta gway maid kun ingkaw as taku gwot ananaon, ‘Isakanaju nan ajon nan Apu! Pawhayugwonju nan manadchayanana!’ ” ");
INSERT INTO kyb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gwot nampaila as Juan gway Manghohonjag san luta gway maid kun ingkaw as taku. Kun impaakammuna sasan taku gway manchu'kancha nan whersucha ad nampahonjagcha tot ligwatan Apudyus nan whersucha. ");
INSERT INTO kyb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chachama nan taku gway ummuummoy nanchongor an sija gway nerpu san iliyay Judea ja Jerusalem. Kun ingwhawhagkacha nan whersuchaot whinonjakan Juan chicha san gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sa'ad as Juan sija isisillupna nan inahor gway chutchut nan kamel ja sa'ad nan ayapawna kadchang. Ad sa'ad nan aannona chuchun ja chilu. ");
INSERT INTO kyb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kun ingwhakan Juan sasan takuway manggwana, “Agwad nan umali mipasu an sa'on gway nangatngatu an sa'on, amod nangatu gway achiya' kun miwhilang as mansilwhi an sija uyay mangaan san sinilasna. ");
INSERT INTO kyb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Honjaka' cha'aju san chanum jon sa'ad as sija honjakana cha'aju san Ispilitun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sa'ad san sachi chimpu gway nanghonjakan Juan kummatong as Hesus gway nerpu ad Nazaret ad Galili kun whinonjakan Juan as sija san sachi gwanggwangay Jordan. ");
INSERT INTO kyb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lummosgwa kun as Hesus san chanum inilanaay niibwhat nan langit ad sa'ad nan Ispilitun Apudyus gway isun chi kaob nan kalapati chummo''oya gway ummoy inumpa an sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kun iningkaw nan kinga gway nerpud langit gway manggwana, “Si'a nan ana''uway ipatpatog'u. Mamasoma' an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chadchaan kun impujut nan Ispilitun Apudyus as Hesus san luta gway maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kun iningkaw as Hesus ad aschi as opat puyuway erkaw kun impachas Satanas sulisukan as sija. Iningkaw as sija san agwachan chanan atap gway ajam gwot nansilwhi chanan a'anghel an sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sa'ad san niwhayuchan Juan gway Manghohonjag nanagkulin as Hesus ad Galili kun impaakammuna nan Whayuway Chamag gway nerpu an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kun anana, “Tummuttuwa nan chimpuway chinutu'an Apudyus ad takangay nan mangituyajana sasan takuna. Sija nan manchu'kanju chanan whersuju ja tuttugwaonju nan Whayuway Chamag!” ");
INSERT INTO kyb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Manadchadchayan kus Hesus san tayantag nan whaywhay gway Galili inilana cha Simon an Andres gway mansunud gway ikaokaobcha nan akaidcha san whaywhay tan mangii'ancha. ");
INSERT INTO kyb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kun anan Hesus an chicha, “Gwayyu ta mitunud aju an sa'on ad nangngachano' cha'aju mangii'an san taku gway mamatiyonju chicha an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kun nanitaynancha san akaidchaot nitunudcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Akagcha kun ummachaju san nanadchadchayanancha inilan Hesus nan mansunud gway Santiago an Juan gway ana' Zebedeo. Iniingkawcha san whang'acha gway iperroperrogcha nan akaidcha. ");
INSERT INTO kyb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kun nanijajag Hesus an chicha kun tinaynancha as amacha san whang'a ja chachay tinangchanancha kun nitunudcha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Awni kun ummoy cha Hesus ad Capernaum. Gwot Erkaw ad gway Umillongan nilumno' as Hesus san sinagoga gway maallusan chanan Hudyu kun nansuyu. ");
INSERT INTO kyb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kun nataag chanan nangngor an sija san sussuyuna tan anna nan ayobhonganaay mansuyu. Wha'on kus isun nan insussuyun chanan mangaagkammu san lintog. ");
INSERT INTO kyb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ad sa'ad san sachi nansuyuwana nilumno' nan osa laya'i gway nilno' nan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kun inip'awna gway manggwana, “Hesus gway iNazaret kamma whijawhijangan cha'ami? Umalim tangkaan cha'ami? Akammu' si'a! Si'a chay maid kun whersuna gway ingwhaun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gwon impakino' Hesus chay chimunju gway manggwana, “Kumino''a! Lumajaw'a san sanatay taku!” ");
INSERT INTO kyb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ad sa'ad nan sachi chimunju namajogpokona ku chay laya'i gwot nampa'uy lummajaw as sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kun nataag losan chanan taku kun nanisijimuschaay manggwana, “Ngachan ma nina! Assahuway sussuyu gway anna nan ayobhongana gway mamerjaw sasan chimunju ad chumngorcha hos an sija.” ");
INSERT INTO kyb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chadchaan kun nigwayas nan mipangkop an Hesus san losanay ili ad Galili. ");
INSERT INTO kyb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lummagwa ku cha Hesus san sinagoga ummoycha ancha Santiago an Juan san hoyoy cha Simon an Andres. ");
INSERT INTO kyb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Inuumhog nan naangod gway atukangan Simon gway huwhai sija nan naniwhakacha an Hesus nan mipangkop an sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ummoy ku ummachayug as Hesus san inuumhokana inognana nan imana kun whinangonnaot na'aan nan atungna. Kun pina'anan chay huwhai chicha. ");
INSERT INTO kyb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mummaschom kunay nasi'ut nan init iyoy chanan taku an Hesus nan losanay nasa'it ja chanan takuway nilno' nan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Losan chanan taku san sachi ili naayus san sowhan nan sachi gway hoyoy. ");
INSERT INTO kyb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kun impawhayun Hesus nan losanay taku gway nangicham san na'aya'ayasi gway sa'it kun pinerjawna hos chanan chimunju gway nilumno' sasan taku. Jon achina kun iyujaay kuminga chanan chimunju tan inakammucha as sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mummachani kun hummangon as Hesus kun ummoy ummoossa san maid kun tagtaku gwot nallugwayu. ");
INSERT INTO kyb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kun ummoy cha Simon ja chanan huhuyunna inanap as sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Gwot inchasancha kun anancha, “Chachama nan takuway manganaanap an si'a!” ");
INSERT INTO kyb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kun summungwhat as Hesus gway manggwana, “Maserpuway inta'u san uchumay ili ta iya' ipaakammu hos nan Whayuway Chamag an chicha tan annaja nan kapun nan ummaliya'.” ");
INSERT INTO kyb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kun ummoy as Hesus san ailiili ad Galili gway nansuyusuyu sasan sinagoga ja namperjaw sasan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iningkaw nan osa laya'iyay naleprosi kun ummoy an Hesus nampalintumong. Kun nampa'pa''aasi an sija gway manggwana, “Nu whayugwomay pawhayugwon sa'on akammu'ay lobhongnu.” ");
INSERT INTO kyb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Inachakugwan kun Hesus nan sachi taku iyochonna nan imana an sija gway manggwana, “Whayugwo', humayu'a!” ");
INSERT INTO kyb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kun maag ekay na'aan nan leprosinaot hummayu as sija. ");
INSERT INTO kyb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pinuyung ku Hesus as amod as sija naniperjawna an sija gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Achim pay iwhagwhaka na san uchum gwon i'a manchachawwos mampaila san pachi ta ilana gway hummayu'a. Manchatun'a nu ngachan nan nisuyu san lintog gway inatod Apudyus an Moses as mangakammugwan chanan taku gway hummayu'a.” ");
INSERT INTO kyb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gwon lummajaw ku chay laya'i in'ernga'erngagna nan inggwan Hesus an sija kun adadchuwan nan taku gway nangngor san whayuway inggwa'inggwan Hesus. Sija nan maid kun ininon Hesus gway umoy mampaila san ailiili. Gwot impa''igwotna san maid kun tagtaku gwon ta'on nu amaschi, ummoy an sija chanan takuway nerpu san na'aya'ayasiyay ili. ");
INSERT INTO kyb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Neerkagwanan kunot nanagkulin as Hesus ad Capernaum nanchinamag gway hummu'nag as sija san hoyoycha. ");
INSERT INTO kyb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Amod nan takuway naayus ingkana san maid kun magkagwan ad chayo' ja sowhan. Kun impaakammun Hesus nan ukud Apudyus an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kun hummu'nag chanan takuway nangijoy san osa takuway napalalais gway chinachangoy nan opatay laya'i. ");
INSERT INTO kyb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kapu san inaachun nan taku maid kun ininonchaay mangijoy an sija san agwachan Hesus. Kun ummoycha san sahoy gwot asichaot ahutan nan whatug Hesus kun inursuuscha chay napalalais gway iniingkaw san oogkana. ");
INSERT INTO kyb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Inilan kun Hesus nan pammaticha an sija anana say napalalais, “Sunud, niligwata' chanan whersum.” ");
INSERT INTO kyb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ad sa'ad chanan uchum gway mangaagkammu san lintog gway natu'tu'chu san sachi anancha san somsomo'cha, ");
INSERT INTO kyb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kamma nan osa takuwanna iwhagwhaka nan amasna? Maamamang as Apudyus san ingwhakana anchi! Ama' agwad uchum as sillobhong malligwat san whersu nu achi ahus as Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Gwot chadchaan kun inakammun Hesus nan agwad san somsomo'cha. Kun anana an chicha, “Ka'ajuman manomsomo' as amasnat? ");
INSERT INTO kyb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngachan nan lanuy as iwhaka sanna napalalais, ‘Niligwata' chanan whersum’ gwinnu ‘Humangon'a ta ayam nan oogkam ad nanadchayan'a?’ ");
INSERT INTO kyb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta maakammugwanjuway sa'ad as sa'on gway Ana' nan Taku anna nan ayobhonga'ay malligwat san whersu ad asna luta, ilanju nannaja oo'.” Sija nan anana say napalalais, ");
INSERT INTO kyb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iwhaka' an si'a, humangon'a ta ayam nan inogkam ad lummajaw'a ad ugwaju.” ");
INSERT INTO kyb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kun hummangon as sijaot nanijayana san inogkana gwot lummajaw gway nilausana nan adadchuwan gway nangila an sija. Kun nataagcha losanot nanchaychajawcha an Apudyus gway manggwana, “Maid kun inila ta'u as isun nan amasna!” ");
INSERT INTO kyb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ummoy asin as Hesus san tayantag nan whaywhay ad Galili. Ad sa'ad nan angsanay taku ummoycha an sija kun sinuyuwana chicha. ");
INSERT INTO kyb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nappung kun chiyot manadchadchayan as Hesus inilana as Levi gway ana' Alfeo gway tummutu'chu san sisingngilan san hugwis kun anan Hesus an sija, “Tunuchona'.” Lummiggwat kus Levi nitunud an sija. ");
INSERT INTO kyb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Namingsan ad ummoy cha Hesus san hoyoy Levi. Ad sa'ad san mangamanganan cha Hesus ja chanan pasuyutna ummoy na'a'an an chicha nan angsanay manchachakup san hugwis ja chanan humersuwhersu tan angsan nan nitunud an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sa'ad chanan uchumay mangaagkammu san lintog gway Pariseo, inilacha ad as Hesus gway na'a'an sasan humersuwhersu ja manchachakup san hugwis, ingwhakacha sasan pasuyutna gway manggwana, “Kaman ma'a'an as Hesus san a'ammasnatay taku?” ");
INSERT INTO kyb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chingngorn kun Hesus chi iyagwatnaay nanungwhat an chicha gway manggwana, “Sa'ad nan takuway maid sa'itna wha'on kus maserpuna nan manaakas. Sija manserpu san manaakas chanan nasa'it. Wha'on kus sija ummaliya' nan manajaka' sasan whayuway taku, sija ummaliya' nan ajaka' chanan humersuwhersu.” ");
INSERT INTO kyb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sa'ad nan namingsanay nallaunan chanan pasuyut Juan gway Manghohonjag ja chanan Pariseo ummoy nan uchumay taku an Hesus kun nanimuschaay manggwana, “Kaman mallaun chanan pasuyut Juan ja chanan pasuyut chanan Pariseo kunja achi chanan pasuyutnu?” ");
INSERT INTO kyb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kun summungwhat as Hesus gway manggwanaay nangijagwat, “Jo'o mallaun chanan ma'abyay nu agwad an chicha nan laya'iyay mangibyay? Ay mangancha hos ja! ");
INSERT INTO kyb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ayawniyot humu'nag nan chimpuway milajaw nan laya'iyay mangibyay an chicha ad asichaot mallaun.” ");
INSERT INTO kyb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Intuyuy Hesus iyagwat gway manggwana, “Maid kun mangiter'up san a''opgwa luput san chachaanay silup. Tan sa'ad nu amaschi nan oona akusuton nan a''opgwa niter'up nan niter'upana luput ad ummamamod nan whis'in nan nichaitana gway chachaanay luput.” ");
INSERT INTO kyb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Maid kuhos mangigka san whilung san chachaanay mangiigkaanay kadchang. Tan sa'ad nu amaschi nan ma'gwa awni ad hota'on nan whilung nan sachi mangiigkaan ad niwhallu nan whilung. Uyay nan sachi mangiigkaan migwa''i. Sija nan nu agwad whilung sija mangigkaanta nan a''opgwa gway mangiigkaan.” ");
INSERT INTO kyb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sa'ad san namingsanay Erkaw gway Umillongan nangoy cha Hesus ja chanan pasuyutna san tayun gway namullan san kerkergwit kun nangkatukatu chanan pasuyutna as utimancha. ");
INSERT INTO kyb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kun anan chanan Pariseo an Hesus gway manggwana, “Ilam ad kamma chanan pasuyutnu annat oon nan amaschi san Erkaw gway Umillongan san mijachi san lintog ta'u?” ");
INSERT INTO kyb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kun summungwhat as Hesus gway manggwana, “Jo'o achiju whinasa nan inggwan cha Dabid ja chanan takuna san agwi san nawhitilancha. ");
INSERT INTO kyb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nilumno' as Dabid san hoyoy Apudyus kun nangan san tinapay gway nichatun an Apudyus. Na'gwa nan annaja san chimpu gway as Abyater nan angatuwanay pachi. Ad sa'ad nan lintog ta'u sija ekay mijujaay mangan chanan papachi san sanatay tinapay. Gwon nangan as Dabid kun inatchana hos nan huhuyunna.” ");
INSERT INTO kyb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kun anan ahos Hesus an chicha, “Na'gwa nan Erkaw gway Umillongan as humayugwan nan atakutaku, wha'on kus na'gwa nan taku as humayugwan nan Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sija nan sa'ad as sa'on gway Ana' nan Taku anna nan ayobhonga'ay manggwas whayu san Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Asin kun ummoy as Hesus san sinagoga kun iningkaw nan osa laya'i gway napalalais nan osa imana. ");
INSERT INTO kyb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ad sa'ad chachay takuway iniingkaw sisipputancha as Hesus ta ilancha nu pawhayugwona nan laya'i san Erkaw gway Umillongan tot agwad mangichayumancha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kun anan Hesus say laya'i, “Gwaynu' asna.” ");
INSERT INTO kyb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kun anan Hesus gway nangimus sasan taku, “Ngachan nan ijujan nan lintog ta'uway oon san Erkaw gway Umillongan? Manggwa san whayu gwinnu manggwa san lagwing? Manaku san whijag gwinnu mangtoy san whijag?” Gwon nakinokino'cha. ");
INSERT INTO kyb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Intollongna kun chicha gway ummogwot ja summanga as amod tan achicha kun chumngor, anana say laya'i, “Ujachom nan imam.” Kun inujad chay laya'i nan imana kun hummayu. ");
INSERT INTO kyb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lummajaw ku chachay Pariseo san sinagoga ummoycha sasan takun Ali Herod kun chadchaan kun nanuukuchancha nu ngachan nan ininoncha mangipaotoy an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ummadchajang ku cha Hesus ja chanan pasuyutna san tayantag nan whaywhay nitunud ahos nan chachama taku gway nerpud Galili ja nerpud Judea, ");
INSERT INTO kyb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem ja Idumea ja chanan nerpu san chomang nan gwanggwang gway Jordan ancha chanan nerpu san iliyay sa'upon nan Tiro ja Sidon. Umoycha ilan as Hesus tan angsan nan chingngorchaay inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa'ad tan angsan chanan taku ingwhakan Hesus sasan pasuyutna ta umisakanacha as whang'a as igkagwana ta achi maipit as sija sasay taku. ");
INSERT INTO kyb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kapu san angsanay impawhayuna mansusulig nan losanay nasa'it gway umoy an Hesus ta ognancha as sija. ");
INSERT INTO kyb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ad sa'ad chachay nilno' nan chimunju ilancha ad as sijaon nampalintumongcha san sanguna gway mangipo'aw gway manggwana, “Si'a nan Ana' Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Gwon pinuyupuyung Hesus chachay chimunju gway achicha ipaakammu nan mipangkop an sija. ");
INSERT INTO kyb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ummoy nanakacha as Hesus san whilig kun inajakana chanan pinilina kun ummoycha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kun nanchutu' as sija as nasagwayan as chugwa as apostolesna, pinilina chicha as manghuyunna ad chicha nan iwhaunna gway umoy mangiwhaka san ukud Apudyus ");
INSERT INTO kyb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ja maatchancha as ayobhongan gway mamerjaw sasan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Annachaja nan chinutu'anaay nasagwayan as chugwa: Simon (gway nginachanan Hesus as Pedro); ");
INSERT INTO kyb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","cha Santiago an Juan gway ana' Zebedeo (nginachanan Hesus chicha as Boanerges gway sa'ad nan pijaona anan, Anana' nan Ichur tan huchu''ancha), ");
INSERT INTO kyb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andres, Felipe, Bartolome, Mateo, Tomas, Santiago gway ana' Alfeo, Tadeo, Simon gway ananchaon Patriota, ");
INSERT INTO kyb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja as Judas Iscariote gway nangijiwhit an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lummajaw as Hesus kun asin ahos naayus nan angsanay taku, sija nan sa'ad as Hesus ja chanan pasuyutna maid kun ininonchaay mangan. ");
INSERT INTO kyb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chingngorn ku chanan susunud Hesus chi ummoycha tot ilajawcha otjan as sija tan ananchaon, “Nayapang as Hesus!” ");
INSERT INTO kyb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ad sa'ad nan uchumay mangaagkammu san lintog gway nerpud Jerusalem asi'a'anancha, “Nilumno' as Beelzebub an Hesus. Ad sa'ad nan ayobhonganaay mamerjaw san chimunju nerpu san pangat chanan chimunju.” ");
INSERT INTO kyb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Inayus kun Hesus chicha iyagwatna gway manggwana, “Ngachamma ininon Satanasay mamerjaw san longagna. ");
INSERT INTO kyb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sa'ad nu mangwhiwhinnursu chanan taku san ili mampatingkacha. ");
INSERT INTO kyb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ad sa'ad nu manisiisi' chanan singwherjan masibsibta'cha. ");
INSERT INTO kyb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ad amasna as Satanas gway sa'ad nu lawhanona ja sinasinaona chanan chimunjuna mampatingka nan ayobhongana. ");
INSERT INTO kyb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Isuna hos gway maid kun ma'erno' san hoyoy nan pigsaay taku tot mana'aw san a'unna nu achina jan unaon ita'od nan pigsaay taku ad asinaot ayan nan a'unna. ");
INSERT INTO kyb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Iwhaka' an cha'aju nan tuttuwa, ma'gwaay ligwatan Apudyus nan losan gway whersun nan taku ja ngachan manay apaapatonchaay lagwing gway mipangkop an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gwon nu ngachan nan manapapat san lagwing mipangkop san Ispilitun Apudyus kadto'ay achin kun Apudyus ligwatan nan whersuwanna ad whersuna ekay chi as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ingwhakan Hesus nan amaschi tan ingwhakachaay, “Nilno' nan chimunju as sija.” ");
INSERT INTO kyb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sachi kun hummu'nag nan inan Hesus ja chanan susunudna laya'i. Summisi'adcha san sowhan gway impaajagcha as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ad sa'ad nan angsanay taku gway natu'tu'chu gway nampali'gwos an sija, ingwhakacha an sija gway manggwana, “Agwad cha inam ja chanan susunudnu san sowhan gway anapon cha'a.” ");
INSERT INTO kyb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Summungwhat kus Hesus an chicha anana, “Iwhaka' an cha'aju nu ngachan nan iwhilang'us ina' ja susunud'u.” ");
INSERT INTO kyb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nilangyangana ku chanan nampali'gwos an sija anana, “Annachaja nan iwhilang'us ina' ja susunud'u! ");
INSERT INTO kyb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tan sa'ad chanan manggwa san whayugwon Apudyus chicha nan iwhilang'us susunud'u ja ina'.” ");
INSERT INTO kyb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Asin ahos nansuyu as Hesus san ikid nan whaywhay ad Galili. Kun naayus nan amochay taku an sija, sija nan ummoy as sija tummu'chu san whang'a gway agwad san ikid nan whaywhay kun iningkaw chanan taku san tayantag gway manchongor. ");
INSERT INTO kyb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kun angsan nan insuyun Hesus an chicha gway iyagwatna. Sa'ad san nansuyuwana anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Chongyonju nannaja! Iningkaw nan osa takuway ummoy nawwakagwag san whini. ");
INSERT INTO kyb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mawwakagwakagwag kun ummoy nan uchumay gwakagwag san chayan gwot ummoy ku chanan mammanu' timpo'cha. ");
INSERT INTO kyb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sa'ad nan uchum ummoycha san whattuwhattuway a'it nan lutana kun nallasu nan summimitancha kapu san maymayyapit nan lutana. ");
INSERT INTO kyb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gwon ummamod kunan init na'yuy chachay minuya kun na'kingcha tan achicha kun lummamut. ");
INSERT INTO kyb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sa'ad nan uchumay gwakagwag ummoycha san agwachan nan sassait. Kun chummacha''or chanan sait gwot sinjungcha chanan minuya ad sija nan achicha kun nangkas. ");
INSERT INTO kyb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ad sa'ad nan uchumay gwakagwag ummoycha san lumong kun chumma'orcha gwot whinumkascha. Nangkas nan osa as tuyumpuyu, ad nan osa onompuyu ja nangkas chanan uchum as singkasut.” ");
INSERT INTO kyb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kun pinungpung Hesus gway manggwana, “Nu ngachan nan naingaan maserpu manchongor!” ");
INSERT INTO kyb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sa'ad san ummahusan Hesus inimus chachay nasagwayan as chugwaay apostolesna ja chanan uchumay nitunud an chicha nu ngachan nan pijaona anan chay iyagwatna. ");
INSERT INTO kyb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kun anan Hesus, “Nipaakammu an cha'aju nan chaan kun maakammugwan gway mipangkop san Mantuyajan Apudyus jon sa'ad san uchum pasig agwat nan misuyu an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tot ‘Ta'on nu iillancha achicha kun maimatunan ja ta'on nu chochongyoncha achicha kun maagwatan. Ad sa'ad nu milasincha ja maagwatancha tugwakay managkulincha an Apudyus ad niligwatana nan whersucha.’ ” ");
INSERT INTO kyb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sachi kun anan Hesus an chicha, “Jo'o maid akammuju say iyagwat'u? Ininonjuma mangakammu san losanay agwat'u nu'? ");
INSERT INTO kyb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sa'ad chay nawwakagwag ukud Apudyus nan iwwakagwagna sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ad sa'ad chachay gwakagwag gway ummoy san chayan mijagwat sasan taku gway nangngor san ukud Apudyus gwon nanipyos Satanas san ukud gway nisuyu an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Ad sa'ad chachay gwakagwag gway ummoy san whattuwhattuway a'it nan lutana mijagwat sasan taku gway chingngorcha kun ekay ukud Apudyus nallaylajadchaay nangagwat. ");
INSERT INTO kyb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gwon isucha chachay minuya gway achi kun lummamut sija nan chadchaan kun na'yuycha. Ad isuna hos nu humu'nag nan likat an chicha gwinnu matupotupo'cha kapu san namatiyancha ad chadchaan ad nanchu'kancha nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ad sa'ad nan uchumay gwakagwag gway ummoy san agwachan nan sassait isun chachay nangngor san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Gwon kapu san somsomo'cha san whijagcha ja mauyawcha san atchon nan whayangna mampawha'nang ancha mayapancha san whayangna ekasnat, sija nan sachi nan nasjungan nan ukud Apudyus san whijagcha ad achi kun nangkas nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ad sa'ad chachay gwakagwag gway ummoy san lumong mijagwat sasan takuway nangngor san ukud Apudyus kun inagwatcha ja tinuttuwacha. Ad isucha hos chanan minuya gway humkascha as tuyumpuyu, onompuyu ja singkasut.” ");
INSERT INTO kyb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Intuyuy Hesus iyagwat gway manggwana an chicha, “Jo'o ma'gwaay matangwhan nan nangongokkanay silaw san timba gwinnu miigka san silu' nan kama. Jo'o wha'on as sija miigkaana nan papattangan. ");
INSERT INTO kyb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tan amasna, nu ngachan nan mitayu awni ad nallotaw. Ad sa'ad nan misulib san sana maakammugwan a' asi. ");
INSERT INTO kyb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu ngachan nan naingaan maserpu manchongor!” ");
INSERT INTO kyb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kun anana hos an chicha, “Sija nan ammanju ilan nan chongyonju tan nu aman nan topong nan atchonju sija ahos nan topong nan maayaju ad amod pay. ");
INSERT INTO kyb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tan nan takuway anna nan naagwatana san mipangkop an Apudyus ja san Mantuyajana, achu pay nan maagwatana. Gwon nu ngachan nan takuway maid maagwatana uyay nan a'it gway naagwatana ma'aan an sija.” ");
INSERT INTO kyb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Intuyuy Hesus iyagwat gway manggwana, “Amasna nan mijagwatan nan Mantuyajan Apudyus, anna nan osa takuway ummoy nawwakagwag san whini san tayunna. ");
INSERT INTO kyb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa'ad as sija masujop san lawhi ad hummangon san whigwhikat. Ad whinumta' ja chuma'or nan minuyana gwon wha'on kus akammun nan sachi taku nu ngachan nan ininon nan tummuhuwancha. ");
INSERT INTO kyb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sa'ad nan luta sija nan mangipatuhu san minuya, sumimit ad janay umuna nan tuhuna ja chuma'or asinaot ilukiyay mahuki ad asiyot mamushus ad asiyot ma'gwas inutim. ");
INSERT INTO kyb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ad sa'ad nu merrum ummoyna inani tan chimpun nan iya''ani.” ");
INSERT INTO kyb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sachi kun anan Hesus gway manggwana, “Amasna nan mijagwatan nan Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mijagwat san hu'orn nan mustard gway awha''ijutan san losanay hu'or san luta. ");
INSERT INTO kyb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gwon sa'ad nu mimuya ja chuma'or sija nan acha'yan san losanay minuya san kerchin gway a'annanchu chanan pangana ad mawhalinay mangubhu chanan mammanu' san ichungna.” ");
INSERT INTO kyb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A'ammasnaay agwat nan ininon Hesus gway nangisuyu san ukud Apudyus sasan taku gway ikad san loogcha maagwatan. ");
INSERT INTO kyb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sija usuusayona nan agwat nu mansuyu an chicha gwon nu umahuscha sasan pasuyutna, inammana iwhaka losan an chicha nan pijaon chachay agwat anan. ");
INSERT INTO kyb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mummaschom kun san sachi erkaw anan Hesus sasan pasuyutna, “Inta'u chumormang.” ");
INSERT INTO kyb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tinaynancha ku chachay angsanay taku ummoycha san whang'a gway iniingkagwan Hesus. Iningkaw ahos chanan uchumay namang'a gway nitunud an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chadchaan kun maag ekay namali. Kun natapitapija'an nan whang'a gwot takangay mapnu san chanum. ");
INSERT INTO kyb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ad sa'ad as Hesus iniingkaw san oppoyan nan whang'aay nanassuy gway nampopongngan. Gwot whinangon chanan pasuyutna gway manggwana, “Mistuyu, ka'a mamassuy san takangay ta'u malinong?” ");
INSERT INTO kyb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hummangon kus Hesus impakino'na nan whali kun anana san whaywhay, “Akay! Kumino''a!” Kun na'aan nan whali gwot ummino' nan whaywhay. ");
INSERT INTO kyb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kun anan Hesus sasan pasuyutna, “Ka'ajuman umogjat? Umman ekay pammatiju?” ");
INSERT INTO kyb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kun nataagchas amod kun asi'a'anancha, “Ngachamma atakun nina tuwa? Uyay nan tungnin ja tapiya' pakin'ona achon nakakino'!” ");
INSERT INTO kyb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Awni kun chummormangcha san sachi whaywhay kun hummu'nagcha san iliyay agwachan nan iGerasa. ");
INSERT INTO kyb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nilumsa kus Hesus san whang'a nijahot an sija nan osa laya'i gway nilno' nan chimunju gway nerpu san lijangay loyobhonan. ");
INSERT INTO kyb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sa'ad nannaja laya'i sija iingkagwana nan loyobhonan. Ipukopukodcha ad ekay tot talijanchaon achicha kun lobhong ta'on nu talijancha san ayuwhing'i. ");
INSERT INTO kyb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tan nangimmancha ta'chon nan imana ja i'ina ad whinsawhinsatna nan ayuwhing'i. Maid kun osas ontog as sillobhong an sija. ");
INSERT INTO kyb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Whinikatay mampa'upa'uy as sija san loyobhonan ja whibilig ad jinamajamanna nan longagna san whatu. ");
INSERT INTO kyb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Inilan ku chay nilno' nan chimunju gway mayungay as Hesus san achaju nanodcha' kun nampalintumong san sangun Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kun inip'awna gway manggwana, “Hesus gway Ana' nan angatuwanay Apudyus achim whijangan as sa'on. Ipa'pa''aasi' an si'a gway iwhawhagkam san ngachan Apudyus gway achim palikatan as sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Amasna nan ingwhakana tan anan Hesuson, “Si'aay chimunju, lumajaw'a.” ");
INSERT INTO kyb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kun inimus Hesus gway manggwana, “Ngachan nan ngachannu?” Kun summungwhat chay chimunju gway manggwana, “Nilihu nan ngachan'u tan chachama ami.” ");
INSERT INTO kyb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kun nampa'pa''aasi an Hesus chachay chimunju ta achina otjan perjagwon chicha san sachiyay ili. ");
INSERT INTO kyb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sa'ad san whilig gway achani san sachi ili iningkaw nan angsanay hoyo' gway asijaayab. ");
INSERT INTO kyb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kun anan chachay chimunjuway nampa'pa''aasi, “Ipooynu cha'ami sanchichajaay hoyo' ad ijujam cha'amiyay lumno' an chicha.” ");
INSERT INTO kyb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kun iyujan Hesus chicha. Lummagwa ku chachay chimunju say laya'i ummoycha nilumno' sasay hoyo' gway ummoy as chugwallihu. Kun asitotodcha'cha losan gway nanotchag san chopyas kun nitubungcha san whaywhay gwot nalinongcha losan. ");
INSERT INTO kyb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ad sa'ad chachay taku nama'apa'an sasay hoyo' inilacha kunan na'gwa nanodcha'chaay ummoy san ili ja sasan whija' gway mangiwhaka san na'gwa. Sija nan ummoy chanan taku inila nan sachi na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ad sa'ad san umachanijancha an Hesus inilacha nan laya'i gway lummagwaan chanan alihulihuway chimunju. Tummutu'chuway nansisillup gway hummayu nan somsomo'na. Kun ummogjatcha losan. ");
INSERT INTO kyb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ad sa'ad chachay nangila san na'gwa say laya'i ja chanan hoyo' impachamagcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kun nampa'pa''aasi chanan taku an Hesus ta lumajaw san ilicha. ");
INSERT INTO kyb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Anna kunay mamang'as Hesus nampa'pa''aasi chay takuway namerjagwan Hesus san chimunju ta mitunud an sija. ");
INSERT INTO kyb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jon iyachin Hesus gway manggwana, “I'a san ahumerjannu ad impachamagnu an chicha nan amochay inggwan Apudyus an si'a ja nan nangachakugwana an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gwot lummajaw chay laya'i gway ummoy san ailiiliyay Decapolis kun inuullitna losan nan inggwan Hesus an sija. Kun nataag losan chanan takuway nangngor san ingwhakana. ");
INSERT INTO kyb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Asin kus Hesus chumormang san whaywhay naayus nan angsanay taku an sija san tayantag. ");
INSERT INTO kyb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kun hummu'nag as Jairo gway osaay pangat san sinagoga san sachiyay ili. Inilana kus Hesus nampalintumong kun nampa'pa''aasi an sija gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Takinotojon nan ana''u gway huwhai. Akagnuud ta umalim ipatay nan imam an sija ta humayu ad nataku!” ");
INSERT INTO kyb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kun nihuyog as Hesus an sija. Kun nitunud ahos nan chachama takuway mansusulig. ");
INSERT INTO kyb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ad sa'ad nan amochay takuway mansusulig iningkaw ahos nan osa huwhai gway achi kun natnatchu' nan chayana san nasagwayan as chugwa tagwon. ");
INSERT INTO kyb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Amod ekay likatna san nampaakasana san angsanay chu'tur gwot namin ekay nakastu nan losanay u'ugwana gwon achi ekay paat hummayu. Ummamochot nan sa'itna. ");
INSERT INTO kyb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chingngorna ad nan mipangkop an Hesus ummoy na'as'aslig san amod gway taku kun sinakidna nan lagkoyloy gway silup Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tan anana san somsomo'na, “Uyay otjan ekay sakicho' nan lagkoyloy gway silupna humayuwa'!” ");
INSERT INTO kyb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kun inognanaot nakanino' nan chayaay lumagwa an sija kun kini'nanaay na'aan nan sa'itna. ");
INSERT INTO kyb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sachi kun kini'nan Hesus gway agwad nan impawhayun nan ayobhongana, sija nan nantulili kun inimusna sasan taku gway manggwana, “Ngachan nan nangchon san silup'u?” ");
INSERT INTO kyb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kun anan chanan pasuyutna, “Iillam ad gway angsan nan takuway mansusulig san ochognuwon, kamman imuson nu ngachan nan nangchon an si'a?” ");
INSERT INTO kyb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kun nallangyanga as Hesus gway manganap nu ngachan nan nangchon an sija. ");
INSERT INTO kyb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gwot inakammun chay huwhai nan na'gwa an sija, sija nan namajogpog san ogjatna gway ummachani an Hesus kun nampalintumong san sanguna kun ingwhakana nan losan gway na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kun inamman Hesus anan say huwhai, “Kapu san pammatim hummayu'a. Lumajaw'a ad achi'a manchanag tan achi ku asin manulin nan sa'itnu!” ");
INSERT INTO kyb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ad sa'ad san ma'aapaapatan Hesus say huwhai hummu'nag nan uchumay taku gway nerpu san hoyoy cha Jairo gway manggwana an Jairo, “Natoy nan ana'nu, sija nan achim ta'ta'on nan Mistuyu?” ");
INSERT INTO kyb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gwon wha'on kus chongyon Hesus nan ingwhakacha an Jairo. Ingwhakanaot an sijaay, “Achi'a umogjat, mamati'a ekay.” ");
INSERT INTO kyb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kun iyachin Hesus chanan taku mihuyog an sija. Ahus as Pedro ja cha Santiago an Juan gway mansunud as iyujanaay mihuyog. ");
INSERT INTO kyb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hummu'nagcha kun san hoyoy chay pangat san sinagoga inilan Hesus nan asingangayaay taku gway amod nan towhag nan iwhilcha. ");
INSERT INTO kyb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nilumno' kus Hesus ad chayo' anana an chicha, “Ka'aju asingangaya ancha asijiiwhil? Achi ku natoy nan sanatay ana'. Nassuy ekay.” ");
INSERT INTO kyb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kun inamamangcha as sija. Gwon impayagwana chicha losan kun inghuyogna nan sinana' ja chachay nihuyog an sija kun nilumno'cha san agwachan nan whawhallas. ");
INSERT INTO kyb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inognan kun Hesus nan iman chay ana' anana, “Talita kumi!” Sa'ad nan pijaona anan nan sachi, “Ana', humangon'a!” ");
INSERT INTO kyb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kun nawhanangon chay ana' kun nanadchadchayan. (Nasagwayan as chugwa nan tagwon chay ana'). Kun nataagchas amod san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gwot pinuyung Hesus chicha losan ta achicha iwhagwhaka nan na'gwa. Kun anana hos an chicha, “Pa'ananjus sija.” ");
INSERT INTO kyb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lummajaw as Hesus ad Capernaum kun nanulin san ilina gway Nazaret. Kun nitunud an sija chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa'ad san Erkaw gway Umillongan ummoy as Hesus nansuyu san sinagoga. Iningkaw nan angsanay taku san sachi kun nataagcha losan gway nanchongor an sija. Kun anancha san somsomo'cha, “Agwamma nangallan nannaja taku san annachajaay iwhakawhakana? Ngachamma nan ayasin nan laing gway agwad an sija? Ininonaay manggwa san mataakan gway inggwa'inggwana? ");
INSERT INTO kyb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jo'o wha'onna san apantilu gway ana' Maria ja sunud cha Santiago, Josep, Judas ja Simon. Ad annacha hos ad asna chanan susunudnaay hubhuwhai!” Kun nilagwingcha as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kun anan Hesus an chicha, “Tuttuwa gway ngachamman sinatay ili nan umajan nan profetan Apudyus patkon nan taku as sija. Gwon nan kadto'ay ailijana ja chanan ahumerjanna achicha kun patkon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ad kapu tan achicha kun tuttugwaon as Hesus maid ku ininona gway nanggwa san mataakan san sachiyay ili, ahus chachay nangijochonana san imana as hummayu. ");
INSERT INTO kyb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kun nataag as Hesus tan a'it nan namati an sija. Sachi kun kinagkakagka'ay Hesus nan ailiili ad Nazaret gway ummoy nansuyu. ");
INSERT INTO kyb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Osa kunay erkaw inajakan Hesus chachay nasagwayan as chugwaay apostolesna kun sininchuggwana chicha iwhaun gwot inatchana chicha as ayobhonganay mamerjaw sasan chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kun pinuyungna chicha gway achicha managwit as uyay whayangnas nat san mangwhaatancha, ahus nan sur'ud. Achicha mansongot, managwit as mangigkaan san ochon ja achicha managwit as pila'. ");
INSERT INTO kyb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mawhalinay mansinilascha gwon achicha kun managwit as adgwan nan kotap nan silupcha. ");
INSERT INTO kyb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kun anana hos an chicha, “Sa'ad nu agwad mammangili an cha'aju ingkaw aju san hoyoycha ingkanas lumajaw aju san sachi ili. ");
INSERT INTO kyb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ad sa'ad nu ngachan nan iliyay achi mammangili an cha'aju ja lagwingoncha hosay mangngor an cha'aju, lumajaw aju ad pinu'pu'anju nan chapur san i'iju as mangakammugwanchaay lagwingon Apudyus nan inggwacha.” ");
INSERT INTO kyb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lummiggwat ku chachay apostolesna impaakammucha san takuway maserpu manchu'kancha chanan whersucha. ");
INSERT INTO kyb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kun pinerjawcha nan angsanay chimunju. Kun nilankancha nan angsanay nasa'it kun impawhayucha chicha. ");
INSERT INTO kyb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sa'ad as Herod gway alin nan Galili chingngorna nan mipangkop an Hesus tan nanchinamag nan inggwa'inggwan Hesus. Anan chanan uchumay taku, “Nataku as Juan gway Manghohonjag! Sija nan agwad an sija nan ayobhonganay manggwa san mataakan.” ");
INSERT INTO kyb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kun anan ahos chanan uchum, “Sija as Elias!” Anna ahos chanan uchum gway manggwana, “Sija nan osa profeta gway isun chachay profeta san agwi.” ");
INSERT INTO kyb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gwon chingngorn kun Ali Herod nan mipangkop san annaja anana, “Sija as Juan gway kinungsuya' gway nataku!” ");
INSERT INTO kyb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tan sa'ad san nugwan sa'ad as Herod impatiliwnaot sija kus Juan, asinaot ipawhayud kapu an Herodias gway in'ahoyoyna gway asagwan Felipe gway sunudna. ");
INSERT INTO kyb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tan inna'innanan Juan gway Manghohonjag san agwi an Herochon, “Achi kun ma'gwa nan i'ahoyoynu nan asagwan nan sunudnu.” ");
INSERT INTO kyb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sija nan amod nan lingun Herodias an Juan kun whayugwonaay ipaotoy as sija. Gwon maid kun ininona ");
INSERT INTO kyb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tan ummogjat as Herod an Juan san inakammunaay nalintog ja takun Apudyus as sija, sija nan whayugwon Herod gway takuwon as sija. Ad sa'ad san nangngoyana san insuyun Juan nalihu' nan somsomo'na gwon whayugwona chongyon as Juan. ");
INSERT INTO kyb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niwhatug kunan erkaw gway nijana'an Herod sachi nan gwajan Herodias gway mangipaotoy an Juan. Inajakan Herod nan losanay nangangatuway papangat nan kuwhilnu ancha papangat chanan surchachu ja chanan mawhigwhigwhig gway taku san Galili. ");
INSERT INTO kyb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nilumno' kunan whawhallas gway ana' Herodias gwot nansaya pinayagsa'na cha Herod ja chanan mangilina gway nanghuja. Sija nan anan Ali Herod san whawhallas, “Ochagwom nan whayugwom gway ochagwon ta atcho' an si'a!” ");
INSERT INTO kyb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Insapatana pajay manggwana, “Atcho' nu ngachan nan whayugwomay ochagwon, uyay pay koggwan nan mantuyaja'.” ");
INSERT INTO kyb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lummagwa kun chay whawhallas inimusna an inana gway manggwana, “Ngachan nan ochagwo'?” Ad sa'ad nan insungwhat inana, “Ochagwom nan wha''ag Juan gway Manghohonjag!” ");
INSERT INTO kyb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nanaagkulin kun chay whawhallas an Ali Herod anana, “Whayugwo'ay atchom an sa'on san sana nan wha''ag Juan gway Manghohonjag gway napapallangkan!” ");
INSERT INTO kyb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kun amod nan sangan Ali Herod gwon kapu san lausna ingwhaka an sija san sangun chanan mangilina, achina kun mawhalinay pawhainan chay whawhallas. ");
INSERT INTO kyb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Naniwhaunna kusan osaay surchachu ingwhilinnaay ijoyna nan wha''ag Juan gway Manghohonjag. Ummoy kunan surchachu san whawhalluchan kinungsuyana as Juan. ");
INSERT INTO kyb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kun inghu'nagna nan wha''ag Juan gway napapallangkan kun inatodna san whawhallas gwot asinaot atchon an inana. ");
INSERT INTO kyb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chinamag kun chanan pasuyut Juan nan na'gwa an sija ummoycha inaya nan lachagna kun inilhoncha san loyobhonan. ");
INSERT INTO kyb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ad sa'ad chachay apostoles Hesus nanulincha an sija kun impachamagcha an sija nan losanay inggwacha ja insuyucha. ");
INSERT INTO kyb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kapu san adadchuwan nan takuway mangwhinu'nag maid kun ininonchaay mangan, sija nan anan Hesus sasan apostolesna, “Inta'u tuma'iyan san mawhalin ta'uway umillongan.” ");
INSERT INTO kyb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kun namang'achaay ummoy tumma'iyan san maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gwon angsan nan nangila san lummajagwancha ja nangilasin an chicha. Sija nan asitotodcha'cha gway nerpu san ailiiliyay nangoy san tayantag kun ummunacha hummu'nag san umajan cha Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nilumsa kus Hesus san whang'a inilana chachay amochay taku kun nachaku an chicha tan amacha as kernero gway maid kun mangipastur an chicha. Kun illukinaay nansuyu gwot angsan nan insuyuna an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Anna kunay mumaschom ummoy chanan apostolesna an sija gway manggwana, “Anna mumaschom ad maid kun hohoyoy ad asna. ");
INSERT INTO kyb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Perjagwom chanan taku sasan achaniyay ili tot umoycha malla'u as anoncha.” ");
INSERT INTO kyb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Gwon anan Hesus gway summungwhat an chicha, “Atchanju chichas anoncha.” Kun anancha an Hesus, “Sija whayugwomay anan nan i'ami malla'u as tinapay as whatug nan chugwangkasut gway dinario as ipa'anmi an chicha?” ");
INSERT INTO kyb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kun anan Hesus an chicha, “Aman nan tinapay gway agwad an cha'aju? I'aju ilan.” Inilacha kun anancha, “Agwad nan lima tinapay ja chugwa i'an.” ");
INSERT INTO kyb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sachi kun pinuyung Hesus chicha ta manto'to'noncha chachay taku patu'chugwon san man'ayayawhaay ap'api'ap. ");
INSERT INTO kyb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kun nato'oto'on chanan taku gway tummu'chu gway agwad nan singkakasut, agwad ahos nan sillimmampuyu. ");
INSERT INTO kyb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inayan kun Hesus nan limaay tinapay ja chugwaay i'an gwot nantangad ad langit nanjaman an Apudyus. Pini'pi''ina kunan tinapay impaigwatgwatna sasan pasuyutna. Kun pinispisngitna hos chay chugwa i'an kun impa'anna sasay taku. ");
INSERT INTO kyb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kun nangancha losanot nabsugcha. ");
INSERT INTO kyb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kun chinakupcha nan nasergwa san napi'pi''iyay tinapay ja napispisngitay i'an kun napnu nan nasagwayan as chugwaay langngay. ");
INSERT INTO kyb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ad sa'ad nan whilang chanan lallaya'i gway nangan limallihu. ");
INSERT INTO kyb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nappung kunan sachi nama'anan Hesus sasay taku nanipooyna sasan apostolesna san whang'a ta umunacha chumormang san whaywhay gway umoy ad Betsaida. Anna kunay umoycha pinerjaw Hesus chachay taku. ");
INSERT INTO kyb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sachi kun nanakacha as Hesus san whilig gway umoy mallugwayu. ");
INSERT INTO kyb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lummawhi kun nangkinagwa nan whang'a san whaywhay ad osossa''an as Hesus san whilig. ");
INSERT INTO kyb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kun chimmangnaay mampasikab chanan apostolesnaay mangichormang san whang'acha tan amod nan pigsan nan tungnin gway mijahot an chicha. Awni kunot machani nanadchayan as Hesus san lawhaw nan chanum gway ummoy an chicha. Lausana otjan chicha ");
INSERT INTO kyb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","gwon inilacha kus sijaay manadchadchayan san lawhaw nan chanum anancha kunnu ayan kun nampa'uycha ");
INSERT INTO kyb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tan losancha inila as sija kun ummogjatcha. Gwon nakaninga as Hesus gway manggwana, “Sa'on na achi aju umogjat. Papigsaonju somsomo'ju.” ");
INSERT INTO kyb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kun ummoy as Hesus an chicha san whang'a kun kummino' nan tungnin. Kun nataagcha losan as amod ");
INSERT INTO kyb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tan ta'on nu inilachas sijaay nangipaachu san tinapay chaancha pay maagwatan nan ayobhongana tan chaan ku miigkat nan somsomo'cha. ");
INSERT INTO kyb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chummormangcha kun san whaywhay hummu'nagcha ad Genesaret kun inta'odcha nan whang'acha. ");
INSERT INTO kyb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nilumsacha kun nanijimatun chanan taku an Hesus ");
INSERT INTO kyb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kun asitotodcha' chanan takuway ummoy nangipachamag san awhijawhija' gway hummu'nag as Hesus. Kun iyoycha chanan nasa'it gway naohoohog san nanamakancha san agwachan Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sija nan uyay ngachammanay ili gway umajan Hesus iyoy chanan taku nan losanay nasa'it. Kun nampa'pa''aasi chanan taku an sijaay uyay ognancha otjan ekay nan pagpag nan lagkoyloy gway silupna. Ad sa'ad nan losanay nangognan san pagpag nan silupna hummayucha. ");
INSERT INTO kyb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Osa kunay erkaw sa'ad chanan Pariseo naayuscha san agwachan Hesus ad iningkaw ahos chachay uchumay mangaagkammu san lintog gway nerpu ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inilachaay sa'ad chanan uchumay pasuyut Hesus achicha kun inggwa nan ukalichaay manghuyucha ad asichaot mangan. ");
INSERT INTO kyb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tan sa'ad chanan Pariseo ja chanan losanay asingHudyucha achicha kun mangan nu achicha jan oon nan inghuhhuyucha gway sija nan anan nan ukalicha gway insuyun chanan chacha''orcha san agwi. ");
INSERT INTO kyb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ad sa'ad nu merpucha san merket achicha jan mangan nu achicha oon nan ukalicha gway papor'asoncha nan longagcha. Angsan ahos nan uchumay ukali gway o'ooncha gway uyasancha chanan langkaw, whanga ja anchilu.) ");
INSERT INTO kyb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Gwot inimus chanan Pariseo ancha mangaagkammu san lintog an Hesus gway manggwana, “Kamma chanan pasuyutnu achi oon nan ukalin chanan chacha''or ta'u san agwi gway manghuyu asichaot mangan?” ");
INSERT INTO kyb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kun sinungwhatan Hesus chicha gway manggwana, “Ustu nan nangijununnaan Isaias san nangiwhagana san mipangkop an cha'aju gway an'annanju mampawhayu. Illistana gway anan Apudyus, ‘Sa'ad nannachaja taku chajagwona' san tupo'cha gwon achaju nan somsomo'cha an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maid kun silwhin nan manaychajagwancha an sa'on, isussuyucha nan lintog gway inggwan chanan taku ad ingwhilangcha as lintog Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kun ingwhakan Hesus an chicha gway manggwana, “Sa'ad as cha'aju iwwalinju kunan lintog Apudyus sija patkonju nan ukalin chanan taku!” ");
INSERT INTO kyb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kun anana hos an chicha, “Nalaing aju tuwa gway mangigwalin san whilin Apudyus ta sija oognanju nan ukaliju! ");
INSERT INTO kyb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tan anan nan lintog Apudyus gway insuyun Moses, ‘Chumngor'a an cha amam an inam’ ja ‘Sa'ad nu ngachan nan manapapat as lagwing san amana ja inana lobhongna mapatoy.’ ");
INSERT INTO kyb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gwon sa'ad nan isuyuju san taku iwhakajuway nu agwad iwhachangju san amaju ja inaju iwhakaju an chichaay annaja nan iwhachang'u jon Korban (nan pijaona anan, man'ugwan Apudyus). ");
INSERT INTO kyb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nu chachi nan iwhakan nan osa taku san amana ja inana impaijakayyu an sija gway mamachang an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sija nan inggwaju ekay as maid kun kutu' nan ukud Apudyus kapu san ukali gway impatagwidju sasan taku. Ad angsan ahos nan o'oonju gway a'ammaschi.” ");
INSERT INTO kyb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Inajakan kuhos Hesus chanan taku anana an chicha, “Chongyona' an cha'aju losan tot maagwatanju nannaja iwhaka'! ");
INSERT INTO kyb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wha'on kusan lumno' san tupo' nan manimo' san taku gwon sija manimo' nan merpu san somsomo'na.” ");
INSERT INTO kyb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Anna kunay chingngorju nan ingwhaka', ammanju somsom'on. ");
INSERT INTO kyb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sa'ad san nilumno'an Hesus san hoyoy gway maid kun nihuyog as taku an sija inimus chachay pasuyutna nan pijaon nan agwatna anan. ");
INSERT INTO kyb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kun anan Hesus an chicha, “Jo'o sissija ahosay achiju ekay maagwatan. Akammuju kajay wha'on kusan lumno' san taku nan machim'ana ");
INSERT INTO kyb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tan wha'on kus mangoy san somsomo'na jon mangoy san hota' ad awni ad nijattay.” (Sa'ad nan nangiwhagan Hesus sina iyujana gway losanay ma'an mawhalinay anon.) ");
INSERT INTO kyb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kun intuyuyna gway manggwana, “Nan merpu san somsomo' nan taku sijachi nan mangipergwing an sija. ");
INSERT INTO kyb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tan sa'ad nan somsomo' nan taku sachi nan merpugwan nan lagwing. Sija nan agwad chanan manggwas whayangna awhawhain ja ina'aisaw gway pijaon nan longag, agwad chanan mana'aw, agwad chanan pumatoy. ");
INSERT INTO kyb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Agwad chanan ma'assuy san wha'on kus asagwacha, agwad chanan mangkamkam ja agwad nan uchum gway lagwing nan oona, agwad nan uchum gway lumigwan san huyunna ja agwad nan uchum gway maid kun whainna gway manggwas whayangna. Agwad ahos nan uchumay maapos. Agwad nan uchum gway mangana'anan san huyunna, agwad ahos nan uchum gway mamangpangas ja agwad nan nayu'u gway whayangna ekay nan lagwingay oona. ");
INSERT INTO kyb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Losan nan a'ammasna gway lagwing merpu san somsomo' nan taku. Annachaja nan mangipergwing san taku an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lummajaw kus Hesus san sachi ili ummoy sasan ili gway sa'upon nan Tiro ja Sidon. Nanchagwos kusan osa hoyoy lagwingona otjan gway maakammugwan nan taku nan agwachana gwon naakammugwan chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Iningkaw nan osa huwhai gway nilno' nan chimunju nan ana'naay huwhai. Chingngorna kunan mipangkop an Hesus naanooy san agwachana kun nampalintumong san sanguna. ");
INSERT INTO kyb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kun nampa'pa''aasi gway perjagwon otjan Hesus nan chimunju gway nilumno' say ana'na. Sa'ad nan annaja gway osa huwhai nijana' ad Fenicia san osa ili san Siria gway Griego nan kingana. ");
INSERT INTO kyb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kun iyagwat Hesus an sija gway manggwana, “Maserpu gway pa'anan jan gway umuna nan anana' tan wha'on kus mawhalinay ipa'anta nan anon nan ana' sasan asu.” ");
INSERT INTO kyb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Anan chay huwhai, “Tuttuwa nan sanat gway anam Apu gwon sa'ad chanan asu gway iingkaw san agwachan nan mamangnganan anoncha hos chanan hugtan nan anana'.” ");
INSERT INTO kyb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kun anan Hesus an sija, “Kapu san sanat gway ingwhakam mawhalin'a gway lumajaw. Aysan nan chimunju san ana'nu!” ");
INSERT INTO kyb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lummajaw kun chay huwhai ad ugwacha inchasana nan ana'naay inuumhog kun inakammunaay lummajaw nan chimunju an sija. ");
INSERT INTO kyb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lummajaw ku cha Hesus ad Tiro nangoycha ad Sidon gwot nalli'gwos san ailiiliyay Decapolis ingkana as hummu'nagcha san whaywhay ad Galili. ");
INSERT INTO kyb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kun inghu'nag chanan taku an sija nan osa laya'i gway natuyong ja nakigki. Kun nampa'pa''aasicha an Hesus tot ognanas sija ta humayu. ");
INSERT INTO kyb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inta'iyan kun Hesus chay laya'i san amod gway taku iyuchu'na nan kammatna san ingan chay laya'i gwot tummubwha kun inognana nan chilan chay laya'i. ");
INSERT INTO kyb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nantangad kus Hesus ad langit nangngosja gwot anana say laya'i, “Efata!” (Nan pijaona anan nan sachi “Miibwhat'a!”.) ");
INSERT INTO kyb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kun nagwanasgwas nan chongorn chay laya'i gway natuyong. Kun na'aan nan kigkina gwot hummayu nan kingana. ");
INSERT INTO kyb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kun pinuyung Hesus chachay taku ta achicha iwhagwhaka san whayangna taku chay na'gwa. Gwon ta'on nu pinuyupuyungna chichaay achicha iwhagwhaka amamochot gway in'erngagcha nan chamag gway mataakan gway inggwana. ");
INSERT INTO kyb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kun nataag as amod chanan taku gway nangngor san annaja chamag gway asi'a'anancha, “Ka whayu eka losan nan o'oona! Padngoyona chanan natuyong ja pakingaona chanan achi ma'akinga.” ");
INSERT INTO kyb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","San sachi chimpu san naayusan ahos nan angsanay taku an Hesus gwot kapu san maid ku anoncha, inajakan Hesus chanan pasuyutna kun anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Machakuwa' san annachajaay taku tan tuyu erkaw gway iniingkawcha an sa'on gway maid kun ekay anoncha. ");
INSERT INTO kyb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ad sa'ad nu perjagwo' chichaay nawhiwhittil tugwakay maagcha ekay matugwad san chayan tan achaju nan nerpugwan chanan uchum.” ");
INSERT INTO kyb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kun inimus chanan pasuyutna an sija gway manggwana, “Agwamma inta'u mangallan as loog mipa'an san amasnaay aachun nan taku san tummatalin nannaja ili?” ");
INSERT INTO kyb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kun inimusna an chicha gway manggwana, “Aman nan tinapay gway agwad an cha'aju?” “Pitu” ananchaay summungwhat. ");
INSERT INTO kyb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kun impatu'chun Hesus chanan taku san luta. Inayana ku chachay pituway tinapay gwot nanjaman an Apudyus pini'pi''ina. Kun asinaot atchon sasan pasuyutna ta igwatgwatcha sasan taku kun inggwacha. ");
INSERT INTO kyb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Agwad ahos nan a''itan gway i'an gway whana'iyut. Nanjaman kus Hesus an Apudyus san annachaja asinaot ahos ipaigwatgwat sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kun nangancha losanot nabsugcha. Nappungcha kun, chinakup chanan pasuyut nan nasergwa sasan napi'pi''i kun napnu nan pitu langngay. ");
INSERT INTO kyb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sa'ad nan whilang chanan taku gway nangan ummoy as opat lihu. Kun pinerjawna chicha. ");
INSERT INTO kyb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Naanooy ku namang'a as Hesus ja chachay pasuyutna ummoycha san ili gway sa'upon nan Dalmanuta. ");
INSERT INTO kyb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sa'ad san namingsanay erkaw ummoy chanan uchumay Pariseo an Hesus kun illukichaay isi'on as sija. Whayugwonchaay padpadchason as sija gway mampa'gwaonchas sija san imatunay mataakan as mamatiyancha nu tuttuwaay Apudyus nan nangiwhaun an sija. ");
INSERT INTO kyb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nangngosja kus amod as Hesus anana, “Kama nannaja lunap san sana mampa'gwa an sa'on as mataakanay mangimatunan. Iwhaka' an cha'aju nan tuttuwa gway maid kun osas mataakanay mangimatunan as ipaila' sannaja lunap san sana!” ");
INSERT INTO kyb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tinaynana ku chachay Pariseo gwot asin namang'a chummormangcha. ");
INSERT INTO kyb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sa'ad chanan pasuyut Hesus naligwatanchaay nansongot as tinapay kun ahus nan osa as agwad an chicha san whang'a. ");
INSERT INTO kyb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kun pinuyung Hesus chichaay manggwana, “Ammanju ilan nan yeast chanan Pariseo ja yeast Ali Herod.” ");
INSERT INTO kyb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kun asijaapatcha gway manggwana, “Amaschi nan ingwhakana tan maid kun tinapay ta'u.” ");
INSERT INTO kyb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Inakammun kun Hesus nan apaapatoncha anana an chicha, “Kajuman sija apaapaton nan inamaid nan tinapayyu. Achiju nina ekay akammu gwinnu maagwatan. Umman ekay imperno'ju san somsomo'ju. ");
INSERT INTO kyb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ka pajan ekay nangilanju ja nangngoyanju. Jo'o naligwatanju. ");
INSERT INTO kyb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tan sa'ad ka san nami'pi''iya' san lima tinapay gway inan chachay lima lihu gway taku, amana langngay nan nahunan gway chinakupju?” Kun anancha an sija, “Nasagwayan as chugwa.” ");
INSERT INTO kyb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sa'ad ahos san nami'pi''iya' san pitu tinapay gway inan nan opat lihu gway taku, amanaay langngay nan nasergwaay chinakupju?” Kun ananchaay summungwhat, “Pitu.” ");
INSERT INTO kyb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kun anan Hesus an chicha, “Ka chaanju ekay maagwatan ingkana san sana.” ");
INSERT INTO kyb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hummu'nag cha Hesus ad Betsaida kun iyoy chanan uchum gway taku nan osa na'uyap gway laya'i san agwachan Hesus. Kun nampa'pa''aasicha an sija ta ognana nan laya'i. ");
INSERT INTO kyb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Inigwid kun Hesus nan na'uyap ummoyna inta'iyan san achaju san ili. Tinubwhaana kunan atanaot ognana as sija inimusna gway manggwana, “Agwad ilam?” ");
INSERT INTO kyb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nantollong kun anana, “Oon. Maila' chanan taku gwon amacha as aju gway manadchadchayan.” ");
INSERT INTO kyb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inognan kun Hesus asin nan atan chay laya'i gwot nanchiyat na'aa'aan nan uyapna kun hummayu nan mantollongana. ");
INSERT INTO kyb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa'ad san mamerjagwan Hesus an sija san hoyoycha pinuyungna gway manggwana, “Achi'a manulin san anchiya ili.” ");
INSERT INTO kyb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kun ummoy cha Hesus ja chanan pasuyutna san ailiili san Cesarea Filipos. Ingkawcha ad san chayan inimusna an chicha gway manggwana, “Ngachan nan anan chanan taku san mipangkop an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kun summungwhatchaay manggwana, “Anan nan uchum si'a as Juan gway Manghohonjag. Anan nan uchum si'a as Elias. Anan ahos nan uchum osa'a sasan profeta san agwi.” ");
INSERT INTO kyb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kun inimusna an chicha gway manggwana, “As cha'aju kay ngachan nan mangngachanju an sa'on?” Kun summungwhat as Pedro gway manggwana, “Si'a nan Kristu.” ");
INSERT INTO kyb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sachi kun pinuyung Hesus chichaay achicha iwhaka nannaja san uchum. ");
INSERT INTO kyb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kun illukin Hesus gway mangiwhaka sasan pasuyutna san ma'gwa an sija gway anana, “Maserpu gway sa'ad as sa'onay Ana' nan Taku mapalikatana' as amod ja maid kun manggwaan chanan chacha''orn nan Hudyu an sa'on ja papangat nan papachi ancha chanan mangaagkammu san lintog. Ipaotoycha as sa'on gwon matakuwa' nu mappung nan tuyu erkaw.” ");
INSERT INTO kyb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nayagwag nan nangiwhagan Hesus an chicha. Inta'iyan kun Pedro as Hesus ingwhakana an sijaay achina amonsichiyay manapapat. ");
INSERT INTO kyb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nansakung kus Hesus sasay pasuyutna gwot intollongna chicha inamujuwana as Pedro gway manggwana, “Umachaju'a an sa'on Satanas! Nan somsomo'nu wha'on kus somsomo' Apudyus, somsomo' chanan taku.” ");
INSERT INTO kyb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Inajakan kun Hesus nan angsanay taku ja chanan pasuyutna anana an chicha, “Nu ngachan nan mamayu mitunud an sa'on maserpu achina sija sosom'on nan longagna, isimo'naay mamati ta'on nu sija nan iliglikatna ja i'atoyna ad nitunud an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nu ngachan nan ahus nan whijagnas patpatkona achi kun ma'awhijag an Apudyus as ingkaingkana. Gwon nu ngachan nan achi mangipatog san whijagna kapu an sa'on ja kapu san Whayuway Chamag, ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maid kun kutu' nan man'ugwan nan osa taku nan losanay agwad san luhung nu achi ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maid kun mawhalin nan osa taku atchon an Apudyus as iwhajadna tot ma'awhijag an sija as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ad sa'ad ahos nu ngachan nan mangiwhain an sa'on ja san ukud'u san annachaja taku san sana gway mijisu san huwhai whinerjan gway mallaya'i tan wha'on kus napudnu an Apudyus ja humersuwhersu, sa'ad as sa'onay Ana' nan Taku iwhain'u hos as sija san managkulina' ad asna luta gway anna an sa'on nan ayobhongan Ama gway huyun'u chanan a'anghelna.” ");
INSERT INTO kyb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Anan ahos Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway anna nan uchum an cha'aju san annaja gway achi kun matoy ingkanas ilancha as Apudyus gway umali mantuyay gway anna nan ayobhongana.” ");
INSERT INTO kyb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lummaus ad nan onom gway erkaw inghuyog Hesus as Pedro ja cha Santiago an Juan kun iyoyna chicha san nata'nang gway whilig gway ahuscha ekay. Gwot nanohos nan ilan Hesus san sakkangcha. ");
INSERT INTO kyb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ad sa'ad nan silupna sumiling gway putputtaa' gway maid kun osas taku san luta as ma'iipaputa' as isun nan inaputa'na. ");
INSERT INTO kyb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Awni kun nampaila an chicha as Elias gway huyunna as Moses gway ma'aapaapatcha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kun summayampitaw as Pedro gway manggwana an Hesus, “Apu, whayu nan annaan ta'ud asna! Manggwa amis tuyu sikay as manghubhugwa''anju ancha Moses an Elias.” ");
INSERT INTO kyb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Amasna nan ingwhakan Pedro tan maid kun akammuna nu ngachan nan iwhakana tan umogjatcha as amod. ");
INSERT INTO kyb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kun inichungan nan hunot chicha kun iningkaw nan kingaay nerpu san hunot gway manggwana, “Annaja nan ana''uway patpatko'. Chumngor aju an sija.” ");
INSERT INTO kyb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nallangyangacha kun maag ekay maid chachay chugwa, ahus as Hesus as inilacha. ");
INSERT INTO kyb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ad sa'ad san manoskancha san whilig pinuyung Hesus chicha gway manggwana, “Ilanju ta agwad mangiwhaganju sannaja inilaju ingkanas sa'ad as sa'on gway Ana' nan Taku matakuwa' san matoja'.” ");
INSERT INTO kyb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kun tinuttuwacha nan impuyungna gwot nanisijimuscha nu ngachan nan pijaona anan nan mataku as sija san matojana. ");
INSERT INTO kyb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kun inimuscha an sija gway manggwana, “Kamma chanan mangaagkammu san lintog ananon maserpu managkulin jan as Elias ad asiyot umali nan Kristu?” ");
INSERT INTO kyb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kun summungwhat gway manggwana, “Tuttuwa kajay umuna managkulin as Elias ta isakanana nan losan. Gwon somsom'onju hosay nilista san Ukud Apudyus gway sa'ad as sa'onay Ana' nan Taku mapalikatana' as amod ad maamsigwa' ahos. ");
INSERT INTO kyb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Iwhaka' ahos an cha'aju gway naahus umali nan isun Elias. Kun inggwan chanan taku nan whayugwonchaay oon an sija gway sachi nan nilista mipangkop an sija.” ");
INSERT INTO kyb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa'ad san manulinan cha Hesus san agwachan chanan uchumay pasuyutna inilacha nan angsanay taku gway naayus say agwachan chachay pasuyutna. Iningkaw ahos chanan uchum gway mangaagkammu san lintog gway ma'aisiisi' an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sachi kunay inilan chanan taku as Hesus gway mayungay nataagcha as amod kun nanodcha'cha gway ummoy nangahot an sija gwot kiningaancha. ");
INSERT INTO kyb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kun anan Hesus gway nanimus an chicha, “Ngachan nan ukuchonju an chicha?” ");
INSERT INTO kyb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kun summungwhat nan osa taku san sachi amung gway manggwana, “Mistuyu, iyali' nan ana''uway laya'i an si'a tan nilumno' nan chimunju an sija kun achina kun pakingaon. ");
INSERT INTO kyb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu ano''on nan chimunju as sija isogta'nas sija. Ad nanerter'uta' nan tupo'na ja nangngilngiltona hos nan whawhana ad nangontog nan longagna. Ingwhaka' sasan pasuyutnu gway perjagwoncha nan chimunju gwon achicha kun ma'a'gwa.” ");
INSERT INTO kyb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kun anan Hesus an chicha, “Ina'ay aju mahosay takuwanna gway maid kun pammatina! Anaman ekay awhajag nan iingkagwa' an cha'aju ja mangaannusa' an cha'aju! Ijaliju an sa'on nan annatcha ana'.” ");
INSERT INTO kyb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kun iyoycha chay ana' an sija. Anchiya kunay inilan chay chimunju as Hesus maagna ekay nangajas'ason chay ana'. Nisogta' kun nangwhalliwhallin gway manerter'uta' nan tupo'na. ");
INSERT INTO kyb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kun anan Hesus san aman chay ana', “Ma'anu nan nallukijan nan amasnaay ma'ma'gwa an sija?” Kun anan chay ama summungwhat, “Nalluki san awhanogna. ");
INSERT INTO kyb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nadnachiyay itopern nan chimunju as sija san apuy ja chanum ta sachi nan mangtoyna. Gwon nu agwad ma'gwam achakugwam cha'ami ta whachangan cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kun anan Hesus an sija, “Kamma ananon, ‘Nu agwad ma'gwam?’ Maid kun achi ma'gwa san anna nan pammatina.” ");
INSERT INTO kyb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kun nanipo'aw chay aman nan ana' gway manggwana, “Tuttugwao', whachangana' san pammati'.” ");
INSERT INTO kyb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Inilan kun Hesus nan angsanay takuway asichuchu'yus gway umachayug an chicha inamujuwana chay chimunju gway manggwana, “Si'aay chimunju gway nanuyong ja nangsut san kingan nannaja ana' iwhaka' an si'a gway lumajaw'a ad achim agkuagkulinon as sija.” ");
INSERT INTO kyb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nampa'uy ku chay chimunju gwot nangajas'asona chay ana' asiyot lumajaw. Amas natoy chay ana' kun aachugwan nan manggwanaon, “Natoy!” ");
INSERT INTO kyb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jon inognan kun Hesus nan iman chay ana' impasi'adna. Gwot hummangon chay ana'. ");
INSERT INTO kyb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nilumno' kus Hesus san osa hoyoy inimus chachay pasuyutna san ummahusancha gway manggwana, “Ka'ami man achi ma'aperjaw san sachi chimunju?” ");
INSERT INTO kyb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kun anan Hesus gway summungwhat, “Ahus nan lugwayu as mamerjaw san amaschi gway ayasin nan chimunju ad maid kun uchum.” ");
INSERT INTO kyb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lummajaw ku cha Hesus san sachi ili nangoycha ad Galili. Ad lagwingon Hesus gway agwad mangakammu san agwachana ");
INSERT INTO kyb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tan iwhakawhakana sasan pasuyutna nan amasna, “Sa'ad as sa'onay Ana' nan Taku ipawhijanga' sasan taku ad intoycha as sa'on ad mappung ad nan tuyu erkaw matakuwa'.” ");
INSERT INTO kyb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gwon achin ku chanan pasuyutna naagwatan nan pijaon nina anan kun ummogjatchaay manimus an sija. ");
INSERT INTO kyb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hummu'nag cha Hesus ad Capernaum gwot nilumno'cha kusan hoyoy nanimus as Hesus an chichaay manggwana, “Ngachan nan nanuukuchanju san chayan?” ");
INSERT INTO kyb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gwon nakinokino'cha tan nanuukudcha san chayan nu ngachan nan angatuwan an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tummu'chu kus Hesus inajakana chanan nasagwayan as chugwaay apostolesna kun anana an chicha, “Nu ngachan nan mamayu gway mangngachan angatuwan maserpuway mangngachan awhawhaan ad nansilwhi san losan.” ");
INSERT INTO kyb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Inayana kunan osa ana' impasi'adna san agwachancha. Ina'lina kun anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sa'ad nan taku gway mangajag san amasna ana' kapu an sa'on, sa'on nan inajakana. Ad sa'ad nan mangajag an sa'on wha'on kus ahusa' as inajakana gwon inajakana hos nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kun anan Juan an Hesus, “Mistuyu, inilami nan osa taku gway mamerjaw sasan chimunju gway inuserna nan ngachannu kun iyachimi tan wha'on kus pasuyutnu.” ");
INSERT INTO kyb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Gwon anan Hesus an chicha, “Achiju ijachi tan maid kun manggwa san mataakan as manguser san ngachan'u ad awni ad nanapapat ahos as lagwing mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tan sinusnatay achi mallagwing an chita'u huyun ta'u. ");
INSERT INTO kyb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iwhaka' an cha'aju nan tuttuwa gway sa'ad chanan takuway mampainum an cha'aju as sintasaay chanum kapu san takun Kristu cha'aju, maorsan ekajay maorsan. ");
INSERT INTO kyb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nu ngachan nan manggwa as ma'awhasuyan nan mernus nan pammatina an sa'on gway isun nan annachaja anana', unayna ekay mita'od nan cha'or kikillinganay whatu san whakangna ad nitubung san whaywhay. ");
INSERT INTO kyb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ad sa'ad nu imam nan kapun nan ma'awhasuyam kumpuyam. Unayna ekay kumpur'a gway mawhijag as ingkaingkana ad langit nu nan gwachagwad nan chugwa imam gway i'a ad ingwhilnu gway agwachan nan apuy gway achi kun mapatajan. ");
INSERT INTO kyb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Sa'ad ad aschi achi kun matoy nan okos gway agwad an chicha ja achi kun mapatajan nan apuy. ");
INSERT INTO kyb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ad sa'ad nu i'im nan kapun nan ma'awhasuyam kumpuyam. Unayna ekay kumpur'a gway mawhijag as ingkaingkana ad langit nu nan mitoper'a ad ingwhilnu gway gwachagwad nan i'im. ");
INSERT INTO kyb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Sa'ad ad aschi achi kun matoy nan okos gway agwad an chicha ja achi kun mapatajan nan apuy. ");
INSERT INTO kyb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ad sa'ad nu atam nan kapun nan ma'awhasuyam u'atom. Unayna ekay piso''a gway ingkaw san Mantuyajan Apudyus nu nan mitoper'a ad ingwhilnu gway gwachagwad nan chugwa atam. ");
INSERT INTO kyb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sa'ad ad aschi achi kun matoy nan okos gway agwad an chicha ja achi kun mapatajan nan apuy. ");
INSERT INTO kyb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tan losanay taku mapachas san liglikat tot nachayuscha san mangilan Apudyus isun nan chatun gway mapuuyan gway maasinan ad nachayus san mangilan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sa'ad nan asin whayu gwon nu ma'aan nan tamtamna, ininonju manay mangisubli? Maserpu ama aju otjan as asin gway agwad nan misilwhiyanju ja manosossaan aju.” ");
INSERT INTO kyb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Lummajaw kus Hesus san sachi ili ummoy san lutan nan Judea kun nilausana nan gwanggwangay Jordan. Kun naayus ahos nan angsanay taku an sija gwot sinuyuwana chicha as isun chay inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ummoy kunan uchum gway Pariseo an sija gway mamadpadchas, nanimuscha an sija gway manggwana, “Iwhakamud nu mijuja san lintog ta'u nan ichangan nan laya'i nan asagwana?” ");
INSERT INTO kyb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kun sinungwhatan Hesus chicha gway manggwana, “Ngachan nan ingwhilin Moses an cha'aju?” ");
INSERT INTO kyb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kun ananchaay summungwhat, “Iyujan Moses gway ipapil nan laya'i nan mangichangana san asagwana.” ");
INSERT INTO kyb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kun anan Hesus an chicha, “Amaschi nan illistan Moses gway lintog an cha'aju kapu tan hummatu nan somsomo'ju. ");
INSERT INTO kyb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gwon sa'ad san chamun nan nanggwaan Apudyus san luhung, ‘Inggwan Apudyus nan taku as laya'i ja huwhai.’ ");
INSERT INTO kyb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Sija nan kapu sannaja taynan nan laya'i cha amana an inana ad nan'atumcha san asagwana ");
INSERT INTO kyb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ad sa'ad chay manasagwa nangngachancha osa.’ Ad wha'oncha kus chugwa gwon nangngachancha osossa''an. ");
INSERT INTO kyb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sija nan nu ngachan nan nan'atumon Apudyus wha'on kus mawhalinay manichangon nan taku.” ");
INSERT INTO kyb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nanulincha kun san hoyoy inimus chanan pasuyut asin nan mipangkop san ichang. ");
INSERT INTO kyb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kun anan Hesus an chicha, “Nu ngachan nan laya'i gway mangichang san asagwana ja mangasagwa san uchum, ma'awhersu san ummuna asagwana ad niwhilangay namuwhai as sija. ");
INSERT INTO kyb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ad isun ahos nan huwhai gway sa'ad nu ma'aichang san asagwana ja nangasagwa san sawhali, miwhilangay nallaya'i as sija.” ");
INSERT INTO kyb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iningkaw nan uchum gway taku gway nangijoy san anana' an Hesus ta ipatayna nan imana an chicha gwon chinogjajan chanan pasuyut chicha. ");
INSERT INTO kyb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gwon inilan kun Hesus nan inggwan chanan pasuyutna nilingugwana chicha kun anana an chicha, “Ijujaju nan anana' gway umali an sa'on. Achiju ijachi chicha tan nan isun nan a'ammasna anana' mitapicha sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iwhaka' an cha'aju nan tuttuwa, nu ngachan nan achi mamati san Mantuyajan Apudyus as isun nan mamatiyan nan osa ana' achi kun mitapi sasan takuway ituyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Whinajaw kun Hesus nan anana' impatayna nan imana an chicha kun ingwhakana an chichaay pawhayugwon Apudyus nan whijagcha. ");
INSERT INTO kyb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Anna kunay malliggwat as Hesus gway lumajaw iningkaw nan osa laya'i gway nanodcha' gway ummoy an sija. Gwot nampalintumong kun san sangun Hesus nanimus gway manggwana, “Whayuway Mistuyu, ngachan nan oo' ta ma'awhijaka' an Apudyus as ingkaingkana?” ");
INSERT INTO kyb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kun anan Hesus an sija, “Kamman mangngagnon as sa'on whayu? Maid kun uchum as whayu nu achi ahus as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Akammum chanan whilin Apudyus: Achi'a pumatoy. Achi'a ma'assuy san wha'on kus asagwam. Achi'a mana'aw. Achim ta'choyan nan tuli gway mihursu san osa taku. Achi'a mansi'ap. Chumngor'a an cha amam an inam.” ");
INSERT INTO kyb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kun anan chay laya'i, “Mistuyu, nalluki san awhanog'u inggwa'inggwa' losan chanat.” ");
INSERT INTO kyb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Intollong kun Hesus as sija nerjad an sija kun anana, “Anna nan osa uyangnu. I'a ila'u nan losan gway u'ugwam ad inatodnu nan la'una san whawha'sigwot ad agwad nan whina'nangnu ad langit. Ad ummali'a nitunud an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sa'ad san sachi nangiwhagan Hesus nangnguspoy kun lummajaw gway mansasanga tan amod nan whina'nangna. ");
INSERT INTO kyb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nallangyanga kus Hesus anana sasan pasuyutna, “Sa'ad nan takuway sija ekay ipatogna nan inawha'nang, mansikab as mitapi sasan takuway ituyajan Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kun nataag chanan pasuyutna san nangngoyancha san sachi ingwhakana gwon inasin Hesus anan an chicha, “Anana', mansikab nan mitapijan sasan takuway ituyajan Apudyus! ");
INSERT INTO kyb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Amod mansikab nan mitapijan nan osa taku sasan takuway ituyajan Apudyus gway sija ekay ipatogna nan inawha'nang nu san lumno'an nan kamel san ahut nan chakum.” ");
INSERT INTO kyb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kun nataag as amod chanan pasuyutna kun asi'a'anancha, “Ad ngachan maangkay mataku nu'?” ");
INSERT INTO kyb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Intollong kun Hesus chicha anana, “Wha'on kus ma'a'gwa nan taku san annaja gwon ma'gwan Apudyus. Tan lobhong Apudyus gway manggwa san losan.” ");
INSERT INTO kyb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kun kumminga as Pedro gway manggwana, “As cha'ami kay, tinaynanmi nan losanay u'ugwami kun nitunud ami an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kun anan Hesus an chicha, “Iwhaka' an cha'aju nan tuttuwa gway nu ngachan nan manaynan san hoyoyna, susunudna, inana, amana, anana'na ja lutana kapu an sa'on ja kapu san Whayuway Chamag ");
INSERT INTO kyb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","maatod ekajay maatod an sija nan amamod angsan gway hoyoy, susunud, ina ja ama, anana' ja luta nu sasay tinaynana gwon mapalikatan ahos as sija san matattakuwana ad awni ad na'awhijag an Apudyus as ingkaingkana san umaliyay whijag. ");
INSERT INTO kyb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gwon angsan chanan ummuna gway mangudchi ad angsan ahos chanan mangudchiyay umuna.” ");
INSERT INTO kyb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa'ad san manadchadchayanan cha Hesus san ersa gway umoy manakacha ad Jerusalem, namangpangu as Hesus san pasuyutnaay manadchadchayan kun nataag chachay pasuyutna ad sa'ad chachay misu'su'nub an Hesus ummogjatcha. Intalin kuhos Hesus nan nasagwayan as chugwaay pasuyutna illukina iwhaka nan ma'gwa an sija ");
INSERT INTO kyb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","gway manggwana, “Chongyonju na, anna inta'ud Jerusalem ad sa'ad as sa'onay Ana' nan Taku mipawhijanga' sasan papangat nan papachi ja chanan mangaagkammu san lintog. Ad nilodchongana' gway matoy ad impawhijanga' sasan wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ad inamamanga' an chicha ja tubwhatubwhaana' ancha saplisaplitana' an chicha ad intoja' ad mappung ad nan tuyu erkaw natakuwa'.” ");
INSERT INTO kyb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kun ummachayug an Hesus cha Santiago an Juan gway ana' Zebedeo kun anancha an sija, “Mistuyu, oomud nu ngachan nan pa'gwami an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kun anan Hesus an chicha, “Ngachan nan whayugwonju gway oo' an cha'aju?” ");
INSERT INTO kyb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kun anancha an sija, “Patu'chugwom cha'ami san nachajaw gway mantuyajam gway sa'ad nan osa ingkaw san machigwanannu ja ingkaw ahos nan osa san machigwikim.” ");
INSERT INTO kyb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Gwon anan Hesus gway summungwhat, “Achiju kun akammu nan od'ochagwonju. Jo'o ja ma'iijattom aju san likat gway isun nan likat gway ma'gwa an sa'on gwinnu ma'aituyod aju gway matoy san isun nan i'aman'uway matoy.” ");
INSERT INTO kyb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kun anancha gway summungwhat, “Ma'aituyod ami.” Kun anan Hesus an chicha, “Tuttuwaay ma'iijattom aju san likat gway ma'gwa an sa'on ja ma'aituyod aju gway matoy san isun nan i'aman'uway matoy. ");
INSERT INTO kyb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gwon wha'on kun as sa'on nan mampili nu ngachan nan tumu'chu san machigwanan'u ja machigwiki' tan naahus nisakana chana san nisakanaana.” ");
INSERT INTO kyb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chingngorn kun chachay simpuyu pasuyut nan inchawcha nalingucha an Santiago ja Juan. ");
INSERT INTO kyb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Inajakan kun Hesus losan chicha anana an chicha, “Akammuju gway sa'ad chachay miwhilang otjan as mangituyay sasan wha'on kus Hudyu, amod nan mangilajusancha san ituyajancha ad sa'ad chanan pangatcha mansuwoncha chicha. ");
INSERT INTO kyb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gwon wha'on kus amasnat nan oonju. Nu ngachan nan mamayu an cha'aju gway mampangatu maserpu mansilwhi an cha'aju losan. ");
INSERT INTO kyb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ad nu ngachan nan mamayu gway mangngachan apatkan maserpu mampamudchachu an cha'aju losan. ");
INSERT INTO kyb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tan sa'ad ahos as sa'onay Ana' nan Taku wha'on kus ummaliya' ta mansilwhiyana' gwon ummaliya' ta mansilwhiya' ja atcho' nan whijag'u as oyos nan whijag nan aachugwanay taku ta magwajagwajaancha san ayobhongan nan whersu.” ");
INSERT INTO kyb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hummu'nag cha Hesus ja chanan pasuyutna ad Jerico. Ad sa'ad san lummajagwancha gway nihuyog chanan pasuyutna ja chanan angsanay taku, iningkaw as Bartimeo gway na'uyapay mampalpalimus gway ana' Timeo. Tummutu'chu as sija san ikid nan chayan. ");
INSERT INTO kyb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chingngorna kun gway as Hesus gway iNazaret chay lumaus illukina mampo'aw gway manggwana, “Hesus gway kana' Dabid achakugwana'ud!” ");
INSERT INTO kyb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Angsan nan taku gway nangijachi an sija kun ingwhakachaay kumino'. Gwon iyamamodnaot impa'uy gway manggwana, “Kana' Dabid, achakugwana'ud!” ");
INSERT INTO kyb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Summinong kus Hesus anana, “Ajakanju sannaja.” Kun inajakancha chay na'uyap gway manggwana, “Papigsaom nan somsomo'nu! Sumi'ad'a tan paajag cha'a.” ");
INSERT INTO kyb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Intoperna kunan akoynaot tummaud ummoy as sija an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kun inimus Hesus gway manggwana, “Ngachan nan whayugwom gway oo' an si'a?” Kun anan chay na'uyap, “Apu, aanomud nan uyap'u!” ");
INSERT INTO kyb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kun anan Hesus an sija, “Oon, kapu san pammatim hummayu'a. Mawhalin'aay lumajaw.” Kun napanadcha nan ilana gwot nitunud an Hesus san ersa. ");
INSERT INTO kyb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sa'ad san takangay cha Hesus chumakusan ad Jerusalem gwot hummu'nagchad Betfage ja Betania san whilig gway ma'gwaniyon Olibu, impaunan Hesus nan chugwa sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kun anana an chicha, “I'aju sanchi iliyay chomangonju. Ad humu'nag aju ad ekay agwad nan ochasanju niwhawhawwod gway uyhun nan asno gway chaan kun maawhajuwan. U'whachonju ad iyaliju sannaja. ");
INSERT INTO kyb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ad nu agwad manggwana an cha'ajuwon, ‘Kajuman u'whachon nan sanat?’ Ananjuwon, ‘Maserpun nan Apu ad asina paijaagkulin.’ ” ");
INSERT INTO kyb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gwot ummoycha kun inchasancha nan osaay uyhun nan asnoway iniingkaw san ersa gway niwhawhawwod san sagwang nan osa hoyoy. Anna kunay u'whachoncha nan uyhun ");
INSERT INTO kyb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","iningkaw chanan taku nasi'asi'ad gway manggwana, “Ngachan nan oonju annat? Kajuman u'whachon nan sanat gway uyhun?” ");
INSERT INTO kyb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kun ingwhakacha chay ingwhakan Hesus an chicha gwot iyujan chachay taku. ");
INSERT INTO kyb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kun iyoycha nan uyhun an Hesus. Kun inap'apancha nan ochog nan uyhun san silupcha kun nangawhajuwan Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kun angsan nan taku gway nangijap'ap san silupcha san chayan ad sa'ad nan uchum iyap'apcha hos san ersa nan pangaay mantutuhu gway inayacha san tayun. ");
INSERT INTO kyb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ad sa'ad chanan taku gway namangu ja nangudchi an Hesus asipopo'awchaay manggwana, “Hosanna! Piyan as sija gway umali san ayobhongan Apudyus! ");
INSERT INTO kyb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Piyan'a gway umali san mantuyajam gway isun nan nantuyajan Ali Dabid gway apu ta'u. Machaychajaw as Apudyus ad langit.” ");
INSERT INTO kyb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hummu'nag kus Hesus ad Jerusalem nilumno' as sija san sowhan nan Templo kun nilangyangana nan losanay agwad ad aschi. Gwon sa'ad tan mummaschom ummoy ad Betania gway huyunna chanan pasuyutna gway nasagwayan as chugwa. ");
INSERT INTO kyb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mawhikat kun san lummajagwancha ad Betania nawhitil as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chimmangna kunan ajuway igos gway angsan nan tuhuna ummoyna inila nu agwad hokasna. Gwon chummakus kus sija maid kun inilanas hokasna, ahus ekay tuhuna tan chaan kunan humkasana. ");
INSERT INTO kyb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kun anan Hesus say aju gway igos, “Malluki san sana maid kun mangmangan san hokasnu kapu tan achi'a kun puyus humkas!” Kun chingngorn chachay pasuyutna nan ingwhakana. ");
INSERT INTO kyb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hummu'nag cha Hesus ad Jerusalem gwot ummoy kus sija san sowhan nan Templo, pinerjawna nan malla'ya'u ja mallaya'u san sachi. Kun inaminna tugwachon nan lamisaan chanan manooyos san pila' ja tutu'chugwan chanan mangila'ya'u san kalapati. ");
INSERT INTO kyb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kun iyachina nan naododnanan gway mangoy san Templo. ");
INSERT INTO kyb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kun tinudtuchugwana chanan taku gway manggwana, “Nilista san Ukud Apudyus gway anana, ‘Sa'ad nan hoyoy'u luyuwwayuwan nan losanay taku gwon nangngachanonju tatalluwan chanan mamayangkat!’ ” ");
INSERT INTO kyb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chingngorn ku chanan papangat nan papachi ja mangaagkammu san lintog nan inggwan Hesus, illukichaay mananap as mangtojancha an sija tan ummogjatcha an sija tan nataag losan nan taku gway nangngor san insuyuna. ");
INSERT INTO kyb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mummaschom kun lummajaw cha Hesus san sachiyay ili. ");
INSERT INTO kyb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Whigwhikat kun sa'ad san manadchadchayanancha san chayan inilacha chay ajuway igos gway nayangu ingkana san lamutna. ");
INSERT INTO kyb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Simsimmo' kun Pedro chay ingwhakan Hesus san aju anana an Hesus, “Apu, ilam ad! Nayangu nannaja aju gway chay whinujunam!” ");
INSERT INTO kyb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kun summungwhat as Hesus gway manggwana, “Tuttugwaonju as Apudyus! ");
INSERT INTO kyb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iwhaka' an cha'aju nan tuttuwa, nu ngachan nan manggwana san annaja whilikon, ‘Mita'nang'a ta mitoper'a san whaywhay!’ gway achi kun manchugwachugwa gwon tuttugwaonaay ma'gwa nan ingwhakana, ma'gwa tuwa an sija. ");
INSERT INTO kyb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sija nan iwhaka' an cha'aju gway nu ngachan nan ochagwonju san lugwayu ja tuttugwaonjuway maayaju tuttuwaay maayaju. ");
INSERT INTO kyb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ad sa'ad nu mallugwayu aju umuna janay ligwatanju nan lagwingay inggwan nan uchum an cha'aju ta ligwatan ahos Amaju ad langit nan whersuju. ");
INSERT INTO kyb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tan sa'ad nu achiju ligwatan nan whersun nan osa taku an cha'aju achin ku Amajud langit ligwatan nan whersuju.” ");
INSERT INTO kyb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kun nanagkulin cha Hesus asin ad Jerusalem. Manadchadchayan kus Hesus san sowhan nan Templo ummoy an sija chanan papangat nan papachi ja mangaagkammu san lintog ja chanan chacha''orn chanan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kun inimuscha an sija gway manggwana, “Agwan nan nangallam san ayobhongam gway manggwa san o'oom? Ngachan nan nangatod san ayobhongam gway manggwa san o'oom?” ");
INSERT INTO kyb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kun summungwhat as Hesus gway manggwana, “Anna nan imuso' an cha'aju ad sa'ad nu masungwhatanju, iwhaka' ahos nu agwan nan nangalla' san ayobhonga' gway manggwa san o'oo'. ");
INSERT INTO kyb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iwhakajuud an sa'on nu ngachan nan nerpugwan nan ayobhongan Juan gway manghonjag? Nerpu an Apudyus gwinnu nerpu sasan taku?” ");
INSERT INTO kyb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kun nanuukuchanchaay manggwana, “Ngachan nan iwhaka ta'u? Sa'ad nu anan ta'uwon, ‘Nerpu an Apudyus,’ anana hos an chita'uwon, ‘Kajuman angkay achi tinuttuwa as Juan?’ ");
INSERT INTO kyb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ad iwhaka ta'u achay, ‘Nerpu sasan taku’ ja ngachamma ma'gwa an chita'u?” (Ummogjatcha sasan taku tan losancha tuttugwaon gway tuttuwaay profeta as Juan.) ");
INSERT INTO kyb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gwot sinungwhatancha as Hesus gway manggwana, “Maid kun akammumi.” Kun summungwhat as Hesus gway manggwana, “Sa'ad nu amasnat achi' kuhos iwhaka nu ngachan nan nerpugwan nan ayobhonga' gway manggwa san o'oo'.” ");
INSERT INTO kyb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Intuyuy Hesus iyagwat gway manggwana an chicha, “Iningkaw nan osa taku gway nammuya as angsanay ubas san lutana kun nili'gwosna a'upon. Kun nanggwas uussutan san ubas. Kun nampata'chor as nata'nang as allangan gway whinatu as ingkagwan nan mangijaachug. Kun impasamerna sasan mansasamer gwot nangwhaat. ");
INSERT INTO kyb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chimpun kunan inghubhuyas ingwhaunna nan osa mudchachuna sasay mansasamer ta umoyna ayan nan huwana. ");
INSERT INTO kyb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Gwon sa'ad chachay mansasamer inayacha ku chay niwhaun inabchaabchoycha gwot pinerjawcha gway naugwas. ");
INSERT INTO kyb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kun nangwhaun asin chay sin'ugwa san ubas as sawhali gway mudchachuna kun pina''uwancha kun pinawhainancha as sija. ");
INSERT INTO kyb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Gwot nangiwhaun ahos as sawhali kun intoycha. A'ammaschi nan inggwa'inggwacha san uchum gway niwhauwhaun. Pinertupertuwancha nan uchum kun sawhali hos ekay chanan intoycha. ");
INSERT INTO kyb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Osossa''an nan nahunan gway iwhaunna. Sija nan ana'naay patpatkona gway laya'i. Anunu kun ingwhaunna sasay nangipasamayana tan anana kunnu ananaon, ‘Whigwhikoncha nan ana''u.’ ");
INSERT INTO kyb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Gwon asi'a'anan chachay mansasamer, ‘Annaja nan mangila'sun. Gwayyu ta otojon ta'us sija ad nan'ugwa ta'u nan la'sunna!’ ");
INSERT INTO kyb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Inayacha kun chay ana', intoychaot ingwhallucha nan lachagna san lasin nan mumullan san ubas.” ");
INSERT INTO kyb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kun anan Hesus an chicha, “Ad ngachamma nan oon chay sin'ugwa san ubas? Umoyna otojon chicha a! Ad inchalisna ipasamer chay mumullana san ubas san uchumay taku. ");
INSERT INTO kyb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jo'o achiju whinasa nan nilista san Ukud Apudyus gway anana, ‘Sa'ad chay whatuway nampiliyan chanan mamanggwas hoyoy sachiyot nan kadto'ay nisaachan nan hoyoy. ");
INSERT INTO kyb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","As Apudyus nan nanggwa sanna ad amod mataakan nan mangilan ta'u.’ ” ");
INSERT INTO kyb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ad sa'ad chachay papangat nan Hudyu nananapchas ininonchaay mangipachopap an Hesus tan naagwatanchaay chicha nan iyagwatna. Gwon ummogjatcha san angsan gway taku. Gwot lummajawcha ekajot tinaynancha as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kun ingwhauncha nan uchumay Pariseo ja chanan uchumay takun Herod ta umoycha si'apan as Hesus san ukuchona. ");
INSERT INTO kyb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ummoycha ku an sija anancha, “Mistuyu, akammumi gway achi'a kun mantuliyay taku. Achim pun chongyon nu ngachan nan somsom'on chanan taku an si'a tan manisisugwom nan taku ad sija o'oom nan isuyum nan atuttugwaan gway whayugwon Apudyus. Ad iwhakamud nan tuttuwa an cha'ami nu mijuja san lintog ta'u nan mangwhajad san hugwis san Emperador gwinnu achi? Mangwhajad ta'u an chicha gwinnu achi?” ");
INSERT INTO kyb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Gwon akammun Hesus gway an'annancha manimus sija nan anana an chicha, “Kajuman padpadchason as sa'on? Atchana' as osas aka pila' ta ila'.” ");
INSERT INTO kyb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kun inatodcha nan osa. Kun inimus Hesus gway manggwana, “Ngachan nan singhoser ja singngachan sannaja?” Kun anancha summungwhat, “Emperador.” ");
INSERT INTO kyb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kun anan Hesus an chicha, “Atchonju san Emperador nan ugwan nan Emperador ad inatodju an Apudyus nan ugwan Apudyus.” Kun nataagcha losan an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kun ummoy an Hesus nan uchum gway Saduceo. Chicha nan achi mamati gway mataku nan natoy. Ummoycha nanimus an Hesus gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mistuyu, illistan Moses nan annaja lintog an chita'u gway ‘Sa'ad nu matoy nan osa laya'i ja tinaynana nan asagwana gway maid kun ana'cha, maserpu gway asawwon nan sunudna chay nawhayu tot umana'chas miwhilang as ana' chay sunudna natoy.’ ");
INSERT INTO kyb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iningkaw nan pitu mansusunud gway lallaya'i. Ad sa'ad na panguyu nangasagwa gwon natoy gway maid kun ana'na. ");
INSERT INTO kyb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kun inasagwan nan umaggwa chay nawhayu gwon natoy ahos gway maid kun ana'na. Kun amaschi ahos nan na'gwa san umatlu ");
INSERT INTO kyb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ingkana san mi'apitu. Natoy losan chachay pitu mansusunuchay maid kun ana'cha. Anunu kun natoy ahos chay huwhai. ");
INSERT INTO kyb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ad sa'ad nu umali nan erkaw gway mataku nan natoy ngachan nan sinasagwa say huwhai tan losan chachay pitu mansusunud inasagwa as sija?” ");
INSERT INTO kyb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kun anan Hesus an chicha, “Nasama nan somsomo'ju, achijuwot sija akammu nan nilistaay Ukud Apudyus gwinnu ayobhongana. ");
INSERT INTO kyb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tan sa'ad nu mataku chanan natoy maid kun manasasagwa tan isucha chanan a'anghel ad langit. ");
INSERT INTO kyb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ad sa'ad nu manimus aju mipangkop san matakuwan nan natoy, jo'o achiju whinasa san illistan Moses gway uullit nan mipangkop san kumilakilab gway aju gway anan Apudyus an sija, ‘Sa'on nan Apudyus Abraham, Apudyus Isaac ja Apudyus Jacob.’ ");
INSERT INTO kyb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nan pijaon nina anan wha'on kus Apudyus chanan natoy as sija gwon Apudyus chanan mawhiwhijag. Nipa'hot as amod nan ananju.” ");
INSERT INTO kyb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ummoy ku an Hesus nan osaay mangaagkammu san lintog san chingngorna nan maniisi'ancha gwot inilana gway ustu nan sungwhat Hesus sasan Saduceo, nanimus gway manggwana, “Ngachan nan apatkan san whilin?” ");
INSERT INTO kyb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kun summungwhat as Hesus gway manggwana, “Annaja nan apatkan gway whilin ‘Chongyonju na, cha'ajuway ijIsrael! Sa'ad as Apu gway Apudyus ta'u osossa''an as sija as Apu. ");
INSERT INTO kyb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ad maserpu gway ipatognu nan Apu gway Apudyusnu san losan gway agwad an si'a gway somsomo'nu, san alichodgwam, san losanay laingnu ja losan gway pigsam.’ ");
INSERT INTO kyb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ad sa'ad nan mi'aggwaay apatkan san whilin ananaon, ‘Ipatognu nan asintatakum as isun nan mangipatognu san longagnu.’ Maid kun uchum as whilin as napatpatog san annachaja gway chugwa.” ");
INSERT INTO kyb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kun anan chay mangaagkammu san lintog, “Ustu'a, Mistuyu, tuttuwa nan ingwhakamannat gway osossa''an as sija, maid ku uchum gway ahus ekay as sija. ");
INSERT INTO kyb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ad maserpu gway ipatog ta'u as sija san losan gway agwad an chita'uway somsomo' ja san losanay laing ja losanay pigsa. Ad maserpu gway ipatog ta'u hos nan asintataku ta'u as isun nan mangipatokan ta'u san longag ta'u. Amod napatpatog nan annachaja chugwa whilin san mapuuyanay maatod an Apudyus ja chatunay mipachaya.” ");
INSERT INTO kyb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Inilan kun Hesus gway nalaingay sumungwhat chay mangaagkammu san lintog anana an sija, “Mawhalin'aay mitapi sasan takuway ituyajan Apudyus.” Nappung kunan sachi maid kun nangituyod nanimus asin an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sa'ad san nansuyuwan Hesus san Templo nanimus gway manggwana, “Ininon chanan mangaagkammu san lintokay manggwanaon kana' Dabid nan Kristu? ");
INSERT INTO kyb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa'ad as Dabid mismu inchayan nan Ispilitun Apudyus as sija san manggwanaanaon, ‘Anan Apudyus san Apu': tumu'chu'a san machigwanan'u ingkanas ipaawha''u an si'a chanan ahursum!’ ");
INSERT INTO kyb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Dabid mismu nan manggwanaon ‘Apu'’ san Kristu. Ad sa'ad nu amasnat gway Apu nan anan Dabid san Kristu ininon Kristu gway nangngachan kana' Dabid?” Kun nayagsa'an nan angsanay taku gway nanchongor an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa'ad san nansuyuwana an chicha anana, “Ammanju ilan chachay mangaagkammu san lintog gway whayugwonchaay mangikagkagka'ay san mallagyagkoyloy gway silupcha ja whayugwonchaay agwad mangingakinga an chicha san merket. ");
INSERT INTO kyb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Whayugwoncha hosay tu'chu san awhayugwanay tu'chugwan san sinagoga ja ingkaw san agwachan nan ikaw nan nangatuway taku sasan lagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Isi'asi'apchaay mangaya san u'ugwan chanan nawhayu ad an'annancha anchugwon nan lugwayucha. Sa'ad nannachaja machusachas amod.” ");
INSERT INTO kyb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tummu'chu kus Hesus san chomang nan mangiigkaancha san pila'ay atchoncha san Templo, iniilana nan angsanay taku gway mangigka san pila'cha. Angsan nan whawha'nang gway nangigka san achuway pila'. ");
INSERT INTO kyb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nilumno' kunan osa nawhayu gway apus inigkana nan chugwa aka pila'. ");
INSERT INTO kyb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Inajakan kun Hesus nan pasuyutna anana an chicha, “Iwhaka' an cha'aju nan tuttuwa, adachu nan inigkan chay nawhayu gway apus nu san inigkan chachay uchum gway taku. ");
INSERT INTO kyb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tan sa'ad chachay uchum, sergwan nan pila'cha nan inigkacha gwon sa'ad chay nawhayu ta'on nu apus as sija inaminna inigka nan agwad an sija gway ahus otjan as i'atakuna.” ");
INSERT INTO kyb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sa'ad san lumajagwan Hesus san Templo osa san pasuyutna nan manggwana an sija, “Mistuyu, ilam ad nannachajaay man'awhawhayu whatu ja inawhayun nan annachaja nipata'chor.” ");
INSERT INTO kyb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Anan Hesus an sija, “Mailam nannachajaay chacha''orray pata'chor? Awni achot maid kun osas matchay san whatu gway natuutuun as achi ku mi'uurb.” ");
INSERT INTO kyb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sa'ad san tummutu'chugwan Hesus san whilig gway Olibu gway chomangon nan Templo, ummoy cha Pedro, Santiago, Juan ja Andres an sija. ");
INSERT INTO kyb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kun iyuwhitchaay nanimus gway manggwana, “Iwhakamud an cha'ami nu ma'anu nan ma'gwaan nina. Ngachan nan mangimatunan san humu'nakan nina?” ");
INSERT INTO kyb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kun anan Hesus an chicha, “Ammanju ilan ta maid mangallilaw an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tan angsan nan umali manguser san ngachan'u gway manggwana, ‘Sa'on nan Kristu’ ad angsan nan allilagwoncha. ");
INSERT INTO kyb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ad sa'ad nu chongyonju nan mipangkop san kukuwhat ja chamag mipangkop san kukuwhat achi aju ma'og'og. Maserpu ma'gwa jan nannaja gwon wha'on kus pijaona anan nan sachi nan pungpung nan luhung. ");
INSERT INTO kyb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tan mangwhiwhinnursu nan ailiili ja chanan kuwhilnu san luta. Ad mangita hos nan na'aya'ayasiyay ili ja humu'nag ahos nan uyat. Gwon sa'ad nannachaja lukin ekay nan likat gway isun nan sikab nan mangkumut. ");
INSERT INTO kyb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Manannad aju tan mipawhijang aju san papangat ad naabchoy aju sasan sinagoga. Misangu aju sasan kuwhinnachur ja chanan ali kapu san pammatiju an sa'on ad sachi nan mangiwhaganju an chicha san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gwon sa'ad nan Whayuway Chamag maserpu gway mipaakammu jan san losan gway taku san ayutayuta. ");
INSERT INTO kyb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ad sa'ad nu ijoycha cha'aju san uu''uman ta sumerjaon cha'aju ja mipawhijang aju, achi aju umunnuunna manchanag nu ngachan nan iwhakaju gwon iwhakaju nu ngachan nan ustuway mipaakammu an cha'aju san sanatay chimpu. Tan wha'on ku an cha'aju nan merpugwan nan isungwhatju. Sija merpugwana nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ad san sachi chimpu sa'ad nan osa sunud ipuyangna nan sunudna ipaotoy. Sa'ad ahos chanan ummaana' ipuyangcha nan ana'cha ipaotoy ja isuna hos chanan anana' gway kuyaoncha chanan sinana' an chicha ad impa'toycha chicha. ");
INSERT INTO kyb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ad as cha'aju kuyaon cha'aju san losanay taku kapu an sa'on. Gwon sa'ad nan mangituttuyuy san pammatina mataku. ");
INSERT INTO kyb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sa'ad nu ilanju nan amod a'oogjat gway mawwa''i gway summisi'ad san wha'on kus lobhongna sumi'achan, (maserpu maagwatan nan mangwhasa,) sa'ad chachay ingkaw ad Judea san sachi gway chimpu maserpu umagwidcha san whibilig. ");
INSERT INTO kyb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ad sa'ad nan nijaspur gway iningkaw san otop nan hoyoyna a''agwaynaay manosog ad achi kun lumno' gway mangayas whayangna as ijagwidna. ");
INSERT INTO kyb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ad sa'ad nan nijaspur gway agwad san tayun achi kun manulin san hoyoyna gway mangayas kotap nan silupna. ");
INSERT INTO kyb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Ad achagchaku chanan mahuki ja chanan mantatakiwhi san sachi gway chimpu. ");
INSERT INTO kyb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sija nan ilugwayuju an Apudyus ta achi mijaspur na san chimpuway amod nan tagling. ");
INSERT INTO kyb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tan sa'ad nan amaschi chimpu humu'nag nan amochay likat gway maid kun mijisugwana san ikad nan nanggwaan Apudyus san luhung ingkana san sana. Ad achi kun puyus ma'gwa nan amasna asin. ");
INSERT INTO kyb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sa'ad nu achin Apudyus ipaa'it nan whilang nan erkaw san sachiyay chimpu maid kun osas taku as mataku. Gwon kapu sasan pinilinaay takuna inaanana nan whilang nan erkaw san sachiyay chimpu. ");
INSERT INTO kyb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ad sa'ad nu agwad manggwana an cha'ajuwon, ‘Ilanju ad, annaja nan Kristu!’ gwinnu ‘Anchiya nan Kristu!’ achiju tuttugwaon. ");
INSERT INTO kyb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tan lumosgwa chanan wha'wha''onay Kristu ja wha'wha''onay profeta ad nangipailacha as mangimatunan ja mataakan ad nu agwad awhalinana uyay chanan takun Apudyus gway pinilina allilagwoncha chicha. ");
INSERT INTO kyb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gwon ammanju ilan! Anna inunnaunna' ingwhaka an cha'aju losan nan annachaja ma'gwa.” ");
INSERT INTO kyb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ad anan ahos Hesus, “San sachi chimpu mappung ad nan mapalpalikatan as amod chanan taku, humulingot nan init ad achi kun sumyag nan huyan. ");
INSERT INTO kyb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ad sa'ad chanan whituwon maotchagcha ja sa'ad chanan ayobhonganay agwad ad langit majugjug. ");
INSERT INTO kyb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ad ilancha as sa'onay Ana' nan Taku gway umali gway nangkakagwa san hunot gway anna nan amochay ayobhonga' ja inachajaw'u. ");
INSERT INTO kyb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ad ingwhaun'u chanan a'anghel ad inasinutcha chanan pinilin Apudyus san intilu luhung.” ");
INSERT INTO kyb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Intuyuy Hesus gway manggwana, “Achayonju hos nan acher gway atchon nan aju gway igos. Sa'ad nu luminsi nan pangana ja sumimit akammuju gway takangay nan chakun. ");
INSERT INTO kyb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ad isuna hosay sa'ad nu ilanju gway ma'gwa chana aagkammujuway umachani gway umachani nan chimpuway managkulina'. ");
INSERT INTO kyb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuttuwa iwhaka' an cha'ajuway sa'ad nannachaja takuway matattaku san sana achicha kun losan matoy ingkanas ma'gwa losan nannachajaay ingwhaka'. ");
INSERT INTO kyb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sa'ad nan langit ja luta maumas gwon sa'ad nan ukud'u sissija iingkaw.” ");
INSERT INTO kyb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Sa'ad nan mipangkop san sanat gway erkaw ja uyas gway managkulina' maid kun mangakammu. Uyay chanan a'anghel ad langit achicha kun akammu gwinnu as sa'on gway Ana' Apudyus achi' kun akammu. Ahus as Ama as mangakammu. ");
INSERT INTO kyb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sija nan ammanju ilan ja mansasagkana aju tan maid kun akammuju san umaliyan nan sanat gway chimpu. ");
INSERT INTO kyb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Sa'ad nan sanatay chimpu mijagwat san osa taku gway nangwhaat san achaju ili. Sa'ad san lumiggwatana ingwhakanas mudchachunaay nangamungcha san whijangchaay terwhasu kun pinuyungna nan mangijaachug san hoyoy gway na'asasagkana. ");
INSERT INTO kyb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sija nan patinajunay na'asakana aju tan achiju kun akammu nan humu'nakan nan singhoyoy nu lawhi, kagwan nan lawhi, machani gwinnu whigwhikat nan humu'nakana. ");
INSERT INTO kyb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tan awni ad nu mawhanu'nag as sija tugwakay aspuyan cha'ajuway masusujop. ");
INSERT INTO kyb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa'ad nannaja iwhaka' an cha'aju sija ahos nan iwhaka' san uchum gway taku gway mansasagkanacha.” ");
INSERT INTO kyb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chugwa ad janay erkaw asiyot nan pijasta gway ma'gwaniyon Lumaus ja pijasta gway ma'gwaniyon Tinapay Gway Maid Kun Yeastna. Ad sa'ad san sachi chimpu, sa'ad nan papangat nan papachi ja mangaagkammu san lintog mananapcha as ininonchaay manpap an Hesus as achi kun maakammugwan ad intoycha. ");
INSERT INTO kyb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tan asi'a'ananchaon, “Achi ta'u ijaspur san chimpun nan pijasta tan tugwakay makuyu chanan taku.” ");
INSERT INTO kyb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iningkaw as Hesus san sachi chimpu ad Betania san hoyoy Simon gway naleprosi. Ad sa'ad san mangamanganana nilumno' nan osa huwhai gway nanangchon san whangwhangyuway pasig nardo gway amod nan patogna gway niigka san iigkaan gway na'gwa san whatuway alabaster. Whinta' ku chay huwhai nan whakang chay nangigkaana san whangwhangyu, insiitna san wha''ag Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gwon nalingu nan uchum gway agwad san sachi hoyoy gway asi'a'anancha, “Ka aynga ekay nan whangwhangyu! ");
INSERT INTO kyb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tan sa'ad nannaja whangwhangyu mila'u otjan as tuyungkasut as dinario ad naatod san whawha'sigwot.” Kun inamujuwancha chay huwhai. ");
INSERT INTO kyb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gwon anan Hesus, “Ainnugwana man. Kajuman whijangan as sija. Whayu nan inggwana an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tan patinajunay iingkaw chanan whawha'sigwot an cha'aju ad nu whayugwonju whayangna chimpu nan humadnganju an chicha. Gwon as sa'on wha'ona' kus patinajun gway iingkaw an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Inggwana nan loogna oon. Inununnana inggwaan nan longag'u san whangwhangyu as misakanaan nan miilhona'. ");
INSERT INTO kyb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuttuwa iwhaka' an cha'aju gway agwanna man sinat nan mipaakammugwan nannaja Whayuway Chamag san intilu luhung, machamag ahos nan inggwan nannaja huwhai as manomsom'an an sija.” ");
INSERT INTO kyb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sa'ad as Judas Iscariote gway osa sasan nasagwayan as chugwaay apostoles ummoy sasan papangat nan papachi ta ijiwhitna as Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chingngorcha ku chay ingwhakan Judas lummagsa'cha kun ingwhakachaay aatchancha as sija as pila'. Kun illukinaay mananap as chimpu as mangijiwhitana an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sa'ad san chamun nan erkaw nan pijasta gway ma'gwaniyon Tinapay Gway Maid Kun Yeastna gway sija nan mamertiyancha san kernero gway michatun san pijasta gway ma'gwaniyon Lumaus, inimus chanan pasuyut Hesus an sija gway manggwana, “Agwan nan whayugwomay mangisakanaanmi san manganam san pijasta gway ma'gwaniyon Lumaus?” ");
INSERT INTO kyb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kun ingwhaun Hesus nan chugwaay pasuyutna gway manggwana, “I'aju ad Jerusalem ad anna nan osa laya'i gway mangahot an cha'aju gway nanoodchon san singkusiyay chanum. Ad nitunud aju an sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ad nu ngachan nan hoyoy gway lumno'ana ananju san singhoyojon, ‘Anan nan Mistuyuwon agwan nan agwad nan ugwertu gway mangananmi san pasuyut'u san pijasta gway ma'gwaniyon Lumaus?’ ");
INSERT INTO kyb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ad initchuna nan cha'or ugwertu gway nangngatu san agwachan nan gwachagwad nan mauser gway nisasagkana san manganan ta'u. Ad aschi nan mangisakanaanju san anon ta'u.” ");
INSERT INTO kyb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kun lummiggwat chachay chugwa pasuyut kun ummoycha ad Jerusalem gwot inchasancha nan ustu'ustuway ingwhakan Hesus an chicha kun insakanacha nan anoncha san pijasta. ");
INSERT INTO kyb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mummaschom pun hummu'nag as Hesus ja chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sa'ad san mangamanganancha anan Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway osa an cha'aju gway auhung'u nan mangijiwhit an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lummagwing nan angoscha losan kun nasinnossacha gway manggwana an sija, “Sa'on lagwa nan anam?” ");
INSERT INTO kyb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kun summungwhat gway manggwana, “Osa an cha'ajuway nasagwayan as chugwa gway ma'atuynotuyno' an sa'on san tinapayna san chujug. ");
INSERT INTO kyb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tan as sa'on gway Ana' nan Taku matoja' gway sachi nan nilista san Ukud Apudyus gwon amod a'oogjat nan ma'gwa san sanatay takuway mangijiwhit an sa'on gway Ana' nan Taku! Unayna ekay achi nijana' nan sanatay taku.” ");
INSERT INTO kyb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sa'ad san mangamanganancha nangaya as Hesus san tinapay gwot nanjaman an Apudyus kun pini'pi''inaot inatodna an chicha. Kun anana, “Ayanju na. Annaja nan longag'u.” ");
INSERT INTO kyb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Inayan kuhos Hesus nan sintasa whajas gwot nanjaman an Apudyus inatodna an chicha kun umminumcha losan. ");
INSERT INTO kyb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kun anana an chicha, “Annaja nan chaya' gway umigwang as mamagchot san assahu tuyag Apudyus sasan taku. ");
INSERT INTO kyb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nan inatuttugwaana achi' kun asin inumon nan whajas nan ubas ingkana san erkaw gway uminuma' san assahu whajas san Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nappungcha ad nan'anta san chaychajaw an Apudyus lummagwachaay ummoy san whilig gway Olibu. ");
INSERT INTO kyb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sachi kun anan Hesus an chicha, “Taynana' an cha'aju losan tan sija nan nilista san Ukud Apudyus gway anana, ‘Otojo' nan mampaspastur ad nasibsibta' chanan kernero.’ ");
INSERT INTO kyb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Gwon matakuwa' ad ummunaa' an cha'aju umoy ad Galili.” ");
INSERT INTO kyb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kun anan Pedro an sija, “Ta'on nu losancha taynan si'a achi' kus si'a taynan!” ");
INSERT INTO kyb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kun anan Hesus an sija, “Tuttuwa iwhaka' an si'a gway san sana lawhi mamitlum sa'on isulib san chaanan nan awwit ipiggwaay mangu''uu'.” ");
INSERT INTO kyb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Gwon impapilit Pedro gway manggwana, “Ta'on nu mitapiya' matoy an si'a achi' kun si'a isulib.” Amaschi hos nan ingwhakacha losan. ");
INSERT INTO kyb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sachi kun ummoy cha Hesus san ma'gwaniyon Getsemani kun anan Hesus sasan pasuyutna, “Tu'chu aju jan sannaja ta iya' mallugwayu.” ");
INSERT INTO kyb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inghuyogna kun cha Pedro, Santiago ja Juan illukinaay sumanga as amod ja nakuyu nan somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kun anana an chicha, “Lumagwilagwing as amod nan angos'u gway amaa' ekas matoy. Ainnugwanju sannaja ta mansasagkana aju.” ");
INSERT INTO kyb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ummachaju kus a'it as Hesus nallu'hub san luta gwot illugwayuna gway nu mawhalin achi otjan ma'gwa nan likat an sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kun anana, “Ama, maid kun achim ma'gwa. Ilisiya' otjan sannaja amod gway likat. Gwon wha'on kusan whayugwo' nan ma'gwa, sija ma'gwa nan whayugwom.” ");
INSERT INTO kyb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Manulin kus Hesus inchasana chichaay nanassuy. Kun anana an Pedro, “Simon, nassuy'a? Jo'o achi'a ekay ma'aituyod gway mansuyap as osa uyas? ");
INSERT INTO kyb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Achi aju massuy ja mallugwayu aju tot achi aju masulisukan. Tuttuwa whayugwon nan somsomo'ju nan ustu gwon achi kun ma'a'gwa nan longagju.” ");
INSERT INTO kyb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Asin kun ummachaju as Hesus nallugwayu hos as isun chay lugwayuna san chamu. ");
INSERT INTO kyb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nanulin kuhos asin inchasana hos chichaay nanassuy tan amod nan chu'chu'jopcha. Ad maid kun akammucha nu ngachan nan iwhakacha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pitluna kun gway manulin anana an chicha, “Ka'aju patho' ekay mamassuy ja umiillong? Akay san sujop! Ilanju ad takangay nan uyas ad as sa'on gway Ana' nan Taku mijiwhita' sasan humersuwhersu. ");
INSERT INTO kyb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Humangon aju ta inta'u mijahot. Ilanju ad annaja umachayug nan mangijiwhit an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sa'ad san manapaapatan Hesus nawhanu'nag as Judas gway osa sasan nasagwayan as chugwa pasuyutna gway huyogna nan angsanay taku gway naniispada ja namperpertu. Ingwhaun chanan papangat nan papachi ja chanan mangaagkammu san lintog ancha chanan chacha''orn nan Hudyu chicha. ");
INSERT INTO kyb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ad sa'ad nan mangijiwhit an Hesus inununnana ingwhaka an chicha nan mangimatunancha an Hesus gway manggwana, “Nu ngachan nan sin'aping san mangichooma' san aping'u chopaponju as sija ad illajawjuway whawhantajanju ustu.” ");
INSERT INTO kyb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hummu'nag kun as Judas nanijachayugna an Hesus kun anana, “Mistuyu!” kun inchoomna nan apingna san aping Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kun chimpapcha as Hesus gwot impukodchas sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gwon sa'ad nan osa summisi'ad nilu'pusna nan ispadana gwot whina'agna kunan mudchachun nan angatuwanay pachi napingasan nan ingana. ");
INSERT INTO kyb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kun kumminga as Hesus an chicha gway manggwana, “Jo'o tulisana' ta umali ajuway naniispada ja namperpertu gway manpap an sa'on. ");
INSERT INTO kyb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Awhikawhikat peekay iniingkagwa' an cha'aju san Templo gway mansuyu gwon achiya' kun chimpap. Gwon ma'gwa losan nan niwhaka san Ukud Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ummagwid ku losan chanan pasuyutna tinaynancha as sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kun iningkaw nan osa whawhayu gway nansisillup san japit gway luput gway mituntunud an Hesus. Gwot chino'maan nanchichajaay taku as sija ");
INSERT INTO kyb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","gwon tinaynana kunan silupna ummagwid gway nampoponnas. ");
INSERT INTO kyb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iyoycha as Hesus san hoyoy nan angatuwan gway pachi gway sachi nan naayusan chanan papangat nan papachi, chanan mangaagkammu san lintog ja chanan chacha''orn nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ad sa'ad as Pedro ummaadchajang gway misu'su'nub an sija ingkana san sowhan nan hoyoy nan angatuwanay pachi kun na'atu'chu san mangwhawhantay kun na'aanichu. ");
INSERT INTO kyb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ad sa'ad chanan papangat nan papachi ja chanan losanay papangatay naayus nananapcha as taku as mangiwhakas tuli as ipawhersucha an Hesus tot ipa'toychas sija. Gwon maid kun inchasancha. ");
INSERT INTO kyb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tan angsan nan taku gway nangiwhaka san tuli gway mipawhersu an Hesus gwon achi kun maninnaya nan ingwhakawhakacha. ");
INSERT INTO kyb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ad sa'ad nan uchumay lallaya'i ummoycha kumminga kun ingwhakacha nan tuli san mipangkop an Hesus gway anancha, ");
INSERT INTO kyb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Chingngormi nan ingwhakana gway ananaon, ‘Igwa''i' nan annaja Templon Apudyus gway inggwan nan taku ad nanggwaa' as sawhali as Templo san tuyu erkaw as wha'on kusan taku nan nanggwa.’ ” ");
INSERT INTO kyb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gwon uyay pay nu amaschi nan ingwhakacha achi kun maninnaya nan anancha. ");
INSERT INTO kyb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Summi'ad kunan angatuwanay pachi san sangucha losan inimusna an Hesus gway manggwana, “Ad maid isungwhatnu san ingwhakan nannachaja taku gway mihursu an si'a?” ");
INSERT INTO kyb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gwon kummikinno' as Hesus kun achi kun summungsungwhat. Kun nanimus asin nan angatuwan gway pachi an sija gway manggwana, “Tuttuwa si'a nan Kristu gway ana' nan Machajaw gway Apudyus?” ");
INSERT INTO kyb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kun summungwhat as Hesus gway manggwana, “Oon sa'on! Ad ilanju as sa'onay Ana' nan Taku gway tumutu'chuwa' san machigwanan Apudyus gway anna ayobhongana ad ummaliya' gway nangkakagwa san hunot ad langit.” ");
INSERT INTO kyb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nalingu kunan angatuwanay pachi whinis'ina nan silupna. Kun anana, “Ad ngachan manan uchum as anapon ta'u as mangiwhaka san whersuna. ");
INSERT INTO kyb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chingngorju nan ananaanchi gway maamamangan Apudyus. Ad ngachan nan whayugwonju ma'gwa an sija?” Kun nilodchongancha losan as sijaay manggwana, “Lobhongnaay matoy as sija.” ");
INSERT INTO kyb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kun illukin nan uchum gway manubwha an sija kun whinungutcha nan hoserna kun sinuntu'chaay manggwana, “Imatunama nu ngachan nan nanuntu' an si'a?” Kun inayan chanan mangwhawhantay as Hesus kun nanilipa'cha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa'ad san iniingkagwan Pedro san nanchoyaay sowhan hummu'nag nan osa huwhai gway mudchachun nan angatuwan gway pachi. ");
INSERT INTO kyb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gwot inilana kun as Pedro gway manaannichu intor'orna kun anana an sija, “Si'a hos nan nihuyohuyog an Hesus gway iNazaret.” ");
INSERT INTO kyb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Gwon insulib Pedro gway manggwana, “Maid kun akammu' ja maid kun maagwata' san mipangkop san iwhagwhakam.” Kun lummagwaay nan ummoy san sagwang nan ayad kun nangu''uu' nan awwit. ");
INSERT INTO kyb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Inilan ku chay mudchachuway huwhai asin as Pedro ingwhakana san nasi'asi'ad san sachi gway manggwana, “Sa'ad nan osa takuwanna osa sasan huyun Hesus!” ");
INSERT INTO kyb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Gwon asin ahos Pedro insulib. Awawni kun anan ahos nan uchum gway taku an Pedro, “Si'a tuwa nan osa an chicha tan iGalili'a.” ");
INSERT INTO kyb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gwon whinujunana nan longagna kun nansapataay manggwana, “Maid kun tuwa akammu' san sanatay takuway ana'ananju!” ");
INSERT INTO kyb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sachi kun ekay impiggwan nan awwit gway mangu''uu' kun simsimmo' Pedro chay ingwhakan Hesus an sija gway manggwana, “Chaan ad nan awwit ipiggwaay mangu''uu', namitlum sa'on isulib.” Kun naniwhil as Pedro san amod gway somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gwisnit kun ekay nanuukud chachay papangat nan papachi ja chanan chacha''orn nan Hudyu ja chanan mangaagkammu san lintog ancha chanan Sanhedrin. Pinungucha kus Hesus iyoycha impawhijang an Pilato. ");
INSERT INTO kyb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kun inimus Pilato an Hesus gway manggwana, “Si'a nan Alin chanan Hudyu?” Anan Hesus gway summungwhat, “Si'a nan nangiwhaka gway aliya'.” ");
INSERT INTO kyb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ad sa'ad chachay papangat nan papachi angsan nan impawhersucha an sija. ");
INSERT INTO kyb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kun nanimus asin as Pilato an sija gway manggwana, “Ad maid isungwhatnu? Ilam ad angsan yakay nan ipabpawhersucha an si'a.” ");
INSERT INTO kyb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Gwon achi kun summungsungwhat. Sija nan nataag as Pilato. ");
INSERT INTO kyb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","San tinagwonay pijasta nisikud gway umipayagwa as Pilato as osas whayud nu ngachan nan ochagwon chanan taku. ");
INSERT INTO kyb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ad sa sachi chimpu iningkaw nan osa laya'i gway mangngachan Barrabas gway niwhayud gway huyunna chachay pummatoy san sachi chimpun nan kuyu gway achi kun umajun san kuwhilnu. ");
INSERT INTO kyb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ummoy kunan angsan gway taku an Pilato ingwhakachaay oona nan sikuchay o'oona san chimpun nan pijasta gway umipayagwa otjan san whayud. ");
INSERT INTO kyb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kun inimus Pilato an chichaay manggwana, “Whayugwonjuway ipayagwa' an cha'aju nan Alin nan Hudyu?” ");
INSERT INTO kyb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akammunaot sija gway apos chanan papangat nan papachi nan nangipawhijangancha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gwon sa'ad chachay papangat nan papachi sinugsukancha nan angsan gway taku ta iwhakacha an Pilato gway as Barrabas ekay nan ipayagwana. ");
INSERT INTO kyb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kun asin ahos Pilato inimus san angsanay taku gway manggwana, “Ad ngachan nan whayugwonju oo' sannaja takuway ananjuwon Alin nan Hudyu?” ");
INSERT INTO kyb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kun impa'uycha an sija gway manggwana, “Pailansam as sija san krus!” ");
INSERT INTO kyb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kun inimus ahos Pilato gway manggwana, “Kaman, ngachan nan lagwingay inggwana?” Gwon impaamamodchaot ipa'uy gway manggwana, “Pailansam as sija san krus!” ");
INSERT INTO kyb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ad kapu san whayugwon Pilato gway mangop nan angsanay taku impayagwanas Barrabas an chicha gwot nappungna kun ipasaplit as Hesus asinaot ipawhijang sasan surchachu ta ilansacha san krus. ");
INSERT INTO kyb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ad sa'ad chanan surchachu imperno'chas Hesus san hoyoy nan kuwhinnachur kun inajakancha losan nan huhuyuncha gway surchachu. ");
INSERT INTO kyb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kun inakojancha as Hesus san luput gway malluyom nan chayagna kun nalli'uscha san sait kun asichaot ijakipur an sija. ");
INSERT INTO kyb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kun chinaychayyawcha as sija gway manggwana, “Mawhiwhijag nan Alin nan Hudyu!” ");
INSERT INTO kyb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kun inabchaabchoycha nan wha''agna san tannuhung ja tinubwhatubwhaancha as sija. Kun intumu'cha nan puwogcha gway nanaychayyaw an sija. ");
INSERT INTO kyb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nappungcha kun nansansannuyan as sija inaancha nan akoynaay malluyom nan chayagna kun inigkacha nan sikud gway silupna kun asichaot ilagwa ta umoycha ilansa san krus. ");
INSERT INTO kyb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa'ad san manadchadchayanancha inahotcha nan osa takuway mangngachan Simon gway iCirene gway aman cha Alehandro an Rufo. Sa'ad as Simon nerpu san lasin nan Jerusalem. Kun asichaot ipapilit pahu'ud an sija nan krus Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kun iyoychas Hesus san ikaw gway ma'gwaniyon Golgota gway nan pijaona anan, Tungern nan Wha''ag. ");
INSERT INTO kyb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ad sa'ad san agwachancha san sachi inatchanchas Hesus san whajas gway na'ayutan san mirra gway mangaan san sikab gwon achina kun ininum. ");
INSERT INTO kyb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kun illansacha as sija san krus kun nangwhiwhinnunutchaay namiwhillay san luputna nu ngachan nan ayan nan gwaschi osa an chicha. ");
INSERT INTO kyb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Suminer chi san nangilansaancha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iningkaw nan nilista san krusna gway nipawhersu an sija gway anana, “Nan Alin nan Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ad iningkaw ahos nan chugwaay mamayangkat gway illansacha san krus san chapat Hesus, osa san machigwananna ja osa san machigwikina. ");
INSERT INTO kyb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tummuttuwa nan Ukud Apudyus san agwiyay anana, “Niwhilang as sija an chichaay humersuwhersu.” ");
INSERT INTO kyb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ad sa'ad chanan takuway asilayaus inamamangcha as sija gway asigwigwikigwigchaay manggwana, “Ana'anu! Si'a chay manggwanaon igwa''im nan Templon Apudyus ad impata'chorm san tuyu ekajay erkaw. ");
INSERT INTO kyb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ay chuud takuwom nan longagnu ad nilumsa'a san krus.” ");
INSERT INTO kyb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sa'ad ahos chanan papangat nan papachi ja chanan mangaagkammu san lintog asijaamangcha gway manggwana, “Tinakuna nan uchum gwon achi kun ma'ataku san longagna! ");
INSERT INTO kyb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lumsaud san krus nan Kristu gway Alin nan ijIsrael ta ilan ta'u tot tuttugwaon ta'us sija.” Ad sa'ad chachay chugwaay nitapi an sija nilansa san krus na'aamamangcha hos. ");
INSERT INTO kyb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mamatu' kun hummulingot nan losanay luta ingkana san singwhattang as anchu. ");
INSERT INTO kyb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ad sa'ad san sachi singwhattang as anchu nampa'uy as towhag as Hesus gway manggwana, “Eloy, Eloy, lama sabaktani!” Na pijaona anan, “Apudyus'u, Apudyus'u, kamman ekay manchu'kan sa'on?” ");
INSERT INTO kyb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ad sa'ad chachay uchumay nasi'asi'ad ad aschi chingngorcha nan ingwhakan Hesus kun anancha, “Chongyonju ad, ajakana as profeta Elias!” ");
INSERT INTO kyb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nanu'yus kunan osa laya'i gway ummoyna insagnong nan ispongha san na'ilomay whajas gwot iyipitna san tannuhung, asinaot umoy atchon ta ipainumna an Hesus gway manggwana, “Awni jan ta ilan ta'u nu umalin Elias opason as sija san krusna!” ");
INSERT INTO kyb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nampa'uy kus Hesus chakasnaay mahursutan. ");
INSERT INTO kyb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ad sa'ad nan kurtinaay nanorcha' san ingkagwan Apudyus san chayo' nan Templo nawhis'i kun nan'aggwa mallukid ngatu ingkanad choya. ");
INSERT INTO kyb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ad sa'ad nan apitan nan surchachu gway summisi'ad gway nisasakkang an Hesus san sachiyay nangiillana san hursutna, anana, “Tuttuwa tuwaay Ana' Apudyus nannaja taku!” ");
INSERT INTO kyb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iningkaw ahos nan uchum gway hubhuwhai san akag achaju gway nangiila san na'na'gwa. Iningkaw an chicha cha Maria gway iMagdala, Maria gway inan cha Santiago gway whanog an Josep ja as Salome. ");
INSERT INTO kyb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Annachaja nan hubhuwhai gway nitunutunud an Hesus gway hummachang an sija san iningkagwana ad Galili. Iningkaw ahos nan uchumay hubhuwhai gway nitunud an Hesus san ummajana ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ad kapu tan sachi nan erkaw nan mangisakanaan chanan Hudyu san losanay maserpucha san Erkaw gway Umillongan, ");
INSERT INTO kyb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mumaschom pun sa'ad as Josep gway ijArimatea intuyodnaay ummoy an Pilato nangchaw san lachag Hesus. Sa'ad as sija osa sasan pangat nan Hudyu gway patkon nan taku gway osa ahos gway manguullay san umaliyan Apudyus mantuyajan. ");
INSERT INTO kyb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kun nataag as Pilato gway natoy tuwa as Hesus kun impaajagna nan apitan nan surchachu kun inimusna nu natoy tuwa as Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Inakammun kun Pilato san ingwhakan chay apitan nan surchachu gway tuttuwaay natoy as Hesus, iyujana gway ayan Josep nan lachag Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nalla'u kus Josep san whawhalluwanay luputay puta' gwot impasna nan lachag Hesus san krus, whinichiwhichana nan lachag Hesus san luput gwot asinaot ijoy san lijangay lohon. Kun inalikadna nan cha'orray whatu kun sija nan iyonobna san sagwang nan lohon. ");
INSERT INTO kyb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ad sa'ad cha Maria gway iMagdala an Maria gway inan Josep inilacha hos nan niilhonan Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nappung kunan Erkaw gway Umillongan ummoy cha Maria gway iMagdala an Maria gway inan Santiago ja as Salome nalla'u san whangwhangyu ta umoycha igka san lachag Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Whigwhikat kusan chumungitan nan init ummoycha san niilhonan Hesus gway sachi nan umunaay erkaw nan chumingku. ");
INSERT INTO kyb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sa'ad san ingkagwancha san chayan nanisijimuscha gway manggwana, “Ngachamma mangijalikad an chita san whatuway nijumut san lohon?” ");
INSERT INTO kyb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ad sa'ad san chummakusancha san lohon inilacha gway naalikad nan sachi whatu. Sa'ad chay whatu amod nan acha'orna. ");
INSERT INTO kyb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nilumno'cha kun san lohon inilacha nan osa whawhayu nansisillup san puta'ay lagkoyloy gway tummutu'chu san machigwanan. Kun nataagcha. ");
INSERT INTO kyb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kun anan chay laya'i an chicha, “Achi aju mataag. Umali ajuway manganap an Hesus gway iNazaret gway chay nilansa san krus. Nataku as sija, maid kun sannaja. Ilanju nan nangigkaancha san lachagna. ");
INSERT INTO kyb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sija nan i'aju iwhaka sasan pasuyutna ja as Pedro gway umuna as Hesus an cha'aju umoy ad Galili ad aschi nan mangilanju an sija gway chay ingwhakana an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lummagwacha kun san lohon ina''agwaychaay lummajaw tan namajogpogcha san amochay ogjatcha. Ad maid kun nangiwhagwhagancha san na'gwa kapu tan ummogjatcha. ");
INSERT INTO kyb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sa'ad nan natakuwan Hesus san chaan nan init chumungitan san umunaay erkaw nan chumingku, Maria gway iMagdala nan ummunaay nampailana gway sija chay namerjagwan Hesus san pituway chimunju. ");
INSERT INTO kyb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kun ummoy Maria ingwhaka sasay nansimo' ja naniwhil gway huhuyun Hesus. ");
INSERT INTO kyb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gwon chingngorcha kunay nataku as Hesus ja nampaila an sija achicha kun tinuttuwa. ");
INSERT INTO kyb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nappung ad chi sawhali hos nan ilan Hesus san nampailana san chugwa pasuyutnaay manadchadchayan gway nerpu ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kun nanulinchaot ingwhakacha sasan huhuyunchaay pasuyut gwon achicha kun tinuttuwa chicha. ");
INSERT INTO kyb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nappung kun chi nampaila hos as Hesus sasay nasagwayan as osaay pasuyutna san mangamanganancha. Kun inamujuwana chicha kapu tan achicha kun mamati ja achicha kun mammingat kapu san achicha mamatiyan sasay nangila an sija san natakuwana. ");
INSERT INTO kyb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kun anana an chicha, “I'aju san ailiili ipaakammu nan Whayuway Chamag san losanay taku. ");
INSERT INTO kyb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ngachan ad nan mamati ja mahonjakan mataku. Gwon sa'ad nan achi mamati an sa'on machusa. ");
INSERT INTO kyb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ad annachaja imatun nan mamyun sasan mamati: mamperjawcha sasan chimunju kapu san ngachan'u, manapapatcha san ayasiyay apapat. ");
INSERT INTO kyb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Agwad ad lagwa pichitoncha as uyog ja uyay nu uminumcha san ochot maid kun alina an chicha. Idoncha nan imacha san masa'it ad hummayucha.” ");
INSERT INTO kyb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nappung kun Apu Hesus iwhaka nan anana an chicha nipangatu as sija ad langit kun tummu'chu san machigwanan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ad sa'ad chachay pasuyutna lummiggwatcha ad Jerusalem kun ummoycha impaakammu nan mipangkop an Hesus. Sa'ad san sachi whinadngan Hesus chicha kun intuttuwana nan insuyucha kapu san imatun gway nipaila. Amen.");
INSERT INTO kyb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ipatpatog'uway Teofilo, angsan nan nangisisimo' nangilista san mipangkop sasan aullitan nan na'na'gwa gway inggwan Hesus an chita'u. ");
INSERT INTO kyb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nan illistacha manisu sasay ingwhakacha an cha'ami chachay nangila sannachaja san chamchamu ja nangipaakammu san Whayuway Chamag. ");
INSERT INTO kyb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ad sija nan, Machajaw gway Teofilo, sa'ad tan inamma' achayon losan nannachaja na'gwa san chamu, simsimmo''uway whayu ahos nu isuyat'u an si'a chanan naurnus gway aullitan nan na'na'gwa ");
INSERT INTO kyb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tot maakammugwam nan atuttugwaanay mipangkop san Whayuway Chamag gway nipaakammu an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sa'ad san chimpuway as Herod nan alid Judea iningkaw nan pachiyay mangngachan Zacarias gway mitapi san hungkuy chanan papachiyay ipangatan Abias. Ad nan asagwana osa sasan kana' Aaron gway sa'ad nan ngachanna Elisabet. ");
INSERT INTO kyb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Manisuchaay nalintog san mangilan Apudyus gway pinaticha nan losanay whilin ja lintog Apudyus gway maid kun na'na'gwaniyancha. ");
INSERT INTO kyb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ad maid kun ana'cha tan nawhasig as Elisabet ja lumma'pus losan nan tagwoncha. ");
INSERT INTO kyb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Osa ku erkaw nanterwhasu nan hungkuy Zacarias gway papachi san Templo kun niwhatug nan nanterwhasuwana as osaay pachi san Templo. ");
INSERT INTO kyb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sikuchay nan o'oon chanan papachi nan mangwhiwhinnunutcha gwot sa'ad as Zacarias nahunut as lumno' san ingkagwan Apudyus san chayo' nan Templo as mamuur san insenso. ");
INSERT INTO kyb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kun anna chanan chachama takuway mallugwayugwayu san pagway san annaay mapuppuuyan nan insenso. ");
INSERT INTO kyb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kun nampaila an sija nan anghel Apudyus gway summi'ad san machigwanan nan chachattunan gway pupuuyan san insenso. ");
INSERT INTO kyb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kun na'ogjay as Zacarias san nangilana say anghel gwot ummogjat. ");
INSERT INTO kyb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gwon anan chay anghel an sija, “Achi'a umogjat Zacarias, chingngorn Apudyus nan lugwayum. Sa'ad as asagwamay Elisabet umana' as laya'i ad Juan nan ingachannu an sija. ");
INSERT INTO kyb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ad mallaylajad'a ja humayu nan somsomo'nu as amod ad angsan ahos nan mallaylajad san mijana'ana ");
INSERT INTO kyb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tan mangngachan napatog as sija san mangilan Apudyus. Ad maserpu achi kun uminum san whajas ancha ngachamman sinatay humutong. Ad nan Ispilitun Apudyus agwad an sija san mihuhugkiyana. ");
INSERT INTO kyb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ad angsan nan ijIsraelay manulinona an Apu gway Apudyuscha. ");
INSERT INTO kyb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ad umunas sija miwhaun nu san Apu gway agwad nan napigsaay ayobhongana gway isun Elias tot urnusona chanan manaama ja manulinona nan somsomo' chanan achi kun chumngor ta ammancha manomsomo' as isun nan nalintokay taku. Ad mansakanaona chanan taku san umaliyan Apu.” ");
INSERT INTO kyb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kun anan Zacarias say anghel, “Ngachan nan mangakammugwa'ay tuttuwa na tan mangorraka' ja madan ahos as asagwa'?” ");
INSERT INTO kyb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kun anan chay anghel, “Sa'on as Gabriel gway anna nan ayobhonga' gway nerpu an Apudyus. Ingwhauna' an Apudyus ta iwhaka' ja ipaakammu' an si'a nannaja Whayuway Chamag. ");
INSERT INTO kyb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chongyom na, achi'a kun ma'akinga ingkana san chimpuway ma'gwaan nannaja kapu tan achim pun tinuttuwa nan ingwhaka' gway ma'gwa nu miwhatug nan chimpuna.” ");
INSERT INTO kyb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Anna kunay manuullay chanan taku san lumagwaan Zacarias mataagcha tan patho' ekas sija iingkaw san ingkagwan Apudyus san chayo' nan Templo. ");
INSERT INTO kyb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gwot lumagwa kus sija achi kun ma'akinga kun impapagwatnaay na'aapapat an chicha, sija nan inakammuchaay agwad nan inilana gway nerpu an Apudyus ad chayo'. Ad manipud san sachi sissija achi kun ma'akinga as sija. ");
INSERT INTO kyb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nappung kunan whatangna san Templo aysan ad ugwacha. ");
INSERT INTO kyb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaan kun meerkagwanan nahukis asagwanaay Elisabet gwot nalluyu'u' ad ugwacha san lima huyan. ");
INSERT INTO kyb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kun anana, “Anunu ku chadlu tinuliliya' an Apudyus. Inaanna nan miwhawhaina' sasan taku.” ");
INSERT INTO kyb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mi'anom huyan kusan hukin Elisabet ingwhaun Apudyus nan anghel gway as Gabriel ad Nazaret gway osa ilid Galili ");
INSERT INTO kyb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","san osa whawhallasay chaan pabog gway ni'awherjan san osa laya'iyay mangngachan Josep gway nerpu san kana' Dabid. Ad sa'ad nan ngachan nan whawhallasanna Maria. ");
INSERT INTO kyb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kun ummoy nan anghel an Maria kun anana, “Ininon nan whijagnu! Impailan Apudyus nan inawhayuna an si'a! Agwad as Apudyus an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Gwon nakuyu nan somsomo' Maria san ingwhakan chay anghel kun anana san somsomo'na, “Ngachamma pijaon nina anan?” ");
INSERT INTO kyb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kun anan chay anghel an sija, “Achi'a umogjat Maria, piyan'a tan si'a nan pinilin Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chongyom na! Mahuki'a ad iyana'nu nan laya'i ad nginadnam as sija as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Sa'ad as sija mangngachan napatog ja mangngachan as sija Ana' nan Angatuwan. Ad man'aliyon Apudyus as sija as isun Dabid gway nerpugwana. ");
INSERT INTO kyb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ad sija nan man'alin chanan kana' Jacob as ingkaingkana. Ad sa'ad nan mantuyajana maid kun mappungana.” ");
INSERT INTO kyb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kun anan Maria san anghel, “Ininonma ninaay ma'gwa ama' agwad nanghog an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kun summungwhat nan anghel gway manggwana an sija, “Umali an si'a nan Ispilitun Apudyus ad sa'ad nan ayobhongan nan Angatuwanay Apudyus isun nan hunot gway mangichung an si'a. Sija nan sa'ad nan ijana'nuway maid kun whersuna maagwakan as sija as Ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Somsom'om as Elisabet gway chokam gwot inghukina nan ana' gway laya'i gway nan madan as sija. Kun mi'anom huyan nan hukina san sana gway nan ma'gwaniyon whasig as sija. ");
INSERT INTO kyb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tan maid kun achin Apudyus ma'gwa.” ");
INSERT INTO kyb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kun anan Maria, “Annajas sa'on gway mudchachun Apudyus. Ma'gwa an sa'on nan losanay ingwhakam.” Kun aysan nan anghel. ");
INSERT INTO kyb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Neerkagwanan kun lummiggwat as Maria gwot ina''agwaynaay ummoy nangwhaat san osa ili san ilid Judea gway whibilig. ");
INSERT INTO kyb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hummu'nag kun nilumno' san hoyoy cha Zacarias gwot kiningaana as Elisabet. ");
INSERT INTO kyb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chingngorn kun Elisabet nan kingan Maria nangkichu chay ana' san husugna. Kun ummoy nan Ispilitun Apudyus an Elisabet. ");
INSERT INTO kyb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kun tinowhagna nan kingana an Maria gway manggwana, “Piyan'a san losanay huwhai ja piyan nan ana' gway ijana'nu. ");
INSERT INTO kyb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ngachamma inatataku'ay umaliya' lagwaon san inan nan Apu'? ");
INSERT INTO kyb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tan chingngor' kun ekay kingam nangkichu san lagsa'na nan ana' san husug'u. ");
INSERT INTO kyb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Piyan'a tan namati'aay ma'gwa nan ingwhakan Apudyus an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kun anan Maria, “Chaychajagwon nan somsomo''u as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Amod nan lagsa''u kapu an Apudyus gway Manaku an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tan simsimmo'nas sa'onay mudchachu gway nawhawha nan saadna. Ad malluki san sana anan nan losanay lunap an sa'onon piyan nan whijag'u ");
INSERT INTO kyb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kapu san amochay mataakan gway inggwan nan Apigsaanay Apudyus an sa'on. Tuttuwa machaychajaw as Sija gway maid kun mijisugwana. ");
INSERT INTO kyb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ad nan achakuna ipailana an chichaay manchajaw an sija ingkana san mansinu'nub gway lunapcha. ");
INSERT INTO kyb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inggwana nan amochay mataakan kapu san ayobhongana. Sinibsibta'na chanan nangangatu nan somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Impawhawhana chanan papangat san tuyaycha kun impangatuna nan saad chanan nawhawha. ");
INSERT INTO kyb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sa'ad chanan mawhiwhittil inatchana chicha sasan whayu ingkanas nangopcha, kun sa'ad chanan whawha'nang pinerjawna chicha gway namu'yungawcha. ");
INSERT INTO kyb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Whinadngana chanan takunaay ijIsrael as manomsom'ana san achakuna an chicha, ");
INSERT INTO kyb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isun nan ingwhawhagkana sasan nerpugwan ta'u gway Abraham ja chanan kana'na as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iningkaw as Maria an Elisabet as takangay matuyunghuyan asiyot lumajawa' ugwacha. ");
INSERT INTO kyb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Niwhatug kunan umana'an Elisabet iyana'na nan laya'i. ");
INSERT INTO kyb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kun chingngorn chanan cherragna ja chochogkana gway impailan Apudyus nan amod gway achakuna an sija kun na'ayagsa'cha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gwot mi'agwayu kus erkawna chay ana' ummoycha san manuglitancha an sija kun ngadnancha otjan chay ana' as Zacarias gway ngachan amana. ");
INSERT INTO kyb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gwon anan inana, “Wha'on! Juan nan mingachan an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kun anancha an sija, “Maid kun osa sasan chochogkajus mangngachan amasnat.” ");
INSERT INTO kyb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gwot impapagwatcha san imacha an Zacarias nu ngachan nan whayugwona mingachan san ana'na. ");
INSERT INTO kyb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nan'ochaw kus sija as mallistaana, illistanaay “Juan nan ngachanna.” Kun nataagcha losan. ");
INSERT INTO kyb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sachi kun nakaninga as sija kun nanapapat gway nanchaychajaw an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kun ummogjat losan chanan cherragcha ad san losanay whibilig gway ili san Judea sija ekay ana'anancha nan mipangkop sannaja na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ad nan losanay nangngor simmosimmo'cha gway manggwana, “Ngachan nin nan ma'gwaan nannaja ana'?” Tan agwad an sija as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ad sa'ad as Zacarias gway amana ummoy nan Ispilitun Apudyus an sija kun ingwhakana ananon, ");
INSERT INTO kyb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Machajaw as Apudyus gway Apudyus chanan ijIsrael kapu tan ummalina whinadngan ja gwinajagwajaan chanan takuna. ");
INSERT INTO kyb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kun nangipaalis sija as apigsaanay Manaku an chita'u gway nerpu san kana' Dabid gway mansilsilwhiyona. ");
INSERT INTO kyb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Impaiwhakan Apudyus sasan mangikakadto'ay mansilwhi gway profetana san agwi ");
INSERT INTO kyb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","gway takuwona chita'u sasan ahursu ta'u ja san pigsan chanan losanay mangisil an chita'u. ");
INSERT INTO kyb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta ipailana nan achakuna gway ingwhawhagkana sasan nerpugwan ta'u ja tungpayona nan tuyagna gway maid kun lagwing as pangkopna. ");
INSERT INTO kyb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sachi nan ingwhawhagkanaay intuyagna an Abraham gway nerpugwan ta'u ");
INSERT INTO kyb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tot sa'ad san nanakuwana an chita'u san pigsan chanan ahursu ta'u, ijujanaay maid ogjat ta'uway mansilwhi an sija. ");
INSERT INTO kyb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mansilwhi ta'u an sija gway maid kun ma'gwaniyan ja nalintog san mangilana an chita'u sannaay matattakuwan ta'u.” ");
INSERT INTO kyb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kun intuyuy Zacarias gway manggwanaon, “Ad sa'ad as si'aay ana''u anna, maagwakan'as profetan nan Angatuwanay Apudyus tan umununa'a nu nan Apu ta isakanam nan ajona, ");
INSERT INTO kyb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ta ipaakammuna nan matakuwan chanan takuna kapu san malligwatana sasan whersucha. ");
INSERT INTO kyb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kapu san lajad ja achakun Apudyus an chita'u ipaalina gway merpud langit nan Mesias gway manaku an chita'u gway mijagwat san init gway chumungit. ");
INSERT INTO kyb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Umalis sija tot padchaana chanan iingkaw san manghulingot gway umogjat san otoy ja tot ichayanna chita'u san whayuway somsomo' gway maid kun machanakan.” ");
INSERT INTO kyb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kun sa'ad chay ana' chumma'or ja nasom'an ja pummigsa nan pammatina. Iniingkaw as sija san luta gway maid kun ingkaw as taku ingkana san chimpuway nampaila sasan ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sa'ad san sachi nijana'an Juan nanggwas Emperador Agusto as lintog ta mampalista nan lamangay taku san losanay ili gway sa'up nan Roma. ");
INSERT INTO kyb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Annaja nan chamchamu nampalistaan chanan taku san Kirenio nan kuwhinnachur ad Siria. ");
INSERT INTO kyb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kun losanay taku ummoy nampalista san gwaschi ilina. ");
INSERT INTO kyb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kun lummiggwat ahos as Josep ad Nazaret gway osaay ilid Galili kun ummoy san ilin Dabid ad Betlehem ad Judea tan kana' Dabid as sija. ");
INSERT INTO kyb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huyunna ummoy nampalista as Maria awherjanna gway mahuki. ");
INSERT INTO kyb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ad sa'ad san agwachanchad Betlehem niwhatug nan chimpu gway umana'ana. ");
INSERT INTO kyb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kun iyana'na nan panguyu ana'na gway laya'i kun inagjana san luput asinaot ipabog san atutung kapu tan maid kun ikawcha san manchachawsan. ");
INSERT INTO kyb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ad sa'ad san sachiyay ili agwad chanan mampaspastur san puyag gway mangijaachug sasan kernerocha san sachiyay lawhi. ");
INSERT INTO kyb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ad sa'ad nan anghel nan Apu nampaila an chicha ad sa'ad nan inachajaw nan Apu nilinangana chicha gwot amod nan ogjatcha. ");
INSERT INTO kyb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kun anan chay anghel an chicha, “Achi aju umogjat tan anna iyali' nan Whayuway Chamag an cha'aju gway sija nan mampayagsa' as amod san losanay taku. ");
INSERT INTO kyb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","San sana lawhi san ilin Dabid, nijana' nan manaku an cha'aju. Sija nan Kristu gway Apu! ");
INSERT INTO kyb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ad annaja nan mangimatunanju gway mailaju nan ana' gway na'agjan san luput gway nipabog san atutung.” ");
INSERT INTO kyb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sachi kun maag ekay nampaila ad langit nan adadchuwanay anghel gway huyun chay anghel gway mangichaychajaw an Apudyus gway ananchaon, ");
INSERT INTO kyb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Machaychajaw nan Apudyus gway agwad san angatuwanay langit ja sa'ad ad asna luta maid kun machanakan chanan taku gway masomana!” ");
INSERT INTO kyb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nanulin kun chachay a'anghel ad langit asi'a'anan chachay mampaspastur san gwaschi osa an chicha, “Inta'ud Betlehem ilan nan na'gwa gway impaakammun nan Apu an chita'u!” ");
INSERT INTO kyb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kun ina''agwaychaay ummoy kun inchasancha cha Maria an Josep ja nan ana' gway inuumhog san atutung. ");
INSERT INTO kyb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Inilacha kun chi ingwhakacha an chicha chay ingwhakan nan anghel mipangkop san ana'. ");
INSERT INTO kyb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kun nataag nan losanay taku nangngor san ingwhakan chachay mampaspastur. ");
INSERT INTO kyb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gwon sa'ad as Maria iniingngatana losan nannachaja gway sosom'ona chachi. ");
INSERT INTO kyb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kun nanulin chachay mampaspastur gway nanchaychajaw an Apudyus ja inchaychajawcha nan inawhayuna kapu san losanay chingngorcha ja inilacha tan sachi nan ingwhakan nan anghel an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mi'agwayu kun san erkaw chay ana' san chimpuway manuglitancha an sija, nangadnan as sija as Hesus. Sijana nan ngachan gway inatod nan anghel san chaanna mihukiyan. ");
INSERT INTO kyb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hummu'nag kunan chimpuway mampachayusan cha Josep an Maria gway sija nan anan nan lintog Apudyus an Moses, ummoycha ad Jerusalem tot ipailacha an Apudyus ");
INSERT INTO kyb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","tan nilista san lintog Apudyus gway anana, “Losanay umuna mijana'ay laya'i miwhilang as ugwan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kun nanchatuncha hos san anan nan lintog Apudyus, “Chugwa whayug gwinnu chugwa man'amernus gway kalapati.” ");
INSERT INTO kyb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sa'ad sa sachi erkaw iningkaw nan osa taku ad Jerusalem gway mangngachan Simon gway nalintog ja anna nan ogjatna an Apudyus. Uullajona nan manaku sasan ijIsrael ad sa'ad nan Ispilitun Apudyus agwad an sija. ");
INSERT INTO kyb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Impaakammun nan Ispilitun Apudyus an sija gway achi kun matoy as sija ingkana mailana nan Kristu gway ingwhawhagkan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ad kapu san Ispilitun Apudyus gway nangipujut an sija nilumno' as Simon san Templo. Ummoy kun chachay sinana' an Hesus san Templo ta ooncha an sija nan anan nan lintog, ");
INSERT INTO kyb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","iningkaw as Simon kun whina'gwerna chay ana' kun nanchajaw an Apudyus gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apudyus, san sana tan na'gwa nan ingwhakam an sa'on ijujam nannaja mansilsilwhi an si'a gway matoy gway maid kun machanakana. ");
INSERT INTO kyb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tan inila' chadlu nan manaku sasan taku ");
INSERT INTO kyb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","gway insakanam tot ilan nan losanay taku. ");
INSERT INTO kyb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mijagwat as sija san silaw gway mangipaakammu san mipangkop an Apudyus sasan wha'on kus Hudyu ja kapu an sija mapachajagwan chanan takum gway ijIsrael.” ");
INSERT INTO kyb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kun nataag nan sinana' an Hesus san ingwhakan Simon san mipangkop an sija. ");
INSERT INTO kyb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kun ingwhakanaay pawhayugwon Apudyus nan whijagchaay sinana' an Hesus kun anana an Maria, “Chongyom na, sa'ad nannaja ana' chinutu'an Apudyus gway sija nan kapun nan lumagwingan ja matakuwan nan angsanay ijIsrael. Sija ahos nan imatun gway lagwingon nan angsanay taku. ");
INSERT INTO kyb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ipayosgwana nan nitatayuway somsomo'cha. Ad sa'ad as si'a amod nan sasangam.” ");
INSERT INTO kyb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Sachi kun sa'ad nan osa profetaay huwhai ummoy ummachayug an chicha. Sa'ad nan ngachanna as Ana gway ana' Fanuel gway kana' Aser. Pitun tagwon nan nanaassawwancha an asagwana kun nawhayus sija ingkanas gwayumpuyu ja opat nan tagwonna. Sijasija umoy san Templo gway manchajaw an Apudyus san inerkaw ja nilawhi gway nadnachi mallugwayu ja mallaun. Nanjaman as sija an Apudyus kapu san ana'ay Kristu kun ingwhakana nan mipangkop san ana' san losanay manuullay san Mesias gway umali ta gwajagwajaana nan ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nappung kun cha Josep an Maria inggwa nan losanay anan nan lintog Apu, nanulincha san ilichaay Nazaret ad Galili. ");
INSERT INTO kyb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chumma'or nan ana'ay as Hesus kun pummigsa ja lummaing kun pinawhayun Apudyus nan whijagna. ");
INSERT INTO kyb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinagwonay umoy nan sinana' an Hesus ad Jerusalem san pijasta gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nasagwayan kus chugwa nan tagwon Hesus ummoycha na'apijasta tan sija nan sikud gway o'ooncha san ukalicha. ");
INSERT INTO kyb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nappung kunan pijasta san lummajagwancha nanto'chay as Hesus ad Jerusalem gway maid akammun chanan sinana' an sija. ");
INSERT INTO kyb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Anancha kunnu agwad san huyogcha sija nan inerkawcha manadchadchayanay lumajaw. Awni kun iyukudcha as sija sasan chochogkacha ja huhuyuncha. ");
INSERT INTO kyb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Maid kun inchasancha an sija, nanulincha ad Jerusalem gway mangijukud an sija. ");
INSERT INTO kyb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mi'atlu kun gway erkaw inchasancha as Hesus san Templo gway ma'atu'tu'chu sasan mimistuyun nan lintog gway manchochongngor ja manimiimus an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kun losan nan nanchongor an sija nataag san sungwhatna ja inalaingna. ");
INSERT INTO kyb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inilan kun cha amana an inana as sija nataagcha. Kun anan inana, “Ana''u, kamman oon nan amasna an cha'ami? Amod nan chanagmi gway mangijukuukud an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kun anana an chicha, “Kajuman anaanapon as sa'on? Jo'o achiju akammu gway maserpu ingkagwa' san hoyoy Ama?” ");
INSERT INTO kyb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jon achicha kun naagwatan nan sungwhat Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gwot nihuyog as Hesus an chichaay lummajaw ad Nazaret kun pinatina nan losanay ingwhakacha. Kun sisimmo' inana nannachaja losanay na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kun chumma'or kus Hesus ja lummaing nasom as Apudyus ja chanan taku an sija. ");
INSERT INTO kyb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sa'ad san mi'asergwa as limaay tagwon san nantuyajan Emperador Tiberio, as Poncio Pilato nan kuwhinnachur ad Judea kun as Herod nan mangituyay ad Galili ja as sunudnaay Felipe nan mangituyay ad Ituria ja Traconite. Kun as Lisanias nan mangituyay ad Abilene. ");
INSERT INTO kyb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Cha Anas an Caifas nan angatuwanay pachi san sachi chimpu. Kun impaakammun Apudyus nan ukudna an Juan gway ana' Zacarias san luta gway maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gwot ummoy as Juan san losanay ili gway nampali'gwos san gwanggwangay Jordan kun impaakammuna sasan taku gway manchu'kancha chanan whersucha ad nampahonjagcha tot ligwatan Apudyus nan losanay whersucha. ");
INSERT INTO kyb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa'ad nan inggwan Juan sija nan nilista san nibyun profeta Isaias gway anana, “Agwad nan osa mampa'upa'uy san luta gway maid kun ingkaw as taku gway ananaon, ‘Isakanaju nan ajon nan Apu! Pawhayugwonju nan manadchayanana! ");
INSERT INTO kyb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Maserpu maawhab losan nan challug, mapanad losan nan whilig, malinchong nan nanti''urti''urray chayan ja maamamma''an nan napillapillau'anay ersa. ");
INSERT INTO kyb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ad nailan nan losanay taku nan manakuwan Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Anana san amochay takuway ummoy an sija nampahonjag, “Nasi'ap aju gway isun chanan uyog, ngachan nan nangiwhaka an cha'ajuway malisiyanju nan umaliyay manusaan Apudyus nu achiju manchu'kan nan whersuju? ");
INSERT INTO kyb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Maserpu ipailaju san kidkichujuway tuttuwa nanchu'kanju chanan whersuju. Ad achiju somsom'on gway achi cha'aju chusaon kapu san ananjuwon kana' cha'aju an Abraham. Tan iwhaka' an cha'aju gway uyay nannachaja whatu ma'gwaay oon Apudyus as kana' Abraham. ");
INSERT INTO kyb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na'asakana as Apudyus gway manusa san taku nu achicha manchu'kan nan lagwingay o'ooncha, isun nan taku gway na'asakanaay mangikupung san gwasayna san lamut nan aju. Ad losanay aju gway achi kun humkas as whayu makupung ad niwhallu san apuy.” ");
INSERT INTO kyb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kun anan nan amochay taku, “Ngachan maangkay oonmi?” ");
INSERT INTO kyb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kun anan Juan gway summungwhat an chicha, “Nu ngachan nan chugwa nan silupna atchona nan osa san maid silupna. Ad nu ngachan nan anna anona maserpu hosay mangatod.” ");
INSERT INTO kyb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kun ummoy nan uchumay manchachakup san hugwis tot mampahonjagcha an Juan kun anancha an sija, “Mistuyu, ngachan nan oonmi?” ");
INSERT INTO kyb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kun anana an chicha, “Achiju labson nan singilonju nu san ustuway masingil.” ");
INSERT INTO kyb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kun nanimus ahos nan uchumay susurchachu an sija gway manggwana, “As cha'ami kay, ngachan nan oonmi?” Kun anana an chicha, “Achiju piliton ayan nan pila' nan taku gwinnu achiju pawhasuyon nan taku nu maid atuttugwaana. Mapno' aju san labhuju.” ");
INSERT INTO kyb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kun pummigsa nan namnaman chanan taku kun losancha nanommosommo' tan anancha kunnu as Juan nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Anan Juan gway summungwhat an chicha losan, “Honjaka' cha'aju san chanum gwon agwad nan osa umaliyay nangatngatu an sa'on. Achiya' kun miwhilang as mansilwhi an sija uyay mangaan san sinilasna. Honjakana cha'aju san apuy gway Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ad nu umali ichersinna nan whayuway taku san lagwing gway isun nan takuway anna nan ayay'aynaay mallaid san chakami san kerkergwit. Igkana san ayangna nan kerkergwit gwon sa'ad nan chakami puuyana san apuy gway achi kun mapatajan.” ");
INSERT INTO kyb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Amasna ja angsan nan in'aman Juan gway nampapigsa san somsomo'cha san nangipaakammugwana san Whayuway Chamag sasan taku. ");
INSERT INTO kyb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Ad sa'ad as kuwhinnachur Herod gway patinajun gway amujuwan Juan san mipangkop an Herodias gway asagwan nan sunudna ja mipangkop sasan lagwingay o'oona, chinogwana nan lagwingay o'oona san nangiwhayuchana an Juan. ");
INSERT INTO kyb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sa'ad san chaan mawhayud as Juan san namonjakana sasan taku nahonjakan ahos as Hesus. Anna kunay mallugwayugwayu as Hesus niibwhat nan langit. ");
INSERT INTO kyb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kun ummoy inumpa nan Ispilitun Apudyus gway isun chi kaob nan kalapati an sija. Ad iningkaw nan kingaay nerpud langit gway manggwana, “Si'a nan ana''uway ipatpatog'u, mamasoma' an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sa'ad as Hesus ummoy as tuyumpuyu nan tagwonna san nangilukijanaay mansuyu. Ad nan somsomo' chanan taku ana' Josep as sija gway ana' Eli, ");
INSERT INTO kyb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ad sa'ad as Eli ana' Matat, sa'ad as Matat ana' Levi, sa'ad as Levi ana' Melki, sa'ad as Melki ana' Jannai, sa'ad as Jannai ana' Josep, ");
INSERT INTO kyb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","sa'ad as Josep ana' Matias gway ana' Amos, sa'ad as Amos ana' Nahum, sa'ad as Nahum ana' Esli gway ana' Nagi, ");
INSERT INTO kyb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","sa'ad as Nagi ana' Maat gway ana' Matatias, sa'ad as Matatias ana' Semei, as Semei ana' Josep gway ana' Juda. ");
INSERT INTO kyb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sa'ad as Juda ana' Joanan, sa'ad as Joanan ana' Resa gway ana' Zerubabel, sa'ad as Zerubabel ana' Sealtiel, sa'ad as Sealtiel ana' Neri. ");
INSERT INTO kyb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sa'ad as Neri ana' Melki, sa'ad as Melki ana' Adi, sa'ad as Adi ana' Cosam, sa'ad as Cosam ana' Elmadam, sa'ad as Elmadam ana' Er, ");
INSERT INTO kyb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","sa'ad as Er ana' Josue, sa'ad as Josue ana' Eliezer, sa'ad as Eliezer ana' Jorim, sa'ad as Jorim ana' Matat, sa'ad as Matat ana' Levi, ");
INSERT INTO kyb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","sa'ad as Levi ana' Simeon, sa'ad as Simeon ana' Juda, sa'ad as Juda ana' Josep, sa'ad as Josep ana' Jonan, sa'ad as Jonan ana' Eliakim, ");
INSERT INTO kyb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","sa'ad as Eliakim ana' Melea, sa'ad as Melea ana' Mena, sa'ad as Mena ana' Matata, sa'ad as Matata ana' Natan, sa'ad as Natan ana' Dabid, ");
INSERT INTO kyb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","sa'ad as Dabid ana' Jesse, sa'ad as Jesse ana' Obed, sa'ad as Obed ana' Boaz, sa'ad as Boaz ana' Salmon, sa'ad as Salmon ana' Naason, ");
INSERT INTO kyb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","sa'ad as Naason ana' Aminadab, sa'ad as Aminadab ana' Arni, sa'ad as Arni ana' Ami, sa'ad as Ami ana' Esron, sa'ad as Esron ana' Fares, sa'ad as Fares ana' Juda, ");
INSERT INTO kyb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","sa'ad as Juda ana' Jacob, sa'ad as Jacob ana' Isaac, sa'ad as Isaac ana' Abraham, sa'ad as Abraham ana' Tare, sa'ad as Tare ana' Nacor, ");
INSERT INTO kyb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","sa'ad as Nacor ana' Serug, sa'ad as Serug ana' Reu, sa'ad as Reu ana' Peleg, sa'ad as Peleg ana' Heber, sa'ad as Heber ana' Selah, ");
INSERT INTO kyb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","sa'ad as Selah ana' Cainan, sa'ad as Cainan ana' Arfaxad, sa'ad as Arfaxad ana' Sem, sa'ad as Sem ana' Noe, sa'ad as Noe ana' Lamec, ");
INSERT INTO kyb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","sa'ad as Lamec ana' Metusela, sa'ad as Metusela ana' Enoc, sa'ad as Enoc ana' Jared, sa'ad as Jared ana' Mahalaleel, sa'ad as Mahalaleel ana' Cainan, ");
INSERT INTO kyb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","sa'ad as Cainan ana' Enos, sa'ad as Enos ana' Set, sa'ad as Set ana' Adam sa'ad as Adam ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anna kunay ummoy iningkaw an Hesus nan Ispilitun Apudyus lummajaw as sija san gwanggwangay Jordan kun impujut nan Ispilitun Apudyus as sija san luta gway maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ad san opat puyuway erkaw sinulisukan Satanas as sija. San sachiyay chimpu achi kun nangnangan as Hesus sija nan nawhitil as sija san nappung nan sachi. ");
INSERT INTO kyb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kun anan Satanas an sija, “Nu si'a nan Ana' Apudyus iwhakam sannachaja whatu ta mangngachancha tinapay.” ");
INSERT INTO kyb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kun summungwhat as Hesus gway manggwana, “Nilista san Ukud Apudyus gway anana, ‘Wha'on kus ahus nan tinapay as i'atakun nan taku.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sachi achot iyoy Satanas as Hesus san nangatuway whilig maagna ekay impaila an sija nan losanay mantuyajan san luhung. ");
INSERT INTO kyb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kun anan Satanas an Hesus, “Atcho' an si'a nan losanay ayobhongan gway mangituyay sannachaja ja nan losanay ina'erjadcha tan naatod chana losan an sa'on ad mawhalin'uway atchon san whayugwo'ay mangatchan. ");
INSERT INTO kyb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ad nu mampalintumong'aay manchajaw an sa'on man'ugwam losan chana.” ");
INSERT INTO kyb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kun summungwhat as Hesus gway manggwana, “Nilista san Ukud Apudyus gway anana, ‘As Apu gway Apudyusnu nan manchajagwam ad ahus as sija as mansilwhiyam!’ ” ");
INSERT INTO kyb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Awni kun iyoy Satanas as Hesus ad Jerusalem kun impasi'adnas sija san tu'tu' nan Templo kun anana an sija, “Nu si'a nan Ana' Apudyus lumajug'a sanna. ");
INSERT INTO kyb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tan nilista san Ukud Apudyus gway anana, ‘Sa'ad chanan a'anghel Apudyus whilinona chicha san mipangkop an si'a tot whantajan cha'a.’ ");
INSERT INTO kyb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Anana hos, ‘Tapajaon cha'a san imacha tot achi chanan i'im miserser san whatu.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kun summungwhat as Hesus gway manggwana, “Anan nan Ukud Apudyus, ‘Achim sulisukon nan Apu gway Apudyusnu.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sachi kunay inamin Satanas pachason nan losanay mawhalinna isulisug an Hesus tinaynana as sija ingkanas agwad chimpuna asin. ");
INSERT INTO kyb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kun nanulin as Hesus ad Galili gway anna an sija nan ayobhongan nan Ispilitun Apudyus. Kun nanchinamag nan mipangkop an sija san ailiili san sachiyay ili. ");
INSERT INTO kyb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kun nansuyusuyus sija sasan sinagoga gwot chinaychajaw nan losanay taku. ");
INSERT INTO kyb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kun ummoy as Hesus ad Nazaret san iliyay chumma'yana. Gwot nilumno' san sinagoga san Erkaw gway Umillongan tan sija nan ukalina. Kun summi'ad gway mamasa san Ukud Apudyus ");
INSERT INTO kyb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","gwot inatodcha an sija nan nayu'utay papil gway illistan profeta Isaias. Kun whinitwhitna nan nayu'utay papil gwot inchasana nan nisuyatan nan ananaon: ");
INSERT INTO kyb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anna an sa'on nan Ispilitun Apudyus tan chinutu'anas sa'on as mangiwhaka san Whayuway Chamag sasan whawha'sigwot. Ingwhauna' as mangipaakammu sasan whayud gway magwajagwajaancha ancha ma'aila chanan na'uyap ja tot magwajaan chanan milaylajusan. ");
INSERT INTO kyb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ja ta ipaakammu' ahos gway humu'nag nan chimpuway mangipailan Apudyus san manakuwana sasan takuna.” ");
INSERT INTO kyb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kun nilu'ut Hesus nan papilay nilistaan nan Ukud Apudyus kun inatodna insubli san mansilsilwhi san sinagoga kun tummu'chuway nansuyu. Kun losanay taku san sinagoga intotollongcha as sija. ");
INSERT INTO kyb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kun anana an chicha, “San sana erkaw tummuttuwa nan annaja niwhasaay Ukud Apudyus gway chingngorju.” ");
INSERT INTO kyb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kun losanay nangngor an sija nasomcha an sija ja nataagcha san inawhayun nan inukudna kun anancha, “Tan ana' kayna Josep ja.” ");
INSERT INTO kyb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kun anana an chicha, “Maid kun chugwachugwanaay iwhakaju an sa'on nan amasnaay apapat, ‘Chu'tur, akasam nan longagnu! Losanay chingngormiyay na'gwa ad Capernaum oom ahos ad asna gway ilim.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Innanana hos, “Tuttuwa iwhaka' an cha'aju, maid kun profeta as michajaw san ilina. ");
INSERT INTO kyb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gwon nan inatuttugwaana iwhaka' an cha'aju gway angsan chanan nawhayu ad Israel san chimpun Elias san achina kun ummuduchanan san tuyu ja koggwaay tagwon san iningkagwan nan amochay uyat san losanay luta. ");
INSERT INTO kyb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gwon maid ku an chicha nan niwhaunan Elias, ahus san osa nawhayu ad Sarepta san ilid Sidon. ");
INSERT INTO kyb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ja angsan nan naleprosi ad Israel san chimpun Eliseo gway profeta, maid kun hummayu as osa an chicha ahus ekas Naaman gway iSiria as hummayu.” ");
INSERT INTO kyb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chingngorn ad chanan taku san sinagoga nannaja nalingucha as amod. ");
INSERT INTO kyb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kun summi'adchaot pinerjawcha as Hesus san lasin nan ili san ikid nan whilig gway nipata'choyan nan ili tot otchakonchas sija. ");
INSERT INTO kyb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gwon nangoy kusan hoyaat nan amochay taku aysan as sija. ");
INSERT INTO kyb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kun nanosog as Hesus ad Capernaum gway osa ilid Galili. Kun nansuyu sasan taku san Erkaw Gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kun nataagcha losan tan anna nan ayobhongan nan insussuyuna. ");
INSERT INTO kyb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ad sa'ad san sinagoga iningkaw nan osa laya'iyay nilno' nan chimunju kun inip'awna gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oy! Kamma whijawhijangan cha'ami Hesus gway iNazaret? Umalim tangkaan cha'ami? Akammu' si'a! Si'a chay maid kun whersuna gway ingwhaun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Gwon impakino' Hesus nan chimunju gway manggwana, “Kumino''a, lumajaw'a san sanatay taku!” Gwot impatug kunan chimunju nan sachi taku san sangucha losan, tinaynana nanchi laya'i gway achina kus sija jinaman. ");
INSERT INTO kyb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kun nataag losan nan taku kun asi'a'anancha san gwaschi osa an chicha, “Sima ayasin nan apapat nina? Anna nan ayobhongana ja pigsana mamerjaw sasan chimunju ad lummajawcha!” ");
INSERT INTO kyb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kun nanchinamag nan mipangkop an Hesus san gwaschi ili gway mampali'gwos. ");
INSERT INTO kyb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lummajaw kus Hesus san sinagoga ummoy san hoyoy Simon. Ad sa'ad nan atukangan Simon gway huwhai amod nan atungna kun ingwhakacha an Hesus ta pawhayugwona as sija. ");
INSERT INTO kyb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gwot ummachayug kus Hesus summi'ad san cherragna kun ingwhakanaay ma'aan nan atungna kun na'aan nan atungnaot nawhanangon kun pina'anana chicha. ");
INSERT INTO kyb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mummaschom pun losanay anna huyunna nasa'it san whayangna ayasin nan sa'it, iyoycha an Hesus. Kun inognana nan gwaschi osa an chicha gwot hummayucha. ");
INSERT INTO kyb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pinerjawna hos chanan chimunju san angsanay taku. Kun nampa'uy chanan chimunjuway manggwana, “Si'a nan Ana' Apudyus!” Gwon impakino'na chicha ja achina kun iyujaay kumingacha tan akammucha gway sija nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gwisnit kunot lummajaw as Hesus san sachi ili ummoy as sija san maid tagtaku. Kun inanaanap nan takus sija kun ummoycha an sija gwot tinagwichancha ta achi lumajaw. ");
INSERT INTO kyb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gwon anana, “Maserpu ipaakammu' nan Whayuway Chamag gway mipangkop san mantuyajan Apudyus san uchum ahosay ili kapu tan sijana nan nangiwhaunan Apudyus an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kun intuyuynaay nangipaakammu san Whayuway Chamag sasan sinagoga san ailiilid Judea. ");
INSERT INTO kyb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","San osa erkaw summisi'ad as Hesus san ikid nan whaywhay ad Genesaret. Nantu'tu'jud gway umoy nan angsanay taku an sija kun nanchongorcha san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kun inilana nan chugwa whang'a san ikid nan whaywhay gway tinaynan chanan mangii'an gway ummoycha whinawhayan nan akaidcha. ");
INSERT INTO kyb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Namang'a kus Hesus san osa whang'a gway whang'an Simon, ingwhakana an sijaay ipakagwanas a'it. Kun tummu'chu as Hesus san whang'a gwot nansuyu sasan taku. ");
INSERT INTO kyb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nappung kus sija nansuyu anana an Simon, “Ipooynu nan whang'a san achayo' ad ingkaobju san huhuyunnu nan akaidju ta agwad ayanju.” ");
INSERT INTO kyb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kun anan Simon gway summungwhat, “Apu, nilabyawhimi nangakaid gwon maid kun inayami. Gwon kapu tan ingwhakam ikaob'u nan akaid.” ");
INSERT INTO kyb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ingkaobcha kun amod nan inayachaay i'an kun takangay mawhis'i nan akaidcha. ");
INSERT INTO kyb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kun pinaypajancha nan huhuyuncha gway agwad san uchumay whang'a tot umoycha whadngan chicha. Gwot ummoycha kun inggwaancha nan chugwa whang'a gwot mallukicha malinong. ");
INSERT INTO kyb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Inilan kun Simon Pedro nan na'gwa nampalintumong san sangun Hesus kun anana, “Apu, achajugwana' tan humersuwhersuwa'!” ");
INSERT INTO kyb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Amasna nan ingwhakana tan nataag cha Simon Pedro ja uchumay huhuyunna san inaachun nan inakaichancha. ");
INSERT INTO kyb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nataag ahos nan huhuyunnaay cha Santiago an Juan gway anana' Zebedeo. Kun anan Hesus an Simon, “Achi'a umogjat, malluki san sana taku chanan ayusom gway mamatiyom chicha an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Impaikidcha kun san tayantag nan whang'a tinaynancha nan losan kun nitunudcha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sa'ad san iningkagwan Hesus san osaay ili iningkaw nan osa laya'iyay naleprosi. Inilana kus Hesus nampa'yob as sija san sangun Hesus kun nampa'pa''aasi gway manggwana, “Apu, nu whayugwomay pawhayugwon sa'on akammu'ay lobhongnu.” ");
INSERT INTO kyb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kun inognan Hesus chay laya'i gway manggwana, “Whayugwo', humayu'a!” Kun nawhanayu chay laya'i san leprosina. ");
INSERT INTO kyb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kun pinuyung Hesus as sija gway manggwana, “Achim pay iwhagwhaka na san uchum gwon i'a manchachawwos mampaila san pachi ta ilana gway hummayu'a. Manchatun'a nu ngachan nan nisuyu san lintog gway inatod Apudyus an Moses as mangakammugwan chanan taku gway hummayu'a.” ");
INSERT INTO kyb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gwon ummamamod nan'umamag nan mipangkop an Hesus. Kun ummoy nan chachamaay taku nanchongor an sija ja nampaakas san sa'sa'itcha. ");
INSERT INTO kyb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gwon sa'ad as Hesus nadnachi umoy umachaju san maid taku ad nallugwayu. ");
INSERT INTO kyb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Osa kunay erkaw san mansuyuwan Hesus iningkaw chanan uchumay Pariseo ja mimistuyun nan lintog gway natu'tu'chu gway nerpucha san ailiili ad Galili ja Judea ja nerpud Jerusalem. Kun agwad an Hesus nan ayobhongan Apudyus gway mangipawhayu sasan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sachi kun hummu'nag nan uchumay lallaya'i gway nanachangoy san osa napalalais gway inuumhog san oogkana. Kun pachasoncha otjan ijoy ad chayo' san hoyoy tot igkacha san sangun Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sa'ad tan achicha ma'aiperno' say napalalais kapu tan amod nan taku, ummoycha san sahoy nan hoyoy kun ummahutcha san sachi kun iyursuuschas sija san kagwan nan amochay taku san sangun Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Inilan kun Hesus nan pammaticha anana san napalalais, “Sunud, niligwata' chanan whersum.” ");
INSERT INTO kyb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kun asijaajumuum chanan mangaagkammu san lintog ja Pariseo gway manggwana, “Ngachan manan osa takuwanna gway manapapat as maamamangan Apudyus? Ama' agwad sillobhong malligwat san whersu nu achi ahus as Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Akammun Hesus nan agwad san somsomo'cha kun anana an chicha, “Ka'ajuman manomsomo' as amasnat? ");
INSERT INTO kyb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngachan nan lanuy as iwhaka, ‘Niligwata' chanan whersum’ gwinnu ‘Humangon'a ad nanadchayan'a’? ");
INSERT INTO kyb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ta maakammugwanjuway sa'ad as sa'on gway Ana' nan Taku anna nan ayobhonga'ay malligwat san whersu ad asna luta, ilanju nannaja oo'.” Sija nan anana say napalalais, “Iwhaka' an si'a, humangon'a, ayam nan inogkam ad lummajaw'a ad ugwaju!” ");
INSERT INTO kyb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kun nasani'ad chay napalalais san sangucha losan kun inayana nan inogkana kun lummajaw gway nanchaychajaw an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kun nataagcha losanay nangila kun nanchaychajawcha an Apudyus. Kun ummogjatcha losan gway manggwana, “Inila ta'u nan wha'on kus apapati gway mataakan san sana erkaw!” ");
INSERT INTO kyb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sachi kun lummagwa as Hesus san hoyoy kun inilana nan osaay manchachakup san hugwis gway mangngachan Levi gway tummutu'chu san sisingngilan san hugwis. Kun anan Hesus an sija, “Tunuchona'.” ");
INSERT INTO kyb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kun lummiggwat as Levi kun tinaynana nan losanot nitunud an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kun pinernusan Levi as Hesus san hoyoyna. Iningkaw ahos nan amochay taku gway mitapi chanan manchachakup san hugwis ja uchum pajay taku gway na'a'an an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kun asingunguchu chanan Pariseo ja huhuyunchaay mangaagkammu san lintog kun anancha sasan pasuyut Hesus, “Ka'ajuman ma'a'an ja ma'iinum sasan manchachakup san hugwis ja chanan humersuwhersu?” ");
INSERT INTO kyb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chingngorn kun Hesus chi iyagwatnaay nanungwhat an chicha gway manggwana, “Sa'ad nan takuway maid sa'itna wha'on kus maserpuna nan manaakas. Sija manserpu san manaakas chanan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wha'on kus sija ummaliya' nan manajaka' sasan whayuway taku, sija ummaliya' nan ajaka' chanan humersuwhersu tot manchu'kancha nan whersucha.” ");
INSERT INTO kyb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Anan chachay Pariseo an Hesus, “Nadnachi mallaun ja mallugwayu chanan pasuyut Juan ancha amasna ahos nan o'oon chanan pasuyut chanan Pariseo kunja kama chanan pasuyutnu achi mallaun?” ");
INSERT INTO kyb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kun summungwhat as Hesus gway manggwanaay nangijagwat, “Jo'o mallaun chanan ma'abyay nu agwad an chicha nan laya'iyay mangibyay? Ay mangancha hos ja! ");
INSERT INTO kyb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ayawniyot humu'nag nan chimpuway milajaw an chicha nan laya'iyay mangibyay ad asichaot mallaun.” ");
INSERT INTO kyb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iyagwat ahos Hesus an chicha gway manggwana, “Maid kun takus mangaya san a''opgwa luput ad inter'upna san chachaanay luput. Tan sa'ad nu amaschi nan oona mawhis'i nan a''opgwa luput ad achi kuhos mijaya san niter'upanaay chachaan. ");
INSERT INTO kyb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ad maid kuhos mangigka san whilung san chachaanay mangiigkaanay kadchang. Tan sa'ad nu amaschi nan oona awni ad hota'on nan whilung nan sachi mangiigkaan ad niwhallu ad natangkaan nan mangiigkaanay kadchang. ");
INSERT INTO kyb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gwon nan whilung sija mangigkaanta nan a''opgwaay mangiigkaanay kadchang. ");
INSERT INTO kyb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ad maid kun mamija san whilung nu mappung mainum nan chachaanay whajas tan anana, ‘Sa'ad nan chachaan pija.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sa'ad san namingsanay Erkaw gway Umillongan nangoy cha Hesus san tayun gway namullan san kerkergwit kun nangkatukatu chanan pasuyutna kun nilalicha san imacha kun inutimancha. ");
INSERT INTO kyb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anan nan uchumay Pariseo, “Kajuman oon nan mijachi san Erkaw gway Umillongan?” ");
INSERT INTO kyb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kun anan Hesus an chicha gway summungwhat, “Jo'o achiju whinasa nan inggwan cha Dabid ja chanan takuna san agwi san nawhitilancha. ");
INSERT INTO kyb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nilumno' as Dabid san hoyoy Apudyus kun nangaya san tinapay gway nichatun an Apudyus kun nangan ta'on nu mijachi san lintog tan ahus chanan papachi as mijujaay mangan, kun inatchana hos nan huhuyunna.” ");
INSERT INTO kyb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kun anan Hesus an chicha, “Sa'on gway Ana' nan Taku nan Apun nan Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sa'ad san namingsan hosay Erkaw gway Umillongan ummoy as Hesus san sinagoga kun nansuyu. Iningkaw nan osa laya'iyay sa'ad nan chigwananay imana achi kun mangkichu. ");
INSERT INTO kyb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kun iningkaw chanan mangaagkammu san lintog ja Pariseo gway manisiput an Hesus nu mangipawhayu san masa'it san Erkaw gway Umillongan tot agwad mangilancha as ipawhersucha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gwon akammun Hesus nan somsomo'cha kun anana say laya'i, “Sumi'ad'a ad ummali'a sanna sangu.” Kun summi'ad chay laya'i kun ummoy san sangucha. ");
INSERT INTO kyb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kun anan Hesus an chicha, “Imuso'ud cha'aju, ngachan nan ijujan nan lintog ta'uway oon san Erkaw gway Umillongan? Manggwa san whayu gwinnu manggwa san lagwing? Manaku san whijag gwinnu manangka san whijag?” ");
INSERT INTO kyb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Intollongna ku chicha losan anana say laya'i, “Ujachom nan imam.” Kun inujad chay laya'i nan imana kun hummayu. ");
INSERT INTO kyb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kun nalingu' amod chachay Pariseo ja chanan mangaagkammu san lintog kun nanuukuchancha nu ngachan nan ooncha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa'ad san sachi chimpu nanakacha as Hesus san whilig tot mallugwayu. Kun nilabyawhinad aschiyay mallugwayu an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mawhikat kun inajakana chachay pasuyutna kun pummili an chicha as nasagwayan as chugwa gway inagwakana hos as apostoles. ");
INSERT INTO kyb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Annachaja nan ngachancha: Simon gway nginadnanas Pedro ja as Andres gway sunudna, cha Santiago an Juan, cha Felipe an Bartolome, ");
INSERT INTO kyb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","cha Mateo an Tomas, as Santiago gway ana' Alfeo ja as Simon gway ananchaon Patriota, ");
INSERT INTO kyb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","as Judas gway ana' Santiago ja as Judas Iscariote gway nangijiwhit an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nanosog ku cha Hesus ja chachay apostolesna summi'ad as sija san tummanapana. Kun iningkaw san sachi nan angsanay pasuyutna ja chachama taku gway nerpu san ailiili san Judea ja Jerusalem ancha nerpu sasan iliyay achani san whaywhay ad Tiro ja Sidon. ");
INSERT INTO kyb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ummoychad aschi manchongor an Hesus ja tot ma'aan chanan sa'itcha. Ad sa'ad chachay nilno' chanan chimunju hummayucha. ");
INSERT INTO kyb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ad losanay taku whayugwoncha ognan as Hesus tan anna nan merpu an sija ayobhonganay mangaan san sa'it ad impawhayuna chicha losan. ");
INSERT INTO kyb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Intollong kun Hesus chachay pasuyutna anana, “Piyan aju, cha'ajuway whawha'sigwot tan mitapi aju sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Piyan aju, cha'ajuway mawhitil san sana tan awni ad mapno' aju. Piyan aju, cha'ajuway maniwhiiwhil san sana tan awni ad majo'jo' aju. ");
INSERT INTO kyb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Piyan aju nu kuyaon cha'aju sasan taku, nu ila'sig cha'aju, nu pawhainan cha'aju ancha ananchaon lagwing ajuway taku kapu san manuyutanju an sa'on gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","San nugwan amaschi ahos nan inggwan chanan nerpugwancha sasay profeta. Lumagsa' aju nu ma'gwa chana an cha'aju ja tumaud aju san amochay lagsa' kapu tan cha'or nan makanabju ad langit. ");
INSERT INTO kyb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gwon amod a'oogjat nan ma'gwa an cha'ajuway whawha'nang tan inippongju san sana nan lamay gway whijag. ");
INSERT INTO kyb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amod a'oogjat nan ma'gwa an cha'ajuway mamabsug san sana tan awni ad nawhitil aju. Amod a'oogjat nan ma'gwa an cha'ajuway majo'jo' san sana tan awni ad nansasanga ajus amod ja maniwhil aju. ");
INSERT INTO kyb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amod a'oogjat nan ma'gwa an cha'aju nu chajagwon cha'aju sasan taku tan amaschi ahos nan inggwan chachay nerpugwancha san mipangkop sasan wha'wha''onay profeta. ");
INSERT INTO kyb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Gwon sa'ad as cha'ajuway manchochongngor an sa'on annachaja nan iwhaka': Ipatogju chanan ahursuju ad inggwaju nan whayu sasan mangisil an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ochagwonjuway pawhayugwon Apudyus nan whijag chanan mamujun an cha'aju ad illugwayuwanju chanan mangilajus an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nan takuway mallipa' san apingnu, palipa'nu hos nan whisa' ad nan mangaya san kotap nan silupnu, atchom kahos nan silupnu. ");
INSERT INTO kyb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nan losanay man'ochaw an si'a atcham ad nan mangaya san u'ugwam, achim ayan asin. ");
INSERT INTO kyb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nan whayugwonjuway oon chanan taku an cha'aju amaschi ahos nan oonju an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nu sija ekay ipatogju chanan mangipatog an cha'aju ininonju manay mapachajagwan san amasnat? Tan uyay chanan humersuwhersu ipatogcha hos chanan mangipatog an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ad nu sija ekay oonju nan whayu sasan manggwa san whayu an cha'aju ininonju manay mapachajagwan san amasnat? Tan uyay chanan humersuwhersu ooncha hos. ");
INSERT INTO kyb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ad nu sija ekay pahuyuchanju chanan akammuju gway agwad nan mangyosna ininonju manay mapachajagwan san amasna? Tan uyay chanan humersuwhersu pahuyuchancha nan isucha gway humersuwhersu tan namnamaonchaay misubli nan isun nan impahuyudcha. ");
INSERT INTO kyb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Gwon ipatogju chanan mallagwing an cha'aju ad oonju nan whayu an chicha. Ad mampahuyud ajuway achiju sosom'on gway mipagkulin an cha'aju. Ad nu amasna nan oonju cha'or nan makanabju ad nangngachan aju anana' nan Angatuwanay Apudyus. Tan as Apudyus whayu nan ipailana sasan maid akammuna manjaman ja chanan lagwingay taku. ");
INSERT INTO kyb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maserpu mangachaku aju as isun Amaju gway mangachaku. ");
INSERT INTO kyb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Achi aju mangu'um san uchum ta achi cha'aju ahos u'umon an Apudyus. Achiju lodchongan nan huyunju ta achi cha'aju ahos lodchongan an Apudyus. Ligwatanju nan whersun nan huyunju ta ligwatan ahos Apudyus nan whersuju. ");
INSERT INTO kyb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangatod aju ad inatchan cha'aju an Apudyus: ustu nan topongna, nasodsod, najugjug ja lumiblibjas nan atchona an cha'aju. Tan nu aman nan topong nan atchonju san huyunju sija ahos nan topong nan atchon Apudyus an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kun iyagwat Hesus an chicha gway manggwana, “Jo'o mawhalinay ipujut nan na'uyap nan isuna na'uyap. Tan nu amasnat nan ma'gwa losancha maotchag san ahut. ");
INSERT INTO kyb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maid kun pasuyut as nangatngatu san mistuyuna gwon sa'ad nu nasuyuwan gway ustu mangngachan ahos isun nan mistuyuna. ");
INSERT INTO kyb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kamma sija iillan nan a'itay whersun nan huyunnu ja achim sija ilan nan cha'or whersum? Isun nan mangiillam san a''iyutay huyaw san atan nan huyunnu gwon achim pun ilan nan amod cha'orray huyaw san atam. ");
INSERT INTO kyb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ininomma manggwana san huyunnuwon, ‘Chota aano' nan huyawnu nu agwad amod cha'or as huyawnu’? Si'aay an'annam mampawhayu san longagnu, aanom janay umuna nan amod cha'or huyawnu tot chata' nan mangilamay mangaan san huyaw nan huyunnu. ");
INSERT INTO kyb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Sa'ad nan whayu aju achi kun mangkas as lagwing ad sa'ad nan lagwingay aju achi kun mangkas as whayu. ");
INSERT INTO kyb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gwaschi osa aju milasin san hokasna. Achi kun mawhalinay pusiyonta nan igos san chawchagwor gwinnu huyasonta nan ubas san pinpinit. ");
INSERT INTO kyb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nan takuway whayu whayu nan apapatona gway merpu san whayuway somsomo'na ad sa'ad nan lagwingay taku lagwing nan apapatona gway merpu san lagwingay somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kajuman anan an sa'onon, Apu, Apu, kunja achi aju chumngor san iwhaka' an cha'aju? ");
INSERT INTO kyb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Losanay umali an sa'on ja manchongor sasan ukud'u ja patiyona chachi ipaila' an cha'aju nan mijisugwana. ");
INSERT INTO kyb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mijisu as sija san osa takuway nangisaad as hoyoyna. Nan'aub as adadchayo'an kun inigkana nan tamangna san whatu. Nanina'or kun nan gwanggwang gwot nangoy san sachi hoyoy, achina kun jinugjug tan pagchot nan tamangna. ");
INSERT INTO kyb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gwon sa'ad nan taku manchongor san ukud'u ja achina patiyon mijisu san taku mangisaad as hoyoyna gway maid kun tamangna as whatu. Nangoy kunan china'or na'anusob nan sachi hoyoy kun amod nan nigwa''iyana.” ");
INSERT INTO kyb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nappung kun nanagwat as Hesus sasan taku ummoy ad Capernaum. ");
INSERT INTO kyb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iningkaw ad aschi nan osa apitan chanan surchachun nan Roma gway agwad nan patpatkona mudchachuna gway nasa'it kun takinotojon. ");
INSERT INTO kyb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chingngorn kun chay apitan nan mipangkop an Hesus ingwhaunna nan uchumay chacha''orn chanan Hudyu tot ochagwoncha an sijaay umoyna pawhayugwon nan mudchachuna. ");
INSERT INTO kyb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ummoycha kun an Hesus nampa'pa''aasicha an sija gway manggwana, “Lobhongnaay mawhachangam nannaja taku ");
INSERT INTO kyb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tan ipatpatogna as chita'uway Hudyu ja hummachang gway nampata'chor san sinagoga ad asna.” ");
INSERT INTO kyb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kun nihuyog as Hesus an chicha. Takangay kus sija san hoyoy nangwhaun chay apitan sasan huyunna ta iwhakacha an sija gway manggwana, “Apu, achi'a manunger umali tan achiya' kun miwhilang as mammangili an si'a san hoyoy'u. ");
INSERT INTO kyb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sija nan achiya' kun miwhilang gway umali an si'a. Iwhakam ekay ad hummayu nan mudchachu'. ");
INSERT INTO kyb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tan uyay as sa'on agwacha' san tuyay nan nangatngatu an sa'on ad anna ahos nan ituyaja'ay susurchachu'. Ana' ad san osaon, ‘I'a’ ummoy, ana' ad san uchumon, ‘Gwaynu’ ummali. Ad ana' ad san mudchachu'on ‘Oom nannaja’ inggwana.” ");
INSERT INTO kyb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chingngorn kun Hesus chi nataag as sija say apitan kun nansakung sasay angsanay taku nitunud an sija. Kun anana, “Iwhaka' an cha'ajuway maid kun osa as ini''ila' as amasna nan pammatina an chita'uway ijIsrael!” ");
INSERT INTO kyb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nanulin kun chachay niwhaun san hoyoy nan apitan inilacha chay mudchachuway hummayu. ");
INSERT INTO kyb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Awni kun ummoy as Hesus san osa iliyay mangngachan Nain. Huyunna chanan pasuyutna ja amochay taku. ");
INSERT INTO kyb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Takangay kus sija san lumno'an san ili iningkaw nan osa natoy gway chinachangngoycha gway umoycha ilhon. Osossa''an as ana' nan nawhayu huwhai. Nihuyog an sija nan amochay taku gway nerpu san sachi ili. ");
INSERT INTO kyb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Inilan kun Apu Hesus chay ina inachakugwana as sija kun anana, “Achi'a maniwhil.” ");
INSERT INTO kyb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kun ummachayug as Hesus kun inognana nan nangigkaancha an sija kun summinong chachay nanachangoy. Kun anan Hesus, “Whawhayu, iwhaka' an si'a gway humangon'a!” ");
INSERT INTO kyb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kun tummu'chu chay natakuway natoy kun kumminga. Kun inatod Hesus san inana. ");
INSERT INTO kyb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ummogjat losan nan taku kun nanchaychajawcha an Apudyus gway manggwana, “Sa'ad nan napatokay profeta lummosgwa an chita'u!” ja “Ummalin Apudyus whinachangan chanan takuna!” ");
INSERT INTO kyb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kun nanchinamag nannaja chamag gway mipangkop an Hesus san losanay Judea ja losanay nampali'gwos san Judea. ");
INSERT INTO kyb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ingwhakan chanan pasuyut Juan an sija nan nanakuwan Hesus say whawhayu. Gwot inajakan kun Juan nan chugwa pasuyutna ");
INSERT INTO kyb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ingwhaunna chicha tot imusoncha an Apu Hesus ananon, “Si'a chay ingwhakan Juan gway umali gwinnu agwad sawhalis uullajonmi?” ");
INSERT INTO kyb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hummu'nagcha kun an Hesus anancha, “Whinaun cha'ami an Juan gway Manghohonjag gway anana, ‘Si'a chay ananaon umali gwinnu agwad sawhalis uullajonmi?’ ” ");
INSERT INTO kyb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa'ad san sachi chimpu impawhayuna chanan angsanay masa'sa'it san na'aya'ayasiyay sa'it ja pinerjawna chanan chimunju ancha inaanna nan uyap nan angsanay na'uyap. ");
INSERT INTO kyb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kun anan Hesus gway summungwhat sasay ingwhaun Juan, “I'aju iwhaka an Juan nan inilaju ja chingngorju. Ananjuwon, ‘Sa'ad chanan na'uyap anna nan ilancha, sa'ad chanan napilay manadchayancha, sa'ad chanan naleprosi hummayucha, sa'ad chanan natuyong anna nan chongyoncha, sa'ad chanan natoy natakucha ja sa'ad chanan whawha'sigwot nipaakammu nan Whayuway Chamag an chicha.’ ");
INSERT INTO kyb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ad ananju hoson piyan chanan takuway achi kun manchugwachugwa san mipangkop an sa'on!” ");
INSERT INTO kyb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lummajaw kun chachay whinaun Juan illukin Hesus iwhaka sasan amochay taku nan mipangkop an Juan gway manggwana, “San ummajanju nangilan an Juan san luta gway maid kun ingkaw as taku, ngachan nan ummoyyu iniila? Jo'o sija ummoyyu iniila nan osa takuway maymaju'u gway isun nan lunu gway ujuujukon nan tungnin? ");
INSERT INTO kyb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Somsom'onju nu ngachan nan ummoyyu iniila. Jo'o sija ummoyyu iniila nan osa takuway nansisillup as a'erjad. Wha'on kun tan sa'ad chanan a'erjad nan silupcha ja lamay nan whijagcha iingkawcha san hoyoy chanan ali! ");
INSERT INTO kyb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iwhakajuud an sa'on nu ngachan nan ummoyyu iniila? Osa profeta? Sija gwon iwhaka' an cha'aju gway nangatngatu san profeta nan inilaju. ");
INSERT INTO kyb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tan as Juan nan ingwhakan nan Ukud Apudyus gway anan Apudyus, ‘Anna iwhaun'u nan umuna an si'a gway umoy mangisakana san ajom.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anan ahos Hesus, “Iwhaka' an cha'aju gway san losanay nijana'ay taku maid kun nangatngatu an Juan. Gwon nan awhawhaan sasan takuway ituyajan Apudyus nangatngatu an Juan.” ");
INSERT INTO kyb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chingngorn kunan losanay taku uyay chanan manchachakup san hugwis nan sussuyun Hesus, ummajuncha san inalintog Apudyus kapu tan nampahonjagcha an Juan. ");
INSERT INTO kyb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gwon sa'ad chanan Pariseo ja mimistuyun nan lintog lagwingoncha nan pangkop Apudyus an chicha kun nilagwingchaay mampahonjag an Juan. ");
INSERT INTO kyb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Intuyuy Hesus gway manggwana, “Ngachan nan mangijisugwa' san annaja lunap? Ngachan nan isucha? ");
INSERT INTO kyb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Isucha nan anana'ay mananannangu san sowhan. Ingwhakan nan uchum san uchumay huyuncha gway manggwana, ‘Nantu'er ami san nayagsa' gwon achi aju kun nansaya! Naniwhil ami gwon achi aju kun na'aiwhil!’ ");
INSERT INTO kyb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Kaman iwhaka' gway a'ammaschi chanan taku? Kapu tan ummalis Juan gway Manghohonjag gway achi kun nangnangan ja achi kun ummi''inum san whajas, kun ananju, ‘Agwad nan chimunju an sija!’ ");
INSERT INTO kyb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ummaliya' kun gway Ana' nan Taku gway mangamangan ja uminiinum ananjuwon, ‘Ilanju nan osa takuwanna! Lagwotan ja huttongan. Hubuyun chanan manchachakup san hugwis ja chanan humersuwhersu!’ ");
INSERT INTO kyb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ta'on nu amaschi sa'ad nan laing Apudyus mipano'no'ay tuttuwa sasan mangagwat.” ");
INSERT INTO kyb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iningkaw nan osa Pariseo gway nangajag an Hesus ta umoy ma'a'an an sija. Kun ummoy as Hesus san hoyoy chay Pariseo na'a'an. ");
INSERT INTO kyb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","San sachiyay ili iningkaw nan osa huwhaiyay naukor. Chingngorna kunay agwachay ma'a'an as Hesus san hoyoy nan Pariseo, ummoy san sachi hoyoy gway inoognana nan lana gway na'ayutan san whangwhangyuway niigka san iigkaan gway na'gwa san whatuway alabaster. ");
INSERT INTO kyb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ummoy kus sija san i''ijan Hesus gway maniwhiiwhil, nabor san luwanana nan i'in Hesus. Ad sa'ad nan huu'na impunadna kun asinaot ichoom nan tupo'na san i'in Hesus kun whinu'hu'ana san lana gway whangwhangyu. ");
INSERT INTO kyb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Inilan kun chay Pariseo gway nangajag an Hesus nan annaja anana san somsomo'na, “Nu tuttuwaay profeta nannaja taku, akammuna otjan nan inatatakun nannaja huwhaiyay mangchomangchon an sija kapu tan naukor as sija.” ");
INSERT INTO kyb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kun anan Hesus gway summungwhat an sija, “Simon, anna nan iwhaka' an si'a.” Kun anana summungwhat, “Mistuyu, ngachan nichi?” ");
INSERT INTO kyb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Anan Hesus, “Iningkaw nan chugwa takuway nanutang san mampappautang. Nan osa, nanutang as limangkasut gway dinario ad sa'ad nan mi'aggwa, nanutang as limampuyu. ");
INSERT INTO kyb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sa'ad tan achicha kun ma'awhajad niligwatan nan ummutangancha nan utangcha. Kun ngachanna an chicha nan mangipatog as amod an sija?” ");
INSERT INTO kyb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kun summungwhat as Simon gway manggwana, “Nan akammu' chay takuway achu nan utangnaay niligwatan chay ummutangancha.” Kun anan Hesus an sija, “Ustu nan ingwhakam.” ");
INSERT INTO kyb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kun tinulilina chay huwhai kun anana an Simon, “Ilam ad nannaja huwhai. Ummaliya' sannaja hoyoyyu gwon achiya' kun inatchan as chanum as mangisu' san i'i' gwon inisuwan nannaja huwhai nan i'i' san luwana kun pinunachana san huu'na. ");
INSERT INTO kyb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Achim pun inchoom nan tupo'nu san aping'u as mangipailaay minangilim as sa'on gwon sa'ad as sija malluki san hu'nag'u achina kun insinongay nangichoom san tupo'na san i'i'. ");
INSERT INTO kyb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Achim pun nilanaan nan wha''ag'u gwon sa'ad as sija whinu'hu'ana nan i'i' san lana. ");
INSERT INTO kyb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sija nan iwhaka' an si'a, niligwata' chanan whersuna gway angsan tan cha'or nan lajad gway impailana an sa'on. Gwon niligwata' as a'it nan whersun chay a'it nan impailana lajadna.” ");
INSERT INTO kyb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kun anan Hesus say huwhai, “Niligwata' chanan whersum.” ");
INSERT INTO kyb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ad sa'ad chanan uchumay natu'tu'chu san oo''anan asi'a'anancha san somsomo'cha, “Ngachan manan osa takuwanna gway uyay chanan whersu ligwatana?” ");
INSERT INTO kyb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gwon anan Hesus say huwhai, “Kapu san pammatim tinaku cha'a. Lumajaw'a gway maid kun machanakam.” ");
INSERT INTO kyb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sachi kun kinagka'ay Hesus nan ailiili gway mangipaakammu san Whayuway Chamag gway mipangkop san Mantuyajan Apudyus. Nihuyog an sija nan nasagwayan as chugwa gway pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kun nihuyog ahos chanan uchumay hubhuwhaiyay hummayu san na'aan nan sa'sa'itoncha ja chachay naperjagwan chanan chimunju. Chicha cha Maria gway iMagdala gway sija chay naperjagwan nan pituway chimunju, ");
INSERT INTO kyb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","as Juana gway asagwan Kusa gway pangpangaton nan manterterwhasuwon Herod ja mamangchon san pila', as Susana ja chanan uchum. Sa'ad nannachaja hubhuwhai inusercha nan u'ugwacha ta whachangancha as Hesus ja chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ummoy ku chanan amochay taku ja chanan takuway nerpu san ailiili, iyagwat Hesus an chicha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iningkaw nan osa takuway ummoy nawwakagwag san whini. Mawwakagwakagwag kun ummoy nan uchumay gwakagwag san chayan kun nakuskuschan ja timpo' chanan mammanu'. ");
INSERT INTO kyb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sa'ad nan uchum ummoycha san whattuwhattuway a'it nan lutana. Tummuhucha kun na'kingcha tan mammamaka nan luta gway tummuhuwancha. ");
INSERT INTO kyb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sa'ad nan uchumay gwakagwag ummoycha san agwachan nan sassait kun na'akisan chumma'or chanan sait gwot sinjungcha nan gwakagwag gway tummuhu. ");
INSERT INTO kyb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ad sa'ad nan uchumay gwakagwag ummoycha san lumong kun chumma'orcha gwot whinumkaschas manginsingkasut nan ummachugwana.” Ingwakana kun chi tinowhagna gway manggwana, “Nu ngachan nan naingaan maserpu manchongor!” ");
INSERT INTO kyb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inimus chanan apostoles Hesus nu ngachan nan pijaona anan chay iyagwatna. ");
INSERT INTO kyb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kun anan Hesus, “Nipaakammu an cha'aju nan chaan kun maakammugwan gway mipangkop san Mantuyajan Apudyus. Gwon sa'ad san uchumay taku sija mipaakammu chanan agwat tot: ‘Ta'on nu iillancha achicha kun maimatunan ja ta'on nu chochongyoncha achicha kun maagwatan.’ ");
INSERT INTO kyb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Annaja nan pijaona anan nan iyagwat'u. Sa'ad chay gwakagwag sija nan ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sa'ad chay gwakagwakay ummoy san chayan mijagwatcha sasan takuway chingngorcha nan ukud Apudyus. Awni kun ummoy as Satanas kun inaanna nan chingngorcha san somsomo'cha tot achicha kun mamati ja mataku. ");
INSERT INTO kyb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ad sa'ad chachay gwakagwag gway ummoy san whattuwhattuway a'it nan lutana, mijagwat sasan taku gway chingngorcha kun ekay ukud Apudyus nallaylajadchaay nangagwat. Gwon isucha chachay minuya gway achi kun lummamut, namatichas sina'itan gwon nu mapachascha manchu'kancha nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sa'ad chachay gwakagwag gway ummoy san agwachan nan sassait isun chachay nangngor san ukud Apudyus gwon kapu san somsomo'cha san whijagcha, mauyawcha san atchon nan whayangna mampawha'nang ja kankanas nan whijag san mawhiwhijakancha, sachi nan nasjungan nan ukud Apudyus san whijagcha ad achi kun nangkas nan pammaticha. ");
INSERT INTO kyb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ad sa'ad chachay gwakagwag gway ummoy san lumong mijagwat sasan takuway whayu ja tuttuwa nan somsomo'cha san nanchongyancha san ukud Apudyus kun intuyuychaay namati ja nangkas nan pammaticha kapu san anuscha.” ");
INSERT INTO kyb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Intuyuy Hesus iyagwat gway manggwana, “Maid kun nangongokkan as silaw ad tinangwhanta san timba gwinnu igkata san silu' nan kama. Gwon igkata san papattangan san silaw tot sa'ad chanan lumno' mailacha nan padcha. ");
INSERT INTO kyb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tan maid kun mitatayu as achi mallotaw ja maid kuhos misulib as achi maakammugwan. ");
INSERT INTO kyb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Sija nan ammanju ilan nan chongyonju tan nan na'aagwat san ukud Apudyus choo machogwan nan maagwatana. Gwon nu ngachan nan achi na'aagwat san ukud Apudyus uyay nan somsom'onaay naagwatana maamamod ma'aan an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ummoy an Hesus nan inana ja chanan susunudna laya'i. Paatcha ekay gway umoy an sija gwon achicha kun ma'aachayug tan amod nan taku. ");
INSERT INTO kyb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kun iningkaw nan osa manggwana an Hesus, “Agwad cha inam ja chanan susunudnu gway summisi'ad san sowhan gway whayugwon cha'a ilan.” ");
INSERT INTO kyb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Gwon summungwhat kus Hesus anana an chicha, “Nan ina' ja chanan susunud'u chicha nan manchongor ja manungper san ukud Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Osa ku erkaw namang'a as Hesus ja chanan pasuyutna kun anana an chicha, “Inta'u chumormang.” Gwot lummiggwatcha. ");
INSERT INTO kyb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sa'ad san mamawhang'aancha nassuy as Hesus. Awni kun maag ekay namali kun nasa'chugwan nan whang'a ad a'oogjat nan asasaadcha. ");
INSERT INTO kyb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ummachayugcha kun an Hesus whinangonchas sija gway manggwana, “Apu, Apu! Malinong ta'u!” Hummangon kus Hesus pinakino'na nan tungnin ja tapiya'. Kun kummino' nan tungnin ja tapiya' gwot ummino' nan whaywhay. ");
INSERT INTO kyb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kun anan Hesus sasan pasuyutna, “Umman ekay pammatiju.” Kun ummogjatcha ja nataagcha gway asi'a'anancha, “Ngachamma atakun nina tuwa? Uyay nan whali ja tapiya' pakin'ona achon nakakino'!” ");
INSERT INTO kyb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hummu'nag as Hesus ja chanan pasuyutna san ilin nan iGerasa gway chomang nan Galili. ");
INSERT INTO kyb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nilumsa kus Hesus san whang'a inahot nan osa laya'i gway nilno' nan chimunju. Nawhajag gway achi kun nansissilup ja wha'on kus iingkaw san hoyoy gwon sija iigkagwana nan lijangay loyobhonan. ");
INSERT INTO kyb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Inilana kus Hesusot nampa'uy nampalintumong san sanguna kun tinowhagna nan kingana gway manggwana, “Hesus gway Ana' nan Angatuwan gway Apudyus, achim whijangan as sa'on. Ipa'pa''aasi' an si'a gway achiya' palikatan.” ");
INSERT INTO kyb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Amaschi nan ingwhakana tan whinilin Hesus nan chimunjuway lumagwa san sachi laya'i. (Tan nangimmancha piliton tingngilon as sija gway ta'on nu natata''od san ayuwhing'i nan imana ja i'ina, hosatona nan ayuwhing'i ad impaagwid nan chimunju san luta gway maid kun ingkaw as taku.) ");
INSERT INTO kyb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kun inimus Hesus gway manggwana, “Ngachan nan ngachannu?” Summungwhat chay chimunju gway manggwana, “Alihulihu nan ngachan'u” tan chachama nan chimunjuway nilumno' an sija. ");
INSERT INTO kyb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kun nampa'pa''aasi chachay chimunju an Hesus ta achina chicha ipooy san ahut gway maid kun pungpung nan aachayo'na gway machusaancha. ");
INSERT INTO kyb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iningkaw san sachi nan angsanay hoyo' gway manayaayab san ikid nan whilig. Kun nampa'pa''aasi chachay chimunju ta ijujanaay lumno'cha sasay hoyo'. Kun iyujana chicha. ");
INSERT INTO kyb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lummagwa ku chachay chimunju say taku nilumno'cha sasan hoyo'. Kun asitotodcha' chachay hoyo' gway ummoy nanotchag san chopyas gway nantubung san whaywhay kun nalinongcha. ");
INSERT INTO kyb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Inilan ku chachay mangaaygwan sasay hoyo' nan na'gwa asitotodcha'chaay ummoy nangipaakammu san hobyoy nan Gerasa ja sasan whija'na. ");
INSERT INTO kyb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kun ummoy chanan taku inila nan na'gwa. Chummakuscha kusan agwachan Hesus inchasancha nan laya'iyay lummagwaan nan chimunju gway tummutu'chu san sangun Hesus. Nansisillup gway hummayu nan somsomo'na. Kun ummogjat chachay taku nangila. ");
INSERT INTO kyb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sa'ad chachay nangila san na'gwa ingwhakacha sasan taku nan ininon nan hummayugwan chay laya'i. ");
INSERT INTO kyb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kun impa'pa''aasin chachay losanay taku gway nerpu san whija' nan Gerasa ta umachaju as Hesus san ilicha kapu tan nangyog nan amochay ogjatcha. Sija nan ummoy cha Hesus san whang'a tot lumajawcha. ");
INSERT INTO kyb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kun nampa'pa''aasi an Hesus chay laya'iyay lummagwaan chachay chimunju tot mitunud an sija. Gwon pinerjaw Hesus as sija gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mana''ulin'a ad ugwaju ad ingwhakam nan inggwan Apudyus an si'a.” Kun lummajaw chay laya'i san ili gway ummoy nangipaakammu san inggwan Hesus an sija. ");
INSERT INTO kyb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nanulin kus Hesus san chomang nan whaywhay minangilin chanan taku tan uullajoncha as sija. ");
INSERT INTO kyb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sachi kun hummu'nag nan osa laya'iyay mangngachan Jairo gway osaay pangat san sinagoga san sachi ili. Nampalintumong kusan sangun Hesus nampa'pa''aasi an sijaay umoy san hoyoyna ");
INSERT INTO kyb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tan nan osossa''anay ana'na huwhai gway ummoy as nasagwayan as chugwa tagwonna, takinotojon. Manadchadchayan kus Hesus gway umoy mansusulig nan amochay takuway namaligwonggwong an sija. ");
INSERT INTO kyb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iningkaw nan osa huwhai gway achi kun natnatchu' nan chayana san nasagwayan as chugwaay tagwon. Inaminna kastuwon nan losanay u'ugwana sasan chu'tur gwon maid kun osas na'aakas an sija. ");
INSERT INTO kyb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ummachayug kun san ochog Hesus sinakidna nan pagpag nan lagkoyloy gway silup Hesus kun nakakino' nan lumagwaay chayana. ");
INSERT INTO kyb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kun anan Hesus, “Ngachan nan nanakid an sa'on?” Insulib ku chanan taku anan Pedro, “Apu, amod nan taku mansusulikay mamawhaligwonggwong an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gwon anan Hesus, “Agwad nan nanakid an sa'on tan akammu'ay agwad nan hummayu san ayobhonga'.” ");
INSERT INTO kyb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Inakammun ku chay huwhai gway achina kun misulib nan inggwana mamaypajogpog gway ummoy an Hesus. Nampalintumong kusan sangun Hesus ingwhakana san sangun nan losanay taku nu kanama sinakid as Hesus ja ininonaay nawhanayu. ");
INSERT INTO kyb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kun inamman Hesus anan say huwhai, “Kapu san pammatim hummayu'a. Lumajaw'a ad achi'a machanakan.” ");
INSERT INTO kyb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sa'ad san mangiwhagawhagan Hesus san sachi hummu'nag nan niwhaunay nerpu san hoyoy Jairo kun anana an Jairo, “Natoy nan ana'nu, achim ta'ta'on nan Mistuyu.” ");
INSERT INTO kyb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gwon chingngorn kun Hesus nan sachi anana an Jairo, “Achi'a umogjat, mamati'a ekay ad hummayu as sija.” ");
INSERT INTO kyb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hummu'nag kus Hesus san hoyoy iyachina nan takuway ma'erno' an sija. Ahus cha Pedro, Juan ja Santiago ja chanan sinana' say ana' as iyujanaay ma'erno'. ");
INSERT INTO kyb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Asijiiwhil nan losanay taku. Gwon anan Hesus, “Achi aju maniwhil, wha'on kus natoy as sija, nassuy ekay!” ");
INSERT INTO kyb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inamamangcha as sija tan akammucha natoy. ");
INSERT INTO kyb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gwon inognan Hesus nan iman chay ana' kun anana, “Ana''u, humangon'a.” ");
INSERT INTO kyb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nataku chay ana' kun nasani'ad. Kun ingwhakan Hesus gway pa'anancha. ");
INSERT INTO kyb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nataag chachay sinana' gwon pinuyung Hesus chichaay maid kun mangiwhagwhagancha san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Osa kunay erkaw inajakan Hesus nan nasagwayan as chugwa gway pasuyutna kun inatodna an chicha nan ayobhongan gway mamerjaw san losanay chimunju ja mangaan sasan sa'it. ");
INSERT INTO kyb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kun ingwhaunna chichaay umoy mangipaakammu san Mantuyajan Apudyus ja mangipawhayu sasan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Anana an chicha, “Achi aju managwit as whayangna san mangwhaatanju, isun nan sur'ud, mangigkaan san ochon, songot, pila' ja uyay adgwan nan kotap nan silupju. ");
INSERT INTO kyb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sa'ad nu agwad mammangili an cha'aju ingkaw aju san hoyoycha ingkanas lumajaw aju san sachi ili. ");
INSERT INTO kyb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ad sa'ad nu achi cha'aju mangiliyon taynanju nan sanatay ili ad pinu'pu'anju nan chapur san i'i'ju as mangakammugwanchaay lagwingon Apudyus nan inggwacha.” ");
INSERT INTO kyb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kun lummiggwat chachay pasuyutna gway ummoy nangagka'ay san ailiili gway nangipaakammu san Whayuway Chamag ja nangipawhayu sasan nasa'it san ailiiliyay ummajancha. ");
INSERT INTO kyb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chingngorn kun Herod gway mangituyay ad Galili nan losanay na'na'gwa nakuyu as amod nan somsomo'na kapu tan anna nan uchumay taku manggwana an sijaon nataku as Juan gway manghohonjag. ");
INSERT INTO kyb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anan nan uchum nallotaw as Elias ja anna nan manggwanaon, nan sanatay osa sasay profeta san agwi nataku. ");
INSERT INTO kyb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kun anan Herod, “Sa'ad as Juan impakungsur' gwon ngachan nan takuwanna chongyochongyo'?” Sija nan insisimo'na gway mangila an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nanulin ku chachay apostoles ingwhakacha an Hesus nan inggwa'inggwacha. Inghuyogna ku chicha ummoy ummosa san iliyay ananchaon Betsaida. ");
INSERT INTO kyb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Inakammun kunan angsanay taku nan mipangkop san annaja nitunudcha an sija. Inajakan ku Hesus chicha ingwhakana an chicha nan mipangkop san Mantuyajan Apudyus. Kun impawhayuna chanan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Takangay kun mumaschom ummoy nan nasagwayan as chugwaay apostoles an sija gway manggwana, “Perjagwom chanan taku tot umoycha sasan achaniyay ili ta mananapchas anoncha ja umijanancha tan achaju ta'u san hohoyoy.” ");
INSERT INTO kyb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gwon anan Hesus an chicha, “Atchanju chichas anoncha.” Kun anancha, “Ahus nannaja lima tinapay ja chugwa i'an as anna an cha'ami. Whayugwomay i'ami malla'us ipa'anmi san losananna taku?” ");
INSERT INTO kyb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ummoy as limallihu nan whilang nan lallaya'iyay agwad san sachi.) Kun anan Hesus an chicha, “Patu'chugwonju chichaay mato'oto'on ad sillimmampuyu nan whilang nan osa to'on.” ");
INSERT INTO kyb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Inggwan ku chanan pasuyut nan ingwhakana tummu'chu losan nan taku. ");
INSERT INTO kyb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Inayan kun Hesus chay lima tinapay ja chugwaay i'an gwot nantangad ad langit, nanjaman an Apudyus. Kun pini'pi''ina chachay tinapay ja pinispisngitna nan i'an kun inatodna sasan pasuyutna tot igwatgwatcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kun nangancha losanot nabsugcha. Kun chinakup chanan pasuyutna nan nasagwayan as chugwaay langngay gway napnu san nasergwa san napi'pi''iyay tinapay. ");
INSERT INTO kyb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Osa ku erkaw san ummosaan Hesus gway mallugwayugwayu gway huyunna chanan pasuyutna, anana an chicha, “Ngachan nan anan chanan taku san mipangkop an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kun summungwhatcha gway manggwana, “Anan nan uchum si'a as Juan gway Manghohonjag. Anan nan uchum si'a as Elias. Kun anan nan uchum gway osa'a sasan profeta san agwi gway nataku.” ");
INSERT INTO kyb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kun anana an chicha, “As cha'aju kay, ngachan nan mangngachanju an sa'on?” Kun summungwhat as Pedro gway manggwana, “Si'a nan Kristu gway ingwhaun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Inamman kun Hesus puyungon chicha ingwhakanaay maid mangiwhagancha san mipangkop sannaja. ");
INSERT INTO kyb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Anana an chicha, “Maserpu sa'ad as sa'onay Ana' nan Taku mapalikatana' as amod ja maid kun manggwaan chanan chacha''orn nan Hudyu an sa'on ja papangat nan papachi ja chanan mangaagkammu san lintog. Ipaotoycha as sa'on gwon mi'atlu achay erkaw matakuwa'.” ");
INSERT INTO kyb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kun anana an chicha losan, “Nu ngachan nan mamayu mitunud an sa'on maserpu achina sija sosom'on nan longagna, isimo'naay mamati ta'on nu sija nan iliglikatna ja i'atoyna ad nitunud an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nu ngachan nan ahus nan whijagnas patpatkona, achi kun ma'awhijag an Apudyus as ingkaingkana gwon nu ngachan nan achi mangipatog san whijagna kapu an sa'on, ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Maid kun kutu' nan man'ugwan nan osa taku nan losanay agwad san luhung nu achi ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tan sa'ad nu ngachan nan mangiwhain an sa'on ja mangiwhain san ukud'u, sa'ad as sa'onay Ana' nan Taku iwhain'u as sija nu managkulina' ad asna luta gway anna an sa'on nan ayobhongan Ama gway huyun'u chanan a'anghel gway iwhaunna. ");
INSERT INTO kyb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iwhaka' an cha'aju nan tuttuwa gway anna an cha'aju nan achi kun matoy ingkanas ilancha nan Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nasinchumingkugwan kun san nappung Hesus iwhaka chachi gwot inagwitna cha Pedro, Juan ja Santiago, nanakachacha san whilig ta umoy as sija mallugwayu. ");
INSERT INTO kyb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mallugwayugwayu kus sija nanohos nan ilan nan hoserna kun sa'ad nan silupna summiling as amod gway putputtaa'. ");
INSERT INTO kyb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Awni kun maag ekay iningkaw nan chugwa laya'iyay ma'aapaapat an sija gway cha Moses an Elias. ");
INSERT INTO kyb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sumilisilingchaay nampaila gway na'aapapatcha an Hesus mipangkop san matojana gway takangay ma'gwa ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sa'ad as Pedro ja nan huhuyunna nailo'cha. Gwon humangoncha kun inilacha as Hesus gway sumilingsiling ja nan chugwa laya'iyay na'asisi'ad an sija. ");
INSERT INTO kyb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","San nanaynanan chachay chugwa laya'i an Hesus anan Pedro an sija, “Apu, whayu nan annaan ta'ud asna! Manggwa amis tuyu sikay as manghubhugwa''anju ancha Moses an Elias.” (Achina kun akammu nan iwhagwhakana.) ");
INSERT INTO kyb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sa'ad san manapaapatan Pedro namunot kun inichungana chicha kun ummogjat chachay pasuyut san tinangwhan nan hunot chicha. ");
INSERT INTO kyb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kun iningkaw nan kingaay nerpu san hunot gway manggwana, “Annaja nan Ana''u gway pinili'. Chumngor aju an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kummino' kun chay kinga ummahus as Hesus as inilacha. Kun kummikinno' chachay pasuyut gwot maid kun osa as nangiwhagwhagancha san sachi chimpu san uyay osa gway inilacha. ");
INSERT INTO kyb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mawhikat kun san nanoskancha gway nerpu san whilig inahot nan amochay taku as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Awni kun sa'ad nan osa laya'i gway agwad san sachi amochay taku, nampo'aw gway manggwana, “Mistuyu! Ipa'pa''aasi' an si'a gway ilamud nannaja ana''u laya'i. Osossa''an as ana''u as sija! ");
INSERT INTO kyb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ilam ad sa'ad nu lon'on nan chimunju maag ekay mapana'uy ad nangajas'asona as sija ad naner'uta' nan tupo'na ja mansikab ekay manaynana an sija ancha jamanonas sija. ");
INSERT INTO kyb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Impa'pa''aasi' sasan pasuyutnu gway perjagwoncha nan chimunju gwon achicha kun ma'a'gwa.” ");
INSERT INTO kyb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kun summungwhat as Hesus gway manggwana, “Ina'ay aju mahosay takuwanna maid kun pammatina ja nasama somsomo'na! Anaman ekay awhajag nan iingkagwa' an cha'aju ja mangaannusa' an cha'aju!” Kun anana say aman nan ana', “Ijalim sanna nan ana'nu.” ");
INSERT INTO kyb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Umadachayug kun chay ana' impatug nan chimunju kun nangajas'asona. Gwon inamujuwan Hesus chay chimunju kun impawhayuna chay ana' gwot inatodna say amana. ");
INSERT INTO kyb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kun nataag chachay taku san amod gway ayobhongan Apudyus. Matataag ku chachay taku san losanay inggwan Hesus anana sasan pasuyutna, ");
INSERT INTO kyb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sosom'onju nannaja iwhaka' an cha'aju. Sa'ad as sa'onay Ana' nan Taku mipawhijanga' sasan taku.” ");
INSERT INTO kyb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gwon achin ku chachay pasuyutna maagwatan nan ingwhakan Hesus. Achi kun nipaakammu an chicha tot achicha kun maagwatan. Kun umogjatchaay manimus an sija san mipangkop san ingwhakana. ");
INSERT INTO kyb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kun naniisi' chachay pasuyut nu ngachanna an chicha nan angatuwan. ");
INSERT INTO kyb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gwon inakammun kun Hesus nan agwad san somsomo'cha inayana kunan osa ana' impasi'adna san chapatna. ");
INSERT INTO kyb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kun anana an chicha, “Sa'ad nan mangajag san amasna ana' kapu an sa'on, sa'on nan inajakana. Ad sa'ad nan mangajag an sa'on inajakana hos nan nangiwhaun an sa'on. Tan sa'ad nan awhawhaan an cha'aju losan sija nan angatuwan.” ");
INSERT INTO kyb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Summungwhat as Juan gway manggwana, “Apu, inilami nan osa takuway ususayona nan ngachannuway mamerjaw sasan chimunju kun ingwhakami an sija gway ijakayna tan wha'on kus pasuyutnu.” ");
INSERT INTO kyb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Gwon anan Hesus an sija, “Achiju ijachis sija tan sa'ad nan achi humursu an cha'aju huyunju.” ");
INSERT INTO kyb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Takangay kunan managkulinan Hesus ad langit simsimmo'naay umoy ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kun nangiwhaun sasan whawha''unonaay umoy umuna an sija. Aysancha kun ummoycha san ili ad Samaria tot mansakanaoncha chanan taku san kumatngan Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gwon lagwingon chanan takud aschi ajakan as Hesus tan sija umajana ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Inilan ku chanan pasuyutnaay cha Juan an Santiago anancha, “Apu, whayugwomay iwhakami an Apudyus ad langit ta ipaalina nan apuy ta puuyana chicha?” ");
INSERT INTO kyb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gwon nansakung kun inamujuwana chicha. ");
INSERT INTO kyb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kun ummoycha Hesus ja chanan pasuyutna san sawhaliyay ili. ");
INSERT INTO kyb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sa'ad san manadchadchayanancha anan nan osa laya'i an Hesus, “Mitunucha' an si'a uyay nu ngachan nan ajam.” ");
INSERT INTO kyb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kun anan Hesus an sija, “Sa'ad chanan mutit anna nan luhucha ja sa'ad chanan mammanu' anna nan ubhucha gwon as sa'onay Ana' nan Taku maid kun hoyoy'u as masuypa'.” ");
INSERT INTO kyb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kun anana san osa laya'i, “Tunuchona'.” Gwon anan chay laya'i, “Apu, ijujamay iya' jan ilhon as ama.” ");
INSERT INTO kyb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Gwon anan Hesus an sija, “Nangamung chanan maid ku pammaticha gway anigcha natoy gway mangilhon san isucha natoy. Gwon i'a ta ipaakammum nan mipangkop san Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Anan ahos nan osa, “Mitunucha' an si'a Apu, gwon iya' jan iwhaka san ahumerjan'u.” ");
INSERT INTO kyb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gwon anan Hesus an sija, “Maid kun manayachu as malluki achon nantulitulili tan wha'on kus mijaya san Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nappung ku sachi chummutu' ahos as Hesus as pitumpuyu ja chugwa as pasuyutna kun ingwhaunna chicha sininchoggwa gway umuna an sija san gwaschi ili gway umajana. ");
INSERT INTO kyb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iyagwatna an chicha gway manggwana, “Tuttuwa angsan chanan taku na'asakana mangagwat san sussuyu gwon a'it nan mangisuyu san ukud'u. Isucha nan minuyaay nerrum gway maapit gwon a'it nan umoy manapit. Sija nan ilugwayuju an Apudyus gway sin'ugwa san apit ta mangiwhaun as angsan as umoy mangayus sasan taku ad sinuyuwancha san ukud'u, isun nan sin'ugwa san tayun gway iwhaunna chanan umoy manapit tot chakuponcha nan apit. ");
INSERT INTO kyb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“I'aju. Chongyonju nannaja! Iwhaun'u cha'aju sasan naujungay taku gway isuju chanan kernero gway umoy san agwachan chanan mangajam gway asu. ");
INSERT INTO kyb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Achi aju managwit as mangigkaan san pila', mangigkaan san silup gwinnu sinilasju. Ja achiju whaywhajakonay kuminga san takuway abtonju san chayan. ");
INSERT INTO kyb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ad sa'ad nu agwad mammangili an cha'aju umuna janay ananjuwon, ‘Pawhayugwon Apudyus nan whijagju.’ ");
INSERT INTO kyb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ad san sanatay hoyoy nu agwad mamayu san ingwhakaju matchay an sija nan whayuway ingwhakaju. Nu maid whawhagwiyonju nan ingwhakaju. ");
INSERT INTO kyb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ad nu minangili cha'aju ingkaw aju san sachi hoyoy. Anonju ja inumonju nu ngachan nan ipasangucha tan nan manterterwhasu lobhongnaay mayabhuwan. Achi aju manattaattun san uchumay hoyoy. ");
INSERT INTO kyb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ad nu ngachan nan ili gway umajanju ja mangiliyoncha cha'aju anonju nu ngachan nan ipasangucha an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pawhayugwonju chanan nasa'it san sanatay ili ad ananju sasan taku, ‘Takangay nan mangituyajan Apudyus an cha'aju.’ ");
INSERT INTO kyb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gwon nu ngachan nan ili gway umajanju ja achi cha'aju mangiliyon i'aju sasan ersa ad ananju, ");
INSERT INTO kyb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Uyay nan chapur san iliju gway nipa'ot san i'imi pu'pu'anmi as mangakammugwanjuway ugwayyu san machusaanju. Gwon ta'on nu amaschi sosom'onjuway takangay nan Mantuyajan Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kun anan ahos Hesus, “Iwhaka' an cha'aju gway san erkaw gway mangu'uman Apudyus ununnayna nan chusan nan iSodoma nu san chusan nan sachiyay ili.” ");
INSERT INTO kyb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Intuyuy Hesus gway manggwana, “Cha'ajuway iCorasin ja iBetsaida achagchaku aju! Tan sa'ad otjan nu na'gwad Tiro ja Sidon nan mataakan gway inggwa' an cha'aju, nawhajag otjanay impailacha nan nanchu'kancha sasan whersucha san tummutu'chugwancha gway nansilup san sa'u ja chinapuyancha nan wha''agcha. ");
INSERT INTO kyb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gwon ununnayna nan chusan chanan iTiro ja iSidon nu san chusaju san mangu'uman Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ad sa'ad as cha'ajuway iCapernaum adja ananjuwon mipangatu ajud langit gway machajaw? Wha'on, mitoper aju ad ingwhilnu.” ");
INSERT INTO kyb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kun anan Hesus sasan pasuyutna, “Nan manchongor an cha'aju sa'on nan chingngorna. Ad sa'ad nan mallagwing an cha'aju sa'on nan nilagwingna. Ad nan mallagwing an sa'on nilagwingna nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nanulin chachay pitumpuyu ja chugwa pasuyut gway nayagsa' gway manggwana, “Apu, uyay chanan chimunju chinumngorcha an cha'ami san nangusayanmi san ngachannuway namerjaw an chicha!” ");
INSERT INTO kyb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kun anana an chicha, “Inila' as Satanas gway naotchag gway isun nan ilat gway nerpud langit. ");
INSERT INTO kyb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chongyonju na! Inatcha' cha'aju as ayobhongan gway manguschan sasan uyog ja pangat chanan kayyaman, mangawha' san losanay ayobhongan Satanas ja maid kun mayyaman an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ta'on nu amaschi achi aju mayagsa'an sanna kapu san chumngor chanan chimunju an cha'aju gwon lumagsa' aju tan sa'ad chanan ngachanju nilistad langit.” ");
INSERT INTO kyb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa'ad san sachiyay uyas pinayagsa' nan Ispilitun Apudyus as Hesus as amod kun anana, “Manjamana' an si'a Ama gway Apun nan losanay agwad ad langit ja anna san luta tan sa'ad nan achim pun impaakammu sasan man'alaing ja naacher taku impaakammum sasan takuway wha'on kus naacher. Tuttuwa Ama, inggwam nan amasna kapu tan annaja nan masomam.” ");
INSERT INTO kyb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nappung kus Hesus nallugwayu anana sasan taku, “Sa'ad nan losan inatod Ama an sa'on ad maid kun mangakammu an sa'on gway Ana'na nu achi ahus as Ama ad maid kuhos mangakammu an Ama nu achi ahus as sa'on gway Ana'na ja chanan whayugwo'ay piliyon gway mangipaakammugwa' an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nansakung kus Hesus sasan pasuyut ahus as chichas nangiwhagana gway manggwana, “Piyan chanan mangiila sanna iillanju! ");
INSERT INTO kyb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tan iwhaka' an cha'aju gway angsan chanan profeta ancha ali gway mamayu mangila san iillanju gwon achicha kun inila ja whayugwonchaay chongyon nan chochongyonju gwon achicha kun chingngor.” ");
INSERT INTO kyb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sachi kun summi'ad nan osaay mangaagkammu san lintog tot padpadchasona as Hesus gway manggwana, “Mistuyu, ngachan nan oo' tot ma'awhijaka' an Apudyus as ingkaingkana?” ");
INSERT INTO kyb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kun anan Hesus an sija, “Ngachan nan anan nan nilista gway lintog Apudyus? Ngachan nan mawhasam sichi?” ");
INSERT INTO kyb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kun summungwhat gway manggwana, “Ipatognu as Apu gway Apudyusnu san losanay agwad an si'a gway somsomo'nu, san alichodgwam, san losanay laingnu ja san losanay pigsam, ja ipatognu nan asintatakum as isun nan mangipatognu san longagnu.” ");
INSERT INTO kyb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kun anan Hesus an sija, “Ustu nan insungwhatnu, oom nannaja ad na'awhijag'a an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Gwon whayugwon chay mangaagkammu san lintog gway ipailaay ustu as sija, sija nan anana an Hesus, “Ad ngachanma na cherrag'u nu'?” ");
INSERT INTO kyb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iyagwat Hesus gway manggwana, “Iningkaw nan osa taku nanosog gway nerpud Jerusalem gway umoy ad Jerico. Kun insanob chanan mamayangkat, inayacha nan losanay agwad an sija uyay nan silupna ja pinertuwancha asichaot taynan gway takangay matoy. ");
INSERT INTO kyb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kun nijaspur nan osa pachi gway nangoy san sachi chayan. Inilana ad chay laya'i niligligna as sija. ");
INSERT INTO kyb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ad isuna hos nan osa Levita gway nangoy san sachi, ummachayug kunot inilana niligligna as sija. ");
INSERT INTO kyb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Gwon sa'ad nan osa iSamaria gway mangwhijasi nangoy san sachi, inilana kus sija inachakugwana. ");
INSERT INTO kyb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inachayukana kun whinu'hu'ana chanan jamanna san whajas ja lana kun whinohodna. Inigkana kusan ajam gway nangawhajuwana iyoyna san hoyojay manchachawsan nan taku kun inamamma''ana as sija. ");
INSERT INTO kyb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mawhikat kun in'atna nan chugwa dinario kun inatodna san mangwhanwhantay san hoyojay manchachawsan kun anana, ‘Amamma''am as sija ad amana ad nan chokan nan makastum, managkulina' ad whinajacha' si'a.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kun iyanungus Hesus gway manggwana, “San somsomo'nu, ngachanna sannachaja tuyu nan ustu cherrag chay takuway insanob chanan mamayangkat?” ");
INSERT INTO kyb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kun anan chay mistuyun nan lintog, “Chay nangachaku an sija.” Kun anan Hesus an sija, “I'a ad amaschi ahos nan oom.” ");
INSERT INTO kyb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sa'ad san nangituyujan cha Hesus ja chanan pasuyutna san umajancha ummoycha san osa ili. Ad sa'ad nan osa huwhaiyay mangngachan Marta minangilina cha Hesus ad ugwacha. ");
INSERT INTO kyb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ad agwad nan sunudna mangngachan Maria gway tummu'chu san chapat Hesus kun nanchochongngor san sussuyuna. ");
INSERT INTO kyb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gwon na'attutan as Marta gway manchurngu. Ummachayug kus sija an Hesus anana, “Apu, jo'o maid eka whijangnu san nangipaahusan nan sunud'u an sa'onay mangisakana san anonju? Iwhakam pot an sija ta whadngana'.” ");
INSERT INTO kyb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gwon summungwhat as Hesus gway manggwana an sija, “Marta, Marta, machanakan'a ekay ja masunutan san whayangna. ");
INSERT INTO kyb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gwon osa ekay maserpu ad sijana nan pinilin Maria gway achi kun ma'a''aan an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sa'ad san namingsan gway mallugwayugwayuwan Hesus san osa ikaw, nappung kus sija nallugwayu anan nan osa sasan pasuyutna an sija, “Apu, suyuwam cha'ami gway mallugwayu as isun nan nanuyuwan Juan sasan pasuyutna.” ");
INSERT INTO kyb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kun anan Hesus an chicha, “Sa'ad nu mallugwayu aju amasna nan ananju: ‘Amami, machaychajaw nan ngachannu, umali nan Mantuyajam. ");
INSERT INTO kyb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Atchan cha'ami as anonmi san whinikat. ");
INSERT INTO kyb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ligwatam chanan whersumi as isun nan malligwatanmi sasan whersun chanan na'awhersu an cha'ami. Ad achim ituyung gway masulisukan ami.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kun anan Hesus an chicha, “Ngachanna an cha'aju nan anna nan hubuyunna ja umoy an sija san tipyo' ja anana an sijaon, ‘Sunud, pahuyuchana'ud as tuyus tinapay. ");
INSERT INTO kyb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tan sa'ad nan hubuyun'u hummu'nakay nanchakas gway nangwhaat ad maid kun ipa'an'u an sija.’ ");
INSERT INTO kyb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ad nu anana sumungwhaton, ‘Achiya' whayakaon. Naahus naongwhan nan onob ja nassuy ami sasan ana''u. Lagwingo'ay humangon, maid kun atcho' an si'a.’ ");
INSERT INTO kyb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iwhaka' an cha'aju gway ta'on nu achi humangon ja achi mangatod as tinapay kapu tan hubuyunnas sija gwon kapu tan lagwingonaay miwhawhain as sija, humangon ad inatchana chay man'ochaw as angsanay maserpuna. ");
INSERT INTO kyb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ad iwhaka' an cha'aju gway man'ochaw aju an Apudyus ad inatchan cha'aju. Anaponju an sija nu ngachan nan anaponju ad inchasanju. Man'ab'ab aju an sija ad inigkatna cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tan gwaschi osa man'ochaw maatchan. Na mananap ochasana nan anapona ja nu ngachan nan man'ab'ab miigkat nan onob an sija. ");
INSERT INTO kyb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ngachanna an cha'ajuway ama nan man'ochaw ad nan ana'na as i'anon sija atchona nan uyog? ");
INSERT INTO kyb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Gwinnu man'ochaw ad as itlukon sija atchona an sija nan pangat nan kayyaman? ");
INSERT INTO kyb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anna pat cha'ajuway lagwingay takuwot akammuju mangatod as whayu san anana'ju. Kanuyamas Apudyus gway Ama ad langit as achina atchon nan Ispilituna sasan man'ochaw an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sa'ad san namingsan pinerjaw Hesus nan chimunju gway nangigki san osa laya'i. Lummajaw ku chay chimunju kumminga chay laya'i kun nataag chanan amochay taku. ");
INSERT INTO kyb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gwon anan nan uchum an chicha, “As Beelzebub gway pangat chanan chimunju nan nangatod an sija as ayobhongana gway mamerjaw sasan chimunju.” ");
INSERT INTO kyb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ad sa'ad chanan uchum pinadpadchascha as sija gway nan'ochaw as imatunay mataakan as mamatiyancha nu tuttuwaay Apudyus nan nangiwhaun an sija. ");
INSERT INTO kyb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gwon kapu tan aagkammun Hesus nan somsomo'cha anana an chicha, “Losanay mantuyajan gway mangwhiwhinnursu matangkaan ja sa'ad nan singwherjan gway manisiisi' masibsibta'cha. ");
INSERT INTO kyb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ad sa'ad ahos as Satanas nu lawhanona chanan chimunjuna ininon na mantuyajanaay humajag? Ingwhaka' nannaja kapu tan ingwhakajuway as Beelzebub nan nangatod san ayobhonga'ay mamerjaw sasan chimunju. ");
INSERT INTO kyb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nu ananjuwon perjagwo' chanan chimunju kapu san ayobhongan Beelzebub, ngachan nan sin'ayobhongan san usayon chanan pasuyutjuway mamerjaw sasan chimunju nu'? Nu amasnat uyay as chicha, pano'no'ancha gway nipa'hot nan iwhakawhakaju. ");
INSERT INTO kyb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gwon sa'ad tan Apudyus nan nangatod an sa'on san ayobhongan gway mamerjaw sasan chimunju, sijana nan mangipaila gway hummu'nag nan mangituyajan Apudyus an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sa'ad nan osa taku napigsa gway na'eermas gway ustu gway mangijachug san hoyoyna, maid kun mana'aw san u'ugwana. ");
INSERT INTO kyb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gwon sa'ad nu umali nan osa takuway napigpigsa an sija awha'onas sija, pursona losan nan ermasnaay mantayo'ana ad sa'ad chanan sinamsamna atchona igwayas. ");
INSERT INTO kyb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nan achi umannatup san o'oo' lagwingonas sa'on. Ad nan achi humachang gway mangajag sasan taku tot sumuyutcha an sa'on, chicha nan manibsibta' an chicha.” ");
INSERT INTO kyb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Intuyuy Hesus gway manggwana, “Nu lummajaw nan chimunju san taku umoy mangoy san luta gway maid kun ingkaw as taku mananap as umillongana. Ad nu maid ochasana anana san somsomo'na, ‘Iya' managkulin san ikaw'uway nerpugwa'.’ ");
INSERT INTO kyb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Managkulin ad inchasana gway por'as ja naurnus. ");
INSERT INTO kyb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Managkulin ad nangihuyog as sija as pitu chimunju gway amod lagwing an sija ad nu lumno'cha ingkawcha ad aschi. Ad sa'ad nan mangudchi asasaad nan sachi taku amod lagwing say chamu.” ");
INSERT INTO kyb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Anna kuway iwhakawhakan Hesus nan sachi nampo'aw nan osa huwhaiyay agwad san amochay taku kun anana an Hesus, “Piyan nan ina gway nangijana' an si'a ja nanakiwhi an si'a!” ");
INSERT INTO kyb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gwon anan Hesus, “Piyan as amod chanan manchongor ja mamopotpot san ukud Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ummachu ku chanan takuway naayus illukin Hesus gway manggwana, “Sa'ad nan lunap san sana lummagwing. Man'ochawcha as mataakanay mangimatunan gwon maid kun mipaila an chicha nu achi ahus nan mataakanay mangimatunan gway na'gwa an Jonas. ");
INSERT INTO kyb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tan sa'ad nan na'gwa an profeta Jonas sachi nan mangimatunanay mangipaila sasan takud Nineve, isuna hos gway sa'ad as sa'on gway Ana' nan Taku mangngachan mangimatunanay mangipaila sasan taku san annaja lunap. ");
INSERT INTO kyb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Sa'ad nan reyna ad Seba mitapi san annaja lunap sumangu san erkaw gway mangu'uman Apudyus ad tina'choyana chicha gway na'awhersucha ad nilodchongana chicha kapu tan nerpus sija san adadchajuwanay ili ta umoyna chongyon nan inalaing Ali Solomon. Gwon ta'on nu agwad an cha'aju nan nangatngatu an Solomon sissija achiju kun tuttugwaon as sija. ");
INSERT INTO kyb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Sa'ad chanan iNineve mitapicha san annaja lunap sumangu san erkaw gway mangu'uman Apudyus ad tina'choyancha cha'aju gway na'awhersu aju ad nilodchongancha cha'aju kapu tan nanchu'kancha nan whersucha san chingngorcha nan sussuyun Jonas. Gwon ta'on nu agwad an cha'aju nan nangatngatu an Jonas sissija achiju kun tuttugwaon as sija!” ");
INSERT INTO kyb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Intuyuy Hesus gway manggwana, “Maid kun mangngotog san silaw ad illingobna gwinnu tangwhana san timba gwon ipatangna san papattangan tot sa'ad chanan lumno' mailacha nan padcha. ");
INSERT INTO kyb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sa'ad ahos nan ata isun chi silaw nan longag gway mangatod as ayobhongan gway mangila san losan. Sa'ad nu whawhalluwan nan atam isun chi napadchaan nan somsomo'nu ad naakammugwam losan nan whayugwon Apudyus gway ipaakammu an si'a. Gwon nu agwad sikahon nan atam isun chi agwad'a san manghulingot ad achim pun maakammugwan losan nan whayugwon Apudyus gway ipaakammu an si'a. ");
INSERT INTO kyb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sija nan ammam ilan ta achim ananon nasilagwan nan somsomo'nu annaotay agwad'a san manghulingot. ");
INSERT INTO kyb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ad nu nasilagwan nan somsomo'nu gway maid kun hulingotna maakamugwam nan losanay whayugwon Apudyus gway isun chi pinapadchaan cha'a san silaw.” ");
INSERT INTO kyb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nappung kus Hesus nanapapat inajakan nan osa Pariseo as sija ta umoy ma'a'an an sija. Kun ummoy as sijaot tummu'chu san oo''anan. ");
INSERT INTO kyb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gwon sa'ad chay Pariseo san inilanaay achin ku Hesus inggwa nan ukalichaay manghuyu asiyot mangan, nataag as sija. ");
INSERT INTO kyb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gwon anan Apu Hesus an sija, “Sa'ad as cha'ajuway Pariseo uyasanju nan lawhaw nan langkaw ja chujas gwon nan somsomo'ju pasig kamkam ja lagwing. ");
INSERT INTO kyb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Katkatung aju! Jo'o wha'on an Apudyus gway nanggwa san mallawhaw nan nanggwa ahos san manchayo'. ");
INSERT INTO kyb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Whaligwanju nan somsomo'ju ta mangatod aju sasan whawha'sigwot ad ilanju achot pumor'as nan losan an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Amod a'oogjat nan ma'gwa an cha'ajuway Pariseo! Tan ta'on nu atchonju an Apudyus nan mi'asimpuyu whillay san apitju san muyaju gway mampapija ja mampawhangu san ma'an ja losanay minuya, achiju kun tinungper nan manggwaanju san ustu san asintatakuju ja mangipatog an Apudyus. Annachaja nan maserpu oonju gway achiju hos ligwatan nan uchumay lintog. ");
INSERT INTO kyb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Amod a'oogjat nan ma'gwa an cha'ajuway Pariseo! Tan whayugwonju tu'chu san awhayugwan gway tu'chugwan san sinagoga ja makingakingaan san merket. ");
INSERT INTO kyb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Amod a'oogjat nan ma'gwa an cha'aju tan mijisu aju sasan lohonay maid imatunna gway sa'ad chanan taku manguskuschan achicha kun akammu.” ");
INSERT INTO kyb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kun summungwhat nan osa sasan mangaagkammu san lintog an sija gway manggwana, “Mistuyu, kapu san ingwhakamannat pinawhainam ahos cha'ami.” ");
INSERT INTO kyb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Gwot anan Hesus, “Sa'ad as cha'aju ahos gway mangaagkammu san lintog achagchaku aju kapu tan ipa'gwaju sasan taku nan angsanay lintog gway mansikab as suyuton. Isun chi padonju an chicha nan chagsonay ochon. Gwon sa'ad as cha'aju mismu achiju kun chongyon chanan lintog gway ipa'gwaju san uchum. ");
INSERT INTO kyb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Amod a'oogjat nan ma'gwa an cha'aju kapu tan ina'erjadjuway nanggwa san pusantun chachay profetaay intoy chanan nerpugwanju. ");
INSERT INTO kyb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","San amaschiyay inggwaju pinano'no'anjuway inajunanju nan inggwan chachay nerpugwanju gway intoycha chachay profeta ad cha'aju pay nan nampata'chor san pusantucha. ");
INSERT INTO kyb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kapu sannaja anan Apudyus san inalaingna, ‘Iwhaun'u an chicha chanan profeta ja nachutu'an as mangiwhaka san mipangkop an sa'on ad nan uchum otojoncha ja palikatancha hos nan uchum.’ ");
INSERT INTO kyb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Tot sa'ad chanan taku san sanaay lunap machusacha kapu san natojan chanan profeta manipud san na'gwaan nan luhung ");
INSERT INTO kyb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","malluki san nangtojancha an Abel ingkana an Zacarias gway napatoy san nanghoyaatan nan chachattunan ja nan Templo. Tuttuwa, iwhaka' an cha'aju gway machusa nan annaja lunap kapu san nangtojancha an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Amod a'oogjat nan ma'gwa an cha'aju gway mangaagkammu san lintog kapu tan ijachiju chanan taku gway mangakammu an Apudyus. Lagwingonjuway mampaituyay an Apudyus ja ijachiju pay chanan mamayu paituyay!” ");
INSERT INTO kyb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ad sa'ad san lummajagwan Hesus san sachi hoyoy illukin chanan mangaagkammu san lintog ja chanan Pariseo gway mangisil as amod an sija ja angsan nan imuscha an sija, ");
INSERT INTO kyb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","pijaonchaay agwad maayachas ukudna as mangipawhasuyancha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","San sachi naayusan nan alihulihuway taku gwot nampigpiglit nan gwaschi osa an chicha, anan Hesus gway ummuna sasan pasuyutna, “Ammanju ilan nan yeast chanan Pariseo gway an'annancha mampawhayu ta achi aju maalisan an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maid kun mitatayu as achi mallotaw ja maid kun misulib as achi maakammugwan. ");
INSERT INTO kyb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sija nan nu ngachan nan ingwhakam san manghulingot awni ad nipagngor san padcha ja nu ngachan nan iyakakaasnu san ugwertu awni ad nangalimawmaw san panabhungan.” ");
INSERT INTO kyb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Intuyuy Hesus gway manggwana, “Iwhaka' an cha'ajuway huhuyun'u, achi aju umogjat sasan mangtoy san longag tan mappung ad maid kun mawhalincha oon. ");
INSERT INTO kyb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gwon ipaakammu' an cha'aju nan umogjatanju. Umogjat aju an Apudyus gway anna nan ayobhonganaay mangtoy ja mangitoper san longag ad ingwhilnu. Tuttuwa iwhaka' an cha'ajuway umogjat aju an sija. ");
INSERT INTO kyb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ta'on nu sinchoggwampisil ekay la'un nan lima u'i'i maid kun osa an chichas niligwatan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Uyay nan huu'ju akammuna nan whilangcha. Achi aju umogjat. Napatpatog ajus amod nu sasan angsanay u'i'i.” ");
INSERT INTO kyb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kun anan ahos Hesus, “Iwhaka' an cha'aju gway nu ngachan nan mangiwhawhagka sasan taku gway mamatis sija an sa'on, sa'ad as sa'on gway Ana' nan Taku ta'choya' as sija san sangun chanan a'anghel Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gwon nu ngachan nan mangisulib an sa'on san sangun chanan taku isulib'u hos as sija san sangun chanan a'anghel Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ad nu ngachan nan manapapat as mihursu an sa'on gway Ana' nan Taku mawhalinay ligwatan Apudyus nan whersuna. Gwon nan mangiwhaka san maamamangan nan Ispilitun Apudyus achin ku Apudyus ligwatan nan whersuna. ");
INSERT INTO kyb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ad sa'ad nu ijoy cha'aju sasan sinagoga ja sasan mantutuyay ja sasan anna nan ayobhongana tot sumerjaon cha'aju, achi aju machanakan nu ininonju sumungwhat, ngachan nan isungwhatju gwinnu nu ngachan nan iwhakaju. ");
INSERT INTO kyb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tan san sanat eka uyas Ispilitun Apudyus nan mangisuyu an cha'aju nu ngachan nan maserpu iwhakaju.” ");
INSERT INTO kyb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anan nan osa laya'i san agwachan nan amochay taku an Hesus, “Apu, iwhakam san sunud'uway laya'i ta whillajona nan la'sunmi.” ");
INSERT INTO kyb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Gwon anan Hesus say laya'i, “Ngachan nan nanutu' an sa'on as mangiwhanag gwinnu mamillay san la'sunju?” ");
INSERT INTO kyb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kun anan Hesus an chicha, “Ammanju ilan ja whantajanju nan losanay ayasin nan kamkam tan nan whijag nan taku wha'on kus sija mayu'uchana nan inaachun nan u'ugwana.” ");
INSERT INTO kyb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gwot nanagwat as Hesus an chicha gway manggwana, “Iningkaw nan osa wha'nang gway angsan nan apitna san tayunna. ");
INSERT INTO kyb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sija nan anana san somsomo'na, ‘Ngachan nan oo' tan maid kun mangigkaa' san apit'u?’ ");
INSERT INTO kyb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kun anana, ‘Oo' nan amasna: Igwa''i' chanan ayang'u ad nanggwaa' as chacha''or. Ad sachi nan mangigkaa' san losanay apit'u ja u'ugwa'. ");
INSERT INTO kyb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ad ana' san somsomo''u, “Angsan nan u'ugwam gway nasikkut san angsanay tagwon. Umillong'a, o'an ekay ja inum nan o'oom ja mangkankanas'a.” ’ ");
INSERT INTO kyb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Gwon anan Apudyus an sija, ‘Katkatung'a! San sana lawhi matoy'a ad ngachan nan mangin'ugwa san sinikkutnu?’ ");
INSERT INTO kyb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Amaschi nan ma'gwa san takuway mansikkut as whina'nangna gwon wha'on kus wha'nang san mangilan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Anan Hesus sasan pasuyutna, “Sija nan iwhaka' an cha'aju gway achi aju machanakan san iwhijagju nu ngachan nan anonju ja inumonju gwinnu isilupju. ");
INSERT INTO kyb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tan napatpatog nan whijag san ma'an ja napatpatog nan longag san luput. ");
INSERT INTO kyb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilanju chanan kajang achicha kun mammuya gwinnu manapit as anoncha. Maid kun manikkutancha gwinnu maid kun ayangcha gwon ta'on nu amaschi, pa'apa'anan Apudyus chicha. Jo'o achi aju napatpatog sasan mammanu'? ");
INSERT INTO kyb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aychuuda'ay nu agwad mangipaanchu san whijagna uyay a'it kapu san machanchanakana! ");
INSERT INTO kyb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ad nu achi aju ma'a'gwa san uyay aa''itanay mangipaanchu san whijagju ka'aju machanakan san mipangkop san uchum? ");
INSERT INTO kyb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ammanju ilan chanan tabwha' nu ininoncha chuma'or. Achicha kun manterwhasu gwinnu manahor. Gwon iwhaka' an cha'aju gway uyay as Ali Solomon san losanay whina'nangna maid kun silupnas isun nan ina'erjad nan osa sannachaja tabwha'. ");
INSERT INTO kyb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nu ipawhayun Apudyus chanan hokaw san tayun gway mawhiwhijag a' awniyanna ja mawhikat ad niwhallu maskob, kanuya ajuman as achina silupan? Whawhang ekay pammatiju! ");
INSERT INTO kyb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ad achiju sosom'on nu ngachan nan anonju ja inumonju ja achi aju machachanakan. ");
INSERT INTO kyb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tan sa'ad chanan taku sanna luhung gway achi kun mamati sija sosom'oncha nan mipangkop sannachaja ad akammun Apudyus gway Amaju gway maserpuju chana. ");
INSERT INTO kyb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sijaot sosom'onju nan Mantuyajan Apudyus ad sa'ad chanan maserpuju maatod an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Achi aju umogjat cha'ajuway aa''itanay pasuyut'u tan nasom as Apudyus gway Amaju gway mangitapi an cha'ajuway ma'atuyay an sija. ");
INSERT INTO kyb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ila'uju nan u'ugwaju ad nangatod aju sasan whawha'sigwot tot agwad masikkutju san whina'nang ad langit. Sa'ad ad aschi, sa'ad nan masikkutju whina'nang achi kun mayusyus'uy ja ma'a''aanan ja maid kun manaa'aw as umoy umachayug mana'aw ja maid kun la'oy as manangka. ");
INSERT INTO kyb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tan nu agwan nan agwachan nan whina'nangju sachi hos nan agwachan nan somsomo'ju. ");
INSERT INTO kyb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Maserpu na'asakana aju ja nangongokkan nan sisillagwanju. ");
INSERT INTO kyb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Isugwonju chanan mansilsilwhiyay manguullay san amucha gway ummoy na'abyay tot humu'nag ad ja man'ab'ab, manijigkatcha san onob. ");
INSERT INTO kyb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Piyan chanan mansilsilwhi gway sa'ad nan amucha kinatngana chicha gway hummawhangon. Tuttuwa iwhaka' an cha'aju gway manuser san usern nan mansilsilwhis sija ad impatu'chuna chicha san oo''anan ad chinurnguwana chicha pa'anan. ");
INSERT INTO kyb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ad nu tipyo' gwinnu machani ja kinatngana chichaay hummawhangon, piyan chachay mansilsilwhi. ");
INSERT INTO kyb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Gwon akammugwonju na gway nu akammun nan sin'ugwa san hoyoy nan uyas gway umaliyan nan manaa'aw achina kun ijujaay lon'on nan manaa'aw nan hoyoyna. ");
INSERT INTO kyb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sa'ad ahos as cha'aju maserpu patinajunay na'asakana aju tan sa'ad nan uyas gway achiju kun akammu sachi nan umaliya' gway Ana' nan Taku.” ");
INSERT INTO kyb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Anan Pedro, “Apu, cha'ami nan mangiwhagam san annaja iyagwatnu gwinnu san losanay taku?” ");
INSERT INTO kyb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kun anan Apu, “Ad ngachan nan mantayo'an ja naangsan gway mangiila san hoyoy as chutu'an nan singhoyoy gway mangiila san mansilsilwhi san hoyoyna tot sija nan mangaatod san whillaycha san anoncha san ustuway chimpu? ");
INSERT INTO kyb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Piyan na sanatay mansilsilwhi nu humu'nag nan amuna gway ochasanas sija gway manggwamanggwa san terwhasuway nitayo' an sija. ");
INSERT INTO kyb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tuttuwa iwhaka' an cha'aju gway chutu'anas sija as mangiila san losanay u'ugwana. ");
INSERT INTO kyb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gwon nu anan nan sanatay mansilsilwhi san somsomo'naon, ‘Mawhajag nan managkulinan nan amu'’ ja ilukinaay saplitan nan huhuyunnaay mansilsilwhi gway lallaya'i ja hubhuwhai ja o'an ja inum nan o'oona ancha manghutohutong, ");
INSERT INTO kyb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","humu'nag ad nan amuna san erkaw gway achi kun na'asakana ja uyas gway achina kun akammu, chusaon nan amunas amod as sija ad iyoynas sija san agwachan chanan achi kun mamati. ");
INSERT INTO kyb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ad nan sanatay mansilsilwhi gway akammuna nan ipa'gwan nan amuna gwon achi kun na'asakana ja achina kun inggwa nan impa'gwan nan amuna, masaplitan as angsanay saplit. ");
INSERT INTO kyb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gwon nan mansilsilwhiyay achina akammu nan pa'gwan nan amuna gwon nanggwas kapun nan mapalikatana, masaplitan as a'it. Nan losanay naatchan as angsan, angsan nan ochagwoncha an sija. Ad nan nitayo'an nan angsan sinumamod angsan nan ochagwoncha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Masibsibta'an chanan takud asna luta nan iyali'. Ad whayugwo' gway naahus otjan malluki! ");
INSERT INTO kyb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gwon chaan ad ma'gwa nannaja maserpu mapalikatana' as amod ja matoja'. Malilihu'ana' as amod ingkanas mappung na. ");
INSERT INTO kyb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ananju ninaon iyali' nan maurnusan chanan taku ad asna luta? Wha'on. Iwhaka' an cha'aju gway sija iyali' nan mangwhiwhinnusuyan chanan taku. ");
INSERT INTO kyb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Malluki san sana masississiyan nan lima whilangnaay taku san osa wherjan. Sa'ad nan tuyu kuyaoncha nan chugwa ad nan chugwa kuyaoncha nan tuyu. ");
INSERT INTO kyb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mangkikinnuya chanan manaama ja maniina ancha manatatukanga gway huwhai.” ");
INSERT INTO kyb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kun anan Hesus ahos sasan amochay taku, “Sannaja ili nu ilanju nan mangmangngititay hunot san si'uton nan init, nani'ananjuwon umuchan ad amasnat nan na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ad nu ilanju nan tungnin gway merpud apyay ananjuwon umattub as amod ad na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cha'ajuway an'annanju mampawhayu! Sa'ad nan ilan nan luta ja langit akammuju mangimatun gwon kajuman achi akammu gway mangimatun san sana chimpu? ");
INSERT INTO kyb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kajuman achi somsom'on nu ngachan nan ustu oonju? ");
INSERT INTO kyb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ad sa'ad nu agwad mangichayum an si'a san uu''uman oom nan lobhongnuway ma'alinnisut an sija san chaanju umajan san manguu'um. Nu achim oon na huthuton cha'a ijoy san manguu'um ad nan manguu'um ipawhijang cha'a san pulis ad impisu' cha'a san whawhalluchan. ");
INSERT INTO kyb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iwhaka' an si'a gway achi'a kun lumallagwa san whawhalluchan ingkanas ijahusnu aminon iwhajad nan pila'nu.” ");
INSERT INTO kyb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sa'ad san sachi chimpu iningkaw chanan uchumay takud aschi gway nangiwhaka an Hesus san mipangkop sasan iGalili gway impa'toy Pilato san manchatunancha san chatuncha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kun summungwhat as Hesus gway manggwana an chicha, “Adja ananjuwon sa'ad nannachaja iGalili nachagchagson nan whersucha nu chanan uchumay iGalili kapu tan amasnat nan in'atoycha? ");
INSERT INTO kyb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wha'on! Gwon iwhaka' an cha'aju gway nu achiju manchu'kan chanan whersuju matangkaan aju hos. ");
INSERT INTO kyb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Isun ahos chachay nasagwayan as gwayu gway tinu'nukan nan ni'uurb gway anchaanchu pata'chor ad Siloam kun natoycha. Adja ananjuwon nachagchagson nan whersucha nu sasan uchumay takuway ingkaw ad Jerusalem? ");
INSERT INTO kyb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wha'on! Gwon iwhaka' an cha'aju gway nu achiju manchu'kan chanan whersuju matangkaan aju hos.” ");
INSERT INTO kyb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iyagwat Hesus gway manggwana, “Iningkaw nan osa takuway nammuya san igos san mumullana san ubas. Ad umoyna ad ilan nu agwad hokasnaon maid kun ochasana. ");
INSERT INTO kyb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gwot anana san manaadchukona, ‘Ilam ad na, tuyun tagwon gway umalaaliya' ta ila' nu agwad hokas nannaja igos gwon maid kun ochasa' as hokasna. Sija nan sipuyomot. Ma'ayngaam man lagwa san lutaay mimumullan nina.’ ");
INSERT INTO kyb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ad summungwhat chay manaadchukona gway manggwana an sija, ‘Apu, ainnugwana jan as sintagwon, auwha' nan mampali'gos gway puunna ad inahunuwa'. ");
INSERT INTO kyb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ad sa'ad nu humkas a' asi whayu. Gwon nu achi humkas asimot pasipur.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nansuyu as Hesus san osa sasan sinagoga san Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kun iningkaw ad aschi nan osa huwhaiyay iniingkaw nan chimunju an sija san nasagwayan as gwayu tagwon. Gwot nawhi'ug as sija ja achi kun ma'asi'ad as linchong. ");
INSERT INTO kyb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Inilan kun Hesus chay huwhai inajakana kun anana an sija, “Hummayu'a san sa'itnu!” ");
INSERT INTO kyb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kun impatay Hesus nan imana an sija kun nakanochong nan sumi'achana kun nanchaychajaw as sija an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gwon sa'ad nan pangat nan sinagoga nalingu kusan nangipawhayugwan Hesus say osa huwhai san Erkaw gway Umillongan, anana sasan taku, “Agwad nan onomay erkaw gway maserpu manterwhasuwan. Sija nan chanat gway erkaw nan umaliyanju mampaakasan ad wha'on kusan Erkaw gway Umillongan!” ");
INSERT INTO kyb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kun anan Hesus an sija, “Cha'ajuway an'annanju mampawhayu! Jo'o achi gwaschi osa an cha'aju san Erkaw gway Umillongan umoyna u'whachon nan talin nan wha'ana gwinnu asnona san pu'u' ad ummoyna pinainuman. ");
INSERT INTO kyb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gwon nannaja kana' Abraham gway pinalikatan Satanas san nasagwayan as gwayu tagwon, adja achi ekas sija humayuway ma'aan nan sa'itna san Erkaw gway Umillongan?” ");
INSERT INTO kyb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ingwhakana ku sachi nawhainan losan nan mallagwing an sija. Kun nallaylajad nan amochay taku san losanay a'erjad gway inggwana. ");
INSERT INTO kyb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gwot anan Hesus, “Ngachan nan mijisugwan nan Mantuyajan Apudyus? Ngachan nan mangijagwata'? ");
INSERT INTO kyb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mijisu san hu'orn nan mustard gway inayan nan osa taku kun iwwakagwagna san kerchinna. Chumma'or kun nangngachan isun chi aju kun nangubhuwan chanan mammanu' chanan pangana.” ");
INSERT INTO kyb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kun inasin Hesus gway manggwana, “Ngachan nan mangijagwata' san Mantuyajan Apudyus? ");
INSERT INTO kyb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mijisu san yeast gway in'ayut nan osa huwhai san sillataay alina kun ingkana san whinumter losan.” ");
INSERT INTO kyb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kinagka'ay Hesus chanan chacha''or ja whananog gway ili gway nansuyusuyu san umajana ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kun anan nan osa taku an sija, “Apu, adja a''itan chanan mataku?” Kun anan Hesus an chicha, ");
INSERT INTO kyb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wha'on kus angsan tan sa'ad nan chayanay umoy ad langit isun nan nalipitay onob. Sija nan igkaju nan lobhongjuway lumno' san nalipitay sagwang gway umoy ad langit tan iwhaka' an cha'ajuway angsan nan mamachas gway lumno' gwon achicha kun ma'erno'. ");
INSERT INTO kyb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tan sa'ad nu sumi'ad nan sin'ugwa san hoyoy ja ongwhana nan sagwang ilukijuway sumi'ad ad pagway ad nan'ab'ab aju san onob gway manggwanaon, ‘Apu, perno'on cha'amiyud!’ Ad summungwhat gway manggwana an cha'aju, ‘Achi' kun akammu nu agwan nan nerpugwanju!’ ");
INSERT INTO kyb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ad ananju, ‘Na'a'an ami ja na'iinum ami an si'a ja sa'ad sasan chayan san ilimi nansuyu'a.’ ");
INSERT INTO kyb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gwon kuminga gway manggwana an cha'aju, ‘Achi' kun akammu cha'aju nu agwan nan nerpugwanju. Umachaju aju an sa'on cha'aju losanay manggwamanggwa san lagwing!’ ");
INSERT INTO kyb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ad asijiiwhil aju ja mangngilngiltonju nan whawhaju nu ilanju cha Abraham, Isaac, Jacob ja nan losanay profeta san Mantuyajan Apudyus gwon as cha'aju mitoper aju san lasin! ");
INSERT INTO kyb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ad ummali chanan takuway merpu san hu'nakon nan init ja merpu san si'uton nan init ja merpud lakud ja merpud apyay ad tummu'chucha san oo''anan gway ma'a'an an Apudyus san Mantuyajana. ");
INSERT INTO kyb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chongyonju, agwad chanan nawhawha taku gway mipangatu ja agwad chanan nangatu taku gway mipawhawha.” ");
INSERT INTO kyb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa'ad san sachiyay chimpu ummachayug nan uchumay Pariseo gway manggwana an Hesus, “Lumajaw'ad asna tan whayugwon Herod gway ipaotoy as si'a!” ");
INSERT INTO kyb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gwon anana an chicha, “I'aju iwhaka san sanatay nasi'ap gway mamperjaperjagwa' sasan chimunju ja ipawhayu' chanan nasa'it san sana ja as whikat ad san mi'atlu erkaw pungpungo' nan terwhasu'. ");
INSERT INTO kyb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gwon maserpu sa'ad as sa'on san sana erkaw, whikat ja as awhikatna mangwhaata' kapu tan achi kun mawhalinay matoy nan osaay profeta san lasin nan Jerusalem.” ");
INSERT INTO kyb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sachi ad anan Hesus, “Ina'ay ajuway iJerusalem, cha'aju nan nangtoy sasay profeta ja naminwhintug san ingwhaun Apudyus an cha'aju! Nadnachi whayugwo'ay umali asinuton cha'aju as isun nan manga'owhan nan angnga' san isiwna gwon lagwingonju! ");
INSERT INTO kyb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chongyonju, taynan Apudyus nan Temploju. Iwhaka' an cha'ajuway achiju kun maila asin as sa'on ingkanas ananjuwon, ‘Piyan as sija gway umali san ayobhongan Apudyus.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sa'ad san osa Erkaw gway Umillongan san ummoy Hesus na'a'anan san hoyoy nan osa sasan pangat chanan Pariseo, sisipputancha as sija. ");
INSERT INTO kyb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kun iningkaw nan osa laya'iyay nallotyotog nan longagna san sangun Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Inimus Hesus sasan mangaagkammu san lintog ja chanan Pariseo gway manggwana, “Ad mijuja san Erkaw gway Umillongan nan mangipawhayu san nasa'it gwinnu achi?” ");
INSERT INTO kyb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gwon kummikinno'cha. Gwot inognan kun Hesus chay laya'i impawhayuna kun pinerjawna as sija. ");
INSERT INTO kyb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kun anana an chicha, “Ngachanna an cha'aju nan agwad nan ana'na gwinnu wha'ana gway naotchag san huhun, ad achi maanooy gway mang'at an sija san Erkaw gway Umillongan?” ");
INSERT INTO kyb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gwot achicha kun ma'asungwhat sannaja. ");
INSERT INTO kyb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nanagwat as Hesus sasan naajakan. Iniilana ku chanan mangili gway mampilis awhayugwanay tu'chugwan anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu agwad mangajag an si'a san hoyay maserpu achi'a umoy tu'chu san awhayugwanay tu'chugwan tan agwad ad nangatngatu an si'a as inajakana ");
INSERT INTO kyb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ja umali nan nangajag an cha'ajuway chugwa gway manggwana an si'a, ‘Atchom an sija nan sanat gway tu'chugwam’ ad nawhainan'a umoy san audchijanay tu'chugwan. ");
INSERT INTO kyb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Jon sa'ad nu ajakan cha'a i'a tu'chu san audchijanay tu'chugwan tot sa'ad nu umali nan nangajag an si'a anana an si'a, ‘Huyun, i'a tu'chu san whayu tu'chugwan.’ Ad nichajaw'a san sangun nan losanay huyunnu tumu'chu san oo''anan. ");
INSERT INTO kyb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tan nan losanay mangipangatu san longagna ipawhawhan Apudyus ad nan mangipawhawha san longagna ipangatun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kun anan ahos Hesus san nangajag an sija, “Nu manajag'as ma'a'an san mamatu' gwinnu san lawhi achim ajakan chanan huhuyunnu gwinnu susunudnu, chochogkam ancha whawha'nang gway cherragnu tan ajakan cha'a hos ad nangngachan whajad nan inggwam. ");
INSERT INTO kyb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jon sa'ad nu mampakagaja'a ajakam chanan whawha'sigwot, chanan nawhi'ug, chanan napilay ja chanan na'uyap. ");
INSERT INTO kyb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ad piyan'a tan achicha kun mawhajachan as si'a tan whajachan cha'a an Apudyus san manakuwana sasan nalintokay taku.” ");
INSERT INTO kyb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chingngorn kunan osa sasan na'a'an an Hesus anana an Hesus, “Piyan nan takuway umoy ma'a'an san kagaja san Mantuyajan Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kun anan Hesus an sija, “Iningkaw nan osa takuway nampakagaja kun inajakana nan angsanay taku. ");
INSERT INTO kyb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kun ingwhaunna nan mudchachuna san niwhatug nan sachi kagaja tot iwhakana sasan naajakan gway manggwana, ‘Umali aju tan nisakana nan losan.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gwon nasinossacha nallasun losan. Anan nan osa say mudchachu, ‘Nalla'uwa' as tayun ad maserpu iya' ilan. Sija nan maagwatam otjan.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kun anan nan osa, ‘Nalla'uwa' as simpuyus wha'a ad iya' ipachas chicha. Sija nan maagwatam otjan.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kun anan ahos nan osa, ‘A''aasagwaa' ad sija nan achiya' kun umali.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Gwot lummajaw chay mudchachu kun ingwhakana san amuna nan losanay ingwhakacha. Gwot nalingu kus amod nan sin'ugwa san hoyoy anana say mudchachuna, ‘Kanasomay umoy sasan ersa ja sasan chayan san ili ad sa'ad chanan whawha'sigwot, chanan nawhi'ug, chanan na'uyap ancha chanan napilay ijalim chicha ad asna.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tinungpern ku chay mudchachu nanagkulin say amuna kun anana, ‘Apu, naahus'u inggwa chay ingwhakam ad kochangnaay agwad nan magkagwan.’ ");
INSERT INTO kyb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kun anan chay amuna san mudchachuna, ‘I'a sasan ersa ja sasan chayan san lasin nan ili ad impapilitnu iwhaka sasan taku ta umalicha tot mapnu nan hoyoy'u. ");
INSERT INTO kyb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iwhaka' an cha'ajuway maid kun osa sasay ummunaay inajaka' as mangippong san insakana'.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sa'ad san anna mituntunud nan amochay taku an Hesus nansakung kun anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nu agwad mitunud an sa'on ja sija napatpatog an sija cha amana, inana, asagwana chanan anana'na, chanan susunudna ja uyay pay nan longagna, wha'on kus miwhilang as pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu ngachan nan achi ma'iijattom san likat kapu san mitunuchana an sa'on achi kun miwhilang as pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tan nu agwad osa an cha'ajus mamangkop mampata'chor san anchaanchuway pata'chor, ad achi sija oona nan tumu'chu jan tot somsom'ona nu aman nan makastuna, nu agwad umanay as pila' as mamungpungna? ");
INSERT INTO kyb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tan nu tinuudna nan tamangna ja achina kun mapungpung losanay mangila amamangonchas sija ");
INSERT INTO kyb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","gway manggwana, ‘Sa'ad nannaja taku nilukijana nampata'chor gwon achi kun ma'apungpung!’ ");
INSERT INTO kyb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Gwinnu nan osa ali gway umoyna kuwhaton nan sawhali ali, ad achi tumu'chu jan ta somsom'onaay ustu nu loogna san simpuyu lihu surchachuna gway umoy kuwhaton nan sawhali ali gway chugwampuyu lihu nan surchachuna? ");
INSERT INTO kyb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ad nu achina loog san achaju pay nan ahursurna, mangwhaun as umoy mangahot ta ochagwona gway mampochoncha. ");
INSERT INTO kyb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sija nan nu ngachanna an cha'aju nan achi manaynan san losanay u'ugwana achi kun mawhalinay mangngachan pasuyut'u.” ");
INSERT INTO kyb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nanagwat as Hesus gway manggwana, “Whayu nan asin gwon nu ma'aan nan tamtamna ininona ma mansubli nan tamtamna? ");
INSERT INTO kyb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tan achi kun mauser san luta gwinnu mauser as ahunu. Miwhallucha. Nu ngachan nan naingaan maserpu manchongor!” ");
INSERT INTO kyb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","San namingsan iningkaw chanan manchachakup san hugwis ja uchumay humersuwhersu gway ummoy ummachayug an Hesus ta manchongorcha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kun asijaajumuum chanan Pariseo ja chanan mangaagkammu san lintog gway manggwana, “Nan osaanna taku ma'ahubuyun sasan humersuwhersu ja ma'a'an an chicha!” ");
INSERT INTO kyb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sija nan nanagwat as Hesus an chicha gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngachanna an cha'aju nan agwad nan singkasutay kernerona ja nataya' nan osa an chicha, adja ngachamma nan oona? Jo'o ja achina taynan nan sijampuyu ja sijam san puyag ad ummoyna inanap chay osa nataya' ingkanas ochasana. ");
INSERT INTO kyb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ad nu inchasana hu'uchonaay mallagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ad sa'ad nu humu'nag san hoyoyna ajakana chanan huhuyunna ja chercherragna gway manggwana an chicha, ‘Ma'ayagsa' aju an sa'on kapu tan inchasa' nan kernero' gway nataya'.’ ");
INSERT INTO kyb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iwhaka' an cha'ajuway sa'ad ad langit sinumamod nan lagsa' kapu san osa humersuwhersu gway nanchu'kana nan whersuna nu chanan sijampuyu ja sijamay nalintog gway ananchaon achicha kun maserpu manchu'kan nan whersucha.” ");
INSERT INTO kyb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Anan ahos Hesuson, “Nu agwatna agwad osas huwhai gway anna simpuyu pila'na aka ja tinaya'na nan osa, ngachan nan oona? Ngokkana nan silaw ad sinakachana nan hoyoyna ad inammana anapon ingkanas ochasana. ");
INSERT INTO kyb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ad sa'ad nu ochasana ajakana chanan huhuyunna ja chercherragna gway manggwana, ‘Ma'ayagsa' aju an sa'on tan inchasa' nan pila'ay tinaya''u.’ ");
INSERT INTO kyb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ad isuna hosay iwhaka' an cha'aju gway mallaylajad chanan a'anghel Apudyus kapu san osa humersuwhersuway nanchu'kana nan whersuna.” ");
INSERT INTO kyb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Intuyuy Hesus gway manggwana, “Iningkaw nan osa takuway chugwa nan ana'na laya'i. ");
INSERT INTO kyb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ad anan nan uchichi san amana, ‘Ama, atchom an sa'on nan la'sun'u.’ Kun whinillay amacha nan la'sunna an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Meerkagwanan kus amana erkaw illa'un chay uchichi nan losanay la'sunna kun nangwhaat san achaju ili. Kun whinushusna nan pila'na san maid kun kutu'naay whijag. ");
INSERT INTO kyb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Inaminna ku hushuson nan pila'na hummu'nag nan amod gway uyat san sachiyay ili kun illukinaay mananap as maserpuna. ");
INSERT INTO kyb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sija nan ummoy nampapujung san osa taku san sachiyay ili, kun impooynas sija san tayunna tot papa''anana nan hoyo'. ");
INSERT INTO kyb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ad kapu san whitilna whayugwona ekajay mangan san hokas nan ajuway carob gway anon nan hoyo' gwon maid kun osas mangatod an sija as anona! ");
INSERT INTO kyb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Gwon nanomosomo' kus sija anana, ‘Losanay mallabyabhuwon ama angsan nan mahunancha ma'an gwon annaa' ad asnaay matoy san whitil! ");
INSERT INTO kyb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iya' lumajaw an ama ad ingwhaka' an sija ananon, “Ama, hummersuwa' an Apudyus ja an si'a. ");
INSERT INTO kyb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Achiya' kun miwhilang gway maagwakan as ana'nu. Oom as sa'on as osa sasan mallabyabhuwom.” ’ ");
INSERT INTO kyb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Lummiggwat kun ummoy nanulin an amana. Ad sa'ad san achaju pay as sija chimmang amana as sija kun nachaku an sija gwot nanodcha' kunay ummoy nangahot an sija, inagwornaot inchoomna nan apingna san aping nan ana'na. ");
INSERT INTO kyb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kun anan chay ana'na an sija, ‘Ama, hummersuwa' an Apudyus ja an si'a. Achiya' kun miwhilang gway maagwakan as ana'nu.’ ");
INSERT INTO kyb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Gwon anan amana sasan mudchachuna, ‘A''agwayyu, ijaliju nan awhayugwanay lagkoyloy gway silup ad sinilupanjus sija ad siningsinganju ja sapatusanjus sija. ");
INSERT INTO kyb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ja i'aju ayan nan punor pinorrag gway wha'a ta pertiyonju as ischa ta'u ta mallagyagsa' ta'u ");
INSERT INTO kyb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kapu tan sa'ad nan annaja ana''u anigna natoy gwon nataku. Isun chi nataya' gwon na'chasan.’ Kun illukichaay mallagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Gwon sa'ad nan panguyu gway ana'na agwad san tayun. Lummajaw kunot takangay san hoyoy chingngorna chanan takuway mallagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Inajakana kunan osa sasan mudchachu inimusna nu ngachan nan ma'ma'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kun anana an sija, ‘Sa'ad nan sunudnu annad asna hummu'nag ad sa'ad as amam namperti san punor pinorrag gway wha'a kapu tan whawhayus sija pinahu'nagna.’ ");
INSERT INTO kyb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Gwon nalingus sija kun lagwingona lumno' san hoyoy. Gwot sa'ad as amana lummagwa kun ina''ayu'nas sija ta lumno'. ");
INSERT INTO kyb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gwon anana gway summungwhat an amana, ‘Ilam ad, angsanay tagwon nan nansilsilwhiya' an si'a kun achi' kun sinu'su'il nan ingwhakam. Gwon as sa'on maid kun ina''atodnu as osas mernus gway erching as ma'ayagsa''u otjan sasan huhuyun'u. ");
INSERT INTO kyb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gwon sa'ad nannaja ana'nu gway namushus san u'ugwam sasan hubhuwhaiyay naukor hummu'nag kun impertiyam as sija san punor pinorrag gway wha'a.’ ");
INSERT INTO kyb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Gwot anan amana an sija, ‘Ana''u, patinajunay iingkaw'a an sa'on ad nan losanay u'ugwa' ugwam. ");
INSERT INTO kyb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gwon maserpuway mallagsa' ja mangkankanas ta'u kapu tan sa'ad nannaja sunudnu anigna natoy gwon nataku. Anigna nataya' gwon na'chasan.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Anan ahos Hesus sasan pasuyutna, “Iningkaw nan osa wha'nangay anna nan manaadchukona san whina'nangna. Impinitcha say wha'nangay hushushuson chay manaadchukona nan nitayo' an sija gway u'ugwana. ");
INSERT INTO kyb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sija nan impaajagna chay manaadchukona kun anana an sija, ‘Ngachan nannaja chongyochongyo' gway mipangkop an si'a? Atchom losan an sa'on nan listaan nan iyachugnu gway whina'nang'u tan wha'on kunon as si'a nan manaadchuko'.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kun anan chay manaadchukona san somsomo'na, ‘Ngachan nan oo' kapu tan sa'ad nan amu' aanona' san terwhasu'? Achi' kun loog gway mantayun ja mawhaina' gway mampalimus. ");
INSERT INTO kyb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, akammu'on nan oo' tot sa'ad nu ma'aana' san terwhasu' ajakana' sasan taku san hohoyoycha.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Inajakana kunan losanay nanutang say amuna anana san ummuna, ‘Aman nan utangnu san amu'?’ ");
INSERT INTO kyb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kun anan chay laya'i, ‘Singkasutay hurnay gway lana.’ Kun anan chay mangijaachug an sija, ‘Ayam nan listaam ad tummu'chu'a, kanasomay ilista nan limampuyu.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kun anana san osa, ‘Si'a kay, amanma utangnu?’ Anan chay laya'i, ‘Sillihu sayup gway kerkergwit.’ Anan chay mangijaachug, ‘Ayam nan listaam ad illistam nan gwayungkasut.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Sachi kun pinachajagwan chay wha'nang chay wha'on kus ustu nan o'o''ona manaadchukona kapu san silib gway inggwana. Tan sa'ad chanan taku san anna luhung gway achi mamati nasissilibcha san o'o''oncha nu chanan takuway mamati. ");
INSERT INTO kyb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ad iwhaka' an cha'aju gway usayonju chanan whina'nangju gway ma'ahubuyun sanna luta tot mamin ad mawhalinay ajakan cha'aju san maid pungpungnaay ingkagwan. ");
INSERT INTO kyb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nan takuway mantayo'an san uyay aa''itanay ipaijachugcha an sija mantayo'an ahos san cha'or. Gwon nan takuway wha'on kus mantayo'an san a''itan wha'on kuhos as mantayo'an san cha'or. ");
INSERT INTO kyb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ad nu wha'on aju kus mantayo'an san whina'nang ad asna luta ngachan manan mangitayo' an cha'aju san tuttuwaay whina'nang? ");
INSERT INTO kyb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ad nu wha'on aju kus mantayo'an san ugwan nan uchum ngachan manan mangatod an cha'aju as ugwaju? ");
INSERT INTO kyb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maid kun mudchachus chugwa nan amu as isilwhiyana. Tan kuyaona nan osa ad impatogna nan osa. Ipapatinaay mansilwhi san osa ad nilagwingna nan osa. Wha'on kus mawhalinay mangkisanonju nan Apudyus ja nan whina'nang mansilwhiyan.” ");
INSERT INTO kyb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chingngorn kun chachay Pariseo gway mangipatpatog san pila' nannachaja losan inamamangcha as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Gwon anan Hesus an chicha, “Cha'aju nan manggwana san longagjuwon nalintog san mangilan chanan taku gwon akammun Apudyus nan somsomo'ju. Tan sa'ad chanan ingwhilang chanan taku as amod napatog akuyan Apudyus as amod. ");
INSERT INTO kyb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sa'ad nan lintog Moses ja nan illistan chachay profeta sija nan sinuyut chanan taku san chaan pay humu'nag as Juan gway Manghohonjag. Hummu'nag kus Juan impaakammuna nan Whayuway Chamag gway mipangkop san mangituyajan Apudyus sasan takuna kun angsan nan mangipapilitay lumno'. ");
INSERT INTO kyb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ta'on nu amaschi wha'on kus pijaona anan nan maid kun silwhin nan Lintog kapu tan naya'ya'a nan maumasan nan langit ja luta san maumasan nan osa chokan nan lista san lintog. ");
INSERT INTO kyb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nu ngachan nan laya'iyay mangichang san asagwacha ja mangasagwacha san uchum miwhilangay namuwhai. Ad nan mangasagwa san naichangan gway huwhai miwhilang ahos gway namuwhai.” ");
INSERT INTO kyb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Anan Hesus, “Iningkaw nan osa wha'nang gway nansisillup san man'apapatog gway silup, mallagsayagsa' san whinikat ja maag ekay mangamangan. ");
INSERT INTO kyb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iningkaw ahos nan osa wha'sigwot gway mangngachan Lazaro. Napnu san kakerto nan longagna, miijiijoy san sagwang nan hoyoy chay wha'nang ");
INSERT INTO kyb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","gway whayugwona umoy manchakup as anona san hugtaay majagjag san silu' nan oo''anan chay wha'nang. Ad choon chanan asu chilchilan nan kakertona. ");
INSERT INTO kyb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Natoy kun chay wha'sigwot iyoy chanan a'anghel san agwachan Abraham ad langit. Kun natoy ahos chay wha'nang kun niilhon. ");
INSERT INTO kyb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maliglikatan kus sija as amod ad ingwhilnu, nantangad kun inilana as Abraham san adadchajuwan gway huyunna as Lazaro. ");
INSERT INTO kyb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Kun nampo'aw chay wha'nang gway manggwana, ‘Ama Abraham! Achakugwana'ud ad ingwhaunnu as Lazaro ta ituyno'na nan pagpag nan kammatna san chanum ad impatakaliyongna nan chila' tanna maliglikatana' as amod sannaja apuy!’ ");
INSERT INTO kyb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Gwon anan Abraham, ‘Ana''u, somsom'om gway naagwatnu chanan whayu san matattakuwam ad as Lazaro naagwatna nan lagwing. Gwon san sana annad asna maliwligwa ad sa'ad as si'a maliglikatan'a. ");
INSERT INTO kyb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ja wha'on kus ahus nat agwad nan adadchayo'anay onga' nan luta gway nanghoyaatan ta'u tot sa'ad chanan mamayu umalid asnat gway merpud asna achicha kun ma'gwa gwinnu merpud asnat gway umali chumormang ad asna.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kun anan chay wha'nang, ‘Ad mampa'pa''aasiya' angkay ama Abraham ta iwhaunnus Lazaro san hoyoy cha ama' ");
INSERT INTO kyb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tan agwad chanan lima susunud'u lallaya'i ta umoyna whagan chicha tot achicha hos umali sannaja annaan nan amochay likat.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Gwon anan Abraham, ‘Agwad an chicha nan illistan Moses ja chachay profeta gway mamagwhaka an chicha. Maserpu chumngorcha an chicha.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Gwon anan chay wha'nang, ‘Wha'on kus umanay chi ama Abraham! Nu agwad osas mataku sasan natoy gway umoy an chicha manchu'kancha nan whersucha.’ ");
INSERT INTO kyb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Gwon anan Abraham an sija, ‘Nu achicha patiyon nan illistan Moses ja chachay profeta achicha kun mamati uyay nu agwad osas mataku sasan natoy as umoy.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Anan Hesus sasan pasuyutna, “Nan mangkapugwan nan humasuyan nan taku umaliyay umali gwon amod a'oogjat nan ma'gwa san osa takuway mangkapugwan nan whersu! ");
INSERT INTO kyb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Unayna ekay mita'od nan cha'or kikillinganay whatu san whakangna ad nitubung san whaywhay nu nan mangkapu as humasuyan nannachaja namati. ");
INSERT INTO kyb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ammanju ilan nan longagju! Nu humersu nan huyunnu amujuwam ad nu manchu'kana nan whersuna ligwatam nan whersuna. ");
INSERT INTO kyb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ad nu mangimpitu humersu an si'a san osa erkaw ja mangimpitu umali an si'a ananon, ‘Manchu'ka' nan whersu',’ ligwatam nan whersuna.” ");
INSERT INTO kyb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Anan chanan apostoles an Apu Hesus, “Chogwam nan pammatimi.” ");
INSERT INTO kyb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kun anan Apu Hesus gway summungwhat, “Nu agwad pammatijus isun nan acha'orn nan hu'orn nan mustard mawhalinju anan sannaja sikamoro gway aju, ‘Mau'put'a ad nanatun'a san whaywhay!’ ad mawhalinay patiyon cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kun intuyuy Hesus gway manggwana, “Sa'ad nu agwatnaay osa an cha'aju nan agwad nan mudchachuna gway manaayachu gwinnu mampaspastur sasan kernero gway hummu'nag gway nerpu san tayun, adja anam an sijaon, ‘Kanasom ta umali'a mangan?’ ");
INSERT INTO kyb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wha'on! Gwon sija iwhakam an sija nan, ‘Isakanam nan ano' ad asi'aot mansu'at ad chinurnguwana' sanna mangamangana' ad mappunga' ad mangan asi'aot mipasu mangan.’ ");
INSERT INTO kyb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Adja manjaman'a san mudchachum nu inggwana nan impa'gwam an sija? Achi! ");
INSERT INTO kyb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Isuna hos an cha'aju gway nu inggwaju nan losanay impa'gwacha an cha'aju, ananjuwon, ‘Maid kun silwhimiyay mudchachu, inggwami ekay nan terwhasumi.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sa'ad san umajan Hesus ad Jerusalem nangoy san nanghoyaatan nan Samaria ja Galili. ");
INSERT INTO kyb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mayungay kusan osa ili inahot nan simpuyu lallaya'iyay naleprosi gway nasi'asi'adcha san achajus a'it. ");
INSERT INTO kyb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Kun nampo'awcha gway manggwana, “Hesus! Apu! Achakugwamud cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Inilana kun chicha anana an chicha, “I'aju ad nampaila aju sasan papachi.” Agwadcha kusan chayan hummayucha. ");
INSERT INTO kyb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ad sa'ad nan osa an chicha inilana kunay hummayu as sija nanulin gway nangichaychajaw an Apudyus san towhakay kinga. ");
INSERT INTO kyb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kun nampalintumong san whatug nan i'in Hesus gway nanjaman an sija. Nannaja taku iSamaria. ");
INSERT INTO kyb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kun anan Hesus, “Jo'o achi simpuyu chachay hummayu? Kunja umma chanan sijam? ");
INSERT INTO kyb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kaman ahus ekay annajaay ikaja' as nanulinay manjaman an Apudyus?” ");
INSERT INTO kyb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kun anan Hesus an sija, “Sumi'ad'a ta lumajaw'a. Kapu san pammatim hummayu'a.” ");
INSERT INTO kyb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sa'ad san namingsan nanimus ku chanan Pariseo an Hesus nu ma'anu umaliyan nan Mantuyajan Apudyus, summungwhat gway manggwana an chicha, “Sa'ad nan Mantuyajan Apudyus wha'on kus umali gway mama''ila. ");
INSERT INTO kyb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gwon maid kun osas manggwana, ‘Ilanju, annad asna!’ gwinnu ‘Anchiya ad aschi!’ Tan ilanju, sa'ad nan Mantuyajan Apudyus anna an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Gwot anan Hesus sasan pasuyutna, “Humu'nag nan chimpuway whayugwonju ilan as sa'onay Ana' nan Taku uyay osa ekajay erkaw gwon achi kun jan mawhalin. ");
INSERT INTO kyb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Agwad chanan manggwana an cha'aju, ‘Ilanju, anchiyad aschi as sija!’ gwinnu ‘Ilanju, annad asna as sija!’ Achi aju umoy an chicha gwinnu mitunud an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tan sa'ad as sa'on gway Ana' nan Taku managkulina' gway isun nan misigwatan nan ilat ad langit gway sumlit. ");
INSERT INTO kyb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gwon nan umuna maserpuway mapachasa' nan angsanay likat ja lagwingona' san annaja lunap. ");
INSERT INTO kyb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ad isun chay na'gwa san chimpun Noe, amasna ahos nan ma'gwa nu managkulina' gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","San sachi nanganangancha, umminiinumcha ja nanasasagwacha ingkana san erkaw gway nilumno'an Noe san papur kun hummu'nag nan itap kun inanudna chicha losan. ");
INSERT INTO kyb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Isun ahos san chimpun Lot. Nanganangancha ja umminiinumcha, nalla'uya'ucha ja nalla'ya'ucha, nammuyamuyacha ja nampatapata'chorcha sasan hoyoy. ");
INSERT INTO kyb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gwon sa'ad san erkaw gway nanaynanan Lot san iliyay Sodoma ummuchan san apuy ja asupre gway nerpud langit kun intoyna chicha losan. ");
INSERT INTO kyb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Isun ahos nan ma'gwa san erkaw gway manulina' gway Ana' nan Taku gway sa'ad chanan taku achicha kun na'asakana. ");
INSERT INTO kyb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“San sanatay erkaw, nu ngachan nan agwad san otop nan hoyoyna achi kun lumno' gway mangayas whayangna as ijagwidna. Ad isun ahos nan agwad san tayun gway achi kun lumajaw ad ugwacha. ");
INSERT INTO kyb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Somsom'onju nan na'gwa say asagwan Lot! ");
INSERT INTO kyb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nu ngachan nan ahus nan whijagnas patpatkona, achi kun ma'awhijag an Apudyus as ingkaingkana gwon nu ngachan nan achi mangipatog san whijagna kapu an sa'on, ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iwhaka' an cha'aju gway nu lawhi nan managkulina' ja agwad ad chugwas taku as nanassuy san osa susuypan, nan osa maaya mipangatu ad nan osa mataynan. ");
INSERT INTO kyb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Agwad ad chugwas huwhais mangkilikiling san kikillingan sa'ad nan osa maaya mipangatu ad nan osa mataynan. ");
INSERT INTO kyb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Agwad ad chugwas laya'iyay manterwhaterwhasu san pajaw nan osa maaya mipangatu ad nan osa mataynan.” ");
INSERT INTO kyb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kun anan chachay pasuyutna an sija, “Agwanna nan ma'gwaan ninat, Apu?” Gwot anan Hesus an chicha, “Nu ngachan nan maayusan chanan hu'aw sachi nan mangipailaay agwad nan lachag sichi ad sija nan sa'ad nannachaja imatun ipailanaay takangay nan anungus nan erkaw.” ");
INSERT INTO kyb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nanagwat as Hesus sasan pasuyutna tot suyuwana chicha gway maserpu patinajunay mallugwayucha ja achicha ngumangngaja. ");
INSERT INTO kyb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anana, “Agwad nan osa manguu'um san osa ili gway achi kun umogjat an Apudyus ja maid kun whigwhikonas taku. ");
INSERT INTO kyb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kun iningkaw nan osa nawhayu san sachi hosay ili. Kun umuumoy say manguu'um gway manggwana, ‘Whachangana'ud gway mangilintog san lilimi san alili'!’ ");
INSERT INTO kyb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nawhajakay achin kunan manguu'um atinguyon gwon anungusna kun anana san somsomo'na, ‘Uyay nu achiya' umogjat an Apudyus ja maid whigwhiko' as taku ");
INSERT INTO kyb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gwon kapu tan singsingaona' sannaja nawhayu atcho' ekay nan ochaochagwona. Tan sa'ad nu achi' atchon umaliya' ta'tata'ta'on an sija ad tugwakay mamin nan anus'u.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kun anan Apu Hesus, “Chongyonju nan anan nan wha'on kus nalintokay manguu'um. ");
INSERT INTO kyb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Adja achin Apudyus whachangan chanan pinilina gway mampawhachang an sija san inerkaw ja nilawhi? Adja itantannaay mamachang an chicha? ");
INSERT INTO kyb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iwhaka' an cha'aju gway achina kun whajakonay mamachang an chicha. Gwon sa'ad as sa'on gway Ana' nan Taku nu umaliya', ad agwad ochasa' as takus mamati an sa'on ad asna luta?” ");
INSERT INTO kyb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kun ingwhakan ahos Hesus nannaja agwat san uchumay mantayo' san longagcha gway nalintogcha ja mangamsaamsiw san uchumay taku. ");
INSERT INTO kyb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Iningkaw nan chugwa laya'iyay ummoy nallugwayu san Templo. Nan osa Pariseo ad nan osa manchachakup san hugwis. ");
INSERT INTO kyb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sa'ad nan Pariseo summi'ad kun anana san somsomo'na gway mallugwayu, ‘Apudyus, manjamana' an si'a tan wha'ona' kus isun nan uchumay taku gway tulisan, wha'on kus nalintog, mamuwhai gwinnu wha'ona' kus isun nannaja manchachakup san hugwis. ");
INSERT INTO kyb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mamiggwaa' mallaun san sinchumingkugwan, atcho' nan mi'asimpuyu koggwan nan chatun'uway merpu san losanay tinerwhasu'.’ ");
INSERT INTO kyb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Gwon sa'ad nan manchachakup san hugwis summi'ad san achaju gway achina kun ekay mitangad nan atana ad langit. Gwon inab'a'ab'abna nan whayu'ungna gway manggwana, ‘Apudyus, achakugwam as sa'on gway humersuwhersu!’ ");
INSERT INTO kyb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iwhaka' an cha'aju gway nannaja taku lummajaw ad ugwacha gway nagwasgwas nan whersuna gwon wha'on kus nagwasgwas nan whersun chay Pariseo. Tan nan gwaschi mangipangatu san longagna ipawhawhan Apudyus gwon nan mangipawhawha san longagna ipangatun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iningkaw nan uchumay taku nangijoy ahos an Hesus san anana' tot ipatayna nan imana an chicha. Inilan kun chachay pasuyut chicha chinogjajancha chicha. ");
INSERT INTO kyb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gwon sa'ad as Hesus inajakana nan anana' an sija kun anana, “Ijujaju nan anana'ay umali an sa'on ad achiju chicha ijachi tan nan isun nan a'ammasna anana' mitapicha sasan takuway ituyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tuttuwa iwhaka' an cha'aju, nu ngachan nan achi mamati san Mantuyajan Apudyus as isun nan manuttugwan nan osa ana' achi kun mitapi sasan ituyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iningkaw nan osa pangat nan Hudyu gway nanimus an Hesus gway manggwana, “Whayuway Mistuyu, ngachan nan oo' ta ma'awhijaka' an Apudyus as ingkaingkana?” ");
INSERT INTO kyb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kun anan Hesus an sija, “Kamman mangngagnon as sa'on whayu? Maid kun uchum as whayu nu achi ahus as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akammum chanan whilin Apudyus: ‘Achi'a ma'assuy san wha'on kus asagwam. Achi'a pumatoy. Achi'a mana'aw. Achim ta'choyan nan tuli gway mihursu san osa taku. Chumngor'a an cha amam an inam.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kun anan chay laya'i, “Sa'ad nannachaja in'abwhanog'u inggwa.” ");
INSERT INTO kyb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chingngorn kun Hesus anana an sija, “Agwad nan osa uyangnu. Sa'ad nan losanay u'ugwam ila'um ad inatodnu nan la'una san whawha'sigwot ad agwad nan whina'nangnu ad langit. Ad ummali'a nitunud an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gwon chingngorn kun chay wha'nang nannaja amod nan sasangana tan amod nan whina'nangna. ");
INSERT INTO kyb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inilan kun Hesus as sija gway amod nan sasangana anana, “Sa'ad nan takuway sija ekay ipatogna nan inawha'nang, mansikab as mitapi sasan takuway ituyajan Apudyus! ");
INSERT INTO kyb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Amod mansikab nan mitapijan nan taku sija ekay ipatogna nan inawha'nang sasan takuway ituyajan Apudyus nu nan lumno'an nan kamel san ahut nan chakum.” ");
INSERT INTO kyb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Gwon sa'ad chanan takuway nangngor san ingwhakan Hesus anancha, “Ad ngachan maangkay mataku nu'?” ");
INSERT INTO kyb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kun anan Hesus, “Nan achin nan taku ma'gwa, ma'gwan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kun anan Pedro, “As cha'ami kay, tinaynanmi nan losanay u'ugwami kun nitunud ami an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kun anan Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway nu ngachan nan manaynan san hoyoyna, asagwana, susunudna, amana, inana ja anana'na kapu san Mantuyajan Apudyus, ");
INSERT INTO kyb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","amamod angsan nan maayana san sana chimpu ja san umaliyay chimpu ma'awhijag an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Inta'iyan kun Hesus nan nasagwayan as chugwaay pasuyutna anana an chicha, “Chongyonju! Inta'u ad Jerusalem ad natungper nan losanay illistan chachay profeta mipangkop an sa'on gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tan mipawhijanga' sasan wha'on kus Hudyu, maamamanga', maamsaamsigwa', matubwhatubwhaana', ");
INSERT INTO kyb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","masaplisaplitana', otojonchas sa'on ad mi'atlu achay erkaw matakuwa'.” ");
INSERT INTO kyb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gwon maid kun naagwatancha san ingwhakana. Nitayu an chicha nan pijaona anan chay ingwhakana kun achicha kun naagwatan chay ingwhakan Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Takangay kus Hesus ad Jerico iningkaw nan osa na'uyap gway tummutu'chu san ikid nan chayan gway mampalpalimus. ");
INSERT INTO kyb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chingngorna kun chanan takuway asilayaus inimusna nu ngachan nan ma'ma'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kun anancha an sija, “As Hesus gway iNazaret nan lumaus.” ");
INSERT INTO kyb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kun nampa'uy gway manggwana, “Hesus gway kana' Dabid achakugwana'ud!” ");
INSERT INTO kyb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ad sa'ad chachay takuway namangpangu lumaus inamujuwanchas sija ta kumino'. Gwon iyamamodnaot impa'uy gway manggwana, “Kana' Dabid achakugwana'ud!” ");
INSERT INTO kyb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kun summinong as Hesus kun ingwhilinna ta ijoycha chay na'uyap an sija. Nijachayug kun anan Hesus an sija, ");
INSERT INTO kyb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngachan nan whayugwomay oo' an si'a?” Kun anan chay na'uyap, “Apu, aanomud nan uyap'u!” ");
INSERT INTO kyb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kun anan Hesus an sija, “Ma'aan nan uyapnu! Kapu san pammatim hummayu'a.” ");
INSERT INTO kyb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sachi kun maag ekay anna nan ilana kun nitunud an Hesus gway nanchaychajaw an Apudyus. Ad sa'ad nan losanay taku nangila san na'gwa nanchaychajawcha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Intuyuy kun Hesus gway umoy ad Jerusalem inoyna ad Jerico kun hummu'nag ad aschi. ");
INSERT INTO kyb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kun iningkaw nan osa takuway mangngachan Zakeo gway osa pangat nan manchachakup san hugwis. Wha'nang as sija. ");
INSERT INTO kyb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ad whayugwona ilan nu ngachanna as Hesus gwon achi kun ma'aila tan amod nan taku kapu tan abobobwha as sija. ");
INSERT INTO kyb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nanodcha' kunay ummuna sasan taku, ummayab san ajuway sikamoro tot ilanas Hesus kapu tan lumaus as sija san sachi chayan. ");
INSERT INTO kyb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Niwhatug kun as Hesus san agwachana nantangad as sija kun anana an sija, “Zakeo, kanasomay lumsa tan san sana erkaw maserpu umaliya' ad ugwaju.” ");
INSERT INTO kyb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kun kinankanas Zakeo gway nilumsa kun amod nan lagsa'na gway nangajag an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Inilan kunan losanay taku asijaajumuumchaay manggwana, “Ummoy nampamangili as sija san osa taku humersuwhersu.” ");
INSERT INTO kyb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Summi'ad kus Zakeo anana an Apu Hesus, “Chongyom, Apu! Sa'ad nan koggwan nan u'ugwa' atcho' sasan whawha'sigwot. Ad nu agwad osas nilu'u' whajacha' an sija as mangimpat nan aachuna nu san inaya'.” ");
INSERT INTO kyb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kun anan Hesus an sija, “San sana tinakun Apudyus nan wherjannu tan kana' kahos Abraham as si'a. ");
INSERT INTO kyb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tan sa'ad as sa'on gway Ana' nan Taku ummaliya' ta anapo' ja takuwo' chanan takuway nataya'.” ");
INSERT INTO kyb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sa'ad san nanchochongngoyan chachay taku an Hesus, intuyuyna gway nanagwat an chicha kapu tan takangay as sija ad Jerusalem kun anancha ekajon agwachay maanali nan Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sija nan anana, “Iningkaw nan osa takuway nangatu nan saadna gway umoy san achajuway ili tot agwatona nan mangngachanana ali ad mappung ad chi nanagkulin. ");
INSERT INTO kyb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sa'ad san chaanna lumiggwatan inajakana nan simpuyu mudchachuna kun nilnobna chichas sinnossa as mina kun anana an chicha, ‘Ijamusantiju ingkanas managkulina'.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Gwon sa'ad chanan ailijana aisilcha as sija, sija nan nangiwhaunchas umoy misu'nub mangiwhaka san manchutu' an sija ananon, ‘Lagwingonmi nannaja taku as man'alimi.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gwon nan'aliyoncha as sija. Nanagkulin kus sija san ilina impaajagna chanan mudchachuna gway nangatchana say pila' ta akammugwona nu aman nan nangipaachugwancha. ");
INSERT INTO kyb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ummoy kunan osa an sija anana, ‘Apu, sa'ad chay mina inatodnu ummana' as simpuyu.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kun anan chay ali an sija, ‘Whayu nan inggwam. Whayu'a gway mudchachu! Kapu tan mantayo'an'a san uyay a'it si'a nan mangituyay san simpuyuway ili.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kun ummoy nan mi'aggwaay mudchachu kun anana, ‘Apu, sa'ad chay mina inatodnu ummana' as lima.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kun anan chay ali an sija, ‘Si'a nan mangituyay san limaay ili.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kun ummoy nan osa ahosay mudchachu kun anana, ‘Apu, ilam, annaja chay mina gway inatodnu gway inulihuta' san panju kun intayu'. ");
INSERT INTO kyb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ummogjata' an si'a tan asisingon'a taku. Ayam nan wha'on as nanungayam ja apitom nan wha'on kus iniso'nu.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Anan chay ali an sija, ‘Nan ingwhakam sachi nan mallodchong'u an si'a, katkatungay mudchachu! Jo'o achim aagkammuway asisingona'ay taku gway aya' nan wha'on kus nanungaya' ja apito' nan wha'on kus iniso''u? ");
INSERT INTO kyb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kamman achi imbangku nan pila''u tot humu'naka' ad inaya' uyay nan ana'na?’ ");
INSERT INTO kyb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kun anan chay ali sasay nasi'asi'ad ad aschi, ‘Ayanju an sija nan mina ad inatodju say agwachan nan simpuyu mina.’ ");
INSERT INTO kyb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Gwon anancha an sija, ‘Apu, agwachon an sija nan simpuyu mina!’ ");
INSERT INTO kyb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Anan chay ali, ‘Iwhaka' an cha'aju gway nu ngachan nan anna ugwana maatchan as adachu. Gwon nan takuway maid ugwana uyay nan a'itay agwad an sija mumaid. ");
INSERT INTO kyb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ad sa'ad chachay ahursu'ay mallagwing an sa'on as man'alicha ijaliju chicha sannaja ta otojonju chicha san sangu'!’ ” ");
INSERT INTO kyb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nappung ku Hesus iwhaka chi intuyuyna gway ummoy ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Takangaycha kud Betfage ja Betania san whilig gway ma'gwaniyon Olibu impaunan Hesus nan chugwa sasan pasuyutna ");
INSERT INTO kyb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","gway manggwana, “I'aju sanchi chomangay ili ad sa'ad nu humu'nag aju agwad nan ochasanju gway uyhun nan asno gway niwhawhawwod gway chaan maawhajuwan. U'whachonju ad iyaliju sannaja. ");
INSERT INTO kyb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ad nu agwad manimus an cha'aju nu kajuman u'whachon iwhakaju an sija gway manggwana, ‘Maserpun nan Apu.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kun ummoy chachay niwhaun kun inchasancha chay ingwhakan Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","U'whau'whachoncha kun nan talin chay uyhun nan asno anan chanan sin'ugwa an chicha, “Kajuman u'whachon?” ");
INSERT INTO kyb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kun anancha, “Maserpun nan Apu na.” ");
INSERT INTO kyb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kun iyoycha an Hesus kun nappungcha ku iyap'ap nan kotap nan silupcha san ochog chay uyhun nangawhajuwonchas Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","San nangaabwhajuwana umoy ad Jerusalem, iyap'a'ap'ap chanan taku nan kotap nan silupcha san ajona. ");
INSERT INTO kyb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mayungay kus Hesus ad Jerusalem san oskanay whilig gway Olibu, illukin nan amochay pasuyutnaay mallaylajad gway nanchaychajaw an Apudyus san towhakay kingacha kapu sasan inilachaay mataakan. ");
INSERT INTO kyb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Anancha, “Piyan nan Ali gway umali san ayobhongan Apudyus! Kapu an sija na'aosossaan ta'u an Apudyus ja machaychajaw as Apudyus ad langit!” ");
INSERT INTO kyb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ad sa'ad nan uchumay Pariseo gway agwad san amochay taku anancha an sija, “Mistuyu, pakin'om chanan pasuyutnu.” ");
INSERT INTO kyb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kun summungwhat as sija gway manggwana, “Iwhaka' an cha'aju gway sa'ad nu kumino'cha sa'ad chanan whatu mampa'uycha.” ");
INSERT INTO kyb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ummachani kus sija gwot chimmangna ad Jerusalem naniwhil as sija kapu sasan takud aschi ");
INSERT INTO kyb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","gway manggwana, “Nu inakammuju otjan san sana nan mangatod as maid kuyu! Gwon san sana nitayu an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tan humu'nag nan chimpuway a'ammasna nan ma'gwa an cha'aju gway umali chanan ahursuju ayachan san whinatu pali'gwosan nan iliju ad naumtan nan losanay maoy. ");
INSERT INTO kyb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tangkaan cha'aju ad intoycha nan losanay takuway ingkaw san iliju. Tangkaancha kuchason nan iliju kapu tan achiju kun whinigwhig nan chimpuway ummaliyan Apudyus nanakuwan an cha'aju!” ");
INSERT INTO kyb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ummoy kus Hesus san sowhan nan Templo pinerjawna chachay malla'ya'u ");
INSERT INTO kyb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","gway manggwana an chicha, “Nilista san Ukud Apudyus gway anana, ‘Sa'ad nan hoyoy'u luyuwwayuwan nan losanay taku gwon nangngachanonju tatalluwan chanan mamayangkat!’ ” ");
INSERT INTO kyb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kun whinikatay nansuyu as Hesus san sowhan nan Templo. Gwon sa'ad chanan papangat nan papachi, mangaagkammu san lintog ja papangat chanan taku whayugwoncha otojon as sija. ");
INSERT INTO kyb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gwon maid kun ochasanchas mangkapugwanchaay manggwa san pangkopcha kapu tan aadchin nan losanay taku gway manchongor an sija. ");
INSERT INTO kyb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Osa ku erkaw san mansuyusuyuwan Hesus san sowhan nan Templo ja mangipaakammugwana san Whayuway Chamag, ummoy chanan papangat nan papachi ja chanan mangaagkammu san lintog gway huyuncha chanan mangipangpangu sasan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kun anancha an sija, “Iwhakamud an cha'ami nu agwan nan nangallam san ayobhongamay manggwa san annachaja o'oom. Ngachan nan nangatod an si'a san ayobhongam?” ");
INSERT INTO kyb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Anan Hesus gway summungwhat an chicha, “Manimusa' ahos an cha'aju ad iwhakajuud an sa'on ");
INSERT INTO kyb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nu ngachan nan nerpugwan nan ayobhongan Juan gway manghonjag, as Apudyus gwinnu chanan taku?” ");
INSERT INTO kyb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kun nanuukuchanchaay manggwana, “Nu anan ta'uwon nerpu an Apudyus ananaon, ‘Kajuman angkay achi tinuttuwa as Juan.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gwon nu anan ta'uwon, ‘Nerpu sasan taku’ losanay taku whintukon chita'u tan tinuttuwachaay profeta as Juan.” ");
INSERT INTO kyb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gwot summungwhatcha gway manggwana, “Maid kun akammumi nu agwan nan nerpugwana.” ");
INSERT INTO kyb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kun anan Hesus an chicha, “Sa'ad nu amasnat achi' kuhos iwhaka nu ngachan nan nerpugwan nan ayobhonga' gway manggwa san o'oo'.” ");
INSERT INTO kyb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sachi kun iyagwat Hesus sasan taku gway manggwana, “Iningkaw nan osa taku gway nammuya as angsanay ubas san lutana kun impasamerna sasan mansasamer kun ummoy nangwhaat gway nawhajag san ayasi ili. ");
INSERT INTO kyb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chimpun kunan inghubhuyas ingwhaunna nan osa mudchachuna sasay mansasamer ta umoyna ayan nan huwana. Gwon sa'ad chachay mansasamer inayacha ku chay niwhaun inabchaabchoycha gwot pinerjawcha gway naugwas. ");
INSERT INTO kyb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kun nangwhaun as sawhali as mudchachu gwon pina''uwancha ja pinawhainancha as sija asichaot perjagwon gway naugwas. ");
INSERT INTO kyb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kun ingwhaunna nan mi'atluway mudchachuna. Ad sa'ad ahos as sija jinamancha asichaot itoper san lasin nan mumullan. ");
INSERT INTO kyb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kun anan chay sin'ugwa san mumullan san ubas, ‘Ngachamma nan oo' sina? Iwhaun'u nan patpatko'ay ana''u. Tugwakay whigwhikonchas sija.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Gwon inilan kun chachay mansasamer as sija asi'a'anancha, ‘Annaja nan mangila'sun. Otojon ta'u as sija tot chita'u nan mangin'ugwa san la'sunna.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gwot intopercha ku nilasin as sija san mumullan san ubas, intoycha.” Kun anan Hesus, “Ad ngachamma nan oon chay sin'ugwa san mumullan san ubas sasay mansasamer? ");
INSERT INTO kyb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umoyna otojon chicha a! Ad inchalisna ipasamer chay mumullana san ubas san uchumay taku.” Chingngorn kun chachay taku nan ingwhakana anancha, “Achi otjan ma'gwa nat.” ");
INSERT INTO kyb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Intollong kun Hesus chicha anana, “Ad ngachamma nan pijaona anan nannaja nilistaay Ukud Apudyus gway anana, ‘Sa'ad chay whatuway nampiliyan chanan mamanggwas hoyoy, sachiyot nan kadto'ay nisaachan nan hoyoy.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Nu ngachan nan maotchag sannaja whatu mayumo'. Ad nu ngachan nan mitu'nukana mamo'mo'.” ");
INSERT INTO kyb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ad sa'ad chachay mangaagkammu san lintog ja chachay papangat nan papachi pinachaschaay pachopap as sija san sachiyay uyas tan akammuchaay sa'ad nan agwat gway ingwhakan Hesus mihursu an chicha. Gwon ummogjatcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sinisipputancha kus sija nangiwhaunchas ti'ti' as mampammayang as ustu nan iwhakacha ta si'apanchas sija san ukuchona tot agwad lasunchaay mangipawhijang an sija san tuyay ja ayobhongan nan kuwhinnachur. ");
INSERT INTO kyb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kun inimuscha an sija gway manggwana, “Mistuyu, akammumiyay ustu nan iwhakawhakam ja isuyusuyum ancha maid kun mat'on as whayugwom gwon nu ngachan nan atuttugwaan gway mipangkop san whayugwon Apudyus sija nan isuyum. ");
INSERT INTO kyb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iwhakamud an cha'ami nu maserpu mangwhajad ami san hugwis san Emperadorn nan Roma gwinnu achi?” ");
INSERT INTO kyb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gwon akammun Hesus nan si'apcha, sija nan anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Umipaila aju an sa'on as aka pila'. Ngachan nan singhoser ja singngachan sannaja?” Kun anancha, “Ngachan nan Emperador.” ");
INSERT INTO kyb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kun anan Hesus an chicha, “Nu amasnat atchonju san Emperador nan ugwan nan Emperador ad inatodju an Apudyus nan ugwan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Achicha kun na'asi'ap an Hesus san ukudna san sangun chanan taku. Ad kapu tan nataagcha san sungwhatna ingkino'cha ekay. ");
INSERT INTO kyb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ummoy ummachayug an Hesus chanan uchumay Saduceo gway chicha nan achi kun mamati gway mataku nan matoy. Kun inimuscha an sija ");
INSERT INTO kyb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","gway manggwana, “Mistuyu, illistan Moses san lintog an chita'u gway nu matoy nan osa laya'i ja taynana nan asagwanaay maid ana'cha, maserpu asawwon nan sunudna chay nawhayu tot umana'chas miwhilang as ana' chay sunudna natoy. ");
INSERT INTO kyb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ad iningkaw nan pitu mansusunud gway lallaya'i. Nangasagwa nan panguyu gwon natoy gway maid kun ana'na. ");
INSERT INTO kyb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ad nan umaggwa sunudna inasagwana chay nawhayu gwon natoy ahos gway maid ana'na. ");
INSERT INTO kyb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kun amaschi ahos nan na'gwa san mi'atlu ingkana san mi'apitu gway maid kun ana'cha kun losancha natoy. ");
INSERT INTO kyb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gwot anunu kun natoy ahos chay huwhai. ");
INSERT INTO kyb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ad sa'ad chay huwhai nu umali nan erkaw gway matakuwan chanan natoy, ngachan nan sinasagwa an sija tan losan chachay pitu mansusunud inasagwas sija?” ");
INSERT INTO kyb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kun anan Hesus an chicha, “Sa'ad chanan taku san sana chimpu manasasagwacha. ");
INSERT INTO kyb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gwon san umaliyay chimpu sa'ad chanan taku gway miwhilangay mataku san otoy achicha kun manasasagwa. ");
INSERT INTO kyb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ad achicha kun matoy kapu tan mijisucha sasan a'anghel gway achi kun matoy ja ana' Apudyus chicha tan natakucha. ");
INSERT INTO kyb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gwon sa'ad chanan natoy matakucha uyay as Moses impaakammuna san Ukud Apudyus nan mipangkop san kumilakilab gway aju gway anana, ‘As Apudyus, sija nan Apudyus Abraham, nan Apudyus Isaac ja nan Apudyus Jacob.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wha'on kus Apudyus chanan natoy as sija gwon Apudyus chanan mawhiwhijag tan nan losan mawhiwhijag an sija.” ");
INSERT INTO kyb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ad sa'ad chanan uchumay mangaagkammu san lintog summungwhatcha gway manggwana, “Mistuyu, whayu nan ingwhakam.” ");
INSERT INTO kyb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kun maid kun mangituyod manimus asin an sija. ");
INSERT INTO kyb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Anan Hesus an chicha, “Ininonchaay manggwanaon kana' Dabid nan Kristu? ");
INSERT INTO kyb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tan anan Dabid gway mismu san nibyun nan Salmo, ‘Anan Apudyus san Apu', tumu'chu'a san machigwanan'u ");
INSERT INTO kyb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ingkanas ipaawha''u an si'a chanan ahursum ad isucha nan layappangan nan i'im.’ ");
INSERT INTO kyb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Sija nan nu anan Dabichon ‘Apu'’ san Kristu, ininon Kristu gway nangngachan kana' Dabid?” ");
INSERT INTO kyb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sa'ad san manchochongngoyan nan losanay taku anan Hesus sasan pasuyutna, ");
INSERT INTO kyb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ammanju ilan chanan mangaagkammu san lintog gway whayugwonchaay mangikagkagka'ay san mallagyagkoyloy gway silupcha ja whayugwonchaay agwad mangingakinga an chicha san merket. Ja whayugwoncha hosay tu'chu san awhayugwanay tu'chugwan san sinagoga ja ingkaw san agwachan nan ikaw nan nangatuway taku sasan lagyagsa'. ");
INSERT INTO kyb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Isi'asi'apchaay mangaya san u'ugwan chanan nawhayu ad an'annancha anchugwon nan lugwayucha. Kapu sannaja machusachas amod.” ");
INSERT INTO kyb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nallangyanga kus Hesus inilana chanan whawha'nangay mangigkiigka san chatuncha san iigkaan san pila'. ");
INSERT INTO kyb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kun inilana hos nan osa wha'sigwot gway whayu gway nangigka san chugwa aka pila'. ");
INSERT INTO kyb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kun anana, “Tuttuwa iwhaka' an cha'aju gway sa'ad chay wha'sigwot gway nawhayu adachu nan inigkana nu san inigkan chachay uchumay taku. ");
INSERT INTO kyb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tan sa'ad nan losanay inigkacha sergwan nan pila'cha. Gwon sa'ad chay nawhayu, ta'on nu wha'sigwot as sija inigkana losan nan ahus as i'atakuna.” ");
INSERT INTO kyb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sa'ad san mangukuukuchan chanan uchumay pasuyutna san mipangkop san Templo gway naeertiyan sasan man'awhawhayuway whatu ja chanan nichatun an Apudyus, anan Hesus, ");
INSERT INTO kyb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sa'ad nannachaja iillanju humu'nag nan chimpuway maid kun osas matchay san whatu gway natuutuun as achi ku mi'uurb.” ");
INSERT INTO kyb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sachi kun inimuscha an Hesus gway manggwana, “Mistuyu, ma'anu nan ma'gwaan nina ja ngachan nan mangimatunan san humu'nakan nina?” ");
INSERT INTO kyb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kun anan Hesus, “Ammanju ilan tot achi aju paallilaw. Tan angsan nan umali manguser san ngachan'u gway manggwana, ‘Sa'on nan Kristu’ ja ‘Takangay nan chimpu!’ Achi aju mitunud an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ad nu chongyonju nan mipangkop san kukuwhat ancha kuyu achi aju umogjat tan maserpuway umuna jan ma'gwa nannaja. Gwon wha'on kus sachi ekay nan anungus nan erkaw.” ");
INSERT INTO kyb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gwot intuyuyna gway manggwana an chicha, “Mangwhiwhinnursu nan ailiili ja chanan kuwhilnu san luta. ");
INSERT INTO kyb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ad humu'nag chanan amod gway kitakita ja uyat san na'aya'ayasiyay ili ja chanan sa'it. Ad agwad nan losanay ayasin nan amod a'oogjat gway maila ad langit. ");
INSERT INTO kyb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gwon chaan ad ma'gwa nannachaja chopapon cha'aju ja palikatan cha'aju. Ipawhijang cha'aju sasan sinagoga ad ingwhayud cha'aju. Miijoy aju sasan ali ja sasan kuwhinnachur kapu san pammatiju an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ad sachi nan mangiwhaganju an chicha san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sija nan achi aju umunnuunna manchanag nu ngachan nan isungwhatju. ");
INSERT INTO kyb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tan whadnga' cha'aju san iwhakaju ja atcha' cha'aju as laing gway achin ku chanan ahursuju lobhong masungwhatan ja masurngasing. ");
INSERT INTO kyb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Uyay pay chanan sinana' an cha'aju, susunudju, chochogkaju ja huhuyunju ipuyangcha cha'aju. Ad nan uchum an cha'aju ipaotoycha. ");
INSERT INTO kyb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kuyaon cha'aju hos san losanay taku kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gwon aygwanan cha'aju an Apudyus ad uyay osa sasan huu'ju maid kun mataya'. ");
INSERT INTO kyb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kapu san inaattomju sachi nan matakuwan nan longagju. ");
INSERT INTO kyb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sa'ad nu ilanju nan Jerusalem gway pali'gwosan chanan susurchachu akammujuway takangay nan migwa''iyana. ");
INSERT INTO kyb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ad sa'ad chanan takuway agwad ad Judea maserpu umagwidcha san whibilig. Ad sa'ad chanan agwad san kagwan nan ili maserpu lumajawcha ja sa'ad chanan agwad sasan tayun achicha lumno' san ili. ");
INSERT INTO kyb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tan sanat nan chimpuway machusaan chanan taku tot ma'gwa nan losanay nilista san Ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Achagchaku chanan mahuki ja chanan mantatakiwhi san sanat gway chimpu. Tan humu'nag nan amod gway likat sannaja luta ja amochay lingun Apudyus sannachaja taku. ");
INSERT INTO kyb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mapapatoy nan uchum kapu san ispada ad mapyos miwhayud chanan uchum sasan ailiili. Ad nan Jerusalem purson chanan wha'on kus Hudyu ingkanas mampatingkaon Apudyus nan ayobhongan chanan wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Agwad nan ma'aya'ayasiyay ma'gwa san init, huyan, ancha whituwon. Ad sa'ad ad asna luta malilihu' as amod chanan taku san ailiili ja machanakancha kapu san awhayug nan whaywhay ja napigsa tapiya'na. ");
INSERT INTO kyb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Umapsut chanan taku san ogjatchaay manguullay san ma'gwa san luta tan sa'ad chanan ayobhonganay agwad ad langit majugjug. ");
INSERT INTO kyb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ad ilancha as sa'onay Ana' nan Taku gway umali gway nangkakagwa san hunot gway anna nan amochay ayobhonga' ja inachajaw'u. ");
INSERT INTO kyb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ad sa'ad nu malluki nannachaja ma'gwa papigsaonju ja payagsa'onju nan somsomo'ju tan takangay nan matakuwanju.” ");
INSERT INTO kyb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kun iyagwat Hesus an chicha gway manggwana, “Ilanju nan aju gway igos ja losanay aju. ");
INSERT INTO kyb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sa'ad nu sumimit nan tuhucha akammujuway takangay nan chakun. ");
INSERT INTO kyb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Isuna hosay sa'ad nu ilanju gway ma'gwa chana akammujuway takangay nan chimpun nan mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tuttuwa iwhaka' an cha'ajuway sa'ad nannachaja takuway matattaku san sana achicha kun losan matoy ingkanas ma'gwa losan nannachajaay ingwhaka'. ");
INSERT INTO kyb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sa'ad nan langit ja luta maumas gwon sa'ad nan ukud'u sissija iingkaw.” ");
INSERT INTO kyb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ammanju ilan tot achi aju milumyum san amochay lagyagsa', hutong ja chanan manchanakan san whijag tan maag ad ekay mawhanu'nag nan sanatay erkaw gway isun nan ma'naanju san ilug, mailukan aju. ");
INSERT INTO kyb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tan humu'nag nan sanatay erkaw san losanay takuway ingkaw san intilu luta. ");
INSERT INTO kyb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ammanju whantajan nan losanay chimpu, ilugwayuju ta agwad pigsajuway lumisi san losanay ma'gwa ja mawhalinay sumangu aju an sa'on gway Ana' nan Taku.” ");
INSERT INTO kyb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chimpun ad nan erkaw mansuyusuyus Hesus san Templo gwon sa'ad nu lawhi umoy massuy san whilig gway ma'gwaniyon Olibu. ");
INSERT INTO kyb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ad sa'ad chanan taku masasapacha umoy san Templo ta manchongorcha an sija. ");
INSERT INTO kyb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Takangay nan pijasta gway ma'gwaniyon Tinapay Gway Maid Kun Yeastna gway maagwakan ahos as pijasta gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kun anaanapon chanan papangat nan papachi ja chanan mangaagkammu san lintog nu ininoncha mangipaotoy an Hesus tan umogjatcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kun sinumpaw as Satanas an Judas gway ananchaon Iscariote gway osa sasan nasagwayan as chugwaay apostoles. ");
INSERT INTO kyb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ummoy as Judas na'aukud sasan papangat nan papachi ja chanan apitan chanan mangijaachug san Templo nu ngachan nan ininona mangipawhijang an Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kun nayagsa'anchaot tinachunanchaay whajachan as sija as pila'. ");
INSERT INTO kyb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kun jinangochan Judas kun illukinaay mananap as chimpu as mangijiwhitana an Hesus as maid kun angsan as takus mangakammu. ");
INSERT INTO kyb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hummu'nag nan erkaw nan pijasta gway ma'gwaniyon Tinapay Gway Maid Kun Yeastna gway sija nan mampertiyancha san uyhun nan kernero gway michatun san pijasta gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kun ingwhaun Hesus cha Pedro an Juan gway manggwana, “I'aju isakana nan anon ta'u san pijasta gway ma'gwaniyon Lumaus.” ");
INSERT INTO kyb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kun anancha an sija, “Agwan nan whayugwomay mangisakanaanmi?” ");
INSERT INTO kyb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kun anana an chicha, “Chongyonju, sa'ad nu humu'nag ajud Jerusalem agwad nan mangahot an cha'ajuway osa laya'i nanoodchon san singkusiyay chanum. Ad nitunud aju an sija. ");
INSERT INTO kyb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ad nu ngachan nan hoyoy gway lumno'ana ananju san singhoyojon, ‘Anan nan Mistuyuwon agwan nan agwad nan ugwertu gway mangananmi san pasuyut'u san pijasta gway ma'gwaniyon Lumaus?’ ");
INSERT INTO kyb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ad nan sanatay taku itchuna nan cha'or ugwertu gway nangngatu san agwachan nan gwachagwad nan mauser. Ad aschi nan mangisakanaanju.” ");
INSERT INTO kyb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ummoycha kun inchasancha nan losanay ingwhakan Hesus an chicha. Kun insakanacha nan anoncha san pijasta. ");
INSERT INTO kyb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hummu'nag kunan chimpuway manganancha tummu'chus Hesus san oo''anan gway huyunna chanan apostoles. ");
INSERT INTO kyb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kun anana an chicha, “Whayugwo' ekajay ma'a'an an cha'aju sannaja pijasta gway ma'gwaniyon Lumaus ad asiya'ot mapalikatan. ");
INSERT INTO kyb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tan iwhaka' an cha'aju gway achiya' kun mangmangan sina ingkanas ma'gwa nan pijaona ukuchon nan Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Inayan kun Hesus nan sintasaay whajas nan ubas ja nappung kun manjaman an Apudyus, anana, “Ayanju nannaja ad nanatattawhanju. ");
INSERT INTO kyb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tan iwhaka' an cha'ajuway malluki san sana achiya' kun uminum san whajas nannaja ubas ingkanas humu'nag nan Mantuyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nangaya kus Hesus san tinapay gwot iyamanna an Apudyus pini'pi''ina kun inatodna an chicha gway manggwana, “Annaja nan longag'u gway atcho' an cha'aju. Anonju nannaja as manomsom'anju an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Amaschi hos nan inggwana san sintasa whajas san nappungcha nangan gway anana, “Annaja nan chaya' gway umigwang as mamagchot san assahu tuyag Apudyus an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Gwon ilanju, nan takuway mangijiwhit an sa'on annad asna gway ma'a'a'a'an an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kapu tan sa'ad as sa'onay Ana' nan Taku matoja' tan sachi nan simsimmo' Apudyus san agwi gwon amod a'oogjat nan ma'gwa san sanatay taku gway mangijiwhit an sa'on!” ");
INSERT INTO kyb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kun illukichaay nanisijimus nu ngachanna an chicha nan manggwa san amaschi. ");
INSERT INTO kyb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sachi kun illukicha hosay maniisi' chanan pasuyut Hesus nu ngachanna an chicha nan angatuwan. ");
INSERT INTO kyb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sija nan anan Hesus an chicha, “Sa'ad chanan alin nan wha'on kus Hudyu amod nan manggwacha gway mangituyay sasan takucha ad whayugwoncha pajay maagwakan as, ‘Humawhachangcha sasan taku.’ ");
INSERT INTO kyb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gwon wha'on kus amasnat nan oonju, nan apatkan an cha'aju maserpu mangngachan as sija awhawhaan ja sa'ad nan mangipangpangu mangngachan as sija isun chi mansilsilwhi. ");
INSERT INTO kyb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tan ngachan nan napatpatog, chay osa tummu'chu san oo''anan gwinnu chay osa mansilwhi an sija? Ad wha'on say tummu'chu san oo''anan? Gwon sa'ad as sa'on gway anna an cha'aju sa'on nan mansilwhi an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Cha'aju nan iniingkaw an sa'on san losanay nalliglikata'. ");
INSERT INTO kyb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ad atcho' an cha'aju nan ayobhonganay mantuyay as isun nan nangatchan Ama an sa'on san ayobhonganay mantuyay as Ali ");
INSERT INTO kyb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tot mawhalinay ma'a'an ja ma'iinum aju an sa'on san oo''ana' san Mantuyaja' ja tu'chu aju sasan ikaw gway mangituyay sasan kana' chachay nasagwayan as chugwaay ana' Israel.” ");
INSERT INTO kyb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Anan Hesus an Pedro, “Simon, Simon, chongyom na! Inchaw Satanas kun nijujaay mamachas an cha'aju ta ilana nu agwad an cha'aju nan milasin as isun nan milasinan nan chuki san hokas nan kerkergwit. ");
INSERT INTO kyb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gwon illugwayuwa' si'a, Simon tot achi mampapog nan pammatim. Ad sa'ad nu managkulin'a an sa'on papigsaom nan pammatin chanan huhuyunnu.” ");
INSERT INTO kyb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Gwon anan Pedro an sija, “Apu, na'asakanaa'ay mitapi miwhayud ja mitapi matoy an si'a.” ");
INSERT INTO kyb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Anan Hesus, “Iwhaka' an si'a Pedro gway san sana lawhi mamitlum isulib gway akammum sa'on san chaanan nan awwit mangu''uu'an.” ");
INSERT INTO kyb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Anan Hesus an chicha, “Sa'ad san nangiwhauna' an cha'ajuway maid inaw'agwitjus mangiigkaanju san pila' ja mangiigkaanjus silup ancha maid sinilasju, ad nan'uyang ajus maserpuju?” Kun anancha, “Achi kun.” ");
INSERT INTO kyb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gwot anana an chicha, “Jon san sana nan anna nan mangiigkaana san pila' maserpu agwitona, isuna hos san mangiigkaan san silup. Ad sa'ad nan maid ispadana ila'una nan oberkotna ad illa'unas ispada. ");
INSERT INTO kyb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tan iwhaka' an cha'ajuway maserpu tumuttuwa nan nilistaay Ukud Apudyus an sa'on gway anana, ‘Niwhilang as sija sasan takuway humersuwhersu.’ Tan nan nilistaay mipangkop an sa'on takangay tumuttuwa.” ");
INSERT INTO kyb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Gwot anan chachay pasuyutna, “Apu, ilam, annaja nan chugwa ispada.” Kun anan Hesus an chicha, “Akay sinat.” ");
INSERT INTO kyb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lummagwacha kun san inigkagwancha ummoy as Hesus san whilig gway Olibu tan sija nan sikuchay o'oona. Kun nitunud ahos an sija chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chummakuscha kun ad aschi anana an chicha, “Mallugwayu aju ta achi aju masulisukan.” ");
INSERT INTO kyb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kun ummachajus sija an chichas isun nan aachajun nan loog mawhintug gwot nampalintumong kun nallugwayus sija ");
INSERT INTO kyb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","gway manggwana, “Ama, nu whayugwom ilisiya' otjan sanna amod gway likat. Gwon wha'on kusan whayugwo' nan ma'gwa, sija ma'gwa nan whayugwom.” ");
INSERT INTO kyb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kun nampaila an sija nan osa anghel gway nerpud langit gway nangipapigsa an sija. ");
INSERT INTO kyb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ummamamod kunan sikab nan somsomo'na impapatina' amochay nallugwayu, ad sa'ad nan lingotna nangngachan amas todtod chi chayaay tumiyotiyong san luta. ");
INSERT INTO kyb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lummiggwat kusan nappung nallugwayuwot ummoy san agwachan chachay pasuyutna, inchasana chichaay nanassuy tan amod nan sasangacha. ");
INSERT INTO kyb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kun anana an chicha, “Ka'aju mamassuy? Humangon aju ad nallugwayu aju ta achi aju masulisukan.” ");
INSERT INTO kyb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sa'ad san manapaapatan Hesus hummu'nag nan amochay taku. Ad sa'ad nan osa taku mangngachan Judas gway osa sasan nasagwayan as chugwa pasuyutna, impujutna chicha kun ummachayug an Hesus ta choomana nan aping Hesus san apingna. ");
INSERT INTO kyb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gwot anan Hesus an sija, “Judas, kamma ipaila nan mangijiwhitam an sa'on gway Ana' nan Taku san mangichoomam san apingnu san aping'u.” ");
INSERT INTO kyb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Inilan ku chachay pasuyut Hesus nan ma'gwa an sija anancha, “Apu, wha'akonmi chicha?” ");
INSERT INTO kyb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kun whina'ag nan osa an chicha nan mudchachun nan angatuwanay pachi kun napingasan nan machigwanan gway ingana. ");
INSERT INTO kyb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Gwon summungwhat as Hesus gway manggwana, “Akay sinat!” Inognana kunan ingan chay mudchachu impawhayuna. ");
INSERT INTO kyb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gwot anan Hesus sasay ummoy maniliw an sija gway papangat nan papachi, a'appittan nan mangijaachug san Templo ja chanan chacha''orn nan Hudyu, “Jo'o tulisana' ta umali ajuway naniispada ja namperpertu gway manpap an sa'on. ");
INSERT INTO kyb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Awhikawhikat peekay iniingkagwa' an cha'aju san Templo gwon achiya' kun chimpap. Jon annaja nan chimpuju ja chimpun Satanas gway mangituyay san manghulingot.” ");
INSERT INTO kyb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chimpapcha kus Hesus illajawchas sija kun iyoycha san hoyoy nan angatuwanay pachi. Kun ummaadchajang as Pedro gway misu'su'nub. ");
INSERT INTO kyb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Manapappuycha kun san kagwan nan sowhan nan hoyoy ja tummu'chucha losan, na'atu'chus Pedro an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Inilan ad nan osa huwhaiyay mudchachu as sija gway na'atu'tu'chu san achani san apuy intotollongna as sija gway manggwana, “Sa'ad nan osaanna ahos huyun Hesus!” ");
INSERT INTO kyb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Gwon insulib Pedro say huwhai gway manggwana, “Achi' kun akammus sija!” ");
INSERT INTO kyb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Umawawni kun iningkaw nan sawhali taku nangila an sija gway manggwana, “Si'a hos nan osa an chicha!” Gwon anan Pedro, “Wha'ona' kun!” ");
INSERT INTO kyb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lumma'pus kunan osa uyas iningkaw nan osa mangipapilit manggwanaon, “Maid kun chugwachugwanaay sa'ad nannaja taku huyun Hesus tan iGalili hos as sija.” ");
INSERT INTO kyb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gwon anan Pedro, “Achi' kun akammu nan iwhakawhakam!” Kun maag ekay nangu''uu' nan awwit san manapaapatan Pedro. ");
INSERT INTO kyb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nansakung kus Apu Hesus intollongna as Pedro. Kun simsimmo' Pedro chay ingwhakan nan Apu san nangiwhagana an sija gway manggwana, “Chaan ad mangu''uu' nan awwit san sana lawhi namitlum sa'on isulib.” ");
INSERT INTO kyb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lummagwa kus Pedro ap pagway naniwhil san amod gway somsomo'na. ");
INSERT INTO kyb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sa'ad chanan takuway nangijachug an Hesus amaamangonchas sija ja saplisaplitanchas sija. ");
INSERT INTO kyb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Whinungutcha kunan atana inimuschas sija gway manggwana, “Imatunama nu ngachan nan nangano''a an si'a?” ");
INSERT INTO kyb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kun angsanay whayangna amamang nan ingwhakachaay mihursu an sija. ");
INSERT INTO kyb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mawhikat kun naayus chanan angatuwanay chacha''orn chanan Hudyu, chanan papangat nan papachi, chanan mangaagkammu san lintog kun iyoychas Hesus sasan Sanhedrin ");
INSERT INTO kyb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","gway manggwana, “Nu si'a nan Kristu iwhakam an cha'ami.” Gwon anana an chicha, “Nu iwhaka' an cha'aju achiju kun tuttugwaon. ");
INSERT INTO kyb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ja nu manimusa' an cha'aju achi aju kun sumungwhat. ");
INSERT INTO kyb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gwon malluki san sana tumu'chuwa' gway Ana' nan Taku san machigwanan Apudyus gway amod nan ayobhongana.” ");
INSERT INTO kyb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kun inimuscha losan gway manggwana, “Ad tuttuwa si'a nan Ana' Apudyus?” Kun summungwhat an chicha gway manggwana, “Cha'aju nan manggwanaon sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gwot anancha, “Ngachamma uchum as anapon ta'u as mana'chor an sija. Chita'u mismu nan nangngor san ingwhakana!” ");
INSERT INTO kyb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lummiggwat ku chanan losanay Sanhedrin iyoychas Hesus an Pilato. ");
INSERT INTO kyb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kun illukichaay mangiwhaka san ipawhersucha an sija gway manggwana, “Sa'ad nannaja taku inchasanmi gway mangagwaagwis gway mangalallilaw sasan ailijanmiyay Hudyu gway humersu san kuwhilnu ja ijachina nan mangwhajad san hugwis san Emperador ja agwakana nan longagna as Kristu gway ali.” ");
INSERT INTO kyb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kun inimus Pilato an sija gway manggwana, “Si'a nan Alin chanan Hudyu?” Anan Hesus gway summungwhat, “Si'a nan nangiwhaka gway aliya'.” ");
INSERT INTO kyb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gwot anan Pilato sasay papangat nan papachi ja chachay amochay taku, “Maid kun maanapa' as kapun nan mayodchongan nan osa takuwanna.” ");
INSERT INTO kyb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gwon impapilitcha gway manggwana, “Kuyugwona chanan taku san losanay ilid Judea kapu san mansuyusuyuwana gway illukinad Galili ingkanad asna.” ");
INSERT INTO kyb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chingngorn kun Pilato nan ingwhakacha inimusna gway manggwana, “iGalili nannaja taku?” ");
INSERT INTO kyb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Inakammuna kun gway nerpus Hesus san iliyay ituyajan Herod impaijoyna as sija an Herod gway agwad ahos ad Jerusalem san sachiyay chimpu. ");
INSERT INTO kyb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Inilan kun Herod as Hesus nayagsa'an as amod tan nawhajakay whayugwona ilan as sija kapu tan chingngorchingngorna nan mipangkop an sija ja namnamaonaay ilan nan mangimatunanay mataakan gway oon Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sija nan angsan nan inimus Herod an Hesus gwon achi kun summungsungwhat an sija. ");
INSERT INTO kyb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ad agwad gway nasi'asi'ad chachay papangat nan papachi ja chachay mangaagkammu san lintog gway impaamamodcha pawhasuyon as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Whinanwhanit Herod as sija gway huyunna chanan surchachuna gway nangamamang ahos an sija. Inakojancha kus sija san a'erjachay akoy impaijoyna ipagkulin as sija an Pilato. ");
INSERT INTO kyb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kun nangngachan manghubuyun cha Herod an Pilato san sachiyay erkaw kapu tan sikuchay maninnisilcha. ");
INSERT INTO kyb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Impaajag kun Pilato chanan papangat nan papachi, chanan mantutuyay ja chanan taku ");
INSERT INTO kyb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","anana an chicha, “Iyaliju an sa'on nannaja taku gway ananjuwon mangalallilaw sasan taku gway humursu san kuwhilnu. Kun ilanju, sinumerja' kus sija sanna sanguju maid kun inchasa' sannaja taku as kapun nan mangipawhasuyanju an sija. ");
INSERT INTO kyb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Uyay as Herod maid kun inchasana tan impaipagkulinnas sija an chita'u. Ad ilanju, maid kun inggwana as lobhongna matojan. ");
INSERT INTO kyb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sija nan ipasaplit'u ad as sija pinerjaw'u.” ");
INSERT INTO kyb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","San gwaschi pijastan nan Lumaus nisikud gway ma'ma'gwaay umipayagwa as Pilato as osa sasan whayud an chichaay Hudyu. ");
INSERT INTO kyb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gwon nakigsan nampa'uy chanan taku gway manggwana, “Paotoynu nan sanatay taku ad impayagwam an cha'ami as Barrabas.” ");
INSERT INTO kyb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nawhayud as Barrabas kapu san nitapijana san kuyu gway inggwacha san kuwhilnu gway na'gwa ad Jerusalem ja kapu san pummatoy.) ");
INSERT INTO kyb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gwot inasin Pilato na'aapapat an chicha gway whayugwona ipayagwa as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gwon impa'uycha gway manggwana, “Pailansam as sija san krus! Pailansam as sija san krus!” ");
INSERT INTO kyb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kun impitlun Pilato gway manggwana an chicha, “Kaman, ngachan nan lagwingay inggwan nina? Maid kun inchasa' as kapun nan matojana. Sija nan ipasaplit'u ad as sija impayagwa'.” ");
INSERT INTO kyb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gwon iyamamodchaot tinowhag nan kingacha gway manggwana an sijaon pailansam as sija san krus, kun nangyog nan anancha. ");
INSERT INTO kyb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sija nan intachun Pilato gway ma'gwa nan ochawcha. ");
INSERT INTO kyb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kun impayagwana chay osa laya'iyay sija nan inchawcha gway niwhayud kapu san nitapijana san kuyu gway inggwacha san kuwhilnu ja pummatoy gwon sa'ad as Hesus impawhijangna tot ooncha nan whayugwoncha. ");
INSERT INTO kyb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sa'ad san mangilajagwancha an Hesus impukodcha nan osa taku mangngachan Simon gway iCirene gway inahotcha nerpu san lasin nan Jerusalem kun impahu'udcha an sija nan krus ta hu'uchona gway misu'su'nub an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kun nituntunud an Hesus nan amochay taku ja chanan hubhuwhai gway asisasanga ja asijiiwhil kapu an sija. ");
INSERT INTO kyb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nansakung kus Hesus an chicha anana, “Cha'aju hubhuwhaiyay iJerusalem, achiju iwhilan as sa'on sija iwhilanju chanan longagju ja chanan anana'ju. ");
INSERT INTO kyb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tan ilanju, humu'nag nan chimpuway anan chanan taku, ‘Piyan chanan whasig, chanan achi kun nahuki ja chanan achi kun nantakiwhi!’ ");
INSERT INTO kyb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa'ad tot achicha ichaman nan likat san manangkaan nan ahursurcha san ilicha ilukichaay manggwana san whibilig, ‘Maotchag'a an cha'ami’ ja anancha sasan whana'iyutay whibilig, ‘Tabunan cha'ami!’ ");
INSERT INTO kyb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tan sa'ad nu amasna nan ooncha an sa'on gway maid whersuna ad achi sinumamod nan ooncha an cha'ajuway hummersu?” ");
INSERT INTO kyb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kun iyoycha hos nan chugwa mamayangkat gway intapicha an Hesus ta otojoncha. ");
INSERT INTO kyb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hummu'nagcha kusan ikaw gway ma'gwaniyon “Tungern nan Wha''ag”, illansacha as Hesus san krus ja chanan chugwa mamayangkat ad aschi, osa san machigwananna ja osa san machigwikina. ");
INSERT INTO kyb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kun anan Hesus, “Ama, ligwatam nan whersucha tan achicha kun maagwatan nan o'ooncha.” Kun nangwhiwhinnunutchaay namiwhillay san luputna. ");
INSERT INTO kyb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kun nasi'asi'ad chanan takud aschiyay manghuhuja. Ad amaamangon ahos chanan mantutuyay as sija gway manggwana, “Tinakuna nan uchumay taku, takuwonaud nan longagna nu sija nan Kristu gway pinilin Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kun inamamang hos chanan surchachu as sija. Ummachayugcha kun inatchanchas sija san na'ilomay whajas ");
INSERT INTO kyb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kun anancha, “Nu si'a nan Alin nan Hudyu takuwom nan longagnu!” ");
INSERT INTO kyb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kun iningkaw ahos nan nilista san ngatugwon nan wha''ag Hesus gway anana, “Annaja nan Alin chanan Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ad sa'ad nan osa sasan mamayangkatay nilansa gway huyun Hesus, inamamangnas Hesus gway manggwana, “Jo'o wha'on a si'a nan Kristu. Takuwom nan longagnu ja cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gwon sinungwhatan nan huyunna gway inamujuwana gway manggwana, “Jo'o achi'a umogjat an Apudyus? Agwad'a san isuna asasaad gway mayodchonganay machusa. ");
INSERT INTO kyb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ad chita nan kadto'ay lobhongna ma'gwaan nannaja kapu san inggwata. Gwon nan annaja taku maid kun lagwing as inggwana.” ");
INSERT INTO kyb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kun anana, “Hesus, somsom'om as sa'on nu mantuyay'aon san man'aliyam!” ");
INSERT INTO kyb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kun anan Hesus an sija, “Tuttuwa iwhaka' an si'a, san sana erkaw mitapi'a an sa'on san Paraiso.” ");
INSERT INTO kyb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Takangay kus mamatu' hummulingot nan losanay luta ingkana san singwhattang as anchu. ");
INSERT INTO kyb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa'ad san hummulingotan nan init nakoggwa nawhis'i nan kurtinaay nanorcha' san ingkagwan Apudyus san chayo' nan Templo. ");
INSERT INTO kyb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nampa'uy kus Hesus as towhag anana, “Ama, itayo''u an si'a nan alichodgwa'!” Ingwhakana kunan sachi chakasnaay matoy. ");
INSERT INTO kyb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Inilan kunan apitan nan surchachu nan na'gwa nanchaychajaw an Apudyus gway manggwana, “Tuttuwa tuwa gway sa'ad nannaja taku maid kun whersuna!” ");
INSERT INTO kyb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ad sa'ad chanan naayusay taku gway nangiila san na'gwa lummajawchaay mangob'o'ob'ob san whayu'ungcha san amochay sasangacha. ");
INSERT INTO kyb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kun summisi'ad nan losanay hubuyunna san achajus a'it ja chanan hubhuwhai gway nitunutunud an sija gway nerpud Galili gway nangiila san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iningkaw nan osa laya'iyay mangngachan Josep gway ijArimatea san osa ilid Judea. Whayu ja nalintog as sija gway taku gway osaay manguullay san mantuyajan Apudyus. Ad uyay nu osas sija gway mitapi san Sanhedrin achi kun ummajun san pangkop ja inggwacha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ummoy kus Josep an Pilato inchawna nan lachag Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Impasna kunan lachag Hesus whinichiwhichana san puta' gway luput kun inigkana san lijangay lohon gway maid kun nii''ilhon as taku. ");
INSERT INTO kyb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Erkaw nan mangisakanaan chanan Hudyu san losanay maserpucha san Erkaw gway Umillongan ad mallugyuki nan Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nituntunudcha kun an Josep chachay hubhuwhaiyay nihuyohuyog an Hesus gway nerpud Galili, inilacha nan lohon ja ininonay niwhanat nan lachag Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lummajawcha kun insakanacha nan whangwhangyu ja lanaay miigka san lachag. Erkaw kun gway Umillongan iningkawcha tan sija nan anana san lintog Moses. ");
INSERT INTO kyb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gwisnigwisnit kun san Chumingku ummoy chachay hubhuwhai san lohon gway inagwitcha chay whangwhangyu insakanacha. ");
INSERT INTO kyb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gwot inchasancha nan whatuway naalikad gway nijonob san lohon. ");
INSERT INTO kyb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gwon nilumno'cha kun achicha kun inchasan nan lachag Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Anna kunay maid kun akammuchas ooncha san mipangkop sannaja, maag ekay summi'ad nan chugwa laya'i san agwachancha gway sumilasilap nan silupcha. ");
INSERT INTO kyb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ummogjatcha kun ja nampa'yobcha san luta anan chachay chugwa laya'i an chicha, “Kajuman anaanapon nan mawhiwhijag san ikaw chanan natoy? ");
INSERT INTO kyb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid kus sija ad asna, nataku. Somsom'onju nan ingwhakana an cha'aju san iningkagwanad Galili ");
INSERT INTO kyb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","gway anana, ‘Sa'ad as Sa'onay Ana' nan Taku maserpu mipawhijanga' sasan humersuwhersuway taku ja milansaa' san krus ad mi'atlu ad gway erkaw, natakuwa'.’ ” ");
INSERT INTO kyb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kun simsimmo'cha chay ingwhakan Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nanulincha kunay nerpu san lohon ummoycha impaakammu nannachaja losan sasan nasagwayan as osa apostoles ja losanay huhuyuncha. ");
INSERT INTO kyb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sa'ad chachay huwhaiyay ummoy san lohon cha Maria gway iMagdala, Juana ja Maria gway inan Santiago ja chachay uchum. ");
INSERT INTO kyb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gwon sa'ad nan ingwhakan chanan hubhuwhai sasan apostoles anancha kunnu maid kutu'na, sija nan achicha kun tinuttuwa chicha. ");
INSERT INTO kyb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gwon lummiggwat kus Pedro nanodcha'ay ummoy san lohonot nayyu'ung kunay nangisiim ad chayo', ahus chanan luput as inilana kun lummajaw gway natataag san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ad sa'ad nan chugwa pasuyut Hesus san sachi hosay erkaw umoycha san iliyay mangngachan Emaus gway ummoy as simpuyu ja osa kilometro nan aachajuna san Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kun apaapatoncha nan mipangkop san losanay na'gwa san sinerkagwan. ");
INSERT INTO kyb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sa'ad san manapaapatancha ja manukuukuchancha, sa'ad ahos as Hesus gway ummachayug nihuyog an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gwon achicha kun naimatunan as sija. ");
INSERT INTO kyb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kun anan Hesus an chicha, “Ngachan nan ukuukuchonjuway manadchadchayan?” Kun summinongchaay mansasanga. ");
INSERT INTO kyb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gwot summungwhat nan osa mangngachan Cleofas gway manggwana an sija, “Si'a nina ekay osa mangilid Jerusalem gway achi kun mangakammu san na'na'gwa san sinerkagwan?” ");
INSERT INTO kyb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kun anan Hesus an chicha, “Ngachamma ninat?” Gwot anancha an sija, “Mipangkop an Hesus gway iNazaret gway osa profeta gway amod nan ayobhongana san o'oona ja ukudna san mangilan Apudyus ja san losanay taku ");
INSERT INTO kyb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ja ininonchaay nangipawhijang an sija chanan papangat nan papachi ja chanan mangituyay an chita'u ta mayodchonganay matoy kun illansachas sija san krus. ");
INSERT INTO kyb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sa'ad as cha'ami ninamnamamiyay as sija nan mawwajagwaja san Israel. Wha'on ekas ahus chi, mi'atlu erkaw san sana nan lummaus manipud san na'gwaan nina. ");
INSERT INTO kyb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Osa pay, sa'ad ahos nan uchumay hubhuwhai huyunmi tinaag cha'amis amod. Nasapacha kusan whigwhikatay ummoy san lohon ");
INSERT INTO kyb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gwot achicha inchasan nan lachagna nanulinchaay manggwanaon inilacha nan a'anghel gway nampaila gway manggwana an chichaon nataku as Hesus. ");
INSERT INTO kyb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gwot ummoy nan uchumay huhuyunmi san lohon kun inchasancha hos nan isun nan ingwhakan chachay hubhuwhai gwon sa'ad as Hesus achicha kun inila.” ");
INSERT INTO kyb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gwot anan Hesus an chicha, “Ay maid kun maagwatanju ja mansikab ekay mamatiyanju san losanay ingwhakan chachay profeta san agwi! ");
INSERT INTO kyb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Jo'o achi mapalikatan nan Kristu ad asiyot michajaw.” ");
INSERT INTO kyb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kun impaagwat Hesus an chicha nan losanay nilista san Ukud Apudyus gway mipangkop an sija malluki san nibyuway illistan Moses ingkana san illistan chachay losanay profeta. ");
INSERT INTO kyb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ummachanicha kun san iliyay umajancha an'annan Hesus ipailaay umachaju san ajana. ");
INSERT INTO kyb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gwon tinagwichanchas sija gway manggwana, “Ma'achagwos'a an cha'ami tan takangay mumaschom ja humulingot.” Kun na'achagwos as Hesus an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tummu'chu kus sija san oo''anan gway huyunna chicha nangaya san tinapay kun nanjaman an Apudyus. Pini'pi''ina kun inatodna an chicha. ");
INSERT INTO kyb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kun ama ekas niigkat nan atacha kun inimatunanchas sija. Gwot maag ekay mummaid san agwachancha. ");
INSERT INTO kyb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kun asi'a'ananchaay chugwa, “Apaanpata amas whayu nan li'natad kanad say ma'aapaapatana an chita say mangipaapaagwatana sasay nilista Ukud Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lummiggwatcha kusan sachi hos ekajay uyas nanulinchad Jerusalem. Kun inchasanchaay naayus chanan nasagwayan as osaay apostoles ja chanan uchumay huhuyuncha ");
INSERT INTO kyb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","gway manggwana, “Tuttuwaay nataku nan Apu gwot nampaila an Simon!” ");
INSERT INTO kyb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kun inuullit chachay chugwa nan na'gwa san iningkagwanchas chayan ja ininoncha nangimatun an Hesus san nami'pi''iyana san tinapay. ");
INSERT INTO kyb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Anna kunay iwhakawhakan chachay chugwa nan na'na'gwa summi'ad as Hesus san agwachancha kun anana an chicha, “Atchan otjan Apudyus cha'aju as whayuway somsomo' gway maid kun machanakanju.” ");
INSERT INTO kyb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gwon na'asugkajatcha ja ummogjatcha tan anancha kunnu ayan nan inilacha. ");
INSERT INTO kyb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kun anan Hesus an chicha, “Ka'ajuman umogjat ja ka'aju manchugwachugwa? ");
INSERT INTO kyb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilanju nan ima' ja i'i', sa'onna mismu. Odnana' ad inakammujuway sa'on tan sa'ad nan ayan maid kun longagna ja tungerna gwon an sa'on mailajuway anna.” ");
INSERT INTO kyb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ingwhakana kunan sachi impailana an chicha nan imana ja i'ina. ");
INSERT INTO kyb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sissija achay achicha kun mamati kapu san lagsa'cha ja taagcha, anan Hesus an chicha, “Agwad ma'anju ad asna?” ");
INSERT INTO kyb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kun inatchanchas sija san i'an gway nachagwis. ");
INSERT INTO kyb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inayana kun inanna san sangucha. ");
INSERT INTO kyb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gwot anana an chicha, “Annachaja chachay ingwhakawhaka' an cha'aju say iniingkagwa' an cha'aju gway maserpu ma'gwa nan losanay nilista san lintog Moses ja illistan chachay profeta ancha nilista san nibyuway Salmo nan mipangkop an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kun inibwhatna nan somsomo'cha tot maagwatancha nan nilistaay Ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kun anana an chicha, “Nilista san agwiyay mallikat nan Kristu ja matoy ad nataku san mi'atlu erkaw. ");
INSERT INTO kyb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ad maserpu misuyu san losanay ailiili manipud ad Jerusalem gway kapu san ngachanna ligwatan Apudyus nan whersun chanan manchu'kancha nan whersucha. ");
INSERT INTO kyb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Cha'aju nan mangipano'no' sannachaja. ");
INSERT INTO kyb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chongyonju na, iwhaun'u nan ingwhawhagkan Ama an cha'aju. Gwon iingkaw ajud asnaay ili ingkanas maagwatju nan ayobhonganay merpud langit.” ");
INSERT INTO kyb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sachi kun iyoy Hesus chachay pasuyutna ad Betania. Intajagna kunan imana ingwhakana gway pawhayugwon Apudyus nan whijagcha. ");
INSERT INTO kyb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sa'ad nan nangiwhaganas chi ummachaju an chicha kun nipangatud langit. ");
INSERT INTO kyb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nanchaychajawcha an sija kun nanulincha ad Jerusalem gway amod nan lagsa'cha. ");
INSERT INTO kyb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kun patinajunay umoycha san Templo manchaychajaw an Apudyus.");
INSERT INTO kyb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sa'ad san chaan ma'gwa nan losan nisisikud nan Ukud ad sa'ad nan Ukud nihuyun an Apudyus ad sa'ad nan Ukud, Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nisisikuchay nihuyun nan Ukud an Apudyus san chaan ma'gwa nan luhung. ");
INSERT INTO kyb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ad kapu san Ukud inggwan Apudyus nan losan. Ad maid kun na'gwa nu wha'on as kapu san Ukud. ");
INSERT INTO kyb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sa'ad nan Ukud sija nan merpugwan nan whijag ad nannaja whijag sija nan silaw gway mamadcha san somsomo' chanan taku. ");
INSERT INTO kyb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sa'ad nan silaw papadchaona nan manghulingot ad nan manghulingot achi kun ma'aawha' san padcha. ");
INSERT INTO kyb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iningkaw nan osa takuway ingwhaun Apudyus gway Juan nan ngachanna. ");
INSERT INTO kyb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kun ummalis sija tot iwhakana nan mipangkop san silaw tot losan otjan chanan taku mamati kapu san iwhakana. ");
INSERT INTO kyb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wha'on kus sija nan silaw gwon ummalina ekay impano'no' nan mipangkop san silaw. ");
INSERT INTO kyb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sa'ad nan kadto'ay silaw gway mamadcha san somsomo' chanan taku, sija nan umali ad asna luhung. ");
INSERT INTO kyb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gwon ta'on nu ummalis sija ad asna luhung ja na'gwa nan luhung kapu an sija, achin ku chanan taku whinigwhig as sija nu ngachanna as sija. ");
INSERT INTO kyb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ummoy as sija san ilina gwon achin ku chanan ailijana Hudyu whinigwhig as sija. ");
INSERT INTO kyb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gwon sa'ad chanan namigwhig an sija ja namati an sija nangngachanona chichas ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wha'on kus nangngachancha ana' Apudyus kapu san nerpugwancha gwinnu kapu san whinayun nan manasagwa gwon kapu san whinayun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nangngachan taku chay Ukud kun na'aumili an chita'u ad asna luta. Amod nan inawhayuna ja sija nan mangipaakammu san atuttugwaan. Inilami nan ina'erjadna gway nangipaila san ina'apudyus Apudyus gway naayana as osossa''anay ana' Amana gway Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kun pinano'no'an Juan gway manghohonjag nan mipangkop an sija kun impa'uyna gway manggwana, “Annaja chay ingwhaka' say manggwanaa'on, ‘Sa'ad nan umali mipasu an sa'on nangatngatu an sa'on kapu tan nisisikud as sija san chaan'u mijana'an.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kapu san maid ku agwat nan inawhayuna mansinu'nub nan whayuway inatodna an chita'u. ");
INSERT INTO kyb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Inatod Apudyus nan Lintogna kapu an Moses gwon sa'ad nan inawhayuna ja atuttugwaan gway mipangkop an sija, naatod an chita'u kapu an Hesu Kristu. ");
INSERT INTO kyb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maid kun osas nangila an Apudyus. Ahus nan osossa''anay Ana'na gway Apudyus ahos ekay as sija gway pagchot nan mihuyunana an Amana. Sija nan nangipaakammu an chita'u an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ad sa'ad chanan papangat nan Hudyu ad Jerusalem nangiwhauncha sasan papachi ja chanan Levita tot umoycha imuson an Juan ananon, “Ngachan'a?” ");
INSERT INTO kyb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kun ingwhawhagkan Juan nan tuttuwa gway achina kun insulib kun anana, “Wha'ona' kus Kristu.” ");
INSERT INTO kyb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kun anancha an sija, “Ad ngachan'a nu'? Si'a chay Elias?” Kun anana, “Wha'ona' kun.” Kun anancha, “Si'a chay profetan Apudyus gway uullajonmi?” “Wha'on,” anana. ");
INSERT INTO kyb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Gwot anancha an sija, “Ngachan'a man nu'? Sungwhatam cha'ami ta agwad iwhakami san nangiwhaun an cha'ami. Ngachamma anam san mipangkop an si'a?” ");
INSERT INTO kyb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kun anan Juan gway summungwhat, “Sa'on chay anan Isaias gway profetan Apudyus san agwiyon, ‘Anna nan osaay iniingkaw san luta gway maid kun ingkaw as taku gway mampa'upa'uy gway ananaon pawhayugwonju nan manadchayanan nan Apu.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ad sa'ad chachay ingwhaun chanan Pariseo gway ummoy an Juan ");
INSERT INTO kyb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","inimuscha an sija gway manggwana, “Nu wha'on'a kus Kristu gwinnu wha'on'a ku an Elias gwinnu wha'on'a kus profetan Apudyus, ka'a manghonjag nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kun anan Juan gway summungwhat, “Manghonjaka' san chanum jon agwad an cha'aju nan osaay achiju kun agakammu nu ngachanna as sija. ");
INSERT INTO kyb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Sija nan umali mipasu an sa'on gwon achiya' kun miwhilang as mansilwhi an sija uyay mangaan san sinilasna.” ");
INSERT INTO kyb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na'gwa losan nannachaja san ilid Betania san chomang nan gwanggwangay Jordan gway ad aschi nan nanghonjahonjakan Juan. ");
INSERT INTO kyb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mawhikat kun inilan Juan as Hesus gway takangay mi'atum an sija kun anana, “Anchiya nan Kerneron Apudyus gway michatun gway malligwat san whersun nan losanay takud asna luta! ");
INSERT INTO kyb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sija chay ingwhakawhaka' san manggwanaa'on, ‘Umchas an sa'on nan osa takuway nangatngatu an sa'on kapu tan nisisikud as sija san chaan'u mijana'an.’ ");
INSERT INTO kyb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Achi' kun naimatunan san chamu gway sija chay takuway ingwhaka' gwon ummaliya' manghonjag san chanum tot mipaakammus sija sasan ijIsrael.” ");
INSERT INTO kyb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kun impano'no' Juan gway manggwana, “Inila' nan Ispilitun Apudyus gway chumo''ocho''oya gway isun chi kaob nan kalapati gway nerpud langit kun ummoy inumpa an sija. ");
INSERT INTO kyb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Achi' kun naimatunanay sija chay takuway ingwhaka'. Gwon sa'ad as Apudyus gway nangiwhaun an sa'on gway umali manghonjag san chanum anana an sa'on, ‘Mailam nan Ispilitu' gway chumo''ocho''oya ad iningkaw an sija. Sija nan mangipaali san Ispilitu' gway ingkaw sasan taku.’ ");
INSERT INTO kyb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ad kapu tan inila' nannaja na'gwa an Hesus, ta'choya' gway sija nan Ana' Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Asin ku mawhikat agwad ahos cha Juan ja nan chugwa sasan pasuyutna ad aschiyay summisi'ad. ");
INSERT INTO kyb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Intollong kun Juan as Hesus gway manadchadchayan anana, “Anchiya nan Kerneron Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chingngorn ku chachay chugwaay pasuyut Juan nan ingwhakana tinunudchas Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nantulili kus Hesus inilana chichaay mituntunud an sija. Kun anana an chicha, “Ngachan nan anaponju?” Kun anancha an sija, “Rabbi, agwan nan iingkagwam?” (Nan pijaona anan nan apapat gway “Rabbi”, Mistuyu.) ");
INSERT INTO kyb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kun anan Hesus an chicha, “Gwayyu ta umaliju ilan.” Summingwhattang as anchu nan tayun san nitunuchancha an Hesus san ikawna kun iningkawcha an sija ingkanas maschom. ");
INSERT INTO kyb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sa'ad as Andres sija nan osa sasay chugwaay nangngor san ingwhakan Juan gway nitunud an Hesus. Sunud Simon Pedro as sija. ");
INSERT INTO kyb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kun sija ummunana inggwa nan ummoyna inanap as Simon gway sunudna kun anana an sija, “Inchasanmi nan Mesias.” ");
INSERT INTO kyb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kun iyoy Andres as Simon an Hesus. Kun intotollong Hesus as Simon kun anana, “Si'a uwa as Simon gway ana' Juan? Mangngachan'a Cefas.” (Nan Cefas isuna san Pedro gway sa'ad nan pijaona anan “whatu”.) ");
INSERT INTO kyb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mawhikat kun simsimmo' Hesus gway umoy ad Galili. Kun inchasana ad aschi as Felipe kun anana an sija, “Mitunud'a an sa'on ad nangngachan'a pasuyut'u.” ");
INSERT INTO kyb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Sa'ad as Felipe iBetsaida, sa'ad nan Betsaida ilin cha Andres an Pedro. ");
INSERT INTO kyb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kun inanap Felipe as Natanael gwot inchasana kun anana an sija, “Inchasanmis sija gway chay illistan Moses san nibyun nan Lintog ja illistan ahos chachay profetan Apudyus. Sija as Hesus gway iNazaret gway ana' Josep.” ");
INSERT INTO kyb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kun anan Natanael an sija, “Ama' agwad whayu as merpud Nazaret?” Kun anan Felipe an sija, “Gwaynu ta umalim ilan.” ");
INSERT INTO kyb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Inilan kun Hesus gway umoy as Natanael an sija anana san mipangkop an Natanael, “Annaja nan kadto'ay ijIsrael gway achi kun mansi'ap.” ");
INSERT INTO kyb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kun anan Natanael an sija, “Ka akammum as sa'on?” Kun anan Hesus gway summungwhat, “Inila' si'a gway iniingkaw san puun nan ajuway igos san chaan Felipe mangajakan an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kun anan Natanael gway summungwhat, “Mistuyu, si'a nan Ana' Apudyus! Si'a nan Alin chanan ijIsrael!” ");
INSERT INTO kyb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kun anan Hesus an sija, “Kapu tan ingwhaka' an si'a gway inila' si'a san puun nan ajuway igos sijachi nan mamatiyam? Amamod pay'a nan mailam sannaja!” ");
INSERT INTO kyb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kun anana an chicha, “Iwhaka' an cha'aju nan tuttuwa gway mailaju nan langit gway miibwhat ja chanan a'anghel Apudyus gway mansinuhotay manakacha ja manosog san agwacha' gway Ana' nan Taku.” ");
INSERT INTO kyb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mi'atlu kunay erkaw san nangajakan Hesus ancha Felipe an Natanael, iningkaw nan hoyay ad Cana ad Galili. Kun ummoy na'abyay nan inan Hesus ad aschi. ");
INSERT INTO kyb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ad sa'ad as Hesus ja chanan pasuyutna, naajakancha hos san hoyay. ");
INSERT INTO kyb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Namin kunan whajas anan nan inan Hesus an sija, “Namin nan whajas.” ");
INSERT INTO kyb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kun anan Hesus an sija, “Ina, kamma itaptapis sa'on. Chaan ku humu'nag nan chimpuway mangipaila' san ayobhonga'.” ");
INSERT INTO kyb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Gwon anan nan inan Hesus sasay pujung san sachi hoyoy, “Oonju nu ngachan nan iwhakana an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kun iningkaw nan onomay amutu whatu gway nisasaad gway sillimman lataanay chanum nan umoy. Sachi nan manghuyugwan chanan Hudyu mipangkop san ukalicha tot machayusancha. ");
INSERT INTO kyb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kun anan Hesus sasay pujung san sachi hoyoy, “Pungwonju nan annatchaja amutu san chanum.” Kun pinnucha chachay amutu. ");
INSERT INTO kyb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gwot anan Hesus an chicha, “Kumaud aju ad iyoyyu san sin'erku san hoyay.” Kun iyoycha. ");
INSERT INTO kyb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Inippong ku chay sin'erku san hoyay nan chanumay nangngachan whajas, inajakana chay namyay gway laya'i. Wha'on kus akammun chay sin'erku san hoyay nu agwan nan nerpugwan chay whajas ta'on nu akammun chachay pujung san sachi hoyoy. ");
INSERT INTO kyb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Kun anana say namyay, “Ukalin nan takuway umunacha jan ipainum nan pijaay whajas. Awni achay mahutong chanan taku asiyot nan na'ilom. Gwon san sana nangudchijom impainum nan pijaay whajas.” ");
INSERT INTO kyb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sa'ad nannajaay na'gwa ad Cana ad Galili sija nan ummuunnaay mataakan gway inggwan Hesus gway nangipailana san ayobhongana. Kun tinuttuwan chachay pasuyutna as sija. ");
INSERT INTO kyb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nappung kunan sachi, ummoy as Hesus ja as inana ja chanan susunudna lallaya'i ancha chachay pasuyutna ad Capernaum kun iningkawchad aschi as amanaay erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Takangay kunan pijastan nan Hudyu gway ma'gwaniyon Lumaus ummoy as Hesus ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ad sa'ad san agwachana san sowhan nan Templo inchasana chanan mangamusantiyay mangila'ya'u san wha'a, kernero, kalapati ancha manooyos san pila'. ");
INSERT INTO kyb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kun nangayas Hesus as tali gwot inggwanas abchoy kun pinerjawna chicha losan san sowhan nan Templo ama ahos chanan kernero ancha wha'a. Kun iwwalisa'na nan pila' chachay manooyos san pila' gwot tinugwadna nan lamisaancha. ");
INSERT INTO kyb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kun anan Hesus sasay mangamusanti sasan kalapati, “Ipayagwaju nannachaja. Achiju oon nan hoyoy Ama as laya''uwan.” ");
INSERT INTO kyb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kun simsimmo' chachay pasuyutna nan nilista san agwi san ukud Apudyus gway anana, “Nan mangipatog'u san hoyoynu Apudyus sija nan loog'u matojan.” ");
INSERT INTO kyb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kapu san inggwan Hesus anan chachay papangat nan Hudyu an sija, “Ngachan nan mataakanay ipailam an cha'ami ta mangipano'no' gway anna nan ayobhongamay manggwa san amasna?” ");
INSERT INTO kyb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kun anan Hesus gway summungwhat, “Nu igwa''iju nannaja Templon Apudyus asin'u oon san tuyu erkaw.” ");
INSERT INTO kyb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Gwot anan chachay Hudyu, “Opat puyu ja onomay tagwon nan na'gwaan nannaja Templon Apudyus, kunja anamon oom san tuyu yakajay erkaw?” ");
INSERT INTO kyb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gwon sa'ad nan iwhagwhakan Hesus gway mipangkop san Templon Apudyus longagna. ");
INSERT INTO kyb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sija nan nataku kun as Hesus san natojana simsimmo' chachay pasuyutna chay ingwhakana. Kun tinuttuwacha nan nilistaay Ukud Apudyus ja chay ingwhakan Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sa'ad san agwachan Hesus ad Jerusalem san Pijasta gway ma'gwaniyon Lumaus, angsan nan namati an sija san inilacha nan mataakan gway inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gwon achin ku Hesus intayo' nan longagna an chicha tan aagkammuna nu ngachan nan agwad san somsomo' nan losanay taku. ");
INSERT INTO kyb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sija nan wha'on kus maserpuna nan agwad mangiwhaka an sija san mipangkop sasan taku tan aagkammuna nan agwad san somsomo' nan osa taku. ");
INSERT INTO kyb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iningkaw nan Pariseo gway Nicodemo nan ngachanna gway osas sija gway pangat nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Osa kunay lawhi ummoy as Nicodemo an Hesus kun anana, “Rabbi, akammumiyay si'a nan mistuyuway ingwhaun Apudyus. Maid kun osas ma'a'gwa sannachaja mataakan gway o'oom nu maid as Apudyus an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kun anan Hesus gway summungwhat, “Iwhaka' an si'a nan tuttuwa, maid kun osas mitapi sasan takuway ituyajan Apudyus nu achi mijana' asin.” ");
INSERT INTO kyb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kun anan Nicodemo, “Ininon manan naotongay taku gway mijana' asin? Ininona manay managkulin asin san takana'on inana ad nipiggwaay mijana'?” ");
INSERT INTO kyb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kun summungwhat as Hesus gway manggwana, “Iwhaka' an si'a nan tuttuwa, maid kun osas mitapi sasan takuway ituyajan Apudyus nu achi mijana' san chanum ja san Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa'ad nan ijana' nan taku, taku hos ekay gwon ahus nan Ispilitun Apudyus as mangngachanam ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Achi'a mataag san ingwhaka' an si'a gway maserpu mijana' aju asin. ");
INSERT INTO kyb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Isun nan mangngoyanju san agwogwos nan tungnin gway achi kun maakammugwan nu agwan nan merpugwana gwinnu agwan nan umajana. Sija nan achim pun mipaagwat nan ininon chanan takuway mijana' san Ispilitun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kun anan Nicodemo an sija, “Ngachamma ininon nina ma'gwa nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kun anan Hesus an sija, “Osa'a nangatu gway mistuyu ad asna Israel, kunja achim maagwatan nannachaja? ");
INSERT INTO kyb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iwhaka' an si'a nan tuttuwa, anna iwhakami nan akammumi ja ta'choyanmi nan inilami gwon sissijaay achiju kun tuttugwaon nan iwhakami. ");
INSERT INTO kyb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ingwhakawhaka' an cha'aju nan mipangkop san ma'ma'gwa ad asna luta gwon achiju kun tuttugwaon. Kanuyaman nu iwhaka' nan mipangkop san ma'ma'gwa ad langit as tuttugwaonju? ");
INSERT INTO kyb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tan maid kun osas ummoy ad langit nu achi ahus as sa'on gway Ana' nan Taku gway nerpud langit. ");
INSERT INTO kyb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Sa'ad as Moses san nugwan san iningkagwancha san luta gway maid kun ingkaw as taku, inigkana san aju nan uyog gway na'gwa san hulinsi. Amasna ahos nan maserpu ma'gwa an sa'on gway ngagnoncha Ana' nan Taku gway miwhajug san krus. ");
INSERT INTO kyb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tot ngachan ad nan mamati an sa'on ma'awhijag an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kapu san impatpatog Apudyus as amod chanan taku ad asna luta, impaalina nan osossa''anay ana'na tot ngachan ad nan mamati san ana'na achi kun misiyan an Apudyus as ingkaingkana jon ma'awhijag an sija as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tan sa'ad as Apudyus wha'on kus impaalina nan Ana'na ad asna luta tot lodchongana chusaon chanan taku gwon impaalinas sija tot takuwona chanan taku. ");
INSERT INTO kyb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu ngachan nan mamati san Ana'na achi kun mayodchonganay machusa. Gwon sa'ad chanan achi kun mamati naahuscha mayodchonganay machusa kapu tan achicha kun tinuttuwa nan osossa''anay Ana' Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Amasna nan i'aman Apudyus gway mangu'um sasan taku: Tan ummali ad asna luhung as Hesus gway anig silaw tot padchaana nan somsomo' chanan taku san atuttugwaan gwon sija impatpatogcha nan manghulingot nu nan padcha kapu tan lagwing nan o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sa'ad chanan manggwamanggwa san lagwing, lagwingoncha mapadchaan nan somsomo'cha ja achicha kun umachayug sannajaay silaw tan mawhaincha mallotaw nan lagwingay o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gwon sa'ad chanan manggwa san ustu umachayugcha san silaw tot sa'ad nan inggwacha sachi nan mangipaila gway chumngorcha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nappung kunan sachi ummoy cha Hesus ja chanan pasuyutna san ilid Judea kun iningkaw as Hesus an chicha ad aschi as amanaay erkaw gwot nanghonjahonjag. ");
INSERT INTO kyb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ad sa'ad ahos as Juan nanghonjahonjag ad Enon san achani ad Salim kapu tan angsan nan chanum ad aschi. Kun ummuummoy chanan taku nampahonjag an sija. ");
INSERT INTO kyb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tan sa'ad san sachi chimpu chaan kus Juan miwhayud. ");
INSERT INTO kyb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kun iningkaw chanan pasuyut Juan ja nan osaay Hudyu gway mansinsinnungwhatchas mipangkop san ukalicha san ininonchaay machayusan. ");
INSERT INTO kyb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sachi kun ummoycha an Juan kun anancha an sija, “Mistuyu, sa'ad chay takuway huyunnu san agwachanju san chomang nan gwanggwangay Jordan gway chay ingwhakam an cha'ami, agwachay manghonjahonjag as sija kun sija nan umajaajan nan losanay taku.” ");
INSERT INTO kyb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kun anan Juan gway summungwhat, “Achi kun ma'gwa nan amasna san osa taku nu wha'on as Apudyus nan mangijuja an sija. ");
INSERT INTO kyb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cha'aju mismu nan mamano'no' san ingwhaka' an cha'ajuway, ‘Wha'ona' kus Kristu gwon niwhauna' gway ummuna an sija.’ ");
INSERT INTO kyb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sa'ad nan laya'iyay mangibyay sija nan mijamungan nan huwhaiyay miibyay. Sa'ad nan hubuyun nan laya'iyay mangibyay manuullay ja chochongyona chay mangibyay ad mallaylajad san mangngoyana san kingan nan laya'iyay mangibyay. Sa'ad as Hesus mijalig san laya'iyay mamyay ad sa'on nan hubuyun chay laya'iyay mamyay. Sija nan kapu sannaja amod nan lagsa''u. ");
INSERT INTO kyb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maserpu as Kristu nan mangngachan napatpatog an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Sa'ad nan merpud langit angatuwan san losan. Sa'ad nan merpud asna luta iluta as sija ad iwhakana nan mipangkop san ma'ma'gwa ad asna luta. Gwon sa'ad nan sachi merpud langit angatuwan san losan. ");
INSERT INTO kyb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iwhakana nan inilana ja chingngornad langit gwon ta'on nu amaschi maid kun mamati san ingwhakana. ");
INSERT INTO kyb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nu ngachan nan mamati san ingwhakana ipaakammuna gway kadto' as Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tan sa'ad chay ingwhaun Apudyus gway ana'na iwhakana nan ukud Apudyus kapu tan naatod an sija nan losanay ayobhongan nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ipatpatog Amana nan Ana'na kun impawhijangna an sija nan losan. ");
INSERT INTO kyb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ad nu ngachan nan mamati san Ana' Apudyus ma'awhijag an Apudyus as ingkaingkana. Nu ngachan nan achi chumngor san Ana'na achina kun mapachasan nan whijag gway maid kun pungpungna ad achi kun mappung nan manusaan Apudyus an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chingngorn chanan Pariseo gway adachu nan nitunud ja whinonjakan Hesus gway pasuyut nu nan whinonjakan Juan ");
INSERT INTO kyb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ta'on nu wha'on kus Hesus nan nanghonjag gway ahus ekay chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Inakammun kun Hesus chay chingngorn chachay Pariseo lummajawchad Judea kun ummoycha nanagkulin ad Galili. ");
INSERT INTO kyb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kun simsimmo' Hesus gway maserpu mangoychad Samaria. ");
INSERT INTO kyb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kun hummu'nagcha san osaay ilid Samaria gway Sicar gway achani san tayun gway inatod Jacob san agwi an Josep gway ana'na. ");
INSERT INTO kyb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Agwad san sachi nan huhun Jacob. Ad kapu tan naunger as Hesus gway nangwhaat tummu'chus sija san ngawhangab nan huhun. Kun takangay as mamatu' nan tayun san sachi. ");
INSERT INTO kyb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sa'ad chanan pasuyutna ummoycha nalla'us anoncha san hobyoy. Awni kun hummu'nag nan osa huwhai gway iSamaria gway mana'chu. Kun anan Hesus an sija, “Atchana'ud as inumo'.” ");
INSERT INTO kyb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kun anan chay huwhai an sija, “Tan Hudyu'a kayya, ka'a man'ochaw as inumom an sa'onay huwhai gway iSamaria.” Tan sa'ad ka chanan Hudyu maid ku manggwaancha san iSamaria. ");
INSERT INTO kyb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kun anan Hesus gway summungwhat, “Sa'ad nu inakammum nu ngachan nan atchon Apudyus ja nu ngachanna as sa'on gway man'ochaw an si'a san chanum, si'a otjan nan man'ochaw an sa'on ad inatcha' si'a san chanumay mangatod san whijag.” ");
INSERT INTO kyb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kun anan chay huwhai an sija, “Apu, maid kun ikaudnu ancha achayo' nannaja huhun. Agwamma nan mangallam san sanatay chanumay mangatod san whijag? ");
INSERT INTO kyb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sa'ad as Jacob gway nerpugwan ta'u impaya'sunna nannaja huhun an cha'ami. Annaja nan mangaallana as inumona ja chanan anana'na ancha chanan ajamna. Adja anamon nangatngatu'a an Jacob gway nerpugwan ta'u?” ");
INSERT INTO kyb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kun summungwhat as Hesus gway manggwana, “Losanay uminum sannaja chanum mauwaw asin. ");
INSERT INTO kyb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gwon nu ngachan nan uminum san chanumay atcho' an sija achi kun puyus mauwaw. Sa'ad nan chanumay atcho' an sija mangngachan obob san longagna gway achi kun matchu' ja mangatod an sija san whijag gway maid kun pungpungnana.” ");
INSERT INTO kyb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kun anan chay huwhai, “Apu, atchana'ud san sanatay chanum tot achiya' mauwaw ja achiya' umalaalid asna mana'chu.” ");
INSERT INTO kyb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kun anan Hesus an sija, “I'a ajakan nan asagwam ad ummali ajud asna.” ");
INSERT INTO kyb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kun anan chay huwhai summungwhat, “Maid kun asagwa'.” Gwot anan Hesus an sija, “Tuttuwa nan anam gway maid kun asagwam ");
INSERT INTO kyb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tan lima nan inasagwam ad sa'ad nan agwad an si'a san sana wha'on kus kadto'ay asagwam. Tuttuwa nan ingwhakam an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kun anan chay huwhai, “Apu, naakammugwa'ay profeta'a. ");
INSERT INTO kyb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sa'ad chanan aammami san agwi annaja whilig nan nanchaychajagwancha an Apudyus. Gwon sa'ad as cha'ajuway Hudyu ananjuwon ad Jerusalem nan maserpuway manchaychajagwan chanan taku an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kun anan Hesus say huwhai, “Mamati'a an sa'on tan humu'nag nan chimpuway wha'on kusan annaja whilig gwinnu wha'on kud Jerusalem nan manchajagwanju an Ama gway Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sa'ad as cha'ajuway iSamaria achiju kun akammu nu ngachanna as Apudyus gway chaychajagwonju. Gwon sa'ad as cha'amiyay Hudyu akammumi nan chaychajagwonmi kapu tan sa'ad nan manaku sasan taku merpu sasan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gwon umali nan chimpu kun annaja angkay gway hummu'nag gway sa'ad chanan tuttuwaay manchajaw an Ama gway Apudyus kapu san ayobhongan nan Ispilituna chaychajagwonchas sija san tuttuwaay ina'apudyusna. Tan amasna nan whayugwona gway sa'ad chanan manchajaw an sija maserpu kadto'ay chaychajagwonchas sija. ");
INSERT INTO kyb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tan as Apudyus ispilitu gway achi kun maila, sija nan sa'ad chanan manchaychajaw an Apudyus maserpu manchajawcha kapu san ayobhongan nan Ispilitun Apudyus san kadto'ay ina'apudyusna.” ");
INSERT INTO kyb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kun anan chay huwhai an sija, “Akammu'ay umali nan Mesias gway ananchaon Kristu. Ad nu umalis sija ipaakammuna nan losan an chita'u.” ");
INSERT INTO kyb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kun anan Hesus gway summungwhat, “Sa'on nan Mesias gway anna ma'aapaapat an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nappungna kun iwhaka nan sachi hummu'nag chanan pasuyutna. Kun nataagcha tan inchasanchas Hesus gway ma'aapaapat san huwhai. Gwon maid kun osas nanimus san huwhai nu ngachan nan maserpuna gwinnu maid kun manggwana an Hesuson ka'a ma'aapapat an sija. ");
INSERT INTO kyb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sija nan tinaynan chay huwhai nan whangana kun nanagkulin san hobyoy kun anana sasan taku, ");
INSERT INTO kyb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Gwayyu ta umaliju ilan nan laya'iyay nangiwhaka an sa'on san losanay inggwa'inggwa'. Sija nin nan Kristu?” ");
INSERT INTO kyb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kun lummiggwatchaay umoy mangila an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa'ad san sachi hos ekajay uyas inajakan chachay pasuyut as Hesus gway manggwana, “Mistuyu, gwaynu kot ta mangan'a.” ");
INSERT INTO kyb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gwon anana an chicha, “Anna nan ano' gway achiju kun akammu.” ");
INSERT INTO kyb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sija nan asi'a'anan chachay pasuyutna, “Ama anu' agwad nangijalis inanna ta?” ");
INSERT INTO kyb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kun anan Hesus an chicha, “Sija ma'an'u nan oo' nan whayugwon nan nangiwhaun an sa'on gway pungpungo' nan terwhasuway pa'gwana an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ad achi sija chay ananjuwon, ‘Opat achay huyan asiyot nan iya''ani?’ Gwon iwhaka' an cha'ajuway iya''ani san sana. Ilanju nannachaja takuway umali manchongor san sussuyu', anigcha pakoy gway nerrum ad maserpuway maani. ");
INSERT INTO kyb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ad sa'ad nan manani matangchanan ja sa'ad chanan taku gway aniyona ma'awhijagcha an Apudyus as ingkaingkana. Tot sa'ad nan mangimuya ja nan manani manisucha gway mallagsa'. ");
INSERT INTO kyb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tan tuttuwa nan ananchaon, ‘Uchum nan mammuya ad sawhali nan manani.’ ");
INSERT INTO kyb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ingwhaun'u cha'ajuway mangani san wha'on kus tinerwhasuju. Inungern nan uchum kun cha'aju nan nanganab.” ");
INSERT INTO kyb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kun angsan chanan iSamaria san sachi iliyay namati an Hesus kapu san nangipano'no'an chay huwhai san nangiwhagan Hesus an sija san losanay inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sija nan ummoy ku chachay iSamaria an Hesus tinagwichanchas sija kun na'aggwa erkaw nan iningkagwan Hesus ad aschi. ");
INSERT INTO kyb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kun nachogwachogwan nan namati an Hesus kapu san nangngoyancha san insuyuna. ");
INSERT INTO kyb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kun anan chachay taku say huwhai, “San sana mamati ami wha'on kus kapu san ingwhakam gwon kapu tan cha'ami mismu nan nangngor sasan ingwhakana kun akammumiyay sija nan tuttuwaay manaku sasan taku ad asna luta.” ");
INSERT INTO kyb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na'aggwa ku erkaw Hesus ad Samaria ummoy as sija ad Galili. ");
INSERT INTO kyb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tan as Hesus nan nangiwhaka gway, “Sa'ad nan profeta wha'on kus chajagwon chanan ailijanas sija.” ");
INSERT INTO kyb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hummu'nag kus Hesus ad Galili minangilin chanan umili as sija kapu tan ummoycha ku say pijasta gway ma'gwaniyon Lumaus ad Jerusalem, inilicha nan losanay inggwana say chimpun nan pijasta. ");
INSERT INTO kyb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sachi kun ummoy as Hesus asin ad Cana ad Galili gway ad aschi chay nanggwaana san chanum as whajas. Kun iningkaw ad aschi nan osa pangat nan kuwhilnu gway nasa'it nan ana'na laya'i ad Capernaum. ");
INSERT INTO kyb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chingngorna kunay hummu'nag as Hesus ad Galili gway nerpud Judea, ummoy as sija kun nampa'pa''aasi an Hesus gway umoy ad Capernaum ta pawhayugwona nan ana'naay takinootojon. ");
INSERT INTO kyb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kun anan Hesus an sija, “Tuttuwa gway achi aju kun mamati nu maid kun mailajus oo' as mataakan.” ");
INSERT INTO kyb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kun anan chay pangat, “Apu, akag'aud umali ta achi matoy nan ana''u.” ");
INSERT INTO kyb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kun anan Hesus an sija, “I'a lumajaw tan nataku nan ana'nu!” Kun tinuttuwan chay pangat nan ingwhakan Hesus an sija gwot aysan. ");
INSERT INTO kyb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ad sa'ad san agwachana san chayan inahot chanan mudchachuna as sija kun ingwhakachaay nataku chay ana'na. ");
INSERT INTO kyb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kun inimusna an chicha nu ma'anu nan nallukijan nan na'aanan nan sa'it chay ana'na. Kun anancha an sija, “Kallab san machama nan na'aanan nan angodna.” ");
INSERT INTO kyb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kun inakammun chay ama gway amaschi chay uyas gway nanggwanaan Hesus an sijaon, “Nataku nan ana'nu.” Sija nan namatis sija ja losanay ahumerjanna an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Annaja nan mi'aggwaay mataakan gway inggwan Hesus san ummajanad Galili gway nerpud Judea. ");
INSERT INTO kyb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nappung kunan inggwan Hesus ad Galili ummoy ad Jerusalem na'apijasta san osa sasan pijastan chanan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iningkaw ad Jerusalem nan aamsan gway Betsata nan ngachanna san Whinudyuway apapat. Sa'ad nan sachi aamsan achani san loyon'an san ili gway nginadnanchas loyon'an nan Kernero. Ad san sachi hosay aamsan agwad nan limaay iidchungan. ");
INSERT INTO kyb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kun iningkaw nan amochay takuway nan'inayasi nan sa'itcha gway annat nan na'uyap, napilay ancha napalalais gway naohoohog sasan iidchungan. Uullajoncha nan mangkichugwan nan chanum ");
INSERT INTO kyb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tan sa'ad nu hotangna umali nan anghel Apudyus ad nantipja'agwona nan chanum san aamsan. Ad sa'ad nan umuna pumisu' san chanum nu nappung mantipja'aw, ma'aan nan ngachammasnatay sa'itna. ");
INSERT INTO kyb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kun iningkaw ad aschi nan osa laya'iyay tuyumpuyu ja gwayu tagwon nan nasasa''itana. ");
INSERT INTO kyb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Inilan kun Hesus as sija gway inuumhog ad aschi gwot inakammunaay nawhajakay nasasa''it, anana an sija, “Whayugwomay ma'aan nan sa'itnu?” ");
INSERT INTO kyb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kun anan chay nasa'itay summungwhat, “Apu, maid kun mamachang an sa'on gway mangijoy san aamsan nu mantipja'aw nan chanum. Tan sa'ad nu ana'on iya' naahus nan uchum pumisu'.” ");
INSERT INTO kyb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kun anan Hesus an sija, “Humangon'a ad inayam nan inogkam ad nanadchayan'a.” ");
INSERT INTO kyb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kun chakasna hummayu chay laya'i kun inayana nan inogkanaot nanadchayan. Sa'ad nan na'gwaan nan sachi, Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sija nan anan chachay papangat nan Hudyu say laya'iyay hummayu, “Achi ku mawhalinay manochon'a san ohognu tan mijachi san lintog ta'u nan manterwhasu san Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Gwon anan chay laya'iyay na'aan nan sa'itna, “Sa'ad chay takuway nangaan san sa'it'u ingwhakana an sa'on ananon, ‘Ayam nan ohognu ad nanadchayan'a.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kun inimuscha an sija gway manggwana, “Ngachan ninatay taku nan manggwana an si'aon ayam nan ohognu ad nanadchayan'a?” ");
INSERT INTO kyb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gwon sa'ad chay laya'iyay na'aan nan sa'itna achina kun akammu nu ngachan nan nangipawhayu an sija kapu tan amod nan taku san sachi kun aysan as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Awni kun inchasan Hesus chay laya'i san Templo. Kun anana an sija, “Ilam achot na'aan nan sa'itnu! Achi'a asin humersu tot achi sinumamod nan ma'gwa an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kun aysan chay laya'iyot ummoyna ingwhaka sasay papangat nan Hudyu gway as Hesus nan nangipawhayu an sija. ");
INSERT INTO kyb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ad kapu sannaja illukin chachay papangat nan Hudyuway pergwingon as Hesus kapu tan nangipawhayu as sija san Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gwon anan Hesus gway summungwhat an chicha, “Sa'ad as Ama achi kun umillongay manterwhasu ad isu' ahos.” ");
INSERT INTO kyb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sija nan kapu sannaja nalingu as amod chanan papangat nan Hudyu kun whayugwonchaay otojon as Hesus kapu tan wha'on kun ekas ahus nan nallabsingana san lintog nan Erkaw gway Umillongan gwon mangngagnona hos Amana as Apudyus gway ijisuna nan longagna an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kun anan Hesus gway summungwhat, “Iwhaka' an cha'aju nan tuttuwa, sa'ad as sa'on gway Ana' Apudyus wha'on kus oo' nan terwhasu san ugwa'ay somsomo' gwon sija ekay oo' nan maila' gway oon Ama. Nu ngachan nan oon Ama sija ahos nan oo'ay Ana'na. ");
INSERT INTO kyb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tan sa'ad as Ama ipatpatognas sa'on gway Ana'na ja ipailana an sa'on nan losanay oona. Ipailana an sa'on nan amamochay mataakanay ma'gwa nu nan annachaja tot losan aju mataag. ");
INSERT INTO kyb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tan sa'ad nan manakuwan Ama sasan natoy ja mangatchana an chicha san whijag, isuna hos an sa'on gway Ana'na gway atcha' san whijag nan whayugwo'ay atchan. ");
INSERT INTO kyb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Maid kun osas u'umon Ama gwon inatodna an sa'on gway Ana'na nan losanay ayobhonganay mangu'um ");
INSERT INTO kyb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tot chajagwona' san losanay taku as isun nan manchajagwancha an Ama. Ad sa'ad nan achi manchajaw an sa'on gway Ana'na achina kuhos chajagwon as Ama gway nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Iwhaka' an cha'aju nan tuttuwa, nu ngachan nan chumngor san itudtuchu' ja mamati an sija gway nangiwhaun an sa'on, naahus ma'awhijag an Apudyus as ingkaingkana. Achi kun mau'um gwon naahus mataku san otoy ad illukinaay ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iwhaka' an cha'aju nan tuttuwa, umali nan chimpu ad annaja angkay gway hummu'nag gway chongyon chachay natoy nan kingan nan Ana' Apudyus. Ad sa'ad chanan mangngor ja manggwa san iwhakana ma'awhijagcha an sija as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tan sa'ad as Ama sija nan merpugwan nan whijag. Sija nan inggwana hos as sa'on gway Ana'na as merpugwan nan whijag. ");
INSERT INTO kyb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kun inatodna an sa'on gway Ana'na nan ayobhonganay mangu'um kapu tan sa'on nan ngagnoncha Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Achi aju mataag sannaja ingwhaka' an cha'aju tan humu'nag nan chimpuway losan chachay niilhon, chongyoncha nan kinga' ");
INSERT INTO kyb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ad lummagwacha san lohoncha. Ad sa'ad chachay nanggwa san whayu matakucha ad nawhijagchas ingkaingkana gwon sa'ad chachay nanggwa san lagwing matakucha ad nachusacha.” ");
INSERT INTO kyb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kun intuyuy Hesus gway manggwana, “Maid kun ma'gwa' san ugwa'ay ayobhongan. Mangu'uma' ekay san iwhakan Ama an sa'on. Sija nan ustu nan i'aman'uway mangu'um kapu tan wha'on kus anapo' nan whayugwo'ay oon gwon sija oo' nan whayugwon nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Anana hos, “Nu ahusa' as mana'chor san longag'u maid kun mamati san iwhaka'. ");
INSERT INTO kyb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gwon anna as Ama gway mana'chor an sa'on ad akammu'ay tuttuwa nan iwhakana gway mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nangwhaun ajus ummoy an Juan gway manghohonjag kun ingwhakana nan atuttugwaan gway mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wha'on kus maserpu' nan takuway mangipano'no' san mipangkop an sa'on jon iwhaka' ekay nan nangiwhagan Juan an sa'on tot mataku aju. ");
INSERT INTO kyb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mijisu san silaw as Juan gway kukumngot ja pumapadcha kun whinayujuway kanason as sina'itan nan padchana. ");
INSERT INTO kyb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon anna nan mana'chor an sa'onay nangatngatu nu nan nangiwhagan Juan an sa'on. Tan sa'ad nan o'oo' gway inatod Ama an sa'on gway pungpungo', annachajaay o'oo'. Ad annachaja o'oo' nan mangipano'no'ay ingwhauna' an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ad sa'ad as Ama gway nangiwhaun an sa'on sija mismu nan mana'chor san mipangkop an sa'on. Achiju kun chingchingngor nan kingana gwinnu achiju kun ini''ila nan hoserna. ");
INSERT INTO kyb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ad achiju kun iningatan nan ukudna tan achiya' kun tuttugwaon gway ingwhaunna. ");
INSERT INTO kyb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sija ekay achaachayonju nan nilistaay Ukud Apudyus tan ananju kunnu ochasanju sannachaja nan ininonjuway ma'awhijag an Apudyus as ingkaingkana. Gwon annachaja nilistaay Ukud Apudyus nan mangipano'no' san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gwon lagwingonjuway mitunud an sa'on tot ma'awhijag aju otjan an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Wha'on kus anapo' nan manchajagwan chanan taku an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gwon aagkammu' cha'aju ja akammu'ay maid kun lajadju an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ummaliya' kapu san ayobhongan Ama gwon achiya' kun chongyon. Gwon sa'ad nu umali nan sawhali takuway mangiwhaka san ugwanaay ayobhongan, chongyonju. ");
INSERT INTO kyb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sija whayugwonju anapon nan michajagwanju gwon achiju kun anapon nan chajaw gway merpu san osossa''anay Apudyus. Ad ininonju manay mamati an sa'on? ");
INSERT INTO kyb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Achiju ananon sa'on nan mampawhersu an cha'aju an Ama. As Moses nan mampawhersu an cha'aju gway sija nan nangatchanju san namnamaonju. ");
INSERT INTO kyb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tan nu tinuttuwajus Moses tinuttuwaa' otjan kapu tan illistana nan mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gwon kapu tan achiju kun tuttugwaon nan illistana ininonju manay mamati san ukud'u?” ");
INSERT INTO kyb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ummoy as Hesus ja chanan pasuyutna san chomangay tayantag nan Whaywhay gway Galili gway anancha hoson Whaywhay gway Tiberias. ");
INSERT INTO kyb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kun nitunutunud an sija nan amod gway taku kapu tan inilacha chanan mataakan gway inggwana san nangipawhayugwana sasan nasa'it. ");
INSERT INTO kyb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kun nanakacha as Hesus ja chanan pasuyutna san whilig kun tummu'chucha ad achi. ");
INSERT INTO kyb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ad sa'ad san sachi chimpu takangay nan Pijastan chanan Hudyu gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mantollong kus Hesus gwot inilana nan angsanay takuway umoy an sija, anana an Felipe, “Agwan na inta'u malla'uwan as tinapay as ipa'an ta'u sannachaja taku?” ");
INSERT INTO kyb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Gwon ingwhakana na ta padpadchasona imuson as Felipe tan aagkamun Hesus nan oona. ");
INSERT INTO kyb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kun anan Felipe gway summungwhat an sija, “Jo'o umanay nan chugwangkasutay dinario as mila'u san tinapay as ipa'an ta'u an chicha ta'on nu sina''itoncha.” ");
INSERT INTO kyb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Anan nan osa sasan pasuyutna an sija gway as Andres gway sunud Simon Pedro, ");
INSERT INTO kyb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Anna nan osa ana' gway laya'i nansongot as lima tinapajay barley ja chugwa i'an. Jo'o ja umanay na san angsananna taku.” ");
INSERT INTO kyb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kun anan Hesus, “Patu'chugwonju chanan taku.” Ap'api'ap nan sachi agwachancha. Gwot tummu'chu chachay taku gway sa'ad nan whilang nan lallaya'i ekay ummoy as lima lihu. ");
INSERT INTO kyb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gwot inayan Hesus chachay tinapay kun nanjaman an Apudyus gwot impaigwatgwatna sasay taku gway natu'tu'chu. Amaschi ahos nan inggwana say chugwa i'an kun nangan chachay takuwot nan'ugwa'ugwacha. ");
INSERT INTO kyb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nabsugcha kun losan anan Hesus sasay pasuyutna, “Chakuponju chanan nasergwaay napi'pi''i ta aynga.” ");
INSERT INTO kyb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sija nan chinakupcha losan kun pinnucha nan nasagwayan as chugwaay langngay san napi'pi''i limaay tinapay gway barley gway sergwan chachay nangan. ");
INSERT INTO kyb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gwot sa'ad chachay taku san nangilancha san mataakan gway inggwan Hesus anancha, “Tuttuwaay sija chay profeta gway umalid asna luta.” ");
INSERT INTO kyb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gwot sa'ad as Hesus san inakammuna gway umoy chanan taku patuton ayan as sija tot man'aliyoncha, ummoy ummachaju asin san whilig ummoossa. ");
INSERT INTO kyb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mummaschom kun nanosog chachay pasuyutna san whaywhay ");
INSERT INTO kyb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","gway namang'a tot umoycha chumormang ad Capernaum. Hummulingot kun chaan ekas Hesus umchas an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ad sa'ad nan chanum san nanungnin as pigsa ummamamod nan tapiya'na. ");
INSERT INTO kyb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gwot namang'acha kus ummoy as lima gwinnu onomay kilometro inilachas Hesus gway manadchadchayan san lawhaw nan chanum gway umadachayug san whang'a. Kun ummogjatcha. ");
INSERT INTO kyb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gwon anan Hesus an chicha, “Sa'on na. Achi aju umogjat!” ");
INSERT INTO kyb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kun whayugwoncha ekajay mamang'aon as sija san whang'a. Gwot nachanakus nan whang'a san tayantag gway chumormangancha. ");
INSERT INTO kyb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mawhikat kun sa'ad chachay takuway natchay san chomang nan whaywhay, inilachaay maid kun uchum as whang'a ad kallab ad aschi nu achi ahus nan osossa''an. Akammuchaay achi kus Hesus na'awhang'a sasay pasuyutna jon ahus chachay pasuyutna as aysan. ");
INSERT INTO kyb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hummu'nag chanan whang'aay nerpud Tiberias san achani say nanganan chachay taku say tinapay san nappung nan nanjamanan Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sija nan inilan ku chachay takuway maid as Hesus gwinnu chachay pasuyutna, namang'acha kun ummoycha ad Capernaum tot anaponchas Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Inchasancha kun as Hesus san chomang nan whaywhay anancha an sija, “Mistuyu, ma'anu nan ummaliyam ad asna?” ");
INSERT INTO kyb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kun anan Hesus gway summungwhat, “Tuttuwa iwhaka' an cha'aju gway anaanaponjus sa'on wha'on kus kapu san inilaju nan mataakanay inggwa' jon kapu tan nangan aju san tinapay gwot nabsug aju. ");
INSERT INTO kyb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Achiju sija manungayan nan ma'anay mawhangyos jon sija manungayanju nan ma'an gway achi kun mawhangyos gway mangatod as whijag gway maid kun pungpungna gway sa'onay Ana' nan Taku nan mangatod an cha'aju. Tan sa'ad as Apudyus gway Ama sija nan nangakuwher an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gwot inimuscha an sija gway manggwana, “Ngachamma oonmi tot ma'gwami chanan terwhasuway ipa'gwan Apudyus nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kun anan Hesus gway summungwhat, “Annaja nan terwhasuway ipa'gwan Apudyus, tuttugwaonjus sa'on gway ingwhaunna.” ");
INSERT INTO kyb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Sija nan anancha an sija, “Ngachan nan mataakanay oom ta ilanmi ad tinuttuwamis si'a? Ngachan nan oom? ");
INSERT INTO kyb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sa'ad chachay aamma ta'u san agwi nangancha san manna san iniingkagwancha san luta gway maid kun ingkaw as taku. Tan nan nilista san Ukud Apudyus anana, ‘Impa'anna nan tinapajay nerpud langit an chicha.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sija nan anan Hesus an chicha, “Tuttuwa iwhaka' an cha'ajuway wha'on kus Moses nan nangatod an cha'aju san tinapay gway nerpud langit. As Ama nan mangatod an cha'aju san tuttuwa tinapay gway merpud langit. ");
INSERT INTO kyb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tan nan tinapay gway atchon Apudyus sija nan umaliyay merpud langit ad atchona nan whijag sasan taku ad asna luhung.” ");
INSERT INTO kyb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Gwot anancha an sija, “Apu, patinajunay atchan cha'ami sannaja tinapay.” ");
INSERT INTO kyb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Anan Hesus an chicha, “Sa'on nan tinapay gway mangatod san whijag. Nu ngachan nan umali an sa'on achi kun puyus mawhitil ja nu ngachan nan mamati an sa'on achi kun puyus mauwaw. ");
INSERT INTO kyb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naahus'u iwhaka an cha'ajuway inilajus sa'on gwon achi aju ekay mamati. ");
INSERT INTO kyb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Losanay itayo' Ama an sa'on umalicha an sa'on. Ad nu ngachan nan umali an sa'on achi' kun perjagwon. ");
INSERT INTO kyb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kapu tan sija ummaliya'ay nerpud langit nan wha'on kusan oo' nan whayugwo' jon sija oo' nan whayugwon nan nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ad annaja nan whayugwon nan nangiwhaun an sa'on gway losanay intayo'na an sa'on achi' kun taya'on chicha jon takuwo' chicha san anungus nan erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tan annaja nan whayugwon Ama gway sa'ad nan losanay mangakammu an sa'on gway Ana'na ja mamati an sa'on ma'awhijag an Apudyus as ingkaingkana. Ad takuwo' chicha san anungus nan erkaw.” ");
INSERT INTO kyb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sija nan ngummuchu chachay Hudyu san mipangkop an Hesus kapu tan anana, “Sa'on nan tinapay gway nerpud langit.” ");
INSERT INTO kyb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kun anancha, “Jo'o wha'onna an Hesus gway ana' Josep ta. Agakammu ta'u nan amana ja inana. Kunja kanaman ananon, ‘Ad langit nan nerpugwa'’?” ");
INSERT INTO kyb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Anan Hesus an chicha gway summungwhat, “Achi aju asingunguchu. ");
INSERT INTO kyb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maid kun osas ma'aali an sa'on nu wha'on ku an Ama gway nangiwhaun an sa'on nan mangijachayug an sija an sa'on, ad takuwo' as sija san anungus nan erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Illistan chachay profeta gway anana, ‘Losanay taku suyuwan Apudyus chicha’. Losanay manchongor an Ama ja masuyuwan umalicha an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wha'on kus sija pijaona anan nan anna nan nangila an Ama. Tan ahus nan nerpu an Apudyus as nangila an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tuttuwa iwhaka' an cha'aju gway nu ngachan nan mamati an sa'on naahus ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sa'on nan tinapay gway mangatod san whijag. ");
INSERT INTO kyb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sa'ad chachay aammaju nangancha san manna san iniingkagwancha san luta gway maid kun ingkaw as taku kun isuna hos ekajay natoycha. ");
INSERT INTO kyb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Annaja nan tinapay gway nerpud langit gway ngachan ad nan mangan sina achi kun matoy. ");
INSERT INTO kyb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sa'on nan mawhiwhijakay tinapay gway nerpud langit. Nu ngachan nan mangan sannaja tinapay ma'awhijag an Apudyus as ingkaingkana. Ad nannaja tinapay gway atcho' tot mawhijag chanan takud asna luta, longag'u.” ");
INSERT INTO kyb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sija nan naniisi' chanan Hudyu gway manggwana, “Ininonma anu nosaanna taku mangatod san longagna as anon ta'uwa?” ");
INSERT INTO kyb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Gwot anan Hesus an chicha, “Tuttuwa iwhaka' an cha'aju gway nu achiju anon nan longag'u gway Ana' nan Taku ja achiju inumon nan chaya', achi aju kun ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu ngachan nan mangan san longag'u ja uminum san chaya' ma'awhijag an Apudyus as ingkaingkana ad takuwo' asin as sija san anungus nan erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tan nan longag'u sija nan kadto'ay ma'an ja nan chaya' sija nan kadto'ay mainum. ");
INSERT INTO kyb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu ngachan nan mangan san longag'u ja uminum san chaya' ainnugwana an sa'on ad inainnugwa' ahos an sija. ");
INSERT INTO kyb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Ingwhauna' an Ama gway mawhiwhijag ad mawhiwhijaka' ahos kapu tan sija nan manaku an sa'on. Ad isuna hos gway sa'ad nan mangan san longag'u mawhijagcha hos kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Annaja nan tinapay gway nerpud langit gway wha'on kus isun chay inan chachay aammaju kun isuna hos ekajay natoycha. Nan mangan sannaja tinapay ma'awhijag an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Annachaja nan ingwhakan Hesus san nansuyuwana san sinagoga ad Capernaum. ");
INSERT INTO kyb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sija nan angsan ku sasan pasuyutna nan nangngor anancha, “Mansikab nannaja sussuyu. Ngachamma mangngor sina?” ");
INSERT INTO kyb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Inakammun kun Hesus nan nguchunguchugwon chanan pasuyutna anana an chicha, “Adja annaja nan mangijakajanjuway mamati an sa'on? ");
INSERT INTO kyb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kanuyaman nu mailajus sa'on gway Ana' nan Taku gway umoy managkulin ad langit gway sikuchay nerpugwa'? ");
INSERT INTO kyb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nan Ispilitun Apudyus nan mangatod san whijag. Nan longag maid kun kutu' nan o'oona. Sa'ad chachay ingwhakawhaka' an cha'aju nerpucha san Ispilitun Apudyus gway sija nan mangatod san whijag. ");
INSERT INTO kyb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jon anna nan uchum an cha'aju gway achi kun mamati.” Tan sa'ad san chamuchamu aagkammun Hesus chanan achi kun mamati an sija ja aagkammuna nan mangijiwhit an sija. ");
INSERT INTO kyb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kun anana, “Annaja nan kapun nan manggwanaa' an cha'ajuwon maid kun ma'aali an sa'on nu achin Ama paaliyon.” ");
INSERT INTO kyb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Malluki san sachi angsan sasay pasuyutna nan nangijakay kun achicha kun nitunud an sija. ");
INSERT INTO kyb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sija nan anan Hesus sasay nasagwayan as chugwaay pasuyutna, “Adja whayugwonju hosay ijakay?” ");
INSERT INTO kyb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Anan Simon Pedro gway summungwhat, “Apu, ngachamma umajanmi nu'? Agwad an si'a chanan ukud gway mangatod as ma'awhijakan an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ad tuttugwaonmi ja akammumiyay si'a nan maid kun whersuna gway ingwhaun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Anan Hesus an chicha, “Pinili' cha'aju gway nasagwayan as chugwa gwon osa an cha'aju nan ugwan Satanas.” ");
INSERT INTO kyb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sa'ad nan pijaon Hesus iwhaka as Judas gway ana' Simon Iscariote. Tan ta'on nu osas sija sasan nasagwayan as chugwaay pasuyut Hesus, sija nan mangijiwhit an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sachi kun kinagka'ay Hesus nan losanay ili ad Galili. Kinakayanaay achi nangagka'ay ad Judea kapu tan whayugwon chanan papangat nan Hudyu gway otojon as sija. ");
INSERT INTO kyb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kun takangay nan pijastan chanan Hudyu gway ananchaon Pijastan nan Sikay ");
INSERT INTO kyb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","gwot anan nan susunud Hesus gway lallaya'i an sija, “Lumajaw'ad asna ad ummoy'a ad Judea tot sa'ad chanan pasuyutnu ilancha hos chanan mataakan gway o'oom. ");
INSERT INTO kyb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tan maid kun osas mangitayu san oona ad nampawhigwhig as sija sasan taku. Sa'ad tan annachaja nan o'oom ipaakammum nan longagnu san losanay taku san luhung.” ");
INSERT INTO kyb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ama ahos chanan susunudna lallaya'i gway achicha kun tuttugwaon as sija. ");
INSERT INTO kyb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Gwot anan Hesus an chicha, “Chaan kun humu'nag nan chimpu'. Gwon sa'ad as cha'aju mawhalinay whayangna nan chimpuway umajanju. ");
INSERT INTO kyb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Maid kun kapun nan mangisilan chanan takud asna luta an cha'aju gwon isilonchas sa'on kapu tan iwhakawhaka' nan lagwing gway o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cha'aju ekay umoy ma'apijasta. Achiya' kun umali sannaja pijasta tan sa'ad nan chimpu' chaan kun humu'nag.” ");
INSERT INTO kyb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ingwhakana kunan sachi natchay as sija ad Galili. ");
INSERT INTO kyb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gwon naahus kun lummungud chachay susunudnaay ummoy na'apijasta nisu'nub ahos as sija jon achi kun nampaki'na. ");
INSERT INTO kyb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gwot sa'ad chanan papangat nan Hudyu anaanaponchas Hesus san sachi pijasta kun anancha, “Agwan nan agwad na sachi taku?” ");
INSERT INTO kyb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kun asingunguchucha san mipangkop an sija nan angsan sasay takuway naayus. Anan nan uchum an chicha, “Whayuway taku as sija.” Gwon anan nan uchum, “Wha'on, allilagwona chanan taku!” ");
INSERT INTO kyb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gwon maid kun nangipagngor gway nanukud san mipangkop an Hesus tan umogjatcha sasan papangat nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Anna kunay mangkikinagwa nan pijasta ummoy as Hesus san sowhan nan Templo kun illukinaay mansuyu. ");
INSERT INTO kyb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sija nan nataag chachay papangat nan Hudyuway manggwana, “Agwamma anu nangallan nina san laingna tan achi kayna nasuyuwan san lintog ja?” ");
INSERT INTO kyb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Gwot anan Hesus gway summungwhat an chicha, “Nan sussuyu' wha'on kus nerpu an sa'on jon nerpu san nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu ngachan nan mamayuway manggwa san whayugwon Apudyus maakammugwana nan mipangkop san sussuyu' nu nerpu an Apudyus gwinnu nerpu ekay san ugwa'ay somsomo'. ");
INSERT INTO kyb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nan takuway isuyuna nan merpu ekay san ugwanaay somsomo' sija anapona nan michajagwana. Gwon nan takuway sija anapona nan michajagwan nan nangiwhaun an sija iwhakana nan tuttuwa ja achi kun mantuli. ");
INSERT INTO kyb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Jo'o achin Moses inatod an cha'aju nan lintog? Gwon maid kun chumngor an cha'aju san lintog. Kunja kajuman whayugwonay otojon as sa'on nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kun anan chachay takuway summungwhat, “Annat an si'a nan chimunju! Ngachamma mamayuway mangtoy an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Anan Hesus gway summungwhat an chicha, “Nanggwaa' as osaay mataakan kun losan aju nataag. ");
INSERT INTO kyb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ingwhilin Moses an cha'ajuway mansuglit aju kun chinumngor aju uyay san Erkaw gway Umillongan (ta'on nu wha'on ku an Moses nan nangiluki jon chachay aammaju). ");
INSERT INTO kyb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nu mijujaay masuglitan nan ana' san Erkaw gway Umillongan tot achi mayabsing nan lintog Moses, ka'aju malingu an sa'on san impawhayu' nan osa taku san Erkaw gway Umillongan? ");
INSERT INTO kyb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Achi aju mangu'um kapu san mailaju jon mangu'um aju kapu san tuttuwa.” ");
INSERT INTO kyb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gwot sachi kun anan nan uchumay iJerusalem, “Jo'o wha'onna say takuway whayugwoncha otojon? ");
INSERT INTO kyb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gwon ilanju! Annatchaay manukuukud ekay as sija sasan taku gwon maid kun anancha an sija. Tugwakay akammun chanan papangat ta'u gway sija nan Kristu? ");
INSERT INTO kyb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jon sa'ad nannaja taku akammu ta'u nan nerpugwana. Gwon sa'ad nu umali nan Kristu maid kun mangakammu nu agwan nan merpugwana.” ");
INSERT INTO kyb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sachi kun sa'ad san nansuyusuyuwan Hesus san sowhan nan Templo tinowhagna nan kingana gway manggwana, “Ananjuwon akammujus sa'on ja akammuju nan nerpugwa'. Wha'on kus ummaliya' ad asna kapu san ugwa'ay somsomo' jon tuttuwa as sija gway nangiwhaun an sa'on gway achiju kun akammu. ");
INSERT INTO kyb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Akammu' as sija kapu tan nerpuwa' an sija ja sija nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sija nan pinachaschaay chopapon as sija gwon maid kun nangognan an sija tan chaan ku humu'nag nan chimpuna. ");
INSERT INTO kyb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gwon ta'on nu amaschi angsan sasan taku nan namati an sija kun anancha, “Nu umali nan Kristu ad ma'a'gwa san amod pay gway mataakanay o'oon nannaja taku?” ");
INSERT INTO kyb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chingngorn chanan Pariseo chanan taku gway ngumuchunguchu san mipangkop an Hesus. Kun whinaun chachay papangat nan papachi ja chachay Pariseo chanan mangijaachug san Templo tot umoycha chopapon as sija. ");
INSERT INTO kyb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gwot anan Hesus, “Sina'itanay chimpu nan iingkagwa' an cha'aju ad asiya'ot umoy managkulin san nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Anaponjus sa'on gwon achi aju kun ma'a'chas an sa'on ad nan umaja' achi aju kun ma'aali.” ");
INSERT INTO kyb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sija nan asi'a'anan chachay papangat nan Hudyu, “Agwamma anu ajan nan osaanna taku gway achi ta'u kun ma'a'chas an sija? Umoy ninas sija sasan ailijan ta'uway nasibsibta' san ilin chanan Griego tot suyuwana chanan iGriego? ");
INSERT INTO kyb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngachan nan pijaona anan chay ananaon, ‘Anapona' gwon achi aju kun ma'a'chas an sa'on’ ja ‘Nan umaja' achi aju kun ma'aali’?” ");
INSERT INTO kyb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Anungus kunan erkaw nan Pijasta gway sija nan apatkanay erkawna, summi'ad as Hesus kun tinowhagnaay manggwana, “Nu ngachan nan mauwaw umali an sa'on ad umminum. ");
INSERT INTO kyb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tan nilista san Ukud Apudyus gway anana, ‘Nu ngachan nan mamati an sa'on agwad an sija nan mangatod as whijag gway isun nan chanum gway umajaajus gway nerpu san obob.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sa'ad chay ingwhakan Hesus sachi nan mipangkop san Ispilitun Apudyus gway maayan chachay namati an sija. Gwon chaan kun maatod nan Ispilitun Apudyus tan chaan kunan managkulinan Hesus ad langit gway michajagwana. ");
INSERT INTO kyb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gwot chingngorn ku chanan uchumay taku nan ingwhakan Hesus anan chanan uchum an chicha, “Sa'ad nannaja taku tuttuwaay sija chay profetan Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Anan nan uchum, “Sija nan Kristu!” Gwon anan nan uchum, “Wha'on kunad Galili nan merpugwan nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jo'o achi nilista san Ukud Apudyus gway sa'ad nan Kristu merpu san kana' Dabid ja mijana' ad Betlehem gway ilin Dabid?” ");
INSERT INTO kyb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sija nan wha'on kus naninnayaan chanan taku kapu an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ad nan uchum an chicha whayugwoncha chopapon as Hesus jon maid kun osas nanpap an sija. ");
INSERT INTO kyb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gwot nanagkulin chachay mangijaachug san Templo sasan papangat nan papachi ja chachay Pariseo. Kun anan chachay papangat nan papachi ja chachay Pariseo, “Kaju achi iyalis sija ad asna?” ");
INSERT INTO kyb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Anan chachay mangijaachug san Templo gway summungwhat, “Maid kun nanukud as isun nan iyu''ukud nan sachi taku!” ");
INSERT INTO kyb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Gwot anan chachay Pariseo gway summungwhat an chicha, “Adja inallilawna hos cha'aju? ");
INSERT INTO kyb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jo'o agwad namati an cha'amiyay papangatju gwinnu chanan Pariseo an sija ta? ");
INSERT INTO kyb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jon sa'ad nannachaja takuway maid kun akammucha san Lintog gway inatod Apudyus an Moses naahuscha machusa.” ");
INSERT INTO kyb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ad sa'ad as Nicodemo gway huyunchaay Pariseo gway ummoy na'aapapat an Hesus san nugwan, anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sa'ad nan lintog ta'u achi ta'u kun mawhalinay u'umon nan osa taku nu chaan ta'u chongyon nan iwhakana ja maakammugwan nu ngachan nan inggwana.” ");
INSERT INTO kyb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kun ananchaay summungwhat an sija, “Jo'o iGalili'a hos ta? Anapom san Ukud Apudyus ad inilam gway maid kun merpud Galili as profeta.” ");
INSERT INTO kyb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sachi kun nansississiyanchaay lummajaw. ");
INSERT INTO kyb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lummajaw kunan losanay taku san nansuyuwan Hesus san Templo ummoy as Hesus san Whilig gway Olibu. ");
INSERT INTO kyb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mawhikat kusan gwisnigwisnit ummoy as Hesus asin san sowhan nan Templo. Kun angsanay taku nan ummoy an sija gwot tummu'chuway nansuyu an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kun iyoy chanan mangaagkammu san lintog ja chanan Pariseo nan osa huwhaiyay na'chasan gway na'assuy san wha'on kus asagwana. Kun impasi'adcha san sangun chanan taku. ");
INSERT INTO kyb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kun anancha an Hesus, “Mistuyu, sa'ad nannaja huwhai nadpap gway na'assuy san wha'on kus asagwana. ");
INSERT INTO kyb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ad san lintog ta'u ingwhilin Moses gway maserpuway mawhinwhintug nan a'ammasnatay huwhai ingkanas matoy. Ad as si'a ngachamma anam sichi?” ");
INSERT INTO kyb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Amaschi nan ingwhakacha ta si'apanchas Hesus tot agwad lagwa ipawhersucha an sija. Gwon as Hesus nayyu'ung gway nallista san luta gway inuserna nan kammatna. ");
INSERT INTO kyb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Assi'assinoncha kunay manimus an Hesus summi'ad as sija kun anana an chicha, “Sa'ad nan maid whersuna an cha'aju sija nan umuna mamintug sannaja huwhai.” ");
INSERT INTO kyb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kun asin ahos nayyu'ung as sija gway nallista san luta. ");
INSERT INTO kyb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ad sa'ad san nangngoyancha san sachi nasinnossachaay aysan gway iyununan chanan chacha''or an chicha. Kun ahus as Hesus as natchay ja chay huwhaiyay summisi'ad san sanguna. ");
INSERT INTO kyb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kun summi'ad as Hesus gwot anana an sija, “Umman chachi? Ad maid osas nanusa an si'a?” ");
INSERT INTO kyb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kun anan chay huwhai, “Maid kun, Apu.” Kun anan Hesus, “Uyay as sa'on achi' kun si'a chusaon. I'a ad mallukis sana ijakaynuway ma'awhersu.” ");
INSERT INTO kyb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gwot inasin Hesus iyagwat sasan taku gway manggwana, “Sa'on nan silaw nan luhung. Nu ngachan nan mitunud an sa'on achi kun puyus manadchayan san manghulingot jon agwad an sija nan silaw gway mangatod san whijag.” ");
INSERT INTO kyb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Gwot anan chachay Pariseo an sija, “Si'a ekay nan mangita'chor san longagnu, nan iwhakawhakamannat wha'on kus atuttugwaan.” ");
INSERT INTO kyb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kun anan Hesus gway summungwhat, “Ta'on nu sa'on nan mangita'chor san longag'u tuttuwa nan iwhakawhaka' tan akammu' nan nerpugwa' ja umaja'. Gwon sa'ad as cha'aju achiju kun akammu nan nerpugwa' ja umaja'. ");
INSERT INTO kyb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mangu'um aju kapu san mailaju. Maid kun u'umo' as osa. ");
INSERT INTO kyb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gwon ta'on nu mangu'uma' ustu nan i'aman'uway mangu'um tan wha'on kus ahusa' as mangu'um jon huyun'us Ama gway nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ad san lintogju nilista gway sa'ad nu manisu nan anan nan chugwa taku miwhilang gway tuttuwa. ");
INSERT INTO kyb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sa'on nan mana'chor san mipangkop san longag'u ja ta'choyana' ahos an Ama gway nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sija nan anancha an Hesus, “Agwan nan agwad Amam?” Anan Hesus gway summungwhat, “Achiju kun akammus sa'on ja achiju kun akammu nan Ama'. Sa'ad otjan nu akammujus sa'on akammuju hos nan Ama'.” ");
INSERT INTO kyb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ingwhakan Hesus nannachaja san nansuyuwana san achani san agwachan nan mangiigkaanchas pila' san Templo. Gwon maid kun jan nanpap an sija tan chaan kunan chimpuna. ");
INSERT INTO kyb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Gwot asinona hos anan an chicha, “Humu'nag nan chimpuway lumajagwa' ad inanapjus sa'on gwon matoy aju gway achi kun ma'aan nan whersuju. Achi aju kun ma'aali san umaja'.” ");
INSERT INTO kyb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Gwot anan chachay papangat nan Hudyu, “Jo'o anu otojona nan longagna ta? Kapu tan ananaon, ‘Nan umaja' achi aju kun ma'aali.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kun anan Hesus an chicha, “Nerpu aju san luta, nerpuwa' ad langit. Iluta aju, wha'ona' kus iluta. ");
INSERT INTO kyb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sija nan ingwhaka' an cha'ajuway matoy aju gway achi kun ma'aan chanan whersuju. Tan nu achiju tuttugwaon gway sa'on chay ingwhaka' matoy aju gway achi kun ma'aan chanan whersuju.” ");
INSERT INTO kyb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Gwot anancha an sija, “Ngachan'a nu'?” Anan Hesus an chicha, “Chay ingwhaka' an cha'aju san chamchamu. ");
INSERT INTO kyb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Angsan nan maiwhaka' ja mau'um'u san mipangkop an cha'aju. Jon sa'ad as sija gway nangiwhaun an sa'on kadto' nan iwhagwhakana ad as sa'on, nu ngachan ekay chingngor' an sija iwhaka' sasan takud asna luta.” ");
INSERT INTO kyb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Achicha kun naagwatanay sa'ad nan ingwhakana an chicha mipangkop an Amana. ");
INSERT INTO kyb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sija nan anan Hesus an chicha, “Sa'ad nu iwhajugjus sa'on gway Ana' nan Taku maakammugwanjuway sa'on chay ingwhaka' ja wha'on kus ma'gwa' nan oo' san ugwa'ay ayobhongan jon sija yakay iwhaka' nan intudtuchun Ama an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ad nan nangiwhaun an sa'on iingkaw an sa'on. Achina kun tinaynan as sa'on kapu tan patinajunay oo' nan masomana.” ");
INSERT INTO kyb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sa'ad san mangiwhagawhagana sannachaja angsan nan namati an sija. ");
INSERT INTO kyb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Gwot anan Hesus sasay Hudyuway namati an sija, “Nu ituttuttuyuyjuway patiyon nan sussuyu' cha'aju nan kadto'ay pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ad maakammugwanju nan atuttugwaan ad nan atuttugwaan sachi nan mawwajagwaja an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Anancha gway summungwhat an sija, “Kana' cha'ami an Abraham ad maid kun nammudchachu an cha'ami. Ngachan nan manggwanaamon magwajagwajaan ami?” ");
INSERT INTO kyb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Anan Hesus gway summungwhat an chicha, “Tuttuwa iwhaka' an cha'ajuway nu ngachan nan ma'awhersu mudchachun nan whersu as sija. ");
INSERT INTO kyb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sa'ad nan mudchachu wha'on kus mi'ahumerjan san simmudchachu an sija as ingkaingkana. Gwon nan ana' nan singhoyoy mi'ahumerjan as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sija nan nu gwajagwajaan cha'aju san Ana' Apudyus kadto'ay magwajagwajaan aju. ");
INSERT INTO kyb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Akammu'ay kana' Abraham cha'aju. Jon whayugwonjuway otojon as sa'on kapu tan achiju kun ingatan nan sussuyu'. ");
INSERT INTO kyb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sa'ad as sa'on iwhaka' nan inila' an Ama ad as cha'aju sija oonju nan chingngorju an amaju.” ");
INSERT INTO kyb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ananchaay summungwhat an sija, “Sa'ad nan amami as Abraham.” Anan Hesus an chicha, “Nu kana' cha'aju an Abraham oonju otjan nan inggwana. ");
INSERT INTO kyb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gwon san sana whayugwonjuway otojon as sa'on gway nangiwhaka an cha'aju san atuttugwaan gway chingngor' an Apudyus. Achin ku Abraham inggwa nan amasna. ");
INSERT INTO kyb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sa'ad as cha'aju o'oonju nan inggwan amaju.” Sija nan anancha an sija, “Wha'on ami kus nijana' as agkawha'. Osossa''an nan Amami gway as Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Anan Hesus an chicha, “Nu Apudyus nan Amaju ipatoka' otjan tan nerpuwa' an Apudyus ad annaa' ad asna san sana. Wha'on kus ummaliya' san ugwa'ay ayobhongan jon Apudyus nan nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kaju achi maagwatan nan iwhakawhaka'? Aysaan achiju kun iningatan nan sussuyu'. ");
INSERT INTO kyb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nerpu aju san amaju gway Satanas ad nan whayugwon amaju, whayugwonju oon. Pumapatoy as sija san chamu ja maid kun manggwaana san atuttugwaan kapu tan maid kun atuttugwaan an sija. Sa'ad nu mantuli mijunun san ukalinaay tuliyan kapu tan tuliyan as sija ja sija nan nerpugwan nan tuli. ");
INSERT INTO kyb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gwon sa'ad as sa'on kapu tan atuttugwaan nan iwhaka' achiju kun tuttugwaon as sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngachanna an cha'aju nan mangiwhaka gway na'awhersuwa'? Nu atuttugwaan nan iwhaka' kaju achi tuttugwaon as sa'on? ");
INSERT INTO kyb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sa'ad nan nerpu an Apudyus chongyona nan iwhakan Apudyus. Nan kapun nan achiju manchongyan wha'on aju kus nerpu an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Anan chachay Hudyuway summungwhat an Hesus, “Ad achi tuttuwa nan ananmiyon iSamaria'a ja annat nan chimunju an si'a?” ");
INSERT INTO kyb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Anan Hesus gway summungwhat, “Maid kun chimunju an sa'on. Jon chajagwo' as Ama ad sa'ad as cha'aju achiju kun chajagwon as sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wha'on kus anapo' nan michajagwa' gwon agwad nan manganap san michajagwa' ja sija nan mangu'um. ");
INSERT INTO kyb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tuttuwa iwhaka' an cha'ajuway nu ngachan nan chumngor san sussuyu' achi kun puyus matoy.” ");
INSERT INTO kyb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Gwot anan chachay Hudyu an sija, “Naakammugwanmi tuwaay annat nan chimunju an si'a! Natoy as Abraham ja natoy ahos chachay profeta kunja anamon nu ngachan nan chumngor san sussuyum achi kun puyus matoy. ");
INSERT INTO kyb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jo'o nangatngatu'a san nerpugwanmi gway Abraham ta? Natoy as sija ja natoy ahos chachay profeta san agwi. Adja ngachamma anam san longagnu?” ");
INSERT INTO kyb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Anan Hesus gway summungwhat, “Nu ichajaw'u nan longag'u maid kun kutu' nan chajaw'u. As Ama nan mangichajaw an sa'on gway chay ananjuwon sija nan Apudyusju. ");
INSERT INTO kyb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Achiju kun agakammus sija gwon akammu' as sija. Nu ana'on achi' kun akammus sija isu' as cha'aju gway tuliyan. Jon akammu' as sija ja chumngorra' san iwhakana. ");
INSERT INTO kyb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sa'ad as Abraham gway nerpugwanju nallaylajad gway mangila san umaliya' ad asna. Gwot inilana kun nayagsa'an as sija.” ");
INSERT INTO kyb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sija nan anan chachay Hudyu an sija, “Chaan kun malimampuyu nan tagwonnu kunja inilam as Abraham?” ");
INSERT INTO kyb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Anan Hesus an chicha, “Tuttuwa iwhaka' an cha'ajuway san chaan Abraham mijana'an agwacha'.” ");
INSERT INTO kyb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sachi kun nampichit chachay taku san whatu tot whintukoncha as Hesus. Gwon sa'ad as sija nallinus kun lummajaw san Templo. ");
INSERT INTO kyb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sa'ad san manadchadchayanan Hesus inilana nan osa laya'i gway sikuchay na'uyap san nijana'ana. ");
INSERT INTO kyb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kun inimus chachay pasuyutna an sija gway manggwana, “Mistuyu, ngachan nan singwhersu annaja taku gwinnu chanan sinana' an sija nan singwhersu san nijana'ana gway na'uyap?” ");
INSERT INTO kyb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Anan Hesus gway summungwhat, “Wha'on kus whersun nannaja taku gwinnu whersun nan sinana' an sija jon na'gwa nannaja ta mipaila nan mataakanay oon Apudyus an sija. ");
INSERT INTO kyb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Maserpu oon ta'u nan ipa'gwan nan nangiwhaun an sa'on san apadchaana tan lumawhi ad maid kun osas mawhalinay manterwhasu. ");
INSERT INTO kyb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sa'ad sannaay agwacha' ad asna luta sa'on nan silaw gway mamadcha san somsomo' chanan taku ad asna luta.” ");
INSERT INTO kyb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ingwhakan kun Hesus nan sachi tummubwha san luta kun impilutna gwot asinaot ijapyus nan pijo' san atan chay na'uyap. ");
INSERT INTO kyb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kun anana an sija, “I'a mancherrup san pu'ung ad Siloe.” (Nan pijaona anan nan Siloe, niwhaun.) Gwot ummoy nancherrup chay na'uyap kun lummajaw gway anna nan ilana. ");
INSERT INTO kyb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sija nan sa'ad chachay cherragna ja chachay takuway nangila an sija san nugwan gway sija chay mampalpalimus, anancha, “Annaja kay nin chay takuway umoy tumu'chutu'chu mampalimus ja?” ");
INSERT INTO kyb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Anan nan uchum, “Sija!” Anan ahos nan uchum, “Wha'on kus sija jon ahoshosayana ekay!” Anan chay laya'i, “Sa'on chiya.” ");
INSERT INTO kyb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Gwot anancha an sija, “Kaman anna nan ilam san sana nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Anan chay laya'iyay summungwhat, “Sa'ad chay osa takuway ananchaon Hesus impilutna nan tubwhana san luta kun asinaot ijapyus san ata'. Kun anana an sa'on, ‘I'a ad Siloe ad nancherrup'a’. Gwot ummoja' kun nancherrup maag ekay anna nan ila'.” ");
INSERT INTO kyb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kun anancha an sija, “Agwan nan agwadna?” Anana, “Maid kun akammu'.” ");
INSERT INTO kyb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sachi kun iyoychas sija sasan Pariseo. ");
INSERT INTO kyb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Erkaw gway Umillongan nan sachi erkaw gway nampilutan Hesus san pijo' ja nangaanana san uyapna. ");
INSERT INTO kyb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Gwot inimus ahos asin chanan Pariseo chay laya'i nu ininonaay maag ekay anna ilana. Kun anana an chicha, “Iyapyusna nan pijo' san ata' kun ummoja' nancherrup gwot maag ekay anna nan ila'.” ");
INSERT INTO kyb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Gwot anan nan uchumay Pariseo, “Sa'ad nan sachi taku wha'on kus nerpu an Apudyus kapu tan achi kun chumngor san Erkaw gway Umillongan.” Gwon anan ahos nan uchum, “Ininon nan osa taku humersuwhersu gway manggwa san a'ammasnaay mataakan?” Kun achicha kun naninnayaan. ");
INSERT INTO kyb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Gwot inasin chachay Pariseo anan say na'aan nan uyapna, “Ngachan nan anam san mipangkop an sija kapu tan inaanna nan uyapnu?” Kun anan chay laya'i, “Profeta as sija.” ");
INSERT INTO kyb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gwon sa'ad chachay papangat nan Hudyu achicha kun tuttugwaonay sikuchay na'uyap as sija ja anna nan ilana san sana ingkanas impaajagcha nan sinana' an sija. ");
INSERT INTO kyb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kun inimuscha an chicha gway manggwana, “Ana'ju nannaja gway ananjuwon sikuchay na'uyap san nijana'ana? Kunja kaman anna ilana san sana nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Gwot anan chachay sinana' gway summungwhat, “Akammumiyay sa'ad nannaja taku ana'mi ja nijana' as sija gway na'uyap. ");
INSERT INTO kyb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gwon nan ininon nan uyapnaay na'aan gwinnu nu ngachan nan nangaan san uyapna, achimi kun akammu. Imusonjus sija tan naangsan. Sija ekay kuminga.” ");
INSERT INTO kyb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Amaschi nan ingwhakan nan sinana' say laya'i tan ummogjatcha sasan papangat nan Hudyu tan naahuscha nanuukuchan gway nu ngachan nan mamati an Hesus gway sija nan Mesias, maperjaw san sinagoga. ");
INSERT INTO kyb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sija nan anan nan sinana' an sija, “Naangsan as sija, imusonju ekay an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gwot inajakancha asin chay na'aan nan uyapna kun anancha an sija, “Isapatam an Apudyus gway iwhakam nan tuttuwa. Akammumiyay sa'ad nan sachi taku humersuwhersu.” ");
INSERT INTO kyb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sija nan anan chay laya'i gway summungwhat, “Nu humersuwhersus sija achi' kun akammu. Nan ahus yakajay akammu' na'uyapa' san nugwan ad san sana anna nan ila'.” ");
INSERT INTO kyb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Gwot anancha an sija, “Ngachan nan inggwana an si'a? Ininonaay nangaan san uyapnu?” ");
INSERT INTO kyb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Anana gway summungwhat an chicha, “Naahus'u iwhaka an cha'aju kun achiju kun tuttugwaon. Kunja kaju asinon chongyon? Jo'o whayugwonju hosay mangngachan pasuyutna?” ");
INSERT INTO kyb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kun inana'ananchas sija gway manggwana, “Si'a nan pasuyut nan sachi taku gwon cha'ami nan pasuyut Moses. ");
INSERT INTO kyb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Akammumiyay na'aapapat as Apudyus an Moses gwon na sachi taku achimi kun akammu nu agwan nan naliggwatana.” ");
INSERT INTO kyb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Anan chay laya'i an chicha gway summungwhat, “Sanat tuwa nan mataakanta gway achiju kun akammu nu agwan nan naliggwatana gwon inaanna nan uyap'u. ");
INSERT INTO kyb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Akammu ta'uway sa'ad chanan humersuwhersu achin ku Apudyus chongyon chicha. Sa'ad nan manchajaw an Apudyus ja manggwa san whayugwona pa'gwa chongyon Apudyus as sija. ");
INSERT INTO kyb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Malluki san na'gwaan nan luhung maid kun nagngor as nangigkat san atan nan takuway nijana'ay na'uyap. ");
INSERT INTO kyb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu wha'on kus nerpu nan sachi taku an Apudyus achina otjan ma'gwa nan amasna.” ");
INSERT INTO kyb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Anancha an sija gway summungwhat, “Humersuwhersu'a manipud san nijana'am kunja ka cha'amiyot nan tudtuchugwam?” Sachi kun pinerjawchas sija san sinagoga. ");
INSERT INTO kyb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chingngorn Hesus gway pinerjawcha chay laya'i kun inchasanaot anana an sija, “Ad tuttugwaom nan Ana' nan Taku?” ");
INSERT INTO kyb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kun anan chay laya'i gway summungwhat, “Ngachan nichi, Apu, tot tuttugwao' as sija?” ");
INSERT INTO kyb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Anan Hesus an sija, “Inilam as sija ja sija nannaja ma'aapaapat an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kun anan chay laya'i, “Tuttugwao' si'a, Apu!” Kun nanchajaw an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kun anan Hesus, “Ummaliya' ad asna luta ta u'umo' chanan taku tot sa'ad chanan na'uyap atcha' chichas ilancha ja sa'ad chanan anna ilana mangngachancha na'uyap.” ");
INSERT INTO kyb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kun chingngorn nan uchumay Pariseo gway agwad san sachi agwachan Hesus kun anancha an sija, “Adja sija anam nan na'uyap ami hos?” ");
INSERT INTO kyb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Anan Hesus an chicha, “Nu na'uyap aju maid otjan humasuyanju. Gwon sa'ad tan ananjuwon anna nan ilanju sissija nan whersuju gway sachi nan nanguyap an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kun iyagwat Hesus gway manggwana, “Iwhaka' an cha'aju nan tuttuwa, nan takuway achi kun mangoy san sagwang nan pu'u' chanan kernero gway sawhali nan mangojana manaa'aw ja mamayangkat. ");
INSERT INTO kyb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gwon sa'ad nan takuway mangoy san sagwang sija nan mampaspastur sasan kernero. ");
INSERT INTO kyb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ad sa'ad as sija igkat nan mangijaachug san sagwang nan lumno'ana. Ad imatunan chanan kernero nan kingana. Ad pin'agwana chanan kernerona sasan ngachancha ad illagwana chicha. ");
INSERT INTO kyb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ad sa'ad nu illagwana losan chanan kernerona sija nan mangipangu an chicha ad nitunudcha an sija kapu tan aagkammucha nan kingana. ");
INSERT INTO kyb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Achicha kun mitunud san sawhali gwon umagwidcha an sija tan wha'on kus maimatunancha nan kingana.” ");
INSERT INTO kyb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iyagwat Hesus nannaja an chicha gwon achicha kun naagwatan nan ingwhakana an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sija nan iyagwat Hesus asin an chicha gway manggwana, “Iwhaka' an cha'aju nan tuttuwa, sa'on nan sagwang gway mangojan chanan kernero. ");
INSERT INTO kyb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Losanay ummuna an sa'on chicha chachay manaa'aw ja mamayangkat jon achin ku chanan kernero chongyon chicha. ");
INSERT INTO kyb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sa'on nan sagwang. Nu ngachan nan mangoy an sa'on mataku, isun nan kernero gway lumno' ja lumagwa ad nangchas as manayawhana. ");
INSERT INTO kyb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nan manaa'aw sija ekay pangkopna nan umoy mana'aw ja pumatoy ancha mantangka. Ummaliya' gway mangatod as whijag gway maid kun man'uyangana. ");
INSERT INTO kyb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sa'on nan whayuway mampaspastur sasan kernero. Sa'ad nan whayuway mampaspastur sasan kernero aatchona nan whijagna kapu sasan kernerona. ");
INSERT INTO kyb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nan mayabhuwan gway wha'on kus kadto'ay mampaspastur wha'on kus sija nan sin'ugwa sasan kernero. Ilana ad nan atap gway ajam gway umawhat taynana chanan kernerona ad iyagwidna. Ad chinogchog nan atap gway ajam chanan kernero ad nasibsibta'cha. ");
INSERT INTO kyb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Umagwid chay mayabhuwan tan mallabhu yakay as sija ja maid kun whijangnaay mangipatog sasan kernero. ");
INSERT INTO kyb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sa'on nan whayuway mampaspastur ad aagkammu' chanan kernero' ja aagkammuwa' an chicha, ");
INSERT INTO kyb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","isun nan mangaagkammugwan Ama an sa'on ja mangaagkammugwa' an Ama. Ad aatcho' nan whijag'u kapu sasan kernero. ");
INSERT INTO kyb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ad agwad ahos nan uchumay kernero' gway maid kun sannajaay naamung. Maserpu hosay ajaka' chicha. Ad chongyoncha nan kinga' ad nanamungcha as osossa''an ad osa nan mampaspastur an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Sija nan ipatpatoka' an Ama kapu tan aatcho' nan whijag'u tot asin'u pagkulinon. ");
INSERT INTO kyb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maid kun ma'aaya san whijag'u jon ugway'u eka mangatod. Anna nan ayobhonga' gway mangatod san whijag'u ja anna ahos nan ayobhonga' gway asin mangipagkulin. Annaja nan ingwhilin Ama an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kun achi kuhos naninnayaan chachay Hudyu kapu san annachajaay ingwhakan Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kun angsan an chicha nan manggwana, “Agwad nan chimunju an sija ja nayapang as sija. Kajuman chongyon as sija!” ");
INSERT INTO kyb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anan nan uchum, “Wha'on kus amasna nan ukuchon nan nachimunjugwan. Jo'o ma'a'aan nan chimunju san uyap nan na'uyap?” ");
INSERT INTO kyb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gwot niwhatug nan Pijasta gway ma'gwaniyon Nangichatunancha san Templo ad Jerusalem san chimpun nan amiyan ");
INSERT INTO kyb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","kun ummoy nangkagka'ay as Hesus san sowhan nan Templo gway ma'gwaniyon Abwhawhang Solomon. ");
INSERT INTO kyb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Gwot whinaligwonggwongan chanan Hudyu as sija kun anancha an sija, “Ma'anu man ekay asim mangiwhagan an cha'ami san mipangkop an si'a? Nu si'a nan Kristu iwhawhagkam an cha'ami.” ");
INSERT INTO kyb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Anan Hesus gway summungwhat an chicha, “Naahus'u iwhaka an cha'aju gwon achiju kun tuttugwaon. Sa'ad chanan o'oo' kapu san ayobhongan Ama chachi nan mangipano'no' san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jon achiju kun tuttugwaon kapu tan wha'on kus kernero' cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sa'ad chanan kernero' chongyoncha nan kinga'. Aagkammu' chicha ja tunuchona' an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ad atcho' an chicha nan whijag gway maid kun pungpungna ad achicha kun misiyan an Apudyus as ingkaingkana ja maid kun ma'apyos an chicha an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sa'ad as Ama gway nangitayo' an chicha an sa'on nangatngatu san losan. Ad maid kun ma'apyos an chicha an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sa'ad as sa'on ja as Ama osossa''an ami.” ");
INSERT INTO kyb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Asin nampichit chanan Hudyu sasan whatu tot whintukoncha as sija. ");
INSERT INTO kyb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Anan Hesus an chicha, “Angsan nan impaila' an cha'aju gway whayuway impa'gwan Ama an sa'on. Ad ngachanna sannachaja inggwa' nan kapun nan mamintukanju an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Anan chachay Hudyu gway summungwhat, “Wha'on kusan whayuway inggwam nan mamintukanmi an si'a jon kapu san ingwhakamay maamamangan Apudyus. Kapu tan sa'ad as si'a gway kakangayna ekajay taku mangngadnom nan longagnu Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Anan Hesus gway summungwhat an chicha, “Jo'o achi nilista san Lintogju gway anan Apudyus, ‘Sa'ad as cha'aju apudyus aju.’ ");
INSERT INTO kyb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nu apudyus nan iyagwag Apudyus an chichaay nangiwhagana san ukudna akammu ta'uway sa'ad nan nilistaay Ukud Apudyus achi kun mabos. ");
INSERT INTO kyb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kunja kaju anan an sa'onon naawhersu'a san whersuway maamamangan Apudyus san ana'on ‘Sa'on nan Ana' Apudyus’? ");
INSERT INTO kyb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu achi' oon nan terwhasun Ama gway ipa'gwana an sa'on achiju tuttugwaon as sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gwon nu oo' nan terwhasun Ama ta'on nu achiju tuttugwaon as sa'on, tuttugwaonju otjan chanan inggwa' tot maakammugwanju ja maagwatanjuway anna as Ama an sa'on ja agwacha' an Ama.” ");
INSERT INTO kyb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sija nan asincha otjan chopapon as Hesus gwon nallinus an chicha kun aysan. ");
INSERT INTO kyb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Gwot nanagkulin asin as Hesus san chomang nan gwanggwangay Jordan san ikaw gway nanghonjahonjakan Juan san chamu. Kun iningkaw as sija ad aschi. ");
INSERT INTO kyb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ad angsanay taku nan ummoy an sija. Kun asi'a'anancha, “Maid kun inggwan Juan gway Manghohonjag as mataakan gwon losanay ingwhakan Juan gway mipangkop sannaja taku tuttuwa.” ");
INSERT INTO kyb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gwot angsan nan namati an Hesus ad aschi. ");
INSERT INTO kyb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iningkaw nan osa laya'iyay nasa'it gway Lazaro nan ngachanna gway iBetania. Nan Betania ilin ahos cha Maria an Marta gway susunudna. ");
INSERT INTO kyb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ad sa'ad as Maria anna sunudna sija chay nangihu'hu' san whangwhangyu san i'in Apu Hesus kun pinunachana san huu'na. ");
INSERT INTO kyb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sija nan nangwhaun chachay mansunuchay huwhai as umoy mangiwhaka an Hesus gway manggwana, “Apu, sa'ad chay whawhallugwomay hubuyunnu nasa'it.” ");
INSERT INTO kyb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chingngorn kun Hesus chi anana, “Nan sachi sa'it wha'on kus otoy nan ma'gwaana jon na'gwa nannaja tot mipaila nan inachajaw Apudyus tot michajagwa' gway Ana'na kapu sannaja.” ");
INSERT INTO kyb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ipatpatog Hesus chachay mansusunud gway Marta, Maria ja Lazaro. ");
INSERT INTO kyb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ta'on nu chingngornaay nasa'it as Lazaro achi kun ummoy gway inuyayna jan nan chugwaay erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nappung ku chugwa erkaw anan Hesus sasan pasuyutna, “Inta'u asin ad Judea.” ");
INSERT INTO kyb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anan chanan pasuyutna an sija, “Mistuyu, say sinerkagwan takangay cha'a whintukon sasan Hudyu. Kunja asin'a hos umoy ad aschi?” ");
INSERT INTO kyb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Anan Hesus gway summungwhat, “Jo'o achi nasagwayan as chugwa uyas nan osa erkaw ta? Nu ngachan nan manadchayan san erkaw achi kun michungpur tan kapu san padcha anna nan ilana. ");
INSERT INTO kyb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gwon nu ngachan nan manadchayan san lawhi michungpur tan maid kun silaw an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nappung kun Hesus iwhaka nan sachi anana an chicha, “Sa'ad as Lazaro gway hubuyun ta'u nanassuy jon iya' tot whangono' as sija.” ");
INSERT INTO kyb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gwot anan chanan pasuyutna an sija, “Apu, nu nanassuy as sija ayawniyot ma'aan nan sa'itna ja.” ");
INSERT INTO kyb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sija whayugwon Hesus anan nan natoy as Lazaro gwon anancha kunnu sija whayugwona anan nan nanassuy ekas sija. ");
INSERT INTO kyb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gwot sija nan ingwhawhagkan Hesus an chicha gway manggwana, “Natoy as Lazaro. ");
INSERT INTO kyb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gwon humayugwanju nan maicha' san natojana tot mamati aju. Maserpu inta'u an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Gwot anan Tomas gway ananchaon Didymus san huhuyunnaay pasuyut, “Inta'u hos tot mitapi ta'uway matoy an Hesus.” ");
INSERT INTO kyb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gwot hummu'nag ku cha Hesus ad Betania naakammugwanaay nappung na'apat nan erkaw Lazaro san lohonna. ");
INSERT INTO kyb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ad nan Betania umoy as tuyuway kilometro nan aachajuna san Jerusalem ");
INSERT INTO kyb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kun angsan nan iJudea gway ummoy nalliwligwa an Marta ja Maria kapu san sunudchaay natoy. ");
INSERT INTO kyb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Gwot sa'ad as Marta chingngorna kunay anna umali as Hesus, ummoyna inahot as sija gwon natchay as Maria gway tummutu'chu ad ugwacha. ");
INSERT INTO kyb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Gwot anan Marta an Hesus, “Apu, nu iningkaw'a otjan ad asna achi otjan natoy nan sunud'u. ");
INSERT INTO kyb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jon ta'on nu amasnat akammu'ay nu ngachan nan ochagwom an Apudyus atchon Apudyus an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Anan Hesus an sija, “Mataku nan sunudnu.” ");
INSERT INTO kyb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Anan Marta an sija, “Akammu'ay mataku as sija san matakuwan nan natoy san udchin nan erkaw.” ");
INSERT INTO kyb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Anan Hesus an sija, “Sa'on nan manaku sasan taku san otoy ja sa'on nan mangatod san whijag as ingkaingkana. Nan mamati an sa'on ta'on nu matoy, mataku. ");
INSERT INTO kyb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ja nu ngachan nan mawhiwhijag ja mamati an sa'on achi kun puyus matoy. Ad tuttugwaom na?” ");
INSERT INTO kyb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Anan Marta an sija “Oon, Apu, tinuttuwa' si'a gway si'a nan Kristu gway Ana' Apudyus gway umalid asna luta.” ");
INSERT INTO kyb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nappung kun Marta iwhaka nan sachi nanagkulin ad ugwacha gway ummoy nangajag an Maria gway sunudna. Achina kun impaakammu san aachugwan gway manggwana, “Anna hummu'nag nan Mistuyu ad asna ad ipaajag cha'a.” ");
INSERT INTO kyb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chingngorn kun Maria nan ingwhakan Marta nernagwa kun ummoy an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Chaan kun chumakus as Hesus san ilicha, sissija agwad say nangabtan Marta an sija. ");
INSERT INTO kyb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sija nan sa'ad chachay iJudea gway iniingkaw an Maria san hoyoy gway malliwligwa an sija, inilacha kunay nerniggwat ja lummagwa as Maria nitunudcha an sija. Anancha kunnu umoy san niilhonan Lazaro tot maniwhil as sija ad aschi. ");
INSERT INTO kyb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Gwon sa'ad as Maria chummakus kun san agwachan Hesus gwot inilan Hesus as sija nanchumug san i'ina gway manggwana, “Apu, nu iningkaw'a otjan ad asna achi otjan natoy nan sunud'u.” ");
INSERT INTO kyb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gwot sa'ad as Hesus, inilana kun as Maria gway maniwhiiwhil ja chachay Hudyuway nitunud an sija gway maniwhiiwhil, lummagwing nan somsomo'na kun amod nan sasangana. ");
INSERT INTO kyb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kun anana, “Agwan nan nangilhonanju an sija?” Anancha an sija, “Apu, gwaynu ta umalim ilan.” ");
INSERT INTO kyb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sachi kun nalluwa as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gwot anan chachay Hudyu, “Ilanju ad nan mamayuna an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gwon anan nan uchum an chicha, “Nu inaanna nan uyap nan na'uyap kana achi impaggwod as Lazaro san otoy nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Gwot sa'ad as Hesus ummamod asin lummagwing nan somsomo'na san chummakus san niilhonan Lazaro. Lijang na sachi niilhonana gway naongwhan san whatu. ");
INSERT INTO kyb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kun anan Hesus, “Aanonju nan whatuway onobna.” Gwon anan Marta gway chay sunud nan natoy, “Apu, manakub san sana tan mi'apat nan erkawnad kanad san natojana.” ");
INSERT INTO kyb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Anan Hesus an sija, “Jo'o achi' ingwhaka an si'aay nu tuttugwaom as sa'on mailam nan inachajaw Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gwot inaancha chay whatuway onobna. Kun nantangad as Hesus gwot anana, “Ama, manjamana' tan chingngorm as sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Akammu'ay patinajunnu chongyon as sa'on jon kapu sannachaja takuway nasi'asi'ad iwhaka' na tot tuttugwaonchaay si'a nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ingwhakana ku sachi impa'uyna gway manggwana, “Lazaro, lumagwa'a!” ");
INSERT INTO kyb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kun lummagwa chay natoy gway napuputtiputan nan i'ina ja imana san luput ja nahungut nan hoserna san panju. Kun anan Hesus an chicha, “U'whachonju nan niputiput an sija ad ainnugwana manadchayan.” ");
INSERT INTO kyb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sachi kun angsan sasay Hudyuway ummoy an Maria gway nangila san inggwan Hesus nan namati an sija. ");
INSERT INTO kyb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gwon iningkaw nan uchum an chicha gway ummoy sasan Pariseo kun ingwhakacha nan inggwan Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sija nan impaajag chachay papangat nan papachi ja chachay Pariseo chanan uchumay papangat nan Hudyu. Kun nanuukuchancha gway manggwana, “Ngachan nan oon ta'u? Tan sa'ad nannaja taku angsan nan mataakan gway o'oona. ");
INSERT INTO kyb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu ijuja ta'us sija san amaschi o'oona losan nan taku tuttugwaon as sija ad ummali chanan iRoma ad iwwa''icha nan Templo ta'u ja tangkaancha nan losanay ili ta'u.” ");
INSERT INTO kyb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gwon sa'ad nan osa an chicha gway Caifas nan ngachanna gway sija nan angatuwanay pachi san sachi tagwon, anana an chicha, “Maid kun puyus akammuju. ");
INSERT INTO kyb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Achiju kun somsom'onay humayugwanju nan matoy nan osa taku sasan aachugwan nu nan matangkaan nan losanay umili Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wha'on kus ingwhakana nannaja san ugwanaay somsomo' jon kapu tan sija nan angatuwanay pachi san sachi tagwon, impaipadtun Apudyus an sija gway sa'ad as Hesus matoy kapu sasan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ad wha'on kus ahus chanan Hudyu ekay jon sa'ad ahos chanan ana' Apudyus gway nigwayas san ailiili, ayusona chicha manosossaanon. ");
INSERT INTO kyb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gwot malluki kusan sachi erkaw nanuukud chachay papangat nan Hudyu tot otojoncha as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sija nan iyakay cha Hesus gway umoy mampaipaila mangkagka'ay sasan iJudea. Jon ummoycha san achani san luta gway maid kun ingkaw as taku san osa iliyay ananchaon Epraim. Kun iningkawchad aschi sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Takangay nan pijastan chanan Hudyu gway ma'gwaniyon Lumaus. Kun angsan nan takuway nerpu san ailiiliyay ummoy ad Jerusalem san chaan malluki nan Pijasta tot umoycha oon nan ukalicha gway maserpu mampapor'ascha. ");
INSERT INTO kyb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gwot inanaanapchas Hesus kun asi'a'anancha san summisi''achancha san sowhan nan Templo, “Ngachan nan ananju? Ad umalis sija san Pijasta?” ");
INSERT INTO kyb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kun ingwhilin chachay papangat nan papachi ja chachay Pariseo gway nu ngachan ad nan mangakammu san agwachan Hesus, ipaakammuna tot chopaponchas sija. ");
INSERT INTO kyb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Onom ad gway erkaw asiyot nan pijasta gway ma'gwaniyon Lumaus, ummoy as Hesus ad Betania gway ilin Lazaro gway chay tinakuna san natojana. ");
INSERT INTO kyb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gwot insakasakanan chanan taku ad aschi nan anon Hesus san lawhi kun hummachang as Marta gway nanchurngu kun osas Lazaro sasan na'a'an an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Gwot sa'ad as Maria inayana nan koggwan nan litro gway amod nan patognaay whangwhangyu gway pasig nardo, kun insiitna san i'in Hesus kun asinaot punachan san huu'na. Ad sa'ad nan hoyoy napnu san whangun nan whangwhangyu. ");
INSERT INTO kyb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ad sa'ad as Judas Iscariote gway osa sasan pasuyut Hesus gway sija nan mangijiwhit an sija, anana, ");
INSERT INTO kyb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mila'u otjan nannaja whangwhangyu as tuyungkasut as dinario ad naatod san whawha'sigwot?” ");
INSERT INTO kyb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ingwhakana na wha'on kus kapu tan isi'nana chanan whawha'sigwot jon kapu tan manaa'aw as sija ja sija nan mamangchon san pila' ad choona a'huton nan chokana. ");
INSERT INTO kyb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gwot anan Hesus, “Ainnugwana man. Tinerterponna na tot mangununnana mallana san lachag'u san miilhona'. ");
INSERT INTO kyb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tan nan whawha'sigwot patinajunay iingkaw an cha'aju gwon wha'ona' kus patinajunay iingkaw an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Naakammugwan kunan amochay taku gway agwad as Hesus ad Betania, ummoycha. Ad wha'on ku' ahus ekay as Hesus as umoycha ilan jon whayugwoncha hosay ilan as Lazaro gway chay tinakuna san natojana. ");
INSERT INTO kyb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gwon sa'ad chanan papangat nan papachi nanuukuchancha gway otojoncha hos as Lazaro ");
INSERT INTO kyb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tan kapu san na'gwa an sija angsan sasan Hudyu nan ummoy an Hesus kun tinuttuwachas sija. ");
INSERT INTO kyb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mawhikat kun sa'ad chachay amochay taku gway ummoy na'apijasta chingngorcha kun gway umoy as Hesus ad Jerusalem, ");
INSERT INTO kyb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nangayacha san tuhun nan palma kun ummoycha inahot as Hesus. Kun ip'aip'awchaay manggwana, “Hosanna! Piyan as sija gway umali san ayobhongan Apudyus. Machaychajaw as sija gway Alin chanan ijIsrael!” ");
INSERT INTO kyb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kun inchasan Hesus nan uyhun nan asno kun nangawhajuwana. Tan nilista san Ukud Apudyus gway anana, ");
INSERT INTO kyb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Achi aju umogjat cha'ajuway iJerusalem. Ilanju nan Aliju anna umaliyay nangaabwhaju san uyhun nan asno.” ");
INSERT INTO kyb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nannaja na'gwa wha'on kus naagwatan chanan pasuyutna san sachi chimpu. Jon nappung kun nipaila nan inachajaw Hesus san natakuwana asichaot somsom'on chay nilista gway mipangkop an sija ja annaja inggwacha an sija. ");
INSERT INTO kyb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ad sa'ad chachay takuway iningkaw an sija say nam'agwana an Lazaro san lohonay lijang kun tinakuna as sija san otoy, impano'no'cha nan inilacha. ");
INSERT INTO kyb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gwot ummoy ahos nan amochay taku inahot as Hesus kapu tan chingngorcha nannaja mataakanay inggwana. ");
INSERT INTO kyb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sija nan asi'a'anan chanan Pariseo, “Ilanjuwot maid kun ma'gwa ta'u. Amod nan takuway ummoy nitunud an sija!” ");
INSERT INTO kyb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iningkaw chanan uchumay Griego gway umoy ad Jerusalem tot manchajawcha san Pijasta. ");
INSERT INTO kyb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gwot sa'ad nannachaja ummoycha an Felipe gway iBetsaida ad Galili kun inimuscha an sija gway manggwana, “Apu, whayugwonmi ilan as Hesus.” ");
INSERT INTO kyb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ummoy Felipe ingwhaka an Andres kun ummoychaay chugwa ingwhaka an Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kun anan Hesus gway summungwhat an chicha, “Hummu'nag nan chimpuway michajagwa' gway Ana' nan Taku. ");
INSERT INTO kyb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tuttuwa iwhaka' an cha'aju gway nu achi mijoso' nan osaay hu'orn nan trigo san luta ja achi matoy sissija eka osossa''an. Gwon nu matoy mamushus as angsan. ");
INSERT INTO kyb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu ngachan nan ahus nan whijagnas patpatkona achi kun ma'awhijag an Apudyus as ingkaingkana gwon nu ngachan nan achi mangipatog san whijagna ad asna luta kapu an sa'on, ma'awhijag an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nu ngachan nan mansilwhi an sa'on maserpu mitunud an sa'on. Ad sa'ad nu agwan nan agwad'u agwad ahos as sija. Nu ngachan nan mansilwhi an sa'on ichajaw Ama.” ");
INSERT INTO kyb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kun intuyuy Hesus gway manggwana, “San sana anna nakuyu nan somsomo''u. Ad ngachamma iwhaka'? Ana'on, ‘Ama, ilisiya' san likat gway ippong'u?’ Wha'on tan annaja nan kapun nan ummaliya' san sana chimpu. ");
INSERT INTO kyb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ama, ichajawnu nan ngachannu!” Gwot anan nan kingaay nerpud langit, “Nappung'u ichajaw ad asi' asinon ichajaw.” ");
INSERT INTO kyb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gwot sa'ad chachay takuway nasi'asi'ad ad aschi ja nangngor san kinga, ananchaon nangichur. Anan nan uchum, “Na'aapapat nan anghel an sija!” ");
INSERT INTO kyb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Anan Hesus gway summungwhat, “Wha'on kus humayugwa' nannaja kingaay chingngorju jon humayugwanju chi. ");
INSERT INTO kyb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sana nan mau'uman nan luhung. Ad nan mangituyay sannaja luhung sana nan maawha'ana. ");
INSERT INTO kyb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ad as sa'on nu miwhajuka' san krus paachayuko' nan losanay taku gway mamati an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Amaschi nan ingwhakana as mangipaakammugwana san ininonaay matoy. ");
INSERT INTO kyb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gwot anan chachay takuway summungwhat an sija, “Naagwatanmi san Ukud Apudyus gway sa'ad nan Kristu iingkaw as ingkaingkana. Kunja kamma ananon maserpuway miwhajug san krus nan Ana' nan Taku? Ngachamma nannaja gway Ana' nan Taku nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sija nan anan Hesus an chicha, “Sina'itan nan ingkagwan nan silaw an cha'aju. Manadchayan aju san annaan nan silaw an cha'aju tot achi cha'aju awha'on san manghulingot. Nan manadchayan san manghulingot achina kun akammu nan umajana. ");
INSERT INTO kyb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sa'ad san annaan nan silaw an cha'aju tuttugwaonju nan silaw tot mangngachan aju anana' nan silaw.” Ingwhakan kun Hesus nan sachi lummajaw gway nallinus an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ta'on nu angsan nan mataakanay inggwana san agwachancha achicha kun tuttugwaon as sija ");
INSERT INTO kyb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tot tumuttuwa nan anan profeta Isaias gway anana, “Apu, ngachan nan namati san ingwhakami? Ja ngachan nan nangipailan Apudyus san pigsana?” ");
INSERT INTO kyb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sija nan achicha kun mamati kapu tan anan ahos Isaias, ");
INSERT INTO kyb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Inuyap Apudyus nan atacha tot achicha ma'aila ja impawhatuna nan somsomo'cha tot maid maagwatancha ja tot achicha managkulin an sa'on, anan Apudyus, ad impawhayu' chicha.” ");
INSERT INTO kyb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ingwhakan Isaias nannaja kapu tan inilana nan inachajaw Kristu kun ingwhakana nan mipangkop an sija. ");
INSERT INTO kyb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gwon uyay nu amaschi angsan sasan papangat nan Hudyu nan namati an Hesus. Jon kapu tan umogjatcha sasan Pariseo achicha kun ipaakammu tan maperjawcha san sinagoga. ");
INSERT INTO kyb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tan sija impatogcha nan mapachajagwancha sasan taku nu nan mapachajagwancha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kun inipa'w Hesus gway manggwana, “Nu ngachan nan mamati an sa'on wha'on kus ahusa' as tuttugwaona, tuttugwaona hos nan nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ad nan mangila an sa'on mailana hos nan nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sa'on nan silaw gway ummalid asna luta tot nu ngachan ad nan mamati an sa'on achi kun iingkaw san manghulingot. ");
INSERT INTO kyb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ad nu ngachan nan manchongor san ukud'u gwon achi kun chumngor sina achi' kun u'umon as sija. Tan wha'on kus ummaliya' tot u'umo' chanan taku ad asna luta jon ummaliya' ta takuwo' chicha. ");
INSERT INTO kyb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nan mallagwing an sa'on ja achina tuttugwaon nan ukud'u, agwad nan mangu'um an sija. Chay inukud'uwanchi gway atuttugwaan nan mangu'um an sija san udchin nan erkaw ");
INSERT INTO kyb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","kapu tan achiya' kun nanukud san ugwa'ay somsomo' jon nan nangiwhaun an sa'on gway as Ama, sija nan nangiwhilin an sa'on nu ngachan nan iwhaka' ja nu ngachan nan ukucho'. ");
INSERT INTO kyb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ad akammu'ay sa'ad nan whilinna mangatod as ma'awhijakan an Apudyus as ingkaingkana. Sija nan nu ngachan nan iwhaka' sija nan impaiwhakan Ama an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Osa ad eka erkaw asiyot nan Pijasta gway ma'gwaniyon Lumaus, ad aagkammun Hesus gway humu'nag nan chimpuna gway lumajaw ad asna luta ja managkulin an Amana. Sikud gway impatpatogna chanan summuyut an sija ad asna luta ad san sana impailana an chicha nan lajadna gway maid kun uyangna. ");
INSERT INTO kyb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sa'ad san mangamanganan cha Hesus ja chanan pasuyutna san lawhi naahus Satanas ipaslo' san somsomo' Judas gway ana' Simon Iscariote ta ijiwhitna as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ad sa'ad as Hesus aagkammuna gway inatod Amana an sija nan losanay ayobhongan ja nerpus sija an Apudyus ad umoy managkulin an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sija nan summi'ad as sija san mangamanganancha kun inaanna nan kotap nan silupna kun asinaot ayan nan tu'erja gwot in'ainna. ");
INSERT INTO kyb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Gwot inggwaana san chanum nan payangkan kun asinaot isuwan nan i'in chanan pasuyutna kun pinunachana san tu'erjaay in'a'ainna. ");
INSERT INTO kyb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gwot miwhatug kus sija an Simon Pedro anan Pedro an sija, “Apu, adja isuwam nan i'i'?” ");
INSERT INTO kyb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Anan Hesus gway summungwhat an sija, “Nan o'oo' anna achim pun maagwatan san sana gwon maagwatam a' asi.” ");
INSERT INTO kyb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kun anan Pedro an sija, “Puyus gway achim pun isuwan nan i'i'.” Gwon anan Hesus gway summungwhat, “Nu achi' isuwan nan i'im achi'a kun miwhilang an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Anan Simon Pedro an sija, “Apu, wha'on kus ahus yakay i'i' jon itapim ahos nan ima' ja wha''ag'u!” ");
INSERT INTO kyb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Anan Hesus an sija, “Nan naahus manamos wha'on kus maserpu manamos asin tan por'as as sija. Ahus ekay i'ina as maisuwan. Por'as aju jon wha'on aju kus losan.” ");
INSERT INTO kyb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kapu tan aagkammuna nan mangijiwhit an sija, sija nan ananaon, “Wha'on aju kus losan por'as.” ");
INSERT INTO kyb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nappungna ad isuwan nan i'icha insilupna asin nan kotap nan silupna kun nanagkulin san ingkagwana san lamisaan. Kun anana an chicha, “Maagwatanju nannaja inggwa' an cha'aju? ");
INSERT INTO kyb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Agwakanjus sa'on as Mistuyu ja Apu ad ustu nan ananju tan tuttuwa gway sa'onnat. ");
INSERT INTO kyb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sija nan sa'ad tan as sa'onay Apuju ja Mistuyuju nan nangisu san i'iju maserpuway maninnisu aju hos. ");
INSERT INTO kyb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inggwa' an cha'aju nan mangilanju tot oonju hos nan inggwa' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tuttuwa iwhaka' an cha'aju gway sa'ad nan mudchachu wha'on kus nangatngatu san amuna ja sa'ad ahos nan niwhaun wha'on kus nangatngatu san nangiwhaun an sija. ");
INSERT INTO kyb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ad sa'ad tan naagwatanju nannachaja piyan nan whijagju nu oonju chana. ");
INSERT INTO kyb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Wha'on kus cha'aju losan nan pijao' iwhaka. Aagkammu' chanan pinili'. Gwon maserpu ma'gwa nan nilista san Ukud Apudyus gway chay ananaon, ‘Nan na'auhuuhungay na'a'an an sa'on san tinapay whinursunas sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","San sana iwhaka' an cha'aju nannaja san chaan ma'gwa tot sa'ad nu ma'gwa tuttugwaonjuway ‘Sa'on as Sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tuttuwa iwhaka' an cha'aju gway nu ngachan nan mangajag san iwhaun'u inajakana' ahos. Ad nu ngachan nan mangajag an sa'on inajakana nan nangiwhaun an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nappung kun Hesus iwhaka chi nakuyu as amod nan somsomo'na kun impaakammuna gway manggwana, “Tuttuwa iwhaka' an cha'aju gway osa an cha'aju nan mangijiwhit an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kun nanisitollong chachay pasuyutna gway mati'awcha nu ngachanna an chicha nan pijaona anan. ");
INSERT INTO kyb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ummaassiyay tummu'chu san cherrag Hesus nan osa sasan pasuyutna gway ipatpatogna. ");
INSERT INTO kyb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sija nan nayyangod as Simon Pedro san sachiyay pasuyut ta imusona an Hesus nu ngachanna an chicha nan pijaona anan. ");
INSERT INTO kyb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gwot nisachag nan sachiyay pasuyut an Hesus kun anana an sija, “Apu, ngachan nichi?” ");
INSERT INTO kyb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kun anan Hesus gway summungwhat, “Sija nan mangatcha' san ituyno''u gway pi''in nan tinapay.” Gwot intuyno'na chay pi''in nan tinapay kun inatodna an Judas gway ana' Simon Iscariote. ");
INSERT INTO kyb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gwot inayan kun Judas chay tinapay sinumpaw as Satanas an sija. Gwot anan Hesus an sija, “Nan whayugwomay oon a''agwaynuway manggwa.” ");
INSERT INTO kyb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gwon achin ku chachay agwad san oo''anan naagwatan nu kanama iwhaka chi an Judas. ");
INSERT INTO kyb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Anan ekay uchumon sa'ad tan Judas nan mamangchon san pila', ingwhakan Hesus an sijaay umoy malla'us usayoncha san pijasta gwinnu umoy mangatod as pila' san whawha'sigwot. ");
INSERT INTO kyb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gwot inayan kun Judas nan tinapay nernagwa as sija. Ad lawhi nan sachi. ");
INSERT INTO kyb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aysan kus Judas anan Hesus, “Ad san sana sa'ad as sa'onay Ana' nan Taku nichajaw ad michajaw ahos as Apudyus kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ad sa'ad nu michajaw as Apudyus kapu an sa'on, as Apudyus sija ahos nan mangichajaw an sa'on ad nanichajawna an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cha'ajuway anana''u, sina'itan nan ingkagwa' an cha'aju. Anapona' an cha'aju ad isun nan ingwhaka' sasay papangat nan Hudyu, iwhaka' ahos an cha'aju san sana gway sa'ad nan umaja' achi aju kun ma'aali. ");
INSERT INTO kyb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Anna nan assahu whilin gway atcho' an cha'aju. Manisiwhayu aju. Maserpu manisiwhayu aju as isun nan mamayu' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tan nu manisiwhayu aju maakammugwan nan losanay taku gway pasuyut'u cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kun anan Simon Pedro an Hesus, “Apu, agwan nan ajam?” Kun anan Hesus gway summungwhat, “Achi'a kun mawhalinay mitunud an sa'on san sana san umaja' gwon mitunud'a san tapin chi erkaw.” ");
INSERT INTO kyb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kun anan Pedro an sija, “Apu, kaman achiya' mawhalinay mitunud an si'a san sana? Aatcho' nan whijag'u kapu an si'a!” ");
INSERT INTO kyb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Gwot anan Hesus gway summungwhat, “Ad tuttuwa aatchom nan whijagnu kapu an sa'on? Iwhaka' an si'a nan tuttuwa: Chaan ad mangu''uu' nan awwit mamitlum sa'on isulib.” ");
INSERT INTO kyb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Anan Hesus an chicha, “Achi aju malilihu'an. Tuttugwaonju as Apudyus ja tuttugwaonju hos as sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Angsan nan magkagwan san hoyoy Ama. Nu wha'on as tuttuwa na achi' otjan iwhaka an cha'ajuway iya' isakana nan ingkagwanju. ");
INSERT INTO kyb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ad mappung'u ad umoy isakana nan igkagwanju umaliya' asin ad inajaka' cha'aju tot agwan ad nan agwad'u agwad aju hos. ");
INSERT INTO kyb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ad nu agwan nan umaja' akammuju nan chayan.” ");
INSERT INTO kyb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Anan Tomas an Hesus, “Apu, achimi kun akammu nu agwan nan ajam. Ininonmiyay mangakammu san chayan?” ");
INSERT INTO kyb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Anan Hesus an sija, “Sa'on nan chayan ja nan atuttugwaan ja nan whijag. Maid kun umoy an Ama nu achi mangoy an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu tuttuwaay akammuju nu ngachanna as sa'on, akammuju hos as Ama. Ad malluki san sana akammujus sija ja inilajus sija.” ");
INSERT INTO kyb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Anan Felipe, “Apu, ipailam an cha'ami as Ama ta mapno' ami.” ");
INSERT INTO kyb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Anan Hesus an sija, “Felipe, nawhajakay iniingkagwa' an cha'aju kunja chaannu ekay maakammugwan as sa'on? Nu ngachan nan nangila an sa'on inilana as Ama. Kunja kamma ananon, ‘Ipailam an cha'ami as Ama’? ");
INSERT INTO kyb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jo'o achim tuttugwaonay agwacha' an Ama ja annas Ama an sa'on? Sa'ad nan iwhakawhaka' an cha'aju wha'on kus nerpu san somsomo''u gwon as Ama gway iingkaw an sa'on nan manggwa san terwhasuna gway inggwa'inggwa'. ");
INSERT INTO kyb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tuttugwaonjus sa'on san manggwanaa'on agwacha' an Ama ja annas Ama an sa'on. Gwon nu achiju tuttugwaon as sa'on mamati aju otjan kapu sasan inggwa'inggwa'. ");
INSERT INTO kyb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tuttuwa iwhaka' an cha'aju gway nu ngachan nan mamati an sa'on oona hos nan o'oo'. Ancha amamod pay nan oona nu nan o'oo' kapu tan sa'ad as sa'on iya' an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ad nu ngachan nan ochagwonju kapu san ngachan'u, oo' ta michajaw as Ama kapu an sa'on gway Ana'na. ");
INSERT INTO kyb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nu ngachamman sinat gway ochagwonju kapu san ngachan'u, oo'.” ");
INSERT INTO kyb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Intuyuy Hesus gway manggwana, “Nu ipatogjus sa'on sa'ad chanan whilin'u chongyonju. ");
INSERT INTO kyb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ochagwo' ad an Ama atchona an cha'aju nan osa ahosay Mamachang an cha'aju tot ingkaw an cha'aju as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sa'ad nan Mamachang sija nan Ispilitun Apudyus gway mangipaakammu san atuttugwaanay mipangkop an Apudyus. Achin ku chanan takud asna luta ajakan nan Ispilitun Apudyus kapu tan achicha kun maila as sija ja achicha kun akammu as sija. Gwon sa'ad as cha'aju akammuju as sija kapu tan iingkaw an cha'aju ja agwad an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wha'on kus tayna' cha'aju as isun chanan ulila. Umaliya' managkulin an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sina'itan ad achin ku chanan takud asna luta ilan as sa'on gwon ilanjus sa'on. Kapu tan mawhiwhijaka', mawhijag aju hos. ");
INSERT INTO kyb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","San sanatay chimpu maakammugwanjuway agwacha' an Ama ja anna aju an sa'on ancha agwacha' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nan mamopotpot sasan whilin'u ja chumngor an chana sija nan mangipatog an sa'on. Ad nan mangipatog an sa'on ipatog Ama ad impatog'u as sija ad impaakammu' nan mipangkop an sa'on an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kun anan Judas an sija (wha'on ku an Judas Iscariote), “Apu, ka cha'ami nan mangipaakammugwam san mipangkop an si'a ja wha'on sasan takud asna luta gway achi kun mamati?” ");
INSERT INTO kyb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Anan Hesus gway summungwhat an sija, “Nu ngachan nan mangipatog an sa'on chongyona nan sussuyu' ad impatog Ama as sija ad ummali ami ja iingkaw ami an sija. ");
INSERT INTO kyb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nan achi mangipatog an sa'on achina kun chongyon chanan sussuyu'. Ad nan sussuyu gway chochongyonju wha'on kus nerpu an sa'on, nerpu an Ama gway nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ingwhaka' nannachaja an cha'aju sanna annaa' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gwon nan Mamachang gway Ispilitun Apudyus sija nan iwhaun Ama gway misu'at an sa'on. Sija nan mangisuyu an cha'aju san losan ja mangipasmo' an cha'aju san losanay ingwhaka' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tayna' an cha'aju nan whayu somsomo' gway maid machanakanju. Atcho' an cha'aju nan whayuway somsomo' gway nerpu an sa'on. Wha'on kus isun nan atchon chanan takud asna luta nan atcho' an cha'aju. Achi aju malilihu'an ja achi aju umogjat. ");
INSERT INTO kyb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chingngorju gway innana' an cha'ajuwon, ‘Iya' lumajaw ad ummaliya' managkulin an cha'aju.’ Nu ipatpatogjus sa'on lumagsa' aju otjan kapu tan iya' an Ama tan as Ama nangatngatu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ad iwhaka' san sana an cha'aju san chaan ma'gwa tot sa'ad nu ma'gwa mamati aju. ");
INSERT INTO kyb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Achiya' kun patho' ma'augugkud an cha'aju tan umali nan mangituyay san annaja luhung. Maid kun mawhalinna an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jon o'oo' nan ingwhilin Ama an sa'on tot sa'ad chanan takud asna luta gway achi kun mamati maakammugwancha gway ipatpatog'u as Ama. “Lumiggwat aju ta lumajaw ta'u sannaja.” ");
INSERT INTO kyb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Intuyuy Hesus gway manggwana, “Sa'on nan kadto'ay puun nan ubas ja as Ama nan manasamer. ");
INSERT INTO kyb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aanona nan panga' gway achi mangkas ja chayusana nan panga' gway mangkas ta umachu' amod nan hokasna. ");
INSERT INTO kyb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naahus aju nachayusan kapu san ukud'uway ingwhaka' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ainnugwanju an sa'on ad inainnugwa' an cha'aju. Tan achi aju mangkas nu achiju ainnugwan an sa'on, isun nan panga gway nisiyan san puunna. ");
INSERT INTO kyb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sa'on nan puun nan ubas cha'aju nan panga. Nan ainnugwana an sa'on ja ainnugwa' an sija mangkas as sija as angsan kapu tan nu maicha' maid ma'gwaju. ");
INSERT INTO kyb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu ngachan nan achi iingkaw an sa'on miwhallu as isun nan pangaay miwhallu ad nayangu ad naubpuncha ja naskobcha. ");
INSERT INTO kyb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu ainnugwanju an sa'on ja ainnugwan nan ukud'u an cha'aju ochagwonju nan ngachamman sinatay whayugwonju ad naatod an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Michajaw as Ama kapu sannaja gway mangkas aju as angsan ad impailajuway cha'aju nan pasuyut'u. ");
INSERT INTO kyb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ipatpatog'u cha'aju as isun nan mangipatog Ama an sa'on. Ainnugwanju san lajad'u. ");
INSERT INTO kyb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu patiyonju chanan whilin'u ainnugwanju san lajad'u as isun nan chinumngoya' sasan whilin Ama ja ainnugwa' san lajadna. ");
INSERT INTO kyb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ingwhaka' nannachaja an cha'aju tot sa'ad nan lagsa''u agwad an cha'aju ad nan lagsa'ju maid uyangna. ");
INSERT INTO kyb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Annaja nan whilin'u: manisiwhayu aju as isun nan mamayu' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maid kun osas awhayugwanay lajad nu nan annaja gway atchon nan osa taku nan whijagna sasan hubuyunna. ");
INSERT INTO kyb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Cha'aju nan hubuyun'u nu chongyonju nan iwhilin'u an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wha'on kus iwhilang'u cha'aju as mudchachu kapu tan wha'on kus akammun nan mudchachu nan o'oon nan amuna. Gwon ingwhilang'u cha'aju as hubuyun'u kapu tan losanay chingngor' an Ama impaakammu' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wha'on kus cha'aju nan namili an sa'on jon sa'on nan namili an cha'aju. Kun chinutu'a' cha'aju tot i'aju ad whinumkas aju ad sa'ad chanan hokasju sissijachaay iingkaw tot ngachan ad nan ochagwonju an Ama kapu san ngachan'u atchona an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Annaja nan iwhilin'u an cha'aju gway manisiwhayu aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nu isilon cha'aju sasan takud asna luta gway achi kun mamati, sosom'onjuway sa'on nan ummunacha inisil. ");
INSERT INTO kyb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu mijamung aju sasan takud asna lutaay achi kun mamati whayugwon cha'aju otjan an chicha. Wha'on aju kus mijamung an chicha jon pinili' cha'aju init'on an chicha ad asna luta sija nan aisilcha cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sosom'onju nan ingwhaka' an cha'aju: ‘Nan mudchachu wha'on kus nangatngatu san amuna.’ Sa'ad tan pinalikatana', palikatan cha'aju hos. Nu chinumngorcha san sussuyu' chumngorcha hos nan sussuyuju. ");
INSERT INTO kyb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Losan nan annachaja ooncha an cha'aju kapu an sa'on kapu tan achicha kun akammus Ama gway nangiwhaun an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nu achiya' ummali ja nanukud an chicha mawhalin gway ananchaon maid whersucha. Gwon san sana achicha kun mayasunan nan whersucha. ");
INSERT INTO kyb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu ngachan nan mangisil an sa'on isilona hos as Ama. ");
INSERT INTO kyb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu achi' inggwa nan mataakan an chicha gway maid kun osas nanggwa, mawhalin gway ananchaon maid whersucha. Gwon ta'on nu inilacha nan inggwa'inggwa' sissijaay iissiloncha as sa'on ja as Ama. ");
INSERT INTO kyb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jon maserpu ma'gwa nan nilista san Ukud Apudyus gway anana, ‘Inisilchas sa'on gway maid kun kapuna.’ ");
INSERT INTO kyb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nu umali an cha'aju nan iwhaun'uway Mamachang gway Ispilitun nan atuttugwaan gway merpu an Ama, sija nan mangipano'no' san mipangkop an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ad cha'aju ahos nan mangipano'no' kapu tan iniingkaw aju an sa'on san chamchamu.” ");
INSERT INTO kyb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Intuyuy Hesus gway manggwana, “Ingwhaka' nannachaja an cha'aju tot achiju ijakay san pammatiju. ");
INSERT INTO kyb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Perjagwoncha cha'aju sasan sinagoga ad hummu'nag nan chimpuway sa'ad nan losanay mangtoy an cha'aju anancha kunnu ichajawcha as Apudyus san o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ad annachaja nan ooncha an cha'aju kapu tan achicha kun akammu as Ama gwinnu sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jon ingwhaka' nannachaja an cha'aju tot humu'nag ad nan chimpu gway ma'gwa chana somsom'onjuway ingwhaka' an cha'aju nannaja. “Sa'ad nannachaja achi' kun ingwhaka an cha'aju san chamchamu tan iniingkagwa' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gwon iwhaka' san sana gway iya' an Ama gway nangiwhaun an sa'on ad maid manimus an cha'aju nu agwan nan aja'? ");
INSERT INTO kyb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kapu tan ingwhaka' an cha'aju nannachaja lumagwing nan somsomo'ju. ");
INSERT INTO kyb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta'on nu amaschi iwhaka' nan tuttuwa an cha'aju gway humayugwanju nan lumajagwa' tan sa'ad nu achiya' lumajaw achi kun umali nan Mamachang an cha'aju. Ad nu lumajagwa' iwhaun'us sija an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ad sa'ad nu umalis sija su'unona chanan taku san luhung gway wha'on kus ustu nan manomsom'ancha san mipangkop san whersu ja mipangkop san mangiwhilangan Apudyus san taku as ustu san mangilana ancha mipangkop san mangu'uman Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wha'on kus ustu nan manomsom'ancha san mipangkop san whersu kapu tan achicha kun mamati an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wha'on kus ustu nan manomsom'ancha san mipangkop san mangiwhilangan Apudyus san taku as ustu san mangilana kapu tan iya' an Ama ad awniyot achiju kus sa'on maila. ");
INSERT INTO kyb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ancha wha'on kus ustu nan manomsom'ancha mipangkop san mangu'uman Apudyus kapu tan sa'ad nan mangituyay sannaja luhung naahus mau'um. ");
INSERT INTO kyb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Angsan pay iwhaka' an cha'aju jon achiju kun lobhong maagwatan san sana. ");
INSERT INTO kyb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gwon sa'ad nu umali nan Ispilitu gway mangipaakammu san atuttugwaanay mipangkop an Apudyus, sija nan mangichayan an cha'aju san losanay atuttugwaan. Tan achi kus sija manukud san hu'udnaay somsomo' jon ngachan ad nan chongyona iwhakana ja ipaakammuna an cha'aju nan ma'gwa san umaliyay erkaw. ");
INSERT INTO kyb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ichajagwa' tan ijalina an cha'aju nan whayugwo' gway iwhaka an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ugwa' nan losanay agwad an Ama. Sija nan kapuna gway ingwhaka' gway ijalina nan whayugwo' gway iwhaka an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ad san sina'itanay chimpu achiju kus sa'on maila ad mappung ad nan sina'itanay chimpu mailajus sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Asi'a'anan nan uchumay pasuyutna, “Ngachan nan pijaona anan san manggwanaana an chita'uwon, ‘Sina'itanay chimpu ad achiju kus sa'on maila ad mappung ad nan sina'itanay chimpu mailajus sa'on’ ja san ananaon, ‘Kapu tan iya' an Ama'’? ");
INSERT INTO kyb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ngachan nan pijaona anan san manggwanaanaon, ‘sina'itanay chimpu’? Achi ta'u kun maagwatan nan pijaona anan.” ");
INSERT INTO kyb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Inakammun Hesus gway whayugwoncha manimus an sija, sija nan anana an chicha, “Maninnimus aju kapu san ana'on, ‘Sina'itanay chimpu ad achiju kus sa'on maila ad mappung ad nan sina'itanay chimpu mailajus sa'on’? ");
INSERT INTO kyb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tuttuwa iwhaka' an cha'aju gway humu'nag nan chimpuway maniwhil aju ja mansimo' aju gwon sa'ad chanan takud asna luta mallagsa'cha. Sa'ad as cha'aju sumanga aju jon nan sasangaju mangwhalin lagsa'. ");
INSERT INTO kyb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sa'ad nan huwhai nu humu'nag nan mangkumutana machanakan gwon nu mappungna ipason nan ana', maligwatana nan sikabna kapu san lagsa'na gway nijana' nan osaay ana' sannaja luhung. ");
INSERT INTO kyb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Isuna hos an cha'aju gway sana nan mansasangaanju gwon ila' ad cha'aju asin lummagsa' nan somsomo'ju ja sa'ad nan lagsa'ju maid kun mangaan an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ad san sanatay erkaw achi aju kun maserpu manimus an sa'on san whayangna. Tuttuwa iwhaka' an cha'aju gway nu ngachan nan ochagwonju an Ama kapu an sa'on atchona an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ingkana san sana maid kun inchawju kapu an sa'on. Man'ochaw aju ad naatchan aju tot sa'ad nan lagsa'ju maid kun man'uyangana. ");
INSERT INTO kyb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ta'on nu iyagwat'uway nangiwhaka sannachaja an cha'aju humu'nag nan chimpuway achi' kun ijagwaagwat gway mangiwhaka an cha'aju jon iwhaka'ay ustu nan mipangkop an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","San sanatay erkaw man'ochaw aju an sija kapu an sa'on. Ad nan pijao' iwhaka wha'on kus maserpu sa'on nan mangi'chaw an cha'aju an Ama. ");
INSERT INTO kyb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tan as Ama chadlu nan mangipatog an cha'aju kapu tan impatogjus sa'on ja tinuttuwajuway nerpuwa' an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nerpuwa' an Ama kun ummaliya' ad asna luta. Tayna' ad asna luta ad nanagkulina' an Ama.” ");
INSERT INTO kyb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kun anan chanan pasuyutna an sija, “Ilam chadluwot ingwhawhagkamay ustu kun wha'on kus iyagwatnuway nangiwhaka. ");
INSERT INTO kyb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","San sana maid kun chugwachugwana gway akammumiyay akammum losan nan agwad san somsomo' nan taku ad wha'on kus maserpum nan manimus an si'a. Kapu sannaja tuttugwaonmiyay nerpu'a an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kun anan Hesus gway summungwhat an chicha, “Ad sa sana mamati aju? ");
INSERT INTO kyb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chongyonju na, takangay humu'nag nan chimpu kun anna tuwa hummu'nag gway masibsibta' aju gway gwaschi osaon umoy san hoyoyna ad impaahusjus sa'on taynan. Gwon wha'on kus ahusa' kapu tan anna' Ama an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ingwhaka' nannachaja an cha'aju tot kapu an sa'on maatchan ajus somsomo' gway maid machanakanju. San annaja luhung mapalikatan aju jon papigsaonju nan somsomo'ju tan inawha''u nan lagwingay pigsan nan luhung!” ");
INSERT INTO kyb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nappung kun Hesus iwhaka nan sachi nantangad ad langit kun anana, “Ama, anna hummu'nag nan chimpu. Ichajawnus sa'on gway Ana'nu tot ichajaw'us si'a ");
INSERT INTO kyb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tan inatodnu an sa'on nan ayobhongan gway mangituyay san losanay taku tot losan gway intayo'nu an sa'on ma'awhijagcha an si'a as ingkaingkana kapu an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ad annaja nan pijaona anan nan ma'awhijakan an si'a as ingkaingkana gway ma'ahubuyunancha an si'a gway ahus as kadto'ay Apudyus ja an sa'onay Kristu gway ingwhaunnu. ");
INSERT INTO kyb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inchajaw'u si'a ad asna luta san namungpunga' san terwhasuway impa'gwam an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ad Ama, atchom asin an sa'on nan chajaw gway iniingkaw an sa'on san agwacha' an si'a san chaan ma'gwa nan luhung. ");
INSERT INTO kyb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Impaakammu' si'a sasan pinilim ad asna luhung gway intayo'nu an sa'on. Ugwam chicha kun intayo'nu chicha an sa'on kun pinaticha nan ukud'u. ");
INSERT INTO kyb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","San sana naakammugwancha gway losanay intayo'nu an sa'on nerpu an si'a ");
INSERT INTO kyb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kapu tan sa'ad nan ukudnu gway inatodnu an sa'on inatod'u hos an chicha kun tinuttuwacha ja kadto'ay inakammucha gway nerpuwa' an si'a kun tinuttuwachaay ingwhaunnus sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ilugwayuwa' chicha. Wha'on ku sasan achi mamati nan ilugwayuwa' jon chachay intayo'nu an sa'on kapu tan ugwam chicha. ");
INSERT INTO kyb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ad nan losanay ugwa', ugwam ja losanay ugwam, ugwa' kun nichajagwa' kapu an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wha'ona' kus iingkaw ad asna luta tan umaliya' an si'a gwon as chicha matchaychad asna luta. Ama gway agwad ad langit, whantajam chicha gway inatodnu an sa'on san pigsam gway sija ahos nan pigsa gway inatodnu an sa'on tot manosossaancha gway isuta. ");
INSERT INTO kyb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","San iniingkagwa' an chicha whinawhantaja' chicha san pigsam gway inatodnu an sa'on. Whinawhantaja' chicha kun maid kun nataya' as osa an chicha, maya'sig san ma'gwaniyon mataya' gway sija nan mantungpayan nan nilistaay ukudnu. ");
INSERT INTO kyb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“San sana umaliya' an si'a gwon iwhaka' nannachaja san annaa' ad asna luta tot mapachascha nan lagsa''u gway maid kun man'uyangana. ");
INSERT INTO kyb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inatod'u an chicha nan ukudnu kun inisil chanan takud asna luta gway achi kun mamati tan wha'oncha kus mijamung an chicha. Isu' chicha gway wha'ona' kus mijamung an chichaay achi kun mamati. ");
INSERT INTO kyb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Wha'on kus ochagwo' gway aanom chicha ad asna luhung jon whantajam chicha an Satanas. ");
INSERT INTO kyb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wha'oncha kus mijamung an chichaay achi kun mamati. Isu' chicha gway wha'ona' kus mijamung an chichaay achi kun mamati. ");
INSERT INTO kyb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","To'nom chicha as mansilwhi an si'a kapu san ukudnuway tuttuwa. ");
INSERT INTO kyb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Isun nan nangiwhaunam an sa'on sasan takuway achi kun mamati, amasna ahos nan oo'ay mangiwhaun an chicha sasan taku ad asna luhung. ");
INSERT INTO kyb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kapu an chicha atcho' nan whijag'u an si'a gway mansilwhi an si'a tot atchoncha hos nan whijagcha gway mansilwhi an si'a san ukudnuway tuttuwa.” ");
INSERT INTO kyb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Intuyuy Hesus mallugwayu gway manggwana, “Wha'on kus ahuscha as ilugwayuwa' jon ilugwayuwa' ahos chanan mamati an sa'on kapu san sussuyucha ");
INSERT INTO kyb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","tot losancha manosossaan isun nan annaam Ama an sa'on ja agwacha' an si'a ta agwadcha hos an chita tot tuttugwaon chanan taku ad asna luta gway achi kun mamati gway ingwhaunnus sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kun sa'ad nan nangichajagwam an sa'on sachi hos nan nangichajagwa' an chicha tot manosossaancha as isuta gway osossa''an. ");
INSERT INTO kyb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Agwacha' an chicha ja anna'a an sa'on tot maid man'uyangan nan manosossaanancha tot maakammugwan chanan takud asna luta gway achi kun mamati gway ingwhaunnus sa'on ja impatognu chicha as isun nan nangipatokam an sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, sa'ad chachay intayo'nu an sa'on whayugwo'ay nu agwan nan agwad'u, agwadcha otjan ahos an sa'on tot mailacha nan inachajaw'u say nangichajagwam an sa'on kapu tan impatognus sa'on san chaan ma'gwa nan luhung. ");
INSERT INTO kyb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama gway ustu nan o'oona, achi cha'a kun agakammu sasan takud asna luta gway achi kun mamati gwon akammu' si'a ad nan annachaja ahosay mamati an sa'on akammucha hosay ingwhaunnus sa'on. ");
INSERT INTO kyb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kun impaakammu' an chicha as si'a ad achiya' kun mampapokay mangipaakammu tot nan lajadnu an sa'on agwad an chicha ja annaa' ahos an chicha.” ");
INSERT INTO kyb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nappung kus Hesus nallugwayu lummajaw gway huyunna chanan pasuyutna gway ummoy san chomang nan challug gway Kidron gway agwachan nan kerchin kun sachi nan ummajancha sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sa'ad as Judas gway mangijiwhit an sija aagkammuna hos nan sachi kerchin tan ad aschi nan choon Hesus mangayusan sasan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Gwot ummoy as Judas ad aschi gway impujutna nan angsanay surchachuway iRoma ja nan uchumay mangijaachug san Templo gway ingwhaun chanan papangat nan papachi ja chanan Pariseo. Nansisillawcha ja naniispadacha. ");
INSERT INTO kyb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sa'ad tan aagkammun Hesus nan losanay ma'gwa an sija ummoy nijahot an chicha kun anana an chicha, “Ngachan nan anaponju?” ");
INSERT INTO kyb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ananchaay summungwhat an sija, “As Hesus gway iNazaret.” Kun anana an chicha, “Sa'on.” Ad sa'ad as Judas gway nangijiwhit an sija ni'aslang an chicha gway summisi'ad. ");
INSERT INTO kyb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Anan kun Hesus an chichaon “Sa'on”, nan'unudcha kun natu'angcha. ");
INSERT INTO kyb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kun asin Hesus inimus an chicha gway manggwana, “Ngachan nan anaponju?” Kun anancha, “As Hesus gway iNazaret.” ");
INSERT INTO kyb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kun anan Hesus gway summungwhat, “Ingwhaka' gway sa'on. Nu sa'on nan anaponju ijujajuway lumajaw nannachaja huhuyun'u.” ");
INSERT INTO kyb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ingwhakana nan annaja tot tumuttuwa chay innananaon, “Maid kun uyay osa as nataya' sasan intayo'nu an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Gwot sa'ad as Simon Pedro gway naniispada nilu'pusna nan ispadana kun iyayasna gwot napingasan nan machigwananay ingan nan mudchachun nan angatuwanay pachi. Malco nan ngachan nan sachiyay mudchachu. ");
INSERT INTO kyb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Gwon anan Hesus an Pedro, “Ijusu'nu nan ispadam san horjanna. Jo'o anam ekajon achi' ijuja nan sikab gway whayugwon Ama gway ma'gwa an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gwot sa'ad chachay angsanay surchachun nan iRoma ja nan pangatcha ancha chachay Hudyu gway mangijaachug san Templo, chimpapchas Hesus kun pinunguchas sija. ");
INSERT INTO kyb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kun ummunacha jan iyoy an Anas gway atukangan Caifas gway angatuwanay pachi san sachiyay tagwon. ");
INSERT INTO kyb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","As Caifas chay nangiwhaka san nugwan sasan Hudyu gway ununnayna nu matoy nan osa taku as humayugwan chanan losanay taku. ");
INSERT INTO kyb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa'ad as Simon Pedro ja nan osa ahosay pasuyut Hesus nituntunudcha an Hesus. Ad nan sachi osaay pasuyut aagkammun nan angatuwanay pachi, sija nan nijujaay na'erno' an Hesus san sowhan nan hoyoy nan angatuwanay pachi. ");
INSERT INTO kyb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Gwon natchay as Pedro gway summi'ad san lasin nan sagwang nan sowhan. Sija nan lummagwa chay osa pasuyut gway agakammun nan angatuwanay pachi kun na'aapapat san huwhaiyay mangijaachug san sagwang kun imperno'na as Pedro. ");
INSERT INTO kyb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kun anan chay huwhai an Pedro, “Ad achi si'a hos nan osa sasan pasuyut nan sachi taku?” Kun anan Pedro, “Wha'ona' kun.” ");
INSERT INTO kyb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mantakaliyong nan sachi chimpu kun nanapuy chachay mudchachu ja chachay mangijaachug san Templo as mananichuwancha kun nasi'asi'adcha mananichu. Kun ummoy ahos as Pedro na'asi'ad kun na'aanichu an chicha. ");
INSERT INTO kyb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kun sinumerjan nan angatuwanay pachi as Hesus san mipangkop sasan pasuyutna ja mipangkop san sussuyuna. ");
INSERT INTO kyb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kun anan Hesus gway summungwhat an sija, “Wha'on kus illi'ali'aw'u gway nanukud san losanay taku. Patinajuna'ay nansuyu sasan sinagoga ja san Templo gway maayuayusan nan losanay Hudyu. Maid kun inukud'u as nitayu sasan taku. ");
INSERT INTO kyb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kunja kamma imuson a sa'on? Imusom sasan takuway nanchongor an sa'on. Aagkammucha nan ingwhaka'.” ");
INSERT INTO kyb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Gwot ingwhakan kun Hesus na sachi sa'ad nan osa sasan mangijaachug san Templo gway summisi'ad, nilipa'na as Hesus gway manggwana, “Kamman amonsinatay sumungwhat san angatuwanay pachi?” ");
INSERT INTO kyb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Anan Hesus gway summungwhat, “Nu agwad ingwhaka' as lagwing pano'no'am nu ngachan nan ingwhaka' gway lagwing. Gwon nu ustu nan ingwhaka' kamma lipa'on as sa'on?” ");
INSERT INTO kyb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sachi kun impaijoy Anas as Hesus gway sissija natata''od an Caifas gway angatuwanay pachi. ");
INSERT INTO kyb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sissija as Simon Pedro gway summisi'ad gway manaannichu. Kun anancha an sija, “Ad achi si'a hos nan osa sasan pasuyutna?” “Wha'ona' kun,” anana gway nangisulib. ");
INSERT INTO kyb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sa'ad nan osa sasan mudchachun nan angatuwanay pachi gway chokan chay laya'iyay piningasan Pedro nan ingana, anana, “Tan si'a ka chay inila'ay huyunna san kerchin ja?” ");
INSERT INTO kyb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Gwon asin ahos Pedro insulib kun maag ekay nangu''uu' nan osaay awwit. ");
INSERT INTO kyb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kun illajawchas Hesus san hoyoy Caifas kun iyoycha san iingkagwan nan kuwhinnachur. Takangay as mawhikat san sachi. Gwon sa'ad chachay Hudyu achicha kun nilumno' san iingkagwan nan kuwhinnachur tan anna nan ukalichaay Hudyu gway ananchaon machimo'cha nu lumno'cha san hoyoy nan wha'on kus Hudyu ad maid kun ininonchaay ma'a'an san Pijasta gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sija nan lummagwa as Pilato gway kuwhinnachur kun anana an chicha, “Ngachan nan ipawhersujuway mihursu san annaja taku?” ");
INSERT INTO kyb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kun anancha gway summungwhat an sija, “Nu wha'on as lagwing nan o'oon nannaja taku achimi otjan iyali as sija an si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Gwot anan Pilato an chicha, “Ilajawjus sija ad inu'umjus sija san mijaya san illilintogju.” Kun anan chachay Hudyu an sija, “Wha'on kus mijuja an cha'ami gway otojonmi nan osa taku.” ");
INSERT INTO kyb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na'gwa nannaja ta tumuttuwa chay ingwhakan Hesus gway mipangkop san ininonaay matoy. ");
INSERT INTO kyb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nilumno' asin as Pilato san iingkagwana kun inajakana as Hesus kun inimusna gway manggwana, “Si'a nan Alin chanan Hudyu?” ");
INSERT INTO kyb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Anan Hesus gway summungwhat an sija, “Nerpu an si'a nan sanatay imusnu gwinnu agwad uchum as nangiwhaka an si'a san mipangkop an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kun anan Pilato, “Jo'o Hudyuwa'? Chanan ailijamay Hudyu ja chanan papangat nan papachi nan nangijali an si'a an sa'on. Ngachamma inggwamay?” ");
INSERT INTO kyb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Anan Hesus gway summungwhat, “Wha'on kud asna luhung nan agwachan nan mantuyaja'. Nu asna luhung nan mantuyaja' ma'apatoy chanan pasuyut'u tot achiya' ipawhijang sasan Hudyu. Gwon nan mantuyaja' wha'on kud asna luhung.” ");
INSERT INTO kyb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Gwot anan Pilato an sija, “Ad ali'aot?” Anan Hesus gway summungwhat, “Si'a nan nangiwhaka gway aliya'. Ummaliya' ad asna luhung ja nijana'a' tot ipano'no''u nan atuttugwaan. Nan losanay agwad san atuttugwaan manchongor san iwhaka'.” ");
INSERT INTO kyb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kun anan Pilato an sija, “Ngachamma nan atuttugwaan?” Nappung kun Pilato iwhaka nan sachi lummagwa asin gway ummoy say agwachan chanan Hudyu kun anana an chicha, “Maid kun inchasa' as mihursu an sija. ");
INSERT INTO kyb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gwon sa'ad nan atagwotagwonay Pijasta gway ma'gwaniyon Lumaus sija o'oo' nan umipayagwaa' an cha'aju as osa whayud. Adja whayugwonjuway ipayagwa' an cha'ajuway Hudyu nan Aliju?” ");
INSERT INTO kyb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sachi kun impa'uychaay manggwana, “Wha'on kus sija, as Barrabas nan whayugwonmi!” Sa'ad as Barrabas osaay mamayangkat gway achi kun umajun san kuwhilnu. ");
INSERT INTO kyb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gwot impasaplit Pilato as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ad sa'ad chanan surchachu nalli'uscha san sait kun iyakipurcha san wha''agna kun asichaot akojan san malluyom nan chayagna gway luput. ");
INSERT INTO kyb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kun asi'a'anancha, “Mawhiwhijag nan Alin nan Hudyu!” Kun nilipa'chas sija. ");
INSERT INTO kyb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kun lummagwa asin as Pilato kun anana sasan taku, “Chongyonju, paijali' as Hesus an cha'aju tot maakammugwanjuway maid kun inchasa' as mihursu an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kun lummagwa as Hesus gway nawhawhalli'usan nan wha''agna san sait ja naaagkojan san malluyom nan chayagna gway luput. Kun anan Pilato an chicha, “Annaja as sija!” ");
INSERT INTO kyb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gwot inilan ad chachay papangat nan papachi ja chachay mangijaachug san Templo as sija inip'awcha gway manggwana, “Pailansam san krus as sija! Pailansam san krus as sija!” Anan Pilato an chicha, “Ilajawjus sija ad cha'aju ekay nan mangilansa an sija san krus tan maid kun inchasa' as whersuna.” ");
INSERT INTO kyb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Anan chachay Hudyu an sija gway summungwhat, “Anna san lintogmi gway maserpu matoy as sija kapu tan ingwhilangna nan longagna as Ana' Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chingngorn kun Pilato chi ummamamod nan ogjatna ");
INSERT INTO kyb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kun nanagkulin asin ad chayo' san iingkagwana kun inimusna an Hesus gway manggwana, “Agwan nan kadto'ay nerpugwam?” Gwon maid kun insungwhat Hesus an sija. ");
INSERT INTO kyb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sija nan anan Pilato an sija, “Ka'a achi sumungwhat an sa'on? Achim akammuway anna nan ayobhonga'ay mangipayagwa an si'a ja mangipailansa an si'a san krus?” ");
INSERT INTO kyb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Anan Hesus gway summungwhat an sija, “Maid kun ayobhongam an sa'on nu achin Apudyus inatod an si'a. Sija nan sa'ad nan nangijali an sa'on an si'a cha'or nan whersuna nu si'a.” ");
INSERT INTO kyb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chingngorn kun Pilato chi whayugwona gway payuhusan as Hesus. Gwon inip'aw chachay Hudyu gway manggwana, “Nu payuhusam nan sanatay taku wha'on'a kus hubuyun nan Emperador. Nu ngachan nan mangiwhilang san longagna as ali humursu san Emperador.” ");
INSERT INTO kyb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chingngorn kun Pilato nan anancha impayagwana as Hesus kun ummoy tummu'chu san uu''uman gway ma'gwaniyon Chapinajay Whatu (san Hinebreo gway apapat, Gabata). ");
INSERT INTO kyb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Takangay as mamatu' nan sachi chimpu gway lukin nan mansakanaan chanan Hudyu san Pijasta gway ma'gwaniyon Lumaus. Kun anan Pilato sasan Hudyu, “Annaja nan aliju!” ");
INSERT INTO kyb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gwon impa'uycha gway manggwana, “Ipaotoynus sija! Ipaotoynus sija! Pailansam san krus!” Anan Pilato an chicha, “Whayugwonju pailansa' san krus nan aliju?” Kun anan chachay papangat nan papachi gway summungwhat, “Maid kun uchum as alimi nu achi ahus nan Emperador!” ");
INSERT INTO kyb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Anunu kun chadlu impawhijang Pilato as Hesus an chicha tot milansa san krus. Sachi kun illajawcha as Hesus ");
INSERT INTO kyb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","gway whinuhu'udna nan krusna kun lummagwaay ummoy san ma'gwaniyon Ikaw nan Tungern nan Wha''ag gway anancha san apapatay Hebreon Golgota. ");
INSERT INTO kyb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ad aschi nan nangilansaancha an sija san krus. Kun iningkaw nan chugwa laya'iyay illansacha san krus, osa san machigwananna ja osa san machigwikina. ");
INSERT INTO kyb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Iningkaw ahos nan impailistan Pilato kun inigkacha san krus gway anana, “Hesus gway iNazaret, nan Alin chanan Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kun angsan sasan Hudyu nan namasa sannaja tan achani san ili nan nilansaan Hesus san krus. Nilista nannaja san tuyu ayasiyay apapat gway Hebreo, Latin ja Griego. ");
INSERT INTO kyb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gwot anan chanan papangat nan papachin chanan Hudyu an Pilato, “Achim ilista nan, ‘Nan Alin chanan Hudyu’ jon sija ilistam nan, ‘Anan nannaja taku, sa'on nan Alin chanan Hudyu.’ ” ");
INSERT INTO kyb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Anan Pilato gway summungwhat, “Nu ngachan nan illista' sija nan nilista.” ");
INSERT INTO kyb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Gwot sa'ad chanan surchachu nappungcha kun ilansa san krus as Hesus, inayacha chanan silupna kun kiniskis'icha nan'apaton sininnossa. Inayacha hos nan lagkoyloy gway akoyna gwon maid kun chaitna gway nayaka ad ngatu ingkanad choya. ");
INSERT INTO kyb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Gwot asi'a'anancha, “Achi ta'u whiswhis'iyon nan akoyna jon mangwhiwhinnunut ta'u nu ngachan nan mangin'ugwa.” Na'gwa nannaja tot tumuttuwa nan nilista san Ukud Apudyus gway anana, “Whiniwhillaycha chanan silup'u ad sa'ad nan lagkoyloy gway akoy'u nangwhiwhinnunutancha.” Gwot amaschi nan inggwan chanan surchachu. ");
INSERT INTO kyb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gwon agwachay summisi'ad san achani san krus Hesus as inana ja nan sunud inana ja as Maria gway asagwan Cleofas ja as Maria gway iMagdala. ");
INSERT INTO kyb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sija nan inilan kun Hesus nan inana ja nan pasuyutay ipatpatogna anana an inana, “Chongyom na, iwhilangnus sija as ana'nu.” ");
INSERT INTO kyb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Gwot anana say pasuyut, “Chongyom na, iwhilangnus sija as inam.” Kun malluki san sachi inajakan nan sachi pasuyut nan inan Hesus gway mi'ahumerjan an sija. ");
INSERT INTO kyb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Aagkammun kun Hesus gway nappung na'gwa nan losan anana, “Nauwagwa'.” (Ingwhakana nannaja tot tumuttuwa nan nilista san Ukud Apudyus.) ");
INSERT INTO kyb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iningkaw nan hurnay gway nisasaad ad aschi gway napnu san na'ilomay whajas. Kun insagnongcha san na'ilomay whajas nan ispongha kun iyipitcha san tannuhung kun iyadchangcha san tupo'na. ");
INSERT INTO kyb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tinamtaman kun Hesus nan na'ilomay whajas anana, “Napungpung nan losan.” Kun nanchumug kus sija na'anut nan angosna. ");
INSERT INTO kyb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kapu tan erkaw gway mansakanaan san Pijastaay ma'gwaniyon Lumaus nan sachi erkaw, sa'ad chanan papangat nan Hudyu ingwhakacha an Pilato gway magtod nan i'in chachay nilansa san krus ja maopas nan lachagcha. Ingwhakacha nannaja tan lagwingonchaay iingkaw chanan lachag san krus san Erkaw gway Umillongan tan napatog nan sachiyay Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sija nan ummoy chachay surchachu kun kintodcha nan i'in chachay chugwa laya'iyay huyun Hesus gway nilansa san krus. ");
INSERT INTO kyb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Gwon niwhatugcha kun an Hesus gwot inilachaay naahus natoy as sija achicha kun kintod nan i'ina. ");
INSERT INTO kyb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gwon sa'ad nan osa sasan surchachu jinuju'na nan huti' Hesus san tuwhay kun nawhanushus nan chaya ja chanum. ");
INSERT INTO kyb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ad sa'ad chay nangila san na'gwa impaakammuna na kun tuttuwa nan impano'no'na. Kun akammuna gway tuttuwa nan iwhakawhakana tot mamati aju hos. ");
INSERT INTO kyb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na'gwa nannaja tot tumuttuwa nan nilista san Ukud Apudyus gway anana, “Maid kun osas tungerna as magtod.” ");
INSERT INTO kyb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ja agwad ahos nan sawhali nilista san Ukud Apudyus gway anana, “Ilancha as sija gway chay jinuju'cha.” ");
INSERT INTO kyb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nappung kun chi sa'ad as Josep gway i'jArimatea ummoy nampayang an Pilato ta umoyna ayan nan lachag Hesus. Kun iyujan Pilato, sija nan ummoy as Josep kun inayana nan lachag Hesus. Sa'ad as Josep osa as sija gway pasuyut Hesus gwon achina kun impaakammu san aachugwan tan umogjat sasan papangat nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kun na'ooy ahos as Nicodemo gway chay ummoy na'aapapat an Hesus san nugwan san osa lawhi. Nanaawwit as sija san whangwhangyuway nan'ayut san mirra ja aloe gway ummoy as tuyumpuyu ja chugwa ilu. ");
INSERT INTO kyb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kun inayacha nan lachag Hesus kun whinichiwhichancha san nanginaay luput gway na'gwaan san whangwhangyu tan sachi nan ukalin chanan Hudyu nu ilhoncha nan matoy. ");
INSERT INTO kyb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ad iningkaw san achani san sachiyay nilansaan Hesus san krus nan osa kerchin. Ad san sachi kerchin iningkaw nan a''opgwa lijangay lohon gway maid kun nii''ilhon as taku. ");
INSERT INTO kyb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gwot kapu tan mawhikat ad Erkaw gway Umillongan ja kapu tan achani nan sachi lijangay lohon, inilhoncha as Hesus san sachi. ");
INSERT INTO kyb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gwisnigwisnit kun san Chumingku sa'ad as Maria gway iMagdala anajun ummoy san lijangay lohon kun inilanaay naalikad nan whatuway onob nan lohon. ");
INSERT INTO kyb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sija nan nanodcha'ay ummoy an Simon Pedro ja osa pasuyut gway chay ipatpatog Hesus. Kun anana an chicha, “Inayacha as Apu Hesus san lohonna kun achimi kun akammu nu agwan nan nangijajancha an sija.” ");
INSERT INTO kyb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sija nan lummagwa cha Pedro ja chay osa pasuyut kun ummoycha san lijangay lohon. ");
INSERT INTO kyb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kun nanodcha'chaay chugwa gwon sa'ad chay osaay pasuyut kapu tan whi'as ummuna chummakus an Pedro san lijangay lohon. ");
INSERT INTO kyb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kun nayyu'ungay nangisiim ad chayo' kun inilana nan niwhawhannatay luput gwon achi kun nilumno' as sija. ");
INSERT INTO kyb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Gwot hummu'nag ahos as Pedro gway misu'su'nub an sija kun nanchachawwos ad chayo' say lijangay lohon. Kun inilana nan luputay niwhawhannat ");
INSERT INTO kyb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ja chay panjuway nihungut san wha''ag Hesus. Achi kun nijamung say luput gwon nayu'ut gway nat'on san sawhali. ");
INSERT INTO kyb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Gwot nilumno' ahos chay osaay pasuyut gway chay ummuna hummu'nag san lohon kun inilana kun namati as sija. ");
INSERT INTO kyb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tan sissija chaancha maagwatan nan nilista san Ukud Apudyus gway ananaon maserpu mataku as sija. ");
INSERT INTO kyb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sachi kun lummajaw chachay chugwaay pasuyut. ");
INSERT INTO kyb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Gwon sa'ad as Maria summisi'ad gway maniwhiiwhil san pagway nan lijangay lohon. Ad sa'ad san maniwhiiwhilana nayyu'ungay nangisiim ad chayo' san lohon ");
INSERT INTO kyb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kun inilana nan chugwa anghel gway nansisillupchas man'aputaa' gway tummutu'chucha san niwhanatan nan lachag Hesus. Na osa tummutu'chu san ullunganna ad nan osa san i''ijanna. ");
INSERT INTO kyb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kun inimuscha an sija gway manggwana, “Ka'a man maniwhiiwhil?” Kun anana an chicha, “Illajawcha nan Apu' kun achi' kun akammu nu agwan nan nangijajancha an sija!” ");
INSERT INTO kyb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ingwhakana kunan sachi nantulili as sija kun inimatunanas Hesus gway summisi'ad gwon achina kun illasinay sija as Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kun anan Hesus an sija, “Ka'a man maniwhiiwhilay? Ngachan nan anaanapom?” Anan eka Mariaon sija nan mangkerkerchin, sija nan anana an sija, “Apu, nu illajawnus sija iwhakam nu agwan nan nangijajam an sija ta iya' ayan.” ");
INSERT INTO kyb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kun anan Hesus an sija, “Maria!” Nansakung kus Maria an sija anana san apapatay Hebreo, “Rabboni!” (Nan pijaona anan “Mistuyu”.) ");
INSERT INTO kyb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Anan Hesus an sija, “Achiya' kun ipukod tan chaana' kun umoy managkulin an Ama. Gwon i'a sasan susunud'u ad ingwhakam gway iya' managkulin an Ama ja Amaju gway Apudyus'u ja Apudyusju.” ");
INSERT INTO kyb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kun ummoy Maria gway iMagdala ingwhaka sasay pasuyut gway manggwana, “Inila' nan Apu.” Kun ingwhakana an chicha nan ingwhakan Hesus an sija. ");
INSERT INTO kyb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lawhi kun san sachiyay erkaw gway Chumingku naayus chachay pasuyut san hoyoy gway nicha'ig nan onobna tan umogjatcha sasan Hudyu. Ummoy kun as Hesus summi'ad san kagwacha, anana an chicha, “Ta'okot nu whayu nan somsomo'juway maid machanakanju.” ");
INSERT INTO kyb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ingwhakana kunan sachi impailana nan imana ja huti'na an chicha. Amod nan lagsa' chachay pasuyut san inilacha nan Apu. ");
INSERT INTO kyb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Gwot inasin Hesus anan an chicha, “Ta'okot nu whayu nan somsomo'juway maid machanakanju. Isun nan nangiwhaunan Ama an sa'on, amasna ahos gway iwhaun'u cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ingwhakana kunan sachi sinapujana chicha kun anana an chicha, “Ajakanju nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nu ligwatanju nan whersun nan sinusnatay taku naligwatan nan whersucha. Nu sissija achiju ligwatan nan whersucha sissija achi kun maligwatan nan whersucha.” ");
INSERT INTO kyb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sa'ad as Tomas gway osa sasan nasagwayan as chugwa pasuyut gway ananchaon Apa', maid ku an chicha san nampailan Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kun anan chachay uchumay pasuyut an sija, “Inilami nan Apu.” Gwon anan Tomas an chicha, “Nu achi' ilan ja apu'apon nan inoy nan lansa san imana ja ognan nan huti'na achiya' kun kadto' mamati.” ");
INSERT INTO kyb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Asin kunay Chumingku naayus asin chachay pasuyutna san hoyoy kun iningkaw as Tomas an chicha. Ummoy as Hesus ta'on nu nacha'ikan nan onob kun anana an chicha, “Ta'okot nu whayu nan somsomo'juway maid machanakanju.” ");
INSERT INTO kyb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sachi kun anana an Tomas, “Igkam nan imam san ima' ad inilam. Ijaggwangnu nan imam san huti''u ad inognam ad iyakaynuway manchugwachugwa ad namati'a!” ");
INSERT INTO kyb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kun anan Tomas gway summungwhat an sija, “Si'a nan Apu' ja Apudyus'u!” ");
INSERT INTO kyb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Anan Hesus an sija, “Kapu tan inilam as sa'on mamati'a? Piyan nan whijag chanan namati ta'on nu achicha inila as sa'on.” ");
INSERT INTO kyb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Angsan nan uchumay mataakan gway inggwan Hesus san agwachan chanan pasuyutna gway achi kun nilista san annaja nibyu. ");
INSERT INTO kyb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gwon nilista nannachaja ta tuttugwaonjuway as Hesus nan Kristu gway Ana' Apudyus ja kapu san pammatiju an sija ma'awhijag aju an Apudyus as ingkaingkana. ");
INSERT INTO kyb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nappung ku amana erkaw nampaila asin as Hesus sasan pasuyutna san whaywhay gway Tiberias. Amasna nan ininona nampaila. ");
INSERT INTO kyb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nahuyog cha Simon Pedro, Tomas (gway ananchaon Apa'), Natanael gway iCana ad Galili, chanan ana' Zebedeo ja nan chugwa ahosay pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kun anan Simon Pedro an chicha, “Iya' mangi'an.” Anancha an sija, “Umali ami hos an si'a.” Ummoycha namang'a kun nilabyawhichaay nangi'an gwon maid kun inayacha. ");
INSERT INTO kyb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gwisnit kun agwad as Hesus gway summisi'ad san tayantag gwon achin ku chachay pasuyutna naimatunan as sija. ");
INSERT INTO kyb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kun anan Hesus an chicha, “Huhuyun, agwad inayajus i'an?” Anancha an sijaay summungwhat, “Maid kun.” ");
INSERT INTO kyb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kun anana an chicha, “Itoperju nan akaidju san machigwanan nan whang'a ad anna nan maayaju.” Kun intopercha nan akaid kun kapu tan amod nan i'anay naaya achicha kun ma'agud. ");
INSERT INTO kyb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sa'ad chay pasuyut gway ipatpatog Hesus anana an Pedro, “As Apu chi!” Chingngorn kun Simon Pedro gway as Apu chi in'akoyna nan kotap nan silupna tan nampoponnas as sija kun pinumsu' san chanum. ");
INSERT INTO kyb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gwon sa'ad chachay uchumay pasuyut namang'achaay misu'su'nub gway mangita'chang say akaid gway napnu san i'an. Wha'oncha kus achaju san tayantag, ummoy as singkasutay sumi'u nan aachajuna. ");
INSERT INTO kyb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tumma'changcha kun san tayantag inilacha nan humayawhaya uling ja nan i'an gway nichachagwis ja nan tinapay. ");
INSERT INTO kyb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kun anan Hesus an chicha, “Umijali aju san i'anay a''aayaju.” ");
INSERT INTO kyb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kun ummoy as Simon Pedro san whang'a kun inta'changna nan akaichay napnu san chacha''orray i'an, singkasut ja limampuyu ja tuyu nan amungna. Ta'on nu amod nan inaachucha achi kun nabsat nan akaid. ");
INSERT INTO kyb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kun anan Hesus an chicha, “Gwayyu ta manugcha aju.” Gwon maid kun osa sasay pasuyutna as nangituyochay nangimus an sija gway manggwana, “Ngachan'a?” Kapu tan akammuchaay sija nan Apu. ");
INSERT INTO kyb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kun inayan Hesus nan tinapay kun inatodna an chicha ad isuna hos san i'an. ");
INSERT INTO kyb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Annaja nan mi'atluway nampailan Hesus sasan pasuyutna nalluki san natakuwana san natojana. ");
INSERT INTO kyb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nappungcha kun nanugcha anan Hesus an Simon Pedro, “Simon gway ana' Juan, ad ipatpatognus sa'on as amamod nu nan annachaja?” Anan Pedro an sija, “Oon Apu, akammumay ipatpatog'us si'a.” Kun anan Hesus an sija, “Whantajam chanan mamati an sa'onay isun nan uyhunay kernero.” ");
INSERT INTO kyb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kun piniggwan Hesus gway manggwana, “Simon gway ana' Juan ad ipatpatognus sa'on?” Anan Pedro an sija, “Oon Apu, akammumay ipatpatog'us si'a.” Kun anan Hesus an sija, “Whantajam chanan mamati an sa'on gway isun chanan kernero.” ");
INSERT INTO kyb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kun pinitlun Hesus anan an sija, “Simon gway ana' Juan, ad ipatpatognus sa'on?” Kun lummagwing nan somsomo' Pedro san impitlun Hesus anan an sijaon, “Ad ipatpatognus sa'on?” Kun anan Pedro an sija, “Apu, akammum nan losan. Akammumay ipatpatog'us si'a!” Kun anan Hesus an sija, “Whantajam chanan mamati an sa'on gway isun chanan kernero. ");
INSERT INTO kyb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iwhaka' an si'a nan tuttuwa: Sa'ad san amernusnu si'a ekay mangigka san silupnu ad ummoy'a san whayugwomay ajan. Gwon nu mumangorrag'a ujachom nan imam ad sawhali nan mangigka san silupnu ja mangijoy an si'a san lagwingomay ajan.” ");
INSERT INTO kyb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ingwhakana na ta ipaakammuna nan ininon Pedro gway matoy as mangichajagwana an Apudyus. Nappung kun Hesus iwhaka chi anana an Pedro, “Tunuchona'.” ");
INSERT INTO kyb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nantulili kus Pedro inilanaay misu'su'nub chay pasuyut gway ipatpatog Hesus gway chay nisachag san whayu'ung Hesus san udchin nan nanganancha san lawhi ja nangimusay manggwana, “Apu, ngachan nan mangijiwhit an si'a?” ");
INSERT INTO kyb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Inilan kun Pedro chay sachiyay pasuyut anana an Hesus, “Apu, ngachanma ma'gwa an sija nu'?” ");
INSERT INTO kyb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Anan Hesus an sija, “Nu whayugwo' as sija gway sissija matattaku ingkana san managkulina', maid kun whijangnus na. Mitunud'a an sa'on!” ");
INSERT INTO kyb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kapu sanna ingwhakan Hesus nanchinamag sasan namati an sija gway sa'ad nannaja pasuyut achi kun matoy. Gwon wha'on kus sija ingwhakan Hesus nan achi kun matoy nannaja taku gwon anana ekay, “Nu whayugwo'ay sissija matattaku nannaja taku ingkana san managkulina', maid kun whijangnus na.” ");
INSERT INTO kyb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sijana chay pasuyut gway chay nangipano'no' san mipangkop san annachaja ja nangilista ahos sannachaja. Akammumi hosay kadto' nan impano'no'na. ");
INSERT INTO kyb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Angsan ahos nan uchumay inggwan Hesus gway nu nilistacha nasinnossa, nan manomsom'a' achi kun nin umanay nannaja luhung as ingkagwan chanan anibyunibyuway milistaancha.");
INSERT INTO kyb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nachajaw gway Teofilo, sa'ad chay chamuway nibyu' inuullit'u nan losanay inggwa'inggwan Hesus ja chanan insuyusuyuna nalluki san chimpuway nangilukijana ");
INSERT INTO kyb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ingkana san erkaw gway nipangatuwan Hesus ad langit. Sa'ad san chaanna mipangatuwan pinuyungna chanan pinilinaay apostoles kapu san ayobhongan nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nappung kunan natojana na'aya'ayasi nan in'amanna nampaipaila an chicha tot agwad mamatiyancha gway nataku as sija. Ummoy as opat puyuway erkaw nan nampaipailan Hesus sasan apostolesna. Ingwhakana an chicha nan mipangkop san Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sa'ad san namingsanay naamungancha pinuyung Hesus chicha gway manggwana, “Achi aju lumajaw ad asnaay Jerusalem gwon uyajonju jan nan atchon Ama an cha'aju gway chay ingwhaka' gway ingwhawhagkana an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tan as Juan chanum nan inghonjagna san taku gwon wha'on kus mawhajag ad sa'ad as cha'aju mahonjakan aju san Ispilitun Apudyus gway nan pijaona anan ipaalina nan Ispilituna an cha'aju.” ");
INSERT INTO kyb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sa'ad san naamungan chanan apostoles nanimuscha an Hesus gway manggwana, “Apu, ad sana nan mangipagkulinam asin san mantuyajan chanan ijIsrael?” ");
INSERT INTO kyb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kun anan Hesus an chicha, “Sa'ad as cha'aju achi kun nipacha''an nan chimpuway ma'ma'gwa gway ahus ekas Ama as sillobhongay manggwa. ");
INSERT INTO kyb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gwon maatchan aju as ayobhongan san umaliyan nan Ispilitun Apudyus an cha'aju. Ad cha'aju nan mangipano'no' an sa'on sasan taku ad Jerusalem, Judea, Samaria ja ingkana san losanay ili san luhung.” ");
INSERT INTO kyb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nappungna kun iwhaka nan sachi nipangatu as sija ad langit. Gwot tinatangadchas sija ingkanas nalingwhan san hunot. ");
INSERT INTO kyb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mantatangadcha kunay mangiila san aysanan Hesus maag ekay nasani'ad san agwachancha nan chugwa laya'iyay nansisillup san puta'. ");
INSERT INTO kyb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kun anancha, “Cha'ajuway iGalili, ka'ajuman masi'asi'ad gway mantatangad ad langit? Nan sachi Hesus gway nipangatu ad langit mana''ulin ahos as isun nan nangilanju san ummajana ad langit.” ");
INSERT INTO kyb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kun nana''ulin chanan apostoles ad Jerusalem gway nerpu san whilig gway ma'gwaniyon Olibu. Osa kilometro nan aachajun nan sachiyay whilig san ili. ");
INSERT INTO kyb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hummu'nagcha kun ad Jerusalem ummoycha san nangngatuway ugwertun nan hoyoy gway iningkagwancha. Sa'ad chanan naayus cha Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago gway ana' Alfeo, Simon gway Zelotes ja Judas gway ana' Santiago. ");
INSERT INTO kyb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nannachaja losan patinajuncha manosossaanay mallugwayu. Nitapi ahos nan uchumay hubhuwhai ja as Maria gway inan Hesus ja chanan lallaya'iyay susunudna. ");
INSERT INTO kyb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iningkaw nan namingsanay naamung chanan namatiyay ummoy as singkasut ja chugwampuyu nan whilangcha kun summi'ad as Pedro gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Susunud, maserpuway tumuttuwa chay Ukud Apudyus gway impailistan nan Ispilitun Apudyus an Dabid mipangkop san ma'gwa an Judas gway chay nangipujut sasay nanpap an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sikud gway huyunmis sija gway apostol gway mansilsilwhi an Hesus.” ");
INSERT INTO kyb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Sa'ad as Judas illa'unas luta nan tangchanna san lagwingay inggwana. Ad san sachi luta naotchag as sija gway ummuna nan wha''agna kun nabta' nan husugnaot nihu'allay nan whakisna. ");
INSERT INTO kyb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chingngorn kunan losanay takud Jerusalem nan na'gwa nginadnancha nan sachi luta as Akeldama gway nan pijaona anan, “Luta gway Nachayaan.”) ");
INSERT INTO kyb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kun intuyuy Pedro gway manggwana, “Agwad nan nilista san nibyun nan Salmo gway ananaon, ‘Mawhaagwan otjan nan hoyoyna, Ad maid kun ingkaw san chayo'na.’ “Agwad ahos nan osa gway nilista gway anana, ‘Agwad otjan sawhali as mangaya san whijangna.’ ");
INSERT INTO kyb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Sija nan pumili ta'u otjan as osas michoka an chita'uway nasagwayan as osa gway apostoles as mangipano'no' san natakuwan Hesus. Ad maserpu osa sasan huyun ta'uway nansilwhi an Apu Hesus san losanay chimpuway iniingkagwan Hesus an chita'u manipud san namonjakan Juan an Hesus ingkana san nipangatuwanad langit.” ");
INSERT INTO kyb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kun chugwaay laya'i nan ingwhakacha, as Jose gway ananchaon Barsabas gway mangngachan ahos as Justo ja as Matias. ");
INSERT INTO kyb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gwot nallugwayucha gway manggwana, “Apudyus, si'a nan mangakammu san somsomo' nan losanay taku, ipailam an cha'ami nu ngachan nan pinilim sasan chugwaanna ");
INSERT INTO kyb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","as mansilwhi as apostol gway misu'at an Judas san terwhasuway tinaynana tan ummoy san ingkagwanaay nijallana.” ");
INSERT INTO kyb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kun nangwhiwhinnunutchaot Matias nan napili kun sija nan nitapi sasan nasagwayan as osaay apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sa'ad san hummu'nakan nan Pijasta gway ma'gwaniyon Pentecostes, naayus losan chanan namati san osa hoyoy. ");
INSERT INTO kyb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kun maag ekay iningkaw nan manawhawhayug gway nerpud langit gway amas awhayug nan napigsaay tungnin ad nagngor san intiluway chayo' nan hoyoy gway iningkagwancha ");
INSERT INTO kyb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ja iningkaw chanan amas apuy gway ummoy nasinnossa nigwayas ja ummoy san gwaschi osa an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kun ummoy nan Ispilitun Apudyus an chicha losan gwot illukichaay kuminga san uchumay na'aya'ayasi apapat kapu tan inatchan nan Ispilitun Apudyus chicha as ayobhonganay manapapat. ");
INSERT INTO kyb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sa'ad san sachi chimpu iningkaw ahos ad Jerusalem chanan Hudyu gway mangikakadto' san pammaticha gway nerpu san na'aya'ayasiyay ili san luhung. ");
INSERT INTO kyb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chingngorcha kun chay awhayug nangwhinu'nag chanan angsanay taku san sachi hoyoy. Kun nataagcha losan tan gwaschi osa an chicha chongyoncha chachay namati gway manapaapat san ugwachaay apapat. ");
INSERT INTO kyb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nataagchas amod gway manggwana, “Jo'o wha'on as iGalili nannatchaja asijaapapatay. ");
INSERT INTO kyb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kunja kamaangkay gwaschi osa an chita'uwon chochongyon ta'u chicha gway kuminga sasan apapat ta'u? ");
INSERT INTO kyb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Agwad an chita'u chanan iPartia, iMedia, ijElam, iMesopotamia, iJudea, iCapadocia, iPonto ja ijAsia. ");
INSERT INTO kyb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Anna ahos chanan iFrigia, iPamfilia, ijEgipto ja chanan nerpu san sa'upon nan Libya gway achani ad Cirene. Ja anna ahos chanan mangiliyay nerpud Roma gway Hudyu nan uchum ja wha'on kus Hudyu nan uchum gway nangngachan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nerpu ahos nan uchum ad Creta ja Arabia. Chochongyon ta'u chicha gway kuminga san apapat ta'u mipangkop san mataakan gway inggwa'inggwan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nataagcha losan ja achicha kun maagwatan nan na'gwa, sija nan nanisijimuschaay manggwana, “Ngachan nan pijaon nina anan?” ");
INSERT INTO kyb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gwon iningkaw nan uchumay nangamamang sasay namati an Hesus gway manggwana, “Nahutong nannatchaja taku!” ");
INSERT INTO kyb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Gwon summi'ad as Pedro ja chanan nasagwayan as osa apostoles kun tinowhagna kumminga gway manggwana, “Ailija'ay Hudyu ja cha'ajuway iningkaw ad asnaay Jerusalem! Chongyonju ad, ipaagwat'u an cha'aju nan pijaon nina anan! ");
INSERT INTO kyb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wha'on kus nahutong nannachaja taku tan amas agwad mahutong san suminer! ");
INSERT INTO kyb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gwon nan annajaay na'gwa, sijana nan tummuttugwaan nan ingwhakan profeta Joel san agwi gway anana: ");
INSERT INTO kyb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anan Apudyus: Amasna nan oo' nu takangay nan humu'nakan nan anungus nan erkaw. Nachayaa' gway mangatod san Ispilitu' san losanay taku. Ad sa'ad chanan anana'ju ipaakammu' chanan paiwhaka' an chicha. Ad sa'ad chanan whabwhawhayuju agwad nan mailacha gway ipaila' an chicha. Sa'ad chanan man'amangorragju agwad nan ininponcha gway ipaininop'u an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Isun ahos chanan mudchachu' gway lallaya'i ja hubhuwhai, Atcho' hos nan Ispilitu' an chicha Ad impaakammucha nan paiwhaka' an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Agwad nan ipaila' gway mataakan ad langit. Isuna hos san luhung gway agwad nan ipaila' gway mangimatunan gway chaya, apuy ja amochay asu'. ");
INSERT INTO kyb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ad hummulingot nan init, Ad chummayag nan huyanay amas chaya. Ad asiyot humu'nag nan apatkan ja umma'allasi awhayugwanay erkaw gway umaliyan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ad ngachanna manay takuway man'ochaw san achakun Apudyus, mataku.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kun intuyuy Pedro gway manggwana, “Susunud gway ijIsrael, chongyonju nan annaja iwhaka'. Sa'ad as Hesus gway iNazaret impano'no' Apudyus an chita'u kapu sasan na'na'gwa gway mataakan ja chanan mangimatunan gway inggwan Apudyus kapu an sija. Akammuju tan na'na'gwa chachi san agwachan ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ad nan sachiyay Hesus gway inatodna an cha'aju tan sachi nan sikud gway pangkop Apudyus, impailansaju sasan wha'on kus Hudyu san krus. Intoyyu as sija. ");
INSERT INTO kyb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gwon tinakun Apudyus as Hesus gway gwinajagwajaana san ayobhongan nan otoy tan maid kun ayobhongan nan otoy gway mangipaggwod an sija. ");
INSERT INTO kyb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tan ingwhakan Dabid san agwi nan mipangkop an Hesus gway anana, ‘Akammu' gway patinajunay agwad as Apudyus gway iingkaw an sa'on tan anna as sija san machigwanan'u ad achiya' kun umogjat. ");
INSERT INTO kyb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sija nan nayagsa' nan somsomo''u ja mallaylajacha' gway manchaychajaw an si'a tan anna nan namnamao' san longag'u. ");
INSERT INTO kyb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tan achim taynan nan alichodgwa' san ikaw nan natoy ja achim kuhos ijujaay mahuju' nan longag nan Mansilsilwhiyom gway maid whersuna. ");
INSERT INTO kyb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impaakammum an sa'on nan ininonay ma'awhijag an Apudyus as ingkaingkana. Mallaylajacha' tan anna'a an sa'on.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kun intuyuy ahos Pedro gway manggwana, “Susunud, tuttuwa nannaja iwhaka' an cha'aju mipangkop an Dabid gway nerpugwan ta'u. Natoy as sija kun niilhon ad san sana sissija maila ta'u nan lohonna sannaja ikaw ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kapu tan osa as sija gway profetan Apudyus akammuna nan ingwhawhagkan Apudyus an sija gway osa sasan kana'na nan mangngachan ali san umaliyay erkaw. ");
INSERT INTO kyb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nipacha''an an Dabid nan ma'gwa gway mataku nan Kristu gway manaku sasan taku. Sachi nan inukudna gway ananaon, ‘Achi' kun taynan as sija ad Hades gway ingkagwan nan natoy ja achi kuhos mahuju' nan longagna.’ ");
INSERT INTO kyb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Nan sachiyay Hesus tinakun Apudyus. Ad cha'ami losan nan nangila san natakuwana. ");
INSERT INTO kyb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ad kapu tan nipangatu as Hesus gwot agwad san machigwanan Apudyus chinagwatna nan merpu an Apudyus gway Amana nan Ispilitun Apudyus gway ingwhawhagkana. Kun impaalin Hesus gway ma'ayongag an cha'ami gway sachi nan inilaju ja chingngorju san sana. ");
INSERT INTO kyb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tan wha'on kus Dabid nan ummoy ad langit gwon anan Dabid, ‘Anan Apudyus san Apu' tumu'chu'a san machigwanan'u ");
INSERT INTO kyb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ingkanas ipaawha''u an si'a chanan ahursum ad isucha nan layappangan nan i'im.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sachi kun anan Pedro, “Sija nan chita'u losanay ijIsrael maserpuway akammugwon ta'u gway sa'ad nan sachiyay Hesus gway illansaju san krus, sija nan nangngachanon Apudyus as man'Apu ta'u ja sija ahos nan Kristu.” ");
INSERT INTO kyb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chingngorn ku chanan taku nan sachi nasakid nan somsomo'cha. Kun anancha an Pedro ja chanan uchum gway apostoles, “Susunud, ngachan maangkay oonmi?” ");
INSERT INTO kyb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kun summungwhat as Pedro an chicha gway manggwana, “Manchu'kanju chanan whersuju ad nampahonjag nan gwaschi osa an cha'aju gway mangipaakammu gway Apuju as Hesu Kristu tot ligwatan Apudyus nan whersuju ad chagwatonju nan Ispilitun Apudyus gway atchona gway maid kun oyosna. ");
INSERT INTO kyb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tan ingwhawhagkan Apudyus ta'u nan sachi an cha'aju ja sasan kana'ju ja mitapi ahos losan chanan agwad sasan achajuway inailin chi ili san losanay ajakana.” ");
INSERT INTO kyb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Angsan nan ingwhakawhakan Pedro gway mangipano'no' ja mangagwis an chicha gway manggwana, “Iligtasju nan longagju san chusa gway ma'gwa sasan lagwingay taku.” ");
INSERT INTO kyb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ad sa'ad chachay namati san ingwhakan Pedro nampahonjagcha san sachiyay erkaw gwot ummoy as tuyu lihu chanan takuway nichoka sasan namati an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kun impapuutcha gway nanchongor san sussuyun chanan apostoles ja nanosossaancha san ooncha. Nallugwayucha ja na'api'pi''icha san tinapay gway nangan as manomsom'ancha an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kun ummogjat nan gwaschi osa takuway manggwas lagwing kapu san inilachaay angsan gway mataakan ja mangimatunan gway impa'gwapa'gwan Apudyus sasan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nanghuhuyun chanan losanay namati ja nangwhiwhinnachangcha gway losancha naninnatod san agwad an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Illa'ucha chanan tayuncha ja u'ugwacha kun whiniwhillaycha nan la'una insikun san maserpun nan gwaschi osa an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kun whinikatay maayuscha san sowhan nan Templo ja maasinut sasan hoyoy gway nampa'pa''ayus ja nampi'pi''i san tinapay as manomsom'ancha an Hesus gway asilayajad. ");
INSERT INTO kyb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gwot patinajunchaay manchaychajaw an Apudyus kun nasom nan losanay taku an chicha. Kun whinikatay ichokan Apudyus an chicha chanan takuwona. ");
INSERT INTO kyb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Osa kunay erkaw ummoycha Pedro an Juan san sowhan nan Templo san chimpun nan ilullugwayu san singwhattang as anchu. ");
INSERT INTO kyb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Aspur hos gway iningkaw nan osa laya'iyay pilay manipud san nijana'ana gway chinangoycha iyoy san sowhan nan Templo. Whinikatay changojoncha as sija ad iyoycha san sagwang gway ma'gwaniyon Whayuway Sagwang tot mampalimus sasan lumno' san sowhan nan Templo. ");
INSERT INTO kyb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Inilana kun cha Pedro an Juan gway lumno' san sowhan nan Templo nampalimus as sija an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Gwon intotollongcha as sija kun anan Pedro, “Ilam cha'ami.” ");
INSERT INTO kyb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kun intotollongna chicha tan anana kunnu agwad atchoncha an sija. ");
INSERT INTO kyb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kun anan Pedro, “Maid kun pila''u gwon atcho' an si'a nan agwad an sa'on. San ngachan Hesu Kristu gway iNazaret sumi'ad'a ad nanadchayan'a.” ");
INSERT INTO kyb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kun inognan Pedro nan chigwananay imana gwot impasi'adna. Kun maag ekay ummontog nan i'ina. ");
INSERT INTO kyb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kun summi'achay tumattattaud gway manadchadchayan. Kun na'erno' as sija ancha Pedro ja Juan san sowhan nan Templo gway tumattattaud gway manadchadchayan gway nanchaychajaw an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kun inilan chanan losanay taku as sija gway manadchadchayanay manchaychajaw an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Gwot naimatunancha kun gway sija chay mampalpalimus gway tummutu'chu san ma'gwaniyon Whayuway Sagwang nan Templo, nataagcha san na'gwa an sija. ");
INSERT INTO kyb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nijiigwid ku chay napilay ancha Pedro an Juan nanodcha' chanan taku gway ummoy ummachayug an chicha san agwachan nan ma'gwaniyon Portikun Solomon tan nataagcha. ");
INSERT INTO kyb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Inilan kun Pedro chanan taku gway naayus anana an chicha, “Susunud gway ijIsrael ka'ajuman mataag san annaja na'gwa? Kaman amasnat nan intottollongju an cha'ami? Ananju nina ekoon impachadchayanmi nan annaja taku kapu san ayobhonganmi ja kapu san inawhayumi. ");
INSERT INTO kyb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nan Apudyus gway chaychajagwon cha Abraham, Isaac, Jacob ja chanan nerpugwan ta'u, impailana nan inapatog Hesus gway nansilwhi an sija san luhung. Sija nan Hesus gway impachopapju gwot nilagwingjus sija san sangun Pilato ta'on nu nappung Pilato iwhaka gway payuhusana as sija. ");
INSERT INTO kyb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nilagwingjus sija gway Maid kun Whersuna ja Nalintog. Ad sija piniliju as payuhusan Pilato nan osaay manootoy. ");
INSERT INTO kyb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Intoyyu nan merpugwan nan whijag gwon tinakun Apudyus. Ad cha'ami nan mangiwhaka san sachi tan inilami. ");
INSERT INTO kyb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ad kapu san pammati san ayobhongan Hesus, nannaja taku gway iniilajuway napilay, as Hesus nan nangipapigsa an sija. Nan ayobhongan Hesus ja nan pammati an sija nan nangipawhayu sannaja taku gway iillanju losan. ");
INSERT INTO kyb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ad san sana susunud akammu'ay maid kun akammuju san inggwa'inggwaju isun ahos chanan papangatju. ");
INSERT INTO kyb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gwon amasna nan tummuttugwaan nan impaiwhakan Apudyus sasan losanay profeta san agwi gway maserpuway mapalikatan nan Kristu gway pinilin Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sija nan manchu'kanju nan whersuju ja managkulin aju an Apudyus tot ligwatana chanan whersuju ");
INSERT INTO kyb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tot mawhalinay atchona an cha'aju chanan chimpu as umillongan ad mawhalinay paaliyona as Hesus gway Kristu gway chinutu'anaay mangituyay an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Gwon maserpuway iingkaw jan as sija ad langit ingkana san chimpuway mangipawhayugwan Apudyus san losan. Sachi nan ingwhakan Apudyus sasan mangikakadto'ay mansilwhi gway profetana san agwi. ");
INSERT INTO kyb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tan ingwhakan Moses gway anana, ‘Agwad nan ipaalin Apudyus gway profeta gway merpu san ailijanju gway isu' gway ingwhaunna. Maserpuway tuttugwaonju nan losanay iwhakana. ");
INSERT INTO kyb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ad nu ngachanna man sinatay achi mamati san sachiyay profeta misiyan sasan takun Apudyus as ingkaingkana.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kun intuyuy Pedro gway manggwana, “Sa'ad chachay losanay profeta gway kumminga malluki an Samuel ingkana sasay nisu'su'nub an sija, impaakammucha nan mipangkop san annachaja gway ma'ma'gwa san sana. ");
INSERT INTO kyb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Cha'aju nan niwhilang san ingwhakan Apudyus sasan profeta san agwi ja nitapi aju hos san intuyag Apudyus sasan nerpugwanju san manggwanaan Apudyus an Abraham, ‘Pawhayugwo' nan whijag chanan losanay taku sanna luhung kapu san kana'nu.’ ");
INSERT INTO kyb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ummuna jan gway ingwhaun Apudyus an cha'aju nan pinilinaay mansilsilwhi an sija gway as Hesus tot pawhayugwona nan whijagju san mangipachu'kana an cha'aju san lagwingay ayanggwaju.” ");
INSERT INTO kyb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sa'ad san nanukuchan cha Pedro an Juan sasan taku ummachayug an chicha chanan papachi, chanan Saduceo ja nan apitan chanan mangijaachug san Templo. ");
INSERT INTO kyb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Amod nan lingucha kapu tan nansuyusuyu cha Pedro an Juan sasan taku. Impaakammucha gway agwad nan matakuwan chanan natoy gway isun nan nipaila san natakuwan Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kun chimpapcha chicha gwot ingwhayudcha chicha ingkanas mawhikat kapu tan mummaschom. ");
INSERT INTO kyb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gwon sa'ad chachay nanchongor angsan an chicha nan namati san insuyun cha Pedro an Juan kun ummoy as lima lihu nan whilang chanan lallaya'i. ");
INSERT INTO kyb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mawhikat kun naayus ad Jerusalem chanan papangat nan Hudyu, chanan chacha''orn chanan Hudyus ja mangaagkammu san lintog. ");
INSERT INTO kyb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Iningkaw cha Anas gway angatuwan gway pachi, Caifas, Juan ja Alejandro ja chanan uchumay ahumerjan nan angatuwanay pachi. ");
INSERT INTO kyb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kun impasangucha an chicha cha Pedro an Juan kun nanimuscha gway manggwana, “Ngachan nan ininonjuway nanggwa san amaschi? Ngachan nan sin'ayobhongan gwinnu singngachan san inuserju?” ");
INSERT INTO kyb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kun nanterwhasu nan ayobhongan nan Ispilitun Apudyus an Pedro kun summungwhat as sija gway manggwana an chicha, “Cha'ajuway papangat chanan taku ja chacha''orn nan ili! ");
INSERT INTO kyb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nu masumerja ami san sanaay erkaw kapu san whayuway na'gwa san annaja pilay ja nu ngachan nan ininonaay nan hummayu, ");
INSERT INTO kyb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","maserpuway akammugwonju losan ja nan losanay taku san Israel gway sa'ad nannaja laya'i gway summisi'ad sannaja, hummayu kapu san ayobhongan nan ngachan Hesu Kristu gway iNazaret gway impailansaju san krus gwon tinakun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘As Hesus nan whatu gway nilagwingjuway mamanggwa san hoyoy gwon nangngachan as sija kadto'ay nisaachan nan hoyoy.’ ");
INSERT INTO kyb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Maid kun uchum as manaku an chita'u. Tan sa'ad san intiluway luhung ahus nan ngachan Hesus as naatod as manaku an chita'u.” ");
INSERT INTO kyb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Inilacha kunan tuyodcha Pedro an Juan ja inakammuchaay kakangaycha ekajay taku ja achicha kun nangusgwila, nataagcha. Ad inakammuchaay nihuyohuyogcha an Hesus san agwi. ");
INSERT INTO kyb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ad kapu tan iillancha gway summisi'ad san cherragcha Pedro an Juan chay laya'iyay hummayu, maid kun maiwhakacha as mihursu an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sija nan impayagwacha cha Pedro an Juan san Sanhedrin kun losancha nanuukud ");
INSERT INTO kyb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","gway manggwana, “Ngachan nan oon ta'u sannachajaay taku? Akammun nan losanay taku ad Jerusalem nan amochay mataakan gway inggwacha ad achi ta'u kun ma'iisulib. ");
INSERT INTO kyb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gwon sa'ad tot achi migwayas nannaja sasan taku gwerningan ta'u chicha tot achicha kun asinon apapaton san whayangnaay taku nan ngachan Hesus.” ");
INSERT INTO kyb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Gwot imperno'cha hos cha Pedro an Juan kun pinuyungcha chicha gway achicha kun manapapat gwinnu mansuyu san mipangkop san ngachan Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Gwon sinungwhatan cha Pedro an Juan chicha gway manggwana, “Iwhakajuud nu ngachan nan ustu san mangilan Apudyus, cha'aju nan chongyonmi gwinnu as Apudyus? ");
INSERT INTO kyb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tan achimi kun mawhalinay ijakay gway mangiwhaka sasan inilami ja chingngormi.” ");
INSERT INTO kyb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gwot gwinerningancha kus amod cha Pedro an Juan asichaot ipayagwa chicha. Maid kun ininonchaay mamalikat an chicha tan losan chanan taku nanchajaw an Apudyus kapu san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sa'ad chay laya'iyay hummayu san mataakan gway na'gwa nasuyu' as opat puyu nan tagwonna. ");
INSERT INTO kyb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Napayuhusan kun cha Pedro an Juan ummoycha sasan huhuyuncha kun impachamagcha an chicha nan ingwhakan chanan papangat nan papachi ja chanan chacha''orcha. ");
INSERT INTO kyb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chingngorn ku chanan huhuyuncha nan sachi nanosossaanchaay nallugwayu an Apudyus gway manggwana, “Apu gway nanggwa san langit ja luta, san whaywhay ja losan gway ingkaw sannachaja, ");
INSERT INTO kyb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kapu san Ispilitum nanapapat'a say nerpugwanmiyay Dabid gway mansilsilwhiyom san nanggwanaanaon: ‘Kaman nalingu as amod chanan wha'on kus Hudyu? Kaman manomsomo' chanan taku gway manggwa san maid kun kutu'na? ");
INSERT INTO kyb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nansakanachaay ma'akuwhat chanan ali san annaja luhung, Naayus chanan papangat gway humursu an Apudyus ja san Kristuna.’ ");
INSERT INTO kyb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tan tuttuwaay ad asna Jerusalem naayus gway nanuukud cha Herod an Poncio Pilato, nitapi ahos chanan aachugwan gway wha'on kus Hudyu ja chanan ijIsrael. Whinursuchas Hesus gway mansilsilwhiyom gway maid whersuna gway sija nan pinilim as Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inggwacha nan losanay pinangkopnu san agwi gway ma'gwa kapu san ayobhongam ja sachi nan whinayum. ");
INSERT INTO kyb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ad san sana Apu, ilam chanan inggwachaay ogogjat an cha'ami gway mansilsilwhi an si'a. Atcham cha'ami as amod as tuyod gway mangiwhaka san ukudnu. ");
INSERT INTO kyb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipailam nan ayobhongam tot humayu chanan nasa'it ja ijujam gway ma'gwa chanan mataakan san ngachan Hesus gway mansilsilwhiyom gway maid whersuna.” ");
INSERT INTO kyb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nappungcha kun mallugwayu nijukajug nan hoyoy gway naayusancha. Gwot naatchancha losan san ayobhongan nan Ispilitun Apudyus kun tummuyodchaay nan mangiwhaka san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kun nanosossaan chanan losanay namati san somsomo'. Maid kun osa as manggwanaon ugwana nan losanay u'ugwana. Nangwhiwhillajancha nan losan gway agwad an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ad san amochay ayobhonganay naatod an chicha intuyuy chanan apostoles gway mangipano'no' san mipangkop san natakuwan Apu Hesus. Kun amod nan inawhayun Apudyus gway impailana an chicha losan. ");
INSERT INTO kyb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maid kun man'uyangancha losan. Ad sa'ad chanan anna nan hoyoy ja tayunna illa'ucha kun iyoycha nan la'una ");
INSERT INTO kyb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","inatod sasan apostoles. Kun whiniwhillaycha sasan manserpu. ");
INSERT INTO kyb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iningkaw nan osa laya'i gway mangngachan Josep gway iCyprus gway kana' Levi gway nginadnan chanan apostoles as Bernabas (gway sa'ad nan pijaona anan, “Osa gway mangipapigsa san somsomo'”). ");
INSERT INTO kyb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Illa'una nan tayunna kun iyoyna nan la'una sasan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iningkaw nan osa laya'i gway Ananias nan ngachanna ad Safira nan asagwana. Illa'ucha nan tayuncha. ");
INSERT INTO kyb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Intayun Ananias nan uchumay la'un nan tayuncha gway tinachunan asagwana kun asinaot atchon nan nahunan sasan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Gwon anan Pedro, “Ananias, ka'aman paituyay an Satanas gway tinuliyam nan Ispilitun Apudyus ja intayum nan uchumay la'un nan tayunnu? ");
INSERT INTO kyb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sa'ad san chaannu mangila'uwan san tayunnu ugwam. Kun illa'um pun ugwam ahos nan la'una. Ngachamma sinumyo' san somsomo'nu gway oom nan amaschi? Wha'on kus taku nan tinuliyam, as Apudyus nan tinuliyam!” ");
INSERT INTO kyb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chingngorn kun Ananias nan ingwhakan Pedro natugwad as sija kun natoy. Kun amod nan ogjat chanan losan gway nangngor san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kun nilumno' chanan whabwhawhayu kun whinunguncha nan lachagna kun illagwachaot inilhoncha. ");
INSERT INTO kyb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lumma'pus ad as tuyu uyas, nilumno' as Safira. Maid kun akammuna san na'gwa an asagwana. ");
INSERT INTO kyb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kun anan Pedro an sija, “Iwhakamud an sa'on, annaja ekay la'un nan tayunju?” “Oon,” anan nan huwhai, “sanat nan la'una.” ");
INSERT INTO kyb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kun anan Pedro, “Kajuman mantuyakanay manasagwa gway mamadpadchas san Ispilitun Apudyus? Chongyom nan annatchaja alichas nan i'i, annatchaja san sagwang chanan lallaya'iyay nangilhon an asagwam. Umali cha'a hos ipayagwa.” ");
INSERT INTO kyb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kun maag ekay natugwad as Safira san whatug nan i'in Pedro kun natoy. Nilumno' kun chanan whabwhawhayu inilacha as Safira gway natoy. Sija nan impayagwachaot inilhoncha san cherrag nan lohon asagwana. ");
INSERT INTO kyb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kun amod nan ogjat chanan losanay maayuayusay namati ja chanan losanay nangngor san na'gwa. ");
INSERT INTO kyb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sa'ad san sachiyay chimpu angsan chanan mangimatunan ja mataakan gway inggwa'inggwan chanan apostoles san sangun chanan taku. Maayuayus chanan losanay namati san ma'gwaniyon Portikun Solomon. ");
INSERT INTO kyb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Maid kun nangituyod gway mijamung an chicha gwon amod whayu nan mangilan chanan taku an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kun ummachaachu chanan nichokaay namati an Apu gway chachamaay lallaya'i ancha hubhuwhai. ");
INSERT INTO kyb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ad kapu san inggwa'inggwan chanan apostoles gway mataakan iyoy ahos chanan taku chanan nasa'it sasan ersa. Impabogcha chicha sasan oogkan ja ohog tot lumaus ad as Pedro miwhatug lagwa san uchum nan aninigwanna. ");
INSERT INTO kyb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kun chachama hos chanan taku gway naasinut gway nerpu sasan serronaay ailiili san Jerusalem gway nangijoy sasan nasa'it ja nilno' chanan chimunju. Kun hummayucha losan. ");
INSERT INTO kyb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ad sa'ad nan angatuwanay pachi ja chachay nihuyog an sija gway hungkuy nan Saduceo amod nan aposcha kun nanuukuchancha nu ngachan nan ooncha. ");
INSERT INTO kyb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Impachopapcha chachay apostoles kun ingwhayudcha chicha. ");
INSERT INTO kyb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gwon san sachi gway lawhi inigkat nan osaay anghel Apudyus nan onob nan whawhalluchan kun impayagwana chanan apostoles. Kun anana an chicha, ");
INSERT INTO kyb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“I'aju san sowhan nan Templo ad ingwhakaju sasan taku nan losan gway mipangkop san ma'awhijakan an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kun tinuttuwan chanan apostoles nan sachi gwot mawhikat kun san chaan chumungit nan init, nilumno'cha san sowhan nan Templo kun nansuyucha. Hummu'nag kunan angatuwanay pachi ja chanan huhuyunna impaajagcha chanan Sanhedrin ja losanay chacha''orn chanan ijIsrael gwot asichaot ipaajag chachay apostoles san whawhalluchan tot sumerjaoncha chicha. ");
INSERT INTO kyb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gwon hummu'nag ku chanan mangijaachug san Templo gway mangaya an chicha san whawhalluchan, maid kun chachay apostoles. Kun nanulinchaot ummoycha impaakammu ");
INSERT INTO kyb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","gway manggwana, “Hummu'nag ami kun san whawhalluchan inilamiyay naongwhan nan onob ja gwachagwad chanan mangijaachug. Gwon inigkatmi kun maid kun inchasanmi as taku ad chayo'!” ");
INSERT INTO kyb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chingngorn kunan apitan chanan mangijaachug san Templo ja chanan papangat nan papachi nan ingwhakacha, nataagcha san na'gwa sasay apostoles kun simsimmo'cha nu ngachan nan na'gwa sasay apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kun hummu'nag nan osa laya'i kun ingwhakana an chichaay manggwana, “Chongyonju! Agwad san sowhan nan Templo chachay lallaya'iyay ingwhayudju. Agwadcha mansuyusuyu sasan taku.” ");
INSERT INTO kyb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lummiggwat kunan apitan ja chanan mangijaachug san Templo inayacha chachay apostoles. Gwon whayu nan in'amanchaay nangajag an chicha tan umogjatcha as tugwakay whintukon chanan taku chicha. ");
INSERT INTO kyb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iyoycha kun chachay apostoles san Sanhedrin nanimus nan angatuwanay pachi gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tan inammanmi kay cha'aju puyungonay achiju isuyu nan mipangkop an Hesus ja! Ilanju nannaja inggwaju! Nigwayas nan insuyusuyuju san intiluway Jerusalem kun whayugwonju hosay pawhasuyon cha'ami san natojana.” ");
INSERT INTO kyb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kun summungwhat as Pedro ja chanan uchumay apostoles gway manggwana, “Maserpuway as Apudyus nan chongyonmi, wha'on kusan taku. ");
INSERT INTO kyb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sa'ad as Apudyus gway chinaychajaw chanan nerpugwan ta'u san agwi tinakuna as Hesus gway intoyyu san nangipailansaanju an sija san krus. ");
INSERT INTO kyb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Sa'ad as Hesus impangatun Apudyus gway impatu'chunas sija san machigwananna as Mangipanguyu ja Manaku tot magwajaan ta'uway ijIsrael gway manchu'kan ta'u chanan lagwing gway o'oon ta'u tot ligwatan Apudyus chanan whersu ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ad cha'amiyay nangila nan mangipano'no' sina ja nan Ispilitun Apudyus gway inatodna sasan chumngor an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chingngorn kunan Sanhedrin nannaja amod nan huchu'cha kun whayugwonchaay otojon chachay apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gwon summi'ad nan osa Pariseo gway nitapi san Sanhedrin gway mangngachan Gamaliel gway osaay mistuyun nan lintog gway whigwhikon chanan losanay taku. Kun ingwhakanaay ipayagwacha jan chanan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nipayagwa kun chachay apostoles nanukud gway manggwana, “Susunud gway ijIsrael ammanju ilan nu ngachan nan oonju sannachajaay taku. ");
INSERT INTO kyb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sa'ad san sinerkagwan iningkaw as Teodas gway nangnanggwa gway ananaon napatog as sija. Ummoy as 400 chanan lallaya'i gway summuyut an sija. Gwon intoycha kus sija nasibsibta' chanan pasuyutna kun mummaid chay nilukijana inggwa. ");
INSERT INTO kyb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Awni kun iningkaw ahos as Judas gway iGalili san chimpun nan sinsus kun angsan ahos chanan inagwisna. Intoycha kuhos as Judas nasibsibta' ahos chanan pasuyutna. ");
INSERT INTO kyb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Sija nan san sana annaja nan iwhaka' an cha'aju, ‘Achiju whijangan chicha. Ainnugwancha! Tan sa'ad nu nerpu san somsomo' nan taku nan annaja o'ooncha maid kun mangwhanakana. ");
INSERT INTO kyb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gwon sa'ad nu nerpu an Apudyus achiju kun mawhalinay awha'on chicha. Achiju husuyon chicha tan tugwakay as Apudyus nan hushusuyonju!’ ” Kun inajunanchas sija. ");
INSERT INTO kyb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Impaajagcha kun asin chachay apostoles impasaplitcha chicha. Ingwhakacha an chichaay achicha mansuyu san ngachan Hesus. Nappung kun pinerjawcha chicha. ");
INSERT INTO kyb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nallaylajad as amod chanan apostoles gway lummajaw san agwachan nan Sanhedrin tan whinigwhig Apudyus chicha as miwhilang gway mallikat san miwhawhainan kapu an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kun whinikatay ituttuttuyuychaay umoy san sowhan nan Templo ancha hohoyoy gway mangipaakammu ja mangisuyu san Whayuway Chamag gway sa'ad as Hesus sija nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ad sa'ad san sachi chimpu gway umachaachu nan whilang chanan pasuyut Hesus, nallili chanan Hudyu gway Grinego nan apapatcha sasay Hudyu gway Aramaic nan apapatcha gway iJerusalem tan wha'on kus patinajunay magwayasan san inerkaw gway lasjun chanan nawhayu. ");
INSERT INTO kyb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kun inajakan chanan nasagwayan as chugwaay apostoles nan losanay pasuyut Hesus kun anancha, “Lagwing nin nu ijakaymiyay mangipaakammu ja mangisuyu san ukud Apudyus tot sija ekay oonmi nan mangigwayas sasan pila' ja lasjun. ");
INSERT INTO kyb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sija nan susunud, mampili ajus pitu gway lallaya'i as merpu an cha'aju gway whayu nan achamakancha, nalaing ja anna nan ayobhongan nan Ispilitun Apudyus an chicha. Chicha nan chutu'an ta'us manggwa sannaja. ");
INSERT INTO kyb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sa'ad as cha'ami sija ekay ipapuutmi oon nan mallugwayu ja mangipaakammu san ukud Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kun nayagsa'an chanan amod gway taku san ingwhakan chanan apostoles. Kun pinilicha as Esteban gway osaay laya'i gway ipapatina nan pammatina ja anna nan ayobhongan nan Ispilitun Apudyus an sija. Pinilicha hos cha Felipe, Procoro, Nicanor, Timon, Parmenas ja as Nicolas gway osaay wha'on kus Hudyu gway ijAntiokia gway summuyut san pammatin nan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Impayangcha chicha sasan apostoles kun asinot chanan apostoles ipatay nan imachaay mangilugwayu an chichaay nachutu'an. ");
INSERT INTO kyb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kun nantuttuttuyuy nan nigwerna'an nan ukud Apudyus. Kun ummachaachu as amod chanan pasuyut Hesus ad Jerusalem ja angsan sasan papachi gway Hudyu nan summuyut gway namati an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sa'ad as Esteban gway cha'or nan tuyung ja ayobhongan gway inatod Apudyus an sija, amod nan inggwa'inggwana gway mataakan ja mangimatunan sasan taku. ");
INSERT INTO kyb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Gwon iningkaw nan uchum gway nitapi san sinagogan chanan Hudyu gway ma'gwaniyon Nagwajagwajaanay Mudchachu gway iCirene, ijAlejandria, chanan uchum gway iSilicia ja ijAsia gway na'asinsinnungwhat an Esteban. ");
INSERT INTO kyb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gwon achicha kun lobhongay awha'on as sija kapu san laingna gway inatod nan Ispilitun Apudyus an sija gway manukud. ");
INSERT INTO kyb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kun pinasu'su'ancha chanan uchum gway lallaya'i as manggwanaon, “Chingngormi as Esteban gway nanapapat as lagwing san mipangkop san lintog Moses ja an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kinakayachaay palingugwon chanan taku an Esteban uyay chanan chacha''orn chanan Hudyu ja mangaagkammu san lintog. Kun ummoycha chimpap as Esteban asichaot ijoy san Sanhedrin. ");
INSERT INTO kyb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kun nangipooycha as mantutulli as manggwanaon, “Achi kun mampatingka nan annaja taku gway manapapat as lagwing san ikaw gway Nat'on as Ingkagwan Apudyus ja san lintog gway inatodna an Moses. ");
INSERT INTO kyb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tan chingngormi gway ananaon igwa''in Hesus gway iNazaret nan Templon Apudyus ad inghosna chanan ukali gway impatagwid Moses an chita'u.” ");
INSERT INTO kyb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Intotollong kun chachay losanay tummutu'chu gway agwad san Sanhedrin as Esteban inilachaay amas hosern nan anghel nan hoserna. ");
INSERT INTO kyb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kun inimus nan angatuwanay pachi an Esteban gway manggwana, “Ad tuttuwa nannachaja ipawhersucha an si'a?” ");
INSERT INTO kyb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kun summungwhat as Esteban gway manggwana, “Aamma ja susunud! Chongyona' ad. As Apudyus gway machaychajaw, nampaila an Abraham gway nerpugwan ta'u ad Mesopotamia san chaanna humyojan ad Haran. ");
INSERT INTO kyb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anana an Abraham, ‘Taynam nan ilim ja chanan chochogkam ad ummoy'a san ili gway ipaila' an si'a.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sachi kun tinaynana nan ilin chanan iCaldeo kun ummoy whinumyoy ad Haran. Natoy kunan amana asinot Apudyus iwhaun as sija gway manatun sanna ili gway agwachanju san sana. ");
INSERT INTO kyb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Kun maid ekay impappaya'sun Apudyus an sija uyay sinali'agwog gway luta san sachi ili. Gwon ingwhawhagkana gway atchona an sija ja sasan kana'na nan u'ugwana ta'on nu maid ana'na. ");
INSERT INTO kyb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Amasna nan ingwhawhagkan Apudyus an Abraham, ‘Mangngachan mangili chanan kana'nu san sawhaliyay ili. San sachiyay ili mangngachancha mudchachu ja mapalikatancha as opat kasutay tagwon. ");
INSERT INTO kyb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gwon chusao' chanan taku gway mammudchachu an chicha. Awni ad lummajawcha san sachiyay ili ad chinajagwa' sannaja ili.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Kun intuyag Apudyus an Abraham gway suglitana nan ana'na gway lallaya'i as mangimatunan san tuyakancha. Sija nan iyana' kun Abraham as Isaac sinuglitana san mi'agwayu san erkawna manipud san nijana'ana. Ad sa'ad as Isaac iyana'na hos as Jacob. Kun as Jacob nangngachan aman chanan nasagwayan as chugwa lallaya'iyay mawhigwhigwhig gway nerpugwan ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kapu san apos chanan anana' Jacob an Josep gway sunudcha illa'uchas sija gwot niijoy as mudchachu ad Egipto. Gwon whinadngawhadngan Apudyus as sija. ");
INSERT INTO kyb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Whingadngan Apudyus as sija san losanay likatna ja inatchanas sija as laing ja whayuway ukali ta masom nan Faraon gway alin nan Egipto. Chinutu'an Faraon as Josep as kuwhinnachurn nan Egipto ja mangaaygwan san losanay wherjanna. ");
INSERT INTO kyb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Awni kun hummu'nag nan uyat san intiluway Egipto ja Canaan sija nan nalikatan ekas amod chanan nerpugwan ta'u ja maid kun ma'an as maanapancha. ");
INSERT INTO kyb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gwot chingngorn kun Jacob gway agwad nan ma'an ad Egipto ingwhaunna chanan ana'na gway nerpugwan ta'u. Annaja nan chamu ummajancha ad Egipto. ");
INSERT INTO kyb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ad sa'ad nan mi'adgwa ummajancha impaakammun Josep nan inatatakuna sasan susunudna kun naakammugwan nan Faraon nan Egipto nan mipangkop san ahumerjanna. ");
INSERT INTO kyb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kun impaajag Josep as Jacob gway amana ja chanan chochogkana ad Egipto, pitumpuyu ja lima nan amungcha losan. ");
INSERT INTO kyb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kun ummoy as Jacob ad Egipto kun aschi nan natojana uyay chanan nerpugwan ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ad sa'ad chanan lachagcha nipagkulin niijoy ad Sikem kun niilhoncha san nilijangay loyobhonan gway nila'uwan Abraham as pila' sasan ana' Hamor san agwi ad Sikem. ");
INSERT INTO kyb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Takangay kunan chimpu gway mangipatungpayan Apudyus san ingwhawhagkana an Abraham ummachaachu' amod chanan nerpugwan ta'u ad Egipto ");
INSERT INTO kyb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ingkanas nisu'at nan osa ali gway nantuyay ad Egipto gway achina kun akammu as Josep. ");
INSERT INTO kyb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sini'apana chanan nerpugwan ta'u ja pinilitna chicha gway mangiwhallu sasan a''ijana'ay ana'cha tot matoycha. ");
INSERT INTO kyb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Sa'ad san sachi chimpu, nijana' as Moses gway whawhalluwanay ana'. Tuyung huyan nan nanakiwhiyan nan sinana' an sija. ");
INSERT INTO kyb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Napilitancha kunay taynan as sija inchasan nan huwhaiyay ana' nan Faraon kun impacha'orna as manana'na. ");
INSERT INTO kyb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kun nasuyuwan as Moses san losanay inalaing nan ijEgipto kun nangngachan nalaingay manukud ja manggwa san losanay o'oona. ");
INSERT INTO kyb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Man'opat puyu kunan tagwon Moses nanomsomo'ay umoyna kagka'ajon chanan ailijanaay ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Inilana kunan osa ailijana palpalikatan nan osaay ijEgipto ummoyna insaya' asinaot iwhayus gway intoyna chay ijEgipto. ");
INSERT INTO kyb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Anan ekay Moseson naagwatan nan ailijana gway sija nan usayon Apudyus as mangiligtas an chicha gwon annaotay achicha kun naagwatan. ");
INSERT INTO kyb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Asin kun mawhikat inilana nan chugwaay ijIsrael gway manajam kun umoyna otjan tugkiyan chicha gway manggwanaon, ‘Susunud, anna kajay man'ailijan aju ja ka'ajuman manajam?’ ");
INSERT INTO kyb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Gwon sa'ad chay osa laya'i gway nangajam san huyunna, intu'judnas Moses gway manggwana, ‘Ngachan nan saadnuway mangilintog ja mangu'um an cha'ami? ");
INSERT INTO kyb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Adja pijaom ahosay otojon as sa'on isun nan nangtojam san ijEgipto ad kallab.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chingngorn kun Moses na sachi ummagwid ad Midian gwot na'aumili ad aschi. Kun nangasagwa ad aschi gwot ummana' as chugwaay laya'i. ");
INSERT INTO kyb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lummaus kunan opat puyuway tagwon nampaila an Moses nan osaay anghel Apudyus san kumikillaub gway whanwhanokay aju san luta gway maid kun ingkaw as taku gway achani san whilikay Sinai. ");
INSERT INTO kyb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Inilan kun Moses nataag as sija. Anna kunay umoyna achayukon ilan chingngorna nan kingan Apudyus ");
INSERT INTO kyb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","gway manggwana, ‘Sa'on nan Apudyus chanan nerpugwam gway cha Abraham, Isaac ja Jacob.’ Kun namajogpog as Moses san ogjatna gwot achi kun ma'iituyod gway mangitollong. ");
INSERT INTO kyb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kun anan Apudyus an sija, ‘Aanom nan sinilasnu tan sa'ad nannaja summisi''acham niit'on an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tuttuwa iniila' nan amochay palikat chanan taku' ad Egipto ja chingngor' nan ajuwongcha kun ummaliya' gway mangiligtas an chicha. Gwaynu ta si'a nan iwhaun'u ad Egipto.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Sachi Moses nan nilagwing chanan ijIsrael san manggwanaanchaon, ‘Ngachan nan saadnuway mangilintog ja mangu'um an cha'ami?’ Sija nan ingwhaun Apudyus gway mangituyay ja mangiligtas an chicha kapu san whachang nan anghel gway nampaila an sija san kumikillaub gway whanwhanokay aju. ");
INSERT INTO kyb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Illagwana chicha ad Egipto. Inggwana chanan mataakan ja mangimatunan ad aschi Egipto san ma'gwaniyon ‘Chayakay Whaywhay’ ja san luta gway maid kun ingkaw as taku san unog nan opat puyu gway tagwon. ");
INSERT INTO kyb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Sachi Moses nan manggwana sasan ijIsraelon, ‘Umiwhaun as Apudyus as osaay profeta an cha'aju gway ailijanju as isun nan nangiwhaunana an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","San naayusan chanan taku san luta gway maid kun ingkaw as taku san whilig gway Sinai, as Moses nan na'aapapatan nan anghel kun asinot Moses iwhaka sasan nerpugwan ta'u. Kun inagwatna nan mawhiwhijakay ukud Apudyus tot ichalisna an chita'u. ");
INSERT INTO kyb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Gwon achin ku chanan nerpugwan ta'u tinuttuwa as sija. Nilagwingchas sija ja simsimmo'chaay managkulin ad Egipto ");
INSERT INTO kyb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","gway manggwana an Aaron, ‘I'gwaan cha'ami as sinang'apudyus as mangipangu an cha'ami. Achimi kun akammu nu ngachan nan na'gwa an Moses gway nangilagwa an chita'u ad Egipto.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nanggwacha as sinang'apudyus as isun nan uyhun nan wha'a. Kun nanchatuncha san sinang'apudyus ja nilagsa'ancha nan sachiyay inggwacha. ");
INSERT INTO kyb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sachi nan nanchu'kan Apudyus an chicha. Iyujana chichaay sija chaychajagwoncha nan whituwon ad langit gway isun nan nilista san nibyun chanan profeta gway ananaon: ‘Cha'ajuway ijIsrael! Wha'on ku an sa'on nan nangatchanju sasan pinertiju ja inchatunju san opat puyu tagwonay iningkagwanju san luta gway maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kun inta''ita''ikadju nan hoholloy nan sinang'apudyusay Moloch ja nan whituwon gway mangipayang san sinang'apudyusju gway Refam gway inggwaju as manchaychajagwanju. Sija nan ijoy'u cha'aju san ili gway achaju san Babilonia.’ ");
INSERT INTO kyb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Inta''ita''ikad chanan nerpugwan ta'u nan turcha gway iigkagwan nan tuyag Apudyus san luta gway maid kun ingkaw as taku. Na'gwa nannaja san nangiwhagan Apudyus an Moses gway oona as issuissun nan kaob nan impailan Apudyus an sija. ");
INSERT INTO kyb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Awni kun illa'sun chanan nerpugwan ta'u nan turchan nan tuyag Apudyus sasan aamma ta'u. Kun inta''ita''ikadcha san nihuyokancha an Josue gway namyos san lutan chanan taku gway pinerjaw Apudyus. Kun iniingkaw nan sachi san ili ta'u ingkana san chimpun Dabid. ");
INSERT INTO kyb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Nasom as Apudyus an Dabid kun ingwhakan Dabid an Apudyus nu ijujanaay manggwas sija as hoyoy as ingkagwan nan Apudyus Jacob. ");
INSERT INTO kyb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gwon as Solomon nan nanggwa san ingkagwan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Gwon wha'on kun as ingkaw nan angatuwanay Apudyus sasan ingkagwan gway inggwan nan taku gway isun nan anan nan profetaon, ");
INSERT INTO kyb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit nan tumu'chugwa' gway mantuyay ad luta nan layappangan nan i'i'. Ngachan nan ayasin nan hoyoy'u pata'choyonju?’ Anan Apudyus, ‘Jo'o manserpuwa' as umillonga'. ");
INSERT INTO kyb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jo'o wha'on an sa'on nan nanggwa san losan ta?’ ");
INSERT INTO kyb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Hummatu nan somsomo'ju! Nasu'il aju ja tutullongonju nan ukud Apudyus, inagwatju chanan nerpugwanju! Patinajunay ingingaonju nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jo'o agwad profeta as achin chanan nerpugwanju pinalikatan. Intoycha chanan ingwhaun Apudyus san agwiyay ummali nangipakaammu san umaliyan nan Nalintokay Mansilsilwhi. Kun anna ahosay iyiwhitju ja intoyyus sija. ");
INSERT INTO kyb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Cha'aju nan nangagwat san lintog Apudyus gway impaijatodna sasan a'anghelna gwon achiju kun pinati.” ");
INSERT INTO kyb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sa'ad san nangngoyan chanan Sanhedrin san ingwhakan Esteban amod nan huchu'cha kun mangngilngiltoncha ekay whawhacha. ");
INSERT INTO kyb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Gwon as Esteban gway nanterwhasu nan ayobhongan nan Ispilitun Apudyus an sija, nantangad ad langit gwot inilana nan inachajaw Apudyus ja as Hesus gway summisi'ad san machigwanan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kun anana, “Ilanju, inila' gway niibwhat ad langit ja nan Ana' nan Taku gway as Hesus gway summisi'ad san machigwanan Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Gwon impupcha nan ingacha gway nampo'aw as towhag kun nakabhuurchaay ummoy an sija. ");
INSERT INTO kyb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kun ingkudchas sijaot iyoycha san lasin nan syudad kun whininwhintugchas sija. Ad sa'ad chanan namano'no' san na'gwa tinaynancha nan kotap nan silupcha san osaay mernusay whawhayu gway mangngachan Saulo. ");
INSERT INTO kyb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Anna kunay whinwhintukoncha as Esteban nallugwayu gway manggwanaon, “Apu Hesus, agwatom nan alichodgwa'.” ");
INSERT INTO kyb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kun nansalli'on ku puwogna ni'ulin gwot nampa'uy gway manggwana, “Apu, achim otjan ipawhersu an chicha nannaja.” Nappungna kun iwhaka chi natoy as sija. ");
INSERT INTO kyb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sa'ad as Saulo tinachunana nan nangtojancha an Esteban. Ad san sachi erkaw nalluki nan amochay mamalpalikatancha sasan maayuayusay namati ad Jerusalem. Ad losancha nansississiyan san losanay ili gway sa'upon nan Judea ja Samaria maya'sig sasan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kun iningkaw nan uchumay mangipapatiyay mangapudyus gway nangilhon an Esteban kun amod nan simo'cha ja nangiwhilancha an sija. ");
INSERT INTO kyb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ad sa'ad as Saulo kinuyuna chanan maayuayusay namati. Kun ummoy ahos san hohoyoycha kun whinuthutna chanan lallaya'i ja hubhuwhai gwot impawhayudna chicha. ");
INSERT INTO kyb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sa'ad chanan nansississiyanay namati, ummoycha impaakammu nan Whayuway Chamag mipangkop an Hesus san ailiiliyay ummajancha. ");
INSERT INTO kyb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ad sa'ad as Felipe ummoy san syudad nan Samaria kun impaakammuna ad aschi nan mipangkop an Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kun inamman chanan amochay taku nanosossaanay nanchongor san ingwhakan Felipe san chingngorcha ja inilacha chanan mataakan gway inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tan asipapa'uy chanan chimunju gway lummagwa san angsanay taku gway nilumno'ancha. Kun angsan ahos chanan napalalais ja chanan napilay gway hummayu. ");
INSERT INTO kyb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sija nan nallaylajad as amod chanan taku san sachiyay syudad. ");
INSERT INTO kyb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","San sachi syudad iningkaw nan osa takuway mangngachan Simon. Sikuchay mansayusayumang'a as sija ad kapu san inggwa'inggwana nataag chanan takud Samaria. Maningaingati as sija gway anna nan amochay ayobhongana. ");
INSERT INTO kyb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ad losanay taku, whawha'nang ja whawha'sigwot san sachi syudad inammacha nanchongor an sija. Kun anancha, “Sa'ad nannaja taku agwad an sija nan ayobhongan Apudyus gway ma'gwaniyon Amochay Ayobhongan.” ");
INSERT INTO kyb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kun naagwischa an sija gway nanchongor tan nawhajakay nataagcha san sayumang'a gway inggwa'inggwana. ");
INSERT INTO kyb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gwon namaticha kusan Whayuway Chamag gway impaakammun Felipe gway mipangkop san Mantuyajan Apudyus ja san ngachan Hesu Kristu, nampahonjagcha losan gway lallaya'i ja hubhuwhai. ");
INSERT INTO kyb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Uyay as Simon namati hos kun nahonjakan kun nitunud an Felipe. San nangillana san mangimatunan ja amochay mataakan gway inggwa'inggwan Felipe nataag as sija. ");
INSERT INTO kyb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chingngorn ku chanan apostoles ad Jerusalem gway inagwat chanan taku ad Samaria nan ukud Apudyus, ingwhaunchas Pedro ja Juan an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hummu'nagcha kun illugwayuwancha nan losanay namati tot agwatoncha hos nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tan chaan kun umoy nan Ispilitun Apudyus an chicha. Nahonjakancha ekay san ngachan Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kun impatay cha Pedro an Juan nan imacha an chicha gwot inagwatcha nan Ispilitun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Inilan kun Simon gway naatod nan Ispilitun Apudyus sasan namati san nangipatajan chanan apostoles san imacha an chicha, inayayyu'ana cha Pedro an Juan san pila'. ");
INSERT INTO kyb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kun anana, “Atchonju hos an sa'on nannaja ayobhongan tot ngachan ad nan mangipataja' san ima' agwatona hos nan Ispilitun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Gwon anan Pedro an sija, “Mitapi otjan nan pila'nu an si'a miwhallu ad ingwhilnu tan anam punnu la'uwam san pila' nan atchon Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maid kun whijangnu gwinnu alintokam san terwhasumi tan lagwing nan somsomo'nu san mangilan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Manchu'kam nan sanatay inergwing nan somsomo'nu ad nallugwayu'a an Apudyus tot tugwakay lagwa ligwatana nan whersum kapu san lagwingay pangkop nan somsomo'nu. ");
INSERT INTO kyb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tan maila' gway amod nan aposnu ja niwhawhayud'a san whersu.” ");
INSERT INTO kyb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kun summungwhat as Simon gway manggwana, “Ilugwayuwana' an Apudyus ta maid ma'gwa an sa'on sanchichaja ingwhakaju.” ");
INSERT INTO kyb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nappung kun cha Pedro an Juan ipaakammu ja ipano'no' nan ukud Apudyus, nana''ulincha ad Jerusalem. Kun impaapaakammucha nan Whayuway Chamag san angsanay ilin nan iSamaria gway nilausancha. ");
INSERT INTO kyb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kun anan nan osa anghel Apudyus an Felipe, “Lumiggwat'a ta i'a san apot ad apyay gway ersaay merpud Jerusalem gway umoy ad Gaza.” Sa'ad nannaja ersa maid kun mangmangoy. ");
INSERT INTO kyb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lummiggwat kus Felipe ummoy. Awni kun iningkaw nan inahotna gway ijEtiopia gway na'apun gway osa pangat gway mamangchon san inawha'nang nan ma'gwaniyon Candace gway huwhaiyay mangituyay ad Etiopia. Nerpu chay ijEtiopia ad Jerusalem gway ummoy nanchaychajaw an Apudyus gway lumajaw ad Etiopia. ");
INSERT INTO kyb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nalluyukan kus sija san lukanna gway awhaju nan mangujud whasawhasaona nan ukud Apudyus gway illistan profeta Isaias. ");
INSERT INTO kyb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kun anan nan Ispilitun Apudyus an Felipe, “I'a achayukon nan sachi lukan.” ");
INSERT INTO kyb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kun nanodcha' as Felipe gway ummachayug kun chingngorna chay pangat gway mangwhasawhasa san nibyuway illistan Isaias. Kun inimus Felipe ananaon, “Adja maagwatam nan whasawhasaom?” ");
INSERT INTO kyb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kun anan chay pangat gway sumungwhat, “Inino'ay mangagwat nu maid mangipaagwat an sa'on?” Kun inajakanas Felipe ta ma'ayukan an sija. ");
INSERT INTO kyb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Annaja nan whasawhasaonaay Ukud Apudyus gway chay ananaon, “Isun nan kernero gway miijoy san perpertiyan gwinnu uyhun nan kernero gway ikikinno'na san pu'isanchas sija ad achi kun mantongaa'. ");
INSERT INTO kyb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Niwhawhain as sija ja wha'on kus ustu nan in'amanchaay nangu'um an sija. Maid kun manguullit san mipangkop san kana'na tan nappungon nan whijagna ad asna luta.” ");
INSERT INTO kyb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kun anan chay pangat an Felipe, “Ngachan nan ukuukuchon nannaja profeta, nan longagna gwinnu sawhali taku?” ");
INSERT INTO kyb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kun illukin Felipe gway manukud malluki say niwhasaay illistan Isaias kun impaagwatna nan Whayuway Chamag gway mipangkop an Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ad sa'ad san nalluyugkanancha niwhatugcha san chanum kun anan chay pangat an Felipe, “Ilam ad, anchiya nan chanum. Achi mawhalinay honjakana'?” ");
INSERT INTO kyb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kun impasinong chay pangat nan lukan gwot ummoychaay chugwa san chanum. Kun whinonjakan Felipe as sija. ");
INSERT INTO kyb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lummosgwacha kusan chanum illajaw nan Ispilitun Apudyus as Felipe gwot maid kun nangilan asin chay pangat an Felipe. Kun lummajaw chay pangat gway mallaylajad! ");
INSERT INTO kyb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Awni kun inakammun Felipe gway agwad as sija ad Azoto. Kun impaapaakammuna nan Whayuway Chamag san losanay ili nangojana ingkana kummatong ad Cesarea. ");
INSERT INTO kyb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sa'ad as Saulo intuttuyuynaay nangogogjat ja mangipaotoy sasan pasuyut Hesus. Ummoy as sija san angatuwanay pachi ");
INSERT INTO kyb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kun nampa'gwas suyat tot umoyna ipaila sasan sinagogan chanan Hudyu ad Damasco tot agwad ad ochasana sasan sumuyut san ma'gwaniyon Mangojan, laya'i man gwinnu huwhai agwad ayobhonganaay manpap an chicha ad iyoyna chicha ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ad sa'ad san nangwhaatana gwot takangay chumakus ad Damasco maag ekay nampali'gwos an sija nan amod sumiling gway nerpud langit. ");
INSERT INTO kyb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natugwad kus Saulo san luta chingngorna nan kinga gway manggwana, “Saulo, Saulo, kamman palpalikatan as sa'on?” ");
INSERT INTO kyb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kun anan Saulo, “Ngachan'a, Apu?” Kun anan chay kinga, “Sa'on as Hesus gway palpalikatam. ");
INSERT INTO kyb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sumi'ad'a ta i'a san syudad gway Damasco ad asi miwhaka an si'a nan oom ad aschi.” ");
INSERT INTO kyb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sa'ad chachay lallaya'i nihuyog an Saulo summisi'adchaay natataag tan chingngorcha nan kinga gwon maid kun mailas taku. ");
INSERT INTO kyb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kun hummangon as Saulo gwot manchiyat kun achi kun ma'aila. Kun inigwidchas sija iyoy ad Damasco. ");
INSERT INTO kyb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na'uyap as sija san tuyu erkaw ad achi kun nangnangan ja ummininum. ");
INSERT INTO kyb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iningkaw nan osaay pasuyut Hesus ad Damasco gway mangngachan Ananias. Kun nampaila as Hesus an sija san isun chi ininop gway manggwana, “Ananias!” Kun anan Ananias, “Apu, annaa' sina.” ");
INSERT INTO kyb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kun anan Apu Hesus an sija, “Sumi'ad'a ta i'a san ersa gway ma'gwaniyon Linchong. I'a san hoyoy Judas ad inimusnu nan osaay laya'i gway mangngachan Saulo gway iTarso. Agwad as sija gway mallugwayugwayu. ");
INSERT INTO kyb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Agwad nan impaila' an sija san isun chi ininop gway osa laya'i gway mangngachan Ananias gway nilumno' san agwachana kun impatayna nan imana an sija tot mansubli nan ilana.” ");
INSERT INTO kyb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Gwon anan Ananias, “Apu, angsan nan nangngoya' san mipangkop sannaja taku. Amochay lagwing nan inggwa'inggwana sasan takum ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ad anna ummalid asna Damasco gway inatchan chanan papangat nan papachi as ayobhonganay manpap sasan manchaychajaw an si'a.” ");
INSERT INTO kyb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gwon anan Apu Hesus an sija, “I'a, tan pinili' as sija as mansilwhi an sa'on tot ipaakammuna nan ngachan'u sasan wha'on kus Hudyu, sasan ali ja an cha'aju gway ijIsrael. ");
INSERT INTO kyb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ipaila' an sija nan amochay maserpu mapalikatana tot mipaakammu nan ngachan'u.” ");
INSERT INTO kyb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kun ummoy as Ananias nilumno' san hoyoy gwot impatayna kunan imana an Saulo anana, “Sunud gway Saulo, sa'ad as Apu Hesus gway nampaila an si'a san chayan san umaliyam ad asna, ingwhauna' tot mansubli nan ilam ja manterwhasu nan Ispilitun Apudyus an si'a.” ");
INSERT INTO kyb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kun maag ekay najagjag nan amas assip nan i'an san atan Saulo kun nanagkulin nan ilana. Kun summi'ad gwot whinonjakan Ananias. ");
INSERT INTO kyb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nangan kus sija nansubli nan pigsana. Kun iningkaw as Saulo as amanaay erkaw sasan pasuyut Hesus ad Damasco. ");
INSERT INTO kyb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kun ummoy sasan sinagoga gwot illukina gway mangipaakammu san mipangkop an Hesus gway manggwana, “Sija nan Ana' Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kun losanay nangngor an sija nataag kun asi'aananchaon, “Jo'o wha'on sannaja taku nan namalpalikat sasan takud Jerusalem gway manchaychajaw an Hesus. Tan sija kay nin ummaliyanad asna nan umalina chopapon chanan namati ad iyoyna chicha sasan papangat nan papachi ja?” ");
INSERT INTO kyb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Gwon ummamochot pummigsa as Saulo gway mangipano'no' san mipangkop an Hesus gway sija nan Kristu. Ad sa'ad chanan Hudyuway iingkaw ad Damasco achicha kun ma'asungwhat an sija. ");
INSERT INTO kyb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lummaus kunan angsan gway erkaw pinangkop chanan Hudyu gway otojon as Saulo. ");
INSERT INTO kyb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Gwon naakammugwan Saulo nan pangkopcha. Inerkaw ja nilawhi whawhangngawhangancha nan aayyon gway lumno' san syudad tot otojonchas sija. ");
INSERT INTO kyb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Gwon osa kunay lawhi inayan chanan pasuyutna as sija kun inigkacha san isun nan allung kun asichaot ursuuson san hoyaat nan ayad nan syudad. ");
INSERT INTO kyb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hummu'nag kus Saulo ad Jerusalem pinachasna umoy mijamung sasan pasuyut Hesus. Gwon ummogjatcha losan an sija tan achicha kun mamati gway osaay pasuyut Hesus as sija. ");
INSERT INTO kyb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Gwon ummoy Bernabas inajakan as sija kun iyoyna sasan apostoles. Kun inuullit Bernabas an chicha nan ininon Saulo gway nangila an Apu Hesus san chayan ja nan na'aapapatan Apu Hesus an sija ancha ininon nan tuyodnaay nangipaakammu san mipangkop an Hesus ad Damasco. ");
INSERT INTO kyb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sachi kun nijamung as Saulo an chicha gway nangagka'ay ad Jerusalem gway natuyochay nangipaapaakammu san mipangkop an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na'aapapat ja na'asinsinnungwhat ahos sasan Hudyuway Grinego nan apapatcha gwon whayugwonchaay otojon as sija. ");
INSERT INTO kyb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Inakammun ku chanan susunud san pammati nan pangkopcha iyoychas Saulo ad Cesarea kun impooychas sija ad Tarso. ");
INSERT INTO kyb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ad sa'ad chanan maayuayusay namati san ailiili ad Judea, Galili ja Samaria nijakay nan napalpalikatancha kun pummigsacha. Nawhijagchaay hummain an Apudyus ja kapu san whachang nan Ispilitun Apudyus ummachaachucha. ");
INSERT INTO kyb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Sa'ad san nangkagkakagka'ajan Pedro san ailiili gway ummoyna nilagwa chanan namati, ummoyna hos nilagwa chanan takun Apudyus gway iningkaw ad Lidda. ");
INSERT INTO kyb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kun inchasana san sachi ili nan osa takuway Eneas nan ngachanna. Napalalais as sija gway inuumhog ekay san gwayu tagwon. ");
INSERT INTO kyb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kun anan Pedro an sija, “Eneas! Pawhayugwon cha'a an Hesu Kristu! Humangon'a ad sinikkutnu nan ohognu!” Kun nawhanangon as Eneas. ");
INSERT INTO kyb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Inilan kunan losanay umili ad Lidda ja Sarona as Eneas, namaticha an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sa'ad ad Joppe iningkaw nan osa huwhaiyay pasuyut Hesus gway mangngachan Tabita. (Dorcas nan ngachanna san Grinego ad na pijaona anan, “ugsa.”) Patinajunay oona nan whayu san uchum ja humachawhachang san whawha'sigwot. ");
INSERT INTO kyb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ad sa'ad san sachi chimpu nasa'it as Dorcas kun natoy. Inamoscha kunan lachagna asichaot iwhanat san mangngatuway ugwertu. ");
INSERT INTO kyb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sa'ad tan achani nan Lidda san Joppe naakammugwan ku chanan pasuyut Hesus ad Joppe gway agwad as Pedro ad Lidda, nangiwhaunchas chugwas laya'i as umoy mangiwhaka an sijaay kanasona otjanay umoy ad Joppe. ");
INSERT INTO kyb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kun lummiggwat as Pedro gwot nihuyog an chicha. Hummu'nagcha kun iyoychas Pedro san mangngatuway ugwertu. Asijiiwhil chanan nawhayu gway nasi'asi'ad san cherrag Pedro kun impailacha an sija chachay silup gway inahorn Dorcas san matattakuwana. ");
INSERT INTO kyb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Gwon impayagwan kun Pedro chicha losan nampalintumongay nallugwayu. Nappung kun nansakung san lachag gway manggwana, “Tabita, humangon'a.” Kun nanchiyat as Dorcas kun inilana kus Pedro, tummu'chu. ");
INSERT INTO kyb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kun inognan Pedro nan imana gwot impasi'adna. Inajakana ku chanan takun Apudyus ja chanan nawhayu gway agwad san sowhan, impailanas Dorcas gway matattaku. ");
INSERT INTO kyb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kun nanchinamag san ailiili ad Joppe nannaja na'gwa kun angsan chanan namati an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kun iningkaw as Pedro ad Joppe as angsanay erkaw san hoyoy Simon gway mamanggwas layat. ");
INSERT INTO kyb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iningkaw ad Cesarea nan osa laya'i gway mangngachan Cornelio gway osaay apitan nan singkasut gway surchachun nan Roma gway nitapi san ananchaon “Batalyun gway ijItalia.” ");
INSERT INTO kyb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mangapudyus as sija ja ikakadto'naay manchajaw an Apudyus mitapi ahos nan losanay wherjanna. Nachayaay mangatod sasan whawha'sigwot ja patinajunay mallugwayu an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Osa kunay erkaw san singwhattang as anchu iningkaw nan impailan Apudyus an Cornelio. Inilanaay nilumno' san hoyoyna nan osa anghel Apudyus gway manggwana an sija, “Cornelio!” ");
INSERT INTO kyb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kun ummogjat as Cornelio gway nangitotollong san anghel kun anana, “Ngachan nichi, Apu?” Kun anan chay anghel, “Chingngorn Apudyus chanan lugwayum ja inilana chanan whachangnu sasan whawha'sigwot sija nan sosom'on cha'a. ");
INSERT INTO kyb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ad san sana mangiwhaun'a as umoy ad Joppe tot ajakancha nan osa takuway mangngachan Simon gway ananchaon Pedro ");
INSERT INTO kyb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","gway mangilin Simon gway mamanggwas layat. Agwad nan hoyoyna san ikid nan whaywhay.” ");
INSERT INTO kyb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lummajaw kun chay anghel gway na'aapapat an sija inajakan Cornelio nan chugwaay whawha''unona ja osa surchachunaay mangapudyus gway osa sasan mansilsilwhi an sija. ");
INSERT INTO kyb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ingwhakan kun Cornelio an chicha nan losanay na'gwa ingwhaunna chicha ad Joppe. ");
INSERT INTO kyb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mawhikat kun san agwachan chachay nawhaun san chayanay takangay ad Joppe, nijaspur ahos gway ummoy as Pedro san huhung nan hoyoy san takangay as mamatu' tot mallugwayu. ");
INSERT INTO kyb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nawhitil kun pijaonaay mangan. Gwon anna kunay misakasakana nan anona, iningkaw nan impailan Apudyus an sija gway amas ininop. ");
INSERT INTO kyb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kun inilanaay niibwhat nan langit kun iningkaw nan isun chi ergwa uyos gway chumo''ocho''oya san luta gway napachunan nan opatay sunguna. ");
INSERT INTO kyb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ad iningkaw san sachi uyos nan losanay ayasin nan ajam ja chanan umachap san luta ja chanan mammanu'. ");
INSERT INTO kyb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kun anan nan osa kinga, “Pedro, lumiggwat'a ad ummoy'a pummerti as ischam.” ");
INSERT INTO kyb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Gwon anan Pedro, “Achi' kun ma'gwa nat, Apu. Puyus gway achiya' kun nansidsicha san miwhilangay aisaw ja mijachiyay maischa.” ");
INSERT INTO kyb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kun summungwhat ahos chay kingaay manggwana, “Achim mangngagnon aisaw nan ingwhilang Apudyus as nachayus.” ");
INSERT INTO kyb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Namitlu na'gwa nan sachi kun maag ekay nipangatu ad langit chay inilana. ");
INSERT INTO kyb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anna kunay som'osom'on Pedro nan pijaona anan chay inilana, naakammugwan chachay laya'i gway ingwhaun Cornelio nan hoyoy Simon. Kun ummoycha san sagwang chay hoyoy summi'ad. ");
INSERT INTO kyb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nampo'awchaay nanimus nu agwad as Simon gway ananchaon Pedro. ");
INSERT INTO kyb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Som'osom'on kun Pedro nu ngachan nan pijaona anan chay inilana, kumminga nan Ispilitun Apudyus an sija gway manggwana, “Pedro! Agwad chanan tuyu lallaya'i mangimus an si'a. ");
INSERT INTO kyb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lumsa'a ad nihuyog'a gway achi'a manchugwachugwa tan sa'on nan nangiwhaun an chicha.” ");
INSERT INTO kyb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kun nilumsa as Pedro kun anana sasay lallaya'i, “Sa'on nan imusonju, kamanay?” ");
INSERT INTO kyb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kun summungwhatcha gway manggwana, “Ingwhaun cha'ami an Cornelio gway apitan chanan surchachu. Osa takuway nalintog, mangapudyus ja whigwhikon nan losanay Hudyu. Ingwhakan nan anghel Apudyus gway ajakan cha'a san hoyoyna ta chongyona nu ngachan nan iwhakam.” ");
INSERT INTO kyb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kun imperno' Pedro chicha as mangilina. Mawhikat kun lummiggwat as Pedro gway nihuyog an chicha. Whinurnan chanan uchumay susunud san pammati gway iJoppe. ");
INSERT INTO kyb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Asin kun mawhikat kummatongcha ad Cesarea. Inuullay Cornelio chicha ama ahos chanan inajakana gway chochogkana ja chanan hubuyunna. ");
INSERT INTO kyb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Anna kunay lumno' as Pedro san hoyoy inahot Cornelio kun nampalintumong san sanguna gway manchajaw an sija. ");
INSERT INTO kyb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gwon impasi'ad Pedro as sija gway manggwana, “Sumi'ad'a tan takuwa' ahos gway isum!” ");
INSERT INTO kyb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma'aapaapat kus Pedro an sija san lumno'ancha inilana nan angsanay taku gway naayus. ");
INSERT INTO kyb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kun anan Pedro an chicha, “Aagkammuju gway mijachi san lintogmiyay Hudyu nan mijamung ja mangkagka'ay sasan wha'on kus Hudyu. Gwon impailan Apudyus an sa'on gway achi' kun iwhilang nan ngachamman sinatay taku as aisaw ja mijachiyay mijamung. ");
INSERT INTO kyb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Sija nan impaajagnu kus sa'on naanaliya' anna. Ad imuso'ud nu kajuman ipaajag as sa'on?” ");
INSERT INTO kyb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kun anan Cornelio gway summungwhat, “Mi'apat kunay erkaw san amasna uyas mallugwayugwayuwa' ad asna hoyoymi san singwhattang as anchu. Awni kun maag ekay summi'ad nan osa laya'i gway sumiling nan silupna san sakkang'u ");
INSERT INTO kyb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","gway manggwana, ‘Cornelio, chingngorn Apudyus nan lugwayum ja inilana chanan whachangnu sasan whawha'sigwot. ");
INSERT INTO kyb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Humaun'a as umoy ad Joppe mangajag san osa takuway Simon gway ananchaon Pedro gway mangilin Simon gway mamanggwas layat. Agwad nan hoyoyna san ikid nan whaywhay.’ ");
INSERT INTO kyb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Sija nan naniwhaun'u san umali mangajag an si'a kun whayu tan inanusamay ummali. Ad san sana gwachagwad ami losan gway akammumiyay anna as Apudyus an chita'u. Manuullay amiyay manchongor san ingwhakan Apudyus an si'a gway ipaakammum an cha'ami.” ");
INSERT INTO kyb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kun illukin Pedro gway nanukud gway manggwana, “Tuttuwaay maila' san sanaay manisisugwon Apudyus nan taku. ");
INSERT INTO kyb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tan uyay ngachamman sinatay taku san ailiili gway umogjat an Apudyus ja manggwa san ustu masom as Apudyus an sija. ");
INSERT INTO kyb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Akammuju nan ukud Apudyus sasan ijIsrael gway impaakammunaay Whayuway Chamag san mipangkop san ma'aosossaanan ta'u an Apudyus kapu an Hesu Kristu gway Apun nan losanay taku. ");
INSERT INTO kyb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Akammuju nan na'na'gwa san losanay Judea manipud ad Galili san nappung Juan intudtuchu nan mipangkop san honjag. ");
INSERT INTO kyb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","“Akammuju nan mipangkop an Hesus gway iNazaret san namiliyan Apudyus an sija ja nangipaaliyana san Ispilituna ja nangatchana san ayobhongana an sija. Ummoy as Hesus san ailiili nanggwa san whayu ja impawhayuna chanan pinalikatan Chijabyu tan anna as Apudyus an sija. ");
INSERT INTO kyb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ad cha'ami nan mangipano'no' san inilami gway inggwa'inggwana san ilin chanan Hudyu ja ad Jerusalem. Intoycha gway illansachas sija san krus. ");
INSERT INTO kyb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gwon tinakun Apudyus as sija san mi'atluway erkaw kun impailanas sija sasan taku ");
INSERT INTO kyb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","gwon wha'on kusan losanay taku, ahus as cha'ami gway pinilin Apudyus as mangipano'no' gway na'a'an ja na'iinum an sija san natakuwana. ");
INSERT INTO kyb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kun ingwhilinna an cha'amiyay umoy mangipaakammu ja mangipano'no' sasan takuway sija nan chinutu'an Apudyus gway mangu'um sasan matattaku ja natoy. ");
INSERT INTO kyb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","As sija nan ipano'no' chanan losanay profeta gway kapu an sija ligwatan Apudyus chanan whersun nan losanay mamati an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sa'ad san manapaapatan Pedro, ummoy nan Ispilitun Apudyus san losanay nanchochongngor san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kun nataag chanan Hudyu gway namati an Hesus gway nihuyog an Pedro tan uyay ahos sasan wha'on kus Hudyu naatod ahos nan Ispilitun Apudyus an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tan chingngorcha gway asikikingacha san ayasi apapat gway achi kun maagwatan ja chinaychajawcha as Apudyus. Kun anan Pedro, ");
INSERT INTO kyb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Anna achay inagwatcha hos nan Ispilitun Apudyus gway isun nan nangagwatan ta'u, adja agwad osa an cha'aju as mangijachi gway mahonjakancha san chanum?” ");
INSERT INTO kyb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sachi kun ingwhilinna an chicha gway pahonjagcha san ngachan Hesu Kristu. Gwot ingwhakacha an Pedro gway ingkaw jan an chicha as amana erkaw. ");
INSERT INTO kyb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sa'ad chanan apostoles ja nan losanay susunud san pammati ad Judea chingngorcha gway tinuttuwan chanan wha'on kus Hudyu nan ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Gwon ummoy kus Pedro ad Jerusalem inamujuwan chanan Hudyu gway namati an Hesus as sija ");
INSERT INTO kyb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","gway manggwana, “Ka'a umoy ma'a'an sasan achi kun nasuglitan?” ");
INSERT INTO kyb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Sija nan illukin Pedro nangiturturpu gway nanguullit san na'gwa gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Osa achay erkaw san iniingkagwa' ad Joppe, mallugwayugwayuwa' kun impailan Apudyus an sa'on nan isun chi ininop gway chumo''ocho''oya gway nerpud langit gway amas ergwaay uyos gway napachunan nan opatay sunguna kun ummali san agwacha'. ");
INSERT INTO kyb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Amma' kun ilan nan sachi, inila' chanan na'aya'ayasiyay ajam gway atap, chanan umachap ja chanan mammanu'. ");
INSERT INTO kyb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kun chingngor' nan kinga gway manggwana an sa'on, ‘Pedro, lumiggwat'a ad ummoy'a pummerti as ischam.’ ");
INSERT INTO kyb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Gwon ana'ay summungwhat, ‘Achi' kun magwa nat, Apu! Puyus gway achiya' kun nansidsicha san miwhilangay aisaw ja mijachiyay maischa.’ ");
INSERT INTO kyb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kun summungwhat ahos chay kingaay nerpud langit gway manggwana, ‘Achim mangngagnon aisaw nan ingwhilang Apudyus as nachayus.’ ");
INSERT INTO kyb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Namitlu na'gwa nan sachi kun nipangatu nan losan ad langit. ");
INSERT INTO kyb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sachi kun ekay hummu'nag nan tuyu lallaya'i san hoyoy gway iningkagwanmi gway nerpu ad Cesarea gway mangajag an sa'on. ");
INSERT INTO kyb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kun ingwhakan nan Ispilitun Apudyus an sa'onay achiya' manchugwachugwaay mitunud an chicha. Nihuyog ahos nannachaja onomay susunud san pammati kun ummoy amid Cesarea. Kun nilumno' ami losan san hoyoy Cornelio. ");
INSERT INTO kyb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Kun ingwhakan Cornelio an cha'ami nan nangillana san osa anghel gway summisi'ad san hoyoyna gway manggwana an sija, ‘Humaun'a as umoy ad Joppe mangajag san taku gway mangngachan Simon Pedro. ");
INSERT INTO kyb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ad ingwhakana an si'a nan ininon Apudyus gway manaku an si'a ja san losanay wherjannu.’ ");
INSERT INTO kyb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Lukija' kun gway manapapat ummoy an chicha nan Ispilitun Apudyus as isun chay ummaliyana an chita'u san chamu. ");
INSERT INTO kyb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kun simsimmo''u chay anan Apu Hesuson, ‘Nanghonjag as Juan san chanum gwon mahonjakan aju san Ispilitun Apudyus.’ ");
INSERT INTO kyb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Nu Apudyus nan nangatod an chicha san isun nan inatodna an chita'u san namatiyan ta'u an Apu Hesu Kristu, ngachan'u manay manipod an Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chingngorcha kun chi kummino'cha. Kun chinajawcha as Apudyus gway manggwana, “Nu amasnat inatod ahos Apudyus sasan wha'on kus Hudyu nan chimpuway manchu'kancha chanan whersucha ta ma'awhijagcha an Apudyus as ingkaingkana.” ");
INSERT INTO kyb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sa'ad chanan namati gway nasississiyan kapu san palikat gway natojan Esteban chummakus nan uchum ad Fenicia, Cyprus ja Antiokia. Impaakammucha nan ukud gway mipangkop an Hesus sasan Hudyu ekay. ");
INSERT INTO kyb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gwon iningkaw nan uchumay lallaya'i namati gway iCyprus ja iCirene gway ummoy ad Antiokia. Kun impaakammucha hos nan mipangkop an Apu Hesus sasan Hudyuway Grinego nan apapatcha. ");
INSERT INTO kyb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Agwad an chicha nan ayobhongan Apudyus sija nan angsan nan namati gwot summuyutcha an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chummakus ad Jerusalem sasan maayuayusay namati nannaja chamag kun ingwhauncha as Bernabas ad Antiokia. ");
INSERT INTO kyb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hummu'nag kun as sijaot inilana nan ininon Apudyus gway nangipaila san inawhayuna an chicha, nayagsa'an as sija. Kun impapigsana nan somsomo'cha losan gway ipapuutcha ja ituttuyuychaay sumuyut an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Sa'ad as Bernabas whayuway taku ja anna nan ayobhongan nan Ispilitun Apudyus an sija ja napigsa nan pammatina. Sija nan angsanay taku nan naagwis gway nichoka sasan namati an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kun ummoy as Bernabas ad Tarso gway nanganap an Saulo. ");
INSERT INTO kyb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Inchasana kun as sija iyoyna ad Antiokia. Nasintagwon gway na'akimukimungcha sasan maayuayusay namati ad aschi kun angsan chanan takuway sinuyuwancha. Ad Antiokia nan ummunaay nginadnanchas Krischanu chanan namati. ");
INSERT INTO kyb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ad sa'ad san sachi chimpu ummoy ad Antiokia chanan profetaay nerpud Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Osa an chicha gway mangngachan Agabo nan summi'ad kapu san ayobhongan nan Ispilitun Apudyus. Kun ingwhakanaay humu'nag nan amod gway uyat san intiluway luhung. (Na'gwa nannaja san chimpun Claudio gway Emperadorn nan Roma.) ");
INSERT INTO kyb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kun simsimmo' chanan pasuyut Hesus gway mangatod as whachang insikun san lobhong nan osa atchon sasan susunud san pammati gway ingkaw ad Judea. ");
INSERT INTO kyb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kun inggwacha nannaja kun asichaot ipagwit ancha Bernabas an Saulo nan whachangcha sasan mangipangpangu sasan namati ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sa'ad san sachi chimpu pinalikatan Ali Herod chanan uchumay maayuayusay namati. ");
INSERT INTO kyb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kun impakungsurna as Santiago gway sunud Juan. ");
INSERT INTO kyb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Inilana kunay nasom chanan Hudyu impadpapna hos as Pedro. Na'gwa nannaja san chimpun nan pijasta gway ma'gwaniyon Tinapay gway Maid Kun Yeastna. ");
INSERT INTO kyb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nappungna kun pachopap as Pedro impawhayudna kun asinaot paijachug san nasagwayan as onomay surchachu gway nasinnoppatcha nampassupassu gway nangijachug an sija. Tan pangkop Herod gway sumerjaon as Pedro san sangun chanan taku nu mappung nan Pijasta gway ma'gwaniyon Lumaus. ");
INSERT INTO kyb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sija nan iningkaw as Pedro san whawhalluchan. Gwon impapatin chanan maayuayusay namati gway mangilugwayugwayu an sija an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sa'ad san lawhi san chaan Herod ipawhijang as Pedro sasan taku, nanassuy as sija san kagwan nan chugwa surchachu gway natata'od nan imana san chugwa ayuwhing'i. Ad iningkaw ahos chanan surchachu nangijaachug san sagwang nan whawhalluchan. ");
INSERT INTO kyb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Awni kun iningkaw nan nampailaay osa anghel Apudyus kun napadchaan nan whawhalluchan. Kun kinichun nan anghel nan huti' Pedro tot whangonona gway manggwana, “Humangon'a! Kanasom!” Kun na'aan nan ayuwhing'iyay ta'od nan iman Pedro. ");
INSERT INTO kyb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kun anan nan anghel an sija, “Ortom nan silupnu ad nansinilas'a.” Gwot tinuttuwan Pedro. Kun anan ahos chay anghel “Igkam nan kotap nan silupnu ad nitunud'a an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kun tinunud Pedro chay anghel gway lummagwa san whawhalluchan. Achina kun akammu gway tuttuwa nan inggwan chay anghel. Anana kunnu nanininop as sija. ");
INSERT INTO kyb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nilausancha ku chanan umuna ja mi'aggwaay mangijaachug hummu'nagcha san akaay sagwang gway umoy san syudad. Kun maag ekay niibwhat nan sagwang kun lummagwacha. Gwot nangoycha san osa ersa kun maag ekay maid chay anghel. ");
INSERT INTO kyb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kun naagwatan Pedro nan na'gwa an sija kun ananaon, “Ah, akammu'ay tuttuwa tuwaay ingwhaun Apudyus nan anghelnaay ummali nangiligtas an sa'on san ayobhongan Herod ja nan losanay pangkop chanan Hudyu gway oon an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Simsimmo'na kunan sachi ummoy san hoyoy Maria gway inan Juan gway mangngachan ahos as Mer'us. Aschi nan iningkagwan nan angsanay taku naayus gway mallugwayugwayu. ");
INSERT INTO kyb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nan'ab'ab kus Pedro san onob nan sagwang, ummoy tinwhern nan osa huwhaiyay mudchachu gway mangngachan Roda. ");
INSERT INTO kyb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Illasinna kunan kingan Pedro amod nan lagsa'na gwon achina kun inibwhat nan onob. Sijaot inggwana nan nanodcha'ay nanagkulin ad chayo' kun ingwhakanaay agwad as Pedro san sowhan. ");
INSERT INTO kyb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Gwon anancha an sija, “Tingangnu nat.” Gwon impapilitnaay tuttuwa nan ingwhakana. Kun ananchaon, “Anghel nin gway mangijaachug an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Gwon patho' ekas Pedro man'ab'a'ab'ab. Inigkatcha kun nataagcha san inilacha gway sija tuwa. ");
INSERT INTO kyb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kun timpapna chichaot inuullitna an chicha nan ininon Apudyus gway nangipayagwa an sija san whawhalluchan. Kun anana, “Uullitonju hos nannaja an Santiago ja sasan susunud ta'u san pammati.” Kun aysan san sawhaliyay ili. ");
INSERT INTO kyb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mawhikat kun nakuyu chanan surchachuway mangijaachug nu ngachan nan na'gwa a Pedro. ");
INSERT INTO kyb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Impaanap kun Herod as Pedro gwot maid inchasancha an sija, sinumerjana chachay surchachu kun asinaot ipaotoy chicha. Nappung kun chi ummoy as Herod ad Cesarea gway nerpud Judea kun iningkaw ad aschi. ");
INSERT INTO kyb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sa'ad san iniingkagwan Herod ad Cesarea amod nan linguna sasan iTiro ja iSidon. Sija nan nanosossaan chanan uchumay iTiro ja iSidon gway umoy an sija. Ummunacha jan inagwis as Blasto gway osa sasan nangatu pangat nan palasyun Herod ta humachang an chichaay ma'aosossaan an Herod. Merpuwot sija nan anoncha sasan iliyay sa'upon Herod. ");
INSERT INTO kyb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hummu'nag kunan erkaw gway whintong Herod gway manukuchana inigkana nan angangkana gway usern nan ali kun tummu'chu san tukawna gwot nanukud sasan takuway naayus. ");
INSERT INTO kyb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kun nampa'uy chanan taku gway manggwana, “Kingan Apudyus nannaja, wha'on kus kingan nan taku!” ");
INSERT INTO kyb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kun nanipalikat nan anghel Apudyus an Herod tan iyujanaay chajagwon chanan takus sija gway wha'on ku an Apudyus. Naogsan kun natoy. ");
INSERT INTO kyb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gwon nantuttuttuyuy gway nigwerna' nan ukud Apudyus gwot ummachaachu chanan namati. ");
INSERT INTO kyb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nappung kunan inggwan cha Bernabas an Saulo ad Jerusalem nanagkulincha ad Antiokia gway inghuyogchas Juan gway mangngachan ahos Mer'us. ");
INSERT INTO kyb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sa'ad chanan maayuayusay namati ad Antiokia iningkaw chanan uchumay profeta ja mangisussuyu san ukud Apudyus gway cha Bernabas, Simeon gway ma'gwaniyon Negro, Lucio gway iCirene, Manaen gway hubuyun Kuwhinnachur Herod san awhanogna ja as Saulo. ");
INSERT INTO kyb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sa'ad san manchaychajagwancha an Apudyus ja nallaunancha, ingwhakan nan Ispilitun Apudyus an chicha gway manggwana, “Chutu'anju cha Bernabas an Saulo tan pinili' chicha gway manggwa san ipa'gwa' an chicha.” ");
INSERT INTO kyb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nappungcha kun nallaun ja nallugwayu impataycha nan imacha an Bernabas ja Saulo kun asichaot iwhaun chicha. ");
INSERT INTO kyb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sachi kun impooy nan Ispilitun Apudyus cha Bernabas an Saulo ad Seleucia gwot namapurchaay ummoy ad Cyprus. ");
INSERT INTO kyb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hummu'nagcha kun ad Salamina gway sa'up nan Cyprus impaakammucha nan ukud Apudyus sasan sinagogan chanan Hudyu. Inghuyogcha as Juan gway mangngachan ahos Mer'us tot humachang an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kinagka'aycha kunan ailiiliyay sa'up nan Cyprus ingkanad Pafo inaspuyancha nan osa takuway mansayusayumang'a gway mangngachan Bar Hesus gway osa Hudyu gway wha'wha''onay profeta. ");
INSERT INTO kyb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hubuyun Sergio Paulo gway kuwhinnachur ad Cyprus gway osaay nalaing gway taku. Impaajag nan kuwhinnachur cha Bernabas an Saulo tan whayugwona manchongor san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Gwon sa'ad as Bar Hesus (Elimas nan ngachanna san Grinego gway nan pijaona anan mansayusayumang'a) pinachasnaay ijachi nan kuwhinnachur manchongor an Bernabas ja Saulo tan whayugwonaay mijachaju nan kuwhinnachur san pammati. ");
INSERT INTO kyb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ad sa'ad as Saulo gway mangngachan ahos Pablo nanterwhasu nan ayobhongan nan Ispilitun Apudyus an sija kun intotollongna as Bar Hesus ");
INSERT INTO kyb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","gway manggwana, “Si'aay ana' nan Chijabyu, ahursun nan losanay nalintog! Amod ekay laingnu mangallilaw ja manggwas lagwing. Patinajunay pi'tutom nan tuttuwaay mipangkop an Apudyus! ");
INSERT INTO kyb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ad chongyom na! Chusaon cha'a an Apudyus ad na'uyap'a ad achim pun maila nan padchan nan init ingkana san hotong nan erkaw gway ma'aila'a.” Nawhanulingot nan ilana kun man'apu'apu'ap gway mananap as mangigwid an sija. ");
INSERT INTO kyb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Inilan kun chay kuwhinnachur nan na'gwa namati as sija tan nataag san sussuyu mipangkop an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Namapur kus Pablo ja chanan huyunna ad Pafo, ummoycha ad Perge gway osaay syudad nan Pamfilia. Gwon tinaynan Juan Mer'us chicha ad aschi gwot nanagkulin ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nangoycha kud Perge ummoycha ad Antiokia gway sa'up nan Pisidia. Ad sa'ad san Erkaw gway Umillongan nilumno'cha san sinagoga kun tummu'chucha. ");
INSERT INTO kyb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nappung kun niwhasa nan Lintog Moses ja insuyat chanan profeta nangiwhaun chanan mangipangpangu san sinagoga an chicha gway manggwana, “Susunud, nu agwad iwhakaju sasan taku as mangipapigsa san somsomo'cha iwhakaju.” ");
INSERT INTO kyb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Summi'ad as Pablo kun nantajakay nangipakino' an chicha gway manggwana, “Susunud gway ijIsrael ja cha'aju gway wha'on kus Hudyu gway mangapudyus, manchongor aju! ");
INSERT INTO kyb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sa'ad as Apudyus gway chaychajagwon ta'uway ijIsrael, pinilina chanan nerpugwan ta'u. Kun whinadngana chicha gwot ummadadchuwancha san iniingkagwanchad Egipto. Kapu san impailanaay napigsaay ayobhongana illagwana chicha san sachi ili. ");
INSERT INTO kyb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","San unog nan opat kasut gway tagwon inanusana chicha san iniingkagwancha san luta gway maid kun ingkaw as taku. ");
INSERT INTO kyb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Inawha'na kunan pituway ili ad Canaan, inatodna nan luta sasan takuna gway ijIsrael as man'ugwacha. ");
INSERT INTO kyb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na'gwa chana losan san unog nan opat kasut ja limampuyu tagwon. “Napungpung kun chachi nanchutu' as Apudyus an chicha as nampassupassuway nangilintog an chicha ingkana an profeta Samuel. ");
INSERT INTO kyb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Gwot nan'ochawcha as ali kun nan'aliyon Apudyus as Saulo gway ana' Kis gway nerpu san kana' Benjamin. Nantuyay as Ali Saulo as opat puyuway tagwon. ");
INSERT INTO kyb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Awni kun inaan Apudyus as Saulo san ina'alina kun insu'atna as Dabid as nan'alicha. Amasna nan anan Apudyus san mipangkop an Dabid, ‘Inila' as Dabid gway ana' Jesse gway masoma' as amod an sija. Mamatpati as sija san losanay whayugwo'.’ ");
INSERT INTO kyb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Nerpu san kana' Dabid nan ingwhawhagkan Apudyus gway impaalina as manaku sasan ijIsrael gway as Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sa'ad san chaan Hesus iluki gway mansuyu naahus Juan gway manghohonjag ipaakammu sasan losanay ijIsrael gway maserpu manchu'kancha chanan whersucha ad nampahonjagcha. ");
INSERT INTO kyb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Takangay kun mappung nan niwhaunan Juan anana sasan taku, ‘Ananju ninaon sa'on nan ingwhaun Apudyus gway manaku an cha'aju? Wha'on, agwad nan umali mipasu an sa'on ad achiya' kun miwhilang as mansilwhi an sija uyay mangaan san sinilasna.’ ");
INSERT INTO kyb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Susunud gway kana' Abraham ja cha'ajuway wha'on kus Hudyu gway mangapudyus, chita'u nan nangatchan Apudyus san ukudnaay mipangkop san manakuwana an chita'u! ");
INSERT INTO kyb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tan sa'ad chanan takuway ingkaw ad Jerusalem ja chanan papangatcha, achicha kun whinigwhig gway as Hesus nan ingwhaun Apudyus. Achicha kuhos naagwatan nan ingwhakawhakan chanan profeta gway miwhasawhasa san gwaschi Erkaw gway Umillongan. Gwon kapu an chicha tummuttuwa chay ingwhakan chanan profeta san agwi gway lodchongancha gway matoy as Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ta'on nu maid inchasancha as kapun nan mangipaotojancha an Hesus, impapilitchaay ipaotoy Pilato as sija. ");
INSERT INTO kyb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Inggwacha kunan losanay nilista san Ukud Apudyus gway mipangkop an sija, impascha nan lachagna san krus kun iyoycha san lijangay loyobhonan. ");
INSERT INTO kyb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Gwon tinakun Apudyus as sija. ");
INSERT INTO kyb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kun nampaipaila as sija as angsanay erkaw sasay nihuyohuyog an sija manipud ad Galili ingkana ad Jerusalem. Ad san sana chicha nan mangipanopano'no' san mipangkop an sija sasan taku. ");
INSERT INTO kyb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Kun ipaakammumi an cha'aju nan Whayuway Chamag gway ingwhawhagkan Apudyus sasan nerpugwan ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tinungpern Apudyus nan sachi ingwhawhagkana sasan kana'cha gway chita'u san nanakuwana an Hesus. Isun nan nilista san mi'aggwaay Salmo gway anan Apudyus, ‘Si'a nan Ana''u, san sana erkaw nangngachana' Amam.’ ");
INSERT INTO kyb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Ad kapu tan tinakun Apudyus as Hesus achi kun puyus mahuju'. Amasna nan ingwhakan Apudyus gway ananaon, ‘Oo' gway oon an cha'aju nan ingwhawhagka' an Dabid gway oo'.’ ");
INSERT INTO kyb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Sija nan agwad ahos nan uchumay nilista san Salmo gway ananaon: ‘Achim pun puyus ijujaay mahuju' nan Mansilsilwhiyom gway maid whersuna.’ ");
INSERT INTO kyb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Sa'ad as Dabid impatungperna kunan pangkop Apudyus an sija san chimpuna, natoy gwot niilhon san niilhonan chanan nerpugwana kun nahuju' nan lachagna. ");
INSERT INTO kyb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jon sa'ad as Hesus gway tinakun Apudyus achi kun nahuju' nan lachagna. ");
INSERT INTO kyb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Sija nan susunud, akammugwonju otjan gway mipaakammu an cha'aju gway ligwatan Apudyus chanan whersu ta'u kapu an Hesus. Akammugwonju hos gway losanay mamati an sija magwasgwas nan losanay whersuna gway achin kunan Lintog Moses lobhong gwasgwason. ");
INSERT INTO kyb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ad ammanju ilan ta achi ma'gwa an cha'aju nan impaiwhakan Apudyus sasan profeta gway manggwana, ");
INSERT INTO kyb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Chongyonju, cha'ajuway nan manamaamamang! Mataag aju san oo' ad awni ad natoy aju! Tan anna nan oo' san chimpuju gwon achiju kun puyus patiyon uyay nu agwad mangipaagwat an cha'aju.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Anna kunay lumagwa cha Pablo an Bernabas san sinagoga nampa'pa''aasi chanan taku an chicha ta iwhakacha asin nan insuyucha san umali Erkaw gway Umillongan. ");
INSERT INTO kyb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nahu'er ku chanan taku san sinagoga nihuyog an cha Pablo ja Bernabas chanan angsanay Hudyu ja chanan wha'on kus Hudyu gway summuyut san pammatin chanan Hudyu. Kun inamman cha Pablo iwhaka an chichaay ituttuyuycha mawhijag kapu san inawhayun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Asin kunay Erkaw gway Umillongan takangay masinumili chanan takuway naayus tot manchongorcha san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Gwon inilan ku chanan uchumay Hudyu nan amochay taku amod nan aposcha kun sinuplingcha nan ingwhakan Pablo. Kun pinawhainancha hos as Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Gwon natuyod cha Pablo an Bernabas gway nanukud gway manggwana, “Maserpu umuna janay mipaakammu an cha'aju nan ukud Apudyus. Gwon sa'ad tan achiju kun patiyon ja ipailajuway achi aju kun miwhilangay ma'awhijag an Apudyus as ingkaingkana, taynanmi cha'aju ad ummoy ami sasan wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tan annaja nan ingwhilin Apudyus an cha'ami gway manggwana: ‘Chinutu'a' si'a as isun chi silaw gway mamadcha san somsomo' chanan wha'on kus Hudyu tot ipaakammum nan matakuwan chanan taku san intiluway luhung.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chingngorn ku chanan wha'on kus Hudyu nannaja nayagsa'ancha ja nerjadcha san ukud Apudyus. Kun losanay pinilin Apudyus gway ma'awhijag an sija as ingkaingkana, namaticha. ");
INSERT INTO kyb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kun nigwerna' nan mipangkop an Apu Hesus san ailiili ad Antiokia. ");
INSERT INTO kyb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Gwon kinuyun chanan papangat nan Hudyu chanan mangapudyus gway wha'on kus Hudyu gway hubhuwhai mawhigwhigwhig ja chanan mangipangpanguway lallaya'i san sachi syudad. Kun illukichaay mamalikat an Pablo ja Bernabas kun pinerjawcha chicha san sachiyay syudad. ");
INSERT INTO kyb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sija nan pinu'pu'an cha Pablo an Bernabas nan chapur san i'icha as mangakammugwancha gway lagwingon Apudyus nan inggwacha ja chusaona chicha. Kun ummoy cha Pablo an Bernabas ad Iconio. ");
INSERT INTO kyb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ad sa'ad chanan pasuyut Hesus gway natchay ad Antiokia amod nan lagsa'cha ja anna nan ayobhongan nan Ispilitun Apudyus an chicha losan. ");
INSERT INTO kyb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Isuna hos nan na'gwa ad Iconio gway ummoy cha Pablo an Bernabas san sinagogan chanan Hudyu nansuyu kun angsan chanan Hudyu ja wha'on kus Hudyu gway namati an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Gwon sa'ad chanan Hudyu gway achi kun mamati kinuyucha chanan wha'on kus Hudyu ja pinalingucha chicha ta kuyaoncha chanan susunud san pammati. ");
INSERT INTO kyb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Sija nan nawhajagcha Pablo an Bernabas gway iniingkaw ad aschi. Natuyodchaay mangiwhaka san mipangkop an Apu Hesus. Impano'no' Apu Hesus gway tuttuwa nan iwhakawhakacha mipangkop san inawhayuna san nangatchana an chicha san ayobhonganay manggwa san mangimatunan ja mataakan. ");
INSERT INTO kyb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Gwot achi kun naninnayaan chanan taku san sachi syudad. Anna chanan ummamhuyuy sasan Hudyu ja sa'ad chanan uchum ummamhuyuycha sasan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Sachi kun nanuukud chanan wha'on kus Hudyu ja chanan Hudyu gway nitapi ahos chanan papangatcha tot palikatancha ja whinwhintukoncha chanan apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Naakammugwan ku chanan apostoles nan pangkopcha, ummoycha lummajaw sasan syudad nan Listra ja Derbe gway sa'upon nan Liconia ja sasan serronchaay ili. ");
INSERT INTO kyb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kun impaakammucha nan Whayuway Chamag ad aschi. ");
INSERT INTO kyb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Iningkaw ad Listra nan osa laya'i gway tummutu'chu gway achi kun ma'achayan. Sikuchay pilay as sija san nijana'ana. ");
INSERT INTO kyb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nanchochongngor as sija an Pablo. Intotollong kun Pablo gwot inilana gway anna nan pammatinaay humayu, ");
INSERT INTO kyb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","tinowhagnaay nan manggwana, “Sumi'ad'a!” Tummaud chay laya'iyot nanadchadchayan. ");
INSERT INTO kyb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Inilan ku chanan amochay taku nan inggwan Pablo impa'uycha san niLiconian gway manggwana, “Lummajug chanan apudyus gway ummali an chita'u gway isun chanan taku!” ");
INSERT INTO kyb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kun nginadnancha as Bernabas as Zeus ja sa'ad as Pablo nginadnancha as Hermes tan sija nan mangiiwhaka san iwhakacha. ");
INSERT INTO kyb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sa'ad nan templon nan sinang'apudyuschaay Zeus agwad san lasin nan syudad kun iyoy nan pachin nan templo ja chanan taku san sagwang gway luyumno'an san syudad chanan toroway wha'a ja tabwha' gway mijongong sasan ajam tan whayugwonchaay ichatun sasay apostoles. ");
INSERT INTO kyb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Gwon naakammugwan kun chachay apostoles gway cha Bernabas an Pablo nan pangkopcha, whiniswhis'icha nan silupcha kun nanu'yuschaay ummoy sasan naayusay taku. ");
INSERT INTO kyb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Kun nampo'awchaay manggwana, “Huhuyun, kajuman oon nan amasna? Taku ami hosay isuju. Umalimi ipaakammu an cha'aju nan Whayuway Chamag tot ijakayyu sannachajaay maid kutu'na ad sija chajagwonju nan mawhiwhijag gway Apudyus gway nanggwa san langit, luta, whaywhay ja losanay ingkaw sannachaja. ");
INSERT INTO kyb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Sa'ad san agwi iyujan Apudyus chanan losanay taku gway manggwa san whayangna whayugwonchaay oon. ");
INSERT INTO kyb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gwon ta'on nu amaschi achina kun iyuja gway maid maillan nan ina'apudyusna tan inggwa'inggwana nan whayu. Inatchana cha'aju as uchan ja angsanay apit san ustu'ustuway chimpu kun pinonno'na cha'aju san ma'an ja lagsa' san somsomo'ju.” ");
INSERT INTO kyb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ta'on nu ingwhakan cha Pablo an Bernabas nan amasna, nampasikabchaay mangijachi sasan takuway mangatod as chatun an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gwon hummu'nag chanan uchumay Hudyu gway nerpu ad Antiokia ja Iconio. Inagwischa ku chanan takuway naayus whininwhintugcha as Pablo gwot ingkayadcha san lasin nan syudad tan anancha kunnu natoy. ");
INSERT INTO kyb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Gwon whinaligwonggwongan ku chanan pasuyut Hesus as Pablo, hummangon kun nana''ulin san syudad. Mawhikat kun lummajawcha an Bernabas gway ummoy ad Derbe. ");
INSERT INTO kyb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Impaakammun cha Pablo an Bernabas nan Whayuway Chamag ad Derbe gwot angsan nan inagwischaay nangngachan pasuyut Hesus. Kun nana''ulincha ad Listra, Iconio ja Antiokia ad Pisidia. ");
INSERT INTO kyb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Impapigsacha nan somsomo' chanan pasuyut Hesus ja tinudtuchugwancha chicha tot sumissija nan pammaticha. Kun anancha, “Maserpuway angsan nan mapalikatan ta'u ad asi ta'uwot mitapi sasan takuway ituyajan Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nanchutu' cha Pablo an Bernabas as mangipangpangu sasan losanay maayuayusay namati. Nappungcha kun nallugwayu ja nallaun impawhijangcha chicha an Apu Hesus gway nantayo'ancha. ");
INSERT INTO kyb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nangoy kun cha Pablo an Bernabas ad Pisidia hummu'nagcha ad Pamfilia. ");
INSERT INTO kyb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Impaakammucha kunan ukud Apudyus ad Perge ummoycha ad Atalia ");
INSERT INTO kyb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","gwot namapurcha gway nanagkulin ad Antiokia gway ad aschi nan nangitayo'an chanan maayuayusay namati an chicha an Apudyus tot whadngana chicha san terwhasucha gway appupungpungcha. ");
INSERT INTO kyb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hummu'nagcha kud Antiokia inayuscha chanan maayuayusay namati. Kun ingwhakacha nan losanay inggwa'inggwan Apudyus kapu an chicha ja ininonaay namachang an chicha tot mamati hos chanan wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Gwot nawhajakay iniingkawcha sasan pasuyut Hesus san sachi ili. ");
INSERT INTO kyb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Iningkaw chanan uchumay lallaya'i gway nerpud Judea gway ummoy ad Antiokia. Kun nansuyucha sasan susunud san pammati gway manggwana, “Nu achi aju pasuglit tan sija nan anan nan lintog gway inatod Apudyus an Moses, achi aju kun mataku.” ");
INSERT INTO kyb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kun na'aisi' as amod ja na'asinsinnungwhat cha Pablo an Bernabas an chicha. Sija nan ingwhauncha cha Pablo an Bernabas ja nan uchumay namati ta umoycha ad Jerusalem tot manuukudcha sasan apostoles ja chanan mangipangpangu sasan namati ad aschi mipangkop sannaja insuyucha. ");
INSERT INTO kyb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pinayungud ku chanan maayuayusay namati chicha nangoycha ad Fenicia ja Samaria gway nangipaakammu san namatiyan chanan wha'on kus Hudyu kun nallaylajad as amod chanan susunud san pammati gway nangngor. ");
INSERT INTO kyb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hummu'nagcha kud Jerusalem minangilin chanan maayuayusay namati, chanan apostoles ja chanan mangipangpangu sasan namati chicha. Kun inuullitcha losan nan inggwan Apudyus an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Gwon summi'ad chanan uchumay namati gway nitapi san hungkuy chanan Pariseo gway manggwana, “Maserpuway masuglitan chanan wha'on kus Hudyu ja miwhaka an chicha gway chumngorcha san Lintog Moses.” ");
INSERT INTO kyb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kun naayus chanan apostoles ja chanan mangipangpangu sasan namati tot manuukudcha san mipangkop sannaja. ");
INSERT INTO kyb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nawhajagcha kunay nansinsinnungwhat summi'ad as Pedro gway manggwana an chicha, “Susunud, akammuju gway sa'ad san agwi osaa' gway pinilin Apudyus an cha'aju gway mangipaakammu san Whayuway Chamag sasan wha'on kus Hudyu ta chongyoncha ja mamaticha. ");
INSERT INTO kyb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ad as Apudyus gway mangakammu san somsomo' nan losanay taku, impano'no'na sasan wha'on kus Hudyu gway namati kapu san nangatchana san Ispilituna an chicha gway isun nan nangatchana an chita'u. ");
INSERT INTO kyb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ad manisisugwon Apudyus chita'u ja chicha tan chinayusana nan somsomo'cha kapu san pammaticha. ");
INSERT INTO kyb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kunja kajuman padpadchason as Apudyus? Kajuman pa'gwa sasan pasuyut Hesus nan achin chanan nerpugwan ta'u lobhong oon gway isu ta'u hosay achi ta'u kun ma'a'gwa? ");
INSERT INTO kyb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Gwon kapu san inawhayun Apu Hesus mamati ta'uway mataku ta'u as isun nan manakuwana an chicha.” ");
INSERT INTO kyb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kun nakinokino' chanan losanay naayus gway nanchochongngor an cha Pablo an Bernabas gway nanguullit sasan mangimatunan ja mataakan gway inggwan Apudyus sasan wha'on kus Hudyu kapu an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nappung kun, kumminga hos as Santiago gway manggwana, “Susunud, chongyona' ad! ");
INSERT INTO kyb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","A''ipaagwat Simon Pedro nan chamuway nangipailan Apudyus san nangipatokana sasan wha'on kus Hudyu kapu san namiliyana an chicha as mangngachan takuna. ");
INSERT INTO kyb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nijunud ahos nan annaja san ingwhakan chanan profeta gway anancha, ");
INSERT INTO kyb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Anan Apudyus, “Tapin ad chi erkaw managkulina' ad ipagkulin'u nan natangkaanay mantuyajan Dabid. Ipagkulin'u nan nigwa''i ad pinawhayu', ");
INSERT INTO kyb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tot sa'ad chanan uchumay taku san luhung anaponcha as sa'onay Apu, mitapi nan losanay wha'on kus Hudyu gway pinili' as mantaku'.” ");
INSERT INTO kyb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Amasna nan impaakammun Apudyus san agwaagwi.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kun intuyuy Santiago gway manggwana, “Nan maiwhaka' achi ta'u palikatan chanan wha'on kus Hudyu gway mamati an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gwon suyatan ta'uwot chicha ta achicha mangan sasan ma'anay ijachin Apudyus gway nichatun san sinang'apudyus. Achicha manggwas whayangna awhawhain ja ina'aisaw gway pijaon nan longag. Achicha mansicha san ajamay achi kun nipachaya ja achicha hos ischa nan chaya. ");
INSERT INTO kyb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tan nalluki sasan namanguway lunap san agwi gway nipaapaakammu san losanay syudad nan Lintog Moses tan niwhasawhasa sasan sinagoga san gwaschi Erkaw gway Umillongan.” ");
INSERT INTO kyb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kun nanosossaan chanan apostoles, chanan mangipangpangu san namati ja chanan losanay maayuayusay namati ta mampilicha san lallaya'iyay merpu an chicha ad ingwhauncha chicha gway mihuyog an cha Pablo an Bernabas gway umoy ad Antiokia. Kun ingwhauncha nan chugwaay whigwhikon chanan namati gway as Judas gway mangngachan ahos Barsabas ja as Silas. ");
INSERT INTO kyb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Amasna nan anan nan impagwitchaay suyat an chicha: “Sa'ad as cha'ami gway susunudjuway apostoles ja mangipangpangu sasan namati ad Jerusalem, nanuyat ami an cha'ajuway susunudmiyay wha'on kus Hudyu ad asnatay Antiokia, Siria ja Silicia. Ininon nan whijagju! ");
INSERT INTO kyb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Chingngormi gway ummali ad asnat nan uchumay lallaya'iyay huyunmi nerpud asna kun kinuyucha cha'aju kapu san ingwhakacha gwot nakuyu nan somsomo'ju. Gwon maid kun ingwhakami an chichaay amaschi nan ooncha. ");
INSERT INTO kyb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sija nan nanosossaan amiyay nampili as iwhaunmi an cha'aju gway mihuyog an cha Bernabas an Pablo gway ipatpatogmi. ");
INSERT INTO kyb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Inatodcha nan whijagcha gway uyay ekay i'atoycha kapu san mansilwhiyancha an Apu ta'uway Hesu Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sija nan iwhaunmi hos cha Judas an Silas tot iwhakacha hos an cha'aju nan mipangkop san annaja suyatmi. ");
INSERT INTO kyb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Tan na'aosossaan ami san Ispilitun Apudyus gway achimi cha'aju pachagsonan san ukalimi. Ahus nan annachaja whilin nan maserpuway suyutonju gway ");
INSERT INTO kyb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","‘Achi aju mangan san ma'anay nichatun san sinang'apudyus. Achi aju mansicha san chaya. Achi aju mansicha san ajamay achi kun nipachaya. Achi aju manggwas whayangna awhawhain ja ina'aisaw gway pijaon nan longag. Ustu nan o'oonju nu achiju oon nan annachaja. Ahus chi.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Impayungudcha ku chachay niwhaun ummoycha ad Antiokia. Inayuscha ku chanan losanay namati inatodcha an chicha nan suyat. ");
INSERT INTO kyb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Whinasan ku chanan taku nan suyat, amod nan lagsa'cha kapu tan pummigsa nan somsomo'cha san sachi suyat. ");
INSERT INTO kyb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sa'ad cha Judas an Silas gway profeta hos, angsan nan ingwhakachaay nangipapigsa san somsomo' chanan susunud san pammati kun pummigsacha. ");
INSERT INTO kyb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Iningkawcha kud aschi as amanaay erkaw, pinayungud chanan susunud san pammati chicha gway manggwana, “Ammanju umoy.” Kun nanagkulincha sasan nangiwhaun an chicha ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Gwon sa'ad cha Pablo an Bernabas, natchaycha ad Antiokia gway nansuyusuyu ja nangipaapaakammu san Whayuway Chamag mipangkop an Apu Hesus. Huyuncha hos nan angsanay namati gway hummachang an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Naya'pus kunan amanaay erkaw anan Pablo an Bernabas, “Inta kagka'ajon chanan susunud san losanay syudad gway nangipaakammugwanta san mipangkop an Apu Hesus ta ilanta nu ininon nan whijagcha.” ");
INSERT INTO kyb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Whayugwon Bernabas gway ihuyogcha hos as Juan gway mangngachan ahos Mer'us. ");
INSERT INTO kyb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Gwon simsimmo' Pablo gway whayu nu achicha ihuyog as sija tan tinaynana chicha ad Pamfilia ja achina kun intuyuy gway na'aterwhasu an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kun nanisi' cha Pablo an Bernabas, sija nan nansiyancha. Inghuyog Bernabas as Mer'us kun namapurchaay ummoy ad Cyprus. ");
INSERT INTO kyb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Gwon pinilin Pablo as Silas as huyunna. Illugwayuwan ku chanan susunud san pammati chicha tot whadngan Apudyus chicha, aysancha. ");
INSERT INTO kyb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kun ummoycha kinagka'ay nan intiluway Siria ja Silicia kun impapigsacha nan somsomo' chanan maayuayusay namati. ");
INSERT INTO kyb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Kun hummu'nag ahos as Pablo ad Derbe ja Listra. Kun iningkaw nan osaay pasuyut Hesus gway mangngachan Timoteo. Hudyu nan inanaay namati gwon Griego nan amana. ");
INSERT INTO kyb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Whayu nan iwhakawhakan chanan susunud san pammati ad Listra ja Iconio san mipangkop an Timoteo. ");
INSERT INTO kyb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Whayugwon Pablo gway ihuyog as Timoteo. Inajakana kus sija, sinuglitana tan akammun chanan Hudyuway ingkaw san chachi ili gway Griego nan amana. ");
INSERT INTO kyb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ad san losanay ili umajancha, inchunchuncha impaakammu sasan namati nan whilin gway ingwhakan chanan apostoles ja mangipangpangu sasan namati ad Jerusalem gway maserpuway ooncha. ");
INSERT INTO kyb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sija nan pummigsa nan pammatin chanan maayuayusay namati ja whinikatay umachaachucha. ");
INSERT INTO kyb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kun nangoy cha Pablo ja nan huhuyunna san sa'upon nan Frigia ja Galacia tan iyachin nan Ispilitun Apudyus chicha gway mangipaakammu san ukud Apudyus ad Asia. ");
INSERT INTO kyb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hummu'nagcha kun san ikad nan Misia, umoycha otjan ad Bitinia gwon achin kuhos nan Ispilitun Hesus iyuja chicha. ");
INSERT INTO kyb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Sija nan nangoycha ekay ad Misia gway ummoy ad Troas. ");
INSERT INTO kyb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gwot lawhi kun, iningkaw nan impailan Apudyus an Pablo. Inilana nan osa laya'iyay iMacedonia gway summisi'ad gway mampa'pa''aasi an sija gway manggwana, “Umali'aud ad Macedonia tot whadngam cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nappungna kun ilan na sachi, nerniggwat amiyay umoy ad Macedonia tan inakammumi gway inajakan Apudyus cha'ami gway mangipaakammu san Whayuway Chamag sasan takud aschi. ");
INSERT INTO kyb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Namapur ami kunay nerpud Troas, inchagkusmi ad Samotracia. Mawhikat kun kummatong ami ad Neapolis. ");
INSERT INTO kyb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nerpu ami kud aschi, ummoy amid Filipos gway osaay cha'or syudad gway sa'upon nan Macedonia gway osa ahosay sa'upon nan tuyay nan iRoma. Iningkaw ami san sachiyay syudad as amanaay erkaw. ");
INSERT INTO kyb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","San Erkaw gway Umillongan, lummagwa ami san sagwang gway luyumno'an san ili kun ummoy ami san ikid nan gwanggwang gway ananmi kunnu agwad luyuwwayuwan. Tummu'chu ami kun na'aapapat ami sasan hubhuwhaiyay naamung san sachi. ");
INSERT INTO kyb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ad sa'ad nan osa huwhaiyay nanchochongngor gway mangngachan Lydia gway iTiatira, malla'ya'u san man'apapatokay luput ja osa ahosay manchaychajaw an Apudyus. Inigkat Apu Hesus nan somsomo'na kun inammana chongyon chanan ingwhakawhakan Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nahonjakan kus sija ja chanan ahumerjanna, iyagwisna ananon, “Nu iwhilangju as sa'on gway tuttuwa namati an Apu Hesus, umali ajuud manchagwos san hoyoy'u.” Aadchina ekajay umoy ami. ");
INSERT INTO kyb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sa'ad ahos san osa erkaw gway ummajanmi san luyuwwayuwan, inahotmi nan osa mudchachu gway whawhallas. Nilno' nan chimunju as sija gway anna nan ayobhonganaay manawhig. Angsan nan pila'ay ayaayan chanan simmudchachu an sija kapu san manawhikana. ");
INSERT INTO kyb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kun tinuntunudna cha'ami ancha Pablo gway ip'aip'awna gway manggwana, “Sa'ad nannachaja taku mansilsilwhicha san Angatuwanay Apudyus! Ipaakammucha an cha'aju nan ininonjuway mataku!” ");
INSERT INTO kyb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Angsanay erkaw nan nangiwhagawhagana san amasna. Gwot nappog kus Pablo, nansakung san whawhallas kun anana san chimunju, “Sa ngachan Hesu Kristu, lumagwa'a san annajaay huwhai!” Kun nernagwa chay chimunju say huwhai. ");
INSERT INTO kyb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Inilan ku chanan simmudchachu an sijaay mummaid nan mamila'ancha, chimpapcha cha Pablo an Silas. Kun whinuthutcha chicha iyoy san agwachan nan susummerjaan san sangun chanan mantutuyay san ili. ");
INSERT INTO kyb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Iyoycha kun chicha sasan mantutuyay, anancha, “Hudyu chana ad kuyukuyugwoncha nan syudad ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Isuyucha chanan ukaliyay mijachi san lintog ta'uway achi kun mawhalinay agwaton gwinnu oon ta'uway iRoma.” ");
INSERT INTO kyb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kun inuhuwan chanan taku cha Pablo an Silas. Whinis'in chanan mantutuyay nan silupcha kun impaabchoycha chicha. ");
INSERT INTO kyb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nappung kunan naabchaabchojancha, ingwhayudcha chicha kun pinuyungcha nan mangijaachug tot ammana chicha ijachug. ");
INSERT INTO kyb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nappungcha kun puyungon as sija, iyoyna chicha san u'u' nan whawhalluchan kun insamangna inipit nan i'icha san chugwa chagsonay aju gway nakigwa'an. ");
INSERT INTO kyb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sa'ad san kagwan nan lawhi, mallugwayugwayu ja man'anta'anta cha Pablo an Sila gway manchaychajaw an Apudyus. Gwot manchochongngor an chicha chanan uchumay whayud. ");
INSERT INTO kyb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kun maag ekay nangita as amod sija nan nijukajug nan whawhalluchan. Kun maag ekay niibwhat chanan losanay onob ja na'aan nan ayuwhing'iyay nita'od sasan losanay whayud. ");
INSERT INTO kyb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nawhangon ku chay mangijaachug gwot inilina gway niibwhat nan onob nan whawhalluchan, nilu'pusna nan ispadana gway otojona otjan nan longagna tan anana kunnu ummagwid chanan whayud. ");
INSERT INTO kyb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Gwon nampo'aw as Pablo gway manggwana, “Kamma otojon nan longagnu? Gwachagwad ami losan!” ");
INSERT INTO kyb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nampaaya kun chay mangijaachug san silaw, nernano' san agwachan cha Pablo. Kun nampalintumong as sija gway mamaypajogpog san sangun cha Pablo an Silas. ");
INSERT INTO kyb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Sachi kun impayagwana cha Pablo an Silas. Kun anana, “Ngachan nan maserpu oo' ta matakuwa'?” ");
INSERT INTO kyb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kun anancha, “Mamati'a an Apu Hesus ad nataku'a ja chanan ahumerjannu.” ");
INSERT INTO kyb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kun ingwhakacha nan ukud gway mipangkop an Apu Hesus an sija ja san losanay taku gway agwad san hoyoyna. ");
INSERT INTO kyb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sa'ad san sachi lawhi, inajakana chicha san agwachan nan chanum. Inuyasana chanan najaman an chicha kun nampahonjag as sija ja chanan ahumerjanna. ");
INSERT INTO kyb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gwot inajakana cha Pablo an Silas ad chayo' nan hoyoyna kun pina'anana chicha. Nayagsa'cha losanay singwherjan san namatiyancha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mawhikat kun, ingwhilin chanan mantutuyay sasan pulis gway iwhakacha sasan mangijaachug gway ipayagwacha chachay taku. ");
INSERT INTO kyb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sija nan ingwhakan chay mangijaachug an Pablo gway manggwana, “Ingwhilin chanan mantutuyay gway mapayuhusan aju. Sija nan i'aju ad ammaanjuway umoy.” ");
INSERT INTO kyb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Gwon anan Pablo sasan pulis, “Impaabchoy cha'ami san sangun chanan taku ta'on nu chaan ami masumerja gway nan iRoma ami! Kun impawhayudcha cha'ami! Sana kunja ijagagka'awchaay mamerjaw an cha'ami? Achi ku ma'gwa nat! Maserpu umali chanan mantutuyay gway mangilagwa an cha'ami!” ");
INSERT INTO kyb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kun impachamag chanan pulis nan ingwhakan Pablo sasan mantutuyay san ili. Gwot ummogjatcha san chingngorcha gway iRoma cha Pablo an Silas. ");
INSERT INTO kyb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Sija nan ummoycha whinawhagwi nan inggwacha an chicha. Kun impayagwacha chicha san whawhalluchan asichaot iwhaka an chichaay lumajawcha san sachi syudad. ");
INSERT INTO kyb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lummagwa kun cha Pablo an Silas san whawhalluchan, ummoycha san hoyoy Lydia. Naninni''ilacha sasan susunud san pammati kun impapigsacha nan somsomo'cha gwot lummajawchad aschi. ");
INSERT INTO kyb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nangoy kun cha Pablo an Silas ad Amfipolis ja Apolonia, hummu'nagchad Tesalonica gway agwachan nan sinagogan chanan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kun ummoy as Pablo san sinagoga gway isun nan sikud gway o'oona. Ad san tuyuway chumingku san gwaschi Erkaw gway Umillongan, nanukud as sija sasan taku mipangkop san Ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Impaagwatna ja impano'no'na gway maserpu matoy nan Kristu ad nataku. Kun anana, “Sa'ad as Hesus gway ipaakammu' an cha'aju, sija nan Kristu gway manaku sasan taku.” ");
INSERT INTO kyb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Anna nan uchum gway namati san ingwhakana gwot nitapicha ancha Pablo an Silas, isun ahos chanan angsanay wha'on kus Hudyu gway manchaychajaw an Apudyus ja angsanay mawhigwhig gway hubhuwhai. ");
INSERT INTO kyb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gwon naapos ku chanan uchumay Hudyu gwot inajakancha chanan langkatanay mawhachuur san syudad, inayuscha chicha kun illukichaay kuyugwon nan ili. Sillo'cha nan hoyoy Jason tan anaanaponcha cha Pablo an Silas ta ipayangcha sasan taku. ");
INSERT INTO kyb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Gwon sa'ad tan achicha kun inchasan chay chugwa, whinuthutcha as Jason ja chanan uchumay susunud san pammati gwot impayangcha sasan mantutuyay san syudad. Kun impa'uycha gway manggwana, “Annachaja chanan takuway kumukuyu san losanay ajanchaay ili. Kun anna ummalicha hos san ili ta'uwanna. ");
INSERT INTO kyb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ad sa'ad as Jasonanna, minangilina chicha. Suplingoncha losan chanan lintog nan Emperador. Iwhakawhakacha gway agwad nan sawhali ali gway mangngachan Hesus.” ");
INSERT INTO kyb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kun nakuyu chanan naayusay taku ja chanan mantutuyay san syudad san chingngorcha nan ingwhakacha. ");
INSERT INTO kyb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nappungcha kun mangwhajachon cha Jason ja chay huhuyunna, impayagwacha chicha. ");
INSERT INTO kyb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lummawhi kun naniperjaw chanan susunud san pammati cha Pablo an Silas gway umoy ad Berea. Hummu'nagcha kun ad aschi, ummoycha san sinagogan chanan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Sa'ad chanan Hudyu ad Berea, whayugwoncha ekajay manchongor san Ukud Apudyus nu chanan Hudyu ad Tesalonica tan amod nan lajadchaay nangagwat san ukud Apudyus. Whinikatay ammancha whasaon tot ilancha nu tuttuwa chanan iwhakawhakan Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sija nan angsan an chicha nan namati an Apu Hesus, nitapi chanan angsanay wha'on kus Hudyu gway mawhigwhig gway hubhuwhai ja lallaya'i. ");
INSERT INTO kyb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gwon chingngorn ku chanan Hudyu ad Tesalonica gway impaakammun ahos Pablo nan ukud Apudyus ad Berea, ummoycha hos ad aschi kun sinugsukancha chanan taku. ");
INSERT INTO kyb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kun naniperjaw chanan susunud an Pablo tot umoy san ikid nan whaywhay gwon natchay cha Silas an Timoteo. ");
INSERT INTO kyb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Sa'ad nan uchum intuyudcha as Pablo san ikad ad Atenas. Kun impuyung Pablo an chicha gway manggwanaon, “Achi mampatho' cha Silas an Timoteo ta umalicha an sa'on.” Kun aysancha nanulin. ");
INSERT INTO kyb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","San iningkagwan Pablo ad Atenas gway manguullay an cha Silas an Timoteo, lummagwing as amod nan somsomo'na san nangilana san angsanay sinang'apudyus san sachi syudad. ");
INSERT INTO kyb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Sija nan ummoy as sija san sinagoga na'augugkud sasan Hudyu ja sasan wha'on kus Hudyu gway manchaychajaw an Apudyus. Ad whinikatay ma'augugkud as sija sasan takuway umoy san merket. ");
INSERT INTO kyb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Agwad ahos chanan uchumay mimistuyu gway ma'gwaniyon Epicureo ja Estoico gway na'augugkud an sija. Ad anan nan uchum an chicha, “Ngachamma anu pijaon nannaja manukuukud eka' otom ananay?” Anan ahos nan uchum an chicha, “Ama ekas ayasi apudyus nan iwhakawhakana” kapu tan impaakammun Pablo nan Whayuway Chamag mipangkop an Hesus ja nan matakuwan nan matoy. ");
INSERT INTO kyb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Inajakancha kus sija gwot iyoycha san maallusan chanan mangipangpangu san ili gway ma'gwaniyon Areopago, anancha, “Whayugwonmiyay akammugwon nan assahu sussuyu gway iwhakawhakam. ");
INSERT INTO kyb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tan iyalim nan achimi kun chingchingngor gway ukud. Sija nan whayugwonmiyay akammugwon nan pijaon nina anan.” ");
INSERT INTO kyb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Sa'ad chanan ijAtenas ja chachay ikaja' gway iningkaw ad aschi, maid kun sawhali as ooncha nu achi ahus nan ukuukuchoncha gwinnu manchochongorcha san assahuway sussuyu.) ");
INSERT INTO kyb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Summi'ad kus Pablo san agwachan chanan taku san Areopago, anana, “Cha'aju gway ijAtenas, maila' san losanay oonju gway ipapatijuway manchajaw sasan apudyusju. ");
INSERT INTO kyb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tan nangkagka'aja' kun san syudad gwot inamma' ilan chanan chaychajagwonju, inila' ahos nan chachattunan gway nilista nan, ‘San Apudyus gway achimi kun akammu.’ Sija nan achiju ad akammu nan chaychajagwonju, annaja ipaakammu' an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Nan Apudyus gway nanggwa san luhung ja losanay iningkaw, sija nan Apun nan langit ja luta ad wha'on kus ingkaw san templo gway inggwan nan taku. ");
INSERT INTO kyb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ad achi kuhos maserpuway pawhachang san taku as sija tan maid kun man'uyangana. Tan sija nan mangatod san whijag ja angos nan losanay taku ja losanay maserpu ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Inggwan Apudyus nan osa taku san chamuchamu kun sija nan nerpugwan nan losanay ayasin nan taku san luhung. Sija nan simpangkop gway namtong san chimpun nan ingkagwancha ja ikad nan lutaay ikawcha. ");
INSERT INTO kyb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Inggwana nannachaja tot anaponchas sija ad ochasancha lagwa as sija san manganapancha an sija tan wha'on kus achaju as Apudyus san gwaschi osa an chita'u. ");
INSERT INTO kyb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tan agwad nan nangiwhakaay manggwana, ‘Kapu an sija mawhiwhijag ta'u, mangkidkidchu ta'u ja anna ta'u.’ “Isuna hos gway anan nan uchumay nalaingay manangchangu an cha'aju, ‘Anana'na hos chita'u.’ ");
INSERT INTO kyb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ad kapu tan anana' chita'u an Apudyus, achi ta'u otjan ananon mijisu nan ina'Apudyusna san tagtagku gway na'gwa san huyagwan, wha'yaw gwinnu whatu. Nannachaja inggwan chanan taku kapu san laing ja somsomo'cha. ");
INSERT INTO kyb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Impayaus Apudyus nan chimpu gway maid kun akammun chanan taku san inggwa'inggwacha. Gwon san sana, impaakammuna sasan taku san losanay ili ta manchu'kancha chanan lagwingay o'ooncha. ");
INSERT INTO kyb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tan whintongna nan erkaw gway mangu'umana san losanay taku san luhung san inalintogna kapu san osa takuway pinilina. Impailana nan mangipano'no' sasan losanay taku kapu san nanakuwana san sachiyay taku.” ");
INSERT INTO kyb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sa'ad san nangngoyancha san nangiwhagan Pablo san matakuwan chanan natoy, inamamang nan uchum as sija gwon anan nan uchum, “Whayugwonmiyay manchongor an si'a asin san mipangkop san annaja.” ");
INSERT INTO kyb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Sachi kun tinaynan Pablo chicha. ");
INSERT INTO kyb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gwot sa'ad chanan uchumay ummamhuyuy an sija, namaticha. Mitapi an chicha as Dionisio gway osaay u'um san Areopago ja osa huwhai gway mangngachan Damaris ja chanan uchum ahos gway namati an Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Sachi kun, lummajaw as Pablo ad Atenas kun ummoy ad Corinto. ");
INSERT INTO kyb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kun inchasana ad aschi nan osa Hudyu gway mangngachan Akila gway nijana' ad Ponto. Apperpu cha Akila an Priscila gway asagwana ad Italia tan pinerjaw Emperador Claudio nan losanay Hudyu ad Roma. Kun ummoy Pablo nilagwa chicha. ");
INSERT INTO kyb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kapu tan manisisu nan terwhasuchaay mamanggwachas turcha, iningkaw an chicha na'aterwhasu. ");
INSERT INTO kyb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Umuumoy as sija san sinagoga ma'aug'ugkud sasan taku san gwaschi Erkaw gway Umillongan ta agwisona chanan Hudyu ja wha'on kus Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Hummu'nag kun cha Silas an Timoteo ad Corinto gway nerpud Macedonia, sija ekay o'oon Pablo san whinikat nan ipaakammuna ja ipano'no'na sasan Hudyu gway sa'ad as Hesus sija nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Gwon sa'ad tan suplingon chanan Hudyus sija ja pergwingonchas sija, pinu'pu'ana nan chapur san silupna kun anana, “Nu chusaon Apudyus cha'aju, cha'aju nan singwhersu! Maid kunon whijang'u. Ad malluki san sana tayna' cha'aju ad ummoja' sasan wha'on kus Hudyu.” ");
INSERT INTO kyb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Gwot tinaynana chicha kun ummoy nansuyu san hoyoy nan osaay taku gway mangngachan Ticio Justo gway wha'on kus Hudyu gway manchaychajaw an Apudyus. Cherrag nan sinagoga nan hoyoyna. ");
INSERT INTO kyb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sa'ad as Crispo gway mangipangpangu san sinagoga, namati an Apu Hesus ja chanan ahumerjanna. Angsan ahos sasan iCorinto gway nanchongor an Pablo nan namati ja nahonjakan. ");
INSERT INTO kyb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kun nampaila as Apu Hesus san isun chi ininop an Pablo san osa lawhi gway manggwana, “Achi'a umogjat. Ituyuynu gway mangiwhaka ja achim ikino'. ");
INSERT INTO kyb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tan annaa' an si'a. Maid kun manggwas lagwing an si'a tan angsan nan taku' sannaja syudad.” ");
INSERT INTO kyb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gwot iningkaw as Pablo ad Corinto as osa ja koggwaay tagwon gway nangisuyu san ukud Apudyus sasan taku. ");
INSERT INTO kyb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nangkuwhinnachur kus Galion ad Acaya, nanosossaan chanan Hudyu gway namursu an Pablo gwot chimpapchas sija ijoy san uu''uman ");
INSERT INTO kyb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","gway manggwanaon, “Nannajaay taku agwaagwisona chanan taku tot manchajawcha an Apudyus gway mihursu san lintogmi.” ");
INSERT INTO kyb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Anna kunay kuminga otjan as Pablo, anan Galion sasan Hudyu, “Nu mipangkop san lumagwingan ja humasuyan san lintogmiyay iRoma chongyo' otjan nan liliju. ");
INSERT INTO kyb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Gwon sa'ad tan iisi' ekay gway mipangkop sasan ukud ja ngadngachan ja nan lintogju, cha'aju nan mangunun. Lagwingo'ay mangu'um sinat.” ");
INSERT INTO kyb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kun pinerjawna chicha san uu''uman. ");
INSERT INTO kyb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chimpap ku chanan taku as Sostenes gway mangipangpangu san sinagoga, sinaplitanchas sija san sangun nan uu''uman gwon achin kun Galion whinijangan. ");
INSERT INTO kyb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Iningkaw as Pablo ad Corinto san angsanay erkaw. Awni kun nampayang sasan susunud ad aschi kun namapur gway ummoy ad Siria gway huyunna cha Priscila an Akila. Hummu'nagcha kun ad Sencrea, nampapu'yang as Pablo tan anna nan ingwhawhagkana an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Hummu'nagcha kun ad Efeso, tinaynan Pablo cha Priscila an Akila. San chaanna lumajagwan nilumno' jan as sija san sinagoga na'augugkud sasan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tagwichancha otjan gway ingkaw as mawhajag gwon achi kus sija. ");
INSERT INTO kyb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nampayang kunay lumajaw anana, “Asiya' managkulin ad asna nu ijujan Apudyus.” Kun namapur gway lummajaw ad Efeso. ");
INSERT INTO kyb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hummu'nag kun ad Cesarea, ummoy ad Jerusalem kun ummoyna nilagwa chanan maayuayusay namati gwot ummoy ad Antiokia. ");
INSERT INTO kyb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Iningkaw kun ad aschi san amanaay erkaw, lummajaw kun ummoy san ailiili gway sa'upon nan Galacia ja Frigia gway umoy mangipapigsa san somsomo' chanan losanay pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Hummu'nag ad Efeso nan osaay taku gway Apolos nan ngachanna gway osaay Hudyu gway nijana' ad Alejandria. Nalaing gway manukud ja angsan nan akammuna san mipangkop san ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Natudtuchugwan nan osa takuwanna san ma'gwaniyon Mangojan gway intudtuchun Apu Hesus. Nakakot as sija gway mansuyu ja tuttuwa nan isuyuna mipangkop an Hesus. Gwon ahus nan honjag Juan as akammuna. ");
INSERT INTO kyb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Natuyod gway nanukud san sinagoga. Chingngorn kun cha Priscila an Akila as sija, inajakancha kun impaagwatcha an sija nan ustuway chaanna akammugwon mipangkop san ma'gwaniyon Mangojan gway intudtuchun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Simsimmo' kun Apolos gway umoy ad Acaya, ummajun chanan namati ad Efeso. Gwot nanuyatcha sasan pasuyut ad aschi tot agwatonchas sija. Sa'ad san agwachanad aschi, cha'or nan ingwhachangna an chicha gway namati kapu san inawhayun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kapu tan nalaingay ma'asinsinnungwhat sasan Hudyu inawha'na chicha. Impano'no'na kapu san nilista Ukud Apudyus gway sa'ad as Hesus sija nan Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sa'ad san iningkagwan Apolos ad Corinto, nangoy as Pablo sasan whibilig gway ili tot umoy manosog ad Efeso. Hummu'nag kud aschi inchasana chanan uchumay pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kun anan Pablo an chicha, “Inagwatju nan Ispilitun Apudyus san namatiyanju?” Kun anancha an sija, “Achimi, maid kun chingchingngormi gway agwad nan Ispilitun Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Gwot anan Pablo an chicha, “Ad ngachamma nan ayasin nan honjag gway inagwatju?” Ananchaay summungwhat, “Nan honjag gway insuyun Juan.” ");
INSERT INTO kyb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kun anan Pablo, “Sa'ad nan nanghonjakan Juan, sija nan mangillan san manu'ukancha san lagwingay o'ooncha. Ingwhakawhakana gway maserpu tuttugwaoncha nan umali mipasu an sija gway as Hesus.” ");
INSERT INTO kyb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chingngorcha kunan sachi, nahonjakancha san ngachan Apu Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Impatay kun Pablo nan imana san wha''agcha, ummoy nan Ispilitun Apudyus an chicha. Kun kummingacha san na'aya'ayasiyay apapat ja ingwhakacha nan impaiwhakan Apudyus an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nan whilangcha ummoy as nasagwayan as chugwaay lallaya'i. ");
INSERT INTO kyb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","San tuyuway huyan ummuummoy as Pablo san sinagoga gway natuyochay ma'asinsinnungwhat ja managwis sasan taku san mipangkop san Mantuyajan Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Gwon anna chanan uchum an chichaay achi kun mammingat ja achi kun mamati gway impergwingchaot chanan sumuyut san ma'gwaniyon Mangojan san agwachan nan amochay taku. Tinaynan Pablo chicha gwot inghuyogna chanan pasuyut Hesus. Kun whinikatay na'asinsinnungwhat san mansusulluwan Tirano. ");
INSERT INTO kyb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nantuttuyuy nan amaschi san chugwa tagwon sija nan losan chanan Hudyu ja wha'on kus Hudyu gway iningkaw ad Asia, chingngorcha nan ukud Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kun nanggwananggwa as Apudyus sasan amochay mataakan kapu an Pablo ");
INSERT INTO kyb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","gway uyay chanan panju gwinnu luput gway inuserna, niijoy ku sasan nasa'it, hummayucha ja lummajaw ahos chanan chimunju an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pinachas hos chanan uchumay Hudyu mangka'aka'ay gway mamerjaw sasan chimunju gway usayoncha nan ngachan Apu Hesus. Anancha sasan takuway nilno' chanan chimunju, “San ngachan Hesus gway impaakammun Pablo, lumajaw aju!” ");
INSERT INTO kyb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iningkaw chanan pitu lallaya'iyay ana' Seva gway osa pangat nan pachin chanan Hudyu gway o'ooncha nan amaschi. ");
INSERT INTO kyb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gwon summungwhat nan chimunju an chicha gway manggwana, “Akammu' as Hesus ja akammu' ahos as Pablo. Gwon ngachan ajuma hos?” ");
INSERT INTO kyb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tummaud kun chay takuway nilno' nan chimunju, inajamna chicha kun illogna chicha losan. Sija nan nampoponnascha ja najamajamancha gway ummagwid gway lummagwas hoyoy. ");
INSERT INTO kyb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gwot naakammugwan chanan losanay Hudyu ja wha'on kus Hudyu gway iingkaw ad Efeso nan annaja na'gwa kun losancha ummogjat. Kun chinaychajawcha as Apu Hesus kapu san ayobhongana. ");
INSERT INTO kyb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Angsan ahos sasan namati nan ummoy nangipudnu san lagwingay inggwa'inggwacha. ");
INSERT INTO kyb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ad sa'ad chanan uchumay namati an Apu Hesus gway sikuchay mansayusayumang'a, inasinutcha chanan nibyuway uussayonchaay mansayumang'a kun singkobcha san sangun chanan taku. Whinilangcha kunan katadna, ummoy as limampuyu lihuway wha'yaw gway pila'. ");
INSERT INTO kyb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Amaschi kunan na'gwa, amamochay nigwerna' nan ukud Apudyus mipangkop an Hesu Kristu kun umachaachu chanan namati. ");
INSERT INTO kyb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nappung kun chanan na'gwa, simsimmo' Pablo gway mangoy ad Macedonia ja Acaya ad asiyot umoy ad Jerusalem. Anana, “Sa'ad nu merpuwa' ad Jerusalem, maserpu iya' hos lagwaon ad Roma.” ");
INSERT INTO kyb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ingwhaunna kun chanan chugwa atuyungana gway cha Timoteo an Erasto ad Macedonia, nanto'chay as sina'itan as sija ad Asia. ");
INSERT INTO kyb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sa'ad san sachiyay chimpu, na'gwa nan amochay kuyu ad Efeso mipangkop san ma'gwaniyon Mangojan. ");
INSERT INTO kyb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iningkaw nan osa takuway mangngachan Demetrio gway manghohoser san wha'yaw gway manggwamanggwa as whana'iyutay whina'yaw gway temtemplon Artemis. Angsan nan labhun chanan mallabhu an sija. ");
INSERT INTO kyb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Inayus kun Demetrio nan losanay mallabhuwona ja chanan uchumay isunaay manghohoser, anana an chicha, “Akammujuway sa'ad nan terwhasu ta'uwanna sija nan humma'nangan ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kun inilaju ja chingngorju gway sa'ad nan sachiyay Pablo, angsan nan takuway inagwisna wha'on kus ahus ad asna Efeso gwon takangayna pay ichungpus nan losanay ailiili san Asia. Ingwhakawhakanaay sa'ad nannaja o'oon ta'u wha'on kus tuttuwaay apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Aamama' as mipergwing nannaja terwhasu ta'u wha'on kus ahus nannaja gwon uyay ahos nan templon Artemis maigjan ja sa'ad as Artemis mismu gway apudyus ta'uway machaychajaw gway chaychagwon nan losanay ili san Asia ja san intiluway luhung, achicha kun chajagwon.” ");
INSERT INTO kyb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chingngorcha kunan sachi, nalingucha' amod kun nampa'uycha gway manggwana, “Machaychajaw as Artemis gway apudyus chanan ijEfeso!” ");
INSERT INTO kyb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gwot nakuyu losan nan taku san syudad gway asipapa'uy. Kun nakabhuurchaay ummoy nanpap ancha Gayo an Aristarco gway iMacedonia gway huyun Pablo san mangka'aka'ajana. Kun iyoycha chicha san aallusan nan taku. ");
INSERT INTO kyb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Whayugwon otjan Pablo gway umoy san sangun chanan takuway naayus gwon achin ku chanan pasuyut Hesus iyuja as sija. ");
INSERT INTO kyb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ad sa'ad ahos nan uchumay papangat san ailiili san Asia gway hubuyunna, nangwhauncha as ummoy nampa'pa''aasi an Pablo tot achi umoy mampaila san aallusan chanan taku. ");
INSERT INTO kyb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nakuyu nan amung chanan taku. Nan'inayasi nan ipa'uycha ad nan aachugwan an chicha maid kun akammucha nu kachaman naayus sichi. ");
INSERT INTO kyb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kun intu'jud chanan Hudyu as Alejandro gway nerpu san naamung gway impasangucha sasan taku. Gwot impajapay Alejandro nan imana gway pakin'ona chicha ta kuminga otjan sasan taku. ");
INSERT INTO kyb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gwon inakammucha kunay Hudyu as sija, nanossosaanchaay nampa'uy as ummoy as chugwa uyas gway manggwana, “Machaychajaw as Artemis gway apudyus chanan ijEfeso!” ");
INSERT INTO kyb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Awawni kun pinakino' nan osa nawhilinan san ili chicha gway manggwana, “Ailija' gway ijEfeso, akammuju losan gway sa'ad nan syudad ta'u sija nan mangijaachug san templon Artemis gway machaychajaw ja san whatuway naotchag gway nerpud langit gway mijalig an sija. ");
INSERT INTO kyb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Maid kun mangisulib sannaja, sija nan maserpuway kumino' aju ad achi aju manga''agway. ");
INSERT INTO kyb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iyaliju nannachajaay chugwa laya'i ad asna ta'on nu maid ina'awchas templo ja maid ingwhakacha as lagwing san apudyus ta'u. ");
INSERT INTO kyb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ad sa'ad nu agwad ichayum cha Demetrio ja chanan huhuyunna manghohoser sasan whayangnaay taku, agwad chanan uu''uman. Ad agwad chanan mantutuyay gway manguu'um ad sachi nan mangisa'yangancha. ");
INSERT INTO kyb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ad nu agwad pay uchum as pangkopju, maserpuway maukud san maayusan chanan umili. ");
INSERT INTO kyb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tan mawhalinay michayum ta'u losan sasan mantutuyay as nangkuyu san sana erkaw. Tan maid kun kapun nannaja kuyu as mawhalin as ustuway lasun as isungwhat ta'u.” ");
INSERT INTO kyb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nappungna kun iwhaka nan sachi, whinu'erna chanan naayusay taku. ");
INSERT INTO kyb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kummino' kunan kuyu, impaajag Pablo chanan pasuyut Hesus. Impapigsana nan somsomo'cha gwot nampayang an chicha gway umoy ad Macedonia. ");
INSERT INTO kyb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kinagka'ayna kun chanan ailiili ad aschi gwot angsan nan ingwhakawhakanaay nangipapigsa san somsomo' chanan namati, ummoy ad Grecia. ");
INSERT INTO kyb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Iningkaw as sija ad aschi san tuyuway huyan. Na'asakana otjan as sijaay mamapur umoy ad Siria gwon inakammuna kunan lagwingay pangkop chanan Hudyu an sija, simsimmo'naay managkulin gway mangoy ad Macedonia. ");
INSERT INTO kyb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kun nihuyog an sija as Sopatro gway ana' Pirro gway iBerea. Nihuyog ahos chanan iTesalonica gway cha Aristarco an Segundo, as Gayo gway iDerbe ja as Timoteo ja chanan ijAsia gway cha Tikiko an Trofino. ");
INSERT INTO kyb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ummunacha kun inuyaycha cha'ami ad Troas. ");
INSERT INTO kyb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nappung kunan Pijastan nan Tinapay Gway Maid Kun Yeastna, namapur amiyay nerpud Filipos kun inchasanmi chicha ad Troas san mi'alima erkaw. Kun iningkaw amid aschi as pitu erkaw. ");
INSERT INTO kyb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","San lawhin nan Sawhachu san naayusanmiyay mami'pi''i san tinapay as manomsom'anmi an Apu Hesus, whinajag Pablo gway nanukud sasan taku ingkana san kagwan nan lawhi tan lumajaw san mawhikat. ");
INSERT INTO kyb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Angsan nan silaw san mi'aggwa katun nan hoyoy gway naayusanmi. ");
INSERT INTO kyb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Iningkaw nan osa whawhayuway mangngachan Eutico gway tummutu'chu san tagwa. Manchu'jochu'jop as sija san nawhajakay manukuukuchan Pablo. Nailo' kun naotchag ad choya gway nerpu san umatluway katun nan hoyoy. Gwot intangoychas sija gway natoy. ");
INSERT INTO kyb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nanosog kus Pablo, whina'gwerna as sija gway manggwana, “Achi aju machanakan tan achi kun natoy!” ");
INSERT INTO kyb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Summangat kus Pablo pini'pi''icha nan tinapay asichaot nampa'pa''ayus. Na'aapaapat as sija an chicha ingkana san chumungit nan init kun asiyot lumajaw. ");
INSERT INTO kyb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kun iyoycha chay natakuway whawhayu san hoyoycha gwot amod nan lagsa'cha. ");
INSERT INTO kyb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ummuna ami ku lummiggwat namapur, ummoy ami ad Asson tan merpud aschi as Pablo gway chakasonmi. Amaschi nan ingwhakana tan whayugwonaay manadchayan gway umoy ad Asson. ");
INSERT INTO kyb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Inahot cha'ami kud Asson, na'apapur an cha'ami gwot ummoy ami ad Mitilene. ");
INSERT INTO kyb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Intuyuymiyay namapur gwot mawhikat kun niwhatug ami san chomang nan Chio. Asin ku mawhikat niwhatug ami ad Samos. Asin kuhos mawhikat chummakus ami ad Mileto. ");
INSERT INTO kyb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pinangkop Pablo gway achi mangoy ad Efeso tot achi mata'ta' ad Asia tan kanasona tot chumakus ad Jerusalem tot ochasana otjan nan Pijasta gway ma'gwaniyon Pentecostes. ");
INSERT INTO kyb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sa'ad san agwachan Pablo ad Mileto, impaajagna chanan mangipangpangu sasan maayuayusay namati ad Efeso. ");
INSERT INTO kyb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ummoycha kun an sija, anana an chicha, “Akammuju nan whijag'u san iniingkagwa' an cha'aju san ikad nan chamuway ummaliya' ad Asia. ");
INSERT INTO kyb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nansilwhiya' an Apudyus gway impawhawha' nan somsomo''u san losanay taku. Pinachas'u gway choo maniwhil ja nalliglikata' kapu sasan lagwingay pangkop nan Hudyu san whijag'u. ");
INSERT INTO kyb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Akammuju gway achi' kun inimutanay nangipaakammu an cha'aju san humayugwanju ja nangisuyu an cha'aju san sangun chanan taku ja sasan hohoyoyyu. ");
INSERT INTO kyb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ingwhakawhaka' sasan Hudyu ja wha'on kus Hudyu gway maserpuway manchu'kancha chanan whersucha ad nanagkulincha an Apudyus ja mamaticha an Apu ta'uway Hesu Kristu. ");
INSERT INTO kyb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ad san sana kapu tan whinilin nan Ispilitun Apudyus as sa'on, iya' ad Jerusalem ta'on nu achi' akammu nan ma'gwa an sa'on ad aschi. ");
INSERT INTO kyb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ahus as akammu' nan impaakammun nan Ispilitun Apudyus an sa'on gway sa'ad san losanay syudad gway umaja', miwhayucha' ja mapalikatana'. ");
INSERT INTO kyb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Gwon achi' kun iwhilang nan whijag'u as napatog an sa'on tot mawhalinay pungpungo' nan ipa'gwan Apu Hesus an sa'on gway mangipano'no' san Whayuway Chamag mipangkop san inawhayun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ad san sana, chongyonju! Sa'ad as cha'aju losanay ummoy'u nangipaakammugwan san mipangkop san Mantuyajan Apudyus, akammu'ay maid kun mangillanju asin an sa'on. ");
INSERT INTO kyb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Sija nan san sana erkaw iwhawhagka' gway sa'ad nu agwad sumiyan an cha'aju, machusa ad wha'on kus whersu'. ");
INSERT INTO kyb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tan achi' kun iyimut gway nangipaakammu an cha'aju san losanay pangkop Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ad ammanju ilan nan whijagju ja chanan losanay maayuayusay namati gway impaijachug nan Ispilitun Apudyus an cha'ajuway mangipangpangu. Aygwananju chanan maayuayusay namati an Apudyus gway sina'ana kapu san chayan nan Ana'na. ");
INSERT INTO kyb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Akammu'ay sa'ad nu tayna' cha'aju, umali an cha'aju chanan wha'wha''onay mangisuyu ad tangkaancha chanan takun Apudyus gway ijaachugju. ");
INSERT INTO kyb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ad agwad nan merpu an cha'aju gway lumosgwa lallaya'iyay iwhakawhakacha nan tuli tot agwisoncha gway sumuyut an chicha chanan pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sija nan ammanju ilan. Sosom'onju nan tuyu tagwonay nilawhi ja inerkaw gway amod nan likat'u kapu tan ipatpatog'u cha'aju gway achi' kun ijakay gway nanudtuchu an cha'aju. ");
INSERT INTO kyb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ad san sana, itayo''u cha'aju an Apudyus. Mantayo'a' san ukudna gway nangipaakammu san mipangkop san inawhayuna gway sachi nan mangipapigsa san pammatiju. Nan sachi ukud sija nan mangipawhayu san whijag chanan losanay takun Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Maid kun pangkop'us mangkamkam san wha'yaw, huyagwan ja silup nan osa taku. ");
INSERT INTO kyb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sa'ad as cha'aju, sikuchay aagkammuju gway sa'ad nan nallingota' sija nan nanerrun an sa'on ja chanan huhuyun'u. ");
INSERT INTO kyb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","San losanay inggwa'inggwa' impaila' an cha'aju gway maserpu mangkakot ta'u tot agwad iwhachang ta'u sasan manserpus whachang. Ad sosom'on ta'u nan ukud Apu Hesus gway anana, ‘Piyan as amod nan mangatod nu nan umagwat.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nappung kun Pablo iwhaka chachi, nampalintumongcha losanay nallugwayu. ");
INSERT INTO kyb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Losancha naniwhil kun ni'agworcha an sija gwot inchoomcha nan apingcha san apingna. ");
INSERT INTO kyb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lummagwing nan somsomo'cha tan ingwhakanaay achicha kun maila asin as sija. Kun intuyudchas sija san papur. ");
INSERT INTO kyb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nampayang ami kun sasan mangipangpangu sasan namati ad Efeso, namapur ami gwot hummu'nag ami ad Coos. Mawhikat kun chummakus amid Rodas gwot ummoy ami hos ad Patara. ");
INSERT INTO kyb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Inchasanmi kunan papur gway umoy ad Fenicia, namapur ami. ");
INSERT INTO kyb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Niwhatug ami kun san mailad Cyprus, nangoy nan papurmi san machigwiki gway umoy ad Siria. Kun hummu'nag amid Tiro tan aschi nan mangichissaakan nan papur san ochonna. ");
INSERT INTO kyb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kun inanapmi chanan pasuyut Hesus ad aschi gwot iningkaw ami an chicha as pitu erkaw. Kapu san impaakammun nan Ispilitun Apudyus an chicha, ingwhakacha an Pablo gway achi umoy ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Naya'pus kunan erkaw gway iniingkagwanmid aschi, intuyuymiyay nangwhaat. Intuyud cha'ami an chicha losan gway nitapi hos chanan asagwacha ja anana'cha ingkana san lasin nan syudad. Nampalintumong ami kun san ikid nan whaywhay, nallugwayu ami. ");
INSERT INTO kyb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nampipinna'acha ami kun, namapur ami gwot nanagkulincha san hohoyoycha. ");
INSERT INTO kyb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Intuyuymi ku gway namapur nerpud Tiro, hummu'nag ami ad Tolemaida. Kun nanisikinga ami sasan susunud san pammati ad aschi kun iningkaw ami an chicha as osa erkaw. ");
INSERT INTO kyb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mawhikat kun lummajaw amid Tolemaida kun hummu'nag ami ad Cesarea. Kun nanchagwos ami ad aschi san hoyoy Felipe gway mangiwhawhagka san Whayuway Chamag gway osa sasan pitu lallaya'i gway napili ad Jerusalem san nugwan. ");
INSERT INTO kyb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Agwad nan opatay anana'na whabwhawhallas gway mangiwhakawhaka san impaiwhakan Apudyus an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sa'ad san iniingkagwanmid aschi san amanaay erkaw, hummu'nag nan osa profetaay mangngachan Agabo gway nerpud Judea. ");
INSERT INTO kyb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ummali ku an cha'ami, inayana nan sintuyun Pablo. Kun inta'odna san imana ja i'ina asinaot ananon, “Annaja nan anan nan Ispilitun Apudyus: ‘Amasna nan mamungugwan chanan Hudyu ad Jerusalem san sin'ugwa sanna sintuyun ad impayangchas sija sasan wha'on kus Hudyu.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chingngormi kun chi sa'ad as cha'ami ja chanan uchum gway agwad ad aschi, nampa'pa''aasi ami an Pablo ta achi umoy ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Gwon anana gway summungwhat, “Ka'aju maniwhil ja kaju pergwingon nan somsomo''u? Na'asakanaa' gway mapungu ja uyay matoja' ad Jerusalem kapu san mansilwhiya' an Apu Hesus.” ");
INSERT INTO kyb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Achimi kun maayayu' as sija, ingkino'mi ekay kun ananmi, “Sija otjan ma'gwa nan whayugwon Apudyus.” ");
INSERT INTO kyb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Neerkagwanan kun nansakana amiyot ummoy ami ad Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kun nihuyog an cha'ami chanan uchumay pasuyut Hesus gway iCesarea. Intuyud cha'ami san nanchawsanmiyay hoyoy Manason gway iCyprus gway osa sasan ummunaay pasuyut Hesus. ");
INSERT INTO kyb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hummu'nag ami kud Jerusalem, nayagsa' chanan susunud gway nangipakatong an cha'ami. ");
INSERT INTO kyb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mawhikat kun nihuyog ami an Pablo gway umoy lumagwa an Santiago. Ad gwachagwad chanan mangipangpangu sasan namati ad aschi. ");
INSERT INTO kyb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nappung kun Pablo kingaan chicha, impongponganna uulliton nan inggwa'inggwan Apudyus sasan wha'on kus Hudyu kapu san nansilwhiyana. ");
INSERT INTO kyb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Chingngorn ku chanan taku nan ingwhakana, chinaychajawcha as Apudyus. Kun anancha an sija, “Sunud, akammum gway nilihu chanan Hudyuway namati an Apu Hesus. Akammum ahosay ipapatichaay manuyut san lintog Moses. ");
INSERT INTO kyb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kun nipachamag an chicha nan mipangkop an si'a gway insuyum anu sasan losanay Hudyuway iningkaw san ilin chanan wha'on kus Hudyu gway manchu'kancha nan lintog Moses. Ingwhakawhakam anu hos gway achicha pasuglit nan anana'cha ja achicha hos suyuton nan ukalin chanan Hudyu. ");
INSERT INTO kyb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ad ngachamma oon ta'u? Maid kun chugwachugwanaay chongyoncha gway hummu'nag'a. ");
INSERT INTO kyb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Sija nan oom nan pa'gwami an si'a. Anna chanan opatay lallaya'i sanna nangngilin kapu san ingwhawhagkacha an Apudyus. ");
INSERT INTO kyb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ihuyognu chicha san Templo ad inggwaju nan ukaliyay pumor'asan ad si'a nan nangamung san whajad tot papu'yangcha. Ad nangakammugwan nan losan gway maid kun atuttugwaan san chingngorchaay chamag mipangkop an si'a ad anna'a hosay manusuyut san lintog Moses. ");
INSERT INTO kyb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nu mipangkop sasan wha'on kus Hudyu gway namati, insuyatmi an chicha nan nanuukuchanmiyay maserpu achicha mansicha san ischaay nichatun sasan sinang'apudyus. Achicha mansicha san chaya ja ajamay achi kun nipachaya. Insuyatmi hosay achicha manggwas whayangna awhawhain ja ina'aisaw gway pijaon nan longag.” ");
INSERT INTO kyb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Sija nan inghuyog Pablo chachay opatay laya'i. Mawhikat kun inggwacha nan ukaliyay pumor'asan. Kun ummoy as sija san sowhan nan Templo tot ipaakammuna nu ma'anu nan erkaw gway mapungpungan nan pumor'asancha ja nu ma'anu hos nan mangatchancha san chatun nan gwaschi osa an chicha. ");
INSERT INTO kyb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Takangay kun mappung nan pitu erkaw gway mampapor'asancha sa'ad chanan Hudyuway ijAsia gway nangila an Pablo san sowhan nan Templo, sinugsukancha chanan taku gwot chimpapcha as Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Inip'awcha gway manggwana, “Ailijanay ijIsrael! Humachang aju! Annaja nan taku gway mansuyusuyu san losanay taku san ailiili san mihursu an chita'uway ijIsrael ja san lintog Moses ja san Templo. Inghuyogna hos chanan wha'on kus Hudyu san sowhan nan Templo kun chinimo'na nan Temploway nat'on as ugwan Apudyus!” ");
INSERT INTO kyb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ingwhakacha nannaja tan inilacha san nerrusay chimpu as Trofimo gway ijEfeso gway huyun Pablo ad aschiyay syudad tan anancha kunnu inghuyog Pablo as sija san sowhan nan Templo. ");
INSERT INTO kyb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Gwot nakuyu chanan losanay umili kun nakabhuur chanan takuway ummoy nanpap an Pablo gwot whinuthutchas sija impayagwa san lasin nan Templo kun na'a'tuub nan onob. ");
INSERT INTO kyb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Anna kunay otojon otjan chanan taku as Pablo, chummakus nan chamag san pangat chanan surchachu gway iRoma gway nakuyu nan losanay takud Jerusalem. ");
INSERT INTO kyb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kun nanijajagna sasan apitan ja chanan surchachucha. Kun kinanaschaay umoy san agwachan chanan taku gwot inilan ku chanan taku chicha, iyakaychaay nan mangabchaabchoy an Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kun ummoy nan pangat chanan surchachu an Pablo gwot chimpapna kun impapungunas sija san chugwa ayuwhing'i. Gwot nanimus gway manggwanaon, “Ngachan nannaja taku ja ngachan nan inggwana?” ");
INSERT INTO kyb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nan'inayasi nan ip'aip'aw chanan taku ad achina kun maagwatan nu ngachan nan tuttuwaay na'gwa tan amod nan umiinger. Sija nan impaijoyna as Pablo san ampun chanan surchachu. ");
INSERT INTO kyb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chummakuscha kun san erchan intangoy chanan surchachu as Pablo tan amod nan huchu' chanan taku. ");
INSERT INTO kyb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tan nituntunud chanan amochay taku gway asipapa'uy gway manggwana, “Otojonjus sija!” ");
INSERT INTO kyb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Takangay ku chanan surchachu ijoy as Pablo san ampu, nanapapat san Grinego say pangat gway manggwana, “Anna nan iwhaka' an si'a.” Kun anan chay pangat, “Ka akammumay manapapat san Grinego.” ");
INSERT INTO kyb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Ana' kunnu si'a chay ijEgipto gway nangiluki san kuyu san sinerkagwan ja nangipangu sasan opat lihuway taku gway manootoy gway ummoy san luta gway maid kun ingkaw as taku.” ");
INSERT INTO kyb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Kun anan Pablo gway summungwhat, “Wha'on! Hudyuwa' gway nijana' ad Tarso ad Silicia gway mawhigwhikay syudad. Ijujamud ta kumingaa' sannachaja taku.” ");
INSERT INTO kyb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iyujan kun chay pangat, summi'ad as Pablo san erchan asinaot itajag nan imana gway nangipakino' sasan taku. Nakinokino'cha kun losan, anana an chicha san Hinebreo gway apapat, ");
INSERT INTO kyb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Susunud ja aamma, chongyonju nannaja sungwhat'u san ipawhersuju an sa'on.” ");
INSERT INTO kyb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Chingngorcha kunay nanukud an chicha san Hinebreo gway apapatcha, nakinokino'cha' amod. Kun anan Pablo, ");
INSERT INTO kyb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Hudyuwa' gway nijana' ad Tarso ad Silicia gwon chumma'orra' ad asna Jerusalem gway usgwilan Gamaliel. Inammana insuyu an sa'on nan lintog chanan nerpugwan ta'u. Impapati' gway nansilwhi an Apudyus gway isuju hosay anna san sana. ");
INSERT INTO kyb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinalpalikata' chicha ingkanas natoy chanan uchum gway summuyut san ma'gwaniyon Mangojan gway intudtuchun Apu Hesus. Impadpap'u ja impawhayud'u chanan lallaya'i ja hubhuwhai. ");
INSERT INTO kyb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pano'no'an hos nan angatuwanay pachi ja chanan losanay chacha''orn nan Sanhedrin gway tuttuwa nan iwhakawhaka'. Chicha ahos nan nerpugwan nan suyat gway inaya' ta ijoy'u sasan susunud gway Hudyu ad Damasco. Sija nan ummoja' ad aschi tot chopapo' chanan summuyut san ma'gwaniyon Mangojan gway intudtuchun Apu Hesus ad iyali' chichad asna Jerusalem tot machusacha.” ");
INSERT INTO kyb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nangwhaata' kunot takangaja' chumakus ad Damasco san takangay as mamatu', maag ekay iningkaw nan amod nan padchana gway naniling an sa'on gway nerpud langit. ");
INSERT INTO kyb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kun natugwacha' san luta gwot chingngor' nan kinga gway manggwana an sa'on, ‘Saulo, Saulo, kamman palpalikatan as sa'on?’ ");
INSERT INTO kyb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Kun summungwhata' gway manggwana, ‘Ngachan'a apu?’ “Kun anana an sa'on, ‘Sa'on as Hesus gway iNazaret gway palpalikatam.’ ");
INSERT INTO kyb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ad sa'ad chanan nihuyog an sa'on, inilacha nan padcha gwon achicha kun chingngor nan ma'aapaapat an sa'on. ");
INSERT INTO kyb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Kun inimus'u gway manggwana, ‘Ngachan nan oo', Apu?’ “Kun anan Apu Hesus an sa'on, ‘Sumi'ad'a ad ummoy'a ad Damasco. Ad ingwhakacha an si'a ad aschi nan losanay ipa'gwa' an si'a.’ ");
INSERT INTO kyb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ad kapu tan na'uyapa' san sumilingay padcha, inigwicha' sasan huyog'u gway ummoy ad Damasco. ");
INSERT INTO kyb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Iningkaw nan osa laya'iyay mangngachan Ananias gway osaay mangikakadto'ay manuyut san lintog ta'u ja whigwhikon nan losanay Hudyuway iningkaw ad Damasco. ");
INSERT INTO kyb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ummali kus sija an sa'on gwot summi'ad san cherrag'u, anana, ‘Sunud gway Saulo, mansubli nan ilam!’ Ad san sachi hos ekajay uyas nansubli nan ila' kun inila' as sija. ");
INSERT INTO kyb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Kun anana, ‘Sa'ad nan Apudyus nan nerpugwan ta'u pinili cha'a tot maakamugwam nan whayugwona tot mailam nan Ustu nan O'oona gway Mansilsilwhiyona ancha chongyom nan kingana. ");
INSERT INTO kyb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Si'a nan mangipano'no' an sija san losanay taku san mipangkop san inilam ja chingngorm. ");
INSERT INTO kyb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ad san sana, ngachanma uullajom? Sumi'ad'a ad nampahonjag'a ad nallugwayu'a an Apu Hesus tot ligwatan Apudyus chanan whersum.’ ");
INSERT INTO kyb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nanagkulina' kud asna Jerusalem gwot nallugwayugwayuwa' san sowhan nan Templo, iningkaw nan impailan Apudyus an sa'on san isun chi ininop. ");
INSERT INTO kyb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Kun inila' as Apu Hesus gway manggwana an sa'on, ‘Kanasom, taynam ad asna Jerusalem tan achin ku chanan takud asna tuttugwaon nan iwhakawhakam gway mipangkop an sa'on.’ ");
INSERT INTO kyb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Kun ana' gway summungwhat, ‘Apu, akammucha gway gwaschi sinagoga ummoy'u nilno' gwot chimpap'u ja inabchaabchoy'u chanan namati an si'a. ");
INSERT INTO kyb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ad sa'ad san nangtojan chanan taku an Esteban gway nangipano'no' san mipangkop an si'a, iningkagwa' ahos san sachi gway summisi'ad gway nanachun ja nangijaachug san silup chanan nangtoy an sija.’ ");
INSERT INTO kyb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Gwon anana an sa'on, ‘I'a, tan iwhaun'u si'a san achajuway ili sasan wha'on kus Hudyu.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nanchochongngor chanan taku an Pablo ingkana san nangiwhagana san sachi gwot ummorjacha gway manggwana, “Otojonju nat! Wha'on kus lobhongna mataku nat!” ");
INSERT INTO kyb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Asipapa'uycha kunay nan mangigwasgwasigwas san lagkoyloy gway silupcha ja mangikabkabur san chapur, ");
INSERT INTO kyb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ingwhilin nan pangat chanan surchachu gway miijoy as Pablo san ampu ta ipasaplitna tot akammugwona nu ngachan nan kapun nan mama''upa''uwancha an sija. ");
INSERT INTO kyb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Gwon anna kunay pungugwonchas Pablo san layat, anana san apitan chanan surchachu gway summisi'ad, “Jo'o ijujan nan lintog gway saplitam nan takuway Romano gway chaan masumerja?” ");
INSERT INTO kyb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Chingngorn kun chay apitan chanan surchachu, ummoy san pangatcha kun ananaon, “Ngachan nan oom? Tan sa'ad nannaja taku Romano!” ");
INSERT INTO kyb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sija nan ummoy an Pablo chay pangat kun inimusna an sija gway manggwana, “Iwhakamud an sa'on nu Romano'a?” Kun anan Pablo, “Oon”. ");
INSERT INTO kyb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kun anan chay pangat, “Amod nan kinastu' gway pila' gwot asiya'ot miwhilang as Romano.” “Gwon nijana'a' gway Romano,” anan Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Gwot sa'ad chachay manumerja otjan an sija, nernajawcha. Isun ahos chay pangat gway ummogjat san inakammunaay Romano as Pablo gway impapunguna. ");
INSERT INTO kyb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mawhikat kun, kapu tan whayugwon chay pangat akammugwon nan kadto'ay kapu nu kaman pawhasuyon chanan Hudyu as Pablo, impau'whadna nan ayuwhing'i gway impungucha an sija. Kun impaajagna chanan papangat nan papachi ja chanan Sanhedrin gwot impasi'adna as Pablo san sangucha. ");
INSERT INTO kyb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Intotollong kun Pablo chanan Sanhedrin, anana, “Susunud! Nachayus nan somsomo''uway nawhijag san mangilan Apudyus ingkana san sana erkaw.” ");
INSERT INTO kyb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Chingngorn kun Ananias gway angatuwanay pachi na sachi, ingwhakana sasan summisi'ad san cherrag Pablo tot lipa'oncha nan tupo'na. ");
INSERT INTO kyb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kun anan Pablo an sija, “As Apudyus nan manusa an si'a, an'annam gway mampawhayu! Tumu'chu'a san sanatay mangu'um an sa'on san anan nan lintog gwon annatay nilabsingnu nan lintog san nangipalipa'am an sa'on!” ");
INSERT INTO kyb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sa'ad chanan summisi'achay achani an Pablo anancha, “Kamma pawhainan nan angatuwanay pachin Apudyus?” ");
INSERT INTO kyb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Anan Pablo, “Susunud, achi' kun akammuway sija nan angatuwanay pachi tan nilista san Ukud Apudyus gway ananaon, ‘Achi'a manukud as lagwing san mangituyay sasan takum.’ ” ");
INSERT INTO kyb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nadlaw kun Pablo gway Saduceo nan uchum ja Pariseo nan uchum, tinowhagna nan kingana san Sanhedrin gway manggwana, “Susunud, Pariseowa' ja Pariseo hos nan sinana' an sa'on. Kapu san namnamao' gway mataku chanan natoy, anna masumerjaa'.” ");
INSERT INTO kyb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ingwhakana kunan sachi, nalluki chanan Pariseo ja Saduceo gway naniisi' kun nakoggwa chanan naayus. ");
INSERT INTO kyb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sa'ad chanan Saduceo ananchaon achi kun mataku nan natoy, maid kun anghel ja chanan isucha gway achi kun maila. Gwon sa'ad chanan Pariseo tuttugwaoncha losan chana. ");
INSERT INTO kyb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kun ngummonotchaay naniisi'ot summi'ad chanan uchumay mimistuyun nan lintog gway mitapi sasan Pariseo kun tina'choyancha gway manggwana, “Maid kun inchasanmis inergwing nannaja taku! Tugwakay tuwa agwad achi maila gwinnu anghel as na'aapapat an sija!” ");
INSERT INTO kyb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ummatung kunan iisi'cha ummogjat chay pangat chanan surchachu tan tugwakay manininnatanchas Pablo. Sija nan ingwhakana sasan surchachuna tot umoycha ugchon as Pablo ta ijachajucha an chicha ad iyoycha san ampucha. ");
INSERT INTO kyb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lummawhi kun summi'ad as Apu Hesus san cherrag Pablo kun anana, “Achi'a umogjat! Isun nan nangipano'no'am an sa'on ad Jerusalem, maserpuway ipano'no'nu hos as sa'on ad Roma.” ");
INSERT INTO kyb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mawhikat kun nantutuyag chanan uchumay Hudyu nu ininonchaay mangipaotoy an Pablo. Nansasapatacha gway achicha mangan ja uminum ingkanas ipaotoychas Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nasuyu'chas opat puyuway nantutuyag. ");
INSERT INTO kyb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kun ummoycha san papangat nan pachi ja chacha''orn chanan Hudyu kun anancha, “Nansapata ami gway achi ami kun mangan ingkanas ipaotoymi as Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Sija nan sa'ad as cha'aju ja chanan Sanhedrin, iwhakaju san pangat chanan surchachu tot paijaliju as sija, ad ananjuwon whayugwonju gway usikon as ustu as sija mipangkop san michayumana. Ad nachacha''an amiyay mangtoy an sija san chaanna umachayukan.” ");
INSERT INTO kyb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Gwon chingngorn kunan amuna'on Pablo gway ana' nan sunudna huwhai nan pangkopcha, ummoy san ampu gwot ingwhakana an Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kun inajakan Pablo nan osaay apitan nan surchachu gwot anana, “Ijoynu nannaja whawhayu san pangat tan agwad nan ipachamagna an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kun whinuyogna iyoy san pangat kun anana, “Sa'ad as Pablo gway whayud inajakana' ta ijali' nannaja whawhayu tan agwad anu nan iwhakana an si'a.” ");
INSERT INTO kyb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kun inigwid chay pangat chay whawhayu gwot inta'iyannaot inimusna gway manggwana, “Ngachan nan iwhakam an sa'on?” ");
INSERT INTO kyb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kun anan chay whawhayu, “Nantutuyag chanan uchumay Hudyu gway ochagwoncha an si'as whikat tot ijoynu as Pablo san Sanhedrin tan whayugwoncha anu gway usikon gway ustu nan atuttugwaan mipangkop an sija. ");
INSERT INTO kyb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gwon achim tuttugwaon chicha kapu tan agwad nan nasuyu' as opat puyu lallaya'iyay nantayu ad uullajonchas sija. Nansasapatachaay achicha mangan ja uminum ingkanas otojoncha as sija. Ad san sana nachacha''anchaay manguullay san mangijujaam.” ");
INSERT INTO kyb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kun anan chay pangat, “Achim iwhagwhaka san sinusnatay taku gway ingwhakam an sa'on nannaja.” Kun pinerjawna chay whawhayu. ");
INSERT INTO kyb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Awni kun inajakan chay pangat nan chugwaay apitan chanan surchachu kun anana, “Isakanaju chanan chugwangkasutay surchachu ja itapiju chanan pitumpuyu taku manga'abwhaju ja chugwang kasutay natubtuwhajan tot umoycha ad Cesarea san sana lawhi. ");
INSERT INTO kyb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Isakanaju hos chanan awhaju as mallukanan Pablo ad iyoyyuway maid ma'ma'gwa an sija an Kuwhinnachur gway Felix.” ");
INSERT INTO kyb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kun nanuyat hos chay pangat as amasna: ");
INSERT INTO kyb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Sa'on as Claudio Lysias gway nanuyat an si'a nachajaw gway Kuwhinnachur Felix. ");
INSERT INTO kyb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Nannaja taku tiniliw chanan Hudyu ja otojoncha otjan. Inakammu' kunay Romano as sija, inghuyog'u chanan surchachu kun insaya'mis sija. ");
INSERT INTO kyb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Whayugwo'ay maakammugwan nu ngachan nan nangisa'yangancha an sija, sija nan iyoy'us sija san Sanhedrin. ");
INSERT INTO kyb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kun naakammugwa'ay mipangkop ekay san lintogcha nan nangisa'yangancha gwon maid kun inggwanas lagwing as lobhongnas matojan gwinnu miwhayuchan. ");
INSERT INTO kyb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Naakammugwa' kunay pangkopchaay otojon as sija, nanipaijali' an si'a. Ingwhaka' ahos sasan nangisa'yang gway iwhakacha an si'a nan chayum gway mihursu an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sija nan tinungpern chanan surchachu nan niwhilin an chicha. Inayacha as Pablo san sachi lawhi kun iyoycha ad Antipatrisa. ");
INSERT INTO kyb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mawhikat kun intuyud chanan nangawhaju as Pablo ad sa'ad chachay uchumay surchachu nanagkulincha san ampucha. ");
INSERT INTO kyb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hummu'nagcha kun ad Cesarea inatodcha nan suyat san kuwhinnachur asichaot ipayang as Pablo an sija. ");
INSERT INTO kyb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Whinasan kunan kuwhinnachur nan suyat inimusna an Pablo nu agwan nan ili gway nerpugwana. Naakammugwana kunay nerpus sija ad Silicia ");
INSERT INTO kyb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","anana, “Asi' si'a sumerjaon nu humu'nag chanan mangichayum an si'a.” Kun ingwhilinna gway mawhantajan as Pablo san agagya'janay hoyoy gway impata'chorn Herod. ");
INSERT INTO kyb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Neerkagwanan kus lima, ummoy as Ananias gway angatuwanay pachi ad Cesarea gway huyunna chanan uchumay chacha''orn chanan Hudyu ja nan atorni gway mangngachan Tertullus. Ummoycha impaagwat an Kuwhinnachur Felix nan chayumcha an Pablo. ");
INSERT INTO kyb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Impaajag kunan kuwhinnachur as Pablo, illukin Tertullus gway namawhersu an sija gway manggwana, “Nachajaw gway Kuwhinnachur! Kapu an si'a, nawhajag gway naurnus chanan Hudyu ja angsan nan hummayugwana kapu san laingnuway mantuyay. ");
INSERT INTO kyb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","San losanay chimpu ja san losanay ajanmi gway ili, whigwhikonmi nannaja gway amod nan jamanmi an si'a, nachajaw gway Kuwhinnachur Felix. ");
INSERT INTO kyb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lagwingo'ay ta'ta'on si'a, sija nan ochagwo' gway anusamud manchongor san sina'itanay iwhakami. ");
INSERT INTO kyb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Naakammugwanmiyay nannaja taku mangkuyukuyu ad sija nan mangilugyuki san kuyu sasan Hudyu san losanay ili san luhung. Sija ahos nan osaay panguyun chanan sumuyut san ma'gwaniyon Nazareno. ");
INSERT INTO kyb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pinachasna hos chim'on nan Templo sija nan chimpapmi. ");
INSERT INTO kyb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nu sumerjaom as sija, maakammugwam an sija gway tuttuwa losan nan chayummi an sija.” ");
INSERT INTO kyb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","