﻿USE sofia;
DROP TABLE IF EXISTS sofia.kxv_vpl;
CREATE TABLE kxv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kxv_vpl WRITE;
INSERT INTO kxv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଅବ୍ରାହାମ ମୀର୍‌ଏସି ଅ଼ଡ଼େ ଦାୱୁଦତି ମୀର୍‌ଏସି ଜୀସୁ କ୍ରୀସ୍ତତି କୂଡ଼ା । ");
INSERT INTO kxv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମ ମୀର୍‌ଏସି ଇସାହାକ, ଇସାହାକ ମୀର୍‌ଏସି ଜାକୁବ, ଜାକୁବ ମୀର୍‌ଏସି ଜୀହୁଦା ଇଞ୍ଜାଁ ତାମି ତାୟିୟାଁ, ");
INSERT INTO kxv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜୀହୁଦା ଅ଼ଡ଼େ ତାମାର ମୀର୍‌ଏସି ପେରସ ଅ଼ଡ଼େ ଜେରହ, ପେରସ ମୀର୍‌ଏସି ହେସ୍ରଣ, ହେସ୍ରଣ ମୀର୍‌ଏସି ଅରାମ, ");
INSERT INTO kxv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଅରାମ ମୀର୍‌ଏସି ଅମିନାଦାବ, ଅମିନାଦାବ ମୀର୍‌ଏସି ନହସନ, ନହସନ ମୀର୍‌ଏସି ସଲମନ, ");
INSERT INTO kxv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲମନ ଅ଼ଡ଼େ ରାହାବ୍‌ ମୀର୍‌ଏସି ବୟାଜ, ବୟାଜ ଅ଼ଡ଼େ ରୂତ ମୀର୍‌ଏସି ଅବେଦ, ଅବେଦ ମୀର୍‌ଏସି ଜିସି । ");
INSERT INTO kxv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଜିସି ମୀର୍‌ଏସି ଦାୱୁଦ ରାଜା, ଦାୱୁଦ ଅ଼ଡ଼େ ଉରିୟ ଡକ୍ରିନି ତା଼ଣାଟି ସଲମନ ଜାର୍ନା ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସଲମନ ମୀର୍‌ଏସି ରିହବୟାମ, ରିହବୟାମ ମୀର୍‌ଏସି ଅବିୟ, ଅବିୟ ମୀର୍‌ଏସି ଅସା, ");
INSERT INTO kxv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅସା ମୀର୍‌ଏସି ଜିହସାପାଟ୍‌, ଜିହସାପାଟ୍‌ ମୀର୍‌ଏସି ଜରାମ, ଜରାମ ମୀର୍‌ଏସି ଉଜିୟ, ");
INSERT INTO kxv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟ ମୀର୍‌ଏସି ଜତମ୍‌, ଜତମ୍‌ ମୀର୍‌ଏସି ଆହାଜ, ଆହାଜ ମୀର୍‌ଏସି ହିଜକିୟ, ");
INSERT INTO kxv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟ ମୀର୍‌ଏସି ମନସି, ମନସି ମୀର୍‌ଏସି ଆମନ, ଆମନ ମୀର୍‌ଏସି ଜସିୟ, ");
INSERT INTO kxv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଇସ୍ରାୟେଲଇଁ ବାବିଲନ ଦେ଼ସାତା ଦସାନା ଅ଼ନି ବେ଼ଲାତା ଜସିୟ ମୀର୍‌କା ଜିକନିୟ ଇଞ୍ଜାଁ ତାନି ତାୟିୟାଁ ଜାର୍ନା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲନତା ଅ଼ୱିଆ଼ତି ଜେ଼ଚ ଜିକନିୟ ସଲ୍‌ଟିୟେଲ୍‌ଇଁ ଜାର୍ନି କିତେସି, ସଲ୍‌ଟିୟେଲ୍‌ ମୀର୍‌ଏସି ଜିରୁବାବେଲ, ");
INSERT INTO kxv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲ ମୀର୍‌ଏସି ଅବିହୁଦ, ଅବିହୁଦ ମୀର୍‌ଏସି ଏଲିୟାକିମ, ଏଲିୟାକିମ ମୀର୍‌ଏସି ଅସର, ");
INSERT INTO kxv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅସର, ମୀର୍‌ଏସି ସାଦକ, ସାଦକ ମୀର୍‌ଏସି ଆକିମ, ଆକିମ ମୀର୍‌ଏସି ଏଲିହୁଦ, ");
INSERT INTO kxv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲିହୁଦ ମୀର୍‌ଏସି ଏଲିୟାଜର, ଏଲିୟାଜର ମୀର୍‌ଏସି ମତାନ, ମତାନ ମୀର୍‌ଏସି ଜାକୁବ, ");
INSERT INTO kxv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ଜାକୁବ ମୀର୍‌ଏସି ମରିୟମନି ଡକ୍ରା ଜସେପ, ଈ ମରିୟମନି ବାଣ୍ତିଟି ଜୀସୁ ଜାର୍ନା ଆ଼ତେସି, ଏ଼ୱାଣାଇଁ କ୍ରୀସ୍ତ ଇଣ୍‌ମ୍ବି ଆ଼ହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇଲେଆ଼ହିଁ ଅବ୍ରାହାମ ତା଼ଣାଟିଏ ଦାୱୁଦ ପାତେକା ସ଼ଦ ଜା଼ଣା ଆକୁୟାଁ, ଅ଼ଡ଼େ ଦାୱୁଦ ତା଼ଣାଟିଏ ବାବିଲନ ଅ଼ୱିଆ଼ତି ପାତେକା ସ଼ଦ ମାଣ୍‌ସି, ଇଞ୍ଜାଁ ବାବିଲନ ଅ଼ୱିଆ଼ତି ତା଼ଣାଟିଏ ଜୀସୁ କ୍ରୀସ୍ତତି ଜାର୍ନା ପାତେକା ସ଼ଦ ମାଣ୍‌ସି । ");
INSERT INTO kxv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଜୀସୁ କ୍ରୀସ୍ତତି ଜାର୍ନା ଇଲେକିଁ ଆ଼ତେ । ତାମି ଇୟା ମରିୟମ ଅ଼ଡ଼େ ଜସେପ ତଲେ ବୀହା ଆ଼ହାଲି ରୀସ୍‌ପି ଆ଼ହାମାଚି ଜେ଼ଚ, ଏ଼ୱି କା଼ଲ୍‌ୱି ଆ଼ଆ ନ଼କେଏ, ଏ଼ଦି ସୁଦୁଜୀୱୁ ତଲେ ପୂରାମା଼ସା ଆ଼ହାମାନେ ଇଞ୍ଜିଁ ପୁଣ୍‌ମ୍ବି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଏଚେଟିଏ ତାନି ଡକ୍ରା ଜସେପ ର଼ ଦାର୍ମୁ ଲ଼କୁ ମାଚାକି, ଇଞ୍ଜାଁ ଏ଼ଦାଣି ଲ଼କୁ ନ଼କିତା ଦ଼ହ ଗାଟାୟି ଇଞ୍ଜିଁ ତ଼ହ୍‌ଆପେଏଁ ଇଞ୍ଜିଁ ଏ଼ଦାନି ଡ଼ୁକ୍‌ହାନା ପିସାଲି ତୀରି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ସାମା ଏ଼ୱାସି ଏଲେଇଞ୍ଜି ତୀରିକିତି ଡା଼ୟୁ, ମେହ୍‌ଦୁ, ମାହାପୂରୁତି ର଼ ଦୂତୁ ଏ଼ୱାଣାଇଁ ହାପାନାତା ଏଲେଇଚେସି, “ଆଡ଼େ ଦାୱୁଦ କୂଡ଼ାତି ଜସେପ, ମରିୟମନି ଡକ୍ରି କିହାଲିତାକି ଆଜାଆନି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁତି ସୁଦୁଜୀୱୁ ତଲେ ପୂରାମା଼ସା ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ଏ଼ଦି ର଼ କକାଣାଇଁ ଜାର୍ନି କିନେ, ଅ଼ଡ଼େ ମୀରୁ ଏ଼ୱାଣି ଦ଼ରୁ ଜୀସୁ ଇଞ୍ଜିଁ ଇଟାଦୁ, ଇଚିହିଁ ଏ଼ୱାସି ତାମି ଲ଼କୁଇଁ ତାମି ବାରେ ପା଼ପୁଟି ଗେଲ୍‌ପିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ପ୍ରବୁତି ଈ କାତା ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ, ଈଦାଆଁତାକି ଈ ବାରେ ଆ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ମେହଦୁ ର଼ ଡ଼ାଆ ମା଼ଙ୍ଗା ପୂରାମା଼ସା ଆ଼ହାନା ର଼ କକାଣାଇଁ ଜାର୍ନି କିନେ, ଅ଼ଡ଼େ ଲ଼କୁ ଏ଼ୱାଣି ଦ଼ରୁ ‘ଇମାନୁୟେଲ’ ଇଟିନେରି ।” ଈ ଦ଼ରୁତି ଅର୍ତ “ମାହାପୂରୁ ମା଼ ତଲେ ମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଏମ୍ବାଟିଏ ଜସେପ ଇଦାଟି ନିଙ୍ଗିତି ଡା଼ୟୁ ପ୍ରବୁତି ଦୂତୁ ଏ଼ନିକିଁ ହୁକୁମି ହୀହାମାଚେସି, ଏଲେକିହିଁଏ କିତେସି, ଏ଼ୱାସି ମରିୟମଇଁ ବୀହା ଆ଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ସାମା ଏ଼ଦି କକାଣାଇଁ ଜାର୍ନି କିଆ ପାତେକା ଏ଼ଦାଣି ତଲେ କୂଡ଼ାଆତେସି, ଅ଼ଡ଼େ ଏ଼ କକାଣି ଦ଼ରୁ ଜୀସୁ ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରଦ ରାଜା ବେ଼ଲାତା ଜୀହୁଦା ଦେ଼ସାତି ବେତଲିହିମ ଗା଼ଡ଼ାତା ଜୀସୁ ଜାର୍ନାଆ଼ତି ଡା଼ୟୁ, ମେହ୍‌ଦୁ, ୱେ଼ଡ଼ା ହ଼ପୁ ୱାକିଟି ଏଚରଜା଼ଣା ସ଼ଗୁପୁନାରି ଜିରୁସାଲମତା ୱା଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ଆମିନି କକାସି ଜୀହୁଦିଙ୍ଗା ରାଜା ଆ଼ହାଲି ଜାର୍ନା ଆ଼ହାମାନାସି, ଏ଼ୱାସି ଆମ୍ବିୟା ? ମା଼ମ୍ବୁ ୱେ଼ଡ଼ା ହ଼ପୁ ୱାକିଟି ତାନି ହୁକା ମେସାନା ଏ଼ୱାଣାଇଁ ଜହରା କିହାଲି ୱା଼ହାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ଈ କାତା ୱେଞ୍ଜାନା ହେରଦ ରାଜା ଅ଼ଡ଼େ ତାନିତଲେ ଜିରୁସାଲମତି ବାରେ ଲ଼କୁ କାବାଆ଼ହାନା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ଅ଼ଡ଼େ ଏ଼ୱାସି ଲ଼କୁତି କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ମେ଼ରା ପୁନାରାଇଁ କୂଡ଼ି କିହାନା, କ୍ରୀସ୍ତ ଏମ୍ବିୟା ଜାର୍ନା ଆ଼ନେସି, ଏ଼ଦାଆଁ ଏ଼ୱାରି ତା଼ଣାଟି ପୁଞ୍ଜାଲି ଅଣ୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, ଜୀହୁଦା ଦେ଼ସାତି ବେତଲିହିମ ଗା଼ଡ଼ାତା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ଇଲେଇଞ୍ଜିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ଏ଼ ଜୀହୁଦା ଦେ଼ସାତି ବେତଲିହିମ, ଜୀହୁଦାତି କାଜା ନା଼ସ୍‌କା ବିତ୍ରାଟି ନୀନୁ ଊଣା ଆ଼ଏ; ଇଚିହିଁ ଆମ୍ବାଆସି ନା଼ ଇସ୍ରାୟେଲ ଲ଼କୁଣି ପ଼ହି କିନେସି, ଏଲେତି ର଼ ସା଼ଲୱି କିନାସି ନୀ ତା଼ଣାଟି ୱା଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଡା଼ୟୁ ହେରଦ ସ଼ଗୁ ପୁନାରାଇଁ ମେ଼ଣେଏ ହା଼ଟାନା, ଏ଼ ହୁକା ଏଚେଲା ତ଼ଞ୍ଜାଆ଼ତେ ଏ଼ କାତା ଏ଼ୱାରି ତା଼ଣାଟି ନେହିଁକିଁ ୱେଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ବେତଲିହିମତା ପାଣ୍ତାନା ଏଲେଇଚେସି, “ମୀରୁ ହାଜାନା ଏ଼ କକାଣି କାତା ନେହିଁକିଁ ସିନିକିହାନା ନାଙ୍ଗେ ଜିକେଏ ୱେସ୍ତାଦୁ, ଇଚିହିଁ ନା଼ନୁ ଜିକେଏ ହାଜାନା ଜହରା କିକାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ଏଚେଟିଏ ଏ଼ୱାରି ରାଜା କାତା ୱେଞ୍ଜାନା ହାଚେରି; ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ଏ଼ୱାରି ୱେ଼ଡ଼ା ହ଼ପୁୱାକି ଆମିନି ହୁକା ମେସାମାଚେରି, ଏ଼ଦି ଏ଼ୱାରି ନ଼କି ନ଼କିତା ହାଜାନା, ଏମ୍ବିୟା କକାସି ମାଚେସି ଏ଼ ଲାକ ହାଜାନା ନିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ଏ଼ ହୁକା ମେସାନା ଏ଼ୱାରି ହା଼ରେକା ରା଼ହାଁତଲେ ରା଼ହାଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ଏ଼ୱାରି ଇଲୁ ବିତ୍ରା ହ଼ଡାନା ତାମି ଇୟା ମରିୟମ ଇଞ୍ଜାଁ କକାଣି ଡା଼ଲୁଇଁ ମେସାନା, ଏ଼ୱାଣାଇଁ ମେଣ୍ତାକୁତାନା ଜହରା କିତେରି, ଇଞ୍ଜାଁ ତା଼ମ୍ବୁ ତାଚାମାଚି ପେ଼ଡ଼ାୟାଁଟି ବାଂଗାରା, ଦୁପା ଦୁପ୍‌ଣି ଅ଼ଡ଼େ ଗାନ୍ଦା ନିୟୁଁ ବେଟୁ ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଡା଼ୟୁ ହେରଦ ରାଜା ତା଼ଣା ୱେଣ୍ଡା ହାଲାଆପେରିୱା ଇଞ୍ଜିଁ ମାହାପୂରୁ ଏ଼ୱାରାଇଁ ହାପାନାତା ହୁକୁମି ହୀହାଲିଏ, ଏ଼ୱାରି ଅ଼ର ଜିରୁଟି ତାମି ଦେ଼ସାତା ୱେଣ୍ଡାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ଏ଼ୱାରି ହାଚି ଡା଼ୟୁ, ମେହ୍‌ଦୁ, ମାହାପୂରୁତି ଦୂତୁ ଜସେପଇଁ ହାପାନାତା ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ କକାଣି ଡା଼ଲୁଇଁ ଅ଼ଡ଼େ ତାମି ଇୟାନି ଅ଼ହିଁ ମିସରତା ହାଲାମୁ, ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାଆ ପାତେକା ଏମ୍ବାଆଁ ମାଞ୍ଜୁ, ଇଚିହିଁ କକାଣି ଡା଼ଲୁଇଁ ପା଼ୟାଲି ହେରଦ ଅଣ୍‌ପିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଜସେପ ନିଙ୍ଗାନା କକାଣି ଡା଼ଲୁ ଇଞ୍ଜାଁ ତାମି ଇୟାନି ଆସାନା ଲା଼ଆଁ ଲା଼ଆଁୟାଁ ମିସର ଦେ଼ସାତା ଅ଼ହିଁ ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରଦ ହା଼ନି ପାତେକା ଏମ୍ବାଆଁ ଏ଼ୱାରି ଡ଼ୟିତେରି, ଈ ବାରେ ଗଟୱି ଆ଼ନାଣି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ଈ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ପୂରା ଆ଼ନେ, “ନା଼ ମୀର୍‌ଏଣାଇଁ ନା଼ନୁ ମିସର ଦେ଼ସାଟି ହା଼ଟା ତାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ୱେ଼ଡ଼ା ହ଼ପୁ ଦେ଼ସାଟି ୱା଼ହାମାଚି ସ଼ଗୁପୁନାରି ଏ଼ୱାଣାଇଁ ନା଼ଡ଼ିକିହାନା ହାଜାମାନେରି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା, ହେରଦ ହା଼ରେକା କ଼ପା ଆ଼ତେସି, ହୁକାତି ଉଜେଡ଼ି ଆମିନି ବେ଼ଲାତା ତ଼ଞ୍ଜାଆ଼ହାମାଚେ ସ଼ଗୁପୁନାରି ତା଼ଣାଟି ନେହିଁକିଁ ପୁଞ୍ଜାମାଚେସି, ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ବେତଲିହିମ ଅ଼ଡ଼େ ତାନି ଡାଗେ ମାଚି ନା଼ସ୍‌କାତି ରୀ ବାର୍ସାଟିଏ ଊଣା କକାରାଇଁ ପା଼ୟାଲି ତାକି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଏଚିବେ଼ଲା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିରିମିୟ ୱେସ୍ତି ଈ ବ଼ଲୁ ସାତା ଆ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରମାତା ହା଼ଡା ୱେ଼ଙ୍ଗିମାନେ, ଡ଼ୀକି ଅ଼ଡ଼େ ହା଼ରେକା ଦୁକୁତି ଗିୟାଁ ରାହେଲ ତାନି ମୀର୍‌କା ତାକି ଡ଼ୀହିମାଚେ; ଅ଼ଡ଼େ ଏ଼ୱାରି ବାରେ ହା଼ହାହାଚେରି ଇଞ୍ଜିଁ, ଏ଼ଦି ଦୁକୁ ଡୂକ୍‌ହାଲି ମ଼ନ କିହି ହିଲାଆତେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରଦ ହା଼ତି ଡା଼ୟୁ, ମେହ୍‌ଦୁ, ପ୍ରବୁତି ର଼ ଦୂତୁ ମିସରତା ଜସେପଇଁ ହାପାନାତା ତ଼ଞ୍ଜାଆ଼ହାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ନିଙ୍ଗାମୁ, କକାଣାଇଁ ଅ଼ଡ଼େ ତାମି ଇୟାନି ତଲେ ଇସ୍ରାୟେଲ ଦେ଼ସାତା ହାଲାମୁ, ଇଚିହିଁ ଆମ୍ବାଆରି କକାଣି ଜୀୱୁ ଅ଼ହାଲି ତାକି ଅଣ୍‌ପିମାଚେରି ଏ଼ୱାରି ହା଼ହାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଏଚେଟିଏ ଜସେପ ନିଙ୍ଗାନା କକାଣାଇଁ ଇଞ୍ଜାଁ ତାମି ଇୟାନି ଆସାନା ଇସ୍ରାୟେଲ ଦେ଼ସାତା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ସାମା ହେରଦ ଟା଼ୟୁତା ତାନି ମୀର୍‌ଏସି ଆର୍କିଲାୟ ଜୀହୁଦାତି ରାଜା ଆ଼ହାମାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା ଏ଼ୱାସି ଏମ୍ବାଆଁ ହାଜାଲି ଆଜିତେସି; ସାମା ହାପାନାତା ହୁକୁମି ବେଟାଆ଼ହାନା ଏ଼ୱାସି ଗାଲିଲି ରା଼ଜି ୱାକି ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ଇଞ୍ଜାଁ ନା଼ଜରିତତି ଗା଼ଡ଼ାତା ହାଜାନା ଡ଼ୟିତେରି, ଏ଼ନିକିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ରା଼ଚିତି କାତା ସାତା ଆ଼ନେ, “ଏ଼ୱାସି ନା଼ଜରିତତାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ଏ଼ ବେ଼ଲାତା ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ଜୀହୁଦା ଦେ଼ସାତି ବାଃଲି ବାଟାଟି ୱା଼ହାନା ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ପା଼ପୁ ପିସାନା ମ଼ନ ୱେଟ୍‌ହା କଡାଦୁ, ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଏଗାୱା଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ତା଼ଣାଟି ଈ ହା଼ଡା ୱେସ୍‌ପି ଆ଼ହାମାଚେ, ଏ଼ୱାସିଏ ଈୱାସି; “ରଅଣି ହା଼ଡା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ୱେ଼ଙ୍ଗିମାନେ, ପ୍ରବୁ ତାକି ଜିରୁ ତିୟି କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଜହନ ଊଟୁ ବା଼ଣାୟାଁ ତଲେ କେ଼ପିତି ହିମ୍ବରିକା ତୁର୍‌ହିମାଚେସି, ଇଞ୍ଜାଁ ତାନି ଟେଡେଲିତା ର଼ ତ଼ଲୁତି ବୁଡ଼୍‌ପା ମା଼ଡ଼ା ଦସା କଡ୍‌ୱିତେସି, ଗପ୍‌ଏରିକା ଅ଼ଡ଼େ ଜା଼ଡ଼ାତି କ୍ରିୟାଁ ଏ଼ୱାଣି କା଼ଦି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଏଚିବେ଼ଲାତା ଜିରୁସାଲମ ଗା଼ଡ଼ା ଇଞ୍ଜାଁ ବାରେ ଜୀହୁଦା ଦେ଼ସା ଅ଼ଡ଼େ ଜର୍ଦନ ଦାରିତି ନା଼ସ୍‌କାତି ବାରେ ଲ଼କୁ ତାନି ତା଼ଣା ୱା଼ହାଲି ମା଼ଟ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଏ଼ୱାରି ଜାହାରା ପା଼ପୁ ୱେସାନା ଜହନ ତା଼ଣାଟି ଜର୍ଦନ କାଡାତା ବାପ୍ତିସ୍ମ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ସାମା ହା଼ରେକା ପାରୁସିୟାଁ ଅ଼ଡ଼େ ସାଦୁକିୟାଁ ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ୱା଼ହିମାନାଣି ମେସାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଅ଼ଡ଼େ ରା଼ସ୍‌କା କୂଡ଼ାତାତେରି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହିମାନି କ଼ପାଟି ପିସ୍‌ପି କିହାକଡାଲି ଆମ୍ବାଆସି ମିଙ୍ଗେ ସେତ୍‌ନା ହିୟାତେସି ");
INSERT INTO kxv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଈଦାଆଁତାକି ମ଼ନ ୱେଟ୍‌ହାମାନାଣି ନେହିଁ କାମାତା ତ଼ହ୍‌ଦୁ, ");
INSERT INTO kxv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଅ଼ଡ଼େ ଅବ୍ରାହାମ ମା଼ ଆ଼ବା ଇଞ୍ଜିଁ ମୀ ମ଼ନ ବିତ୍ରା ଅଣ୍‌ପାଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ଈ ୱାଲ୍‌କାଟି ଜିକେଏ ଅବ୍ରାହାମତି ମୀର୍‌କାଣି ଗା଼ଡ଼ି କିହାଲି ଆ଼ଡିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଅ଼ଡ଼େ ନୀଏଁ ଜିକେଏ ମା଼ର୍‌ନୁ ଡାକିତା କାଃଆଲି ଆଟାମାନେ, ଆମିନି ମା଼ର୍‌ନୁ ନେହିଁ ପା଼ଡ଼େୟି ଆ଼ୟେଏ, ଏ଼ଦାନି ଟୂଣ୍‌ହାନା ହିଚୁତା ମେତ୍‌ପି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ନା଼ନୁସାଁ ମିଙ୍ଗେ ପା଼ପୁଟି ପିସ୍‌ପି କିହାଲି ଇଞ୍ଜାଁ ମ଼ନ ୱେଟ୍‌ପି କିହାଲି ଏ଼ୟୁତଲେ ବାପ୍ତିସ୍ମ ହୀହିମାଞ୍ଜାଇଁ, ସାମା ନା଼ ଡା଼ୟୁ ରଅସି ୱା଼ହିମାନେସି ଏ଼ୱାସି ନା଼ କିହାଁ ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁ ଗାଟାସି, ଏ଼ୱାଣି ସେପୁୟାଁ ହୁକ୍‌ହାଲି ଜିକେଏ ନା଼ନୁ ପା଼ଡ଼ାଆ଼ଅଁ; ଏ଼ୱାସି ମିଙ୍ଗେ ସୁଦୁଜୀୱୁ ଇଞ୍ଜାଁ ହିଚୁତଲେ ବାପ୍ତିସ୍ମ ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଏ଼ୱାସି ତାନି କ୍ଡାନୁତି ନେହିଁକିଁ ତାସାହାଁ, ତାନି ଆର୍ନାତି କ୍ଡସାହାଁ ଗା଼ଦେୟିତା ଇଟାଲି ଏ଼ୱାଣି କେୟୁତା ହେ଼ଚି ମାନେ, ସାମା ଟା଼ଟା ପ଼ଡ଼ୁତି ଏଚେଲା ଡୁମ୍ବାଆଗାଟି ହିଚୁତା ହୂଡା ତୁହ୍‌ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ଏଚିବେ଼ଲା ଜୀସୁ ଗାଲିଲିଟି ୱା଼ହାନା ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ତାକି ଜର୍ଦନ କାଡାତା ଜହନ ତା଼ଣା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ସାମା ଜହନ ଜୀସୁଇଁ କା଼ହି କିହାଲି ଅଣ୍‌ପାନା ଏଲେଇଚେସି, “ନୀ ତା଼ଣାଟି ନା଼ନୁ ବାପ୍ତିସ୍ମ ଅ଼ନାୟି ନା଼ ଲ଼ଡ଼ାମାନେ, ଇଞ୍ଜାଁ ନୀନୁ ନା଼ ତା଼ଣା ୱା଼ହାମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ହା଼ଡା ଆହ୍‌ମୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଇଲେ ତଲେ ମାହାପୂରୁ ଦାର୍ମୁତି କାମା କିନାୟିମାନେ ।” ଏଚେଟିଏ ଜହନ ମା଼ନୱି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜୀସୁ ବାପ୍ତିସ୍ମ ଅ଼ତି ଦେବୁଣିଏ ଏ଼ୟୁଟି ନିଙ୍ଗା ୱା଼ତେସି । ଏଚେଟିଏ ହା଼ଗୁ ଦେପିଆ଼ତେ, ଇଞ୍ଜାଁ ମାହାପୂରୁତି ସୁଦୁଜୀୱୁ ପା଼ର୍‌ୱା ପଟାଲେହେଁ ଜୀସୁ ଲାକ ରେ଼ଚା ୱା଼ହିମାଚାଣି ଜହନ ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ହା଼ଗୁଟି ଈ ହା଼ଡା ଆ଼ତେ, “ଈୱାସି ନା଼ ଜୀୱୁତି ମୀର୍‌ଏସି ଈୱାଣି ତା଼ଣା ନା଼ ହା଼ରେକା ରା଼ହାଁ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଏଚିବେ଼ଲା ଜୀସୁ ସୟତାନ ତା଼ଣାଟି ତାୟିପାରି କିୱି ଆ଼ହାଲି ସୁଦୁଜୀୱୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଅ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଜୀସୁ ରୀ କ଼ଡ଼ି ଦିନା ଲା଼ଆଁୟାଁ ମାଦେନା ଏ଼ନାଆଁ ତିନାଆନା ଉପାସା କିହାଁ ହାକି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ଏଚିବେ଼ଲା ସୟତାନ ତାନି ଦାରିତା ୱା଼ହାନା ଏଲେଇଚେ, “ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଇଚିସାରେ ଈ ୱାଲ୍‌କାଣି ରୂଟି ଆ଼ହାଲି ହୁକୁମି ହୀମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ ମାଣ୍‌ସି ୱାର୍‌ଇ ରୂଟି ତିଞ୍ଜାନା ନୀଡଅସି, ସାମା ମାହାପୂରୁ ଗୂତିଟି ହ଼ଚିମାନି ବ଼ଲୁ ତଲେ ନୀଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଡା଼ୟୁ ସୟତାନ ଜୀସୁଇଁ ସୁଦୁ ଗା଼ଡ଼ା ଜିରୁସାଲମତା ଅ଼ହାନା, ମାହାପୂରୁ ଇଲୁ ତୂଡ଼ିୟା ଲାକ ନିପ୍‌ହାନା, ");
INSERT INTO kxv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ଏଲେଇଚେ, “ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଇଚିହିଁ ଇମ୍ବାଟି ଡ଼଼ଇକା ଗେ଼ମ୍ବାମୁ,” ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନିଙ୍ଗ ଜାତ୍‌ନୁ କିହାଲିତାକି ମାହାପୂରୁ ତାନି ଦୂତୁୟାଁଇଁ ହୁକୁମି ହୀନେସି; “ନୀ କଡାୟାଁ ଏ଼ନିକିଁ ୱାଲ୍‌କାଣା ଆ଼ଡାଉ ଇଞ୍ଜାଁ ଦୂତୁୟାଁ ନିଙ୍ଗ କେସ୍କାତଲେ ପେର୍‌ହା ଆସ୍ତାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନୀନୁ ପ୍ରବୁ ନୀ ମାହାପୂରୁଇଁ ତାୟିପାରି କିଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ଅ଼ଡ଼େ ୱେଣ୍ତେ ସୟତାନ ଜୀସୁଇଁ କାଜା ହ଼ରୁ ଲାକ ଅ଼ହାନା ଦାର୍‌ତିତି ବାରେ ରା଼ଜି ଅ଼ଡ଼େ ଏମ୍ବାତି ବାରେ ଅ଼ଜୁ ଅ଼ଡ଼େ ଜୂପ୍‌କା ତ଼ସାନା ଏଲେଇଚେ, ");
INSERT INTO kxv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ନୀନୁ ନାଙ୍ଗେ ମେଣ୍ତାକୁତାନା ଜହରା କିୟାଦି ଇଚିହିଁ ନା଼ନୁ ଈ ବାରେ ନିଙ୍ଗ ହିୟାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ ସୟତାନ ନା଼ ତା଼ଣାଟି ହେକ ହାଲାମୁ ! ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ୱାର୍‌ଇ ନୀ ପ୍ରବୁ ମାହାପୂରୁଇଁ ଜହରା କିଦି ଅ଼ଡ଼େ ୱାର୍‌ଇ ତାଙ୍ଗେଏ ସେ଼ବା କିଦି ।’” ");
INSERT INTO kxv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ଏ଼ ଦେବୁଣିଏ ସୟତାନ ଜୀସୁଇଁ ପିସାନା ହାଜାତୁସ୍ତେ; ଅ଼ଡ଼େ ଦୂତୁୟାଁ ୱା଼ହାନା ଏ଼ୱାଣି ସେ଼ବା କିତୁ । ");
INSERT INTO kxv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଜହନଇଁ କାୟିଦି ଇଲୁତା ଇଟିତେରି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା ଜୀସୁ ଏମ୍ବାଟିଏ ଗୁଚା ଆ଼ହାନା ଗାଲିଲିତା ୱା଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ଏ଼ୱାସି ନା଼ଜରିତତା ଡ଼ୟାଆତେସି, ସାମା କପର୍‌ନାହୁମତା ଡ଼ୟାଲି, ସୁବୁଲୁନ୍‌ ଅ଼ଡ଼େ ନପ୍ତାଲିତା ମାନି ର଼ ଗାଲିଲି ସାମ୍‌ଦୁରି ଗାଟୁତା ମାନି ଗା଼ଡ଼ାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଏ଼ନିକିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି ହା଼ଡା ସାତା ଆ଼ନେ, ଏ଼ୱାସି ଏଲେଇଞ୍ଜାମାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ସୁବୁଲୁନ୍‌ ଦେ଼ସା ଅ଼ଡ଼େ ନପ୍ତାଲି ଦେ଼ସା ସାମ୍‌ଦୁରି ଡାଗେ ଇଞ୍ଜାଁ ଜର୍ଦନ କାଡା ଆତାଲାୱାକିତି, ଜୀହୁଦିଆ଼ଆତି ଗାଲିଲି ! ");
INSERT INTO kxv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଆନ୍ଦେରିତା ବାସା କିହିମାନି ଲ଼କୁ କାଜା ଉଜେଡ଼ି ମେସ୍ତେରି ହା଼କିତି ନା଼ସ୍‌କା ଅ଼ଡ଼େ ସାହ୍‌ଡ଼ାତା ମାନି ଲ଼କୁତାକି ଉଜେଡ଼ି ତ଼ଞ୍ଜାଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଏ଼ ବେ଼ଲାଟିଏ ଜୀସୁ ତାନି କାତା ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, “ମୀ ପା଼ପୁ ପିସାନା ମ଼ନ ୱେଟ୍‌ହା କଡାଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଏଗାୱା଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜୀସୁ ଗାଲିଲି ସାମ୍‌ଦୁରି ଗାଟୁଟି ହାଜିମାଚାଟି ସିମନ ଇନି ପିତର ଅ଼ଡ଼େ ତାନି ତାୟି ଆନ୍ଦ୍ରିୟ, ଈ ତାୟି ରିଆରି ସାମ୍‌ଦୁରିତା ଜା଼ଲା ମେତ୍‌ହି ମାଚାଣି ମେସ୍ତେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ମୀଣ୍‌କା ଆହ୍‌ନାରି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ଦୁ, ନା଼ନୁ ମିଙ୍ଗ ଲ଼କୁଣି ଆହ୍‌ନାଣି ଜା଼ପ୍‌ହାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ଏଚେଟିଏ ଏ଼ୱାରି ଦେବୁଣିଏ ଜା଼ଲା ପିସାନା ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଏମ୍ବାଟିଏ ଜୀସୁ ନ଼କିତା ହାଜାନା ଜେବଦି ମୀର୍‌କା ଜାକୁବ ଅ଼ଡ଼େ ଏ଼ୱାଣି ତାୟି ଜହନ ଦ଼ରୁଗାଟାସି ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ରିଆରି ତାୟିୟାଁ ତାମି ଆ଼ବା ଜେବଦି ତଲେ ଡଂଗତା ଜା଼ଲା ମୁଦା କିହିମାଚାଣି ମେସାନା ଏ଼ୱାରାଇଁ ଜିକେଏ ହା଼ଟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ ଦେବୁଣିଏ ଡଂଗ ଅ଼ଡ଼େ ତାମି ଆ଼ବାଇଁ ପିସାନା ଜୀସୁ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଡା଼ୟୁ ଜୀସୁ ଗାଲିଲି ଦେ଼ସାତା ରେ଼ଜି ରେ଼ଜିହିଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ଜା଼ପ୍‌ହିହିଁ, ମାହାପୂରୁ ରା଼ଜିତି ନେହିଁ କାବ୍ରୁ ୱେସିହିଁ ର଼ଗଗାଟି ଲ଼କୁଣି ନେହିଁ କିହାଲି ମା଼ଟ୍‌ହେସି, ");
INSERT INTO kxv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ଅ଼ଡ଼େ ଏ଼ୱାଣି କାତା ଦେ଼ସାତି ସା଼ରିୱାକି ଇଞ୍ଜାଁ ସିରିୟା ଦେ଼ସାତା ଜିକେଏ ୱେ଼ଙ୍ଗାହାଚେ, ଇଞ୍ଜାଁ ଲ଼କୁ ବୂତୁୟାଁ ଆଲ୍‌ଗା ମାଚାରାଇଁ, କାଟିୱେତାରାଇଁ, ଇଞ୍ଜାଁ ଟଟ ୱା଼ୟିତାରାଇଁ; ଇଲେତି ହା଼ରେକା ର଼ଗଟି କସ୍ତ ଆ଼ହିମାନାରାଇଁ ଜୀସୁ ନ଼କିତା ତାତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଅ଼ଡ଼େ ଗାଲିଲି, ଦସଗଟା ନା଼ସ୍‌କା, ଜିରୁସାଲମ, ଜୀହୁଦା ଅ଼ଡ଼େ ଜର୍ଦନତି ଏ଼ ଗାଟୁତା ମାନି ନା଼ସ୍‌କାଟି ହା଼ରେକା ଲ଼କୁ ଜୀସୁ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜୀସୁ ହା଼ରେକା ଲ଼କୁଇଁ ମେସାନା ର଼ ହ଼ରୁ ଲାକ ହାଜାନା କୁଗିତେସି, ଇଞ୍ଜାଁ ସୀସୁୟାଁ ଏ଼ୱାଣି ଡାଗେ ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଗୂତି ଏ଼କ୍‌ହାନା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ଆମ୍ବାଆରି ଜୀୱୁତା ଏ଼ନାଆଁ ହିଲାଆ ଗାଟାରାକି ନେହେଁ, ଏ଼ନିଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଏ଼ୱାରି ୱା଼ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଆମ୍ବାଆରି ଦୁକୁତା ଡ଼ୀହିମାନି ଲ଼କୁତାକି ନେହେଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁ ଏ଼ୱାରି ଦୁକୁ ଡୂକ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","କ଼ପା ହିଲାଆ ଗାଟାରି ନେହେଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଦାର୍‌ତିତା ଏ଼ୱାରି ଅଦିକାରା ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ମାହାପୂରୁ ଦାର୍ମୁତି କାମା କିହାଲି ହାକି ଏ଼ସ୍‌କି ଗାଟାରି ଏ଼ୱାରାକି ନେହେଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁ ଏ଼ୱାରାକି ଲ଼ଡ଼ାମାନାଣି ବାରେ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ଏଟ୍‌କା ଲ଼କୁଣି କାର୍ମା ମେହ୍‌ନେରି, ଏ଼ୱାରାକି ନେହେଁ, ଏ଼ନିଇଚିହିଁ ମାହାପୂରୁ ଏ଼ୱାରାଇଁ କାର୍ମା ମେହ୍‌ନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ଆମ୍ବାଆରି ସୁଦୁ ହିୟାଁ ଗାଟାରି ଏ଼ୱାରାକି ନେହେଁ, ଏ଼ନିଇଚିହିଁ ଏ଼ୱାରି ମାହାପୂରୁଇଁ ମେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ହିତ୍‌ଡ଼ି ଗାଟି ଲ଼କୁ ନେହେଁ, ଏ଼ନିଇଚିହିଁ ଏ଼ୱାରି ମାହାପୂରୁତି ମୀର୍‌କା ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ମାହାପୂରୁ ଦାର୍ମୁ କାତାତାକି ଦୁକୁ ବେଟାଆ଼ନାରି ଏ଼ୱାରାକି ନେହେଁ, ଏ଼ନିଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଏ଼ୱାରିୱାୟି । ");
INSERT INTO kxv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ଏଚିବେ଼ଲା ଲ଼କୁ ମିଙ୍ଗ ନା଼ ତାକି ନିନ୍ଦା କି ଲାଜା କିୟାନେରି, ଅ଼ଡ଼େ ନା଼ ତାକି ଉଜେ ଉଜେଏ ମୀ କ଼ପାଟି ମିଚି କାତା ଜ଼ଲାନେରି, ଆତିହିଁ ମିଙ୍ଗେ ତାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ରା଼ହାଁ ଆ଼ହାନା ଏ଼ନ୍ଦାଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଲାକପୂରୁତା ମୀ ତାକି ହା଼ରେକା ଦା଼ନା ମାନେ; ଏଲେକିହିଁଏ, ମୀ ନ଼କିତି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ଜିକେଏ ଇଲେକିହିଁ ନିନ୍ଦା କିହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ମୀରୁ ବାରେ ଦାର୍‌ତିତି ହା଼ରୁ ଲେହେଁ, ସାମା ହା଼ରୁ ମୂଆତିହିଁ, ଅ଼ଡ଼େ ଏ଼ଦାଆଁ ଏମ୍ବିୟା ଜିକେଏ ଲେ଼ମ୍ବାଲି ଆ଼ଏ, ଇଞ୍ଜାଁ ଏ଼ଦି ଏ଼ନି କାମାତା ପା଼ଡ଼ା ଆ଼ଏ, ଲ଼କୁ ଏ଼ଦାଆଁ କଡାଁ ଡ଼଼ଇ ୱିସା ହାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ମୀରୁ ଦାର୍‌ତିତି ଉଜେଡ଼ି ତେରି, ଆମିନି ଗା଼ଡ଼ା ହ଼ରୁ ଲାକ କେ଼ପି ଆ଼ହାମାନେ, ଏ଼ଦି ଏଚେଲା ଡ଼ୁଗାନା ଡ଼ୟାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଅ଼ଡ଼େ ଦୀୱଁ ଡ଼ୀସାନା ଆମ୍ବାଆରି ମା଼ଣା ପ୍ଡିକ୍‌ହାନା ଇଟଅରି, ସାମା ଏ଼ଦାନି ଦୀୱଁ ସ଼ଡ଼ାତା ଇଟିନେରି, ଆତିହିଁ ଇଲୁତା ୱା଼ନି ବାରେ ଲ଼କୁ ଉଜେଡ଼ି ମେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଏଲେକିହିଁଏ ମୀ ଉଜେଡ଼ି ଲ଼କୁ ନ଼କିତା ନେହିଁକିଁ ତ଼ଞ୍ଜାଆ଼ପେ, ଏ଼ନିକିଁ ଏ଼ୱାରି ମୀ ନେହିଁ କାମା ମେସାନା ଲାକପୂରୁତି ଆ଼ବାତି ଗାୱୁରମି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ନାଙ୍ଗେ ମ଼ସାତି ମେ଼ରା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ମେ଼ରାତି ମ୍ଣେକ୍‌ହାଲି ୱା଼ହାମାନେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପାଆଦୁ; ନା଼ନୁ ମ୍ଣେକ୍‌ହାଲି ୱା଼ହାହିଲଅଁ ସାମା ଈ ବାରେ ପୂରା କିହାଲି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ହା଼ଗୁପା଼କା ଅ଼ଡ଼େ ଦାର୍‌ତି ମେଣ୍‌ଙ୍ଗାଆ ପାତେକା ଇଞ୍ଜାଁ ଈ ବାରେ ଆ଼ଆପାତେକା ମ଼ସା ମେ଼ରାତି ଇଚାୟି ସିନା ଜିକେଏ ମେଣ୍‌ଙ୍ଗେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଆମ୍ବାଆସି ଈ ହୁକୁମିଟି ର଼ ଊଣା ହୁକୁମି ମା଼ନୱି ଆ଼ଅସି ଅ଼ଡ଼େ ଲ଼କୁଇଁ ଏଲେକିହିଁଏ ଜା଼ପ୍‌ନେସି, ଏ଼ୱାସି ଲାକପୂରୁ ରା଼ଜିତା ଊଣା ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି; ସାମା ଆମ୍ବାଆସି ମା଼ନୱି ଆ଼ନେସି ଅ଼ଡ଼େ ଜା଼ପ୍‌ନେସି ଏ଼ୱାସି ଲାକପୂରୁ କାଜାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀ ଦାର୍ମୁ ମେ଼ରା ପୁନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଦାର୍ମୁ କିହାଁ ମୀ ନାମୁ ହା଼ରେକା ଆ଼ଆତିହିଁ, ମୀରୁ ଜିକେଏ ଲାକପୂରୁ ରା଼ଜିତା ହ଼ଡାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ମୀରୁ ୱେଞ୍ଜାମାଞ୍ଜେରି, ତଲିକା଼ଲାତି ଲ଼କୁଇଁ ୱେସ୍‌ପିଆ଼ହାମାଚେ, ‘ଲ଼କୁଇଁ ପା଼ୟାଆଦୁ, ଆମ୍ବାଆରି ଲ଼କୁଇଁ ପା଼ୟିନେରି, ଏ଼ୱାସି ନୀହାଁୟି ପାଙ୍ଗାତା ଡଣ୍ତ ବେଟା ଆ଼ନେସି ।’” ");
INSERT INTO kxv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ତାମି ତାୟି ଲାକ କ଼ପାଆ଼ନେସି, ଏ଼ୱାସି ନୀହାଁୟି ପିଣ୍ତାତା ଡଣ୍ତ ବେଟା ଆ଼ନେସି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ତାମି ତାୟିଇଁ କାର୍‌ବିଗାଟାତି ଇଞ୍ଜିଁ ଇନେସି, ଏ଼ୱାସି ବେ଼ରଣିମାଣ୍ତାତା ଡଣ୍ତ ବେଟା ଆ଼ନେସି; ଅ଼ଡ଼େ ଆମ୍ବାଆସି ପ଼ଲ୍‌ଆଗାଟାତି ଇଞ୍ଜିଁ ଇନେସି, ଏ଼ୱାସି ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେତ୍‌ପି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଅ଼ଡ଼େ ମାହାପୂରୁତି ପୂଜା ପିଣ୍ତାତା ଦା଼ନା ତାଚିମାନାଟି ମୀ ତାୟି କ଼ପାଟି ଏ଼ନି ହା଼ଡା ମାନେ ଇଞ୍ଜିଁ ଏମ୍ବାଆଁ ଅଣ୍‌ପୁ ୱା଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ଆତିହିଁ ଏ଼ଦିଏମ୍ବାଆଁ ପୂଜା ପିଣ୍ତାତା ମୀ ଦା଼ନା ପିସାନା ହାଜୁ, ଇଞ୍ଜାଁ ମୀ ତାୟିତଲେ ଆଣ୍ଡିତି ଜେ଼ଚ ୱେଣ୍ଡା ୱା଼ହାନା ମାହାପୂରୁ ନ଼କିତା ଏ଼ ଦା଼ନା ହେର୍‌ପାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ନୀନୁ ଗଡ଼୍‌ହା ଆ଼ତାଣି ତଲେ ନୀହାଁୟି କିନାଣି ତା଼ଣା ହାନିବେ଼ଲାତା ଜିରୁତେଏ କା଼ଲ୍‌ୱି ଆୟାଲି ଅଣ୍‌ପାମୁ, ଆ଼ଆତିଁ ଏ଼ୱାସି ନିଙ୍ଗେ ନୀହାଁୟି କିନାଣି ତା଼ଣା ହେର୍‌ପାନେସି, ଅ଼ଡ଼େ ନୀହାଁୟି କିନାସି ନିଙ୍ଗେ ଜାମାନାଙ୍ଗା କେୟୁତା ହେର୍‌ପାନେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି କା଼ୟିଦି ଇଲୁତା ସୁଣ୍ତାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ମୀ ତାକି କିୱିଆ଼ହାମାନି ର଼ କା଼ନି ଜିକେଏ ହୀଆପାତାକା ଏମ୍ବାଟି ଏ଼ନିଜିକେଏ ହ଼ଚାୱା଼ହାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ମୀରୁ ୱେଞ୍ଜାମାଞ୍ଜେରି, ଇଲେଇଞ୍ଜିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଦା଼ରିକାମା କିଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ର଼ ଇୟାନି ଲାଗେଏତି ଅଣ୍‌ପୁ ତଲେ ସିନିକିନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ଦାନିତଲେ ମ଼ନ ମ଼ନତା ଦା଼ରିକାମା କିତେସିଏ । ");
INSERT INTO kxv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଅ଼ଡ଼େ ମୀ ଟିଃନି କାନୁ ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ ଇଚିହିଁ ଏ଼ କାନୁ ଡ଼େୱା କୁତାଦୁ, ଇଚିହିଁ ମୀ ବାରେ ଆଙ୍ଗା ନର୍କତା ରିନି କିହାଁ, ଆଙ୍ଗାତି ର଼ ବା଼ଗା ହିଲାଆଗାଟାଇ ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଇଞ୍ଜାଁ ମୀ ଟିଃନି କେୟୁ ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ ଇଚିହିଁ ଏ଼ଦାଆଁ ଜା଼ଚାନା କୁତାଦୁ, ଇଚିହିଁ ମୀ ବାରେ ଆଙ୍ଗା ନର୍କତା ରିନିବାଟା ଆଙ୍ଗାତି ର଼ କେୟୁ ହିଲାଆଗାଟାୟି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ଅ଼ଡ଼େ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଆମ୍ବାଆସି ତାନି ଡକ୍ରିନି ପିହ୍‌ନେସି, ଇଚିହିଁ ଏ଼ୱାସି ଏ଼ଦାନାକି ପିହ୍‌ନି ଆ଼କୁ ରା଼ଚାନା ହୀପେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ତାନି ଡକ୍ରିନି ଦା଼ରି କାମାତି ଦ଼ହ ହିଲାଆନା ଡକ୍ରିନି ପିହ୍‌ନେସି, ଏ଼ୱାସି ଏ଼ଦାନି ଦା଼ରେଣି କିନେସି; ଅ଼ଡ଼େ ଆମ୍ବାଆସି ପିସ୍ତି ଇୟାନି ବୀହା ଆ଼ନେସି, ଏ଼ୱାସି ଜିକେଏ ଦା଼ରେଲା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ଅ଼ଡ଼େ ମୀରୁ ୱେଞ୍ଜାମାଞ୍ଜେରି, ତଲିକା଼ଲାତି ଲ଼କୁଣି ୱେସ୍‌ପି ଆ଼ହିମାଚେ, ମୀରୁ ମିଚି ପାର୍‌ମାଣା କିଆଦୁ, ସାମା ପାର୍‌ମାଣା କିହାମାନାଣି ଡିକ୍‌ଆନି, ମାହାପୂରୁ ନ଼କିତା ପୂରା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ ପାର୍‌ମାଣା କିୱୁଏ କିଆଦୁ; ପାର୍‌ମାଣା କିନି ବେ଼ଲା ଲାକପୂରୁତି ଦ଼ରୁତଲେ ପାର୍‌ମାଣା କିଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ଦି ମାହାପୂରୁତି ସିଂଗାସାଣି; ");
INSERT INTO kxv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ଅ଼ଡ଼େ ଦାର୍‌ତିତି ଦ଼ରୁତଲେ ପାର୍‌ମାଣା କିଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ଦି ମାହାପୂରୁତି କଡାୟାଁ ଇଟିନି ଟା଼ୟୁ; ଜିରୁସାଲମ ଦ଼ରୁତଲେ ପାର୍‌ମାଣା କିଆଦୁ, ଏ଼ଦି ଆ଼ହିମାନେ କାଜା ରାଜାତି ଗା଼ଡ଼ା; ");
INSERT INTO kxv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ଇଞ୍ଜାଁ ମୀ ତା଼ର୍ୟୁଁତି ପାର୍‌ମାଣା କିଆଦୁ, ଇଚିହିଁ ମୀ ତା଼ର୍ୟୁଁତି ର଼ ବା଼ଣା କା଼ଡ଼ିୟା ଆ଼ଆତିଁ ଦବ୍‌ଲା କିହାଲିତାକି ମୀ ବା଼ଡ଼୍‌ୟୁ ହିଲେଏ, ");
INSERT INTO kxv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ସାମା ମୀଦି ହାଅ ଇନି କାତା ହାଅ ଆ଼ପେ, ଇଞ୍ଜାଁ ଆ଼ଏ ଇନି କାତା ଆ଼ଏ ଆ଼ପେ; ଈଦାଆଁ ପିସ୍‌ପେ ଏ଼ନାଆଁ ଇଚାଣି ଆଗାଡ଼ା କାଲ୍‌ହିହିଁ ଏ଼ଦି ଲାଗେଏ ତା଼ଣାଟି ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ମୀରୁ ଈ କାତା ୱେଞ୍ଜାମାଞ୍ଜେରି, ରା଼ସ୍‌କି ଆ଼ହାମାନେ, କାନୁତି ବାଦୁଲି କାନୁ, ପାଲୁତି ବାଦୁଲି ପାଲୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମିଙ୍ଗେ ଲାଗେଏ କିୟାନାଣାଇଁ ବାଦୁଲି ଅ଼ଆଦୁ, ସାମା ଆମ୍ବାଆସି ନୀ ଟିଃନି ଗେଏଲାତା ସା଼ପ୍‌ଡ଼ା ୱେ଼ତାନେସି, ଏ଼ୱାଣାକି ଅ଼ର ଗେଏଲା ଜିକେଏ ତ଼ହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ନୀହାଁୟି ପାଙ୍ଗାତା ମୀ ସକା ଅ଼ହାଲି ମ଼ନ କିତିହିଁ ଏ଼ୱାଣାକି ମୀ ହିମ୍ବରି ଜିକେଏ ହୀଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଆମିନି ଦେ଼ସା ସା଼ଲୱି କିନାସି ମିଙ୍ଗେ ବ଼ଜୁ ଡେ଼କାନା ତାନିତଲେ ର଼ କିଲମିଟର ହାଜାଲିତାକି ଏଲେଇଞ୍ଜାନେସି, ଏ଼ୱାଣିତଲେ ରୀ କିଲମିଟର ହାଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଆମ୍ବାଆସି ମିଙ୍ଗେ ରୀସ୍ତାନେସି, ଏ଼ୱାଣାକି ହୀଦୁ, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ମୀ ତା଼ଣାଟି ରୀଣା ଅ଼ହାଲି ମ଼ନ କିନେସି ଏ଼ୱାଣାଇଁ ଆ଼ଏ ଇନାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ମୀରୁ ୱେଞ୍ଜାମାଞ୍ଜେରି, ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ମୀ ପା଼ଡ଼ିତାଣାଇଁ ଜୀୱୁନ଼ଦୁ ଇଞ୍ଜାଁ ସାତ୍ରୁୟାଁଣି ଅ଼ପାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀ ସାତ୍ରୁୟାଁଇଁ ଜୀୱୁନ଼ଦୁ, ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ମିଙ୍ଗେ ନିନ୍ଦା କିୟାନେରି, ଏ଼ୱାରି ତାକି ପ୍ରା଼ତାନା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଏ଼ନିକିଁ ମୀରୁ ମୀ ଲାକପୂରୁ ଆ଼ବାତି ମୀର୍‌କା ଆ଼ଦେରି; ସାମା ମାହାପୂରୁ ନେହାଁରି ଅ଼ଡ଼େ ଲାଗେଏ ପ଼ଲେଏତି ବାରେ ଲ଼କୁତାକି ୱେ଼ଡ଼ା ଉଜେଡ଼ି ହୀନାସି ଅ଼ଡ଼େ ଦାର୍ମୁଗାଟାରି ଅ଼ଡ଼େ ଦାର୍ମୁ ହିଲାଆ ଗାଟାରାକି ଜିକେଏ ପିୟୁ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ମିଙ୍ଗେ ଜୀୱୁ ନ଼ୟାଁନେରି ଏ଼ ଲ଼କୁଇଁଦେଁ ଜୀୱୁ ନ଼ତିହିଁ ଏ଼ନାୟି ମେ଼ଡ଼ାଆୟାନେ ? ସିସ୍ତୁ ରୀହ୍‌ନାରି ଜିକେଏ ଏ଼ଦାଆଁ କିଅରିକି ? ");
INSERT INTO kxv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଅ଼ଡ଼େ ମୀରୁ ମୀ ତାୟିୟାଁଇଁ ଜହରା କିଦେରି, ଏମ୍ବାଟିଏ ଅ଼ଡ଼େ ଏ଼ନି କାମା କିଦେରି ? ଜୀହୁଦିଆ଼ଆତାରି ଜିକେଏ ଏ଼ଦାଆଁ କିଅରିକି ? ");
INSERT INTO kxv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ଏ଼ଦାଆଁତାକି ମୀ ଲାକପୂରୁତି ଆ଼ବା ଏ଼ନିକିଁ ବାରେକିହାଁ ନେହାଁସି ମୀରୁ ଜିକେଏ ଏଲେକିଁ ନେହିଁ ଆ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ଲ଼କୁ ମେସ୍ତାପେରିୱା ଇଞ୍ଜିଁ ଲ଼କୁ ନ଼କିତା ଦାର୍ମୁତି କାମା କିଆଦୁ, ଏ଼ଦାଆଁତାକି ମୀରୁ ଜାଗ୍ରାତା ଆ଼ଦୁ, ଆ଼ଆତିହିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ନ଼କିତା ମିଙ୍ଗେ ଦା଼ନା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ଏ଼ଦାଆଁତାକି ଦା଼ନା ହୀନାଟି କୁଟୁ ଗାଟାରିଲେହେଁ ଜାହାରା ନ଼କିତା ତୀତ୍ରି ଊକାଆଦୁ; ଏ଼ୱାରି ଲ଼କୁ ତା଼ଣାଟି ମା଼ନି ବେଟାଆ଼ହାଲି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଅ଼ଡ଼େ ମାଦି ଆଂଗେଣିତା ଏଲେକିନେରି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଏ଼ୱାରି ତାମି ଦା଼ନା ବେଟାଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ସାମା ମୀରୁ ଦା଼ନା ହୀନାଟି ମୀ ଟିଃନି କେୟୁ ଏ଼ନାଆଁ କିହିମାନେ ମୀ ଟେ଼ବ୍ରି କେୟୁ ପୁନାଆପେ, ");
INSERT INTO kxv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ଏ଼ନିକିଁ ମୀ ଦା଼ନା ହୀତାୟି ପୁନାଆରେ଼ଟୁ ଆ଼ନେ, ମୀ ଲାକପୂରୁତି ଆ଼ବା ଜିକେଏ ପୁନାଆରେ଼ଟୁ ମେହ୍‌ନାସି, ଏ଼ୱାସି ମିଙ୍ଗେ ଦା଼ନା ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ପ୍ରା଼ତାନା କିନାଟି କୁଟୁ ଗାଟାରିଲେହେଁ ଆ଼ଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ଲ଼କୁଣି ତ଼ସାଲି ତାକି, ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଅ଼ଡ଼େ ଡେ଼ଡ଼ା ଜିରୁତି କନତା ନିଚାନା ପ୍ରା଼ତାନା କିହାଲି ରା଼ହାଁ ଆ଼ନେରି; ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାରି ତାମି ଦା଼ନା ବେଟାଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ସାମା ମୀରୁ ପ୍ରା଼ତାନା କିନାଟି ମୀ ଇଲୁ ବିତ୍ରା ହାଜୁ, ଇଞ୍ଜାଁ ଦା଼ରା ସୁଣ୍ଡା କଡାଦୁ ଅ଼ଡ଼େ ତ଼ଞ୍ଜା ଆ଼ଆଗାଟି ମୀ ଆ଼ବା ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା କିଦୁ; ଅ଼ଡ଼େ ମୀ ଆ଼ବା ଆମ୍ବାଆସି ଡ଼ୁଗାନା ମେସ୍ତାନେସି ଏ଼ୱାସି ମିଙ୍ଗେ ଦା଼ନା ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ମୀରୁ ପ୍ରା଼ତାନା କିନାଟି ଜୀହୁଦିଆ଼ଆତାରି ଲେହେଁ ଉଜେ ଉଜେଏ ପେଚେପେଚେ ଜ଼ଲାଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ଅଣ୍‌ପିନେରି, ହା଼ରେକା ପ୍ରା଼ତାନା କିତିସାରେ ମା଼ ପ୍ରା଼ତାନା ମାହାପୂରୁ ୱେଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରିଲେହେଁ ଆ଼ଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମିଙ୍ଗେ ଏ଼ନାୟି ଲ଼ଡ଼ାମାନେ, ରୀହ୍‌ଆ ନ଼କେଏ ଏ଼ଦାଆଁ ମୀ ଆ଼ବା ମାହାପୂରୁ ବାରେ ପୁଞ୍ଜାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଅ଼ଡ଼େ ମୀରୁ ଇଲେକିହିଁ ପ୍ରା଼ତାନା କିଦୁ; ଏ଼ ମା଼ ଲାକପୂରୁତି ଆ଼ବା, ନୀ ଦ଼ରୁ ନେହାୟି ଇଞ୍ଜିଁ ମା଼ନୱି ଆ଼ପେ; ");
INSERT INTO kxv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ନୀ ରା଼ଜି ୱା଼ପେ; ଲାକପୂରୁତି ଲେହେଁ ଦାର୍‌ତିତା ଜିକେଏ ନୀ କାତେଏ ଆ଼ପେ, ");
INSERT INTO kxv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ନୀଞ୍ଜୁ ମାଙ୍ଗେ ଲ଼ଡ଼ା ଆ଼ନି ରା଼ନ୍ଦା ହିୟାମୁ, ");
INSERT INTO kxv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ମା଼ କ଼ପାତଲେ ଦ଼ହ କିହାମାନି ଲ଼କୁଣି ମା଼ମ୍ବୁ ଏ଼ନିକିହିଁ ଦ଼ହ ଆହ୍‌ଅମି, ଏଲେକିହିଁ ମା଼ ଦ଼ହ ବାରେ ମ୍ଣେକ୍‌ହାମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ମାଙ୍ଗେ ପା଼ନ୍ଦାତା ମେତ୍‌ହାଆନି ଲାଗେଏ ପ଼ଲେଏ ତା଼ଣାଟି ପିସ୍‌ପି କିୟାମୁ, ଏ଼ନିଇଚିହିଁ ରା଼ଜି ବା଼ଡ଼୍‌ୟୁ କାଜାପା଼ଣା କା଼ଲା କା଼ଲାତାକି ନୀଦିଏ ଆ଼ପେ । ଆ଼ମେନ୍‌ । ");
INSERT INTO kxv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ଇଚିହିଁ ମୀରୁ ଏଟ୍‌କା ଲ଼କୁତି ପା଼ପୁ ବାରେ ମ୍ଣେକ୍‌ହିସାରେ, ମୀ ଲାକପୂରୁତି ଆ଼ବା ମାହାପୂରୁ ଜିକେଏ ମୀ ପା଼ପୁ ମ୍ଣେକ୍‌ହାନେସି; ");
INSERT INTO kxv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ସାମା ମୀରୁ ଲ଼କୁତି ପା଼ପୁ ମ୍ଣେକ୍‌ଆସାରେ, ମୀ ଆ଼ବା ଜିକେଏ ମୀ ପା଼ପୁ ମ୍ଣେକ୍‌ହଅସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ଉପାସା କିନାଟି କୁଟୁ ଗାଟାରିଲେହେଁ ମୀ ମୂମ୍ବୁତି ୱା଼ଡ଼ି କିଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ଉପାସା କିହିମାନେରି ଇଞ୍ଜିଁ ଲ଼କୁଣି ତ଼ସାଲି ତାମି ମୂମ୍ବୁ ୱା଼ଡ଼ି କିନେରି; ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଏ଼ୱାରି ତାମି ଦା଼ନା ବେଟାଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ସାମା ମୀରୁ ଉପାସା କିନାଟି, ମୀ ତା଼ର୍ୟୁଁତା ନିୟୁଁ ଉହ୍‌ଦୁ ଅ଼ଡ଼େ ମୂମ୍ବୁ ନର୍‌ହା କଡାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଏ଼ନିକିଁ ମୀରୁ ଉପାସା କିହିମାନେରି ଇଞ୍ଜିଁ ଲ଼କୁ ନ଼କିତା ତ଼ଞ୍ଜା ଆ଼ଆନା, ପୁନାଆରେ଼ଟୁ ମାନି ମୀ ଲାକପୂରୁତି ଆ଼ବା ନ଼କିତା ତ଼ଞ୍ଜା ଆ଼ଦେରି; ଅ଼ଡ଼େ ମୀ ଆ଼ବା ପୁନାଆରେ଼ଟୁ ମେସାନା ମିଙ୍ଗେ ଦା଼ନା ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ଏମ୍ବିୟା ସୀର୍‌ନେ ଇଞ୍ଜାଁ ଲୀମ୍ବୁ ତିନେ ଅ଼ଡ଼େ ସ଼ର୍‌କା କାତି ତୂକ୍‌ହାନା ସ଼ରୁ କିହା ଅ଼ନେରି, ଇଲେତି ଦାର୍‌ତିତା ମିଙ୍ଗେତାକି ଦ଼ନ କୂଡ଼ିକିହାଁ ଇଟାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ସାମା ଆମ୍ବିୟା ସୀର୍‌ଏ ଇଞ୍ଜାଁ ଲୀମ୍ବୁ ତିନେଏ ଅ଼ଡ଼େ ସ଼ର୍‌କା କାତି ତୂକ୍‌ହାନା ମା଼ଣ୍‌ଚା ଅ଼ଅରି ଇଲେତି ଲାକପୂରୁ ମିଙ୍ଗେତାକି ଦ଼ନ କୂଡ଼ି କିଦୁ, ");
INSERT INTO kxv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଇଚିହିଁ ଆମ୍ବିୟା ମୀ ଦ଼ନ ଏମ୍ବେଏ ମୀ ମ଼ନ ଜିକେଏ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","କାନୁ ଆଙ୍ଗାତି ଦୀୱଁ ଲେହେଁ, ଇଚିହିଁ ମୀ କାନୁ ନେହିଁ ମାନେ, ଆତିହିଁ ମୀ ବାରେ ଆଙ୍ଗା ଉଜେଡ଼ି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ସାମା ମୀ କାନୁ ଲାଗେଏ ମାନେ, ଆତିହିଁ ମୀ ବାରେ ଆଙ୍ଗା ଜିକେଏ ଆନ୍ଦେରି ଆ଼ନେ । ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀ ଆଙ୍ଗାତି ଉଜେଡ଼ି ଆନ୍ଦେରି ଆତିହିଁ ଏ଼ ଆନ୍ଦେରି ଏଚେକା ଆଜିନାୟି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ଆମ୍ବାଆସି ଜିକେଏ ରୀ ସା଼ୱୁକାରି ତା଼ଣା ହ଼ଲେଏସି ଆ଼ହାଲି ଆ଼ଡଅସି; ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାସି ରଅଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଅ଼ଡ଼େ ରଅଣାଇଁ ଅ଼ପଅସି, ରଅଣାଇଁ ମା଼ନି କିନେସି ଅ଼ଡ଼େ ରଅଣାଇଁ ମା଼ନୱି ଆ଼ଅସି, ମୀରୁ ମାହାପୂରୁ ଅ଼ଡ଼େ ଦ଼ନତି ହ଼ଲିୟାଙ୍ଗା ଆ଼ହାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ନାଆଁ ତିନାୟି ଏ଼ନାଆଁ ଗହନାୟି, ଏଲେକିଁ ମୀ ଜୀୱୁତାକି, ଏ଼ନାଆଁ ତୁର୍‌ନାୟି ଇଲେକିଁ ମୀ ଆଙ୍ଗା ତାକି ଅଣ୍‌ପାଆଦୁ, ରା଼ନ୍ଦାକିହା ଜୀୱୁ, ହିମ୍ବରିକା କିହାଁ ଆଙ୍ଗା କାଜାୟି ଆ଼ଏକି ? ");
INSERT INTO kxv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ପଟାୟାଁଣି ସିନିକିଦୁ, ଏ଼ୱି ମାଟାଉ କି ଦା଼ଉ କି ଗା଼ଦେୟିତା କୂଡ଼ିକିହାଁ ଇଟାଉ, ଏଲେଆ଼ତିୱା ଲାକପୂରୁତି ଆ଼ବା ଏ଼ୱାସିକାକି ତାମି ରା଼ନ୍ଦା ହୀହିମାନେସି, ଏ଼ୱାସିକା କିହାଁ ମୀରୁ କାଜାତେରି ଆ଼ଏକି ? ");
INSERT INTO kxv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଅ଼ଡ଼େ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ତାନି ଗାଡି ଅଣ୍‌ପୁ ତଲେ ତାନି ଜୀୱୁତି ଆଗାଡ଼ା ପାଡିକିହାଲି ଆ଼ଡିମାନେସି ? ");
INSERT INTO kxv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ହିମ୍ବରିକା ତାକି ଏ଼ନାଆଁତାକି ଅଣ୍‌ପିମାଞ୍ଜେରି ? ଜା଼ଡ଼ାତି ପୂଙ୍ଗାଣି ସିନିକିହାଁ ଅଣ୍‌ପାନା ଜା଼ପାଦୁ, ଏ଼ୱି ଏ଼ନିକିଁ ପାଡାଆ଼ନୁ; ଏ଼ୱି କସ୍ତ କିଉ କି ଲୂଲୁ ଦା଼ଉ, ");
INSERT INTO kxv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ଆ଼ତିଜିକେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ରାଜା ସଲମନ ଗାଡି ଦାରାତି ହିମ୍ବରିକା ହୁଚିମାଚିହିଁ ଜିକେଏ ଏ଼ ପୂଙ୍ଗା ବିତ୍ରାଟି ର଼ ପୂୟୁ ଲେହେଁ ଅ଼ଜା ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ସାମା ଗୁଡିୟାତା ଡ଼ୟିନି ଗାର୍କି ଜା଼ଡ଼ା ନୀଞ୍ଜୁ ମାନେ ୱିଏ ହଲୁତା ହୂଡ୍‌କିଆ଼ନେ, ଏ଼ଦାନାକି ମାହାପୂରୁ ଇଚେକା ନେହିଁ ଅ଼ଜୁ ହୀତିହିଁ, ଏ଼ ନାମୁ ହିଲାଆଗାଟାତେରି ମିଙ୍ଗେ ହା଼ରେକା ଗାଡି ହିମ୍ବରିକା ହିୟଅସିକି ? ");
INSERT INTO kxv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ଏ଼ଦାଆଁତାକି ଏ଼ନାଆଁ ତିନମି, ଏ଼ନାଆଁ ଗହ୍‌ନମି, ଏ଼ନାଆଁ ପର୍‌ନମି ଏଲେକିହିଁ ଅଣ୍‌ପାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଇଚିହିଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ଈ ବାରେ ପାରିନେରି, ଅ଼ଡ଼େ ଈ ବାରେ ମିଙ୍ଗେ ଲ଼ଡ଼ାମାନେ ଇଞ୍ଜିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ପୁଞ୍ଜାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ସାମା ମୀରୁ ନ଼କେଏ ମାହାପୂରୁତି ରା଼ଜି ଅ଼ଡ଼େ ଦାର୍ମୁତି ପାରାଦୁ, ଆତିହିଁ ମୀ ଲ଼ଡ଼ାମାନି ବାରେ ହୀପ୍‌କିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଇଚିହିଁ ୱିଏତାକି ଅଣ୍‌ପାଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ୱିଏତି ଅଣ୍‌ପୁ ୱିଏ ମୀରୁ ମିଙ୍ଗେତାକି ଅଣ୍‌ପିଦେରି, ଇଚିହିଁ ନୀଞ୍ଜୁତି କସ୍ତ ନୀଞ୍ଜୁତାକି ସା଼ରି । ");
INSERT INTO kxv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ମୀରୁ ଏ଼ନିକିଁ ନୀହାଁୟି କିୱି ଆ଼ଅତେରି, ଏ଼ଦାଆଁତାକି ମୀରୁ ଆମ୍ବାଆରାଇଁ ନୀହାଁୟି କିଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଇଚିହିଁ ମୀରୁ ଏ଼ନିକିଁ ଲ଼କୁଣି ନୀହାଁୟି କିଦେରି, ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ନୀହାଁୟି କିୱିଆ଼ଦେରି; ଅ଼ଡ଼େ ଆମିନି ମା଼ଣାତଲେ ଲା଼ଚିଦେରି ଏ଼ ମା଼ଣା ତଲେ ମିଙ୍ଗେ ଲା଼ଚା ହିୟାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ଅ଼ଡ଼େ ଏ଼ନାଆଁତାକି ମୀ ତାୟି କାନୁତି ଲାଟା ସିନିକିହିମାଞ୍ଜି, ସାମା ନୀ କାନୁତା ଆମିନି କାଜା ଲାଟା ମାନେ, ଏ଼ଦାଆଁ ଅଣ୍‌ପି ହିଲଅତି କି ? ");
INSERT INTO kxv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ଅ଼ଡ଼େ ନୀନୁ ଏ଼ନିକିଁ ମୀ ତାୟିଇଁ ଏଲେଇଞ୍ଜି ୱା଼ମୁ, ନୀ କାନୁତି ଲାଟା ଡ଼େୱାଇଁ, ଅ଼ଡ଼େ ମେହ୍‌ମୁ ନୀ କାନୁତେଏ କାଜା ଲାଟା ମାନେ ! ");
INSERT INTO kxv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ଆଡ଼େ କୁଟୁ ଗାଟାତି ତଲିଏ ନୀ କାନୁତି ଲାଟା ଡ଼େୱା କଡାମୁ, ଆତିହିଁ ମୀ ତାୟି କାନୁତି ଲାଟା ଡ଼େୱାଲି ନେହିଁକିଁ ମେସାଲି ଆ଼ଡିଦି । ");
INSERT INTO kxv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ନେହିଁ ଆ଼ସ୍ତିତି ନେସ୍‌କାକି ହୀଆଦୁ, ଏ଼ୱି ୱେଣ୍ତେ ତିର୍‌ୱାହାଁ କାଚାନୁ ଇଞ୍ଜାଁ ବାଂଗାରା କିହାଁ ଆଗାଡ଼ା ଦାରାଗାଟି ହୀଙ୍ଗା ପାଜିୟାଁ ନ଼କିତା ମେତ୍‌ଆଦୁ, ଏ଼ୱି ଏ଼ଦାନି କା଼ଦତା ତୁଡ଼୍‌ବିନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ରୀହ୍‌ଦୁ ଆତିହିଁ ମିଙ୍ଗେ ହୀପ୍‌କିଆ଼ନେ; ପାରାଦୁ ଆତିହିଁ ମିଙ୍ଗେ ମେ଼ଡ଼ାଆୟାନେ; ଦୁୱେରିତା ୱେ଼ଦୁ, ଏଚେଟିଏ ମିଙ୍ଗେତାକି ଦୁୱେରି ଦେପିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଇଚିହିଁ ଆମ୍ବାଆସି ରୀହ୍‌ନେସି, ଏ଼ୱାସି ବେଟାଆ଼ନେସି; ଆମ୍ବାଆସି ପାରିନେସି, ଏ଼ୱାସି ମେଡ଼ାଆ଼ନେସି; ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଦୁୱେରିତା ୱେ଼ନେସି ଏ଼ୱାଣାକି ଦା଼ରା ଦେପିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ଇଚିହିଁ ମୀ ବିତ୍ରା ଆମ୍ବାଆସି ଇଲେତି ମାଣ୍‌ସି ମାନେସି, ତାନି ମୀର୍‌ଏସି ରୂଟି ରୀସ୍ତିସାରେ ଏ଼ୱାଣାକି ୱାଲ୍‌କା ହୀନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ଅ଼ଡ଼େ ମୀନୁ ରୀସ୍ତିସାରେ ଏ଼ୱାଣାକି ରା଼ଚୁ ହୀନେସି ? ");
INSERT INTO kxv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ଏ଼ଦାଆଁତାକି ମୀରୁ ଲାଗେଏ ପ଼ଲେଏତି ଲ଼କୁ ଆ଼ତିଜିକେଏ ମୀ ମୀର୍‌କା ମା଼ସ୍‌କାକି ନେହାଁଣି ହୀହିମାଞ୍ଜେରି, ଆତିହିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ନ଼କିତା ରୀହ୍‌ନି ଲ଼କୁକି ଏଚେକା ନେହା ନେହାଁଣି ହୀଅସି !” ");
INSERT INTO kxv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ଏ଼ଦାଆଁତାକି ଲ଼କୁ ମିଙ୍ଗେ ତାକି ଏ଼ନିକିଁ ଲେ଼ମ୍ବାପେରି ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି, ମୀରୁ ଜିକେଏ ଏ଼ୱାରାଇଁ ଏଲେକିହିଁ କିଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଈଦିଏ ମ଼ସାତି ମେ଼ରା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଦାର୍ମୁ ପତିତି କାତା ।” ");
INSERT INTO kxv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ଜାକ୍‌ଣି ଦୁୱେରିଟି ହାଜୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନର୍କତା ହାନି ଜିରୁ ଅ଼ସାରା ଅ଼ଡ଼େ ଊସାସା, ଏ଼ ଜିରୁ ନା଼ସା ଆ଼ନିୱାକି ଅ଼ନାୟି, ଏ଼ ଜିରୁଟି ହା଼ରେକା ଲ଼କୁ ହାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ଅ଼ଡ଼େ ଜୀୱୁତା ଅ଼ନି ଦୁୱେରି ଜାକ୍‌ଣି ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ହାନି ଜିରୁ କସ୍ତଗାଟାୟି ଏ଼ ଜିରୁଟି ହାନି ଲ଼କୁ ହା଼ରେକା ଊଣା । ");
INSERT INTO kxv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାତମି ଇଞ୍ଜିଁ ୱେସାନା ମିଚି କାତା ୱେହ୍‌ନାରି ତା଼ଣାଟି ଜାଗ୍ରାତା; ଏ଼ୱାରି ମେ଼ଣ୍ତାୟାଁ ୱା଼ଣା ଆସାନା ମୀ ତା଼ଣା ୱା଼ନେରି, ସାମା ଏ଼ୱାରି ହିୟାଁତା କାର୍‌ବି ଆ଼ତି କ୍ଡାଃନି ! ");
INSERT INTO kxv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ଏ଼ୱାରି କାମା ମେସାନା ମୀରୁ ଏ଼ୱାରାଇଁ ପୁଞ୍ଜାଲି ଆ଼ଡିଦେରି, ଲ଼କୁ ହା଼ପ୍‌କା ମା଼ର୍‌ନୁତା ଅଙ୍ଗୁରି ପା଼ଡ଼େୟି ଆ଼ଆତିହିଁ ଅଣ୍‌ଙ୍ଗ ମା଼ର୍‌ନୁତା ତ଼ୟା ପା଼ଡ଼େୟି ଏହ୍‌ନେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ଏଲେକିହିଁଏ ନେହିଁ ମା଼ର୍‌ନୁତା ବାରେ ନେହିଁ ପା଼ଡ଼େୟି ଅ଼ଡ଼େ ଲାଗେଏତି ମା଼ର୍‌ନୁତା ବାରେ ଲାଗେଏତି ପା଼ଡ଼େୟି ଆ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ନେହିଁ ମା଼ର୍‌ନୁ ଲାଗେଏତି ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡେଏ, ଅ଼ଡ଼େ ଲାଗେଏତି ମା଼ର୍‌ନୁ ନେହିଁ ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଆମିନି ମା଼ର୍‌ନୁ ନେହିଁ ପା଼ଡ଼େୟି ଆ଼ୟେଏ, ଏ଼ଦାନି ଟୂଣ୍‌ୱି ଆ଼ହାନା ହିଚୁତା ମେତ୍‌ପି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଏଲେକିହିଁଏ ମିଚି ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ତାମା କାମା ତଲେ ପୁଞ୍ଜାଲି ଆ଼ଡିନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ନାଙ୍ଗେ ‘ପ୍ରବୁ, ପ୍ରବୁ’ ଇଞ୍ଜିଁ ହା଼ଟାନେରି, ଏଲେତି ବାରେଜା଼ଣା ଲାକପୂରୁ ରା଼ଜିତା ହାଲଅରି, ସାମା ଆମ୍ବାଆରି ନା଼ ଲାକପୂରୁତି ଆ଼ବା ୱେସ୍ତି କାତା ମା଼ନୱି ଆ଼ନେରି, ଏ଼ୱାରି ହାଜାଲି ଆ଼ଡିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ଏ଼ ଦିନା ହା଼ରେକା ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାନେରି, ଏ଼ ପ୍ରବୁ ଏ଼ ପ୍ରବୁ ମା଼ମ୍ବୁ ନୀ ଦ଼ରୁତଲେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ଆତମି କି ? ଅ଼ଡ଼େ ନୀ ଦ଼ରୁତଲେ ବୂତୁୟାଁଇଁ ପିସ୍‌ପି କିଆତମି କି ? ଅ଼ଡ଼େ ନୀ ଦ଼ରୁତଲେ ହା଼ରେକା କାବାଆ଼ନି କାମା କିଆତମି କି ? ");
INSERT INTO kxv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ଏଚିବେ଼ଲା ନା଼ନୁ ଏ଼ୱାରାଇଁ ତୀରେତଲେ ଏଲେଇଇଁ ‘ଏ଼ ଲାଗେଏ ପ଼ଲେଏ ଗାଟାତେରି, ନା଼ ତା଼ଣାଟି ହେକ ଆ଼ଦୁ, ନା଼ନୁ ମିଙ୍ଗେ ଏଚେଲାୱା ପୁଞ୍ଜାମାଞ୍ଜଅଁ ।’” ");
INSERT INTO kxv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଈ ନା଼ ହା଼ଡା ୱେନେସି ଅ଼ଡ଼େ ମା଼ନୱି ଆ଼ନେସି, ଏ଼ୱାସି ପା଼କା ୱାଲି ଲାକ ଇଲୁ କିନି ର଼ ବୁଦିଗାଟି ଲ଼କୁ ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଗାଡି ପିୟୁ ରୀତେ ୱା଼ରୁ ୱା଼ତେ ଅ଼ଡ଼େ ଗା଼ଲି ଆ଼ତେ, ଏ଼ ଇଲୁତି ଗୁପିତେ, ସାମା ଏ଼ ଇଲୁ ରିଆତେ, ଇଚିହିଁ ଏ଼ଦି ପା଼କାତା କାନ୍ଦା କା଼ର୍‌ହାନା ପୁନାଦି ଦସାମାଚାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଈ ନା଼ ହା଼ଡା ୱେଞ୍ଜାନା ମା଼ନୱି ଆ଼ଅସି ଏ଼ୱାସି ବାଃଲି ଲାକ ଇଲୁ କେ଼ପା ଡ଼ୟିନି ବୁଦି ହିଲାଆଗାଟି ଲ଼କୁ ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଗାଡି ପିୟୁ ରୀତେ, ୱା଼ରୁ ୱା଼ତେ ଅ଼ଡ଼େ ଗା଼ଲି ଆ଼ତେ, ଏ଼ ଇଲୁତି ଗୁପିତେ ଏମ୍ବାଟିଏ ଇଲୁ ତର୍‌ଗାହାଜା ବୂମିତା ଆଣ୍ତିତେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଜୀସୁ ଈ ବାରେ କାତା ରା଼ପ୍‌ହି ଜେ଼ଚ ତାନି କାତା ୱେଚାରି କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଇଚିହିଁ ଏ଼ୱାସି ତାମି ବୁଦି ଗାଟାରିଲେହେଁ ଜା଼ପ୍‌ଆନା ଅଦିକାରା ବେଟାଆ଼ହାମାନି ମାଣ୍‌ସିଲେହେଁ ଜା଼ପ୍‌ହି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜୀସୁ ହ଼ରୁ ଲାକଟି ରେ଼ଚା ୱା଼ତି ଡା଼ୟୁ ମାନ୍ଦା ଲ଼କୁ ତାନି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଏଚିବେ଼ଲା ର଼ କାଜା ର଼ଗ ଗାଟାସି ତାନି ନ଼କିତା ୱା଼ହାଁ ମେଣ୍ତାକୁତାନା ଜହରା କିହାଁ ଏଲେଇଚେସି, “ପ୍ରବୁ ନୀନୁ ମ଼ନ କିତିହିଁ ନାଙ୍ଗେ ନେହିଁ କିହାଲି ଆ଼ଡାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ଏଚେଟିଏ ଜୀସୁ କେୟୁ ଦା଼ସାହାଁ ତାଙ୍ଗ ଡୀଗାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମ଼ନ କିହିମାଇଁ ନୀନୁ ନେହିଁଆ଼ମୁ ।” ଏ଼ ଦେବୁଣିଏ କାଜା ର଼ଗ ଗାଟାସି ନେହିଁଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଜାଗ୍ରାତା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆନି, ସାମା ନୀନୁ କାଜା ପୂଜେରା ତା଼ଣା ହାଜାନା ନିଙ୍ଗ ତ଼ସାକଡାମୁ, ଅ଼ଡ଼େ ମ଼ସା ଆମିନି ମେ଼ରା ହୀହାମାନେସି ଏ଼ଦାଆଁ ଲ଼କୁ ନ଼କିତା ସା଼କି ହୀନିଲେହେଁ ହେର୍‌ପାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜୀସୁ କପର୍‌ନାହୁମ ଗା଼ଡ଼ାତା ହାଜାଲିଏ ର଼ ରମିୟ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ବାତିମା଼ଲିହିଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଏ଼ ପ୍ରବୁ, ନା଼ ହ଼ଲେଏସି ଟଟୱା଼ୟାନା ହା଼ରେକା କସ୍ତ ଆ଼ହିଁ ଇଜ କାଟେଲିତା ଡୂରାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ନେହିଁ କିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ସାମା ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏଲେଇଚେସି, “ଆ଼ଏ, ପ୍ରବୁ ନୀନୁ ନା଼ ଇଜ ପା଼ୱୁଲି ଇଟିଦି, ଏଲେତି ଜ଼ଗେ ଆ଼ଏ; ସାମା ନୀନୁ ର଼ ପଦୁ ୱେସା ପାଣ୍ତାମୁ, ନା଼ ହ଼ଲେଏସି ନେହିଁ ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ଇଚିହିଁ ନା଼ନୁ ରଅଣି ତା଼ଣା କାମା କିନି ମାଣ୍‌ସି ଆ଼ତିହିଁ ଜିକେଏ ନା଼ ଅଦିକାରାତା ଅ଼ଡ଼େ କ଼ସ୍‌କା ମାନେରି; ନା଼ନୁ ରଅଣାଇଁ ହାଲାମୁ ଇଚିହିଁ ଏ଼ୱାସି ହାନେସି; ଅ଼ଡ଼େ ରଅଣାଇଁ ୱା଼ମୁ ଇଚିହିଁ ୱା଼ନେସି; ଅ଼ଡ଼େ ନା଼ ହ଼ଲେଏଣାଇଁ ଈଦାଆଁ କିମୁ ଇଚିହିଁ ଏ଼ଦାଆଁ କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜୀସୁ ଈ ବାରେ କାତା ୱେଞ୍ଜାନା କାବା ଆ଼ତେସି,ଅ଼ଡ଼େ ତାନି ଜେ଼ଚ ୱା଼ହିମାଚି ଲ଼କୁଣି ଏଲେଇଚେସି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଇସ୍ରାୟେଲ ବିତ୍ରା ଆମ୍ବାଆରି ତା଼ଣା ଇଚେକା କାଜା ନାମୁ ମେସାହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ସାମା ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ହା଼ରେକା ଲ଼କୁ ୱେ଼ଡ଼ା ହ଼ପୁ ୱାକିଟି ଅ଼ଡ଼େ ୱେ଼ଡ଼ା କୂଡ଼୍‌ନି ୱାକିଟି ୱା଼ହାନା ଅବ୍ରାହାମ, ଇସାହାକ ଅ଼ଡ଼େ ଜାକୁବ ତଲେ ଲାକପୂରୁ ରା଼ଜିତା ତିଞ୍ଜାଲି କୁଗିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ସାମା ରା଼ଜିତି ମୀର୍‌କାଣି ପାଙ୍ଗାତି ଆନ୍ଦେରିତା ମେତ୍‌ପି ଆ଼ନେ ଏମ୍ବାଆଁ ଏ଼ୱାରି ପାଲ୍‌କା ଟୀଟି କିହିଁ ଡ଼ୀନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ କାଜାଣାଇଁ ଏଲେଇଚେସି, ଇଜ ହାଲାମୁ, ଏ଼ନିକିହିଁ ନାମାମାଞ୍ଜି ନିଙ୍ଗେତାକି ଏଲେକିହିଁ ଆ଼ପେ । ଏ଼ ଦେବୁଣିଏ ଏ଼ ହ଼ଲେଏସି ନେହିଁଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଡା଼ୟୁ ଜୀସୁ ପିତର ଇଜ ୱା଼ହାନା ପିତରତି ପ଼ୟା ନ଼ମେରି ତାକି କାଟେଲିତା ଡୂରାମାନାଣି ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ଏଚେଟିଏ ଜୀସୁ ତାନି କେୟୁ ଡୀଗାଲିଏ ନ଼ମେରି ପିସ୍ତେ, ଅ଼ଡ଼େ ନିଙ୍ଗାନା ଏ଼ୱାଣି ସେ଼ବା କିହାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ଲ଼କୁ ହା଼ରେକା ବୂତୁ ଆଲ୍‌ଗାମାଚି ଲ଼କୁଣି ଜୀସୁ ତା଼ଣା ତାତେରି, ଏଚେଟିଏ ଜୀସୁତି ର଼ ବ଼ଲୁ ତାକି ବୂତୁୟାଁ ଏ଼ୱାରି ତା଼ଣାଟି ହ଼ଚାହାଚୁ, ଅ଼ଡ଼େ ହା଼ରେକା ନ଼ମେରି ଗାଟାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଏ଼ନିକିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି କାତା ସାତା ଆ଼ନେ, “ଏ଼ୱାସି ତା଼ନୁଏ ମା଼ ନ଼ମେରି ଦୁକା ଅ଼ତେସି ଅ଼ଡ଼େ ମା଼ ର଼ଗତି ଡେ଼କିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଜୀସୁ ତାନି ସା଼ରିୱାକି ଲ଼କୁଣି ମେସାନା, ସୀସୁୟାଁଇଁ ସାମ୍‌ଦୁରି ଆତାଲା ହାଜାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ର଼ ମେ଼ରା ଜା଼ପ୍‌ନାସି ୱା଼ହାନା ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଗୂରୁ, ନୀନୁ ଆମ୍ବିୟା ହାଜି, ନା଼ନୁ ଜିକେଏ ନୀ ତଲେ ୱା଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନାକାୟାଁକି ଡ଼ୟିନି ପା଼ୱୁୟାଁ ମାନୁ, ହା଼ଗୁ ଲାକ ଊମ୍ବିନି ପଟାୟାଁକି ବାସାଟା଼ୟୁ ମାନେ, ସାମା ମାଣ୍‌ସି ମୀର୍‌ଏଣାକି ତା଼ର୍ୟୁଁ ନେଟ୍‌ହାଲି ବାସାଟା଼ୟୁ ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଇଞ୍ଜାଁ ସୀସୁୟାଁ ବିତ୍ରାଟି ଅ଼ଡ଼େ ରଅସି ଜୀସୁଇଁ ଏଲେଇଚେସି “ପ୍ରବୁ, ନ଼କେଏ ହାଜାନା ନା଼ ଆ଼ବାଇଁ ମାହ୍‌ଣିଣା ମୁସାଲି ହେଲ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ, ହା଼ତାରାଇଁ ତାମି ହା଼ତି ଲ଼କୁଣି ମୁସାଲି ପିହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଜୀସୁ ଡଂଗତା ହ଼ଚାଲିଏ ସୀସୁୟାଁ ତାନି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଦେବୁଣିଏ ସାମ୍‌ଦୁରିତା କାଜା ଗା଼ଲି ଆ଼ତେ, ଇଞ୍ଜାଁ ଡଂଗ ଏ଼ୟୁତା ମୁଞ୍ଜାଲି ମା଼ଟ୍‌ହେ, ସାମା ଜୀସୁ ଡଂଗତା ଡୂରାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଡାଗେ ୱା଼ହାଁ ନିକ୍‌ହାନା ଏଲେଇଚେରି, “ପ୍ରବୁ, ମାଙ୍ଗ ଗେଲ୍‌ପାମୁ, ଆ଼ଆତିଁ ମା଼ମ୍ବୁ ହା଼ହିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଊଣା ନାମୁ ଗାଟାତେରି, ଏ଼ନାଆଁତାକି ଇଚେକା ଆଜିମାଞ୍ଜେରି ?” ଏମ୍ବାଟିଏ ଜୀସୁ ନିଙ୍ଗାନା ଗା଼ଲି ଅ଼ଡ଼େ ୱୀଡିମାଚି ସାମ୍‌ଦୁରିତି ଦାକା ହୀତେସି, ଇଞ୍ଜାଁ ଦେବୁଣିଏ ସାପିଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଏମ୍ବାଟିଏ ଏ଼ୱାରି କାବା ଆ଼ହାଁ ଏଲେଇଚେରି, “ଈୱାସି ଏ଼ନିଲେହେଁତି ମାଣ୍‌ସି ? ଗା଼ଲି ଅ଼ଡ଼େ ସାମ୍‌ଦୁରି ଜିକେଏ ଈୱାଣି ହା଼ଡା ମା଼ନୱି ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଡା଼ୟୁ ଜୀସୁ ସାମ୍‌ଦୁରି ଆତାଲାୱାକିତି ଗଦରିୟ ନା଼ସ୍‌କାଣାଁ ଏଗାହାଜାଲିଏ ରୀ ବୂତୁୟାଁ ଆଲ୍‌ଗା ମାଚାରି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଟି ୱା଼ହାନା ଜୀସୁ ବେଟାଆ଼ତେରି, ଏ଼ୱାରି ଇଲେତି ଆଜିହ଼ପେତି ଲ଼କୁ ମାଚେରି, ଏ଼ ଜିରୁଟି ଲ଼କୁ ରେ଼ଜାଲି ଆ଼ଡିହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ଏ଼ୱାରି କିର୍‌ଡ଼ିହିଁ ଏଲେଇଚେରି, “ଏ଼ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ! ନୀ ତଲେ ନାଙ୍ଗେ ଏ଼ନାୟି ମାନେ ? ମା଼ ବେ଼ଲା ୱା଼ଆନେଏ ମାଙ୍ଗେ କସ୍ତ ହିୟାଲି ଇମ୍ବାଆଁ ୱା଼ତିକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଇଞ୍ଜାଁ ଏ଼ୱାରି ତା଼ଣାଟି ହେକ ର଼ ମାନ୍ଦା ପାଜିୟାଁ ମେୟିଁମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ଏ଼ ଲ଼କୁ ବିତ୍ରାତି ବୂତୁୟାଁ ଜୀସୁଇଁ ବାତିମା଼ଲିହିଁ ଏଲେଇଚୁ, “ମାଙ୍ଗେ ପେ଼ର୍‌ହାଦି ଇଚିହିଁ, ଏ଼ ପାଜିୟାଁ ମାନ୍ଦା ବିତ୍ରା ପାଣ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜୀସୁ ଏ଼ୱାସିକାଣି ଏଲେଇଚେସି, “ହାଜୁ ।” ବୂତୁୟାଁ ଏ଼ ଦେବୁଣିଏ ଲ଼କୁଇଁ ପିସାନା ପାଜିୟାଁ ମାନ୍ଦା ବିତ୍ରା ହ଼ଟୁ; ଏ଼ ପାଜିୟାଁ ହ଼ରୁ କାଡ଼୍‌ଦିଟି ଦାବ୍‌ଡ଼ି ହଟାନା ଦାରିତି ସାମ୍‌ଦୁରିତା ମେଦାନା ହା଼ହାହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ପାଜିୟାଁ ମେଚିମାଚି ଗ଼ଡ଼୍‌କା ହଟିହିଁ ହାଜାନା ଗା଼ଡ଼ାତା ବାରେ କାବ୍ରୁ ଇଞ୍ଜାଁ ବୂତୁୟାଁ ଆଲ୍‌ଗା ମାଚାରି ଏ଼ନି ଆ଼ତେରି ଏ଼ ବାରେ ହା଼ଡା ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଅ଼ଡ଼େ ନା଼ସ୍‌କାତି ବାରେ ଲ଼କୁ ଜୀସୁଇଁ ମେସାଲି ୱା଼ତେରି, ଇଞ୍ଜାଁ ଜୀସୁଇଁ ମେସାନା ତାମି ହାନ୍ଦିଟି ହାଜାଲି ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଏମ୍ବାଟିଏ ଜୀସୁ ଡଂଗତା ହ଼ଚାନା ସାମ୍‌ଦୁରି ଗା଼ଣ୍‌ଚାହାଁ ତା଼ନୁ ବାସାଆ଼ହାମାନି ଗା଼ଡ଼ାତା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ କାଟେଲିତା ଡୂରାମାଚି ର଼ ଟଟୱା଼ୟିତି ଲ଼କୁଇଁ ଡେ଼କାନା ତାନି ତା଼ଣା ତାତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ନାମୁ ମେସାନା ଜୀସୁ ଏ଼ ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ମୀର୍‌ଏଣା, ସା଼ସା ଆହ୍‌ମୁ ନୀ ପା଼ପୁ ବାରେ ମେଣ୍‌ଙ୍ଗାହାଚେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଏଚେକା ମେ଼ରା ଜା଼ପ୍‌ନାରି ଈ ହା଼ଡା ୱେଞ୍ଜାନା ଏ଼ୱାରି ୱେସ୍‌ପି ଆ଼ତେରି, “ଈ ମାଣ୍‌ସି ମାହାପୂରୁଇଁ ନିନ୍ଦା କିହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ଜୀସୁ ଏ଼ୱାରି ମ଼ନତି ହା଼ଡା ପୁଞ୍ଜାନା ଏଲେଇଚେସି, “ମୀରୁ ମୀ ମ଼ନତା ଏ଼ନାଆଁତାକି ଇଚେକା ଲାଗେଏତି ଅଣ୍‌ପୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ଇଚିହିଁ ଏ଼ନାଆଁ ଇନାୟି ଊସାସା, ନୀ ପା଼ପୁ ମେଣ୍‌ଙ୍ଗାହାଚେ, ଆ଼ଆତିଁ ନିଙ୍ଗାନା ତା଼କାମୁ ? ");
INSERT INTO kxv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ସାମା ଦାର୍‌ତିତି ପା଼ପୁ ମ୍ଣେକ୍‌ହାଲି ତାକି ମାଣ୍‌ସି ମୀର୍‌ଏଣାକି ଅଦିକାରା ମାନେ, ଈଦାଆଁ ଏ଼ନିକିଁ ପୁଞ୍ଜାଲି ଆ଼ଡିନେରି,” ଏ଼ଦାଆଁତାକି ଜୀସୁ ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ ନୀ କାଟେଲି ଡେ଼କାନା ଇଜ ହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନିଙ୍ଗାନା ତାମି ଇଜ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ଈଦାଆଁ ମେସାନା ଲ଼କୁ ଆଜିତେରି, ଅ଼ଡ଼େ ଆମିନି ମାହାପୂରୁ ମାଣ୍‌ସିୟାଁକି ଇଲେତି ଅଦିକାରା ହୀହାମାନେସି ଇଞ୍ଜିହିଁ ଏ଼ ମାହାପୂରୁତି ଗାୱୁରମି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜୀସୁ ଏମ୍ବାଟି ହାଜି ହାଜିହିଁ ମାତିୟୁ ଦ଼ରୁଗାଟି ର଼ ସିସ୍ତୁ ରୀହ୍‌ନାସି ତାନି ସିସ୍ତୁ ରୀହ୍‌ନି ଟା଼ୟୁତା କୁଗାମାନାଣି ମେସାନା ହା଼ଟାନା ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ ।” ଏମ୍ବାଟିଏ ମାତିୟୁ ନିଙ୍ଗାନା ତାନି ଜେ଼ଚ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଇଞ୍ଜାଁ ଜୀସୁ ମାତିୟୁ ଇଜ ତୀନି ବେ଼ଲା ଏଚେକା ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁଗାଟି ଲ଼କୁ ତାମି ସୀସୁୟାଁ ତଲେ ତିଞ୍ଜାଲି କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ପାରୁସିୟାଁ ଈଦାଆଁ ମେସାନା ସୀସୁୟାଁଇଁ ଏଲେଇଚେରି, “ମୀ ଗୂରୁ ଏ଼ନାଆଁତାକି ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରି ତଲେ ତିଞ୍ଜି ମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ସାମା ଜୀସୁ ଏ଼ୱାରି ହା଼ଡା ୱେଞ୍ଜାନା ଏଲେଇଚେସି, “ନେହିଁ ଲ଼କୁତାକି ଅସଗୂରୁ ଲ଼ଡ଼ା ହିଲେଏ, ସାମା ର଼ଗ ଗାଟାରାକି ଲ଼ଡ଼ାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ଈଦାଆଁତାକି ମୀରୁ ହାଜାନା ଈଦାନି କାତା ଜା଼ପାଦୁ, ସାମା ପୂଜା ହୀନାୟି ଲ଼ଡ଼ାଆଏ, ସାମା ଲ଼କୁଣି କାର୍ମାମେହ୍‌ନାୟି ନେହେଁ; ଇଚିହିଁ ନା଼ନୁ ଦାର୍ମୁ ଗାଟାରାଇଁ ଆ଼ଏ ସାମା ପା଼ପୁ ଗାଟାରାଇଁ ହା଼ଟାଲି ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ଏଚିବେ଼ଲାତା ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି ସୀସୁୟାଁ ଜୀସୁଇଁ ୱା଼ହାନା ୱେଚେରି, “ମା଼ମ୍ବୁ ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଉପାସା କିହିମାନମି, ସାମା ମୀ ସୀସୁୟାଁ ଏ଼ନାଆଁତାକି ଉପାସା କିଅରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବୀହା ହନେଏସି ଡ଼ୟିନି ପାତେକା ବୀହା ଲ଼କୁ ଦୁକୁ ଆ଼ଅରି, ସାମା ଦିନା ୱା଼ନେ, ଏଚିବେ଼ଲା ବୀହା ହନେଣାଇଁ ଅ଼ନେରି, ଏଚିବେ଼ଲା ଏ଼ୱାରି ଉପାସା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ଆମ୍ବାଆସି ପ୍ଣାଃଇ ହିମ୍ବରିତା ପୁଃନି ପାସ୍‌କି ତାଚଅସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ ପାସ୍‌କି ପ୍ଣାଃଇ ହିମ୍ବରିତି ଗେସାଅ଼ନେ, ଇଞ୍ଜାଁ ଏ଼ଦି ହା଼ରେକା କାଜାୟି ଆ଼ହିଁ ଗେଞ୍ଜିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଅ଼ଡ଼େ ଲ଼କୁ ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପ୍ଣାଃଇ ଡ଼଼କାତା ଇଟଅରି; ଇଚିହିଁ ଏ଼ ଡ଼଼କା ଡ଼ାୟାହାନେ ଅଙ୍ଗୁରି ରାସା ବ଼ହାହାନେ, ସାମା ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପୁଃନି ଡ଼଼କାତା ଇଟିନେରି, ଆତିହିଁ ଅଙ୍ଗୁରି ରାସା ଅ଼ଡ଼େ ଡ଼଼କା ନେହିଁ ଡ଼ୟିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଏଚିବେ଼ଲା ଈ ବାରେ କାତା ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସିମାଚି ବେ଼ଲାତା ର଼ ଜୀହୁଦି କାଜାପା଼ଣା ଗାଟାସି ଡାଗେ ୱା଼ହାନା ମେଣ୍ତାକୁତାନା ଜହରା କିହାଁ ଏଲେଇଚେସି, “ନା଼ ମା଼ଙ୍ଗା ନୀଏଁ ହା଼ହାହାଚେ, ସାମା ନୀନୁ ୱା଼ହାନା ତାନି ଲାକ କେୟୁ ଇଟିତିହିଁ ଏ଼ଦି ନୀଡିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ଏମ୍ବାଟିଏ ଜୀସୁ ନିଙ୍ଗାନା ତାନି ସୀସୁୟାଁ ତଲେ ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ବା଼ର ବାର୍ସା ପାତେକା ନେତେରି ୱା଼ଙ୍ଗିନି ର଼ଗଗାଟି ର଼ ଇୟା ଡା଼ୟୁୱାକିଟି ୱା଼ହାନା ଜୀସୁତି ହିମ୍ବରି କୁଙ୍ଗୁ ଡୀଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଇଚିହିଁ ଏ଼ ଇୟା ମ଼ନତା ଅଣ୍‌ପିମାଚେ, “ୱାର୍‌ଇ ତାନି ହିମ୍ବରି ଡୀଗିତିହିଁ ନା଼ନୁ ନେହିଁ ଆ଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ସାମା ଜୀସୁ ୱେଣ୍ଡେ ଡା଼ୟୁୱାକି ସିନିକିହାନା ଏଲେଇଚେସି, “ମା଼ଙ୍ଗା ସା଼ସା ଆହ୍‌ମୁ, ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେ” ଏ଼ ଦେବୁଣିଏ ଏ଼ ଇୟା ନେହିଁ ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ଡା଼ୟୁ ଜୀସୁ ଏ଼ କାଜାପା଼ଣା ଗାଟାରି ଇଜ ହାଚେସି, ଏମ୍ବାଆଁ ପୀରୁଡ଼ି ଊକିନାରାଇଁ ଅ଼ଡ଼େ ଡ଼ୀହିଁ କା଼ଲ୍‌ୱି ଆ଼ହିମାଚି ଲ଼କୁଣି ମେସାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ବାରେ ଇମ୍ବାଟି ପାଙ୍ଗାତା ହାଜୁ, ପ଼ଦା ହା଼ହାହିଲେଏ, ସାମା ଡୂରାମାନେ, ଏଚେଟିଏ ତାନି ହା଼ଡା ୱେଞ୍ଜାନା ଏ଼ୱାରି କାକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ସାମା ବାରେ ଲ଼କୁ ପାଙ୍ଗାତା ହାଜାଲିଏ, ଜୀସୁ ଇଜ ବିତ୍ରା ହାଜାନା ପ଼ଦାନି କେୟୁ ଆସାନା ନିକ୍‌ହେସି ଅ଼ଡ଼େ ଏ଼ ଦେବୁଣିଏ ନିଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଇଞ୍ଜାଁ ଈ କାବ୍ରୁ ଏ଼ ଦେ଼ସାତି ସା଼ରିୱାକି ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜୀସୁ ଏମ୍ବାଟି ହାଜିମାଚି ବେ଼ଲାତା ରିଆରି କା଼ଣାୟାଁ କାଜା ଗିୟାଁତଲେ ହା଼ଟିହିଁ ଏଲେଇଚେରି, “ଏ଼ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ମାଙ୍ଗ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଇଞ୍ଜାଁ ଜୀସୁ ଇଲୁ ବିତ୍ରା ହ଼ଡାଲିଏ ଏ଼ କା଼ଣାୟାଁ ଜିକେଏ ଏ଼ୱାଣି ଡାଗେ ୱା଼ତେରି, ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ମାଙ୍ଗେ ନେହିଁ କିହାଲି ଆ଼ଡାନେସି ଇଞ୍ଜିଁ ମୀରୁ ନାମିମାଞ୍ଜେରି ? ଏ଼ୱାରି ଏଲେଇଚେରି “ହାଅ ପ୍ରବୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରି କାଣ୍‌କା ଡୀଗାନା ଏଲେଇଚେସି, “ମୀ ନାମିନି ଲେହେଁ ମିଙ୍ଗେତାକି ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଏଚେଟିଏ ଏ଼ୱାରି ମେସାଲି ଆ଼ଡିତେରି, ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ୱାରାଇଁ ଜାଣ୍ତେ ହୁକୁମି ହୀହାନା ଏଲେଇଚେସି, “ହେଣ୍ତୁ ଈ ହା଼ଡା ଆମ୍ବାଆରି ଜିକେଏ ପୁନଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ସାମା ଏ଼ୱାରି ପାଙ୍ଗାତା ହାଜାନା ଜୀସୁତି ହା଼ଡା ଦେ଼ସାତି ସା଼ରିୱାକି ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ଏ଼ୱାରି ହ଼ଚା ହାଜିମାଚାଟି ଲ଼କୁ ର଼ ଜ଼ଲାଲି ଆ଼ଡାଆଗାଟି ବୂତୁ ଆଲ୍‌ଗା ମାଚାଣାଇଁ ଜୀସୁ ନ଼କିତା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜୀସୁ ବୂତୁଇଁ ପେ଼ର୍‌ହା ପାଣ୍ତିତି ଦେବୁଣିଏ ଏ଼ୱାସି ଜ଼ଲାଲି ଆ଼ଡିତେସି, ଏଚେଟିଏ ଲ଼କୁ କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଇସ୍ରାୟେଲ ଦେ଼ସାତା ମା଼ମ୍ବୁ ଇଲେତି କାବାଆ଼ନି କାମା ଏଚେଲା ମେସାହିଲାଆତମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ଏଚିବେ଼ଲା ପାରୁସିୟାଁ ୱେଚେରି. ଏ଼ୱାରି ଏଲେଇଚେରି, “ଈୱାସି ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାନେସି” ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାସିକାଣି ସା଼ଲୱି କିହିମାନି ବା଼ଲ୍‌ପେ଼ନୁ ଏ଼ୱାଣାକି ବା଼ଡ଼୍‌ୟୁ ହୀହିମାନେ ଲାକା ଆ଼ଡିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ଜା଼ପ୍‌ହିହିଁ ମାହାପୂରୁ ରା଼ଜିତି ନେହିଁ କାବ୍ରୁ ୱେସିହିଁ ବାରେଲେହେଁତି ର଼ଗ ନ଼ମେରି ଦୁକାଟି ନେହିଁ କିହିହିଁ, ବାରେ ଗା଼ଡ଼ାୟାଁ ଇଞ୍ଜାଁ ନା଼ସ୍‌କାଣାଁ ରେ଼ଜାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଅ଼ଡ଼େ ବାରେ ଲ଼କୁଣି ମେସାନା ଏ଼ୱାସି କାର୍ମା ଆ଼ତେସି, ଇଚିହିଁ ଏ଼ୱାରି ଗ଼ଡ଼ୁ ହିଲାଆ ମେ଼ଣ୍ତାୟାଁ ଲେହେଁ କା଼କୁଲିଟି ଇତାଲା ଆତାଲା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଏଚିବେ଼ଲା ଜୀସୁ ତାମି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ପା଼ଚି ହା଼ରେକା ସାମା ଦା଼ଃଆନାରି ଊଣା ଜା଼ଣା । ");
INSERT INTO kxv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ଏ଼ଦାଆଁତାକି ପା଼ଚି ଜା଼ଚାଲି, ଲ଼କୁଣି ପାଣ୍ତାଲିତାକି ଗୁଡିୟାତି ସା଼ୱୁକାରିଇଁ ବାତିମା଼ଲାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଏମ୍ବାଟିଏ ଜୀସୁ ତାମି ବା଼ରଜା଼ଣା ସୀସୁୟାଁଇଁ ଡାଗେ ହା଼ଟାନା ବୂତୁୟାଁ ପିସ୍‌ପି କିହାଲି, ଇଞ୍ଜାଁ ବାରେ ର଼ଗ କସ୍ତଟି ନେହିଁ କିହାଲି ଏ଼ୱାରାକି ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ଏ଼ ବା଼ରଜା଼ଣା ପାଣ୍ତ୍‌ୱିଆ଼ତି ସୀସୁୟାଁ ଦ଼ର୍‌କା ଆ଼ତୁ, ସିମନ, ଆମ୍ବାଆରାଇଁ ପିତର ଇନେରି, ଅ଼ଡ଼େ ତାମି ତାୟି ଆନ୍ଦ୍ରିୟ, ଜେବଦି ମୀର୍‌ଏସି ଜାକୁବ ଅ଼ଡ଼େ ତାମି ତାୟି ଜହନ, ");
INSERT INTO kxv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ ଅ଼ଡ଼େ ବାର୍ତଲମି, ତ଼ମା ଅ଼ଡ଼େ ସିସ୍ତୁ ରୀହ୍‌ନି ମାତିୟୁ, ଆଲେପି ମୀର୍‌ଏସି ଜାକୁବ ଅ଼ଡ଼େ ତଦିୟ, ");
INSERT INTO kxv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ଦେ଼ସାତି ଜୀୱୁ ନ଼ନି ସିମନ ଅ଼ଡ଼େ ଇସ୍କାରିୟତ ଜୀହୁଦା ଆମ୍ବାଆସି ଜୀସୁଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜୀସୁ ଈ ବା଼ରଜା଼ଣାତି ପାଣ୍ତାନା ହୁକୁମି ହୀହାଁ ଏଲେଇଚେସି, ମୀରୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ହାଲାଆଦୁ, ଅ଼ଡ଼େ ଆମିନି ସମିରଣି ନା଼ସ୍‌କାଣାଁ ହ଼ଡ଼୍‌ଆଦୁ, ");
INSERT INTO kxv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ସାମା ଜା଼ଙ୍ଗାମାନି ମେ଼ଣ୍ତାୟାଁ ଇଚିହିଁ ଇସ୍ରାୟେଲ ଲ଼କୁତା଼ଣା ହାଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଏ଼ୱାରିତା଼ଣା ହାଜୁ ଅ଼ଡ଼େ ୱେ଼କ୍‌ଦୁ ଲାକପୂରୁ ରା଼ଜି ଏଗାୱା଼ହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ଅ଼ଡ଼େ ନ଼ମେରି ଗାଟାରାଇଁ ନେହିଁ କିଦୁ, ହା଼ତାରାଇଁ ନିକ୍‌ଦୁ, କାଜା ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିଦୁ, ବୂତୁୟାଁଇଁ ପେ଼ର୍‌ଦୁ । ମୀରୁ ଉଜେଏ ବେଟା ଆ଼ହାମାଞ୍ଜେରି ଏ଼ଦାଆଁ ଉଜେଏ ହୀଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ମୀ ତଲେ ବାଂଗାରା ୱେଣ୍ଡି କି ଅଟଡ଼ିତା ଟାକାୟାଁ ଅ଼ଆଦୁ, ");
INSERT INTO kxv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଅ଼ଡ଼େ ହାନାଟି ଲେଚା କଡିନି ମ଼ଣା, ରୀ ଜ଼ଡ଼ୁ ସକାୟାଁ କି ସେପୁୟାଁ କି କୁତା ବାଡ଼୍‌ଗା ଜିକେଏ ପାରାଆଦୁ, କାମାକିନାସି ତାନି ରା଼ନ୍ଦା ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ଅ଼ଡ଼େ ମୀରୁ ଆମିନି ନା଼ୟୁଁତା କି ଗା଼ଡ଼ାତା ହାଜେରି ଏମ୍ବାଆଁ ନେହାଁଣାଇଁ ପାରାଦୁ, ଅ଼ଡ଼େ ଏମ୍ବାଟି ୱେଣ୍ତାହାନି ପାତେକା ଏ଼ୱାଣି ଇଜ ଡ଼ୟାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଅ଼ଡ଼େ ଇଜ ହ଼ଡ଼ନାଟି ଏ଼ୱାରାଇଁ ହିତ୍‌ଡ଼ି ଜୀୱୁ ମିଙ୍ଗେ ଆୟାପେ ଇଞ୍ଜୁ; ");
INSERT INTO kxv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଏ଼ୱାରି ଇଜତାରି ନେହାଁରି ଇଚିହିଁ ଏ଼ୱାରିତଲେ ମୀ ହିତ୍‌ଡ଼ି ଡ଼ୟାପେ, ସାମା ଏ଼ୱାରି ନେହାଁରି ଆ଼ଆତିଁ ମୀ ହିତ୍‌ଡ଼ି ମିଙ୍ଗେ ୱେଣ୍ଡା ୱା଼ପେ । ");
INSERT INTO kxv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଅ଼ଡ଼େ ଆମିନି ଇଲୁତାକି ନା଼ସ୍‌କାଣାଁ ମିଙ୍ଗ ଲ଼କୁ ଅ଼ପଅରି, ମୀ କାତାତି ୱେନଅରି, ଏ଼ ଇଲୁଟି କି ଏ଼ ଗା଼ଡ଼ାଟି ହ଼ଚାୱାନାଟି ମୀ କଡାତି ଦୂଡ଼ି ହାଣ୍‌ହା କଡାନା ଏ଼ ଟା଼ୟୁ ପିହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁତି ନୀହାଁୟି ଦିନାତା ଏ଼ ଗା଼ଡ଼ାତି ଡଣ୍ତ କିହାଁ ସଦମ ଅ଼ଡ଼େ ଗମରା ଦେ଼ସାତି ଡଣ୍ତ ଊଣା କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ହେଣ୍ତୁ ମେ଼ଣ୍ତାୟାଁଣି କ୍ଡାଃନିୟାଁ ବିତ୍ରା ପାଣ୍ତିନିଲେହେଁ ନା଼ନୁ ମିଙ୍ଗେ ପାଣ୍ତିମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁତାକି ମୀରୁ ରା଼ଚୁ ଲେହେଁ ବୁଦି ଗାଟାତେରି, ଅ଼ଡ଼େ ପା଼ର୍‌ୱା ପଟାଲେହେଁ କ଼ପା ହିଲାଆ ଗାଟାତେରି ଆ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ସାମା ମାଣ୍‌ସିୟାଁ ତା଼ଣାଟି ଜାଗ୍ରାତା ଆ଼ହାନା ଡ଼ୟାଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ମିଙ୍ଗେ ଆସାନା ନୀହାଁୟି କିନି ତା଼ଣା ହେର୍‌ପାନେରି, ଇଞ୍ଜାଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ଏ଼ୱାରି ମିଙ୍ଗେ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ତାନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଅ଼ଡ଼େ ମୀରୁ ନା଼ ତାକି ରାଜା ଅ଼ଡ଼େ ସା଼ଲୱି କିନି ଲ଼କୁତା଼ଣା ଅ଼ହାନା ନୀହାଁୟି କିୱିଆ଼ଦେରି; ଏ଼ଦି ଏ଼ୱାରାକି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁକି ମାହାପୂରୁତି ନେହିଁ କାବ୍ରୁ ୱେସାଲି ସା଼କି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ସାମା ଏଚିବେ଼ଲା ଏ଼ୱାରି ମିଙ୍ଗେ ହେର୍‌ପାନେରି, ମୀରୁ ନୀହାଁୟି ଆ଼ନିବେଲା ଏ଼ନାଆଁ ଜ଼ଲିଦେରି ଅ଼ଡ଼େ ଏ଼ନିକିଁ ଜ଼ଲିଦେରି, ଏ଼ କାତା ଅଣ୍‌ପାଆଦୁ, ଇଚିହିଁ ମୀରୁ ଏ଼ନାଆଁ ଜ଼ଲିଦେରି ଏ଼ ବେ଼ଲାତେଏ ମିଙ୍ଗେ ୱେସ୍ତାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","। ଇଚିହିଁ ମୀରୁ ଜ଼ଲିନାତେରି ଆ଼ଏ, ଆ଼ବା ମାହାପୂରୁତି ସୁଦୁଜୀୱୁ ମୀ ଗୂତି ହୀହାନା ହା଼ଡା ଜ଼ଲିନେ, ଏ଼ଦି ଜ଼ଲିନାୟି । ");
INSERT INTO kxv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ତାୟି ତାୟିଇଁ ଆ଼ବା ମୀର୍‌ଏଣାଇଁ ପା଼ୟାଲି ହେର୍‌ପିନେସି, ମା଼ସ୍‌କା, ମୀର୍‌କା ଏ଼ୱାରି ତାମି ଇୟା ଆ଼ବା କ଼ପାଟି ହ଼ଚାନା, ଏ଼ୱାରାଇଁ ପା଼ୟିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ଅ଼ଡ଼େ ନା଼ ଦ଼ରୁ ତାକି ମୀରୁ ବାରେତା଼ଣା ଅ଼ପାଆ ଗାଟାତେରି ଆ଼ଦେରି, ସାମା ଆମ୍ବାଆସି ରା଼ନି ପାତେକା ସା଼ସା ତଲେ ମାନେସି ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ସାମା ଏ଼ୱାରି ଏଚିବେ଼ଲା ର଼ ଗା଼ଡ଼ାତା ମିଙ୍ଗେ ନିନ୍ଦା କିୟାନେରି, ଏଚିବେ଼ଲା ଏଟ୍‌କା ଗା଼ଡ଼ାତା ହାଜୁ, ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଇସ୍ରାୟେଲତି ବାରେ ଗା଼ଡ଼ାୟାଁତା କାମା ରା଼ପ୍‌ଆ ନ଼କେଏ ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ସୀସୁ ତାନି ଗୂରୁ କିହାଁ ହ଼ଲେଏସି ସା଼ୱୁକାରି କିହାଁ କାଜାସି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ସୀସୁ ତାନି ଗୂରୁ ଅ଼ଡ଼େ ହ଼ଲେଏସି ତାନି ସା଼ୱୁକାରି ଲେହେଁ ଆତିହିଁ ଏ଼ୱାରାକି ସମାନା ଆ଼ନେ, ଏ଼ୱାରି ଇଲୁତି ସା଼ୱୁକାରିଇଁ ବାଲ୍‌ଜିବୁଲ୍‌ ଇନେରି ଇଚିହିଁ ଏ଼ୱାଣି ଇଲୁତି ଲ଼କୁବା଼କାଆଁ ହା଼ରେକା ପ଼ଲ୍‌ଆ କାତା ଜ଼ଲିନେରି !” ");
INSERT INTO kxv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଏ଼ଦାଆଁତାକି ଲ଼କୁଇଁ ଆଜାଆଦୁ; ଇଚିହିଁ ଡ଼ୁଗାମାନାୟି ଏ଼ନାୟିୱା ର଼ ଦିନା ତ଼ଞ୍ଜାଆ଼ନେ, ଏଲେକିଁ ତ଼ଞ୍ଜାଆ଼ଆନା ଡ଼ୁଗାମାନାୟି ଏ଼ନାୟିୱା ହିଲେଏ, ଇଞ୍ଜାଁ ପୁଣ୍‌ମ୍ବି କିୱିଆ଼ଆଗାଟାୟି ଇଲେକିଁ ଏ଼ନାୟି ଡ଼ୁଗା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ନା଼ନୁ ମିଙ୍ଗ ଏ଼ନାଆଁ ଆନ୍ଦେରିତା ୱେସ୍ତାଇଁ ଏ଼ଦାଆଁ ଉଜେଡ଼ିତା ୱେହ୍‌ଦୁ, ଅ଼ଡ଼େ ଏ଼ନାଆଁ ଡ଼ୁଗାନା ୱେଞ୍ଜେରି ଏ଼ଦାଆଁ ଇଲୁ ତୂଡ଼ିୟା ଲାକ ହ଼ଚାନା ୱେହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଅ଼ଡ଼େ ଆମ୍ବାଆରି ୱାର୍‌ଇ ଆଙ୍ଗାତି ପା଼ୟିନେରି, ସାମା ଜୀୱୁତି ପା଼ୟାଲି ଆ଼ଡଅରି, ଏ଼ୱାରାଇଁ ଆଜାଆଦୁ; ସାମା ଆମ୍ବାଆସି ମୀ ଜୀୱୁ ଅ଼ଡ଼େ ଆଙ୍ଗା ବାରେତି ନର୍କତା ନା଼ସା କିହାଲି ଆ଼ଡିମାନେସି ଏ଼ୱାଣାଇଁ ଆଜାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ରୀ ଜେତା ପଟାୟାଁ ର଼ କା଼ନି ତାକି ପାର୍‌ପି ଆ଼ଉ କି ? ଅ଼ଡ଼େ ମୀ ଲାକପୂରୁତି ଆ଼ବା ହେଲ ହୀଆତି ଏ଼ୱାସିକା ବିତ୍ରାଟି ରଣ୍ତି ଜିକେଏ ଡ଼଼ଇ ତର୍‌ଗେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ସାମା ମୀ ତା଼ର୍ୟୁଁତି ବାରେ ବା଼ଣାୟାଁ ଜିକେଏ ଏଜିକିୱି ଆ଼ହାମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଏ଼ଦାଆଁତାକି ଆଜାଆଦୁ, ମୀରୁ ହା଼ରେକା ଜେତା ପଟାୟାଁ ତା଼ଣାଟି ମୀ ଦାରା ହା଼ରେକା ।” ");
INSERT INTO kxv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଲ଼କୁ ନ଼କିତା ନାଙ୍ଗେ ଆବାନେସି, ଇଞ୍ଜାଁ ନା଼ନୁ ଜିକେଏ ନା଼ ଲାକପୂରୁତି ଆ଼ବା ନ଼କିତା ଆବିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ସାମା ଆମ୍ବାଆସି ଲ଼କୁ ନ଼କିତା ନାଙ୍ଗେ ଆବଅସି, ନା଼ନୁ ଜିକେଏ ନା଼ ଲାକପୂରୁତି ଆ଼ବା ନ଼କିତା ଆବଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ନା଼ନୁ ଦାର୍‌ତିତା ହିତ୍‌ଡ଼ି ହୀହାଲି ୱା଼ହାମାଇଁ ଇଞ୍ଜିଁ ମ଼ନ କିଆଦୁ; ହିତ୍‌ଡ଼ି ହୀହାଲି ୱା଼ଆନା, କାଣ୍ତା ହୀହାଲି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ଇଚିହିଁ ନା଼ନୁ ଆ଼ବା କ଼ପାଟି ମୀର୍‌ଏଣାଇଁ, ଅ଼ଡ଼େ ଇୟାନି କ଼ପାଟି ମା଼ଙ୍ଗା ଇଞ୍ଜାଁ ପ଼ୟାନି କ଼ପାଟି କୁଡ଼ିୟାନି ଗଡ଼୍‌ହା କିହାଲି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଅ଼ଡ଼େ ମାଣ୍‌ସିତି ତାମି ଇଲୁତି ଲ଼କୁଏ ବାରେଜା଼ଣା ତାନି ସାତ୍ରୁ ଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଆମ୍ବାଆସି ଆ଼ବା କି ଇୟାନି ନା଼ କିହାଁ ହା଼ରେକା ଜୀୱୁ ନ଼ନେସି, ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ପା଼ଡ଼ାଆ଼ଅସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନିଜେତି ମା଼ଙ୍ଗା କି ମୀର୍‌ଏଣାଇଁ ହା଼ରେକା ଜୀୱୁ ନ଼ନେସି ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ପା଼ଡ଼ାଆ଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଆମ୍ବାଆସି ନିଜେତି କ୍ରୁସ ଡେ଼କାନା ନା଼ ଜେ଼ଚ ୱା଼ଅସି, ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ପା଼ଡ଼ାଆ଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଆମ୍ବାଆସି ନିଜେତି ଜୀୱୁ ନୀଟ୍‌ହା କଡିନେସି ଏ଼ୱାସି ହା଼ନେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନା଼ ତାକି ନିଜେତି ଜୀୱୁ ହୀନେସି, ଏ଼ୱାସି ନୀଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଆମ୍ବାଆସି ମିଙ୍ଗେ ଆବାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଆବାନେସି; ଆମ୍ବାଆସି ନାଙ୍ଗେ ଆବାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ଆବିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଆମ୍ବାଆସି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ, ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାରି ଇଞ୍ଜିଁ ଆବିନେସି, ଏ଼ୱାସି ଏ଼ ବ଼ଲୁ ୱେହ୍‌ନାରି ଦା଼ନା ବେଟା ଆ଼ନେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି କି ତୀରିଗାଟାରାଇଁ, ତୀରିଗାଟାସି ଇଞ୍ଜିଁ ଆବିନେସି ଏ଼ୱାସି ତୀରିଗାଟାରି ଦା଼ନା ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନା଼ ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅଣାଇଁ ନା଼ ସୀସୁ ଇଞ୍ଜିଁ ଗିନାତା ଏ଼ୟୁ ଗସାଲି ହୀନେସି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ତାନି ଦା଼ନାତି ଜା଼କ୍‌ଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜୀସୁ ତାନି ବା଼ରଜା଼ଣା ସୀସୁୟାଁଇଁ ଈ ବାରେ ହେଲ ହୀତି ଡା଼ୟୁ ଗାଲିଲି ଦାରିତା ମାନି ନା଼ସ୍‌କାଣାଁ ହାଜାନା ମାହାପୂରୁତି ହା଼ଡା ଜା଼ପ୍‌ହିହିଁ ୱେସିହିଁ ଏ଼ ଟା଼ୟୁଟି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଏଚିବେ଼ଲା ବାପ୍ତିସ୍ମ ହୀନି ଜହନ କାୟିଦିତା ମାଞ୍ଜାନା କ୍ରୀସ୍ତତି କାମା କିହିମାନାଣି ୱେଞ୍ଜାନା ଏ଼ ବାରେ ପୁଞ୍ଜାଲି ତାନି ସୀସୁୟାଁଣି ଜୀସୁ ତା଼ଣା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ଏ଼ୱାରି ହାଜାନା ଜୀସୁଇଁ ୱେଚେରି, “ଆମିନି ଲ଼କୁ ୱା଼ନେସି ଇଞ୍ଜିଁ ଜହନ ୱେସାମାଚେସି, ନୀନୁ କି ଏ଼ୱାତି ? କି ଅ଼ଡ଼େ, ଆମ୍ବାଆରି ତାକି କା଼ଚାନା ଡ଼ୟିନମି ?” ");
INSERT INTO kxv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ୱେଣ୍ଡା ହାଜାନା ଏ଼ନାଆଁ ୱେଞ୍ଜାମାଞ୍ଜେରି ଅ଼ଡ଼େ ମେସିମାଞ୍ଜେରି, ଜହନଇଁ ୱେହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କା଼ଣାୟାଁ ମେସିମାନେରି, ସଟାୟାଁ ତାକି ମାନେରି, କାଜା ର଼ଗ ଗାଟାରି ନେହିଁ ଆ଼ହିମାନେରି, ବେ଼ରାୟାଁ ୱେଞ୍ଜିମାନେରି, ହା଼ତାରି ନିଙ୍ଗିମାନେରି ଅ଼ଡ଼େ କାଙ୍ଗାଲା ଗାଟାରି ନେହିଁ କାବ୍ରୁ ୱେଞ୍ଜିମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ନା଼ ତା଼ଣା ଆମ୍ବାଆରି ଆନାମାନା ଆ଼ଅରି ଏ଼ୱାରି ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଜହନତି ସୀସୁୟାଁ ୱେଣ୍ଡାହାଜିମାଚି ବେ଼ଲା ଜୀସୁ ଲ଼କୁଇଁ ଜହନତି କାତା ଏଲେଇଚେସି, “ମୀରୁ ଲ଼କୁ ହିଲାଆ ରା଼ଜିତା ଏ଼ନାଆଁ ମେସାଲି ହାଜାମାଚେରି ? ଗା଼ଲିତା ଦା଼ଙ୍ଗିନି ଡାଣ୍ତି ଆ଼କୁ ? ");
INSERT INTO kxv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ଏ଼ଦାଆଁ ଆ଼ଆତିହିଁ ଏ଼ନାଆଁ ମେସାଲି ହାଜାମାଚେରି ? ନେହିଁ ଅ଼ଜିତି ପା଼ତାଡ଼ା ହିମ୍ବରି ହୁଚାମାନି ର଼ ଲ଼କୁଇଁ ? ମେହ୍‌ଦୁ ଅ଼ଜିତି ହିମ୍ବରି ହୁଚିତି ଲ଼କୁ ରାଜା ଗା଼ଡ଼ାତା ଡ଼ୟିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ଏ଼ଦାଆଁ ଆ଼ଆତିଁ ଏ଼ନାଆଁ ମେସାଲି ହାଜାମାଚେରି ? ଏ଼ନାଆଁ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଣାଇଁ ? ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କିହାଁ ହା଼ରେକା କାଜାଣାଇଁ; ");
INSERT INTO kxv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଇଚିହିଁ ଏ଼ ଜହନତି କାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ମାହାପୂରୁ ଏଲେଇଞ୍ଜି ମାନେସି, ନା଼ ତାକି ଜିରୁ କେ଼ପାଲି ନା଼ନୁ ନ଼କେଏ ନା଼ ଦୂତୁଇଁ ପାଣ୍ତାଇଁ, ଏ଼ୱାସିଏ ଈ ମାଣ୍‌ସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ ପାତେକା ଈ ଦାର୍‌ତିତା ଏଚେକା ଜାର୍ନା ଆ଼ହାମାନେରି, ଏ଼ ବାରେଜା଼ଣା କିହାଁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନ କାଜାସି; ଆ଼ତିଜିକେଏ ଲାକପୂରୁ ରା଼ଜିତା ଆମ୍ବାଆସି ବାରେକିହାଁ ଊଣା, ଏ଼ୱାସି ଜହନ କିହାଁ କାଜାସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି କାତା ୱେହ୍‌ନି ଦିନାଟିଏ ନୀଞ୍ଜୁପାତେକା ଲାକପୂରୁ ରା଼ଜି ବା଼ଡ଼୍‌ୟୁ ତଲେ ପାଡାଆ଼ହିମାନେ; ଇଞ୍ଜାଁ ବା଼ଡ଼୍‌ୟୁଟି ଆସାମାନାରି ଏ଼ଦାଆଁ ବେଟାଆ଼ହାଲି ଅଣ୍‌ପିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଇଚିହିଁ ବାରେ ମ଼ସାତି ମେ଼ରାତା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣା ଜହନତି ୱା଼ନି ଦିନା ପାତେକା ୱେସ୍‌ପି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଅ଼ଡ଼େ ମୀରୁ ଏ଼ୱାରି କାତା ଆସାଲି ମୀ ମ଼ନ ମାଚିହିଁ ଆମିନି ଏଲିୟ ୱା଼ନାୟି ମାଚେ ଜହନଏ ଏ଼ୱାସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଆମ୍ବାଆରି କୀର୍କା ମାନୁ ଏ଼ୱାସି ୱେଣ୍‌ମ୍ବାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ସାମା ନା଼ନୁ ଆମ୍ବାରିତଲେ ଈ ଜୁଗୁତି ଲ଼କୁଣି ତୂକ୍‌ଇଁ, ଆମିନି ହା଼ଟା ମାଦି କୁଗାନା କାହି ଡ଼ୟିନି କକାରି ଲେହେଁ, ର଼ ଗଚିତି କକାରି ଅ଼ର ଗଚିତି ଏଲେଇନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ମା଼ମ୍ବୁ ମୀ ନ଼କିତା ପୀରୁଡ଼ି ଊକିତମି, ସାମା ମୀରୁ ଏ଼ନ୍ଦାଆତେରି; ମା଼ମ୍ବୁ ଦୁକୁତି ପା଼ଚୁ ପା଼ଚିତମି ସାମା ମୀରୁ ଡ଼ୀଆତେରି, ନୀଏଁତି ଲ଼କୁ ଏଲେତାରି । ");
INSERT INTO kxv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଇଚିହିଁ ଜହନ ୱା଼ହାନା ରା଼ନ୍ଦା ତିନାଆତେସି ଅ଼ଡ଼େ ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି ବୂତୁ ଆଲ୍‌ଗାମାନାସି । ");
INSERT INTO kxv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ସାମା ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ହାନା ରା଼ନ୍ଦା ତିଚେସି ଉଟେସି, ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେଜା଼ଣା ଏଲେଇଚେରି, ଈୱାସି ଟିଣ୍ତିକାୱୁ, କାଡ଼ୁବୂତୁ, ଏ଼ୱାସି ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରି ତ଼ଣେଏସି; ସାମା ମାହାପୂରୁତି ବୁଦି ଏ଼ୱାଣି କାମାଟି ସାତା ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ଏଚିବେ଼ଲା ଆମିନି ଗା଼ଡ଼ାତା ହା଼ରେକା କାବାଆ଼ନି କାମା କିୱି ଆ଼ହାମାଚେ, ଏ଼ ଗା଼ଡ଼ାତି ଲ଼କୁ, ତାମି ପା଼ପୁଟି ତାମା ମ଼ନ ୱେଟ୍‌ହା ହିଲାଆତେରି, ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ ଗା଼ଡ଼ାୟାଁତି ଲ଼କୁଇଁ ଦାକା ହୀହାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କରାଜିନ୍‌ ଅ଼ଡ଼େ ବେତ୍‌ସାୟିଦା, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀ ତା଼ଣା ଆମିନି ବା଼ଡ଼୍‌ୟୁତି କାମା କିୱିଆ଼ହାମାନେ, ଏ଼ ବାରେ ସ଼ର ଅ଼ଡ଼େ ସିଦନତା କିୱି ଆ଼ହାମାଚିହିଁମା; ଏମ୍ବାତି ଲ଼କୁ ଆଙ୍ଗାତା ବାସ୍ତାୟାଁ ପର୍‌ହାନା ଦାର୍‌ମ୍ବୁତା କୁଗାନା ମ଼ନ ୱେଟ୍‌ହାଲି ଅଣ୍‌ପିତେରିମା ");
INSERT INTO kxv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ଆ଼ତିଜିକେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁତି ନୀହାଁୟି ଦିନାତା ମୀ ଡଣ୍ତ କିହାଁ ସ଼ର ଅ଼ଡ଼େ ସିଦନତି ଡଣ୍ତ ଅ଼ର୍‌ହିନାୟି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଏ଼ କପର୍‌ନାହୁମ, ନୀନୁ ଏ଼ନାଆଁ ଲାକପୂରୁ ପାତେକା ପାଡାଆ଼ଦି ? ନୀନୁ ହା଼ତାରି ମାନି ରା଼ଜିତା ଅ଼ୱିଆ଼ଦି, ନୀ ତା଼ଣା ଆମିନି ବା଼ଡ଼୍‌ୟୁତି କାମା କିୱିଆ଼ହାମାନେ, ଏ଼ଦାଆଁ ସଦମତା କିୱିଆ଼ତିହିଁମା, ଏ଼ ଗା଼ଡ଼ା ନୀଞ୍ଜୁପାତେକା ଡ଼ୟିତେମା । ");
INSERT INTO kxv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ଆ଼ତିଜିକେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ “ମାହାପୂରୁତି ନୀହାଁୟି ଦିନାତା ମୀ ଡଣ୍ତ କିହାଁ ସଦମ ଦେ଼ସାତି ଡଣ୍ତ ଅ଼ର୍‌ହିନାୟି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଏ଼ ବେ଼ଲାତା ଜୀସୁ ପ୍ରା଼ତାନା କିହିଁ ଏଲେଇଚେସି; “ଏ଼ ଆ଼ବା, ଲାକପୂରୁ ଅ଼ଡ଼େ ଦାର୍‌ତିତି ପ୍ରବୁ, ଈ ବାରେ ହା଼ଡା ନୀନୁ ବୁଦି ଅ଼ଡ଼େ ପୁନି ଲ଼କୁତା଼ଣାଟି ଡ଼ୁକ୍‌ହା ଇଟାନା, ଈ ବାରେ କାତା ପୁନାଆଗାଟି ଲ଼କୁତା଼ଣା ତ଼ସିମାନାକି ନା଼ନୁ ନିଙ୍ଗ ଜହରା କିହିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ହାଅ ଆ଼ବା, ଈଦି ନୀ ନ଼କିତା ରା଼ହାଁତି କାତା ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ନା଼ ଆ଼ବା ନାଙ୍ଗେ ବାରେ ହୀହାମାଞ୍ଜାନେସି, ଆ଼ବା ପିସ୍‌ପେ ଆମ୍ବାଆରି ମୀର୍‌ଏଣାଇଁ ପୁନଅରି ଅ଼ଡ଼େ ମୀର୍‌ଏଣା ପିସ୍‌ପେ ଆମ୍ବାଆରି ଆ଼ବାଇଁ ପୁନଅରି, ମୀର୍‌ଏସି ଆମ୍ବାଆରି ତା଼ଣା ତ଼ହ୍‌ନେସି ଏ଼ୱାସି ପୁନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ଼ ୱା଼ହୁ ରା଼ତା ଗାଟି ଲ଼କୁ, ବାରେ ନା଼ ତା଼ଣା ୱା଼ଦୁ, ନା଼ନୁ ମିଙ୍ଗେ ଜ଼ମିକିୟାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ନା଼ ଜୁୱେଡ଼ି ମୀ ବମିତା ଡେ଼କାନା ନା଼ ତା଼ଣାଟି ଜା଼ପାଦୁ, ଇଚିହିଁ ନା଼ନୁ କ଼ପା କାର୍‌ବି ହିଲାଆନା ସୁଦୁ ହିୟାଁ ଗାଟାତେଏଁ, ଇଞ୍ଜାଁ ମୀରୁ ନା଼ ତା଼ଣାଟି ମୀ ଜୀୱୁତା ଜ଼ମିଦେରି; ");
INSERT INTO kxv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଇଚିହିଁ ନା଼ ଜୁୱେଡ଼ି ଊସାସା ଅ଼ଡ଼େ ବ଼ଜୁ ଊଣା ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ଏଚରଦିନା ଡା଼ୟୁ ର଼ ଜ଼ମିନି ଦିନାତା ଜୀସୁ ଗ଼ହଁ ଗୁଡିୟାଟି ହାଜିମାଚେସି, ଇଞ୍ଜାଁ ତାନି ସୀସୁୟାଁ ହାକି ଆ଼ହାମାଚାକି ଗ଼ହଁ ଜେ଼କା ଡାପ୍‌ହାନା ତିଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ସାମା ପାରୁସିୟାଁ ଏ଼ଦାଆଁ ମେସାନା ଜୀସୁଇଁ ଏଲେଇଚେରି, “ମେହ୍‌ମୁ ଜ଼ମିନି ଦିନାତା ଏ଼ନାଆଁ କିନି ମେ଼ରା ହିଲେଏ, ଏ଼ଦାଆଁ ମୀ ସୀସୁୟାଁ କିହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ର଼ ଦିନା ଦାୱୁଦ ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗା ହାକି ଆ଼ହାଲିଏ ଏ଼ନାଆଁ କିହାମାଚେରି, ମୀରୁ ସା଼ସ୍ତେରିତା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ଏ଼ୱାସି ଏ଼ନିକିଁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଆମିନି ମାହାପୂରୁକି ହେର୍‌ପାମାନି ରୂଟି ପୂଜେରାଙ୍ଗା ପିସ୍‌ପେ ଆମ୍ୱାଆରି ତିନାଆଗାଟି ମେ଼ରା ମାଚେ, ସାମା ଦାୱୁଦ ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗା ତିନାଆଗାଟାୟି ମାଚେ, ଏ଼ଦାଆଁ ଏ଼ୱାରି ତିଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ଅ଼ଡ଼େ ଜ଼ମିନି ଦିନାତା ମାହାପୂରୁ ଇଲୁ ବିତ୍ରା ପୂଜେରାଙ୍ଗା ମେ଼ରା ଊରିତି ଜିକେଏ ଦ଼ହଗାଟାରି ଆ଼ଅରି, ମୀରୁ ଏ଼ନି ଏ଼ଦାଆଁ ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଈ ଟା଼ୟୁତା ମାହାପୂରୁ ଇଲୁ କିହାଁ ହା଼ରେକା କାଜାୟି ଇମ୍ବାଆଁ ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“ସା଼ସ୍ତେରି ୱେସିମାନେ, ସାମା ପୂଜା ହୀନାୟି ଲ଼ଡ଼ାଆଏ, ସାମା ଲ଼କୁଣି କାର୍ମାମେହ୍‌ନାୟି ନେହେଁ, ଈଦାଣି କାତା ମୀରୁ ପୁଞ୍ଜାମାଚିହିଁମା ଈ ଦ଼ହ ହିଲାଆ ଗାଟାଣାଇଁ ଦ଼ହ କିଆତେରିମା; ");
INSERT INTO kxv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଇଚିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜ଼ମିନି ଦିନାତି ପ୍ରବୁ ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜୀସୁ ଏମ୍ବାଟି ହାଜାନା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଏମ୍ବାଆଁ ରଅସି ମାଚେସି, ଏ଼ୱାଣି ର଼ କେୟୁ ୱା଼ୟାହାଜାମାଚେ, ଜୀସୁଇଁ ଦ଼ହ ଆସାଲି ଏଚେକା ଲ଼କୁ ଏମ୍ବାଆଁ କା଼ଚାମାଚେରି, ଏ଼ୱାରି ଜୀସୁଇଁ ୱେଚେରି, “ଜ଼ମିନି ଦିନାତା ନେହିଁକିନାୟି ମେ଼ରା ମାନେକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ବିତ୍ରା ରଅଣାକି ର଼ ମେ଼ଣ୍ତା ମାନେ, ଏମ୍ବାଟିଏ ଜ଼ମିନି ଦିନାତା ଏ଼ ମେ଼ଣ୍ତା ଗା଼ଡ଼୍‌ୟୁତା ତର୍‌ଗିନେ, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଏ଼ଦାନି ନିକ୍‌ଅସି, ଇଲେତି ଲ଼କୁ ଆମ୍ବାଆସି ମୀ ବିତ୍ରା ମାନେସି ? ");
INSERT INTO kxv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଆତିହିଁ ର଼ ମେ଼ଣ୍ତାତି ଦାରା କିହାଁ ମାଣ୍‌ସିତି ଦାରା ହା଼ରେକା । ଏ଼ଦାଆଁତାକି ଜ଼ମିନି ଦିନାତା ନେହିଁ କାମା କିନାୟି ମେ଼ରାତି କାମା ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଏଚିବେ଼ଲା ଏ଼ୱାସି କେୟୁ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “କେୟୁ ଦା଼ହ୍‌ମୁ ।” ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ କେୟୁ ଦା଼ସ୍ତେସି ଏମ୍ବାଟିଏ ଏ଼ କେୟୁ ଅ଼ର କେୟୁଲେହେଁ ନେହିଁ ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ସାମା ପାରୁସିୟାଁ ପାଙ୍ଗାତା ହାଜାନା ଜୀସୁଇଁ ପା଼ୟାଲି ଏ଼ୱାଣି କ଼ପାଟି ପାରୁ ପାରୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ଜୀସୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଏମ୍ବାଟି ଏଟ୍‌କା ଆ଼ହାନା ହ଼ଚାହାଚେସି, ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁ ତାନି ଜେ଼ଚ ହାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ବାରେଜା଼ଣାତି ର଼ଗଟି ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଇଞ୍ଜାଁ ତାଙ୍ଗେ ଲ଼କୁଇଁ ୱେ଼କ୍‌ଆଦୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ଏ଼ନିକିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି କାତା ସାତା ଆ଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ମେହ୍‌ଦୁ ନା଼ ହ଼ଲେଏସି, ଆମ୍ବାଆରାଇଁ ନା଼ନୁ ଆ଼ଚାମାଇଁ; ଏ଼ୱାସି ନା଼ ଜୀୱୁତି ମୀର୍‌ଏସି, ଆମ୍ବାଆରିତା଼ଣା ନା଼ ହା଼ରେକା ରା଼ହାଁ ମାନେ; ନା଼ନୁ ଏ଼ୱାଣିଲାକ ନା଼ ସୁଦୁଜୀୱୁ ହୀଇଁ, ଅ଼ଡ଼େ ଏ଼ୱାସି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ନୀହାଁୟିତି କାତା ୱେ଼କନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ଏ଼ୱାସି ଗଡ଼୍‌ହା କିଅସିକି କା଼ଲ୍‌ୱି ଆ଼ଅସି, ଇଞ୍ଜାଁ ଆଂଗେଣିତା ଏ଼ୱାଣି ହା଼ଡା ଆମ୍ବାଆରି ୱେନଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ନୀହାଁୟିତା ଜୀଣା ଆ଼ଆପାତେକା, ଏ଼ୱାସି ୱା଼ୟିତି ଡାଣ୍ଡିତି ଡିକ୍‌ଅସି ବ଼ୟିଁ ଆ଼ହିଁ ଡ଼ୀଞ୍ଜିମାନି ଦୀୱଁତି ଡୁପ୍‌ଅସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଅ଼ଡ଼େ ଏ଼ୱାଣି ଦ଼ରୁତା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବା଼ର୍ସୁ ଇଟିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ର଼ ଦିନା ଲ଼କୁ ବୂତୁ ଆଲ୍‌ଗାମାଚି ର଼ କା଼ଣାଇଁ ତାତେରି ଏ଼ୱାଣାଇଁ ବୂତୁ ଆଲ୍‌ଗା ମାଚାକି ଗୁଲା ଆ଼ହାମାଚେସି । ଜୀସୁ ଏ଼ୱାଣାଇଁ ନେହିଁ କିତେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ମେସାଲି ଅ଼ଡ଼େ ଜ଼ଲାଲି ଆ଼ଡିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଈୱାସି ଏ଼ନାଆଁ ଏ଼ ଦାୱୁଦ କୂଡ଼ାତାସି ଆ଼ଏକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ପାରୁସିୟାଁ ଈ କାତା ୱେଞ୍ଜାନା ଏଲେଇଚେରି, ଈ ମାଣ୍‌ସି ବୂତୁୟାଁ କିହାଁ କାଜା ବାଲ୍‌ଜିବୁଲ୍‌ ବୂତୁ ହିଲାଆନା ବୂତୁୟାଁ ପେ଼ର୍‌ଅସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ସାମା ଜୀସୁ ପାରୁସିୟାଁ ମ଼ନତି ଅଣ୍‌ପୁ ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ର଼ ରା଼ଜି ତା଼ନୁ ତା଼ନୁଏ ଆସ୍‌ପି ଆ଼ହାନା ରୀ ବା଼ଗା ତୀନି ବା଼ଗା ଆ଼ତିସାରେ ଏ଼ ରା଼ଜି ଅ଼ଡ଼େ ତୀରିତଲେ ମାଞ୍ଜାଲି ଆ଼ଡେଏ, ଇଞ୍ଜାଁ ର଼ ଗା଼ଡ଼ା କି ର଼ ଇଲୁ କୁଟମି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଆସ୍‌ପି ଆ଼ହାନା ବା଼ଗା ଆ଼ତିସାରେ ତୀରିତଲେ ମାଞ୍ଜାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଇଞ୍ଜାଁ ସୟତାନ ସୟତାନଇଁ ପିସ୍‌ପି କିନେ ଆତିହିଁ ଏ଼ଦି ବା଼ଗା ଆ଼ହାନା ତାନି କ଼ପାଟି ନିଙ୍ଗିତେୟିଏ, ଆତିହିଁ ଏ଼ଦାନି ରା଼ଜି ଏ଼ନିକିଁ ତୀରିଆ଼ହାଁ ଡ଼ୟିନେ ? ");
INSERT INTO kxv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ମୀରୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜେରି, ନା଼ନୁ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ବାଲ୍‌ଜିବୁଲ୍‌ ତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାଇଁ, ଆତିହିଁ ମୀ ମୀର୍‌କା ଆମ୍ବାଆରି ବା଼ଡ଼୍‌ୟୁ ତଲେ ବୂତୁୟାଁ ପେ଼ର୍‌ନେରି । ଈଦାଆଁତାକି ଏ଼ୱାରିଏ ମୀ ନୀହାଁୟି କିୟାନାରି ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ସାମା ନା଼ନୁ ମାହାପୂରୁ ଜୀୱୁତି ବା଼ଡ଼୍‌ୟୁ ତଲେ ବୂତୁୟାଁ ପେ଼ର୍‌ହି ମାଇଁ, ଆତିହିଁ ମାହାପୂରୁତି ରା଼ଜି ମୀ ତା଼ଣା ଏଦାତେୟିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ର଼ ବାଡ଼୍‌ୟୁଗାଟି ଲ଼କୁଇଁ ତଲିଏ ଦହ୍‌ଆନା, ଏ଼ନିକିହିଁ ଏ଼ୱାଣି ଇଜ ହ଼ଡାନା ତାନି ଇଲୁ କା଼ଣ୍ତା ବାରେ ସ଼ରୁ ଅୟାଲି ଆ଼ଡିନେସି ? ଏ଼ୱାଣାଇଁ ତଲିଏ ଦସ୍ତିହିଁଦେ ଏ଼ୱାଣି ଇଲୁ କା଼ଣ୍ତା ସ଼ରୁ ଆ଼ହାଲି ଆ଼ଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଆମ୍ବାଆସି ନା଼ ୱାକିଟି ଆ଼ଆଗାଟାସି, ଏ଼ୱାସି ନା଼ ସାତ୍ରୁ, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ନା଼ ତଲେ କୂଡ଼ି କିଅସି ଏ଼ୱାସି ଆଲାରା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଈଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାଣ୍‌ସି ଲ଼କୁତି ବାରେ ପା଼ପୁ ଅ଼ଡ଼େ ଲାଗେଏ ପ଼ଲେଏଟି ଲ଼କୁଣି ନିନ୍ଦା କାତା ଜ଼ଲାମାନାଣି ମ୍ଣେକ୍‌ହା ତୁସ୍‌ପିଆ଼ନେ, ସାମା ମାହାପୂରୁତି ସୁଦୁଜୀୱୁ ଦ଼ରୁତଲେ ଜ଼ଲିନାଣା ପା଼ପୁ ମେଣ୍‌ଙ୍ଗି କିୱିଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ମାଣ୍‌ସି ମୀର୍‌ଏଣା କ଼ପାଟି ଜ଼ଲିନେସି, ଏ଼ୱାଣି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗି କିୱିଆ଼ନେ, ସାମା ଆମ୍ବାଆସି ମାହାପୂରୁତି ସୁଦୁଜୀୱୁତି କ଼ପାଟି ଜ଼ଲିନେସି, ଈ କା଼ଲାତା କି ଡା଼ୟୁ କା଼ଲାତା ଜିକେଏ ଏ଼ୱାଣି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗି କିୱିଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ମା଼ର୍‌ନୁତି ନେହାୟି ଇଞ୍ଜୁ ଅ଼ଡ଼େ ତାନି ପା଼ଡ଼େୟିତି ନେହାୟି ଇଞ୍ଜୁ, ଆ଼ଆତିଁ ମା଼ର୍‌ନୁତି ଲାଗେଏତାୟି ଇଞ୍ଜୁ ଅ଼ଡ଼େ ତାନି ପା଼ଡ଼େୟିତି ଲାଗେଏତାୟି ଇଞ୍ଜୁ, ଇଚିହିଁ ପା଼ଡ଼େୟି ତଲେ ମା଼ର୍‌ନୁତି ପୁଣ୍‌କି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଆଡ଼େ ରା଼ସ୍‌କା କୂଡ଼ାତେରି, ମୀରୁ ପ଼ଲ୍‌ଆ ଗାଟାତେରି ଆ଼ହାଁ ଏ଼ନିକିଁ ମୀରୁ ନେହିଁ ହା଼ଡା ୱେସାଲି ଆ଼ଡିଦେରି ? ଇଚିହିଁ ହିୟାଁତା ମାନି କାତା ଗୂତି ଜ଼ଲିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ନେହିଁ ଲ଼କୁ ନେହିଁ ମ଼ନ ବିତ୍ରାଟି ନେହିଁ କାତା ହ଼ପ୍‌ନେସି, ଇଞ୍ଜାଁ ପ଼ଲ୍‌ଆ ଗାଟାସି ପ଼ଲ୍‌ଆ ମ଼ନ ବିତ୍ରାଟି ପ଼ଲ୍‌ଆ କାତା ହ଼ପ୍‌ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ସାମା ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ବାରେଜା଼ଣା ତା଼ମ୍ବୁ ୱେସାମାନି ଉଜେଏତି କାତାତାକି ବିଚାରା କିନି ଦିନାତା ଏମ୍ବାତି କାତା ଜ଼ଲିନେରି; ");
INSERT INTO kxv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ଈଦାଆଁତାକି ମୀ ଗୂତିତି ହା଼ଡାତଲେ ନୀହାଁୟି ଦିନାତା ମୀରୁ ଦ଼ହ ଗାଟାତେରି ଅ଼ଡ଼େ ଦ଼ହ ହିଲାଆଗାଟାତେରି ଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ଏଚିବେ଼ଲା ମେ଼ରା ପୁନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଜୀସୁଇଁ ଏଲେଇଚେରି, “ଗୂରୁ, ମା଼ମ୍ବୁ ନୀ ତା଼ଣାଟି ର଼ କାବାଆ଼ନି ସିନା ମେସାଲି ଅଣ୍‌ପିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ପ଼ଲ୍‌ଆ ଗାଟାରି ଅ଼ଡ଼େ ମାହାପୂରୁଇଁ ନାମାଆ ଗାଟାରିଦେହେଁ ସିନାୟାଁ ପାରିନେରି, ସାମା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜୁନସତି ସିନା ପିସ୍‌ପେ ଏ଼ୱାରାକି ଏ଼ନି ସିନା ହୀପ୍‌କି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଇଚିହିଁ ଜୁନସ ଏ଼ନିକିଁ ତୀନିଦିନା ତୀନି ଲା଼ଆଁୟାଁ କାଜା ମୀନୁ ବାଣ୍ତି ବିତ୍ରା ମାଚେସି, ଏଲେକିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ବୂମି ବିତ୍ରା ତୀନିଦିନା ତୀନି ଲା଼ଆଁୟାଁ ଡ଼ୟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ନୀହାଁୟି ଦିନାତା ନିନିବିତି ଲ଼କୁ ଈ କା଼ଲାତି ଲ଼କୁ ନ଼କିତା ନିଚାନା ଏ଼ୱାରାଇଁ ଦ଼ହ କିନେରି, ଇଚିହିଁ ଏ଼ୱାରି ଜୁନସ ୱେସ୍ତି କାତା ଆସାନା ପା଼ପୁଟି ମ଼ନ ୱେଟ୍‌ହା ମାଚେରି, ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଜୁନସକିହାଁ କାଜାସି ଇମ୍ବାଆଁ ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ନୀହାଁୟି ଦିନାତା ସିବା ଦେ଼ସାତି ରା଼ଣି ଈ କା଼ଲାତି ଲ଼କୁ ନ଼କିତା ନିଚାନା ଏ଼ୱାରାଇଁ ଦ଼ହ କିନେ, ଇଚିହିଁ ସଲମନତି ବୁଦିତିକାତା ୱେଞ୍ଜାଲି ଦାର୍‌ତିତି ହେକ ଦେ଼ସାଟି ୱା଼ହାମାଚେ, ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ସଲମନକିହାଁ କାଜା କାତା ଇମ୍ବାଆଁ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ର଼ ପ଼ଲ୍‌ଆ ବୂତୁ ର଼ ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚା ହାଜାନା ଏ଼ୟୁ ହିଲାଆ ଟା଼ୟୁ ବାରେ ରେ଼ଜିହିଁ ଜ଼ମାଲି ଟା଼ୟୁ ପାରୀତେ, ଇଞ୍ଜାଁ ଏ଼ଦାଆଁ ପ୍ଣାଃଆତେ, ");
INSERT INTO kxv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ଏଚେଟିଏ ଏ଼ଦି ଏଲେଇନେ, ନା଼ନୁ ଆମିନି ଇଲୁଟି ହ଼ଚା ୱା଼ହାମାଇଁ, ନା଼ ଏ଼ ଇଲୁତା ୱେଣ୍ତେ ହାଇଁ; ଇଞ୍ଜାଁ ୱେଣ୍ତା ୱା଼ହାନା ୱାର୍‌ଆଣି ଇଞ୍ଜାଁ ଅ଼ଜିତାଣି ମେହ୍‌ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ଏଚିବେ଼ଲା ଏ଼ଦି ହାଜାନା ତାନିକିହାଁ ଆଗାଡ଼ା ପ଼ଲ୍‌ଆଗାଟି ସା଼ତାଗଟା ଜୀୱୁୟାଁ ଆସାନା ୱା଼ନେ, ଇଞ୍ଜାଁ ଏ଼ୱି ବାରେ ଏମ୍ବାଆଁ ହ଼ଡାନା ବାସା କିନୁ, ଅ଼ଡ଼େ ଏ଼ ଲ଼କୁତି ତଲିତି କସ୍ତ କିହାଁ ଡା଼ୟୁତି କସ୍ତ ହା଼ରେକା ଆ଼ନେ, ଈ କା଼ଲାତି ପ଼ଲ୍‌ଆ ଗାଟାରାକି ଜିକେଏ ଏଲେଆ଼ହିଁଏ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜୀସୁ ବାରେ ଲ଼କୁଇଁ ହା଼ଡା ଆ଼ହିମାଚାଟି ତାମି ଇୟା ଅ଼ଡ଼େ ତାୟିୟାଁ ପାଙ୍ଗାତା ନିଚାନା ହା଼ଡା ଆ଼ହାଲି ମ଼ନ କିହିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ଏଚେଟିଏ ରଅସି ୱା଼ହାନା ଜୀସୁଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ମୁ, ମୀ ଇୟା ଅ଼ଡ଼େ ନୀ ତାୟିୟାଁ ପାଙ୍ଗାତା ନିଚାନା ହା଼ଡା ଆ଼ହାଲି ମ଼ନ କିହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ସାମା ଈ କାତା ୱେସ୍ତାଣାଇଁ ଜୀସୁ ଏଲେଇଚେସି, “ଆମ୍ବାଆୟି ମା଼ ଇୟା ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ନା଼ ତାୟିୟାଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ଅ଼ଡ଼େ ସୀସୁୟାଁ ୱାକି କେୟୁ ଦା଼ସାନା ଏଲେଇଚେସି, “ମେହ୍‌ଦୁ ମାୟା ଇଞ୍ଜାଁ ମା଼ ତାୟିୟାଁ, ");
INSERT INTO kxv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଇଚିହିଁ ଆମ୍ବାଆୟି ଜିକେଏ ନା଼ ଲାକପୂରୁତି ଆ଼ବା କାତା ଆହ୍‌ନେସି ଏ଼ୱାସି ନା଼ ତାୟି ଏ଼ଦି ନା଼ ତାଙ୍ଗି ଅ଼ଡ଼େ ମା଼ ଇୟା ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଏ଼ ଦିନା ଜୀସୁ ଇଲୁଟି ହ଼ଚା ହାଜାନା ସାମ୍‌ଦୁରି ଡାକିତା ଲ଼କୁଇଁ ଜା଼ପ୍‌ହାଲି କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ଏଚେଟିଏ ହା଼ରେକା ଲ଼କୁ କୂଡ଼ା ଆ଼ହାଲିଏ, ଏ଼ୱାସି ହାଜାନା ର଼ ଡଂଗତା କୁଗିତେସି, ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ ସାମ୍‌ଦୁରି ଗାଟୁତା ନିଚାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଅ଼ଡ଼େ ଜୀସୁ ପୁଣ୍‌ମ୍ବିକିନି କାତା ହା଼ରେକା ୱେସ୍ତେସି, ଏ଼ୱାସି ଏଲେଇଚେସି । “ମେହ୍‌ଦୁ ର଼ ବିଚା ମାଟିନାସି ମାଟାଲି ହ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ଏ଼ୱାସି ବିଚା ମାଟିନି ବେ଼ଲା କଚେକା ବିଚା ଜିରୁତା ରୀତେ ଇଞ୍ଜାଁ ପଟାୟାଁ ୱା଼ହାନା ଏ଼ ପା଼ଡ଼େୟି ପେର୍‌ହା ତିଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଅ଼ଡ଼େ କଚେକା ବିଚା ୱାଲ୍‌କାତି ପା଼ତାଡ଼ା ବୂମିତା ରୀତେ, ଇଞ୍ଜାଁ ଇର୍‌ଆ ଗାଡି ହିଲାଆତାକି ପା଼ଡ଼େୟି ତବେ ଗଜା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ସାମା ୱେ଼ଡ଼ା ହ଼ଚାଲିଏ, ଗଜା ଆ଼ହାମାଚାୟି ୱେହା ହାଚେ, ଇଞ୍ଜାଁ ତାନି ହୀରୁ ଗାଡି ଡ଼଼ଇକା ହାଲାଆତାକି ୱା଼ୟାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଅ଼ଡ଼େ କଚେକା ବିଚା ହା଼ପ୍‌କା ବୂଟା ଡ଼଼ଇ ରୀତେ, ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ବୂଟାୟାଁ ବାରେ ପାଡାଆ଼ହାନା ଆର୍ନା ଡାକିତି ପ୍ଡିକ୍‌ହାତୁସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ଅ଼ଡ଼େ କଚେକା ବିଚା ନେହିଁ ବୂମିତା ରୀତେ, ଇଞ୍ଜାଁ କାମ୍ବାନା ର଼ ପା଼ଡ଼େୟିଟିଏ ପା଼ସାକ଼ଡ଼ି, ତୀନିକ଼ଡ଼ି ଇଞ୍ଜାଁ କଡ଼େଦସ ପା଼ଡ଼େୟିକା କାମ୍ବିତୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“ଆମ୍ବାଆରାକି କୀର୍କା ମାନୁ ଏ଼ୱାସି ୱେଣ୍‌ମ୍ବାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, “ଲ଼କୁଣି ଜା଼ପ୍‌ନାଟି ନୀନୁ ଏ଼ନାଆଁତାକି ପୁଣ୍‌ମ୍ବିକିନି କାତାୟାଁ ୱେସିହିଁ ଜା଼ପ୍‌ହିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜିତି ବାରେ ଡ଼ୁଗାମାନି ହା଼ଡା ପୁଞ୍ଜାଲି ମିଙ୍ଗେ ବା଼ଡ଼୍‌ୟୁ ହୀପ୍‌କି ଆ଼ହାମାଞ୍ଜାନେ, ସାମା ଏ଼ୱାରାକି ହୀପ୍‌କି ଆ଼ହା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଇଞ୍ଜାଁ ଏମ୍ବାଆରାକି ମାନେ, ଏ଼ୱାରାକି ହୀପ୍‌କିଆ଼ନେ ଅ଼ଡ଼େ ଏ଼ୱାଣାକି ଗାଡିଆ଼ନେ; ସାମା ଆମ୍ବାଆରାକି ହିଲେଏ ତାନିତା଼ଣା ଏ଼ନାୟି ମାନେ, ଏ଼ଦାଆଁ ଜିକେଏ ଅ଼ୱିଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ଏ଼ୱାରି ମେସି ମେସିହିଁ ମେସାଲି ଆ଼ଡଅରି, ଅ଼ଡ଼େ ୱେଞ୍ଜିୱେଞ୍ଜି ୱେନଅରି କି ପୁନଅରି; ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାରାଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଅ଼ଡ଼େ ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି ଈ କାତା ଏ଼ୱାରାକି ସାତା ଆ଼ନେ । ଈ ଲ଼କୁ ୱେଞ୍ଜିୱେଞ୍ଜିହିଁ ୱେନେରି, ଏ଼ନାଆଁ ତେଲ୍‌ହଅରି, ମେସି ମେସିହିଁ ମେହ୍‌ନେରି ସାମା ଏ଼ନାଆଁ ପୁନଅରି; ");
INSERT INTO kxv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଇଚିହିଁ ଈ ଲ଼କୁତି ହିୟାଁ ଅଣ୍‌ପାଲି ଆ଼ଡାଆ ଗାଟାୟି, ଏ଼ୱାରି କସ୍ତଟି କୀର୍କା ତଲେ ୱେଚେରି, ଇଞ୍ଜାଁ ତାମି କାଣ୍‌କା ପଟିତେରି, ଏ଼ନିକିଁ ଏ଼ୱାରି କାଣ୍‌କା ତଲେ ମେହ୍‌ଅରି, ଅ଼ଡ଼େ କୀର୍କା ତଲେ ୱେନଅରି, ଅ଼ଡ଼େ ହିୟାଁ ତଲେ ତେଲ୍‌ହଅରି ଇଞ୍ଜାଁ ଏ଼ୱାରି ନା଼ ତା଼ଣା ୱେଣ୍ଡା ୱା଼ଅରି, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାରାଇଁ ନେହିଁ କିଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ସାମା ନେହେଁ ମୀ କାଣ୍‌କା ଇଚିହିଁ ଏ଼ୱି ମେସି ମାନୁ, ନେହେଁ ମୀ କୀର୍କା ଇଚିହିଁ ଏ଼ୱି ୱେଞ୍ଜିମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଏ଼ନା ଏ଼ନାଆଁ ମେସିମାଞ୍ଜେରି, ଏ଼ ବାରେ ହା଼ରେକା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଇଞ୍ଜାଁ ତୀରିଗାଟାରି ମେସାଲି ମ଼ନ କିତେରି, ସାମା ମେସାଲି ଆ଼ଡାଆତେରି; ଅ଼ଡ଼େ ମୀରୁ ଏ଼ନା ଏ଼ନାଆଁ ୱେଞ୍ଜିମାଞ୍ଜେରି, ଏ଼ ବାରେ ଏ଼ୱାରି ୱେଞ୍ଜାଲି ମ଼ନ କିତେରି, ସାମା ୱେଞ୍ଜାଲି ଆ଼ଡାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ଆତିହିଁ ମୀରୁ ବିଚା ମାଟିନି ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଆମ୍ବାଆସି ମାହାପୂରୁ ରା଼ଜିତି କାତା ୱେଞ୍ଜାନା ପୁନାଆ ଗାଟାସି, ଏ଼ୱାଣି ହିୟାଁତା ୱେସାମାନି ମାହାପୂରୁ ବ଼ଲୁ ସୟତାନ ୱା଼ହାନା ମୀଞ୍ଜା ଅ଼ନେସି, ଏ଼ୱାସି ଜିରୁ ଦାରି ମାଟାମାନି ବିଚା ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ୱାଲ୍‌କା ବୂମିତା ମାଟିତି ବିଚା ଏ଼ୱାସି ଇଲେତାସି, ଆମ୍ବାଆସି ମାହାପୂରୁତି କାତା ୱେଞ୍ଜାନା ରା଼ହାଁତଲେ ନାମିନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ସାମା ଏ଼ୱାଣି ତା଼ଣା ହୀରୁ ଜୀଆତାକି ଗା଼ଡ଼େକେଏ ତୀରିଆ଼ହାନା ମାନେସି, ଡା଼ୟୁ ମାହାପୂରୁ କାତାତାକି ବା଼ଦା ଅ଼ଡ଼େ ନିନ୍ଦା ବେଟାଆ଼ତିସାରେ ଏ଼ ବାରେ ପିସାତୁହ୍‌ନେସି, ଏ଼ୱାସି ୱାଲ୍‌କା ବୂମିତା ରିତି ବିଚା ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଆମ୍ବାଆସି ମାହାପୂରୁତି କାତା ୱେନେସି, ଇଞ୍ଜାଁ ଦାର୍‌ତିତି ଅଣ୍‌ପୁ ଦ଼ନତି ଜୂପ୍‌କା ଏ଼ୱାସି ୱେଞ୍ଜାମାନି କାତାତି ପ୍ଡିକ୍‌ହା ତୁସାଲିଏ, ତାନି ଜୀୱୁତା ପା଼ଡ଼େୟି କାମ୍ବାଆତେ, ଏ଼ୱାସି ହା଼ପ୍‌କା ବୂଟା ଡ଼଼ଇ ରିତି ବିଚା ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ସାମା ଆମିନିଗାଟାସି କାତାତି ୱେନେସି ଇଞ୍ଜାଁ ନେହିଁକିଁ ପୁନେସି, ଅ଼ଡ଼େ ନେହିଁ ପା଼ଡ଼େୟି କାମ୍ବିନେସି, ଆମ୍ବାଆସି ପା଼ସାକ଼ଡ଼ି, ଆମ୍ବାଆସି ତୀନିକ଼ଡ଼ି, ଆମ୍ବାଆସି କଡ଼େଦସ ପା଼ଡ଼େୟିକା, ଏ଼ୱାସି ନେହିଁ ବୂମିତା ରିତି ବିଚା ଲେହେଁତାସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜୀସୁ ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ଲାକପୂରୁ ରା଼ଜି ରଅସି ତାନି ଗୁଡିୟାତା ନେହିଁ ବିଚା ମାଟାମାନି ମାଣ୍‌ସିଲେହେଁ; ");
INSERT INTO kxv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ସାମା ଲ଼କୁ ଡୂରାମାନାଟି ତାନି ସାତ୍ରୁ ୱା଼ହାନା ଏ଼ ଗ଼ହଁୟାଁ ବିତ୍ରା ଟଲି ଜା଼ଡ଼ାତି ବିଚା ମାଟାନା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଏଚିବେ଼ଲା ଗ଼ହଁୟାଁ ପାଡାଆ଼ହାନା ଜେ଼କା ଆ଼ନିବେଲା ଟଲି ଜା଼ଡ଼ା ଜିକେଏ ତ଼ଞ୍ଜାଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ଏଚେଟିଏ ସା଼ୱୁକାରିତି ହ଼ଲିୟାଙ୍ଗା ତାନି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, ବା଼ବୁ, ନୀନୁ ଏ଼ନାଆଁ ନୀ ଗୁଡିୟାତା ନେହିଁ ବିଚା ମାଟା ହିଲାଆତି ? ସାମା ଈ ଟଲି ଜା଼ଡ଼ା ବାରେ ଏମ୍ବିଟି ୱା଼ତେ ? ");
INSERT INTO kxv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ର଼ ସାତ୍ରୁ ଈଦାଆଁ କିହାମାନେସି । ଅ଼ଡ଼େ ହ଼ଲିୟାଙ୍ଗା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, ନୀ ମ଼ନ ଏ଼ନାୟି, ମା଼ମ୍ବୁ ହାଜାନା ଟଲି ରେଜାନା କୂଡ଼ି କିନମି, ");
INSERT INTO kxv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ସାମା ଏ଼ୱାସି ଏଲେଇଚେସି, ଆ଼ଏ ଏଚେ଼ତା ମୀରୁ ଟଲି ଜା଼ଡ଼ା ରେ଼ଜି ରେ଼ଜିହିଁ ଗ଼ହଁୟାଁ ଜିକେଏ ରେଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ଗ଼ହଁ ଦା଼ଃନି ପାତେକା ଗ଼ହଁ ଅ଼ଡ଼େ ଟଲି ଜା଼ଡ଼ା ରହେଁଏ ପାଡାଆ଼ପୁ, ଅ଼ଡ଼େ ଆର୍ନା ଦା଼ଃନି ବେ଼ଲାତା ଦା଼ଃଆନାରାଇଁ ନା଼ନୁ ଏଲେଇଇଁ, ତଲିଏ ଟଲି ଜା଼ଡ଼ା ଦା଼ଚାନା ହୂଡାଲିତାକି ପେ଼ଣ୍ତାୟାଁ ଏଟ୍‌କା କିଦୁ, ସାମା ଗ଼ହଁୟାଁ କୂଡ଼ି କିହାନା ନା଼ ଗା଼ଦେୟିତା ଇଟାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜୀସୁ ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ଲାକପୂରୁ ରା଼ଜି ର଼ ହାର୍ସୁ ପା଼ଡ଼େୟି ଲେହେଁତାୟି, ଏ଼ଦାଆଁ ଅ଼ହାନା ରଅସି ତାନି ବା଼ଡ଼ାତା ମାଟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ଏ଼ ପା଼ଡ଼େୟି ବାରେ ପା଼ଡ଼େୟିକା କିହାଁ ଊଣା, ସାମା ଏ଼ଦି ପାଡା ଆ଼ତିସାରେ ବାରେ କୁଚା କିହାଁ କାଜାୟି ଆ଼ହାଁ ଇଲେତି ମା଼ର୍‌ନୁ ଆ଼ନେ, ଇଞ୍ଜାଁ ହା଼ଗୁତା ଊମ୍ବିମାନି ପଟାୟାଁ ୱା଼ହାନା ଏ଼ଦାନି କମାତା ବ଼ଣ କିହାନା ବାସା କିନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜୀସୁ ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ଲାକପୂରୁ ରା଼ଜି ର଼ ପୁଲା ଏ଼ୟୁଲେହେଁତାୟି; ର଼ ଇୟା ଗ଼ହଁୟାଁ ଗୁଣ୍ତାତା ପୁଲାଏ଼ୟୁ କାଲ୍‌ହାନା ଇଟିତେ, ଏଚେଟିଏ ଏ଼ ଗୁଣ୍ତା ପ଼ଙ୍ଗାନା ବାରେ ପୁଲା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଈ ବାରେ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ଜୀସୁ ଲ଼କୁଣି ୱେସ୍ତେସି, ଇଞ୍ଜାଁ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଆଟ୍‌ଆନା ଏ଼ନାଆଁୱା ଲ଼କୁଣି ୱେସି ହିଲାଆତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଏ଼ନିକିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଣି ତା଼ଣାଟି ଈ କାତା ସାତା ଆ଼ନେ, “ନା଼ନୁ ନା଼ ଗୂତି ଏ଼କ୍‌ହାନା ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେହ୍‌ଇଁ; ଦାର୍‌ତି ଗା଼ଡ଼ି ଆ଼ତି ଦିନାଟିଏ ଡ଼ୁଗାମାନି କାତା ବାରେ ୱେହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ଡା଼ୟୁ ଜୀସୁ ମାନ୍ଦା ଲ଼କୁଣି ପିସାନା ଇଲୁ ବିତ୍ରା ହାଚେସି, ଇଞ୍ଜାଁ ତାମି ସୀସୁୟାଁ ଡାଗେ ୱା଼ହାନା ଏଲେଇଚେରି, “ଗୁଡିୟାତି ଟଲି ଜା଼ଡ଼ାତି ପୁଣ୍‌ମ୍ବି କିନି କାତା ମାଙ୍ଗେ ନେହିଁକିଁ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜୀସୁ ଏଲେଇଚେସି, “ନେହିଁ ବିଚା ମାଟିନାସି ଏ଼ୱାସି ମାଣ୍‌ସି ମୀର୍‌ଏସି; ");
INSERT INTO kxv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ଈ ଦାର୍‌ତି ଆ଼ହିମାନେ ଗୁଡିୟା, ନେହିଁ ବିଚା ମାହାପୂରୁ ରା଼ଜିତି ମୀର୍‌କା ମା଼ସ୍‌କା; ଟଲି ଜା଼ଡ଼ା ସୟତାନତି ମୀର୍‌କା ମା଼ସ୍‌କା; ");
INSERT INTO kxv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଆମିନି ସାତ୍ରୁ ଏ଼ଦାଆଁ ମାଟିତେସି ଏ଼ୱାସି ସୟତାନ; ଆର୍ନା ଦା଼ଃନି ଦିନା ଇଚିହିଁ ଜୁଗୁ ରା଼ନି ଦିନା, ଇଞ୍ଜାଁ ଆର୍ନା ଦା଼ଃଆନାରି ମାହାପୂରୁତି ଦୂତୁୟାଁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଇଚିହିଁ ଟଲି ଜା଼ଡ଼ାତି ଏ଼ନିକିଁ ର଼ ତା଼ଣା କୂଡ଼ି କିହାନା ହିଚୁତା ହୂଡିନାୟି, ଜୁଗୁ ରା଼ନି ଦିନାତା ଜିକେଏ ଏଲେକିହିଁ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ମାଣ୍‌ସି ମୀର୍‌ଏସି ତାନି ଦୂତୁୟାଁଣି ପାଣ୍ତିନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ତାନି ରା଼ଜିତି ବାରେ ଲାଗେଏ ପ଼ଲେଏତାରାଇଁ ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରାଇଁ ରୁଣ୍ତା କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେତ୍‌ନେରି, ଏମ୍ବାଆଁ ଏ଼ୱାରି ଡ଼ୀହିଁ ପାଲ୍‌କା ଟୀଟି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ଏଚିବେ଼ଲା ତୀରିଗାଟାରି ତାମି ଆ଼ବା ରା଼ଜିତା ୱେଡ଼ାଲେହେଁ ଡ଼ୀଞ୍ଜିହିଁ ତ଼ଞ୍ଜାଆ଼ନେରି । ଆମ୍ବାଆରାକି କୀର୍କା ମାନୁ ଏ଼ୱାରି ୱେଣ୍‌ମ୍ବାରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ଲାକପୂରୁ ରା଼ଜି ଗୁଡିୟାତା ଡ଼ୁଗାମାନି ଦ଼ନ ଲେହେଁତାୟି, ରଅସି ଏ଼ଦାଆଁ ମେସାନା ଡ଼ୁକ୍‌ହା ଇଟିତେସି, ଅ଼ଡ଼େ ରା଼ହାଁଟି ହାଜାନା ତାନି ଈସିତୀସି ଆ଼ସ୍ତି ପାର୍‌ଚାନା ୱେଣ୍ତେ ହାଜାନା ଏ଼ ଗୁଡିୟାତି କଡିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ଅ଼ଡ଼େ ଲାକପୂରୁ ରା଼ଜି ନେହିଁ ଅପ୍‌ନି ୱାଲି ପାରିମାନି ର଼ ବେ଼ବାରା କିନାଣିଲେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ର଼ ଦାରାଗାଟି ଅପ୍‌ନି ୱାଲି ମେସାନା ଏ଼ୱାସି ହାଜାନା ତାନି ଈସିତୀସି ଆ଼ସ୍ତି ପାର୍‌ଚାନା ଏ଼ ଅପ୍‌ନି ୱାଲିତି କଡିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ଅ଼ଡ଼େ ଜିକେଏ ଲାକପୂରୁ ରା଼ଜି ସାମ୍‌ଦୁରିତା ବାରେ କୂଡ଼ାତି ମୀଣ୍‌କା ଆସାଲି ମେତ୍‌ନି ଜା଼ଲା ଲେହେଁତାୟି । ");
INSERT INTO kxv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଏ଼ ଜା଼ଲା ନେଞ୍ଜାଲିଏ ମୀଣ୍‌କା ଆହ୍‌ନାରି ଏ଼ଦାଆଁ ସାମ୍‌ଦୁରି ଗାଟୁତା ରେଜା ତାନେରି, ଇଞ୍ଜାଁ କୁଗାନା ନେହାଁଆଁ ବାରେ ରୁଣ୍ତା କିହାନା ତିରିତା ଇଟିନେରି, ସାମା ଲାଗେଏ ପ଼ଲେଏ ଗାଟାଆଁ ବାରେ କୁତା ତୁହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗୁ ରା଼ନି ଦିନାତା ଏଲେକିହିଁ ଆ଼ନେ; ଦୂତୁୟାଁ ହ଼ଚାୱା଼ହାନା ତୀରିଗାଟାରି ତା଼ଣାଟିଏ ଲାଗେଏ ପ଼ଲେଏତାରାଇଁ ଏଟ୍‌କା କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେତ୍‌ହା ତୁହ୍‌ନେରି, ଏମ୍ବାଆଁ ଡ଼ୀନାୟି ଅ଼ଡ଼େ ପାଲ୍‌କା ଟୀଟି କିନାୟି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜୀସୁ ସୀସୁୟାଁଇଁ ୱେଚେସି, “ମୀରୁ ଈ ବାରେ କାତା ପୁଚେରି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ହାଅ ପ୍ରବୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ଆମିନି ଇଲୁଗାଟାସି ତାନି ଇଲୁଟି ପୁଃନାଣି ପ୍ଣାଃଆଣି ହ଼ପ୍‌ନେସି, ଲାକପୂରୁ ରା଼ଜିତି ସୀସୁ ଆ଼ହାମାନି ବାରେ ମେ଼ରା ପୁନାରି ଏ଼ୱାଣି ଲେହେଁତାରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜୀସୁ ଈ ବାରେ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସାଲି ଆ଼ଡାଲିଏ, ଡା଼ୟୁ ଏମ୍ବାଟିଏ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଇଞ୍ଜାଁ ଏ଼ୱାସି ତା଼ନୁ ପାଡାଆ଼ତି ନା଼ୟୁଁତା ୱା଼ହାନା ଲ଼କୁଣି ତାମି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଇଲେକିହିଁ ଜା଼ପ୍‌ହେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଈୱାଣାକି ଇଲେତି ବୁଦି ଇଞ୍ଜାଁ ଇଲେତି କାବାଆ଼ନି କାମା କିହାଲି ଆମ୍ବିଟି ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ତେସି ? ");
INSERT INTO kxv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଈୱାସି ଏ଼ ବାଡିୟାତି ମୀର୍‌ଏସି ଆ଼ଏକି ? ଈୱାଣି ଇୟା ମରିୟମ ଆ଼ଏ ? ଅ଼ଡ଼େ ଈୱାଣି ତାୟିୟାଁ ଦ଼ର୍‌କା ଜାକୁବ, ଜସେପ, ସିମନ ଇଞ୍ଜାଁ ଜୀହୁଦା ଆ଼ଏ ? ");
INSERT INTO kxv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ଅ଼ଡ଼େ ଈୱାଣି ତାଙ୍ଗିସ୍କା ମା଼ ତଲେ ହିଲାଉ ? ଇଞ୍ଜାହାଁ ଈୱାସି ଏ଼ ବାରେ ଆମ୍ବିଟି ମେ଼ଡ଼ାଆ଼ତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜୀସୁଇଁ ଅ଼ପାଆତେରି । ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ନିଜେତି ନା଼ୟୁଁତା ଇଞ୍ଜାଁ ନିଜେତି ଇଲୁ କୁଟମିତା ମା଼ନି ପ୍ଣାଃଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଅ଼ଡ଼େ ଏ଼ୱାରି ନାମାଆତାକି ଏ଼ୱାସି ଏମ୍ବାଆଁ ହା଼ରେକା କାବାଆ଼ନି କାମା କିଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ଏଚିବେ଼ଲାତା ଗାଲିଲିତି ସା଼ଲୱି କିନି ରାଜା ହେରଦ ଜୀସୁତି କାବ୍ରୁ ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ଅ଼ଡ଼େ ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ଏଲେଇଚେସି, “ଈୱାସି ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ଏ଼ୱାସି ହା଼ତାରି ତା଼ଣାଟି ନିଙ୍ଗାମାନେସି, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ବା଼ଡ଼୍‌ୟୁ ଏ଼ୱାଣି ତା଼ଣା କାମା କିହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ଇଚିହିଁ ତଲି ହେରଦ ତାମି ତାୟି ପିଲିପ ଡକ୍ରି ହେରଦିୟାନି ତାକି ଜହନଇଁ ଦସ୍‌ପା ତାଚାନା କା଼ୟିଦି ଇଲୁତା ଇଟାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଇଚିହିଁ ଜହନ ତାଙ୍ଗ ଏଲେଇଞ୍ଜିମାଚେସି, ହେରଦିୟାନି ଇଟିନାୟି ନୀ ମେ଼ରା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଅ଼ଡ଼େ ହେରଦ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ମ଼ନ କିତି ଜିକେଏ ଲ଼କୁଣି ଆଜିମାଚେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଇଞ୍ଜିଁ ମା଼ନି କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ସାମା ହେରଦତି ଜାର୍ନା ଦିନା ୱା଼ହାଲିଏ, ହେରଦିୟାତି ମା଼ଙ୍ଗା ରୁଣ୍ତା ଆ଼ହାମାଚି ଲ଼କୁ ନ଼କିତା ଏ଼ନ୍ଦାନା ହେରଦଇଁ ରା଼ହାଁ କିୱିକିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ଏଚେଟିଏ ଏ଼ୱାସି ପାର୍‌ମାଣା କିହାନା ଆ଼ଞ୍ଜିତେସି, ନୀନୁ ନାଙ୍ଗେ ଏ଼ନାଆଁ ରୀସ୍ତାତିହିଁ ଏ଼ଦି ନିଙ୍ଗ ହୀପ୍‌କିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ଇଞ୍ଜାଁ ଏ଼ଦି ତାମି ଇୟାନି କାତା ଆସାହାଁ ଏଲେଇଚେ, “ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି ତା଼ର୍ୟୁଁ ନୀଏଁ ଇମ୍ବାଆଁ ର଼ ସାଡ଼୍‌ୱାତା ନାଙ୍ଗେ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଈଦାଆଁ ୱେଞ୍ଜାନା ରାଜା ଦୁକୁ ଆ଼ତିହିଁ ଜିକେଏ ତା଼ନୁ ପାର୍‌ମାଣା କିହାଁ ଆ଼ଞ୍ଜାମାଚାକି ଅ଼ଡ଼େ ତାନିତଲେ ବ଼ଜିତା କୁଗାମାଚାରି ନ଼କିତା ଆ଼ଞ୍ଜାମାଚାକି ଏ଼ଦାନି ମ଼ନଲେହେଁ ହୀହାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଇଞ୍ଜାଁ ଲ଼କୁଣି ପାଣ୍ତାନା କା଼ୟିଦି ଇଲୁତା ଜହନତି ତା଼ର୍ୟୁଁ ଦା଼ପିକିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ଅ଼ଡ଼େ ଏ଼ୱାଣି ତା଼ର୍ୟୁଁ ର଼ ସାଡ଼୍‌ୱାତା ତାଚାନା ଏ଼ ପ଼ଦାକି ହୀତେରି, ଇଞ୍ଜାଁ ଏ଼ଦି ଅ଼ହାନା ତାମି ଇୟାନି ତା଼ଣା ଅ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ଏଚେଟିଏ ଜହନତି ସୀସୁୟାଁ ୱା଼ହାନା ମାଡ଼୍‌ହା ଅ଼ହାନା ମୁସ୍ତେରି, ଅ଼ଡ଼େ ହାଜାନା ଜୀସୁଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଜହନ ହା଼ତି କାବ୍ରୁ ୱେଞ୍ଜାନା, ଜୀସୁ ର଼ ଡଂଗତା କୁଗାନା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଚେସି, ଲ଼କୁ ଈ କାତା ୱେଞ୍ଜାନା ଗା଼ଡ଼ାୟାଁଟି ୱା଼ହାନା ତା଼କି ତା଼କିହିଁ ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଅ଼ଡ଼େ ଏ଼ୱାସି ଡଂଗଟି ରେ଼ଚାନା ମାନ୍ଦା ଲ଼କୁଣି ମେସାନା କାର୍ମା ଆ଼ହାନା ଏ଼ୱାରି ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ୱେ଼ଡ଼ା ହାଜାଲିଏ ତାନି ସୀସୁୟାଁ ତାନି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଈ ଟା଼ୟୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁ ଇଞ୍ଜାଁ ଆନ୍ଦେରି ଜିକେଏ ଆ଼ହିମାନେ; ଏ଼ଦାଆଁତାକି ବାରେ ଲ଼କୁ ଏ଼ନିକିଁ ନା଼ସ୍‌କାଣାଁ ହାଜାନା ତାମ୍‌ଙ୍ଗେ ତାକି ଲ଼ହଡ଼ି ପାରିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରାଇଁ ହାଜାଲି ହେଲ ହୀମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ୱାରି ହାନି ଲ଼ଡ଼ା ଆ଼ଏ, ମୀରୁ ଏ଼ୱାରାକି ତିଞ୍ଜାଲି ହୀଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମାଙ୍ଗେ ଇମ୍ବାଆଁ ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କା ମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ୱାଆଁ ଇମ୍ବାଆଁ ନା଼ ତା଼ଣା ତାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଅ଼ଡ଼େ ଏ଼ୱାସି ଲ଼କୁଣି ଗାର୍କି ଜା଼ଡ଼ା ଲାକ କୁଗାଲି ହୁକୁମି ହୀତେସି, ଅ଼ଡ଼େ ଏ଼ ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କାଣି ଅ଼ହାନା ଲାକପୂରୁ ୱାକି ସିନିକିହାନା ମାହାପୂରୁଇଁ ଜହରା କିତେସି, ଇଞ୍ଜାଁ ରୂଟି ଡ଼ିକ୍‌ହାନା ତାମି ସୀସୁୟାଁକି ହୀତେସି, ଏଚେଟିଏ ସୀସୁୟାଁ ବାରେ ଲ଼କୁକି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ଏଚେଟିଏ ବାରେଜା଼ଣା ତିଞ୍ଜାନା ପାଞ୍ଜିତେରି, ଇଞ୍ଜାଁ ସୀସୁୟାଁ ହା଼ରାମାଚି ରୂଟି ଗାଣ୍ତ୍ରାୟାଁ କୂଡ଼ି କିହାନା ବା଼ରଗଟା ଡାଲିତା ନେଞ୍ଜିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ରା଼ନ୍ଦା ତିଚି ଲ଼କୁ ଇୟାସିକା ଇଞ୍ଜାଁ କକାରି ପ଼ଦାଁଣି ପିସାନା ବାରେ ପା଼ସାମା଼ଣା ଆ଼ବାୟାଁ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ଏ଼ ଦେବୁଣିଏ ଜୀସୁ ତାନି ସୀସୁୟାଁଣି ଡଂଗତା ଏ଼କ୍‌ହାନା ସାମ୍‌ଦୁରି ଆତାଲାୱାକି ତାନି ନ଼କିତା ହାଜାଲି ଏଲେଇଚେସି, ଏଚେଟିଏ ବାରେ ଲ଼କୁଣି ହାଜାଲି ହେଲ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ଜୀସୁ ଲ଼କୁଣି ହେଲ ହୀତି ଡା଼ୟୁ ପ୍ରା଼ତାନା କିହାଲି ହ଼ରୁ ଲାକ ହାଚେସି, ଇଞ୍ଜାଁ ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ଏ଼ୱାସି ଏମ୍ବାଆଁ ରଅସିଏ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ସାମା ଏଚିବେ଼ଲା ଡଂଗ ସାମ୍‌ଦୁରି ଗାଟୁଟିଏ ହା଼ରେକା ହେକ ମାଚେ, ଇଞ୍ଜାଁ ସାମ୍‌ଦୁରିତା ଗା଼ଲି ୱେ଼ଚାଲିଏ ଏ଼ ଡଂଗ ୱୀଡିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ସାମା ୱେ଼ୟା ନେ଼କେରି ଜୀସୁ ଏ଼ୟୁ ଲାକ ତାକି ତା଼କିହିଁ ସୀସୁୟାଁ ଡାଗେ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ଅ଼ଡ଼େ ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏ଼ୟୁ ଲାକ ତା଼କି ମାନାଣି ମେସାନା ଆଜାହାଚେରି, ଇଞ୍ଜାଁ ଏଲେଇଚେରି, “ଈଦି ର଼ ବୂତୁ !” ଇଞ୍ଜିଁ ଆଜିତାକି କିର୍‌ଡ଼ିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ସାମା ଜୀସୁ ଦେବୁଣିଏ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ସା଼ସା ଆହ୍‌ଦୁ ଆଜାଆଦୁ ନା଼ନୁ ଜୀସୁତେଏଁ !” ");
INSERT INTO kxv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଏଚେଟିଏ ପିତର ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ସାତେଏ ନୀନୁ ଇଚିହିଁ ଏ଼ୟୁଲାକଟି ତା଼କିହିଁ ନୀପ ୱା଼ହାଲି ହୁକୁମି ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜୀସୁ ଏଲେଇଚେସି “ୱା଼ମୁ !” ଏଚେଟିଏ ପିତର ଡଂଗଟି ରେ଼ଚାନା ଜୀସୁ ତା଼ଣା ଏ଼ୟୁଲାକଟି ତା଼କିହିଁ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ସାମା ଗା଼ଲି ମେସାନା ଆଜିତେସି, ଇଞ୍ଜାଁ ଏ଼ୟୁଣାଁ ମୁଞ୍ଜିହିଁ ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନାଙ୍ଗେ ଗେଲ୍‌ପାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଏ଼ ଦେବୁଣିଏ ଜୀସୁ କେୟୁ ଦା଼ସାନା ପିତରଇଁ ଆସାନା ଏଲେଇଚେସି, “ଏ଼ ଊଣା ନାମୁ ଗାଟାତି ! ଏ଼ନାଆଁ ତାକି ଆନାମାନା ଆ଼ତି ?” ");
INSERT INTO kxv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଅ଼ଡ଼େ ଏ଼ୱାରି ଡଂଗତା ହ଼ଚାଲିଏ ଗା଼ଲି ଡୂଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ଏଚେଟିଏ ଡଂଗତା ମାଚି ସୀସୁୟାଁ ଜୀସୁଇଁ ଜହରା କିହାନା ଏଲେଇଚେରି, “ନୀନୁ ସାତେଏ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ।” ");
INSERT INTO kxv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଏ଼ୱାରି ସାମ୍‌ଦୁରି ଗା଼ଣ୍‌ଚାନା ଗେନେସର ରା଼ଜିତା ଏତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଅ଼ଡ଼େ ଏମ୍ବାତି ଲ଼କୁ ଜୀସୁଇଁ ପୁଞ୍ଜାନା ସା଼ରିୱାକି ମାନି ବାରେ ରା଼ଜିତା କାବ୍ରୁ ପାଣ୍ତିତେରି, ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ ର଼ଗ ଗାଟାରାଇଁ ଜୀସୁ ତା଼ଣା ତାତେରି; ");
INSERT INTO kxv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଅ଼ଡ଼େ ର଼ଗ ଗାଟାରି ଜୀସୁତି ହିମ୍ବରି କୁଙ୍ଗୁ ଡୀଗିନେରି, ଏ଼ଦାଆଁତାକି ଜୀସୁଇଁ ବାତିମା଼ଲିତେରି, ଇଞ୍ଜାଁ ଏଚେକା ଲ଼କୁ ଡୀଗିତେରି ବାରେ ନେହିଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଏଚିବେ଼ଲାତା ଜିରୁସାଲମଟି ପାରୁସିୟାଁ ଇଞ୍ଜାଁ ମେ଼ରାପୁନାରି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ନୀ ସୀସୁୟାଁ ଏ଼ନାଆଁତାକି ତଲିତି ଆକୁ ଆ଼ବାୟାଁ ଜା଼ପ୍‌ହି ମେ଼ରା ମା଼ନି କିହିହିଲଅରି ? ଇଚିହିଁ ରା଼ନ୍ଦା ତିନାଟି କେସ୍କା ନର୍‌ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁତାକି ମୀରୁ ଜିକେଏ ମୀ ପା଼ଣାପା଼ଟୁ ମେ଼ରାତାକି ମାହାପୂରୁତି ହୁକୁମି ମା଼ନୱି ଆ଼ହି ହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ମାହାପୂରୁ ଏଲେଇଞ୍ଜା ମାନେସି ଇୟା ଆ଼ବାଇଁ ମା଼ନି କିଦୁ, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଇୟା କି ଆ଼ବାଇଁ ବା଼କା ଇଟିନେସି ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ସାମା ମୀରୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜେରି, ଆମ୍ବାଆସି ଆ଼ପେସି ତାମି ଇୟା କି ଆ଼ବାଇଁ ଏଲେଇନେସି, ନା଼ ତା଼ଣାଟି ମିଙ୍ଗେ ଏ଼ନାଆଁ ହିୟାତିହିଁ ନେହେଁ ଆ଼ତେମା, ଏ଼ ବାରେ ମାହାପୂରୁକି ହେର୍‌ପି ଆ଼ହାମାନେ, ");
INSERT INTO kxv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ଏ଼ୱାସି ସାତେଏ ତାମି ଇୟା ଆ଼ବାଇଁ ମା଼ନି କିଅସି । ଇଲେକିହିଁ ମୀରୁ ମୀ ପା଼ଣାପା଼ଟୁ ମେ଼ରା ତଲେ ମାହାପୂରୁ କାତା ଉଜେଏ କିହିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଆଡ଼େ କୁଟୁ ଗାଟାତେରି, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ମିଙ୍ଗେତାକି ନେହିଁକିଁ ଈ କାତା ୱେସାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ଈ କୂଡ଼ାତାରି ୱାର୍‌ଇ ଗୂତି ତଲେ ସେ଼ବା କିୟାନେରି, ସାମା ଏ଼ୱାରି ହିୟାଁ ନା଼ ତା଼ଣାଟି ହେକ ଡ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ଏ଼ୱାରି ମାଣ୍‌ସି କେ଼ପିତି ପା଼ଣା ପା଼ଟୁତି ଦାର୍ମୁତି ନେହିଁ କାତା ଇଞ୍ଜିଁ ଜା଼ପ୍‌ହାନା, ଉଜେଏ ନାଙ୍ଗେ ସେ଼ବା କିହିମାଞ୍ଜାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ଅ଼ଡ଼େ ଜୀସୁ ଲ଼କୁଣି ଡାଗେ ହା଼ଟାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ୱେଞ୍ଜୁ ଇଞ୍ଜାଁ ପୁଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ମାଣ୍‌ସି ଗୂତି ବିତ୍ରା ଏ଼ନାୟି ହ଼ଡ଼୍‌ନେ ଏ଼ଦି ଏ଼ୱାଣାଇଁ ଲାଗେଏ କିଏ, ସାମା ଗୂତି ବିତ୍ରାଟି ଏ଼ନାୟି ହ଼ନେ ଏ଼ଦି ମାଣ୍‌ସିଇଁ ଲାଗେଏ କିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ଏଚିବେ଼ଲା ସୀସୁୟାଁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, ପାରୁସିୟାଁ ଈ କାତା ୱେଞ୍ଜାନା କସ୍ତ ବେଟାଆ଼ହି ମାନେରି ଈଦାଆଁ ନୀନୁ ପୁଞ୍ଜା ମାଞ୍ଜିକି ? ");
INSERT INTO kxv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ ଲାକପୂରୁତି ଆ଼ବା ଆମିନି ମା଼ର୍‌ନୁ ଉହା ହିଲଅସି ଏ଼ ବାରେ ରେୱି ଆ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ପାରୁସିୟାଁ କାତା ୱେନାଆଦୁ, ଏ଼ୱାରି କା଼ଣାୟାଁ ଆ଼ହାନା କା଼ଣାୟାଁଇଁ ଜିରୁ ତ଼ହ୍‌ନେରି, ଇଞ୍ଜାଁ କା଼ଣା ଅ଼ର କା଼ଣାଇଁ ଜିରୁ ତ଼ସ୍ତିହିଁ ରିଆରି ଜିକେଏ ଗା଼ଡ୍‌ୟୁତା ତର୍‌ଗିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ପିତର ଏଲେଇଚେସି, “ଏ଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ମାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜୀସୁ ଏଲେଇଚେସି, “ମୀରୁ ଜିକେଏ ନୀଏଁ ପାତେକା ପୁନାଆ ଗାଟାତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଏ଼ନାୟି ଗୂତିଟି ହ଼ଡ଼୍‌ନେ ଏ଼ଦି ବାଣ୍ତିତା ହାଜାନା ଏ଼ଦି ବାଣ୍ତିହାନିଲେହେଁ ହ଼ଚା ହାନେ, ଈଦାଆଁ ପୁଞ୍ଜି ହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ସାମା ଗୂତିଟି ଏ଼ନାୟି ହ଼ଚିମାନେ ଏ଼ଦି ହିୟାଁଟି ହ଼ଚିମାନେ ଏ଼ଦିଏ ମାଣ୍‌ସିଇଁ ଲାଗେଏ କିହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଇଚିହିଁ ହିୟାଁଟି ଲାଗେଏତି ଅଣ୍‌ପୁ ହ଼ନେ, ଇଚିହିଁ ଲ଼କୁଣି ପା଼ୟିନାୟି, ଦା଼ରି କାମା କିୟାଲି, ଲାଗେଏ ପ଼ଲେଏ କାମା କିହାଲି, ସ଼ରୁ କାମା କିହାଲି, ମିଚି ସା଼କି ହୀହାଲି ଇଞ୍ଜାଁ ନିନ୍ଦା କାତା ଜ଼ଲାଲି; ");
INSERT INTO kxv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଈ ବାରେ କାମା ମାଣ୍‌ସିଇଁ ଲାଗେଏ କିନେ, ସାମା କେୟୁ ନର୍‌ଆନା ତିନାୟି ମାଣ୍‌ସିଇଁ ଲାଗେଏ କିଏ । ");
INSERT INTO kxv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜୀସୁ ଏ଼ ଟା଼ୟୁ ପିସାନା ସ଼ର ଅ଼ଡ଼େ ସିଦନ ରା଼ଜିତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଏ଼ ହାନ୍ଦିଟି କିଣାନ ଦେ଼ସାତି ର଼ ଇୟା ୱା଼ହାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେ, “ଏ଼ ପ୍ରବୁ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ଇଚିହିଁ ନା଼ ମା଼ଙ୍ଗାନି ହା଼ରେକା ଆଜିହ଼ପେତି ବୂତୁ ଆସାନା କସ୍ତ ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ସାମା ଜୀସୁ ଏ଼ଦାନି ର଼ ପଦୁ ଜିକେଏ ଜ଼ଲାଆତେସି । ଇଞ୍ଜାଁ ତାନି ସୀସୁୟାଁ ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଈଦାନି ହେଲ ହୀହାନା ପାଣ୍ତାତୁହ୍‌ମୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଈଦି ମା଼ ଜେ଼ଚ କା଼ଲ୍‌ୱି ଆ଼ହିମାନେ !” ");
INSERT INTO kxv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ଇସ୍ରାୟେଲ କୂଡ଼ାତା ଜା଼ଙ୍ଗାମାନି ମେ଼ଣ୍ତାୟାଁ ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆରି ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ଏ଼ ଇୟା ୱା଼ହାନା ଜହରା କିହାନା ଏଲେଇଚେ, “ଏ଼ ପ୍ରବୁ ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ମୀର୍‌କା ମା଼ସ୍‌କା କା଼ଦି ଅ଼ହାନା ନେସ୍‌କା ଡାଗେ ମେତ୍‌ନାୟି ନେହେଁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ଏ଼ ଇୟା ଏଲେଇଚେ, “ହାଅ ପ୍ରବୁ ଇଚିହିଁ ନେସ୍‌କା ତାମି ସା଼ୱୁକାରିୟାଁ ତା଼ଣାଟି ତର୍‌ଗାମାନି ଜୁଟା ରା଼ନ୍ଦା ପେର୍‌ହା ତିନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଏଚେଟିଏ ଜୀସୁ ଏ଼ ଇୟାନି ଏଲେଇଚେସି, “ଏ଼ ଇୟା ନୀଦି ହା଼ରେକା କାଜା ନାମୁ ନୀ ମ଼ନ ଲେହେଁଏ ନିଙ୍ଗ ଆୟାପେ ।” ଏ଼ ଦେବୁଣିଏ ତାନି ମା଼ଙ୍ଗା ନେହେଁ ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜୀସୁ ଏମ୍ବାଟିଏ ହାଜାନା ଗାଲିଲି ସାମ୍‌ଦୁରି ଡାଗେ ୱା଼ତେସି, ଅ଼ଡ଼େ ହ଼ରୁ ଲାକ ହାଜାନା କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ସଟାୟାଁ, ଟୁଡୁୱାୟାଁ, କା଼ଣାୟାଁ, ଗୁଲାୟାଁ, ହା଼ରେକା ଲ଼କୁଇଁ ତାମିତଲେ ତାଚାନା ଜୀସୁ କଡାଁ ଡ଼଼ଇ ଇଟିତେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଇଲେକିହିଁ ବେବ୍‌ଡ଼ାୟାଁ ଜ଼ଲିମାନେରି, ଟୁଡୁୱାୟାଁ ନେହିଁ ଆ଼ହିମାନେରି, ସଟାୟାଁ ତା଼କି ମାନେରି ଅ଼ଡ଼େ କା଼ଣାୟାଁ ମେସିମାନେରି; ଈ ବାରେ ମେସାନା ଲ଼କୁ କାବା ଆ଼ତେରି, ଇଞ୍ଜାଁ ଇସ୍ରାୟେଲତି ମାହାପୂରୁଇଁ ଜହରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଅ଼ଡ଼େ ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଈ ବାରେ ଲ଼କୁତାକି ନାଙ୍ଗେ କାର୍ମା ହ଼ଚିମାଞ୍ଜାନେ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଈୱାରି ତୀନିଦିନା ଆ଼ତେରିଏ ନା଼ ତଲେ ମାଞ୍ଜାମାନେରି, ଅ଼ଡ଼େ ଈୱାରି ତା଼ଣା ଏ଼ନାୟିୱା ତିଞ୍ଜାଲି ହିଲେଏ; ଈୱାରି ହାନାଟି ଜୀୱୁ ହ଼ଚା ହା଼ତିଲେହେଁ ଜିରୁତା ତର୍‌ଗିନେରି, ଏ଼ଦାଆଁତାକି ହାକିଟି ପାଣ୍ତାଲି ନା଼ ମ଼ନ ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଇଚେକା ଲ଼କୁତାକି ବାଣ୍ତି ପାଞ୍ଜିକିହାଲି ଈ ଏ଼ନାଆଁ ହିଲାଆ ଟା଼ୟୁତା ଏମ୍ବିଟି ରୂଟି ପା଼ଣ୍‌ନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀ ତା଼ଣା ଏଚରଗଟା ରୂଟି ମାନୁ ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ସା଼ତାଗଟା ଇଞ୍ଜାଁ ଏଚରଗଟା ଊଣା ମୀଣ୍‌କା ମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଏଚେଟିଏ ଜୀସୁ ଲ଼କୁଣି ବୂମିତା କୁଗାଲି ହୁକୁମି ହୀତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ ସା଼ତାଗଟା ରୂଟି ଇଞ୍ଜାଁ ମୀଣ୍‌କାଣି ମାହାପୂରୁ ତା଼ଣା ଜହରା କିହାନା ସୀସୁୟାଁକି ହୀତେସି; ଏ଼ୱାରି ଲ଼କୁତାକି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ଅ଼ଡ଼େ ଲ଼କୁ ତିଞ୍ଜାନା ପାଞ୍ଜିତି ଡା଼ୟୁ, ଡୀଗିତି ରୂଟି ସା଼ତା ଡାଲି ହା଼ରିତାଣି କୂଡ଼ି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ରୂଟି ତିଚି ଲ଼କୁ ଇୟାସିକା ଅ଼ଡ଼େ ଊଣା କକାରି ପ଼ଦାଁଣି ପିସାନା ସା଼ରି ମା଼ଣା ଆ଼ବାୟାଁ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଏଚେଟିଏ ଏ଼ୱାସି ଲ଼କୁଣି ହେଲ ହୀହାନା ଡଂଗତା ହ଼ଚାନା ମଗଦାନ ହାନ୍ଦିତା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ଏଚେକା ପାରୁସି ଅ଼ଡ଼େ ସାଦୁକିୟାଁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ତାୟିପାରି କିହାଲି, ମାଙ୍ଗେ ହା଼ଗୁ ଲାକଟି ର଼ ସିନା ତ଼ସ୍ତାମୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମିଡ଼୍‌ଅଲା ବେ଼ଲା ଏଲେଇଞ୍ଜେରି, ୱିଏ କାରା ଆ଼ନେ, ଇଚିହିଁ ହା଼ଗୁ ଗାଦ୍‌ଗା ଆ଼ହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଅ଼ଡ଼େ ଲା଼ଇ ବେ଼ଲା ଏଲେଇଞ୍ଜେରି, ନୀଞ୍ଜୁ ପିୟୁ ଆ଼ନେ, ଇଚିହିଁ ହା଼ଗୁ ଗାଦ୍‌ଗା ଅ଼ଡ଼େ ଦୂନ୍ଦ୍ରା ମୁଚାମାନେ । ମୀରୁ ହା଼ଗୁତି ପା଼ଗା ମେସାନା ନ଼କିତି କାତା ପୁଞ୍ଜାଲି ଆ଼ଡି ମାଞ୍ଜେରି, ସାମା ନୀଏଁତି କାତା ଅ଼ଡ଼େ ସିନାୟାଁ ପୁଞ୍ଜି ହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ପ଼ଲ୍‌ଆ ଗାଟାରି ଇଞ୍ଜାଁ ମାହାପୂରୁଇଁ ଅଣ୍‌ପାଆଗାଟି କୂଡ଼ାତାରି ସିନାୟାଁ ପାରିନେରି, ସାମା ଜୁନସତି ସିନା ପିସ୍‌ପେ ଅ଼ଡ଼େ ଏଟ୍‌କାତି ସିନା ଏ଼ୱାରାକି ହୀପ୍‌କି ଆ଼ଏ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପିସାନା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ସୀସୁୟାଁ ସାମ୍‌ଦୁରି ଆତାଲା ହାଜାନା ସିନିକିତେରି, ଏ଼ୱାରି ରୂଟି ଅ଼ହାଲି ବା଼ଣା ଆ଼ହା ହାଜାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଜାଗ୍ରାତା ଆ଼ଦୁ, ପାରୁସିୟାଁ ଅ଼ଡ଼େ ସାଦୁକିୟାଁ ପୁଲା ଏ଼ୟୁଟି ଜାଗ୍ରାତା ଆ଼ହାଁ ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଜ଼ଲ୍‌କି ଆ଼ହାଲି ମା଼ଟ୍‌ହେରି, “ମା଼ର ରୂଟି ତାଚା ହିଲାଆୟି ଇଞ୍ଜିଁ ଏ଼ୱାସି ଏଲେଇଞ୍ଜିମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ସାମା ଜୀସୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଏଲେଇଚେସି, “ଆଡ଼େ ଊଣା ନାମୁ ଗାଟାତେରି, ମୀ ବିତ୍ରା ରୂଟି ହିଲେଏ ଇଞ୍ଜିଁ ଏ଼ନାଆଁତାକି ୱେସ୍‌ପି ଆ଼ହିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ମୀରୁ ନୀଏଁ ପାତେକା ପୁଞ୍ଜି ହିଲଅତେରି ? ଏ଼ ପା଼ସାମା଼ଣା ଲ଼କୁତି ପା଼ସାଗଟା ରୂଟି ଡ଼ିକ୍‌ହାନା ହୀହା ମାଚେଏଁ, ଇଞ୍ଜାଁ ମୀରୁ ଏଚର ଡାଲି ହା଼ରିତାଣି କୂଡ଼ି କିତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଇଞ୍ଜାଁ ଏ଼ ସା଼ରି ମା଼ଣା ଲ଼କୁତି ସାତା ଗଟା ରୂଟି, ଇଞ୍ଜାଁ ଏଚର ଡାଲି ହା଼ରିତାଣି କୂଡ଼ି କିତେରି, ଏ଼ ବାରେ ମିଙ୍ଗେ ଅଣ୍‌ପୁ ହିଲେଏ ? ");
INSERT INTO kxv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ନା଼ନୁ ମିଙ୍ଗେ ରୂଟି କାତା ୱେସାମାଞ୍ଜାଆତେଏଁ, ଈଦାଆଁ ଏ଼ନିକିଁ ପୁଞ୍ଜି ହିଲଅତେରି ? ସାମା ପାରୁସିୟାଁ ଅ଼ଡ଼େ ସାଦୁକିୟାଁ ପୁଲା ଏ଼ୟୁଟି ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଏ଼ୱାସି ରୂଟି ତାକି ଲ଼ଡ଼ାମାନି ପୁଲା ଏ଼ୟୁତାକି ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜାଲି ୱେହ୍‌ଆନା, ପାରୁସିୟାଁ ଅ଼ଡ଼େ ସାଦୁକିୟାଁ ଜା଼ପ୍‌ନି ତା଼ଣାଟି ଜାଗ୍ରାତା ଆ଼ହାଁ ମାଞ୍ଜାଲି ଏ଼ୱାରାଇଁ ୱେସାମାଚେସି, ଏ଼ଦାଆଁ ଏ଼ୱାରି ଏଚିବେ଼ଲା ପୁଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ଡା଼ୟୁ ଜୀସୁ କାୟିସରିୟା ପିଲିପି ରା଼ଜିତା ୱା଼ହାନା ତାନି ସୀସୁୟାଁଇଁ ୱେଚେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ଆମ୍ବାଆସି ଇଞ୍ଜିଁ ଲ଼କୁ ୱେସିମାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ଏଚେଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ଆମ୍ବା ଆମ୍ବାଆରି ବାପ୍ତିସ୍ମ ହୀନି ଜହନ, ଆମ୍ବା ଆମ୍ବାଆରି ଏଲିୟ, ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରି ଜିରିମିୟ ଆ଼ଆତିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ରଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ସାମା ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ଇଞ୍ଜିଁ ମୀରୁ ୱେସିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମନ ପିତର ଏଲେଇଚେସି, “ନୀନୁ କ୍ରୀସ୍ତ, ଜୀୱୁଗାଟି ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଜୁନସ ମୀର୍‌ଏଣାତି ସିମନ, ନୀନୁ ନେହେଁ, ଇଚିହିଁ ମାଣ୍‌ସି ନୀ ତା଼ଣାଟି ଈଦାଆଁ ୱେ଼କ୍‌ହାମାଞ୍ଜଅସି, ସାମା ନା଼ ଲାକପୂରୁତି ଆ଼ବା ୱେ଼କ୍‌ହାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଅ଼ଡ଼େ ନା଼ନୁ ଜିକେଏ ନିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନୀନୁ ପିତରତି, ଇଞ୍ଜାଁ ଈ ୱାଲି ଲାକ ନା଼ନୁ ନା଼ କୁଲମିତି କେ଼ପିଇଁ, ଅ଼ଡ଼େ ହା଼କିତି ବା଼ଡ଼୍‌ୟୁ ଏ଼ଦାଆଁ ମ୍ଣେକ୍‌ହାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ନା଼ନୁ ନିଙ୍ଗ ଲାକପୂରୁତି କୁଚିକା଼ଡ଼ି ହିୟାଇଁ, ଅ଼ଡ଼େ ନୀନୁ ଦାର୍‌ତିତା ଏ଼ନାଆଁ ସୁଣ୍ତିଦି, ଏ଼ଦି ଲାକପୂରୁ ରା଼ଜି ଜିକେଏ ସୁଣ୍ତ୍‌କି ଆ଼ନେ, ଅ଼ଡ଼େ ଦାର୍‌ତିତା ଏ଼ନାଆଁ ଦେଏଦି ଏ଼ଦି ଲାକପୂରୁ ଜିକେଏ ଦେପି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଏଚିବେ଼ଲା ଏ଼ୱାସିଏ କ୍ରୀସ୍ତ ଇଞ୍ଜିଁ ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଏ଼ୱାସି ତାମି ସୀସୁୟାଁଣି ଜାଣ୍ତେ କିହିଁ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଏଚିବେ଼ଲାଟିଏ ଜୀସୁ ତାନି ସୀସୁୟାଁଣି ୱେସାଲି ମା଼ଟ୍‌ହେସି, ନା଼ନୁ ଜିରୁସାଲମତା ହାନାୟିମାନେ, ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗା, କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ତା଼ଣାଟି ହା଼ରେକା ଦୁକୁ ବେଟାଆ଼ହାନା ହା଼ନାୟି ମାନେ, ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ଏଚେଟିଏ ପିତର ଏ଼ୱାଣାଇଁ ଅ଼ରୱାକି ଅ଼ହାନା ଲା଼ଗାନା ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ, ମାହାପୂରୁ ନିଙ୍ଗ କାର୍ମା ଆୟାପେସି, ଇଲେତାୟି ନିଙ୍ଗେ ଏଚେଲାୱା ଆ଼ୟାଆପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ସାମା ଜୀସୁ ଡା଼ୟୁୱାକି ସିନିକିହାନା ପିତରଇଁ ଏଲେଇଚେସି, “ଏ଼ ସୟତାନ ନା଼ ତା଼ଣାଟି ହେକ ଆ଼ମୁ, ନୀନୁ ନା଼ ସାତ୍ରୁ ଲେହେଁ, ଇଚିହିଁ ନୀନୁ ମାହାପୂରୁ କାତା ଅଣ୍‌ପାଆନା ମାଣ୍‌ସିତି କାତା ଅଣ୍‌ପିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ଏଚିବେ଼ଲା ଜୀସୁ ତାନି ସୀସୁୟାଁଣି ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ ଜେ଼ଚ ତା଼କାଲି ମ଼ନ କିତିହିଁ, ଏ଼ୱାସି ତା଼ନୁଏ ତାଙ୍ଗେ ଅ଼ପାକଡାଆନା ତାନି କ୍ରୁସ ଡେ଼କାନାହାଁ ନା଼ ଜେ଼ଚ ତା଼କାପେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଇଚିହିଁ ଆମ୍ବାଆସି ତାନି ଜୀୱୁ ନୀଟ୍‌ହା କଡାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସି ହା଼ୱି କିନେସି; ସାମା ଆମ୍ବାଆସି ନା଼ ତାକି ତାନି ଜୀୱୁ ହୀନେସି ଏ଼ୱାସି ନୀଟ୍‌ହା କଡିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଅ଼ଡ଼େ ମାଣ୍‌ସି ଈ ଦାର୍‌ତିତା ମାନାଣି ବାରେ ମେଡ଼ି କିହାନା ତାନି ଜୀୱୁତି ହା଼ୱି କିନେସି, ଆତିହିଁ ଏ଼ୱାଣାକି ଏ଼ନି ଲା଼ବା, ଇଞ୍ଜାଁ ମାଣ୍‌ସି ତାନି ଜୀୱୁତି ବାଦୁଲି ଏ଼ନାଆଁ ହୀନେସି ? ");
INSERT INTO kxv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ଇଞ୍ଜାଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ତାନି ଆ଼ବାତି ଗାୱୁରମିଟି ତାନି ଦୂତୁୟାଁ ତଲେ ୱା଼ନେସି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ବାରେ ଲ଼କୁକି ତାନି କାମାତି ଲେକା ତଲେ ପା଼ଡ଼େୟି ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାଣ୍‌ସି ମୀର୍‌ଏସି ତାନି ରା଼ଜିତା ରାଜାଆ଼ହାଁ ୱା଼ନାଣି ମେହ୍‌ଆ ପାତେକା ଇମ୍ବାଆଁ ମାନି ଲ଼କୁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ହା଼ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଜୀସୁ ସ଼ ଦିନା ଡା଼ୟୁ ପିତର, ଜାକୁବ, ଅ଼ଡ଼େ ତାନି ତାୟି ଜହନଇଁ ଏଟ୍‌କା କିହାନା ଏ଼ୱାରାଇଁ ର଼ ପାଡାଆ଼ତି ହ଼ରୁ ଲାକ ଅ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରି ନ଼କିତା ତାନି ୱା଼ଣା ବାଦ୍‌ଲୱି ଆ଼ହାନା ତାନି ମୂମ୍ବୁ ୱେଡ଼ାଲେହେଁ ଉଜେଡ଼ି ଇଞ୍ଜାଁ ତାନି ହିମ୍ବରି ଉଜେଡ଼ି ଲେହେଁ ଦବ୍‌ଲା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ମ଼ସା ଅ଼ଡ଼େ ଏଲିୟ ଜୀସୁତଲେ କାତା ଆ଼ହିମାଚାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ଏମ୍ବାଟିଏ ପିତର ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ମା଼ର ଈ ଟା଼ୟୁତା ମାନାୟି ନେହେଁ; ନୀ ମ଼ନ ଆତିହିଁ ନା଼ନୁ ଇମ୍ବାଆଁ ତୀନିଗଟା ଗୂଡ଼ାୟାଁ କେ଼ପିଇଁ, ନିଙ୍ଗେତାକି ରଣ୍ତାଆଁ ମ଼ସାକି ରଣ୍ତାଆଁ ଇଞ୍ଜାଁ ଏଲିୟକି ରଣ୍ତାଆଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ଈ କାତା ୱେସ୍‌ପନିଏ ମେହ୍‌ଦୁ ଇଚାୟି ହା଼ଗୁ ୱା଼ହାନା ଏ଼ୱାରାଇଁ ପ୍ଡିକ୍‌ହେ, ଇଞ୍ଜାଁ ଏ଼ ହା଼ଗୁଟି ଈ ହା଼ଡା ୱେ଼ଙ୍ଗିତେ, “ଈୱାସି ନା଼ ଜୀୱୁତି ମୀର୍‌ଏସି ଈୱାଣି ତା଼ଣେଏ ନା଼ ରା଼ହାଁ ମାନେ, ଈୱାଣି ବ଼ଲୁ ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ଈ ହା଼ଡା ୱେଞ୍ଜାହାଁ ସୀସୁୟାଁ ମୁନୁ କୁତିହିଁ ରୀତେରି ଇଞ୍ଜାଁ ହା଼ରେକା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଏମ୍ବାଟିଏ ଜୀସୁ ୱା଼ହାନା ଏ଼ୱାରାଇଁ ଡୀଗାନା ଏଲେଇଚେସି, “ନିଙ୍ଗାଦୁ ମୀରୁ ଆଜାଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଲାକ ସିନିକିହାଲିଏ ଜୀସୁ ପିସ୍‌ପେ ଆମ୍ବାଆରାଇଁ ମେହ୍‌ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ଏ଼ୱାରି ହ଼ରୁ ଲାକଟି ରେ଼ଚା ୱା଼ହିମାଚାଟି ଜୀସୁ ଏ଼ୱାରାଇଁ ହୁକୁମି ହୀହାନା ଏଲେଇଚେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ହା଼ତାରି ତା଼ଣାଟି ନିଙ୍ଗାଆ ପାତେକା ଈ ମେସାମାନି କାତା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଏ଼ଦାଆଁତାକି ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଆତିହିଁ ନ଼କେଏ ଏଲିୟ ୱା଼ନାୟି ମାନେ ଇଞ୍ଜିଁ ମେ଼ରାପୁନାରି ଏ଼ନାଆଁତାକି ୱେସିମାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏଲିୟ ୱା଼ହାନା ବାରେ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଇଟିନାୟି ସାତା” ");
INSERT INTO kxv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ଏଲିୟ ୱା଼ହା ରା଼ତେସିଏ, ସାମା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପୁନାଆନା ଏ଼ନିକିହାଲି ମ଼ନ ଏଲେକିତେରି । ଏଲେକିହିଁଏ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ଏ଼ୱାରି କେୟୁତା ଦୁକୁ ବେଟାଆ଼ହାଲି ହାଜିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଏଚିବେ଼ଲା ଏ଼ୱାରାଇଁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି କାତା ୱେସିମାନେସି, ଏଚିବେ଼ଲା ସୀସୁୟାଁ ପୁଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଡା଼ୟୁ ଏ଼ୱାରି ଲ଼କୁତା଼ଣା ୱା଼ହାଲିଏ, ରଅସି ଜୀସୁ ତା଼ଣା ୱା଼ହାଁ ମେଣ୍ତାକୁତାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ପ୍ରବୁ ନା଼ କକାଣାଇଁ କାର୍ମା ମେହ୍‌ମୁ, ଇଚିହିଁ ଏ଼ୱାସି କାଟିୱେନି ନ଼ମେରି ତାକି ହା଼ରେକା କସ୍ତ ଆ଼ହିମାନେସି, ଏ଼ୱାସି ଏଚର ପା଼ଲି ହିଚୁତା ଅ଼ଡ଼େ ଏ଼ୟୁଣାଁ ତର୍‌ଗା ହାଜିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ନା଼ନୁ ମୀ ସୀସୁୟାଁ ତା଼ଣା ଏ଼ୱାଣାଇଁ ତାଚାମାଚେଏଁ, ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ନେହିଁ କିହାଲି ଆ଼ଡାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜୀସୁ ଏଲେଇଚେସି, “ଆଡ଼େ ନାମାଆଗାଟି ଲାଗେଏ ପ଼ଲେଏ କାମା କିନି କୂଡ଼ାତାତେରି, ଏଚର କା଼ଲା ପାତେକା ନା଼ନୁ ମୀ ତଲେ ଡ଼ୟିଇଁ ? ଏଚର କା଼ଲା ମୀ ଲେ଼ମ୍ବାନାଣି ଅ଼ର୍‌ହିଇଁ ? କକାଣାଇଁ ଇମ୍ବାଆଁ ନା଼ ତା଼ଣା ତାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ଅ଼ଡ଼େ ଜୀସୁ ବୂତୁଇଁ ଦାକା ହୀହାଲିଏ, ବୂତୁ ଏ଼ୱାଣାଇଁ ପିସା ହାତୁସ୍ତେ, ଏ଼ ଦେବୁଣିଏ କକାସି ନେହିଁଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ଏଚେଟିଏ ସୀସୁୟାଁ ମେଣେଏ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଏ଼ନାଆଁତାକି ଏ଼ ବୂତୁ ପିସ୍‌ପି କିହାଲି ଆ଼ଡାଆତମି ?” ");
INSERT INTO kxv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ଊଣା ନାମୁ ତାକି, ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ର଼ ହାର୍ସୁ ପା଼ଡ଼େୟି ସମାନା ମୀ ନାମୁ ମାଚିହିଁ, ଈ ହ଼ରୁତି ଇମ୍ବାଟି ଏମ୍ବାଆଁ ଗୁଚାଆ଼ମୁ ଇଚିହିଁ, ଏ଼ଦି ଗୁଚାଆ଼ନେ, ଅ଼ଡ଼େ ଏ଼ନାୟି ଜିକେଏ ଆ଼ଆଗାଟାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ସାମା ପ୍ରା଼ତାନା ଅ଼ଡ଼େ ଉପାସା ପିସ୍‌ପେ ଅ଼ଡ଼େ ଏ଼ନି ଊପେୟିଟି ଇଲେତି ବୂତୁ ହ଼ଚା ହାଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ଅ଼ଡ଼େ ଏ଼ୱାରି ଗାଲିଲିତା ରୁଣ୍ତା ଆ଼ତି ବେ଼ଲାତା ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ମାଣ୍‌ସିୟାଁ କେୟୁତା ହେର୍‌ପି ଆ଼ହାଲି ହାଜିମାନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ୟିନେରି; ଅ଼ଡ଼େ ତୀନି ଦିନାଟିଏ ଏ଼ୱାସି ୱେଣ୍ତେ ନିଙ୍ଗିନେସି ।” ଏଚେଟିଏ ଏ଼ୱାରି ହା଼ରେକା ଦୁକୁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଏମ୍ବାଟିଏ ଏ଼ୱାରି କପର୍‌ନାହୁମତା ୱା଼ହାଲିଏ ମାହାପୂରୁ ଇଲୁତି ସିସ୍ତୁ ରୀହ୍‌ନାରି ପିତରଇଁ ୱା଼ହାନା ୱେଚେରି, “ମୀ ଗୂରୁ ମାହାପୂରୁ ଇଲୁତାକି ସିସ୍ତୁ ହୀଅସିକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର ଏଲେଇଚେସି, “ହାଅ ହୀନେସି ।” ଅ଼ଡ଼େ ଏ଼ୱାସି ଇଜ ୱା଼ହାଲିଏ ଜୀସୁ ନ଼କେଏ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ସିମନ ନୀ ଅଣ୍‌ପୁ ଏ଼ନାୟି, ଦାର୍‌ତିତି ରାଜାୟାଁ ଆମ୍ବାଆରି ତା଼ଣାଟି ସିସ୍ତୁ ରୀହ୍‌ନେରି, ଏ଼ୱାରି ମୀର୍‌କା ତା଼ଣାଟି କି ଏଟ୍‌କା ଦେ଼ସାତି ଲ଼କୁ ତା଼ଣାଟି ?” ");
INSERT INTO kxv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ଏ଼ୱାସି ଏଟ୍‌କା ଦେ଼ସାତି ଲ଼କୁ ତା଼ଣାଟି ଏଲେଇଞ୍ଜାଲିଏ, ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ମୀର୍‌କା ହିୟାଲି ଲ଼ଡ଼ାଆଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ସାମା ମା଼ର ଏ଼ନିକିଁ ଏ଼ୱାରାକି ବା଼ଦା ହୀନାତାୟି ଆ଼ଆୟି, ଏ଼ଦାଆଁତାକି ସାମ୍‌ଦୁରିତା ହାଜାନା କା଼ଟା ମେତ୍‌ମୁ, ଇଞ୍ଜାଁ ତଲିଏ ଆମିନି ମୀନୁ ଆହ୍‌ଦି, ଏ଼ଦାଣି ଆସାନା ତାନି ଗୂତି ଏ଼କ୍‌ହିସାରେ ର଼ ୱେଣ୍ତି ଟାକା ବେଟାଆ଼ଦି; ଏ଼ଦାଆଁ ଅ଼ହାନା ନାଙ୍ଗେ ଅ଼ଡ଼େ ନିଙ୍ଗେତାକି ଏ଼ୱାରାକି ହୀମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ଏଚିବେ଼ଲା ସୀସୁୟାଁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, “ଆତିହିଁ ଲାକପୂରୁ ରା଼ଜିତା ଆମ୍ବାଆସି କାଜାସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଏ଼ୱାସି ର଼ ଊଣା କକାଣାଇଁ ଡାଗେ ହା଼ଟାହାଁ ନିପ୍‌ହାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ୱେଣ୍ତେ ର଼ ଊଣା କକାଣି ଲେହେଁ ଆ଼ଆତିହିଁ, ଏ଼ନିଜିକେଏ ଲାକପୂରୁ ରା଼ଜିତା ହ଼ଡାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଈଦାଆଁତାକି ଆମ୍ବାଆସି ଈ ଊଣା କକାଣି ଲେହେଁ ତାଙ୍ଗେତାକି ଊଣା କିହାକଡିନେସି, ଏ଼ୱାସି ଲାକପୂରୁ ରା଼ଜିତା କାଜାସି । ");
INSERT INTO kxv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଜିକେଏ ନା଼ ଦ଼ରୁଟି ଈ ଊଣା କକାଣାଇଁ ଆବିନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଆବାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ସାମା ଆମ୍ବାଆସି ଜିକେଏ ନା଼ ତା଼ଣା ନାମାମାନି ଈ ଊଣାୟାଁ ବିତ୍ରାଟି ରଅଣାଇଁ ତାୟିପାରି କିହାଲି ପା଼ପୁ କିୱି କିନେସି, ଏ଼ୱାଣି ହେର୍‌କିତା ର଼ କାଜା ଜେତାୱାଲି ଦସାନା ସାମ୍‌ଦୁରିତି କୂଡ଼୍‌ନି ଏ଼ୟୁଣାଁ ମେତ୍‌ହିଁ ଏ଼ୱାଣାକି ନେହେଁ ଆ଼ତେମା । ");
INSERT INTO kxv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ଆୟ଼ତା, ଦାର୍‌ତିତି ଲାଗେଏ କିନାକି ଡଣ୍ତ ବେଟା ଆ଼ନାତେରି; ଲାଗେଏ ଆ଼ନାୟି ସାତେଏ ଆ଼ନେ, ଆୟ଼ତା ଆମିନି ଲ଼କୁ ତା଼ଣାଟି ଲାଗେଏ ଆ଼ନେ ଏ଼ୱାସି ଡଣ୍ତ ବେଟା ଆ଼ନେସି !” ");
INSERT INTO kxv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ମୀ କେୟୁ କି କଡା ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ, ଇଚିହିଁ ଏ଼ଦାଆଁ ରାତ୍‌ହାନା କୁତାଦୁ, ରୀ କେସ୍କା ଅ଼ଡ଼େ ରୀ କଡାୟାଁ ଆସାନା କା଼ଲାକା଼ଲା ଡ଼ୀଞ୍ଜିମାନି ହିଚୁତା ହ଼ଡ଼୍‌ନି କିହାଁ କଲା ଅ଼ଡ଼େ ସଟା ଆ଼ହାନା କା଼ଲେଏତି ଜୀୱୁ ବେଟାଆ଼ହାନା ମାହାପୂରୁ ରା଼ଜିତା ହାନାୟି ମିଙ୍ଗେତାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଅ଼ଡ଼େ ମୀ କାନୁ ମିଙ୍ଗେ ଲାଗେଏ କିୱିକିୟାତିହିଁ, ଏ଼ଦାଆଁ ଡ଼େୱା କୁତାଦୁ; ରୀ କାଣ୍‌କା ଆସାନା କା଼ଲେଏ ଡ଼ୀଞ୍ଜିମାନି ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେଦିନି କିହାଁ ର଼ କାନୁ ତଲେ କା଼ଲେଏତି ଜୀୱୁ ବେଟାଆ଼ହାନା ମାହାପୂରୁ ରା଼ଜିତା ହାନାୟି ମିଙ୍ଗେତାକି ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ହେଣ୍ତୁ ଈ ଊଣା କକାରି ବିତ୍ରାଟି ରଅଣାଇଁ ଜିକେଏ ହୀଣି ମେହ୍‌ଆଦୁ, ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଲାକପୂରୁ ମାନି ଏ଼ୱାରି ଦୂତୁୟାଁ ବାରେଦିନା ଲାକପୂରୁତି ମା଼ ଆ଼ବାତି ମୂମ୍ବୁ ମେସେ ମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଇଚିହିଁ ଏ଼ନାୟି ଜା଼ଙ୍ଗାମାନେ ଏ଼ଦାଆଁ ପାରାନା ଗେଲ୍‌ପାଲି ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ମୀରୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ରଅଣାକି ପା଼ସାକ଼ଡ଼ି ମେ଼ଣ୍ତାୟାଁ ମାଚିହିଁ, ଏ଼ୱାସିକା ବିତ୍ରାଟି ରଣ୍ତି ଜା଼ଙ୍ଗାହାନେ, ଇଞ୍ଜାଁ ରଣ୍ତି ଊଣା ପା଼ସାକ଼ଡ଼ି ମେ଼ଣ୍ତାୟାଁ ହ଼ରୁତା ପିସାନା ଏ଼ୱାସି ହାଜାନା ଏ଼ ଜା଼ଙ୍ଗାମାନି ମେ଼ଣ୍ତାତି ପାରଅସି ? ");
INSERT INTO kxv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ଦାଆଁ ବେଟା ଆ଼ନେସି, ଇଞ୍ଜାଁ ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଜା଼ଙ୍ଗା ହିଲାଆଗାଟି ରଣ୍ତି ଊଣା ପା଼ସାକ଼ଡ଼ି ମେ଼ଣ୍ତାୟାଁ କିହାଁ ଜା଼ଙ୍ଗାମାଚି ର଼ ମେ଼ଣ୍ତା ତାକି ହା଼ରେକା ରା଼ହାଁ କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ଏଲେକିହିଁଏ ଈ ଊଣାୟାଁ ବିତ୍ରାଟି ରଣ୍ତି ଜିକେଏ ନସ୍ତ ଆ଼ଆପେ ଇଞ୍ଜିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବାତି ମ଼ନ ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ନୀ ତାୟି ପା଼ପୁ କିତିହିଁ, ନୀନୁ ଏ଼ୱାଣାଇଁ ମେ଼ଣେଏ ଏଲେକିଆନି ଇଞ୍ଜିଁ ୱେସାନା ତାନି ପା଼ପୁ ତ଼ହ୍‌ମୁ; ଏ଼ୱାସି ନୀ କାତା ଆସ୍ତିହିଁ ନୀନୁ ଏ଼ୱାଣାଇଁ ନୀ ତାୟିଲେହେଁ ୱେଣ୍ତେ ବେଟାଆ଼ଦି । ");
INSERT INTO kxv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ସାମା ଏ଼ୱାସି ନୀ କାତା ୱେନାଆତିହିଁ, ନୀ ତଲେ ରଅଣାଇଁ କି ରିଆରାଇଁ ଅ଼ହିହିଁ ହାଲାମୁ, ଏ଼ନିକିହିଁ ରିଆରି କି ତୀନି ଜା଼ଣା ସା଼କିୟାଁ ନ଼କିତା ବାରେ କାତା ତୀରି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଏ଼ୱାସି ଏ଼ୱାରି କାତା ଜିକେଏ ଆହ୍‌ଆତିହିଁ କୁଲମିତି ୱେହ୍‌ମୁ, ଅ଼ଡ଼େ ଜିକେଏ କୁଲମି କାତା ୱେନଅସି, ଆତିହିଁ ଏ଼ୱାସି ମୀ କାନୁତା ଜୀହୁଦିଆ଼ଆତାରି କି ସିସ୍ତୁ ରୀହ୍‌ନାରି ଲେହେଁ ଆ଼ପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଦାର୍‌ତିତା ଏ଼ନାଆଁ ସୁଣ୍ତିଦେରି, ଲାକପୂରୁ ଜିକେଏ ସୁଣ୍ତ୍‌କିଆ଼ନେ, ଅ଼ଡ଼େ ଦାର୍‌ତିତା ଏ଼ନାଆଁ ହେଲ ହୀଦେରି, ଲାକପୂରୁ ଜିକେଏ ହେଲ ହୀପ୍‌କି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ଅ଼ଡ଼େ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଦାର୍‌ତିତା ମୀ ବିତ୍ରାଟି ରିଆରି ରଣ୍ତିଏ ମ଼ନ ଆ଼ହାନା ଏ଼ନାଆଁ ଜିକେଏ ରୀସ୍ତିହିଁ ଏ଼ଦି ଲାକପୂରୁତି ଆ଼ବା ତା଼ଣାଟି ଏ଼ୱାରାକି ହୀପ୍‌କିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଇଚିହିଁ ଏମ୍ବିୟା ରିଆରି କି ତୀନି ଜା଼ଣା ନା଼ ଦ଼ରୁତଲେ ରୁଣ୍ତା ଆ଼ନେରି ଏମ୍ବାଆଁ ନା଼ନୁ ଏ଼ୱାରିତଲେ ମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ଏଚିବେ଼ଲା ପିତର ଜୀସୁ ଡାଗେ ୱା଼ହାନା ୱେଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ ତାୟି ଏଚର ପା଼ଲି ନା଼ କ଼ପାଟି ପା଼ପୁ କିତିସାରେ ନା଼ନୁ ଏ଼ୱାଣି ପା଼ପୁ ମ୍ଣେକ୍‌ଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ସା଼ତା ଦେବା ପାତେକା କି ? ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ୱାର୍‌ଇ ସା଼ତା ଦେବା ପାତେକା ଆ଼ଏ, ସାତା ଗୂଣୁ ତୀନିକ଼ଡ଼ି ଦସ ଦେବା ପାତେକା ମ୍ଣେକ୍‌ନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ତାନି ହ଼ଲିୟାଙ୍ଗା ତଲେ ରୀଣା ଲେକା କିନି ର଼ ରାଜା ଲେହେଁତାୟି । ");
INSERT INTO kxv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ଏ଼ୱାସି ଲେକା କିହାଲି ମା଼ଟ୍‌ହାଲିଏ, ତୀନି ଗାର୍‌ହା ଦସ ମା଼ଣା ଟାକାୟାଁ ରୀଣା ଆ଼ହାମାନି ର଼ ହ଼ଲେଏଣାଇଁ ଏ଼ୱାଣାଇଁ ତା଼ଣା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ସାମା ଏ଼ ବାରେ ଡିକ୍‌ହାଲି ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନାୟି ହିଲାଆତାକି ଏ଼ ସା଼ୱୁକାରି ଏ଼ୱାଣାଇଁ ଅ଼ଡ଼େ ତାନି ଡକ୍ରିନି ଇଞ୍ଜାଁ ତାନି କକାରି ପ଼ଦାଁଣି ଇଞ୍ଜାଁ ତାନି ଇଲୁତି ଆ଼ସ୍ତି ପାର୍‌ଚାନା ରୀଣା ଡିକ୍‌ହାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ଏଚେଟିଏ ଏ଼ ହ଼ଲେଏସି ମେଣ୍ତାକୁତାନା ଜହରା କିହାନା ଏଲେଇଚେସି, ନୀନୁ କାର୍ମାମେସାନା କା଼ତାମୁ, ନା଼ନୁ ନିଙ୍ଗେ ବାରେ ଡିକ୍‌ହା ତୁସ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ଏଚେଟିଏ ସା଼ୱୁକାରି ଏ଼ ହ଼ଲେଏଣାଇଁ କାର୍ମାମେସାନା ତାନି ରୀଣା ପିସ୍‌ପି କିୱିଆ଼ତେ ଇଞ୍ଜାଁ ତାନି ରୀଣା ମେଣ୍‌ଙ୍ଗାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ସାମା ଏ଼ ହ଼ଲେଏସି ଏମ୍ବାଟି ପାଙ୍ଗାତା ହାଜାନା ତାନିତା଼ଣାଟି ରୀ କ଼ଡ଼ି ଦସଟାକା ରୀଣା ଅ଼ହାମାନି ତାନି ତଲେତି ର଼ ହ଼ଲେଏଣାଇଁ ମେସାନା ଏ଼ୱାଣି ହେର୍‌କିତା ଆସାନା ଏଲେଇଚେସି, ନୀନୁ ଅ଼ହାମାନି ରୀଣା ଡିକ୍‌ହା ତୁସ୍ତାମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ଏଚେଟିଏ ତାନି ତଲେତି ହ଼ଲେଏସି ମେଣ୍ତାକୁତାନା ଜହରା କିହିଁ ଏଲେଇଚେସି, ନୀନୁ ନାଙ୍ଗେ କାର୍ମାମେସାନା କା଼ତାମୁ ନା଼ନୁ ନିଙ୍ଗେ ବାରେ ଡିକ୍‌ହାଇଁ ");
INSERT INTO kxv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ସାମା ଏ଼ୱାସି ରା଼ଜି ଆ଼ଆତେସି, ଇଞ୍ଜାଁ ରୀଣା ଡିକ୍‌ଆ ପାତେକା ଏ଼ୱାଣାଇଁ କା଼ୟିଦି ଇଲୁତା ସୁଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଇଞ୍ଜାଁ ତାନି ତଲେତି ହ଼ଲିୟାଙ୍ଗା ଏ଼ଦାଆଁ ମେସାନା ହା଼ରେକା ଦୁକୁ କିତେରି ଅ଼ଡ଼େ ହାଜାନା ସା଼ୱୁକାରିଇଁ ବାରେ କାତା ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ଏମ୍ବାଟିଏ ସା଼ୱୁକାରି ଏ଼ୱାଣାଇଁ ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, ଆଡ଼େ କାମାତା ୱା଼ଆଗାଟି ହ଼ଲେଏଣାତି ନୀନୁ ନାଙ୍ଗେ ବାତିମା଼ଲାଲିଏ ନା଼ନୁ ନୀ ବାରେ ରୀଣା ପିସ୍ତାତେଏଁ; ");
INSERT INTO kxv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ନା଼ନୁ ଏ଼ନିକିଁ ନିଙ୍ଗେ କାର୍ମା ଆୟାତେଏଁ, ଏଲେକିହିଁଏ ନୀନୁ ଜିକେଏ ନୀ ତଲେତି ହ଼ଲେଏଣାଇଁ କାର୍ମାମେହ୍‌ନାୟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଅ଼ଡ଼େ ତାନି ପ୍ରବୁ ହା଼ରେକା କ଼ପା ଆ଼ହାନା ବାରେ ରୀଣା ଡିକ୍‌ଆ ପାତେକା ଏ଼ ହ଼ଲେଏଣାଇଁ କସ୍ତ ହୀନି ଲ଼କୁ କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ମୀରୁ ବାରେତେରି ମୀ ବାରେ ହିୟାଁଟି ମୀ ତାୟିଇଁ ତାମି ପା଼ପୁ ମ୍ଣେକ୍‌ଆତିହିଁ ଲାକପୂରୁତି ମୀ ଆ଼ବା ଜିକେଏ ମିଙ୍ଗେ ଏଲେ କିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜୀସୁ ଈ ବାରେ କାତା ୱେସାଲି ରା଼ପ୍‌ହି ଡା଼ୟୁ ଗାଲିଲି ରା଼ଜି ପିସାନା ଜର୍ଦନ କାଡା ଆତାଲାତି ଜୀହୁଦା ରା଼ଜିତି ହାନ୍ଦିତା ଏତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁ ତାନି ଜେ଼ଚ ହାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏମ୍ବାଆଁ ଏ଼ୱାରି ର଼ଗଟି ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ଏମ୍ବାଟିଏ ପାରୁସିୟାଁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ତାୟିପାରିକିହିଁ ୱେଚେରି, “ରଅସି ଜାହାରା ଡକ୍ରିନି ଏ଼ନି କାତାତାକି ଜିକେଏ ପିସାଲି ମେ଼ରା ମାନେକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜୀସୁ ଏଲେଇଚେସି, “ମୀରୁ ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି ? ଗା଼ଡ଼ି କିନାସି ନ଼କେଏଟିଏ ଏ଼ୱାରାଇଁ ଇୟା ଅ଼ଡ଼େ ଆ଼ବା କିହିଁ ଗା଼ଡ଼ିକିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଅ଼ଡ଼େ ଏ଼ଦାଆଁତାକି ଡକ୍ରା ତାଲି ତାଞ୍ଜିଇଁ ପିସାନା ତାନି ଡକ୍ରି ତଲେ ଆଣ୍ତିନେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ରଣ୍ତିଏ ଆଙ୍ଗା ଆ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ରିଆରି ଆ଼ଏ, ସାମା ରଣ୍ତିଏ ଆଙ୍ଗା ଆ଼ନେରି । ଇଞ୍ଜାଁ ମାହାପୂରୁ ଏ଼ନାଆଁ ଆଣ୍ତ୍‌ୱି କିହାମାନେସି, ମାଣ୍‌ସି ଏ଼ଦାଆଁ ଏଟ୍‌କା କିଆପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୁସିୟାଁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଆତିହିଁ ମ଼ସା ଏ଼ନାଆଁତାକି ପିହ୍‌ନି ଆ଼କୁ ରା଼ଚାନା ଡକ୍ରିନି ପିସାଲି ହେଲ ହୀହାମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଇଚିହିଁ ମୀ ଆ଼ଟ୍‌ୱା ହିୟାଁତି ମେସାନା ମ଼ସା ମିଙ୍ଗେ ମୀ ଡକ୍ରିସିକାଣି ପିସାଲି ହେଲ ହିୟାତେସି, ସାମା ଗା଼ଡ଼ିକିତି ଦିନାଟିଏ ଏଲେକିହିଁ ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ତାନି ଡକ୍ରିନି ଦାରି ଦ଼ହ ହିଲାଆନା ଏ଼ନି କାତାତାକି ପିସାନା ଅ଼ର ଡକ୍ରିନି ତାତିହିଁ, ଏ଼ୱାସି ଦା଼ରିକାମା କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଡକ୍ରିନି ତଲେ ମାଣ୍‌ସିକି ଇଲେତାୟି ମାଚିହିଁ, ଏ଼ୱାସି ବୀହା ଆ଼ଆତିହିଁ ନେହେଁ ଆ଼ତେମା ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବାରେଜା଼ଣା ଈ କାତାତି ଆସାଲି ଆ଼ଡଅରି, ଇଚିହିଁ ଆମ୍ବାଆରାକି ମାହାପୂରୁ ବା଼ଡ଼୍‌ୟୁ ହୀହାମାନେସି, ୱାର୍‌ଇ ଏ଼ୱାରିଦେହେଁ ଆସାଲି ଆ଼ଡିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ଇଚିହିଁ ଆମ୍ବା ଆମ୍ବାଆରି ଇୟାନି ବାଣ୍ତିଟିଏ ବୀହା ଆ଼ହାଲି ଆ଼ଡାଆରେଟୁ ଜାର୍ନା ଆ଼ହାମାନେରି; ଇଞ୍ଜାଁ ଆମ୍ବା ଆମ୍ବାଆରି ଲ଼କୁ ତା଼ଣାଟି ଏଲେକିୱି ଆ଼ହାମାନେରି, ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରି ଲାକପୂରୁ ରା଼ଜିତାକି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଏଲେ ଆ଼ହାମାନେରି, ଆମ୍ବାଆସି ଏ଼ କାତାତି ଆସାଲି ଆ଼ଡିନାସି ଆସ୍‌ପାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ଏଚିବେ଼ଲା ଜୀସୁ କକାରି ପ଼ଦାୟାଁ ମୁହେଁ କେୟୁ ଇଟାନା ପ୍ରା଼ତାନା କିନେସି, ଏ଼ଦାଆଁତାକି ଲ଼କୁ ଏ଼ୱାରାଇଁ ତାନି ତା଼ଣା ତାତେରି, ସାମା ସୀସୁୟାଁ ତାଚିମାଚି ଲ଼କୁଣି ଦାକା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “କକାରି ପ଼ଦାଁଣି ନା଼ ତା଼ଣା ୱା଼ହାଲି ହୀଦୁ, ଏ଼ୱାରାଇଁ ଆ଼ଂଗାଆଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଏଲେତାରିୱାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରି ଲାକ କେୟୁ ଇଟାନା ଏମ୍ବାଟି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ରଅସି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେସି, “ଏ଼ ଗୂରୁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାଲି ନା଼ନୁ ଆମିନି ନେହିଁ କାମା କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନେହାୟି ଇନି କାତାତି ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ୱେଞ୍ଜିମାଞ୍ଜାଦି ? ୱାର୍‌ଇ ରଅସିଏ ନେହାଁସି; ସାମା ନୀନୁ ଜୀୱୁ ବେଟାଆ଼ହାଲି ମ଼ନ କିତିହିଁ, ବାରେ ହୁକୁମି ମା଼ନୱି ଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ଏ଼ୱାସି ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଏ଼ନିଲେହେଁତି ହୁକୁମି ?” ଜୀସୁ ଏଲେଇଚେସି, “ଲ଼କୁଣି ପା଼ୟାଆନି, ଦା଼ରିକାମା କିଆନି, ସ଼ରୁ କିଆନି, ମିଚି ସା଼କି ହୀଆନି, ");
INSERT INTO kxv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ତାଲି ତାଞ୍ଜି କାତା ଆହ୍‌ମୁ, ନୀ ପା଼ଡ଼ିତି ଲ଼କୁଣି ନୀ ଜୀୱୁ ଲେହେଁ ଜୀୱୁ ନ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ଏ଼ ଦାଂଗ୍‌ଣେଏସି ଜୀସୁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଈ ବାରେ ମା଼ନୱି ଆ଼ହାମାଇଁ, ନାଙ୍ଗେ ଅ଼ଡ଼େ ଏ଼ନୱା ଊଣା ମାନେ ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ନେହାଁତି ଆ଼ହାଲି ମ଼ନ କିତିହିଁ, ହାଜାନାହାଁ ନୀ ବାରେ ଦ଼ନ ପାର୍‌ଚାନାହାଁ ହିଲାଆ ଗାଟାରାକି ଦା଼ନା ହୀମୁ, ଇଞ୍ଜାଁ ନା଼ ଜେ଼ଚ ୱା଼ମୁ, ଏଚେଟିଏ ଲାକପୂରୁ ନୀନୁ ଦ଼ନ ବେଟାଆ଼ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଈ କାତା ୱେଞ୍ଜାନା ଦାଂଗ୍‌ଣେଏସି ଦୁକୁ ଆ଼ହାନା ହାଚେସି, ଇଚିହିଁ ଏ଼ୱାଣାକି ହା଼ରେକା ଦ଼ନ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଏଚେଟିଏ ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଦ଼ନ ଗାଟାରି ଲାକପୂରୁ ରା଼ଜିତା ହ଼ଡାଲି ହା଼ରେକା କସ୍ତ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଅ଼ଡ଼େ ୱେଣ୍ଡେ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁତି ରା଼ଜିତା ଦ଼ନଗାଟାରି ହାନି କିହାଁ ଊଟୁ ସୂଜା କା଼ଣିଟି ହ଼ଡା ହାନାୟି ଊସାସା ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ସୀସୁୟାଁ ଈ କାତା ୱେଞ୍ଜାନା କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଆତିହିଁ ଆମ୍ବାଆସି ଗେଲ୍‌ପି ଆ଼ହାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜୀସୁ ଏ଼ୱାରାଇଁ ସିନିକିହାନା ଏଲେଇଚେସି, “ଈଦି ମାଣ୍‌ସିତାକି ଆ଼ଆଗାଟାୟି, ସାମା ମାହାପୂରୁ ତାକି ବାରେ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଏଚେଟିଏ ପିତର ଏଲେଇଚେସି, “ମେହ୍‌ମୁ ମା଼ମ୍ବୁ ବାରେ ପିସାନା ନୀ ଜେ଼ଚ ୱା଼ହାମାନମି; ଆତିହିଁ ମା଼ମ୍ବୁ ଏ଼ନାଆଁ ବେଟାଆ଼ନମି ?” ");
INSERT INTO kxv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ପୁଃନି ଜୁଗୁ ଆ଼ନାଟି ଏଚେ଼ତା ମାଣ୍‌ସି ମୀର୍‌ଏସି ତାନି ଗାୱୁରମିତି କାଜାପା଼ଣା ତଲେ ସିଂଗାସାଣିତା କୁଗିନି ଦିନା ନା଼ ଜେ଼ଚ ୱା଼ହାମାନାତେରି ମୀରୁ, ମୀରୁ ଜିକେଏ ବା଼ର ଗଟା ସିଂଗାସାଣିତା କୁଗାନା, ଇସ୍ରାୟେଲତି ବା଼ର କୂଡ଼ାତି ସା଼ଲୱି କିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ନା଼ ଦ଼ରୁ ତାକି ଇଲୁ କା଼ଣ୍ତା, କି ତାୟି ତାଙ୍ଗିସ୍କା, ତାଲି ତାଞ୍ଜି, କକାରି ପ଼ଦାୟାଁ, ଇଞ୍ଜାଁ ବୂମି ବା଼ଡ଼ା ପିସାମାନେସି, ଏ଼ୱାସି ଏ଼ ବାରେକିହାଁ ହା଼ରେକା ଗାଡି ବେଟା ଆ଼ନେସି, ଇଞ୍ଜାଁ କା଼ଲାକା଼ଲାତି ଜୀୱୁତି ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ସାମା ନ଼କିତା ମାନି ହା଼ରେକା ଲ଼କୁ ଡା଼ୟୁ ଆ଼ନେରି, ଇଞ୍ଜାଁ ଡା଼ୟୁତା ମାନି ହା଼ରେକା ଲ଼କୁ ନ଼କିତା ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ଇଚିହିଁ ଲାକପୂରୁ ରା଼ଜି ଇଲେତି ର଼ ସା଼ୱୁକାରି ଲେହେଁତାୟି, ଲା଼ଇ ୱେ଼ୟାଲିଏ ତାନି ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା କୂଲି କାମା କିୱିକିହାଲି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଅ଼ଡ଼େ ଏ଼ୱାସି କୂଲି ଗାଟାରାଇଁ ଦିନାତାକି ର଼ ୱେଣ୍ତି ଟାକା ହିୟାଇଁ ଇଞ୍ଜିଁ ଏ଼ୱାରାଇଁ ତାନି ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ଅ଼ଡ଼େ ନ଼ ଗଂଟା ବେ଼ଲାତା ଏ଼ୱାସି ପାଙ୍ଗାତା ହାଜାନା ଏଟ୍‌କାତାରି କାମା ପ୍ଣାଃଆନା ନିଚାମାଚାଣି ମେସାନା ଏ଼ୱାରାଇଁ ଜିକେଏ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ମୀରୁ ଜିକେଏ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା ହାଜାନା କାମା କିଦୁ, ଇଞ୍ଜାଁ ଏ଼ନିକିଁ ତୀରି ଆ଼ହାମାନେ, ଏଲେକିହିଁ ମିଙ୍ଗେ ହିୟାଇଁ; ଇଞ୍ଜାଁ ଏ଼ୱାରି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ଅ଼ଡ଼େ ମାଦେନା ବା଼ର ଗଂଟା ଇଞ୍ଜାଁ ତୀନି ଗଂଟା ବେ଼ଲାତା ପାଙ୍ଗାତା ହାଜାନା ଏଲେକିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ଇଞ୍ଜାଁ ମିଡ଼୍‌ଅଲା ପା଼ସା ଗଂଟା ବେ଼ଲାତା ପାଙ୍ଗାତା ହାଜାନା ଏଚରଜା଼ଣା ନିଚାମାନାଣି ମେସାନା ୱେଚେସି, ମୀରୁ ଏ଼ନାଆଁତାକି ମାଦେନା ୱେଡ଼ାଡୁମ୍ବେ କାମା କିଆନା ଉଜେଏ ନିଚାମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, ଆମ୍ବାଆରି ମାଙ୍ଗେ କାମା ହେର୍‌ପା ମାଞ୍ଜଅରି । ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି ମୀରୁ ଜିକେଏ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା ହାଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ଡା଼ୟୁ ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ, ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ସା଼ୱୁକାରି ତାନି ଗୁମୁସ୍ତାଇଁ ଏଲେଇଚେସି, କୂଲି ଗାଟାରାଇଁ ହା଼ଟାନା ଡା଼ୟୁ ୱା଼ତି ଲ଼କୁ ତା଼ଣାଟିଏ ମା଼ଟ୍‌ହାନା ନ଼କିତା ୱା଼ତି ଲ଼କୁ ପାତେକା କୂଲି ହୀମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ଏଚେଟିଏ ଆମିନି ଗାଟାରି ପା଼ସା ଗଂଟା ବେ଼ଲାତା କାମାତା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚେରି, ଏ଼ୱାରି ୱା଼ହାନା ର଼ ୱେଣ୍ତି ଟାକା ଲାକା ବେଟାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଇଞ୍ଜାଁ ନ଼କେଏ କାମାତା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ୱା଼ହାନା ଗାଡି ବେଟାଆ଼ନେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେରି; ସାମା ଏ଼ୱାରି ଜିକେଏ ଏ଼ ର଼ ୱେଣ୍ତି ଟାକା ଲାକା ବେଟାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ସାମା ଏଲେକିଁ ବେଟାଆ଼ହାନା ଏ଼ୱାରି ସା଼ୱୁକାରିଇଁ କ଼ପା ଆ଼ହାନା ଲା଼ଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ଈ ଡା଼ୟୁତି ଲ଼କୁ ୱାର୍‌ଇ ର଼ ଗଂଟା କାମା କିତେରି, ଇଞ୍ଜାଁ ମା଼ମ୍ବୁ ୱେ଼ଡ଼ା ଡୁମ୍ବେ ୱା଼ହୁ ଆ଼ହିଁ କାରା ୱେହିଁ କାମା କିତିହିଁ ଜିକେଏ ନୀନୁ ଏ଼ୱାରାକି ମା଼ ସମାନା କିତି । ");
INSERT INTO kxv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ଏ଼ୱାରି ବିତ୍ରାଟି ରଅଣାଇଁ ସା଼ୱୁକାରି ଏଲେଇଚେସି ଏ଼ ତ଼ଣେ, ୱେନାମୁ, ନା଼ନୁ ନିଙ୍ଗେ ନା଼ଡ଼ି କିହିମାଞ୍ଜଅଁ; ନୀନୁ ନା଼ ତଲେ ର଼ ୱେଣ୍ତି ଟାକା ତାକି ରା଼ଜି ଆ଼ହାହିଲାଆତି କି ? ");
INSERT INTO kxv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ନୀନୁ ଏଚେକା ପା଼ଣ୍‌ନାୟି ମାନେ ଏଚେକା ଆସାନା ହାଜାତୁହ୍‌ମୁ, ସାମା ଈ ଡା଼ୟୁତି ଲ଼କୁକି ଜିକେଏ ନୀ ଲେହେଁକି ହିୟାଲି ନା଼ ମ଼ନ । ");
INSERT INTO kxv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ନା଼ ଦ଼ନତି ନା଼ ମ଼ନ ଲେହେଁ ଲେ଼ମ୍ବାଲି ନା଼ ଅଦିକାରା ହିଲେଏ କି ? ନା଼ନୁ କାର୍ମାମେସାନା ହିୟାଲିଏ ନୀନୁ ଏ଼ନାଆଁତାକି ଡା଼ହାରା ଆ଼ହିମାଞ୍ଜାଦି । ");
INSERT INTO kxv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଏଲେକିହିଁଏ ଡା଼ୟୁ ମାନି ଲ଼କୁ ନ଼କିତା ଆ଼ନେରି, ଇଞ୍ଜାଁ ନ଼କିତା ମାନି ଲ଼କୁ ଡା଼ୟୁ ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜୀସୁ ଜିରୁସାଲମତା ହାଜିମାଚାଟି ବା଼ରଜା଼ଣାତି ସୀସୁୟାଁଇଁ ଏଟ୍‌କା କିହାନା, ଜିରୁତା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ମେହ୍‌ଦୁ ମା଼ର ଜିରୁସାଲମତା ହାଜିମାନାୟି, ମାଣ୍‌ସି ମୀର୍‌ଏସି କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି କେୟୁତା ହେର୍‌ପିଆ଼ନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ହା଼ନି ଡଣ୍ତ ହୀହାନା ଏଟ୍‌କା କୂଡ଼ାତାରି କେୟୁତା ହେର୍‌ପିନେରି, ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ କିଜୱି କିନେରି, ସା଼ଟ୍‌ଣି ଡ଼଼ରିତଲେ ୱେ଼ନେରି, ଅ଼ଡ଼େ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟିନେରି, ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ହା଼କିଟି ୱେଣ୍ତେ ନିଙ୍ଗିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଏଚିବେ଼ଲା ଜେବଦି ଡକ୍ରି ତାନି ରୀ ମୀର୍‌କା ତଲେ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଜହରା କିହାନା ଏ଼ୱାଣି ତା଼ଣା ବାତିମା଼ଲିହିଁ ଏଲେଇଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଏଚେଟିଏ ଜୀସୁ ଏ଼ଦାନି ୱେଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ମ଼ନ କିହିମାଞ୍ଜି ?” ଏ଼ଦି ଏଲେଇଚେ, “ନୀ ରା଼ଜିତା ନା଼ ରୀ ମୀର୍‌କା ବିତ୍ରାଟି ରଅସି ନୀ ଟିଃନିୱାକି ଅ଼ଡ଼େ ରଅସି ନୀ ଟେ଼ବ୍ରିୱାକି କୁଗିନେରି ଇଞ୍ଜିଁ ହୁକୁମି ହୀମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ରୀସିମାଞ୍ଜେରି ଏ଼ଦାଆଁ ପୁଞ୍ଜିହିଲଅତେରି । ନା଼ନୁ ଆମିନି ସ଼ଲାତା ଗସାଲି ହାଜିମାଇଁ, ଏ଼ଦାଆଁ ମୀରୁ ଗସାଲି ଆ଼ଡିଦେରି ?” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଆ଼ଡିନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ନା଼ ସ଼ଲାତା ଗହ୍‌ଦେରି ସାତା, ସାମା ନା଼ ଟିଃନି କି ଟେ଼ବ୍ରିୱାକି କୁଗାଲି ହୀନି ନା଼ ଅଦିକାରାତି କାତା ଆ଼ଏ, ଇଚିହିଁ ଆମିନି ଗାଟାରାକି ନା଼ ଆ଼ବା ତା଼ଣାଟି ଟା଼ୟୁ କିୱିଆ଼ହାମାନେ ଏ଼ୱାରି କୁଗିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଏଟ୍‌କାତି ଦସ ଜା଼ଣା ଈ କାତା ୱେଞ୍ଜାନା ଏ଼ ତାୟି ରିଆରାଇଁ କ଼ପା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଏଟ୍‌କା କୂଡ଼ାତାରି ସା଼ଲୱି କିନାରି କାଜା ବା଼ଡ଼୍‌ୟୁ ତଲେ ତାମି କାଜାପା଼ଣା ତ଼ହ୍‌ନେରି, ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ମୀ ବିତ୍ରା ଏଲେକିହିଁ ଆ଼ଏ, ସାମା ମୀ ବିତ୍ରା ଆମ୍ବାଆସି କାଜାସି ଆ଼ହାଲି ଅଣ୍‌ପିନେସି, ଏ଼ୱାସି ମୀ ସେ଼ବା କିନାସି ଆ଼ପେସି; ");
INSERT INTO kxv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଅ଼ଡ଼େ ଆମ୍ବାଆସି କାଜାପା଼ଣା ବେଟାଆ଼ହାଲି ମ଼ନ କିନାସି ଏ଼ୱାସି ମୀ ହ଼ଲେଏସି ଆ଼ପେସି, ");
INSERT INTO kxv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଏ଼ନିକିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ସେ଼ବା ବେଟାଆ଼ହାଲି ୱା଼ହାହିଲଅସି, ସାମା ସେ଼ବା କିହାଲି ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁଣି ଗେଲ୍‌ପାଲି ଜୀୱୁ ହୀହାଲି ୱା଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଜୀସୁ ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ ଜିରିହଟି ହାଜିମାଚାଟି ହା଼ରେକା ମାନ୍ଦା ଲ଼କୁ ତାନି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଅ଼ଡ଼େ ଜିରୁ ଦାରିତା ରିଆରି କା଼ଣାୟାଁ ଜୀସୁ ଏ଼ ଜିରୁଟି ହାଜିମାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା, କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ! ମାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ସାମା ଲ଼କୁ ଏ଼ୱାରାଇଁ ପାଲେଏ ଆ଼ହାଲି ଦାକା ହୀତେରି, ସାମା ଏ଼ୱାରି ଅ଼ଡ଼େ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ! ମାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ଏମ୍ବାଟିଏ ଜୀସୁ ନିଚାନା ଏ଼ୱାରାଇଁ ହା଼ଟାନା ୱେଚେସି, “ନା଼ନୁ ମିଙ୍ଗେତାକି ଏ଼ନାଆଁ କିଇଁ ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଏ଼ନିକିଁ ମା଼ କାଣ୍‌କା ଦେପି ଆ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଅ଼ଡ଼େ ଜୀସୁ କାର୍ମା ଆ଼ହାନା ଏ଼ୱାରି କାଣ୍‌କା ଡୀଗିତେସି, ଇଞ୍ଜାଁ ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାରି ମେସ୍ତେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଏଚିବେ଼ଲା ଜୀସୁ ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ ଜିରୁସାଲମ ଡାଗେ ଆ଼ହାନା ଜୀତ ଇନି ହ଼ରୁ ଦାରିତି ବେତ୍‌ପାଗି ଏଜାଲିଏ ଏଚିବେ଼ଲା ଜୀସୁ ତାନି ରୀ ସୀସୁୟାଁଣି ଏଲେଇଞ୍ଜା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ମୀରୁ ନ଼କିତା ମାନି ନା଼ୟୁଁତା ହାଜୁ, ଇଞ୍ଜାଁ ହାଲ୍‌ୱନିଏ ଦସାମାନି ର଼ ଗା଼ଡ଼୍‌ଦେ ଇଞ୍ଜାଁ ଡା଼ଲୁ ମେହ୍‌ଦେରି; ଏ଼ୱାଆଁ ହୁକ୍‌ହାନା ନା଼ ତା଼ଣା ତାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଅ଼ଡ଼େ ଆମ୍ବାଆରି ଏ଼ନାଆଁ ଇଞ୍ଜାତିହିଁ, ୱେହ୍‌ଦୁ, ଇୱାସିକା ତା଼ଣା ମା଼ ପ୍ରବୁକି ଲ଼ଡ଼ାମାନେ, ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସିକାଣି ପାଣ୍ତାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ଏ଼ନିକିଁ ସାତା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ଆ଼ତେ; ");
INSERT INTO kxv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟନତି ଗା଼ଡ଼ାଇଁ ୱେହ୍‌ଦୁ ମେହ୍‌ମୁ ନୀ ରାଜା ନୀ ତା଼ଣା ୱା଼ହିମାନେସି ! ଏ଼ୱାସି ସୁଦୁଗାଟାସି ଇଞ୍ଜାଁ ଗା଼ଡ଼୍‌ଦେ ଲାକ କୁଗାମାନେସି ଇଚିହିଁ ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁ ଲାକ କୁଗାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ହାଜାନା ଜୀସୁ ୱେସ୍ତିଲେହେଁ କାମା କିତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଅ଼ଡ଼େ ଗା଼ଡ଼୍‌ଦେ ଇଞ୍ଜାଁ ଡା଼ଲୁତି ତାଚାନା ଏ଼ୱାସିକା ଲାକ ହିମ୍ବରିକା ପା଼ସ୍ତେରି, ଇଞ୍ଜାଁ ଜୀସୁଇଁ କୁଗିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ତାମି ହିମ୍ବରିକା ଜିରୁତା ପା଼ସ୍ତେରି, ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ମା଼ର୍‌କାତି ଗଚାୟାଁ ତାଚାନା ଜିରୁତା ପା଼ସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଅ଼ଡ଼େ ଜୀସୁତି ଡା଼ୟୁତା ନ଼କିତା ହାଜିମାଚି ଲ଼କୁ ବାରେ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ହ଼ସାନା ଦାୱୁଦ ମୀର୍‌ଏସି ! ମାହାପୂରୁ ଦ଼ରୁଟି ୱା଼ହିମାନେସି ନେହାଁସି ! ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ବ଼ର ହୀପାସି, ଲାକପୂରୁ ହ଼ସାନା !” ");
INSERT INTO kxv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଅ଼ଡ଼େ ଏ଼ୱାସି ଜିରୁସାଲମତା ହ଼ଡାଲିଏ, ଗା଼ଡ଼ାତାରି ବାରେଜା଼ଣା “ଈୱାସି ଆମ୍ବାଆସି ?” ଇଞ୍ଜିଁ କାବାଆ଼ହାନା ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ଏଚେଟିଏ ବାରେ ଲ଼କୁ ଏଲେଇଚେରି, “ଈୱାସି ଗାଲିଲି ଦେ଼ସାତା ମାନି ନା଼ଜରିତତି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜୀସୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଡା଼ୟୁ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଏ଼ ଟା଼ୟୁତା ଏମ୍ବାଆଁ ଆ଼ସ୍ତି ମା଼ସ୍‌କି ମାଚାରାଇଁ ବାରେତି ପାଙ୍ଗାତା ପେ଼ର୍‌ହା ପାଣ୍ତିତେସି, ଇଞ୍ଜାଁ ଟାକାୟାଁ ବେ଼ବାରା ଗାଟାରି କୁର୍ଚିୟାଁ ଅ଼ଡ଼େ ପା଼ର୍‌ୱା ପଟାୟାଁ ବେ଼ବାରା ଗାଟାରି ଜ଼ମ୍ବାୟାଁ ତିରିମ୍ଣିପ୍‌ହେସି, ");
INSERT INTO kxv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ମାହାପୂରୁ ଦାର୍ମୁପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ନା଼ ଇଲୁ ପ୍ରା଼ତାନା ଇଲୁ ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେ, ସାମା ମୀରୁ ଏ଼ଦାଆଁ ଡଂଗାଁୟାଁ ପା଼ୱୁ ମ୍ଣିପ୍‌ହା ମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା କା଼ଣାୟାଁ, ସଟାୟାଁ ତାନି ତା଼ଣା ୱା଼ତେରି ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ତା଼ନୁ କିହିମାନି କାବାଆ଼ନି କାମା ମେସାନା ଅ଼ଡ଼େ “ମାହାପୂରୁ ଇଲୁତା ହ଼ସାନା ଦାୱୁଦ ମୀର୍‌ଏସି” ଇଞ୍ଜିଁ କାଜା ଗିୟାଁତଲେ କକାରି ଜ଼ଲିମାନାଣି ୱେଞ୍ଜାନା କ଼ପା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ଏ଼ୱାରି ଜୀସୁଇଁ ୱେଚେରି, “ଈୱାରି ଏ଼ନାଆଁ ଇଞ୍ଜିଁ ମାନେରି, ନୀନୁ ଏ଼ଦାଆଁ ୱେଞ୍ଜିମାଞ୍ଜି ?” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ହାଅ, ୱେଞ୍ଜିମାଇଁ, ମୀରୁ କକାରି ଇଞ୍ଜାଁ ପା଼ଲୁ ଗହ୍‌ନରାଇଁ ନିଙ୍ଗ ଜହରା ପା଼ଚୁ ପା଼ଚାଲି ଜା଼ପ୍‌ହାମାଞ୍ଜି, ଦାର୍ମୁ ପତିତି ଈ କାତାତି ମୀରୁ ଏଚେଲା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପିସାନା ଗା଼ଡ଼ାଟି ହ଼ଚାନା ବେତନିୟାଁତା ହାଜାନା ଏମ୍ବାଆଁ ଲା଼ଆଁୟାଁ ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ଜୀସୁ ଗା଼ଡ଼ାତା ୱେଣ୍ତା ହାଜିମାଚାଟି ହାକି ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ଅ଼ଡ଼େ ଜିରୁ ଦାରିତା ର଼ ତ଼ୟା ମା଼ର୍‌ନୁ ମେସାନା ଦାରିତା ହାଚେସି, ଇଞ୍ଜାଁ ୱାର୍‌ଇ ଆ଼କା ପିସ୍‌ପେ ଏମ୍ବାଆଁ ଏ଼ନାଆଁ ମେହ୍‌ଆତେସି ଇଞ୍ଜାଁ ଏ଼ଦାନି ବା଼କା ଇଟାନା ଏଲେଇଚେସି, “ନୀ ତା଼ଣା ଏଚେଲା ପା଼ଡ଼େୟି ଆ଼ୟାଆପେ” ଇଞ୍ଜାଁ ଏ଼ ଦେବୁଣିଏ ଏ଼ ତ଼ୟା ମା଼ର୍‌ନୁ ୱା଼ୟାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ସୀସୁୟାଁ ଏ଼ଦାଆଁ ମେସାନା କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ତ଼ୟା ମା଼ର୍‌ନୁ ଏ଼ନିକିଁ ଏ଼ ଦେବୁଣିଏ ୱା଼ୟା ହାଚେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀ ନାମୁ ମାଚିହିଁ, ଅ଼ଡ଼େ ମୀରୁ ଆନାମାନା ଆ଼ଆନା, ଈ ତ଼ୟା ମା଼ର୍‌ନୁତି ଏ଼ନି କିୱିଆ଼ହାମାନେ, ଏଲେକିହିଁଏ କିଦେରି ଏ଼ଦି ଆ଼ଏ, ‘ସାମା ଈ ହ଼ରୁତି ଜିକେଏ ନୀନୁ ନିଙ୍ଗାନା ସାମ୍‌ଦୁରିତା ତର୍‌ଗାମୁ’ ଇଞ୍ଜେରି, ଆତିହିଁ ଏ଼ଦି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ଇଞ୍ଜାଁ ନାମୁତଲେ ପ୍ରା଼ତାନାତା ଏ଼ନାଆଁ ରୀହ୍‌ଦେରି ଏ଼ ବାରେ ମିଙ୍ଗେ ମେଡ଼ାଆୟାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଡା଼ୟୁ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଜା଼ପ୍‌ହି ମାଚାଟି, କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, “ନୀନୁ ଆମିନି ଅଦିକାରା ତଲେ ଈ ବାରେ କାମା କିହିମାଞ୍ଜି ? ନିଙ୍ଗେ ଏ଼ ଅଦିକାରା ଆମ୍ବାଆସି ହିୟାତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ର଼ କାତା ୱେଞ୍ଜାଇଁ, ମୀରୁ ଏ଼ଦାଆଁ ୱେଣ୍ତେ ୱେସ୍ତାତିହିଁ, ନା଼ନୁ ଆମିନି ଅଦିକାରା ତଲେ ଈ ବାରେ କାମା କିହିମାଇଁ, ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ୱେସ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଜହନ ବାପ୍ତିସ୍ମ ହୀହାଲି ଆମ୍ବାଆରି ତା଼ଣାଟି ବେଟା ଆ଼ହାମାଚେସି, ଲାକପୂରୁଟି କି ଲ଼କୁ ତା଼ଣାଟି ?” ଏଚେଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଜ଼ଲ୍‌କି ଆ଼ତେରି, “ମାହାପୂରୁ ତା଼ଣାଟି ଇଞ୍ଜିଁ ୱେସ୍ତିହିଁ, ଏ଼ୱାସି ମାଙ୍ଗେ ଏଲେଇଞ୍ଜାନେସି, ‘ମୀରୁ ଏ଼ନାଆଁତାକି ଏ଼ୱାଣାଇଁ ନାମାଆତେରି ?’ ");
INSERT INTO kxv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ସାମା ମାଣ୍‌ସିୟାଁ ତା଼ଣାଟି ଇନାୟି, ଲ଼କୁତାକି ଆଜି, ଇଚିହିଁ ବାରେ ଲ଼କୁ ଜହନଇଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଇଞ୍ଜିହିଁ ମା଼ନୱି ଆ଼ହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଜୀସୁଇଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ।” ଏ଼ୱାସି ଜିକେଏ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ନା଼ନୁ ଜିକେଏ ଆମିନି ଅଦିକାରା ତଲେ ଈ ବାରେ କିହିମାଇଁ, ଏ଼ଦାଆଁ ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ୱେସ୍ତଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ମୀରୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ରଅଣାକି ରୀ ମୀର୍‌କା ମାଚେରି, ଏ଼ୱାସି କାଜା ମୀର୍‌ଏଣି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେସି, “ମୀର୍‌ଏଣା ନୀଞ୍ଜୁ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା ହାଜାନା କାମା କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ଏ଼ୱାସି ଏଲେଇଚେସି, “ନାଙ୍ଗେ କାମା କିହାଲି ମ଼ନ ହିଲେଏ” ସାମା ଡା଼ୟୁ ଏ଼ୱାସି ଅଣ୍‌ପାନା କାମା କିହାଲି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଇଞ୍ଜାଁ ଊଣା ମୀର୍‌ଏଣା ତା଼ଣା ୱା଼ହାନା ଏଲେଇଞ୍ଜି ୱେସ୍ତେସି, ଏ଼ୱାସି ଏଲେଇଚେସି, “ହାଅ ଆ଼ବା ନା଼ନୁ ହାଜିମାଇଁ, ସାମା ଏ଼ୱାସି ହାଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଈ ରିଆରି ବିତ୍ରାଟି ଆମ୍ବାଆସି ଆ଼ବା ମ଼ନ ଲେହେଁ କିତେସି ?” ଏ଼ୱାରି ଏଲେଇଚେରି “କାଜାସି ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ସିସ୍ତୁ ରୀହ୍‌ନାରି ଇଞ୍ଜାଁ ଦା଼ରେଣିସିକା ମୀ ନ଼କେଏ ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡ଼୍‌ନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ୱା଼ହାନା ମୀ ତା଼ଣା ଦାର୍ମୁତି ଜିରୁ ତ଼ସ୍ତାତେସି, ଅ଼ଡ଼େ ମୀରୁ ଏ଼ୱାଣାଇଁ ନାମାଆତେରି, ସାମା ସିସ୍ତୁ ରୀହ୍‌ନାରି ଇଞ୍ଜାଁ ଦା଼ରେଣିସିକା ଏ଼ୱାଣାଇଁ ନାମିତୁ, ସାମା ମୀରୁ ଏ଼ନିକିଁ ନାମିଦେରି, ଏ଼ଦାଆଁତାକି ଏ଼ନାଆଁ ମେସାନା ଜିକେଏ ହିୟାଁ ବାଦ୍‌ଲି କିଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଅ଼ଡ଼େ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେଞ୍ଜୁ, ର଼ ବୂମି ଗାଟାସି ମାଚେସି, ଏ଼ୱାସି ର଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ା କିହାନା ସା଼ରିୱାକି ବେୟିଁ ଗୂର୍‌ତେସି, ଇଞ୍ଜାଁ ଅଙ୍ଗୁରି ପା଼ଡ଼େୟି ପୀଚାଲି ର଼ ଗା଼ଡ଼୍‌ୟୁ କା଼ର୍‌ହାନା ର଼ ଗା଼ଣା ହଲୁଲେହେଁ କିତେସି, ଇଞ୍ଜାଁ କା଼ଃଆନି ଇଲୁ କେ଼ପାନା କାମା କିନାରାକି ଏ଼ ବା଼ଡ଼ାତି ବା଼ଗା ହୀହାନା ହେକ ଦେ଼ସାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ଡା଼ୟୁ ପା଼ଡ଼େୟି କାମ୍ବି ବେ଼ଲା ଆୟାଲିଏ, ଏ଼ୱାସି ତାନି ପା଼ଡ଼େୟି ବା଼ଗା ବେଟାଆ଼ହାଲି, ବା଼ଡ଼ାତା କାମାକିନାରି ତା଼ଣା, ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ସାମା କାମାକିନାରି ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ଆସାନା ରଅଣାଇଁ ୱେ଼ତେରି ଇଞ୍ଜାଁ ଅ଼ର ରଅଣାଇଁ ପା଼ୟିତେରି, ଅ଼ଡ଼େ ରଅଣାଇଁ ୱାଲ୍‌କା ୱେ଼ଚାନା ପା଼ୟାଁ କୁତାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଅ଼ଡ଼େ ଏ଼ୱାସି ତଲିତି କିହାଁ ହା଼ରେକା ଜା଼ଣା ହ଼ଲିୟାଙ୍ଗାଣି ପାଣ୍ତିତେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ଜିକେଏ ଏଲେକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ସାମା ନା଼ ମୀର୍‌ଏଣାଇଁ ଏ଼ୱାରି ମା଼ନି କିନେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା, ଏ଼ୱାସି ଡା଼ୟୁ ତାନି ମୀର୍‌ଏଣାଇଁ ଏ଼ୱାରିତା଼ଣା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ସାମା ଏ଼ କାମାକିନାରି ମୀର୍‌ଏଣାଇଁ ମେସାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ୱେସ୍‌ପି ଆ଼ତେରି, ଈୱାସିତ ବା଼ଡ଼ାତି ଅଦିକାରା ଗାଟାସି; ୱା଼ଦୁ ଈୱାଣାଇଁ ପା଼ୟାନା ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ଅଦିକାରା କିହାକଡିନ । ");
INSERT INTO kxv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଅଙ୍ଗୁରି ବା଼ଡ଼ା ଆତାଲା ମେତ୍‌ହାନା ପା଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଇଚିହିଁ ଏଚିବେ଼ଲା ଏ଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ସା଼ୱୁକାରି ୱା଼ନେସି, ଏଚିବେ଼ଲା ଏ଼ କାମା କିନାରାଇଁ ଏ଼ନାଆଁ କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ ଲାଗେଏ ପ଼ଲେଏତି କାମା କିନାରାଇଁ କସ୍ତ ହୀହିଁ ପା଼ୟିନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାକି କାମ୍ବିନିସାରି ବା଼ଗା ହୀନି ଏଟ୍‌କାତି କାମା କିନାରାକି ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ହେର୍‌ପିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଦାର୍ମୁ ପତିତି ଈ କାତା ଏଚେଲାୱା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି କି ?” ଇଲୁ ଦହ୍‌ନାରି ଆମିନି ୱାଲିତି ମିଣ୍‌ଏ ଇଞ୍ଜିଁ କୂତେରି, ଏ଼ଦିଏ ଇଲୁ କନତି ମୂଲୁ ୱାଲି ଆ଼ତେ; ମାହାପୂରୁ ତା଼ଣାଟି ଈଦି ଆ଼ତେ, ଇଞ୍ଜାଁ ଏ଼ଦି ମା଼ କାନୁତାକି କାବା ଆ଼ନାୟି । ");
INSERT INTO kxv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁତି ରା଼ଜି ମୀ ତା଼ଣାଟି ମୀଞ୍ଜା ଅ଼ୱିଆ଼ନେ, ଇଞ୍ଜାଁ ଆମିନି ଜା଼ତିତି ଲ଼କୁ ନେହିଁ ପା଼ଡ଼େୟି କାମ୍ବି କିନେରି ଏ଼ୱାରାକି ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଈ ୱାଲି ଲାକ ରିନେସି ଏ଼ୱାସି କାଣ୍ତାମୁକା ଆ଼ନେସି, ଇଞ୍ଜାଁ ଈ ୱାଲି ଆମ୍ବାଆରି ଲାକ ରିନେ ଏ଼ଦି ଏ଼ୱାଣାଇଁ ନା଼ସାକିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଈୱାଣି ଈ ବାରେ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେଞ୍ଜାନା, ଏ଼ୱାସି ଏ଼ୱାରି କାତା ୱେସିମାନେସି ଇଞ୍ଜିଁ ପୁଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆସାଲି ଅଣ୍‌ପିମାଚେରି, ସାମା ଲ଼କୁଇଁ ଆଜିତେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଇଞ୍ଜିଁ ମା଼ନି କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜୀସୁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ଲାକପୂରୁତି ରା଼ଜି ଇଲେତାୟି, ର଼ ରାଜା ଲେହେଁ, ଏ଼ୱାସି ତାନି ମୀର୍‌ଏଣା ବୀହା ବ଼ଜି କିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଇଞ୍ଜାଁ ଏ଼ ବୀହା ବ଼ଜିତା ହା଼ଟାମାନି ଲ଼କୁଣି ବ଼ଜିତା ୱା଼ପେରିୱା ଇଞ୍ଜିଁ ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ପାଣ୍ତିତେସି, ସାମା ଏ଼ୱାରି ୱା଼ହାଲି ମ଼ନ କିଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏଟ୍‌କାତି ହ଼ଲିୟାଙ୍ଗାଣି ପାଣ୍ତାନା ଏଲେଇଚେସି, ହା଼ଟି କିହାମାନି ଲ଼କୁଣି ୱେହ୍‌ଦୁ, ମେହ୍‌ଦୁ ନା଼ନୁ ନା଼ ବ଼ଜି ୱାଜା ମାଇଁ, ଆଙ୍ଗା ଆ଼ତି କ଼ଡିୟାଁ ପା଼ୟ୍‌ୱି ଆ଼ହାମାନୁ, ବାରେ ରା଼ନ୍ଦା ଆ଼ତେୟିଏ, ମୀରୁ ବୀହା ବ଼ଜିତା ୱା଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ସାମା ଏ଼ୱାରି ଏ଼ଦାଆଁ ଅଣ୍‌ପାଆନା ଆମ୍ବାଆରି ତାମି ତା଼ସା କାମାତା ହାଚେରି, ଇଞ୍ଜାଁ ଆମ୍ବା ଆମ୍ବାଆରି ତାମି ବେ଼ବାରା କିୟାଲି ହାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଲ଼କୁ ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ଆସାନା ପା଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ସାମା ରାଜା କ଼ପା ଆ଼ହାନା ତାନି କ଼ସ୍‌କାଣି ପାଣ୍ତାନା ଏ଼ ପା଼ୟିତାରାଇଁ ପା଼ୟି କିତେସି ଇଞ୍ଜାଁ ଏ଼ୱାରି ନା଼ସ୍‌କା ମ୍ଣେକ୍‌ହା ତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ଏଲେଇଚେସି, ବୀହା ବ଼ଜି ଆ଼ହାମାନେ, ସାମା ହା଼ଟ୍‌କି ଆ଼ହାମାନି ଲ଼କୁ ପା଼ଡ଼ା ଆ଼ଆତାରି, ");
INSERT INTO kxv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଏ଼ଦାଆଁତାକି ନୀଏଁ ମୀରୁ ଗା଼ଡ଼ାତି କାଜା ଡାଣ୍ତେଣାଁ ହାଜାନା, ଏଚରଜା଼ଣାତି ମେହ୍‌ଦେରି, ଏ଼ୱାରାଇଁ ବୀହା ବ଼ଜିତା ହା଼ଟା ତାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ଏମ୍ବାଟିଏ ଏ଼ ହ଼ଲିୟାଙ୍ଗା କାଜା ଡାଣ୍ତେଣାଁ ହାଜାନା ଲାଗେଏ ପ଼ଲେଏତାରାଇଁ ଇଞ୍ଜାଁ ଏଚେକା ନେହାଁରାଇଁ ମେସ୍ତେରି, ଏ଼ ବାରେତି ରୁଣ୍ତି କିହାନା ବୀହା ଇଲୁତା ତାତେରି, ଇଞ୍ଜାଁ ୱା଼ହାମାନି ଲ଼କୁ ବୀହା ଇଲୁତା ନେଞ୍ଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ସାମା ରାଜା ବୀହା ବ଼ଜିତା ୱା଼ହାମାନି ଲ଼କୁଣି ସିନିକିହାଲି ବିତ୍ରା ୱା଼ହାନା ଏମ୍ବାଆଁ ବୀହା ହିମ୍ବରି ହୁଚାଆନା କୁଗାମାନି ରଅଣାଇଁ ମେସାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ଏ଼ ତ଼ଣେ, ନୀନୁ ବୀହା ହିମ୍ବରି ହୁଚାଆନା ଏ଼ନିକିଁ ଇମ୍ବାଆଁ ୱା଼ତି ? ସାମା ଏ଼ୱାସି ଏ଼ନି ହା଼ଡା ଆ଼ଆନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ଏମ୍ବାଟିଏ ରାଜା ଏମ୍ବାଆଁ ହ଼ଲିୟାଙ୍ଗାଇଁ ଏଲେଇଚେସି, ଈୱାଣି କେସ୍କା କଡାୟାଁ ଦସାନା ପାଙ୍ଗାତି ଆନ୍ଦେରିତା ମେତ୍‌ହା ତୁହ୍‌ଦୁ, ଏମ୍ବାଆଁ ଡ଼ୀହିଁ ପାଲ୍‌କା ଟୀଟି କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଇଚିହିଁ ହା଼ଟ୍‌କି ଆ଼ତି ଲ଼କୁ ହା଼ରେକା ଜା଼ଣା ସାମା ଆ଼ଚିତି ଲ଼କୁ ହା଼ରେକା ଊଣା ଜା଼ଣା । ");
INSERT INTO kxv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ଏଚିବେ଼ଲା ପାରୁସିୟାଁ ହାଜାନା ଜୀସୁଇଁ ତାନି ୱେସ୍ତି କାତାଟି ଦ଼ହ ଦସାଲି ପାରୁ ପାରୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ଇଞ୍ଜାଁ ଏ଼ୱାରି ହେରଦ ଗଚି ବିତ୍ରାଟି ଏଚେକା ଲ଼କୁତଲେ ତାମି ସୀସୁୟାଁଇଁ ଜୀସୁ ତା଼ଣା ୱେସା ପାଣ୍ତିତେରି, “ଏ଼ ଗୂରୁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି ନୀନୁ ସାତା ୱେହ୍‌ନାତି ଇଞ୍ଜାଁ ସାତା କିହିଁ ମାହାପୂରୁତି ଜିରୁ ଜା଼ପ୍‌ନାତି, ଇଞ୍ଜାଁ ଆମ୍ବାଆରାଇଁ ଆଜଅତି ଅ଼ଡ଼େ ଆମ୍ବାଆରି ପାର୍‌ଡ଼ା ବାଚିକିହିଁ ଜ଼ଲିନାତି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଈଦାଆଁତାକି ନୀନୁ ମାଙ୍ଗେ ୱେସ୍ତାମୁ, ନୀ ଅଣ୍‌ପୁତା ଏ଼ନାୟି ମାନେ ? କାୟିସରକି ସିସ୍ତୁ ହୀନାୟ ମେ଼ରା କି ଆ଼ଏ ?” ");
INSERT INTO kxv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ସାମା ଜୀସୁ ଏ଼ୱାରି କାର୍‌ବି ପୁଞ୍ଜାନା ଏଲେଇଚେସି, “ଆଡ଼େ କୁଟୁ ଗାଟାତେରି ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ତାୟିପାରି କିହିମାଞ୍ଜାଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ଏ଼ ସିସ୍ତୁ ହୀନି ଟାକା ନାଙ୍ଗେ ହିୟାଦୁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାଣି ତା଼ଣା ର଼ ଟାକା ଆଦ୍‌ଲି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଈ ଆଦ୍‌ଲି ଲାକ ଆମ୍ବାଆରି ଦ଼ରୁ ଅ଼ଡ଼େ ତା଼ର୍ୟୁଁ ବମା ମାନେ ?” ");
INSERT INTO kxv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ଏ଼ୱାରି ଏଲେଇଚେରି, “କାୟିସରୱାୟି ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ଆମିନାୟି କାୟିସରୱାୟି ଏ଼ଦାଆଁ କାୟିସରକି ହୀଦୁ, ଅ଼ଡ଼େ ଆମିନାୟି ମାହାପୂରୁୱାୟି ଏ଼ଦାଆଁ ମାହାପୂରୁକି ହୀଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଏ଼ୱାରି ଏ଼ଦାଆଁ ୱେଞ୍ଜାନା କାବାଆ଼ହାନା ଏ଼ୱାଣାଇଁ ପିସାଁ ହାଜାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ହା଼କିଟି ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ହିଲେଏ ଇଞ୍ଜିମାନି ଏଚରଜା଼ଣା ସାଦୁକିୟାଁ ଏ଼ ଦିନା ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ଏ଼ ଗୂରୁ ମ଼ସା ୱେସାମାଞ୍ଜାନେସି, ରଅସି ପ଼ଦି ପ଼ଦା ଆ଼ଆନା ହା଼ତିହିଁ ତାନି ତାୟି ତାନି ଡକ୍ରିନି ଇଟାନା ଏ଼ ହା଼ତାଣି କୂଡ଼ା ଏ଼ପାକିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ମେହ୍‌ମୁ ମା଼ ତା଼ଣା ସା଼ତା ଜା଼ଣା ତାୟିୟାଁ ମାଚେରି; ତଲି ମୂଲୁ ତାସି ବୀହା ଆ଼ହାନା ହା଼ହାହାଚେସି, ଇଞ୍ଜାଁ କକାରି ପ଼ଦାୟାଁ ହିଲାଆତାକି ଏ଼ୱାସି ତାନି ଡକ୍ରିନି ତାନି ତାୟିକି ପିସାହାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ଏ଼ୱାଣି ଜେ଼ଚତାସି ଅ଼ଡ଼େ ଏ଼ୱାଣି ଜେ଼ଚତାସି ଏଲେକିହିଁ ସାତା ଜା଼ଣା ଜିକେଏ ହା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ବାରେତି ଡା଼ୟୁ ଏ଼ ଇୟାଟି ଜିକେଏ ହା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଆତିହିଁ ୱେଣ୍ତେ ନିଙ୍ଗିନାଟି ଏ଼ ସାତା ଜା଼ଣା ବିତ୍ରା ଆମ୍ବାଆରି ଡକ୍ରି ଆ଼ନେ ? ଇଚିହିଁ ବାରେଜା଼ଣା ଏ଼ଦାନି ବୀହା ଆ଼ହାମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଦାର୍ମୁ ସା଼ସ୍ତେରି ଅ଼ଡ଼େ ମାହାପୂରୁତି ବା଼ଡ଼୍‌ୟୁ ପୁନାଆନା ନା଼ଡ଼ି ଆ଼ହିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଇଚିହିଁ ହା଼ହାନା ୱେଣ୍ତେ ନିଙ୍ଗିସାରେ ଲ଼କୁ ବୀହା ଆ଼ଅରି, କି ବୀହା ହୀଅରି, ସାମା ଲାକପୂରୁତି ଦୂତୁୟାଁଲେହେଁ ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ସାମା ହା଼ତାରି ୱେଣ୍ତେ ନିଙ୍ଗିନି କାତା ମାହାପୂରୁ ମିଙ୍ଗେ ଏ଼ନାଆଁ ୱେସାମାଞ୍ଜାନେସି ଏ଼ଦାଆଁ ମୀରୁ ପ଼ଡ଼ୱି ଅ଼ହାହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ନା଼ନୁ ଅବ୍ରାହାମତି ମାହାପୂରୁ, ଇସାହାକତି ମାହାପୂରୁ, ଅ଼ଡ଼େ ଜାକୁବତି ମାହାପୂରୁତେଏଁ, ଏ଼ୱାସି ହା଼ତି ଲ଼କୁତି ମାହାପୂରୁ ଆ଼ଏ ସାମା ଜୀୱୁଗାଟାରି ମାହାପୂରୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଲ଼କୁ ବାରେ ଏ଼ୱାଣି ଜା଼ପ୍‌ନାଣି ୱେଞ୍ଜାନା କାବା ଆ଼ହାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଜୀସୁଇଁ ସାଦୁକିୟାଁ ୱେଣ୍ତେ ୱେସାଲି ଆ଼ଡି ହିଲଅରି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ପାରୁସିୟାଁ ବିତ୍ରାଟି ରୁଣ୍ତା ଆ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଅ଼ଡ଼େ ଏ଼ୱାରି ବିତ୍ରାଟି ମେ଼ରା ପୁନାସି ରଅସି ଜୀସୁଇଁ ତାୟିପାରିକିହିଁ ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଗୂରୁ ବାରେ ହୁକୁମିକା ବିତ୍ରାଟି ଆମିନି ହୁକୁମି କାଜାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ନୀନୁ ନୀ ବାରେ ହିୟାଁ, ନୀ ବାରେ ଜୀୱୁ ବାରେ ଅଣ୍‌ପୁ ତଲେ ପ୍ରବୁ ନୀ ମାହାପୂରୁଇଁ ଜୀୱୁ ନ଼ମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଈଦିଏ ବାରେ ହୁକୁମିକା କିହାଁ କାଜାୟି ଇଞ୍ଜାଁ ତଲିତି ହୁକୁମି । ");
INSERT INTO kxv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ଏ଼ଦାଣି ଜେ଼ଚତି ହୁକୁମି ଜିକେଏ ଏଲେକିହିଁଏ, ନୀନୁ ନୀ ପା଼ଡ଼ିତି ଲ଼କୁଣି ନୀ ଜୀୱୁତି ଜୀୱୁ ନ଼ହାଁ କଡିନି ଲେହେଁ ଜୀୱୁ ନ଼ମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଈ ରୀ ହୁକୁମିତା ମ଼ସାତି ବାରେ ମେ଼ରା, ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ମାଞ୍ଜାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ପାରୁସିୟାଁ ରୁଣ୍ତା ଆ଼ହାମାଚାଟି ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କ୍ରୀସ୍ତଇଁ ମୀରୁ ଆମ୍ବାଆସି ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ଏ଼ୱାସି ଆମ୍ବାଆରି ମୀର୍‌ଏସି ?” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି “ଦାୱୁଦ ମୀର୍‌ଏସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ଦାୱୁଦ ଏ଼ନିକିଁ ସୁଦୁଜୀୱୁ ତଲେ ଏ଼ୱାଣାଇଁ ପ୍ରବୁ ଇଞ୍ଜିଁ ମାଚେସି ?” ଦାୱୁଦ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ପ୍ରବୁ ନା଼ ପ୍ରବୁଇଁ ୱେସ୍ତେସି, ନା଼ନୁ ନୀ ସାତ୍ରୁୟାଁଣି ନୀ କଡାୟାଁ ଡ଼଼ଇ ଇଟାଆ ପାତେକା ନା଼ ଟିଃନି ଟଟତା କୁଗାମାନାମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ଇଚିହିଁ ଦାୱୁଦ ତା଼ନୁଏ ଏ଼ୱାଣାଇଁ ପ୍ରବୁ ଇଚିହିଁ, କ୍ରୀସ୍ତ ଏ଼ନିକିଁ ଦାୱୁଦ ମୀର୍‌ଏସି ଆ଼ନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଏମ୍ବାଟି ଆମ୍ବାଆସି ଜିକେଏ ଏ଼ୱାଣାଇଁ ୱେଣ୍ତେ ୱେସାଲି ଆ଼ଡାଆତେସି, ଅ଼ଡ଼େ ଏ଼ ନେ଼ଚୁଟିଏ ଆମ୍ବାଆସି ଜିକେଏ ଜୀସୁଇଁ ଏ଼ନି କାତା ୱେଞ୍ଜାଲି ସା଼ସା କିଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଏଚିବେ଼ଲାତା ଜୀସୁ ବାରେ ଲ଼କୁଇଁ ଇଞ୍ଜାଁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ମେ଼ରାପୁନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ ମ଼ସାତି ମେ଼ରା ଜା଼ପ୍‌ହାଲି ପା଼ଣା ବେଟାଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ମିଙ୍ଗେ ଏ଼ନାଆଁ ୱେସ୍ତାତିହିଁ ଏ଼ଦାଆଁ ମା଼ନୱି ଆ଼ଦୁ, ଅ଼ଡ଼େ ଏ଼ୱାରି ୱେସ୍ତିଲେହେଁ କିଦୁ, ସାମା ଏ଼ୱାରି କାମା କିନିଲେହେଁ କାମା କିଆଦୁ, ଇଚିହିଁ ଏ଼ୱାରି ଏ଼ନାଆଁ କିନାୟିମାନେ ଇଞ୍ଜିଁ ୱେହ୍‌ନେରି ସାମା ଏ଼ୱାରି କିଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ଏ଼ୱାରି ବ଼ଜୁଗାଟି କା଼ସ୍‌କା ଦସାନା ଲ଼କୁ ବମିତା ଏକ୍‌ନେରି ସାମା ତା଼ମ୍ବୁ ତାମି ର଼ ୱାଞ୍ଜୁ ତଲେ ଜିକେଏ ପେର୍‌ହାଲି ମ଼ନ କିଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ଏ଼ୱାରି ଲ଼କୁଣି ତ଼ସାଲି ତାମି କିନି କାମା ବାରେ କିନେରି, ଇଚିହିଁ ଏ଼ୱାରି ପା଼ଟାୟାଁଣା ଦାର୍ମୁ ପତିତି କାତା ରା଼ଚାନା ମ଼ପା ଅ଼ଡ଼େ ମୁଞ୍ଜୁତା ଦସା କଡିନେରି, ଇଞ୍ଜାଁ ତାମି ହିମ୍ବରିକାତି ପୁର୍‌ଡ଼େୟାଁ କାଜା କାଜାଆଁ କିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଅ଼ଡ଼େ ବ଼ଜିତା ନେହିଁ ଟା଼ୟୁ ଇଞ୍ଜାଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ନେହିଁ କାଜା ଟା଼ୟୁ ପାରିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ଇଞ୍ଜାଁ ହା଼ଟା ବାଜାରାତା ଜହରା ବେଟାଆ଼ହାଲି ଅ଼ଡ଼େ ଲ଼କୁ ତା଼ଣାଟି ଗୂରୁ ଇଞ୍ଜିଁ ମା଼ନି ବେଟାଆ଼ହାଲି ନେହାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ସାମା ମୀରୁ ଗୂରୁ ଇଞ୍ଜିଁ ମା଼ନି ବେଟାଆ଼ହାଲି ଅଣ୍‌ପାଆଦୁ, ଇଚିହିଁ ମୀ ଗୂରୁ ରଅସି ମାନେସି, ଇଞ୍ଜାଁ ମୀରୁ ବାରେତାୟି ତାୟିୟାଁତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଅ଼ଡ଼େ ଦାର୍‌ତିତା ଆମ୍ବାଆରାଇଁ ଜିକେଏ ଆ଼ବା ଇଞ୍ଜିଁ ମା଼ନି କିଆଦୁ, ଇଚିହିଁ ମୀ ଆ଼ବା ରଅସିଏ ଲାକପୂରୁ ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଅ଼ଡ଼େ ମୀରୁ ସା଼ଲୱି କିନାତମି ଇଞ୍ଜିଁ ମା଼ନି ପ୍ଣାଃଆଦୁ, ଇଚିହିଁ ମିଙ୍ଗେ ସା଼ଲୱି କିୟାନାସି ରଅସିଏ ଏ଼ୱାସି କ୍ରୀସ୍ତ । ");
INSERT INTO kxv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ସାମା ମୀ ବିତ୍ରା ଆମ୍ବାଆସି କାଜାସି ଏ଼ୱାସି ମୀ ସେ଼ବା କିନାସି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ତାଙ୍ଗେ କାଜାତେଏଁ ଇଞ୍ଜିଁ ଇଞ୍ଜାଁ କଡିନେସି, ଏ଼ୱାଣାଇଁ ଊଣା କିୱିଆ଼ନେ, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ତାଙ୍ଗେ ଊଣା କିହାକଡିନେସି, ଏ଼ୱାଣାଇଁ କାଜାସି କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରା ପୁନାତେରି, ଇଚିହିଁ ମୀରୁ ଲ଼କୁତାକି ଲାକପୂରୁ ରା଼ଜିତି ଦା଼ରା ସୁଣ୍ତିଦେରି; ମୀରୁ ମୀରୁଏ ଏମ୍ବାଆଁ ହ଼ଡି ହିଲଅତେରି, ଇଞ୍ଜାଁ ହ଼ଡାଲି ମ଼ନ ଗାଟି ଲ଼କୁଣି ଜିକେଏ ହ଼ଡାଲି ହୀହି ହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ମେ଼ରା ପୁନାତେରି ଅ଼ଡ଼େ ପାରୁସିୟାଁତେରି, ଇଚିହିଁ ମୀରୁ ଉଜେ ଉଜେଏ ଲାମ୍ବା ପ୍ରା଼ତାନା କିହାନା ରା଼ଣ୍ତେଣିସିକା ଇଲ୍‌କା ସେନ୍ଦିନାତେରି; ଏ଼ଦାଆଁତାକି ମୀରୁ ହା଼ରେକା ଡଣ୍ତ ବେଟାଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରା ପୁନାତେରି, ଇଚିହିଁ ମୀରୁ ରଅଣାଇଁ ଜୀହୁଦି ଦାର୍ମୁତା ଆଟ୍‌ହାଲି ସାମ୍‌ଦୁରି ଆତାଲା ଗା଼ଣ୍‌ଚାନା ଦେ଼ସା ରେ଼ଜେରି, ଇଞ୍ଜାଁ ଏଚିବେ଼ଲା ଏ଼ୱାସି ଆଣ୍ତାନେସି, ଏଚିବେ଼ଲାତା ମୀରୁ ଏ଼ୱାଣାଇଁ ମୀ କିହାଁ ହା଼ରେକା ଆଗାଡ଼ା ନର୍କତା ମେତ୍‌ପି ଆ଼ନାସି କିହାନା ଲାଗେଏ କିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ଆୟ଼ତା ଡଣ୍ତ ବେଟା ଆ଼ନାତେରି କା଼ଣାୟାଁଇଁ ଜିରୁ ତ଼ହ୍‌ନାତେରି, ମୀରୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜେରି, ଆମ୍ବାଆସି ମାହାପୂରୁ ଇଲୁତି ପାର୍‌ମାଣା କିତିହିଁ ଏ଼ନାୟି ହିଲେଏ, ସାମା ଆମ୍ବାଆସି ଇଲୁତି ବାଂଗାରାତି ପାର୍‌ମାଣା କିତିହିଁ ଏ଼ୱାସି ପାର୍‌ମାଣା କିତିଲେହେଁ ତାପାଆନା କାମା କିନାୟିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଆଡ଼େ କା଼ଣାୟାଁ ଅ଼ଡ଼େ ବୁଦି ହିଲାଆଗାଟାତେରି ବାଂଗାରା କି ଏ଼ ବାଂଗାରାତି ସୁଦୁ କିହାମାନି ଦେ଼ୱୁଡ଼ି, ଈ ରୀ ବିତ୍ରାଟି ଆମିନାୟି କାଜାୟି ? ");
INSERT INTO kxv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଅ଼ଡ଼େ ମୀରୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜେରି, ଆମ୍ବାଆସି ମାହାପୂରୁ ଇଲୁ ପିଣ୍ତାତି ପାର୍‌ମାଣା କିତିହିଁ ଏ଼ନାୟି ଆ଼ଏ, ସାମା ଆମ୍ବାଆସି ପୂଜାପିଣ୍ତା ଲାକ ମାନି ଦା଼ନାତି ପାର୍‌ମାଣା କିତିହିଁ, ପାର୍‌ମାଣା କିତିଲେହେଁ ତାପାଆନା କାମା କିନାୟିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ଆଡ଼େ କା଼ଣାୟାଁତେରି, ଦା଼ନା କି ଏ଼ ଦା଼ନାତି ସୁଦୁ କିହିମାନି ମାହାପୂରୁ ଇଲୁତି ପୂଜାପିଣ୍ତା, ଈ ରୀ ବିତ୍ରାଟି ଆମିନାୟି କାଜାୟି ? ");
INSERT INTO kxv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ଏ଼ଦାଆଁତାକି ଆମ୍ବାଆସି ଦା଼ନାହୀନି ପିଣ୍ତାତି ପାର୍‌ମାଣା କିନେସି, ଏ଼ୱାସି ଏ଼ ପିଣ୍ତା ଅ଼ଡ଼େ ପିଣ୍ତାତା ମାନି ଦା଼ନାତି ପାର୍‌ମାଣା କିହିମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ମାହାପୂରୁ ଇଲୁତି ପାର୍‌ମାଣା କିନେସି, ଏ଼ୱାସି ମାହାପୂରୁ ଇଲୁ ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ବାସାଆ଼ହାମାନି ମାହାପୂରୁଇଁ ପାର୍‌ମାଣା କିନେସି; ");
INSERT INTO kxv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଲାକପୂରୁତି ପାର୍‌ମାଣା କିନେସି, ଏ଼ୱାସି ମାହାପୂରୁତି ସିଂଗାସାଣି ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ କୁଗାମାନି ମାହାପୂରୁଇଁ ପାର୍‌ମାଣା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ମେ଼ରା ପୁନାତେରି ଇଞ୍ଜାଁ ପାରୁସିୟାଁ, ଇଚିହିଁ ମୀରୁ କୁମ୍ବୁରି କୁଚା, ରା଼ୟି, ଜିରା ଇନି ଊଣା ତା଼ସା ବିତ୍ରାଟି ଜିକେଏ ଦସ ବା଼ଗାଟି ର଼ ବା଼ଗା ହୀହିମାଞ୍ଜେରି, ଅ଼ଡ଼େ ମ଼ସା ମେ଼ରାତି କାଜା କାତାୟାଁ ଇଚିହିଁ ସାତା ନୀହାଁୟି କିନାୟି, କାର୍ମା ତ଼ହ୍‌ନାୟି, ଇଞ୍ଜାଁ ନାମୁ, ଈ ବାରେ ପିସାମାଞ୍ଜେରି; ସାମା ଈ ବାରେ ମା଼ନୱି ଆ଼ହାନା ଅ଼ଡ଼େ ଏ଼ ବାରେ ପିହ୍‌ଆୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଆଡ଼େ କା଼ଣାୟାଁ ଜିରୁ ତ଼ହ୍‌ନାତେରି, ମୀରୁ ୱୀହାଁତି ହା଼ଣି କିଦେରି ସାମା ଊଟୁଇଁ ଗୂହ୍‌ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ମେ଼ରା ପୁନାତେରି ଇଞ୍ଜାଁ ପାରୁସିୟାଁତେରି, ଇଚିହିଁ ମୀରୁ ଗିନା ଅ଼ଡ଼େ ସାଡ଼ୱାତି ପାଙ୍ଗାତା ନର୍‌ହି ମାଞ୍ଜେରି, ସାମା ଏ଼ ବିତ୍ରା ଜୂପ୍‌କା ଆ଼ହାଁ ସ଼ରୁ କିତି ଆ଼ସ୍ତି ବାରେ ନେଞ୍ଜି କିହାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ଆଡ଼େ କାଣ୍‌କା ମେହ୍‌ଆଗାଟି ପାରୁସିୟାଁ, ନ଼କେଏ ଗିନାତି ବିତ୍ରାତାଣି ନର୍‌ଦୁ, ଏ଼ନିକିଁ ପାଙ୍ଗାତା ଜିକେଏ ନର୍‌ୱି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ମେ଼ରା ପୁନାତେରି ଇଞ୍ଜାଁ ପାରୁସିୟାଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀରୁ ହୁନୁ ଊସ୍‌ପିତି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଲେହେଁ ତାତେରି । ଏ଼ଦି ପାଙ୍ଗାତା ଅଜିକିଁ ତ଼ଞ୍ଜାଆ଼ନେ, ସାମା ବିତ୍ରା ହା଼ତାରି ପେ଼ଣ୍‌କା ଇଞ୍ଜାଁ ସୀର୍‌ତାୟି ନେଞ୍ଜାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ପାଙ୍ଗାତି ଲ଼କୁ ନ଼କିତା ଦାର୍ମୁଗାଟାତେରି ଲେହେଁ ତ଼ଞ୍ଜା ଆ଼ଦେରି, ସାମା ମୀ ହିୟାଁ ବିତ୍ରା କୁଟୁ ଅ଼ଡ଼େ ପା଼ପୁ ନେଞ୍ଜାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କୁଟୁଗାଟି ମେ଼ରା ପୁନାତେରି ଇଞ୍ଜାଁ ପାରୁସିୟାଁ, ଇଚିହିଁ ମୀରୁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁ କେ଼ପାନା, ଦାର୍ମୁଗାଟାରି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତି ମୁଣ୍ତା ଅଜିକିଁ କିହାନା ଏଲେଇଞ୍ଜିମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ମା଼ମ୍ବୁ ମା଼ ଆକୁ ଆ଼ବାୟାଁ ବେ଼ଲାତା ମାଚିହିଁମା, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ପା଼ୟାଲି ଆଣ୍ତାଆତମିମା । ");
INSERT INTO kxv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଏ଼ଦାଆଁତାକି ମୀରୁଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ପା଼ୟାମାନି ଲ଼କୁତି ମୀର୍‌କାତେରି, ଏ଼ କାତାତାକି ମୀରୁଏ ମିଙ୍ଗେ ସା଼କି ହୀହା କଡିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ମୀରୁ ହାଜାନା ମୀ ଆକୁ ଆ଼ବାୟାଁ କିତି କାମା ରା଼ପ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଆଡ଼େ ରା଼ସ୍‌କାତେରି, ଇଞ୍ଜାଁ ବୀସା ଗାଟି ରା଼ସ୍‌କା କୂଡ଼ାତି ମୀର୍‌କାତେରି, ମୀରୁ ବିଚାରା ଦିନାତା ଏ଼ନିକିଁ ହିଚୁ ଗୁଦ୍‌ୱାତି ଡଣ୍ତଟି ପିସ୍‌ପି ଆ଼ଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଏ଼ଦାଆଁତାକି ମେହ୍‌ମୁ ନା଼ନୁ ମୀ ତା଼ଣା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ, ବୁଦି ଗାଟାରାଇଁ, ଇଞ୍ଜାଁ ଜା଼ପ୍‌ନି ଗୂର୍‌କାଇଁ ପାଣ୍ତିମାଞ୍ଜାଇଁ; ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରାଇଁ ପା଼ୟିଦେରି, ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟିଦେରି, ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରାଇଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ସା଼ଟ୍‌ଣି ଡ଼଼ରିତଲେ ୱେଦେରି, ଇଞ୍ଜାଁ ଗା଼ଡ଼ାତାକି ଗା଼ଡ଼ା ଗଡ଼୍‌ହା ନିନ୍ଦା କିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଏ଼ନିକିଁ ଦାର୍ମୁଗାଟି ହେବଲଇଁ ପା଼ୟିତି ଦିନାଟିଏ, ମାହାପୂରୁ ଇଲୁ ପିଣ୍ତା ଦାରିତା ବେରିକିୟ ମୀର୍‌ଏସି ଜିକରିୟଇଁ ପା଼ୟିତି ପାତେକା, ଦାର୍‌ତିତା ଏଚେକା ନେହାଁରାଇଁ ପା଼ୟାମାଞ୍ଜେରି, ଏ଼ ବାରେ କାମାତି ଡଣ୍ତ ମୀ ମୁହେଁ ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଈ କା଼ଲାତି ଲ଼କୁ ମୁହେଁ ଈ ବାରେ ଡଣ୍ତ ରିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ଏ଼ ଜିରୁସାଲମ, ଏ଼ ଜିରୁସାଲମ ! ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ପା଼ୟିନାତି ନୀ ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ୱାଲ୍‌କାତଲେ ୱେନାତି, କୟୁ ଏ଼ନିକିଁ ତାନି ହୀପାୟାଁଣି କୂଡ଼ି କିହାନା ମା଼ରାୟାଁ ଡ଼଼ଇ ପ୍ଡିକ୍‌ହାନା ଜ଼ଙ୍ଗିନେ, ନା଼ନୁ ନୀ ଲ଼କୁଇଁ ଏଚର ପା଼ଲି ଏଲେକିଁ କୂଡ଼ିକିହାଲି ମ଼ନ କିତେଏଁ, ସାମା ଏ଼ୱାରି ମ଼ନ ହୀଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ମୀ ମାହାପୂରୁ ଇଲୁ ମୀ କେୟୁତା ହୀପ୍‌କି ଆ଼ହାମାଞ୍ଜାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ଦ଼ରୁଟି ଆମ୍ବାଆସି ୱା଼ହିମାନେସି, ଏ଼ୱାସି ନେହାଁସି, ମୀରୁ ଏ଼ କାତା ଜ଼ଲାଆ ପାତେକା ନୀଞ୍ଜୁଟିଏ ନାଙ୍ଗେ ଅ଼ଡ଼େ ମେସ୍ତଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜୀସୁ ମାହାପୂରୁ ଇଲୁଟି ହ଼ଚା ହାଜିମାଚାଟି ତାନି ସୀସୁୟାଁ ମାହାପୂରୁ ଇଲୁତି ବାରେ ଇଲ୍‌କାଣି ତ଼ସାଲି ତାନି ତା଼ଣା ୱା଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଈ ବାରେ ମେସି ହିଲଅତେରି ? ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଇମ୍ବାଆଁ ମାନି ର଼ ୱାଲି ଅ଼ର ୱାଲି ଲାକ ଡ଼ୟେଏ, ଈ ବାରେଏ ମେଣ୍‌ଙ୍ଗାହାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଡା଼ୟୁ ଜୀସୁ ଜୀତ ହ଼ରୁ ଲାକ କୁଗାଲିଏ, ତାନି ସୀସୁୟାଁ ମେ଼ଣେଏ ୱା଼ହାନା ୱେଚେରି, “ଈ ବାରେ ଏଚେଲା ଆ଼ନେ, ଅ଼ଡ଼େ ନୀନୁ ୱା଼ନାୟି ଇଞ୍ଜାଁ ଜୁଗୁ ରା଼ନି ଦିନାତି ସିନା ଏ଼ନାୟି ଏ଼ଦାଆଁ ମାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଜାଗ୍ରାତା ଏ଼ନିକିଁ ଆମ୍ବାଆରି ମିଙ୍ଗେ ନା଼ଡ଼ି କିୟଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ଇଚିହିଁ ହା଼ରେକା ନା଼ ଦ଼ରୁଟି ୱା଼ହାନା ନା଼ନୁ କ୍ରୀସ୍ତତେଏଁ ଇଞ୍ଜିଁ ୱେସାନା ହା଼ରେକା ଲ଼କୁଇଁ ନା଼ଡ଼ି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ଅ଼ଡ଼େ ମୀରୁ ଜୁଜୁତି କାତା ଇଞ୍ଜାଁ ଜୁଜୁତା କା଼ଲୱି ଆ଼ହିମାନି ଲ଼କୁତି ହା଼ଡା ୱେଞ୍ଜେରି; ଜାଗ୍ରାତା କିଲିବିଲି ଆ଼ଆଦୁ । ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଈ ବାରେ ଆ଼ନାୟି ମାନେ, ସାମା ଏ଼ କା଼ଲା ଜୁଗୁ ରା଼ନାୟି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଇଚିହିଁ ଦେ଼ସା କ଼ପାଟି ଦେ଼ସା, ଅ଼ଡ଼େ ରା଼ଜି କ଼ପାଟି ରା଼ଜି ଗଡ଼୍‌ହା ନିଙ୍ଗିନେ, ଇଞ୍ଜାଁ ଆମ୍ବି ଆମ୍ବିୟା କାର୍‌ୱୁ ଆ଼ନେ, ଅ଼ଡ଼େ ବୂମି ୱୀଡିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ସାମା ଈ ବାରେ କକାରି ପ଼ଦାୟାଁ ବେଟାଆ଼ନାଟି ତଲିଏ ଲୁଞ୍ଜିନି ବୀସାଲେହେଁତାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ଏଚିବେ଼ଲାତା ଲ଼କୁ ମିଙ୍ଗେ କସ୍ତ ହିୟାଲି ହେର୍‌ପାନେରି, ଇଞ୍ଜାଁ ମିଙ୍ଗେ ପା଼ୟାନେରି, ଇଞ୍ଜାଁ ନା଼ ଦ଼ରୁ ତାକି ମୀରୁ ବାରେ କୂଡ଼ାତି ଲ଼କୁ ତା଼ଣା ଅ଼ପାଆ ଗାଟାତେରି ଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ଏଚିବେ଼ଲା ହା଼ରେକା ଲ଼କୁ ତାମି ନାମୁତି ପିହ୍‌ନେରି, ଅ଼ଡ଼େ ରଅସି ରଅଣାଇଁ ଆସ୍‌ପି କିୱି କିନେରି, ଅ଼ଡ଼େ ରଅସି ରଅଣାଇଁ ଅ଼ପ୍‌ୱି ଆ଼ଅରି, ");
INSERT INTO kxv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଅ଼ଡ଼େ ହା଼ରେକା ମାହାପୂରୁତି ମିଚି ବ଼ଲୁ ୱେହ୍‌ନାରି ନିଙ୍ଗାନା ହା଼ରେକା ଲ଼କୁଇଁ ନା଼ଡ଼ି କିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଅ଼ଡ଼େ ଲାଗେଏ ପ଼ଲେଏ କାମା ଗାଡି ଆ଼ତିସାରେ, ହା଼ରେକା ଲ଼କୁତି ତାମି ଜୀୱୁନ଼ନାୟି ଊଣା ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ସାମା ଆମ୍ବାଆସି ରା଼ନି ପାତେକା ସା଼ସା ଆସାନା ଡ଼ୟିନେସି ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଅ଼ଡ଼େ ବାରେ ଲ଼କୁ ନ଼କିତା ସା଼କି ଆ଼ହାଲିତାକି, ମାହାପୂରୁ ରା଼ଜିତି ଈ ନେହିଁ କାବ୍ରୁ ବାରେ ଦାର୍‌ତିତା ୱେ଼ପ୍‌କିଆ଼ନେ, ଡା଼ୟୁ ଜୁଗୁ ରା଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ଏ଼ଦାଆଁତାକି ମୀରୁ ଏଚିବେ଼ଲା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଦାନିୟେଲ ୱେସ୍ତି କାତାଲେହେଁ ନା଼ସାକିନି ଅ଼ପାଆଗାଟି ଆ଼ସ୍ତିତି ସୁଦୁ ଟା଼ୟୁତା ଇଟାମାନାଣି ମେହ୍‌ଦେରି” ପ଼ଡ଼ୱି ଆ଼ନାସି ଜାଗ୍ରାତା ଆ଼ହାନା ପୁଣ୍‌ମ୍ବେସି ");
INSERT INTO kxv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ଏଚିବେ଼ଲା ଆମ୍ବାଆରି ଜୀହୁଦା ରା଼ଜିତା ମାନେରି, ଏ଼ୱାରି ହ଼ର୍‌କା ଲାକ ହଣ୍‌ପାରି; ");
INSERT INTO kxv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଆମ୍ବାଆସି ଇଲୁ ଲାକ ମାନେସି, ଏ଼ୱାସି ତାନି ଇଲୁ ବିତ୍ରା ଆ଼ସ୍ତି ତାକାହାଜାଲି ରେ଼ଚା ୱା଼ଆପେସି; ");
INSERT INTO kxv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଗୁଡିୟାତା ମାନେସି, ଏ଼ୱାସି ତାନି ହିମ୍ବରି ଅ଼ହାଲି ୱେଣ୍ତେ ହାଲାଆପେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ଏଚିବେ଼ଲାତା ପୂରାମା଼ସା ଆ଼ହାମାନାଇ ଇଞ୍ଜାଁ ପା଼ଲୁ ଊଟ୍‌ହିମାନାଇ ଆୟ଼ତା ଏ଼ୱି ଊଣେଏ କସ୍ତ ପା଼ଣ୍‌ନୁ, ");
INSERT INTO kxv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ସାମା ମୀ ହଣ୍‌ନାୟି ପେନି ବେ଼ଲାତା କି ଜ଼ମିନି ଦିନାତା ଆ଼ଆପେ, ଏ଼ଦାଆଁତାକି ପ୍ରା଼ତାନା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଇଚିହିଁ ଏଚିବେ଼ଲାତା ଇଲେତି କସ୍ତ ଆ଼ନେ, ମାହାପୂରୁ ଦାର୍‌ତିତି ଗା଼ଡ଼ିକିତି ଦିନାଟିଏ ନୀଞ୍ଜୁପାତେକା ଏଲେକିଁ ଆ଼ହା ହିଲେଏ, ଇଞ୍ଜାଁ ଏଲେକିଁ ଏଚେଲାୱା ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ଅ଼ଡ଼େ ମାହାପୂରୁ ଏ଼ ବେ଼ଲାତି ଊଣା କିହା ହିଲାଆତିହିଁମା; ଦାର୍‌ତିତା ଆମ୍ବାଆସି ଜିକେଏ ଗେଲ୍‌ପି ଆ଼ଆତେସିମା, ସାମା ତାନି ଆ଼ଚିତି ଲ଼କୁତାକି ଏ଼ କସ୍ତ ଊଣା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ଏଚିବେ଼ଲା, ‘ମେହ୍‌ଦୁ କ୍ରୀସ୍ତ ଇମ୍ବାଆଁ ମାନେସି ଆ଼ଆତିଁ ଏମ୍ବାଆଁ ମାନେସି’ ଇଞ୍ଜିଁ ଆମ୍ବାଆସି ମିଙ୍ଗେ ଏଲେକିହିଁ ୱେସ୍ତାନେସି ଇଚିହିଁ ଏ଼ଦାଆଁ ନାମାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଇଚିହିଁ ନା଼ଡ଼ିକିନି କ୍ରୀସ୍ତୟାଁ ଅ଼ଡ଼େ ମାହାପୂରୁ ବ଼ଲୁ ମିଚି ୱେହ୍‌ନାରି ନିଙ୍ଗାନା ହା଼ରେକା କାଜା ସିନା ଅ଼ଡ଼େ କାବାଆ଼ନି କାମାୟାଁ ତ଼ହ୍‌ନେରି, ଆ଼ଡିତିହିଁ ଆ଼ଚ୍‌ୱିଆ଼ତି ଲ଼କୁଣି ଜିକେଏ ନା଼ଡ଼ି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ମେହ୍‌ଦୁ ନା଼ନୁ ମିଙ୍ଗେ ତଲିଏ ୱେସାମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ଈଦାଆଁତାକି ‘ମେହ୍‌ଦୁ ଏ଼ୱାସି ବାଟାତା ମାନେସି’ ଇଞ୍ଜିଁ ଲ଼କୁ ୱେସ୍ତାତିହିଁ ହାଲାଆଦୁ; ‘ମେହ୍‌ଦୁ ବିତ୍ରା ବାକ୍ରାତା ମାନେସି’ ଇଞ୍ଜିଁ ୱେସ୍ତାତିହିଁ ଏ଼ଦାଆଁ ନାମାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଇଚିହିଁ ହା଼ଗୁ ମ୍ଣିହ୍‌ନି ବେ଼ଲାତି ଉଜେଡ଼ି ଏ଼ନିକିଁ ୱେ଼ଡ଼ା ହ଼ପୁ ୱାକିଟି ହ଼ଚାନା ୱେ଼ଡ଼ା କୂଡ଼୍‌ନି ପାତେକା ତ଼ଞ୍ଜାଆ଼ନେ, ଏଲେଆ଼ହିଁଏ ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ଏମ୍ବିୟା ମାଡ଼୍‌ହା ରିହାମାନେ ଏମ୍ବାଆଁ ରା଼ମ୍‌ଣାୟାଁ ରୁଣ୍ତା ଆ଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ସାମା ଏଚିବେ଼ଲାତି କସ୍ତ ଡା଼ୟୁ ଦେବୁଣିଏ ୱେ଼ଡ଼ା ଆନ୍ଦେରି ଆ଼ନେ, ଅ଼ଡ଼େ ଲେ଼ଞ୍ଜୁ ଉଜେଡ଼ି ହୀଏ, ଅ଼ଡ଼େ ହା଼ଗୁଟି ହୁକାୟାଁ ତର୍‌ଗିନୁ, ଇଞ୍ଜାଁ ହା଼ଗୁ ଲାକତି ବା଼ଡ଼୍‌ୟୁ ବାରେ ୱୀଡିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ଏଚିବେ଼ଲା ହା଼ଗୁ ଲାକଟି ମାଣ୍‌ସି ମୀର୍‌ଏଣି ସିନା ତ଼ଞ୍ଜାଆ଼ନେ, ଇଞ୍ଜାଁ ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ କାଜା ବା଼ଡ଼୍‌ୟୁ ଅ଼ଡ଼େ ଗାୱୁରମିଗାଟି ଉଜେଡ଼ି ତଲେ ହା଼ଗୁତି ଦୂନ୍ଦ୍ରାଟି ୱା଼ନାଣି ମେସାନା ଦାର୍‌ତିତି ବାରେ କୂଡ଼ାତି ଲ଼କୁ ହା଼ରେକା ଦୁକୁ ତଲେ ଡ଼ୀନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ଅ଼ଡ଼େ ଏ଼ୱାସି ତୀତ୍ରି ମ଼ହ୍‌ରି ହା଼ଡାତଲେ ତାନି ଦୂତୁୟାଁଣି ପାଣ୍ତିନେସି ଇଞ୍ଜାଁ ଏ଼ୱାରି ଦାର୍‌ତି ମୁଟ୍‌ପେତି ହାନ୍ଦିଟିଏ ହା଼ଗୁଲାକତି ମୁଟ୍‌ପେ ହାନ୍ଦି ପାତେକା ସା଼ରିୱାକିଟି ତାନି ଆ଼ଚାମାନି ଲ଼କୁଣି ରୁଣ୍ତା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ତ଼ୟା ମା଼ର୍‌ନୁ ପୁଣ୍‌ମ୍ବି କିନି କାତାଟି ଜା଼ପାଦୁ; ଏଚିବେ଼ଲା କମାତା ଆ଼କା ଗା଼ଲ୍‌ନାଣି ମେସ୍ତିହିଁ କାରାୟାଁ ୱେ଼ଡ଼ା ୱା଼ତେ ଇଞ୍ଜିଁ ପୁଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ଈ ବାରେ ମେସ୍ତିସାରେ ଏ଼ୱାସି ଦୁୱେରି ଡାଗେ ମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଈ ବାରେ ଗଟୱି ଆ଼ଆପାତେକା ଈ କା଼ଲାତି ଲ଼କୁ ଏ଼ନିଜିକେଏ ମେଣ୍‌ଙ୍ଗଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ହା଼ଗୁପା଼କା ଦାର୍‌ତି ବାରେ ମେଣ୍‌ଙ୍ଗିନେ, ସାମା ନା଼ ବ଼ଲୁ ଏଚେଲାୱା ମେଣ୍‌ଙ୍ଗେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ସାମା ଏ଼ ଦିନା ଡଣ୍ତତି କାତା ଆମ୍ବାଆସି ପୁନଅସି, ଲାକପୂରୁତି ଦୂତୁୟାଁ କି ମୀର୍‌ଏସି ଜିକେଏ ପୁନଅସି, ୱାର୍‌ଇ ଆ଼ବାଦେ ପୁନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଅ଼ଡ଼େ ନ଼ହ ବେ଼ଲାତା ଏ଼ନିକିଁ ଆ଼ହାମାଚେ, ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନି ବେ଼ଲାତା ଏଲେକିଁ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଇଚିହିଁ ୱା଼ରୁ କ୍ଡୁପ୍‌ନି ନ଼କେଏ, ନ଼ହ ଡଂଗତା ହ଼ଡ଼ନି ଦିନା ପାତେକା ଲ଼କୁ ଏ଼ନିକିଁ ତିଞ୍ଜି ଉଣ୍ତିହିଁ, ବୀହା କିୟାଲି ବୀହା ହିୟାଲି ହେ଼ରାମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଇଞ୍ଜାଁ କାଜା ପିୟୁତଲେ ୱା଼ରୁ ୱା଼ହାନା କ୍ଡୁପ୍‌ହା ଅ଼ନି ପାତେକା ଏ଼ନିକିଁ ଏ଼ୱାରି ପୁଞ୍ଜାହିଲାଆତେରି, ମାଣ୍‌ସି ମୀର୍‌ଏଣା ୱା଼ନାୟି ଜିକେଏ ଏଲେଆ଼ହିଁଏ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ଏଚିବେ଼ଲାତା ରିଆରି ଗୁଡିୟାତା ମାନେରି, ରଅସି ଅ଼ୱିଆ଼ନେସି ରଅସି ଏମ୍ବାଆଁ ଡ଼ୟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ରୀ ଇୟାସିକା ଜେତାତା ନୂୟିଁମାନୁ ରଣ୍ତି ଅ଼ୱିଆ଼ନେ ଅ଼ଡ଼େ ରଣ୍ତି ଏମ୍ବାଆଁ ଡ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ଈଦାଆଁତାକି ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀ ପ୍ରବୁ ଆମିନି ଦିନା ୱା଼ନେସି, ଏ଼ଦାଆଁ ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ସାମା ଈଦାଆଁ ପୁଞ୍ଜାମାଞ୍ଜୁ, ଆମିନି ନେ଼କେରିତା ସ଼ରୁ ୱା଼ନେସି, ଏ଼ଦାଆଁ ସା଼ୱୁକାରି ପୁଞ୍ଜାମାଚିହିଁମା, ଜାଗ୍ରାତା ଆ଼ହାନା ତାନି ଇଲୁତି କାତି ତୂତ୍‌ହାଲି ହୀଆତେସିମା । ");
INSERT INTO kxv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ଏ଼ଦାଆଁତାକି ମୀରୁ ଜିକେଏ କା଼ଚାନା ମାଞ୍ଜୁ, ଇଚିହିଁ ଆମିନି ବେ଼ଲାତା ମୀରୁ ଅଣ୍‌ପା ହିଲଅତେରି, ଏ଼ ବେ଼ଲାତା ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ସା଼ୱୁକାରି, ତାନି ଇଲୁତି ଲ଼କୁତାକି, ରା଼ନ୍ଦା କାଟୁତା ରା଼ନ୍ଦା ହୀହାଲି, ତାନି ଗୁମୁସ୍ତା ପା଼ଣା ଆମ୍ବାଆରାକି ହୀହାମାନେସି, ଇଲେତି ନାମୁ ଅ଼ଡ଼େ ବୁଦିଗାଟି ଗୁମୁସ୍ତା ଆମ୍ବାଆସି, ");
INSERT INTO kxv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ପ୍ରବୁ ୱା଼ହାନା ତାନି ଆମିନି ହ଼ଲେଏଣାଇଁ ଏଲେକିହିଁ ମାନାଣାଇଁ ମେହ୍‌ନେସି, ଏ଼ୱାସି ନେହାଁସି ! ");
INSERT INTO kxv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ତାନି ବାରେ ଦ଼ନତି ମୁହେଁ ଗୁମୁସ୍ତା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ସାମା ଏ଼ ହ଼ଲେଏସି ଲାଗେଏ ପ଼ଲେଏତାସି ଆ଼ହାନା, ନା଼ ସା଼ୱୁକାରି ୱା଼ନାୟି ମାନେୟିଏ ଇଞ୍ଜିଁ ତାନି ମ଼ନତା ଅଣ୍‌ପାନା, ");
INSERT INTO kxv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଏ଼ୱାସି ତାନି ତଲେତି ହ଼ଲିୟାଙ୍ଗାଣି ୱେଚିହିଁ, କା଼ଡ଼ୁ ଗହ୍‌ନାରି ତଲେ ତିଞ୍ଜିହିଁ ଗସିହିଁ ମାନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ଆତିହିଁ ଆମିନି ନେ଼ଚୁ ହ଼ଲେଏସି କା଼ଚାହିଲଅସି ଅ଼ଡ଼େ ଏମିନି ବେ଼ଲା ପୁଞ୍ଜାହିଲଅସି ଏ଼ ଦିନା ଏ଼ ବେ଼ଲାତା ତାନି ପ୍ରବୁ ୱା଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ରୀ ବା଼ଗା କିହିଁ ଦା଼ଚାନା କୁଟୁ ଗାଟାରି ତଲେ ତାନି ବା଼ଗା କିନେସି; ଏମ୍ବାଆଁ ଡ଼ୀନାୟି ଅ଼ଡ଼େ ପାଲ୍‌କା ଟୀଟି କିନାୟିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ଏଚିବେ଼ଲା ଲାକପୂରୁତି ରା଼ଜି ଦସ ଜା଼ଣା ଡ଼ାଆ ପ଼ଦାୟାଁ ଲେହେଁ ଆ଼ନେ; ଏ଼ୱି ତାମି ଦୀୱଁୟାଁ ଆସାନା ବୀହା ହନେଏଣାଇଁ ବେଟାଆ଼ହାଲି ହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ଏ଼ୱାସିକା ବିତ୍ରା ପା଼ସା ଜା଼ଣା ବୁଦି ହିଲାଆଗାଟାଇ ଇଞ୍ଜାଁ ପା଼ସା ଜା଼ଣା ବୁଦି ଗାଟାଇ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ବୁଦି ହିଲାଆଗାଟାଇ ତାମି ଦୀୱଁୟାଁ ଅ଼ତୁ ସାମା ଏଟ୍‌କା ନିୟୁଁ ଅ଼ଆତୁ, ");
INSERT INTO kxv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ସାମା ବୁଦି ଗାଟାଇ ତାମି ଦୀୱଁୟାଁ ତଲେ ଗା଼ଜୁତା ନିୟୁଁ ଅ଼ହିଁ ହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବୀହା ହନେଏସି ୱା଼ନାୟି ୱେ଼ଡ଼ା ଆୟାଲିଏ, ବାରେଜା଼ଣା କଟଣି ହ଼ଚିହିଁ ଡୂରାତୁସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ସାମା ମାଦି ଲା଼ଆଁୟାଁ ମେହ୍‌ଦୁ ବୀହା ଦାଂଗ୍‌ଣେଏସି ୱା଼ହିମାନେସି, ବେଟାଆ଼ହାଲି ୱା଼ଦୁ ଇଞ୍ଜିଁ ର଼ କାଜା ହା଼ଡା ଆ଼ତେ ! ");
INSERT INTO kxv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ଏମ୍ବାଟିଏ ଡ଼ାଆସିକା ନିଙ୍ଗାନା ତାମି ଦୀୱଁୟାଁ ପ୍ରତ୍‌ହୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ସାମା ବୁଦି ହିଲାଆଗାଟାଇ ବୁଦିଗାଟି ଡ଼ାଆସିକାଣି ଏଲେଇଚୁ, ମୀ ନିୟୁଁ ଇଚାଣି ଲାକା ମାଙ୍ଗେ ହିୟାଦୁ, ଇଚିହିଁ ମା଼ ଦୀୱଁୟାଁ ଡୁମ୍ବାହାଜିମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ସାମା ବୁଦିଗାଟାୟି ଏଲେଇଚୁ, ଆ଼ଏ ମିଙ୍ଗେ ଅ଼ଡ଼େ ମାଙ୍ଗେତାକି ନିୟୁଁ ଏ଼ଦେଏ, ବାଜାରାତା ହାଜାନା ମିଙ୍ଗେତାକି ନିୟୁଁ କଡା ତାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ସାମା ଏ଼ୱି ନିୟୁଁ କଡାଲି ହାଜିମାଚାଟି ହନେଏସି ୱା଼ତେସି; ଇଞ୍ଜାଁ ଆମିନି ଗାଟାଇ ତିୟାରା ଆ଼ହାନା କା଼ଚାମାଚୁ, ଏ଼ୱି ହନେଏଣି ତଲେ ବୀହା ବ଼ଜି ଇଲୁତା ହ଼ଟୁ, ଅ଼ଡ଼େ ଦା଼ରା ସୁଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ଏଚେଟିଏ ଡା଼ୟୁ ଅ଼ର ଡ଼ାଆ ପ଼ଦାୟାଁ ଜିକେଏ ୱା଼ହାନା ଏଲେଇଚୁ, ଏ଼ ପ୍ରବୁ ଏ଼ ପ୍ରବୁ ମାଙ୍ଗେତାକି ଦା଼ରା ଦେତାମୁ ଇଞ୍ଜିଁ ହା଼ଟିତୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ଏଚେଟିଏ ବୀହା ହନେଏସି ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନା଼ନୁ ମିଙ୍ଗ ପୁଞ୍ଜାମାଞ୍ଜଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଈଦାଆଁତାକି ଜାଗ୍ରାତା ମାଞ୍ଜୁ ଏ଼ ଦିନା କି ଏ଼ ଡଣ୍ତ ଆମ୍ବାଆରି ପୁନଅରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ଲାକପୂରୁ ରା଼ଜି ଇଲେତାୟି, ଇଚିହିଁ ହେକ ରା଼ଜି ହାଜିମାନି ର଼ ମାଣ୍‌ସି, ଏ଼ୱାସି ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ହା଼ଟାନା ତାନି ଦ଼ନତି ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ଏ଼ୱାସି ରଅଣାକି ପା଼ସାମା଼ଣା, ଅ଼ଡ଼େ ରଅଣାକି ରୀ ମା଼ଣା, ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ରଅଣାକି ର଼ ମା଼ଣା ଇଲେକିହିଁ ବାରେତାକି ତାମି ଆ଼ଡିନି ବା଼ଡ଼୍‌ୟୁ ତଲେ ହୀହାନା ହେକ ରା଼ଜିତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ଆମିନିଗାଟାସି ପା଼ସାମା଼ଣା ବେଟା ଆ଼ହାମାଚେସି, ଏ଼ୱାସି ଏ଼ୱାଆଁ ଅ଼ହାନା ବେ଼ବାରା କିହାନା ଅ଼ଡ଼େ ପା଼ସାମା଼ଣା ଲା଼ବା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ଏଲେକିହିଁଏ ଆମିନିଗାଟାସି ରୀ ମା଼ଣା ବେଟା ଆ଼ହାମାଚାସି ଏ଼ୱାସି ଜିକେଏ, ଅ଼ଡ଼େ ରୀ ମା଼ଣା ଲା଼ବା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ସାମା ଆମିନିଗାଟାସି ର଼ ମା଼ଣା ବେଟା ଆ଼ହାମାଚେସି, ଏ଼ୱାସି ହାଜାନା ବୂମି କା଼ର୍‌ହାନା ତାନି ସା଼ୱୁକାରି ଟାକାୟାଁଣି ମୁସାନା ଡ଼ୁକ୍‌ହା ଇଟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ହା଼ରେକା ଦିନା ହାଚି ଡା଼ୟୁ ଏ଼ ହ଼ଲିୟାଙ୍ଗାତି ସା଼ୱୁକାରି ୱା଼ହାନା, ଏ଼ୱାରିତଲେ ଲେକା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ଅ଼ଡ଼େ ଆମିନିଗାଟାସି ପା଼ସାମା଼ଣା ବେଟା ଆ଼ହାମାଚେସି, ଏ଼ୱାସି ଅ଼ଡ଼େ ପା଼ସାମା଼ଣା ତାଚାନା ଏଲେଇଚେସି, ପ୍ରବୁ ନୀନୁ ନାଙ୍ଗେ ପା଼ସାମା଼ଣା ହୀହାମାଞ୍ଜାତି; ମେହ୍‌ମୁ ନା଼ନୁ ଅ଼ଡ଼େ ପା଼ସାମା଼ଣା ଲା଼ବା କିହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ତାନି ସା଼ୱୁକାରି ତାଙ୍ଗେ ଏଲେଇଚେସି, ଆୟାଁଲେତା ନେହିଁ ଟିକାଣାଗାଟି ହ଼ଲେଏଣାତି, ନୀନୁ ଊଣା କାମାତା ନାମୁ ଗାଟାତି ଆ଼ହାମାଞ୍ଜି, ନା଼ନୁ ନିଙ୍ଗ ହା଼ରେକା କାଜା କାମାତା ହେର୍‌ପାଇଁ, ନୀନୁ ନା଼ ତଲେ ରା଼ହାଁ କିହାଲି ୱା଼ମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ଅ଼ଡ଼େ ଆମିନିଗାଟାସି ରୀ ମା଼ଣା ବେଟା ଆ଼ହାମାଚେସି, ଏ଼ୱାସି ଜିକେଏ ୱା଼ହାନା ଏଲେଇଚେସି, ଏ଼ ପ୍ରବୁ ନୀନୁ ନାଙ୍ଗେ ରୀ ମା଼ଣା ହୀହାମାଞ୍ଜାତି; ମେହ୍‌ମୁ ନା଼ନୁ ଅ଼ଡ଼େ ରୀ ମା଼ଣା ଲା଼ବା କିହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ତାନି ସା଼ୱୁକାରି ଏ଼ୱାଣାଇଁ ଜିକେଏ ଏଲେଇଚେସି, ଆୟାଁଲେତା ନେହିଁ ଇଞ୍ଜାଁ ଟିକାଣାଗାଟି ହ଼ଲେଏଣାତି, ନୀନୁ ଊଣା କାମାତା ନାମୁ ଗାଟାତି ଆ଼ହାମାଞ୍ଜି, ନା଼ନୁ ନିଙ୍ଗ ହା଼ରେକା କାଜା କାମାତା ହେର୍‌ପାଇଁ, ନୀନୁ ନା଼ ତଲେ ରା଼ହାଁ କିହାଲି ୱା଼ମୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ଡା଼ୟୁ ର଼ ମା଼ଣା ଟାକାୟାଁ ଅ଼ହାମାଚି ହ଼ଲେଏସି ଏଲେଇଚେସି, ସା଼ୱୁକାରି, ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ, ନୀନୁ ର଼ ଆ଼ଟ୍‌ୱା ହିୟାଁ ଗାଟାତି । ମାଟାଆତି ବୂମିତା ନୀନୁ ଦା଼ଃଆନାତି । ବିଚା ମାଟାଆନା ଆର୍ନା କୂଡ଼ି କିନାତି । ");
INSERT INTO kxv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଏ଼ଦାଆଁତାକି ଆଜାହାଁ ନା଼ନୁ ନୀ ଟାକାୟାଁଣି ବୂମିତା ମୁସାନା ଡ଼ୁକ୍‌ହା ଇଟିତେଏଁ; ମେହ୍‌ମୁ ନୀ ଦ଼ନ ନୀନୁ ବେଟାଆ଼ତି । ");
INSERT INTO kxv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ସାମା ତାନି ସା଼ୱୁକାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ଆଡ଼େ ଲାଗେଏ ଅ଼ଡ଼େ ନିସ୍ତଗାଟି ହ଼ଲେଏଣାତି, ନା଼ନୁ ଆମ୍ବିୟା ମାଟା ହିଲଅଁ ଏମ୍ବାଆଁ ଦା଼ଃଆନାତେଏଁ, ଇଞ୍ଜାଁ ଆମ୍ବିୟା ଆର୍ନା ଊପ୍‌ହା ହିଲଅଁ ଏମ୍ବାଆଁ କୂଡ଼ି କିନାତେଏଁ, ଈଦାଆଁ ନୀନୁ ପୁଞ୍ଜାମାଚି ? ");
INSERT INTO kxv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ଆତିହିଁ ବେ଼ବାରା କିନାରି ତା଼ଣା ନା଼ ଟାକାୟାଁ ନୀନୁ ଇଟିନାୟି ମାଚେ; ଆତିହିଁ ନା଼ନୁ ୱା଼ହାନା ଅଡିତଲେ ନା଼ ଦ଼ନ ନା଼ନୁ ବେଟାଆ଼ତେଏଁମା । ");
INSERT INTO kxv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଈଦାଆଁତାକି ଈୱାଣି ତା଼ଣାଟି ଈ ଟାକାୟାଁ ଅ଼ହାନା ଆମିନି ଗାଟାଣାକି ଦସ ମା଼ଣା ମାନୁ ଏ଼ୱାଣାକି ହୀଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଇଚିହିଁ ଆମ୍ବାଆରାକି ମାନୁ, ଏ଼ୱାଣାକି ହୀପ୍‌କିଆ଼ନେ, ଇଞ୍ଜାଁ ଏ଼ୱାଣିୱାୟି ହା଼ରେକା ଗାଡିଆ଼ନେ; ସାମା ଆମ୍ବାଆରି ତା଼ଣା ହିଲେଏ, ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନାୟି ମାନେ, ଏ଼ଦାଆଁ ଜିକେଏ ଏ଼ୱାଣି ତା଼ଣାଟି ଅ଼ୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଅ଼ଡ଼େ ମୀରୁ ଈ କାମା କିଆଗାଟି ହ଼ଲେଏଣାଇଁ ପାଙ୍ଗାତି ଆନ୍ଦେରିତା ମେତ୍‌ହା ତୁହ୍‌ଦୁ, ଏମ୍ବାଆଁ ଡ଼ୀହିଁ ପାଲ୍‌କା ଟୀଟି କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ମାଣ୍‌ସି ମୀର୍‌ଏସି ଏଚିବେ଼ଲା ବାରେ ଦୂତୁୟାଁ ତଲେ ତାନି କାଜାପା଼ଣାଟି ୱା଼ନେସି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ତାନି ଗାୱୁରମିଗାଟି ସିଂଗାସାଣିତା କୁଗିନେସି, ");
INSERT INTO kxv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଇଞ୍ଜାଁ ତାନି ନ଼କିତା ବାରେ କୂଡ଼ାତି ଲ଼କୁଣି କୂଡ଼ି କିୱିଆ଼ନେ, ଇଞ୍ଜାଁ ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁ ଏ଼ନିକିଁ ଗରିୟାଁ ତା଼ଣାଟି ମେ଼ଣ୍ତାୟାଁଣି ଏଟ୍‌କା କିନେସି, ଏଲେକିହିଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଟ୍‌କା କିହାନା, ");
INSERT INTO kxv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ମେ଼ଣ୍ତାୟାଁଣି ତାନି ଟିଃନି ଟଟତା ଇଞ୍ଜାଁ ଗରିୟାଁଣି ତାନି ଟେ଼ବ୍ରି ଟଟତା ଇଟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ଏଚିବେ଼ଲା ରାଜା ତାନି ଟିଃନି ଟଟତି ଲ଼କୁଣି ଏଲେଇନେସି, ୱା଼ଦୁ ନା଼ ଆ଼ବାତି ବ଼ର ବେଟା ଆ଼ନାତେରି, ମିଙ୍ଗେତାକି ଦାର୍‌ତି ଗା଼ଡ଼ି ଆ଼ତି ଦିନାଟିଏ ଆମିନି ରା଼ଜି ଗା଼ଡ଼ି କିୱିଆ଼ହାମାନେ ଏମ୍ବାତି ଅଦିକାରା ଆ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ଇଚିହିଁ ନା଼ନୁ ହାକିଟି ମାଚେଏଁ, ମୀରୁ ନାଙ୍ଗେ ତିଞ୍ଜାଲି ହିୟାତେରି; ଏ଼ସ୍‌କିଟି ମାଚେଏଁ, ନାଙ୍ଗେ ଗସାଲି ଏ଼ୟୁ ହିୟାତେରି; ଏଟ୍‌କା ମାଚେଏଁ ନାଙ୍ଗେ ଆଟ୍‌ହାତେରି; ");
INSERT INTO kxv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ନା଼ଗ୍‌ଡ଼ାଟି ମାଚେଏଁ ନାଙ୍ଗେ ହିମ୍ବରି ହୁଚି କିୟାତେରି; ନ଼ମେରି ମାଚେଏଁ ନାଙ୍ଗେ କେର୍‌ହାତେରି; କା଼ୟିଦିତା ମାଚେଏଁ ନାଙ୍ଗେ ବେ଼ଚି ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ଏମ୍ବାଟିଏ ଦାର୍ମୁଗାଟାରି ଏ଼ୱାଣାଇଁ ଏଲେଇନେରି, ଏ଼ ପ୍ରବୁ ଏଚେଲା ହାକିଟି ମାନାଣି ମେସାନା ନିଙ୍ଗେ ତିଞ୍ଜାଲି ହିୟାଆତମି ? ଏଚେଲା ଏ଼ସ୍‌କି ଆ଼ତାଣି ମେସାନା ଏ଼ୟୁ ହିୟାଆତମି ? ");
INSERT INTO kxv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଅ଼ଡ଼େ ଏଚେଲା ଏଟ୍‌କା ମାଚାଣି ମେସାନା ଆଟ୍‌ହାତମି ? ଏଚେଲା ନା଼ଗ୍‌ଡ଼ା ମେସାନା ହିମ୍ବରି ହୁଚି କିୟାଆତମି ? ");
INSERT INTO kxv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଅ଼ଡ଼େ ଏଚେଲା ନ଼ମେରିତା ଇଞ୍ଜାଁ କା଼ୟିଦି ମାନାଣି ମେସାନା ନୀ ତା଼ଣା ୱା଼ତମି ? ");
INSERT INTO kxv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ଇଞ୍ଜାଁ ରାଜା ଏ଼ୱାରାଇଁ ଏଲେଇନେସି, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ନା଼ ଈ ଊଣା ତାୟିୟାଁଇଁ ରଅଣାଇଁ ଏ଼ନାଆଁ କିହାମାଞ୍ଜେରି ଏ଼ ବାରେ ନାଙ୍ଗେତାକି କିହାମାଞ୍ଜାଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ଏମ୍ବାଟିଏ ତାନି ଟେ଼ବ୍ରି ଦାରିତି ଲ଼କୁଣି ଜିକେଏ ଏଲେଇନେସି, ଆଡ଼େ ମାହାପୂରୁ ତା଼ଣାଟି ବା଼କା ବେଟା ଆ଼ନାତେରି, ନା଼ ନ଼କିଟି ହେକ ଆ଼ହାନା ସୟତାନ ଇଞ୍ଜାଁ ତାନି ଦୂତୁୟାଁକି କିହାମାନି କା଼ଲାକା଼ଲା ଡ଼ୀଞ୍ଜିମାନି ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ହାଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ଇଚିହିଁ ନା଼ନୁ ହାକିଟି ମାଚେଏଁ ନାଙ୍ଗେ ତିଞ୍ଜାଲି ହିୟାଆତେରି; ଏ଼ସ୍‌କିଟି ମାଚେଏଁ ନାଙ୍ଗେ ଗସାଲି ଏ଼ୟୁ ହିୟାଆତେରି; ");
INSERT INTO kxv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ଏଟ୍‌କା ମାଚାଟି ନାଙ୍ଗେ ଆଟ୍‌ହାଆତେରି; ନା଼ଗ୍‌ଡ଼ା ମାଚାଟି ନାଙ୍ଗେ ହିମ୍ବରି ହୁଚି କିୟାଆତେରି; ନ଼ମେରି ଇଞ୍ଜାଁ କା଼ୟିଦିତା ମାଚାଟି ନାଙ୍ଗେ କେର୍‌ହାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜିକେଏ ଏଲେଇନେରି, ଏ଼ ପ୍ରବୁ ଏଚେଲା ମା଼ମ୍ବୁ ନିଙ୍ଗେ ହାକି କି ଏ଼ସ୍‌କି, ଏଟ୍‌କା କି ନା଼ଗ୍‌ଡ଼ା, ନ଼ମେରି କି କା଼ୟିଦିତା ମାନାଣି ମେସାନା ନିଙ୍ଗେ ସେ଼ବା କିୟାଆତମି ? ");
INSERT INTO kxv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ଏଚେଟିଏ ରାଜା ଏ଼ୱାରାଇଁ ଏଲେଇନେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନା଼ ଈ ଊଣା ଲ଼କୁ ବିତ୍ରାଟି ରଅଣାଇଁ କିହାହିଲାଆକି ନାଙ୍ଗେ କିହାମାଞ୍ଜଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଅ଼ଡ଼େ ଈୱାରି କା଼ଲାକା଼ଲାତି ସା଼ସ୍ତି ବେଟାଆ଼ନେରି, ସାମା ତୀରିଗାଟାରି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଜୀସୁ ଈ ବାରେ କାତା ରା଼ପ୍‌ହାନା ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ରୀଇନି ଜେ଼ଚ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଆ଼ନେ, ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ଇଞ୍ଜାଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ପା଼ସି ମୁଣ୍ତାତା ହା଼ୟାଲି ହେର୍‌ପିଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ଏଚିବେ଼ଲାତା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି କୟାପା ଦ଼ରୁଗାଟି କାଜା ପୂଜେରା ଆଂଗେଣିତା ରୁଣ୍ତା ଆ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଅ଼ଡ଼େ ଜୀସୁଇଁ ଆସାନା ପା଼ୟାଲି ପାରୁ ପାରୀତେରି; ");
INSERT INTO kxv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ସାମା ଏ଼ୱାରି ଏଲେଇଚେରି, “ପାର୍ବୁ ବେ଼ଲାତା ଆ଼ଏ ଇଚିହିଁ ଏଚେ଼ତା ଲ଼କୁ ଗଡ଼୍‌ହା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଜୀସୁ ବେତନିୟାଁତା କାଜା ର଼ଗଗାଟି ସିମନ ଇଜ ତିଞ୍ଜାଲି କୁଗାମାଚାଟି, ");
INSERT INTO kxv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ର଼ ଇୟା ର଼ ଗା଼ଜୁତା ହା଼ରେକା ଦାରାଗାଟି ଗାନ୍ଦା ନିୟୁଁ ତାଚାନା ଜୀସୁ ତା଼ର୍ୟୁଁତା ୱା଼କ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ସାମା ଏ଼ଦାଆଁ ମେସାନା ସୀସୁୟାଁ କ଼ପା ଆ଼ହାନା ଏଲେଇଚେରି, “ଇଚେକା ଉଜେଏ ଏ଼ନାଆଁତାକି କାର୍ଚୁ ? ");
INSERT INTO kxv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଈଦାଆଁ ହା଼ରେକା ଟାକାୟାଁତାକି ପାର୍‌ପି ଆ଼ହାନା କା଼କୁଲି ଗାଟାରାକି ହିୟାଲି ଆ଼ତେମା ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଜୀସୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଈ ଇୟାନି ଏ଼ନାଆଁତାକି କସ୍ତ ହୀହିମାଞ୍ଜେରି ? ଏ଼ଦି ନାଙ୍ଗେତାକି ହା଼ରେକା ନେହିଁ କାମା କିହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","କା଼କୁଲି ଗାଟାରି କା଼ଲେଏ ମୀ ତା଼ଣା ମାନେରି, ସାମା ନା଼ନୁ କା଼ଲେଏ ମୀ ତା଼ଣା ମାନଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ଇଞ୍ଜାଁ ଏ଼ଦି ନା଼ ଆଙ୍ଗାତା ନ଼କେଏ ନିୟୁଁ ୱା଼କ୍‌ହାନା ମୁସାଲି ତାକି ନ଼କେଏ ତିୟାରା କିହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ବାରେ ଦାର୍‌ତିତା ଆମିନି ଟା଼ୟୁତା ଈ ନେହିଁ କାବ୍ରୁ ୱେ଼ପ୍‌କି ଆ଼ନେ, ଏମ୍ବାଆଁ ଏ଼ ଇୟାନି ଅଣ୍‌ପାଲି ଏ଼ଦାନି ଈ କାମା ଜିକେଏ ୱେସ୍‌ପି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଏଚିବେ଼ଲା ବା଼ରଜା଼ଣା ବିତ୍ରାଟି ଇସ୍କାରିୟତ ଜୀହୁଦା ଦ଼ରୁଗାଟାସି କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣା ହାଜାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ନାଙ୍ଗେ ଏ଼ନାଆଁ ହିୟାଦେରି ୱେସ୍ତାଦୁ ? ନା଼ନୁ ଜୀସୁଇଁ ଆସ୍‌ପି କିୟାଇଁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାକି କଡ଼େଦସ ଗଟା ୱେଣ୍ତି ଟାକାୟାଁ ଏଜିକିହାନା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଅ଼ଡ଼େ ଏ଼ ଦିନାଟିଏ ଏ଼ୱାସି ଜୀସୁଇଁ ଏ଼ୱାରିତା଼ଣା ହେର୍‌ପାଲି ତାକି ପାରୁ ପାରାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ଡା଼ୟୁ ପୁଲାଏ଼ୟୁ ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁତି ତଲିତି ଦିନାତା ସୀସୁୟାଁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, “ମା଼ମ୍ବୁ ଆମିନି ଟା଼ୟୁତା ନିଙ୍ଗେତାକି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି କିନମି ଇଞ୍ଜିଁ ନୀନୁ ଅଣ୍‌ପିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜୀସୁ ଏଲେଇଚେସି, “ମୀରୁ ଗା଼ଡ଼ାତା ପାଲାଣା ଗାଟାଣି ତା଼ଣା ହାଜାନା ଏଲେଇଞ୍ଜୁ, ମା଼ ଗୂରୁ ଏଲେଇଞ୍ଜି ୱେସା ପାଣ୍ତାତେସି, ନା଼ କାଟୁ ଏଦାତେୟିଏ, ନା଼ନୁ ନା଼ ସୀସୁୟାଁ ତଲେ ମୀ ଇଜ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି କିନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ଜୀସୁତି ହୁକୁମି ତଲେ କାମା କିହାନା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ଡା଼ୟୁ ମିଡ଼୍‌ଅଲା ଆୟାଲିଏ ଜୀସୁ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ତଲେ ବ଼ଜିତା କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଏ଼ୱାରି ତିଞ୍ଜିମାଚି ବେ଼ଲାତା ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀ ବିତ୍ରାଟି ରଅସି ନାଙ୍ଗେ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହା଼ରେକା ଦୁକୁ ଆ଼ହାନା ରଅ ରଅସି ଜୀସୁଇଁ ୱେଚେରି, “ଏ଼ ପ୍ରବୁ ଏ଼ୱାତେଏଁ ନା଼ନୁ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ ତଲେ ଆମ୍ବାଆସି ସାଡ଼୍‌ୱାତା କେୟୁ ପା଼ର୍‌କି ମାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ମାଣ୍‌ସି ମୀର୍‌ଏଣି କାତା ଏ଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ ଏଲେକିଁ କିହିମାନେସି ସାତା; ସାମା ଆମିନି ଲ଼କୁ ତା଼ଣାଟି ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପି ଆ଼ହିମାନେସି, ଆୟ଼ତା ଏଚେକା ଡଣ୍ତ ବେଟା ଆ଼ନେସି; ଏ଼ୱାସି ଜାର୍ନା ଆ଼ହାହିଲାଆତିହିଁ ଏ଼ୱାଣାକି ନେହେଁ ଆ଼ତେମା ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ଏଚେଟିଏ ଆମିନି ଜୀହୁଦା, ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିତେସି, ଏ଼ୱାସି ଏଲେଇଞ୍ଜି ଇଚେସି, “ଏ଼ ଗୂରୁ ଏ଼ୱାତେଏଁ ନା଼ନୁ କି ?” ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁତ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଅ଼ଡ଼େ ଏ଼ୱାରି ତିଞ୍ଜିମାଚି ବେ଼ଲାତା, ଜୀସୁ ରୂଟି ଅ଼ହାନା ମାହାପୂରୁଇଁ ଜହରା କିତେସି, ଇଞ୍ଜାଁ ରୂଟି ଡ଼ିକ୍‌ହାନା ସୀସୁୟାଁକି ହୀହାନା ଏଲେଇଚେସି, “ଈଦାଆଁ ଅ଼ଦୁ ଇଞ୍ଜାଁ ତିଞ୍ଜୁ ଈଦି ନା଼ ଆଙ୍ଗା ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ଅ଼ଡ଼େ ଏ଼ୱାସି ଗହ୍‌ନି ସ଼ଲା ଆସାନା ମାହାପୂରୁଇଁ ଜହରା କିତେସି ଇଞ୍ଜାଁ ସୀସୁୟାଁକି ହୀହାନା ଏଲେଇଚେସି; “ଈଦାଆଁ ବାରେତେରି ଗହଦୁ” ");
INSERT INTO kxv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“ଇଚିହିଁ ଆମିନି ନେତେରିତି ରା଼ଜିମା଼ନା ହା଼ରେକା ଲ଼କୁତାକି ପା଼ପୁତି ମ୍ଣେକ୍‌ହାଲି ୱା଼କ୍‌ହାମାନି ଈଦି ଏ଼ ନା଼ ନେତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମିନି ଦିନା ନା଼ ଆ଼ବାତି ରା଼ଜିତା ମୀ ତଲେ ପୁଃନି ଅଙ୍ଗୁରି ରାସା ଗହ୍‌ଆ ପାତେକା ନୀଞ୍ଜୁଟିଏ ଏଚେଲାୱା ଅଙ୍ଗୁରି ରାସା ଗହ୍‌ଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜହରା ପା଼ଚୁ ପା଼ଚିତି ଡା଼ୟୁ ଜୀତ ହ଼ରୁତା ହ଼ଚା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ଏଚିବେ଼ଲା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ ମୀରୁ ବାରେତେରି ନାଙ୍ଗେ ପିସାନା ହାଜାଦେରି, ଇଚିହିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନା଼ନୁ ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁଇଁ ୱେ଼ଇଁ ଅ଼ଡ଼େ ମାନ୍ଦାତି ମେ଼ଣ୍ତାୟାଁ ଆଲାରା ଆ଼ହାହାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ସାମା ନା଼ନୁ ହା଼ହାନା ନିଙ୍ଗିତି ଡା଼ୟୁ ମୀ ନ଼କିତା ଗାଲିଲିତା ହାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ସାମା ପିତର ଜୀସୁଇଁ ଏଲେଇଚେସି, “ବାରେଜା଼ଣା ନିଙ୍ଗେ ପିସ୍ତାତିହିଁ ଜିକେଏ, ନା଼ନୁ କଡ଼େ ନିଙ୍ଗେ ଏଚେଲାୱା ପିସ୍ତଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜୀସୁ ପିତରଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ କୟୁ କେ଼ଣ୍‌ଆ ନ଼କେଏ ନୀନୁ ନାଙ୍ଗେ ତୀନିପା଼ଲି ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ୱେହ୍‌ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନୀ ତଲେ ହା଼ହାଲି ଆ଼ତି ଜିକେଏ ନା଼ନୁ ନିଙ୍ଗେ ଏଚେଲା ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ଇନଅଁ !” ଇଞ୍ଜାଁ ବାରେ ସୀସୁୟାଁ ଜିକେଏ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ଏଚେଟିଏ ଜୀସୁ ତାନି ସୀସୁୟାଁ ତଲେ ଗେତ୍‌ସିମନି ଇନି ର଼ ଟା଼ୟୁତା ହାଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏମ୍ବାଆଁ ହାଜାନା ପ୍ରା଼ତାନା କିନି ପାତେକା ମୀରୁ ଇମ୍ବାଆଁ କୁଗା ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଅ଼ଡ଼େ ଏ଼ୱାସି ପିତର ଇଞ୍ଜାଁ ଜେବଦିତି ରୀ ମୀର୍‌କାଣି ଅ଼ହାନା ହିୟାଁତା କିଲିବିଲି ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଇଞ୍ଜାଁ ଏଚିବେ଼ଲା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜୀୱୁ ହା଼ନିଲେହେଁ ହା଼ରେକା କିଲିବିଲି ହ଼ଚି ମାଞ୍ଜାନେ, ମୀରୁ ଇମ୍ବାଆଁ ଡ଼ୟାନା ନା଼ ତଲେ କା଼ଚିହିଁ ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଇଞ୍ଜାଁ ଏ଼ୱାସି ହିରେ ହେକ ହାଜାନା ମୁନୁ କୁତାନା ପ୍ରା଼ତାନା କିହିହିଁ ଏଲେଇଚେସି, “ଏ଼ ନା଼ ଆ଼ବା ଆତିହିଁ ଈ ନା଼ ଦୁକୁ କସ୍ତଗାଟି ସ଼ଲାତି ହେକ କିମୁ; ସାମା ନା଼ ମ଼ନ କଡ଼େ ଆ଼ଏ ନୀ କାତେଏ ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ଅ଼ଡ଼େ ଏ଼ୱାସି ସୀସୁୟାଁତା଼ଣା ୱା଼ହାନା ଏ଼ୱାରାଇଁ ଇଦା କିତାଣି ମେସ୍ତେସି ଇଞ୍ଜାଁ ପିତରଇଁ ଏଲେଇଚେସି, “ମୀରୁ ନା଼ ତଲେ ଗା଼ଡ଼େକା ଜିକେଏ କା଼ଚାଲି ଆ଼ଡାଆତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପା଼ନ୍ଦାତା ଏ଼ନିକିଁ ହେର୍‌ଅତେରି, ଏ଼ଦାଆଁତାକି କା଼ଚାହାଁ ପ୍ରା଼ତାନା କିହେ଼ମାଞ୍ଜୁ; ଇଚିହିଁ ମ଼ନ ମାନେ ସାମା ଆଙ୍ଗାତା ବା଼ଡ଼୍‌ୟୁ ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଅ଼ଡ଼େ ର଼ ପା଼ଲି ହାଜାନା ପ୍ରା଼ତାନା କିହିହିଁ ଏଲେଇଚେସି, “ଏ଼ ନା଼ ଆ଼ବା ଈ ନା଼ ଦୁକୁ କସ୍ତଗାଟି ସ଼ଲା ନା଼ ତା଼ଣାଟି ହେକ ଆ଼ହାଲି ଆ଼ଡାଆତି, ନା଼ନୁ ଏ଼ଦାଆଁ ଗହ୍‌ଇଁ ନା଼ ମ଼ନ କଡ଼େ ଆ଼ଏ ନୀ କାତେଏ ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ଅ଼ଡ଼େ ଏ଼ୱାସି ୱା଼ହାନା ଏ଼ୱାରାଇଁ ଇଦା କିହାମାନାଣି ମେସ୍ତେସି; ଇଚିହିଁ ଏ଼ୱାରି କଟଣି ହ଼ଚି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପିସାନା ଅ଼ଡ଼େ ୱେଣ୍ତେ ହାଜାନା ଅ଼ଡ଼େ ଏ଼ ପ୍ରା଼ତାନା ତୀନିପା଼ଲି ତାକି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ଡା଼ୟୁ ସୀସୁୟାଁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେସି, “ଗା଼ଡ଼େକା ଡୂରାନା ଜ଼ମାଦୁ, ଇଚିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ପା଼ପୁ ଗାଟାରି ତା଼ଣା ହେର୍‌ପି ଆ଼ନିବେଲା ଏଦାତେୟିଏ । ");
INSERT INTO kxv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ନିଙ୍ଗାଦୁ ମା଼ର ହାନ, ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ଆମ୍ବାଆସି ନାଙ୍ଗେ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି, ଏ଼ୱାସି ଡାଗେ ୱା଼ତେସିଏ !” ");
INSERT INTO kxv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜୀସୁ ଈ କାତା ୱେସିମାଚି ବେ଼ଲାତା, ମେହ୍‌ଦୁ, ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ବିତ୍ରାଟି ଜୀହୁଦା ଦ଼ରୁଗାଟାସି ରଅସି ଇଞ୍ଜାଁ ଏ଼ୱାଣିତଲେ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି ତା଼ଣାଟି ପାଣ୍ତ୍‌ୱିଆ଼ହାମାନି ହା଼ରେକା ଲ଼କୁ କାଣ୍ତାୟାଁ ଅ଼ଡ଼େ ବାଡ଼୍‌ଗାୟାଁ ଆସାନା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ଜୀସୁଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିନାସି ଏ଼ୱାରାଇଁ ଈ ସିନା ୱେସାମାଚେସି, “ନା଼ନୁ ଆମ୍ବାଆରାଇଁ ନଣ୍ତିଇଁ ଏ଼ୱାସିଏ ଏ଼ୱାସି, ଏ଼ୱାଣାଇଁ ଆହ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ ଦେବୁଣିଏ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା, “ଏ଼ ଗୂରୁ ଜହରା ଇଚେସି” ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ହା଼ରେକା ନଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ତ଼ଣେ ଏ଼ନାଆଁ କିହାଲି ୱା଼ହାମାଞ୍ଜି ଏ଼ଦାଆଁ କିମୁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଡାଗେ ୱା଼ହାନା ଜୀସୁଇଁ ଆସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ଜୀସୁତଲେ ମାଚାରି ବିତ୍ରାଟି ରଅସି କାଣ୍ତା ହ଼ପ୍‌ହେସି ଇଞ୍ଜାଁ କାଜା ପୂଜେରା ହ଼ଲେଏଣାଇଁ କିର୍ୟୁଁ ରାତ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ କାଣ୍ତା ୱେଣ୍ତେ ନୀ ପାଡ଼୍‌କାତା ଇଟାମୁ, ଇଚିହିଁ ଆମ୍ବାଆରି କାଣ୍ତା ଆହ୍‌ନେରି ଏ଼ୱାରି କାଣ୍ତା ତଲେଏ ହା଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ନୀନୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜି, ନା଼ନୁ ନା଼ ଆ଼ବାଇଁ ବାତିମା଼ଲିତିହିଁ ଈ ଦେବୁଣିଏ ବା଼ର ଗଚି ରିଜାରି କ଼ସ୍‌କା କିହାଁ ହା଼ରେକା ଦୂତୁୟାଁଇଁ ପାଣ୍ତଅସି ?” ");
INSERT INTO kxv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ଇଚିହିଁ ଇଲେକିଁ ସାତେଏ ଆ଼ନେ ଇଞ୍ଜାଁମାନି ଦାର୍ମୁ ପତିତି କାତା ଏ଼ନିକିଁ ସାତା ଆ଼ନେ ? ");
INSERT INTO kxv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ଏଚେଟିଏ ଜୀସୁ ମାନ୍ଦା ଲ଼କୁଣି ଏଲେଇଚେସି, ଡଂଗା ଗାଟାରାଇଁ ଆହ୍‌ନିଲେହେଁ କାଣ୍ତାୟାଁ ଅ଼ଡ଼େ ଟେଙ୍ଗାୟାଁ ଆସାନା ମୀରୁ ନାଙ୍ଗେ ଆସାଲି ୱା଼ହାମାଞ୍ଜେରି ? ନା଼ନୁ ବାରେଦିନା ମାହାପୂରୁ ଇଲୁତା କୁଗାନା ଜା଼ପ୍‌ହି ମାଚେଏଁ, ସାମା ମୀରୁ ନାଙ୍ଗେ ଆସ୍ତାଆତେରି ! ");
INSERT INTO kxv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ସାମା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ରା଼ଚିତି ସା଼ସ୍ତେରି କାତା ଏ଼ନିକିଁ ସାତା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ଆ଼ହିମାନେ । ଏଚିବେ଼ଲା ବାରେଜା଼ଣା ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ପିସାନା ହଟାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଡା଼ୟୁ ଏମିନିଗାଟାରି ଜୀସୁଇଁ ଆସାମାଚେରି, ଏ଼ୱାରି ଜୀସୁଇଁ କୟାପା ଇନି କାଜା ପୂଜେରା ନ଼କିତା ଅ଼ତେରି; ଏ଼ ଟା଼ୟୁତା ମେ଼ରାପୁନାରି ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି ରୁଣ୍ତା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ସାମା ପିତର ହେକ ଡ଼ୟାନା କାଜା ପୂଜେରା ଆଂଗେଣି ପାତେକା ଏ଼ୱାରି ଜେ଼ଚ ହାଚେସି, ଇଞ୍ଜାଁ ଡା଼ୟୁ ଏ଼ନି ଆ଼ନେ, ଏ଼ଦାଆଁ ସିନିକିହାଲି ଏ଼ୱାସି ବିତ୍ରା ହାଜାନା ଜାମାନାଙ୍ଗା ତଲେ କୁଗାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ଏମ୍ବାଟିଏ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ବାରେ ବେ଼ରଣି ମାଣ୍ତାତାରି ଜୀସୁଇଁ ପା଼ୟାଲି ଏ଼ୱାଣି କ଼ପାଟି ମିଚି ସା଼କିୟାଁ ପାରୀତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ଇଞ୍ଜାଁ ହା଼ରେକା ସା଼କିୟାଁ ୱେସ୍ତି ଜିକେଏ, ଏ଼ୱାଣି ଏ଼ନି ଦ଼ହ ପ୍ଣାଃଆତେରି । ଇଞ୍ଜାଁ ଡା଼ୟୁ ରିଆରି ନିଚାନା ୱେସ୍ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ଈୱାସି ଏଲେଇଞ୍ଜାମାଚେସି, “ନା଼ନୁ ମାହାପୂରୁତି ଇଲୁ ଡିକ୍‌ହାନା ତୀନି ଦିନାଟିଏ କେ଼ପାଲି ଆ଼ଡିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ଏମ୍ବାଟିଏ କାଜା ପୂଜେରା ନିଙ୍ଗାନା ଏଲେଇଚେସି, “ନୀ କ଼ପାଟି ଜ଼ଲିମାନାରାକି ୱେଣ୍ତେ ୱେସାଲି ନୀ ଏ଼ନି କାତା ହିଲେଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ସାମା ଜୀସୁ ପାଲେଏ ଆ଼ହାନା ଡ଼ୟିତେସି । ଏମ୍ବାଟିଏ କାଜା ପୂଜେରା ଜୀସୁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜୀୱୁତି ମାହାପୂରୁ ଦ଼ରୁତଲେ ପାର୍‌ମାଣା କିୱି କିହାନା ୱେଞ୍ଜିମାଞ୍ଜାଇଁ, ନାଙ୍ଗେ ୱେସ୍ତାମୁ, ନୀନୁ ସାତେଏ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି କ୍ରୀସ୍ତତିକି ?” ");
INSERT INTO kxv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁତ ୱେସିମାଞ୍ଜି; ଅ଼ଡ଼େ ନା଼ନୁ ନିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁଟିଏ ମୀରୁ ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ ବା଼ଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ଟିଃନିୱାକି ନିଚାମାନାଣି ଅ଼ଡ଼େ ହା଼ଗୁ ଦୂନ୍ଦ୍ରାଟି ୱା଼ନାଣି ମେହ୍‌ଦେରି !” ");
INSERT INTO kxv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଏମ୍ବାଟିଏ କାଜା ପୂଜେରା ତାନି ହିମ୍ବରି ଗେସାନା ଏଲେଇଚେସି, “ଈୱାସି ମାହାପୂରୁ ନିନ୍ଦା କିହିମାନେସି, ଇଞ୍ଜାଁ ମାଙ୍ଗେ ଅ଼ଡ଼େ ଏ଼ନି ସା଼କିୟାଁ ଲ଼ଡ଼ାମାନେ ? ମେହ୍‌ଦୁ ନୀଏଁ ଜିକେଏ ମାହାପୂରୁ ନିନ୍ଦା କିତାଣି ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ମୀ ଅଣ୍‌ପୁତା ଏ଼ନାୟି ମାନେ ?” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ ପା଼ଣ୍‌ନାୟି ମାନେ ! ");
INSERT INTO kxv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ଏଚିବେ଼ଲା ଏ଼ୱାରି ଏ଼ୱାଣି ମୂମ୍ବୁତା ହୂପିତେରି, ବିଦା ୱେ଼ତେରି; ଇଞ୍ଜାଁ ଆମ୍ବା ଆମ୍ବାଆରି ସା଼ପ୍‌ଡ଼ା ୱେ଼ଚାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଏ଼ କ୍ରୀସ୍ତ ନୀନୁସାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି, ମାଙ୍ଗେ ୱେସ୍ତାମୁ ନିଙ୍ଗ ଆମ୍ବାଆସି ୱେତାତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ଏମ୍ବାଟିଏ ପିତର ପାଙ୍ଗାତି ଆଂଗେଣିତା କୁଗାମାଚେସି, ଇଞ୍ଜାଁ ର଼ ହ଼ଲେଣି ପିତର ଡାଗେ ୱା଼ହାନା ଏଲେଇଚେ, “ନୀନୁ ଜିକେଏ ଗାଲିଲିତି ଜୀସୁତଲେ ମାଚି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ସାମା ଏ଼ୱାସି ବାରେତି ନ଼କିତା “ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ ନୀନୁ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜି ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଅ଼ଡ଼େ ପିତର ଆଂଗେଣି ଦୁୱେରିତା ହାଜାଲିଏ ଅ଼ଡ଼େ ର଼ ହ଼ଲେଣି ଏ଼ୱାଣାଇଁ ମେସାନା ଏ଼ ଟା଼ୟୁତି ଲ଼କୁଣି ଏଲେଇଚେ, “ଈୱାସି ନା଼ଜରିତ ଜୀସୁତଲେ ମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର ପାର୍‌ମାଣା କିହାନା ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଅ଼ଡ଼େ ର଼ ଗା଼ଡ଼େକା ହାଜାଲିଏ ଦାରିତା ନିଚାମାଚାରି ପିତର ଡାଗେ ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀନୁ ଜିକେଏ ସାତେଏ ଏ଼ୱାରି ବିତ୍ରାଟି ରଅତି, ଇଚିହିଁ ନୀ ହା଼ଡାଟି ପୁଣ୍‌ମ୍ବି ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ଏମ୍ବାଟିଏ ପିତର ପାର୍‌ମାଣା ଅ଼ଡ଼େ ବା଼କା ଇଟିହିଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ ।” ଏ଼ ଦେବୁଣିଏ କୟୁ କେ଼ଣ୍‌ତେ । ");
INSERT INTO kxv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଏଚେଟିଏ “କୟୁ କେ଼ଣ୍‌ଆ ନ଼କେଏ ନାଙ୍ଗେ ତୀନି ପା଼ଲି ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜାଦି” ଇଞ୍ଜିଁ ଜୀସୁ ୱେସ୍ତି ଈ କାତା ପିତର ଅଣ୍‌ପୁତା ୱା଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ପାଙ୍ଗାତା ହାଜାନା ହା଼ରେକା କିଲିବିଲି ଦୁକୁଆ଼ହିଁ ଡ଼ୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ଲା଼ଇ ୱେ଼ୟାଲିଏ ବାରେ କାଜା ପୂଜେରାଙ୍ଗା, ଇଞ୍ଜାଁ ଲ଼କୁତି କାଜାରି ଜୀସୁଇଁ ପା଼ୟାଲି ଏ଼ୱାଣି କ଼ପାଟି କାତା ଆ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଦସା ଅ଼ହାନା ପିଲାତ ଇନି ସା଼ଲୱି କିନାଣି ତା଼ଣା ହେର୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ଏଚିବେ଼ଲା ଜୀସୁଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିତି ଜୀହୁଦା, ଜୀସୁ ହା଼ନି ଡଣ୍ତ ବେଟା ଆ଼ହାମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା, ଜୀୱୁତା ଅଣ୍‌ପାନା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି ତା଼ଣା ଏ଼ କଡ଼େଦସ ଟାକା ୱେଣ୍ତେ ତାଚାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ନା଼ନୁ ଦ଼ହ ହିଲାଆଗାଟାଣି ନେତେରି ହେର୍‌ପାନା ପା଼ପୁ କିହାମାଇଁ ।” ସାମା ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ଦି ଏମ୍ବାଆଁ ଏ଼ନାୟି ମାନେ ? ଏ଼ଦାଆଁ ନୀନୁ ଅଣ୍‌ପାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଟାକାୟାଁଣି ମାହାପୂରୁ ଇଲୁ ବିତ୍ରା କୁତାତୁସାନା ହାଚେସି, ଇଞ୍ଜାଁ ହାଜାନା ହେର୍‌କି ଲେ଼ଜା ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଏ଼ ଟାକାୟାଁ ଅ଼ହାନା ଏଲେଇଚେରି, “ଈୱାଆଁ ମାହାପୂରୁ ଇଲୁତି ଦ଼ନ ତଲେ ଇଟିନାୟି ମେ଼ରା ହିଲେଏ, ଇଚିହିଁ ଈୱି ନେତେରିତି ଟାକାୟାଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାରି କାତା ଆ଼ହାନା ଏଟ୍‌କା ଦେ଼ସାତି ଲ଼କୁତି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁ ତାକି ଏ଼ ଟାକାୟାଁ ହୀହାନା ର଼ କୁମ୍ବ୍ରେଏଣା ବୂମି କଡିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ଏ଼ଦାଆଁତାକି ନୀଞ୍ଜୁପାତେକା ଏ଼ଦାନି “ନେତେରି ବୂମି” ଇଞ୍ଜିଁ ଇନେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଏମ୍ବାଟିଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିରିମିୟ ତା଼ଣାଟି ରା଼ଚିତି ଈ କାତା ସାତା ଆ଼ତେ, ଇସ୍ରାୟେଲ ମୀର୍‌କା ଆମ୍ବାଆରି ତାକି ଏଚେକା ଲେକା ହୀନାୟି ମାନେ, ଏ଼ୱାଣି ଲେକାତଲେ ଏ଼ କଡ଼େଦସ ଟାକା ଅ଼ହାନା, ");
INSERT INTO kxv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ନା଼ ତାକି ମାହାପୂରୁତି ହୁକୁମି ଲେହେଁ କୁମ୍ବ୍ରେଏଣା ବୂମି ତାକି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଏମ୍ବାଟିଏ ସା଼ଲୱି କିନାଣି ନ଼କିତା ଜୀସୁଇଁ ନିପ୍‌ହେରି, ଇଞ୍ଜାଁ ସା଼ଲୱି କିନାସି ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ ଜୀହୁଦି ଲ଼କୁତି ରାଜାତି ?” ଜୀସୁ ଏଲେଇଚେସି, “ନୀନୁତ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ଲ଼କୁତି କାଜାରି ଏ଼ୱାଣି କ଼ପାଟି ୱେସାଲିଏ, ଜୀସୁ ଏ଼ନାଆଁ ଇନାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ଏଚେଟିଏ ପିଲାତ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଈୱାରି ନୀ କ଼ପାଟି ହା଼ରେକା କାତା ୱେସିମାନେରି, ଏ଼ଦାଆଁ ୱେଞ୍ଜି ହିଲଅତି କି ?” ");
INSERT INTO kxv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ସାମା ଏ଼ୱାସି ର଼ କାତା ଜିକେଏ ଏ଼ୱାଣାଇଁ ଜ଼ଲାଆତେସି, ଏମ୍ବାଟିଏ ସା଼ଲୱି କିନାସି ହା଼ରେକା କାବା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ବେ଼ଲାତା ଲ଼କୁ, ଆମିନି କାୟିଦିତା ଇଟାମାନାରାଇଁ ରୀସିମାଚେରି ଏ଼ୱାଣାଇଁ ପିସାଲି ସା଼ଲୱି କିନାଣି ମେ଼ରା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ଏଚିବେ଼ଲା ଏ଼ୱାରି ଜୀସୁ-ବାରବା ଦ଼ରୁଗାଟି ର଼ କାଜା ୱେ଼ଙ୍ଗିତି କାୟିଦି ଗାଟାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ରୁଣ୍ତା ଆ଼ହାମାନି ବେ଼ଲାତା ପିଲାତ ଏ଼ୱାରାଇଁ ୱେଚେସି, ନା଼ନୁ ମିଙ୍ଗେତାକି ଆମ୍ବାଆରାଇଁ ପିସାହିୟାଇଁ ଇଞ୍ଜିଁ ମୀରୁ ମ଼ନ କିହିମାଞ୍ଜେରି ? ବାରବାଇଁ କି ଆମ୍ବାଆରାଇଁ କ୍ରୀସ୍ତ ଇଞ୍ଜିଁ ମାଞ୍ଜେରି ଏ଼ ଜୀସୁଇଁ ? ");
INSERT INTO kxv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ଇଚିହିଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ କ଼ପାଟି ହେର୍‌ପା ମାନେରି ଇଞ୍ଜିଁ ପିଲାତ ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ଇଞ୍ଜାଁ ପିଲାତ ନୀହାଁୟି କିନି ଟା଼ୟୁତା କୁଗାମାଚାଟି ତାନି ଡକ୍ରି ତାନି ତା଼ଣା ୱେସା ପାଣ୍ତିତେ, “ଏ଼ ଦାର୍ମୁଗାଟି ମାଣ୍‌ସିଇଁ ଏ଼ନାଆଁ କିଆନି, ଇଚିହିଁ ଏ଼ୱାଣି ତାକି ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ ହାପାନାତା ହା଼ରେକା କସ୍ତ ଆ଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରି, ବାରବାଇଁ ରୀସାଲି ଇଞ୍ଜାଁ ଜୀସୁଇଁ ନା଼ସା କିହାଲି ଲ଼କୁଣି ଜା଼ପ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ସାମା ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଈ ରିଆରି ବିତ୍ରାଟି ଆମ୍ବାଆରାଇଁ ପିସାହିୟାଇଁ ଇଞ୍ଜିଁ ମୀରୁ ମ଼ନ କିହିମାଞ୍ଜେରି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ବାରବାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ ଏ଼ୱାରାଇଁ ୱେଚେସି, ଆତିହିଁ ଆମ୍ବାଆରାଇଁ କ୍ରୀସ୍ତ ଇନେରି ଏ଼ ଜୀସୁଇଁ ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ? ଏ଼ୱାରି ବାରେଜା଼ଣା ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ସାମା ପିଲାତ ୱେଚେସି, “ଏ଼ନାଆଁତାକି, ଏ଼ୱାସି ଏ଼ନି ଦ଼ହ କିହାମାନେସି ?” ସାମା ଏ଼ୱାରି ହା଼ରେକା କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଏଚିବେ଼ଲା ପିଲାତ ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡିହିଲଅସି, ଇଞ୍ଜାଁ ହା଼ରେକା ଗଡ଼୍‌ହା ଆ଼ହିମାନାଣି ମେସାନା, ଏଚିବେ଼ଲା ଲ଼କୁ ନ଼କିତା ଏ଼ୟୁ ଅ଼ହାନା କେସ୍କା ନର୍‌ହାଁ ଏଲେଇଚେସି, “ଈୱାଣି ପା଼ୟିନି ତା଼ଣା ନା଼ ଦ଼ହ ହିଲେଏ, ମୀରୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ଏମ୍ବାଟିଏ ବାରେ ଲ଼କୁ ଏଲେଇଚେରି, “ଏ଼ୱାଣି ନେତେରିତି ଡଣ୍ତ ମା଼ ଲାକ ଇଞ୍ଜାଁ ମା଼ ମୀର୍‌କା ମୁହେଁ ୱା଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ଏମ୍ବାଟିଏ ପିଲାତ ଏ଼ୱାରାକି ବାରବାଇଁ ପିସା ହୀତେସି, ଇଞ୍ଜାଁ ଜୀସୁଇଁ ସା଼ଟ୍‌ଣି ୱେ଼ଚାନା ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ଏମ୍ବାଟିଏ ସା଼ଲୱି କିନାଣି କ଼ସ୍‌କା ଜୀସୁଇଁ ମେ଼ଡ଼ା ଇଲୁ ବିତ୍ରା ଅ଼ହାନା ବାରେ କ଼ସ୍‌କା ଏ଼ୱାଣି ନ଼କିତା କୂଡ଼ା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣି ହିମ୍ବରି ହୁକ୍‌ହାନା ଏ଼ୱାଣାଇଁ ହେୟାଁ ୱା଼ଣାଗାଟି ହିମ୍ବରି ହୁଚିକିତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ଟ଼ପେରି ଆଲାନା ଏ଼ୱାଣି ତା଼ର୍ୟୁଁତା ଇଟିତେରି ଅ଼ଡ଼େ ଏ଼ୱାଣି ଟିଃନି କେୟୁତା ର଼ ବାଡ଼୍‌ଗା ଆସ୍‌ପି କିତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ନ଼କିତା ମେଣ୍ତା କୁତିହିଁ “ଏ଼ ଜୀହୁଦି ଲ଼କୁତି ରାଜା ଜହରା” ଇଞ୍ଜିଁ ଲାଜାକିହିଁ କାକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଅ଼ଡ଼େ ଏ଼ୱାଣିଲାକ ହୂପିତେରି, ଅ଼ଡ଼େ ଏ଼ ବାଡ଼୍‌ଗା ଆସାନା ଏ଼ୱାଣି ତା଼ର୍ୟୁଁତା ୱେ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଲାଜାକିହିଁ କାକ୍‌ହି ଡା଼ୟୁ, ଏ଼ ହିମ୍ବରି ହୁକ୍‌ହା ଅ଼ହାନା ତାନି ହିମ୍ବରି ହୁଚିକିତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ଏ଼ୱାରି ହାଜିମାଚାଟି ସିମନ ଦ଼ରୁଗାଟି ର଼ କୁରିଣି ଦେ଼ସାତି ଲ଼କୁଇଁ ମେସାନା ଜୀସୁତି ପା଼ସିମୁଣ୍ତା ଡେ଼କାଲି ଏ଼ୱାଣାଇଁ ବାଲାମାତମି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଗଲ୍‌ଗତା ଇନି ଟା଼ୟୁତା ଇଚିହିଁ ଏମିନାଣି ତା଼ର୍ୟୁଁଗିର୍ପା ଇନେରି ଏମ୍ବାଆଁ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ଏମ୍ବାଆଁ ଏ଼ୱାରି ଏ଼ୱାଣାକି କାମ୍ବେଲି ଏ଼ୟୁ ଆଟ୍‌ହି ଅଙ୍ଗୁରି ରାସା ଗସାଲି ହୀତେରି, ସାମା ଏ଼ୱାସି ଏ଼ୱାଆଁ ୱାଣ୍ତାନା ଗସାଲି ମ଼ନ କିଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ଡା଼ୟୁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ତାନି ହିମ୍ବରିକା ପାଦି କିହାନା ତାମି ବିତ୍ରା ବା଼ଟି କିହା ଅ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ କୁଗାନା ଏ଼ୱାଣାଇଁ କା଼ଚିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣି ତା଼ର୍ୟୁଁ ଲାକଟି ଇଲେଇଞ୍ଜିଁ ରା଼ଚାନା ଲେତେରି, “ଈୱାସି ଜୀହୁଦି ଲ଼କୁତି ରାଜା ଜୀସୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ଏଚିବେ଼ଲା ତାନି ଟିଃନିୱାକି ରଅସି ଇଞ୍ଜାଁ ତାନି ଟେ଼ବ୍ରିୱାକି ରଅସି ଇଲେକିହିଁ ରୀ ସ଼ର୍‌କାଣି ତାନିତଲେ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଇଞ୍ଜାଁ ଏ଼ ଜିରୁଟି ହାଜିମାନି ଲ଼କୁ ତାମି ତା଼ର୍କା ଗୁଟ୍‌କିକିହିଁ ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିହିଁ ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ଆଡ଼େ ମାହାପୂରୁ ଇଲୁ ଡିକ୍‌ନାତି ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ଏ଼ଦାଆଁ ୱେଣ୍ତେ କେ଼ପିନାତି, ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଇଚିହିଁ, ନୀନୁ ନିଙ୍ଗେ ଗେଲ୍‌ପା କଡାନା ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ଚା ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","କାଜା ପୂଜେରାଙ୍ଗା ଜିକେଏ ଏଲେକିହିଁଏ ମେ଼ରାପୁନାରି ଇଞ୍ଜାଁ ଲ଼କୁତି କାଜାରି ତଲେ କିଜୱିକିହିଁ କାକ୍‌ହିହିଁ ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ଏ଼ୱାସି ଏଟ୍‌କା ଲ଼କୁଣି ପିସ୍‌ପି କିତେସି ତାଙ୍ଗେ ଗେଲ୍‌ପାଲି ଆ଼ଡିହିଲଅସି । ଏ଼ୱାସିତ ଇସ୍ରାୟେଲତି ରାଜା, ଏ଼ୱାସି ଦେବୁଣିଏ ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ଚା ୱା଼ପେସି, ଆତିହିଁ ମା଼ର ଏ଼ୱାଣି ତା଼ଣା ନାମିନ । ");
INSERT INTO kxv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣା ନାମା ମାନେସି; ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଜୀୱୁ ନ଼ହାଁ ମାନେସି, ଆତିହିଁ ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣାଇଁ ଗେଲ୍‌ପାପେସି, ଏ଼ୱାସି ୱେସାମାଚେସି ନା଼ନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଇଞ୍ଜାଁ ଆମିନି ସ଼ର୍‌କା ତାନିତଲେ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହା ମାଚେରି, ଏ଼ୱାରି ଜିକେଏ ଏଲେକିଁ ନିନ୍ଦା କିହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ଡା଼ୟୁ ବା଼ର ଗଂଟାଟିଏ ତୀନି ଗଂଟା ପାତେକା ଦେ଼ସା ବାରେ ଆନ୍ଦେରି ଆ଼ହାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ମିଡ଼୍‌ଅଲା ତୀନି ଗଂଟା ବେ଼ଲାତା ଜୀସୁ କାଜା ଗିୟାଁତଲେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଏଲି, ଏଲି, ଲାମା ସାବକ୍‌ତାନି ?” ଇଚିହିଁ “ଏ଼ ନା଼ ମାହାପୂରୁ ଏ଼ ନା଼ ମାହାପୂରୁ ନୀନୁ ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ପିସ୍ତାତି ?” ");
INSERT INTO kxv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଈ ହା଼ଡା ୱେଞ୍ଜାନା ଦାରିତା ନିଚାମାଚି ଲ଼କୁ ଏଲେଇଚେରି, “ଈୱାସି ଏଲିୟଇଁ ହା଼ଟି ମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ଅ଼ଡ଼େ ଏ଼ ଦେବୁଣିଏ ରଅସି ଏ଼ୱାରି ବିତ୍ରାଟି ହଟିହିଁ ହାଜାନା ର଼ ଡ୍ରାଃଆଲି ପୁଲା ଅଙ୍ଗୁରି ରାସାତା ମୁସାନା ଏ଼ଦାଆଁ ର଼ ବାଡ଼୍‌ଗାତା ଦସାନା ଜୀସୁକି ଗସାଲି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ସାମା ଏଚେକା ଲ଼କୁ ଏଲେଇଚେରି, “ହେଣ୍ତୁ, ଏଲିୟ ଈୱାଣାଇଁ ଗେଲ୍‌ପାଲି ୱା଼ହିମାନେସି କି ଆ଼ଏ ସିନିକିନ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ସାମା ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ କାଜା ଗିୟାଁତଲେ ହା଼ଟାନା ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ମାହାପୂରୁ ଇଲୁତା ଲେଚାମାନି ହିମ୍ବରି ଲାକଟିଏ ଡ଼଼ଇ ପାତେକା ଗେଞ୍ଜାନା ରୀ ବା଼ଗା ଆ଼ତେ, ଇଞ୍ଜାଁ ବୂମି ବାରେ ୱୀଡିତେ ଅ଼ଡ଼େ ୱାଲ୍‌କା ଅ଼ୟାହାଚୁ, ");
INSERT INTO kxv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଇଞ୍ଜାଁ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ସ୍କା ବାରେ ଦେପିଆ଼ତୁ, ଅ଼ଡ଼େ ହା଼ହାମାଚି ହା଼ରେକା ସୁଦୁ ଲ଼କୁତି ଆଙ୍ଗା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଟି ନିଙ୍ଗାନା ୱା଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଇଞ୍ଜାଁ ଜୀସୁ ୱେଣ୍ତେ ନିଙ୍ଗିତି ଡା଼ୟୁ ଏ଼ୱାରି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଟି ହ଼ଚାନା ସୁଦୁ ଗା଼ଡ଼ାତା ହାଜାନା ହା଼ରେକା ଜା଼ଣାତି ତ଼ଞ୍ଜାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଇଞ୍ଜାଁ ତାନିତଲେ ଜୀସୁଇଁ କା଼ଚାମାଚାରି, ଏ଼ୱାରି ବୂମି ୱୀଡିତାଣି ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ଗଟୱି ଆ଼ତାଣି ମେସାନା ହା଼ରେକା ଆଜାନା ଏଲେଇଚେରି, “ସାତେଏ ଈୱାସି ମାହାପୂରୁ ମୀର୍‌ଏସି ମାଚେସି !” ");
INSERT INTO kxv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଅ଼ଡ଼େ ହା଼ରେକା ଇୟାସିକା ଜିକେଏ ଏମ୍ବାଆଁ ମାଞ୍ଜାନା ହେକଟି ସିନିକିହିମାଚୁ; ଏ଼ୱି ଜୀସୁତି ସେ଼ବା କିହିଁ ଗାଲିଲିଟି ଏ଼ୱାଣିତଲେ ୱା଼ହାମାଚୁ; ");
INSERT INTO kxv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ଏ଼ୱାସିକା ବିତ୍ରାଟି ମଗ୍‌ଦଲିନି ମରିୟମ, ଜାକୁବ ଅ଼ଡ଼େ ଜସେପ ତାମି ଇୟା ମରିୟମ, ଅ଼ଡ଼େ ଜେବଦି ତାମି ଇୟା ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ୱେ଼ଡ଼ା ହାଜିମାଚାଟି ହାରାମାତିୟା ଜସେପ ଦ଼ରୁଗାଟି ହାରାମାତିୟାତି ର଼ ଦ଼ନ ଗାଟାସି ୱା଼ତେସି, ଏ଼ୱାସି ଜିକେଏ ଜୀସୁତି ର଼ ସୀସୁ ଆ଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ଏ଼ୱାସି ପିଲାତ ତା଼ଣା ହାଜାନା ଜୀସୁତି ଆଙ୍ଗା ରୀସ୍ତେସି, ପିଲାତ ଜୀସୁତି ମାଡ଼୍‌ହା ଏ଼ୱାଣାକି ହେର୍‌ପାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଜସେପ ମାଡ଼୍‌ହା ଆଙ୍ଗାତି ଅ଼ହାନା ନେହିଁ ପୁଃନି ପା଼ତାଡ଼ା ଦବ୍‌ଲା ହିମ୍ବରି ରୂପିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ଇଞ୍ଜାଁ ତା଼ନୁ ତାଙ୍ଗେତାକି ହ଼ରୁତା କା଼ର୍‌ୱି କିହାମାନି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ପୁଃନି ଟା଼ୟୁତା ମାଡ଼୍‌ହାତି ଇଟିତେସି, ଇଞ୍ଜାଁ ମାଡ଼୍‌ହାତି ମୁହ୍‌ନି ଟା଼ୟୁତି ଦୁୱେରିତା ର଼ କାଜା ୱାଲି ପ୍ଡିକ୍‌ହାନା ହାଜାତୁସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିୟମ ଅ଼ଡ଼େ ଏଟ୍‌କାତି ମରିୟମ ଏ଼ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା କୁଗା ଡ଼ୟିତୁ । ");
INSERT INTO kxv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତାନି ଅ଼ର ଦିନା, ଇଚିହିଁ ତିୟାରା ଆ଼ନି ଦିନାତି ଡା଼ୟୁତି ଦିନା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପାରୁସିୟାଁ ପିଲାତ ତା଼ଣା ରୁଣ୍ତା ଆ଼ହାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ବା଼ବୁ, ଏ଼ ନା଼ଡ଼ି କିନାସି ଜୀୱୁତା ମାଚାଟି, ‘ନା଼ନୁ ତୀନି ଦିନାଟିଏ ୱେଣ୍ତେ ନିଙ୍ଗିଇଁ’ ଇଞ୍ଜିଁ ୱେସାମାଚାଣି ନୀଏଁ ମା଼ମ୍ବୁ ଅଣ୍‌ପିମାନମି । ");
INSERT INTO kxv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ଏ଼ଦାଆଁତାକି ତୀନିଦିନା ପାତେକା ଏ଼ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା କା଼ଚାଲି ତାକି ହୁକୁମି ହୀମୁ, ଆ଼ଆତିଁ ତାମି ସୀସୁୟାଁ ୱା଼ହାନା ମାଡ଼୍‌ହାତି ଡଂଗା ଆ଼ହାଁ ଏ଼ୱାସି ହା଼କିଟି ନିଙ୍ଗାମାନେସି ଇଞ୍ଜିଁ ଲ଼କୁଣି ୱେହ୍‌ନେରି; ଆତିହିଁ ତଲି ନା଼ଡ଼ି କିତାଣି କିହାଁ ଡା଼ୟୁତି ନା଼ଡ଼ିକିନାୟି ହା଼ରେକା ଆଗାଡ଼ା ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ କା଼ଃଆନାରି ମାନେରି, ମୀରୁ ହାଜାନା ଆ଼ଡିନି ପାତେକା କା଼ଃଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ହାଜାନା କା଼ଃଆନାରି ତଲେ ଏ଼ ୱାଲି ଗୁଚା ଆ଼ଆପେୱା ଇଞ୍ଜିଁ ୱାଲିତି ଜାଣ୍ତି କିହିଁ ସୀଲି ୱେ଼ଚାନା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା କା଼ଃନାରାଇଁ କା଼ପି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ଜ଼ମିନି ଦିନା ରା଼ତି ଡା଼ୟୁ ୱା଼ରାତି ତଲିତି ଦିନାତା ଲା଼ଇ ଲାଇସିଏ ମଗ୍‌ଦଲିନି ମରିୟମ ଅ଼ଡ଼େ ଏଟ୍‌କାତି ମରିୟମ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତି ସିନିକିହାଲି ହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଏ଼ ଦେବୁଣିଏ ବୂମି ୱୀଡିତେ, ଇଚିହିଁ ମାହାପୂରୁତି ର଼ ଦୂତୁ ଲାକପୂରୁଟି ରେ଼ଚାୱା଼ହାନା ଏ଼ ୱାଲିତି ଗୁଚି କିହାନା ଏ଼ଦାଣି ଲାକ କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ତାନି ୱା଼ଣା ମିଣ୍‌ସିମାନି ହା଼ଗୁଲେହେଁ ମାଚେ ଅ଼ଡ଼େ ତାନି ହିମ୍ବରି ପେଣ୍ତିଲେହେଁ ଦବ୍‌ଲା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଇଞ୍ଜାଁ କା଼ଃଆନାରି ଆଜିତାକି ତୀର୍‌ଗିହିଁ ହା଼ତିଲେହେଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ସାମା ଦୂତୁ ଇୟାସିକାଣି ଏଲେଇଚେସି, “ମୀରୁ ଆଜାଆଦୁ, ଇଚିହିଁ ମୀରୁ ପା଼ସି ମୁଣ୍ତାତା ହା଼ତି ଜୀସୁଇଁ ପାରିମାଞ୍ଜେରି, ଏ଼ଦାଆଁ ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ଏ଼ୱାସି ଇମ୍ବାଆଁ ହିଲଅସି; ଇଚିହିଁ ଏ଼ୱାସି ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଏଲେକିହିଁଏ ନିଙ୍ଗାମାନେସି, ୱା଼ଦୁ ଏ଼ୱାସି ଆମିନି ଟା଼ୟୁତା ଡୂରାମାଚେସି ଏ଼ ଟା଼ୟୁତି ସିନିକିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଅ଼ଡ଼େ ମୀରୁ ତବେ ହାଜାନା ତାମି ସୀସୁୟାଁଣି ୱେହ୍‌ଦୁ, ଏ଼ୱାସି ହା଼ତାରି ତା଼ଣାଟି ନିଙ୍ଗାମାନେସି, ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଏ଼ୱାସି ମୀ ନ଼କି ନ଼କିତା ଗାଲିଲିତା ହାଜିମାନେସି, ଏମ୍ବାଆଁ ମୀରୁ ଏ଼ୱାଣାଇଁ ମେହ୍‌ଦେରି; ନା଼ନୁ ୱେସ୍ତାତାଣି ଅଣ୍‌ପାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଏମ୍ବାଟିଏ ଆଜି ଅ଼ଡ଼େ ରା଼ହାଁଟି ମାହ୍‌ଣି ମାଣ୍ତାଟି ତବେ ହାଜାନା ତାମି ସୀସୁୟାଁଣି ୱେସାଲି ଦାବ୍‌ଡ଼ି ହଟୁ । ");
INSERT INTO kxv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଜୀସୁ ଏ଼ୱାସିକାଣି ବେଟାଆ଼ହାନା ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ” ଏମ୍ବାଟିଏ ଏ଼ୱି ଡାଗେ ୱା଼ହାନା ଏ଼ୱାଣି କଡାୟାଁ ଆସାନା ଏ଼ୱାଣାଇଁ ଜହରା କିତୁ । ");
INSERT INTO kxv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାସିକାଣି ଏଲେଇଚେସି, “ଆଜାଆଦୁ, ମୀରୁ ହାଜାନା ନା଼ ତାୟିୟାଁଇଁ ୱେହ୍‌ଦୁ, ଏ଼ୱାରି ଗାଲିଲିତା ହାଲାପେରି; ଏମ୍ବାଆଁ ଏ଼ୱାରି ନାଙ୍ଗେ ମେସ୍ତାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ଆୟାସିକା ହାଜିମାଚାଟି, କା଼ପୁ କା଼ଚାମାଚି କ଼ସ୍‌କା ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଗା଼ଡ଼ାତା ହାଜାନା ଏ଼ ବାରେ ଗଟୱି ଆ଼ତାଣି କାଜା ପୂଜେରାଙ୍ଗାଣି ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ଏ଼ୱାରି ଲ଼କୁତି କାଜାରି ତଲେ ରୁଣ୍ତା ଆ଼ହାନା ଅଣ୍‌ପିହିଁ କାତା ତୀରିକିତି ଡା଼ୟୁ, ଏ଼ କ଼ସ୍‌କାକି ହା଼ରେକା ଟାକାୟାଁ ହୀହାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ମୀରୁ ଏଲେଇଞ୍ଜୁ, ମା଼ମ୍ବୁ ଡୂରାମାଚି ବେ଼ଲାତା ତାମି ସୀସୁୟାଁ ଲା଼ଆଁୟାଁ ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ସ଼ରୁ ଆ଼ହାନା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଅ଼ଡ଼େ ଈ କାତା ସା଼ଲୱି କିନାଣି କିର୍ୟୁଁତା ହାଚିହିଁ, ମା଼ମ୍ବୁ ଏ଼ୱାଣାଇଁ ନେହିଁକିଁ ୱେସାନା ମୀ ଅଣ୍‌ପୁଟି ପିସ୍‌ପି କିୟାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ଏ଼ୱାରି ଟାକାୟାଁ ଅ଼ହାନା ଏ଼ନିକିଁ ହୁକୁମି ବେଟାଆ଼ହା ମାଚେରି, ଏଲେକିହିଁ କିତେରି । ଏ଼ଦାଆଁତାକି ଈ କାତା ଜୀହୁଦି ଲ଼କୁତା଼ଣା ୱେ଼ଙ୍ଗା ହାଜାନା ନୀଏଁ ପାତେକା ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ସାମା ଏଗାର ଜା଼ଣା ସୀସୁୟାଁ ଗାଲିଲିତା ହାଜାନା, ଜୀସୁ ଆମିନି ହ଼ରୁ କାତା ଏ଼ୱାରାଇଁ ୱେସାମାଚେସି, ଏ଼ ହ଼ରୁତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ମେସାନା ଜହରା କିତେରି, ସାମା ଆମ୍ବା ଆମ୍ବାଆରି ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରି ଡାଗେ ୱା଼ହାନା ଏଲେଇଚେସି, “ଲାକପୂରୁ ଅ଼ଡ଼େ ଦାର୍‌ତିତି ଅଦିକାରା ନାଙ୍ଗେ ମେ଼ଡ଼ା ଆ଼ହାମାଞ୍ଜାନେ । ");
INSERT INTO kxv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ଏ଼ଦାଆଁତାକି ମୀରୁ ହାଜାନା ବାରେ କୂଡ଼ାତି ଲ଼କୁଣି ଆ଼ବା, ମୀର୍‌ଏସି ଅ଼ଡ଼େ ସୁଦୁଜୀୱୁ ଦ଼ରୁଟି ବାପ୍ତିସ୍ମ ହୀହାନା, ");
INSERT INTO kxv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ନା଼ନୁ ମିଙ୍ଗେ ହୀହାମାଞ୍ଜାନି ହୁକୁମି ବାରେ ମା଼ନୱି ଆ଼ହାଲି ଜା଼ପ୍‌ହାନା ଏ଼ୱାରାଇଁ ନା଼ ସୀସୁୟାଁ କିଦୁ; ମେହ୍‌ଦୁ ଜୁଗୁ ରା଼ନି ପାତେକା ନା଼ନୁ ବାରେବେ଼ଲା ମୀ ତଲେ ମାଞ୍ଜେ ମାଞ୍ଜାଇଁ ।”");
INSERT INTO kxv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ମାହାପୂରୁ ମୀର୍‌ଏସି ଜୀସୁ କ୍ରୀସ୍ତତି ନେହିଁ କାବ୍ରୁ ଇଲେକିଁ ଆ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ସା଼ସ୍ତେରିତା ଏ଼଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ; “ମାହାପୂରୁ ଏଲେଇଞ୍ଜି ମାନେସି, ମେହ୍‌ମୁ ନା଼ନୁ ନା଼ କାବ୍ରୁ ୱେହ୍‌ନାଣାଇଁ ନୀ ନ଼କିତା ପାଣ୍ତିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ନିଙ୍ଗେତାକି ଜିରୁ ତିୟାରା କିନେସି; ");
INSERT INTO kxv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ରଅଣି ହା଼ଡା ୱେ଼ଙ୍ଗିମାନେ, ପ୍ରବୁତି ଜିରୁ ତିୟାରା କିଦୁ, ଏ଼ୱାସି ତା଼କାଲି ତାକି ଜିରୁ ତିୟି କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ଏମ୍ବାଟିଏ ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ୱା଼ହାନା ବ଼ଲୁ ୱେ଼କ୍‌ହେସି, ଅ଼ଡ଼େ ବାପ୍ତିସ୍ମ ହୀହାନା ଏଲେଇଚେସି, “ଜାହାରା ପା଼ପୁଟି ପିସ୍‌ପି ଆୟାଲିତାକି ମ଼ନ ୱେଟ୍‌ହାନା ବାପ୍ତିସ୍ମ ଅ଼ଦୁ, ଆତିହିଁ ମାହାପୂରୁ ମୀ ପା଼ପୁ ମ୍ଣେକ୍‌ହାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଏମ୍ବାଟିଏ ଜୀହୁଦା ଦେ଼ସା ଇଞ୍ଜାଁ ଜିରୁସାଲମ ଗା଼ଡ଼ାତି ବାରେ ଲ଼କୁ ତାନି ତା଼ଣା ୱା଼ହାଲି ମା଼ଟ୍‌ହେରି, ଇଞ୍ଜାଁ ତା଼ମ୍ବୁ ତାମି କିତି ପା଼ପୁତି ୱେସାନା ଏ଼ୱାଣି ତା଼ଣାଟି ଜର୍ଦନ କାଡାତା ବାପ୍ତିସ୍ମ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଜହନ ଊଟୁ ବା଼ଣାୟାଁ ତଲେ କେ଼ପିତି ହିମ୍ବରିକା ତୁର୍‌ହିମାଚେସି, ଅ଼ଡ଼େ ଟେଡେଲିତା ର଼ ତ଼ଲୁତି ବୁଡ଼୍‌ପା ମା଼ଡ଼ା କିହାଁ ଦସା କଡ୍‌ୱିତେସି, ଗପ୍‌ଏରିକା ଅ଼ଡ଼େ ଜା଼ଡ଼ାତି କ୍ରିୟାଁ ଏ଼ୱାଣି କା଼ଦି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ଜହନ ଏଲେଇଞ୍ଜି ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, “ଆମ୍ବାଆସି ନା଼ କିହାଁ ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁ ଗାଟାସି ଏ଼ୱାସି ନା଼ ଡା଼ୟୁ ୱା଼ହିମାନେସି; ନା଼ନୁ ମେଣ୍ତାକୁତାନା ଏ଼ୱାଣି ସେପୁୟାଁତି ଡ଼଼ର୍କା ଜିକେଏ ହୁକ୍‌ହାଲି ପା଼ଡ଼ାଆ଼ଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ନା଼ନୁ ମିଙ୍ଗେ ଏ଼ୟୁତଲେ ବାପ୍ତିସ୍ମ ହୀହିମାଞ୍ଜାଇଁ, ସାମା ଏ଼ୱାସି ମିଙ୍ଗେ ସୁଦୁଜୀୱୁ ତଲେ ବାପ୍ତିସ୍ମ ହିୟାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ଏଚିବେ଼ଲାତା ଜୀସୁ ଗାଲିଲିତି ନା଼ଜରିତଟି ୱା଼ହାନା ଜର୍ଦନ କାଡାତା ଜହନ ତା଼ଣାଟି ବାପ୍ତିସ୍ମ ଅ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଜୀସୁ ଏ଼ୟୁଟି ନିଙ୍ଗା ୱା଼ହିମାଚାଟି ଦେବୁଣିଏ ଲାକପୂରୁ ଦେପି ଆ଼ତେ ଇଞ୍ଜାଁ ସୁଦୁଜୀୱୁ ପା଼ର୍‌ୱା ପଟାଲେହେଁ ତାନି ଲାକ ରେ଼ଚା ୱା଼ହିମାଚାଣି ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଅ଼ଡ଼େ ଲାକପୂରୁଟି ଈ ହା଼ଡା ଆ଼ତେ, “ନୀନୁ ନା଼ ଜୀୱୁତି ମୀର୍‌ଏଣାତି, ନୀ ତା଼ଣେଏ ନା଼ ହା଼ରେକା ରା଼ହାଁ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ଏ଼ ଦେବୁଣିଏ ସୁଦୁଜୀୱୁ ଏ଼ୱାଣାଇଁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଅ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଜୀସୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ରୀ କ଼ଡ଼ି ଦିନା ପାତେକା ଡ଼ୟାନା ସୟତାନ ତା଼ଣାଟି ତାୟିପାରି କିୱିଆ଼ତେସି; ଏ଼ୱାସି ଜା଼ଡ଼ାତି ଜ଼ନ୍ତ ତଲେ ଡ଼ୟିତେସି, ଇଞ୍ଜାଁ ଲାକପୂରୁତି ଦୂତୁୟାଁ ୱା଼ହାନା ଏ଼ୱାଣି ସେ଼ବା କିହିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଜହନଇଁ କାୟିଦି ଇଲୁତା ଇଟାଲିଏ ଜୀସୁ ଗାଲିଲିତା ୱା଼ତେସି ଇଞ୍ଜାଁ ମାହାପୂରୁତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“କା଼ଲା ଏଜିମାଞ୍ଜାନେ, ଲାକପୂରୁ ରା଼ଜି ଏଗାୱା଼ହିମାନେ, ପା଼ପୁତି ପିସାନା ମ଼ନ ୱେଟ୍‌ଦୁ ଇଞ୍ଜାଁ ମାହାପୂରୁତି ନେହିଁ କାବ୍ରୁତି ନାମାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜୀସୁ ଗାଲିଲି ସାମ୍‌ଦୁରି ଗାଟୁଟି ହାଜିମାଚାଟି ସିମନ ଅ଼ଡ଼େ ତାମି ତାୟି ଆନ୍ଦ୍ରିୟଇଁ ସାମ୍‌ଦୁରିତା ମୀଣ୍‌କା ଜା଼ଲା ମେତ୍‌ହି ମାଚାଣି ମେସ୍ତେସି, ଇଚିହିଁ ଏ଼ୱାରି ମୀଣ୍‌କା ଆହ୍‌ନାରି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜୀସୁ ଏ଼ୱାରାଇଁ ହା଼ଟାନା ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ଦୁ ନା଼ନୁ ମିଙ୍ଗେ ଲ଼କୁଣି ଆହ୍‌ନାଣି ଜା଼ପ୍‌ହାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ଏ଼ୱାରି ଦେବୁଣିଏ ଜା଼ଲାୟାଁ ପିସାନା ଜୀସୁତି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଏଚେଟିଏ ଜୀସୁ ହିରେ ହେକ ହାଜାଲିଏ ଜେବଦି ମୀର୍‌କା ଜାକୁବ ଇଞ୍ଜାଁ ତାମି ତାୟି ଜହନଇଁ ଡଂଗତା ଜା଼ଲା ମୁଦା କିହିମାଚାଣି ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ମେସ୍‌ପନିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ହା଼ଟିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ତାମି ଆ଼ବା ଜେବଦିଇଁ ହ଼ଲିୟାଙ୍ଗା ତଲେ ଡଂଗତା ପିସାନା ଜୀସୁ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ଜୀସୁ ଅ଼ଡ଼େ ତାମି ସୀସୁୟାଁ କପର୍‌ନାହୁମ ଗା଼ଡ଼ାତା ୱା଼ତେରି, ଇଞ୍ଜାଁ ଅ଼ର ନେ଼ଚୁ ଜ଼ମିନି ଦିନା ମାଚାକି ଜୀସୁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଜାନା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଲ଼କୁ ତାନି ଜା଼ପ୍‌ନାଣି ୱେଞ୍ଜାନା କାବା ଆ଼ହାହାଚେରି; ଇଚିହିଁ ଏ଼ୱାସି ସା଼ସ୍ତେରି ୱେହନାରି ଲେହେଁ ଜା଼ପ୍‌ଆନା ଅଦିକାରା ବେଟାଆ଼ହାମାନି ଲେହେଁ ଜା଼ପ୍‌ହି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ଜୀସୁ ଜା଼ପ୍‌ହି ମାଚିବେ଼ଲାତା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ର଼ ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ଼ ନା଼ଜରିତତି ଜୀସୁ ନୀ ତଲେ ମାଙ୍ଗେ ଏ଼ନି କାମା ମାନେ, ନୀନୁ କି ମାଙ୍ଗେ ନା଼ସା କିହାଲି ଇମ୍ବାଆଁ ୱା଼ହାମାଞ୍ଜି ? ନୀନୁ ଆମ୍ବାଆତି ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ; ନୀନୁ ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନି ଏ଼ ସୁଦୁ ମାଣ୍‌ସିତି ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜୀସୁ ଏ଼ଦାନି ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ପାଲେଏ ଆ଼ମୁ ଇଞ୍ଜାଁ ଈୱାଣି ତା଼ଣାଟି ହ଼ଚାହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ଏଚେଟିଏ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁ ଏ଼ୱାଣାଇଁ ମୁଡ଼ୁମାଡ଼ା କିହାନା, କାଜା ଗିୟାଁତଲେ କିର୍‌ଡ଼ିହିଁ ଏ଼ୱାଣି ତା଼ଣାଟି ହ଼ଚାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା ହା଼ରେକା କାବା ଆ଼ତେରି, ଇଞ୍ଜାଁ ଇଲେକିଁ ଜ଼ଲ୍‌କି ଆ଼ତେରି, “ଈଦି ଏ଼ନିଲେହେଁତାୟି ? ଈଦି ଅଦିକାରା ବେଟାଆ଼ହାମାନି ଲେହେଁତି ପୁଃନି ଜା଼ପ୍‌ନାୟି, ଏ଼ୱାସି ପ଼ଲ୍‌ଆ ବୂତୁୟାଁଇଁ ଜିକେଏ ହୁକୁମି ହୀହିମାନେସି, ଅ଼ଡ଼େ ଏ଼ୱି ଏ଼ୱାଣି କାତା ଆସିମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ଏମ୍ବାଟିଏ ଏ଼ୱାସି କିତି କାମାତି କାବ୍ରୁ ଏ଼ ରେ଼ଟୁଏ ଗାଲିଲି ରା଼ଜିତି ସା଼ରିୱାକିତି ନା଼ସ୍‌କାଣାଁ ୱେ଼ଙ୍ଗାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ହ଼ଚାନା ଜାକୁବ ଅ଼ଡ଼େ ଜହନ ତଲେ ଏ଼ ଦେବୁଣିଏ ସିମନ ଇଞ୍ଜାଁ ଆନ୍ଦ୍ରିୟ ଇଜ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ସିମନ ପ଼ୟା ନ଼ମେରି ତାକି ଡୂରାମାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ଦାଣି କାତା ରେ଼ଟୁଏ ଜୀସୁଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଡାଗେ ହାଜାନା ତାନି କେୟୁ ଆସାନା ଏ଼ଦାନି ନିକ୍‌ହେସି, ଅ଼ଡ଼େ ଏ଼ଦାନି ନ଼ମେରି ପିସ୍ତେ, ଇଞ୍ଜାଁ ଏ଼ଦି ଏ଼ୱାରି ସେ଼ବା କିତେ । ");
INSERT INTO kxv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ମିଡ଼୍‌ଅଲା ବେ଼ଲା ୱେ଼ଡ଼ା କୂଡ୍‌ହାଲିଏ ଲ଼କୁ ର଼ଗ ଗାଟାରାଇଁ ଇଞ୍ଜାଁ ବୂତୁୟାଁ ଆଲ୍‌ଗା ମାଚାରାଇଁ ଜୀସୁ ତା଼ଣା ତାତେରି, ");
INSERT INTO kxv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଇଞ୍ଜାଁ ଗା଼ଡ଼ାତାରି ବାରେ ଜୀସୁ ମାଚି ଇଲୁ ଦୁୱେରିତା ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ଏମ୍ବାଟିଏ ଜୀସୁ ବାରେଲେହେଁତି ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିତେସି, ଇଞ୍ଜାଁ ହା଼ରେକା ବୂତୁଣି ପିସ୍‌ପି କିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ବୂତୁୟାଁଣି ଜ଼ଲାଲି ହୀଆତେସି, ଇଚିହିଁ ଏ଼ୱି ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ୱେ଼ୟାଆ ମାଚାଟିଏ ଆନ୍ଦେରି ମାଞ୍ଜା ମାଞ୍ଜାନା ଏ଼ୱାସି ନିଙ୍ଗା ହ଼ଚା ହାଜାନା ର଼ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଜାନା ପ୍ରା଼ତାନା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ସିମନ ଇଞ୍ଜାଁ ତାନି ଆଟ୍‌ହିତାରି ଏ଼ୱାଣାଇଁ ପାରାଲି ମା଼ଟ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ହାନା ଏଲେଇଚେରି, “ବାରେଜା଼ଣା ନିଙ୍ଗେ ପାରିମାଞ୍ଜାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ୱା଼ଦୁ ମା଼ର ଏଟ୍‌କା ଗା଼ଡ଼ାତା, ଇଚିହିଁ ଦାରିମାରି ନା଼ସ୍‌କାଣାଁ ହାନ; ଏମ୍ବାଆଁ ଜିକେଏ ନା଼ନୁ ମାହାପୂରୁତି ବ଼ଲୁ ୱେ଼କ୍‌ଇଁ, ଇଚିହିଁ ଏ଼ଦାଆଁତାକି ନା଼ନୁ ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଇଞ୍ଜାଁ ଜୀସୁ ବାରେ ଗାଲିଲି ନା଼ସ୍‌କାଣାଁ ରେ଼ଜି ରେ଼ଜିହିଁ ଏ଼ୱାରି ବାରେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ମାହାପୂରୁ ବ଼ଲୁ ୱେ଼କ୍‌ହେସି ଇଞ୍ଜାଁ ବୂତୁୟାଁଣି ପିସ୍‌ପି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ଏମ୍ବାଟିଏ ର଼ କାଜା ର଼ଗ ଗାଟାସି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ମେଣ୍ତାକୁତାନା ବାତିମା଼ଲିହିଁ ଜୀସୁଇଁ ଏଲେଇଚେସି, “ନୀନୁ ମ଼ନ କିତିହିଁ ନାଙ୍ଗେ ନେହିଁ କିହାଲି ଆ଼ଡାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ କାର୍ମା ମେସ୍ତେସି, ଇଞ୍ଜାଁ କେୟୁ ଦା଼ସାନା ଏ଼ୱାଣାଇଁ ଡୀଗାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମ଼ନ କିହିମାଇଁ ନୀନୁ ନେହିଁଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣି ତା଼ଣାଟି କାଜା ର଼ଗ ଗୁଚାଆ଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ନେହିଁଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଜାଣ୍ତେ ହୁକୁମି ହୀହାନା ୱେସା ପାଣ୍ତିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ଜାଗ୍ରାତା ଆମ୍ବାଆରାଇଁ ଏ଼ନାଆଁ ୱେହ୍‌ଆନି, ସାମା ହାଲାମୁ ଇଞ୍ଜାଁ ପୂଜେରା ତା଼ଣା ହାଜାନା ନିଙ୍ଗ ତ଼ସାକଡାମୁ, ଇଞ୍ଜାଁ ମ଼ସା ଆମିନି ମେ଼ରା ହୀହାମାନେସି ଏ଼ଦାଆଁ ଲ଼କୁ ନ଼କିତା ନେହିଁ ଆ଼ତାକି ସା଼କି ହୀନିଲେହେଁ ହେର୍‌ପାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ସାମା ଏ଼ୱାସି ପାଙ୍ଗାତା ହାଜାନା ତା଼ନୁ ନେହିଁ ଆ଼ତି କାତାତି ସା଼ରିୱାକି ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, ଇଞ୍ଜାଁ ଜୀସୁ ଆମିନି ଗା଼ଡ଼ାତା ପୁଣ୍‌ମ୍ବେ ହ଼ଡାଲି ଆ଼ଡାଆତେସି, ସାମା ପାଙ୍ଗାତା ଲ଼କୁ ହିଲାଆ ଟା଼ସ୍କାଣା ଡ଼ୟିତେସି; ଅ଼ଡ଼େ ସା଼ରି ୱାକିଟି ଲ଼କୁ ଜୀସୁ ତା଼ଣା ୱା଼ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଏଚରଦିନା ଆୟାଲିଏ ଜୀସୁ କପର୍‌ନାହୁମତା ୱେଣ୍ତେ ହାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଇଜ ମାନେସି ଇଞ୍ଜିଁ ସା଼ରିୱାକି ୱେ଼ଙ୍ଗାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ଏମ୍ବାଆଁ ଇଚେକା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ତେରି ଇଞ୍ଜାଁ ଦୁୱେରିତା ଜିକେଏ ଟା଼ୟୁ ହିଲାଆତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ମାହାପୂରୁ କାତା ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଏମ୍ବାଟିଏ ସା଼ରି ଜା଼ଣା ର଼ ଟଟ ୱା଼ୟିତାଣାଇଁ କାଟେଲିତା ଜୀସୁ ତା଼ଣା ଡେ଼କା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ସାମା ହା଼ରେକା ଲ଼କୁ ମାଚାକି ଏ଼ୱାଣି ତା଼ଣା ତାଚାଲି ଆ଼ଡାଆତେରି, ଇଞ୍ଜାଁ ଆମିନି ଟା଼ୟୁତା ଜୀସୁ ମାଚେସି, ଏମ୍ବାଆଁ ଇଲୁତି ତେ଼ପରି ରିକ୍‌ହେରି, ଇଞ୍ଜାଁ ଏ଼ ଟଟ ୱା଼ୟିତାଣାଇଁ କାଟେଲି ୱେଣ୍ତେଏ ଇଲୁ ବିତ୍ରା ରେ଼ପ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜୀସୁ ଏ଼ୱାରି ନାମୁ ମେସାନା, ଏ଼ ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ମୀର୍‌ଏଣା ନୀ ପା଼ପୁ ବାରେ ମେଣ୍‌ଙ୍ଗାହାଚେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ସାମା ଏମ୍ବାଆଁ ମାଚି ଏଚେକା ମେ଼ରା ଜା଼ପ୍‌ନାରି କୁଗାନା ତାମି ମ଼ନତା ଅଣ୍‌ପିହିଁ କାତାବାର୍ତା ଆ଼ହିମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଈୱାସି ଏ଼ନାଆଁତାକି ଏଲେଇଞ୍ଜି ମାନେସି ? ଈୱାସି ମାହାପୂରୁଇଁ ନିନ୍ଦା କିହିମାନେସି; ମାହାପୂରୁ ପିସ୍‌ପେ ଆମ୍ବାଆସି ପା଼ପୁ ମ୍ଣେକ୍‌ହାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଏ଼ୱାରି ମ଼ନତା ଇଲେକିଁ ଅଣ୍‌ପିମାନାଣି ଜୀସୁ ଦେବୁଣିଏ ଜୀୱୁତା ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ମୀ ମ଼ନ ବିତ୍ରା ଏ଼ନାଆଁତାକି ଇଲେକିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଏ଼ନାଆଁ ଇନାୟି ଊସାସା ? ଏ଼ କାଜା ର଼ଗ ଗାଟାଣାଇଁ ‘ନୀ ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିତେ ଇନାୟି କି ନିଙ୍ଗାମୁ ନୀ କାଟେଲି ଡେ଼କାନା ତା଼କାମୁ ଇନାୟି ଊସାସା ?’ ");
INSERT INTO kxv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ସାମା ଦାର୍‌ତିତା ପା଼ପୁ ମ୍ଣେକ୍‌ହାଲି ମାଣ୍‌ସି ମୀର୍‌ଏଣା ଅଦିକାରା ମାନେ, ଏ଼ଦାଆଁ ନୀଏଁ ମୀରୁ ପୁଞ୍ଜାଲି ଆ଼ଡିଦେରି ।” ଏ଼ଦାଆଁତାକି ଏ଼ ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ନା଼ନୁ ନିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ ନିଙ୍ଗାନା ନୀ କାଟେଲି ଡେ଼କାନା ନୀ ଇଜ ହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ଏଚେଟିଏ ଏ଼ୱାସି ଦେବୁଣିଏ ନିଙ୍ଗାନା କାଟେଲି ଡେ଼କାନା ବାରେଜା଼ଣା ନ଼କିଟି ହ଼ଚାହାଚେସି; ଏଚେଟିଏ ବାରେଜା଼ଣା କାବାଆ଼ହାନା ମାହାପୂରୁତି ଜହରା କିହିଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଇଲେତି କାବାଆ଼ନି କାମା ଏଚେଲା ଜିକେଏ ମେସାହିଲାଆତମି ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ସାମ୍‌ଦୁରି ଗାଟୁତା ହାଚେସି, ଇଞ୍ଜାଁ ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାଲିଏ, ଏ଼ୱାରାଇଁ ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଅ଼ଡ଼େ ଜିରୁଟି ହାଜି ହାଜିହିଁ ଜୀସୁ ଆଲେପି ମୀର୍‌ଏସି ଲେ଼ବିଇଁ ସିସ୍ତୁ ରୀହ୍‌ନି ତା଼ଣା କୁଗାମାନାଣି ମେସ୍ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ” ଏଚେଟିଏ ଲେ଼ବି ନିଙ୍ଗାନା ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ଅ଼ଡ଼େ ଜୀସୁ ଲେ଼ବି ଇଜ ରା଼ନ୍ଦା ତିଞ୍ଜାଲି କୁଗାମାଚାଟି ହା଼ରେକା ସିସ୍ତୁ ରୀହ୍‌ନାରି ଇଞ୍ଜାଁ ପା଼ପୁ ଗାଟାରି ତାମି ସୀସୁୟାଁ ତଲେ କୁଗିତେରି; ଇଚିହିଁ ଏ଼ୱାରି ହା଼ରେକା ମାଚେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଜେ଼ଚ ହାଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଜୀସୁ ପା଼ପୁ ଗାଟାରି ଇଞ୍ଜାଁ ସିସ୍ତୁ ରୀହ୍‌ନାରି ତଲେ ତିଞ୍ଜି ମାନେସି, ଈଦାଆଁ ମେସାନା ପାରୁସି ଗଚିତି ମେ଼ରାପୁନାରି ତାନି ସୀସୁୟାଁଣି ଏଲେଇଚେରି, “ଏ଼ୱାସି ଏ଼ନାଆଁତାକି ପା଼ପୁ ଗାଟାରି ଅ଼ଡ଼େ ସିସ୍ତୁ ରୀହ୍‌ନାରି ତଲେ ରା଼ନ୍ଦା ତିଞ୍ଜି ମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଜୀସୁ ଈ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନେହିଁ ଲ଼କୁତାକି ଅସଗୂରୁ ଲ଼ଡ଼ା ହିଲେଏ, ସାମା ର଼ଗ ଗାଟାରାକି ଲ଼ଡ଼ାମାନେ; ନା଼ନୁ ଦାର୍ମୁ ଲ଼କୁତାକି ୱା଼ହାହିଲଅଁ ସାମା ପା଼ପୁ ଗାଟାରାକି ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଜହନତି ସୀସୁୟାଁ ଇଞ୍ଜାଁ ପାରୁସିୟାଁ ଉପାସା କିହିମାଚାଟି, ଏଚେକା ଲ଼କୁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଜହନତି ସୀସୁୟାଁ ଇଞ୍ଜାଁ ପାରୁସିୟାଁତି ସୀସୁୟାଁ ଉପାସା କିନେରି, ସାମା ନୀ ସୀସୁୟାଁ ଏ଼ନାଆଁତାକି ଉପାସା କିଅରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବୀହା ଲ଼କୁତଲେ ବୀହା ହନେଏସି ମାନି ପାତେକା ବୀହା ଲ଼କୁ ହାକିଟି ମାଞ୍ଜାଲି ଆ଼ଡିନେରିକି ? ବୀହା ହନେଏସି ଏ଼ୱାରିତଲେ ମାନି ପାତେକା ଏ଼ୱାରି ଉପାସା କିଅରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ସାମା ଦିନା ୱା଼ନେ ଏଚିବେ଼ଲା ଏ଼ୱାରି ତା଼ଣାଟି ବୀହା ହନେଏଣାଇଁ ହ଼ପ୍‌ହା ଅ଼ତିସାରେ ଏଚିବେ଼ଲା ଏ଼ୱାରି ଉପାସା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ଆମ୍ବାଆସି ପ୍ଣାଃଇ ହିମ୍ବରିତା ପୁଃନି ପାସ୍‌କି ତା଼ଚଅସି; ତା଼ଚିସାରେ ପ୍ଣାଃଇ ହିମ୍ବରିତି ପୁଃନି ପାସ୍‌କି ମୁଦା ଆ଼ହାଁ ଗାଡି ଗେଞ୍ଜିକିନେ । ");
INSERT INTO kxv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଆମ୍ବାଆସି ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପ୍ଣାଃଇ ଡ଼଼କାତା ଇଟଅସି; ଇଟିସାରେ ଡ଼଼କା ଡ଼ାୟାହାନେ, ଇଞ୍ଜାଁ ଅଙ୍ଗୁରି ରାସା ଅ଼ଡ଼େ ଡ଼଼କା ରିଣ୍ତିୱା ନସ୍ତ ଆ଼ନୁ, ଏ଼ଦାଆଁତାକି ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପୁଃନି ଡ଼଼କାତା ଇଟିନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ର଼ ପା଼ଲି ଜୀସୁ ଜ଼ମିନି ଦିନା ତାନି ସୀସୁୟାଁ ତଲେ ଗ଼ହଁ ଗୁଡିୟାଟି ହାଜିମାଚେସି, ତାମି ସୀସୁୟାଁ ହାଜି ହାଜିହିଁ ଗ଼ହଁୟାଁ ଜେ଼କା ଡାପ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଏମ୍ବାଟିଏ ପାରୁସିୟାଁ ଜୀସୁଇଁ ଏଲେଇଚେରି, “ମେହ୍‌ମୁ ଜ଼ମିନି ଦିନାତା ଏ଼ନାଆଁ କିନାୟି ମେ଼ରା ହିଲେଏ, ନୀ ସୀସୁୟାଁ ଏ଼ନାଆଁତାକି କିହିମାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଦାୱୁଦ ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗା ହାକି ଆ଼ହାମାଚାଟି ଏ଼ୱାରି ଏ଼ନାଆଁ କିହାମାଚେରି, ଏ଼ଦାଆଁ ମୀରୁ ଏଚେଲା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି, ");
INSERT INTO kxv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିୟତର କାଜା ପୂଜେରା ମାଚିବେ଼ଲାତା ଏ଼ୱାସି ଏ଼ନିକିଁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଆମିନି ମାହାପୂରୁକି ହେର୍‌ପିତି ରୂଟି କାଜା ପୂଜେରାଙ୍ଗା ପିସ୍‌ପେ ଆମ୍ବାଆରି ତିନାଆଗାଟି ମେ଼ରା ମାଚେ, ସାମା ଏ଼ଦାଆଁ ଦାୱୁଦ ତିଞ୍ଜା ମାଚେସି ଇଞ୍ଜାଁ ତାନି ଆଟ୍‌ହି ତାରାକି ଜିକେଏ ତିଞ୍ଜାଲି ହୀହାମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଡା଼ୟୁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଜ଼ମିନି ଦିନା ମାଣ୍‌ସିତାକି ଆ଼ହାମାନେ; ସାମା ମାଣ୍‌ସି ଜ଼ମିନି ଦିନାତାକି ଆ଼ହାହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ଏ଼ଦାଆଁତାକି ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜ଼ମିନି ଦିନାତି ପ୍ରବୁ ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଚେସି, ଏମ୍ବାଆଁ ରଅସି ମାଚେସି, ଏ଼ୱାଣି ର଼ କେୟୁ ୱା଼ୟାହାଜାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଜ଼ମିନି ଦିନାତା ନେହିଁ କିନେସିକି ଆ଼ଏ, ଏ଼ୱାଣି କ଼ପାଟି ଦ଼ହ ଦସାଲିତାକି ଗୁରି କିହାନା ସିନିକିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଏମ୍ବାଟିଏ ଜୀସୁ ଆମିନି ଲ଼କୁତି କେୟୁ ୱା଼ୟାହାଜାମାଚେ, ଏ଼ୱାଣାଇଁ ଜୀସୁ ଏଲେଇଚେସି, “ୱା଼ମୁ ମାଦି ନିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଜ଼ମିନି ଦିନାତା ଏ଼ନାଆଁ କିନାୟି ମେ଼ରା ମାନେ ? ନେହିଁକିନାୟି କି ଲାଗେଏ କିନାୟି ? ଜୀୱୁତି ଗେଲ୍‌ପିନାୟି କି ନା଼ସା କିନାୟି ?” ସାମା ଏ଼ୱାରି ୱେଣ୍ତେ ହା଼ଡା ଆୟାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରି ଆ଼ଟ୍‌ୱା ହିୟାଁତି ମେସାନା ଦୁକୁ ଆ଼ତେସି, ଇଞ୍ଜାଁ କ଼ପାଟି ସା଼ରିୱାକି ଏ଼ୱାରାଇଁ ସିନିକିହାନା ଏଲେଇଚେସି, “କେୟୁ ଲାକ ଦା଼ହ୍‌ମୁ” ଏ଼ୱାସି ତାନି କେୟୁ ଦା଼ସ୍‌ପନିଏ ଏ଼ଦି ନେହିଁ ଆ଼ହାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଏଚେଟିଏ ପାରୁସିୟାଁ ହ଼ଚା ହାଜାନା ଜୀସୁଇଁ ପା଼ୟାଲି ତାକି ହେରଦ ଗଚିତି ଲ଼କୁତଲେ କାଲ୍‌ହାନା କାତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜୀସୁ ଅ଼ଡ଼େ ତାମି ସୀସୁୟାଁ ଗାଲିଲି ସାମ୍‌ଦୁରି ଗାଟୁତା ହାଚେରି, ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି; ଏ଼ୱାରି ଜୀହୁଦା, ");
INSERT INTO kxv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଗାଲିଲି, ଜିରୁସାଲମ, ଇଦମ, ଜର୍ଦନ ଅ଼ରୱାକି, ସ଼ର ଅ଼ଡ଼େ ସିଦନ ଗା଼ଡ଼ା ୱାକିତି ଲ଼କୁ ତାନି ବାରେ କିତି କାମାତି କାତା ୱେଞ୍ଜାନା ତାନି ତା଼ଣା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ଏମ୍ବାଆଁ ଇଚେକା ମାନ୍ଦା ଲ଼କୁ ଆ଼ତେରି ଏ଼ ମାନ୍ଦା ଏ଼ନିକିଁ ଏ଼ୱାଣିଲାକ ୱିହ୍‌ଅରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ତାନି ସୀସୁୟାଁଣି ତାଙ୍ଗେତାକି ର଼ ଊଣା ଡଂଗ ପାରା ଇଟାଲି ୱେସ୍ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଏ଼ୱାସି ହା଼ରେକା ଲ଼କୁଣି ନେହିଁ କିହାମାଚାକି ର଼ଗ ଗାଟାରି ବାରେ ଏ଼ୱାଣାଇଁ ଡୀଗାଲି ଏ଼ୱାଣି ମୁହେଁ ମୁହେଁ ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଇଞ୍ଜାଁ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ଆସାମାନାରି ଏ଼ୱାଣାଇଁ ମେସ୍‌ପନିଏ, ଏ଼ୱାଣି ନ଼କିତା ରିହାନା କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଞ୍ଜି ମାଚୁ, “ନୀନୁଏ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ଏ଼ୱାସି ଆମ୍ବାଆସି ଈ କାତା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଜୀସୁ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁଇଁ ଦାକା ହୀହାନା ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଜୀସୁ ହ଼ରୁ ଲାକ ହାଜାନା ଆମିନି ଗାଟାରାଇଁ ମ଼ନ କିତେସି ଏ଼ୱାରାଇଁ ଡାଗେ ହା଼ଟିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଡାଗେ ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଇଞ୍ଜାଁ ଏ଼ୱାସି ବା଼ରଜା଼ଣାତି ଆ଼ଚାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଇଞ୍ଜାନା, ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ତଲେ ଡ଼ୟାଲି ନା଼ନୁ ମିଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜାଇଁ, ଇଞ୍ଜାଁ ୱେ଼କ୍‌ହାଲି ପାଣ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଇଞ୍ଜାଁ ମୀରୁ ବୂତୁୟାଁ ପେ଼ର୍‌ହାଲି ଜିକେଏ ଅଦିକାରା ବେଟାଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜୀସୁ ଈ ବା଼ରଜା଼ଣାତି ଆ଼ଚିତେସି, ଏ଼ୱାରି ଆ଼ତେରି ସିମନ ଆମ୍ବାଆରାଇଁ ଜୀସୁ ପିତର ଇଞ୍ଜିଁ ଇଟିତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦି ରୀ ମୀର୍‌କା ଜାକୁବ ଅ଼ଡ଼େ ତାନି ତାୟି ଜହନ ଆମ୍ବାଆରାଇଁ ବିନେରିଗସ୍‌ ଇଚିହିଁ ଗୂଣ୍‌ହିମାନି ହା଼ଗୁତି ମୀର୍‌କା ଇଞ୍ଜିହିଁ ଦ଼ରୁ ଇଟିତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ, ପିଲିପ, ବାର୍ତଲମି, ମାତିୟୁ, ତ଼ମା, ଆଲେପି ମୀର୍‌ଏସି ଜାକୁବ, ତଦିୟ, ଦେ଼ସାତି ଜୀୱୁ ନ଼ନି ସିମନ, ");
INSERT INTO kxv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଅ଼ଡ଼େ ଇସ୍କାରିୟତ ଜୀହୁଦା, ଆମ୍ବାଆସି ଜୀସୁଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ଡା଼ୟୁ ଜୀସୁ ଇଜ ୱା଼ତେସି; ଅ଼ଡ଼େ ୱେଣ୍ତେ ଇଚେକା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ତେରି ଜୀସୁ ଇଞ୍ଜାଁ ତାନି ସୀସୁୟାଁକି ତିଞ୍ଜାଲି ଜିକେଏ ଆ଼ଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“ଜୀସୁ ବାୟା ଆ଼ତେସି” ଇଞ୍ଜିଁ ଲ଼କୁ ଏଲେଇନାଣି ୱେଞ୍ଜାନା ତାମି କୁଟମି ଜୀସୁଇଁ ଅ଼ହାଲି ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଅ଼ଡ଼େ ଜିରୁସାଲମଟି ୱା଼ହାମାନି ମେ଼ରାପୁନାରି ଏଲେଇଚେରି, “ଈୱାଣାଇଁ ବାଲ୍‌ଜିବୁଲ୍‌ ବୂତୁ ଆଲ୍‌ଗାମାନେ, ଲାକା ଈୱାସି ବୂତୁୟାଁଣି ପିସ୍‌ପି କିହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଡାଗେ ହା଼ଟାନା ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସ୍ତେସି, “ସୟତାନ ଏ଼ନିକିଁ ସୟତାନଇଁ ପେ଼ର୍‌ହାଲି ଆ଼ଡିନେ ? ");
INSERT INTO kxv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ର଼ ରା଼ଜି ବା଼ଗା ଆ଼ହାନା ତାନି କ଼ପାଟି ନିଙ୍ଗିନେ, ଇଚିହିଁ ଏ଼ ରା଼ଜି ଅ଼ଡ଼େ ତୀରିତଲେ ଡ଼ୟାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଇଞ୍ଜାଁ ର଼ ଇଲୁ କୁଟମିତାରି ବା଼ଗା ଆ଼ହାନା ତା଼ମ୍ବୁ ତାମି କ଼ପାଟି ନିଙ୍ଗିନେରି ଇଚିହିଁ ଏ଼ ଇଲୁତାରି ତୀରିତଲେ ଡ଼ୟାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ଏଲେକିହିଁଏ ସୟତାନ ବା଼ଗା ଆ଼ହାନା ତାନି କ଼ପାଟି ନିଙ୍ଗାମାନେ, ଆତିହିଁ ଏ଼ଦି ଅ଼ଡ଼େ ତୀରିତଲେ ଡ଼ୟାଲି ଆ଼ଡେଏ, ସାମା ଏ଼ଦାନି ବାରେ ନା଼ସା ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ସାମା ଆମ୍ବାଆସି ନ଼କେଏ ବା଼ଡ଼୍‌ୟୁ ଗାଟାଣାଇଁ ଦହ୍‌ଆତିହିଁ ତାନି ଇଜ ହ଼ଡାନା ତାନି ଇଜତି ଆ଼ସ୍ତି ସ଼ରୁ କିହାଲି ଆ଼ଡଅସି; ଏ଼ୱାଣାଇଁ ତଲିଏ ଦସ୍ତିହିଁଦେ ଏ଼ୱାସି ଏ଼ୱାଣି ଇଜତାଣି ସ଼ରୁ କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ନା଼ନୁ ମିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଲ଼କୁତି ବାରେ ପା଼ପୁ ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏଚେକା ନିନ୍ଦା କାତାତଲେ ମାହାପୂରୁ ନିନ୍ଦା କିନେରି ଏ଼ ବାରେ ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନେ । ");
INSERT INTO kxv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ସାମା ଆମ୍ବାଆସି ସୁଦୁଜୀୱୁ କ଼ପାଟି ନିନ୍ଦା କାତା ଜ଼ଲିନେସି, ଏ଼ୱାଣି ଆମିନି କା଼ଲାତା ଜିକେଏ ଦ଼ହ ମେଣ୍‌ଙ୍ଗେଏ, ସାମା ଏ଼ୱାସି କା଼ଲାକା଼ଲାତି ପା଼ପୁତି ଦ଼ହଗାଟାସି ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ଜୀସୁଇଁ ବୂତୁ ଆଲ୍‌ଗାମାନେ ଇଞ୍ଜିଁ ଏଚେକା ଲ଼କୁ ଏଲେଇଞ୍ଜାଲିଏ ଜୀସୁ ଈ କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ଏଚିବେ଼ଲା ଜୀସୁତି ଇୟା ଅ଼ଡ଼େ ତାୟିୟାଁ ୱା଼ହାନା ଇଲୁ ପାଙ୍ଗାତା ନିଚାନା ଜୀସୁଇଁ ହା଼ଟି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଏମ୍ବାଟିଏ ସା଼ରିୱାକି କୁଗାମାଚି ଲ଼କୁ ଏଲେଇଚେରି, “ମେହ୍‌ମୁ ମୀ ଇୟା, ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା ପାଙ୍ଗାତା ନିଚାନା ନିଙ୍ଗେ ପାରିମାଞ୍ଜାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ଇୟା ଇଞ୍ଜାଁ ନା଼ ତାୟି ତାଙ୍ଗିସ୍କା ଆମ୍ବାଆୟି ?” ");
INSERT INTO kxv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାନି ସା଼ରିୱାକି କୁଗାମାନି ଲ଼କୁଣି ସିନିକିହାନା ଏଲେଇଚେସି, “ମେହ୍‌ଦୁ ନା଼ ଇୟା ଅ଼ଡ଼େ ନା଼ ତାୟି ତାଙ୍ଗିସ୍କା । ");
INSERT INTO kxv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଆମ୍ବାଆସି ମାହାପୂରୁତି କାତା ଆହ୍‌ନେସି ଏ଼ୱାସିଦେଁ ନା଼ ତାୟି, ତାଙ୍ଗି ଅ଼ଡ଼େ ନା଼ ଇୟା ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜୀସୁ ଗାଲିଲି ସାମ୍‌ଦୁରି ଗାଟୁତା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ରୁଣ୍ତା ଆ଼ତେରି ଇଞ୍ଜାଁ ଜୀସୁ ସାମ୍‌ଦୁରିତା ମାନି ର଼ ଡଂଗତା ହାଜାନା କୁଗିତେସି ଇଞ୍ଜାଁ ଲ଼କୁ ସାମ୍‌ଦୁରି ଗାଟୁତା ନିଚାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ହା଼ରେକା ପୁଣ୍‌ମ୍ବିକିନି କାତା ଜା଼ପ୍‌ହିହିଁ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ୱେଞ୍ଜୁ, ମେହ୍‌ଦୁ ର଼ ବିଚା ମାଟିନାସି ବିଚା ମାଟାଲି ହ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ଇଞ୍ଜାଁ ଏ଼ୱାସି ମାଟିମାଚାଟି କଚେକା ବିଚା ଜିରୁତା ରୀତେ, ଇଞ୍ଜାଁ ପଟାୟାଁ ୱା଼ହାନା ଏ଼ ପା଼ଡ଼େୟି ପେର୍‌ହା ତିଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଅ଼ଡ଼େ କଚେକା ବିଚା ଇଚାୟି ଇର୍‌ଆ ମାନି ୱାଲ୍‌କା ଲାକ ରୀତେ, ଇଞ୍ଜାଁ ଊଣା ଇର୍‌ଆ ମାଚାକି ଗା଼ଡ଼େକେଏ ନେୟିଁତେ, ");
INSERT INTO kxv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ସାମା ୱେ଼ଡ଼ା ଆ଼ଡାଲିଏ ନେୟାଁ ମାଚାୟି ୱେହା ହାଚେ ଇଞ୍ଜାଁ ହୀରୁ ଜୀଆତାକି ୱା଼ୟାନା ହା଼ହାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଅ଼ଡ଼େ କଚେକା ବିଚା ହା଼ପ୍‌କା ବୂଟାତା ରୀତେ, ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ବୂଟା ପାଡାଆ଼ହାନା ଆର୍ନା ଡାକିତି ପ୍ଡିକ୍‌ହାତୁସ୍ତେ ଇଞ୍ଜାଁ ପା଼ଡ଼େୟି ଆ଼ୟାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ଅ଼ଡ଼େ କଚେକା ବିଚା ନେହିଁ ବୂମିତା ରୀତେ, ଏ଼ଦି ନେୟାହାଁ ପାଡାଆ଼ହାନା, କଡ଼େଦସ, ତୀନିକ଼ଡ଼ି, ପା଼ସାକ଼ଡ଼ି ପା଼ଡ଼େୟି କାମ୍ବିତେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଚେସି, “ୱେଞ୍ଜାଲି ଆମ୍ବାଆରାକି କୀର୍କା ମାନୁ ଏ଼ୱାସି ୱେଣ୍‌ମ୍ବାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜୀସୁ ରଅସିଏ ମାଚାଟି ତାନି ତଲେତି ଏଚରଜା଼ଣା ଇଞ୍ଜାଁ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ତଲେ ଏ଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଏ଼ନାୟି ଇଞ୍ଜିଁ ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ମାହାପୂରୁ ରା଼ଜିତି ଡ଼ୁଗାମାନାଣି ପୁଞ୍ଜାଲି ମିଙ୍ଗେ ବା଼ଡ଼୍‌ୟୁ ହୀପ୍‌କି ଆ଼ହାମାନେ, ସାମା ପାଙ୍ଗାତି ବାରେ ଲ଼କୁତାକି ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସ୍‌ପି ଆ଼ହିମାନେ, ");
INSERT INTO kxv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଏ଼ନିକିଁ, “ଏ଼ୱାରି ମେସି ମେସିହିଁ, ମେହ୍‌ଅରି; ଇଞ୍ଜାଁ ୱେଞ୍ଜିୱେଞ୍ଜିହିଁ, ତେଲ୍‌ହଅରି, ଏ଼ୱାରି ମାହାପୂରୁ ତା଼ଣା ୱେଣ୍ତା ୱା଼ତିହିଁମା, ପା଼ପୁଟି ପିସ୍‌ପି ଆ଼ତେରିମା ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଈ ପୁଣ୍‌ମ୍ବି କିନାଣି ପୁଞ୍ଜି ହିଲଅତେରି ? ଆତିହିଁ ନା଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଏ଼ନିକିଁ ପୁଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ଆମ୍ବାଆସି ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାସି ଏ଼ୱାସି ବିଚା ମାଟିନାସି । ");
INSERT INTO kxv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଆମିନି ଗାଟାରି ୱେନେରି, ଇଞ୍ଜାଁ ୱେଚି ଦେବୁଣିଏ ସୟତାନ ୱା଼ହାନା ଏ଼ୱାରିତା଼ଣା ୱେଣ୍‌ମ୍ବି ଆ଼ହାମାନି ବ଼ଲୁ ମୀଞ୍ଜାଅ଼ନେ, ଏ଼ୱାରି ଜିରୁ ଦାରିତା ରିତି ବିଚାଲେହେଁତାରି । ");
INSERT INTO kxv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ଏଲେକିହିଁଏ ୱାଲି ଲାକ ରିହାମାନି ବିଚାଲେହେଁତାରି, ଏ଼ ବ଼ଲୁ ୱେଣ୍‌ମ୍ବନିଏ ରା଼ହାଁଟି ନାମିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ସାମା ଏ଼ୱାରିତା଼ଣା ହୀରୁ ଜୀଆତାକି ଗା଼ଡ଼େକା ତାକି ତୀରି ମାନେରି, ଡା଼ୟୁ ମାହାପୂରୁ ବ଼ଲୁ ତାକି କସ୍ତ ବା଼ଦା ୱା଼ତିସାରେ ଦେବୁଣିଏ ପିହ୍‌ନେରି, ଏ଼ୱାରି ଊଣା ଇର୍‌ଆ ମାନି ୱାଲ୍‌କା ଲାକତି ବିଚାଲେହେଁତାରି । ");
INSERT INTO kxv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ହା଼ପ୍‌କା ବୂଟାତା ମାଟିତି ବିଚା ଏ଼ୱାରି, ଆମ୍ବାଆରି ବ଼ଲୁତି ୱେନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ଦାର୍‌ତିତି ଅଣ୍‌ପୁ ଦ଼ନତି ବାରେ ଜୂପ୍‌କା ହ଼ଡାନା ଏ଼ୱାରାଇଁ ପ୍ଡିକ୍‌ହାତୁହ୍‌ନେ, ଇଞ୍ଜାଁ ଏ଼ଦି ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି କାତା ୱେନେରି, ଇଞ୍ଜାଁ ନାମିନେରି, ଅ଼ଡ଼େ କଡ଼େଦସ, ତୀନିକ଼ଡ଼ି, ଇଞ୍ଜାଁ ପା଼ସାକ଼ଡ଼ି ପା଼ଡ଼େୟି କାମ୍ବିନେରି, ଏ଼ୱାରି ନେହିଁ ବୂମିତା ମାଟିତି ବିଚାଲେହେଁତାରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ଦୀୱଁ ଡ଼ୀସାନା ମା଼ଣା ପ୍ଡିକ୍‌ହାନା କି କାଟେଲି ଡ଼଼ଇ ଇଟିନେସି ? ଏ଼ଦାଆଁ ଏ଼ନାଆଁ ଦୀୱଁ ସ଼ଡ଼ାତା ଇଟଅସି ? ");
INSERT INTO kxv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଇଚିହିଁ ତ଼ଞ୍ଜା ଆ଼ଆଗାଟାୟି ଏ଼ନାୟି ଜିକେଏ ଡ଼ୁଗାନା ଡ଼ୟେଏ; ଏ଼ନାୟି ଡ଼ୁଗାନା ଆ଼ହାମାନେ, ଏ଼ଦି ତ଼ଞ୍ଜାଆ଼ହାଲି ଡ଼ୁଗାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଇଚିହିଁ ଆମ୍ବାଆରାକି ୱେଞ୍ଜାଲି କୀର୍କା ମାନୁ ଏ଼ୱାସି ୱେଣ୍‌ମ୍ବାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜୀସୁ ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ଏ଼ନାଆଁ ୱେଞ୍ଜି ମାଞ୍ଜେରି ଏ଼ କାତାତା ଜାଗ୍ରାତା, ଆମିନି ମା଼ଣା ତଲେ ଲା଼ଚିଦେରି, ଏ଼ ମା଼ଣା ତଲେ ମିଙ୍ଗେ ଲା଼ଚା ହିୟାନେରି, ଅ଼ଡ଼େ ମୀରୁ ହା଼ରେକା ବେଟାଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଇଚିହିଁ ଆମ୍ବାଆରାକି ମାନେ ଏ଼ୱାଣାକି ହୀପ୍‌କି ଆ଼ନେ; ଅ଼ଡ଼େ ଆମ୍ବାଆରାକି ହିଲେଏ, ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନାୟି ମାନେ, ଏ଼ଦାଆଁ ଜିକେଏ ଏ଼ୱାଣି ତା଼ଣାଟି ଅ଼ୱିଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଜୀସୁ ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ମାହାପୂରୁ ରା଼ଜି ଇଲେତାୟି, ଏ଼ନିକିଁ ର଼ ମାଣ୍‌ସି ବୂମିତା ବିଚା ମାଟିନେସି; ");
INSERT INTO kxv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଇଞ୍ଜାଁ ଲା଼ଆଁୟାଁ ଇଦା କିନେସି ଅ଼ଡ଼େ ମାଦେନା ତେଃଏଲିନେସି, ଅ଼ଡ଼େ ବିଚା ଏ଼ନିଆ଼ହିଁ ଗଜା ଆ଼ହାଁ ପାଡାଆ଼ନେ ଏ଼ଦାଆଁ ଏ଼ୱାସି ପୁନଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ଗ଼ହଁ ବୂମିଟି ତା଼ନୁଏ ନେୟିଁନେ, ତଲିଏ ଆ଼କୁ ଆ଼ନେ ଡା଼ୟୁ ଜେ଼ଙ୍ଗୁ ଅ଼ଡ଼େ ଡା଼ୟୁ ଜେ଼ଙ୍ଗୁତି ପା଼ଡ଼େୟି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ସାମା ଆର୍ନା କାମ୍ବିସାରେ ମାଟିତାସି ଏ଼ ଆର୍ନାତି କ଼ଚାଡୱେଲି ତଲେ ଦା଼ଃଆନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ଅ଼ଡ଼େ ଜୀସୁ ଏଲେଇଚେସି, “ମା଼ର ମାହାପୂରୁ ରା଼ଜି ଏ଼ନାଆଁତଲେ ତୂକ୍‌ନାୟି ? ଇଞ୍ଜାଁ ଏ଼ନିଲେହେଁତି ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେହ୍‌ନାୟି ? ");
INSERT INTO kxv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ଏ଼ଦି ର଼ ହାର୍ସୁ ପା଼ଡ଼େୟି ଲେହେଁ; ବୂମିତା ମାଟିନି ବେ଼ଲାତା ଏ଼ଦି ଦାର୍‌ତିତି ବାରେ ପା଼ଡ଼େୟି କିହାଁ ଊଣା, ");
INSERT INTO kxv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ସାମା ମାଟିତି ଜେ଼ଚ ପାଡାଆ଼ହାନା ବାରେ କୁଚା କିହାଁ କାଜାୟି ଆ଼ନେ, ଇଞ୍ଜାଁ ଏ଼ଦାନି କମାୟାଁ ଇଲେକିଁ କାଜାଇ ଆ଼ନୁ, ଇଞ୍ଜାଁ ହା଼ଗୁ ଲାକ ଊମ୍ବିନି ପଟାୟାଁ ୱା଼ହାନା ଏ଼ଦାନି କମାଣାଁ ବ଼ଣ ଦସାଁ ବାସାଆ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଜୀସୁ ଇଲେକିହିଁ ହା଼ରେକା ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସିହିଁ ଏ଼ୱାରି ପୁନିଲେହେକିଁ ମାହାପୂରୁ କାତା ୱେସିମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଅ଼ଡ଼େ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଆଟ୍‌ଆନା ଜୀସୁ ଏ଼ନାଆଁୱା ୱେସି ହିଲାଆତେସି, ସାମା ଲ଼କୁ ହିଲାଆ ବେ଼ଲାତା ତାମି ସୀସୁୟାଁଣି ବାରେ ପୁଣ୍‌ମ୍ବି କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ଏ଼ ଦିନା ମିଡ଼୍‌ଅଲା ବେ଼ଲା ଜୀସୁ ତାମି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ୱା଼ଦୁ ମା଼ର ସାମ୍‌ଦୁରି ଆତାଲା ହାନ ।” ");
INSERT INTO kxv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଲ଼କୁଣି ପିସାନା ଏ଼ୱାସି ଏ଼ନିକିଁ ଡଂଗତା ମାଚେସି ଏଲେକିହିଁଏ ଅ଼ତେରି, ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ଏଚରଗଟା ଡଂଗାଁୟାଁ ଜିକେଏ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ଇଞ୍ଜାଁ ଦେବୁଣିଏ ହା଼ରେକା କାଜା ଗା଼ଲି ଆ଼ତେ, ଇଞ୍ଜାଁ ଡଂଗ ସାମ୍‌ଦୁରିତି ଗା଼ଲିତାକି ମୁଞ୍ଜାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ଏଚିବେ଼ଲା ଜୀସୁ ଡଂଗତି ଡା଼ୟୁୱାକି ର଼ ମୂଲାତା ତା଼ର୍‌ପୁ ଆ଼ଂଗାନା ଇଦା କିହାମାଚେସି; ଇଞ୍ଜାଁ ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ନିକ୍‌ହାନା ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ମା଼ର ହାନାୟିଦେଁ ନିଙ୍ଗେ ଅଣ୍‌ପୁ ହିଲେଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଏମ୍ବାଟିଏ ଜୀସୁ ନିଙ୍ଗାନା ଗା଼ଲିତି ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ଡୂଙ୍ଗାମୁ” ଇଞ୍ଜାଁ ସାମ୍‌ଦୁରିତି ଏଲେଇଚେସି, “ସାପି ଆ଼ମୁ” ଏମ୍ବାଟିଏ ଗା଼ଲି ପାଲେଏ ଆ଼ତେ ଇଞ୍ଜାଁ ବାରେ ସୂସ୍ତି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁତାକି ଇଚେକା ଆଜିମାଞ୍ଜେରି ? ମୀ ନାମୁ ହିଲେଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହା଼ରେକା ଆଜାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ କାତା ଆ଼ତେରି, “ଈୱାସି ଆମ୍ବାଆସି ? ଗା଼ଲି ଅ଼ଡ଼େ ସାମ୍‌ଦୁରି ଜିକେଏ ଈୱାଣି ହା଼ଡା ମା଼ନୱି ଆ଼ହିମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଡା଼ୟୁ ଜୀସୁ ଅ଼ଡ଼େ ସୀସୁୟାଁ ଗାଲିଲି ଆତାଲାତି ଗରାସିୟ ରା଼ଜିତା ଏଗାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜୀସୁ ଡଂଗଟି ରେ଼ପନିଏ ର଼ ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଟି ହ଼ଚାୱା଼ହାନା ଜୀସୁଇଁ ବେଟାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ଏ଼ୱାସି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ବାସା କିହିମାଚେସି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଜିକେଏ ଏ଼ୱାଣାଇଁ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସାଲି ଆ଼ଡିହିଲାଆତେରି; ");
INSERT INTO kxv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ହା଼ରେକା ଦେବା ହିକ୍‌ଣିୟାଁ ତଲେ ଦସାମାଚେରି, ସାମା ଏ଼ ହିକ୍‌ଣିୟାଁ ଡାପ୍‌ହାନା କୁଟୁକୁଟା କିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ଦସା ଇଟାଲି ଆମ୍ବାଆରାକି ଜିକେଏ ବା଼ଡ଼୍‌ୟୁ ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ଏ଼ୱାସି ଲା଼ଆଁୟାଁ ମାଦେନା ବାରେବେ଼ଲା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ଅ଼ଡ଼େ ହ଼ରୁତା ଡ଼ୟାନା କିର୍‌ଡ଼ି ମାଚେସି, ଇଞ୍ଜାଁ ୱାଲ୍‌କାତଲେ କତ୍‌ହା କଡିହିଁ ରା଼ଣାରାକା କିହା କଡିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ଏ଼ୱାସି ହେକଟିଏ ଜୀସୁଇଁ ମେସାନା ହଟି ହଟିହିଁ ୱା଼ହାନା ଏ଼ୱାଣି କଡାଣା ରିହାଁ ଜହରା କିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଅ଼ଡ଼େ କାଜା ଗିୟାଁତଲେ କିର୍‌ଡ଼ିହିଁ ଏଲେଇଚେସି, “ଏ଼ ବାଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଜୀସୁ, ନୀ ତଲେ ନାଙ୍ଗେ ଏ଼ନାୟି ମାଚେ ? ନିଙ୍ଗେ ମାହାପୂରୁ ଦ଼ରୁତଲେ ପାର୍‌ମାଣା କିହିମାଞ୍ଜାଇଁ, ନାଙ୍ଗେ କସ୍ତ ହିୟାଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏ଼ନାଆଁ ଇଞ୍ଜାଲି ହାଜିମାଚେସି, “ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁତି ଈୱାଣି ତା଼ଣାଟି ହ଼ଚାହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଜୀସୁ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀ ଦ଼ରୁ ଏ଼ନାୟି ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ ଦ଼ରୁ ‘ମାନ୍ଦା’ ଇଚିହିଁ ମା଼ମ୍ବୁ ହା଼ରେକା ଜା଼ଣାତମି ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ନିକିଁ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁଣି ଏ଼ ରା଼ଜିଟି ଅ଼ର ରା଼ଜିତା ପାଣ୍ତଅସି, ଏ଼ଦାଆଁତାକି ଏ଼ୱି ଜୀସୁଇଁ ହା଼ରେକା ବାତିମା଼ଲିତୁ । ");
INSERT INTO kxv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ଏମ୍ବାଆଁ ହ଼ରୁ ଦାରିତା ର଼ ମାନ୍ଦା ପାଜିୟାଁ ମେୟିଁମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ଅ଼ଡ଼େ ଏ଼ ବୂତୁୟାଁ ବାତିମା଼ଲିହିଁ ଏଲେଇଚୁ, “ମାଙ୍ଗେ ଏ଼ ପାଜିୟାଁ ମାନ୍ଦାତା ହ଼ଡାଲି ପାଣ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ହୁକୁମି ହୀହାଲିଏ, ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ଏ଼ୱାଣି ତା଼ଣାଟି ହ଼ଚାନା ପାଜିୟାଁ ମାନ୍ଦା ବିତ୍ରା ହ଼ଟୁ; ଏମ୍ବାଟିଏ ମାନ୍ଦା ପାଜିୟାଁ ତବେ ହଟାନା ଡାଗେ ମାଚି ସାମ୍‌ଦୁରିତା ମେଦାନା ହା଼ହାହାଚୁ, ବାରେ ରୀ ମା଼ଣା ପାଜିୟାଁ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ଏ଼ ପାଜିୟାଁ ମେଚିମାଚି ଗ଼ଡ଼୍‌କା ଗା଼ଡ଼ାତା ଅ଼ଡ଼େ ନା଼ସ୍‌କାଣାଁ ଏ଼ କାତା ୱେସ୍‌କା ହାଚେରି; ଏମ୍ବାଟିଏ ଲ଼କୁ ଏ଼ନାଆଁ ଆ଼ହାମାନେ ଇଞ୍ଜିଁ ସିନିକିହାଲି ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜୀସୁ ଡାଗେ ୱା଼ହାନା, ଏ଼ ବୂତୁ ଆଲ୍‌ଗା ମାଚାଣାଇଁ ଇଚିହିଁ ଆମ୍ବାଆରାକି ନ଼କେଏ ମାନ୍ଦା ବୂତୁୟାଁ ଆସାମାଚୁ, ଏ଼ୱାଣାଇଁ ହିମ୍ବରି ହୁଚାନା ନେହିଁ ମ଼ନତଲେ କୁଗାମାଚାଣି ମେସାନା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆମ୍ବାଆରି ମେସାମାଚେରି, ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି ଏ଼ନିକିଁ ନେହିଁଆ଼ତେସି, ଅ଼ଡ଼େ ପାଜିୟାଁ ଏ଼ନିକିଁ ନା଼ସା ଆ଼ତୁ ଏ଼ ବାରେ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ତାମି ହାନ୍ଦିଟି ହାଜାଲି ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଡା଼ୟୁ ଜୀସୁ ଡଂଗତା ହ଼ଚିମାଚାଟି ଆମିନି ଗାଟାଣାକି ବୂତୁ ଆଲ୍‌ଗାମାଚେ, ଏ଼ୱାସି ତାମିତଲେ ଡ଼ୟାଲି ତାକି ବାତିମା଼ଲିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ସାମା ଜୀସୁ ହେଲ ହୀଆନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ ଇଜ ନୀ ଲ଼କୁତା଼ଣା ହାଲାମୁ, ଇଞ୍ଜାଁ ପ୍ରବୁ ନିଙ୍ଗେତାକି ଏ଼ନି କାମା ଅ଼ଡ଼େ ନିଙ୍ଗେତାକି ଏମିନି କାର୍ମା କିହାମାଞ୍ଜାନେସି, ଏ଼ ବାରେ ଏ଼ୱାରାଇଁ ୱେହ୍‌ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ହାଜାନା, ଜୀସୁ ଏ଼ୱାଣାକି ଏ଼ନି କାମା କିହାମାଚେସି, ଏ଼ୱାସି ଦେକାପଲିତା ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି; ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜୀସୁ ଡଂଗଟି ଗା଼ଣ୍‌ଚାନା ଅ଼ରୱାକି ୱେଣ୍ତେ ୱା଼ତେସି, ମାନ୍ଦା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ରୁଣ୍ତା ଆ଼ତେରି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ସାମ୍‌ଦୁରି ଗାଟୁତା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ଏଚିବେ଼ଲା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାରି ବିତ୍ରାଟି ଜାୟିରସ ଦ଼ରୁଗାଟାସି ରଅସି ଜୀସୁଇଁ ମେସାନା ଏ଼ୱାଣି କଡାଣା ରୀତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ଇଞ୍ଜାଁ ହା଼ରେକା ବାତିମା଼ଲିହିଁ ଏଲେଇଚେସି, “ନା଼ ମା଼ଙ୍ଗା ହା଼ନିହ଼ଗେ ଆ଼ହାମାନେ; ଏ଼ଦି ଏ଼ନିକିଁ ନେହିଁ ଆ଼ହାନା ନୀଡିନେ, ଏ଼ଦାଆଁତାକି ନୀନୁ ୱା଼ହାନା ଏ଼ଦାନି ଲାକ କେୟୁ ଇଟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣିତଲେ ହାଚେସି, ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣିତଲେ ହାଜାଲି ମା଼ଟ୍‌ହେରି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ମୁହେଁ ମୁହେଁ ୱିସ୍‌ପି ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ଏଚିବେ଼ଲାତା ର଼ ଇୟା ବା଼ର ବାର୍ସା ପାତେକା ନେତେରି ୱା଼ଙ୍ଗିନି ର଼ଗତା ନେତେରି ଡୂଙ୍ଗାଆନା ନେହିଁ ଆ଼ହି ହିଲାଆତେ, ");
INSERT INTO kxv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଇଞ୍ଜାଁ ଅସଗୂରୁ ତା଼ଣା ହାଜାନା ଜିକେଏ ହା଼ରେକା ଟାକାୟାଁ କାର୍ଚୁ କିହାମାଚେ, ଅ଼ଡ଼େ ଜିକେଏ ନେହିଁ ଆ଼ହାହିଲାଆତେ, ସାମା ହା଼ରେକା କସ୍ତ ବେଟାଆ଼ହି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଏ଼ଦି ଜୀସୁତି କାତା ୱେଞ୍ଜାନା ଲ଼କୁ ମାନ୍ଦାତା ୱା଼ହାନା ଡା଼ୟୁ ୱାକିଟି ଏ଼ୱାଣି ହିମ୍ବରି ଡୀଗିତେ; ");
INSERT INTO kxv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ଇଚିହିଁ ଏ଼ଦି ଏଲେ ଇଞ୍ଜିମାଚେ, “ଏ଼ୱାଣି ହିମ୍ବରି ଡୀଗିତିହିଁ ନେହିଁ ଆ଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ଏ଼ ଦେବୁଣିଏ ଏ଼ଦାଣି ନେତେରି ବ଼ନାୟି ଡୂଙ୍ଗିତେ, ଇଞ୍ଜାଁ ଏ଼ଦି ର଼ଗଟି ନେହିଁ ଆ଼ହାମାନେ ଏ଼ଦାଆଁ ତାନି ଆଙ୍ଗାତା ପୁଞ୍ଜା କଡିତେ । ");
INSERT INTO kxv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଦେବୁଣିଏ ଜୀସୁ ତାନି ଆଙ୍ଗାଟି ବା଼ଡ଼୍‌ୟୁ ହାଚାଣି ହିୟାଁତା ପୁଞ୍ଜାନା, ଲ଼କୁ ମାନ୍ଦାତା ୱେଣ୍ତେ ସିନିକିହାନା ଏଲେଇଚେସି, “ଏମ୍ବାଆୟି ନା଼ ହିମ୍ବରି ଡୀଗାତେ ?” ");
INSERT INTO kxv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ଏମ୍ବାଟିଏ ତାନି ସୀସୁୟାଁ ଏଲେଇଚେରି, “ନୀନୁତ ମେସିମାଞ୍ଜି ଲ଼କୁ ଏ଼ନିକିଁ ନୀ ମୁହେଁ ଆ଼ହିମାନେରି, ଅ଼ଡ଼େ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ଆମ୍ବାଆୟି ନାଙ୍ଗେ ଡୀଗାତେ ?” ");
INSERT INTO kxv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ସାମା ଏମ୍ବାଆୟି ତାଙ୍ଗେ ଡୀଗିତେ ଏ଼ଦାଆଁ ମେସାଲି ଜୀସୁ ସା଼ରିସୁଟୁ ସିନିକିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ଏମ୍ବାଟିଏ ଏ଼ ଇୟା ୱା଼ହାନା ତାଙ୍ଗେତାକି ଏ଼ନାୟି ଆ଼ହାମାନେ ଏ଼ଦାଆଁ ପୁଞ୍ଜା ଆଜିତାକି ତୀର୍‌ଗିହିଁ ୱା଼ହାଁ ତାନି କଡାଣା ରିହାନା ବାରେ ସାତା କାତା ଏ଼ୱାଣାଇଁ ୱେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ ଇୟାନି ଏଲେଇଚେସି, “ଆଲ ମା଼ଙ୍ଗା ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେ; ହିତ୍‌ଡ଼ି ତଲେ ହାଲାମୁ ଇଞ୍ଜାଁ ନୀ ର଼ଗଟି ନେହିଁଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଜୀସୁ ଈ କାତା ୱେସିମାଚାଟି, ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାଣା ଇଜଟି ରଅସି ୱା଼ହାନା ଏଲେଇଚେସି, “ନୀ ମା଼ଙ୍ଗା ହା଼ତେୟିଏ ଗୂରୁଇଁ ଅ଼ଡ଼େ ଏ଼ନାଆଁତାକି କସ୍ତ ହୀହିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ସାମା ଜୀସୁ ଏ଼ କାତା ୱେଞ୍ଜାନା ୱେନାଆତିଲେହେଁ ଆ଼ହାନା ଜାୟିରସଇଁ ଏଲେଇଚେସି, “ଆଜାଆନି ସାମା ନାମାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ଅ଼ଡ଼େ ଏ଼ୱାସି ପିତର, ଜାକୁବ, ଅ଼ଡ଼େ ତାନି ତାୟି ଜହନ ପିସ୍‌ପେ ଆମ୍ବାଆରାଇଁ ତାନିତଲେ ଅ଼ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ଏ଼ୱାରି ଜାୟିରସ ଇଜ ଏଜାଲିଏ, ଏମ୍ବାଆଁ ହା଼ରେକା କା଼ଲ୍‌ୱି ଆ଼ହିଁ ଡ଼ୀହିମାନାଣି ମେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଇଞ୍ଜାଁ ବିତ୍ରା ହାଜାନା ଏ଼ୱାସିକାଣି ଏଲେଇଚେସି, “ଏ଼ନାଆଁତାକି କା଼ଲ୍‌ୱି ଆ଼ହିଁ ଡ଼ୀହି ମାଞ୍ଜେରି, ଈ ପ଼ଦା ହା଼ହାହିଲେଏ ସାମା ଇଦା କିହାମାନେ” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ କାକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଲାଜା କିହାନା କାକ୍‌ହେରି, ସାମା ଏ଼ୱାସି ବାରେତି ପାଙ୍ଗାତା ପାଣ୍ତାନା ପ଼ଦାନି ଇୟା ଆ଼ବା ଅ଼ଡ଼େ ତାନି ତୀନି ଜା଼ଣା ସୀସୁୟାଁ ତଲେ ଏ଼ ପ଼ଦା ମାଚି ତା଼ଣା ହାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଇଞ୍ଜାଁ ଏ଼ ପ଼ଦାନି କେୟୁ ଆସାନା ଏ଼ଦାନି ଏଲେଇଚେସି, “ଟଲିତା କୁମ୍‌” ଇଚିହିଁ “ଆଲ ମା଼ଙ୍ଗା ନା଼ନୁ ନିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ ନିଙ୍ଗାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ଏ଼ ଦେବୁଣିଏ ପ଼ଦା ନିଙ୍ଗାନା ତା଼କିତେ (ଇଚିହିଁ ଏ଼ଦି ବା଼ର ବାର୍ସା ଆ଼ହାମାଚେ) ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହା଼ରେକା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ଇଞ୍ଜାଁ ଈ କାତା ଏ଼ନିକିଁ ଆମ୍ବାଆରି ପୁନଅରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଜାଣ୍ତେ ହୁକୁମି ହୀତେସି, ଇଞ୍ଜାଁ “ପ଼ଦାନାକି ଏ଼ନାଆଁ ତିଞ୍ଜାଲି ହୀଦୁ” ଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜୀସୁ ଏ଼ ଟା଼ୟୁ ପିସାନା ତା଼ନୁ ପାଡାଆ଼ତି ନା଼ୟୁଁତା ହାଚେସି ଇଞ୍ଜାଁ ତାନି ସୀସୁୟାଁ ତାନି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଜ଼ମିନି ଦିନା ୱା଼ହାଲିଏ, ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି; ଇଞ୍ଜାଁ ହା଼ରେକା ତାନି କାତା ୱେଞ୍ଜାନା କାବା ଆ଼ହାଁ ଏଲେଇଚେରି, “ଈୱାଣାକି ଈ ବାରେ ଏମ୍ବିଟି ଆ଼ତେ ? ଈୱାସି ଇଲେତି ବୁଦି ଏ଼ନିକିଁ ପୁଚେସି ? ଇଞ୍ଜାଁ ଇଲେତି କାବାଆ଼ନି କାମା ଏ଼ନି ବା଼ଡ଼୍‌ୟୁ ତଲେ କିହିମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଈୱାସି ଏ଼ ବାଡିୟାତି ମୀର୍‌ଏସି ଆ଼ଏକି ? ଈୱାସି ମରିୟମନି ମୀର୍‌ଏସି ଇଞ୍ଜାଁ ଜାକୁବ, ଜସି, ଜୀହୁଦା ଇଞ୍ଜାଁ ସିମନତି ତାୟି ଆ଼ଏକି ? ଇଞ୍ଜାଁ ତାମି ତାଙ୍ଗିସ୍କା ଇମ୍ବାଆଁ ମା଼ ତଲେ ହିଲାଉ କି ? ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଅ଼ପାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଏଟ୍‌କା ଲ଼କୁ ତା଼ଣାଟି ମା଼ନି ବେଟାଆ଼ନେରି ସାମା ତାମି ନା଼ୟୁଁତି ଲ଼କୁ ଇଞ୍ଜାଁ ତାମି ଇଲୁ କୁଟମିତି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ମା଼ନି କିଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଇଞ୍ଜାଁ ଏଚରଜା଼ଣା ର଼ଗ ଗାଟାରାଇଁ କେୟୁ ଇଟାନା ନେହିଁ କିନାଣି ପିସ୍‌ପେ ଏ଼ ଟା଼ୟୁତା ଏ଼ନି ବା଼ଡ଼୍‌ୟୁତି କାମା କିହାଲି ଆ଼ଡାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଇଞ୍ଜାଁ ଏ଼ୱାରି ନାମାଆତାକି ଜୀସୁ ହା଼ରେକା କାବା ଆ଼ତେସି ଏମ୍ବାଟି ବାରେ ନା଼ସ୍‌କାଣାଁ ହାଜାନା ଜା଼ପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ଡା଼ୟୁ ଏ଼ୱାସି ନା଼ସ୍‌କା ନା଼ସ୍‌କାଣାଁ ରେ଼ଜି ରେ଼ଜିହିଁ ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, ଏମ୍ବାଟିଏ ବା଼ରଜା଼ଣାତି ଡାଗେ ହା଼ଟାନା ଏ଼ୱାରାଇଁ ରିଆରି ଲାକା କିହାନା ପାଣ୍ତାଲି ମା଼ଟ୍‌ହେସି ଇଞ୍ଜାଁ ଲାଗେଏ ପ଼ଲେଏତି ଜୀୱୁୟାଁ ଲାକ ଏ଼ୱାରାକି ଅଦିକାରା ହୀତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ଅ଼ଡ଼େ ହାଜାଲିତାକି ବାଡ଼୍‌ଗା ପିସ୍‌ପେ, ଲ଼ହଡ଼ି କି ମ଼ଣା କି ଅଟଡ଼ିତା ଟାକାୟାଁ ଅ଼ଆଦୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ସାମା ଏ଼ୱାରାଇଁ କଡାତା ସେପୁୟାଁ ତୁର୍‌ହାଲି ଏଲେଇଚେସି, ଇଞ୍ଜାଁ ରୀ ସକାୟାଁ ତୁର୍‌ହାଲି କା଼ହି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମିଙ୍ଗ ଆମିନି ଇଲୁତା ହା଼ଟାନେରି, ଏମ୍ବାଟି ୱେଣ୍ତା ୱା଼ଆ ପାତେକା ଏମ୍ବାଆଁ ଡ଼ୟାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ସାମା ଆମିନି ଟା଼ୟୁତି ଲ଼କୁ ମିଙ୍ଗ ଆବଅରି, କି ମୀ କାତା ୱେନଅରି, ଏମ୍ବାଟି ୱେଣ୍ତା ୱା଼ନାଟି ଏ଼ୱାରି ନ଼କିତା ସା଼କି ହୀହାଲି ତାକି ମୀ କଡାତି ଦୂଡ଼ି ହାଣ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ରେ଼ଜି ରେ଼ଜିହିଁ ପା଼ପୁ ପିସାନା ମ଼ନ ୱେଟ୍‌ନି କାତା ୱେ଼କ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଇଞ୍ଜାଁ ହା଼ରେକା ବୂତୁଣି ପିସ୍‌ପି କିତେରି, ଇଞ୍ଜାଁ ହା଼ରେକା ର଼ଗ ଗାଟାରାଇଁ ନିୟୁଁ ରୁବାନା ନେହିଁ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଏମ୍ବାଟିଏ ଜୀସୁ ଦ଼ରୁ ସା଼ରି ୱାକି ୱେ଼ଙ୍ଗା ହାଜାଲିଏ ହେରଦ ରାଜା ଏ଼ୱାଣି କାତା ୱେଚେସି, ଇଞ୍ଜାଁ ଲ଼କୁ ଏଲେଇଞ୍ଜିମାଚେରି, “ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ହା଼ତାରି ତା଼ଣାଟି ନିଙ୍ଗାମାନେସି, ଏ଼ଦାଆଁତାକି ଈ ବାରେ କାବାଆ଼ନି ବା଼ଡ଼୍‌ୟୁତି କାମା ଏ଼ୱାଣି ତା଼ଣା ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ସାମା ଏଟ୍‌କାତାରି ଏଲେଇଞ୍ଜିମାଚେରି, “ଈୱାସି ଏଲିୟ ।” ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏଲେଇଞ୍ଜିମାଚେରି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଲେହେଁ ଈୱାସି ଜିକେଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ସାମା ହେରଦ ଈଦାଆଁ ୱେଞ୍ଜାନା ଏଲେଇଚେସି, “ଆମିନି ଜହନତି ତା଼ର୍ୟୁଁ ନା଼ନୁ ଦା଼ପି କିହାମାଇଁ, ଏ଼ୱାସି ନିଙ୍ଗାମାନେସି !” ");
INSERT INTO kxv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ଇଚିହିଁ ହେରଦ ତାନି ତାୟି ପିଲିପ ଡକ୍ରି ହେରଦିୟାନି ବୀହା ଆ଼ହାମାଚାକି, ଏ଼ଦାନି ତାକି ତା଼ନୁ ଲ଼କୁଣି ପାଣ୍ତାନା ଜହନଇଁ ଦସ୍‌ପା ତାଚାନା କା଼ୟିଦିତା ଇଟାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଇଚିହିଁ ଜହନ ହେରଦଇଁ ଏଲେଇଞ୍ଜାମାଚେସି, “ନୀ ତାୟି ଡକ୍ରିନି ଇଟିନାୟି ନୀ ମେ଼ରା ହିଲାଆତେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଏମ୍ବାଟିଏ ହେରଦିୟା କାର୍‌ବି ଆ଼ହାନା ଜହନଇଁ ପା଼ୟାଲି ମ଼ନ କିହିମାଚେ ସାମା ଏ଼ଦି ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡିହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଇଚିହିଁ ହେରଦ ଜହନଇଁ ର଼ ଦାର୍ମୁଗାଟାସି ଅ଼ଡ଼େ ସୁଦୁଗାଟାସି ଇଞ୍ଜିଁ ଆଜିମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ଗେଲ୍‌ପାଲି ଅଣ୍‌ପିମାଚେସି, ଏ଼ୱାଣି କାତା ୱେଞ୍ଜାନା ଆଜିତିହିଁ ଜିକେଏ ଏ଼ୱାଣି କାତା ୱେଞ୍ଜାଲି ମ଼ନ କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ଡା଼ୟୁ ହେରଦିୟାକି ର଼ ପାରୁ ମେ଼ଡ଼ାଆ଼ତେ, ହେରଦ ତାନି ଜାର୍ନା ଦିନାତା କାଜା କାଜା ମନ୍ତ୍ରିୟାଁଣି ଇଞ୍ଜାଁ ଗାଲିଲିତି କାଜା କାଜାରାଇଁ ଲା଼ଆଁ ବେ଼ଲାତା ର଼ ବ଼ଜିତା ହା଼ଟିତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ଇଞ୍ଜାଁ ହେରଦିୟାନି ମା଼ଙ୍ଗା ବିତ୍ରା ହାଜାନା ଏ଼ନ୍ଦାହାଁ ହେରଦ ଇଞ୍ଜାଁ ତାନିତଲେ ବ଼ଜିତା କୁଗାମାଚି ଲ଼କୁଣି ରା଼ହାଁ କିୱିକିତେ, ଏମ୍ବାଟିଏ ରାଜା ଏ଼ ପ଼ଦାନି ଏଲେଇଚେସି, “ଏ଼ନାଆଁ ମ଼ନ କିହିମାଞ୍ଜି ରୀସ୍ତାମୁ ନା଼ନୁ ଏ଼ଦାଆଁ ନିଙ୍ଗେ ହିୟାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ଇଞ୍ଜାଁ ଏ଼ୱାସି ପ଼ଦା ନ଼କିତା ପାର୍‌ମାଣା କିତେସି, “ନୀନୁ ନାଙ୍ଗେ ଏ଼ନାଆଁ ରୀସ୍ତାଦି, ରା଼ଜିତି ଆଦା ଜିକେଏ ନା଼ନୁ ନିଙ୍ଗେ ହିୟାଇଁ !” ");
INSERT INTO kxv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ଏମ୍ବାଟିଏ ଏ଼ ପ଼ଦା ହାଜାନା ତାମି ଇୟାନି ୱେଚେ, “ନା଼ନୁ ଏ଼ନାଆଁ ରୀହ୍‌ଇଁ ?” ଏମ୍ବାଟିଏ ଏ଼ଦି ଏଲେଇଚେ, “ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି ତା଼ର୍ୟୁଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ଏ଼ ଦେବୁଣିଏ ରାଜା ତା଼ଣା ତବେ ୱା଼ହାନା ଏଲେଇଞ୍ଜି ରୀସ୍ତେ, “ନାଙ୍ଗେ ନୀନୁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି ତା଼ର୍ୟୁଁ ର଼ ସାଡ଼୍‌ୱାତା ନୀଏଁ ନାଙ୍ଗେ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଏମ୍ବାଟିଏ ରାଜା ହା଼ରେକା ଦୁକୁ ଆ଼ତିହିଁ ଜିକେଏ, ତା଼ନୁ କିତି ପାର୍‌ମାଣା ଅ଼ଡ଼େ ବ଼ଜିତା କୁଗାମାଚାରି ତାକି ଆ଼ଏ ଇଞ୍ଜାଲି ଆ଼ଡାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ଏ଼ଦାଆଁତାକି ରାଜା ଦେବୁଣିଏ ର଼ କ଼ହ୍‌ଏଁଣାଇଁ ପାଣ୍ତାନା ତାନି ତା଼ର୍ୟୁଁ ତାଚାଲି ହୁକୁମି ହୀତେସି, ଏମ୍ବାଟିଏ ଏ଼ୱାସି ହାଜାନା କା଼ୟିଦି ଇଲୁତା ତାନି ତା଼ର୍ୟୁଁ ଦା଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଅ଼ଡ଼େ ଏ଼ଦାଆଁ ର଼ ସାଡ଼୍‌ୱାତା ତାଚାନା ପ଼ଦାନାକି ହୀତେସି, ଇଞ୍ଜାଁ ପ଼ଦା ଏ଼ଦାଆଁ ଅ଼ହାନା ତାମି ଇୟାନାକି ହୀତେ । ");
INSERT INTO kxv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଇଞ୍ଜାଁ ଜହନତି ସୀସୁୟାଁ ଏ଼ କାତା ୱେଞ୍ଜାନା ୱା଼ତେରି, ଇଞ୍ଜାଁ ତାନି ମାଡ଼୍‌ହାତି ଅ଼ହାନା ମାଡ଼୍‌ହା ଇଟିନି ଟା଼ୟୁତା ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ଡା଼ୟୁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚାରି ଜୀସୁ ତା଼ଣା ୱା଼ତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଚେରି, ଇଞ୍ଜାଁ ଏ଼ନା ଏ଼ନାଆଁ ଜା଼ପ୍‌ହା ମାଚେରି, ଏ଼ ବାରେ ଏ଼ୱାଣାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମା଼ର ଇମ୍ବାଟି ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାନ, ଏମ୍ବାଆଁ ମୀରୁ ଗା଼ଡ଼େକା ଜ଼ମାଦୁ ।” ଇଚିହିଁ ହା଼ରେକା ଲ଼କୁ ହାଜି ୱା଼ହି ଆ଼ହିମାଚାକି ଏ଼ୱାରାକି ତିଞ୍ଜାଲି ଜିକେଏ ମ୍ଣିଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏଟ୍‌କା ଆ଼ହାନା ର଼ ଡଂଗତା ହ଼ଚାନା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ସାମା ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାରି ହ଼ଚା ହାଚାଣି ମେସ୍ତେରି ଅ଼ଡ଼େ ପୁଚେରି, ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ ଗା଼ଡ଼ାୟାଁଟି ତା଼କିହିଁ ହାଜାନା ଏ଼ୱାରି ନ଼କିତା ଏଗାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଏ଼ୱାସି ଡଂଗଟି ରେ଼ଚାନା ହା଼ରେକା ଲ଼କୁଣି ମେସାନା ଏ଼ୱାରାଇଁ କାର୍ମା ଆ଼ତେସି, ଇଚିହିଁ ଏ଼ୱାରି ଗ଼ଡ଼ୁ ହିଲାଆ ମେ଼ଣ୍ତାୟାଁ ଲେହେଁ ମାଚେରି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ହା଼ରେକା କାତା ଜା଼ପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଗାଡି ୱେଡ଼ାଆୟାଲିଏ ତାନି ସୀସୁୟାଁ ତାନି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଈ ଟା଼ୟୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁ ଇଞ୍ଜାଁ ଆନ୍ଦେରି ଜିକେଏ ଆ଼ହିମାନେ; ");
INSERT INTO kxv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ଲ଼କୁ ଏ଼ନିକିଁ ସା଼ରିୱାକି ମାନି ୱାଲ୍‌ହାୱା଼ଡ଼ି ଅ଼ଡ଼େ ଗା଼ଡ଼ାତା ହାଜାନା ତାମ୍‌ଙ୍ଗେ ତାକି ତିଞ୍ଜାଲି ରା଼ନ୍ଦା କଡାପେରିୱା, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରାଇଁ ହେଲ ହୀହାନା ପାଣ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ସାମା ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ୱାରାକି ତିଞ୍ଜାଲି ହୀଦୁ ।” ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ର ରୀ ୱାଞ୍ଜା ୱେଣ୍ତି ଟାକାୟାଁତି ରୂଟି ତାଚାନା ଈୱାରାକି ତିଞ୍ଜାଲି ହୀନାୟି କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ତା଼ଣା ଏଚରଗଟା ରୂଟି ମାନୁ ? ହାଜାନା ସିନିକିଦୁ ।” ଏ଼ୱାରି ୱେଞ୍ଜା ୱା଼ହାନା ଜୀସୁଇଁ ଏଲେଇଚେରି, “ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କା ମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ଇଞ୍ଜାଁ ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, ବାରେ ଲ଼କୁଇଁ ଗଚି ଗଚି କିହିଁ କ୍ଡଗି ଜା଼ଡ଼ା ଲାକ କୁଗିକିହାଲି ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ଏଚେଟିଏ ଏ଼ୱାରି ପା଼ସାକ଼ଡ଼ି ଜା଼ଣା ରୀ କ଼ଡ଼ି ଦସ ଜା଼ଣା ଲାକା ମାନ୍ଦା ମାନ୍ଦା ଆ଼ହିଁ କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ଡା଼ୟୁ ଜୀସୁ ଏ଼ ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କା ଅ଼ହାନା ଲାକପୂରୁ ୱାକି ସିନିକିହାଁ ମାହାପୂରୁଇଁ ଜହରା କିତେସି, ଅ଼ଡ଼େ ରୂଟି ଡ଼ିକ୍‌ହାନା ଲ଼କୁତାକି ବା଼ଟି କିହା ହୀହାଲି ତାନି ସୀସୁୟାଁକି ହୀତେସି, ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କା ଜିକେଏ ଏଲେକିହିଁଏ ବା଼ଗା କିହାନା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ଏମ୍ବାଆଁ ବାରେଜା଼ଣା ତିଞ୍ଜାନା ପାଞ୍ଜିତେରି, ");
INSERT INTO kxv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଇଞ୍ଜାଁ ଏ଼ୱାରି ହା଼ରାମାଚି ରୂଟି ଅ଼ଡ଼େ ମୀଣ୍‌କା କୂଡ଼ି କିହାନା ବା଼ରଗଟା ଡାଲିତା ନେଞ୍ଜିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ରୂଟି ତିଚି ଲ଼କୁ ପା଼ସାମା଼ଣା ୱାର୍‌ଇ ଆ଼ବାୟାଁ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସି ତାନି ସୀସୁୟାଁଣି ଡଂଗତା ହ଼ଚାନା ଆତାଲାୱାକି ମାନି ବେତ୍‌ସାୟିଦା ଗା଼ଡ଼ାତା ହାଜାଲି ତାନି ନ଼କେଏ ପାଣ୍ତିତେସି, ଏମ୍ବାଟିଏ ବାରେ ଲ଼କୁଣି ହାଜାଲିତାକି ହେଲ ହୀହାଁ ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଏ଼ୱାରି ତା଼ଣାଟି ହେଲ ଅ଼ତି ଡା଼ୟୁ ଏ଼ୱାସି ପ୍ରା଼ତାନା କିହାଲି ହ଼ରୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ଡଂଗ ସାମ୍‌ଦୁରି ମାଦିଏ ମାଚେ, ଇଞ୍ଜାଁ ଜୀସୁ ସାମ୍‌ଦୁରି ଗାଟୁତା ରଅସିଏ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଏମ୍ବାଟିଏ ହା଼ରେକା ଗା଼ଲି ଏ଼ୱାରି ୱାକି ୱେ଼ଚିମାଚାକି ଡଂଗ ତାକି କିହାଲି କସ୍ତ ଆ଼ହିମାଚାଣି ମେସାନା ଏ଼ୱାସି ୱେ଼ୟା ନେ଼କେରି ସାମ୍‌ଦୁରି ଏ଼ୟୁ ଲାକ ତା଼କିହିଁ ଏ଼ୱାରି ଡାଗେ ୱା଼ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଡାଗେଟି ଆଗାଡ଼ା ହାଜାଲି ଅଣ୍‌ପାମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ସାମ୍‌ଦୁରି ଲାକ ତା଼କି ମାନାଣି ମେସାନା ବୂତୁ ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା କା଼ଲ୍‌ୱି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଇଚିହିଁ ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ ମେସାନା ଆଜାହାଜା ମାଚେରି । ସାମା ଜୀସୁ ଦେବୁଣିଏ ଏ଼ୱାରିତଲେ କାତା ଆ଼ହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ସା଼ସା ଆହ୍‌ଦୁ ନା଼ନୁଏ ଏ଼ୱାତେଏଁ, ଆଜାଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରିତା଼ଣା ହାଜାନା ଡଂଗତା କୁଗିତେସି, ଇଞ୍ଜାଁ ଗା଼ଲି ଡୂଙ୍ଗିତେ, ଏମ୍ବାଟିଏ ଏ଼ୱାରି ମ଼ନ ମ଼ନତା ହା଼ରେକା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ଇଚିହିଁ ଏ଼ୱାରି ରୂଟିୟାଁ କାତା ପୁଣ୍‌ମ୍ବୁଏ ପୁଞ୍ଜାହିଲାଆତେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ହିୟାଁ ଆ଼ଟ୍‌ୱା ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଏ଼ୱାରି ସାମ୍‌ଦୁରି ଗା଼ଣ୍‌ଚାନା ଗେନେସର ରା଼ଜିତା ଏଜାନା କାଡା ଗାଟୁତା ଡଂଗତି ଦସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଅ଼ଡ଼େ ଏ଼ୱାରି ଡଂଗଟି ରେ଼ଚାଲିଏ, ଦେବୁଣିଏ ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାନା, ");
INSERT INTO kxv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଏ଼ ରା଼ଜିତି ସା଼ରିୱାକି ହାଚେରି, ଏ଼ୱାରି ଆମିନି ଟା଼ୟୁତା ମାନେରି ଇଞ୍ଜିଁ ୱେଚେରି, ଅ଼ଡ଼େ ଜୀସୁ ମାନି ଟା଼ୟୁତା ର଼ଗ ଗାଟାରାଇଁ କାଟେଲିତା ଡେ଼କା ତାଚାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଆମିନି ନା଼ସ୍‌କା, ଅ଼ଡ଼େ ଗା଼ଡ଼ାତା ହାଚେସି, ଲ଼କୁ ଏ଼ ବାରେ ଟା଼ସ୍କାତି ହା଼ଟା ବାଜାରାଟି ର଼ଗ ଗାଟାରାଇଁ ଏ଼ୱାଣି ନ଼କିତା ଏ଼ୱାରାଇଁ ଇଟିତେରି, ଏ଼ୱାରି ଏ଼ନିକିଁ ଏ଼ୱାଣି ହିମ୍ବରି କୁଙ୍ଗୁ ଡୀଗିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାଣାଇଁ ବାତିମା଼ଲିତେରି; ଇଞ୍ଜାଁ ଏଚେକା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଡୀଗିତେରି ଏ଼ୱାରି ବାରେ ନେହିଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ଡା଼ୟୁ ପାରୁସିୟାଁ ଅ଼ଡ଼େ ଜିରୁସାଲମଟି ୱା଼ହାମାନି ଏଚରଜା଼ଣା ମେ଼ରାପୁନାରି ଜୀସୁ ତା଼ଣା ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ଏ଼ୱାରି ସୀସୁୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣାତି କେସ୍କା ନର୍‌ଆନା ତିଞ୍ଜି ମାଚାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିୟାଁ ଅ଼ଡ଼େ ବାରେ ଜୀହୁଦି ଲ଼କୁ ଆକୁ ଆ଼ବାୟାଁ ଇଟାମାନି ମେ଼ରାତି ମା଼ନୱି ଆ଼ହାନା ନେହିଁକିଁ କେୟୁ ନର୍‌ଆସାରେ ତିଞ୍ଜି ହିଲାଆତେରି, ");
INSERT INTO kxv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଇଞ୍ଜାଁ ହା଼ଟା ବାଜାରାଟି ୱା଼ହାନା ତାମି ଲାକ ଏ଼ୟୁ ଡ଼ାଞ୍ଜା କଡାଆନା ତିଞ୍ଜି ହିଲାଆତେରି; ଅ଼ଡ଼େ ଗିନା ମୁତା ଇଞ୍ଜାଁ ପିତାଡ଼ା ଡ଼଼କାୟାଁ, ପା଼ସ୍‌ପନି ନର୍‌ନାୟି, ଇଲେତି ହା଼ରେକା ମେ଼ରା ମା଼ନୱି ଆ଼ହାଲି ହୁକୁମି ବେଟା ଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ଏ଼ଦାଆଁତାକି ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଜୀସୁଇଁ ୱେଚେରି, “ନୀ ସୀସୁୟାଁ ତଲିତି ଆକୁ ଆ଼ବାୟାଁ ମେ଼ରା ତଲେ ତା଼କାଆନା ଏ଼ନାଆଁତାକି କେସ୍କା ନର୍‌ଆନା ତିନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ କୁଟୁ ଗାଟାତେରି, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ନେହିଁକିଁ ଈ କାତା ୱେସାମାନେସି, ଏ଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ; ଈ କୂଡ଼ାତାରି ୱାର୍‌ଇ ଗୂତି ତଲେ ନାଙ୍ଗେ ସେ଼ବା କିୟାନେରି, ସାମା ଏ଼ୱାରି ହିୟାଁ ନା଼ ତା଼ଣାଟିଏ ହା଼ରେକା ହେକ ଡ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ଏ଼ୱାରି ମାଣ୍‌ସିୟାଁ କେ଼ପିତି ମେ଼ରାତି ଦାର୍ମୁତି ନେହିଁ କାତା ଇଞ୍ଜିଁ ଜା଼ପ୍‌ହାନା, ଉଜେଏ ନା଼ ସେ଼ବା କିୟାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ମୀରୁ ମାହାପୂରୁତି ହୁକୁମି ପିସାନା ମାଣ୍‌ସିୟାଁ ମେ଼ରାତି ଆସାମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁତି ହୁକୁମି ପିସାନା ମୀ ଜା଼ପ୍‌ହାମାଞ୍ଜନାଣି ଆସାଲି ତାକି ମୀରୁ ହୁକୁମି ମା଼ନି କିହିହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ଇଚିହିଁ ମ଼ସା ଏଲେଇଞ୍ଜା ମାନେସି, ‘ତାଲି ତାଞ୍ଜିଇଁ ଜୀୱୁନ଼ଦୁ, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ତାଲି କି ତାଞ୍ଜିଇଁ ବା଼କା ଇଟିନେସି, ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ ବେଟା ଆ଼ନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମୀରୁ ଜା଼ପ୍‌ହି ମାଞ୍ଜେରି, ‘ଆମ୍ବାଆସି ତାଲି କି ତାଞ୍ଜିଇଁ ଏଲେଇନେସି, ନା଼ ତା଼ଣାଟି ଏ଼ନାଆଁ ହିୟାତିହିଁ ନିଙ୍ଗେ ନେହେଁ ଆ଼ତେମା, ଏ଼ଦି କର୍ବାନ ଇଚିହିଁ ମାହାପୂରୁ ତାକି ହେର୍‌ପି ଆ଼ହାମାନାୟି । ");
INSERT INTO kxv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ଇଞ୍ଜାଁ ମୀରୁ ଏଲେକିହିଁ ତାମି ଇୟା କି ଆ଼ବାଇଁ ଏ଼ନି ସା଼ୟେମି କିହାଲି ହୀହି ହିଲଅତେରି; ");
INSERT INTO kxv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଏଲେକିହିଁଏ ମୀରୁ ମୀ ତା଼ଣା ମାନି ମେ଼ରା ତଲେ ମାହାପୂରୁତି ବ଼ଲୁ ଉଜେଏ କିହିମାଞ୍ଜେରି, ଇଞ୍ଜାଁ ଏଲେକିହିଁ ହା଼ରେକା କାମା କିହିମାଞ୍ଜେରି ।’” ");
INSERT INTO kxv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଲ଼କୁଣି ଡାଗେ ହା଼ଟାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ବାରେ ନା଼ କାତା ୱେଞ୍ଜୁ ଅ଼ଡ଼େ ତେଲ୍‌ହାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ମାଣ୍‌ସିତି ପାଙ୍ଗାତା ଇଲେତି ଏ଼ନାୟି ହିଲେଏ, ଏ଼ଦି ମାଣ୍‌ସି ବିତ୍ରା ହ଼ଡାନା ଏ଼ୱାଣାଇଁ ଲାଗେଏ କିହାଲି ଆ଼ଡିନେ, ସାମା ଏ଼ନା ଏ଼ନାୟି ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚିମାନେ, ଏ଼ ବାରେ ଏ଼ୱାଣାଇଁ ଲାଗେଏ କିହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ୱେଞ୍ଜାଲି କୀର୍କା ମାନାସି ୱେଣ୍‌ମ୍ବାସି । ");
INSERT INTO kxv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଅ଼ଡ଼େ ଏ଼ୱାସି ଲ଼କୁ ତା଼ଣାଟି ଇଲୁ ବିତ୍ରା ୱା଼ହାଲିଏ ତାନି ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତି ଅର୍ତ ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଜିକେଏ ଏଲେକିହିଁଏ ପୁନାଆ ଗାଟାତେରି ? ଏ଼ନାୟି ପାଙ୍ଗାଟି ମାଣ୍‌ସି ବିତ୍ରା ହ଼ଟିହିଁ ଏ଼ଦି ଏ଼ୱାଣାଇଁ ଲାଗେଏ କିହାଲି ଆ଼ଡେଏ, ");
INSERT INTO kxv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ଇଚିହିଁ ଏ଼ଦି ଏ଼ୱାଣି ହିୟାଁତା ହ଼ଡ଼୍‌ଆନା ବାଣ୍ତିତା ହ଼ଡ଼୍‌ନେ ଇଞ୍ଜାଁ ବାଣ୍ତିହାନିଲେହେଁ ହ଼ଚାହାନେ ଇଲେଆ଼ହିଁ ବାରେ ରା଼ନ୍ଦା ଅଟ୍‌ହି ଆ଼ହିମାନେ, ଈଦାଆଁ ପୁଞ୍ଜି ହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ନାୟି ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚିମାନେ ଏ଼ଦି ଏ଼ୱାଣାଇଁ ଲାଗେଏ କିହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଇଚିହିଁ ମାଣ୍‌ସି ହିୟାଁ ବିତ୍ରାଟି ଲାଗେଏତି ଅଣ୍‌ପୁ ହ଼ନେ, ଦା଼ରି କିୟାଲି, ସ଼ରୁ କିୟାଲି, ଲ଼କୁଣି ପା଼ୟିନାୟି, ");
INSERT INTO kxv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଜୂପ୍‌କା, ଲାଗେଏ ପ଼ଲେଏ କାମା, ନା଼ଡ଼ିକିନାୟି, ଡା଼ହାରା, ନିନ୍ଦା କିନାୟି, ଡା଼ହାରା ଆ଼ନାୟି, କାର୍‌ବି ଆ଼ନାୟି; ");
INSERT INTO kxv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଏଲେତି ଲାଗେଏତାୟି ବିତ୍ରାଟି ହ଼ଚାୱା଼ହାନା ମାଣ୍‌ସିଇଁ ଲାଗେଏ କିହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ ଟା଼ୟୁ ପିସାନା ସ଼ରତି ହାନ୍ଦି ୱାକି ହାଚେସି, ଇଞ୍ଜାଁ ର଼ ଇଲୁତା ହ଼ଡାନା ଏ଼ନିକିଁ ଆମ୍ବାଆରି ପୁନଅରି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେସି, ସାମା ଏ଼ୱାସି ଡ଼ୁଗାନା ଡ଼ୟାଲି ଆ଼ଡାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ଏ଼ ଦେବୁଣିଏ ର଼ ଇୟା, ଆମ୍ବାଆରି ମା଼ଙ୍ଗାନି ବୂତୁ ଆଲ୍‌ଗାମାଚେ, ଏ଼ଦି ଜୀସୁ କାତା ୱେଞ୍ଜାନା ୱା଼ହାଁ ଏ଼ୱାଣି କଡାଣା ରୀତେ । ");
INSERT INTO kxv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ଏ଼ ଇୟା ସୁରପୟିନିକି ଜା଼ତିତି ର଼ ଗ୍ରିକ୍‌ ଇୟା ମାଚେ, ତାନି ମା଼ଙ୍ଗାନି ତା଼ଣାଟି ବୂତୁ ପିସ୍‌ପି କିହାଲି ଏ଼ଦି ଜୀସୁଇଁ ବାତିମା଼ଲିତେ । ");
INSERT INTO kxv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ତଲିଏ କକାରି ପ଼ଦାଁଣି ପାଞ୍ଜି କିଦୁ, ଇଚିହିଁ କକାରି ପ଼ଦାୟାଁ ରା଼ନ୍ଦା ଅ଼ହାନା ନେସ୍‌କା ନ଼କିତା ମେତ୍‌ନାୟି ନେହେଁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ସାମା ଏ଼ଦି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ହାଅ ପ୍ରବୁ ନେସ୍‌କା ଜିକେଏ କକାରି ପ଼ଦାୟାଁ ତ୍ରକ୍‌ହାମାନି ଲିତାତି ପେର୍‌ହା ତିନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଈ କାତାତାକି ନୀ ମା଼ଙ୍ଗାନି ତା଼ଣାଟି ବୂତୁ ହ଼ଚା ହାଚେୟିଏ, ହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଇଞ୍ଜାଁ ଏ଼ଦି ଇଜ ହାଜାନା ତାନି ମା଼ଙ୍ଗା ପା଼ସ୍‌ପନିତା ହୁଞ୍ଜାମାନାଣି ଇଞ୍ଜାଁ ବୂତୁ ହ଼ଚା ହାଜା ମାନାଣି ମେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାସି ସ଼ର ହାନ୍ଦିଟି ହାଜାନା ସିଦନ ଅ଼ଡ଼େ ଦସଗଟା ନା଼ସ୍‌କା ହାନ୍ଦି ହୀହାନା ଗାଲିଲି ସାମ୍‌ଦୁରି ଡାଗେ ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଇଞ୍ଜାଁ ଲ଼କୁ ର଼ ବେ଼ରା ଅ଼ଡ଼େ ଗୁଲାଇଁ ଏ଼ୱାଣି ନ଼କିତା ତାଚାନା ଏ଼ୱାଣିଲାକ କେୟୁ ଇଟାଲି ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜୀସୁ ଲ଼କୁ ତା଼ଣାଟି ରଅଣାଇଁଏ ଏଟ୍‌କା କିହା ଅ଼ହାନା ଏ଼ୱାଣି ରୀ କୀର୍କାଣା ତାନି ୱାସ୍‌କା ଇଟିତେସି ଅ଼ଡ଼େ ହୂପାନା ଏ଼ୱାଣି ୱେନ୍ଦରି ଡୀଗିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଅ଼ଡ଼େ ଲାକପୂରୁ ୱାକି ସିନିକିହାନା ଗାଡିକିହିଁ ନେ଼ଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଇପ୍‌ପତ” ଇଚିହିଁ “ଦେପି ଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ଏମ୍ବାଟିଏ ଏ଼ୱାଣି କୀର୍କା ଦେପିଆ଼ତୁ, ଇଞ୍ଜାଁ ୱେନ୍ଦରିତି ଜା଼ଲା ଏ଼ ଦେବୁଣିଏ ଗୁଚାଆ଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ନେହିଁକିଁ ଜ଼ଲାଲି ଆ଼ଡିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଇଞ୍ଜାଁ ଏ଼ କାତା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଏ଼ୱାରାଇଁ ଗାଡିକିହିଁ ହୁକୁମି ହୀତେସି; ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଚେକା କା଼ହି କିତେସି, ଏ଼ୱାରି ଏଚେକା ଗାଡି ୱେ଼କ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଅ଼ଡ଼େ ଲ଼କୁ କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଏ଼ୱାସି ବାରେ କାମା ନେହିଁକିଁ କିହିମାନେସି; ଏ଼ୱାସି ବେ଼ରାୟାଁଇଁ ୱେଞ୍ଜାଲି ଗୁଲାୟାଁଇଁ ଜ଼ଲିନି ବା଼ଡ଼୍‌ୟୁ ଜିକେଏ ହୀହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ଏଚିବେ଼ଲା ହା଼ରେକା ମାନ୍ଦା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାରିତା଼ଣା ତିନାୟି ଉନାୟି ଏ଼ନାୟି ହିଲାଆତାକି ଜୀସୁ ସୀସୁୟାଁଣି ଡାଗେ ହା଼ଟାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ଲ଼କୁତାକି ନାଙ୍ଗେ କାର୍ମା ହ଼ଚିମାଞ୍ଜାନେ, ଇଚିହିଁ ଈୱାରି ତୀନିଦିନା ଆ଼ତେରିଏ ନା଼ ତଲେ ମାଞ୍ଜାମାନେରି, ଅ଼ଡ଼େ ଈୱାରି ତା଼ଣା ଏ଼ନାୟି ତିନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଏ଼ୱାରାଇଁ ତୀହ୍‌ଆନାଁ ପାଣ୍ତିସାରେ, ୱେଣ୍ଡାହାନାଟି ଏ଼ୱାରି ହା଼ହା ଜିକେଏ ହା଼ନେରି । ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ହେକଟି ୱା଼ହାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଇମ୍ବାଆଁ ଈ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଆମ୍ବାଆସି ଆମ୍ବିଟି ରୂଟି ତାଚାନା ଈୱାରାଇଁ ପାଞ୍ଜି କିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀ ତା଼ଣା ଏଚରଗଟା ରୂଟି ମାନୁ ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ସା଼ତାଗଟା ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ଏମ୍ବାଟିଏ ଜୀସୁ ଲ଼କୁଣି ବୂମିତା କୁଗାଲି ହୁକୁମି ହୀତେସି; ଅ଼ଡ଼େ ଏ଼ୱାସି ସା଼ତାଗାଟା ରୂଟି ଅ଼ହାନା ଜହରା କିହାନା ଏ଼ ବାରେ ଡ଼ିକ୍‌ହାନା ବା଼ଟି କିହାଲି ତାନି ସୀସୁୟାଁକି ହୀତେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଲ଼କୁତାକି ବା଼ଟି କିହା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାରିତା଼ଣା ଏଚରଗଟା ଊଣା ମୀଣ୍‌କା ମାଚୁ; ଏ଼ ବାରେତି ଜିକେଏ ଜୀସୁ ମାହାପୂରୁ ତା଼ଣା ଜହରା କିହାନା ବା଼ଟି କିହା ହୀହାଲି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ତିଞ୍ଜାନା ପାଞ୍ଜିତେରି ଇଞ୍ଜାଁ ହା଼ରିତାଣି ସା଼ତା ଡାଲି କୂଡ଼ି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ଏ଼ୱାରି ବାରେ ସା଼ରି ମା଼ଣା ଲ଼କୁ ମାଚେରି । ଏଚେଟିଏ ଡା଼ୟୁ ଏ଼ୱାରାଇଁ ହେଲ ହୀତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ଇଞ୍ଜାଁ ଦେବୁଣିଏ ତାନି ସୀସୁୟାଁ ତଲେ ଡଂଗତା ହ଼ଚାନା ଦଲ୍‌ମନୁ ଗା଼ଡ଼ାତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ଡା଼ୟୁ ପାରୁସିୟାଁ ୱା଼ହାନା ଜୀସୁତଲେ ବା଼ଦିବା଼ଦା କିହାଲି ମା଼ଟ୍‌ହେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ତାୟିପାରି କିହାଲିତାକି ହା଼ଗୁ ଲାକଟି ର଼ ସିନା ରୀସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ଜୀସୁ ଜୀୱୁତା କିଲିବିଲି ଆ଼ହାନା ଗାଡି ନେ଼ଞ୍ଜାନା ୱେସ୍ତେସି, “ଈ ଜୁଗୁତି ଲ଼କୁ ଏ଼ନାଆଁତାକି ସିନା ପାରିମାନେରି ? ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀଏଁତି ମାଣ୍‌ସିକି ଏ଼ନି ସିନା ହୀପ୍‌କି ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପିସାନା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଡଂଗତା ହ଼ଚାନା ଆତାଲାୱାକି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଏଚିବେ଼ଲାତା ସୀସୁୟାଁ ରୂଟି ଅ଼ହାଲି ବା଼ଣାଆ଼ତେରି; ଡଂଗତା ଏ଼ୱାରିତା଼ଣା ରଣ୍ତିଏ ରୂଟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଡା଼ୟୁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଜାଣ୍ତେ ହୁକୁମି ହୀତେସି, “ଜାଗ୍ରାତା ଆ଼ଦୁ, ପାରୁସିୟାଁ ଅ଼ଡ଼େ ହେରଦତି ପୂଲାଗୁଣ୍ଡାଟି ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ଏଚେଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ୱେସ୍‌ପିଆ଼ହିଁ ଏଲେଇଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି, “ମା଼ ତା଼ଣା ରୂଟି ହିଲେଏ ଇଞ୍ଜିଁ ଏ଼ୱାସି ମାଙ୍ଗେ ଏଲେଇଞ୍ଜିମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ଜୀସୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ତା଼ଣା ରୂଟି ହିଲେଏ ଇଞ୍ଜିଁ ଏ଼ନାଆଁତାକି ମୀରୁ ମୀରୁ ୱେସ୍‌ପି ଆ଼ହିମାଞ୍ଜେରି ? ମୀରୁ ନୀଏଁ ପାତେକା ପୁଞ୍ଜି ହିଲଅତେରି କି ତେଲ୍‌ହି ହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","କାଣ୍‌କା ମାଞ୍ଜାନା ମେସି ହିଲଅତେରି ? ଅ଼ଡ଼େ, କୀର୍କା ମାଞ୍ଜାନା ୱେଞ୍ଜି ହିଲଅତେରି ? ମୀରୁ ଈଦାଣି ଅଣ୍‌ପି ହିଲ୍‌ଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ଏ଼ ପା଼ସାମା଼ଣା ଲ଼କୁ ବିତ୍ରା ନା଼ନୁ ଏଚିବେ଼ଲା ପା଼ସାଗଟା ରୂଟି ଡ଼ିକ୍‌ହା ମାଚେଏଁ, ଏଚିବେ଼ଲା ମୀରୁ ଏଚର ଡାଲି ହା଼ରିତାଣି କୂଡ଼ି କିତେରି, ଏ଼ଦି ମୀ ଅଣ୍‌ପୁତା ହିଲେଏ କି ?” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ବା଼ର ଡାଲି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ଅ଼ଡ଼େ ଏ଼ ସା଼ରି ମା଼ଣା ଲ଼କୁ ବିତ୍ରା ନା଼ନୁ ଏଚିବେ଼ଲା ସା଼ତାଗଟା ରୂଟି ଡ଼ିକ୍‌ହା ମାଚେଏଁ, ଏଚିବେ଼ଲା ମୀରୁ ଏଚର ଡାଲି କୂଡ଼ି କିହାମାଚେରି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ସା଼ତା ଡାଲି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ଏଚିବେ଼ଲା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ନୀଏଁ ପାତେକା ତେଲ୍‌ହାଲି ଆ଼ଡିହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ଡା଼ୟୁ ଏ଼ୱାରି ବେତ୍‌ସାୟିଦାତା ୱା଼ତେରି, ଅ଼ଡ଼େ, ଲ଼କୁ ର଼ କା଼ଣାଇଁ ଏ଼ୱାଣି ତା଼ଣା ତାଚାନା ଏ଼ୱାଣାଇଁ ଡୀଗାଲି ତାକି ଜୀସୁଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଏ଼ଦାଆଁତାକି ଜୀସୁ କା଼ଣାତି କେୟୁ ଆସାନା ଏ଼ୱାଣାଇଁ ନା଼ୟୁଁ ପାଙ୍ଗାତା ଅ଼ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି କାଣ୍‌କାଣାଁ ହୂପ୍‌କା ରୁବାନା ଅ଼ଡ଼େ ଏ଼ୱାଣିଲାକ କେୟୁ ଇଟାନା ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ମେସାଲି ଆ଼ଡିମାଞ୍ଜି କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ଏ଼ୱାସି ସିନିକିହାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମାଣ୍‌ସିୟାଁଇଁ ମେସିମାଇଁ, ଇଚିହିଁ ନା଼ନୁ ମା଼ର୍‌କା ଲେହେଁ ଏ଼ନାଇ ତା଼କି ମାନାଣି ମେସିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ଡା଼ୟୁ ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାଣି କାଣ୍‌କାଣାଁ କେୟୁ ଇଟିତେସି; ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନେହିଁକିଁ ମେସାଲି ଆ଼ଡିତେସି, ନେହିଁ ଆ଼ହାନା ବାରେ ତୀରିତଲେ ସିନିକିହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଡା଼ୟୁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ତାନି ଇଜ ପାଣ୍ତାନା ଏଲେଇଚେସି, “ଏ଼ ନା଼ୟୁଁ ବିତ୍ରା ଜିକେଏ ୱେଣ୍ତେ ହାଲାଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଏଚେଟିଏ ଜୀସୁ ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ କାୟିସରିୟା ପିଲିପି ରା଼ଜିତି ନା଼ସ୍‌କାୱାକି ହାଚେରି, ଅ଼ଡ଼େ ଜିରୁତା ଏ଼ୱାସି ତାନି ସୀସୁୟାଁଇଁ ୱେଚେସି, “ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ଇଞ୍ଜିଁ ଲ଼କୁ ଏଲେଇଞ୍ଜି ମାଞ୍ଜାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ବାପ୍ତିସ୍ମ ହୀନି ଜହନ, ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରି ଏଲିୟ, ସାମା ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଞ୍ଜି ମାଞ୍ଜାନେରି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ବିତ୍ରାଟି ରଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, “ସାମା ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ଇଞ୍ଜିଁ ମୀରୁ ଏଲେଇଞ୍ଜି ମାଞ୍ଜାଦେରି ?” ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ କ୍ରୀସ୍ତତି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ତାନି କାତାତି ଆମ୍ବାଆରାଇଁ ଏ଼ନାଆଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଜାଣ୍ତେ କିହିଁ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଅ଼ଡ଼େ, ଜୀସୁ ଏ଼ୱାରାଇଁ ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, “ଇଚିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ହା଼ରେକା ଦୁକୁ କସ୍ତ ବେଟାଆ଼ନାୟି ମାନେ ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗା, କାଜା ପୂଜେରାଙ୍ଗା, ଇଞ୍ଜାଁ ମେ଼ରାପୁନାରି ତା଼ଣାଟି ଅ଼ପାଆଗାଟାସି ଆ଼ହାନା ପା଼ୟ୍‌ୱି ଆ଼ନାୟି ମାନେ, ଅ଼ଡ଼େ ତୀନିଦିନା ଜେ଼ଚ ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଈ କାତା ଏ଼ୱାସି ତୀର୍‌ପୁତଲେ ୱେସ୍ତେସି । ଏମ୍ବାଟିଏ ପିତର ଏ଼ୱାଣାଇଁ ଅ଼ରୱାକି ଅ଼ହାନା ଦାକା ହୀହାନା ଲା଼ଗାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ସାମା ଏ଼ୱାସି ଡା଼ୟୁୱାକି ତିର୍‌ୱାହାଁ ତାନି ସୀସୁୟାଁଣି ସିନିକିହାନା ପିତରଇଁ ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ସୟତାନ, ନା଼ ନ଼କିଟି ହେକ ହାଲାମୁ, ଇଚିହିଁ ନୀନୁ ମାହାପୂରୁ କାତା ଅଣ୍‌ପାଆନା ମାଣ୍‌ସିୟାଁ କାତା ଅଣ୍‌ପିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ଏମ୍ବାଟିଏ ଜୀସୁ ତାନି ସୀସୁୟାଁ ତଲେ ଲ଼କୁଣି ହା଼ଟାନା ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ ଜେ଼ଚ ୱା଼ହାଲି ମ଼ନ କିନେସି, ଆତିହିଁ ଏ଼ୱାସି ଜାହାରାଇଁ ପିସ୍‌ପେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାନି କ୍ରୁସ ଡେ଼କାନା ନା଼ ଜେ଼ଚ ୱା଼ପେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଇଚିହିଁ ଆମ୍ବାଆସି ତାନି ଜୀୱୁ ଗେଲ୍‌ପାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ ହା଼ୱି କିନେସି; ସାମା ଆମ୍ବାଆସି ନା଼ ତାକି ଇଞ୍ଜାଁ ନେହିଁ କାବ୍ରୁତାକି ତାନି ଜୀୱୁ ହୀନେସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ ନୀଟ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଅ଼ଡ଼େ, ମାଣ୍‌ସି ଈ ଦାର୍‌ତିତା ମାନାଣି ବାରେ ମେଡ଼ି କିହାନା ତାନି ଜୀୱୁତି ହା଼ୱି କିନେସି, ଆତିହିଁ ଏ଼ୱାଣାକି ଏ଼ନି ଲା଼ବା ? ");
INSERT INTO kxv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଅ଼ଡ଼େ, ମାଣ୍‌ସି ତାନି ଜୀୱୁତି ବାଦୁଲି ଏ଼ନାଆଁ ହୀହାଲି ଆ଼ଡିନେସି ? ");
INSERT INTO kxv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଏ଼ଦାଆଁତାକି ଆମ୍ବାଆସି ଈ କା଼ଲାତି ଦା଼ରି କିନାରି ଅ଼ଡ଼େ ପା଼ପୁଗାଟି ଲ଼କୁ ବିତ୍ରା ନାଙ୍ଗେ ଅ଼ଡ଼େ ନା଼ ବ଼ଲୁ ତାକି ଲାଜା ଆ଼ନେସି, ମାଣ୍‌ସି ମୀର୍‌ଏସି ଏଚିବେ଼ଲା ସୁଦୁ ଦୂତୁୟାଁ ତଲେ ତାନି ଆ଼ବାତି ଗାୱୁରମି ତଲେ ୱା଼ନେସି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ଜିକେଏ ଏ଼ୱାଣି କାତାତାକି ଲାଜା ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଅ଼ଡ଼େ ଜୀସୁ ତାନି ସୀସୁଣି ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଇମ୍ବାଆଁ ଏଚରଜା଼ଣା ମାନେରି ମାହାପୂରୁତି ରା଼ଜି ବା଼ଡ଼୍‌ୟୁ ତଲେ ୱା଼ନାଣି ମେହ୍‌ଆ ପାତେକା ହା଼ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ସ଼ ଦିନା ଡା଼ୟୁ ଜୀସୁ ୱା଼ର୍‌ଇ ପିତର, ଜାକୁବ ଅ଼ଡ଼େ ଜହନଇଁ ତାନିତଲେ ଏଟ୍‌କା କିହାନା ଏ଼ୱାରାଇଁ ର଼ ପାଡାଆ଼ତି ହ଼ରୁତା ଅ଼ତେସି । । ");
INSERT INTO kxv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରି ନ଼କିତା ଅ଼ର ୱା଼ଣା ଆ଼ତେସି, ଏ଼ୱାଣି ହିମ୍ବରି ଇଲେକିଁ ଉଜେଡ଼ି ଆ଼ହାନା ହା଼ରେକା ଦବ୍‌ଲା ଆ଼ତେ, ଈ ଦାର୍‌ତିତା ଆମ୍ବାଆସି ଏଲେତି ଦବ୍‌ଲା କିହାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ମ଼ସା ଅ଼ଡ଼େ ଏଲିୟ ଜୀସୁତଲେ ହା଼ଡାକାତା ଆ଼ହିମାଚାଣି ତୀନି ଜା଼ଣା ସୀସୁୟାଁ ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ଏମ୍ବାଟିଏ ପିତର ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ମା଼ର ଈ ଟା଼ୟୁତା ମାନାୟି ହା଼ରେକା ନେହାୟି; ମା଼ର ତୀନିଗଟା ଗୂଡ଼ାୟାଁ କେ଼ପିନ, ନିଙ୍ଗେତାକି ରଣ୍ତାଆଁ, ମ଼ସାକି ରଣ୍ତାଆଁ ଅ଼ଡ଼େ ଏଲିୟକି ରଣ୍ତାଆଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର ଏ଼ନାଆଁ ଜ଼ଲାଲି ଆ଼ନେ ଇଞ୍ଜିଁ ପୁଞ୍ଜା ହିଲାଆତେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରି ହା଼ରେକା ଆଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଇଞ୍ଜାଁ, ଇଚାୟି ଦୂନ୍ଦ୍ରା ୱା଼ହାନା ଏ଼ୱାରାଇଁ ପ୍ଡିକ୍‌ହେ, ଅ଼ଡ଼େ ଏ଼ ଦୂନ୍ଦ୍ରାଟି ଈ ହା଼ଡା ୱା଼ତେ, “ଈୱାସି ନା଼ ଜୀୱୁତି ମୀର୍‌ଏସି, ଈୱାଣି ବ଼ଲୁ ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଦେବୁଣିଏ ଏ଼ୱାରି ସା଼ରିୱାକି ସିନିକିତେରି, ତାମିତଲେ ଜୀସୁଇଁ ପିସ୍‌ପେ ଆମ୍ବାଆରାଇଁ ମେହ୍‌ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ଏ଼ୱାରି ହ଼ରୁଟି ରେ଼ଚା ୱା଼ହି ମାଚାଟି ଜୀସୁ ଏ଼ୱାରାଇଁ ଜାଣ୍ତେ ହୁକୁମି ହୀହାନା ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ମେସାମାଞ୍ଜେରି, ଏ଼ ବାରେ ହା଼ତାରି ବିତ୍ରାଟି ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱେଣ୍ତେ ନିଙ୍ଗାଆ ପାତେକା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ କାତା ଆସାନା “ହା଼ତାରି ବିତ୍ରାଟି ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ଏ଼ନାୟି ?” ଏ଼ କାତାତି ତାମି ବିତ୍ରା ୱେସ୍‌ପି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜୀସୁଇଁ ୱେଚେରି, “ନ଼କେଏ ଏଲିୟ ୱା଼ନାୟି ଆ଼ନେ, ମେ଼ରାପୁନାରି ଏ଼ନିକିଁ ଈ କାତା ୱେହ୍‌ନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଲିୟ ନ଼କେଏ ୱା଼ହାନା ବାରେ ମେ଼ରା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଇଟିନାୟି ସାତା, ସାମା ମାଣ୍‌ସି ମୀର୍‌ଏସି ହା଼ରେକା ଦୁକୁ ବେଟାଆ଼ହାନା ଅ଼ପାଆଗାଟାସି ଆ଼ନେସି, ଈଦି ଏ଼ନିକିଁ ଏ଼ୱାଣି କାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ ? ");
INSERT INTO kxv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏଲିୟ ୱା଼ତେସିଏ, ଅ଼ଡ଼େ ଏ଼ୱାଣି କାତା ଏ଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଏଲେକିହିଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜିକେଏ ଏ଼ନାଆଁ ମ଼ନ ଏ଼ଦାଆଁ କିହାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଡା଼ୟୁ ଏ଼ୱାରି ସୀସୁୟାଁ ତା଼ଣା ୱା଼ହାନା ମେସ୍ତେରି, ଏ଼ୱାରି ସା଼ରିୱାକି ହା଼ରେକା ମାନ୍ଦା ଲ଼କୁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଏ଼ୱାରିତଲେ ବା଼ଦିବା଼ଦା ଆ଼ହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ଲ଼କୁ ବାରେ ଏ଼ୱାଣାଇଁ ମେସ୍‌ପନିଏ ହା଼ରେକା କାବାଆ଼ହାନା ଅ଼ଡ଼େ ଦାବ୍‌ଡ଼ି ୱା଼ହାନା ଜହରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀରୁ ଏ଼ୱାରିତଲେ ଏ଼ନାଆଁତାକି ବା଼ଦିବା଼ଦା ଆ଼ହିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ଲ଼କୁ ବିତ୍ରାଟି ରଅସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ, ନା଼ନୁ ନା଼ ମୀର୍‌ଏଣାଇଁ ନୀ ତା଼ଣା ତାଚାମାଚେଏଁ; ଏ଼ୱାଣାଇଁ ର଼ ଗୁଲା ବୂତୁ ଆଲ୍‌ଗାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଏମିନି ଟା଼ୟୁତା ଏ଼ଦି ଏ଼ୱାଣାଇଁ ଆହ୍‌ନେ, ଏ଼ୱାଣାଇଁ ଡ଼଼ଇ ତ୍ରକ୍‌ନେ, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଗୂତିଟି ପମ୍ବଲି ହ଼ନେ, ଅ଼ଡ଼େ ଏ଼ଦି ପାଲ୍‌କା ଟୀଟି କିନେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ୱା଼ୟାହାଜି ମାନେସି; ଏ଼ୱାଣାଇଁ ପିସ୍‌ପି କିହାଲି ନା଼ନୁ ନୀ ସୀସୁୟାଁଇଁ ଏଲେଇଚେଏଁ, ସାମା ଏ଼ୱାରି ଆ଼ଡାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ ନାମାଆଗାଟି କୂଡ଼ାତାତେରି, ଏଚରଦିନା ନା଼ନୁ ମୀ ତଲେ ଡ଼ୟିଇଁ ? ଏଚରଦିନା ମୀ ଲେ଼ମ୍ବାନାଣି ଅ଼ର୍‌ହିଇଁ ? କକାଣାଇଁ ନା଼ ତା଼ଣା ତାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ଏମ୍ବାଟିଏ ଏ଼ୱାଣାଇଁ ଜୀସୁ ତା଼ଣା ତାତେରି । ଅ଼ଡ଼େ, ଜୀସୁଇଁ ମେସ୍‌ପନିଏ ଏ଼ ବୂତୁ ଏ଼ୱାଣାଇଁ ହା଼ରେକା ତିର୍‌ୱି କିତେ ଇଞ୍ଜାଁ ବୂମିତା ତର୍‌ଗାନା ଗୂତିଟି ପମ୍ବଲି ହ଼ପ୍‌ହାନା ଊସାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ଏଚିବେ଼ଲା ଜୀସୁ ତାନି ଆ଼ବାଇଁ ୱେଚେସି, “ଏଚରଦିନା ଆ଼ତେ ଈୱାଣାଇଁ ଇଲେ କିହିମାନେ ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ଊଣା ୱେ଼ଡ଼ାଟିଏ ");
INSERT INTO kxv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ଏ଼ଦି ଏ଼ୱାଣାଇଁ ହା଼ୱି କିହାଲି ଏଚେ ଏଚେ଼ତା ହିଚୁତା ଅ଼ଡ଼େ ଏ଼ୟୁଣାଁ ମେତ୍‌ହାମାନେ; ସାମା ନୀନୁ ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡିତିଁ, ମାଙ୍ଗେ କାର୍ମା ଆ଼ହାନା ମା଼ ସା଼ୟେମି ଆୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁ ଇଚି ? ଇଚିହିଁ କିହାଲି ଆ଼ଡିତିଁ ! ଆମ୍ବାଆସି ନାମିନେସି ଏ଼ୱାଣାକି ବାରେଏ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ଏ଼ ଦେବୁଣିଏ କକାଣି ତାମି ଆ଼ବା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ନା଼ନୁ ନାମିମାଇଁ ନା଼ ନାମାଆଗାଟାଣି ଗୁଚି କିହାଲି ସା଼ୟେମି କିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଡା଼ୟୁ ମାନ୍ଦା ଲ଼କୁ ରହେଁଏ ହଟିହିଁ ୱା଼ହି ମାଚାଣି ମେସାନା, ଜୀସୁ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁତି ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ଆଡ଼େ ଗୁଲା ଅ଼ଡ଼େ ବେ଼ରା ବୂତୁତି, ନା଼ନୁ ନିଙ୍ଗେ ହୁକୁମି ହୀହିମାଞ୍ଜାଇଁ, ଈୱାଣି ତା଼ଣାଟି ହ଼ଚାହାଲାମୁ, ଇଞ୍ଜାଁ ଏଚେଲା ଜିକେଏ ଈୱାଣି ତା଼ଣା ହ଼ଡ଼୍‌ଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ଏମ୍ବାଟିଏ ଏ଼ଦି ହା଼ରେକା କିର୍‌ଡ଼ିହିଁ କକାଣାଇଁ ତିର୍‌ୱି କିହାନା ବୂମିତା ତ୍ରକ୍‌ହାନା ହ଼ଚାହାଚେ, ଅ଼ଡ଼େ କକାସି ହା଼ତିଲେହେଁ ଆ଼ତେସି, ଇଲେକିହିଁ ହା଼ରେକା ଲ଼କୁ ଏଲେଇଞ୍ଜିମାଚେରି, “କକାସି ହା଼ତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ସାମା ଜୀସୁ ଏ଼ୱାଣି କେୟୁ ଆସାନା ନିକ୍‌ହେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ନିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଇଞ୍ଜାଁ ଜୀସୁ ଇଜ ୱା଼ହାଲିଏ ତାନି ସୀସୁୟାଁ ମେଣେଏ ୱେଚେରି, “ମା଼ମ୍ବୁ ଏ଼ନାଆଁତାକି ଏ଼ୱାଣାଇଁ ପିସ୍‌ପି କିହାଲି ଆ଼ଡାଆତମି ?” ");
INSERT INTO kxv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ପ୍ରା଼ତାନା କିଆନା ଅ଼ଡ଼େ ଏ଼ନିକିଁ ଜିକେଏ ଇଲେତି ବୂତୁ ପେ଼ର୍‌ହାଲି ଆ଼ଡାଆୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଏ଼ୱାରି ଏ଼ ଟା଼ୟୁଟି ହାଜାନା ଗାଲିଲି ମାଦିଟି ହାଚେରି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ପୁନାଆପେସି ଇଞ୍ଜିଁ ଏ଼ୱାଣି ମ଼ନ ହିଲାଆତେ; ");
INSERT INTO kxv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ଇଚିହିଁ ଜୀସୁ ତାନି ସୀସୁୟାଁଣି ଈ କାତା ୱେସିହିଁ ଜା଼ପ୍‌ହି ମାଚେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ମାଣ୍‌ସିୟାଁ କେୟୁତା ହେର୍‌ପିଆ଼ନେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ୟିନେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ହା଼ତି ଡା଼ୟୁ ତୀନିଦିନା ଜେ଼ଚ ୱେଣ୍ତେ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ସାମା ଏ଼ୱାରି ଏ଼ କାତାତି ତେଲ୍‌ହାଆତେରି, ସାମା ଏ଼ୱାଣାଇଁ ୱେଞ୍ଜାଲି ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ଡା଼ୟୁ ଏ଼ୱାରି କପର୍‌ନାହୁମତା ୱା଼ତେରି । ଜୀସୁ ଇଜ ଏଜାନା ସୀସୁୟାଁଣି ୱେଚେସି, “ମୀରୁ ଜିରୁତା ଏ଼ନାଆଁ କାତା ଆ଼ହିମାଚେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ସାମା ଏ଼ୱାରି ହା଼ଡା ଆ଼ଆନା ପାଲେଏ ଡ଼ୟିତେରି, ଇଚିହିଁ ଆମ୍ବାଆସି କାଜାସି ଈ କାତା ଆସାନା ଜିରୁତା କାତା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଏମ୍ବାଟିଏ ଜୀସୁ କୁଗାନା ବା଼ର ଜା଼ଣାଇଁ ହା଼ଟିତେସି ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଇଚିହିଁ ଆମ୍ବାଆସି କାଜାସି ଆ଼ହାଲି ମ଼ନ କିନେସି, ଆତିହିଁ ଏ଼ୱାସି ବାରେତି କିହାଁ ଊଣା ଅ଼ଡ଼େ ବାରେତି ସେ଼ବା କିନାସି ଆ଼ପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ଅ଼ଡ଼େ ଏ଼ୱାସି ର଼ ଊଣା କକାଣାଇଁ ଅ଼ହାନା ଏ଼ୱାରି ମାଦି ନିପ୍‌ହେସି ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ପମାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ଆମ୍ବାଆସି ନା଼ ଦ଼ରୁ ତାକି ଇଲେତି ଊଣା କକାରି ବିତ୍ରାଟି ରଅଣାଇଁ ଆବିନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଆବାନେସି; ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନାଙ୍ଗେ ଆବାନେସି, ଏ଼ୱାସି ୱାର୍‌ଇ ନାଙ୍ଗେ ଆବଅସି, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ଜିକେଏ ଆବିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜହନ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ମା଼ ଗଚିତା ହିଲାଆଗାଟାସି ରଅସି ନୀ ଦ଼ରୁତଲେ ବୂତୁଣି ପେ଼ର୍‌ହି ମାଚାଣି ମେସ୍ତମି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ମା଼ ଗଚିତା ହିଲାଆତାକି ଏ଼ୱାଣାଇଁ କା଼ହିକିତମି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ୱାଣାଇଁ କା଼ହିକିଆଦୁ; ଇଚିହିଁ ନା଼ ଦ଼ରୁତଲେ କାବାଆ଼ନି କାମା କିହାନା ୱେଣ୍ତେ ନାଙ୍ଗେ ନିନ୍ଦା କିୟାନେସି, ଇଲେତି ଲ଼କୁ ଆମ୍ବାଆସି ହିଲଅସି; ");
INSERT INTO kxv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ଇଚିହିଁ ଆମ୍ବାଆସି ମା଼ କ଼ପାଟି ନିଙ୍ଗାଆ ଗାଟାସି ଏ଼ୱାସି ମା଼ ତଲେତାସି । ");
INSERT INTO kxv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ କ୍ରୀସ୍ତତି ଲ଼କୁ ଇଞ୍ଜିଁ ଆମ୍ବାଆସି ଜିକେଏ ମିଙ୍ଗେ ଜା଼ଚେକା ଏ଼ୟୁ ଗସାଲି ହିୟାନେସି, ଏ଼ୱାସି ଏ଼ନିଜିକେଏ ତାନି ଦା଼ନାତି ଜା଼କ୍‌ଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନାମାମାନି ଈ ଊଣାୟାଁ ବିତ୍ରାଟି ରଅଣାଇଁ ପା଼ପୁ କିୱି କିନେସି, ଏ଼ୱାଣି ହେର୍‌କିତା କାଜା ଜେତାୱାଲି ଦସାନା ଏ଼ୱାଣାଇଁ ସାମ୍‌ଦୁରିତା ମେତ୍‌ହିହିଁ ନେହେଁ ଆ଼ତେମା । ");
INSERT INTO kxv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ମୀ କେୟୁ ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ, ଇଚିହିଁ ଏ଼ଦାଆଁ ଜା଼ଚାନା କୁତାଦୁ; ରୀ କେସ୍କା ମାଞ୍ଜାନା ନର୍କ ଇଚିହିଁ ଡୁମ୍ବାଆଗାଟି ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେତ୍‌ପି ଆ଼ନି ବା଼ଟା କଲା ଆ଼ହାନା ଜୀୱୁତା ହ଼ଡ଼ନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ଇଚିହିଁ ନର୍କତା ଏମ୍ବାତି ପିଡ଼୍‌କା ଏଚେଲା ହା଼ଉ, ଅ଼ଡ଼େ ହିଚୁ ଏଚେଲା ଡୁମ୍ବେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଅ଼ଡ଼େ ମୀ କଡା ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ, ଏ଼ଦାଣି ରାତ୍‌ହା କୁତାଦୁ, ରୀ କଡାୟାଁ ନେହେଁ ମାଞ୍ଜାନା ନର୍କତା ମେତ୍‌ପି ଆ଼ନି ବା଼ଟା ସଟା ଆ଼ହାନା ଜୀୱୁତା ହ଼ଡ଼ନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ଇଚିହିଁ ନର୍କତା ଏମ୍ବାତି ପିଡ଼୍‌କା ଏଚେଲା ହା଼ଉ, ଅ଼ଡ଼େ ହିଚୁ ଏଚେଲା ଡୁମ୍ବେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଇଞ୍ଜାଁ ମୀ କାନୁ ମିଙ୍ଗେ ପା଼ପୁ କିୱିକିୟାନେ ଇଚିହିଁ ଏ଼ଦାନି ଡ଼େୱା କୁତାଦୁ, ରୀ କାଣ୍‌କା ନେହେଁ ମାଞ୍ଜାନା ନର୍କତା ମେତ୍‌ପି ଆ଼ନି କିହାଁ ର଼ କାନୁ ତଲେ ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡ଼ନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ଇଚିହିଁ ନର୍କତା ଏମ୍ବାତି ପିଡ଼୍‌କା ଏଚେଲା ହା଼ଉ, ଅ଼ଡ଼େ ହିଚୁ ଏଚେଲା ଡୁମ୍ବେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ହା଼ରୁ ତଲେ ଏ଼ନିକିଁ ପୂଜା ହୀନାୟି ସୁଦୁ ଆ଼ନେ, ଏଲେକିହିଁଏ ହିଚୁତଲେ ବାରେ ସୁଦୁ କିୱିଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ହା଼ରୁ ନେହାୟି, ସାମା ହା଼ରୁ ମୂଆସାରେ ଆତିହିଁ ଏ଼ନିକିଁ ମୂପି କିନାୟି ଆ଼ନେ ? ମୀରୁ ମୀ ତା଼ଣା ହା଼ରୁ ଲେହେଁ ଆ଼ଦୁ, ଅ଼ଡ଼େ ରଅତେରି ରଅଣାକି ହିତ୍‌ଡ଼ି ଜୀୱୁତଲେ ନେହିଁ ଆ଼ହିଁ ଡ଼ୟାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଏ଼ ଟା଼ୟୁଟି ଜୀସୁ ହାଜାନା ଜୀହୁଦା ରା଼ଜିତି ହାନ୍ଦି ଅ଼ଡ଼େ ଜର୍ଦନ କାଡା ଆତାଲାୱାକି ୱା଼ତେସି; ଇଞ୍ଜାଁ ଲ଼କୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାଣି ତା଼ଣା ରୁଣ୍ତା ଆ଼ହାଲିଏ, ଏ଼ୱାସି ତାନି ମେ଼ରା ଲେହେଁ ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଏମ୍ବାଟିଏ ପାରୁସିୟାଁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ତାୟିପାରିକିହିଁ ୱେଚେରି, “ଜାହାରା ଡକ୍ରିନି ପିସାଲି ଆ଼ବାୟାଁକି ମେ଼ରା କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମ଼ସା ମିଙ୍ଗେ ଏ଼ନି ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ଏ଼ୱାରି ଏଲେଇଚେରି, “ପିହ୍‌ନି ଆ଼କୁ ରା଼ଚାନା ଡକ୍ରିନି ପିସାଲି ମ଼ସା ହେଲ ହୀହାମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ଆ଼ଟ୍‌ୱା ହିୟାଁତି ମେସାନା ଏ଼ୱାସି ମିଙ୍ଗେତାକି ଈ ହୁକୁମି ରା଼ଚାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ସାମା ମାଣ୍‌ସି ଗା଼ଡ଼ି ଆ଼ତି ବେ଼ଲାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଇୟା ଅ଼ଡ଼େ ଆ଼ବା କିହିଁ ମାହାପୂରୁ ଗା଼ଡ଼ିକିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ଏ଼ଦାଆଁତାକି ଆ଼ବା ତାଲି ତାଞ୍ଜିଇଁ ପିହ୍‌ନେସି, ଇଞ୍ଜାଁ ତାନି ଡକ୍ରି ତଲେ ଆଣ୍ତିନେସି, ");
INSERT INTO kxv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ଇଞ୍ଜାଁ ଏ଼ୱାରି ରିଆରି ଆ଼ଏ, ସାମା ରଣ୍ତିଏ ଆଙ୍ଗା ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଇଞ୍ଜାଁ ମାହାପୂରୁ ଏ଼ନାଆଁ ଆଣ୍ତ୍‌ୱି କିହାମାନେସି, ମାଣ୍‌ସି ଏ଼ଦାଆଁ ଏଟ୍‌କା କିଆପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଡା଼ୟୁ ସୀସୁୟାଁ ଇଜ ଈ କାତାତି ଜୀସୁଇଁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ତାନି ଡକ୍ରିନି ପିସାନା ଏଟ୍‌କାତାଣି ବୀହା ଆ଼ନେସି, ଏ଼ୱାସି ତଲିତି ଡକ୍ରିନି କ଼ପାଟି ଦା଼ରିକାମା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଅ଼ଡ଼େ ଡକ୍ରି ତାନି ଡକ୍ରାଇଁ ପିସାନା ଏଟ୍‌କାତାଣାଇଁ ବୀହା ଆ଼ନେ, ଆତିହିଁ ଏ଼ଦି ଦା଼ରିକାମା କିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଏ଼ୱାସି ଏ଼ନିକିଁ କକାରି ପ଼ଦାଁଣି ଡୀଗିନେସି, ଏ଼ଦାଆଁତାକି ଲ଼କୁ ଏ଼ୱାରାଇଁ ଜୀସୁ ତା଼ଣା ତାଚାଲି ମା଼ଟ୍‌ହେରି; ସାମା ସୀସୁୟାଁ ଏ଼ୱାରାଇଁ ଦାକା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଜୀସୁ ଏ଼ଦାଆଁ ମେସାଁ କାର୍‌ବି ଆ଼ହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “କକାରି ପ଼ଦାଁଣି ନା଼ ତା଼ଣା ୱା଼ହାଲି ହୀଦୁ, ଏ଼ୱାରାଇଁ ଆ଼ଂଗାଆଦୁ; ଇଚିହିଁ ମାହାପୂରୁତି ରା଼ଜି ଇଲେତି ଲ଼କୁତାୟି । ");
INSERT INTO kxv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ନା଼ନୁ ମିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି କକାରି ପ଼ଦାୟାଁ ଲେହେଁ ମାହାପୂରୁତି ରା଼ଜି ଆବଅସି, ଏ଼ୱାସି ଏ଼ନିଜିକେଏ ଏମ୍ବାଆଁ ହ଼ଡାଲି ଆ଼ଡଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ କଡାଣା ଜ଼ଙ୍ଗାନା ଏ଼ୱାରି ଲାକ କେୟୁ ଇଟାନା ବ଼ର ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ହାଜିମାଚାଟି ରଅସି ଦାବ୍‌ଡ଼ି ୱା଼ହାନା ଏ଼ୱାଣି ନ଼କିତା ମେଣ୍ତାକୁତାନା ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ଏ଼ ନେହିଁ ଗୂରୁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାଲି ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ନେହାଁତି ଇଞ୍ଜିଁ ଏ଼ନାଆଁତାକି ଏଲେଇଞ୍ଜି ମାଞ୍ଜାଦି ? ରଅଣି ପିସ୍‌ପେ ଇଚିହିଁ ମାହାପୂରୁ ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନେହାଁସି ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ନୀନୁ ସା଼ସ୍ତେରିତି ବାରେ ହୁକୁମିକା ପୁଞ୍ଜାମାଞ୍ଜି, ଲ଼କୁଣି ପା଼ୟାଆଦୁ, ଦା଼ରିକାମା କିଆଦୁ, ସ଼ରୁ କିଆଦୁ, ମିଚି ସା଼କି ଜ଼ଲାଆଦୁ, ଲ଼କୁଣି ନା଼ଡ଼ି କିଆଦୁ, ଇଞ୍ଜାଁ ତାଲି ତାଞ୍ଜିଇଁ ଜୀୱୁନ଼ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ଈ ବାରେ ନା଼ନୁ ଊଣା ୱେ଼ଡ଼ାଟିଏ ମା଼ନୱି ଆ଼ହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜୀସୁ ଏ଼ୱାଣାଇଁ ତୀରେ ସିନିକିହାଁ ଜୀୱୁ ନ଼ତେସି ଇଞ୍ଜାଁ ଏଲେଇଚେସି, “ନୀନୁ ର଼ କାମାତା ଊଣା ମାଞ୍ଜି, ନୀନୁ ହାଜାନା ନୀ ଦ଼ନ ବାରେ ପାର୍‌ଚାନାହାଁ ହିଲାଆ ଗାଟାରାକି ଦା଼ନା ହୀମୁ, ଅ଼ଡ଼େ ନା଼ ଜେ଼ଚ ୱା଼ମୁ, ଇଞ୍ଜାଁ ନୀନୁ ଲାକପୂରୁ ଦ଼ନ ବେଟାଆ଼ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ସାମା ଈ କାତାତା ଏ଼ୱାଣି ମୂମ୍ବୁ ହାପ୍‌ଲି ଆ଼ହାହାଚେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଦୁକୁ ଆ଼ହାନା ହାଚେସି, ଇଚିହିଁ ଏ଼ୱାଣାକି ହା଼ରେକା ଦ଼ନ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଏମ୍ବାଟିଏ ଜୀସୁ ସା଼ରିୱାକି ସିନିକିହାନା ତାନି ସୀସୁୟାଁଣି ଏଲେଇଚେସି, “ଦ଼ନ ଗାଟାରି ହା଼ରେକା କସ୍ତତଲେ ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡ଼୍‌ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଏ଼ୱାଣି କାତା ୱେଞ୍ଜାନା ସୀସୁୟାଁ କାବା ଆ଼ତେରି, ସାମା ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ କକାତେରି ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡ଼୍‌ନାୟି ହା଼ରେକା କସ୍ତ । ");
INSERT INTO kxv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ମାହାପୂରୁତି ରା଼ଜିତା ଦ଼ନ ଗାଟାରି ହ଼ଡ଼୍‌ନି କିହାଁ ସୂଜା କା଼ଣିଟି ଊଟୁ ହ଼ଡ଼୍‌ନାୟି ଊସାସା ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହା଼ରେକା କାବାଆ଼ହାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ କାତା ଆ଼ତେରି, “ଆତିହିଁ ଆମ୍ବାଆସି ଗେଲ୍‌ପି ଆ଼ହାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜୀସୁ ଏ଼ୱାରାଇଁ ତୀରିତଲେ ସିନିକିହାନା ଏଲେଇଚେସି, “ଈଦି ମାଣ୍‌ସିକି ଆ଼ଡାଆଗାଟାୟି, ସାମା ମାହାପୂରୁକି ଆ଼ଏ; ଇଚିହିଁ ମାହାପୂରୁ ବାରେ କିହାଲି ଆ଼ଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ମୁ ମା଼ମ୍ବୁ ବାରେ ପିସାନା ନୀ ଜେ଼ଚ ୱା଼ହାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମିନି ଲ଼କୁ ନା଼ ନେହିଁ କାବ୍ରୁତାକି ଇଲୁ କି ତାୟିକି ତାଙ୍ଗି କି ତାଲି, ତାଞ୍ଜି, କକାରି ପ଼ଦାଁଣି କି ବୂମି ବା଼ଡ଼ା ପିସାମାନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଅ଼ଡ଼େ ଈ କା଼ଲାତା କସ୍ତ ବେଟାଆ଼ହିଁ, ୱାଞ୍ଜା ଗୂଣୁତି ଇଲ୍‌କା, ତାୟି, ତାଙ୍ଗି, ତାଲି ତାଞ୍ଜି, କକାରି ପ଼ଦାୟାଁ ଅ଼ଡ଼େ ବୂମି ବା଼ଡ଼ା, ଇଞ୍ଜାଁ ୱା଼ନି ଜୁଗୁତା କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ଅସି, ଇଲେତି ଲ଼କୁ ଆମ୍ବାଆସି ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ସାମା ନ଼କିତା ମାନି ହା଼ରେକା ଲ଼କୁ ଡା଼ୟୁ ଆ଼ନେରି, ଇଞ୍ଜାଁ ଡା଼ୟୁ ମାନି ହା଼ରେକା ଲ଼କୁ ନ଼କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଏ଼ୱାରି ଜିରୁସାଲମତା ହାଜିମାଚାଟି ଜିରୁତା ମାଚେରି ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରି ନ଼କି ନ଼କିତା ହାଜିମାଚେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି କାବାଆ଼ହାନା ଡା଼ୟୁ ୱା଼ହିମାନି ଲ଼କୁ ଆଜାମାଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ୱେଣ୍ତେ ବା଼ରଜା଼ଣାତି ଏଟ୍‌କା କିହାନା ତାଙ୍ଗେତାକି ଏ଼ନା ଏ଼ନାୟି ଆ଼ହାଲି ହାଜିମାନେ, ଏ଼ ବାରେ ଏ଼ୱାରାଇଁ ୱେସାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜୀସୁ ଏଲେଇଚେସି, “ମେହ୍‌ଦୁ ମା଼ର ଜିରୁସାଲମତା ହାଜିମାନାୟି; ମାଣ୍‌ସି ମୀର୍‌ଏସି କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି କେୟୁତା ହେର୍‌ପିଆ଼ନେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ହା଼ନି ଡଣ୍ତ ହୀହାନା ଏଟ୍‌କା କୂଡ଼ାତାରି କେୟୁତା ହେର୍‌ପିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ କିଜୱି କିନେରି, ଏ଼ୱାଣିଲାକ ହୂପିନେରି, ଏ଼ୱାଣାଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ନେରି, ଇଞ୍ଜାଁ ପା଼ୟିନେରି, ଅ଼ଡ଼େ ତୀନି ଦିନାଟିଏ ୱେଣ୍ତେ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଡା଼ୟୁ ଜେବଦି ମୀର୍‌କା ଜାକୁବ ଅ଼ଡ଼େ ଜହନ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ମା଼ ଅଣ୍‌ପୁ ମା଼ମ୍ବୁ ନୀ ତା଼ଣାଟି ଏ଼ନାଆଁ ରୀହ୍‌ନମି ଏ଼ଦାଆଁ ମା଼ ତାକି ନୀନୁ କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ନା଼ନୁ ମୀ ତାକି ଏ଼ନାଆଁ କିଇଁ ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀନୁ ଗାୱୁରମିଗାଟି ରା଼ଜିତା କୁଗିସାରେ ଏ଼ନିକିଁ ମା଼ ବିତ୍ରାଟି ରଅତମି ନୀ ଟିଃନି ଟଟ ଅ଼ଡ଼େ ରଅତମି ନୀ ଟେ଼ବ୍ରି ଟଟ କୁଗିନମି ଈ ବ଼ର ମାଙ୍ଗେ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ରୀସିମାଞ୍ଜେରି ଏ଼ଦାଆଁ ପୁଞ୍ଜାହିଲଅତେରି । ନା଼ନୁ ଆମିନି ସ଼ଲାତା ଗସିମାଇଁ, ଏମ୍ବାଆଁ ମୀରୁ ଗସାଲି ଆ଼ଡିଦେରି ? ଇଞ୍ଜାଁ ନା଼ନୁ ଆମିନି ବାପ୍ତିସ୍ମତା ବାପ୍ତିସ୍ମ ଅ଼ହିମାଇଁ ଏମ୍ବାଆଁ ମୀରୁ ବାପ୍ତିସ୍ମ ଆ଼ହାଲି ଆ଼ଡିଦେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ଏ଼ୱାରି ଏଲେଇଚେରି, “ଆ଼ଡିନମି ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମିନି ସ଼ଲାତା ଗସିମାଇଁ ଏମ୍ବାଆଁ ଗସାଲି ଆ଼ଡିଦେରି, ଇଞ୍ଜାଁ ନା଼ନୁ ଆମିନି ବାପ୍ତିସ୍ମତା ବାପ୍ତିସ୍ମ ଆ଼ହିମାଇଁ ମୀରୁ ଏମ୍ବାଆଁ ବାପ୍ତିସ୍ମ ଆ଼ଦେରି; ");
INSERT INTO kxv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ସାମା ନା଼ ଟିଃନି ଅ଼ଡ଼େ ଟେ଼ବ୍ରିୱାକି କୁଗାଲି ହୀହାଲି ନା଼ ଅଦିକାରାତି କାତା ଆ଼ଏ, ଆମ୍ବାଆରାକି ମାହାପୂରୁ ଟା଼ୟୁ କେ଼ପାମାନେସି ଏ଼ୱାରି କୁଗିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଏଟ୍‌କାତି ଦସ ଜା଼ଣା ଈଦାଆଁ ୱେଞ୍ଜାନା ଜାକୁବ ଅ଼ଡ଼େ ଜହନଇଁ କାର୍‌ବି ଆ଼ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଆମିନି ଗାଟାରି ଏଟ୍‌କା କୂଡ଼ାତି ସା଼ଲୱି କିନାରି ଲେହେଁ ଆ଼ହାମାନେରି, ଏ଼ୱାରି ଲାକ ସା଼ଲୱି କିନେରି, ଅ଼ଡ଼େ ଏ଼ୱାରି କାଜାପା଼ଣା ଗାଟାରି ଏ଼ୱାରି ମୁହେଁ ସା଼ଲୱି କିନେରି, ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ସାମା ମୀ ବିତ୍ରା ଏଲେକିହିଁ ଆ଼ଏ; ସାମା ମୀ ବିତ୍ରା ଆମ୍ବାଆସି କାଜାସି ଆ଼ହାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସି ମୀ ସେ଼ବା କିପେସି, ");
INSERT INTO kxv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଅ଼ଡ଼େ ମୀ ବିତ୍ରା ଆମ୍ବାଆସି କାଜାସି ଆ଼ହାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସି ବାରେତି ହ଼ଲେଏସି ଆ଼ପେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଇଚିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ସେ଼ବା ବେଟାଆ଼ହାଲି ୱା଼ହାହିଲଅସି, ସାମା ସେ଼ବା କିହାଲି ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁଣି ପା଼ପୁଟି ପିସ୍‌ପି କିହାଲିତାକି ତାନି ଜୀୱୁ ହୀହାଲି ୱା଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ଡା଼ୟୁ ଏ଼ୱାରି ଜିରିହତା ଏଗାତେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ତାନି ସୀସୁୟାଁ ଇଞ୍ଜାଁ ମାନ୍ଦା ଲ଼କୁତଲେ ଜିରିହଟି ହାଜିମାନି ବେ଼ଲାତା ଟିମାୟ ମୀର୍‌ଏସି ବାର୍ଟିମୟ ଦ଼ରୁଗାଟି ର଼ କା଼ଣା, ରୀସ୍‌ପାଲି ଜିରୁ ଦାରିତା କୁଗାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ଏ଼ୱାସି ନା଼ଜରିତତି ଜୀସୁ, ଇମ୍ବାଟି ହାଜିମାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା ଏ଼ୱାସି କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଏ଼ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ଜୀସୁ ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ଏମ୍ବାଟିଏ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପାଲେଏ ଆ଼ହାଲି ଦାକା ହୀତେରି, ସାମା ଏ଼ୱାସି ଅ଼ଡ଼େ କାଜା ହା଼ଡାତଲେ ଏଲେଇଚେସି, “ଏ଼ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ଜୀସୁ ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ଏମ୍ବାଟିଏ ଜୀସୁ ନିଚାନା ଏଲେଇଚେସି, “ଏ଼ୱାଣାଇଁ ହା଼ଟାଦୁ ।” ଏ଼ୱାରି ଏ଼ କା଼ଣାଇଁ ହା଼ଟାନା ଏଲେଇଚେରି, “ସା଼ସା ଆ଼ହାନା ନିଙ୍ଗାମୁ, ଏ଼ୱାସି ନିଙ୍ଗେ ହା଼ଟିମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନିଙ୍ଗାନା ତାନି ହିମ୍ବରି କୁତାନା ଜୀସୁ ତା଼ଣା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେତାକି ଏ଼ନାଆଁ କିଇଁ ଇଞ୍ଜିଁ ନୀନୁ ଅଣ୍‌ପିମାଞ୍ଜି ?” ଏ଼ କା଼ଣା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ନା଼ନୁ ଏ଼ନିକିଁ ମେସାଲି ଆ଼ଡିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ହାଲାମୁ ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିୟାତେ ।” ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସି ମେସାଲି ଆ଼ଡିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜେ଼ଚ ଜେ଼ଚ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଏଚିବେ଼ଲା ଏ଼ୱାରି ଜିରୁସାଲମ ଡାଗେ ଆ଼ହାନା ଜୀତ ହ଼ରୁ ଡାଗେ ବେତ୍‌ପାଗି ଇଞ୍ଜାଁ ବେତନିୟାଁ ଡାଗେ ୱା଼ତେରି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରିଆରାଇଁ ଈ କାତା ୱେସା ପାଣ୍ତିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ମୀ ନ଼କିତା ମାନି ଏ଼ ନା଼ୟୁଁତା ହାଜୁ; ଏ଼ ନା଼ୟୁଁତା ହ଼ଡ଼୍‌ୱନିଏ ଆମିନି ଲାକ ଆମ୍ବାଆରି ଏଚେଲା ହ଼ଚା ହିଲଅରି ଇଲେତି ର଼ ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ଦସାମାନାଣି ମେହ୍‌ଦେରି; ଏ଼ଦାନି ହୁକ୍‌ହାନା ତାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଏ଼ନାଆଁ କିହିମାଞ୍ଜେରି ଇଞ୍ଜିଁ ମିଙ୍ଗେ ୱେଞ୍ଜାନେସି, ଆତିହିଁ ଏଲେଇଞ୍ଜୁ, ଈଦାଣି ତା଼ଣା ମା଼ ପ୍ରବୁକି ଲ଼ଡ଼ାମାନେ, ଅ଼ଡ଼େ ୱେଣ୍ତେ ଈଦାଣି ୱେ଼ଡ଼ାକିଆନା ପାଣ୍ତାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ଏ଼ୱାରି ହାଜାନା ଦୁୱେରିଦାରି ଆଂଗେଣିତା ର଼ ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ଦସାମାନାଣି ମେସାନା ଏ଼ଦାଣି ହୁକ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଏମ୍ବାଟିଏ ଏମ୍ବାଆଁ ନିଚାମାଚି ଲ଼କୁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ୱେଚେରି, “ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ପିସାନା ଏ଼ନାଆଁ କିହିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜୀସୁ ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଏ଼ୱାରି ଏଲେକିଁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେରି; ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ହେଲ ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଜୀସୁ ନ଼କିତା ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ତାଚାନା ଏ଼ୱାରି ଏ଼ଦାଣି ଲାକ ତାମି ହିମ୍ବରିକା ପା଼ସ୍ତେରି, ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ଦାନିଲେକ କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ଅ଼ଡ଼େ ହା଼ରେକା ଜିରୁତା ତାମି ହିମ୍ବରିକା ପା଼ସ୍ତେରି ଅ଼ଡ଼େ ଏଟ୍‌କାତାରି ଜା଼ଡ଼ାତି ଗଚାୟାଁ ଟୂଣ୍‌ହା ତାଚାନା ପା଼ସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଇଞ୍ଜାଁ ନ଼କିତା ଡା଼ୟୁୱାକି ହାଜିମାନି ଲ଼କୁ କାଜା ହା଼ଡାତଲେ ଏଲେଇଚେରି, “ହ଼ସାନା ମାହାପୂରୁ ଦ଼ରୁଟି ଆମ୍ବାଆସି ୱା଼ହିମାନେସି, ଏ଼ୱାସି ନେହାଁସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ମା଼ ଆକୁ ଦାୱୁଦତି ଆମିନି ରା଼ଜି ୱା଼ହିମାନେ, ଏ଼ଦି ଜହରା, ଲାକପୂରୁତି ହ଼ସାନା ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଡା଼ୟୁ ଜୀସୁ ଜିରୁସାଲମତା ୱା଼ହାନା ମାହାପୂରୁ ଇଲୁତା ହାଚେସି, ଇଞ୍ଜାଁ ସା଼ରିୱାକି ମାନାଣି ବାରେ ସିନିକିହାନା ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ତଲେ ବେତନିୟାଁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ତାନି ଅ଼ର ଦିନା ବେତନିୟାଁଟି ୱା଼ହିମାଚାଟି ଜୀସୁ ହାକି ଆ଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଇଞ୍ଜାଁ ହେକଟି ଆ଼କା ମାନି ର଼ ତ଼ୟା ମା଼ର୍‌ନୁତି ଆ଼କା ମେସାନା ଏମ୍ବାଆଁ ପା଼ଡ଼େୟି ବେଟାଆ଼ନି ଆ଼ସା ତଲେ ଡାଗେ ହାଚେସି । ସାମା ଡାଗେ ୱା଼ହାନା ଏ଼ୱାସି ଆ଼କା ପିସ୍‌ପେ ଅ଼ଡ଼େ ଏ଼ନାଆଁ ପ୍ଣାଃଆତେସି, ଇଚିହିଁ ଏ଼ଦି ତ଼ୟା ଆ଼ୟିନି ୱେ଼ଡ଼ା ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ଦାଣି ଏଲେଇଚେସି, “ନୀ ପା଼ଡ଼େୟି ଲ଼କୁ ଏଚେଲା ତିନାଆପେରି ।” ଏ଼ୱାଣି କାତା ତାମି ସୀସୁୟାଁ ୱେଞ୍ଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ଡା଼ୟୁ ଏ଼ୱାରି ଜିରୁସାଲମତା ୱା଼ତେରି, ଅ଼ଡ଼େ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଏ଼ ଟା଼ୟୁତା ବେ଼ବାରା କିହିମାଚି ଲ଼କୁଣି ପାଙ୍ଗାତା ପେ଼ର୍‌ହାଲି ମା଼ଟ୍‌ହେସି, ଇଞ୍ଜାଁ ଟାକାୟାଁ ବେ଼ବାରା ଗାଟାରି କୁର୍ଚିୟାଁ ଅ଼ଡ଼େ ପଟାୟାଁ ବେ଼ବାରା କୁର୍ଚିୟାଁ ତିରିମ୍ଣିପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଇଞ୍ଜାଁ ପ୍ରା଼ତାନା ଇଲୁ ବିତ୍ରାଟି ଆମ୍ବାଆରାକି ଏ଼ନାଆଁ ଅ଼ହାଲି ତାଚାଲି ହେଲ ହୀଆତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଡା଼ୟୁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଜା଼ପ୍‌ହିହିଁ ଏଲେଇଚେସି, “ଦାର୍ମୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନା଼ ଇଲୁ ବାରେ କୂଡ଼ାତି ଲ଼କୁତାକି ପ୍ରା଼ତାନା ଇଲୁ ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେ ? ସାମା ମୀରୁ ଏ଼ଦାଆଁ ଡଂଗାଁୟାଁ ପା଼ୱୁ କିହାମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ଈ କାତା ୱେଞ୍ଜାନା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଏ଼ୱାଣାଇଁ ଏ଼ନିକିଁ ନା଼ସା କିହାଲି ଆ଼ଡିନେରି, ଏ଼ଦାଆଁ ପାରୁ ପାରାଲି ମା଼ଟ୍‌ହେରି; ଇଚିହିଁ ଲ଼କୁ ଏ଼ୱାଣି ଜା଼ପ୍‌ନି ତା଼ଣା କାବା ଆ଼ହିମାଚାକି ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଏ଼ ଦିନା ମିଡ଼୍‌ଅଲା ବେ଼ଲା ଜୀସୁ ଅ଼ଡ଼େ ସୀସୁୟାଁ ଗା଼ଡ଼ାଟି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ଅ଼ର ଦିନା ଲା଼ଇଏ ଏ଼ ଜିରୁଟି ହାଜିମାଚାଟି ଏ଼ୱାରି ତ଼ୟା ମା଼ର୍‌ନୁ ଡାକିଟିଏ ୱା଼ୟିତାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ଏମ୍ବାଟିଏ ପିତର ତଲିତି କାତା ଅଣ୍‌ପାନା ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ମେହ୍‌ମୁ ନୀନୁ ଆମିନି ତ଼ୟା ମା଼ର୍‌ନୁତି ବା଼କା ହୀହାମାଚି ଏ଼ଦି ୱା଼ୟାହାଚେୟିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ତା଼ଣା ନାମାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ଈ ହ଼ରୁତି ନୀନୁ ନିଙ୍ଗାନା ସାମ୍‌ଦୁରିତା ତର୍‌ଗାମୁ ଇନେସି, ଇଞ୍ଜାଁ ତାନି ହିୟାଁତା ଆନାମାନା ଆ଼ଆନା, ଏ଼ନାଆଁ ଜ଼ଲିମାଇଁ ଏ଼ଦି ଆ଼ନେ ଇଞ୍ଜିଁ ନାମିନେସି, ଏ଼ୱାଣାକି ଏ଼ଦି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଏ଼ନାଆଁ ପ୍ରା଼ତାନା କିଦେରି ଅ଼ଡ଼େ ରୀହ୍‌ଦେରି, ଏ଼ ବାରେ ମିଙ୍ଗେ ମେ଼ଡ଼ା ଆୟାତେ ଇଞ୍ଜିଁ ନାମାଦୁ, ଏଚେଟିଏ ଏ଼ ବାରେ ସାତେଏ ବେଟାଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଇଞ୍ଜାଁ ମୀରୁ ଆମିନି ବେ଼ଲାତା ପ୍ରା଼ତାନା କିହାଲି ନିଦେରି, ଇଞ୍ଜାଁ ଆମ୍ବାଆରି କ଼ପାଟି ଏ଼ନି କାତା ମାଚିହିଁ, ଏ଼ୱାଣି ପା଼ପୁ ମ୍ଣେକ୍‌ଦୁ, ଏ଼ନିକିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ଜିକେଏ ମୀ ପା଼ପୁତି ମ୍ଣେକ୍‌ହାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ସାମା ମୀରୁ ଏ଼ୱାଣି ପା଼ପୁ ମ୍ଣେକ୍‌ଅତେରି, ଆତିହିଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ଜିକେଏ ମୀ ବାରେ ପା଼ପୁତି ମ୍ଣେକ୍‌ହଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଡା଼ୟୁ ଏ଼ୱାରି ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜିରୁସାଲମତା ୱା଼ତେରି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ପ୍ରା଼ତାନା ଇଲୁତା ହ଼ଡିମାଚି ବେ଼ଲାତା କାଜା ପୂଜେରାଙ୍ଗା ମେ଼ରାପୁନାରି ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗା ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ନୀନୁ ଆମିନି ଅଦିକାରା ତଲେ ଈ ବାରେ କିହିମାଞ୍ଜି ? ଇଞ୍ଜାଁ ଈ ବାରେ କିହାଲି ଆମ୍ବାଆସି ଈ ଅଦିକାରା ହିୟାତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ର଼ କାତା ୱେଞ୍ଜାଇଁ, ନାଙ୍ଗେ ୱେସ୍ତାଦୁ, ଆତିହିଁ ନା଼ନୁ ଆମିନି ଅଦିକାରା ତଲେ କିହିମାଇଁ, ଏ଼ଦାଆଁ ମିଙ୍ଗେ ୱେସ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜହନତି ବାପ୍ତିସ୍ମ ଲାକପୂରୁଟି କି ମାଣ୍‌ସିୟାଁ ତା଼ଣାଟି ଆ଼ହାମାଚେ ? ଏ଼ଦାଆଁ ନାଙ୍ଗେ ୱେସ୍ତାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ଏଚେଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ କାତା ଆ଼ହାଲି ମା଼ଟ୍‌ହେରି, “ଲାକପୂରୁଟି ଇନାୟି, ଆତିହିଁ ଏ଼ୱାସି ଏଲେଇଞ୍ଜାନେସି ମୀରୁ ଏ଼ନାଆଁତାକି ଏ଼ୱାଣାଇଁ ନାମାଆତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଅ଼ଡ଼େ ମାଣ୍‌ସି ତା଼ଣାଟି ଇନାୟି, ଏ଼ୱାରି ଲ଼କୁଣି ଆଜିମାଚେରି; ଇଚିହିଁ ବାରେଜା଼ଣା ଜହନ ସାତା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଇଞ୍ଜିଁ ମା଼ନୱି ଆ଼ହିମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ଏ଼ଦାଆଁତାକି ଜୀସୁଇଁ ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମିନି ଅଦିକାରା ତଲେ କିହିମାଇଁ ଏ଼ଦାଆଁ ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ୱେସ୍ତଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସାଲି ମା଼ଟ୍‌ହେସି, “ରଅସି ର଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ା କିହାନା ବା଼ଡ଼ା ସା଼ରିୱାକି ବେୟିଁ ଗୂର୍‌ତେସି, ଇଞ୍ଜାଁ ଅଙ୍ଗୁରି ପା଼ଡ଼େୟି ପୀଚାଲି ର଼ ଗା଼ଡ଼୍‌ୟୁ କା଼ର୍‌ହାନା ଏମ୍ବାଆଁ କା଼ଃଆନାରାକି କା଼ଃଆନି ଇଲୁ କେ଼ପିତେସି, ଇଞ୍ଜାଁ କାମା କିନାରାକି ଏ଼ ବା଼ଡ଼ା ବା଼ଗା ହୀହାନା ହେକ ରା଼ଜି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ଡା଼ୟୁ କାମାକିନାରି ତା଼ଣାଟି ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ପା଼ଡ଼େୟି ବା଼ଗା ବେଟାଆ଼ହାଲି ଏ଼ୱାସି ର଼ ହ଼ଲେଏଣାଇଁ ପା଼ଡ଼େୟି କାମ୍ବିନିୱେଡ଼ା ଏ଼ୱାରିତା଼ଣା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆସାନା ୱେ଼ତେରି ଇଞ୍ଜାଁ ୱାର୍‌ଇ କେୟୁଟି ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ଏ଼ୱାସି ଅ଼ଡ଼େ ଏ଼ୱାରିତା଼ଣା ଅ଼ଡ଼େ ର଼ ହ଼ଲେଏଣାଇଁ ପାଣ୍ତିତେସି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜିକେଏ ତା଼ର୍ୟୁଁ ଡ଼ାୟେ ୱେ଼ଚାନା ହୀଣି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ଏ଼ୱାସି ଅ଼ଡ଼େ ରଅଣାଇଁ ପାଣ୍ତିତେସି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜିକେଏ ପା଼ୟିତେରି, ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଅ଼ଡ଼େ ହା଼ରେକା ଜା଼ଣାତି ପାଣ୍ତିତେସି; ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣାତି ୱେ଼ତେରି ଇଞ୍ଜାଁ ଏଚରଜା଼ଣାତି ପା଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ତାନି ତା଼ଣା ରଅସିଏ ଡ଼ୟିତେସି, ଏ଼ୱାସି ତାନି ଜୀୱୁତି ମୀର୍‌ଏସି, ଡା଼ୟୁ ଅଣ୍‌ପିତେସି ‘ଏ଼ୱାରି ନା଼ ମୀର୍‌ଏଣାଇଁ ମା଼ନି କିନେରି’ ଇଞ୍ଜିଁ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ସାମା ଏ଼ କାମାକିନାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ କାତା ଆ଼ତେରି, ‘ଈୱାସିତ ଅଦିକାରା ଗାଟାସି, ୱା଼ଦୁ ଈୱାଣାଇଁ ପା଼ୟିନ; ଆତିହିଁ ବା଼ଡ଼ାତି ଅଦିକାରା ମା଼ଦି ଆ଼ନେ ।’ ");
INSERT INTO kxv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆସାନା ପା଼ୟିତେରି ଇଞ୍ଜାଁ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ପାଙ୍ଗାତା ମେତ୍‌ହାତୁସ୍ତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ୱେସ୍ତାଦୁ, ଈଦାଆଁ ଡା଼ୟୁ ଏ଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ସା଼ୱୁକାରି ଏ଼ନାଆଁ କିନେସି ? ଏ଼ୱାସି ୱା଼ହାନା କାମା କିନାରାଇଁ ନା଼ସା କିନେସି ଇଞ୍ଜାଁ ଏଟ୍‌କାତି କାମା କିନାରାକି ଏ଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ା ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ମୀରୁ ଦାର୍ମୁ ପତିତା ଈ କାତା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି ? ଇଲୁ କେ଼ପିନାରି ଆମିନି ୱାଲିତି ମିଣ୍‌ଏ ଇଞ୍ଜିଁ ଅ଼ପାଆତେରି, ଏ଼ଦିଏ ଇଲୁତି ମୂଲୁ ୱାଲି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ମାହାପୂରୁ ତା଼ଣାଟି ଈଦି ଆ଼ତେ, ଇଞ୍ଜାଁ ଏ଼ଦି ମା଼ କାନୁତାକି ର଼ କାବା ଆ଼ନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଏଚେଟିଏ ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ଏ଼ୱାଣାଇଁ ଆସାଲି ଅଣ୍‌ପିମାଚେରି, ସାମା ଏ଼ୱାରି ଲ଼କୁଣି ଆଜିତେରି; ଇଚିହିଁ ଏ଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଏ଼ୱାରାଇଁ ସିନିକିହାନା ୱେସିମାଚେସି ଇଞ୍ଜିଁ ପୁଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପିସାନା ହାଜାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ଡା଼ୟୁ ଜୀସୁ କାତାତି ଦ଼ହ ଆସାଲି ତାକି ଏ଼ୱାରି ପାରୁସି ଅ଼ଡ଼େ ହେରଦ ଗଚିତି ଏଚେକା ଲ଼କୁଣି ଏ଼ୱାଣି ତା଼ଣା ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ଏ଼ୱାରି ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି, ନୀନୁ ସାତା କାତା ୱେହ୍‌ନାତି ଅ଼ଡ଼େ ଆମ୍ବାଆରାଇଁ ଆଜାଆ ଗାଟାତି; ଇଚିହିଁ ନୀନୁ ମାଣ୍‌ସିତି ମୂମ୍ବୁ ମେସାନା ଜ଼ଲାଆ ଗାଟାତି ଇଞ୍ଜାଁ ସାତା ତଲେ ମାହାପୂରୁତି ଜିରୁ ଜା଼ପ୍‌ନାତି, କାୟିସରକି ସିସ୍ତୁ ହୀନାୟି ମେ଼ରା କି ଆ଼ଏ, ମା଼ମ୍ବୁ ହୀନମି କି ଆ଼ଏ ?” ");
INSERT INTO kxv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ସାମା ଏ଼ୱାସି ଏ଼ୱାରି କାର୍‌ବିତି ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ତାୟିପାରି କିହିମାଞ୍ଜାଦେରି ? ର଼ ୱେଣ୍ତି ଟାକା ନା଼ ତା଼ଣା ତାଦୁ ନା଼ନୁ ଏ଼ଦାଆଁ ସିନିକିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ଦାଆଁ ତାତେରି, ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଈ ବମା ଅ଼ଡ଼େ ଦ଼ରୁ ଆମ୍ବାଆରାୱାୟି ?” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “କାୟିସରୱାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “କାୟିସରୱାୟି ଏ଼ନାୟି ଏ଼ଦାଆଁ କାୟିସରକି ହୀଦୁ; ଇଞ୍ଜାଁ ମାହାପୂରୁୱାୟି ଏ଼ନାୟି ଏ଼ଦାଆଁ ମାହାପୂରୁକି ହୀଦୁ ।” ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣି କାତାତାକି କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଏମ୍ବାଟିଏ ହା଼କିଟି ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ହିଲେଏ ଇଞ୍ଜିମାନି ସାଦୁକି ଲ଼କୁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ଼ ଗୂରୁ ମ଼ସା ମାଙ୍ଗେତାକି ରା଼ଚାମାନେସି, ଇଚିହିଁ ଆମ୍ବାଆରି ତାୟି ହା଼ନେସି ଇଞ୍ଜାଁ ତାନି ଡକ୍ରି ନୀଡାମାନେ ଇଞ୍ଜାଁ ଏ଼ଦାନି ଏ଼ନି କକାରି ପ଼ଦାୟାଁ ହିଲାଉ ଆତିହିଁ ତାନି ତାୟି ତାନି ଡକ୍ରିନି ଇଟାନା ତାନି ତାୟିକି କୂଡ଼ା ଏ଼ପାକିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ମେହ୍‌ମୁ ସା଼ତା ଜା଼ଣା ତାୟିୟାଁ ମାଚେରି; କାଜାସି ର଼ ଆୟାନି ବୀହା ଆ଼ତେସି, ଇଞ୍ଜାଁ କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ଏ଼ୱାଣି ଜେ଼ଚତାସି ଏ଼ ଇୟାନି ଇଟିତେସି ଇଞ୍ଜାଁ କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତେସି; ଅ଼ଡ଼େ ଜେ଼ଚତାସି ଏଲେକିତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଇଞ୍ଜାଁ ସା଼ତା ଜା଼ଣା ଜିକେଏ କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତେରି; ବାରେତି ଡା଼ୟୁ ଏ଼ ଇୟା ଜିକେଏ ହା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ୱେଣ୍ତେ ନିଙ୍ଗିନି ବେ଼ଲାତା ଏଚିବେ଼ଲା ଏ଼ୱାରି ନିଙ୍ଗିନେରି, ଏଚିବେ଼ଲା ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆରି ଡକ୍ରି ଆ଼ନେ ? ସା଼ତା ଜା଼ଣା ଜିକେଏ ଇଟାମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହା଼ରେକା ନା଼ଡ଼ିକିନି ଅଣ୍‌ପୁ ମାନେ । ଦାର୍ମୁ ସା଼ସ୍ତେରି, ଇଞ୍ଜାଁ ମାହାପୂରୁତି ବା଼ଡ଼୍‌ୟୁତି କାତା ପୁଞ୍ଜାହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ହା଼ତାରି ନିଙ୍ଗିତି ଡା଼ୟୁ ଲ଼କୁ ବୀହା ଆ଼ଅରି କି ବୀହା ହୀଅରି, ସାମା ଲାକପୂରୁତି ଦୂତୁୟାଁଲେହେଁ ଡ଼ୟିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ଇଞ୍ଜାଁ ହା଼ତାରି ନିଙ୍ଗିନେରି ଏ଼ କାତାତି ମୀରୁ ମ଼ସା ରା଼ଚିତି ପତିତା ୱେହିମାନି ବୂଟାତି କାବ୍ରୁ ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି କି ? ମାହାପୂରୁ ଏ଼ନିକିଁ ଏଲେଇଞ୍ଜା ମାନେସି, ‘ନା଼ନୁ ଅବ୍ରାହାମତି ମାହାପୂରୁ, ଇସାହାକତି ମାହାପୂରୁ, ଅ଼ଡ଼େ ଜାକୁବତି ମାହାପୂରୁତେଏଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ଏ଼ୱାସି ହା଼ତାରି ମାହାପୂରୁ ଆ଼ଏ, ସାମା ଜୀୱୁଗାଟାରି ମାହାପୂରୁ ମୀରୁ ହା଼ରେକା ନା଼ଡ଼ିକିୱି ଆ଼ହାମାଞ୍ଜରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ଏଚିବେ଼ଲା ର଼ ମେ଼ରା ଜା଼ପ୍‌ନାସି ଡାଗେ ୱା଼ହାନା ଏ଼ୱାରି ବା଼ଦିବା଼ଦା ଆ଼ହିମାଚାଣି ୱେଞ୍ଜାନା ଅ଼ଡ଼େ ଜୀସୁ ସାଦୁକି ଲ଼କୁଇଁ ସମାନା କାତା ୱେଣ୍ତେ ୱେସିମାଚାଣି ୱେଞ୍ଜାନା ଜୀସୁଇଁ ୱେଚେସି, “ଆମିନି ହୁକୁମି ଦାର୍ମୁପତିତା ବାରେକିହାଁ କାଜାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜୀସୁ ଏଲେଇଚେସି, “କାଜା ହୁକୁମି ଈଦି ‘ଏ଼ ଇସ୍ରାୟେଲ ୱେଞ୍ଜୁ; ପ୍ରବୁ ମା଼ ମାହାପୂରୁ ରଣ୍ତିଏ ପ୍ରବୁ ମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଅ଼ଡ଼େ ନୀନୁ ନୀ ବାରେ ହିୟାଁ ବାରେ ଜୀୱୁ ମ଼ନ ହୀହାନା ଅ଼ଡ଼େ ବାରେ ବା଼ଡ଼୍‌ୟୁ ତଲେ ପ୍ରବୁ ନୀ ମାହାପୂରୁଇଁ ଜୀୱୁ ନ଼ମୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଅ଼ଡ଼େ ରଣ୍ତି ଈଦି ନୀନୁ ନୀ ପା଼ଡ଼ିତାଣାଇଁ ନୀ ଜାହାରାଲେହେଁ ଜୀୱୁ ନ଼ମୁ । ଈ ହୁକୁମିକା ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମିନି କାଜା ହୁକୁମି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଏମ୍ବାଟିଏ ଏ଼ ମେ଼ରା ପୁନାସି ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ଏ଼ଦି ସାତା ମାହାପୂରୁ ରଅସିଏ ଇଞ୍ଜାଁ ଏ଼ୱାଣି ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆସି ହିଲଅସି, ଏ଼ଦାଆଁ ନୀନୁ ନେହିଁକିଁ ୱେସ୍ତାତି; ");
INSERT INTO kxv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଇଞ୍ଜାଁ ବାରେ ହିୟାଁ, ବାରେ ବୁଦି, ବାରେ ବା଼ଡ଼୍‌ୟୁ ହୀହାନା ଏ଼ୱାଣାଇଁ ଜୀୱୁନ଼ନାୟି ଇଞ୍ଜାଁ ପା଼ଡ଼ିତାଣାଇଁ ମା଼ ଜାହାରାଲେହେଁ ଜୀୱୁନ଼ନାୟି ବାରେ ଜ଼ନ୍ତତି ପୂଜା ହୀନି କିହାଁ କାଜାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ଏ଼ୱାସି ବୁଦିତଲେ ଜ଼ଲାମାଞ୍ଜାନେସି ଇଞ୍ଜିଁ ମେସାନା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁତି ରା଼ଜିଟି ନୀନୁ ହେକ ହିଲଅତି । ଏଚେଟିଏ ଆମ୍ବାଆସି ଜୀସୁଇଁ ଏ଼ନାଆଁ ୱେଞ୍ଜାଲି ସା଼ସା କିଆତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ସାମା ଜୀସୁ ପ୍ରା଼ତାନା ଇଲୁତା ଜା଼ପ୍‌ହି ମାଚିବେ଼ଲାତା ଏଲେଇଚେସି, “କ୍ରୀସ୍ତ ଦାୱୁଦ ମୀର୍‌ଏସି, ଈଦାଆଁ ମେ଼ରାପୁନାରି ଏ଼ନିକିଁ ଏଲେଇନେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ତା଼ନୁଏ ଦାୱୁଦ ମାହାପୂରୁତି ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାନା ୱେସାମାଚେସି, ‘ପ୍ରବୁ ନା଼ ପ୍ରବୁଇଁ ଏଲେଇଚେସି, ନା଼ନୁ ଏଚେ ପାତେକା ନୀ ସାତ୍ରୁୟାଁଇଁ ନୀ କଡାଁ ଡ଼଼ଇ କିହାହିଲଅଁ, ଏଚେ ପାତେକା ନା଼ ଟିଃନିୱାକି କୁଗାମାନାମୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଦାୱୁଦ ତା଼ନୁଏ ଏ଼ୱାଣାଇଁ ପ୍ରବୁ ଇଞ୍ଜିମାନେସି; ଆତିହିଁ ଏ଼ୱାସି ଏ଼ନିକିଁ ଦାୱୁଦ ମୀର୍‌ଏସି ।” । ");
INSERT INTO kxv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ମାନ୍ଦା ଲ଼କୁ ରା଼ହାଁଟି ତାନି କାତା ୱେଞ୍ଜିମାଚେରି, ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାସି ତାନି ଜା଼ପ୍‌ହି ମାଚି କାତାତା ଏଲେଇଚେସି, “ମେ଼ରାପୁନାରି ତା଼ଣାଟି ଜାଗ୍ରାତା, ଏ଼ୱାରି ଲାମ୍ବା ହିମ୍ବରିକା ହୁଚାନା ରେ଼ଜାଲି ଇଞ୍ଜାଁ ହା଼ଟା ବାଜାରାତା ଜହରା ବେଟାଆ଼ହାଲି ରା଼ହାଁ ଆ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା କାଜା କୁର୍ଚି, ବ଼ଜିତା ନେହିଁ ଟା଼ୟୁତା କୁଗାଲି ପାରିନେରି; ");
INSERT INTO kxv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ଏ଼ୱାରି ରା଼ଣ୍ତେଣିସିକା ଇଲ୍‌କା ସେନ୍ଦିନେରି, ଲ଼କୁଣି ତ଼ସାଲି ଲାମ୍ବା ପ୍ରା଼ତାନା କିନେରି; ଏ଼ୱାରି ହା଼ରେକା ଡଣ୍ତ ବେଟାଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଡା଼ୟୁ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତି ଦା଼ନା ପେ଼ଡ଼ା ଡାଗେ କୁଗାନା ଲ଼କୁ ଏମ୍ବାଆଁ ଏ଼ନିକିଁ ଦା଼ନା ହୀହିମାନେରି, ଏ଼ଦାଆଁ ସିନିକିହିମାଚେସି । ଏଚିବେ଼ଲାତା ହା଼ରେକା ଦ଼ନ ଗାଟାରି ଗାଡି ମେତ୍‌ହେରି; ");
INSERT INTO kxv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଅ଼ଡ଼େ ର଼ ହାକି କା଼କୁଲିଗାଟି ରା଼ଣ୍ତେଣି ଇୟା ୱା଼ହାନା ରୀ ଊଣା ତାମ୍ବାତି ଆଦ୍‌ଲି ଏ଼ ପେ଼ଡ଼ାତା ମେତ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ଏଚେଟିଏ ଜୀସୁ ତାନି ସୀସୁଣି ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଦା଼ନା ପେ଼ଡ଼ାତା ଟାକାୟାଁ ମେତ୍‌ହିମାନି ବାରେ ଲ଼କୁ କିହାଁ ଈ ହାକି କା଼କୁଲିଗାଟି ରା଼ଣ୍ତେଣି ଇୟା ଗାଡି ମେତ୍‌ହାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଇଚିହିଁ ବାରେଜା଼ଣା ତାମି ହା଼ରେକା ଦ଼ନଟି ଇଚାଣି ମେତ୍‌ହା ମାନେରି, ସାମା ଈଦି ତାନି ହିଲାଆବେ଼ଲାତା ତାଙ୍ଗେ ନୀଡାଲି ତାଙ୍ଗେ ଏ଼ନାୟି ମାଚେ, ଏ଼ ବାରେ ମେତ୍‌ହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜୀସୁ ମାହାପୂରୁ ଇଲୁଟି ହାଜିମାଚାଟି ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ମେହ୍‌ମୁ ଏ଼ନିଲେହେଁତି ଅ଼ଜିତି ୱାଲ୍‌କା ଅ଼ଡ଼େ ଏ଼ନିଲେହେଁତି ଅ଼ଜିତି ମେ଼ଡ଼ା ଇଲ୍‌କା !” ");
INSERT INTO kxv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ଈ କାଜା ମେ଼ଡ଼ା ମେସିମାଞ୍ଜି ? ର଼ ୱାଲି ଅ଼ର ୱାଲି ଲାକ ଡ଼ୟେଏ, ବାରେ ମେଣ୍‌ଙ୍ଗାହାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଡା଼ୟୁ ପ୍ରା଼ତାନା ଇଲୁ ନ଼କିତା ମାନି ଜୀତ ହ଼ରୁ ଲାକ କୁଗାଲିଏ ପିତର, ଜାକୁବ, ଜହନ, ଅ଼ଡ଼େ ଆନ୍ଦ୍ରିୟ ତାନି ତା଼ଣା ମେ଼ଣେଏ ୱା଼ହାନା ୱେଚେରି, “ଈ ବାରେ ଏଚେଲା ଆ଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ଅ଼ଡ଼େ ଆମିନି ବେ଼ଲାତା ଈ ବାରେ ଗଟୱି ଆ଼ନେ ଏ଼ ବେ଼ଲାତି ସିନା ଏ଼ନାୟି, ଏ଼ଦାଆଁ ମାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଜାଗ୍ରାତା, ଆମ୍ବାଆସି ଏ଼ନିକିଁ ମିଙ୍ଗେ ନା଼ଡ଼ି କିୟଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ହା଼ରେକା ନା଼ ଦ଼ରୁତଲେ ୱା଼ହାନା, ‘ନା଼ନୁ ଏ଼ୱାତେଏଁ’ ଇଞ୍ଜିଁ ହା଼ରେକା ଲ଼କୁଣି ନା଼ଡ଼ି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ସାମା ମୀରୁ ଏଚିବେ଼ଲା ଜୁଜୁତି କାତା ଅ଼ଡ଼େ ଗଡ଼୍‌ହାତି ହା଼ଡା ୱେଞ୍ଜେରି, ଏଚିବେ଼ଲା କିଲିବିଲି ଆ଼ଆଦୁ; ଏ଼ ବାରେ ଆ଼ନାୟି ମାନେ, ସାମା ଏ଼ କା଼ଲା ଜିକେଏ ଜୁଗୁ ରା଼ନାୟି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଇଚିହିଁ ଦେ଼ସା କ଼ପାଟି ଦେ଼ସା, ରା଼ଜି କ଼ପାଟି ରା଼ଜି ନିଙ୍ଗିନେ, ବାରେୱାକି ବୂମି ୱୀଡିନେ ଅ଼ଡ଼େ କା଼ତାରା ଆ଼ନେ; ଈ ବାରେ କକାରି ପ଼ଦାୟାଁ ଆ଼ନାଟି ଲୁଞ୍ଜିନି ବୀସା ଲେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ସାମା ମୀରୁ ମିଙ୍ଗେ ତାକି ଜାଗ୍ରାତା ଆ଼ହାମାଞ୍ଜୁ; ଲ଼କୁ ମିଙ୍ଗେ ନୀହାଁୟି କିନି ତା଼ଣା ଦସାନା ଅୟାନେରି, ଅ଼ଡ଼େ ମିଙ୍ଗେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ୱେ଼ତାନେରି, ଇଞ୍ଜାଁ ନା଼ ତାକି ସା଼ଲୱି କିନାରି ତା଼ଣା ରାଜାୟାଁ ନ଼କିତା ନିଦେରି, ଏ଼ୱାରି ନ଼କିତା ସା଼କି ଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଇଞ୍ଜାଁ ବାରେ କୂଡ଼ା ନ଼କିତା ନେହିଁ କାବ୍ରୁ ନ଼କେଏ ୱେସ୍‌ପି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ଇଞ୍ଜାଁ ଏଚିବେ଼ଲା ଲ଼କୁ ମିଙ୍ଗେ ଅ଼ହାନା ହେର୍‌ପାନେରି, ଏଚିବେ଼ଲା ମୀରୁ ଏ଼ନାଆଁ ଜ଼ଲିଦେରି, ଏ଼ କାତା ନ଼କେଏ ଅଣ୍‌ପାଆଦୁ, ସାମା ଏ଼ ବେ଼ଲାତା ମିଙ୍ଗେ ଏ଼ନାଆଁ ଜ଼ଲାଲି ହୀପ୍‌କିଆ଼ନେ ଏ଼ଦାଆଁ ୱେହ୍‌ଦୁ; ଇଚିହିଁ ମୀରୁ ଜ଼ଲିନାତେରି ଆ଼ଏ ସାମା ସୁଦୁଜୀୱୁ ଜ଼ଲିନାୟି । ");
INSERT INTO kxv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ତାୟି ତାୟିଇଁ ଅ଼ଡ଼େ ତାଞ୍ଜି ମୀର୍‌ଏଣାଇଁ ହା଼ହାଲି ତାକି ହେର୍‌ପିନେରି; ଇଞ୍ଜାଁ ମୀର୍‌କା ତାଲି ତାଞ୍ଜି କ଼ପାଟି ନିଙ୍ଗାନା ଏ଼ୱାରାଇଁ ପା଼ୟିନେରି; ");
INSERT INTO kxv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ଅ଼ଡ଼େ ନାଙ୍ଗେତାକି ବାରେ ଲ଼କୁ ମିଙ୍ଗେ ଅ଼ପଅରି; ସାମା ଆମ୍ବାଆସି ରା଼ନି ପାତେକା ସା଼ସା ଆସାନା ଡ଼ୟିନେସି ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ମୀରୁ ଏଚିବେ଼ଲା ଏ଼ ନା଼ସାକିନି ଅ଼ପାଆଗାଟି ଆ଼ସ୍ତି ଆମିନି ତା଼ଣା ଡ଼ୟିନି କାତା ହିଲେଏ, ଏମ୍ବାଆଁ ଡ଼ୟାମାନାଣି ମେହ୍‌ଦେରି (ପ଼ଡ଼ୱି ଆ଼ନାରି ତେଲ୍‌ହାପେରି) ଏଚିବେ଼ଲା ଆମ୍ବାଆରି ଜୀହୁଦା ଦେ଼ସାତା ମାନେରି, ଏ଼ୱାରି ହ଼ର୍‌କାଣା ହଣ୍‌ପେରି; ");
INSERT INTO kxv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଆମ୍ବାଆସି ଇଲୁ ଲାକ ମାନେସି, ଏ଼ୱାସି ଇଲୁ ବିତ୍ରା ୱା଼ହାନା ଏ଼ନି ଦିଣ୍‌ସୁ ଅ଼ହାଲି ରେ଼ଚା ୱା଼ଆପେସି କି ବିତ୍ରା ହାଲାଆପେସି; ");
INSERT INTO kxv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ବା଼ଡ଼ାତା ମାନେସି, ଏ଼ୱାସି ତାନି ହିମ୍ବରି ଅ଼ହାଲି ୱେଣ୍ତେ ୱା଼ଆପେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ଏ଼ ବେ଼ଲାତା ଆମିନି ଗାଟାଇ ପୂରାମା଼ସା ଆ଼ହାମାନୁ ଇଞ୍ଜାଁ ପା଼ଲୁ ଊଟ୍‌ହିମାନୁ, ଏ଼ ଦିନା ଆୟ଼ତା ଏ଼ୱି ଏଚେକା କସ୍ତ ବେଟାଆ଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ସାମା ଏ଼ଦି ଏ଼ନିକିଁ ପେନି ବେ଼ଲାତା ଆ଼ଏ ଏ଼ଦାଆଁତାକି ପ୍ରା଼ତାନା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଇଚିହିଁ ଏ଼ କା଼ଲାତା ଇଲେତି କସ୍ତ ୱା଼ନେ, ମାହାପୂରୁ ଗା଼ଡ଼ିକିତି ଦିନାଟିଏ ନୀଞ୍ଜୁପାତେକା ଏଲେକିଁ ଆ଼ହା ହିଲେଏ, ଇଞ୍ଜାଁ ଏଲେକିଁ ଏଚେଲାୱା ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ସାମା ପ୍ରବୁ ଏ଼ ଲାଗେଏତି କା଼ଲାଇଁ ଊଣା କିହାମାନେସି । ଏଲେ କିହାହିଲାଆତିଁମା, ଏ଼ଦି ଏମ୍ବାଟି ଆମ୍ବାଆରି ଗେଲ୍‌ପି ଆ଼ଆତେରିମା । ତାନି ଆ଼ଚ୍‌ୱିଆ଼ତି ଲ଼କୁତାକି ଏ଼ କା଼ଲା ଊଣା କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ଏଚିବେ଼ଲା ‘ମେହ୍‌ଦୁ କ୍ରୀସ୍ତ ଇମ୍ବାଆଁ’ ଅ଼ଡ଼େ ‘ଏମ୍ବାଆଁ’ ଇଞ୍ଜିଁ ଲ଼କୁ ମିଙ୍ଗେ ୱେସ୍ତାନେରି, ଆତିହିଁ ମୀରୁ ଏ଼ଦାଆଁ ନାମାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ନା଼ଡ଼ିକିନି କ୍ରୀସ୍ତ ଅ଼ଡ଼େ ମାହାପୂରୁ ବ଼ଲୁ ମିଚି ୱେହ୍‌ନାରି ନିଙ୍ଗାନା ଇଲେତି ସିନା ଅ଼ଡ଼େ କାବାଆ଼ନି କାମାୟାଁ ତ଼ହ୍‌ନେରି, ଆ଼ଡିତିହିଁ, ଆ଼ଚ୍‌ୱିଆ଼ତି ଲ଼କୁଣି ଜିକେଏ ନା଼ଡ଼ି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ସାମା ମୀରୁ ଜାଗ୍ରାତା ଆ଼ହାମାଞ୍ଜୁ; ନା଼ନୁ ମିଙ୍ଗେ ତଲିଏ ବାରେ ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ସାମା ଏ଼ ବେ଼ଲାତି ଏ଼ କସ୍ତ ଡା଼ୟୁ ୱେ଼ଡ଼ା ଆନ୍ଦେରି ଆ଼ନେ ଅ଼ଡ଼େ ଲେ଼ଞ୍ଜୁ ଉଜେଡ଼ି ହୀଏ, ");
INSERT INTO kxv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ହୁକାୟାଁ ହା଼ଗୁଟି ତର୍‌ଗାଲି ମା଼ଟ୍‌ନୁ ଅ଼ଡ଼େ ହା଼ଗୁ ଲାକତି ବା଼ଡ଼୍‌ୟୁ ବାରେ କିଲିବିଲି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ଏଚିବେ଼ଲା ଲ଼କୁ ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ କାଜା ବା଼ଡ଼୍‌ୟୁଟି କାଜାପା଼ଣା ତଲେ ହା଼ଗୁ ଲାକଟି ୱା଼ନାଣି ମେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ଏଚିବେ଼ଲା ଏ଼ୱାସି ଦୂତୁୟାଁଣି ପାଣ୍ତାନା ଦାର୍‌ତି ମୁଟ୍‌ପେତି ସା଼ରିୱାକିଟି ତାନି ଆ଼ଚାମାନି ଲ଼କୁଣି ରୁଣ୍ତା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ତ଼ୟା ମା଼ର୍‌ନୁ ପୁଣ୍‌ମ୍ବି କିନି କାତାଟି ଜା଼ପାଦୁ । ଏଚିବେ଼ଲାତା ଏ଼ ମା଼ର୍‌ନୁତା କ଼ଡ଼୍‌ଗି କମାୟାଁ ଅ଼ଡ଼େ ଗୱେଡ଼ି ଗା଼ଲ୍‌ନୁ, କାରା କା଼ଲମି ୱା଼ତେ ଇଞ୍ଜିଁ ପୁଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ଈ ବାରେ ମେସ୍ତିସାରେ ଏ଼ୱାସି ଦୁୱେରି ଡାଗେ ମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଈ ବାରେ ଆ଼ଆପାତେକା ଈ କା଼ଲାତି ଲ଼କୁ ଏ଼ନିଜିକେଏ ମେଣ୍‌ଙ୍ଗଅରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ହା଼ଗୁପା଼କା ଦାର୍‌ତି ବାରେ ମେଣ୍‌ଙ୍ଗିନେ, ସାମା ନା଼ ବ଼ଲୁ ଏଚେଲାୱା ମେଣ୍‌ଙ୍ଗେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ସାମା ଏ଼ ଦିନା କି କା଼ଲାତି କାତା ଆମ୍ବାଆରି ପୁନଅରି, ଲାକପୂରୁତି ଦୂତୁୟାଁ କି ମୀର୍‌ଏସି ଜିକେଏ ପୁନଅସି, ୱାର୍‌ଇ ଆ଼ବାଦେଁ ପୁନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ମୀରୁ ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ, କା଼ଚାନା ମାଞ୍ଜୁ; ଇଚିହିଁ ଏ଼ ବେ଼ଲା ଏଚେଲା ଆ଼ନେ ଏ଼ଦାଆଁ ମୀରୁ ପୁନଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଏ଼ଦି ଇଲେକିହିଁ, ର଼ ମାଣ୍‌ସି ତାନି ଇଲୁ ପିସାନା ହେକ ରା଼ଜିତା ହାନେସି, ଅ଼ଡ଼େ ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ବାରେ କାମାତି ଅଦିକାରା ହୀତେସି ଇଞ୍ଜାଁ ଦୁୱେରିତା କା଼ଚାଲି ଜିକେଏ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଏ଼ଦାଆଁତାକି କା଼ଚାନା ଡ଼ୟାମୁ; ଇଚିହିଁ ନୀନୁ ପୁଞ୍ଜାହିଲଅତି ଇଲୁତି ସା଼ୱୁକାରି ଏଚେଲା ୱା଼ନେସି, ମିଡ଼୍‌ଅଲା କି ମାଦି ଲା଼ଆଁୟାଁ, ୱେ଼ୟାଆ ନ଼କେଏ କି ୱେ଼ଡ଼ା ହ଼ନି ବେ଼ଲାତା ଏ଼ୱାସି ୱା଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଏ଼ୱାସି ଦେବୁଣିଏ ୱା଼ତିସାରେ ମୀରୁ ହୁଞ୍ଜାମାନାଣି ମେସ୍ତାଆପେସି । ");
INSERT INTO kxv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ନା଼ନୁ ମିଙ୍ଗେ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁ ବାରେତି ୱେସିମାଇଁ, ଜାଗ୍ରାତା ମାଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଇଞ୍ଜାଁ ପୁଲାଏ଼ୟୁ ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁ ଆ଼ହାଲି ରୀ ଦିନା ମାଚେ । ଏଚିବେ଼ଲାତା କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ମେ଼ରା ପୁନାରି ଏ଼ନିକିଁ ଏ଼ୱାଣାଇଁ ନା଼ଡ଼ିକିହାଁ ଆସାନା ପା଼ୟିନେରି ଏ଼ଦାଆଁତାକି ପାରୁ ପାରିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ଇଚିହିଁ ଏ଼ୱାରି ଏଲେଇଚେରି, “ପାର୍ବୁ ବେ଼ଲାତା ଆ଼ଏ ଏଚେ଼ତା ଲ଼କୁ ଗଡ଼୍‌ହା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜୀସୁ ବେତନିୟାଁତା କାଜା ର଼ଗଗାଟି ସିମନ ଇଜ ତିଞ୍ଜାଲି କୁଗାମାଚାଟି ର଼ ଇୟା ର଼ ଗା଼ଜୁତା ହା଼ରେକା ଦାରାତି ଗାନ୍ଦା ନିୟୁଁ ତାଚାନା ଗା଼ଜୁତି ଦେଚାନା ଜୀସୁ ତା଼ର୍ୟୁଁତା ୱା଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ସାମା ଏଚେକା ଲ଼କୁ କାର୍‌ବି ଆ଼ହାନା, ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ୱେସ୍‌ପି ଆ଼ତେରି, “ନିୟୁଁ ଏ଼ନାଆଁତାକି ନସ୍ତ ଆ଼ତେ ? ");
INSERT INTO kxv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଈ ନିୟୁଁ ସା଼ତାକ଼ଡ଼ି ଦସଟାକା କିହାଁ ଆଗାଡ଼ା ପାର୍‌ପି ଆ଼ହାନା ହାକି ଗାଟାରାକି ହୀପ୍‌କି ଆ଼ହାଲି ଆ଼ଡିତେମା” ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ ଇୟାନି ଲା଼ଗାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ଦାନି ପିହ୍‌ଦୁ; ଏ଼ନାଆଁତାକି କସ୍ତ ହୀହିମାଞ୍ଜେରି ? ଏ଼ଦି ନାଙ୍ଗେତାକି ନେହିଁ କିହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ଇଚିହିଁ ହାକି ଗାଟାରି କା଼ଲେଏ ମୀ ତା଼ଣା ମାନେରି, ଅ଼ଡ଼େ ମିଙ୍ଗେ ଏଚେ଼ତା ମ଼ନ ଏଚେ଼ତା ଏ଼ୱାରି ସା଼ୟେମି କିହାଲି ଆ଼ଡିଦେରି; ସାମା ନା଼ନୁ କା଼ଲେଏ ମୀ ତା଼ଣା ଡ଼ୟଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଏ଼ଦି ଏ଼ନାଆଁ ଆ଼ଡିନାୟି ମାନେ ଏ଼ଦାଆଁ କିହାମାନେ; ଏ଼ଦି ନା଼ ଆଙ୍ଗାତି ମୁସାଲି ତାକି ତଲିଏ ନିୟୁଁ ୱା଼କ୍‌ହାନା ତିୟାରା କିହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ବାରେ ଦାର୍‌ତିତା ଆମ୍ବିୟା ଜିକେଏ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ନେରି, ଏ଼ ଟା଼ୟୁତା ଈ ଇୟାନି ଅଣ୍‌ପାଲିତାକି ଏ଼ଦାନି ଈ କାମାତି କାତା ଜିକେଏ ୱେସ୍‌ପି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ଏମ୍ବାଟିଏ ବା଼ରଜା଼ଣା ବିତ୍ରାଟି ଇସ୍କାରିୟତ ଜୀହୁଦା ଦ଼ରୁଗାଟାସି ରଅସି ଜୀସୁଇଁ କାଜା ପୂଜେରାଙ୍ଗା କେୟୁତା ହେର୍‌ପାଲି ଏ଼ୱାରିତା଼ଣା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ଏ଼ୱାରି ଏ଼ଦାଆଁ ୱେଞ୍ଜାନା ରା଼ହାଁ ଆ଼ତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାକି ଟାକାୟାଁ ହୀହାଲି ଆ଼ଞ୍ଜିତେରି, ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଆସ୍‌ପି କିହାଲି ନେହିଁ ପାରୁ ପାରିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ଡା଼ୟୁ ପୂଲାଗୁଣ୍ଡା ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁତି ମୂଲୁ ଦିନାତା ଆମିନି ନେ଼ଚୁ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ମେ଼ଣ୍ତା ଡା଼ଲୁତି ହେର୍‌ପିଆ଼ନେ, ଏ଼ ଦିନା ତାନି ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ମା଼ମ୍ବୁ ହାଜାନା ଆମିନି ଟା଼ୟୁତା ନିଙ୍ଗେତାକି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି କିନମି ଇଞ୍ଜିଁ ନୀନୁ ଅଣ୍‌ପିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରିଆରାଇଁ ଏଲେଇଞ୍ଜା ପାଣ୍ତିତେସି, “ମୀରୁ ଗା଼ଡ଼ାତା ହାଜୁ ଇଞ୍ଜାଁ ଏ଼ୟୁ ଡ଼଼କା ଅ଼ହିମାନି ରଅସି ମିଙ୍ଗେ ବେଟାଆୟାନେସି; ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ ହାଜୁ; ");
INSERT INTO kxv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଏ଼ୱାସି ଆମିନି ଇଜ ହ଼ଡ଼ନେସି, ଏ଼ ଇଲୁ ଗାଟାଣାଇଁ ୱେଞ୍ଜୁ, ‘ଗୂରୁ ୱେଞ୍ଜିମାଞ୍ଜାନେସି, ନା଼ନୁ ନା଼ ସୀସୁୟାଁ ତଲେ ଆମିନି ଟା଼ୟୁତା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି କିହାଲି ଆ଼ନେ ଏ଼ ବାକ୍ରା ଆମିନାୟି ?’ ");
INSERT INTO kxv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଏଚେଟିଏ ଏ଼ୱାସି ମିଙ୍ଗେ ନେହିଁକିଁ ତିୟାରା ଆ଼ହାମାନି ଲାକନି ପାରୁତି ର଼ କାଜା ବାକ୍ରା ତ଼ସ୍ତାନେସି; ଏମ୍ବାଆଁ ମାଙ୍ଗେତାକି ରା଼ନ୍ଦା ୱାଜାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ହାଜାନା ଗା଼ଡ଼ାତା ହ଼ଟେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଏଲେକିଁ ମେସାନା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି ୱାଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ଜୀସୁ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ତଲେ ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ଏ଼ୱାରି କୁଗାନା ରା଼ନ୍ଦା ତିଞ୍ଜି ମାଚାଟି ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀ ବିତ୍ରାଟି ରଅତେରି ନାଙ୍ଗେ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପାଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଦୁକୁ ଆ଼ହାନା ର଼ଅ ର଼ଅରି ଏ଼ୱାଣାଇଁ ୱେଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି, “ନା଼ନୁ ଏ଼ୱାତେଏଁ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବା଼ରଜା଼ଣା ବିତ୍ରାଟି ରଅସି, ଆମ୍ବାଆସି ନା଼ ତଲେ ସାଡ଼୍‌ୱାତା କେୟୁ ମେତ୍‌ହି ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ମାଣ୍‌ସି ମୀର୍‌ଏଣା କାତା ଏ଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଏଲେକିହିଁଏ ହା଼ନେସି ସାତା, ସାମା ଆମିନି ଲ଼କୁ ତା଼ଣାଟି ମାଣ୍‌ସି ମୀର୍‌ଏସି ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିଆ଼ନେସି, ଆୟ଼ତା ଏ଼ୱାଣି ଡଣ୍ତ ! ଏ଼ ଲ଼କୁତି ଜାର୍ନା ଆ଼ହାହିଲାଆତିହିଁ ଏ଼ୱାଣାକି ନେହେଁ ଆ଼ତେମା ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ଏ଼ୱାରି ତିଞ୍ଜି ମାଚାଟି ଜୀସୁ ରୂଟି ଅ଼ହାନା ମାହାପୂରୁଇଁ ଜହରା କିହାନା ଏ଼ଦାଆଁ ଡ଼ିକ୍‌ହା ହୀହାନା ଏଲେଇଚେସି, “ଅ଼ଦୁ ତିଞ୍ଜୁ, ଈଦି ନା଼ ଆଙ୍ଗା ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଗହ୍‌ନି ସ଼ଲା ଆସାନା ମାହାପୂରୁଇଁ ଜହରା କିହାଁ ଏ଼ୱାରାକି ହୀତେସି, ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ଏ଼ଦାଆଁ ଗସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମିନି ରା଼ଜିମା଼ନା ନେତେରି ହା଼ରେକା ଲ଼କୁତାକି ୱା଼ଙ୍ଗାମାନେ, ଈଦି ଏ଼ ନା଼ ନେତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମିନି ଦିନା ମାହାପୂରୁତି ରା଼ଜିତା ପୁଃନି କିହିଁ ଅଙ୍ଗୁରି ପା଼ଡ଼େୟିତି ରାସା ଗହ୍‌ଇଁ ଏ଼ ଦିନା ପାତେକା ଈଦାଆଁ ଅ଼ଡ଼େ ନା଼ନୁ ଏଚେଲା ଗହ୍‌ଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜହରା ପା଼ଚୁ ପା଼ଚିତି ଡା଼ୟୁ ଜୀତ ହ଼ରୁତା ହ଼ଚା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଏଚିବେ଼ଲା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ବାରେ ପିସା ହାଜାଦେରି, ଇଚିହିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନା଼ନୁ ମେ଼ଣ୍ତା ଗ଼ଡ଼ୁଇଁ ପା଼ୟିଇଁ ଇଞ୍ଜାଁ ମେ଼ଣ୍ତାୟାଁ ଆଲାରା ଆ଼ହାହାନୁ । ");
INSERT INTO kxv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ସାମା ନା଼ନୁ ହା଼ହାନା ୱେଣ୍ତେ ନିଙ୍ଗିତି ଡା଼ୟୁ ମୀ ନ଼କିତା ଗାଲିଲିତା ହାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ଏମ୍ବାଟିଏ ପିତର ଏଲେଇଚେସି, “ବାରେଜା଼ଣା ପିସା ହାଜାନେରି ନା଼ନୁ କଡ଼େ ନିଙ୍ଗେ ଏଚେଲା ପିସ୍ତଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜୀସୁ ପିତରଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ ଈ ଲା଼ଆଁୟାଁ କୟୁ ରୀ ଦେବା କେ଼ଣ୍‌ଆ ମାନାଟିଏ, ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ତୀନିପା଼ଲି ଏଲେଇଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ସାମା ପିତର ଆ଼ଟ୍‌ୱା ତଲେ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ନୀ ତଲେ ହା଼ହାଲି ଆ଼ତି ଜିକେଏ ନା଼ନୁ ନିଙ୍ଗେ ଏଚେଲା ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜଅଁ ।” ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ଜିକେଏ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ଡା଼ୟୁ ଏ଼ୱାରି ଗେତ୍‌ସିମନି ଇନି ର଼ ଟା଼ୟୁତା ୱା଼ତେରି, ଇଞ୍ଜାଁ ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ପ୍ରା଼ତାନା କିହିମାନି ପାତେକା ଇମ୍ବାଆଁ କୁଗାନା ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଇଞ୍ଜାଁ ଏ଼ୱାସି ପିତର, ଜାକୁବ ଅ଼ଡ଼େ ଜହନଇଁ ତାନିତଲେ ଅ଼ତେସି । ଏ଼ୱାସି ହା଼ରେକା ଦୁକୁତି କସ୍ତ ତାକି କିଲିବିଲି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜୀୱୁ ହା଼ନିଲେହେଁ ହା଼ରେକା କିଲିବିଲି ହ଼ଚିମାଞ୍ଜାନେ; ମୀରୁ ଇମ୍ବାଆଁ ତେଃଏଲାନା କା଼ଚାମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜୀସୁ ନ଼କିତା ହାଜାନା ବୂମିତା ମୁନୁ କୁତିତେସି, ଅ଼ଡ଼େ ଆ଼ହାଲି ଆ଼ଡିତିହିଁ, ଏ଼ ଦୁକୁ ଏ଼ୱାଣି ତା଼ଣାଟି ଏ଼ନିକିଁ ହେକ ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ପ୍ରା଼ତାନା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଇଞ୍ଜାଁ ଜୀସୁ ଏଲେଇଚେସି, “ଆ଼ବା, ନୀନୁ ବାରେଏ କିହାଲି ଆ଼ଡିଦି; ଈ କସ୍ତ ବା଼ଦା ନା଼ ତା଼ଣାଟି ହେକ କିମୁ; ଆ଼ତିଜିକେଏ ନା଼ କାତା ଆ଼ଏ ନୀ କାତେଏ ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଇଞ୍ଜାଁ ଏ଼ୱାସି ୱା଼ହାନା ସୀସୁୟାଁ ଇଦା କିତାଣି ମେସ୍ତେସି, ଇଞ୍ଜାଁ ପିତରଇଁ ଏଲେଇଚେସି, “ସିମନ ନୀନୁ ଡୂରିତିକି ? ଗା଼ଡ଼େକା ଜିକେଏ କା଼ଚାଲି ଆ଼ଡାଆତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ଏ଼ଦାଆଁତାକି କା଼ଚାନା ପ୍ରା଼ତାନା କିଦୁ; ଏ଼ନିକିଁ ମୀରୁ ପା଼ନ୍ଦାତା ହେର୍‌ଅତେରି, ମ଼ନ ମାନେ ସାତା, ଆଙ୍ଗାତା ବା଼ଡ଼୍‌ୟୁ ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଏ଼ୱାସି ଅ଼ଡ଼େ ୱେଣ୍ତେ ହାଜାନା ତଲିତିଲେହେଁ ପ୍ରା଼ତାନା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ଅ଼ଡ଼େ ୱେଣ୍ତେ ୱା଼ହାନା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଇଦା କିହାମାନାଣି ମେସ୍ତେସି, ଇଚିହିଁ ଏ଼ୱାରି କାଣ୍‌କା ପଜ୍‌ୱି ଆ଼ହିମାଚୁ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏ଼ନାଆଁ ଜ଼ଲିନେରି ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଜୀସୁ ତୀନି ଦେବା ୱା଼ହାନା ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଗା଼ଡ଼େକା ଡୂରାନା ଜ଼ମାଦୁ; ହା଼ରେକା ବେ଼ଲା ଆ଼ତେୟିଏ, ଏ଼ ବେ଼ଲା ଏଗାୱା଼ହିମାନେ; ମେହ୍‌ଦୁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପି ଆ଼ହିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ନିଙ୍ଗାଦୁ, ମା଼ର ହାନ, ମେହ୍‌ଦୁ ଆମ୍ବାଆସି ନାଙ୍ଗେ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି ଏ଼ୱାସି ଏଗାୱା଼ତେସିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଏ଼ ଦେବୁଣିଏ ଜୀସୁ ୱେସିମାଚି ବେ଼ଲାତା, ବା଼ରଜା଼ଣା ବିତ୍ରାଟି ଜୀହୁଦା ଦ଼ରୁଗାଟାସି ରଅସି ଇଞ୍ଜାଁ ତାନିତଲେ କାଜା ପୂଜେରାଙ୍ଗା, ମେ଼ରା ପୁନାରି ଇଞ୍ଜାଁ ଲ଼କୁତି କାଜାରି ତା଼ଣାଟି କାଣ୍ତା ଟେଙ୍ଗା ଆସାନା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଜୀସୁଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିନାସି ଏ଼ୱାରାଇଁ ଈ ସିନା ୱେସାମାଚେସି, “ନା଼ନୁ ଆମ୍ବାଆରାଇଁ ନଣ୍ତିଇଁ ଏ଼ୱାସିଏ ଏ଼ୱାସି । ଏ଼ୱାଣାଇଁ ଦସାନା ଜାଗ୍ରାତା ତଲେ ଅ଼ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣି ଡାଗେ ହାଜାନା, “ଏ଼ ଗୂରୁ” ଇଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ନଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆସାନା ଦସା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ସାମା ଡାଗେ ନିଚାମାଚି ଲ଼କୁ ବିତ୍ରାଟି ରଅସି କାଣ୍ତା ହ଼ପ୍‌ହେସି ଇଞ୍ଜାଁ କାଜା ପୂଜେରା ହ଼ଲେଏଣା କିର୍ୟୁଁ ଦା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ସ଼ରୁଇଁ ଆସାଲି ହାନିଲେହେଁ କାଣ୍ତା ଅ଼ଡ଼େ ଟେଙ୍ଗା ଆସାନା ମୀରୁ ନାଙ୍ଗେ ଆସାଲି ୱା଼ତେରି ? ");
INSERT INTO kxv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ନା଼ନୁ ବାରେଦିନା ମୀ ତଲେ ପ୍ରା଼ତାନା ଇଲୁତା ମାଞ୍ଜାନା ଜା଼ପ୍‌ହି ମାଞ୍ଜାତେଏଁ, ସାମା ମୀରୁ ନାଙ୍ଗେ ଆସ୍ତାଆତେରି; ସାମା ଦାର୍ମୁ ପତିତି ରା଼ସ୍‌କି ଆ଼ତି ବ଼ଲୁ ଏ଼ନିକିଁ ସାତା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ଏଚିବେ଼ଲା ବାରେଜା଼ଣା ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ପିସାନା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ର଼ ଦାଂଗ୍‌ଣା କକାସି ର଼ ହିମ୍ବରି ପିଡ଼୍‌ଗାହାଁ ଜୀସୁ ଜେ଼ଚ ଜେ଼ଚ ହାଜିମାଚେସି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆସାଲି ହାଜାଲିଏ, ");
INSERT INTO kxv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ଏ଼ୱାସି ଏ଼ ପା଼ତାଡ଼ା ହିମ୍ବରି ପିସାନା ୱାର୍‌ଇ ଆଙ୍ଗାଟି ହଟାତୁସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ଡା଼ୟୁ ଏ଼ୱାରି ଜୀସୁଇଁ କାଜା ପୂଜେରା ନ଼କିତା ଅ଼ତେରି, ଇଞ୍ଜାଁ କାଜା ପୂଜେରା, ଲ଼କୁତି କାଜାରି ଅ଼ଡ଼େ ମେ଼ରା ପୁନାରି ବାରେ ୱା଼ହାନା ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର ହେକ ମାଞ୍ଜାନା ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ କାଜା ପୂଜେରା ଆଂଗେଣି ବିତ୍ରା ହାଚେସି ଇଞ୍ଜାଁ ଜାମାନାଙ୍ଗା ତଲେ କୁଗାନା ହିଚୁ କେର୍‌ଞ୍ଜି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ଏମ୍ବାଟିଏ କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ବେ଼ରଣି ମାଣ୍ତାତି ବାରେଜା଼ଣା ଜୀସୁଇଁ ପା଼ୟାଲି ଏ଼ୱାଣି କ଼ପାଟି ସା଼କିୟାଁ ପାରିତେରି, ସାମା ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ଆତେରି; ");
INSERT INTO kxv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ଇଚିହିଁ ହା଼ରେକା ଏ଼ୱାଣି କ଼ପାଟି ମିଚି ସା଼କିୟାଁ ହୀତି ଜିକେଏ ଏ଼ୱାରି ହୀତି ସା଼କି ଆଣ୍ତାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ଡା଼ୟୁ ଏଚରଜା଼ଣା ହ଼ଚାନା ଏ଼ୱାଣି କ଼ପାଟି ମିଚି ସା଼କି ହୀହାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ମା଼ମ୍ବୁ ଈୱାଣାଇଁ ଈ କାତା ୱେସିମାଚାଣି ୱେଞ୍ଜାମାନମି, ନା଼ନୁ ଈ କେୟୁଟି କେ଼ପିତି ପ୍ରା଼ତାନା ଇଲୁତି ଡିକ୍‌ହାନା ତୀନିଦିନା ବିତ୍ରା ଅ଼ଡ଼େ ମାଣ୍‌ସି କେ଼ପାଆତି ପ୍ରା଼ତାନା ଇଲୁ କେ଼ପିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ସାମା ଏମ୍ବାଆଁ ଜିକେଏ ସା଼କି ଆଣ୍ତାଆତେ ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଏଚେଟିଏ କାଜା ପୂଜେରା ମାଦିଏ ନିଚାନା ଜୀସୁଇଁ ୱେଚେସି, “ନୀ କ଼ପାଟି ଈୱାରି ଆମିନି ସା଼କି ହୀହିମାନେରି, ୱେଣ୍ତେ ଜ଼ଲାଲି ଏ଼ନି କାତା ହିଲେଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ସାମା ଏ଼ୱାସି ପାଲେଏ ଆ଼ହାନା ଏ଼ନି କାତା ଜ଼ଲାଆତେସି, କାଜା ପୂଜେରା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ କି ମା଼ନିଗାଟି ମାହାପୂରୁ ମୀର୍‌ଏଣାତି କ୍ରୀସ୍ତ ?” ");
INSERT INTO kxv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାତେଏଁ, ମୀରୁ ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ ବା଼ଡ଼୍‌ୟୁଗାଟି ଟିଃନିୱାକି କୁଗାମାନାଣି ମେହ୍‌ଦେରି ଇଞ୍ଜାଁ ହା଼ଗୁ ଦୂନ୍ଦ୍ରାଟି ୱେଣ୍ତେ ୱା଼ନାଣି ମେହ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ଏଚେଟିଏ କାଜା ପୂଜେରା ତାନି ହିମ୍ବରି ଗେସାନା ଏଲେଇଚେସି, “ମାଙ୍ଗେ ଅ଼ଡ଼େ ଏ଼ନି ସା଼କିୟାଁ ଲ଼ଡ଼ା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ମୀରୁ ମାହାପୂରୁ ନିନ୍ଦା ୱେଚେରି; ମୀ ଅଣ୍‌ପୁ ଏ଼ନାୟି ?” ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ ବେଟାଆ଼ପେସି ଇଞ୍ଜିଁ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଇଞ୍ଜାଁ ଆମ୍ବା ଆମ୍ବାଆରି ଏ଼ୱାଣିଲାକ ହୂପିତେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣି କାଣ୍‌କା ପଜାନା ଏ଼ୱାଣାଇଁ ୱେ଼ଚାନା ୱେଚେରି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି ଆମ୍ବାଆସି ନିଙ୍ଗେ ୱେ଼ତାତେସି, ୱେସ୍ତାମୁ !” ଜାମାନାଙ୍ଗା ଜିକେଏ ଆସାନା ସା଼ପ୍‌ଡ଼ା ୱେ଼ଚିହିଁ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ଏମ୍ବାଟିଏ ପିତର ଆଂଗେଣିତା ମାଚିବେ଼ଲାତା କାଜା ପୂଜେରା ହ଼ଲେଣି ୱା଼ହାନା ପିତର ହିଚୁ କେର୍‌ଞ୍ଜି ମାଚାଣି ମେସ୍ତେ, ");
INSERT INTO kxv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଇଞ୍ଜାଁ ପିତରଇଁ ସିନିକିହାନା ଏଲେଇଚେ, “ନୀନୁ ଜିକେଏ ନା଼ଜରିତ ଜୀସୁତଲେ ମାଚି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ସାମା ଏ଼ୱାସି, ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ, ନୀନୁ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜି ନା଼ନୁ ପୁଞ୍ଜିହିଲଅଁ, ଡା଼ୟୁ ଏ଼ୱାସି ଆଂଗେଣି ଦୁୱେରିତା ହାଚେସି, ରେ଼ଟୁଏ କୟୁ କେ଼ଣ୍‌ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଇଞ୍ଜାଁ ଏ଼ ହ଼ଲେଣି ଏ଼ୱାଣାଇଁ ମେସାନା ଦାରିତା ନିଚାମାନି ଲ଼କୁଣି ଅ଼ଡ଼େ ୱେଣ୍ତେ ୱେସାଲି ମା଼ଟ୍‌ହେ, “ଈୱାସି ଏ଼ୱାରି ବିତ୍ରାଟି ରଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ସାମା ଏ଼ୱାସି ଅ଼ଡ଼େ ୱେଣ୍ତେ ପୁଞ୍ଜାହିଲଅଁ ଇଚେସି, ଅ଼ଡ଼େ ଗା଼ଡ଼େକା ଆ଼ହାଲିଏ ଦାରିତା ମାଚି ଲ଼କୁ ପିତରଇଁ ଏଲେଇଚେରି, “ନୀନୁ ସାତେଏ ଏ଼ୱାରି ବିତ୍ରାଟି ରଅତି, ଇଚିହିଁ ନୀନୁ ର଼ ଗାଲିଲି ଲ଼କୁତି ।” ");
INSERT INTO kxv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ସାମା ଏ଼ୱାସି ପାର୍‌ମାଣା ଇଞ୍ଜାଁ ବା଼କା ଇଟାନା ଏଲେଇଚେସି, ମୀରୁ ଆମିନି ଲ଼କୁତି କାତା ୱେସିମାଞ୍ଜେରି, ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ଏ଼ ଦେବୁଣିଏ କୟୁ ରୀ ଦେବା କେ଼ଣ୍‌ତେ । ଏମ୍ବାଟିଏ କୟୁ ରୀ ଦେବା କେ଼ଣ୍‌ଆ ନ଼କେଏ ନୀନୁ ନାଙ୍ଗେ ତୀନି ଦେବା ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜାଦି, ଆମିନି କାତା ଜୀସୁ ପିତରଇଁ ଏଲେଇଞ୍ଜାମାଚେସି, ଏ଼ଦି ଏ଼ୱାଣି ମ଼ନତା ୱା଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ କାତା ଅଣ୍‌ପିହିଁ ହା଼ରେକା ଡ଼ୀହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ଲା଼ଇ ୱେ଼ୟାଲିଏ ବେ଼ରଣି ମାଣ୍ତାତାରି, ଇଚିହିଁ ଲ଼କୁତି କାଜାରି ଇଞ୍ଜାଁ ମେ଼ରା ପୁନାରି ତଲେ କାଜା ପୂଜେରାଙ୍ଗା ବେ଼ରଣି କିହାନା କାତା ଆ଼ତେରି । ଜୀସୁଇଁ ଦସ୍‌ପା ଅ଼ହାନା ପିଲାତ କେୟୁତା ହେର୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ କି ଜୀହୁଦି ଲ଼କୁତି ରାଜା ?” ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁଏ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ଇଞ୍ଜାଁ କାଜା ପୂଜେରାଙ୍ଗା ଜୀସୁ କ଼ପାଟି ହା଼ରେକା କାତାୟାଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ଏମ୍ବାଟିଏ ପିଲାତ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ ଏ଼ନାଆଁତାକି ୱେସିମାଞ୍ଜଅତି ? ମେହ୍‌ମୁ ଈୱାରି ନୀ କ଼ପାଟି ହା଼ରେକା କାତା ଜ଼ଲିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ସାମା ଜୀସୁ ଏ଼ନି ହା଼ଡା ଜ଼ଲାଆତେସି, ଏଚେଟିଏ ପିଲାତ କାବା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ସାମା ପାର୍ବୁ ବେ଼ଲାତା ଲ଼କୁ ଆମିନି କାୟିଦିତା ମାଚାଣାଇଁ ରୀସିମାଚେରି, ଏ଼ୱାଣାଇଁ ପିଲାତ ଏ଼ୱାରି ତାକି ପିସିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଆମିନି ଗଡ଼୍‌ହା ଗାଟାରି ଗଡ଼୍‌ହା ବେ଼ଲାତା ଲ଼କୁଣି ପା଼ୟାମାଚେରି, ଏ଼ୱାରିତଲେ ବାରବା ଦ଼ରୁଗାଟାସି କାୟିଦିତା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଏ଼ଦାଆଁତାକି ତାନି ମେ଼ରା ଲେହେଁ କିହାଲି ପିଲାତଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ଏମ୍ବାଟିଏ ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ନା଼ନୁ ମିଙ୍ଗେତାକି ଜୀହୁଦି ଲ଼କୁତି ରାଜାଇଁ ପିସାହିୟାଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଇଚିହିଁ କାଜା ପୂଜେରାଙ୍ଗା ଏ଼ୱାଣାଇଁ ଡା଼ହାରା ତଲେ ହେର୍‌ପାମାଚେରି, ଏ଼ଦାଆଁ ଏ଼ୱାସି ପୁଚେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ସାମା ଏ଼ୱାସି ଏ଼ନିକିଁ ଏ଼ୱାରି ତାକି ବାରବାଇଁ ପିହ୍‌ନେସି, ଏ଼ଦାଆଁତାକି କାଜା ପୂଜେରାଙ୍ଗା ଲ଼କୁଣି ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ସାମା ପିଲାତ ୱେଣ୍ତେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ଆମ୍ବାଆରାଇଁ ଜୀହୁଦି ଲ଼କୁତି ରାଜା ଇଞ୍ଜିଁ ମାଞ୍ଜେରି, ଜୀସୁଇଁ ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଲ଼କୁ ବାରେ କା଼ଲ୍‌ୱି ଆ଼ହାନା ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ଏକ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ଏମ୍ବାଟିଏ ପିଲାତ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଏ଼ନାଆଁତାକି ଏ଼ୱାସି ଏ଼ନି ଦ଼ହ କିହାମାନେସି ?” ସାମା ଏ଼ୱାରି ଗାଡି କା଼ଲ୍‌ୱି ଆ଼ହାନା ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ଏକ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ଏଚେଟିଏ ପିଲାତ ଲ଼କୁଣି ରା଼ହାଁ କିହାଲି ମ଼ନ କିହାନା ଏ଼ୱାରି ତାକି ବାରବାଇଁ ପିସ୍ତେସି, ଇଞ୍ଜାଁ ଜୀସୁଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ପି କିହାନା ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ଏମ୍ବାଟିଏ କ଼ସ୍‌କା ଜୀସୁଇଁ ଆଂଗେଣିଟି ମେ଼ଡ଼ା ଇଲୁ ବିତ୍ରା ଅ଼ହାନା ବାରେ କ଼ସ୍‌କାଣି ହା଼ଟାନା ରୁଣ୍ତା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ହେୟାଁ ୱା଼ଣା ହିମ୍ବରି ହୁଚିକିତେରି ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ଟ଼ପେରି ଆଲାନା ଏ଼ୱାଣି ତା଼ର୍ୟୁଁତା ତୁର୍‌ୱି କିତେରି; ");
INSERT INTO kxv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଅ଼ଡ଼େ “ଏ଼ ଜୀହୁଦି ଲ଼କୁତି ରାଜା ଜହରା” ଇଞ୍ଜିଁ ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ଇଞ୍ଜାଁ ଏ଼ୱାରି ର଼ ବାଡ଼୍‌ଗା ଆସାନା ଏ଼ୱାଣି ତା଼ର୍ୟୁଁତା ୱେ଼ତେରି ଇଞ୍ଜାଁ ମେଣ୍ତାକୁତାନା ଜହରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଲାଜାକିହିଁ କାକ୍‌ହି ଡା଼ୟୁ, ଏ଼ ହେୟାଁ ୱା଼ଣାଗାଟି ହିମ୍ବରି ହୁକ୍‌ହା ଅ଼ହାନା ତାନି ହିମ୍ବରି ହୁଚିକିତେରି । ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ପାଙ୍ଗାତା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ଏଚିବେ଼ଲା ଆଲେକ୍‌ଜାଣ୍ତାର ଇଞ୍ଜାଁ ରୁପତାମି ଆ଼ବା ସିମନ ଦ଼ରୁଗାଟି ର଼ କୁରିଣିୟ ଲ଼କୁ ନା଼ୟୁଁଟି ୱା଼ହାନା ଏ଼ ଜିରୁଟି ହାଜିମାଚେସି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜୀସୁତି ପା଼ସିମୁଣ୍ତା ଡେ଼କାଲି ବାଲାମାତମି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଗଲ୍‌ଗତା ଇଚିହିଁ “ତା଼ର୍ୟୁଁଗିର୍ପା” ଇନି ଟା଼ୟୁତା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାକି ପୁଲା ଆଣ୍ତିତି ଅଙ୍ଗୁରି ରାସା ଗସାଲି ହୀତେରି, ସାମା ଏ଼ୱାସି ଏ଼ୱାଆଁ ଗହ୍‌ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଏ଼ନାଆଁ ବେଟା ଆ଼ନେସି, ଏ଼ଦାଆଁ ପାଦି କିହାନା ତାନି ହିମ୍ବରିକା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ବା଼ଟି କିହାନା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ଦିନା ନ଼ ଗଂଟା ବେ଼ଲାତା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଇଞ୍ଜାଁ ଏ଼ୱାଣିଲାକ ଇଲେଇଞ୍ଜିଁ ରା଼ସ୍‌କି ଆ଼ହାମାଚେ, “ଈୱାସି ଜୀହୁଦି ଲ଼କୁତି ରାଜା ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଟିଃନିୱାକି ରଅଣାଇଁ ଅ଼ଡ଼େ ଟେ଼ବ୍ରିୱାକି ରଅଣାଇଁ, ଇଲେକିହିଁ ରୀ ସ଼ର୍‌କାଣି ଏ଼ୱାରି ଏ଼ୱାଣିତଲେ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ଏଚେଟିଏ ଦାର୍ମୁ ପତିତି କାତା ସାତା ଆ଼ତେ, ଏ଼ୱାସି ପା଼ପୁ ଗାଟାରି ତଲେ ଲେକା କିୱିଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଏ଼ ଜିରୁଟି ହାଜିମାନି ଲ଼କୁ ତାମି ତା଼ର୍କା ଗୁଟ୍‌କିକିହିଁ ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିହିଁ ଏଲେଇଚେରି, “ଆବା, ମାହାପୂରୁ ଇଲୁତି ଡିକ୍‌ନାତି ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ଏ଼ଦାଆଁ କେ଼ପିନାତି, ");
INSERT INTO kxv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ଚାୱା଼ହାନା ନିଙ୍ଗେ ଗେଲ୍‌ପା କଡାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","କାଜା ପୂଜେରାଙ୍ଗା ଜିକେଏ ଏଲେକିଁ ମେ଼ରାପୁନାରି ତଲେ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିହିଁ ଏଲେଇଚେରି, “ଏ଼ୱାସି ଅ଼ର ଲ଼କୁଇଁ ଗେଲ୍‌ପିତେସି, ସାମା ତାଙ୍ଗେ ଗେଲ୍‌ପାଲି ଆ଼ଡିହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଇସ୍ରାୟେଲତି ରାଜା କ୍ରୀସ୍ତତି ଇଚିହିଁ ଦେବୁଣିଏ ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ଚା ୱା଼ମୁ, ଏ଼ନିକିଁ ମା଼ମ୍ବୁ ଏ଼ଦାଆଁ ମେସାନା ନାମାନମି ।” ଇଞ୍ଜାଁ ଆମିନି ଗାଟାରାଇଁ ଜୀସୁତଲେ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହା ମାଚେରି, ଏ଼ୱାରି ଜିକେଏ ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ବା଼ର ଗଂଟା ବେ଼ଲା ଏ଼ ଦେ଼ସା ଆନ୍ଦେରି ଆ଼ହାନା ତୀନି ଗଂଟା ପାତେକା ଡ଼ୟିତେ । ");
INSERT INTO kxv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ତୀନି ଗଂଟା ବେ଼ଲାତା ଜୀସୁ କାଜା ହା଼ଡାତଲେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଏଲହି ଏଲହି ଲାମା ସାବକ୍‌ତାନି ?” ଇଚିହିଁ “ଏ଼ ନା଼ ମାହାପୂରୁ ଏ଼ ନା଼ ମାହାପୂରୁ ନୀନୁ ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ପିସ୍ତାତି ?” ");
INSERT INTO kxv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଈ ହା଼ଡା ୱେଞ୍ଜାନା ଦାରିତା ନିଚାମାନି ଲ଼କୁ ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଚେରି, “ମେହ୍‌ଦୁ ଏ଼ୱାସି ଏଲିୟଇଁ ହା଼ଟି ମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଇଞ୍ଜାଁ ରଅସି ହଟିହିଁ ହାଜାନା ର଼ ଡ୍ରାଃଆଲି ପୁଲା ଅଙ୍ଗୁରି ରାସାତା ମେତ୍‌ହାନା ଏ଼ଦାଆଁ ର଼ ବାଡ଼୍‌ଗାତା ରୂପାନା ଏ଼ୱାଣାକି ଗସାଲି ହୀହାନା ଏଲେଇଚେସି, “ହେଣ୍ତୁ ଏଲିୟ ଈୱାଣାଇଁ ଗେଲ୍‌ପାଲି ୱା଼ହିମାନେସି କି ଆ଼ଏ ସିନିକିନ ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ସାମା ଜୀସୁ କାଜା ଗିୟାଁତଲେ ଜ଼ଲାନା ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା ଲେଚାମାନି ହିମ୍ବରି ଲାକଟିଏ ଡ଼଼ଇ ପାତେକା ଗେଞ୍ଜାନା ରୀ ବା଼ଗା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ଏ଼ୱାଣି ନ଼କିତା ନିଚାମାନି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏ଼ୱାଣି ଇଲେତି ହା଼ତାଣି ମେସାନା ଏଲେଇଚେସି, “ସାତେଏ, ଈୱାସି ମାହାପୂରୁତି ମୀର୍‌ଏସି ମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ଏଚେକା ଇୟାସିକା ଜିକେଏ ହେକଟି ସିନିକିହିମାଚୁ; ଏ଼ୱାସିକା ବିତ୍ରାଟି ମଗ୍‌ଦଲିନି ମରିୟମ, ଊଣା ଜାକୁବ ଇଞ୍ଜାଁ ଜସିତି ଇୟା ମରିୟମ, ଅ଼ଡ଼େ ସାଲମି ମାଚୁ; ");
INSERT INTO kxv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଏ଼ୱାସି ଗାଲିଲିତା ମାଚାଟି ଏ଼ୱି ଏ଼ୱାଣି ଜେ଼ଚ ହାଜାନା ଏ଼ୱାଣି ସେ଼ବା କିହିମାଚୁ; ଏ଼ୱାସିକା ତଲେ ଜିରୁସାଲମତା ୱା଼ହାମାନି ହା଼ରେକା ଇୟାସିକା ସିନିକିହିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ୱେ଼ଡ଼ା ହାଜିମାଚାଟି, ଏ଼ ଦିନା ତିୟାରା ଆ଼ନି ଦିନା ଇଚିହିଁ ଜ଼ମିନି ଦିନାତି ନ଼କିତି ଦିନା ମାଚାକି, ");
INSERT INTO kxv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ହାରାମାତିୟାତି ଜସେପ ଦ଼ରୁଗାଟି କାଜା ବେ଼ରଣିମାଣ୍ତାତି ମା଼ନି ଗାଟାସି ମାଚେସି, ଇଞ୍ଜାଁ ଆମିନିଗାଟାସି ତା଼ନୁଏ ମାହାପୂରୁତି ରା଼ଜି କା଼ଚିମାଚେସି, ଏ଼ୱାସି ସା଼ସାତଲେ ପିଲାତ ତା଼ଣା ହାଜାନା ଜୀସୁତି ଆଙ୍ଗା ରୀସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ସାମା ଏ଼ୱାସି ହା଼ତେସିଏ ଈ କାତା ପିଲାତ ୱେଞ୍ଜାନା କାବା ଆ଼ତେସି, ଇଞ୍ଜାଁ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ଡାଗେ ହା଼ଟାନା ୱେଚେସି, “ଏ଼ୱାସି ହା଼ହାନା ହା଼ରେକା ବେ଼ଲା ଆ଼ତେୟିଏ ?” ");
INSERT INTO kxv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣି ତା଼ଣାଟି ଏ଼ କାତା ପୁଞ୍ଜାନା ଆଙ୍ଗାତି ଅ଼ହାଲି ଜସେପଇଁ ହେଲ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଏ଼ୱାସି ର଼ ପା଼ତାଡ଼ା ହିମ୍ବରି କଡାନା ଏ଼ୱାଣାଇଁ ରେ଼ପ୍‌ହା ତାଚାନା ଏ଼ ହିମ୍ବରି ରୂପିତେସି ଇଞ୍ଜାଁ ହ଼ରୁତା କା଼ର୍‌ହାମାନି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ଏ଼ୱାଣାଇଁ ଇଟାନା ଦୁୱେରିତା ର଼ କାଜା ୱାଲି ଊସି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ଏ଼ୱାଣାଇଁ ଆମିନି ଟା଼ୟୁତା ଇଟ୍‌କି ଆ଼ହାମାନେ, ଏ଼ଦାଆଁ ମଗ୍‌ଦଲିନି ମରିୟମ ଇଞ୍ଜାଁ ଜସି ତାମି ଇୟା ମରିୟମ ମେସାମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ଜ଼ମିନି ଦିନା ରାୟାଲିଏ ମଗ୍‌ଦଲିନି ମରିୟମ, ଜାକୁବ ତାମି ଇୟା ମରିୟମ, ଇଞ୍ଜାଁ ସାଲମି ଗାନ୍ଦାଗାଟି ନିୟୁଁ କଡିତୁ, ଏ଼ନିକିଁ ଏ଼ୱି ହାଜାନା ଜୀସୁ ଆଙ୍ଗାତା ରୁବାଲି ଆ଼ଡିନୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ଏ଼ୱି ୱା଼ରାତି ମୂଲୁ ଦିନା ଲା଼ଇ ୱେ଼ଡ଼ା ହ଼ନି ବେ଼ଲାତା ମାହ୍‌ଣି ମାଣ୍ତାତା ହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ଏ଼ୱି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ୱେସ୍‌ପି ଆ଼ହିମାଚୁ, “ଆମ୍ବାଆସି ମାଙ୍ଗେତାକି ମାହ୍‌ଣି ମାଣ୍ତା ଦୁୱେରିତି ୱାଲି ଊସିକିହା ହିୟାନେସି ?” ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ ୱାଲି ହା଼ରେକା କାଜାୟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ସାମା ଏ଼ୱି ଏମ୍ବାଆଁ ସିନିକିନି ବେ଼ଲାତା, ୱାଲି ଊସିକିୱି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ଏ଼ୱି ମାହ୍‌ଣି ମାଣ୍ତାତା ହ଼ଡାନା ଦବ୍‌ଲା ହିମ୍ବରି ହୁଚାମାନି ର଼ ଦାଂଗ୍‌ଣେଏଣାଇଁ ଟିଃନିୱାକି କୁଗାମାନାଣି ମେସାନା ହା଼ରେକା କାବାଆ଼ତୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାସିକାଣି ଏଲେଇଚେସି, “ଆଜାଆଦୁ; ମୀରୁ ପା଼ସି ମୁଣ୍ତାତା ହା଼ହାମାନି ନା଼ଜରିତ ଜୀସୁଇଁ ପାରିମାଞ୍ଜେରି; ଏ଼ୱାସି ନିଙ୍ଗାମାନେସି, ଏ଼ୱାସି ଇମ୍ବାଆଁ ହିଲଅସି, ସିନିକିଦୁ ଇମ୍ବାଆଁ ଏ଼ୱାଣାଇଁ ଇଟାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ସାମା ମୀରୁ ହାଜାନା ତାମି ସୀସୁୟାଁ ଇଞ୍ଜାଁ ପିତରଇଁ ୱେହ୍‌ଦୁ, ଏ଼ୱାସି ମୀ ନ଼କି ନ଼କିତା ଗାଲିଲିତା ହାଜିମାନେସି; ଏ଼ୱାସି ମିଙ୍ଗେ ଏ଼ନିକିଁ ୱେସାମାଞ୍ଜାତେସି, ଏଲେକିହିଁଏ ମୀରୁ ଏ଼ୱାଣାଇଁ ଏମ୍ବାଆଁ ମେହ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ଏମ୍ବାଟିଏ ଏ଼ୱି ମାହ୍‌ଣି ମାଣ୍ତାଟି ହଟୁ, ଇଚିହିଁ ଏ଼ୱି କାବା ଆ଼ହାନା ଆଜିତାକି ତୀର୍‌ଗିମାଚୁ, ଇଞ୍ଜାଁ ଆମ୍ବାଆରାଇଁ ଏ଼ନାଆଁ ୱେହ୍‌ଆତୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ୱା଼ରାତି ମୂଲୁତି ଦିନା ଲାଇସିଏ ଏ଼ୱାସି ୱେଣ୍ତେ ନିଙ୍ଗାନା, ଆମିନିଗାଟାଣି ସା଼ତାଗଟା ବୂତୁୟାଁ ପିସ୍‌ପି କିହାମାଚେସି, ଏ଼ ମଗ୍‌ଦଲିନି ମରିୟମନି ତଲିଏ ତ଼ଞ୍ଜାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ଏ଼ଦି ହାଜାନା ଆମିନି ଗାଟାରି ତାମିତଲେ ମାଚେରି, ଏ଼ୱାରାଇଁ ୱେସ୍ତେ; ଇଚିହିଁ ଏ଼ୱାରି ଦୁକୁଟି ଡ଼ୀହି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ଜୀସୁ ନୀଡାମାନେସି, ଇଞ୍ଜାଁ ଏ଼ଦାନି ତ଼ଞ୍ଜା ଆ଼ହାମାନେସି, ଈଦାଆଁ ୱେଞ୍ଜାନା ଏ଼ୱାରି ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଏଚେଟିଏ ଈ ବାରେ ଆ଼ତି ଡା଼ୟୁ ଏ଼ୱାରି ବିତ୍ରାଟି ରୀ ସୀସୁୟାଁ ର଼ ନା଼ୟୁଁତା ହାଜିମାଚାଟି ଏ଼ୱାସି ଅ଼ର ୱା଼ଣା ତଲେ ଏ଼ୱାରାଇଁ ତ଼ଞ୍ଜାଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଇଞ୍ଜାଁ ଏ଼ୱାରି ହାଜାନା ଏଟ୍‌କା ତାରାଇଁ ୱେସ୍ତେରି; ସାମା ଏ଼ୱାରି କାତା ଜିକେଏ ଏ଼ୱାରି ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ଏମ୍ବାଟିଏ ଏଗାର ଜା଼ଣା ସୀସୁୟାଁ ତିଞ୍ଜାଲି କୁଗାମାଚାଟି ଜୀସୁ ଏ଼ୱାରାଇଁ ତ଼ଞ୍ଜାଆ଼ତେସି ଇଞ୍ଜାଁ ଏ଼ୱାରି ନାମିହିଲାଆତାକି ଇଞ୍ଜାଁ ହିୟାଁତି ଆ଼ଟ୍‌ୱାତାକି ଏ଼ୱାରାଇଁ ଦାକା ହୀତେସି, ଇଚିହିଁ ଆମିନି ଗାଟାରି ଏ଼ୱାଣି ୱେଣ୍ତେ ନିଙ୍ଗିତାଣି ମେସାମାଚେରି, ଏ଼ୱାରି କାତା ଏ଼ୱାରି ନାମା ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ବାରେ ଦାର୍‌ତିତା ହାଜାନା ବାରେ କୂଡ଼ାତି ଲ଼କୁତା଼ଣା ନେହିଁ କାବ୍ରୁ ୱେହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଆମ୍ବାଆସି ନାମାନା ବାପ୍ତିସ୍ମ ଅ଼ନେସି ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି; ସାମା ଆମ୍ବାଆସି ନାମଅସି ଏ଼ୱାସି ଡଣ୍ତ ବେଟାଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ଇଞ୍ଜାଁ ନାମିନାରାକି ଈ ସିନାୟାଁ ଆ଼ନୁ, ଏ଼ୱାରି ନା଼ ଦ଼ରୁତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିନେରି, ପୁଃନି ପୁଃନି ହା଼ଡାତଲେ ଜ଼ଲିନେରି, ");
INSERT INTO kxv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","କେସ୍କାତଲେ ରା଼ସ୍‌କା ଆହ୍‌ନେରି, ଇଞ୍ଜାଁ ହା଼ନି ଅସ ଗସ୍ତିହିଁ ଜିକେଏ ଏ଼ୱାରି ଏ଼ନାଆଁ ଆ଼ଅରି; ଏ଼ୱାରି ନ଼ମେରି ଦୁକା ଗାଟାରି ଲାକ କେୟୁ ଇଟିତିହିଁ ଏ଼ୱାରି ନେହିଁ ଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଇଲେକିହିଁ ଏ଼ୱାରାଇଁ ବାରେ କାତା ୱେସ୍ତି ଡା଼ୟୁ ଜୀସୁ ଲାକପୂରୁ ଅ଼ୱିଆ଼ହାନା ମାହାପୂରୁତି ଟିଃନିୱାକି କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ସାମା ଏ଼ୱାରି ହାଜାନା ବାରେୱାକି କାବ୍ରୁ ୱେସ୍ତେରି, ଇଞ୍ଜାଁ ପ୍ରବୁ ଜୀସୁ ଏ଼ୱାରିତଲେ କାମା କିହାନା ତାନି ବାରେ ସିନାୟାଁ ତଲେ ଏ଼ୱାରି ୱେ଼କ୍‌ହାମାନାଣି ସାତା ଇଞ୍ଜିଁ ତ଼ସ୍ତେସି ।");
INSERT INTO kxv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ମୂଲୁଟିଏ ଆମ୍ବାଆରି ତୀରେ ମେସ୍ତାରି ଇଞ୍ଜାଁ ବ଼ଲୁ ୱେ଼କ୍‌ନାରି, ଏ଼ୱାରି ମାଙ୍ଗେ ହେର୍‌ପା ମାଞ୍ଜାନି ଲେହେଁ, ");
INSERT INTO kxv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ମା଼ ବିତ୍ରା ଆ଼ହାମାନି କାମା ବାରେ ହା଼ରେକା ନେହିଁକିଁ ରା଼ଚାଲି ଜାଗ୍ରାତା ଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଜୀୱୁତି ତିୟପିଲ, ମୂଲୁଟିଏ ବାରେ କାତା ନେହିଁକିଁ ସିନିକିହାନା ଏମ୍ବାଆଁ ଏ଼ନାୟି ମାନେ ଏ଼ଦାଆଁ ନିଙ୍ଗେତାକି ରା଼ଚାଲି ନା଼ନୁ ଜିକେଏ ନେହେଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଏ଼ନିକିଁ ନୀନୁ ଏ଼ ବାରେ କାତା ଜା଼ପାମାଞ୍ଜି, ଏ଼ଦି ସାତା ଇଞ୍ଜିଁ ପୁଞ୍ଜାଲି ଆ଼ଡିଦି । ");
INSERT INTO kxv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜୀହୁଦା ଦେ଼ସାତି ରାଜା ହେରଦ ବେ଼ଲାତା ଅବିୟ କୂଡ଼ାତି ଜିକରିୟ ଦ଼ରୁଗାଟି ର଼ ପୂଜେରା ମାଚେସି; ତାନି ଡକ୍ରି ହାରଣ କୂଡ଼ାତି ମା଼ଙ୍ଗା, ଏ଼ଦାନି ଦ଼ରୁ ଏଲିସାବେତ । ");
INSERT INTO kxv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ଜିକରିୟ ଅ଼ଡ଼େ ଏଲିସାବେତ ମାହାପୂରୁତି ହୁକୁମି ଇଞ୍ଜାଁ ମେ଼ରା ତଲେ ଦ଼ହ ହିଲାଆଗାଟାଇ ଆ଼ହାନା ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁ ଗାଟାଇ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ସାମା ଏ଼ୱାରାକି କକାରି ପ଼ଦାୟାଁ ହିଲାଆତୁ, ଇଚିହିଁ ଏଲିସାବେତ ବା଼ଞ୍ଜେଣି ମାଚେ, ଅ଼ଡ଼େ ଡକ୍ରି ଡକ୍ରା ରିଆରି ଜିକେଏ ଗାଡି ବୁଡ଼୍‌ହି ବୁଡ଼୍‌ହା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ର଼ ଦିନା ଜିକରିୟ ତାମି ଗଚିତି ପା଼ଲି ଏଜାଲିଏ ମାହାପୂରୁ ନ଼କିତା ପୂଜେରା କାମା କିନି ବେ଼ଲାତା, ");
INSERT INTO kxv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ପୂଜେରା କାମାତି ମେ଼ରା ତଲେ ଆ଼ଚ୍‌ୱି ଆ଼ହାନା ଏ଼ୱାଣାକି ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଦୁପ୍‌ଣି ହୀହାଲି ଆ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଇଞ୍ଜାଁ ଦୁପ୍‌ଣି ହୀନି ବେ଼ଲାତା ବାରେ ଲ଼କୁ ପାଙ୍ଗାତା ପ୍ରା଼ତାନା କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ଏଚିବେ଼ଲା ମାହାପୂରୁତି ର଼ ଦୂତୁ ଦୁପ୍‌ଣି ପିଣ୍ତା ଟିଃନିୱାକି ନିଚାନା ଏ଼ୱାଣାଇଁ ତ଼ଞ୍ଜାଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିୟ ଏ଼ଦାଣି ମେସାନା କାବାଆ଼ହାନା ଆଜିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ସାମା ଦୂତୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ଜିକରିୟ, ଆଜାଆନି, ଇଚିହିଁ ମୀ ଗ଼ହାରା ୱେଣ୍‌ମ୍ବି ଆ଼ହାମାନେ, ଇଞ୍ଜାଁ ନୀ ଡକ୍ରି ଏଲିସାବେତ ନିଙ୍ଗେତାକି ର଼ କକାଣାଇଁ ଜାର୍ନି କିନେ, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଦ଼ରୁ ଜହନ ଇଞ୍ଜିଁ ହୀଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ଇଚିହିଁ ଏ଼ୱାସି ମୀ ରା଼ହାଁତି ରା଼ହାଁ ଆ଼ନେସି, ଇଞ୍ଜାଁ ହା଼ରେକା ଏ଼ୱାଣି ଜାର୍ନାତା ରା଼ହାଁ କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଇଞ୍ଜାଁ ଏ଼ୱାସି ମାହାପୂରୁ ନ଼କିତା କାଜାସି ଆ଼ନେସି; ଏ଼ୱାସି ଅଙ୍ଗୁରି ରାସା କି କା଼ଡ଼ୁ ଏଚେଲାୱା ଗହ୍‌ଅସି, ଇଞ୍ଜାଁ ତାଲିନି ବାଣ୍ତିଟିଏ ସୁଦୁଜୀୱୁତା ବେଟାଆ଼ନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଏ଼ୱାସି ଇସ୍ରାୟେଲ ମୀର୍‌କା ବିତ୍ରାଟି ହା଼ରେକା ଲ଼କୁଇଁ ମାହାପୂରୁ ୱାକି ୱେଟ୍‌ହା ତାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ତାଞ୍ଜିୟାଁ ହିୟାଁ ମୀର୍‌କା ୱାକି ଇଞ୍ଜାଁ କାତା ମା଼ନୱି ଆ଼ଆଗାଟାରାଇଁ ତୀରିଗାଟି ବୁଦିତା ତା଼କାଲି ୱେଟ୍‌ହା ତାଚାଲି ଇଞ୍ଜାଁ ମାହାପୂରୁ ତାକି ତିୟାରା ଆ଼ହାମାନି ର଼ ଲ଼କୁତି କୁଲମି ଜାଗ୍ରାତା କିହାଲି ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ଏଲିୟତି ଜୀୱୁ ଅ଼ଡ଼େ ବା଼ଡ଼୍‌ୟୁ ତଲେ ପ୍ରବୁତି ନ଼କିତା ତା଼କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଏଚେଟିଏ ଜିକରିୟ ଦୂତୁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମିନି ସିନା ତଲେ ପୁଇଁ ? ଇଚିହିଁ ନା଼ନୁ ବୁଡ଼୍‌ହାତେଏଁ, ଇଞ୍ଜାଁ ନା଼ ଡକ୍ରିନି ବାର୍ସା ଗାଡି ଆ଼ତେୟିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ଦୂତୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ନା଼ନୁ ଗାବ୍ରିୟେଲ, ନା଼ନୁ ମାହାପୂରୁ ନ଼କିତା ନିଚା ଡ଼ୟିନାତେଏଁ, ଇଞ୍ଜାଁ ନିଙ୍ଗେ ୱେସାଲି ଅ଼ଡ଼େ ଈ ନେହିଁ କାବ୍ରୁ ପୁଣ୍‌ମ୍ବି କିହାଲି ନା଼ନୁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ମେହ୍‌ମୁ ଈ ବାରେ ଆ଼ଆପାତେକା ନୀନୁ ବେବ୍‌ଡ଼ା ଆ଼ହାନା ଡ଼ୟିଦି, ଇଚିହିଁ ନା଼ ଆମିନି କାତା ସାତା ଆ଼ନେ ଏ଼ ବାରେ ନୀନୁ ନାମାଆତି ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଏମ୍ବାଟିଏ ଲ଼କୁ ଜିକରିୟଇଁ କା଼ଚିମାଚେରି, ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା ଇଚେକା ୱେ଼ଡ଼ା ଆ଼ତାକି କାବା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ସାମା ଏ଼ୱାସି ପାଙ୍ଗାତା ୱା଼ହାନା ଏ଼ୱାରାଇଁ କାତା ଆ଼ହାଲି ଆ଼ଡାଆତେସି; ଏମ୍ବାଟିଏ ଏ଼ୱାସି ମାହାପୂରୁ ଇଲୁତା ଏ଼ନାଆଁ ମେସାମାନେସି ଇଞ୍ଜିଁ ଏ଼ୱାରି ପୁଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ କେୟୁ ହୂଟିହିଁ ତ଼ସାଲି ମା଼ଟ୍‌ହେସି ଇଞ୍ଜାଁ ବେବ୍‌ଡ଼ା ଆ଼ହାନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ଡା଼ୟୁ ମାହାପୂରୁ ଇଲୁତି ସେ଼ବା କାମା ରାୟାଲିଏ, ଏ଼ୱାସି ତାମି ଇଜ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ଏଚରଦିନା ହାଚି ଡା଼ୟୁ ତାନି ଡକ୍ରି ଏଲିସାବେତ ପୂରାମା଼ସା ଆ଼ତେ ଅ଼ଡ଼େ ଏ଼ଦି ପା଼ସା ଲେ଼ଞ୍ଜୁ ପାତେକା ଲ଼କୁଣି ତ଼ଞ୍ଜା ଆ଼ଆତେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ଏ଼ଦି ଏଲେଇଚେ, “ନୀଏଁ ନାଙ୍ଗେ ପ୍ରବୁ କାର୍ମାମେସାନା ଲ଼କୁ ନାଙ୍ଗେ ଲାଜା କିହିମାଞ୍ଜାତାଣି ପିସ୍‌ପି କିହାଲି ନାଙ୍ଗେ ଇଲେକିଁ କିହାମାଞ୍ଜାନେସି !” ");
INSERT INTO kxv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିସାବେତ ପୂରାମା଼ସା ଆ଼ହାନା ସ଼ ଲେ଼ଞ୍ଜୁ ଆ଼ହାଲିଏ ଗାବ୍ରିୟେଲ ଦୂତୁ ମାହାପୂରୁ ତା଼ଣାଟି ଗାଲିଲିତି ନା଼ଜରିତ ଗା଼ଡ଼ାତି ର଼ ଡ଼ାଆ ପ଼ଦାନି ତା଼ଣା ପାଣ୍ତ୍‌ୱିଆ଼ତେ; ");
INSERT INTO kxv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଏ଼ ଡ଼ାଆ ପ଼ଦାନି ଦାୱୁଦ କୂଡ଼ାତି ଜସେପ ଇନାଣାକି ରୀସା ମାଚେରି; ଏ଼ ଡ଼ାଆ ପ଼ଦା ଦ଼ରୁ ମରିୟମ । ");
INSERT INTO kxv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ଦୂତୁ ପ଼ଦା ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେ, “ଆଲ ମାହାପୂରୁତି କାର୍ମା ମେହ୍‌ନାତି ନିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ !” ");
INSERT INTO kxv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମରିୟମ ଏ଼ ହା଼ଡା ୱେଞ୍ଜାନା ଈଦି ଏ଼ନିଲେହେଁତି କାତା ଇଞ୍ଜିଁ ଆଜାନା ମ଼ନତା ଅଣ୍‌ପିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ଏମ୍ବାଟିଏ ଦୂତୁ ଏଲେଇଚେ, “ଆଲ ମରିୟମ ଆଜାଆନି; ନିଙ୍ଗେ ମାହାପୂରୁ କାର୍ମା ମେସାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ନୀନୁ ପୂରାମା଼ସା ଆ଼ହାନା ର଼ ମୀର୍‌ଏଣାଇଁ ବେଟାଆ଼ଦି ଏ଼ୱାଣି ଦ଼ରୁ ଜୀସୁ ଇଞ୍ଜିଁ ଇଟିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ଏ଼ୱାସି କାଜାସି ଆ଼ନେସି ଇଞ୍ଜାଁ ମାହାପୂରୁ ମୀର୍‌ଏସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି; ପ୍ରବୁ ମାହାପୂରୁ ଏ଼ୱାଣାକି ତାମି ଆକୁ ଦାୱୁଦତି ସିଂଗାସାଣି ହୀନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ଏ଼ୱାସି ଜାକୁବ କୂଡ଼ାତା ଜୁଗୁ ଜୁଗୁତାକି ରା଼ଜି କିନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ରା଼ଜି ଏଚେଲାୱା ରା଼ଏ !” ");
INSERT INTO kxv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ସାମା ମରିୟମ ଦୂତୁଇଁ ଏଲେଇଚେ, “ଈଦି ଏ଼ନିକିଁ ଆ଼ନେ ? ନା଼ନୁ ଡକ୍ରାଇଁ ଜିକେଏ ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୂତୁ ଏଲେଇଚେ, “ସୁଦୁଜୀୱୁ ନୀ ଲାକ ରେ଼ଚାୱା଼ନେ ଅ଼ଡ଼େ ମାହାପୂରୁତି ବା଼ଡ଼୍‌ୟୁ ୱା଼ନେ, ଏ଼ଦାଆଁତାକି ନୀ ତା଼ଣାଟି ଜାର୍ନା ଆ଼ନେସି, ଏ଼ୱାସି ମାହାପୂରୁତି ମୀର୍‌ଏସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଅ଼ଡ଼େ ମେହ୍‌ମୁ ନୀ କୂଡ଼ାତି ଏଲିସାବେତ ଜିକେଏ ବୁଡ଼୍‌ହି ବେ଼ଲାତା ପୂରାମା଼ସା ଆ଼ହାମାନେ । ଆମିନି ଇୟା ବା଼ଞ୍ଜେଣି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗାମାନେ, ଏ଼ଦି ନୀଏଁ ସ଼ ଲେ଼ଞ୍ଜୁ ଆ଼ହାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ଇଚିହିଁ ମାହାପୂରୁତି ବ଼ଲୁ ବା଼ଡ଼୍‌ୟୁ ହିଲାଆଗାଟାୟି ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ଏମ୍ବାଟିଏ ମରିୟମ ଏଲେଇଚେ, “ନା଼ନୁତ ପ୍ରବୁତି ହ଼ଲେଣିତେଏଁ; ନୀ କାତେଏ ନାଙ୍ଗେତାକି ଆୟାପେ ।” ଏମ୍ବାଟିଏ ଦୂତୁ ଏ଼ଦାନି ତା଼ଣାଟିଏ ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଏମ୍ବାଟିଏ ମରିୟମ ନିଙ୍ଗାନା ଜୀହୁଦା ଦେ଼ସାତି ହ଼ର୍‌କା ରା଼ଜିତି ର଼ ଗା଼ଡ଼ାତା ତବେ ହାଚେ, ");
INSERT INTO kxv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଅ଼ଡ଼େ ଜିକରିୟ ଇଜ ହାଜାନା ଏଲିସାବେତନି ଜହରା କିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଅ଼ଡ଼େ ଏଲିସାବେତ ମରିୟମନି ଜହରା ୱେଣ୍‌ମ୍ବନିଏ ତାନି ବାଣ୍ତିତି ମୀଲା ୱୀଡିତେ, ଇଞ୍ଜାଁ ଏଲିସାବେତ ସୁଦୁଜୀୱୁଟି, ");
INSERT INTO kxv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେ, “ଇୟାସିକା ବିତ୍ରାଟି ନୀନୁ ହା଼ରେକା ନେହାଁତି, ଇଞ୍ଜାଁ ନୀ ବାଣ୍ତିତି ମୀଲା ଜିକେଏ ନେହାୟି ! ");
INSERT INTO kxv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ଅ଼ଡ଼େ ନା଼ ପ୍ରବୁତି ଇୟା ନା଼ ତା଼ଣା ୱା଼ନେ ଈ କାର୍ମା ନାଙ୍ଗେ ଏମ୍ବିଟି ୱା଼ତେ ? ");
INSERT INTO kxv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ଇଚିହିଁ ନୀ ଜହରା ହା଼ଡା ନା଼ କିର୍ୟୁଁ ୱେଣ୍‌ମ୍ବନିଏ ନା଼ ବାଣ୍ତିତି ମୀଲା ରା଼ହାଁଟି ୱୀଡିତେ ");
INSERT INTO kxv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଆମିନି ଗାଟାୟି ନାମିତେ ଏ଼ଦାନାକି ନେହେଁ, ଇଚିହିଁ ପ୍ରବୁ ତା଼ଣାଟି ଏ଼ଦାନାକି ଏ଼ନାଆଁ ୱେସ୍‌ପି ଆ଼ହାମାନେ ଏ଼ ବାରେ ପୂରା ଆ଼ନେ !” ");
INSERT INTO kxv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଏଚେଟିଏ ମରିୟମ ଏଲେଇଚେ, “ନା଼ ଜୀୱୁ ପ୍ରବୁତି ଜହରା କିହିମାନେ; ");
INSERT INTO kxv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଅ଼ଡ଼େ ନା଼ ଜୀୱୁ ନାଙ୍ଗେ ଗେଲ୍‌ପାନି ମାହାପୂରୁ ତା଼ଣା ରା଼ହାଁ ଆ଼ହିମାନେ, ");
INSERT INTO kxv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଇଚିହିଁ ଏ଼ୱାସି ତାନି ହ଼ଲେଣିନି କାର୍ମା କା଼କୁଲି ମେସାମାନେସି । ଏ଼ନିଇଚିହିଁ ନୀଞ୍ଜୁଟିଏ ବାରେ ଲ଼କୁ ନାଙ୍ଗେ ନେହାୟି ଇଞ୍ଜିଁ ଜ଼ଲାନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଇଚିହିଁ ଆମ୍ବାଆସି ବାରେକିହାଁ ବାଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ଏ଼ୱାସି ନା଼ ତାକି କାଜା କାମା କିହାମାନେସି, ଏ଼ୱାଣି ଦ଼ରୁ ସୁଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଇଞ୍ଜାଁ ତାଙ୍ଗେ ଆଜିନାରାକି ପା଼ଟୁ ପା଼ଟୁ ତାକି ତାନି କାର୍ମାମେହ୍‌ନାୟି ଡ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ଏ଼ୱାସି ତାନି ବାଡ଼୍‌ୟୁଗାଟି କେୟୁଟି କାଜା କାମା କିହାମାନେସି, ଡା଼ହାରା ଗାଟାରାଇଁ ଏ଼ୱାରି ହିୟାଁତି ଅଣ୍‌ପୁତା ମାନାଣି ଗୁଚି କିହାମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ଏ଼ୱାସି ସା଼ଲୱି କିନାରାଇଁ ତାମି ରାଜା ଗାଦି ପିସ୍‌ପି କିହାମାନେସି, କା଼କୁଲି ଗାଟାରାଇଁ ନିକ୍‌ହାମାନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ଏ଼ୱାସି ହାକି ଗାଟାରାଇଁ ନେହିଁ ଆ଼ସ୍ତି ହୀହାନା ପାଞ୍ଜି କିହାମାନେସି, ଇଞ୍ଜାଁ ଦ଼ନ ଗାଟାରାଇଁ ୱାର୍‌ଇ କେୟୁଟି ପାଣ୍ତାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","କା଼ଲାକା଼ଲା ତାକି ଅଣ୍‌ପାଲି ତାନି ହ଼ଲେଏସି ଇସ୍ରାୟେଲତି କାର୍ମା ଆ଼ହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","କା଼ଲାକା଼ଲା ତାକି ଅବ୍ରାହାମ ଅ଼ଡ଼େ ତାନି ବାରେ କୂଡ଼ାତାରାଇଁ କାର୍ମାମେହ୍‌ନାଣି ବା଼ଣା ଆ଼ହାହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଅ଼ଡ଼େ ମରିୟମ ତୀନି ଲେ଼ଞ୍ଜୁ ଏଲିସାବେତ ତଲେ ଡ଼ୟାନା ତାମି ଇଜ ୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ଡା଼ୟୁ ଏଲିସାବେତ ପୂରାମା଼ସା ଏଜାଲିଏ ର଼ କକାସି ଜାର୍ନା ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଅ଼ଡ଼େ ମାହାପୂରୁ ଏ଼ଦାନି ହା଼ରେକା କାର୍ମା ମେସାମାନାଣି ୱେଞ୍ଜାନା ତାମି କୂଡ଼ାତାରି ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ଆଟ୍‌ହିତାରି ଏ଼ଦାନିତଲେ ହା଼ରେକା ରା଼ହାଁ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","କକାସି ୱା଼ରେକା ଆ଼ହାଲିଏ, ଏ଼ୱାରି ତ଼ଲୁ ଦା଼ଚାଲି ୱା଼ହାନା ତାମି ଆ଼ବା ଦ଼ରୁଲେହେଁ ତାନି ଦ଼ରୁ ଜିକରିୟ ଇଟାଲି ମ଼ନ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ସାମା ତାମି ଇୟା ଏଲେଇଚେ, “ଆ଼ଏ ! ଏ଼ୱାଣି ଦ଼ରୁ ଜହନ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ଏ଼ୱାରି ଏଲେଇଚେରି, “ମୀ କୂଡ଼ାତା ଆମ୍ବାଆରାକି ଏଲେତି ଦ଼ରୁ ହିଲେଏ !” ");
INSERT INTO kxv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ତାଞ୍ଜିଗାଟାଣାଇଁ କେୟୁ ହୂଟାନା କକାଣାଇଁ ଏ଼ନି ଦ଼ରୁ ଇଟିନାୟି ଇଞ୍ଜିଁ ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ଜିକରିୟ ର଼ ରା଼ଚିନି ପା଼ଟା ରୀସାନା ଏ଼ୱାଣି ଦ଼ରୁ ଜହନ ଇଞ୍ଜିଁ ରା଼ଚିତେସି, ଏ଼ଦାଆଁ ମେସାନା ବାରେଜା଼ଣା କାବା ଆ଼ତେରି ! ");
INSERT INTO kxv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ଅ଼ଡ଼େ ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣି ଗୂତି ଅ଼ଡ଼େ ୱେନ୍ଦରି ପିସ୍‌ପି ଆ଼ତେ ଅ଼ଡ଼େ ଏ଼ୱାସି ଜ଼ଲିହିଁ ମାହାପୂରୁତି ଜହରା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ଏମ୍ବାଟିଏ ତାମି ଲ଼କୁ ବାରେ ଆଜାହାଚେରି, ଅ଼ଡ଼େ ଈ କାତା ଜୀହୁଦା ଦେ଼ସାତି ହ଼ର୍‌କା ରା଼ଜିତା ବାରେୱାକି ୱେ଼ଙ୍ଗିତେ, ");
INSERT INTO kxv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଇଞ୍ଜାଁ ୱେନି ବାରେ ଲ଼କୁ ଏ଼ କାତା ତାମି ମ଼ନତା ଇଟାନା ଏଲେଇଚେରି, “ଆତିହିଁ ଈ କକାସି ଏ଼ନିଲେହେଁତାସି ଆ଼ନେସି ?” ଏ଼ନିଇଚିହିଁ ପ୍ରବୁ ଈୱାଣି ତଲେ ମାନେସି ଇଞ୍ଜିଁ ପୁଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଅ଼ଡ଼େ ଜିକରିୟ ସୁଦୁଜୀୱୁ ତଲେ ଈ ଡା଼ୟୁ ଆ଼ନି କାତା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ଇସ୍ରାୟେଲତି ମାହାପୂରୁ ଜହରା ! ଏ଼ନିଇଚିହିଁ ଏ଼ୱାସି ତାନି ଲ଼କୁଣି କାର୍ମାମେସାନା ଗେଲ୍‌ପି କିହାମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ଏ଼ୱାସି ତାନି ହ଼ଲେଏସି ଦାୱୁଦ କୂଡ଼ାଟି ମା଼ ତାକି ର଼ ଗେଲ୍‌ପିନାଣାଇଁ ହୀହାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ତଲି କା଼ଲାଟିଏ ତାନି ନେହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଗୂତି ତଲେ ଏ଼ନିକିଁ ଜ଼ଲା ମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ଏଲେକିହିଁଏ ମାଙ୍ଗେ ମା଼ ସାତ୍ରୁୟାଁ ତା଼ଣାଟି ଅ଼ଡ଼େ ମାଙ୍ଗେ ଅ଼ପାଆଗାଟାରି ତା଼ଣାଟି ଗେଲ୍‌ପି କିହାମାଞ୍ଜାନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଏ଼ୱାସି ଏଲେ ଇଞ୍ଜାମାନେସି, ଏ଼ୱାସି ମା଼ ଆକୁୟାଁଣି କାର୍ମା ମେସାମାଇଁ ଅ଼ଡ଼େ ତାନି ସୁଦୁଗାଟି ରା଼ଜିମା଼ନାତି ଅଣ୍‌ପିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ମା଼ ଆ଼ବା ଅବ୍ରାହାମ ତା଼ଣା ଏନିମି ପାର୍‌ମାଣା କିହାଁ ଆ଼ଞ୍ଜାମାନାଣି ଅଣ୍‌ପାନା ପୂରା କିହାମାନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଅ଼ଡ଼େ ମା଼ ସାତ୍ରୁୟାଁ ତା଼ଣାଟି ଗେଲ୍‌ପି ଆ଼ହାନା, ଆଜାଆନା କା଼ଲେଏ ତାଙ୍ଗେ ସେ଼ବା କିହାଲି ଆ଼ଡିନାୟି, ");
INSERT INTO kxv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ତାନି ନ଼କିତା ମା଼ର ନୀଡାମାନି ପାତେକା ସୁଦୁ ଅ଼ଡ଼େ ଦାର୍ମୁ ଗାଟାତାୟି ଆ଼ହାନା ଡ଼ୟିନାୟି । ");
INSERT INTO kxv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ଏ଼ ନା଼ ମୀର୍‌ଏଣାତି ନୀନୁ ବାରେତି କିହାଁ ବା଼ଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିଦି; ");
INSERT INTO kxv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପା଼ପୁ ମ୍ଣେପ୍‌କି ଆ଼ହାନା ଏ଼ୱାରି ଗେଲ୍‌ପି ଆ଼ନାଣି ବେଟାଆ଼ନେରି, ଏ଼ କାତା ପୁଣ୍‌ମ୍ବି କିହାଲି ତାକି ତାନି ଲ଼କୁତା଼ଣା ହାଜି । ");
INSERT INTO kxv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଇଞ୍ଜାଁ ମାଙ୍ଗେ ହିତ୍‌ଡ଼ି ଜିରୁତା ତାଚାଲି ମା଼ ମାହାପୂରୁତି ଜୀୱୁନ଼ନି କାର୍ମାତଲେ ଲାକପୂରୁଟି ମାଙ୍ଗେତାକି ୱେ଼ଡ଼ା ହ଼ଚିମାନି ଲେହେଁ ଆ଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ଆମ୍ବାଆରି ହା଼ନିଲେହେଁତି ତା଼ଣା ବାସା କିନେରି, ହିତ୍‌ଡ଼ି ଜିରୁତା ଅ଼ହାଲି ତାକି ଏ଼ୱାସି ବାରେତି ଲାକ ଲାକପୂରୁଟି ଉଜେଡ଼ି ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଇଞ୍ଜାଁ ଏ଼ କକାସି ଆଙ୍ଗାତା ଜୀୱୁତା ପାଡାଆ଼ହାନା ଇସ୍ରାୟେଲ ଲ଼କୁତା଼ଣା ୱେ଼ଙ୍ଗାଆ ପାତେକା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଏଚିବେ଼ଲାତା ର଼ମ୍‌ ଦେ଼ସାତି ବାରେ ଲ଼କୁ ଦ଼ରୁ ରା଼ଚି କିହାଲି କାୟିସର ଅଗସ୍ତସ୍‌ ତା଼ଣାଟି ହୁକୁମି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସିରିୟାତି ସା଼ଲୱି କିନାସି କୁରିଣିୟ ବେ଼ଲାତା ତଲି ମୂଲୁ ଦ଼ରୁ ରା଼ସ୍‌କି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଏ଼ଦାଆଁତାକି ବାରେଜା଼ଣା ଦ଼ରୁ ରା଼ଚି କିହାଲି ନା଼ୟୁଁଟିଏ ଜାହାରା ଗା଼ଡ଼ାତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଜସେପ ଜିକେଏ ଦ଼ରୁ ରା଼ଚି କିହାଲି ମରିୟମନି ତଲେ ଗାଲିଲିତି ନା଼ଜରିତ ଗା଼ଡ଼ାଟି ଜୀହୁଦା ରା଼ଜିତି ବେତଲିହିମ ଇନି ଦାୱୁଦ ଗା଼ଡ଼ାତା ହାଚେସି, ଇଚିହିଁ ଏ଼ୱାସି ଦାୱୁଦ କୂଡ଼ା ଇଞ୍ଜାହାଁ ଏ଼ ଗଚିତାସି ମାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଏ଼ୱାସି ଦ଼ରୁ ରା଼ଚି କିୟାଲି ମରିୟମନି ତଲେ ହାଚେସି, ଏ଼ଦି ଏ଼ୱାଣାକି ବୀହା ଆ଼ହାଲି ରୀସ୍‌ପି ଆ଼ହାମାଚେ ଅ଼ଡ଼େ ଏ଼ଦି ପୂରାମା଼ସା ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଅ଼ଡ଼େ ଏ଼ ଲ଼କୁ ବେତଲିହିମତା ମାନିବେ଼ଲା, ଏ଼ଦାନାକି ଜାର୍ନିକିନି କାଟୁ ଏଗାୱା଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଇଞ୍ଜାଁ ଏ଼ଦି ତାନି ପା଼ଣ୍‌ୱା ମୀର୍‌ଏଣାଇଁ ଜାର୍ନିକିତେ ଇଞ୍ଜାଁ ହିମ୍ବରି ପ୍ଡିକ୍‌ହାନା କ଼ଡିୟାଁ ଗହ୍‌ନି ଡଂଗତା ତ୍ରିପ୍‌ହେ, ଇଚିହିଁ ଏ଼ ଲ଼କୁତାକି ବାସାଟା଼ୟୁ ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଏ଼ ଦାରିମାରି ନା଼ସ୍‌କାଣାଁ ମେ଼ଣ୍ତା ଗ଼ଡ଼୍‌କା ଲା଼ଆଁୟାଁ ପାଙ୍ଗାତା ଡ଼ୟାନା ମେ଼ଣ୍ତାୟାଁ କା଼ଚିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ପ୍ରବୁତି ର଼ ଦୂତୁ ଏ଼ୱାରିତା଼ଣା ୱା଼ତେ ଇଞ୍ଜାଁ ପ୍ରବୁତି ଗାୱୁରମିତି ଉଜେଡ଼ି ଏ଼ୱାରି ସା଼ରିୱାକି ତ଼ଞ୍ଜାଆ଼ତେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ହା଼ରେକା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ଏମ୍ବାଟିଏ ଦୂତୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେ, “ମୀରୁ ଆଜାଆଦୁ ! ନା଼ନୁ ମୀ ବାରେ ଲ଼କୁତାକି ହା଼ରେକା ରା଼ହାଁତି କାବ୍ରୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଇଚିହିଁ ନୀଞ୍ଜୁ ଦାୱୁଦ ଗା଼ଡ଼ାତା ମିଙ୍ଗେ ଗେଲ୍‌ପାନାସି ଜାର୍ନା ଆ଼ହାମାନେସି, ଏ଼ୱାସି କ୍ରୀସ୍ତ ପ୍ରବୁ । ");
INSERT INTO kxv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଅ଼ଡ଼େ ଈଦି ମିଙ୍ଗେତାକି ସିନାଲେହେଁ ଆ଼ନେ, ମୀରୁ ର଼ କକାଣାଇଁ ହିମ୍ବରି ପ୍ଡିକ୍‌ହାନା କ଼ଡିୟାଁ ଗହ୍‌ନି ଡଂଗତା ଡୂରାମାନାଣି ମେହ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଦେବୁଣିଏ ଏ଼ ଦୂତୁ ତଲେ ଲାକପୂରୁତି ହା଼ରେକା ଦୂତୁୟାଁ ୱା଼ହାନା ମାହାପୂରୁଇଁ ଜହରା ପା଼ଚୁ ପା଼ଚିତୁ, ");
INSERT INTO kxv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ଲାକପୂରୁ ମାହାପୂରୁତି ଗାୱୁରମି, ଅ଼ଡ଼େ ଦାର୍‌ତିତା ଏ଼ୱାଣି ରା଼ହାଁ ଇଞ୍ଜାଁ ମାଣ୍‌ସିୟାଁ ବିତ୍ରା ହିତ୍‌ଡ଼ି ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୂତୁୟାଁ ଏମ୍ବାଟି ଲାକପୂରୁ ହାଜାଲିଏ ମେ଼ଣ୍ତା ଗ଼ଡ଼୍‌କା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ କାତା ଆ଼ତେରି, “ମା଼ର ବେତଲିହିମ ପାତେକା ହାଜାନା ପ୍ରବୁ ମାଙ୍ଗେ ଆମିନି କାତା ୱେସାମାଞ୍ଜାନେସି ଏ଼ଦାଆଁ ସିନି କିକାନ ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଏମ୍ବାଟିଏ ତବେ ହାଜାନା ପାରାନା ମରିୟମ ଅ଼ଡ଼େ ଜସେପ ଇଞ୍ଜାଁ କ଼ଡିୟାଁ ଗହ୍‌ନି ଡଂଗତା ପୁଃନି ଜାର୍ନାଆ଼ତି କକାଣାଇଁ ଡୂରାମାନାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ଏ଼ୱାରି ଈ ବାରେ ମେସାନା ଏ଼ କକାଣି କାତା ଏ଼ନାଆଁ ଇଣ୍‌ମ୍ବି ଆ଼ହାମାଚେ ଏ଼ଦାଆଁ ୱେ଼କ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ମେ଼ଣ୍ତା ଗ଼ଡ଼୍‌କା ତା଼ଣାଟି ଏ଼ ବାରେ କାତା ୱେଚେରି, ଏ଼ୱାରି ବାରେ ଏ଼ କାତାତାକି କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ସାମା ମରିୟମ ଈ ବାରେ କାତା ହିୟାଁତା ଇଟାନା ହା଼ରେକା ଅଣ୍‌ପାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଅ଼ଡ଼େ ମେ଼ଣ୍ତା ଗ଼ଡ଼୍‌କାକି ଏ଼ନିକିଁ ୱେସ୍‌ପି ଆ଼ହାମାଚେ, ଏଲେକିହିଁଏ ଏ଼ୱାରି ଏ଼ନା ଏ଼ନାଆଁ ୱେଚେରି ଇଞ୍ଜାଁ ମେସ୍ତେରି ଏ଼ ବାରେତାକି ମାହାପୂରୁତି ଗାୱୁରମି ଅ଼ଡ଼େ ଜହରା କିହିଁ ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଏ଼ୱାଣାକି ଆ଼ଟାଦିନା ଆ଼ତେ ଅ଼ଡ଼େ ତ଼ଲୁ ଦା଼ଃନି ଦିନା ୱା଼ତେ ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଦ଼ରୁ ଜୀସୁ ଇଞ୍ଜିଁ ଇଟିତେରି; ଈ ଦ଼ରୁ ତାନି ପୂରାମା଼ସା ଆ଼ନି ନ଼କେଏ ଦୂତୁ ତା଼ଣାଟି ୱେସ୍‌ପି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ଅ଼ଡ଼େ ଏଚେ଼ତା ମ଼ସାତି ମେ଼ରା ତଲେ ଏ଼ୱାରି ଅଟ୍‌ହା କଡିନି ଦିନା ଏଗାୱା଼ତେ, ଏଚେଟିଏ ଜସେପ ଅ଼ଡ଼େ ମରିୟମ ଜୀସୁଇଁ ମାହାପୂରୁ ନ଼କିତା ଜିରୁସାଲମତା ଅ଼ହିଁ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ଏ଼ନିକିଁ ମାହାପୂରୁତି ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ବାରେ ପା଼ଣ୍‌ୱା ମୀର୍‌କା ପ୍ରବୁ ତାକି ସୁଦୁଗାଟାରି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଅ଼ଡ଼େ ମେ଼ରାତା ରା଼ସ୍‌କି ଆ଼ହାମାନି ଈ ମେ଼ରା ତଲେ ରୀ କୁଗୁରି ପଟାୟାଁ ଆ଼ଆତିଁ ରୀ ପା଼ର୍‌ୱା ପଟାୟାଁ ମାହାପୂରୁ ନ଼କିତା ପୂଜା କିହାଲି ଏ଼ୱାଣାଇଁ ଜିରୁସାଲମତା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଏଚିବେ଼ଲା ଜିରୁସାଲମତା ସିମିୟନ ଦ଼ରୁଗାଟି ର଼ ମାଣ୍‌ସି ମାଚେସି; ଏ଼ୱାସି ର଼ ଦାର୍ମୁଗାଟାସି ଅ଼ଡ଼େ ମାହାପୂରୁଇଁ ଆଜିନାସି ମାଚେସି, ଅ଼ଡ଼େ ଇସ୍ରାୟେଲ ଲ଼କୁ ବା଼ର୍ସୁ ବେଟାଆ଼ନାଣି କା଼ଚିମାଚେସି, ଇଞ୍ଜାଁ ସୁଦୁଜୀୱୁ ଏ଼ୱାଣି ତା଼ଣା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ମାହାପୂରୁ ପାଣ୍ତାନି କ୍ରୀସ୍ତଇଁ ମେହ୍‌ଆ ପାତେକା ଏ଼ୱାସି ହା଼ଅସି ଇଞ୍ଜିଁ ସୁଦୁଜୀୱୁ ତଲିଏ ୱେସାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ସିମିୟନ ସୁଦୁଜୀୱୁଟି ମାହାପୂରୁ ଇଲୁତା ୱା଼ତେସି; ଅ଼ଡ଼େ ତାଲି ତାଞ୍ଜି ମ଼ସାତି ମେ଼ରାଲେହେଁ କିହାଲି ଜୀସୁଇଁ ବିତ୍ରା ତାତୁ, ");
INSERT INTO kxv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଏଚିବେ଼ଲା ସିମିୟନ କକାଣାଇଁ ପମାନା ମାହାପୂରୁଇଁ ଜହରା କିତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ଼ ପ୍ରବୁ ନୀଏଁ ନୀନୁ ୱେସ୍ତିଲେହେଁ ନୀ ହ଼ଲେଏଣା ଜୀୱୁ ହିତ୍‌ଡ଼ିତଲେ ଅ଼ମୁ; ");
INSERT INTO kxv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ନା଼ କାନୁ ନୀ ଗେଲ୍‌ପିନାଣାଇଁ ମେସାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଏ଼ନିଇଚିହିଁ ବାରେ ଲ଼କୁତାକି କେ଼ପାମାନି ");
INSERT INTO kxv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଜୀହୁଦିଆ଼ଆତାରାକି ସାତା ତ଼ହ୍‌ନି ର଼ ଉଜେଡ଼ି ଆ଼ନେସି, ଅ଼ଡ଼େ ନୀ ଇସ୍ରାୟେଲ ଲ଼କୁତି ଗାୱୁରମି ଲେହେଁ କିହାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ଇଞ୍ଜାଁ ତାମି ଇୟା ଅ଼ଡ଼େ ଆ଼ବା ଏ଼ୱାଣି ତାକି ୱେସ୍‌ପି ଆ଼ହିମାନି ବାରେ କାତାତାକି କାବା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଏଚେଟିଏ ସିମିୟନ କକାଣାଇଁ ବ଼ର ହୀହାନା ତାମି ଇୟା ମରିୟମନି ଏଲେଇଚେସି, “ମେହ୍‌ମୁ ଈୱାସି ଇସ୍ରାୟେଲତି ହା଼ରେକା ଲ଼କୁଣି ନା଼ସା କିହାଲି ଅ଼ଡ଼େ ଗେଲ୍‌ପାଲି ଆ଼ଚ୍‌ୱି ଆ଼ହାମାନେସି, ଆମ୍ବାଆରି କ଼ପାଟି ହା଼ରେକା ଜ଼ଲିନେରି । ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣାଟି ର଼ ସିନାଲେହେଁ ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ଆ଼ଆତିଁ ନୀ ଜୀୱୁତା ଜିକେଏ କାଣ୍ତାତଲେ ଗ୍ଣାକ୍‌ହିସାରେ ହ଼ଚାହାନି ଲେହେଁ, ଏ଼ କସ୍ତ ନୀ ହିୟାଁତା ଆୟାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଅ଼ଡ଼େ ହାନା ଦ଼ରୁଗାଟି ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାୟି ମାଚେ; ଏ଼ଦି ଆସେର୍‌ କୂଡ଼ାତି ପନୁଏଲ ମା଼ଙ୍ଗା । ଏ଼ଦାନାକି ହା଼ରେକା ବାର୍ସା ଆ଼ହାମାଚେ; ଏ଼ଦି ଡ଼ାଆ ଆ଼ତି ଜେ଼ଚ ସାତା ବାର୍ସା ଡକ୍ରାତଲେ ବାସା କିହାମାଚେ, ଅ଼ଡ଼େ ସା଼ରିକ଼ଡ଼ି ସା଼ରି ବାର୍ସା ରା଼ଣ୍ତେଣି ଆ଼ହାନା ନୀଡାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ଏ଼ଦି ମାହାପୂରୁ ଇଲୁ ପିହ୍‌ଆନା ବାତିମା଼ଲିହିଁ ଲା଼ଆଁ ମାଦେନା ରା଼ନ୍ଦା ତିନାଆନା ପ୍ରା଼ତାନା କିହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ଏ଼ ଦେବୁଣିଏ ଏ଼ଦି ୱା଼ହାନା ମାହାପୂରୁତି ଜହରା କିହିଁ ଜିରୁସାଲମତି ଗେଲ୍‌ପିନାଣାଇଁ କା଼ଚି ମାନାରାଇଁ ଏ଼ୱାଣି କାତା ୱେସାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ଡା଼ୟୁ ଜସେପ ଅ଼ଡ଼େ ମରିୟମ ମାହାପୂରୁତି ମେ଼ରା ତଲେ ବାରେ କାମା ରା଼ପ୍‌ହାନା ଗାଲିଲିତି ତାମି ଗା଼ଡ଼ା ନା଼ଜରିତତା ୱେଣ୍ତା ୱା଼ତେରି ");
INSERT INTO kxv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଅ଼ଡ଼େ ଜୀସୁ ଆଙ୍ଗାତା ବୁଦିତା ଅ଼ଡ଼େ ବା଼ଡ଼୍‌ୟୁତା ପାଡା ଆ଼ତେସି, ଅ଼ଡ଼େ ମାହାପୂରୁତି କାର୍ମା ଏ଼ୱାଣିଲାକ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ତାମି ଇୟା ଆ଼ବା ବାରେ ବାର୍ସା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତାକି ଜିରୁସାଲମତା ହାଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜୀସୁ ବା଼ର ବାର୍ସା ଆ଼ହାଲିଏ ଏ଼ୱାରି ପାର୍ବୁତି ମେ଼ରାଲେହେଁ ଜିରୁସାଲମତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ଅ଼ଡ଼େ ପାର୍ବୁତି ଦିନା ରା଼ପ୍‌ହାନା ଏଚେ଼ତା ଏ଼ୱାରି ୱେଣ୍ତା ୱା଼ହିମାଚେରି, ଏଚିବେ଼ଲାତା ଊଣା କକାସି ଜୀସୁ ଜିରୁସାଲମତା ଡ଼ୟାହାଚେସି, ସାମା ତାମି ଇୟା ଆ଼ବା ପୁଞ୍ଜାହିଲାଆତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ସାମା ଏ଼ୱାରି ତାମିତଲେ ୱା଼ହାମାଚି ଲ଼କୁତଲେ ମାନେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ର଼ ଦିନାତି ଜିରୁ ହାଚେରି, ଅ଼ଡ଼େ ତାମି ଲ଼କୁ ଇଞ୍ଜାଁ ପୁଚି ଲ଼କୁତା଼ଣା ପାରାଲି ମା଼ଟ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ମେ଼ଡ଼ା ଆ଼ଆନା ପାରି ପାରି ଜିରୁସାଲମତା ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ତୀନିଦିନା ଡା଼ୟୁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ମାହାପୂରୁ ଇଲୁତା ବେଟାଆ଼ତେରି; ଏ଼ୱାସି ମେ଼ରାପୁନାରି କାତା ୱେଞ୍ଜିହିଁ ଏ଼ୱାରାଇଁ ୱେଣ୍ତେ କାତା ୱେଞ୍ଜିମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ଏ଼ୱାଣି କାତା ୱେଞ୍ଜିମାଚେରି, ବାରେଜା଼ଣା ଏ଼ୱାଣି ବୁଦିତା ଅ଼ଡ଼େ ୱେହ୍‌ନି କାତାତା କାବା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଏଚିବେ଼ଲା ତାମି ଇୟା ଆ଼ବା କକାଣାଇଁ ମେସାନା କାବାଆ଼ତୁ ଇଞ୍ଜାଁ ତାମି ଇୟା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ମୀର୍‌ଏଣା ମାଙ୍ଗେ ଏ଼ନାଆଁତାକି ଇଚେକା ଦୁକୁ ହିୟାତି ? ମେହ୍‌ମୁ ନା଼ନୁ ଅ଼ଡ଼େ ମୀ ଆ଼ବା ଏଚେକା ଦୁକୁଆ଼ହିଁ ନିଙ୍ଗେ ପାରିମାଞ୍ଜାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ମୀରୁ ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ପାରିମାଞ୍ଜାଦେରି ? ନା଼ ଆ଼ବା ଇଜ ନା଼ନୁ ମାନାଣି ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ସାମା ଏ଼ୱାସି ଆମିନି କାତା ଜ଼ଲିତେସି, ତାମି ଇୟା ଆ଼ବା ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ଡା଼ୟୁ ଜୀସୁ ତାମି ଇୟା ଆ଼ବା ତଲେ ୱେଣ୍ତେ ନା଼ଜରିତତା ୱା଼ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି କାତା ମା଼ନୱି ଆ଼ହାନା ଡ଼ୟିତେସି, ଅ଼ଡ଼େ ତାମି ଇୟା ଈ ବାରେ କାତା ଜାଗ୍ରାତା ତଲେ ମ଼ନତା ଇଟାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଅ଼ଡ଼େ ଜୀସୁ ଆଙ୍ଗାତା, ବୁଦିତା ଇଞ୍ଜାଁ ମାହାପୂରୁ ଅ଼ଡ଼େ ମାଣ୍‌ସିୟାଁ କାର୍ମାଟି ପାଡା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିୟା କାୟିସରତି ସା଼ଲୱି କିନି ପନ୍ଦର ବାର୍ସା ଆୟାଲିଏ, ଏଚିବେ଼ଲା ପନ୍ତିୟ ପିଲାତ ଜୀହୁଦା ରା଼ଜିତି ସା଼ଲୱି କିନାସି ଅ଼ଡ଼େ ହେରଦ ଗାଲିଲି ରା଼ଜିତି ରାଜା ମାଚେସି, ଅ଼ଡ଼େ ତାମି ତାୟି ପିଲିପ ଇତୁରିୟା ଅ଼ଡ଼େ ତ୍ରାକନିତି ରା଼ଜି ଅ଼ଡ଼େ ଲୁସାନିୟା ଅବିଲିନିତି ରାଜା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ହାନାନ ଅ଼ଡ଼େ କୟାପା କାଜା ପୂଜେରା ମାଚେରି, ଏଚିବେ଼ଲାତା ମାହାପୂରୁତି ବ଼ଲୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଜିକରିୟ ମୀର୍‌ଏସି ଜହନ ତା଼ଣା ୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଏମ୍ବାଟିଏ ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ଜର୍ଦନ ଦାରିତି ବାରେ ନା଼ସ୍‌କାୱାକି ହାଜାନା ପା଼ପୁ ମ୍ଣେପ୍‌କି ଆ଼ହାଲି ମ଼ନ ୱେଟ୍‌ହାନା ବାପ୍ତିସ୍ମ ଅ଼ନି କାତା ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଏ଼ନିଇଚିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ରଅଣି ହା଼ଡା ୱେ଼ଙ୍ଗିମାନେ; ପ୍ରବୁତି ଜିରୁ ନେହିଁ କେ଼ପାଦୁ; ଅ଼ଡ଼େ ଏ଼ୱାଣି କାଜା ଆଂଗେଣି ତିୟି କିଦୁ ! ");
INSERT INTO kxv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ବାରେ ଗା଼ଡ଼୍‌ଙ୍ଗା ନେଞ୍ଜି କିୱିଆ଼ନୁ, ବାରେ ହ଼ର୍‌କା ମେଟାୟାଁ ଊଣା କିୱିଆ଼ନୁ, ଡଂଗିତି ଜିରୁ ତିୟି କିୱିଆ଼ନେ, କାଡ଼୍‌ଦି ଡେପା ବୂମିତି ବାରେ ସମାନା କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ବାରେ ଦାର୍‌ତିତି ଲ଼କୁ ମାହାପୂରୁତି ଗେଲ୍‌ପିନାଣି ମେହ୍‌ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଏଲେକିହିଁ, ଜହନ ତା଼ଣାଟି ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ୱା଼ହିମାନି ଲ଼କୁଣି ମେସାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ ରା଼ସ୍‌କା କୂଡ଼ାତାତେରି ମାହାପୂରୁ ପାଣ୍ତାମାଞ୍ଜାନି କ଼ପାଟି ପିସ୍‌ପି ଆ଼ହାଲି ମାଙ୍ଗେ ଆମ୍ବାଆସି ସେତ୍‌ନା ହିୟାତେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ଏ଼ଦାଆଁତାକି ମ଼ନ ୱେଟ୍‌ହାକଡିତି ନେହିଁ କାମା ତ଼ହ୍‌ଦୁ; ଅ଼ଡ଼େ ଅବ୍ରାହାମ ମା଼ ଆ଼ବା ଇଞ୍ଜିହିଁ ଅଣ୍‌ପାଆଦୁ, ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ଈ ୱାଲ୍‌କାଟି ଜିକେଏ ଅବ୍ରାହାମତି ମୀର୍‌କାଣି ଗା଼ଡ଼ି କିହାଲି ଆ଼ଡିମାନେସି ! ");
INSERT INTO kxv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଅ଼ଡ଼େ ନୀଏଁ ଜିକେଏ ମା଼ର୍‌ନୁ ଡାକିତା କାଃଆଲି ଆଟାମାନେ; ଆମିନି ମା଼ର୍‌ନୁ ନେହିଁ ପା଼ଡ଼େୟି ଆ଼ୟେଏ ଏ଼ଦାନି ଟୂଣ୍‌ହାନା ହିଚୁତା ମେତ୍‌ପି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଏମ୍ବାଟିଏ ଲ଼କୁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଆତିହିଁ ମା଼ମ୍ବୁ ଏ଼ନାଆଁ କିନମି ?” ");
INSERT INTO kxv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଏ଼ୱାସି ଏଲେଇଚେସି, “ଆମ୍ବାଆରାକି ଜ଼ଡ଼େକା ସକାୟାଁ ମାନୁ, ଏ଼ୱାସି ଆମ୍ବାଆରାକି ହିଲାଉ ଏ଼ୱାଣାକି ରଣ୍ତାଆଁ ହୀପେସି; ଇଞ୍ଜାଁ ଆମ୍ବାଆରାକି କା଼ଦି ମାନେ ଏ଼ୱାସି ଜିକେଏ ଏଲେକିପାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ସିସ୍ତୁ ରୀହ୍‌ନାରି ଜିକେଏ ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ୱା଼ହାନା ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ମା଼ମ୍ବୁ ଏ଼ନାଆଁ କିନମି ?” ");
INSERT INTO kxv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମିଙ୍ଗେତାକି ଏଚେକା ମେ଼ରା ମାନେ ଏଚେକାଟିଏ ଆଗାଡ଼ା ରୀହ୍‌ଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ଏଚରଜା଼ଣା ରିଜାରି କ଼ସ୍‌କା ୱା଼ହାନା ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଏ଼ନାଆଁ କିନମି ?” ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବା଼ଡ଼୍‌ୟୁଟି କି ନା଼ଡ଼ିକିହାନା ଆମ୍ବାଆରି ଦ଼ନ ମୀଞ୍ଜା ଅ଼ଆଦୁ, ଅ଼ଡ଼େ ମୀରୁ ଏଚେକା ବେଟାଆ଼ଦେରି ଏଚେକା ତଲେଏ ନୀଡାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ଲ଼କୁ ମସିହାଇଁ କା଼ଚିମାଚେରି, ଇଞ୍ଜାଁ ଜହନଏ କ୍ରୀସ୍ତ ହାବୁଲା ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ବାରେଜା଼ଣା ତାମି ମ଼ନତା କାତା ଆ଼ହିମାଚାକି, ");
INSERT INTO kxv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଜହନ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁସାଁ ଏ଼ୟୁତଲେ ବାପ୍ତିସ୍ମ ହୀହିମାଞ୍ଜାଇଁ, ସାମା ନା଼ କିହାଁ ଆମ୍ବାଆସି ବା଼ଡ଼୍‌ୟୁ ଗାଟାସି ଏ଼ୱାସି ୱା଼ହିମାନେସି, ଏ଼ୱାଣି ସେପୁୟାଁତି ଡ଼଼ର୍କା ଜିକେଏ ହୁକ୍‌ହାଲି ନା଼ନୁ ପା଼ଡ଼ାଆ଼ଅଁ; ଏ଼ୱାସି ମିଙ୍ଗେ ସୁଦୁଜୀୱୁ ଅ଼ଡ଼େ ହିଚୁତଲେ ବାପ୍ତିସ୍ମ ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ତାନି କ୍ଡାନୁତି ତାସାଲି ଅ଼ଡ଼େ ତାନି ଆର୍ନାତି କ୍ଡସାହାଁ କୂଡ଼ି କିହାନା ଗା଼ଦେୟିତା ଇଟାଲି ଏ଼ୱାଣି କେୟୁତା ହେ଼ଚି ମାନେ, ଇଞ୍ଜାଁ ଟା଼ଟା ପ଼ଡ଼ୁତି ଏଚେଲା ଡୁମ୍ବାଆଗାଟି ହିଚୁତା ହୂଡା ତୁହ୍‌ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଏ଼ୱାସି ଇଲେତି ହା଼ରେକା କାତା ୱେସିହିଁ ଅ଼ଡ଼େ ରା଼ହାଁତି କାତା ଜ଼ଲିହିଁ ଲ଼କୁତା଼ଣା ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହି ମାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ସାମା ରାଜା ହେରଦ ତାମି ତାୟି ଡକ୍ରି ହେରଦିୟାନି କାତା ଅ଼ଡ଼େ ତା଼ନୁ କିହାମାନି ବାରେ ଲାଗେଏତି କାମାତାକି ଜହନ ତା଼ଣାଟି ଲା଼ଗି ବେଟା ଆ଼ହାମାଚାକି, ");
INSERT INTO kxv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ହେରଦ ଜହନଇଁ ଦସ୍‌ପାନା କା଼ୟିଦିତା ଇଟାନା ହା଼ରେକା ଲାଗେଏତି କାମା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ବାରେ ଲ଼କୁ ବାପ୍ତିସ୍ମ ଅ଼ତି ଡା଼ୟୁ ଜୀସୁ ଜିକେଏ ବାପ୍ତିସ୍ମ ଅ଼ହାନା ପ୍ରା଼ତାନା କିହିମାଚାଟି ହା଼ଗୁ ଦେପିଆ଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଅ଼ଡ଼େ ସୁଦୁଜୀୱୁ ପା଼ର୍‌ୱା ପଟାଲେହେଁ ଏ଼ୱାଣିଲାକ ରେ଼ଚାୱା଼ତେ; ଇଞ୍ଜାଁ ହା଼ଗୁଟି ଈ ହା଼ଡା ଆ଼ତେ, “ନୀନୁ ନା଼ ଜୀୱୁତି ମୀର୍‌ଏଣାତି ନୀ ତା଼ଣା ନା଼ ରା଼ହାଁ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜୀସୁ ସେ଼ବା କାମା ମା଼ଟ୍‌ହି ବେ଼ଲାତା ଏ଼ୱାଣାକି କଡ଼େଦସ ବାର୍ସା ଆ଼ହାମାଚେ; ଲ଼କୁତି କାତାତଲେ ଏ଼ୱାସି ଜସେପ ମୀର୍‌ଏସି; ଜସେପ ଏଲି ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମତାତ ମୀର୍‌ଏସି, ମତାତ ଲେ଼ବି ମୀର୍‌ଏସି, ଲେ଼ବି ମଲ୍‌କି ମୀର୍‌ଏସି, ମଲ୍‌କି ଜନୟ ମୀର୍‌ଏସି, ଜନୟ ଜସେପ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜସେପ ମତିତିୟା ମୀର୍‌ଏସି, ମତିତିୟା ଆମସ ମୀର୍‌ଏସି, ଆମସ ନାହୁମ ମୀର୍‌ଏସି, ନାହୁମ ହେସ୍‌ଲି ମୀର୍‌ଏସି, ହେସ୍‌ଲି ନଗୟ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମହତ ମୀର୍‌ଏସି, ମହତ ମତିତିୟସ୍‌ ମୀର୍‌ଏସି, ମତିତିୟସ୍‌ ସିମିୟି ମୀର୍‌ଏସି, ସିମିୟି ଜସେକ ମୀର୍‌ଏସି, ଜସେକ ଜଦା ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜଦା ଜହନ ମୀର୍‌ଏସି, ଜହନ ରେସା ମୀର୍‌ଏସି, ରେସା ଜିରୁବାବେଲ ମୀର୍‌ଏସି, ଜିରୁବାବିଲ ସଲ୍‌ଟିୟେଲ୍‌ ମୀର୍‌ଏସି, ସଲ୍‌ଟିୟେଲ୍‌ ନେରି ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲ୍‌କି ମୀର୍‌ଏସି, ମଲ୍‌କି ଅଦ୍‌ଦି ମୀର୍‌ଏସି, ଅଦ୍‌ଦି କସାମ ମୀର୍‌ଏସି, କସାମ ଏଲାଦାନ ମୀର୍‌ଏସି, ଏଲାଦାନ ଏର ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର ଜିହସୁୟ ମୀର୍‌ଏସି, ଜିହସୁୟ ଏଲିୟାଜର ମୀର୍‌ଏସି, ଏଲିୟାଜର ଜରିମ ମୀର୍‌ଏସି, ଜରିମ ମତାତ ମୀର୍‌ଏସି, ମତାତ ଲେ଼ବି ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେ଼ବି ସିମିୟନ ମୀର୍‌ଏସି, ସିମିୟନ ଜୀହୁଦା ମୀର୍‌ଏସି, ଜୀହୁଦା ଜସେପ ମୀର୍‌ଏସି, ଜସେପ ଜନାମ ମୀର୍‌ଏସି, ଜନାମ ଏଲିୟାକିମ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିୟାକିମ ମଲାହ ମୀର୍‌ଏସି, ମଲାହ ମନ୍‌ନା ମୀର୍‌ଏସି, ମନ୍‌ନା ମତତା ମୀର୍‌ଏସି, ମତତା ନାତନ ମୀର୍‌ଏସି, ନାତନ ଦାୱୁଦ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାୱୁଦ ଜିସି ମୀର୍‌ଏସି, ଜିସି ଅବେଦ ମୀର୍‌ଏସି, ଅବେଦ ବୟାଜ ମୀର୍‌ଏସି, ବୟାଜ ସେଲହ ମୀର୍‌ଏସି, ସେଲହ ନହସନ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହସନ ଅମିନାଦାବ ମୀର୍‌ଏସି, ଅମିନାଦାବ ଅଦ୍‌ମିନି ମୀର୍‌ଏସି, ଅଦ୍‌ମିନି ଅର୍‌ନି ମୀର୍‌ଏସି, ଅର୍‌ନି ହେସ୍ରଣ ମୀର୍‌ଏସି, ହେସ୍ରଣ ପେରସ ମୀର୍‌ଏସି, ପେରସ ଜୀହୁଦା ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜୀହୁଦା ଜାକୁବ ମୀର୍‌ଏସି, ଜାକୁବ ଇସାହାକ ମୀର୍‌ଏସି, ଇସାହାକ ଅବ୍ରାହାମ ମୀର୍‌ଏସି, ଅବ୍ରାହାମ ତେରହ ମୀର୍‌ଏସି, ତେରହ ନାହ଼ର ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହ଼ର ସରୁଗ ମୀର୍‌ଏସି, ସରୁଗ ରଗୁ ମୀର୍‌ଏସି, ରଗୁ ପେଲଗ ମୀର୍‌ଏସି, ପେଲଗ ଏବର ମୀର୍‌ଏସି, ଏବର ସେଲହ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲହ କେନାନ ମୀର୍‌ଏସି, କେନାନ ଅର୍ପକ୍ୟଦ ମୀର୍‌ଏସି, ଅର୍ପକ୍ୟଦ ସେମ ମୀର୍‌ଏସି, ସେମ ନ଼ହ ମୀର୍‌ଏସି, ନ଼ହ ଲେମକ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକ ମତୁସେଲହ ମୀର୍‌ଏସି, ମତୁସେଲହ ହନକ ମୀର୍‌ଏସି, ହନକ ଜେରଦ ମୀର୍‌ଏସି, ଜେରଦ ମହଲଲେଲ ମୀର୍‌ଏସି, ମହଲଲେଲ କେନାନ ମୀର୍‌ଏସି, ");
INSERT INTO kxv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ ଏନସ ମୀର୍‌ଏସି, ଏନସ ସେତ ମୀର୍‌ଏସି, ସେତ ଆଦମ ମୀର୍‌ଏସି, ଆଦମ ମାହାପୂରୁ ମୀର୍‌ଏସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜୀସୁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାନା ଜର୍ଦନ କାଡାଟି ୱେଣ୍ତାୱା଼ତେସି ଇଞ୍ଜାଁ ରୀ କ଼ଡ଼ି ଦିନା ପାତେକା ସୁଦୁଜୀୱୁ ତଲେ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ଏମ୍ବାଆଁ ଏ଼ୱାସି ସୟତାନ ତା଼ଣାଟି ତାୟିପାରି କିୱିଆ଼ତେସି । ଈ ରୀ କ଼ଡ଼ି ଦିନା ଏ଼ୱାସି ଏ଼ନାଆଁ ତିନାଆତେସି, ଅ଼ଡ଼େ ଏ଼ ରୀ କ଼ଡ଼ି ଦିନା ରା଼ହାଲିଏ ଏ଼ୱାସି ହାକି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ଏମ୍ବାଟିଏ ସୟତାନ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଇଚିହିଁ ଈ ୱାଲ୍‌କାଣି ରୂଟି ଆ଼ହାଲି ହୁକୁମି ହୀମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ମାଣ୍‌ସି ୱାର୍‌ଇ ରୂଟି ତିଞ୍ଜାନା ନୀଡଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ଅ଼ଡ଼େ ସୟତାନ କାଜା ହ଼ରୁ ଲାକ ଅ଼ହାନା ଗା଼ଡ଼େକା ତାକି ଦାର୍‌ତିତି ବାରେ ରା଼ଜି ଏ଼ୱାଣାଇଁ ତ଼ସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଇଞ୍ଜାଁ ସୟତାନ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ନା଼ନୁ ନିଙ୍ଗେ ଈ ବାରେ ଦ଼ନତି ଅଦିକାରା କିୟାଇଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ବାରେ ନାଙ୍ଗେ ହେର୍‌ପି ଆ଼ହାମାଞ୍ଜାନେ, ଅ଼ଡ଼େ ନା଼ନୁ ଆମ୍ବାଆରାକି ମ଼ନ ଏ଼ୱାଣାକି ହୀଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ଈଦାଆଁତାକି ନୀନୁ ନା଼ ନ଼କିତା ମେଣ୍ତାକୁତାନା ଜହରା କିୟାଦି, ଇଚିହିଁ ଈ ବାରେ ନୀଦି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜୀସୁ ଏଲେଇଚେସି, “ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ନୀନୁ ନୀ ମାହାପୂରୁଇଁ ଜହରା କିଦି, ଅ଼ଡ଼େ ୱାର୍‌ଇ ଏ଼ୱାଣି ସେ଼ବା କିଦି ।’” ");
INSERT INTO kxv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଅ଼ଡ଼େ ସୟତାନ ଏ଼ୱାଣାଇଁ ଜିରୁସାଲମତା ଅ଼ହାନା ମାହାପୂରୁ ଇଲୁ ତୂଡ଼ିୟା ଲାକ ନିପ୍‌ହାନା ଏଲେଇଚେ, “ନୀନୁ ମାହାପୂରୁତି ମୀର୍‌ଏଣାତି ଇଚିହିଁ ଇମ୍ବାଟି ଡ଼଼ଇକା ଗେ଼ମ୍ବାମୁ; ");
INSERT INTO kxv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଇଚିହିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ନିଙ୍ଗେ ଗେଲ୍‌ପାଲିତାକି ମାହାପୂରୁ ତାନି ଦୂତୁୟାଁଇଁ ହୁକୁମି ହୀନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଅ଼ଡ଼େ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ନୀ କଡାୟାଁ ଏ଼ନିକିଁ ୱାଲ୍‌କାଣା ଆ଼ଡାଉ ଏ଼ଦାଆଁତାକି ଏ଼ୱି ନିଙ୍ଗେ କେସ୍କାତଲେ ପେର୍‌ହା ଆସ୍ତାନୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ସାମା ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନୀନୁ ପ୍ରବୁ ନୀ ମାହାପୂରୁଇଁ ତାୟିପାରି କିଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ସୟତାନ ଜୀସୁଇଁ ବାରେ ତାୟିପାରି କିନାଣି ରା଼ପ୍‌ହାନା ଗା଼ଡ଼େକା ତାକି ଏ଼ୱାଣାଇଁ ପିସାନା ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଏ଼ ଡା଼ୟୁ ଜୀସୁ ସୁଦୁଜୀୱୁତି ବା଼ଡ଼୍‌ୟୁ ତଲେ ଗାଲିଲିତା ୱା଼ତେସି, ଅ଼ଡ଼େ ସା଼ରିୱାକି ଏ଼ୱାଣି କାତା ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ଜା଼ପ୍‌ହିହିଁ ବାରେ ଲ଼କୁ ତା଼ଣାଟି ଗାୱୁରମି ବେଟାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଅ଼ଡ଼େ ଏ଼ୱାସି ଆମିନି ନା଼ଜରିତତା ପ଼ହିପାଡି ଆ଼ହାମାଚେସି, ଏଚେ଼ତା ଏ଼ ଟା଼ୟୁତା ହାଚେସି ଅ଼ଡ଼େ ତାମି ମେ଼ରାଲେହେଁ ଜ଼ମିନି ଦିନାତା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଚେସି ଇଞ୍ଜାଁ ପ଼ଡ଼ୱି ଆ଼ହାଲି ନିତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ଏମ୍ବାଟିଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି ପତି ହୀତେରି, ଜୀସୁ ଏ଼ଦାଆଁ ଏ଼କ୍‌ହାନା ଏମିନିତା଼ଣା ଈ କାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ ଏ଼ କାତା ବେଟାଆ଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ପ୍ରବୁତି ଜୀୱୁ ନା଼ ତା଼ଣା ମାନେ, ଏ଼ନିଇଚିହିଁ ହିଲାଆ ଗାଟାରି ତା଼ଣା ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି ଏ଼ୱାସି ନାଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜାନେସି; କାୟିଦିତା ମାନାରାଇଁ ପିସ୍‌ପି ଆ଼ନାଣି ୱେ଼କ୍‌ହାଲି, କାଣ୍‌କା ମେହ୍‌ଆଗାଟାରାଇଁ ମେସ୍‌ପି କିହାଲି, ଦୁକୁ ବେଟାଆ଼ହି ମାନାରାଇଁ ଗେଲ୍‌ପାଲି, ");
INSERT INTO kxv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଇଞ୍ଜାଁ ମାହାପୂରୁ କାର୍ମା ମେସ୍ତାନି ବେ଼ଲାତି କାତା ୱେ଼କ୍‌ହାଲି ପ୍ରବୁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ଏମ୍ବାଟିଏ ଜୀସୁ ପତିତି ମୁଦା କିହାନା ସେ଼ବା କିନାଣି କେୟୁତା ହୀହାନା କୁଗିତେସି । ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା କୁଗାମାନି ବାରେ ଲ଼କୁ ଜୀସୁ ୱାକି ସିନିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନୀଞ୍ଜୁଟିଏ ଦାର୍ମୁ ପତିତି ଈ କାତା ମୀରୁ ୱେଣ୍‌ମ୍ବନିଏ ପୂରା ଆ଼ତେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଅ଼ଡ଼େ ବାରେଜା଼ଣା ତାନି କାତାତାକି ସା଼କି ହୀତେରି, ଅ଼ଡ଼େ ତାନି ଗୂତିଟି ହ଼ଚିମାନି କାର୍ମାତି ବ଼ଲୁତା କାବା ଆ଼ତେରି ଇଞ୍ଜାଁ ଏଲେଇଚେରି, “ଈୱାସି ଏ଼ନାଆଁ ଜସେପ ମୀର୍‌ଏସି ଆ଼ଏକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ସାତେଏ ନାଙ୍ଗେ ଏଲେ ଇଞ୍ଜାଦେରି, ଏ଼ ଅସଗୂରୁ ନୀନୁଏ ନିଙ୍ଗେ ନେହିଁ କିହାକଡାମୁ; କପର୍‌ନାହୁମତା ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଞ୍ଜି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ୱେଞ୍ଜାମାନମି ଏଲେକିଁ ମୀ ଆକୁ ଆ଼ବାୟାଁ ନା଼ୟୁଁତା ଜିକେଏ କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ନୁ ପାଡାଆ଼ତି ନା଼ୟୁଁତି ଲ଼କୁ ଅ଼ପଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏଲିୟ ବେ଼ଲାତା ଏ଼ନିକିଁ ତୀନି ବାର୍ସା ସ଼ ଲେ଼ଞ୍ଜୁ ପାତେକା ହା଼ଗୁଟି ପିୟୁ ରିଆତାକି ବାରେ ଦେ଼ସା କାର୍‌ୱୁ ଆ଼ହାମାଚେ, ଏଚିବେ଼ଲାତା ଇସ୍ରାୟେଲତା ହା଼ରେକା ରା଼ଣ୍ତେଣିସିକା ମାଚିହିଁ ଜିକେଏ; ");
INSERT INTO kxv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ଏଲିୟ ଏ଼ୱାସିକା ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ଆନା ସିଦନ ଦେ଼ସାତି ସାରିପତ ନା଼ୟୁଁତି ର଼ ରା଼ଣ୍ତେଣିନି ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଏଲିସାୟ ମାଚାଟି ଇସ୍ରାୟେଲ ବିତ୍ରା ହା଼ରେକା କାଜା ର଼ଗ ଗାଟାରି ମାଚେରି; ଆ଼ତିଜିକେଏ ଏ଼ୱାରି ବିତ୍ରାଟି ରଅସି ଜିକେଏ ନେହିଁ ଆ଼ଆତେସି, ସାମା ସିରିୟା ଦେ଼ସାତି ନାମାନ ନେହିଁ କିୱିଆ଼ତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ବାରେଜା଼ଣା କାର୍‌ବି ଆ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ଅ଼ଡ଼େ ଏ଼ୱାରି ନିଙ୍ଗାନା ଏ଼ୱାଣାଇଁ ଗା଼ଡ଼ାଟି ପାଙ୍ଗାତା ପେ଼ର୍‌ହେରି ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏମିନି ଗା଼ଡ଼ା ହ଼ରୁଲେକ ଦସାମାଚେରି ଏ଼ ହ଼ରୁ ଲାକଟି ଡ଼଼ଇକା ମେତ୍‌ହାଲି ଏ଼ୱାଣାଇଁ ଅ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ସାମା ଏ଼ୱାସି ଏ଼ୱାରି ମାଦିଟି ହ଼ଚାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଜୀସୁ କପର୍‌ନାହୁମ ଦ଼ରୁଗାଟି ଗାଲିଲିତି ର଼ ଗା଼ଡ଼ାତା ୱା଼ତେସି, ଇଞ୍ଜାଁ ଜ଼ମିନି ଦିନା ଲ଼କୁଣି ଜା଼ପ୍‌ହି ମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣି ଜା଼ପ୍‌ନି ତା଼ଣା କାବା ଆ଼ତେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାଣି ଜ଼ଲିନାୟି ଅଦିକାରା ଗାଟାୟି ଲେହେଁ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ର଼ ଦିନା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ର଼ ପ଼ଲ୍‌ଆ ବୂତୁ ଆଲ୍‌ଗାମାଚି ଲ଼କୁ ମାଚେସି; ଏ଼ୱାସି କିର୍‌ଡ଼ିହିଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଏ଼ ନା଼ଜରିତତି ଜୀସୁ ନୀ ତଲେ ମାଙ୍ଗେ ଏ଼ନାୟି ମାନେ ? ନୀନୁ ମାଙ୍ଗେ ନା଼ସା କିହାଲି ୱା଼ହାମାଞ୍ଜି କି ? ନୀନୁ ଆମ୍ବାଆତି ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ; ନୀନୁ ମାହାପୂରୁତି ସୁଦୁ ମାଣ୍‌ସିତି ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜୀସୁ ଏ଼ଦାନି ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ପାଲେଏ ଆ଼ମୁ ଇଞ୍ଜାଁ ଈୱାଣି ତା଼ଣାଟି ହ଼ଚାହାଲାମୁ ।” ଏମ୍ବାଟିଏ ଏ଼ ବୂତୁ ଏ଼ୱାଣାଇଁ ମାଦିଏ ତ୍ରକ୍‌ହାନା ଏ଼ୱାଣାଇଁ ଏ଼ନାଆଁ କିଆନା ହ଼ଚାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା କାବାଆ଼ହାନା ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ଈଦି ଏ଼ନିଲେହେଁତି କାତା ? ଏ଼ୱାସି ବୂତୁୟାଁଇଁ ଅଦିକାରା ଅ଼ଡ଼େ ବା଼ଡ଼୍‌ୟୁଟି ହୁକୁମି ହୀହିମାନେସି ଇଞ୍ଜାଁ ଏ଼ୱି ହ଼ଚା ହାଜିମାନୁ !” ");
INSERT INTO kxv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଏମ୍ବାଟିଏ ଏ଼ୱାଣି ହା଼ଡାତି କାବ୍ରୁ ଦେ଼ସାତି ସା଼ରିୱାକି ୱେ଼ଙ୍ଗାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ଏମ୍ବାଟିଏ ଜୀସୁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ହ଼ଚାନା ସିମନ ଇଜ ହାଚେସି । ସିମନ ପ଼ୟା ଗାଡି ନ଼ମେରି ଆ଼ହାମାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଈ କାତା ଜୀସୁଇଁ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ଦାନି ଡାଗେ ନିଚାନା ନ଼ମେରିତି ଦାକା ହୀତେସି, ଇଞ୍ଜାଁ ଏ଼ଦାନାକି ନ଼ମେରି ପିସ୍ତେ, ଏ଼ଦି ଏ଼ ଦେବୁଣିଏ ନିଙ୍ଗାନା ଏ଼ୱାରି ସେ଼ବା କିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ୱେ଼ଡ଼ା କୂଡ଼୍‌ହି ମାଚାଟି ଆମ୍ବାଆରି ତା଼ଣା ଏ଼ନିଲେହେଁତି ର଼ଗ ମାଚେ, ଏଲେତି ର଼ଗ ଲ଼କୁଣି ଜୀସୁ ତା଼ଣା ତାତେରି, ଇଞ୍ଜାଁ ତାମି ତା଼ର୍କାଣା କେୟୁ ଇଟାନା ବାରେତି ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଅ଼ଡ଼େ ବୂତୁୟାଁ ଜିକେଏ କିର୍‌ଡ଼ିହିଁ ହା଼ରେକା ଲ଼କୁ ତା଼ଣାଟି ଏଲେଇଞ୍ଜି ହ଼ଚାହାଚୁ, “ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ।” ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ ବାରେତି କାତା ଆ଼ହାଲି ହୀଆନା ଦାକା ହୀତେସି, ଇଚିହିଁ ଏ଼ୱାସି କ୍ରୀସ୍ତ ଈଦାଆଁ ଏ଼ୱି ପୁଞ୍ଜାମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ଲା଼ଇ ୱେ଼ୟାଲିଏ ଏ଼ୱାସି ହ଼ଚାନା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଚେସି; ଅ଼ଡ଼େ ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପାରି ପାରିହିଁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ନିକିଁ ଏ଼ୱାରି ତା଼ଣାଟି ହାଲଅସି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାଣାଇଁ ମାଞ୍ଜାଲି ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଟ୍‌କା ଗା଼ଡ଼ାତା ଜିକେଏ ନା଼ନୁ ମାହାପୂରୁ ରା଼ଜିତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ନାୟି ମାନେ, ଇଚିହିଁ ଏ଼ଦାଆଁତାକି ନା଼ନୁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଜୀହୁଦା ଦେ଼ସାତି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ହାଜାନା ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ର଼ ଦିନା ଜୀସୁ ଗେନେସର ବାନ୍ଦା ଗାଟୁତା ନିଚାମାଚାଟି ହା଼ରେକା ଲ଼କୁ ମାହାପୂରୁତି କାତା ୱେଞ୍ଜାଲି ଏ଼ୱାଣି ସା଼ରିସୁଟୁ ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଇଞ୍ଜାଁ ଏ଼ୱାସି ବାନ୍ଦା ଗାଟୁତା ରୀ ଡଂଗାଁୟାଁ ମାନାଣି ମେସ୍ତେସି; ଏମ୍ବାଟି ମୀଣ୍‌କା ଆହ୍‌ନାରି ଏମ୍ବାଟି ରେ଼ଚାନା ତାମି ଜା଼ଲାୟାଁ ନର୍‌ହି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ଏ଼ ଡଂଗ ବିତ୍ରାଟି ଏମିନାୟି ସିମନୱାୟି ମାଚେ, ଏ଼ ଡଂଗତା କୁଗାନା ଗାଟୁଟିଏ ହିରେ ହେକ ହାଜାଲି ବାତିମା଼ଲିତେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି କୁଗାନା ଲ଼କୁଣି ଜା଼ପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଏ଼ୱାସି ତାନି କାତା ରା଼ପ୍‌ହାଲିଏ ସିମନଇଁ ଏଲେଇଚେସି, “ମୀଣ୍‌କା ଆସାଲି କୂଡ଼୍‌ନି ଏ଼ୟୁୱାକି ହାଜାନା ମୀ ଜା଼ଲାୟାଁ ମେତ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ଏମ୍ବାଟିଏ ସିମନ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ମା଼ମ୍ବୁ ଲା଼ଆଁ ୱେ଼ୟେ କସ୍ତ କିତିୱା ର଼ ମୀନୁ ଜିକେଏ ବେଟାଆ଼ଆତମି; ସାମା ନୀ କାତା ଆସାନା ଜା଼ଲା ମେତ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜା଼ଲା ମେତ୍‌ହାଲିଏ ଏମ୍ବାଆଁ ଜା଼ଲା ନେଞ୍ଜେ ମୀଣ୍‌କା ହ଼ଟୁ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜା଼ଲା ଡାମ୍ବାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଆମିନି ତ଼ଡ଼ୁଗାଟାରି ଅ଼ର ଡଂଗତା ମାଚେରି, ଏ଼ୱାରି ଏ଼ନିକିଁ ୱା଼ହାନା ସା଼ୟେମି କିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ୱାରାଇଁ କେୟୁ ଜୀଞ୍ଜିତେରି, ଏମ୍ବାଟିଏ ଏ଼ୱାରି ୱା଼ହାନା ରୀ ଡଂଗଁଣା ମୀଣ୍‌କା ନେଞ୍ଜି କିୟାଲିଏ ଏ଼ ଡଂଗାଁୟାଁ ମୁଞ୍ଜିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ସାମା ସିମନ ପିତର ଏ଼ଦାଆଁ ମେସାନା ଜୀସୁ କଡାଣା ରିହାନା ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ ତା଼ଣାଟି ହାଜାତୁହ୍‌ମୁ ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନା଼ନୁ ପା଼ପୁଗାଟି ମାଣ୍‌ସିତେଏଁ !” ");
INSERT INTO kxv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଇଚିହିଁ ଏ଼ୱାରି ହା଼ରେକା ମୀଣ୍‌କା ଆସାମାଚାକି ତା଼ନୁ ଅ଼ଡ଼େ ତାନିତଲେ ମାଚାରି କାବା ଆ଼ହାହାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଜେବଦିତି ରୀ ମୀର୍‌କା ଜାକୁବ ଅ଼ଡ଼େ ଜହନ, ଆମ୍ବାଆରି ସିମନ ଆଟ୍‌ହିତାରି ମାଚେରି, ଏ଼ୱାରି ଜିକେଏ କାବା ଆ଼ହାହାଚେରି । ଅ଼ଡ଼େ ଜୀସୁ ସିମନଇଁ ଏଲେଇଚେସି, “ଆଜାଆନି ନୀଞ୍ଜୁଟିଏ ନୀନୁ ଲ଼କୁଣି ଆହ୍‌ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ଏଚେଟିଏ ଏ଼ୱାରି ଡଂଗାଁୟାଁ ଗାଟୁତା ତାଚାନା ଏମ୍ବାଆଁ ବାରେ ପିସାନା ଜୀସୁ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ଜୀସୁ ର଼ ଗା଼ଡ଼ାତା ମାଚାଟି ମେହ୍‌ଦୁ ଏମ୍ବାଆଁ ଗୂଡ଼ା ଆଙ୍ଗା କାଜା ର଼ଗ ଗାଟାସି ମାଚେସି; ଏ଼ୱାସି ଜୀସୁଇଁ ମେସାନା ମୁନୁ କୁତାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନୀନୁ ମ଼ନ କିତିହିଁ ନାଙ୍ଗେ ନେହିଁ କିହାଲି ଆ଼ଡାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ଏଚେଟିଏ ଏ଼ୱାସି କେୟୁ ଦା଼ସାହାଁ ଡୀଗାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମ଼ନ କିହିମାଇଁ ନୀନୁ ନେହିଁଆ଼ମୁ ।” ଏ଼ ଦେବୁଣିଏ କାଜା ର଼ଗଟି ଏ଼ୱାସି ନେହିଁଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଜୀସୁ ଏ଼ୱାଣାଇଁ ହୁକୁମି ହୀହାନା ଏଲେଇଚେସି, “ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆନି, ସାମା ହାଜାନା ପୂଜେରାଙ୍ଗାଣି ତ଼ହ୍‌ମୁ, ଅ଼ଡ଼େ ମ଼ସାତି ମେ଼ରାଲେହେଁ ନୀନୁ ନେହିଁ ଆ଼ତାଣି ସା଼କି ହୀହାଲି ପୂଜା ହୀମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ସାମା ଏ଼ୱାଣି କାତା ହା଼ରେକା ୱେ଼ଙ୍ଗାହାଚେ, ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ୱେଞ୍ଜାଲିତାକି ଅ଼ଡ଼େ ର଼ଗଟି ନେହିଁ ଆ଼ହାଲିତାକି ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ସାମା ଜୀସୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହାଜାନା ପ୍ରା଼ତାନା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ର଼ ଦିନା ଜା଼ପ୍‌ହି ମାଚାଟି, ଗାଲିଲି ଦେ଼ସାତି ବାରେ ନା଼ସ୍‌କାଟି, ଜୀହୁଦା ଦେ଼ସା ଇଞ୍ଜାଁ ଜିରୁସାଲମଟି ୱା଼ହାମାନି ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଜୀସୁ ତା଼ଣା କୁଗାମାଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ନିକିଁ ନେହିଁ କିନେସି ଈଦାଆଁତାକି ପ୍ରବୁତି ନେହିଁକିନି ବା଼ଡ଼୍‌ୟୁ ଜୀସୁ ତା଼ଣା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଏଚରଜା଼ଣା ଲ଼କୁ ର଼ ଟଟ ୱା଼ୟିତାଣାଇଁ କାଟେଲିତା ଡେ଼କା ତାଚାନା ଜୀସୁ ନ଼କିତା ବିତ୍ରା ଅ଼ହାଲି ଅଣ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ସାମା ଏମ୍ବାଆଁ ହା଼ରେକା ଲ଼କୁ ମାଚାକି ଜିରୁ ବେଟାଆ଼ଆତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଇଲୁ ତେ଼ପରିତା ଡେ଼କା ଅ଼ହାନା ତୂଡ଼ିୟାତି ଟାୟିଲି ହୁକ୍‌ହାନା କାଟେଲି ତଲେ ଜୀସୁ ନ଼କିତା ରେ଼ପ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ଜୀସୁ ଏ଼ୱାରି ନାମୁ ମେସାନା ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “ତ଼ଣେ ନୀ ପା଼ପୁ ବାରେ ମେଣ୍‌ଙ୍ଗାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ଏଚେଟିଏ ମେ଼ରା ଜା଼ପ୍‌ନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ କାତା ଆ଼ହିଁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ଈୱାସି ମାହାପୂରୁ ନିନ୍ଦା କିହିମାନେସି, ଈୱାସି ଆମ୍ବାଆସି ! ମାହାପୂରୁ ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆସି ପା଼ପୁ ମ୍ଣେକ୍‌ହାଲି ଆ଼ଡିମାନେସି !” ");
INSERT INTO kxv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ସାମା ଜୀସୁ ଏ଼ୱାରି କାତାବାର୍ତା ଆ଼ହିମାନାଣି ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ମୀ ମ଼ନତା ଏ଼ନାଆଁତାକି ଏଲେକିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ଏ଼ନାଆଁ ଇନାୟି ଊସାସା ‘ନୀ ପା଼ପୁ ବାରେ ମେଣ୍‌ଙ୍ଗିତେ ଇନାୟି କି ନିଙ୍ଗାନା ତା଼କାମୁ ଇନାୟି ?’ ");
INSERT INTO kxv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ଦାର୍‌ତିତା ପା଼ପୁ ମ୍ଣେକ୍‌ହାଲି ମାଣ୍‌ସି ମୀର୍‌ଏଣାକି ଅଦିକାରା ମାନେ, ଈଦାଆଁ ମୀରୁ ଏ଼ନିକିଁ ପୁଞ୍ଜାଲି ଆ଼ଡିଦେରି” ଈଦାଆଁତାକି ଟଟ ୱା଼ୟିତାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନିଙ୍ଗାନା ନୀ କାଟେଲି ଡେ଼କାନା ନୀ ଇଜ ହାଲାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାରି ନ଼କିତା ନିଙ୍ଗାନା ଆମିନି କାଟେଲିତା ଡୂରାମାଚେସି, ଏ଼ଦାଆଁ ଡେ଼କାନା ମାହାପୂରୁଇଁ ଜହରା କିହିଁ ତାମି ଇଜ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ଏଚେଟିଏ ବାରେଜା଼ଣା କାବାଆ଼ହାନା ମାହାପୂରୁଇଁ ଜହରା କିତେରି, ଅ଼ଡ଼େ ଆଜିତଲେ ଏଲେଇଚେରି, “ନୀଞ୍ଜୁ ମା଼ମ୍ବୁ କାବାଆ଼ନି କାମା ମେସ୍ତମି ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଏମ୍ବାଟିଏ ଜୀସୁ ପାଙ୍ଗାତା ହାଜାନା ଲେ଼ବି ଦ଼ରୁଗାଟି ର଼ ସିସ୍ତୁ ରୀହ୍‌ନାସି ସିସ୍ତୁ ରୀହ୍‌ନି ଟା଼ୟୁତା କୁଗାମାନାଣି ମେସାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ବାରେ ପିସାନା ନିଙ୍ଗାନା ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଅ଼ଡ଼େ ଲେ଼ବି ତାମି ଇଜ ର଼ କାଜା ବ଼ଜି କିତେସି, ଇଞ୍ଜାଁ ହା଼ରେକା ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ଏଟ୍‌କାଟି ଲ଼କୁ ବାରେ ଏ଼ୱାରିତଲେ ତିଞ୍ଜାଲି କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ଏଚେଟିଏ ପାରୁସିୟାଁ ଅ଼ଡ଼େ ଏ଼ୱାରି ଗଚିତି ମେ଼ରାପୁନାରି ତାମି ସୀସୁୟାଁଇଁ ଏଲେଇଚେରି, “ମୀରୁ ଏ଼ନାଆଁତାକି ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରି ତଲେ ତିଞ୍ଜି ଉଣ୍ତି ମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନେହିଁ ମାନାରାକି ଅସଗୂରୁ ଲ଼ଡ଼ା ହିଲେଏ, ସାମା ର଼ଗ ଗାଟାରାକି ଲ଼ଡ଼ାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ନା଼ନୁ ତୀରିଗାଟାରାଇଁ ହା଼ଟାଲି ୱା଼ହାହିଲଅଁ, ସାମା ମ଼ନ ୱେଟ୍‌ପି କିହାଲି ପା଼ପୁ ଗାଟାରାଇଁ ହା଼ଟାଲି ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ଏଚେକା ଲ଼କୁ ଜୀସୁଇଁ ୱେଚେରି, “ଜହନତି ସୀସୁୟାଁ ଅ଼ଡ଼େ ପାରୁସିୟାଁତି ସୀସୁୟାଁ ଅଲେ ଅଲେ ଉପାସା ଅ଼ଡ଼େ ପ୍ରା଼ତାନା କିହିମାନେରି, ସାମା ନୀ ସୀସୁୟାଁ ତିଞ୍ଜି ଉଣ୍ତି ମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ବୀହା ଲ଼କୁତଲେ ହନେଏସି ମାନି ପାତେକା ବୀହା ଲ଼କୁ ଉପାସା ମାଞ୍ଜାଲି ଆ଼ଡିନେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ସାମା ର଼ ଦିନା ୱା଼ନେ; ଏ଼ୱାରି ତା଼ଣାଟି ହନେଏସି ହାନେସି, ଏଚେଟିଏ ଏ଼ୱାରି ଉପାସା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଇଞ୍ଜାଁ ଏ଼ୱାସି ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଜିକେଏ ୱେସ୍ତେସି, “ଆମ୍ବାଆସି ପ୍ଣାଃଇ ହିମ୍ବରିତା ପୁଃନି ପାସ୍‌କି ତାଚଅସି; ତା଼ଚିତିୱା ଏ଼ ପୁଃନି ପାସ୍‌କି ଗେହ୍‌ନେ ଇଞ୍ଜାଁ ପୁଃନି ପାସ୍‌କି ପ୍ଣାଃଇ ପାସ୍‌କି ତଲେ ଆଣ୍ତେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପ୍ଣାଃଇ ଡ଼଼କାତା ଇଟଅସି; ଇଟିତିହିଁ ଅଙ୍ଗୁରି ରାସା ଡ଼଼କାତି ଅ଼ୟି କିହାନା ବ଼ହାହାନେ ଅ଼ଡ଼େ ଡ଼଼କା ଜିକେଏ ନସ୍ତ ଆ଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ସାମା ପୁଃନି ଅଙ୍ଗୁରି ରାସା ପୁଃନି ଡ଼଼କାତା ଇଟିନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆମ୍ବାଆରି ପ୍ଣାଃଇ ଅଙ୍ଗୁରି ରାସା ଗସ୍ତି ଡା଼ୟୁ ପୁଃନି ଅଙ୍ଗୁରି ରାସା ଗହ୍‌ଅତେରି । ପ୍ଣାଃଆୟି ନେହେଁ ଇଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ର଼ ଜ଼ମିନି ଦିନା ଜୀସୁ ତାନି ସୀସୁୟାଁ ତଲେ ଗ଼ହଁ ଗୁଡିୟାଟି ହାଜିମାଚାଟି ସୀସୁୟାଁ ଗ଼ହଁ ଜେ଼କା ଡାପ୍‌ହାନା କେୟୁତଲେ ରା଼କ୍‌ହା ତିଞ୍ଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ସାମା ପାରୁସିୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଜ଼ମିନି ଦିନାତା ଏ଼ନାଆଁ କିନାୟି ମେ଼ରା ହିଲେଏ ମୀରୁ ଏ଼ନାଆଁତାକି କିହିମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଦାୱୁଦ ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗା ହାକି ମାଚାଟି ଏ଼ନାଆଁ କିହାମାଚେରି, ଏ଼ଦାଆଁ ମୀରୁ ଏଚେଲା ପ଼ଡ଼ୱି ଆ଼ହାହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଏ଼ୱାସି ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଆମିନି ହେର୍‌ପିଆ଼ହାମାନି ରୂଟି ପୂଜେରାଙ୍ଗା ପିସ୍‌ପେ ଆମ୍ବାଆରି ତିନି ମେ଼ରା ହିଲାଆତେ ଏ଼ଦାଆଁ ତିଚେସି ଇଞ୍ଜାଁ ତାନି ତ଼ଣେସିଙ୍ଗାକି ଜିକେଏ ହୀତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜ଼ମିନି ଦିନାତି ପ୍ରବୁ ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଏ଼ୱାସି ର଼ ଜ଼ମିନି ଦିନାତା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଜାନା ଜା଼ପ୍‌ହି ମାଚେସି; ଏମ୍ବାଆଁ ରଅସି ମାଚେସି ଏ଼ୱାଣି ଟିଃନି କେୟୁ ୱା଼ୟାହାଜାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଅ଼ଡ଼େ ଏ଼ୱାସି ଜ଼ମିନି ଦିନାତା ନେହିଁ କିନେସିକି ଆ଼ଏ ଏ଼ଦାଆଁ ସିନିକିହାଲି ମେ଼ରାପୁନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ କୁଗାନା ସିନିକିହିମାଚେରି, ଏ଼ନିକିଁ ଏ଼ୱାଣାଇଁ ଦ଼ହ ଆସାଲି ପାରୁ ବେଟାଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ସାମା ଏ଼ୱାସି ଏ଼ୱାରି ହିୟାଁତି ଅଣ୍‌ପୁ ପୁଞ୍ଜାନା ଆମିନି ଲ଼କୁତି କେୟୁ ୱା଼ୟାହାଜାମାଚେ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ ମାଦି ନିମୁ ।” ଏଚେଟିଏ ଏ଼ୱାସି ନିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ୱେଞ୍ଜିମାଞ୍ଜାଇଁ ଜ଼ମିନି ଦିନାତା ଏ଼ନାଆଁ କିନାୟି ମେ଼ରା ମାନେ ? ନେହିଁକିନାୟି କି ଲାଗେଏ କିନାୟି ? ଜୀୱୁତି ଗେଲ୍‌ପିନାୟି କି ନା଼ସା କିନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଅ଼ଡ଼େ ଏ଼ୱାସି ସା଼ରିୱାକି ଲ଼କୁଣି ସିନିକିହାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ କେୟୁ ଦା଼ହ୍‌ମୁ ।” ଏମ୍ବାଟିଏ ଦା଼ସ୍ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି କେୟୁ ନେହିଁ ଆ଼ହାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ଏ଼ଦାଆଁ ମେସାନା ଏ଼ୱାରି କାର୍‌ବି ଆ଼ହାହାଚେରି ଅ଼ଡ଼େ ଜୀସୁଇଁ ଏ଼ନିକିହାଲି ଆ଼ନେ ଇଞ୍ଜିଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ କାତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ଏଚିବେ଼ଲାତା ଏ଼ ଦିନା ପ୍ରା଼ତାନା କିହାଲି ହ଼ରୁ ଲାକ ହାଚେସି ଇଞ୍ଜାଁ ଲା଼ଆଁ ୱେ଼ୟେ ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ଲା଼ଇ ୱେ଼ୟାଲିଏ ଏ଼ୱାସି ତାନି ସୀସୁୟାଁ ଡାଗେ ହା଼ଟାନା ଏ଼ୱାରି ବିତ୍ରାଟି ବା଼ରଜା଼ଣାତି ଆ଼ଚିତେସି; ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଇଞ୍ଜିଁ ଦ଼ରୁ ଇଟିତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ଏ଼ୱାରି ଆ଼ତେରି ସିମନ ଆମ୍ବାଆରାଇଁ ଏ଼ୱାସି ପିତର ଦ଼ରୁ ହୀତେସି, ଅ଼ଡ଼େ ତାନି ତାୟି ଆନ୍ଦ୍ରିୟ, ଜାକୁବ ଅ଼ଡ଼େ ଜହନ, ପିଲିପ, ବାର୍ତଲମି, ");
INSERT INTO kxv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିୟୁ ଅ଼ଡ଼େ ତ଼ମା, ଆଲେପି ମୀର୍‌ଏସି ଜାକୁବ ଅ଼ଡ଼େ ସିମନ, ଆମିନି ଗାଟାଣାଇଁ ତାନି ଦେ଼ସାତି ଜୀୱୁ ନ଼ନାସି ଇନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବ ମୀର୍‌ଏସି ଜୀହୁଦା ଅ଼ଡ଼େ ଇସ୍କାରିୟତ ଜୀହୁଦା, ଆମ୍ବାଆସି ଜୀସୁଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରିତଲେ ରେ଼ଚାୱା଼ହାନା ନିମା ଗାଟି ଟା଼ୟୁତା ନିତେସି, ଇଞ୍ଜାଁ ତାନି ହା଼ରେକା ସୀସୁୟାଁ ଅ଼ଡ଼େ ବାରେ ଜୀହୁଦା ଦେ଼ସା ଜିରୁସାଲମ ଇଞ୍ଜାଁ ସ଼ର ଅ଼ଡ଼େ ସିଦନ ଦାରିଟି ହା଼ରେକା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଏ଼ୱାରି ଜୀସୁତି କାତା ୱେଞ୍ଜାଲି ଅ଼ଡ଼େ ତାମି ର଼ଗଟି ନେହିଁ ଆ଼ହାଲି ୱା଼ହାମାଚେରି, ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି ବୂତୁୟାଁ ତା଼ଣାଟି କସ୍ତ ବେଟାଆ଼ହି ମାଚେରି, ଏ଼ୱାରି ଜିକେଏ ନେହିଁ ଆ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ ଡୀଗାଲି ମ଼ନ କିହିମାଚେରି, ଇଚିହିଁ ଏ଼ୱାଣି ତା଼ଣାଟି ବା଼ଡ଼୍‌ୟୁ ହ଼ଚାନା ବାରେଜା଼ଣାତି ନେହିଁ କିହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ଏଚିବେ଼ଲାତା ଜୀସୁ ତାନି ସୀସୁୟାଣି ସିନିକିହାନା ଏଲେଇଚେସି, “ହିଲାଆଗାଟାତେରି ମୀରୁ; ମିଙ୍ଗେ ନେହେଁ, ଇଚିହିଁ ମାହାପୂରୁ ରା଼ଜି ମୀଦିଏ । ");
INSERT INTO kxv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ନୀଏଁ ହାକି ଗାଟାତେରି ମୀରୁ; ମିଙ୍ଗେ ନେହେଁ, ଇଚିହିଁ ମୀରୁ ଡା଼ୟୁ ପାଞ୍ଜିଦେରି । ନୀଏଁ ଡ଼ୀହିମାନାତେରି ମୀରୁ; ମିଙ୍ଗେ ନେହେଁ, ଇଚିହିଁ ମୀରୁ ଡା଼ୟୁ କାକ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ଏଚେ଼ତା ଲ଼କୁ ମିଙ୍ଗେ ଅ଼ପଅରି ଅ଼ଡ଼େ ମାଣ୍‌ସି ମୀର୍‌ଏଣା ତାକି ଏଟ୍‌କା କିୟାନେରି, ଅ଼ଡ଼େ ନିନ୍ଦା କିୟାନେରି ଇଞ୍ଜାଁ ମୀ ଦ଼ରୁତି ଲାଗେଏତାୟି ଇଞ୍ଜିଁ ଅ଼ପଅରି, ଆତିହିଁ ମୀରୁ ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ଏ଼ ବେ଼ଲାତା ରା଼ହାଁତଲେ ଏ଼ନ୍ଦାଦୁ, ଏ଼ନିଇଚିହିଁ ଲାକପୂରୁ ମିଙ୍ଗେତାକି ହା଼ରେକା ଦା଼ନା ମାନେ; ଅ଼ଡ଼େ ଏଲେକିହିଁଏ ଏ଼ୱାରି ଆକୁ ଆ଼ବାୟାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ କିହିମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ସାମା ଆୟ଼ତା ଡଣ୍ତ ବେଟାଆ଼ନି ଦ଼ନ ଗାଟାତେରି ମୀରୁ; ମୀରୁ ମୀ ଅଣ୍‌ପିମାଚି ସୁକୁ ବେଟା ଆ଼ହାମାଞ୍ଜେରି ! ");
INSERT INTO kxv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଆୟ଼ତା ଡଣ୍ତ ବେଟାଆ଼ନାତେରି ନୀଏଁ ପାଞ୍ଜାମାନାତେରି ମୀରୁ; ଇଚିହିଁ ଡା଼ୟୁ ମୀରୁ ହାକି ଆ଼ଦେରି । ଆୟ଼ତା ନୀଏଁ କାକ୍‌ହି ମାନାତେରି ମୀରୁ; ଇଚିହିଁ ଡା଼ୟୁ ମୀରୁ ଦୁକୁ ଆ଼ହାନା ଡ଼ୀଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ଏଚିବେ଼ଲା ବାରେ ଲ଼କୁ ମିଙ୍ଗେ ନେହାଁତେରି ଇଞ୍ଜାନେରି, ଏଚିବେ଼ଲା ଆୟ଼ତା ଡଣ୍ତ ବେଟା ଆ଼ନାତେରି; ଏଲେକିହିଁଏ ଏ଼ୱାରି ଆକୁ ଆ଼ବାୟାଁ ମିଚି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ କିହିମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ସାମା ମୀରୁ ୱେଞ୍ଜିମାଞ୍ଜେରି, ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀ ସାତ୍ରୁୟାଁଇଁ ଜୀୱୁନ଼ଦୁ; ଆମ୍ବାଆରି ମିଙ୍ଗ ଅ଼ପଅରି ଏ଼ୱାରି ନେହିଁ କିଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଆମ୍ବାଆରି ମିଙ୍ଗ ବା଼କା ଇଟାନେରି, ଏ଼ୱାରାଇଁ ବ଼ର ହୀଦୁ; ଆମ୍ବାଆରି ମିଙ୍ଗେ ଲାଗେଏ କିହିଁ ଲେ଼ମ୍ବାନେରି ଏ଼ୱାରି କ଼ସମି ପ୍ରା଼ତାନା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଆମ୍ବାଆସି ମିଙ୍ଗେ ର଼ ଗେଏଲାତା ସା଼ପ୍‌ଡ଼ା ୱେ଼ତାନେସି, ଏ଼ୱାଣାକି ଅ଼ର ଗେଏଲା ଜିକେଏ ଅଗାହୀଦୁ; ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ମୀ ହିମ୍ବରି ଅ଼ନେସି ଏ଼ୱାଣାଇଁ ମୀ ସକା ଜିକେଏ ଅ଼ହାଲି କା଼ହିକିଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଆମ୍ବାଆସି ମିଙ୍ଗେ ରୀସ୍ତାନେସି, ଏ଼ୱାଣାକି ହୀଦୁ; ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଦ଼ନ ଅ଼ନେସି, ଏ଼ୱାଣାଇଁ ୱେଣ୍ତେ ରୀହ୍‌ଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ଲ଼କୁ ମିଙ୍ଗେ ଏ଼ନିକିଁ ଲେ଼ମ୍ବାପେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି, ମୀରୁ ଜିକେଏ ଏ଼ୱାରାଇଁ ଏଲେକିହିଁ ଲେ଼ମ୍ବାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ମିଙ୍ଗେ ଜୀୱୁ ନୟାଁନେରି, ଏ଼ୱାରାଇଁ ଜୀୱୁ ନ଼ତିହିଁ ଏ଼ନି ବ଼ର ବେଟାଆ଼ଦେରି ? ଇଚିହିଁ ପା଼ପୁ ଗାଟାରି ଜିକେଏ ତାମ୍‌ଙ୍ଗେ ଜୀୱୁ ନ଼ନାରାଇଁ ଜୀୱୁ ନ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଅ଼ଡ଼େ ଆମ୍ବାଆରି ମିଙ୍ଗେତାକି ନେହିଁ କିୟାନେରି, ମୀରୁ ଏ଼ୱାରି ନେହିଁ କିଦେରି, ଆତିହିଁ ମୀରୁ ଏ଼ନି ବ଼ର ବେଟାଆ଼ଦେରି ? ଇଚିହିଁ ପା଼ପୁ ଗାଟାରି ଜିକେଏ ଏଲେକିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ତା଼ଣାଟି ବେଟାଆ଼ହାଲି ଆ଼ସା ମାନେ, ଏ଼ୱାରାକି ରୀଣା ହୀତିସାରେ ମୀରୁ ଏ଼ନି ବ଼ର ବେଟାଆ଼ଦେରି ? ପା଼ପୁ ଗାଟାରି ଜିକେଏ ସମାନା ଲେକାତଲେ ବେଟାଆ଼ହାଲି ପା଼ପୁ ଗାଟାରାକି ରୀଣା ହୀନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ସାମା ମୀ ସାତ୍ରୁୟାଁଣି ଜୀୱୁନ଼ଦୁ ଇଞ୍ଜାଁ ଏ଼ୱାରି ନେହିଁ କିଦୁ, ୱେଣ୍ତେ ବେଟାଆ଼ହାଲି ଆ଼ସା କିଆନା ଉଦାରା ହୀଦୁ; ଆତିହିଁ ମିଙ୍ଗେତାକି କାଜା ଦା଼ନା ମାନେ, ଇଞ୍ଜାଁ ମୀରୁ କାଜା ମାହାପୂରୁତି ମୀର୍‌କା ଆ଼ଦେରି, ଇଚିହିଁ ଏ଼ୱାସି ଜୀୱୁ ନ଼ଆଗାଟାରାଇଁ ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରାଇଁ ଜିକେଏ ଜୀୱୁ ନ଼ନାସି । ");
INSERT INTO kxv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ମୀ ଲାକପୂରୁତି ଆ଼ବା ଏ଼ନିକିଁ କାର୍ମା ମେହ୍‌ନାସି ମୀରୁ ଜିକେଏ ଏଲେକିହିଁଏ କାର୍ମା ମେହ୍‌ନାତେରି ଆ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ଅ଼ଡ଼େ ନୀହାଁୟି କିଆଦୁ, ଆତିହିଁ ମୀରୁ ମାହାପୂରୁ ତା଼ଣା ନୀହାଁୟି କିୱି ଆ଼ଅତେରି; ଦ଼ହ ଦହ୍‌ଆଦୁ, ଆତିହିଁ ମୀରୁ ମାହାପୂରୁ ତା଼ଣା ଦ଼ହ ଗାଟାତେରି ଆ଼ଅତେରି; ଦ଼ହ ମ୍ଣେକ୍‌ଦୁ, ଆତିହିଁ ମାହାପୂରୁ ମୀ ଦ଼ହ ଜିକେଏ ମ୍ଣେକ୍‌ହାନେସି; ");
INSERT INTO kxv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ହୀଦୁ ଆତିହିଁ ମିଙ୍ଗେ ଜିକେଏ ହୀପ୍‌କିଆ଼ନେ; ଲ଼କୁ ମା଼ଣାତି ନେଞ୍ଜିକିହାନା ଏ଼ଦାନି ନାବ୍‌ଗାନା ଦା଼କ୍‌ହାନା ତେ଼ଲି କିହାନା ମୀ ଅଟଡ଼ିତା ହିୟାନେରି; ଇଚିହିଁ ଆମିନି ମା଼ଣାତଲେ ଲା଼ଚିଦେରି, ମିଙ୍ଗେ ଜିକେଏ ଏ଼ ମା଼ଣା ତଲେଏ ଲା଼ଚା ହିୟାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଜିକେଏ ଏଲେଇଚେସି, “ର଼ କା଼ଣା ଅ଼ର କା଼ଣାଇଁ ଜିରୁ ତ଼ସାଲି ଆ଼ଡିନେସିକି ? ଏ଼ୱାରି ରିଆରି ଜିକେଏ ରହେଁଏ ଗା଼ଡ଼୍‌ୟୁତା ତର୍‌ଗଅରି କି ? ");
INSERT INTO kxv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ସୀସୁ ତାନି ଗୂରୁ କିହାଁ କାଜାସି ଆ଼ଏ; ସାମା ବାରେଜା଼ଣା ସୀସୁୟାଁ ନେହିଁକିଁ ଜା଼ପାଲି ଆ଼ଡିସାରେ ତାମି ଗୂରୁ ସମାନା ଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ଅ଼ଡ଼େ ଏ଼ନାଆଁତାକି ମୀ ତାୟି କାନୁତି ଲାଟା ସିନିକିହିମାଞ୍ଜି, ସାମା ନୀ କାନୁତା ଆମିନି କାଜା ଲାଟା ମାନାଣି ଏ଼ନାଆଁତାକି ଅଣ୍‌ପି ହିଲଅତି ? ");
INSERT INTO kxv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ନୀନୁ ନୀ କାନୁତା ମାନି କାଜା ଲାଟାତି ଅଣ୍‌ପାଆନା, ଏ଼ନିକିଁ ନୀ ତାୟିଇଁ ଏଲେଇଞ୍ଜାଲି ଆ଼ଡିଦି, ତାୟି ୱା଼ମୁ ନୀ କାନୁତା ମାନି ଲାଟା ଡ଼େୱାଇଁ, ଆଡ଼େ କୁଟୁ ଗାଟାତି ତଲିଏ ନୀ କାନୁତି କାଜା ଲାଟା ଡ଼େୱା କଡାମୁ, ଡା଼ୟୁ ମୀ ତାୟି କାନୁତି ଲାଟା ନେହିଁକିଁ ମେସାଲି ଆ଼ଡିଦି । ");
INSERT INTO kxv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ଇଚିହିଁ ଇଲେତି ଏ଼ନି ର଼ ନେହିଁ ମା଼ର୍‌ନୁ ହିଲେଏ, ଏମିନାୟି ଲାଗେଏତି ପା଼ଡ଼େୟି ଆ଼ୟିନେ, ଅ଼ରୱାକି ଇଲେତି ଏ଼ନି ମା଼ର୍‌ନୁ ହିଲେଏ ଏମିନାୟି ନେହିଁ ପା଼ଡ଼େୟି ଆ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ଇଚିହିଁ ବାରେ ମା଼ର୍‌କାଣି ତାନି ପା଼ଡ଼େୟି ତଲେ ପୁନାୟି; ହା଼ପ୍‌କା ମା଼ର୍‌ନୁଟି ଲ଼କୁ ତ଼ୟା ପା଼ଡ଼େୟି ଏହ୍‌ଅରି, ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ବୂଟାଟି ଅଙ୍ଗୁରି ପା଼ଡ଼େୟି ଏହ୍‌ଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ନେହିଁ ଲ଼କୁ ନେହିଁ ମ଼ନ ବିତ୍ରାଟି ନେହିଁ କାତା ହ଼ପ୍‌ନେସି, ଇଞ୍ଜାଁ ପ଼ଲ୍‌ଆ ଗାଟାସି ପ଼ଲ୍‌ଆ ମ଼ନ ବିତ୍ରାଟି ପ଼ଲ୍‌ଆ କାତା ହ଼ପ୍‌ନେସି; ଇଚିହିଁ ହିୟାଁ ବିତ୍ରା ମାନାଣି ଗୂତିଟି ଜ଼ଲିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ଅ଼ଡ଼େ ମୀରୁ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ପ୍ରବୁ ପ୍ରବୁ ଇଞ୍ଜିଁ ମାଞ୍ଜାଦେରି, ସାମା ନା଼ କାତା ମା଼ନୱି ଆ଼ହି ହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ୱା଼ହାନା ନା଼ କାତା ୱେଞ୍ଜାନା ବାରେ ମା଼ନୱି ଆ଼ନେସି, ଏ଼ୱାସି ଏ଼ନିଲେହେଁତାସି, ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଏ଼ୱାସି ଇଲେତି ର଼ ଇଲୁ ଦହ୍‌ନିଲେହେତି ଲ଼କୁ, ଏମିନିଗାଟାସି ଗାଡି ଗା଼ଡ଼୍‌ୟୁ କା଼ର୍‌ହାନା ପୁନାଦି ୱାଲ୍‌କାତଲେ କାତି ନିପ୍‌ନେସି; କାଜା କାଡା ୱା଼ହାନା ଏ଼ ଇଲୁତି ଗୁପିତେ, ୱାଲ୍‌କାତଲେ ଇଲୁ ଦସାମାଚାକି କାଡା ଇଲୁତି ଦା଼କ୍‌ହାଲି ଆ଼ଡାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ସାମା ଆମ୍ବାଆସି ୱେଞ୍ଜାନା ମା଼ନୱି ଆ଼ଅସି ଏ଼ୱାସି ଗା଼ଡ଼୍‌ୟୁଟିଏ ପୁନାଦି କିଆନା ଲାକ ଲାକ ଇର୍‌ଆ ଲାକ ଇଲୁ କିହାମାନି ଲ଼କୁ ଲେହେଁତାସି; କାଜା କାଡା ୱା଼ହାନା ଇଲୁତି ଗୁପାଲିଏ ଦେବୁଣିଏ ଇଲୁ ରିହା ହାଚେ ଇଞ୍ଜାଁ କୁଡ଼୍‌ପୁନା଼ସା ଆ଼ହାହାଚେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜୀସୁ ଲ଼କୁ ନ଼କିତା ବାରେ କାତା ୱେସାଲି ରା଼ପ୍‌ହାଲିଏ କପର୍‌ନାହୁମ ଗା଼ଡ଼ାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ଏଚିବେ଼ଲାତା ରଅସି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣା ହ଼ଲେଏସି ହା଼ନିଲେହେଁ ନ଼ମେରି ଆ଼ହାମାଚେସି; ଏ଼ ହ଼ଲେଏଣାଇଁ ଏ଼ୱାସି ହା଼ରେକା ଜୀୱୁ ନ଼ହିଁମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ଏ଼ୱାସି ଜୀସୁ କାତା ୱେଞ୍ଜାନା, ଏ଼ୱାସି ଏ଼ନିକିଁ ୱା଼ହାନା ତାନି ହ଼ଲେଏଣାଇଁ ନେହିଁ କିନେସି, ଈଦାଆଁତାକି ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣାତି ଏ଼ୱାଣି ତା଼ଣା ପାଣ୍ତାନା ବାତିମା଼ଲିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ଏ଼ୱାରି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ହା଼ରେକା ବାତିମା଼ଲିହିଁ ୱେସ୍ତେରି, “ଏ଼ୱାସି ନୀ ତା଼ଣାଟି ହା଼ରେକା ସା଼ୟେମି ବେଟାଆ଼ହାଲି ପା଼ଡ଼ା ଆ଼ନାସି; ");
INSERT INTO kxv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଇଚିହିଁ ଏ଼ୱାସି ମା଼ ଜୀହୁଦି ଲ଼କୁଣି ଜୀୱୁ ନ଼ନେସି ଅ଼ଡ଼େ ତା଼ନୁଏ ମାଙ୍ଗେତାକି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁ କିହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରିତଲେ ହାଚେସି, ଏ଼ୱାସି କାଜାଣି ଇଲୁଟିଏ ହିରେ ହେକ ମାଚାଟିଏ ତାନି ତ଼ଣେସିଙ୍ଗାଣି ୱେସା ପାଣ୍ତିତେସି, “ଏ଼ ପ୍ରବୁ ନୀନୁ ଅ଼ଡ଼େ କସ୍ତ ପ୍ଣାଃଆନିଦେ; ଇଚିହିଁ ନୀନୁ ନା଼ ଇଜ ପା଼ୱୁଲି ଇଟିଦି ଇଲେକିଁ ପା଼ଡ଼ାଆ଼ଆତାତେଏଁ; ");
INSERT INTO kxv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଈଦାଆଁତାକି ନା଼ନୁ ନୀ ତା଼ଣା ୱା଼ହାଲି ପା଼ଡ଼ାଆ଼ଅଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେଏଁ; ସାମା ନୀନୁ ର଼ ପଦୁ ୱେସା ପାଣ୍ତାମୁ ନା଼ ହ଼ଲେଏସି ନେହିଁ ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ଇଚିହିଁ ନା଼ନୁ ରଅଣି ତା଼ଣା କାମା କିନି ମାଣ୍‌ସି ଆ଼ତିହିଁ ଜିକେଏ ନା଼ ଅଦିକାରାତା ଅ଼ଡ଼େ କ଼ସ୍‌କା ମାନେରି; ଅ଼ଡ଼େ ନା଼ନୁ ରଅଣାଇଁ ହାଲାମୁ ଇଚିହିଁ ହାନେସି; ରଅଣାଇଁ ୱା଼ମୁ ଇଚିହିଁ ୱା଼ନେସି; ଇଞ୍ଜାଁ ନା଼ ହ଼ଲେଏଣାଇଁ ଈଦାଆଁ କିମୁ ଇଚିହିଁ ଏ଼ୱାସି କିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜୀସୁ ଈ ବାରେ କାତା ୱେଞ୍ଜାନା କାବା ଆ଼ତେସି, ଅ଼ଡ଼େ ଜେ଼ଚ ୱା଼ହିମାନି ଲ଼କୁୱାକି ସିନିକିହାନା ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ ଇସ୍ରାୟେଲ ଲ଼କୁ ବିତ୍ରା ଜିକେଏ ନା଼ନୁ ଇଲେତି ନାମୁ ମେସାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଅ଼ଡ଼େ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚି ଲ଼କୁ ଇଜ ୱା଼ହାନା ହ଼ଲେଏସି ନେହିଁ ଆ଼ହାମାନାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଏମ୍ବାଟିଏ ନାଇନ ଦ଼ରୁଗାଟି ଗା଼ଡ଼ାତା ହାଚେସି, ତାନି ସୀସୁୟାଁ ଇଞ୍ଜାଁ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣିତଲେ ହାଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଏ଼ୱାସି ଗା଼ଡ଼ାତି ଗ଼ଲିମୁଟାତା ଏଜାଲିଏ ଲ଼କୁ ର଼ ମାଡ଼୍‌ହାତି ପାଙ୍ଗାତା ଡେ଼କା ତାଚି ମାଚେରି, ଏ଼ୱାସି ତାମି ଇୟାନି ରଣ୍ତିଏ ମୀର୍‌ଏସି ମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ ଇୟା ରା଼ଣ୍ତେଣି ମାଚେ; ଅ଼ଡ଼େ ଗା଼ଡ଼ାତି ହା଼ରେକା ଲ଼କୁ ଏ଼ଦାନିତଲେ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ଏ଼ଦାନି ମେସାନା ଜୀସୁ ହା଼ରେକା କାର୍ମା ଅଣ୍‌ପାନା ଏ଼ଦାନି ଏଲେଇଚେସି, “ଡ଼ୀଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଅ଼ଡ଼େ ଏ଼ୱାସି ଡାଗେ ହାଜାନା ଡେ଼କାମାଚି ଚେଚେଣିତି ଡୀଗିତେସି, ଇଞ୍ଜାଁ ଡେ଼କା ଅ଼ହିମାଚି ଲ଼କୁ ନିଚାଲିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଆଡ଼େ ଦାଂଗ୍‌ଣେଣାଁତି ! ନା଼ନୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜାଇଁ ନିଙ୍ଗାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ଏଚେଟିଏ ହା଼ହାମାଚି ଦାଂଗ୍‌ଣେଏସି ନିଙ୍ଗାନା କୁଗିତେସି ଇଞ୍ଜାଁ ଜ଼ଲିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାମି ଇୟାନି କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଏଚେଟିଏ ବାରେଜା଼ଣା ଆଜିତାକି ମାହାପୂରୁଇଁ ଜହରା କିହିଁ ଏଲେଇଚେରି; “ମା଼ ବିତ୍ରା ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ହ଼ଚାମାନେସି, ଇଚିହିଁ ମାହାପୂରୁ ତାନି ଲ଼କୁଣି କାର୍ମା ମେସାମାନେସି !” ");
INSERT INTO kxv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଇଞ୍ଜାଁ ଜୀସୁ କିତି ଈ କାତା ବାରେ ଜୀହୁଦା ଦେ଼ସାତା ଅ଼ଡ଼େ ସା଼ରିସୁଟୁ ମାନି ରା଼ଜିତା ୱେ଼ଙ୍ଗାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ଡା଼ୟୁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନତି ସୀସୁୟାଁ ଈ ବାରେ କାତା ଏ଼ୱାଣାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ଏଚେଟିଏ ଜହନ ତାନି ରୀ ସୀସୁୟାଁଇଁ ଡାଗେ ହା଼ଟାନା ପ୍ରବୁ ତା଼ଣା ଏଲେଇଞ୍ଜା ପାଣ୍ତିତେସି, “ଆମ୍ବାଆସି ୱା଼ନାୟି ମାଚେ, ନୀନୁଏ ଏ଼ୱାତିକି, ଆ଼ଆତିଁ ମା଼ମ୍ବୁ ଅ଼ର ରଅଣାଇଁ କା଼ଃଆନମି ?” ");
INSERT INTO kxv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ଏ଼ୱାରି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ମାଙ୍ଗେ ଏଲେଇଞ୍ଜା ପାଣ୍ତାତେସି, ଆମ୍ବାଆସି ୱା଼ନାୟି ମାଚେ ଏ଼ୱାତି ନୀନୁଏ କି ଆ଼ଆତିଁ ମା଼ମ୍ବୁ ଅ଼ର ରଅଣାଇଁ କା଼ଃଆନମି ?” ");
INSERT INTO kxv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ଏଚିବେ଼ଲା ଏ଼ୱାସି ହା଼ରେକା ର଼ଗ, କସ୍ତ ଅ଼ଡ଼େ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ତା଼ଣାଟି ହା଼ରେକା ଲ଼କୁଣି ନେହିଁ କିତେସି, ଇଞ୍ଜାଁ ହା଼ରେକା କାଣ୍‌କା ମେହ୍‌ଆଗାଟାରାଇଁ ମେହ୍‌ନି ବା଼ଡ଼୍‌ୟୁ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ହାଜାନା ଏ଼ନା ଏ଼ନାଆଁ ମେସାମାଞ୍ଜେରି ଅ଼ଡ଼େ ୱେଞ୍ଜାମାଞ୍ଜେରି, ଏ଼ ବାରେ ଜହନଇଁ ୱେହ୍‌ଦୁ; କାଣ୍‌କା ମେହ୍‌ଆଗାଟାରି ମେସାଲି ଆ଼ଡିମାନେରି, ସଟାୟାଁ ତା଼କାଲି ଆ଼ଡିମାନେରି, କାଜା ର଼ଗ ଗାଟାରି ନେହିଁ ଆ଼ହିମାନେରି, ବେ଼ରାୟାଁ ୱେଞ୍ଜିମାନେରି, ହା଼ତାରି ନୀଡିମାନେରି, ଅ଼ଡ଼େ ହିଲାଆ ଗାଟାରି ନେହିଁ କାବ୍ରୁ ୱେଞ୍ଜିମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ନା଼ ତା଼ଣା ଆମ୍ବାଆରି ଆନାମାନା ଆ଼ଆନା ନାମାନେରି, ତାମ୍‌ଙ୍ଗେଏ ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜହନ ସୀସୁୟାଁ ହାଜାଲିଏ, ଜୀସୁ ଲ଼କୁଣି ଜହନତି କାତା ଏଲେଇଚେସି, “ଏଚିବେ଼ଲା ବାଃଲି ବାଟାତା ମୀରୁ ହାଜାମାଚେରି, ଏମ୍ବାଆଁ ଏ଼ନାଆଁ ମେସାଲି କା଼ଚାମାଚେରି ? ଏ଼ନାଆଁ ଗା଼ଲି ତଲେ ୱା଼ଲିମାନି ଡାଣ୍ତିତି ? ");
INSERT INTO kxv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଏ଼ଦାଆଁ ଆ଼ଆତିହିଁ ଏ଼ନାଆଁ ମେସାଲି ହାଜାମାଚେରି ? ନେହିଁ ଅ଼ଜିତି ପା଼ତାଡ଼ା ହିମ୍ବରି ହୁଚାମାନି ର଼ ମାଣ୍‌ସିଇଁ ? ମେହ୍‌ଦୁ ଆମ୍ବାଆରି ନେହିଁ ନେହିଁ ହିମ୍ବରିକା ହୁଚାନା ସୁକୁ ତଲେ ଡ଼ୟିନାରି ଏ଼ୱାରି ରାଜା ଗା଼ଡ଼ାତା ଡ଼ୟିନେରି ! ");
INSERT INTO kxv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ଏ଼ଦାଆଁ ଆ଼ଆତିଁ ଏ଼ନାଆଁ ମେସାଲି ହାଜାମାଚେରି ? ଏ଼ନାଆଁ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଣାଇଁ ? ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାରି କିହାଁ କାଜାଣାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଆମ୍ବାଆରି କାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ହେଣ୍ତୁ ନା଼ନୁ ନା଼ କାବ୍ରୁ ୱେହ୍‌ନାଣାଇଁ ନୀ ନ଼କିତା ପାଣ୍ତିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ନୀ ନ଼କିତା ଜିରୁ ତିୟାରା କିନେସି, ଏ଼ୱାସି ଏ଼ ମାଣ୍‌ସି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଇୟାନି ବାଣ୍ତିଟି ଜାର୍ନା ଆ଼ହାମାନାରି ବିତ୍ରା ଜହନ ବାରେକିହାଁ କାଜାସି; ଆ଼ତିଜିକେଏ ମାହାପୂରୁ ରା଼ଜିତା ଆମ୍ବାଆସି ଊଣା ଏ଼ୱାସି ଏ଼ୱାଣି କିହାଁ କାଜାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ବାରେଜା଼ଣା ଈ କାତା ୱେଞ୍ଜାନା, ସିସ୍ତୁ ରୀହ୍‌ନାରି ଜିକେଏ ଜହନ ତା଼ଣାଟି ବାପ୍ତିସ୍ମ ଅ଼ହାମାଚାକି ମାହାପୂରୁଇଁ ସାତା ଇଞ୍ଜିଁ ଇଚେରି; ");
INSERT INTO kxv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ସାମା ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଏ଼ୱାଣି ତା଼ଣାଟି ବାପ୍ତିସ୍ମ ପ୍ଣାଃଆନାହାଁ ତାମ୍‌ଙ୍ଗେ ତାକି ମାହାପୂରୁ ଅଣ୍‌ପିମାଚାଣି କୂତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“ଈ କା଼ଲାତି ଲ଼କୁଣି ଆମ୍ବାଆରି ତଲେ ତୂକ୍‌ଇଁ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଆମ୍ବାଆରି ଲେହେଁ ? ");
INSERT INTO kxv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଏମିନି କକାରି ହା଼ଟା ବାଜାରାତା କୁଗାନା ତା଼ମ୍ବୁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ନେରି, ‘ମା଼ମ୍ବୁ ମିଙ୍ଗତାକି ପୀରୁଡ଼ି ଊକିତମି, ମୀରୁ ଏ଼ନ୍ଦାଆତେରି; ମା଼ମ୍ବୁ ଦୁକୁ ତଲେ ଡ଼ୀତମି ମୀରୁ ଡ଼ୀଆତେରି !’ ଏ଼ୱାରି ଇଲେତାରି ଇଞ୍ଜିଁ ଜୀସୁ ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଇଚିହିଁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ୱା଼ହାନା ରା଼ନ୍ଦା ତିନାଆତେସି କି ଅଙ୍ଗୁରି ରାସା ଗହ୍‌ଆତେସି, ଅ଼ଡ଼େ ମୀରୁ ଏଲେଇଚେରି, ‘ଏ଼ୱାଣାଇଁ ବୂତୁ ଆଲ୍‌ଗାମାଚେ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ହାନା ରା଼ନ୍ଦା ତିଚେସି ଉଟେସି, ଅ଼ଡ଼େ ମୀରୁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜେରି, ‘ମେହ୍‌ଦୁ ଈୱାସି ଟିଣ୍ତିକାୱୁ, କାଡ଼ୁବୂତୁ, ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରି ତ଼ଣେଏସି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମାହାପୂରୁତି ବୁଦି ତାନି ବାରେ ମୀର୍‌କା ତା଼ଣାଟି ସାତା ଇଞ୍ଜିଁ ତ଼ଞ୍ଜାଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଅ଼ଡ଼େ ପାରୁସିୟାଁ ବିତ୍ରାଟି ରଅସି ଜୀସୁଇଁ ତାନି ଇଜ ତିଞ୍ଜାଲି ଏଲେଇଚେସି, ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ ପାରୁସି ଇଜ ହ଼ଡାନା ରା଼ନ୍ଦା ତିଞ୍ଜାଲି କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ମେହ୍‌ଦୁ ଏ଼ ଗା଼ଡ଼ାତା ପା଼ପୁଗାଟି ର଼ ଇୟା ମାଚେ; ଜୀସୁ ପାରୁସିୟାଁ ଇଜ ତିଞ୍ଜାଲି କୁଗାମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଏ଼ଦି ର଼ ଗା଼ଜୁତା ଗାନ୍ଦାଗାଟି ନିୟୁଁ ତାଚାନା, ");
INSERT INTO kxv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ଡା଼ୟୁୱାକି ଜୀସୁ କଡାୟାଁଦାରି ନିଚାନା ଡ଼ୀହି ଡ଼ୀହି କାଣ୍ତ୍ରୁ ବକ୍‌ହାନା ଏ଼ୱାଣି ପାଃଆନାୟାଁ ଊଦି କିହାନା ତାନି ତା଼ର୍ୟୁଁ ବା଼ଣାୟାଁ ତଲେ ଜୀସୁ ପାଃଆନାୟାଁ ଜେ଼ଜିହିଁ ଏ଼ୱାଣି ପାଃଆନାୟାଁ ନଣ୍ତିତେ ଅ଼ଡ଼େ ଗାନ୍ଦା ନିୟୁଁ ରୁବିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ଏ଼ଦାଆଁ ମେସାନା ଆମିନି ପାରୁସି ହା଼ଟାମାଚେସି, ଏ଼ୱାସି ମ଼ନ ମ଼ନତା ଅଣ୍‌ପିତେସି, “ଈୱାସି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଆ଼ହାମାଚିହିଁମା, ତାଙ୍ଗେ ଡୀଗିମାନି ଇୟାଟି ଏ଼ନିଲେହେଁତାୟି ପୁଚେସିମା, ଇଚିହିଁ ଏ଼ଦି ପା଼ପୁ ଗାଟାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ ସିମନ ନା଼ନୁ ନିଙ୍ଗେ ର଼ କାତା ୱେସ୍ତାନାୟିମାନେ ।” ଏ଼ୱାସି ଏଲେଇଚେସି, “ହାଅ ପ୍ରବୁ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ର଼ ସା଼ୱୁକାରି ତା଼ଣା ରିଆରି ରୀଣାଗାଟାରି ମାଚେରି; ରଅସି ପା଼ସାୱାଞ୍ଜା ଅ଼ଡ଼େ ରଅସି ରୀ କ଼ଡ଼ି ଦସଟାକା ରୀଣା ଗାଟାସି । ");
INSERT INTO kxv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ଏ଼ୱାରି ରୀଣା ଡିକ୍‌ହାଲି ଆ଼ଡାଆଲିଏ, ଏ଼ୱାରି ସା଼ୱୁକାରି ରିଆରି ରୀଣାତି ଜିକେଏ ପିସାତୁସ୍ତେସି । ଇଞ୍ଜାଁ ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆସି ଏ଼ୱାଣାଇଁ ହା଼ରେକା ଜୀୱୁ ନ଼ନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମନ ଏଲେଇଚେସି, “ନା଼ ଅଣ୍‌ପୁତା ଆମ୍ବାଆରାକି ଗାଡି ରୀଣା ପିସ୍‌ପିଆ଼ତେ ଏ଼ୱାସି ।” ଜୀସୁ ଏଲେଇଚେସି, “ନୀନୁ ନେହିଁ ଅଣ୍‌ପାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ ଇୟାନିୱାକି ସିନିକିହାନା ସିମନଇଁ ଏଲେଇଚେସି, “ଈ ଇୟାନି ମେସିମାଞ୍ଜି ? ନା଼ନୁ ମୀ ଇଜ ୱା଼ତେଏଁ, ନା଼ କଡାୟାଁ ତାକି ଏ଼ୟୁ ହିୟାଆତି, ସାମା କାଣ୍ତ୍ରୁତଲେ ନା଼ ପାଃଆନାୟାଁ ଊଦି କିହାନା ତାନି ତା଼ର୍ୟୁଁ ବା଼ଣାୟାଁ ତଲେ ଜେ଼ଜାତେ । ");
INSERT INTO kxv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ନୀନୁ ନାଙ୍ଗେ ନଣ୍ତାଆତି ? ସାମା ନା଼ନୁ ବିତ୍ରା ୱା଼ୱନିଏ ନା଼ ପାଃଆନାୟାଁ ନଣ୍ତାଲି ପିସିମାଞ୍ଜେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ନୀନୁ ନା଼ ତା଼ର୍ୟୁଁତା ନିୟୁଁ ରୁବାଆତି ? ସାମା ଈଦି ନା଼ ପାଃଆନାଣାଁ ଗାନ୍ଦା ନିୟୁଁ ରୁବାତେ । ");
INSERT INTO kxv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଈଦାଆଁତାକି ନା଼ନୁ ନିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ଈଦାନି ହା଼ରେକା ପା଼ପୁ ମେଣ୍‌ଙ୍ଗାମାନେ ଏ଼ଦାଣିତାକି ଏ଼ଦି ହା଼ରେକା ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାନେ; ସାମା ଆମ୍ବାଆରାକି ଊଣା ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନେ ଏ଼ୱାସି ଊଣା ଜୀୱୁ ନ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ ଇୟାନି ଏଲେଇଚେସି, “ନୀ ପା଼ପୁ ବାରେ ମେଣ୍‌ଙ୍ଗାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ଏମ୍ବାଟିଏ ଏ଼ୱାଣିତଲେ ତିଞ୍ଜାଲି କୁଗାମାଚାରି ମ଼ନ ମ଼ନତା ଏଲେଇଚେରି, “ପା଼ପୁ ଜିକେଏ ମେଣ୍‌ଙ୍ଗି କିହିମାନେସି ଈୱାସି ଆମ୍ବାଆସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ସାମା ଜୀସୁ ଏ଼ ଇୟାନି ଏଲେଇଚେସି, “ନୀ ନାମୁ ନିଙ୍ଗେ ଗେଲ୍‌ପାମାଞ୍ଜାନେ; ହିତ୍‌ଡ଼ି ତଲେ ହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଏଚରଦିନା ଡା଼ୟୁ ଜୀସୁ ଗା଼ଡ଼ାତାକି ଗା଼ଡ଼ା ନା଼ୟୁଁ ତାକି ନା଼ୟୁଁ ରେ଼ଜିହିଁ ମାହାପୂରୁ ରା଼ଜିତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହେସି, ଅ଼ଡ଼େ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ଏ଼ୱାଣିତଲେ ମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଅ଼ଡ଼େ ଏମିନିଗାଟି ଇୟାସିକା ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ତା଼ଣାଟି ର଼ଗଟି ନେହିଁ କିୱି ଆ଼ହାମାଚୁ, ଇଚିହିଁ ମଗ୍‌ଦଲିନି ମରିୟମ, ଆମ୍ବାଆରି ତା଼ଣାଟି ସା଼ତାଗାଟା ବୂତୁୟାଁ ହ଼ଚାହାଜାମାଚୁ, ");
INSERT INTO kxv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରଦ ଇଜତି ଗୁମୁସ୍ତା କୁଜା ଅ଼ଡ଼େ ତାନି ଡକ୍ରି ଜହାନା, ସସାନା ଅ଼ଡ଼େ ହା଼ରେକା ଇୟାସିକା ଏ଼ୱାଣିତଲେ ମାଞ୍ଜାନା ତାମି ଦ଼ନ ହୀହାନା ଏ଼ୱାରି ସେ଼ବା କିହିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଲ଼କୁ ବାରେ ଗା଼ଡ଼ାୟାଁଟି ୱା଼ହିମାଚାକି ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ରୁଣ୍ତା ଆ଼ତେରି ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ରଅସି ବିଚା ମାଟିନାସି ବିଚା ମାଟାଲି ହ଼ତେସି । ଏ଼ୱାସି ମାଟି ମାଟିହିଁ କଚେକା ବିଚା ଜିରୁତା ରୀତେ ଏ଼ଦାଆଁ ଲ଼କୁ ୱିସାତୁସ୍ତେରି, ଅ଼ଡ଼େ ହା଼ଗୁ ଲାକ ଊମ୍ବିନି ପଟା କା଼ଟି ପେର୍‌ହା ତିଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଅ଼ଡ଼େ କଚେକା ୱାଲ୍‌କା ଲାକ ରୀତେ, ଇଞ୍ଜାଁ ନେୟାଁନା ବୂମି ଅ଼ଲୁ ହିଲାଆତାକି ୱା଼ୟାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଅ଼ଡ଼େ କଚେକା ହା଼ପ୍‌କା ବୂଟାତା ରୀତେ, ଇଞ୍ଜାଁ ହା଼ପ୍‌କା ବୂଟା ପାଡାଆ଼ହାନା ଆର୍ନା ଡାକିତି ପ୍ଡିକ୍‌ହାତୁସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଅ଼ଡ଼େ କଚେକା ବିଚା ନେହିଁ ବୂମିତା ରୀତେ, ଇଞ୍ଜାଁ ପାଡାଆ଼ହାନା ପା଼ସାକ଼ଡ଼ି ପା଼ଡ଼େୟି ଆ଼ୟିତେ ।” ଏଚେଟିଏ ଜୀସୁ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଆମ୍ବାଆରାକି ୱେଞ୍ଜାଲି କୀର୍କା ମାନୁ ଏ଼ୱାରି ୱେଣ୍‌ମ୍ବାରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ତାମି ସୀସୁୟାଁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତାତି ଅର୍ତ ଏ଼ନାୟି ଇଞ୍ଜିଁ ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ଏ଼ୱାସି ଏଲେଇଚେସି, “ମାହାପୂରୁ ରା଼ଜିତି କାତା ପୁଞ୍ଜାଲି ମିଙ୍ଗେ ବା଼ଡ଼୍‌ୟୁ ହୀପ୍‌କି ଆ଼ହାମାନେ, ସାମା ଏଟ୍‌କା ତାରାଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସ୍‌ପିଆ଼ନେ, ଇଚିହିଁ ଏ଼ୱାରି ମେସି ମେସିହିଁ ମେହ୍‌ଅରି ଅ଼ଡ଼େ ୱେଞ୍ଜିୱେଞ୍ଜି ତେଲ୍‌ହଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ପୁଣ୍‌ମ୍ବିକିନି କାତା ଅର୍ତ ଈଦି, ବିଚା ମାହାପୂରୁ ବ଼ଲୁ, ");
INSERT INTO kxv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଜିରୁ ଦାରିତି ପା଼ଡ଼େୟି ଇଲେତାରି, ଏ଼ୱାରି ମାହାପୂରୁ କାତା ୱେନେରି; ଡା଼ୟୁ ସୟତାନା ୱା଼ହାନା ଏ଼ୱାରି ଏ଼ନିକିଁ ନାମାଆପେରିୱା ଅ଼ଡ଼େ ଗେଲ୍‌ପି ଆ଼ଆପେରିୱା ଇଞ୍ଜିଁ ଏ଼ୱାରି ହିୟାଁତା ୱେଞ୍ଜାମାନାଣି ମୀଞ୍ଜାଅ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ୱାଲ୍‌କା ବୂମିତା ରିତି ଲ଼କୁ ଇଲେତାରି, ଏ଼ୱାରି କାତା ୱେଞ୍ଜାନା ରା଼ହାଁଟି ଆହ୍‌ନେରି; ଏ଼ୱାରିତା଼ଣା ହୀରୁ ଜୀଆତାକି ଗା଼ଡ଼େକା ତାକି ନାମିନେରି, ଅ଼ଡ଼େ ତାୟିପାରି କିନାୟି ୱା଼ତିସାରେ ମାହାପୂରୁଇଁ ପିସା ତୁହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଅ଼ଡ଼େ ହା଼ପ୍‌କା ବୂଟାତା ରିତି ଲ଼କୁ ଇଲେତାରି ଆମିନି ଗାଟାରି ମାହାପୂରୁ କାତା ୱେଞ୍ଜାନା ଦାର୍‌ତିତି ଦୁକୁ କା଼କୁଲି, ଦ଼ନତି ଜୂପ୍‌କା ଅ଼ଡ଼େ ଦାର୍‌ତିତି ରା଼ହାଁ ଏ଼ୱାରାଇଁ ପ୍ଡିକ୍‌ହାତୁସାମାନାକି ନେହିଁକିଁ କାମ୍ବାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ନେହିଁ ବୂମିତା ରିତି ପା଼ଡ଼େୟି ଇଲେତାରି, ଏମିନିଗାଟାରି ନେହିଁ ସୁଦୁଜୀୱୁ ହିୟାଁଟି କାତା ୱେଞ୍ଜାନା ଆହ୍‌ନେରି, ଅ଼ଡ଼େ ବାରେ ଅ଼ର୍‌ହାନା କାମା କିହାନା ପା଼ଡ଼େୟି ଆ଼ୟିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ଦୀୱଁ ଡ଼ୀସାନା ଆମ୍ବାଆରି ମା଼ଣା ପ୍ଡିକ୍‌ହାନା କି କାଟେଲି ଡ଼଼ଇକା ଇଟଅରି, ସାମା ଦୀୱଁ ସ଼ଡ଼ାତା ଇଟିନେରି, ଏ଼ନିକିଁ ଇଜୱାନି ଲ଼କୁ ଉଜେଡ଼ି ମେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ଡ଼ୁଗାମାନାୟି ଏ଼ନାୟିୱା ହିଲେଏ, ଏ଼ନାୟି ତ଼ଞ୍ଜା ଆ଼ଏ ଇଲେକିଁ ଏ଼ନାୟି ଜିକେଏ ହିଲେଏ, ୱେସ୍‌ପି ଆ଼ହାନା ତ଼ଞ୍ଜା ଆ଼ଏ ଇଲେତି ଡ଼ୁଗାମାନାୟି ଏ଼ନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ଏ଼ନିକିଁ ୱେଞ୍ଜାମାଞ୍ଜେରି ଏ଼ଦାଆଁତାକି ଜାଗ୍ରାତା; ଇଚିହିଁ ଆମ୍ବାଆରାୱାୟି ମାନେ ଏ଼ୱାଣାକି ହୀପ୍‌କିଆ଼ନେ, ଅ଼ଡ଼େ ଆମ୍ବାଆରାୱାୟି ହିଲେଏ ଏ଼ୱାସି ନା଼ଦି ମାନେ ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାନେସି, ଏ଼ଦାଆଁ ଜିକେଏ ଅ଼ୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜୀସୁତି ଇୟା ଅ଼ଡ଼େ ତାମି ତାୟିୟାଁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ତେରି, ସାମା ଲ଼କୁ ମାନ୍ଦା ମାଚାକି ଏ଼ୱାଣି ତା଼ଣା ହାଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଏମ୍ବାଟିଏ ଜୀସୁଇଁ ୱେସ୍ତେରି, “ମୀ ଇୟା ଅ଼ଡ଼େ ମୀ ତାୟିୟାଁ ନିଙ୍ଗେ ମେସାଲି ପାଙ୍ଗାତା ନିଚାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ସାମା ଏ଼ୱାସି ବାରେତି ଏଲେଇଚେସି, “ମାୟା ଅ଼ଡ଼େ ମା଼ ତାୟିୟାଁ ଏ଼ୱାରି, ଆମ୍ବାଆରି ମାହାପୂରୁତି କାତା ୱେନେରି ଅ଼ଡ଼େ ମା଼ନୱି ଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ର଼ ଦିନା ଜୀସୁ ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ ଡଂଗତା କୁଗିତେରି, ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ୱା଼ଦୁ ମା଼ର ସାମ୍‌ଦୁରି ଆତାଲା ହାନ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଡଂଗଟି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ସାମା ଏ଼ୱାରି ଡଂଗତା ହାଜିମାନି ବେ଼ଲାତା ଜୀସୁ ଡୂରୀତେସି । ଏଚିବେ଼ଲା ସାମ୍‌ଦୁରିତା କାଜା ଗା଼ଲି ଆ଼ତେ, ଅ଼ଡ଼େ ଏ଼ୟୁ ଡଂଗତା ହ଼ଡିମାଚାକି ଏ଼ୱାରି ହା଼ରେକା କସ୍ତ ଆ଼ତେରି ଇଞ୍ଜାଁ ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଏଚେଟିଏ ସୀସୁୟାଁ ଡାଗେ ୱା଼ହାନା ନିକ୍‌ହାଁ ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ଏ଼ ଗୂରୁ ମା଼ର ହା଼ହିମାନାୟି !” ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନିଙ୍ଗାନା କାଜା ଗା଼ଲିତି ଦାକା ହୀତେସି, ଇଞ୍ଜାଁ ଏ଼ ବାରେ ସାପି ଆ଼ହାନା ସୂସ୍ତି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ନାମୁ ଆମ୍ବିୟା ?” ସାମା ଏ଼ୱାରି ଆଜି ଅ଼ଡ଼େ କାବାଆ଼ହାନା ତା଼ମ୍ବୁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ଈୱାସି ଏ଼ନିଲେହେଁତାସି ଇଚିହିଁ ଗା଼ଲି ଅ଼ଡ଼େ ୱୀଡିମାନି ଏ଼ୟୁଣି ଜିକେଏ ହୁକୁମି ହୀହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ଡା଼ୟୁ ଏ଼ୱାରି ଗାଲିଲି ନ଼କିତି ଆତାଲାୱାକି ଗରାସିୟ ଦେ଼ସାତା ଏତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଜୀସୁ ଡଂଗଟି ରେ଼ଚାନା ଗାଟୁତା ୱା଼ହାଲିଏ, ଏ଼ ଗା଼ଡ଼ାତି ର଼ ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ତେସି; ଏ଼ୱାସି ଗାଡୁ ଦିନାଟିଏ ହିମ୍ବରିକା ହୁଚାଆନା ଅ଼ଡ଼େ ଇଜ ମାନାଆନା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ଡ଼ୟିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ଏ଼ୱାସି କିର୍‌ଡ଼ିହିଁ ଜୀସୁ କଡାଣା ରିହାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଏ଼ ବାଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ଜୀସୁ ନୀ ତଲେ ନାଙ୍ଗେ ଏ଼ନାୟି ମାନେ ? ନା଼ନୁ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ ନାଙ୍ଗେ ଅ଼ଡ଼େ କସ୍ତ ହିୟାଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଇଚିହିଁ ଜୀସୁ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁତି ଏ଼ ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚା ହାଜାଲି ହୁକୁମି ହୀହାଲି ହାଜିମାଚେସି । ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁ ହା଼ରେକା ପା଼ଲି ଏ଼ୱାଣାଇଁ ଆଲ୍‌ଗାମାଚେ, ଇଞ୍ଜାଁ ଲ଼କୁ ଏ଼ୱାଣାଇଁ କେସ୍କା କଡାଣା ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପା ଇଟିମାଚେରି, ସାମା ଏ଼ ଦସ୍‌ପା ମାଚାଣି ଡାପ୍‌ହାନା ବୂତୁ ତଲେ ବାୟା ଆ଼ହାନା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ହଟିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ ଦ଼ରୁ ଏ଼ନାୟି ?” “ନା଼ ଦ଼ରୁ ମାନ୍ଦା” ଇଞ୍ଜିଁ ଇଚେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ହା଼ରେକା ବୂତୁୟାଁ ଆଲ୍‌ଗାମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାସିକାଣି ତା଼ଡ଼େପୂରୁ ପାଣ୍ତାଲି ହୁକୁମି ହୀଅସି, ଈଦାଆଁତାକି ଏ଼ୱାଣାଇଁ ବାତିମା଼ଲିତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ଏମ୍ବାଆଁ ହ଼ରୁ ଦାରିତା ର଼ ମାନ୍ଦା ପାଜିୟାଁ ମେୟିଁମାଚୁ, ଇଞ୍ଜାଁ ଜୀସୁଇଁ ଏ଼ ବୂତୁୟାଁ ପାଜିୟାଁ ମାନ୍ଦା ବିତ୍ରା ହାଜାଲି ହେଲ ରୀସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଏ଼ୱାସି ହେଲ ହୀହାଲିଏ, ବୂତୁୟାଁ ଏ଼ ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚା ହାଜାନା ପାଜିୟାଁ ବିତ୍ରା ହ଼ଟୁ; ଏଚେଟିଏ ଏ଼ ପାଜିୟାଁ ଏ଼ ହ଼ରୁଟି ଦାବ୍‌ଡ଼ି ହାଜାନା ଦାରିତା ମାଚି ସାମ୍‌ଦୁରିତା ମେଦା ହା଼ହାହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ଏ଼ ପାଜିୟାଁ ମାନ୍ଦା ମେଚିମାଚି ଗ଼ଡ଼୍‌କା ଏ଼ଦାଆଁ ମେସାନା ହଟେରି ଇଞ୍ଜାଁ ଗା଼ଡ଼ା ଅ଼ଡ଼େ ନା଼ସ୍‌କାଣାଁ ଏ଼ କାତା ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ଏ଼ନାୟି ଆ଼ହାମାନେ ଏ଼ଦାଆଁ ମେସାଲି ଲ଼କୁ ହ଼ଚାୱା଼ତେରି; ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜୀସୁ ଡାଗେ ୱା଼ହାନା, ଆମିନି ମାଣ୍‌ସି ତା଼ଣାଟି ବୂତୁୟାଁ ହ଼ଚା ହାଜାମାଚୁ, ଏ଼ୱାଣାଇଁ ନେହିଁ ହିମ୍ବରିକା ହୁଚାନା ନେହିଁ ମ଼ନତଲେ ଜୀସୁ କଡାଁ ଡ଼଼ଇ କୁଗାମାଚାଣି ମେସାନା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି ମେସାମାଚେରି ଏ଼ୱାରି ଏ଼ ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି ଏ଼ନିକିଁ ନେହିଁଆ଼ତେସି, ଏ଼ଦାଆଁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ଏମ୍ବାଟିଏ ଗରାସିୟ ବାରେ ନା଼ସ୍‌କାତି ସା଼ରିୱାକି ବାରେ ଲ଼କୁ ଜୀସୁଇଁ ତାମି ଦେ଼ସାଟି ହାଜାଲି ବାତିମା଼ଲିତେରି, ଇଚିହିଁ ଏ଼ୱାରି ହା଼ରେକା ଆଜିମାଚେରି । ଇଞ୍ଜାଁ ଏ଼ୱାସି ର଼ ଡଂଗତା ହ଼ଚାନା ୱେଣ୍ଡାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ସାମା ଏମିନିଗାଟାଣି ତା଼ଣାଟି ବୂତୁୟାଁ ହ଼ଚା ହାଜାମାଚୁ, “ନାଙ୍ଗେ ନୀ ତଲେ ହାଜଲି ହେଲ ହିୟାମୁ” ଇଞ୍ଜିଁ ବାତିମା଼ଲିତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ହେଲ ହୀହାନା, “ମୀ ଇଜ ୱେଣ୍ତା ହାଲାମୁ, ଇଞ୍ଜାଁ ମାହାପୂରୁ ନିଙ୍ଗେତାକି ଆମିନି କାମା କିହାମାଞ୍ଜାନେସି ଏ଼ କାତା ୱେ଼କ୍‌ମୁ ।” ଏଚେଟିଏ ଏ଼ୱାସି ହାଜାନା ଜୀସୁ ତାଙ୍ଗେତାକି ଆମିନି କାମା କିହାମାଚେସି, ଏ଼ ବାରେ ଗା଼ଡ଼ାତା ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଜୀସୁ ୱେଣ୍ତା ୱା଼ହାଲିଏ ମାନ୍ଦା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ରା଼ହାଁତଲେ ବେଟାଆ଼ତେରି, ଇଚିହିଁ ଏ଼ୱାରି ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ କା଼ଚିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଏମ୍ବାଟିଏ ଜାୟିରସ ଦ଼ରୁଗାଟାସି ୱା଼ତେସି; ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାସି ମାଚେସି । ଏ଼ୱାସି ଜୀସୁ କଡାଣା ରିହାନା ତାମି ଇଜ ହାଜାଲି ବାତିମା଼ଲିତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଇଚିହିଁ ଏ଼ୱାଣାକି ବା଼ର ବାର୍ସାତି ରଣ୍ତିଏ ମା଼ଙ୍ଗା ମାଚେ, ଏ଼ଦି ହା଼ନିଲେହେଁ ନ଼ମେରି ଆ଼ହାମାଚେ । ସାମା ଏ଼ୱାସି ହାଜିମାଚାଟି ଲ଼କୁ ଏ଼ୱାଣି ମୁହେଁ ମୁହେଁ ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ଏଚିବେ଼ଲାତା ବା଼ର ବାର୍ସା ପାତେକା ନେତେରି ୱା଼ଙ୍ଗିନି ର଼ଗଗାଟି ର଼ ଇୟା, ଏମିନି ଗାଟାୟି ଆମ୍ବାଆରି ତା଼ଣାଟି ଜିକେଏ ନେହିଁ ଆ଼ହାଲି ଆ଼ଡିହିଲାଆତେ, ");
INSERT INTO kxv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ଏ଼ଦି ଡା଼ୟୁ ୱାକିଟି ୱା଼ହାନା ଜୀସୁତି ହିମ୍ବରି କୁଙ୍ଗୁ ଡୀଗିତେ, ଏ଼ ଦେବୁଣିଏ ଏ଼ଦାନି ନେତେରି ବ଼ନାୟି ପିସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ଏମ୍ବାଟିଏ “ନାଙ୍ଗେ ଆମ୍ବାଆୟି ଡୀଗାତେ” ଇଞ୍ଜିଁ ଜୀସୁ ୱେଚେସି ? ସାମା ବାରେଜା଼ଣା ଆ଼ଏ ଇଞ୍ଜାଲିଏ, ପିତର ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ଲ଼କୁ ବାରେ ମୁହେଁ ମୁହେଁ ଆ଼ହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ଆମ୍ବାଆୟିମା ଡୀଗାତେ, ଇଚିହିଁ ନା଼ ତା଼ଣାଟି ର଼ ବା଼ଡ଼୍‌ୟୁ ହ଼ତାକି ନା଼ନୁ ପୁଚେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଏମ୍ବାଟିଏ ଏ଼ ଇୟା ୱା଼ହାନା ଅଣ୍‌ପିତେ ନା଼ନୁ ଅ଼ଡ଼େ ଡ଼ୁଗାନା ମାଞ୍ଜାଲି ଆ଼ଡଅଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଆଜିତାକି ତାରା ତାରା ଆ଼ହିଁ ଜୀସୁ କଡାଣା ରିହାନା, ଏ଼ନାଆଁତାକି ଡୀଗିତେ ଇଞ୍ଜାଁ ଦେବୁଣିଏ ଏ଼ନିକିଁ ନେହିଁ ଆ଼ତେ, ବାରେ ଲ଼କୁ ନ଼କିତା ୱେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ମା଼ଙ୍ଗା ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେ, ହିତ୍‌ଡ଼ିଟି ହାଲାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଜୀସୁ ଈ କାତା ୱେସିମାଚି ବେ଼ଲାତା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାଣା ଇଜଟି ରଅସି ୱା଼ହାନା ଜାୟିରସଇଁ ଏଲେଇଚେସି, “ନୀ ମା଼ଙ୍ଗା ହା଼ହାହାଚେୟିଏ ଗୂରୁଇଁ ଅ଼ଡ଼େ କସ୍ତ ହୀଆନିଦେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ସାମା ଜୀସୁ ଏ଼ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆଜାଆନି ନାମାମୁ ଏ଼ଦି ନୀଡିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଅ଼ଡ଼େ ଜୀସୁ ଇଜ ୱା଼ହାନା ପିତର, ଜହନ ଅ଼ଡ଼େ ଜାକୁବ ଇଞ୍ଜାଁ ପ଼ଦାନି ତାମି ଆ଼ବା ଇୟାନି ପିସ୍‌ପେ ଆମ୍ବାଆରାଇଁ ବିତ୍ରା ହାଜାଲି ହୀଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ସାମା ବାରେଜା଼ଣା ଡ଼ୀହି ଡ଼ୀହିଁ ବକତା ୱେ଼ଚା କଡିମାଚୁ । ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଡ଼ୀଆଦୁ; ଏ଼ଦି ହା଼ହାହିଲେଏ, ସାମା ଡୂରାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ସାମା ପ଼ଦା ହା଼ହାମାନାଣି ପୁଞ୍ଜାନା ଏ଼ୱି ଏ଼ୱାଣାଇଁ କାକ୍‌ହୁ । ");
INSERT INTO kxv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ସାମା ଜୀସୁ ପ଼ଦାନି କେୟୁ ଆସାନା ହା଼ଟାହାଁ ଏଲେଇଚେସି, “ଆକେ ପ଼ଦା, ନିଙ୍ଗାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ଏମ୍ବାଟିଏ ପ଼ଦାନି ଜୀୱୁ ୱେଣ୍ତା ୱା଼ତେ ଅ଼ଡ଼େ ଏ଼ ଦେବୁଣିଏ ନିଙ୍ଗିତେ, ଇଞ୍ଜାଁ ଇଚାଣି ତିଞ୍ଜାଲି ହୀଦୁ ଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଏମ୍ବାଟିଏ ତାମି ତାଲି ତାଞ୍ଜି କାବାଆ଼ତୁ; ସାମା ଈ ପ଼ଦା ନେହିଁ ଆ଼ତାଣି ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଏ଼ୱାସିକାଣି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଏଚେଟିଏ ଜୀସୁ ବା଼ରଜା଼ଣାତି ହା଼ଟାନା ରୁଣ୍ତା କିହାନା ଏ଼ୱାରାଇଁ ବାରେ ବୂତୁୟାଁ ଲାକ ଅ଼ଡ଼େ ର଼ଗଟି ନେହିଁ କିହାଲି ବା଼ଡ଼୍‌ୟୁ ଅ଼ଡ଼େ ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ମାହାପୂରୁତି ରା଼ଜିତି କାତା ୱେ଼କ୍‌ହାଲି ଅ଼ଡ଼େ ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିହାଲି ପାଣ୍ତିତେସି ");
INSERT INTO kxv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ହାଜାଲିତାକି କୁତା ବାଡ଼୍‌ଗା କି ମ଼ଣା କି ରୂଟି କି ଏ଼ନି ଟାକାୟାଁ ଜିକେଏ ଅ଼ଆଦୁ, ଅ଼ଡ଼େ ଜ଼ଡ଼େକା ସକାୟାଁ ଜିକେଏ ଅ଼ଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଅ଼ଡ଼େ ମୀରୁ ଆମିନି ଇଜ ହାଜେରି, ଏମ୍ବାଟି ୱେଣ୍ତାହାନି ପାତେକା ଏମ୍ବାଆଁ ଡ଼ୟାଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ମିଙ୍ଗେ ଆବଅରି ଏ଼ୱାରି କ଼ପାଟି ସା଼କି ହୀହାଲି ଏ଼ ଗା଼ଡ଼ାଟି ହ଼ଚା ୱା଼ନାଟି ମୀ କଡାତି ଦୂଡ଼ି ହାଣ୍‌ହାଁନା ୱା଼ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହାଜାନା ସା଼ରିୱାକି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହିହିଁ ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିହିହିଁ ନା଼ୟୁଁ ନା଼ୟୁଁତା ରେ଼ଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଏମ୍ବାଟିଏ ଏ଼ ଦେ଼ସାତି ରାଜା ହେରଦ ଈ ବାରେ କାତା ୱେଞ୍ଜାନା କାବା ଆ଼ତେସି, ଇଚିହିଁ ବାପ୍ତିସ୍ମ ହୀନି ଜହନ ହା଼ତାରି ତା଼ଣାଟି ନିଙ୍ଗାମାନେସି ଇଞ୍ଜିଁ ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଞ୍ଜିମାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରି ଏଲିୟ ତ଼ଞ୍ଜା ଆ଼ହାମାନେସି ଇଞ୍ଜାଁ ଏଟ୍‌କାତାରି ତଲିକା଼ଲାତି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ବିତ୍ରାଟି ରଅସି ନିଙ୍ଗାମାନେସି ଇଞ୍ଜିଁ ୱେସିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ସାମା ହେରଦ ଏଲେଇଚେସି, “ଜହନତି ତା଼ର୍ୟୁଁ ମା଼ରତ ଦା଼ଚା ମାନାୟି, ସାମା ଆମ୍ବାଆରି କାତା ମା଼ର ୱେଞ୍ଜିମାନାୟି ଏ଼ୱାସି ଆମ୍ବାଆସି ?” ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ମେସାଲି ମ଼ନ କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ଡା଼ୟୁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚାରି ୱା଼ହାନା ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଚେରି, ଏ଼ ବାରେ ଏ଼ୱାଣାଇଁ ୱେସ୍ତେରି । ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରିତଲେ ଏଟ୍‌କା ଆ଼ହାନା ବେତ୍‌ସାୟିଦା ଦ଼ରୁଗାଟି ଗା଼ଡ଼ାତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ସାମା ଲ଼କୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ ହାଚେରି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ କାର୍ମା ଆ଼ହାଁ ଆବାନା ମାହାପୂରୁ ରା଼ଜିତି କାତା ୱେସ୍ତେସି, ଅ଼ଡ଼େ ଏମିନିଗାଟାରି ର଼ଗଟି ନେହିଁ ଆ଼ନାୟି ମାଚେ, ଏ଼ୱାରାଇଁ ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଏଚେ଼ତା ମିଡ଼୍‌ଅଲା ଆ଼ହାଲି ମା଼ଟ୍‌ହେ; ଏଚେଟିଏ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ତାନି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଲ଼କୁ ଏ଼ନିକିଁ ନା଼ସ୍‌କା ଅ଼ଡ଼େ ଗା଼ଡ଼ାତା ହାଜାନା ବାସାଟା଼ୟୁ ଅ଼ଡ଼େ ତିଞ୍ଜାଲି କା଼ଦି ପାରିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରାଇଁ ହେଲ ହୀମୁ ଇଚିହିଁ ମା଼ର ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ମାନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ୱାରାକି ତିଞ୍ଜାଲି ହୀଦୁ ।” ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ ତା଼ଣା ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ରୀ ମୀଣ୍‌କା ପିସ୍‌ପେ ଆଗାଡ଼ା ହିଲାଉ; ଏ଼ନାଆଁ ମା଼ର ହାଜାନା ଈ ବାରେତାକି କା଼ଦି କଡିନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଇଚିହିଁ ଏ଼ୱାରି ପା଼ସାମା଼ଣା ଆ଼ବାୟାଁ ମାଚେରି । ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାନି ସୀସୁଣି ଏଲେଇଚେସି, “କଡ଼େଦସ ଜା଼ଣା ଲାକା କୁଗିକିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ଏଚେଟିଏ ଏ଼ୱାରି ଏଲେକିହିଁଏ ବାରେତି କୁଗିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଅ଼ଡ଼େ ଏ଼ୱାସି ପା଼ସାଗଟା ରୂଟି ଅ଼ଡ଼େ ରୀ ମୀଣ୍‌କାଣି ଆସାନା ଲାକପୂରୁ ୱାକି ସିନିକିହାନା ବ଼ର ହୀତେସି, ଇଞ୍ଜାଁ ରୂଟି ଡ଼ିକ୍‌ହାନା ଲ଼କୁକି ହା଼ସ୍‌ପାଲି ସୀସୁୟାଁକି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ଏଚେଟିଏ ବାରେଜା଼ଣା ତିଞ୍ଜା ପାଞ୍ଜିତେରି, ଅ଼ଡ଼େ ହା଼ରିତାଣି ବା଼ର ଡାଲି ରୂଟି କୂଡ଼ି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ର଼ ଦିନା ଜୀସୁ ରଅସିଏ ପ୍ରା଼ତାନା କିନି ବେ଼ଲାତା ସୀସୁୟାଁ ଏ଼ୱାରିତଲେ ମାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, “ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ଇଞ୍ଜିଁ ଲ଼କୁ ଏଲେଇଞ୍ଜିମାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଏଚେଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ଆମ୍ବାଆରି ବାପ୍ତିସ୍ମ ହୀନି ଜହନ, ଆମ୍ବାଆରି ଏଲିୟ, ଅ଼ଡ଼େ ଆମ୍ବାଆରି ତଲିକା଼ଲାତି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ବିତ୍ରାଟି ରଅସି ନିଙ୍ଗାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ମୀରୁ ଏ଼ନାଆଁ ଇଞ୍ଜିଁ ମାଞ୍ଜେରି ?” ପିତର ଏଲେଇଚେସି, “ନୀନୁ ମାହାପୂରୁତି କ୍ରୀସ୍ତ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ଜାଣ୍ତେ କିହିଁ ହୁକୁମି ହୀତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“ମାଣ୍‌ସି ମୀର୍‌ଏସି ହା଼ରେକା ଦୁକୁ ପା଼ଣ୍‌ନାୟି ମାନେ ଇଞ୍ଜାଁ ଲ଼କୁତି କାଜାରି, କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ମେ଼ରାପୁନାରି ତା଼ଣାଟି ଅ଼ପାଆନା ଏ଼ୱାଣାଇଁ ପା଼ୟିନେରି, ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ଏଚେଟିଏ ଏ଼ୱାସି ବାରେତି ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ ଜେ଼ଚ ତା଼କାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସି ତାଙ୍ଗେ ଅ଼ପାଆନା ବାରେଦିନା ତାନି କ୍ରୁସ ଡେ଼କାନାହାଁ ନା଼ ଜେ଼ଚ ତା଼କାପେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଇଚିହିଁ ଆମ୍ବାଆସି ଜାହାରା ଜୀୱୁ ଗେଲ୍‌ପାଲି ମ଼ନ କିନେସି ଏ଼ୱାସି ନା଼ସା କିନେସି; ସାମା ଆମ୍ବାଆସି ନା଼ ତାକି ନିଜେତି ଜୀୱୁ ନା଼ସା କିନେସି ଏ଼ୱାସି ଗେଲ୍‌ପି କିହାକଡିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଅ଼ଡ଼େ ମାଣ୍‌ସି ଈ ଦାର୍‌ତିତା ମାନାଣି ବାରେ ମେଡ଼ି କିହାନା ତାନି ଜୀୱୁତି ନା଼ସା କିନେସି, ଇଚିହିଁ ଏ଼ୱାଣାକି ଏ଼ନି ଲା଼ବା ? ");
INSERT INTO kxv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ଇଚିହିଁ ଆମ୍ବାଆସି ନାଙ୍ଗେତାକି ଅ଼ଡ଼େ ନା଼ କାତାତାକି ଲାଜା ଆ଼ନେସି, ମାଣ୍‌ସି ମୀର୍‌ଏସି ତାନି କାଜାପା଼ଣା ତଲେ ଇଞ୍ଜାହାଁ ମାହାପୂରୁ ଆ଼ବା ଅ଼ଡ଼େ ତାନି ସୁଦୁଗାଟି ଦୂତୁୟାଁ ତଲେ କାଜାପା଼ଣାଟି ୱା଼ନେସି ଏଚିବେ଼ଲା ଏ଼ୱାସି ଜିକେଏ ଏ଼ୱାଣି ତାକି ଲାଜା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁତି ରା଼ଜି ମେହ୍‌ଆ ପାତେକା ଇମ୍ବାଆଁ ନିଚାମାନାରି ଏଚରଜା଼ଣା ହା଼ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଈ କାତା ୱେସାନା ଆ଼ଟାଦିନା ହାଜାଲିଏ ପିତର, ଜହନ ଅ଼ଡ଼େ ଜାକୁବଇଁ ଅ଼ହିଁ ହାଜାନା ପ୍ରା଼ତାନା କିହାଲି ହ଼ରୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଅ଼ଡ଼େ ଏ଼ୱାସି ପ୍ରା଼ତାନା କିହିମାଚାଟି ତାନି ମୂମ୍ବୁତି ୱା଼ଣା ତିରିମ୍ଣିହେ ଇଞ୍ଜାଁ ତାନି ହିମ୍ବରି ଦବ୍‌ଲା ଆ଼ହାନା ହା଼ରେକା ଉଜେଡ଼ି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ମ଼ସା ଅ଼ଡ଼େ ଏଲିୟ ଏ଼ୱାଣିତଲେ କାତା ଆ଼ହିମାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ଏ଼ୱାରି ଗାୱୁରମିଟି ତ଼ଞ୍ଜାଆ଼ହାନା ଜୀସୁ ଜିରୁସାଲମତା ହାନିକାତା ଜ଼ଲ୍‌କି ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ଏଚିବେ଼ଲା ପିତର ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗାକି ଗାଡି ଇଦାକାଣ୍‌କା ହ଼ଚିମାଚୁ; ସାମା ଏ଼ୱାରି ଇଦାଟି ନିଙ୍ଗାଲିଏ ତାନି ଗାୱୁରମି ଇଞ୍ଜାଁ ଏ଼ୱାଣିତଲେ ରିଆରି ନିଚାମାନାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଇଞ୍ଜାଁ ଏ଼ୱାରି ତା଼ଣାଟି ହାଜିମାଚାଟି ପିତର ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଗୂରୁ ମା଼ମ୍ବୁ ଇମ୍ବାଆଁ ମାନାୟି ନେହେଁ; ମା଼ମ୍ବୁ ଇମ୍ବାଆଁ ତୀନିଗଟା ଗୂଡ଼ାୟାଁ କେ଼ପିନମି, ନିଙ୍ଗେତାକି ରଣ୍ତାଆଁ, ମ଼ସାକି ରଣ୍ତାଆଁ ଅ଼ଡ଼େ ଏଲିୟକି ରଣ୍ତାଆଁ ।” ସାମା ତା଼ନୁ ଏ଼ନାଆଁ ଇଞ୍ଜିମାଚେସି ତା଼ନୁଏ ପୁଞ୍ଜି ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ଏ଼ୱାସି ଏଲେଇଞ୍ଜି ମାଚାଟି ଇଚାୟି ହା଼ଗୁ ଦୂନ୍ଦ୍ରା ୱା଼ହାନା ଏ଼ୱାରାଇଁ ପ୍ଡିକ୍‌ହେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଦୂନ୍ଦ୍ରାତା ହ଼ଡି ମାଚାଟି ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଇଞ୍ଜାଁ ଏ଼ ଦୂନ୍ଦ୍ରାଟି ଈ ହା଼ଡା ୱା଼ତେ, “ଈୱାସି ନା଼ ମୀର୍‌ଏସି, ନା଼ନୁ ଆ଼ଚିତାସି, ଈୱାଣି ବ଼ଲୁ ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଏଲେଇଞ୍ଜି ୱେସ୍ତି ଡା଼ୟୁ ଜୀସୁ ରଅସିଏ ତ଼ଞ୍ଜାଆ଼ତେସି । ଏ଼ୱାରି ଈ କାତାତାକି ପାଲେଏ ମାଞ୍ଜାନା, ଏ଼ନା ଏ଼ନାଆଁ ମେସାମାଚେରି ଏ଼ ବେ଼ଲାତା ଆମ୍ବାଆରାଇଁ ଜିକେଏ ୱେହ୍‌ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ଅ଼ଡ଼େ ର଼ ନେ଼ଚୁ ହ଼ରୁଟି ରେ଼ଚା ୱା଼ହାଲିଏ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ବେଟା ଆ଼ୟାଲି ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଅ଼ଡ଼େ ଏ଼ ମାନ୍ଦା ଲ଼କୁ ବିତ୍ରାଟି କାଜା ଗିୟାଁତଲେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ନା଼ନୁ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ ନା଼ ମୀର୍‌ଏଣାଇଁ କାର୍ମା ଆ଼ମୁ, ଇଚିହିଁ ଏ଼ୱାସି ନା଼ ରଣ୍ତିଏ ମୀର୍‌ଏସି; ");
INSERT INTO kxv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଏ଼ୱାଣାଇଁ ର଼ ବୂତୁ ଆଲ୍‌ଗିମାନେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ପେଦ୍‌ରାହାଁ ଦେବୁଣିଏ କିର୍‌ଡ଼ି ମାନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ଇଲେକିଁ ବୂମିତା ତ୍ରକ୍‌ହାନା ଗୂତିଟି ପମ୍ବଲି ହ଼ପ୍‌ହି ମାନେ, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ଗାଡି ବା଼ଦା କିହାନା ଏ଼ୱାଣି ତା଼ଣାଟି କା଼କୁଲିଟି ହ଼ଚାହାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ନା଼ନୁ ବୂତୁତି ପିସ୍‌ପି କିହାଲି ନୀ ସୀସୁୟାଁ ବାତିମା଼ଲିତେଏଁ, ସାମା ଏ଼ୱାରି ପିସ୍‌ପି କିହାଲି ଆ଼ଡାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜୀସୁ ଏଲେଇଚେସି, “ଆଡ଼େ ନାମାଆଗାଟି ଏଟ୍‌କା ଜିରୁ ଆହ୍‌ନି କୂଡ଼ା, ନା଼ନୁ ଅ଼ଡ଼େ ଏଚେକା ମୀ ତଲେ ମାଞ୍ଜାନା ମୀ କାତା ଅ଼ର୍‌ହାଇଁ ? ନୀ ମୀର୍‌ଏଣାଇଁ ଇମ୍ବାଆଁ ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ବୂତୁ ଆଲ୍‌ଗାମାଚି କକାସି ୱା଼ହିମାଚାଟି ବୂତୁ ଏ଼ କକାଣାଇଁ ବୂମିତା ଡାଡ଼ି କିହାନା ତ୍ରେପ୍‌ହାତୁସ୍ତେ, ସାମା ଜୀସୁ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁତି ଦାକା ହୀତେସି ଇଞ୍ଜାଁ କକାଣାଇଁ ନେହିଁ କିହାନା ତାମି ଆ଼ବା କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଏଚେଟିଏ ବାରେ ଲ଼କୁ ମାହାପୂରୁତି ବା଼ଡ଼୍‌ୟୁ ମେସାନା ଜାଗ୍‌ଲା ଆ଼ତେରି । ସାମା ଏ଼ୱାସି କିହାମାନି ବାରେ କାମାତାକି ଜାଗ୍‌ଲା ଆ଼ହିମାଚାକି ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ଈ ବାରେ କାତା ମୀ କୀର୍କା ଅଡାନା ୱେଞ୍ଜୁ; ଇଚିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ସାମା ଏ଼ୱାରି ଏ଼ କାତା ତେଲ୍‌ହାଆତେରି, ଏ଼ୱାରି ତେଲ୍‌ହାଲି ଆ଼ଡାଆରେଟୁ ଏ଼ୱାରି ତା଼ଣାଟି ଡ଼ୁଗାମାଚେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ କାତା ଜିକେଏ ଜୀସୁଇଁ ୱେଞ୍ଜାଲି ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆସି କାଜାସି, ଈ କାତାତାକି ଏ଼ୱାରି ବିତ୍ରା ବା଼ଦିବା଼ଦା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ସାମା ଜୀସୁ ଏ଼ୱାରି ବିତ୍ରା ବା଼ଦିବା଼ଦା ଆ଼ହିମାନାଣି ପୁଞ୍ଜାନା, ର଼ ଊଣା କକାଣାଇଁ ତାନି ନ଼କିତା ନିପ୍‌ହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ଆମ୍ବାଆସି ନା଼ ଦ଼ରୁଟି ଈ ଊଣା କକାଣାଇଁ ଆବିନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଆବାନେସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ଆବିନେସି; ଇଚିହିଁ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ବାରେକିହାଁ ଊଣା ଏ଼ୱାସି କାଜାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଏଚେଟିଏ ଜହନ ଏଲେଇଚେସି, “ଗୂରୁ, ମା଼ମ୍ବୁ ନୀ ଦ଼ରୁଟି ବୂତୁୟାଁ ପେ଼ର୍‌ହି ମାଚାଣି ମେସ୍ତମି ଇଞ୍ଜାଁ ଏ଼ୱାସି ମା଼ ତଲେ ନୀ ଜେ଼ଚ ୱା଼ଆଲିଏ କା଼ହିକିତମି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “କା଼ହିକିଆଦୁ, ଇଚିହିଁ ଆମ୍ବାଆସି ମୀ କ଼ପାଟି ନିଙ୍ଗା ହିଲଅସି ଏ଼ୱାସି ମୀ ତଲେତାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ଏଚିବେ଼ଲା ଜୀସୁ ଲାକପୂରୁ ହାନି ବେ଼ଲା ଏଗାୱା଼ହିମାଚାକି ଏଚିବେ଼ଲା ଜୀସୁ ଜିରୁସାଲମତା ହାଜାଲି ମ଼ନତି ତୀରି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ଅ଼ଡ଼େ ତାନି ନ଼କେଏ କ଼ସ୍‌କାଣି ପାଣ୍ତିତେସି, ଏ଼ୱାରି ହାଜାନା ର଼ ସମିରଣ ନା଼ୟୁଁତା ଜୀସୁ ୱା଼ନେସି ଇଞ୍ଜିଁ ଜାଗ୍ରାତା କିହାନା କା଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ସାମା ଏ଼ୱାସି ଜିରୁସାଲମତା ହାଜାଲି ମ଼ନ କିହାମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ଆବାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଈଦାଆଁ ମେସାନା ଜାକୁବ ଅ଼ଡ଼େ ଜହନ ଈ ରୀ ସୀସୁୟାଁ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଏଲିୟ ଏ଼ନିକିଁ ଏଲେଇଞ୍ଜାମାଚେସି, ଏଲେକିହିଁଏ ହା଼ଗୁଲାକଟି ହିଚୁ ରିହାନା ଏ଼ୱାରାଇଁ ନା଼ସା କିପେ, ଏଲେଇଞ୍ଜାଲି ନୀ ମ଼ନ ମାନେକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ସାମା ଏ଼ୱାସି ୱେଣ୍ତେ ସିନିକିହାନା ଏ଼ୱାରାଇଁ ଲା଼ଗାନା ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନିଲେହେଁତି ଜୀୱୁ ଗାଟାତେରି, ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି ମାଣ୍‌ସି ମୀର୍‌ଏସି ମାଣ୍‌ସିୟାଁତି ଜୀୱୁ ନା଼ସା କିହାଲି ୱା଼ଆନା ଗେଲ୍‌ପାଲି ୱା଼ହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ଏଚେଟିଏ ଏ଼ୱାରି ଅ଼ର ନା଼ୟୁଁତା ହାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ଏ଼ୱାରି ଜିରୁତା ହାଜିମାଚାଟି ରଅସି ୱା଼ହାନା ଜୀସୁଇଁ ଏଲେଇଚେସି, “ନୀନୁ ଆମ୍ବିୟା ହାଜି, ନା଼ନୁ ଜିକେଏ ନୀ ତଲେ ୱା଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନାକାୟାଁକି ଡ଼ୟିନି ପା଼ୱୁୟାଁ ମାନୁ, ହା଼ଗୁ ଲାକ ଊମ୍ବିନି ପଟାୟାଁକି ବାସାଟା଼ୟୁ ମାନେ, ସାମା ମାଣ୍‌ସି ମୀର୍‌ଏଣାକି ତା଼ର୍ୟୁଁ ନେଟ୍‌ହାଲି ଟା଼ୟୁ ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଅ଼ଡ଼େ ରଅଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ ।” ସାମା ଏ଼ୱାସି ଏଲେଇଚେସି, “ପ୍ରବୁ ନ଼କେଏ ହାଜାନା ନା଼ ଆ଼ବାଇଁ ମାହ୍‌ଣିଣା ମୁସାଲି ହେଲ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ଜୀସୁ ଏଲେଇଚେସି, “ହା଼ତାରାଇଁ ତାମି ହା଼ତି ଲ଼କୁଣି ମୁସାଲି ପିହ୍‌ଦୁ, ସାମା ମୀରୁ ହାଜାନା ମାହାପୂରୁ ରା଼ଜିତି କାତା ୱେହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଅ଼ଡ଼େ ରଅସି ୱା଼ହାନା ଏଲେଇଚେସି, “ପ୍ରବୁ ନା଼ନୁ ଜେ଼ଚ ୱା଼ଇଁ ସାମା ନ଼କେଏ ଇଜତି ଲ଼କୁ ତା଼ଣାଟି ହେଲ ଅ଼ହାଲି ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ଙ୍ଗେଲି କେୟୁତା ଆସାନା ଡା଼ୟୁୱାକି ସିନିକିନେସି ଏ଼ୱାସି ମାହାପୂରୁ ରା଼ଜିତା ପା଼ଡ଼ା ଆ଼ଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ଏମ୍ବାଟିଏ ପ୍ରବୁ ଅ଼ଡ଼େ ତୀନିକ଼ଡ଼ି ବା଼ରଜା଼ଣାତି ଆ଼ଚାନା ତା଼ନୁ ଆମିନି ଗା଼ଡ଼ା ଅ଼ଡ଼େ ନା଼ସ୍‌କାଣାଁ ହାଜାଲି ମ଼ନ କିହାମାଚେସି, ଏ଼ ନା଼ସ୍‌କା ଅ଼ଡ଼େ ଗା଼ଡ଼ାୟାଁଣା ରିଆରି ଲାକା କିହାଁ ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ପା଼ଚି ହା଼ରେକା ସାମା ଦା଼ଃଆନାରି ଊଣା ଜା଼ଣା; ଈଦାଆଁତାକି ଗୁଡିୟାତା କାମା କିନାରାଇଁ ପାଣ୍ତାଲିତାକି ଗୁଡିୟାତି ସା଼ୱୁକାରିଇଁ ବାତିମା଼ଲାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ମୀରୁ ହାଜୁ; ନା଼ନୁ ମିଙ୍ଗ କ୍ଡାଃନିୟାଁ ବିତ୍ରା ମେ଼ଣ୍ତା ଡା଼ଲ୍‌କା ଲେହେଁ ମିଙ୍ଗେ ପାଣ୍ତିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଡାବୁୟାଁ, ମ଼ଣା କି ସେପୁୟାଁ ଜିକେଏ ଅ଼ଆଦୁ, ଅ଼ଡ଼େ ଜିରୁତା ଆମ୍ବାଆରାଇଁ ଜହରା କିଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଅ଼ଡ଼େ ମୀରୁ ଆମିନି ଇଲୁତା ହ଼ଡ଼୍‌ଦେରି ନ଼କେଏ ଈ ଇଲୁତାକି ହିତ୍‌ଡ଼ି ଆ଼ପେ ଇଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଅ଼ଡ଼େ ଏ଼ ଇଜ ହିତ୍‌ଡ଼ିତି ମାଣ୍‌ସି ରଅସି ମାଚିହିଁ ମୀ ହିତ୍‌ଡ଼ି ଏ଼ୱାଣାକି ଆ଼ପେ; ଅ଼ଡ଼େ ହିଲାଆତିହିଁ ମୀ ହିତ୍‌ଡ଼ି ମିଙ୍ଗେ ୱେଣ୍ତେ ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାରିତା଼ଣା ଏ଼ନାୟି ମାନେ ଏ଼ଦାଆଁ ତିଞ୍ଜା ଉଣ୍ତାନା ଏ଼ ଇଜ ମାଞ୍ଜୁ, ଇଚିହିଁ କାମାକିନାସି ତାନି କାମାତି ବୁତି ମେ଼ଡ଼ା ଆ଼ନାୟି ମାନେ । ଏ଼ ଇଜ ପିସାନା ଅ଼ର ଇଜ ହାଲାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଅ଼ଡ଼େ ଆମିନି ଗା଼ଡ଼ାତା ହାଜେରି ଅ଼ଡ଼େ ଲ଼କୁ ମିଙ୍ଗେ ଅ଼ପାନେରି ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ଏ଼ନାଆଁ ତିଞ୍ଜାଲି ହିୟାନେରି ଏ଼ଦାଆଁ ତିଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ଏମ୍ବାଆଁ ମାନି ର଼ଗ ଗାଟାରାଇଁ ନେହିଁ କିଦୁ, ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ଏଲେଇଞ୍ଜୁ ‘ମାହାପୂରୁତି ରା଼ଜି ମୀ ତା଼ଣା ଏଦାତେୟିଏ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ସାମା ମୀରୁ ଆମିନି ଗା଼ଡ଼ାତା ହାଜେରି ଇଞ୍ଜାଁ ଲ଼କୁ ମିଙ୍ଗେ ଅ଼ପଅରି, ଏମ୍ବାତି ଆଂଗେଣିକାଟି ପାଙ୍ଗାତା ହାଜାନା ଏଲେଇଞ୍ଜୁ, ");
INSERT INTO kxv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ମୀ ଗା଼ଡ଼ାତି ଆମିନି ଦୂଡ଼ି ମା଼ କଡାୟାଁଣା ଆଟାମାଚେ, ଏ଼ଦାଆଁ ଜିକେଏ ମିଙ୍ଗେ ତାକି ହାଣ୍‌ହି ମାନମି; ସାମା ମାହାପୂରୁତି ରା଼ଜି ଏଗାୱା଼ହିମାନେ ଈଦାଆଁ ପୁଞ୍ଜୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନୀହାଁୟି ଦିନାତା ଏ଼ ଗା଼ଡ଼ାତି ଡଣ୍ତ କିହାଁ ସଦମତି ଗା଼ଡ଼ାତି ଡଣ୍ତ ଊଣା କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି କରାଜିନ୍‌ ଅ଼ଡ଼େ ବେତ୍‌ସାୟିଦା ଇଚିହିଁ ମୀ ତା଼ଣା ଆମି ଆମିନି କାବାଆ଼ନି କାମାୟାଁ କିୱିଆ଼ହାମାନୁ, ଏ଼ ବାରେ ସ଼ର ଅ଼ଡ଼େ ସିଦନତା କିୱି ଆ଼ହାମାଚିହିଁମା, ଏ଼ୱାରି ହା଼ରେକା ଦିନା ନ଼କେଏ ବାସ୍ତାୟାଁ ପର୍‌ହାଁ ଦାର୍‌ମ୍ବୁତା କୁଗାନା ମ଼ନ ୱେଟ୍‌ହେରିମା । ");
INSERT INTO kxv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଆ଼ତିଜିକେଏ ନୀହାଁୟି ଦିନାତା ସ଼ର ଅ଼ଡ଼େ ସିଦନତି ଡଣ୍ତ ଊଣା କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଏ଼ କପର୍‌ନାହୁମ ନୀନୁ ଲାକପୂରୁ ପାତେକା ପାଡାଆ଼ଦି ? ହା଼ତାରି ମାନି ରା଼ଜିତା ମେତ୍‌ପି ଆ଼ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜୀସୁ ଏଲେଇଚେସି “ଆମ୍ବାଆସି ମୀ କାତା ୱେନେସି, ଏ଼ୱାସି ନା଼ କାତା ୱେନେସି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ମିଙ୍ଗେ ଅ଼ପଅସି ଏ଼ୱାସି ନାଙ୍ଗେ ଅ଼ପଅସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନାଙ୍ଗେ ଅ଼ପଅସି ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ଅ଼ପଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଏମ୍ବାଟିଏ ତୀନିକ଼ଡ଼ି ବା଼ରଜା଼ଣା ୱେଣ୍ତା ୱା଼ହାନା ରା଼ହାଁଟି ଏଲେଇଚେରି, “ପ୍ରବୁ ବୂତୁୟାଁ ଜିକେଏ ନୀ ଦ଼ରୁଟି ମା଼ ଡ଼଼ଇକା ହେର୍‌ପି ଆ଼ହିମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ହା଼ଗୁ ମ୍ଣିହ୍‌ନିଲେହେଁ ଲାକଟି ସୟତାନ ରିହିମାନାଣି ମେସ୍ତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ମେହ୍‌ଦୁ ନା଼ନୁ ମିଙ୍ଗେ ରା଼ସ୍‌କା, କାଚାକୁପିୟାଁ ମୁହେଁ ତା଼କାଲି ଅ଼ଡ଼େ ସାତ୍ରୁତି ବାରେ ବା଼ଡ଼୍‌ୟୁ ମୁହେଁ ଜିକେଏ ଅଦିକାରା ହୀହିମାଞ୍ଜାଇଁ, ଅ଼ଡ଼େ ଏ଼ନାୟି ଜିକେଏ ମିଙ୍ଗେ ନସ୍ତ କିହାଲି ଆ଼ଡେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ସାମା ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ବା଼ଡ଼୍‌ୟୁ ମୀ ଡ଼଼ଇକା ମାନେ ଇଞ୍ଜିଁ ରା଼ହାଁ ଆ଼ଆଦୁ, ସାମା ମୀ ଦ଼ରୁ ଲାକପୂରୁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ ଏ଼ଦାଆଁତାକି ରା଼ହାଁ କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ଏଚିବେ଼ଲା ଜୀସୁ ସୁଦୁଜୀୱୁ ତଲେ ରା଼ହାଁ ଆ଼ହାନା ଏଲେଇଚେସି, “ଆ଼ବା ଲାକପୂରୁ ଅ଼ଡ଼େ ଦାର୍‌ତିତି ପ୍ରବୁ, ନୀନୁ ବୁଦିଗାଟି ଲ଼କୁତା଼ଣା ଈ ବାରେ କାତା ଡ଼ୁକ୍‌ହାନା ଊଣା କକାରି ତା଼ଣା ତ଼ସାମାଞ୍ଜି, ଈଦାଆଁତାକି ନିଙ୍ଗେ ଜହରା କିହିମାଞ୍ଜାଇଁ; ଏ଼ ଆ଼ବା ଈଦିଏ ନୀ ନ଼କିତା ନେହାୟି ଆ଼ତେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ନା଼ ଆ଼ବାତି ବାରେ ଅଦିକାରା ନାଙ୍ଗେ ହେର୍‌ପି ଆ଼ହାମାନେ; ଅ଼ଡ଼େ ମୀର୍‌ଏସି ଆମ୍ବାଆସି, ଈଦାଆଁ ଆ଼ବା ପିସ୍‌ପେ ଆମ୍ବାଆସି ପୁନଅସି, ଅ଼ଡ଼େ ଆ଼ବା ଆମ୍ବାଆସି ଈଦାଆଁ ମୀର୍‌ଏଣା ପିସ୍‌ପେ ଆମ୍ବାଆସି ପୁନଅସି, ଇଞ୍ଜାଁ ମୀର୍‌ଏସି ଆମ୍ବାଆରି ତା଼ଣା ଏ଼ୱାଣାଇଁ ତ଼ସାଲି ମ଼ନ କିନେସି, ଏ଼ୱାସିଦେଁ ପୁନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଅ଼ଡ଼େ ଜୀସୁ ଡା଼ୟୁ ସିନିକିହାନା ତାମି ସୀସୁୟାଁଇ ଏଟ୍‌କେଏ ଏଲେଇଚେସି, “ହା଼ରେକା ନେହେଁ ଏ଼ କାଣ୍‌କା ଏମିନିଗାଟାଣି ମେସିମାନୁ, ଏ଼ନାଆଁ ମୀରୁ ମେସିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଏ଼ନା ଏ଼ନାଆଁ ମେସିମାଞ୍ଜେରି ଏ଼ ବାରେ ହା଼ରେକା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଅ଼ଡ଼େ ରାଜାୟାଁ ମେସାଲି ମ଼ନ କିହାମାଚେରି, ସାମା ମେସାଲି ଆ଼ଡାଆତେରି; ଅ଼ଡ଼େ ମୀରୁ ଏ଼ନା ଏ଼ନାଆଁ ୱେଞ୍ଜିମାଞ୍ଜେରି, ଏ଼ ବାରେ ଏ଼ୱାରି ୱେଞ୍ଜାଲି ମ଼ନ କିତେରି ସାମା ୱେଞ୍ଜାଲି ଆ଼ଡାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ମେହ୍‌ଦୁ ର଼ ମ଼ସାତି ମେ଼ରା ଜା଼ପ୍‌ନାସି ୱା଼ହାନା ଜୀସୁଇଁ ତାୟିପାରିକିହିଁ ୱେଚେସି, “ଏ଼ ଗୂରୁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାଲି ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଏଚେଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ମ଼ସାତି ମେ଼ରାତା ଏ଼ନାଆଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ନୀନୁ ଏ଼ନିକିଁ ପ଼ଡ଼ୱି ଆ଼ହିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଏ଼ୱାସି ଏଲେଇଚେସି, “ନୀନୁ ନୀ ବାରେ ହିୟାଁ, ବାରେ ଜୀୱୁ, ବାରେ ବା଼ଡ଼୍‌ୟୁ ଅ଼ଡ଼େ ବାରେ ମ଼ନ ହୀହାନା ପ୍ରବୁ ନୀ ମାହାପୂରୁଇଁ ଜୀୱୁନ଼ମୁ; ଅ଼ଡ଼େ ପା଼ଡ଼ିତି ଲ଼କୁଣି ନୀ ଜୀୱୁ ଲେହେଁ ଜୀୱୁ ନ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ନେହିଁକିଁ ୱେସାମାଞ୍ଜି; ଏଲେଏ କିମୁ ଆତିହିଁ ଏ଼ ଜୀୱୁ ମେ଼ଡ଼ା ଆ଼ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ସାମା ଏ଼ୱାସି ତାଙ୍ଗେ ତୀରିତାସି କିହାକଡାଲି ମ଼ନ କିହାନା ଜୀସୁଇଁ ୱେଚେସି, “ଆତିହିଁ ନା଼ ପା଼ଡ଼ିତାସି ଆମ୍ବାଆରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜୀସୁ ଏ଼ କାତା ଆସାନା ଏଲେଇଚେସି, “ର଼ ଲ଼କୁ ଜିରୁସାଲମଟିଏ ଜିରିହତା ହାଜିମାଚାଟି ସ଼ର୍‌କା ତା଼ଣା ହେର୍‌ହେସି । ଏ଼ୱାରି ଏ଼ୱାଣି ହିମ୍ବରିଦୂକି ମୀଞ୍ଜାନା ହା଼ନିଲେହେଁ ମା଼ଡା ୱେ଼ଚାନା ପିସା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଏଚିବେ଼ଲାତା ର଼ ପୂଜେରା ଏ଼ ଜିରୁଟି ହାଜିମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ମେସାନା ଜିରୁ ପିସାନା ଅ଼ର ଜିରୁଟି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ଏଲେକିହିଁଏ ର଼ ଲେ଼ବି କୂଡ଼ାତାସି ଜିକେଏ ଏ଼ ଜିରୁଟି ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ମେସାନା ଅ଼ର ଜିରୁ ହୀହାନା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ସାମା ର଼ ସମିରଣ ଲ଼କୁ ଏ଼ ଜିରୁଟି ହାଜିମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ମେସାନା ହା଼ରେକା କାର୍ମା ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଅ଼ଡ଼େ ଡାଗେ ହାଜାନା ଏ଼ୱାଣି ଗା଼ହାଁୟାଁ ବାରେ ନିୟୁଁ ଅ଼ଡ଼େ ଅଙ୍ଗୁରି ରାସା ରୁବାନା ଗା଼ହାଁୟାଁଣା ଦସ୍‌ପାନା ଏ଼ୱାଣାଇଁ ର଼ ଗା଼ଡ଼୍‌ଦେ ଲାକ କୁଗିକିହାନା ର଼ ସେ଼ବାକିନି ଇଲୁତା ଅ଼ହାନା ଏ଼ୱାଣି ସେ଼ବା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ଅ଼ର ଦିନା ସେ଼ବାକିନି ଇଲୁ ଗାଟାଣାକି ରୀ କା଼ନି ହୀହାନା ଏଲେଇଚେସି, ‘ଈୱାଣି ସେ଼ବା କିମୁ, ଅ଼ଡ଼େ ଏଚେକା ଗାଡି କାର୍ଚୁ ଆ଼ନୁ, ୱେଣ୍ତା ୱା଼ନାଟି ବାରେ ହିୟାଇଁ ।’” ");
INSERT INTO kxv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଜୀସୁ ଏଲେଇଚେସି, “ଈ ତୀନି ଜା଼ଣାତି ବିତ୍ରା ଆମ୍ବାଆସି ସ଼ର୍‌କାତା଼ଣା ହେର୍‌ହା ମାଚାଣି ପା଼ଡ଼ିତାସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ଏ଼ ମେ଼ରା ଜା଼ପ୍‌ନାସି ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ଏ଼ୱାଣାଇଁ କାର୍ମା ଆ଼ତେସି ଏ଼ୱାସି ।” ଜୀସୁ ଏଲେଇଚେସି, “ହାଲାମୁ ନୀନୁ ଜିକେଏ ଏଲେଏ କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଏ଼ୱାରି ହାଜିମାନି ବେ଼ଲାତା ର଼ ନା଼ୟୁଁତା ହାଚେରି, ଇଞ୍ଜାଁ ମାର୍ତା ଦ଼ରୁଗାଟି ର଼ ଇୟା ଜୀସୁଇଁ ତାମି ଇଜ ହା଼ଟିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ଏ଼ଦାନାକି ର଼ ତାଙ୍ଗି ମାଚେ ଏ଼ଦାନି ଦ଼ରୁ ମରିୟମ, ଏ଼ଦି ପ୍ରବୁତି କଡାଁ ଡ଼଼ଇ କୁଗାନା ଏ଼ୱାଣି କାତା ୱେଞ୍ଜିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ସାମା ମାର୍ତା ରା଼ନ୍ଦା ୱାଜାଲି ହା଼ରେକା କିଲିବିଲି ଆ଼ହିମାଚେ; ଈଦାଆଁତାକି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେ, “ଏ଼ ପ୍ରବୁ ନା଼ ତାଙ୍ଗି ୱାଜିନି କାମା ବାରେ ନା଼ ଲାକ ହେର୍‌ପା ମାଞ୍ଜାନେ ଈଦାଆଁ ଅଣ୍‌ପି ହିଲଅତି କି ? ଈଦାଆଁତାକି ନାଙ୍ଗେ ସା଼ୟେମି କିହାଲି ଏଲେଇନାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ସାମା ପ୍ରବୁ ଏଲେଇଚେସି, “ମାର୍ତା, ମାର୍ତା ନୀନୁ ହା଼ରେକା କାମାତା ଅଣ୍‌ପିହିଁ କିଲିବିଲି ଆ଼ହିମାଞ୍ଜି, ");
INSERT INTO kxv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ସାମା ୱାର୍‌ଇ ର଼ କାତା ଲ଼ଡ଼ାମାନେ । ମରିୟମ ଏ଼ ନେହିଁ କାତା ବାଚି କିହାମାନେ; ଏ଼ଦାଆଁ ଏ଼ଦାନି ତା଼ଣାଟି ଅ଼ୱି ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ର଼ ଦିନା ଜୀସୁ ର଼ ଟା଼ୟୁତା ପ୍ରା଼ତାନା କିହିମାଚେସି; ଏ଼ୱାସି ପ୍ରା଼ତାନା କିହାଲି ରା଼ପ୍‌ହାଲିଏ, ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅସି ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ, ଜହନ ଏ଼ନିକିଁ ତାନି ସୀସୁୟାଁଇଁ ପ୍ରା଼ତାନା କିହାଲି ଜା଼ପ୍‌ହି ମାଚେସି, ନୀନୁ ଜିକେଏ ମାଙ୍ଗେ ଏଲେକିହିଁଏ ପ୍ରା଼ତାନା କିହାଲି ଜା଼ପ୍‌ହାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଚିବେ଼ଲା ମୀରୁ ଏଲେଇଞ୍ଜି ପ୍ରା଼ତାନା କିଦୁ; ‘ଏ଼ ଆ଼ବା ନୀ ଦ଼ରୁ ନେହାୟି ଇଞ୍ଜିଁ ମା଼ନୱି ଆ଼ପେ; ନୀ ରା଼ଜି ୱା଼ପେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ବାରେଦିନା ମାଙ୍ଗେ ଲ଼ଡ଼ା ଆ଼ନି ରା଼ନ୍ଦା ହିୟାମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ମା଼ ଦ଼ହ ବାରେ ମ୍ଣେକ୍‌ହାମୁ, ଇଚିହିଁ ମା଼ମ୍ବୁ ଜିକେଏ ମା଼ ଦ଼ହ କିତାରାଇଁ ମ୍ଣେକ୍‌ନମି । ମାଙ୍ଗେ ପା଼ନ୍ଦାତା ମେତ୍‌ହାଆନି ।’” ");
INSERT INTO kxv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ତା଼ଣା ଆମ୍ବାଆସି ଇଲେତି ତ଼ଣେଏସି ମାନେସି, ଆମ୍ବାଆରି ତା଼ଣା ମାଦି ଲା଼ଆଁୟାଁ ହାଜାନା ଏଲେଇନେସି, ‘ଏ଼ ତ଼ଣେ ନାଙ୍ଗେ ତୀନିଗଟା ରୂଟି ହିୟାମୁ, ");
INSERT INTO kxv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ଇଚିହିଁ ନା଼ ଗତାଗାଟି ତ଼ଣେଏସି ନା଼ ତା଼ଣା ୱା଼ହାମାନେସି, ଏ଼ୱାଣାକି ତିଞ୍ଜାଲି ହୀହାଲି ନା଼ ତା଼ଣା ଏ଼ନାୟିୱା ହିଲେଏ !’ ");
INSERT INTO kxv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଅ଼ଡ଼େ ବିତ୍ରାଟି ଏଲେଇନେସି, ‘ନାଙ୍ଗେ କସ୍ତ ହିୟାଆନି; ଦା଼ରା ସୁଣ୍ତ୍‌କି ଆ଼ତେୟିଏ, ଇଞ୍ଜାଁ ନା଼ ମୀର୍‌କା ନା଼ ତଲେ ଡୂରା ମାନେରି; ନା଼ନୁ ନିଙ୍ଗାନା ହୀହାଲି ଆ଼ଡଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ତାନି ତ଼ଣେଏସି ଆ଼ହାମାନାକି ଲାଜା ପିସାନା ଅଲେ ଅଲେ ରୀସ୍ତାକି ଏ଼ୱାସି ନିଙ୍ଗାନା ଏ଼ୱାଣି ଲ଼ଡ଼ାମାନି ପାତେକା ଏ଼ୱାସି ଏ଼ୱାଣାକି ହୀନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ରୀହ୍‌ଦୁ ଆତିହିଁ ମିଙ୍ଗେ ହୀପ୍‌କିଆ଼ନେ; ପାରାଦୁ ଆତିହିଁ ମେ଼ଡ଼ା ଆ଼ଦେରି; ଦୁୱେରିତା ୱେ଼ଦୁ ଆତିହିଁ ମିଙ୍ଗେତାକି ଦା଼ରା ଦେପି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଇଚିହିଁ ଆମ୍ବାଆସି ରୀହ୍‌ନେସି ଏ଼ୱାସି ବେଟାଆ଼ନେସି; ଆମ୍ବାଆସି ପାରିନେସି ଏ଼ୱାସି ମେ଼ଡ଼ାଆ଼ନେସି; ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଦୁୱେରିତା ୱେ଼ନେସି ଏ଼ୱାଣି ତାକି ଦା଼ରା ଦେପିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ଅ଼ଡ଼େ ମୀ ତା଼ଣା ଇଲେତି ଆମିନି ଆ଼ବା ମାନେସି, ତାନି ମୀର୍‌ଏସି ମୀନୁ ରୀସ୍ତିସାରେ ଏ଼ୱାସି ମୀନୁତି ବାଦୁଲି ରା଼ଚୁ ହୀନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଅ଼ଡ଼େ ଗୁଡୁ ରୀସ୍ତିସାରେ ଏ଼ୱାଣାକି କାଚାକୁପି ହୀନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ଈଦାଆଁତାକି ମୀରୁ ଲାଗେଏ ପ଼ଲେଏତି ଲ଼କୁ ଆ଼ତିଜିକେଏ ମୀ ମୀର୍‌କା ମା଼ସ୍‌କାକି ନେହାଁଣି ହୀହିମାଞ୍ଜେରି, ଆତିହିଁ ଆମିନି ଆ଼ବା ଲାକପୂରୁଟି ହୀହିମାଞ୍ଜାନେସି, ଏ଼ୱାସି ତାନି ତା଼ଣା ରୀହ୍‌ନି ଲ଼କୁକି ଏଚେ ହା଼ରେକା ସୁଦୁଜୀୱୁ ହୀଅସି !” ");
INSERT INTO kxv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ଜୀସୁ ର଼ ପା଼ଲି ବୂତୁ ପେ଼ର୍‌ହି ମାଚେସି ଏ଼ ବୂତୁ ଗୁଲା । ବୂତୁ ଏ଼ୱାଣି ତା଼ଣାଟି ହ଼ଚା ହାଜାଲିଏ ଏ଼ ଗୁଲା ଜ଼ଲିତେସି; ଏମ୍ବାଟିଏ ଲ଼କୁ ବାରେ କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ସାମା ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଚେରି, “ଏ଼ୱାସି ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ କାଜା ପେ଼ନୁ ବାଲ୍‌ଜିବୁଲ୍‌ ବୂତୁ ତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ଇଞ୍ଜାଁ ଏଟ୍‌କାତାରି ଏ଼ୱାଣାଇଁ ତାୟିପାରି କିହାଲିତାକି ଏ଼ୱାଣି ତା଼ଣାଟି ହା଼ଗୁଟି ର଼ ସିନା ରୀସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ସାମା ଏ଼ୱାସି ଏ଼ୱାରି ମ଼ନତି ଅଣ୍‌ପୁ ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ଆମିନି ରା଼ଜି ବା଼ଗା ଆ଼ହାନା ତାନି କ଼ପାଟି ନିଙ୍ଗିନେ ଏ଼ଦି ନା଼ସା ଆ଼ହାହାନେ ଇଞ୍ଜାଁ ଇଲୁ ଲାକ ବାରେ ରିହାହାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଇଞ୍ଜାଁ ସୟତାନ ବା଼ଗା ଆ଼ହାନା ଜାହାରା କ଼ପାଟି ନିଙ୍ଗିନେ, ଇଚିହିଁ ତାନି ରା଼ଜି ଏ଼ନିକିଁ ତୀରିଆ଼ହାନା ଡ଼ୟିନେ ? ନା଼ନୁ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ବାଲ୍‌ଜିବୁଲ୍‌ ତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାଇଁ ଇଞ୍ଜିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ସାମା ନା଼ନୁ ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ବାଲ୍‌ଜିବୁଲ୍‌ ତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାଇଁ, ଆତିହିଁ ମୀ ମୀର୍‌କା ଆମ୍ବାଆରି ବା଼ଡ଼୍‌ୟୁ ତଲେ ପିସ୍‌ପି କିନେରି ? ଇଞ୍ଜାଁ ଏ଼ୱିଏ ମିଙ୍ଗେ ନୀହାଁୟି କିୟାନୁ । ");
INSERT INTO kxv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ସାମା ନା଼ନୁ ମାହାପୂରୁ ବା଼ଡ଼୍‌ୟୁ ତଲେ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାଇଁ ଇଚିହିଁ ମାହାପୂରୁତି ରା଼ଜି ମୀ ତା଼ଣା ଏଗାୱା଼ତେୟିଏ । ");
INSERT INTO kxv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ବାଡ଼୍‌ୟୁଗାଟି ଲ଼କୁ ଏଚେ଼ପାତେକା ଆ଼ସ୍ତି ଆସାନା ତାନି ଗା଼ଡ଼ାତି ଗେଲ୍‌ପିନେସି, ଏଚିବେ଼ଲା ପାତେକା ତାନି ଦ଼ନ ଗେଲ୍‌ପିଆ଼ହାନା ଡ଼ୟିନେ; ");
INSERT INTO kxv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ସାମା ଏଚିବେ଼ଲା ଏ଼ୱାଣି କିହାଁ ହା଼ରେକା ବାଡ଼୍‌ୟୁଗାଟି ଲ଼କୁ ଏ଼ୱାଣିତଲେ ଜୁଜୁ କିହାନା ଜୀଣା ଆ଼ନେସି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ଆମିନି ଆ଼ସ୍ତିତି ବା଼ର୍ସୁ କିହାମାଚେସି, ଏ଼ ବାରେ ଏ଼ୱାସି ମୀଞ୍ଜା ଅ଼ନେସି, ଇଞ୍ଜାଁ ମୀଞ୍ଜା ଅ଼ହାମାନି ଦ଼ନ ବା଼ଟିକିହା ଅ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ଆମ୍ବାଆସି ନା଼ ୱାକିଟି ଆ଼ଆଗାଟାସି ଏ଼ୱାସି ନା଼ ସାତ୍ରୁ; ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ନା଼ ତଲେ କୂଡ଼ି କିଅସି ଏ଼ୱାସି ଆଲାରା କିନାସି । ");
INSERT INTO kxv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ର଼ ପ଼ଲ୍‌ଆ ବୂତୁ ର଼ ମାଣ୍‌ସି ତା଼ଣାଟି ହ଼ଚା ହାଜାନା ଏ଼ୟୁ ହିଲାଆ ୱା଼ୟିତି ଟା଼ୟୁତା ଜ଼ମାଲି ପାରିନେ, ଇଞ୍ଜାଁ ମେଡ଼ି କିଆନା ଏଲେଇନେ, ‘ନା଼ନୁ ଆମିନି ଇଲୁଟି ହ଼ଚା ୱା଼ହାମାଚେଏଁ, ଏ଼ ଇଲୁତା ୱେଣ୍ତା ହାଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଇଞ୍ଜାଁ ଏ଼ଦି ୱେଣ୍ତା ୱା଼ହାନା ଏ଼ଦାଆଁ ଅ଼ଜିହିଁ ନେହିଁ ଆ଼ହାମାନାଣି ମେହ୍‌ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ଏଚିବେ଼ଲା ଏ଼ଦି ହାଜାନା ତାନିକିହାଁ ହା଼ରେକା ପ଼ଲ୍‌ଆଗାଟି ସା଼ତାଗଟା ବୂତୁୟାଁ ଆସାନା ୱା଼ନେ, ଅ଼ଡ଼େ ବାରେଜା଼ଣା ଏମ୍ବାଆଁ ହ଼ଡାନା ବାସା କିନୁ, ଇଞ୍ଜାଁ ଏ଼ ମାଣ୍‌ସିତି ତଲିତି କସ୍ତ କିହାଁ ଡା଼ୟୁତି କସ୍ତ ହା଼ରେକା ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜୀସୁ ଈ ବାରେ କାତା ୱେସିମାଚାଟି ଲ଼କୁ ମାନ୍ଦା ବିତ୍ରାଟି ର଼ ଇୟା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେ, “ଆମିନିଗାଟି ଇୟା ନିଙ୍ଗେ ଜାର୍ନି କିହାନା ପା଼ଲୁ ଊଟ୍‌ହାତେ ଏ଼ ଇୟା ହା଼ରେକା ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଆମ୍ବାଆରି ମାହାପୂରୁତି ବ଼ଲୁ ୱେନେରି ଅ଼ଡ଼େ ମା଼ନୱି ଆ଼ନେରି ଏ଼ୱାରାକିଦେହେଁ ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ଲ଼କୁ ମାନ୍ଦା ମାନ୍ଦା ଆ଼ହାନା ଏ଼ୱାଣି ତା଼ଣା ରୁଣ୍ତା ଆ଼ହାଲିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ଈ କା଼ଲାତି ଲ଼କୁ ହା଼ରେକା ଲାଗେଏତାରି; ଈୱାରି ବାରେ ସିନାୟାଁ ପାରିନେରି, ସାମା ଏ଼ୱାରାକି ଜୁନସତି ସିନା ପିସ୍‌ପେ ଏ଼ନି ସିନା ହୀପ୍‌କିଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଇଚିହିଁ ଜୁନସ ଏ଼ନିକିଁ ନିନିବି ଲ଼କୁତାକି ର଼ ସିନାଲେହେଁ, ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ଏଲେକିହିଁଏ ଈ ଜୁଗୁତି ଲ଼କୁତାକି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ନୀହାଁୟି ଦିନାତା ସିବା ଦେ଼ସାତି ରା଼ଣି ଈ କା଼ଲାତି ଲ଼କୁ ନ଼କିତା ନିଚାନା ଏ଼ୱାରି କ଼ପାଟି ସା଼କିହୀନେ, ଇଚିହିଁ ଏ଼ଦି ସଲମନତି ବୁଦିତିକାତା ୱେଞ୍ଜାଲି ଦାର୍‌ତିତି ହେକ ଦେ଼ସାଟି ୱା଼ହାମାଚେ; ମେହ୍‌ଦୁ ସଲମନକିହାଁ କାଜାସି ଇମ୍ବାଆଁ ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନୀହାଁୟି ଦିନାତା ନିନିବି ଗା଼ଡ଼ାତି ଲ଼କୁ ନିଚାନା ଏ଼ୱାରି କ଼ପାଟି ସା଼କି ହୀନେରି, ଇଚିହିଁ ଏ଼ୱାରି ଜୁନସ ୱେସ୍ତି କାତା ୱେଞ୍ଜାନା ଅଣ୍‌ପା କଡାନା ମ଼ନ ୱେଟ୍‌ହେରି; ମେହ୍‌ଦୁ ଜୁନସକିହାଁ ହା଼ରେକା କାଜାସି ଇମ୍ବାଆଁ ମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ଆମ୍ବାଆସି ଦୀୱଁ ଡ଼ୀସାନା ଡ଼ୂକ୍‌ନି ଟା଼ୟୁତା କି ମା଼ଣା ପ୍ଡିକ୍‌ହାନା ଇଟଅରି, ସାମା ଦୀୱଁ ସ଼ଡ଼ାତା ଇଟିନେରି, ଏ଼ନିକିଁ ଇଲୁ ବିତ୍ରା ୱା଼ନି ଲ଼କୁ ଉଜେଡ଼ି ମେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ମୀ କାଣ୍‌କା ଆଙ୍ଗାତି ଦୀୱଁ ଏଚେ଼ତା ମୀ କାଣ୍‌କା ନେହିଁ ମାନୁ ଏଚିବେ଼ଲା ପାତେକା ମୀ ଆଙ୍ଗା ବାରେ ଉଜେଡ଼ି ଆ଼ନେ; ସାମା ଏଚେ଼ତା ନୀ କାଣ୍‌କା ନେହିଁ ହିଲାଉ ଇଚିହିଁ ଏଚେ଼ତା ମୀ ଗୂଡ଼ା ଆଙ୍ଗା ଜିକେଏ ଆନ୍ଦେରି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ଈଦାଆଁତାକି ଜାଗ୍ରାତା ଏ଼ନିକିଁ ମୀ ହିୟାଁତା ମାନି ଉଜେଡ଼ି ଆନ୍ଦେରି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀ ଗୂଡ଼ା ଆଙ୍ଗା ବାରେ ଉଜେଡ଼ି ଆ଼ନେ ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ଏ଼ନି ଆନ୍ଦେରି ଡ଼ୟେଏ, ଆତିହିଁ ଦୀୱଁ ଏ଼ନିକିଁ ମିଙ୍ଗେ ତାର୍ହାଣା ଉଜେଡ଼ିତା ଉଜେଡ଼ି କିୟାନେ, ଏଲେକିହିଁଏ ମୀ ଗୂଡ଼ା ଆଙ୍ଗା ଉଜେଡ଼ି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜୀସୁ ଈ କାତା ୱେସ୍ତି ଡା଼ୟୁ ର଼ ପାରୁସି ଏ଼ୱାଣାଇଁ ତାନି ଇଜ ତିଞ୍ଜାଲି ଏଲେଇଚେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ଇଜ ହାଜାନା ତିଞ୍ଜାଲି କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ସାମା ତିଞ୍ଜାଲି କୁଗିନି ନ଼କେଏ ଏ଼ୱାସି କେସ୍କା କଡାୟାଁ ନର୍‌ହା ହିଲାଆତେସି, ଈଦାଆଁ ମେସାନା ଏ଼ ପାରୁସି କାବା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଏଚେଟିଏ ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ମୀ ପାରୁସିୟାଁତେରି ଗିନାୟାଁ ଅ଼ଡ଼େ ସାଡ଼୍‌ୱାୟାଁ ପାଙ୍ଗାତା ନର୍‌ହି ମାଞ୍ଜେରି, ସାମା ମୀ ବିତ୍ରା ଜୂପ୍‌କା ଅ଼ଡ଼େ ଲାଗେଏତାୟି ନେଞ୍ଜାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଆଡ଼େ ବୁଦି ହିଲାଆଗାଟାତେରି, ଆମ୍ବାଆସି ପାଙ୍ଗାତାଣି ଗା଼ଡ଼ିକିତେସି, ଏ଼ୱାସି ବିତ୍ରାତାଣି ଜିକେଏ ଗା଼ଡ଼ି କିହାହିଲଅସି କି ? ");
INSERT INTO kxv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ସାମା ମୀ ସାଡ଼୍‌ୱାୟାଁ ଅ଼ଡ଼େ ଗିନାୟାଁଣା ମାନାଣି ହିଲାଆ ଗାଟାରାକି ହୀତିହିଁ ମିଙ୍ଗେତାକି ବାରେଏ ଅଟ୍‌ହାୟି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ସାମା ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି ପାରୁସିୟାଁତେରି, ଇଚିହିଁ ମୀରୁ ହାର୍ସୁ, ରା଼ୟି ଇଞ୍ଜାଁ ବାରେ କୁଚାତି ଦସ ବା଼ଗାଟି ର଼ ବା଼ଗା ହୀହିମାଞ୍ଜେରି, ସାମା ନୀହାଁୟିତା ଅ଼ଡ଼େ ମାହାପୂରୁତି ଜୀୱୁ ନ଼ନି ତା଼ଣା ଅଣ୍‌ପି ହିଲଅତେରି; ସାମା ଈ ବାରେ ମା଼ନୱି ଆ଼ହାନା ଏଟ୍‌କାତାଣି ହେଲା ଆ଼ନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି ପାରୁସିୟାଁତେରି, ଇଚିହିଁ ମୀରୁ ମାହାପୂରୁ ଇଲୁତା କାଜା ଟା଼ୟୁ ଇଞ୍ଜାଁ ହା଼ଟା ବାଜାରାତା ଜହରା ବେଟାଆ଼ହାଲି ନେହେଁ ଅଣ୍‌ପିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଆୟ଼ତା ମୀରୁ ଡଣ୍ତ ବେଟା ଆ଼ନାତେରି, ଇଚିହିଁ ମୀରୁ ତ଼ଞ୍ଜା ଆ଼ଆଗାଟି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁଲେହେଁ ତାତେରି; ଇଚିହିଁ ପୁନାଆନା ଲ଼କୁ ଲାକ ତାକି ମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଏଚେଟିଏ ମ଼ସାତି ମେ଼ରାପୁନାରି ବିତ୍ରାଟି ରଅସି ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ନୀନୁ ଏଲେଇଞ୍ଜି ମାଙ୍ଗେ ଲାଜା କିହିମାଞ୍ଜାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜୀସୁ ଏଲେଇଚେସି, ଆୟ଼ତା ମ଼ସାତି ମେ଼ରା ପୁନାତେରି ମୀରୁ, ମୀରୁ ଜିକେଏ ଡଣ୍ତ ବେଟାଆ଼ଦେରି, ଇଚିହିଁ ମୀରୁ ମାଣ୍‌ସିୟାଁ ଲାକ ବ଼ଜୁଗାଟି କା଼ସ୍‌କା ଏକ୍‌ହି ମାଞ୍ଜେରି ଅ଼ଡ଼େ ଏ଼ ବ଼ଜୁତି ମୀରୁ ର଼ ୱାଞ୍ଜୁ ତଲେ ଜିକେଏ ଡୀଗଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଆୟ଼ତା ଡଣ୍ତ ବେଟା ଆ଼ନାତେରି ମୀରୁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ପା଼ୟାନା ଏ଼ୱାରି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁ ତିୟାରା କିହିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ଇଚିହିଁ ମୀରୁ ମୀ ଆକୁ ଆ଼ବାୟାଁ କାମାତା ସା଼କି ତ଼ସି ମାଞ୍ଜେରି ଇଞ୍ଜାଁ ଏ଼ୱାରିଲେହେଁ ଆ଼ହିମାଞ୍ଜେରି; ଇଚିହିଁ ଏ଼ୱାରିସାଁ ଏ଼ୱାରାଇଁ ପା଼ୟାମାଚେରି, ସାମା ମୀରୁ ଏ଼ୱାରି ମୁହ୍‌ନି ଟା଼ୟୁତି କାତିୟାଁ ନିପ୍‌ହି ମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଈଦାଆଁତାକି ମାହାପୂରୁ ଜିକେଏ ତାନି ବୁଦିତଲେ ଏଲେଇଞ୍ଜା ମାନେସି, ନା଼ନୁ ଏ଼ୱାରି ନ଼କିତା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ଅ଼ଡ଼େ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ପାଣ୍ତିଇଁ; ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରାଇଁ ପା଼ୟିନେରି ଇଞ୍ଜାଁ ନିନ୍ଦା କିନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଈ ଜୁଗୁତି ଲ଼କୁ ଦାର୍‌ତି ଗା଼ଡ଼ି ଆ଼ତି ନ଼କେଏଟିଏ ବାରେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପା଼ୟିତାକି ଡଣ୍ତ ବେଟାଆ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ଏ଼ନିକିଁ ହେବଲଇଁ ପା଼ୟିତି ଦିନାଟିଏ ଜିକରିୟ ପାତେକା ଆମ୍ବାଆରାଇଁ ମାହାପୂରୁ ଇଲୁତି ଡ଼ା଼କିନି ପିଣ୍ତା ଅ଼ଡ଼େ ସୁଦୁ ବାକ୍ରା ମାଦିଏ ପା଼ୟ୍‌ୱି ଆ଼ହାମାଚେ । ହାଅ, ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ଦାନି ବାଦୁଲି ଈ ଜୁଗୁତି ଲ଼କୁ ଏ଼ ବାରେତାକି ଡଣ୍ତ ବେଟାଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ଆୟ଼ତା ଡଣ୍ତ ପା଼ଣ୍‌ନି ମେ଼ରା ପୁନାତେରି ମୀରୁ, ଇଚିହିଁ ବୁଦି ଦେନି କୁଚିତି ଅ଼ହାମାଞ୍ଜେରି; ମୀରୁତ ହ଼ଡି ହିଲଅତେରି ସାମା ହ଼ଡାଲି ଅଣ୍‌ପି ମାନାରାଇଁ ଆ଼ଂଗିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଜୀସୁ ଏ଼ ଇଜଟି ହାଜାଲିଏ ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ହା଼ରେକା ଡା଼ହାରା ଆ଼ହାନା । ");
INSERT INTO kxv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ଏ଼ୱାଣି ଜ଼ଲିନି ହା଼ଡାତା ଦ଼ହ ଆସାଲି ଏ଼ୱାଣାଇଁ ହା଼ରେକା କାତା ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଏଚିବେ଼ଲାତା ମା଼ଣା ମା଼ଣା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ହାନା ୱିସ୍‌ପି ଆ଼ହିମାଚେରି; ଏଚିବେ଼ଲା ଏ଼ୱାସି ନ଼କେଏ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, ପାରୁସିୟାଁ ଲାଗେଏତି କୁଟୁଗାଟି ତା଼ଣାଟି ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ସାମା ଏ଼ନାୟି ତ଼ଞ୍ଜା ଆ଼ଏ, ଇଲେକିଁ ପ୍ଡିପ୍‌କି ଆ଼ହା ହିଲେଏ, ଅ଼ଡ଼େ ଏ଼ନାୟି ପୁନାଆରେ଼ଟୁ ଇଲେକିଁ ଡ଼ୁଗାମାନାୟି ଏ଼ନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ଇଚିହିଁ ମୀରୁ ଏ଼ନା ଏ଼ନାଆଁ ଆନ୍ଦେରିତା ୱେସାମାଞ୍ଜେରି, ଏ଼ ବାରେ ଉଜେଡ଼ିତା ୱେଣ୍‌ମ୍ବିଆ଼ନେ, ଏ଼ନା ଏ଼ନାଆଁ ପୁନାଆ ରେ଼ଟୁ ଇଲୁ ବିତ୍ରା ଡ଼ୁଗାନା ୱେସାମାଞ୍ଜେରି, ଏ଼ଦାଆଁ ଇଲୁ ତୂଡ଼ିୟାତା ୱେ଼ପ୍‌କି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ଇଚିହିଁ ନା଼ ତ଼ଣେସିଙ୍ଗାତେରି ମୀରୁ, ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ଆମ୍ବାଆରି ଆଙ୍ଗାତି ପା଼ୟିନେରି ସାମା ଡା଼ୟୁ ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡଅରି, ଏ଼ୱାରାଇଁ ଆଜାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ସାମା ଆମ୍ବାଆରାଇଁ ଆଜିଦେରି ଏ଼ଦାଆଁ ମିଙ୍ଗେ ୱେସ୍ତାଇଁ; ପା଼ୟିତି ଜେ଼ଚ ହିଚୁ ଗା଼ଡ଼୍‌ୟୁତା ମେତ୍‌ହାଲି ଆମ୍ବାଆରି ଅଦିକାରା ମାନେ, ଏ଼ୱାଣାଇଁ ଆଜାଦୁ; ହାଅ ନା଼ନୁ ନିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାଣାଇଁ ଆଜାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ପା଼ସାଗଟା ଜେତା ପଟାୟାଁ ରୀ କା଼ନି ତାକି ପାର୍‌ପି ଆ଼ଉ କି ? ଆ଼ତିଜିକେଏ ଏ଼ୱାସିକା ବିତ୍ରାଟି ରଣ୍ତାଣି ଜିକେଏ ମାହାପୂରୁ ବା଼ଣା ଆ଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ସାମା ମୀ ତା଼ର୍ୟୁଁତି ବାରେ ବା଼ଣାୟାଁ ଜିକେଏ ଏଜିକିୱି ଆ଼ହାମାନୁ । ଆଜା ଆ଼ଦୁ; ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀରୁ ଜେତା ପଟାୟାଁ କିହାଁ ହା଼ରେକା ଦାରା ଗାଟାତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଅ଼ଡ଼େ, ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ଲ଼କୁ ନ଼କିତା ନାଙ୍ଗେ ୱେ଼କ୍‌ହାନେସି, ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ମାହାପୂରୁତି ଦୂତୁୟାଁ ନ଼କିତା ୱେ଼କ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ସାମା ଆମ୍ବାଆସି ଲ଼କୁ ନ଼କିତା ନାଙ୍ଗେ ୱେ଼କ୍‌ହଅସି, ଏ଼ୱାଣାଇଁ ଜିକେଏ ମାହାପୂରୁ ଦୂତୁୟାଁ ନ଼କିତା ୱେ଼କ୍‌ଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ମାଣ୍‌ସି ମୀର୍‌ଏଣା କ଼ପାଟି ଜ଼ଲିନେସି, ଏ଼ୱାଣି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନେ; ସାମା ଆମ୍ବାଆସି ସୁଦୁଜୀୱୁ କ଼ପାଟି ନିନ୍ଦା କାତା ଜ଼ଲିନେସି, ଏ଼ୱାଣି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗେଏ । ");
INSERT INTO kxv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ଏଚିବେ଼ଲା ଏ଼ୱାରି ମିଙ୍ଗେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା, ସା଼ଲୱି କିନାରି ତା଼ଣା ଇଞ୍ଜାଁ ଅଦିକାରା ବେଟା ଆ଼ହାମାନାରି ତା଼ଣା ଅ଼ହାନା ନିପ୍‌ହାନେରି ଏଚିବେ଼ଲା ନା଼ ୱାକିଟି ଆ଼ହାନା ଏ଼ନା ଏ଼ନାଆଁ ଜ଼ଲିନମି ଇଞ୍ଜିଁ ଅଣ୍‌ପାଆଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଇଚିହିଁ ଏ଼ନାଆଁ ଜ଼ଲିନାୟି ମାନେ, ଏ଼ଦାଣି ଏଚିବେ଼ଲାତେଏ ସୁଦୁଜୀୱୁ ମିଙ୍ଗେ ଜା଼ପ୍‌ହାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ଲ଼କୁ ମାନ୍ଦା ବିତ୍ରାଟି ରଅସି ଜୀସୁଇଁ ଏଲେଇଚେସି, ଏ଼ ଗୂରୁ ନା଼ ତାୟିଇଁ ମା଼ ଆ଼ବାତି ଦ଼ନ ବା଼ଟି କିହାଲି ଏଲେଇଞ୍ଜା ହିୟାମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ସାମା ଜୀସୁ ଏଲେଇଚେସି, ଏ଼ ତାୟି ଆମ୍ବାଆସି ନାଙ୍ଗେ ମୀ ମୁହେଁ ନୀହାଁୟି କିହାଲି ମାଦି କିହାନା ଆ଼ଚାମାଞ୍ଜାନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ଜାଗ୍ରାତା, ବାରେୱାକିତି ଜୂପ୍‌କାଟି ମିଙ୍ଗେ ଗେଲ୍‌ପିକିହା କଡାଦୁ, ଇଚିହିଁ ର଼ ମାଣ୍‌ସିତି ଜୀୱୁ ତାନି ଦ଼ନତି ବା଼ର୍ସୁ କିନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଜୀସୁ ଏ଼ୱାରାଇଁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, “ର଼ ସା଼ୱୁକାରିକି ବୂମିତା ଗାଡି ତା଼ସା କାମ୍ବିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ମ଼ନ ମ଼ନତା ଅଣ୍‌ପାନା ଏଲେଇଚେସି, ‘ନା଼ନୁ ନୀଏଁ ଏ଼ନାଆଁ କିଇଁ ? ନା଼ ଆର୍ନା କୂଡ଼ି କିହାନା ଇଟାଲି ଟା଼ୟୁ ହିଲେଏ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଅ଼ଡ଼େ ଏଲେଇଚେସି; ‘ନୀଏଁ ଇଲେ କିଇଁ ମାନି ଗା଼ଦେୟିକା ରିକ୍‌ହାନା କାଜାଆଁ କିହାନା ଏମ୍ବାଆଁ ଗ଼ହଁୟାଁ ଇଞ୍ଜାଁ ଏ଼ନି ଏ଼ନି ଆର୍ନା କୂଡ଼ି କିହାନା ଇଟିଇଁ, ");
INSERT INTO kxv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଅ଼ଡ଼େ ନା଼ ଜୀୱୁତି ଏଲେଇଇଁ, ଏ଼ ଜୀୱୁ, ହା଼ରେକା ବାର୍ସା ତାକି ନିଙ୍ଗେ ତାକି ଗାଡି ଆର୍ନା କୂଡ଼ି କିୱିଆ଼ହାମାନେ, ନୀଏଟି ଜ଼ମାନା ମ଼ନକିତି ଲେହେଁ ତିଞ୍ଜା ଉଣ୍ତାନା ରା଼ହାଁ କିମୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ସାମା ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ଆଡ଼େ ବୁଦି ହିଲାଆଗାଟାତି, ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ ନୀ ଜୀୱୁ ନୀ ତା଼ଣାଟି ଅ଼ୱିଆ଼ନେ; ଏଚେଟିଏ ନୀନୁ କୂଡ଼ିକିହା ଇଟାମାନି ବାରେ ଦ଼ନ ଆମ୍ବାଆରାୱାୟି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଜୀସୁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ତାଙ୍ଗେତାକି ଦ଼ନ କୂଡ଼ି କିନେସି, ସାମା ମାହାପୂରୁ ତା଼ଣା ଦ଼ନଗାଟାସି ଆ଼ଅସି, ଏ଼ୱାସି ଈୱାଣି ଲେହେଁତାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜୀସୁ ତାନି ସୀସୁୟାଣି ଏଲେଇଚେସି, ଈଦାଆଁତାକି ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ନାଆଁ ତିନାୟି, ଇଲେକିଁ ମୀ ଜୀୱୁତାକି, ଏ଼ନାଆଁ ତୁର୍‌ନାୟି ଇଲେକିଁ ମୀ ଆଙ୍ଗା ତାକି ଜିକେଏ ମୀରୁ ଅଣ୍‌ପାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଇଚିହିଁ ରା଼ନ୍ଦା କିହାଁ ଜୀୱୁ କାଜାୟି ଅ଼ଡ଼େ ହିମ୍ବରିକା କିହାଁ ଆଙ୍ଗା କାଜାୟି । ");
INSERT INTO kxv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ପଟାୟାଁଣି ସିନିକିଦୁ, ଏ଼ୱି ମାଟାଉ କି ଦା଼ଉ, ଇଞ୍ଜାଁ ଏ଼ୱାସିକା ଗା଼ଦେୟିକା ହିଲାଉ, ଅ଼ଡ଼େ ମାହାପୂରୁ ଏ଼ୱାସିକାକି ତିନି କା଼ଦି ହୀନେସି; ମୀରୁ ପଟାୟାଁ କିହାଁ ଏଚେକା କାଜାତେରି ! ");
INSERT INTO kxv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଅ଼ଡ଼େ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆତେରି ଅଣ୍‌ପି ଅଣ୍‌ପିହିଁ ମୀ ଜୀୱୁତି ଆଗାଡ଼ା ପାଡିକିହାଲି ଆ଼ଡିଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ମୀରୁ ର଼ ଊଣା କାମାତି କିହାଲି ଆ଼ଡିହିଲଅତେରି, ଆତିହିଁ ଏଟ୍‌କାତି କାତା ଏ଼ନାଆଁତାକି ଗାଡି ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ଜା଼ଡ଼ାତି ପୂଙ୍ଗାଣି ସିନିକିହାଁ ଅଣ୍‌ପାଦୁ, ଏ଼ୱି ଏ଼ନି କାମା କିଉ; ଆ଼ତିଜିକେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ସଲମନକି ବାରେ ଅ଼ଜିତାୟି ମାଚିହିଁ ଜିକେଏ ଏ଼ୱାଣାକି ଈ ପୂଙ୍ଗା ଏଚେକା ଅ଼ଜିତି ହିମ୍ବରିକା ହିଲାଆତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ଆମିନି ଜା଼ଡ଼ା ନୀଞ୍ଜୁ ମାନେ, ୱିଏ ୱା଼ୟା ହାନେ ଅ଼ଡ଼େ ହଲୁତା ହୂଡ୍‌କିଆ଼ନେ, ମାହାପୂରୁ ଏ଼ ଜା଼ଡ଼ାତି ଇଲେତି ୱା଼ଣା ହୀନେସି, ଏ଼ନାଆଁ ଏ଼ୱାସି ମିଙ୍ଗେ ହିମ୍ବରିକା ପର୍‌ୱି କିୟଅସି ? ମୀ ନାମୁ ଏଚେକା ଊଣା ! ");
INSERT INTO kxv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ଏ଼ଦାଆଁତାକି ଏ଼ନାଆଁ ତିନାୟି ଏ଼ନାଆଁ ଗହ୍‌ନାୟି, ଏ଼ଦାଆଁ ମୀରୁ ପାରିହିଁ ରେ଼ଆଦୁ କି ଅଣ୍‌ପାଆଦୁ, ");
INSERT INTO kxv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ଇଚିହିଁ ଦାର୍‌ତିତି ଜୀହୁଦିଆ଼ଆତାରି ଏ଼ ବାରେ ପାରିହିଁ ରେ଼ନେରି; ସାମା ଈ ବାରେ ମୀ ଲ଼ଡ଼ାମାନେ ଏ଼ଦାଆଁ ମୀ ଲାକପୂରୁତି ଆ଼ବା ପୁଞ୍ଜାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମୀରୁ ମାହାପୂରୁତି ରା଼ଜି ପାରାଦୁ, ଆତିହିଁ ଈ ବାରେ ମିଙ୍ଗେ ହୀପ୍‌କିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ଏ଼ ଊଣା ମେ଼ଣ୍ତା ମାନ୍ଦାତେରି ଆଜାଆଦୁ, ଇଚିହିଁ ମିଙ୍ଗେ ଏ଼ ରା଼ଜିତି ହୀହାଲି ମୀ ଲାକପୂରୁତି ଆ଼ବାକି ଏଚେକା ରା଼ହାଁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ମୀରୁ ମୀ ଦ଼ନତି ପାର୍‌ଚାନା ହିଲାଆ ଗାଟାରାକି ହୀଦୁ; ମୀରୁ ମିଙ୍ଗେତାକି ଇଲେତି ବଟ୍‌ୱା କେ଼ପାଦୁ; ଇଚିହିଁ ଏମ୍ବିୟା ସ଼ରୁ ୱା଼ଅସି ଅ଼ଡ଼େ ଲୀମ୍ବୁ ତିନେଏ ଇଲେତି ଲାକପୂରୁ ଦ଼ନ କୂଡ଼ି କିଦୁ, ");
INSERT INTO kxv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଇଚିହିଁ ଆମ୍ବିୟା ଦ଼ନ ଏମ୍ବେଏ ଜିକେଏ ମୀ ମ଼ନ ମାଞ୍ଜେମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ମୀ ଟେଡେଲି ଦସା କଡାନା ମାଞ୍ଜୁ ଅ଼ଡ଼େ ମୀ ଦୀୱଁୟାଁ ଡ଼ୀଞ୍ଜିହିଁ ମାଣ୍‌ମ୍ବୁ; ");
INSERT INTO kxv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଅ଼ଡ଼େ ପ୍ରବୁ ବୀହା ଇଜ ହାଜାନା ୱେଣ୍ତା ୱା଼ନାଟି ଏ଼ୱାଣାଇଁ ଦା଼ରା ଦେନମିୱା ଇଞ୍ଜିଁ କା଼ଚାମାନାରି, ମୀରୁ ଜିକେଏ ଏ଼ୱାରିଲେହେଁ କା଼ଚାହାଁ ମାଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ପ୍ରବୁ ୱା଼ହାନା ଆମିନି ହ଼ଲିୟାଙ୍ଗାଣି ଜାଗ୍ରାତା ମାନାଣି ମେହ୍‌ନେସି, ଏ଼ୱାରି ନେହେଁ; ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ତାନି ଟେଡେଲି ରୂପାନା ଏ଼ୱାରାଇଁ ତିଞ୍ଜାଲି କୁଗି କିହାଁ ଡାଗେ ହାଜାନା ସେ଼ବା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଅ଼ଡ଼େ ଏ଼ୱାସି ମାଦି ଲା଼ଆଁୟାଁ କି ୱେ଼ୟା ନେ଼କେରିତା ଜିକେଏ ୱା଼ହାନା ଏ଼ୱାରାଇଁ ଏଲେକିଁ କା଼ଚାମାନାଣି ମେହ୍‌ନେସି ଏ଼ ହ଼ଲିୟାଙ୍ଗା ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ସାମା ଈଦାଆଁ ପୁଞ୍ଜାମାଞ୍ଜୁ, ଆମିନି ବେ଼ଲାତା ସ଼ରୁ ୱା଼ନେସି, ଈଦାଆଁ ଇଲୁଗାଟାସି ପୁଚିହିଁ ଏ଼ୱାସି ତାନି କୂଡୁ ତୂତ୍‌ହାଲି ହୀଆତେସିମା । ");
INSERT INTO kxv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ମୀରୁ ଜିକେଏ ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ, ଇଚିହିଁ ମୀରୁ ଆମିନି ବେ଼ଲାତା ଅଣ୍‌ପା ହିଲଅତେରି, ଏଚିବେ଼ଲାତା ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ଏଚେଟିଏ ପିତର ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନୀନୁ ପୁଣ୍‌ମ୍ବିକିନି କାତା ମାଙ୍ଗେ କି ବାରେତାକି ୱେସିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ପ୍ରବୁ ଏଲେଇଚେସି, “ସା଼ୱୁକାରି ତାନି ଇଲୁତି ଲ଼କୁତାକି ତାନି ରା଼ନ୍ଦା କାଟୁତା ରା଼ନ୍ଦା ହୀହାଲି ତାନି ଗୁମୁସ୍ତା ପା଼ଣା ହେର୍‌ପିନେସି, ଇଲେତି ଟିକାଣାଗାଟି ଅ଼ଡ଼େ ବୁଦିଗାଟି ହ଼ଲେଏସି ଆମ୍ବାଆସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ପ୍ରବୁ ୱା଼ହାନା ତାନି ଆମିନି ହ଼ଲେଏଣାଇଁ ଏଲେ କିହିମାନାଣି ମେହ୍‌ନେସି ଏ଼ୱାସି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ତାନି ବାରେ ଦ଼ନତି ମୁହେଁ ଗୁମୁସ୍ତା କିହା ଇଟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ସାମା ଏ଼ ହ଼ଲେଏସି ନା଼ ସା଼ୱୁକାରି ୱା଼ନାୟି ମାନେୟିଏ ଇଞ୍ଜିଁ ମ଼ନତା ଅଣ୍‌ପାନା ହ଼ଲିୟାଙ୍ଗା ହ଼ଲେଣିସିକାଣି ୱେ଼ଚାଲି ଇଞ୍ଜାଁ ତିଞ୍ଜି ଉଣ୍ତିହିଁ କା଼ଡ଼ୁ ହ଼ଚାଲି ମା଼ଟ୍‌ନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ଆତିହିଁ ଏମିନି ଦିନା ହ଼ଲେଏସି କା଼ଚାହିଲଅସି ଇଞ୍ଜାଁ ଏମିନି ବେ଼ଲା ଏ଼ୱାସି ପୁଞ୍ଜାହିଲଅସି, ଏ଼ ଦିନା ଏ଼ ବେ଼ଲାତା ତାନି ପ୍ରବୁ ୱା଼ନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ରୀ ବା଼ଗା କିହାନା ନାମୁ ହିଲାଆଗାଟାରି ତଲେ ଏ଼ୱାଣାଇଁ କାଲ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ଅ଼ଡ଼େ ଆମିନି ହ଼ଲେଏସି ତାନି ସା଼ୱୁକାରିତି ମ଼ନ ଅଣ୍‌ପାନା ଜାଗ୍ରାତା ଆ଼ଅସି କି ଏ଼ୱାଣି ମ଼ନତଲେ କାମା କିଅସି, ଏ଼ୱାସି ଗାଡି ମା଼ଡା ବେଟା ଆ଼ନେସି; ");
INSERT INTO kxv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ସାମା ଆମ୍ବାଆସି ପୁନାଆନା ମା଼ଡା ପା଼ଣ୍‌ନି କାମା କିନେସି, ଏ଼ୱାସି ଊଣା ମା଼ଡା ବେଟା ଆ଼ନେସି । ଆମ୍ବାଆରାକି ଗାଡି ହୀପ୍‌କି ଆ଼ହାମାନେ, ଏ଼ୱାଣି ତା଼ଣାଟି ହା଼ରେକା ରୀହ୍‌ନାୟି ମାନେ; ଇଞ୍ଜାଁ ଲ଼କୁ ଆମ୍ବାଆରାକି ଗାଡି ହୀହାମାନେରି ଏ଼ୱାଣି ତା଼ଣାଟି ହା଼ରେକା ଆଗାଡ଼ା ରୀହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ନା଼ନୁ ଈ ଦାର୍‌ତିତା ହିଚୁ ପ୍ରତ୍‌ହାଲି ୱା଼ହାମାଇଁ, ଈଦି ନୀଏଁ ଗୁଦୁ ଗୁଦୁ ଆ଼ହିମାନେ ଆତିହିଁ ନାଙ୍ଗେ ଏ଼ନି ଅଣ୍‌ପୁ ? ");
INSERT INTO kxv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ସାମା ନା଼ନୁ ର଼ ବାପ୍ତିସ୍ମ ପା଼ଣ୍‌ନାୟି ମାନେ, ଅ଼ଡ଼େ ଏ଼ଦି ରା଼ଆ ପାତେକା ନାଙ୍ଗେ ଏଚେକା କସ୍ତ ହ଼ଚି ମାଞ୍ଜାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ନା଼ନୁ ଦାର୍‌ତିତା ହିତ୍‌ଡ଼ି ହୀହାଲି ୱା଼ହାମାଇଁ ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆ଼ଏ, ବା଼ଗା କିହାଲି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଇଚିହିଁ ର଼ ଇଜ ପା଼ସାଜା଼ଣା ମାନେରି, ରିଆରି କ଼ପାଟି ତୀନିଜା଼ଣା ଅ଼ଡ଼େ ତୀନିଜା଼ଣା କ଼ପାଟି ରିଆରି ଏଟ୍‌କା ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ମୀର୍‌ଏଣା କ଼ପାଟି ତାଞ୍ଜି, ତାଞ୍ଜି କ଼ପାଟି ମୀର୍‌ଏସି, ମା଼ଙ୍ଗା କ଼ପାଟି ତାଲି, ତାଲି କ଼ପାଟି ମା଼ଙ୍ଗା, କୁଡ଼ିୟାନି କ଼ପାଟି ପ଼ୟା, ଅ଼ଡ଼େ ପ଼ୟା କ଼ପାଟି କୁଡ଼ିୟା ଏଟ୍‌କା ଆ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଲ଼କୁଣି ଜିକେଏ ଏଲେଇଚେସି, “ୱେ଼ଡ଼ା କୂଡ଼୍‌ନିୱାକି ହା଼ଗୁ ନିଙ୍ଗି ମାନାଣି ମେସ୍ତିସାରେ ଦେବୁଣିଏ ଏଲେଇଞ୍ଜେରି ପିୟୁ ୱା଼ନେ, ଅ଼ଡ଼େ ଏଲେକିହିଁଏ ଆ଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଅ଼ଡ଼େ ଟିଃନି ୱାକିଟି ଗା଼ଲି ୱେନାଣି ମେସ୍ତିସାରେ ମୀରୁ ଏଲେଇଞ୍ଜେରି, ଗାଡି କାରା ଆ଼ନେ, ଅ଼ଡ଼େ ଏଲେଏ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଆଡ଼େ କୁଟୁ ଗାଟାତେରି, ମୀରୁ ଦାର୍‌ତି ଅ଼ଡ଼େ ହା଼ଗୁତି ସିନାୟାଁ ପୁଞ୍ଜିମାଞ୍ଜେରି, ସାମା ଈ କା଼ଲାତି ସିନାୟାଁ ଏ଼ନିଲେହେଁତାଇ ପୁଞ୍ଜି ହିଲଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ଏ଼ନାଆଁ କିନାୟିମାନେ ଇଞ୍ଜିଁ ମୀରୁ ଏ଼ନାଆଁତାକି ମୀ ବିତ୍ରା ନୀହାଁୟି କିହିହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଇଚିହିଁ ମୀ ଗଡ଼୍‌ହା ଆ଼ତାଣି ତଲେ ନୀହାଁୟି କିନାଣି ତା଼ଣା ହାନିବେ଼ଲାତା ଜିରୁତେଏ କାଲ୍‌ୱିଆ଼ନି ଊପେୟି ଅଣ୍‌ପାମୁ, ଏଲାଆ଼ଆତିହିଁ ଏ଼ୱାସି ନିଙ୍ଗେ ଅ଼ଡ଼େ ୱେଣ୍ତେ ନୀହାଁୟି କିନାଣି ତା଼ଣା ରେଜା ଅୟାନେସି, ଅ଼ଡ଼େ ନୀହାଁୟି କିନାସି କ଼ସ୍‌କା କେୟୁତା ହେର୍‌ପାନେସି, ଅ଼ଡ଼େ କ଼ସ୍‌କା ନିଙ୍ଗେ କା଼ୟିଦି ଇଲୁତା ଇଟାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ମୀରୁ ର଼ କା଼ନି ଜିକେଏ ପିହ୍‌ଆନାହା ହୀତିହିଁଦେଁ ଏମ୍ବାଟି ହ଼ଚା ୱା଼ହାଲି ଆ଼ଡିଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଏଚିବେ଼ଲାତା ଏଚେକା ଲ଼କୁ ୱା଼ହାନା, ପିଲାତ ଏମିନି ଗାଲିଲି ଲ଼କୁତି ନେତେରି ଏ଼ୱାରି ପୂଜା ତଲେ ଆଟ୍‌ହାମାଚେସି, ଏ଼ କାତା ଜୀସୁଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଗାଲିଲିତାରି ଡଣ୍ତ ବେଟାଆ଼ହାଲିଏ ଏ଼ୱାରି ଅ଼ର ଗାଲିଲିତାରି କିହାଁ ହା଼ରେକା ପା଼ପୁ ଗାଟାରି ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏଲେକିଁ ଆ଼ଏ, ସାମା ମୀରୁ ମ଼ନ ୱେଟ୍‌ଆତିହିଁ ବାରେଜା଼ଣା ତେରି ଏ଼ୱାରିଲେହେଁ ହା଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ସିଲହତା ଆମିନି ଅଟର ଜା଼ଣାତି ଲାକ ପାଡାଆ଼ତି କ଼ଟା ଇଲୁ ରିହାନା ହା଼ତେରି, ଏ଼ୱାରି ବାରେଜା଼ଣା ଜିରୁସାଲମତି ଲ଼କୁ କିହାଁ ହା଼ରେକା ପା଼ପୁ ଗାଟାରି ଇଞ୍ଜିଁ ମୀରୁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏଲେକିଁ ଆ଼ଏ, ମୀରୁ ମ଼ନ ୱେଟ୍‌ଆତିହିଁ ବାରେଜା଼ଣା ତେରି ଏଲେକିହିଁଏ ନା଼ସା ଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଜୀସୁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ରଅଣି ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା ର଼ ତ଼ୟା ମା଼ର୍‌ନୁ ଉହି ଆ଼ହାମାଚେ । ଏ଼ୱାସି ୱା଼ହାନା ପା଼ଡ଼େୟି ପାରୀତେସି ସାମା ମେଡ଼ାଆ଼ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାସି କାମା କିନାଣାଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ମୁ ନା଼ନୁ ତୀନି ବାର୍ସା ଆ଼ତେୟିଏ ଈ ତ଼ୟା ମା଼ର୍‌ନୁତା ୱା଼ହାନା ପା଼ଡ଼େୟି ପାରିମାଇଁ, ସାମା ମେ଼ଡ଼ା ଆ଼ହି ହିଲଅଁ; ଏ଼ଦାଣି ଟୂଣ୍‌ହା ତୁହ୍‌ମୁ, ଈଦି ଏ଼ନାଆଁତାକି ବୂମିତି ପା଼ଡ଼ିୟା କିନେ ?” ");
INSERT INTO kxv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ସାମା କାମାକିନାସି ଏଲେଇଚେସି, “ପ୍ରବୁ ଈଦି ଇୟନା ତାକି ମାଣ୍‌ମ୍ବେ, ନା଼ନୁ ଈଦାଣି ସା଼ରିସୁଟୁ କା଼ର୍‌ହାନା ଗାତା ହୀଇଁ, ");
INSERT INTO kxv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ଅ଼ଡ଼େ ଡା଼ୟୁ ପା଼ଡ଼େୟି ଆ଼ୟିତିହିଁ ନେହେଁ ଆ଼ୟାଆତିହିଁ ଏ଼ଦାଣି ଟୂଣ୍‌ହା ତୁହ୍‌ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ର଼ ଦିନା ଜୀସୁ ଜ଼ମିନି ଦିନା ର଼ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଜା଼ପ୍‌ହି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଏମ୍ବାଆଁ ର଼ ଇୟା ମାଚେ, ଏ଼ଦି ଅଟର ବାର୍ସା ପାତେକା ପ଼ଲ୍‌ଆ ବୂତୁ ତଲେ କସ୍ତ ଆ଼ହିମାଚେ, ଏ଼ଦି ଟୁଡୁୱା ଆ଼ହାନା ସଲ୍‌କେ ଆ଼ହିଁ ତା଼କାଲି ଆ଼ଡିହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜୀସୁ ଏ଼ଦାନି ମେସାନା ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “ଏ଼ ଇୟା ନୀନୁ ନୀ ଆ଼ଡାଆ କସ୍ତଟି ନେହିଁ ଆ଼ତି ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ଦାନିଲେକ କେୟୁ ଇଟିତେସି, ଏମ୍ବାଟିଏ ଏ଼ଦି ଏ଼ ଦେବୁଣିଏ ସଲ୍‌କେ ଆ଼ହାନା ମାହାପୂରୁତି ଜହରା କିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ସାମା ଜୀସୁ ଜ଼ମିନି ଦିନାତା ନେହିଁ କିହିମାଚାକି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାସି କାର୍‌ବି ଆ଼ହାନା ଲ଼କୁଣି ଏଲେଇଚେସି, “କାମା କିହାଲି ସ଼ ଦିନା ମିଙ୍ଗେ ମାନେ; ଏ଼ଦାଣିତାକି ସ଼ ଦିନା ନେହିଁ ଆ଼ହାଲି ୱା଼ଦୁ, ଜ଼ମିନି ଦିନାତା ୱା଼ଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ସାମା ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ କୁଟୁ ଗାଟାତେରି, ମୀରୁ ବାରେଜା଼ଣା ତେରି ଜ଼ମିନି ଦିନାତା ମୀ କ଼ଡି କି ଗା଼ଡ଼୍‌ଦେତି ହାଃଅଲାଟି ଅ଼ହାନା ଏ଼ୟୁ ଊଟ୍‌ହି ହିଲଅତେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ଅଟର ବାର୍ସା ପାତେକା ସୟତାନ ତା଼ଣାଟି ଦସ୍‌ପି ଆ଼ହାମାନି ଅବ୍ରାହାମ କୂଡ଼ାତି ଈ ଇୟାନି ଜ଼ମିନି ଦିନାତା ନେହିଁକିନାୟି ହିଲାଆତେ କି ?” ");
INSERT INTO kxv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଏ଼ୱାସି ଈ ବାରେ କାତା ୱେସାଲିଏ, ତାନି ସାତ୍ରୁୟାଁ ବାରେ ଲାଜା ବେଟାଆ଼ତେରି, ସାମା ଜୀସୁ କିହାମାନି କାମା ମେସାନା ଲ଼କୁ ରା଼ହାଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଜୀସୁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ରା଼ଜି ଏ଼ନିଲେହେଁତାୟି ? ଆମ୍ବାରିତଲେ ଏ଼ଦାନି ତୂକ୍‌ଇଁ ? ");
INSERT INTO kxv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ଏ଼ଦି ଇଲେତି ର଼ ହାର୍ସୁ ପା଼ଡ଼େୟି ଲେହେଁ, ଏ଼ଦାଆଁ ଅ଼ହାନା ରଅସି ତାନି ବା଼ଡ଼ାତା ମାଟିତେସି, ଅ଼ଡ଼େ ଏ଼ଦି ପାଡାଆ଼ହାନା ର଼ ମା଼ର୍‌ନୁ ଆ଼ତେ, ଅ଼ଡ଼େ ହା଼ଗୁ ଲାକ ଊମ୍ବିନି ପଟାୟାଁ ୱା଼ହାନା ଏ଼ କମାତା ବାସା କିତୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜୀସୁ ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମ୍ବାରିତଲେ ମାହାପୂରୁତି ରା଼ଜି ତୂକ୍‌ଇଁ ? ");
INSERT INTO kxv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ଏ଼ଦି ପୁଲା ଏ଼ୟୁଲେହେଁତାୟି, ର଼ ଇୟା ତୀନିମା଼ଣା ଗୁଣ୍ତାତା କାଲ୍‌ହା ଇଟିତେ, ଡା଼ୟୁ ବାରେ ଗୁଣ୍ତା ପୁଲା ଆ଼ତେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଡା଼ୟୁ ଜୀସୁ ଗା଼ଡ଼ାତାକି ଗା଼ଡ଼ା ନା଼ୟୁଁ ତାକି ନା଼ୟୁଁ ରେ଼ଜିହିଁ ଜା଼ପ୍‌ହିହିଁ ଜିରୁସାଲମ ୱାକି ହାଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ରଅସି ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ପ୍ରବୁ ଗେଲ୍‌ପି ଆ଼ନାରି ୱାର୍‌ଇ ଇଚରା ଜା଼ଣାକି ?” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ଜୀୱୁ ତୂସାନା ଜାକ୍‌ଣି ଦୁୱେରିଟି ହାଜୁ; ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ହା଼ରେକା ହ଼ଡାଲି ଅଣ୍‌ପିନେରି, ସାମା ହ଼ଡାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଇଲୁଗାଟାସି ନିଙ୍ଗାନା ଦା଼ରା ସୁଣ୍ତିତି ଡା଼ୟୁ ଏଚେ଼ତା ମୀରୁ ପାଙ୍ଗାତା ନିଚାନା ଦା଼ରା ଡୀ ଡୀ ୱେଚିହିଁ ‘ଏ଼ ପ୍ରବୁ ମାଙ୍ଗେତାକି ଦା଼ରା ଦେତାମୁ’ ଇଞ୍ଜିଁ ହା଼ଟିଦେରି, ଏଚେ଼ତା ଏ଼ୱାସି ମିଙ୍ଗେ ଏଲେଇଞ୍ଜାନେସି, ‘ମୀରୁ ଏମ୍ବିତାତେରି ନା଼ନୁ ପୁଞ୍ଜାମାଞ୍ଜଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ଏଚିବେ଼ଲା ମୀରୁ ଏଲେଇଞ୍ଜେରି, ‘ଏ଼ ପ୍ରବୁ ମା଼ମ୍ବୁ ନୀ ତଲେ ତିଚା ଉଟାତମି, ଅ଼ଡ଼େ ନୀନୁ ମା଼ ଆଂଗେଣିକାଣା ଜା଼ପ୍‌ହିମାଞ୍ଜାତି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଅ଼ଡ଼େ ଏ଼ୱାସି ମିଙ୍ଗେ ଏଲେଇଞ୍ଜାନେସି, ‘ମୀରୁ ଆମିନି ଟା଼ୟୁତି ଲ଼କୁତେରି ନା଼ନୁ ପୁଞ୍ଜାମାଞ୍ଜଅଁ; ଏ଼ ଲାଗେଏ ପ଼ଲେଏ ତାତେରି ନା଼ ତା଼ଣାଟି ହେକ ଆ଼ଦୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଏଚିବେ଼ଲା ମୀରୁ ଅବ୍ରାହାମ, ଇସାହାକ, ଜାକୁବ ଇଞ୍ଜାଁ ବାରେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ମାହାପୂରୁ ରା଼ଜିତା ମାନାଣି ଅ଼ଡ଼େ ମିଙ୍ଗେ ପାଙ୍ଗାତା କୁତା ମାଞ୍ଜାନାଣି ଅଣ୍‌ପାନା ପାଲ୍‌କା ଟୀଟି କିହିଁ ଡ଼ୀଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ୱେ଼ଡ଼ା ହ଼ପୁ ୱାକିଟି ଅ଼ଡ଼େ ୱେ଼ଡ଼ା କୂଡ଼୍‌ନି ୱାକିଟି, ଟିଃନି ୱାକିଟି ଟେ଼ବ୍ରି ୱାକିଟି ୱା଼ହାନା ମାହାପୂରୁତି ରା଼ଜିତି ବ଼ଜିତା କୁଗିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଡା଼ୟୁତା ମାନି କଚେକା ନ଼କିତା ଆ଼ନେରି ଅ଼ଡ଼େ ନ଼କିତା ମାନି କଚେକା ଡା଼ୟୁତା ଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ଏଚିବେ଼ଲାତେଏ ଏଚରଜା଼ଣା ପାରୁସିୟାଁ ୱା଼ହାନା ଜୀସୁଇଁ ୱେସ୍ତେରି, “ନୀନୁ ଈ ଟା଼ୟୁ ପିସାନା ହାଜାତୁହ୍‌ମୁ ଏ଼ନାଆଁତାକି ଇଚିହିଁ ହେରଦ ନିଙ୍ଗେ ପା଼ୟାଲି ଅଣ୍‌ପିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ହାଜାନା ଏ଼ ନାକାଇଁ ୱେହ୍‌ଦୁ, ‘ମେହ୍‌ମୁ ନା଼ନୁ ନୀଞ୍ଜୁ ଅ଼ଡ଼େ ୱିଏ ବୂତୁୟାଁ ପିସ୍‌ପି କିହିମାଇଁ ଅ଼ଡ଼େ ନେହିଁ କିହିମାଇଁ ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ନା଼ କାମା ରା଼ପ୍‌ଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ଏ଼ନିଜିକେଏ ନୀଞ୍ଜୁ ୱିଏ ଅ଼ଡ଼େ ମାଏଁ ନାଙ୍ଗେ ତା଼କିହିଁ ହାଜାଲି ଆ଼ନେ, ଇଚିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଜିରୁସାଲମ ପିସ୍‌ପେ ପାଙ୍ଗାତା ହାନାୟି ନେହେଁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ଏ଼ ଜିରୁସାଲମ, ଏ଼ ଜିରୁସାଲମ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ପା଼ୟିନାତି ଅ଼ଡ଼େ ନୀ ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ୱାଲ୍‌କାତଲେ ୱେନାତି, ତାଲି କୟୁ ଏ଼ନିକିଁ ତାନି ହୀପାୟାଁଣି ତାନି ମା଼ରାୟାଁ ଡ଼଼ଇ ଜ଼ଙ୍ଗିନେ, ଏଲେକିଁ ଏଚର ଦେବା ନୀ ପ଼ଦି ପ଼ଦାତି ପ୍ଡିକ୍‌ହାନା ଇଟିଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେଏଁ ସାମା ମୀରୁ ଏଲେକିହାଲି ହିୟାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ମେହ୍‌ଦୁ ମୀ ଇଲୁ ମୀ କେୟୁତା ହୀପ୍‌କି ଆ଼ହିମାଞ୍ଜାନେ; ଅ଼ଡ଼େ ନା଼ନୁ ମିଙ୍ଗେ ଏଲେଇଞ୍ଜିମାଞ୍ଜାଇଁ ମାହାପୂରୁ ଦ଼ରୁଟି ଆମ୍ବାଆସି ୱା଼ହିମାନେସି ଏ଼ୱାସି ନେହାଁସି ଇଞ୍ଜିଁ ଏମିନି ନେ଼ଚୁ ଈ କାତା ଏଲେଇଞ୍ଜେରି ଏ଼ ଦିନା ୱା଼ଆ ପାତେକା ମୀରୁ ଅ଼ଡ଼େ ନାଙ୍ଗେ ମେସ୍ତଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ଜୀସୁ ର଼ ଜ଼ମିନି ଦିନା ରା଼ନ୍ଦା ତିଞ୍ଜାଲି ପାରୁସିୟାଁ ବିତ୍ରାଟି ର଼ କାଜାଣି ଇଜ ହ଼ଡାଲିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଦ଼ହ ଦସାଲି ପ଼ର୍‌ହି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ ଏ଼ୱାଣି ନ଼କିତା କେସ୍କା କଡାୟାଁ ପଂଗିତାସି ରଅସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ଏମ୍ବାଟିଏ ଜୀସୁ ମ଼ସାତି ମେ଼ରାପୁନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁଇଁ ଏଲେଇଚେସି, “ଜ଼ମିନି ଦିନାତା ରଅଣାଇଁ ନେହିଁକିନି ମେ଼ରା ମାନେକି ଆ଼ଏ ?” ");
INSERT INTO kxv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା ପାଲେଏ ଆ଼ତେରି । ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଡୀଗାହାଁ ନେହିଁ କିହାନା ମୀ ଇଜ ହାଲାମୁ ଇଞ୍ଜିଁ ହେଲ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ମୀର୍‌ଏସି କି କ଼ଡି ଜ଼ମିନି ଦିନାତା କୁହିତା ରିତିହିଁ ଏ଼ ଦେବୁଣିଏ ଡ଼େୱା କଡଅସି କି ?” ");
INSERT INTO kxv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଅ଼ଡ଼େ ଏ଼ୱାରି ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ଏ଼ନାଆଁ ଜ଼ଲାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ବ଼ଜିତା ହା଼ଟ୍‌କି ଆ଼ହାମାଚାରି ନେହିଁ ନେହିଁ ଟା଼ୟୁତା କୁଗାଲି ବାଚି କିହିମାଚାଣି ମେସାନା, ଏ଼ୱାରାଇଁ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଏଚିବେ଼ଲା ରଅସି ମିଙ୍ଗେ ବୀହା ବ଼ଜିତା ହା଼ଟାନେସି, ଏମ୍ବାଆଁ ନେହିଁ ଟା଼ୟୁତା କୁଗାଆଦୁ, ଇଚିହିଁ ଏମ୍ବାଆଁ ନୀ କିହାଁ କାଜାସି ଜିକେଏ ହା଼ଟ୍‌କି ଆ଼ହାଡ଼ୟିନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଏଚେ଼ତା ନିଙ୍ଗେ ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ହା଼ଟା ମାନାସି, ଏ଼ୱାସି ୱା଼ହାନା ଈୱାଣାକି ଈ ଟା଼ୟୁ ପିସାହୀମୁ ଇଞ୍ଜାନେସି, ଏଚେ଼ତା ନୀନୁ ଲାଜାତଲେ ଊଣା ଟା଼ୟୁତା କୁଗିଦି । ");
INSERT INTO kxv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ସାମା ଏଚିବେ଼ଲା ନୀନୁ ହା଼ଟ୍‌କି ଆ଼ହାମାନି ତା଼ଣା ହାଜାନା ଡ଼଼ଇତି ଟା଼ୟୁତା କୁଗାମୁ, ଏଚେଟିଏ ନିଙ୍ଗେ ହା଼ଟି କିହାମାଞ୍ଜାନାସି, ଏ଼ ତ଼ଣେ ନୀନୁ ଈ ନେହିଁ ଟା଼ୟୁତା କୁଗାମୁ ଇଞ୍ଜିଁ ହା଼ଟାସାରେ ଏଚିବେ଼ଲା କୂଡ଼ା ଆ଼ହାମାନି ଲ଼କୁ ନ଼କିତା ଗାଡି ମା଼ନି ବେଟାଆ଼ଦି । ");
INSERT INTO kxv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଇଚିହିଁ ଆମ୍ବାଆସି ନା଼ନୁ କାଜାତେଏଁ ଇଞ୍ଜିଁ ଇଞ୍ଜାଁ କଡିନାଣାଇଁ ଊଣା କିୱିଆ଼ନେ, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ତାଙ୍ଗେ ଊଣା କିହାକଡିନେସି ଏ଼ୱାଣାଇଁ କାଜାସି କିୱିଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଇଞ୍ଜାଁ ଜୀସୁ ତାଙ୍ଗେ ହା଼ଟି କିହା ମାଚାଣାଇଁ ଜିକେଏ ଏଲେଇଚେସି, “ନୀନୁ ବ଼ଜି ହୀନାଟି ନୀ ତ଼ଣେସିଙ୍ଗାଣି, ତାୟିୟାଁ, ସାମ୍‌ନ୍ଦିୟାଁ କି ନୀ ନା଼ୟୁଁତା ମାନି ଦ଼ନ ଗାଟାରାଇଁ ହା଼ଟାଆନି, ଇଚିହିଁ ଏ଼ୱାରି ଜିକେଏ ନିଙ୍ଗେ ହା଼ଟାଲି ଆ଼ଡାନେରି ଅ଼ଡ଼େ ନୀନୁ ୱେଣ୍ତେ ବେଟାଆ଼ଦି । ");
INSERT INTO kxv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ସାମା ବ଼ଜି କିତିସାରେ ହିଲାଆ ଗାଟାରି, କଲାୟାଁ, ସଟାୟାଁ, କା଼ଣାୟାଁଣି ହା଼ଟାମୁ; ଆତିହିଁ ନୀନୁ ନେହାଁତି ଆ଼ଦି, ");
INSERT INTO kxv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ଆତିହିଁ ନିଙ୍ଗେତାକି ନେହେଁ, ଇଚିହିଁ ନିଙ୍ଗେ ୱେଣ୍ତେ ହୀହାଲି ଏ଼ୱାରିତା଼ଣା ଏ଼ନାୟି ହିଲେଏ; ଇଞ୍ଜାଁ ତୀରିଗାଟାରି ୱେଣ୍ତେ ନିଙ୍ଗିନାଟି ମାହାପୂରୁ ନିଙ୍ଗେ ୱେଣ୍ତେ ହିୟାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଈ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାଣିତଲେ ତିଞ୍ଜାଲି କୁଗାମାଚାରି ବିତ୍ରାଟି ରଅସି ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଆମିନିଗାଟାସି ମାହାପୂରୁ ରା଼ଜିତା ବ଼ଜି ତିନାସି ଏ଼ୱାସି ନେହାଁସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ରଅସି ର଼ କାଜା ବ଼ଜି ଲ଼କୁକି ହୀଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ହା଼ରେକା ଲ଼କୁଇଁ ହା଼ଟିତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଅ଼ଡ଼େ ତିନି କାଟୁ ଆୟାଲିଏ, ଏ଼ୱାସି ହା଼ଟାମାନି ଲ଼କୁତା଼ଣା ତାନି ହ଼ଲେଏଣାଇଁ ପାଣ୍ତାନା ଏଲେଇଚେସି, ‘ବାରେ ଆ଼ତେୟିଏ ନୀଏଟି ମୀରୁ ତିଞ୍ଜାଲି ୱା଼ଦୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ସାମା ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ ରଣ୍ତିଏ କାତା ଏଲେଇଚେରି, ରଅସି ୱେସ୍ତେସି, ‘ନା଼ନୁ ଇଚାଣି ବୂମି କଡାମାଇଁ ଏ଼ଦାଆଁ ସିନିକିହାଲି ହାନାୟିମାନେ; ଏ଼ଦାଆଁତାକି ନାଙ୍ଗେ କାର୍ମା ଅଣ୍‌ପାମୁ ନା଼ନୁ ୱା଼ହାଲି ଆ଼ଡଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଅ଼ଡ଼େ ରଅସି ଏଲେଇଚେସି, ‘ନା଼ନୁ ପା଼ସା ହେ଼ରୁ କ଼ଡିୟାଁ କଡାମାଇଁ, ନା଼ନୁ ଏ଼ୱାସିକାଣି ମା଼ତ୍‌ନାୟି ମାନେ ଏ଼ଦାଣିତାକି ନାଙ୍ଗେ କାର୍ମା ଅଣ୍‌ପାମୁ ନା଼ନୁ ୱା଼ହାଲି ଆ଼ଡଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ଅ଼ଡ଼େ ରଅସି ଏଲେଇଚେସି, ‘ନା଼ନୁ ନୀଞ୍ଜୁ ବୀହା ଆ଼ହାମାଇଁ ଏ଼ଦାଆଁତାକି ନା଼ନୁ ୱା଼ହାଲି ଆ଼ଡଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ଇଞ୍ଜାଁ ଏ଼ ହ଼ଲେଏସି ୱା଼ହାନା ବାରେ ତାନି ସା଼ୱୁକାରିଇଁ ୱେସ୍ତେସି । ଏଚେଟିଏ ଏ଼ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାସି କାର୍‌ବି ଆ଼ହାନା ତାନି ହ଼ଲେଏଣାଇଁ ଏଲେଇଚେସି, ନୀନୁ ତବେ ଗା଼ଡ଼ାତି ସାହ୍‌ଡ଼ାୟାଁ ଅ଼ଡ଼େ ଡାଣ୍ତେଣାଁ ହାଜାନା ହିଲାଆଗାଟାରାଇଁ, କଲାୟାଇଁ, ସଟାୟାଁଇଁ ଇଞ୍ଜାଁ କା଼ଣାୟାଁଇଁ ଇମ୍ବାଆଁ ହା଼ଟାତାମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ଡା଼ୟୁ ଏ଼ ହ଼ଲେଏସି ଏଲେଇଚେସି, ‘ଏ଼ ପ୍ରବୁ ନୀ କାତାତଲେ ବାରେ କିତମି ସାମା ଇଲୁ ନେଞ୍ଜା ହିଲେଏ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ଏମ୍ବାଟିଏ ସା଼ୱୁକାରି ହ଼ଲେଏଣାଇଁ ଟା଼ଣ୍ତିତେସି, ‘କାଜା ଆଂଗେଣି ଅ଼ଡ଼େ ମା଼ର୍‌ନୁ ଡ଼଼ଇ ହାଜାନା ନା଼ ଇଲୁ ଏ଼ନିକିଁ ନେଞ୍ଜିନେ ଏ଼ଦାଆଁତାକି ଲ଼କୁଣି ୱା଼ହାଲି ଏଲେଇନାମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ନା଼ନୁ ୱେସିମାଞ୍ଜାଇଁ ତଲି ହା଼ଟାମାଚାରି ବିତ୍ରାଟି ରଅସି ଜିକେଏ ନା଼ ବ଼ଜି ୱାଣ୍ତାଲି ବେଟାଆ଼ଅସି ।’” ");
INSERT INTO kxv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ମାନ୍ଦା ଲ଼କୁ ଜୀସୁତଲେ ହାଜିମାଚେରି, ଏ଼ୱାସି ଡା଼ୟୁୱାକି ସିନିକିହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ୱା଼ହାନା ତାନି ତାଲି, ତାଞ୍ଜି, ଡକ୍ରି, ମୀର୍‌କା, ମା଼ସ୍‌କା, ତାୟି ତାଙ୍ଗିସ୍କାଣି ଅ଼ଡ଼େ ତାନି ଜୀୱୁତି ଜିକେଏ ଅ଼ପଅସି ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଆମ୍ବାଆସି ତାନି କ୍ରୁସ ଡେ଼କାନା ନା଼ ଜେ଼ଚ ଜେ଼ଚ ୱା଼ଅସି, ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ପାଡିକିହିଁ କ଼ଟା ଇଲୁ ଦସାଲି ଅଣ୍‌ପିନେସି, ଦହ୍‌ନି କାମା ରା଼ପ୍‌ହାଲି ଟାକାୟାଁ ଏନୁ କି ଏଉ ଇଞ୍ଜିହିଁ ଏମ୍ବାତି ଲେକା କିଅସିକି ? ");
INSERT INTO kxv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ଏଚେ଼ତା ଏ଼ୱାସି ପୁନାଦି ନିପ୍‌ହାନା ରା଼ପ୍‌ହାଲି ଆ଼ଡାଆସାରେ, ଏଚେକା ଲ଼କୁ ଏ଼ଦାଆଁ ମେହ୍‌ନେରି, ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ କାକ୍‌ନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଲାଜାକିହିଁ ଏଲେଇନେରି, ଈୱାସି ଇଲୁ ଦସାଲି ମା଼ଟ୍‌ହେସି ରା଼ପ୍‌ହାଲି ଆ଼ଡାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ର଼ ରାଜା ଅ଼ର ରାଜା କ଼ପାଟି ଜୁଜୁ କିହାଲି ହାଜିମାନାଟି ଦସ ମା଼ଣା କ଼ସ୍‌କା ଏ଼ୱାଣି କଡ଼େ ମା଼ଣା କ଼ସ୍‌କା କ଼ପାଟି ଜୁଜୁ କିହାଲି ଆ଼ଡିନେରିକି ଆ଼ଏ ଇଞ୍ଜିଁ ଅଣ୍‌ପଅସିକି ? ");
INSERT INTO kxv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଆ଼ଡାଆଲେହେଁ ଇଚିହିଁ ଏ଼ ରାଜା ହେକ ମାନାଟିଏ ଏ଼ୱାସି ରା଼ଜିମା଼ନା ଆୟାଲି କ଼ସ୍‌କାଣି ହିତ୍‌ଡ଼ି ତାକି ଏଲେଇଞ୍ଜା ପାଣ୍ତିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ଏଲେକିହିଁଏ ମୀ ବିତ୍ରାଟି ଜିକେଏ ଆମ୍ବାଆସି ତାନି ବାରେ ପିହ୍‌ଆତିହିଁ ଏ଼ୱାସି ନା଼ ସୀସୁ ଆୟାଲି ଆ଼ଡଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ହା଼ରୁତ ନେହାୟି; ସାମା ହା଼ରୁ ମୂଆସାରେ ଏ଼ଦାଆଁ ଏ଼ନିକିଁ ଅ଼ଡ଼େ ଏ଼ନାଆଁତଲେ ହା଼ରୁ ଲେହେଁ ମୂପି କିନାୟି ? ");
INSERT INTO kxv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ଏ଼ଦି ବୂମିତା କି ଗାତା କ଼ଟୁତା କୁତୁସାଲି ଜିକେଏ ଜ଼ଗେ ଆ଼ଏ । ଲ଼କୁ ଏ଼ଦାନି ପାଙ୍ଗାତା କୁତା ତୁହ୍‌ନେରି । ଆମ୍ବାଆରି ୱେଞ୍ଜାଲି କୀର୍କା ମାଚିହିଁ, ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ର଼ ଦିନା ସିସ୍ତୁ ରୀହ୍‌ନାରି ଅ଼ଡ଼େ ପା଼ପୁ ଗାଟାରି ବାରେଜା଼ଣା ତାନି କାତା ୱେଞ୍ଜାଲି ୱା଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ଏଚେଟିଏ ପାରୁସିୟାଁ ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଜୀସୁଇଁ ଗୁରୁମୁରୁ ଆ଼ହିଁ ଏଲେଇଚେରି, “ଈୱାସି ପା଼ପୁ ଗାଟାରାଇଁ ଆବିମାନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରିତଲେ ତିଞ୍ଜି ଉଣ୍ତି ମାନେସି !” ");
INSERT INTO kxv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆତେରି ଇଲେତି ଲ଼କୁ ମାଞ୍ଜେରି, ଏ଼ୱାଣାକି ପା଼ସାକ଼ଡ଼ି ମେ଼ଣ୍ତାୟାଁ ମାଚିହିଁ, ଏ଼ୱାସିକା ବିତ୍ରାଟି ରଣ୍ତି ଜା଼ଙ୍ଗିତିହିଁ ଏ଼ୱାସି ଏ଼ନାଆଁ କିନେସି, ରଣ୍ତି ଊଣା ପା଼ସାକ଼ଡ଼ି ମେ଼ଣ୍ତାୟାଁ ବାଟାତା ପିସାନା ଜା଼ଙ୍ଗାମାନି ମେ଼ଣ୍ତା ପା଼ଣ୍‌ନି ପାତେକା ପାରଅସି କି ? ");
INSERT INTO kxv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଇଞ୍ଜାଁ ବେଟାଆ଼ତିସାରେ ରା଼ହାଁତଲେ ଡେ଼କାନା ଇଜ ତାନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଇଞ୍ଜାଁ ତାନି ତ଼ଣେସିଙ୍ଗାଣି ଅ଼ଡ଼େ ନା଼ୟୁଁତାରାଇଁ ହା଼ଟାନା ଏଲେଇନେସି, ମୀରୁ ନା଼ ତଲେ ରା଼ହାଁ କିଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଜା଼ଙ୍ଗାମାଚି ନା଼ ମେ଼ଣ୍ତା ବେଟାଆ଼ତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏଲେକିହିଁଏ ମ଼ନ ୱେଟ୍‌ହାଲି ଲ଼ଡ଼ା ଆ଼ଆଗାଟି ରଅସି ଊଣା ପା଼ସାକ଼ଡ଼ି ତୀରିଗାଟାରି କିହାଁ ପା଼ପୁ ଗାଟାସି ରଅସି ତାନି ମ଼ନ ୱେଟ୍‌ହା କଡିତିହିଁ, ଏ଼ୱାଣି କ଼ସମି ଲାକପୂରୁ ହା଼ରେକା ରା଼ହାଁ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ଅ଼ଡ଼େ ଇଲେତି ଆମିନି ଇୟା ମାନେ, ଏ଼ ଇୟାନାକି ଦସଗଟା ୱେଣ୍ତି ଟାକା ମାଚିହିଁ ରଣ୍ତାଆଁ ଜା଼କ୍‌ହିହିଁ ଏ଼ଦି ଏ଼ନାଆଁ କିନେ, ଦୀୱଁ ଡ଼଼ସାନା ଇଲୁ ହେ଼ପାନା ଏ଼ ଜା଼କ୍‌ହି ଟାକା ପା଼ଣ୍‌ନି ପାତେକା ଜାତ୍‌ନୁ ତଲେ ପାରେଏକି ? ");
INSERT INTO kxv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଇଞ୍ଜାହାଁ ଏ଼ ଟାକା ବେଟାଆ଼ତିସାରେ ଏ଼ଦି ତାନି ତ଼ଡ଼ୁ ଲ଼କୁଣି ଇଞ୍ଜାଁ ନା଼ସ୍‌କାତି ଲ଼କୁଣି ରୁଣ୍ତି କିହାନା ଏଲେଇନେ ନା଼ ତଲେ ରା଼ହାଁ କିଦୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଜା଼କ୍‌ହାମାଚି ଟାକା ବେଟାଆ଼ତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ଏଲେକିହିଁ ଆମ୍ବାଆସି ମ଼ନ ୱେଟ୍‌ନେସି, ଇଲେତି ପା଼ପୁ ଗାଟାରାକି ମାହାପୂରୁତି ଦୂତୁୟାଁ ନ଼କିତା ରା଼ହାଁ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜୀସୁ ଅ଼ଡ଼େ ଏଲେଇଚେସି, ରଅଣାକି ରିଆରି ମୀର୍‌କା ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ଏ଼ୱାରି ବିତ୍ରାଟି ଊଣା ମୀର୍‌ଏସି ଆ଼ବାଇଁ ଏଲେଇଚେସି, ଆ଼ବା ଇଲୁତି ଦ଼ନ ବା଼ଟି କିହାନା ନାଙ୍ଗେ ଆୟାନି ବା଼ଗା ହିୟାମୁ । ଏଚେଟିଏ ତାମି ଆ଼ବା ତାନି ଦ଼ନ ବା଼ଟି କିହାନା ରୀ ମୀର୍‌କାକି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଏମ୍ବାଟିଏ ଏଚରଦିନା ହାଜାଲିଏ ଈଚି ମୀର୍‌ଏସି ଇଲୁ ବା଼ଗା ହୀହାମାଚାଣି ପାର୍‌ଚାହାଁ ଟାକାୟାଁ ଆସାହାଁ ହେକରା଼ଜି ହାଜାତୁସ୍ତେସି, ଇଞ୍ଜାଁ ଲେନିପନିଏ ଡା଼ୟୁ ଏ଼ସ୍‌କି ଅଣ୍‌ପାଆନା ଲାଗେଏତି କାମାତା ତାନି ଦ଼ନ ରା଼ପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ସାମା ବାରେ ଦ଼ନ ରା଼ପ୍‌ହି ଜେ଼ଚ ଏ଼ ଦେ଼ସାତା କାର୍‌ୱୁ କା଼ତାରା ଆ଼ହାଲିଏ ଏ଼ୱାସି କା଼କୁଲି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ଏଚେଟିଏ ଏ଼ୱାସି ହାଜାନା ଏ଼ ଦେ଼ସାତି ର଼ ସା଼ୱୁକାରି ତା଼ଣା ଗତି ଡ଼ୟିତେସି, ଏ଼ୱାସି ଏ଼ୱାଣାକି ପାଜିୟାଁ ମେଚାଲି ଗୁଡିୟାତା ପାଣ୍ତିତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଇଞ୍ଜାଁ ପାଜିୟାଁ ଆମିନି କା଼ଙ୍ଗା ସା଼ଲିୟାଁ ତିଞ୍ଜି ମାଚୁ, ଏ଼ୱାଆଁ ତିଞ୍ଜାଲି ମ଼ନ କିତେସି, ସାମା ଆମ୍ବାଆରି ଏ଼ୱାଣାକି ତିଞ୍ଜାଲି ହୀହି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ର଼ ଦିନା ତୀର୍‌ପୁ ଆ଼ହାନା ଅଣ୍‌ପିତେସି, ମା଼ ଆ଼ବା ତା଼ଣାତି ଗତି ବୁତି ତିନି ରା଼ନ୍ଦେଏ ହା଼ରା ହାଜିମାନେ, ସାମା ନା଼ନୁ ଇମ୍ବାଆଁ ହାକି ତାକି ହା଼ହିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ନା଼ନୁ ନିଙ୍ଗାନା ମା଼ ଆ଼ବା ତା଼ଣା ହାଇଁ ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ୱେହ୍‌ଇଁ, “ଲାକପୂରୁତି ଆ଼ବା କ଼ପାଟି ଅ଼ଡ଼େ ନୀ ନ଼କିତା ନା଼ନୁ ପା଼ପୁ କିତେଏଁ; ");
INSERT INTO kxv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ନୀ ମୀର୍‌ଏଣାତେଏଁ ଇଞ୍ଜିଁ ନା଼ନୁ ଅ଼ଡ଼େ ପା଼ଡ଼ା ଆ଼ଅଁ; ନାଙ୍ଗେ ର଼ ହ଼ଲେଏଣା ଲେହେଁ ଇଟାମୁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନିଙ୍ଗାନା ତାମି ଆ଼ବା ୱାକି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ସାମା ଆ଼ବା ତାନି ମୀର୍‌ଏଣା ୱା଼ହିମାନାଣି ହେକଟିଏ ମେସାନା କାର୍ମା ଆ଼ହାନା ହଟି ହଟିହିଁ ହାଜାନା ପମାହାଁ ନଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ଏମ୍ବାଟିଏ ମୀର୍‌ଏ ଗାଟାସି ଏଲେଇଚେସି, “ଲାକପୂରୁ ଆ଼ବା କ଼ପାଟି ଅ଼ଡ଼େ ନୀ ନ଼କିତା ନା଼ନୁ ପା଼ପୁ କିତେଏଁ, ନୀ ମୀର୍‌ଏଣାତେଏଁ ଆୟାଲି ପା଼ଡ଼ା ଆ଼ଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ସାମା ଆ଼ବା ତାନି ହ଼ଲିୟାଙ୍ଗାଣି ଏଲେଇଚେସି, “ଅ଼ଜିତି ହିମ୍ବରି ତବେ ତାଚାନା ଈୱାଣାଇଁ ହୁଚି କିଦୁ, ଈୱାଣି କେୟୁତା ମୁଦି ଅ଼ଡ଼େ କଡାୟାଁଣା ସେପୁୟାଁ ତୁର୍‌ୱି କିଦୁ, ");
INSERT INTO kxv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଇଞ୍ଜାହାଁ ଆଙ୍ଗା ଆ଼ତି କ଼ଡି ଡା଼ଲୁ ତାକା ହାଜାନା ପା଼ୟାଦୁ; ମା଼ର ତିଞ୍ଜା ଉଣ୍ତାନା ରା଼ହାଁ କିନ, ");
INSERT INTO kxv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ଇଚିହିଁ ନା଼ ମୀର୍‌ଏସି ହା଼ହା ହାଜାମାଚେସି, ୱେଣ୍ତେ ନୀଡାମାନେସି; ଜା଼ଙ୍ଗା ହାଜାମାଚେସି ଅ଼ଡ଼େ ମେ଼ଡ଼ା ଆୟାତେସି ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ରା଼ହାଁ କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ଏଚିବେ଼ଲାତା କାଜା ମୀର୍‌ଏସି ଗୁଡିୟାତା ମାଚେସି, ଏ଼ୱାସି କାମା କିହାଁ ଇଲୁ ଡାଗେ ୱାୟାଲିଏ, ତାମି ଇଜ ବା଼ଜାଗା଼ଜା ଅ଼ଡ଼େ ରା଼ହାଁ କିହିମାନି ହା଼ଲି ୱେଞ୍ଜାନା, ");
INSERT INTO kxv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ର଼ ହ଼ଲେଏଣାଇଁ ହା଼ଟାନା ୱେଚେସି, “ମାଜ ଏ଼ନାଆଁ କିହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ ଊଣା ତାୟି ୱେଣ୍ତା ୱା଼ହାମାନେସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ନେହିଁ ଆଙ୍ଗା ତଲେ ୱେଣ୍ତା ୱା଼ତାଣି ମେସାନା ମୀ ଆ଼ବା ଆଙ୍ଗା ଆ଼ତି କ଼ଡି ପା଼ୟାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ଏମ୍ବାଟିଏ କାଜା ତାୟି କାର୍‌ବି ଆ଼ହାନା ଇଜ ହାଲାଆତେସି; ସାମା ତାମି ଆ଼ବା ପାଙ୍ଗାତା ୱା଼ହାନା ଏ଼ୱାଣାଇଁ କା଼ହିବା କ଼ପା ଆ଼ଆନି ଇଜ ୱା଼ମୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାମି ଆ଼ବାଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ମୁ ନା଼ନୁ ଇଚର ବାର୍ସା ଆ଼ତେ ନୀ ହ଼ଲେଏଣା ଲେହେଁ କାମା କିହିମାଇଁ, ଏଚେଲା ଜିକେଏ ନୀ ହୁକୁମି ଊରାହିଲଅଁ, ଆ଼ତିଜିକେଏ ନା଼ ତ଼ଣେସିଙ୍ଗା ତଲେ ବ଼ଜି କିହାଲି ନୀନୁ ନାଙ୍ଗେ ର଼ ଗରି ଡା଼ଲୁ ଜିକେଏ ହୀହାମାଞ୍ଜଅତି; ");
INSERT INTO kxv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ସାମା ଈ ନୀ ମୀର୍‌ଏସି ଇଲୁତି ବାରେ ଦ଼ନ ଅ଼ହାନା ସାନେଣିସ୍କାତଲେ ମାଞ୍ଜାନା ବାରେ ରା଼ପ୍‌ହେସି, ଏଚେ଼ତା ଈୱାସି ୱେଣ୍ତାୱା଼ତେସି, ଏଚେ଼ତା ଏ଼ୱାଣାକି ଆଙ୍ଗା ଆ଼ତି କ଼ଡି ପା଼ୟାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ଏଚେଟିଏ ତାଞ୍ଜି ଗାଟାସି ଏଲେଇଚେସି, “ମୀର୍‌ଏଣା ନୀନୁତ କା଼ଲେଏ ନା଼ ତଲେ ମାଞ୍ଜାମାଞ୍ଜି, ଅ଼ଡ଼େ ଏ଼ନା ଏ଼ନାୟି ନା଼ଦି ଏ଼ ବାରେତ ନୀଦି; ");
INSERT INTO kxv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ସାମା ଈ ନୀ ତାୟି ହା଼ହା ହାଜାମାଚେସି, ୱେଣ୍ତେ ନୀଡାମାନେସି, ଜା଼ଙ୍ଗା ହାଜାମାଚେସି, ମେ଼ଡ଼ା ଆୟାତେସି, ଏ଼ଦାଆଁତାକି ରା଼ହାଁ କିନାୟି ମାଚେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ର଼ ଦ଼ନଗାଟାସି ମାଚେସି; ଏ଼ୱାଣାକି ର଼ ଗୁମୁସ୍ତା ମାଚେସି, ଏ଼ୱାସି ତାନି ଦ଼ନତି ଆଲାରା କିହାମାନାଣି ପୁଞ୍ଜାନା, ");
INSERT INTO kxv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ହା଼ଟାନା ଏଲେଇଚେସି, ‘ନା଼ନୁ ନୀ କାତା ୱେଚେଏଁ ନୀନୁ ନୀ ଗୁମୁସ୍ତା କାମା ଏ଼ନି କିହିମାଞ୍ଜି ଲେକା ତ଼ସ୍ତାମୁ, ଇଚିହିଁ ନୀନୁ ଅ଼ଡ଼େ ଗୁମୁସ୍ତା ଆ଼ହା ମାଞ୍ଜାଲି ଆ଼ଡଅତି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ଏମ୍ବାଟିଏ ଏ଼ ଗୁମୁସ୍ତା ଅଣ୍‌ପା କଡିତେସି, ‘ନା଼ ସା଼ୱୁକାରି ନା଼ ଗୁମୁସ୍ତା କାମା ପିସ୍‌ପି କିହିମାଞ୍ଜାନେସି, ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ? ଇର୍‌ଆ କା଼ର୍‌ହାଲି ନାଙ୍ଗେ ବପୁ ହିଲେଏ, ଅ଼ଡ଼େ ରୀସ୍‌ପା ତିଞ୍ଜାଲି ଲାଜା ହ଼ଚି ମାଞ୍ଜାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ନୀଏଁ ପୁଚେଏଁ, ନାଙ୍ଗେ ଗୁମୁସ୍ତା ପା଼ଣାଟି ପିସ୍‌ପି କିୟାତି ଡା଼ୟୁ ଲ଼କୁ ନାଙ୍ଗେ ତାମି ଇଲ୍‌କାଣା ଆବାନିଲେହେଁ କିଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାମି ସା଼ୱୁକାରି ତା଼ଣାଟି ରୀଣା ଅ଼ହାମାଚାରାଇଁ ହା଼ଟାନାହାଁ ତଲିତାଣାଇଁ ୱେଚେସି, ‘ନା଼ ସା଼ୱୁକାରି ତା଼ଣା ନୀ ରୀଣା ଏଚେକା ମାନେ ?’ ");
INSERT INTO kxv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ଏ଼ୱାସି ଏଲେଇଚେସି, ‘ପା଼ସାକ଼ଡ଼ି ଡା଼ବା ନିୟୁଁ’ ଗୁମୁସ୍ତା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ‘ନୀନୁ ତବେ ଇମ୍ବାଆଁ କୁଗାନା ରୀ କ଼ଡ଼ି ଦସ ଇଞ୍ଜିଁ ରା଼ଚାମୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ଡା଼ୟୁ ଅ଼ଡ଼େ ରଅଣାଇଁ ୱେଚେସି, ‘ନୀନୁ ଏଚେକା ରୀଣା ଅ଼ହାମାଞ୍ଜି ?’ ଏ଼ୱାସି ଏଲେଇଚେସି, ‘ର଼ ମା଼ଣା ବାସ୍ତା ଗ଼ହଁୟାଁ’ ଗୁମୁସ୍ତା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ‘ନୀନୁ ତବେ ଇମ୍ବାଆଁ କୁଗାନା ଆ଼ଟା ୱାଞ୍ଜା ଇଞ୍ଜିଁ ରା଼ଚାମୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ଏ଼ ଲାଗେଏତି ଗୁମୁସ୍ତା ବୁଦିତଲେ କାମା କିହାମାନାକି ସା଼ୱୁକାରି ଏ଼ୱାଣାଇଁ ନୀନୁ ନେହିଁ କାମା କିହାମାଞ୍ଜି ଇଚେସି; ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଉଜେଡ଼ିତି ମୀର୍‌କା କିହାଁ ଈ ଦାର୍‌ତିତାରି ତାମି କାମାତା ହା଼ରେକା ବୁଦିଗାଟାରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ମୀରୁ ଦାର୍‌ତିତି ଲାଗେଏତି ଦ଼ନ ତଲେ ତ଼ଣେ ଦହ୍‌ଦୁ, ଏ଼ଦି ରା଼ତିସାରେ ମିଙ୍ଗେ କା଼ଲାକା଼ଲାତି ବାସା ଟା଼ୟୁତା ମିଙ୍ଗେ ଆବାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଆମ୍ବାଆସି ଊଣା କାମାତା ନାମୁଗାଟାସି ଆ଼ନେସି ଏ଼ୱାସି କାଜା କାମାତା ଜିକେଏ ନାମୁଗାଟାସି ଆ଼ନେସି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଊଣା କାମାତା ନାମୁଗାଟାସି ଆ଼ଆସାରେ ଏ଼ୱାସି କାଜା କାମାତା ଜିକେଏ ନାମୁଗାଟାସି ଆ଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଲାଗେଏତି ଦ଼ନତା ନାମୁ ଗାଟାତେରି ଆ଼ହାହିଲଅତେରି, ଆତିହିଁ ଆମ୍ବାଆସି ମିଙ୍ଗେ ନାମାହାଁ ସାତା ଦ଼ନ ମୀ କେୟୁତା ହେର୍‌ପାନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ମୀରୁ ଏଟ୍‌କାତା଼ଣା ଦ଼ନତି ନାମୁତଲେ ଲେ଼ମ୍ବା ହିଲାଆସାରେ ମିଙ୍ଗେ ମୀ ଲ଼ଡ଼ାମାନାଣି ଆମ୍ବାଆସି ହିୟାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ର଼ ହ଼ଲେଏସି ରୀ ସା଼ୱୁକାରି ତା଼ଣା ହ଼ଲେଏସି ଆ଼ହାଲି ଆ଼ଡଅସି; ଇଚିହିଁ ରଅଣାଇଁ ଜୀୱୁ ନ଼ନେସି ରଅଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଆ଼ଆତିଁ ରଅଣାଇଁ ମା଼ନୱି ଆ଼ନେସି ରଅଣାଇଁ ଅ଼ପଅସି । ମୀରୁ ମାହାପୂରୁ ଅ଼ଡ଼େ ଦ଼ନତି ହ଼ଲିୟାଙ୍ଗା ଆ଼ହାଲି ଆ଼ଡଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ଦ଼ନ ଜୂପ୍‌କା ପାରୁସିୟାଁ ଜୀସୁଇଁ କାକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆରି ମାଣ୍‌ସି ନ଼କିତା ତୀରିଗାଟାରି ଇଞ୍ଜିଁ ତ଼ସା କଡିମାନେରି, ମୀରୁ ଏଲେତି ଲ଼କୁ, ସାମା ମାହାପୂରୁ ମୀ ହିୟାଁତି ପୁନାସି ଇଚିହିଁ ଏ଼ନାୟି ମାଣ୍‌ସି ଅଣ୍‌ପୁତା କାଜାୟି ଲେହେଁ ତ଼ଞ୍ଜା ଆ଼ନେ, ଏ଼ଦି ମାହାପୂରୁ ନ଼କିତା ଅ଼ପାଆଗାଟାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ମ଼ସାତି ମେ଼ରା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ରା଼ଚିତି ପତି ଜହନ ପାତେକା ସା଼ଲୱି ଆ଼ହିମାଚୁ; ଏଚିବେ଼ଲାଟିଏ ମାହାପୂରୁ ରା଼ଜିତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହି ମାନେରି ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ତାମି ବା଼ଡ଼୍‌ୟୁ ତଲେ ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ହା଼ଗୁପା଼କା ଅ଼ଡ଼େ ଦାର୍‌ତି ବାରେ ମେଣ୍‌ଙ୍ଗିନେ ସାମା ମେ଼ରାତି ଇଚାୟି ସିନା ଜିକେଏ ମେଣ୍‌ଙ୍ଗେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଆମ୍ବାଆସି ତାନି ଡକ୍ରିନି ପିସାନା ଏଟ୍‌କାତାଣି ବୀହା ଆ଼ନେସି, ଏ଼ୱାସି ଦା଼ରି କିନେସି; ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ପିସ୍ତି ଡକ୍ରିନି ବୀହା ଆ଼ନେସି, ଏ଼ୱାସି ଦା଼ରେଲା ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ର଼ ଦ଼ନ ଗାଟାସି ମାଚେସି, ଏ଼ୱାସି ହା଼ରେକା ଅ଼ଜିତି ହିମ୍ବରିଦୂକି ହୁଚାନା ନେହିଁ ରା଼ନ୍ଦା ତିଞ୍ଜିହିଁ ହା଼ରେକା ରା଼ହାଁତଲେ ଡ଼ୟିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ସାମା ଏ଼ୱାଣି ଦୁୱେରି ଦାରିତା ଲାଜର ଦ଼ରୁଗାଟି ରୀସ୍‌ପା ତିନାସି ଡ଼ୟାମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଗୂଡ଼ା ଆଙ୍ଗା ଗା଼ହାଁୟାଁ ଆ଼ହାମାଚେସି; ଏ଼ ଦ଼ନ ଗାଟାଣି ଜୁଟା ଲିତା ତିଞ୍ଜାନା ତାନି ବାଣ୍ତି ପାଞ୍ଜିକିହାଲି ଆ଼ସା କିହିମାଚେସି; ଇଞ୍ଜାଁ ନେସ୍‌କା ୱା଼ହି ତାନି ଗା଼ହାଁୟାଁ ନା଼କିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ର଼ ଦିନା କାର୍ମାଗାଟି ଲାଜର ହା଼ହାହାଚେସି ଇଞ୍ଜାଁ ଲାକପୂରୁତି ଦୂତୁୟାଁ ତଲେ ଅବ୍ରାହାମ ମାଚିତା଼ଣା ଅ଼ୱିଆ଼ତେସି; ଡା଼ୟୁ ଏ଼ ଦ଼ନ ଗାଟାସି ଜିକେଏ ହା଼ହାହାଚେସି ଇଞ୍ଜାଁ ମାହ୍‌ଣି ମାଣ୍ତାତା ମୁସ୍‌ପି ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଅ଼ଡ଼େ ଏ଼ୱାସି ହା଼ତାରି ମାନି ରା଼ଜିତି କସ୍ତତଲେ କିଲିବିଲି ଆ଼ହିଁ ଲାକ ସିନିକିହାଲିଏ ହେକଟି ଅବ୍ରାହାମ ଅ଼ଡ଼େ ତାନିତଲେ ଲାଜରଇଁ ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ଏଚେଟିଏ ଏ଼ୱାସି ହା଼ଟିତେସି, ‘ଏ଼ ଆ଼ବା ଅବ୍ରାହାମ, ନାଙ୍ଗେ କାର୍ମା ଅଣ୍‌ପାନା ଲାଜରଇଁ ନା଼ ତା଼ଣା ପାଣ୍ତାମୁ, ଏ଼ୱାସି ତାନି ୱାଞ୍ଜୁତା ଏ଼ୟୁ ବନ୍ଦା ତାଚାନା ନା଼ ୱେନ୍ଦରିତି ହିତ୍‌ଡ଼ି କିୟାପେସି, ଇଚିହିଁ ନା଼ନୁ ଈ ହିଚୁତା କିଲିବିଲି ଆ଼ହିମାଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ସାମା ଅବ୍ରାହାମ ଏଲେଇଚେସି, ‘ମୀର୍‌ଏଣା ନୀନୁ ନୀଡାମାଚି ବେ଼ଲାତା ନୀ ନେହାଁଣି ବେଟାଆ଼ତି, ଇଞ୍ଜାଁ ଲାଜର ଏଲେକିହିଁଏ ପ଼ଲ୍‌ଆ ଗାଟାଣି ବେଟାଆ଼ତେସି, ଈଦାଆଁ ଅଣ୍‌ପାମୁ; ସାମା ନୀଏଁ ଏ଼ୱାସି ଇମ୍ବାଆଁ ସୁକୁ ବେଟାଆ଼ହି ମାନେସି, ଅ଼ଡ଼େ ନୀନୁ କିଲିବିଲି ଆ଼ହିମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଅ଼ଡ଼େ ର଼ କାତା ମୀ ମାଦି ମା଼ ମାଦି ର଼ କାଜା ଗା଼ଡ଼୍‌ୟୁ ମାନେ, ଆମ୍ବାଆରି ଈ ଟା଼ୟୁଟି ମୀ ତା଼ଣା ହାଜାଲି ମ଼ନ କିନେରି, ଏ଼ୱାରି ହାଜାଲି ଆ଼ଡଅରି ଆ଼ଆତିଁ ଏ଼ ଟା଼ୟୁଟି ଈ ଟା଼ୟୁତା ଗା଼ଣ୍‌ଚାନା ୱାୟାଲି ଆ଼ଡଅରି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ଏମ୍ବାଟିଏ ଦ଼ନ ଗାଟାସି ଏଲେଇଚେସି, ‘ଏ଼ ଆ଼ବା, ଆତିହିଁ ନା଼ନୁ ନିଙ୍ଗେ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ, ଲାଜରଇଁ ମା଼ ଆ଼ବା ଇଜ ପାଣ୍ତାମୁ, ");
INSERT INTO kxv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ଇଚିହିଁ ନା଼ ପା଼ସାଜା଼ଣା ତାୟିୟାଁ ମାନେରି; ଏ଼ୱାରି ଜିକେଏ ଏ଼ନିକିଁ ଈ କସ୍ତଗାଟି ଟା଼ୟୁତା ୱା଼ଅରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଏ଼ୱାରିତା଼ଣା ସା଼କି ହୀନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ସାମା ଅବ୍ରାହାମ ଏଲେଇଚେସି, ‘ଏ଼ୱାରିତା଼ଣା ମ଼ସା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପତିୟାଁ ମାନୁ, ଏ଼ୱାରି ଏ଼ କାତାତି ୱେଣ୍‌ମ୍ବାରି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଏମ୍ବାଟିଏ ଦ଼ନ ଗାଟାସି ଏଲେଇଚେସି, ‘ଏ଼ ଆ଼ବା ଅବ୍ରାହାମ, ଏଚେକେଏ ସା଼ରି ଆ଼ଏ, ସାମା ହା଼ତାରି ବିତ୍ରାଟି ରଅସି ଏ଼ୱାରିତା଼ଣା ହାନେସି ଆତିହିଁ ଏ଼ୱାରି ମ଼ନ ୱେଟ୍‌ନେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ସାମା ଅବ୍ରାହାମ ଏଲେଇଚେସି, ଏ଼ୱାରି ମ଼ସା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ୱେନଅରି, ଆତିହିଁ ହା଼ତାରି ବିତ୍ରାଟି ୱେଣ୍ତେ ନିଙ୍ଗିତିଁ ଜିକେଏ ଏ଼ୱାଣି କାତା ନାମଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଏମିନି ତାୟିପାରି କିନି ତା଼ଣାଟି ଲ଼କୁ ପା଼ପୁତା ହେର୍‌ନେରି, ଏ଼ ବାରେ ପିଟୱି ଆ଼ଏ, ସାମା ତାୟିପାରି କିୱି କିନାସି ଆୟ଼ତା ଏ଼ୱାସି ଗାଡି ଡଣ୍ତ ବେଟାଆ଼ନେସି; ");
INSERT INTO kxv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଊଣା କକାରି ବିତ୍ରାଟି ରଅଣାଇଁ ତାୟିପାରି କିନିବାଟା ତାନି ହେର୍‌କିତା କାଜା ଜେତାୱାଲି ଦସାନା ସାମ୍‌ଦୁରିତା ମେତ୍‌ହିହିଁ ଏ଼ୱାଣାକି ନେହେଁ ଆ଼ତେମା । ");
INSERT INTO kxv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ମୀରୁ ମୀ ତାକି ଜାଗ୍ରାତା ଆ଼ହାମାଞ୍ଜୁ ।” “ନୀ ତାୟି ପା଼ପୁ କିନେସି, ଆତିହିଁ ଏ଼ୱାଣାଇଁ ଲା଼ଗାମୁ; ଏ଼ୱାସି ନା଼ନୁ ପା଼ପୁ କିତେଏଁ ଇଞ୍ଜିଁ ମ଼ନ ୱେଟ୍‌ହିହିଁ, ଏ଼ୱାଣି ପା଼ପୁ ମ୍ଣେକ୍‌ହା ତୁହ୍‌ମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଅ଼ଡ଼େ ଏ଼ୱାସି ସାତା ପା଼ଲି ନୀ କ଼ପାଟି ପା଼ପୁ କିନେସି ଅ଼ଡ଼େ ସାତା ପା଼ଲି ନୀ ତା଼ଣା ୱେଣ୍ତା ୱା଼ହାନା ନା଼ନୁ ମ଼ନ ୱେଟ୍‌ହିମାଇଁ ଇଞ୍ଜିଁ ଇଞ୍ଜାନେସି ଆତିହିଁ ଏ଼ୱାଣି ପା଼ପୁ ମ୍ଣେକ୍‌ହା ତୁହ୍‌ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଏଚେଟିଏ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ପ୍ରବୁଇଁ ଏଲେଇଚେରି, “ମା଼ ନାମୁତି ପାଡି କିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରବୁ ଏଲେଇଚେସି, “ର଼ ହାର୍ସୁ ପା଼ଡ଼େୟି ଏଚେକା ମୀ ନାମୁ ମାଚିହିଁମା, ଈ ତୁତୁକଲି ମା଼ର୍‌ନୁତି ହୀରୁତଲେ ମେଗାହାଜାନା ସାମ୍‌ଦୁରିତା ଉହି ଆ଼ମୁ ଇଚିହିଁ ଏ଼ଦି ମୀ କାତା ମା଼ନୱି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ସାମା ମୀ ବିତ୍ରାଟି ଇଲେତାସି ଆମ୍ବାଆସି ମାନେସି, ତାନି ହ଼ଲେଏସି ହେ଼ରୁ ଡ଼ୂହାନା କି କ଼ଡିୟାଁ ମେଚାନା ୱା଼ତିସାରେ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଜୁରୁୟାଁ ଗହ୍‌ମୁଦେଁ ଇନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ନାଙ୍ଗେ ତିଞ୍ଜାଲି ହିୟାମୁ, ନା଼ନୁ ତିଞ୍ଜାଲି ଆ଼ଡାଆ ପାତେକା ଟେଡେଲି ହିମ୍ବରି ରୂପାନା ନା଼ ସେ଼ବା କିୟାମୁ, ଇଞ୍ଜାଁ ଡା଼ୟୁ ନୀନୁ ତିନାମୁ ଇଞ୍ଜିଁ ଏ଼ୱାଣାଇଁ ଏଲେଇନଅସି ? ");
INSERT INTO kxv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ର଼ ହ଼ଲେଏସି ସା଼ୱୁକାରି କାତା ମା଼ନୱି ଆ଼ହାନା କାମା କିନାକି ଏ଼ୱାଣାଇଁ ଜହରା କିନେସିକି ? ");
INSERT INTO kxv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ହୁକୁମି ତଲେ କାମା କିତି ଡା଼ୟୁ ‘ମା଼ମ୍ବୁ ପା଼ଡ଼ା ଆ଼ଆ ହ଼ଲିୟାଙ୍ଗାତମି; ଏ଼ନାୟି ମା଼ମ୍ବୁ କିନାୟି ମାଚେ ଏ଼ଦାଆଁ କିହାମାନମି’ ଇଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜୀସୁ ଜିରୁସାଲମତା ହାଜିମାଚାଟି ଗାଲିଲି ଅ଼ଡ଼େ ସମିରଣି ଦେ଼ସା ମାଦିଟି ହାଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ର଼ ନା଼ୟୁଁତା ଏଗାହାଜାଲିଏ ଦସଜା଼ଣା କାଜା ର଼ଗ ଗାଟାରି ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ଏ଼ୱାରି ହେକ ନିଚାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ଏ଼ ଜୀସୁ ଗୂରୁ ମାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଜୀସୁ ଏ଼ୱାରାଇଁ ମେସାନା ଏଲେଇଚେସି, “ମୀରୁ ହାଜାନା ପୂଜେରାଙ୍ଗା ତା଼ଣା ତ଼ଞ୍ଜା ଆ଼କାଦୁ ।” ଅ଼ଡ଼େ ଏ଼ୱାରି ହାଜି ହାଜିହିଁ ନେହିଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ସାମା ଏ଼ୱାରି ବିତ୍ରାଟି ରଅସି ତା଼ନୁ ନେହିଁ ଆ଼ତାଣି ମେସାନା କାଜା ଗିୟାଁତଲେ ମାହାପୂରୁତି ଜହରା କିହିଁ କିହିଁ ୱେଣ୍ତା ୱା଼ହାନା, ");
INSERT INTO kxv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ଜୀସୁତି କଡାୟାଁ ଡ଼଼ଇ ମୁନୁ କୁତାନା ଜହରା କିତେସି; ଏ଼ୱାସି ସମିରଣି ଲ଼କୁ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ଏଚେଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଦସଜା଼ଣା ନେହିଁ ଆ଼ଆତେରିକି ? ଅ଼ଡ଼େ ନ଼ ଜା଼ଣା ଏମ୍ବିୟା ମାନେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ମାହାପୂରୁଇଁ ଜହରା କିହାଲି ଈ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ପିସ୍‌ପେ ଆମ୍ବାଆସି ୱେଣ୍ତା ୱା଼ଆତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗାନା ହାଲାମୁ ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ମାହାପୂରୁତି ରା଼ଜି ଏଚେଲା ୱା଼ହିମାନେ, ଈ କାତା ପାରୁସିୟାଁ ୱେଞ୍ଜାଲିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁତି ରା଼ଜି ତ଼ଞ୍ଜା ଆ଼ହିଁ ୱା଼ଏ; ");
INSERT INTO kxv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଇମ୍ବାଆଁ ମାନେକି ଏମ୍ବାଆଁ ମାନେ ଇଞ୍ଜିଁ ଲ଼କୁ ୱେସ୍ତଅରି; ଇଚିହିଁ ମାହାପୂରୁତି ରା଼ଜି ମୀ ବିତ୍ରେଏ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ଇଞ୍ଜାଁ ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଇଲେତି ବେ଼ଲା ୱା଼ନେ, ଏଚିବେ଼ଲା ମାଣ୍‌ସି ମୀର୍‌ଏଣାତି ର଼ ଦିନା ମେସାଲି ମ଼ନ କିତିହିଁ ଜିକେଏ ମେହ୍‌ଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ଏଚିବେ଼ଲା ଲ଼କୁ ମିଙ୍ଗେ ୱେସ୍ତାନେରି, ଏ଼ୱାସି ଇମ୍ବାଆଁ ମାନେସି ଏମ୍ବାଆଁ ମାନେସି; ସାମା ଏ଼ୱାରି କାତା ଆହ୍‌ଆଦୁ କି ଏ଼ୱାରିତଲେ ତା଼କାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଏ଼ନିଇଚିହିଁ ହା଼ଗୁ ମ୍ଣିହ୍‌ନାଟି ର଼ କନଟି ଅ଼ର କନୱାକି ଉଜେଡ଼ି ଆ଼ନେ, ଏଲେକିହିଁଏ ମାଣ୍‌ସି ମୀର୍‌ଏଣା ଦିନାତା ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ସାମା ଏ଼ୱାସି ଗାଡି କସ୍ତ ପା଼ଣ୍‌ନାୟି ମାନେ, ଇଞ୍ଜାଁ ଈ କା଼ଲାତି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଅ଼ପଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଅ଼ଡ଼େ ନ଼ହ ବେ଼ଲାତା ଏ଼ନିକିଁ ଆ଼ହାମାଚେ, ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନି ଦିନାତା ଜିକେଏ ଏଲେକିହିଁଏ ଆ଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ନ଼ହ ଜା଼ଜାତା ହ଼ଡ଼୍‌ନି ଦିନା ପାତେକା ଲ଼କୁ ତିଞ୍ଜି ଉଣ୍ତିହିଁ ବୀହା କିୟାଲି ବୀହା ହିୟାଲି ହେ଼ରାମାଚେରି, ଏଚିବେ଼ଲା କାଜା ପିୟୁ ୱା଼ତେ ଇଞ୍ଜାଁ ବାରେତି କ୍ଡୁପ୍‌ହାତୁସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲଟ ବେ଼ଲାତା ଜିକେଏ ଏଲେଏ ଆ଼ତେ, ଲ଼କୁ ତିଞ୍ଜି ଉଣ୍ତି ମାଚେରି, କଡି ମାଚେରି, ପାର୍‌ଚି ମାଚେରି, ମା଼ର୍‌କା ଉହି ମାଚେରି ଅ଼ଡ଼େ ଇଲ୍‌କା କିହାଲି ହେ଼ରାମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ସାମା ଲଟ ସଦମ ଗା଼ଡ଼ାଟି ହ଼ଚା ହାଲ୍‌ୱନିଏ, ଲାକପୂରୁଟି ହିଚୁ ଅ଼ଡ଼େ ଗାନ୍ଦାଗୁଣ୍ତା ୱା଼ହାନା ବାରେତି ନା଼ସା କିତେ । ");
INSERT INTO kxv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ନି ଦିନାତା ଜିକେଏ ଏଲେଆ଼ହିଁଏ ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ଏ଼ ଦିନା ଆମ୍ବାଆସି ଇଲୁ ଲାକ ମାନେସି, ଏ଼ୱାସି ଇଲୁ ବିତ୍ରାମାନି ତାନି ଆ଼ସ୍ତି ଅ଼ହାଲି ରେ଼ଚା ୱା଼ଆପେସି; ଏଲେକିହିଁଏ ଆମ୍ବାଆସି ନେଃଏଲାତା ମାନାସି ଇଜ ୱେଣ୍ତା ୱା଼ଆପେସି । ");
INSERT INTO kxv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲଟ ଡକ୍ରିନି କାତା ଅଣ୍‌ପାଦୁ ! ");
INSERT INTO kxv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଆମ୍ବାଆସି ତାନି ଜୀୱୁତି ନୀଟ୍‌ହାଲି ମ଼ନ କିନାସି, ଏ଼ୱାସି ନା଼ସା ଆ଼ନେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ତାନି ଜୀୱୁତି ଆ଼ସା କିଆଗାଟାସି ଏ଼ୱାସି ନୀଡିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ ଲା଼ଆଁୟାଁ ରିଆରି କାଟେଲିତା ଡୂରା ଡ଼ୟିନେରି, ରଅସି ଅ଼ୱିଆ଼ନେସି ଅ଼ଡ଼େ ରଅସି ଏମ୍ବାଆଁ ଡ଼ୟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ରୀ ଇୟାସିକା ରଣ୍ତିଏ ତା଼ଣା ନୂୟିଁମାନୁ, ରଣ୍ତି ଅ଼ୱିଆ଼ନେ ରଣ୍ତି ଏମ୍ବାଆଁ ଡ଼ୟିନେ । ");
INSERT INTO kxv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ରିଆରି ନେଃଏଲାତା ମାନେରି, ରଅସି ଅ଼ୱିଆ଼ନେସି, ରଅସି ଏମ୍ବାଆଁ ଡ଼ୟିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ଏଚେଟିଏ ସୀସୁୟାଁ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଏମ୍ବିୟା ?” ଜୀସୁ ଏଲେଇଚେସି, “ମାଡ଼୍‌ହା ଏମ୍ବିୟାମାନେ ଏମ୍ବାଆଁ ରା଼ମ୍‌ଣାୟାଁ ରୁଣ୍ତା ଆ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ୱା଼ହାଆନା ଅଲେ ଅଲେ ପ୍ରା଼ତାନା କିନାୟିମାନେ, ଈ କାତାତି ଜୀସୁ ସୀସୁୟାଁଇଁ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ୱେସ୍ତେସି ");
INSERT INTO kxv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ର଼ ଗା଼ଡ଼ାତା ର଼ ନୀହାଁୟି କିନାସି ମାଚେସି, ଏ଼ୱାସି ମାହାପୂରୁଇଁ ଆଜି ହିଲାଆତେସି କି ମାଣ୍‌ସିୟାଁଇଁ ଜିକେଏ ଅଣ୍‌ପି ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଏ଼ ଗା଼ଡ଼ାତା ର଼ ରା଼ଣ୍ତେଣି ମାଚେ, ଏ଼ଦି ନୀହାଁୟି କିନାଣି ତା଼ଣା ଅଲେ ଅଲେ ହାଜିହିଁ ନୀନୁ ନେହିଁ ନୀହାଁୟି କିହିଁ ନା଼ କ଼ପାଟି ନିଙ୍ଗିମାଞ୍ଜାନାଣା ତା଼ଣାଟି ଗେଲ୍‌ପାମୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ଦାନି କାତା ୱେଞ୍ଜି ହିଲାଆତେସି; ଡା଼ୟୁ ଏ଼ୱାସି ମ଼ନ ମ଼ନତା ଅଣ୍‌ପିତେସି, ନା଼ନୁ ମାହାପୂରୁଇଁ ଆଜିହିଲଅଁ କି ମାଣ୍‌ସିଇଁ ଅଣ୍‌ପି ହିଲଅଁ, ");
INSERT INTO kxv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଆ଼ତିଜିକେଏ ଈ ରା଼ଣ୍ତେଣି ନାଙ୍ଗେ କସ୍ତ ହୀହିମାଞ୍ଜାନାକି ନା଼ନୁ ତାନି କ଼ପାଟି ନିଙ୍ଗାମାନି ନୀହାଁୟି ଡିକ୍‌ହାତୁହ୍‌ଇଁ, ଆ଼ଆତିଁ ଏ଼ଦି ନାଙ୍ଗେ ବାରେବେ଼ଲା ଗିଜିଗିଜା କିହେ଼ମାଞ୍ଜାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ଏମ୍ବାଟିଏ ପ୍ରବୁ ଏଲେଇଚେସି, “ଈ ଲାଗେଏତି ନୀହାଁୟି କିନାଣି କାତା ଅଣ୍‌ପାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଆତିହିଁ ମାହାପୂରୁ ଆ଼ଚିତି ଲ଼କୁ ଲା଼ଆଁ ମାଦେନା ଏ଼ୱାଣାଇଁ ହା଼ଟିହିଁ ଡ଼ୟିନେରି, ଏ଼ୱାସି କି ଏ଼ୱାରି ନୀହାଁୟି କିଅସି ? ଆ଼ତିଜିକେଏ ଏ଼ୱାସି ଏ଼ୱାରି ସାତ୍ରୁୟାଁକି ହା଼ରେକା ଅ଼ର୍‌ହିନାସି ଆ଼ନେସି କି ? ");
INSERT INTO kxv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ତବେ ଏ଼ୱାରି ତାକି କିୱି ଆ଼ହାମାନି ପ଼ଲ୍‌ଆ କାମାତି ନୀହାଁୟି କିନେସି, ଆ଼ତିଜିକେଏ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଦାର୍‌ତିତା ୱା଼ହାନା ନାମୁତି ମେହ୍‌ନେସିକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ତାମ୍‌ଙ୍ଗେ ତୀରିଗାଟାତମି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଏଟ୍‌କା ତାରାଇଁ ହୀଣି କିନି ଲ଼କୁଣି ଜୀସୁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ରିଆରି ପ୍ରା଼ତାନା କିହାଲି ର଼ ପ୍ରା଼ତାନା ଇଲୁତା ହାଚେରି, ରଅସି ପାରୁସି ଅ଼ଡ଼େ ରଅସି ସିସ୍ତୁ ରୀହ୍‌ନାସି । ");
INSERT INTO kxv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ପାରୁସି ନିଚାନା ଇଲେକିହିଁ ପ୍ରା଼ତାନା କିତେସି, “ଏ଼ ମାହାପୂରୁ ନା଼ନୁ ନିଙ୍ଗେ ଜହରା କିହିମାଞ୍ଜାଇଁ, ନା଼ନୁ ଏଟ୍‌କା ଲ଼କୁ ଲେହେଁ ଦାର୍ମୁ ହିଲାଆ ଗାଟାତେଏଁ ଆ଼ଏ, ସ଼ରୁ, ଦା଼ରି ଗାଟାତେଏଁ ଆ଼ଏ କି ଈ ସିସ୍ତୁ ରୀହ୍‌ନାଣି ଲେହେଁ ଜିକେଏ ଆ଼ଏ; ");
INSERT INTO kxv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ନା଼ନୁ ୱା଼ରା ତାକି ରୀ ଦେବା ଉପାସା କିହିମାଇଁ, ଅ଼ଡ଼େ ନା଼ନୁ ବେଟାଆ଼ହି ମାନାଣି ବାରେ ଦସ ବା଼ଗାଟି ର଼ ବା଼ଗା ହୀହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ସାମା ସିସ୍ତୁ ରୀହ୍‌ନାସି ହେକ ନିଚାନା ତାନି କାନୁ ଲାକପୂରୁ ୱାକି ଜିକେଏ ପେର୍‌ହାଁ ସିନିକିହାଲି ସା଼ସା କିଆତେସି, ସାମା ତାନି ବକତା ୱେ଼ଚା କଡାନା ଏଲେଇଚେସି, “ଏ଼ ମାହାପୂରୁ ନା଼ନୁ ପା଼ପୁ ଗାଟାତେଏଁ ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ଆ଼ଏ ସାମା ସିସ୍ତୁ ରୀହ୍‌ନାସି ତୀରିଗାଟାସି ଆ଼ହାନା ତାମି ଇଜ ହାଚେସି; ଏ଼ନିଇଚିହିଁ ଆମ୍ବାଆସି ନା଼ନୁ କାଜାତେଏଁ ଇଞ୍ଜାଁ କଡିନେସି, ଏ଼ୱାଣାଇଁ ଊଣା କିୱିଆ଼ନେ, ସାମା ଆମ୍ବାଆସି ନା଼ନୁ ଊଣାତେଏଁ ଇନେସି, ଏ଼ୱାଣାଇଁ କାଜାସି କିୱିଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଏ଼ୱାସି ଏ଼ନିକିଁ କକାରି ପ଼ଦାଁଣି ଡୀଗିନେସି, ଏ଼ଦାଆଁତାକି ଲ଼କୁ ଏ଼ୱାରାଇଁ ଜୀସୁ ତା଼ଣା ତାଚାଲି ମା଼ଟ୍‌ହେରି; ସାମା ସୀସୁୟାଁ ଏ଼ଦାଆଁ ମେସାନା ଏ଼ୱାରାଇଁ ଦାକା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ସାମା ଜୀସୁ କକାରି ପ଼ଦାଁଣି ଡାଗେ ହା଼ଟାନା ଏଲେଇଚେସି, “କକାରି ପ଼ଦାଁଣି ନା଼ ଡାଗେ ୱା଼ହାଲି ହୀଦୁ, ଏ଼ୱାରାଇଁ କା଼ହିକିଆଦୁ; ଏ଼ନିଇଚିହିଁ ମାହାପୂରୁତି ରା଼ଜି ଇଲେତାରାୱାୟି । ");
INSERT INTO kxv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ଊଣା କକାରି ପ଼ଦାୟାଁ ଲେହେଁ ମାହାପୂରୁ ରା଼ଜି ଆହ୍‌ଅସି ଏ଼ୱାସି ଏ଼ନିକିଁ ଜିକେଏ ଏମ୍ବାଆଁ ହ଼ଡାଲି ଆ଼ଡଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଜୀହୁଦି ଲ଼କୁ ବିତ୍ରାଟି କାଜାସି ଜୀସୁଇଁ ୱେଚେସି, “ଏ଼ ନେହିଁ ଗୂରୁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାଲି ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ନେହାଁତି ଇଞ୍ଜିଁ ଏ଼ନାଆଁତାକି ଏଲେଇଞ୍ଜିମାଞ୍ଜି ? ଇଚିହିଁ ମାହାପୂରୁ ରଅସିଏ ନେହାଁସି ମାନେସି ଏ଼ୱାଣି ପିସ୍‌ପେ ଆମ୍ବାଆସି ନେହାଁସି ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ହୁକୁମିକା ପୁଞ୍ଜାମାଞ୍ଜି, ‘ଦା଼ରି କିଆନି, ଲ଼କୁଣି ପା଼ୟାଆନି, ସ଼ରୁ କିଆନି, ମିଚିସାକି ହୀଆନି, ତାଲି ତାଞ୍ଜି କାତା ମା଼ନି କିମୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ଦ଼ନଗାଟାସି ଏଲେଇଚେସି, “ନା଼ନୁ ଈ ବାରେ ଊଣାୱେଡ଼ାଟିଏ କିହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜୀସୁ ଈ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ର଼ କାମା କିନାୟିମାନେ; ନୀନୁ ନୀ ତା଼ଣା ମାନି ବାରେ ଦ଼ନବିତି ପାର୍‌ଚାନାହାଁ ହିଲାଆ ଗାଟାରାକି ଦା଼ନା ହୀମୁ, ଇଞ୍ଜାଁ ଡା଼ୟୁ ନୀନୁ ଲାକପୂରୁତା ଦ଼ନ ବେଟାଆ଼ଦି; ଏଚେଟିଏ ନା଼ ଜେ଼ଚ ଜେ଼ଚ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ସାମା ଏ଼ୱାସି ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ହା଼ରେକା ଦୁକୁ ଆ଼ତେସି, ଇଚିହିଁ ଏ଼ୱାସି ବାତ୍‌କୁ ଗାଟାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ମେସାନା ଏଲେଇଚେସି, “ଆମ୍ବାଆରି ଦ଼ନ ମାନେ, ଏ଼ୱାରି ହା଼ରେକା କସ୍ତତଲେ ମାହାପୂରୁତି ରା଼ଜିତା ହ଼ଡ଼୍‌ନେରି ! ");
INSERT INTO kxv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଇଚିହିଁ ମାହାପୂରୁତି ରା଼ଜିତା ଦ଼ନଗାଟାସି ହ଼ଡ଼୍‌ନି କିହାଁ ଊଟୁ ସୂଜା କା଼ଣିଟି ହ଼ଚାହାନାୟି ଊସାସା ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଏ଼ କାତା ୱେଞ୍ଜିମାଚାରି ଏଲେଇଚେରି, “ଆତିହିଁ ଆମ୍ବାଆସି ଗେଲ୍‌ପି ଆ଼ହାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁ ଲ଼କୁ କିୟାଲି ଆ଼ଡାଆଗାଟାଣି ମାହାପୂରୁ କିହାଲି ଆ଼ଡିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ଏଚେ଼ତା ପିତର ଜୀସୁଇଁ ୱେଚେସି, “ମେହ୍‌ମୁ ମା଼ମ୍ବୁ ବାରେ ପିସାନା ନୀ ଜେ଼ଚ ୱା଼ହିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମିନି ଗାଟାରି ମାହାପୂରୁ ରା଼ଜିତାକି ଇଲୁକାଣ୍ତା, ଡକ୍ରିନି, ତାୟି, ତାଲି ତାଞ୍ଜି, ଅ଼ଡ଼େ ମୀର୍‌କା ମା଼ସ୍‌କାଣି ପିସାମାନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଏ଼ୱାରି ଈ ଜୁଗୁତା ହା଼ରେକା ଆଗାଡ଼ା ବେଟାଆ଼ହାନା, ୱା଼ନି ଜୁଗୁତା କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ଜୀସୁ ତାନି ବା଼ରଜା଼ଣା ସୀସୁୟାଁଇଁ ହା଼ଟାନା ୱେସ୍ତେସି, “ମେହ୍‌ଦୁ ମା଼ର ଜିରୁସାଲମତା ହାଜିମାନାୟି, ଏମ୍ବାଆଁ ମାଣ୍‌ସି ମୀର୍‌ଏଣି ତାକି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଏ଼ନା ଏ଼ନାଆଁ ରା଼ଚାମାନେରି, ଏ଼ ବାରେ ମାଣ୍‌ସି ମୀର୍‌ଏଣା ତା଼ଣା ସାତା ଆ଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ଏଟ୍‌କା କୂଡ଼ାତାରି କେୟୁତା ହେର୍‌ପିଆ଼ନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ କାକ୍‌ନେରି, ଏ଼ୱାଣାଇଁ ହୀଣି କିହାନା ହୂପିନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ଏ଼ୱାଣାଇଁ ସା଼ଟ୍‌ଣି ଡ଼଼ରିତଲେ ୱେ଼ଚାନା ପା଼ୟିନେରି, ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ସାମା ସୀସୁୟାଁ ଈ ବାରେ କାତା ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି; ଈ କାତା ଏ଼ୱାରିତା଼ଣା ଡ଼ୁଗାନା ମାଚେ, ଏ଼ନାଆଁ ୱେସ୍‌ପି ଆ଼ହିମାଚେ ଏ଼ ବାରେ ପୁଞ୍ଜିହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜୀସୁ ଜିରିହ ଗା଼ଡ଼ାତା ଏଜିମାଚାଟି ର଼ କା଼ଣା ଜିରୁତା କୁଗାନା ରୀସ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ଏ଼ୱାସି ଲ଼କୁତି ହାଜିମାନି ହା଼ଡା ୱେଞ୍ଜାନା, “ଈଦି ଏ଼ନାୟି ଆ଼ହିମାନେ ଇଞ୍ଜିଁ ୱେଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“ନା଼ଜରିତତି ଜୀସୁ ଇମ୍ବାଟି ହାଜିମାନେସି” ଇଞ୍ଜିଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ଏଚେଟିଏ କା଼ଣା କାଜା ଗିୟାଁତଲେ ଏଲେଇଞ୍ଜି ଇଚେସି, “ଏ଼ ଜୀସୁ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ସାମା ନ଼କିତା ହାଜିମାଚାରି ଏ଼ୱାଣାଇଁ ପାଲେଏ ମାଞ୍ଜାଲି ଦାକା ହୀତେରି, ସାମା ଏ଼ୱାସି ଅ଼ଡ଼େ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଏ଼ ଜୀସୁ ଦାୱୁଦ ମୀର୍‌ଏଣାତି ନାଙ୍ଗେ କାର୍ମା ମେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ଏଚେଟିଏ ଜୀସୁ ଏମ୍ବାଆଁ ନିଚାନା କା଼ଣାଇଁ ତାନି ଦାରିତା ତାଚାଲି ଟା଼ଣ୍ତିତେସି; ଏଚେ଼ତା କା଼ଣା ଡାଗେ ୱା଼ତେସି ଇଞ୍ଜାଁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ନା଼ନୁ ନିଙ୍ଗେତାକି ଏ଼ନାଆଁ କିଇଁ ଇଞ୍ଜିଁ ମ଼ନ କିହିମାଞ୍ଜି ?” କା଼ଣା ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ନୁ ଏ଼ନିକିଁ ମେସାଲି ଆ଼ଡିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜୀସୁ ୱେସ୍ତେସି, “ନୀନୁ ମେହ୍‌ମୁ, ନୀ ନାମୁ ନିଙ୍ଗେ ନେହିଁ କିୟାତେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସି ମେସାଲି ଆ଼ଡିତେସି ଇଞ୍ଜାଁ ମାହାପୂରୁତି ଜହରା କିହିଁ କିହିଁ ଜୀସୁ ଜେ଼ଚ ହାଚେସି, ଅ଼ଡ଼େ ଲ଼କୁ ଏ଼ଦାଆଁ ମେସାନା ମାହାପୂରୁଇଁ ଜହରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ଜୀସୁ ଜିରିହତା ହ଼ଡାନା ଗା଼ଡ଼ା ମାଦିଟି ହାଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଏମ୍ବାଆଁ ଜକିୟ ଦ଼ରୁଗାଟାସି ରଅସି ମାଚେସି, ଏ଼ୱାସି ସିସ୍ତୁ ରୀହ୍‌ନାରି ବିତ୍ରାଟି କାଜାସି ଅ଼ଡ଼େ ଏ଼ୱାଣାକି ହା଼ରେକା ଦ଼ନ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜୀସୁ ଏ଼ନିଲେହେଁତାସି ଇଞ୍ଜିଁ ଏ଼ୱାଣାଇଁ ମେସାଲି ହା଼ରେକା ମ଼ନ ମାଚେ, ସାମା ହା଼ରେକା ଲ଼କୁ ମାଚାକି ମେସାଲି ଆ଼ଡିହିଲାଆତେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାସି କୁଜା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନ଼କିତା ହଟି ହଟି ହାଜାନା ଜୀସୁ ହାନି ଜିରୁତା ଏ଼ୱାଣାଇଁ ମେସାଲି ର଼ ତ଼ୟା ମା଼ର୍‌ନୁତା ହ଼ତେସି, ଇଚିହିଁ ଜୀସୁ ଏ଼ ଜିରୁଟି ହାନାୟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜୀସୁ ଏମ୍ବାଆଁ ଏଜାନା ଲାକ ସିନିକିହାନା ହା଼ଟିତେସି, “ଆଡ଼େ ଜକିୟ ତବେ ରେ଼ଚାୱାମୁ ଇଚିହିଁ ନୀଞ୍ଜୁ ନା଼ନୁ ମୀ ଇଜ ଗତା ୱା଼ନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ଏ଼ୱାସି ତବେ ରେ଼ଚାୱା଼ହାନା ଏ଼ୱାଣାଇଁ ରା଼ହାଁଟି ତାମି ଇଜ ହା଼ଟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ଈଦାଆଁ ମେସାନା ବାରେ ଲ଼କୁ ମୁରୁ ମୁରୁ ଆ଼ହିଁ କାତା ଆ଼ତେରି, “ଈୱାସି ର଼ ପା଼ପୁ ଗାଟାରି ଇଜ ଗତା ହାଜିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ସାମା ଜକିୟ ନିଚାନା ପ୍ରବୁଇଁ ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ନୁ ନା଼ ଦ଼ନତି ର଼ ବା଼ଗା ହିଲାଆ ଗାଟାରାକି ହୀଇଁ, ଅ଼ଡ଼େ ନା଼ନୁ ଆମ୍ବାଆରି ତା଼ଣାଟି ଏ଼ନାଆଁ ତାଚାମାଚିହିଁ ସା଼ରି ବା଼ଗା ଆଗାଡ଼ା ୱେଟ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ନୀଞ୍ଜୁ ଈ ଇଜତି ଲ଼କୁତାକି ଗେଲ୍‌ପିନାୟି ୱା଼ହାମାନେ, ଇଚିହିଁ ଈୱାସି ଜିକେଏ ଅବ୍ରାହାମତି କୂଡ଼ାତାସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଇଚିହିଁ ଏ଼ନାୟି ଜା଼ଙ୍ଗା ହାଜାମାନେ ଏ଼ଦାଆଁ ପାରାନା ଗେଲ୍‌ପାଲି ମାଣ୍‌ସି ମୀର୍‌ଏସି ୱା଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ଲ଼କୁ ଈ କାତା ୱେଞ୍ଜି ମାଚାଟି ଏ଼ୱାସି ଅ଼ଡ଼େ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, ଇଚିହିଁ ଏ଼ୱାସି ଜିରୁସାଲମ ଡାଗେ ଆ଼ହାମାଚେସି, ଇଚିହିଁ ମାହାପୂରୁ ରା଼ଜି ତବେ ତ଼ଞ୍ଜାଆ଼ନେ ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଏ଼ୱାସି ଏଲେଇଚେସି, “ର଼ କାଜା କୂଡ଼ାତାସି ରାଜା ପା଼ଣା ବେଟାଆ଼ହାଁ ୱେଣ୍ତା ୱାଇଁୱା ଇଞ୍ଜିଁ ର଼ ହେକ ରା଼ଜି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ଏ଼ୱାସି ତାନି ଦସଜା଼ଣା ହ଼ଲିୟାଙ୍ଗାଣି ହା଼ଟାନା ଏ଼ୱାରାକି ଦସଗଟା ୱେଣ୍ତି ଟାକା ଲାକା ହୀହାନା ଏଲେଇଚେସି, ‘ନା଼ନୁ ୱେଣ୍ତା ୱା଼ନି ପାତେକା ମୀରୁ ଈ ଟାକା ତଲେ ବେ଼ବାରା କିଦୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ସାମା ତାନି ଦେ଼ସାତାରି ଏ଼ୱାଣାଇଁ ଅ଼ପିହିଲାଆତେରି, ‘ଈୱାସି ମାଙ୍ଗେତାକି ରାଜା ଆୟାଆପେସି’ ଇଞ୍ଜିଁ ତାନି ଜେ଼ଚଏ କ଼ସ୍‌କାଣି କାବ୍ରୁ ୱେସା ପାଣ୍ତିତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ଡା଼ୟୁ ଏ଼ୱାସି ରାଜା ପା଼ଣା ବେଟାଆ଼ହାନା ତାନି ରା଼ଜିତା ୱେଣ୍ତାୱା଼ତେସି, ଇଞ୍ଜାଁ ତା଼ନୁ ଟାକାୟାଁ ହୀହାମାଚି ହ଼ଲିୟାଙ୍ଗା ବେ଼ବାରା କିହାଁ ଏଚେକା ଲା଼ବା କିହାମାନେରି ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲି ଏ଼ୱାରାଇଁ ହା଼ଟିକିତେସି, ଇଞ୍ଜାଁ ୱେଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ତଲିତାସି ୱା଼ହାନା ଏଲେଇଚେସି, “ବା଼ବୁ ନୀନୁ ହୀହାମାଞ୍ଜାତି ର଼ ଟାକା ତଲେ ବେ଼ବାରା କିହାନା ଦସଟାକା ଲା଼ବା କିହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନେହିଁ ଟିକାଣାଗାଟି ନାମୁତି ହ଼ଲେଏଣାତି, ନୀନୁ ଊଣା କାମାତାକି ନେହିଁ କାମା କିହାମାନାକି ନା଼ନୁ ନିଙ୍ଗେ ଦସଗଟା ଗା଼ଡ଼ାୟାଁ ସା଼ଲୱି କିନି ଅଦିକାରା କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଅ଼ଡ଼େ ରଅସି ୱା଼ହାନା ଏଲେଇଚେସି, “ବା଼ବୁ ନୀନୁ ହୀହାମାଞ୍ଜାତି ଟାକା ତଲେ ପା଼ସାଗଟା ଲା଼ବା କିହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଜିକେଏ ଏଲେଇଚେସି, “ନୀନୁ ଜିକେଏ ପା଼ସାଗଟା ଗା଼ଡ଼ାୟାଁ ମୁହେଁ ଅଦିକାରା ଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ଅ଼ଡ଼େ ରଅସି ୱା଼ହାନା ଏଲେଇଚେସି, “ପ୍ରବୁ ମେହ୍‌ମୁ ଈଦି ନୀନୁ ହୀହାମାଞ୍ଜାତି ଟାକା; ଈଦାଆଁ ନା଼ନୁ ଡ୍ରାଃଆଲିତା ରୂପାନା ଇଟାମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଇଚିହିଁ ନା଼ନୁ ନିଙ୍ଗେ ଆଜାତେଏଁ, ନୀନୁ ର଼ ଗିରିଗିରା ଗାଟାତି, ଇଟା ହିଲାଆଗାଟାଣି ପାରିନାତି, ମାଟା ହିଲାଆତା଼ଣା ଦା଼ଃଆନାତି ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ଆଡ଼େ ପ଼ଲ୍‌ଆଗାଟି ହ଼ଲେଏଣାତି, ନୀ ଗୂତିତି ହା଼ଡାତଲେ ନୀ ନୀହାଁୟି କିୟାଇଁ, ନା଼ନୁ ଗିରିଗିରା ଗାଟାତେଏଁ, ଇଟାହିଲାଆ ତା଼ଣା ପାରିନାତେଏଁ ମାଟାଆତି ତା଼ଣା ଦା଼ଃଆନାତେଏଁ ଈଦାଆଁ ପୁଞ୍ଜାମାଚି ? ");
INSERT INTO kxv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଆତିହିଁ ଏ଼ନାଆଁତାକି ନା଼ ଟାକାତି ରୀଣା ଅ଼ନାରାକି ହୀଆତି, ନା଼ନୁ ୱା଼ହାନା ଅଡିତଲେ ବେଟାଆ଼ତେଏଁମା । ");
INSERT INTO kxv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ଇଞ୍ଜାଁ ଦାରିତା ନିଚାମାଚାରାଇଁ ୱେସ୍ତେସି, “ଈୱାଣି ତା଼ଣାଟି ଏ଼ ଟାକା ମୀଞ୍ଜା ଅ଼ହାନା ଆମ୍ବାଆରିକି ଦସଟାକା ମାନୁ ଏ଼ୱାଣାକି ହୀଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ଏଚେଟିଏ ଏ଼ୱାରି ୱେସ୍ତେରି, “ପ୍ରବୁ ଏ଼ୱାଣାକି ଦସଟାକା ମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ଆମିନିଗାଟାଣାକି ମାନେ, ଏ଼ୱାଣାକି ଗାଡି ହୀପ୍‌କିଆ଼ନେ । ସାମା ଆମ୍ବାଆରାୱାୟି ହିଲେଏ ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନାୟି ମାନେ ଏ଼ଦାଆଁ ଜିକେଏ ଏ଼ୱାଣି ତା଼ଣାଟି ଅ଼ୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ସାମା ନାଙ୍ଗେ ତାମି ରାଜା ଆ଼ହାଲି କୂହାମାଞ୍ଜାନି ସାତ୍ରୁୟାଁଇଁ ଇମ୍ବାଆଁ ତା଼କା ହାଜାନା ଏ଼ୱାରାଇଁ ନା଼ ନ଼କିତା ଟୂଣ୍‌ହାତୁହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଈ ବାରେ କାତା ୱେସ୍ତି ଡା଼ୟୁ ଜୀସୁ ଜିରୁସାଲମ ୱାକି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଏ଼ୱାସି ଜୀତ ହ଼ରୁ ଦାରିତା ମାନି ବେତନିୟାଁ ଅ଼ଡ଼େ ବେତ୍‌ପାଗି ନା଼ସ୍‌କାଣାଁ ଏଜାନା ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରିଆରାଇଁ ଈ କାତା ୱେସା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ମୀରୁ ହାଜାନା ମୀ ନ଼କିତି ନା଼ୟୁଁତା ହ଼ଡ଼୍‌ଦୁ ଇଞ୍ଜାଁ ଲ଼କୁ ଏଚେଲା ହ଼ଚା ହିଲଅରି; ଇଲେତି ର଼ ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ଦସାମାନାଣି ମେହ୍‌ଦେରି; ଏ଼ଦାଆଁ ଦା଼ୱାଁ ହୁକ୍‌ହା ନା଼ ତା଼ଣା ତାଚିହିଁ ୱା଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଆମ୍ବାଆସି ଏ଼ନାଆଁତାକି ହୁକ୍‌ହିମାଞ୍ଜେରି ଇଞ୍ଜିଁ ୱେଞ୍ଜାତିହିଁ, ଈଦାନି ମା଼ ପ୍ରବୁକି ଲ଼ଡ଼ାମାନେ ଇଞ୍ଜିଁ ୱେହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ଏମ୍ବାଟି ଜୀସୁ ପାଣ୍ତାମାଚାରି ଏ଼ୱାସି ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଏଲେହେଁ ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁତି ଦା଼ୱାଁ ହୁକ୍‌ହିମାଚାଟି ଗା଼ଡ଼୍‌ଦେ ସା଼ୱୁକାରିୟାଁ “ଏ଼ନାଆଁତାକି ହୁକ୍‌ହିମାଞ୍ଜେରି ଇଞ୍ଜିଁ ୱେଚେରି ?” ");
INSERT INTO kxv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ଏ଼ୱାରି ଏଲେଇଚେରି, “ଈଦାନି ମା଼ ପ୍ରବୁକି ଲ଼ଡ଼ାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ଏମ୍ବାଟିଏ ଗା଼ଡ଼୍‌ଦେ ଜୀସୁ ତା଼ଣା ତାଚାନା ଏ଼ଦାନିଲେକ ହିମ୍ବରିକା ପା଼ସାନା ଜୀସୁଇଁ ଲାକ କୁଗିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଅ଼ଡ଼େ ଏ଼ୱାସି ନ଼କିତା ହାଜିମାଚାଟି ଲ଼କୁ ଜିରୁତା ତାମି ହିମ୍ବରିକା ପା଼ସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଜିରୁସାଲମ ଡାଗେ ମାନି ଜୀତ ହ଼ରୁଟି ୱା଼ନି ବେ଼ଲାତା ଏ଼ୱାସି ଇଞ୍ଜାଁ ତାମି ସୀସୁୟାଁ ଜୀସୁ କିତି ବା଼ଡ଼୍‌ୟୁତି କାମାତାକି ମାହାପୂରୁଇଁ ଜହରା କିହିହିଁ ରା଼ହାଁଟି ପା଼ଚୁ ପା଼ଚିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ପ୍ରବୁତି ଦ଼ରୁଟି ଆମିନି ରାଜା ୱା଼ହିମାନେସି ଏ଼ୱାଣାକି ନେହେଁ । ଲାକପୂରୁ ହିତ୍‌ଡ଼ି ଅ଼ଡ଼େ ଲାକପୂରୁତି ମାହାପୂରୁଇଁ ଗାୱୁରମି ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ଏଚେଟିଏ ଲ଼କୁ ମାନ୍ଦାଟି ଏଚରଜା଼ଣା ପାରୁସିୟାଁ ଜୀସୁଇଁ ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ନୀ ସୀସୁୟାଁଇଁ ଲା଼ଗାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, “ଈୱାରି ପାଲେଏ ଆ଼ତିସାରେ, ୱାଲ୍‌କା ହାଲେହେଁ କାଜା ଗିୟାଁତଲେ ଜ଼ଲିତୁମା ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଅ଼ଡ଼େ ଏଚେ଼ତା ଗା଼ଡ଼ା ଡାଗେ ୱା଼ତେସି, ଏଚିବେ଼ଲା ଗା଼ଡ଼ାତି ମେସାନା ଡ଼ୀହିହିଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ନୀନୁ ହାଅ, ନୀନୁ ନୀଞ୍ଜୁ ହିତ୍‌ଡ଼ି ଜିରୁ ପୁଚିହିଁ ଅ଼ଜିତେମା ! ସାମା ଏ଼ଦି ନୀ ତା଼ଣାଟି ଡ଼ୁଗାମାନେ ! ");
INSERT INTO kxv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ଏଚିବେ଼ଲା ମାହାପୂରୁ ନିଙ୍ଗେ ଗେଲ୍‌ପାଲି ଅଣ୍‌ପାମାଞ୍ଜାତେସି ଏ଼ଦାଆଁ ପୁନାଆତାକି ଏଚିବେ଼ଲାତା ନୀ ସାତ୍ରୁୟାଁ ନୀ ସା଼ରିସୁଟୁ କାଜା କ଼ଟା ଦସାନା ମୁଚାନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ଇଞ୍ଜାଁ ନିଙ୍ଗେ ଅ଼ଡ଼େ ନୀ ତା଼ଣା ମାନି ନୀ ମୀର୍‌କାଣି କୁଡ଼୍‌ପୁନା଼ସା କିୟାନେରି, ଅ଼ଡ଼େ ର଼ ୱାଲିତି ଅ଼ର ୱାଲି ଲାକ ତୀରି ଆ଼ହାଲି ହିୟଅରି, ଇଲେତି ଦିନା ୱା଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଏମ୍ବାଟିଏ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନାହାଁ ବେ଼ବାରା କିନାରାଇଁ ଏମ୍ବାଟି ହାସା ପେ଼ର୍‌ହାତୁସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଦାର୍ମୁପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ନା଼ ଇଲୁ ପ୍ରା଼ତାନା ଇଲୁ ଆ଼ନେ, ସାମା ମୀରୁ ଏ଼ଦାଆଁ ଡଂଗାଁୟାଁ ପା଼ୱୁ ମ୍ଣିପ୍‌ହାତୁସ୍ତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ଅ଼ଡ଼େ ଜୀସୁ ଦିନାତାକି ଦିନା ପ୍ରା଼ତାନା ଇଲୁତା ଜା଼ପ୍‌ହି ମାଚେସି, ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଲ଼କୁତି କାଜାରି ତଲେ ଜୀସୁଇଁ ପା଼ୟାଲି ଅଣ୍‌ପିମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ସାମା ଲ଼କୁ ରା଼ହାଁଟି ଏ଼ୱାଣି ଜା଼ପ୍‌ନାଣି ୱେଞ୍ଜିମାଚାକି ଏ଼ୱାରି ଏ଼ନିକିହାଲି ଆ଼ନେ ପାରୁ ବେଟାଆ଼ହି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ର଼ ଦିନା ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ଲ଼କୁଣି ଜା଼ପ୍‌ହି ମାଚେସି, ଅ଼ଡ଼େ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହି ମାଚେସି, ଏଚିବେ଼ଲା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ପ୍ରାଚିନାଙ୍ଗା ତଲେ ୱା଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ନୀନୁ ଆମିନି ଅଦିକାରା ତଲେ ଈ ବାରେ କିହିମାଞ୍ଜି, ଏଲେକିହାଲି ଆମ୍ବାଆସି ଅଦିକାରା ହୀହାମାଞ୍ଜାନେସି, ମାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜିକେଏ ର଼ କାତା ୱେଞ୍ଜାଇଁ, ନାଙ୍ଗେ ୱେସ୍ତାଦୁ ");
INSERT INTO kxv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଜହନଇଁ ବାପ୍ତିସ୍ମ ହୀମୁ ଇଞ୍ଜିଁ ଆମ୍ବାଆସି ଟା଼ଣ୍ତିତେସି, ଲାକପୂରୁଟି କି ମାଣ୍‌ସି ତା଼ଣାଟି ?” ");
INSERT INTO kxv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ଏଚେଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ଜ଼ଲ୍‌କି ଆ଼ତେରି, “ଲାକପୂରୁଟି ଇନାୟି, ଆତିହିଁ ଏ଼ୱାସି ଏଲେଇଞ୍ଜାନେସି ଏ଼ନାଆଁତାକି ଏ଼ୱାଣାଇଁ ନାମାଆତେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ସାମା ମାଣ୍‌ସି ତା଼ଣାଟି ଇନାୟି, ଇଞ୍ଜାଁ ଲ଼କୁ ମାଙ୍ଗେ ୱାଲ୍‌କାତଲେ ପା଼ୟାନେରି, ଇଚିହିଁ ଜହନଇଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ରଅସି ଇଞ୍ଜିଁ ହା଼ରେକା ନାମାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ଏ଼ଦି ଏମ୍ବିଟି ଆ଼ହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ନା଼ନୁ ଆମିନି ଅଦିକାରା ତଲେ କିହିମାଇଁ ନା଼ନୁ ଜିକେଏ ୱେସ୍ତଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ଏମ୍ବାଟିଏ ଜୀସୁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, “ରଅସି ର଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ା କିହାନା କାମା କିନାରାକି ବା଼ଗା ହୀହାନା ହା଼ରେକା ଦିନାତାକି ଅ଼ର ଦେ଼ସାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଅଙ୍ଗୁରି ପା଼ଡ଼େୟି କାମ୍ବି ବେ଼ଲା ଏ଼ୱାସି ତାନି ବା଼ଗା ବେଟାଆ଼ହାଲି ର଼ ହ଼ଲେଏଣାଇଁ ପାଣ୍ତିତେସି, ସାମା ଅଙ୍ଗୁରି ବା଼ଡ଼ାତା କାମାକିନାରି ଏ଼ୱାଣାଇଁ ମା଼ଡା ୱେ଼ଚାନା ୱାର୍‌ଇ କେୟୁଟି ପେ଼ର୍‌ହାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ଏ଼ୱାସି ଅ଼ଡ଼େ ର଼ ହ଼ଲେଏଣାଇଁ ପାଣ୍ତିତେସି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜିକେଏ ୱେ଼ଚାନା ନିନ୍ଦା କିହାଁ ୱାର୍‌ଇ କେୟୁଟି ପେ଼ର୍‌ହା ପାଣ୍ତିତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ଡା଼ୟୁ ଅ଼ଡ଼େ ରଅଣାଇଁ ପାଣ୍ତିତେସି, ସାମା ଏ଼ୱାଣାଇଁ ଜିକେଏ ରା଼ଣାରାକା କିହାନା ବା଼ଡ଼ାତି ପାଙ୍ଗାତା ମେତ୍‌ହାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ଏମ୍ବାଟିଏ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ସା଼ୱୁକାରି ନୀଏଟି ଏ଼ନାଆଁ କିଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା, ନା଼ ଜୀୱୁତି ମୀର୍‌ଏଣାଇଁ ପାଣ୍ତିଇଁ ଆତିହିଁ ଏ଼ୱାଣାଇଁ ମା଼ନି କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ସାମା କାମାକିନାରି ଏ଼ୱାଣାଇଁ ମେସାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି ‘ଈୱାସି ଅଦିକାରା ଗାଟାସି, ଈୱାଣାଇଁ ପା଼ୟାତୁହ୍‌ନ, ଆତିହିଁ ଈ ଅଙ୍ଗୁରି ବା଼ଡ଼ା ମାଙ୍ଗେ ଆୟାନେ ।’ ");
INSERT INTO kxv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ଅଙ୍ଗୁରି ବା଼ଡ଼ା ପାଙ୍ଗାତା ମେତ୍‌ହାନା ପା଼ୟିତେରି ।” “ଆତିହିଁ ଅଙ୍ଗୁରି ବା଼ଡ଼ାତି ସା଼ୱୁକାରି ଏ଼ୱାରାଇଁ ଏ଼ନାଆଁ କିନେସି ? ");
INSERT INTO kxv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ଏ଼ୱାସି ୱା଼ହାନା ଈ କାମା କିନାରାଇଁ ପା଼ୟାତୁହ୍‌ନେସି, ଅ଼ଡ଼େ ଏଟ୍‌କାତାରାକି ଏ଼ ଅଙ୍ଗୁରି ବା଼ଡ଼ା ହୀନେସି ।” ଲ଼କୁ ଈ କାତା ୱେଞ୍ଜାନା ଏଲେଇଚେରି, “ଏଲେକିହିଁ ଆ଼ୱୁଏ ଆ଼ଆପେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ଆତିହିଁ ରା଼ଚାମାନି ଈ ବ଼ଲୁ ଏ଼ନାୟି ? ଇଲୁ କେ଼ପିନାରି ଆମିନି ୱାଲିତି କୂତେରି, ଏ଼ଦି ଇଲୁ କନତି ମୂଲୁ ୱାଲି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଆମ୍ବାଆସି ଏ଼ ୱାଲି ଲାକ ତର୍‌ଗିନେସି, ଏ଼ୱାସି କାଣ୍ତାମୁକା ଆ଼ନେସି; ଇଞ୍ଜାଁ ଏ଼ ୱାଲି ଆମ୍ବାଆରି ମୁହେଁ ତର୍‌ଗିନେ ଏ଼ୱାଣାଇଁ ଗୁଣ୍ତୁଗୁଣ୍ତା କିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ଏଚେଟିଏ ମେ଼ରାପୁନାରି ଅ଼ଡ଼େ କାଜା ପୂଜେରାଙ୍ଗା ଦେବୁଣିଏ ଜୀସୁଇଁ ଆସାଲି ଅଣ୍‌ପିତେରି, ସାମା ଲ଼କୁ ମାନ୍ଦାତି ଆଜିତେରି, ଇଚିହିଁ ଏ଼ୱାସି ଏ଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଏ଼ୱାରାଇଁ ସିନିକିହାନା ୱେସାମାଚେସି ଇଞ୍ଜିଁ ଏ଼ୱାରି ପୁଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ପା଼ଣା ଅ଼ଡ଼େ ବାଡ଼୍‌ୟୁଗାଟି ସା଼ଲୱି କିନାରି କେୟୁତା ଏ଼ୱାଣାଇଁ ହେର୍‌ପାଲି ପାରୁ ପାରୀତେରି, ଇଞ୍ଜାଁ ଏଚରଜା଼ଣା ତା଼ମ୍ବୁ ତାମ୍‌ଙ୍ଗେ ଦାର୍ମୁଗାଟାରି ଇଞ୍ଜିଁ ତ଼ସା କଡିନି ନା଼ଡ଼ିକିନାରି ଜୀସୁଇଁ ତାନି ୱେହ୍‌ନି କାତାତା ଦ଼ହ ଦସାଲି ଏ଼ୱାଣି ତା଼ଣା ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ଏ଼ୱାରି ଜୀସୁଇଁ ୱେଚେରି, “ଗୂରୁ, ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି, ନୀନୁ ଏ଼ନାଆଁ ୱେସାମାଞ୍ଜି ଅ଼ଡ଼େ ଜା଼ପ୍‌ହାମାଞ୍ଜି ଏ଼ଦି ସାତା, ଅ଼ଡ଼େ ଆମ୍ବାଆରାଇଁ ପାର୍‌ଡ଼ା ବାଚି କିଅତି, ସାମା ସାତା ମାହାପୂରୁତି ଜିରୁତି କାତା ଜା଼ପ୍‌ଦି । ");
INSERT INTO kxv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ଆତିହିଁ କାୟିସରକି ସିସ୍ତୁ ହୀନାୟି ମେ଼ରା ମାନେକି ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ସାମା ଜୀସୁ ଏ଼ୱାରି ନା଼ଡ଼ିକିନି ଅଣ୍‌ପୁତି ପୁଞ୍ଜାନା ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ନାଙ୍ଗେ ର଼ ୱେଣ୍ତି ଟାକା ହିୟାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ଏ଼ ୱେଣ୍ତି ଟାକାତା ଆମ୍ବାଆରି ବମା ଅ଼ଡ଼େ ଦ଼ରୁ ମାନେ, ଏ଼ୱାରି ୱେସ୍ତେରି, “କାୟିସରୱାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, “ଆତିହିଁ କାୟିସରୱାୟି ଏ଼ନାୟି ଏ଼ଦାଆଁ କାୟିସରକି ହୀଦୁ; ଇଞ୍ଜାଁ ମାହାପୂରୁୱାୟି ଏ଼ନାୟି ଏ଼ଦାଆଁ ମାହାପୂରୁକି ହୀଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଏଚେଟିଏ ଏ଼ୱାରି ଲ଼କୁ ନ଼କିତା ଏ଼ୱାଣାଇଁ ଏ଼ନି ଦ଼ହ ଦସାଲି ଆ଼ଡାଆତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜୀସୁ ୱେସ୍ତି କାତାତାକି ଆଡାଜାକା ଆ଼ହାନା ପାଲେଏ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ଏମ୍ବାଟିଏ ହା଼ତାରି ୱେଣ୍ତେ ନିଙ୍ଗିନାଣି ନାମିହିଲାଆଗାଟି ଏଚରଜା଼ଣା ସାଦୁକିୟାଁ ଜୀସୁତା଼ଣା ୱା଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଏ଼ ଗୂରୁ ମ଼ସା ମାଙ୍ଗେତାକି ରା଼ଚାମାନେସି, ରଅସି ବୀହା ଆ଼ହାଁ କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତିହିଁ, ଏ଼ୱାଣି ତାୟି ତାନି ଡକ୍ରିନି ଇଟାନା ଏ଼ୱାଣି କୂଡ଼ା ଏ଼ପିକିୟାଲି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ସାତା ଜା଼ଣା ତାୟିୟାଁ ମାଚେରି; କାଜାସି ବୀହା ଆ଼ହାନା କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ଡା଼ୟୁ ଏ଼ୱାଣି ଜେ଼ଚତାସି ଇଟିତେସି, ଅ଼ଡ଼େ ଏ଼ୱାଣି ଜେ଼ଚତାସି ଇଟିତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ଏଲେକିହିଁଏ ସା଼ତା ଜା଼ଣା ଜିକେଏ କକାରି ପ଼ଦାଁ ଆ଼ଆନା ହା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ଡା଼ୟୁ ଏ଼ ଇୟା ଜିକେଏ ହା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଆତିହିଁ ୱେଣ୍ତେ ନିଙ୍ଗିନି ଦିନା ଏ଼ୱାରି ବିତ୍ରାଟି ଏ଼ ଇୟା ଆମ୍ବାଆରି ଡକ୍ରି ଆ଼ନେ ? ଇଚିହିଁ ସାତା ଜା଼ଣା ଜିକେଏ ଏ଼ଦାନି ଇଟାମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଈ ଦାର୍‌ତିତି ଲ଼କୁ ବୀହା କିନେରି ଅ଼ଡ଼େ ଆ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ସାମା ୱା଼ନି ଜୁଗୁତାକି ଇଞ୍ଜାଁ ହା଼କିଟି ନିଙ୍ଗାଲିତାକି ପା଼ଡ଼ା ଆ଼ନାରି ବୀହା ଆ଼ଅରି କି ବୀହା ହୀଅରି; ");
INSERT INTO kxv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଇଚିହିଁ ଏ଼ୱାରି ଦୂତୁୟାଁଲେହେଁ ଆ଼ହାନା ଏଚେଲାୱା ହା଼ଅରି, ଇଞ୍ଜାଁ ହା଼କିଟି ନିଙ୍ଗାମାନାକି ଏ଼ୱାରି ମାହାପୂରୁତି ମୀର୍‌କା ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ସାମା ହା଼ତାରି ସାତେଏ ନିଙ୍ଗିନେରି ଇଞ୍ଜିଁ ମ଼ସାଇଁ ଜିକେଏ ୱେହିମାନି ବୂଟାତି କାବ୍ରୁତଲେ ନେହିଁକିଁ ତ଼ସାମାଚେସି, ଇଚିହିଁ ଏ଼ୱାସି ପ୍ରବୁଇଁ ଅବ୍ରାହାମତି ମାହାପୂରୁ, ଇସାହାକତି ମାହାପୂରୁ ଅ଼ଡ଼େ ଜାକୁବତି ମାହାପୂରୁ ଇଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ଏ଼ୱାସି ହା଼ତାରି ମାହାପୂରୁ ଆ଼ଏ ସାମା ଜୀୱୁଗାଟାରି ମାହାପୂରୁ; ଇଚିହିଁ ମାହାପୂରୁ ନ଼କିତା ବାରେଜା଼ଣା ନୀଡାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଏମ୍ବାଟିଏ ମେ଼ରାପୁନାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ହାଅ, ଗୂରୁ ନୀନୁ ଅଜେ ୱେସ୍ତାତି ।” ");
INSERT INTO kxv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ଅ଼ଡ଼େ ଏ଼ନାଆଁ ୱେଞ୍ଜାଲି ଏ଼ୱାରାକି ସା଼ସା ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, କ୍ରୀସ୍ତ ଦାୱୁଦ ମୀର୍‌ଏସି, ଲ଼କୁ ଏ଼ନିକିଁ ଏଲେଇନେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଇଚିହିଁ ଦାୱୁଦ ତା଼ନୁଏ ପା଼ଚୁ ପତିତା ଏଲେଇଞ୍ଜି ମାନେସି, ପ୍ରବୁ ନା଼ ପ୍ରବୁଇଁ ୱେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ନା଼ନୁ ନୀ ସାତ୍ରୁୟାଁଣି ନୀ କଡାୟାଁ ଡ଼଼ଇ ଇଟାଆ ପାତେକା, ନୀନୁ ନା଼ ଟିଃନିୱାକି କୁଗାମାନାମୁ । ");
INSERT INTO kxv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଦାୱୁଦ ତା଼ନୁଏ ଏ଼ୱାଣାଇଁ ପ୍ରବୁ ଇଞ୍ଜିଁ ମାନେସି; ଆତିହିଁ କ୍ରୀସ୍ତ ଏ଼ନିକିଁ ଏ଼ୱାଣି ମୀର୍‌ଏସି ? ");
INSERT INTO kxv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ଡା଼ୟୁ ବାରେ ଲ଼କୁ ନ଼କିତା ସୀସୁୟାଁଇଁ ୱେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ମେ଼ରା ଜା଼ପ୍‌ନାରି ତା଼ଣାଟି ଜାଗ୍ରାତା ! ଇଚିହିଁ ଏ଼ୱାରି ଲାମ୍ବା ଲାମ୍ବା ହିମ୍ବରିକା ହୁଚାନା ତିର୍‌ୱିହିଁ ରେ଼ଜାଲି, ଅ଼ଡ଼େ ହା଼ଟା ବାଜାରାତା ଜହରା ବେଟାଆ଼ହାଲି, ପ୍ରା଼ତାନା ଇଲ୍‌କାଣା ନେହିଁ ନେହିଁ କୁର୍ଚିୟାଁ ଅ଼ଡ଼େ ବ଼ଜିତା ନେହିଁ ଟା଼ୟୁ ବେଟାଆ଼ହାଲି ଅଣ୍‌ପିନେରି; ");
INSERT INTO kxv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ଏ଼ୱାରି ରା଼ଣ୍ତେଣିସିକା ଇଲୁ ସେନ୍ଦିନେରି ଅ଼ଡ଼େ ଉଜେ ଉଜେଏ ଲାମ୍ବା ଲାମ୍ବା ପ୍ରା଼ତାନା କିନେରି; ଏ଼ୱାରି ହା଼ରେକା ଡଣ୍ତ ବେଟାଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଏଚିବେ଼ଲା ଦ଼ନଗାଟାରି ଦା଼ନା ପେ଼ଡ଼ାତା ତାମି ଦା଼ନା ମେତ୍‌ହି ମାଚାଣି ଜୀସୁ ସିନିକିହିମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଅ଼ଡ଼େ ର଼ କାର୍ମାଗାଟି ରା଼ଣ୍ତେଣି ୱା଼ହାନା ଏମ୍ବାଆଁ ରୀ ଊଣା ତାମ୍ବାତି ଆଦ୍‌ଲି ମେତ୍‌ହାଣି ମେସାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ନା଼ନୁ ମିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଈ କାର୍ମାଗାଟି ରା଼ଣ୍ତେଣି ଗାଡି ଦା଼ନା ହୀହାମାନେ, ");
INSERT INTO kxv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଇଚିହିଁ ଦ଼ନ ଗାଟାରି ତାମି ଗାଡି ଦ଼ନଟି ଇଚାଣି ତାଚାନା ବେଟୁ ହୀହାମାନେରି, ସାମା କାର୍ମାଗାଟି ରା଼ଣ୍ତେଣି ତାନି ହିଲାଆବେ଼ଲାତା ତାଙ୍ଗେ ନୀଡାଲିତାକି ଏ଼ନାୟି ମାଚେ ଏ଼ ବାରେ ହୀହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ଅ଼ଡ଼େ ଆମ୍ବା ଆମ୍ବାଆରି ମାହାପୂରୁ ଇଲୁ ଅ଼ଜି ଅ଼ଜିତି ୱାଲ୍‌କା ଅ଼ଡ଼େ ଦା଼ନା ହୀନାଣି ତଲେ ଅଜିକିଁ ଆଜାମାନେ ଇଞ୍ଜିଁ ଇଞ୍ଜାଲିଏ ଜୀସୁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ମୀରୁ ନୀଏଁ ଏ଼ନା ଏ଼ନାଆଁ ମେସିମାଞ୍ଜେରି, ଦିନା ୱା଼ନେ, ଏଚିବେ଼ଲା ର଼ ୱାଲି ଅ଼ର ୱାଲି ଲାକ ଡ଼ୟେଏ, ଈ ବାରେ ମେଣ୍‌ଙ୍ଗାହାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ଏଚିବେ଼ଲା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଏ଼ ଗୂରୁ ଆତିହିଁ ଈ ବାରେ ଏଚେଲା ଆ଼ନେ ? ଇଞ୍ଜାଁ ଈ ବାରେ ଆମିନି ବେ଼ଲାତା ଆ଼ନେ, ଏ଼ ବେ଼ଲାତି ସିନା ଏ଼ନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଜୀସୁ ଏଲେଇଚେସି, “ଜାଗ୍ରାତା ମୀରୁ ଏ଼ନିକିଁ ଆନ୍ଦା ଆ଼ଅତେରି; ଇଚିହିଁ ହା଼ରେକା ନା଼ ଦ଼ରୁଟି ୱା଼ହାନା ନା଼ନୁ ଏ଼ୱାତେଏଁ ଅ଼ଡ଼େ ଏ଼ ଦିନା ଏଦାତେୟିଏ ଇଞ୍ଜିଁ ଇଞ୍ଜାନେରି; ଏ଼ୱାରି ଜେ଼ଚ ହାଲାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ଇଞ୍ଜାଁ ମୀରୁ ଏଚେ଼ତା ଜୁଜୁ ଇଞ୍ଜାଁ ମେ଼ଲି ଆ଼ହିମାନାଣି ୱେଚିସାରେ ଆଜାଆଦୁ; ଏ଼ନିଇଚିହିଁ ଈ ବାରେ ନ଼କେଏ ଆୟାଲି ଆ଼ନେ, ଆ଼ତିଜିକେଏ ଏଚିବେ଼ଲା ଜୁଗୁ ରା଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଡା଼ୟୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଦେ଼ସା କ଼ପାଟି ଦେ଼ସା, ରା଼ଜି କ଼ପାଟି ରା଼ଜି ମେ଼ଲି ନିଙ୍ଗିନେ, ");
INSERT INTO kxv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ଇଞ୍ଜାଁ ଇମ୍ବାଆଁ ଏମ୍ବାଆଁ ବୂମି ୱୀଡିନେ, ହା଼ରେକା ଟା଼ୟୁତା ମର୍‌ଡ଼ି ଇଞ୍ଜାଁ କାର୍‌ୱୁ ୱା଼ନେ, ଅ଼ଡ଼େ ହା଼ଗୁ ପା଼କାତା ଆଜିହ଼ପେତି ସିନାୟାଁ ତ଼ଞ୍ଜା ଆ଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ସାମା ଈ ବାରେ ଆ଼ଆ ନ଼କେଏ ଲ଼କୁ ମିଙ୍ଗେ ଆସାନା ନା଼ ଦ଼ରୁ ତାକି ନିନ୍ଦା କିହାନା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା, କା଼ୟିଦି ଇଲ୍‌କାଣା, ରାଜା ଇଞ୍ଜାଁ ନୀହାଁୟି କିନାରି ତା଼ଣା ହେର୍‌ପାନେରି; ");
INSERT INTO kxv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ଈଦି ମିଙ୍ଗେତାକି ସା଼କି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ଇଞ୍ଜାଁ ଏ଼ନାଆଁ ଜ଼ଲିଇଁ ଏ଼ନାଆଁ ୱେହ୍‌ଇଁ ଇଞ୍ଜିଁ ତଲିଏ ମ଼ନତା ଅଣ୍‌ପାଆଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମୀ ସାତ୍ରୁୟାଁ ମିଙ୍ଗେ ୱେଣ୍ତେ ଜ଼ଲାଲି କି ୱେସାଲି ଆ଼ଡାଆପେରିୱା ଇଞ୍ଜିଁ ନା଼ନୁ ମିଙ୍ଗେ ଏଚିବେ଼ଲାତା ନେହିଁ ବୁଦି ଅ଼ଡ଼େ ସୁୱା ହିୟାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ସାମା ମୀ ତାଲି ତାଞ୍ଜି ତାୟିୟାଁ ସାମ୍‌ନ୍ଦିୟାଁ ଇଞ୍ଜାଁ ମୀ ତ଼ଣେସିଙ୍ଗା ଜିକେଏ ମିଙ୍ଗେ ହେର୍‌ପାନେରି, ଅ଼ଡ଼େ ମୀ ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରାଇଁ ଇର୍‌ହାନା ପା଼ୟିନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ଇଞ୍ଜାଁ ନା଼ ଦ଼ରୁ ତାକି ବାରେ ଲ଼କୁତା଼ଣା ଲାଜା ବେଟାଆ଼ଦେରି ଅ଼ଡ଼େ ଅ଼ପଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ସାମା ମୀ ତା଼ର୍ୟୁଁତି ର଼ ବା଼ଣା ଜିକେଏ ନସ୍ତ ଆ଼ଏ; ");
INSERT INTO kxv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ଅ଼ର୍‌ହିନି ତା଼ଣାଟି ମୀରୁ ମୀ ଜୀୱୁତି ଗେଲ୍‌ପିକିହା କଡିଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ସାମା ମୀରୁ ଏଚିବେ଼ଲା ସାତ୍ରୁୟାଁ ଜିରୁସାଲମ ଗା଼ଡ଼ାତା ମୁଚାମାନାଣି ମେହ୍‌ଦେରି, ଏଚିବେ଼ଲା ଏ଼ଦି ନା଼ସା ଆ଼ନି କା଼ଲା ଏଦାତେ ଇଞ୍ଜିଁ ପୁଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ଏଚିବେ଼ଲା ଏମିନିଗାଟାରି ଜୀହୁଦା ଦେ଼ସାତା ମାନେରି, ଏ଼ୱାରି ହ଼ର୍‌କାଣା ହଣ୍‌ପାରି; ଇଞ୍ଜାଁ ଏମିନିଗାଟାରି ଗା଼ଡ଼ା ବିତ୍ରା ମାନେରି, ଏ଼ୱାରି ହ଼ଚା ହାଲ୍‌ବେରି; ଏମିନିଗାଟାରି ନା଼ସ୍‌କାଣାଁ ମାନେରି, ଏ଼ୱାରି ଗା଼ଡ଼ାତା ହ଼ଡ଼୍‌ଆପେରି; ");
INSERT INTO kxv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଏ଼ନିଇଚିହିଁ ମାହାପୂରୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନି ବାରେ କାତାଲେହେଁ ଆୟାଲିତାକି ଏ଼ଦି ଡଣ୍ତ ହୀନି କା଼ଲା । ");
INSERT INTO kxv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ଆୟ଼ତା ଏଚିବେ଼ଲା ପୂରାମା଼ସା ଆ଼ହାମାନୁ କି ପା଼ଲୁ ଊଟ୍‌ହିମାନୁ ଏ଼ୱି ଊଣେଏ କସ୍ତ ପା଼ଣ୍‌ନୁକି ! ଏ଼ନିଇଚିହିଁ ଏଚିବେ଼ଲା ଈ ଦାର୍‌ତିତା କାଜା ଡଣ୍ତ ଅ଼ଡ଼େ ଈ ଲ଼କୁତାକି ମାହାପୂରୁତି କ଼ପା ଆ଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଏଚରଜା଼ଣା କାଣ୍ତାତଲେ ଟୂଣ୍‌ୱି ଆ଼ନେରି, ଇଞ୍ଜାଁ ଏଚର ଜା଼ଣାଇଁ ଦସ୍‌ପି କିହାଁ ଏଟ୍‌କା କୂଡ଼ାତି ଲ଼କୁତା଼ଣା ଅ଼ନେରି, ଇଞ୍ଜାଁ ଏଟ୍‌କା ଜା଼ତିତି ଲ଼କୁତି କଲା ଏଆ ପାତେକା ଏ଼ୱାରି କଡାୟାଁ ଡ଼଼ଇ ଜିରୁସାଲମ ଗା଼ଡ଼ା ୱିସ୍‌ପିଆ଼ହିଁ ଡ଼ୟିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ଏମ୍ବାଟିଏ ୱେ଼ଡ଼ା ଲେ଼ଞ୍ଜୁ ଅ଼ଡ଼େ ହୁକାୟାଁ ବିତ୍ରାଟି ଏ଼ନି ଏ଼ନି ସିନାୟାଁ ତ଼ଞ୍ଜାଆ଼ନେ, ସାମ୍‌ଦୁରି ଗାର୍ଜିନାଣି ଇଞ୍ଜାଁ ଏ଼ୟୁ ନିଙ୍ଗିନାଣି ମେସାନା ଦାର୍‌ତିତି ବାରେ ଦେ଼ସାତି ଲ଼କୁ ଆଡାଜାକା ଆ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଇଞ୍ଜାଁ ଦାର୍‌ତିତା ଏ଼ନା ଏ଼ନାୟି ଗଟୱି ଆ଼ହିମାନେ ଇଞ୍ଜିଁ କା଼ଚାନା ଲ଼କୁ ଆଜିତାକି ଜୀୱୁ ପିସ୍ତିଲେହେଁ ଆ଼ନେରି, ଏ଼ନିଇଚିହିଁ ହା଼ଗୁ ପା଼କାତି ବା଼ଡ଼୍‌ୟୁ ବାରେ ୱୀଡିନେ । ");
INSERT INTO kxv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ଏଚିବେ଼ଲା ମାଣ୍‌ସି ମୀର୍‌ଏସି କାଜା ବା଼ଡ଼୍‌ୟୁ ଅ଼ଡ଼େ ଗାୱୁରମି ତଲେ ହା଼ଗୁ ଲାକତି ଦୂନ୍ଦ୍ରାଟି ୱା଼ନାଣି ମେହ୍‌ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ସାମା ଈ ବାରେ ଗଟୱି ଆୟାଲି ମା଼ଟ୍‌ହିସାରେ ମୀରୁ ଲାକ ସିନିକିଦୁ ଏ଼ନିଇଚିହିଁ ମିଙ୍ଗେ ଗେଲ୍‌ପିନି କାତା ଏଜିମାଞ୍ଜାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଅ଼ଡ଼େ ଜୀସୁ ଏ଼ୱାରାଇଁ ର଼ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସ୍ତେସି, “ତ଼ୟା ମା଼ର୍‌ନୁ ଅ଼ଡ଼େ ବାରେ ମା଼ର୍‌କାଣି ସିନିକିଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଏଚିବେ଼ଲା ଏ଼ୱି ଗୱେଡ଼ି ଗା଼ଲ୍‌ନୁ, ଏ଼ ଗୱେଡ଼ି ଗା଼ଲ୍‌ନାଣି ମେସାନା କାରା ୱେ଼ଡ଼ା ୱା଼ତେ ଇଞ୍ଜିଁ ମୀରୁ ପୁଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ଏଲେକିହିଁଏ ମୀରୁ ଈ ବାରେ ମେସାନା ମାହାପୂରୁତି ରା଼ଜି ଏଜିମାଞ୍ଜାନେ ଇଞ୍ଜିଁ ପୁଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ନା଼ନୁ ମିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଈ ବାରେ ଆ଼ଆପାତେକା ଈ କା଼ଲାତି ଲ଼କୁ ଏ଼ନିଜିକେଏ ମେଣ୍‌ଙ୍ଗଅରି । ");
INSERT INTO kxv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ହା଼ଗୁପା଼କା ଦାର୍‌ତି ବାରେ ମେଣ୍‌ଙ୍ଗିନେ, ସାମା ନା଼ ବ଼ଲୁ ଏଚେଲାୱା ମେଣ୍‌ଙ୍ଗାଉ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ଏ଼ଦାଆଁତାକି ମୀରୁ ଜାଗ୍ରାତା ଆ଼ହାନା ମାଞ୍ଜୁ, ଆ଼ଆତିହିଁ ତିନାଣି ଉନାଣି ଅ଼ଡ଼େ ବାତ୍‌କିନି ଅଣ୍‌ପୁ ମୀ ହିୟାଁତା ନେଞ୍ଜିନେ ଅ଼ଡ଼େ ଏ଼ ଦିନା ଦେବୁଣିଏ ପା଼ନ୍ଦାଲେହେଁ ମୀ ମୁହେଁ ୱା଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ଏ଼ନିଇଚିହିଁ ଏ଼ଦି ପା଼ନ୍ଦା ଲେହେଁ ଦାର୍‌ତିତି ବାରେ ଜା଼ତିତି ଲ଼କୁ ମୁହେଁ ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ସାମା ମୀରୁ ଏ଼ନିକିଁ ଈ ବାରେ ୱା଼ହିମାନି ଡଣ୍ତଟି ଗେଲ୍‌ପି ଆ଼ହାଲି ଅ଼ଡ଼େ ମାଣ୍‌ସି ମୀର୍‌ଏଣି ନ଼କିତା ନିଚାଲି ଆ଼ଡିଦେରି, ଏ଼ଦାଆଁତାକି ବାରେବେ଼ଲା କା଼ଚାନା ପ୍ରା଼ତାନା କିହେ଼ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜୀସୁ ଏଚିବେ଼ଲା ପ୍ରା଼ତାନା ଇଲୁତା ଜା଼ପ୍‌ହି ମାଚେସି, ଇଞ୍ଜାଁ ଲା଼ଆଁୟାଁ ଗା଼ଡ଼ାଟି ହ଼ଚା ହାଜାନା ଜୀତ ଇନି ହ଼ରୁତା ମାଣ୍‌ମ୍ବିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ଅ଼ଡ଼େ ବାରେ ଲ଼କୁ ପ୍ରା଼ତାନା ଇଲୁତା ଜୀସୁ କାତା ୱେଞ୍ଜାଲି ଲା଼ଇ ଲାଇସିଏ ରୁଣ୍ତା ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଦ଼ରୁଗାଟି ପୁଲାଏ଼ୟୁ ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁ ଡାଗେ ଆ଼ହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଇଞ୍ଜାଁ କାଜା ପୂଜେରା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି, ଜୀସୁଇଁ ଏ଼ନିକିଁ ପା଼ୟାଲି ଆ଼ଡିନେରି, ଏ଼ଦାଆଁତାକି ପାରୁ ପାରିମାଚେରି, ସାମା ଏ଼ୱାରି ଲ଼କୁଣି ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଏଚିବେ଼ଲା ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ବିତ୍ରାମାନି ଇସ୍କାରିୟତ ଦ଼ରୁଗାଟି ଜୀହୁଦା ହିୟାଁତା ସୟତାନ ହଟେ; ");
INSERT INTO kxv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଅ଼ଡ଼େ ଜୀହୁଦା ହାଜାନା ଏ଼ନିକିଁ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମାହାପୂରୁ ଇଲୁ କା଼ପୁଗାଟି କାଜାରି କେୟୁତା ଆସ୍‌ପି କିନେସି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରିତଲେ କାତାବାର୍ତା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ରା଼ହାଁ ଆ଼ହାନା ଏ଼ୱାଣାକି ଟାକାୟାଁ ହୀହାଲି ଆ଼ଞ୍ଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଅ଼ଡ଼େ ଜୀହୁଦା ରା଼ଜି ଆ଼ହାନା ଲ଼କୁ ହିଲାଆବେ଼ଲାତା ଜୀସୁଇଁ ଏ଼ୱାରି କେୟୁତା ହେର୍‌ପାଲି ପାରୁ ପାରୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ଡା଼ୟୁ ଆମିନି ଦିନା ପୁଲାଏ଼ୟୁ ଆଣ୍ତାଆତି ରୂଟି ତିନି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତାକି ମେ଼ଣ୍ତା ଡା଼ଲ୍‌କାଣି ପୂଜା କିନି ଦିନା ଏତେ; ");
INSERT INTO kxv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଏଚେଟିଏ ଜୀସୁ ପିତର ଅ଼ଡ଼େ ଜହନଇଁ ଈ କାତା ୱେସା ପାଣ୍ତିତେସି, “ମୀରୁ ହାଜାନା ମାଙ୍ଗେତାକି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତାକି ରା଼ନ୍ଦା ୱାଜାଦୁ ମା଼ର ତିନୱା ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ୱେଚେରି, “ମା଼ମ୍ବୁ ଆମ୍ବିୟା ହାଜାନା ରା଼ନ୍ଦା ୱାଜିହାଲାପାରି ଇଞ୍ଜିଁ ନୀନୁ ଅଣ୍‌ପିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଗା଼ଡ଼ା ହଟିସାରେ ଡ଼଼କାତା ଏ଼ୟୁ ଅ଼ହିମାନାଣାଇଁ ମେହ୍‌ଦେରି; ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ ହାଜାନା ଏ଼ୱାସି ଆମିନି ଇଜ ହ଼ଡ଼୍‌ନେସି ଇଲୁ ଗାଟାଣାଇଁ ୱେହ୍‌ଦୁ, ");
INSERT INTO kxv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଗୂରୁ ନିଙ୍ଗ ଇଲେଇଞ୍ଜିଁ ୱେସା ପାଣ୍ତାମାଞ୍ଜାନେସି, ନା଼ନୁ ନା଼ ସୀସୁୟାଁ ତଲେ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି ଏମିନି ଇଲୁତା ତିଇଁ ଏ଼ ବାକ୍ରା ଆମିନାୟି ତ଼ସ୍ତାମୁ ? ");
INSERT INTO kxv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନେହିଁ ତିୟାରା ଆ଼ହାମାନି ଲାକନି ପାରୁତି ର଼ କାଜା ବାକ୍ରା ତ଼ସ୍ତାନେସି; ଏମ୍ବାଆଁ ମାଙ୍ଗେତାକି ରା଼ନ୍ଦା ୱାଜାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ଏ଼ୱାରି ହାଜାନା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଏଲେକିଁ ମେସାନା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ରା଼ନ୍ଦା ୱାଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବେ଼ଲା ଆୟାଲିଏ, ଜୀସୁ ଅ଼ଡ଼େ ତାନି ପାଣ୍ତ୍‌ୱି ଆ଼ତି ସୀସୁୟାଁ ତଲେ ତିଞ୍ଜାଲି କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଦୁକୁ କସ୍ତ ପ୍ଣାଃଆ ନ଼କେଏ ମୀ ତଲେ ଈ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ବ଼ଜି ତିଞ୍ଜାଲି ହା଼ରେକା ଅଣ୍‌ପାମାଚେଏଁ ! ");
INSERT INTO kxv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ଏ଼ନିଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ରା଼ଜିତା ଈ କାତା ବାରେ ପୂରା ଆ଼ଆପାତେକା ନା଼ନୁ ଅ଼ଡ଼େ ଏଚେଲାୱା ଏ଼ଦାଆଁ ତିନଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଇଞ୍ଜାଁ ଏ଼ୱାସି ର଼ ସ଼ଲା ଆସାନା ମାହାପୂରୁଇଁ ଜହରା କିହାନା ଏଲେଇଚେସି, “ମୀରୁ ଈଦାଆଁ ଅ଼ହାନା ମୀ ବିତ୍ରା ବା଼ଟିକିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ରା଼ଜି ୱା଼ଆ ପାତେକା ନା଼ନୁ ନୀଞ୍ଜୁଟିଏ ଅଙ୍ଗୁରି ରାସା ଏଚେଲାୱା ଗହ୍‌ଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଅ଼ଡ଼େ ଏ଼ୱାସି ରୂଟି ଅ଼ହାନା ମାହାପୂରୁଇଁ ଜହରା କିହାଁ ଡ଼ିକ୍‌ହାନା ହୀହାଁ ଏଲେଇଚେସି, “ମିଙ୍ଗେତାକି ହୀପ୍‌କି ଆ଼ହାମାନି ନା଼ ଆଙ୍ଗା ଈଦି; ନାଙ୍ଗେ ଅଣ୍‌ପାଲି ଈଦାଆଁ କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଏଲେକିହିଁଏ ତିଚି ଡା଼ୟୁ ଏ଼ୱାସି ଗହ୍‌ନି ସ଼ଲା ଆସାନା ଏଲେଇଚେସି, “ଈ ସ଼ଲାତା ମିଙ୍ଗେତାକି ୱା଼କ୍‌ହିମାନି ନା଼ ନେତେରିତି ପୁଃନି ରା଼ଜିମା଼ନା ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ସାମା ମେହ୍‌ଦୁ ଆମ୍ବାଆସି ନାଙ୍ଗେ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିମାଞ୍ଜାନେସି, ଏ଼ୱାସି ନା଼ ତଲେ ବ଼ଜିତା କୁଗାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ଏ଼ନିଇଚିହିଁ ମାହାପୂରୁ ତୀରି କିହାମାଚି ଲେହେଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ହା଼ନେସି, ସାମା ଏ଼ୱାଣାଇଁ ସାତ୍ରୁ ତା଼ଣା ହେର୍‌ପିନେସି ଆୟ଼ତା ଏ଼ୱାସି ଊଣେଏ ଡଣ୍ତ ବେଟା ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ମା଼ ବିତ୍ରାଟି ଆମ୍ବାଆସି ଇଲେତି କାମା କିନେସି ଇଞ୍ଜିଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଜ଼ଲ୍‌କି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଇଞ୍ଜାଁ ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆସି କାଜାସି ଆ଼ନେସି ଇଞ୍ଜିଁ ସୀସୁୟାଁ ବିତ୍ରା ଆସ୍‌ପି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଟ୍‌କା କୂଡ଼ାତି ରାଜାୟାଁ ଏ଼ୱାରି ମୁହେଁ ସା଼ଲୱି କିନେରି, ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି ଏ଼ୱାରାଇଁ ସା଼ଲୱି କିନେରି, ଏ଼ୱାରି ଲ଼କୁତା଼ଣା ନେହାଁରି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗାଲି ଅଣ୍‌ପିନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ସାମା ମୀ ବିତ୍ରା ଏଲେଆ଼ଆଦୁ ଇଚିହିଁ ମୀ ବିତ୍ରା ଆମ୍ବାଆସି କାଜାସି ଏ଼ୱାସି ଊଣା ଆ଼ପେସି, ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ସା଼ଲୱି କିନାସି ଏ଼ୱାସି ସେ଼ବା କିନାସି ଆ଼ପେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଆମ୍ବାଆସି କାଜାସି ? ତିଞ୍ଜାଲି କୁଗିନାସି କାଜାସି କି ସେ଼ବା କିନାସି କାଜାସି ? ତିଞ୍ଜାଲି କୁଗିନାସି କାଜାସି ଆ଼ଏକି ? ସାମା ନା଼ନୁ ମୀ ବିତ୍ରା ସେ଼ବା କିନାତେଏଁଲେହେଁ ଆ଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ସାମା ମୀରୁ ନା଼ ବାରେ କସ୍ତତା ନା଼ ତଲେ ମାଞ୍ଜାମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ଇଞ୍ଜାଁ ନା଼ ଆ଼ବା ଏ଼ନିକିଁ ନାଙ୍ଗେ ସା଼ଲୱି କିହାଲି ପା଼ଣା ହୀହାମାଞ୍ଜାନେସି, ନା଼ନୁ ଜିକେଏ ଏଲେକିହିଁଏ ମିଙ୍ଗେ ହିୟାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଏ଼ନିକିଁ ମୀରୁ ନା଼ ରା଼ଜିତା ନା଼ ତଲେ କୁଗାନା ତିଞ୍ଜେରି, ଇଞ୍ଜାଁ ସିଂଗାସାଣିତା କୁଗାନା ଇସ୍ରାୟେଲତି ବା଼ର କୂଡ଼ାତି ସା଼ଲୱି କିଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ସିମନ, ସିମନ ମେହ୍‌ମୁ ସୟତାନ ଗ଼ହଁ ହା଼ଣିକିନିଲେହେଁ ସୟତାନ ମାହାପୂରୁ ତା଼ଣାଟି ହେଲ ବେଟାଆ଼ହାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ସାମା ନୀ ନାମୁ ଏ଼ନିକିଁ ମେଣ୍‌ଙ୍ଗେଏ, ଈଦାଆଁତାକି ନା଼ନୁ ନୀ ତାକି ପ୍ରା଼ତାନା କିତେଏଁ; ଇଞ୍ଜାଁ ନୀନୁ ନେହିଁ ଆ଼ହାନା ୱେଣ୍ତାସାରେ ନୀ ତାୟିୟାଣି ତୀର୍‌ପୁକିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ସାମା ପିତର ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ନୁ ନୀ ତଲେ କା଼ୟିଦିତା ହାଜାଲି ଅ଼ଡ଼େ ହା଼ହାଲି ଜିକେଏ ଆଣ୍ତାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ ପିତର ନା଼ନୁ ଏଲେଇଞ୍ଜିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ କୟୁ କେ଼ଣ୍‌ଆ ନ଼କେଏ ନୀନୁ ନାଙ୍ଗେ ତୀନିପା଼ଲି ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ୱେହ୍‌ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଚିବେ଼ଲା ନା଼ନୁ ମିଙ୍ଗେ ଡାବୁୟାଁ ମ଼ଣା ଇଞ୍ଜାଁ ସେପୁୟାଁ ଅ଼ଆନା ହାଜୁ ଇଞ୍ଜିଁ ପାଣ୍ତା ମାଞ୍ଜାତେଏଁ ଏ଼ ବେ଼ଲା ମିଙ୍ଗେ ଏ଼ନାୟି ଊଣା ଆୟାତେକି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ଏ଼ନାୟି ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ସାମା ନୀଏଁ ଆମ୍ବାଆରାକି ଡାବୁୟାଁ ମାନୁ ଏ଼ୱାସି ଏ଼ୱାଆଁ ଅ଼ପେସି, ଏଲେକିହିଁଏ ମ଼ଣା ଜିକେଏ ଅ଼ପେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆରାକି କାଣ୍ତା ହିଲେଏ ଏ଼ୱାସି ତାନି ହିମ୍ବରି ପାର୍‌ଚାନା କଡାପେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ମାହାପୂରୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନାୟି ସାତେଏ ନାଙ୍ଗେତାକି ଆ଼ନାୟି ମାନେ, ଏ଼ୱାସି ପା଼ପୁ ଗାଟାରି ତଲେ ଲେକା ଆ଼ନେସି, ଏଲେଆ଼ହିଁଏ ଏ଼ ବାରେ ନାଙ୍ଗେ ଏଜାତାଚିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ଇମ୍ବାଆଁ ରୀ କାଣ୍ତା ମାନୁ ।” ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏଲେଇଚେସି, “ହାଅ, ଏ଼ୱିଏ ସା଼ରି ଆ଼ନୁ ଇଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଏ଼ୱାସି ଗା଼ଡ଼ାଟି ହ଼ଚା ହାଜାନା ତା଼ନୁ ହାଲ୍‌ୱିତିଲେହେଁ ଜୀତ ହ଼ରୁତା ହାଚେସି, ଅ଼ଡ଼େ ସୀସୁୟାଁ ଜିକେଏ ଏ଼ୱାଣି ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଏମ୍ବାଆଁ ଏଜାନା ଏ଼ୱାସି ତାନି ସୀସୁୟାଁଇଁ ୱେସ୍ତେସି, “ମୀରୁ ଏ଼ନିକିଁ ପା଼ନ୍ଦାତା ହେର୍‌ୱି ଆ଼ଅତେରି, ଈଦାଆଁତାକି ପ୍ରା଼ତାନା କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରି ତା଼ଣାଟି ହିରେ ହେକ ହାଜାନା ମେଣ୍ତାକୁତାନା ପ୍ରା଼ତାନା କିହିଁ ୱେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ଏ଼ ଆ଼ବା ନୀନୁ ମ଼ନ କିତିହିଁ ଈ ଦୁକୁ କସ୍ତ ନା଼ ତା଼ଣାଟି ଗୁଚି କିମୁ; ସାମା ନା଼ ମ଼ନ କଡ଼େ ଆ଼ଏ ନୀ କାତେଏ ଆ଼ପେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ଅ଼ଡ଼େ ଲାକପୂରୁତି ର଼ ଦୂତୁ ତ଼ଞ୍ଜାଆ଼ହାନା ଏ଼ୱାଣାକି ବା଼ଡ଼୍‌ୟୁ ହୀତେ । ");
INSERT INTO kxv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଏଚେଟିଏ ଏ଼ୱାସି ହା଼ରେକା ଦୁକୁ ତଲେ ଅ଼ଡ଼େ ଗାଡିକିହିଁ ପ୍ରା଼ତାନା କିତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଗା଼ମା ନେତେରିଲେହେଁ ବୂମିତା ତର୍‌ଗିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଅ଼ଡ଼େ ଏ଼ୱାସି ପ୍ରା଼ତାନାଟି ନିଙ୍ଗା ୱା଼ହାନା ତାନି ସୀସୁୟାଁଣି ଦୁକୁ ତଲେ ଇଦା କିତାଣି ମେସ୍ତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁତାକି ଡୂରାମାଞ୍ଜେରି ? ପା଼ନ୍ଦାତା ଏ଼ନିକିଁ ହେର୍‌ୱଅତେରି ଏ଼ଦାଆଁତାକି ନିଙ୍ଗାନା ପ୍ରା଼ତାନା କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଏ଼ୱାସି ଜ଼ଲିମାଚାଟି ର଼ ମାନ୍ଦା ଲ଼କୁ ଏମ୍ବାଆଁ ଏଗା ୱା଼ତେରି, ଅ଼ଡ଼େ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ବିତ୍ରାଟି ଜୀହୁଦା ଦ଼ରୁଗାଟାସି ଏ଼ୱାରି ନ଼କିତା ୱା଼ହାନା ଜୀସୁଇଁ ନଣ୍ତାଲି ତାନି ତା଼ଣା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଜୀହୁଦା ନଣ୍ତାନା ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ଏମ୍ବାଟିଏ ଜୀସୁତଲେ ମାଚାରି ଈଦି ଏ଼ନାୟି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଜୀସୁଇଁ ଏଲେଇଚେରି, “ଏ଼ ପ୍ରବୁ ମା଼ମ୍ବୁ ଈୱାରାଇଁ କାଣ୍ତାତଲେ ପା଼ୟିନମି କି ?” ");
INSERT INTO kxv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ଅ଼ଡ଼େ ଏ଼ୱାରି ରଅସି କାଜା ପୂଜେରା ହ଼ଲେଏଣାଇଁ ଇର୍‌ହାନା ତାନି ଟିଃନି କିର୍ୟୁଁ ଦା଼ଚାତୁସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଇଚେକେଏ ଆ଼ତେ” ଇଞ୍ଜାନା ଏ଼ୱାଣି କିର୍ୟୁଁ ଡୀଗାନା ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଅ଼ଡ଼େ ଜୀସୁ ତାଙ୍ଗେ ଆସାଲି ୱା଼ହାମାଚି କାଜା ପୂଜେରା, ମାହାପୂରୁ ଇଲୁତି କା଼ପୁଗାଟାରି ଅ଼ଡ଼େ ଲ଼କୁତି କାଜାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ସ଼ରୁଇଁ ଆହ୍‌ନିଲେହେଁ ଈଟା କାଣ୍ତା ଅ଼ଡ଼େ ଟେଙ୍ଗାୟାଁ ଆସାନା ୱା଼ହାମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ନା଼ନୁ କା଼ଲେଏ ମୀ ତଲେ ମାହାପୂରୁ ଇଲୁତା ମାଚେଏଁ, ଏଚିବେ଼ଲା ମୀରୁ ନାଙ୍ଗେ ଆସ୍ତାଆତେରି; ସାମା ଈ ଦିନା ମୀଦିଏ ଅ଼ଡ଼େ ଆନ୍ଦେରିତି ବା଼ଡ଼୍‌ୟୁ ରା଼ଜିକିନି ଦିନା ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ଡା଼ୟୁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଅ଼ହାନା କାଜା ପୂଜେରା ଇଜ ତାତେରି; ସାମା ପିତର ହେକ ମାଞ୍ଜାନା ଜେ଼ଚ ଜେ଼ଚ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ଅ଼ଡ଼େ ଏ଼ୱାରି ଆଂଗେଣିତା ହିଚୁ ଡାସାନା ହିଚୁ ସା଼ରିସୁଟୁ କୁଗିତେରି, ଇଞ୍ଜାଁ ପିତର ଜିକେଏ ଏ଼ୱାରିତଲେ କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ଏମ୍ବାଟିଏ ର଼ ହ଼ଲେଣି ପିତର ହିଚୁ ମାଣ୍ତାତା କୁଗାମାନାଣି ମେସାନା, ଏ଼ୱାଣାଇଁ ସିନିକିହାନା ଏଲେଇଚେ, “ଈୱାସି ଜିକେଏ ଏ଼ୱାଣିତଲେ ମାଚାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ସାମା ପିତର ଏଲେଇଚେସି, “ଆ଼ଏକା ନା଼ନୁ କଡ଼େ ଏ଼ୱାଣାଇଁ ପୁଣ୍‌ମ୍ବୁଏ ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଅ଼ଡ଼େ ଗା଼ଡ଼େକା ହାଜାଲିଏ ଅ଼ଡ଼େ ରଅସି ଏଲେଇଚେସି, “ନୀନୁ ଜିକେଏ ଏ଼ୱାରି ବିତ୍ରାଟି ରଅତି ।” ସାମା ପିତର ଏଲେଇଚେସି, “ଆ଼ଏ ତାୟି ନା଼ନୁ କଡ଼େ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ଅ଼ଡ଼େ ର଼ ଗଂଟା ହାଜାଲିଏ ଅ଼ର ରଅସି ଏଲେଇଚେସି, “ସାତେଏ ଈୱାସି ଏ଼ୱାରିତଲେ ମାଚାସି, ଏ଼ନିଇଚିହିଁ ଈୱାସି ଗାଲିଲି ଦେ଼ସାତାସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ସାମା ପିତର ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ଇଞ୍ଜିମାଞ୍ଜି ତାୟି ନା଼ନୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜିହିଲଅଁ ।” ଏ଼ ଦେବୁଣିଏ କୟୁ କେ଼ଣ୍‌ତେ; ");
INSERT INTO kxv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ଏମ୍ବାଟିଏ ପ୍ରବୁ ମୂମ୍ବୁ ପେର୍‌ହାନା ପିତରଇଁ ସିନିକିତେସି; ଏମ୍ବାଟିଏ ନୀଞ୍ଜୁ କୟୁ କେ଼ଣ୍‌ଆ ନ଼କେଏ ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜାଦି, ପ୍ରବୁ ୱେସ୍ତି ଈ କାତା ତାନି ମ଼ନତା ୱା଼ତେ, ");
INSERT INTO kxv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ଇଞ୍ଜାଁ ଏ଼ୱାସି ପାଙ୍ଗାତା ହାଜାନା ଗାଡି ଦୁକୁ ଆ଼ହାନା ଡ଼ୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଅ଼ଡ଼େ ଆମିନିଗାଟାରି ଜୀସୁଇଁ ଆସା ଇଟାମାଚେରି, ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେ଼ଚି ୱେ଼ଚିହିଁ କାକ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଅ଼ଡ଼େ ଏ଼ୱାଣି ମୂମ୍ବୁତା ହିମ୍ବରି ପ୍ଡିକ୍‌ହାନା ୱେଚେରି, “ନୀନୁସାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି ! ୱେସ୍ତାମୁ ନିଙ୍ଗେ ଆମ୍ବାଆସି ୱେତାତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଅ଼ଡ଼େ ଏ଼ୱାରି ହା଼ରେକା କାତା ଏ଼ୱାଣି କ଼ପାଟି ଜ଼ଲାନା ଏ଼ୱାଣି ନିନ୍ଦାକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଲା଼ଇ ୱେ଼ୟାଲିଏ ଲ଼କୁତି କାଜାରି, କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ରୁଣ୍ତା ଆ଼ହାନା ତାମି ବେ଼ରଣିମାଣ୍ତାତା ଜୀସୁଇଁ ଅ଼ହାନା ୱେଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ନୀନୁ କ୍ରୀସ୍ତତିକି ମାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାସାରେ ମୀରୁ ନାମଅତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ଅ଼ଡ଼େ ନା଼ନୁ ୱେଞ୍ଜାତିହିଁ ମୀରୁ ୱେସାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ସାମା ନୀଏଁଟିଏ ମାଣ୍‌ସି ମୀର୍‌ଏସି ବା଼ଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ଟିଃନି ଟଟତା କୁଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ଏମ୍ବାଟିଏ ବାରେଜା଼ଣା ୱେଚେରି, “ଆତିହିଁ ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତିକି ?” ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁତ ୱେସିମାଞ୍ଜାଦେରି, ନା଼ନୁ ଏ଼ୱାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଏଚେଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ମାଙ୍ଗେ ଅ଼ଡ଼େ ଏ଼ନି ସା଼କି ଲ଼ଡ଼ା, ମା଼ରତ ଈ କାତା ତାନି ଗୂତିଟିଏ ୱେଚାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ଏଚେଟିଏ ଡା଼ୟୁ ବାରେଜା଼ଣା ନିଙ୍ଗାନା ଜୀସୁଇଁ ପିଲାତ ନ଼କିତା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜୀସୁ କ଼ପାଟି ଦ଼ହ ଦସାନା ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ପୁଚମି ଈୱାସି ମା଼ କୂଡ଼ାତି ଲ଼କୁଣି ପ଼ଲ୍‌ଆ ଜା଼ପ୍‌ହିମାନେସି, ଇଚିହିଁ ଈୱାସି କାୟିସରକି ସିସ୍ତୁ ହୀଆଦୁ, ତା଼ନୁ ନା଼ନୁଏ କ୍ରୀସ୍ତ ଅ଼ଡ଼େ ରାଜାତେଏଁ ଇଞ୍ଜିଁ ୱେସା କଡିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ଏଚେଟିଏ ପିଲାତ ଜୀସୁଇଁ ୱେଚେସି, “ନୀନୁ କି ଜୀହୁଦି ଲ଼କୁତି ରାଜାତି ?” ଜୀସୁ ୱେସ୍ତେସି, “ନୀନୁତ ୱେସିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ଏଚେଟିଏ ପିଲାତ କାଜା ପୂଜେରା ଅ଼ଡ଼େ ବାରେ ଲ଼କୁଣି ଏଲେଇଚେସି, “ନା଼ନୁ ଈୱାଣି ତା଼ଣା ଏ଼ନି ଦ଼ହ ପ୍ଣାଃଆତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ସାମା ଏ଼ୱାରି ଗାଡିକିହିଁ ଜ଼ଲିତେରି, “ଈୱାସି ଗାଲିଲିଟିଏ ମା଼ଟ୍‌ହାନା ଇମ୍ବା ପାତେକା ବାରେ ଜୀହୁଦା ଦେ଼ସାତି ଲ଼କୁଣି ଜା଼ପ୍‌ହାନା ଲାଗେଏ କିହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ସାମା ପିଲାତ ଈ କାତା ୱେଞ୍ଜାନା ୱେଚେସି, “ଈୱାସି ଗାଲିଲିତାସିକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାସି ହେରଦ ରାଜା ରା଼ଜି ତାସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ହେରଦ ତା଼ଣା ପାଣ୍ତିତେସି, ଏ଼ନିଇଚିହିଁ ଏଚିବେ଼ଲା ହେରଦ ଜିରୁସାଲମତା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରଦ ଜୀସୁଇଁ ମେସାନା ହା଼ରେକା ରା଼ହାଁ ଆ଼ତେସି, ଏ଼ନିଇଚିହିଁ ଏ଼ୱାସି ଏ଼ୱାଣି କାତା ୱେଞ୍ଜା ମାଚାକି ଏ଼ୱାଣାଇଁ ହା଼ରେକା ଦିନାଟିଏ ମେସାଲି ମ଼ନ କିହିମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ତା଼ଣାଟି ଏ଼ନି କାବାଆ଼ନି କାମାକିନାଣି ମେହ୍‌ଇଁ ଇଞ୍ଜିଁ ଆ଼ସା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ହେରଦ ଜୀସୁଇଁ ଏ଼ନି ଏ଼ନି କାତାୟାଁ ୱେଚେସି, ସାମା ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏ଼ନି କାତାୱା ୱେଣ୍ତେ ୱେହ୍‌ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ସାମା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ନିଚାନା ଏ଼ୱାଣି କ଼ପାଟି ଆଜିହ଼ପେତି କାତାୟାଁ ଜ଼ଲିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ଏଚେଟିଏ ହେରଦ ତାନି କ଼ସ୍‌କା ତଲେ ଏ଼ୱାଣାଇଁ କାକ୍‌ହି କାକ୍‌ହିହିଁ ନିନ୍ଦାକିତେରି ଏଚେଟିଏ ର଼ ପା଼ଟୁ ହିମ୍ବରି ଏ଼ୱାଣାଇଁ ହୁଚି କିହାନା ପିଲାତ ତା଼ଣା ୱେଣ୍ତେ ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ଏ଼ ଦିନାଟିଏ ପିଲାତ ଅ଼ଡ଼େ ହେରଦ ତ଼ଣେ ଆ଼ତେରି; ଏ଼ୱାରି ନ଼କେଏ ସାତ୍ରୁୟାଁଲେହେଁ ମେସ୍‌ପି ଆ଼ୱିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ଏମ୍ବାଟିଏ ପିଲାତ କାଜା ପୂଜେରା ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ଅ଼ଡ଼େ ବାରେ ଲ଼କୁଇଁ ହା଼ଟି କିହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ଈୱାସି ଲ଼କୁଣି ପ଼ଲ୍‌ଆ ଜା଼ପ୍‌ହିମାନେସି ଇଞ୍ଜିଁ ମୀରୁ ନା଼ ତା଼ଣା ତାତେରି; ସାମା ନା଼ନୁ ଏ଼ୱାଣାଇଁ ମୀ ନ଼କିତା ତାୟିପାରି କିତେଏଁ ଇଞ୍ଜାଁ ମୀରୁ ୱେସାମାଞ୍ଜାତି ଏ଼ନି ଦ଼ହ ଏ଼ୱାଣି ତା଼ଣା ପ୍ଣାଃଆତେଏଁ, ଇଞ୍ଜାଁ ହେରଦ ଜିକେଏ ପ୍ଣାଃଆତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଏ଼ନିଇଚିହିଁ ହେରଦ ଅ଼ଡ଼େ ୱେଣ୍ତେ ନା଼ ତା଼ଣା ପାଣ୍ତାତେସି; ଇଞ୍ଜାଁ ମେହ୍‌ଦୁ ଈୱାସି ହା଼ନି ଡଣ୍ତ ପା଼ଣ୍‌ନି ଏ଼ନି ଦ଼ହୱା କିହାହିଲଅସି; ");
INSERT INTO kxv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଈୱାଣାଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ଚାନା ପିହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ବେ଼ଲା କାୟିଦି ମାନାରି ବିତ୍ରାଟି ରଅଣାଇଁ ଏ଼ୱାରାକି ପିସାଲି ମେ଼ରା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ସାମା ଏ଼ୱାରି ରହେଁଏ ଗାଡିକିହିଁ ଏଲେଇଚେରି, “ଈୱାଣାଇଁ ପା଼ୟାଦୁ ବାରବାଇଁ ମାଙ୍ଗେ ପିସାହିୟାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ଈ ବାରବାଇଁ ଗା଼ଡ଼ାତି ଗଡ଼୍‌ହା ତାକି ଇଞ୍ଜାଁ ରଅଣାଇଁ ପା଼ୟାମାଚାକି କା଼ୟିଦି ଇଟାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ସାମା ପିଲାତ ଜୀସୁଇଁ ପିସାଲି ଅଣ୍‌ପାନା ଲ଼କୁ ମାନ୍ଦାତି ଅ଼ଡ଼େ ପୁଣ୍‌ମ୍ବି କିହାଲି ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ସାମା ଏ଼ୱାରି କାଜା ହା଼ଡାତଲେ ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ଦୁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ଦୁ ଇଞ୍ଜିଁ ଇଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଅ଼ଡ଼େ ତୀନି ପା଼ଲି ୱେସ୍ତେସି, “ଏ଼ନାଆଁତାକି, ଏ଼ୱାସି ଏ଼ନି ଦ଼ହ କିହାମାନେସି ? ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନି ହା଼ନିହ଼ଗେତି ଦ଼ହ ପ୍ଣାଃଆତେଏଁ; ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାଣାଇଁ ସା଼ସ୍ତି ହୀହାନା ପିହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ସାମା ଏ଼ୱାରି କାଜା ଗିୟାଁତଲେ ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ୱେସ୍ତେରି, ଡା଼ୟୁ ଏ଼ୱାରି ୱେସ୍ତାୟିଏ ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ଇଞ୍ଜାଁ ଏ଼ୱାରି ୱେସ୍ତିଲେହେଁଏ କିୟାଲି ପିଲାତ ହୁକୁମି ହୀତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ସାମା ଆମିନିଗାଟାସି ଗଡ଼୍‌ହା ଅ଼ଡ଼େ ଲ଼କୁଣି ପା଼ୟାଲିଏ କା଼ୟିଦିତା ଇଟାମାଚାଣାଇଁ ରୀସା ମାଚେରି ପିସ୍ତେସି, ଅ଼ଡ଼େ ଜୀସୁଇଁ ଏ଼ୱାସି ଏ଼ୱାରି ଅଣ୍‌ପିତି ଲେହେଁ କିୟାଲି ଏ଼ୱାରିତା଼ଣା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ଏ଼ୱାରି ଜୀସୁଇଁ ଅ଼ହିମାଚାଟି ସିମନ ଦ଼ରୁଗାଟି କୁରିଣି ଦେ଼ସାତି ର଼ ନା଼ୟୁଁଟି ୱା଼ହିମାଚେସି, ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସିମୁଣ୍ତା ଡେ଼କି କିହାନା ଜୀସୁ ଜେ଼ଚ ଜେ଼ଚ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ମାନ୍ଦା ଲ଼କୁ ଜୀସୁ ଜେ଼ଚ ହାଜିମାଚେରି ଅ଼ଡ଼େ ତାନି ତାକି ବକତା ୱେ଼ଚା କଡିହିଁ ଡ଼ୀହି ଡ଼ୀହିଁ ଏଚରଜା଼ଣା ଇୟାସିକା ଜିକେଏ ଏ଼ୱାଣି ଜେ଼ଚ ହାଜିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ସାମା ଜୀସୁ ଏ଼ୱାସିକାୱାକି ସିନିକିହାନା ଏଲେଇଚେସି, “ଆଲ, ଜିରୁସାଲମତି ମା଼ସ୍‌କାତେରି ନା଼ ତାକି ଡ଼ୀଆଦୁ ସାମା ମୀ ତାକି ଅ଼ଡ଼େ ମୀ କକାରି ପ଼ଦାଁ ତାକି ଡ଼ୀଦୁ; ");
INSERT INTO kxv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ହେଣ୍ତୁ ଇଲେତି ଦିନା ୱା଼ହିମାନେ, ଆମ୍ବାଆୟି ବା଼ଞ୍ଜେଣିସିକା, ଆମ୍ବାଆୟି ଏଚେଲା ପୂରାମା଼ସା ଆ଼ହାହିଲାଉ ଅ଼ଡ଼େ ପା଼ଲୁ ଊଟ୍‌ହା ହିଲାଉ ଲ଼କୁ ଏ଼ୱାସିକାଣି ମିଙ୍ଗେଏ ନେହେଁ ଇଞ୍ଜାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ଏଚିବେ଼ଲା ଲ଼କୁ ହ଼ର୍‌କାଣି ଏଲେଇନେରି ମା଼ ଲାକ ତର୍‌ଗାଦୁ ଅ଼ଡ଼େ ଊଣା ହ଼ର୍‌କାଣି ଏଲେଇନେରି ମାଙ୍ଗେ ପ୍ଡିକ୍‌ହାନା ଡ଼ୁକ୍‌ହାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଏ଼ନିଇଚିହିଁ ଲ଼କୁ ହିଇଲି ମା଼ର୍‌ନୁତି ଏଲେକିତିହିଁ, ଏ଼ଦି ୱା଼ୟିସାରେ ଏ଼ଦାଆଁ କିହାଁ ଆଗାଡ଼ା କିଅରିକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଦ଼ହଗାଟାରି ରିଆରି ଜିକେଏ ପା଼ସି ଏକ୍‌ହାଲି ଜୀସୁତଲେ ଅ଼ୱିଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ତା଼ର୍ୟୁଁଗିର୍ପା ଇନି ଟା଼ୟୁତା ଏଜାନା ଏମ୍ବାଆଁ ଜୀସୁଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ଏ଼ ରୀ ଦ଼ହଗାଟାରି ବିତ୍ରାଟି ରଅଣାଇଁ ଏ଼ୱାଣି ଟିଃନିୱାକି ଅ଼ଡ଼େ ରଅଣାଇଁ ଏ଼ୱାଣି ଟେ଼ବ୍ରିୱାକି ପା଼ସି ଏକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ଏଚିବେ଼ଲା ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ ଆ଼ବା ଏ଼ୱାରି ଦ଼ହ ଆହ୍‌ଆନି, ଇଚିହିଁ ଏ଼ୱାରି ଏ଼ନାଆଁ କିହିମାନେରି ଏ଼ଦାଆଁ ପୁଞ୍ଜାହିଲଅରି ।” ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣି ହିମ୍ବରି ବା଼ଟିକିହାଲି ପାଦି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ ନିଚାନା ସିନିକିହିମାଚେରି, ଏ଼ୱାରି ବିତ୍ରାଟି କାଜାରି ଜିକେଏ ନିନ୍ଦାକିହିଁ ଏଲେଇଚେରି, “ଏ଼ୱାସି ଏଟ୍‌କା ଲ଼କୁଣି ଗେଲ୍‌ପିତେସି; ଏ଼ୱାସି ମାହାପୂରୁ ଆ଼ଚିତି କ୍ରୀସ୍ତ ଇଚିହିଁ ତା଼ନୁଏ ତାଙ୍ଗେ ଗେଲ୍‌ପିକିହା କଡାପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","କ଼ସ୍‌କା ଜିକେଏ ଏ଼ୱାଣି ଡାଗେ ହାଜାନା ପୁଲାଏ଼ୟୁ ଗସାଲି ହୀହାଁ ଏ଼ୱାଣାଇଁ କାକ୍‌ହିହିଁ ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ନୀନୁ ଜୀହୁଦି ଲ଼କୁତି ରାଜାତି ଇଚିହିଁ ନୀନୁଏ ନିଙ୍ଗେ ପିସ୍‌ପି କିହାକଡାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଇଞ୍ଜାଁ ଏ଼ୱାଣି ପା଼ସିମୁଣ୍ତା ଲାକ ଇଲେଇଞ୍ଜିଁ ରା଼ସ୍‌କି ଆ଼ହାମାଚେ, “ଈୱାସି ଜୀହୁଦି ଲ଼କୁତି ରାଜା ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ଅ଼ଡ଼େ ପା଼ସି ମୁଣ୍ତାତା ପା଼ସି ଏକ୍‌ହାମାଚି ଦ଼ହଗାଟାରି ବିତ୍ରାଟି ଜିକେଏ ରଅସି ଏ଼ୱାଣାଇଁ ନିନ୍ଦାକିହିଁ ଏଲେଇଚେସି, “ନୀନୁ କ୍ରୀସ୍ତତି ଆ଼ଏକି ? ନିଙ୍ଗେ ଅ଼ଡ଼େ ମାଙ୍ଗେ ପିସ୍‌ପି କିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ସାମା ଅ଼ଡ଼େ ରଅସି ଏ଼ୱାଣାଇଁ ଦାକା ହୀହାନା ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ୱାଣିଲେହେଁ ଡଣ୍ତ ବେଟାଆ଼ହିଁ ଜିକେଏ ନିଙ୍ଗେ ମାହାପୂରୁଇଁ ଆଜି ହିଲେଏ ? ");
INSERT INTO kxv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଅ଼ଡ଼େ ମା଼ରସା ନୀହାଁୟି ତଲେ ଡଣ୍ତ ବେଟାଆ଼ହି ମାନାୟି, ଇଚିହିଁ ମା଼ କିତି କାମାତି ପା଼ଡ଼େୟି ବେଟାଆ଼ହି ମାନାୟି; ସାମା ଈୱାସି ଏ଼ନି ଦ଼ହ କିହାହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଜୀସୁଇଁ ଏଲେଇଚେସି, “ଏ଼ ଜୀସୁ ନୀନୁ ନୀ ରା଼ଜିତା ହାଚିସାରେ ନାଙ୍ଗେ ଅଣ୍‌ପାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ ନୀନୁ ଲାକପୂରୁତା ନା଼ ତଲେ ମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ଏଚିବେ଼ଲା ସମାନା ବା଼ରଗଂଟା ଆ଼ହାମାଚେ, ଅ଼ଡ଼େ ୱେ଼ଡ଼ା ଉଜେଡ଼ି ହୀଆତାକି ତୀନି ଗଂଟା ପାତେକା ଦେ଼ସା ବାରେ ଆନ୍ଦେରି ଆ଼ହାମାଚେ, ");
INSERT INTO kxv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା ଲେଚାମାନି ହିମ୍ବରି ରୀ ବା଼ଗା ଆ଼ହିଁ ଗେଞ୍ଜା ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଅ଼ଡ଼େ ଜୀସୁ କାଜା ଗିୟାଁତଲେ ହା଼ଟିହିଁ ଏଲେଇଚେସି, “ଏ଼ ଆ଼ବା ନୀ କେୟୁତା ନା଼ ଜୀୱୁତି ହେର୍‌ପିମାଞ୍ଜାଇଁ !” ଏଲେଇଞ୍ଜି ଜ଼ଲାନା ତାନି ଜୀୱୁ ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ଏ଼ଦାଆଁ ମେସାନା ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ମାହାପୂରୁଇଁ ଜହରା କିହିଁ ଏଲେଇଚେସି, “ଈୱାସି ସାତେଏ ତୀରିଗାଟାସି ମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ମେସାଲି ରୁଣ୍ତା ଆ଼ହାମାଚି ବାରେ ଲ଼କୁ ଈ ବାରେ ମେସାନା ବକତା ୱେ଼ଚା କଡିହିଁ ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ସାମା ଜୀସୁଇଁ ପୁଞ୍ଜାମାଚି ବାରେ ଲ଼କୁ ଇଞ୍ଜାଁ ଗାଲିଲିଟି ରହେଁଏ ଆଣ୍ତାନା ତାନି ଜେ଼ଚ ଜେ଼ଚ ୱା଼ହାମାଚି ଇୟାସିକା ହେକ ନିଚାନା ଏ଼ ବାରେ ସିନିକିହିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଇଞ୍ଜାଁ ଜୀହୁଦି ଦେ଼ସାତି ହାରାମାତିୟା ଇନି ଗା଼ଡ଼ାତି ଜସେପ ଇନାସି ଜୀହୁଦି ଲ଼କୁତି କାଜା କୁଲମିତି ରଅସି ମାଚେସି; ଏ଼ୱାସି ନେହାଁସି ଇଞ୍ଜାଁ ତୀରିଗାଟାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଜୀହୁଦାତି ହାରାମାତିୟା ଇନି ନା଼ୟୁଁତି ଜସେପ ଇନାସି ର଼ ମାଣ୍‌ସି ମାଚେସି । ଏ଼ୱାସି ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜାଁ ମା଼ନି ଗାଟାସି ମାଚେସି ଅ଼ଡ଼େ ମାହାପୂରୁତି ରା଼ଜି ୱା଼ନାଣି କା଼ଚିମାଚେସି । କାଜା ବେ଼ରଣିତି ମାଣ୍‌ସି ମାଚିହିଁ ଜିକେଏ, ଏ଼ୱାସି ଏ଼ୱାରି କାତା ଅ଼ଡ଼େ କାମାତା ଆଣ୍ଡିହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ଏ଼ୱାସି ପିଲାତ ତା଼ଣା ହାଜାନା ଜୀସୁ ମାଡ଼୍‌ହାତି ରୀସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଇଞ୍ଜାଁ ମାଡ଼୍‌ହାତି ରେ଼ପ୍‌ହାନା ନେହିଁ ପା଼ତାଡ଼ା ହିମ୍ବରି ରୂପାନା ଏମ୍ବାଆଁ ହ଼ରୁତା କା଼ର୍‌ହାମାଚି ଏଚେଲା ଆମ୍ବାଆରି ମୁସାହିଲାଆ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ଏ଼ୱାଣାଇଁ ମୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ଏ଼ ଦିନା ତିୟାରା ଆ଼ନି ଦିନା ମାଚେ ଅ଼ଡ଼େ ଜ଼ମିନି ଦିନା ଏଗା ୱା଼ହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଅ଼ଡ଼େ ଗାଲିଲିଟି ୱା଼ହାମାନି ଇୟାସିକା ଜେ଼ଚ ଜେ଼ଚ ହାଜାନା ମାହ୍‌ଣି ମାଣ୍ତା ଅ଼ଡ଼େ ତାନି ମାଡ଼୍‌ହା ଏ଼ନିକିଁ ମୁସାମାଚାଣି ମେସ୍ତୁ, ");
INSERT INTO kxv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ଇଞ୍ଜାଁ ଏ଼ୱି ୱେଣ୍ତା ହାଜାନା ଗାନ୍ଦା ନିୟୁଁ ଇଞ୍ଜାଁ ଗାନ୍ଦାଗାଟି ଆ଼ସ୍ତି ତିୟାରା କିତୁ । ଇଞ୍ଜାଁ ଜ଼ମିନି ଦିନାତା ତାମି ମେ଼ରାଲେହେଁ ଜ଼ମିତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ଅ଼ଡ଼େ ଜ଼ମିନି ଦିନାତି ମେ଼ରା ତଲେ ଜ଼ମିତୁ, ସାମା ୱା଼ରାତି ତଲିତି ଦିନାତା ଜୁଲୁପୁଲୁ ୱେ଼ୟାଲିଏ ଏ଼ୱି ତା଼ମ୍ବୁ କିହାମାଚି ଗାନ୍ଦାନିୟୁଁ ଆସାନା ମାହ୍‌ଣି ମାଣ୍ତାତା ହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଇଞ୍ଜାଁ ମାହ୍‌ଣି ମାଣ୍ତାତା ପ୍ଡିକ୍‌ହାମାଚି ୱାଲି ଗୁଚା ଆ଼ହାମାନାଣି ମେସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ସାମା ଏ଼ୱି ବିତ୍ରା ହାଜାନା ପ୍ରବୁ ଜୀସୁତି ମାଡ଼୍‌ହା ଏମ୍ବାଆଁ ମେହ୍‌ଆତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ଏ଼ୱି ଏ଼ଦାଆଁତାକି ବିଲ୍‌କି ଆ଼ହିମାଚି ଦେବୁଣିଏ ମ୍ଣିହ୍‌ନି ହିମ୍ବରି ହୁଚାମାଚି ରିଆରି ଏ଼ୱାସିକା ନ଼କିତା ନିଚାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ଏମ୍ବାଟିଏ ଏ଼ୱି ଆଡାଜାକା ଆ଼ହାନା ବୂମିତା ତା଼ର୍କା ଲେ଼ସ୍ତୁ ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାସିକାଣି ଏଲେଇଚେରି, “ମୀରୁ ଏ଼ନାଆଁତାକି ହା଼ତାରି ବିତ୍ରାଟି ନୀଡାମାନାରାଇଁ ପାରିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଏ଼ୱାସି ଇମ୍ବାଆଁ ହିଲଅସି, ଏ଼ୱାସି ନିଙ୍ଗାମାନେସି, ଏ଼ୱାସି ଗାଲିଲିତା ମାଚାଟି ୱେସାମାଞ୍ଜାତାଣି ଅଣ୍‌ପାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ମାଣ୍‌ସି ମୀର୍‌ଏସି ପା଼ସି ମୁଣ୍ତାତା ହା଼ୟାଲି ପା଼ପୁ ଗାଟାରି ତା଼ଣା ହେର୍‌ପି ଆ଼ନାୟି ମାନେ ଇଞ୍ଜାଁ ତୀନି ଦିନାଟିଏ ହା଼କିଟି ୱେଣ୍ତେ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ଏମ୍ବାଟିଏ ଏ଼ୱି ଏ଼ୱାଣି ୱେସ୍ତି କାତା ଅଣ୍‌ପିତୁ, ");
INSERT INTO kxv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଇଞ୍ଜାଁ ଏ଼ୱି ମାହ୍‌ଣି ମାଣ୍ତାଟି ୱେଣ୍ତା ହାଜାନା ଏଗାର ଜା଼ଣା ସୀସୁୟାଁ ଅ଼ଡ଼େ ଏଟ୍‌କା ତାରାଇଁ ଈ ବାରେ କାତା ୱେସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଏ଼ୱି ମଗ୍‌ଦଲିନି ମରିୟମ, ଜହାନା, ଜାକୁବ ତାମି ଇୟା ମରିୟମ ଅ଼ଡ଼େ ଏ଼ୱାସିକାତଲେ ମାଚି ଏଟ୍‌କାତି ଇୟାସିକା; ଈୱି ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ଈ ବାରେ କାତା ୱେସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ସାମା ଈ ବାରେ କାତା ଏ଼ୱାରି ନ଼କିତା ମ଼ନତା ଗା଼ଡ଼ିକିତି ର଼ ପୁସ୍‌ପନି ଲେହେଁ ଆ଼ତେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାସିକାଣି ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ସାମା ପିତର ନିଙ୍ଗାନା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ହଟି ହଟିହିଁ ହାଚେସି, ଇଞ୍ଜାଁ କାପାନା ସିନିକିତେସି ଏମ୍ବାଆଁ ପା଼ତାଡ଼ା ହିମ୍ବରିକା ମେସ୍ତେସି, ଇଞ୍ଜାଁ ଈଦି ଏ଼ନି ଆ଼ତେ ଇଞ୍ଜିଁ କାବାଆ଼ହାନା ତାମି ଇଜ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ଏ଼ ନେ଼ଚୁ ଏ଼ୱାରି ବିତ୍ରାଟି ରିଆରି ଜିରୁସାଲମଟିଏ ଏଗାର କିଲମିଟରଲେହେଁ ହେକ ମାଚି ଇମାୟୁ ଇନି ନା଼ୟୁଁତା ହାଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଅ଼ଡ଼େ ହାଜି ହାଜିହିଁ ଈ ବାରେ କାତା ଜ଼ଲ୍‌କି ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ଏଲେକିଁ ୱେସ୍‌ପି ଆ଼ହିଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଜ଼ଲ୍‌କି ଆ଼ହିମାଚାଟି ଜୀସୁ ତା଼ନୁଏ ଏ଼ୱାରିତା଼ଣା ୱା଼ହାନା ଏ଼ୱାରିତଲେ ହାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ମେସ୍ତି ଜିକେଏ ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଜୀସୁ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀରୁ ହାଜି ହାଜିହିଁ ଏ଼ନା ଏ଼ନାଆଁ ଜ଼ଲ୍‌କି ଆ଼ହିମାଞ୍ଜେରି ?” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ମୂମ୍ବୁ ୱା଼ଡ଼ି କିହାନା ନିତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଅ଼ଡ଼େ ଏ଼ୱାରି ବିତ୍ରାଟି କ୍ଲେୟାପା ଇନାସି ରଅସି ଏ଼ୱାଣାଇଁ ୱେସ୍ତେସି, “ଈ ୱା଼ରା ବିତ୍ରା ଜିରୁସାଲମତା ଏ଼ନା ଏ଼ନାୟି ଆ଼ତେ ଏମ୍ବାଆଁ ମାନାରି ବିତ୍ରାଟି ନୀନୁ ରଅତିଏ ପୁଞ୍ଜାହିଲଅତିକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଏ଼ନା ଏ଼ନାୟି ଆ଼ତେ ?” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେସ୍ତେରି, “ନା଼ଜରିତ ଜୀସୁତି କାତା; ମାହାପୂରୁ ନ଼କିତା ଅ଼ଡ଼େ ବାରେ ଲ଼କୁ ନ଼କିତା ଏ଼ ଜୀସୁ କାମାତା ଅ଼ଡ଼େ କାତାତା ର଼ ବାଡ଼୍‌ୟୁଗାଟି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଅ଼ଡ଼େ ମା଼ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ସା଼ଲୱି କିନାରି ଏ଼ୱାଣାଇଁ ହା଼କି ଡଣ୍ତ ହୀହାଲି ହେର୍‌ପାନା ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟିତି କାତା । ");
INSERT INTO kxv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ସାମା ଏ଼ୱାସି ଇସ୍ରାୟେଲ ଲ଼କୁଣି ପିସ୍‌ପି କିନାସି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ଆ଼ସା କିହାମାଚମି; ସାମା ଈ ବାରେ ଆ଼ହାନା ନୀଞ୍ଜୁଟିଏ ତୀନିଦିନା ଆ଼ହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଅ଼ଡ଼େ ଜିକେଏ ମା଼ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଇୟାସିକା ମାଙ୍ଗେ ଆଡାଜାକା କିହାମାଞ୍ଜାନୁ; ଏ଼ୱି ଲାଇସିଏ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ହାଜାମାଚୁ, ");
INSERT INTO kxv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ଏମ୍ବାଆଁ ଏ଼ୱି ଏ଼ୱାଣି ମାଡ଼୍‌ହା ମେହ୍‌ଆନା ୱା଼ହାନା ୱେସ୍ତାତୁ, ଇଞ୍ଜାଁ ଦୂତୁୟାଁ ତ଼ଞ୍ଜାଆ଼ହାନା ୱେସ୍ତାତେରି, ଏ଼ୱାସି ନୀଡାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଅ଼ଡ଼େ ମା଼ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁତା ହାଜାନା ଇୟାସିକା ୱେସ୍ତିଲେହେଁଏ ମେସ୍ତେରି ସାମା ଏ଼ୱାଣାଇଁ ମେହ୍‌ଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଡ଼େ ବୁଦି ହିଲାଆଗାଟାତେରି, ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ବାରେ କାତାତି ନାମାଲି ଆ଼ଡାଆଲେହେଁତି ହିୟାଁ ଗାଟାତେରି, ");
INSERT INTO kxv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","କ୍ରୀସ୍ତ ଈ ବାରେ କସ୍ତ ବେଟାଆ଼ହାନା ତାନି ଗାୱୁରମିତା ହ଼ଡ଼ନାୟି ହିଲାଆତେ କି ?” ");
INSERT INTO kxv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ମ଼ସା ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ମା଼ଟ୍‌ହାନା ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ତାନି ତାକି ରା଼ସ୍‌କି ଆ଼ହାମାନି ବାରେ କାତା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପୁଣ୍‌ମ୍ବି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଏ଼ୱାରି ହାଜିମାଚି ନା଼ୟୁଁ ଡାଗେ ଏଜାଲିଏ ଜୀସୁ ଅ଼ଡ଼େ ନ଼କିତା ହାନି ଅଣ୍‌ପୁ ତ଼ସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଆ଼ଂଗିହିଁ ଏଲେଇଚେରି, “ମା଼ ତଲେ ଡ଼ୟାହାଲାମୁ ଏ଼ନିଇଚିହିଁ ଆନ୍ଦେରି ଆ଼ହିମାନେ, ୱେଡ଼ାହାଚେୟିଏ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରିତଲେ ଡ଼ୟାଲି ଇଲୁ ବିତ୍ରା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଅ଼ଡ଼େ ଏ଼ୱାରିତଲେ ରା଼ନ୍ଦା ତିଞ୍ଜାଲି କୁଗିତି ଡା଼ୟୁ ଏ଼ୱାସି ରୂଟି ଆସାଁ ମାହାପୂରୁଇଁ ଜହରା କିତେସି, ଇଞ୍ଜାଁ ଡ଼ିକ୍‌ହାନା ଏ଼ୱାରାକି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ଏମ୍ବାଟିଏ ଏ଼ୱାରି କାଣ୍‌କା ଦେପିଆ଼ତୁ ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପୁଚେରି; ଅ଼ଡ଼େ ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସି ଏ଼ୱାରି କାଣ୍‌କାତା ତ଼ଞ୍ଜା ଆ଼ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ଏଚେଟିଏ ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଏଲେଇଚେରି, “ଏଚିବେ଼ଲା ଜିରୁତା ଏ଼ୱାସି ମାଙ୍ଗେ ଜିରୁତା କାତାବାର୍ତା ଆ଼ହିମାଚେସି ଅ଼ଡ଼େ ମାଙ୍ଗେ ଦାର୍ମୁ ସା଼ସ୍ତେରି ତେଲ୍‌ହି କିହିମାଞ୍ଜାତେସି, ଏଚିବେ଼ଲା ମା଼ ହିୟାଁ କା଼ଡି ମାଞ୍ଜାଆତେ କି ?” ");
INSERT INTO kxv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ଅ଼ଡ଼େ ଏ଼ୱାରି ଦେବୁଣିଏ ନିଙ୍ଗାନା ଜିରୁସାଲମତା ୱେଣ୍ତା ହାଜାନା କୂଡ଼ା ଆ଼ହାମାଇଁ ଏଗାର ଜା଼ଣା ସୀସୁୟାଁ ଅ଼ଡ଼େ ଏ଼ୱାରି ଆଟ୍‌ହିତାରାଇଁ ମେସ୍ତେରି; ");
INSERT INTO kxv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ଏ଼ୱାରି ଏଲେଇଞ୍ଜିମାଚେରି, “ପ୍ରବୁ ସାତେଏ ନିଙ୍ଗାମାନେସି ଅ଼ଡ଼େ ସିମନଇଁ ତ଼ଞ୍ଜାଆ଼ତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜିକେଏ ଜିରୁତି ବାରେ କାତା ଅ଼ଡ଼େ ରୂଟି ଡ଼ିକ୍‌ହାଟିଏ ଏ଼ୱାରି ପୁଞ୍ଜାଲି ଆ଼ଡିତମି ଇଞ୍ଜିଁ ଏ଼ୱାରି ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ସାମା ଏ଼ୱାରି ଈ ବାରେ କାତା ଜ଼ଲ୍‌କି ଆ଼ହିମାଚାଟି ଜୀସୁ ଏ଼ୱାରି ମାଦି ନିଚାନା ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ବୂତୁ ମେସ୍ତମି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଆଡାଜାକା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ହିୟାଁତା ଏ଼ନାଆଁତାକି ଆଜିମାଞ୍ଜେରି, ଇଞ୍ଜାଁ ମୀ ହିୟାଁ ଏ଼ନାଆଁତାକି ଆନାମାନା ଆ଼ହିମାନେ ? ");
INSERT INTO kxv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ନା଼ନୁଏ ଏ଼ୱାତେଏଁ ନା଼ କେସ୍କା କଡାୟାଁ ମେହ୍‌ଦୁ, ନାଙ୍ଗେ ଡୀଗାଦୁ ମୀରୁ ନାଙ୍ଗେ ଊଙ୍ଗା ପେ଼ଣ୍‌କା ମାନାଣି ମେସ୍ତିଲେହେଁ ବୂତୁକି ହିଲାଉ ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଞ୍ଜାନା ଏ଼ୱାରାଇଁ ତାନି କେସ୍କା କଡାୟାଁ ତ଼ସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଏଲେଜିକେଏ ଏ଼ୱାରି ରା଼ହାଁତାକି ନାମାଲି ଆ଼ଡାଆନା ଆନାମାନା ଆ଼ହାଁ କାବା ଆ଼ହିମାଚାକି ଜୀସୁ ଏଲେଇଚେସି, “ମିଙ୍ଗେ ଇମ୍ବାଆଁ ଏ଼ନି ରା଼ନ୍ଦା ମାନେକି ?” ");
INSERT INTO kxv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାକି ର଼ ୱାସ୍ତି ମୀନୁ ହୀତେରି, ");
INSERT INTO kxv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ଦାଆଁ ଆସାନା ଏ଼ୱାରି ନ଼କିତା ତିଚେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମ଼ସାତି ମେ଼ରା ପତିତା ଇଞ୍ଜାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପତିତା ଅ଼ଡ଼େ ପା଼ଚୁ ପତିତା ନାଙ୍ଗେତାକି ଏ଼ନାୟି ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଏ଼ ବାରେ ସାତା ଆ଼ନାୟି ମାନେ, ନା଼ନୁ ମୀ ତଲେ ମାଚାଟି ଈ ବାରେ ୱେସାମାଞ୍ଜାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ନିକିଁ ଦାର୍ମୁ ସା଼ସ୍ତେରି ତେଲ୍‌ହାଲି ଆ଼ଡିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ହିୟାଁତି ଦା଼ରା ଦେତେସି; ");
INSERT INTO kxv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଲେଆ଼ହିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, କ୍ରୀସ୍ତ ଦୁକୁ କସ୍ତ ବେଟା ଆ଼ନେସି ଅ଼ଡ଼େ ତୀନି ଦିନାଟିଏ ହା଼ତାରି ତା଼ଣାଟି ୱେଣ୍ତେ ନିଙ୍ଗିନେସି, ");
INSERT INTO kxv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଇଞ୍ଜାଁ ଜିରୁସାଲମଟିଏ ମା଼ଟ୍‌ହାନା ବାରେ କୂଡ଼ା ତା଼ଣା ଏ଼ୱାଣି ଦ଼ରୁଟି ପା଼ପୁ ମ୍ଣେପ୍‌କି ଆୟାଲି ମ଼ନ ୱେଟ୍‌ନି କାତା ୱେ଼କ୍‌ନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ମୀରୁ ଈ ବାରେତାକି ସା଼କି ଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଅ଼ଡ଼େ ହେଣ୍ତୁ ଆ଼ବା ଏ଼ନାଆଁ ଆ଼ଞ୍ଜାମାନେସି ଏ଼ଦାଆଁ ନା଼ନୁ ମୀ ତା଼ଣା ପାଣ୍ତିମାଞ୍ଜାଇଁ, ସାମା ଲାକପୂରୁଟି ବା଼ଡ଼୍‌ୟୁ ପ୍ଣାଃଆ ପାତେକା ମୀରୁ ଈ ଗା଼ଡ଼ାତେଏ ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ବେତନିୟାଁ ପାତେକା ଅ଼ତେସି ଇଞ୍ଜାଁ ତାନି କେସ୍କା ପେର୍‌ହାନା ଏ଼ୱାରାଇଁ ବ଼ର ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ବ଼ର ହୀହି ହୀହିଁ ଏ଼ୱାସି ଏ଼ୱାରି ତା଼ଣାଟି ଏଟ୍‌କା ଆ଼ହାନା ଲାକପୂରୁ ଅ଼ୱିଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ଜହରା କିହାନା ହା଼ରେକା ରା଼ହାଁତଲେ ଜିରୁସାଲମତା ୱେଣ୍ତା ହାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ଇଞ୍ଜାଁ ଏ଼ ଦିନାଟିଏ କା଼ଲେଏ ମାହାପୂରୁ ଇଲୁତା ମାଞ୍ଜାନା ମାହାପୂରୁଇଁ ଜହରା କିହେ଼ମାଚେରି ।");
INSERT INTO kxv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ମୂଲୁଏ ବ଼ଲୁ ମାଚେ, ବ଼ଲୁ ମାହାପୂରୁ ତଲେ ମାଚେ, ଏ଼ ବ଼ଲୁଏ ମାହାପୂରୁ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ମୂଲୁଏ ଏ଼ ବ଼ଲୁ ମାହାପୂରୁ ତଲେ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ଏ଼ ବ଼ଲୁ ତଲେ ମାହାପୂରୁ ବାରେ ଗା଼ଡ଼ିକିତେସି; ଅ଼ଡ଼େ ଏ଼ନାୟି ବାରେ ଗା଼ଡ଼ି ଆ଼ହାମାନେ, ଏ଼ ବିତ୍ରାଟି ରଣ୍ତି ଜିକେଏ ଏ଼ ବ଼ଲୁ ପିସ୍‌ପେ ରା଼ଚି ଆ଼ହା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ଏ଼ ବ଼ଲୁତା ଜୀୱୁ ମାଚେ ଅ଼ଡ଼େ ଏ଼ ଜୀୱୁ ମାଣ୍‌ସିୟାଁତି ଉଜେଡ଼ି । ");
INSERT INTO kxv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ଏ଼ ଉଜେଡ଼ି ଆନ୍ଦେରିତା ଡ଼ୀଞ୍ଜିହିଁ ୱା଼ହିମାନେ, ଇଞ୍ଜାଁ ଆନ୍ଦେରି ଏ଼ଦାଆଁ ଏଚେଲା ଜିକେଏ ଅ଼ପାହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ମାହାପୂରୁ ତା଼ଣାଟି ତାନି କାବ୍ରୁ ୱେହ୍‌ନାଣାଇଁ ପାଣ୍ତାତେସି; ଏ଼ୱାଣି ଦ଼ରୁ ଜହନ । ");
INSERT INTO kxv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ଏ଼ୱାସି ଉଜେଡ଼ିତି କାତା ଲ଼କୁଇଁ ୱେସାଲି ୱା଼ତେସି, ଅ଼ଡ଼େ ଏ଼ନିକିହିଁ ବାରେଜା଼ଣା ଏ଼ୱାଣି ତା଼ଣାଟି ନାମିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ସା଼କି ହୀହାଲି ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଏ଼ୱାସିଏ ତା଼ନୁଏ ଉଜେଡ଼ି ହିଲାଆତେସି; ସାମା ଏ଼ୱାସି ଏ଼ ଉଜେଡ଼ିତି କାତା ୱେସାଲି ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଏମିନି ସାତା ଉଜେଡ଼ି ବାରେ ଲ଼କୁକି ଉଜେଡ଼ି ହୀନେ, ଏ଼ୱାସି ଦାର୍‌ତିତା ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ଏ଼ୱାସି ଦାର୍‌ତିତା ମାଚେସି ଅ଼ଡ଼େ ଏ଼ୱାଣି ତା଼ଣାଟି ଦାର୍‌ତି ବାରେ ରା଼ଚି ଆ଼ତେ, ଆ଼ତିଜିକେଏ ଈ ଦାର୍‌ତି ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ଏ଼ୱାସି ତାନି ରା଼ଜିତା ୱା଼ତେସି, ଆ଼ତିଜିକେଏ ତାନି ଜାହାରା ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଆବାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ଆମ୍ବାଆରି ଏ଼ୱାଣାଇଁ ଆବିତେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣି ତା଼ଣା ନାମିତେରି; ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ମାହାପୂରୁତି ମୀର୍‌କା ମା଼ସ୍‌କା ଆ଼ହାଲି ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ମାଣ୍‌ସିତି ତାଞ୍ଜିୟାଁ ତା଼ଣାଟି ଜାର୍ନା ଆ଼ତାକି ଏ଼ୱାରି ମାହାପୂରୁତି ମୀର୍‌କା ଆ଼ହାହିଲଅରି, ମାହାପୂରୁ ତା଼ନୁଏ ଏ଼ୱାରି ତାଞ୍ଜି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଅ଼ଡ଼େ, ଏ଼ ବ଼ଲୁ ମାଣ୍‌ସି ୱା଼ଣା ଆ଼ତେ, ମାହାପୂରୁତି କାର୍ମା ଇଞ୍ଜାଁ ସାତା ତଲେ ମା଼ ତା଼ଣା ବାସା କିତେସି, ଅ଼ଡ଼େ ଆ଼ବା ତା଼ଣାଟି ୱା଼ହାମାନି ରଣ୍ତିଏ ମୀର୍‌ଏଣାତି ଗାୱୁରମି ଲେହେଁ ମା଼ର ଏ଼ୱାଣି ଗାୱୁରମି ମେସ୍ତାୟି । ");
INSERT INTO kxv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଜହନ ଏ଼ୱାଣି କାତାତି ସା଼କି ହୀହାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ ଡା଼ୟୁ ୱା଼ହିମାନେସି, ଏ଼ୱାସି ନା଼ କିହାଁ କାଜାସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାସି ନା଼ନୁ ଜାର୍ନାଆ଼ତି ନ଼କେଏ ମାଚେସି, ଇଞ୍ଜିଁ ଏ଼ୱାଣି କାତା ନା଼ନୁ ତଲିଏ ଏଲେଇଞ୍ଜି ୱେସାମାଞ୍ଜାତେଏଁ, ଏ଼ୱାସିଏ ଈୱାସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ଏ଼ଦାଆଁତାକି ତା଼ନୁ ପୂରା କିନି ତା଼ଣାଟି ମା଼ର ବାରେ ଜା଼ଣାତାୟି ବାରେ ବେଟାଆ଼ହାନା, କାର୍ମା ମୁହେଁ କାର୍ମାମେହ୍‌ନାଣି ବେଟାଆ଼ହାମାନାୟି । ");
INSERT INTO kxv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ମାହାପୂରୁ ମ଼ସା ତା଼ଣାଟି ମେ଼ରା ହିୟାତେସି, ସାମା ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣାଟି କାର୍ମାମେହ୍‌ନାୟି ଅ଼ଡ଼େ ସାତା ୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ଆମ୍ବାଆସି ଏଚେଲା ମାହାପୂରୁଇଁ ମେସାହିଲଅସି, ତାନିତଲେ ମାନି ରଣ୍ତିଏ ମୀର୍‌ଏସି ଏ଼ୱାସି ମାହାପୂରୁ ଆ଼ବାଇଁ ପୁଣ୍‌ମ୍ବି କିହାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ନୀନୁ ଆମ୍ବାଆତି ଇଞ୍ଜିଁ ଜହନଇଁ ୱେଞ୍ଜାଲି ଜୀହୁଦିୟାଁ ଏଚିବେ଼ଲା ଜିରୁସାଲମଟି କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ଲେ଼ବିୟଙ୍ଗାଣି ଜହନ ତା଼ଣା ପାଣ୍ତିତେରି, ଏ଼ୱାସି ଈ କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଜହନ ସାତା କାତା ୱେସ୍ତେସି, ଆ଼ଏ ଇଞ୍ଜିଁ ଇନାଆତେସି, ତୀର୍‌ପୁତଲେ ୱେସ୍ତେସି, “ନା଼ନୁ ମସିହା ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, ଆତିହିଁ “ନୀନୁ ଆମ୍ବାଆତି ? ନୀନୁ ଏ଼ନାଆଁ ଏଲିୟତି କି ?” ଜହନ ଏଲେଇଚେସି, “ନା଼ନୁ ଏଲିୟତେଏଁ ଆ଼ଏ ।” ଏ଼ୱାରି ୱେଚେରି, “ନୀନୁ ଏ଼ନାଆଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି କି ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମାଙ୍ଗେ ୱେସ୍ତାମୁ, ମା଼ମ୍ବୁ ମାଙ୍ଗେ ପାଣ୍ତା ମାଞ୍ଜାନାରାଇଁ ଏ଼ନି କାତା ୱେହ୍‌ନମି । ନୀନୁ ଆମ୍ବାଆତେଏଁ ଇଞ୍ଜିଁ ୱେସାକଡିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜହନ ଏଲେଇଚେସି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ଏ଼ନିକିଁ ଜ଼ଲାମାଚେସି, ‘ନା଼ନୁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା କାଜା ଗିୟାଁତଲେ କା଼ଲୱି ଆ଼ହିମାନି ରଅଣି ହା଼ଡାଲେହେଁ ତାତେଏଁ, ପ୍ରବୁତି ଜିରୁ ସଲ୍‌କେ କିଦୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଅ଼ଡ଼େ, ପାରୁସିୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ଏ଼ୱାରି ଜହନଇଁ ୱେଚେରି, “ନୀନୁ କ୍ରୀସ୍ତ କି ଏଲିୟ କି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି ଆ଼ଏ, ଆତିହିଁ ନୀନୁ ଏ଼ନାଆଁତାକି ବାପ୍ତିସ୍ମ ହୀହିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜହନ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୟୁତା ବାପ୍ତିସ୍ମ ହୀହିମାଇଁ; ଆମ୍ବାଆରାଇଁ ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି, ଏ଼ୱାସି ମୀ ବିତ୍ରା ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ଏ଼ୱାସି ନା଼ ଡା଼ୟୁ ୱା଼ହିମାନେସି, ନା଼ନୁ ଏ଼ୱାଣି ସେପୁୟାଁତି ଡ଼଼ର୍କା ଜିକେଏ ହୁକ୍‌ହାଲି ଜ଼ଗେ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଏମିନି ଜର୍ଦନ କାଡାତି ୱେ଼ଡ଼ା ହ଼ପୁୱାକିତି ବେତନିୟାଁତା ଜହନ ବାପ୍ତିସ୍ମ ହୀହିମାଚେସି, ଏ଼ ଟା଼ୟୁତା ଈ ବାରେ ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ଏ଼ ଅ଼ର ନେ଼ଚୁ ଜହନ ଜୀସୁଇଁ ତାନି ୱାକି ୱା଼ହିମାନାଣି ମେସାନା ଏଲେଇଚେସି, “ସିନିକିଦୁ ମାହାପୂରୁତି ମେ଼ଣ୍ତା ଡା଼ଲୁ, ଆମିନିଗାଟାସି ଈ ଦାର୍‌ତିତି ପା଼ପୁ ବାରେ ଡେ଼କା ଅ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଈୱାସିଏ ଏ଼ୱାସି, ଆମ୍ବାଆରି କାତା ନା଼ନୁ ୱେସାମାଞ୍ଜାତେଏଁ, ‘ର଼ ମାଣ୍‌ସି ନା଼ ଡା଼ୟୁ ୱା଼ହିମାନେସି, ସାମା ଏ଼ୱାସି ନା଼ କିହାଁ କାଜାସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ନା଼ନୁ ଜାର୍ନାଆ଼ତି ନ଼କେଏ ମାଚେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ନା଼ନୁ ଜିକେଏ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜା ହିଲାଆତେଏଁ, ସାମା ଏ଼ୱାସି ଏ଼ନିକିହିଁ ଇସ୍ରାୟେଲ ଲ଼କୁ ନ଼କିତା ତ଼ଞ୍ଜାଆ଼ନେସି, ଈଦାଆଁତାକି ନା଼ନୁ ଏ଼ୟୁତା ବାପ୍ତିସ୍ମ ହୀହାଲି ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଅ଼ଡ଼େ ଜହନ ସା଼କି ହୀହାନା ୱେସ୍ତେସି, “ନା଼ନୁ ସୁଦୁଜୀୱୁ ପା଼ର୍‌ୱା ପଟାଲେହେଁ ଲାକପୂରୁଟି ରେ଼ଚା ୱା଼ହିମାନାଣି ମେସ୍ତେଏଁ, ଇଞ୍ଜାଁ ଏ଼ଦି ଏ଼ୱାଣିଲାକ କୁଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ନା଼ନୁ ଜିକେଏ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜା ହିଲାଆତେଏଁ, ସାମା ଆମ୍ବାଆସି ନାଙ୍ଗେ ଏ଼ୟୁତା ବାପ୍ତିସ୍ମ ହୀହାଲି ପାଣ୍ତାମାଞ୍ଜାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ୱେସ୍ତାତେସି, ‘ଆମିନିଗାଟାଣି ଲାକ ସୁଦୁଜୀୱୁ ରେ଼ଚା ୱା଼ନାଣି ଅ଼ଡ଼େ କୁଗିନାଣି ମେହ୍‌ଦି, ଆମ୍ବାଆସି ସୁଦୁଜୀୱୁ ତଲେ ବାପ୍ତିସ୍ମ ହୀନେସି, ଏ଼ୱାସି ଏ଼ ମାଣ୍‌ସି ।’” ");
INSERT INTO kxv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଜହନ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ଦାଆଁ ମେସାମାଇଁ, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ମାହାପୂରୁ ମୀର୍‌ଏସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ତାନି ଅ଼ର ନେ଼ଚୁ ଜହନ ତାନି ରୀ ସୀସୁୟାଁ ତଲେ ନିଚାମାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଏ଼ୱାସି ଜୀସୁଇଁ ଏ଼ ଜିରୁଟି ହାଜିମାନାଣି ମେସାନା ଏଲେଇଚେସି, “ସିନିକିଦୁ ମାହାପୂରୁତି ମେ଼ଣ୍ତା ଡା଼ଲୁ !” ");
INSERT INTO kxv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଏ଼ ରୀ ସୀସୁୟାଁ ଏ଼ୱାଣି ହା଼ଡା ୱେଞ୍ଜାନା ଜୀସୁ ଜେ଼ଚ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜୀସୁ ୱେଣ୍ଡେ ତିର୍‌ୱାନା ଏ଼ୱାରାଇଁ ତାନି ଜେ଼ଚ ଜେ଼ଚ ହାଜିମାନାଣି ମେସାନା ୱେଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ପାରିମାଞ୍ଜେରି ?” ଏ଼ୱାରି ୱେଚେରି, “ରାବି ନୀନୁ ଆମ୍ବିୟା ଡ଼ୟିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, ୱା଼ଦୁ, ମେହ୍‌ଦେରି । ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହାଜାନା ତାନି ଡ଼ୟିନି ଟା଼ୟୁ ମେସ୍ତେରି, ଇଞ୍ଜାଁ, ଏ଼ ଦିନା ଏ଼ୱାଣିତଲେ ଡ଼ୟିତେରି; ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏଚିବେ଼ଲା ଲା଼ଇତି ଦସ ଗଂଟା ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଜହନତି କାତା ୱେଞ୍ଜାନା ଆମିନି ରିଆରି ଜୀସୁ ଜେ଼ଚ ଜେ଼ଚ ହାଜାମାଚେରି, ଏ଼ୱାରି ବିତ୍ରା ରଅସି ସିମନ ପିତରତି ତାୟି ଆନ୍ଦ୍ରିୟ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଏ଼ୱାସି ତଲିଏ ତାନି ତାୟି ସିମନଇଁ ମେସାନା ଏଲେଇଚେସି, “ମା଼ମ୍ବୁ ମସିହାଇଁ ମେସ୍ତମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ଆନ୍ଦ୍ରିୟ ସିମନଇଁ ଜୀସୁ ତା଼ଣା ତାତେସି । ଜୀସୁ ଏ଼ୱାଣାଇଁ ଆଟେ ସିନିକିହାନା ଏଲେଇଚେସି, “ନୀନୁ ଜହନ ମୀର୍‌ଏଣା ସିମନତି । ନୀନୁ କେ଼ପା ଦ଼ରୁଟି ୱେ଼ଙ୍ଗିଦି ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ଅ଼ର ନେ଼ଚୁ ଜୀସୁ ଗାଲିଲିତା ହାଜାଲି ଅଣ୍‌ପିତେସି, ଏ଼ୱାସି ପିଲିପଇଁ ମେସାନା ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ !” ");
INSERT INTO kxv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ ବେତ୍‌ସାୟିଦା ଗା଼ଡ଼ାତାସି ମାଚେସି, ଏ଼ଦି ଆନ୍ଦ୍ରିୟ ଇଞ୍ଜାଁ ପିତରତି ଗା଼ଡ଼ା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ ନିତନିୟେଲଇଁ ମେସାନା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆରି କାତା ମ଼ସାତି ମେ଼ରାତା ରା଼ଚାମାନେରି, ଅ଼ଡ଼େ, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଜିକେଏ ରା଼ଚାମାନେରି, ମା଼ମ୍ବୁ ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ହାମାନମି । ଏ଼ୱାସି ଜସେପ ମୀର୍‌ଏସି ନା଼ଜରିତତି ଜୀସୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିୟେଲ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନା଼ଜରିତତା କି ଏ଼ନି ନେହିଁ କାମା ଆ଼ହିମାନେ ?” ପିଲିପ ଏଲେଇଚେସି, “ୱା଼ହାନା ସିନିକିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜୀସୁ ନିତନିୟେଲଇଁ ତାନି ତା଼ଣା ୱା଼ହିମାନାଣି ମେସାନା ଜୀସୁ ଏ଼ୱାଣି କାତା ୱେସ୍ତେସି, “ମେହ୍‌ଦୁ ଈୱାସି ସାତା ତଲେ ଇସ୍ରାୟେଲତି ଲ଼କୁ; ଈୱାଣି ତା଼ଣା ଏ଼ନାୟି ନା଼ଡ଼ିକିନି ବୁଦି ହିଲେଏ !” ");
INSERT INTO kxv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିୟେଲ ଜୀସୁଇଁ ୱେଚେସି, “ନୀନୁ ନାଙ୍ଗେ ଏ଼ନିକିହିଁ ପୁଞ୍ଜାତି ?” ଜୀସୁ ଏଲେଇଚେସି, “ପିଲିପ ନିଙ୍ଗେ ହା଼ଟାତି ନ଼କେଏ ନୀନୁ ତ଼ୟା ମା଼ର୍‌ନୁ ଡ଼଼ଇ ମାଚି, ଏଚେ଼ତା ନା଼ନୁ ନିଙ୍ଗ ମେସାମାଞ୍ଜାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନିୟେଲ ଏଲେଇଚେସି, “ଏ଼ ଗୂରୁ ନୀନୁ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି ! ନୀନୁଏ ଇସ୍ରାୟେଲ ରାଜାତି ।” ");
INSERT INTO kxv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ତ଼ୟା ମା଼ର୍‌ନୁ ଡ଼଼ଇ ମେସ୍ତାତେଏଁ ଇଞ୍ଜିଁ ୱେସାଲିଏ ନୀନୁ ନାମିମାଞ୍ଜି ?” ନୀନୁ ଈଦାଆଁ କିହାଁ ହା଼ରେକା କାଜା କାମାୟାଁ ମେହ୍‌ଦି । ");
INSERT INTO kxv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଜୀସୁ ନିତନିୟେଲଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ନୀନୁ ଲାକପୂରୁ ଦେପିଆ଼ହାମାନାଣି ଇଞ୍ଜାଁ ମାଣ୍‌ସି ମୀର୍‌ଏଣା ତା଼ଣା ମାହାପୂରୁତି ଦୂତୁୟାଁ ଲାକ ହାଜିମାନାଣି ଅ଼ଡ଼େ ଡ଼଼ଇ ୱା଼ହିମାନାଣି ମେହ୍‌ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ତୀନି ଦିନା ଜେ଼ଚ ଗାଲିଲିତି କାନା ଗା଼ଡ଼ାତା ର଼ ବୀହା ମାଚେ, ଜୀସୁ ତାମି ଇୟା ମରିୟମ ଜିକେଏ ଏମ୍ବାଆଁ ମାଚେ; ");
INSERT INTO kxv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜୀସୁ ଜିକେଏ ତାନି ସୀସୁୟାଁ ତଲେ ବୀହାତା ହାଜାଲି ହା଼ଟ୍‌କି ଆ଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ଏଚିବେ଼ଲା ଅଙ୍ଗୁରି ରାସା ରା଼ହାହାଚୁ, ଜୀସୁଇଁ ତାମି ଇୟା ଏଲେଇଚେ, “ଏ଼ୱାରି ଅଙ୍ଗୁରି ରାସା ରା଼ହାହାଚୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ଏମ୍ବାଟିଏ ଜୀସୁ ତାମି ଇୟାନି ଏଲେଇଚେସି, “ଇୟା, ନୀନୁ ନାଙ୍ଗେ ଏ଼ନାଆଁ କିନାୟିମାନେ ଏ଼ନାଆଁକି ୱେସିମାଞ୍ଜାଦି ? ନା଼ କା଼ଲା ନୀଏଁ ପାତେକା ୱା଼ହାହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଜୀସୁ ତାମି ଇୟା କାମା କିନାରାଇଁ ଏଲେଇଚେ, “ଏ଼ୱାସି ମିଙ୍ଗେ ଏ଼ନାଆଁ ୱେସ୍ତାନେସି ଏଲେକିହିଁଏ କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଅ଼ଡ଼େ, ଏମ୍ବାଆଁ ଜୀହୁଦିୟାଁ ସୁଦୁ କିହାଲି ନର୍‌ନି ମେ଼ରାତାକି ସ଼ ଗଟା କାଜା ୱାଲ୍‌କାତି ଏ଼ୟୁ ଗୂନାୟାଁ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜୀସୁ ହ଼ଲିୟାଙ୍ଗାଣି ଏଲେଇଚେସି, “ଈ ଗୂନାୟାଁଣା ଏ଼ୟୁ ନେଞ୍ଜିକିଦୁ ।” ଏ଼ୱାରି ଏମ୍ବାଆଁ ନେଞ୍ଜିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଇମ୍ବାଟି ଇଚରା ଅ଼ହାନା ବ଼ଜିତି ଗୁମୁସ୍ତାକି ହୀଦୁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବ଼ଜିତି ଗୁମୁସ୍ତା ଅଙ୍ଗୁରି ରାସା ଆ଼ହାମାନି ଏ଼ ଏ଼ୟୁତି ୱାଣ୍ତାହାଁ ଏ଼ୱି ଏମ୍ବିଟି ତାପିଆ଼ତୁ, ପୁଞ୍ଜା ହିଲାଆତେସି । ସାମା ଏ଼ ହ଼ଲିୟାଙ୍ଗା ଏ଼ୟୁ ୱା଼କ୍‌ହା ମାଚାରି ପୁଞ୍ଜାମାଚେରି ଏ଼ଦାଆଁତାକି ହନେଏଣାଇଁ ହା଼ଟାହାଁ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ବାରେଜା଼ଣା ତଲିଏ ନେହିଁ ଅଙ୍ଗୁରି ରାସା ହୀନେରି ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ୱା଼ହାଡ଼ୟିନି ଲ଼କୁ ହ଼ଚିସାରେ ଡା଼ୟୁ ଲାଗେଏତି ଅଙ୍ଗୁରି ରାସା ହୀନେରି; ସାମା ମୀରୁ ବାରେ ନେହିଁ ଅଙ୍ଗୁରି ରାସା ନୀଏଁ ପାତେକା ଇଟାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜୀସୁ ଇଲେକିଁ ଗାଲିଲିତି କାନା ଗା଼ଡ଼ାତା କାବାଆ଼ନି କାମା ମା଼ଟ୍‌ହାନା ତାନି ଗାୱୁରମି ତ଼ସ୍ତେସି, ଅ଼ଡ଼େ ସୀସୁୟାଁ ଏ଼ୱାଣି ତା଼ଣା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଏ଼ଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ତାମି ଇୟା, ତାୟିୟାଁ ଅ଼ଡ଼େ ସୀସୁୟାଁ ତଲେ କପର୍‌ନାହୁମତା ହାଚେରି; ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ହା଼ରେକା ଦିନା ଡ଼ୟାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ଏଚିବେ଼ଲାତା ଜୀହୁଦିଙ୍ଗା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଡାଗେ ଆ଼ହାମାଚେ, ଅ଼ଡ଼େ ଜୀସୁ ଜିରୁସାଲମତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ଏମ୍ବାଆଁ ଜୀସୁ ମେସ୍ତେସି, ମାହାପୂରୁ ଇଲୁ ବିତ୍ରା ଲ଼କୁ କ଼ଡିୟାଁ ମେ଼ଣ୍ତାୟାଁ ଅ଼ଡ଼େ ପଟାୟାଁ ବେ଼ବାରା କିନାରି ଅ଼ଡ଼େ ଡାବୁୟାଁ ବେ଼ବାରା କିନାରି କୁଗାମାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଏମ୍ବାଟିଏ ଜୀସୁ ଡ଼଼ରିତି ସା଼ଟ୍‌ଣି କେ଼ପାନା କ଼ଡିୟାଁ, ମେ଼ଣ୍ତାୟାଁ ମାହାପୂରୁ ଇଲୁଟି ପାଙ୍ଗାତା ପେ଼ର୍‌ହା ପାଣ୍ତାନା ଟାକାୟାଁ ବେ଼ବାରା ଗାଟାରି କୁର୍ଚିୟାଁ ତିରିମ୍ଣିପ୍‌ହାନା ଟାକାୟାଁ ବାରେ ଡ଼ାଞ୍ଜିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ପଟାୟାଁ ବେ଼ବାରା ଗାଟାରାଇଁ ଏଲେଇଚେସି, “ଈ ବାରେତି ଇମ୍ବାଟି ଅ଼ହାତ୍‌ହୁଦୁ, ନା଼ ଆ଼ବା ଇଲୁତି ବେ଼ବାରା ଇଲୁ କିଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ଈଦାଆଁ ମେସାନା ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନି ର଼ କାତା ସୀସୁୟାଁ ମ଼ନତା ୱା଼ତେ, “ନୀ ଇଲୁତାକି ନା଼ ରା଼ହାଁ ନାଙ୍ଗେ ହା଼ରେକା ନା଼ସା କିୟାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ଜୀହୁଦିୟାଁ ଜୀସୁଇଁ ୱେଚେରି, “ନୀନୁ ଈ ବାରେ କାମା କିହାଲିତାକି ଅଦିକାରା ବେଟାଆ଼ହାମାଞ୍ଜି, ଏମ୍ବାତି ସିନା ମାଙ୍ଗେ ଏ଼ନାଆଁ ତ଼ସିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜୀସୁ ଏଲେଇଚେସି, “ଈ ଦେ଼ୱୁଡ଼ିତି ନା଼ସା କିଦୁ, ଅ଼ଡ଼େ ତୀନି ଦିନାଟିଏ ନା଼ନୁ ଏ଼ଦାଆଁ ୱେଣ୍ତେ କେ଼ପିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଏଚେଟିଏ ଜୀହୁଦି ଲ଼କୁ ଏଲେଇଚେରି, “ଏ଼ନାଆଁ ତୀନିଦିନା ବିତ୍ରା ନୀନୁ ଈଦାଆଁ କେ଼ପାଲି ଆ଼ଡିଦି ? ଈ ଦେ଼ୱୁଡ଼ି କିହାଲିତାକି ରୀ କ଼ଡ଼ି ସ଼ ବାର୍ସା ଆ଼ହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ସାମା ଜୀସୁ ଜାହାରା ଆଙ୍ଗା ଲେହେଁତି ଦେ଼ୱୁଡ଼ିତି ତ଼ସାନା ଈଦାଆଁ ୱେସାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଈଦାଆଁତାକି ଜୀସୁ ହା଼ହାନା ନିଙ୍ଗାଲିଏ ତାନି ସୀସୁୟାଁ ଜୀସୁ ଈ କାତା ୱେସାମାଚେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେରି; ଅ଼ଡ଼େ ଦାର୍ମୁ ସା଼ସ୍ତେରି ଅ଼ଡ଼େ ଜୀସୁ ୱେସାମାଚି କାତାତି ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଆ଼ହିମାଚି ବେ଼ଲାତା ଜିରୁସାଲମତା ଜୀସୁ ମାଚାଟି ହା଼ରେକା ତାନି କାବାଆ଼ନି କାମା ମେସାନା ତାନି ଦ଼ରୁତା ହା଼ରେକା ଜା଼ଣା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ସାମା ଜୀସୁ ଏ଼ ଲ଼କୁଣି ନାମାଆନା ଏ଼ୱାରି ତା଼ଣାଟି ଏଟ୍‌କା ଡ଼ୟିତେସି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ୱାରାଇଁ ନେହିଁକିଁ ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ମାଣ୍‌ସି କାତା ସା଼କି ହୀନେସି, ଈଦି ଏ଼ୱାଣାକି ଲ଼ଡ଼ା ହିଲାଆତେ, ଇଚିହିଁ ମାଣ୍‌ସି ବିତ୍ରା ଏ଼ନାୟି ମାନେ ଏ଼ୱାସି ତା଼ନୁଏ ପୁଞ୍ଜାଲି ଆ଼ଡିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିୟାଁ ଗଚିଟି ନିକଦିମ ଇଞ୍ଜିଁ ର଼ ମାଣ୍‌ସି ମାଚେସି, ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁଣି ସା଼ଲୱି କିନାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ଏ଼ୱାସି ଲା଼ଆଁ ବେ଼ଲାତା ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେସି, “ଏ଼ ରାବି, ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି ନୀନୁ ମାହାପୂରୁ ପାଣ୍ତାମାଞ୍ଜାନି ଗୂରୁ । ନୀନୁ ଆମିନି ବାରେ କାବାଆ଼ନି କାମା କିହିମାଞ୍ଜି, ମାହାପୂରୁ ସା଼ୟେମି ହିଲାଆସାରେ ଏ଼ଦାଆଁ ଆମ୍ବାଆରି କିହାଲି ଆ଼ଡଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ସାତା ସାତା ନା଼ନୁ ନିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ଅ଼ଡ଼େ ୱେଣ୍ଡେ ଜାର୍ନା ଆ଼ଆସାରେ ଆମ୍ବାଆସି ମାହାପୂରୁ ରା଼ଜି ମେସାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ବୁଡ଼୍‌ହା ଆ଼ତିସାରେ ମାଣ୍‌ସି ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ନିକିଁ ଜାର୍ନା ଆ଼ହାଲି ଆ଼ଡିନେସି ? ତାଲିନି ବାଣ୍ଡିତା ହ଼ଡାନା ଏ଼ୱାସି ୱେଣ୍ତେ ଜାର୍ନା ଆ଼ହାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜୀସୁ ଏଲେଇଚେସି; “ସାତା ସାତା ନା଼ନୁ ନିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ” ଏ଼ୟୁ ଅ଼ଡ଼େ ସୁଦୁଜୀୱୁଟି ଜାର୍ନା ଆ଼ଆସାରେ ଆମ୍ବାଆସି ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଆଙ୍ଗାଟି ଏ଼ନାୟି ଜାର୍ନା, ଏ଼ଦି ଆଙ୍ଗା; ଅ଼ଡ଼େ ସୁଦୁଜୀୱୁଟି ଏ଼ନାୟି ଜାର୍ନା ଆ଼ନେ, ଏ଼ଦି ସୁଦୁଜୀୱୁ । ");
INSERT INTO kxv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ନିଙ୍ଗେ ୱେଣ୍ଡେ ଜାର୍ନା ଆ଼ନାୟି ଲ଼ଡ଼ାମାନେ ଇଞ୍ଜିଁ ନା଼ନୁ ନିଙ୍ଗ ୱେସ୍ତାତେଏଁ, ଏ଼ଦାଆଁତାକି କାବା ଆ଼ଆନି । ");
INSERT INTO kxv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ଗା଼ଲି ଆମ୍ବିୟାୱାକି ମ଼ନ କିନେ, ଏତାଲା ୱାକି ହାନେ, ଅ଼ଡ଼େ ନୀନୁ ୱାର୍‌ଇ ଏ଼ଦାନି ହା଼ଡା ୱେଞ୍ଜାଲି ଆ଼ଡିଦି, ସାମା ଏ଼ଦି ଏମିନି ତା଼ଣାଟି ୱା଼ନେ ଅ଼ଡ଼େ, ଏମ୍ବିୟା ହାନେ, ଏ଼ଦାଆଁ ପୁନଅତି; ସୁଦୁଜୀୱୁଟି ଜାର୍ନା ଆ଼ହାମାନି ବାରେଜା଼ଣା ଏଲେକିହିଁଏ । ");
INSERT INTO kxv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ଦି ଏ଼ନିକିଁ ଆ଼ହାଲି ଆ଼ଡିନେ ?” ");
INSERT INTO kxv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି; “ନୀନୁ ଇସ୍ରାୟେଲତି ଗୂରୁ ଆ଼ହାନା ଜିକେଏ, ଈ ବାରେ ତେଲ୍‌ହି ହିଲଅତି କି ? ");
INSERT INTO kxv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ନା଼ନୁ ନିଙ୍ଗ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନା଼ନୁ ଏ଼ନାଆଁ ପୁଞ୍ଜାମାଇଁ, ଏ଼ଦାନି କାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ନାଆଁ ମେସାମାଇଁ, ଅ଼ଡ଼େ ନୀନୁ ନା଼ କାତା ନାମିହିଲଅତି । ");
INSERT INTO kxv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ନା଼ନୁ ଦାର୍‌ତି କାତାତି ୱେସ୍ତାସାରେ ନୀନୁ ନାମଅତି, ଆତିହିଁ ଲାକପୂରୁତି ହା଼ଡା ୱେସ୍ତାସାରେ ଏ଼ନିକିଁ ନାମିଦି ? ");
INSERT INTO kxv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଆମିନି ମାଣ୍‌ସି ମୀର୍‌ଏସି ଲାକପୂରୁଟି ରେ଼ଚା ୱା଼ତେସି, ଏ଼ୱାଣି ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଲାକପୂରୁ ହାଜାହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ଅ଼ଡ଼େ, ମ଼ସା ଏ଼ନିକିଁ ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ପିତାଡ଼ା ରା଼ଚୁତି ଲାକ ପେର୍‌ହା ମାଚେସି, ମାଣ୍‌ସି ମୀର୍‌ଏସି ଜିକେଏ ଏଲେକିହିଁଏ ଲାକ ପେର୍‌ୱି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଏ଼ନିଇଚିହିଁ ଆମ୍ବାଆସି ତାନି ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଇଚିହିଁ ମାହାପୂରୁ ଦାର୍‌ତିତି ଏଚେକା ଜୀୱୁ ନ଼ତେସି, ଏ଼ୱାସି ତାନି ରଣ୍ତିଏ ମୀର୍‌ଏଣାଇଁ ଦା଼ନା ହୀତେସି, ଏ଼ନିଇଚିହିଁ ଏ଼ୱାଣି ତା଼ଣା ନାମିନାସି ନା଼ସା ଆ଼ଆନା କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଇଚିହିଁ ଦାର୍‌ତିତା ନୀହାଁୟି କିହାଲିତାକି ମାହାପୂରୁ ତାନି ମୀର୍‌ଏଣାଇଁ ଦାର୍‌ତିତା ପାଣ୍ତାଆନା, ଦାର୍‌ତି ଏ଼ନିକିଁ ତାନିତା଼ଣାଟି ଗେଲ୍‌ପିଆ଼ନେ, ଏ଼ଦାଆଁତାକି ତାନି ମୀର୍‌ଏଣାଇଁ ପାଣ୍ତାତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଆମ୍ବାଆସି ତାନି ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ନୀହାଁୟି କିୱି ଆ଼ଅସି ଆମ୍ବାଆସି ନାମଅସି, ଏ଼ୱାସି ନୀହାଁୟି କିୱି ଆ଼ତେସିଏ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁତି ରଣ୍ତିଏ ମୀର୍‌ଏଣା ଦ଼ରୁତି ନାମାହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଅ଼ଡ଼େ ଏ଼ ନୀହାଁୟି ଈଦି, ଈ ଦାର୍‌ତିତା ଉଜେଡ଼ି ତ଼ଞ୍ଜା ଆ଼ହାମାନେ, ଅ଼ଡ଼େ ଲ଼କୁ ଉଜେଡ଼ି ପିସାନା ଆନ୍ଦେରିତି ଜୀୱୁ ନ଼ତେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ବାରେ କାମା ଲାଗେଏତାୟି । ");
INSERT INTO kxv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଇଚିହିଁ ଆମ୍ବାଆରି ଲାଗେଏତି କାମାକିନାରି, ଉଜେଡ଼ିତି ଅ଼ପଅରି, ଅ଼ଡ଼େ ଏଚେ଼ତା ତାମି ପା଼ପୁ କାମା ତ଼ଞ୍ଜାଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଉଜେଡ଼ିତା ୱା଼ଅରି । ");
INSERT INTO kxv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ସାମା ଆମ୍ବାଆରି ସାତା କାମା କିନେରି, ଏ଼ୱାରି ଉଜେଡ଼ିତା ୱା଼ନେରି, ଏ଼ନିକିଁ ତାମି କାମା ବାରେ ମାହାପୂରୁ ତା଼ଣାଟି ତୀରି ଆ଼ତାୟି ଇଞ୍ଜିଁ ତ଼ଞ୍ଜାଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ଈଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ ଜୀହୁଦା ରା଼ଜିତା ହାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ ଟା଼ୟୁତା ଡ଼ୟାନା ବାପ୍ତିସ୍ମ ହୀହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଜହନ ଜିକେଏ ସାଲମତି ଡାଗେ ଏନନ୍‌ତା ବାପ୍ତିସ୍ମ ହୀହିମାଚେସି, ଇଚିହିଁ ଏମ୍ବାଆଁ ଗାଡି ଏ଼ୟୁ ମାଚୁ, ଅ଼ଡ଼େ ଲ଼କୁ ୱା଼ହାନା ବାପ୍ତିସ୍ମ ଅ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଏଚିବେ଼ଲା ପାତେକା ଜହନ କା଼ୟିଦିତା ହାଜାହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଏମ୍ବାଟିଏ ଜହନତି ଏଚରଜା଼ଣା ସୀସୁୟାଁ ର଼ ଜୀହୁଦି ତଲେ ମେ଼ରାତାକି ନର୍‌ନି କାତାତାକି ବା଼ଦିବା଼ଦା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଏ଼ୱାରି ଜହନଇଁ ଏଲେଇଚେରି, “ଗୂରୁ ଆମ୍ବାଆସି ଜର୍ଦନ କାଡାତି ଅ଼ରୱାକି ନୀ ତଲେ ମାଚେସି, ଆମ୍ବାଆରି କାତା ନୀନୁ ସା଼କି ହୀହାମାଞ୍ଜାତି, ମେହ୍‌ମୁ ଏ଼ୱାସି ବାପ୍ତିସ୍ମ ହୀହିମାନେସି ଅ଼ଡ଼େ ବାରେଜା଼ଣା ଏ଼ୱାଣି ତା଼ଣା ହାଜିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜହନ ଏଲେଇଚେସି, “ଲାକପୂରୁଟି ମାହାପୂରୁ ହୀଆସାରେ ମାଣ୍‌ସି ଏ଼ନାଆଁ ମେଡ଼ାଆ଼ହାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ନା଼ନୁ କ୍ରୀସ୍ତତେଏଁ ଆ଼ଏ, ସାମା ଏ଼ୱାଣି ନ଼କିତା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଇଁ, ଈ କାତା ନା଼ନୁ ମିଙ୍ଗେ ୱେସାମାଞ୍ଜାତେଏଁ ଇଞ୍ଜିଁ ମୀରୁ ନା଼ ସା଼କି । ");
INSERT INTO kxv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ମା଼ଙ୍ଗାନି ଅ଼ନାସି, ଏ଼ୱାସି ହନେଏସି, ସାମା ହନେଏଣି ଏମିନି ତ଼ଡ଼ୁ ନିଚାନା ତାନି ହା଼ଡା ୱେନେସି, ଏ଼ୱାସି ହନେଏଣି ହା଼ଡା ୱେଞ୍ଜାନା ହା଼ରେକା ରା଼ହାଁ ଆ଼ନେସି । ଏଲେକିହିଁଏ ନା଼ ରା଼ହାଁ ଜିକେଏ ପୂରା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ସାତେଏ ଏ଼ୱାସି କାଜାସି ଆ଼ନାୟି ମାନେ, ଅ଼ଡ଼େ ନାଙ୍ଗେ ଊଣା ଆ଼ନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଆମ୍ବାଆସି ଲାକପୂରୁଟି ୱା଼ନେସି, ଏ଼ୱାସି ବାରେକିହାଁ କାଜାସି, ଆମ୍ବାଆସି ଦାର୍‌ତିଟି ଜାର୍ନା ଆ଼ନେସି, ଏ଼ୱାସି ଦାର୍‌ତିତି କାତା ୱେହ୍‌ନେସି; ଆମ୍ବାଆସି ଲାକପୂରୁଟି ୱା଼ନେସି ଏ଼ୱାସି ବାରେଜା଼ଣା କିହାଁ କାଜାସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ଏ଼ୱାସି ଏ଼ନାଆଁ ମେସାମାନେସି ଅ଼ଡ଼େ ଏ଼ନାଆଁ ୱେଞ୍ଜାମାନେସି, ଏ଼ଦାଆଁ ଏ଼ୱାସି ସା଼କି ହୀହିମାନେସି, ସାମା ଆମ୍ବାଆସି ତାନି ହା଼ଡାତି ଅ଼ପଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ତାନି କାତାତି ଅ଼ପିନେସି, ଏ଼ୱାସି ମାହାପୂରୁ ସାତା ଇଞ୍ଜିଁ ଏ଼ କାତାତି ଆବା ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ସାମା ମାହାପୂରୁ ଆମ୍ବାଆରାଇଁ ପାଣ୍ତାମାଞ୍ଜାନେସି, ଏ଼ୱାସି ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନେସି, ଏ଼ୱାଣାକି ମାହାପୂରୁ ସୁଦୁଜୀୱୁ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଆ଼ବା ମୀର୍‌ଏଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଅ଼ଡ଼େ ବାରେ ତାନି କେୟୁତା ହେର୍‌ପା ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଆମ୍ବାଆସି ମୀର୍‌ଏଣାଇଁ ନାମିନେସି, ଏ଼ୱାସି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାମାନେସି, ସାମା ଆମ୍ବାଆସି ମୀର୍‌ଏଣାଇଁ ଅ଼ପଅସି, ଏ଼ୱାସି ଜୀୱୁ ଜିକେଏ ମେହ୍‌ଅସି, ସାମା ଏ଼ୱାସି ମାହାପୂରୁତି ଡଣ୍ତତା ଡ଼ୟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ପାରୁସିୟାଁ ୱେଚେରି, ଜୀସୁ ଜହନ କିହାଁ ଗାଡି ସୀସୁୟାଁ କିହିମାନେସି ଅ଼ଡ଼େ ବାପ୍ତିସ୍ମ ହୀହିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଜୀସୁ ତା଼ନୁ ବାପ୍ତିସ୍ମ ହୀହିହିଲାଆତେସି, ସାମା ତାନି ସୀସୁୟାଁ ବାପ୍ତିସ୍ମ ହୀହିମାଚେରି, ଈ କାତା ପାରୁସିୟାଁ ୱେଞ୍ଜାମାନେରି ଇଞ୍ଜିଁ ପ୍ରବୁ ଏଚେ଼ତା ପୁଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଏଚେ଼ତା ଜୀହୁଦା ଦେ଼ସା ପିସାନା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଗାଲିଲିତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ସାମା ତାଙ୍ଗେ ସମିରଣ ଜିରୁଟି ହାଜାଲି ଲା଼ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଅ଼ଡ଼େ ଏ଼ୱାସି ହାଜାନା ଜାକୁବ ତାନି ମୀର୍‌ଏସି ଜସେପକି ଏମିନି ବୂମି ହୀହାମାଚେସି ଏ଼ ଡାଗେ ସମିରଣତି ସୁକାର ଦ଼ରୁଗାଟି ର଼ ନା଼ୟୁଁତା ଏଗାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ଏ଼ ଟା଼ୟୁତା ଜାକୁବତି କୁହି ମାଚେ, ଇଞ୍ଜାଁ ଜୀସୁ ୱା଼ହାହାଜାମାଚାକି ଏ଼ କୁହି ଡାଗେ କୁଗିତେସି । ଏଚେ଼ତା ମାଦେନା ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଅ଼ଡ଼େ ର଼ ସମିରଣ ଇୟା ଏ଼ୟୁ ଅ଼ହାଲି ୱା଼ତେ । ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି “ନାଙ୍ଗେ ଏ଼ୟୁ ଗସାଲି ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ତାନି ସୀସୁୟାଁ କା଼ଦି କଡାଲି ଗା଼ଡ଼ାତା ହାଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଏମ୍ବାଟିଏ ସମିରଣ ଇୟା ଜୀସୁଇଁ ଏଲେଇଚେ, “ନୀନୁ ର଼ ଜୀହୁଦି ଲ଼କୁ ଆ଼ହାଁ, ନା଼ନୁ ସମିରଣ ଆୟାତେଏଁ, ଏ଼ନିକିଁ ନା଼ କେୟୁଟି ଏ଼ୟୁ ଗସାଲି ରୀସି ମାଞ୍ଜାଦି ?” ଏ଼ନିଇଚିହିଁ ଜୀହୁଦିୟାଁ ତଲେ ସମିରଣ ଲ଼କୁତି ଲେ଼ମ୍ବିନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ମାହାପୂରୁତି ଦା଼ନା ଅ଼ଡ଼େ ନାଙ୍ଗେ ଗସାଲି ହିୟାମୁ ଇଞ୍ଜିଁ ଆମ୍ବାଆସି ନିଙ୍ଗେ ଏଲେଇଞ୍ଜିମାଞ୍ଜାନେସି, ଏ଼ୱାସି ଆମ୍ବାଆସି, ଈଦାଆଁ ନୀନୁ ପୁଚିହିଁମା, ନୀନୁ ଏ଼ୱାଣାଇଁ ରୀସ୍ତିମା, ଅ଼ଡ଼େ ଏ଼ୱାସି ନିଙ୍ଗେ ଜୀୱୁତି ଏ଼ୟୁ ହିୟାତେସିମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ଏ଼ ଆୟାଟି ଏଲେଇଚେ, “ଗୂରୁ ନୀ ତା଼ଣା ଏ଼ୟୁ କଡାଲି ତାକି ନକି ହିଲେଏ, ଅ଼ଡ଼େ ଈ କୁହି କୂଡ଼୍‌ହାମାନେ; ଆତିହିଁ ନୀନୁ ଏମ୍ବିଟି ଏ଼ ଜୀୱୁଗାଟି ଏ଼ୟୁ ବେଟାଆ଼ହାମାଞ୍ଜି ? ");
INSERT INTO kxv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ମା଼ ଆକୁୟାଁତି ଆ଼ବା ଜାକୁବ ଈ କୁହି ମାଙ୍ଗେ ହୀହାମାଞ୍ଜାତେସି, ଅ଼ଡ଼େ, ତାନି ମୀର୍‌କା ଅ଼ଡ଼େ ତାମି କ଼ଡି ଗରି ଇମ୍ବାତି ଏ଼ୟୁ ଗସିମାଚୁ, ଏ଼ୱାଣି କିହାଁ ନୀନୁ କି କାଜାତି ?” ");
INSERT INTO kxv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜୀସୁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ଈ ଏ଼ୟୁ ଗହ୍‌ନେସି, ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ସ୍‌କି ଆ଼ନେସି; ");
INSERT INTO kxv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ସାମା ନା଼ନୁ ଏମିନି ଏ଼ୟୁ ହିୟାଇଁ, ଏ଼ୱାଆଁ ଆମ୍ବାଆସି ଗହ୍‌ନେସି, ଏ଼ୱାସି ଏଚେଲାୱା ଏ଼ସ୍‌କି ଆ଼ଅସି, ଇଚିହିଁ ନା଼ନୁ ଏମିନି ଏ଼ୟୁ ହୀଇଁ, ଏ଼ଦି କା଼ଲାକା଼ଲାତି ଜୀୱୁତି ଊସା ଲେହେଁ ଏ଼ୱାଣି ତା଼ଣାଟି ତେ଼ଲାବୟା ହାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ଆୟାଟି ଏଲେଇଚେ, “ଗୂରୁ, ନାଙ୍ଗେ ଏ଼ନିକିଁ ଏ଼ସ୍‌କି ଆୟେଏ, ଅ଼ଡ଼େ ଏ଼ୟୁତାକି ଇଚେକା ହେକ ଈ କୁହିତା ୱାୟାଲି ଆ଼ଏ, ଏ଼ଦାଆଁତାକି ଏ଼ ଏ଼ୟୁ ନାଙ୍ଗେ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ହାଲାମୁ, ନୀ ଡକ୍ରାଇଁ ହା଼ଟାତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ଏ଼ ଆୟାଟି ଏଲେଇଚେ, “ନା଼ ଡକ୍ରା ହିଲଅସି ।” ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି “ନୀ ଡକ୍ରା ହିଲଅସି ଇଞ୍ଜିଁ ସାତା ୱେସାମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ନିଙ୍ଗେ ପା଼ସାଜା଼ଣା ଡକ୍ରାୟାଁ ମାଚେରି, ଅ଼ଡ଼େ ନୀଏଁ ନୀ ତଲେ ଆମ୍ବାଆସି ମାନେସି ଏ଼ୱାସି ନୀ ଡକ୍ରା ଆ଼ଏ ଈଦାଆଁ ସାତା ୱେସାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ଆୟାଟି ଏଲେଇଚେ, “ଗୂରୁ, ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ ନୀନୁ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାତି, ଈଦାଆଁ ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ମା଼ ଆକୁ ଆ଼ବାୟାଁ ଈ ହ଼ରୁ ଲାକ ପ୍ରା଼ତାନା କିହିମାଚେରି; ଅ଼ଡ଼େ ମୀ ଜୀହୁଦି ଲ଼କୁ ଏଲେଇନେରି, ପ୍ରା଼ତାନା କିନି ଟା଼ୟୁ ଆ଼ହିମାନେ ଜିରୁସାଲମ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ଇୟା ନା଼ ହା଼ଡାତି ନାମାମୁ, ଏମିନି ବେ଼ଲାତା ମୀରୁ ଈ ହ଼ରୁତା କି ଜିରୁସାଲମତା ଆ଼ବା ତା଼ଣା ପ୍ରା଼ତାନା କିଅତେରି ଇଲେତି କା଼ଲମି ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ଆମ୍ବାଆରାଇଁ ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି, ଏ଼ୱାଣାଇଁ ପ୍ରା଼ତାନା କିହିମାଞ୍ଜେରି; ଆମ୍ବାଆରାଇଁ ମା଼ର ପୁଞ୍ଜାମାନାୟି, ଏ଼ୱାଣାଇଁ ପ୍ରା଼ତାନା କିହିମାନାୟି, ଇଚିହିଁ ଗେଲ୍‌ପିନାୟି ଜୀହୁଦି ଲ଼କୁ ତା଼ଣାଟି ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ସାମା ଏମିନି କା଼ଲମିତା ସାତା ତଲେ ପ୍ରା଼ତାନା କିନି ଲ଼କୁ ଜୀୱୁତଲେ ଅ଼ଡ଼େ ସାତା ତଲେ ଆ଼ବାଇଁ ପ୍ରା଼ତାନା କିନେରି, ଇଲେତି କା଼ଲମି ୱା଼ହିମାନେ; ଅ଼ଡ଼େ, ନୀଏଁ ଜିକେଏ ମାନେ; ଇଚିହିଁ ଆ଼ବା ଇଲେତି ପ୍ରା଼ତାନା କିନାରାଇଁ ପାରିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ମାହାପୂରୁ ସୁଦୁଜୀୱୁ ଗାଟାସି, ଅ଼ଡ଼େ ଆମ୍ବାଆରି ତାନି ପ୍ରା଼ତାନା କିନେରି, ଏ଼ୱାରି ଜୀୱୁ ଇଞ୍ଜାଁ ସାତା ତଲେ ତାନି ପ୍ରା଼ତାନା କିନାୟିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ଏ଼ ଆୟାଟି ଜୀସୁଇଁ ଏଲେଇଚେ, “ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ, ମସିହା, ଆମ୍ବାଆରାଇଁ କ୍ରୀସ୍ତ ଇନେରି, ଏ଼ୱାସି ୱା଼ନେସି; ଏଚେ଼ତା ଏ଼ୱାସି ୱା଼ନେସି ମାଙ୍ଗେ ବାରେ କାତା ପୁଣ୍‌ମ୍ବି କିୟାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ନୀଏଁ ନୀ ତଲେ ହା଼ଡା ଆ଼ହିମାନାତେଏଁ ନା଼ନୁ, ନା଼ନୁ ଏ଼ୱାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଏଚିବେ଼ଲାତା ତାନି ସୀସୁୟାଁ ୱା଼ହାନା ତା଼ନୁ ର଼ ଆୟାଟି ତଲେ ହା଼ଡା ଆ଼ହିମାନାଣି ମେସାନା କାବା ଆ଼ତେରି, ଆ଼ତିଜିକେଏ ନୀନୁ ଏ଼ନାଆଁ ମ଼ନ କିହିମାଞ୍ଜି, ଆ଼ଆତିଁ ଏ଼ନାଆଁତାକି ଏ଼ଦାନିତଲେ ହା଼ଡା ଆ଼ହିମାଞ୍ଜି ଇଞ୍ଜିଁ ? ଆମ୍ବାଆରି ୱେନାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ଏମ୍ବାଟିଏ ଆୟାଟି ଏମ୍ବାଆଁ ତାନି ଏ଼ୟୁ ଡ଼଼କା ପିସାନା ଗା଼ଡ଼ାତା ହାଜାନା ଲ଼କୁଣି ୱେସ୍ତେ, “ୱା଼ଦୁ, ରଅଣାଇଁ ମେହ୍‌ଦେରି, ");
INSERT INTO kxv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ନା଼ନୁ ଏ଼ନା ଏ଼ନାଆଁ ନା଼ ଜୀୱୁତା କିହାମାଇଁ, ଏ଼ୱାସି ନାଙ୍ଗେ ବାରେ ୱେସ୍ତାତେସି; ଏ଼ୱାସି ମସିହା ଆ଼ହାଡ଼ୟିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଏମ୍ବାଟିଏ ଏମ୍ବାତି ଲ଼କୁ ଗା଼ଡ଼ାଟି ହ଼ଚାନା ଜୀସୁ ତା଼ଣା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଏଚିବେ଼ଲାତା ସୀସୁୟାଁ ବାତିମା଼ଲିହିଁ ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ, ତିନାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ତିଞ୍ଜାଲି ତାକି ଏମିନି କା଼ଦି ନା଼ ତା଼ଣା ମାନେ, ମୀରୁ ଏ଼ କା଼ଦିତି କାତା ପୁଞ୍ଜାହିଲଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ସୀସୁୟାଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ହା଼ଡାକାତା ଆ଼ତେରି, “ଆମ୍ବାଆୟି ତାଙ୍ଗେତାକି କା଼ଦି ତାଚା ହୀହାମାନେ ହାବୁଲା ?” ");
INSERT INTO kxv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାଣା ଅଣ୍‌ପୁ ଅ଼ଡ଼େ ତାନି କାମା ରା଼ପ୍‌ନାୟି ଏ଼ଦିଏ ନା଼ କା଼ଦି । ");
INSERT INTO kxv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଆର୍ନା ଦା଼ଚାଲି ଅ଼ଡ଼େ ସା଼ରି ଲେ଼ଞ୍ଜୁ ମାନେ, ଈ କାତା ମୀରୁ ୱେସିହିଲଅତେରି ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଗୁଡିୟାକା ବାରେ ସିନିକିଦୁ ଏ଼ ବାରେ ଦା଼ଚାଲି ତାକି କାମ୍ବାହାଚେୟିଏ । ");
INSERT INTO kxv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ନୀଏଁ ଜିକେଏ ଦା଼ଃଆନାରାକି କୂଲି ହୀପ୍‌କି ଆ଼ହିମାନେ ଅ଼ଡ଼େ କା଼ଲାକା଼ଲାତି ଜୀୱୁତାକି ପା଼ଡ଼େୟି କୂଡ଼ି କିହିମାନେରି, ଏ଼ନିକିହିଁ ଦା଼ଃଆନାସି ଅ଼ଡ଼େ କୂଡ଼ିକିନାସି ରହେଁଏ ରା଼ହାଁ କିନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ରଅସି ମାଟିନେସି ଅ଼ଡ଼େ ଅ଼ର ରଅସି ଦା଼ଃଆନେସି ଈ କାତା ସାତା । ");
INSERT INTO kxv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ମୀରୁ ଏ଼ନାଆଁତାକି କାମା କିହାହିଲଅତେରି, ଏ଼ଦାଆଁ ଦା଼ଚାଲି ତାକି ନା଼ନୁ ପାଣ୍ତାତେଏଁ; ଏଟ୍‌କାତାରି କାମା କିହାମାନେରି, ଅ଼ଡ଼େ ମୀରୁ ଏ଼ୱାରି କାମାତି ଲା଼ବା ବେଟାଆ଼ହିମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“ନା଼ନୁ ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଇଁ, ଏ଼ କାତା ଏ଼ୱାସି ନାଙ୍ଗେ ବାରେ ୱେସ୍ତାତେସି” ଇଞ୍ଜିଁ ଏମିନି ଆୟାଟି ସା଼କି ହୀହାମାଚେ, ଏ଼ଦାନି କାତାତାକି ଏ଼ ଗା଼ଡ଼ାତି ସମିରଣ ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ଜୀସୁଇଁ ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଅ଼ଡ଼େ ସମିରଣ ଲ଼କୁ ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ତାମିତଲେ ଡ଼ୟାଲି ତାକି ତାଙ୍ଗେ ବାତିମା଼ଲିତେରି ଜୀସୁ ଏ଼ୱାରିତଲେ ଅ଼ଡ଼େ ରୀ ଦିନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଜୀସୁତି ବ଼ଲୁ ୱେଞ୍ଜାନା ହା଼ରେକା ଲ଼କୁ ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଏ଼ୱାରି ଏ଼ ଆୟାଟିଇଁ ଏଲେଇଚେରି, “ୱାର୍‌ଇ ନୀନୁ ଏଲେଇଞ୍ଜାତାକି ମା଼ମ୍ବୁ ନାମାହିଲଅମି, ସାମା ମା଼ମ୍ବୁ ୱେଞ୍ଜାମାନମି, ଅ଼ଡ଼େ, ଈୱାସି ସାତେଏ ଦାର୍‌ତିତି ଗେଲ୍‌ପିନାସି, ଈଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ରୀ ଦିନା ଡା଼ୟୁ ଜୀସୁ ଏମ୍ବାଟି ହ଼ଚାନା ଗାଲିଲିତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଇଚିହିଁ ଜୀସୁ ତାଙ୍ଗେତାକି ସା଼କି ହୀହିଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଜାହାରା ଦେ଼ସାତା ମା଼ନି ବେଟାଆ଼ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଅ଼ଡ଼େ ଏ଼ୱାସି ଗାଲିଲିତା ଏଜାଲିଏ ଏ଼ ଗାଲିଲିତାରି ଏ଼ୱାଣାଇଁ ଆବିତେରି, ଇଚିହିଁ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ବେ଼ଲାତା ଜୀସୁ ଜିରୁସାଲମତା ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଚେସି ବାରେ ମେସାମାଚେରି ଏ଼ୱାରି ଜିକେଏ ପାର୍ବୁତା ହାଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଏମ୍ବାଟିଏ ଜୀସୁ ଗାଲିଲିତି କାନା ଗା଼ଡ଼ାତା ୱେଣ୍ତେ ହାଚେସି, ଏମ୍ବିୟା ଜୀସୁ ଏ଼ୟୁଣି ଅଙ୍ଗୁରି ରାସା କିହାମାଚେସି, ଏମ୍ବାଆଁ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ରଅସି ମାଚେସି, ତାନି ମୀର୍‌ଏସି କପର୍‌ନାହୁମତା ଆ଼ଡିହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜୀସୁ ଜୀହୁଦା ଗା଼ଡ଼ାଟି ଗାଲିଲିତା ୱା଼ହାମାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା, ତାନି ତା଼ଣା ହାଜାନା ଏ଼ୱାସି ୱା଼ହାନା ଏ଼ନିକିଁ ତାନି ମୀର୍‌ଏଣାଇଁ ନେହିଁ କିନେସି ଏ଼ଦାଆଁତାକି ବାତିମା଼ଲିତେସି, ଇଚିହିଁ ଏ଼ୱାସି ହା଼ନିହ଼ଗେ ଆ଼ହାମାଚେସି ");
INSERT INTO kxv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ସିନା ଅ଼ଡ଼େ କାବାଆ଼ନି କାମାୟାଁ ମେହ୍‌ଆତିହିଁ ମୀରୁ ଏ଼ନିଜିକେଏ ନାମଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ଏ଼ ସା଼ଲୱି କିନାସି ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ, ନା଼ ମୀର୍‌ଏସି ହା଼ନି ନ଼କେଏ ନା଼ ତଲେ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ହାଲାମୁ, ନୀ ମୀର୍‌ଏସି ନୀଡିନେସି ।” ଏ଼ ମାଣ୍‌ସିଇଁ ଜୀସୁ ଏମିନି ହା଼ଡା ୱେସ୍ତେସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ ନାମାନା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ଅ଼ଡ଼େ, ଏ଼ୱାସି ହାଲ୍‌ୱନିଏ ତାନି ହ଼ଲିୟାଙ୍ଗା ଜିରୁତେଏ ନୀ ମୀର୍‌ଏସି ନୀଡିତେସି ଇଞ୍ଜିଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ଏଚିବେ଼ଲାତା କକାସି ନେହିଁଆ଼ତେସି, ଏ଼ଦାଆଁ ଏ଼ୱାସି ୱେଚେସି । ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ରେଃଏନି ସା଼ତା ଗଂଟା ବେ଼ଲାତା ନ଼ମେରି ପିସ୍ତେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଏମ୍ବାଟି ତାମି ଆ଼ବା ପୁଚେସି ଜୀସୁ ଆମିନି ବେ଼ଲାତା “ନୀ ମୀର୍‌ଏସି ନୀଡିତେସି” ଇଞ୍ଜିଁ ୱେସାମାଚେସି, ଏଚିବେ଼ଲାତେଏ ଏ଼ଦି ଗଟୱି ଆ଼ତେ । ଏମ୍ବାଟିଏ, ଏ଼ୱାସି ଅ଼ଡ଼େ ତାମି ଇଜତି ବାରେ ଇଲୁ କୁଟମି ଜୀସୁ ତା଼ଣା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜୀହୁଦାଟିଏ ଗାଲିଲିତା ୱେଣ୍ତା ୱା଼ହାଁ, ଜୀସୁ ରୀ ପା଼ଲି ତାକି ଈ କାବାଆ଼ନି କାମା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ଈଦାଣି ଡା଼ୟୁ ଜୀହୁଦି ଲ଼କୁତି ର଼ ପାର୍ବୁ ଆ଼ତେ, ଅ଼ଡ଼େ ଜୀସୁ ଜିରୁସାଲମତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲମତି ମେ଼ଣ୍ଡାୟାଁ ଦୁୱେରି ଡାଗେ ର଼ ବାନ୍ଦା ମାନେ; ଏବ୍ରି ହା଼ଡାତଲେ ବେତ୍‌ସାୟିଦା ଇନେରି, ଏ଼ ବାନ୍ଦାତା ପା଼ସାଗଟା ପିଣ୍ତାୟାଁ ମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ଏମ୍ବାଆଁ କା଼ଣାୟାଁ, ସଟାୟାଁ ଅ଼ଡ଼େ ଆଙ୍ଗା ୱା଼ୟିତି ର଼ଗ ଗାଟାରି ହା଼ରେକା ଜା଼ଣା ନେହିଁ ଆୟାଲି କା଼ଚାହାଁ ମାଣ୍‌ମ୍ବିତେରି; ");
INSERT INTO kxv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଇଚିହିଁ ଏଚିବେ଼ଲାତା ପ୍ରବୁତି ର଼ ଦୂତୁ ବାନ୍ଦାତା ରେ଼ଚାନା ଏ଼ୟୁ ୱୀଟ୍‌ହିସାରେ, ଅ଼ଡ଼େ ଏ଼ୟୁ ୱୀଡିତି ଡା଼ୟୁ ଆମ୍ବାଆସି ତଲିଏ ହ଼ଡ଼ନେସି, ଏ଼ୱାଣାକି ଏ଼ନି ର଼ଗ ଆ଼ହାମାଚି ଜିକେଏ ନେହିଁ ଆ଼ହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","କଡ଼େ ଅଟର ବାର୍ସା ପାତେକା ର଼ଗ ଗାଟାସି ରଅସି ଏମ୍ବାଆଁ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଡ଼ୟାମାନାଣି ମେସାନା ଗାଡୁ ଦିନାତି ର଼ଗ ଗାଟାସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାହାଁ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ନେହିଁ ଆ଼ହାଲି ମ଼ନ କିହିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ର଼ଗ ଗାଟାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ବା଼ବୁ, ଏ଼ୟୁ ୱୀଡିନାଟି ନାଙ୍ଗେ ବାନ୍ଦାତା ଅ଼ହାଲି ତାକି ଆମ୍ବାଆସି ହିଲଅସି; ଅ଼ଡ଼େ, ନା଼ନୁ ହାନିବେ଼ଲାତା ଅ଼ଡ଼େ ରଅସି ନା଼ ନ଼କେଏ ହ଼ଡାହାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ, ନୀ ପା଼ସ୍‌ପନି ଡେ଼କାହାଁ ତା଼କାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାସି ନେହିଁ ଆ଼ତେସି ଅ଼ଡ଼େ ତାନି ପା଼ସ୍‌ପନି ଡେ଼କାନା ତା଼କାଲି ମା଼ଟ୍‌ହେସି । ଏ଼ ଦିନା ଜ଼ମିନି ଦିନା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ଈଦାଆଁତାକି, ଜୀହୁଦିୟାଁ ନେହିଁ ଆ଼ହାମାନି ମାଣ୍‌ସିଇଁ ଏଲେଇଚେରି, “ନୀଞ୍ଜୁ ଜ଼ମିନି ଦିନା, ପା଼ସ୍‌ପନି ଡେ଼କା ଅ଼ହାଲି ନିଙ୍ଗେତାକି ମେ଼ରା ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ସାମା, ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନାଙ୍ଗେ ନେହିଁ କିୟାତେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାତେସି, ନୀ ପା଼ସ୍‌ପନି ଡେ଼କାନା ତା଼କାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ନୀ ପା଼ସ୍‌ପନି ଡେ଼କାନା ତା଼କାମୁ ଇଞ୍ଜିଁ ଏଲେଇଞ୍ଜାତାସି, ଏ଼ୱାସି ଆମ୍ବାଆସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ସାମା ଏ଼ୱାସି ଆମ୍ବାଆସି, ଏ଼ ନେହିଁ ଆ଼ତାସି ପୁଞ୍ଜା ହିଲାଆତେସି, ଇଚିହିଁ ଏମ୍ବାଆଁ ଲ଼କୁ ମାନ୍ଦା ମାଚାକି ଜୀସୁ ମେହ୍‌ଆରେ଼ଟୁ ହାଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ଈଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ଏ଼ୱାଣାଇଁ ମେସାନା ଏଲେଇଚେସି, “ମେହ୍‌ମୁ, ନୀନୁ ନେହିଁ ଆ଼ହାମାଞ୍ଜି, ଅ଼ଡ଼େ ପା଼ପୁ କିଆନି, ଏ଼ନିକିଁ ନିଙ୍ଗେତାକି ଗାଡି କସ୍ତ ୱା଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ଏ଼ ମାଣ୍‌ସି ୱେଣ୍ଡା ହାଜାନା, ଆମ୍ବାଆସି ତାଙ୍ଗେ ନେହିଁ କିହାମାଚେସି, ଏ଼ୱାସି ଜୀସୁ ଇଞ୍ଜିଁ ଜୀହୁଦିଙ୍ଗାଣି ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଈଦାଆଁତାକି ଜୀସୁ ଜ଼ମିନି ଦିନାତା ଈଦାଆଁ କିହିମାଚାକି ଜୀହୁଦିଙ୍ଗା ଏ଼ୱାଣାଇଁ ନିନ୍ଦା କିହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ ଆ଼ବା ନୀଏଁ ପାତେକା କାମା କିହିମାନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ଜିକେଏ କାମା କିହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଈ ହା଼ଡା ତାକି ଜୀହୁଦିଙ୍ଗା ଜୀସୁଇଁ ପା଼ୟାଲି ତାକି ଅ଼ଡ଼େ ଗାଡି ଅଣ୍‌ପିତେରି, ଏ଼ୱାସି ଜ଼ମିନି ଦିନାତି ମେ଼ରାତି ଊରିତେସି ୱାର୍‌ଇ ଏ଼ଦି ଆ଼ଏ, ସାମା ମାହାପୂରୁଇଁ ନା଼ ଆ଼ବା ଇଞ୍ଜିଁ ୱେସାନା ତାଙ୍ଗେ ମାହାପୂରୁ ତଲେ ସମାନା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ସାତା ସାତା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀର୍‌ଏସି ଆ଼ବାଇଁ ଏ଼ନାଆଁ କିହିମାନାଣି ମେହ୍‌ନେସି, ଏ଼ଦାଆଁ ପିସ୍‌ପେ ଏ଼ୱାସି ତା଼ନୁଏ ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡଅସି । ଇଚିହିଁ ଆ଼ବା ଏ଼ନା ଏ଼ନାଆଁ କିନେସି, ମୀର୍‌ଏସି ଜିକେଏ ଏ଼ଦାଆଁ ବାରେ ଏଲେକିହିଁଏ କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଇଚିହିଁ ଆ଼ବା ମୀର୍‌ଏଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ତା଼ନୁ ଏ଼ନା ଏ଼ନାଆଁ କିନେସି, ଏ଼ଦାଆଁ ବାରେ ମୀର୍‌ଏଣାଇଁ ତ଼ହ୍‌ନେସି, ଅ଼ଡ଼େ ମୀରୁ ଏ଼ନିକିଁ କାବା ଆ଼ଦେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଏ଼ୱାଣି ତା଼ଣାଟି ଈଦାନି କିହାଁ ଆଡ଼େ କାଜା କାଜା କାମା ତ଼ହ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଆ଼ବା ଏ଼ନିକିଁ ହା଼ତି ଲ଼କୁଣି ନିକ୍‌ହାନା ଜୀୱୁ ହୀନେସି, ଏଲେକିହିଁଏ ମୀର୍‌ଏସି ଜିକେଏ ଆମ୍ବା ଆମ୍ବାଆରାଇଁ ମ଼ନ କିନେସି ଏ଼ୱାରାଇଁ ଜୀୱୁ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆ଼ବା ତା଼ନୁଏ ଆମ୍ବାଆରାଇଁ ନୀହାଁୟି କିଅସି, ସାମା ବାରେଜା଼ଣା ଏ଼ନିକିଁ ଆ଼ବାଇଁ ମା଼ନି କିହିମାନେରି, ଏଲେକିହିଁଏ ମୀର୍‌ଏଣାଇଁ ଜିକେଏ ମା଼ନି କିନେରି, ଏ଼ଦାଆଁତାକି ମୀର୍‌ଏଣାକି ବାରେ ନୀହାଁୟି କିହାଲି ଅଦିକାରା ହୀହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ଆମ୍ବାଆସି ମୀର୍‌ଏଣାଇଁ ମା଼ନି କିଅସି, ଏ଼ୱାସି ତାଙ୍ଗେ ପାଣ୍ତାତି ଆ଼ବାଇଁ ଜିକେଏ ମା଼ନି କିଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ନା଼ ବ଼ଲୁ ୱେଞ୍ଜାନା ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ନାମିନାସି, ଏ଼ୱାସି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ହାମାନେସି, ଅ଼ଡ଼େ, ଏ଼ୱାସି ନୀହାଁୟି କିୱିଆ଼ଆନା ହା଼କିତି ଜୀଣାଆ଼ହାନା ରା଼ଆଗାଟି ଜୀୱୁତା ହ଼ଡାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ର଼ ଦିନା ୱା଼ନେ ନୀଏଁ ଜିକେଏ ଏଦାତେୟିଏ, ଏମିନି ଦିନାତା ହା଼ତାରି ମାହାପୂରୁ ମୀର୍‌ଏଣି ହା଼ଡାତି ୱେନେରି ଅ଼ଡ଼େ ଆମ୍ବାଆରି ୱେନାରି ଏ଼ୱାରି ନୀଡିନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଇଚିହିଁ ଆ଼ବା ଏ଼ନିକିଁ ତା଼ନୁଏ ଜୀୱୁ ଗାଟାସି, ଏଲେକିହିଁଏ ଏ଼ୱାସି ମୀର୍‌ଏଣାଇଁ ଜିକେଏ ଜୀୱୁ ଗାଟାସି ଆ଼ହାଲି ହୀହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଅ଼ଡ଼େ, ଏ଼ୱାସି ମାଣ୍‌ସି ମୀର୍‌ଏସି ଆ଼ହାମାନାକି ଏ଼ୱାସି ଏ଼ୱାଣାକି ନୀହାଁୟି କିନି ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଈଦାଆଁତାକି କାବା ଆ଼ଆଦୁ, ଇଚିହିଁ ଏଚିବେ଼ଲା ହା଼ତି ଲ଼କୁ ମାହ୍‌ଣି ମାଣ୍ତାଟି ତାନି ଗିୟାଁ ୱେନେରି ଅ଼ଡ଼େ ଆମ୍ବାଆରି ସାତା କାମା କିହାମାନେରି, ");
INSERT INTO kxv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ଏ଼ୱାରି ଜୀୱୁତା ୱେଣ୍ତେ ନୀଡାଲିତାକି ଅ଼ଡ଼େ ଆମ୍ବାଆରି ଲାଗେଏତି କାମା କିହାମାନେରି, ଏ଼ୱାରି ନୀହାଁୟିତି ଡଣ୍ତ ତାକି ୱେଣ୍ତେ ନିଙ୍ଗା ୱା଼ନେରି, ଇଲେତି ଦିନା ୱା଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ନା଼ନୁ ନା଼ ତା଼ଣାଟି ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡଅଁ; ନା଼ନୁ ଏ଼ନିକିଁ ୱେଇଁ, ଏଲେକିହିଁଏ ନୀହାଁୟି କିଇଁ, ଅ଼ଡ଼େ ନା଼ ନୀହାଁୟି ଟିକ୍‌ଣାତାୟି, ଇଚିହିଁ ନା଼ନୁ ନା଼ ମ଼ନତଲେ କିହାଲି ଅଣ୍‌ପାଆନା, ନାଙ୍ଗେ ପାଣ୍ତାତାଣା ମ଼ନ ଲେହେଁ କିହାଲି ଅଣ୍‌ପିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ନା଼ନୁ ନାଙ୍ଗେତାକି ସା଼କି ହୀଇଁ, ଆ଼ତିଜିକେଏ ନା଼ ସା଼କି ସାତା ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ନା଼ କାତାତି ଆମ୍ବାଆସି ସା଼କି ହୀନେସି, ଏ଼ୱାସି ଅ଼ର ରଅସି; ଅ଼ଡ଼େ, ନା଼ କାତାତାକି ଏ଼ୱାଣି ସା଼କି ସାତା, ଏ଼ଦାଆଁ ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ମୀରୁ ଜହନ ତା଼ଣା ଲ଼କୁଣି ପାଣ୍ତାମାଞ୍ଜେରି ଅ଼ଡ଼େ ଏ଼ୱାସି ସାତା ତାକି ସା଼କି ହୀହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ସାମା ନାଙ୍ଗେ ମାଣ୍‌ସି ତା଼ଣାଟି ସା଼କି ଲ଼ଡ଼ା ଆ଼ଏ, ସାମା ମୀରୁ ଏ଼ନିକିଁ ଗେଲ୍‌ପି ଆ଼ଦେରି, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜହନ ଡ଼ୀଞ୍ଜିତି ମିଣ୍‌ସିମାନି ଦୀୱଁ ମାଚେସି, ଇଞ୍ଜାଁ ମୀରୁ ଏ଼ୱାଣି ଉଜେଡ଼ିତା ଗା଼ଡ଼େକା ତାକିଏ ରା଼ହାଁ ଆ଼ହାଁ ମାଞ୍ଜାଲି ମ଼ନ କିହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ସାମା ଜହନତି ସା଼କି କିହାଁ ନା଼ ତା଼ଣା ହା଼ରେକା କାଜା ସା଼କି ମାନେ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନି ଏ଼ନି କାମା ରା଼ପ୍‌ହାଲି ହୀହାମାଞ୍ଜାନେସି, ନା଼ନୁ ଏମିନି କାମା କିହିମାଇଁ, ଆ଼ବା ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନେସି ଇଞ୍ଜିଁ ଏ଼ ବାରେ ନା଼ ୱାକିଟି ସା଼କି ହୀହିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଅ଼ଡ଼େ ଏମିନି ଆ଼ବା ନାଙ୍ଗେ ପାଣ୍ତାତେସି, ଏ଼ୱାସି ନା଼ ତାକି ସା଼କି ହୀହାମାନେସି । ମୀରୁ ଏଚେଲା ଏ଼ୱାଣି ହା଼ଡା ୱେଞ୍ଜା ହିଲଅତେରି କି ତାନି ମୂମ୍ବୁ ମେସା ହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଅ଼ଡ଼େ ଏ଼ୱାଣି ବ଼ଲୁ ମୀ ହିୟାଁତା ଇଟାହିଲଅତେରି, ଇଚିହିଁ ଏ଼ୱାସି ଆମ୍ବାଆରାଇଁ ପାଣ୍ତାତେସି ମୀରୁ ଏ଼ୱାଣାଇଁ ନାମିହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ମୀରୁ ଦାର୍ମୁ ପତିତି କାତା ପାରିମାଞ୍ଜେରି, ଇଚିହିଁ ଏମ୍ବାଆଁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟାଆ଼ହାମାନମି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ଅ଼ଡ଼େ ଏ଼ ଦାର୍ମୁ ପତି ନା଼ ୱାକିଟି ସା଼କି ହୀହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ସାମା ମୀରୁ ଜୀୱୁ ବେଟାଆ଼ହାଲି ତାକି ନା଼ ତା଼ଣା ୱା଼ହାଲି ମ଼ନ କିହିହିଲଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ନା଼ନୁ ମାଣ୍‌ସିୟାଁ ତା଼ଣାଟି ଗାୱୁରମି ପାରିହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜାଇଁ, ମୀ ହିୟାଁତା ମାହାପୂରୁତି ଜୀୱୁନ଼ନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ନା଼ନୁ ନା଼ ଆ଼ବା ଦ଼ରୁଟି ୱା଼ହାମାଇଁ, ଅ଼ଡ଼େ ମୀରୁ ନାଙ୍ଗେ ଅ଼ପିମାଞ୍ଜଅତେରି; ଅ଼ର ରଅସି ତାନି ଦ଼ରୁଟି ୱା଼ତିହିଁ, ମୀରୁ ଏ଼ୱାଣାଇଁ ଅ଼ପିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ମୀରୁ ଏ଼ନିକିଁ ନାମିମାଞ୍ଜେରି ? ମୀରୁ ମୀ ତା଼ଣାଟି ଗାୱୁରମି ବେଟାଆ଼ହି ମାଞ୍ଜେରି, ଅ଼ଡ଼େ ଏମିନି ରଣ୍ତିଏ ମାହାପୂରୁ ତା଼ଣାଟି ଗାୱୁରମି ଏ଼ଦାଆଁ ବେଟାଆ଼ହାଲି ମ଼ନ କିହିହିଲଅତେରି ");
INSERT INTO kxv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ନା଼ନୁ ଆ଼ବା ନ଼କିତା ମୀ କ଼ପାଟି ଦ଼ହ ଦସ୍ତାଇଁ, ଏଲେଇଞ୍ଜି ଅଣ୍‌ପାଆଦୁ; ଆମିନି ମ଼ସା ତା଼ଣା ମୀରୁ ବା଼ର୍ସୁ ଇଟାମାଞ୍ଜେରି, ଏ଼ୱାସିଏ ମୀ କ଼ପାଟି ଦ଼ହ ଦସି ମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଇଚିହିଁ ମୀରୁ ମ଼ସାଇଁ ନାମା ମାଚିହିଁ, ନାଙ୍ଗେ ଜିକେଏ ନାମାତେରିମା, ଇଚିହିଁ ଏ଼ୱାସି ନା଼ କାତେଏ ରା଼ଚାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ସାମା ମୀରୁ ଏ଼ୱାଣି ରା଼ଚାମାନି କାତା ନାମା ହିଲଅତେରି, ଆତିହିଁ ନା଼ କାତା ଏ଼ନିକିଁ ନାମିଦେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ଈଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ଗାଲିଲି ସାମ୍‌ଦୁରି, ଇଚିହିଁ ତିବିରିୟା ସାମ୍‌ଦୁରି ଆତାଲାୱାକି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଅ଼ଡ଼େ ଏ଼ୱାସି ର଼ଗ ଗାଟାରାଇଁ ଏ଼ନି ଏ଼ନି କାବାଆ଼ନି କାମା କିହାମାଚେସି, ଏ଼ ବାରେ ମେସାନା ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଏମ୍ବାଟିଏ ଜୀସୁ ସୀସୁୟାଁ ତଲେ ର଼ ହ଼ରୁ ଲାକ ହାଜାନା କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ଏଚିବେ଼ଲା ଜୀହୁଦି ଲ଼କୁତି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଡାଗେ ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ହା଼ରେକା ଲ଼କୁ ତାନି ତା଼ଣା ୱା଼ହିମାନାଣି ମେସାନା, ଜୀସୁ, ପିଲିପଇଁ ଏଲେଇଚେସି, “ଈୱାରାକି ତିଞ୍ଜାଲି ମା଼ର ଆମ୍ବିଟି ରା଼ନ୍ଦା କଡିନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ସାମା ଏ଼ୱାସି ପିଲିପଇଁ ତାୟିପାରି କିୟାଲି ଏଲେଇଚେସି, ଇଚିହିଁ ଏ଼ୱାସି ଏ଼ନାଆଁ କିନାୟିମାନେ, ଏ଼ଦାଆଁ ତା଼ନୁଏ ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ବାରେ ଲ଼କୁତାକି ଇଚା ଇଚାଣି ତିଞ୍ଜାଲି ରୀ ୱାଞ୍ଜାଟିଏ ଆଗାଡ଼ା ୱେଣ୍ତି ଟାକାୟାଁତି ରୂଟି ଜିକେଏ ହା଼ଲାଉ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି, ସିମନ ପିତର ତାୟି ଆନ୍ଦ୍ରିୟ ଦ଼ରୁଗାଟାସି ଜୀସୁଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ଇମ୍ବାଆଁ ର଼ କକାସି ମାନେସି, ତାନିତା଼ଣା ପା଼ସାଗଟା ରୂଟି ଇଞ୍ଜାଁ ୱାଜିତି ମୀଣ୍‌କା ରିଣ୍ତି ମାନୁ, ସାମା ଇଚେକା ଲ଼କୁତାକି ଏ଼ୱି ହା଼ଲିନୁ କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜୀସୁ ଏଲେଇଚେସି, “ଲ଼କୁଣି କୁପ୍‌କି କିଦୁ ।” ଏ଼ ଟା଼ୟୁତା ହା଼ରେକା ଗାର୍କି ଜା଼ଡ଼ା ମାଚେ । ଏମ୍ବାଆଁ ପା଼ସାମା଼ଣା ଆ଼ବାୟାଁ କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ଏମ୍ବାଟିଏ ଜୀସୁ ରୂଟି ଆସାନା ମାହାପୂରୁଇଁ ଜହରା ହୀହାନା ଏମ୍ବାଆଁ କୁଗାମାନାରାକି ଏ଼ଦାଆଁ ବା଼ଟିକିହାଁ ହୀତେରି, ମୀଣ୍‌କା ଜିକେଏ ଏଲେକିହିଁଏ ବା଼ଟିକିତେରି, ଏଚେକା ମ଼ନ କିତେରି ଏ଼ୱାରାକି ଏଚେକା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ଅ଼ଡ଼େ ଏ଼ୱାରି ବାରେ ପାଞ୍ଜିତି ଡା଼ୟୁ, ଜୀସୁ ତାନି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଏଚେକା ହା଼ରାମାନେ, ଏ଼ଦାଆଁ ବାରେ କୂଡ଼ି କିଦୁ ଏ଼ନିକିଁ ଇଚାୟି ଜିକେଏ ନସ୍ତ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ଏଚେଟିଏ ଲ଼କୁ ତିଚି ଡା଼ୟୁ ପା଼ସାଗଟା ରୂଟି ବିତ୍ରାଟି ହା଼ରାମାଚି ମୁକାୟାଁ ବା଼ର ଡାଲି କୂଡ଼ି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଜୀସୁତି ଈ କାବାଆ଼ନି କାମା ମେସାନା ଲ଼କୁ ଏଲେଇଚେରି, “ଆମିନି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେ଼କ୍‌ନାସି ଦାର୍‌ତିତା ୱା଼ନାୟି ମାଚେ, ଏ଼ୱାସି ସାତେଏ ଈୱାସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ୱା଼ହାନା ରାଜା କିୟାଲି ବାଲ୍‌ମିଟି ଆସା ଅୟାନେରି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଜୀସୁ ଏଟ୍‌କା ଆ଼ହାନା ରଅସିଏ ଦାରିତା ମାଚି ହ଼ରୁ ଲାକ ହ଼ଚାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ମିଡ଼୍‌ଅଲା ଆ଼ହାଲିଏ ତାନି ସୀସୁୟାଁ ସାମ୍‌ଦୁରି ଗାଟୁତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ଅ଼ଡ଼େ ସାମ୍‌ଦୁରି ଆତାଲା ମାନି କପର୍‌ନାହୁମ ୱାକି ହାଜାଲି ଡଂଗତା ହ଼ତେରି । ଆନ୍ଦେରି ଆ଼ହାହାଚେ, ଅ଼ଡ଼େ, ଜୀସୁ ଏଚିବେ଼ଲା ପାତେକା ଏ଼ୱାରିତା଼ଣା ୱା଼ହା ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ଇଞ୍ଜାଁ କାଜା ଗା଼ଲି ୱେ଼ଚିମାଚାକି ସାମ୍‌ଦୁରିତା ଆଜିହ଼ପେତି ଏ଼ୟୁ ଉଣ୍ତାୟାଁ ନିଙ୍ଗିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଏଚିବେ଼ଲା ଏ଼ୱାରି ସ଼ କିଲମିଟର ହେକ ହାଜାଲିଏ ଜୀସୁ ସାମ୍‌ଦୁରିତା ତା଼କିହିଁ ଡଂଗ ୱାକି ୱା଼ହିମାନାଣି ମେସାନା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ସାମା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆଜାଆଦୁ ଈୱାତେଏଁ ନା଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଡଂଗତା ଅ଼ହାଲି ମ଼ନ କିତେରି, ଅ଼ଡ଼େ, ଏମିନି ସାମ୍‌ଦୁରି ଗାଟୁତା ହାଜିମାଚେରି, ଦେବୁଣିଏ ଏ଼ ଟା଼ୟୁତା ଡଂଗ ଏତେ । ");
INSERT INTO kxv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଏ଼ ଟା଼ୟୁତା ର଼ ଡଂଗ ପିସ୍‌ପେ ଏଟ୍‌କାତି ଡଂଗୟାଁ ହିଲାଆତୁ, ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ଜୀସୁ ତାନି ସୀସୁୟାଁ ତଲେ ହାଜାହିଲାଆତେସି, ସାମା ୱାର୍‌ଇ ସୀସୁୟାଁ ହାଜାମାଚେରି, ଈଦାଆଁ ଆମିନି ଲ଼କୁ ତାନି ଅ଼ର ନେ଼ଚୁ ସାମ୍‌ଦୁରି ଆତାଲା ନିଚାମାଚେରି ଏ଼ୱାରି ମେସାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ଆମିନି ତା଼ଣା ଜୀସୁ ଜହରା କିହାନା ଲ଼କୁଣି ରୂଟି ତିଞ୍ଜାଲି ହୀହାମାଚେସି, ତିବିରିୟାଟି ଅ଼ଡ଼େ ଏଚରଗଟା ଡଂଗାଁୟାଁ ଏ଼ ଟା଼ୟୁତା ୱା଼ତୁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଇଞ୍ଜାଁ ଜୀସୁ ତାନି ସୀସୁୟାଁ ଏମ୍ବାଆଁ ହିଲାଆତେରି, ଈଦାଆଁ ମେସାନା ବାରେ ଲ଼କୁ ଈ ଡଂଗତା ହ଼ଚାନା ଜୀସୁଇଁ ପାରି ପାରିହିଁ କପର୍‌ନାହୁମତା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଏ଼ୱାରି ସାମ୍‌ଦୁରି ଆତାଲା ଜୀସୁଇଁ ବେଟାଆ଼ହାନା ୱେଚେରି, ଏ଼ “ଗୂରୁ, ନୀନୁ ଏଚିବେ଼ଲା ଇମ୍ବାଆଁ ୱା଼ତି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନା଼ କାବାଆ଼ନି କାମା ମେସ୍ତାକି ନାଙ୍ଗେ ପାରିମାଞ୍ଜାଦେରି ଏ଼ଦି ଆ଼ଏ, ସାମା ରୂଟି ତିଞ୍ଜା ପାଞ୍ଜିତାକି ମୀରୁ ନାଙ୍ଗେ ପାରିମାଞ୍ଜାଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ସୀର୍‌ନି ରା଼ନ୍ଦା ତାକି କାମା କିଆନା, କା଼ଲାକା଼ଲାତି ଜୀୱୁତାକି ଡ଼ୟିନି ରା଼ନ୍ଦା ତାକି କାମା କିଦୁ, ଏ଼ ରା଼ନ୍ଦା ମାଣ୍‌ସି ମୀର୍‌ଏସି ମିଙ୍ଗେ ହିୟାନେସି, ଇଚିହିଁ ତାନି ଆ଼ବା ମାହାପୂରୁ ଏ଼ୱାଣାକି ଅଦିକାରା ହୀହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ମାହାପୂରୁତି ବାରେ କାମା କିହାଲିତାକି ମାଙ୍ଗେ ଏ଼ନାଆଁ କିହାଲି ଆ଼ନେ ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ଆମ୍ବାଆରାଇଁ ପାଣ୍ତାମାଞ୍ଜାନେସି, ଏ଼ୱାଣି ତା଼ଣା ନାମିନାୟି ମାହାପୂରୁତି କାମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ଏଚେଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଆତିହିଁ ନୀନୁ ସିନାଲେହେଁ ଏ଼ନାଆଁ କିହିମାଞ୍ଜି, ଏ଼ଦାଆଁ ମେସାନା ମା଼ମ୍ବୁ ନିଙ୍ଗେ ନାମାନମି ? ");
INSERT INTO kxv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ମା଼ ଆକୁ ଆ଼ବାୟାଁ ଲ଼କୁ ଡ଼ୟାଆ ଟା଼ୟୁତା ‘ମାନା’ ତିଞ୍ଜା ମାଚେରି, ଦାର୍ମୁପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ତିଞ୍ଜାଲି ଏ଼ୱାସି ଏ଼ୱାରାକି ଲାକପୂରୁଟି ରା଼ନ୍ଦା ହୀତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଏଚେଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ସାତା ସାତା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମ଼ସା ମିଙ୍ଗେ ଲାକପୂରୁଟି ରା଼ନ୍ଦା ହୀହାମାଞ୍ଜଅସି, ସାମା ନା଼ ଆ଼ବା ମିଙ୍ଗେ ଲାକପୂରୁଟି ସାତା ରା଼ନ୍ଦା ହିୟାନେସି; ");
INSERT INTO kxv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଇଚିହିଁ ଆମିନି ରା଼ନ୍ଦା ଲାକପୂରୁଟି ୱା଼ହାନା ଦାର୍‌ତିତି ଲ଼କୁଣି ଜୀୱୁ ହୀନେ, ଏ଼ଦି ମାହାପୂରୁ ହିୟାତି ରା଼ନ୍ଦା ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ଏ଼ୱାରି ଜୀସୁଇଁ ଏଲେଇଚେରି, “ପ୍ରବୁ, ମାଙ୍ଗେ ବାରେଦିନା ଏ଼ ରା଼ନ୍ଦା ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁଏ ଜୀୱୁତି ରା଼ନ୍ଦାତେଏଁ; ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ୱା଼ନେସି, ଏ଼ୱାସି ଏଚେଲା ହାକି ଆ଼ଅସି, ଅ଼ଡ଼େ ନା଼ ତା଼ଣା ନାମିନାସି, ଏଚେଲା ଏ଼ସ୍‌କି ଆ଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ନାଙ୍ଗେ ମେସ୍ତାତି ଜିକେଏ ନାମିମାଞ୍ଜଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଆ଼ବା ନାଙ୍ଗେ ଆମ୍ବାଆରାଇଁ ହିୟାନେସି, ଏ଼ୱାରି ବାରେଜା଼ଣା ନା଼ ତା଼ଣା ୱା଼ନେରି; ଅ଼ଡ଼େ ନା଼ ତା଼ଣା ୱା଼ନାଣାଇଁ, ନା଼ନୁ ଏଚେଲାୱା ପାଙ୍ଗାତା ପିହ୍‌ଅଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଇଚିହିଁ ନା଼ନୁ ଅଣ୍‌ପିନି ଲେହେଁ କିହାଲି ୱା଼ହାହିଲଅଁ, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାତାଣା ଅଣ୍‌ପୁ ତଲେ କିହାଲି ଲାକପୂରୁଟି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଅ଼ଡ଼େ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାସି ଆମିନି ଗାଟାରାଇଁ ନାଙ୍ଗେ ହିୟାନେସି, ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆରାଇଁ ଜିକେଏ ଏ଼ନିକିଁ ନା଼ନୁ ଜା଼କ୍‌ଅଁ, ସାମା ରା଼ନି ଦିନାତା ଏ଼ୱାରାଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ଇଁ, ଈଦି ଏ଼ୱାଣି ଅଣ୍‌ପୁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଇଚିହିଁ ଆମ୍ବାଆସି ମୀର୍‌ଏଣାଇଁ ମେସାନା ଏ଼ୱାଣି ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ଏ଼ନିକିଁ କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ନେସି, ଈଦି ନା଼ ଆ଼ବାତି ଅଣ୍‌ପୁ, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ରା଼ନି ଦିନାତା ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ନା଼ନୁ ଲାକପୂରୁଟି ରେ଼ଚା ୱା଼ହାମାନି ରା଼ନ୍ଦାତେଏଁ ଇଞ୍ଜିଁ ଏ଼ୱାସି ଏଲେଇଞ୍ଜାଲିଏ ଜୀହୁଦିୟାଁ ଏ଼ୱାଣି କ଼ପାଟି ଏଲେଇଞ୍ଜି ଜ଼ଲ୍‌କି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“ଈୱାସି ଜସେପ ମୀର୍‌ଏସି ଜୀସୁ ଆ଼ଏକି, ଅ଼ଡ଼େ ମା଼ର ଈୱାଣି ଇୟା ଆ଼ବାତି ପୁଞ୍ଜାହିଲାଆୟି କି ? ଆତିହିଁ ନା଼ନୁ ଲାକପୂରୁଟି ରେ଼ଚା ୱା଼ହାମାଇଁ ଇଞ୍ଜିଁ ଏ଼ୱାସି ନୀଏଁ ଏ଼ନିକିଁ ୱେସିମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ମୀରୁ ମୁରୁମୁର ଜ଼ଲ୍‌କି ଆ଼ଆଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନି ଆ଼ବା ଆମ୍ବାଆରାଇଁ ରେଜା କଡିନେସି, ଏ଼ୱାସିଦେଁ ନା଼ ତା଼ଣା ୱା଼ହାଲି ଆ଼ଡିନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ରା଼ନି ଦିନାତା ଏ଼ୱାଣାଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଦାର୍ମୁପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ବାରେଜା଼ଣା ମାହାପୂରୁ ତା଼ଣାଟି ଜା଼ପିନେରି । ଆମ୍ବାଆସି ଆ଼ବାତି କାତା ୱେଞ୍ଜାନା ଜା଼ପାମାନେସି, ଏ଼ୱାସି ନା଼ ତା଼ଣା ୱା଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଆମ୍ବାଆସି ଆ଼ବାଇଁ ମେସାହିଲଅସି, ଆମ୍ବାଆସି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନାସି, ୱାର୍‌ଇ ଏ଼ୱାସି ମେସାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ନାମିନେସି, ଏ଼ୱାସି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ନା଼ନୁ ଜୀୱୁତି ରା଼ନ୍ଦାତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ମୀ ଆକୁ ଆ଼ବାୟାଁ ଲ଼କୁ ଡ଼ୟାଆ ଟା଼ୟୁତା ମାନା ତିଞ୍ଜାନା, ହା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ଆମ୍ବାଆରି ଏ଼ନିକିଁ ରା଼ନ୍ଦା ତିଞ୍ଜାନା ହା଼ଅରି, ଏ଼ଦାଆଁତାକି ଲାକପୂରୁଟି ୱା଼ନି ରା଼ନ୍ଦା ଈଦି । ");
INSERT INTO kxv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ନା଼ନୁ ଲାକପୂରୁଟି ୱା଼ହାମାନି ଏ଼ ଜୀୱୁଗାଟି ରା଼ନ୍ଦାତେଏଁ; ଆମ୍ବାଆସି ଏ଼ ରା଼ନ୍ଦା ତିନେସି, କା଼ଲାକା଼ଲା ତାକି ନୀଡିନେସି; ହାଅ, ନା଼ନୁ ଏମିନି ରା଼ନ୍ଦା ହୀଇଁ, ଏ଼ୱି ନା଼ ଊଙ୍ଗା, ନା଼ନୁ ଏ଼ୱାଆଁ ଦାର୍‌ତିତି ଜୀୱୁତାକି ହୀଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଈ ହା଼ଡା ୱେଞ୍ଜାନା ଜୀହୁଦିୟାଁ କାର୍‌ବି ଆ଼ହାନା ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ଈୱାସି ଏ଼ନିକିଁ ମାଙ୍ଗେ ତାନି ଊଙ୍ଗା ତିଞ୍ଜାଲି ହିୟାଲି ଆ଼ଡାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମାଣ୍‌ସି ମୀର୍‌ଏଣି ଊଙ୍ଗା ତିନାଆସାରେ ଅ଼ଡ଼େ ତାନି ନେତେରି ଗହ୍‌ଆସାରେ, ମୀ ତା଼ଣା ଜୀୱୁ ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଆମ୍ବାଆସି ନା଼ ଊଙ୍ଗା ତିନେସି ଅ଼ଡ଼େ ନା଼ ନେତେରି ଗହ୍‌ନେସି, କା଼ଲାକା଼ଲାତି ଜୀୱୁ ବେଟା ଆ଼ନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ରା଼ନି ଦିନାତା ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଇଚିହିଁ ନା଼ ଊଙ୍ଗା ସାତା ରା଼ନ୍ଦା ଅ଼ଡ଼େ ନା଼ ନେତେରି ସାତା ଗହ୍‌ନାୟି । ");
INSERT INTO kxv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଆମ୍ବାଆସି ନା଼ ଊଙ୍ଗା ତିନେସି ଅ଼ଡ଼େ ନା଼ ନେତେରି ଗହ୍‌ନେସି, ଏ଼ୱାସି ନା଼ ତା଼ଣା ଡ଼ୟିନେସି ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣା ଡ଼ୟିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜୀୱୁତି ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନିକିଁ ପାଣ୍ତାମାଞ୍ଜାନେସି ଅ଼ଡ଼େ ନା଼ନୁ ତାନିତା଼ଣାଟି ନୀଡାମାଇଁ, ଏଲେକିହିଁଏ ଆମ୍ବାଆସି ନାଙ୍ଗେ ତିଞ୍ଜାନେସି, ଏ଼ୱାସି ଜିକେଏ ନା଼ ତା଼ଣାଟି ନୀଡିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଆମିନି ରା଼ନ୍ଦା ଲାକପୂରୁଟି ୱା଼ହାମାନେ, ଏ଼ଦି ଈଦି; ମୀ ଆକୁ ଆ଼ବାୟାଁ ଏ଼ନିକିଁ ତିଞ୍ଜାନା ହା଼ତେରି, ଈଦି ଏଲେତାୟି ଆ଼ଏ, ଆମ୍ବାଆସି ଈ ରା଼ନ୍ଦା ତିନାସି ଏ଼ୱାସି କା଼ଲାକା଼ଲା ତାକି ଜୀୱୁତଲେ ଡ଼ୟିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜୀସୁ କପର୍‌ନାହୁମତି ର଼ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ମାହାପୂରୁ ବ଼ଲୁ ୱେସିମାଚାଟି ଈ ବାରେ କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ଜୀସୁତି ସୀସୁୟାଁ ବିତ୍ରାଟି ହା଼ରେକା ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ଏଲେଇଚେରି, “ଈଦି ଅ଼ପାଆଗାଟି କାତା, ଆମ୍ବାଆସି ଈଦାଆଁ ୱେଞ୍ଜାଲି ଆ଼ଡିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ଏ଼ୱାରି ଈ କାତାତାକି ୱେସ୍‌ପି ଆ଼ହିମାନେରି ଇଞ୍ଜିଁ ଜୀସୁ ପୁଞ୍ଜାନା ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଈ କାତା ମିଙ୍ଗେ ଅ଼ପାଆଗାଟାୟି ଆ଼ହିମାନେ କି ? ");
INSERT INTO kxv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଆତିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ତଲିଏ ମାଚି ଟା଼ୟୁତା, ୱେଣ୍ତେ ହାନାଣି ମେସ୍ତିହିଁ, ଏ଼ନାଆଁ ଇଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ମାହାପୂରୁତି ଜୀୱୁ ନୀଡାଲି ହୀନାୟି; ମାଣ୍‌ସିତି ଆଙ୍ଗା ଏ଼ନାଆଁ କିୟାଲି ଆ଼ଡେଏ; ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାତି ବ଼ଲୁ ବାରେ, ସୁଦୁଜୀୱୁ ଅ଼ଡ଼େ ନୀଡିନି ବ଼ଲୁ । ");
INSERT INTO kxv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ସାମା ମୀ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ନାମିହିଲଅରି” ଇଚିହିଁ ଆମ୍ବାଆରି ନାମି ହିଲାଆତେରି ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଏ଼ୱାଣାଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପିନେସି ଏ଼ଦାଆଁ ଜୀସୁ ତଲିଏ ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ଆ଼ବା ହେଲ ହୀଆତିହିଁ ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ୱାୟାଲି ଆ଼ଡଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଏ଼ ଦିନାଟିଏ ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ହା଼ରେକା ଜା଼ଣା ଅ଼ପାଆନାହାଁ ହାଜାତୁସ୍ତେରି, ଇଞ୍ଜାଁ, ଏ଼ୱାଣିତଲେ ଅ଼ଡ଼େ ହାଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ଏମ୍ବାଟିଏ ଜୀସୁ ବା଼ରଜା଼ଣା ସୀସୁୟାଁଣି ୱେଚେସି, “ମୀରୁ ଜିକେଏ ହାଜାଲି ମ଼ନ କିହିମାଞ୍ଜେରି କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମନ ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ ଆମ୍ବାଆରି ତା଼ଣା ହାନମି ? କା଼ଲାକା଼ଲାତି ଜୀୱୁତି ବ଼ଲୁ ନୀ ତା଼ଣା ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ନୀନୁ, ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନି ଏ଼ ସୁଦୁ ମାଣ୍‌ସିତି ଈଦାଆଁ ମା଼ମ୍ବୁ ନାମା ମାନମି ଅ଼ଡ଼େ ପୁଞ୍ଜାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ନାଆଁ ମୀ ବା଼ରଜା଼ଣାତେରି ମିଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜଅଁ କି ? ଅ଼ଡ଼େ ମୀ ବିତ୍ରାଟି ରଅସି ସୟତାନ ।” ");
INSERT INTO kxv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଏ଼ୱାସି ଇସ୍କାରିୟତ ସିମନ ମୀର୍‌ଏସି ଜୀହୁଦାଇଁ ସିନିକିହାନା ଏଲେଇଚେସି, ଇଚିହିଁ ଏ଼ୱାସି ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଜୀସୁଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପାଲି ହାଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ଈଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ଗାଲିଲିତା ରେ଼ଜିମାଚେସି, ଇଚିହିଁ ଜୀହୁଦିୟାଁ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ଅଣ୍‌ପି ମାଚାକି ଏ଼ୱାସି ଜୀହୁଦା ରା଼ଜିତା ରେ଼ଜାଲି ମ଼ନ କିହି ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ସାମା ଜୀହୁଦି ଲ଼କୁତି “ଗଚାୟାଁ ଗୂଡ଼ାତା ବାସାଆ଼ନି” ପାର୍ବୁ ଡାଗେ ୱା଼ହିମାଚାକି । ");
INSERT INTO kxv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ଜୀସୁତି ତାୟିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀନୁ କିହିମାନି କାମାୟାଁ, ନୀ ସୀସୁୟାଁ ଜିକେଏ ମେହ୍‌ନେରି ଈଦାଆଁତାକି ନୀନୁ ଇମ୍ବାଟି ହ଼ଚା ହାଜାନା ଜୀହୁଦା ରା଼ଜିତା ହାଲାମୁ । ");
INSERT INTO kxv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଇଚିହିଁ ଲ଼କୁତା଼ଣା ୱେ଼ଙ୍ଗାଲି ମ଼ନ କିନାସି ତାନି କାମା ଡ଼ୁଗାହାଁ କିଅସି । ନୀନୁ ଈ ବାରେ କାମା କିହିମାଞ୍ଜି, ଆତିହିଁ ନୀନୁ ଦାର୍‌ତି ନ଼କିତା ତ଼ସାକଡାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଇଚିହିଁ ତାନି ତାୟିୟାଁ ଜିକେଏ ତାଙ୍ଗେ ନାମି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନୀଏଁ ପାତେକା ନା଼ ଦିନା ଏଜାମାଞ୍ଜେଏ, ସାମା ମୀ ଦିନା କା଼ଲେଏ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଦାର୍‌ତିତାରି ମିଙ୍ଗେ ଅ଼ପାନେରି ସାମା ନାଙ୍ଗେ ଅ଼ପଅରି ଏ଼ନାଆଁତାକି ଇଚିହିଁ ତାମି କାମା ବାରେ ଲାଗେଏତାୟି ଇଞ୍ଜିଁ ନା଼ନୁ ସା଼କି ହୀହାନା ତ଼ସିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ମୀରୁ ଈ ପାର୍ବୁତା ହାଜୁ, ନା଼ନୁ ନୀଏଁ ଈ ପାର୍ବୁତା ହାଜିହିଲଅଁ, ଇଚିହିଁ ନା଼ ଦିନା ୱା଼ହାହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଈ ବାରେ କାତା ୱେସାନା ଗାଲିଲିତା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ଜୀସୁତି ତାୟିୟାଁ ଏ଼ ପାର୍ବୁତା ହାଚି ଡା଼ୟୁ, ଜୀସୁ ଜିକେଏ ହାଚେସି ସାମା ଲ଼କୁ ମେହ୍‌ଆରେ଼ଟୁ ମେଣେଏ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ପାର୍ବୁ ବେ଼ଲାତା ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପାରି ପାରିହିଁ, “ଏ଼ୱାସି ଏମ୍ବିୟା ମାନେସି ଇଞ୍ଜିଁ ୱେଚେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ବାରେ ଲ଼କୁ ଏ଼ୱାଣି ତାକି କିଲିବିଲି ଆ଼ହିମାଚେରି, ଏଚରଜା଼ଣା “ଏ଼ୱାସି ନେହିଁ ମାଣ୍‌ସି” ଇଚେରି; ଅ଼ଡ଼େ ଏଚରଜା଼ଣା “ଆ଼ଏ, ଏ଼ୱାସି ଲ଼କୁଣି ନା଼ଡ଼ି କିହିମାନେସି” ଇଞ୍ଜିଁ ଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ସାମା ଜୀହୁଦିୟାଁ ଆଜିତାକି ଆମ୍ବାଆରି ତାନି କାତା ପାଙ୍ଗାୱେ଼ଙ୍ଗେ ୱେସି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ସାମା ପାର୍ବୁତି ମାଦି ପାତେକା ରା଼ହାଲିଏ, ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ହାଜାନା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଏମ୍ବାଟିଏ ଜୀହୁଦିୟାଁ କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଈୱାସି ପା଼ଟା ଜା଼ପାଆନାହାଁ ଏ଼ନିକିଁ ଇଚେକା ବୁଦି ପୁଚେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜା଼ପ୍‌ହିମାନାୟି ନା଼ ତା଼ଣାଟି ଆ଼ଏ, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାତାଣାୱାୟି । ");
INSERT INTO kxv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଆମ୍ବାଆସି ତାନି ଅଣ୍‌ପୁ ତଲେ କିହାଲି ଅଣ୍‌ପିନେସି, ଆ଼ତିସାରେ ଈ ଜା଼ପ୍‌ନାୟି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନେ, କି, ନା଼ ତା଼ଣାଟି ୱେସିମାଇଁ, ଏ଼ଦାଣି ଏ଼ୱାସି ପୁନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଆମ୍ବାଆସି ନା଼ଦିଏ ଇନେସି, ଏ଼ୱାସି ତାନି ଗାୱୁରମି ପାରିନେସି, ସାମା ଆମ୍ବାଆସି ତାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାଣା ଗାୱୁରମି ପାରିନେସି, ଏ଼ୱାସି ସାତା, ଅ଼ଡ଼େ ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନାୟି ଲାଗେଏ କିନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମ଼ସା ମିଙ୍ଗେ ମେ଼ରା ହୀହାମାଞ୍ଜଅସି କି ? ଆ଼ତିଜିକେଏ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆତେରି ମେ଼ରାତି ମା଼ନୱି ଆ଼ହି ହିଲଅତେରି, ମୀରୁ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ପା଼ୟାଲି ଅଣ୍‌ପିମାଞ୍ଜାଦେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ଲ଼କୁ ବାରେ ଏଲେଇଚେରି, “ନିଙ୍ଗେ ବୂତୁ ଆଲ୍‌ଗାମାଞ୍ଜାନେ, ନିଙ୍ଗେ ଆମ୍ବାଆସି ପା଼ୟାଲି ଅଣ୍‌ପି ମାଞ୍ଜାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ର଼ କାବାଆ଼ନି କାମା କିତେଏଁ, ଅ଼ଡ଼େ ମୀରୁ ବାରେ କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ଈଦାଆଁତାକି ମ଼ସା ମିଙ୍ଗେ ତ଼ଲୁ ଦା଼ପି କିନି ମେ଼ରା ହୀହାମାଞ୍ଜାନେସି, ଈ ମେ଼ରା ମ଼ସା ତା଼ଣାଟି ଆ଼ହାମାନେ, ଏ଼ଦି ଆ଼ଏ, ସାମା ଆକୁ ଆ଼ବାୟାଁ ତା଼ଣାଟି, ଇଞ୍ଜାଁ ମୀରୁ ଜ଼ମିନି ଦିନାତା ଜିକେଏ କକାରି ତ଼ଲୁ ଦା଼ପି କିହିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଜ଼ମିନି ଦିନାତା ର଼ କକାଣି ତ଼ଲୁ ଦା଼ପି କିନାଣିତାକି ମ଼ସାତି ମେ଼ରା ଊରିହିଲଅତେରି, ଆତିହିଁ ନା଼ନୁ ଜ଼ମିନି ଦିନାତା ର଼ ମାଣ୍‌ସିତି ଗୂଡ଼ା ଆଙ୍ଗା ନେହିଁ କିୟାଲିଏ ମୀରୁ ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି କ଼ପା ଆ଼ହିମାଞ୍ଜାଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ୱାର୍‌ଇ ଲାକ ଲାକ କାତା ମେସାନା ନୀହାଁୟି କିଆଦୁ ସାତା ତଲେ ନୀହାଁୟି କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଏଚେଟିଏ ଜିରୁସାଲମତା ମାନାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ୱେସ୍‌ପି ଆ଼ତେରି, “ଆମ୍ବାଆରାଇଁ ଈୱାରି ପା଼ୟାଲି ଅଣ୍‌ପିମାନେରି ଈୱାସି ଏ଼ୱାସି ଆ଼ଏକି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ଏ଼ୱାସି ଲ଼କୁ ପୁଣ୍‌ମ୍ବେ କାତା ୱେସିମାନେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ସା଼ଲୱି କିନାରି ଏ଼ନାଆଁ କିହିହିଲଅରି । ଏ଼ୱାସି କ୍ରୀସ୍ତ ଇଞ୍ଜିଁ ଏ଼ୱାରି ଏ଼ନାଆଁ ସାତା ତଲେ ପୁଚେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଆତିହିଁ ଏ଼ୱାସି, ଆମ୍ବିଟି ୱା଼ହାମାନେସି, ଈଦାଆଁ ମା଼ର ପୁଞ୍ଜାମାନାୟି, ସାମା କ୍ରୀସ୍ତ ଏଚିବେ଼ଲା ୱା଼ନେସି, ଏଚିବେ଼ଲାତା ଆମ୍ବାଆସି ପୁନଅସି, ଇଚିହିଁ ଏ଼ୱାସି ଆମ୍ବିଟି ୱା଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଜୀସୁ ମାହାପୂରୁ ଇଲୁତା ମାହାପୂରୁ କାତା ୱେସି ୱେସିହିଁ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ମୀରୁ ସାତେଏ ନାଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜାଦେରି ଅ଼ଡ଼େ ନା଼ନୁ ଏମ୍ବିଟି ୱା଼ହାମାଇଁ ଏ଼ଦାଆଁ ସାତେଏ ପୁଞ୍ଜାମାଞ୍ଜେରି; ନା଼ନୁ ନା଼ ଅଣ୍‌ପୁ ତଲେ ୱା଼ହାହିଲଅଁ, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାତାସି ଏ଼ୱାସି ସାତା, ମୀରୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାମାଇଁ, ଇଚିହିଁ ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣାଟି ୱା଼ହାମାଇଁ, ଅ଼ଡ଼େ ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଏମ୍ବାଟିଏ ଜୀସୁଇଁ ଆସାଲି ତାକି ଅଣ୍‌ପିତେରି; ସାମା ଆମ୍ବାଆରି କେୟୁ ଏ଼ୱାଣି ମୁହେଁ ଏଆତେ, ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ଆହ୍‌ନି କାଟୁ ଏଚେ଼ତା ଏଜାହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ସାମା ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ଏ଼ୱାଣି ତା଼ଣା ନାମାନା ଏଲେଇଚେରି, “ଈୱାସି ଏ଼ନି ଏ଼ନି କାବାଆ଼ନି କାମା ବାରେ କିହିମାନେସି, କ୍ରୀସ୍ତ ୱା଼ହାନା ଈୱାଣି କିହାଁ ଏ଼ନାଆଁ ଆଗାଡ଼ା କିନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଲ଼କୁ ଜୀସୁ କାତା ତାମି ବିତ୍ରା ୱେସ୍‌ପି ଆ଼ହିମାଚାଣି ପାରୁସିୟାଁ ୱେଚେରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଅ଼ଡ଼େ କାଜା ପୂଜେରାଙ୍ଗା ଜୀସୁଇଁ ଦସାଲି ଜାମାନାଙ୍ଗାଣି ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ଏମ୍ବାଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ମୀ ତଲେ ଗା଼ଡ଼େକା ତାକି ଡ଼ୟାହାଁ ନାଙ୍ଗେ ପାଣ୍ତାତାଣା ତା଼ଣା ହାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ମୀରୁ ନାଙ୍ଗେ ପାରାଦେରି, ସାମା ମେଡ଼ାଆୟଅତେରି; ଅ଼ଡ଼େ, ନା଼ନୁ ଏମ୍ବିୟା ମାଇଁ, ମୀରୁ ଏମ୍ବାଆଁ ୱା଼ହାଲି ଆ଼ଡଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଜୀହୁଦିୟାଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ୱେସ୍‌ପି ଆ଼ତେରି, “ଈୱାସି ଆମ୍ବିୟା ହାଜିମାନେସି, ମା଼ର ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ହାଲି ଆ଼ଡାଆୟି ଏ଼ନାଆଁ ଈୱାସି ଇତାଲା ଆତାଲା ଜା଼ଙ୍ଗାହାଜାମାନି ଗ୍ରିକ୍‌ ଲ଼କୁଇଁ ଜା଼ପ୍‌ହାଲି ହାଜିମାନେସି କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“ମୀରୁ ନାଙ୍ଗେ ପାରାଦେରି, ସାମା ବେଟାଆୟଅତେରି, ଅ଼ଡ଼େ ନା଼ନୁ ଏମ୍ବିୟା ମାଇଁ, ମୀରୁ ଏମ୍ବାଆଁ ୱା଼ହାଲି ଆ଼ଡଅତେରି, ଇଞ୍ଜିଁ ଏ଼ୱାସି ୱେସ୍ତାତି ଈ କାତା ଏ଼ନାୟି ଇଞ୍ଜିଁ ୱେସ୍‌ପି ଆ଼ତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ରା଼ନି ଦିନା, ଇଚିସାରେ ପାର୍ବୁତି କାଜା ଦିନା, ଜୀସୁ ନିଚାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, ଆମ୍ବାଆସି ଏ଼ସ୍‌କି ଆ଼ତିହିଁ, ଏ଼ୱାସି ନା଼ ଡାଗେ ୱା଼ହାନା ଗସ୍‌ପେସି । ");
INSERT INTO kxv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ନାମିନେସି, “ଦାର୍ମୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନି ଲେହେଁ, ଏ଼ୱାଣି ହିୟାଁଟି ଜୀୱୁତି ଜାର୍‌ଣା ଏ଼ୟୁ ହ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜୀସୁ ସୁଦୁଜୀୱୁତି କାତା ୱେସିମାଚେସି, ଆମିନି ଗାଟାରି ଜୀସୁ ତା଼ଣା ନାମି ମାଚେରି, ଏ଼ୱାରି ସୁଦୁଜୀୱୁ ବେଟାଆ଼ନାୟି ମାଚେ, ଜୀସୁ ଗାୱୁରମି ବେଟାଆ଼ହା ହିଲାଆତାକି ଏ଼ୱାରାକି ଏଚେ଼ତା ସୁଦୁଜୀୱୁ ହୀପ୍‌କି ଆ଼ହାହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଏଚେ଼ତା, ଲ଼କୁ ଏ଼ କାତା ୱେଚେରି, ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଈୱାସି ସାତେଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ଏଟ୍‌କାତାରି ଏଲେଇଚେରି, “ଏ଼ୱାସି ମସିହା !” ସାମା ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଚେରି, “ମସିହା ! ଏ଼ନାଆଁ ଗାଲିଲିଟି ୱା଼ନେସି କି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, କ୍ରୀସ୍ତ ଦାୱୁଦ ରାଜା କୂଡ଼ାଟି ଇଞ୍ଜାଁ ଦାୱୁଦ ଏମିନି ଟା଼ୟୁତା ବାସା ଆ଼ହାମାଚେସି, ଏ଼ ବେତଲିହିମ ନା଼ୟୁଁଟି ୱା଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଈଦାଆଁତାକି ଲ଼କୁ ତାମି ବିତ୍ରାଟି ଏ଼ୱାଣି ତାକି ବା଼ଗା ଆ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଅ଼ଡ଼େ, ତାମି ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରି ଏ଼ୱାଣାଇଁ ଆସାଲି ଅଣ୍‌ପି ମାଚେରି, ସାମା ଆମ୍ବା ଆମ୍ବାଆରି ତାନି ଲାକ କେୟୁ ଇଟାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଏଚେଟିଏ ଜାମାନାଙ୍ଗା କାଜା ପୂଜେରା ଅ଼ଡ଼େ ପାରୁସିୟାଁ ତା଼ଣା ୱେଣ୍ତା ହାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ୱେଚେରି, “ଏ଼ୱାଣାଇଁ ଏ଼ନାଆଁତାକି ଆସା ତାଆତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ଜାମାନାଙ୍ଗା ଏ଼ୱାରାଇଁ ଏଲେଇଚେରି, “ଈ ମାଣ୍‌ସି ଏ଼ନିକିଁ ହା଼ଡା ୱେହ୍‌ନାସି, ଏଲେକିହିଁ ଏମିନି ମାଣ୍‌ସି ଏଚେଲା ୱେସାହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ପାରୁସିୟାଁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେରି, “ଏ଼ନାଆଁ ମୀରୁ ଜିକେଏ ନା଼ଡ଼ିକିୱି ଆ଼ତେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ପାରୁସିୟାଁ ବିତ୍ରାଟି କି ସା଼ଲୱି କିନାରି ବିତ୍ରାଟି ଆମ୍ବାଆରି ଏ଼ୱାଣି ତା଼ଣା ନାମାମାନେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ସାମା ଈ ଏମିନି ଲ଼କୁ ମ଼ସାତି ମେ଼ରା ପୁଞ୍ଜାହିଲଅରି, ଏ଼ଦାଆଁତାକି ଈୱାରି ବା଼କା ଗାଟି ଲ଼କୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ଏମିନି ନିକଦିମ ଈଦାଆଁ ନ଼କେଏ ଜୀସୁଇଁ ମେସାଲି ତାକି ୱା଼ହାମାଚେସି ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରି ବିତ୍ରାଟି ପାରୁସି ମାଚେସି, ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ରଅଣି ତା଼ଣାଟି ନ଼କେଏ ୱେନାଆନା ଇଞ୍ଜାଁ ତାନି ମାଣ୍‌କି ପୁନାଆନା ମା଼ ମ଼ସାତି ମେ଼ରା ଏ଼ନାଆଁ ଏ଼ୱାଣାଇଁ ଦ଼ହ କିନେ ?” ");
INSERT INTO kxv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀନୁ ଜିକେଏ ଏ଼ନାଆଁ ଗାଲିଲି ଲ଼କୁ କି ? ଗାଲିଲିଟି ଏ଼ନି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଏଚେଲା ୱା଼ହାଲି ଆ଼ଡଅରି, ଈଦାଆଁ ସା଼ସ୍ତେରିତା ସିନିକିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ଅ଼ଡ଼େ ଏ଼ୱାରି ବାରେଜା଼ଣା ଜାହାରା ଇଜ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ସାମା ଜୀସୁ ଜୀତ ହ଼ରୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ଅ଼ର ଦିନା ଲା଼ଇ ଏ଼ୱାସି ମାହାପୂରୁ ଇଲୁତା ୱେଣ୍ଡା ୱା଼ତେସି, ଅ଼ଡ଼େ, ବାରେ ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାଲିଏ, ଏ଼ୱାସି କୁଗାନା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ମେ଼ରା ଜା଼ପ୍‌ନାରି ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଦା଼ରି କାମାତା ଆସ୍‌ପି ଆ଼ହାମାନି ର଼ ଇୟାନି ତାତେରି, ବାରେଜା଼ଣା ନ଼କିତା ନିପ୍‌ହାନା ଜୀସୁଇଁ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଗୂରୁ, ଈ ଇୟା ଦା଼ରିକାମା କିହିମାଚାଟି ଆସ୍‌ପି ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଇଲେତି ଇୟାସିକାଣି ୱାଲ୍‌କା କୁତାନା ୱେ଼ଚାଲିତାକି ମ଼ସା ମା଼ ମେ଼ରାତା ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି; ଆତିହିଁ ନୀନୁ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ଏ଼ୱାରି ଜୀସୁଇଁ ଏ଼ନିକିଁ ପା଼ନ୍ଦାତା ମେତ୍‌ହାଲି ଆ଼ଡିନେରି, ଈଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ତାୟିପାରି କିହାଲି ୱେଚେରି, ସାମା ଜୀସୁ ମୁନୁକାପାନା ୱାଞ୍ଜୁ ତଲେ ବୂମିତା ରା଼ଚାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ଏ଼ୱାରି ଏମ୍ବାଆଁ ନିଚାନା ୱେଣ୍ତେ ୱେଞ୍ଜାଲିଏ, ଜୀସୁ ତା଼ର୍ୟୁଁ ପେର୍‌ହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ଏଚେଲା ଏ଼ନି ପା଼ପୁ କିହାହିଲଅସି, ଏ଼ୱାସି ମୂଲୁ ୱାଲି କୁତାପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜୀସୁ ମୁନୁକାପାନା ବୂମିତା ରା଼ଚାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଜୀସୁତି ହା଼ଡା ୱେଞ୍ଜାନା ଏ଼ୱାରି କାଜାରିଟିଏ ମାଟ୍‌ହାଁ ରଅଣି ଜେ଼ଚ ରଅସି ହାଜାଲି ମା଼ଟ୍‌ହେରି, ଏମ୍ବାଆଁ ୱାର୍‌ଇ ଜୀସୁ ଅ଼ଡ଼େ ମାଦି ମାନି ଏ଼ ଇୟା ଡ଼ୟିତେ । ");
INSERT INTO kxv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଜୀସୁ ତା଼ର୍ୟୁଁ ପେର୍‌ହାନା ଏ଼ଦାନି ଏଲେଇଚେସି, “ଏ଼ ଇୟା ଏ଼ୱାରି ଏମ୍ବିୟା ? ଆମ୍ବାଆରି ନିଙ୍ଗେ ଡଣ୍ତ ହୀହାଲି ହିଲଅରି କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ଏ଼ଦି ଏଲେଇଚେ, “ଆ଼ଏ, ପ୍ରବୁ, ଆମ୍ବାଆରି ହିଲଅରି ।” ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି; “ନା଼ନୁ ଜିକେଏ ନିଙ୍ଗେ ଡଣ୍ତ ହିୟଅଁ; ହାଲାମୁ, ସାମା ଅ଼ଡ଼େ ପା଼ପୁ କିଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜୀସୁ ୱେଣ୍ଡେ ପାରୁସିୟାଁଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଦାର୍‌ତିତି ଉଜେଡ଼ି, ଆମ୍ବାଆସି ନା଼ ଜେ଼ଚ ୱା଼ନେସି, ଏ଼ୱାସି ଜୀୱୁତି ଉଜେଡ଼ି ବେଟା ଆ଼ନେସି ଅ଼ଡ଼େ ଏଚେଲା ଜିକେଏ ଆନ୍ଦେରିତା ତା଼କଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ପାରୁସିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀଏଁ ନୀନୁ ନିଙ୍ଗେତାକି ସା଼କି ହୀହିମାଞ୍ଜି, ନୀନୁ ଏ଼ନାଆଁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ଏ଼ଦି ସାତା ପାର୍‌ମାଣା ହିଲାଆଗାଟାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆ଼ଏ ନା଼ନୁ ନା଼ ତାକି ସା଼କି ହୀତି ଜିକେଏ, ନା଼ନୁ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜାଇଁ ଏ଼ଦି ସାତା, ଇଚିହିଁ ନା଼ନୁ ଆମ୍ବିଟି ୱା଼ହାମାଇଁ ଅ଼ଡ଼େ ଏମ୍ବିୟା ହାଜିମାଇଁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାମାଇଁ, ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି ଏମ୍ବାଟି ୱା଼ଇଁ ଅ଼ଡ଼େ ଏମ୍ବିୟା ହାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ମୀରୁ ୱାର୍‌ଇ ମାଣ୍‌ସିୟାଁ ଲେହେଁ ବିଚାରା କିହିମାଞ୍ଜେରି, ନା଼ନୁ ଆମ୍ବାଆରି ବିଚାରା କିଅଁ । ");
INSERT INTO kxv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ସାମା ନା଼ନୁ ବିଚାରା କିଇଁ, ଆ଼ତିଜିକେଏ ନା଼ ବିଚାରା ସାତା; ଇଚିହିଁ ନା଼ନୁ ରଅତେଏଁ ଆ଼ଏ ସାମା ଏମିନି ଆ଼ବା ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାସି ନା଼ ତଲେ ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ମୀ ମ଼ସାତି ମେ଼ରାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ରିଆରି ସା଼କି ହା଼ଡା ର଼ଲେଏ ଆ଼ତିସାରେ, ଏ଼ୱାରି ଏ଼ନାଆଁ ଇନେରି ଏ଼ଦି ସାତା । ");
INSERT INTO kxv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ନା଼ନୁ ନାଙ୍ଗେତାକି ସା଼କି ହୀହିମାଇଁ, ଅ଼ଡ଼େ, ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନି ଆ଼ବା ଜିକେଏ ନା଼ ୱାକିଟି ସା଼କି ହୀହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଏ଼ୱାଣାଇଁ ଏ଼ୱାରି ୱେଚେରି, “ନୀ ଆ଼ବା ଏମ୍ବିୟା ?” ଜୀସୁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ କି ନା଼ ଆ଼ବାଇଁ ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି; ନାଙ୍ଗେ ପୁଞ୍ଜାତିହିଁମା, ନା଼ ଆ଼ବାଇଁ ଜିକେଏ ପୁଚେରିମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ମାହାପୂରୁ ଇଲୁତି ଦା଼ନା ଇଟିନି ବାକ୍ରାତା ଜୀସୁ ଏ଼ ବାରେ କାତା ଜା଼ପ୍‌ହିମାଚେସି, ସାମା ଆମ୍ବାଆରି ଜିକେଏ ଏ଼ୱାଣାଇଁ ଆହ୍‌ଆତେରି ଏ଼ନାଆଁତାକି ଇଚିହିଁ ତାନି ବେ଼ଲା ୱା଼ହା ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ହାଜିମାଇଁ, ମୀରୁ ନାଙ୍ଗେ ପାରାଦେରି, ଅ଼ଡ଼େ ମୀରୁ ମୀ ପା଼ପୁତା ହା଼ଦେରି । ନା଼ନୁ ଏମ୍ବିୟା ହାଜିମାଇଁ, ଏମ୍ବାଆଁ ମୀରୁ ହାଜାଲି ଆ଼ଡଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଇଞ୍ଜାଁ ଜୀହୁଦିୟାଁ ଏଲେଇଚେରି, “ଈୱାସି ଏ଼ନାଆଁ ହା଼ହାଲି ଏଲେଇଞ୍ଜି ମାନେସି, ନା଼ନୁ ଏମ୍ବିୟା ହାଇଁ ମୀରୁ ଏମ୍ବାଆଁ ହାଜାଲି ଆ଼ଡଅତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଈ ଡ଼଼ଇପୂରୁଟି ଜାର୍ନା ଆ଼ହାମାଞ୍ଜେରି, ସାମା ନା଼ନୁ ଲାକଟି ୱା଼ହାମାଇଁ । ମୀରୁ ଈ ଦାର୍‌ତିଟି, ନା଼ନୁ ଈ ଦାର୍‌ତିଟି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ମୀ ପା଼ପୁ ତଲେ ହା଼ଦେରି । ନା଼ନୁ ଏ଼ୱାତେଏଁ ଇଞ୍ଜିଁ ୱେସ୍ତାସାରେ ମୀରୁ ନାମାଆସାରେ, ମୀ ପା଼ପୁତା ହା଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ନୀନୁ ଆମ୍ବାଆତି ?” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଈ ହା଼ଡା ନା଼ନୁ ମୂଲୁଟିଏ ୱେସାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ମିଙ୍ଗେତାକି କାତା ଜ଼ଲାଲି ଅ଼ଡ଼େ ବିଚାରା କିହାଲି ନା଼ ତା଼ଣା ହା଼ରେକା କାତା ମାନେ; ସାମା ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାସି, ଏ଼ୱାସି ସାତା, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ନାଆଁ ୱେଞ୍ଜାମାଇଁ; ଏ଼ ବାରେ ଦାର୍‌ତିତି ୱେସିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଏ଼ୱାସି ମାହାପୂରୁ ଆ଼ବା କାତା ୱେସିମାଚେସି, ଏ଼ୱାରି ତେଲ୍‌ହାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ଏ଼ଦାଆଁତାକି ଜୀସୁ ଏଲେଇଚେସି; “ଏଚେ଼ତା ମୀରୁ ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ ଗାୱୁରମି ହୀଦେରି, ଏଚେ଼ତା ନା଼ନୁ ଏ଼ ମାଣ୍‌ସିତେଏଁ ଅ଼ଡ଼େ ନା଼ନୁ ଜାହାରାୱାଣି ଏ଼ନାଆଁ କିଆନା, ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନିକିଁ ଜା଼ପ୍‌ହା ମାଞ୍ଜାନେସି, ଏଲେକିଁ ଈ ବାରେ କାତା ୱେସିମାଞ୍ଜାଇଁ ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜାଲି ଆ଼ଡିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଆମ୍ବାଆସି ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାସି ଏ଼ୱାସି ନା଼ ତଲେ ମାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ରଅତେଏଁ କିହିଁ ପିସାମାଞ୍ଜଅସି, ଇଚିହିଁ ନା଼ନୁ ତାନି ରା଼ହାଁ ଆ଼ନି କାମା କିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜୀସୁ ଈ ବାରେ ହା଼ଡା ୱେଞ୍ଜାନା ହା଼ରେକା ଜା଼ଣା ତାନି ତା଼ଣା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଏମ୍ବାଟିଏ ଜୀସୁ ତାନି ତା଼ଣା ନାମିତି ଜୀହୁଦିଙ୍ଗାଣି ଏଲେଇଚେସି, “ନା଼ ବ଼ଲୁତା ତୀରିଆ଼ହାଁ ଡ଼ୟିଦେରି, ଆତିହିଁ ମୀରୁ ସାତେଏ ନା଼ ସୀସୁୟାଁତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ମୀରୁ ସାତାତି ପୁଞ୍ଜେରି ଅ଼ଡ଼େ ଏ଼ ସାତା ମିଙ୍ଗେ ଗେଲ୍‌ପାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଅବ୍ରାହାମତି କୂଡ଼ାତମି, ଅ଼ଡ଼େ ଏଚେଲା ଆମ୍ବାଆରି ହ଼ଲିୟା ଆ଼ହାହିଲଅମି, ଆତିହିଁ ମୀରୁ ମୁକ୍‌ଲୱି ଆ଼ଦେରି ଇଞ୍ଜିଁ ଏ଼ନିକିଁ ୱେସିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମିନିଗାଟାସି ପା଼ପୁ କିନେସି, ଏ଼ୱାସି ପା଼ପୁତି ହ଼ଲେଏସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ହ଼ଲେଏସି କା଼ଲେଏ ତାକି ଇଲୁ କୁଟମିତା ଡ଼ୟଅସି, ମୀର୍‌ଏସି ଇଲୁ କୁଟମିତା କା଼ଲେଏ ତାକି ଡ଼ୟିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ମୀର୍‌ଏସି ମିଙ୍ଗେ ମୁକ୍‌ଲୱି କିୟାନେସି, ମୀରୁ ସାତେଏ ମୁକ୍‌ଲୱି ଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ମୀରୁ ଅବ୍ରାହାମତି କୂଡ଼ାତାତେରି ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ; ସାମା ନା଼ ବ଼ଲୁ ମୀ ହିୟାଁତି ଟା଼ୟୁତା ହିଲାଆକି ମୀରୁ ନାଙ୍ଗେ ପା଼ୟାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ନା଼ ଆ଼ବା ତା଼ଣା ନା଼ନୁ ଏ଼ନାଆଁ ମେସାମାଇଁ, ଏ଼ ବାରେ ନା଼ନୁ ୱେସିମାଞ୍ଜାଇଁ । ଏ଼ଦାଆଁତାକି ମୀରୁ ଜିକେଏ ମୀ ଆ଼ବା ତା଼ଣାଟି ଏ଼ନାଆଁ ୱେଞ୍ଜାମାଞ୍ଜେରି ଏ଼ ବାରେ କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଅବ୍ରାହାମ ମା଼ ଆ଼ବା ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଅବ୍ରାହାମତି ମୀର୍‌କା ମା଼ସ୍‌କାତେରି, ଆତିହିଁ ଅବ୍ରାହାମ କିହାମାଚି କାମା କିଦୁ; ");
INSERT INTO kxv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ମାହାପୂରୁ ତା଼ଣାଟି ୱେଞ୍ଜାମାନି ସାତାତି ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନା଼ନୁ ଇଲେତି ଲ଼କୁ, ମୀରୁ ନାଙ୍ଗେ ପା଼ୟାଲି ତାକି ଅଣ୍‌ପିମାଞ୍ଜାଦେରି; ଅବ୍ରାହାମ ଇଲେତି କାମା କିଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ମୀରୁ ମୀ ଆ଼ବାତି ବାରେ କାମା କିହିମାଞ୍ଜେରି ।” ଏ଼ୱାରି ଜୀସୁଇଁ ଏଲେଇଚେରି; “ମା଼ମ୍ବୁ ଦା଼ରିକାମାଟି ଜାର୍ନା ଆ଼ହାହିଲଅମି; ମା଼ ରଣ୍ତିଏ ଆ଼ବା, ଏ଼ୱାସି ମାହାପୂରୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ସାତେଏ ମୀ ଆ଼ବା ଆ଼ତିହିଁମା, ମୀରୁ ନାଙ୍ଗେ ଜୀୱୁ ନୟାତେରିମା, ଇଚିହିଁ ନା଼ନୁ ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାଇଁ; ନା଼ନୁ ନା଼ ତା଼ଣାଟି ୱା଼ହାହିଲଅଁ, ସାମା ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ନା଼ନୁ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଏ଼ନାଆଁତାକି ନା଼ ହା଼ଡାତି ତେଲ୍‌ହାଲି ଆ଼ଡିହିଲଅତେରି ? ଈଦାନି କାତା ଆ଼ହିମାନେ ମୀରୁ ନା଼ ବ଼ଲୁତି ୱେଞ୍ଜାଲି ଆ଼ଡିହିଲଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ମୀରୁ ମୀ ଆ଼ବା ସୟତାନତି ମୀର୍‌କା ମା଼ସ୍‌କାତେରି, ଅ଼ଡ଼େ ମୀରୁ ମୀ ଆ଼ବାତି କାମା କିହାଲି ମୀ ଅଣ୍‌ପୁ । ଏ଼ୱାସି ମୂଲୁଟିଏ ଲ଼କୁଣି ପା଼ୟିନାସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ସାତାତା ଡ଼ୟଅସି, ଇଚିହିଁ ଏ଼ୱାଣି ତା଼ଣା ସାତା ହିଲେଏ । ଏଚିବେ଼ଲା ଏ଼ୱାସି ମିଚି ଜ଼ଲିନେସି, ଏଚେ଼ତା ତାନିତା଼ଣାଟି ଜ଼ଲିନେସି; ଇଚିହିଁ ଏ଼ୱାସି ମିଚି ଗାଟାସି ଇଞ୍ଜାଁ ମିଚିତି ତାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ସାମା ନା଼ନୁ ସାତା ଜ଼ଲିମାନାକି, ମୀରୁ ନାଙ୍ଗେ ନାମିମାଞ୍ଜଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ନା଼ନୁ ପା଼ପୁ ଗାଟାତେଏଁ ଇଞ୍ଜିଁ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆତେରି ପାର୍‌ମାଣା କିହାଲି ଆ଼ଡିଦେରି ? ନା଼ନୁ ସାତା ୱେସ୍ତାସାରେ, ନାଙ୍ଗେ ମୀରୁ ଏ଼ନାଆଁତାକି ନାମିମାଞ୍ଜଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଆମ୍ବାଆସି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନେସି, ଏ଼ୱାସି ମାହାପୂରୁତି ବ଼ଲୁ ୱେନେସି; ମୀରୁ ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାହିଲଅତେରି, ଏ଼ଦାଆଁତାକି ଈ ବ଼ଲୁ ୱେଞ୍ଜିହିଲଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜୀହୁଦିୟାଁ ଜୀସୁଇଁ ଏଲେଇଚେରି, “ନୀନୁ ସମିରଣତି ଇଞ୍ଜାଁ ନିଙ୍ଗେ ବୂତୁ ଆଲ୍‌ଗାମାଞ୍ଜାନେ, ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ସାତା ୱେସି ହିଲଅମି କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି; “ନାଙ୍ଗେ ବୂତୁ ଆଲ୍‌ଗା ମାଞ୍ଜେଏ, ନା଼ନୁ ନା଼ ଆ଼ବାଇଁ ମା଼ନି କିହିମାଇଁ, ସାମା ମୀରୁ ନାଙ୍ଗେ ଲାଜା କିହିମାଞ୍ଜାଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ନା଼ନୁ ନା଼ ଗାୱୁରମି କିହାଲି ଅଣ୍‌ପି ହିଲଅଁ; ରଅସି ଅଣ୍‌ପିମାନେସି ଏ଼ୱାସି ନା଼ ୱାକିଟି ବିଚାରା କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ନା଼ନୁ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ନା଼ ବ଼ଲୁତି ମା଼ନୱି ଆ଼ନେସି, ଏ଼ୱାସି ଏଚେଲା ହା଼ଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଜୀହୁଦିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀଏଁ ମା଼ମ୍ବୁ ପୁଚମି, ନିଙ୍ଗେ ବୂତୁ ଆଲ୍‌ଗାମାଞ୍ଜାନେ, ଅବ୍ରାହାମ ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ବାରେଜା଼ଣା ହା଼ତେରି, ଅ଼ଡ଼େ ନୀନୁ ୱେସିମାଞ୍ଜି, ଆମ୍ବାଆସି ନା଼ ବ଼ଲୁ ମା଼ନୱି ଆ଼ନେସି, ଏ଼ୱାସି ଏଚେଲା ଜିକେଏ ହା଼ଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ମା଼ ଆକୁ ଅବ୍ରାହାମ ହା଼ତେସି, ନୀନୁ ଏ଼ନାଆଁ ଅବ୍ରାହାମ କିହାଁ କାଜାତି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜି ? ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଜିକେଏ ହା଼ତେରି; ନୀନୁ ଆମ୍ବାଆତି ଇଞ୍ଜିଁ ୱେସିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ନା଼ ଗାୱୁରମି କିହିମାଇଁ, ଆତିହିଁ ନା଼ ଗାୱୁରମି ଏ଼ନାୟି ଆ଼ଏ; ଆମ୍ବାଆସି ନାଙ୍ଗେ ଗାୱୁରମି କିୟାନେସି ଏ଼ୱାସି ନା଼ ଆ଼ବା ଆମ୍ବାଆରାଇଁ ମୀରୁ ମୀ ମାହାପୂରୁ ଇଞ୍ଜିଁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ମୀରୁ ଏ଼ୱାଣାଇଁ ଏଚେଲା ପୁଞ୍ଜାହିଲଅତେରି, ସାମା ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାମାଇଁ । ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ନା଼ନୁ ୱେସ୍ତିହିଁ, ମୀ ଲେହେଁ ନା଼ନୁ ଜିକେଏ ମିଚି ଗାଟାତେଏଁ ଆ଼ଇଁ, ସାମା ନା଼ନୁ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାମାଇଁ ଅ଼ଡ଼େ ତାନି ବ଼ଲୁତି ମା଼ନୱି ଆ଼ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ମୀ ଆ଼ବା ଅବ୍ରାହାମ ନା଼ ଦିନା ମେସାଲି ତାକି ଆ଼ସା କିହାନା ରା଼ହାଁ କିତେସି, ଅ଼ଡ଼େ ଏ଼ଦାଆଁ ମେସାନା ଏ଼ୱାସି ରା଼ହାଁ ଆ଼ତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ଜୀହୁଦିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନିଙ୍ଗେ ରୀ କ଼ଡ଼ି ଦସ ବାର୍ସା ଆ଼ହାମାଞ୍ଜେଏ, ନୀନୁ ଏ଼ନାଆଁ ଅବ୍ରାହାମଇଁ ମେସାମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଅବ୍ରାହାମତି ଜାର୍ନା ନ଼କେଏ ନା଼ନୁ ମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେ଼ଚାଲିତାକି ୱାଲ୍‌କା ପେର୍‌ହା କଡିତେରି, ସାମା ଜୀସୁ ମାହାପୂରୁ ଇଲୁଟି ମେହ୍‌ଆରେ଼ଟୁ ହ଼ଚାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଜୀସୁ ହାଜିମାଚାଟି ର଼ ଜାର୍ନାଟିଏ କା଼ଣାଇଁ ବେଟାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ତାନି ସୀସୁୟାଁ ୱେଚେରି, “ଗୂରୁ, ଆମ୍ବାଆସି ପା଼ପୁ କିହାଲିଏ ଈୱାସି କା଼ଣା ଆ଼ହାନା ଜାର୍ନା ଆ଼ତେସି, ତା଼ନୁ କି ତାମି ଇୟା ଆ଼ବା ପା଼ପୁ କିତାକି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜୀସୁ ଏଲେଇଚେସି, “ଈୱାସି କି ତାମି ଇୟା ଆ଼ବା ପା଼ପୁ କିତାକି ଆ଼ଏ, ସାମା ମାହାପୂରୁତି କାମା ଏ଼ନିକିଁ ଈୱାଣି ତା଼ଣାଟି ତ଼ସ୍‌ପିଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଈଦି ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନା ମାଞ୍ଜା ମାଞ୍ଜାନା, ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନାଣି କାମା କିନାୟିମାନେ; ଏମିନି ବେ଼ଲାତା ଆମ୍ବାଆସି କାମା କିହାଲି ଆ଼ଡଅସି, ଇଲେତି ଲା଼ଆଁ ୱା଼ହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ନା଼ନୁ ଏଚେ଼ପାତେକା ଦାର୍‌ତିତା ମାଇଁ, ଏଚେ଼ପାତେକା ନା଼ନୁ ଦାର୍‌ତିତି ଉଜେଡ଼ିତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଈ କାତା ଏଲେଇଞ୍ଜାନା, ଜୀସୁ ଇର୍‌ଆତା ହୂପାନା ହୂପ୍‌କା ତଲେ କା଼ଦ କିତେସି; ଅ଼ଡ଼େ ତାନି ରୀ କାଣ୍‌କାଣାଁ ରୁବିତେସି ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ହାଲାମୁ “ସିଲହ ବାନ୍ଦାତା ମୂମ୍ବୁ ନର୍‌ହା ୱା଼ମୁ ।” ଏମ୍ବାଟିଏ ଏ଼ୱାସି ହାଜାନା ନର୍‌ହା କଡାନା ୱେଣ୍ତା ୱା଼ହିମାଚାଟି ମେସାଲି ଆ଼ଡିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ତାନି ପା଼ଡ଼ିତାରି, ଅ଼ଡ଼େ ଏମିନିଗାଟାରି ଏ଼ୱାଣାଇଁ ନ଼କେଏ ରୀସ୍‌ପି ମାଚାଣି ମେସାମାଚେରି, ଏ଼ୱାରି ୱେଚେରି, “ଈୱାସି ଏ଼ନାଆଁ କୁଗାନା ରୀସ୍‌ପି ମାଚେସି ଏ଼ୱାସି ଆ଼ଏକି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଈୱାସିଏ ଏ଼ୱାସି;” ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଆ଼ଏ, ଏ଼ୱାଣିଲେହେଁ ତାସି ।” ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁଏ ଏ଼ୱାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଲ଼କୁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ଆତିହିଁ, ନୀନୁ ନୀଏଁ ଏ଼ନିକିଁ ମେସାଲି ଆ଼ଡିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ଏ଼ୱାସି ଏଲେଇଚେସି, “ଆମ୍ବାଆରାଇଁ ଜୀସୁ ଇନେରି, ଏ଼ୱାସି ଇର୍‌ଆତି କା଼ଦ କିହାନା ନା଼ କାଣ୍‌କାଣାଁ ରୁବାତେସି ଅ଼ଡ଼େ ସିଲହତା ହାଜାହାଁ ମୂମ୍ବୁ ନର୍‌ହା କଡାମୁ ଏଲେଇଞ୍ଜାତେସି; ଏଚେଟିଏ ନା଼ନୁ ହାଜାନା ମୂମ୍ବୁ ନର୍‌ହାଲିଏ ମେସାଲି ଆ଼ଡିତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“ଏ଼ୱାସି ଆମ୍ବିୟା ?” ଇଞ୍ଜିଁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁ, ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଆମ୍ବାଆସି ନ଼କେଏ କା଼ଣା ମାଚେସି, ଏ଼ୱାଣାଇଁ ପାରୁସିୟାଁ ତା଼ଣା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜୀସୁ ଏମିନି ଦିନା କା଼ଦ କିହାନା ତାନି କାଣ୍‌କା ନେହିଁ କିହାମାଚେସି, ଏ଼ ଦିନା ଜ଼ମିନି ଦିନା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ପାରୁସିୟାଁ ଏ଼ୱାଣାଇଁ ୱେଚେରି, ଏ଼ନିକିଁ ଏ଼ୱାସି ମେସାଲି ଆ଼ଡିତେସି ? ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ କାଣ୍‌କାଣାଁ ଏ଼ୱାସି ଇଚାଣି କା଼ଦ ରୁବାତେସି, ନା଼ନୁ ହାଜାନା ମୂମ୍ବୁ ନର୍‌ହାନା ୱା଼ତେଏଁ ଅ଼ଡ଼େ ମେସାଲି ଆ଼ଡିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ପାରୁସିୟାଁ ତାମି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାହିଲଅସି, ଇଚିହିଁ ଏ଼ୱାସି ଜ଼ମିନି ଦିନାତି ମା଼ନୱି ଆ଼ହିହିଲଅସି ।” ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ପା଼ପୁ ଲ଼କୁ ଆ଼ହାନା ଇଲେତି କାବାଆ଼ନି କାମା ଏ଼ନିକିଁ କିହାଲି ଆ଼ଡିନେସି ?” ଇଲେଆ଼ହିଁ ଏ଼ୱାରି ତାମି ବିତ୍ରା ବା଼ଗା ଆ଼ତେ ? ");
INSERT INTO kxv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ପାରୁସିୟାଁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ କା଼ଣାଇଁ ୱେଚେରି, “ଏ଼ୱାସି ନୀ କାଣ୍‌କା ନେହିଁ କିୟାତେସି, ଏ଼ୱାଣି କାତା ନୀନୁ ଏ଼ନାଆଁ ଇଞ୍ଜିମାଞ୍ଜି ?” ଏ଼ୱାସି ଏଲେଇଚେସି “ଏ଼ୱାସି ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ଏ଼ୱାସି ଜାର୍ନାଟିଏ କା଼ଣା ମାଚେସି ଅ଼ଡ଼େ ନୀଏଁ, ଈ ହା଼ଡା ତାମି ଇୟା ଆ଼ବାତି ୱେନାଆ ପାତେକା, ଜୀହୁଦିୟାଁ ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ଏ଼ୱାରି ତାମି ଇୟା ଆ଼ବାତି ୱେଚେରି, “ମୀ ଆମିନି ମୀର୍‌ଏସି କା଼ଣା ଆ଼ହାନା ଜାର୍ନା ଆ଼ହାମାଚେସି ଇଞ୍ଜିଁ ଏଲେଇଣ୍‌ମ୍ବିତେରି ଈୱାସି ଏ଼ନାଆଁ ଏ଼ ମୀ ମୀର୍‌ଏସି ? ଆତିହିଁ ଏ଼ୱାସି ନୀଏଁ ଏ଼ନିକିଁ ମେସାଲି ଆ଼ଡିମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ଏମ୍ବାଟିଏ ତାମି ଇୟା ଆ଼ବା ଏଲେଇଚୁ, “ହାଅ, ଏ଼ୱାସି ମା଼ ମୀର୍‌ଏସି, ଏ଼ୱାସି କା଼ଣା ଆ଼ହାନା ଜାର୍ନା ଆ଼ହାମାଚେସି ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି; ");
INSERT INTO kxv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ସାମା ଏ଼ୱାସି ନୀଏଁ ଏ଼ନିକିଁ ମେସାଲି ଆ଼ଡିମାନେସି, ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ଏ଼ୱାଣାଇଁ ମେସ୍‌ପି କିହାମାନେସି, ମା଼ମ୍ବୁ ଏ଼ଦାଆଁ ଜିକେଏ ପୁଞ୍ଜାହିଲଅମି; ଏ଼ୱାଣାଇଁ ୱେଞ୍ଜୁ, ଏ଼ୱାସି କାଜାସି ଆ଼ତେସିଏ, ଏ଼ୱାସି ତାନି କାତା ତା଼ନୁଏ ୱେସାଲି ଆ଼ଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ଏ଼ୱାଣି ତାମି ଇୟା ଆ଼ବା ଜୀହୁଦି ଲ଼କୁତି କାଜାରାଇଁ ଆଜିମାଚାକି ଈ ବାରେ କାତା ୱେସ୍ତୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଆମ୍ବାଆସି ଜୀସୁଇଁ କ୍ରୀସ୍ତ ଇଞ୍ଜିଁ ଇନେସି, ଏ଼ୱାଣାଇଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ପେ଼ର୍‌ୱି ଆ଼ନେ ଇଞ୍ଜିଁ ଜୀହୁଦି ଲ଼କୁ ଏ଼ ନ଼କେଏ କାତା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଏ଼ଦାଆଁତାକି ତାମି ଇୟା ଆ଼ବା ଏଲେଇଚୁ, “ଏ଼ୱାସି କାଜାସି ଆ଼ତେସିଏ, ଏ଼ୱାଣାଇଁ ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ପାରୁସିୟାଁ ଏ଼ ଜାର୍ନାଟିଏ କା଼ଣାଇଁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ହା଼ଟାନା ଏଲେଇଚେରି, “ମାହାପୂରୁଇଁ ଗାୱୁରମି କିହାନା ଏଲେଇନାମୁ, ଆମ୍ବାଆସି ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେସି, ଏ଼ୱାସି ର଼ ପା଼ପୁ ଗାଟାସି ଈ କାତା ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ୱାସି ପା଼ପୁ ଗାଟାସି କି ଆ଼ଏ, ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ; ନା଼ନୁ ର଼ କାତା ପୁଞ୍ଜାମାଇଁ; ନା଼ନୁ କା଼ଣା ମାଚେଏଁ, ନୀଏଁ ମେସାଲି ଆ଼ଡିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ୱାସି ନିଙ୍ଗେ ଏ଼ନାଆଁ କିୟାତେସି ? ଏ଼ନିକିଁ ଏ଼ୱାସି ନୀ କାଣ୍‌କା ଦେପି କିୟାତେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ଏ଼ୱାସି ଏଲେଇଚେସି, “ନ଼କେଏ ୱେସା ରା଼ହାମାଞ୍ଜାଇଁ, ଅ଼ଡ଼େ ମୀରୁ ୱେନାଆତେରି; ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏ଼ନାଆଁତାକି ୱେଞ୍ଜାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି ? ମୀରୁ ଜିକେଏ ଏ଼ନାଆଁ ତାନି ସୀସୁ ଆ଼ହାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଲା଼ଗାନା ଏଲେଇଚେରି, “ନୀନୁ ତାନି ସୀସୁତି, ସାମା ମା଼ମ୍ବୁ ମ଼ସାତି ସୀସୁୟାଁତମି । ");
INSERT INTO kxv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି, ମାହାପୂରୁ ମ଼ସାଇଁ କାତା ଆ଼ହାମାଚେସି, ସାମା ଈ ମାଣ୍‌ସି ଆମ୍ବିଟି ୱା଼ହାମାନେସି, ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଈଦି ରଣ୍ତି କାବାଆ଼ନି କାତା ଏ଼ୱାସି ଏମ୍ବିଟି ୱା଼ହାମାନେସି, ମୀରୁ ପୁଞ୍ଜାହିଲଅତେରି, ସାମା ଏ଼ୱାସି ନାଙ୍ଗେ କାଣ୍‌କା ଦେପି କିୟାତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି, ମାହାପୂରୁ ପା଼ପୁଗାଟି ଲ଼କୁତି ହା଼ଡା ୱେନଅସି, ଆମିନି ଗାଟାରି ମାହାପୂରୁଇଁ ମା଼ନି କିନେରି ଅ଼ଡ଼େ ତାନି ଅଣ୍‌ପୁ ତଲେ କାମା କିନେରି, ଏ଼ୱାରି ହା଼ଡାତି ଏ଼ୱାସି ୱେନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ତଲି କା଼ଲାଟିଏ ଆମ୍ବାଆସି ଜାର୍ନା କା଼ଣାଇଁ ମେସ୍‌ପିକିତି କାତା ଏଚେଲା ୱେଣ୍‌ମ୍ବି ଆ଼ହାହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଈୱାସି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହା ହିଲାଆତିଁ, ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡାଆତେସିମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ପା଼ପୁ ତଲେ ନୀନୁ ଜାର୍ନା ଆ଼ହାନା ପା଼ପୁ ତଲେ ପାଡାଆ଼ତି, ନୀନୁ ମାଙ୍ଗେ ଜା଼ପ୍‌ହି ମାଞ୍ଜାଦି ?” ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ପେ଼ର୍‌ହାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପେ଼ର୍‌ହା ମାନେରି, ଇଞ୍ଜାଁ ଜୀସୁ ଈ କାତା ୱେଞ୍ଜାନା, ଏ଼ୱାଣାଇଁ ମେସାନା ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ମାଣ୍‌ସି ମୀର୍‌ଏଣି ତା଼ଣା ନାମିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ, ୱେସ୍ତାମୁ ଏ଼ୱାସି ଆମ୍ବାଆସି, ଆତିହିଁ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ନାମିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ୱାଣାଇଁ ମେସାମାଞ୍ଜି, ନୀ ତଲେ ଆମ୍ବାଆସି ନୀଏଁ କାତା ଆ଼ହିମାନେସି, ଏ଼ୱାସିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁ ନାମିମାଇଁ, ପ୍ରବୁ !” ଇଞ୍ଜାଁ ଜୀସୁ ନ଼କିତା ମେଣ୍ତାକୁତାନା ଜହରା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଜୀସୁ ଏଲେଇଚେସି, “ମେହ୍‌ଆଗାଟି ଲ଼କୁ ଏ଼ନିକିଁ ମେହ୍‌ନେରି ଇଞ୍ଜାଁ ମେହ୍‌ନି ଲ଼କୁ ଏ଼ନିକିଁ କା଼ଣା ଆ଼ନେରି, ଈ ବିଚାରା କିହାଲି ନା଼ନୁ ଦାର୍‌ତିତା ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ଏମ୍ବାଆଁ ମାଚି ଏଚରଜା଼ଣା ପାରୁସିୟାଁ ଈ କାତା ୱେଞ୍ଜାନା, ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଜିକେଏ ଏ଼ନାଆଁ କା଼ଣାୟାଁତମି ?” ");
INSERT INTO kxv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “କା଼ଣାୟାଁ ଆ଼ହାମାଚିହିଁ ମୀରୁ ଦ଼ହ ହିଲାଆଗାଟାତେରି ଆ଼ତେରିମା, ସାମା ମେସାଲି ଆ଼ଡିମାନମି ଇଞ୍ଜିମାନାକି ମୀରୁ ହା଼ରେକା ପା଼ପୁତା ମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ଦା଼ରା ୱାକିଟି ମେ଼ଣ୍ତାୟାଁ ମାନ୍ଦାତା ହ଼ଡ଼୍‌ଅସି, ସାମା ଅ଼ର ୱାକିଟି ଡେ଼ୱାଁନା ହ଼ଡ଼୍‌ନେସି, ଏ଼ୱାସି ସ଼ରୁ ଇଞ୍ଜାଁ ଡଂଗେଏସି; ");
INSERT INTO kxv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ସାମା ଆମ୍ବାଆସି ଦା଼ରା ୱାକିଟି ହ଼ଡ଼୍‌ନେସି, ଏ଼ୱାସି ମେ଼ଣ୍ତା ଗ଼ଡ଼ୁ । ");
INSERT INTO kxv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଦା଼ରାତା କା଼ଃଆନାସି ଏ଼ୱାଣାକି ଦା଼ରା ଦେଚା ହୀନେସି, ଅ଼ଡ଼େ, ଏ଼ୱାସି ତାନି ମେ଼ଣ୍ତାୟାଁ ଦ଼ରୁ ଆସାନା ହା଼ଟିନେସି, ଏ଼ୱି ତାନି ହା଼ଟିନାଣି ୱେନୁ ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ ମାନ୍ଦାତି ପାଙ୍ଗାତା ଜିରୁ ନ଼କି କିହାନା ଅ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ମେ଼ଣ୍ତାୟାଁଣି ପାଙ୍ଗାତା ଅ଼ନାଟି ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁ ନ଼କି ନ଼କିତା ତା଼କିନେସି, ଅ଼ଡ଼େ ମେ଼ଣ୍ତାୟାଁ ତାନି ଜେ଼ଚ ଜେ଼ଚ ତା଼କିନୁ, ଇଚିହିଁ ଏ଼ୱି ଏ଼ୱାଣି ଗିୟାଁ ତେଲ୍‌ହାଉ । ");
INSERT INTO kxv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ସାମା ଏ଼ୱି ପୁନାଆତି ଲ଼କୁ ଜେ଼ଚ ଏଚେଲା ଜିକେଏ ତା଼କାଉ, ସାମା ଏ଼ୱାଣି ଦାରି ଦାରିଟି ହଟାତୁହନୁ, ଇଚିହିଁ ଏ଼ୱି ପୁନାଆତାରି ଗିୟାଁ ତେଲ୍‌ହିନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜୀସୁ ଏ଼ୱାରାଇଁ ଈ ପୁଣ୍‌ମ୍ବିକିନି କାତା ୱେସାନା ଏଲେଇଚେସି, ସାମା ଏ଼ୱାସି ଏ଼ନା ଏ଼ନାଆଁ ୱେସିମାଚେସି, ଏ଼ ବାରେ ଏ଼ନାୟି ଇଞ୍ଜିଁ ଏ଼ୱାରି ପୁନାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଜୀସୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏଲେଇଚେସି, “ସାତା ସାତା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ନା଼ନୁ ମେ଼ଣ୍ତାୟାଁ ଦୁୱେରିତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଏଚରଜା଼ଣା ନା଼ ନ଼କିତା ୱା଼ହାମାନେରି, ଏ଼ୱାରି ବାରେ ସ଼ର୍‌କା ଅ଼ଡ଼େ ଡଂଗାଁୟାଁ, ସାମା ମେ଼ଣ୍ତାୟାଁ ଏ଼ୱାରି କାତା ୱେନାଆତୁ । ");
INSERT INTO kxv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ନା଼ନୁ ଆ଼ହିମାଇଁ ଦା଼ରା । ଆମ୍ୱାଆସି ନା଼ ତା଼ଣାଟି ହ଼ଡ଼୍‌ନେସି, ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି ଇଞ୍ଜାଁ ବିତ୍ରା ୱା଼ହାନା ଅ଼ଡ଼େ ପାଙ୍ଗାତା ହାଜାନା ହା଼ରା ବେଟାଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ସ଼ରୁ ୱାର୍‌ଇ ସ଼ରୁ କିହାଲି, ପା଼ୟାଲି ଅ଼ଡ଼େ ନା଼ସା କିହାଲି ୱା଼ନେସି; ଏ଼ୱାରି ଏ଼ନିକିଁ ଜୀୱୁ ବେଟାଆ଼ନେରି ଅ଼ଡ଼େ ହା଼ରେକା ବେଟାଆ଼ନେରି ଏ଼ଦାଆଁତାକି ନା଼ନୁ ୱା଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ନା଼ନୁ ନେହିଁ ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁତେଏଁ; ନେହିଁ ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁ ମେ଼ଣ୍ତାୟାଁ ତାକି ତାନି ଜୀୱୁ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଆମ୍ବାଆସି ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁ ଆ଼ଏ, ଗତି ଦାଂଗ୍‌ଣେଏସି, ଜାହାରା ମେ଼ଣ୍ତାୟାଁ ହିଲାଉ ଏ଼ୱାସି କ୍ଡାଃନି ୱା଼ନାଣି ମେସାନା ମେ଼ଣ୍ତାୟାଁ ପିସା ହଣ୍‌ନେସି ଅ଼ଡ଼େ କ୍ଡାଃନି ୱା଼ହାନା ଏ଼ ବାରେତି ସିନାସାତ୍ରା କିନେ, ");
INSERT INTO kxv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଇଚିହିଁ ଏ଼ୱାସି ଗତି ଦାଂଗ୍‌ଣେଏସି, ଇଞ୍ଜାଁ ମେ଼ଣ୍ତାୟାଁକି ଅଣ୍‌ପୁ ହିଲେଏ, ");
INSERT INTO kxv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ନା଼ନୁ ନେହିଁ ମେ଼ଣ୍ତାୟାଁ ଗ଼ଡ଼ୁ । ଆ଼ବା ଏ଼ନିକିଁ ନାଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜାନେସି ଅ଼ଡ଼େ ନା଼ନୁ ଆ଼ବାଇଁ ପୁଞ୍ଜାମାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ଏ଼ନିକିଁ ଆ଼ବା ନାଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜାନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ଆ଼ବାଇଁ ପୁଞ୍ଜାମାଇଁ, ଏଲେକିହିଁଏ ନା଼ନୁ ନା଼ ମେ଼ଣ୍ତାୟାଁଇଁ ପୁଇଁ, ଅ଼ଡ଼େ ନା଼ ମେ଼ଣ୍ତାୟାଁ ଜିକେଏ ନାଙ୍ଗେ ପୁଞ୍ଜାନୁ, ଅ଼ଡ଼େ ମେ଼ଣ୍ତାୟାଁ ତାକି ନା଼ନୁ ନା଼ ଜୀୱୁ ହୀଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଏମିନି ମେ଼ଣ୍ତାୟାଁ ଈ ମାନ୍ଦାତାଇ ଆ଼ଏ, ନା଼ ଇଲେତି ମେ଼ଣ୍ତାୟାଁ ମାନୁ, ଏ଼ୱାଆଁ ଜିକେଏ ନାଙ୍ଗେ ତାନାୟି ଆ଼ନେ, ଅ଼ଡ଼େ ଏ଼ୱି ନା଼ ହା଼ଡା ତେଲ୍‌ହିନୁ; ଏମ୍ବାଟିଏ ରଣ୍ତିଏ ମାନ୍ଦା ଅ଼ଡ଼େ ରଣ୍ତିଏ ଗ଼ଡ଼ୁ ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ନା଼ନୁ ନା଼ ଜୀୱୁ ହୀନାକି ଆ଼ବା ନାଙ୍ଗେ ଜୀୱୁ ନୟାଁନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ନା଼ ଜୀୱୁ ୱେଣ୍ତେ ଅ଼ହାକଡାଲି ନା଼ନୁ ଏ଼ଦାଆଁ ହୀଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ନା଼ ଜୀୱୁ ଏଟ୍‌କାତାରି ଆମ୍ବାଆରି ଅ଼ହାଲି ଆ଼ଡଅରି, ଏ଼ଦାଆଁ ନା଼ନୁ ନା଼ ଅଣ୍‌ପୁ ତଲେ ହୀଇଁ, ନା଼ ଜୀୱୁ ହୀହାଲିତାକି ଅ଼ଡ଼େ ଏ଼ଦାଆଁ ୱେଣ୍ତେ ଅ଼ହାକଡାଲି ତାକି ନା଼ ଅଦିକାରା ମାନେ । ଈଦାଆଁ କିହାଲି ଆ଼ବା ମାହାପୂରୁ ନାଙ୍ଗେ ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଜୀସୁତି ଈ ବାରେ କାତାତାକି ଜୀହୁଦି ଲ଼କୁତା଼ଣା ଗଡ଼୍‌ହା ହ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ବୂତୁ ଆଲ୍‌ଗାମାନେ, ଏ଼ୱାସି ବାୟା ଆ଼ହାମାନେସି, ଏ଼ନାଆଁତାକି ଏ଼ୱାଣି କାତା ୱେଞ୍ଜିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ଏଟ୍‌କାତାରି ଏଲେଇଚେରି, “ଈ ବାରେ କାତା ବୂତୁ ଆଲ୍‌ଗାମାନାରି କାତା ଆ଼ଏ; ବୂତୁ ଏ଼ନାଆଁ କା଼ଣାତି କାଣ୍‌କା ମେସ୍‌ପି କିହାଲି ଆ଼ଡିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଏଚିବେ଼ଲା ଜିରୁସାଲମତା ମାହାପୂରୁ ଇଲୁତି ମାହାପୂରୁ ଦ଼ରୁଟି ହେର୍‌ପିନି ପାର୍ବୁ ଆ଼ତେ; ଏ଼ଦି ପେନିବେ଼ଲା ମାଚେ, ");
INSERT INTO kxv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଜୀସୁ ମାହାପୂରୁ ଇଲୁତି ସଲମନ ପିଣ୍ତାତା ରେ଼ଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଏମ୍ବାଟିଏ ଜୀହୁଦି ଲ଼କୁ ସା଼ରିୱାକି ମୁଚାନା ୱେଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି, “ଏଚରଦିନା ପାତେକା ମା଼ ମ଼ନତା ଆନାମାନା କିୟାଦି ? ନୀନୁ କ୍ରୀସ୍ତତି ଇଚିହିଁ ମାଙ୍ଗେ ନେହିଁକିଁ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ୱେସାମାଞ୍ଜାଇଁ, ସାମା ମୀରୁ ନାମିହିଲଅତେରି; ନା଼ ଆ଼ବା ଦ଼ରୁଟି ନା଼ନୁ ଏମିନି ବାରେ କାମା କିହିମାଇଁ, ଏ଼ ବାରେ ନା଼ ୱାକିଟି ସା଼କି ହୀହିମାନେ; ");
INSERT INTO kxv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ଆ଼ତିଜିକେଏ ମୀରୁ ନାମିହିଲଅତେରି, ଇଚିହିଁ ମୀରୁ ନା଼ ମେ଼ଣ୍ତାୟାଁତେରି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ନା଼ ମେ଼ଣ୍ତାୟାଁ ନା଼ ହା଼ଡା ୱେନୁ ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଆଁ ପୁଇଁ, ଅ଼ଡ଼େ ଏ଼ୱି ନା଼ ଜେ଼ଚ ଜେ଼ଚ ତା଼କିନୁ, ");
INSERT INTO kxv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାସିକାକି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ହୀଇଁ, ଅ଼ଡ଼େ ଏ଼ୱି ଏଚେଲା ଜିକେଏ ନା଼ସା ଆ଼ଉ, ଆମ୍ବାଆସି ନା଼ କେୟୁଟି ଏ଼ୱାଆଁ ମୀଞ୍ଜା ଅୟଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ନା଼ ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନାଆଁ ହୀହାମାଞ୍ଜାନେସି, ଏ଼ଦି ବାରେକିହାଁ ଦାରାଗାଟାୟି, ଇଞ୍ଜାଁ ଆ଼ବା ତା଼ଣାଟି ଆମ୍ବାଆସି ମୀଞ୍ଜାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଆ଼ବା ଅ଼ଡ଼େ ନା଼ନୁ ରଅତମିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ୱେ଼ଚାଲି ଅ଼ଡ଼େ ୱେଣ୍ତେ ୱାଲ୍‌କା ତାଚିହିଁ ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆ଼ବା ତା଼ଣାଟି ହା଼ରେକା ନେହିଁ କାମାୟାଁ ମିଙ୍ଗେ ତ଼ସାମାଞ୍ଜାଇଁ; ଏ଼ ବାରେ କାମାୟାଁ ବିତ୍ରାଟି ଏମିନି କାମାତାକି ନାଙ୍ଗେ ୱାଲ୍‌କା ୱେ଼ଚି ମାଞ୍ଜାଦେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଜୀହୁଦିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନେହିଁ କାମାତାକି ନିଙ୍ଗେ ୱାଲ୍‌କା ୱେ଼ଚିମାଞ୍ଜଅମି, ସାମା ମାହାପୂରୁ ନିନ୍ଦା କିହିମାନାକି, ନୀନୁ ମାଣ୍‌ସି ଆ଼ହାନା ମାହାପୂରୁତେଏଁ ଇଞ୍ଜିମାନାକି ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀ ମ଼ସା ମେ଼ରାତା ରା଼ସ୍‌କି ଆ଼ହାହିଲେଏ, ନା଼ନୁ ଏଲେଇଞ୍ଜାତେଏଁ ‘ମୀରୁ ମାହାପୂରୁୟାଁତେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଆମ୍ବାଆରି ତା଼ଣା ମାହାପୂରୁତି ବ଼ଲୁ ତ଼ଞ୍ଜାଆ଼ତେ, ଏ଼ୱାରି ମାହାପୂରୁୟାଁ ଇଚିହିଁ ଦାର୍ମୁ ସା଼ସ୍ତେରି ଉଜେଏ କିହାଲି ଆ଼ଡଅସି, ");
INSERT INTO kxv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ଆ଼ବା ମାହାପୂରୁ ନାଙ୍ଗେ ସୁଦୁ କିହାନା ଦାର୍‌ତିତା ପାଣ୍ତାମାଞ୍ଜାନେସି । ଇଞ୍ଜାଁ ନା଼ନୁ ନାଙ୍ଗେ ମାହାପୂରୁ ମୀର୍‌ଏଣାତେଏଁ ଇଞ୍ଜିମାନାକି ମାହାପୂରୁ ନିନ୍ଦା କିହିମାଞ୍ଜି ଇଞ୍ଜିଁ ଏ଼ନିକିଁ ଏଲେଇଞ୍ଜି ମାଞ୍ଜାଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ନା଼ନୁ ନା଼ ଆ଼ବାତି ବାରେ କାମା କିହା ହିଲାଆତିହିଁ ନାଙ୍ଗେ ନାମାଆଦୁ; ");
INSERT INTO kxv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ସାମା ନା଼ନୁ କିହିମାଇଁ, ଆତିହିଁ ମୀରୁ ନାଙ୍ଗେ ନାମି ମାଞ୍ଜଅତେରି, ଆ଼ତିଜିକେଏ ଆ଼ବା ନା଼ ତା଼ଣା ମାନେସି ଅ଼ଡ଼େ ନା଼ନୁ ଆ଼ବା ତା଼ଣା ମାଇଁ, ଈଦାଆଁ ମୀରୁ ଏ଼ନିକିଁ ପୁଞ୍ଜେରି ଅ଼ଡ଼େ ତେଲ୍‌ହିଦେରି, ଈଦାଆଁତାକି ବାରେ କାମାତି ନାମାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ଆସାଲି ଅଣ୍‌ପିତେରି, ସାମା ଏ଼ୱାସି ଏ଼ୱାରି କେୟୁତା ହେର୍‌ପି ଆ଼ଆନା ଏମ୍ବାଟି ହ଼ଚାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଏମ୍ବାଟି ଏ଼ୱାସି ଅ଼ଡ଼େ ୱେଣ୍ତେ ଜର୍ଦନ ଆତାଲା ହାଜାନା, ତଲି ଜହନ ଏମିନି ଟା଼ୟୁତା ବାପ୍ତିସ୍ମ ହୀହିମାଚେସି, ଏ଼ ଟା଼ୟୁତା ୱା଼ହାନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଜହନ ଏ଼ନି କାବାଆ଼ନି କାମା କିଆତେସି, ସାମା ଈ ମାଣ୍‌ସି କାତା ଜହନ ଏ଼ନା ଏ଼ନାଆଁ ୱେସାମାଚେସି, ଏ଼ ବାରେ ସାତା ।” ");
INSERT INTO kxv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଏମ୍ବାଆଁ ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତନିୟାଁତି ଲାଜର ଦ଼ରୁଗାଟାସି ରଅସି ନ଼ମେରି ଆ଼ହାମାଚେସି; ତାମି ତାଙ୍ଗିସ୍କା ମରିୟମ ଅ଼ଡ଼େ ମାର୍ତା ଏ଼ ନା଼ୟୁଁତା ଡ଼ୟିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଏମିନି ଇୟା ପ୍ରବୁଇଁ ନିୟୁଁ ୱା଼କ୍‌ହାନା ତାନି ତା଼ର୍ୟୁଁ ବା଼ଣାୟାଁ ତଲେ ଏ଼ୱାଣି ପାଃଆନାୟାଁ ଜେ଼ଜା ମାଚେ, ଈଦି ଏ଼ ମରିୟମ; ତାମି ତାୟି ଲାଜର ନ଼ମେରି ଆ଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଏ଼ଦାଆଁତାକି ଏ଼ ତାଙ୍ଗିସ୍କା ଜୀସୁ ତା଼ଣା କାବ୍ରୁ ପାଣ୍ତିତୁ, “ପ୍ରବୁ, ନୀନୁ ଆମ୍ବାଆରାଇଁ ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜି ଏ଼ୱାସି ନ଼ମେରି ଆ଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ସାମା ଜୀସୁ ଈ କାତା ୱେଞ୍ଜାନା ଏଲେଇଚେସି, “ଈ ନ଼ମେରି ହା଼ହାଲି ତାକି ଆ଼ଏ, ସାମା ମାହାପୂରୁତି ଗାୱୁରମି ତାକି, ଏ଼ନିକିଁ ଏମ୍ବାଟି ମାହାପୂରୁତି ମୀର୍‌ଏସି ଗାୱୁରମି ବେଟା ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜୀସୁ ମାର୍ତା, ତାନି ତାଙ୍ଗି ମରିୟମଇଁ ଅ଼ଡ଼େ ଲାଜରଇଁ ଜୀୱୁ ନ଼ହିଁମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ଏଚେ଼ତା ଏ଼ୱାସି ନ଼ମେରି ଆ଼ହାମାନେସି ଇଞ୍ଜିଁ ୱେଚେସି, ଏଚେ଼ତା ଏ଼ୱାସି ଏମିନିତା଼ଣା ମାଚେସି, ଏ଼ ଟା଼ୟୁତା ରୀ ଦିନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ଏଚେଟିଏ ଏ଼ୱାସି ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଜା଼ଦୁ ମା଼ର ୱେଣ୍ତେ ଜୀହୁଦା ରା଼ଜିତା ହାନ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ ଗୂରୁ ଜୀହୁଦିୟାଁ ନୀଏଁ ନିଙ୍ଗେ ୱାଲ୍‌କାତଲେ ୱେ଼ଚାଲି ଅଣ୍‌ପି ମାଞ୍ଜାତେରି, ଅ଼ଡ଼େ ୱେଣ୍ତେ ନୀନୁ ଏମ୍ବାଆଁ ହାଜିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜୀସୁ ଏଲେଇଚେସି, “ଦିନାତାକି ବା଼ର ଗଂଟା ହିଲେଏ ? ଆମ୍ବାଆସି ମାଦେନା ତା଼କିସାରେ ପୁଟିକିଅସି, ଇଚିହିଁ ଏ଼ୱାସି ଦାର୍‌ତିତି ଉଜେଡ଼ି; ");
INSERT INTO kxv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ସାମା ଲା଼ଆଁୟାଁ ତା଼କିସାରେ ଏ଼ୱାସି ପୁଟିକିନେସି, ଇଚିହିଁ ଏ଼ୱାଣି ହିୟାଁତା ଉଜେଡ଼ି ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଈ ବାରେ କାତା ୱେସ୍ତି ଡା଼ୟୁ ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ମା଼ ତ଼ଣେ ଲାଜର ଇଦା କିହାମାନେସି, ସାମା ଏ଼ୱାଣାଇଁ ଇଦାଟି ନିକ୍‌ହାଲି ନା଼ନୁ ହାଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ ଏ଼ୱାସି ଡୂରାନା ଇଦା କିହାମାଚିହିଁ ନେହିଁ ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜୀସୁ ଲାଜର ହା଼ହାମାନାକି ଏ଼ କାତା ଏଲେଇଚେସି, ସାମା ଏ଼ୱାଣି ଇଦା କିହାମାନି କାତା ୱେସ୍ତାତେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ଏଚିବେ଼ଲା ଜୀସୁ ତୀରେତଲେ ଏଲେଇଚେସି, “ଲାଜର ହା଼ହାମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଅ଼ଡ଼େ ନା଼ନୁ ଏମ୍ବାଆଁ ହିଲାଆତେଏଁ, ଏ଼ଦାଆଁତାକି ମୀ ତାକି ରା଼ହାଁ କିହିମାଇଁ, ଏ଼ନିକିଁ ମୀରୁ ନାମିଦେରି; ସାମା ଜା଼ଦୁ ମା଼ର ଏ଼ୱାଣି ତା଼ଣା ହାନ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ଏମ୍ବାଟିଏ ତ଼ମା, ଆମ୍ବାଆରାଇଁ ଦିଦୁମ ଇଞ୍ଜିଁ ଇନେରି, ଏ଼ୱାସି ତାମି ତ଼ଣେ ସୀସୁୟାଁଇଁ ଏଲେଇଚେସି, “ଜା଼ଦୁ, ମା଼ର ଜିକେଏ ହାଜାନା ଏ଼ୱାଣିତଲେ ହା଼ନ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜୀସୁ ବେତନିୟାଁତା ଏଜାନା ୱେଚେସି, ଏ଼ୱାସି ସା଼ରି ଦିନା ଆ଼ତେସି ମାହ୍‌ଣି ମାଣ୍ତାତା ଇଟାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତନିୟାଁ ଜିରୁସାଲମଟି ରୀ କିଲମିଟର ହେକ ମାଚେ, ");
INSERT INTO kxv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଅ଼ଡ଼େ ଜୀହୁଦିୟାଁ ବିତ୍ରାଟି ହା଼ରେକା ମାର୍ତା ଇଞ୍ଜାଁ ମରିୟମଇଁ ତାମି ତାୟିତି ଦୁକୁ ଡୂକ୍‌ହାଲି ଏମ୍ବାଆଁ ୱା଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଜୀସୁ ୱା଼ହିମାନେସି ଇଞ୍ଜିଁ ଏଚେ଼ତା ମାର୍ତା ୱେଚେ, ଏଚେ଼ତା ମାର୍ତା ଏ଼ୱାଣାଇଁ ବେଟାଆୟାଲି ହାଚେ, ସାମା ମରିୟମ ଇଜ କୁଗାନା ଡ଼ୟିତେ । ");
INSERT INTO kxv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତା ଜୀସୁଇଁ ଏଲେଇଚେ, “ପ୍ରବୁ ନୀନୁ ଇମ୍ବାଆଁ ମାଚିହିଁମା, ନା଼ ତାୟି ହା଼ଆତେସିମା, ");
INSERT INTO kxv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ସାମା ନୀନୁ ମାହାପୂରୁଇଁ ଏ଼ନାଆଁ ରୀହ୍‌ଦି, ମାହାପୂରୁ ନିଙ୍ଗେ ଏ଼ଦାଆଁ ହିୟାନେସି, ଏ଼ଦାଆଁ ନୀଏଁ ଜିକେଏ ପୁଞ୍ଜାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ନୀ ତାୟି ଅ଼ଡ଼େ ୱେଣ୍ତେ ନିଙ୍ଗିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“ମାର୍ତା ଜୀସୁଇଁ ଏଲେଇଚେ, ଏ଼ୱାସି ଡା଼ୟୁ ୱେଣ୍ତେ ନିଙ୍ଗିନି ଦିନାତା ନିଙ୍ଗିନେସି, ଈଦାଆଁ ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ନା଼ନୁ ୱେଣ୍ତେ ନିଙ୍ଗିନାତେଏଁ ଅ଼ଡ଼େ ଜୀୱୁତେଏଁ; ଆମ୍ବାଆସି ନାଙ୍ଗେ ନାମାନେସି, ଏ଼ୱାସି ହା଼ତି ଜିକେଏ ନୀଡିନେସି, ");
INSERT INTO kxv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆମ୍ବାଆସି ନୀଡିନେସି ଅ଼ଡ଼େ ନାମିନେସି, ଏ଼ୱାସି ଏଚେଲା ଜିକେଏ ହା଼ଅସି; ଈ କାତା ନାମିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍ତା ଏଲେଇଚେ, “ଏ଼ ପ୍ରବୁ ଆମ୍ବାଆସି ଦାର୍‌ତିତା ୱା଼ନାୟି ମାଚେ, ନୀନୁ ଏ଼ କ୍ରୀସ୍ତ ମାହାପୂରୁ ମୀର୍‌ଏଣାତି, ଈ କାତା ନାମିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଈ କାତା ୱେସାନା ମାର୍ତା ହାଜାନା ତାମି ତାଙ୍ଗି ମରିୟମଇଁ ଏଟ୍‌କା ହା଼ଟାନା ଏଲେଇଚେ, “ଗୂରୁ ୱା଼ତେସିଏ ନିଙ୍ଗେ ପାରିମାଞ୍ଜାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ମରିୟମ ଈ କାତା ୱେଞ୍ଜାନା ଦାପେ ନିଙ୍ଗାନା ଏ଼ୱାଣି ତା଼ଣା ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଏଚିବେ଼ଲା ଜୀସୁ ନା଼ୟୁଁ ବିତ୍ରା ୱା଼ହାହିଲାଆତେସି, ସାମା ମାର୍ତା ଏ଼ୱାଣାଇଁ ଏମିନି ଟା଼ୟୁତା ବେଟାଆ଼ହାମାଚେ, ଏଚେ଼ପାତେକା ଏ଼ ଟା଼ୟୁତେଏ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ଏମିନି ଜୀହୁଦିୟାଁ ଏ଼ଦାନିତଲେ ଏ଼ ଇଲୁତା ଦୁକୁ ଡୂକ୍‌ହିମାଚେରି, ଏ଼ୱାରି ମରିୟମ ଦାପେ ନିଙ୍ଗାନା ପାଙ୍ଗାତା ହାଚାଣି ମେସାନା, ଏ଼ଦି ମାହ୍‌ଣି ମାଣ୍ତାତା ଡ଼ୀହାଲି ହାଜିମାନେ, ଈ କାତା ଅଣ୍‌ପାନା ଏ଼ଦାନି ଜେ଼ଚ ଜେ଼ଚ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଏମ୍ବାଟିଏ ଜୀସୁ ଏମିନି ଟା଼ୟୁତା ମାଚେସି, ମରିୟମ ଏ଼ ଟା଼ୟୁତା ହାଜାନା ଏ଼ୱାଣାଇଁ ମେସାନା ଏ଼ୱାଣି କଡାୟାଁ ଡ଼଼ଇ ରିହାନା ଏଲେଇଚେ, “ପ୍ରବୁ ନୀନୁ ଇମ୍ବାଆଁ ମାଚିହିଁମା ନା଼ ତାୟି ହା଼ଆତେସିମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ଜୀସୁ ମରିୟମ ଅ଼ଡ଼େ ତାନିତଲେ ୱା଼ହାମାନି ଜୀହୁଦି ଲ଼କୁ ଡ଼ୀହିମାନାଣି ମେସାନା ଜୀୱୁତା ହା଼ରେକା ଦୁକୁ ଆ଼ହାନା ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“ଏ଼ୱାଣାଇଁ ଆମ୍ବିୟା ଇଟାମାଞ୍ଜେରି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ପ୍ରବୁ, ୱା଼ହାନା ସିନିକିମୁ ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜୀସୁ ଡ଼ୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଏଚେଟିଏ ଜୀହୁଦି ଲ଼କୁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଚେକା ଜୀୱୁ ନ଼ହିଁମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ସାମା ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଈ ମାଣ୍‌ସି ଏ଼ କା଼ଣାଇଁ ମେସ୍‌ପି କିହାମାଚେସି, ଏ଼ୱାସି ଈୱାଣାଇଁ ହା଼କିଟି ଗେଲ୍‌ପାଲି ଆ଼ଡିତେସିମା ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଏମ୍ବାଟିଏ ଜୀସୁ ଦୁକୁ ଆ଼ହାନା ମାହ୍‌ଣି ମାଣ୍ତା ଡାଗେ ୱା଼ତେସି; ଏ଼ଦି ର଼ ପା଼ୱୁ ମାଚେ, ଇଞ୍ଜାଁ ପା଼ୱୁ ଦୁୱେରିତା ର଼ କାଜା ୱାଲି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜୀସୁ ଏଲେଇଚେସି, “ଈ ୱାଲି ଗୁଚି କିଦୁ ।” ହା଼ତାଣି ତାଙ୍ଗି ମାର୍ତା ଏଲେଇଚେ, “ପ୍ରବୁ, ଏ଼ୱାସି ଗାନ୍ଦା ଆ଼ହାହାଚେସିଏ, ଇଚିହିଁ ହା଼ହାନା ସା଼ରି ଦିନା ଆ଼ତେସିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ନୀନୁ ନାମିଦି, ଆ଼ତିହିଁ ମାହାପୂରୁତି ଗାୱୁରମି ମେହ୍‌ଦି, ଈ କାତା ନା଼ନୁ ନିଙ୍ଗେ ୱେସାମାଞ୍ଜାଆତେଏଁ ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ଅ଼ଡ଼େ ଏ଼ୱାରି ୱାଲି ଗୁଚି କିତେରି । ଅ଼ଡ଼େ ଜୀସୁ ଲାକୱାକି ସିନିକିହାନା ଏଲେଇଚେସି, “ଆ଼ବା ନା଼ ପ୍ରା଼ତାନା ୱେଚି ଇଞ୍ଜିଁ ନା଼ନୁ ନିଙ୍ଗେ ଜହରା କିହିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ନୀନୁ କା଼ଲେଏ ନା଼ ପ୍ରା଼ତାନା ୱେଞ୍ଜିମାଞ୍ଜି, ଈ କାତା ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ; ସାମା ଏମିନି ଲ଼କୁ ସା଼ରିସୁଟୁ ନିଚାମାନେରି, ନୀନୁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାଦି ଇଞ୍ଜିଁ ଏ଼ୱାରି ଏ଼ନିକିଁ ନାମିନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ତାକି ନା଼ନୁ ଏଲେଇଚେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଏ଼ୱାସି ଏଲେଇଞ୍ଜାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଲାଜର ପାଙ୍ଗାତା ହ଼ଚା ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଦେବୁଣିଏ ଲାଜର ପାଙ୍ଗାତା ହ଼ଚାୱା଼ତେସି; ତାନି କେସ୍କା କଡାଣା ମାହ୍‌ଣି ମାଣ୍ତାତି ହିମ୍ବରିକା ତଲେ ରୂପି ଆ଼ହାମାଚୁ, ଇଞ୍ଜାଁ ତାନି ମୂମ୍ବୁତା ଇଚାୟି ପାସ୍‌କି ପିଡ଼୍‌ଗିୱି ଆ଼ହାମାଚେ । ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ହିମ୍ବରିକା ହୁକ୍‌ଦୁ ଏ଼ୱାସି ତା଼କାପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ହା଼ରେକା ଜୀହୁଦି ଲ଼କୁ, ଇଚିହିଁ ଆମ୍ବାଆରି ମରିୟମ ତା଼ଣା ୱା଼ହାମାଚେରି ଅ଼ଡ଼େ ଜୀସୁତି କାମା ମେସାମାଚେରି, ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ଅ଼ଡ଼େ ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରି ପାରୁସିୟାଁ ତା଼ଣା ହାଜାନା ଜୀସୁ ଏ଼ନା ଏ଼ନାଆଁ କିହାମାଚେସି ଏ଼ ବାରେ ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଈ କାତା ୱେଞ୍ଜାନା ପାରୁସିୟାଁ ଅ଼ଡ଼େ କାଜା ପୂଜେରାଙ୍ଗା କାଜା ବେ଼ରଣିମାଣ୍ତାତା ଏଲେଇଚେରି, “ମା଼ର ଏ଼ନି କିନାୟି ଈ ମାଣ୍‌ସି ହା଼ରେକା କାବାଆ଼ନି କାମାୟାଁ କିହିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ମା଼ର ଏ଼ୱାଣାଇଁ ଏଲେକିହିଁ ପିସ୍ତିହିଁ ବାରେ ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ନାମିନେରି, ଅ଼ଡ଼େ ରମିୟ ଲ଼କୁ ୱା଼ହାନା ଈ ଟା଼ୟୁ କୂଡ଼ା ବାରେତି ନା଼ସା କିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ସାମା ଏ଼ୱାରି ବିତ୍ରାଟି ର଼ କାଜା ପୂଜେରା, ଇଚିହିଁ କୟାପା ଏ଼ ବାର୍ସାତି କାଜା ପୂଜେରା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ପୁଞ୍ଜାହିଲଅତେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ବାରେ କୂଡ଼ାତାରି ନା଼ସା ଆ଼ନି କିହାଁ ବାରେ ଲ଼କୁ ତାକି ରଅସି ହା଼ନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ, ଈଦାଆଁ ମୀରୁ ଅଣ୍‌ପି ହିଲଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ଏ଼ୱାସି ତାନିତା଼ଣାଟି ଏଲେଇଞ୍ଜା ହିଲାଆତେସି, ସାମା ଏ଼ୱାସି ଏ଼ ବାର୍ସାତି କାଜା ପୂଜେରା ମାଚାକି ଈ ଡା଼ୟୁ ଆ଼ନି କାତା ତାନି ଗୂତିଟି ହ଼ଚାମାଚେ, ଜୀସୁ ଏ଼ କୂଡ଼ାତି ଲ଼କୁ ତାକି, ");
INSERT INTO kxv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଅ଼ଡ଼େ ୱାର୍‌ଇ ଏ଼ କୂଡ଼ା ତାକି ଆ଼ଏ, ସାମା ମାହାପୂରୁତି ଇତାଲା ଆତାଲା ଆ଼ହାମାନି ମୀର୍‌କାଣି ଜିକେଏ କୂଡ଼ି କିହାନା ରଣ୍ତିଏ କିହାଲିତାକି ହା଼ହାଲି ହାଜିମାନେସି, ଈଦାଆଁତାକି ଈ କାତା ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଇଞ୍ଜାଁ ଏ଼ ଦିନାଟିଏ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ତାକି ପାରୁ ପାରିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଏ଼ଦାଆଁତାକି ଜୀସୁ ଜୀହୁଦି ଲ଼କୁ ବିତ୍ରା ପାଙ୍ଗାୱେ଼ଙ୍ଗେ ରେ଼ଆତେସି, ସାମା ଏ଼ୱାସି ଏ଼ ଟା଼ୟୁଟି ହ଼ଚା ହାଜାନା ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁ ଦାରି ମାନି ଏପ୍ରିୟମ ଦ଼ରୁଗାଟି ର଼ ଗା଼ଡ଼ାତା ହାଚେସି, ଅ଼ଡ଼େ ସୀସୁୟାଁ ତଲେ ଏମ୍ବାଆଁ ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଏଚିବେ଼ଲା ଜୀହୁଦି ଲ଼କୁତି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ଡାଗେ ମାଚେ, ଅ଼ଡ଼େ ନା଼ସ୍‌କାଟି ହା଼ରେକା ଲ଼କୁ ଜାହାରାଇଁ ଅଟ୍‌ହା କଡାଲି ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ନ଼କେଏ ଜିରୁସାଲମତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ପାରି ପାରିହିଁ ମାହାପୂରୁ ଇଲୁତା ନିଚାମାଚାଟି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ଏଲେଇଣ୍‌ମ୍ବି ଆ଼ତେରି, “ମୀରୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜେରି ? ଏ଼ୱାସି କି ପାର୍ବୁତା ୱା଼ଅସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପାରୁସିୟାଁ ଏ଼ୱାଣାଇଁ ଆସାଲି ତାକି, ଏ଼ୱାସି ଏମ୍ବିୟା ମାନେସି, ଈ କାତା ଆମ୍ବାଆସି ପୁଞ୍ଜାମାନେସି, ଏ଼ କାତା ୱେସାଲି ତାକି ହୁକୁମି ହୀହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଏମ୍ବାଟିଏ ଜୀସୁ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ସ଼ ଦିନା ନ଼କେଏ ବେତନିୟାଁତା ୱା଼ତେସି; ଏମିନି ଲାଜରଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ହା ମାଚେସି, ଏ଼ୱାସି ଏ଼ ଟା଼ୟୁତା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ୱାଣାକି ଏ଼ ଟା଼ୟୁତା ଲା଼ଆଁୟାଁ ର଼ ବ଼ଜି କିତେରି; ମାର୍ତା ବା଼ଟି କିହିମାଚେ, ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି ଏ଼ୱାଣିତଲେ ତିଞ୍ଜାଲି କୁଗାମାଚେରି, ଲାଜର ଏ଼ୱାରି ବିତ୍ରାଟି ରଅସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ଏଚିବେ଼ଲା ମରିୟମ ଆଦା ଗା଼ଜୁ ଗାନ୍ଦା ନିୟୁଁ ତାଚାନା ଜୀସୁ କଡାଣା ରୁବାନା ତାନି ତା଼ର୍ୟୁଁ ବା଼ଣାୟାଁ ତଲେ ତାନି କଡାଁଣି ଜେ଼ତେ, ଅ଼ଡ଼େ ବାରେ ଇଲୁତା ନିୟୁଁ ଗାନ୍ଦା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ସାମା ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ଇସ୍କାରିୟତ ଜୀହୁଦା ଆମିନି ସୀସୁ ଜୀସୁଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାଲି ହାଜିମାଚେସି, ଏ଼ୱାସି ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଈ ନିୟୁଁ ତୀନି ୱାଞ୍ଜା ଟାକାୟାଁ ତାକି ପାର୍‌ପି ଆ଼ହାନା ଏ଼ନାଆଁତାକି କା଼କୁଲି ଗାଟାରାକି ହୀପ୍‌କି ଆ଼ଆତେ ?” ");
INSERT INTO kxv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ଏ଼ୱାସି କା଼କୁଲି ଗାଟାରାଇଁ ଅଣ୍‌ପିମାଚେସି ଇଞ୍ଜିଁ ଏଲେଇଚେସି, ଏ଼ଦି ଆ଼ଏ, ସାମା ଏ଼ୱାସି ର଼ ସ଼ରୁ ଅ଼ଡ଼େ ଏ଼ୱାଣି ତା଼ଣା ଟାକାୟାଁ ମ଼ଣା ମାଚାକି, ଏମ୍ବାଆଁ ଏ଼ନା ଏ଼ନାଆଁ ଇଟ୍‌କି ଆ଼ହିମାଚେ, ଏ଼ଦାଆଁ ସ଼ରୁ କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ଈଦାଆଁ ପିହ୍‌ଦୁ, ଏ଼ନିକିଁ ନା଼ ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଦିନାତାକି ଏ଼ଦି ଏ଼ଦାଆଁ ଇଟାଲି ଆ଼ଡିନେ । ");
INSERT INTO kxv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","କା଼କୁଲି ଗାଟାରି ବାରେଦିନା ମୀ ତା଼ଣା ମାନେରି, ସାମା ନା଼ନୁ ବାରେବେ଼ଲା ମୀ ତଲେ ମାନଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଏଚେଟିଏ ହା଼ରେକା ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାସି ଏମ୍ବାଆଁ ମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ୱାର୍‌ଇ ଜୀସୁ ତାକି ଆ଼ଏ, ସାମା ଏମିନି ଲାଜରଇଁ ଏ଼ୱାସି ହା଼କିଟି ନିକ୍‌ହା ମାଚେସି, ଏ଼ୱାଣାଇଁ ମେସାଲି ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ସାମା ଲାଜରଇଁ ଜିକେଏ ପା଼ୟାଲି କାଜା ପୂଜେରାଙ୍ଗା ପାରୁ ପାରିତେରି, ");
INSERT INTO kxv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଇଚିହିଁ ଏ଼ୱାଣି ତାକି ଜୀହୁଦିୟାଁ ବିତ୍ରାଟି ହା଼ରେକା ହାଜାନା ଜୀସୁ ତା଼ଣା ନାମି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ତାନି ଅ଼ର ଦିନା ପାର୍ବୁତା ୱା଼ହାମାନି ହା଼ରେକା ଲ଼କୁ ଜୀସୁ ଜିରୁସାଲମତା ୱା଼ହାମାନେସି ଇଞ୍ଜିଁ ୱେଚେରି ");
INSERT INTO kxv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ଇଞ୍ଜାଁ କାଜୁରି ମାଟାୟାଁ ଆସାନା ଜୀସୁଇଁ ବେଟାଆ଼ହାଲି ୱା଼ତେରି ଅ଼ଡ଼େ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ହ଼ସାନା । ପ୍ରବୁତି ଦ଼ରୁତଲେ ଆମ୍ବାଆସି ୱା଼ହିମାନେସି, ଏ଼ୱାସି ନେହେଁ; ଇସ୍ରାୟେଲତି ରାଜାଇଁ ମାହାପୂରୁ ବ଼ର ହୀପାସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଜୀସୁ ର଼ ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁ ଲାକ କୁଗାନା ୱା଼ହିମାଚେସି, ଏ଼ନିକିଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ");
INSERT INTO kxv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ଆକେ ସିୟନତି ମା଼ସ୍‌କା, ଆଜାଆଦୁ ମେହ୍‌ଦୁ ମୀ ରାଜା ୱା଼ହିମାନେସି, ଏ଼ୱାସି ଗା଼ଡ଼୍‌ଦେ ଡା଼ଲୁ ଲାକ କୁଗାନା ୱା଼ହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଏଚିବେ଼ଲା ସୀସୁୟାଁ ଏ଼ଦାନି କାତା ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି, ସାମା ଜୀସୁ ଗାୱୁରମିଟି ୱେଣ୍ତେ ନିଙ୍ଗାଲିଏ ଏ଼ୱାରି ଅଣ୍‌ପୁତା ୱା଼ତେ, ଈ ବାରେ କାତା ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଇଚିହିଁ ଏଲେକିହିଁଏ ଏ଼ୱାରି କାମା କିହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଜୀସୁ ହା଼ତି ଲାଜରଇଁ ମାହ୍‌ଣି ମାଣ୍ତାଟି ହା଼ଟାନା ନିକ୍‌ହାମାଚି ବେ଼ଲାତା ଏମିନିଗାଟାରି ଏ଼ୱାଣିତଲେ ମାଚେରି, ଏ଼ୱାରି ଈ ବାରେ କାତା ସା଼ରିୱାକି ୱେ଼କ୍‌ହା ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ଈଦାଆଁତାକି ଲ଼କୁ ବାରେ ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ହାଲି ହାଜାମାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଈ କାବାଆ଼ନି କାମା କିହାମାଚେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ଈଦାଆଁ ମେସାନା ପାରୁସିୟାଁ ତାମି ବିତ୍ରା କାତା ଆ଼ତେରି, “ମେସିମାଞ୍ଜେରି ମା଼ର ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡିହିଲାଆୟି; ଦାର୍‌ତିତି ବାରେ ଲ଼କୁ ଏ଼ୱାଣି ଜେ଼ଚ ହାଜିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପାର୍ବୁ ବେ଼ଲାତା ପ୍ରା଼ତାନା କିହାଲି ଜିରୁସାଲମତା ୱା଼ହାମାନି ଲ଼କୁ ବିତ୍ରା ଏଚେକା ଗ୍ରିକ୍‌ ଲ଼କୁ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ଏ଼ୱାରି ଗାଲିଲିତି ବେତ୍‌ସାୟିଦାତି ପିଲିପ ତା଼ଣା ୱା଼ହାନା ବାତିମା଼ଲିହିଁ ଏଲେଇଚେରି, “ବା଼ବୁ, ମା଼ମ୍ବୁ ଜୀସୁଇଁ ମେସାଲି ଅଣ୍‌ପିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ ହାଜାନା ଆନ୍ଦ୍ରିୟଇଁ କାବ୍ରୁ ହୀତେସି ଅ଼ଡ଼େ ରିଆରି ହାଜାନା ଜୀସୁଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମାଣ୍‌ସି ମୀର୍‌ଏସି ଗାୱୁରମି ଆ଼ନି ବେ଼ଲା ୱା଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ଗ଼ହଁ ପା଼ଡ଼େୟି ବୂମିତା ରିହାନା ହା଼ନି ପାତେକା ଏ଼ଦି ରଣ୍ତିଏ ପା଼ଡ଼େୟି ଆ଼ହାନା ଡ଼ୟିନେ, ସାମା ଏ଼ଦି ହା଼ତିସାରେ ଏମ୍ବାଟି ହା଼ରେକା ପା଼ଡ଼େୟିକା ଆ଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଆମ୍ବାଆସି ଜାହାରା ଜୀୱୁତି ଜୀୱୁ ନ଼ନେସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ ହା଼ରୱି କିନେସି, ଆମ୍ବାଆସି ଜାହାରା ଜୀୱୁତି ଈ ଦାର୍‌ତିତା ଅ଼ପଅସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ କା଼ଲାକା଼ଲା ତାକି ଗେଲ୍‌ପିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଆମ୍ବାଆସି ନା଼ ସେ଼ବା କାମାକିନାସି ଆ଼ନେସି, ଆତିହିଁ ଏ଼ୱାସି ନା଼ ଜେ଼ଚ ୱା଼ପେସି; ଅ଼ଡ଼େ ନା଼ନୁ ଆମ୍ବିୟା ଡ଼ୟିଇଁ, ନା଼ ସେ଼ବା କାମାକିନାସି ଜିକେଏ ଏମ୍ବାଆଁ ଡ଼ୟିନେସି; ଆମ୍ବାଆସି ନା଼ ସେ଼ବା କିନେସି, ଆତିହିଁ ଆ଼ବା ଏ଼ୱାଣାଇଁ ମା଼ନି କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ନୀଏଁ ନା଼ ଜୀୱୁ କିଲିବିଲି ଆ଼ହିମାନେ, ଇଞ୍ଜାଁ ନା଼ନୁ ଏ଼ନାଆଁ ଇଞ୍ଜାଇଁ ? ଆ଼ବା ଈ ଲାଗେଏ ତା଼ଣାଟି ଗେଲ୍‌ପାମୁ, ସାମା ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଈ ଟା଼ୟୁତା ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ଆ଼ବା ନୀ ଦ଼ରୁ ଗାୱୁରମି ଆ଼ପେ ।” ଏଚିବେ଼ଲାତା ହା଼ଗୁ ଲାକଟି ଈ ହା଼ଡା ଆ଼ତେ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ଗାୱୁରମି କିହାମାଇଁ ଅ଼ଡ଼େ ଗାୱୁରମି କିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ଦାରି ନିଚାମାଚି ଲ଼କୁ ବାରେ ଈ ହା଼ଡା ୱେଞ୍ଜାନା ଏଲେଇଚେରି, “ଈଦି ହା଼ଗୁ ଗୂଣ୍‌ହିମାନେ ।” ଅ଼ଡ଼େ ଏଟ୍‌କାତାରି ଏଲେଇଚେରି, “ଲାକପୂରୁତି ଦୂତୁ ଏ଼ୱାଣିତଲେ କାତା ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜୀସୁ ଏଲେଇଚେସି, “ଈ ହା଼ଡା ନାଙ୍ଗେତାକି ଆ଼ହା ହିଲେଏ, ସାମା ଈ ହା଼ଡା ମିଙ୍ଗେତାକି ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ନୀଏଁ ଈ ଦାର୍‌ତି ବିଚାରା କିନି ଦିନା; ନୀଏଁ ଈ ଦାର୍‌ତିତି ସା଼ଲୱି କିନାଇ ଡ଼଼ଇ ମେତ୍‌ପିଆ଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ନା଼ନୁ ଏଚିବେ଼ଲା ଦାର୍‌ତିଟି ଲାକପୂରୁ ଅ଼ୱିଆ଼ଇଁ, ଏଚିବେ଼ଲା ବାରେତି ନା଼ ତା଼ଣା ରେଜା ଅ଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ଏ଼ୱାସି ଏ଼ନିକିଁ ହା଼ହାଲି ହାଜିମାନେସି, ଏ଼ୱାସି ଈ କାତାତା ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମସିହା କା଼ଲେଏ ଡ଼ୟିନେସି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ମ଼ସାତି ମେ଼ରାତା ୱେଞ୍ଜାମାନମି, ଆତିହିଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଲାକ ପେର୍‌ୱି ଆ଼ନେସି ଇଞ୍ଜିଁ ନୀନୁ ଏ଼ନିକିଁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ? ଏ଼ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଆମ୍ବାଆସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଅ଼ଡ଼େ ଗା଼ଡ଼େକା ତାକି ଉଜେଡ଼ି ମୀ ତା଼ଣା ମାନେ । ଆନ୍ଦେରି ମିଙ୍ଗେ ଏ଼ନିକିଁ ଗୂସ୍ତେଏ, ଏ଼ଦାଆଁତାକି ମୀ ତା଼ଣା ଉଜେଡ଼ି ମାଞ୍ଜା ମାଞ୍ଜାନା ତା଼କାଦୁ; ଆମ୍ବାଆସି ଆନ୍ଦେରିତା ତା଼କିନେସି, ଏ଼ୱାସି ଆମ୍ବିୟା ହାଜିମାନେସି ପୁଞ୍ଜାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ମୀରୁ ଏ଼ନିକିଁ ଉଜେଡ଼ିତି ମୀର୍‌କା ମା଼ସ୍‌କା ଆ଼ଦେରି, ଏ଼ଦାଆଁତାକି ଉଜେଡ଼ି ମୀ ତା଼ଣା ମାଞ୍ଜା ମାଞ୍ଜାନା ଉଜେଡ଼ିତା ନାମାଦୁ ।” ଜୀସୁ ଈ ବାରେ କାତା ୱେସାନା ହାଚେସି ଇଞ୍ଜାଁ ଏ଼ୱାରି ତା଼ଣାଟି ଡ଼ୁଗାନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଏ଼ୱାରି ନ଼କିତା ଏଚେକା କାବାଆ଼ନି କାମାୟାଁ କିହାମାଚେସି, ଆ଼ତିଜିକେଏ ଏ଼ୱାରି ଏ଼ୱାଣି ତା଼ଣା ନାମା ହିଲାଆତେରି, ");
INSERT INTO kxv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଏ଼ନିକିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ତା଼ଣାଟି ରା଼ଚାମାନି କାତା ପୂରା ଆ଼ନେ, “ପ୍ରବୁ ମା଼ ହା଼ଡା ୱେଞ୍ଜାନା ଆମ୍ବାଆସି ନାମା ମାନେସି ? ଆମ୍ବାଆରି ତା଼ଣା ପ୍ରବୁ ତାନି ବା଼ଡ଼୍‌ୟୁ ତ଼ସାମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଈଦାଆଁତାକି ଏ଼ୱାରି ନାମାଲି ଆ଼ଡିହିଲାଆତେରି, ଇଞ୍ଜାଁ ଜିସାୟ ଏଲେଇଞ୍ଜାମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ସାତେଏ ମାହାପୂରୁ ଏ଼ୱାରି କାଣ୍‌କା କା଼ଣା କିହାମାନେସି । ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ହିୟାଁତା ଏ଼ନାଆଁ ମେସାଲି ଆ଼ଡଅରି, ଇଞ୍ଜାଁ ହିୟାଁତା ଏ଼ନାଆଁ ତେଲ୍‌ହାଲି ଆ଼ଡଅରି ମାହାପୂରୁ ଏଲେଇଞ୍ଜି ମାନେସି, “ନେହିଁ ଆ଼ହାଲିତାକି ଏ଼ୱାରି ନା଼ ତା଼ଣା ୱେଣ୍ତା ୱା଼ହିହିଲଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିସାୟ ଜୀସୁ କ୍ରୀସ୍ତତି ଗାୱୁରମି ମେସ୍ତେସି ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଏ଼ୱାଣି କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଆ଼ତିଜିକେଏ ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ହା଼ରେକା ଏ଼ୱାଣି ତା଼ଣା ନାମିତେରି, ସାମା ଏଚେ଼ତା ଜୀହୁଦି କୁଲମିଟି ପେ଼ର୍‌ହାନେରି ଇଞ୍ଜିଁ ପାରୁସିୟାଁ ଆଜିତାକି ବାରେଜା଼ଣା ଏ଼ କାତାବାର୍ତା ଆ଼ହି ହିଲାଆତେରି, ");
INSERT INTO kxv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଇଚିହିଁ ଏ଼ୱାରି ମାହାପୂରୁ ତା଼ଣାଟି ଗାୱୁରମି କିହାଁ ମାଣ୍‌ସିୟାଁ ତା଼ଣାଟି ଗାୱୁରମି ଜୀୱୁ ନ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜୀସୁ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ନା଼ ତା଼ଣା ନାମଅସି, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ନାମିନେସି; ");
INSERT INTO kxv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଆମ୍ବାଆସି ନାଙ୍ଗେ ମେସ୍ତାନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ମେହ୍‌ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ଏ଼ନିକିଁ ଆନ୍ଦେରିତା ବାସା କିଅସି, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଦାର୍‌ତିତା ଉଜେଡ଼ି ଆ଼ହାନା ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଆମ୍ବାଆସି ନା଼ ବ଼ଲୁ ୱେଞ୍ଜାନା ମା଼ନୱି ଆ଼ଅସି, ଆ଼ତିହିଁ ନା଼ନୁ ଏ଼ୱାଣି ବିଚାରା କିଅଁ; ଇଚିହିଁ ନା଼ନୁ ଦାର୍‌ତିତା ବିଚାରା କିହାଲି ୱା଼ଆନା ଦାର୍‌ତିତି ଗେଲ୍‌ପାଲି ୱା଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଆମ୍ବାଆସି ନାଙ୍ଗେ ଅ଼ପଅସି ଅ଼ଡ଼େ ନା଼ ବ଼ଲୁତି ଆବଅସି, ନା଼ନୁ ଏମିନି ବ଼ଲୁ ଜ଼ଲାମାଇଁ, ନା଼ ଗୂତିତି ବ଼ଲୁ ଡା଼ୟୁତି ଦିନାତା ଏ଼ୱାଣି ବିଚାରା କିନେ; ");
INSERT INTO kxv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଇଚିହିଁ ନା଼ନୁ ନା଼ ତା଼ଣାଟି ଜ଼ଲା ହିଲଅଁ, ସାମା ନା଼ନୁ ଏ଼ନାଆଁ ଜ଼ଲିଇଁ ଅ଼ଡ଼େ ଏ଼ନାଆଁ ୱେ଼କ୍‌ଇଁ, ଏ଼ଦାଆଁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନି ଆ଼ବା ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି ");
INSERT INTO kxv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଇଞ୍ଜାଁ ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ ତାନି ହୁକୁମି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ହୀନେ । ନା଼ ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନାଆଁ ଜ଼ଲାଲି ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି, ୱାର୍‌ଇ ଏଲେକିହିଁଏ ୱେହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ନ଼କେଏ ଜୀସୁ ଈ ଦାର୍‌ତିଟି ଆ଼ବା ତା଼ଣା ହାନି କାଟୁ ଆ଼ହାଲିଏ, ଦାର୍‌ତିତା ମାନି ତାନି ଲ଼କୁଣି ଏ଼ୱାସି ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଏ଼ୱାରାଇଁ ହା଼ରେକା ଜୀୱୁ ନ଼ନାଣି ତ଼ସାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ଜୀସୁ ତାନି ସୀସୁୟାଁ ତଲେ ଲା଼ଆଁୟାଁ ତିନି ବେ଼ଲାତା ସୟତାନ ସିମନ ମୀର୍‌ଏସି ଇସ୍କାରିୟତ ଜୀହୁଦା ହିୟାଁତା ଜୀସୁଇଁ ସାତ୍ରୁ କେୟୁତା ହେର୍‌ପାଲି ଅଣ୍‌ପି କିହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ଏଚିବେ଼ଲା ଆ଼ବା ତାନି କେୟୁତା ବାରେ ହେର୍‌ପା ମାନେସି ଅ଼ଡ଼େ ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାନେସି, ଅ଼ଡ଼େ ମାହାପୂରୁ ତା଼ଣା ହାଜିମାନେସି, ");
INSERT INTO kxv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ଈଦାଆଁ ପୁଞ୍ଜାନା ରା଼ନ୍ଦା ତିନି ତା଼ଣାଟି ନିଙ୍ଗାନା, ତାନି ହିମ୍ବରି ଇଟିତେସି ଇଞ୍ଜାଁ ର଼ ତୁୱାଲା ତାନି ଟେଡେଲିତା ରୂପା କଡିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ଡା଼ୟୁ ଏ଼ୱାସି ମୁତାତା ଏ଼ୟୁ କଡିତେସି, ଅ଼ଡ଼େ ସୀସୁୟାଁତି କଡାୟାଁ ନର୍‌ହାନା ତାନି ଟେଡେଲିତା ମାନି ତୁୱାଲା ତଲେ ଜେ଼ଜାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଏଚିବେ଼ଲା ଜୀସୁ ସିମନ ପିତର ଦାରିତା ୱା଼ତେସି; ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ ନୀନୁ ନା଼ କଡାୟାଁ ନର୍‌ହି ମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ନାଆଁ କିହିମାଇଁ ନୀନୁ ନୀଏଁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲି ଆ଼ଡଅତି, ଡା଼ୟୁ ପୁଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର ଏଲେଇଚେସି, “ଆ଼ଏ, ନା଼ କଡାୟାଁ ଏଚେଲାୱା ନର୍‌ହଅତି ।” ସାମା ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ନୀ କଡାୟାଁ ନର୍‌ହାଆତିହିଁ ନୀନୁ ଅ଼ଡ଼େ ନା଼ ସୀସୁ ଆୟାଲି ଆ଼ଡଅତି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମନ ପିତର ଏଲେଇଚେସି, “ପ୍ରବୁ, ଆତିହିଁ କଡାୟାଁ ଏ଼ନାଆଁକି, ନା଼ କେସ୍କା ଅ଼ଡ଼େ ତା଼ର୍ୟୁଁ ଜିକେଏ ନର୍‌ହାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ଏ଼ୟୁ ମୀହାମାନେସି, ଏ଼ୱାଣି କଡାୟାଁ ନର୍‌ନି କିହାଁ ଏ଼ନାୟି ଲ଼ଡ଼ା ହିଲେଏ, ମୀରୁ ଅଟ୍‌ୱି ଆ଼ହାମାଞ୍ଜେରି; ସାମା ବାରେଜା଼ଣା ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଇଚିହିଁ ଆମ୍ବାଆସି ଏ଼ୱାଣାଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିନେସି ଜୀସୁ ତଲିଏ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜାମାଚେସି; ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଏଲେଇଚେସି, “ମୀରୁ ବାରେଜା଼ଣା ଅଟ୍‌ୱି ଆ଼ହାହିଲଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ଡା଼ୟୁ ଜୀସୁ ଏ଼ୱାରି କଡାୟାଁ ନର୍‌ହାନା ତାନି ହିମ୍ବରି ପର୍‌ହାନା ୱେଣ୍ତେ ତିଞ୍ଜାଲି କୁଗିତେସି ଇଞ୍ଜାଁ ୱେଚେସି, “ନା଼ନୁ ମିଙ୍ଗେ ତାକି ଏ଼ନାଆଁ କିହାମାଇଁ ମୀରୁ ପୁଞ୍ଜାଲି ଆ଼ଡିତେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ମୀରୁ ନାଙ୍ଗେ ଗୂରୁ ଇଞ୍ଜିଁ ହା଼ଟିମାଞ୍ଜାଦେରି, ଏ଼ଦି ସାତା; ଇଚିହିଁ ନା଼ନୁ ଏ଼ୱାତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ମୀ ଗୂରୁ ଅ଼ଡ଼େ ପ୍ରବୁତେଏଁ ନା଼ନୁ, ନା଼ନୁ ମୀ କଡାୟାଁ ନର୍‌ହାମାଞ୍ଜାଇଁ ଆତିହିଁ ମୀରୁ ଜିକେଏ ରଅତେରି ରଅଣି କଡାୟାଁ ନର୍‌ନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେତାକି ଏ଼ନିକିଁ କିହାମାଇଁ ମୀରୁ ଜିକେଏ ଏଲେକିହିଁ କିଦୁ, ଈଦାଆଁତାକି ଈଦାଆଁ ତ଼ସାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ସାତା ସାତା ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ହ଼ଲେଏସି ତାନି ସା଼ୱୁକାରି କିହାଁ କାଜାସି ଆ଼ଏ, ଅ଼ଡ଼େ ପାଣ୍ତ୍‌ୱି ଆ଼ତାସି ତାନି ପାଣ୍ତିତାଣା କିହାଁ କାଜାସି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ମୀରୁ ଈ ବାରେ ପୁଞ୍ଜାନା ଏଲେକିଁ କିଦେରି ଇଚିହିଁ ମୀରୁ ନେହାଁତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ନା଼ନୁ ମୀ କାତା ୱେସିହିଲଅଁ; ଏ଼ନିଲେହେଁତି ଲ଼କୁଣି ନା଼ନୁ ଆ଼ଚାମାଇଁ, ଏ଼ କାତା ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ; ସାମା ଦାର୍ମୁ ପତିତି ଈ ବ଼ଲୁ ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ, ଈଦାଆଁତାକି ଈ ବାରେ ଆ଼ହିମାନେ, ‘ଆମ୍ବାଆସି ନା଼ କା଼ଦି ତିନେସି ଏ଼ୱାସି ନା଼ କ଼ପାଟି ନିଙ୍ଗିତେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଏ଼ଦି ଗଟୱି ଆ଼ନାଟି ନା଼ନୁ ଏ଼ୱାତେଏଁ ଇଞ୍ଜିଁ ମୀରୁ ନାମିଦେରି, ଏ଼ଦାଆଁତାକି ଗଟୱି ଆ଼ନି ନ଼କେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ସାତା ସାତା ନା଼ନୁ ମିଙ୍ଗ ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ନା଼ ତା଼ଣାଟି ପାଣ୍ତ୍‌ୱି ଆ଼ତାଣାଇଁ ଆବିନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଆବାନେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନାଙ୍ଗେ ଆବାନେସି ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ଆବିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜୀସୁ ଈ ବାରେ କାତା ୱେସ୍ତି ଡା଼ୟୁ ଜୀୱୁତା ହା଼ରେକା ଦୁକୁ ଆ଼ହାନା ବାରେତି ନ଼କିତା ୱେ଼କ୍‌ହେସି, “ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ ମୀ ବିତ୍ରାଟି ରଅସି ନାଙ୍ଗେ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଏ଼ୱାସି ଆମ୍ବାଆରି କାତା ଏଲେଇଚେସି, ପୁନାଆନା କାବାଆ଼ହାନା ସୀସୁୟାଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ସିନିକିୱି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଏ଼ୱାରି ବିତ୍ରାଟି ଏମିନି ସୀସୁଇଁ ଜୀସୁ ହା଼ରେକା ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଏ଼ୱାସି ଜୀସୁତି ଟିଃନିୱାକି କୁଗାନା ତିଞ୍ଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ସିମନ ପିତର ଏ଼ୱାଣାଇଁ କେୟୁତଲେ ଏଲେଇଚେସି, “ଏ଼ୱାସି ଆମ୍ବାଆରି କାତା ଏଲେଇଞ୍ଜି ମାନେସି, ଏ଼ଦାଆଁ ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ଏ଼ ସୀସୁ ଅ଼ଡ଼େ ଡାଗେ ଆ଼ହାନା ଜୀସୁଇଁ ୱେଚେସି, “ଏ଼ୱାସି ଆମ୍ବାଆସି ପ୍ରବୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଜୀସୁ ଏଲେଇଚେସି, “ଈ ରୂଟି ଗିନାତା କୁତି କିହାନା ହୀଇଁ ଏ଼ୱାସି ।” ଏଲେଇଞ୍ଜାନା ଜୀସୁ ରୂଟି ଗିନାତା କୁତି କିହାନା ସିମନ ମୀର୍‌ଏସି ଇସ୍କାରିୟତ ଜୀହୁଦାକି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ରୂଟି ରୀସାଲିଏ ସୟତାନା ଏ଼ୱାଣି ହିୟାଁତା ହ଼ଟେ । ଏଚେଟିଏ ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁ କିନାୟିମାନେ ତବେ କିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଈ କାତା ଏ଼ନାଆଁତାକି ଏଲେଇଚେସି ଏଟ୍‌କାତାରି ଆମ୍ବାଆରି ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଜୀହୁଦା କେୟୁତା ଟାକାୟାଁ ମ଼ଣା ମାଚାକି, ପାର୍ବୁତାକି ଏ଼ନା ଏ଼ନାଆଁ ଲ଼ଡ଼ାମାନେ, ଏ଼ଦାଆଁ କଡାଲି ଆ଼ଆତିଁ କା଼କୁଲି ଗାଟାରାକି ହୀହାଲିତାକି ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି ଇଞ୍ଜିଁ ଆମ୍ବା ଆମ୍ବାଆରି ଅଣ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ରୂଟି ତିଞ୍ଜାନା ଜୀହୁଦା ଏ଼ ଦେବୁଣିଏ ପାଙ୍ଗାତା ହାଚେସି, ଏଚେ଼ତା ଲା଼ଆଁୟାଁ ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଜୀହୁଦା ପାଙ୍ଗାତା ହାଜାଲିଏ ଜୀସୁ ଏଲେଇଚେସି, “ନୀଏଁ ମାଣ୍‌ସି ମୀର୍‌ଏସି ଗାୱୁରମି ଆ଼ନି ବେ଼ଲା ୱା଼ହାମାନେ; ଅ଼ଡ଼େ ତାନିତା଼ଣାଟି ମାହାପୂରୁ ଗାୱୁରମି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ମାହାପୂରୁ ମାଣ୍‌ସି ମୀର୍‌ଏଣା ତା଼ଣାଟି ଗାୱୁରମି ଆ଼ତିହିଁ, ମାହାପୂରୁ ତା଼ନୁଏ ଗାୱୁରମିଟି ମାଣ୍‌ସି ମୀର୍‌ଏଣାଇଁ ଗାୱୁରମି କିନେସି । ତବେ ଏ଼ୱାଣାଇଁ ଗାୱୁରମି କିହାଲି ହାଜିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","କକାତେରି ନା଼ନୁ ଅ଼ଡ଼େ ଗାଡି ଦିନା ଡ଼ୟଅଁ, ମୀରୁ ନାଙ୍ଗେ ପାରାଦେରି, ସାମା ନା଼ନୁ ଆମ୍ବିୟା ହାଜିମାଇଁ ମୀରୁ ଏମ୍ବାଆଁ ହାଜାଲି ଆ଼ଡଅତେରି, ଈ କାତା ଜୀହୁଦି ଲ଼କୁତି କାଜାରାଇଁ ଏଲେଇଞ୍ଜା ମାଚେଏଁ ଏଲେକିହିଁ ମିଙ୍ଗେ ଜିକେଏ ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ମୀରୁ ରଅତେରି ରଅଣାଇଁ ଜୀୱୁନ଼ଦୁ, ଈ ପୁଃନି ମେ଼ରା ମିଙ୍ଗେ ହୀହିମାଞ୍ଜାଇଁ; ନା଼ନୁ ଏ଼ନିକିଁ ମିଙ୍ଗେ ଜୀୱୁନ଼ହାଁମାଞ୍ଜାଇଁ, ମୀରୁ ଜିକେଏ ଏଲେକିହିଁଏ ରଅତେରି ରଅଣାଇଁ ଜୀୱୁନ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ମୀ ତା଼ଣା ରଅସି ରଅଣାଇଁ ଜୀୱୁନ଼ନାୟି ମାନେ, ଆତିହିଁ ମୀରୁ ନା଼ ସୀସୁୟାଁତେରି, ଈ କାତା ବାରେଜା଼ଣା ପୁନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମନ ପିତର ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ପ୍ରବୁ ନୀନୁ ଆମ୍ବିୟା ହାଜିମାଞ୍ଜି ?” ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ଆମ୍ବିୟା ହାଜିମାଇଁ, ନୀନୁ ନୀଏଁ ନା଼ ଜେ଼ଚ ଜେ଼ଚ ହାଜାଲି ଆ଼ଡଅତି, ସାମା ଡା଼ୟୁ ହାଜି ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ ନୀଏଁ ନା଼ନୁ ଏ଼ନାଆଁକି ହାଜାଲି ଆ଼ଡଅଁ ? ନା଼ନୁ ନୀ ତାକି ନା଼ ଜୀୱୁ ଜିକେଏ ହୀଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜୀସୁ ଏଲେଇଚେସି, “ଏ଼ନାଆଁ ନୀନୁ ନା଼ ତାକି ନୀ ଜୀୱୁ ହୀଦି ? ନା଼ନୁ ନିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, କୟୁ କେ଼ଣ୍‌ଆ ନ଼କେଏ ନୀନୁ ନାଙ୍ଗେ ତୀନିପା଼ଲି ପୁଞ୍ଜାହିଲଅଁ ଇଞ୍ଜିଁ ଇଞ୍ଜାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“ମୀ ହିୟାଁ ଆଡାଜାକା ଆ଼ଆପେ; ମୀରୁ ମାହାପୂରୁ ତା଼ଣା ନାମାଦୁ, ଅ଼ଡ଼େ ନା଼ ତା଼ଣା ଜିକେଏ ନାମାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ନା଼ ଆ଼ବାତି ଇଜ ହା଼ରେକା ବାସାଟା଼ୟୁ ମାନେ; ବାସାଟା଼ୟୁ ହିଲାଆତିହିଁମା ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାଆତେଏଁମା, ନା଼ନୁ ମିଙ୍ଗେତାକି ଟା଼ୟୁ ତିୟାରା କିହାଲି ହାଜିମାଇଁ; ");
INSERT INTO kxv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଅ଼ଡ଼େ ନା଼ନୁ ହାଜାନା ମିଙ୍ଗେତାକି ଟା଼ୟୁ କେ଼ପିତି ଡା଼ୟୁ, ୱେଣ୍ଡେ ୱା଼ଇଁ, ଅ଼ଡ଼େ ନା଼ନୁ ଆମ୍ବିୟା ମାଇଁ, ମୀରୁ ଜିକେଏ ଏ଼ନିକିଁ ଏ଼ ଟା଼ୟୁତା ଡ଼ୟିଦେରି, ଏ଼ଦାଆଁତାକି ମିଙ୍ଗେ ଏ଼ ଟା଼ୟୁତା ଅ଼ହିଁ ହାଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ନା଼ନୁ ଆମ୍ବିୟା ହାଜିମାଇଁ ଏ଼ ଜିରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତ଼ମା ଏଲେଇଚେସି, “ପ୍ରବୁ, ନୀନୁ ଆମ୍ବିୟା ହାଜିମାଞ୍ଜି, ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି, ଏମ୍ବିୟା ହାଜି ଏ଼ ଜିରୁତି ଏ଼ନିକିଁ ପୁନମି ?” ");
INSERT INTO kxv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜିରୁ, ସାତା ଅ଼ଡ଼େ ଜୀୱୁତେଏଁ; ନା଼ ତା଼ଣାଟି ତା଼କାଆସାରେ ଆମ୍ବାଆସି ଆ଼ବା ତା଼ଣା ହାଜାଲି ଆ଼ଡଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ମୀରୁ ନାଙ୍ଗେ ପୁଞ୍ଜାତିହିଁମା, ନା଼ ଆ଼ବାଇଁ ଜିକେଏ ପୁଚେରିମା; ନୀଏଁ ଜିକେଏ ଏ଼ୱାଣାଇଁ ପୁଞ୍ଜିମାଞ୍ଜେରି ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ମେସାମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ପ୍ରବୁ, ମାଙ୍ଗେ ଆ଼ବାଇଁ ତ଼ସ୍ତାମୁ, ଏଚେକେଏ ମାଙ୍ଗେତାକି ସାରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜୀସୁ ଏଲେଇଚେସି, “ପିଲିପ ଇଚର ଦିନା ନା଼ନୁ ମୀ ତଲେ ଡ଼ୟାମାଇଁ, ମୀରୁ ଏ଼ନାଆଁ ନାଙ୍ଗେ ପୁଞ୍ଜାଆତେରି ? ଆମ୍ବାଆସି ନାଙ୍ଗେ ମେସାମାଞ୍ଜାନେସି ଏ଼ୱାସି ଆ଼ବାଇଁ ମେସାମାନେସି; ମାଙ୍ଗେ ଆ଼ବାଇଁ ତ଼ସ୍ତାମୁ ଇଞ୍ଜିଁ ଏ଼ନିକିଁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ? ");
INSERT INTO kxv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ନା଼ନୁ ଆ଼ବା ତା଼ଣା ଅ଼ଡ଼େ ଆ଼ବା ନା଼ ତା଼ଣା ମାନେସି, ଈ କାତା ଏ଼ନାଆଁ ମୀରୁ ନାମିହିଲଅତେରି ? ନା଼ନୁ ମିଙ୍ଗେ ଏମିନି କାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ ବାରେ ନା଼ ତା଼ଣାଟି ୱେସିମାଞ୍ଜଅଁ, ସାମା ଆ଼ବା ନା଼ ତା଼ଣା ମାଞ୍ଜାନା ତାନି କାମା କିହିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ନା଼ନୁ ଆ଼ବା ତା଼ଣା ମାଇଁ ଅ଼ଡ଼େ ଆ଼ବା ନା଼ ତା଼ଣା ମାନେସି ଈ କାତା ନାମାଦୁ, ଆ଼ଆତିଁ କାମାତି ମେସାନା ନାମାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ନାମିନେସି, ନା଼ନୁ ଏ଼ନି ଏ଼ନି କାମା କିହିମାଇଁ, ଏ଼ୱାସି ଜିକେଏ ଏ଼ ବାରେ କିନେସି, ଅ଼ଡ଼େ ଏ଼ ବାରେକିହାଁ ହା଼ରେକା କାଜା କାମା କିନେସି, ଇଚିହିଁ ନା଼ନୁ ଆ଼ବା ତା଼ଣା ହାଜିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଆ଼ବା ଏ଼ନିକିଁ ମୀର୍‌ଏଣା ତା଼ଣା ଗାୱୁରମି ଆ଼ନେସି, ଏ଼ଦାଆଁତାକି ମୀରୁ ନା଼ ଦ଼ରୁଟି ଏ଼ନାଆଁ ରୀହ୍‌ଦେରି, ଏ଼ ବାରେ ନା଼ନୁ ହିୟାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ମୀରୁ ନା଼ ଦ଼ରୁଟି ଏ଼ନାଆଁ ନାଙ୍ଗେ ରୀସ୍ତାଦେରି, ନା଼ନୁ ମିଙ୍ଗେ ଏ଼ ବାରେ ହିୟାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ମୀରୁ ନାଙ୍ଗେ ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାଦେରି, ଆତିହିଁ ନା଼ ହୁକୁମି ମା଼ନୱି ଆ଼ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ଅ଼ଡ଼େ ନା଼ନୁ ନା଼ ଆ଼ବାଇଁ ବାତିମା଼ଲିଇଁ, ଅ଼ଡ଼େ ମୀ ତଲେ କା଼ଲେଏ ଡ଼ୟାଲି ତାକି ଏ଼ୱାସି ମିଙ୍ଗେ ଅ଼ଡ଼େ ର଼ ସା଼ୟେମି କିନାଣାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ଇଚିହିଁ ଏ଼ ସାତା ଜୀୱୁତି ହିୟାନେସି । ଦାର୍‌ତି ଏ଼ଦାଣି ଆବାଲି ଆ଼ଡେଏ, ଇଚିହିଁ ଦାର୍‌ତି ଏ଼ଦାଣି ମେସା ହିଲେଏ କି ପୁଞ୍ଜା ହିଲେଏ; ମୀରୁ ଏ଼ଦାଣି ପୁଞ୍ଜାମାଞ୍ଜେରି, ଇଚିହିଁ ଏ଼ଦି ମୀ ତଲେ ମାନେ, ଅ଼ଡ଼େ ଏ଼ଦି ମୀ ହିୟାଁତା ଡ଼ୟିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ନା଼ନୁ ମିଙ୍ଗେ କାର୍ମା କିହା ହାଜଅଁ, ନା଼ନୁ ମୀ ତା଼ଣା ୱେଣ୍ତା ୱା଼ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଗା଼ଡ଼େକା ଜେ଼ଚ ଦାର୍‌ତି ଅ଼ଡ଼େ ନାଙ୍ଗେ ମେସାଲି ଆ଼ଡେଏ; ସାମା ମୀରୁ ନାଙ୍ଗେ ମେସ୍ତାଦେରି, ଇଚିହିଁ ନା଼ନୁ ନୀଡାମାଇଁ, ଅ଼ଡ଼େ ମୀରୁ ଜିକେଏ ନୀଡାନା ଡ଼ୟିଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ନା଼ନୁ ନା଼ ଆ଼ବା ତା଼ଣା ଅ଼ଡ଼େ ମୀରୁ ନା଼ ତା଼ଣା ଅ଼ଡ଼େ ନା଼ନୁ ମୀ ତା଼ଣା ଡ଼ୟିଇଁ, ଈଦାଆଁ ଏ଼ ଦିନା ମୀରୁ ପୁଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଆମ୍ବାଆସି ନା଼ ହୁକୁମି ଆବାହାଁ ମା଼ନୱି ଆ଼ନେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ଜୀୱୁ ନୟାଁନେସି, ଅ଼ଡ଼େ ଆମ୍ବାଆସି ନାଙ୍ଗେ ଜୀୱୁ ନୟାଁନେସି, ନା଼ ଆ଼ବା ଏ଼ୱାଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ଜୀୱୁ ନ଼ଇଁ ଅ଼ଡ଼େ ଏ଼ୱାଣି ତା଼ଣା ତ଼ସାକଡିଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଜୀହୁଦା ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ, ଏ଼ନାଆଁ ଆ଼ତେ, ନୀନୁ ଦାର୍‌ତିତା ନିଙ୍ଗେ ତ଼ସା କଡାଆନା ମା଼ ତା଼ଣା ତ଼ସିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନାଙ୍ଗେ ଜୀୱୁ ନୟାଁନେସି ଆତିହିଁ ଏ଼ୱାସି ନା଼ ବ଼ଲୁତି ମା଼ନୱି ଆ଼ନେସି, ଅ଼ଡ଼େ ନା଼ ଆ଼ବା ଏ଼ୱାଣାଇଁ ଜୀୱୁ ନ଼ନେସି, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ଏ଼ୱାଣିତଲେ ବାସା କିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଆମ୍ବାଆସି ନାଙ୍ଗେ ଜୀୱୁ ନୟଁଅସି, ଏ଼ୱାସି ନା଼ ବ଼ଲୁତି ମା଼ନୱି ଆ଼ଅସି, ଅ଼ଡ଼େ ମୀରୁ ଏମିନି ବ଼ଲୁ ୱେଞ୍ଜାମାଞ୍ଜେରି, ଏ଼ଦି ନା଼ଦି ଆ଼ଏ, ସାମା ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନି ଆ଼ବା ମାହାପୂରୁୱାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ନା଼ନୁ ମୀ ତା଼ଣା ମାଞ୍ଜା ମାଞ୍ଜାନା ମିଙ୍ଗେ ଈ କାତା ୱେସ୍ତାତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ସାମା ଏ଼ ସା଼ୟେମି କିନାୟି, ଇଚିହିଁ ଏମିନି ସୁଦୁଜୀୱୁ ଆ଼ବା ନା଼ ଦ଼ରୁଟି ହିୟାନେସି, ଏ଼ଦି ମିଙ୍ଗେ ବାରେ ଜା଼ପ୍‌ହାନେ, ଅ଼ଡ଼େ ନା଼ନୁ ମିଙ୍ଗେ ଏ଼ନା ଏ଼ନାଆଁ ୱେସାମାଞ୍ଜାଇଁ, ଏ଼ ବାରେ ମିଙ୍ଗେ ଅଣ୍‌ପି କିୟାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ନା଼ନୁ ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ହୀହାନା ହାଜିମାଇଁ, ନା଼ ହିତ୍‌ଡ଼ି ମିଙ୍ଗେ ଦା଼ନା କିହିମାଞ୍ଜାଇଁ; ଦାର୍‌ତି ଏ଼ନିକିଁ ଦା଼ନା କିନେ ନା଼ନୁ ମିଙ୍ଗେ ଏଲେକିଁ ଦା଼ନା କିହିହିଲଅଁ, ମୀ ହିୟାଁ କିଲିବିଲି ଅ଼ଡ଼େ ଆଜି ଗାଟାୟି ଆ଼ଆପେ । ");
INSERT INTO kxv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ନା଼ନୁ ହାଜିମାଇଁ ଅ଼ଡ଼େ ମୀ ତା଼ଣା ୱେଣ୍ତା ୱା଼ଇଁ, ଈ ନା଼ କାତା ୱେଞ୍ଜାମାଞ୍ଜେରି । ମୀରୁ ନାଙ୍ଗେ ଜୀୱୁ ନୟାତିହିଁମା, ନା଼ନୁ ନା଼ ଆ଼ବା ତା଼ଣା ହାଜିମାଇଁ ଇଞ୍ଜିଁ ରା଼ହାଁ କିତେରିମା, ଇଚିହିଁ ଆ଼ବା ନା଼ କିହାଁ କାଜାସି । ");
INSERT INTO kxv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଏ଼ନାୟି ବାରେ ଗଟୱି ଆ଼ନାୟି ମାନେ, ଏ଼ ନ଼କେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସ୍ତାତେଏଁ । ଏ଼ ବାରେ ଗଟୱି ଆ଼ତିସାରେ ମୀରୁ ନାଙ୍ଗେ ନାମାଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ନା଼ନୁ ମୀ ତଲେ ହା଼ରେକା କାତା ଆୟଅଁ, ଇଚିହିଁ ଦାର୍‌ତିତି ସା଼ଲୱି କିନାୟି ୱା଼ହିମାନେ; ଅ଼ଡ଼େ ନା଼ ତା଼ଣା ତାନିୱାୟି ଏ଼ନାୟି ହିଲେଏ; ");
INSERT INTO kxv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ସାମା ଆ଼ବା ନାଙ୍ଗେ ଏ଼ନିକିଁ ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି, ଏଲେକିହିଁ ନା଼ନୁ କାମା କିଇଁ । ଆତିହିଁ ନା଼ନୁ ଆ଼ବାଇଁ ଜୀୱୁ ନ଼ହିଁମାଇଁ ଇଞ୍ଜିଁ ଦାର୍‌ତି ପୁନେ ।” “ୱା଼ଦୁ ମା଼ର, ଇମ୍ବାଟି ହାନ ।” ");
INSERT INTO kxv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ନା଼ନୁ ସାତା ଅଙ୍ଗୁରି ମା଼ଡ଼ା, ଅ଼ଡ଼େ ନା଼ ଆ଼ବା କାମାକିନାସି । ");
INSERT INTO kxv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ନା଼ ତା଼ଣା ମାନି ଏମିନି କମା ପା଼ଡ଼େୟି ଆ଼ୟେଏ, ଏ଼ଦାନି ଏ଼ୱାସି ଟୂଣ୍‌ହାତୁହ୍‌ନେସି; ଅ଼ଡ଼େ ଏମିନି କମା ପା଼ଡ଼େୟି ଆ଼ୟିନେ, ଗାଡି ପା଼ଡ଼େୟି ଆ଼ୟାଲି ତାକି ଜାତ୍‌ନୁ କିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ନା଼ନୁ ମିଙ୍ଗେ ଏମିନି ବ଼ଲୁ ୱେସାମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁତାକି ଜାତ୍‌ନୁ ଆ଼ହାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ନା଼ ତା଼ଣା ଡ଼ୟାଦୁ ଆତିହିଁ ନା଼ନୁ ମୀ ତା଼ଣା ଡ଼ୟିଇଁ । କମା ଏ଼ନିକିଁ ଅଙ୍ଗୁରି ମା଼ଡ଼ାତା ଡ଼ୟାଆସାରେ ତାନିତା଼ଣାଟି ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡେଏ, ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ନା଼ ତା଼ଣା ଡ଼ୟାଆସାରେ ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ନା଼ନୁ ଅଙ୍ଗୁରି ମା଼ଡ଼ା ମୀରୁ କମାୟାଁ, ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ଡ଼ୟିନେସି ଅ଼ଡ଼େ ନା଼ନୁ ଆମ୍ବାଆରି ତା଼ଣା ଡ଼ୟିଇଁ, ଏ଼ୱାସି ହା଼ରେକା ପା଼ଡ଼େୟି ଆ଼ୟିନେସି; ଇଚିହିଁ ନା଼ ପିସ୍‌ପେ ମୀରୁ ଏ଼ନାଆଁ କିହାଲି ଆ଼ଡଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ଡ଼ୟଅସି, ଆତିହିଁ ଏ଼ୱାସି କମା ଲେହେଁ ପାଙ୍ଗାତା ମେତ୍‌ପି ଆ଼ନେସି ଅ଼ଡ଼େ ୱା଼ୟା ହାନେସି, ଇଞ୍ଜାଁ ଲ଼କୁ ଏ଼ୱାଆଁ କୂଡ଼ି କିହାନା ହିଚୁତା ମେତ୍‌ନେରି ଅ଼ଡ଼େ ଏ଼ୱି ବାରେ ୱେହାହାନୁ । ");
INSERT INTO kxv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ମୀରୁ ନା଼ ତା଼ଣା ଡ଼ୟିଦେରି, ଅ଼ଡ଼େ ନା଼ ବ଼ଲୁ ମୀ ତା଼ଣା ଡ଼ୟିନେ, ଆତିହିଁ ମୀରୁ ଏ଼ନାଆଁ ମ଼ନ କିଦେରି, ଏ଼ଦାଆଁ ରୀହ୍‌ଦୁ, ଆତିହିଁ ଏ଼ଦି ମିଙ୍ଗେତାକି କିୱିଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ମୀରୁ ହା଼ରେକା ପା଼ଡ଼େୟି ଆ଼ୟିସାରେ ନା଼ ଆ଼ବା ଗାୱୁରମି ଆ଼ନେସି, ଅ଼ଡ଼େ ମୀରୁ ନା଼ ସାତା ସୀସୁ ଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଏ଼ନିକିଁ ଆ଼ବା ନାଙ୍ଗେ ଜୀୱୁ ନ଼ହାଁମାଞ୍ଜାନେସି, ନା଼ନୁ ଜିକେଏ ଏଲେକିହିଁଏ ମିଙ୍ଗେ ଜୀୱୁନ଼ହାଁମାଞ୍ଜାଇଁ; ନା଼ ଜୀୱୁ ନ଼ୱୁତା ତୀରିଆ଼ହାନା ଡ଼ୟାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ନା଼ନୁ ଏ଼ନିକିଁ ନା଼ ଆ଼ବାତି ହୁକୁମି ମା଼ନୱି ଆ଼ହାନା ତାନି ଜୀୱୁ ନ଼ୱୁତା ତୀରିଆ଼ହାନା ଡ଼ୟିମାଇଁ, ଏଲେକିହିଁଏ ମୀରୁ ଜିକେଏ ନା଼ କାତା ମା଼ନୱି ଆ଼ଦେରି, ଆତିହିଁ ନା଼ ଜୀୱୁ ନ଼ୱୁତା ତୀରିଆ଼ହାନା ଡ଼ୟିଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ଏ଼ନିକିଁ ନା଼ ରା଼ହାଁ ମୀ ତା଼ଣା ଡ଼ୟିନେ, ଅ଼ଡ଼େ ମୀ ରା଼ହାଁ ଏ଼ନିକିଁ ପୂରାଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ମିଙ୍ଗେ ୱେସ୍ତାତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ନା଼ନୁ ଏ଼ନିକିଁ ମିଙ୍ଗେ ଜୀୱୁନ଼ହାଁମାଞ୍ଜାଇଁ, ମୀରୁ ଜିକେଏ ଏଲେକିହିଁଏ ରଅତେରି ରଅଣାଇଁ ଜୀୱୁନ଼ଦୁ, ଈଦି ନା଼ ହୁକୁମି । ");
INSERT INTO kxv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ଜାହାରା ତ଼ଣେସିଙ୍ଗା ତାକି ଜୀୱୁହୀନି କିହାଁ ଅ଼ଡ଼େ କାଜା ଜୀୱୁନ଼ନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ନା଼ନୁ ମିଙ୍ଗେ ଆମିନି ହୁକୁମି ହୀହାମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁ ମୀରୁ ମା଼ନୱି ଆ଼ଦେରି ଆତିହିଁ ମୀରୁ ନା଼ ତ଼ଣେସିଙ୍ଗା । ");
INSERT INTO kxv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ନା଼ନୁ ମିଙ୍ଗେ ଅ଼ଡ଼େ ହ଼ଲେଏସି ଇଞ୍ଜିଁ ମାଞ୍ଜଅଁ, ଇଚିହିଁ ସା଼ୱୁକାରି ଏ଼ନାଆଁ କିନେସି, ହ଼ଲେଏସି ଏ଼ଦାଆଁ ପୁନଅସି, ସାମା ନା଼ନୁ ମିଙ୍ଗେ ତ଼ଣେ ଇଞ୍ଜିମାଞ୍ଜାଇଁ, ଇଚିହିଁ ନା଼ନୁ ନା଼ ଆ଼ବା ତା଼ଣାଟି ଏ଼ନା ଏ଼ନାଆଁ ୱେଞ୍ଜାମାଇଁ, ଏ଼ ବାରେ ମିଙ୍ଗେ ୱେସାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ମୀରୁ ନାଙ୍ଗେ ଆ଼ଚା ମାଞ୍ଜଅତେରି, ସାମା ନା଼ନୁ ମିଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜାଇଁ, ଅ଼ଡ଼େ ମୀରୁ ଏ଼ନିକିଁ ପା଼ଡ଼େୟି ଆ଼ୟାଲି ଆ଼ଡିଦେରି ଅ଼ଡ଼େ ମୀ ପା଼ଡ଼େୟି ତୀରିଆ଼ହାନା ଡ଼ୟିନେ, ଏ଼ଦାଆଁତାକି ମିଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜାଇଁ । ଏଚେଟିଏ ମୀରୁ ନା଼ ଦ଼ରୁତଲେ ଆ଼ବାଇଁ ଏ଼ନାଆଁ ରୀହ୍‌ଦେରି ଏ଼ୱାସି ମିଙ୍ଗେ ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ମୀରୁ ଏ଼ନିକିଁ ରଅତେରି ରଅଣାଇଁ ଜୀୱୁ ନ଼ଦେରି, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଈ ବାରେ ହୁକୁମି ହୀହିମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ଦାର୍‌ତି ମିଙ୍ଗେ ଅ଼ପେଏ, ଆତିହିଁ ମିଙ୍ଗେ ଅ଼ପାଆ ନ଼କେଏ ନାଙ୍ଗେ ଅ଼ପାମାଞ୍ଜେଏ, ଈଦାଆଁ ପୁଞ୍ଜାମାଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ମୀରୁ ଦାର୍‌ତିତାତେରି ଆ଼ହାମାଚିହିଁମା, ଦାର୍‌ତି ମିଙ୍ଗେ ନା଼ ଲ଼କୁ ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଜୀୱୁ ନ଼ୟାଁତେମା; ମୀରୁ ଦାର୍‌ତିଟି ୱା଼ହା ହିଲଅତେରି, ସାମା ନା଼ନୁ ମିଙ୍ଗେ ଦାର୍‌ତିଟି ଆ଼ଚାମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁତାକି ଦାର୍‌ତି ମିଙ୍ଗେ ଅ଼ପେଏ । ");
INSERT INTO kxv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ହ଼ଲେଏସି ସା଼ୱୁକାରି କିହାଁ କାଜାସି ଆ଼ଏ, ନା଼ନୁ ମିଙ୍ଗେ ଏମିନି ବ଼ଲୁ ୱେସାମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁ ଅଣ୍‌ପାଦୁ । ଏ଼ୱାରି ନାଙ୍ଗେ ସା଼ସ୍ତି ହୀହାମାଞ୍ଜାନେରି, ଆତିହିଁ ମିଙ୍ଗେ ଜିକେଏ ସା଼ସ୍ତି ହିୟାନେରି; ଅ଼ଡ଼େ ଏ଼ୱାରି ନା଼ ବ଼ଲୁତି ମା଼ନୱି ଆ଼ହାମାନେରି, ଆତିହିଁ ମୀ ବ଼ଲୁ ଜିକେଏ ମା଼ନୱି ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ସାମା ଏ଼ୱାରି ନାଙ୍ଗେ ପାଣ୍ତାତାଣାଇଁ ପୁଞ୍ଜାହିଲାଆକି, ନା଼ ଦ଼ରୁ ତାକି ମିଙ୍ଗେ ଈ ବାରେ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ନା଼ନୁ ୱା଼ହାନା ଏ଼ୱାରାଇଁ ୱେହ୍‌ଆତିହିଁ, ଏ଼ୱାରି ପା଼ପୁ ଗାଟାରି ଆ଼ଆତେରିମା; ସାମା ନୀଏଁ ଈ ପା଼ପୁ ତାକି ଏ଼ନି ମିଚି କାତା ୱେସାଲି ଆ଼ଡଅରି ");
INSERT INTO kxv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଆମ୍ବାଆସି ନାଙ୍ଗେ ଅ଼ପଅସି, ଏ଼ୱାସି ନା଼ ଆ଼ବାଇଁ ଜିକେଏ ଅ଼ପଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ନା଼ନୁ ଏ଼ୱାରିତା଼ଣା ଏ଼ନି କାବାଆ଼ନି କାମା କିହାହିଲାଆତିଁ, ଏ଼ୱାରି ପା଼ପୁ ଗାଟାରି ଇଞ୍ଜିଁ ଏଜିକିୱି ଆ଼ଆତେରିମା । ସାମା ନା଼ ବାରେ କାମା ମେସାନା ଜିକେଏ ଏ଼ୱାରି ନାଙ୍ଗେ ଅ଼ଡ଼େ ନା଼ ଆ଼ବାଇଁ ଅ଼ପାହିଲଅରି । ");
INSERT INTO kxv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ସାମା ଏ଼ୱାରି ନାଙ୍ଗେ ଉଜେଏ ଅ଼ପାମାଞ୍ଜଅରି, ମ଼ସା ମେ଼ରାତା ରା଼ସ୍‌କି ଆ଼ହାମାନାୟି ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ ଈଦାଆଁତାକି ଈ ବାରେ ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ଆ଼ବା ତା଼ଣାଟି ନା଼ନୁ ମୀ ତା଼ଣା ଏମିନି ସା଼ୟେମି କିନାଣି ପାଣ୍ତାଇଁ, ଆ଼ବା ତା଼ଣାଟି ୱା଼ନି ଏ଼ ସାତା ଜୀୱୁ ୱା଼ତିହିଁ ନା଼ କାତା ସା଼କି ହିୟାନେ; ");
INSERT INTO kxv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ମୀରୁ ଜିକେଏ ନା଼ କାତାତାକି ସା଼କି ହୀଦେରି, ଇଚିହିଁ ମୂଲୁଟିଏ ମୀରୁ ବାରେ ନା଼ ତଲେ ମାଚେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ମୀ ନାମୁତି ଏ଼ନିକିଁ ପିହ୍‌ଅତେରି, ଈଦାଆଁତାକି ଈ ବାରେ କାତା ୱେସାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ଏ଼ୱାରି ମିଙ୍ଗେ କୁଲମଟି ହ଼ପ୍‌ହାନେରି, ଇଲେତି ଦିନା ୱା଼ହିମାନେ, ଏଚେ଼ତା ଆମ୍ବାଆସି ମିଙ୍ଗେ ପା଼ୟାନେସି, ଏ଼ୱାସି ମାହାପୂରୁ ତାକି ଜହରାତି ପୂଜା କିହିମାଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ଲ଼କୁ ଈ ବାରେ କିୟାନେରି, ଇଚିହିଁ ଏ଼ୱାରି ଆ଼ବା ଆ଼ଆତିଁ ନାଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜଅରି । ");
INSERT INTO kxv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ଈ ବାରେ ଗଟୱି ଆ଼ତିସାରେ, ନା଼ନୁ ମିଙ୍ଗେ ୱେସାମାଞ୍ଜାତେଏଁ ଈ କାତା ମୀରୁ ଏ଼ନିକିଁ ଅଣ୍‌ପିଦେରି, ଈଦାଆଁତାକି ଈ ବାରେ କାତା ମିଙ୍ଗେ ୱେସାମାଞ୍ଜାଇଁ । ନା଼ନୁ ମୀ ତଲେ ମାଚାକି ମୂଲୁଟିଏ ଈ ବାରେ କାତା ମିଙ୍ଗେ ୱେସାମାଞ୍ଜଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ସାମା ନା଼ନୁ ନୀଏଁ ନା଼ ପାଣ୍ତାତାଣା ତା଼ଣା ହାଜିମାଇଁ, ଅ଼ଡ଼େ ମୀରୁ ଆମ୍ବିୟା ହାଜିମାଞ୍ଜି ଇଞ୍ଜିଁ ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆତେରି ନାଙ୍ଗେ ୱେଞ୍ଜି ମାଞ୍ଜଅତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ସାମା ନା଼ନୁ ଈ ବାରେ କାତା ୱେସାମାଞ୍ଜାନାକି ମୀ ହିୟାଁ ହା଼ରେକା ଦୁକୁ ଆ଼ହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ସାମା ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନା଼ନୁ ହାନାୟି ମିଙ୍ଗେତାକି ନେହେଁ, ଇଚିହିଁ ନା଼ନୁ ହାଲାଆସାରେ ଏ଼ ସା଼ୟେମି କିନାୟି ମୀ ତା଼ଣା ୱା଼ଏ, ସାମା ନା଼ନୁ ହାଚିସାରେ ଏ଼ଦାଣି ମୀ ତା଼ଣା ପାଣ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ଏ଼ଦି ୱା଼ହାନା ପା଼ପୁ, ଦାର୍ମୁ ଅ଼ଡ଼େ ମାହାପୂରୁତି ବିଚାରାତି କାତା ଈ ଦାର୍‌ତିତି ଲ଼କୁଣି ୱେହ୍‌ନେ; ");
INSERT INTO kxv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ପା଼ପୁତି କାତା, ଇଚିହିଁ ଏ଼ୱାରି ନା଼ ତା଼ଣା ନାମା ହିଲଅରି; ");
INSERT INTO kxv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଦାର୍ମୁତି କାତା, ଇଚିହିଁ ନା଼ନୁ ଆ଼ବା ତା଼ଣା ହାଜିମାଇଁ ମୀରୁ ଅ଼ଡ଼େ ନାଙ୍ଗେ ମେସ୍ତଅତେରି; ");
INSERT INTO kxv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ବିଚାରାତି କାତା, ଇଚିହିଁ ଈ ଦାର୍‌ତି ସା଼ଲୱି କିନାରି ବିଚାରା କିୱି ଆ଼ହାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ମିଙ୍ଗେ ନା଼ନୁ ଅ଼ଡ଼େ ହା଼ରେକା କାତା ୱେସ୍ତାନାୟିମାନେ, ସାମା ନୀଏଁ ମୀରୁ ଏ଼ ବାରେ ଅ଼ର୍‌ହାଲି ଆ଼ଡଅତେରି ");
INSERT INTO kxv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ସାମା ସାତାତି ଜୀୱୁ ୱା଼ତିସାରେ, ଏ଼ଦି ବାରେ ସାତାତି ତେଲ୍‌ହାଲି ବା଼ଡ଼୍‌ୟୁ ହିୟାନେ, ଏ଼ଦି ମିଙ୍ଗେ ଜିରୁ ତ଼ସାନା ତାନିତା଼ଣାଟି ଏ଼ନାଆଁ ୱେହ୍‌ଏ, ମାହାପୂରୁ ତା଼ଣାଟି ଏ଼ନା ଏ଼ନାଆଁ ୱେଞ୍ଜାମାନେ ୱାର୍‌ଇ ଏଚେକେଏ ୱେହ୍‌ନେ, ଅ଼ଡ଼େ ଏ଼ନାୟି ଆ଼ହାଲି ହାଜିମାନେ ଏ଼ଦାଆଁ ଏ଼ଦି ୱେସ୍ତାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ଏ଼ୱାସି ନାଙ୍ଗେ ଗାୱୁରମି କିୟାନେସି, ଇଚିହିଁ ନା଼ ତା଼ଣାଟି ବାରେ କାତା ପୁଞ୍ଜାନା ଏ଼ଦି ଏ଼ଦାଆଁ ମୀ ତା଼ଣା ୱେସ୍ତାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଏ଼ନା ଏ଼ନାୟି ଆ଼ବାୱାୟି, ଏ଼ ବାରେ ନା଼ଦି; ଈଦାଆଁତାକି ନା଼ନୁ ଏଲେଇଞ୍ଜାତେଏଁ, ଏ଼ୱାସି ନା଼ କାତା ଅ଼ହାନା ମିଙ୍ଗେ ୱେସ୍ତାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ଗା଼ଡ଼େକା ଜେ଼ଚ ମୀରୁ ଅ଼ଡ଼େ ନାଙ୍ଗେ ମେସ୍ତଅତେରି, ସାମା ଏଚରଦିନା ଜେ଼ଚ ମେସ୍ତାଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ଏଚେଟିଏ ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ଆମ୍ବା ଆମ୍ବାଆରି ଏଲେଇଚେରି, “ଗା଼ଡ଼େକା ଜେ଼ଚ ନାଙ୍ଗେ ମେସ୍ତଅତେରି, ଅ଼ଡ଼େ ଏଚରଦିନା ହାଚି ଡା଼ୟୁ ନାଙ୍ଗେ ମେସ୍ତାଦେରି, ନା଼ନୁ ଆ଼ବା ତା଼ଣା ହାଜିମାଇଁ, ଏ଼ୱାସି ଏମିନି କାତା ମାଙ୍ଗେ ୱେସ୍ତାତେସି, ଈଦି ଏ଼ନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ଏ଼ୱାରି ଏଲେଇଚେରି, “ଗା଼ଡ଼େକା ଇଞ୍ଜିଁ ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜି ମାନେସି ? ଏ଼ୱାସି ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜି ମାନେସି ମା଼ମ୍ବୁ ତେଲ୍‌ହାଲି ଆ଼ଡିହିଲଅମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ସୀସୁୟାଁ ତାଙ୍ଗ ୱେଞ୍ଜାଲି ଅଣ୍‌ପିମାନେରି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଗା଼ଡ଼େକା ଜେ଼ଚ ନାଙ୍ଗେ ମେସ୍ତଅତେରି, ଅ଼ଡ଼େ ଏଚରଦିନା ହାଚି ଡା଼ୟୁ ନାଙ୍ଗେ ମେସ୍ତାଦେରି, ନା଼ନୁ ଈ ଏମିନି କାତା ମିଙ୍ଗେ ୱେସ୍ତାତେଏଁ, ଏ଼ କାତାତାକି ଏ଼ନାଆଁତାକି ମୀରୁ ବା଼ଦିବା଼ଦା ଆ଼ହିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଦୁକୁଆ଼ହିଁ ଡ଼ୀଦେରି, ସାମା ଦାର୍‌ତି ରା଼ହାଁ କିନେ; ମୀରୁ ଦୁକୁ ଆ଼ଦେରି, ସାମା ମୀ ଦୁକୁ ରା଼ହାଁତା ତିରି ମୀଣ୍‌ନେ । ");
INSERT INTO kxv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ଜାର୍ନିକିନି ବେ଼ଲା ୱା଼ତିସାରେ ଇୟା ଦୁକୁ ବେଟାଆ଼ନେ; ସାମା ଏ଼ଦି କକାଣାଇଁ ଜାର୍ନି କିତି ଡା଼ୟୁ ଦାର୍‌ତିତା ର଼ ମାଣ୍‌ସି ଜାର୍ନା ଆ଼ହାମାନେସି, ଈ ରା଼ହାଁତାକି କସ୍ତତି ଅଣ୍‌ପେଏଦେଁ । ");
INSERT INTO kxv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ଏଲେକିହିଁଏ ମୀରୁ ନୀଏଁ ଦୁକୁ ବେଟାଆ଼ହିମାଞ୍ଜେରି, ସାମା ନା଼ନୁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ମିଙ୍ଗେ ତ଼ଞ୍ଜା ଆୟାଇଁ, ଅ଼ଡ଼େ ମୀ ହିୟାଁ ରା଼ହାଁ ଆ଼ନେ ଅ଼ଡ଼େ ଆମ୍ବାଆସି ମୀ ତା଼ଣାଟି ମୀ ରା଼ହାଁ ମୀଞ୍ଜା ଅୟଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ଏ଼ ଦିନା ମୀରୁ ନାଙ୍ଗେ ଏ଼ନାଆଁ ୱେଞ୍ଜଅତେରି । ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଆ଼ବାଇଁ ଏ଼ନାଆଁ ରୀହ୍‌ଦେରି, ଏ଼ୱାସି ନା଼ ଦ଼ରୁତଲେ ମିଙ୍ଗେ ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ନୀଏଁ ପାତେକା ନା଼ ଦ଼ରୁତଲେ ଏ଼ନାଆଁ ରୀସା ହିଲଅତେରି; ରୀହ୍‌ଦୁ, ଏ଼ନିକିଁ ମୀ ରା଼ହାଁ ଗାଡି ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ମୀରୁ ଏ଼ଦାଆଁ ବେଟାଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ନା଼ନୁ ମିଙ୍ଗେ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ଈ ବାରେ ୱେସାମାଞ୍ଜାଇଁ; ଦିନା ୱା଼ହିମାନେ, ଏଚିବେ଼ଲା ନା଼ନୁ ଅ଼ଡ଼େ ପୁଣ୍‌ମ୍ବିକିନି କାତାତଲେ ମିଙ୍ଗେ ୱେସ୍ତଅଁ, ଆ଼ବାତି କାତା ତୀରେତଲେ ୱେସ୍ତାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ଏ଼ ଦିନା ମୀରୁ ନା଼ ଦ଼ରୁତଲେ ରୀହ୍‌ଦେରି; ଅ଼ଡ଼େ ନା଼ନୁ ମୀ ୱାକିଟି ଆ଼ବାଇଁ ବାତିମା଼ଲିଇଁ, ଈ କାତା ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜଅଁ; ");
INSERT INTO kxv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଇଚିହିଁ ଆ଼ବା ତା଼ନୁଏ ମିଙ୍ଗେ ଜୀୱୁ ନ଼ହାଁମାଞ୍ଜାନେସି, ମୀରୁ ନାଙ୍ଗେ ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାଦେରି ଅ଼ଡ଼େ ନା଼ନୁ ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାଇଁ, ଏ଼ଦାଆଁ ମୀରୁ ନାମାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ନା଼ନୁ ଆ଼ବା ତା଼ଣାଟି ଦାର୍‌ତିତା ୱା଼ହାମାଇଁ; ଦାର୍‌ତି ପିସାନା ୱେଣ୍ତେ ଆ଼ବା ତା଼ଣା ହାଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଈ ହା଼ଡା ୱେଞ୍ଜାନା ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ନୀଏଁ ନୀନୁ ପୁଣ୍‌ମ୍ବିକିନି କାତା ଲେ଼ମ୍ବାଆନା ତୀରେତଲେ ୱେସିମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ନୀନୁ ବାରେ କାତା ପୁଞ୍ଜାମାଞ୍ଜି, ଆମ୍ବାଆସି ନିଙ୍ଗେ ୱେଞ୍ଜାନାୟି ଲ଼ଡ଼ା ହିଲେଏ, ଏ଼ଦାଆଁ ନୀଏଁ ମା଼ମ୍ବୁ ପୁଚମି; ମାହାପୂରୁ ତା଼ଣାଟି ୱା଼ହାମାଞ୍ଜି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ଈ କାତା ନାମି ମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ନାଆଁ ନୀଏଁ ନାମିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ମେହ୍‌ଦୁ ଦିନା ୱା଼ହିମାନେ, ଏ଼ ବେ଼ଲା ୱା଼ତେୟିଏ, ଏଚିବେ଼ଲା ମୀରୁ ଇତାଲା ଆତାଲା ଆ଼ହାନା ବାରେଜା଼ଣା ଜାହାରା ଇଜ ହାଜେରି, ଅ଼ଡ଼େ ନାଙ୍ଗେ ରଅତେଏଁ କିୟାଦେରି; ଆ଼ତିଜିକେଏ ନା଼ନୁ ରଅତେଏଁ ଆ଼ଏ, ଇଚିହିଁ ଆ଼ବା ନା଼ ତଲେ ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ମୀରୁ ଏ଼ନିକିଁ ନା଼ ତା଼ଣାଟି ହିତ୍‌ଡ଼ି ବେଟାଆ଼ଦେରି, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ଈ ବାରେ କାତା ୱେସାମାଞ୍ଜାଇଁ । ଦାର୍‌ତିତା ମିଙ୍ଗେତାକି ହା଼ରେକା ସା଼ସ୍ତି ମାନେ, ସାମା ସା଼ସା ଆହ୍‌ଦୁ; ଇଚିହିଁ ନା଼ନୁ ଦାର୍‌ତିତି ଜୀଣା ଆ଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜୀସୁ ଈ ବାରେ କାତା ଏଲେଇଞ୍ଜାଁ ଲାକପୂରୁ ୱାକି ସିନିକିହାନା ଏଲେଇଚେସି, “ଆ଼ବା, ବେ଼ଲା ଆ଼ତେୟିଏ; ନୀ ମୀର୍‌ଏଣାଇଁ ଗାୱୁରମି କିମୁ, ଏ଼ନିକିଁ ମୀର୍‌ଏସି ନିଙ୍ଗେ ଗାୱୁରମି କିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ନୀନୁ ଏ଼ୱାଣାଇଁ ବାରେ ମାଣ୍‌ସି କୂଡ଼ାତି ମୁହେଁ ଅଦିକାରା ହୀହାମାଞ୍ଜି । ଅ଼ଡ଼େ ଆମ୍ବାଆରାଇଁ ଏ଼ୱାଣି କେୟୁତା କା଼ଲାକା଼ଲାତି ଜୀୱୁ ହୀହାଲିତାକି ହେର୍‌ପାମାଞ୍ଜି ଏ଼ୱାଣାକି ବା଼ଡ଼୍‌ୟୁ ହୀହାମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଅ଼ଡ଼େ ରଣ୍ତିଏ ସାତା ମାହାପୂରୁତି ନୀନୁ, ନିଙ୍ଗେ ଅ଼ଡ଼େ ନୀ ତା଼ଣାଟି ପାଣ୍ତ୍‌ୱିଆ଼ହାମାନି ଜୀସୁ କ୍ରୀସ୍ତଇଁ ପୁନାୟି ଆ଼ହିମାନେ କା଼ଲାକା଼ଲାତି ଜୀୱୁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ନୀନୁ ନାଙ୍ଗେ ଏମିନି କାମା କିହାଲି ହୀହାମାଞ୍ଜାଦି, ଏ଼ଦାଆଁ ନା଼ନୁ ରା଼ପ୍‌ହାନା ଦାର୍‌ତିତା ନିଙ୍ଗେ ଗାୱୁରମି କିହାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଏ଼ ଆ଼ବା ଦାର୍‌ତି ଗା଼ଡ଼ି ଆ଼ଆ ନ଼କେଏ ନୀ ତଲେ ନା଼ ଏମିନି ଗାୱୁରମି ମାଚେ, ଏମ୍ବାଟି ନୀନୁ ନାଙ୍ଗେ ନୀ ତଲେ ଗାୱୁରମି କିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ନୀନୁ ନାଙ୍ଗେ ଦାର୍‌ତି ବିତ୍ରାଟି ଏମିନି ଲ଼କୁଣି ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାଦି, ନା଼ନୁ ନୀ ଦ଼ରୁ ଏ଼ୱାରି ନ଼କିତା ତ଼ସାମାଇଁ; ଏ଼ୱାରି ନୀ ଲ଼କୁ ମାଚେରି ଅ଼ଡ଼େ ନୀନୁ ଏ଼ୱାରାଇଁ ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାତି, ଏ଼ୱାରି ନୀ ବ଼ଲୁତି ମା଼ନୱି ଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ନୀନୁ ନାଙ୍ଗେ ଏ଼ନା ଏ଼ନାଆଁ ହୀହାମାଞ୍ଜାଦି, ଏ଼ ବାରେ ନୀ ତା଼ଣାଟି ୱା଼ହାମାନେ, ଈଦାଆଁ ନୀଏଁ ଏ଼ୱାରି ପୁଞ୍ଜାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ଇଚିହିଁ ନୀନୁ ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାନି ବ଼ଲୁ ନା଼ନୁ ଏ଼ୱାରାକି ହୀହାମାଇଁ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଆବା ମାନେରି ଇଞ୍ଜାଁ ନା଼ନୁ ନୀ ତା଼ଣାଟି ୱା଼ହାମାଇଁ, ଏ଼ଦାଆଁ ସାତା ତଲେ ପୁଞ୍ଜାମାନେରି, ଅ଼ଡ଼େ ନୀନୁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାଦି ଇଞ୍ଜିଁ ଏ଼ୱାରି ନାମାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ନା଼ନୁ ଏ଼ୱାରି ତାକି ପ୍ରା଼ତାନା କିହିମାଇଁ; ଦାର୍‌ତି ତାକି ପ୍ରା଼ତାନା କିହିହିଲଅଁ, ସାମା ନୀନୁ ନାଙ୍ଗେ ଏମିନି ଗାଟାରାଇଁ ହୀହାମାଞ୍ଜାଦି, ଏ଼ୱାରି ତାକି ପ୍ରା଼ତାନା କିହିମାଇଁ, ଇଚିହିଁ ଏ଼ୱାରି ନୀ ଲ଼କୁ; ");
INSERT INTO kxv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଏ଼ନା ଏ଼ନାୟି ନା଼ଦି ମାନେ ଏ଼ ବାରେ ନୀଦି, ଅ଼ଡ଼େ ଏ଼ନା ଏ଼ନାୟି ନୀଦି ମାନେ, ଏ଼ ବାରେ ନା଼ଦି ଅ଼ଡ଼େ ଏ଼ୱାରି ତା଼ଣାଟି ନା଼ନୁ ଗାୱୁରମି ଆ଼ହିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ନା଼ନୁ ଅ଼ଡ଼େ ଈ ଦାର୍‌ତିତା ଡ଼ୟିହିଲଅଁ, ସାମା ଈୱାରି ଦାର୍‌ତିତା ଡ଼ୟିମାନେରି, ଇଞ୍ଜାଁ ନା଼ନୁ ନୀ ତା଼ଣା ୱା଼ହିମାଇଁ; ସୁଦୁଗାଟି ଆ଼ବା ଆମିନି ଗାଟାରାଇଁ ନୀ ଦ଼ରୁତି ବା଼ଡ଼୍‌ୟୁ ତଲେ ନାଙ୍ଗେ ହେର୍‌ପା ମାଞ୍ଜାଦି ଏ଼ୱାରାଇଁ ଗେଲ୍‌ପାମୁ, ନୀନୁ ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ନିକିଁ ରଣ୍ତିଏ ଆ଼ହାମାନାୟି ଏଲେକିହିଁଏ ଏ଼ୱାରାଇଁ ଜିକେଏ ରଣ୍ତିଏ କିହାଲି ସା଼ୟେମି କିମୁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ଏ଼ୱାରିତଲେ ମାଚିବେ଼ଲାତା ନା଼ନୁ ଏ଼ୱାରାଇଁ ନୀ ଦ଼ରୁତଲେ ଗେଲ୍‌ପାମାଇଁ, ଆମିନି ଦ଼ରୁ ନୀନୁ ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାଦି, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାରାଇଁ ଜାଗ୍ରାତା ତଲେ ଗେଲ୍‌ପାମାଇଁ, ଦାର୍ମୁ ପତି ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ନା଼ସା ଆ଼ନାୟି ମାଚି ଜିକେଏ, ରଅସି ଜିକେଏ ନା଼ସା ଆ଼ହାହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ସାମା ନୀଏଁ ନା଼ନୁ ନୀ ତା଼ଣା ୱା଼ହିମାଇଁ, ଅ଼ଡ଼େ ଦାର୍‌ତିତା ମାଞ୍ଜା ମାଞ୍ଜାନା ନା଼ ରା଼ହାଁତା ଏ଼ୱାରି ହିୟାଁ ଏ଼ନିକିଁ ରା଼ହାଁ ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଈ ବାରେ କାତା ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ନା଼ନୁ ଏ଼ୱାରାକି ନୀ ବ଼ଲୁ ହୀହାମାଇଁ, ଏ଼ଦାଆଁତାକି ଦାର୍‌ତି ଏ଼ୱାରାଇଁ ଅ଼ପିହିଲେଏ, ନା଼ନୁ ଏ଼ନିକିଁ ଦାର୍‌ତିଟି ୱା଼ହାହିଲଅଁ ଏ଼ୱାରି ଜିକେଏ ଈ ଦାର୍‌ତିତାରି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ନୀନୁ ଏ଼ୱାରାଇଁ ଈ ଦାର୍‌ତିଟି ଅ଼ହିଁ ହାଲାମୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲି ମାଞ୍ଜଅଁ, ସାମା ଏ଼ୱାରାଇଁ ଲାଗେଏତି ପା଼ନ୍ଦାଟି ଗେଲ୍‌ପାମୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ନା଼ନୁ ଏ଼ନିକିଁ ଦାର୍‌ତିଟି ୱା଼ହାହିଲଅଁ, ଏ଼ୱାରି ଏଲେକିଁ ଦାର୍‌ତିଟି ୱା଼ହାହିଲଅରି । ");
INSERT INTO kxv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ସାତା ତଲେ ଏ଼ୱାରାଇଁ ସୁଦୁ କିମୁ, ଇଚିହିଁ ନୀ ବ଼ଲୁଏ ସାତା । ");
INSERT INTO kxv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ନୀନୁ ଏ଼ନିକିଁ ନାଙ୍ଗେ ଦାର୍‌ତିତା ପାଣ୍ତାମାଞ୍ଜାଦି, ନା଼ନୁ ଜିକେଏ ଏ଼ୱାରାଇଁ ଦାର୍‌ତିତା ପାଣ୍ତାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜିକେଏ ଏ଼ନିକିଁ ସାତା ତଲେ ସୁଦୁ ଆ଼ନେରି, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାରି ତାକି ନାଙ୍ଗେ ସୁଦୁ କିହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ନା଼ନୁ ୱାର୍‌ଇ ଏ଼ୱାରି ତାକି ପ୍ରା଼ତାନା କିହିହିଲଅଁ, ଏ଼ୱାରି ବ଼ଲୁ ୱେଞ୍ଜାନା ଆମ୍ବାଆସି ନା଼ ତା଼ଣା ନାମିନେସି, ଏ଼ୱାରି ତାକି ଜିକେଏ ପ୍ରା଼ତାନା କିହିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ଏ଼ନିକିଁ ଏ଼ୱାରି ବାରେ ରଣ୍ତିଏ ଆ଼ନେରି; ଏ଼, ଆ଼ବା ନୀନୁ ଏ଼ନିକିଁ ନା଼ ତା଼ଣା ମାଞ୍ଜି ଅ଼ଡ଼େ ନା଼ନୁ ନୀ ତା଼ଣା ମାଇଁ, ଏ଼ୱାରି ଜିକେଏ ଏଲେକିହିଁଏ ମା଼ ତା଼ଣା ଡ଼ୟାପେରି, ଏ଼ନିକିଁ ନୀନୁ ନାଙ୍ଗେ ପାଣ୍ତାତି ଇଞ୍ଜିଁ ଦାର୍‌ତି ନାମିନେ । ");
INSERT INTO kxv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଅ଼ଡ଼େ ନୀନୁ ନାଙ୍ଗେ ଏମିନି ଗାୱୁରମି ହୀହାମାଞ୍ଜାଦି, ନା଼ନୁ ଏ଼ଦାଆଁ ଏ଼ୱାରାକି ହୀହାମାଇଁ, ମା଼ର ଏ଼ନିକିଁ ରଣ୍ତିଏ ଏ଼ୱାରି ଏଲେକିଁ ରଣ୍ତିଏ ଆ଼ନେରି; ");
INSERT INTO kxv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ନୀନୁ ଏ଼ନିକିଁ ନା଼ ତା଼ଣା ନା଼ନୁ ଏଲେକିହିଁ ଏ଼ୱାରିତା଼ଣା ଡ଼ୟିଇଁ । ଏ଼ନିକିଁ ଏ଼ୱାରି ମା଼ନି ତଲେ ରଣ୍ତିଏ ଆ଼ନେରି, ଇଞ୍ଜାଁ ଦାର୍‌ତି ପୁନେ କି ନୀନୁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାଦି, ନାଙ୍ଗେ ଏ଼ନିକିଁ ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜାଦି ଏ଼ୱାରାଇଁ ଜିକେଏ ଏଲେକିହିଁଏ ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଏ଼ ଆ଼ବା ! ନୀନୁ ଏ଼ୱାରାଇଁ ନା଼ କେୟୁତା ହୀହାମାଞ୍ଜାଦି । ନା଼ନୁ ଆମ୍ବିୟା ଡ଼ୟିଇଁ, ଏ଼ୱାରି ଜିକେଏ ଏ଼ନିକିଁ ଏମ୍ବାଆଁ ଡ଼ୟିନେରି ଅ଼ଡ଼େ ଦାର୍‌ତି ଗା଼ଡ଼ି ଆ଼ଆ ନ଼କେଏ ନୀନୁ ନାଙ୍ଗେ ଜୀୱୁ ନ଼ହାଁମାଞ୍ଜାନାକି ନାଙ୍ଗେ ଏମିନି ଗାୱୁରମି ହୀହାମାଞ୍ଜାଦି, ନା଼ ଏ଼ ଗାୱୁରମି ଏ଼ନିକିଁ ଏ଼ୱାରି ମେସାଲି ଆ଼ଡିନେରି ଈଦି ନା଼ ଅଣ୍‌ପୁ । ");
INSERT INTO kxv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ଼ ଦାର୍ମୁଗାଟି ଆ଼ବା, ଦାର୍‌ତି ନିଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜେଏ, ସାମା ନା଼ନୁ ନିଙ୍ଗେ ପୁଞ୍ଜାମାଞ୍ଜାଇଁ; ଅ଼ଡ଼େ ନୀନୁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାଦି, ଏ଼ଦାଆଁ ଈୱାରି ପୁଞ୍ଜାମାଞ୍ଜାନେରି; ");
INSERT INTO kxv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ନୀନୁ ନାଙ୍ଗେ ଏମିନି ଜୀୱୁ ନ଼ୱୁଟି ଜୀୱୁ ନ଼ହାଁମାଞ୍ଜାଦି, ଏ଼ଦି ଏ଼ନିକିଁ ଏ଼ୱାରିତା଼ଣା ଡ଼ୟିନେ ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାରିତା଼ଣା ଡ଼ୟିଇଁ, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାରାଇଁ ୱେସାମାଇଁ ଅ଼ଡ଼େ ୱେହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜୀସୁ ଈ ପ୍ରା଼ତାନା ରା଼ପ୍‌ହି ଡା଼ୟୁ ତାନି ସୀସୁୟାଁ ତଲେ କିଦ୍ରଣ କାଡା ଆତାଲା ହାଚେରି, ଏମ୍ବାଆଁ ର଼ ବା଼ଡ଼ା ମାଚେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ତାନି ସୀସୁୟାଁ ତଲେ ଏମ୍ବାଆଁ ହ଼ଟେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଏମିନି ଜୀହୁଦା ଏ଼ୱାଣାଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିତେସି, ଏ଼ୱାସି ଜିକେଏ ଏ଼ ଟା଼ୟୁତି ପୁଞ୍ଜାମାଚେସି, ଇଚିହିଁ ଜୀସୁ ହା଼ରେକା ପା଼ଲି ସୀସୁୟାଁ ତଲେ ଏ଼ ଟା଼ୟୁତା ହାଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ଏ଼ଦାଆଁତାକି ଜୀହୁଦା ଜାମାନାଙ୍ଗା ଇଞ୍ଜାଁ କାଜା ପୂଜେରା ଅ଼ଡ଼େ ପାରୁସିୟାଁ ତା଼ଣାଟି ମାହାପୂରୁ ଇଲୁତି ଜାମାନାଙ୍ଗା ଲ଼କୁ ଦୀୱଁ, ହିଚୁ ବ଼ନ୍ଦାୟାଁ ଅ଼ଡ଼େ ଟେଙ୍ଗା ବା଼ଲାୟାଁ ଆସାନା ଏମ୍ବାଆଁ ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ଏମ୍ବାଟିଏ ଜୀସୁ ତାଙ୍ଗେତାକି ଏ଼ନା ଏ଼ନାଆଁ ଆ଼ହାଲି ହାଜିମାନେ ଏ଼ ବାରେ ପୁଞ୍ଜାନା, ନ଼କିତା ହାଜାନା ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀରୁ ଆମ୍ବାଆରାଇଁ ପାରିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ଏ଼ୱାରି ଏଲେଇଚେରି, “ନା଼ଜରିତତି ଜୀସୁ ।” ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାତେଏଁ ?” ଏମିନି ଜୀହୁଦା ଏ଼ୱାଣାଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପିତେସି, ଏ଼ୱାସି ଜିକେଏ ଏ଼ୱାରିତଲେ ଏମ୍ବାଆଁ ନିଚାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜୀସୁ ଏଚିବେ଼ଲା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାତେଏଁ” ଏଚିବେ଼ଲା ଏ଼ୱାରି ଡା଼ୟୁୱାକି ଗୁଚା ଆ଼ହାନା ବୂମିତା ତର୍‌ଗା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଜୀସୁ ୱେଣ୍ତେ ୱେଚେସି, “ମୀରୁ ଆମ୍ବାଆରାଇଁ ପାରିମାଞ୍ଜେରି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ନା଼ଜରିତତି ଜୀସୁଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ୱେସାମାଞ୍ଜାଇଁ, ନା଼ନୁ ଏ଼ୱାତେଏଁ । ମୀରୁ ନାଙ୍ଗେ ପାରିମାଞ୍ଜାଦେରି ଇଚିହିଁ ଈୱାରାଇଁ ପିହ୍‌ଦୁ । ");
INSERT INTO kxv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଆମ୍ବାଆରାଇଁ ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାଦି, ଏ଼ୱାରି ବିତ୍ରାଟି ରଅଣାଇଁ ଜିକେଏ ଜା଼କ୍‌ହା ହିଲଅଁ ।” ଏ଼ନିକିଁ ଦାର୍ମୁ ପତିତି କାତା ସାତା ଆ଼ନେ ଏ଼ଦାଆଁତାକି ଏଲେ ଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମନ ପିତର ତାନି ତା଼ଣା କାଣ୍ତା ମାଚାକି ଏ଼ୱାସି କାଜା ପୂଜେରା ହ଼ଲେଏଣା ଟିଃନି କିର୍ୟୁଁ ଦା଼ତେସି, ଏ଼ୱାଣି ଦ଼ରୁ ମାଲ୍‌କସ୍‌ । ");
INSERT INTO kxv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ଏଚେଟିଏ ଜୀସୁ ପିତରଇଁ ଏଲେଇଚେସି, “କାଣ୍ତା, କାଣ୍ତା ଇଟିନି ଟା଼ୟୁତା ଇଟାମୁ; ନୀନୁ ଏ଼ନାଆଁ ଅଣ୍‌ପିମାଞ୍ଜି, ଆ଼ବା ମାହାପୂରୁ ନାଙ୍ଗେ ହୀହାମାଞ୍ଜାନି ଦୁକୁତି ସ଼ଲାତା ଗସାଲି ଆ଼ଡଅଁ କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଏମ୍ବାଟିଏ ରମିୟ କ଼ସ୍‌କା, ଇଞ୍ଜାଁ ରିଜାରି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି, ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁତି କ଼ସ୍‌କା ଜୀସୁଇଁ ଆସାନା ଦସ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଏ଼ୱାଣାଇଁ ଦସ୍‌ପାନା ମୂଲୁଏ ହାନାନ ତା଼ଣା ଅ଼ତେରି, ଇଚିହିଁ ଏ଼ୱାସି ଏ଼ ବାର୍ସାତି କାଜା ପୂଜେରା କୟାପାତି ପତ୍‌ଲେଏସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ଏ଼ କୟାପା ବାରେ ଲ଼କୁ ତାକି ରଅସି ହା଼ନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ ଇଞ୍ଜିଁ ଜୀହୁଦି ଲ଼କୁଣି ୱେସାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମନ ପିତର ଅ଼ଡ଼େ ର଼ ସୀସୁ ଜୀସୁତି ଜେ଼ଚ ଜେ଼ଚ ହାଜିମାଚେରି । ଏ଼ ସୀସୁ କାଜା ପୂଜେରା ତଲେ ପୁଣ୍‌ମ୍ବି ଆ଼ହାମାଚେରି ଅ଼ଡ଼େ ଜୀସୁତଲେ କାଜା ପୂଜେରା ଆଂଗେଣିତା ହାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ସାମା ପିତର ପାଙ୍ଗାତି ଦୁୱେରି ଦାରିତା ନିଚାନା ଡ଼ୟିତେସି । ସାମା ଏମିନି ସୀସୁ କାଜା ପୂଜେରା ତଲେ ପୁଣ୍‌ମ୍ବି ଆ଼ହାମାଚେରି, ଏ଼ୱାସି ପାଙ୍ଗାତା ହାଜାନା ଦୁୱେରିତା କା଼ଃଆନାଣାଇଁ ଏଲେଇଞ୍ଜାନା ପିତରଇଁ ବିତ୍ରା ଅ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ଏମ୍ବାଟିଏ ଦୁୱେରିତା କା଼ଃଆନାଣି ହ଼ଲେଣି ପିତରଇଁ ଏଲେଇଚେ, “ନୀନୁ ଜିକେଏ ଏ଼ନାଆଁ ଈ ଲ଼କୁତି ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅତି ଆ଼ଏକି ?” ପିତର ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାତେଏଁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ଏଚିବେ଼ଲାତା ପେନି ଆ଼ହିମାଚାକି ହ଼ଲିୟାଙ୍ଗା ଅ଼ଡ଼େ କା଼ଃଆନାରି ହିଚୁ ଡାସାନା ସା଼ରିୱାକି ନିଚାନା କେର୍‌ଞ୍ଜି ମାଚେରି; ପିତର ଜିକେଏ ଏ଼ୱାରିତଲେ ନିଚାନା ହିଚୁ କେର୍‌ଞ୍ଜି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","କାଜା ପୂଜେରା ଜୀସୁଇଁ ତାନି ଜା଼ପ୍‌ନାଣି ଇଞ୍ଜାଁ ସୀସୁୟାଁତି କାତା ୱେଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜୀସୁ ଏଲେଇଚେସି, “ନା଼ନୁ ବାରେ ଦାର୍‌ତିତି ନ଼କିତା ତ଼ସାନା ଜା଼ପ୍‌ହାମାଇଁ, ଆମ୍ବିୟା ବାରେ ଜୀହୁଦି ଲ଼କୁ କୂଡ଼ା ଆ଼ନେରି, ମାହାପୂରୁ ଇଲୁତା ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା, ଲ଼କୁ କୂଡ଼ା ଆ଼ହାମାନି ବେ଼ଲାତା ନା଼ନୁ ଜା଼ପ୍‌ହାମାଇଁ, ଡ଼ୁକ୍‌ହାନା ଏ଼ନାଆଁ କିହାହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ନାଙ୍ଗେ ଏ଼ନାଆଁତାକି ୱେଞ୍ଜିମାଞ୍ଜାଦି ? ନା଼ନୁ ଏ଼ୱାରାଇଁ ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜାମାଇଁ, ଆମ୍ବାଆରି ୱେଞ୍ଜାମାନେରି ଏ଼ୱାରାଇଁ ୱେନାମୁ; ନା଼ନୁ ଏ଼ନା ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜାମାଇଁ, ଏ଼ୱାରି ବାରେ ପୁଞ୍ଜାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜୀସୁ ଏଲେ ଇଞ୍ଜିମାନାଣି ୱେଞ୍ଜାନା ଦାରିତା ନିଚାମାଚି ମାହାପୂରୁ ଇଲୁ ଜାମାନାଙ୍ଗା ବିତ୍ରାଟି ରଅସି ଏ଼ୱାଣାଇଁ ସା଼ପ୍‌ଡ଼ା ୱେ଼ଚାନା ଏଲେଇଚେସି, “ନିଙ୍ଗେ ଇଚେକା ସା଼ସା କାଜା ପୂଜେରାଇଁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଲାଗେଏ ଜ଼ଲାମାଚିହିଁ, ଏ଼ ଲାଗେଏତି ପାର୍‌ମାଣା ହିୟାଦୁ; ନେହିଁ ଜ଼ଲାମାଇଁ ଇଚିହିଁ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ୱେ଼ଚିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ଏମ୍ବାଟିଏ ହାନାନ ଜୀସୁଇଁ ଏଲେକିହିଁଏ ଦସ୍‌ପି ଆ଼ହାମାନାଣାଇଁ କାଜା ପୂଜେରା କୟାପା ତା଼ଣା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ସିମନ ପିତର ହିଚୁ ଡାଗେ ନିଚାନା ହିଚୁ କେର୍‌ଞ୍ଜି ମାଚେସି, ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ୱେଚେରି, “ନୀନୁ ଜିକେଏ ଏ଼ୱାଣି ସୀସୁୟାଁ ବିତ୍ରାଟି ରଅତି ଆ଼ଏକି ?” ପିତର ଏଲେଇଚେସି, “ନା଼ନୁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ପିତର, ଏମିନି କାଜା ପୂଜେରା ହ଼ଲିୟାଙ୍ଗା ବିତ୍ରାଟି ରଅଣି କିର୍ୟୁଁ ଦା଼ଚା ମାଚେସି, ଏ଼ୱାଣି କୁଟମିତାସି ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ବା଼ଡ଼ାତା ଏ଼ୱାଣିତଲେ ମାଚାଣି ମେସାମାଞ୍ଜାଆତେଏଁ କି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ପିତର ଅ଼ଡ଼େ ୱେଣ୍ତେ ଏଲେଇଚେସି, “ଆ଼ଏ ପୁଞ୍ଜାହିଲଅଁ ।” ଏଚିବେ଼ଲାତା କୟୁ କେ଼ଣ୍‌ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ତାନି ଅ଼ର ନେ଼ଚୁ ଲା଼ଇ ଏ଼ୱାରି ଜୀସୁଇଁ କୟାପା ଇଲୁଟି ଅ଼ହାନା ରମିୟ ରା଼ଜି ସା଼ଲୱି କିନାଣି ମେ଼ଡ଼ା ଇଲୁତା ଏତେରି, ଜୀହୁଦି ଲ଼କୁ ମେ଼ଡ଼ା ଇଲୁ ବିତ୍ରା ହାଲାଆତେରି, ଇଚିହିଁ ଏ଼ଦାଆଁ ତଲେ ପିସ୍‌ପିଆ଼ତି ପାର୍ବୁତି ବ଼ଜି ତାକି ତାମ୍‌ଙ୍ଗେ ଲାଗେଏ କିହାକଡାଲି ଅଣ୍‌ପି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ଏ଼ଦାଆଁତାକି ସା଼ଲୱି କିନି ପିଲାତ ଏ଼ୱାରିତା଼ଣା ପାଙ୍ଗାତା ୱା଼ହାନା ୱେଚେସି, “ଈ ମାଣ୍‌ସି କ଼ପାଟି ମୀ ଏ଼ନିଲେହେଁତି ଦାୱା ମାନେ ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଈ ମାଣ୍‌ସି ଲାଗେଏତି କାମା କିହା ହିଲାଆତିହିଁମା, ମା଼ମ୍ବୁ ଏ଼ୱାଣାଇଁ ନୀ ତା଼ଣା ତାଆତମିମା ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆତିହିଁ ଈୱାଣାଇଁ ଅ଼ହାନା ମୀ ମେ଼ରା ତଲେ ନୀହାଁୟି କିଦୁ ।” ଜୀହୁଦିୟାଁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଆମ୍ବାଆରାଇଁ ହା଼ନି ଡଣ୍ତ ହୀହାଲି ମା଼ ଅଦିକାରା ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜୀସୁ ଏ଼ନିକିଁ ହା଼ହାଲି ହାଜିମାନେସି, ଏ଼ କାତା ଜୀସୁ ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜାମାଚେସି, ଏ଼ଦି ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତ ୱେଣ୍ତା ମେ଼ଡ଼ା ଇଲୁ ବିତ୍ରା ହାଜାନା ଜୀସୁଇଁ ୱେଚେସି, “ଏ଼ନାଆଁ ନୀନୁ ଜୀହୁଦି ଲ଼କୁତି ରାଜାତି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜୀସୁ ଏଲେଇଚେସି, “ଈ କାତା ନୀ ମ଼ନଟି ୱେଞ୍ଜିମାଞ୍ଜାଦି କି ଏଟ୍‌କାତାରି ନା଼ କାତାତି ନିଙ୍ଗେ ଏ଼ନାଆଁ ଏଲେଇଞ୍ଜା ମାଞ୍ଜାନେରି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ନାଆଁ ଅଣ୍‌ପାମାଞ୍ଜି, ନା଼ନୁ ର଼ ଜୀହୁଦିତେଏଁ ? ନୀ କୂଡ଼ାତି ଲ଼କୁ ଇଞ୍ଜାଁ କାଜା ପୂଜେରାଙ୍ଗା ନିଙ୍ଗେ ତାଚାନା ନା଼ କେୟୁତା ହେର୍‌ପା ମାଞ୍ଜାନେରି । ୱେସ୍ତାମୁ ନୀନୁ ଏ଼ନାଆଁ କିହାମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜୀସୁ ଏଲେଇଚେସି, ନା଼ ରା଼ଜି ଈ ଦାର୍‌ତିତାୟି ଆ଼ଏ; ନା଼ ରା଼ଜି ଦାର୍‌ତିତାୟି ଆ଼ତିହିଁମା, ନା଼ନୁ ଜୀହୁଦି ଲ଼କୁତା଼ଣା ହେର୍‌ପି ଆ଼ଆରେ଼ଟୁ ନାଙ୍ଗେ ସେ଼ବା କିୟାନାରି ନା଼ ତାକି ଜୁଜୁ କିତେରିମା, ସାମା ନା଼ ରା଼ଜି ସାତେଏ ଈ ଦାର୍‌ତିତାୟି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ପିଲାତ ଏ଼ୱାଣାଇଁ ୱେଚେସି, “ଆତିହିଁ ନୀନୁ ଜୀହୁଦି ଲ଼କୁତି ରାଜାତି ?” ଜୀସୁ ଏଲେଇଚେସି, “ନୀନୁ ଏଲେ ଇଞ୍ଜିମାଞ୍ଜି ନା଼ନୁ ର଼ ରାଜାତେଏଁ । ନା଼ନୁ ସାତା ୱାକିଟି ସା଼କି ହୀହାଲି ଜାର୍ନା ଆ଼ହାମାଇଁ ଅ଼ଡ଼େ ଦାର୍‌ତିତା ୱା଼ହାମାଇଁ । ଆମ୍ବାଆସି ସାତାତି ମୀର୍‌ଏସି ଏ଼ୱାସି ନା଼ କାତା ୱେନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ ୱେଚେସି, “ସାତା ଏ଼ନାୟି ?” ପିଲାତ ପାଙ୍ଗାତା ହାଜାନା ଜୀହୁଦି ଲ଼କୁଣି ଏଲେଇଚେସି, “ନା଼ନୁ ଈୱାଣି ତା଼ଣା ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ହି ହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ସାମା ନା଼ନୁ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ବେ଼ଲାତା ମିଙ୍ଗେତାକି କାୟିଦିତା ମାନାରାଇଁ ରଅଣାଇଁ ପିସାଲି ତାକି ମୀ ମେ଼ରା ମାନେ, ଏ଼ଦାଆଁତାକି ଜୀହୁଦି ଲ଼କୁତି ରାଜାଇଁ ମାଙ୍ଗେତାକି ପିସା ହିୟାପେସି ଇଞ୍ଜିଁ ମୀ ମ଼ନ ମାନେକି ?” ");
INSERT INTO kxv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ଏମ୍ବାଟିଏ ଏ଼ୱାରି କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ଈୱାଣାଇଁ ଆ଼ଏ, ସାମା ବାରବାଇଁ ପିସାହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ଡା଼ୟୁ ପିଲାତ ଜୀସୁଇଁ ଅ଼ହାନା ସା଼ଟ୍‌ଣି ମା଼ଡା କିୱି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ଅ଼ଡ଼େ ରିଜାରି କ଼ସ୍‌କା ହା଼ପ୍‌କା ଟ଼ପେରି ଆଲାନା ଜୀସୁ ତା଼ର୍ୟୁଁତା ଇଟିତେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ହେୟାଁ ୱା଼ଣା ହିମ୍ବରି ହୁଚିକିତେରି; ");
INSERT INTO kxv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଏ଼ୱାରି ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହାନା ଏଲେଇଚେରି, “ଏ଼ ଜୀହୁଦିୟାଁ ରାଜା ଜହରା;” ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ସା଼ପ୍‌ଡ଼ା ୱେ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ ୱେଣ୍ତେ ପାଙ୍ଗାତା ହାଜାନା ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ହି ହିଲଅଁ, ଈଦାଆଁ ଏ଼ନିକିଁ ମୀରୁ ପୁଞ୍ଜେରି, ଈଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାଣାଇଁ ମୀ ତା଼ଣା ତା଼ଚିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ଏମ୍ବାଟିଏ ଜୀସୁ ଏ଼ ହା଼ପ୍‌କା ଟ଼ପେରି ଅ଼ଡ଼େ ହେୟାଁ ୱା଼ଣା ହିମ୍ବରି ପର୍‌ହାନା ପାଙ୍ଗାତା ୱା଼ତେସି, ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ଦୁ ଈୱାସି ଏ଼ ମାଣ୍‌ସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ଏମ୍ବାଟିଏ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମାହାପୂରୁ ଇଲୁ କା଼ଃଆନି ଜାମାନାଙ୍ଗା ଏ଼ୱାଣାଇଁ ମେସାନା କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ସି ଏକ୍‌ଦୁ ପା଼ସି ଏକ୍‌ଦୁ ।” ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ଏ଼ୱାଣାଇଁ ଅ଼ହାନା ପା଼ସି ଏକ୍‌ଦୁ, ଇଚିହିଁ ନା଼ନୁ ଏ଼ୱାଣି ତା଼ଣା ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ହି ହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଇଚିହିଁ ମାଙ୍ଗେ ରଣ୍ତିଏ ମେ଼ରା ମାନେ, ଏ଼ ମେ଼ରାଲେହେଁଏ ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ ବେଟାଆ଼ନାୟି ମାନେ, ଇଚିହିଁ ଏ଼ୱାସି ତାଙ୍ଗେ ମାହାପୂରୁତି ମୀର୍‌ଏସି ଇଞ୍ଜିଁ ୱେସାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ଏମ୍ବାଟିଏ ପିଲାତ ଈ କାତା ୱେଞ୍ଜାନା ଗାଡି ଆଜିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ୱେଣ୍ତେ ମେ଼ଡ଼ା ଇଲୁତା ହାଜାନା, ଜୀସୁଇଁ ୱେଚେସି, “ନୀନୁ ଆମ୍ବିଟି ୱା଼ହାମାଞ୍ଜି ?” ସାମା ଜୀସୁ ସାପି ଆ଼ହାନା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ପିଲାତ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ଜ଼ଲିମାଞ୍ଜଅତି ? ନିଙ୍ଗ ଗେଲ୍‌ପାଲି ନା଼ ଅଦିକାରା ମାନେ ଅ଼ଡ଼େ ପା଼ସିତା ଏକ୍‌ହାଲି ନା଼ ଅଦିକାରା ମାନେ ଈ କାତା ନୀନୁ ପୁଞ୍ଜାହିଲଅତି ?” ");
INSERT INTO kxv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜୀସୁ ଏଲେଇଚେସି, “ମାହାପୂରୁ ତା଼ଣାଟି ନିଙ୍ଗେ ଅଦିକାରା ହୀଆତିହିଁ, ନା଼ ଲାକ ନୀ ଏ଼ନି ଅଦିକାରା ହିଲାଆତେମା; ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ନାଙ୍ଗେ ନୀ କେୟୁତା ହେର୍‌ପା ମାଞ୍ଜାନେସି ଏ଼ୱାଣି ପା଼ପୁ ହା଼ରେକା ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ଈ କାତା ୱେଞ୍ଜାନା ପିଲାତ ଜୀସୁଇଁ ପିସାଲି ତାକି ଅଣ୍‌ପିତେସି, ସାମା ଜୀହୁଦି ଲ଼କୁ କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ନୀନୁ ଈୱାଣାଇଁ ପିହ୍‌ଦି ଆତିହିଁ ନୀନୁ କାୟିସରତି ତ଼ଣେତି ଆ଼ଏ; ଆମ୍ବାଆସି ଜାହାରାଇଁ ରାଜା ଇନେସି ଏ଼ୱାସି କାୟିସର କ଼ପାଟି କାତା ଜ଼ଲିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ପିଲାତ ଈ କାତା ୱେଞ୍ଜାନା ଜୀସୁଇଁ ପାଙ୍ଗାତା ୱାଲ୍‌କାତି ବେ଼ରଣିମାଣ୍ତା ତାତେରି । ଏମିନାଣି ଏବ୍ରି ହା଼ଡାତଲେ “ଗବ୍‌ବତା” ଇଞ୍ଜିଁ ଇନେରି, ଏ଼ ଟା଼ୟୁଟି ବିଚାରା କିନି ଟା଼ୟୁତା କୁଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ଏ଼ ଦିନା ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁତି ତଲିତି ଦିନା ମାଚେ, ଏଚିବେ଼ଲା ଲା଼ଇ ସ଼ ଗଂଟା ଆ଼ହାମାଚେ । ଇଞ୍ଜାଁ ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁଣି ଏଲେଇଚେସି, “ଈୱାସି ମେହ୍‌ଦୁ ମୀ ରାଜା ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପା଼ୟାଦୁ, ପା଼ୟାଦୁ, ପା଼ସି ଏକ୍‌ଦୁ ।” ପିଲାତ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମୀ ରାଜାଇଁ ପା଼ସିତା ଏକ୍‌ଇଁ ?” କାଜା ପୂଜେରାଙ୍ଗା ଏଲେଇଚେରି, “କାୟିସର ପିସ୍‌ପେ ମା଼ ରାଜା ଆମ୍ବାଆସି ହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ଡା଼ୟୁ ପିଲାତ ଜୀସୁଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାଲି ତାକି ଏ଼ୱାରି କେୟୁତା ହେର୍‌ପିତେସି, ଇଞ୍ଜାଁ ଡା଼ୟୁ ଏ଼ୱାରି ଜୀସୁଇଁ ଅ଼ହିଁ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ଏଚେଟିଏ ଏ଼ୱାରି ଜୀସୁଇଁ ଅ଼ତେରି; ଅ଼ଡ଼େ ଜୀସୁ ଜାହାରା ପା଼ସିମୁଣ୍ତା ଡେ଼କାନା “ତା଼ର୍ୟୁଁଗିର୍ପା” ଇନି ଟା଼ୟୁତା, ଇଚିହିଁ ଏମିନାଣି ଏବ୍ରି ହା଼ଡାତଲେ “ଗଲ୍‌ଗତା” ଇଞ୍ଜିଁ ଇନେରି ଏମ୍ବାଆଁ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ଏମ୍ବାଆଁ ଏ଼ୱାରି ଜୀସୁଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି, ଏ଼ୱାଣିତଲେ ଅ଼ଡ଼େ ରିଆରାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହେରି, ରିକୱାକି ରିଆରି ଅ଼ଡ଼େ ମାଦିଏ ଜୀସୁ । ");
INSERT INTO kxv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଅ଼ଡ଼େ ପିଲାତ ର଼ ଆ଼କୁତା ରା଼ଚାନା ପା଼ସିମୁଣ୍ତା ଲାକ ଆଟିକିତେସି, ଏମ୍ବାଆଁ ରା଼ସ୍‌କି ଆ଼ହାମାଚେ, “ନା଼ଜରିତତି ଜୀସୁ ଜୀହୁଦିୟାଁ ରାଜା ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜୀହୁଦିୟାଁ ବିତ୍ରାଟି ହା଼ରେକା ଏ଼ ଆ଼କୁତି ପ଼ଡ଼ୱି ଆ଼ତେରି, ଇଚିହିଁ ଜୀସୁଇଁ ଏମିନିତା଼ଣା ପା଼ସି ଏପ୍‌କି ଆ଼ହାମାଚେ, ଏ଼ଦି ଗା଼ଡ଼ା ଡାଗେ ମାଚେ; ଇଞ୍ଜାଁ ଏ଼ ଆ଼କୁ ଏବ୍ରି, ଲାଟିନ୍‌ ଅ଼ଡ଼େ ଗ୍ରିକ୍‌ ହା଼ଡାତଲେ ରା଼ସ୍‌କି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଜୀହୁଦି ଲ଼କୁତି କାଜା ପୂଜେରାଙ୍ଗା ପିଲାତଇଁ ଏଲେଇଚେରି, “ଜୀହୁଦିୟାଁ ରାଜା ଇଞ୍ଜିଁ ରା଼ଚାଆନା, ନା଼ନୁ ଜୀହୁଦି ଲ଼କୁତି ରାଜା ଇଞ୍ଜିମାଚେସି ଇଞ୍ଜିଁ ରା଼ଚାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ସାମା ପିଲାତ ଏଲେଇଚେସି, “ନା଼ନୁ ଏ଼ନାଆଁ ରା଼ଚାମାଇଁ ଏଲେକିହିଁଏ ଡ଼ୟିନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ରିଜାରି କ଼ସ୍‌କା ଜୀସୁଇଁ ପା଼ସିତା ଏକ୍‌ହି ଜେ଼ଚ ଏ଼ୱାଣି ହିମ୍ବରିକା ଅ଼ହାନା ସା଼ରି ବା଼ଗା କିତେରି, ର଼ ର଼ କ଼ହ୍‌ଏଁଣାକି ରଣ୍ତାଲାକା, ଅ଼ଡ଼େ ଏ଼ୱାଣି ଲାମ୍ବା ସକା ଜିକେଏ ଅ଼ତେରି । ଏ଼ ଲାମ୍ବା ସକା ତାଚାନା ହେର୍‌କି ଟିଏ ପାଃଆନା କଡାୟାଁ ପାତେକା କିୱି ଆ଼ହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏଲେଇଚେରି, “ଈଦାଆଁ ଗେହ୍‌ଆପ, ସାମା ଈଦି ଆମ୍ବାଆରାୱାୟି ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ପାଦି କିନ ।” ଏ଼ନିକିଁ ଦାର୍ମୁ ପତିତି କାତା ପୂରା ଆ଼ନେ, “ଏ଼ୱାରି ତାମି ବିତ୍ରା ନା଼ ହିମ୍ବରିକା ବା଼ଗା କିତେରି, ଅ଼ଡ଼େ ନା଼ ଲାମ୍ବା ସକାତାକି ପାଦି କିତେରି ।” ରିଜାରି କ଼ସ୍‌କା ସମାନା ଏଲେକିହିଁଏ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ସାମା ଜୀସୁତି ପା଼ସିମୁଣ୍ତା ଡାଗେ ତାମି ଇୟା, ତାମି ଇୟାନି ତାଙ୍ଗି, କ୍ଲପାତି ଡକ୍ରି ମରିୟମ ଅ଼ଡ଼େ ମଗ୍‌ଦଲିନି ମରିୟମ ନିଚାମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜୀସୁ ତାମି ଇୟା ଅ଼ଡ଼େ ଏମିନି ସୀସୁଇଁ ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଏ଼ୱାସି ଡାଗେ ନିଚାମାନାଣି ମେସାନା ଏଲେଇଚେସି, “ଏ଼ ଇୟା ମେହ୍‌ମୁ ନୀ ମୀର୍‌ଏସି !” ");
INSERT INTO kxv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ଡା଼ୟୁ ଜୀସୁ ଏ଼ ସୀସୁଇଁ ଏଲେଇଚେସି, “ଈଦି ମୀ ଇୟା ।” ଏ଼ ଦିନାଟିଏ ଏ଼ ସୀସୁ ଜୀସୁତି ଇୟାନି ତାମି ଇଜ ଅ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଡା଼ୟୁ ଜୀସୁ ଦାର୍ମୁ ପତିତି ବ଼ଲୁ ଏ଼ନିକିଁ ପୂରା ଆ଼ନେ, ଏ଼ଦାଆଁତାକି ବାରେ ରା଼ହାମାନେ ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଏଲେଇଚେସି, “ନାଙ୍ଗେ ଏ଼ସ୍‌କି ହ଼ଚିମାଞ୍ଜାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ଏମ୍ବାଆଁ ପୁଲାଏ଼ୟୁ ନେଞ୍ଜାମାନି ର଼ ଡ଼଼କା ମାଚେ; ଏ଼ୱାରି ଏମ୍ବାଆଁ ର଼ ଡ୍ରାଃଆଲି ମୁସାନା ବା଼ଲାତି ମୁନୁତା ରୂପାନା ଜୀସୁତି ଗୂତିତା ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଏଚେଟିଏ ଜୀସୁ ଏ଼ ପୁଲାଏ଼ୟୁ ଗସାନା ଏଲେଇଚେସି, “ରା଼ହାହାଚେ” ଏଲେଇଞ୍ଜାନା ତା଼ର୍ୟୁଁ ଲେ଼ସାନା ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ପା଼ସି ଏପ୍‌କି ଆ଼ହାମାନାରି କଡାୟାଁ ଡିକ୍‌ହାନା ଏ଼ୱାରି ହା଼ତି ମାଡ଼୍‌ହାତି ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ପ୍‌ହା ତାଚାଲି ଜୀହୁଦି ଲ଼କୁଇଁ କାଜାରି ପିଲାତଇଁ ବାତିମା଼ଲିତେରି, ଇଚିହିଁ ଏ଼ ଦିନା ସୁକ୍ରି ତାନି ଅ଼ର ଦିନା ସୁଦୁ ଜ଼ମିନି ଦିନାତା ହା଼ତି ମାଡ଼୍‌ହା ପା଼ସିମୁଣ୍ତା ଲାକ ପିସାଲି ଏ଼ୱାରି ମ଼ନ କିହିହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ଇଞ୍ଜାଁ ରିଜାରି କ଼ସ୍‌କା ୱା଼ହାନା ଜୀସୁତଲେ ପା଼ସି ମୁଣ୍ତାତା ଏକ୍‌ହାମାଚି ରିଆରି କଡାୟାଁ ଡିକ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ସାମା ଏ଼ୱାରି ଜୀସୁ ତା଼ଣା ୱା଼ହାନା ଏ଼ୱାସି ହା଼ହାମାନାଣି ମେସ୍ତେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଏ଼ୱାଣି କଡାୟାଁ ଡିକ୍‌ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ଆ଼ତିଜିକେଏ କ଼ସ୍‌କା ବିତ୍ରାଟି ରଅସି ଜୀସୁତି ପାଡ଼୍‌କା ଟଟତା ବା଼ଲା ତଲେ ଗ୍ଣାକ୍‌ହେସି ଇଞ୍ଜାଁ ଦେବୁଣିଏ ଏମ୍ବାଟି ଏ଼ୟୁ ଅ଼ଡ଼େ ନେତେରି ହ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଆମ୍ବାଆସି ମେସାମାନେସି, ଏ଼ୱାସି ସା଼କି ହୀହାମାନେସି, ଏ଼ନିକିଁ ମୀରୁ ଜିକେଏ ନାମିଦେରି; ଇଞ୍ଜାଁ ଏ଼ୱାଣି ସା଼କି ସାତା, ଏ଼ୱାସି ସାତା ୱେସାମାନେସି ଈ କାତା ଏ଼ୱାସି ପୁଞ୍ଜାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଇଚିହିଁ ଦାର୍ମୁ ପତିତି କାତା ପୂରା ଆ଼ହାଲିତାକି ଈ ବାରେ ଆ଼ତେ, “ଏ଼ୱାଣି ର଼ ଡୁମୁ ଜିକେଏ ଡିକ୍‌ଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଦାର୍ମୁ ପତିତି ଅ଼ର କାତା ଈଦି, “ଏ଼ୱାରି ଆମ୍ବାଆରାଇଁ ବା଼ଲା ତଲେ ଗ୍ଣାକ୍‌ହା ମାଚାରି ଜିକେଏ ଏ଼ୱାଣାଇଁ ସିନିକିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଈଦାଆଁ ଡା଼ୟୁ ହାରାମାତିୟାତି ଜସେପ ଇନାସି ପିଲାତ ତା଼ଣା ହାଜାନା ଜୀସୁତି ଆଙ୍ଗା ଅ଼ହାଲି ବାତିମା଼ଲିତେସି । ଈ ଜସେପ ଜୀସୁତି ର଼ ସୀସୁ ମାଚେସି, ସାମା ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ଆଜିତାକି ଡ଼ୁଗାନା ମାଚେସି, ପିଲାତ ଏ଼ୱାଣାଇଁ ହେଲ ହୀହାଲିଏ ଏ଼ୱାସି ଜୀସୁତି ଆଙ୍ଗା ମୁସାଲି ଅ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଏ଼ୱାଣିତଲେ ନିକଦିମ ମାଚେସି । ଈ ନିକଦିମ ର଼ ଦିନା ଲା଼ଆଁୟାଁ ଜୀସୁତଲେ କାତା ଆ଼ହାଲି ୱା଼ହାମାଚେସି, ଏ଼ ନିକଦିମ କଡ଼େଦସ କେ଼ଜି ଗାନ୍ଦା ନିୟୁଁ ତାଚିହିଁ ୱା଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ଏ଼ୱାରି ଜୀସୁତି ଆଙ୍ଗା ଅ଼ହାନା ଜୀହୁଦି ଲ଼କୁତି ମୁହ୍‌ନି ମେ଼ରା ତଲେ ଏ଼ଦାଆଁ ଗାନ୍ଦା ନିୟୁଁତଲେ ପା଼ତାଡ଼ା ହିମ୍ବରି ରୂପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜୀସୁ ଏମିନି ଟା଼ୟୁତା ପା଼ସି ମୁଣ୍ତାତା ଏପ୍‌କି ଆ଼ହାମାଚେସି ଏ଼ ଦାରିତା ର଼ ବା଼ଡ଼ା ମାଚେ, ଏ଼ ବିତ୍ରା ର଼ ପୁଃନି ମାହ୍‌ଣି ମାଣ୍ତା ମାଚେ, ଏମ୍ବାଆଁ ନ଼କେଏ ଆମ୍ବାଆରାଇଁ ଇଟ୍‌ୱି ଆ଼ହାହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଏ଼ ଦିନା ଜୀହୁଦି ଲ଼କୁତି ଜ଼ମିନି ଦା଼ନାତି ନ଼କିତି ଦିନା ମାଚାକି, ଗାଡି ହେକ ହାଲାଆନା ଏ଼ୱାରି ଜୀସୁତି ଆଙ୍ଗା ଅ଼ହାନା ମାହ୍‌ଣି ମାଣ୍ତାତା ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ୱା଼ରାତି ମୂଲୁ ଦିନା ଲା଼ଇ ଲା଼ଇ ଆନ୍ଦେରି ମାଞ୍ଜା ମାଞ୍ଜାନା ମଗ୍‌ଦଲିନି ମରିୟମ ମାହ୍‌ଣି ମାଣ୍ତା ଦାରିତା ୱା଼ହାନା ଏମ୍ବାତି ୱାଲି ଗୁଚା ଆ଼ହାମାନାଣି ମେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ଇଞ୍ଜାଁ ଏ଼ଦି ହଟି ହଟି ହାଜାନା ସିମନ ପିତର ଆମ୍ବାଆରାଇଁ ଜୀସୁ ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଏ଼ ସୀସୁୟାଁଇଁ ଏଲେଇଚେ, “ଆମ୍ବାଆରି ପ୍ରବୁଇଁ ମାହ୍‌ଣି ମାଣ୍ତାଟି ଅ଼ହାମାନେରି, ଇଞ୍ଜାଁ ଆମ୍ବିୟା ଇଟାମାନେରି ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଈ କାତା ୱେଞ୍ଜାନା ପିତର ଅ଼ଡ଼େ ଅ଼ର ସୀସୁ ମାହ୍‌ଣି ମାଣ୍ତା ୱାକି ହଟେରି । ");
INSERT INTO kxv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ଏ଼ୱାରି ରିଆରି ରହେଁଏ ହଟେରି, ଅ଼ର ସୀସୁ ପିତରଇଁ ଡା଼ୟୁ ପିସାନା ତଲିଏ ମାହ୍‌ଣି ମାଣ୍ତା ଏତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଏ଼ୱାସି ବଙ୍ଗାହାଁ ଏମିନି ପା଼ତାଡ଼ା ହିମ୍ବରି ଆଙ୍ଗାତା ରୂପା ମାଚେରି ଏମ୍ବାଆଁ ରିହାମାଚାଣି ମେସ୍ତେସି, ସାମା ବିତ୍ରା ହାଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ଡା଼ୟୁ ସିମନ ପିତର ଜିକେଏ ୱା଼ତେସି ଇଞ୍ଜାଁ ମାହ୍‌ଣି ମାଣ୍ତା ବିତ୍ରା ହ଼ଡାନା ସିନିକିତେସି ଏମ୍ବାଆଁ ପା଼ତାଡ଼ା ହିମ୍ବରିକା ମାନୁ, ");
INSERT INTO kxv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଇଞ୍ଜାଁ ତାନି ତା଼ର୍ୟୁଁତା ଦସାମାଚି ଏ଼ ପା଼ତାଡ଼ା ହିମ୍ବରିକା ତଲେ ହିଲାଆତେ ଏ଼ଦି ଏଟ୍‌କା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ଏଚିବେ଼ଲା ଏମିନି ସୀସୁ ତଲିଏ ମାହ୍‌ଣି ମାଣ୍ତା ଡାଗେ ୱା଼ହାମାଚେସି, ଏ଼ୱାସି ଜିକେଏ ବିତ୍ରା ହ଼ଡାନା ମେସ୍ତେସି ଅ଼ଡ଼େ ନାମିତେସି; ");
INSERT INTO kxv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଇଚିହିଁ ହା଼ତାରି ବିତ୍ରାଟି ଏ଼ୱାଣାକି ନିଙ୍ଗାଲି ଆ଼ନେ, ଦାର୍ମୁ ପତିତି ଈ ବ଼ଲୁ ଏଚେ ପାତେକା ତେଲ୍‌ହା ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ଡା଼ୟୁ ସୀସୁୟାଁ ୱେଣ୍ତେ ଇଜ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ସାମା ମରିୟମ ଡ଼ୀହି ଡ଼ୀହି ପାଙ୍ଗାତା ନିଚା ଡ଼ୟିତେ; ଇଞ୍ଜାଁ ଡ଼ୀହି ଡ଼ୀହି ବଙ୍ଗାହାଁ ମାହ୍‌ଣି ମାଣ୍ତା ବିତ୍ରା ସିନିକିତେ, ");
INSERT INTO kxv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଜୀସୁତି ଆଙ୍ଗା ଏମିନି ଟା଼ୟୁତା ଇଟ୍‌କି ଆ଼ହାମାଚେ, ଏମ୍ବାଆଁ ତା଼ର୍ୟୁଁ ୱାକି ରଅସି ଅ଼ଡ଼େ କଡାୟାଁ ୱାକି ରଅସି ଦବ୍‌ଲା ହିମ୍ବରିକା ପର୍‌ହାନା ରିଆରି ଦୂତୁୟାଁ କୁଗାମାନାଣି ମେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ଏ଼ୱାରି ଏ଼ଦାନି ଏଲେଇଚେରି, “ଏ଼ ଇୟା ଏ଼ନାଆଁତାକି ଡ଼ୀହିମାଞ୍ଜି ?” ଏ଼ଦି ଏ଼ୱାରାଇଁ ଏଲେଇଚେ, “ଆମ୍ବାଆରି ନା଼ ପ୍ରବୁଇଁ ଅ଼ହାମାନେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ଆମ୍ବିୟା ଇଟାମାନେରି ପୁଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଏ଼ଦି ଏଲେଇଞ୍ଜାନା ଡା଼ୟୁୱାକି ସିନିକିହାନା ଜୀସୁଇଁ ମେସ୍ତେ, ସାମା ଏ଼ୱାସି ଜୀସୁ ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ଏ଼ ଇୟା ଏ଼ନାଆଁତାକି ଡ଼ୀହିମାଞ୍ଜି ? ଆମ୍ବାଆରାଇଁ ପାରିମାଞ୍ଜି ?” ଏ଼ଦି ଏ଼ୱାଣାଇଁ ବା଼ଡ଼ା ଗାଟାସି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଏଲେଇଚେ, “ବା଼ବୁ ନୀନୁ ଏ଼ୱାଣାଇଁ ଅ଼ହାମାଞ୍ଜି ଇଚିହିଁ ଆମ୍ବିୟା ଇଟାମାଞ୍ଜି, ନାଙ୍ଗେ ୱେସ୍ତାମୁ ନା଼ନୁ ଅ଼ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ମରିୟମ !” ମରିୟମ ଏ଼ୱାଣି ୱାକି ସିନିକିହାନା ଏବ୍ରି ହା଼ଡାତଲେ ଏଲେଇଚେ, “ରାବ୍‌ବୁନି” ଇଚିହିଁ ଏ଼ ଗୂରୁ । ");
INSERT INTO kxv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜୀସୁ ଏ଼ଦାନି ଏଲେଇଚେସି, “ନାଙ୍ଗେ ଆସା ଇଟାଲି ଅଣ୍‌ପାଆନି, ଇଚିହିଁ ନା଼ନୁ ନୀଏଁ ପାତେକା ଆ଼ବା ତା଼ଣା ହାଜାହିଲଅଁ; ସାମା ନା଼ ତାୟିୟାଁ ତା଼ଣା ହାଜାନା କାବ୍ରୁ ହୀମୁ, ନା଼ନୁ ନା଼ ଆ଼ବା ମୀ ଆ଼ବା ନା଼ ମାହାପୂରୁ ମୀ ମାହାପୂରୁ ତା଼ଣା ହାଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିୟମ ହାଜାନା, ନା଼ନୁ ପ୍ରବୁଇଁ ମେସାମାଇଁ ଏ଼ୱାସି ନାଙ୍ଗେ ଈ ବାରେ କାତା ୱେସାମାଞ୍ଜାନେସି ଇଞ୍ଜିଁ ସୀସୁୟାଁଇଁ କାବ୍ରୁ ହୀତେ । ");
INSERT INTO kxv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ଏ଼ ଦିନା ଇଚିହିଁ ୱା଼ରାତି ତଲିତି ଦିନା ମିଡ଼୍‌ଅଲା ବେ଼ଲା ଏଚେ଼ତା ସୀସୁୟାଁ ଏମିନି ଇଲୁତା ଜୀହୁଦି ଲ଼କୁତି ଆଜିତାକି ଦା଼ରାୟାଁ ସୁଣ୍ତାମାଚେରି, ଏଚିବେ଼ଲା ଜୀସୁ ୱା଼ହାନା ମାଦିଏ ନିଚାନା ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଏ଼ୱାସି ଏଲେଇଞ୍ଜାନା ତାନି କେସ୍କା, ପାଡ଼୍‌କା ଡ଼଼ଇକା ତ଼ସ୍ତେସି, ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ପ୍ରବୁଇଁ ମେସାନା ରା଼ହାଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜୀସୁ ୱେଣ୍ତେ ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ ଆ଼ବା ଏ଼ନିକିଁ ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନେସି, ନା଼ନୁ ଜିକେଏ ମିଙ୍ଗେ ଏଲେକିହିଁଏ ପାଣ୍ତିମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଏଲେଇଞ୍ଜାନା ଏ଼ୱାରି ଲାକ ନେ଼ଞ୍ଜାନା ଏଲେଇଚେସି, “ସୁଦୁଜୀୱୁଇଁ ଆବାକଡାଦୁ, ");
INSERT INTO kxv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ମୀରୁ ମାଣ୍‌ସିୟାଁ ପା଼ପୁ ମ୍ଣେକ୍‌ହିସାରେ, ମାହାପୂରୁ ଜିକେଏ ଏ଼ୱାରି ପା଼ପୁ ମ୍ଣେକ୍‌ନେସି; ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ପା଼ପୁ ମ୍ଣେକ୍‌ଅତେରି, ଇଚିହିଁ ଏ଼ୱାଣି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ସାମା ଜୀସୁ ଏଚିବେ଼ଲା ୱା଼ହାମାଚେସି, ଏଚିବେ଼ଲାତା ବା଼ରଜା଼ଣା ବିତ୍ରା ତ଼ମା ଆମ୍ବାଆରାଇଁ ଦିଦୁମ ଇନେରି, ଏ଼ୱାସି ଏ଼ୱାରିତଲେ ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ଏଟ୍‌କାତି ସୀସୁୟାଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଜୀସୁଇଁ ମେସ୍ତମି ।” ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ୱାଣି କେୟୁତି କୁଟିୟାଁ ସିନା ମେହ୍‌ଆତିହିଁ ଅ଼ଡ଼େ ଏ଼ ବାରେ ତା଼ଣା ନା଼ ୱାଞ୍ଜୁ ଉହ୍‌ଆନା ଇଞ୍ଜାଁ ଏ଼ୱାଣି ପାଡ଼୍‌କା ଡ଼଼ଇକା ଡୀଗାଆନା ନା଼ନୁ ଏଚେଲା ଜିକେଏ ନାମଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆ଼ଟାଦିନା ଜେ଼ଚ ତାନି ସୀସୁୟାଁ ଏ଼ ଇଲୁତେଏ ମାଚେରି, ଅ଼ଡ଼େ ତ଼ମା ଜିକେଏ ଏ଼ୱାରିତଲେ ମାଚେସି, ଦା଼ରାୟାଁ ସୁଣ୍ତ୍‌କି ଆ଼ହାମାଚୁ, ସାମା ଜୀସୁ ୱା଼ହାନା ଏ଼ୱାରି ମାଦି ନିଚାନା ଏଲେଇଚେସି, “ମିଙ୍ଗେ ହିତ୍‌ଡ଼ି ଆୟାପେ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ଡା଼ୟୁ ଏ଼ୱାସି ତ଼ମାଇଁ ଏଲେଇଚେସି, “ଇମ୍ବାଆଁ ନୀ ୱାଞ୍ଜୁ ଊସାନା ସିନିକିମୁ, କେୟୁ ଦା଼ସାନା ନା଼ ପାଡ଼୍‌କା ଡ଼଼ଇକା ଡୀଗାମୁ; ଆନାମାନା ଆ଼ଆନା ନାମାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତ଼ମା ଜୀସୁଇଁ ଏଲେଇଚେସି, “ନା଼ ପ୍ରବୁ ନା଼ ମାହାପୂରୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀନୁ ନାଙ୍ଗେ ମେସାନା ନାମିମାଞ୍ଜାଦି, ଆମ୍ବାଆରି ମେହ୍‌ଆନା ନାମିନେରି ଏ଼ୱାରି ନେହେଁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜୀସୁ ସୀସୁୟାଁ ନ଼କିତା ହା଼ରେକା କାବାଆ଼ନି କାମାୟାଁ କିହାମାଚେସି, ଏ଼ୱି ବାରେ ଈ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାହିଲାଉ; ");
INSERT INTO kxv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ସାମା ମୀରୁ ଏ଼ନିକିଁ ନାମିଦେରି, ଜୀସୁ ମାହାପୂରୁ ମୀର୍‌ଏସି ମସିହା, ଈ କାତା ନାମାହାଁ ଏ଼ନିକିଁ ମୀରୁ ଏ଼ୱାଣି ଦ଼ରୁଟି ଜୀୱୁ ବେଟାଆ଼ଦେରି, ଏ଼ଦାଆଁତାକି ଈ ବାରେ ରା଼ସ୍‌କି ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ଈଦାଆଁ ଡା଼ୟୁ ଜୀସୁ ତିବିରିୟା ସାମ୍‌ଦୁରି ଗାଟୁତା ସୀସୁୟାଁଇଁ ୱେଣ୍ତେ ତ଼ଞ୍ଜାଆ଼ତେସି; ");
INSERT INTO kxv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଏମ୍ବାଆଁ ସିମନ ପିତର ତ଼ମା ଆମ୍ବାଆରାଇଁ ଦିଦୁମ ଇନେରି, ଗାଲିଲିତି କାନା ଗା଼ଡ଼ାତି ନିତନିୟେଲ, ଜେବଦିତି ମୀର୍‌କା ଅ଼ଡ଼େ ତାନି ସୀସୁୟାଁ ବିତ୍ରାଟି ରିଆରି କୂଡ଼ା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମନ ପିତର ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ମୀଣ୍‌କା ଆସାଲି ହାଜିମାଇଁ ।” ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଜିକେଏ ନୀ ତଲେ ୱା଼ନମି ।” ଏ଼ୱାରି ହାଜାନା ଡଂଗତା ହ଼ତେରି, ଏ଼ ଲା଼ଆଁୟାଁ ଏ଼ୱାରି ଏ଼ନାଆଁ ଜିକେଏ ବେଟାଆ଼ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ସାମା ଜୁଲୁପୁଲୁ ଆ଼ହାଲିଏ ଜୀସୁ ଗାଟୁତା ନିତେସି; ଆ଼ତିଜିକେଏ ଏ଼ୱାସି ଜୀସୁ ଇଞ୍ଜିଁ ସୀସୁୟାଁ ପୁନାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ କକାତେରି ମୀ ତା଼ଣା ଏ଼ନାଆଁ ମୀଣ୍‌କା ମାନୁ କି ?” ଏ଼ୱାରି “ଆ଼ଏ” ଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଡଂଗତି ଟିଃନିୱାକି ଜା଼ଲା ମେତ୍‌ଦୁ, ଆତିହିଁ ମୀରୁ ବେଟାଆ଼ଦେରି ।” ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଜା଼ଲା ମେତ୍‌ହେରି, ଏମ୍ବାଆଁ ଇଚେକା ମୀଣ୍‌କା ୱା଼ତୁ ଏ଼ୱାରି ଏ଼ଦାଆଁ ରେଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଏମ୍ବାଟିଏ ଜୀସୁ ଏମିନି ସୀସୁଇଁ ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଏ଼ ପିତରଇଁ ଏଲେଇଚେରି, “ଈୱାସିତ ପ୍ରବୁ ।” ସିମନ ପିତର ଈ କାତା ୱେଞ୍ଜାନା ଡୁମ୍‌ଣ୍ତା ମାଚାକି ତାନି ସକା ତୁର୍‌ହାନା ସାମ୍‌ଦୁରିତା ଡେ଼ୱିତେସି; ");
INSERT INTO kxv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ସାମା ଏଟ୍‌କାତି ସୀସୁୟାଁ ନେଞ୍ଜାମାନି ମୀଣ୍‌କା ଜା଼ଲାତି ରେଜି ରେଜି ଡଂଗତି ଗାଟୁତା ତାତେରି, ଇଚିହିଁ ଏ଼ୱାରି ଗାଟୁଟିଏ ହା଼ରେକା ହେକ ହାଜା ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ଏ଼ୱାରି ସାମ୍‌ଦୁରି ଗାଟୁତା ରେ଼ଚାନା, ଏମ୍ବାଆଁ ରୀଙ୍ଗାୟାଁତି ହିଚୁ ଇଞ୍ଜାଁ ହିଚୁ ଲାକ ମୀଣ୍‌କା ଅ଼ଡ଼େ ରୂଟି ଇଟାମାନାଣି ମେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ନୀଏଁ ଏମିନି ମୀଣ୍‌କା ଆସାମାଞ୍ଜେରି ଏମ୍ବାଟି ଇଚରା ତାଚିହିଁ ୱା଼ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସିମନ ପିତର ହାଜାନା ସା଼ତାକ଼ଡ଼ି ତେ଼ରଗଟା ମୀଣ୍‌କା ମାଚି ଜା଼ଲାତି ଗାଟୁତା ରେଜା ତାତେସି; ଇଚେକା ମୀଣ୍‌କା ତାକି ଜିକେଏ ଜା଼ଲା ଡାମ୍ବାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ୱା଼ଦୁ ତିଞ୍ଜୁ ।” ସୀସୁୟାଁ ବିତ୍ରାଟି ଆମ୍ବାଆରି ଏ଼ୱାଣାଇଁ ନୀନୁ ଆମ୍ବାଆତି ଇଞ୍ଜିଁ ୱେଞ୍ଜାଲି ସା଼ସା କିଆତେରି, ଇଚିହିଁ ଏ଼ୱାସି ପ୍ରବୁ ଈ କାତା ଏ଼ୱାରି ପୁଞ୍ଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜୀସୁ ୱା଼ହାନା ରୂଟି ଅ଼ହାନା ହୀତେସି, ଇଞ୍ଜାଁ ମୀଣ୍‌କା ଜିକେଏ ଏଲେକିହିଁଏ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଜୀସୁ ହା଼କିଟି ନିଙ୍ଗିତି ଡା଼ୟୁ ଈଦି ତୀନି ପା଼ଲି ତାକି ସୀସୁୟାଁଇଁ ତ଼ଞ୍ଜାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ଏ଼ୱାରି ତିଞ୍ଜାଲି ଆ଼ଡିତି ଜେ଼ଚ ଜୀସୁ ସିମନ ପିତରଇଁ ୱେଚେସି, “ଏ଼ ଜହନତି ମୀର୍‌ଏଣା ସିମନ ଏ଼ନାଆଁ ନୀନୁ ନାଙ୍ଗେ ଈୱାରି କିହା ହା଼ରେକା ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜାଦି ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ନୁ ନିଙ୍ଗେ ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାଇଁ ନୀନୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାମାଞ୍ଜି ।” ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ମେ଼ଣ୍ତା ଡା଼ଲ୍‌କାଣି ତୀହ୍‌ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜୀସୁ ୱେଣ୍ତେ ରୀ ପା଼ଲି ତାକି ୱେଚେସି, “ଏ଼ ଜହନତି ମୀର୍‌ଏଣା ସିମନ ଏ଼ନାଆଁ ନୀନୁ ନାଙ୍ଗେ ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜାଦି ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନା଼ନୁ ନିଙ୍ଗେ ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାଇଁ ନୀନୁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାମାଞ୍ଜି ।” ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ମେ଼ଣ୍ତାୟାଁଣି ପ଼ହିକିମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜୀସୁ ଅ଼ଡ଼େ ତୀନି ପା଼ଲି ତାକି ୱେଚେସି, “ଏ଼ ଜହନତି ମୀର୍‌ଏଣା ସିମନ ଏ଼ନାଆଁ ନୀନୁ ନାଙ୍ଗେ ଜୀୱୁ ନ଼ହିଁମାଞ୍ଜାଦି ?” ଏଲେଇଞ୍ଜି ତୀନି ପା଼ଲି ୱେଞ୍ଜାଲିଏ ଏ଼ୱାସି ଦୁକୁ ଆ଼ହାନା ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନୀନୁ ବାରେ ପୁଞ୍ଜାମାଞ୍ଜି; ନା଼ନୁ ନିଙ୍ଗେ ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାଇଁ, ଏ଼ଦାଆଁ ନୀନୁ ପୁଞ୍ଜାମାଞ୍ଜି ।” ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ମେ଼ଣ୍ତାୟାଁଣି ଜାତ୍‌ନୁ ଅ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ନା଼ନୁ ମିଙ୍ଗେ ସାତା ୱେସିମାଞ୍ଜାଇଁ, ନୀନୁ ଦାଂଗ୍‌ଣା ମାନି ବେ଼ଲାତା ନୀ ଟେଡେଲି ରୂପା କଡାନା ଆମ୍ବିୟାୱାକି ନୀ ମ଼ନ ଏନିକା ରେ଼ଜିମାଚି, ସାମା ବୁଡ଼୍‌ହା ଆ଼ତିହିଁ ନୀନୁ ନୀ କେସ୍କା ଦା଼ହ୍‌ଦି ଇଞ୍ଜାଁ ଅ଼ର ରଅସି ନୀ ଟେଡେଲିତା ଦସାନା ଆମ୍ବିୟା ନୀ ମ଼ନ ହିଲେଏ ଏନିକା ରେଜା ଅୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପିତର ଏ଼ନିଲେହେଁତି ହା଼କି ତଲେ ମାହାପୂରୁଇଁ ଗାୱୁରମି କିନେସି, ଏ଼ଦାଆଁ ପୁଣ୍‌ମ୍ବି କିହାଲି ଏଲେଇଞ୍ଜାମାଚେସି । ଏଲେଇଚି ଡା଼ୟୁ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ଜେ଼ଚ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଜୀସୁ ଏମିନି ସୀସୁଇଁ ଜୀୱୁ ନ଼ହିଁମାଚେସି, ଅ଼ଡ଼େ ଲା଼ଆଁୟାଁ ବ଼ଜି ବେ଼ଲାତା ତାନି ବକତା ଲାବାନା ପ୍ରବୁ ନିଙ୍ଗେ ଆମ୍ବାଆସି ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାମାଚେସି, ଏ଼ ସୀସୁ ଜେ଼ଚ ୱା଼ହିମାନାଣି ପିତର ୱେଣ୍ତେ ତିର୍‌ୱାନା ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର ଏ଼ୱାଣାଇଁ ମେସାନା ଜୀସୁଇଁ ୱେଚେସି, “ପ୍ରବୁ ଈୱାଣି କାତା ଏ଼ନାଆଁ ଇଞ୍ଜିମାଞ୍ଜି ?” ");
INSERT INTO kxv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ ୱା଼ନି ଦିନା ପାତେକା ଡ଼ୟାପେସି ଇଞ୍ଜିଁ ନା଼ନୁ ମ଼ନ କିଇଁ, ଆତିହିଁ ଏମ୍ବାଆଁ ନୀଦି ଏ଼ନାୟି ମାନେ ? ନୀନୁ ନା଼ ଜେ଼ଚ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ଏମ୍ବାଟିଏ ଏ଼ ସୀସୁ ହା଼ଅସି, ଈ କାତା ତାୟିୟାଁ ବିତ୍ରା ୱେ଼ଙ୍ଗାହାଚେ, ସାମା ଏ଼ୱାସି ହା଼ଅସି ଇଞ୍ଜିଁ ଜୀସୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଞ୍ଜା ହିଲାଆତେସି, ସାମା ନା଼ ୱା଼ନି ଦିନା ପାତେକା ଏ଼ୱାସି ଡ଼ୟାପେସି ଇଞ୍ଜିଁ ନା଼ନୁ ମ଼ନ କିଇଁ, ଆତିହିଁ ଏମ୍ବାଆଁ ମୀ ଏ଼ନାୟି ମାନେ ଇଞ୍ଜିଁ ୱେସାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଆମ୍ବାଆସି ଈ ବାରେ ସା଼କି ହୀହିମାନେସି, ଅ଼ଡ଼େ ଈ ବାରେ ରା଼ଚାମାନେସି, ଏ଼ୱାସି ଏ଼ ସୀସୁ; ଅ଼ଡ଼େ ଏ଼ୱାଣି ସା଼କି ସାତା ଈଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି । ");
INSERT INTO kxv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଜୀସୁ ହା଼ରେ ହା଼ରେକା କାମାୟାଁ କିହାମାଚେସି; ଏ଼ ବାରେ ରଣ୍ତା ରଣ୍ତାଆଁ କିହିଁ ରା଼ଚିତିହିଁମା, ଇଚେକା ପତିୟାଁ ରା଼ସ୍‌କି ଆ଼ତୁମା, ଇଚିହିଁ ନା଼ ଅଣ୍‌ପୁତା ବାରେ ଦାର୍‌ତିତା ଜିକେଏ ଏ଼ ବାରେ ଇଟାଲି ଟା଼ୟୁ ଆ଼ଆତେମା ।");
INSERT INTO kxv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଏ଼ ଜୀୱୁତି ତିୟପିଲ, ନା଼ ମୂଲୁତି ପତିତା ଈ ବାରେ କାତା ରା଼ଚାମାଇଁ, ଜୀସୁ ଏମିନି କାମା ମା଼ଟ୍‌ହେସି ଅ଼ଡ଼େ ଜା଼ପ୍‌ହେସି, ");
INSERT INTO kxv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ଏ଼ ଦିନା ପାତେକା ଏ଼ୱାସି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ଆ଼ଚାମାଚେସି, ସୁଦୁଜୀୱୁ ତଲେ ହୁକୁମି ହୀହାନା ଲାକପୂରୁ ଅ଼ୱି ଆ଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଏଚେଟିଏ ଜୀସୁ ତାନି ଦୁକୁ ବେଟାଆ଼ତି ଡା଼ୟୁ ହା଼ରେକା ଦିନା ଏ଼ୱାସି ଜୀୱୁତଲେ ମାଚେସି ଈଦାଆଁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ତା଼ଣା ପାର୍‌ମାଣା କିତେସି, ଇଞ୍ଜାଁ ରୀ କ଼ଡ଼ି ଦିନା ପାତେକା ହା଼ରେକା ଦେବା ତ଼ଞ୍ଜାଆ଼ହାନା ମାହାପୂରୁ ରା଼ଜିତି କାତା ଜା଼ପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ର଼ ଦିନା ଏ଼ୱାରି ରଣ୍ତିଏ ତା଼ଣା ତିଞ୍ଜାଲି କୂଡ଼ା ଆ଼ହାମାଚି ବେ଼ଲାତା ଜୀସୁ ଏ଼ୱାରାକି ଈ ହୁକୁମି ହୀତେସି; “ମୀରୁ ଜିରୁସାଲମ ପିସାଁ ଆମ୍ବିୟା ହାଲାଆଦୁ, ସାମା ମୀରୁ ମାହାପୂରୁ ଆ଼ବାତି ଆ଼ଞ୍ଜାମାନାଣି ନା଼ ତା଼ଣାଟି ୱେଞ୍ଜା ମାଞ୍ଜେରି, ଏ଼ଦାଆଁ ପା଼ଣ୍‌ନି ପାତେକା କା଼ଚାନା ଡ଼ୟାଦୁ; ");
INSERT INTO kxv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଇଚିହିଁ ଜହନ ଏ଼ୟୁତା ବାପ୍ତିସ୍ମ ହୀତେସି ସାତା, ସାମା ମୀରୁ ଏଚରଦିନା ଜେ଼ଚ ସୁଦୁଜୀୱୁ ତଲେ ବାପ୍ତିସ୍ମ ବେଟାଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ର଼ ଦିନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ରୁଣ୍ତା ଆ଼ହାମାଚି ବେ଼ଲା ଜୀସୁଇଁ ୱେଚେରି, “ପ୍ରବୁ, ନୀନୁ ଏ଼ନାଆଁ ନୀଏଁ ଇସ୍ରାୟେଲ କେୟୁତା ଅ଼ଡ଼େ ୱେଣ୍ତେ ଈ ରା଼ଜିତି ହେର୍‌ପିଦି ?” ");
INSERT INTO kxv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜୀସୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆମିନି ଦିନା ଅ଼ଡ଼େ କା଼ଲା ନା଼ ଆ଼ବା ତାନି ଅଦିକାରାତା ଇଟାମାନେସି, ଏ଼ ବାରେ ମିଙ୍ଗେ ପୁଞ୍ଜାଲି ଲ଼ଡ଼ା ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ସାମା ସୁଦୁଜୀୱୁ ମୀ ତା଼ଣା ୱା଼ତିସାରେ, ମୀରୁ ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ଦେରି, ଇଞ୍ଜାଁ ଜିରୁସାଲମ ବାରେ ଜୀହୁଦା ଦେ଼ସା ଇଞ୍ଜାଁ ସମିରଣତା ଅ଼ଡ଼େ ବୂମି ମୁଟ୍‌ପେ ତାକି ନା଼ ସା଼କି ଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଏ଼ୱାସି ଈ ବାରେ କାତା ୱେସ୍ତି ଡା଼ୟୁ ଏ଼ୱାରି ମେସ୍‌ପନିଏ ଜୀସୁ ଲାକପୂରୁ ହାଚେସି, ଅ଼ଡ଼େ ଇଚାୟି ଦୂନ୍ଦ୍ରା ଏ଼ୱାଣାଇଁ ଏ଼ୱାରି ତା଼ଣାଟି ଅ଼ହିଁ ହାଚେ, ଏ଼ୱାରି ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ମେହ୍‌ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଏ଼ୱାସି ଲାକପୂରୁ ହାଜାଲିଏ ଜିକେଏ ଏ଼ୱାରି ହା଼ଗୁୱାକି ମୂମ୍ବୁ କିହାନା ସିନିକିହି ମାନେରି; ଏଚିବେ଼ଲା ଦବ୍‌ଲା ହିମ୍ବରିକା ହୁଚାମାନି ରିଆରି ଦେବୁଣିଏ ଏ଼ୱାରି ନ଼କିତା ନିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏଲେଇଚେରି “ଏ଼ ଗାଲିଲିତି ଲ଼କୁତେରି, ଏ଼ନାଆଁତାକି ହା଼ଗୁୱାକି ମୂମ୍ବୁ କିହାନା ନିଚାମାଞ୍ଜେରି ? ଈ ଆମିନି ଜୀସୁ ମୀ ତା଼ଣାଟି ଲାକପୂରୁ ଅ଼ୱିଆ଼ତେସି, ଏ଼ୱାଣାଇଁ ଏ଼ନିକିଁ ଲାକପୂରୁ ହାଚାଣି ମୀରୁ ମେସ୍ତେରି, ଅ଼ଡ଼େ ଏଲେକିହିଁଏ ୱେଣ୍ତେ ୱା଼ନାଣି ମେହ୍‌ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ଏମ୍ବାଟିଏ ଡା଼ୟୁ ଏ଼ୱାରି ଜୀତ ଇନି ହ଼ରୁ ଲାକଟି ଜିରୁସାଲମତା ୱେଣ୍ଡାୱା଼ତେରି, ଏ଼ ଜୀତ ହ଼ରୁଟିଏ ଜିରୁସାଲମ ର଼ କିଲମିଟର ହେକ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଇଞ୍ଜାଁ ଏ଼ୱାରି ପିତର, ଜହନ, ଜାକୁବ, ଆନ୍ଦ୍ରିୟ, ପିଲିପ, ତ଼ମା, ବାର୍ତଲମି, ମାତିୟୁ, ଆଲେପି ମୀର୍‌ଏସି ଜାକୁବ, ଦେ଼ସାତି ଜୀୱୁ ନ଼ନି ସିମନ ଅ଼ଡ଼େ ଜାକୁବ ମୀର୍‌ଏସି ଜୀହୁଦା, ଗା଼ଡ଼ାତା ଏଜାନା, ଏମିନି ଲାକନି ଇଲୁତା ବାସା ଆ଼ହାମାଚେରି, ଏମ୍ବାଆଁ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ଏ଼ୱାରି ବାରେଜା଼ଣା ଇୟାସିକା ତଲେ ଇଞ୍ଜାଁ ଜୀସୁତି ଇୟା ମରିୟମ ଅ଼ଡ଼େ ତାମି ତାୟିୟାଁ ତଲେ ରଣ୍ତିଏ ଅଣ୍‌ପୁ ତଲେ ପ୍ରା଼ତାନା କିହିଁ ରୁଣ୍ତା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ଏଚରଦିନା ଡା଼ୟୁ ନାମିତାରି କୂଡ଼ା ଆ଼ହାମାଚେରି, ଏମ୍ବାଆଁ ସ଼ କ଼ଡ଼ି ଜା଼ଣା ଲ଼କୁ କୂଡ଼ା ଆ଼ହାମାଚେରି, ପିତର ତାୟିୟାଁ ବିତ୍ରାଟି ନିଚାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ଜୀୱୁତି ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା, ଆମିନି ଇସ୍କାରିୟତ ଜୀହୁଦା ଜୀସୁଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ଆସ୍‌ପି କିହାଲିତାକି ଜିରୁ ତ଼ସାମାଚେସି, ଏ଼ୱାଣି ତାକି ସୁଦୁଜୀୱୁ ନ଼କେଏ ଦାୱୁଦ ଗୂତିଟି ଏ଼ନାଆଁ ୱେସାମାଚେସି, ଏ଼ ଦାର୍ମୁ ସା଼ସ୍ତେରି ପୂରା ଆ଼ନାୟି ମାଚେ; ");
INSERT INTO kxv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଇଚିହିଁ ଏ଼ୱାସି ମା଼ ବିତ୍ରାଟି ରଅସି ଇଞ୍ଜିଁ ଏଜିକିୱି ଆ଼ହିମାଚେସି, ଅ଼ଡ଼େ ଈ ସେ଼ବା କାମାତା ପା଼ଣା ବେଟାଆ଼ହା ମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଈ ଇସ୍କାରିୟତ ଜୀହୁଦା ଲାଗେଏ କାମା କିତି ଡାବୁୟାଁ ତଲେ ରଚାଣି ବୂମି କଡ୍‌ୱି ଆ଼ହାମାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାସି ହା଼ତି ତା଼ଣା ତା଼ର୍ୟୁଁ ଡ଼଼ଇ କିହିଁ ତର୍‌ଗାଲିଏ ତାନି ବାଣ୍ତି ଡ଼ାୟାହାଚେ ଇଞ୍ଜାଁ ୱାହିୟାଁ ହ଼ଚାହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଅ଼ଡ଼େ, ଈଦାଆଁ ଜିରୁସାଲମ ଗା଼ଡ଼ାତା ବାସା କିହିମାନି ଲ଼କୁ ବାରେ ପୁଞ୍ଜାଲିଏ ଏ଼ ବୂମିତି ଏ଼ୱାରି ହା଼ଡାତଲେ “ହକଲ୍‌ଦାମା” ଇଚିହିଁ “ନେତେରି ବୂମି” ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ଅ଼ଡ଼େ ପା଼ଚୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ଏ଼ୱାଣି ବାସାଟା଼ୟୁ ୱାର୍‌ଆୟି ଆ଼ପେ; ଏମ୍ବାଆଁ ଆମ୍ବାଆରି ବାସା କିଆପେରି ।” ଅ଼ଡ଼େ ଜିକେଏ ରା଼ସ୍‌କି ଆ଼ହାମାନେ; “ଏ଼ୱାଣି କାମାତି ପା଼ଣା ଅ଼ର ରଅସି ବେଟା ଆ଼ପେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ଏ଼ଦାଆଁତାକି, ପ୍ରବୁ ଜୀସୁ ୱେଣ୍ଡେ ନିଙ୍ଗିତି କାତା ସା଼କି ଆ଼ହାଲି ଅ଼ର ରଅସି ମା଼ ତଲେ ଆଣ୍ଡାନାୟି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜୀସୁ ଜହନ ତା଼ଣାଟି ବାପ୍ତିସ୍ମ ଅ଼ତି ବେ଼ଲାଟିଏ ଲାକପୂରୁ ହାନି ପାତେକା ପ୍ରବୁ ଜୀସୁ ମା଼ ତଲେ ନୀଡାମାଚି ବେ଼ଲାତା, ଆମିନି ଲ଼କୁ ମା଼ ଗଚିତା ମାଚେରି, ଏ଼ୱାରି ତା଼ଣାଟି ରଅସି ୱେଣ୍ତେ ନିଙ୍ଗିନି ସା଼କି ଆ଼ନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ଏଚେଟିଏ ଏ଼ୱାରି ରିଆରାଇଁ ଇଚିହିଁ ଜସେପଇଁ, ଆମ୍ବାଆରାଇଁ ବର୍ସବା ଇନେରି ଅ଼ଡ଼େ ଆମ୍ବାଆରି ହା଼ଟା ଦ଼ରୁ ଜୁସ୍ତ ଏ଼ୱାଣାଇଁ ଇଞ୍ଜାଁ ମତିୟଇଁ ବାଚି କିହାନା, ");
INSERT INTO kxv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ଈ ପ୍ରା଼ତାନା କିତେରି, “ପ୍ରବୁ ନୀନୁ ବାରେତି ହିୟାଁତି ଅଣ୍‌ପୁ ପୁନାତି, ଜୀହୁଦା ଏମିନି ଟା଼ୟୁତା ଡ଼ୟିନାୟି ମାନେ ଏ଼ୱାସି ହାଜାଲିଏ, ଏ଼ୱାଣି ଟା଼ୟୁତା ଈ ରିଆରି ବିତ୍ରାଟି ନୀ ତା଼ଣାଟି ଆ଼ଚିତାସି ଆମ୍ବାଆସି, ");
INSERT INTO kxv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଏ଼ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ସେ଼ବା କାମା କିହାଲି ଆମ୍ବାଆରାଇଁ ଜୀହୁଦା ପା଼ଣାତା ବାଚି କିହାମାଞ୍ଜି ତ଼ସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ ରିଆରି ତାକି ପାଦି କିହାଲିଏ ମତିୟ ଦ଼ରୁତଲେ ଆ଼ତେ; ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଗାର ଜା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଗଚିତା ଆଣ୍ଡିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେନ୍ତିକସ୍ତ ଦିନାତା କ୍ରୀସ୍ତଇଁ ନାମିତି ବାରେଜା଼ଣା ର଼ ଟା଼ୟୁତା ରୁଣ୍ତା ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଏ଼ ଦେବୁଣିଏ କାଜା ଗା଼ଲି ୱା଼ହିମାନି ଲେହେଁ ର଼ ହା଼ଡା ଲାକପୂରୁଟି ୱା଼ହାଁ, ଆମିନି ଇଲୁତା ଏ଼ୱାରି କୁଗାମାଚେରି, ଏ଼ ଇଲୁତି ବାରେୱାକି ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ଇଞ୍ଜାଁ ହିଚୁ ଗୁଦ୍‌ୱା ଲେହେଁ ତ଼ଞ୍ଜାଆ଼ହାନା ଏ଼ୱାରି ନ଼କିତା ରଣ୍ତି ରଣ୍ତି ଆ଼ହିଁ ଏ଼ ବାରେଜା଼ଣାତି ଲାକ ରେ଼ଚାୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ବାରେଜା଼ଣା ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାନା ଏ଼ ଜୀୱୁ ଏ଼ନିକିଁ ଜ଼ଲାଲି ବା଼ଡ଼୍‌ୟୁ ହୀତେ, ଏଲେକିଁ ଏ଼ୱାରି ଏଟ୍‌କା ଏଟ୍‌କା ହା଼ଡାତଲେ ଜ଼ଲାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଏଚିବେ଼ଲାତା ପେନ୍ତିକସ୍ତ ପାର୍ବୁତାକି ହା଼ଗୁ ଡ଼଼ଇତି ଏଟ୍‌କା ଏଟ୍‌କା ଦେ଼ସାଟି ୱା଼ହାମାଚି ଜୀହୁଦି ଲ଼କୁ ଜିରୁସାଲମତା ଡ଼ୟା ମାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଅ଼ଡ଼େ, ଏ଼ ହା଼ଡା ୱେଞ୍ଜାଲିଏ, ହା଼ରେକା ଲ଼କୁ କୂଡ଼ା ଆ଼ହାନା ବାରେଜା଼ଣା ଜାହା ଜାହାରା ହା଼ଡାତଲେ ଏ଼ୱାରି ଜ଼ଲିମାନାଣି ୱେଞ୍ଜାନା କାବା ଆ଼ହାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଆଡାଜାକା ଅ଼ଡ଼େ କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ମେହ୍‌ଦୁ ଈ ଆମିନି ଲ଼କୁ ହା଼ଡା ଜ଼ଲିମାନେରି, ଏ଼ୱାରି ବାରେ ଗାଲିଲିତାରି ଆ଼ଏକି ? ");
INSERT INTO kxv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ଆତିହିଁ, ମା଼ର ଏ଼ନିକିଁ ବାରେଜା଼ଣା ଜାହା ଜାହାରା ଜାର୍ନା ଟା଼ୟୁତି ହା଼ଡାତଲେ ଜ଼ଲିମାନାଣି ୱେଞ୍ଜିମାନାୟି ? ");
INSERT INTO kxv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ପାର୍ତିୟ, ମାଦିୟ, ଏଲାମିୟ, ଅ଼ଡ଼େ ମେସପଟାମିୟାଁ, ଜୀହୁଦା ଦେ଼ସା, କାପାଦକିୟା; ପନ୍ତ ଅ଼ଡ଼େ ଆସିୟା, ");
INSERT INTO kxv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପୁର୍ଗିୟା, ପଂପୁଲିୟା, ମିସର ଇଞ୍ଜାଁ କୁରିଣି ଦାରିତା ଡ଼଼ଇନି ଲିବିୟା ନା଼ସ୍‌କାଣାଁ ବାସା କିନାରି, ଇଞ୍ଜାଁ ର଼ମ୍‌ଟି ୱା଼ହାମାନି ଜୀହୁଦି, ");
INSERT INTO kxv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଅ଼ଡ଼େ ଏଟ୍‌କା କୂଡ଼ାତି ଲ଼କୁ ଜୀହୁଦି ଦାର୍ମୁତି ନାମାହାଁ ଡ଼ୟାମାନାରି; ଅ଼ଡ଼େ କ୍ରିତି ଇଞ୍ଜାଁ ଆରବିୟ ଦେ଼ସାତି ଲ଼କୁତାୟି ମା଼ର, ମା଼ର ଜାହା ଜାହାରା ହା଼ଡାତଲେ ମାହାପୂରୁତି କାଜା କାଜା କାମାତି କାତା ଜ଼ଲିମାନାଣି ୱେଞ୍ଜିମାନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଅ଼ଡ଼େ ବାରେଜା଼ଣା ଆଡାଜାକା ଅ଼ଡ଼େ କାବାଆ଼ହାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ହା଼ଡାକାତା ଆ଼ତେରି, “ଈଦାଣି ଅର୍ତ ଏ଼ନାୟି ?” ");
INSERT INTO kxv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ସାମା ଏଟ୍‌କାତାରି ଲାଜାକିହିଁ ଏଲେଇଚେରି, “ଈୱାରି ପୁଃନି ଡ଼ାକ୍‌ହି ଅଙ୍ଗୁରି ରାସା ଗସାନା ହ଼ଚା ହାଜାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ସାମା ପିତର ଏଗାର ଜା଼ଣା ସୀସୁୟାଁ ତଲେ ନିଚାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଜୀହୁଦି ତାୟିୟାଁ ଅ଼ଡ଼େ ଜିରୁସାଲମତା ବାସା କିହିମାନାତେରି, ମୀରୁ ନା଼ କାତାତି ୱେଞ୍ଜାଦୁ ଅ଼ଡ଼େ ଈଦାଆଁ ପୁଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଇଚିହିଁ ମୀରୁ ଏ଼ନିକିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି, ଈୱାରି ଏଲେକିହିଁ ଅଙ୍ଗୁରି ରାସା ଗସାହାଁ ହ଼ଚା ହିଲଅରି; ଈଦି ଆ଼ତେ ଲା଼ଇତି ନ଼ ଗଂଟା ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ସାମା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଆମିନି ଜୟେଲ ତା଼ଣାଟି ରା଼ସ୍‌କି ଆ଼ହାମାନେ ଈଦି ଆ଼ହିମାନେ ଏ଼ଦି; ");
INSERT INTO kxv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘ମାହାପୂରୁ ୱେସିମାନେସି ରା଼ନି ଦିନାତା ଈ ବାରେ ଗଟୱି ଆ଼ନେ, ନା଼ନୁ ବାରେ ଲ଼କୁତାକି ନା଼ ଜୀୱୁ ପାଣ୍ତାଇଁ, ଏଚେଟିଏ ମୀ ମୀର୍‌କା ମା଼ସ୍‌କା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନେରି, ମୀ ଦାଂଗ୍‌ଣାୟାଁ କାବା ଆ଼ନାଣି ମେହ୍‌ନେରି, ଅ଼ଡ଼େ ମୀ ବୁଡ଼୍‌ହାୟାଁ ହାପାନା ହେଣ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ହାଅ, ଏ଼ କା଼ଲାତା ନା଼ ହ଼ଲିୟାଙ୍ଗା ଇଞ୍ଜାଁ ହ଼ଲେଣିସିକା ଲାକ, ନା଼ନୁ ନା଼ ଜୀୱୁତି ଏ଼ୱାରି ଲାକ ୱା଼କ୍‌ଇଁ, ଏଚେଟିଏ ଏ଼ୱାରି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ନା଼ନୁ ହା଼ଗୁ ଲାକ କାବାଆ଼ନି କାମା; ଅ଼ଡ଼େ ଡ଼଼ଇ ଦାର୍‌ତିତା କାବାଆ଼ନି ସିନାୟାଁ, ଏମ୍ବାଆଁ ନେତେରି, ହିଚୁ ଇଞ୍ଜାଁ ହା଼ରେକା ବ଼ୟିଁ ତ଼ହ୍‌ଇଁ; ");
INSERT INTO kxv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ପ୍ରବୁତି କାଜା ଗାୱୁରମି ଦିନା ୱା଼ନି ନ଼କେଏ, ୱେ଼ଡ଼ା ଆନ୍ଦେରି ଆ଼ନେ, ଅ଼ଡ଼େ ଲେ଼ଞ୍ଜୁ ନେତେରିଲେହେଁ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଅ଼ଡ଼େ ଇଲେକିହିଁ ଆ଼ନେ, ଆମ୍ବାଆସି ପ୍ରବୁ ଦ଼ରୁ ଆସାନା ପ୍ରା଼ତାନା କିନେସି, ଏ଼ୱାସି ଗେଲ୍‌ପି ଆ଼ନେସି ।’” ");
INSERT INTO kxv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ଇସ୍ରାୟେଲ ଲ଼କୁତେରି, ଈ ବାରେ କାତା ୱେଞ୍ଜୁ ! ନା଼ଜରିତ ଜୀସୁ ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁତି କାମା, କାବାଆ଼ନି କାମା ଇଞ୍ଜାଁ ସିନାୟାଁ ତଲେ ମୀ ନ଼କିତା ମାହାପୂରୁତି ପାଣ୍ତ୍‌ୱି ଆ଼ତାସି ଇଞ୍ଜିଁ ପାର୍‌ମାଣା ଆ଼ହାମାନେସି, ଏ଼ୱାଣି ତା଼ଣାଟି ମାହାପୂରୁ ମୀ ତା଼ଣା ଈ ବାରେ କାମା କିହାମାନେସି, ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଏ଼ ଜୀସୁ ମାହାପୂରୁ କିହାମାନି ଅଣ୍‌ପୁ ଅ଼ଡ଼େ ତଲିତି କାତାତଲେ ହେର୍‌ପି ଆ଼ହାଲିଏ, ମୀରୁ ଏ଼ୱାଣାଇଁ ପା଼ପୁ ଗାଟାରି କେୟୁଟି ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ସାମା ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ହା଼କିତି ବା଼ଡ଼୍‌ୟୁଟି ଗେଲ୍‌ପାନା ନୀଟ୍‌ହା ମାଚେସି, ଇଚିହିଁ ଏ଼ୱାସି ହା଼କିତା ଦସ୍‌ପି ଆ଼ହା ଡ଼ୟିନେସି ଏ଼ଦି ଆ଼ହାଲି ଆ଼ଡେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାୱୁଦ ଏ଼ କାତାତି ୱେସାମାନେସି, “ନା଼ନୁ ବାରେବେ଼ଲା ନା଼ ନ଼କିତା ପ୍ରବୁଇଁ ମେସିମାଚେଏଁ; ଇଚିହିଁ ନା଼ନୁ ଏ଼ନିକିଁ କିଲିବିଲି ଆ଼ଅଁ, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ନା଼ ଟିଃନି ଟଟତା ମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଏ଼ଦାଆଁତାକି ନା଼ ହିୟାଁ ରା଼ହାଁ ଅ଼ଡ଼େ ନା଼ ୱେନ୍ଦରି ରା଼ହାଁ ଆ଼ତେ, ଅ଼ଡ଼େ ନା଼ ଆଙ୍ଗା ଜିକେଏ ବା଼ର୍ସୁ ତଲେ ବାସା କିନେ, ");
INSERT INTO kxv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଇଚିହିଁ ନୀନୁ ନା଼ ଜୀୱୁତି ହା଼କିପୂରୁତା ପିହ୍‌ଅତି; ଅ଼ଡ଼େ ନୀ ନାମୁ ଅ଼ଡ଼େ ସୁଦୁ ଗାଟାଣାଇଁ ମାହ୍‌ଣି ମାଣ୍ତାତା ସୀର୍‌ହାଲି ହୀଅତି । ");
INSERT INTO kxv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ନୀନୁ ନାଙ୍ଗେ ଜୀୱୁତି ଜିରୁ ତ଼ସାମାଞ୍ଜାଦି, ଅ଼ଡ଼େ ନୀନୁ ନାଙ୍ଗେ ନୀ ନ଼କିତା ରା଼ହାଁତା ନେଞ୍ଜିକିୟାଦି ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ଇସ୍ରାୟେଲତି ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କାତେରି, ମା଼ ଆକୁ ଦାୱୁଦତି କାତା ନା଼ନୁ ମିଙ୍ଗେ କାଜା ହା଼ଡାତଲେ ୱେସାଲି ଆ଼ଡାଇଁ, ଇଚିହିଁ ଏ଼ୱାସି ହା଼ତେସି ଇଞ୍ଜାଁ ମୁସ୍‌ପି ଆ଼ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ମାହ୍‌ଣି ମାଣ୍ତା ନୀଏଁ ପାତେକା ଇମ୍ବାଆଁ ମା଼ ବିତ୍ରା ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ରାଜା ଦାୱୁଦ ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଲେହେଁ, ତାନି ନେତେରି ତଲେ ଜାର୍ନି ଆ଼ତାଣାଇଁ ମାହାପୂରୁ ତାନି ସିଂଗାସାଣିତା କୁଗିକିହାଲି ତାନି ତା଼ଣା ଆ଼ଞ୍ଜାମାଚେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଦାୱୁଦ ଈଦାଆଁ ପୁଞ୍ଜାମାଚାକି, କ୍ରୀସ୍ତତି ୱେଣ୍ତେ ନିଙ୍ଗିନି କାତା ୱେସାମାଚେସି ।” “ଇଚିହିଁ ଏ଼ୱାସି ହା଼ତାରି ତା଼ଣା ଡ଼ୟାଆତେସି; ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଆଙ୍ଗା ମାହ୍‌ଣି ମାଣ୍ତାତା ସୀର୍‌ଆତେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ମାହାପୂରୁ ଈ ଜୀସୁଇଁ ଅ଼ଡ଼େ ୱେଣ୍ତେ ହା଼କିଟି ନିକ୍‌ହାମାନେସି ଈଦାଣି ତାକି ମା଼ମ୍ବୁ ବାରେ ସା଼କି । ");
INSERT INTO kxv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଏ଼ଦାଆଁତାକି ଆ଼ବା ମାହାପୂରୁ ଜୀସୁଇଁ କାଜାସି କିହାନା ତାନି ଟିଃନିୱାକି କୁଗିକିହାନା ତାନିତଲେ ସା଼ଲୱି କିହାଲି ହୀତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ମାଙ୍ଗେ ଆ଼ଞ୍ଜାମାଚି ସୁଦୁଜୀୱୁ ହିୟାତେସି, ଈଦି ମୀରୁ ବାରେ ଆମିନିଗାଟାଣି ମେସିମାଞ୍ଜେରି ଇଞ୍ଜାଁ ୱେଞ୍ଜିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଇଚିହିଁ ଦାୱୁଦ ଲାକପୂରୁ ହାଜାହିଲାଆତେସି; ଏ଼ୱାସି ତା଼ନୁଏ ୱେସାମାଚେସି, “ପ୍ରବୁ ନା଼ ପ୍ରବୁଇଁ ଏଲେଇଚେସି; ");
INSERT INTO kxv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ନା଼ନୁ ନୀ ସାତ୍ରୁୟାଁଣି ନୀ କଡାୟାଁ ଡ଼଼ଇ ଇଟାଆ ପାତେକା, ନୀନୁ ନା଼ ଟିଃନିୱାକି କୁଗାମାନାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ଈଦାଆଁତାକି ବାରେ ଇସ୍ରାୟେଲତି ଲ଼କୁ ସାତେଏ ପୁନାପେରି, ଇଚିହିଁ ଆମିନି ଜୀସୁଇଁ କ୍ରୁସତା ପା଼ୟିତେରି, ସାତେଏ ଏ଼ୱାଣାଇଁ ମାହାପୂରୁ, ପ୍ରବୁ ଅ଼ଡ଼େ ମସିହା ପା଼ଣା ହୀତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଈ କାତା ୱେଞ୍ଜାନା ଲ଼କୁତି ହିୟାଁ ଡୀହାହାଚେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ପିତର ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ମାଚି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ଏଲେଇଚେରି, “ତାୟିୟାଁ ମା଼ମ୍ବୁ ଏ଼ନାଆଁ କିନମି ?” ");
INSERT INTO kxv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ପିତର ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମୀରୁ ମୀ ହିୟାଁ ୱେଟ୍‌ହା କଡାଦୁ, ଅ଼ଡ଼େ ଜାହାରା ପା଼ପୁତି ମ୍ଣେକ୍‌ହାଲି ବାରେଜା଼ଣା ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁତଲେ ବାପ୍ତିସ୍ମ ଅ଼ଦୁ; ଆତିହିଁଦେଁ ମୀରୁ ସୁଦୁଜୀୱୁତି ଦା଼ନା ବେଟାଆ଼ଦେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଇଚିହିଁ ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାନାୟି ମିଙ୍ଗେତାକି, ଇଞ୍ଜାଁ ମୀ ମୀର୍‌କା ମା଼ସ୍‌କା ତାକି, ଅ଼ଡ଼େ ହେକତି ଏଚେକା ଲ଼କୁ ମା଼ ପ୍ରବୁ ମାହାପୂରୁ ତାନି ତା଼ଣା ହା଼ଟିନେସି, ଏ଼ ବାରେ ଲ଼କୁତାକି ଆ଼ନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଅ଼ଡ଼େ ପିତର ଏ଼ୱାରାଇଁ ହା଼ରେକା କାତାତଲେ ବାତିମା଼ଲିହିଁ ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ଜା଼ପ୍‌ନି ହା଼ଡା ୱେସିହିଁ ସା଼କି ହୀତେସି, “ଈ କୁଟୁଗାଟି କୂଡ଼ାତି ଲ଼କୁଟିଏ ମୀରୁ ଗେଲ୍‌ପି ଆ଼ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ହା଼ରେକା ଲ଼କୁ ଏ଼ୱାଣି ହା଼ଡା ନାମିତେରି ଇଞ୍ଜାଁ ବାପ୍ତିସ୍ମ ଅ଼ତେରି, ଅ଼ଡ଼େ ଏ଼ ଦିନା ବାରେ ତୀନି ମା଼ଣା ଲ଼କୁ କୁଲମି ତଲେ ଆଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଏ଼ ଦିନାଟିଏ ଏ଼ୱାରି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଜା଼ପ୍‌ନି ତା଼ଣା, ଏ଼ୱାରିତଲେ ଆଣ୍ତାନା ରୂଟି ଡ଼ିକ୍‌ହାଲି, ପ୍ରା଼ତାନା କିହାଲି ଆଣ୍ତ୍‌ୱି ଆ଼ହାଁ ଡ଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ତା଼ଣାଟି ହା଼ରେ ହା଼ରେକା କାବାଆ଼ନି କାମା ଇଞ୍ଜାଁ ସିନାୟାଁ ତ଼ଞ୍ଜାଆ଼ହାଲି ମା଼ଟ୍‌ହେ; ଅ଼ଡ଼େ, ଲ଼କୁ ବାରେ ଆଜାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ସାମା ବାରେ ନାମିତାରି, ଏ଼ୱାରି ବାରେଜା଼ଣା ରଣ୍ତିଏ ତା଼ଣା ଡ଼ୟାନା ବାରେ ଦ଼ନତି ବାରେତାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଅ଼ଡ଼େ ଏ଼ୱାରି ଜାହାରା ଦ଼ନତି ଆ଼ସ୍ତି ମାଚାଣି ପା଼ର୍‌ଚାନା, ଆମ୍ବାଆରାକି ଏ଼ନାୟି ଲ଼ଡ଼ାମାନେ, ଏଲେକିହିଁ ବାରେତାକି ବା଼ଟିକିହାଁ ହୀହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଅ଼ଡ଼େ, ଏ଼ୱାରି ରଣ୍ତିଏ ହିୟାଁ ଆ଼ହାଁ ବାରେଦିନା ପ୍ରା଼ତାନା ଇଲୁତା ରୁଣ୍ତା ଆ଼ହାନା ଡ଼ୟିମାଚେରି, ଇଞ୍ଜାଁ ଇଲୁତାକି ଇଲୁ ରୂଟି ଡ଼ିକ୍‌ହିଁ ରା଼ହାଁ ଅ଼ଡ଼େ ହିତ୍‌ଡ଼ି ହିୟାଁ ତଲେ ତିଞ୍ଜି ଉଣ୍ତିହିଁ, ");
INSERT INTO kxv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ମାହାପୂରୁତି ଜହରା କିହିମାଚେରି ଇଞ୍ଜାଁ ବାରେ ଲ଼କୁତି ଜୀୱୁ ନ଼ନାରି ଆ଼ହିମାଚେରି । ଅ଼ଡ଼େ ପ୍ରବୁ ତା଼ଣା ଗେଲ୍‌ପି ଆ଼ହିମାନି ଲ଼କୁଣି ବାରେଦିନା କୁଲମି ତଲେ କାଲ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ପିତର ଅ଼ଡ଼େ ଜହନ ର଼ ଦିନା ପ୍ରା଼ତାନା କିନି କାଟୁତା ଇଚିହିଁ ତୀନି ଗଂଟା ବେ଼ଲାତା ପ୍ରା଼ତାନା ଇଲୁତା ହାଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଏଚିବେ଼ଲାତା ଜାର୍ନାଟିଏ ସଟା ରଅସି ଡେ଼କି କିୱି ଆ଼ହାଁ “ଅ଼ଜିତି” ଦ଼ରୁଗାଟି ଦୁୱେରିତା ଇଟ୍‌ୱି ଆ଼ହିମାଚେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ପ୍ରା଼ତାନା ଇଲୁତା ୱା଼ନି ଲ଼କୁଣି ରୀସିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ଅ଼ଡ଼େ ଏ଼ୱାସି ପିତର ଇଞ୍ଜାଁ ଜହନଇଁ ପ୍ରା଼ତାନା ଇଲୁ ବିତ୍ରା ହାଜିମାନାଣି ମେସାନା ଏ଼ୱାରାଇଁ ରୀସାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର ଅ଼ଡ଼େ ଜହନ ଏ଼ୱାଣାଇଁ ଆଟେ ସିନିକିତେରି, ଇଞ୍ଜାଁ ପିତର ଏଲେଇଚେସି “ମା଼ ୱାକି ସିନିକିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ୱାରି ତା଼ଣାଟି ଇଚାଣି ବେଟାଆ଼ହାଲି ଏ଼ୱାରି ୱାକି ସିନିକିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ସାମା ପିତର ଏଲେଇଚେସି, “ନା଼ ତା଼ଣା ବାଂଗାରା କି ୱେଣ୍ତି ହିଲେଏ, ସାମା ନା଼ ତା଼ଣା ଏ଼ନାୟି ମାନେ ଏ଼ଦାଆଁ ହୀହିମାଞ୍ଜାଇଁ; ନା଼ଜରିତ ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁତଲେ ହୁକୁମି ହୀହିମାଞ୍ଜାଇଁ ନିଙ୍ଗାନା ତା଼କାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଅ଼ଡ଼େ, ଏ଼ୱାସି ଏ଼ୱାଣି ଟିଃନି କେୟୁ ଆସାନା ଏ଼ୱାଣାଇଁ ନିକ୍‌ହେସି, ଏଚେଟିଏ ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣି କଡାୟାଁତି ହାନ୍ଦୁଲିକା ବା଼ଡ଼୍‌ୟୁ ଆ଼ତୁ; ");
INSERT INTO kxv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ଏ଼ୱାସି ଡେ଼ୱିଁ ଡେ଼ୱିଁ ତାନି କଡାତଲେ ନିତେସି, ଅ଼ଡ଼େ ତା଼କାଲି ମା଼ଟ୍‌ହେସି । ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ୱାରିତଲେ ପ୍ରା଼ତାନା ଇଲୁତା ତା଼କହିଁ ଅ଼ଡ଼େ ଡେ଼ୱିହିଁ ଇଞ୍ଜାଁ ମାହାପୂରୁଇଁ ଗାୱୁରମି କିହିଁ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ଏମ୍ବାଆଁ ମାନି ଲ଼କୁ ବାରେ ଏ଼ୱାଣି ତା଼କିନାଣି ଅ଼ଡ଼େ ମାହାପୂରୁତି ଗାୱୁରମି କିହିମାନାଣି ମେସ୍ତେରି; ");
INSERT INTO kxv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଅ଼ଡ଼େ ଆମିନିଗାଟାସି ପ୍ରା଼ତାନା ଇଲୁତି ଅ଼ଜିତି ଦୁୱେରିତା କୁଗାନା ରୀସିମାଚେସି, ଏ଼ୱାସିଏ ଈୱାସି ଇଞ୍ଜିଁ ପୁଚେରି, ଏ଼ୱାଣାକି ଏ଼ନାଆଁ କିୱି ଆ଼ହାମାଚେ ଏ଼ଦାଆଁ ମେସାନା ଆଡାଜାକା ଆ଼ହାନା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଏ଼ୱାସି ପିତର ଇଞ୍ଜାଁ ଜହନ ତଲେ ସଲମନତି ପିଣ୍ତାତା ମାନାଣି ମେସାନା, ବାରେ ଲ଼କୁ ଆଡାଜାକା ଆ଼ହାନା ଏ଼ୱାରି ଡାଗେ ହଟାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର ଏ଼ୱାରାଇଁ ମେସାନା ଏଲେଇଚେସି, “ଇସ୍ରାୟେଲ ଲ଼କୁତେରି, ମୀରୁ ଏ଼ନାଆଁତାକି ଆଡାଜାକା ଆ଼ହିମାଞ୍ଜେରି ? ମା଼ମ୍ବୁ ମା଼ ବା଼ଡ଼୍‌ୟୁ କି ମାହାପୂରୁ ଆଜିତଲେ ଈୱାଣାକି ତା଼କାଲି ବା଼ଡ଼୍‌ୟୁ ହୀହାମାନମି, ଏ଼ଦାଆଁ ଅଣ୍‌ପାନା ମାଙ୍ଗେ ରଣ୍ତିଏ ଅଣ୍‌ପୁ ତଲେ ଏ଼ନାଆଁତାକି ସିନିକିହିମାଞ୍ଜାଦେରି ? ");
INSERT INTO kxv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ, ଇସାହାକ ଅ଼ଡ଼େ ଜାକୁବତି ମାହାପୂରୁ, ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ମାହାପୂରୁ, ତାନି ହ଼ଲେଏସି ଜୀସୁଇଁ ମାହାପୂରୁତି ଗାୱୁରମି ହୀହାମାନେସି । ସାମା ଜୀସୁଇଁ ମୀରୁଏ ସା଼ଲୱି କିନାରି କେୟୁତା ହେର୍‌ପିତେରି, ଏଚିବେ଼ଲା ପିଲାତ ଜୀସୁଇଁ ପିସାଲି ଅଣ୍‌ପା ମାଚିହିଁ ଜିକେଏ, ଏ଼ୱାଣାଇଁ ମୀରୁ ପିଲାତ ନ଼କିତା ଅ଼ପାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ଏ଼ୱାସି ସୁଦୁ ଅ଼ଡ଼େ ଦାର୍ମୁଗାଟାସି ମାଚେସି, ସାମା ମୀରୁ ଏ଼ୱାଣାଇଁ ଅ଼ପାଆତେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣି ଟା଼ୟୁତା ର଼ ଲ଼କୁଣି ପା଼ୟିନାଣାଇଁ ପିସାଲି ପିଲାତଇଁ ବାତିମା଼ଲିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ଆମ୍ବାଆସି ଜୀୱୁତି ଜିରୁ ତ଼ହ୍‌ନାସି ଏ଼ୱାଣାଇଁ ମୀରୁ ପା଼ୟିତେରି; ଏ଼ୱାଣାଇଁ ମାହାପୂରୁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ହାମାନେସି, ମା଼ମ୍ବୁ ଈଦାଣି ସା଼କି । ");
INSERT INTO kxv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଏ଼ୱାଣି ଦ଼ରୁତି ବା଼ଡ଼୍‌ୟୁ ଈ ସଟାଇଁ ନେହିଁ କିହାମାନେ, ମୀରୁ ଏ଼ନାଆଁ ମେସାନା ସାତା ଇଞ୍ଜିଁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ଏ଼ୱାଣି ଦ଼ରୁତଲେ ନାମିତାକି ଆ଼ହାମାନେ । ଜୀସୁଇଁ ନାମିତାକି ଏ଼ୱାସି ନେହିଁ ଆ଼ହାମାନେସି ଈଦାଆଁ ମୀରୁ ମେସାମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଅ଼ଡ଼େ ନୀଏଁ ଇସ୍ରାୟେଲତି ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କାତେରି, ମୀ କାଜାରି ଏ଼ନିକିଁ, ମୀରୁ ଜିକେଏ ଏଲେକିଁ ବୁଦି ହିଲାଆକି ଈଦାଆଁ କିହାମାନେରି ଇଞ୍ଜିଁ ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ତଲି କା଼ଲାଟିଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ମାହାପୂରୁ ୱେସାମାଚେସି ମସିହାତି ଦୁକୁ ପା଼ଣ୍‌ନାୟି ମାନେ; ଏ଼ ବାରେ ଏ଼ୱାସି ଇଲେକିଁ ପୂରା କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ଇଚିହିଁ, ଏ଼ନିକିଁ ମୀ ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନେ, ଏ଼ଦାଆଁତାକି ମ଼ନ ୱେଟ୍‌ହାନା ମାହାପୂରୁ ତା଼ଣା ୱେଣ୍ତା ୱା଼ଦୁ, ");
INSERT INTO kxv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ପ୍ରବୁ ତା଼ଣାଟି ମୀରୁ ଜୀୱୁତି ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ଦେରି, ମାହାପୂରୁ ମିଙ୍ଗେତାକି ତଲିଏ ଆ଼ଚାମାନି ମସିହା ଜୀସୁଇଁ ପାଣ୍ତାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ବାରେ କାତାତି ୱେଣ୍ତେ କିନାଣି ଆମିନି ବେ଼ଲାତି କାତା ତଲି କା଼ଲାଟିଏ ମାହାପୂରୁ ତାନି ସୁଦୁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ୱେ଼କ୍‌ହା ମାଚେସି, ଏ଼ କା଼ଲା ୱା଼ଆ ପାତେକା ଏ଼ୱାଣାକି ସାତେଏ ଲାକପୂରୁ ହାଜାଲି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ମ଼ସା ୱେସାମାଚେସି, ‘ପ୍ରବୁ ମାହାପୂରୁ ମୀ ତାୟିୟାଁ ବିତ୍ରାଟି ମିଙ୍ଗେତାକି ନା଼ ଲେହେଁକି ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଣାଇଁ ନିକ୍‌ନେସି; ଏ଼ନା ଏ଼ନାଆଁ ମିଙ୍ଗେ ୱେସ୍ତାନେସି, ଏ଼ ବାରେ ମୀରୁ ଏ଼ୱାଣି କାତା ୱେଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ଆମିନିଗାଟାସି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ନାମଅରି ଏ଼ୱାରି ମାହାପୂରୁତି ଲ଼କୁ ତା଼ଣାଟି ଏଟ୍‌କା କିୱିଆ଼ନେରି ଅ଼ଡ଼େ ନା଼ସା କିୱିଆ଼ନେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ସାମୁୟେଲ ଇଞ୍ଜାଁ ତାନି ଡା଼ୟୁତି ଏଚରଜା଼ଣା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ୱେସାମାନେରି, ଏ଼ୱାରି ବାରେ ଈ କା଼ଲାତା ଆ଼ହିମାନି କାତା ୱେସାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ମାହାପୂରୁତି ଆ଼ଞ୍ଜାମାନି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ମିଙ୍ଗେତାକି ନେହେଁ, ମାହାପୂରୁ ମୀ ଆକୁ ଆ଼ବାୟାଁ ତଲେ କିତି ରା଼ଜିମା଼ନା ମୀରୁ କିହିମାଞ୍ଜେରି । ଏ଼ନିକିଁ ଏ଼ୱାସି ଅବ୍ରାହାମଇଁ ଏଲେଇଚେସି, ‘ନା଼ନୁ ମୀ କୂଡ଼ାଟି ବାରେ ଦାର୍‌ତିତି ଲ଼କୁକି ବ଼ର ହୀଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ମାହାପୂରୁ ତଲିଏ ତାନି ହ଼ଲେଏଣାଇଁ ମିଙ୍ଗେତାକି ବାଚି କିହାନା ପାଣ୍ତାତେସି, ଏ଼ନିକିଁ ଏ଼ୱାସି ମୀ ବାରେଜା଼ଣା ତେରି ମିଙ୍ଗେ ଲାଗେଏ ଜିରୁଟି ୱେଟ୍‌ହାନା ବ଼ର ହିୟାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର ଅ଼ଡ଼େ ଜହନ ଲ଼କୁ ନ଼କିତା ୱେସିମାଚି ବେ଼ଲାତା ପୂଜେରାଙ୍ଗା, ମାହାପୂରୁ ଇଲୁତି କାଜାରି ଇଞ୍ଜାଁ ସାଦୁକିୟାଁ ଏ଼ୱାରି ନ଼କିତା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ଏ଼ୱାରି କ଼ପା ଆ଼ହିମାଚେରି, ଇଚିହିଁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଲ଼କୁଣି ଜା଼ପ୍‌ହି ମାଚେରି, ଇଞ୍ଜାଁ ଜୀସୁତି କାତା ଆସାନା ହା଼ତାରି ବିତ୍ରାଟି ୱେଣ୍ତେ ନିଙ୍ଗିତି କାତା ୱେ଼କ୍‌ହି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ଏଚିବେ଼ଲା ମିଡ଼୍‌ଅଲା ଆ଼ହିମାଚେ, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ସୀସୁୟାଁଣି ଦସ୍‌ପାନା ଅ଼ର ନେ଼ଚୁ ପାତେକା କାୟିଦି ଇଲୁତା ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ସାମା ଏଚେକା ଲ଼କୁ ବ଼ଲୁ ୱେଚାରି ନାମିତେରି, ଇଞ୍ଜାଁ ୱାର୍‌ଇ ଆ଼ବାୟାଁ ପା଼ସାମା଼ଣା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ତାନି ଅ଼ର ଦିନା ଜୀହୁଦିଙ୍ଗାତି କାଜାରି, ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗା, ଜା଼ପ୍‌ନାରି ଅ଼ଡ଼େ ମେ଼ରାପୁନାରି ଜିରୁସାଲମତା କୂଡ଼ା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ଏମ୍ବାଆଁ କାଜା ପୂଜେରା ହାନାନ, କୟାପା, ଜହନ, ଆଲେକ୍‌ଜାଣ୍ତାରତି କାଜା ପୂଜେରାଙ୍ଗା କୂଡ଼ାତି ବାରେ ଲ଼କୁ କୂଡ଼ା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ଏ଼ୱାରି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ମାଦିଏ ନିପ୍‌ହାନା ୱେଚେରି, “ଏ଼ନିକିହିଁ କିତେରି ? ଏ଼ନି ବା଼ଡ଼୍‌ୟୁ ଇଞ୍ଜାଁ ଆମ୍ବାଆରି ଦ଼ରୁତଲେ ମୀରୁ ଈ ବାରେ କାମା କିହିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ଏମ୍ବାଟିଏ ପିତର ସୁଦୁଜୀୱୁତା ନେଞ୍ଜାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଲ଼କୁତି କାଜାତେରି ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗାତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ନୀଞ୍ଜୁ ମା଼ମ୍ବୁ ସଟାକି କିହାମାନି ନେହିଁ କାମାତାକି ମୀରୁ ୱେଞ୍ଜି ମାଞ୍ଜାଦେରି, ଏ଼ୱାସି ଏ଼ନିକିହିଁ ନେହିଁଆ଼ତେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି, ");
INSERT INTO kxv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ଆତିହିଁ ମୀରୁ ବାରେଜା଼ଣା ତେରି ପୁନିକାତା, ଇସ୍ରାୟେଲତି ବାରେ ଲ଼କୁ ପୁନାୟିମାନେ, ଆମିନି ନା଼ଜରିତ ଜୀସୁ କ୍ରୀସ୍ତଇଁ ମୀରୁ କ୍ରୁସତା ପା଼ୟିତେରି, ଆମ୍ବାଆରାଇଁ ମାହାପୂରୁ ହା଼କିଟି ନିକ୍‌ହାମାନେସି ଏ଼ ଜୀସୁ ଦ଼ରୁଟି ଈ ମାଣ୍‌ସି ନେହିଁ ଆ଼ହାନା ମୀ ନ଼କିତା ନିଚାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜୀସୁ ରଅସିଏ, ଦାର୍ମୁ ସା଼ସ୍ତେରି ୱେସିମାଞ୍ଜାନେ, “ଇଲୁ କେ଼ପିନାତେରି ମୀରୁ, ମୀ ତା଼ଣାଟି ଆମିନି ୱାଲି ଲାଗେଏତାୟି ଆ଼ହାମାଚେ, ସାମା ଆମିନାୟି କନତି କାଜା ୱାଲି ଆ଼ତେ, ଏ଼ୱାସି ଏ଼ ୱାଲି ।” ");
INSERT INTO kxv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ଏ଼ୱାଣି ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆରି ତା଼ଣା ଗେଲ୍‌ପିନାୟି ହିଲେଏ; ଇଚିହିଁ ଆମ୍ବାଆରି ତା଼ଣାଟି ମା଼ର ଗେଲ୍‌ପି ଆ଼ନାୟି ଆ଼ନେ, ହା଼ଗୁ ଡ଼଼ଇ ମାଣ୍‌ସିୟାଁ ବିତ୍ରା ଏ଼ନି ଦ଼ରୁ ହୀପ୍‌କି ଆ଼ହା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ଏ଼ୱାରି ପିତର ଅ଼ଡ଼େ ଜହନତି ସା଼ସା ମେସାନା ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ନାଆଁ ପୁନାଆତାରି ଅ଼ଡ଼େ ବୁଦି ହିଲାଆ ଲ଼କୁ, ଈଦାଆଁ ପୁଞ୍ଜାନା ଆଡାଜାକା ଆ଼ହାହାଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜୀସୁତଲେ ମାଚେରି ଇଞ୍ଜିଁ ପୁଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ସାମା ଏ଼ ନେହିଁ ଆ଼ହାମାଚାସି ଜହନ ଇଞ୍ଜାଁ ପିତର ତଲେ ନିଚାମାଚାଣି ମେସାନା ଏ଼ୱାରି କ଼ପାଟି ଏ଼ନାଆଁ ଜ଼ଲାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ଡା଼ୟୁ ଏ଼ୱାରାଇଁ ବେ଼ରଣି ମାଣ୍ତାଟି ହ଼ଚା ହାଜାଲି ହୁକୁମି ହୀହାନା ଏ଼ୱାରି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ୱେସ୍‌ପି ଆ଼ତେରି ");
INSERT INTO kxv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ଈ ଲ଼କୁଣି ଏ଼ନାଆଁ କିନାୟି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ଇଚିହିଁ ଈୱାରି ତା଼ଣାଟି କାବାଆ଼ନି କାମା କିୱିଆ଼ହାମାନେ, ଈଦି ଜିରୁସାଲମତି ବାରେଜା଼ଣା ନ଼କିତା ତ଼ଞ୍ଜା ଆ଼ହାମାନେ, ଇଞ୍ଜାଁ ମା଼ର ଏ଼ଦାଆଁ ଆ଼ଏ ଇଞ୍ଜାଲି ଆ଼ଡାଆୟି; ");
INSERT INTO kxv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ସାମା ଈ କାତା ଲ଼କୁତା଼ଣା ଏ଼ନିକିଁ ଗାଡି ୱେ଼ଙ୍ଗେଏ, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରାଇଁ ଜୀସୁ ଦ଼ରୁ ଏଚେଲା ଆମ୍ବାଆରି ନ଼କିତା ଆସାଲି ଏ଼ୱାରାଇଁ କା଼ହିକିନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ଡା଼ୟୁ ଏ଼ୱାରି ଜହନ ଅ଼ଡ଼େ ପିତରଇଁ ହା଼ଟାନା ଜୀସୁତି ଦ଼ରୁ ୱେହ୍‌ଆଦୁ କି ଜା଼ପ୍‌ଆଦୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ସାମା ପିତର ଅ଼ଡ଼େ ଜହନ ଏ଼ୱାରାଇଁ ଏଲେଇଚେରି, “ମାହାପୂରୁ କାତା ୱେନିକିହାଁ ମୀ କାତା ୱେନାୟି ମାହାପୂରୁ ନ଼କିତା ନେହେଁ କି ଆ଼ଏ, ଏ଼ଦାଆଁ ମୀରୁ ଅଣ୍‌ପା କଡାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ଇଚିହିଁ ମା଼ମ୍ବୁ ଏ଼ନାଆଁ ମେସାମାନମି ଇଞ୍ଜାଁ ୱେଞ୍ଜାମାନମି, ଏ଼ ବାରେ ୱେହ୍‌ଆନା ଡ଼ୟାଲି ଆ଼ଡଅମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ସାମା ଏ଼ ବେ଼ରଣି ମାଣ୍ତାତାରି ଏ଼ୱାରାଇଁ ଅ଼ଡ଼େ ହା଼ରେକା ଆଜି କିହାନା ପିସ୍ତେରି, ଏ଼ୱାରାଇଁ ଡଣ୍ତ ହୀହାଲି ଆ଼ଏ ଇଞ୍ଜିଁ ଏ଼ୱାରି ପୁଚେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏ଼ କାମାତାକି ଲ଼କୁ ବାରେ ମାହାପୂରୁଇଁ ଜହରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଇଚିହିଁ ଆମିନିଗାଟାଣି ତା଼ଣା କାବାଆ଼ନି ନେହିଁ କାମା କିୱି ଆ଼ହାମାଚେ, ଏ଼ୱାସି ରୀ କ଼ଡ଼ି ବାର୍ସାଟିଏ ଲାକ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର ଅ଼ଡ଼େ ଜହନ ପିସ୍‌ପିଆ଼ତି ଦେବୁଣିଏ ତାମି ତ଼ଣେସିଙ୍ଗା ତା଼ଣା ହାଚେରି ଇଞ୍ଜାଁ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ଏ଼ନାଆଁ ୱେସାମାଚେରି, ଏ଼ ବାରେ ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ଏ଼ୱାରି ଏ଼ଦାଆଁ ୱେଞ୍ଜାନା ରଣ୍ତିଏ ହିୟାଁ ତଲେ ମାହାପୂରୁ ନ଼କିତା କାଜା ହା଼ଡାତଲେ ପ୍ରା଼ତାନା କିହିଁ ଏଲେଇଚେରି, “ପ୍ରବୁ ନୀନୁ ହା଼ଗୁ, ଦାର୍‌ତି, ସାମ୍‌ଦୁରି ଇଞ୍ଜାଁ ଏ଼ ବାରେ ତା଼ଣା ମାନାଣି ବାରେ ଗା଼ଡ଼ି କିହାମାଞ୍ଜି ! ");
INSERT INTO kxv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ସୁଦୁଜୀୱୁ ତଲେ ନୀନୁ ମା଼ ଆକୁ ଦାୱୁଦ ନୀ ହ଼ଲେଏଣା ଗୂତିଟି, ଈ କାତା ୱେସାମାଚି; ‘ଜୀହୁଦିଆ଼ଆତାରି ଏ଼ନାଆଁତାକି କାର୍‌ବି ଆ଼ତେରି; ଇଞ୍ଜାଁ ଲ଼କୁ ଏ଼ନାଆଁତାକି ଉଜେଏତାଣି ଅଣ୍‌ପିତେରି ? ");
INSERT INTO kxv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପ୍ରବୁ ଅ଼ଡ଼େ ତାନି ବ଼ର ବେଟାଆ଼ହାମାନି ମସିହା କ଼ପାଟି, ଦାର୍‌ତିତି ରାଜାୟାଁ ନିଙ୍ଗିତେରି, ଇଞ୍ଜାଁ ସା଼ଲୱି କିନାରି କୂଡ଼ା ଆ଼ତେରି ।’” ");
INSERT INTO kxv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଇଚିହିଁ ନୀ ସୁଦୁଗାଟି ହ଼ଲେଏସି ଜୀସୁଇଁ ବ଼ର ହୀତି, ସାତେଏ ଏ଼ୱାଣି କ଼ପାଟି ହେରଦ ଅ଼ଡ଼େ ପନ୍ତିୟ ପିଲାତ ଈ ରିଆରି ଜୀହୁଦିଆ଼ଆତାରି ଅ଼ଡ଼େ ଇସ୍ରାୟେଲ ଲ଼କୁତଲେ ଈ ଗା଼ଡ଼ାତା ପାରୁ ପାରିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ମୀ ଅଣ୍‌ପୁ ତଲେ ଏ଼ନାୟି ବାରେ ଗଟୱି ଆ଼ନେ ଇଞ୍ଜିଁ ତଲିଟିଏ କିୱି ଆ଼ହାମାଚେ, ଏ଼ଦାଆଁ କିହାଲି କୂଡ଼ା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ଅ଼ଡ଼େ ନୀଏଁ, ଏ଼ ପ୍ରବୁ, ଏ଼ୱାରି ମାଙ୍ଗେ ଆଜି କିହିମାଞ୍ଜାନାଣି ସିନିକିୟାମୁ; ଅ଼ଡ଼େ ନୀ ହ଼ଲିୟାଙ୍ଗାଣି ହା଼ରେକା ସା଼ସାତଲେ ନୀ ବ଼ଲୁ ୱେସାଲି ବା଼ଡ଼୍‌ୟୁ ହୀମୁ, ");
INSERT INTO kxv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ଇଞ୍ଜାଁ ଏ଼ଦାଆଁ ତଲେ ନୀ ସୁଦୁ ହ଼ଲେଏସି ଜୀସୁତି ଦ଼ରୁତଲେ ନେହିଁ କିହାଲି ଅ଼ଡ଼େ ସିନାୟାଁ ଇଞ୍ଜାଁ କାବାଆ଼ନି କାମାୟାଁ କିହାଲିତାକି ନୀ କେୟୁ ଦା଼ସା ଡ଼ୟାମୁ । ");
INSERT INTO kxv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ଏ଼ୱାରି ପ୍ରା଼ତାନା ରା଼ପ୍‌ହି ଡା଼ୟୁ, ଆମିନି ଟା଼ୟୁତା ରୁଣ୍ତା ଆ଼ହାମାଚେରି, ଏ଼ଦି ୱୀଡିତେ । ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ସୁଦୁଜୀୱୁ ତଲେ ନେଞ୍ଜାନା ବା଼ଡ଼୍‌ୟୁ ତଲେ ମାହାପୂରୁତି ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ନାମୁଗାଟି ଲ଼କୁ ରଣ୍ତିଏ ହିୟାଁ ରଣ୍ତିଏ ମ଼ନତଲେ ମାଚେରି; ଏ଼ୱାରି ବିତ୍ରାଟି ଆମ୍ବାଆରି ଜିକେଏ ତାମି ଦ଼ନତି ମା଼ଦି ଇଞ୍ଜିଁ ଅଣ୍‌ପି ହିଲାଆତେରି, ସାମା ଏ଼ୱାରିୱାୟି ବାରେ ସମାନା ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଗାଡି ବା଼ଡ଼୍‌ୟୁ ତଲେ ପ୍ରବୁ ଜୀସୁତି ୱେଣ୍ତେ ନିଙ୍ଗିତି କାତା ୱେସାଲି ମା଼ଟ୍‌ହେରି, ଇଞ୍ଜାଁ ବାରେତି ଲାକ ମାହାପୂରୁତି ହା଼ରେକା କାର୍ମା ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ଇଚିହିଁ ଏ଼ୱାରି ବିତ୍ରା ଆମ୍ବାଆରାକି ଏ଼ନାୟି ଊଣା ଆ଼ହି ହିଲାଆତେ, ଇଚିହିଁ ଏଚେକା ଲ଼କୁତି ବୂମି ଇଞ୍ଜାଁ ଇଲ୍‌କା ମାଚୁ ପାର୍‌ଚି ମାଚେରି ");
INSERT INTO kxv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ଅ଼ଡ଼େ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି କଡାଁ ଡ଼଼ଇକା ଏ଼ ଡାବୁୟାଁ ହୀହିମାଚେରି, ଅ଼ଡ଼େ ବାରେ ଲ଼କୁତାକି ତାମି ଲ଼ଡ଼ାମାନି ଲେହେଁ ଏ଼ ଡାବୁୟାଁ ବା଼ଟିକିୱି ଆ଼ହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","କୁପ୍ର ଇନି ଟା଼ୟୁତା ଜାର୍ନା ଆ଼ହାମାଚି ଲେ଼ବି କୂଡ଼ାତି ଜସେପ, ଆମିନାଣାଇଁ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ବର୍ନବା ଇଞ୍ଜିଁ ମାଚେରି, ଈ ଦ଼ରୁ ଅର୍ତ “ବା଼ର୍ସୁ ହୀନାସି,” ");
INSERT INTO kxv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଏ଼ୱାଣିୱାୟି ଇଚାୟି ବୂମି ମାଚେ, ଏ଼ୱାସି ଏ଼ଦାଆଁ ପା଼ର୍‌ଚାନା ଏମ୍ବାତି ଟାକାୟାଁ ତାଚାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି କଡାୟାଁ ଡ଼଼ଇ ଇଟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନିୟ ଦ଼ରୁଗାଟାସି ରଅସି ମାଚେସି, ଏ଼ୱାସି ତାନି ଡକ୍ରି ସପିରା ତଲେ ଇଚାଣି ବୂମି ପାର୍‌ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ହନନିୟ ତାନି ଡକ୍ରି ତଲେ ଏ଼ ଟାକାୟାଁ ବିତ୍ରାଟି କଚେକା ଡ଼ୁକ୍‌ହା ଇଟାନା କଚେକା ତାଚାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାକି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ହନନିୟ, ସୁଦୁଜୀୱୁ ନ଼କିତା ମିଚି ଜ଼ଲାଲି ଇଞ୍ଜାଁ ବୂମି ପାର୍‌ଚାନା କଚେକା ଡ଼ୁକ୍‌ହା ଇଟାଲି ସୟତାନ ଏ଼ନାଆଁତାକି ମୀ ହିୟାଁତି ଲକ୍‌ହାମାନେ ? ");
INSERT INTO kxv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ପା଼ର୍‌ନି ନ଼କେଏ ଏ଼ଦି ନୀ ଅଦିକାରାତା ହିଲାଆତେ କି ? ପା଼ର୍‌ତି ଡା଼ୟୁ ଜିକେଏ ଏମ୍ବାତି ଟାକାୟାଁ ଜିକେଏ ନୀୱି ଆ଼ହାହିଲାଆତୁ କି ? ଆତିହିଁ ନୀନୁ ଏ଼ନିକିଁ ନୀ ହିୟାଁତା ଈ ଅଣ୍‌ପୁ ଅଣ୍‌ପିତି ? ଏ଼ଦାଆଁ ନୀନୁ ମାଣ୍‌ସି ନ଼କିତା ମିଚି ଜ଼ଲିମାଞ୍ଜି ଏ଼ଦି ଆ଼ଏ, ସାମା ମାହାପୂରୁ ନ଼କିତା ମିଚି ଜ଼ଲାମାଞ୍ଜି !” ");
INSERT INTO kxv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ହନନିୟ ଈ ହା଼ଡା ୱେଣ୍‌ମ୍ବନିଏ ଡ଼଼ଇ ତର୍‌ଗାନା ହା଼ହାହାଚେସି; ଏମ୍ବାଆଁ ଏଚେକା ଲ଼କୁ ଈ କାତା ୱେଚେରି, ଏ଼ୱାରି ବାରେ ହା଼ରେକା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଅ଼ଡ଼େ, ଦାଂଗ୍‌ଣାୟାଁ ବିତ୍ରା ୱା଼ହାନା ହିମ୍ବରି ପ୍ଡୀକ୍‌ହେରି ଇଞ୍ଜାଁ ପାଙ୍ଗାତା ଅ଼ହାନା ମାହ୍‌ଣି ମାଣ୍ତାତା ମୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ତୀନି ଗଂଟା ଡା଼ୟୁ ତାନି ଡକ୍ରି ୱା଼ତେ, ସାମା ଏ଼ନାଆଁ ଆ଼ହାମାନେ, ଏ଼ଦାଆଁ ଏ଼ଦି ପୁଞ୍ଜା ହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର ଏ଼ଦାନି ୱେଚେସି, “ନୀନୁ ଅ଼ଡ଼େ ନୀ ଡକ୍ରା ଇଚେକା ଟାକାୟାଁତାକି କି ମୀ ବୂମି ପା଼ର୍‌ତେରି ?” ଏ଼ଦି ଏଲେଇଚେ, “ହାଅ ଏଚେକା ତାକିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ପିତର ଏ଼ଦାନି ଏଲେଇଚେସି, “ପ୍ରବୁତି ଜୀୱୁତି ତାୟିପାରି କିହାଲି ମୀରୁ ଏ଼ନାଆଁତାକି ରଣ୍ତିଏ କାତା ଆ଼ତେରି ? ମେହ୍‌ମୁ ଆମିନି ଗାଟାରି ନୀ ଡକ୍ରାଇଁ ମୁସାନା ୱା଼ହିମାନେରି, ଏ଼ୱାରି ଦୁୱେରିତା ୱା଼ତେରିଏ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ନିଙ୍ଗେ ପାଙ୍ଗାତା ଡେ଼କା ଅୟାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ଏ଼ କାତା ୱେଣ୍‌ମ୍ବନିଏ ଏ଼ଦି ପିତର କଡାଁ ଡ଼଼ଇ ତର୍‌ଗାନା ହା଼ହାହାଚେ, ଇଞ୍ଜାଁ ଦାଂଗ୍‌ଣାୟାଁ ବିତ୍ରା ୱା଼ହାନା ହା଼ହାମାନାଣି ମେସ୍ତେରି ଇଞ୍ଜାଁ ପାଙ୍ଗାତା ଡେ଼କା ଅ଼ହାନା ତାନି ଡକ୍ରା ଟଟତା ମୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ଏମ୍ବାଟିଏ ବାରେ କୁଲମି ଇଞ୍ଜାଁ ଏଚେକା ଲ଼କୁ ଈ ବାରେ କାତା ୱେଚେରି, ଏ଼ୱାରି ବାରେ ହା଼ରେକା ଆଜିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ତା଼ଣାଟି ହା଼ରେକା କାବାଆ଼ନି କାମାୟାଁ ଅ଼ଡ଼େ ସିନାୟାଁ ଆ଼ହାଲି ମା଼ଟ୍‌ହେ, ଇଞ୍ଜାଁ ବାରେ ନାମିତାରି ରଣ୍ତିଏ ଅଣ୍‌ପୁ ତଲେ ସଲମନତି ପିଣ୍ତାତା କୂଡ଼ା ଆ଼ହିମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ସାମା ଏଟ୍‌କାତି ଲ଼କୁ ଆମ୍ବାଆରି ଏ଼ୱାରିତଲେ କୂଡ଼ାଲି ସା଼ସା କିହିହିଲାଆତେରି; ଆ଼ତିଜିକେଏ ଲ଼କୁ ଏ଼ୱାରି ଗାୱୁରମି କିହିମାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ଇଞ୍ଜାଁ, ହା଼ରେ ହା଼ରେକା ଇୟାସିକା ଅ଼ଡ଼େ ଆ଼ବାୟାଁ ନାମାହାଁ ପ୍ରବୁ ତା଼ଣା କୂଡ଼ାଲି ଆଣ୍ତିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି କାମା ଦିନାତାକି ଦିନା ପାଡାଆ଼ତେ, ଇଲାଆ଼ହିଁ, କି ପିତର ୱା଼ନି ବେ଼ଲାତା ଏ଼ନିକିଁ ତାନି ସା଼ୟିଁ ର଼ଗ ଗାଟାରି ଲାକ ଆ଼ଡିନେ, ଏ଼ଦାଆଁତାକି ର଼ଗ ଗାଟାରାଇଁ ଆଂଗେଣିତା ଡେ଼କା ତାଚାନା କାଟେଲି ଇଞ୍ଜାଁ ପା଼ସ୍‌ପନିତା ଇଟିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲମତି ସା଼ରିସୁଟୁ ଗା଼ଡ଼ାୟାଁତି ହା଼ରେକା ଲ଼କୁ ର଼ଗ ଗାଟାରାଇଁ ଅ଼ଡ଼େ ବୂତୁୟାଁ ଆଲ୍‌ଗିତାରାଇଁ ତାଚିହିଁ ୱା଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାରି ବାରେଜା଼ଣା ନେହିଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ଏଚେଟିଏ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ଏ଼ୱାଣି ବାରେ ତ଼ଡ଼ୁ ଲ଼କୁ, ନା଼ୟୁଁତି ସାଦୁକିୟାଁ ଗଚିତାରି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ଡା଼ହାରା ଆ଼ହାନା ଏ଼ୱାରି କ଼ପାଟି ନିଙ୍ଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଏ଼ୱାରି ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ଆସାନା କାୟିଦି ଇଲୁତା ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ସାମା ଲା଼ଆଁୟାଁ ବେ଼ଲାତା ପ୍ରବୁତି ର଼ ଦୂତୁ କା଼ୟିଦି ଇଲୁତି ଦା଼ରାୟାଁ ବାରେ ଦେଚାତୁସ୍ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ପାଙ୍ଗାତା ତାଚାନା ଏଲେଇଚେ, ");
INSERT INTO kxv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ହାଜୁ, ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା ନିଚାନା ଲ଼କୁଣି ଈ ଜୀୱୁତି ବାରେ କାତା ୱେହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ଈ କାତା ୱେଞ୍ଜାନା ଏ଼ୱାରି ଲା଼ଇଅଲି ମାହାପୂରୁ ଇଲୁତା ହ଼ଡାନା ଜା଼ପ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ଏମ୍ବାଟିଏ କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ତାମି ତ଼ଣେସିଙ୍ଗା ୱା଼ହାନା କୁଟମିତି କାଜାରାଇଁ ଅ଼ଡ଼େ ଇସ୍ରାୟେଲ ଲ଼କୁତି ପ୍ରାଚିନାଙ୍ଗାଣି ହା଼ଟାନା କୂଡ଼ି କିତେରି; ଇଞ୍ଜାଁ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ତାଚାଲି କାୟିଦି ଇଲୁତା ଲ଼କୁଣି ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ସାମା କାମାକିନାରି ହାଜାନା କା଼ୟିଦି ଇଲୁତା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ବେଟାଆ଼ଆନା ୱେଣ୍ତା ୱା଼ହାନା ବେ଼ରଣି ମାଣ୍ତାତାରାଇଁ ୱେସ୍ତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ମା଼ମ୍ବୁ କାୟିଦି ଇଜ ହାଜାନା ସିନିକିତମି, କାୟିଦି ଇଲୁ ଦା଼ରା ଆ଼ଟ୍‌ୱା ତଲେ ସୁଣ୍ଡ୍‌ୱିଆ଼ହାମାଚେ; ଇଞ୍ଜାଁ ଦୁୱେରିକାଣା କା଼ଚାମାଚି କ଼ସ୍‌କା ନିଚାମାଚେରି, ସାମା ଦା଼ରା ଦେଚାଲିଏ ବିତ୍ରା ଆମ୍ବାଆରାଇଁ ଜିକେଏ ବେଟାଆ଼ଆତମି !” ");
INSERT INTO kxv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଈ ହା଼ଡା ୱେଞ୍ଜାନା କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ମାହାପୂରୁ ଇଲୁତି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାକି ଏ଼ନାଆଁ ଆ଼ତେ ଅଣ୍‌ପାନା ଏ଼ୱାରି କାତାତା ଆଡାଜାକା ଆ଼ହାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଏଚିବେ଼ଲା ରଅସି ୱା଼ହାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ମେହ୍‌ଦୁ ମୀରୁ ଆମିନି ଗାଟାରାଇଁ କା଼ୟିଦି ଇଲୁତା ଇଟାମାଚେରି, ଏ଼ୱାରି ମାହାପୂରୁ ଇଲୁତା ଜା଼ପ୍‌ହିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ଏଚେଟିଏ କ଼ସ୍‌କା ମୁହେଁ କାଜାସି, କାମାକିନାରି ତଲେ ହାଜାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ୱେଣ୍ଡେ ହା଼ଟା ତାତେରି, ସାମା ବା଼ଡ଼୍‌ୟୁ ତଲେ ଆ଼ଏ, ଇଚିହିଁ ଲ଼କୁ ୱାଲ୍‌କାତଲେ ୱେ଼ତାନେରି ଜିକେଏ ଇଞ୍ଜିଁ ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ତାଚାନା କୁଲମି ପାଙ୍ଗାତା ନିପ୍‌ହେରି, ଏମ୍ବାଟିଏ କାଜା ପୂଜେରା ଏ଼ୱାରାଇଁ ୱେଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଈ ମାଣ୍‌ସି ଦ଼ରୁତଲେ ଆମ୍ବାଆରାଇଁ ଜିକେଏ ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ଜାଣ୍ଡେ ହୁକୁମି ହୀହାମାଞ୍ଜାତମି, ସାମା ସିନିକିଦୁ, ମୀରୁ ଏ଼ନାଆଁ କିହାମାଞ୍ଜେରି ! ଜିରୁସାଲମତି ସା଼ରିୱାକି ମୀରୁ ଏ଼ କାତା ଜା଼ପ୍‌ହି ମାଞ୍ଜେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ନେତେରିତି ଦ଼ହ ମା଼ ମୁହେଁ ଏକ୍‌ହାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ସାମା ପିତର ଇଞ୍ଜାଁ ଏଟ୍‌କାତି ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଏଲେଇଚେରି, “ମାଣ୍‌ସିୟାଁତି ହୁକୁମି ମା଼ନି କିନି କିହାଁ ମାହାପୂରୁତି ହୁକୁମି ମା଼ନି କିନାୟିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଆମିନି ଜୀସୁଇଁ ମୀରୁ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟାମାଚେରି, ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ୱେଣ୍ତେ ନିକ୍‌ହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ନିକିଁ ଇସ୍ରାୟେଲତି ମ଼ନ ୱେଟ୍‌ପି କିହାଁ ପା଼ପୁ ମେଣ୍‌ଙ୍ଗି କିନେସି, ଏ଼ଦାଆଁତାକି ମାହାପୂରୁ ତାନି ଟିଃନି କେୟୁତଲେ ଏ଼ୱାଣାଇଁ କାଜାପା଼ଣା ଇଞ୍ଜାଁ ଗେଲ୍‌ପିନାଣା ଲେହେଁ କାଜାସି କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଅ଼ଡ଼େ, ମା଼ମ୍ବୁ ଈ ବାରେତି ସା଼କି, ଇଞ୍ଜାଁ ଆମିନି ସୁଦୁଜୀୱୁଇଁ ମାହାପୂରୁ ତାନି ହୁକୁମି ମା଼ନୱି ଆ଼ନାରାକି ହୀହାମାଞ୍ଜାନେସି, ଏ଼ଦି ଜିକେଏ ସା଼କି ।” ");
INSERT INTO kxv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ଈ କାତା ୱେଞ୍ଜାନା କୁଟମିତି କାଜାରି ହା଼ରେକା କାର୍‌ବି ଆ଼ହାହାଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ପା଼ୟାଲି ତାକି କାତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ସାମା ଗମଲିୟେଲ ଦ଼ରୁଗାଟି ର଼ ମା଼ନିଗାଟି ପାରୁସି, ଆମିନିଗାଟାସି ମ଼ସାତି ମେ଼ରା ଜା଼ପ୍‌ନାସି ମାଚେସି, ଏ଼ୱାସି ବେ଼ରଣିମାଣ୍ତାତା ନିଚାନା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ଗା଼ଡ଼େକା ତାକି ପାଙ୍ଗାତା ପାଣ୍ତାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି “ଏ଼ ଇସ୍ରାୟେଲ ଲ଼କୁତେରି, ଈୱାରି ତାକି ମୀରୁ ଏ଼ନାଆଁ କିହାଲି ଅଣ୍‌ପିମାଞ୍ଜେରି, ଏ଼ କାତାତା ଜାଗ୍ରାତା ଆ଼ହାମାଞ୍ଜୁ । ");
INSERT INTO kxv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଇଚିହିଁ ଈଦାଆଁ ନ଼କେଏ ତିୱୁଦା ଇନାସି ହ଼ଚାନା ତା଼ନୁ ର଼ କାଜା ମାଣ୍‌ସି କିହା କଡିତେସି, ଇଞ୍ଜାଁ ସା଼ରି ୱାଞ୍ଜା ଲ଼କୁ ଏ଼ୱାଣିତଲେ ଆଣ୍ତିତେରି; ଏ଼ୱାସି ପା଼ୟ୍‌ୱି ଆ଼ତେସି, ଇଞ୍ଜାଁ ଏଚେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ବା଼ର୍ସୁ କିହାମାଚେରି, ଏ଼ୱାରି ବାରେ ଇତାଲା ଆତାଲା ଆ଼ହାଁ ଏ଼ନି କାମାତା ହୀଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ଏ଼ ଲ଼଼କୁତି ଜେ଼ଚ ଲ଼କୁଣି ଏଜିକିନି ବେ଼ଲାତା ଗାଲିଲିତି ଜୀହୁଦା ଇନାସି ହ଼ଚାନା ଲ଼କୁଣି ତାନି ୱାକି ରେଜା ଅ଼ହାନା ତାନି ସୀସୁୟାଁ କିତେସି; ଏ଼ୱାସି ଜିକେଏ ପା଼ୟ୍‌ୱି ଆ଼ତେସି, ଇଞ୍ଜାଁ ଏଚେକା ଲ଼କୁ ଏ଼ୱାଣି ଜେ଼ଚ ଆଣ୍ତାମାଚେରି, ଏ଼ୱାରି ବାରେ ଇତାଲା ଆତାଲା ଆ଼ହାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଇଞ୍ଜାଁ ନୀଏଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ମୀରୁ ଈ ଲ଼କୁଣି ଏ଼ନାଆଁ କିଆନା ଏ଼ୱାରାଇଁ ପିସାତୁହ୍‌ଦୁ, ଇଚିହିଁ ଈ କାତା କି କାମା ମାଣ୍‌ସି ତା଼ଣାଟି ଆ଼ହାମାନେ, ଇଚିହିଁ ଏ଼ଦି ଉଜେଏ ଆ଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ସାମା ଏ଼ଦି ମାହାପୂରୁ ତା଼ଣାଟି ଆ଼ହାମାନେ, ଇଚିହିଁ ମୀରୁ ଏ଼ୱାରାଇଁ ଜୀଣା ଆ଼ନି ସା଼ସା ହିଲେଏ, ଇଚିହିଁ ମୀରୁ ମାହାପୂରୁ କ଼ପାଟି ଜୁଜୁ କିହିମାଞ୍ଜେରି ଇଞ୍ଜିଁ ତ଼ଞ୍ଜା ଆ଼ଦେରି !” ଏ଼ ବାରେ କୁଟମି ଗମଲିୟେଲ କାତାତି ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ଇଞ୍ଜାଁ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରାଇଁ ବିତ୍ରା ହା଼ଟାନା ସା଼ଟ୍‌ଣି ମା଼ଡା ୱେ଼ଚାନା ଜୀସୁ ଦ଼ରୁତି କାତା ୱେହ୍‌ଆଦୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀହାନା ପିସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ମାହାପୂରୁ ନ଼କିତା ଏ଼ୱାରି ଜୀସୁ ଦ଼ରୁ ତାକି ଲାଜା ବେଟାଆ଼ହାଲି ଜ଼ଗେ ଇଞ୍ଜିଁ ଅଣ୍‌ପାମାଚେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ରା଼ହାଁ କିହିଁ କୁଟମି ବିତ୍ରାଟି ହ଼ଚାୱା଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଅ଼ଡ଼େ, ଏ଼ୱାରି ଦିନାତାକି ଦିନା ମାହାପୂରୁ ଇଲୁତା ଇଞ୍ଜାଁ ଇଲୁତାକି ଇଲୁ ଜା଼ପ୍‌ହାଲି ଇଞ୍ଜାଁ ଜୀସୁଏ ମସିହା, ଈ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି ଊଣା ଆ଼ଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ହା଼ରେ ହା଼ରେକା ଜା଼ଣା ଆ଼ହାଲି ମା଼ଟ୍‌ହେରି, ଗ୍ରିକ୍‌ ଜ଼ଲିନି ଜୀହୁଦି ଲ଼କୁ ଏବ୍ରି ଜ଼ଲିନି ନାମିତି ଲ଼କୁଣି ଲାଜା କିହାଲି ମା଼ଟ୍‌ହେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଦିନାତାକି ଦିନା କା଼ଦିକଣ୍ଡା ବା଼ଟିକିନି ବେ଼ଲାତା ରା଼ଣ୍ତେଣିସିକାକି ହୀହି ହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ଏମ୍ବାଟିଏ ବା଼ରଜା଼ଣା ସୀସୁୟାଁ ବାରେ ନାମିତି ଲ଼କୁଇଁ ର଼ ତା଼ଣା କୂଡ଼ି କିହାନା ଏଲେଇଚେରି, “ମାହାପୂରୁତି ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ପିସାହାଁ ବା଼ଟି କିହାଲି ହିକିତିହିଁ ନେହେଁ ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଈଦାଆଁତାକି ଏ଼ ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା, ମୀ ବିତ୍ରାଟି ନେହାଁରି ଇଞ୍ଜାଁ ୱେ଼ଙ୍ଗିତି ସୁଦୁଜୀୱୁ ତଲେ ନେଞ୍ଜାମାନି ବୁଦିଗାଟି ସା଼ତା ଜା଼ଣାଇଁ ଆ଼ଚାଦୁ, ଏ଼ୱାରାକି ଈ ବା଼ଟିକିନି କାମା ହେର୍‌ପାଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ଆତିହିଁ ମା଼ମ୍ବୁ ପ୍ରା଼ତାନାତା ଇଞ୍ଜାଁ ବ଼ଲୁ ୱେହ୍‌ନି ସେ଼ବା କାମାତା ରଣ୍ତିଏ ଅଣ୍‌ପୁ ତଲେ ଡ଼ୟିନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଈ କାତା ବାରେ ଲ଼କୁତି କାନୁତା ନେହିଁ ତ଼ଞ୍ଜାଆ଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ନାମୁ ଅ଼ଡ଼େ ସୁଦୁଜୀୱୁତା ନେଞ୍ଜାମାନି ସ୍ତିପାନ ଦ଼ରୁ ଗାଟାଣାଇଁ ଇଞ୍ଜାଁ ପିଲିପ, ପ୍ରକର, ନିକାନର, ତିମନ, ପାର୍ମନା, ଅ଼ଡ଼େ ଆନ୍ତିୟକିୟାତି ତଲି ଜୀହୁଦି ଦାର୍ମୁତା ଆଣ୍ତାମାଚି ନିକଲାୟଇଁ ଆ଼ଚିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ତା଼ଣା ତାତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଲାକ କେସ୍କା ଇଟାନା ପ୍ରା଼ତାନା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଏଚେଟିଏ ମାହାପୂରୁତି ବ଼ଲୁ ହା଼ରେକା ୱେ଼ଙ୍ଗିତେ, ଇଞ୍ଜାଁ ଜିରୁସାଲମତା ସୀସୁୟାଁ ହା଼ରେକା ପାଡାଆ଼ହାଲି ମା଼ଟ୍‌ହେରି; ଅ଼ଡ଼େ ପୂଜେରାଙ୍ଗା ବିତ୍ରାଟି ହା଼ରେକା ଜା଼ଣା କ୍ରୀସ୍ତଇଁ ନାମାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ସ୍ତିପାନ ମାହାପୂରୁତି କାର୍ମା ଇଞ୍ଜାଁ ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ହାନା ଲ଼କୁ ବିତ୍ରା କାଜା କାଜା କାବାଆ଼ନି କାମା ଅ଼ଡ଼େ ସିନାୟାଁ କିହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ସାମା ଲିବର୍ତନ, କୁରିଣି ଅ଼ଡ଼େ ଆଲେକ୍‌ଜାଣ୍ତ୍ରିୟା ଗା଼ଡ଼ାୟାଁଣା ବାସା କିହାମାନି ଦ଼ରୁତା ୱେ଼ଙ୍ଗାମାନି ଜୀହୁଦି ଲ଼କୁତି ପ୍ରା଼ତାନା ଇଲୁତି ଏଚେକା ଲ଼କୁ ଅ଼ଡ଼େ କିଲିକିୟା ଇଞ୍ଜାଁ ଆସିୟା ଦେ଼ସାତି ଏଟ୍‌କା ଜୀହୁଦିଙ୍ଗା ନିଙ୍ଗାନା ସ୍ତିପାନ ତଲେ ବା଼ଦିବା଼ଦା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ସାମା ଏ଼ୱାସି ଆମିନି ସୁଦୁଜୀୱୁ ଅ଼ଡ଼େ ବୁଦିତଲେ ଜ଼ଲିମାଚେସି, ଏ଼ୱାରି ଏ଼ କାତାତି ୱେଣ୍ତେ ଜ଼ଲାଲି ସା଼ସା କିହିହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ଏଚେଟିଏ ଏ଼ୱାରି ଏଚରଜା଼ଣାତି ମା଼ତୱି କିହାନା ଏଲେଇଞ୍ଜି ୱେସାଲି ଜା଼ପ୍‌ହେରି, “ମା଼ମ୍ବୁ ଈୱାଣି ତା଼ଣାଟି ମ଼ସା ଅ଼ଡ଼େ ମାହାପୂରୁ ନିନ୍ଦା କାତା ଜ଼ଲିମାଚାଣି ୱେଞ୍ଜାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଅ଼ଡ଼େ, ଏ଼ୱାରି ବାରେ ଲ଼କୁଣି, ଇଞ୍ଜାଁ ପ୍ରାଚିନାଙ୍ଗାଣି ଅ଼ଡ଼େ ମେ଼ରା ପୁନାରାଇଁ କାର୍‌ବି କିହାନା ଏ଼ୱାଣାଇଁ ବା଼ଡ଼୍‌ୟୁ ତଲେ ଆସାନା ବେ଼ରଣିମାଣ୍ତାତା ତାତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ଇଞ୍ଜାଁ ମିଚି ସା଼କି ହୀନାରାଇଁ ନିପ୍‌ହାନା; ଏ଼ୱାରାଇଁ ଏଲେଇଚେରି, “ଈୱାସି ଈ ସୁଦୁ ପ୍ରା଼ତାନା ଇଲୁ ଇଞ୍ଜାଁ ମ଼ସା ମେ଼ରାତି କ଼ପାଟି ଜ଼ଲାଲି ଊଣା ଆ଼ହିହିଲଅସି, ");
INSERT INTO kxv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ଇଚିହିଁ ନା଼ଜରିତ ଜୀସୁ ମାହାପୂରୁ ଇଲୁତି ମ୍ଣେକ୍‌ନେସି, ଇଞ୍ଜାଁ ମ଼ସା ମାଙ୍ଗେ ଆମିନି ମେ଼ରା ହୀହାମାଞ୍ଜାନେସି, ଏ଼ ବାରେ ତିରିମ୍ଣିପ୍‌ନେସି ଇଞ୍ଜିଁ ୱେସିମାଚାଣି ମା଼ମ୍ବୁ ୱେଞ୍ଜାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ଏଚିବେ଼ଲା ବେ଼ରଣିମାଣ୍ତାତା କୁଗାମାଚି ବାରେ ଲ଼କୁ ସ୍ତିପାନଇଁ ଆଟେ ସିନିକିତେରି, ଏ଼ୱାଣି ମୂମ୍ବୁ ଦୂତୁତି ମୂମ୍ବୁ ଲେହେଁ ଉଜେଡ଼ି ତ଼ଞ୍ଜାଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ଏଚେଟିଏ କାଜା ପୂଜେରା ସ୍ତିପାନଇଁ ୱେଚେସି, “ଈ ବାରେ କାତା ସାତା କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିପାନ ଏଲେଇଚେସି, “ତାୟିୟାଁ ଅ଼ଡ଼େ ଆ଼ବାୟାଁତେରି ୱେଞ୍ଜୁ ! ମା଼ ଆ଼ବା ଅବ୍ରାହାମ ହାରଣତା ବାସାଆ଼ନି ନ଼କେଏ ଏଚିବେ଼ଲା ଏ଼ୱାସି ମେସପଟାମିୟାଁ ଦେ଼ସାତା ମାଚେସି, ଏଚିବେ଼ଲା ଗାୱୁରମିଗାଟି ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ତ଼ଞ୍ଜାଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଅ଼ଡ଼େ ଏଲେଇଚେସି ‘ନୀନୁ ମୀ ଇଲୁ କୁଟମି ଇଞ୍ଜାଁ ମୀ ଦେ଼ସାଟି ହ଼ଚା ୱା଼ମୁ, ଇଞ୍ଜାଁ ନା଼ନୁ ଆମିନି ଦେ଼ସା ତ଼ସ୍ତାଇଁ ଏ଼ ଦେ଼ସାତା ହାଲାମୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ଏଚେଟିଏ ତାନି କଲ୍‌ଦିୟୟାଁ ଦେ଼ସାଟି ହ଼ଚାୱା଼ହାନା ହାରଣତା ବାସା କିତେସି, ଇଞ୍ଜାଁ ଅବ୍ରାହାମତି ଆ଼ବା ହା଼ତି ଡା଼ୟୁ ଏମ୍ବାଟିଏ ମୀରୁ ନୀଏଁ ଆମିନି ଦେ଼ସାତା ବାସା କିହାମାଞ୍ଜେରି, ମାହାପୂରୁ ଏ଼ ଦେ଼ସାତା ଏ଼ୱାଣାଇଁ ତାଚିହିଁ ୱା଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଅ଼ଡ଼େ, ମାହାପୂରୁ ଅବ୍ରାହାମକି ଏମ୍ବାଆଁ ଏ଼ନି ଅଦିକାରା ହୀଆତେସି, ଅ଼ଡ଼େ ର଼ ପା଼ୱୁଲି ୱିହ୍‌ନି ବୂମିଗାରି ଜିକେଏ ହୀଆତେସି, ଇଞ୍ଜାଁ ଏଚିବେ଼ଲା ଏ଼ୱାଣାକି ପ଼ଦି ପ଼ଦା ହିଲାଆତି ଜିକେଏ ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ଇଞ୍ଜାଁ ତାନି ୱା଼ହିମାନି କୂଡ଼ାତାରିକି ଏ଼ଦାଆଁ ଅଦିକାରା କିହାଲିତାକି ହୀଇଁ ଇଞ୍ଜିଁ ଆ଼ଞ୍ଜିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲେଇଞ୍ଜିଁ ୱେସ୍ତେସି, ‘ତାନି କୂଡ଼ାତାରି ଏଟ୍‌କା ଦେ଼ସାତା ବାସା କିନେରି ଇଞ୍ଜାଁ ଏ଼ ଟା଼ୟୁତି ଲ଼କୁ ଏ଼ୱାରାଇଁ ସା଼ରି ୱାଞ୍ଜା ବାର୍ସା ପାତେକା ହ଼ଲିୟାଙ୍ଗା କିହାଁ ଏ଼ୱାରାଇଁ ୱେଟି କାମା କିୱି କିହାନା ସା଼ସ୍ତି ହୀନେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ଅ଼ଡ଼େ ମାହାପୂରୁ ଏଲେଇଚେସି, ନା଼ନୁ ଏ଼ୱାରାଇଁ ହ଼ଲିୟା କାମା କିୱିକିନାରାଇଁ ବିଚାରା କିଇଁ; ଅ଼ଡ଼େ ଡା଼ୟୁ ମୀ କୂଡ଼ାତାରି ଏ଼ ଦେ଼ସାଟି ହ଼ଚା ୱା଼ନେରି ଅ଼ଡ଼େ ଈ ଟା଼ୟୁତା ନାଙ୍ଗେ ପ୍ରା଼ତାନା କିୟାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ଅ଼ଡ଼େ ମାହାପୂରୁ ଅବ୍ରାହାମକି ତ଼ଲୁ ଦା଼ଃନି ରା଼ଜିମା଼ନା ସିନାତି ହୀତେସି, ଇଞ୍ଜାଁ ଏଲେକିହିଁଏ ଅବ୍ରାହାମ ଇସାହାକଇଁ ଜାର୍ନି କିହାନା ଆ଼ଟାଦିନା ଆ଼ହାଲିଏ ଏ଼ୱାଣି ତ଼ଲୁ ଦା଼ତେସି; ଇସାହାକ ଜାକୁବଇଁ, ଅ଼ଡ଼େ ଜାକୁବ ବା଼ରଜା଼ଣା ୱେ଼ଙ୍ଗିତି ଆକୁ ଆ଼ବାୟାଁଣି ଜାର୍ନି କିହାନା ତ଼ଲୁ ଦା଼ପିକିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବ ମୀର୍‌ଏସି ଜସେପଇଁ ତାମି ତାୟିୟାଁ ଡା଼ହାରା ଆ଼ହାନା ମିସର ଦେ଼ସାତା ଅ଼ୱିଆୟାଲି ଏ଼ୱାଣାଇଁ ପା଼ର୍‌ତେରି; ସାମା ମାହାପୂରୁ ଏ଼ୱାଣିତଲେ ମାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଅ଼ଡ଼େ ବାରେ କସ୍ତଟି ଜସେପଇଁ ଗେଲ୍‌ପାହାଁ ମିସରତି ପା଼ର ରାଜା ନ଼କିତା ମାହାପୂରୁ କାର୍ମା ତ଼ସାହାଁ ବୁଦି ହୀତେସି; ଏମ୍ବାଟିଏ ପା଼ର ଜସେପଇଁ ମିସର ଦେ଼ସା ଇଞ୍ଜାଁ ତାମି ଇଲୁତି ସା଼ଲୱି କିହାଲି ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ଡା଼ୟୁ ମିସର ଇଞ୍ଜାଁ କିଣାନ ଦେ଼ସାତା କାର୍‌ୱୁ କା଼ତାରା ଆ଼ତେ, ଲ଼କୁ ହା଼ରେକା କସ୍ତ ଆ଼ତେରି, ମା଼ ଆକୁ ଆ଼ବାୟାଁ ତିଞ୍ଜାଲି କା଼ଦିକଣ୍ଡା ବେଟାଆ଼ଆତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ସାମା ମିସର ଦେ଼ସାତା ଆର୍ନା ମାନେ ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା, ଜାକୁବ ତାନି ମୀର୍‌କା ଇଚିହିଁ ମା଼ ଆକୁ ଆ଼ବାୟାଁଣି ତଲିଏ ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ଏ଼ୱାରି ଅ଼ର ଦେବା ହାଜାଲିଏ ଜସେପ ତାନି ତାୟିୟାଁ ତା଼ଣା ପୁଣ୍‌ମ୍ବି କିହା କଡିତେସି, ଇଞ୍ଜାଁ ମିସରତି ରାଜା ପା଼ର ଜସେପ କୂଡ଼ାତାରି ଇଞ୍ଜିଁ ପୁଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ଏମ୍ବାଟିଏ ଜସେପ ତାମି ଆ଼ବା ଜାକୁବ ଇଞ୍ଜାଁ ତୀନିକ଼ଡ଼ି ପନ୍ଦର ଜା଼ଣା ତାମି କୁଟମିତି ହା଼ଟାଲି ପାଣ୍ତିତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଏମ୍ବାଟିଏ ଜାକୁବ ମିସର ଦେ଼ସାତା ହାଚେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ଅ଼ଡ଼େ ତାନି ମୀର୍‌କା ଏମ୍ବାଆଁ ହା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଇଞ୍ଜାଁ ଏ଼ୱାରି ମାଡ଼୍‌ହା ସିକିମତା ଅ଼ୱିଆ଼ତେ, ଇଞ୍ଜାଁ ଅବ୍ରାହାମ ଏମ୍ବାଆଁ ହମର ମୀର୍‌କା ତା଼ଣାଟି ଆମିନି ମାହ୍‌ଣି ମାଣ୍ତା ଟାକାୟାଁ ହୀହାଁ କଡାମାଚେସି, ଏମ୍ବାଆଁ ମୁସ୍‌ପି ଆ଼ତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ସାମା, ମାହାପୂରୁ ଅବ୍ରାହାମ ନ଼କିତା ଆ଼ଞ୍ଜାମାଚି ଲେହେଁ, ଏ଼ ଆ଼ଞ୍ଜାମାନାୟି ପୂରା ଆ଼ନି କା଼ଲା ୱା଼ହାଲିଏ ମା଼ ଲ଼କୁ ମିସର ଦେ଼ସାତା ହା଼ରେକା ଗାଡି ପାଡା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ଡା଼ୟୁ ମିସର ଦେ଼ସାତା ଅ଼ଡ଼େ ର଼ ରାଜା ଆ଼ତେସି, ଏ଼ୱାସି ଜସେପଇଁ ପୁଞ୍ଜା ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ଏ଼ୱାସି ମା଼ ଆକୁ ଆ଼ବାଣି ୱେ଼ପିକିତେସି ଅ଼ଡ଼େ ସା଼ସ୍ତି ହୀତେସି, ତାମି କକାରି ହା଼ପାରିୱା ଇଞ୍ଜିଁ ଇଲୁଟି ପାଙ୍ଗାତା କୁତୁସାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଏଚିବେ଼ଲାତା ମ଼ସା ଜାର୍ନା ଆ଼ତେସି, ଏ଼ୱାସି ମାହାପୂରୁ ନ଼କିତା ହା଼ରେକା ଅ଼ଜିତାସି ଇଞ୍ଜାଁ ତୀନି ଲେ଼ଞ୍ଜୁ ପାତେକା ତାମି ଆ଼ବା ଇଜ ପ଼ହିକିୱି ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ଡା଼ୟୁ ଏଚିବେ଼ଲା ଏ଼ୱାସି ପାଙ୍ଗାତା ମେତ୍‌ପି ଆ଼ତେସି, ଏଚିବେ଼ଲା ପା଼ର ରାଜା ମା଼ଙ୍ଗା ଏ଼ୱାଣାଇଁ ଅ଼ହାନା ତାନି ମୀର୍‌ଏଣା ଲେହେଁ ପ଼ହିକିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ଅ଼ଡ଼େ ମ଼ସା ମିସର ଲ଼କୁତି ବାରେ ବୁଦି ଜା଼ପାନା କାତାତା ଅ଼ଡ଼େ କାମାତା ୱେ଼ଙ୍ଗିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ମ଼ସାକି ରୀ କ଼ଡ଼ି ବାର୍ସା ଆୟାଲିଏ ତାମି ତାୟିୟାଁ ଇଚିହିଁ ଇସ୍ରାୟେଲ ଲ଼କୁତି ମା଼ସ୍‌କା ମୀର୍‌କାଣି ଏ଼ନିକିହିଁ ଲେ଼ମ୍ବ୍‌ୱି ଆ଼ହିମାନେ ଇଞ୍ଜିଁ ପୁଞ୍ଜାଲି ଅଣ୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ଏ଼ୱାସି ରଅଣାଇଁ ମିସରତାସି ଗଡ଼୍‌ହା କିହିମାଚାଣି ମେସ୍ତେସି, ଏ଼ୱାଣାଇଁ ସା଼ୟେମି କିହାଲି ହାଚେସି ଅ଼ଡ଼େ ବାଦୁଲି ଅ଼ହାନା ଏ଼ୱାଣାଇଁ ପା଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ଏ଼ୱାଣି କେୟୁଟି ମାହାପୂରୁ ତାମି ତାୟିୟାଁଣି ଗେଲ୍‌ପି ମାନେସି, ଈଦାଆଁ ଏ଼ୱାରି ପୁଞ୍ଜାଲି ଆ଼ଡିନେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେସି, ସାମା ଏ଼ୱାରି ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ତାନି ଅ଼ର ଦିନା ଇସ୍ରାୟେଲ ଲ଼କୁ ରିଆରି ମା଼ଡା ଆ଼ହିମାଚାଣି ମେସ୍ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ଆଣ୍ତ୍‌ୱି କିହାଲି ମାଦି ଆ଼ହାଁ ଏଲେଇଚେସି, ‘ଆଡ଼େ, ମୀରୁତ ଇସ୍ରାୟେଲ ତାୟିୟାଁତେରି; ଏ଼ନାଆଁତାକି ଇଲେଆ଼ହିଁ ଗଡ଼୍‌ହା ଆ଼ହିମାଞ୍ଜେରି ?’ ");
INSERT INTO kxv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ସାମା ଆମିନିଗାଟାସି ପା଼ଡ଼ିତାଣାଇଁ ଲାଗେଏ କିହିମାଚେସି, ଏ଼ୱାସି ମ଼ସାଇଁ ମେଡାନା ଏଲେଇଚେସି, ‘ଆମ୍ବାଆସି ନିଙ୍ଗେ ମା଼ ଲାକ ସା଼ଲୱି କିହାଲି ଅ଼ଡ଼େ ନୀହାଁୟି କିହାଲି ହିୟାତେସି ?’ ");
INSERT INTO kxv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘ରେଃଏନି ଏ଼ନିକିଁ ମିସର ତା଼ଣାଇଁ ପା଼ୟାମାଚି, ଏଲେକିହିଁ କି ନୀନୁ ନାଙ୍ଗେ ପା଼ୟାଲି ଅଣ୍‌ପିମାଞ୍ଜାଦି ?’ ");
INSERT INTO kxv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ଈ କାତା ୱେଞ୍ଜାନା ମ଼ସା ମିଦିୟନ ଦେ଼ସାତା ହାଜାନା ବାସା କିତେସି; ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ରୀ ମୀର୍‌କା ଜାର୍ନା ଆ଼ତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ଡା଼ୟୁ ରୀ କ଼ଡ଼ି ବାର୍ସା ଆୟାଲିଏ, ସିନୟ ହ଼ରୁ ଡାଗେତି ଜା଼ଡ଼ାତା ର଼ ଦୂତୁ ର଼ ବୂଟାତା ହିଚୁ ଡ଼ୀଞ୍ଜାନା ତ଼ଞ୍ଜାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମ଼ସା ଏ଼ଦାଆଁ ମେସାନା ଆଡାଜାକା ଆ଼ତେସି, ଇଞ୍ଜାଁ ନେହିଁକିଁ ସିନିକିହାଲି ଡାଗେ ହାଜିମାଚି ବେ଼ଲାତା ପ୍ରବୁତି ଈ ହା଼ଡା ୱେଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“ନା଼ନୁ ମୀ ଆକୁ ଆ଼ବାୟାଁ ମାହାପୂରୁ, ଅବ୍ରାହାମତି, ଇସାହାକ ଅ଼ଡ଼େ ଜାକୁବତି ମାହାପୂରୁ” ଏଚେଟିଏ ମ଼ସା ଆଜିତାକି ନେହିଁକିଁ ସିନିକିହାଲି ସା଼ସା କିଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ନୀ କଡାତି ସେପୁୟାଁ ହୁକୁମି, ଇଚିହିଁ ନୀନୁ ଆମିନି ଟା଼ୟୁତା ନିଚାମାଞ୍ଜି ଏ଼ଦି ସୁଦୁଗାଟି ଟା଼ୟୁ । ");
INSERT INTO kxv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସରତା ନା଼ ଆମିନି ଲ଼କୁ ମାନେରି, ନା଼ନୁ ଏ଼ୱାରି କସ୍ତ ମେସାମାଇଁ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଡ଼ୀହିମାନାଣି ୱେଞ୍ଜାମାଇଁ, ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ଗେଲ୍‌ପାଲି ରେ଼ଚା ୱା଼ହାମାଇଁ; ଇଞ୍ଜାଁ ନୀଏଁ ୱା଼ମୁ ନା଼ନୁ ନିଙ୍ଗେ ମିସର ଦେ଼ସାତା ପାଣ୍ତାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ମ଼ସାଇଁ ଇସ୍ରାୟେଲତି ଲ଼କୁ ଅ଼ପାଆତେରି । ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, ‘ମାଙ୍ଗେ ସା଼ଲୱି କିହାଲି ଅ଼ଡ଼େ ନୀହାଁୟି କିହାଲି ଆମ୍ବିଟି ଅଦିକାରା ବେଟାଆ଼ତି ? ଏ଼ୱାଣାଇଁ ମାହାପୂରୁ ଲ଼କୁଣି ସା଼ଲୱି କିହାଲି ଅ଼ଡ଼େ ମୁକ୍‌ଲୱି କିହାଲି ଦୂତୁତି ସା଼ୟେମି ତଲେ ହିଚୁ ଡ଼ୀଞ୍ଜିମାନି ବୂଟାତା ତ଼ଞ୍ଜାଆ଼ହାନା ପାଣ୍ତାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ଏ଼ୱାସି ଲ଼କୁଣି ମିସର ଦେ଼ସାଟି, ସୁପ ସାମ୍‌ଦୁରି, ଇଞ୍ଜାଁ ରୀ କ଼ଡ଼ି ବାର୍ସା ପାତେକା ବାଟାତା ହା଼ରେକା କାବାଆ଼ନି କାମା ଅ଼ଡ଼େ ସିନାୟାଁ ତ଼ସାହାଁ ଏ଼ୱାରାଇଁ ହ଼ପ୍‌ହା ତାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ଏ଼ ମ଼ସା ତା଼ନୁଏ ଇସ୍ରାୟେଲ ମୀର୍‌କାଣି ଏଲେଇଚେସି, ମାହାପୂରୁ ମୀ ତାୟିୟାଁ ବିତ୍ରାଟି ମିଙ୍ଗେତାକି ନା଼ ଲେହେଁକି ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଣାଇଁ ହିୟାନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଏ଼ ମ଼ସା ବାଃଲି ବାଟାତା କୂଡ଼ା ଆ଼ହାମାନି ଇସ୍ରାୟେଲ ଲ଼କୁତଲେ ମାଚେସି । ସିନୟ ହ଼ରୁତା ତାନିତଲେ କାତା ଆ଼ହିମାଚି ଦୂତୁ ଇଞ୍ଜାଁ ମା଼ ଆକୁ ଆ଼ବାୟାଁ ବିତ୍ରା ମାଦିତାସି ମାଚେସି; ଏ଼ୱାସି ମିଙ୍ଗେ ହୀହାଲିତାକି ମାହାପୂରୁ ତା଼ଣାଟି ଜୀୱୁତି ବ଼ଲୁ ବେଟାଆ଼ତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ସାମା ମା଼ ଆକୁ ଆ଼ବାୟାଁ ଏ଼ୱାଣି କାତା ଆହ୍‌ଆନା ଏ଼ୱାଣାଇଁ ଅ଼ପାଆତେରି, ଅ଼ଡ଼େ ମିସର ଦେ଼ସାତା ୱେଣ୍ତା ହାଜାଲି ମ଼ନ କିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ହାରଣଇଁ ଏଲେଇଚେରି । ‘ମା଼ ନ଼କି ନ଼କିତା ହାଜାଲି ମାଙ୍ଗେତାକି ପେ଼ଣ୍‌କାଣି କେ଼ପାମୁ, ଇଚିହିଁ ମାଙ୍ଗେ ମିସର ଦେ଼ସାଟି ହ଼ପ୍‌ହା ତାତାତି ମ଼ସାକି ଏ଼ନାଆଁ ଆ଼ତେ ମା଼ମ୍ବୁ ପୁଞ୍ଜାହିଲଅମି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଅ଼ଡ଼େ, ଏଚିବେ଼ଲାତା ଏ଼ୱାରି ର଼ କ଼ଡି ଡା଼ଲୁତି ବମା କେ଼ପାନା ଏ଼ ବମା ତାକି ପୂଜା ହୀହାନା ତାମି କେୟୁଟି କେ଼ପିତି ଆ଼ସ୍ତି ତାକି ରା଼ହାଁ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ସାମା ମାହାପୂରୁ ଏ଼ୱାରି ତା଼ଣାଟି ଏଟ୍‌କା ଆ଼ହାନା ଏ଼ୱାରାଇଁ ହା଼ଗୁଲାକତି ହୁକାୟାଁଣି ସେ଼ବା କିୟାଲି ପିସ୍ତେସି, ଏ଼ନିକିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ; ‘ଏ଼ ଇସ୍ରାୟେଲ କୂଡ଼ାତେରି, ବାଟାତା ରୀ କ଼ଡ଼ି ବାର୍ସା ପାତେକା ମୀରୁ ନାଙ୍ଗେତାକି କ଼ଡି ଗରି ପୂଜା କିହାହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ମୀରୁ ପୂଜା କିହାଲି ଆମିନି ବମାୟାଁ କେ଼ପାମାଚେରି, ଏ଼ ମଲକ ପେ଼ନୁତି ତୂମୁ ଅ଼ଡ଼େ ରମ୍‌ପାନ୍‌ ପେ଼ନୁତି ହୁକାତି ମୀରୁ ଆସାନା ସେ଼ବା କିତେରି, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ବାବିଲନ ଆତାଲା ବାସା ଆୟାଲି ପାଣ୍ତାଇଁ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ନୀନୁ ଏ଼ନିକିଁ ମେସାମାଞ୍ଜି, ଏଲେକିହିଁଏ ସା଼କି ହୀନି ତୂମୁ ଇଲୁ କେ଼ପାମୁ ଇଞ୍ଜିଁ ମ଼ସାକି ଆମ୍ବାଆସି ୱେସାମାଚେସି, ଏ଼ୱାଣି ହୁକୁମି ତଲେ ମା଼ ଆକୁୟାଁ ବାଟାତା ସା଼କି ହୀନି ତୂମୁ ଇଲେ କେ଼ପାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ଡା଼ୟୁ ମା଼ ଆକୁ ଆ଼ବାୟାଁ ଏ଼ଦାଆଁ ତାମି ଆ଼ବାୟାଁ ତା଼ଣାଟି ବେଟାଆ଼ତେରି ଇଞ୍ଜାଁ ଜିହସୁୟ ତଲେ ତା଼କିମାଚିବେ଼ଲା ଏ଼ୱାରି ଏ଼ଦାଆଁ ଡେ଼କା ଅ଼ତେରି, ଏମ୍ବାଟିଏ ମାହାପୂରୁ ଏ଼ୱାରି ନ଼କିତା ମାଚି ବାରେ କୂଡ଼ାତି ଲ଼କୁଣି ପେ଼ର୍‌ହା ତୁସାଲିଏ, ଇସ୍ରାୟେଲ ଲ଼କୁ ଈୱାରି ଦେ଼ସା ଜୀଣାଆ଼ହାନା ଈ କୂଡ଼ାଆନି ତୂମୁ ଇଲୁ ଏମ୍ବାଆଁ ତାଚାନା ଇଟିତେରି, ଇଞ୍ଜାଁ ଏ଼ଦି ଦାୱୁଦ ରାଜା ପାତେକା ଏମ୍ବାଆଁ ଡ଼ୟିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଦାୱୁଦ ମାହାପୂରୁ ନ଼କିତା କାର୍ମା ବେଟାଆ଼ହାନା, ଜାକୁବତି ମାହାପୂରୁକି ର଼ ବାସାଟା଼ୟୁ କିହାଲି ପ୍ରା଼ତାନା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ସାମା ସଲମନ ମାହାପୂରୁକି ଏ଼ ଇଲୁ କେ଼ପିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ସାମା ବା଼ଡ଼୍‌ୟୁ ଗାଟି ମାହାପୂରୁ ମାଣ୍‌ସି କେୟୁତଲେ କେ଼ପିତି ଇଲୁତା ବାସା କିଅସି; ଏ଼ନିକିଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ୱେସାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ପ୍ରବୁ ଏଲେଇଞ୍ଜା ମାନେସି, “ଲାକପୂରୁ ନା଼ ସିଂଗାସାଣି, ଦାର୍‌ତି ନା଼ କଡା ଇଟିନି ଟା଼ୟୁ, ମୀରୁ ନା଼ ତାକି ଏ଼ନିଲେହେଁତି ଇଲୁ କେ଼ପିଦେରି ? ଇଞ୍ଜାଁ ନା଼ ଜ଼ମିନି ଟା଼ୟୁ ଏମ୍ବିୟାମାନେ ? ");
INSERT INTO kxv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ନା଼ କେୟୁ ଈ ବାରେ ଗା଼ଡ଼ି କିହାହିଲେଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିପାନ ଏଲେଇଚେସି, “ମୀରୁ ଏଚେକା ମୁଣ୍ତି ଗାଟାତେରି, ଇଞ୍ଜାଁ ଅଟ୍‌ହା କଡାଆତି ହିୟାଁ ଗାଟାତେରି ଅ଼ଡ଼େ ମାହାପୂରୁତି ବ଼ଲୁ ତାକି କୀର୍କା ୱେନାଆ ଗାଟାତେରି, ମୀରୁ କା଼ଲେଏ ସୁଦୁଜୀୱୁତି କସ୍ତ ହୀହିମାଞ୍ଜେରି; ମୀ ଆକୁ ଆ଼ବାୟାଁ ଏ଼ନିକିଁ ମୀରୁ ଜିକେଏ ଏଲେତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରାଇଁ ଆମ୍ବାଆରାଇଁ ଜିକେଏ ମୀ ଆକୁ ଆ଼ବାୟାଁ ନିନ୍ଦା କିହାହିଲାଆତେରି ? ଆମିନି ଗାଟାରି ଏ଼ ଦାର୍ମୁଗାଟାସି ୱା଼ନି କାତା ନ଼କେଏ ୱେସାମାଚେରି, ଏ଼ୱାରାଇଁ ଏ଼ୱାରି ପା଼ୟିତେରି; ନୀଏଁ ମୀରୁ ଏ଼ୱାଣାଇଁ ସାତ୍ରୁୟାଁ କେୟୁତା ହେର୍‌ପାନା ପା଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ମୀରୁ ମାହାପୂରୁତି ମେ଼ରା ବେଟାଆ଼ହା ମାଚେରି, ଏ଼ ମେ଼ରା ଦୂତୁୟାଁ ତା଼ଣାଟି ହୀପ୍‌କି ଆ଼ହାମାଚେ, ଆ଼ତିଜିକେଏ ମୀରୁ ଏ଼ଦାଆଁ ନାମାଆତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ସ୍ତିପାନ ବେ଼ରଣିମାଣ୍ତାତା କୁଗାମାଚି ଲ଼କୁଇଁ ଈ ବାରେ କାତା ୱେସ୍ତେସି, ଏମ୍ବାଆଁ ମାଚି ପାରୁସି ଇଞ୍ଜାଁ ବାରେ କୂଡ଼ା ଆ଼ହାମାଚାରି କାର୍‌ବି ଆ଼ହାଁ ପାଲ୍‌କା ଟୀଟି କିହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ସାମା ସ୍ତିପାନ ସୁଦୁଜୀୱୁ ତଲେ ନେଞ୍ଜାନା ଲାକପୂରୁ ୱାକି ସିନିକିତେସି, ଇଞ୍ଜାଁ ମାହାପୂରୁତି ଗାୱୁରମି ଅ଼ଡ଼େ ଜୀସୁଇଁ ମାହାପୂରୁତି ଟିଃନିୱାକି ନିଚାମାନାଣି ମେସାନା ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“ମେହ୍‌ଦୁ ନା଼ନୁ ଲାକପୂରୁ ଦେପିଆ଼ହାମାନାଣି ଅ଼ଡ଼େ ମାଣ୍‌ସି ମୀର୍‌ଏସି ମାହାପୂରୁତି ଟିଃନିୱାକି ନିଚାମାନାଣି ମେସିମାଇଁ !” ");
INSERT INTO kxv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ଏ଼ କାତା ୱେନାଆପ ଇଞ୍ଜିଁ କା଼ଲୱି ଆ଼ହିଁ ବେ଼ରଣି ମାଣ୍ତାତାରି କୀର୍କା ମୁଚାକଡିତେରି । ଡା଼ୟୁ ବାରେଜା଼ଣା ରୁଣ୍ତା ଆ଼ହାନା ଏ଼ୱାଣାଇଁ ମୁଚିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଗା଼ଡ଼ାଟିଏ ପାଙ୍ଗାତା ରେଜା ଅ଼ହାନା ଏ଼ୱାଣାଇଁ ୱାଲ୍‌କାତଲେ ୱେ଼ଚାଲି ମା଼ଟ୍‌ହେରି; ଅ଼ଡ଼େ ସା଼କିୟାଁ ବିତ୍ରାଟି ସା଼ୱୁଲ କଡାୟାଁ ଡ଼଼ଇ ହିମ୍ବରିକା କା଼ଚିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଏଚିବେ଼ଲା ଏ଼ୱାରି ସ୍ତିପାନଇଁ ୱାଲ୍‌କା ୱେ଼ଚି ମାଚେରି, ଏଚିବେ଼ଲା ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା କିହାନା ଏଲେଇଚେସି, “ପ୍ରବୁ ଜୀସୁ, ନା଼ ଜୀୱୁତି ଅ଼ହାକଡାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଇଞ୍ଜାଁ ଏ଼ୱାସି ମେଣ୍ତାକୁତାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ପ୍ରବୁ ! ଈ ପା଼ପୁ ଈୱାରି ତା଼ଣା ଲେକା କିଆନି” ଏଲେଇଞ୍ଜାହାଁ ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ସ୍ତିପାନଇଁ ପା଼ୟିତାୟି ନେହେଁ ଆ଼ତେ ଇଞ୍ଜିଁ ସା଼ୱୁଲ ଅଣ୍‌ପିମାଚେସି । ଏ଼ ଦିନାଟିଏ ଜିରୁସାଲମତା ମାନି କୁଲମିକାକି ହା଼ରେକା ନିନ୍ଦା ସା଼ସ୍ତି ୱା଼ତେ; ଏମ୍ବାଟିଏ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ପିସ୍‌ପେ ବାରେ ନାମିତାରି, ଜୀହୁଦା ଦେ଼ସା ଇଞ୍ଜାଁ ସମିରଣ ନା଼ସ୍‌କା ସା଼ରିସୁଟୁ ଇତାଲା ଆତାଲା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଆ଼ତିଜିକେଏ ଏଚେକା ନାମୁଗାଟି ଲ଼କୁ ସ୍ତିପାନଇଁ ମୁସ୍ତେରି ଇଞ୍ଜାଁ ହା଼ରେକା ଦୁକୁ ତଲେ ଡ଼ୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ସାମା ସା଼ୱୁଲ କୁଲମିତା ହାଜିହିଁ ଇଲୁତାକି ଇଲୁ ହ଼ଡିହିଁ ନାମିତି ଆୟାସିକା, ଆ଼ବାଣି ରେଜା ତାଚାନା କା଼ୟିଦି ଇଲୁତା ହେର୍‌ପିହିଁ କୁଲମିତି ନା଼ସା କିହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଏମ୍ବାଟିଏ ଆମିନି ଗାଟାରି ଇତାଲା ଆତାଲା ଆ଼ହାମାଚେରି, ଏ଼ୱାରି ସା଼ରିସୁଟୁ ରେ଼ଜି ରେ଼ଜି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଇଞ୍ଜାଁ ପିଲିପ ସମିରଣତି କାଜା ଗା଼ଡ଼ାତା ହାଜାନା ଲ଼କୁ ନ଼କିତା ମସିହାତି କାତା ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଅ଼ଡ଼େ, ଲ଼କୁ ବାରେ ପିଲିପ ହା଼ଡା ୱେଚେରି ଇଞ୍ଜାଁ ଏ଼ୱାସି କିହାମାନି କାବାଆ଼ନି କାମା ମେସାନା ରଣ୍ତିଏ ହିୟାଁ ତଲେ ଏ଼ୱାଣି କାତାତି ୱେଞ୍ଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ଇଚିହିଁ ଆଲ୍‌ଗାମାଚି ପ଼ଲ୍‌ଆ ବୂତୁ ହା଼ରେକା ଲ଼କୁ ତା଼ଣାଟି କାଜା ଗିୟାଁତଲେ କିର୍‌ଡ଼ିହିଁ ହ଼ଚାହାଚୁ, ଇଞ୍ଜାଁ ଟଟ ୱା଼ୟିତାରି ଅ଼ଡ଼େ ସଟାୟାଁ ହା଼ରେକା ଜା଼ଣା ନେହିଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଏ଼ଦାଆଁତାକି ଏ଼ ଗା଼ଡ଼ାତା ହା଼ରେକା କାଜା ରା଼ହାଁ ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ସାମା ସିମନ ଦ଼ରୁଗାଟାସି ରଅସି ଈ ନ଼କେଏ ଏ଼ ଗା଼ଡ଼ାତା ଗାର୍‌ଡ଼ି କିହିଁ ନା଼ନୁ କାଜାତେଏଁ ଇଞ୍ଜିଁ ୱେସା କଡିହିଁ ସମିରଣତି ଲ଼କୁଣି କାବା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ମାହାପୂରୁତି ଆମିନି ବା଼ଡ଼୍‌ୟୁତି କାଜାୟି ଇଞ୍ଜିଁ ଇଣ୍‌ମ୍ବି ଆ଼ନେ, ଊଣାଟିଏ କାଜାରି ପାତେକା ବାରେଜା଼ଣା ଈୱାସିଏ ଏ଼ୱାସି ଇଞ୍ଜିଁ ଏ଼ୱାଣାଇଁ ମା଼ନି କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ମା଼ନି କିହିମାନାୟି ଆ଼ତେ, ହା଼ରେକା ଦିନାଟିଏ ତାନି ଗାର୍‌ଡ଼ି କାମା ତଲେ ଏ଼ୱାରାଇଁ କାବା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ସାମା ପିଲିପ ମାହାପୂରୁତି ରା଼ଜି ଇଞ୍ଜାଁ ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲିଏ ଏ଼ୱାରି ଏଚିବେ଼ଲା ଏ଼ୱାଣି କାତାତା ନାମିତେରି, ଇଞ୍ଜାଁ ଆୟାସିକା ଅ଼ଡ଼େ ଆ଼ବାୟାଁ ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଅ଼ଡ଼େ ସିମନ ତା଼ନୁଏ ନାମିତେସି ଇଞ୍ଜାଁ ବାପ୍ତିସ୍ମ ଅ଼ତେସି, ଇଞ୍ଜାଁ ପିଲିପ ତଲେ ଡ଼ୟିତେସି, ଅ଼ଡ଼େ ହା଼ରେକା ସିନାୟାଁ ଇଞ୍ଜାଁ ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁତି କାବାଆ଼ନି କାମାୟାଁ ମେସାନା କାବା ଆ଼ହାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମିରଣତି ଲ଼କୁ ଜିକେଏ ମାହାପୂରୁ ବ଼ଲୁତି ନାମିମାନେରି, ଇଞ୍ଜିଁ ଜିରୁସାଲମତା ମାନି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ୱେଚେରି, ଏମ୍ବାଟିଏ ଏ଼ୱାରି ପିତର ଅ଼ଡ଼େ ଜହନଇଁ ଏ଼ୱାରିତା଼ଣା ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ଏ଼ୱାରି ଏଗାହାଜାନା, ଏ଼ୱାରି ଏ଼ନିକିଁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ନେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ତାକି ପ୍ରା଼ତାନା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଇଚିହିଁ ନୀଏଁ ପାତେକା ଏ଼ୱାରିତା଼ଣା ଆମ୍ବାଆରି ଲାକ ସୁଦୁଜୀୱୁ ରେ଼ଚା ହିଲାଆତେ, ଇଚିହିଁ ଏ଼ୱାରି ୱାର୍‌ଇ ପ୍ରବୁ ଜୀସୁ ଦ଼ରୁତଲେ ବାପ୍ତିସ୍ମ ଅ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତର ଅ଼ଡ଼େ ଜହନ ଏ଼ୱାରି ଲାକ କେୟୁ ଇଟିତେରି ଇଞ୍ଜାଁ ଏ଼ୱାରି ସୁଦୁଜୀୱୁ ବେଟାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି କେୟୁ ଇଟିସାରେ ସୁଦୁଜୀୱୁ ୱା଼ହିମାନାଣି ମେସାନା, ସିମନ ଏ଼ୱାରାକି ଟାକାୟାଁ ହୀହାନା ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ନାଙ୍ଗେ ଜିକେଏ ଈ ବା଼ଡ଼୍‌ୟୁ ହିୟାଦୁ, ଏ଼ନିକିଁ ନା଼ନୁ ଆମିନିଗାଟାଣି ଲାକ କେୟୁ ଇଟିଇଁ ଏ଼ୱାସି ସୁଦୁଜୀୱୁ ବେଟାଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ସାମା ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି “ନୀ ଟାକାୟାଁ ନୀ ତଲେ ନସ୍ତ ଆ଼ପୁ, ଇଚିହିଁ ନୀନୁ ଟାକାୟାଁ ହୀହାନା ମାହାପୂରୁତି ଦା଼ନା କଡାଲି ଅଣ୍‌ପିତି । ");
INSERT INTO kxv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଈ କାମାତା ନୀଦି ଏ଼ନି ବା଼ଗା କି ଅଦିକାରା ହିଲେଏ, ଇଚିହିଁ ମାହାପୂରୁ ତା଼ଣା ନୀ ହିୟାଁ ଟିକାଣା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଈଦାଆଁତାକି ନୀ ଲାଗେଏତି ଅଣ୍‌ପୁଟି ମ଼ନ ୱେଟ୍‌ହାଁ ପ୍ରବୁ ତା଼ଣା ପ୍ରା଼ତାନା କିମୁ, ଏ଼ନିଆ଼ତିହିଁ ନୀ ହିୟାଁତା ମାନି ଲାଗେଏତି ଅଣ୍‌ପୁ ମ୍ଣେକ୍‌ନେସି; ");
INSERT INTO kxv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଇଚିହିଁ ନା଼ନୁ ମେସିମାଞ୍ଜାଇଁ ନୀ ହିୟାଁ ବିତ୍ରା ଡା଼ହାରା ଆ଼ନାୟି ମାନେ, ନୀନୁ ଲାଗେଏତି ପା଼ନ୍ଦାତା ଦସ୍‌ପି ଆ଼ହାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ଏଚେଟିଏ ସିମନ, ପିତର ଅ଼ଡ଼େ ଜହନଇଁ ଏଲେଇଚେସି, “ମୀରୁ କାର୍ମା ଅଣ୍‌ପାନା ନା଼ ତାକି ପ୍ରବୁ ତା଼ଣା ପ୍ରା଼ତାନା କିଦୁ, ମୀରୁ ଏ଼ନାଆଁ ଜ଼ଲିତେରି ଏ଼ ବାରେ ଏ଼ନିକିଁ ନାଙ୍ଗେତାକି ଏଲେଆ଼ହିଁ ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ଇଲେକିହିଁ ପିତର ଅ଼ଡ଼େ ଜହନ ସା଼କି ହୀହିଁ ପ୍ରବୁତି ବ଼ଲୁ ୱେସିହିଁ, ହା଼ରେକା ସମିରଣ ନା଼ସ୍‌କାଣାଁ ନେହିଁ କାବ୍ରୁ ୱେସି ୱେସିହିଁ ଜିରୁସାଲମତା ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ଡା଼ୟୁ ପ୍ରବୁତି ର଼ ଦୂତୁ ପିଲିପଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ ଇଞ୍ଜାଁ ଟିଃନି ୱାକିତି ଆମିନି ଜିରୁ ଜିରୁସାଲମଟିଏ ଗଜା ୱାକି ମାନେ ଏ଼ ଜିରୁତା ହାଲାମୁ ।” ଏ଼ ଜିରୁଟି ଅ଼ଡ଼େ ଲ଼କୁ ତା଼କିହିଲଅରି । ");
INSERT INTO kxv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନିଙ୍ଗାନା ହାଚେସି, ଇତିୟପିୟା ଦେ଼ସାତି କାଣ୍ତାକି ଦ଼ରୁଗାଟି ରା଼ଣିନି ଡ଼଼ଇ ର଼ କାଜାପା଼ଣା ବେଟାଆ଼ହାମାନି ପେଜୁ ଆମିନିଗାଟାସି ଇତିୟପିୟା ରା଼ଣିନି ବାରେ ଦ଼ନତି ଗୁମୁସ୍ତା ମାଚେସି, ଏ଼ୱାସି ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା କିହାଲି ଜିରୁସାଲମତା ୱା଼ହାମାଚେସି; ");
INSERT INTO kxv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ଏ଼ୱାସି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟତି ପତି କାଜା ଗିୟାଁତଲେ ପ଼ଡ଼ୱି ଆ଼ହିଁ ରାତାତା କୁଗାନା ୱେଣ୍ତା ହାଜିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ଏଚିବେ଼ଲା ସୁଦୁଜୀୱୁ ପିଲିପଇଁ ଏଲେଇଚେ, “ନ଼କିତା ହାଜାନା ରାତାତା ହାଜିମାନାଣି ତା଼ଣା ହାଲାମୁ;” ");
INSERT INTO kxv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ଏଚେଟିଏ ପିଲିପ ହଟି ହଟି ହାଜାନା ଜିସାୟତି ପତି କାଜା ଗିୟାଁତଲେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ପ଼ଡ଼ୱି ଆ଼ହିମାନାଣି ୱେଞ୍ଜାନା ୱେଚେସି, “ନୀନୁ ଆମିନିଗାଟାଣି ପ଼ଡ଼ୱି ଆ଼ହିମାଞ୍ଜି ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲି ଆ଼ଡିମାଞ୍ଜି କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ପେଜୁ ଏଲେଇଚେସି, “ଆମ୍ବାଆସି ନାଙ୍ଗେ ୱେସ୍ତାଆସାରେ ନା଼ନୁ ଏ଼ନିକିଁ ପୁଇଁ ?” ଇଞ୍ଜାଁ ଏ଼ୱାସି ପିଲିପଇଁ ରାତାତା ହ଼ଚାନା ତାନିତଲେ କୁଗାଲି ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ଏ଼ୱାସି ଦାର୍ମୁ ପତିତା ପ଼ଡ଼ୱି ଆ଼ହିମାଚି କାତା ଈଦି; “ଏ଼ୱାସି ପା଼ୟିୱିଆ଼ନି ମେ଼ଣ୍ତା ଡା଼ଲୁ ଲେହେଁ ଅ଼ୱିଆ଼ତେସି, ଇଞ୍ଜାଁ ମେ଼ଣ୍ତା ଡା଼ଲୁ ବା଼ଣାୟାଁ ଦା଼ଃନି ବେ଼ଲାତା ମେ଼ଣ୍ତା ଡା଼ଲୁ ଏ଼ନିକିଁ ଡ଼ୀଆନା ପାଲେଏ ଡ଼ୟିନେ, ଏଲେକିହିଁଏ ଏ଼ୱାସି ତାନି ଗୂତି ଏ଼କ୍‌ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଏ଼ୱାଣାଇଁ ଊଣା କିହାଁ ନୀହାଁୟି କିଆତେରି, ଏ଼ୱାଣି କୂଡ଼ାତି କାତା ଆମ୍ବାଆସି ୱେସାଲି ଆ଼ଡଅସି, ଇଚିହିଁ ତାନି ଜୀୱୁ ଦାର୍‌ତିତା ରା଼ତେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ଏ଼ ପେଜୁ ପିଲିପଇଁ ଏଲେଇଚେସି, “ନାଙ୍ଗେ ୱେସ୍ତାମୁ, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଆମ୍ବାଆରି କାତା ୱେସିମାନେସି ? ତାନି କାତା କି ଅ଼ର ରଅଣି କାତା ?” ");
INSERT INTO kxv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ଏମ୍ବାଟିଏ ପିଲିପ ଗୂତି ଦେଚାନା ଦାର୍ମୁ ସା଼ସ୍ତେରିଟିଏ ମା଼ଟ୍‌ହାନା ଏ଼ୱାଣି ତା଼ଣା ଜୀସୁତି ନେହିଁ କାବ୍ରୁ ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଏ଼ୱାରି ଜିରୁତା ହାଜିମାଚାଟି ଏ଼ୟୁ ମାନି ର଼ ଟା଼ୟୁତା ଏଗାହାଚେରି; ଏଚେଟିଏ ପେଜୁ ଏଲେଇଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“ଇମ୍ବାଆଁ ଏ଼ୟୁ ମାନୁ, ଏ଼ନାଆଁ ନା଼ନୁ ବାପ୍ତିସ୍ମ ଅ଼ହାଲି ଆ଼ଡିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ଇଞ୍ଜାଁ ଏ଼ୱାସି ରାତା ନିପ୍‌ହାଲି ହୁକୁମି ହୀତେସି, ଇଞ୍ଜାଁ ପିଲିପ ଅ଼ଡ଼େ ପେଜୁ ଏ଼ୟୁଣାଁ ରେ଼ତେରି, ଇଞ୍ଜାଁ ପିଲିପ ଏ଼ୱାଣାଇଁ ବାପ୍ତିସ୍ମ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ଏ଼ୱାରି ଏ଼ୟୁଟି ହ଼ଚା ୱା଼ତି ଡା଼ୟୁ, ପ୍ରବୁତି ସୁଦୁଜୀୱୁ ପିଲିପଇଁ ଅ଼ହିଁ ହାଚେ, ଇଞ୍ଜାଁ ପେଜୁ ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ମେହ୍‌ଆତେସି; ଆ଼ତିଜିକେଏ ରା଼ହାଁ କିହିଁ ତାନି ଜିରୁତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ସାମା ପିଲିପ ଅସଦଦ୍‌ ଗା଼ଡ଼ାତା ତ଼ଞ୍ଜାଆ଼ତେସି; ଇଞ୍ଜାଁ ଏ଼ୱାସି ଗା଼ଡ଼ାତାକି ଗା଼ଡ଼ାତା ହାଜାହାଁ ନେହିଁ କାବ୍ରୁ ୱେସ୍ତେସି ଇଞ୍ଜାଁ କାୟିସରିୟାତା ଏଗାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ସାମା ସା଼ୱୁଲ ନୀଏଁ ପାତେକା ପ୍ରବୁତି ସୀସୁୟାଁ କ଼ପାଟି ଆଜି ତ଼ସାନା ଅ଼ଡ଼େ ଜୀୱୁ ନା଼ସାକିନି କାତାୟାଁ ଜ଼ଲିହିଁ କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଅ଼ଡ଼େ ପ୍ରବୁ ଜିରୁଟି ତା଼କିମାନି ଆମିନି ଇୟାସିକା ଆ଼ବାୟାଁଣି ମେସ୍ତିହିଁ, ବାରେଜା଼ଣାତି ଦସ୍‌ପାନା ଜିରୁସାଲମତା ତାଚାଲି ଆ଼ଡିମାନେସି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣା ହାଜାନା ଦମେସକତା ମାନି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ହିୟାଲି ଏ଼ୱାରି ତା଼ଣାଟି ଆ଼କୁ ରୀସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ସା଼ୱୁଲ ଦମେସକ ଡାଗେ ୱା଼ହିମାଚାଟି ଦେବୁଣିଏ ର଼ ଉଜେଡ଼ି ହା଼ଗୁଲାକଟି ତାନି ସା଼ରିୱାକି ମ୍ଣିସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ବୂମିତା ତର୍‌ଗା ହାଚେସି ଇଞ୍ଜାଁ ତାଙ୍ଗେତାକି ଈ ହା଼ଡା ୱେଚେସି, “ଏ଼ ସା଼ୱୁଲ, ଏ଼ ସା଼ୱୁଲ ! ନୀନୁ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ନିନ୍ଦା କିହିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ଏ଼ୱାସି ଏଲେଇଚେସି, “ପ୍ରବୁ, ନୀନୁ ଆମ୍ବାଆତି ?” ଏ଼ୱାସି ଏଲେଇଚେସି, “ନୀନୁ ଆମ୍ବାଆରାଇଁ ନିନ୍ଦା କିହିମାଞ୍ଜି ଏ଼ ଜୀସୁତେଏଁ ନା଼ନୁ । ");
INSERT INTO kxv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ସାମା ନିଙ୍ଗାମୁ ଇଞ୍ଜାଁ ଗା଼ଡ଼ାତା ହାଲାମୁ, ଏ଼ନାଆଁ କିହାଲି ଆ଼ନେ, ଏମ୍ବାଆଁ ନିଙ୍ଗେ ୱେସ୍‌ପି ଆୟାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ଏ଼ୱାଣିତଲେ ଆମିନି ଲ଼କୁ ହାଜିମାଚେରି, ଏ଼ୱାରି ଏ଼ ହା଼ଡା ୱେଞ୍ଜାନା ଆମ୍ବାଆରାଇଁ ମେହ୍‌ଆତେରି, ଇଞ୍ଜାଁ ଆଡାଜାକା ଆ଼ହାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଅ଼ଡ଼େ ସା଼ୱୁଲ ବୂମିଟି ନିଙ୍ଗାନା ତାନି କାଣ୍‌କା ଦେତେସି, ସାମା ଏ଼ୱାସି ଏ଼ନାଆଁ ମେସାଲି ଆ଼ଡାଆତେସି । ଇଞ୍ଜାଁ ଏ଼ୱାରି ତାନି କେୟୁ ଆସାନା ଦମେସକତା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ଅ଼ଡ଼େ ତୀନିଦିନା ପାତେକା ଏ଼ୱାସି ଏ଼ନାଆଁ ମେସାଲି ଆ଼ଡାଆତେସି, ଅ଼ଡ଼େ ଏ଼ନାଆଁ ତିନାଆତେସି ଏ଼ନାଆଁ ଗହ୍‌ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦମେସକତା ହନନିୟ ଦ଼ରୁଗାଟାସି ର଼ ସୀସୁ ମାଚେସି; ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ତ଼ଞ୍ଜାଆ଼ହାଁ ଏଲେଇଚେସି, “ଏ଼ ହନନିୟ !” ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏ଼ ପ୍ରବୁ ନାଙ୍ଗେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ଏଚେଟିଏ ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ତିୟାରା ଆ଼ହାନା ‘ସଲକ’ ଦ଼ରୁଗାଟି ଜିରୁ ଆସାଁ ଜୀହୁଦା ଇଲୁତା ତାର୍ସ ଗା଼ଡ଼ାତି ସା଼ୱୁଲ ଇନାଣାଇଁ ପାରାମୁ; ଇଚିହିଁ ଏ଼ୱାସି ପ୍ରା଼ତାନା କିହିମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ଅ଼ଡ଼େ, ଏ଼ୱାସି ସେୟାଁଣା ହାପାନା ମେସାମାନେସି, ହନନିୟ ଇନାସି ର଼ ମାଣ୍‌ସି ୱା଼ହାନା ତାନି ଲାକ କେୟୁ ଇଟିମାନେସି, ଏ଼ନିକିଁ ଏ଼ୱାସି ମେସାଲି ଆ଼ଡିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ହନନିୟ ଏଲେଇଚେସି, “ପ୍ରବୁ, ଜିରୁସାଲମତା ମାହାପୂରୁ ଲ଼କୁଇଁ ଈୱାସି ଏଚେକା ନିନ୍ଦା କିହାମାନେସି ଇଞ୍ଜିଁ ନା଼ନୁ ହା଼ରେକା ଲ଼କୁ ତା଼ଣାଟି ଈ ଲ଼କୁତି କାତା ୱେଞ୍ଜାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଅ଼ଡ଼େ ଈ ଟା଼ୟୁତା ନୀ ଦ଼ରୁଟି ପ୍ରା଼ତାନା କିହିମାନାରାଇଁ ବାରେଜା଼ଣାତି ଦସା ଅୟାଲି ଏ଼ୱାସି କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣାଟି ଅଦିକାରା ଆ଼କୁ ବେଟାଆ଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ସାମା ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ହାଲାମୁ; ଇଚିହିଁ ଏ଼ୱାସି ଏଟ୍‌କା କୂଡ଼ାତି ରାଜାୟାଁ ଅ଼ଡ଼େ ଇସ୍ରାୟେଲ ଲ଼କୁତି ମା଼ସ୍‌କା ମୀର୍‌କା ନ଼କିତା ନା଼ ଦ଼ରୁ ୱେ଼କ୍‌ହାଲି ନା଼ନୁ ଏ଼ୱାଣାଇଁ ନା଼ ସେ଼ବା କିନାସି କିହାନା ଆ଼ଚାମାଇଁ; ");
INSERT INTO kxv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ଅ଼ଡ଼େ ନା଼ ଦ଼ରୁ ତାକି ଏ଼ୱାସି ଏଚେକା ଦୁକୁ ବେଟାଆ଼ନେସି, ଏ଼ଦାଆଁ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ୱେହ୍‌ଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ଏଚେଟିଏ ହନନିୟ ହାଜାନା, ଏ଼ ଇଲୁତା ହ଼ଟେସି, ଇଞ୍ଜାଁ ତାନି ଲାକ କେୟୁ ଇଟାନା ଏଲେଇଚେସି, “ତାୟି ସା଼ୱୁଲ, ଇମ୍ବାଆଁ ୱା଼ନି ଜିରୁତା ଆମିନି ପ୍ରବୁ ଜୀସୁ ନିଙ୍ଗେ ତ଼ଞ୍ଜା ଆୟାତେସି, ଏ଼ୱାସି ନାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନେସି, ନୀନୁ ଏ଼ନିକିଁ ୱେଣ୍ତେ ମେହ୍‌ମୁ ଇଞ୍ଜାଁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାଣି କାଣ୍‌କାଟି ମୀନୁ ହିପି ଲେହେଁତାୟି ଡୁଲିତେ, ଇଞ୍ଜାଁ ଏ଼ୱାସି ୱେଣ୍ତେ ମେସାଲି ଆ଼ଡିତେସି, ଅ଼ଡ଼େ ନିଙ୍ଗାନା ବାପ୍ତିସ୍ମ ଅ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଅ଼ଡ଼େ ଏ଼ୱାସି ତିଞ୍ଜା ଉଣ୍ତାନା ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ତେସି, ଏଚେଟିଏ ସା଼ୱୁଲ ଏଚରଦିନା ସୀସୁୟାଁ ତଲେ ଦମେସକତା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଅ଼ଡ଼େ, ଜୀସୁ ମାହାପୂରୁତି ମୀର୍‌ଏସି ଇଞ୍ଜିଁ ଆ଼ଟ୍‌ୱା ତଲେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ୱେସାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଅ଼ଡ଼େ, ଆମିନି ଗାଟାରି ତାନି ହା଼ଡା ୱେଚେରି, ଏ଼ୱାରି କାବାଆ଼ହାନା ଏଲେଇଚେରି, “ଜୀସୁ ଦ଼ରୁ ଆସାନା ପ୍ରା଼ତାନା କିନି ଲ଼କୁଣି ଆମ୍ବାଆସି ଜିରୁସାଲମତା ପା଼ୟି କିହିମାଚେସି, ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ଦସ୍‌ପାହାଁ କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣା ଅ଼ହାଲି ତାକି ଇମ୍ବାଆଁ ୱା଼ହାମାଚେସି, ଏ଼ୱାସି କି ଈୱାସି ଆ଼ଏ ?” ");
INSERT INTO kxv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ସାମା, ସା଼ୱୁଲତି ୱେ଼କ୍‌ନାୟି ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁ ଗାଟାୟି ମାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାସି ପାର୍‌ମାଣା କିହାଁ ୱେସ୍ତେସି ଜୀସୁ ଏ଼ ମସିହା, ଈଦାଣି ଦମେସକତା ବାସା କିହାମାନି ଜୀହୁଦି ଲ଼କୁଣି ୱେଣ୍ତେ ୱେସାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ଏଚରଦିନା ହାଚି ଡା଼ୟୁ ଜୀହୁଦିୟାଁ ରୁଣ୍ତା ଆ଼ହାନା ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି କାତା ଆ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ସାମା ଏ଼ୱାରି କାତା ଆ଼ହିମାଚାଣି ସା଼ୱୁଲ କିର୍ୟୁଁତା ହାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ନିକିଁ ସା଼ୱୁଲଇଁ ପା଼ୟାଲି ଆ଼ଡିନେରି, ଏ଼ଦାଆଁତାକି ଲା଼ଆଁ ମାଦେନା ଗା଼ଡ଼ାତି ଦୁୱେରିକାଣା କା଼ଚିହିଁ ଡ଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ସାମା ସା଼ୱୁଲତି ସୀସୁୟାଁ ଲା଼ଆଁୟାଁ ବେ଼ଲାତା ଏ଼ୱାଣାଇଁ ର଼ ଡାଲିତା ର଼ସାହାଁ କ଼ଟା କାତିଟି ଡ଼଼ଇ ରେ଼ପ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ଡା଼ୟୁ ଏ଼ୱାସି ଜିରୁସାଲମତା ହାଜାନା ସୀସୁୟାଁ ତଲେ ଆଣ୍ତାଲି ଅଣ୍‌ପିମାଚେସି; ସାମା ଏ଼ୱାସି ର଼ ସୀସୁ ଇଞ୍ଜିଁ ଏ଼ୱାରି ଇଚାଣି ନାମାଆନା, ବାରେଜା଼ଣା ଏ଼ୱାଣାଇଁ ଆଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ସାମା ବର୍ନବା ଏ଼ୱାଣାଇଁ ଆସାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ତା଼ଣା ତାତେସି, ଇଞ୍ଜାଁ ଜିରୁତା ଏ଼ୱାସି ଏ଼ନିକିଁ ପ୍ରବୁଇଁ ମେସ୍ତେସି ଇଞ୍ଜାଁ ପ୍ରବୁ ଏ଼ନାଆଁ ତାଙ୍ଗେ ହା଼ଡା ଆ଼ତେସି, ଦମେସକତା ଜୀସୁ ଦ଼ରୁତି ସା଼ସାତଲେ ସା଼ୱୁଲ ଏ଼ନିକିଁ ୱେସାମାଚେସି, ଈ ବାରେ କାତା ଏ଼ୱାରି ନ଼କିତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଅ଼ଡ଼େ ସା଼ୱୁଲ ଏ଼ୱାରିତଲେ ଡ଼ୟିତେସି ଅ଼ଡ଼େ ଜିରୁସାଲମତି ବାରେୱାକି ହାଜାନା ସା଼ସାତଲେ ପ୍ରବୁତି ଦ଼ରୁ ୱେ଼କ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଗ୍ରିକ୍‌ ଜ଼ଲିନି ଜୀହୁଦି ଲ଼କୁତଲେ ବା଼ଦିବା଼ଦା କିହିମାଚେସି, ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ପାରୁ ପାରିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ନାମିତି ତାୟିୟାଁ ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲିଏ, ସା଼ୱୁଲଇଁ କାୟିସରିୟାତା ଅ଼ହାନା ଏମ୍ବାଟି ଏ଼ୱାଣାଇଁ ତାର୍ସତା ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଇଲେଆ଼ହିଁ ଏ଼ ବାରେ ଜୀହୁଦା ରା଼ଜି, ଗାଲିଲି ଅ଼ଡ଼େ ସମିରଣତି କୁଲମି ବା଼ର୍ସୁ ଆ଼ହାନା ପ୍ରବୁଇଁ ଆଜାନା ହିତ୍‌ଡ଼ି ଜୀୱୁତଲେ ମାଚେରି, ଇଞ୍ଜାଁ ସୁଦୁଜୀୱୁତି ସା଼ୟେମି ତଲେ ପାଡାଆ଼ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ଏଚେଟିଏ ପିତର ବାରେ ରା଼ଜିତା ରେ଼ଜି ରେ଼ଜିହିଁ ଲୂଦତା ଡ଼ୟିନି ମାହାପୂରୁ ଲ଼କୁଣି ଆଣ୍ତାଲି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ଏମ୍ବାଆଁ ଏ଼ୱାସି ଏନିୟ ଦ଼ରୁଗାଟି ରଅଣାଇଁ ବେଟାଆ଼ତେସି, ଏ଼ୱାସି ଆ଼ଟା ବାର୍ସା ପାତେକା ଟଟ ୱା଼ୟିତି ର଼ଗ ଆ଼ହାନା କାଟେଲିଟି ନିଙ୍ଗାଲି ଆ଼ଡିହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏନିୟ, ଜୀସୁ କ୍ରୀସ୍ତ ନିଙ୍ଗେ ନେହିଁ କିହାମାଞ୍ଜାନେସି; ନିଙ୍ଗାମୁ ନୀ ପା଼ସ୍‌ପନି ମୁଦା କିମୁ” ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ ଦେବୁଣିଏ ନିଙ୍ଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଏଚେଟିଏ ଲୂଦ ଇଞ୍ଜାଁ ସାରଣତା ବାସା କିହାମାନି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ମେସାନା, ପ୍ରବୁ ତା଼ଣା ହିୟାଁ ୱେଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜାପତା ଟାବିତା ଦ଼ରୁଗାଟି ମାହାପୂରୁଇଁ ନାମିତି ର଼ ଇୟା ମାଚେ, ଗ୍ରିକ୍‌ ତଲେ ଦର୍କା ଇଚିସାରେ ତାନି ଦ଼ରୁ “ର଼ କୂର୍ହୁ ।” ଏ଼ଦି ବାରେବେ଼ଲା ନେହିଁ କାମା କିହିଁ, ହିଲାଆ ଗାଟାରାକି ସା଼ୟେମି କିହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ଏଚିବେ଼ଲାତା ଏ଼ଦି ନ଼ମେରି ଆ଼ହାନା ହା଼ହାହାଚେ, ଲ଼କୁ ଏ଼ଦାନି ଏ଼ୟୁ ମୀତ୍‌ହାନା ଲାକନି ପାରୁତି ର଼ ବାକ୍ରାତା ତ୍ରିପ୍‌ହୁ । ");
INSERT INTO kxv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଇଞ୍ଜାଁ ଲୂଦ ଜାପ ଡାଗେ ମାଚାକି ସୀସୁୟାଁ ପିତର ଜାପତା ମାନେସି ଇଞ୍ଜିଁ ୱେଞ୍ଜାନା, ରୀ ଲ଼କୁଣି ଏ଼ୱାଣି ତା଼ଣା ପାଣ୍ତାନା ଈ କାତା ବାତିମା଼ଲିତେରି, “ମା଼ ତା଼ଣା ୱା଼ହାଲି ୱେ଼ଡ଼ା କିଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପିତର ନିଙ୍ଗାନା ଏ଼ୱାରିତଲେ ହାଚେସି, ଏମ୍ବାଆଁ ଏ଼ୱାସି ୱା଼ହାଲିଏ ଏ଼ୱାଣାଇଁ ଲାକନି ପାରୁତି ବାକ୍ରାତା ଅ଼ତେରି, ଅ଼ଡ଼େ ରା଼ଣ୍ତେଣିସିକା ସା଼ରିସୁଟୁ ମୁଚାନା ଡ଼ୀହି ଡ଼ୀହିଁ ଦର୍କା ନୀଡାମାଚି ବେ଼ଲାତା କେ଼ପାମାଚି ହିମ୍ବରିକା ବାରେ ଏ଼ୱାଣାଇଁ ତ଼ସ୍ତୁ । ");
INSERT INTO kxv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ସାମା ପିତର ବାରେଜା଼ଣାତି ପାଙ୍ଗାତା ପାଣ୍ତାନା ମେଣ୍ତାକୁତାନା ପ୍ରା଼ତାନା କିତେସି; ଇଞ୍ଜାଁ ମାଡ଼୍‌ହା ୱାକି ତିର୍‌ୱାନା ଏଲେଇଚେସି, “ଟାବିତା, ନିଙ୍ଗାମୁ” ଏଚେଟିଏ ଏ଼ଦି କାଣ୍‌କା ଦେଚାନା ପିତରଇଁ ମେସ୍ତେ ଇଞ୍ଜାଁ ନିଙ୍ଗାନା କୁଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ଇଞ୍ଜାଁ ପିତର କେୟୁ ଦା଼ସାନା ଦର୍କାଇଁ ନିକ୍‌ହେସି, ଇଞ୍ଜାଁ ମାହାପୂରୁ ଲ଼କୁ ଅ଼ଡ଼େ ରା଼ଣ୍ତେଣିସିକାଣି ହା଼ଟାନା ଏ଼ଦାନି ନୀଡାମାନାଣି ତ଼ସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଈ କାତା ଜାପତି ସା଼ରିସୁଟୁ ୱେ଼ଙ୍ଗାହାଚେ ଅ଼ଡ଼େ ହା଼ରେକା ଲ଼କୁ ପ୍ରବୁଇଁ ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ଅ଼ଡ଼େ, ପିତର ହା଼ରେକା ଦିନା ପାତେକା ଜାପତି ସିମନ ଦ଼ରୁଗାଟି ତ଼ଲ୍‌କା କାମାକିନାଣି ଇଜ ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାୟିସରିୟା ଗା଼ଡ଼ାତା କର୍ନଲିୟ ଦ଼ରୁଗାଟାସି ର଼ ଲ଼କୁ ମାଚେସି, ଏ଼ୱାସି ଇତାଲିକ ଦ଼ରୁଗାଟି ରମିୟ ରିଜାରି କ଼ସ୍‌କାତି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ଏ଼ୱାସି ର଼ ଦାର୍ମୁ ଲ଼କୁ ମାଚେସି; ତାମି ଇଲୁ କୁଟମି ତଲେ ମାହାପୂରୁଇଁ ଆଜିମାଚେସି, ଏ଼ୱାସି କା଼କୁଲି ଲ଼କୁତାକି ଦା଼ନା ହୀହିମାଚେସି, ଅ଼ଡ଼େ ମାହାପୂରୁ ତା଼ଣା କା଼ଲେଏ ପ୍ରା଼ତାନା କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ର଼ ଦିନା ମିଡ଼୍‌ଅଲା ତୀନି ଗଂଟା ବେ଼ଲାତା ଏ଼ୱାସି ସେୟାଁଣା ହାପାନାତା ତୀର୍‌ପୁତଲେ ମେସ୍ତେସି, ର଼ ମାହାପୂରୁତି ଦୂତୁ ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ୱେସ୍ତେସି “କର୍ନଲିୟ !” ");
INSERT INTO kxv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ଏ଼ୱାସି ଆଜିତଲେ ଦୂତୁ ୱାକି ସିନିକିତେସି ଅ଼ଡ଼େ ୱେଚେସି, “ଈଦି ଏ଼ନାୟି ପ୍ରବୁ ?” ଦୂତୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ନୀ ପ୍ରା଼ତାନା ଅ଼ଡ଼େ ଦା଼ନା ହୀନାୟି ଲାକ ମାହାପୂରୁ ନ଼କିତା ଏଜାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ନୀଏଁ ନୀନୁ ଜାପତା ଲ଼କୁଣି ପାଣ୍ତାନା ସିମନ ପିତର ଦ଼ରୁଗାଟି ଲ଼କୁଇଁ ହା଼ଟାତାମୁ, ଏ଼ୱାଣି ହା଼ଟା ଦ଼ରୁ ପିତର ଇନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ଏ଼ୱାସି ସିମନ ଦ଼ରୁଗାଟି ର଼ ତ଼ଲ୍‌କା କାମାକିନାଣି ଇଜ ଗତାଗାଟାସି ଆ଼ହାମାନେସି, ଏ଼ୱାଣି ଇଲୁ ସାମ୍‌ଦୁରି ଗାଟୁତା ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ତାନିତଲେ କାତା ଆ଼ହିମାଚି ଦୂତୁ ହାଜାଲିଏ, ଏ଼ୱାସି ତାନି ଇଜ କାମା କିନି ରୀ ହ଼ଲିୟାଙ୍ଗାଣି ଇଞ୍ଜାଁ ତାଙ୍ଗେ ସେ଼ବାକିନି ରିଜାରି କ଼ସ୍‌କା ବିତ୍ରାଟି ର଼ ଦାର୍ମୁତି କ଼ହ୍‌ଏଁଣାଇଁ ହା଼ଟିତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏମ୍ବାଆଁ ଆ଼ହାମାଚି ବାରେ କାତା ୱେସାନା ଜାପତା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ଅ଼ର ଦିନା ଏ଼ୱାରି ହାଜି ହାଜିହିଁ ଏ଼ ଗା଼ଡ଼ାତି ଡାଗେ ଆ଼ତେରି, ଏଚିବେ଼ଲା ପିତର ମାଦେନା ବା଼ର ଗଂଟା ବେ଼ଲାତା ପ୍ରା଼ତାନା କିହାଲି ଇଲୁ ଲାକ ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଏ଼ୱାସି ହାକି ଆ଼ତେସି ଅ଼ଡ଼େ ଏ଼ନାଆଁ ତିଞ୍ଜାଲି ମ଼ନ କିତେସି; ସାମା ଏ଼ୱାରି ରା଼ନ୍ଦା ୱାଜିମାଚି ବେ଼ଲାତା, ଏ଼ୱାସି ସେୟାଁଣା ହାପାନା ମେସ୍ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ଲାକପୂରୁ ଦେପିଆ଼ହାମାନେ, ଇଞ୍ଜାଁ ଏ଼ନିକିଁ ର଼ ହିମ୍ବରିତି ସା଼ରି କନତା ଆସ୍‌ପି ଆ଼ହାନା ଦାର୍‌ତି ଲାକ ରେ଼ଚା ୱା଼ହିମାନେ; ");
INSERT INTO kxv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ଏମ୍ବାଆଁ ଦାର୍‌ତିତି ବାରେ କୂଡ଼ାତି ସା଼ରିଗଟା କଡା ଗାଟି ଜ଼ନ୍ତ ଜିୱେଡ଼ିକା, ରା଼ସ୍‌କା ଡ୍ରଗିୟାଁ ଅ଼ଡ଼େ ହା଼ଗୁତି ପଟାୟାଁ ମାନୁ । ");
INSERT INTO kxv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଇଞ୍ଜାଁ ଏ଼ୱାଣାକି ଈ ହା଼ଡା ଆ଼ତେ, “ପିତର; ନିଙ୍ଗାମୁ, ପା଼ୟାନା ତିନାମୁ !” ");
INSERT INTO kxv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ସାମା ପିତର ଏଲେଇଚେସି, “ଆ଼ଏ ପ୍ରବୁ, ନା଼ନୁ ଏଚେଲାୱା ଏ଼ନି ଲାଗେଏ ପ଼ଲେଏତି ଦିଣ୍‌ସୁ ତିଞ୍ଜାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ଅ଼ଡ଼େ ର଼ ପା଼ଲି ଈ ହା଼ଡା ଆ଼ତେ, “ମାହାପୂରୁ ଏ଼ନାଆଁ ସୁଦୁ କିହାମାନେସି, ଏ଼ଦାଆଁ ନୀନୁ ଲାଗେଏତାୟି ଇନାଆନି ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଇଲେକିହିଁ ତୀନି ପା଼ଲି ଆ଼ତେ, ଡା଼ୟୁ ଏ଼ ହିମ୍ବରି ଲାକପୂରୁ ଅ଼ୱିଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର ଏ଼ନାଆଁ ସେୟାଁଣା ହାପାନା ହେ଼ଣ୍ତାମାଚେସି, ଏ଼ଦି ଏ଼ନାୟି, ଇଞ୍ଜିଁ ଅଣ୍‌ପିହିଁ ଆଡାଜାକା ଆ଼ହାମାନି ବେ଼ଲାତା, କର୍ନଲିୟ ତା଼ଣାଟି ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ସିମନ ଇଲୁ ପାରିହିଁ ଦୁୱେରିତା ନିକା ୱା଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ଇଞ୍ଜାଁ ଏ଼ୱାରି ୱେଚେରି, “ସିମନ ଇନି ପିତର ଦ଼ରୁଗାଟାସି ରଅସି ଇମ୍ବାଆଁ ଗତେଏସି ମାନେସି କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର ଏ଼ ସେୟାଁଣା ହାପାନା ହେ଼ଟାଣି ଅଣ୍‌ପିମାଚି ବେ଼ଲାତା ଜୀୱୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ମେହ୍‌ମୁ ! ତୀନି ଜା଼ଣା ଲ଼କୁ ନିଙ୍ଗେ ପାରିମାଞ୍ଜାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ଏ଼ଦାଆଁତାକି ତିୟାରା ଆ଼ମୁ ଅ଼ଡ଼େ ଡ଼଼ଇ ହାଲାମୁ, ଅ଼ଡ଼େ ଆନାମାନା ଆ଼ଆନା ଏ଼ୱାରିତଲେ ହାଲାମୁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ନା଼ନୁ ଏ଼ୱାରାଇଁ ପାଣ୍ତାମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ଏଚେଟିଏ ପିତର ଏ଼ ଲ଼କୁତା଼ଣା ରେ଼ଚାୱା଼ହାନା ଏଲେଇଚେସି, “ମୀରୁ ଆମ୍ବାଆରାଇଁ ପାରିମାଞ୍ଜେରି, ନା଼ନୁ ଏ଼ୱାତେଏଁ । ମୀରୁ ଏ଼ନାଆଁତାକି ୱା଼ହାମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ଏ଼ୱାରି ଏଲେଇଚେରି, “କର୍ନଲିୟ ଦ଼ରୁଗାଟି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ମାଙ୍ଗେ ପାଣ୍ତାମାଞ୍ଜାନେସି, ଏ଼ୱାସି ର଼ ସୁଦୁ, ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜାଁ ମାହାପୂରୁଇଁ ଆଜିନାସି, ଅ଼ଡ଼େ ବାରେ ଜୀହୁଦି କୂଡ଼ାତା ୱେ଼ଙ୍ଗିତାସି, ଏ଼ୱାସି ନିଙ୍ଗେ ତାମି ଇଜ ହା଼ଟାନା ନୀ ଜା଼ପ୍‌ନାଣି ୱେଞ୍ଜାଲିତାକି ମାହାପୂରୁତି ଦୂତୁ ତା଼ଣାଟି ହୁକୁମି ବେଟା ଆ଼ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ପିତର ବିତ୍ରା ହା଼ଟା ଅ଼ହାନା ଏ଼ୱାରାଇଁ ସେ଼ବା କିତେସି । ଅ଼ର ନେ଼ଚୁ ନିଙ୍ଗାନା ତିୟାରା ଆ଼ହାନା ଏ଼ୱାରିତଲେ ହାଚେସି; ଜାପତି ଏଚରଜା଼ଣା ନାମିତି ତାୟିୟାଁ ଏ଼ୱାରିତଲେ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଅ଼ର ନେ଼ଚୁ ଏ଼ୱାରି କାୟିସରିୟାତା ଏତେରି, ଏମ୍ବାଆଁ କର୍ନଲିୟ ତାନି କୁଟମି ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ଜାଟୁତି ତ଼ଣେସିଙ୍ଗାଣି ହା଼ଟାହାଁ କୂଡ଼ି କିହାନା ଏ଼ୱାରାଇଁ କା଼ଚିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର ବିତ୍ରା ହାଜାଲିଏ କର୍ନଲିୟ ଏ଼ୱାଣି କଡାଁ ଡ଼଼ଇ ମୁନୁ କୁତାନା ଜହରା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ସାମା ପିତର ତାଙ୍ଗେ ନିକ୍‌ହାନା ଏଲେଇଚେସି, “ନିଙ୍ଗାମୁ, ନା଼ନୁ ଜିକେଏ ର଼ ମାଣ୍‌ସିତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ଏଚେଟିଏ ପିତର କର୍ନଲିୟ ତଲେ କାତା ଆ଼ହିଁ ଆ଼ହିଁ ଇଲୁ ବିତ୍ରା ହାଜାନା ଏମ୍ବାଆଁ ହା଼ରେକା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ହାମାନାଣି ମେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏଟ୍‌କା କୂଡ଼ାତି ଏ଼ନି ଲ଼କୁତଲେ ଆଣ୍ତିନାୟି କି ଏ଼ ଲ଼କୁ ଡାଗେ ହାନାୟି ଜୀହୁଦି ଲ଼କୁତାକି ଏ଼ନିକିହିଁ ମେ଼ରା ହିଲେଏ, ଏ଼ଦାଆଁ ମୀରୁ ନେହିଁକିଁ ପୁଞ୍ଜାମାଞ୍ଜେରି ଆ଼ତିଜିକେଏ ଆମିନି ଲ଼କୁଇଁ ସୁଦୁ ହିଲାଆ ଗାଟାରି କି ଲାଗେଏତାରି ଇଞ୍ଜିହିଁ ଇନାଆନି ଇଞ୍ଜିଁ ମାହାପୂରୁ ନାଙ୍ଗେ ତ଼ସାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ଏ଼ଦାଆଁତାକି ହା଼ଟନିଏ ନା଼ନୁ ଏ଼ନାଆଁ ଅଣ୍‌ପାଆନା ୱା଼ତେଏଁ । ଈଦାଆଁତାକି ନା଼ନୁ ୱେଞ୍ଜିମାଞ୍ଜାଇଁ, ଏ଼ନାଆଁ କିହାଲି ମୀରୁ ନାଙ୍ଗେ ହା଼ଟାତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ନଲିୟ ଏଲେଇଚେସି, “ତୀନିଦିନା ନ଼କେଏ ଈ ବେ଼ଲାତା ମିଡ଼୍‌ଅଲା ତୀନି ଗଂଟା ବେ଼ଲା ନା଼ନୁ ନା଼ ଇଜ ପ୍ରା଼ତାନା କିହିମାଚେଏଁ; ମେହ୍‌ମୁ ଏମ୍ବାଆଁ ଉଜେଡ଼ିଗାଟି ଦବ୍‌ଲା ହିମ୍ବରିକା ତୁର୍‌ହାମାନି ର଼ ଲ଼କୁ ନା଼ ନ଼କିତା ନିତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଞ୍ଜାତେସି, ‘କର୍ନଲିୟ ! ମାହାପୂରୁ ନୀ ପ୍ରା଼ତାନା ୱେଞ୍ଜାମାନେସି; ଇଞ୍ଜାଁ ହିଲାଆ ଗାଟାରାକି ନୀ ଦା଼ନା ହୀନାୟି ବାରେ ମାହାପୂରୁ ନ଼କିତା ନେହିଁ ତ଼ଞ୍ଜା ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ଈଦାଆଁତାକି ସିମନ ଦ଼ରୁଗାଟି ପିତରଇଁ ହା଼ଟା ତାଚାଲି ଜାପତା ଲ଼କୁଇଁ ପାଣ୍ତାମୁ, ଏ଼ୱାସି ସାମ୍‌ଦୁରି ଗାଟୁତା ଡ଼ୟିନି ତ଼ଲ୍‌କା କାମା କିନି ସିମନ ଇଜ ଗତାଗାଟାସି ଆ଼ହାମାନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଏ଼ଦାଆଁତାକି ୱେ଼ଡ଼ାକିଆନା ନା଼ନୁ ନୀ ତା଼ଣା ଲ଼କୁ ପାଣ୍ତାତେଏଁ, ଅ଼ଡ଼େ ନୀନୁ ୱା଼ହାମାଞ୍ଜି ନେହିଁ କିହାମାଞ୍ଜି, ଇଚିହିଁ ପ୍ରବୁ ନିଙ୍ଗେ ଏ଼ନାଆଁ ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି, ଏ଼ଦାଆଁ ୱେଞ୍ଜାଲିତାକି ମା଼ମ୍ବୁ ବାରେ ମାହାପୂରୁ ନ଼କିତା କୂଡ଼ା ଆ଼ହାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ଏଚେଟିଏ ପିତର ଗୂତି ଏ଼କ୍‌ହାନା ଏଲେଇଚେସି, “ମାହାପୂରୁ ସାତେଏ ବାରେ ଲ଼କୁଣି ପାର୍‌ଡ଼ା ବାଚି କିଅସି, ");
INSERT INTO kxv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଆମିନି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ଆଜିନେରି ଅ଼ଡ଼େ ଏ଼ୱାସି ଅ଼ପିନି ଲେହେଁ ନେହିଁ କାମା କିନେରି ଏ଼ୱାରି ଆମିନି କୂଡ଼ାତାରି ଇଚିହିଁ ଜିକେଏ, ଏ଼ୱାସି ଆବିନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ଏ଼ୱାସି ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣାଟି ହିତ୍‌ଡ଼ିତି ନେହିଁ କାବ୍ରୁ ୱେସାନା ଇସ୍ରାୟେଲ ମୀର୍‌କା ନ଼କିତା ଈ ବ଼ଲୁ ପାଣ୍ତିତେସି; ଏ଼ ଜୀସୁ କ୍ରୀସ୍ତ ବାରେତି ପ୍ରବୁ । ");
INSERT INTO kxv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି ଜହନ ବାପ୍ତିସ୍ମ କାତା ୱେ଼କ୍‌ହି ତା଼ଣାଟିଏ ଏ଼ ନେହିଁ କାବ୍ରୁ ଗାଲିଲିଟିଏ ମା଼ଟ୍‌ହାନା ବାରେ ଜୀହୁଦା ରା଼ଜିତି ଲ଼କୁତା଼ଣା ୱେ଼ଙ୍ଗାମାନେ, ");
INSERT INTO kxv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ଇଚିହିଁ ନା଼ଜରିତ ଜୀସୁତି କାତା ପୁଞ୍ଜାମାଞ୍ଜେରି, ଏ଼ନିକିଁ ମାହାପୂରୁ ଏ଼ୱାଣାକି ସୁଦୁଜୀୱୁ ଇଞ୍ଜାଁ ବା଼ଡ଼୍‌ୟୁ ହୀହାନା ବ଼ର ହୀତେସି, ଇଞ୍ଜାଁ ନେହିଁ କାମା କିହିଁ ସୟତାନ ପା଼ନ୍ଦାତା ଦସ୍‌ପି ଆ଼ହାମାନି ଲ଼କୁଣି ନେହିଁ କିହିଁ ବାରେୱାକି ରେ଼ଚେସି, ଇଚିହିଁ ମାହାପୂରୁ ଏ଼ୱାଣିତଲେ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁତି ଦେ଼ସାତା ଅ଼ଡ଼େ ଜିରୁସାଲମତା ଏ଼ନା ଏ଼ନାଆଁ କିତେସି, ମା଼ମ୍ବୁ ଏ଼ ବାରେତି ସା଼କି; ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାତା ଏ଼କ୍‌ହାନା ପା଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ସାମା ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ତୀନି ଦିନାତା ନିକ୍‌ହେସି ଅ଼ଡ଼େ ତ଼ଞ୍ଜାଆ଼ୱି କିତେସି; ");
INSERT INTO kxv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ବାରେଜା଼ଣା ତାକି ଆ଼ଏ, ୱାର୍‌ଇ ମାହାପୂରୁ ଆ଼ଚିତି ସା଼କି, ଇଚିହିଁ ମା଼ ନ଼କିତା ତ଼ଞ୍ଜାଆ଼ତେସି । ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ହା଼କିଟି ନିକ୍‌ହି ଜେ଼ଚ ମା଼ମ୍ବୁ ଏ଼ୱାଣିତଲେ ତିଚମି ଉଟମି । ");
INSERT INTO kxv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଅ଼ଡ଼େ ଲ଼କୁ ନ଼କିତା ଈ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି, ଇଞ୍ଜାଁ ହା଼ତାରି ଅ଼ଡ଼େ ଜୀୱୁତା ନୀଡାମାନାରି ନୀହାଁୟି କିନାସି ଆ଼ହାଲି ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଆ଼ଚାମାନେସି ଇଞ୍ଜିଁ ସା଼କି ହୀହାଲି ଏ଼ୱାସି ମାଙ୍ଗେ ହୁକୁମି ହିୟାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ଆମ୍ବାଆସି ଏ଼ୱାଣି ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ଏ଼ୱାଣି ଦ଼ରୁତଲେ ପା଼ପୁ ମ୍ଣେପ୍‌କି ଆ଼ନେସି, ଈଦାଆଁ ବାରେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଏ଼ୱାଣି କାତାତି ସା଼କି ହୀହାମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର ଈ ବାରେ କାତା ୱେସିମାଚି ବେ଼ଲାତା ଆମିନି ଗାଟାରି ତାନି ବ଼ଲୁ ୱେଞ୍ଜିମାଚେରି, ଏ଼ ବାରେଜା଼ଣାତି ମୁହେଁ ସୁଦୁଜୀୱୁ ରେ଼ଚାୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ଜିକେଏ ସୁଦୁଜୀୱୁ ରେ଼ଚା ୱା଼ତାଣି ମେସାନା ପିତର ତଲେ ଜାପଟି ୱା଼ହାମାଚି ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ନାମିତି ଜୀହୁଦିୟାଁ, ଏ଼ୱାରି ବାରେଜା଼ଣା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ଇଚିହିଁ ଏ଼ୱାରି ଏଟ୍‌କା ଏଟ୍‌କା ହା଼ଡାତଲେ କାତା ଆ଼ହିମାଚାଣି ଇଞ୍ଜାଁ ମାହାପୂରୁତି ଜହରା କିହିମାନାଣି ୱେଚେରି । ଏଚିବେ଼ଲା ପିତର ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ଈୱାରି ଆମିନି ଲ଼କୁ ମା଼ ଲେହେଁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାମାନେରି, ଈୱାରି ଏ଼ୟୁତଲେ ବାପ୍ତିସ୍ମ ବେଟାଆ଼ହାଲି ଆମ୍ବାଆସି କା଼ହି କିୟାଲି ଆ଼ଡିମାନେସି ?” ");
INSERT INTO kxv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଇଞ୍ଜାଁ, ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁତଲେ ବାପ୍ତିସ୍ମ ହୀହାଲି ହୁକୁମି ହୀତେସି, ଡା଼ୟୁ ଏ଼ୱାରି ଏଚରଦିନା ଡ଼ୟାଲି ଏ଼ୱାଣାଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଜୀହୁଦିଆ଼ଆତାରି ଜିକେଏ ମାହାପୂରୁତି ବ଼ଲୁ ନାମିତେରି, ଈ କାତା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଇଞ୍ଜାଁ ଜୀହୁଦା ରା଼ଜିତା ମାନି ତାୟିୟାଁ ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ପିତର ଏଚିବେ଼ଲା ଜିରୁସାଲମତା ୱା଼ତେସି, ଏଚିବେ଼ଲା ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ସୀସୁୟାଁ ପିତର ତଲେ ବା଼ଦିବା଼ଦା ଆ଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ନୀନୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ଇଲ୍‌କାଣା ହାଜାନା ଏ଼ୱାରିତଲେ ତିଞ୍ଜାମାଞ୍ଜି !” ");
INSERT INTO kxv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ସାମା ପିତର ଈ ବାରେ କାତାତି ମୂଲୁଟିଏ ୱେସାଲି ମା଼ଟ୍‌ହାନା ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ନା଼ନୁ ଜାପ ଗା଼ଡ଼ାତା ପ୍ରା଼ତାନା କିହିମାଚେଏଁ, ଇଞ୍ଜାଁ ସେୟାଁଣା ହାପାନାତା ମେସ୍ତେଏଁ, ଏ଼ନିକିଁ ର଼ କାଜା ହିମ୍ବରିତି ସା଼ରି କନତା ଆସାହାଁ ଲାକପୂରୁଟି ଡ଼଼ଇ ରେ଼ଚା ୱା଼ହିମାଚେ, ଅ଼ଡ଼େ ଏ଼ଦି ନା଼ ପାତେକା ୱା଼ତେ; ");
INSERT INTO kxv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ନା଼ନୁ ଏମ୍ବାଆଁ ସିନିକିହାନା ଅଣ୍‌ପାଲି ମା଼ଟ୍‌ହେଏଁ, ଏମ୍ବାଆଁ ଦାର୍‌ତିତି ସା଼ରିଗଟା କଡାୟାଁ ତଲେ ତା଼କିନି ନା଼ସ୍‌କାତି ଜ଼ନ୍ତ ଇଞ୍ଜାଁ ଜା଼ଡ଼ାତି ଜ଼ନ୍ତ ଡ୍ରଗିୟାଁ ରା଼ସ୍‌କା ଅ଼ଡ଼େ ହା଼ଗୁତି ପଟାୟାଁ ମେସ୍ତେଏଁ, ");
INSERT INTO kxv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ଅ଼ଡ଼େ ନାଙ୍ଗେ ୱେସାମାଞ୍ଜାନି ଈ ହା଼ଡା ଜିକେଏ ୱେଚେଏଁ, ‘ପିତର; ନିଙ୍ଗାମୁ, ପା଼ୟାନା ତିନାମୁ !’ ");
INSERT INTO kxv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ସାମା ନା଼ନୁ ଏଲେଇଚେଏଁ, ‘ଆ଼ଏ ପ୍ରବୁ ! ଡୀଗାଆଗାଟି ଲାଗେଏ ପ଼ଲେଏତି କା଼ଦି ନା଼ନୁ ଏଚେଲାୱା ନା଼ ଗୂତିତା ଅ଼ହାହିଲଅଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ସାମା ଅ଼ର ଦେବା ଲାକପୂରୁଟି ଈ ହା଼ଡା ୱେସ୍ତାତେ, ‘ମାହାପୂରୁ ଏ଼ନାଆଁ ସୁଦୁ କିହାମାନେସି, ଏ଼ଦାଆଁ ନୀନୁ ଲାଗେଏତାୟି ଇନାଆନି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ଇଲାଆ଼ହିଁ ତୀନି ପା଼ଲି ଆ଼ତେ, ଅ଼ଡ଼େ ଡା଼ୟୁ ଏ଼ ବାରେ ୱେଣ୍ତେ ଲାକପୂରୁ ଅ଼ୱିଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ଦେବୁଣିଏ ତୀନି ଜା଼ଣା ଲ଼କୁ ମା଼ମ୍ବୁ ଆମିନି ଇଲୁତା ମାଚମି ଏମ୍ବାଆଁ ୱା଼ହାନା ନିତେରି, ଏ଼ୱାରି କାୟିସରିୟାଟିଏ ନା଼ ତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଇଞ୍ଜାଁ ଆନାମାନା ଆ଼ଆନା ଏ଼ୱାରିତଲେ ହାଜାଲି ଜୀୱୁ ନାଙ୍ଗେ ୱେସ୍ତାତେ, ଅ଼ଡ଼େ ଈ ସ଼ ଜା଼ଣା ତାୟିୟାଁ ଜିକେଏ ନା଼ ତଲେ ଜାପଟି କାୟିସରିୟାତା ୱା଼ତେରି, ଇଞ୍ଜାଁ ମା଼ମ୍ବୁ ଏ଼ କର୍ନଲିୟ ଇଜ ହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ଏ଼ୱାସି ଏ଼ନିକିଁ ର଼ ଦୂତୁଇଁ ସେୟାଁଣା ହାପାନାତା ମେସାମାଚେସି, ଏ଼ଦାଆଁ ମାଙ୍ଗେ ୱେସ୍ତାତେସି, ଏ଼ ଦୂତୁ ଏ଼ନିକିଁ ଏ଼ୱାଣି ଇଜ ନିଚାନା ୱେସ୍ତେ, ଜାପତା ଲ଼କୁଣି ପାଣ୍ତାନା ପିତର ଇନି ସିମନଇଁ ହା଼ଟାତାମୁ; ");
INSERT INTO kxv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ଏ଼ୱାସି ମିଙ୍ଗେ ୱେସ୍ତାନି କାତାତଲେ ‘ମୀରୁ ଅ଼ଡ଼େ ମୀ ବାରେ କୁଟମି ଗେଲ୍‌ପି ଆ଼ଦେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ଡା଼ୟୁ ନା଼ନୁ ଜ଼ଲାଲି ମା଼ଟ୍‌ହାଲିଏ ସୁଦୁଜୀୱୁ ମା଼ ଲାକ ଏ଼ନିକିଁ ରେ଼ଚାୱା଼ତେ, ଏଲେକିଁ ଏ଼ୱାରି ଲାକ ଜିକେଏ ରେ଼ଚାୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ଏଚିବେ଼ଲା ପ୍ରବୁ ୱେସ୍ତି ଈ ହା଼ଡା ନା଼ ଅଣ୍‌ପୁତା ୱା଼ତେ; ‘ଜହନ ଏ଼ୟୁତଲେ ବାପ୍ତିସ୍ମ ହୀତେସି ସାତା, ସାମା ମୀରୁ ସୁଦୁଜୀୱୁ ତଲେ ବାପ୍ତିସ୍ମ ଆ଼ଦେରି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ଇଚିହିଁ ମା଼ର ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣା ନାମିତି ବେ଼ଲାତା ମାହାପୂରୁ ଏ଼ନିକିଁ ମାଙ୍ଗେ ଆମିନି ଦା଼ନା ହୀହାମାଞ୍ଜାତେସି, ଏଲେକିହିଁଏ ଏ଼ୱାରାକି ଜିକେଏ ସମାନା ଦା଼ନା ହୀତେସି; ନା଼ନୁ ଆମ୍ବାଆତେଏଁ ମାହାପୂରୁଇଁ କା଼ହି କିହାଲି ଆ଼ଡିଇଁ !” ");
INSERT INTO kxv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଏ଼ୱାରି ଈ ବାରେ କାତା ୱେଞ୍ଜାଲିଏ ଏ଼ୱାରି ପାଲେଏ ଆ଼ତେରି, ଇଞ୍ଜାଁ ମାହାପୂରୁଇଁ ଜହରା କିହିଁ ଏଲେଇଚେରି, “ଆତିହିଁ ମାହାପୂରୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁକି ଜିକେଏ ହିୟାଁ ୱେଟ୍‌ହାଲି ଅ଼ଡ଼େ ନୀଡାଲି ପାରୁ ହୀହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ଏଚେଟିଏ ସ୍ତିପାନ ହା଼ତି ଡା଼ୟୁ, ଏଚେକା ନାମୁଗାଟାରି କସ୍ତ ନିନ୍ଦା ଆ଼ତାକି ଆଲାରା ଆ଼ହାମାଚାରି ବିତ୍ରାଟି, ପୟିନିକିୟା, କୁପ୍ର ଅ଼ଡ଼େ ଆନ୍ତିୟକିୟା ପାତେକା ରେ଼ଜାନା ୱାର୍‌ଇ ଜୀହୁଦି ଲ଼କୁ ପିସ୍‌ପେ ଅ଼ଡ଼େ ଆମ୍ବାଆରି ତା଼ଣା ନେହିଁ କାବ୍ରୁ ୱେସିହିଲାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ସାମା ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା କୁପ୍ର ଅ଼ଡ଼େ କୁରିଣିୟ ଲ଼କୁ ଆନ୍ତିୟକିୟା ୱା଼ହାନା ଗ୍ରିକ୍‌ ଲ଼କୁତା଼ଣା ଜିକେଏ କାତା ୱେସିହିଁ ପ୍ରବୁ ଜୀସୁତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ଅ଼ଡ଼େ, ଏ଼ୱାରିତଲେ ପ୍ରବୁତି ବା଼ଡ଼୍‌ୟୁ ମାଚେ, ଅ଼ଡ଼େ ହା଼ରେ ହା଼ରେକା ଲ଼କୁ ନାମାହାଁ ପ୍ରବୁ ୱାକି ୱେଣ୍ଡାୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ଏ଼ୱାରି ହା଼ଡା ଜିରୁସାଲମତି କୁଲମିତା ଏଗାହାଚେ, ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଆନ୍ତିୟକିୟା ପାତେକା ବର୍ନବାଇଁ ପାଣ୍ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ଏ଼ୱାସି ଏମ୍ବାଆଁ ଏଜାନା ମାହାପୂରୁତି କାର୍ମାମେସାନା ରା଼ହାଁ ଆ଼ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ନିକିଁ ହିୟାଁତା ରଣ୍ତିଏ ରା଼ହାଁତଲେ ପ୍ରବୁ ତା଼ଣା ମାନାପେରି ଇଞ୍ଜିଁ ଏ଼ୱାରାକି ବା଼ର୍ସୁ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍ନବା ର଼ ନେହିଁ ଲ଼କୁ, ନାମୁତା ଇଞ୍ଜାଁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାମାନାସି ମାଚେସି, ଇଞ୍ଜାଁ ଇଲେତି ବ଼ଲୁ ୱେ଼କ୍‌ନି ତା଼ଣା ହା଼ରେକା ଲ଼କୁ ପ୍ରବୁ ତା଼ଣା ଆଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ଡା଼ୟୁ ବର୍ନବା ସା଼ୱୁଲଇଁ ପାରାଲି ତାର୍ସ ଗା଼ଡ଼ାତା ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଇଞ୍ଜାଁ, ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ବେଟାଆ଼ହାନା ଆନ୍ତିୟକିୟାତା ତାଚିହିଁ ୱା଼ତେସି, ଏ଼ୱାରି ର଼ ବାର୍ସା ପାତେକା କୁଲମି ତଲେ ମାଞ୍ଜାନା ହା଼ରେକା ଲ଼କୁଣି ଜା଼ପ୍‌ହେରି, ଅ଼ଡ଼େ ଆନ୍ତିୟକିୟାତି ସୀସୁୟାଁ ତଲିଏ କ୍ରୀସ୍ତାନା ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ଏଚିବେ଼ଲାତା ଏଚରଜା଼ଣା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଜିରୁସାଲମଟି ଆନ୍ତିୟକିୟାତା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ଏ଼ୱାରି ବିତ୍ରାଟି ଆଗାବ ଦ଼ରୁଗାଟି ର଼ ଲ଼କୁ ନିଙ୍ଗାନା ବାରେ ଦାର୍‌ତିତା କାଜା କା଼ତାରା ଆ଼ନେ ଇଞ୍ଜିଁ ଜୀୱୁତି ବା଼ଡ଼୍‌ୟୁ ତଲେ ୱେସ୍ତେସି; ଏ଼ଦି କ୍ଲାୱୁଦିୟା ସା଼ଲୱି କିନାଣି ବେ଼ଲାତା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ଏମ୍ବାଟିଏ ସୀସୁୟାଁ ତା଼ମ୍ବୁ ତାମି ଆ଼ଡିନି ଲେହେଁ ଜୀହୁଦା ରା଼ଜିତା ମାନି ନାମିତି ତାୟିୟାଁକି ସା଼ୟେମି କିୟାଲି ତୀରି କିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଅ଼ଡ଼େ, ଏ଼ୱାରି ଜିକେଏ ଟାକାୟାଁ କୂଡ଼ି କିହାନା ଏ଼ କୁଲମିତି ପ୍ରାଚିନାଙ୍ଗା କେୟୁତା ହୀହାଲି ବର୍ନବା ଅ଼ଡ଼େ, ସା଼ୱୁଲ କେୟୁତା ଟାକାୟାଁ ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଏଚିବେ଼ଲାତା ରାଜା ହେରଦ କୁଲମିତି ଏଚର ଜା଼ଣାଇଁ ସା଼ସ୍ତି ହୀହାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ଏ଼ୱାସି ଜହନତି ତାୟି ଜାକୁବଇଁ କାଣ୍ତାତଲେ ପା଼ୟି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଅ଼ଡ଼େ, ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣି ତାକି ରା଼ହାଁ ଆ଼ହାମାନାଣି ମେସାନା ଏ଼ୱାସି ପିତରଇଁ ଜିକେଏ ଆସ୍ତେସି, ଏଚିବେ଼ଲାତା ପୁଲା ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ଏଚେଟିଏ ଏ଼ୱାସି ପିତରଇଁ ଦସ୍‌ପାନା କା଼ୟିଦି ଇଲୁତା ଇଟିତେସି, ଇଞ୍ଜାଁ ପିସ୍‌ପିଆ଼ନି ପାର୍ବୁ ରା଼ତି ଡା଼ୟୁ ଏ଼ୱାଣାଇଁ ବାରେ ଲ଼କୁ ନ଼କିତା ତାଚାଲି ଅଣ୍‌ପାନା ଏ଼ୱାଣାଇଁ କା଼ଚାଲି ସା଼ରି ଜା଼ଣା ଲାକା ସା଼ରି ଗଚି କ଼ସ୍‌କା କେୟୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପିତରଇଁ କା଼ୟିଦିତା ସୁଣ୍ତିତେରି, ସାମା ଏ଼ୱାଣି ତାକି କୁଲମି ରଣ୍ତିଏ ହିୟାଁ ତଲେ ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ଡା଼ୟୁ ହେରଦ ଆମିନି ଦିନା ପିତରଇଁ ହ଼ପ୍‌ହାଲି ଅଣ୍‌ପାମାଚେସି, ଏ଼ ନେ଼ଚୁ ଲା଼ଆଁୟାଁ ପିତର ରୀ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପି ଆ଼ହାନା ରୀ କ଼ସ୍‌କା ମାଦି ଡୂରାମାଚେସି, ଅ଼ଡ଼େ କା଼ଃଆନାରି କା଼ୟିଦି ଇଲୁ ଦୁୱେରିତା କା଼ଚାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଅ଼ଡ଼େ ମେହ୍‌ଦୁ, ଦେବୁଣିଏ ପ୍ରବୁତି ର଼ ଦୂତୁ ଏମ୍ବାଆଁ ତ଼ଞ୍ଜାଆ଼ତେ, ଇଞ୍ଜାଁ ଇଲୁ ବିତ୍ରା ଉଜେଡ଼ି ଆ଼ହାହାଚେ, ଅ଼ଡ଼େ ପିତରଇଁ ବମିତା ଡୀଗାହାଁ ନିକ୍‌ହାନା ଏଲେଇଚେ, “ତବେ ନିଙ୍ଗାମୁ,” ଏମ୍ବାଟିଏ ଏ଼ୱାଣି କେସ୍କାତି ହିକ୍‌ଣିୟାଁ ହୁଙ୍ଗାହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ଏଚେଟିଏ ଦୂତୁ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେ, “ଟେଡେଲି ରୂପା କଡାମୁ ଇଞ୍ଜାଁ ସେପୁୟାଁ ତୁର୍‌ମୁ” ଇଞ୍ଜାଁ ପିତର ଏଲେକିତେସି, ଅ଼ଡ଼େ ଦୂତୁ ଏଲେଇଚେ, “ନୀ ହିମ୍ବରି ପର୍‌ହାନା ନା଼ ଜେ଼ଚ ଜେ଼ଚ ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ପିତର ହ଼ଚାନା ଏ଼ୱାଣି ଜେ଼ଚ ଜେ଼ଚ ହାଚେସି; ସାମା ଦୂତୁ ତା଼ଣାଟି ଏ଼ନାଆଁ କିୱିଆ଼ତେ, ଏ଼ଦି ସାତେଏ ଏ଼ଦାଆଁ ପୁନାଆନା ଏ଼ୱାସି ହାପାନା ହେ଼ଣ୍ତିମାଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଏଚିବେ଼ଲାତା ଏ଼ୱାରି ନ଼କିତି ଅ଼ଡ଼େ ଏ଼ଦାଣି ଡା଼ୟୁ କା଼ଚାମାଚାରାଇଁ ଗା଼ଣ୍‌ଚାନା ଆମିନି ଲ଼ହ ଦୁୱେରି ହୀହାନା ଗା଼ଡ଼ାତା ହ଼ଡାଲି ଆ଼ନେ, ଏ଼ଦାଆଁ ଡାଗେ ୱା଼ହାଲିଏ, ଏଚେ଼ତା ଏ଼ ଦୁୱେରି ତା଼ନୁ ତା଼ନୁଏ ଏ଼ୱାରାକି ଦେପି ଆ଼ହାହାଚେ, ଅ଼ଡ଼େ ଏ଼ୱାରି ହ଼ଚା ହାଜାନା ର଼ ଆଂଗେଣି ମୁଟ୍‌ହାମାନି ପାତେକା ହାଚେରି, ଇଞ୍ଜାଁ ଦେବୁଣିଏ ଏ଼ ଦୂତୁ ଏ଼ୱାଣାଇଁ ପିସା ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ଏଚେଟିଏ ପିତର ସେତ୍‌ନା ଆ଼ହାନା ଏଲେଇଚେସି, “ପ୍ରବୁ ତାନି ଦୂତୁଇଁ ପାଣ୍ତାନା ହେରଦ କେୟୁଟି ଅ଼ଡ଼େ ବାରେ ଜୀହୁଦି ଲ଼କୁ ଅଣ୍‌ପିମାଚି ତା଼ଣାଟି ପିସ୍‌ପି କିହାଁ ମାଞ୍ଜାନେସି, ଈଦାଆଁ ନୀଏଁ ନା଼ନୁ ସାତେଏ ପୁଚେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ଏ଼ୱାସି ଈ କାତା ଅଣ୍‌ପିହିଁ ମାର୍କ ଦ଼ରୁଗାଟି ଜହନ ତାମି ଇୟା ମରିୟମନି ଇଜ ହାଚେସି; ଏମ୍ବାଆଁ ହା଼ରେକା ଲ଼କୁ ରୁଣ୍ତା ଆ଼ହାନା ପ୍ରା଼ତାନା କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର ପାଙ୍ଗାତି ଦୁୱେରିତା ୱେ଼ଚାଲିଏ, ରଦା ଦ଼ରୁଗାଟି ର଼ ହ଼ଲେଣି ଆମ୍ବାଆତେରି ଇଞ୍ଜିଁ ୱେଞ୍ଜାଲି ହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ଏ଼ଦି ପିତରତି ହା଼ଡା ୱେଞ୍ଜାନା ରା଼ହାଁତାକି ଦା଼ରା ଦେଃଆନା ବିତ୍ରା ଦାବ୍‌ଡ଼ି ହାଜାନା ଦା଼ରା ଡାକିତା ପିତର ନିଚାମାନେସି ଇଞ୍ଜିଁ ୱେସ୍ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ଏ଼ୱାରି ଏ଼ଦାନି ଏଲେଇଚେରି, “ନୀନୁ ବାୟା ଆ଼ତିକି ଇଞ୍ଜିଁ ଇଚେରି,” ସାମା ଏ଼ଦି ଏ଼ଦାଆଁ ସାତା ଇଞ୍ଜିଁ ଗାଡିକିହିଁ ୱେସ୍ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏଲେଇଚେରି, “ଏ଼ଦି ଏ଼ୱାଣି ଦୂତୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ସାମା ପିତର ଦା଼ରାତା ଅଲେ ଅଲେ ୱେ଼ଚିମାଚାକି, ଏ଼ୱାରି ଦା଼ରା ଦେଚାନା ଏ଼ୱାଣାଇଁ ମେସାନା କାବା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପାଲେଏ ମାଞ୍ଜାଲି କେୟୁ ଜୀଞ୍ଜିତେସି, ଇଞ୍ଜାଁ ପ୍ରବୁ ଏ଼ୱାଣାଇଁ ଏ଼ନିକିଁ କା଼ୟିଦି ଇଲୁଟି ହ଼ପ୍‌ହା ତାତେସି ଏ଼ୱାରାଇଁ ୱେସ୍ତେସି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏଲେଇଚେସି “ଈ ବାରେ କାତା ଜାକୁବ ଅ଼ଡ଼େ ବାରେ ନାମିତି ତାୟିୟାଁଇଁ ୱେହ୍‌ଦୁ,” ଇଞ୍ଜାଁ ଏ଼ୱାସି ତା଼କିହିଁ ଅ଼ର ଟା଼ୟୁତା ହାଜାତୁସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ଲା଼ଇ ୱେ଼ୟାଲିଏ ପିତର ଆମ୍ବିୟା ହାଚେସି ଇଞ୍ଜିଁ କା଼ପୁ କା଼ଃଆନି କ଼ସ୍‌କା କାବାଆ଼ହାନା ହା଼ରେକା ବିଲ୍‌କି ଆ଼ତେରି ? ");
INSERT INTO kxv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ଅ଼ଡ଼େ, ହେରଦ ଏ଼ୱାଣାଇଁ ପାରି କିହାନା ପ୍ଣାଃଆଲିଏ, କା଼ପୁ କା଼ଃନାରାଇଁ ୱେଚି ଡା଼ୟୁ, ଏ଼ୱାରାଇଁ ପା଼ୟାଲି ହୁକୁମି ହୀତେସି । ଏ଼ଦାଆଁ ଡା଼ୟୁ ହେରଦ ଜୀହୁଦା ରା଼ଜିଟି କାୟିସରିୟାତା ହାଜାନା ଏମ୍ବାଆଁ ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ଏଚିବେ଼ଲା ହେରଦ ସ଼ର ଅ଼ଡ଼େ ସିଦନତି ଲ଼କୁତାକି ଆଜିହ଼ପେତି କ଼ପା ଆ଼ହାମାଚେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ରଣ୍ତିଏ କାତା ଆ଼ହାନା ଏ଼ୱାଣି ତା଼ଣା ୱା଼ତେରି, ଇଞ୍ଜାଁ ରାଜା ଇଲୁତି ବ୍ଲାସ୍ତସ୍‌ ଇନି ସା଼ଲୱି କିନାଣାଇଁ ତାମି ୱାକି କିହାନା, ରାଜାଇଁ ହିତ୍‌ଡ଼ି ତାକି ବାତିମା଼ଲିତେରି, ଇଚିହିଁ ହେରଦ ରାଜା ଦେ଼ସାଟି ସ଼ର ଅ଼ଡ଼େ ସିଦନ ଦେ଼ସାତା ଆର୍ନା ହାଜିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ଏଚେଟିଏ ହେରଦ ତୀରିକିତି ଦିନାତା ରାଜା ହୁଚିନି ହିମ୍ବରିକା ହୁଚାନା ସିଂଗାସାଣିତା କୁଗାନା ଲ଼କୁ ନ଼କିତା ର଼ କାତା ୱେସ୍ତେସି; ");
INSERT INTO kxv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ଏଚେଟିଏ ଲ଼କୁ କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ଈଦି ମାହାପୂରୁତି ଗିୟାଁ, ମାଣ୍‌ସିତି ଗିୟାଁ ଆ଼ଏ !” ");
INSERT INTO kxv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଏ଼ ଦେବୁଣିଏ ପ୍ରବୁତି ର଼ ଦୂତୁ ହେରଦଇଁ ଡୀଗିତେ, ଇଚିହିଁ ଏ଼ୱାସି ମାହାପୂରୁଇଁ ଜହରା କିଆତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ପିଡ଼୍‌ୟୁଲି ତିଞ୍ଜାଲିଏ ଏ଼ୱାସି ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ସାମା ମାହାପୂରୁତି ବ଼ଲୁ ପାଡାଆ଼ହାନା ହା଼ରେକା ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ଡା଼ୟୁ ବର୍ନବା ଅ଼ଡ଼େ ସା଼ୱୁଲ ତାମି ସେ଼ବା କାମା ରା଼ପ୍‌ହାନା ଜହନ ଇନି ମାର୍କଇଁ ତ଼ଡ଼ୁ କିହାନା ଜିରୁସାଲମଟି ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଏଚିବେ଼ଲା ଆନ୍ତିୟକିୟାତି କୁଲମିତା ବର୍ନବା, ସିମିୟନ କା଼ଡ଼ିୟା ଇନାସି, କୁରିଣି ଦେ଼ସାତି ଲୁକିୟ, ହେରଦ ରାଜା ତାୟିଲେହେଁ ପାଡାଆ଼ତି ମନହେମ ଅ଼ଡ଼େ ସା଼ୱୁଲ, ଆନ୍ତିୟକିୟାତା ମାଚି କୁଲମିତା ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଅ଼ଡ଼େ ଜା଼ପ୍‌ନାରି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ଏ଼ୱାରି ପ୍ରବୁତି ସେ଼ବା ଅ଼ଡ଼େ ଉପାସା କିହିମାଚାଟି, ସୁଦୁଜୀୱୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେ, “ନା଼ନୁ ଆମିନି କାମାତାକି ବର୍ନବା ଅ଼ଡ଼େ ସା଼ୱୁଲଇଁ ହା଼ଟାମାଇଁ, ଏ଼ କାମାତାକି ଏ଼ୱାରାଇଁ ଏଟ୍‌କା କିଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ଏଚେଟିଏ ଏ଼ୱାରି ଉପାସା ଅ଼ଡ଼େ ପ୍ରା଼ତାନା କିତି ଡା଼ୟୁ ଏ଼ୱାରି ତା଼ର୍କାଣା କେସ୍କା ଇଟାନା ଏ଼ୱାରାଇଁ ହେର୍‌ପାନା ପାଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ଇଲେଆ଼ହିଁ ବର୍ନବା ଅ଼ଡ଼େ ସା଼ୱୁଲ ସୁଦୁଜୀୱୁ ତଲେ ପାଣ୍ତ୍‌ୱି ଆ଼ହାନା ସେଲୁକିୟାତା ହାଚେରି; ଇଞ୍ଜାଁ ର଼ ସାମ୍‌ଦୁରି ଜା଼ଜାତା ହ଼ଚାନା କୁପ୍ରତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ଏ଼ୱାରି ସାଲମି ଗା଼ଡ଼ାତା ଏଗାହାଜାଲିଏ ଜୀହୁଦି ଲ଼କୁତି ବାରେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ମାହାପୂରୁତି ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେରି; ଅ଼ଡ଼େ, ଜହନ ମାର୍କ ଜିକେଏ ସା଼ୟେମି କିୟାଲି ଏ଼ୱାରିତଲେ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ ଦେ଼ସା ମାଦିଟି ରେ଼ଜିହିଁ ପାପସ୍‌ ଗା଼ଡ଼ାତା ହାଚେରି; ଏମ୍ବାଆଁ ଏ଼ୱାରି ବାର୍‌-ଜୀସୁ, ଦ଼ରୁଗାଟି ର଼ ଜୀହୁଦି ଗାର୍‌ଡ଼ି ଗାଟାଣାଇଁ ବେଟାଆ଼ତେରି, ଏ଼ୱାସି ମିଚି ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ଏ଼ ଦେ଼ସା ସା଼ଲୱି କିନି ସେର୍ଗିୟ ପା଼ୱୁଲ ତଲେ ମାଚେସି, ଏ଼ ସା଼ଲୱି କିନାସି ର଼ ବୁଦିଗାଟାସି, ଏ଼ୱାସି ସା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବାଇଁ ହା଼ଟି କିହାନା ମାହାପୂରୁତି କାତା ୱେଞ୍ଜାଲି ଅଣ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ସାମା ଏ଼ ଗାର୍‌ଡ଼ିଗାଟି “ଏଲିମା” ଈଦି ଗ୍ରିକ୍‌ ଦ଼ରୁ ଏ଼ ସା଼ଲୱି କିନାଣାଇଁ ନାମୁଟି ପିସ୍‌ପିକିନି ଅଣ୍‌ପୁ ତଲେ ଏ଼ୱାରାଇଁ ବା଼ଦା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ସାମା ସା଼ୱୁଲ ଆମ୍ବାଆରାଇଁ ପା଼ୱୁଲ ଜିକେଏ ଇନେରି, ସୁଦୁଜୀୱୁଟି ନେଞ୍ଜାନା; ଏଲିମାଇଁ ସିନିକିତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ଅ଼ଡ଼େ ଏଲେଇଚେସି, “ଆଡ଼େ ସୟତାନ ମୀର୍‌ଏଣାତି, ବାରେଲେହେଁତି ନା଼ଡ଼ିକିନି ଲାଗେଏତି ଅଣ୍‌ପୁତା ନେଞ୍ଜାମାନାତି, ଅ଼ଡ଼େ ବାରେ ନେହିଁ କାମାତି ସାତ୍ରୁ, ନୀନୁ ପ୍ରବୁତି ସଲକ ଜିରୁତି ଲାଗେଏ କିହାଲି ପିହ୍‌ଅତି କି ? ");
INSERT INTO kxv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଅ଼ଡ଼େ ନୀଏଁ ମେହ୍‌ମୁ ପ୍ରବୁତି କେୟୁ ନୀ ଲାକ ମାନେ; ଇଞ୍ଜାଁ ନୀନୁ କା଼ଣା ଆ଼ହାନା ଗା଼ଡ଼େକା ତାକି ୱେ଼ଡ଼ାତି ଉଜେଡ଼ି ମେହ୍‌ଅତି ।” ଏ଼ ଦେବୁଣିଏ ଏଲିମା କାଣ୍‌କାତା ଦୂନ୍ଦ୍ରା ପଜିତି ଲେହେଁ ଆ଼ତେ ଇଞ୍ଜାଁ ତାନି କେୟୁ ଆସାଁ ଜିରୁ ତ଼ସାଲି ରଅଣାଇଁ ପାରୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଈଦାଆଁ ମେସାନା ସା଼ଲୱି କିନାସି ପ୍ରବୁତି ଜା଼ପ୍‌ନାଣି ୱେଞ୍ଜାନା କାବାଆ଼ହାନା ନାମିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ଡା଼ୟୁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ତାନି ତ଼ଣେସିଙ୍ଗା ପାପସ୍‌ଟିଏ ସାମ୍‌ଦୁରି ଜିରୁଟି ହାଜାନା ପଂପୁଲିୟା ଗା଼ଡ଼ାତି ପର୍ଗିତା ୱା଼ତେରି; ସାମା ଜହନ ମାର୍କ ଏ଼ୱାରାଇଁ ପିସାନା ଜିରୁସାଲମତା ୱେଣ୍ଡାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ଏ଼ୱାରି ପର୍ଗିଟି ହାଜାନା ପିସିଦିୟାତି ଆନ୍ତିୟକିୟାତା ଏଗାହାଚେରି, ଅ଼ଡ଼େ ଜ଼ମିନି ଦିନା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଜାନା କୁଗିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ଅ଼ଡ଼େ, ମ଼ସା ରା଼ଚିତି ମେ଼ରା ଇଞ୍ଜାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପତି ପ଼ଡ଼ୱି ଆ଼ତି ଡା଼ୟୁ, ପ୍ରା଼ତାନା ଇଲୁତି କାଜାରି ଏ଼ୱାରିତା଼ଣା ଏଲେଇଞ୍ଜି ୱେସା ପାଣ୍ତିତେରି; “ତାୟିୟାଁ, ଲ଼କୁତାକି ବା଼ର୍ସୁ ହୀନି କାତା ମାଚିହିଁ ୱେହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ଏଚେଟିଏ ପା଼ୱୁଲ ନିଚାନା ଲ଼କୁଣି କେୟୁ ତ଼ସିହିଁ ଏଲେଇଚେସି; “ଇସ୍ରାୟେଲ ଲ଼କୁତେରି ଇଞ୍ଜାଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତେରି ଅ଼ଡ଼େ ମାହାପୂରୁଇଁ ଆଜିନେରି ନା଼ କାତା ୱେଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଈ ଇସ୍ରାୟେଲ କୂଡ଼ାତି ମାହାପୂରୁ ମା଼ ଆକୁ ଆ଼ବାୟାଁଣି ଆ଼ଚିତେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ମିସର ଦେ଼ସାତା ବାସା କିହାମାନି ବେ଼ଲାତା, ଏ଼ୱାରାଇଁ ପାଡି କିତେସି, ଇଞ୍ଜାଁ ବା଼ଡ଼୍‌ୟୁ ଗାଟି କେୟୁତଲେ ଏ଼ୱାରାଇଁ ହ଼ପ୍‌ହା ତାତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଡା଼ୟୁ ରୀ କ଼ଡ଼ି ବାର୍ସା ପାତେକା ବାଃଲି ବାଟାତା ଏ଼ୱାସି ଏ଼ୱାରି ଲେ଼ମ୍ବିନାଣି ଅ଼ର୍‌ହିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଏ଼ୱାସି କିଣାନ ଦେ଼ସାତି ସା଼ତାଗଟା କୂଡ଼ାତି ଲ଼କୁଣି ନା଼ସା କିହାନା ତାନି ଆ଼ଚାମାନି ଲ଼କୁକି ଏ଼ ଦେ଼ସାତି ଅଦିକାରା ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ସା଼ରି ୱାଞ୍ଜା ରୀ କ଼ଡ଼ି ଦସ ବାର୍ସା ବିତ୍ରା ଈ ବାରେ ଆ଼ତେ । ଏଚେଟିଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ସାମୁୟେଲ ପାତେକା ବିଚାରା କିନାରାଇଁ ଆ଼ଚିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ର଼ ରାଜାଇଁ ହିୟାମୁ ଇଞ୍ଜିଁ ରୀସାଲିଏ ମାହାପୂରୁ ରୀ କ଼ଡ଼ି ବାର୍ସା ପାତେକା ବିନ୍ୟାମିନ୍‌ କୂଡ଼ାତି କିସ୍‌ ମୀର୍‌ଏସି ସା଼ୱୁଲଇଁ ରାଜା ଆ଼ହାଲି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ଡା଼ୟୁ ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ରାଜା ପା଼ଣା ପିସ୍‌ପି କିହାନା, ଏ଼ୱାରି ରାଜା ଆ଼ହାଲିତାକି ଦାୱୁଦଇଁ ଆ଼ଚିତେସି, ମାହାପୂରୁ ଜିକେଏ ଏ଼ୱାଣି କାତା ସା଼କି ହୀହାନା ଏଲେଇଚେସି; “ନା଼ନୁ ଜିସି ମୀର୍‌ଏସି ଦାୱୁଦଇଁ ବେଟାଆ଼ହାମାଇଁ, ଏ଼ୱାସି ନା଼ ହିୟାଁତି ଅଣ୍‌ପୁ ଲେହେଁତାସି, ଏ଼ୱାସି ବାରେ କାତାତା ନା଼ କାତା ମା଼ନୱି ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଏ଼ୱାଣି କୂଡ଼ାଟି ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାଚି ଲେହେଁ ଇସ୍ରାୟେଲ ଲ଼କୁତାକି ର଼ ଗେଲ୍‌ପିନାଣାଇଁ ଇଚିହିଁ ଜୀସୁଇଁ ଜାର୍ନି କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜୀସୁ ତାନି କାମା ମା଼ଟ୍‌ନି ନ଼କେଏ, ଜହନ ଇସ୍ରାୟେଲତି ବାରେ ଲ଼କୁ ନ଼କିତା ପା଼ପୁଟି ୱେଣ୍ତିନି କାତା ଅ଼ଡ଼େ ବାପ୍ତିସ୍ମ ଅ଼ନି କାତା ୱେ଼କ୍‌ହା ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଅ଼ଡ଼େ ଜହନ ତାନି କାମା ରା଼ପ୍‌ହିମାଚି ବେ଼ଲାତା ଲ଼କୁଣି ଏଲେଇଚେସି, “ନାଙ୍ଗେ ମୀରୁ ଆମ୍ବାଆସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜାଦେରି ନା଼ନୁ ଏ଼ୱାତେଏଁ ଆ଼ଏ, ସାମା ମେହ୍‌ଦୁ ନା଼ ଡା଼ୟୁ ରଅସି ୱା଼ହିମାନେସି, ଏ଼ୱାଣି କଡାତି ସେପୁୟାଁ ହୁକ୍‌ହାଲି ନା଼ନୁ ଜ଼ଗେ ଆ଼ଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ଏ଼ ତାୟି ତାଙ୍ଗିସ୍କା, ଅବ୍ରାହାମ କୂଡ଼ାତି ମୀର୍‌କା ମା଼ସ୍‌କାତେରି, ଅ଼ଡ଼େ ମୀ ତା଼ଣାଟି ମାହାପୂରୁଇଁ ଆଜିମାନି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତେରି; ମା଼ ତା଼ଣା ଈ ଗେଲ୍‌ପିଆ଼ନି ବ଼ଲୁ ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାଞ୍ଜାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ସାମା ଏ଼ୱାସି ଗେଲ୍‌ପିନାସି, ଜିରୁସାଲମତା ମାନାରି ଅ଼ଡ଼େ ତାମି ବାରେ କାଜାରି ଏ଼ଦାଆଁ ପୁଞ୍ଜାହିଲାଆତେରି, ଅ଼ଡ଼େ ବାରେ ଜ଼ମିନି ଦିନା ପ଼ଡ଼ୱି ଆ଼ହିମାନି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ପୁଞ୍ଜିହିଲାଆତେରି, ଆ଼ତିଜିକେଏ ଜୀସୁଇଁ ଦ଼ହ କିହାନା ମାହାପୂରୁ ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ପୂରା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଅ଼ଡ଼େ ଏ଼ୱାଣାକି ହା଼ନି ଡଣ୍ତତି ଏ଼ନି ଦ଼ହ ପ୍ଣାଃଆତି ଜିକେଏ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ପିଲାତଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଏ଼ୱାଣି ତାକି ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ବାରେ କାତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ଏଲେଆ଼ହିଁ ବାରେ ଗଟୱି ଆ଼ତି ଜେ଼ଚ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ପା଼ସି ମୁଣ୍ତାଟି ରେ଼ପ୍‌ହା ତାଚାନା, ମାଡ଼୍‌ହା ଇଟିନି ଟା଼ୟୁତା ଇଟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ସାମା ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ହେସି, ");
INSERT INTO kxv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଅ଼ଡ଼େ ଆମିନି ଗାଟାରି ଗାଲିଲିଟି ଜିରୁସାଲମତା ତାନିତଲେ ୱା଼ହାମାଚେରି, ଏ଼ୱାରି ହା଼ରେକା ଦିନା ପାତେକା ଏ଼ୱାଣାଇଁ ମେସ୍ତେରି; ଏ଼ୱାରି ଇସ୍ରାୟେଲ ଲ଼କୁତା଼ଣା ନୀଏଁ ଏ଼ୱାରି ସା଼କି । ");
INSERT INTO kxv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଅ଼ଡ଼େ ଆକୁ ଆ଼ବାୟାଁ ନ଼କିତା ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାନାଣି ମା଼ମ୍ବୁ ମିଙ୍ଗେ ଈ ନେହିଁ କାବ୍ରୁ ୱେସିମାଞ୍ଜାନମି; ");
INSERT INTO kxv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଜୀସୁଇଁ ମାହାପୂରୁ ନିକ୍‌ହାନା ଏ଼ୱାରି ମୀର୍‌କାତାୟି ମା଼ର, ମାଙ୍ଗେତାକି ଏ଼ ଆ଼ଞ୍ଜାମାନାଣି ପୂରା କିହାମାନେସି, ଏ଼ନିକିଁ ରୀ ଲମ୍ବର ପା଼ଚୁ ପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନ, “ନୀନୁ ନା଼ ମୀର୍‌ଏଣାତି; ନୀଞ୍ଜୁଟିଏ ନା଼ନୁ ନୀ ଆ଼ବାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଏ଼ୱାସି ହା଼ତାରି ତା଼ଣାଟି ୱେଣ୍ତେ ନିକ୍‌ହାମାନେସି, ଏ଼ୱାସି ସୀର୍‌ନି ତା଼ଣା ହାଲଅସି ଇଞ୍ଜିଁ ମାହାପୂରୁ ୱେସାମାନେସି; “ନା଼ନୁ ଦାୱୁଦ ନ଼କିତା ଆ଼ଞ୍ଜାମାନି ସୁଦୁ, ଇଞ୍ଜାଁ ତୀରି ଆ଼ନି ବ଼ର ମିଙ୍ଗେ ସାତେଏ ହିୟାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଅ଼ଡ଼େ ର଼ ପତିତା ଏଲେଇଞ୍ଜା ମାନେସି, “ନୀନୁ ନୀ ତୀରି ଗାଟାଣାଇଁ ସୀର୍‌ହାଲି ହୀଅତି ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାୱୁଦ ତା଼ନୁ ରା଼ଜି କିହିମାଚି ବେ଼ଲାତା ଲ଼କୁ ବିତ୍ରା ମାହାପୂରୁ ଅଣ୍‌ପୁ ତଲେ ସେ଼ବା କାମା କିତି ଡା଼ୟୁ ହା଼ତେସି, ଇଞ୍ଜାଁ ତାମି ଆକୁ ଆ଼ବାୟାଁ ଟଟତା ମୁସ୍‌ପି ଆ଼ହାନା ସୀର୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ସାମା ମାହାପୂରୁ ଆମ୍ବାଆରାଇଁ ହା଼କିଟି ନିକ୍‌ହାମାନେସି ଏ଼ୱାସି ସୀର୍‌ହା ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ଈଦାଆଁତାକି ଏ଼ ତାୟିୟାଁ ଈଦାଆଁ ପୁଞ୍ଜୁ, ଈ ଜୀସୁ ତା଼ଣାଟି ମୀ ନ଼କିତା ପା଼ପୁତି ମ୍ଣେକ୍‌ନି କାତା ୱେସ୍‌ପି ଆ଼ହାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ଅ଼ଡ଼େ ମ଼ସାତି ଆମିନି ମେ଼ରାତି ବାରେ ତା଼ଣାଟି ମୀରୁ ପିସ୍‌ପି ଆ଼ହାଁ ଦାର୍ମୁଗାଟାତେରି ଆ଼ହାଲି ଆ଼ଡାଆତେରି, ଇଞ୍ଜାଁ ନାମିମାନି ବାରେ ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣାଟି ଏ଼ ବାରେ ତା଼ଣାଟି ପିସ୍‌ପି ଆ଼ହାନା ଦାର୍ମୁଗାଟାରି ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଏ଼ଦାଆଁତାକି ଜାଗ୍ରାତା, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ସା଼ସ୍ତେରିତା ଏ଼ନାୟି ୱେସ୍‌ପି ଆ଼ହାମାନେ, ଏ଼ଦି ଏ଼ନିକିଁ ମିଙ୍ଗେତାକି ଆୟେଏ; ");
INSERT INTO kxv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ମାହାପୂରୁଇଁ ଅ଼ପାଆ ଗାଟାତେରି ମୀରୁ ମେସାନା, କାବା ଆ଼ହାଁ, ନା଼ସା ଆ଼ଦୁ; ଇଚିହିଁ ମୀ ବେ଼ଲାତା ମା଼ମ୍ବୁ ର଼ କାମା କିହିମାନମି, ଅ଼ଡ଼େ ଏ଼ କାମାତି ଆମ୍ବାଆସି ମୀ ନ଼କିତା ୱେସ୍ତାନେସି, ଏ଼ଦାଆଁ ମୀରୁ ଏ଼ନିଜିକେଏ ନାମଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁଟି ହ଼ଚାହାନି ବେ଼ଲାତା ୱା଼ନି ଜ଼ମିନି ଦିନାତା ମାଙ୍ଗେ ଈ ବାରେ କାତା ଅ଼ଡ଼େ ୱେସ୍ତାଦୁ ଇଞ୍ଜିଁ ଲ଼କୁ ଏ଼ୱାରାଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ବେ଼ରଣି ରା଼ତି ଡା଼ୟୁ ଏଚେକା ଜୀହୁଦି ଅ଼ଡ଼େ, ଜୀହୁଦି ଦାର୍ମୁ ନାମିତି ଏଟ୍‌କା କୂଡ଼ାତି ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଜେ଼ଚ ହାଚେରି; ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଏ଼ୱାରିତଲେ କାତାବାର୍ତା ଆ଼ହିଁ ମାହାପୂରୁ କାର୍ମାତା ତୀର୍‌ପୁ ଆ଼ହିଁ ମାଞ୍ଜାଲି ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ଇଞ୍ଜାଁ ଅ଼ର ଜ଼ମିନି ଦିନାତା ଗା଼ଡ଼ାତି ବାରେ ଲ଼କୁ ମାହାପୂରୁ ବ଼ଲୁ ୱେଞ୍ଜାଲି ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ସାମା ଜୀହୁଦିୟାଁ ଲ଼କୁ ମାନ୍ଦାତି ମେସାନା ଡା଼ହାରା ଆ଼ତେରି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ କାତା କ଼ପାଟି ନିନ୍ଦାକିହିଁ ବା଼ଦିବା଼ଦା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ଏଚେଟିଏ ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ସା଼ସା ଆସାନା ୱେସ୍ତେରି, “ତଲିଏ ମୀ ତା଼ଣା ମାହାପୂରୁତି ବ଼ଲୁ ୱେସ୍ତାନାୟି ମାଚେ, ମୀରୁ ଏ଼ଦାଆଁ ଅ଼ପାଆନା ମୀରୁ ମୀରୁଏ କା଼ଲେଏତି ଜୀୱୁ ବେଟାଆ଼ହାଲି ପା଼ଡ଼ା ଆ଼ଅମି ଇଞ୍ଜିଁ ଅଣ୍‌ପି ମାନାକି ମେହ୍‌ଦୁ ମା଼ମ୍ବୁ ମିଙ୍ଗେ ପିସାନା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ହାଜିମାନମି । ");
INSERT INTO kxv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ଇଚିହିଁ ପ୍ରବୁ ମାଙ୍ଗେ ଈ ହୁକୁମି ହୀହାମାଞ୍ଜାନେସି; ‘ନା଼ନୁ ମିଙ୍ଗେ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତାକି ଉଜେଡ଼ି ଲେହେଁ କିହାମାଞ୍ଜାଇଁ, ଆତିହିଁ ବାରେ ଦାର୍‌ତି ଗେଲ୍‌ପିଆ଼ନେ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଜୀହୁଦିଆ଼ଆତାରି ଈ ହା଼ଡା ୱେଞ୍ଜାନା ରା଼ହାଁ ଆ଼ତେରି; ଅ଼ଡ଼େ ମାହାପୂରୁତି ବ଼ଲୁତି ଗାୱୁରମି କିହାଲି ମା଼ଟ୍‌ହେରି, ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ କା଼ଲାକା଼ଲାତି ଜୀୱୁତାକି ଆ଼ଚ୍‌ୱି ଆ଼ହାମାଚେରି, ଏ଼ୱାରି ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଇଞ୍ଜାଁ ପ୍ରବୁତି ବ଼ଲୁ ଏ଼ ରା଼ଜିତା ବାରେୱାକି ଏଜାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ସାମା ଜୀହୁଦି ଲ଼କୁ ଗା଼ଡ଼ାତି ଆ଼ବାୟାଁଣି ଅ଼ଡ଼େ ମାହାପୂରୁଇଁ ମା଼ନି କିହିମାନି ପାଙ୍ଗାୱେ଼ଙ୍ଗେତି ଆୟାସିକାଣି ରୁଣ୍ତି କିହାନା ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବାଇଁ ସା଼ସ୍ତି ହୀହାନା ତାମି ରା଼ଜିଟି ପେ଼ର୍‌ହାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ଏଚେଟିଏ ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଜାହାରା କଡାୟାଁତି ଦୂଡ଼ି ଏ଼ୱାରି କ଼ପାଟି ହାଣ୍‌ହାଁନା ଇକନିୟତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଅ଼ଡ଼େ ଆନ୍ତିୟକିୟାତି ସୀସୁୟାଁ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହାନା ରା଼ହାଁତଲେ ଡ଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟତା ଜିକେଏ ଏଲେଆ଼ହିଁଏ ଆ଼ତେ; ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଜୀହୁଦି ଲ଼କୁତି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଜାନା ଇଲେକିଁ ୱେସ୍ତେରି, ଇଞ୍ଜାଁ ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ସାମା ଆମିନି ଜୀହୁଦିଙ୍ଗା ନାମାଆତେରି, ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତି ମ଼ନତି କିଲିବିଲି କିହାନା, ଏ଼ୱାରାଇଁ ନାମିତି ତାୟିୟାଁ କ଼ପାଟି ଲାଗେଏତି ଅଣ୍‌ପୁ ଅଣ୍‌ପି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ହା଼ରେକା ଦିନା ପାତେକା ଏ଼ ଟା଼ୟୁତା ଡ଼ୟାନା ପ୍ରବୁ ତା଼ଣା ବା଼ର୍ସୁ ଇଟାନା ସା଼ସାତଲେ ପ୍ରବୁତି କାତା ୱେସ୍ତେରି; ଇଞ୍ଜାଁ ଏ଼ୱାରି ତା଼ଣାଟି ହା଼ରେକା ସିନାୟାଁ ଅ଼ଡ଼େ କାବାଆ଼ନି କାମାୟାଁ କିହାନା ତାନି କାର୍ମାତି ବ଼ଲୁ ସାତା ଇଞ୍ଜିଁ ସା଼କି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ସାମା ଗା଼ଡ଼ାତି ଲ଼କୁ ରୀ ବା଼ଗା ଆ଼ତେରି ର଼ ବା଼ଗା ଜୀହୁଦି ଲ଼କୁ ୱାକି ଅ଼ଡ଼େ ର଼ ବା଼ଗା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ୱାକି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଏଚିବେ଼ଲା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁ ତାମି କାଜାରି ତଲେ ଆଣ୍ତାନା, ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରାଇଁ ଲାଗେଏ କିୟାଲି ଅ଼ଡ଼େ ୱାଲ୍‌କାତଲେ ଇର୍‌ହାଲି ଅଣ୍‌ପିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ଏଚିବେ଼ଲା ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଏ଼ଦାଆଁ ପୁଞ୍ଜାନା ଲୁକାୟନିୟା ଦେ଼ସାତି ଲୁସ୍ତ୍ରା ଅ଼ଡ଼େ ଦର୍ବି ଗା଼ଡ଼ା ଅ଼ଡ଼େ ସା଼ରିୱାକିତି ନା଼ସ୍‌କାଣାଁ ହଟେରି, ");
INSERT INTO kxv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏମ୍ବାଆଁ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରାତା ର଼ ଲ଼କୁ ମାଚେସି, ଏ଼ୱାସି ସଟା ମାଚେସି, ଏ଼ୱାସି ଜାର୍ନାଟିଏ ସଟା, ଏ଼ୱାସି ଏଚେଲାୱା ତା଼କା ହିଲାଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଏ଼ୱାସି ପା଼ୱୁଲ ୱେହ୍‌ନି କାତା ୱେଞ୍ଜିମାଚେସି, ଏ଼ୱାସି ହିୟାଁତା ନାମା ମାନେସି ଇଞ୍ଜାଁ ଏ଼ୱାସି ନେହିଁ ଆ଼ହାଲି ଆ଼ଡିମାନେସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଆଟେ ସିନିକିତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ଏ଼ୱାଣାଇଁ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ନୀ କଡାତି ବା଼ଡ଼୍‌ୟୁ ହୀହାନା ସଲ୍‌କେ ନିମୁ” ଏଚେଟିଏ ଏ଼ୱାସି ଡେ଼ୱିହିଁ ତା଼କାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ପା଼ୱୁଲ ଏ଼ନାଆଁ କିହାମାନେସି, ଲ଼କୁ ବାରେ ଏ଼ଦାଆଁ ମେସାନା ଲୁକାୟନିୟା କାଜା ହା଼ଡାତଲେ ଏଲେଇଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି, “ମାହାପୂରୁୟାଁ ମା଼ ତା଼ଣା ରେ଼ଚା ୱା଼ହାମାନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ଏ଼ୱାରି ବର୍ନବାଇଁ ବ୍ରୁହସ୍‌ପତି ଇଞ୍ଜିଁ ଇଚେରି, ଅ଼ଡ଼େ ପା଼ୱୁଲ ଗାଡି କାତା ୱେହ୍‌ନାସି ମାଚାକି ଏ଼ୱାଣାଇଁ ବୁଦ ଇଞ୍ଜିଁ ଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଗା଼ଡ଼ା ଡାଗେ ମାନି ବ୍ରୁହସ୍‌ପତି ଦେ଼ୱୁଡ଼ିତି ପୂଜେରାଙ୍ଗା ଏଚେକା ଡ଼ୁକି କ଼ଡିୟାଁ ଇଞ୍ଜାଁ ପୂଙ୍ଗା ପେ଼ତାୟାଁ ଗା଼ଡ଼ା ଦୁୱେରିତା ତାଚାହାଁ ଏ଼ୱାସି ବାରେ ଲ଼କୁତଲେ ଆଣ୍ତାନା ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ନ଼କିତା ପୂଜା ହୀହାଲି ଅଣ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","“ସାମା ପାଣ୍ତ୍‌ୱିଆ଼ହାମାନି ବର୍ନବା ଅ଼ଡ଼େ ପା଼ୱୁଲ, ଈଦାଆଁ ୱେଞ୍ଜାନା ତାମି ହିମ୍ବରିକା ଗେସାନା ଲ଼କୁ ମାଦିଟି ହଟି ହଟି ହାଜାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ଏ଼ ମା଼ନିଗାଟି ଲ଼କୁତେରି, ଏ଼ନାଆଁତାକି ଈ ବାରେ କିହିମାଞ୍ଜେରି, ମା଼ମ୍ବୁ ଜିକେଏ ମୀ ଲେହେଁତି ମାଣ୍‌ସିୟାଁତମି, ମୀ ତା଼ଣା ଈ ନେହିଁ କାବ୍ରୁ ୱେସିମାଞ୍ଜାନମି, ଏ଼ନିକିଁ ମୀରୁ ଈ ବାରେ ଉଜେଏତି ପେ଼ଣ୍‌କା ବମାୟାଁଟି ହେକ ଆ଼ହାନା ଜୀୱୁଗାଟି ମାହାପୂରୁ ତା଼ଣା ୱେଣ୍ଡା ୱା଼ଦେରି, ଏ଼ୱାସି ହା଼ଗୁପା଼କା ଦାର୍‌ତି, ସାମ୍‌ଦୁରି ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ମାନି ବାରେତି ରା଼ଚି କିହାମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ମାହାପୂରୁ ତଲିଏ ବାରେ ଲ଼କୁଣି ତାମି ମ଼ନତଲେ ଡ଼ୟାଲି ପିସାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ସାମା ଏ଼ୱାସି ବାରେ ନେହିଁ କାମାଟି ଏ଼ୱାସି କା଼ଲେଏ ତାନି ଗୂଣୁତି ତ଼ସାମାନେସି; ଏ଼ୱାସି ହା଼ଗୁଟି ପିୟୁ ଅ଼ଡ଼େ ସମାନା ବେ଼ଲାତା ଆର୍ନା ହିୟାନାସି, କା଼ଦି ଅ଼ଡ଼େ ମୀ ହିୟାଁତା ରା଼ହାଁ ହିୟାନାସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଈ ବାରେ କାତା ୱେସାନା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଲ଼କୁ ମାନ୍ଦାତି ହା଼ରେକା କସ୍ତତଲେ ତାମ୍‌ଙ୍ଗେ ତାକି ପୂଜା କିହାଲି କା଼ହି କିହାଲି ଆ଼ଡିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ସାମା ପିସିଦିୟାତି ଆନ୍ତିୟକିୟା ଅ଼ଡ଼େ ଇକନିୟଟି ଏଚେକା ଜୀହୁଦି ଏମ୍ୱାଆଁ ୱା଼ତେରି, ଏ଼ୱାରି ଲ଼କୁ ମାନ୍ଦାତି ତାମି ୱାକି କିହାନା ପା଼ୱୁଲଇଁ ୱାଲ୍‌କାତଲେ ଇର୍‌ହାନା ଏ଼ୱାସି ହା଼ହାହାଚେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଗା଼ଡ଼ାତି ପାଙ୍ଗାତା ରେଜା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ସାମା ନାମିତି ସୀସୁୟାଁ ସା଼ରି ୱାକିଟି ନିଚାମାଚାକି ଏ଼ୱାସି ନିଙ୍ଗାନା ଗା଼ଡ଼ା ବିତ୍ରା ହାଚେସି, ଅ଼ର ନେ଼ଚୁ ବର୍ନବା ତଲେ ଦର୍ବିତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଦର୍ବିତା ନେହିଁ କାବ୍ରୁ ୱେସାହାଁ ହା଼ରେକା ସୀସୁୟାଁ କିତି ଡା଼ୟୁ ଏ଼ୱାରି ଲୁସ୍ତ୍ରା, ଇକନିୟ ଅ଼ଡ଼େ ପିସିଦିୟାତି ଆନ୍ତିୟକିୟାତା ୱେଣ୍ଡାହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଅ଼ଡ଼େ, ଏ଼ ଟା଼ୟୁତି ନାମିତି ସୀସୁୟାଁ ମ଼ନତି ସୂସ୍ତି କିହାନା ନାମୁତା ଗାଡିକିହିଁ ଆ଼ଟ୍‌ୱା ତଲେ ଡ଼ୟାଲି ବା଼ର୍ସୁ ହୀହାନା ଏଲେଇଚେରି, “ମାହାପୂରୁ ରା଼ଜିତା ହ଼ଡାଲି ତାକି ହା଼ରେକା କସ୍ତ ପା଼ଣ୍‌ନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ଅ଼ଡ଼େ, ବାରେ କୁଲମିତା ଏ଼ୱାରି ପ୍ରାଚିନାଙ୍ଗାଣି ଆ଼ଚାନା ଉପାସା ତଲେ ପ୍ରା଼ତାନା କିତେରି, ଅ଼ଡ଼େ ଆମିନି ପ୍ରବୁ ତା଼ଣା ନାମା ମାଚେରି, ଏ଼ୱାଣି କେୟୁତା ଏ଼ୱାରାଇଁ ହେର୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ଡା଼ୟୁ ଏ଼ୱାରି ପିସିଦିୟା ନା଼ସ୍‌କାଟି ପଂପୁଲିୟାତା ୱା଼ତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଅ଼ଡ଼େ ପର୍ଗିତା ନେହିଁ କାବ୍ରୁ ୱେସାନା ଆତାଲିୟାତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଏମ୍ବାଟି ଏ଼ୱାରି ଜା଼ଜାତା ହ଼ଚାନା ଆନ୍ତିୟକିୟାତା ହାଚେରି; ଏ଼ୱାରି ଆମିନି କାମା କିହାମାଚେରି, ଏ଼ଦାଆଁ କିହାଲି ମାହାପୂରୁତି କାର୍ମାତା ହେର୍‌ପି ଆ଼ହାନା ଏମ୍ବାଟି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ଏଚିବେ଼ଲା ଏ଼ୱାରି ଆନ୍ତିୟକିୟାତା ଏଗାହାଜାନା କୁଲମିତି ଲ଼କୁଣି କୂଡ଼ି କିତେରି; ଅ଼ଡ଼େ ମାହାପୂରୁ ଏ଼ୱାରିତଲେ ମାଞ୍ଜାନା କିହାମାଚି କାମାତାକି, ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ନାମାଲି ଦୁୱେରି ଦେଚାମାଚାଣି ବାରେ ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଅ଼ଡ଼େ ଏ଼ୱାରି ନାମିତି ସୀସୁୟାଁ ତଲେ ହା଼ରେକା ଦିନା ଡ଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଏମ୍ବାଟିଏ ଏଚରଜା଼ଣା ଲ଼କୁ ଜୀହୁଦା ରା଼ଜିଟି ଆନ୍ତିୟକିୟାତା ୱା଼ହାନା ନାମିତି ତାୟିୟାଁଣି ଈ କାତା ୱେସିହିଁ ଜା଼ପ୍‌ହେରି, “ମ଼ସାତି ମେ଼ରା ଲେହେଁ ମୀ ତ଼ଲୁ ଦା଼ପି ଆ଼ଆତିହିଁ ମୀରୁ ଗେଲ୍‌ପିଆୟାଲି ଆ଼ଡଅତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ବର୍ନବା ତଲେ ହା଼ରେକା ଆସ୍‌ପି ଆ଼ହାନା ବା଼ଦିବା଼ଦା ଆୟାଲିଏ ପା଼ୱୁଲ, ବର୍ନବା ଅ଼ଡ଼େ ଆନ୍ତିୟକିୟାତି ଏଚରଜା଼ଣା ତାୟିୟାଁ ଈ କାତା ଆସାନା ଜିରୁସାଲମତା ମାନି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଇଞ୍ଜାଁ କୁଲମିତି ପ୍ରାଚିନାଙ୍ଗା ତା଼ଣା ହାଲ୍‌ବେରି ଇଞ୍ଜିଁ ତାୟିୟାଁ ତୀରି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ଏଚେଟିଏ କୁଲମି ଏ଼ୱାରାଇଁ ପାଣ୍ତାଲି ଜିରୁ ତ଼ସ୍ତି ଜେ଼ଚ, ଏ଼ୱାରି ପୟିନିକିୟା ଅ଼ଡ଼େ ସମିରଣ ୱାକି ହାଜି ହାଜିହିଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ହିୟାଁ ୱେଟ୍‌ହାମାଚି କାତା ୱେସିହିଁ ବାରେ ତାୟିୟାଁଇଁ ହା଼ରେକା ରା଼ହାଁ କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଡା଼ୟୁ ଏ଼ୱାରି ଜିରୁସାଲମତା ଏଗାହାଜାଲିଏ, କୁଲମି ଇଞ୍ଜାଁ, ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ଏ଼ୱାରାଇଁ ଆବିତେରି, ଅ଼ଡ଼େ ମାହାପୂରୁ ଏ଼ୱାରିତଲେ ମାଞ୍ଜାନା ଆମିନି କାମା କିହାମାଚେସି, ଏ଼ ବାରେ କାତା ଏ଼ୱାରାଇଁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ସାମା ପାରୁସିୟାଁ ଗଚିଟି ଏଚେକା ନାମୁଗାଟାରି ନିଚାନା ଏଲେଇଚେରି, “ନାମାମାନି ଜୀହୁଦିଆ଼ଆତାରି ତ଼ଲୁ ଦା଼ପି କିନାୟିମାନେ, ଅ଼ଡ଼େ ମ଼ସାତି ମେ଼ରା ମା଼ନୱି ଆୟାଲି ଏ଼ୱାରାଇଁ ହୁକୁମି ହୀନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ଡା଼ୟୁ ଈ କାତା, କାତା ଆ଼ହାଲିତାକି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ରୁଣ୍ତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ହା଼ରେକା ଜ଼ଲ୍‌କି ଆ଼ତି ଡା଼ୟୁ ପିତର ନିଙ୍ଗାନା ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ନା଼ ଗୂତିଟି ଜୀହୁଦିଆ଼ଆତାରି ନେହିଁ କାବ୍ରୁ ୱେଞ୍ଜାନା ନାମାପେରିୱା ଇଞ୍ଜିଁ ହା଼ରେକା ଦିନା ନ଼କେଏ ମାହାପୂରୁ ନାଙ୍ଗେ ଆ଼ଚାମାଞ୍ଜାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ବାରେ ଲ଼କୁତି ହିୟାଁ ପୁନି ମାହାପୂରୁ ମାଙ୍ଗେ ଏ଼ନିକିଁ ସୁଦୁଜୀୱୁ ହୀହାମାଞ୍ଜାନେସି, ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁକି ଜିକେଏ ଏଲେକିହିଁ ହୀହାନା ଏ଼ୱାରି ତାକି ସା଼କି ହୀହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଅ଼ଡ଼େ ଏ଼ୱାସି, ମା଼ ବିତ୍ରା ଅ଼ଡ଼େ ଏ଼ୱାରି ବିତ୍ରା ଏ଼ନି ପାର୍‌ଡ଼ା ବାଚି କିହାମାଞ୍ଜଅସି; ଇଞ୍ଜାଁ ନାମୁତଲେ ଏ଼ୱାସି ଏ଼ୱାରି ହିୟାଁ ସୁଦୁ କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଈଦାଆଁତାକି ଆମିନି ଜୁୱେଡ଼ି ମା଼ ଆକୁ ଆ଼ବାୟାଁ ଅ଼ଡ଼େ ମା଼ର ଡେ଼କାଲି ଆ଼ଡାଆତାୟି, ଏ଼ ଜୁୱେଡ଼ି ସୀସୁୟାଁ ବମିତା ଏ଼କ୍‌ହାନା ମୀରୁ ଏ଼ନାଆଁତାକି ମାହାପୂରୁଇଁ ତାୟିପାରି କିହିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ଈଦି ନେହେଁ ଆ଼ଏ, ସାମା ଏ଼ୱାରି ଏ଼ନିକିହିଁ ନାମାହାଁ ଗେଲ୍‌ପି ଆ଼ହାମାନେରି ମା଼ର ଜିକେଏ ଏଲେକିହିଁଏ ନାମାହାଁ ପ୍ରବୁ ଜୀସୁତି କାର୍ମାମେହ୍‌ନାଣି ତଲେ ଗେଲ୍‌ପି ଆ଼ହାମାନାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ଏଚେଟିଏ ଏମ୍ବାଆଁ ରୁଣ୍ତା ଆ଼ହାମାଚାରି ବାରେ ଲ଼କୁ ପାଲେଏ ଆ଼ତେରି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ତା଼ଣାଟି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ମାହାପୂରୁ ତା଼ଣାଟି ଆ଼ହିମାନି ସିନାୟାଁ ଅ଼ଡ଼େ କାବାଆ଼ନି କାମାୟାଁ କିହାଁ ମାଚେସି ଏ଼ୱାଆଁ ଏ଼ୱାରି ତା଼ଣାଟି ୱେଞ୍ଜାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ଏ଼ୱାରି କାତା ରା଼ତି ଡା଼ୟୁ ଜାକୁବ ନିଙ୍ଗାନା ଏଲେଇଚେସି; “ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା, ନା଼ କାତା ୱେଞ୍ଜୁ, ");
INSERT INTO kxv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ମାହାପୂରୁ ତଲିଏ ତାନି ଦ଼ରୁ ତାକି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବିତ୍ରାଟି ତାନି ଲ଼କୁ କିୟାଲି ଏ଼ୱାରାଇଁ କାର୍ମାମେସାନା ଆ଼ଚାମାନେସି ଇଞ୍ଜିଁ ସିମନ ୱେସାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ଅ଼ଡ଼େ, ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତାତଲେ ଆଣ୍ତିମାନେ, ଏ଼ନିକିଁ ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ପ୍ରବୁ ଏଲେଇଞ୍ଜି ମାନେସି, “ଡା଼ୟୁ ନା଼ନୁ ୱେଣ୍ତା ୱା଼ହାନା, ଦାୱୁଦ ବାସାଟା଼ୟୁ ୱେଣ୍ତେ ଗେଲ୍‌ପିଇଁ, ଇଞ୍ଜାଁ ଏମ୍ବାତି ବିଡ଼୍‌ହାମାନି କାତିୟାଁ ବାରେ ୱେଣ୍ତେ କେ଼ପାନା ଆ଼ଟ୍‌ୱା କିଇଁ, ");
INSERT INTO kxv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ଏ଼ନିକିଁ ଡ଼ୟାମାଚି କୂଡ଼ାତି ଲ଼କୁ ଅ଼ଡ଼େ ଏଚେକା ଜୀହୁଦିଆ଼ଆତାରି ନା଼ ଦ଼ରୁଟି ୱେ଼ଙ୍ଗାମାନେରି, ଏ଼ୱାରି ବାରେ ପ୍ରବୁଇଁ ପାରିନେରି, ବାରେ ଗା଼ଡ଼ିକିତି ପ୍ରବୁ ଏଲେ ଇଞ୍ଜିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ପ୍ରବୁ ଈ କାତା ଏଲେଇଞ୍ଜା ମାନେସି, ଆମ୍ବାଆସି ତଲି କା଼ଲାଟିଏ ଈ କାତା ତ଼ସାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଜାକୁବ ଅ଼ଡ଼େ ଜିକେଏ ଏଲେଇଚେସି, “ନା଼ ଅଣ୍‌ପୁ ଈଦି, ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବିତ୍ରାଟି ଆମ୍ବାଆରି ମାହାପୂରୁ ୱାକି ୱେଣ୍ତା ୱା଼ନେରି, ଏ଼ୱାରାକି ମା଼ର ବ଼ଜୁ ହୀଆପ; ");
INSERT INTO kxv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ସାମା ଏ଼ୱାରାକି ଇଲେକିଁ ଆ଼କୁ ରା଼ଚାନା ୱେହ୍‌ନ, ପେ଼ଣ୍‌କା ବମାୟାଁ ତାକି ପୂଜା କିହାମାନି ଲାଗେଏତାଣି ତିନାଆଦୁ; ଦା଼ରିକାମାଟି ଏଟ୍‌କା ଆ଼ଦୁ; ହେର୍‌କି ଦା଼ଆନା ପା଼ୟିତି ଜ଼ନ୍ତତି ଊଙ୍ଗା ଅ଼ଡ଼େ ନେତେରି ତିନାଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ତଲି କା଼ଲାଟିଏ ବାରେ ଗା଼ଡ଼ାଣା ମ଼ସା ମେ଼ରାତି କାତା ୱେ଼କ୍‌ନାରି ମାନେରି, ଇଞ୍ଜାଁ ବାରେ ଜ଼ମିନି ଦିନାତା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ଏ଼ୱାଣି ମେ଼ରାତି କାତା ପ଼ଡ଼ୱି ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ଏଚିବେ଼ଲା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନାରି ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ବାରେ କୁଲମି ତଲେ ତାମି ବିତ୍ରାଟି ଲ଼କୁଇଁ, ଇଚିହିଁ ତାୟିୟାଁ ବିତ୍ରାଟି ମା଼ନିଗାଟି ବର୍ସବା, ଦ଼ରୁଗାଟି ଜୀହୁଦା ଇଞ୍ଜାଁ ସିଲାଇଁ ଆ଼ଚାନା ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ତଲେ, ଆନ୍ତିୟକିୟାତା ପାଣ୍ତାଲି ତୀରି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ନାମିତାରି ତା଼ଣାଟି ରା଼ସ୍‌କି ଆ଼ହାମାନି ଆ଼କୁ ଏ଼ ରିଆରି କେୟୁତା ପାଣ୍ତିତେରି “ମା଼ମ୍ବୁ, ପାଣ୍ତ୍‌ୱି ଆ଼ତାତମି ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା, ମୀ ତାୟିୟାଁତମି ମା଼ ବାରେ ଜୀହୁଦିଆ଼ଆତି ତାୟିୟାଁ ଆମିନି ଗାଟାରି ଆନ୍ତିୟକିୟା, ସିରିୟା ଅ଼ଡ଼େ କିଲିକିୟାତା ମାନେରି ଏ଼ୱାରାକି ଜହରା । ");
INSERT INTO kxv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ମା଼ମ୍ବୁ ୱେଞ୍ଜାମାନମି, ମା଼ମ୍ବୁ ଆମିନି ଲ଼କୁଇଁ ଏ଼ନି ହୁକୁମି ହୀହାହିଲଅମି, ମା଼ ତା଼ଣାଟି ଏଲେତି ଏଚେକା ଲ଼କୁ ମୀ ତା଼ଣା ୱା଼ହାନା ତାମି କାତାତଲେ ମୀ ମ଼ନତି ଏଟ୍‌କା କିହାନା କିଲିବିଲି କିହାମାଞ୍ଜାନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଅ଼ଡ଼େ ମା଼ମ୍ବୁ ବାରେଜା଼ଣା ରୁଣ୍ତା ଆ଼ହାନା ରଣ୍ତିଏ ହିୟାଁ ତଲେ ଏଚରଜା଼ଣାତି ଆ଼ଚାନା ମୀ ତା଼ଣା ପାଣ୍ତାଲି ତୀରି କିହାମାନମି, ଏ଼ୱାରି ମା଼ ଜୀୱୁତି ତ଼ଣେ ବର୍ନବା ଅ଼ଡ଼େ ପା଼ୱୁଲ ତଲେ ହାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଏ଼ୱାରି ଇଲେତି ମାଣ୍‌ସିୟାଁ ମା଼ ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁ ତାକି ଜୀୱୁ ତୂସାନା କାମା କିହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ଏ଼ଦାଆଁତାକି ମା଼ମ୍ବୁ ଜୀହୁଦା ଅ଼ଡ଼େ ସିଲାଇଁ ମୀ ତା଼ଣା ପାଣ୍ତିମାଞ୍ଜାନମି । ମା଼ମ୍ବୁ ଏ଼ନାଆଁ ରା଼ଚାମାନମି, ଏ଼ୱାରି ମିଙ୍ଗେ ୱେସ୍ତାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଏଚରଗଟା ଲ଼ଡ଼ାମାନି ମେ଼ରା ପିସ୍‌ପେ ମୀ ଲାକ ଅ଼ଡ଼େ ଏ଼ନି ବ଼ଜୁ ହେର୍‌ପାଲି ମା଼ମ୍ବୁ ସୁଦୁଜୀୱୁଟି ହୁକୁମି ବେଟାଆ଼ହାମାନମି । ");
INSERT INTO kxv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଏ଼ ମେ଼ରାୟାଁ ଆ଼ହିମାନୁ, ପେ଼ଣ୍‌କା ବମାୟାଁକି ହେର୍‌ପିଆ଼ହାମାନି ରା଼ନ୍ଦା ତିନାଆଦୁ, ନେତେରି ତିନାଆଦୁ, ହେର୍‌କି ଦା଼ଆନା ପା଼ୟ୍‌ୱି ଆ଼ହାମାନି ଜ଼ନ୍ତତି ଊଙ୍ଗା ତିନାଆଦୁ, ଦା଼ରି କିଆଦୁ, ଈ ବାରେ କାମାଟି ହେକ ଆ଼ହାଲି ଜାଗ୍ରାତା ମାଚିହିଁ ମିଙ୍ଗେ ନେହେଁ ଆ଼ନେ । ନେହିଁକିଁ ମାଞ୍ଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ଏଚେଟିଏ କାବ୍ରୁ ଅ଼ନାରାଇଁ ପାଣ୍ତାଲିଏ ଆନ୍ତିୟକିୟାତା ହାଚେରି, ଇଞ୍ଜାଁ ବାରେ ନାମିତାରାଇଁ ରୁଣ୍ତି କିହାନା ଏ଼ ଆ଼କୁ ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଏ଼ ଲ଼କୁ ବାରେ ଏ଼ଦାଆଁ ପ଼ଡ଼ୱି ଆ଼ହାନା ବା଼ର୍ସୁ ବେଟାଆ଼ହାନା ରା଼ହାଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଜୀହୁଦା ଅ଼ଡ଼େ ସିଲା ତା଼ମ୍ବୁ ଜିକେଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ମାଚାକି ହା଼ରେକା କାତାତଲେ ତାୟିୟାଁଇଁ ବା଼ର୍ସୁ ହୀହାନା ସୂସ୍ତି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଅ଼ଡ଼େ, ଏ଼ୱାରି ଏମ୍ବାଆଁ ଏଚରଦିନା ମାଚି ଡା଼ୟୁ ଏ଼ୱାରାଇଁ ପାଣ୍ତାମାଚି ଲ଼କୁତା଼ଣା ୱେଣ୍ଡାହାଜାଲି ତାୟିୟାଁ ତା଼ଣାଟି ହେଲ ବେଟାଆ଼ହାନା ହିତ୍‌ଡ଼ି ଜୀୱୁତଲେ ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ସାମା ସିଲା ଏମ୍ବାଆଁ ଡ଼ୟାଲି ତୀରି କିହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପା଼ୱୁଲ ଅ଼ଡ଼େ ବର୍ନବା ଆନ୍ତିୟକିୟାତା ମାଞ୍ଜାନା ଏଟ୍‌କାତି ଏଚେକା ଲ଼କୁତା଼ଣା ଜିକେଏ ପ୍ରବୁତି ନେହିଁ ବ଼ଲୁ ଜା଼ପ୍‌ହାନା ୱେ଼କ୍‌ହାଲି ମା଼ଟ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ଏଚରଦିନା ହାଜାଲିଏ ପା଼ୱୁଲ ବର୍ନବାଇଁ ଏଲେଇଚେସି, “ୱା଼ମୁ, ମା଼ର ପ୍ରବୁତି ବ଼ଲୁ ୱେ଼କ୍‌ହାମାନି ବାରେ ଗା଼ଡ଼ାୟାଁଣା ୱେଣ୍ତା ହାଜାନା, ତାୟିୟାଁ ନୀଏଁ ଏ଼ନିଆ଼ହିଁ ମାନେରି ଇଞ୍ଜିଁ ବେ଼ଚିହାନ ।” ");
INSERT INTO kxv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ଏଚେଟିଏ ଜହନ ଇନି ମାର୍କଇଁ ଜିକେଏ ତାମିତଲେ ଅୟାଲି ବର୍ନବା ଅଣ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ସାମା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ପିସାନା ପଂପୁଲିୟାଟି ୱେଣ୍ତାହାଚାସି ଅ଼ଡ଼େ କାମା ରା଼ନି ପାତେକା ଏ଼ୱାରିତଲେ ମାନାଆତାକି ତାମିତଲେ ଅୟାଲି ପା଼ୱୁଲ କୂତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ହା଼ରେକା ବା଼ଦିବା଼ଦା ଆୟାଲିଏ ତା଼ମ୍ବୁ ଏଟ୍‌କା ଆ଼ତେରି, ଇଞ୍ଜାଁ ବର୍ନବା ଜହନ ମାର୍କଇଁ ତାନିତଲେ ଅ଼ହିଁ ଜା଼ଜାତା ହ଼ଚାନା କୁପ୍ରତା ହାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ସାମା ପା଼ୱୁଲ ସିଲାଇଁ ଆ଼ଚାନା ତାୟିୟାଁ ତା଼ଣାଟି ପ୍ରବୁତି କାର୍ମାତଲେ ହେର୍‌ପି ଆ଼ହାନା ହାଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ଅ଼ଡ଼େ ଏ଼ୱାସି ସିରିୟା ଅ଼ଡ଼େ କିଲିକିୟାଟି ହାଜାହାଁ ବାରେ କୁଲମିକାଣି ନାମୁତା ଆ଼ଟ୍‌ୱା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ଡା଼ୟୁ ପା଼ୱୁଲ ଦର୍ବି ଅ଼ଡ଼େ ଲୁସ୍ତ୍ରାତା ହାଚେସି, ଏମ୍ବାଆଁ ତିମତି ଦ଼ରୁଗାଟାସି ର଼ ସୀସୁ ମାଚେସି, ଏ଼ୱାସି ର଼ ନାମିତି ଜୀହୁଦି କ୍ରୀସ୍ତାନା ଇୟାନି ମୀର୍‌ଏସି ମାଚେସି, ସାମା ତାମି ଆ଼ବା ର଼ ଗ୍ରିକ୍‌ ଲ଼କୁ । ");
INSERT INTO kxv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ଅ଼ଡ଼େ ଇକନିୟତା ମାନି ବାରେ ନାମିତି ତାୟିୟାଁ ଏ଼ୱାଣାଇଁ ନେହାଁସି ଇଞ୍ଜିଁ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପା଼ୱୁଲ ତାନିତଲେ ତିମତିଇଁ ଅ଼ହାଲି ଅଣ୍‌ପିତେସି, ଅ଼ଡ଼େ ଏ଼ ନା଼ସ୍‌କାଣାଁ ମାନି ଜୀହୁଦି ଲ଼କୁତାକି ଏ଼ୱାଣି ତ଼ଲୁ ଦା଼ପିକିତେସି; ଇଚିହିଁ ତାମି ଆ଼ବା ଗ୍ରିକ୍‌ ଲ଼କୁ ଇଞ୍ଜିଁ ବାରେ ପୁଞ୍ଜାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଗା଼ଡ଼ାୟାଁଟି ହାଜି ହାଜିହିଁ ଜିରୁସାଲମତି ପାଣ୍ତ୍‌ୱି ଆ଼ତାରି ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ତା଼ଣାଟି କିୱି ଆ଼ହାମାନି ମେ଼ରା ମା଼ନୱି ଆ଼ହାଲି ଏ଼ୱାରିତା଼ଣା ହେର୍‌ପି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ଏଲେକିହିଁ କୁଲମିକା ବାରେ ନାମୁତା ଆ଼ଟ୍‌ୱା ଆ଼ହାନା ଦିନାତାକି ଦିନା ପାଡା ଆ଼ତୁ । ");
INSERT INTO kxv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ଏ଼ୱାରି ଆସିୟାତା ମାହାପୂରୁ କାତା ୱେସାଲି ସୁଦୁଜୀୱୁ କା଼ହି କିୟାଲିଏ, ଏ଼ୱାରି ପୁର୍ଗିୟା ଅ଼ଡ଼େ ଗାଲାତିୟ ରା଼ଜି ମାଦିଟି ରେ଼ଜିହିଁ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ଅ଼ଡ଼େ, ଏ଼ୱାରି ମୁସିଆ ରା଼ଜି ଡାଗେ ଏଗାହାଜାନା ବେତନିୟାଁତା ହାଜାଲିତାକି ଅଣ୍‌ପିତେରି, ସାମା ଜୀସୁତି ଜୀୱୁ ଏ଼ୱାରାଇଁ ହାଜାଲି ହେଲ ହୀଆତେ । ");
INSERT INTO kxv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ଏ଼ୱାରି ମୁସିଆ ମାଦିଟି ହାଜାନା ତ୍ରୟାତା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଅ଼ଡ଼େ ଲା଼ଆଁ ବେ଼ଲାତା ପା଼ୱୁଲ ର଼ ସେୟାଁଣା ହାପାନା ହେ଼ଟେସି, ମାକିଦନିୟାତି ର଼ ଲ଼କୁ ନିଚାନା ଏ଼ୱାଣାଇଁ ବାତିମା଼ଲିହିଁ ଏଲେଇଚେସି, “ମାଙ୍ଗେ ସା଼ୟେମି କିୟାଲି ମାକିଦନିୟାତା ଗା଼ଣ୍‌ଚା ୱା଼ମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ଏ଼ୱାସି ସେୟାଁଣା ହାପାନାତା ମେସାଲିଏ ମା଼ମ୍ବୁ ଦେବୁଣିଏ ମାକିଦନିୟାତା ହାଜାଲି ତିୟାରା ଆ଼ତମି, ଇଚିହିଁ ଏ଼ୱାରିତା଼ଣା ନେହିଁ କାବ୍ରୁ ୱେସାଲି ତାକି ମାହାପୂରୁ ମାଙ୍ଗେ ହା଼ଟାମାଞ୍ଜାନେସି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ପୁଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ଏଚେଟିଏ ମା଼ମ୍ବୁ ତ୍ରୟାଟି ଜା଼ଜାତା ହ଼ଚାନା ତିୟିତି ଜିରୁଟି ହାଜାନା ସାମତ୍ରାକିତା ଅ଼ଡ଼େ ଅ଼ର ନେ଼ଚୁ ନୟାପଲିତା ଏଗାହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ଏମ୍ବାଟିଏ ପିଲିପିତା ହାଚମି, ଈଦି ମାକିଦନିୟା ଜିଲାତି ର଼ କାଜା ଗା଼ଡ଼ା, ଇଞ୍ଜାଁ ର଼ମ୍‌ ଦେ଼ସାତାରି ଡ଼ୟିନି ଟା଼ୟୁ ମାଚେ; ଏ଼ ଗା଼ଡ଼ାତା ମା଼ମ୍ବୁ ଏଚରଦିନା ମାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ଜ଼ମିନି ଦିନାତା ମା଼ମ୍ବୁ ଗା଼ଡ଼ାଟି ହ଼ଚାନା କାଡା ଡାଗେ ହାଚମି, ଏମ୍ବାଆଁ ପ୍ରା଼ତାନା କିନି ଟା଼ୟୁ ମାନେ ଇଞ୍ଜିଁ ଅଣ୍‌ପାମାଚମି, ଅ଼ଡ଼େ ମା଼ମ୍ବୁ କୁଗାନା ରୁଣ୍ତା ଆ଼ହାମାଚି ଇୟାସିକା ତଲେ କାତା ଆ଼ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ଅ଼ଡ଼େ, ତୁୟାତିରା ଗା଼ଡ଼ାତି ହେୟାଁ ୱା଼ଣା ହିମ୍ବରିକା ପା଼ର୍‌ନି ଲୁଦିୟା ଦ଼ରୁଗାଟି ର଼ ଇୟା ମା଼ କାତା ୱେଞ୍ଜିମାଚେ, ଏ଼ଦି ମାହାପୂରୁ ସେ଼ବା କିନାୟି, ଏ଼ଦି ଏ଼ନିକିଁ ପା଼ୱୁଲତି କାତାତି ମ଼ନ ହୀନେ ଏ଼ଦାଆଁତାକି ପ୍ରବୁ ଏ଼ଦାନି ହିୟାଁ ଦେଚାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଅ଼ଡ଼େ ଏ଼ଦି ଇଞ୍ଜାଁ ତାମି କୁଟମି ବାପ୍ତିସ୍ମ ଅ଼ତି ଡା଼ୟୁ ମାଙ୍ଗେ ବାତିମା଼ଲିହିଁ ଏଲେଇଞ୍ଜାତେ, “ମୀରୁ ନାଙ୍ଗେ ପ୍ରବୁ ତା଼ଣା ନାମୁଗାଟାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚିହିଁ, ନା଼ ଇଜ ୱା଼ହାନା ବାସା ଆ଼ଦୁ,” ଇଞ୍ଜିଁ ବାଲାମାତମି କିହାଁ ହା଼ଟା ଅୟାତେ । ");
INSERT INTO kxv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ର଼ ଦିନା ମା଼ମ୍ବୁ ପ୍ରା଼ତାନା ଟା଼ୟୁତା ହାନିବେ଼ଲାତା ର଼ ହ଼ଲେଣି ପ଼ଦାଇଁ ବେଟାଆ଼ତମି ଏ଼ଦି ପ଼ଲ୍‌ଆ ପେ଼ନୁ ଆଲ୍‌ଗାନା ଡା଼ୟୁ ଆ଼ନି କାତାୟାଁ ୱେସାଲି ଆ଼ଡିମାଚେ । ଡା଼ୟୁ ଆ଼ନି କାତାୟାଁ ୱେସାନା ତାନି ସା଼ୱୁକାରିକି ହା଼ରେକା ଡାବୁୟାଁ କୂଡ଼ି କିହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ଏ଼ଦି ପା଼ୱୁଲ ଅ଼ଡ଼େ ମା଼ ଜେ଼ଚ ଜେ଼ଚ ୱା଼ହାନା କିର୍‌ଡ଼ିହିଁ ଏଲେଇଞ୍ଜାଲି ମା଼ଟ୍‌ହେ, “ଈ ଲ଼କୁ ବାରେକିହାଁ କାଜା ମାହାପୂରୁତି ହ଼ଲିୟାଙ୍ଗା, ଏ଼ୱାରି ମିଙ୍ଗେ ଗେଲ୍‌ପିଆ଼ନି ଜିରୁତି ୱେ଼କ୍‌ହି ମାଞ୍ଜାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ଏ଼ଦି ହା଼ରେକା ଦିନା ପାତେକା ଏଲେକିୟାତେ, ସାମା ପା଼ୱୁଲ କ଼ପା ଆ଼ହାନା ୱେଣ୍ତେ ସିନିକିହାନା ଏ଼ ବୂତୁଇଁ ଏଲେଇଚେସି, “ଏ଼ଦାନି ତା଼ଣାଟି ହ଼ଚା ହାଜାଲି ନା଼ନୁ ନିଙ୍ଗେ ଜୀସୁ କ୍ରୀସ୍ତ ଦ଼ରୁତଲେ ହୁକୁମି ହୀହିମାଞ୍ଜାଇଁ,” ଏ଼ ଦେବୁଣିଏ ଏ଼ଦି ହ଼ଚାହାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ସାମା ଏ଼ଦାନି ସା଼ୱୁକାରିୟାଁ ତାମି ଲା଼ବା ପା଼ଣ୍‌ନି ଆ଼ସା ହାଚେ, ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲାଇଁ ଦସାନା ବେ଼ରଣିମାଣ୍ତାତା ସା଼ଲୱି କିନାରି ତା଼ଣା ରେଜା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ଅ଼ଡ଼େ, ଏ଼ୱାରି ରମିୟ ସା଼ଲୱି କିନାରି ତା଼ଣା ତାଚାନା ଏଲେଇଚେରି, “ଈୱାରି ଜୀହୁଦି ଲ଼କୁ ମା଼ ଗା଼ଡ଼ାତା ଗଡ଼୍‌ହା କିହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ମା଼ର ରମିୟ ଲ଼କୁତି ମେ଼ରା ପା଼ଣାପା଼ଟୁ ଆବାଲି କି ମା଼ନୱି ଆ଼ହାଲି ମେ଼ରା ହିଲେଏ, ଏ଼ଦାଆଁ ଈୱାରି ୱେସିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ଏମ୍ବାଟିଏ ବାରେ ଲ଼କୁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା କ଼ପାଟି ନିଙ୍ଗିତେରି । ଅ଼ଡ଼େ ନୀହାଁୟି କିନାରି ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା ହିମ୍ବରିକା ହୁକ୍‌ହାନା ଏ଼ୱାରାଇଁ ବାଡ଼୍‌ଗା ତଲେ ୱେ଼ଚାଲି ହୁକୁମି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ଏ଼ୱାରି ଏ଼ୱାରାଇଁ ହା଼ରେକା ୱେ଼ତି ଡା଼ୟୁ କାୟିଦି ଇଲୁତା ଇଟିତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ଜାଗ୍ରାତା କିହିଁ କା଼ପୁ କା଼ଚାଲି କା଼ୟିଦି ଇଲୁତି କା଼ଃଆନାଣାଇଁ ହୁକୁମି ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","କା଼ୟିଦି କା଼ଃଆନାସି ଇଲେତି ହୁକୁମି ବେଟାଆ଼ହାନା ଏ଼ୱାରାଇଁ କା଼ୟିଦି ଇଲୁତି ବାରେକିହାଁ ବିତ୍ରାତି ବାକ୍ରାତା ମେତ୍‌ହାନା ଏ଼ୱାରି କଡାଣା ବ଼ଜୁଗାଟି ମା଼ର୍‌ନୁ କୁଡୁଲିକା ଦସା ପିସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ସାମା ମାଦି ଲା଼ଆଁୟାଁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା ମାହାପୂରୁ ତା଼ଣା ପ୍ରା଼ତାନା ଅ଼ଡ଼େ ଜହରା ପା଼ଚୁ ପା଼ଚିମାଚେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରିତଲେ କାୟିଦି ଇଲୁତା ମାଚାରି ବାରେ ୱେଞ୍ଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ଏଚିବେ଼ଲାତା ଦେବୁଣିଏ ବୂମି ୱୀଡିତେ, ଇଞ୍ଜାଁ କାୟିଦି ଇଲୁତି ପୁନାଦି ଜିକେଏ ୱୀଡାଲିଏ ବାରେ ଦୁୱେରିକା ଦେପି ଆ଼ହାହାଚୁ, ଇଞ୍ଜାଁ ବାରେଜା଼ଣାତି ଦସାମାଚି ହିକ୍‌ଣିୟାଁ ହୁଙ୍ଗାହାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ଏଚେଟିଏ କା଼ୟିଦି ଇଲୁ କା଼ଃଆନାସି ଇଦାଟି ନିଙ୍ଗାନା, ଦା଼ରାୟାଁ ଦେପିଆ଼ହାମାନାଣି ମେସାନା, କା଼ୟିଦିତାରି ହଣ୍‌ପି ଆ଼ତେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା, କାଣ୍ତା ହ଼ପ୍‌ହାନା ଗ୍ଣାକ୍‌ହା କଡିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ସାମା ପା଼ୱୁଲ କାଜା ଗିୟାଁତଲେ ହା଼ଟାନା ଏଲେଇଚେସି, “ନୀନୁ ନିଙ୍ଗେ ନା଼ସା କିହା କଡାଆନି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମା଼ମ୍ବୁ ବାରେତମି ଇମ୍ବାଆଁ ମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","କା଼ୟିଦି ଇଲୁ କା଼ଃଆନାସି ଦୀୱଁ ତାଚାଲି ଏଲେଇଚେସି, ତବେ ବିତ୍ରା ହାଚେସି ଇଞ୍ଜାଁ ତୀର୍‌ଗି ତୀର୍‌ଗିହିଁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା କଡାୟାଁ ଡ଼଼ଇ ରୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ପାଙ୍ଗାତା ତାଚାନା ଏଲେଇଚେସି, “ବା଼ବୁୟାଁ ଗେଲ୍‌ପିଆୟାଲି ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?” ");
INSERT INTO kxv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ଏ଼ୱାରି ଏଲେଇଚେରି, “ପ୍ରବୁ ଜୀସୁ ତା଼ଣା ନାମାଦୁ, ଆତିହିଁ ନୀନୁ ଅ଼ଡ଼େ ନୀ ଇଲୁ କୁଟମି ବାରେ ଗେଲ୍‌ପି ଆ଼ଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ଡା଼ୟୁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଅ଼ଡ଼େ ଏ଼ୱାଣି ଇଜ ମାଚି ବାରେ ଲ଼କୁଣି ମାହାପୂରୁତି ବ଼ଲୁ ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ଅ଼ଡ଼େ, ଏ଼ କା଼ୟିଦି ଇଲୁ କା଼ଃଆନାସି ଏ଼ୱାରାଇଁ ଏ଼ ଲା଼ଆଁୟାଁ ବେ଼ଲାତା ଅ଼ହାନା ଏ଼ୱାରି ଗା଼ହାଁୟାଁ ନର୍‌ହେସି, ଇଞ୍ଜାଁ ଏ଼ୱାସି ଅ଼ଡ଼େ ଏ଼ୱାଣି ଇଲୁ କୁଟମି ବାରେ ଏ଼ ଦେବୁଣିଏ ବାପ୍ତିସ୍ମ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ଏଚେଟିଏ ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ତାମି ଇଜ ଅ଼ହାନା ତିଞ୍ଜାଲି ରା଼ନ୍ଦା ବା଼ଟିକିହାଁ ହୀତେସି, ଅ଼ଡ଼େ ବାରେ କୁଟମି ମାହାପୂରୁ ତା଼ଣା ନାମାନା ହା଼ରେକା ରା଼ହାଁ ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ଲା଼ଇ ୱେ଼ୟାଲିଏ ରମିୟ ଲ଼କୁତି କାଜାରି ରିଜାରି କ଼ସ୍‌କାଣି ଇଲେଇଞ୍ଜିଁ ୱେସା ପାଣ୍ତିତେରି, “ଏ଼ ଲ଼କୁଣି ପିସାତୁହ୍‌ଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ଏଚେଟିଏ କାୟିଦି ଇଲୁ କା଼ଃଆନାସି ପା଼ୱୁଲଇଁ ଈ କାତା ୱେସ୍ତେସି, “ନୀହାଁୟି କିନାରି ନିଙ୍ଗେ ଅ଼ଡ଼େ ସିଲାଇଁ ପିସାଲି କାବ୍ରୁ ପାଣ୍ତା ମାଞ୍ଜାନେରି, ଇଞ୍ଜାଁ ନୀଏଁ ହ଼ଚାୱା଼ହାନା ହିତ୍‌ଡ଼ି ତଲେ ହାଜୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ସାମା ପା଼ୱୁଲ କ଼ସ୍‌କାଣି ଏଲେଇଚେସି, “ମା଼ମ୍ବୁ ରମିୟ ଦେ଼ସାତି ଲ଼କୁତମି, ମାଙ୍ଗେ ନୀହାଁୟି କିଆନା ୱେ଼ତାତି ଡା଼ୟୁ କା଼ୟିଦି ଇଲୁତା ସୁଣ୍ଡାତେରି, ଅ଼ଡ଼େ ନୀଏଁ ଡ଼ୁକ୍‌ହାନା ପିସିମାଞ୍ଜାନେରି, ଏ଼ଦି ମିଣ୍‌ଏ, ସାମା ଏ଼ୱାରି ତା଼ମ୍ବୁଏ ୱା଼ହାନା ମାଙ୍ଗେ ପାଙ୍ଗାତା ଅୟାପେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ଏଚେଟିଏ କ଼ସ୍‌କା ହାଜାନା ନୀହାଁୟି କିନାରାଇଁ ବାରେ କାତା ୱେସ୍ତେରି, ଇଞ୍ଜାଁ ଈୱାରି ରମିୟ ଲ଼କୁ ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ଆଜିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ୱା଼ହାନା ମା଼ମ୍ବୁ ପୁନାଆନା ଏଲେକିତମି ଇଞ୍ଜିଁ ବାତିମା଼ଲିହିଁ ଏ଼ୱାରାଇଁ ପାଙ୍ଗାତା ହ଼ପ୍‌ହା ତାଚାନା, ଗା଼ଡ଼ା ପିସାନା ହାଜାଲି ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ଏଚେଟିଏ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା କା଼ୟିଦି ଇଲୁଟି ହ଼ଚାନା ଲୁଦିୟା ଇଜ ହାଚେରି, ଅ଼ଡ଼େ ତାୟିୟାଁ ତଲେ ଆଣ୍ତାନା ଏ଼ୱାରାଇଁ ବା଼ର୍ସୁ ହୀହାନା ହାଜାତୁସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ଡା଼ୟୁ ଏ଼ୱାରି ଆଂପିପଲି ଅ଼ଡ଼େ ଆପଲନିୟା ହୀହାନା ତେସଲନିକିତା ୱା଼ତେରି; ଏମ୍ବାଆଁ ଜୀହୁଦି ଲ଼କୁତି ର଼ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ଅ଼ଡ଼େ, ପା଼ୱୁଲ ତାନି ମେ଼ରା ଲେହେଁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଚେସି, ଇଞ୍ଜାଁ ତୀନିଗଟା ଜ଼ମିନି ଦିନା ପାତେକା ଦାର୍ମୁ ପତିତି କାତା ଆସାନା ଲ଼କୁତଲେ ଜ଼ଲ୍‌କି ଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦାର୍ମୁ ସା଼ସ୍ତେରି ତେଲ୍‌ହି କିହାନା ଏ଼ କାତା ଈଦି ଇଞ୍ଜିଁ ଇଚେସି, ମସିହା ସା଼ସ୍ତି ପା଼ଣ୍‌ନାୟି ଅ଼ଡ଼େ ହା଼କିଟି ନିଙ୍ଗିନାୟି ଲ଼ଡ଼ାମାନେ । ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଆମିନି ଜୀସୁତି କାତା ୱେସିମାଞ୍ଜାଇଁ, ଏ଼ୱାସି ଏ଼ ମସିହା ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ନାମାହାଁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲା କାତାତା ଆଣ୍ଡିତେରି; ଅ଼ଡ଼େ, ଜୀହୁଦି ଦାର୍ମୁ ନାମାମାନି ଗ୍ରିକ୍‌ ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ଲ଼କୁ ଅ଼ଡ଼େ ମା଼ନିଗାଟି ହା଼ରେକା ଇୟାସିକା ବିତ୍ରାଟି ଏ଼ୱାରିତଲେ ମାହାପୂରୁ ସେ଼ବାତା ଆଣ୍ତିତୁ । ");
INSERT INTO kxv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ସାମା ଜୀହୁଦିୟାଁ ଡା଼ହାରା ଆ଼ହାନା ଏଚେକା ଲାଗେଏତାରାଇଁ ପା଼ହେରିତା କୂଡ଼ି କିତେରି, ଇଞ୍ଜାଁ ଲ଼କୁଣି ମାନ୍ଦା କିହାନା ଗା଼ଡ଼ାତା ଗଡ଼୍‌ହା ହ଼ପ୍‌ହେରି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲାଇଁ ସା଼ଲୱି କିନାରି ନ଼କିତା ହ଼ପ୍‌ହାତାଚାଲି ଏ଼ୱାରି ହାଜାନା ଜାସନ ଇଲୁତି ମୁଚାନା ପାରିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ସାମା ଏ଼ୱାରାଇଁ ବେଟାଆ଼ଆଲିଏ ଏ଼ୱାରି ଜାସନ ଅ଼ଡ଼େ ଏଚେକା ତାୟିୟାଁଇଁ ଗା଼ଡ଼ାତି ସା଼ଲୱି କିନାରି ନ଼କିତା ରେଜା ତାଚାନା କାଜା ଗିୟାଁତଲେ କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି, “ଆମିନି ଲ଼କୁ ଦାର୍‌ତିତି ଇତାଲା ଆତାଲା କିହିମାନେରି, ଏ଼ୱାରି ଇମ୍ବାଆଁ ଜିକେଏ ୱା଼ହାମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଜାସନ ଏ଼ୱାରାଇଁ ଆବାମାନେସି, ଜୀସୁ ଦ଼ରୁଗାଟି ଅ଼ଡ଼େ ର଼ ରାଜା ମାନେସି ଇଞ୍ଜିଁ ୱେସାନା ଈୱାରି ବାରେଜା଼ଣା କାୟିସରତି ହୁକୁମିତି ମା଼ନୱି କିହିହିଲଅରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଈ କାତା ଆସାନା ଲ଼କୁ ଅ଼ଡ଼େ ସା଼ଲୱି କିନାରି ବିତ୍ରା ହା଼ରେକା କାର୍‌ବି ଆ଼ତେରି ଅ଼ଡ଼େ ଗଡ଼୍‌ହା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ଡା଼ୟୁ ସା଼ଲୱି କିନାରି ଜାସନ ଅ଼ଡ଼େ ଏଟ୍‌କା ଲ଼କୁଣି ଡାବୁୟାଁ ରୀସାନା ଜାମ୍‌ଲି ତଲେ ଏ଼ୱାରାଇଁ ପିସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ଅ଼ଡ଼େ, ତାୟିୟାଁ ୱେ଼ଡ଼ାକିଆନା ପା଼ୱୁଲ ଅ଼ଡ଼େ ସିଲାଇଁ ଲା଼ଆଁ ବେ଼ଲାତା ବେରିୟାତା ପାଣ୍ତିତେରି; ଏ଼ୱାରି ଏମ୍ବାଆଁ ଏଜାନା ଜୀହୁଦି ଲ଼କୁତି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତେସଲନିକିତା ମାନି ଜୀହୁଦି ଲ଼କୁ କିହାଁ ଈୱାରି ସାତାପା଼ଣା ଗାଟାରି ମାଚେରି, ଈୱାରି ହା଼ରେକା ରା଼ହାଁତଲେ ମାହାପୂରୁ କାତା ୱେଚେରି, ଅ଼ଡ଼େ ପା଼ୱୁଲ ୱେସ୍ତି କାତା ସାତା କି ଆ଼ଏ ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲି ବାରେଦିନା ଦାର୍ମୁ ପତି ପ଼ଡ଼ୱି ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ଈଦାଆଁତାକି ଏ଼ୱାରି ବିତ୍ରାଟି ହା଼ରେକା ଲ଼କୁ ନାମିତେରି ଅ଼ଡ଼େ ଗ୍ରିକ୍‌ ଲ଼କୁତି କାଜାରି ବିତ୍ରାଟି ହା଼ରେକା ଇୟାସିକା ଅ଼ଡ଼େ ଆ଼ବାୟାଁ ଜିକେଏ ନାମିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ସାମା ଏଚିବେ଼ଲା ତେସଲନିକିତି ଜୀହୁଦିଙ୍ଗା ପୁଚେରି, କି ବେରିୟାତା ଜିକେଏ ପା଼ୱୁଲ ତା଼ଣାଟି ମାହାପୂରୁତି ବ଼ଲୁ ୱେସ୍‌ପି ଆ଼ହିମାନେ, ଏଚିବେ଼ଲା ଏ଼ୱାରି ଏମ୍ବାଆଁ ଜିକେଏ ୱା଼ହାନା ଲ଼କୁ ମାନ୍ଦାତି ନିକ୍‌ହାନା ଗଡ଼୍‌ହା କିୱିକିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ଏଚେଟିଏ ତାୟିୟାଁ ୱେ଼ଡ଼ାକିଆନା ପା଼ୱୁଲଇଁ ସାମ୍‌ଦୁରି ୱାକି ହାଜାଲି ପାଣ୍ତିତେରି; ଇଞ୍ଜାଁ ସିଲା ଅ଼ଡ଼େ ତିମତି ବେରିୟାତା ଡ଼ୟିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ସାମା ଆମ୍ବାଆରି ପା଼ୱୁଲଇଁ ଇଟିହାଚାରି ଏ଼ୱାରି ଆତିନି ପାତେକା ହାଚେରି, ଇଞ୍ଜାଁ ସିଲା ଅ଼ଡ଼େ ତିମତି ତବେ ନା଼ ତା଼ଣା ୱା଼ପେରି ଇଞ୍ଜିଁ ପା଼ୱୁଲ ତା଼ଣାଟି ହୁକୁମି ବେଟାଆ଼ହାନା ଏ଼ୱାରି ବେରିୟାତା ୱେଣ୍ତେ ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଆତିନିତା ପା଼ୱୁଲ, ସିଲା ଅ଼ଡ଼େ ତିମତିଇଁ କା଼ଚିମାଚେସି, ଏ଼ୱାସି ଏ଼ ଗା଼ଡ଼ାତା ହା଼ରେକା ପେ଼ଣ୍‌କା ବମାୟାଁ ମାନାଣି ମେସାନା ତାନି ଜୀୱୁ ହା଼ରେକା ୱୀଡିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଜୀହୁଦି ଲ଼କୁତଲେ ମାହାପୂରୁଇଁ ନାମାମାନି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତଲେ ଈ କାତା ବାରେଦିନା ୱେ଼କ୍‌ହେସି । ଗା଼ଡ଼ାତି ଜିରୁ ଗା଼ଟାତା ହାଜି ୱା଼ହିମାନି ଲ଼କୁତଲେ ଏ଼ କାତାତି ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ଏଚରଜା଼ଣା ଏପିକୁରିୟା ଇଞ୍ଜାଁ ସ୍ତୟିକ୍‌ ଜା଼ପ୍‌ନି ଗୂର୍‌କା ତଲେ ଏ଼ୱାରି ରୁଜୁବାଡ଼ି ଆ଼ତେ । ଏ଼ୱାରି ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଈ ବୁଦି ହିଲାଆ ହା଼ଡାଁକା଼ଣ୍ଡୁ ଏ଼ନାଆଁ ୱେସାଲି ଅଣ୍‌ପିମାନେସି ?” ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ଏ଼ୱାସି ପୁନାଆତି ପେ଼ଣ୍‌କାତି କାତା ୱେହ୍‌ନିଲେହେଁ ୱେସିମାନେସି;” ଇଚିହିଁ ଏ଼ୱାସି ଜୀସୁ ଅ଼ଡ଼େ ତାନି ୱେଣ୍ତେ ନିଙ୍ଗିତି କାତାତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ପା଼ୱୁଲଇଁ ଆରିୟପାଗ ଗା଼ଡ଼ାତି ବେ଼ରଣି ନ଼କିତା ତାତେରି, “ନୀନୁ ଆମିନି ପୁଃନି କାତା ଜା଼ପ୍‌ହିମାଞ୍ଜି ଏ଼ଦି ଏ଼ନାୟି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାଲି ଆ଼ଡିନମି କି ? ");
INSERT INTO kxv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ଇଚିହିଁ ନୀନୁ ଏଚେକା କାବାଆ଼ନି କାତା ମାଙ୍ଗେ ୱେଣ୍‌ମ୍ବି କିହିମାଞ୍ଜାଦି; ଈ ବାରେ କାତା ଏ଼ନାୟି ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାଲି ଅଣ୍‌ପିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଆତିନି ଗା଼ଡ଼ାତି ଲ଼କୁ ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ବାସାଆ଼ହାମାନି ଏଟ୍‌କା ଦେ଼ସାତି ଲ଼କୁ ପୁଃନି କାତା ୱେସାଲି ଇଞ୍ଜାଁ ୱେଞ୍ଜାଲି ରା଼ହାଁ ଆ଼ହିମାଚେରି । ଏମ୍ବାଆଁ ଏ଼ୱାରି ଦିନା ରା଼ପ୍‌ହି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ଏଚେଟିଏ ପା଼ୱୁଲ ଆରିୟପାଗତି ବେ଼ରଣି ମାଦିଏ ନିଚାନା ଏଲେଇଚେସି, “ଏ଼ ଆତିନିତି ଲ଼କୁ, ମୀରୁ ବାରେ ଗାଡି ଦାର୍ମୁଗାଟାତେରି, ଇଞ୍ଜାଁ ହା଼ରେକା ପେ଼ଣ୍‌କାଣି ସେ଼ବା କିନାତେରି, ଏ଼ଦାଆଁ ନା଼ନୁ ମେସିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ଇଚିହିଁ ନା଼ନୁ ମୀ ଗା଼ଡ଼ାଟି ହାଜିମାଚେଏଁ, ଅ଼ଡ଼େ ମୀରୁ ପୂଜା କିନି ଟା଼ୟୁତା ସିନିକିତେଏଁ, ନା଼ନୁ ପୂଜା ପିଣ୍ତାତା ମେସ୍ତେଏଁ ଏମ୍ବାଆଁ ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ପୁନାଆତି ମାହାପୂରୁ ।’ ଆମିନିଗାଟାଣି ମୀରୁ ପୂଜା କିହିମାଞ୍ଜେରି, ଏ଼ଦାଆଁ ମୀରୁ ପୁଞ୍ଜାହିଲାଆତିହିଁ ଜିକେଏ, ଏ଼ଦେଏ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଆମିନି ମାହାପୂରୁ ଦାର୍‌ତି ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ମାନି ବାରେ ରା଼ଚି କିହାମାନେସି, ଏ଼ୱାସି ଲାକପୂରୁ ଅ଼ଡ଼େ ଦାର୍‌ତିତି ପ୍ରବୁ ଆ଼ହାମାନାକି ମାଣ୍‌ସି କେୟୁଟି କେ଼ପିତି ଦେ଼ୱୁଡ଼ିତା ବାସା କିଅସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ଇଚିହିଁ ଏ଼ୱାଣାକି ଏ଼ନାୟି ଲ଼ଡ଼ା ମାନାୟି ହିଲାଆକି ମାଣ୍‌ସି କେୟୁଟି ସେ଼ବା ଆ଼ଅସି, ଇଚିହିଁ ଏ଼ୱାସି ତା଼ନୁଏ ବାରେତାକି ଜୀୱୁ, ନେ଼ଞ୍ଜାଲି ଇଞ୍ଜାଁ ବାରେ ଲ଼ଡ଼ାମାନାଣି ଇନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ର଼ ମାଣ୍‌ସି ତା଼ଣାଟି ଏ଼ୱାସି ବାରେ ଲ଼କୁ ବା଼କାଇଁ ରା଼ଚି କିହାମାନେସି; ଇଞ୍ଜାଁ ଏ଼ୱାଣି ହୁକୁମି ତଲେ ଏ଼ୱାରି ଦାର୍‌ତିତି ବାରେୱାକି ବାସା କିହାମାନେରି । ଆମିନି ବେ଼ଲାତା, ଆମ୍ବାଆସି ଆମିନି ତା଼ଣା ବାସା କିନେସି, ମାହାପୂରୁ ମୂଲୁଟିଏ ଏ଼ଦାଆଁ ତୀରି କିହାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ମାହାପୂରୁତି ଅଣ୍‌ପୁ ମାଚେ, ବାରେଜା଼ଣା ଏ଼ନିକିହିଁ ଏ଼ୱାଣାଇଁ ପାରାନା ବେଟାଆ଼ନେରି । ସାମା ମାହାପୂରୁ ଆମ୍ବାଆରି ତା଼ଣାଟି ହେକ ହିଲଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଏ଼ନିଇଚିହିଁ ରଅସି ୱେସାମାନେସି, “ଏ଼ୱାଣି ତା଼ଣା ମା଼ର ନୀଡିନାୟି, ତା଼କିନାୟି ଅ଼ଡ଼େ ଡ଼ୟିନାୟି । ଇଞ୍ଜାଁ ମୀ ବିତ୍ରାଟି ଜିକେଏ ଏଚରଜା଼ଣା ୱେସାମାନେରି, ମା଼ର ଜିକେଏ ଏ଼ୱାଣି ମୀର୍‌କା ମା଼ସ୍‌କା ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ଇଚିହିଁ ମା଼ର ମାହାପୂରୁତି ମୀର୍‌କା ମା଼ସ୍‌କା ଆ଼ତାକି ଈ ମାହାପୂରୁ ଲେହେଁ ମାଣ୍‌ସି ବୁଦି ଅ଼ଡ଼େ ଅଣ୍‌ପୁ ତଲେ କେ଼ପିତି ବାଂଗାରା, ୱେଣ୍ତି କି ୱାଲ୍‌କାତି ବମା ଲେହେଁ ଅଣ୍‌ପିନାୟି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ଲ଼କୁ ମାହାପୂରୁଇଁ ପୁଞ୍ଜା ହିଲାଆ ବେ଼ଲାତା ଏ଼ୱାସି ଦ଼ହ ଆସା ହିଲାଆତେସି, ସାମା ନୀଏଁ ଏ଼ୱାସି ବାରେଜା଼ଣାତି ବାରେୱାକି ତାମି ପା଼ପୁ ଜିରୁଟି ୱେଣ୍ତା ୱା଼ହାଲି ୱେସିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ଇଚିହିଁ ଆମିନି ଦିନା ତା଼ନୁ ଆ଼ଚିତି ମାଣ୍‌ସି ତା଼ଣାଟି ଦାର୍ମୁତଲେ ଦାର୍‌ତିତି ନୀହାଁୟି କିନେସି, ଇଲେତି ର଼ ଦିନା ତୀରି କିହାମାନେସି, ଇଞ୍ଜାଁ ଈ ବାରେ ସାତା ଇଞ୍ଜିଁ ତ଼ସାଲି ଏ଼ୱାସି ଏ଼ୱାଣାଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ହାମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପା଼ୱୁଲ ତା଼ଣାଟି ହା଼ତାରି ୱେଣ୍ତେ ନିଙ୍ଗିନି କାତା ୱେଞ୍ଜାନା ଏଚରଜା଼ଣା ଲାଜା କିତେରି, ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏଲେଇଚେରି, “ମାଙ୍ଗେ ଅ଼ଡ଼େ ୱେଣ୍ତେ ୱେସ୍ତାମୁ, ନୀ ତା଼ଣାଟି ଈ କାତା ୱେନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଏଚେଟିଏ ପା଼ୱୁଲ ବେ଼ରଣିଟି ହ଼ଚାହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଏରିୟପାଗିୟ ଦିୟନୁସିୟ ଗଚିତି ଦାମାରି ଇନି ର଼ ଇୟା ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ନାମିତେରି ଇଞ୍ଜାଁ ଏ଼ୱାଣିତଲେ ଆଣ୍ଡିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ଆତିନି ଗା଼ଡ଼ା ପିସାନା କରନ୍ତିତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଆକ୍‌ୱିଲା ଦ଼ରୁଗାଟି ର଼ ଜୀହୁଦି ଲ଼କୁଇଁ ବେଟାଆ଼ତେସି, ପନ୍ତ ଏ଼ୱାଣି ଜାର୍ନା ଟା଼ୟୁ; ଏଚରଦିନା ନ଼କେଏ ଏ଼ୱାସି ତାନି ଡକ୍ରି ପ୍ରିସ୍କିଲା ତଲେ ଇଟାଲିଟି ୱା଼ହାମାଚେସି, ଇଚିହିଁ କ୍ଲାୱୁଦିୟା ବାରେ ଜୀହୁଦି ଲ଼କୁଇଁ ର଼ମ୍‌ ପିସା ହାଜାଲି ହୁକୁମି ହୀହାମାଚେସି, ପା଼ୱୁଲ ଏ଼ୱାସିକାଣି ବେ଼ଚି ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ୱାଣିଲେହେଁ ତୂମୁ ବେ଼ବାରା କିନାରି ମାଚାକି ଏ଼ୱାରିତଲେ ଡ଼ୟିତେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି କାମା କିହାଲି ମା଼ଟ୍‌ହେରି, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ବେ଼ବାରାତା ଏ଼ୱାରି ତୂମୁ କିନାରି ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଅ଼ଡ଼େ ବାରେ ଜ଼ମିନି ଦିନାତା ଏ଼ୱାସି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଜ଼ଲ୍‌କି ଆ଼ହିଁ ଜା଼ପ୍‌ହେସି, ଜୀହୁଦି ଅ଼ଡ଼େ ଗ୍ରିକ୍‌ ଲ଼କୁଣି ନାମି କିୱିକିହାଲି ଅଣ୍‌ପିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ଏଚିବେ଼ଲା ସିଲା ଅ଼ଡ଼େ ତିମତି ମାକିଦନିୟାଟି ୱା଼ତେରି, ଏଚିବେ଼ଲା ପା଼ୱୁଲ ନେହିଁ ବ଼ଲୁ ୱେ଼କ୍‌ନି କାମା ଜ଼ମାଆନା କିହିମାଚେସି, ଅ଼ଡ଼େ ଜୀସୁଇଁ ମସିହା ଇଞ୍ଜିଁ ଜୀହୁଦି ଲ଼କୁତା଼ଣା ସା଼କି ହୀହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ସାମା ଏ଼ୱାରି ଅ଼ପାଆନା ନିନ୍ଦା କିହାଲିଏ ଏ଼ୱାସି ତାନି ହିମ୍ବରି ହାଣ୍‌ହାଁନା ଏଲେଇଚେସି, “ମୀରୁ ନା଼ସା ଆତିହିଁ ଏ଼ଦାଆଁତାକି ମୀରୁ ଦା଼ୟି ଆ଼ଦେରି । ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଦା଼ୟି ଆ଼ଏ, ନୀଏଁ ନା଼ନୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ହାଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏ଼ ଟା଼ୟୁଟି ହ଼ଚା ହାଜାନା ତିତସ ଜୁସ୍ତ ଇନି ଜୀହୁଦିଆ଼ଆତି ମାହାପୂରୁ ସେ଼ବା କିନାସି ଏ଼ୱାଣି ଇଜ ହାଚେସି, ଏ଼ୱାଣି ଇଲୁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁ ଡାଗେ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ସାମା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାସି କ୍ରିସ୍‌ପ ବାରେ ଇଲୁ କୁଟମି ତଲେ ପ୍ରବୁ ତା଼ଣା ନାମିତେରି, ଅ଼ଡ଼େ କରନ୍ତି ଗା଼ଡ଼ାତି ଲ଼କୁ ବିତ୍ରାଟି ହା଼ରେକା ପା଼ୱୁଲତି କାତା ୱେଞ୍ଜାନା ନାମିତେରି ଅ଼ଡ଼େ ବାପ୍ତିସ୍ମ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଅ଼ଡ଼େ ପ୍ରବୁ ଲା଼ଆଁୟାଁ ବେ଼ଲାତା ସେୟାଁଣା ହାପାନାତା ପା଼ୱୁଲଇଁ ଏଲେଇଚେସି, “ଆଜାଆନି, ସାପି ଡ଼ୟାଆନା ଜ଼ଲାମୁ, ");
INSERT INTO kxv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଇଚିହିଁ ନା଼ନୁ ନୀ ତଲେ ମାଇଁ, ଆମିନି ଲ଼କୁ ଜିକେଏ ନୀ କ଼ପାଟି ନିଙ୍ଗାନା ନିଙ୍ଗେ ନା଼ସା କିହାଲି ଆ଼ଡଅସି, ଇଚିହିଁ ଈ ଗା଼ଡ଼ାତା ହା଼ରେକା ନା଼ ଲ଼କୁ ମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଏ଼ୱାରିତା଼ଣା ମାହାପୂରୁତି କାତା ଜା଼ପ୍‌ହିହିଁ ର଼ ବାର୍ସା ସ଼ ଲେ଼ଞ୍ଜୁ ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ସାମା ଗାଲିୟ ଆକାୟାତି ରମିୟ ସା଼ଲୱି କିନାସି ମାଚିବେ଼ଲାତା, ଜୀହୁଦି ଲ଼କୁ ପା଼ୱୁଲ କ଼ପାଟି ନିଙ୍ଗାନା ଏ଼ୱାଣାଇଁ ନୀହାଁୟି କିନାରି ତା଼ଣା ଦସା ଅ଼ହାନା ଏଲେଇଚେରି, ");
INSERT INTO kxv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ଈୱାସି ମ଼ସାତି ମେ଼ରା କ଼ପାଟି ଅ଼ର ର଼ଲେକିଁ ମାହାପୂରୁତି ସେ଼ବା କିହାଲି ଲ଼କୁଣି ଜା଼ପ୍‌ହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ସାମା ପା଼ୱୁଲ ଗୂତି ଏ଼କ୍‌ହାନା ଜ଼ଲାଲି ମା଼ଟ୍‌ହି ମାଚାଟି, ଗାଲିୟନ ଜୀହୁଦି ଲ଼କୁଣି ଏଲେଇଚେସି, “ଆଡ଼େ ଜୀହୁଦି ଲ଼କୁତେରି ଏ଼ନିଲେହେଁତି ଦ଼ହ କି ଲାଗେଏତି କାମା ଆ଼ତିହିଁମା ସୂସ୍ତି ତଲେ ମୀ କାତା ୱେନାୟି ନାଙ୍ଗେତାକି ନେହେଁ ଆ଼ତେମା, ");
INSERT INTO kxv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ସାମା ଈଦି ୱାର୍‌ଇ ବ଼ଲୁ ଅ଼ଡ଼େ ଦ଼ରୁ ଅ଼ଡ଼େ ମୀ ମେ଼ରାତି କାତା ମୀରୁଏ ଈଦାଆଁ ସୂସ୍ତି କିଦୁ । ଇଲେତି କାତାତି ନା଼ନୁ ନୀହାଁୟି କିଅଁ !” ");
INSERT INTO kxv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଏଲେଇଞ୍ଜାନା ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ନୀହାଁୟି କିନି ତା଼ଣାଟି ପେ଼ର୍‌ହା ତୁସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ଏଚେଟିଏ ବାରେଜା଼ଣା ସସ୍ତାନ ଇନି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତି କାଜାଣାଇଁ ଆସାନା ନୀହାଁୟି ପାଙ୍ଗାତା ୱେ଼ତେରି; ସାମା ଗାଲିୟନ ଏ଼ ବାରେ କାତାତା ମ଼ନ ହୀଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପା଼ୱୁଲ କରନ୍ତିତା ନାମିତି ତାୟି ତାଙ୍ଗିସ୍କା ତଲେ ହା଼ରେକା ଦିନା ଡ଼ୟାନା ତାୟିୟାଁ ତା଼ଣାଟି ହେଲ ବେଟାଆ଼ହାନା ଏ଼ୟୁ ଜା଼ଜାଟି ସିରିୟାତା ହାଚେସି, ପ୍ରିସ୍କିଲା ଅ଼ଡ଼େ ଆକ୍‌ୱିଲା ତାନିତଲେ ହାଚେରି, ତାନି ଆ଼ଞ୍ଜିତାୟି ମାଚାକି ଏ଼ୱାସି କେଙ୍କ୍ରେୟାତା ତାନି ତା଼ର୍ୟୁଁ ହିଣ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ଡା଼ୟୁ ଏ଼ୱାରି ଏପିସିୟତା ୱା଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ ଟା଼ୟୁତା ଆକ୍‌ୱିଲା ଅ଼ଡ଼େ ପ୍ରିସ୍କିଲାଇଁ ହେଲ ହୀହାନା ପା଼ୱୁଲ ରଅସିଏ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହ଼ଡାନା ଜୀହୁଦିୟାଁ ତଲେ ହା଼ଡାକାତା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ହା଼ରେକା ଦିନା ଡ଼ୟାଲି ବାତିମା଼ଲିତିହିଁୱା ଏ଼ୱାସି ଡ଼ୟାଲି କୂତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ସାମା ଏ଼ୱାରି ତା଼ଣାଟି ହେଲ ଅ଼ହାନା ଏଲେଇଚେସି, “ମାହାପୂରୁତି ମ଼ନ ଆତିହିଁ ଅ଼ଡ଼େ ର଼ ଦେବା ମୀ ତା଼ଣା ୱେଣ୍ତା ୱା଼ଇଁ,” ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏପିସିୟଟି ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","କାୟିସରିୟାତା ଏଗାହାଜାନା ଏମ୍ବାଟି ଜିରୁସାଲମତା ହାଚେସି, ଅ଼ଡ଼େ କୁଲମିତି ଜହରା କିହାନା ଏମ୍ବାଟିଏ ଆନ୍ତିୟକିୟାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ଏମ୍ବାଆଁ ଏଚରଦିନା ଡ଼ୟିତି ଡା଼ୟୁ, ଏ଼ୱାସି ଅ଼ଡ଼େ ୱେଣ୍ତେ ହାଜାନା ଗାଲାତିୟ ଇଞ୍ଜାଁ ପୁର୍ଗିୟା ନା଼ସ୍‌କା ହୀହାନା ହାଚେସି, ଅ଼ଡ଼େ ଜିରୁତା ସୀସୁୟାଁଣି ତାମି ନାମୁତା ଆ଼ଟ୍‌ୱା ତଲେ ଡ଼ୟାଲି ରା଼ହାଁ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଏମ୍ବାଟିଏ ଆପଲ ଦ଼ରୁଗାଟି ର଼ ଜୀହୁଦି ଏପିସିୟତା ୱା଼ତେସି, ଏ଼ୱାସି ଆଲେକ୍‌ଜାଣ୍ତ୍ରିୟାତା ଜାର୍ନା ଆ଼ହାମାଚେସି, ଏ଼ୱାସି ନେହିଁକିଁ ୱେସାଲି ଆ଼ଡିନାସି ଅ଼ଡ଼େ ଦାର୍ମୁ ପତିତି କାତା ଗାଡି ପୁନାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଈୱାସି ପ୍ରବୁ ଜିରୁତି କାତା ନେହିଁକିଁ ଜା଼ପାମାଚେସି, ଇଞ୍ଜାଁ ଜୀୱୁତଲେ ବା଼ଡ଼୍‌ୟୁ ବେଟାଆ଼ହାନା ଜୀସୁତି କାତା ନେହିଁକିଁ ଜା଼ପ୍‌ହି ମାଚେସି, ଏ଼ୱାସି ୱାର୍‌ଇ ଜହନତି ବାପ୍ତିସ୍ମ କାତା ପୁଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ଏ଼ୱାସି ସା଼ସାତଲେ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ଜ଼ଲାଲି ମା଼ଟ୍‌ହେସି, ସାମା ଆକ୍‌ୱିଲା ଅ଼ଡ଼େ ପ୍ରିସ୍କିଲା ଏ଼ୱାଣି କାତା ୱେଞ୍ଜାନା ଏ଼ୱାଣାଇଁ ତାମି ଇଜ ଅ଼ହାନା ଏମ୍ବାଆଁ ହା଼ରେକା ନେହେଁ ମାହାପୂରୁ ଜିରୁତି କାତା ପୁଣ୍‌ମ୍ବିକିତୁ । ");
INSERT INTO kxv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ଡା଼ୟୁ ଆପଲ ଆକାୟା ଦେ଼ସାତା ହାଜାଲି ମ଼ନ କିହାଲିଏ ଏପିସିୟତି ନାମିତି ତାୟିୟାଁ ଏ଼ୱାଣାଇଁ ସା଼ୟେମି କିତେରି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାଇଁ ରା଼ହାଁତଲେ ଆବାଲି ଆକାୟାତା ମାନି ସୀସୁୟାଁକି ର଼ ଆ଼କୁ ରା଼ଚିତେରି, ଏ଼ୱାସି ଏମ୍ବାଆଁ ଏଗାହାଜାନା ମାହାପୂରୁ କାର୍ମାଟି ନାମା ମାନାରାକି ହା଼ରେକା ସା଼ୟେମି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଇଚିହିଁ ଜୀସୁଏ ମସିହା ଇଞ୍ଜିଁ ଦାର୍ମୁ ପତିଟି ନେହିଁକିଁ ତ଼ସାହାଁ ଏ଼ୱାସି ବାରେଜା଼ଣା ନ଼କିତା ତାନିତଲେ ଆସ୍‌ପି ଆ଼ହିମାନି ଜୀହୁଦି ଲ଼କୁଣି ହା଼ରୱି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପଲ କରନ୍ତିତା ମାଚିବେ଼ଲାତା ପା଼ୱୁଲ ୱେ଼ଡ଼ା ହ଼ପୁୱାକିତି ରା଼ଜି ରେ଼ଜାନା ଏପିସିୟ ଗା଼ଡ଼ାତା ଏଗାୱା଼ତେସି । ଏମ୍ବାଆଁ ଏଚରଜା଼ଣା ସୀସୁୟାଁଣି ବେଟାଆ଼ତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ୱେଚେସି, “ମୀରୁ ନାମିତି ରେ଼ଟୁଏ ସୁଦୁଜୀୱୁ ବେଟାଆ଼ହା ମାଚେରି କି ?” ଏ଼ୱାରି ଏଲେଇଚେରି, “ଆ଼ଏ ସୁଦୁଜୀୱୁ ମାନେ ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ୱେଞ୍ଜା ଜିକେଏ ହିଲଅମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ୱେଚେସି, “ଆତିହିଁ ମୀରୁ ଏ଼ନିଲେହେଁତି ବାପ୍ତିସ୍ମ ବେଟାଆ଼ହା ମାଚେରି ।” ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଜହନତି ବାପ୍ତିସ୍ମ ଅ଼ହାମାଚମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଜହନତି ବାପ୍ତିସ୍ମ ହିୟାଁ ୱେଟ୍‌ପି କିୱିକିନି ବାପ୍ତିସ୍ମ; ଜହନ ଇସ୍ରାୟେଲ ଲ଼କୁଣି ବାପ୍ତିସ୍ମ ହୀହାନା ଏଲେଇଚେସି, ନା଼ ଜେ଼ଚ ଆମ୍ବାଆସି ୱା଼ହିମାନେସି, ଏ଼ୱାଣାଇଁ ଇଚିହିଁ ଜୀସୁଇଁ ନାମାଦୁ ଇଞ୍ଜିଁ ୱେସିମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ଈଦାଆଁ ୱେଞ୍ଜାନା ଏ଼ୱାରି ପ୍ରବୁ ଜୀସୁ ଦ଼ରୁତଲେ ବାପ୍ତିସ୍ମ ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ଅ଼ଡ଼େ ପା଼ୱୁଲ ଏ଼ୱାରି ଲାକ କେସ୍କା ଇଟାଲିଏ ସୁଦୁଜୀୱୁ ଏ଼ୱାରି ଲାକ ରେ଼ଚାୱା଼ତେ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ଏଟ୍‌କା ଏଟ୍‌କା ହା଼ଡାତଲେ କାତା ଜ଼ଲାନା ମାହାପୂରୁତି ଡା଼ୟୁ ଆ଼ନି କାତା ଜିକେଏ ୱେ଼କ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ଏ଼ୱାରି ବାରେ ବା଼ରଜା଼ଣା ଆ଼ବାୟାଁ ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ଡା଼ୟୁ ପା଼ୱୁଲ ଜୀହୁଦି ଲ଼କୁତି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା ହାଜାନା ତୀନି ଲେ଼ଞ୍ଜୁ ପାତେକା ସା଼ସାତଲେ ମାହାପୂରୁ ରା଼ଜିତି କାତା ୱେ଼କ୍‌ହିହିଁ ଲ଼କୁତି ମ଼ନତି ନାମି କିହାଲି ଅଣ୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ସାମା ଏଚିବେ଼ଲା ଏଚେକା ଲ଼କୁ ଆ଼ଟ୍‌ୱା ହିୟାଁ ଅ଼ଡ଼େ ମୁଣ୍ତି ଆ଼ହାନା ଲ଼କୁ ନ଼କିତା ପ୍ରବୁ ଜିରୁ କ଼ପାଟି ନିଙ୍ଗାନା ନିନ୍ଦା କାତା ୱେସ୍ତେରି, ଏଚିବେ଼ଲା ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ପିସାନା ସୀସୁୟାଁଇଁ ଏଟ୍‌କା କିତେସି, ଇଞ୍ଜାଁ ତୁରାନନ୍‌ ଇନି ଜା଼ପ୍‌ନି ଇଲୁତା ବାରେଦିନା ଜା଼ପ୍‌ହି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଇଲେଆ଼ହିଁ ରୀ ବାର୍ସା ପାତେକା ଆ଼ତେ; ଏଚେଟିଏ ଆସିୟା ଦେ଼ସାତା ବାସାଆ଼ହାମାନି ହା଼ରେକା ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବାରେଜା଼ଣା ପ୍ରବୁତି କାତା ୱେଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ଅ଼ଡ଼େ, ମାହାପୂରୁ ପା଼ୱୁଲ ତା଼ଣାଟି ହା଼ରେକା ବା଼ଡ଼୍‌ୟୁତି କାମାୟାଁ କିହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଇଲାଆ଼ହିଁ ପା଼ୱୁଲ ଲେ଼ମ୍ବିମାନି ପାଙ୍ଗାତା ତୁର୍‌ନି ସକା କି ତୁୱାଲା ର଼ଗ ଗାଟାରି ତା଼ଣା ତାତିସାରେ ଏ଼ୱାରି ତା଼ଣାତି ର଼ଗ ପିସିମାଚେ ଅ଼ଡ଼େ ବୂତୁୟାଁ ହ଼ଚା ହାଜିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ସାମା ରେ଼ଜି ରେ଼ଜିହିଁ ବୂତୁୟାଁ ପେ଼ର୍‌ନି ଜୀହୁଦିୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ଆସାମାନାରି ଲାକ ପ୍ରବୁ ଜୀସୁ ଦ଼ରୁ ଆସାନା ପେ଼ର୍‌ହାଲି ଅଣ୍‌ପାନା ଏଲେଇଚେରି, “ପା଼ୱୁଲ ଆମିନି ଜୀସୁଇଁ ୱେ଼କ୍‌ହି ମାନେସି ନା଼ନୁ ଏ଼ୱାଣି ଦ଼ରୁଟି ନିଙ୍ଗେ ହୁକୁମି ହୀହିମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ସ୍କେବା ଦ଼ରୁଗାଟି ର଼ ଜୀହୁଦି କାଜା ପୂଜେରାତି ସା଼ତା ଜା଼ଣା ମୀର୍‌କା ଏଲେ କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ସାମା ପ଼ଲ୍‌ଆ ବୂତୁୟାଁ ଏ଼ୱାରାଇଁ ଏଲେଇଚୁ, “ନା଼ନୁ ଜୀସୁଇଁ ପୁଞ୍ଜାମାଇଁ ଅ଼ଡ଼େ ପା଼ୱୁଲଇଁ ପୁଞ୍ଜାମାଇଁ; ସାମା ମୀରୁ ଆମ୍ବାଆତେରି ?” ");
INSERT INTO kxv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଏଚେଟିଏ ଏ଼ ପ଼ଲ୍‌ଆ ବୂତୁ ଆଲ୍‌ଗା ମାଚାସି ଏ଼ୱାରି ଲାକ ଡେ଼ୱାଁନା ଏ଼ୱାରାଇଁ ଇର୍‌ହାଲିଏ ଏ଼ୱାରି ନା଼ଗ୍‌ଡ଼ା ଉଗ୍‌ଡ଼ା ରା଼ଣାରାକା ଆ଼ହାନା ଏ଼ ଇଲୁଟି ହଟେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଈ କାତା ଏପିସିୟତା ମାନି ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ବାରେଜା଼ଣା ପୁଚେରି, ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ଆଜିତେରି, ଅ଼ଡ଼େ ଏମ୍ବାଆଁ ପ୍ରବୁ ଜୀସୁତି ଦ଼ରୁ ହା଼ରେକା ଗାୱୁରମି କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ଅ଼ଡ଼େ ନାମୁଗାଟାରି ବିତ୍ରାଟି ହା଼ରେକା ୱା଼ହାନା ତା଼ମ୍ବୁ କିହାମାନି ପ଼ଲ୍‌ଆ କାମାତି ୱେସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଅ଼ଡ଼େ ଗାର୍‌ଡ଼ି କାମା କିହିମାଚି ହା଼ରେକା ଜା଼ଣା ତା଼ମ୍ବୁ ତାମି ପତିୟାଁ ତାଚିହିଁ ରୁଣ୍ତା କିହାନା ବାରେଜା଼ଣା ନ଼କିତା ହୂଡିତେରି; ଏ଼ୱାରି ଏ଼ ବାରେତି ଲେକା କିହାଲିଏ ରୀ କ଼ଡ଼ି ଦସ ମା଼ଣା ୱେଣ୍ତି ଟାକାୟାଁତି ପତିୟାଁ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଇଲେଆ଼ହିଁ ପ୍ରବୁତି ବ଼ଲୁ ବା଼ଡ଼୍‌ୟୁ ତଲେ ପାଡାଆ଼ତେ ସା଼ରିସୁଟୁ ୱେ଼ଙ୍ଗିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଈ ବାରେ କାତା ରା଼ତି ଡା଼ୟୁ ପା଼ୱୁଲ ମାକିଦନିୟା ଅ଼ଡ଼େ ଆକାୟା ମାଦିଟି ଜିରୁସାଲମତା ହାଜାଲି ମ଼ନତା ତୀରି କିତେସି । ଏ଼ୱାସି ଏଲେଇଚେସି, “ଏମ୍ବାଆଁ ହାଚି ଡା଼ୟୁ ନା଼ନୁ ର଼ମ୍‌ତା ଜିକେଏ ହାନାୟିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଅ଼ଡ଼େ ଆମ୍ବାଆରି ଏ଼ୱାଣି ସେ଼ବା କିହିମାଚେରି, ଏ଼ୱାରି ବିତ୍ରାଟି ତିମତି ଅ଼ଡ଼େ ଏରାସ୍ତ ଈ ରିଆରାଇଁ ମାକିଦନିୟାତା ପାଣ୍ତାନା ଏ଼ୱାସି ଏଚରଦିନା ପାତେକା ଆସିୟାତା ଡ଼ୟିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଏଚିବେ଼ଲାତା ପ୍ରବୁ ତ଼ସାମାନି ଜିରୁତି କାତା ଅ଼ହାନା ଏପିସିୟତା ହା଼ରେକା ଗଡ଼୍‌ହା ଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଦିମିତ୍ରିୟ ଦ଼ରୁଗାଟି ର଼ ୱେଣ୍ତି କାମାକିନାସି ଆର୍ତେମି ପେ଼ନୁତି ର଼ ୱେଣ୍ତିତି ଦେ଼ୱୁଡ଼ି କିହିମାଚେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣି ଈ ବେ଼ବାରା କାମା କିନାରାକି ହା଼ରେକା ଲା଼ବା ଆ଼ହିମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଇଞ୍ଜାଁ ଏ଼ୱାରିଲେହେଁ କାମା କିନାରାଇଁ ହା଼ଟାନା ଏଲେଇଚେସି, “ବା଼ବୁୟାଁ ଈ କାମାଟି ମା଼ର ଦ଼ନ ବେଟାଆ଼ହି ମାନାୟି ଇଞ୍ଜିଁ ମୀରୁ ବାରେ ପୁଞ୍ଜାମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଅ଼ଡ଼େ, କେସ୍କାତଲେ କେ଼ପିତି ପେ଼ଣ୍‌କା ମାହାପୂରୁ ଆ଼ଏ ଇଞ୍ଜିଁ ୱେସାନା ପା଼ୱୁଲ ୱାର୍‌ଇ ଏପିସିୟତା ଆ଼ଏ, ସାମା ବାରେ ଆସିୟାତା ଜିକେଏ ହା଼ରେକା ଲ଼କୁଣି ଜା଼ପ୍‌ହାନା ଏମ୍ବାଟି ମା଼ତୱି କିହିମାନେସି, ଈଦାଆଁ ମୀରୁ ମେସାମାଞ୍ଜେରି ଅ଼ଡ଼େ ୱେଞ୍ଜାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଇମ୍ବାଆଁ ୱାର୍‌ଇ ମା଼ ବେ଼ବାରା କାମା ଲାଗେଏ ଆ଼ନେ, ଏ଼ଦି ଆ଼ଏ, ସାମା ଆମିନି କାଜା ପେ଼ନୁ ଆର୍ତେମିଇଁ ବାରେ ଆସିୟା ଅ଼ଡ଼େ ଦାର୍‌ତିତି ଲ଼କୁ ପୂଜା କିହିମାନେରି, ଏ଼ଦାନି ଦେ଼ୱୁଡ଼ିତି ଜିକେଏ ଲ଼କୁ ମା଼ନି କିଅରି, ଇଞ୍ଜାଁ ଆର୍ତେମି ପେ଼ନୁତି ଦ଼ରୁ କାଜା ଦ଼ରୁ ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଈ କାତା ୱେଞ୍ଜାନା ବାରେଜା଼ଣା କାର୍‌ବି ଆ଼ହାନା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେରି, “ଏପିସିୟ ଲ଼କୁତି ଆର୍ତେମିଏ କାଜା ପେ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଏଚେଟିଏ ଗା଼ଡ଼ା ବାରେ ଗଡ଼୍‌ହା ଆ଼ତେ, ଇଞ୍ଜାଁ ଲ଼କୁ ବାରେ କା଼ଲୱି ଆ଼ହାନା ପା଼ୱୁଲ ତଲେ ହାଜିମାଚି ମାକିଦନିୟାତି ଗାୟ ଅ଼ଡ଼େ ଆରିସ୍ତାର୍କଇଁ ଦସାନା କାହିନି ବାଟାତା ହଟେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ଲ଼କୁ ମାନ୍ଦା ବିତ୍ରା ହାଜାଲି ଅଣ୍‌ପିତେସି, ସାମା ସୀସୁୟାଁ ଏ଼ୱାଣାଇଁ ହାଜାଲି ହୀଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଅ଼ଡ଼େ ଆସିୟାତି ସା଼ଲୱି କିନାରି ବିତ୍ରାଟି ଜିକେଏ ଏ଼ୱାରି ତ଼ଡ଼ୁ ଗାଟାରି ମାଚାକି କାହିନି ବାଟା ମାଦି ହାଲାଆପେସି ଇଞ୍ଜିଁ ଲ଼କୁଣି ୱେସା ପାଣ୍ତାନା ଏ଼ୱାଣାଇଁ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ଏଚିବେ଼ଲା ହା଼ରେକା ଗଡ଼୍‌ହା ଆ଼ହିମାଚେ, ଇଞ୍ଜାଁ ଲ଼କୁ ମାନ୍ଦା ମାନ୍ଦା ଆ଼ହିଁ ଏଚରଜା଼ଣା ଈ କାତା ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ଏ଼ କାତା ଇଞ୍ଜିଁ କା଼ଲୱି ଆ଼ହିମାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ନାଆଁତାକି ରୁଣ୍ତା ଆ଼ହାମାନେରି ହା଼ରେକା ଲ଼କୁ ପୁଞ୍ଜାହିଲାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ଲ଼କୁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ଏଲେଇଚେରି, ଆଲେକ୍‌ଜାଣ୍ତାର ଈଦାଆଁତାକି ଦା଼ୟି, ଇଚିହିଁ ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ନ଼କିତା ନିପ୍‌ହା ମାଚେରି, ଆଲେକ୍‌ଜାଣ୍ତାର କେୟୁ ପେର୍‌ହାନା ଲ଼କୁଣି ପାଲେଏ ଆ଼ହାଲି କେୟୁ ଜୀଞ୍ଜିତେସି, ଅ଼ଡ଼େ ନାମୁଗାଟାରି ୱାକିଟି ୱେସାଲି ଅଣ୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ସାମା ଏ଼ୱାସି ର଼ ଜୀହୁଦି ଇଞ୍ଜିଁ ଏଚିବେ଼ଲା ଏ଼ୱାରି ପୁଚେରି; ଏଚିବେ଼ଲା ବାରେଜା଼ଣା କାଜା ଗିୟାଁତଲେ ରୀ ଗଂଟା ପାତେକା କା଼ଲୱି ଆ଼ହାନା ଏଲେଇଚେରି, “ଆର୍ତେମିଏ ଏପିସିୟ ଲ଼କୁତି କାଜା ପେ଼ନୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ଡା଼ୟୁ ଗା଼ଡ଼ାତି କାଜାସି ଲ଼କୁଣି ସୂସ୍ତି କିହାଲି ୱେସ୍ତେସି, “ଏ଼ ଏପିସିୟତା ମାନି ତାୟିୟାଁତେରି ବାରେଜା଼ଣା ପୁଞ୍ଜାମାନେରି ଏପିସିୟ ଗା଼ଡ଼ାତି କାଜା ପେ଼ନୁ ଆର୍ତେମିତି ଦେ଼ୱୁଡ଼ି ଇଞ୍ଜାଁ ହା଼ଗୁଲାକଟି ରେ଼ଚା ୱା଼ହାମାନି ସୁଦୁତି ବମା ଗେଲ୍‌ପିକିୱି ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ଆମ୍ବାଆସି ଈଦାଆଁ ଆ଼ଏ ଇଞ୍ଜାଲି ଆ଼ଡଅସି, ଏ଼ଦାଆଁତାକି ମୀରୁ ବାରେ ସୂସ୍ତି ଆ଼ଦୁ, ଏ଼ନି ବୁଦି ହିଲାଆ କାମା କିଆଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଇଚିହିଁ ଈ ଆମିନି ଲ଼କୁଇଁ ମୀରୁ ଦସା ତାଚାମାଞ୍ଜେରି, ଈୱାରି ଦେ଼ୱୁଡ଼ିତି ସ଼ରୁ କିହାହିଲଅରି, ଇଞ୍ଜାଁ ମା଼ ପେ଼ଣ୍‌କା କ଼ପାଟି ଏ଼ନି ନିନ୍ଦା କାତା ଜ଼ଲା ହିଲଅରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଏ଼ଦାଆଁତାକି ଦିମିତ୍ରିୟ ଅ଼ଡ଼େ ଏ଼ୱାଣିତଲେ କାମାକିନାରି ଆମ୍ବାଆରି କ଼ପାଟି ଏ଼ନି କାତା ମାଚିହିଁ, ନୀହାଁୟି କିହାଲି ନୀହାଁୟି ଇଲୁ ଦେପିଆ଼ହାମାନେ, ଇଞ୍ଜାଁ ନୀହାଁୟି କିନାରି ମାନେରି, ଏ଼ୱାରି ନ଼କିତା ତା଼ମ୍ବୁ ତାମି ଦାୱା କିପେରି । ");
INSERT INTO kxv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ଈଦାଣିକିହାଁ ଆଗାଡ଼ା ଅଣ୍‌ପିମାଚିହିଁ, ଲ଼କୁ ତା଼ଣାଟି ମେ଼ରା କିୱି ଆ଼ହାମାନି ନୀହାଁୟି କିନି ତା଼ଣା ଏ଼ଦାଆଁ ଡିକ୍‌ନାୟି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ଇଚିହିଁ ସାତେଏ ନୀଞ୍ଜୁତି ଗଡ଼୍‌ହା ତାକି ମା଼ କ଼ପାଟି ଦାୱା ଆ଼ନାୟି ମାନେ; ଏ଼ନିଇଚିହିଁ ଏ଼ ଗଡ଼୍‌ହା ଏ଼ନାଆଁତାକି ହ଼ତେ ଏ଼ଦାଆଁ ମା଼ର ଏ଼ନି କାତାତଲେ ତ଼ସାଲି ଆ଼ଡାଆୟି ।” ");
INSERT INTO kxv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଈ ବାରେ କାତା ୱେସାନା ଲ଼କୁଣି ସୂସ୍ତି କିହାନା ନୀହାଁୟି ଡୂକ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ଏ଼ ଗଡ଼୍‌ହା ଡୂଙ୍ଗିତି ଡା଼ୟୁ ପା଼ୱୁଲ ସୀସୁୟାଁଣି କୂଡ଼ି କିହାନା ଏ଼ୱାରାଇଁ ବା଼ର୍ସୁତି କାତା ୱେସ୍ତେସି, ଏ଼ୱାରି ତା଼ଣାଟି ହେଲ ଅ଼ହାନା ମାକିଦନିୟାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ଏ଼ୱାସି ବାରେ ନା଼ସ୍‌କାଟି ହାଜିହିଁ, ହା଼ରେକା ସୀସୁୟାଁଣି ବା଼ର୍ସୁ ହୀହାନା ଗ୍ରିସ୍‌ ଦେ଼ସାତା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏମ୍ବାଆଁ ତୀନି ଲେ଼ଞ୍ଜୁ ଡ଼ୟିତେସି, ଏ଼ୱାସି ସିରିୟାତା ହାଜାଲି ତିୟାରା ଆ଼ହିମାଚି ବେ଼ଲାତା, ଜୀହୁଦି ଲ଼କୁ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ତୀରି କିହାମାନେରି ଇଞ୍ଜିଁ କାବ୍ରୁ ପୁଞ୍ଜାନା ମାକିଦନିୟା ୱାକିଟି ୱେଣ୍ତେ ହାଜାଲି ତୀରି କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ଅ଼ଡ଼େ ବେରିୟା ତାସି ପୁର୍‌ତି ମୀର୍‌ଏସି ସପାତର, ଅ଼ଡ଼େ ତେସଲନିକି ଗା଼ଡ଼ାତି ଆରିସ୍ତାର୍କ, ସେକୁନ୍ଦ, ଦର୍ବିତି ଗାୟ, ତିମତି ଅ଼ଡ଼େ ଆସିୟାତି ଲ଼କୁ ବିତ୍ରାଟି ତୁକିକ ଅ଼ଡ଼େ ତ୍ରପିମ ଏ଼ୱାଣିତଲେ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଏ଼ୱାରି ବାରେଜା଼ଣା ନ଼କେଏ ହାଜାନା ତ୍ରୟାତା ମାଙ୍ଗେ କା଼ଚିମାଞ୍ଜାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ଅ଼ଡ଼େ ପୁଲା ଗୁଣ୍ତା ଆଣ୍ତାଆତି ରୂଟି ତିନି ପାର୍ବୁ ଡା଼ୟୁ ମା଼ମ୍ବୁ ପିଲିପିଟି ଏ଼ୟୁ ଜା଼ଜାଟି ହାଚମି, ଇଞ୍ଜାଁ ପା଼ସା ଦିନା ଡା଼ୟୁ ତ୍ରୟାତା ଏ଼ୱାରାଇଁ ବେଟାଆ଼ହାନା; ଏମ୍ବାଆଁ ର଼ ୱା଼ରା ଡ଼ୟିତମି । ");
INSERT INTO kxv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ୱା଼ରାତି ମୂଲୁ ଦିନାତି ମିଡ଼୍‌ଅଲା ରା଼ନ୍ଦା ତିଞ୍ଜାଲି ରୁଣ୍ତା ଆ଼ହାମାଚମି, ପା଼ୱୁଲ ଅ଼ର ନେ଼ଚୁ ହାନାୟି ମାଚାକି ଏ଼ୱାସି ଲ଼କୁଣି ମାଦି ନେ଼କେରି ପାତେକା ନେହିଁ କାତା ୱେସିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ମା଼ମ୍ବୁ କୂଡ଼ା ଆ଼ହାମାନି ଲାକନି ପାରୁତି ଇଲୁତା ଏମ୍ବାଆଁ ହା଼ରେକା ଦୀୱଁୟାଁ ଡ଼ୀଞ୍ଜିମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଅ଼ଡ଼େ ଇୱୁତୁକ ଇନି ର଼ ଦାଂଗ୍‌ଣେଏସି କିଡ଼୍‌କି ଲାକ କୁଗାମାଚେସି, ଏ଼ୱାଣାକି ହା଼ରେକା ଇଦା ୱା଼ହିମାଚେ; ଇଞ୍ଜାଁ ପା଼ୱୁଲ କାତା ହା଼ରେକା ଲାମ୍ବା କିହିଁ ୱେସିମାଚାକି ଇୱୁତୁକ ତୀନି ପାରୁ ଗାଟି ଇଲୁ ଲାକଟି ଡ଼଼ଇ ରୀତେସି, ଏଚିବେ଼ଲା ଏ଼ୱାରି ଇୱୁତୁକଇଁ ନିକ୍‌ହେରି, ଏ଼ୱାସି ହା଼ହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ସାମା ପା଼ୱୁଲ ଡ଼଼ଇ ରେ଼ଚାୱା଼ହାନା ଏ଼ୱାଣି ମୁହେଁ ମାର୍‌ହାନା ଏ଼ୱାଣାଇଁ ପମାନା ଏଲେଇଚେସି, “ଆଜାଆଦୁ ଇଚିହିଁ ଈୱାଣି ତା଼ଣା ଜୀୱୁ ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ଡା଼ୟୁ ଲାକ ହାଜାନା ରୂଟି ବା଼ଟିକିହାଁ ତିଚେରି, ଇଞ୍ଜାଁ ଲା଼ଇ ୱେ଼ୟିନି ପାତେକା ହା଼ଡାକାତା ଆ଼ହାନା ପା଼ୱୁଲ ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଅ଼ଡ଼େ ଲ଼କୁ ଏ଼ ଦାଂଗ୍‌ଣା କକାଣାଇଁ ଜୀୱୁତଲେ ଇଜ ଅ଼ହିଁ ହାଚେରି ଇଞ୍ଜାଁ ଏ଼ୱାରି ହା଼ରେକା ବା଼ର୍ସୁ ବେଟାଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ସାମା ମା଼ମ୍ବୁ ନ଼କେଏ ଜା଼ଜାତା ହ଼ଚାନା ଆସସ୍‌ତା ହାଚମି, ଏମ୍ବାଟିଏ ମା଼ମ୍ବୁ ପା଼ୱୁଲଇଁ ଅ଼ହାଲି ଅଣ୍‌ପାମାଚମି, ଇଚିହିଁ ଏ଼ୱାସି ତା଼ନୁଏ ତା଼କିହିଁ ହାଜାଲି ତୀରି କିହାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ଏଚିବେ଼ଲା ଏ଼ୱାସି ଆସସ୍‌ତା ମାଙ୍ଗେ ବେଟା ଆୟାଲିଏ, ମା଼ମ୍ବୁ ଜା଼ଜାତା ଏ଼ୱାଣାଇଁ ମିତିଲିନିତା ତାଚିହିଁ ୱା଼ତମି, ");
INSERT INTO kxv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଅ଼ଡ଼େ ଏମ୍ବାଟି ହାଜାନା ଏ଼ ଅ଼ର ନେ଼ଚୁ କିଅସତା ଏଗାହାଚମି, ଅ଼ଡ଼େ ର଼ ଦିନାତି ଜେ଼ଚ ସାମସ୍‌ତା ଏଜାହାଁ, ତାନି ଅ଼ର ନେ଼ଚୁ ମିଲିତତା ଏଗାହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଇଚିହିଁ ପା଼ୱୁଲ ଆସିୟା ରା଼ଜିତା ହା଼ରେକା ଦିନା ଡ଼ୟାଆନା, ଈଦାଆଁତାକି ଏ଼ୱାସି ଏପିସିୟ ପିସାନା ହାଜାଲି ତୀରି କିହାମାଚେସି, ଆ଼ତିସାରେ ପେନ୍ତିକସ୍ତ ଦିନା ଜିରୁସାଲମତା ଏଗାହାଜାଲି ଦାଗା ଆ଼ହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ମିଲିତଟିଏ ପା଼ୱୁଲ ଏପିସିୟ କୁଲମିତି କାଜା ଲ଼କୁଣି କାବ୍ରୁ ପାଣ୍ତାନା ହା଼ଟିକିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ଏ଼ୱାରି ତାମି ତା଼ଣା ୱାୟାଲିଏ, ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଆସିୟାତା ନା଼ନୁ ଏଦାତି ଦିନାଟିଏ ମୀ ତଲେ ଏ଼ନିକିହିଁ ମାଚେଏଁ ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ");
INSERT INTO kxv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ପ୍ରବୁତି ହ଼ଲେଏଣା ଆ଼ହାନା ଜାହାରାଇଁ ଊଣା କିହାଁ ଅ଼ଡ଼େ କାଣ୍ତ୍ରୁ ବକ୍‌ହାଁ ନାଙ୍ଗେ ସା଼ସ୍ତି ୱା଼ତାଟି ନା଼ନୁ ପ୍ରବୁତି ସେ଼ବା କିତେଏଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଏଚରଜା଼ଣା ଜୀହୁଦି ଲ଼କୁତି ପାରୁ ପାରିମାଚାକି । ");
INSERT INTO kxv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ନା଼ନୁ ପାଙ୍ଗାୱେ଼ଙ୍ଗେ ଲ଼କୁତା଼ଣା ୱେହ୍‌ନାଟି ଅ଼ଡ଼େ ମିଙ୍ଗେତାକି ଇଲୁତା ୱେସ୍ତାନି ବେ଼ଲାତା ମୀ ନେହେଁ ଆ଼ନିଲେହେଁତି ଏ଼ନାଆଁ ଜିକେଏ ଡ଼ୁକ୍‌ହା ହିଲାଆତେଏଁ, ");
INSERT INTO kxv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ନ଼କିତା ଜାଗ୍ରାତା କିହିଁ ସା଼କି ହୀହାନା ୱେସାମାଚେଏଁ, ଏ଼ୱାରି ପା଼ପୁଟି ଏଟ୍‌କା ଆ଼ହାନା ମାହାପୂରୁ ୱାକି ମ଼ନ ୱେଟ୍‌ହା କଡାନା ମା଼ ପ୍ରବୁ ଜୀସୁଇଁ ନାମିନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ନୀଏଁ ମେହ୍‌ଦୁ, ନା଼ନୁ ସୁଦୁଜୀୱୁଇଁ ମା଼ନୱି ଆ଼ହାନା ଜିରୁସାଲମତା ହାଜିମାଇଁ, ଏମ୍ବାଆଁ ନାଙ୍ଗେତାକି ଏ଼ନାଆଁ ଆ଼ନେ ନା଼ନୁ ପୁଞ୍ଜାହିଲଅଁ; ");
INSERT INTO kxv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ସୁଦୁଜୀୱୁ ନାଙ୍ଗେ ଜାଗ୍ରାତା କିହାଁ ସା଼କି ହୀହିମାଞ୍ଜାନେ, ଗା଼ଡ଼ାତାକି ଗା଼ଡ଼ା କାୟିଦି ଆ଼ହାନା କସ୍ତ ବେଟାଆ଼ଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ସାମା ନା଼ନୁ ଏ଼ନିକିଁ ନା଼ ତୀରିଆ଼ହାମାନି ଟା଼ୟୁ ପାତେକା ହଟାଲି ଆ଼ଡିଇଁ, ଅ଼ଡ଼େ ମାହାପୂରୁତି କାର୍ମାଟି ନେହିଁ କାବ୍ରୁତାକି ସା଼କି ହୀହାଲିତାକି ଜୀସୁ ତା଼ଣାଟିଏ ଏମିନି ସେ଼ବା କାମା ବେଟାଆ଼ହାମାଇଁ, ଏ଼ଦାଆଁ ଏ଼ନିକିଁ ରା଼ପ୍‌ହାଲି ଆ଼ଡିଇଁ, ଏ଼ଦାଆଁତାକି ନା଼ ଜୀୱୁତି କାଜାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପି ହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ଅ଼ଡ଼େ ନୀଏଁ ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ ମୀରୁ ଅ଼ଡ଼େ ନାଙ୍ଗେ ୱେଣ୍ଡେ ମେସ୍ତଅତେରି । ନା଼ନୁ ମୀ ବାରେ ତା଼ଣା ମାହାପୂରୁ ରା଼ଜିତି କାତା ରେ଼ଜିହିଁ ୱେସାମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ନୀଞ୍ଜୁତି ଈ ପାରୁତାକି ଆ଼ଟ୍‌ୱା ତଲେ ୱେସିମାଇଁ, ମୀ ବିତ୍ରାଟି ଆମ୍ବାଆସି ନା଼ସା ଆତିହିଁ ଏମ୍ବାତି ଦା଼ୟି ନା଼ନୁ ଆ଼ଏ ");
INSERT INTO kxv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଇଚିହିଁ ମାହାପୂରୁ ଅଣ୍‌ପିମାନାଣି ବାରେ ମିଙ୍ଗେ ୱେସାଲି ନା଼ନୁ ପିସା ହିଲଅଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ମୀରୁ ମିଙ୍ଗେ ଜାହାରା କାତା ଅ଼ଡ଼େ ଆମିନି କୁଲମିତି ମାହାପୂରୁ ତାନି ନେତେରି ତଲେ କଡାମାନେସି, ତାନି ଏ଼ କୁଲମିତି ପ଼ହି ପାଡିକିହାଲିତାକି ସୁଦୁଜୀୱୁ ବାରେ ମାନ୍ଦା ବିତ୍ରାଟି ଗୁମୁସ୍ତା କିହାଁ ମିଙ୍ଗ ଆ଼ଚାମାଞ୍ଜାନେସି, ଏ଼ୱାରାଇଁ ଜାଗ୍ରାତା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ନା଼ନୁ ହାଚି ଡା଼ୟୁ ଆଜିହ଼ପେତି ଗା଼ଡ଼୍‌ଦେ କ୍ଡାଃନିଁ ୱା଼ନୁ, ଅ଼ଡ଼େ ମେ଼ଣ୍ତାୟାଁ ମାନ୍ଦାତି ରା଼ଣାରାକା କିଆନା ପିହ୍‌ଉ, ");
INSERT INTO kxv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଦିନା ୱା଼ନେ, ଏଚିବେ଼ଲା ମୀ ଗଚିତି ଏଚେକା ସୀସୁୟାଁ ନିଙ୍ଗାନା ନାମୁ ଗାଟାରାଇଁ ମିଚି କାତା ୱେସାନା ଏଟ୍‌କା ଜିରୁତା ଅ଼ନେରି, ");
INSERT INTO kxv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଏଚିବେ଼ଲା ଜାଗ୍ରାତା ଡ଼ୟାଦୁ, ନା଼ନୁ ଲା଼ଆଁ ମାଦେନା କାଣ୍ତ୍ରୁ ୱା଼କ୍‌ହିହିଁ ତୀନି ବାର୍ସା ପାତେକା ବାରେତେରି ମିଙ୍ଗେ ଜା଼ପ୍‌ହା ମାଞ୍ଜାଇଁ, ଈ କାତା ଅଣ୍‌ପୁତା ଇଟାଦୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ନୀଏଁ ନା଼ନୁ ମିଙ୍ଗେ ମାହାପୂରୁ ଇଞ୍ଜାଁ ତାନି କାର୍ମାମେହ୍‌ନି ବ଼ଲୁ ନ଼କିତା ହେର୍‌ପିମାଞ୍ଜାଇଁ, ଈ କାର୍ମାତି କାତା ମିଙ୍ଗେ ବା଼ଡ଼୍‌ୟୁ ତଲେ ପାଡିକିହାଲିତାକି ଅ଼ଡ଼େ ସୁଦୁ ଆ଼ହାମାନି ବାରେ ଲ଼କୁ ବିତ୍ରା ଅଦିକାରା ହୀହାଲି ଆ଼ଡାନେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ନା଼ନୁ ଆମ୍ବାଆରି ବାଂଗାରା, ୱେଣ୍ତି କି ହିମ୍ବରିକା ଜୂପ୍‌କା ଆ଼ହାହିଲାଆତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ମୀରୁ ପୁଞ୍ଜାମାଞ୍ଜେରି ଈ ନା଼ ରୀ କେସ୍କାତଲେ କାମା କିହାନା ନାଙ୍ଗେ ଅ଼ଡ଼େ ନା଼ ତ଼ଡ଼ୁ ଲ଼କୁତି ବାରେ ଲ଼ଡ଼ାମାନାଣି ବେଟାଆ଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ଇଲେକିହିଁ କସ୍ତ କିହାନା ଆ଼ଡାଆ ଗାଟାରି ସା଼ୟେମି କିନାୟି, “ଇଚିହିଁ ରୀହ୍‌ନି କିହାଁ ହୀନାୟି ହା଼ରେକା ନେହାୟି” ପ୍ରବୁ ଜୀସୁ ତା଼ନୁଏ ଈ କାତା ୱେସାମାଞ୍ଜାନେସି, ଈ କାତା ମୀରୁ ଅଣ୍‌ପିନାୟି ମାନେ, ଈ ବାରେ କାତାତଲେ ମିଙ୍ଗେ ପୁଣ୍‌ମ୍ବି କିହିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଈ ବାରେ କାତା ୱେସାଲି ରା଼ପ୍‌ହି ଡା଼ୟୁ ପା଼ୱୁଲ ମେଣ୍ତାକୁତାନା ବାରେଜା଼ଣା ତଲେ ପ୍ରା଼ତାନା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ଅ଼ଡ଼େ, ଏ଼ୱାରି ବାରେଜା଼ଣା ଡ଼ୀହି ଡ଼ୀହିଁ ପା଼ୱୁଲଇଁ ପମାହାଁ ନଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ଏ଼ୱାରି ଅ଼ଡ଼େ ତାନି ମୂମ୍ବୁ ୱେଣ୍ତେ ମେସାଲି ଆ଼ଡଅରି, ଏ଼ୱାସି ୱେସାମାଚି କାତାତାକି ହା଼ରେକା ଦୁକୁ କିତେରି, ଡା଼ୟୁ ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ଏ଼ୟୁ ଜା଼ଜା ପାତେକା ଇଟି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ଏ଼ୱାରି ତା଼ଣାଟି ହେଲ ବେଟାଆ଼ହାନା ମା଼ମ୍ବୁ ଏ଼ୟୁ ଜା଼ଜାତା ହ଼ଚାହାଁ ସଲ୍‌କେ ଜିରୁଟି କସ୍‌ତା ୱା଼ତମି, ତାନି ଅ଼ର ନେ଼ଚୁ ରଦାତା, ଇଞ୍ଜାଁ ଏମ୍ବାଟିଏ ପାତାରାତା ୱା଼ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ଏମ୍ବାଟିଏ ପୟିନିକିୟା ହାନି ଏ଼ୟୁ ଜା଼ଜା ବେଟାଆ଼ହାନା ଏମ୍ବାଆଁ ହ଼ଚାହାଁ ହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ଡା଼ୟୁ କୁପ୍ର ତ଼ଞ୍ଜା ଆ଼ହାଲିଏ ତାନି ଟେ଼ବ୍ରିୱାକି ପିସାନା ମା଼ମ୍ବୁ ସିରିୟାତା ହାଜାନା ସ଼ରତା ଏଗାତମି, ମା଼ମ୍ବୁ ଟାୟର୍‌ତା ଜା଼ଜାଟି ରେ଼ତମି, ଇଚିହିଁ ଏମ୍ବାଆଁ ଜା଼ଜାତି ଆ଼ସ୍ତି ରେ଼ପ୍‌ନାୟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ଏମ୍ବାଆଁ ନାମିତି ସୀସୁୟାଁଣି ପାରାନା ଏ଼ୱାରାଇଁ ବେଟାଆ଼ହାନା ଏମ୍ବାଆଁ ସା଼ତା ଦିନା ଡ଼ୟିତମି; ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଏ଼ନିକିଁ ଜିରୁସାଲମତା ହାଲଅସି ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ସୁଦୁଜୀୱୁ ତଲେ ବାତିମା଼ଲିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ମା଼ମ୍ବୁ ସା଼ତା ଦିନା ଡ଼ୟିତି ଡା଼ୟୁ, ଏ଼ୱାରାଇଁ ପିସାନା ଜାହାରା ଜିରୁତା ହାଚମି, ଅ଼ଡ଼େ ମାଙ୍ଗେ ହେଲ ହିୟାଲି ଏ଼ୱାରି ବାରେଜା଼ଣା ଇୟାସିକା କକାରି ପ଼ଦାୟାଁ ତଲେ ଗା଼ଡ଼ାତି ପାଙ୍ଗାତା ମାନି ସାମ୍‌ଦୁରି ଗାଟୁ ପାତେକା ଇଟି ୱା଼ତେରି, ଏମ୍ବାଆଁ ମେଣ୍ତାକୁତାନା ମା଼ମ୍ବୁ ବାରେତମି ପ୍ରା଼ତାନା କିତମି, ");
INSERT INTO kxv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ଡା଼ୟୁ ମା଼ମ୍ବୁ ବାରେଜା଼ଣାତି ହେଲ ହୀହାନା; ଜା଼ଜାତା ହ଼ତମି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ତାମି ଇଜ ୱେଣ୍ତା ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ମା଼ମ୍ବୁ ସ଼ର ଗା଼ଡ଼ାଟି ପତଲମାୟିତା ଏଗାହାଚମି, ଇଞ୍ଜାଁ ଏମ୍ବାଆଁ ତାୟିୟାଁଣି ଜହରା କିହାନା ଏମ୍ବାଆଁ ର଼ ଦିନା ଏ଼ୱାରିତଲେ ଡ଼ୟିତମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ଅ଼ଡ଼େ ଅ଼ର ନେ଼ଚୁ ହାଜାନା କାୟିସରିୟାତା ଏଗାହାଚମି, ଏମ୍ବାଆଁ ମା଼ମ୍ବୁ ନେହିଁ ବ଼ଲୁ ୱେ଼କ୍‌ନି ପିଲିପ ଇଜ ହାଜାନା ଡ଼ୟିତମି, ଜିରୁସାଲମତା ସେ଼ବା କାମା କିହାଲି ଆ଼ଚାମାନି ସା଼ତା ଜା଼ଣା ବିତ୍ରାଟି ଏ଼ୱାସି ରଅସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ଏ଼ୱାଣାକି ସା଼ରି ଜା଼ଣା ଡ଼ାଆ ମା଼ସ୍‌କା ମାଚୁ, ଏ଼ୱି ବାରେ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାଇ ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ଏମ୍ବାଆଁ ହା଼ରେକା ଦିନା ଡ଼ୟିତି ଡା଼ୟୁ ଆଗାବ ଦ଼ରୁଗାଟି ର଼ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାସି ଜୀହୁଦା ଦେ଼ସାଟି ୱା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ଏ଼ୱାସି ମା଼ ତା଼ଣା ୱା଼ହାନା ପା଼ୱୁଲତି ଜାଟି ଡ଼଼ରି ଅ଼ହାନା ତାନି କେସ୍କା କଡାଣା ଦସା କଡାନା ଏଲେଇଚେସି, “ସୁଦୁଜୀୱୁ ଏଲେଇଞ୍ଜି ୱେସିମାଞ୍ଜାନେ, ଈଦାଆଁ ଦସା କଡିନି ଜାଟି ଡ଼଼ରି ଗାଟାଣାଇଁ ଜିରୁସାଲମତି ଜୀହୁଦି ଲ଼କୁ ଇଲେକିଁ ଦସାନା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତି କେୟୁତା ହେର୍‌ପିନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଈ ବାରେ କାତା ୱେଞ୍ଜାନା ଜିରୁସାଲମତା ହାଲାଆନି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ଅ଼ଡ଼େ ଏମ୍ବାତି ଲ଼କୁ ବାତିମା଼ଲିତମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ସାମା ପା଼ୱୁଲ ଏଲେଇଚେସି, “ମୀରୁ ଡ଼ୀହି ଡ଼ୀହିଁ ଏ଼ନାଆଁତାକି ନା଼ ହିୟାଁତି କା଼ଡି କିହିମାଞ୍ଜେରି, ଏ଼ନିଇଚିହିଁ ନା଼ନୁ ପ୍ରବୁ ଜୀସୁ ତାକି ଜିରୁସାଲମତା ଦସ୍‌ପି ଆ଼ହାଲି ଆ଼ଏ ସାମା ହା଼ହାଲି ଜିକେଏ ଅଣ୍‌ପିମାଇଁ, ଇଞ୍ଜିଁ ଇଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ଏ଼ୱାସି ମା଼ କାତା ମା଼ନୱି ଆ଼ଆତାକି ମା଼ମ୍ବୁ ବାରେ ପାଲେଏ ଆ଼ତମି, ଇଞ୍ଜାଁ “ପ୍ରବୁତି କାତେଏ ଆ଼ପେ” ଇଞ୍ଜିଁ ଇଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଏମ୍ବାଆଁ ଏଚରଦିନା ମାଚି ଡା଼ୟୁ ମା଼ମ୍ବୁ ମା଼ ଆ଼ସ୍ତି ଆସାନା ଜିରୁସାଲମତା ହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ଅ଼ଡ଼େ କୁପ୍ରତି ମନାସନ ଦ଼ରୁଗାଟି ର଼ ନାମୁଗାଟାସି ଅ଼ଡ଼େ କାୟିସରିୟାଟି ଏଚରଜା଼ଣା ସୀସୁୟାଁ ମା଼ ତଲେ ହାଚେରି; ମନାସନ ଇଜ ମା଼ମ୍ବୁ ଡ଼ୟିନାୟି ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ମା଼ମ୍ବୁ ଜିରୁସାଲମତା ଏଗାହାଜାଲିଏ ନାମିତି ତାୟିୟାଁ ମାଙ୍ଗେ ରା଼ହାଁଟି ହା଼ଟା ଅୟାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ଏ଼ ଅ଼ର ନେ଼ଚୁ ପା଼ୱୁଲ ମା଼ ତଲେ ଜାକୁବ ଇଜ ହାଚେସି; ଅ଼ଡ଼େ ବାରେ ପ୍ରାଚିନାଙ୍ଗା ଏମ୍ବାଆଁ କୂଡ଼ା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ଜହରା କିତି ଡା଼ୟୁ, ମାହାପୂରୁ ତାନି ସେ଼ବା କାମାତା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ଏ଼ନି ଏ଼ନି କାମା କିହାମାନେସି ଏ଼ ବାରେ ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ଏ଼ୱାରି ଏ଼ଦାଆଁ ୱେଞ୍ଜାନା ମାହାପୂରୁତି ଜହରା କିତେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେରି, “ଏ଼ ତାୟି, ପା଼ୱୁଲ ନୀଏଁ ମେସିମାଞ୍ଜି ଜୀହୁଦିୟାଁ ବିତ୍ରାଟି ମା଼ଣା ମା଼ଣା ଲ଼କୁ ନାମିମାନେରି, ଏ଼ୱାରି ବାରେଜା଼ଣା ମେ଼ରାତି ମା଼ନୱି ଆ଼ହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଏ଼ୱାରି କାବ୍ରୁ ବେଟାଆ଼ହା ମାନେରି, ନୀନୁ ଏଟ୍‌କା କୂଡ଼ାତାରି ତା଼ଣା ବାସା ଆ଼ହାମାନି ବାରେ ଜୀହୁଦି ଲ଼କୁଣି ମ଼ସାତି ମେ଼ରା ପିସାଲି, ଏ଼ୱାରି କକାରି ତ଼ଲୁ ଦା଼ଦୁ, ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁତି ପା଼ଣାପା଼ଟୁ ମା଼ନୱି ଆ଼ଆଦୁ ଇଞ୍ଜିଁ ଜା଼ପ୍‌ହିମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ନୀନୁ ଇମ୍ବାଆଁ ୱା଼ହାମାନି କାବ୍ରୁ ସାତେଏ ଏ଼ୱାରି ୱେନେରି, ଆତିହିଁ ଏ଼ନି କିନାୟି ? ");
INSERT INTO kxv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ଏ଼ଦାଆଁତାକି ମା଼ମ୍ବୁ ନିଙ୍ଗେ ଏ଼ନାଆଁ ୱେସିମାଞ୍ଜାନମି ଏ଼ଦାଆଁ କିମୁ, ମା଼ ତା଼ଣା ସା଼ରି ଜା଼ଣା ମାନେରି, ଏ଼ୱାରି ପାର୍‌ମାଣା କିହାମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ଏ଼ୱାରିତଲେ ହାଲାମୁ ଇଞ୍ଜାଁ ଏ଼ୱାରିତଲେ ଆଣ୍ତାନା ନିଙ୍ଗେ ଅଟ୍‌ହା କଡାମୁ, ଇଞ୍ଜାଁ ଏ଼ୱାରି ତା଼ର୍କା ହିଣ୍‌ନି କାର୍ଚୁ ହୀମୁ, ଆ଼ତିହିଁ ବାରେ ଲ଼କୁ ମେସାନା ଏ଼ୱାରି ନୀ କ଼ପାଟି ୱେସାମାନି କାତା ଏ଼ନି ସାତା ହିଲେଏ, ସାମା ନୀନୁ ଜିକେଏ ମ଼ସା ମେ଼ରା ମା଼ନୱି ଆ଼ହିମାଞ୍ଜି ଇଞ୍ଜିଁ ପୁଞ୍ଜାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ସାମା ଆମିନି ଏଟ୍‌କା କୂଡ଼ାତାରି ନାମାମାନେରି, ଏ଼ୱାରି ପେ଼ଣ୍‌କା ବମାୟାଁକି ପୂଜା ହୀହାମାନି ବ଼ଗୁ, ନେତେରି ଇଞ୍ଜାଁ ହେର୍‌କି ତିଣ୍‌ଚାନା ପା଼ୟିତି ଜ଼ନ୍ତତି ଊଙ୍ଗା ତିନାଆଦୁ, ଇଞ୍ଜାଁ ଦା଼ରିକାମାଟି ଏଟ୍‌କା ଆ଼ଦୁ, ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ତୀରିକିହାଁ ଏ଼ୱାରାକି ର଼ ଆ଼କୁ ରା଼ଚାମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ଅ଼ର ଦିନା ଏ଼ୱାରିତଲେ ହାଜାନା ଅଟ୍‌ହା କଡିନି ମେ଼ରା ମା଼ନୱି ଆ଼ତେସି, ଇଞ୍ଜାଁ ମାହାପୂରୁ ଇଲୁତା ହାଜାନା ତାମି ଅଟ୍‌ହା କଡିନି ଦିନାୟାଁ ଏଚେଲା ରା଼ନେ ଅ଼ଡ଼େ ବାରେଜା଼ଣା ତାକି ଏ଼ନି ଏ଼ନି ପୂଜା କିନାୟିମାନେ ଏ଼ ବାରେ ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ଏ଼ ସା଼ତା ଦିନା ପୂରା ଆ଼ହିମାଚାଟି ଆସିୟା ଦେ଼ସାଟି ଏଚେକା ଜୀହୁଦି ଲ଼କୁ ମାହାପୂରୁ ଇଲୁତା ପା଼ୱୁଲଇଁ ମେସାନା ଏ଼ୱାରି ଏମ୍ବାଆଁ କୂଡ଼ା ଆ଼ହାମାନି ମାନ୍ଦା ଲ଼କୁଣି ମା଼ତୱି କିତେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ଆସାନା କା଼ଲୱି ଆ଼ହିଁ ଏଲେଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ଏ଼ ଇସ୍ରାୟେଲତି ଲ଼କୁ ସା଼ୟେମି କିୟାଦୁ; ଈୱାସି ସା଼ରିୱାକି ହାଜାନା ଇସ୍ରାୟେଲ ଲ଼କୁତି କ଼ପାଟି ଅ଼ଡ଼େ ମ଼ସା ହୀତି ମେ଼ରା ଇଞ୍ଜାଁ ଈ ମାହାପୂରୁ ଇଲୁ କ଼ପାଟି ଜା଼ପ୍‌ହିମାନେସି । ଇଞ୍ଜାଁ ନୀଏଁ ଏଚରଜା଼ଣା ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁଣି ମାହାପୂରୁ ଇଲୁତା ତାଚାନା ସୁଦୁ ଟା଼ୟୁତି ପ଼ଲ୍‌ଆ କିହିମାନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ଇଚିହିଁ ଏ଼ୱାରି ଗା଼ଡ଼ାତା ଏପିସିୟତି ତ୍ରପିମଇଁ ପା଼ୱୁଲ ତଲେ ମେସାମାଚେରି, ଅ଼ଡ଼େ ଏ଼ୱାଣାଇଁ ମାହାପୂରୁ ଇଲୁତା ତାଚାମାନେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଏମ୍ବାଟିଏ ବାରେ ଗା଼ଡ଼ା କିଲିବିଲି ଆ଼ତେ, ଇଞ୍ଜାଁ ଲ଼କୁ ମାନ୍ଦା ମାନ୍ଦା ଆ଼ହିଁ ହଟାନା ପା଼ୱୁଲଇଁ ଆସାନା ମାହାପୂରୁ ଇଲୁଟି ରେଜା ତାତେରି; ଇଞ୍ଜାଁ ଏ଼ ଦେବୁଣିଏ ମାହାପୂରୁ ଇଲୁତି ଦା଼ରାୟାଁ ସୁଣ୍ତିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ଅ଼ଡ଼େ ଏ଼ୱାରି ପା଼ୱୁଲଇଁ ପା଼ୟାଲି ଅଣ୍‌ପିତେରି, ଇଞ୍ଜାଁ ଜିରୁସାଲମତା କାଜା ଗଡ଼୍‌ହା ଆ଼ହାମାନେ ଇଞ୍ଜିଁ ରିଜାରି କ଼ସ୍‌କାତି କାଜାଣି ତା଼ଣା କାବ୍ରୁ ହୀତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଦେବୁଣିଏ ରିଜାରି କ଼ସ୍‌କା ଇଞ୍ଜାଁ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାରାଇଁ ଆସାନା ଏ଼ୱାରିତା଼ଣା ଦାବ୍‌ଡ଼ି ହାଚେସି, ଲ଼କୁ ରିଜାରି କ଼ସ୍‌କା ଅ଼ଡ଼େ କ଼ସ୍‌କା ମୁହେଁ କାଜାରାଇଁ ମେସାନା ଏ଼ୱାରି ପା଼ୱୁଲଇଁ ୱେ଼ଚାଲି ପିସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ଏମ୍ବାଟିଏ କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ପା଼ୱୁଲ ଡାଗେ ହାଜାନା ଏ଼ୱାଣାଇଁ ଆସାନା ରୀ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସାଲି ହୁକୁମି ହୀତେସି, ଅ଼ଡ଼େ “ଈୱାସି ଆମ୍ବାଆସି ? ଏ଼ନାଆଁ କିହାମାନେସି ଇଞ୍ଜିଁ ୱେଚେସି ?” ");
INSERT INTO kxv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ଏଚେଟିଏ ଲ଼କୁ ବାରେ ଆମ୍ବାଆରି ଈ କାତା ଆମ୍ବାଆରି ଏ଼ କାତା ଇଞ୍ଜିଁ କା଼ଲୱି ଆ଼ତେରି, ଇଞ୍ଜାଁ ଏ଼ନାଆଁ ଆ଼ହାମାନେ ଇଞ୍ଜିଁ ତୀର୍‌ପୁତି କାତା ପୁନାଆନା ପା଼ୱୁଲଇଁ କ଼ଟା ଇଲୁତା ଅ଼ହାଲି କ଼ସ୍‌କାଣି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ଏଚିବେ଼ଲା ଏ଼ୱାସି ପା଼ୱୁଜି ପିଣ୍ତାଣା ଏଗାହାଜାଲିଏ, ଲ଼କୁତି ମାନ୍ଦା କାର୍‌ବିଟି କା଼ଲୱି ଆୟାଲିଏ କ଼ସ୍‌କା ପା଼ୱୁଲଇଁ ଇଲୁ ବିତ୍ରା ଡେ଼କା ଅ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ଇଚିହିଁ ମାନ୍ଦା ମାନ୍ଦା ଲ଼କୁ ଜେ଼ଚ ୱା଼ହିହିଁ “ଏ଼ୱାଣାଇଁ ପା଼ୟାଦୁ” ଇଞ୍ଜିଁ କା଼ଲୱି ଆ଼ହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ଏ଼ୱାରି ପା଼ୱୁଲଇଁ କ଼ଟା ଇଲୁ ବିତ୍ରା ଅ଼ହିମାଚାଟି ଏ଼ୱାସି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ନିଙ୍ଗେ ର଼ କାତା ୱେସାଲି ଆ଼ଡାଇଁ କି ?” ଏମ୍ବାଟିଏ କାଜାସି ଏଲେଇଚେସି “ନୀନୁ ଗ୍ରିକ୍‌ ହା଼ଡା ପୁଞ୍ଜି କି ? ");
INSERT INTO kxv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ଆତିହିଁ ଈଦାଆଁ ନ଼କେଏ ଏମିନି ମିସରତି ଲ଼କୁ ଗଡ଼୍‌ହା ହ଼ପ୍‌ହାନା ସା଼ରି ମା଼ଣା କାଗଂରାଣି ଲ଼କୁ ହିଲାଆ ଟା଼ୟୁତା ଅ଼ହାମାଚାତି ନୀନୁ ଏ଼ୱାତି ଆ଼ଏ କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ଏମ୍ବାଟିଏ ପା଼ୱୁଲ ଏଲେଇଚେସି “ନା଼ନୁତ ର଼ ଜୀହୁଦି କିଲିକିୟା ଦେ଼ସାତି ତାର୍ସ ଇଞ୍ଜିହିଁ ୱେ଼ଙ୍ଗିତି ଗା଼ଡ଼ାତା ଜାର୍ନା ଆ଼ତାତେଏଁ; ଈ ଲ଼କୁଣି କାତା ୱେସାଲି ନାଙ୍ଗେ ହେଲ ହିୟାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ଏ଼ କାଜାସି ହେଲ ହିୟାଲିଏ, ପା଼ୱୁଲ ପା଼ୱୁଜିକାଣା ନିଚାନା ଲ଼କୁଣି କେୟୁତଲେ ସାପି କିତେସି; ଇଞ୍ଜାଁ ବାରେଜା଼ଣା ସାପି ଆ଼ହାଲିଏ ଏ଼ୱାସି ଏବ୍ରି ହା଼ଡାତଲେ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ଏ଼ ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଞ୍ଜିୟାଁତେରି, ନା଼ନୁ ନୀଏଁ ମୀ ନ଼କିତା ନା଼ ୱାକିଟି କାତା ୱେସିମାଞ୍ଜାଇଁ, ୱେଞ୍ଜାଦୁ !” ");
INSERT INTO kxv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ପା଼ୱୁଲ ଏ଼ୱାରି ନ଼କିତା ଏବ୍ରି ହା଼ଡାତଲେ ଜ଼ଲିମାନାଣି ୱେଞ୍ଜାନା; ଏ଼ୱାରି ହା଼ଡା ଆ଼ଆନା ପାଲେଏ ଆ଼ତେରି, ଅ଼ଡ଼େ ପା଼ୱୁଲ ଜ଼ଲାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ଏମ୍ବାଟିଏ ଏ଼ୱାସି ଏଲେଇଚେସି, “ନା଼ନୁ ର଼ ଜୀହୁଦି ଲ଼କୁତେଏଁ, କିଲିକିୟାତି ତାର୍ସତା ନା଼ ଜାର୍ନା, ସାମା ନା଼ନୁ ଈ ଜିରୁସାଲମ ଗା଼ଡ଼ାତା ପ଼ହିପାଡି ଆ଼ହାମାଇଁ, ଗମଲିୟେଲ ତା଼ଣା କୁଗାନା ଜା଼ପାମାଇଁ, ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ମେ଼ରାତି ନେହିଁକିଁ ଜା଼ପାମାଇଁ; ମୀରୁ ଏ଼ନିକିଁ ମାହାପୂରୁତି ସେ଼ବା କିହିମାଞ୍ଜେରି ନା଼ନୁ ଜିକେଏ ଏଲେକିହିଁ ମା଼ନୱି ଆ଼ନାତେଏଁ ମାଚେଏଁ; ");
INSERT INTO kxv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ନା଼ନୁ ଈ ଜିରୁତା ତା଼କିମାନି ଇୟାସିକା ଆ଼ବାୟାଁଣି ହା଼ନି ପାତେକା ସା଼ସ୍ତି କିହିମାଚେଏଁ, ଅ଼ଡ଼େ ଦସ୍‌ପାନା କା଼ୟିଦି ଇଲ୍‌କାଣା ହେର୍‌ପିମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ନା଼ ଈ କାତା ସାତା, କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ କାଜା ବେ଼ରଣି ମାଣ୍ତାତାରି ନା଼ ସା଼କି; ନା଼ନୁ ଏ଼ୱାରି ତା଼ଣାଟି ତାୟିୟାଁକି ଆ଼କୁ ରୀସାନା ଲ଼କୁଣି ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପାନା ଜିରୁସାଲମତା ତାଚାଲି ତାକି ନା଼ନୁ ଦମେସକତା ମାନି ଜୀହୁଦି ଲ଼କୁତା଼ଣା ହାଜାମାଚେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ନା଼ନୁ ଦମେସକ ଡାଗେ ଏଜିମାଚାଟି ମାଦେନା ବେ଼ଲାତା ଦେବୁଣିଏ ନା଼ ସା଼ରିୱାକି ହା଼ଗୁଲାକଟି ର଼ ତାର୍ହାଣା ଉଜେଡ଼ି ଡ଼ୀଞ୍ଜିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ଏମ୍ବାଟିଏ ନା଼ନୁ ବୂମିତା ତର୍‌ଗିତେଏଁ, ଇଞ୍ଜାଁ ନାଙ୍ଗେ ତାକି ୱେସିମାଚି ଈ ହା଼ଡା ୱେଚେଏଁ, ‘ସା଼ୱୁଲ, ସା଼ୱୁଲ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ସା଼ସ୍ତି ହୀହିମାଞ୍ଜାଦି ?’ ");
INSERT INTO kxv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ନା଼ନୁ ଏଲେଇଚେଏଁ, ‘ପ୍ରବୁ ନୀନୁ ଆମ୍ବାଆତି ?’ ଏମ୍ବାଟିଏ ଏ଼ୱାସି ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାତେସି, ‘ନୀନୁ ଆମ୍ବାଆରାଇଁ ସା଼ସ୍ତି ହୀହିମାଞ୍ଜି ନା଼ଜରିତତି ଜୀସୁତେଏଁ ନା଼ନୁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ନା଼ ତଲେ ମାଚି ଲ଼କୁ ଏ଼ ଉଜେଡ଼ି ମେସ୍ତେରି ସାତା, ସାମା ନାଙ୍ଗେ ୱେସ୍ତାତି ହା଼ଡା ୱେନାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ଏଚେଟିଏ ନା଼ନୁ ଏଲେଇଚେଏଁ, ‘ପ୍ରବୁ ନା଼ନୁ ଏ଼ନାଆଁ କିଇଁ ?’ ଏଚେଟିଏ ପ୍ରବୁ ନାଙ୍ଗେ ୱେସ୍ତାତେସି, ‘ନିଙ୍ଗାନା ଦମେସକତା ହାଲାମୁ, ଅ଼ଡ଼େ ନିଙ୍ଗେ ଏ଼ନାଆଁ କିହାଲି ଆ଼ନେ ଏ଼ଦାଆଁ ଏମ୍ବାଆଁ ୱେସ୍ତାଇଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ଏ଼ ଉଜେଡ଼ି ମିଣ୍‌ସି ମାଚାକି ନା଼ନୁ କା଼ଣା ଆ଼ହାହାଚେଏ, ଇଞ୍ଜାଁ ନା଼ ତଲେ ୱା଼ହିମାଚାରି ନାଙ୍ଗେ କେୟୁ ଆସାନା ଦମେସକତା ଅୟାତେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ଏ଼ ଗା଼ଡ଼ାତା ହନନିୟ ଇଞ୍ଜିହିଁ ର଼ ଦାର୍ମୁଗାଟାସି ମାଚେସି, ଏ଼ୱାସି ମା଼ ମେ଼ରାତି ମା଼ନୱି ଆ଼ନାସି, ଇଞ୍ଜାଁ ଦମେସକତି ଜୀହୁଦି ଲ଼କୁତା଼ଣା ମା଼ନି ଗାଟାସି ଅ଼ଡ଼େ ୱେ଼ଙ୍ଗିତାସି ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ଏ଼ୱାସି ନା଼ ତା଼ଣା ୱା଼ହାନା ଦାରିତା ନିଚାନା ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାତେସି, ‘ଏ଼ ସା଼ୱୁଲ ତାୟି ମେହ୍‌ମୁ’ ଏ଼ ଦେବୁଣିଏ ନା଼ କାଣ୍‌କା ଦେପିଆ଼ତୁ ଇଞ୍ଜାଁ ନା଼ନୁ ଏ଼ୱାଣାଇଁ ମେସାଲି ଆ଼ଡିତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ଏ଼ୱାସି ଏଲେଇଞ୍ଜାତେସି, ‘ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ମାହାପୂରୁ ତାନି କାତା ପୁଞ୍ଜାଲି ଅ଼ଡ଼େ ଏ଼ ତୀରି ଗାଟାଣାଇଁ ମେସାଲି, ଅ଼ଡ଼େ ତାନି ଗୂତିଟି ହ଼ଚିମାନି ହା଼ଡା ୱେଞ୍ଜାଲି ଆ଼ଚାମାଞ୍ଜାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ଇଚିହିଁ ନୀନୁ ଏ଼ନାଆଁ ମେସାମାଞ୍ଜି ଇଞ୍ଜାଁ ୱେଞ୍ଜାମାଞ୍ଜି, ଏ଼ ବାରେତାକି ବାରେ ଲ଼କୁତା଼ଣା ୱେସାଲି ନୀନୁ ସା଼କି ଆ଼ଦି । ");
INSERT INTO kxv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଅ଼ଡ଼େ ନୀଏଁ ଏ଼ନାଆଁତାକି ୱେ଼ଡ଼ା କିହିମାଞ୍ଜି, ନିଙ୍ଗାମୁ ବାପ୍ତିସ୍ମ ଆ଼ହାନା ତାନି ତା଼ଣା ପ୍ରା଼ତାନା କିହାନା ନୀ ପା଼ପୁ ବାରେ ନର୍‌ୱି କିହାକଡାମୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ଏମ୍ବାଟିଏ ନା଼ନୁ ଜିରୁସାଲମତା ୱେଣ୍ତା ୱା଼ହାନା ମାହାପୂରୁ ଇଲୁତା ପ୍ରା଼ତାନା କିହିମାଚାଟି, ସେୟାଁଣା ହାପାନାତା ମେସ୍ତେଏଁ, ");
INSERT INTO kxv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ନା଼ନୁ ସେୟାଁଣା ହାପାନାତା ପ୍ରବୁଇଁ ମେସ୍ତେଏଁ, ଏ଼ୱାସି ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାତେସି, ‘ତବେ ଜିରୁସାଲମ ପିହ୍‌ମୁ, ଇଚିହିଁ ଇମ୍ବାତି ଲ଼କୁ ନା଼ ସା଼କି ହୀନାଟି ନୀ କାତା ଆହ୍‌ଅରି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ଏମ୍ବାଟିଏ ନା଼ନୁ ଏଲେଇଚେଏଁ ‘ପ୍ରବୁ ନା଼ନୁ ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ହାଜାନା ନିଙ୍ଗେ ନାମାନାରାଇଁ ୱେ଼ଚାନା କାୟିଦି ଇଲୁତା ସୁଣ୍ତିମାଚାଣି ଏ଼ୱାରି ନେହିଁକିଁ ପୁଞ୍ଜାମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ଅ଼ଡ଼େ ଏଚିବେ଼ଲା ନୀ ସା଼କି ସ୍ତିପାନଇଁ ପା଼ୟିତେରି, ନା଼ନୁଏ ଏମ୍ବାଆଁ ମାଚେଏଁ; ଇଞ୍ଜାଁ ବେଲେଏ ହା଼ପେସି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେଏଁ, ଅ଼ଡ଼େ ପା଼ୟିମାଚାରି ହିମ୍ବରିକା କା଼ଚିମାଚେଏଁ ।’ ");
INSERT INTO kxv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ସାମା ପ୍ରବୁ ନାଙ୍ଗେ ଏଲେଇଞ୍ଜାତେସି, ‘ହାଲାମୁ ଇଚିହିଁ ନା଼ନୁ ନିଙ୍ଗେ ହେକ ଦେ଼ସାତି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ପାଣ୍ତାଇଁ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ପା଼ୱୁଲ ଏଲେଇଞ୍ଜି ୱେହ୍‌ନି ପାତେକା ଲ଼କୁ ୱେଞ୍ଜିମାଚେରି, ସାମା ଏ଼ ଦେବୁଣିଏ ଏ଼ୱାରି କାଜା ଗିୟାଁତଲେ କା଼ଲୱି ଆ଼ହାନା ଏଲେଇଚେରି, “ଏ଼ୱାଣାଇଁ ପାଙ୍ଗାତା ତାଚାହାଁ ପା଼ୟାନା ଦାର୍‌ତିଟି ମ୍ଣେକ୍‌ହା ତୁହ୍‌ଦୁ, ଏ଼ୱାସି ନୀଡାଲି ପା଼ଡ଼ାଆ଼ଅସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ଅ଼ଡ଼େ ଏଚିବେ଼ଲା ଏ଼ୱାରି କିଲଡ଼ି କିହିଁ ତାମି ହିମ୍ବରିକା କୁତିହିଁ ଲାକୱାକି ଦୂଡ଼ି ଡ଼ାଞ୍ଜିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ଏଚିବେ଼ଲା ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ପା଼ୱୁଲଇଁ କ଼ଟା ଇଲୁ ବିତ୍ରା ଅ଼ହାଲି ହୁକୁମି ହୀତେସି, ଅ଼ଡ଼େ ଜୀହୁଦି ଲ଼କୁ ଏ଼ନାଆଁତାକି ଏ଼ୱାଣି କ଼ପାଟି ଗଡ଼୍‌ହା କିହିମାନେରି, ଏ଼ଦାଆଁ ପୁଞ୍ଜାଲି ପା଼ୱୁଲଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ଚାନା ୱେଞ୍ଜୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ସାମା ଏ଼ୱାରି ଏ଼ୱାଣାଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ଚାଲି ଡ଼଼ରିତଲେ ଦସାଲିଏ, ପା଼ୱୁଲ ଦାରିତା ମାଚି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ଏଲେଇଚେସି, “ଏମିନି ଦ଼ହତା ନୀହାଁୟି କିୱି ଆ଼ହାହିଲାଆ ର଼ ର଼ମ୍‌ ଦେ଼ସା ତା଼ଣାଇଁ ସା଼ଟ୍‌ଣି ତଲେ ୱେ଼ଚାଲି ଏ଼ନି ମେ଼ରା ମାନେ କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ଈଦାଆଁ ୱେଞ୍ଜାନା କ଼ହ୍‌ଏଁସି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣା ତା଼ଣା ହାଜାନା ଏଲେଇଚେସି, “ନୀନୁ ଏ଼ନାଆଁ କିହାଲି ହାଜିମାଞ୍ଜି, ଇଚିହିଁ ଈୱାସି ରମିୟ ଲ଼କୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ଏମ୍ବାଟିଏ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ୱା଼ହାନା ପା଼ୱୁଲଇଁ ୱେଚେସି, “ନୀନୁ ନାଙ୍ଗେ ୱେସ୍ତାମୁ ନୀନୁ ର଼ମ୍‌ ଦେ଼ସାତାତି କି ?” ପା଼ୱୁଲ ଏଲେଇଚେସି “ହାଅ ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ଏମ୍ବାଟିଏ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏଲେଇଚେସି, “ନା଼ନୁ ହା଼ରେକା ଟାକାୟାଁ ହୀହାନା ର଼ମ୍‌ ଦେ଼ସାତାତେଏଁ ଆ଼ହାମାଇଁ ।” ସାମା ପା଼ୱୁଲ ଏଲେଇଚେସି, “ନା଼ନୁତ ଜାର୍ନାଟିଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ଏମ୍ବାଟିଏ ଆମ୍ବାଆରି ପା଼ୱୁଲଇଁ ୱେଞ୍ଜାଲି ତିୟାରା ଆ଼ହାମାଚେରି, ଦେବୁଣିଏ ଗୁଚା ଆ଼ହାହାଚେରି, ଇଚିହିଁ ପା଼ୱୁଲ ର଼ମ୍‌ ଦେ଼ସାତାସି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏ଼ୱାଣାଇଁ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପି କିହାମାଚାକି ତା଼ନୁଏ ଆଜିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ଜୀହୁଦି ଲ଼କୁ ପା଼ୱୁଲ କ଼ପାଟି ଏ଼ନି ଦାୱା କିହାମାନେରି, ଏ଼ଦାଆଁ ସାତା ତଲେ ପୁଞ୍ଜାଲିତାକି ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ତାନି ଅ଼ର ନେ଼ଚୁ ପା଼ୱୁଲତି ହିକ୍‌ଣିୟାଁ ହୁକ୍‌ହାନା କାଜା ବେ଼ରଣିମାଣ୍ତାତି ବାରେଜା଼ଣାତି କୂଡ଼ିକିହାଲି ପୂଜେରାଙ୍ଗାଣି ହୁକୁମି ହୀତେସି । ଡା଼ୟୁ ପା଼ୱୁଲଇଁ ଏ଼ୱାରି ନ଼କିତା ନିପ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ପା଼ୱୁଲ ଜୀହୁଦି ଲ଼କୁତି କାଜା ବେ଼ରଣିମାଣ୍ତାତା କୁଗାମାନି ଲ଼କୁଣି ଆଟେ ସିନିକିହାନା ଏଲେଇଚେସି, “ଏ଼ ଇସ୍ରାୟେଲ ତାୟିୟାଁତେରି ନା଼ନୁ ନୀଞ୍ଜୁପାତେକା ମାହାପୂରୁ ନ଼କିତା ନେହିଁ ଅଣ୍‌ପୁ ତଲେ ନୀଡାମାଇଁ, ଏ଼ଦାଆଁତାକି ନା଼ ହିୟାଁ ହା଼ରେକା ଅଡିତାୟି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ଈ କାତା ୱେଞ୍ଜାନା କାଜା ପୂଜେରା ହାନାନ ପା଼ୱୁଲ ଦାରିତା ନିଚାମାନି ଲ଼କୁଇଁ ତାନି ଗୂତିତା ୱେ଼ଦୁ ଇଞ୍ଜିଁ ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ପା଼ୱୁଲ ଏ଼ୱାଣାଇଁ ଏଲେଇଚେସି, “ଏ଼ ହୁନୁ ଊସ୍‌ପିତି ଦବ୍‌ଲା କାତି ମାହାପୂରୁ ନିଙ୍ଗେ ୱେ଼ତାନେସି, ନୀନୁ ମ଼ସାତି ମେ଼ରା ଲେହେଁ ନାଙ୍ଗେ ନୀହାଁୟି କିହାଲି କୁଗାମାଚି ଜିକେଏ, ନୀନୁ ନାଙ୍ଗେ ୱେ଼ଚାଲି ହୁକୁମି ହୀହାନା ନୀନୁଏ ମ଼ସାତି ମେ଼ରା ଊରିମାଞ୍ଜି !” ");
INSERT INTO kxv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ଏଚେଟିଏ ଦାରିତା ନିଚାମାଚି ଲ଼କୁ ପା଼ୱୁଲଇଁ ଏଲେଇଚେରି, “ନୀନୁ ମାହାପୂରୁତି କାଜା ପୂଜେରାଇଁ ଲାଜା କିହିମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଏ଼ ଇସ୍ରାୟେଲ ତାୟିୟାଁତେରି ଏ଼ୱାଣାଇଁ ନା଼ନୁ କାଜା ପୂଜେରା ଇଞ୍ଜିଁ ପୁଞ୍ଜା ହିଲାଆତେଏଁ; ଇଚିହିଁ ଦାର୍ମୁପତିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, ‘ମୀରୁ ମୀ ସା଼ଲୱି କିନାରାଇଁ ବା଼କା ଇଟାଆଦୁ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ସାମା ପା଼ୱୁଲ ର଼ ବା଼ଗା ସାଦୁକିୟାଁ ଅ଼ଡ଼େ ର଼ ବା଼ଗା ପାରୁସିୟାଁ ମାନେରି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା, କାଜା ବେ଼ରଣିମାଣ୍ତାତା କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ଏ଼ ଇସ୍ରାୟେଲ ତାୟିୟାଁତେରି ନା଼ନୁ ର଼ ପାରୁସିତେଏଁ ଇଞ୍ଜାଁ ପାରୁସି ମୀର୍‌ଏଣାତେଏଁ; ଇଞ୍ଜାଁ ହା଼ତାରି ୱେଣ୍ତେ ନିଙ୍ଗିନେରି ଇଞ୍ଜିଁ ଆ଼ସା କିହିମାନାକି ମୀରୁ ନାଙ୍ଗେ ନୀହାଁୟି କିହିମାଞ୍ଜାଦେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ଏ଼ୱାସି ଈ କାତା ଏଲେଇଣ୍‌ମ୍ବନିଏ ପାରୁସି ଅ଼ଡ଼େ ସାଦୁକି ଲ଼କୁ ବିତ୍ରା ଗଡ଼୍‌ହା ହ଼ତେ, ଇଞ୍ଜାଁ କାଜା ବେ଼ରଣି ମାଣ୍ତାତାରି ଗଚି ଗଚି ଆ଼ହାଁ ରୀ ବା଼ଗା ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ଇଚିହିଁ ସାଦୁକିୟାଁ ୱେଣ୍ତେ ନିଙ୍ଗିନାୟି ହିଲେଏ, ଦୂତୁୟାଁ ଅ଼ଡ଼େ ଜୀୱୁୟାଁ ହିଲାଉ ଇନେରି, ସାମା ପାରୁସିୟାଁ ଏ଼ ବାରେତି ନାମିନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ଏମ୍ବାଟିଏ କାଜା ଗଡ଼୍‌ହା ଆ଼ତେ, ଅ଼ଡ଼େ ପାରୁସିୟାଁ ବିତ୍ରାଟି ଏଚରଜା଼ଣା ମେ଼ରାପୁନାରି ନିଙ୍ଗାନା ଏଲେଇଚେରି; “ମା଼ମ୍ବୁ ଈୱାଣି ତା଼ଣାଟି ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ଆତମି, ସାତେଏ ଏ଼ୱାଣି ତା଼ଣାଟି ର଼ ଜୀୱୁ ଆ଼ଆତିଁ ଲାକପୂରୁତି ଦୂତୁ କାତା ୱେସାମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ଇଲେଆ଼ହିଁ କାଜା ଗଡ଼୍‌ହା ଆ଼ହାଲିଏ, ପା଼ୱୁଲଇଁ ଏ଼ୱାରି କାଣ୍ତାମୁକା କିନେରି ଇଞ୍ଜିଁ ଆଜିତାକି ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ପା଼ୱୁଲଇଁ ଏ଼ୱାରି ତା଼ଣାଟି ଗେଲ୍‌ପାନା ବାଲ୍‌ମିଟି କ଼ଟା ଇଲୁ ବିତ୍ରା ଅ଼ହାଲି କ଼ସ୍‌କାଣି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ଏ଼ ନେ଼ଚୁ ଲା଼ଆଁୟାଁ ପ୍ରବୁ ପା଼ୱୁଲଇଁ ଏଲେଇଚେସି, “ଆଜାଆନି, ସା଼ସା ଆହ୍‌ମୁ ଇଚିହିଁ ନୀନୁ ଜିରୁସାଲମତା ଏ଼ନିକିଁ ନା଼ ସା଼କି ହୀତି, ର଼ମ୍‌ ଗା଼ଡ଼ାତା ଜିକେଏ ଏଲେକିହିଁ ନା଼ ସା଼କି ହୀନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଅ଼ର ଦିନା ଲା଼ଇ, ଜୀହୁଦିୟାଁ ଜାଟୁ ଆ଼ହାନା ପା଼ୱୁଲଇଁ ପା଼ୟାଆ ପାତେକା ଏ଼ନି ରା଼ନ୍ଦା କି ଏ଼ୟୁ ଡୀଗାଆପ ଇଞ୍ଜିଁ ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ପାର୍‌ମାଣା କିହାମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ଏଲେଇଞ୍ଜି ଅଣ୍‌ପି ମାଚାରି ରୀ କ଼ଡ଼ି ଜା଼ଣାଟିଏ ଆଗାଡ଼ା ମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ଏ଼ୱାରି କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ତା଼ଣା ୱା଼ହାଁ ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ପା଼ୱୁଲଇଁ ପା଼ୟାଲି ଆ଼ଡାଆ ପାତେକା ଏ଼ନାଆଁ ତିନଅମି କି ଡୀଗଅମି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ମାଙ୍ଗେତାକି ପାର୍‌ମାଣା କିହାମାନମି । ");
INSERT INTO kxv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ଏ଼ଦାଆଁତାକି କାଜା ବେ଼ରଣିମାଣ୍ତାତି କାଜାରି ହାଜାନା, ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ନା଼ଡ଼ି କିହିଁ ଏଲେଇଞ୍ଜୁ, ମା଼ମ୍ବୁ ପା଼ୱୁଲ ଏ଼ନାଆଁ କିହାମାନାଣି ନେହିଁକିଁ ୱେନମି ଇଞ୍ଜିହିଁ ମୀ ତା଼ଣା ହା଼ଟିକିଦୁ, ଏଚେଟିଏ ଏ଼ୱାସି ମୀ ତା଼ଣା ଏଗାୱା଼ଆ ନ଼କେଏ ପା଼ୟାଲି ଜାଗ୍ରାତା ଆ଼ହା ଡ଼ୟିନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ସାମା ପା଼ୱୁଲ ତାମି ବାଣ୍‌ଞ୍ଜା କ଼ସ୍‌କା ଜ଼ଲ୍‌କି ଆ଼ହିମାଚି କାତା ଡ଼ୁଗାନା ୱେଚେସି; ଇଞ୍ଜାଁ କ଼ଟା ଇଲୁ ବିତ୍ରା ୱା଼ହାନା ପା଼ୱୁଲଇଁ ଈ ବାରେ କାତା ୱେସ୍ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ଏଚେଟିଏ ପା଼ୱୁଲ ର଼ ରମିୟ କ଼ହ୍‌ଏଁଣାଇଁ ହା଼ଟାନା ଏଲେଇଚେସି, “ଈ ଦାଂଗ୍‌ଣେଣାଇଁ ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାଣି ତା଼ଣା ଅ଼ମୁ, ଇଚିହିଁ ଈୱାସି ର଼ କାତା ଏ଼ୱାଣାଇଁ ୱେହ୍‌ନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ଏଚେଟିଏ ଏ଼ୱାସି ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାଣି ତା଼ଣା ଅ଼ହାନା ଏଲେଇଚେସି, “କାୟିଦିତା ମାନି ପା଼ୱୁଲ ନାଙ୍ଗେ ହା଼ଟାନା ନୀ ତା଼ଣା ଈ ଦାଂଗ୍‌ଣେଣାଇଁ ତାଚାଲି ବାତିମା଼ଲାତେସି, ନିଙ୍ଗେ ୱେସାଲି ଈୱାଣାକି ର଼ କାତା ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏ଼ୱାଣି କେୟୁ ଆସାନା ଲ଼କୁ ହିଲାଆ ତା଼ଣା ଅ଼ହାନା ୱେଚେସି, “ନାଙ୍ଗେ ନୀନୁ ଏ଼ନାଆଁ ୱେସ୍ତାନାୟିମାନେ ୱେସ୍ତାମୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ଏ଼ୱାସି ଏଲେଇଚେସି, “ପା଼ୱୁଲ ଏ଼ନାଆଁ କିହାମାନେସି ଏ଼ଦାଆଁ ନେହିଁକିଁ ପୁଞ୍ଜାଲି ଏ଼ୱାଣାଇଁ ୱିଏ କାଜା ବେ଼ରଣିମାଣ୍ତାତା ମା଼ ତା଼ଣା ତାମୁ ଇଞ୍ଜିଁ ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ନା଼ଡ଼ିକିହାନା ନିଙ୍ଗେ ବାତିମା଼ଲାନେରି, ");
INSERT INTO kxv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ସାମା ନୀନୁ ଏ଼ୱାରି କାତା ମା଼ନୱି ଆ଼ଆନି, ଇଚିହିଁ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ଆ଼ଡାଆ ପାତେକା ରା଼ନ୍ଦା ତିଚିହିଁ କି ଡୀଗିତିହିଁ ମାଙ୍ଗେ ବା଼କା ଆଟାପେ ଇଞ୍ଜିଁ ମା଼ନି କିହାନା ରୀ କ଼ଡ଼ିଟିଏ ଆଗାଡ଼ା ଲ଼କୁ ଡ଼ୁଗାହାଁ କା଼ଚାମାନେରି, ନୀଏଁ ଏ଼ୱାରି ନୀ ତା଼ଣାଟି ହେଲ ବେଟାଆ଼ହାଲି କା଼ଚିମାନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ଏଚେଟିଏ ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଏଲେଇଚେସି, “ନୀନୁ ନାଙ୍ଗେ ୱେସ୍ତାତି କାତା ଆମ୍ବାଆରାଇଁ ୱେହ୍‌ଆନି” ଇଞ୍ଜିଁ ୱେସାନା ଏ଼ ଦାଂଗ୍‌ଣେଣାଇଁ ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ତାନି ଡ଼଼ଇ କାମା କିନି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାରାଇଁ ରିଆରାଇଁ ହା଼ଟାନା ଏଲେଇଚେସି, “ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ ନ଼ ଗଂଟା ବେ଼ଲାତା କାୟିସରିୟାତା ହାଜାଲିତାକି ତୀନିକ଼ଡ଼ି ଦସ ଜା଼ଣା ଗ଼ଡ଼ାତା ହାନାରି ଅ଼ଡ଼େ ରୀ ୱାଞ୍ଜା ବା଼ଲାଁ ଗାଟାରି ତଲେ ରୀ ୱାଞ୍ଜା କ଼ସ୍‌କାଣି ତିୟାରା କିଦୁ । ");
INSERT INTO kxv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ଅ଼ଡ଼େ ଏ଼ୱାରି ଏ଼ନିକିଁ ପା଼ୱୁଲଇଁ ଗ଼ଡ଼ା ଲାକ କୁଗିକିହାନା ସା଼ଲୱି କିନି ପେଲିକସ୍‌ ତା଼ଣା ଜାଗ୍ରାତା ତଲେ ଅ଼ନେରି, ଏ଼ଦାଆଁତାକି ବାରେ କିହାଲି ହୁକୁମି ହୀତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଇଲେଇଞ୍ଜିଁ ର଼ ଆ଼କୁ ରା଼ଚିତେସି; ");
INSERT INTO kxv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ଏ଼ ମା଼ନିଗାଟି ଦେ଼ସା ସା଼ଲୱି କିନି ପେଲିକସ୍‌ କ୍ଲାୱୁଦିୟା ଲୁସିୟାତି ଜହରା । ");
INSERT INTO kxv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଜୀହୁଦିୟାଁ ଈ ଲ଼କୁଇଁ ଆସାନା ପା଼ୟାଲି ଅଣ୍‌ପିମାଚି ବେ଼ଲାତା, ଏ଼ୱାସି ର଼ ରମିୟ ଲ଼କୁ ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା, ନା଼ନୁ କ଼ସ୍‌କା ତଲେ ହାଜାନା ଏ଼ୱାଣାଇଁ ପିସ୍‌ପି କିତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ଏ଼ୱାସି ଏ଼ୱାରି କ଼ପାଟି ଏ଼ନି ଦ଼ହ କିହାମାନେସି ପୁଞ୍ଜାଲି ନା଼ନୁ ଏ଼ୱାଣାଇଁ ତାମି କାଜା ବେ଼ରଣିମାଣ୍ତାତା ଅ଼ହାମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ସାମା ଏ଼ୱାସି ହା଼ନି ଡଣ୍ତ କି କାୟିଦି ଡଣ୍ତ ବେଟାଆ଼ନି ଲେହେଁତି ଏ଼ନି ଦ଼ହ କିହାହିଲଅସି ଇଞ୍ଜିଁ ନା଼ନୁ ପୁଚେଏଁ, ତାନି କ଼ପାଟି ୱାର୍‌ଇ ତାମି ମେ଼ରାତି କାତାତାକି ଏ଼ୱାଣାଇଁ ଦ଼ହ ଦସାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ଏ଼ୱାରି ନା଼ଡ଼ିକିହାଁ ଏ଼ୱାଣାଇଁ ପା଼ୟାଲି ଅଣ୍‌ପିମାନେରି ଇଞ୍ଜିଁ ନାଙ୍ଗେ କାବ୍ରୁ ହିୟାଲିଏ ନା଼ନୁ ଈୱାଣାଇଁ ୱେ଼ଡ଼ାକିଆନା ନୀ ତା଼ଣା ପାଣ୍ତାତେଏଁ; ଏ଼ୱାଣାଇଁ ଦ଼ହ ଦସାମାନାରାଇଁ ଜିକେଏ ନୀ ନ଼କିତା ଏ଼ୱାଣି କ଼ପାଟି ସା଼କି ହୀହାଲି ୱେସା ପାଣ୍ତାତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ଏମ୍ବାଟିଏ କ଼ସ୍‌କା ହୁକୁମି ବେଟାଆ଼ହାନା ପା଼ୱୁଲଇଁ ଅ଼ହାନା ଲା଼ଆଁୟାଁ ବେ଼ଲାତା ଏ଼ୱାଣାଇଁ ଆନ୍ତିପାତ୍ରିତା ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ଅ଼ର ଦିନା ଗ଼ଡ଼ାୟାଁ ଗାଟାରାଇଁ ଏ଼ୱାଣିତଲେ ହାଜାଲି ପିସାନା, କ଼ସ୍‌କା କ଼ଟା ଇଲୁତା ୱେଣ୍ତା ୱା଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ଗ଼ଡ଼ାୟାଁ ଗାଟାରି କାୟିସରିୟାତା ୱା଼ହାନା, ସା଼ଲୱି କିନି ପେଲିକସ୍‌କି ଆ଼କୁ ହୀହାନା ପା଼ୱୁଲଇଁ ଏ଼ୱାଣି ତା଼ଣା ହେର୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ଏ଼ୱାସି ଏ଼ ଆ଼କୁ ପ଼ଡ଼ୱି ଆ଼ତି ଡା଼ୟୁ ନୀନୁ ଏମିନି ରା଼ଜିତାତି ଇଞ୍ଜିଁ ୱେଚେସି; ଅ଼ଡ଼େ ଏ଼ୱାସି କିଲିକିୟାତି ଲ଼କୁ ଇଞ୍ଜିଁ ପୁଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ଇଞ୍ଜାଁ ଏ଼ୱାସି ଏଲେଇଚେସି, “ନିଙ୍ଗେ ଦ଼ହ ଦସାମାଞ୍ଜାନାରି ଇମ୍ବାଆଁ ୱା଼ତିସାରେ ନା଼ନୁ ନୀ କାତା ୱେଞ୍ଜାଇଁ” ଅ଼ଡ଼େ ଏ଼ୱାସି ପା଼ୱୁଲଇଁ ହେରଦତି ଇଜ ଇଟାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ପା଼ସା ଦିନା ଡା଼ୟୁ କାଜା ପୂଜେରା ହାନାନ, ଏଚେକା ପ୍ରାଚିନାଙ୍ଗା ଅ଼ଡ଼େ ତର୍‌ତୁଲ ଦ଼ରୁଗାଟି ଅକିଲା ତଲେ କାୟିସରିୟାତା ୱା଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାରି ପା଼ୱୁଲ କ଼ପାଟି ସା଼ଲୱି କିନି ପେଲିକସ୍‌ ତା଼ଣା ଦାୱା କିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ପା଼ୱୁଲଇଁ ଏମ୍ବାଆଁ ତାଚାଲିଏ, ତର୍‌ତୁଲ ଏ଼ୱାଣି କ଼ପାଟି ଏଲେଇଚେସି, “ଏ଼ ମା଼ନିଗାଟି ପେଲିକସ୍‌ ନୀ ତା଼ଣାଟି ମା଼ମ୍ବୁ ହା଼ରେକା ଦିନାଟିଏ ହିତ୍‌ଡ଼ି ବେଟାଆ଼ହି ମାନମି, ଇଞ୍ଜାଁ ନୀନୁ ମା଼ ଦେ଼ସାତାକି କିହାମାନି କାମା ବାରେ ଈ କୂଡ଼ା ତାରାକି ହା଼ରେକା ନେହେଁ ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ଈଦାଆଁ ମା଼ମ୍ବୁ ବାରେଜା଼ଣା ତଲେ ବାରେ ତା଼ଣା ହା଼ରେକା ମା଼ନିତଲେ ପେଲିକସ୍‌ଇଁ ମା଼ନୱି ଆ଼ହିମାନମି । ");
INSERT INTO kxv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ସାମା ନା଼ନୁ ନିଙ୍ଗେ ଏ଼ନିକିଁ ହା଼ରେକା ବିତିବିତା କିୟଅଁ, ଈଦାଆଁତାକି ନୀନୁ ନାଙ୍ଗେ କାର୍ମାମେସାନା ମା଼ ଏଚରଗଟା କାତା ୱେଞ୍ଜାଲିତାକି ନିଙ୍ଗେ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ଇଚିହିଁ ଈ ମାଣ୍‌ସି ଆଜିହ଼ପେତି ଗଡ଼୍‌ହା ଗାଟାସି, ଏ଼ୱାସି ଦାର୍‌ତିତି ବାରେୱାକି ମାନି ଜୀହୁଦିୟାଁ ତା଼ଣା ଗଡ଼୍‌ହା ହ଼ପ୍‌ନାସି, ଅ଼ଡ଼େ ନା଼ଜରିତ ଗଚିତି ର଼ କାଜାସି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି; ");
INSERT INTO kxv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ଅ଼ଡ଼େ ଜିକେଏ ମାହାପୂରୁ ଇଲୁତି ଲାଗେଏ କିହାଲି ଅଣ୍‌ପାମାଚେସି, ଏଚିବେ଼ଲା ମା଼ମ୍ବୁ ଈୱାଣାଇଁ ଆସ୍ତମି, ଅ଼ଡ଼େ ମା଼ ମେ଼ରାତି ଲେହେଁ ଈୱାଣାଇଁ ନୀହାଁୟି କିୟାଲି ଅଣ୍‌ପାମାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ସାମା ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଲୁସିୟା ୱା଼ହାନା ଏ଼ୱାଣାଇଁ ମା଼ ତା଼ଣାଟି ବା଼ଡ଼୍‌ୟୁ ତଲେ ମୀଞ୍ଜା ଅୟାତେସି, ");
INSERT INTO kxv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଅ଼ଡ଼େ ଈୱାଣାଇଁ ଦ଼ହ ଦସିମାନାରାଇଁ ନୀ ତା଼ଣା ୱା଼ହାଲି ହୁକୁମି ହୀତେସି, ଈ ବାରେ କାତାତାକି ନୀନୁ ଈୱାଣାଇଁ ୱେଚିହିଁ ମା଼ମ୍ବୁ ଏ଼ୱାଣି କ଼ପାଟି ଦାୱା କିହାମାନାଣି ପୁଞ୍ଜାଲି ଆ଼ଡିଦି ।” ");
INSERT INTO kxv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","କୂଡ଼ା ଆ଼ହାମାଚି ଜୀହୁଦିୟାଁ ଜିକେଏ ଦାୱା କିହାମାନାରି ତଲେ ଆଣ୍ତାନା ଈ ବାରେ କାତା ସାତା ଇଞ୍ଜିଁ ଇଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ଏଚେଟିଏ ସା଼ଲୱି କିନାସି ୱାଞ୍ଜୁ ହୂଟାନା ପା଼ୱୁଲଇଁ ଜ଼ଲାଲି ହେଲ ହୀତେସି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଏଲେଇଚେସି, “ନୀନୁ ହା଼ରେକା ବାର୍ସା ଆ଼ତେ ଈ କୂଡ଼ାତାରାଇଁ ନୀହାଁୟି କିନାତି ଆ଼ହାମାଞ୍ଜି ଇଞ୍ଜିଁ ପୁଞ୍ଜାନା, ନା଼ନୁ ସା଼ସାତଲେ ନା଼ ୱାକିଟି ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ବା଼ର ଦିନାଟିଏ ଆଗାଡ଼ା ଆ଼ଏ, ନା଼ନୁ ମାହାପୂରୁତି ସେ଼ବା କିହାଲି ଜିରୁସାଲମତା ହାଜାମାଚେଏଁ, ଈଦାଆଁ ନୀନୁ ୱେଞ୍ଜାନା ପୁଞ୍ଜାଲି ଆ଼ଡିଦି । ");
INSERT INTO kxv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ଅ଼ଡ଼େ ଈୱାରି ମାହାପୂରୁ ଇଲୁତାକି ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲୁତା କି ଗା଼ଡ଼ାତି ଆମିନି ଟା଼ୟୁତା ଆମ୍ବାଆରି ତଲେ ବା଼ଦିବା଼ଦା କିତାଣି କି ଗଡ଼୍‌ହା ହ଼ପ୍‌ହାଣି ଇଞ୍ଜାଁ ଜୀହୁଦିୟାଁଣି ମା଼ତୱି କିହିମାଚାଣି ଈୱାରି ମେସାମାଞ୍ଜଅରି, ");
INSERT INTO kxv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ଇଞ୍ଜାଁ ନୀଏଁ ନା଼ କ଼ପାଟି ତାଚାମାନି ଦ଼ହ ତାକି, ଏ଼ୱାରି ନୀ ନ଼କିତା ଏ଼ନି ପାର୍‌ମାଣା ତ଼ସାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ସାମା ନା଼ନୁ ନିଙ୍ଗେ ଈଦାଆଁ ୱେସିମାଞ୍ଜାଇଁ; ଈୱାରି ଏମିନି ଜିରୁତି ମିଚି ଇଞ୍ଜିମାନେରି, ଏ଼ ଜିରୁ ତା଼କାନା ନା଼ନୁ ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ମାହାପୂରୁଇଁ ଜହରା କିହିମାଇଁ, ସାମା ନା଼ନୁ ଜିକେଏ ମ଼ସାତି ମେ଼ରା ଅ଼ଡ଼େ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ପତିତା ଏ଼ନାୟି ରା଼ସ୍‌କି ଆ଼ହାମାନେ ଏ଼ ବାରେ ନାମିମାଇଁ; ");
INSERT INTO kxv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ଈୱାରି ଲେହେଁ ମାହାପୂରୁ ତା଼ଣା ନା଼ ଏ଼ ରଣ୍ତିଏ ଆ଼ସା ମାନେ ଦାର୍ମୁଗାଟାରି ଅ଼ଡ଼େ ଦାର୍ମୁ ହିଲାଆ ଗାଟାରି ବାରେ ଲ଼କୁ ହା଼ତାରି ତା଼ଣାଟି ୱେଣ୍ତେ ନିଙ୍ଗିନେରି ଇଞ୍ଜିଁ ନୀ ନ଼କିତା ୱେସିମାଞ୍ଜାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଜିକେଏ ମାହାପୂରୁ ଅ଼ଡ଼େ ଲ଼କୁ ନ଼କିତା ବାରେଦିନା ନେହିଁ ଅଣ୍‌ପୁ ତଲେ ଡ଼ୟାଲି ଅଣ୍‌ପିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ହା଼ରେକା ବାର୍ସା ଜେ଼ଚ ନା଼ନୁ ମା଼ ଲ଼କୁତା଼ଣା ଦା଼ନା ତାଚାଲି ଅ଼ଡ଼େ ମାହାପୂରୁ ତା଼ଣା ପୂଜା କିୟାଲି ଜିରୁସାଲମତା ୱା଼ହାମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ଏଚିବେ଼ଲାତା ନା଼ନୁ ମାହାପୂରୁ ଇଲୁତା ଅଟ୍‌ହା କଡିନି ମେ଼ରା ରା଼ପ୍‌ହିମାଚି ବେ଼ଲାତା ଈୱାରି ନାଙ୍ଗେ ମାହାପୂରୁ ଇଲୁତା ମେସ୍ତାତେରି; ଏଚିବେ଼ଲା ନା଼ ତଲେ ମାନ୍ଦା ଲ଼କୁ ହିଲାଆତେରି କି ଏମ୍ବାଆଁ ଏ଼ନି ଗଡ଼୍‌ହା ହିଲାଆତେ, ");
INSERT INTO kxv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ସାମା ଆସିୟାତି ଏଚରଜା଼ଣା ଜୀହୁଦିୟାଁ ଏମ୍ବାଆଁ ମାଚେରି; ନା଼ କ଼ପାଟି ଏ଼ୱାରି ଏ଼ନି କାତା ମାଚିହିଁ ଏ଼ୱାରି ନୀ ନ଼କିତା ୱା଼ହାନା ଦାୱା କିତିହିଁ ନେହେଁ ଆ଼ତେମା । ");
INSERT INTO kxv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ନା଼ନୁ କାଜା ବେ଼ରଣିମାଣ୍ତା ନ଼କିତା ନିଚାମାଚି ବେ଼ଲାତା ଏ଼ନି ଦ଼ହ ମେସାମାଚିହିଁ ଇମ୍ବାଆଁ ମାନି ଈ ଲ଼କୁ ନାଙ୍ଗେ ୱେସ୍ତାପେରି, ");
INSERT INTO kxv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ନା଼ନୁ ରଣ୍ତିଏ କାତା ୱେସାମାଚେଏଁ ଏ଼ୱାରି ନ଼କିତା ନିଚାମାଚି ବେ଼ଲାତା ନା଼ନୁ ଆ଼ଟ୍‌ୱାତଲେ ଏଲେଇଞ୍ଜା ମାଚେଏଁ, ‘ହା଼ତାରି ୱେଣ୍ତେ ନିଙ୍ଗିନେରି ଇଞ୍ଜିଁ ନା଼ନୁ ନାମାମାନାକି ନୀଞ୍ଜୁ ମୀ ତା଼ଣାଟି ନୀହାଁୟି କିୱି ଆ଼ହିମାଇଁ ।’” ");
INSERT INTO kxv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ସାମା ପେଲିକସ୍‌ ଏ଼ ଜିରୁତି କାତା ପୁଞ୍ଜାମାଚାକି ନୀହାଁୟି କିହାଲି ବା଼ୟିଦା କିହାନା ଏଲେଇଚେସି, “ର଼ ମା଼ଣା କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ଲୁସିୟା ୱା଼ତିଦେହେଁ ନା଼ନୁ ମୀ ନୀହାଁୟି ଡିକ୍‌ହାଇଁ,” ଇଞ୍ଜିଁ ୱେସା ପାଣ୍ତିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ଏ଼ୱାସି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ଏଲେଇଚେସି, ତାନି ଲ଼କୁ ଅ଼ଡ଼େ ତ଼ଣେସିଙ୍ଗା ତାନି ସେ଼ବା କିହାଲି କା଼ହି କିଆନି, ଅ଼ଡ଼େ ତାନି କାୟିଦିତା ମାନାସି ଇଞ୍ଜିଁ ଗେଲ୍‌ପାନା ଏ଼ୱାଣାଇଁ ହିତ୍‌ଡ଼ି ତଲେ ଲେ଼ମ୍ବାଲି ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ଏଚରଦିନା ଡା଼ୟୁ ପେଲିକସ୍‌ ଦ୍ରୂସିଲା ଦ଼ରୁଗାଟି ଜୀହୁଦି ତାନି ଡକ୍ରି ତଲେ ୱା଼ତେସି, ଏ଼ୱାସି ପା଼ୱୁଲଇଁ ହା଼ଟି କିହାନା କ୍ରୀସ୍ତ ଜୀସୁ ତା଼ଣା ନାମିନି କାତା ଏ଼ୱାଣି ତା଼ଣାଟି ୱେଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ସାମା ପା଼ୱୁଲ ଦାର୍ମୁତି କାତା, ତୀର୍‌ପୁ ହିୟାଁ ଅ଼ଡ଼େ ୱା଼ହିମାନି ନୀହାଁୟି ଦିନାତି କାତା ୱେସିମାଚାକି, ପେଲିକସ୍‌ ଆଜାନା ଏଲେଇଚେସି, “ନୀଏଁ ନୀନୁ ହାଲାମୁ ବେ଼ଲା ସିନିକିହାନା ଅ଼ଡ଼େ ର଼ ଦିନା ହା଼ଟି କିୟାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ପା଼ୱୁଲ ନାଙ୍ଗେ ଟାକାୟାଁ ହିୟାନେସି ଇଞ୍ଜିଁ ଏ଼ୱାସି ଆ଼ସା କିହାମାଚେସି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାସି ଅଲେ ଅଲେ ଏ଼ୱାଣାଇଁ ହା଼ଟି କିହାନା ଏ଼ୱାଣିତଲେ କାତା ଆ଼ୱିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ଏଲେକିହିଁ ରୀ ବାର୍ସା ଆ଼ତି ଡା଼ୟୁ ପର୍କିୟ ପେସ୍ତସ୍‌, ପେଲିକସ୍‌ ଟା଼ୟୁତା ସା଼ଲୱି କିନାସି ଆ଼ତେସି, ଅ଼ଡ଼େ ପେଲିକସ୍‌ ଜୀହୁଦିୟାଁ ନେହାଁସି ଇଞ୍ଜିଁ ଇଞ୍ଜାପେରିୱା ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ପା଼ୱୁଲଇଁ କାୟିଦିତା ଇଟାନା ହାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ଏମ୍ବାଟିଏ ପେସ୍ତସ୍‌ ଈ ରା଼ଜିତା ୱା଼ହାନା ତୀନିଦିନା ଆୟାଲିଏ କାୟିସରିୟାଟି ଜିରୁସାଲମତା ହାଚେସି, ");
INSERT INTO kxv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ଅ଼ଡ଼େ ଏମ୍ବାଆଁ କାଜା ପୂଜେରାଙ୍ଗା ଇଞ୍ଜାଁ ଜୀହୁଦି ଲ଼କୁତି କାଜାରି ପା଼ୱୁଲ କ଼ପାଟି ପେସ୍ତସ୍‌ ତା଼ଣା ୱେଣ୍ତେ ଦାୱା କିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ଅ଼ଡ଼େ ଏ଼ୱାସି ଏ଼ନିକିଁ ପା଼ୱୁଲଇଁ ଜିରୁସାଲମତା ହା଼ଟା ପାଣ୍ତାନେସି, ଏ଼ଦାଆଁତାକି ଗ଼ହାରା କିହାନା ଏ଼ୱାଣି କ଼ପାଟି କାର୍ମାଆ଼ନି ଲେହେଁ ପେସ୍ତସ୍‌ଇଁ ବାତିମା଼ଲିତେରି; ଇଞ୍ଜାଁ ଏ଼ୱାରି ଜିରୁତା ଡ଼ୁଗାହାଁ ପା଼ୟାଲି ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ପେସ୍ତସ୍‌ ଏଲେଇଚେସି, “ପା଼ୱୁଲ କାୟିସରିୟାତା କାୟିଦିତା ମାନେସି, ଇଞ୍ଜାଁ ନା଼ନୁ ଜିକେଏ ତବେ ଏମ୍ବାଆଁ ୱେଣ୍ତା ହାଜିମାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ଏ଼ୱାସି ଏ଼ନି ଦ଼ହ କିହାମାନେସି, ଆତିହିଁ ମୀ କାଜାରି ନା଼ ତଲେ କାୟିସରତା ହାଲାପେରି ଅ଼ଡ଼େ ଏ଼ୱାଣି କ଼ପାଟି ତାମି ଦାୱା କିପାରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ପେସ୍ତସ୍‌ ଏମ୍ବାଆଁ ଆ଼ଟା କି ଦସ ଦିନା ଏ଼ୱାରିତଲେ ଡ଼ୟାହାଁ କାୟିସରିୟାତା ୱେଣ୍ତେ ହାଚେସି, ଏ଼ ଅ଼ର ନେ଼ଚୁ ନୀହାଁୟି କିନି ଟା଼ୟୁତା କୁଗାନା ପା଼ୱୁଲଇଁ ତାଚାଲି ହୁକୁମି ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ପା଼ୱୁଲ ୱା଼ହାଲିଏ ଜିରୁସାଲମଟି ୱା଼ହାମାନି ଜୀହୁଦିୟାଁ ତାନି ସା଼ରିସୁଟୁ ନିଚାନା ଏ଼ୱାଣି କ଼ପାଟି ହା଼ରେକା ଦ଼ହ ଦସାଲି ମା଼ଟ୍‌ହେରି, ସାମା ଏ଼ୱାରି ଏ଼ ବାରେତି ପାର୍‌ମାଣା କିହାଲି ଆ଼ଡାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ଏଚେଟିଏ ପା଼ୱୁଲ ତାନି ୱାକିଟି ୱେସାକଡାନା ଏଲେଇଚେସି, “ଜୀହୁଦିୟାଁ ମେ଼ରା କ଼ପାଟି ଆ଼ଆତିଁ ମାହାପୂରୁ ଇଲୁ କ଼ପାଟି କି କାୟିସର କ଼ପାଟି ଜିକେଏ ନା଼ନୁ ଏ଼ନି ଦ଼ହ କିହାହିଲଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ସାମା ପେସ୍ତସ୍‌, ଜୀହୁଦି ଲ଼କୁ ନ଼କିତା ନେହାଁସି ଆୟାଲି ପା଼ୱୁଲଇଁ ୱେଚେସି, “ନୀନୁ ଜିରୁସାଲମତା ହାଜାନା ଏମ୍ବାଆଁ ନା଼ ନ଼କିତା ଈ ବାରେତାକି ନୀହାଁୟି ଆୟାଲି ମ଼ନ କିହିମାଞ୍ଜି କି ?” ");
INSERT INTO kxv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ସାମା ପା଼ୱୁଲ ଏଲେଇଚେସି, “ନା଼ନୁ କାୟିସର ନ଼କିତା ନୀହାଁୟି କିନି ଟା଼ୟୁତା ନିଚାମାଇଁ, ଏମ୍ବାଆଁ ନା଼ ନୀହାଁୟି ଆ଼ନାୟି ମାନେ, ନା଼ନୁ ଜୀହୁଦିୟାଁ କ଼ପାଟି ଏ଼ନି ଲାଗେଏ କାମା କିହାହିଲଅଁ, ଏ଼଼ଦାଆଁ ନୀନୁ ଜିକେଏ ନେହିଁକିଁ ପୁଞ୍ଜାମାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ମେ଼ରା ମା଼ନି କିଆନା ଲାଗେଏତି କାମା କିହାମାଚିହିଁ, ନା଼ନୁ ହା଼ହାଲି ଆଜିହିଲଅଁ; ସାମା ଈୱାରି ନା଼ କ଼ପାଟି ଆମିନି ବାରେ ଦାୱା କିହିମାନେରି, ଏ଼ ବାରେ ବିତ୍ରାଟି ଆମିନି ର଼ ପଦୁ ଜିକେଏ ସାତା ଆ଼ଆତିହିଁ, ଆମ୍ବାଆସି ଏ଼ୱାରି କେୟୁତା ନାଙ୍ଗେ ହେର୍‌ପାଲି ଆ଼ଡଅସି, ନା଼ନୁ କାୟିସର ନ଼କିତା ନୀହାଁୟି କିୱିଆୟାଲି ଗ଼ହାରା କିହିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ଏମ୍ବାଟିଏ ପେସ୍ତସ୍‌ ତାନି ନୀହାଁୟିତି କାଜାରି ତଲେ ଜ଼ଲ୍‌କି ଆ଼ହାନା ଏଲେଇଚେସି, “ନୀନୁ କାୟିସର ନ଼କିତା ନୀହାଁୟି କିୱିଆୟାଲି ରୀସିମାଞ୍ଜି, ଆତିହିଁ ନୀନୁ କାୟିସର ତା଼ଣେଏ ହାଜି ।” ");
INSERT INTO kxv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ଏଚରଦିନା ଡା଼ୟୁ ରାଜା ଆଗ୍ରିପା ଅ଼ଡ଼େ ବର୍ନିକି କାୟିସରିୟାତା ୱା଼ହାନା ପେସ୍ତସ୍‌ଇଁ ଆଣ୍ତାଲି ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ଏ଼ୱାରି ଏମ୍ବାଆଁ ଏଚରଦିନା ଡ଼ୟିତି ଡା଼ୟୁ, ପେସ୍ତସ୍‌ ରାଜା ନ଼କିତା ପା଼ୱୁଲ କାତା ୱେସ୍ତେସି, “ପେଲିକସ୍‌ କାୟିଦିତା ଇଟାମାନାସି ରଅସି ଇମ୍ବାଆଁ ମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ନା଼ନୁ ଏଚିବେ଼ଲା ଜିରୁସାଲମତା ହାଜାମାଚେଏଁ ଏଚିବେ଼ଲାତା ଜୀହୁଦି ଲ଼କୁତି କାଜା ପୂଜେରାଙ୍ଗା ଅ଼ଡ଼େ ପ୍ରାଚିନାଙ୍ଗା ଏ଼ୱାଣି କ଼ପାଟି ୱେସାନା ଏ଼ୱାଣାଇଁ ଡଣ୍ତ ହୀହାଲି ନାଙ୍ଗେ ବାତିମା଼ଲି ମାଞ୍ଜାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ସାମା ନା଼ନୁ ଏ଼ୱାରାଇଁ ଏଲେଇଚେଏଁ, ଦ଼ହଗାଟାସି ତାନି ଦ଼ହ ଦସାମାନାରା ନ଼କିତା ନିଆ ପାତେକା ଇଞ୍ଜାଁ ତାଙ୍ଗେ ତାନି ୱାକିଟି ଜ଼ଲାଲି ହୀଆ ପାତେକା ଏ଼ୱାଣାଇଁ ଡଣ୍ତ ହୀହାଲି ମା଼ ର଼ମ୍‌ ଲ଼କୁତି ମେ଼ରା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ଏ଼ୱାରି ନା଼ ତଲେ ଇମ୍ବାଆଁ ୱାୟାଲିଏ, ନା଼ନୁ ୱେ଼ଡ଼ାକିଆନା ତାନି ଅ଼ର ନେ଼ଚୁ ନୀହାଁୟି କିନି ତା଼ଣା କୁଗାନା, ଏ଼ୱାଣାଇଁ ତାଚାଲି ହୁକୁମି ହୀତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ଏ଼ୱାଣାଇଁ ଦ଼ହ ଦସାମାନାରି ୱା଼ହାନା ନିତେରି, ସାମା ଏ଼ୱାରି ଏ଼ନିଲେହେଁତି ଦାୱା କିନେରି ଇଞ୍ଜିଁ ନା଼ନୁ ଅଣ୍‌ପିମାଚେଏଁ, ଏ଼ୱାରି ଏ଼ନି ଦ଼ହ ଏ଼ୱାଣି କ଼ପାଟି ୱେସ୍ତାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ଏ଼ୱାରି ୱାର୍‌ଇ ତାମି ଦାର୍ମୁତି କାତା ଇଞ୍ଜାଁ ଜୀସୁ ଦ଼ରୁଗାଟି ଏମିନି ହା଼ତାଣାଇଁ ପା଼ୱୁଲ ନୀଡାମାନେସି ଇଞ୍ଜିଁ ୱେସିମାନେସି, ତାନି କାତାତାକି ଆସ୍‌ପି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ଈ ବାରେ କାତା ନେହିଁକିଁ ପୁଞ୍ଜାଲିତାକି ଏ଼ନାଆଁ କିହାଲି ଆ଼ନେ, ଏ଼ନାଆଁ ତୀରି କିହାଲି ଆ଼ଡାଆନା ଈ ଦାୱା ତାକି ନୀହାଁୟି ଆ଼ହାଲିତାକି ପା଼ୱୁଲ ଜିରୁସାଲମତା ହାନେସି କି ଆ଼ଏ ଏ଼ଦାଆଁ ନା଼ନୁ ୱେଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ସାମା ପା଼ୱୁଲ ସା଼ଲୱି କିନି କାୟିସର ନ଼କିତା ନୀହାଁୟି କିୱିଆୟାଲି ନା଼ନୁ ହାଇଁ ଇଞ୍ଜିଁ ୱେସିମାଚାକି, ନା଼ନୁ ଏ଼ୱାଣାଇଁ କାୟିସର ତା଼ଣା ପାଣ୍ତିନି ପାତେକା କାୟିଦିତା ଇଟାଲି ହୁକୁମି ହୀତେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ଆଗ୍ରିପା ପେସ୍ତସ୍‌ଇଁ ଏଲେଇଚେସି, “ନା଼ନୁ ଜିକେଏ ଈୱାଣି କାତା ୱେଞ୍ଜାଲି ମ଼ନ କିହିମାଇଁ । ହାଅ ୱିଏ ନୀନୁ ଏ଼ୱାଣି କାତା ୱେଞ୍ଜି” ଇଞ୍ଜିଁ ପେସ୍ତସ୍‌ ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ତାନି ଅ଼ର ଦିନା ଆଗ୍ରିପା ଇଞ୍ଜାଁ ବର୍ନିକି କାଜାପା଼ଣା ଅ଼ଡ଼େ ଗାୱୁରମିଗାଟି କ଼ସ୍‌କା ଇଞ୍ଜାଁ ଗା଼ଡ଼ାତି କାଜାରି ତଲେ ହାଜାନା ନୀହାଁୟି କିନି ଟା଼ୟୁତା ୱା଼ତେସି, ଏମ୍ବାଟିଏ ପେସ୍ତସ୍‌ ହୁକୁମି ତଲେ ପା଼ୱୁଲ ଏମ୍ବାଆଁ ତାପିଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ଏମ୍ବାଟିଏ ପେସ୍ତସ୍‌ ଏଲେଇଚେସି, “ଏ଼ ରାଜା ଆଗ୍ରିପା ଅ଼ଡ଼େ ଇମ୍ବାଆଁ ମାନି ମା଼ନିଗାଟି କାଜାତେରି, ମୀରୁ ବାରେ ଈୱାଣାଇଁ ମେସିମାଞ୍ଜେରି; ଈୱାଣି କ଼ପାଟି ଜିରୁସାଲମ ଇଞ୍ଜାଁ ଇମ୍ବାଆଁ ମାନି ଜୀହୁଦି ଲ଼କୁ ନା଼ ତା଼ଣା ଦାୱା କିହାମାନେରି, ଈୱାସି ନୀଡାମାନାୟି ଲ଼ଡ଼ା ହିଲେଏ ଇଞ୍ଜିଁ ବାରେଜା଼ଣା କା଼ଲୱି ଆ଼ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ସାମା ଈୱାସି ହା଼ନିଲେହେଁତି ଏ଼ନି ଦ଼ହ କିହାମାନାଣି ନା଼ନୁ ମେସାହିଲଅଁ ଇଞ୍ଜାଁ ଏ଼ୱାସି ତା଼ନୁଏ କାୟିସର ତା଼ଣା ନୀହାଁୟି କିୱିଆୟାଲି ବାତିମା଼ଲାତାକି ନା଼ନୁ ଏ଼ୱାଣାଇଁ ଏମ୍ବାଆଁ ପାଣ୍ତାଲି ତାକି ତୀରି କିତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ସାମା ରାଜା କାୟିସର ତା଼ଣା ଏ଼ୱାଣି ତାକି ରା଼ଚାଲି ନାଙ୍ଗେ ଏ଼ନି କାତା ହିଲେଏ, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ଏ଼ୱାଣାଇଁ, ବାରେକିହାଁ ରାଜା ଆଗ୍ରିପା ନୀ ତା଼ଣା ଏ଼ୱାଣାଇଁ ତାଚାମାଇଁ, ଏ଼ନିକିଁ ଏ଼ୱାଣି କାତା ୱେଞ୍ଜାନା, ପୁଚିଡା଼ୟୁ ନା଼ନୁ ଏ଼ୱାଣାକି ଇଚାଣି ରା଼ଚାଲି ଆ଼ଡିଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ଇଚିହିଁ ର଼ କାୟିଦି ଗାଟାଣାଇଁ ପାଣ୍ତିନି ବେ଼ଲାତା ତାନି କ଼ପାଟି କିହାମାନି ଦାୱା ନେହିଁକିଁ ତ଼ହ୍‌ଆନା ପାଣ୍ତାଲି ନେହେଁ ଆ଼ଏ ଇଞ୍ଜିଁ ନା଼ନୁ ଅଣ୍‌ପିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ଆଗ୍ରିପା ପା଼ୱୁଲଇଁ ଏଲେଇଚେସି, “ନିଙ୍ଗେ ନୀ ୱାକିଟି କାତା ଜ଼ଲାଲି ହେଲ ହୀପ୍‌କିଆ଼ତେ” ଏମ୍ବାଟିଏ ପା଼ୱୁଲ କେୟୁ ଦା଼ସାନା ତାନି ୱାକିଟି ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ରାଜା ଆଗ୍ରିପା, ଜୀହୁଦିୟାଁ ନା଼ କ଼ପାଟି ଏ଼ନି ଦ଼ହ ଦସାମାଞ୍ଜାନେରି, ଏ଼ଦାଆଁ ନୀଞ୍ଜୁ ନୀ ନ଼କିତା ୱେସାଲି ନା଼ନୁ ହେଲ ବେଟାଆ଼ହାମାନାକି ନା଼ନୁ ନାଙ୍ଗେ କପଲ ଗାଟାତେଏଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପା କଡିମାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ଏ଼ନାଆଁତାକି ଇଚିହିଁ, ନୀନୁ ଜୀହୁଦିୟାଁ ପା଼ଣାପା଼ଟୁ ଅ଼ଡ଼େ କାତା ନେହିଁକିଁ ପୁଞ୍ଜାମାଞ୍ଜି; ଏ଼ଦାଆଁତାକି ନା଼ କାତା ସା଼ସାତଲେ ୱେଞ୍ଜାଲି ନିଙ୍ଗେ ବାତିମା଼ଲିମାଞ୍ଜାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ନା଼ ଦାଂଗ୍‌ଣା ୱେ଼ଡ଼ାଟିଏ ନୀଏଁ ପାତେକା ନା଼ନୁ ତଲି ମା଼ କୂଡ଼ାତାରି ତଲେ ଅ଼ଡ଼େ ଜିରୁସାଲମତା ଏ଼ନିଆ଼ହିଁ ନୀଡା ମାଚେଏଁ ଏ଼ଦାଆଁ ଜୀହୁଦିୟାଁ ବାରେ ନେହିଁକିଁ ପୁଞ୍ଜାମାନେରି; ");
INSERT INTO kxv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ନା଼ନୁ ମା଼ ମାହାପୂରୁତି ମେ଼ରା ହା଼ରେକା ନେହିଁକିଁ ମା଼ନୱି ଆ଼ହିମାନି ପାରୁସିୟାଁ ଗଚିତା ମାଚେଏଁ, ଏ଼ୱାରି ନାଙ୍ଗେ ତଲିଟିଏ ପୁଞ୍ଜାମାଞ୍ଜାନେରି, ଏ଼ୱାରି ମ଼ନ କିତିହିଁ ସା଼କି ହୀହାଲି ଆ଼ଡିନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ମାହାପୂରୁ ମା଼ ଆକୁ ଆ଼ବାୟାଁଣି ଏମିନି କାତା ଆ଼ଞ୍ଜାମାଚେସି, ଏ଼ କାତା ହୀହାମାନାଣି ବା଼ର୍ସୁ କିହାମାନାକି ନୀଞ୍ଜୁ ନା଼ନୁ ଇମ୍ବାଆଁ ନୀହାଁୟି କିୱିଆୟାଲି ନିଚାମାଇଁ ");
INSERT INTO kxv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ମା଼ ଲ଼କୁତି ବା଼ର କୂଡ଼ାତାରି ଲା଼ଆଁ ମାଦେନା ମାହାପୂରୁତି ସେ଼ବା କିହାନା ଏ଼ ରଣ୍ତିଏ କାତା ବେଟାଆ଼ହାଲି ତାକି ଆ଼ସା କିନେରି, ଏ଼ ରାଜା, ନା଼ ଏ଼ ବା଼ର୍ସୁ ତାକି ଜୀହୁଦିୟାଁ ନାଙ୍ଗେ ଦ଼ହ କିହିମାଞ୍ଜାନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ମାହାପୂରୁ ହା଼ତାରାଇଁ ନିକ୍‌ନେସି, ଈଦାଆଁ ନାମାଲି ଆ଼ଡାଆ ଗାଟାୟି ଇଞ୍ଜିଁ ମୀରୁ ଏ଼ନାଆଁତାକି ଅଣ୍‌ପିମାଞ୍ଜେରି ?” ");
INSERT INTO kxv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ନା଼ଜରିତ ଜୀସୁ ଦ଼ରୁ କ଼ପାଟି ନାଙ୍ଗେ ହା଼ରେକା କାମା କିନାୟିମାନେ ଇଞ୍ଜିଁ ନା଼ନୁ ଅଣ୍‌ପିମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ଜିରୁସାଲମତା ନା଼ନୁ ଏଲେଜିକେଏ କିତେଏଁ । କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣାଟି ଅଦିକାରା ଆ଼କୁ ବେଟାଆ଼ହାନା, ମାହାପୂରୁ ଲ଼କୁ ତା଼ଣାଟି ହା଼ରେକା ଜା଼ଣାଇଁ କା଼ୟିଦିତା ସୁଣ୍ଡିକିହାମାଚେଏଁ ଇଞ୍ଜାଁ ଏ଼ୱାରାଇଁ ପା଼ୟିନାଟି ନା଼ନୁ ଜିକେଏ ଆଣ୍ଡିମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ହା଼ରେକା ଦେବା ଜୀହୁଦି ଲ଼କୁତି କୁଟମି ଇଲ୍‌କାଣା ନା଼ନୁ ଏ଼ୱାରାଇଁ ଲାଜାକିହିଁ ଡଣ୍ତ ହୀହିମାଚେଏଁ ଇଞ୍ଜାଁ ଏ଼ୱାରି ନାମୁତି ଏଟ୍‌କା କିହାଲି ଅଣ୍‌ପାମାଚେଏଁ, ନା଼ନୁ ଏ଼ୱାରି କ଼ପାଟି ହା଼ରେକା କାର୍‌ବି ଆ଼ହାମାଚେଏଁ, ଏ଼ୱାରାଇଁ ସା଼ସ୍ତି ହୀହାଲି ଏଟ୍‌କା ଦେ଼ସାତା ଜିକେଏ ହାଜାମାଚେଏଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ଈଦାଆଁତାକି କାଜା ପୂଜେରାଙ୍ଗା ତା଼ଣାଟି ଅଦିକାରା ଆ଼କୁ ଅ଼ଡ଼େ ହୁକୁମି ବେଟାଆ଼ହାନା ନା଼ନୁ ଦମେସକ ହାଜାମାଚେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ଏ଼ ରାଜା ଆଗ୍ରିପା, ର଼ ଦିନା ମାଦେନା ବେ଼ଲା ଜିରୁତା ହା଼ଗୁଲାକଟି ୱେ଼ଡ଼ାକିହାଁ ହା଼ରେକା ଉଜେଡ଼ି ମେସ୍ତେଏଁ, ଏ଼ ଉଜେଡ଼ି ନାଙ୍ଗେ ଅ଼ଡ଼େ ନା଼ ତଲେ ହାଜିମାଚାରି ସା଼ରିୱାକି ତ଼ଞ୍ଜାଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ମା଼ମ୍ବୁ ବାରେଜା଼ଣା ବୂମିତା ତର୍‌ଗାଲିଏ, ଏବ୍ରି ହା଼ଡାତଲେ ନାଙ୍ଗେତାକି ଈ ହା଼ଡା ୱେଚେଏଁ, “ଆଡ଼େ ସା଼ୱୁଲ ଆଡ଼େ ସା଼ୱୁଲ ଏ଼ନାଆଁତାକି ନାଙ୍ଗେ ସା଼ସ୍ତି ହୀହିମାଞ୍ଜାଦି ? ଏ଼ନିକିଁ ଡ଼ୁକି କ଼ଡି ହେ଼ରୁ ଡ଼ୂନାଣି ହୁତ୍ରୁ ବାଡ଼୍‌ଗାତା ଦୟିନେ ଏଲେକିହିଁ ନୀନୁ ଡା଼ୟୁୱାକି ଦୟାହାଁ ଜାହାରା କଡାତା ଗା଼ଣ୍‌ଙ୍ଗି ମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ଏମ୍ବାଟିଏ ନା଼ନୁ ୱେଚେଏଁ, “ପ୍ରବୁ ନୀନୁ ଆମ୍ବାଆତି ?” ଏଚେଟିଏ ପ୍ରବୁ ଏଲେଇଞ୍ଜାତେସି “ନୀନୁ ଆମ୍ବାଆରାଇଁ ସା଼ସ୍ତି ହୀହିମାଞ୍ଜି ନା଼ନୁ ଏ଼ ଜୀସୁତେଏଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ସାମା ନିଙ୍ଗାମୁ କଡାତା ବା଼ଡ଼୍‌ୟୁ ହୀହାନା ନିମୁ, ଇଚିହିଁ ନା଼ନୁ ନିଙ୍ଗେ ନା଼ ସେ଼ବା କାମା କିହାଲିତାକି ତ଼ଞ୍ଜା ଆ଼ହାମାଞ୍ଜାଇଁ, ନୀଞ୍ଜୁ ନୀନୁ ଏ଼ନାଆଁ ମେସାମାଞ୍ଜି ଡା଼ୟୁ ନା଼ନୁ ନିଙ୍ଗେ ଏ଼ନାଆଁ ତ଼ସ୍ତାଇଁ ଏ଼ କାତା ଏଟ୍‌କା ତାରାଇଁ ସା଼କି ହୀଦି । ");
INSERT INTO kxv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ନା଼ନୁ ନିଙ୍ଗେ ପାଣ୍ତାଇଁ, ଏ଼ୱାରି ତା଼ଣାଟି ନା଼ନୁ ନିଙ୍ଗେ ଗେଲ୍‌ପାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ନିଙ୍ଗେ ଏ଼ୱାରି କାଣ୍‌କା ଦେଚାଲି ଆ଼ନେ, ଅ଼ଡ଼େ ଏ଼ୱାରାଇଁ ଆନ୍ଦେରିଟି ଉଜେଡ଼ିତା ଅ଼ଡ଼େ ସୟତାନ ପା଼ନ୍ଦାଟି ମାହାପୂରୁ ତା଼ଣା ୱେଟ୍‌ହା ତାନାୟି ଆ଼ନେ, ଏ଼ନିକିଁ ନା଼ ତା଼ଣା ନାମିନି ତା଼ଣାଟି ସୁଦୁ କିୱି ଆ଼ହାନା ଏ଼ୱାରି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନେ ଅ଼ଡ଼େ ମାହାପୂରୁ ଆ଼ଚିତି ଲ଼କୁ ବିତ୍ରା ଏ଼ୱାରି ଟା଼ୟୁ ବେଟାଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ରାଜା ଆଗ୍ରିପା, ଏ଼ ଲାକପୂରୁଟି ମେସ୍ତାଣି ନା଼ନୁ ଊରାଆତେଏଁ, ");
INSERT INTO kxv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ତଲିଏ ଦମେସକତା ଇଞ୍ଜାଁ ଜିରୁସାଲମତି ଲ଼କୁତା଼ଣା ଡା଼ୟୁ ଜୀହୁଦା ରା଼ଜିତି ବାରେ ନା଼ସ୍‌କାଣାଁ, ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ଜିକେଏ ୱେ଼କ୍‌ହେଏଁ, ଏ଼ନିକିଁ ଏ଼ୱାରି ମ଼ନ ୱେଟ୍‌ହାନା ମାହାପୂରୁ ତା଼ଣା ୱା଼ନେରି, ଇଞ୍ଜାଁ ଏ଼ୱାରି ମ଼ନ ୱେଟ୍‌ହା କଡାମାନେରି, ଏ଼ଦାଆଁ କାମାତା ତ଼ହ୍‌ନେରି । ");
INSERT INTO kxv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମାହାପୂରୁ ଇଲୁତା ମାଚାଟି ଜୀହୁଦିୟାଁ ନାଙ୍ଗେ ଆସାନା ପା଼ୟାଲି ଅଣ୍‌ପି ମାଞ୍ଜାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ସାମା ନୀଞ୍ଜୁପାତେକା ମାହାପୂରୁ ନାଙ୍ଗେ ସା଼ୟେମି କିହାମାଞ୍ଜାନେସି, ଏ଼ଦାଆଁତାକି ନୀଞ୍ଜୁ ନା଼ନୁ ଊଣା କାଜାରି ବାରେତି ନ଼କିତା ସା଼କି ହୀହାଲି ନିଚାମାଇଁ । ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଅ଼ଡ଼େ ମ଼ସା ଏ଼ନାଆଁ ଆ଼ନେ ଇଞ୍ଜିଁ ୱେସାମାନେସି ନା଼ନୁ ଏ଼ କାତା ୱେସିମାଇଁ, ");
INSERT INTO kxv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ଇଚିହିଁ ମସିହା ସାତେଏ ଦୁକୁ ବେଟାଆ଼ହାନା ହା଼ତାରି ବିତ୍ରାଟି ତଲିଏ ନିଙ୍ଗାନା ଜୀହୁଦି ଲ଼କୁ ଇଞ୍ଜାଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ନ଼କିତା ଗେଲ୍‌ପିନି ଉଜେଡ଼ି ତ଼ହ୍‌ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ପା଼ୱୁଲ ଇଲେକିହିଁ ତାନି ୱାକିଟି ଜ଼ଲିମାଚାଟି ପେସ୍ତସ୍‌ କାଜା ଗିୟାଁତଲେ ଏଲେଇଚେସି, “ପା଼ୱୁଲ ନୀନୁ ବାୟା ଆ଼ତି; ଗାଡି ଜା଼ପିତାକି ନୀନୁ ବାୟା ଆ଼ହାମାଞ୍ଜି ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ସାମା ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଏ଼ ମା଼ନିଗାଟି ପେସ୍ତସ୍‌ ନା଼ନୁ ବାୟା ଆ଼ହାହିଲଅଁ; ସାମା ନା଼ନୁ ଏ଼ନାଆଁ ଜ଼ଲିମାଇଁ ଏ଼ଦି ସାତା, ତୀରି ବୁଦିତଲେ ୱେସିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ରାଜା ଆଗ୍ରିପା ନୀନୁ ଈ ବାରେ ପୁଞ୍ଜାମାନାକି, ନା଼ନୁ ନୀ ନ଼କିତା ସା଼ସାତଲେ କାତା ଜ଼ଲିମାଇଁ, ନା଼ନୁ ସାତେଏ ନାମିମାଇଁ, ଈ ବାରେ ନୀନୁ ପୁନାଆରେ଼ଟୁ ଆ଼ହା ହିଲେଏ; ଅ଼ଡ଼େ ଈ ବାରେ କାତା ଡ଼ୁଗାନା ମେ଼ଣେଏ ଆ଼ହାହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ଏ଼ ରାଜା ଆଗ୍ରିପା, ନୀନୁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ନାମିମାଞ୍ଜି କି ? ହାଅ ନୀନୁ ନାମିମାଞ୍ଜି ଇଞ୍ଜିଁ ନା଼ନୁ ପୁଞ୍ଜାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ଆଗ୍ରିପା ପା଼ୱୁଲଇଁ ଏଲେଇଚେସି, “ନୀନୁ ନାଙ୍ଗେ ଗା଼ଡ଼େକେଏ କ୍ରୀସ୍ତାନା କିଇଁ ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜାଦି ?” ");
INSERT INTO kxv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଗା଼ଡ଼େକା ତାକି ଆ଼ପେ କି ଗାଡିତାକି ଆ଼ପେ ମାହାପୂରୁ ତା଼ଣା ଇଚେକେଏ ନା଼ ପ୍ରା଼ତାନା, ନୀନୁ, ଅ଼ଡ଼େ ଏଚରଜା଼ଣା ନୀଞ୍ଜୁ ନା଼ କାତା ୱେଞ୍ଜିମାନେରି, ବାରେଜା଼ଣା ନା଼ଲେହେଁ ଆ଼ପେରି ସାମା ନା଼ଲେହେଁ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପି ଆ଼ପେରି ଇଞ୍ଜିଁ ନା଼ନୁ ୱେସିମାଞ୍ଜଅଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ଏଚେଟିଏ ରାଜା, ସା଼ଲୱି କିନାସି ଅ଼ଡ଼େ ବର୍ନିକି ଇଞ୍ଜାଁ ଏଟ୍‌କାତାରି ବାରେ ହାଜାଲି ନିଙ୍ଗିତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ଏ଼ୱାରି ହାନିବେ଼ଲାତା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ ଜ଼ଲ୍‌କି ଆ଼ତେରି, “ଈ ମାଣ୍‌ସି ଇଲେତି ଏ଼ନି କାମା କିହାହିଲଅସି ଏ଼ନାଆଁତାକି ଏ଼ୱାସି ଦସ୍‌ପି ଆ଼ନେସି କି ପା଼ୟ୍‌ୱି ଆ଼ନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ଅ଼ଡ଼େ ଆଗ୍ରିପା ପେସ୍ତସ୍‌ଇଁ ଏଲେଇଚେସି, “ଈ ମାଣ୍‌ସି କାୟିସର ତା଼ଣା ନୀହାଁୟି କିୱିଆୟାଲି ବାତିମା଼ଲାଆତିହିଁମା ମା଼ମ୍ବୁ ଏ଼ୱାଣାଇଁ ପିସାଲି ଆ଼ଡିତମିମା ।” ");
INSERT INTO kxv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ମା଼ମ୍ବୁ ଇଟାଲି ଦେ଼ସାତା ଏ଼ୟୁ ଜା଼ଜା ତଲେ ହାଜାଲି ତୀରି କିୱିଆ଼ତି ଡା଼ୟୁ ପା଼ୱୁଲ ଅ଼ଡ଼େ ଏଚରଜା଼ଣା କାୟିଦିତା ମାଚାରାଇଁ, ରାଜାତି କ଼ସ୍‌କା ଜୁଲିୟସ୍‌ ଦ଼ରୁଗାଟି ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣି କେୟୁତା ହେର୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ଏମ୍ବାଟିଏ ମା଼ମ୍ବୁ ଆସିୟା ଦେ଼ସାତି ଏଟ୍‌କା ଏଟ୍‌କା ଟା଼ୟୁତା ହାନି ଏ଼ୟୁ ଜା଼ଜା ନିନି ଟା଼ୟୁଟି ଆଦ୍ରାମୁତିୟ ଜା଼ଜାତା ହ଼ତମି; ଇଞ୍ଜାଁ ମାକିଦନିୟା ଦେ଼ସାତି ତେସଲନିକି ଗା଼ଡ଼ାତି ଆରିସ୍ତାର୍କ ମା଼ ତଲେ ମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ତାନି ଅ଼ର ନେ଼ଚୁ ମା଼ମ୍ବୁ ସିଦନତା ଏଗାତମି, ଅ଼ଡ଼େ ଜୁଲିୟସ୍‌ ପା଼ୱୁଲଇଁ କାର୍ମା ଆ଼ହାନା ତାନି ତ଼ଣେସିଙ୍ଗା ତା଼ଣା ହାଜାନା ଲ଼ଡ଼ାମାନାଣି ସେ଼ବା ବେଟାଆ଼ହାଲି ହେଲ ହୀତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ଏମ୍ବାଟି ଜା଼ଜାତା ହ଼ଚାମାଚାଟି ମା଼ ୱାକି ଗା଼ଲି ୱେ଼ଚାଲିଏ ମା଼ମ୍ବୁ କୁପ୍ର ଦାରି ଦାରିଟି ହାଚମି, ");
INSERT INTO kxv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","କିଲିକିୟା ଅ଼ଡ଼େ ପଂପୁଲିୟା ନ଼କିତା ମାନି ସାମ୍‌ଦୁରି ଗା଼ଣ୍‌ଚାନା ଲୁକିୟାତି ମୂରାତା ୱା଼ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ଏମ୍ବାଆଁ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି, ଇଟାଲିତା ହାଜିମାନି ର଼ ଆଲେକ୍‌ଜାଣ୍ତ୍ରିୟା ଏ଼ୟୁ ଜା଼ଜା ବେଟାଆ଼ହାନା ମାଙ୍ଗେ କୁଗି କିୟାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ଡା଼ୟୁ ହା଼ରେକା ଦିନାତାକି ଦୀରେ ଦୀରେ ହାଜାନା କସ୍ତତଲେ କ୍ନିଦ ଗା଼ଡ଼ା ଡାଗେ ହାଚମି । ନ଼କିତି ଗା଼ଲି ମାଙ୍ଗେ ନ଼କିତା ହାଜାଲି ହିୟାଆଲିଏ ସାଲ୍‌ମନିତି ଅ଼ରୱାକି କ୍ରିତି ଦାରି ଦାରିଟି ହାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ଅ଼ଡ଼େ କସ୍ତତଲେ ଗାଟୁ ଗାଟୁଟି ହାଜାନା “ଅ଼ଜିତି ବାନ୍ଦା” ଇନି ଟା଼ୟୁତା ହାଚମି, ଏ଼ଦି ଲାସାୟା ଗା଼ଡ଼ାତି ଡାଗେ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ଇଲାଆ଼ହିଁ ହା଼ରେକା ଦିନା ଆ଼ହାହାଚେ, ଇଞ୍ଜାଁ ସାମ୍‌ଦୁରିଟି ହାନାୟି କସ୍ତ ଆ଼ହାହାଚେ, ଇଚିହିଁ ଏଚିବେ଼ଲା ଉପାସା ପାର୍ବୁ ରା଼ହାମାଚେ, ଏ଼ଦାଆଁତାକି ପା଼ୱୁଲ ଜାଗ୍ରାତା କିହାନା ଏଲେଇଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ବା଼ବୁୟାଁତେରି ଈ ସାମ୍‌ଦୁରିଟି ହାନାଟି ଜା଼ଜାତି ଆ଼ସ୍ତି ଅ଼ଡ଼େ ଏ଼ୟୁ ଜା଼ଜା ନସ୍ତ ଆ଼ନେ ଏ଼ଦି ଆ଼ଏ, ସାମା ଜା଼ଜାତା ହାଜିମାନାରି ଜୀୱୁ ଜିକେଏ ନସ୍ତ ଆ଼ନେ ନା଼ନୁ ପୁଞ୍ଜିମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ସାମା ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି, ପା଼ୱୁଲତି କାତା କିହାଁ ଜା଼ଜାତି ସା଼ଲୱି କିନାଣାଇଁ ଇଞ୍ଜାଁ ସା଼ୱୁକାରି କାତାତି ହା଼ରେକା ନାମିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ଈ ବାନ୍ଦାତା ପେନିୱେ଼ଡ଼ା ଡ଼ୟାଲି ନେହେଁ ହିଲାଆତେ, ଈଦାଆଁତାକି ଜା଼ଜାତା ହାଜିମାଚାରି ହା଼ରେକା ସାମ୍‌ଦୁରିଟି ହାଜାନା ପିନିକ୍‌ସ୍‌ତା ପେନିବେ଼ଲା ରା଼ପ୍‌ହାଲି ଅଣ୍‌ପିମାଚେରି, ଏ଼ ପିନିକ୍‌ସ୍‌ କ୍ରିତିତି ର଼ ଜା଼ଜାୟାଁ ନିନି କାଜା ଟା଼ୟୁ ମାଚେ, ଏ଼ଦି ୱେ଼ଡ଼ା କୂଡ଼୍‌ନି ଟିଃନିୱାକି ଅ଼ଡ଼େ, ୱେ଼ଡ଼ା କୂଡ଼୍‌ନି ଟେ଼ବ୍ରିୱାକି ମୂମ୍ବୁ କିହାମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ଏଚିବେ଼ଲା ଟିଃନି ୱାକିତି ଗା଼ଲି ଦୀରେ ଦୀରେ ୱା଼ତେ, ହାଜିମାଚାରି ନୀଏଟି ମା଼ ଅଣ୍‌ପିମାଚି ଲେହେଁ ଆ଼ତେ ଇଞ୍ଜିଁ ଅଣ୍‌ପିତେରି, ଜା଼ଜା ନିପ୍‌ହାମାଚି କାଜା ଲ଼ହତି ରେଜାନା କ୍ରିତିତି ଗାଟୁ ଗାଟୁଟି ହାଜାଲି ମା଼ଟ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ସାମା ଗା଼ଡ଼େକା ହାଜାଲିଏ ଇୟୁରକ୍‌ୱିଲ୍‌ ଇନି ଆଜିହ଼ପେତି କାଜା ଗା଼ଲି ୱେ଼ଡ଼ା ହ଼ନି ଟେ଼ବ୍ରି ୱାକିଟି ହ଼ଚାନା ଜା଼ଜା ମାଚିୱାକି ୱା଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ଗା଼ଲି ଜା଼ଜାତି ୱେ଼ଚାଲିଏ, ଜା଼ଜାତି ଗା଼ଲିୱାକି ଅୟାଲି ଆ଼ଡାଆନା ଜା଼ଜାତି ଗା଼ଲି ତଲେ ଅ଼ୱିଆୟାଲି ପିସ୍ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ମା଼ମ୍ବୁ କ୍ଲାୱୁଦାତି ସାମ୍‌ଦୁରି ମାଦି ମାନି ଊଣା ବୂମିତି ଜ଼ମିନି ଟା଼ୟୁ ବେଟାଆ଼ତମି । ଏମ୍ବାଟି ହା଼ରେକା କସ୍ତଟି ଏ଼ୟୁ ଜା଼ଜାତି ଊଣା ଡଂଗ ତଲେ ଗେଲ୍‌ପି ଆ଼ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ଜା଼ଜା ସା଼ଲୱି କିନାରି ଏ଼ଦାଆଁ ଜା଼ଜା ଲାକ ଅ଼ତି ଡା଼ୟୁ ଡ଼଼ର୍କା ତଲେ ଜା଼ଜା ସା଼ରିସୁଟୁ ଦସ୍ତେରି, ଇଞ୍ଜାଁ ଜା଼ଜା ଲିବିୟାତି ସୁର୍‌ତି ଇନି ବାଃଲି ଡିବାତା ଗୁପିନେ ଇଞ୍ଜିଁ ଆଜିତାକି ଜା଼ଜା ସା଼ଲୱି କିନାରି ଜା଼ଜାତା ଗ଼ଞ୍ଜାମାଚି ହିମ୍ବରିକା ହୁକ୍‌ହାନା ଜା଼ଜାତି ଗା଼ଲି ତଲେ ସାମ୍‌ଦୁରି ବିତ୍ରା ଡ଼ୟାଲି ପିସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","କାଜା ଗା଼ଲି ପିୟୁ ତାକି ହା଼ରେକା କସ୍ତ ଆ଼ହାଲିଏ ତାନି ଅ଼ର ନେ଼ଚୁ ଜା଼ଜାତି ସା଼ଲୱି କିନାରି ଜା଼ଜାତା ମାଚି ଆ଼ସ୍ତିତି ସାମ୍‌ଦୁରିତା ମେତ୍‌ହାଲି ମା଼ଟ୍‌ହେରି, ");
INSERT INTO kxv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ଅ଼ଡ଼େ ତୀନିଦିନା ନେ଼ଚୁ ଏ଼ୱାରି ତାମି ଜା଼ଜାତି କଚେକା କା଼ଣ୍ତା ମୁଣ୍ତା ଏ଼ୟୁଣାଁ ମେତ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ହା଼ରେକା ଦିନା ପାତେକା ୱେ଼ଡ଼ା କି ହୁକାୟାଁ ମେସାଲି ଆ଼ଡାଆତମି, ଅ଼ଡ଼େ ହା଼ରେକା ଗା଼ଲି ପିୟୁ ପିହ୍‌ଆଲିଏ ମା଼ମ୍ବୁ ଇମ୍ବାଟି ଗେଲ୍‌ପିଆ଼ନି ଆ଼ସା ପିସାତୁସ୍ତମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ବାରେଜା଼ଣା ହା଼ରେକା ଦିନା ପାତେକା ରା଼ନ୍ଦା ତିନାଆନା ଡ଼ୟିତି ଡା଼ୟୁ, ପା଼ୱୁଲ ଏ଼ୱାରି ବିତ୍ରା ନିଚାନା ଏଲେଇଚେସି, “ବା଼ବୁୟାଁ ନା଼ କାତା ଆସାନା କ୍ରିତିଟି ସାମ୍‌ଦୁରି ଜା଼ଜା ହୁକ୍‌ହା ହିଲାଆତିହିଁ ମା଼ଦି ଏ଼ନାୟିୱା ନସ୍ତ ଆ଼ଆତେମା । ");
INSERT INTO kxv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ସାମା ନୀଏଁ ନା଼ନୁ ମିଙ୍ଗେ ୱେସିମାଞ୍ଜାଇଁ, ସା଼ସା ଆହ୍‌ଦୁ, ଇଚିହିଁ ମୀ ବିତ୍ରା ଆମ୍ବାଆରି ଜୀୱୁ ଜିକେଏ ନା଼ସା ଆ଼ଏ; ୱାର୍‌ଇ ଜା଼ଜାଦେ ନସ୍ତ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ଇଚିହିଁ ନା଼ନୁ ଏମିନି ମାହାପୂରୁତି ସେ଼ବା କିହିମାଇଁ, ନୀଞ୍ଜୁ ଲା଼ଆଁୟାଁ ଏ଼ୱାଣି ର଼ ଲାକପୂରୁତି ଦୂତୁ ନା଼ ଡାଗେ ୱା଼ହାନା ଏଲେଇଞ୍ଜାତେ, ");
INSERT INTO kxv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ଏ଼ ପା଼ୱୁଲ ‘ଆଜାଆନି; ନୀନୁ ସା଼ଲୱି କିନି କାୟିସର ନ଼କିତା ନିନାୟି ମାନେ, ମାହାପୂରୁ ନିଙ୍ଗେ କାର୍ମା ଆ଼ହାମାଞ୍ଜାନାକି ନୀ ତଲେ ୱା଼ହିମାନି ବାରେତି ଜୀୱୁ ଏ଼ୱାସି ଗେଲ୍‌ପିନେସି ।’ ");
INSERT INTO kxv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ଏ଼ଦାଆଁତାକି ଏ଼ ବା଼ବୁୟାଁତେରି ସା଼ସା ଆହ୍‌ଦୁ ଇଚିହିଁ ନା଼ନୁ ମାହାପୂରୁ ତା଼ଣା ନା଼ ନାମୁ ମାନେ, ନାଙ୍ଗେ ଏ଼ନିକିଁ ୱେସ୍‌ପି ଆ଼ହାମାନେ, ଏଲେଆ଼ହିଁଏ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ସାମା ମାଙ୍ଗେ ର଼ ସାମ୍‌ଦୁରି ମାଦିଏ ମାନି ଦେ଼ସାତା ଏଗାହାନାୟି ମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ଇଲେକିହିଁ ମା଼ମ୍ବୁ ଆଦ୍ରିଆ ସାମ୍‌ଦୁରି ଇତାଲା ଆତାଲା ଆ଼ହିଁ ରୀ ୱା଼ରା ଆୟାଲିଏ, ମାଦି ଲା଼ଆଁୟାଁ ଜା଼ଜା ସା଼ଲୱି କିନାରି ର଼ ବୂମି ଦାରିତା ଏଜିମାନାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ଏ଼ୟୁଣି ଲା଼ଚାଲିଏ ପନ୍ଦର ହା଼ତା ଏ଼ୟୁ କୂଡ଼୍‌ହା ମାଚୁ, ଇଞ୍ଜାଁ ଅ଼ଡ଼େ ନ଼କିତା ହାଜାନା ୱେଣ୍ତେ ଲା଼ଚାଲିଏ ଏଗାର ହା଼ତା ଏ଼ୟୁ କୂଡ଼୍‌ହା ମାଚୁ । ");
INSERT INTO kxv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ମା଼ର ହାଜାନା ଜା଼ଜା ୱାଲ୍‌କା ବୂମିତା ଗୁପିକିନାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା ଆଜିତାକି ଏ଼ୱାରି ଜା଼ଜାତି ଡା଼ୟୁୱାକି ସା଼ରିଗଟା ବ଼ଜୁ ଗାଟି ଲ଼ହ ମୁଣ୍ତାୟାଁ ରେ଼ପ୍‌ହାନା ଏଚେଲା ୱେ଼ୟିନେ ଇଞ୍ଜିଁ ପ୍ରା଼ତାନା କିହିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ଇଞ୍ଜାଁ ଜା଼ଜାତି ସା଼ଲୱି କିନାରି ଜା଼ଜାଟି ରେ଼ଚାନା ହଟାତୁସାଲି ଅଣ୍‌ପାନା ନା଼ଡ଼ିକିହାଁ ଜା଼ଜାତି ନ଼କିୱାକି ଲ଼ହ ମୁଣ୍ତାୟାଁ ରେ଼ପ୍‌ନି ଲେହେଁ ଊଣା ଡଂଗତି ସାମ୍‌ଦୁରିତା ରେ଼ପ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ସାମା ପା଼ୱୁଲ ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାଣାଇଁ ଇଞ୍ଜାଁ କ଼ସ୍‌କାଣି ଏଲେଇଚେସି, “ଜା଼ଜା ସା଼ଲୱି କିନାରି ଜା଼ଜାତା ମାନାଆତିହିଁ ମୀରୁ ଗେଲ୍‌ପିଆ଼ନି ଆ଼ସା ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ଏମ୍ବାଟିଏ ଜାମାନାଙ୍ଗା ଊଣା ଡଂଗତି ଡ଼଼ର୍କା ଦା଼ଚାନା ସାମ୍‌ଦୁରିତା ପିସ୍ତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ଲା଼ଇ ଜୁଲୁପୁଲୁ ୱେ଼ୟି ମାଚାଟି ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ଏ଼ନି ରା଼ନ୍ଦା ମାଚିହିଁ ତିଞ୍ଜାଲି ବା଼ର୍ସୁ ହୀହାନା ଏଲେଇଚେସି, “ନୀଞ୍ଜୁଟିଏ ରୀ ୱା଼ରା ଆ଼ତେ ମୀରୁ ଏ଼ନାଆଁ ତିନାଆନାହାଁ ହାକିଟିଏ ମାଞ୍ଜାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ବାତିମା଼ଲିମାଞ୍ଜାଇଁ, ନୀଏଁ ଇଚାଣି ତିଞ୍ଜୁ, ମୀ ଜୀୱୁ ଗେଲ୍‌ପାଲିତାକି ତିନାୟିମାନେ, ଆଜାଆଦୁ, ମୀ ତା଼ର୍କାତି ର଼ ବା଼ଣା ଜିକେଏ ନା଼ସା ଆ଼ଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ପା଼ୱୁଲ ଈ ବାରେ କାତା ଜ଼ଲାନା ରୂଟି ଆସାନା ବାରେଜା଼ଣା ନ଼କିତା ମାହାପୂରୁଇଁ ଜହରା କିହାନା ରୂଟି ଡ଼ିକ୍‌ହାନା ତିଞ୍ଜାଲି ମା଼ଟ୍‌ହେସି । ");
INSERT INTO kxv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ଏମ୍ବାଟିଏ ଏ଼ୱାରି ବାରେଜା଼ଣା ବା଼ର୍ସୁ ବେଟାଆ଼ହାନା ବାରେଜା଼ଣା କା଼ଦି ତିଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ମା଼ମ୍ବୁ ଜା଼ଜାତା ରୀ ୱାଞ୍ଜା ତୀନିକ଼ଡ଼ି ସ଼ଡ଼ ଜା଼ଣାତମି ମାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ଏ଼ୱାରି ପାଞ୍ଜେ ତିଚି ଡା଼ୟୁ ଜା଼ଜାତି ବ଼ଜୁ ଊଣା ଆ଼ପେୱା ଇଞ୍ଜିଁ ଜା଼ଜାତି ବାରେ ଗ଼ହଁୟାଁ ସାମ୍‌ଦୁରିତା ମେତ୍‌ହେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ଅ଼ର ନେ଼ଚୁ ଲା଼ଇ ୱେ଼ୟାଲିଏ ଏ଼ୱାରି ଏମିନି ଦେ଼ସାତି ଟା଼ୟୁତା ୱା଼ତେରି ପୁଞ୍ଜାଲି ଆ଼ଡାଆତେରି, ସାମା ଏ଼ୱାରି ଗାଟୁ ଦାରି ର଼ ବାଃଲି ଟା଼ୟୁ ମେସାନା ଏ଼ନିକିଁ ଜିକେଏ ଏମ୍ବାଆଁ ଜା଼ଜାତି ନିପ୍‌ହାଲି ଅଣ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଲ଼ହ ମୁଣ୍ତାୟାଁତି ଡ଼଼ର୍କା ଦା଼ଚାନା ସାମ୍‌ଦୁରିତା ମୁଞ୍ଜାଲି ପିସ୍ତେରି, ଇଞ୍ଜାଁ ଦେବୁଣିଏ ଏ଼ୟୁ ଜା଼ଜାତି ହାଟୱା ବାଡ଼୍‌ଗାୟାଁତି ଡ଼଼ର୍କା ବାରେ ହୁକ୍‌ହାନା ଜା଼ଜା ନ଼କିତା ଗା଼ଲିୱାକି ହିମ୍ବରିକା ଗ଼ଞ୍ଜାନା ଗାଟୁୱାକି ହାଜାଲି ଅଣ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ସାମା ଏ଼ୱାରି ରୀ ସାମ୍‌ଦୁରିକା କା଼ଲ୍‌ୱି ଆ଼ହିମାନି ଟା଼ୟୁତା ଏଜାଲିଏ ଜା଼ଜା ସାମ୍‌ଦୁରି ଗାଟୁତି ର଼ ବାଃଲି ଡିବାତା ଗୁପିତେ, ଜା଼ଜାତି ନ଼କି ୱାକିତାୟି ଜାଣ୍ତାନା ଡ଼ୟାହାଚେ, ସାମା ଡା଼ୟୁତାୟି ସାମ୍‌ଦୁରିତି ଏ଼ୟୁ ଉଣ୍ତାୟାଁ ଗୁପାଲିଏ ଡୀହାଲି ମା଼ଟ୍‌ହେ । ");
INSERT INTO kxv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","କାୟିଦି ଗାଟାରି ସାମ୍‌ଦୁରି ଗାଟୁଟି ପ଼ର୍‌ହିଁ ପ଼ର୍‌ହିଁ ହଣ୍‌ନେରି ଇଞ୍ଜିଁ ଅଣ୍‌ପାନା କ଼ସ୍‌କା ଏ଼ୱାରାଇଁ ପା଼ୟାଲି ଅଣ୍‌ପିତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ସାମା ପା଼ସାକ଼ଡ଼ି କ଼ସ୍‌କା ମୁହେଁ କାଜାସି ପା଼ୱୁଲଇଁ ଗେଲ୍‌ପାଲି ମ଼ନ କିହାନା, ଏ଼ୱାରି ଅଣ୍‌ପୁତି କା଼ହି କିହାନା ଏଲେଇଞ୍ଜି ହୁକୁମି ହୀତେସି, ଆମ୍ବାଆସି ପ଼ର୍‌ହାଲି ପୁନାସି ଏ଼ୱାସି ସାମ୍‌ଦୁରିତା ଡେ଼ୱାଁନା ତଲିଏ ଗାଟୁତା ହାଲାପେରି; ");
INSERT INTO kxv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ଡ଼ୟାମାନାରି ଜା଼ଜାତି ମା଼ର୍‌କା ପା଼ଟାୟାଁ ଇଞ୍ଜାଁ ଏ଼ନି ଏ଼ନି ଡୀତି ମୁକାୟାଁ ଆସାନା ହାଲାପେରି ଇଞ୍ଜାଲିଏ, ଇଲେକିହିଁ ବାରେଜା଼ଣା ନେହିଁ ଆ଼ହିଁ ଗାଟୁତା ଏତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ମା଼ମ୍ବୁ ଏମ୍ବାଟି ଗେଲ୍‌ପିଆ଼ତି ଡା଼ୟୁ ସାମ୍‌ଦୁରି ମାଦି ମାନି ଟା଼ୟୁ ମେଲିତି ଇଞ୍ଜିହିଁ ପୁଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ଏମ୍ବାଆଁ ବାସାଆ଼ହାମାନି ପାଙ୍ଗାତି ଲ଼କୁ ମାଙ୍ଗେ ତ଼ଣେସିଙ୍ଗା ଲେହେଁ କାର୍ମା ଆୟାତେରି, ଇଚିହିଁ ପିୟୁ ଇଞ୍ଜାଁ ପେନି ଆ଼ହିମାଚାକି ଏ଼ୱାରି ମାଙ୍ଗେ ହିଚୁ ଡାସାନା କେର୍‌ଞ୍ଜାଲି ହିୟାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ସାମା ପା଼ୱୁଲ ର଼ ପେ଼ଣ୍ତା ୱେସ୍‌କା ହିଚୁତା କୁମ୍ବାଲିଏ, ଉସମି ତାକି ର଼ ରା଼ଚୁ ହ଼ଚାନା ପା଼ୱୁଲ କେୟୁତା କାଚାହାଁ ଆଟା ଡ଼ୟିତେ । ");
INSERT INTO kxv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ଏମ୍ବାଆଁ ବାସା ଆ଼ହାମାଚି ପାଙ୍ଗାତି ଲ଼କୁ ପା଼ୱୁଲ କେୟୁତା ଏ଼ ରା଼ଚୁ ଲେ଼ଜା ମାନାଣି ମେସାନା ତା଼ମ୍ବୁ ତା଼ମ୍ବୁ ୱେସ୍‌ପି ଆ଼ତେରି, “ଈ ମାଣ୍‌ସି ସାତେଏ ଲ଼କୁଣି ପା଼ୟିନାସି, ସାମ୍‌ଦୁରିଟି ଗେଲ୍‌ହାଲିଏ ଜିକେଏ ଦାର୍ମୁ ନୀଡାଲି ହୀହି ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ସାମା ପା଼ୱୁଲ ଏ଼ ରା଼ଚୁତି ହିଚୁତା ହାଣ୍‌ହାଁନା ମେତ୍‌ହା ତୁସ୍ତେସି, ଇଞ୍ଜାଁ ଏ଼ୱାଣାକି ଏ଼ନି ନସ୍ତ ଆ଼ଆତେ । ");
INSERT INTO kxv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ଏ଼ୱାଣି ଆଙ୍ଗା ପଙ୍ଗା ହାନେ ଆ଼ଆତିଁ ଦେବୁଣିଏ ହା଼ନେସି ଇଞ୍ଜିଁ କା଼ଚିମାଚେରି; ସାମା ହା଼ରେକା ବେ଼ଲା ଆ଼ତି ଡା଼ୟୁ ଏ଼ୱାଣାକି ଏ଼ନି ନସ୍ତ ଆ଼ଆତାଣି ମେସାନା ଏ଼ୱାରି ତାମି ହିୟାଁ ୱେଟ୍‌ହାନା ଏଲେଇଚେରି, “ଈୱାସି ର଼ ମାହାପୂରୁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ଏ଼ ଟା଼ୟୁ ଡାଗେ ପୁବ୍ଲିୟ ଦ଼ରୁଗାଟି ଏ଼ ଟା଼ୟୁତି କାଜାଣି ଇଲୁ ଅ଼ଡ଼େ ବୂମି ମାଚେ; ଏ଼ୱାସି ମାଙ୍ଗେ ହା଼ଟା ଅ଼ହାନା ତୀନିଦିନା ପାତେକା କାର୍ମା ଆ଼ହାନା ରା଼ହାଁଟି ସେ଼ବା କିୟାତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ଏଚିବେ଼ଲାତା ପୁବ୍ଲିୟ ତାମି ଆ଼ବା ନ଼ମେରି ଇଞ୍ଜାଁ ନେତେରି ବାଣ୍ତି ତାକି ପା଼ସ୍‌ପନିତା ଡୂରାମାଚେସି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ ତାନି ବାକ୍ରାତା ହାଜାନା ପ୍ରା଼ତାନା କିହାନା ତାନି ଲାକ କେୟୁ ଇଟାନା ନେହିଁ କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ଈଦି ଆ଼ତି ଡା଼ୟୁ ଏମ୍ବାଆଁ ମାନି ର଼ଗ ଗାଟାରି ବାରେ ପା଼ୱୁଲ ତା଼ଣା ୱା଼ହାନା ନେହିଁ ଆ଼ତେରି; ");
INSERT INTO kxv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ଏ଼ୱାରି ମାଙ୍ଗେ ଜିକେଏ ହା଼ରେକା ମା଼ନି ତଲେ ଜୀୱୁ ନୟାଁତେରି, ଅ଼ଡ଼େ ମା଼ମ୍ବୁ ହାଜିମାଚାଟି ମା଼ ଲ଼ଡ଼ାମାନାଣି ହୀହାନା ପାଣ୍ତାତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ତୀନି ଲେ଼ଞ୍ଜୁ ଜେ଼ଚ ମା଼ମ୍ବୁ ର଼ ଆଲେକ୍‌ଜାଣ୍ତ୍ରିୟାତି ଏ଼ୟୁ ଜା଼ଜାତା ହ଼ଚାନା ହାଚମି, ଏ଼ୟୁ ଜା଼ଜା ପେନିବେ଼ଲା ହାଲ୍‌ୱେ ଏ଼ ଟା଼ୟୁତା ଡ଼ୟାମାଚେ, ଏ଼ଦାନି ଦ଼ରୁ “ଜା଼ଣ୍‌ୱା ପେ଼ଣ୍‌କା,” ଇଞ୍ଜିମାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ସୁରାକୁସା ଗା଼ଡ଼ାତା ଏଜାନା ଏମ୍ବାଆଁ ମା଼ମ୍ବୁ ତୀନିଦିନା ମାଚମି । ");
INSERT INTO kxv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ଅ଼ଡ଼େ ଏମ୍ବାଟି ଏ଼ୟୁ ଜା଼ଜା ତଲେ ହାଜାନା ରେଗିୟା ଗା଼ଡ଼ାତା ଏତମି, ତାନି ଅ଼ର ଦିନା ଟିଃନି ୱାକିଟି ଗା଼ଲି ୱେ଼ଚାଲିଏ ଅ଼ଡ଼େ ରୀ ଦିନା ଡା଼ୟୁ ପୁତେଅଲି ଗା଼ଡ଼ାତା ଏତମି; ");
INSERT INTO kxv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ଏମ୍ବାଆଁ ମା଼ମ୍ବୁ ଏଚେକା କ୍ରୀସ୍ତାନା ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କାଣି ବେଟାଆ଼ତମି, ଏ଼ୱାରିତଲେ ର଼ ୱା଼ରା ଡ଼ୟାଲି ମାଙ୍ଗେ ବାତିମା଼ଲାତେରି; ଇଲାଆ଼ହିଁ ମା଼ମ୍ବୁ ର଼ମ୍‌ତା ଏଗାତମି । ");
INSERT INTO kxv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ର଼ମ୍‌ତା ମାନି ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କା ମା଼ କାବ୍ରୁ ପୁଞ୍ଜାନା ଏମ୍ବାଟିଏ ଅପିୟତି ହା଼ଟା ଇଞ୍ଜାଁ ତୀନିଗଟା ବା଼ଡ଼ା ଇଲ୍‌କା ପାତେକା ମାଙ୍ଗେ ମେସାଲି ୱା଼ତେରି, ଇଞ୍ଜାଁ ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ମେସାନା ମାହାପୂରୁଇଁ ଜହରା କିହାନା ବା଼ର୍ସୁ ବେଟାଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ମା଼ମ୍ବୁ ର଼ମ୍‌ ଏଜାଲିଏ, ପା଼ୱୁଲଇଁ କା଼ଃଆନି କ଼ସ୍‌କା ତଲେ ତାନି ମ଼ନତଲେ ବାସା ଆୟାଲି ହେଲ ହୀପ୍‌କିଆ଼ତେ । ");
INSERT INTO kxv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ତୀନିଦିନା ଡା଼ୟୁ ପା଼ୱୁଲ ଜୀହୁଦିୟାଁତି କାଜାରାଇଁ ହା଼ଟାନା କୂଡ଼ି କିତେସି, ଅ଼ଡ଼େ ଏ଼ୱାରି ରୁଣ୍ତା ଆୟାଲିଏ, ପା଼ୱୁଲ ଏ଼ୱାରାଇଁ ଏଲେଇଚେସି, “ଏ଼ ଇସ୍ରାୟେଲ ତାୟିୟାଁତେରି ନା଼ନୁ ମା଼ ଲ଼କୁ କ଼ପାଟି କି ମା଼ ଆକୁ ଆ଼ବାୟାଁତି ପା଼ଣାପା଼ଟୁ କ଼ପାଟି ଏ଼ନାଆଁ କିହା ହିଲାଆତି ଜିକେଏ ଜିରୁସାଲମତା ଦସ୍‌ପି ଆ଼ହାନା ର଼ମ୍‌ ଦେ଼ସାତି ଲ଼କୁତା଼ଣା ହେର୍‌ପି ଆ଼ହାମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ଏ଼ୱାରି ନାଙ୍ଗେ ନୀହାଁୟି କିହାନା ନା଼ ତା଼ଣାଟି ହା଼ନି ଡଣ୍ତ ପା଼ଣ୍‌ନି ଏ଼ନି ଦ଼ହ ବେଟାଆ଼ଆଲିଏ ନାଙ୍ଗେ ପିସାଲି ଅଣ୍‌ପାମାଚେରି; ");
INSERT INTO kxv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ସାମା ଜୀହୁଦିଙ୍ଗା ଏ଼ଦାଣି କ଼ପାଟି ୱେସାଲିଏ ନା଼ନୁ କାୟିସର ନ଼କିତା ନୀହାଁୟି କିୟାଦୁ ଇଞ୍ଜିଁ ବାତିମା଼ଲିତେଏଁ; ଏଲେଆ଼ତି ଜିକେଏ ନାଙ୍ଗେ ମା଼ ଲ଼କୁ କ଼ପାଟି ଏ଼ନି କାତା ୱେସାଲି ହିଲାଆତେ, ଏ଼ଦି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମିଙ୍ଗେ ନା଼ ତଲେ ବେଟାଆ଼ହାନା ଜ଼ଲ୍‌କି ଆ଼ହାଲି ବାତିମା଼ଲାତେଏଁ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଆମ୍ବାଆରି ଲାକ ଇସ୍ରାୟେଲ ଲ଼କୁ ବା଼ର୍ସୁ କିହାମାନେରି, ଏ଼ୱାରି ତାକି ନା଼ନୁ ନୀଞ୍ଜୁ ଈ ହିକ୍‌ଣିୟାଁ ତଲେ ଦସ୍‌ପି ଆ଼ହାମାଇଁ ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ଏ଼ୱାରି ଏଲେଇଚେରି, “ମା଼ମ୍ବୁ ଜୀହୁଦା ଦେ଼ସାଟି ନୀ କ଼ପାଟି ଏ଼ନି ଆ଼କୁ ବେଟାଆ଼ହା ହିଲଅମି, ଅ଼ଡ଼େ ନୀ କାବ୍ରୁ ଆସାନା କି ନୀ କ଼ପାଟି ଦ଼ହ ଦସାନା ୱେସାଲି ମା଼ ତାୟିୟାଁ ବିତ୍ରାଟି ଆମ୍ବାଆରି ଇମ୍ବାଆଁ ୱା଼ହାହିଲଅରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ସାମା ନୀ ଅଣ୍‌ପୁ ଏ଼ନାୟି ଏ଼ଦାଆଁ ମା଼ମ୍ବୁ ନୀ ତା଼ଣାଟି ୱେଞ୍ଜାଲି ମ଼ନ କିହିମାନମି, ଇଚିହିଁ ବାରେୱାକିତି ଲ଼କୁ ଈ ଗଚି କ଼ପାଟି କାତା ୱେସିମାନେରି ଇଞ୍ଜିଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜିମାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ଏଚେଟିଏ ଏ଼ୱାରି ର଼ ଦିନା ତୀରି କିହାନା ହା଼ରେକା ଲ଼କୁ ପା଼ୱୁଲ ମାଚି ଇଲୁତା ୱା଼ତେରି, ଅ଼ଡ଼େ ଏ଼ୱାସି ଲା଼ଇଟିଏ ଲା଼ଆଁ ପାତେକା ଏ଼ୱାରି ନ଼କିତା ମାହାପୂରୁତି ରା଼ଜିତି କାତାତାକି ସା଼କି ହୀତେସି, ଅ଼ଡ଼େ ମ଼ସାତି ମେ଼ରା ଇଞ୍ଜାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି କାତା ଆସାନା ଏ଼ୱାସି ଜୀସୁଇଁ ନାମି କିୱି କିୟାଲି ଅଣ୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ଏମ୍ବାଟିଏ ଆମ୍ବା ଆମ୍ବାଆରି ତାନି ୱେସ୍ତି କାତାତି ନାମିତେରି ଇଞ୍ଜାଁ ଆମ୍ବା ଆମ୍ବାଆରି ନାମାଆତେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ଏ଼ କାତାତାକି ଏ଼ୱାରି ତାମି ବିତ୍ରା ରଣ୍ତିଏ କାତା ଆ଼ଆଲିଏ ହେଲ ଅ଼ତେରି; ଏ଼଼ୱାରି ହାନି ନ଼କେଏ ପା଼ୱୁଲ ର଼ କାତା ୱେସ୍ତେସି, “ସୁଦୁଜୀୱୁ ମୀ ଆକୁ ଆ଼ବାୟାଁଣି ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନି ଜିସାୟ ତା଼ଣାଟି ୱେସାମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ଏ଼ୱାସି ଏଲେଇଞ୍ଜି ମାନେସି, “ଈ ଲ଼କୁତା଼ଣା ହାଜାନା ୱେହ୍‌ମୁ, ମୀରୁ ୱେଞ୍ଜିୱେଞ୍ଜି ୱେଞ୍ଜେରି, ସାମା ଏ଼ନାଆଁ ତେଲ୍‌ହଅ ତେରି, ଇଞ୍ଜାଁ ମୀରୁ ମେସି ମେସି ମେହ୍‌ଦେରି, ସାମା ଏ଼ନାଆଁ ପୁଞ୍ଜାଲି ଆ଼ଡଅତେରି, ");
INSERT INTO kxv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ଇଚିହିଁ ଈ ଲ଼କୁ ହିୟାଁତା ଊଣା ବୁଦିଗାଟାରି, ଏ଼ୱାରି ଜାହା ଜାହାରା କୀର୍କା କାଣ୍‌କା ମୁଚା କଡାମାନେରି, ଏଲେଆ଼ହାଁ ହିଲାଆତିହିଁମା, ଏ଼ୱାରି କାଣ୍‌କା ଦେଚାନା ମେସାଲି ଆ଼ଡିତେରିମା, ଅ଼ଡ଼େ କୀର୍କା ତଲେ ୱେଞ୍ଜାଲି ଆ଼ଡିତେରିମା । ଏ଼ୱାରି ହିୟାଁତା ତେଲ୍‌ହାଲି ଆ଼ଡିନି ବା଼ଡ଼୍‌ୟୁ ଡ଼ୟିତେମା; ଏ଼ୱାରି ମାହାପୂରୁ ୱାକି ୱେଣ୍ଡା ୱା଼ତେରିମା, ଅ଼ଡ଼େ ନା଼ନୁ ଏ଼ୱାରାଇଁ ନେହିଁ କିତେଏଁମା ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ଡା଼ୟୁ ପା଼ୱୁଲ ଏଲେଇଚେସି, “ଏ଼ଦାଆଁତାକି ମାହାପୂରୁତି ଈ ଗେଲ୍‌ପିନାଣି ଏଟ୍‌କା କୂଡ଼ାତି ଲ଼କୁତା଼ଣା ପାଣ୍ତ୍‌ୱି ଆ଼ହାମାନେ, ଈଦାଆଁ ମୀରୁ ପୁଞ୍ଜୁ; ଏ଼ୱାରି ଜିକେଏ ୱେନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ପା଼ୱୁଲ ଈ ବାରେ କାତା ୱେସାଲିଏ, ଜୀହୁଦିୟାଁ ତା଼ମ୍ବୁ ତାମି ବିତ୍ରା ବା଼ଦିବା଼ଦା ଆ଼ହିଁ ହାଚେରି । ");
INSERT INTO kxv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ପା଼ୱୁଲ ରୀ ବାର୍ସା ପାତେକା ତାନି ବା଼ଡ଼ା ଇଲୁତା ଡ଼ୟିତେସି, ଅ଼ଡ଼େ ଏଚେକା ଲ଼କୁ ଏ଼ୱାଣି ତା଼ଣା ୱା଼ହିମାଚେରି, ବାରେତି ଇଜ ହା଼ଟା ଅ଼ହିମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ଇଞ୍ଜାଁ ସା଼ସାତଲେ ନୀରାସା ଆ଼ଆନା ମାହାପୂରୁ ରା଼ଜିତି କାତା ୱେସିମାଚେସି, ଇଞ୍ଜାଁ ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତତି କାତା ଜା଼ପ୍‌ହି ମାଚେସି ।");
INSERT INTO kxv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","କ୍ରୀସ୍ତ ଜୀସୁତି ହ଼ଲେଏସି ଅ଼ଡ଼େ ମାହାପୂରୁ ହୀହାମାନି ନେହିଁ ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ପାଣ୍ତ୍‌ୱି ଆ଼ହାଁ ଆ଼ଚାନା ହା଼ଟ୍‌କି ଆ଼ହାମାନି ସୀସୁ ପା଼ୱୁଲତି ଆ଼କୁ । ");
INSERT INTO kxv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନି ଲେହେଁ ଈ ନେହିଁ କାବ୍ରୁତି କାତା ତଲି କା଼ଲାଟିଏ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ତା଼ଣାଟି ଆ଼ଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ଈଦି ମାହାପୂରୁ ମୀର୍‌ଏଣାତି କାତା, ମା଼ ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତ ମାଣ୍‌ସି ଆ଼ହାଁ ଏ଼ୱାସି ଦାୱୁଦ କୂଡ଼ାତା ଜାର୍ନା ଆ଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ସାମା ତାନି ଲାକପୂରୁତି ସୁଦୁଜୀୱୁ ତାକି, କାଜା ହା଼କିଟି ନିଙ୍ଗାନା ଏ଼ୱାସି ବା଼ଡ଼୍‌ୟୁ ତଲେ ଜୀସୁ ମାହାପୂରୁତି ମୀର୍‌ଏସି ମସିହା ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିତେସି, ");
INSERT INTO kxv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","କ୍ରୀସ୍ତ ତାକି, ମାହାପୂରୁ ନାଙ୍ଗେ ପାଣ୍ତ୍‌ୱିଆ଼ହାମାନି ସୀସୁ ଲେହେଁ ହା଼ଟାନା, ବାରେ କୂଡ଼ାତି ଲ଼କୁତା଼ଣା ନେହିଁ ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ପାରୁ ହୀହାମାଞ୍ଜାନେସି, ଏ଼ନିକିହିଁ ଏ଼ୱାରି କ୍ରୀସ୍ତ ଜୀସୁ ତା଼ଣା ନାମାନା ତାଙ୍ଗେ ମା଼ନୱି ଆ଼ହାନା ଡ଼ୟିନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ର଼ମ୍‌ ଗା଼ଡ଼ାତା ବାସାଆ଼ହାମାନି ଲ଼କୁତେରି, ମୀରୁ ଜିକେଏ ଜୀସୁ କ୍ରୀସ୍ତତି ଲ଼କୁ ଆ଼ହାଲି ହା଼ଟ୍‌କି ଆ଼ହାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ର଼ମ୍‌ତି ଆମିନି ଲ଼କୁଣି ମାହାପୂରୁ ଜୀୱୁ ନ଼ହାମାନେସି ଇଞ୍ଜାଁ ତାନି ଲ଼କୁ ଆ଼ହାଲିତାକି ହା଼ଟାମାନେସି, ଏ଼ ବାରେ ଲ଼କୁତାକି ନା଼ନୁ ଈ ଆ଼କୁ ରା଼ଚିମାଇଁ, ମା଼ ଆ଼ବା ମାହାପୂରୁ ଅ଼ଡ଼େ ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣାଟି ମିଙ୍ଗେ କାର୍ମାମେହ୍‌ନାୟି ଅ଼ଡ଼େ ହିତ୍‌ଡ଼ି ଆୟାପେ । ");
INSERT INTO kxv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ମୂଲୁଏ, ମୀ ନାମୁତି ନେହିଁ ହା଼ଡା ବାରେ ଦାର୍‌ତିତା ୱେ଼ଙ୍ଗିମାନେ, ଏ଼ଦାଆଁତାକି ନା଼ନୁ ମୀ ବାରେଜା଼ଣା ତାକି ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣାଟି ନା଼ ମାହାପୂରୁଇଁ ଜହରା କିହିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ନା଼ ବାରେ ହିୟାଁ ଜୀୱୁତଲେ ନା଼ନୁ ଆମିନି ମାହାପୂରୁତି ସେ଼ବା କିହିମାଇଁ ଇଞ୍ଜାଁ ଆମିନି ମାହାପୂରୁତି ମୀର୍‌ଏଣାତି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହିମାଇଁ, ଏ଼ ମାହାପୂରୁ ନା଼ ସା଼କି । ");
INSERT INTO kxv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ପ୍ରା଼ତାନା କିନାଟି ନା଼ନୁ କା଼ଲେଏ ମିଙ୍ଗେ ଅଣ୍‌ପାଇଁ ଇଞ୍ଜାଁ ମୀ ତା଼ଣା ୱା଼ହାଲି ନାଙ୍ଗେ ପାରୁ ହିୟାନି ମାହାପୂରୁ ତା଼ଣା ବାତିମା଼ଲିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ଇଚିହିଁ ନା଼ନୁ ମିଙ୍ଗେ ଆଣ୍ତାଲି ହା଼ରେକା ମ଼ନ କିହିମାଇଁ, ଇଞ୍ଜାଁ ମିଙ୍ଗେ ର଼ ଜୀୱୁତି ବ଼ର ହିୟାଇଁ, ଏ଼ନିକିଁ ମୀରୁ ତୀରିଆ଼ହାନା ମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ଈଦାଆଁ ତଲେ ମା଼ର ରଅତୱି ରଅଣା ନାମୁତି ଆ଼ଟ୍‌ୱା କିହାଲି ଆ଼ଡିନାୟି । ");
INSERT INTO kxv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ଏ଼ ତାୟିୟାଁ ଅ଼ଡ଼େ ତାଙ୍ଗିସ୍କାତେରି, ମୀ ତା଼ଣା ୱା଼ହାଲି ତାକି ନା଼ନୁ ହା଼ରେକା ଦେବା ଅଣ୍‌ପାମାଇଁ, ସାମା ହା଼ରେକା ବା଼ଦା ବେଟାଆ଼ତାକି, ନୀଏଁ ପାତେକା ୱା଼ହାଲି ଆ଼ଡାଆତେଏଁ । ଏଟ୍‌କା କୂଡ଼ାତି ଲ଼କୁତା଼ଣା ଜିକେଏ ବ଼ଲୁ ୱେ଼କ୍‌ହାନା ଏ଼ନିକିହିଁ ପା଼ଡ଼େୟି ବେଟାଆ଼ହାମାଇଁ, ମୀ ତା଼ଣା ଜିକେଏ ଏଲେକିହାଲି ନା଼ ଅଣ୍‌ପୁ । ");
INSERT INTO kxv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ବୁଦିଗାଟାରି ଅ଼ଡ଼େ ପାଙ୍ଗାତାରି ଜା଼ପିତାରି ଅ଼ଡ଼େ ଜା଼ପାଆତି ଲ଼କୁ ବାରେ ଗଚିତି ଲ଼କୁତାକି ନା଼ ଦାୟିପତି ମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ଏ଼ଦାଆଁତାକି ର଼ମ୍‌ ଗା଼ଡ଼ା ତାତେରି ମୀରୁ, ମୀ ତା଼ଣା ଜିକେଏ ନେହିଁ ବ଼ଲୁ ୱେ଼କ୍‌ହାଲି ନା଼ ଅଣ୍‌ପୁ । ");
INSERT INTO kxv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ଇଚିହିଁ ନା଼ନୁ ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି ଲାଜା ଆ଼ଅଁ, ଏ଼ଦି ନାମିମାନି ବାରେ ଲ଼କୁତାକି ଗେଲ୍‌ପି ଆ଼ହାଲିତାକି ମାହାପୂରୁତି ବା଼ଡ଼୍‌ୟୁ, ମୂଲୁଏ ଜୀହୁଦି ଅ଼ଡ଼େ ଡା଼ୟୁ ଜୀହୁଦିଆ଼ଆତି ନାମିତି ଲ଼କୁତାକି । ");
INSERT INTO kxv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ମାଣ୍‌ସି ଏ଼ନିକିହିଁ ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ତ଼ଞ୍ଜାଆ଼ନେସି, ଏ଼ ଊପେୟି ଏମ୍ବାଆଁ ତ଼ସ୍‌ପି ଆ଼ହାମାନେ । ମୂଲୁଟିଏ ରା଼ନି ପାତେକା ଗେଲ୍‌ପିଆ଼ନାଣି ବେଟାଆ଼ନି ଊପେୟି ନାମୁ । ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ଦାର୍ମୁଗାଟାସି ନାମୁତଲେ ନୀଡିନେସି ।” ");
INSERT INTO kxv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ଆମିନି ଲ଼କୁ ବାରେ ଲାଗେଏ କାମାଟି ସାତାଇଁ ଆ଼ଙ୍ଗିମାନେରି, ଏ଼ୱାରି କ଼ପାଟି ଲାକପୂରୁଟି ମାହାପୂରୁତି କାର୍‌ବି ତ଼ଞ୍ଜା ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁତି କାତା ଏ଼ନାଆଁ ପୁନାୟି ମାଚେ, ଏ଼ଦାଆଁ ଏ଼ୱାରି ପୁଞ୍ଜାମାନେରି, ମାହାପୂରୁ ଏ଼ୱାରି ନ଼କିତା ଏ଼ଦାଆଁ ୱେସାମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ମାହାପୂରୁ ଦାର୍‌ତି ଗା଼ଡ଼ିକିତି ତା଼ଣାଟିଏ, ତାନି ତ଼ଞ୍ଜା ଆ଼ଆଗାଟି ଗୂଣୁୟାଁ, ତାନି ରା଼ଆଗାଟି ବା଼ଡ଼୍‌ୟୁ ଅ଼ଡ଼େ ଲାକପୂରୁତି ଗୂଣୁ, ନେହିଁକିଁ ତ଼ଞ୍ଜା ଆ଼ହିମାନୁ; ତାନି ଗା଼ଡ଼ିକିତାଆଁ ବାରେ ଏ଼ୱାଆଁ ମେସାଲି ଆ଼ଡିନାୟି । ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ପୁଞ୍ଜାହିଲଅମି ଇଞ୍ଜିଁ ଇଞ୍ଜାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ଏ଼ୱାରି ମାହାପୂରୁଇଁ ପୁଞ୍ଜା ଜିକେଏ ଏ଼ୱାଣାଇଁ ଗାୱୁରମି କିଆତେରି କି ଏ଼ୱାଣାଇଁ ଜହରା କିଆତେରି । ସାମା ଏ଼ୱାରି ଅଣ୍‌ପୁ ବାରେ ଉଜେଏତି ଅଣ୍‌ପୁ ଅ଼ଡ଼େ ଏ଼ୱାରି ତେଲ୍‌ହାଆଗାଟି ମ଼ନ ଆନ୍ଦେରି ଆ଼ହାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ଏ଼ୱାରି ଜାହାରାଇଁ ବୁଦିଗାଟାତମି ଇଞ୍ଜିଁ ଇନେରି, ସାମା ସାତା ତଲେ ଏ଼ୱାରି ବୁଦି ହିଲାଆ ଗାଟାରି; ");
INSERT INTO kxv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ଅ଼ଡ଼େ ନା଼ସା ଆ଼ଆଗାଟି ମାହାପୂରୁତି ଗାୱୁରମିତି ନା଼ସା ଆ଼ନି ମାଣ୍‌ସି, ସା଼ରିଗଟା କଡାୟାଁ ଗାଟି ଜ଼ନ୍ତ, ପଟାୟାଁ ଅ଼ଡ଼େ ରା଼ସ୍‌କା କୂଡ଼ାତି ବମାୟାଁ କିହାନା ଏ଼ୱାଆଁତି ପୂଜା କିହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ଏ଼ଦାଆଁତାକି ମାହାପୂରୁ ଏ଼ୱାରାଇଁ ହିୟାଁତି ଲାଗେଏତି ଜୂପ୍‌କାତାକି ଏ଼ୱାରାଇଁ ଲାଗେଏତି ତା଼ଣା ହେର୍‌ପିତେସି, ଏ଼ନିକିହିଁ ଏ଼ୱାରି ଆଙ୍ଗା ରଅସି ରଅଣି ତଲେ ଲାଜାଗାଟି କାମା କିହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ଏ଼ୱାରି ମାହାପୂରୁ କାତାତି ସାତା ପିସାନା ମିଚିତି ବା଼ର୍ସୁ କିହିମାନେରି । ଗା଼ଡ଼ିକିତି ମାହାପୂରୁଇଁ ପୂଜା କିଆନା, ଗା଼ଡ଼ିଆ଼ତି ଦିଣ୍‌ସୁ ପୂଜା କିହିମାନେରି; ଏ଼ ଗା଼ଡ଼ି କିତାଣାଇଁ କା଼ଲାକା଼ଲାତାକି ଜହରା । ଆ଼ମେନ୍‌ । ");
INSERT INTO kxv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ଏ଼ୱାରି ଏଲେକିତାକି ମାହାପୂରୁ ଏ଼ୱାରାଇଁ ଲାଜାଗାଟି ପା଼ପୁ କାମାତା ହେର୍‌ପିତେସି, ଇଚିହିଁ ଏ଼ୱାରି ଡକ୍ରିସିକା ଡକ୍ରାୟାଁ ତଲେ କୂଡ଼ାଲି ପିସାନା ଏ଼ୱି ତା଼ମ୍ବୁ ତା଼ମ୍ବୁଏ କିଆଗାଟି ଲାଜା କାମାୟାଁ କିତୁ ");
INSERT INTO kxv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ଏଲେକିହିଁଏ ଆ଼ବାୟାଁ ଜିକେଏ ଜାହାରା ଡକ୍ରି ତଲେ କୂଡ଼ାଆନା ଜାହା ଜାହାରା ବିତ୍ରା ଲାଗେଏତି କାମା କିତେରି । ଆ଼ବା ଆ଼ବାୟାଁ ତଲେ ଲାଜା ଆ଼ନି କାମା କିତେରି, ଏ଼ଦାଆଁତାକି ଏ଼ୱାରି ଲାଗେଏ କାମାତି ଡଣ୍ତ ବେଟା ଆ଼ହିମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ଅ଼ଡ଼େ ଏ଼ନିକିଁ ଏ଼ୱାରି ମାହାପୂରୁତି ବୁଦିତି କୂହାଲିଏ, ଏଲେକିହିଁଏ ମାହାପୂରୁ କିଆଗାଟି କାମା କିହାଲି ଏ଼ୱାରାଇଁ ଲାଗେଏତି ଅଣ୍‌ପୁତା ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ଏ଼ୱାରି ଦାର୍ମୁ ହିଲାଆଗାଟାୟି, ଲାଗେଏ ପ଼ଲେଏ, ଜୂପ୍‌କା ଅ଼ଡ଼େ ଈର୍‌ସା, ଲ଼କୁଇଁ ପା଼ୟିନାୟି, ଗଡ଼୍‌ହା କିନାୟି, ନା଼ଡ଼ିକିନାୟି ଅ଼ଡ଼େ ଲାଗେଏତି କାମା ନେଞ୍ଜାମାନେ; ");
INSERT INTO kxv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ଏ଼ୱାରି ଊତୁପାତି, ନିନ୍ଦା କିନାରି, ମାହାପୂରୁଇଁ ଅ଼ପାଆଗାଟାୟି, ଲାଗେଏତି କାମା କିନାୟି, ଏ଼ୱାରି ଲାଗେଏ କାମା କିହାଲି ପାରୁ ପାରିନେରି; ଏ଼ୱାରି ତାଲି ତାଞ୍ଜିଇଁ ମା଼ନି କିଆଗାଟାରି, ");
INSERT INTO kxv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ଏ଼ୱାରି ବୁଦି ହିଲାଆ ଗାଟାରି, ଜାହାରା ହୀତିକାତା ଆହ୍‌ଅରି । ଇଞ୍ଜାଁ ଏଟ୍‌କାତାରାକି ଇଚାଣି କାର୍ମା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ଏ଼ୱାରି ପୁଞ୍ଜାମାନେରି, ମାହାପୂରୁତି ମେ଼ରା ଲେହେଁ ଇଲେତି ଲ଼କୁ ହା଼ନି ଡଣ୍ତ ପା଼ଣ୍‌ନାୟି ମାନେ, ଈଦାଆଁ ପୁଞ୍ଜାହାଁ ଜିକେଏ ଏ଼ୱାରି ଏଲେକିହିଁଏ ଲାଗେଏତି କାମା କିହେ଼ମାନେରି, ଅ଼ଡ଼େ ଏଲେତି କାମା କିହିମାନି ଲ଼କୁତଲେ ରା଼ହାଁତଲେ ଆଣ୍ଡିନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ଏ଼ ତାୟି ଅ଼ଡ଼େ ତାଙ୍ଗି, ମୀମ୍ବୂ ଏ଼ନାଆଁ ଏଟ୍‌କା ଲ଼କୁଣି ନୀହାଁୟି କିହିମାଞ୍ଜେରି ? ମୀରୁ ଆମ୍ବାଆତେରି ଆ଼ତିଜିକେଏ, ଇଲେ କିନାୟି ମିଙ୍ଗେ ତାକି ନେହେଁ ଆ଼ଏ, ଏଟ୍‌କା ଲ଼କୁଣି ଦ଼ହ ଦସାନା ମୀମ୍ବୁଏ ଏଲେତି କାମା କିହାନା ଏମ୍ବାଟି ମୀରୁଏ ଦ଼ହ କିହିମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ଆମିନି ଗାଟାରି ଇଲେତି କାମା କିନେରି, ମାହାପୂରୁ ଏଲେତି ଲ଼କୁଣି ସାତା ତଲେ ନୀହାଁୟି କିନେସି, ଈଦାଆଁ ମା଼ମ୍ବୁ ପୁଞ୍ଜାମାନମି । ");
INSERT INTO kxv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ଏ଼ ତାୟି ଅ଼ଡ଼େ ତାଙ୍ଗି, ଆମିନି ଗାଟାରି ଲାଗେଏତି କାମା କିନେରି, ଏ଼ୱାରାଇଁ ନୀହାଁୟି କିହାନା, ମୀମ୍ବୁଏ ଏଲେତି କାମା କିହିମାଞ୍ଜେରି, ମୀରୁ ମାହାପୂରୁତି ନୀହାଁୟିଟି ଜୀଣା ଆ଼ନାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିମାଞ୍ଜେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ଆ଼ଆତିଁ, ମାହାପୂରୁତି ହା଼ରେକା କାର୍ମାମେହ୍‌ନାୟି ମୀ ହିୟାଁ ବାଦ୍‌ଲି କିନି ୱାକି ଅ଼ହାଲି ଅଣ୍‌ପିନେ, ଈଦାଆଁ ପୁନାଆନା ମୀରୁ କି ତାନି କାର୍ମାମେହ୍‌ନାଣି, ସା଼ସା, ଅ଼ର୍‌ହାନା ଡ଼ୟିନି ଲେହେଁତି ଦ଼ନଇଁ ଅ଼ପିହିଲଅତେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ସାମା ମୀରୁ ମୀ ଆ଼ଟ୍‌ୱା ଅ଼ଡ଼େ ବାଦ୍‌ଲୱି ଆ଼ଆଗାଟି ହିୟାଁ ଲେହେଁ, ଆମିନି ଦିନା ମାହାପୂରୁତି ନୀହାଁୟି ତ଼ଞ୍ଜାଆ଼ନେ, ଏ଼ କାର୍‌ବିତି ଦିନାତାକି ଜାହାରାତାକି କାର୍‌ବି କୂଡ଼ି କିହିମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ଏ଼ୱାସି ବାରେ ଲ଼କୁତାକି ତାମି କିହାମାନି କାମାତି ପା଼ଡ଼େୟି ହୀନେସି; ");
INSERT INTO kxv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ଆମିନି ଗାଟାରି ସା଼ସାତଲେ ନେହିଁ କାମା କିହାନା ଗାୱୁରମି, ମା଼ନି ଇଞ୍ଜାଁ ହା଼ଆଗାଟାଣି ପାରିନେରି, ଏ଼ୱାରାକି କା଼ଲାକା଼ଲାତି ଜୀୱୁ ହୀନେସି, ");
INSERT INTO kxv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ଆମ୍ବାଆରି ୱାର୍‌ଇ ତାମ୍‌ଙ୍ଗେ ଅଣ୍‌ପିନେରି, ଇଞ୍ଜାଁ ସାତାତି ମା଼ନୱି ଆ଼ଅରି, ସାମା ଲାଗେଏତାଣି ମା଼ନୱି ଆ଼ନେରି; ଏ଼ୱାରାକି କାର୍‌ବି ଅ଼ଡ଼େ କ଼ପା ୱା଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ଆମ୍ବାଆରି ଲାଗେଏତି କାମା କିହିମାନେରି ଏ଼ୱାରାକି କା଼କୁଲି ଅ଼ଡ଼େ କସ୍ତତି ଦିନା ୱା଼ହିମାନେ, ମୂଲୁଏ ଜୀହୁଦି ଲ଼କୁତାକି ଇଞ୍ଜାଁ ଡା଼ୟୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତାକି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ସାମା ମୂଲୁଏ ଜୀହୁଦି ଲ଼କୁକି ଅ଼ଡ଼େ ଜିକେଏ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତାକି, ନେହିଁ କାମା କିହାମାନି ବାରେଜା଼ଣା ତାକି ଗାୱୁରମି, ମା଼ନି ଇଞ୍ଜାଁ ହିତ୍‌ଡ଼ି ହିୟାନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ଇଚିହିଁ ମାହାପୂରୁ ତା଼ଣା ପାର୍‌ଡ଼ା ବାଚି କିନାୟି ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁକି ମ଼ସାତି ମେ଼ରା ହିଲାଆନା ପା଼ପୁ କିହାମାନେରି; ଏ଼ୱାରି ଜିକେଏ ମ଼ସାତି ମେ଼ରା ହିଲାଆନା ନା଼ସା ଆ଼ନେରି, ଅ଼ଡ଼େ ଏଚେକା ଜୀହୁଦି ଲ଼କୁକି ମ଼ସାତି ମେ଼ରା ପୁଞ୍ଜାମାନାକି; ଏ଼ୱାରି ପା଼ପୁ କିହାମାନେରି ଅ଼ଡ଼େ ଏ଼ ମେ଼ରା ତଲେ ନୀହାଁୟି କିୱିଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ଇଚିହିଁ ମେ଼ରାତି ୱେଞ୍ଜାନା ଲ଼କୁ ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁଗାଟାରି ଆ଼ଅରି, ସାମା ମେ଼ରାତି ମା଼ନୱି ଆ଼ତିସାରେ ଦାର୍ମୁଗାଟାରି ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁକି ମେ଼ରା ହିଲାଆତିହିଁ ଜିକେଏ ଏଚିବେ଼ଲା ଏ଼ୱାରି ମେ଼ରାତା ମାନି ଲେହେଁ କାମା କିନେରି, ଏଚିବେ଼ଲା ଏ଼ୱାରି ମେ଼ରା ବେଟା ଆ଼ଆତିହିଁ ଜିକେଏ ତାମ୍‌ଙ୍ଗେ ମେ଼ରା ଲେହେଁ ଆ଼ନେ; ");
INSERT INTO kxv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ଏ଼ୱାରି କିହିମାନି କାମାଟି ଈଦି ନେହିଁତଲେ ତ଼ଞ୍ଜା ଆ଼ହିମାନେ, ମେ଼ରାତି ମା଼ନି ଏ଼ୱାରି ହିୟାଁତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ । ଈ କାତାତି ସାତା ଏ଼ୱାରି ଅଣ୍‌ପୁତା ଜିକେଏ ପାର୍‌ମାଣା ସାତା ତଲେ ଅଣ୍‌ପିନାଟି ଅଣ୍‌ପିନି ଅଣ୍‌ପୁ ଏ଼ୱାରି କାତାତା ରା଼ଜି ଆ଼ହିମାନେ, ସାତା ଅଣ୍‌ପୁ ଅଣ୍‌ପିନାଟି ଅଣ୍‌ପୁ ଏ଼ୱାରାଇଁ ନେହାଁରି କିନେ, ଲାଗେଏତି ଅଣ୍‌ପୁ ଅଣ୍‌ପିନାଟି ଦ଼ହ କିହିମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ଏମିନି ଦିନା ମାହାପୂରୁ କ୍ରୀସ୍ତ ଜୀସୁ ତା଼ଣାଟି ମାଣ୍‌ସିତି ଡ଼ୁଗାମାନି କାତା ବାରେ ନୀହାଁୟି କିନେସି, ଏ଼ ଦିନା ନା଼ନୁ ୱେ଼କ୍‌ହିମାନି ନେହିଁ କାବ୍ରୁ ଲେହେଁ ଈ ବାରେ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ମୀରୁ ଜାହାରାଇଁ ଜୀହୁଦିତମି ଇଞ୍ଜାକଡିମାଞ୍ଜେରି; ମେ଼ରାତି ବା଼ର୍ସୁ ଇଟାମାଞ୍ଜେରି ଅ଼ଡ଼େ ମାହାପୂରୁ ତା଼ଣା ବଡପଣ କିହିମାଞ୍ଜେରି; ");
INSERT INTO kxv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ଅ଼ଡ଼େ ମ଼ସାତି ମେ଼ରାଟି ଜା଼ପାନା ଏ଼ୱାଣି ଅଣ୍‌ପୁ ପୁଞ୍ଜିମାଞ୍ଜେରି, ଇଞ୍ଜାଁ ନେହାଁଣି ଲାଗେଏତାଣି ବାଚି କିହିମାଞ୍ଜେରି, ");
INSERT INTO kxv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ସାତେଏ ମୀରୁ ନେହିଁ କିହିଁ ପୁଞ୍ଜାମାଞ୍ଜେରି, ମୀରୁ କା଼ଣାୟାଁଣି ଜିରୁ ତ଼ହ୍‌ନାତେରି, ଆନ୍ଦେରିତା ମାନି ଲ଼କୁତାକି ଉଜେଡ଼ି ଲେହେଁ, ");
INSERT INTO kxv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ବୁଦି ହିଲାଆ ଲ଼କୁଣି ୱେହ୍‌ନାତେରି, ପୁନାଆତି ଲ଼କୁଣି ଜା଼ପ୍‌ନାତେରି । ମୀ ନାମୁ, ମେ଼ରାଟି ମୀରୁ ସାତା ଅ଼ଡ଼େ ବୁଦି ମେ଼ଡ଼ା ଆ଼ହାମାଞ୍ଜେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ମୀରୁ ଏଟ୍‌କାତି ଲ଼କୁଣି ଜା଼ପ୍‌ହି ମାଞ୍ଜେରି, ସାମା ଜାହାରାଇଁ ଏ଼ନାଆଁତାକି ଜା଼ପ୍‌ହି ହିଲଅତେରି ? ସ଼ରୁ କିଆଦୁ ଇଞ୍ଜିଁ ଜା଼ପ୍‌ହାନା ମୀରୁଏ ଏ଼ନାଆଁତାକି ସ଼ରୁ କିହିମାଞ୍ଜେରି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ଦା଼ରି କିଆଦୁ ଇଞ୍ଜିଁ ଇଞ୍ଜାନା ମୀରୁଏ ଦା଼ରି କିହିମାଞ୍ଜେରି ? ମୀରୁ ପେ଼ଣ୍‌କା ବମାୟାଁ ପୂଜା ଅ଼ପାଆନା ଦେ଼ୱୁଡ଼ିକାତି ଦିଣ୍‌ସୁ ମା଼ଣ୍‌ଚି ହିଲଅତେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ମୀରୁ ମାହାପୂରୁତି ମେ଼ରା ବେଟା ଆ଼ହାମାନମି ଇଞ୍ଜିଁ ବଡପଣ ଆ଼ହିମାଞ୍ଜେରି, ସାମା ଏ଼ଦାଆଁ ମା଼ନି କିଆନା ମାହାପୂରୁଇଁ ଲାଜା ପା଼ଣ୍‌ପି କିହିମାଞ୍ଜେରି କି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ମିଙ୍ଗେ ତାକି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତା଼ଣା ମାହାପୂରୁ ଦ଼ରୁ ନିନ୍ଦା ବେଟା ଆ଼ହିମାନେ ।” ");
INSERT INTO kxv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ମୀରୁ ମେ଼ରାତି ମା଼ନି କିହିମାଚିସାରେ, ମୀ ତ଼ଲୁ ଦା଼ପିଆ଼ନାୟି ଲା଼ବା ମାନେ । ସାମା ମେ଼ରାତି ମା଼ନି କିଆସାରେ, ମୀ ତ଼ଲୁ ଦା଼ପି ଆ଼ତାୟି ତ଼ଲୁ ଦା଼ପିଆ଼ଆତି ଲ଼କୁତଲେ ସମାନା । ");
INSERT INTO kxv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ର଼ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ମେ଼ରାତି ହୁକୁମିକା ମା଼ନି କିତିସାରେ ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ତ଼ଲୁ ଦା଼ପି ଆ଼ତାସି ଲେହେଁ ଇନଅସି କି ? ");
INSERT INTO kxv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ଏ଼ଦାଆଁତାକି ଆଙ୍ଗା ତଲେ ତ଼ଲୁ ଦା଼ପିଆ଼ଆତି, ଆମିନି ଜୀହୁଦିଆ଼ଆତାରି ମ଼ସାତି ମେ଼ରା ମା଼ନି କିନେରି, ଆତିହିଁ ମ଼ସା ରା଼ଚିତି ମେ଼ରା ଅ଼ଡ଼େ ତ଼ଲୁ ଦା଼ପି ଆ଼ତିଜିକେଏ ମେ଼ରା ମା଼ନି କିହିହିଲଅତେରି, ଏ଼ୱାରି ମିଙ୍ଗେ ବିଚାରା କିୟାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ୱାର୍‌ଇ ଆଙ୍ଗା ତଲେ ତ଼ଲୁ ଦା଼ପି ଆ଼ହାନା ପାଙ୍ଗାତା ଜୀହୁଦି ଇଞ୍ଜିହିଁ ତ଼ସାକଡିମାନି ଲ଼କୁ ଜୀହୁଦି ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ଆମ୍ବାଆସି ହିୟାଁ ବିତ୍ରା ଜୀହୁଦି, ଏ଼ୱାସି ସାତା ତଲେ ଜୀହୁଦି, ଅ଼ଙ୍କରି ତଲେ ଆ଼ଏ, ଜୀୱୁ ଅ଼ଡ଼େ ହିୟାଁ ତଲେ ଆମ୍ବାଆସି ତ଼ଲୁ ଦା଼ପି ଆ଼ତାସି, ଏ଼ଦି ସାତା ତ଼ଲୁ ଦା଼ପି ଆ଼ନାୟି । ଏଲେତି ଲ଼କୁ ମାଣ୍‌ସି ତା଼ଣାଟି ମା଼ନି ବେଟାଆ଼ଅସି, ସାମା ମାହାପୂରୁ ତା଼ଣାଟି ମା଼ନି ବେଟା ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ଆତିହିଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ କିହାଁ ଜୀହୁଦି ଲ଼କୁକି ଏ଼ନାୟି ଗାଡି ଲା଼ବା ମାନେ ? ତ଼ଲୁ ଦା଼ଃନାୟି ଏ଼ନି ଲ଼ଡ଼ାମାନେ ? ");
INSERT INTO kxv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ହା଼ରେକାତି, ମୂଲୁଏ ମାହାପୂରୁ ତାନି ନେହିଁ କାବ୍ରୁ ୱେ଼କ୍‌ହାଲି ଦାୟିପତି ଜୀହୁଦି ଲ଼କୁକି ହେର୍‌ପିତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ଆତିହିଁ ଏ଼ନାୟି ? ଜୀହୁଦିଙ୍ଗା ତା଼ଣାଟି ଏଚରଜା଼ଣା ନାମାଆସାରେ, ଏ଼ୱାରି ମା଼ନି କିଆଗାଟାୟି ଏ଼ନାଆଁ ମାହାପୂରୁ ନାମୁତି ଉଜେଏ କିନେ ? ");
INSERT INTO kxv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ଏଲେଆ଼ହିଁ ଆ଼ଆପେ, ଲ଼କୁ ବାରେଜା଼ଣା ମିଚିତାରି ଆତିହିଁ ଜିକେଏ ମାହାପୂରୁ ସାତା । ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ; “ନୀ ବ଼ଲୁ ତଲେ ନୀନୁ ଦାର୍ମୁ ଗାଟାତି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିଦି, ନୀହାଁୟି ଆ଼ନି ବେ଼ଲାତା ନୀନୁ ଜୀଣା ଆ଼ଦି ।” ");
INSERT INTO kxv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ମା଼ ଲାଗେଏତି କାମା ମାହାପୂରୁତି ନେହିଁ କାମାତି ପାର୍‌ମାଣା କିନେ, ଆତିହିଁ ମା଼ର ଏ଼ନାଆଁ ଇନାୟି ? ଆମିନି ମାହାପୂରୁ ଲାଗେଏତି କାମାତାକି ଡଣ୍ତ ହୀନେସି, ଏ଼ୱାସି କି ଦାର୍ମୁ ହିଲାଆଗାଟାସି ? ନା଼ନୁ ମାଣ୍‌ସିଲେହେଁ ୱେସିମାଇଁ । ");
INSERT INTO kxv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ଏଲେଆ଼ହିଁ ଆ଼ଏ । ମାହାପୂରୁ ଦାର୍ମୁଗାଟାସି ଆ଼ଆତିହିଁ, ଏ଼ୱାସି ଏ଼ନିକିହିଁ ଦାର୍‌ତିତି ନୀହାଁୟି କିନେସି ? ");
INSERT INTO kxv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ସାମା ନା଼ ମିଚି ତଲେ ମାହାପୂରୁତି ସାତାତାୟି ତାନି ଗାୱୁରମି ତାକି ହା଼ରେକା ଗାଡି ଆ଼ତେ, ଆତିହିଁ ନା଼ନୁ ପା଼ପୁ ଗାଟାତେଏଁ ଇଞ୍ଜିଁ ଏ଼ନାଆଁତାକି ନୀହାଁୟି କିୱି ଆ଼ଇଁ ? ");
INSERT INTO kxv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ମା଼ର ଏ଼ନାଆଁତାକି ଏଲେଇନାଆୟି, “ୱା଼ଦୁ ମା଼ର ଲାଗେଏତି କାମା କିନ, ଆତିହିଁ ମାଙ୍ଗେତାକି ନେହେଁ ଆ଼ନେ ?” ନା଼ନୁ ଇଲେତି କାତା ୱେସିମାନାକି ଦାୱା କିହାନା ଏଚେକା ଲ଼କୁ ନାଙ୍ଗେ ନିନ୍ଦା କିହିମାଞ୍ଜାନେରି, ଏ଼ୱାରି ଈଦାଆଁତାକି ଆମିନି ଡଣ୍ତ ପା଼ଣ୍‌ନାୟି ମାନେ, ସାତାତଲେ ବେଟାଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ଆତିହିଁ ଜୀହୁଦି ଲ଼କୁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ କିହାଁ ହା଼ରେକା ନେହାଁରି ମାନେରି ? ଏଚେଲାୱା ଆ଼ଏ, ନା଼ନୁ ନ଼କେଏ ୱେସାମାଞ୍ଜାଇଁ ଜୀହୁଦି ଅ଼ଡ଼େ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁ ପା଼ପୁତି ବା଼ଡ଼୍‌ୟୁତା ମାନେରି, ");
INSERT INTO kxv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ; “ଦାର୍ମୁଗାଟାସି ଆମ୍ବାଆସି ହିଲଅସି, ରଅସି ଜିକେଏ ହିଲଅସି, ");
INSERT INTO kxv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ରଅସି ଜିକେଏ ବୁଦିଗାଟାସି ହିଲଅସି; କି ମାହାପୂରୁଇଁ ପାରିନାସି ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ଏ଼ୱାରି ବାରେଜା଼ଣା ମାହାପୂରୁ ତା଼ଣାଟିଏ ହେକ ହାଜାମାନେରି; ଏ଼ୱାରି ବାରେଜା଼ଣା ଲାଗେଏ ଜିରୁତା ହାଜାମାନେରି; ଆମ୍ବାଆସି ଜିକେଏ ରଅସି ସାତାପା଼ଣାତି କାମାକିନାସି ହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ଏ଼ୱାରି ହା଼ଡା ଦେପିଆ଼ତି ମାଡ଼୍‌ହା ମୁହ୍‌ନି ଟା଼ୟୁ, ଏ଼ୱାରି ଗୂତିଟି ମିଚି କାତା ହ଼ଚିମାନେ, ଲୂଡ଼ା ଡ଼଼ଇ ଅ଼ଟୁ କା଼ଚାମାନି ରା଼ଚୁତି ବୀସାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ଏ଼ୱାରି ଗୂତିତି କାତା କାମ୍ବେଲି ଗାଟାୟି ଇଞ୍ଜାଁ ବା଼କା ତଲେ ନେଞ୍ଜାମାନେ । ");
INSERT INTO kxv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ଏ଼ୱାରି ଇର୍‌ହାଲି ଅ଼ଡ଼େ ପା଼ୟାଲି ଦେବୁଣିଏ ହ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ଏ଼ୱାରି ଆମ୍ବିୟାୱାକି ହାନେରି, ଏମ୍ବାଆଁ ନା଼ସା ଇଞ୍ଜାଁ ସା଼ସ୍ତି ବେଟାଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ଏ଼ୱାରି ହିତ୍‌ଡ଼ିତି ଜିରୁ ପୁଞ୍ଜାହିଲଅରି, ");
INSERT INTO kxv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ମାହାପୂରୁଇଁ ଆଜିନାୟି ଏ଼ୱାରିତା଼ଣା ହିଲେଏ ।” ");
INSERT INTO kxv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ମା଼ର ପୁଞ୍ଜାମାନାୟି, ମେ଼ରା ମା଼ନି କିହିମାନେରି, ଏମ୍ବାତି ବାରେ ହୁକୁମିଇଁ ଏ଼ୱାରି ମା଼ନି କିନାୟିମାନେ । ମାହାପୂରୁ ଏଚିବେ଼ଲା ବାରେ ଦାର୍‌ତିତି ବିଚାରା କିନେସି, ମେ଼ରାତି ମା଼ନି କିଆଗାଟି ଲ଼କୁ ଜାହାରାଇଁ ଦ଼ହ ହିଲାଆ ଗାଟାତମି ଇଞ୍ଜିଁ ଇଞ୍ଜାଲି ଆ଼ଡଅରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ସାମା ମେ଼ରା ତଲେ କିନି କାମା ମା଼ନି କିହାଁ ଆମ୍ବାଆସି ଜିକେଏ ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁଗାଟାସି ଆ଼ହାଲି ଆ଼ଡଅସି । ଇଚିହିଁ ମେ଼ରାଟି ମାଣ୍‌ସି ୱାର୍‌ଇ ପା଼ପୁତି ପୁଞ୍ଜାଲି ଆ଼ଡିମାନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ମାହାପୂରୁ ମାଣ୍‌ସିଇଁ ତାନିତଲେ ନେହିଁକିଁ ଆଣ୍ଡାଲି ତାକି ମେ଼ରା ପିସ୍‌ପେ ଏ଼ନାଆଁ କିହାମାନେସି, ଏ଼ଦି ନୀଏଁ ତ଼ଞ୍ଜା ଆ଼ହିମାନେ । ଏ଼ କାତା ମ଼ସାତି ମେ଼ରା ଇଞ୍ଜାଁ ମାହାପୂରୁ ଅଣ୍‌ପୁତି ବ଼ଲୁ ୱେହ୍‌ନାରି ଜିକେଏ ସା଼କି ହୀହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ୱାର୍‌ଇ ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣା ନାମିତାକି ଲ଼କୁ ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁଗାଟାରି ଆ଼ନେରି । ମାହାପୂରୁ ଆମ୍ବାଆରାଇଁ ପାର୍‌ଡ଼ା ବାଚି କିଆନା କ୍ରୀସ୍ତଇଁ ନାମିତି ବାରେ ଜା଼ଣାକି ର଼ ପାରୁ ହୀନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ବାରେଜା଼ଣା ପା଼ପୁ କିହାମାନେରି ଅ଼ଡ଼େ ମାହାପୂରୁତି ଗାୱୁରମିଟି ହେକ ଆ଼ହାମାନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ସାମା, ଏ଼ୱାରି ଉଜେଏ ମାହାପୂରୁତି କାର୍ମାମେହ୍‌ନି ଦା଼ନା ତଲେ କ୍ରୀସ୍ତ ଜୀସୁ ତା଼ଣା ଆମିନି ଗେଲ୍‌ପି ଆ଼ନାୟି ମାନେ, ଏ଼ଦାଆଁ ତଲେ ଦାର୍ମୁଗାଟାରି ଆ଼ନେରି । ");
INSERT INTO kxv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ମାହାପୂରୁ ଜୀସୁଇଁ ଦା଼ନା ହୀତେସି, ଏ଼ନିକିଁ ଏ଼ୱାଣି ହା଼କି, ଏ଼ୱାଣି ତା଼ଣା ନାମାମାନି ଲ଼କୁତାକି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗିନି ଊପେୟି ଆ଼ନେ । ମାହାପୂରୁ ଅ଼ର୍‌ହାନା ଲ଼କୁ କିହାମାନି ତଲିତି ପା଼ପୁତି ତ଼ସାହିଲଅସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ସାମା ନୀଏଁ ଏ଼ୱାସି ଜାହାରା ଦାର୍ମୁ ଗାଟାଣି ତ଼ସାଲି ତାକି ପା଼ପୁ ମ୍ଣେକ୍‌ନି ମେ଼ରା କିହାମାନେସି । ଈଦାଆଁ ତଲେ ମାହାପୂରୁ ତ଼ସାମାନେସି, ଏ଼ୱାସି ତା଼ନୁଏ ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜାଁ ଆମ୍ବାଆସି ଜୀସୁ ତା଼ଣା ନାମିନେସି, ଏ଼ୱାସି ବାରେଜା଼ଣାତି ଦାର୍ମୁ ଗାଟାରିଲେହେଁ ଆବିନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ଆତିହିଁ ଆମିନି କାତାତା ମା଼ର ବଡପଣ ଆ଼ନାୟି ? ଆ଼ଏ, ଏଲେତି କାତା ଏ଼ନାୟି ହିଲେଏ । ବଡପଣ ଆ଼ହାଲିତାକି ମା଼ ତା଼ଣା ଏ଼ନାୟି ମାନେ ? ମା଼ର ବାରେ ହୁକୁମି ମା଼ନୱି ଆ଼ହିମାନାୟି ଇଞ୍ଜିହିଁ କି ? ଆ଼ଏ, ୱାର୍‌ଇ ନାମୁଏ ମା଼ ବଡପଣ ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ମା଼ର ନେହିଁକିଁ ତେଲ୍‌ହାଲି ଆ଼ଡିନାୟି. ରଅସି ୱାର୍‌ଇ ତାନି ନାମୁତଲେ ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେସି, ମେ଼ରାତି ମା଼ନି କିତିସାରେ ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ମାହାପୂରୁ ୱାର୍‌ଇ ଜୀହୁଦି ଲ଼କୁତି ମାହାପୂରୁକି ? ଏ଼ୱାସି ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତି ମାହାପୂରୁ ଆ଼ଏକି ? ସାତେଏ ଏ଼ୱାସି ବାରେ ଲ଼କୁତି ମାହାପୂରୁ । ");
INSERT INTO kxv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ଏ଼ନାଆଁତାକି ଇଚିହିଁ, ମାହାପୂରୁ ରଅସିଏ, ଅ଼ଡ଼େ ଏ଼ୱାସି ଜୀହୁଦି ଇଞ୍ଜାଁ ଜୀହୁଦିଆ଼ଆତି ଲ଼କୁତି ନାମୁ ତାକି ଏ଼ୱାସି ଏ଼ୱାରାଇଁ ଦାର୍ମୁ ଗାଟାରିଲେହେଁ ଆବିନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ଆତିହିଁ, ମା଼ର କି ନାମୁତଲେ ମ଼ସାତି ମେ଼ରା ମ୍ଣେକ୍‌ହି ମାନାୟି ? ଏ଼ଦି ଏଚେଲା ଜିକେଏ ଆ଼ଆପେ, ସାମା ମା଼ର ନାମୁତଲେ ମ଼ସାତି ମେ଼ରାଇଁ ଜାଣ୍ଡେ ତୀରି କିହିମାନାୟି । ");
INSERT INTO kxv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ଆତିହିଁ ଆଙ୍ଗା ତଲେ ମା଼ ଆକୁ ଅବ୍ରାହାମ ଏ଼ନାଆଁ ବେଟାଆ଼ହାମାନେସି ଇଞ୍ଜିହିଁ ମା଼ର ଏଲେଇନାୟି ? ");
INSERT INTO kxv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ଅବ୍ରାହାମ ତାନି ଜାହାରା କାମାଟି ମାହାପୂରୁ ତା଼ଣା ଦାର୍ମୁଗାଟାସି ଆ଼ହା ମାଚିହିଁମା, ଏ଼ୱାଣାକି ବଡପଣ କିନି କାତା ମାଚେ । ସାମା ମାହାପୂରୁ ୱାକିଟି ଏ଼ଦି ଆ଼ହାହିଲାଆତେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ଦାର୍ମୁ ସା଼ସ୍ତେରି ଲେହେଁ, “ଅବ୍ରାହାମ ମାହାପୂରୁଇଁ ନାମିତେସି, ଅ଼ଡ଼େ ଏ଼ ନାମୁତାକି ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଦାର୍ମୁ ଗାଟାଣି ଲେହେଁ ଅ଼ପିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ଆମ୍ବାଆସି କାମା କିନେସି, ଏ଼ୱାଣାକି ତାନି କୂଲି ମେ଼ଡ଼ାଆ଼ନେ, ଏ଼ଦି ଦା଼ନା ହୀନାୟି ଆ଼ହାଲି ଆ଼ଡେଏ, ଏ଼ଦି କାମାତି ପା଼ଡ଼େୟି ଇଞ୍ଜିଁ ଇଣ୍‌ମ୍ବି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ସାମା ଆମ୍ବାଆସି ତାନି କାମାତା ଆ଼ସା କିଆନା, ଦାର୍ମୁ ହିଲାଆଗାଟାଣାଇଁ ଏମିନି ମାହାପୂରୁ ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ଆବିନେସି, ଏ଼ୱାଣି ତା଼ଣା ନାମିନେସି, ଏ଼ୱାଣି ନ଼କିତା ଏ଼ୱାଣି ନାମୁ ଦାର୍ମୁଗାଟାୟି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିନେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ଆମିନି ଲ଼କୁଇଁ କାମା ଲ଼ଡ଼ାତି ସିନି କିଆନା ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ଆବିନେସି, ଏ଼ୱାଣାଇଁ ନେହାଁସି ଇଞ୍ଜିଁ ଦାୱୁଦ ଏଲେଇଞ୍ଜା ମାନେସି; ");
INSERT INTO kxv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“ଆମ୍ବାଆରି ଦ଼ହ ମେଣ୍‌ଙ୍ଗି କିୱିଆ଼ହାମାନେ, ଆମ୍ବାଆରି ପା଼ପୁ ମେଣ୍‌ଙ୍ଗି କିୱିଆ଼ହାମାନେ, ଏ଼ୱାରାକି ନେହେଁ । ");
INSERT INTO kxv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ପ୍ରବୁ ଆମ୍ବାଆରି ପା଼ପୁ ଆହ୍‌ଅସି, ଏ଼ୱାଣାକି ନେହେଁ !” ");
INSERT INTO kxv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ଇମ୍ବାଆଁ ଦାୱୁଦ ଆମ୍ବାଆରାଇଁ ନେହେଁ ଇଞ୍ଜିଁ ୱେସାମାନେସି, ଏ଼ୱାରି କି ୱାର୍‌ଇ ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ଲ଼କୁ ମାଚେରି ? କି, ତ଼ଲୁ ଦା଼ପିଆ଼ଆତି ଲ଼କୁ ଜିକେଏ ନେହାଁରି ଆ଼ହାଲି ଆ଼ଡିନେରି । ମା଼ର ଏଲେ ଇଞ୍ଜିମାନାୟି, “ଅବ୍ରାହାମ ନାମୁତଲେ ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗିତେସି ।” ");
INSERT INTO kxv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ଆତିହିଁ ଏ଼ଦି ଏଚେଲା ଆ଼ହାମାଚେ ? ଅବ୍ରାହାମ ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ଡା଼ୟୁ କି, ତାନି ନ଼କେଏ ? ତ଼ଲୁ ଦା଼ପି ଆ଼ଆନକେଏ, ଡା଼ୟୁ ଆ଼ଏ । ");
INSERT INTO kxv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ନ଼କେଏ ଅବ୍ରାହାମ ନାମୁ ତାକି ମାହାପୂରୁ ଏ଼ୱାଣାଇଁ ଦାର୍ମୁ ଗାଟାଣା ଲେହେଁ ଆବା ମାଚେସି । ଈଦାଆଁ ପୁଣ୍‌ମ୍ବି କିହାଲିତାକି ର଼ ସିନାଲେହେଁ ଅବ୍ରାହାମ ଈ ତ଼ଲୁ ଦା଼ପିଆ଼ନି ମେ଼ରା ବେଟାଆ଼ହା ମାଚେସି, ଇଚିହିଁ, ଆମିନି ଗାଟାରି ତ଼ଲୁ ଦା଼ପି ଆ଼ଆନା ଜିକେଏ ମାହାପୂରୁ ତା଼ଣାଟି ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିହିଁ ଆବିତାସି, ସୁଦୁ ମାଣ୍‌କିଟି ଅବ୍ରାହାମ ଏ଼ୱାରି ତାଞ୍ଜି । ");
INSERT INTO kxv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ଆ଼ବା ଅବ୍ରାହାମ ତ଼ଲୁ ଦା଼ପି ଆ଼ତି ନ଼କେଏଟିଏ ଆମିନି ନାମୁତି କାତା ତ଼ସାମାଚେସି, ତ଼ଲୁ ଦା଼ପିଆ଼ଆତି ଲ଼କୁ ଜାହାରା ଜୀୱୁତା ଏଲେତି ନାମୁ ତ଼ସାଲି ଆ଼ଡିସାରେ, ଅବ୍ରାହାମ ଏ଼ୱାରାକି ଜିକେଏ ତାଞ୍ଜି ଆ଼ନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ଅବ୍ରାହାମ ମେ଼ରାତି ମା଼ନି କିହାମାନାକି ଆ଼ଏ । ୱାର୍‌ଇ ତାନି ନାମୁ ତାକି ମାହାପୂରୁ ତା଼ଣାଟି ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗାମାଚେସି ଇଞ୍ଜାଁ ଏ଼ଦାଆଁତାକି ତାନି ମୀର୍‌କା ମା଼ସ୍‌କା ଦାର୍‌ତିତି ଅଦିକାରା ବେଟାଆ଼ନେରି ଇଞ୍ଜିଁ ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାଚେସି । ");
INSERT INTO kxv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ଆମ୍ବାଆରି ମେ଼ରାତି ମା଼ନି କିନାରି, ୱାର୍‌ଇ ଏ଼ୱାରି ମାହାପୂରୁତି ଦା଼ନା ବେଟାଆ଼ନେରି ଇଚିସାରେ, ମାଣ୍‌ସିତି ନାମୁ ଉଜେଏ, ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାନାୟି ଜିକେଏ ଉଜେଏତାୟି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ଇଚିହିଁ ମ଼ସାତି ମେ଼ରା ଊରିନି ତା଼ଣାଟି ମାହାପୂରୁତି କାର୍‌ବି ଗାଟାସି ଆ଼ନେସି, ସାମା ଆମ୍ବିୟା ମେ଼ରା ହିଲେଏ, ଏମ୍ବାଆଁ ମେ଼ରା ଊରିନି କାତା ହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ଏ଼ଦାଆଁତାକି ମାହାପୂରୁତି ଆ଼ଞ୍ଜାମାନାୟି ନାମୁ ଅ଼ଡ଼େ କାର୍ମାତି ଲାକ ଇଟ୍‌କି ଆ଼ହାମାନେ । ଆମିନି ଗାଟାରି ମେ଼ରାତି ମା଼ନି କିନେରି, ୱାର୍‌ଇ ଏ଼ୱାରାକିଦେହେଁ ମାହାପୂରୁତି ଆ଼ଞ୍ଜାମାନାୟି ଆ଼ଏ । ଅବ୍ରାହାମ ଲେହେଁ ନାମିମାନି ବାରେ ଲ଼କୁତାକି ଜିକେଏ ଆ଼ନେ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ଅବ୍ରାହାମ ଏ଼ୱାରି ସୁଦୁ ମାଣ୍‌କିତି ତାଞ୍ଜି; ");
INSERT INTO kxv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ଆମିନି ମାହାପୂରୁଇଁ ଅବ୍ରାହାମ ନାମିମାଚେସି, ଆମ୍ବାଆସି ହା଼ତାରାଇଁ ୱେଣ୍ତେ ଜୀୱୁ କିନେସି, ଅ଼ଡ଼େ ହିଲାଆଗାଟି ଦିଣ୍‌ସୁତି ମାନି ଲେହେଁ ହା଼ଟିନେସି, ଏ଼ ମାହାପୂରୁ ନ଼କିତା ଏ଼ୱାସି ମା଼ ତାଞ୍ଜି ଆ଼ହାମାନେସି, ଈ କାତା ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ନିଙ୍ଗେ ହା଼ରେକା କୂଡ଼ାତି ଲ଼କୁତି ତାଞ୍ଜି କିହାମାଞ୍ଜାନମି ।” ");
INSERT INTO kxv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ଆ଼ସା କିନାୟି ଏ଼ନାୟି ହିଲାଆତି ଜିକେଏ ଅବ୍ରାହାମ ନାମିତେସି ଇଞ୍ଜାଁ ଆ଼ସା ଇଟିତେସି, ଏ଼ଦାଆଁତାକି “ହା଼ରେକା କୂଡ଼ାତି ତାଞ୍ଜି” ଆ଼ତେସି । ଦାର୍ମୁ ସା଼ସ୍ତେରିତା ରା଼ସ୍‌କି ଆ଼ହାମାନେ, “ନୀ କୂଡ଼ା ହୁକାୟାଁ ଲେହେଁ ଏ଼ପାଆ଼ନେରି ।” ");
INSERT INTO kxv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ଏ଼ୱାଣାକି ଏଚିବେ଼ଲା ପା଼ସାକ଼ଡ଼ି ବାର୍ସା ଆ଼ହାମାଚାକି ଏ଼ୱାସି ତାନି ଆଙ୍ଗାତି ହା଼ତାୟି ଇଞ୍ଜାଁ ସାରା ଅ଼ଡ଼େ କକାରି ପ଼ଦାଁ ଆ଼ନି ଗା଼ରା ଜିକେଏ ହା଼ତାୟି ଇଞ୍ଜିଁ ଅଣ୍‌ପିତି ଜିକେଏ ନାମୁତା ଊଣା ଆ଼ଆତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ଏ଼ୱାସି ତାନି ନାମୁ ପିହ୍‌ଆତେସି, କି ମାହାପୂରୁ ଆ଼ଞ୍ଜାମାନାଣି ଆନାମାନା ଆ଼ଆତେସି । ଏ଼ୱାସି ନାମୁତା ବା଼ଡ଼୍‌ୟୁ ଆ଼ତେସି ଇଞ୍ଜାଁ ମାହାପୂରୁଇଁ ଜହରା କିତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ମାହାପୂରୁ ଏ଼ନାଆଁ ଆ଼ଞ୍ଜାମାଚେସି, ଏ଼ୱାସି ଏ଼ଦାଆଁ ମା଼ନି କିନେସି ଇଞ୍ଜିଁ ଏ଼ୱାଣାକି ଜାଣ୍ଡେ ନାମୁ ମାଚେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ଏ଼ଦାଆଁତାକି ତାନି ନାମୁତଲେ ଅବ୍ରାହାମ, “ମାହାପୂରୁ ତା଼ଣାଟି ଦାର୍ମୁଗାଟାସି ଆ଼ହାମାଚେସି ।” ");
INSERT INTO kxv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","“ଅବ୍ରାହାମ ଦାର୍ମୁଗାଟାସି ଇଞ୍ଜିଁ ୱେ଼ଙ୍ଗାମାଚି” କାତା ୱାର୍‌ଇ ଏ଼ୱାଣି ତାକିଏଦେଁ ରା଼ସ୍‌କି ଆ଼ହାହିଲେଏ । ");
INSERT INTO kxv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ସାମା ଈ କାତା ମାଙ୍ଗେତାକି ଜିକେଏ ରା଼ସ୍‌କି ଆ଼ହାମାନେ; ଇଚିହିଁ ଆମ୍ବାଆସି ମା଼ ପ୍ରବୁ ଜୀସୁଇଁ ହା଼ତାରି ତା଼ଣାଟି ନିକ୍‌ହାମାନେସି, ଏ଼ୱାଣି ତା଼ଣା ମା଼ର ନାମିମାନାୟି, ମାଙ୍ଗେତାକି ଜିକେଏ ଏ଼ଦି ଆ଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ଏ଼ ପ୍ରବୁ ଜୀସୁ ମା଼ ପା଼ପୁତି ବାଦୁଲି ହା଼ହାଲି ହେର୍‌ପିଆ଼ହା ମାଚେସି ଇଞ୍ଜାଁ ମାହାପୂରୁ ନ଼କିତା ମାଙ୍ଗେ ଦାର୍ମୁ ଗାଟାତାୟି କିହାଲି ୱେଣ୍ଡେ ନିଙ୍ଗିତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ନୀଏଁ ନାମୁତଲେ ମା଼ର ମାହାପୂରୁ ନ଼କିତା ଦାର୍ମୁ ଗାଟାତାୟି ଆ଼ହାମାନାୟି ଇଞ୍ଜାଁ ପ୍ରବୁ ଜୀସୁ କ୍ରୀସ୍ତ ତା଼ଣାଟି ମାହାପୂରୁ ତଲେ ମା଼ର ହିତ୍‌ଡ଼ି ତଲେ ମାନାୟି; ");
INSERT INTO kxv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ଏମିନି କାର୍ମାତା ମା଼ର ମାଞ୍ଜାମାନାୟି, ଏମ୍ବାଟି ଏ଼ୱାଣି ତା଼ଣାଟି ନାମୁତା ଜିକେଏ ମାନାୟି; ଇଞ୍ଜାଁ ମା଼ର ମାହାପୂରୁତି ଗାୱୁରମିତି ବା଼ର୍ସୁତା ବଡପଣ କିହିମାନାୟି । ");
INSERT INTO kxv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ୱାର୍‌ଇ ଏ଼ଦି ଆ଼ଏ, ବାରେ ଦୁକୁ କସ୍ତତା ଜିକେଏ ମା଼ର ରା଼ହାଁ କିହିମାନାୟି, ଇଚିହିଁ କସ୍ତଟି ସା଼ସା ୱା଼ନେ, ");
INSERT INTO kxv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ସା଼ସାଟି ବା଼ଡ଼୍‌ୟୁ ମାଣ୍‌କି ୱା଼ନେ ଇଞ୍ଜାଁ ବା଼ଡ଼୍‌ୟୁ ମାଣ୍‌କିଟି ବା଼ର୍ସୁ ୱା଼ନେ । ");
INSERT INTO kxv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ବା଼ର୍ସୁ ମାଙ୍ଗେ ହୀଣି ଆ଼ହାଲି ହିୟେଏ, ଏ଼ନାଆଁତାକି ଇଚିହିଁ ମାହାପୂରୁ ମାଙ୍ଗେ ସୁଦୁଜୀୱୁ ହୀହାନା ମା଼ ହିୟାଁତା ତାନି ଜୀୱୁ ନ଼ନାଣି ହୀହାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ଏଚିବେ଼ଲାତା ମା଼ର ଏ଼ନି ଊପେୟି ହିଲାଆଗାଟାତାୟି ମାଚାୟି, ଏଚିବେ଼ଲା ମାହାପୂରୁ ତୀରି କିହାମାଚି ବେ଼ଲାତା କ୍ରୀସ୍ତ ପା଼ପୁ ଲ଼କୁତାକି ହା଼ତେସି । ");
INSERT INTO kxv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ଦାର୍ମୁତି ଲ଼କୁତାକି ଆମ୍ବାଆସି ଜିକେଏ ହା଼ଅସି, ନେହିଁ ଲ଼କୁତାକି ଆମ୍ବାଆସି ଜୀୱୁ ହୀହାଲି ଅଣ୍‌ପିନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ସାମା ମା଼ର ପା଼ପୁଗାଟି ଲ଼କୁ ମାଚାଟି ଜିକେଏ କ୍ରୀସ୍ତ ମା଼ ତାକି ତାନି ଜୀୱୁ ହୀତେସି, ଈଦାଆଁ ତଲେ ମାହାପୂରୁ ମାଙ୍ଗେ ଏଚେକା ଜୀୱୁନ଼ହିଁ ମାଞ୍ଜାନେସି, ଏ଼ଦାଆଁ ତ଼ସାମାଞ୍ଜାନେସି । ");
INSERT INTO kxv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ଏ