﻿USE sofia;
DROP TABLE IF EXISTS sofia.kxf_vpl;
CREATE TABLE kxf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kxf_vpl WRITE;
INSERT INTO kxf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Asœke kœdœ ɨ'ɨrɨ aata Yisu Kristu, ata Davidi á tshe dœ ndje ata Abrayamo. ");
INSERT INTO kxf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrayamo zu Izaka, Izaka zu Yakobo, Yakobo zu Yuda œdœ aayanœ. ");
INSERT INTO kxf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda zu Perese œdœ Zara, ayi endje kœdœ lima Tamare. Perese zu Eserone, Eserone zu Arame. ");
INSERT INTO kxf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arame zu Aminadabe, Aminadabe zu Nashone, Nashone zu Salma. ");
INSERT INTO kxf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salma zu Boaz, Rahabe kœdœ lima ayinœ. Boaz zu Obede, Luta kœdœ lima ayinœ. Obede zu Yese. ");
INSERT INTO kxf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese zu gbozugo Davidi, yé Davidi zu Salomo tœ yashe á tshe dœ lima awo Uri. ");
INSERT INTO kxf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo zu Robowame, Robowame zu Abiya, Abiya zu Asafe. ");
INSERT INTO kxf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafe zu Yozafate, Yozafate zu Yorame, Yorame kœdœ ata Oziase. ");
INSERT INTO kxf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziase zu Yotame, Yotame zu Akaze, Akaze zu Ezekiase. ");
INSERT INTO kxf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiase zu Manase, Manase zu Amɔ, Amɔ zu Yoziase. ");
INSERT INTO kxf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yoziase zu Yekonia œdœ aayanœ dœ lɔndɔ á endje ko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone. ");
INSERT INTO kxf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Manda kœko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone, Yekonia zu Shaletiele, yé Shaletiele zu Zorobabele. ");
INSERT INTO kxf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabele zu Abiwude, Abiwude zu Eliyakimi, yé Eliyakimi zu Azore. ");
INSERT INTO kxf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azore zu Shadɔke, Shadɔke zu Akimi, yé Akimi zu Eliwude. ");
INSERT INTO kxf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwude zu Eleazare, Eleazare zu Matane, yé Matane zu Yakobo. ");
INSERT INTO kxf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo zu Yozefu akɔ Mareya ayi Yisu, á endje sœ kœ'e she Kristu. ");
INSERT INTO kxf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ataa, kœto kpœtœ Abrayamo œrrr ga tœ Davidi, uwu aatazu sœ ndjokpa dœ vana. Kœto kpœtœ Davidi œrrr ga tœ lɔndɔ á endje ko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone, uwu aatazu sœ ndje ndjokpa dœ vana; yé kœto kpœtœ lɔndɔnœ asœmœ œrrr ga tœ kœzu Kristu, uwu aatazu sœ ndje ndjokpa dœ vana. ");
INSERT INTO kxf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ndœ budu kœzu Yisu Kristu sœ atake: Ayinœ dœ Mareya kœdœ lima koje nœ Yozefu. Kashe utshunœ adœke endje ngbɔtœ endje awa bale ga tœ œsœnœ, tshe gbɔ nguzu lœ awa gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Koje nœ ye dœ Yozefu kœdœ lima uzu á tshe sœ ndjii, yé tshe yiyi lima kœmɨtshelœ ye ngbɨ fœ azu nene. Tshe yi lima kœkatœ ye tɨ lœ ubunœ. ");
INSERT INTO kxf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɓata á tshe sœ lima kœgbe atake, anga andjelu nœ Gbozu wuta ga tœ ye lœ ulu œ pa fœ she adœke: «Yozefu, ata Davidi, awa zaza ɓœ kœza Mareya tœ awo zœ nene. Gbambanœ nene, nguzunœ á sœ lœ ye asœmœ to lœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tshe zu bala gbolo yakoshe yé ɓœ ta ɨ'ɨrɨ ye Yisu; gbambanœ nene, tshe she bala azu nœ ye lœ ekperœ nœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Œneke kɔ mbœrœtœ endje ataa mbœrœ o'onœ á Gbozu pa lima lœ awa nœ ayi kœgbara o'o kœmbœrœtœ endje: ");
INSERT INTO kxf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ɔkpɔ yawuru œ gbɔ nguzu yé œ zu gbolo yakoshe yé endje ta ɨ'ɨrɨ ye Emanwele.» Ádá ɨ'ɨrɨ Emanwele kœdœ «Ndjaba awa bale dœ azœ.» ");
INSERT INTO kxf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lɔkɔ á Yozefu jo, tshe mbœrœtœ ye ɓata á andjelu nœ Gbozu mɨ lima ndɨ nœ fœ she, yé œ za Mareya tœ awonœ. ");
INSERT INTO kxf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kashe tshe ngbɔngbɔpa gbarœ olo bale dœ she nene œrrr ga tœ kœzu gbolo yakoshe nœ ye ga pa ɔshɔ, yé á Yozefu ta ɨ'ɨrɨ Yisu ga pa ye. ");
INSERT INTO kxf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Endje zu Yisu ɓa lœ Beteleme, ɓa lœ ogo Yuda dœ lɔndɔ á Erode dœ́ lima gbozugo. Manda kœzu she, agbangba kœwusœ ádá angerepe to lima ɓa tœ osho á ɔlɔ œ wuta tœnœ yé œ na. Endje yi lima kumu endje ga lœ Yerusaleme, ");
INSERT INTO kxf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yé á yu adœke: «Gbozugo nœ Ayuda á endje zu she ngɔngɔ sœ kpœta a? 'A wu angerepe nœ ye œ wuta ɓa tœ osho á ɔlɔ œ wuta tœnœ, yé á 'a na kœgote ga utshu ye.» ");
INSERT INTO kxf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lɔkɔ á gbozugo Erode djindœ upunœ ataa, tshelœ ɔkɔrɔ ye œdœ œnœ azu ogo Yerusaleme djigi tshanga ye. ");
INSERT INTO kxf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tshe vwa osho ndœ agbozu tshapa anganga Ndjaba œdœ aayi kœyisœ awa akwa, yé œ yu endje tœ osho á endje li kœzu Masiya tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Endje gi fœ she adœke: «Ɓa lœ Beteleme, ɓa lœ ogo Yuda. Gbambanœ nene, œneke á ayi kœgbara o'o su dœke: ");
INSERT INTO kxf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Œɓœ Beteleme, lœ ogo Yuda, ɓœ sœsœ adja teasho ugurutœ tshalakpɨ á sœ lœ ogo Yuda nene; gbambanœ nene, gbozunœ á tshe te bala utshu azu nœ mœ, azu Israyele, œ to ɓa ndœ zœ.”» ");
INSERT INTO kxf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dœ tœnœ ataa, Erode vwa osho ndœ agbangba kœwusœ ádá angerepe lœ ubunœ yé œ yu endje tœ kœwusœ adja lɔkɔnœ á angerepe wuta lima dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Manda nœ, tshe vwa endje ga lœ Beteleme dœ kœpa fœ endje adœke: «'E na œ yu osho pa upu nœ gbolo asœmœ dœ ɔtshɔnœ; yé œdœ 'e kœgbɔ she, 'e pandœ nœ fœ mœ adœke œmœ ndje, mœ na kœgote ga utshu ye.» ");
INSERT INTO kxf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Manda kœdji o'o á gbozugonœ pa fœ endje, endje tetœ awa dœ kœro endje. Ngbewo, endje wu angerepe á endje wu má utshunœ ɓa tœ osho á ɔlɔ œ wuta tœnœ kœna utshu endje, œrrr œ ka ɓa pa osho á gbolonœ sœ lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Endje sœ lima dœ egerœ yanga manda kœwu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Endje li ga lœ anda yé œ wu kpengbe gbolo dœ ayinœ, Mareya. Endje gote ga utshu ye yé œ donga she. Endje kɔrɔ gbarœ nœ endje yé œ ko makabo fœ she: Ɔrœ, zuwa yombo œdœ kada mire. ");
INSERT INTO kxf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Manda nœ, Ndjaba pa fœ endje lœ ulu adœke endje kwakwatœ endje ga ndœ Erode nene. Ataa, endje za anga angbɨ awa á gu dœ tœnœ ga lœ ogo nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lɔkɔ á agbangba kœwusœ ádá angerepenœ asœmœ gu daye, anga andjelu nœ Gbozu bale wuta ga ndœ Yozefu lœ ulu yé œ pa fœ she adœke: «Aafo, œ za kpengbe gbolo dœ ayinœ yé œ kpa dœ endje ga lœ Ezipito. Sœ ɓa zœ œrrr œdœ mœ kœpa fœ ɓœ adœke ɓœ gu yekane. Gbambanœ nene, Erode œ para gbolonœ mbœrœ kœwo she.» ");
INSERT INTO kxf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ataa, Yozefu kœalafo, kœza kpengbe gbolonœ œdœ ayinœ potœ ye lœ butshɔ yé á kpa ga lœ Ezipito. ");
INSERT INTO kxf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tshe sœ ɓa zœ œrrr ga tœ kuzu Erode. Œ sœ ataa, mbœrœ á œneke á Gbozu pandœ nœ lœ awa nœ ayi kœgbara o'o kœmbœrœtœ endje. Tshe pandœ nœ adœke: «Mœ e gbolo nœ mœ adœke tshe wuta lœ Ezipito ye.» ");
INSERT INTO kxf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lɔkɔ á Erode wusœ nœ adœke agbangba kœwusœ ádá angerepe fara œne, ókó za lima she tɔpanœ kpuru. Tshe za o'o adœke endje wo agbolo yakoshe á ungu endje sœ ga tshakudu ungu bisha lakpɨ Beteleme œdœ lakpɨ á sœ dje ɨndɨrɨnœ para kɔkɔ. Ungunœ á tshe ka ga panœ asœmœ sœ lindœ œneke á agbangba kœwusœ ádá angerepenœ za lima fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kɔkɔ asœmœ mbœrœtœ endje ɓata á ayi kœgbara o'o Yilimiya pa lima adœke: ");
INSERT INTO kxf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Endje dji tshama á sœ kœwuta tœnœ ɓa lœ ogo Rama, ɨkɨ œdœ egerœ dɨtshelœma. Rashele dá sœ kœkɨ agbolo nœ ye, tshe yiyindœ nœ adœke endje u œne nene, mbœrœ agbolo nœ ye tshu kɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manda kuzu Erode, anga andjelu nœ Gbozu bale wuta ga tœ Yozefu lœ ulu ɓa lœ Ezipito. ");
INSERT INTO kxf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tshe pa fœ she adœke: «Aalafo œ za gbolo œdœ ayinœ potœ zœ yé œ kwatœ zœ ga lœ ogo Israyele. Gbambanœ nene, endjeneke á endje sœ lima kœpara awa kœwo gbolonœ tshu ye.» ");
INSERT INTO kxf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yozefu áalafo, œ za gbolonœ dœ pe ayinœ potœ ye, yé á endje gu ga lœ ogo Israyele. ");
INSERT INTO kxf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kashe kœdjindœ nœ adœke Arkelawose dá te gbozugo Yuda manda abanœ dœ Erode, awa kœgu ga zœ za she. Ndjaba yisœ osho fœ she lœ ulu á tshe gitœ ye á gu ga lœ ogo Galilayi. ");
INSERT INTO kxf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tshe na œ sœ ɓa lœ ongbo á ɨ'ɨrɨnœ kœdœ Nazarete. Œ sœ ataa yeka á o'o á aayi kœgbara o'o pa lima kœmbœrœtœ endje. Endje pa lima adœke: «Endje e she bala uzu Nazarete.» ");
INSERT INTO kxf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dœ lɔndɔnœ asœmœ, Yowane ayi kœza batisimu wuta lima œ sœ kœyisœ œrœ ɓa lœ kpagagasho nœ ogo Yuda adœke: ");
INSERT INTO kxf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«'E fatshalɔsu 'e, gbambanœ nene, Ogo gbozu nœ tshalafo ndo ye!» ");
INSERT INTO kxf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowane kœdœ uzu á ayi kœgbara o'o Isaya pa lima tœ ye lɔkɔnœ á tshe pa adœke: «Anga uzu sœ kœta rawa ɓa lœ kpagagasho adœke: 'E guma ala awa Gbozu, 'e yɔrɔ ala awa ye ndjii!» ");
INSERT INTO kxf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowane verœ lima lœba á endje mbœrœ dœ usu shamo, yé œ i lima uwu tshapa lœba á endje mbœrœ dœ ɔkɔ agea ga lœ nguku ye; tshe zɨ lima ayila yé œ la adja ojoro awaterœ. ");
INSERT INTO kxf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Azu tshalakpɨ Yerusaleme dœ azu ogo Yuda kɔ œdœ pe azu ogo kɔ á sœ mashenga dœ ungu Yɔrdane, na lima ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Endje sœ lima kœpandœ ekperœ nœ endje, yé Yowane sœ lima kœza batisimu fœ endje ɓa la Yɔrdane. ");
INSERT INTO kxf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yowane wu adœke Afarisayi œdœ Asadukayi ndjoro sœ kœna lima ga tœ œsœ batisimu nœ ye, tshe pa fœ endje adœke: «Ukpulu ekpe ayakoro! Uzu ɗe dá yisœ nœ fœ 'e adœke 'e kpa awa kœwa ngbanga nœ Ndjaba á ndo kœna tœnœ a? ");
INSERT INTO kxf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'E mbœrœ œrœ á sœ kœma adœke adja 'e fatshalɔsu 'e ye, ");
INSERT INTO kxf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","yé 'e papa mbœrœ 'e dœ tœ 'e nene adœke: “Abrayamo kœdœ ata azœ.” Gbambanœ nene, mœ sœ kœmɨndœ nœ fœ 'e adœke, Ndjaba li kœfa badja asœke tœ aata Abrayamo! ");
INSERT INTO kxf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gonda sœ yindjindjinœ mbœrœ kœvwa dœ ɔyɔ tɔtœ œshenœ kɔ ye, ɔyɔ kɔ á elenœ kœgaga nene, endje de yé œ ko va ga tœ owo. ");
INSERT INTO kxf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Œmœ, mœ sœ kœza batisimu fœ 'e dœ ungu mbœrœ kœma adœke 'e yapa ɔtshɔ 'e ye. Kashe tsheneke á tshe na manda mœ, tshe za bala batisimu fœ 'e dœ Ɔtshɔ Ɨshirɨ œdœ dœ owo. Tshe ropa mœ dœ gbɔgbɔ ye, mœ lili kœka ga utshu ye dœ pe kœzu uwu œrada nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tshe za tshekara kœpe dœ tshelœ indji ngwarœ ga tshaabrœ ye, yé tshe mea indji ngwarœ mbœrœ kœkurutshelœ nœ dœ oforo. Tshe gumasœ indji ngwarœ ga la kogba, yé œ ko oforonœ va ga tœ owo neke á ru nene.» ");
INSERT INTO kxf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anga ɔlɔ bale, Yisu to ɓa lœ Galilayi yé œ ro ɓa ndœ Yowane ɓa langu Yɔrdane, tshe na ndoo dœ Yowane mbœrœ adœke tshe za batisimu fœ œne. ");
INSERT INTO kxf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yowane yi lima ndœ kœvwaratœ ye, yé á pa adœke: «Œmœ dá li má adœke ɓœ za batisimu fœ mœ, yé ɓœ kpa na ga ndœ mœ adœke mœ za batisimu fœ ɓœ a!» ");
INSERT INTO kxf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kashe Yisu gi fœ she adœke: «Yindœ nœ adœke œ mbœrœtœ ye ngɔngɔnœ asœke ataa. Gbambanœ nene, mara á li adœke a mbœrœ œrœ á sœ ndjii dœmœ.» Yé Yowane kœyindœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Manda kœgbɔ batisimu nœ Yisu, tshe wuta langu. Kolœ pe dœ lɔndɔnœ asœmœ, tshalafo kɔrɔ ga pa ye, tshe wu Ɨshirɨ nœ Ndjaba œ jerœ ga pa ye ɓata mbepa. ");
INSERT INTO kxf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yé tshama to ɓa lafo œ pa adœke: «Tsheneke asœke kœdœ Gbolo nœ mœ á mœ yindœ ye waa, mœ za yanga nœ mœ kɔ ga ndœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manda nœ, Ɨshirɨ nœ Ndjaba to Yisu na tœnœ ga lœ kpagagasho mbœrœ adœke djaboro wu lɔsu ye. ");
INSERT INTO kxf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Manda kœmbœrœ ɔlɔ zazu bisha œdœ butshɔ zazu bisha ndœ kœyotshelœma, Yisu sœ lima dœ ogo. ");
INSERT INTO kxf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Djaboro, ayi kœwu lɔsu, na ndoo dœ she yé œ pa adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, pa fœ badja asœke œ fatœ ye tœ mapa.» ");
INSERT INTO kxf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kashe Yisu gi adœke: «Endje sú ɓa la Buku nœ Ndjaba adœke: “Uzu œ sœ dœ soro kolœ mbœrœ mapa nene, kashe dœ o'o kɔ á wuta lœ ama Ndjaba.”» ");
INSERT INTO kxf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dœ tœnœ ataa, djaboro na dœ she œrrr ɓa lœ Yerusaleme á dœ ongbo á sœ yerœ, œ za she tɔ ɓa pa kumu Tepelo, ");
INSERT INTO kxf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","á œ pa fœ she adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, i dœ tœ zœ tshirɨ ga atɨ. Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Ndjaba œ za awa o'o fœ aandjelu nœ ye mbœrœ ɓœ, endje za ɓœ ga atɨ dœ kane endje mbœrœ á ɓœ kœzaza ada zœ tɔ badja nene.”» ");
INSERT INTO kxf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yé Yisu gi fœ she adœke: «Endje su ndje ɓa la Buku nœ Ndjaba adœke: “Wuwu lɔsu Gbozu Ndjaba nœ zœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Djaboro kpa ɔ dœ she œrrr ɓa tœ leta kumu ɨngɨrɨ kaga œ ma ogo gbozu tshapashɔ djigi dœ ɔtshɔrœ, ndje dœ mokɔnœ fœ she, ");
INSERT INTO kxf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yé á pa fœ she adœke: «Mœ ko œrœnœ asœke kɔ fœ ɓœ œdœ ɓœ kœgote ga utshu mœ mbœrœ kœdonga mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yé Yisu kœgi fœ she adœke: «Gitœ zœ ga zœ, Satana! Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Donga Gbozu Ndjaba nœ zœ, yé œ za avwala kolœ fœ she tshebabale.”» ");
INSERT INTO kxf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndara tœ asœke, djaboro kœkatœ ye yé. Aandjelu kœgitœ endje ndoo dœ she, yé á kœtetœ kœmbœrœ akwa fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lɔkɔ á Yisu dji adœke endje za Yowane ayi kœza batisimu ga lœ kánga, tshe kwatœ ye ga lœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tshe katœ Nazarete tɨ, œ na kœsœ ɓa lœ Kaparnawumu, ongbo á sœ tœ mangu egerœ ungu adanga nœ Galilayi, ɓa lœ ogo Zabulone œdœ pe ɓa lœ Nefetali. ");
INSERT INTO kxf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Œ sœ lima ataa mbœrœ adœke o'o á ayi kœgbara o'o Isaya pa tœnœ, kœmbœrœtœ endje. Tshe pa o'onœ adœke: ");
INSERT INTO kxf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ogo Zabulone œdœ Nefetali, á sœ tœ awa kœro ga la egerœ ungu adanga, ɓa kele ungu Yɔrdane, ogo Galilayi á angbɨ azu sœ lœnœ asœmœ! ");
INSERT INTO kxf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Azunœ á endje sœ lœ ubu osho asœmœ, wu egerœ ɨngbɨsho! Mbœrœ endjeneke á endje sœ lœ ubu osho nœ kuzu, ɨngbɨsho wuta ga pa endje!» ");
INSERT INTO kxf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pe dœ lɔkɔnœ asœmœ, Yisu tetœ kœyisœ œrœ adœke: «'E yapa ɔtshɔ 'e, gbambanœ nene, Ogo gbozu nœ tshalafo ndo ye!» ");
INSERT INTO kxf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ɔlɔ bale, Yisu sœ lima kœna tœ mangu egerœ ungu adanga nœ Galilayi, yé œ wu aayazu bisha, Shimu á anga ɨ'ɨrɨ ye kœdœ Petro œdœ ayanœ dœ Andere á endje dœ lima aayi kœpara ageatshalangu. Endje sœ lima kœvwi gbanda ɓa la egerœ ungu adanga. ");
INSERT INTO kxf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yisu pa fœ endje adœke: «'E na manda mœ, mœ fa 'e tœ aayi kœpara azu.» ");
INSERT INTO kxf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pe kpœtœ œsœnœ, endje ka lima tœ gbanda nœ endje tɨ yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tshe na lœ ɨngɨrɨnœ, œ kpa wu anga aayazu bisha, Ayakobo dœ ayanœ dœ Yowane, endje kœdœ agbolo nœ Zebedayi. Endje sœ lima lœ agba nœ endje awa bale dœ aba endje dœ Zebedayi, yé œ sœ lima tœ kœguma gbanda nœ endje. Yisu e endje. ");
INSERT INTO kxf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pe kpœtœ œsœnœ, endje katœ agba œdœ aba endje tɨ, yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisu ro djelœ ogo Galilayi djigi; tshe sœ lima kœyisœ œrœ ɓa lœ Sinagoga para. Tshe sœ lima kœmɨndœ Ɔtshɔ O'o nœ ogo gbozu yé œ sœ lima kœshe azu lœ koɓa œdœ lœ gbakɨndɨ nœ endje kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Upu nœ ye za lima ogo Siri djigi, yé endje sœ lima kœna dœ azu á endje sœ lima dœ tshelœ aka koɓa kɔ fœ she, azu á endje sœ dœ ekpe ɨshirɨ pa endje, dœ azu á endje sœ dœ koɓa ɔkɔ œdœ endjeneke á ada endje tshu. Yé Yisu she lima endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ukpulu azu ndjoro na lima manda ye: Endje to lima ɓa lœ Galilayi, ɓa lœ ogonœ á endje e ɨ'ɨrɨnœ adœke tshalakpɨ ndjokpa asœmœ, dœ azu Yerusaleme ndje dœ ogo Yuda, œdœ endjeneke ɓa lœ ogo á sœ ɓa kele ungu Yɔrdane. ");
INSERT INTO kxf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lɔkɔ á Yisu wu ukpulu azu asœmœ, tshe ɔ ga pa kaga yé œ sœ ga atɨ. Ayambarœ nœ ye na ga ɨndɨrɨ ye, ");
INSERT INTO kxf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yé á tshe tetœ kœyisœ œrœ fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Yanga nœ azu á endje sœ dœ lɔsu nœ oyo, gbambanœ nene, Ogo gbozu nœ tshalafo kœdœ œnœ endje! ");
INSERT INTO kxf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yanga nœ azu á endje sœ tœ ɨkɨ, gbambanœ nene, Ndjaba œ turu ngola endje! ");
INSERT INTO kxf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yanga nœ azu á endje sœ dœ lɔsu zɨtɨ, gbambanœ nene, endje gbɔ bala ogonœ á Ndjaba pa tœnœ! ");
INSERT INTO kxf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yanga nœ azu á endje sœ dœ adja ogo kœmbœrœ œrœ á sœ ndjii, gbambanœ nene, Ndjaba œ to gbɔgbɔ kœmbœrœ tœnœ fœ endje! ");
INSERT INTO kxf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yanga nœ azu á endje wu oyo anga endje, gbambanœ nene, Ndjaba œ wu oyo endje! ");
INSERT INTO kxf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yanga nœ azu á lɔsu endje sœ yerœ, gbambanœ nene, endje wu bala Ndjaba! ");
INSERT INTO kxf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yanga nœ azu á endje sœ kœmbœrœ adœke kœsœ gee sœ ugurutœ azu, gbambanœ nene, Ndjaba œ e endje agbolo nœ ye! ");
INSERT INTO kxf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yanga nœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ endje mbœrœ œneke á sœ ndjii; gbambanœ nene, Ogo gbozu nœ tshalafo sœ mbœrœ endje! ");
INSERT INTO kxf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yanga nœ 'e œ kœsœ adœke azu gu 'e, œ mbœrœ œrœ kanga fœ 'e yé œ pa tshelœ áká ekpe o'o kɔ ga tœ 'e mbœrœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'E mɔtœ 'e yé œ sœ dœ egerœ yanga; gbambanœ nene, œrœ tshangbanœ sœ kœkate 'e tœ egerœnœ ɓa lafo. Kolœ dœ maranœ ataa, endje mbœrœ ndje lima œrœ kanga fœ aayi kœgbara o'o á endje sœ lima utshu 'e.» ");
INSERT INTO kxf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«E'e kœdœ ɨngbɨrɨ tshapashɔ. Kashe œ kœsœ adœke kœnga ɨngbɨrɨ ka lœnœ ye, endje kpa gi ga lœnœ koto o? Endje kpa li kœmbœrœ tœnœ dœ akwa bale nene. Endje za va e ga ushu, yé azu œ na pa nœ dœ ada endje. ");
INSERT INTO kxf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«E'e kœdœ ɨngbɨsho tshapashɔ. Ongbo á sœ ɓa pa kaga, œ li kœzatœ ye yiwa tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Endje tata owo ga tœ miinda mbœrœ kœza ga tshakudu losú nene. Kashe endje za ɓa pa gbarœ kœza miinda ga panœ yekane á kœtshi pa azu kɔ á endje sœ lœ anda. ");
INSERT INTO kxf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Awa bale ndje, œ li adœke ɨngbɨsho nœ 'e tshi ɓa utshu azu mbœrœ adœke endje wu ɔtshɔrœ á 'e sœ kœmbœrœ tœnœ, yeka á kœdonga Aba 'e á tshe sœ ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«'E gbegbe adœke mœ na kœwo awa akwa œdœ aayi kœgbara o'o nene. Mœ nana kœwo tœnœ œ wo nene, kashe mœ na adœke œneke á endje pa kœmbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mœ mɨndœ nœ fœ 'e dœ adjapu adœke: Ɓata œndœ tshalafo dœ pe tshapashɔ sœpe kœdɨ tœnœ, tshakanea a'eara uwu mbeti œneke á endje sú ala buku nœ awa akwa œ 'ɨ nene œrrr ga tœ adœke œrœ kɔ mbœrœtœ ye yekane. ");
INSERT INTO kxf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mbœrœ tœnœ ataa, œdœ uzu kœvwaratœ ye kœlɨsœ anga awa o'o teasho lœ awa akwanœ asœke yé á sœ kœyisœ nœ fœ anga azu adœke endje mbœrœ ndje awa bale, uzunœ asœmœ œ dœ bala aya uzu ɓa lœ Ogo gbozu nœ tshalafo. Kashe uzu á tshe lɨsœ awa akwanœ yé á yisœ nœ fœ anga azu adœke endje lɨsœ nœ, uzunœ asœmœ œ dœ bala egerœ uzu ɓa lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO kxf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mœ sœ kœpa fœ 'e adœke, œdœ 'e kœsœsœ kœmbœrœ œrœ á sœ ndjii kœropa œnœ aayi kœyisœ awa akwa œdœ Afarisayi nene, 'e li kœli ga lœ Ogo gbozu nœ tshalafo nene.» ");
INSERT INTO kxf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«'E dji adœke endje pa lima fœ aata azœ adœke: “Ɓœ wo uzu nene. Uzu kɔ á tshe wo yanganœ, œ li adœke endje na dœ she ga utshu aayi kœwa ngbanga.”» ");
INSERT INTO kxf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: «Uzu kɔ á tshe kœsœ dœ ókó ga tœ ayanœ, œ li adœke endje na dœ she ɓa utshu aayi kœwa ngbanga. Uzu á tshe kœgu ayanœ adœke: “Wusœrœ wu”, œ li adœke endje na dœ she ɓa lœ anda kœwa ngbanga nœ azu nœ Ndjaba. Uzu á tshe kœgu ayanœ adœke: “Iyi sœ lœ kumu zœ!” Œ li adœke endje vwi she ga lœ lifelo.» ");
INSERT INTO kxf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Œdœ ɓœ kœna kœkatœ makabo nœ zœ ga pa ndaba fœ Ndjaba, á ɓœ gbetshelœ zœ ɓa zœ adœke aya zœ sœ dœ o'o ga tœ zœ, ");
INSERT INTO kxf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","katœ makabo nœ zœ tɨ kpœtœmœ, ɓa utshu ndabanœ yé œ na utshunœ œ guma tshagurutœ zœ dœ aya zœ, yeka á kœna kœkatœ makabonœ fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Œdœ ɓœ kœsœ dœ upu dœ yanga zœ, pa avwara katsha adœke ɓœ djitœ zœ dœ she damba á 'e sœpe tœ ala awa. Œdœ ɓœ kœmbœmbœrœ ataa nene, tshe za ɓœ ga utshu ayi kœwa ngbanga, ayi kœwa ngbanga œ za ɓœ fœ aprusu, yé aprusunœ œ za ɓœ vwi ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mœ mɨndœ nœ fœ ɓœ dœ adjapu adœke, œdœ endje kœvwi ɓœ ga lœ kánga, œrrr ɓœ ko ngendja á endje dɨ fœ ɓœ para kɔkɔ yekane á wuta.» ");
INSERT INTO kxf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«'E dji o'o á endje pa lima adœke: “Ɓœ para awo uzu nene.” ");
INSERT INTO kxf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: uzu kɔ á tshe kœsœ kœtondœ awo yanganœ dœ ala nœ kœyindœsho, tshe para she ye dœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yé œdœ ɓœ kœsœ kœli ga lœ ekperœ mangba ala zœ á sœ ga tœ kuni zœ, œ li adœke ɓœ vwata œ za vwi'i lœ ɨngɨrɨnœ tœ zœ. Gbambanœ nene, œ sœ dœ ɔtshɔnœ mbœrœ ɓœ adœke anga œrœ kote zœ bale ndɨ, tœ œsœnœ adœke endje za undu zœ djigi vwi ga lœ lifelo. ");
INSERT INTO kxf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Œdœ ɓœ kœsœ kœli ga lœ ekperœ mangba kuni zœ, œ li adœke ɓœ de œ za vwi'i lœ ɨngɨrɨnœ tœ zœ. Gbambanœ nene, œ sœ dœ ɔtshɔnœ mbœrœ ɓœ adœke anga tshakala kane zœ bale ndɨ, tœ œsœnœ adœke endje za undu zœ djigi vwi ga lœ lifelo.» ");
INSERT INTO kxf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Endje kpa pa lima adœke: “Œdœ uzu kœkatœ awonœ tɨ, œ li adœke tshe za mbeti kœkurutshelœ totœ fœ she.” ");
INSERT INTO kxf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: Uzu kɔ á tshe katœ awonœ tɨ mbœrœ á tshe mbœrœ angba budu tshakane ye nene, tshe vwa yashenœ asœmœ ndœ kœmbœrœ angba budu. Yé uzu kɔ á tshe to yashe á akɔnœ katœ ye tɨ, tshe mbœrœ ndje angba budu dœ yashenœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«'E kpa dji o'o á endje pa lima fœ aata azœ. Endje pa lima adœke: “Wawa ɨgɨ zœ ndœ wala nene, kashe mbœrœ œrœ á ɓœ wa ɨgɨ zœ ɓa utshu Gbozu Ndjaba tœ upunœ.” ");
INSERT INTO kxf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yé œmœ, mœ pa fœ 'e adœke 'e wawa ɨgɨ 'e bale nene. 'E wawa dœ ɨ'ɨrɨ tshalafo nene; gbambanœ nene, œtœnœ kœdœ ngande tshagbozu nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'E wawa ɨgɨ 'e dœ ɨ'ɨrɨ ɔshɔ nene; gbambanœ nene, œtœnœ kœdœ osho kœsœ á Ndjaba œ ko ada ye ga tœnœ. 'E wawa ɨgɨ 'e dœ ɨ'ɨrɨ Yerusaleme nene; gbambanœ nene, œtœnœ kœdœ ongbo nœ egerœ Gbozugo. ");
INSERT INTO kxf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Adja wawa ɨgɨ zœ bale dœ kumu zœ nene; gbambanœ nene, ɓœ li kœmbœrœ adœke anga sukumu zœ bale wuta tœ imbinœ too tœ ubunœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pa kolœnœ “Œ̃” œ kœdœ “Œ̃”, yé “œ̃œ̃” œ kœdœ “œ̃œ̃”. Œneke kɔ á ɓœ kpa ko ga pa nœ asœmœ, œ to ɓa ndœ Satana.» ");
INSERT INTO kxf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«'E dji œneke á endje pa lima adœke: “Uzu kœsu ala zœ, ɓœ su ndje ala ye; yé uzu kœkɔ iji zœ, ɓœ kɔ ndje iji ye.” ");
INSERT INTO kxf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yé œmœ, mœ pa fœ 'e adœke 'e gigi ekperœ fœ uzu á tshe mbœrœ ekperœ fœ 'e nene. Œdœ uzu kœda baga zœ ga tœ kuni, fa œnœ gele fœ she yé tshe kpa da ndje. ");
INSERT INTO kxf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Œdœ uzu kœtɔ meza pa zœ fœ ayi kœwa ngbanga adœke œne za lœba okoro nœ zœ tœ zœ ye, ka ndje tœ yɔgbɔdɔ lœba nœ zœ tɨ fœ she yé tshe za ndje. ");
INSERT INTO kxf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Œdœ uzu kœza ɓœ dœ ɔgbɔ adœke ɓœ za gbarœ œ gi dœ œne mangba uwu ada kutu bale, za gbarœnœ œ gi dœ she mangba uwu ada kutu bisha. ");
INSERT INTO kxf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","To œrœ fœ uzu á tshe esho ndœ œrœ tœ zœ. Œdœ uzu kœ'esho ndœ kuɗa ɓa ndœ zœ, vwavwaratœ zœ tœ kœza fœ she nene.» ");
INSERT INTO kxf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«'E dji œneke á endje pa lima adœke: “Yindœ yanga zœ yé œ yiangba yingba zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yé œmœ, mœ pa fœ 'e adœke 'e yindœ ayingba 'e, yé œ za avwala fœ Ndjaba mbœrœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ 'e, ");
INSERT INTO kxf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","yeka á 'e kœwuta agbolo nœ Aba 'e á tshe sœ ɓa lafo. Gbambanœ nene, tshe sœ kœmbœrœ adœke ɔlɔ nœ ye tɔ ga pa aayi kœmbœrœ ekperœ dœ aayi kœmbœrœ ɔtshɔrœ. Tshe sœ kœmbœrœ ndje adœke yavuru ni ga pa azu á endje sœ ndjii dœ azu á endje sœsœ ndjii nene. ");
INSERT INTO kxf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gbambanœ nene, œdœ 'e kœyi kolœ ndœ azu á endje yindœ 'e, œrœ tshangbanœ á 'e gbɔ kœdœ gaɗe? Aayi kœko ngendja lapo mbœmbœrœ ndje dœ tœ endje atamœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Œdœ 'e kœsœ kœbala kolœ aaya 'e, 'e gbe adœke 'e mbœrœ egerœ œrœ a? Azu á endje wuwusœ Ndjaba nene mbœmbœrœ ndje atamœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ataa, Aba 'e ɓa lafo sœ yerœ, e'e ndje 'e sœ ɓata she.» ");
INSERT INTO kxf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ala 'e gbɔ tœ mara á 'e sœ kœmbœrœ dœ akwa nœ Ndjaba tœ ala azu kane. 'E mbœmbœrœ ɔtshɔrœ á Ndjaba yindœ nœ kolœ adœke azu wu 'e nene. Œdœ 'e kœmbœrœ ataa, 'e gbɔ œrœ tshangba nœ ɓa ndœ Aba 'e á tshe sœ ɓa lafo asœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ataa, lɔkɔ á ɓœ kœto œrœ fœ ayi oyo, ɓiɓi dœ itshi adœke ala azu kɔ sœ ga tœ zœ nene, ɓata á awulapatshɔ œ mbœrœ ɓa lœ Sinagoga œdœ ɓa tœ ala awa. Endje sœ kœmbœrœ ataa adœke azu donga œne. Mœ mɨndœ nœ dœ adjapu fœ 'e adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kashe œɓœ, œdœ ɓœ kœto œrœ fœ ayi oyo, mbœmbœrœ adœke gele zœ wusœ œneke á kuni zœ mbœrœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ataa, œ li adœke œrœnœ á ɓœ to asœmœ sœpe lœ ubunœ. Yé Aba zœ á tshe wu œrœ á mbœrœtœ endje lœ ubunœ, œ gi œrœ tshangbanœ fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Œdœ 'e kœsœ kœza avwala fœ Ndjaba, 'e sœsœ ɓata awulapatshɔ nene. Endje yindœ nœ adœke œne li ɓa lœ Sinagoga too œne wuta ɓa lœ shangbeda awa, œ ka dœ ada œne yeka á kœza avwala adœke azu kɔ kœwu œne. Mœ pa fœ 'e dœ adjapu adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kashe œɓœ, œdœ ɓœ kœyindœ kœza avwala, li ga lœ gbɔshɔ nœ zœ œ tshu manda ga tœnœ, yé œ za avwala fœ Aba zœ á tshe sœ ɓa zœ ɓa tœ osho á sœ lœ ubunœ. Yé Aba zœ á tshe wusœ œrœ kɔ á sœ lœ ubunœ, œ gi œrœ tshangba nœ fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Œdœ 'e kœsœ kœza avwala, 'e papa o'o œrrr ɓata azu á endje wuwusœ Ndjaba nene œ pa. Endje sœ kœgbe adœke œdœ œne kœpa o'o œrrr dá Ndjaba œ dji œne dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'E mbœmbœrœ ɓata endje nene; gbambanœ nene, Aba 'e wusœ œneke á 'e sœ dœ ogonœ utshunœ adœke 'e yu she tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'E wu mara á li adœke 'e za dœ avwala: “Aba 'a á ɓœ sœ ɓa lafo, kaka azu kɔ wusœ nœ adœke ɨ'ɨrɨ zœ sœ yerœ. ");
INSERT INTO kxf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kaka Ogo gbozu nœ zœ na, kaka gbetshelœ nœ zœ mbœrœtœ endje ɓa pa ɔshɔ ɓata á mbœrœtœ endje ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","To rœgo á li adœke 'a zɨ kpesheke fœ 'a. ");
INSERT INTO kxf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Djerœndœ ekperœ nœ 'a, ɓata 'a djerœ ndje ndœ ekperœ nœ endjeneke á endje mbœrœ fœ 'a. ");
INSERT INTO kxf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yé kakatœ 'a tɨ adœke 'a li ga lœ kœwu lɔsu nene, kashe vwara 'a lœ ekperœ. Gbambanœ nene, œɓœ kœdœ Gbozu, á ɓœ sœ dœ gbɔgbɔ œdœ mokɔ waa dœ waa. Ame.” ");
INSERT INTO kxf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yé œdœ 'e kœdjerœndœ ekperœ nœ azu, Aba 'e á tshe sœ ɓa lafo œ djerœ ndje ndœ ekperœ nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kashe œdœ 'e kœdjedjerœndœ ekperœ nœ azu nene, Aba 'e œ djerœndœ ekperœ nœ 'e á 'e mbœrœ bale nene.» ");
INSERT INTO kxf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Lɔkɔ á 'e kœsœ kœyotshelœma 'e, 'e sœsœ dœ oyo ɓata á awulapatshɔ œ mbœrœ nene. Endje sœ kœndɨ tshatshu endje dœ mara adœke azu kɔ wusœ nœ adœke œne sœ kœyotshelœma œne. Mœ mɨndœ nœ fœ 'e dœ adjapu adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kashe œɓœ, œdœ ɓœ kœsœ kœyotshelœma zœ, djutɔ tshatshu zœ, yé œ da kada, ");
INSERT INTO kxf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mbœrœ azu kœwuwusœ nœ adœke ɓœ sœ kœyotshelœma zœ nene. Kashe kolœ Aba zœ á tshe sœ ɓa zœ lœ ubunœ, œshe dá wusœ nœ. Œdœ ɓœ kœmbœrœ ataa, Aba zœ á tshe wu œrœ á sœ lœ ubunœ asœmœ, œ to œrœ tshangbanœ fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«'E ngbɔngbɔɓa kœgbɔrœ tshapashɔ asœke nene. Gbambanœ nene, ɓa zœ akɔkɔ œ zɨ, ngbandji œ ndɨ kotenœ yé aayi angba œ kavwa manda œ zɨangba nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kashe 'e ngbɔɓa kœgbɔrœ ɓa lafo. Gbambanœ nene, ɓa zœ œdœ akɔkɔ œ zɨ nene, œdœ ngbandji œ ndɨ nene, yé aayi angba gugu ndje tœ kœkavwa manda á kœzɨ angbanœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gbambanœ nene, osho á kœgbɔrœ nœ zœ sœ tœnœ, lɔsu zœ œ sœ ndje kpœtœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ala uzu kœdœ miinda nœ undu ye. Œdœ ala zœ kœsœ dœ ɔtshɔnœ, undu zœ djigi œ sœ lœ ɨngbɨsho. ");
INSERT INTO kxf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kashe œdœ ala zœ kœsœ dœ koɓa, undu zœ djigi œ sœ lœ ubu osho. Ataa, œdœ ɨngbɨsho á sœ lœ zœ kœdœ ubu osho, ubu oshonœ asœmœ kpa sœ narɨ!» ");
INSERT INTO kxf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Uzu bale lili kœmbœrœ akwa fœ agbozu bisha nene. Gbambanœ nene, œdœ tshe kœyiangba anga bale, tshe yindœ udu anga. Tshe kœzatœ ye fœ anga bale, tshe tɨtœ ye tœ udu anga. 'E lili kœmbœrœ akwa fœ Ndjaba yé œ kpa za ndje tœ 'e fœ ngendja nene.» ");
INSERT INTO kxf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«'E wu ádánœ á mœ mɨndœ nœ fœ 'e adœke: 'E zaza lɔsu 'e ga lafo tœ upu nœ kœzɨrœ œdœ kœndjorœ á 'e gbe dœ tœnœ mbœrœ soro 'e nene, too kœgbe dœ lœba á 'e yindœ kœverœ ga tœ kote 'e nene. Soro uzu roropa kœzɨrœ nene a? Yé undu uzu roropa lœba nene a? ");
INSERT INTO kxf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","'E tondœ ayanu kane. Endje lulu ngwarœ nene, œ kɔkɔ ndje œrœ nene yé œ gugu dœ kogba kœgumasœ rœgo ga lœnœ nene, kashe Aba 'e á tshe sœ ɓa lafo sœ kœto kœzɨrœ fœ endje. 'E roropa endje nene a? ");
INSERT INTO kxf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Œɗe ugurutœ 'e, lœ kœgbetshelœ ye, dá li kœza anga olo bale ga pa olo soro ye a? ");
INSERT INTO kxf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Yé mbœrœ gaɗe á 'e sœ kœza lɔsu 'e ga lafo tœ upu nœ lœba a? 'E wu mara á ndɔkɔ leyɔ œ wuta dœ tœnœ ɓa lœ kɨndɨ kane: Œ sœ kœmbœrœ akwa nene, œ sœ ndje kœsu lœba nene. ");
INSERT INTO kxf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kashe mœ pa fœ 'e adœke, Salomo á tshe dœ́ lima ayi kœgbɔrœ waa, veverœ lima lœba bale ɓata anga ndɔkɔ leyɔnœ asœke nene. ");
INSERT INTO kxf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndjaba dá verœ lœba kpesheke ga tœ gusu á sœ lœ kɨndɨ yé ɓa mbatsha owo œ ju. Œdœ Ndjaba kœmbœrœ ataa ga tœ a'eara ɔyɔ, tshe lili kœko lœba fœ 'e kœropa nœ nene a? E'e kœdœ azu á kœyindœrœ nœ 'e sœ teasho! ");
INSERT INTO kxf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'E zaza lɔsu 'e ga lafo tœ kœyutœ 'e nene adœke: “'A zɨ gaɗe? 'A ndjo gaɗe? 'A verœ lœba gaɗe?” ");
INSERT INTO kxf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Azu á endje wuwusœ Ndjaba nene dá para œrœnœ asœmœ kɔ. Kashe Aba 'e á tshe sœ ɓa lafo wusœ nœ adœke 'e gbe dœ tœnœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'E para utshunœ Ogo gbozu nœ Ndjaba, œdœ œrœ á sœ ndjii ɓa utshu Ndjaba, yé udu œrœ kɔkɔ, Ndjaba œ to fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ataa, 'e zaza lɔsu 'e ga lafo tœ upu nœ œrœ á mbœrœtœ endje ɓa mbatsha nene. Tshambatsha sœ ndje dœ upu nœ ye. Olo bale dœ bale sœ dœ o'o nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«'E wawa ngbanga pa uzu bale nene, mbœrœ á Ndjaba kœwawa ndje ngbanga pa 'e nene. ");
INSERT INTO kxf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gbambanœ nene, Ndjaba œ wa ngbanga pa 'e ɓata á 'e wa ga pa anga 'e. Adja mara œrœ á 'e li dœ anga 'e dá tshe li ndje dœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mbœrœ gaɗe á ɓœ sœ kœtondœ oforo ebe á sœ lœ ala aya zœ yé á gbegbe dœ maɓaya á sœ lœ ala zœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Koto á ɓœ pa fœ aya zœ adœke: “Kaka mœ tshakavwa oforo ebe á sœ lœ ala zœ”, andaa maɓaya sœ lœ œnœ zœ a? ");
INSERT INTO kxf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wulapatshɔ, tshakavwa maɓaya á sœ lœ ala zœ asœmœ utshunœ œ wu osho ngbɨ yeka á kœtshakavwa oforo ebe á sœ lœ ala aya zœ. ");
INSERT INTO kxf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«'E toto œrœ neke á sœ yerœ fœ ayavoro nene. Œdœ 'e kœmbœrœ ataa, endje fatshelœtœ endje tœ 'e œ lo 'e. 'E koko agbɔ œrœ tshelœ ɨgɨ nœ 'e va fœ akɔso nene kparawa adœke endje kœzurutshelœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«'E kœyɔndœ œrœ, endje to fœ 'e ye; 'e kœpara œrœ, 'e gbɔ ye; 'e kœnge manda, endje kɔrɔ fœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gbambanœ nene, uzu kɔ á tshe yɔndœ œrœ, endje to fœ she; tsheneke á tshe para œrœ, tshe gbɔ; yé tsheneke á tshe nge manda, endje kɔrɔ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Œɗe ugurutœ 'e dá za badja fœ gbolo nœ ye œdœ tshe kœyɔndœ kœzɨrœ a? ");
INSERT INTO kxf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Too œdœ tshe kœyu she ndœ ageatshalangu, tshe za yakoro fœ she a? ");
INSERT INTO kxf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ataa, œdœ 'e á 'e dœ akpe azu, 'e wusœ kœto ɔtshɔrœ fœ agbolo nœ 'e, yekane Aba 'e á tshe sœ ɓa lafo kœtoto ɔtshɔrœ fœ endjeneke á endje yɔndœ nœ ɓa ndœ ye nene a? ");
INSERT INTO kxf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«'E mbœrœ fœ anga 'e ɓata œneke á 'e yindœ nœ adœke endje mbœrœ fœ 'e. Asœ kœdœ œneke á awa akwa œdœ aayi kœgbara o'o nœ Ndjaba yisœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«'E li tœ aya manda. Gbambanœ nene, manda kœro ga ndœ kuzu sœ tœ egerœnœ, awa kœ li ga zœ sœ ndje ngbɨ yé azu á endje ro tœnœ lœ ndjoro. ");
INSERT INTO kxf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kashe manda nœ soro á ka nene sœ teasho, awa á ro ga zœ mi dœ gusu yé azu kœro tœnœ mɨmɨ.» ");
INSERT INTO kxf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«'E sœ dœ gbɔdjela tœ aayi kœgbara o'o nœ wala. Gbambanœ nene, endje sœ kœna ga ndœ 'e ɓata apata kashe lɔsu endje sœ ɓata lɔsu amuru á endje wo osho. ");
INSERT INTO kxf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'E wusœ endje mbœrœ akwa tshelœ endje. Gbambanœ nene, endje kɔkɔ ɔtshɔ leyɔ ɓa tœ ekpe ɔyɔ nene, endje kɔkɔ ndje ele fige ɓa tœ batima nene. ");
INSERT INTO kxf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ɔtshɔ ɔyɔ kɔ sœ kœzu ɔtshɔ elenœ, yé ɔyɔ á sœ dœ koɓa sœ kœzu ndje elenœ tœ ekpenœ. ");
INSERT INTO kxf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɔtshɔ ɔyɔ lili kœzu elenœ tœ ekpenœ nene, yeka ɔyɔ á sœ dœ koɓa œ zu ndje ɔtshɔ elenœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɔyɔ kɔ á elenœ kœgaga nene, endje de yé œ ko va ga tœ owo. ");
INSERT INTO kxf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ataa, 'e wusœ aayi kœgbara o'o nœ wala mbœrœ akwa tshelœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Œ dœ́dœ́ uzu kɔ á tshe e mœ adœke: “Gbozu, Gbozu”, dá li ga lœ Ogo gbozu nœ tshalafo nene, kashe kolœ endjeneke á endje sœ kœmbœrœ œrœ á Aba mœ á tshe sœ ɓa lafo yindœ nœ, dá li ga zœ. ");
INSERT INTO kxf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dœ lɔkɔnœ asœmœ, azu ndjoro œ pa bala adœke: “Gbozu, Gbozu”, 'a gbara lima o'o dœ ɨ'ɨrɨ zœ; 'a gɔrɔ lima ekpe ɨshirɨ dœ ɨ'ɨrɨ zœ; 'a mbœrœ lima afá ndjoro dœ ɨ'ɨrɨ zœ! ");
INSERT INTO kxf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yé mœ pa bala ngbɨ fœ endje adœke: “Mœ wuwusœ 'e bale nene, e'e dœ́ aayi kœmbœrœ ekperœ, 'e gitœ 'e tœ ala mœ!”» ");
INSERT INTO kxf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yisu kpa pa adœke: «Uzu kɔ á tshe kœdji o'o á mœ totœ kœpa tœnœ asœke yé á za ga tœ akwa, tshe sœ ɓata uzu nœ kœwusœrœ á tshe mɔ anda nœ ye ga pa badja. ");
INSERT INTO kxf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yavuru ni, ungu sú yé egerœ yugu na œ za kpɨkpɨkpɨ, kashe andanœ tete nene. Gbambanœ nene, endje mɔ lima kiti andanœ ga pa badja. ");
INSERT INTO kxf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kashe uzu kɔ á tshe kœdji o'o á mœ totœ kœpa tœnœ asœke yé á kœzaza ga tœ akwa nene, tshe sœ ɓata ayi ɨndɨ á tshe mɔ anda nœ ye ga pa mindu. ");
INSERT INTO kxf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yavuru ni, ungu sú, egerœ yugu na œ za andanœ yé œ kavwa 'uru ga atɨ.» ");
INSERT INTO kxf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lɔkɔ á Yisu yi lima sœ œrœnœ á ka, azu kɔ ka lima tœ ama ndje tɨ ɔsɔ tœ mara kœyisœrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gbambanœ nene, tshe yiyi lima sœ œrœ ɓata aayi kœyisœ awa akwa nœ endje nene, kashe tshe yi lima sœ nœ ɓata uzu á tshe sœ dœ tshagbozu. ");
INSERT INTO kxf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu sœ lima kœtara kaga gu tœnœ yé ukpulu azu sœ kœna manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yé anga ayi boroma bale gitœ ye ndoo dœ she œ gote ga utshu ye, œ pa adœke: «Gbozu, œdœ ɓœ kœyindœ nœ, ɓœ mbœrœ adœke mœ wuta yerœ.» ");
INSERT INTO kxf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisu yi kane ye, œ goro she yé œ pa adœke: «Mœ yindœ nœ adœke ɓœ wuta yerœ ye.» Petœ œsœnœ, tshe wuta yerœ lœ boroma nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yé Yisu kœpa fœ she adœke: «Mesho! Papandœ nœ fœ uzu bale nene. Kashe gu œ matœ zœ fœ nganga Ndjaba yé œ to tokóró ɓata á Moyize pa lima ndœ nœ, mbœrœ kœma fœ azu kɔ adœke ɓœ wuta yerœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lɔkɔ á Yisu sœ lima kœli ga lœ Kaparnawumu, anga gbozu tshapa aturugu tshelœ Roma na ndoo dœ she œ kɨ fœ she ");
INSERT INTO kxf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","adœke: «Gbozu, ayi akwa nœ mœ lo ɓa sœnda, ada ye tshu tshakudu ye yé tshe sœ kœwu oyo tɔpanœ kpuru.» ");
INSERT INTO kxf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yisu pa fœ she adœke: «A gu dœ́ mœ she she.» ");
INSERT INTO kxf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kashe gbozu tshapa aturugunœ gi adœke: «Gbozu, mœ sœsœ ɓata azu á ɓœ li anda nœ endje nene. Œdœ ɓœ kœyindœ nœ, pa kolœ o'o bale, ayi akwa nœ mœ œ she ye. ");
INSERT INTO kxf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gbambanœ nene, œmœ ndje, mœ sœ dœ agbozu tshapa mœ yé mœ dœ́ ndje gbozu tshapa aturugu. Œdœ mœ kœpa fœ anga bale adœke: “Na”, ngbewo tshe na. Œdœ mœ kpa kœpa fœ anga adœke: “Na ga mœ”, ngbewo tshe na ga ndœ mœ. Yé œdœ mœ kœpa fœ anga ayi akwa nœ mœ adœke “mbœrœ œneke”, ngbewo tshe mbœrœ.» ");
INSERT INTO kxf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lɔkɔ á yisu dji o'o á gbozu tshapa aturugu sœmœ pa, tshe katœ ama ye tɨ ɔsɔ œ pa fœ azu á endje sœ lima kœna manda ye adœke: «Mœ sœ kœmɨndœ nœ fœ 'e dœ adjapu adœke, mœ gbɔgbɔ anga mara kœyindœrœ asœke ndœ anga uzu bale lœ Israyele nene. ");
INSERT INTO kxf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mœ sœ kœpa ndje fœ 'e adœke, azu ndjoro œ to ɓa tœ osho á ɔlɔ œ wuta tœnœ œdœ ɓa tœ osho á ɔlɔ œ li tœnœ, yé œ gbɔ osho kœsœ ɓa pa ndaba ɓa lœ Ogo gbozu nœ tshalafo awa bale dœ Abrayamo, dœ Izaka œdœ pe Yakobo. ");
INSERT INTO kxf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kashe endjeneke á li ma lima adœke endje kœli ga lœ Ogo gbozu nœ Ndjaba, endje vwi endje ga lœ ubu osho ɓa shu. Yé ɓa zœ, endje kɨ œ zɨ tshelœ daji endje.» ");
INSERT INTO kxf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yé Yisu kœpa fœ gbozu tshapa aturugunœ adœke: «Gu ga ndœ zœ, Ndjaba mbœrœ œneke á ɓœ yɔndœ nœ liaka kœyindœrœ nœ zœ ye.» Yé kolœ dœ ada ɔlɔnœ asœmœ, ayi akwa nœ gbozu tshapa aturugu she ye. ");
INSERT INTO kxf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Manda nœ, Yisu na ɓa lœ anda nœ Petro, œ gbɔ ayi mbeyanœ, tshe lo ga atɨ dœ koɓa biwa. ");
INSERT INTO kxf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tshe za kane ye, yé koɓa biwanœ katœ ye yé. Ayi mbeya Petro áafo œ tetœ kœmbœrœ akwa fœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dœ lɔndɔ á ɔlɔ li, endje na dœ azu ndjoro á ekpe ɨshirɨ sœ pa endje fœ Yisu. Tshe gɔrɔ ekpe ɨshirɨ pa azunœ asœmœ dœ o'o ama ye, yé œ she ndje anga aayi koɓa kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tshe mbœrœ lima ataa mbœrœ o'onœ á Isaya ayi kœgbara o'o nœ Ndjaba pa lima kœmbœrœtœ endje. Tshe pa lima adœke: «Œshe dá ko gbakɨndɨ nœ azœ yé á ko koɓa nœ azœ ga pa ye.» ");
INSERT INTO kxf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lɔkɔ á Yisu wu ukpulu azu á endje ndɨvwɨrɨ lima she, tshe za o'o fœ ayambarœ nœ ye adœke œne zu ɓa ɨtshi egerœ ungu adanga. ");
INSERT INTO kxf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Anga ayi kœyisœ awa akwa gitœ ye ndoo œ pa fœ she adœke: «Ayi kœyisœrœ, mœ na manda zœ tœ osho kɔ á ɓœ na tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yisu gi fœ she adœke: «Angbangewo sœ dœ anda nœ endje ɓa lœ ɔshɔ, yé ayanu sœ ndje dœ koma endje ɓa lafo, kashe Gbolo nœ uzu gugu dœ osho kœlo tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Anga yambarœ nœ Yisu bale pa fœ she adœke: «Gbozu, za awa fœ mœ, mœ na œ shi aba mœ utshunœ yekane.» ");
INSERT INTO kxf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yé Yisu kœgi fœ she adœke: «Na manda mœ, yé œ katœ akuzu endje shi akuzu nœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisu ɔ ga lœ agba yé ayambarœ nœ ye ro awa bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ngbangi atake, ndavuru yugu za gu tœnœ kpɨkpɨkpɨ pa egerœ ungu adanga, lokonœ na yé ungu yi lima kœtu ga lœ agba. Kashe Yisu lo lima œnœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ayambarœ gitœ endje ndoo dœ she, á jo she lœ olo dœ kœpa dœ ɔgbɔ adœke: «Gbozu, she azœ kane! A tshu ke a!» ");
INSERT INTO kxf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yisu gi fœ endje adœke: «Mbœrœ gaɗe á 'e sœ dœ awaa? Kœyindœrœ nœ 'e sœ teasho! Yé tshe kœaafo á kœra yugu œdœ egerœ ungu adanganœ, osho kœyi tá.» ");
INSERT INTO kxf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Azu kɔkɔ kɨtœ œsœnœ yé œ sœ lima kœpa adœke: «Uzunœ asœke kœdœ ɗe? Tshe sœ kœpa o'o fœ yugu œdœ fœ ungu yé œ sœ kœdji o'o ama ye!» ");
INSERT INTO kxf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lɔkɔ á Yisu yi kumu ye ɓa atshi egerœ ungu adanga, ɓa lœ ogo nœ Agadaraye, azu bisha á ekpe ɨshirɨ sœ pa endje to ɓa pa udu yé œ na gu tœnœ ga ndœ ye. Endje nga lima waa dœ mara adœke uzu bale œ li kœsɔ dœ awanœ asœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Endje tetœ kœta rawa adœke: «Yisu Gbolo nœ Ndjaba, ɓœ yindœ kœmbœrœ œrœ gaɗe tœ 'a a? Ɓœ na ɓa ke kœgaga kumu 'a a? Olo nœ 'a lili damba nene.» ");
INSERT INTO kxf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Andaa egerœ ukpulu akɔso sœ lima kœpara kœzɨrœ ndoo kpœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aekpe ɨshirɨnœ dɨ tshelœma endje fœ Yisu adœke: «Œdœ ɓœ kœyindœ kœgɔrɔ 'a, vwa 'a, 'a li ga lœ ukpulu akɔso asœ.» ");
INSERT INTO kxf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yé Yisu kœpa fœ endje adœke: «'E na zœ!» Endje wuta lœ azu asœmœ yé œ na œ li ga lœ akɔso. Ngbewo akɔso sœmœ ndjoro to ɓa pa kaga 'uru 'uru 'uru dœ ɔrɔ tra tœnœ œrrr ga la egerœ ungu adanga, yé œ nduru kɔ ye. ");
INSERT INTO kxf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Azu á endje sœ lima kœgbɔndœ akɔsonœ kpa ye. Endje kpagu ɓa lœ ongbo œ mɨndœ œrœ kɔ á mbœrœtœ endje ga tœ azu sœmœ bisha á ekpe ɨshirɨ sœ pa endje fœ azu. ");
INSERT INTO kxf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yé azu tshelœ ongbonœ para kɔkɔ wuta kœgbɔtœ endje dœ Yisu. Lɔkɔ á endje wu she, endje kɨ fœ she adœke tshe gitœ ye lœ ogo nœ œne ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisu ɔ ga lœ agba, œ zu egerœ ungu adanga yé œ gu ga lœ ongbo nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Endje za anga uzu á ada ye tshu, á tshe lo ga pa kelekpa, na tœnœ fœ she. Lɔkɔ á Yisu wu kœyindœrœ nœ azunœ asœmœ, tshe pa fœ uzunœ á ada ye tshu adœke: «Sœ dœ gbɔgbɔ, gbolo nœ mœ! Mœ djerœndœ ekperœ nœ zœ ye!» ");
INSERT INTO kxf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kœdji atamœ, anga aayi kœyisœ awa akwa tetœ kœpa ugurutœ endje dœ tœ endje adœke: «Uzu asœke sœ kœgu œsœ Ndjaba!» ");
INSERT INTO kxf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kashe Yisu wu lima sœ gbetshelœ nœ endje yé œ pa fœ endje adœke: «Mbœrœ gaɗe á 'e sœ dœ ekpe gbetshelœ tœ lɔsu 'e ata a? ");
INSERT INTO kxf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Œdœ mœ kœpa adœke: “Mœ djerœndœ ekperœ nœ zœ”, too mœ kœpa ndje adœke: “Aalafo œ na ana”, o'o neketa dá dœ ɔgbɔ o'o a? ");
INSERT INTO kxf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kashe mœ yindœ nœ adœke 'e wusœ nœ adœke: Gbolo nœ uzu sœ dœ gbɔgbɔ pa ɔshɔ tœ kœdjerœndœ ekperœ.» Manda nœ, tshe kœpa fœ uzu á ada ye tshu asœmœ adœke: «Aalafo, za kelekpa nœ zœ yé œ gu ga ndœ zœ!» ");
INSERT INTO kxf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Uzunœ asœmœ kœalafo á kœgu ga lœ anda nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lɔkɔ á ukpulu azu wu ataa, awa litœ endje yé endje tetœ kœdonga Ndjaba tœ mara gbɔgbɔ neke á tshe to fœ azu. ");
INSERT INTO kxf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu katœ tshakpœmœ tɨ yé œ tetœ kœro tœnœ, ngbewo œ wu anga uzu a ɨ'ɨrɨ ye kœdœ Matie á tshe sœ ga atɨ ɓa lœ anda kœko ngendja lapo. Tshe pa fœ she adœke: «Na manda mœ!» Matie áalafo yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Manda nœ, Yisu sœ lima kœzɨrœ ɓa sœnda nœ Matie. Aayi kœko ngendja lapo ndjoro dœ pe azu kœmbœrœ ekperœ sœ lima kœzɨ œrœ awa bale dœ she œdœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afarisayi wu lima ataa œ yu ayambarœ nœ ye adœke: «Mbœrœ gaɗe á ayi kœyisœrœ nœ 'e œ zɨ œrœ tœ œsœnœ bale dœ aayi kœko ngendja lapo œdœ dœ azu kœmbœrœ ekperœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu dji endje yé œ pa adœke: «Uzu á tshelœ ɔkɔ ye sœ yerœ gbegbe dœ monganga nene, kashe aayi koɓa dá gbe dœ she. ");
INSERT INTO kxf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'E gu œ para ádá o'o á endje sú ɓa la buku nœ Ndjaba adœke: “'E sœ dœ lɔsu nœ kœwu oyo ga ndœ azu, œtœnœ dá mœ yindœ nœ, kashe tokóró nene.” Gbambanœ nene, mœ nana mbœrœ kœ'e azu neke á endje sœ ndjii nene, kashe mœ na mbœrœ aayi kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ayambarœ nœ Yowane ayi kœza batisimu na ga ndœ Yisu yé œ yu she adœke: «Mbœrœ gaɗe á a'a œdœ Afarisayi, 'a sœ kœyotshelœma 'a kpala kpala yekane á ayambarœ nœ zœ mbœmbœrœ ataa nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yé Yisu gi fœ endje adœke: «'E gbe adœke azu á endje e endje ndœ angbo totœ œ sœ dœ oyo dœ lɔkɔ á ayi kœto yashe sœ kpœtœ œsœnœ bale dœ endje a? Œ̃ œ̃ nene! Kashe manda nœ œrrr, lɔkɔ á endje kœza she tshakane endje dá endje yotshelœma endje. ");
INSERT INTO kxf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Yé Yisu kpa kœpa fœ endje adœke uzu bale zaza tafo lœba œ pi ga pa ongboronœ nene. Gbambanœ nene, tafo ndœma lœbanœ œ suru tshelœ ongboronœ, yé ogoronœ œ kpa sœ dœ egerœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Endje susu tafo ipi ga lœ ongboro anga nene. Atamœ nene, tshelœ anga œ 'u, ipinœ œ tu, yé anganœ œ ndɨ ye. Kashe endje sú tafo ipi ga lœ tafo anga, atamœ œrœ bale œ ndɨ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lɔkɔ á Yisu sœ kœpa o'onœ asœmœ fœ endje ataa, anga gbozu nœ Ayuda yikumu ye œ gote ga utshu ye, yé œ pa adœke: «Yawuru nœ mœ tshu ngɔngɔnœ asœke, kashe na œ to kane zœ ga pa ye yé tshe sœ dœ soro.» ");
INSERT INTO kxf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yisu áalafo yé endje te manda ye, œshe dœ pe ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Andaa anga yashe bale á tshe sœ lima kœwu oyo dœ koɓa indji manda ungu ndjokpa dœ bisha, na djagamanda Yisu œ goro ama lœba ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tshe sœ lima kœpa ɓa lœ ye adœke: «Œdœ mœ kœgoro kolœ ama lœba nœ ye, mœ she ye.» ");
INSERT INTO kxf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kashe Yisu fatœ ye œ wu she yé á pa adœke: «Sœ dœ gbɔgbɔ yawuru nœ mœ! Kœyindœrœ nœ zœ she ɓœ ye.» Yé kolœ dœ ada ɔlɔnœ asœmœ, yashenœ she lœ koɓa nœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yisu wuta ɓa lœ anda nœ gbozunœ asœmœ. Lɔkɔ á tshe wu aayi kœ'uru ngbake œdœ ukpulu azu á endje sœ kœta rawa, ");
INSERT INTO kxf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tshe pa adœke: «'E wuta ga shu, gbambanœ nene, yawurunœ asœke tshutshu nene. Tshe sœ tœ olo.» Kashe endje sœ lima kœmɔ she. ");
INSERT INTO kxf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lɔkɔ á endje gɔrɔ ukpulu azunœ ga ushu, Yisu li ɓa tœ osho á gbolonœ sœ tœnœ, œ za kane ye yé tshe áalafo. ");
INSERT INTO kxf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yé o'onœ za tshelœ ogo djigi. ");
INSERT INTO kxf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lɔndɔ á Yisu katœ tshakpœtœmœ tɨ á sœ kœro tœnœ, anga aayibula bisha te manda ye dœ rawa adœke: «Wu oyo 'a, Gbolo nœ Davidi!» ");
INSERT INTO kxf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lɔkɔ á Yisu wuta ɓa lœ anda, aayibulanœ bisha na ndoo dœ she yé tshe yu endje adœke: «Adja 'e yindœ nœ adœke mœ mbœrœ ala 'e œ kɔrɔ a?» Endje gi fœ she adœke: «Œ̃, Gbozu.» ");
INSERT INTO kxf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yisu to kane ye ga pa ala endje yé œ pa adœke: «Kaka œ mbœrœtœ ye fœ 'e liaka kœyindœrœ nœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yé ala endje kɔrɔ. Á Yisu kœpa fœ endje dœ ɔgbɔ adœke: «'E dji mœ dœ ɔtshɔnœ, 'e papandœ nœ fœ uzu bale nene!» ");
INSERT INTO kxf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kashe endje wuta, œ pandœ o'o nœ Yisu lœ ogonœ djigi. ");
INSERT INTO kxf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lɔkɔ á endje yi lima ndœ kœwuta tœnœ, endje na dœ anga uzu á tshe papa o'o nene fœ she. Tshe sœ lima dœ ekpe ɨshirɨ pa ye. ");
INSERT INTO kxf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yé Yisu gɔrɔ ekpe ɨshirɨnœ pa ye, á tshe tetœ kœpa o'o. Ukpulu azu kɨ lima tœ œsœnœ, œ pa adœke: «'A wuwu ɓalima mara anga œrœ atake bale lœ Israyele nene!» ");
INSERT INTO kxf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kashe Afarisayi pa lima adœke: «Gbozu tshapa aekpe ɨshirɨ dá to gbɔgbɔ kœgɔrɔ dœ ekpe ɨshirɨ fœ she asœmœ!» ");
INSERT INTO kxf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisu na lima dje lœ ongbo œdœ dje lakpɨ kɔ, tshe sœ lima kœyisœ œrœ ɓa lœ Sinagoga nœ endje. Tshe sœ lima kœyisœ Ɔtshɔ O'o nœ Ogo gbozu nœ Ndjaba yé œ sœ lima kœshe azu lœ aka koɓa kɔ œdœ lœ gbakɨndɨ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kœwu ukpulu azu, tshe sœ lima dœ oyo tœ lɔsu ye. Gbambanœ nene, endje mɔ lima lœ gbetshelœ nœ endje yé œ gugu lima dœ gbɔgbɔ nene ɓata apata á aayi kœgbɔndœ endje gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yé tshe kœpa fœ ayambarœ nœ ye adœke: «Leyɔ doro ndjoro lœ kɨndɨ, kashe aayi akwa ngbangba nene. ");
INSERT INTO kxf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ataa, 'e kɨ fœ ayengɔ kɨndɨnœ adœke tshe kpa vwa anga aayi akwa mbœrœ kœkɔ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisu e ayambarœ nœ ye ndjokpa dœ bisha asœmœ, œ to gbɔgbɔ kœgɔrɔ dœ ekpe ɨshirɨ fœ endje adœke endje kœgɔrɔ dœ endje yé œ she azu lœ aka koɓa kɔ dœ lœ gbakɨndɨ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ɨ'ɨrɨ aayi avwanœ ndjokpa dœ bisha dœke: Utshunœ kœdœ Shimu á anga ɨ'ɨrɨ ye kœdœ Petro œdœ ayanœ dœ Andere. Ajake dœ Yowane á endje kœdœ agbolo nœ Zebedayi, ");
INSERT INTO kxf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo œdœ Bartelemi, dœ Toma, dœ Matie ayi kœko ngendja lapo, dœ Jake gbolo nœ Alefe, dœ Tade, ");
INSERT INTO kxf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dœ Shimu uzu kanana, dœ Yudasi Isikariote, œshe á tshe ka Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu vwa aayi avwanœ ndjokpa dœ bisha dœ kœza 'o fœ endje adœke: «'E nana œ li ga lœ ogo nœ angbɨ azu nene, 'e lili ndje ga lœ ongbo nœ azu Samariya nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kashe 'e na ga ndœ apata á endje djingili awa á endje dœ́ azu Israyele. ");
INSERT INTO kxf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tœ awa na tœnœ, 'e mɨndœ o'o adœke: “Ogo gbozu nœ tshalafo ndo ye!” ");
INSERT INTO kxf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","'E she aayi koɓa, 'e mbœrœ adœke akuzu kpa kwatœ endje ga lœ soro, 'e mbœrœ adœke aayi boroma wuta yerœ, 'e gɔrɔ ekpe ɨshirɨ. Ɓata á 'e gbɔgbɔ lœ awa nœ ngendja nene, 'e toto ndje lœ awa nœ kœ'esho ndœ ngendja nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Adja 'e zaza ɔrœ too anga langere ngendja bale ga lœ uwu tœ 'e nene, ");
INSERT INTO kxf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","too ngbade kœna dœ ana nene. 'E koko lœba okoro bisha nene, œdœ œrada, œdœ tshɔngbɔlɔ potœ 'e nene. Gbambanœ nene, ayi akwa li kœgbɔ œrœ tshangba akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Lɔkɔ á 'e kœwuta ga lakpɨ too ga lœ anga ongbo, 'e para uzu neke á tshe li kœza osho kœsœ fœ 'e dœ ɔtshɔnœ, yé œ sœ kpœndœ ye kpœtœmœ œrrr ga tœ kœkatœ tshalakpɨnœ asœmœ tɨ. ");
INSERT INTO kxf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lɔkɔ á 'e kœli ga lœ anda nœ uzu, 'e pa adœke: “Kœsœ gee sœ dœ 'e.” ");
INSERT INTO kxf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Œdœ azu tshasœndanœ kœza osho kœsœ fœ 'e, kœsœ gee nœ 'e œ sœ dœ endje. Kashe œdœ endje kœzaza osho kœsœ fœ 'e nene, 'e gi kœsœ gee nœ 'e pa endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yé œdœ azu anga tshalakpɨ bale too anga tshasœnda bale kœvwaratœ endje tœ kœza osho kœsœ fœ 'e, too tœ kœdji o'o ama 'e ye, 'e katœ tshakpœtœmœ tɨ, yé œ gɔrɔ trusha tshada 'e tɨ kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mœ sœ kœpa dœ adjapu fœ 'e adœke, dœ lɔkɔnœ á Ndjaba œ wa ngbanga pa azu, azu ogonœ asœmœ œ gbɔ djofele kœropa œnœ azu Sodomo dœ Gomora. ");
INSERT INTO kxf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«'E wu! Mœ sœ kœvwa 'e ɓata apata ɓa ugurutœ amuru. 'E sœ dœ gbɔdjela ɓata ayakoro yé œ sœ dœ ɔmɔ lɔsu ɓata ambepa. ");
INSERT INTO kxf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ala 'e gbɔ tœ azu. Gbambanœ nene, endje ko 'e na tœnœ ga utshu aayi kœwa ngbanga nœ azu nœ Ndjaba yé œ sɔ 'e dœ ndjapa ɓa lœ Sinagoga nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Endje ko ndje 'e bala tɔ ɓa utshu agboro agbozu œdœ pe agbozugo mbœrœ á 'e kœdœ azu nœ mœ. Ataa, œ za awa fœ 'e adœke 'e pa o'o tœ upu nœ mœ fœ endje, azunœ œdœ endje á endje dœ́dœ́ Ayuda nene asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lɔkɔ á endje kœto 'e na tœnœ ɓa tœ osho kœwa ngbanga, 'e tɔtɔ lɔsu 'e tœ mara á 'e gi dœ o'o nene. Gbambanœ nene, dœ ada ɔlɔnœ asœmœ, endje to o'o á li adœke 'e pa fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Œ dœ́dœ́ 'e dá pa o'onœ nene, kashe Ɨshirɨ nœ Aba 'e œ pa o'o lœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ayazu œ va ɔtɔ ayanœ adœke endje wo she, yé aba kœzu uzu œ mbœrœ ndje ataa fœ gbolo nœ ye; agbolo œ yiangba aayi kœzu endje yé œ ko endje adœke endje wo endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Azu para kɔkɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ kashe uzu á tshe shi gbɨ œrrr ga tœ ndɔngɔlɔnœ, Ndjaba œ she she. ");
INSERT INTO kxf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Œdœ endje kœmbœrœ œrœ kanga fœ 'e ɓa lœ anga ongbo bale, 'e kpa ga lœ anga angbɨnœ. Mœ pa fœ 'e dœ adjapu adœke, Gbolo nœ uzu œ na, damba 'e nana dje lœ ongbo Israyele kɔkɔ nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Yambarœ bale roropa ayi kœyisœrœ fœ she nene, yé ayi akwa roro ndje pa gbozu nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kashe yambarœ œ sœ dœ yanga œdœ endje kœwu she ɓata ayi kœyisœrœ nœ ye, yé ayi akwa œ sœ ndje dœ yanga œdœ endje kœwu she ɓata gbozu nœ ye. Œdœ azu kœna œrrr á e ayengɔ anda Belezebula, ɨ'ɨrɨ gaɗe dá endje e ga tœ azu tshasœnda nœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Awa uzu bale zaza 'e nene. Œrœ neke kɔ á zatœ endje yiwa tœnœ œ matœ endje ngbɨ ga shu, yé œneke kɔ á sœ lœ ubunœ, azu œ wusœ nœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","O'o á mœ sœ kœpa fœ 'e lœ ubunœ asœmœ, 'e pa tshandœnœ dœ ɔlɔ, yé angba o'o á endje sœ kœpa ga lœ utu 'e, 'e pandœ nœ ngbɨ ga shu. ");
INSERT INTO kxf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","'E kpakpa awa azu á endje wo undu uzu kashe á endje lili kœwo ɨshirɨ uzu nene; 'e kpa awa Ndjaba á tshe li kœwo undu uzu œdœ ɨshirɨ ye ɓa lœ lifelo. ");
INSERT INTO kxf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Endje kaka a'eara ayanu bisha ndœ kœgbɔ langere ngendja bale nene a? Andaa, anga bale ugurutœ endje œ te ga tœ ɔshɔ nene œdœ Aba 'e kœyiyindœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kashe e'e, œdœ sukumu 'e, Ndjaba dɨ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mbœrœ tœnœ ataa, 'e sœsœ dœ awa nene, gbambanœ nene, 'e ropa a'eara ayanu ye.» ");
INSERT INTO kxf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Uzu kɔ á tshe yindœ nœ ɓa tœ ala azu adœke œne kœdœ yambarœ nœ mœ, mœ yi ndje ndœ ye ɓa utshu Aba mœ á tshe sœ ɓa lafo adœke œshe kœdœ uzu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kashe tsheneke á tshe 'ea mœ ɓa utshu azu, mœ 'ea ndje she ɓa utshu Aba mœ á tshe sœ ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«'E gbegbe adœke mœ na mbœrœ kœza kœsœ gee ɓa pa ɔshɔ nene. Mœ nana mbœrœ kœza kœsœ gee nene, kashe mœ na dœ ɨngɨrɨ yakamba. ");
INSERT INTO kxf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Adjapu, mœ na kœkurutshelœ gbolo yakoshe dœ abanœ, yawuru dœ ayinœ, yashe dœ yinɨnœ dœ yashe. ");
INSERT INTO kxf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Uzu dœ uzu œ sœ dœ ayingba ye lœ anda nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Uzu á tshe yindœ abanœ too ayinœ kœropa mœ, tshe lili kœdœ uzu nœ mœ nene. Uzu á tshe kœyindœ gbolo yakoshe too gbolo yawuru nœ ye kœropa mœ, tshe lili kœdœ uzu nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uzu á tshe kœza kurushi nœ ye yé á na manda mœ nene, tshe lili kœdœ uzu nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uzu á tshe kœyindœ kœgbɔndœ soro ye, œ yiwatœ ye yé. Kashe tsheneke á tshe kœyindœ kœtshu mbœrœ mœ, tshe sœ dœ soro.» ");
INSERT INTO kxf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Uzu neke á tshe kœza osho kœsœ fœ 'e, dá tshe za ndje fœ mœ ye. Uzu neke á tshe kœza osho kœsœ fœ mœ, dá tshe za ndje fœ tsheneke á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uzu á tshe kœza osho kœsœ fœ anga ayi kœgbara o'o nœ Ndjaba mbœrœ á tshe kœdœ ayi kœgbara o'o asœmœ, tshe gbɔ œrœ tshangbanœ ɓata á Ndjaba sœ kœto fœ ayi kœgbara o'o. Yé tsheneke á tshe za osho kœsœ fœ uzu á tshe sœ ndjii mbœrœ á tshe kœdœ uzu ndjii utshu Ndjaba, tshe gbɔ ndje œrœ tshangbanœ ɓata uzu á tshe sœ ndjii. ");
INSERT INTO kxf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mœ mɨndœ nœ dœ adjapu fœ 'e adœke, uzu kɔ á tshe su ungu kœndjoondjo, œdœ œ kœdœ yashi zɨtɨ ungu tshebabale fœ anga aya gbolo lœ agbolonœ asœke mbœrœ á tshe dœ́ yambarœ nœ mœ, Ndjaba œ to œrœ tshangbanœ fœ she.» ");
INSERT INTO kxf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lɔndɔ á Yisu za o'o fœ ayambarœ nœ ye ndjokpa dœ bisha á ka, tshe katœ tshakpœtœmœ tɨ œ ro kœyisœ œrœ œdœ kœmɨndœ Ɔtshɔ O'o nœ Ndjaba dje lœ ongbo nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Andaa, Yowane ayi kœza batisimu sœ lœ kánga, yé tshe djindœ o'o akwa á Kristu sœ kœmbœrœ tœnœ, ngbewo á vwa anga ayambarœ nœ ye ");
INSERT INTO kxf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kœyu Yisu adœke: «Œɓœ kœdœ tsheneke á tshe sœ kœna tœnœ a, too 'a kate anga angbɨ uzu?» ");
INSERT INTO kxf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yé Yisu kœgi fœ endje adœke: «'E gu œ pandœ œneke á 'e dji yé á wu fœ Yowane adœke: ");
INSERT INTO kxf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aayibula tetœ kœwu osho, aayi gbada na ana, aayi boroma wuta yerœ, aayi bitu dji o'o, akuzu kwatœ endje ga lœ soro, yé endje mɨndœ Ɔtshɔ O'o fœ aayi oyo. ");
INSERT INTO kxf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yanga nœ uzu á tshe kakatœ kœyindœrœ nœ ye ga ndœ mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lɔndɔ á ayambarœ nœ Yowane gu da ye, Yisu tetœ kœpandœ Yowane fœ ukpulu azu adœke: «Œrœ gaɗe dá 'e na kœwu tœnœ ɓa lœ kpagagasho a? A'eara ɔyɔ á yugu sœ kœmea tœnœ a? Œ̃ œ̃ nene. ");
INSERT INTO kxf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yé œrœ gaɗe dá 'e na kœwu tœnœ a? 'E na kœwu anga uzu á tshe verœ ɔtshɔ lœba a? Œ̃ œ̃ nene, azu á endje verœ ɔtshɔ lœba sœ ɓa lœ anda nœ agbozugo. ");
INSERT INTO kxf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yé ataa, œrœ gaɗe dá 'e na kœwu tœnœ a? 'E na kœwu ayi kœgbara o'o a? Œ̃, mœ mɨndœ nœ dœ adjapu fœ 'e adœke tshe ropa ayi kœgbara o'o ye. ");
INSERT INTO kxf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gbambanœ nene, Yowane ayi kœza batisimu kœdœ uzu á endje sú o'o tœ upu nœ ye ɓa la buku nœ Ndjaba adœke: “Mœ vwa ayi avwa nœ mœ utshu zœ mbœrœ kœguma ala awa zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mœ mɨndœ nœ dœ adjapu fœ 'e adœke, ugurutœ azu tshapashɔnœ asœke kɔ, anga uzu bale á tshe ropa Yowane ayi kœza batisimu gugu nene. Andaa, tsheneke á tshe sœ teasho ɓa lœ Ogo gbozu nœ tshalafo ropa ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kœto tœ lɔkɔ á Yowane ayi kœza batisimu wuta kœyisœ œrœ œrrr ga tœ kpesheke, Ogo gbozu nœ tshalafo to toro kœgerœ tœnœ. Aayi gbɔgbɔ dá sœ kœpara awa nœ kœgbɔtœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aayi kœgbara o'o kɔ œdœ awa akwa, gbara o'o œrrr ga tœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yé œdœ 'e kœyindœ kœwusœ nœ dœ ɔtshɔnœ, Yowane kœdœ Eliya á endje pa lima ndœ kœna she. ");
INSERT INTO kxf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaka uzu á tshe kœsœ dœ utu, tshe dji! ");
INSERT INTO kxf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Mœ li azu nœ tshakpesheke dœ azu ɗe? Endje liili dœ agbolo á endje ka ɓa la wutu kœka œrœ yé á sœ kœpa o'o ugurutœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“'A 'uru ngbake fœ 'e, kashe 'e vivi ipi nene! 'A ɓi itshi kuzu fœ 'e, kashe 'e kɨkɨ nene.” ");
INSERT INTO kxf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gbambanœ nene, Yowane ayi kœza batisimu na yé œ vwaratœ ye tœ kœzɨ œrœ œdœ kœndjo ipi, endje pa adœke: “Tshe sœ dœ ekpe ɨshirɨ pa ye!” ");
INSERT INTO kxf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gbolo nœ uzu na œ sœ kœzɨ œrœ yé œ sœ kœndjo ipi, endje sœ kœpa adœke: “'E wu makœzɨrœ, mœndjondjo. Anganœ kœdœ kolœ aayi kœko ngendja lapo œdœ azu kœmbœrœ ekperœ!” Kashe kœwusœtœ nœ Ndjaba sœ kœmatœ ye ndjii lœ awa akwa nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yé Yisu tetœ kœgbagbara azu tshelœ ongbo á tshe mbœrœ lima afá ndjoro lœnœ; gbambanœ nene, endje yayapa lima ɔtshɔ endje nene. Tshe pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Oyo nœ zœ, Koraze! Oyo nœ zœ Betesayida! Gbambanœ nene, œdœ afá á mbœrœtœ endje ɓa ndœ 'e kœmbœrœ má tœ endje ɓa lœ Tire œdœ ɓa lœ Sidona, azu ɓa zœ œ verœ má sake, yé œ dja má tshelœ kumu endje dœ vorowo mbœrœ kœma adœke œne fatshalɔsu œne ye. ");
INSERT INTO kxf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke dœ lɔkɔ kœwa ngbanga, mœ wa o'o tœ ɔgbɔnœ ga tœ 'e kœropa œnœ azu Tire œdœ Sidona. ");
INSERT INTO kxf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yé e'e dœ azu Kaparnawumu, 'e gbe adœke 'e ɔ œrrr ga lafo zœ a? 'E jerœ bala œrrr ɓa lœ ogo nœ akuzu. Gbambanœ nene, œdœ afá á mbœrœtœ endje ɓa ndœ 'e, kœmbœrœ má lima tœ endje ɓa lœ Sodomo ataa, ongbonœ asœmœ œ sœ má œrrr ga tœ kpesheke. ");
INSERT INTO kxf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke dœ lɔkɔ kœwa ngbanga, mœ wa o'o nœ 'e tœ ɔgbɔnœ kœropa œnœ azu ogo Sodomo.» ");
INSERT INTO kxf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dœ lɔndɔnœ asœmœ, Yisu pa dœ ɔgbɔ adœke: «Uu Aba, Gbozu nœ tshalafo dœ tshapashɔ, mœ gi mershe fœ ɓœ mbœrœ á ɓœ má ngbɨ fœ azu á endje wuwusœ œrœ nene adjapu á ɓœ za yiwa tœnœ tœ azu kœwusœtœ œdœ agbangba kœwusœrœ. ");
INSERT INTO kxf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aba, œɓœ dá yindœ nœ adœke œ mbœrœtœ ye ataa. ");
INSERT INTO kxf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Aba mœ ko œrœ kɔ fœ mœ. Uzu bale wuwusœ Gbolo nene, kolœ Aba dá wusœ ye. Uzu bale wuwusœ Aba nene, kolœ Gbolo dá wusœ ye, œdœ tsheneke á Gbolo yindœ kœma Aba fœ she tako. ");
INSERT INTO kxf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«E'e dœ azu kɔ á 'e mɔ dœ kœko ogboro gbarœ, 'e na ga ndœ mœ, mœ ko gbarœnœ lœ kumu 'e dœ́ 'e yatœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'E za ngbongbo awa bale dœ mœ, yé œ li ga lœ lakɔrɔ nœ mœ; gbambanœ nene, mœ dœ́dœ́ ayi gbɔkumu nene kashe mœ dœ́ ayi ɔmɔ lɔsu. Ataa, 'e li kœyatœ 'e dœ tœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngbongbo nœ mœ gbɔgbɔ nene, yé gbarœnœ á a za dœ 'e œ lɨ 'e nene.» ");
INSERT INTO kxf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Manda nœ teasho atake, Yisu ro lima tɔ lœ kɨndɨ ble dœ anga lɔkɔ sabata. Ogo li lima tœ ayambarœ nœ ye yé endje tetœ kœverœ ele blenœ asœmœ á sœ kœzɨ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lɔkɔ á Afarisayi wu ataa, endje pa fœ Yisu adœke: «Wu, ayambarœ nœ zœ sœ kœmbœrœ œrœ á awa akwa vwaratœ ye tœnœ dœ olo sabata!» ");
INSERT INTO kxf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yisu gi fœ endje adœke: «'E dɨdɨ œneke á Davidi mbœrœ lima anga ɔlɔ bale á ogo mi lima she dœ azu nœ ye á tshe na lima tœ awanœ dœ endje nene a? ");
INSERT INTO kxf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tshe li, œshe œdœ azu nœ ye ɓa lœ anda Ndjaba, yé endje zɨ mapa á endje to dœ tokóró fœ Ndjaba; mapa má œdœ she œdœ azu nœ ye, endje lili má kœzɨ tœnœ nene, kashe á sœ kolœ mbœrœ anganga Ndjaba kutɨ endje. ");
INSERT INTO kxf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Too 'e dɨdɨ ndje ɓa la buku awa akwa nene adœke dœ lɔkɔ sabata, ata anganga Ndjaba sœ kœmbœrœ akwa lœ Tepelo gbaa, endje sœ kœmbœrœ œrœ kpi tœ awa akwa, kashe Ndjaba sœsœ kœwu lœ ala ye ɓata ekperœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Andaa mœ sœ kœmɨndœ nœ dœ adjapu fœ 'e adœke, œrœ á 'e wu asœke, œ ropa Tepelo ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Œdœ 'e kœwu má sœ ádá o'o á endje sú ala buku nœ Ndjaba adœke: “Mœ yindœ nœ adœke, 'e wu oyo anga 'e kashe tokóró nene;” 'e wawa ngbanga pa azu á endje mbœmbœrœ œrœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gbambanœ nene, Gbolo nœ uzu kœdœ ayengɔ lɔkɔ sabata.» ");
INSERT INTO kxf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisu katœ tshakpœtœmœ tɨ, œ na œ li ga lœ Sinagoga nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anga uzu bale á kane ye tshu sœ lima kpœtœmœ. Afarisayi yu lima Yisu dœ o'o adœke: «Awa akwa nœ azœ sœ kœyindœ nœ adœke endje she uzu dœ lɔkɔ sabata a?» Endje yu lima she ataa mbœrœ á kœgbɔ awa kœtɔ meza pa ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yisu gi fœ endje adœke: «Œdœ anga uzu ugurutœ 'e kœsœ dœ pata nœ ye tshebabale, á tshe te ga lœ kudu dœ lɔkɔ sabata, tshe lili kœza she ga ushu nene a? ");
INSERT INTO kxf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uzu ropa pata! Mbœrœ tœnœ ataa, awa akwa nœ azœ za awa fœ azœ ndœ kœmbœrœ ɔtshɔrœ dœ lɔkɔ sabata.» ");
INSERT INTO kxf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yé Yisu kœpa fœ uzunœ á kane ye tshu adœke: «Yɔrɔ tshelœ kane zœ.» Tshe yɔrɔ tshelœ kane ye, yé œ gumatœ ye ɓata anga tshakalanœ. ");
INSERT INTO kxf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Afarisayi gu œ vwarandœ o'o ugurutœ endje tœ kœpara awa ndœ kœwo Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lɔndɔ á Yisu djindœ o'onœ asœmœ, tshe gitœ ye kpœtœmœ, yé azu ndjoro na manda ye. Tshe she aayi koɓa kɔ, ");
INSERT INTO kxf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kashe œ pa fœ endje dœ ɔgbɔ adœke endje papa o'o tœ upu nœ œne fœ uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tshe mbœrœ lima ataa adœke o'o á Ndjaba pa dœ awa nœ ayi kœgbara o'o Isaya kœmbœrœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Tshe pa lima adœke: «Wu ayi akwa nœ mœ á mœ ke she dœke, mœ yindœ ye waa yé mœ sœ dœ yanga mbœrœ she. Mœ vwa Ɨshirɨ nœ mœ kœjerœ ga pa ye, yé tshe yisœ ɔtshɔ awa fœ azu tshapashɔ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tshe bœrœtœ ye dœ uzu bale nene, yé œ ta ndje rawa nene; endje dji she kœpa o'o tœ ala awa nene. ");
INSERT INTO kxf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tshe kavwa tshelœ wara á lu nene, yé tshe ru miinda á ndoo kœru tœnœ nene, œrrr ga tœ adœke œneke á sœ ndjii ropa œrœ kɔ yekane. ");
INSERT INTO kxf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yé azu kɔ á endje wuwusœ mœ nene œ ko lɔsu endje ga pa ye.» ");
INSERT INTO kxf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Endje na dœ anga uzu bale á ala ye bu yé á tshe papa o'o nene fœ Yisu. Tshe sœ lima dœ ekpe ɨshirɨ pa ye. Yisu she uzunœ dœ mara adœke tshe tetœ kœpa o'o dœ pe kœwu osho. ");
INSERT INTO kxf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ukpulu azu á endje sœ lima kpœtœmœ, kɨtœ œsœnœ yé œ sœ lima kœpa adœke: «Uzunœ asœke kœdœ ata Davidi nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lɔkɔ á Afarisayi dji endje kœpa o'o ataa, endje pa ngbɨ adœke: «Belezebula gbozu nœ ekpe ɨshirɨ sœ pa ye. Œshe dá za gbɔgbɔ fœ she tœ kœgɔrɔ dœ ekpe ɨshirɨ pa azu asœmœ!» ");
INSERT INTO kxf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kashe yisu wu lima sœ gbetshelœ nœ endje, yé œ pa fœ endje adœke: «Ogo gbozu kɔ á azu tshelœnœ kœsœ kœnga koshe ugurutœ endje, tshelœ ogonœ asœmœ œ ndɨ ye. Œdœ azu tshelœ ongbo bale too lœ bɨngɨ bale kœsœ kœnga koshe ugurutœ endje, tshelœ ongbonœ too bɨngɨnœ œ ndɨ ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Œdœ Satana kœsœ kœgɔrɔ œneke á dœ́ œnœ Satana, asœmœ dá tshe sœ kœnga koshe ga tœ ye dœ tœ ye. Ataa, Ogo gbozu nœ ye œ sœpe koto o? ");
INSERT INTO kxf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'E sœ kœpa adœke Belezebula dá to gbɔgbɔ fœ mœ yeka á mœ sœ kœgɔrɔ dœ ekpe ɨshirɨ. Yé azu nœ 'e gɔrɔ ndje ekpe ɨshirɨ dœ gbɔgbɔ nœ ɗe? Ataa, azu nœ 'e dœ tœ endje œ yisœ nœ adœke 'e te dœ o'o ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kashe œdœ mœ kœsœ kœgɔrɔ ekpe ɨshirɨ dœ Ɨshirɨ nœ Ndjaba, dá œ sœ kœma adœke Ogo gbozu nœ Ndjaba wuta ga ndœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Too ndje, œdœ uzu kœyindœ kœli kœko œrœ dœ ɔgbɔ ɓa lœ anda nœ uzu nœ gbɔgbɔ; œ li adœke tshe i she vwagbagba ga tœnœ utshunœ yeka á kœli kœko œrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Uzu á tshe sœsœ awa bale dœ mœ nene, œshe kœdœ yingba mœ. Yé tsheneke á tshe sœsœ kœtɨ kane mœ adœke 'a ngboɓa azu nene, sœ kœndjɔtshelœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke, Ndjaba œ djerœndœ ekperœ nœ azu kɔ œdœ pe kœgu œsœ Ndjaba á endje sœ kœgu tœnœ. Kashe tsheneke á tshe kœsœ kœgu œsœ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Uzu á tshe pa ekpe o'o dœ upu nœ Gbolo nœ uzu, Ndjaba œ djerœndœ ekperœ nœ ye kashe œdœ tshe kœpa ekpe o'o goro œsœ́ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye bale nene œdœ lœ soro ye pa ɔshɔ œdœ manda kuzu ye.» ");
INSERT INTO kxf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Œdœ ɔyɔ kœdœ ɔtshɔ ɔyɔ, elenœ œ sœ ndje dœ ɔtshɔnœ. Yé œdœ ɔyɔ kœdœ ɔyɔ á sœ dœ koɓa, elenœ œ sœ ndje dœ koɓa. Gbambanœ nene, endje wusœ ɔyɔ mbœrœ elenœ. ");
INSERT INTO kxf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ukpulu ekpe ayakoro! Ɓata 'e kœdœ aekpe azu asœke, mara gaɗe dá 'e li kœpa ɔtshɔ o'o a? Gbambanœ nene, o'o á wuta lœ ama uzu to ɓa tœ lɔsu ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɔtshɔ uzu sœ kœmbœrœ ɔtshɔrœ á sœ kœto lœ ɔtshɔ lɔsu nœ ye; yé ekpe uzu sœ kœmbœrœ ndje ekperœ á sœ kœto lœ ekpe lɔsu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mœ sœ kœmɨndœ nœ fœ 'e adœke, dœ lɔkɔ kœwa ngbanga, Ndjaba œ yu azu tœ o'o á endje pa lima ngbɨlɨngbɨlɨ asœmœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gbambanœ nene, kolœ lindœ o'o á wuta lœ ama zœ dá ɓœ te dœ o'o too ɓœ te ndje dœ o'o nene.» ");
INSERT INTO kxf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yé anga aayi kœyisœ awa akwa œdœ anga Afarisayi pa fœ Yisu adœke: «Gbozu, 'a yindœ nœ adœke ɓœ ma anga ambárá afá bale fœ 'a kane.» ");
INSERT INTO kxf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yisu kœgi fœ endje adœke: «Azu nœ tshakpesheke, endje kœdœ aekpe azu yé œ zazatœ endje fœ Ndjaba nene; endje yindœ nœ adœke œne wu anga ambárá afá bale. Kashe endje wu œrœ bale nene, kolœ ambárá afá á Ndjaba ma lœ awa nœ ayi kœgbara o'o nœ ye dœ Yona asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gbambanœ nene, ɓata á Yona mbœrœ ɔlɔ votɔ œdœ butshɔ votɔ ɓa lœ egerœ ageatshalangu, awa bale Gbolo nœ uzu œ mbœrœ ndje ɔlɔ votɔ dœ butshɔ votɔ lœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dœ lɔkɔ kœwa ngbanga nœ azu pa ɔshɔ, azu Ninive œ áalafo œ wa o'o ga pa azu nœ tshakpesheke asœke. Gbambanœ nene, azu Ninive fa lima tshalɔsu endje lɔkɔ á endje dji Yona kœmɨndœ o'o ama Ndjaba. Kashe uzunœ á tshe sœ kpœke asœke ropa Yona ye! ");
INSERT INTO kxf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dœ lɔkɔ kœwa bala ngbanga, gbozugo yashe tshapa ogo Saba œ wa o'o ga pa 'e. Gbambanœ nene, tshe to ɓa tœ ndɔngɔlɔ tshakala ogo pa ɔshɔ á sœ lœ ɨngɨrɨnœ, á na kœdji o'o kœwusœtœ nœ Salomo. Kashe uzunœ á tshe sœ kpœke asœke ropa Salomo ye!» ");
INSERT INTO kxf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Œdœ ekpe ɨshirɨ kœgitœ ye pa uzu, tshe sœ kœkɔrɔ na tœnœ djezœ lœ kpagagasho mbœrœ kœpara osho kœsœ tœnœ. Œdœ tshe kœgbɔgbɔ osho kœsœ tœnœ nene, ");
INSERT INTO kxf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tshe sœ kœpa adœke: “Mœ kwatœ mœ ga lœ anda nœ mœ á mœ wuta lœ nœ.” Kashe lɔkɔ á tshe kœkwatœ ye yé á wu adœke uzu gugu lœ andanœ nene, endje ngbɔ tshelœnœ œ guma œrœ tshelœnœ dœ awanœ, ");
INSERT INTO kxf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tshe na œ e anga angbɨ aekpe ɨshirɨ mindu dœ bisha (7) á endje sœ tœ ekpenœ kœrosœ ye. Tshe gu dœ endje awa bale œ li ga sœndanœ yé œ gumatœ endje kpœtœmœ. Ataa, oyo á uzunœ asœmœ œ kpa wu œ ropa œneke má utshunœ. Œ sœ ndje awa bale ataa mbœrœ aekpe azu nœ tshakpesheke.» ");
INSERT INTO kxf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lɔndɔ á Yisu sœpe lima kœpa o'o fœ ukpulu azu atake, ayinœ œdœ pe aayanœ yi kumu endje. Endje ka lima ɓa ushu yé œ sœ kœpara awa kœpa o'o dœ she. ");
INSERT INTO kxf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yé anga uzu bale kœpa fœ Yisu adœke: «Ayi zœ œdœ aaya ka ɓa ushu œ yindœ kœpa o'o dœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yisu kœgi fœ uzunœ asœmœ adœke: «Œɗe dá dœ ayi mœ a? Œɗe dá dœ aaya mœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yé tshe yisœ ayambarœ nœ ye dœ kane ye, œ pa adœke: «'E Wu ayi mœ œdœ aaya mœ, endje dá sœ atɨ asœke. ");
INSERT INTO kxf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gbambanœ nene, uzu á tshe sœ kœmbœrœ œneke á Aba mœ á tshe sœ ɓa lafo yindœ nœ, œshe kœdœ aya mœ, yingɔ mœ too ayi mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dœ lɔkɔnœ asœmœ, Yisu wuta lœ anda œ na kœsœ ga atɨ ɓa tœ mangu egerœ ungu adanga. ");
INSERT INTO kxf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ukpulu azu ngbɔtœ endje dje ɨndɨrɨ ye á tshe ɔ ga lœ egerœ agba yé á sœ ga atɨ. Ukpulu azunœ ka lima ɓa tœ mangunœ. ");
INSERT INTO kxf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tshe sœ lima kœpa o'o ndjoro lœ ndœma toro, yé œ pa lima fœ endje adœke: «Ɔlɔ bale, anga uzu na lima ga lœ kɨndɨ nœ ye mbœrœ kœlu indji ngwarœ. ");
INSERT INTO kxf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɓata á tshe sœ lima kœlu indji ngwarœnœ, anganœ yo ga tœ ama awa, ayanu wu œ de ye. ");
INSERT INTO kxf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Anganœ yo lima ga lœ oporo badja ɓa tœ osho á ɔshɔ sœsœ ndjoro tœnœ nene. Indji ngwarœnœ ko lima katsha mbœrœ embe ɔshɔnœ lili lima nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lɔkɔ á ɔlɔ tɔ dœ ɔgbɔ, ungbu ngwarœnœ kɔkɔ œ ɔrɔ ye; gbambanœ nene, œshenœ lili waa ga lœ ɔshɔ nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Anga indji ngwarœnœ yo ga lœ ɔyɔ ishi. Ɔyɔ ishinœ gboro yé œ napa ungbu ngwarœnœ, awa kœgerœ tœnœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kashe anga indji ngwarœ kpa yo ga lœ ɔtshɔ ɔshɔ, yé œ zu ɔtshɔ elenœ: Bale le kama, anganœ le zazu votɔ (60) yé anganœ le ndje zazu bale dœ ndjokpa (30).» ");
INSERT INTO kxf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yé Yisu kœpa adœke: «Œdœ 'e kœsœ dœ utu, kaka 'e dji!» ");
INSERT INTO kxf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ayambarœ gitœ endje ndoo dœ she, œ yu she adœke: «Mbœrœ gaɗe á ɓœ sœ kœpa o'o lœ ndœma toro a?» ");
INSERT INTO kxf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tshe gi fœ endje adœke: «Tœ e'e, 'e li œnœ 'e kœwusœ o'o nœ ádá Ogo gbozu nœ tshalafo á zatœ endje yiwa tœnœ ye, kashe anga azu, endje lili kœwusœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gbambanœ nene, uzu á tshe sœ dœ œrœ, endje kpa ko anganœ ga pa nœ yé œ ngba tœ ye waa. Kashe tsheneke á tshe kœgugu dœ œrœ nene, endje kpa ko œneke teasho á tshe sœ dœ tœnœ, tœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'E wu ádánœ á mœ sœ kœpa o'o fœ endje lœ ndœma toro mbœrœ endje sœ kœwu œrœ kashe endje sœsœ kœwu tœnœ nene, yé endje sœ kœdji o'o kashe endje sœsœ kœdji tœnœ œdœ kœdji tshelœ katanœ kpœrœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Atamœ, œ mbœrœtœ ye lindœ kœgbara o'o nœ Isaya, á tshe pa adœke: “'E dji o'o waa kashe 'e dji tshelœ katanœ nene, 'e wu œrœ waa kashe 'e wu nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gbambanœ nene, lɔsu azu asœke wuta dœ ɔgbɔnœ adœke; endje be utu endje ga tœnœ, endje be ala endje ga tœnœ mbœrœ á ala endje wuwu osho nene, mbœrœ á utu endje djidji o'o nene, mbœrœ á lɔsu endje zaza ádánœ kpœrœ nene yé ataa endje kpa kwa ga ndœ mœ nene mbœrœ á mœ kœshe endje.” ");
INSERT INTO kxf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Tœ e'e nœ 'e, 'e sœ œnœ 'e dœ yanga gbambanœ nene, ala 'e sœ kœwu osho zœ, yé utu 'e sœ kœdji o'o zœ. ");
INSERT INTO kxf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mœ sœ kœmɨndœ nœ dœ adjapu adœke, aayi kœgbara o'o ndjoro œdœ azu á endje sœ ndjii gbe ndœ kœwu œneke á 'e sœ kœwu tœnœ, kashe endje wuwu nene. Endje gbe ndje kœdji œneke á 'e sœ kœdji tœnœ, kashe endje djidji nene.» ");
INSERT INTO kxf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«E'e, 'e dji ádá ndœma toro nœ ayi kœlu ngwarœnœ kane. ");
INSERT INTO kxf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Azu á endje pandœ ogo gbozu fœ endje yé á endje sœsœ kœdji tshelœ katanœ nene, endje lœ ɓata ama awa á indji ngwarœ yo ga tœnœ: Satana na œ kakara œneke á endje lu ga tœ lɔsu endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Anga azu sœ ɓata ɔshɔ lœ oporo badja á indji ngwarœ yo ga lœnœ: Endje sœ kœdji o'o yé œ sœ kœyindœ nœ katsha dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kashe œshe endje gugu nene. Endje yindœ nœ kolœ kwata œndœ nœ œ dɨ nene, lɔkɔ á endje kœtetœ kœwu oyo too endje kœsœ kœmbœrœ œrœ kanga fœ endje lœ kumu o'o ama Ndjaba, endje ka ngbɨrɨ lœ kœyindœrœ nœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anga endje sœ ɓata indji ngwarœ á yo ɓa ugurutœ ɔyɔ ishi. Endje dji o'o ama Ndjaba kashe ogo œrœ tshapashɔ œdœ yanga kœgbɔ œrœ ndjoro á sœ kœfara azu, œ na pa o'onœ yé œ zuzu elenœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anga azu sœ ɓata indji ngwarœ a yo ga lœ ɔtshɔ ɔshɔ. Endje sœ kœdji o'o ama Ndjaba yé œ sœ kœdji tshelœ katanœ. Ataa, endje sœ kœzu elenœ: Anganœ kama bale (100), anganœ zazu votɔ yé anganœ ndje zazu bale dœ ndjokpa.» ");
INSERT INTO kxf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu kpa pa anga angbɨ ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata anga uzu bale á tshe lu ɔtshɔ ngwarœ ga lœ kɨndɨ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dœ anga butshɔ bale, dœ lɔndɔ á azu lo lima, anga yingba ye bale na, œ lu ekpe gusu ɓa uguru ble yé œ gu daye. ");
INSERT INTO kxf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lɔkɔ á blenœ gerœ lima yé á tetœ kœle tœnœ, ekpe gusunœ wuta ndje. ");
INSERT INTO kxf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aayi akwa nœ ayengɔ kɨndɨnœ na œ pandœ nœ fœ she adœke: “Gbozu, ɓœ lu lima ɔtshɔ ngwarœ ga lœ kɨndɨ nœ zœ, yé ekpe gusunœ kpa to kpœta a?” ");
INSERT INTO kxf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tshe gi fœ endje adœke: “Anga yingba bale dá mbœrœ œrœnœ asœmœ.” Yé aayi akwanœ kœyu she adœke: “Ɓœ yindœ nœ adœke, 'a na œ su ekpe gusunœ ye a?” ");
INSERT INTO kxf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tshe gi adœke: “Œ̃ œ̃ nene. Gbambanœ nene, œdœ 'e kœsœ kœsu tœnœ, œ mbœrœ adœke 'e ngbɔɓa dœ blenœ œ su va 'e. ");
INSERT INTO kxf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","'E katœ nœ œ gerœ awa bale œrrr ga tœ kœgbɔ tœnœ, yé dœ lɔkɔ kœkɔ tœnœ, mœ pa bala fœ aayi kœkɔ ngwarœ adœke: 'E su ekpe gusunœ utshunœ œ i agbanœ dœ agbanœ mbœrœ kœko va ga tœ owo. Manda nœ, 'e ko ble gu tœnœ ga la kogba nœ mœ.”» ");
INSERT INTO kxf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisu kpa pandœ anga ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata ele ɔyɔ á ɨ'ɨrɨnœ kœdœ mutarde á uzu œ za á lu ga lœ kɨndɨ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Œtœnœ kœdœ leyɔ á sœ teasho lœ indji ngwarœ kɔ, kashe œ kœgerœ, œ ropa kako dɔngɔ kɔ lœ kɨndɨ yé œ fa egerœ ɔyɔ á ayanu sœ kœna kœmɔ koma endje ga lœ ganeanœ.» ");
INSERT INTO kxf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisu kpa pa anga angbɨ ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata ɔyɔ kœsuku mapa á anga yashe bale za, á djanga dœ kilo zuwa ble votɔ œrrr adœke zuwa blenœ suku.» ");
INSERT INTO kxf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisu pa o'onœ kɔ asœmœ fœ ukpulu azu lœ ndœma toro. Tshe sœ lima kœpa o'o fœ endje kolœ lœ ndœma toro. ");
INSERT INTO kxf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tshe mbœrœ lima ataa mbœrœ á o'o á ayi kœgbara o'o gbara lima kœmbœrœtœ endje. Tshe gbara lima adœke: «Mœ pa bala o'o lœ ndœma toro, mœ mɨndœ œrœ á zatœ ye yiwa tœnœ kœto ɓa tœ ali kœmbœrœ tshapashɔ.» ");
INSERT INTO kxf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Manda nœ, Yisu katœ ukpulu azunœ œ gu ga sœnda. Ayambarœ nœ ye na ndoo dœ she, yé œ yu she adœke: «Mɨndœ ádá ndœma toro nœ ekpe gusu á sœ ɓa lœ kɨndɨ fœ 'a kane.» ");
INSERT INTO kxf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yisu gi fœ endje atake: «Uzu á tshe lu ɔtshɔ indji ngwarœ, œshe kœdœ Gbolo nœ uzu. ");
INSERT INTO kxf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɨndɨ kœdœ tshapashɔ. Ɔtshɔ indji ngwarœ sœ kœma azu neke á endje zatœ endje ga tshakudu ogo gbozu. Ekpe gusu sœ kœma azu neke á endje sœ kœza awa ekperœ. ");
INSERT INTO kxf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yingba á tshe lu ekpe gusu kœdœ djaboro. Kœgbɔ ngwarœ kœdœ kœka tshapashɔ; yé aayi kœkɔ ngwarœnœ kœdœ aandjelu. ");
INSERT INTO kxf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Awa bale mara á endje ngbɔɓa ekpe gusu ndœ kœsho tœnœ ɓa tœ ala owo, œ sœ ndje awa bale dœ lɔkɔ nœ kœka tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gbolo nœ uzu œ vwa aandjelu nœ ye, endje gi azu kɔ á endje sœ kœfa gbetshelœ nœ anga endje tœ kœyindœrœ œdœ pe azu á endje sœ kœmbœrœ ekperœ, ga ushu lœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tshe ko endje va ga la owo; ɓa zœ endje kɨ dœ ngola endje ye yé œ zɨ tshelœ daji endje gbagbara gbagbara. ");
INSERT INTO kxf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kashe endjeneke á endje zatœ endje fœ Ndjaba, endje tshi ɓata ɨshirɨ ɔlɔ ɓa lœ Ogo gbozu nœ Aba endje. Kaka uzu á tshe sœ dœ utu, tshe dji!» ");
INSERT INTO kxf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ogo gbozu nœ tshalafo sœ ɓata ɔtshɔrœ nœ ngendja á zatœ endje yiwa tœnœ ɓa lœ kɨndɨ á uzu gbɔ yé á kpa za tshandœnœ yiwa tœnœ. Tshe sœ dœ yanga kœrosœ nœ, œ gu œ ka œrœ nœ ye kɔ á tshe sœ dœ tœnœ yé á kwatœ ye á yɔ kɨndɨnœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ogo gbozu nœ tshalafo sœ ɓata ayi kœka œrœ á tshe sœ kœpara ɔgbɔ œrœ tshelœgɨ. ");
INSERT INTO kxf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lɔkɔ á tshe kœgbɔ œrœnœ á œsœnœ lɨ, tshe ka œrœ kɔ á tshe sœ dœ tœnœ yé œ yɔ dœ ɔgbɔ œrœ tshelœgɨnœ asœmœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ogo gbozu nœ tshalafo kpa sœ ɓata gbánda á endje vwi ga la egerœ ungu adanga yé á sœ kœko tshelœ aka ageatshalangu kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lɔndɔ á kœsu kperœ, aayi kœpara ageatshalangu œ gbota ga tœ mangu, manda nœ endje sœ ga atɨ mbœrœ kœko ageatshalangunœ lœnœ. Endje ko ɔtshɔ endje ga lœ kingi yé œ ko endjeneke á endje lili nene va e. ");
INSERT INTO kxf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bala kœka ndje tshapashɔ œ sœ ndje kolœ ataa: aandjelu œ na bala kœkurutshelœ aayi katshalɔsu dœ aayi ɔtshɔ azu ");
INSERT INTO kxf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mbœrœ kœko endje va ga la owo. Ɓa zœ dá azu ndjoro œ kɨ yé á zɨ tshelœ daji endje gbagbara gbagbara.» ");
INSERT INTO kxf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisu yu endje adœke: «'E wusœ ádá o'onœ asœmœ kɔ yé a?» Endje gi adœke: «Œ̃.» ");
INSERT INTO kxf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yé tshe kœpa fœ endje adœke: «Dœ tœnœ ataa, ayi kœyisœ awa akwa kɔ á tshe te yambarœ nœ Ogo gbozu nœ tshalafo, tshe sœ ɓata anga ayengɔ œrœ á tshe gbɔ tafo œrœ œdœ pe ongboro œrœ lœ kœgbɔrœ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lɔndɔ á Yisu pa o'o lœ ndœma toronœ asœmœ á ka, tshe katœ tshakpœtœmœ tɨ, ");
INSERT INTO kxf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yé œ gu ga lakpɨ nœ ye. Tshe tetœ kœyisœ œrœ neke á sœ ndjii ɓa lœ Sinagoga nœ endje yé azu kɔ á endje sœ lima kpœtœmœ, kɨ lima tœ œsœnœ. Endje pa lima adœke: «Tshe gbɔ kœwusœtœ œdœ pe gbɔgbɔ nœ kœmbœrœ dœ afánœ asœke kpœta a? ");
INSERT INTO kxf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Œ dœ́dœ́ gbolo nœ ayi kœguma maɓaya dœke nene a? Ayinœ dœ́dœ́ Mareya nene a? Jake, Yozefu, Shimu œdœ pe Yuda kœdœ aaya nœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yé ayingɔnœ kɔ sœsœ ɓa ugurutœ azœ nene a? Tshe gbɔ gbɔgbɔnœ asœke kɔ kpœta a?» ");
INSERT INTO kxf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yé œrœnœ asœmœ mbœrœ lima adœke endje sœ dœ kœyindœrœ ga ndœ ye nene. Á Yisu kœpa fœ endje adœke: «Endje lɨsœ ayi kœgbara o'o tœ osho kɔ, kashe ɓa lakpɨ nœ ye œdœ ɓa lœ bɨngɨ nœ ye, endje lɨsœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yisu mbœmbœrœ afá ɓa zœ ndjoro nene kolœ mangba kœtshapu kœyindœrœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dœ lɔndɔnœ asœmœ, Erode á tshe dœ́ lima gbozu tshapa ogo Galilayi, djindœ œneke kɔ á Yisu mbœrœ ");
INSERT INTO kxf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yé œ pa fœ aayi akwa nœ ye adœke: «Yowane ayi kœza batisimu dœmœ! Œshe dá she lœ akuzu asœmœ! Mbœrœ tœnœ ataa á tshe sœ dœ gbɔgbɔ ndœ kœfarœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Andaa, Erode za lima awa adœke endje za Yowane œ i she dœ djingiri, yé œ vwi she ga lœ anda kánga mangba Erodiade, awo ayanœ dœ Filipo. ");
INSERT INTO kxf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gbambanœ nene, Yowane sœ lima kœpa fœ Erode adœke: «Œ lili adœke ɓœ za Erodiade tœ awo zœ nene!» ");
INSERT INTO kxf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode yi lima ndœ kœwo Yowane kashe awa Ayuda dá sœ lima kœza she. Gbambanœ nene, endje kɔ, endje wu lima Yowane ɓata ayi kœgbara o'o tako. ");
INSERT INTO kxf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ataa, dœ lɔkɔ angbo olo kœzu Erode, yawuru nœ Erodiade vitœ ye ɓa utshu azu á endje na ndœ angbonœ. Tshe za lima yanga fœ Erode tɔpanœ kpuru, ");
INSERT INTO kxf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yé Erode dara ama ye adœke œne to œrœ kɔ á tshe yu œne tœnœ fœ she ye. ");
INSERT INTO kxf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tshe dji upu á ayinœ mɨ fœ she yé œ yɔsho ndœ œrœ ɓa ndœ Erode adœke: «Za kumu Yowane ayi kœza batisimu ga lœ saani fœ mœ!» ");
INSERT INTO kxf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oyo za gbozugo. Kashe kolœ mangba kœdarama ye á tshe dara ɓa utshu azu nœ ye á tshe e endje, tshe za awa adœke endje za tœnœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tshe vwa anga uzu bale adœke tshe na œ wa kumu Yowane ayi kœza batisimu ɓa lœ anda kánga. ");
INSERT INTO kxf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Endje za kumu ye ga lœ saani gutœnœ, œ za fœ ovoro yawurunœ yé á tshe za fœ ayinœ. ");
INSERT INTO kxf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ayambarœ nœ Yowane na œ za lima oko ye á shi. Manda nœ, endje na lima œ pandœ œneke á mbœrœtœ endje asœmœ fœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lɔkɔ á Yisu dji o'onœ asœmœ, tshe katœ tshakpœtœmœ tɨ yé œ ɔ ga lœ egerœ agba mbœrœ kœro ga tœ osho á azu gugu tœnœ nene. Kashe ukpulu azu lakpɨ djezœ dji œsœnœ yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lɔkɔ á Yisu wuta lœ egerœ agba, tshe wu ukpulu azu ndjoro, œ sœ dœ oyo tœ lɔsu ye mbœrœ endje yé œ tetœ kœshe agbakɨndɨ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dœ lɔndɔ á ɔlɔ te lima tœ kœdɨ tœnœ, ayambarœ nœ Yisu na ndoo dœ she œ pa adœke: «Ɔlɔ dɨ ye yé oshonœ asœke azu gugu tœnœ nene; gi ukpulu azunœ asœke dœ́ endje gu ga lakpɨ œ yɔ kœzɨrœ nœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yisu gi fœ endje adœke: «Ádánœ adœke endje gu, gugu nene. 'E to kœzɨrœ fœ endje dœ tœ 'e!» ");
INSERT INTO kxf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kashe endje pa fœ she adœke: «'A sœ kolœnœ kpœke dœ mapa mindu œdœ dœ ageatshalangu bisha.» ");
INSERT INTO kxf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yisu kœpa fœ endje adœke: «'E ko rotœnœ fœ mœ ga mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Manda nœ, tshe pa fœ ukpulu azunœ adœke endje sœ ga atɨ ga pa gusu. Tshe ko mapa sœmœ mindu dœ ageatshalangu bisha œ tɨ ala ye ga lafo, yé œ donga Ndjaba. Tshe kavwa tshelœ mapa œ ko fœ ayambarœ nœ ye, á endje kurutshelœnœ tœ ukpulu azunœ. ");
INSERT INTO kxf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Uzu dœ uzu zɨ œrrr kpœtœ ama ogo nœ ye. Ayambarœ ko udunœ á sœpe kperœ kperœ dœ kingi ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tœ kœdɨ ayashe dœ pe agbolo nene, azu á endje zɨ lima œrœnœ, sœ ga pa œrœ nœ́ ayakoshe kutu mindu (5.000). ");
INSERT INTO kxf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Manda nœ atake, Yisu pa fœ ayambarœ nœ ye adœke endje ɔ ga lœ egerœ agba dœ́ œ zu ga ɨtshi egerœ ungu adanga utshu œne. Andaa, tshe sœpe œnœ ye lima kœgi ukpulu azunœ ga manda endje. ");
INSERT INTO kxf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yé manda kœgi ukpulu azunœ asœmœ ga manda endje, tshe ɔ ɓa pa kaga mbœrœ kœza avwala. Lɔkɔ á ɔlɔ dɨ, tshe sœpe lima ɓa zœ kutɨ ye; ");
INSERT INTO kxf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","egerœ agba wuta lima lœ ɨngɨrɨnœ tœ ɔshɔ ye. Loko sœ lima kœyakpa egerœ agbanœ; gbambanœ nene, yugu sœ lima kœza gu tœnœ dja ga utshunœ. ");
INSERT INTO kxf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dœ ɔgbɔ butshɔ, Yisu na pa ɔkɔ ungu dœ ada ye ga ndœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lɔkɔ á endje wu lima she kœna pa ɔkɔ ungu atake, awa za endje yé endje pa adœke: «Asœke kœdœ ngandoro!» Yé endje ve rawa dœ awa kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kashe ngbewo, Yisu kœpa fœ endje adœke: «'E sœ dœ gbɔgbɔ, œmœ dœmœ! Awa zaza 'e nene!» ");
INSERT INTO kxf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yé á Petro kœpa fœ she adœke: «Gbozu, œ kœdœ adja œɓœ dœmœ, za awa adœke mœ na pa ɔkɔ ungu ga ndœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yisu gi fœ she adœke: «Na ga mœ zœ!» Petro kœjerœ lœ egerœ agba yé œ kœtetœ kœna pa ɔkɔ ungu na tœnœ ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kashe lɔndɔ á tshe wu adœke yugu rosœ nœ ye, awa za she, tshe tetœ kœnduru tœnœ ga la ungu yé œ ta rawa adœke: «Gbozu, she mœ kane!» ");
INSERT INTO kxf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ngbewo Yisu kœyi kane ye á kœtepa ye, yé á kœpa fœ she adœke: «Uzu á tshe sœ dœ kœyindœrœ teasho! Mbœrœ gaɗe á ɓœ sœ kœshara upu a?» ");
INSERT INTO kxf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Endje ɔ bibisha ga lœ egerœ agba yé yugu katœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayambarœ á endje sœ lima ɓa lœ egerœ agba, gote dœ matshukuda endje ga utshu Yisu yé œ pa adœke: «Adja œɓœ kœdœ Gbolo nœ Ndjaba!» ");
INSERT INTO kxf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Manda kœzu ungunœ, endje wuta ga lœ ogo Genazarete. ");
INSERT INTO kxf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Azu oshonœ asœmœ wu lima sœ Yisu ye, œ pandœ kœyikumu ye fœ azu dje lœ ogonœ kɔ, yé á endje ko aayi koɓa kɔ natœnœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Endje sœ lima kœdɨtshelœma endje fœ she adœke tshe katœ amba ama yɔgbɔdɔ lœba nœ ye fœ endje dœ́ endje goro. Yé endjeneke kɔ á endje sœ lima kœgoro tœnœ, she lima lœ koɓa nœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Afarisayi œdœ aayi kœyisœ awa akwa to ɓa lœ Yerusaleme œ na ga ndœ Yisu, yé œ yu she adœke: ");
INSERT INTO kxf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mbœrœ gaɗe á ayambarœ nœ zœ sœsœ kœmbœrœtœ endje liaka o'o ama agbozu Ikrizia nene a? Gbambanœ nene, endje sœsœ kœdjutɔ kane endje utshu kœzɨrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yisu gi fœ endje adœke: «Ka e'e a, mbœrœ gaɗe á 'e zaza awa o'o nœ Ndjaba ga tœ akwa nene yé á sœ kœmbœrœtœ 'e lindœ o'o ama alata 'e a? ");
INSERT INTO kxf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gbambanœ nene, Ndjaba pa adœke: “Lɨ œsœ aba zœ dœ ayi zœ.” Tshe pa ndje adœke: “Tsheneke á tshe kœgu œsœ abanœ too œsœ ayinœ, tshe li kœgbɔ djofele nœ kuzu.” ");
INSERT INTO kxf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kashe e'e, 'e sœ kœpa adœke uzu kœpa fœ abanœ too fœ ayinœ adœke: “Œrœ á mœ yi má ndœ kœto tœnœ fœ ɓœ kœdœ makabo á mœ gumasœ nœ fœ Ndjaba”, ");
INSERT INTO kxf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","uzunœ asœmœ œ lɨsœ abanœ too ayinœ nene. Œtœnœ ataa á 'e za o'o ama Ndjaba vwi'i, yé á ga kolœ ndœ kœmbœrœ œrœ lindœ o'o ama aata 'e. ");
INSERT INTO kxf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wulapatshɔ! Ayi kœgbara o'o Isaya gbara lima o'o dœ ɔtshɔnœ tœ upu nœ 'e lɔkɔ á tshe pa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Azu asœ sœ kœlɨsœ mœ kolœ lœ ama endje, kashe lɔsu endje sœ zara tœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kœdonga osho nœ endje sœ gbambanœ, gbambanœ nene, œrœ á endje sœ kœyisœ nœ kœdœ kolœ o'o á to lœ ama azu.”» ");
INSERT INTO kxf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Manda nœ, Yisu e ukpulu azu yé œ pa fœ endje adœke: «'E dji yé œ wusœ œneke dœ ɔtshɔnœ kane: ");
INSERT INTO kxf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Œ dœ́dœ́ œrœ á li ga lœ ama uzu dá fa she tœ ayi uburu nene. Kashe œneke á wuta lœ ama ye dá fa she tœ ayi uburu.» ");
INSERT INTO kxf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ayambarœ nœ Yisu kœgitœ endje ga ndœ ye, yé á kœyu she adœke: «Ɓœ wusœ nœ adœke o'o zœ za ókó ga tœ lɔsu Afarisayi i?» ");
INSERT INTO kxf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tshe gi adœke: «Ɔyɔ kɔ á dœ́dœ́ Aba mœ á tshe sœ ɓa lafo dá lu nene, endje sú ye. ");
INSERT INTO kxf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","'E katœ endje ye: Endje kœdœ aayibula á endje sœ kœyisœ awa fœ aayibula anga endje. Andaa œdœ ayibula kœsœ kœyisœ awa fœ anga ayibula, endje yo kɔkɔ bibisha ga lœ kudu.» ");
INSERT INTO kxf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro za o'o œ pa fœ she adœke: «Mɨndœ ádá o'o nœ asœmœ fœ a'a kane.» ");
INSERT INTO kxf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yisu kœgi adœke: «E'e ndje, 'e gugu damba dœ kœwusœrœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'E wuwusœ nœ adœke œrœ kɔ á li ga lœ ama uzu sœ kœli ga lœ ye, yé manda nœ á tshe nu ga lœ gbakoto nene a? ");
INSERT INTO kxf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kashe œneke á wuta ɓa lœ ama uzu to ɓa lɔsu, yé œtœnœ dá fa she tœ ayi uburu. ");
INSERT INTO kxf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gbambanœ nene, gbetshelœ nœ kœmbœrœ ekperœ to ɓa tœ lɔsu uzu, gbetshelœ ɓata: Kœwo azu, kœpara awo azu, kœmbœrœ angba budu, kœzɨ angba, kœpa ekpe o'o tœ upu nœ uzu dœ pe kœgu osho. ");
INSERT INTO kxf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Œrœ á fa uzu tœ ayi uburu dœ mœ! Kashe utshu kœzɨ œrœ á ɓœ kœdjudjutɔ kane zœ nene, œ fa ɓœ tœ ayi uburu nene.» ");
INSERT INTO kxf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Manda nœ, Yisu áalafo lakpɨnœ asœmœ, œ gitœ ye ga lœ ogo Tire dœ pe Sidona. ");
INSERT INTO kxf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Anga yashe Kanana bale á tshe sœ lima kœsœ kpœtœmœ na, yé œ tetœ kœtarawa adœke: «Wu oyo mœ, Gbozu, Gbolo nœ Davidi! Ekpe ɨshirɨ sœ kœndanga yawuru nœ mœ tɔpanœ kpuru.» ");
INSERT INTO kxf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kashe Yisu gigi o'o bale fœ she nene. Ayambarœ nœ ye na á kɨ ga tœ ye adœke: «Gɔrɔ she ye, mbœrœ tshe sœ kœna manda azœ dœ rawa.» ");
INSERT INTO kxf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yisu kœgi adœke: «Endje vwa mœ kolœ fœ agbolo Israyele á endje sœ ɓata apata á endje yiwa.» ");
INSERT INTO kxf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kashe yashenœ asœmœ na œ gote ga utshu ye, yé œ pa adœke: «Gbozu, tɨ kane mœ ga lafo!» ");
INSERT INTO kxf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yisu gi adœke: «Œ sœsœ dœ ɔtshɔnœ kœko kɨzɨrœ nœ agbolo mbœrœ kœko tœnœ va fœ ayavoro nene.» ");
INSERT INTO kxf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yashenœ gi adœke: «Adjapu Gbozu, kashe ayavoro zɨ ndœma kœzɨrœ á yo tœ ama gbozu nœ endje ga tshakudu ndaba kɨzɨrœ.» ");
INSERT INTO kxf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yé Yisu gi fœ she adœke: «Yashe, kœyindœrœ nœ zœ gerœ waa! Œ mbœrœtœ endje fœ ɓœ ɓata á ɓœ yindœ nœ.» Yé ngbewo, yawuru nœ ye kœshe pe dœ lɔkɔnœ asœmœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisu wuta lœ ogonœ asœmœ yé œ ro ga tœ mangu egerœ ungu adanga lœ Galilayi. Tshe ɔ ga pa kaga yé œ sœ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Azu ndjoro na ga ndœ ye. Endje na dœ azu á ada endje ndɨ, dœ aayibula, dœ aayi vwɨrɨtɨ, dœ aayi bitu, dœ pe anga aayi koɓa ndjoro. Endje katœ endje ga utshu Yisu, yé á tshe she endje. ");
INSERT INTO kxf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Azu katœ ama endje tɨ ɔsɔ lɔkɔ á endje wu aayi bitu kœpa o'o; dœ azu á endje ndɨ, kœshe tœnœ; dœ azu á ada endje ndɨ, kœna ana; dœ pe azu á ala endje bu, á tetœ kœwu osho. Yé á azu kɔ donga mokɔ nœ Ndjaba nœ Israyele. ");
INSERT INTO kxf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu e ayambarœ nœ ye, œ pa fœ endje adœke: «Oyo azunœ asœ ka mœ waa, gbambanœ nene, endje mbœrœ olo votɔ dœ mœ, yé endje gugu dœ kœzɨrœ nene. Mœ yiyindœ kœgi endje dœ ogo nene: Ete nene, endje mbombo tœ ala awa ye.» ");
INSERT INTO kxf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ayambarœ pa fœ she adœke: «A gbɔ má rœgo lœ kpagagashonœ asœke kpœta yeka á kœto fœ endje á endje kœzɨ, á kœle endje a?» ");
INSERT INTO kxf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yisu yu endje adœke: «'E sœ dœ mapa koto o?» Endje gi fœ she adœke: «Mindu dœ bisha dœ pe a'eara ageatshalangu teasho.» ");
INSERT INTO kxf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yé á tshe kœpa fœ ukpulu azunœ asœmœ adœke endje lœ ga tœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tshe ko mapa mindu dœ bisha dœ pe ageatshalangunœ œ donga Ndjaba, œ ko fœ ayambarœ, yé á ayambarœ kœkurutshelœ nœ tœ ukpulu azunœ. ");
INSERT INTO kxf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Uzu dœ uzu zɨ œrrr œ le she kpœtœ ama ogo nœ ye. Ayambarœ rɔ ama udu rœgo á sœpe ga lœ kingi mindu dœ bisha (7). ");
INSERT INTO kxf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Andaa, azu á endje zɨ lima œrœnœ sœ ayakoshe kutu vana, endje dɨdɨ ayashe dœ agbolo nene. ");
INSERT INTO kxf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Manda kœgi azu gangba endje, Yisu ɔ ga lœ egerœ agba yé œ ro ga lœ ogo Magadane. ");
INSERT INTO kxf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afarisayi dœ Asadukayi na ga ndœ Yisu œ tetœ kœgɨ uku ga tœ awa ye. Endje yu she adœke tshe ma anga ambárá afá tœ kœma adœke œ to ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yisu gi fœ endje adœke: «Dœ adɨla, 'e sœ kœpa adœke: “Yavuru œ ni nene, mbœrœ tshalafo sœ tshee.” ");
INSERT INTO kxf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yé pe dœ amazɨ tuu, 'e sœ kœpa adœke: “Kpesheke yavuru œ ni zœ, mbœrœ tshalafo bu shoshosho.” Ataa 'e wusœ kœpandœ mara á tshalafo sœ dœ tœnœ ye, kashe 'e lili kœpandœ ambárá nœ œrœ nœ tshakpesheke asœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Azu nœ tshakpesheke á endje dœ aekpe azu yé á zazatœ endje fœ Ndjaba nene, sœ kœyɔndœ ambárá! Kashe endje wu anga angbɨ ambárá bale nene, kolœ œnœ Yona œ ka ye. Manda nœ, tshe katœ endje tɨ kpœtœmœ yé œ ro daye.» ");
INSERT INTO kxf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lɔkɔ kœzu ayambarœ ga itshi kota, œndœ kœko kœzɨrœ djerœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yisu kœpa fœ endje adœke: «Ala 'e gbɔ dœ ɔyɔ kœsuku mapa nœ Afarisayi dœ pe Asadukayi kane.» ");
INSERT INTO kxf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ayambarœnœ te lima tœ kœpa ugurutœ endje adœke: «Tshe sœ kœpa ataa mbœrœ á a nana dœ mapa nene.» ");
INSERT INTO kxf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kashe Yisu wu lima sœ gbetshelœ nœ endje, yé œ pa fœ endje adœke: «E'e dœ azu á kœyindœrœ nœ 'e sœ teasho, mbœrœ gaɗe á 'e sœ kœyutœ 'e ugurutœ 'e adœke 'e gugu dœ mapa nene a? ");
INSERT INTO kxf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Œrrr kpesheke, 'e wuwu damba sœ œrœ nene a? Œndœ mapa mindu á 'e kurutshelœ nœ tœ azu kutu mindu (5.000) œdœ kingi kotoo á 'e ko lima dœ udunœ, djerœ 'e ye a? ");
INSERT INTO kxf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Œndœ mapa mindu dœ bisha (7) á 'e kuru lima tshelœ nœ tœ azu kutu vana œdœ kingi kotoo á 'e ko lima dœ udunœ, djerœ 'e ye a? ");
INSERT INTO kxf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mbœrœ gaɗe á 'e wuwusœ nœ adœke mœ sœsœ lima kœpa o'o tœ mapa fœ 'e nene lɔkɔ á mœ sœ lima kœpa fœ 'e adœke: Ala 'e gbɔ tœ ɔyɔ kœsuku mapa nœ Afarisayi dœ Asadukayi a?» ");
INSERT INTO kxf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yé á ayambarœnœ kœwusœ nœ adœke tshe papa o'o tœ upu nœ kœsœ dœ gbɔdjela tœ ɔyɔ kœsuku mapa nene, kashe tshe pa tœ kœyisœrœ nœ Afarisayi dœ pe Asadukayi. ");
INSERT INTO kxf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lɔkɔ á Yisu yi kumu ye ga lœ ogo Sezaré, ogo gbozu Filipo, tshe yu ayambarœ nœ ye adœke: «Azu sœ kœpa má kotoo tœ upu nœ Gbolo nœ uzu a?» ");
INSERT INTO kxf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Endje gi adœke: «Anga azu sœ kœpa adœke, œɓœ kœdœ Yowane ayi kœza batisimu; anga endje sœ kœpa ndje adœke œɓœ kœdœ Eliya; yé anga endje kpa sœ kœ pa œnœ endje adœke, œɓœ kœdœ Yilimiya too anga ayi kœgbara o'o ugurutœ aayi kœgbara o'o liya.» ");
INSERT INTO kxf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yé Yisu kœyu endje adœke: «Yé ka e'e a, 'e sœ kœpa má œnœ 'e adœke œmœ kœdœ ɗe?» ");
INSERT INTO kxf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Shimu Petro za o'o yé á gi adœke: «Œɓœ kœdœ Kristu, Gbolo nœ Ndjaba nœ soro.» ");
INSERT INTO kxf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yisu kœpa fœ she adœke: «Yanga nœ zœ, Shimu gbolo nœ Yona, mbœrœ œ dœ́dœ́ ɔkɔ dœ indji dá pandœ o'o asœ fœ ɓœ nene, kashe Aba mœ á tshe sœ ɓa lafo dá pandœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yé œmœ, mœ sœ kœpandœ nœ fœ ɓœ adœke œɓœ kœdœ Badja, ga pa badjanœ asœmœ dá mœ mɔ bala Ikrizia nœ mœ, yé kuzu œ sœ bala dœ gbɔgbɔ ga pa Ikrizianœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mœ za bala herela nœ Ogo gbozu nœ tshalafo fœ ɓœ; œrœ kɔ á ɓœ i ga tœnœ ɓa pa ɔshɔ, Ndjaba œ i ndje ga tœnœ ɓa lafo; œrœ kɔ á ɓœ vwara tshelœnœ ɓa pa ɔshɔ, Ndjaba œ vwara ndje tshelœnœ ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Manda nœ, Yisu kœkɔ lima ayambarœ nœ ye dœ ɔgbɔ adœke endje papandœ nœ fœ uzu bale adœke œne kœdœ Kristu nene. ");
INSERT INTO kxf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kœto kpœtœ lɔkɔnœ asœmœ, Yisu Kristu tetœ kœpandœ nœ fœ ayambarœ nœ ye adœke: «Œ li adœke mœ ro ga lœ Yerusaleme yé œ wu œrœ kanga waa tshakane agbozu Ikrizia, agbozu tshapa anganga Ndjaba ndje dœ aayi kœyisœ awa akwa yekane. Endje wo mœ, yé manda olo votɔ, Ndjaba œ she mœ lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yé Petro gi she ga ɨndɨrɨnœ yé œ tetœ kœgbagbara she adœke: «Gbozu, Ndjaba œ gbɔndœ zœ lœnœ ye! Œrœ ataa œ wuta ga tœ zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kashe Yisu fatœ yé œ pa fœ Petro adœke: «Gitœ zœ tœ mœ, Satana! Œɓœ kœdœ uzu nœ kœza o'o ga pa mœ adœke mœ te. Gbetshelœ nœ zœ lili dœ œnœ Ndjaba bale nene, kashe œ li dœ œnœ azu.» ");
INSERT INTO kxf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Manda nœ, Yisu pa fœ ayambarœ nœ ye adœke: «Œdœ uzu kœyindœ kœna manda mœ, œ li adœke tshe vwaratœ ye tœ undu ye dœ tœ ye, œ za kurushi nœ ye yeka á kœna manda mœ. ");
INSERT INTO kxf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gbambanœ nene, uzu kɔ á tshe sœ dœ ogo kœsœ dœ soro œ tshu ye; kashe tsheneke á tshe tshu mbœrœ mœ, œshe dá sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ataa uzu kœgbɔ œrœ tshapashɔ asœke kɔ gbaa, œ sœ dœ she kotoo ɓata á soro ye ndɨ a? Œrœ gaɗe dá tshe ka á kpa yɔ dœ soro ye a? ");
INSERT INTO kxf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gbolo nœ uzu œ kwa bala tœ ye awa bale dœ aandjelu nœ ye lœ mokɔ nœ Abanœ, yé tshe gi bala fœ uzu dœ uzu liaka akwa tshelœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mœ sœ kœpa fœ 'e dœ adjapu adœke, ugurutœ 'e á 'e sœ asœ, anga 'e œ tshu nene utshu kœwu Gbolo nœ uzu kœna ɓata gbozugo.» ");
INSERT INTO kxf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Manda olo mindu dœ bale, Yisu za Petro, Jake œdœ pe ayanœ dœ Yowane po tœ ye, œ gitœ ye dœ endje ga ɨndɨrɨnœ ga pa egerœ kaga. ");
INSERT INTO kxf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tshe fatœ ye dœ ala endje; tshatshu ye tetœ kœtshi tœnœ ɓata ɔlɔ, lœba ye wuta tœ imbinœ urrr ɓata ɨshirɨ osho. ");
INSERT INTO kxf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ngbewo, Eliya œdœ Moyize wuta ga utshu endje, yé œ sœ kœpa tshama endje dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petro pa fœ Yisu adœke: «Gbozu, œ sœ dœ ɔtshɔnœ adœke a lœ kpœke. Œdœ ɓœ kœyindœ nœ, mœ mɔ anda tande votɔ: Bale fœ ɓœ, bale fœ Moyize œdœ bale ndje fœ Eliya.» ");
INSERT INTO kxf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tshe sœpe damba kœpa 'o atake, trale ondoro jerœ ga pa endje, yé anga tshama wu ɓa lœnœ adœke: «Tsheneke kœdœ Gbolo nœ mœ á mœ yindœ ye waa, mœ za yanga nœ mœ djigi ga ndœ ye. 'E dji she!» ");
INSERT INTO kxf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lɔkɔ á ayambarœ dji tshamanœ asœmœ ataa, awa litœ endje kpakpakpa yé endje yo ga atɨ œ fa tshatshu endje ga tœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yisu na ndoo dœ endje œ turutœ endje yé á pa adœke: «'E alafo, 'e sœsœ dœ awa nene.» ");
INSERT INTO kxf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kœmesho ga lafo atake, endje wu kolœ Yisu kutɨ ye. ");
INSERT INTO kxf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ɓata endje sœ lima kœjerœ kaga, Yisu kɔ endje adœke: «'E papandœ œrœ kɔ á 'e wu asœke fœ uzu bale nene, œrrr ga tœ adœke Gbolo nœ uzu she lœ akuzu yekane.» ");
INSERT INTO kxf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yé ayambarœ nœ ye yu she adœke: «Mbœrœ gaɗe á ayi kœyisœ awa akwa pa lima adœke Eliya œ na utshunœ yekane a?» ");
INSERT INTO kxf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tshe gi fœ endje adœke: «Adjapu, Eliya œ na utshunœ mbœrœ kœguma œrœ kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kashe mœ sœ kœpa fœ 'e adœke: Eliya na ɓa lima ye, yé azu yiyindœ ye nene, kashe endje mbœrœ fœ she œneke kɔ á endje yi lima ndœ nœ. Awa bale ndje endje mbœrœ œrœ kanga fœ Gbolo nœ uzu.» ");
INSERT INTO kxf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yé á ayambarœ nœ ye kœwusœ nœ adœke, tshe sœ lima kœpa o'onœ fœ œne tœ Yowane ayi kœza batisimu. ");
INSERT INTO kxf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lɔkɔ á endje wuta lima ndoo dœ ukpulu azu, anga yakoshe bale na ga ndœ Yisu, œ gote dœ matshukuda ye ga utshu ye á pa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Gbozu, wu oyo gbolo yakoshe nœ mœ. Tshe sœ dœ koɓa ɔkɔ á sœ ndœ kœka she waa, œ geta she kpala kpala ga tawo too ga langu. ");
INSERT INTO kxf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mœ na dœ she fœ ayambarœ nœ zœ, kashe endje lili tœ kœshe she nene.» ");
INSERT INTO kxf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisu kœpa adœke: «E'e kœdœ aekpe azu, yé 'e gugu dœ kœyindœrœ nene! Mœ kpa sœpe dœ 'e œrrr manda olo koto yekane a? Mœ kpa ru lɔsu mœ mbœrœ 'e manda olo koto o? 'E na dœ gbolonœ fœ mœ ga mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yisu nga fœ ekpe ɨshirɨnœ; tshe wuta lœ gbolonœ yé á tshe kœshe pe dœ lɔndɔnœ asœmœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ayambarœ gitœ endje ndoo dœ Yisu, yé á yu she yaa adœke: «Yé ká a'a, mbœrœ gaɗe á 'a lili má œnœ 'a kœgɔrɔ ekpe ɨshirɨnœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yisu pa fœ endje adœke: «Mbœrœ kœyindœrœ nœ 'e sœ teasho. Mœ sœ kœpa tœnœ fœ 'e dœ adjapu, œdœ anga ɔlɔ bale 'e kœsœ dœ kœyindœrœ á sœ dœ egerœnœ ɓata ele ɔyɔ á ɨ'ɨrɨnœ kœdœ mutarde, 'e pa fœ kaga asœke adœke: “Aafo kpœke œ tɔ ɓa e”, kaga œ mbœrœtœ ye liakanœ ye. Œrœ bale á sœ dœ sharapu ɓa ndœ 'e œ gugu nene.  ");
INSERT INTO kxf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kashe kolœ lœ awa nœ avwala œdœ lœ œnœ kœyotshelœma dá endje li kœgɔrɔ dœ mara ekpe ɨshirɨnœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anga ɔlɔ bale, ayambarœ ngbɔɓa lima tœ endje ɓa lœ ogo Galilayi, Yisu pa fœ endje adœke: «Endje ka Gbolo nœ uzu ga tshaabrœ azu; ");
INSERT INTO kxf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","endje wo she yé manda olo votɔ, Ndjaba œ she she lœ akuzu.» Ayambarœ nœ ye sœ lima dœ oyo waa. ");
INSERT INTO kxf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɔlɔ á endje li ga lœ Kaparnawumu, azu á endje ka lapo ɓa lœ Tepelo na ga ndœ Petro, yé á pa fœ she adœke: «Gbozu nœ 'e œ yɔ lapo nœ Tepelo nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro gi adœke: «Œ̃, tshe yɔ ye.» Ɔlɔ á Petro yi kumu ye ga sœnda, Yisu yu she adœke: «Gbetshelœ nœ zœ kœdœ gaɗe Shimu? Aɗe dá yɔ walaka lapo nœ agbozugo nœ tshapashɔ a? Agbolo nœ endje too anga angbɨ azu?» ");
INSERT INTO kxf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro gi adœke: «Angbɨ azu.» Yé Yisu kœpa fœ she adœke: «Agbolo nœ endje yɔyɔ ka nene. ");
INSERT INTO kxf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kashe a yɔ œnœ azœ ye, mbœrœ á kœzaza ókó fœ azunœ asœ nene. Mbœrœ tœnœ, na ga la kota œ vwi ngada; ali ageatshalangu á ɓœ djɔ she, a tshelœma ye, ɓœ gbɔ langere ngendja lœnœ. Za œ gu dœ tœnœ, œ za fœ endje mbœrœ mœ œdœ pe ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dœ lɔndɔnœ asœmœ, ayambarœ nœ Yisu gitœ endje ga ɨndɨrɨ ye, yé á pa fœ she adœke: «Œɗe dá ropa azu kɔ ɓa lœ Ogo gbozu nœ tshalafo a?» ");
INSERT INTO kxf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yisu e anga gbolo œ za she tɔ ga ugurutœ endje ");
INSERT INTO kxf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yé œ pa adœke: «Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ 'e kœyayapatœ 'e yé á sœ ɓata aya agbolo nene, 'e li bala ga lœ Ogo gbozu nœ tshalafo nene. ");
INSERT INTO kxf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ataa, tsheneke á tshe mbœrœtœ ye ɓata aya gbolonœ asœ, œshe dá ropa azu kɔ ɓa lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO kxf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Uzu á tshe za osho kœsœ fœ gbolo lœ ɨ'ɨrɨ mœ ɓata tsheneke asœ, za osho kœsœ fœ mœ dœ tœ mœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Kashe uzu á tshe mbœrœ adœke anga aya gbolo bale ugurutœ agbolo asœke á endje sœ dœ kœyindœrœ ga ndœ mœ, li ga lœ ekperœ, œ li adœke endje du egerœ badja ga lœ ɨgɨ ye, œ na dœ́ œ geta she ga la egerœ ungu. ");
INSERT INTO kxf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oyo nœ azu tshapashɔ á endje sœ kœmbœrœ adœke azu li ga lœ ekperœ! Œ li adœke œrœ ataa mbœrœtœ endje, kashe oyo nœ uzu neke á yanganœ œ te mbœrœ she. ");
INSERT INTO kxf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Œdœ kane zœ too ada zœ dá sœ kœmbœrœ adœke ɓœ te, wa œ ko va e zara tœ zœ; œ li dœ ɔtshɔnœ mbœrœ ɓœ adœke ɓœ li ga lœ adja soro dœ kane zœ bale too dœ ada zœ bale, tœ œsœnœ adœke ɓœ sœpe dœ kane zœ bibisha œdœ pe ada zœ bibisha yé endje vwi ɓœ ga lœ kudu owo á ru nene. ");
INSERT INTO kxf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yé œdœ ala zœ kœvwa ɓœ ndœ ekperœ, vwata yé œ za vwi'i zara tœ zœ, œ li dœ ɔtshɔnœ mbœrœ ɓœ adœke ɓœ li ga lœ adja soro dœ ala zœ bale, tœ œsœnœ adœke ɓœ sœpe dœ ala zœ bibisha yé endje vwi ɓœ ga lœ kudu owo nœ lifelo.» ");
INSERT INTO kxf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ala 'e gbɔ adœke 'e kœgugu œsœ anga gbolo bale ugurutœ aya agbolo asœke nene. Gbambanœ nene, mœ sœ kœpa fœ 'e, aandjelu nœ endje sœ ɔlɔ dœ ɔlɔ ɨndɨrɨ Aba mœ á tshe sœ ɓa lafo.  ");
INSERT INTO kxf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gbambanœ nene, Gbolo nœ uzu na ndœ kœshe azu á endje sœ lima lœ djingili. ");
INSERT INTO kxf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«'E gbe œnœ 'e koto o? Œdœ anga uzu kœsœ dœ apata kama bale (100), yé anga bale lœ ugurutœ endje kœyiwa, ataa tshe katœ udu endje zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) ɓa pa kaga, ndœ kœna kœpara tsheneke tshebale á tshe yiwa asœmœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Œ kœsœ adœke tshe gbɔ she, mœ sœ kœpa fœ 'e dœ adjapu adœke, tshe sœ dœ yanga ye kœropa udu endje zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) á endje yiyiwa nene asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Awa bale, Aba 'e á tshe sœ ɓa lafo asœmœ, yiyindœ nœ adœke anga gbolo bale ugurutœ aya agbolonœ asœmœ yiwa nene.» ");
INSERT INTO kxf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Œdœ anga aya zœ kœmbœrœ ekperœ ga tœ zœ, na ga ndœ ye kutu zœ œ gbagbara she tœ ekperœ á tshe mbœrœ, œdœ tshe kœdji ɓœ, dá tshe kpa wuta aya zœ. ");
INSERT INTO kxf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Œdœ tshe kœdjidji ɓœ nene, kpa za anga uzu bale too bisha ga ndœ zœ yeka á 'e kœwa o'onœ “mbœrœ œ li adœke atimu bisha too votɔ yindœ o'onœ yekane.” ");
INSERT INTO kxf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Œdœ tshe kœvwaratœ ye ndœ kœdji endje, pandœ nœ ga lœ Ikrizia, yé tshe kœdjidji ndje azu Ikrizia nene, za she ɓata angbɨ uzu too ɓata ayi kœka lapo. ");
INSERT INTO kxf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mœ sœ kœpa fœ 'e dœ adjapu adœke: Œrœ kɔ á 'e i ga tœnœ pa ɔshɔ asœ, endje i ndje ga tœnœ ɓa lafo; yé œrœ kɔ á 'e vwara tshelœ nœ pa ɔshɔ asœ, endje vwara ndje tshelœ nœ ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Mœ kpa sœ kœpa fœ 'e dœ adjapu adœke, œdœ azu bisha ugurutœ 'e pa ɔshɔ kœpa upu ama endje bale ndœ kœyɔndœ œrœ gaɗe, Aba mœ ɓa lafo œ to œrœnœ asœmœ fœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gbambanœ nene, osho á azu bisha too votɔ œ ngbɔtœ endje ga tœnœ dœ ɨ'ɨrɨ mœ, mœ sœ ugurutœ endje zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ataa, á Petro na ga ndœ ye á yu she adœke: «Gbozu, œdœ aya mœ kœmbœrœ ekperœ fœ mœ, mœ djerœndœ ekperœnœ awa kotoo? Œrrr ga tœ awa mindu dœ bisha a (7)?» ");
INSERT INTO kxf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yisu kœgi fœ she adœke: «Mœ papa fœ ɓœ adœke awa mindu dœ bisha nene, kashe œrrr ga tœ awa zazu votɔ dœ ndjokpa awa mindu dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ogo gbozu nœ tshalafo œ sœ bala kolœnœ ataa: Œ sœ ɓata anga gbozugo bale á tshe yi lima ndœ kœtondœ o'o tœ upu nœ kuɗa nœ ye dœ aayi akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tœ ali nœ, endje na dœ anga ayi akwa á tshe sœ dœ kuɗa nœ ye tɔpanœ kpuru fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɓata á tshe sœsœ lima dœ œrœ bale ndœ kœgi tœnœ nene, gbozunœ za awa adœke endje za she yɔ œrœ dœ awonœ, agbolo nœ ye, œdœ ndje pe dœ œrœ kɔ á tshe sœ dœ tœnœ lœ okoro kuɗa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ayi akwanœ gote ga tœ ada ye, œ dɨ tshelœma ye fœ she adœke: “Gbozu, sœ dœ ugu lɔsu ga ndœ mœ, yé mœ gi fœ ɓœ para zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oyo za gbozu nœ ayi akwanœ, tshe katœ ye adœke tshe gu zœ yé œ katœ kuɗa nœ ye lœ kumu ye tɨ ye. ");
INSERT INTO kxf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Kœwuta ayi akwa asœmœ atake, tshe togba dœ anga yanganœ á tshe sœ dœ kuɗa nœ ye teasho lœ kumu ye; tshe za ɔngɔrɔ yanganœ kperœ ndœ kœwo she dœ kœpa fœ she adœke: “Gi kuɗa nœ mœ fœ mœ.” ");
INSERT INTO kxf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ayi akwa nganœ sœmœ kœgote ga tœ ada ye, yé œ dɨ tshelœma ye fœ she dœ kœpa adœke: “Sœ dœ ugu lɔsu ga ndœ mœ, mœ gi fœ ɓœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kashe tshe vwaratœ ye, yé ga pa nœ tshe na dœ she œ za she vwi ga lœ anda kánga ndœ kœkate adœke tshe gi kuɗa nœ œne yekane. ");
INSERT INTO kxf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kœwu œrœ á tshe mbœrœ asœmœ ataa, œ za oyo tœ lɔsu aayi akwa anganœ, yé endje na œ pandœ œrœ kɔ á ro asœmœ fœ gbozu nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yé gbozu e she, á pa fœ she adœke: “Ekpe ayi akwa, mœ katœ kuɗa nœ mœ lœ kumu zœ tɨ kɔ mbœrœ á ɓœ dɨtshelœma zœ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Œɓœ ndje, ɓœ lili má ndœ kœwu oyo ayi akwa nga zœ ɓata á œmœ dœ tœmœ mœ wu oyo zœ nene a?” ");
INSERT INTO kxf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Oko za gbozu, tshe za she vwi ga lœ anda kánga ndœ kœkate ndje adœke tshe kœgi kuɗa nœ œne kɔ fœ œne yekane.» ");
INSERT INTO kxf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Ataa, Aba mœ ɓa lafo œ mbœrœ bala mara œrœnœ asœmœ fœ 'e, œdœ uzu dœ uzu ugurutœ 'e kœdjedjerœndœ ekperœ nœ ayanœ dœ lɔsu ye bale nene.» ");
INSERT INTO kxf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɔlɔ á Yisu katœ kœmɨndœ upu asœmœ, tshe gitœ ye lœ Galilayi ndœ kœro ga lœ ogo Yuda ɓa kele ungu Yɔrdane. ");
INSERT INTO kxf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Azu ndjoro na manda ye, yé ɓa zœ tshe sœ kœshe endje. ");
INSERT INTO kxf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Anga Afarisayi na ga ndœ ye dœ gbetshelœ nœ kœgɨ uku ga tœ awa ye, yé á yu she adœke: «Œ li dœ yakoshe kovwaratœ ye tœ awonœ lœ upu kɔ a?» ");
INSERT INTO kxf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tshe gi fœ endje adœke: «'E dɨdɨ lima œneke á endje sú ɓa la buku nœ Ndjaba adœke, lœ kœmbœrœ œrœ ga pa ɔshɔ asœke, Ndjaba mbœrœ lima yakoshe œdœ yashe nene a? ");
INSERT INTO kxf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Manda nœ, tshe pa adœke: Mbœrœ tœnœ ataa á yakoshe œ katœ abanœ dœ ayinœ tɨ, á sœ ga tœ œsœnœ dœ awonœ, yeka á endje bisha œ wuta undu uzu tshebale. ");
INSERT INTO kxf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ataa, endje kpa sœsœ azu bisha nene kashe undu uzu tshebale. Kaka adœke uzu ndjɔndjɔ tshelœ œneke á Ndjaba ngbɔɓa ga tœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Endje pa fœ she adœke: «Mbœrœ gaɗe á Moyize za lima awa adœke yakoshe su mbeti kœkurutshelœ totœ ga tshakane yashe lɔkɔ á tshe kœkatœ ye tɨ a?» ");
INSERT INTO kxf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yisu gi fœ endje adœke: «Moyize za lima awa ndœ kœkatœ awo 'e tɨ mbœrœ agbɔ lɔsu nœ 'e, kashe utshunœ œ sœsœ lima ataa nene. ");
INSERT INTO kxf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mœ sœ kœpandœ nœ fœ 'e adœke, œdœ uzu kœkatœ awonœ tɨ, á kœdœ́dœ́ tœ upu nœ angba budu nene, á tshe kpa to anga angbɨ yashe, tshe sœ kœpara awo uzu.» ");
INSERT INTO kxf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ayambarœ kœpa fœ she adœke: «Œdœ upu nœ kœtotœsho nœ yakoshe dœ yashe kœsœ ataa, ádá nœ kœtotœsho gugu nene.» ");
INSERT INTO kxf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yisu gi fœ endje adœke: «Œ dœ́dœ́ uzu kɔ dá dji tshelœ kata o'o asœ nene, kashe kolœ endjeneke á Ndjaba za awa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gbambanœ nene, ádá á azu œ vwaratœ endje kœto ayashe sœ ndjoro: Endje zu anga azu dœ koɓa kutshu; anga kœsœ angara to tshakane azu; yé anga azu yiyindœ kœto ayashe nene mbœrœ kœpara Ogo gbozu nœ tshalafo. Uzu á tshe li kœdji tshelœkata o'o asœke kɔ, kaka tshe dji!» ");
INSERT INTO kxf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Azu na dœ agbolo fœ Yisu adœke tshe to kane ye ga pa endje kashe ayambarœ nœ ye sœ lima kœgeta endje. ");
INSERT INTO kxf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yisu pa adœke: «'E katœ agbolo endje na ga ndœ mœ, 'e kɔkɔ endje nene mbœrœ Ogo gbozu nœ tshalafo sœ mbœrœ azu á endje lœ ɓata endje.» ");
INSERT INTO kxf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yé manda kœto kane ye ga pa endje, tshe gitœ ye kpœtœmœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anga uzu bale na ga ndœ Yisu, yé œ yu she adœke: «Ayi kœyisœrœ, ɔtshɔrœ gaɗe dá mœ kœmbœrœ yeka á kœgbɔ soro neke á ka nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisu kœpa fœ she adœke: «Mbœrœ gaɗe á ɓœ sœ kœyu mœ pa ɔtshɔrœ a? Kolœ Ndjaba kutɨ ye dá dœ ɔtshɔ uzu. Œdœ ɓœ kœyindœ kœgbɔ soro, gbɔndœ awa o'o ama Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tshe yu Yisu adœke: «Œneketa a?» Yisu gi fœ she adœke: «Ɓœ wo uzu nene, ɓœ para awo uzu nene, ɓœ zɨ angba nene, ɓœ wa o'o dœ wala ga pa uzu nene. ");
INSERT INTO kxf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Lɨ œsœ aba zœ dœ ayi zœ, yé ɓœ yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gbolo modonœ gi fœ she adœke: «Œrœnœ asœmœ kɔ, mœ sœ kœmbœrœtœ mœ liakanœ zœ. Œrœ gaɗe dá kpa sœpe adœke mœ mbœrœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yisu pa fœ she adœke: «Ɓœ kœyindœ kœsœ ndjii tœ ala Ndjaba, gu œ ka œrœ nœ zœ, œ kurutshelœnœ tœ aayi oyo, yé ɓœ gbɔ bala kœgbɔrœ ɓa lafo. Manda nœ, fatœ zœ œ na manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Manda o'onœ asœmœ, tshe gu dœ oyo tœ ye, mbœrœ tshe sœ lima dœ œrœ waa. ");
INSERT INTO kxf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yé Yisu kœpa fœ ayambarœ nœ ye adœke: «Mœ sœ kœpa dœ adjapu fœ 'e, œ sœ tœ ɔgbɔnœ bala tœ ayi kœgbɔrœ kœli ga lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO kxf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yisu kpa pa fœ endje adœke: Œ gbɔɔgbɔ adœke agea á ɨ'ɨrɨ ye kœdœ shamo li tɔlœ ogoro ɨmbɨlɨ. Kashe œ kpa gbɔ kœrosœ nœ adœke ayi kœgbɔrœ li ga lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kœdji o'onœ asœmœ ataa, ayambarœ katœ ama endje tɨ ɔsɔ, yé œ pa adœke: «Atamœ, uzu ɗe dá li kœshe tœnœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yisu tondœ endje, yé œ pa fœ endje adœke: «Ɓa tœ azu, œ li nene; kashe ɓa tœ Ndjaba, œrœ kɔ li ye.» ");
INSERT INTO kxf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yé Petro kœza 'o, á kœpa fœ she adœke: «Wu kane, 'a katœ œrœ nœ 'a tɨ kɔ á na manda zœ asœ; œ sœ bala dœ a'a koto o?.» ");
INSERT INTO kxf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yisu pa fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke: Ɔlɔ á Ndjaba kpa mbœrœ tshandœ œrœ kɔ tœ tafonœ, olo á Gbolo nœ uzu œ sœ ga lœ ngande mokɔ nœ ye ndœ kœwa ngbanga, e'e á 'e na lima manda mœ, 'e sœ ndje ga pa ngande tshagbozu mokɔ ndjokpa dœ bisha ndœ kœwa ngbanga pa mara azu Israyele ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yé uzu kɔ á tshe katœ anda nœ ye, dœ aayanœ, ayingɔnœ, abanœ, aayinœ, agbolo nœ ye, kɨndɨ nœ ye tɨ mbœrœ ɨ'ɨrɨ mœ, tshe kpa gbɔ œrœ kœropanœ ye, tshe gbɔ ndje soro nœ waa dœ waa. ");
INSERT INTO kxf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Azu ndjoro á endje sœ utshunœ, endje sœ bala tœ ndɔngɔlɔnœ, yé endje nœ ndɔngɔlɔnœ œ te bala azu nœ tshatshunœ.» ");
INSERT INTO kxf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Kœgbɔ Ogo gbozu nœ tshalafo sœ ɓata anga gbozu akwa, á tshe wuta dœ amazɨ kœpara aayi akwa nœ tshelœ kɨndɨ vinu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tshe djitœ ye dœ endje dœ ɔtshɔnœ pa denari bale á li adœke endje gbɔ dœ ɔlɔ bale, yeka á vwa endje ga lœ kɨndɨ vinu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kœwuta she dœ ada ɔlɔ mindu dœ vana utshu kakpi ɔlɔ, tshe wu anga azu, endje sœ gbambanœ, ");
INSERT INTO kxf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","tshe pa fœ endje adœke: “E'e ndje, 'e na ga lœ kɨndɨ vinu nœ mœ, mœ to ndje ngendja á li dœ ɔlɔ bale fœ 'e.” ");
INSERT INTO kxf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Endje ro ndje da ye. Tshe kpa wuta dœ kakpi ɔlɔ œdœ dœ ada ɔlɔ votɔ manda kakpi ɔlɔ, œ pa kolœnœ ata fœ anga azu á tshe gbɔ endje. ");
INSERT INTO kxf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kœwuta ga pa œrœ nœ́ ada ɔlɔ mindu dœ adɨla, tshe kpa wuta ndje, œ kpa gbɔ anga azu á endje sœ ndje ɓa zœ yé œ pa fœ endje adœke: “Mbœrœ gaɗe dá 'e sœ kpœke œrrr kpii á mbœmbœrœ akwa nene a?” ");
INSERT INTO kxf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Endje gi fœ she adœke: “Uzu bale zaza akwa fœ 'a nene.” Gbozu akwanœ kœpa fœ endje adœke: “E'e ndje, 'e na ga lœ kɨndɨ vinu nœ mœ.” ");
INSERT INTO kxf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Kœwuta ga tœ umbru osho, ayengɔ kɨndɨ vinunœ pa fœ kapeta adœke: “E ayi akwanœ para dœ́ œ ko ngendja tshangba akwa nœ endje fœ endje, kœto tœ endjeneke á mœ e endje tœ ndɔngɔlɔnœ asœmœ œrrr ga tœ endjeneke á mœ e má endje utshunœ.” ");
INSERT INTO kxf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Azunœ ada ɔlɔ mindu nœ adɨla na œ gbɔ uzu dœ uzu denari bale. ");
INSERT INTO kxf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kœwuta ga tœ azu á endje na má utshunœ, endje gbe œnœ endje adœke œne dá gbɔ tɔpanœ kpuru; kashe endje gbɔ ndje uzu dœ uzu denari bale. ");
INSERT INTO kxf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lɔkɔ á endje gbɔ ngendjanœ, endje te lima tœ kœpulœma endje tœ ayengɔ kɨndɨnœ. ");
INSERT INTO kxf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Endje pa lima adœke: “Aayi akwa á endje na manda nœ, endje mbœrœ akwa kolœ manda ada ɔlɔ bale, ɓœ to ngendja fœ endje awa bale dœ 'a á a wu oyo œrrr kpii tshakudu ɔlɔ dœ kœwosho!” ");
INSERT INTO kxf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kashe tshe gi fœ anga bale ugurutœ endje adœke: “Yanga mœ, mœ mbœmbœrœ ekperœ fœ ɓœ nene; a djidjimatœ azœ dœ mœ tœ denari bale lœ ɔlɔ bale nene a? ");
INSERT INTO kxf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Za œneke á sœ tshakane zœ asœmœ, œ gu dœ tœnœ zœ. Mœ yindœ kœto ngendja fœ uzu á tshe na tœ ndɔngɔlɔnœ asœmœ awa bale dœ ɓœ. ");
INSERT INTO kxf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Œ lili dœ mœ kœmbœrœ œneke á mœ yindœ nœ dœ œrœ nœ mœ nene a? Too ɓœ sœ dœ uku ga tœ mœ mbœrœ á mœ sœ dœ ɔtshɔ lɔsu a?” ");
INSERT INTO kxf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Atamœ, azu á endje sœ tœ ndɔngɔlɔnœ œ wuta bala azu utshunœ; yé endjeneke á endje sœ utshunœ, œ wuta tœ ndɔngɔlɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisu dœ ayambarœ nœ ye ndjokpa dœ bisha (12) sœ lima kœro ga lœ Yerusaleme, yé á tshe sœ kœpa fœ endje na tœnœ tœ awa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«'E wu, a sœ kœɔ ga lœ Yerusaleme, ɓa tœ osho á endje ka Gbolo nœ uzu fœ agbozu tshapa anganga Ndjaba œdœ fœ aayi kœyisœ awa akwa. Endje wa agbɔ ngbanga ga pa ye adœke endje wo she. ");
INSERT INTO kxf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yé œ za she fœ angbɨ azu mbœrœ á endje kœmɔ she, á kœsɔ she, á kœkuru she ga pa kurushi, yé manda olo votɔ Ndjaba œ she she lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Awo Zebedayi na ga ndœ Yisu dœ agbolo yakoshe nœ ye bisha, œ gote ga utshu ye mbœrœ kœyɔndœ œrœ bale. ");
INSERT INTO kxf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yisu yu she adœke: «Ɓœ yindœ gaɗe?» Tshe pa fœ Yisu adœke: «Mœ kɨ ga tœ zœ, ɓœ kœgu bala ga lœ ogo tshagbozu nœ zœ, lœ agbolo yakoshe nœ mœ bisha asœke, za anga bale ga tœ kuni zœ, yé anga bale ga tœ gele zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yisu gi adœke: «'E wuwusœ œrœnœ á 'e esho ndœnœ asœmœ nene. Adja 'e li kœndjo ungu lœ yashi nœ œrœ kanga á mœ ndjo bala ye a?» Endje pa fœ Yisu adœke: «'A li dœ tœnœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yisu kœpa fœ endje adœke: «Adjapu, 'e ndjo ungu lœ yashi œrœ kanganœ á mœ ndjo ye. Kashe tœ kœza awa fœ uzu kœsœ ga atɨ ga pa kuni mœ too ga pa gele mœ, asœmœ lili dœ mœ nene. Mbœrœ tœnœ kœdœ osho á sœ fœ endjeneke á Aba mœ guma endje.» ");
INSERT INTO kxf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Udu ayambarœnœ ndjokpa dji o'onœ ataa œ tetœ kœso ókó ga tœ aayazu bisha, Ajake dœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kashe Yisu e endje œ pa fœ endje adœke: «'E wusœ nœ adœke agbozu sœ kœko azu ogo dœ ɔgbɔ ga tshakudu tshagbozu nœ endje, yé agboro azu sœ kœma gbɔgbɔ endje ga pa aaya azu. ");
INSERT INTO kxf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Œ lili adœke œrœ ataa mbœrœtœ endje ɓa ugurutœ 'e nene. Kashe œdœ anga uzu bale kœgbe kœsœ tœ egerœ uzu ugurutœ 'e, œ li adœke tshe fatœ ye tœ ayi akwa nœ 'e yekane. ");
INSERT INTO kxf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yé œdœ anga uzu bale kœyindœ kœsœ utshunœ ugurutœ 'e, œ li adœke tshe dœ kanga nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mbœrœ tœnœ ataa, Gbolo nœ uzu nana adœke azu mbœrœ akwa fœ she nene, kashe tshe na kœmbœrœ akwa fœ azu dœ pe ndje kœzatœ ye fœ kuzu mbœrœ kœshe ukpu azu.» ");
INSERT INTO kxf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lɔkɔ á endje sœ lima kœwuta lœ Yeriko, ukpulu azu te manda Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anga aayibula bisha sœ lima ga atɨ ɨndɨrɨ awa. Kœdji adœke Yisu dá ro asœmœ, endje tetœ kœta rawa adœke: «Gbozu, ata Davidi, wu oyo 'a kane!» ");
INSERT INTO kxf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ukpulu azu sœ lima kœgbagbara endje adœke endje sœ koko, kashe endje kpa ta tshandœ rawanœ dœ agbɔ adœke: «Gbozu, ata Davidi, wu oyo 'a kane!» ");
INSERT INTO kxf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisu ka, œ e endje, yé œ pa fœ endje adœke: «Œrœ gaɗe dá 'e yindœ nœ adœke mœ mbœrœ fœ 'e a?» ");
INSERT INTO kxf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Endje kœpa fœ she adœke: «Gbozu, kolœnœ adœke ala 'a kɔrɔ.» ");
INSERT INTO kxf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yisu wu oyo endje, yé œ goro ala endje. Trale ala endje kɔrɔ ye, yé endje te manda ye. ");
INSERT INTO kxf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lɔkɔ á endje ndo dœ ongbo Yerusaleme œdœ dœ tshalakpɨ Betefaje, ɓa pa gaga á ɨ'ɨrɨnœ kœdœ kaga ɔyɔ Olive, Yisu vwa anga ayambarœ nœ ye bisha utshunœ ");
INSERT INTO kxf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dœ kœpa fœ endje adœke: «'E na ɓa lakpɨ á sœ utshu 'e ɓa e. Kœli 'e tshendja, 'e wu aya ane á endje du she kpœtœmœ dœ ayinœ, 'e vwara she œ gu dœ she fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yé œdœ uzu kœpa o'o fœ 'e; 'e gi fœ she adœke: “Gbozu dá gbe dœ she.” Yé ataa, tshe gi kane ye tœ ye katsha fœ 'e ye.» ");
INSERT INTO kxf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Œ wuta ataa mbœrœ á o'o á ayi kœgbara o'o pa lima kœmbœrœtœ endje. Tshe pa lima adœke: ");
INSERT INTO kxf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«'E pandœ nœ fœ yawuru nœ Siyona adœke: Wu, gbozugo nœ zœ sœ kœna ga ndœ zœ. Tshe sœ kœna ɓata amba uzu. Tshe ɔ ga pa ayi ane, œdœ ga pa ayanœ á tshe dœ aya agea nœ akwa.» ");
INSERT INTO kxf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ayambarœ ro œ mbœrœ œneke á Yisu pa tœnœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Endje gu dœ ayi ane œdœ ayanœ, yé endje ko lœba nœ endje œ guma ga pa endje, á Yisu ɔ á sœ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ukpulu azu ndjoro saka lœba nœ endje ga tœ ala awa; anga endje de lima ganea ɔyɔ, yé œ guma ga tœ awa. ");
INSERT INTO kxf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Azu á endje sœ lima kœna ɓa utshu ye dœ pe endjeneke á endje sœ lima kœna manda ye, sœ lima kœta rawa adœke: «Ozana nœ ata Davidi! Kaka Ndjaba to kane ye ga pa uzu á tshe na dœ ɨ'ɨrɨ Gbozu! Ozana fœ Ndjaba á tshe sœ ɓa lafo!» ");
INSERT INTO kxf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɔlɔ á Yisu li ga lœ Yerusaleme, tshelœ ongbo djigi turu, azu tetœ kœyu osho adœke: «Uzu ɗe dá a?» ");
INSERT INTO kxf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Azu á endje na lima dœ Yisu gi adœke: «Ayi kœgbara o'o Yisu dœmœ, uzu Nazarete, lœ ogo Galilayi.» ");
INSERT INTO kxf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Manda nœ, Yisu li ga lœ Tepelo, yé œ gɔrɔ azu á endje sœ lima kœka œrœ dœ pe endjeneke á endje sœ lima kœyɔ œrœ kɔ ga ushu. Tshe ɨvwɨ ndaba nœ azu kœyapa ngendja, œ geta ngande nœ aayi kœka ambepa. ");
INSERT INTO kxf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yé tshe pa fœ endje adœke: «Endje sú ɓa la buku nœ Ndjaba adœke: “Anda nœ mœ œ dœ bala anda nœ kœza avwala, kashe 'e fa tœ wutu nœ aayi angba!”» ");
INSERT INTO kxf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aayibula dœ pe agbangevweta na ga ndœ Yisu ɓa lœ Tepelo yeka á tshe she endje. ");
INSERT INTO kxf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Agbozu tshapa anganga Ndjaba œdœ pe aayi kœyisœ awa akwa so ókó ndœ kœwu mara œrœ kœza uvuru osho á tshe sœ lima kœmbœrœ tœnœ dœ pe agbolo á endje sœ lima kœta rawa ɓa lœ Tepelo adœke: «Ozana nœ ata Davidi!» ");
INSERT INTO kxf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yé endje pa fœ Yisu adœke: «Ɓœ sœ kœdji œneke á endje pa asœ zœ a?» Kashe Yisu pa fœ endje adœke: «Mœ dji ye, ataa 'e dɨdɨ lima mbetinœ asœmœ nene a? Mbetinœ á pa adœke: “Ɓœ mbœrœ dœ mara adœke œdœ agbolo dœ pe aayi mangɔ donga ɓœ.”» ");
INSERT INTO kxf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Manda nœ, tshe katœ endje lœ ongbonœ asœmœ, œ gu kœlo ɓa lœ Betani. ");
INSERT INTO kxf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Osho kɔrɔ panœ dœ amazɨ, lɔkɔ á tshe sœ kœkwatœ ye ga lœ ongbonœ, ogo mi she. ");
INSERT INTO kxf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tshe wu anga ɔyɔ fige ndoo dœ ama awa, œ na ndoo dœ tœnœ, kashe tshe gbɔgbɔ elenœ bale nene, kolœ kakonœ. Yé tshe pa fœ ɔyɔ figenœ adœke: «Ɓœ kpa le bale nene!» Trale, ɔyɔ figenœ asœmœ ɔrɔ ye. ");
INSERT INTO kxf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kœwu œrœnœ ataa, ayambarœ katœ ama endje tɨ ɔsɔ, yé œ yu Yisu adœke: «Kotoo trale á ɔyɔ fige asœke ɔrɔ ata a?» ");
INSERT INTO kxf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yisu gi fœ endje adœke: «Mœ sœ kœmɨndœ nœ fœ 'e dœ adjapu, œdœ anga ɔlɔ bale á 'e kœsœ dœ kœyindœrœ yé á sœsœ dœ sharapu nene, 'e mbœrœ kolœ œrœ á mœ mbœrœ tœ ɔyɔ fige asœ nene, kashe œdœ 'e kœpa fœ kaga asœ adœke: “Gitœ zœ kpœke dœ́ œ na œ te ga la egerœ ungu adanga”, œ mbœrœ ndje tœ endje liaka nœ. ");
INSERT INTO kxf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Œrœ kɔ á 'e yɔndœ nœ lœ avwala dœ kœyindœrœ, 'e gbɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ɔlɔ á tshe li ga lœ Tepelo, agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia na ga ndœ ye ɔlɔ á tshe sœ kœyisœ œrœ, á yu she adœke: «Ɓœ gbɔ awa kœmbœrœ akwa nœ zœ asœke kpœta a? Œɗe dá za awa kœmbœrœ akwa ata fœ ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yisu gi fœ endje adœke: «Mœ yindœ kœyu 'e dœ o'o bale, œ kœsœ adœke 'e gi o'o fœ mœ gbá yekane á mœ kœyisœ osho á mœ gbɔ awa kœmbœrœ dœ œrœnœ asœ kɔ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Œɗe dá vwa lima Yowane kœza batisimu fœ azu a? Œ dœ lima Ndjaba too azu?» Yé endje tetœ kœmirœtshelœ endje ugurutœ endje yé œ pa adœke: «Œdœ a kœgi fœ she adœke: “Ndjaba dá vwa lima she”, tshe yu azœ adœke: “Mbœrœ gaɗe á 'e yiyi lima ndœ o'o ama ye nene a?” ");
INSERT INTO kxf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yé a kpa pa adœke: “Azu dá vwa lima she”, œ li adœke a kpa awa ukpulu azu, mbœrœ azu para wusœ nœ adœke Yowane kœdœ lima ayi kœgbara o'o.» ");
INSERT INTO kxf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yé á endje gi fœ Yisu adœke: «'A wuwusœ nœ nene.» A Yisu gi fœ endje adœke: «Œmœ ndje awa bale, mœ pa ndje ndœ uzu á tshe za awa nœ kœmbœrœ œrœnœ asœke kɔ fœ 'e nene.» ");
INSERT INTO kxf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«'E gbe œneke adœ gaɗe tœ o'o asœ a? Anga yakoshe sœ dœ agbolo yakoshe bisha. Tshe na ga ndœ ali gbolonœ, œ pa fœ she adœke: “Na kpesheke ga lœ kɨndɨ vinu œ mbœrœ akwa ɓa zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Alinœ gi fœ she adœke: “Œ ngba mœ ye;” manda nœ tshe gbetshelœ ye œ na da ye. ");
INSERT INTO kxf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tshe kpa na ga ndœ bishanœ, œ pa kolœ nœ ata fœ she. Tsheneke asœ gi fœ she adœke: “Mœ na zœ Gbozu”, kashe tshe nana ga zœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Uzu ɗe ugurutœ endje bisha dá mbœrœ gbetshelœ nœ abanœ a?» Endje gi adœke: «Ali gbolonœ.» Á Yisu pa fœ endje adœke: «Dœ adjapu, mœ sœ kœmɨndœ nœ fœ 'e, ayi kœko ngendja lapo dœ pe ayi angba budu œ wuta utshu 'e ga lœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gbambanœ nene, Yowane na lima ndœ kœyisœ awa á sœ ndjii fœ 'e, 'e yiyindœ nœ nene. Kashe aayi kœko ngendja lapo dœ pe aayi angba budu dá yindœ ye. Yé ataa 'e wu gbaa, 'e fafatshalɔsu 'e ndœ kpa kœyindœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«'E kpa dji anga ndœma toro. Anga uzu bale djo kɨndɨ vinu. Tshe tɔ gbadjadja dji tœnœ tshakpata, œ dji kudu mbœrœ kœpu ele vinunœ ga lœnœ, yé œ mɔ anda kœgbɔndœ œrœ ga lœ nœ. Manda nœ, tshe za kɨndɨ nœ fœ aayi akwa kɨndɨ vinu, yé œ na ana. ");
INSERT INTO kxf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɔlɔ kœkɔ ele vinunœ li, tshe vwa anga aayi akwa nœ ye fœ aayi akwa kɨndɨ vinunœ adœke endje vwa œsœ œnœ œne ele vinu nœ fœ œne. ");
INSERT INTO kxf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kashe endje ko aayi akwa nœ ye asœmœ, œ ɓi anga bale, œ wo anga yé œ wo votɔnœ dœ badja. ");
INSERT INTO kxf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tshe kpa vwa anga aayi akwa ndjoro, kœropa endjeneke má utshunœ, endje mbœrœ kolœ nœ fœ endje awa bale. ");
INSERT INTO kxf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tœ ndɔngɔlɔ nœ, tshe vwa gbolo yakoshe nœ ye fœ endje dœ gbetshelœ adœke: “Endje kpa lɨ ndara œsœ ye yé.” ");
INSERT INTO kxf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kashe lɔkɔ á endje wu gbolonœ kœna ga ndœ endje, endje guma o'o lœ ugurutœ endje adœke: “'E wu, gbolonœ á tshe sœpe dœ œrœ manda abanœ dœke. A wo she yeka á kɨndɨnœ kœte œnœ azœ.” ");
INSERT INTO kxf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Endje za she œ vwi she ga ushu lœ kɨndɨ vinunœ yeka á wo she.» ");
INSERT INTO kxf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Ataa, lɔkɔ á ayengɔ kɨndɨnœ kœna, tshe mbœrœ œrœ gaɗe tœ aayi akwa kɨndɨ vinunœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Endje gi fœ she adœke: «Tshe na œ wo aayi akwa kɨndɨnœ kɔ dœ oyo nene yé œ kpa za kɨndɨnœ fœ anga angbɨ aayi akwa á endje li kœko ele vinunœ fœ she liaka olo á tshe gbe dœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yisu kœpa fœ endje adœke: «'E dɨdɨ damba o'onœ asœke ala buku nœ Ndjaba nene a? Endje su adœke: “Badja á ayi kœmɔ anda za vwi'i, tœnœ dá wuta sharagunda. Œ to ɓa ndœ Gbozu, yé œ ga tœ ala 'a waa!”» ");
INSERT INTO kxf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Mœ kpa pa ndje fœ 'e adœke: Endje gi 'e lœ Ogo gbozu nœ Ndjaba, yé œ za fœ angbɨ azu á endje li kœmbœrœ akwa á œrœ tshangbanœ sœ dœ ɔtshɔnœ.  ");
INSERT INTO kxf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uzu á tshe te pa badja asœmœ, tshe kɔ ngende ngende. Yé tsheneke á badja œ te ga pa ye, œ ndɨ tshelœ ye krœna.» ");
INSERT INTO kxf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Manda kœdji o'o asœmœ, agbozu tshapa anganga Ndjaba dœ pe Afarisayi wusœ nœ adœke Yisu sœ kœpa o'o asœ tœ œne. ");
INSERT INTO kxf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Endje para lima awa ndœ kœtepa ye, kashe endje kpa awa ukpulu azu, mbœrœ endje sœ lima kœza she ɓata ayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisu tetœ kœpa 'o fœ endje dœ ndœma toro adœke: ");
INSERT INTO kxf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ogo gbozu nœ tshalafo sœ ɓata anga gbozugo á tshe guma kœzɨrœ angbo totœ nœ gbolo yakoshe nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tshe vwa aayi akwa nœ ye fœ azu á tshe e má endje ndœ angbonœ, kashe endje yiyindœ kœna tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tshe kpa vwa anga angbɨ aayi akwa ndœ kœmɨndœ nœ fœ azu á tshe e endje adœke: “'E na ga mœ ngɔngɔ asœ, mœ guma kœzɨrœnœ ye; mœ wo angombe nœ mœ dœ pe agea ojoro. 'E na ga mœ ndœ angbo totœnœ, œrœ kɔ gumatœ endje ye.” ");
INSERT INTO kxf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kashe azunœ gbegbe dœ angbonœ nene, yé œ na ndœ akwa nœ endje: Anga na ga lœ kɨndɨ, anga na kœpara ngendja nœ ye; ");
INSERT INTO kxf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anga endje tepa aayi akwanœ, á mbœrœ œrœ kanga fœ endje yé á wo endje. ");
INSERT INTO kxf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gbozugo su dœ ókó, œ vwa aturugu nœ ye endje wo azu á endje wo aayi akwa nœ ye, yé œ sho ongbo nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Manda nœ, tshe pa fœ aayi akwa nœ ye adœke: “Mœ guma kœzɨrœ angbo ye, kashe azu á mœ e endje, œ dœ́dœ́ azu á li má adœke mœ e endje dœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'E ro ɓa lœ shangbeda awa, dœ́ œ e azu kɔ á 'e gbɔ endje gu tœnœ ndœ kœzɨrœ.” ");
INSERT INTO kxf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aayi akwanœ asœmœ wuta ga lœ shangbeda awa, œ ngbɔɓa azu kɔ á endje gbɔ endje gu tœnœ: Œdœ aekpe azu, œdœ ɔtshɔ azu. Yé dœ tœnœ ataa, anda angbonœ su kperœ dœ azu. ");
INSERT INTO kxf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Lɔkɔ á gbozugo li ndœ kœwu azu á endje sœ pa ndaba nœ kœzɨrœ, tshe wu anga uzu bale, tshe veverœ lœba angbonœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tshe yu she adœke: “Yanga mœ, ɓœ sœsœ dœ lœba angbo nene, ɓœ li ga mœ koto o?” Tshe gigi o'o nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yé á gbozugo kœpandœ nœ fœ aayi akwa nœ ye adœke: “'E i ada ye dœ kane ye ga tœnœ, œ vwi she ga ushu ɓa lœ ubu osho, osho á azu sœ kœkɨ tœnœ dœ kœzɨ tshelœ daji endje gbagbara gbagbara.” ");
INSERT INTO kxf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Adjapu, endje e azu ndjoro, kashe endjeneke á endje ke endje ngbangba nene.» ");
INSERT INTO kxf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yé Afarisayi ngbɔtœ endje ga tœnœ ndœ kœvwarandœ Yisu adœke œne gbɔ she tœ o'o ama ye. ");
INSERT INTO kxf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Endje vwa anga ayambarœ nœ endje dœ pe azu nœ Erode mbœrœ kœpa fœ Yisu adœke: «Ayi kœyisœrœ, 'a wusœ nœ adœke ɓœ sœ kœpa okporo o'o, ɓœ sœ kœyisœ adja awa Ndjaba, ɓœ sœ ndje kœkatœ zœ tɨ fœ uzu adœke tshe li ga lœ zœ dœ ekpe o'o nene. Ɓœ kpakpa awa uzu nene, œ wuwu ndje tshatshu uzu nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ataa, pandœ gbetshelœ nœ zœ fœ a'a kane: œ li adœke azu yɔ lapo nœ Sezare a, too nene?» ");
INSERT INTO kxf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kashe Yisu wu lima sœ ekpe gbetshelœ nœ endje ye, yé œ pa fœ endje adœke: «Awulapatshɔ, mbœrœ gaɗe á 'e sœ kœyu tshelœma mœ a? ");
INSERT INTO kxf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'E ma anga ngendja bale nœ kœyɔ dœ laponœ gamœ mœ wu kane.» Endje ma anga denarinœ bale fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yisu yu endje adœke: «Tshatshu uzu asœke dœ pe ɨ'ɨrɨ á endje sú asœke kœdœ œnœ ɗe?» ");
INSERT INTO kxf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Endje gi adœke: «Œnœ Sezare». Yé Yisu kœpa fœ endje adœke: «'E gi œrœ nœ Sezare fœ Sezare, œnœ Ndjaba fœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kœdji o'onœ asœmœ ataa, endje katœ ama endje tɨ ɔsɔ, œ katœ ye yé œ ro da ye. ");
INSERT INTO kxf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kolœ dœ ɔlɔnœ asœmœ, anga Asadukayi na ga ndœ Yisu. Endje dá sœ kœpa adœke kœshe lœ akuzu gugu nene. Á endje yu Yisu adœke: ");
INSERT INTO kxf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Ayi kœyisœrœ, Moyize pa adœke, œdœ uzu kœtshu á kœzuzu gbolo nene, ayanœ œ to koyanœ manda ye mbœrœ á tshe kœmbœrœ angwa fœ ayanœ á tshe tshu asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Andaa ɓa ndœ 'a, 'a sœ dœ anga ayazu mindu dœ bisha (7). Alinœ to yashe, œ zuzu gbolo dœ she nene, œ tshu ye; ɓata á endje zuzu lima dœ yashenœ asœmœ nene, tshe katœ ye tɨ fœ ayanœ. ");
INSERT INTO kxf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Œ mbœrœtœ endje awa bale ataa ga tœ bisha ayanœ, ga tœ votɔ ayanœ œrrr ga tœ tshenœ mindu dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Manda endje para, yashenœ kœtshu ye. ");
INSERT INTO kxf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Atamœ, dœ olo kœshe lœ akuzu yashenœ asœmœ œdœ awo ɗe? Mbœrœ endje mindu dœ bisha (7) kɔ to lima she tœ awo endje yema a!» ");
INSERT INTO kxf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yisu gi fœ endje adœke: «'E sœ lœ djingili, mbœrœ 'e wuwusœ buku nœ Ndjaba dœ pe gbɔgbɔ nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ɔlɔ kœshe lœ akuzu, ayakoshe dœ ayashe œ totœ endje nene kashe endje lœ ɓata aandjelu ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Œ kœdœ tœ o'o nœ kœshe lœ akuzu, 'e dɨdɨ o'o á Ndjaba pa fœ 'e ala buku nœ ye nene a? Tshe pa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Œmœ kœdœ Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Ndjaba nœ Yakobo.” Yisu kpa pa adœke, Ndjaba kœdœ Ndjaba nœ asoro kashe tshenœ akuzu nene.» ");
INSERT INTO kxf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kœdji o'onœ ataa, ukpulu azu za lima ama endje tɨ ɔsɔ tœ kœyisœrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lɔkɔ á Afarisayi dji adœke Yisu ngbɔ ama Asadukayi ga tœnœ, endje ngbɔtœ endje ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yé anga ayi kœyisœ awa akwa yu she ndœ kœdji gbetshelœ nœ ye adœke: ");
INSERT INTO kxf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Ayi kœyisœrœ, awa o'o gaɗe dá ropa anganœ lœ awa akwa a?» ");
INSERT INTO kxf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisu gi fœ she adœke: «Œ li adœke ɓœ yindœ Gbozu Ndjaba nœ zœ dœ lɔsu zœ bale, dœ ɨshirɨ zœ kɔ, dœ pe gbetshelœ nœ zœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Asœmœ kœdœ awa o'o á ropa anganœ yé œ sœ ndje dœ ádá waa. ");
INSERT INTO kxf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bisha awa o'onœ á sœ ndje dœ ádá waa awa bale dœke: “Ɓœ yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Awa akwa kɔ œdœ pe aayi kœgbara o'o kɔ to lœ awa o'onœ bisha asœke.» ");
INSERT INTO kxf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afarisayi ngbɔɓa lima tœ endje ga tœnœ yé Yisu yu endje dœ o'o atake: ");
INSERT INTO kxf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«'E gbe má œnœ 'e kotoo tœ upu nœ Masiya a? Œshe kœdœ ata ɗe?» Endje gi fœ she adœke: «Ata Davidi.» ");
INSERT INTO kxf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yisu pa fœ endje adœke: «Koto yeka á ɨshirɨ pa lima fœ Davidi adœke tshe e she “Gbozu” a? Gbambanœ nene, Davidi pa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Gbozu pa fœ Gbozu nœ mœ adœke: na œ sœ ga pa kuni mœ, œrrr ga tœnœ adœke mœ ko ayingba zœ ga tshakudu ada zœ yekane.” ");
INSERT INTO kxf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Œdœ Davidi kœ'e she lima Gbozu ataa, koto á tshe pkpa dœ ata nœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Uzu bale lili lima kœgi o'o fœ she nene. Yé kœto kpœtœ olonœ asœmœ, uzu bale kpa yuyu she dœ o'o nene. ");
INSERT INTO kxf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yé Yisu sœ lima kœpa 'o fœ ukpulu azu dœ pe fœ ayambarœ nœ ye adœke: ");
INSERT INTO kxf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Aayi kœyisœ awa akwa œdœ Afarisayi kœdœ azu á endje sœ mbœrœ kœpandœ awa akwa nœ Moyize. ");
INSERT INTO kxf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ataa, 'e mbœrœtœ 'e lindœ o'o endje yé œ mbœrœ œneke kɔ á endje pa fœ 'e; Kashe 'e zaza angwa kœmbœrœ œrœ nœ endje nene, mbœrœ endje sœsœ kœza œneke á endje sœ kœyisœ nœ ga tœ akwa nene. ");
INSERT INTO kxf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Endje sœ kœi kɨkɨlɨ kongba yé œ sœ kœko ga pa kanga azu; kashe endje dœ tœ endje, endje gogoro bale dœ yɔkɔne endje nene. ");
INSERT INTO kxf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Œrœ kɔ á endje sœ kœmbœrœ tœnœ, endje sœ kœmbœrœ dœ mara adœke azu wusœ œne. Ataa, œnœ endje ndœma lœba á endje sú o'o ama Ndjaba ga tœnœ yé á i ga pa ala endje too ga tœ kane endje sœ tœ egerœnœ. Œnœ endje apara yɔgbɔdɔ lœba sœ kpi tœ œnœ anga endje. ");
INSERT INTO kxf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Endje yindœ kœsœ ɓa utshunœ ɓa tœ osho á œsœnœ lɨ œdœ kœsœ lœ ngande á sœ ɓa utshunœ lœ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Endje yindœ nœ adœke azu bala œne tœ osho angbɔtœ yé œ e œne “Rabi” yekane. ");
INSERT INTO kxf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Kashe e'e, 'e eetœ 'e “Rabi” nene, mbœrœ e'e kɔ kœdœ ayazu, yé 'e sœ dœ Rabi kolœ tshebale. ");
INSERT INTO kxf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'E ee uzu bale pa ɔshɔ asœ “Aba” nene, mbœrœ 'e sœ dœ Aba 'e kolœ tshebale á tshe sœ ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'E yiyindœ nœ adœke endje e 'e “Agbangba kœyisœrœ” nene, mbœrœ 'e sœ kolœ dœ gbangba kœyisœrœ bale á tshe kœdœ Kristu. ");
INSERT INTO kxf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Œ li adœke uzu á tshe dœ egerœ uzu ugurutœ 'e dœ ayi akwa nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uzu á tshe tɨtœ ye ga lafo, endje ku she ga atɨ, yé tsheneke á tshe zatœ ye ga atɨ, endje tɨ she ga lafo.» ");
INSERT INTO kxf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Oyo nœ 'e dœ ayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœtshu manda Ogo gbozu nœ tshalafo utshu azu. E'e dœ tœ 'e, 'e sœsœ kœli ga zœ nene, yé 'e sœ kœkɔ endjeneke á endje gbe ndœ kœli tœnœ, kœli ga zœ.»  ");
INSERT INTO kxf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Oyo nœ 'e dœ aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi; 'e sœ kœpara awa kɔ kœko œrœ á ayashe koya sœ dœ tœnœ kɔ tœ endje, 'e sœ ndje kœza avwala dœ o'o ndjoro mbœrœ kœmatœ 'e. Mbœrœ tœnœ ataa, Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Oyo nœ 'e dœ aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi, 'e sœ kœkɔrɔ na tœnœ djezœ mbœrœ kœpara anga uzu bale adœke tshe fatshalɔsu ye, yé lɔndɔ á 'e mbœrœ á tshe fatshalɔsu ye, 'e kpa sœ kœyi she ga lœ kudu owo nœ lifelo awa bisha kœropa 'e.» ");
INSERT INTO kxf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Oyo nœ 'e, agbozu aayibula! 'E sœ kœpa adœke: “Œdœ uzu kœdarama ye dœ ɨ'ɨrɨ anda Ndjaba, œ sœsœ dœ o'o nene; kashe œdœ uzu kœdarama ye dœ ɨ'ɨrɨ ɔrœ á sœ ɓa lœ anda Ndjaba, dá tshe mbœrœ dœ ɔtshɔnœ.” ");
INSERT INTO kxf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aayi ɨndɨ, aayibula, œrœ gaɗe dá sœ dœ ádá kœropa nœ a: Ɔrœ too Tepelo á mbœrœ adœke ɔrœnœ wuta yerœ a? ");
INSERT INTO kxf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'E kpa sœ kœpa adœke: “Œdœ uzu kœdarama ye dœ ɨ'ɨrɨ ndaba á endje to œrœ ga panœ fœ Ndjaba, œ sœsœ dœ o'o nene; kashe œdœ uzu kœdarama ye tœ tokóró á endje ko ga panœ, dá tshe mbœrœ dœ ɔtshɔnœ.” ");
INSERT INTO kxf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aayibula! Œrœ gaɗe dá sœ dœ ádá kœropa nœ a: Tokóró too ndaba á mbœrœ adœke tokórónœ wuta yerœ a? ");
INSERT INTO kxf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ataa, uzu á tshe dara ama ye dœ ɨ'ɨrɨ ndaba, dá tshe dara ama ye pa ndabanœ œdœ ndje pe pa œrœ kɔ á sœ panœ. ");
INSERT INTO kxf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Uzu á tshe dara ama ye dœ ɨ'ɨrɨ Tepelo, dá tshe dara ndje ama ye dœ ɨ'ɨrɨ Ndjaba á tshe sœ ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Uzu á tshe dara ama ye dœ ɨ'ɨrɨ tshalafo, dá tshe dara ama ye dœ ɨ'ɨrɨ ngande tshagbozu œdœ ndje dœ ɨ'ɨrɨ Ndjaba á tshe sœ panœ.» ");
INSERT INTO kxf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœko bale lœ ndjokpa lœ kako dɔngɔ á tshafunœ ga waa, kashe 'e sœsœ kœmbœrœtœ 'e lindœ awa akwa á sœ dœ ádá waa nene ɓata: Kœsœ ndjii, kœwu oyo azu dœ pe kœyindœrœ. Œrœ á li má adœke 'e za ga tœ akwa dœmœ, yé œ tshapu kœmbœrœ udunœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Agbozu ayibula! 'E sœ kœsa ipi mbœrœ kœwo dœ aya voma, kashe 'e sœ kœmerœ shamo!» ");
INSERT INTO kxf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœdjutɔ tshapa yashi œdœ pe tshapa saani, kashe tshelœnœ su dœ œrœ nœ angba œdœ dœ œrœ nœ ogo ekperœ nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisayi ayibula, djutɔ tshelœ yashi utshunœ yeka á tshapa nœ kœga ndje.» ");
INSERT INTO kxf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ ɓata udu á endje dja tshapanœ dœ imbi ngbeya, á ga kolœ dja ga pa nœ, kashe tshelœnœ su kperœ dœ ngbabi akuzu œdœ dœ tshelœ aka mara ufu œrœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E'e ndje awa bale dja ga ushu, 'e sœ kœmatœ 'e ɓata azu á endje sœ ndjii tœ ala azu, kashe ɓa lœ 'e, e'e kœdœ awulapatshɔ œdœ aayi ngbɨndɨrœ.» ");
INSERT INTO kxf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœmbœrœ ɔtshɔ udu mbœrœ aayi kœgbara o'o, yé œ sœ kœguma tshapadu azu á endje sœ ndjii dœ ambara. ");
INSERT INTO kxf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yé 'e sœ kœpa adœke: “Œdœ 'a kœsœ lima lɔndɔ nœ alata 'a zœ, 'a ngbɔtœ 'a lima dœ endje ndœ kœwo aayi kœgbara o'o nene.” ");
INSERT INTO kxf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ataa, 'e wusœ nœ dœ tœ 'e adœke e'e kœdœ aata azu á endje wo lima aayi kœgbara o'o ye! ");
INSERT INTO kxf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yé ngɔngɔ asœke, 'e te lœ kumu kœmbœrœ udu akwa nœ aata 'e! ");
INSERT INTO kxf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","E'e kœdœ ayakoro, ukpulu akatsha ayakoro! 'E gbe koto kœkpa awa adœke endje wa ngbanga djofele nœ lifelo 'e a? ");
INSERT INTO kxf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mbœrœ tœnœ ataa, mœ sœ kœvwa aayi kœgbara o'o, dœ aayi kœwusœtœ dœ pe aayi kœyisœ awa akwa fœ 'e. 'E wo anga endje, œ kuru anga endje ga pa kurushi, 'e kpa sɔ anga endje dœ ndjapa ɓa lœ Sinagoga nœ 'e œ gɔrɔ endje lœ ongbo dœ ongbo. ");
INSERT INTO kxf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yé indji azu á endje sœ ndjii á tu lima ga pa ɔshɔ asœmœ, sœ ga pa kumu 'e, kœto ɓa tœ indji Abele á tshe sœ ndjii œrrr ga tœ indji Zakariya, gbolo nœ Barashi á 'e wo lima she ɓa ugurutœ œyerœ osho œdœ ndaba lœ anda Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mœ sœ kœpa fœ 'e dœ adjapu adœke: Tshangba œrœnœ asœmœ kɔ œ sœ ga pa kumu 'e dœ azu nœ tshakpesheke asœke!» ");
INSERT INTO kxf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusaleme, Yerusaleme, œɓœ á ɓœ sœ kœwo aayi kœgbara o'o yé á sœ kœve endjeneke á Ndjaba sœ kœvwa endje fœ ɓœ dœ badja, awa ndjoro mœ yi lima ndœ kœngbɔɓa azu nœ zœ ga tœ œsœnœ bale ɓata á ayi ngato œ ngbɔɓa ayanœ ga tshakudu ombo ye, kashe 'e yiyi lima ndœ nœ nene! ");
INSERT INTO kxf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mbœrœ tœnœ ataa, Ndjaba œ gi ala ye pa anda nœ 'e, yé anga œrœ bale kpa gu nene. ");
INSERT INTO kxf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gbambanœ nene, mœ sœ kœpa fœ 'e adœke: Kœto ngɔngɔnœ asœke, 'e kpa wu mœ nene œrrr ga tœ lɔkɔ á 'e pa adœke: “Kaka Ndjaba to kane ye ga pa uzu á tshe na dœ ɨ'ɨrɨ Gbozu.”» ");
INSERT INTO kxf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lɔkɔ á Yisu wuta lima lœ Tepelo á tetœ kœro tœnœ, ayambarœ nœ ye na ndoo dœ she mbœrœ kœma mara á endje mɔ dœ Tepelo. ");
INSERT INTO kxf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yisu za o'o yé œ pa fœ endje adœke: «'E wu œrœnœ asœmœ kɔ? Mœ sœ kœpa dœ adjapu adœke anga badja bale œ kpa ka ga pa anganœ nene; tshelœnœ œ ndɨ para ye.» ");
INSERT INTO kxf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lɔkɔ á Yisu sœ ga atɨ ɓa pa kaga ɔyɔ olive, ayambarœ nœ ye gitœ endje ndoo dœ she ga ɨndɨrɨnœ, yé œ yu she adœke: «Pa fœ 'a kane, dœ ɔlɔ gaɗe dá œrœnœ asœmœ œ mbœrœ má tœ endje a? Yé ambárá gaɗe dá matœ endje dœ olo kœkwa ɓœ œdœ dœ olo kœka tshapashɔ a?» ");
INSERT INTO kxf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yisu gi fœ endje adœke: «Ala 'e gbɔ, uzu bale fafara 'e nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gbambanœ nene, azu ndjoro œ na bala dœ ɨ'ɨrɨ mœ, œ pa adœke: “Œmœ kœdœ Masiya!” Yé endje fara azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɔlɔ á 'e kœdjindœ upu nœ koshe á sœ lœ ondonœ œdœ œneke á sœ lœ ɨngɨrɨnœ, awa zaza 'e nene; œ li adœke œrœ ataa wuta yeka, kashe œ dœ́dœ́ damba kœka tshapashɔ dœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ogo bale œ nga koshe dœ anga ogo, yé ogo gbozu bale œ nga koshe dœ anga ogo gbozu, egerœ ogo œdœ kœturu ɔshɔ œ za osho ngbangbangba. ");
INSERT INTO kxf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Œrœnœ asœmœ kɔ œ sœ bala ɓata ali kœka œrœ á ka yashe utshu kœzu gbolo. ");
INSERT INTO kxf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Azu œ ko 'e bala mbœrœ adœke endje ndanga 'e yé œ wo 'e. Angbɨ azu kɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yé azu ndjoro œ katœ kœyindœrœ nœ endje; endje tɔ gbandatœ endje dœ pe kœyiangbatœ endje ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ayi kœgbara o'o nœ wala œ wuta yé œ djingili tshelœ azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Manda nœ, ngbɨndɨrœ œ gerœ lœ azu, yé kœyindœsho œ gerœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kashe uzu neke á tshe ka ngbɨrɨ œrrr ga tœ ndɔngɔlɔnœ, œshe asœmœ dá she. ");
INSERT INTO kxf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Endje mɨndœ Ɔtshɔ O'o ogo gbozu pa ɔshɔ djigi; angbɨ azu kɔ œ dji yeka á manda nœ á tshapashɔ œ ka.» ");
INSERT INTO kxf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«'E wu bala tsheneke á endje e she “ayi kœndɨ œrœ” á ayi kœgbara o'o Daniyele pa lima tœ ye ɓa tœ œyerœ osho. Kaka tsheneke á tshe dɨ mbetinœ asœke wusœ ádánœ! ");
INSERT INTO kxf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yé œ li adœke endjeneke á endje sœ ɓa lœ ogo Yuda, kpa ga pa kaga. ");
INSERT INTO kxf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tsheneke á tshe kœsœ ɓa pa anda, œ lili adœke tshe jerœ ga atɨ mbœrœ kœko gbarœ nœ ye ɓa sœnda nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tsheneke á tshe kœsœ ɓa lœ kɨndɨ, œ lili adœke tshe kwatœ ye ndœ kœza yɔgbɔdɔ lœba nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Oyo nœ ayashe nguzu œdœ endjeneke á endje sœ kœko ɔngɔ ga lœ ama agbolo dœ olonœ asœmœ! ");
INSERT INTO kxf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'E za avwala fœ Ndjaba mbœrœ á 'e kœkpakpa dœ yapu nœ ɨzɨ too dœ olo sabata nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gbambanœ nene, dœ lɔkɔnœ asœmœ, egerœ oyo œ sœ zœ; œ sœ tœ egerœnœ kœrosœ œneke á endje wu ɓa lima kœto kpœtœ ali kœmbœrœ tshapashɔ œrrr ga tœ ngɔngɔ asœke, yé mara œrœ ataa œ kpa mbœrœtœ endje bale nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Œdœ Gbozu kœgbe má lima tœ kœgi ata olonœ nene, uzu bale œ sœpe má dœ soro nene; kashe mbœrœ endjeneke á tshe ke endje dá tshe kundœ átá olonœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Yé œdœ anga uzu kœpa fœ 'e adœke: “Masiya sœ ɓa ke” too “tshe sœ ɓa e”, 'e yiyindœ nœ fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gbambanœ nene, aekpe masiya œdœ aayi kœgbara o'o nœ wala œ wuta ndjoro. Endje mbœrœ afá yé œ ma ambárá œrœ ndjoro dœ mara adœke œne djingili tshelœ kumu azu. Œdœ œ kœli ndje, endje mbœrœ ndje awa bale fœ endjeneke á Ndjaba ke endje. ");
INSERT INTO kxf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'E dji kane! Mœ va tshelœ utu 'e tœnœ utshunœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Œdœ endje kœpa fœ 'e adœke: “'E wu, tshe sœ ɓa lœ kpagagasho”, 'e nana ga zœ nene. Too œdœ endje kœpa fœ 'e adœke: “'e wu, tshe zatœ ye yiwa tœnœ ɓa ke”, 'e yiyindœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ɓata á yavuru œ yerœwa ɓa lafo, kœto ɓa tœ osho á ɔlɔ œ wuta tœnœ œrrr ga tœ osho á ɔlɔ œ li tœnœ, dœ mara ataa dá Gbolo nœ uzu œ na bala dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Osho á oko uzu sœ tœnœ dá adivumbala œ ngbɔtœ endje ɓa zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Manda kœwu oyo nœ olonœ asœmœ, ɔlɔ œ te ubunœ, yapu œ kpa tɔ nene, angerepe œ to ɓa lafo œ yo ga atɨ, gbɔgbɔ nœ tshalafo œ turu. ");
INSERT INTO kxf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yé ambárá Gbolo nœ uzu œ wuta ɓa lafo; azu kɔ pa ɔshɔ œ dɨtshelœma endje, endje wu Gbolo nœ uzu kœna lœ ondoro dœ gbɔgbɔ djigi œdœ lœ mokɔ. ");
INSERT INTO kxf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tshe vwa bala aandjelu nœ ye ndœ kœ'uru ngbake tœ osho kɔ pa ɔshɔ: Tshe ngbɔɓa bala endjeneke á tshe ke endje tœ osho kɔ ga tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«'E dji ádá kœyisœrœ á to lœ ɔyɔ fige: Lɔndɔ á ganeanœ kœyɔrɔtshelœtœ endje, 'e wusœ nœ adœke yapu kœlu ngwarœ ndo ye. ");
INSERT INTO kxf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Œ sœ ndje atamœ fœ 'e, ɔlɔ á 'e kœwu ndje œrœ ataa kœmbœrœtœ endje, 'e wusœ nœ adœke Gbolo nœ uzu ndo ye, tshe sœ lœ manda 'e. ");
INSERT INTO kxf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mœ sœ kœpa fœ 'e dœ adjapu, azu nœ tshakpesheke, endje tshu kɔ nene á œrœnœ œ mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tshalafo dœ tshapa ɔshɔ œ ro ye, kashe o'o ama mœ œ ro nene.» ");
INSERT INTO kxf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Kashe olonœ œdœ ada ɔlɔnœ asœmœ, uzu bale wuwusœ nœ nene; œdœ aandjelu ɓa lafo, œdœ Gbolo nœ uzu, endje wuwusœ nœ nene, Aba kutɨ ye dá wusœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lɔndɔ nœ kœna Gbolo nœ uzu, œrœ œ mbœrœtœ endje kolœ ɓata mara œrœ á mbœrœ lima tœ endje dœ lɔkɔ nœ Nowa. ");
INSERT INTO kxf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gbambanœ nene, dœ lɔndɔnœ asœmœ, utshu lɔkɔ egerœ kœsu ungu pa ɔshɔ djigi, azu sœ lima kœzɨrœ dœ kœndjorœ, endje sœ lima kœtotœ endje too kœko ayawuru nœ endje ndœ totœ œrrr ga tœ olo á Nowa li lima ga lœ egerœ agba. ");
INSERT INTO kxf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Endje sœsœ lima kœgbe dœ œrœ bale nene œrrr á egerœ kœsu ungu na, á endje tara para kɔkɔ. Œ sœ ndje ataa lɔkɔ á Gbolo nœ uzu œ na bala. ");
INSERT INTO kxf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yé ayakoshe bisha œ sœ ɓa lœ kɨndɨ, endje za anga bale, œ katœ anga tɨ. ");
INSERT INTO kxf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ayashe bisha œ sœ kœtɔ œrœ lœ kafuru, endje za anga bale, œ katœ anga tɨ. ");
INSERT INTO kxf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ataa, ala 'e gbɔ mbœrœ 'e wuwusœ olo neke á Gbozu nœ 'e œ na dœ tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'E wusœ nœ adœke, œdœ ayengɔ anda kœwusœ ada ɔlɔ nœ butshɔ á ayi angba œ na kœzɨ angba œrœ nœ ye, tshe lo olo nene yé tshe katœ ye adœke tshe to ogoro lœ anda nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mbœrœ tœnœ ataa, e'e ndje, ala 'e gbɔ mbœrœ Gbolo nœ uzu œ na dœ ada ɔlɔ neke á 'e wuwusœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ataa, œɗe dá dœ ayi akwa á tshe sœ kœmbœrœtœ ye lindœ o'o gbozu nœ ye, yé á sœ ndje dœ kœwusœrœ á gbozu akwa nœ ye za she tœ kapeta nœ anganœ, mbœrœ kœto kœzɨrœ fœ endje liaka ada ɔlɔ dali a? ");
INSERT INTO kxf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yanga nœ ayi akwanœ asœmœ œdœ gbozunœ kœgu á gbɔ she lœma akwanœ! ");
INSERT INTO kxf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mœ sœ kœpa dœ adjapu fœ 'e: gbozu œ za she tœ kapeta tshapa œrœ nœ ye kɔ. ");
INSERT INTO kxf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kashe œdœ œshe kœdœ ekpe ayi akwa, á pa ɓa lɔsu ye adœke: “Gbozu nœ mœ œ gu katsha nene”, ");
INSERT INTO kxf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yé á tetœ kœɓi aayi akwa anganœ, kœzɨ œrœ dœ pe kœndjo œrœ awa bale dœ aayi kœndjorœ, ");
INSERT INTO kxf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","gbozu nœ ayi akwanœ asœmœ œ gu dœ olo œdœ dœ ada ɔlɔ á ayi akwanœ wuwusœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tshe gɔrɔ ayi akwanœ, œ mbœrœ œrœ kanga nœ awulapatshɔ fœ she, ɓa tœ osho á azu œ kɨ dœ pe kœzɨ tshelœ daji endje gbagbara gbagbara.» ");
INSERT INTO kxf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Yé Ogo gbozu nœ tshalafo sœ ɓata ɔkpɔ ayawuru ndjokpa á endje ko miinda nœ endje, yé á wuta kœna kœtogba dœ yakoshe totœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Anga endje mindu kœdœ aayi ɨndɨ, anga endje mindu kœdœ aayi kœwusœrœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kœko miindanœ, aayi ɨndɨnœ mindu susu lima kada ga lœ œnœ endje nene; ");
INSERT INTO kxf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kashe aayi kœwusœrœnœ mindu su lima kada ga lœ anga á na dœ tœnœ dœ miinda nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɓata œndœ yakoshenœ sœ lima kœdɨ tœnœ waa, olo mbœrœ endje, endje lo para ye. ");
INSERT INTO kxf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Lœ ɔgbɔ butshɔ, anga uzu bale tetœ rawa adœke: “'E wu, yakoshenœ dá yi kumu ye asœ; 'e wuta ndœ ye.” ");
INSERT INTO kxf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ɔkpɔ ayawurunœ kœjo para yé kœtetœ kœguma miinda nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aayi ɨndɨnœ kœpa fœ ayi kœwusœrœ adœke: “'E su anga kada nœ 'e fœ 'a mbœrœ œnœ 'a miindanœ sœ kœru tœnœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aayi kœwusœrœ kœgi fœ endje adœke: “Œ ngba 'a ye, œ gegerœ yeka á 'a kœsu mbœrœ 'a œdœ fœ 'e nene. 'E na œ yɔ œne 'e ɓa ndœ aayi kœka œrœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lɔndɔ á aayi ɨndɨnœ ro kœyɔ kadanœ ga zœ atake, yakoshe totœnœ yi kumu ye. Akpɔ ayawuru mindu á endje guma má tœ endje yindjindjinœ asœmœ, li dœ she ga sœnda angbo totœnœ, yé endje kœtshu mandanœ ga tœnœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Œndœnœ dɨ manda nœ, ɔkpɔ ayawuru ɨndɨnœ gu œ tetœ kœ'e osho adœke: “Gbozu, gbozu, kɔrɔ manda fœ 'a ka!” ");
INSERT INTO kxf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kashe tshe gi adœke: “Mœ sœ kœpa dœ adjapu fœ 'e adœke, mœ wuwusœ 'e nene.” ");
INSERT INTO kxf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Atamœ, ala 'e gbɔ, mbœrœ 'e wuwusœ olo dœ pe ada ɔlɔ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Œ sœ bala ɓata anga yakoshe á tshe yi lima ndœ kœna ana: Tshe e aayi akwa nœ ye œ katœ œrœ nœ ye fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tshe ko fœ anga talata mindu, anga talata bisha, fœ votɔnœ talata bale: Tshe ko fœ uzu dœ uzu liaka gbɔgbɔ nœ ye. Manda nœ, tshe ro daye. ");
INSERT INTO kxf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ayi akwa á tshe gbɔ talata mindu gu œ za ga tœ akwa, yé œ kpa gbɔ anganœ mindu ga panœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tsheneke á tshe gbɔ talata bisha mbœrœ ndje awa bale, yé œ kpa gbɔ talata bisha ga panœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kashe tsheneke á tshe gbɔ talata bale, gu œ dji kudu ɓa lœ ɔshɔ, yé œ za talata bale nœ gbozu akwa nœ ye yiwa tœnœ ga lœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Œndœnœ kœdɨ œrrr manda nœ, gbozu nœ aayi akwanœ asœmœ gu, yé œ tetœ kœyu endje tœ akwa á tshe ka lima tœnœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsheneke á tshe gbɔ lima talata mindu gitœ ye ndoo, œ pa adœke: “Gbozu, wu, ɓœ ko lima talata mindu fœ mœ. Anganœ mindu á mœ gbɔ ga panœ dœke.” ");
INSERT INTO kxf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Gbozu nœ ye pa fœ she adœke: “Œ sœ dœ ɔtshɔnœ, œɓœ kœdœ ɔtshɔ ayi akwa yé ɓœ mbœrœtœ zœ lindœ nœ. Ɓata á ɓœ mbœrœtœ zœ lindœ nœ lœ aya akwa ataa, mœ za ɓœ ga pa egerœnœ. Na ga mœ œ sœ dœ yanga awa bale dœ gbozu nœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsheneke á tshe gbɔ lima talata bisha na ndje œne ye, yé œ pa adœke: “Gbozu, ɓœ ko lima talata bisha fœ mœ. Anganœ bisha á mœ gbɔ ga panœ dœke.” ");
INSERT INTO kxf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gbozu nœ ye pa fœ she adœke: “Œ sœ dœ ɔtshɔnœ, œɓœ kœdœ ɔtshɔ ayi akwa yé ɓœ mbœrœtœ zœ lindœ nœ. Ɓata á ɓœ mbœrœtœ zœ lindœ nœ lœ aya akwa ataa, mœ za ɓœ ga pa egerœnœ. Na ga mœ œ sœ dœ yanga awa bale dœ gbozu nœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Tsheneke á tshe gbɔ lima talata bale kœna, yé á kœpa œnœ ye adœke: “Gbozu, mœ wu lima sœ nœ adœke œɓœ kœdœ gbozu á ɓœ ngaanga: Ɓœ sœ kœkɔ ngwarœ á œ dœ́dœ́ ɓœ dá lu nene, ɓœ sœ kœkɔ ngwarœ ɓa tœ osho á ɓœ lulu œrœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Awa za mœ, yé á mœ na á za talata nœ zœ yiwa tœnœ ga lœ ɔshɔ. Wu, œrœ nœ zœ dœke.” ");
INSERT INTO kxf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kashe gbozu nœ ye gi fœ she adœke: “Ekpe ayi akwa, ayi ɔdɔ! Ɓœ wu lima sœ nœ adœke mœ sœ kœkɔ ngwarœ á œ dœ́dœ́ mœ dá lu nene, mœ sœ kœkɔ ngwarœ ɓa tœ osho á mœ lulu œrœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ataa, œ li má adœke ɓœ ko ngendja nœ mœ ga lœ anda kœgumasœ ngendja, yé á mœ kœgu má atake, á kœgbɔ anga œrœ nœ mœ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'E za talatanœ asœmœ bale tœ ye, yé œ za fœ tsheneke á tshe sœ dœ tœnœ ndjokpa asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gbambanœ nene, uzu kɔ á tshe sœ dœ œrœ ndjoro, endje to anganœ ga panœ fœ she. Tsheneke á tshe gugu dœ œrœ nene, endje ko œneke teasho á tshe sœpe dœ tœnœ, tœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tœ ayi akwanœ á ádá ye gugu nene asœ, 'e vwi she ga lœ ubu osho ɓa shu: Ɓa zœ kœdœ kolœ ɨkɨ œdœ kœ zɨ tshelœ daji gbagbara gbagbara.”» ");
INSERT INTO kxf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Lɔkɔ á Gbolo nœ uzu œ na bala lœ mokɔ nœ ye dœ aandjelu para, tshe sœ ɓa pa ngande tshagbozu nœ mokɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Azu ogo kɔ pa ɔshɔ œ ngbɔtœ endje ɓa utshu ye, yé tshe kurutshelœ azu dœ azu ɓata á ayi kœgbɔndœ ayarœ œ kurutshelœ apata dœ ayaburu. ");
INSERT INTO kxf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tshe ko apata ga tœ kuni ye, yé œ ko ayaburu ga tœ gele ye. ");
INSERT INTO kxf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yé gbozugo œ pa fœ endjeneke á endje sœ ga tœ kuni ye adœke: “'E na ga mœ, e'e á Aba mœ to kane ye ga pa 'e. 'E li ga lœ ogo tshagbozu á endje guma ɓa lima sœ nœ fœ 'e, kœtotœ kœmbœrœ tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gbambanœ nene, mœ sœ lima dœ ogo yé 'e to kœzɨrœ fœ mœ; mœ sœ lima dœ ogo ungu yé 'e su ungu fœ mœ; mœ dœ lima gene yé 'e za osho kœsœ fœ mœ; ");
INSERT INTO kxf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mœ sœ lima kpendronœ yé 'e za lœba fœ mœ; mœ sœ lima dœ koɓa yé 'e na ndœ kœtɨtœ mœ; mœ sœ lima lœ anda kánga yé 'e na kœwu mœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Yé azu á endje sœ ndjii gi fœ she adœke: “Gbozu, lɔkɔ gaɗe á 'a wu lima ɓœ dœ ogo yé á to kœzɨrœ fœ ɓœ a, dœ ogo ungu yé á su ungu fœ ɓœ a? ");
INSERT INTO kxf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lɔkɔ gaɗe á 'a wu lima ɓœ tœ gene yé á za osho kœsœ fœ ɓœ a? Lɔkɔ gaɗe dá 'a wu lima ɓœ kpendronœ yé á za lœba fœ ɓœ a? ");
INSERT INTO kxf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lɔkɔ gaɗe dá 'a wu lima ɓœ dœ koɓa too lœ anda kánga yé á 'a na kœwu ɓœ a?” ");
INSERT INTO kxf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yé gbozugo œ gi fœ endje adœke: “Mœ sœ kœpa fœ 'e dœ adjapu adœke: Ɔlɔ kɔ á 'e sœ lima kœmbœrœ œrœnœ asœmœ fœ anga aaya lœ aaya mœ á œsœ endje lɨlɨ nene, œmœ dá 'e sœ lima kœmbœrœ tœnœ fœ mœ asœmœ.” ");
INSERT INTO kxf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Manda nœ, tshe pa bala fœ endjeneke á endje sœ ga pa gele ye adœke: “'E gitœ 'e zara tœ mœ, e'e dœ azu á endje darandœ 'e! 'E na œ yo ga la owo á ru nene, á endje guma fœ djaboro dœ aandjelu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gbambanœ nene, mœ sœ lima dœ ogo yé 'e toto kœzɨrœ fœ mœ nene; mœ sœ lima dœ ogo ungu yé 'e susu ungu kœndjo tœnœ fœ mœ nene; ");
INSERT INTO kxf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mœ na lima tœ gene yé 'e zaza osho kœsœ fœ mœ nene; mœ sœ lima kpendronœ yé 'e zaza lœba fœ mœ nene; mœ sœ lima dœ koɓa yé 'e nana œ tɨtœ mœ nene; mœ sœ lima lœ anda kánga yé 'e nana œ wu mœ nene.” ");
INSERT INTO kxf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yé endje ndje, endje gi bala adœke: “Gbozu, ɔlɔ gaɗe dá 'a wu lima ɓœ dœ ogo too dœ ogo ungu, tœ gene too kpendronœ a, dœ koɓa too lœ anda kánga yeka á gbegbe lima dœ ɓœ nene a?” ");
INSERT INTO kxf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yé tshe gi bala fœ endje adœke: “Mœ sœ kœpa fœ 'e dœ adjapu, ɔlɔ dœ ɔlɔ á 'e mbœmbœrœ lima œrœnœ asœmœ fœ anga aya bale ugurutœ aaya mœ á œsœ endje lɨlɨ nene, 'e mbœmbœrœ ndje lima fœ mœ nene.” ");
INSERT INTO kxf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yé endjeneke œ li bala ga lœ djofele neke á ka nene. Andaa, azu á endje sœ ndjii œ li bala ga lœ soro nœ waa dœ waa.» ");
INSERT INTO kxf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lɔkɔ á Yisu mɨndœ upunœ asœmœ kɔkɔ ye, tshe pa fœ ayambarœ nœ ye adœke: ");
INSERT INTO kxf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«'E wusœ nœ adœke œ sœpe olo bisha kœwuta ga tœ angbo nœ pake: Endje za Gbolo nœ uzu yɔ œrœ ndœ kœkuru she ga pa kurushi.» ");
INSERT INTO kxf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yé agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia ngbɔtœ endje ɓa sœnda nœ egerœ nganga Ndjaba á ɨ'ɨrɨ ye kœdœ Kayifa. ");
INSERT INTO kxf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Endje djitœ endje yé œ wa adœke œne frandœ Yisu œ tepa ye yeka á kœ wo she. ");
INSERT INTO kxf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Endje sœ lima kœpa adœke: «Œ lili adœke a za she dœ lɔndɔ angbonœ nene, ete nene azu œ oma ye.» ");
INSERT INTO kxf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lɔkɔ á Yisu sœ lima ɓa lœ Betani ɓa sœnda nœ ayi boroma Shimu, ");
INSERT INTO kxf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","anga yashe bale na dœ yombo nœ ye lœ anga á endje mbœrœ dœ albatre, ama yombonœ gbɔ waa. Tshe su yombonœ ga lœ kumu Yisu lɔndɔ á tshe sœ pa ndaba kœzɨ œrœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lɔkɔ á ayambarœ nœ ye wu ataa, endje sœ dœ ekpe lɔsu yé œ pa adœke: «Mbœrœ gaɗe á tshe ndɨ ungu yombonœ asœ ataa? ");
INSERT INTO kxf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Œ li má adœke endje ka yombonœ asœmœ dœ amanœ tœ ɔgbɔnœ yé œ kurutshelœ ngendjanœ tœ aayi oyo.» ");
INSERT INTO kxf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisu wusœ nœ lima adœke endje sœ kœpa ataa, yé œ pa fœ endje adœke: «Mbœrœ gaɗe á 'e sœ kœndanga yashenœ asœke a? Œrœ á tshe mbœrœ fœ mœ kœdœ ɔtshɔrœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gbambanœ nene, 'e sœ tœ œsœnœ dœ aayi oyo ɔlɔ dœ ɔlɔ. Kashe œmœ, 'e sœ dœ mœ awa bale waa nene. ");
INSERT INTO kxf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tshe su yombonœ asœmœ kpɔɔ ga tœ ɔkɔ mœ mbœrœ kœguma mœ ndœ kœshi mœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mœ sœ kœpa dœ adjapu fœ 'e adœke: Osho kɔ á endje pandœ Ɔtshɔ O'onœ asœke tœnœ pa tshapashɔ djigi, endje pandœ œrœ á yashe asœke mbœrœ, yé endje gbe dœ she.» ");
INSERT INTO kxf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yé anga yambarœ bale lœ andjokpa dœ bisha á ɨ'ɨrɨ ye kœdœ Yudasi Isikariote, na ga ndœ agbozu tshapa anganga Ndjaba, ");
INSERT INTO kxf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yé œ pa fœ endje adœke: «Œrœ gaɗe dá 'e za fœ mœ œdœ mœ kœza she yɔ œrœ fœ 'e a?» Endje dɨ langere ngendja zazu bale dœ ndjokpa (30), yé á ko fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kœto pe dœ lɔkɔnœ asœmœ, Yuda tetœ kœpara awa ndœ kœza Yisu fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dœ ali olo nœ angbo nœ mapa á susuku nene, ayambarœ na kœyu Yisu adœke: «Ɓœ yindœ nœ adœke 'a guma kœzɨrœ nœ pake fœ ɓœ kpœta a?» ");
INSERT INTO kxf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tshe pa fœ endje adœke: «'E na ɓa ndœ anga uzu bale lœ ongbo yé œ pa fœ she adœke: “Gbozu pa adœke: Ada ɔlɔ nœ mœ li ye; mœ mbœrœ angbo pake dœ ayambarœ nœ mœ ɓa ndœ zœ.”» ");
INSERT INTO kxf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ayambarœnœ mbœrœ ɓata á tshe pa tœnœ fœ endje, yé œ guma œrœ angbo Pakenœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lɔkɔ á ɔlɔ dɨ, Yisu sœ pa ndaba kœzɨrœ dœ ayambarœ ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lɔndɔ á endje sœ kœzɨrœ, tshe kœpa adœke: «Mœ sœ kœpa fœ 'e dœ adjapu, anga yanga 'e bale œ za mœ yɔ œrœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oyo kœza endje, endje kœtetœ kœyu she uzu dœ uzu adœke: Œ dœ mœ a, Gbozu? ");
INSERT INTO kxf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tshe kœgi adœke: «Œshe á tshe ngbɔ kane ye lœ gbarœ kœzɨrœ awa bale dœ mœ asœmœ, œshe dá za mœ yɔ œrœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gbolo nœ uzu œ tshu ɓata á endje sú lima ala buku nœ Ndjaba tœ upu nœ ye. Kashe oyo nœ uzu á tshe za Gbolo nœ uzu yɔ œrœ. Œ sœ má dœ ɔtshɔnœ mbœrœ uzunœ adœke adja endje zuzu she nene!» ");
INSERT INTO kxf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi, á tshe sœ kœza she yɔ œrœ, za o'o œ pa adœke: «Œdœ mœ a, Gbozu?» Yisu gi fœ she adœke: «Œɓœ dœ tœ zœ ɓœ pa ye.» ");
INSERT INTO kxf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dœ lɔndɔ kœzɨ œrœ, Yisu za mapa œ donga Ndjaba, œ kavwa tshelœnœ, œ ko fœ ayambarœ nœ ye, yé œ pa adœke: «'E ko œ zɨ, asœ kœdœ undu mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Manda nœ, tshe za ndje yashi vinu, œ donga Ndjaba, yé œ za fœ endje dœ kœpa adœke: «E'e kɔ 'e ndjo, ");
INSERT INTO kxf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mbœrœ asœke kœdœ indji mœ, indji á guma ayo ugurutœ Ndjaba dœ azu, indji á tu mbœrœ azu ndjoro œdœ mbœrœ kœdjerœndœ ekperœ nœ azu. ");
INSERT INTO kxf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mœ sœ kœpa dœ adjapu fœ 'e adœke, mœ kpa ndjo vinu nene œrrr ga tœ lɔkɔ á mœ ndjo bala tafonœ dœ 'e ɓa lœ Ogo gbozu nœ Aba mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Manda kœdonga Ndjaba dœ itshi, endje wuta ndœ kœɔ ga pa kaga ɔyɔ Olive. ");
INSERT INTO kxf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yé Yisu kœpa fœ endje adœke: «Lœ butshɔ asœ, e'e kɔ 'e katœ mœ tɨ ye. Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Mœ ɓi bala ayi kœgbɔndœ apata, yé ukpulu apatanœ œ ndjɔtshelœtœ endje.” ");
INSERT INTO kxf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kashe, Yisu kpa pa adœke: Lɔkɔ á Ndjaba kœshe mœ lœ kuzu, mœ na utshu 'e ga lœ Galilayi.» ");
INSERT INTO kxf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro za o'o œ pa fœ she adœke: «Œdœ azu kɔ kœkatœ zœ tɨ, œmœ, mœ katœ zœ tɨ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yisu gi fœ she adœke: «Mœ pa fœ ɓœ dœ adjapu adœke, dœ butshɔnœ asœke utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro pa fœ she adœke: «Œdœ œ kœsœ adœke a tshu dœ ɓœ, mœ 'ea ɓœ bale nene.» Yé ayambarœnœ kɔ pa ndje awa bale. ");
INSERT INTO kxf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisu wuta dœ ayambarœ nœ ye ɓa tœ anga osho á endje e ɨ'ɨrɨnœ Getesemane, yé á pa fœ endje adœke: «'E sœ ga atɨ kpœke, mœ sœ kœna kœza avwala ɓa 'e.» ");
INSERT INTO kxf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tshe za Petro œdœ agbolo yakoshe nœ Zebedayi bisha á na dœ endje. Tshe tetœ kœgbɔ oyo tœ lɔsu ye, yé awa li she gɔrɔ. ");
INSERT INTO kxf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yé á tshe kœpa fœ endje adœke: «Lɔsu mœ su kperœ dœ oyo nœ kuzu. 'E sœ kpœke yé œ lolo nene awa bale dœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tshe gitœ ye zara œ te dœ tshatshu ye ga tœ ɔshɔ, œ za avwala adœke: «Aba mœ, œdœ œ kœli, gi yashi œrœ kanganœ asœke zara tœ mœ ye. Œ sœsœ adœke ɓœ mbœrœ œneke á mœ yindœ nœ nene, kashe mbœrœ ɓata á ɓœ yindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Manda nœ, tshe gu ga ndœ ayambarœ yé œ gbɔ endje lœ olo. Tshe pa fœ Petro adœke: «Shimu, 'e sœsœ dœ gbɔgbɔ kœsœ dœ uburu ala 'e awa bale dœ mœ manda ada ɔlɔ bale nene a? ");
INSERT INTO kxf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'E lolo nene yé œ za avwala mbœrœ adœke 'e yoyo ga lœ kœwu lɔsu nene. Ɨshirɨ uzu su dœ gbɔgbɔ, kashe undu ye gugu dœ gbɔgbɔ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tshe kpa gitœ ye zara tœ bishanœ kœza avwala dœ kœpa adœke: «Aba mœ, œdœ œ kœli, za yashi œrœ kanganœ asœke adœke mœ ndjondjo nene. Kaka ɓœ mbœrœ ɓata á ɓœ yindœ nœ!» ");
INSERT INTO kxf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tshe kpa gu ga ndœ ayambarœ nœ ye, œ gbɔ endje kolœ lœ olo, mbœrœ ala endje sœ lima dœ kɨkɨlɨnœ, awa kœkɔrɔ tœnœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tshe kpa gitœ ye, yé œ za avwala tœ votɔnœ kolœ dœ kœpa tshetœ o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Manda nœ, tshe kpa gu ga ndœ ayambarœ œ pa fœ endje adœke: «'E sœpe kœlo tœnœ œdœ pe kœyatœ 'e! Ngɔngɔnœ asœke, ada ɔlɔ á endje za Gbolo nœ uzu ga tshakane aayi kœmbœrœ ekperœ li ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","'E alafo, a na zœ. Ayi kumu mœ á tshe za mœ ga tshakane endje na ye.» ");
INSERT INTO kxf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu sœpe kœpa o'o kolœnœ atake, Yudasi, anga yambarœ bale lœ andjokpa dœ bisha yi kumu ye. Tshe na awa bale dœ ukpulu azu ndjoro dœ ɨngɨrɨ yakamba œdœ pe ndɨndɨ ɔyɔ tshakane endje. Agbozu tshapa anganga Ndjaba œdœ agbozu Ikrizia dá vwa endje. ");
INSERT INTO kxf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uzu á tshe za Yisu ga tshakane endje yi lima œsœ ambárá œrœ adœke: «Uzu á mœ kœ'uru tshelœ utu ye, dá œshe dœmœ; 'e za she.» ");
INSERT INTO kxf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Trale atake, Yudasi wuta œ na ga ndœ Yisu á pa fœ she adœke: «Abala, Rabi!» Manda nœ, tshe 'uru tshelœ utu ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yisu pa fœ she adœke: «Yanga mœ, mbœrœ œrœ á ɓœ gbe dœ tœnœ.» Yé azunœ tepa ye, á za she. ");
INSERT INTO kxf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anga bale lœ ugurutœ endje á endje na dœ Yisu gbota ɨngɨrɨ yakamba nœ ye á de anga ayi akwa nœ egerœ nganga Ndjaba, yé á wa utu ye ndja tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Á Yisu pa fœ she adœke: «Gi ɨngɨrɨ yakamba nœ zœ ga mangbanœ, mbœrœ azu kɔ á endje nga koshe dœ ɨngɨrɨ yakamba, endje tshu kolœ kuzu nœ ɨngɨrɨ yakamba. ");
INSERT INTO kxf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɓœ wuwusœ nœ adœke œdœ mœ kœyɔndœ azu ɓa ndœ Aba mœ, tshe vwa ngɔngɔnœ asœ ukpulu aandjelu kœro pa ndjokpa dœ bisha fœ mœ adœke endje tɨ kane mœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kashe, tœ œneke, dœ mara gaɗe dá o'o ala buku nœ Ndjaba li kœmbœrœtœ endje lindœnœ adœke œ sœ ataa.» ");
INSERT INTO kxf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dœ ada ɔlɔnœ asœmœ, Yisu pa fœ ukpulu azu adœke: «'E na kœza mœ dœ ɨngɨrɨ yakamba œdœ pe dœ ndɨndɨ ɔyɔ, ɓata œmœ kœdœ ayi angba a? Ɔlɔ dœ ɔlɔ, mœ sœ lima kœsœ ga atɨ ɓa lœ Tepelo kœyisœ œrœ, yé 'e zaza lima mœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kashe œneke kɔ wuta mbœrœ á o'o aayi kœgbara o'o pa lima kœmbœrœtœ endje.» Yé, ayambarœ kɔ katœ ye tɨ, œ kpa ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Endje á endje za lima Yisu, gu dœ she ɓa ndœ Kayifa, egerœ nganga Ndjaba á aayi kœyisœ awa akwa œdœ ndje dœ agbozu Ikrizia ngbɔtœ endje ɓa ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro sœ lima kœna manda Yisu yima yima lœ ɨngɨrɨnœ œrrr ɓa lœ gbagba nœ egerœ nganga Ndjaba. Tshe li ga zœ œ sœ ga ɨndɨrɨ aayi akwa ndœ kœwu mara á o'onœ œ ka dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Andaa, agbozu tshapa anganga Ndjaba dœ pe aayi kœwa ngbanga nœ azu nœ Ndjaba kɔ, lœ lima kœpara awa adœke œne gbɔ anga uzu á tshe kœpa anga ekpe o'o goro œsœ Yisu yeka á œne kœgbɔ awa kœwa ngbanga nœ kuzu ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kashe ataa aayi kœpa ekpe o'onœ ma lima tœ endje ndjoro gbaa, endje gbɔgbɔ œrœ bale nene. Kwata œrrr, anga endje bisha matœ endje ");
INSERT INTO kxf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yé œ pa adœke: «Uzunœ asœ pa adœke: “Mœ li kœndɨ tshelœ Tepelo nœ Ndjaba yé œ mɔ ga mangbanœ manda olo votɔ.”» ");
INSERT INTO kxf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Egerœ nganga Ndjaba álafo œ pa fœ she adœke: «Ɓœ gugu dœ o'o kœgi tœnœ tœ œneke kɔ á azu asœ pa ga pa zœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kashe Yisu sœ lima kokoko. Yé egerœ nganga Ndjabanœ kœyu she adœke: «Mœ sœ kœyu ɓœ, ɓœ dara ama zœ dœ ɨ'ɨrɨ Ndjaba nœ soro: Œɓœ kœdœ Masiya Gbolo nœ Ndjaba a?» ");
INSERT INTO kxf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yisu gi fœ she adœke: «Ɓœ pa dœ tœ zœ ye. Kashe mœ sœ kœpa ngbɨ fœ 'e adœke: Kœto ngɔngɔnœ asœ, 'e wu Gbolo nœ uzu kœsœ ga atɨ ga tœ kuni Ndjaba nœ gbɔgbɔ kɔ; 'e wu ndje she kœjerœ ɓa pa ondoro ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yé egerœ nganga Ndjaba suru tshelœ lœba tœ ye œ pa adœke: «Tshe gu œsœ Ndjaba! A kpa gbegbe dœ atimu nene! 'E totœ kœdji kœgu osho á tshe gu tœ Ndjaba ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'E gbe má œne 'e tœnœ kotoo?» Endje gi adœke: «Tshe li dœ kuzu.» ");
INSERT INTO kxf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Manda nœ, endje tetœ kœtu ngusha ga tshatshu ye œ sœ kœdu she, yé anga endje sœ kœda ala ye. ");
INSERT INTO kxf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Endje pa fœ she adœke: «Masiya, œdœ ɓœ kœdœ ayi kœgbara o'o, pandœ nœ fœ 'a: Œɗe dá ɓi ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Andaa Petro sœ lima ga atɨ ɓa ushu ɓa lœ gbagba, anga yashe akwa na ndoo dœ she yé œ pa fœ she adœke: «Œɓœ ndje, ɓœ sœ lima awa bale dœ Yisu uzu Galilayi!» ");
INSERT INTO kxf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kashe tshe vusœ nœ utshu azu kɔ dœ kœpa adœke: «Mœ wuwusœ o'onœ á ɓœ yindœ kœpa tœnœ asœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɓata á tshe sœ lima kœna gu ndœ œsœ manda gbagbanœ, anga angbɨ yashe akwa kpa wu she yé œ pa fœ azu á endje sœ lima kpœtœmœ adœke: «Uzu asœ sœ lima awa bale dœ Yisu uzu Nazarete.» ");
INSERT INTO kxf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petro kpa vusœ nœ dœ kœdarama ye adœke: «Mœ wuwusœ uzunœ asœke nene.» ");
INSERT INTO kxf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Manda nœ teasho, azu á endje sœ lima kpœtœmœ gitœ endje ndoo dœ Petro, yé œ pa fœ she adœke: «Adja, œɓœ kœdœ anga uzu nœ endje, yé o'o zœ sœ kœma ɓœ ataa.» ");
INSERT INTO kxf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yé Petro tetœ kœdarama ye dœ kœpa o'o adœke: «Kaka Ndjaba za djofele fœ mœ œdœ mœ kœpa wala! Mœ wuwusœ uzunœ asœke nene.» Ngbewo, kɔngato kɨ. ");
INSERT INTO kxf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yé Petro gbetshelœ ye ndœ o'onœ á Yisu pa lima fœ she adœke: «Utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ adœke ɓœ wuwusœ mœ nene.» Tshe wuta ga ushu, yé kɨ dœ oyo. ");
INSERT INTO kxf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dœ amazɨ tuu, agbozu tshapa anganga Ndjaba kɔ dœ pe agbozu Ikrizia ngbɔtœ endje ga tœnœ kœwa o'o ndœ kœwo Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Manda nœ, endje i Yisu ga tœnœ, œ na dœ she yé á za she fœ gbozugo á ɨ'ɨrɨ ye kœdœ Pilato. ");
INSERT INTO kxf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudasi á tshe za she yɔ œrœ, wu adœke endje wa ngbanga ndœ kœwo Yisu, egerœ gbetshelœ za she, tshe kwa œ gi langere ngendjanœ zazu bale dœ ndjokpa fœ agbozu tshapa anganga Ndjaba dœ pe fœ agbozu Ikrizia, ");
INSERT INTO kxf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","yé á pa fœ endje adœke: «Mœ mbœrœ ekperœ, mœ za uzu á tshe mbœmbœrœ ekperœ nene fœ kuzu.» Kashe endje gi fœ she adœke: «'A sœsœ lœnœ nene! Tœnœ kœdœ o'o nœ zœ!» ");
INSERT INTO kxf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi ko ngendjanœ va ga lœ Tepelo, yé á na kœdu uwu ga lœ ɨgɨ ye ndœ kœwotœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Agbozu tshapa anganga Ndjaba rɔ ngendjanœ yé á pa adœke: «Awa akwa nœ azœ yiyindœ nœ adœke a ko mara ngendja ataa ga ugurutœ kœgbɔrœ nœ Tepelo nene, mbœrœ tœnœ á to lœ ngendja indji uzu.» ");
INSERT INTO kxf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Manda kœdjitœ endje, endje za œ yɔ dœ kɨndɨ nœ ayi kœmbœrœ lɔsú mbœrœ kœza tœ tshapa udu nœ agene. ");
INSERT INTO kxf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mbœrœ tœnœ ataa œrrr ga tœ kpesheke, ɨ'ɨrɨ kɨndɨnœ asœmœ kœdœ: «Kɨndɨ indji uzu.» ");
INSERT INTO kxf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yé œ mbœrœtœ endje ataa mbœrœ o'o á ayi kœgbara o'o Yilimiya pa lima kœmbœrœtœ endje, tshe pa adœke: «Endje za ngendja zazu bale dœ ndjokpa, œtœnœ kœdœ ama ngendja á agbolo Israyele wa lima tœ upu nœ ye; ");
INSERT INTO kxf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yeka á endje za ndœ kɨndɨ nœ ayi kœmbœrœ lɔsú, ɓata á Gbozu vwa lima mœ ndœ kœpandœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisu ka ɓa utshu gbozugo á ɨ'ɨrɨ ye kœdœ Pilato. Gbozugo yu she adœke: «Œɓœ kœdœ gbozugo nœ Ayuda a?» Yisu gi fœ she adœke: «Œɓœ dá sœ kœpa ataa.» ");
INSERT INTO kxf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kashe o'o á agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia sœ kœpa ga pa ye, tshe gigi lima o'o nene. ");
INSERT INTO kxf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato pa fœ she adœke: «Ɓœ djidji o'o á endje sœ kœpa ga pa zœ asœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tshe gigi lima o'o ndœ nœ bale nene, yé gbozugo za lima ama ye tɨ ɔsɔ. ");
INSERT INTO kxf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dœ lɔndɔ angbo Pake bale dœ bale kɔ, gbozugo sœ lima kœvwara anga ayi kánga bale á ukpulu azu yindœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Andaa, endje sœ lima dœ anga ayi kánga á endje para wu lima sœ ye, ɨ'ɨrɨ ye kœdœ Yisu Barabase. ");
INSERT INTO kxf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilato yu ukpulu azunœ á endje ngbɔtœ endje ga tœnœ adœke: «Œɗe dá 'e yindœ nœ adœke mœ katœ ye a? Yisu Barabase too Yisu á endje e she Kristu?» ");
INSERT INTO kxf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mbœrœ tshe wu lima sœ nœ adœke endje sœ dœ úkú ga tœ ye yeka á za she na tœnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɔlɔ á Pilato sœ kœwa ngbanganœ ɓa lœ anda kœwa ngbanga, awonœ pa fœ she adœke: «Lili ga lœ o'o nœ uzunœ asœ nene, tshe sœ ndjii. Mbœrœ mœ lu dœ abutshɔ asœ, lɔsu mœ ka mœ mbœrœ she waa.» ");
INSERT INTO kxf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia sœ kœli ga lœ azu adœke endje katœ Barabase kashe œ wo Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gbozugo kpa yu endje adœke: «Œɗe ugurutœ endje bisha á 'e yindœ nœ adœke mœ katœ ye fœ 'e a?.» Endje gi adœke: «Barabase.» ");
INSERT INTO kxf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato yu endje adœke: «Œrœ gaɗe á mœ kœmbœrœ tœ Yisu á endje e she Kristu a?» Endje para gi adœke: «'E kuru she ga pa kurushi.» ");
INSERT INTO kxf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato yu endje adœke: «Ekperœ gaɗe dá tshe mbœrœ a?» Kashe endje tetœ kœta rawa dœ agbɔ adœke: «'E kuru she ga pa kurushi.» ");
INSERT INTO kxf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lɔkɔ á tshe wu adœke œne kpa wusœ œrœ á œne mbœrœ nene, tshe su ungu œ djutɔ dœ kane ye utshu ukpulu azu dœ kœpa adœke: «Mœ dœ́dœ́ ayi kumu upu kuzu ye nene; œtœnœ kœdœ upu nœ 'e.» Gbambanœ nene, azu sœ lima kœoma dœ o'onœ waa. ");
INSERT INTO kxf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Azu para gi adœke: «Kaka adœke indji ye sœ ga pa 'a dœ agbolo nœ 'a.» ");
INSERT INTO kxf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yeka á tshe kœkatœ Barabase, yé manda kœsɔ Yisu dœ ndjapa, tshe za she fœ endje adœke endje kœkuru she ga pa kurushi. ");
INSERT INTO kxf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manda nœ aturugu nœ gbozugo gu dœ Yisu ga lœ gbagba nœ ye, yé ukpulu azu kpa dji she djikpata. ");
INSERT INTO kxf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Endje verœ lœba tœ ye, yé á verœ yɔgbɔdɔ odoro lœba ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Endje verœ kpoto nœ ishi ga tœ kumu ye ɓata gbozugo, endje za tshɔngbɔlɔ ga tœ kuni ye, á tetœ kœgote ga utshu ye dœ pe kœmɔ she adœke: «'A bala ɓœ gbozugo nœ Ayuda.» ");
INSERT INTO kxf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Endje sœ kœtu ngusha ga tœ ye, œ za tshɔngbɔlɔnœ asœmœ á sɔ dœ kumu ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Manda kœmɔ she, endje verœ yɔgbɔdɔ lœbanœ tœ ye á gi œne ye ga tœ ye, yé á za she na tœnœ ndœ kœkuru she ga pa kurushi. ");
INSERT INTO kxf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɓata endje sœ lima kœwuta tœnœ, endje gbɔ uzu tshalakpɨ Sirene, á ɨ'ɨrɨ ye kœdœ Shimu, endje vwa she dœ agbɔ ndœ kœza átá kurushi tœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Endje wuta ga tœ osho á ɨ'ɨrɨnœ kœdœ Gologota, œ yindœ kœpa adœke «Osho gbayashi kɔrɔ.» ");
INSERT INTO kxf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Endje sú ipi á endje ngbɔɓa dœ shundɔɗɔ œrœ œ za fœ Yisu adœke tshe ndjo. Tshe dji ɔtshɔnœ kashe tshe yiyi lima ndœ kœndjo tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Endje kuru she ga pa kurushi yé œ ta wuka mbœrœ kœkurutshelœ lœba nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Manda nœ, endje sœ ga atɨ ɓa zœ mbœrœ kœgbɔndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Endje su ádá kœwo she ga pa tsheporo maɓaya yé œ za ga pa kumu ye. O'onœ pa adœke: «Uzu asœ kœdœ Yisu, gbozugo nœ Ayuda.» ");
INSERT INTO kxf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Endje kuru anga aayi angba bisha ga pa kurushi ga ɨndɨrɨ ye; anga ga pa kuni, yé anga ga pa gele ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Azu á endje sœ lima kœvwanga tœnœ, sœ kœgu she dœ kœmea kumu endje, ");
INSERT INTO kxf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yé œ sœ lima kœpa adœke: «Œɓœ á ɓœ pa lima adœke ɓœ ndɨ tshelœ Tepelo yé œ kpa mɔ anganœ manda olo votɔ; œdœ ɓœ kœdœ Gbolo nœ Ndjaba, shetœ zœ dœ tœ zœ yé œ jerœ pa kurushi ga atɨ!» ");
INSERT INTO kxf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Awa bale, agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa œdœ pe agbozu Ikrizia sœ lima kœmɔ she yé œ sœ kœpa adœke: ");
INSERT INTO kxf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Tshe she lima anga azu, tshe shetœ ye dœ tœ ye! Œshe kœdœ gbozugo nœ Israyele, tshe jerœ ngɔngɔnœ asœ pa kurushi yé a kœyindœ nœ ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tshe za lɔsu ye ga pa Ndjaba yé œ pa ngbɨ adœke: “Œmœ kœdœ Gbolo nœ Ndjaba.” Œdœ Ndjaba kœyindœ ye, tshe she she ngɔngɔnœ asœ!» ");
INSERT INTO kxf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aayi angba á endje kuru lima endje ga pa kurushi dœ she gu ndje she awa bale dœ mara ataa. ");
INSERT INTO kxf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dœ kakpi ɔlɔ, osho bu kporokoto pa ogo djigi œrrr ga tœ ada ɔlɔ votɔ manda kakpi ɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kœwuta ga tœ ada ɔlɔ votɔnœ asœmœ, Yisu ta rawa dœ ɔgbɔ tshama ye adœke: «Eli, Eli, lema sabakatani?» Œ yindœ kœpa adœke: «Ndjaba nœ mœ, Ndjaba nœ mœ, mbœrœ gaɗe á ɓœ katœ mœ tɨ a?» ");
INSERT INTO kxf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anga azu ugurutœ endjeneke á endje sœ lima kpœtœmœ dji she yé œ pa adœke: «'E dji ka, tshe sœ kœ'e Eliya!» ");
INSERT INTO kxf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Trale, anga uzu bale ugurutœ endje kpa œ nduru ndɔhɔrɔ ga la ikpi vinu yé œ vwele ga tœ kumu wara yeka á yi ga tœ ama ye adœke tshe ndjo. ");
INSERT INTO kxf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Anga endje pa adœke: «'E kaka kane! A wu œdœ Eliya œ na kœshe she!» ");
INSERT INTO kxf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kashe Yisu kpa ta rawa dœ ɔgbɔ tshama ye, yé œ tshu ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dœ lɔndɔnœ asœmœ, lœba á endje du ɓa lœ Tepelo suru tshelœtœ ye bisha kœto ɓa lafo œrrr ga atɨ. Ɔshɔ turu, tshelœ ogboro badja 'oro, ");
INSERT INTO kxf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","udu kɔrɔ, yé ayindœ Ndjaba ndjoro á endje tshu, kwatœ endje ga lœ soro. ");
INSERT INTO kxf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Manda Ndjaba kœshe Yisu lœ akuzu, manda kœwuta endje lœ udu, endje li ga lœ œyerœ ongbo Yerusaleme, yé á azu ndjoro wu endje ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gbozu tshapa aturugu Roma œdœ aturugu á endje sœ kœgbɔ lima ndœ Yisu dœ she, wu ɔshɔ á turu œdœ œneke kɔ á wuta lima asœmœ, awa za endje tɔpanœ kpuru yé endje pa adœke: «Uzu asœke kœdœ lima adja Gbolo nœ Ndjaba tako.» ");
INSERT INTO kxf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ayashe ndjoro ka lima zara á sœ kœtondœ osho: Endje te lima mangba Yisu kœto ɓa lœ Galilayi mbœrœ kœmbœrœ akwa fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mareya uzu tshalakpɨ Magadala, dœ Mareya ayi Jake dœ Yozefu, œdœ pe ayi agbolo nœ Zebedayi, sœ lima ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dœ adɨla, anga ayi kœgbɔrœ ɓa lœ Arimateyo á ɨ'ɨrɨ ye kœdœ Yozefu yikumu ye; œshe kœdœ ndje lima yambarœ nœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tshe na ga ndœ Pilato yé œ yu she tœ oko Yisu. Yé Pilato za awa adœke endje za fœ she. ");
INSERT INTO kxf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yozefu za oko Yisu œ vwele ga tœnœ dœ ɔtshɔ lœba, ");
INSERT INTO kxf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","yé á za ga lœ tafo udu á tshe totœ kœdji tœnœ ɓa lœ ɔngɔ badja. Manda nœ, tshe vwɨrɨ egerœ badja ga tœ mandanœ yé œ gu da ye. ");
INSERT INTO kxf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Andaa, Mareya uzu Magadala œdœ anga angbɨ Mareyanœ sœ lima ga atɨ ɓa utshu udunœ. ");
INSERT INTO kxf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Olo bale manda nœ, tœnœ kœdœ lima lɔkɔ utshu sabata, agbozu tshapa anganga Ndjaba dœ pe Afarisayi na awa bale ga ndœ Pilato. ");
INSERT INTO kxf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Endje pa fœ she adœke: «Gbozu, 'a gbe dœ o'o á ayi wala asœ pa lima lɔkɔ á tshe sœpe dœ soro. Tshe pa lima adœke: “Manda olo votɔ, Ndjaba œ she mœ lœ akuzu ye.” ");
INSERT INTO kxf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Za awa adœke endje gbɔndœ tshapa udu asœ œrrr ga tœ votɔ olo yekane, ete nene ayambarœ nœ ye œ zɨ angba ye, yé œ pa fœ azu adœke: “Ndjaba she lœ akuzu ye.” Yé walanœ asœ œ kpa ropa œneke lima utshunœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kœpa fœ endje adœke: «Aturugu kœgbɔndœ œrœ dœke. 'E na dœ endje dœ́ endje gbɔndœ tshapa udunœ ɓata á 'e wa asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ataa, endje na ga pa udu œ guma mara kœgbɔndœ nœ: Endje ɨvwɨ badjanœ œ tshu dœ mandanœ yé á katœ aturugu ndœ kœgbɔndœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Manda olo sabata, kœli ga lœ ali olo nœ pɔsɔ, Mareya uzu Magadala dœ pe anga angbɨ Mareyanœ na kœwu tshapa udu. ");
INSERT INTO kxf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Trale atake, ɔshɔ turu dœ agbɔnœ. Anga andjelu nœ Gbozu to ɓa lafo œ jerœ, œ vwɨrɨ egerœ badja tœ manda udunœ yé á sœ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tshe sœ lima ɓata kœyerœwa yavuru, yé lœba ye sœ dœ imbinœ ɓata ondoro. ");
INSERT INTO kxf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aturugu sœ lima kœde gbaragbara dœ awa, yé œ sœ ɓata azu á endje tshu ye. ");
INSERT INTO kxf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kashe andjelu za o'o yé œ pa fœ ayashenœ adœke: «Awa zaza 'e nene, mœ wusœ nœ adœke 'e sœ kœpara Yisu á endje kuru she ga pa kurushi. ");
INSERT INTO kxf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tshe gugu kpeke nene, mbœrœ Ndjaba she she lœ akuzu ɓata á tshe pandœ nœ lima fœ 'e. 'E na ga mœ œ wu osho á tshe lo lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yé 'e gu katsha œ pandœ nœ fœ ayambarœ nœ ye adœke: “Ndjaba shé she lœ akuzu ye, yé tshe ro utshu 'e ga lœ Galilayi da ye; 'e wu she ɓa zœ.” Œtœnœ dá mœ pandœ nœ fœ 'e asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Endje katœ tshapa udu tɨ dœ awa œdœ pe dœ yanga, œ kpagu kœpandœ nœ fœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Trale, endje wu Yisu kœna ga ndœ endje, á pa fœ endje adœke: «Mœ bala 'e!» Endje gitœ endje ndoo ga ndœ ye, œ tepa ada ye yé á gote ga utshu ye. ");
INSERT INTO kxf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yé Yisu pa fœ endje adœke: «Awa zaza 'e bale nene. 'E gu œ pandœ nœ fœ aaya mœ adœke endje ro ga lœ Galilayi: ɓa zœ dá endje wu mœ.» ");
INSERT INTO kxf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lɔkɔ á endje sœpe lima tœ ala awa, anga aturugu lœ ugurutœ aturugu kœgbɔndœ udu ro ga lœ ongbo, œ pandœ œrœ kɔ á ro ɓa zœ fœ agbozu tshapa anganga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Manda kœngbɔtœ dœ kœdjitœ agbozu nganga Ndjaba dœ pe agbozu Ikrizia, endje to ngendja dœ egerœ nœ fœ aturugu, ");
INSERT INTO kxf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yé œ pa fœ endje adœke: «'E pa ngbɨ adœke: Lɔkɔ á 'e sœ tœ olo, ayambarœ nœ ye na dœ butshɔ œ za angba oko ye yé. ");
INSERT INTO kxf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yé œdœ gbozugo kœdji o'onœ asœ, a'a dá ru alanœ yé á mbœrœ adœke 'e gbɔgbɔ o'o nene.» ");
INSERT INTO kxf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aturugu za ngendjanœ yé œ tetœ kœmbœrœtœ endje lindœ o'onœ á endje za fœ endje asœmœ. Ataa, o'onœ asœ kaka osho ɓa ndœ Ayuda œrrr ga tœ kpesheke. ");
INSERT INTO kxf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ayambarœ nœ ye ndjokpa dœ bale na ga lœ Galilayi ɓa pa kaga á Yisu yi lima sœ nœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lɔkɔ á endje wu lima she, endje gote ga utshu ye; kashe anga endje ugurutœ endje sœ lima dœ sharapu. ");
INSERT INTO kxf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yisu na ndoo dœ endje, œ pa fœ endje adœke: «Ndjaba za tshagbozu kɔ nœ œrœ tshalafo dœ pe œnœ tshapa shɔ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'E na djelœ ogo kɔ, 'e fa azu tœ ayambarœ nœ mœ, yé œ za batisimu fœ endje dœ ɨ'ɨrɨ Aba, dœ Gbolo dœ pe Ɔtshɔ ɨshirɨ, ");
INSERT INTO kxf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","'e yisœ nœ fœ endje adœke endje gbɔndœ œneke kɔ á mœ za lima dœ o'o fœ 'e. Yé œmœ, mœ sœ dœ 'e awa bale ɔlɔ dœ ɔlɔ œrrr ga tœ kœka tshapashɔ.»");
INSERT INTO kxf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Asœ kœdœ Ɔtshɔ O'o nœ Yisu Kristu, Gbolo nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaya, anga ayi kœgbara o'o su lima o'o ama Ndjaba la mbeti nœ ye adœke: «Ndjaba pa adœke: “Mœ vwa ayi akwa nœ mœ utshu zœ mbœrœ kœguma ala awa zœ. ");
INSERT INTO kxf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uzu bale sœ kœmɨndœ upu ɓa lœ kpagagasho: 'E guma ala awa Gbozu, 'E yɔrɔ ala awa ye ndjii.”» ");
INSERT INTO kxf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Œneke kɔ mbœrœ lima tœ endje dœ ɔlɔnœ á Yowane sœ lima ɓa lœ kpagagasho. Tshe sœ lima kœza batisimu fœ azu, œ sœ kœyisœ œrœ adœke: «'E fatshalɔsu 'e dœ́ œ gbɔ batisimu yeka á Ndjaba kœdjerœndœ ekperœ nœ 'e kɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Azu tshelœ ogo Yuda dœ tshalakpɨ Yerusaleme á endje sœ lima kœna ga ndœ ye, endje sœ lima kœpandœ ekperœ nœ endje ngbɨɨ tœ ala azu kɔ yeka á Yowane œ za batisimu fœ endje ɓa la ngu Yɔrdane. ");
INSERT INTO kxf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowane verœ lima lœba á endje mbœrœ dœ usu shamo yé uwu tshapa lœbanœ tœ nguku ye kœdœ ɔkɔ agea. Kœzɨrœ ama ye kœdœ lima ayila œdœ pe ojoro awaterœ. ");
INSERT INTO kxf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tshe sœ lima kœgbara o'o fœ azu adœke: «Uzunœ á tshe na manda mœ asœ, tshe ropa mœ dœ gbɔgbɔ ye, mœ lili kœka ga utshu dœ pe kœzu uwu œrada nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mœ za batisimu fœ 'e dœ amba ungu; kashe œshe, tshe za bala batisimu nœ Ɔtshɔ Ɨshirɨ fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dœ ɔlɔ nœ asœmœ, Yisu to ɓa lœ ogo Galilayi ɓa lakpɨ Nazarete, á na yeka á Yowane za batisimu fœ she ɓa la ungu Yɔrdane. ");
INSERT INTO kxf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kœwuta lima she kolœ langu atake, tshe wu adœke tshalafo kɔrɔ ngbɨɨ yé Ɨshirɨ nœ Ndjaba jerœ ga pa ye ɓata mbepa. ");
INSERT INTO kxf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yé tshe dji tshama kœto ɓa lafo œ pa adœke: «Œɓœ kœdœ Gbolo nœ mœ á mœ yindœ zœ, yanga zœ sœ tœ mœ waa.» ");
INSERT INTO kxf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Trale manda nœ, Ɨshirɨ nœ Ndjaba to Yisu na tœnœ ga lœ kpagagasho. ");
INSERT INTO kxf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tshe lo lima lœ kpagagasho olo zazu bisha á Satana na ɓa zœ kœwu lɔsu ye. Tshe sœ lima kpœtœ œsœnœ dœ akatshagea tshelœ gusu yé á aandjelu lœ lima kœmbœrœ akwa fœ she. ");
INSERT INTO kxf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɔlɔnœ á endje za Yowane ga lœ kánga, Yisu kwatœ ye ga lœ Galilayi yé œ tetœ kœmɨndœ Ɔtshɔ O'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tshe mɨ lima ndœ nœ adœke: «Ɔlɔnœ tɔ ye, yé Ogo gbozu nœ Ndjaba ndo ye. Atamœ 'e fatshalɔsu 'e œ yindœ Ɔtshɔ O'o!» ");
INSERT INTO kxf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dœ anga ɔlɔ bale, Yisu sœ lima kœna tœ mangu egerœ ungu adanga Galilayi, tshe wu ayi kœpara ageatshalangu bisha, Shimu œdœ aya nœ dœ Andere á endje sœ kœvwi gbanda nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yisu pa fœ endje adœke: «'E na manda mœ dœ mœ fa 'e tœ aayi kœpara azu.» ");
INSERT INTO kxf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pe kpœtœ œsœnœ, endje katœ gbanda nœ endje tɨ œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisu gitœ ye teasho ga utshunœ, œ wu Jake endje dœ ayanœ dœ Yowane, agbolo nœ Zebedayi. Endje sœ ga atɨ lœ agba á sœ kœdu œsœ gbanda nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yisu e endje, endje katœ aba endje dœ Zebedayi dœ pe ayi akwa nœ endje tɨ lœ agba, yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yisu dœ ayambarœ nœ ye na lima ga lœ ongbo Kaparnawumu. Dœ lɔkɔ sabata, tshe li ga lœ Sinagoga œ tetœ kœyisœ œrœ. ");
INSERT INTO kxf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Azu á endje sœ lima kœdji she kɨtœ mara Kœyisœrœ nœ ye, mbœrœ tshe sœsœ lima kœyisœ œrœnœ ɓata aayi kœyisœ awa akwa nene kashe ɓata uzu á tshe sœ dœ tshagbozu. ");
INSERT INTO kxf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Trale anga uzu á tshe sœ dœ ekpe ɨshirɨ pa ye sœ ndje lima lœ Sinagoganœ, á tshe yi ama ye lœ rawa adœke: ");
INSERT INTO kxf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yisu uzu Nazarete, ɓœ yindœ kœmbœrœ gaɗe tœ 'a? Ɓœ na mbœrœ kœwo 'a? Mœ wusœ zœ dœ ɔtshɔnœ, œɓœ kœdœ œyerœ uzu á Ndjaba vwa she.» ");
INSERT INTO kxf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yisu ra ekpe ɨshirɨ sœmœ adœke: «Sœ koko! Gitœ zœ pa uzunœ asœke!» ");
INSERT INTO kxf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe kpœtœ œsœnœ, ekpe ɨshirɨnœ yaka uzunœ, œ ve ɔgbɔ rawa œ gitœ ye pa ye. ");
INSERT INTO kxf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Œ za lima awa fœ azu kɔkɔ yé endje tetœ kœyutœ endje adœke: «Asœ kœdœ gaɗe? Tshe yisœ tafo œrœ dœ tshagbozu! Tshe pa o'o fœ ekpe ɨshirɨ yé ekpe ɨshirɨ sœ kœmbœrœtœ ye lindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pe manda nœ asœmœ, ɨ'ɨrɨ Yisu za lima tshalakpɨ ogo Galilayi djigi. ");
INSERT INTO kxf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dœ lɔkɔnœ asœmœ, endje wuta lima lœ Sinagoganœ, œ gu ga sœnda nœ Shimu œdœ Andere awa bale dœ Jake dœ pe Yowane. ");
INSERT INTO kxf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kœwuta Yisu atake, azu pa lima fœ she adœke ayimbeya Shimu lo ga pa kelekpa dœ koɓa biwa. ");
INSERT INTO kxf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yisu gitœ ye ndo dœ she, œ za kane ye, œ tɨ she ga lafo, koɓa biwa nœ ye ka ngbewo. Yé yashe sœmœ tetœ kœmbœrœ akwa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dœ adɨla manda kœli ɔlɔ, azu na lima dœ ayi koɓa kɔ dœ pe endje á endje lœ ndje lima dœ ekpe ɨshirɨ pa endje fœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Azu tshalakpɨ ogonœ ngbɔɓa tœ endje kɔ ɓa lœ manda andanœ á Yisu dœ ayambarœ nœ ye sœ lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yisu she lima azu ndjoro á endje sœ dœ mara koɓa dœ koɓa, œ gɔrɔ ndje lima ekpe ɨshirɨ ndjoro pa azu. Tshe rá lima ekpe ɨshirɨ adœke endje ɨɨ ama endje bale nene, endje pupu o'o teasho nene kolœ mbœrœ á endje wu lima sœ ye dœ Yisu dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pe dœ amazɨ utshu nœ kœwuta ɔlɔ, Yisu katœ Kaparnawumu tɨ œ na kœsœ ga tœ osho á sœ zɨtɨ ɓa lœ kpagagasho. Ɓa zœ, tshe tetœ kœ'e tshalafo. ");
INSERT INTO kxf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Shimu dœ anga anganœ na kœpara she. ");
INSERT INTO kxf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kœgbɔ she kpɔ atake, endje pa fœ she adœke: «Azu kɔkɔ lœ kœpara ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yisu gi o'o fœ endje adœke: «A na ga tœ anga angbɨ osho, ga lœ ongbo á sœ mashenga dœ œneke adœke mœ yi ndje sœ Ɔtshɔ O'o ɓa zœ kane. Mbœrœ mœ na mbœrœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yé tshe ro lima djelœ ogo Galilayi djigi; œ yi lima sœ œrœ ɓa lœ Sinagoga nœ endje, œ gɔro ndje lima ekpe ɨshirɨ pa azu. ");
INSERT INTO kxf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɔlɔ bale, anga ayi boroma na ga ndœ Yisu, œ gote ga utshu ye, œ kɨ fœ she adœke: «Œdœ ɓœ kœyindœ kœshe mœ, ɓœ she mœ lœ koɓanœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yisu wu oyo ye, œ yi kane ye, œ goro she á pa fœ she adœke: «Mœ yindœ nœ adœke ɓœ she!» ");
INSERT INTO kxf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kolœ tœ farapu boroma yiwa yé tshe she. ");
INSERT INTO kxf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yisu gi she toro kœgu ga ndœ ye, œ pa fœ she dœ ɔgbɔ adœke: ");
INSERT INTO kxf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Dji mœ dœ ɔtshɔnœ! Papandœ œrœ á mbœrœtœ endje fœ ɓœ fœ uzu bale nene, kashe gu œ matœ zœ fœ nganga Ndjaba, œ to tokóró tœ zœ lindœ œneke á Moyize pa lima ndœ nœ mbœrœ kœma fœ azu kɔ adœke ɓœ she lœ koɓa ye.» ");
INSERT INTO kxf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Atamœ gbaa, uzu sœmœ gu œ mɨ tshelœ o'onœ ngele ngele djezœ tɔpanœ kpuru adœke azu kɔkɔ wusœ nœ. Mbœrœ tœnœ ataa, Yisu kpa lili lima kœwuta ngbɨɨ ga tœ ala azu ndœ akwa nene. Ataa Yisu gi lima tœ ye kœsœ ga tœ osho á azu ngbangba tœnœ nene gbaa, azu lœ lima kœto tœ osho dœ osho kœna ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Manda anga olo, Yisu kwatœ ye ga lœ Kaparnawumu yé azu dji adœke tshe sœ ɓa sœnda. ");
INSERT INTO kxf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Azu ngbɔtœ endje ndjoro ɓa sœnda tɔ ga lœ talamanda œrrr yaba yaba tɔ ɓa shu. Anga ɔngɔrɔ osho sœsœpe nene yé á tshe ka yeka á sœ kœyisœ œrœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Anga azu vana za uzu ada ye tshu tshakudu ye œ na dœ she fœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kolœ mbœrœ kœngba azu, endje lili kœwuta dœ she ɓa tshatshu Yisu nene. Endje ɔ, œ kɔrɔ ogoro ɓa pa anda kpœtœ osho á Yisu ká tœnœ yeka á yi uzunœ á ada ye tshu asœmœ dœ kondja nœ ye kɔ tara tœnœ ndjii ga tshatshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisu wu kœyindœrœ nœ endje, œ pa fœ uzunœ á ada ye tshu adœke: «Gbolo nœ mœ, mœ djerœndœ ekperœ nœ zœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Anga aayi kœyisœ awa akwanœ á ndje lœ ga atɨ tœ œsœnœ tetœ kœgbetshelœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Mbœrœ gaɗe á uzunœ asœke œ pa mara o'o ata a? Asœke kœdœ kœgu œsœ́ Ndjaba nene a? Œɗe dá li tœ kœdjerœndœ ekperœ a; œ dœ́dœ́ Ndjaba kutɨ ye nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yisu wu lima sœ gbetshelœ nœ endje kpa, á yu endje adœke: «Mbœrœ gaɗe á 'e gbe o'o tœ lɔsu 'e ataa a? ");
INSERT INTO kxf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kœpa fœ uzu adœke: “Mœ djerœndœ ekperœ nœ zœ ye”, too ndje kœpa adœke: “Aalafo, œ za kondja nœ zœ yé œ na ana”, o'o neketa dá ga a? ");
INSERT INTO kxf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mœ pa o'onœ asœke mbœrœ 'e kœwusœ nœ adœke kpœpa ɔshɔ asœke kɔ, Gbolo nœ uzu dá sœ dœ gbɔgbɔ mbœrœ kœdjerœndœ ekperœ». Yé á tshe kœpa fœ uzunœ á ada ye tshu adœke: ");
INSERT INTO kxf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mœ pa fœ ɓœ, áalafo œ za kondja nœ zœ yé œ gu ga ndœ zœ!» ");
INSERT INTO kxf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gbɨkɨvwɨgbɨ, ayi koɓanœ aalafo, œ za kondja nœ ye, œ wuta ngarrr dœ ala azu kɔkɔ á endje sœ lima tœ œsœnœ. Œ te egerœ o'o lœma azu kɔ yé uvuru endje kpa lœ nœ. Endje donga Ndjaba, œ pa adœke: «A wuwu ɓa lima anga neke bale nene!» ");
INSERT INTO kxf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yisu fatœ ye kœgu jerœ ngbɔlɔɔ tœ mangu Galilayi. Azu ndjoro na ga ndœ ye á tshe ka á sœ kœyisœ œrœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kœsœ kœdɨrœ ataa, Yisu wu anga uzu bale, ɨ'ɨrɨ ye kœdœ Levi, gbolo nœ Alefe á tshe sœ ga atɨ ɓa tœ osho kœyɔ lapo. Yisu vwi o'o fœ she adœke: «Na manda mœ.» Levi áafo yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Manda nœ, Yisu sœ kœzɨrœ ɓa sœnda nœ Levi. Azu kœko ngendja lapo ndjoro, dœ pe aayi kœmbœrœ ekperœ sœ lima kœzɨ œrœnœ dœ she awa bale œdœ pe ayambarœ nœ ye, mbœrœ ɨlɨ azu á ndje sœ lima kœna manda ye kœdœ kolœ mara azunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yé aayi kœyisœ awa akwa nœ Afarisayi wu Yisu kœzɨ œrœ awa bale dœ ayi kœko ngendja lapo dœ pe azu kœmbœrœ ekperœ, á yu ayambarœ nœ ye adœke: «Mbœrœ gaɗe á tshe zɨ œrœ kpœtœ œsœnœ bale dœ azu kœko ngendja lapo œdœ pe aayi kœmbœrœ ekperœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisu dji ataa, œ gi o'o fœ endje adœke: «Azu neke á tshelœ akɔ endje sœ yerœ, endje mbœrœ ogo monganga nene kolœ ayi koɓa dá gbe ndœ kœna kœwu she. Mœ na kœ'e osho fœ azu á endje sœ ndjii nene, mœ na mbœrœ azu kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dœ anga ɔlɔ bale, ayambarœ nœ Yowane ayi kœza batisimu dœ pe endje nœ Afarisayi lœ lima kœyotshelœma endje mbœrœ Ndjaba yeka azu na kœyu Yisu adœke: «Mbœrœ gaɗe á ayambarœ nœ Yowane ayi kœza batisimu dœ endje nœ Afarisayi œ yotshelœma endje mbœrœ Ndjaba yeka á endje nœ zœ vwara má tœ endje kœmbœrœ awa bale a?» ");
INSERT INTO kxf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yisu gi fœ endje adœke: «Œdœ uzu kœto yashe á kœ'e anganœ ndœ angbonœ, endje yotshelœma endje ye a? Bale nene! Ɓata akɔ yashe sœ kpœtœ œsœnœ dœ endje, endje yotshelœma endje nene. ");
INSERT INTO kxf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kashe lɔkɔ á endje kœza akɔ yashenœ ugurutœ anganœ, ɔlɔnœ á endje yotshelœma dœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Uzu zaza tafo lœba œ pi ga pa ongboro lœba nene. Œdœ tshe kœmbœrœ ataa, tafo ndœma lœbanœ œ suru tshelœ ongboronœ, yé ogoronœ œ kpa gerœ kœropa ongboro ogoronœ má utshunœ. ");
INSERT INTO kxf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Awa bale, uzu susu tafo ipi va va va ga lœ ongboro anga nene. Ete nene œ kœsœ adœke ipinœ yuuyu, tshelœ anga œ kpa kiri kiri; á kœde, ipinœ œ tu kpa ga lœ ɔshɔ. Ipi dœ anga kɔkɔ œ ro ye, a wusœ nœ adœke tafo ipi li dœ tafo anga.» ");
INSERT INTO kxf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Dœ anga lɔkɔ sabata bale, Yisu dœ ayambarœ nœ ye ro tɔ lœ kɨndɨ ble. Ayambarœ nœ ye yopa kœsɔ ogboro kumu ble na tœnœ ɨndɨrɨ ala awa. ");
INSERT INTO kxf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yé Afarisayi yu she adœke: «Wu œneke kane, mbœrœ gaɗe á ayambarœ nœ zœ œ mbœrœ œrœ neke á lili adœke azu mbœrœ dœ olo sabata nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yisu gi o'o fœ endje adœke: «'E dɨdɨ damba la mbeti dœ ádá œrœ á Davidi mbœrœ lima, dœ ɔlɔnœ á ogo li tœ ye dœ azu nœ ye á endje gugu dœ kœzɨrœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tshe li ɓa lœ anda nœ Ndjaba, á zɨ rœgo á endje ko fœ Ndjaba dœ lɔkɔ nœ Abiatare á li kolœnœ adœke egerœ nganga Ndjaba kœzɨ, á Davidi zɨ yeka á kpa to ndje udunœ fœ azu nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yisu kpa pa fœ endje adœke: «Ndjaba mbœrœ lɔkɔ sabata mbœrœ uzu, tshe mbœmbœrœ uzu mbœrœ lɔkɔ sabata nene. ");
INSERT INTO kxf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'E wu ádánœ á sœ adœke Gbolo nœ uzu kœdœ ayengɔ lɔkɔ sabata.» ");
INSERT INTO kxf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɔlɔ bale, Yisu kpa li ga lœ Sinagoga, œ gbɔ anga uzu á kane ye tshu. ");
INSERT INTO kxf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Azu á ndje lœ lima tœ œsœnœ, mesho lima lœ ala endje kœwu too Yisu œ she uzunœ asœmœ dœ lɔkɔ sabata, yeka á œne kœgbɔ awa kœtɔ meza pa ye. ");
INSERT INTO kxf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yé Yisu pa fœ uzunœ á kane ye tshu adœke: «Aalafo, œ na œ ka kpœgurunœ.» ");
INSERT INTO kxf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tshe yu azunœ adœke: «Lɔkɔ sabata yindœ nœ adœke azu mbœrœ ɔtshɔrœ too ekperœ? Lɔkɔ sabata yindœ kœshe uzu too kœkatœ ye adœke tshe tshu?» Endje ngbɔ kɔkɔ œ lœ ko ko ko. ");
INSERT INTO kxf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yisu shokɔ endje vwirrr, tshelœ ye voro tœ endje kɔ kɔ kɔ. Tshe sœ lima dœ adja oyo tœ lɔsu ye tœ kœwu ɔgbɔ lɔsu nœ endje, yé œ pa fœ ayi koɓanœ adœke: «Yɔrɔ tshelœ kane zœ!» Tshe yɔrɔ tshelœnœ yé tœ farapu, kane ye gumatœ ye ngbewo. ");
INSERT INTO kxf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Afarisayi wuta kɔ lœ anda ngbɔtœ, œ ngbɔtœ endje pe kpœtœmœ dœ azu nœ Erode kœvwarandœ o'o tœ kœpara awa ndœ kœwo she dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisu dœ ayambarœ nœ ye áalafo œ gitœ endje kœna ga tœ mangu Galilayi. Azu ndjoro lœ ogo Galilayi na manda ye. Anga endje to lœ ogo Yuda, ");
INSERT INTO kxf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","dœ Yerusaleme, ɓa lœ ogo Idume, œdœ ogonœ á sœ ɓa atshi Yɔrdane, dœ ogonœ á sœ mashenga dœ tshalakpɨ Tire dœ Sidona. Azu na lima ndjoro ga ndœ Yisu mbœrœ endje dji lima o'o tœ upu œneke kɔ á tshe sœ lima kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yé Yisu pa fœ ayambarœ nœ ye adœke endje gumasœ aya agba bale ndœ ana mbœrœ adœke azu kœpoporo œne nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gbambanœ nene, tshe she lima azu tɔpanœ kpuru yeka á endjeneke á endje lœpe dœ koɓa sœ kœgbugburutshelœtœ endje adœke œne goro she yeka á kœshe. ");
INSERT INTO kxf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Œdœ ndje endjeneke á ndje sœ lima dœ ekpe ɨshirɨ, endje kœwu she, endje sœ lima kœyo ga tœ koda ye dœ kœve rawa adœke: «Œɓœ kœdœ Gbolo nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yisu rá endje adœke endje papandœ nœ fœ uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Manda nœ Yisu ɔ ga pa kaga, œ e azu neke á tshe yindœ endje kœna ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tshe ke endje ndjokpa dœ bisha yé œ fa endje tœ «ayi avwa» nœ ye. Tshe ke endje kœsœ awa bale dœ she, tœ kœvwa endje ndœ kœyisœ œrœ, ");
INSERT INTO kxf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","œdœ ndje pe kœza gbɔgbɔ kœgɔrɔ dœ ekpe ɨshirɨ pa azu fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɨ'ɨrɨ aayi avwanœ ndjokpa dœ bisha kœdœ: Shimu (á Yisu za anga ɨ'ɨrɨ ye ga panœ adœke Petro), ");
INSERT INTO kxf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jake œdœ ayanœ dœ Yowane (endje bisha kœdœ agbolo nœ Zebedayi, Yisu tá ɨ'ɨrɨ endje adœke Boaneregese, ádánœ adœke, agbolo nœ kœsɔ yavuru), ");
INSERT INTO kxf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","dœ Andere, Filipo, Bartelemi, Matie, Toma, Jake tshenœ Alefe, Tade, Shimu uzu Kanana, ");
INSERT INTO kxf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dœ Yudasi Isikariote, œshe dá ka lima Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisu gu ga sœnda yé azu ndjoro kpa ngbɔtœ endje dji she. Mbœrœ tœnœ ataa, tshe gbɔgbɔ awa kœzɨrœ teasho œdœ ndje ayambarœ nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aayanœ dji ataa œ ngbɔtœ endje, œ na manda ye ndœ kœto she mbœrœ endje gbe adœke: «Kumu ye djingili ye.» ");
INSERT INTO kxf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aayi kœyisœ awa akwa á endje to ɓa lœ Yerusaleme pa fœ endje adœke: «Belezebula gbozu nœ ekpe ɨshirɨ sœ pa ye. Œshe dá za gbɔgbɔ fœ she tœ kœgɔrɔ dœ ekpe ɨshirɨ pa azu asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yisu e endje, œ pa fœ endje lœ gbaguru adœke: «Kotoo á Satana œ gɔrɔ undu ye dœ tœ ye a? ");
INSERT INTO kxf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Œ kœsœ adœke azu lœ ogo bale kœndjɔtshelœtœ endje, ogonœ œ kpa dœ ogo nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Œdœ azu lœ mazungu kœsœ dœ o'o lœ oporo tœ endje, mazungunœ œ sœpe nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Œ kœsœ adœke Satana sœ kœnga koshe dœ azu nœ ye too œ kœsœ ndje adœke azu nœ ye kurutshelœtœ endje, gbɔgbɔ ye œ ka, yé œndœ ye œ dɨ nene. ");
INSERT INTO kxf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Uzu á tshe kœyindœ kœli kœzɨ angba œrœ nœ ayi gbɔgbɔ, œ li adœke tshe i she vwagbagba ga tœnœ dœ uwu yeka á kœko œrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mœ pa fœ 'e dœ adjapu adœke Ndjaba œ djerœndœ ekperœ nœ azu kɔkɔ dœ pe o'o ama endje á ndje pa. ");
INSERT INTO kxf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kashe uzu neke á tshe kœpa ekpe o'o goro œsœ́ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye teasho nene mbœrœ tshe mbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisu mɨ lima ndœ nœ fœ endje ataa, mbœrœ endje pa lima adœke: «Ekpe ɨshirɨ sœ pa ye.» ");
INSERT INTO kxf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dœ anga ɔlɔ bale, ayi Yisu dœ pe aayanœ na, œ sœpe ɓa shu œ vwa uzu kœ'e she fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Azu ndjoro á ndje lœ atɨ kœdji she pa fœ she adœke: «Oro osho kane! Ayi zœ dœ aaya zœ sœ kœpara ɓœ ɓa shu.» ");
INSERT INTO kxf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yisu gi fœ endje adœke: «Œɗe kœdœ ayi mœ a? Œɗe kœdœ aya mœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tshe shokɔ endje á ndje lœ ga atɨ kœdji she karrr, œ pa fœ endje adœke: «'E wu ayi mœ œdœ aaya mœ; endje dá lœ atɨ asœke. ");
INSERT INTO kxf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uzu neke á tshe mbœrœ œneke kɔ á Ndjaba yindœ nœ, uzunœ kœdœ aya mœ, yingɔ mœ œdœ ndje pe ayi mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yisu kpa kwatœ ye ndœ kœyisœ œrœ ɓa tœ mangu Galilayi. Azu ndjoro ngbɔtœ endje tœ kœdji she. Mbœrœ tœnœ ataa, tshe na œ ɔ ga lœ agba á sœ ga atɨ yeka azu ka yaba yaba ga tœ ɔshɔ tœ makaga ungunœ á lœ tœ kœdji she. ");
INSERT INTO kxf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tshe yi lima sœ œrœ ndjoro fœ endje lœ ndœma toro. Lœ kœyisœrœ nœ ye, tshe pa adœke: ");
INSERT INTO kxf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«E dji mœ dœ ɔshɔnœ! Anga uzu bale na lima ndœ kœlu ngwarœ ga lœ kɨndɨ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɓata á tshe sœ kœlu ngwarœ natœnœ, anga indjinœ yo ga ɨndɨrɨ ama awa, ayanu wu œ de. ");
INSERT INTO kxf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Anga indjinœ yo ga lœ oporo badja. Œ ko gbaa, kashe œ totoro kœgerœ tœnœ mbœrœ adœke ɔshɔ mimi tœ oshonœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɓata ɔlɔ tɔ vwege vwege, œ ɔrɔ mbœrœ awa adœke eshenœ li ɔshɔ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Anga indjinœ yo ga lœ ishi. Ishinœ gerœ œ ropa ɔtshɔ ngwarœnœ yé awa adœke œ le gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Anganœ yo ga lœ ɔtshɔ ɔshɔ. Œ ko, œ gerœ dœ ɔtshɔnœ. Œ zu tshelœtœ endje, œ le zazu bale dœ ndjokpa (30), anganœ le zazu votɔ (60), anganœ kama bale (100).» ");
INSERT INTO kxf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yisu pa fœ endje adœke: «Uzu á tshe kœsœ dœ utu kœdji dœ o'o, kaka tshe dji.» ");
INSERT INTO kxf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɔlɔnœ á Yisu gi lima tœ ye tœ azu á sœ kutɨ ye, endje á ndje sœ lima kœna manda ye dœ pe ayambarœ nœ ye ndjokpa dœ bisha gitœ endje ga ɨndɨrɨ ye tœ kœyu she tœ ádá ndœma toronœ á tshe pa má asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yé tshe gi o'o fœ endje adœke: «Mbœrœ e'e, Ndjaba yisœ ádá o'o Ogo gbozu nœ ye á zatœ endje yiwa tœnœ fœ 'e yé, kashe anga azu á ndje lœ ɓa shu, endje dji o'o kɔ kolœ ɓata ndœma toro gbambanœ, ");
INSERT INTO kxf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mbœrœ adœke endje li kœtondœ œrœ dœ ɔtshɔnœ kashe endje wu nene, yé endje li kœdji o'o dœ ɔtshɔnœ kashe endje za tshelœ katanœ kporo nene, ete nene endje fa má tshalɔsu endje yé Ndjaba œ yindœ kœdjerœndœ ekperœ nœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Manda nœ, tshe kpa kœyu endje adœke: «E djidji tshelœ kata ndœma toronœ asœke nene a? Atamœ 'e wu má sœ ádá anga udunœ koto o? ");
INSERT INTO kxf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ayi kœlu ngwarœ nœ asœmœ kœdœ ayi kœyisœ O'o ama Ndjaba fœ azu. ");
INSERT INTO kxf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Anga azu lœ ɓata ama awa. O'o ama Ndjaba na ga ndœ endje ɓata indji ngwarœ á yo ga tœ ala awa. Endje kœdji O'o ama Ndjaba, Satana na œ kakara tœ lɔsu endje. ");
INSERT INTO kxf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Anga azu lœ ndje ɓata indji ngwarœ œneke á yo ga lœ djeere badja. Ɔlɔ á endje kœdji O'o ama Ndjaba, endje yindœ nœ katsha dœ yanga, ");
INSERT INTO kxf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kashe œndœ kœyindœrœ nœ endje œ dɨ nene mbœrœ eshe endje lili ɔshɔ nene. Endje lili kœla banga mbœrœ O'o ama Ndjaba nene œdœ o'o kœna ga ndœ endje yeka á endje ka ngbɨrɨ lœ kœyindœrœ nœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anga azu lœ ɓata indji ngwarœ œneke á yo ga lœ ishi. Endje dji O'o ama Ndjaba dœ ɔtshɔnœ, ");
INSERT INTO kxf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kashe oyo tshapashɔnœ asœke, yanga kœgbɔrœ á sœ kœfara azu, dœ pe tshelœ áká gbetshelœ kɔkɔ á zuzu tœ lɔsu endje. Tœnœ kɔ dá ndɨ tshelœ O'o ama Ndjaba. Mbœrœ tœnœ ataa, awa adœke endje mbœrœ ɔtshɔrœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Anganœ yo ga lœ ɔtshɔ ɔshɔ. Ɔtshɔ ɔshɔnœ kœdœ azu neke á ndje dji O'o ama Ndjaba á gbɔndœ nœ ga tœ lɔsu endje, á matœ endje dœ ɔtshɔ akwa manda kœdji o'onœ. Endje kœdœ ngwarœ neke á gerœ berea berea, œ le zazu bale dœ ndjokpa (30), anganœ zazu votɔ (60), yé anganœ ndje kama bale (100).» ");
INSERT INTO kxf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisu pa fœ endje adœke: «Uzu kœta owo ga tœ miinda, tshe za ga tshakudu lɔsú too ɓa tshakudu kelekpa a? Endje za miinda ɓa pa gbarœ kœza miinda ga panœ, œ sœsœ atamœ nene a? ");
INSERT INTO kxf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kolœnœ ataa, o'o á zatœ endje yiwa tœnœ, œ matœ endje ngbɨɨ dœ eshenœ kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Uzu á tshe kœsœ dœ utu nœ kœdji dœ o'o, kaka tshe dji!» ");
INSERT INTO kxf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yisu kpa mɨndœ nœ fœ endje adœke: «'E gbe dœ o'onœ á 'e dji asœke. Kolœ awa bale ɓata á 'e sœ kœzatœ 'e fœ azu, awa bale Ndjaba œ to ɔtshɔrœ fœ 'e tɔpanœ kpɔlirɔ. ");
INSERT INTO kxf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gbambanœ nene, œshe á tshe kœsœ dœ œrœ ndjoro, endje za anganœ ga pa nœ; tsheneke á tshe kœgugu dœ œrœ nene, endje ko œneke teasho á sœpe tshakane ye.» ");
INSERT INTO kxf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisu kpa pa adœke: «Ogo gbozu nœ Ndjaba sœ ɓata uzu lu ngwarœ ga lœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Uzu á tshe lu ngwarœ lo olo dœ butshɔ œ na ana dœ ɔlɔ. Ɔlɔ kœwuta ngwarœ dœ pe kœgerœ tœnœ, ayi kœlu ngwarœnœ wuwusœ nœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ɔshɔ mbœrœ kotoo á ngwarœ œ gere a? Utshunœ kɔ, ungbu ngwarœnœ œ wuta yekane á manda nœ elenœ œ u. Tœ votɔnœ á kakonœ œ vuru lœ kumunœ yeka á tetœ kœgerœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɔlɔ á elenœ kœgbɔ yeka á azu œ na kœwa tœnœ, kœvere too kœkɔ tœnœ mbœrœ olonœ li ye.» ");
INSERT INTO kxf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisu kpa yu osho adœke: «Ogo gbozu nœ Ndjaba sœ koto o? Ndœma toro gaɗe dá li dœ tœnœ adœke a kœdji a? ");
INSERT INTO kxf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ogo gbozu nœ Ndjaba sœ ɓata ele mutarde. Œ kœdœ kœlu tœnœ, elenœ sœ teasho ga tshakudu leyɔ kɔ pa ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Manda kœlu tœnœ œ kœko, œ zutshelœtœ ye. Œ gerœ tœ ɨngɨrɨnœ kœropa kako dɔngɔ para kɔkɔ lœ kɨndɨ. Ganeanœ œ gboro tœ ɔtshɔnœ kœli adœke ayanu mbœrœ koma endje ga tshakudunœ.» ");
INSERT INTO kxf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisu yisœ œrœ fœ azu lœ ndœma toro ndjoro ɓata œneke mbœrœ adœke endje kœdji ádá o'onœ á œne sœ tœ kœpa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tshe sœ lima kpalakpala kœpa o'o ko dœ ndœma toro kashe endje kœsœ kolœnœ dœ ayambarœ nœ ye yeka á tshe gbara ala o'onœ ngbɨɨ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kolœ dœ ɔlɔnœ asœmœ, dœ ɔgbɔ kɨdala, Yisu pa fœ ayambarœ nœ ye adœke œne zu ga atshi egerœ ungu adanga. ");
INSERT INTO kxf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ataa endje ka lima tœ azu tɨ, œ za Yisu dœ agba neke á tshe sœ lima lœnœ yé anga angbɨ agba lœ lima ɨndɨrɨ nœ. ");
INSERT INTO kxf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɓata á endje sœ lima kœzu ungu, ndavuru yugu za gu tœnœ kpɨkpɨkpɨ. Loko na, yakpa ungu tu yé œ ɔ dœ agba tshé tshé tshé, agba yindœ kœnduru tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisu sœ ɓa tœ budu agba, œ za kumu ye ga pa tɨkumu, œ lo ye. Ayambarœ nœ ye jo she œ pa fœ she adœke: «Ayi kœyisœrœ, á tshu ke a! Ɓœ gbe kotoo dœ œrœ á mbœrœ dœ kumu azœ asœke a?» ");
INSERT INTO kxf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yisu jo lœ olo, œ gbagbara yugu, œ pa fœ ungu adœke: «Tuturu nene! Sœ koko!» Tshelœ yugu wa ngbewo yé osho yi tá. ");
INSERT INTO kxf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yisu yu ayambarœ nœ ye adœke: «Mbœrœ gaɗe awa sœ tœ 'e ata a? 'E gugu dœ kœyindœrœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Uvuru endje i lima gara yeka endje sœ lima kœvwi o'o ugurutœ endje adœke: «Tsheneke kœdœ ɗe yeka á ungu dœ pe yugu kɔ œ dji she atake a?» ");
INSERT INTO kxf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisu dœ ayambarœ nœ ye zu ga tshi Galilayi ɓa tœ ogo nœ Ageresaye. ");
INSERT INTO kxf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kœjerœ kolœ ga atɨ lœ agba atake, anga yakoshe á tshe sœ dœ ekpe ɨshirɨ pa ye to ɓa pa udu akuzu, œ na para tshatshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tshe sœ lima kœsœ sheko ɓa pa udu akuzu yé uzu bale pa ashɔ á tshe li tœ kœi she ga tœnœ gugu nene. Œdœ ndje dœ djingiri gbaa, œ mbœrœ œrœ bale tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mbœrœ kpala kpala endje i lima ada ye dœ uwu aza, œ i kane ye dœ djingiri, kashe tshe sœ kœsɔtshelœ nœ kɔ. Ayi gbɔgbɔ á tshe li tœ kœza she para adœke tshe kœmɔ too gugu bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Butshɔ dœ ɔlɔ kɔ, tshe sœ lima kœsœ waa ɓa pa udu akuzu œdœ pe ɓa pa kaga kœta rawa œdœ kœgbi kotœ ye dœ badja. ");
INSERT INTO kxf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɓata á tshe wu Yisu lœ ɨngɨrɨnœ, tshe kpa dœ ɔrɔ œ gote ga utshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Œ ve rawa dœ ɔgbɔ adœke: «Yisu Gbolo nœ Ndjaba ɓa lafo, ɓœ yindœ kœmbœrœ gaɗe tœ mœ a? Mœ kɨ fœ ɓœ dœ ɨ'ɨrɨ Ndjaba adœke ɓœ gágága kumu mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tshe kɨ lima ataa mbœrœ Yisu pa lima fœ she adœke: «Ekpe ɨshirɨ, wuta lœ uzunœ asœke!» ");
INSERT INTO kxf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yé Yisu yu she adœke: «Ɨ'ɨrɨ zœ kœdœ ɗe?» Tshe gi fœ she adœke: «Ɨ'ɨrɨ mœ kœdœ Kœngba, gbambanœ nene 'a sœ azu ndjoro.» ");
INSERT INTO kxf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tshe kɨ dœ ɔgbɔ, œ pa fœ Yisu adœke tshe vwavwa œne ga lœ angbɨ ogo nene. ");
INSERT INTO kxf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Egerœ ukpulu akɔso lœ lima kœzɨrœ tœ ada kaga. ");
INSERT INTO kxf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Atamœ ekpe ɨshirɨnœ kɨ fœ Yisu adœke: «Vwa 'a dœ́ 'a na œ li ga lœ akɔso.» ");
INSERT INTO kxf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yisu za awa fœ endje yé endje wuta lœ uzunœ, œ kpa œ li ga lœ ukpulu akɔso. Endje lœ lima kutu bisha (2.000) á to ɓa pa kaga yeka á tara uru uru gu ga la ngu, á nduru kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aayi kœgbɔndœ akɔsonœ kpagu lima dœ ɔrɔ ndœ kœpandœ œsœ œrœ á mbœrœtœ endje fœ azu lœ kɨndɨ wuta tœnœ kpaa ga lakpɨ, yé azu ndjoro na lima ndœ kœwu œrœnœ á wuta asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Endje na ndoo dœ Yisu á wu yakoshenœ á tshe sœ lima dœ aekpe ɨshirɨ ndjoro pa ye asœmœ. Tshe sœ kpakparakpa dœ budu ye ga atɨ, œ verœ lœba ga tœ ye á sœ ko ko ko. Awa za azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Azu á ndje wu lima œrœ á mbœrœ fœ uzunœ á ekpe ɨshirɨnœ sœ lima pa ye œdœ pe tœ upu nœ akɔsonœ asœmœ, mɨndœ œsœnœ fœ anga endje. ");
INSERT INTO kxf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Endje kɨ ga tœ Yisu adœke tshe gitœ ye lœ ogo nœ œne ye. ");
INSERT INTO kxf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kœgu Yisu ndœ kœɔ ga lœ agba, uzu ekpe ɨshirɨ sœmœ kɨ ga tœ ye adœke œdœ tshe kœyindœ nœ œne gu dœ she awa bale. ");
INSERT INTO kxf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kashe Yisu yiyindœ nœ nene á pa fœ she adœke: «Gu ga ndœ ayo zœ, œ pandœ œneke á Gbozu Ndjaba wu oyo zœ á mbœrœ fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yakoshenœ gu lima œ tetœ kœmɨndœ œneke kɔ á Yisu mbœrœ fœ she tara tœnœ ngbɔlɔɔ lœ ogo á ɨ'ɨrɨnœ kœdœ Tshalakpɨ Ndjokpa. Œ fa o'o gooo na tœnœ lœ ama azu kɔ yi kumu anda yi budu nœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu kpa zu ungu dœ agba. Kœwuta she ɓa atshinœ ataa, azu ngbɔtœ endje ndjoro dji she ɓa tœ makaga ungunœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Anga gbozu tshapa Sinagoga á ɨ'ɨrɨ ye kœdœ Jaeruse na, œ wu Yisu, œ gote ga utshu ye, ");
INSERT INTO kxf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","á kɨ ga tœ ye adœke: «Yawuru nœ mœ ndo dœ kuzu. Wu oyo mœ dœ́ œ to kane zœ ga pa ye, tshe she œ sœ dœ soro.» ");
INSERT INTO kxf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yisu yindœ nœ, œ gu tœ awa bale dœ she. Azu ndjoro te manda ye œ sœ kœgoro she na tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Anga yashe bale dœ koɓa indji sœ ndje lima ugurutœ azunœ. Tshe lo lima dœ koɓa indjinœ ungu ndjokpa dœ bisha, ");
INSERT INTO kxf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","tshe wu oyo kœkɔrɔ tœ awa azu kœshe she yé œ ndɨ ngendja nœ ye kɔkɔ gbambanœ. Koɓanœ kpa oma dœ ɔgbɔnœ, ga pa nœ dœmœ tshelœ akɔ ye kakara nene. ");
INSERT INTO kxf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tshe dji ndœ œsœ Yisu, œ na ga lœ oporo tœ azu. Œ gba dœ ɔgɔ ye œrrr á goro lœba nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mbœrœ tshe gbe lima adœke: «Œdœ mœ kœgoro kolœ lœba nœ ye, koɓa nœ mœ œ ka.» ");
INSERT INTO kxf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Petœ œsœnœ koɓa indji nœ ye voro kpa yé tshe wusœ nœ adœke œne she ye. ");
INSERT INTO kxf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Trale Yisu wu lima adœke anga gbɔgbɔ wuta lœ œne. Á fatœ ye karrr á yu osho adœke: «Œɗe dá turutœ lœba mœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ayambarœ nœ ye gi o'o fœ she adœke: «Ɓœ wuwu azu ndjoro á ndje sœ kœro dara ɓœ asœke nene yeka á yu 'a adœke œɗe dá turutœ lœba nœ zœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ataa gbaa, Yisu para osho djitœ ye tshakpata kœwu uzu á tshe mbœrœ œrœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yashe koɓanœ de gbara gbara gbara dœ awa mbœrœ á tshe wusœ œrœ á mbœrœtœ endje fœ she. Tshe na œ te ga utshu Yisu œ pandœ adja o'o kɔ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yisu pa fœ she adœke: «Gbolo nœ mœ, kœyindœrœ nœ zœ she ɓœ ye; gu dœ ɔtshɔnœ. Koɓa nœ zœ ka ye.» ");
INSERT INTO kxf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Damba o'o sœpe lœma Yisu, azu to ɓa sœnda nœ gbozu Jaeruse, œ pa fœ she adœke: «Gbolo yawuru nœ zœ tshu ye. Ádá kœndanga ayi kœyisœrœ kœdœ gaɗe?» ");
INSERT INTO kxf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kashe Yisu gbegbe dœ o'onœ asœmœ nene, œ pa fœ Jaeruse adœke: «Awa zaza ɓœ nene, sœ kolœ dœ kœyindœrœ.» ");
INSERT INTO kxf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tshe pakata udu azu kɔ kœna dœ she, œ za awa kolœ fœ Petro, dœ Jake œdœ pe ayanœ dœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kœwuta endje ɓa sœnda nœ Jaeruse, Yisu wu ɨgbɨ, œ dji tshama azu ndjoro kœkɨ dœ rawa dœ ɔgbɔnœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tshe li ga sœndanœ, œ yu endje adœke: «Ádá ɨkɨ dœ rawa nœ 'e kœdœ gaɗe? Gbolonœ tshutshu nene, tshe sœ tœ olo.» ");
INSERT INTO kxf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Endje tetœ kœmɔ she. Tshe gɔrɔ endje kɔ ga ushu, œ sœpe kolœ dœ aba gbolo, dœ ayinœ œdœ pe dœ ayambarœ nœ ye votɔ. Endje li ɓa tœ osho á oko gbolonœ sœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tshe to kane ye ga pa gbolonœ, œ e she adœke: «Talita kumi!» (Ádánœ adœke: «Yawuru, mœ pa fœ ɓœ adœke ɓœ áalafo!») ");
INSERT INTO kxf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Trale gbolo áafo œ tetœ ana (gbolo nœ ungu ndjokpa dœ bisha). Azu wu atamœ, œ te o'o gooo lœ ama endje natœnœ djezœ. ");
INSERT INTO kxf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kashe Yisu kɔ endje dœ ɔgbɔ adœke endje papandœ nœ fœ uzu bale nene. Tshe pa fœ endje adœke endje para kœzɨrœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisu katœ oshonœ asœmœ tɨ œ gu ga lakpɨ á tshe gerœ lœnœ yé ayambarœ nœ ye na manda ye. ");
INSERT INTO kxf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dœ lɔkɔ sabata, tshe tetœ kœyisœ œrœ ɓa lœ Sinagoga. Œ za awa fœ azu ndjoro á ndje sœ kœdji she, yé endje yu osho adœke: «Asœke kpa to kpœta a? Tshe kpa gbɔ kœwusœrœ œneke ɓa ndœ ɗe? Tshe gbɔ awa afá neke ɓata ma a? ");
INSERT INTO kxf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Œ dœ́dœ́ she kœdœ ayi kœguma maɓaya nene a, gbolo nœ Mareya, aya Jake, dœ Joze, dœ Shimu œdœ ndje Yuda nene a? Ayingɔnœ lœlœ kpœ ndœ azœ kpœke nene a?» Mbœrœ tœnœ ataa, endje vwara lima tœ endje tœ kœsœ dœ kœyindœrœ ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeka á Yisu gi o'o fœ endje adœke: «Endje lɨsœ́ ayi kœgbara o'o tœ osho kɔ. Kolœ ɓa sœnda nœ ye, ugurutœ ayanœ dœ ayingɔnœ, lœ mara ye dá endje lɨlɨsœ́ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yisu lili lima kœmbœrœ afá lœ Nazarete nene. Kolœ gbadjagara anga azu á ndje sœ dœ koɓa dá tshe to kane ye ga pa endje á endje she kɔ lœ koɓa nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yé ɔgbɔ lɔsu nœ endje za lima awa fœ Yisu waa. Manda nœ, Yisu na kœyisœrœ djelœ ogo kɔ á lœ dje ɨndɨrɨ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tshe e ayambarœ nœ ye ndjokpa dœ bisha, œ tetœ kœvwa endje bisha dœ bisha, œ za gbɔgbɔ kœropa ekpe ɨshirɨ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Œ za o'o fœ endje adœke: «'E zaza œrœ potœ 'e lœ ananœ nene, 'e za kolœ tshɔngbɔlɔ bale. Œdœ rœgo, œdœ ngbade too ngendja, 'e zaza œrœ bale ga lœ uwu tœ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'E verœ œrada nœ 'e ga tœ ada 'e kashe 'e koko lœba bisha nene.» ");
INSERT INTO kxf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tshe kpa pa fœ endje adœke: «Œ kœsœ adœke 'e wuta ɓa lakpɨ ogo bale, 'e lo kolœ lœ anda á ndje yisœ nœ fœ 'e œrrr ga tœ ɔlɔ á 'e katœ tshakpœtœmœ tɨ. ");
INSERT INTO kxf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Á œ kœsœ ndje adœke anga azu tshalakpɨ bale kœvwaratœ endje tœ kœza osho kœsœ fœ 'e too tœ kœdji o'o ama 'e; 'e katœ tshalakpɨnœ tɨ. Tœ kœma fœ endje adœke endje mbœrœ ekperœ, 'e gɔrɔ trusha tshada 'e tɨ kpœtœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ayambarœ nœ ye na kœyisœrœ fœ azu adœke: «'E fatshalɔsu 'e.» ");
INSERT INTO kxf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Endje gɔrɔ lima ekpe ɨshirɨ ndjoro pa azu, yé œ tá kada ga tœ aayi koɓa ndjoro á she endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dœ lɔndɔnœ asœmœ, gbozugo Erode dji o'o dœ ɨ'ɨrɨ Yisu mbœrœ ɨ'ɨrɨ ye za osho kɔ. Endje gbe lima tœ ye adœke: «Yowane ayi kœza batisimu dá wuta lœ akuzu, ádánœ á tshe sœ dœ gbɔgbɔ tœ kœfa œrœ dœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Anga endje adœke: «Eliya dœmœ.» Yé ɨlɨ udu endje pa œnœ endje adœke: «Tshe kœdœ ayi kœgbara o'o ama Ndjaba ɓata ongboro anga endje á ndje gbara lima utshunœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erode dji o'onœ ataa œ pa ngbewo adœke: «Adja Yowane ayi kœza batisimu á mœ wa lima ɨgɨ ye dá wuta lœ akuzu asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erode vwa lima aturugu nœ ye adœke endje za she œ i she dœ djingiri, yé œ vwi she ga lœ kánga mbœrœ upu nœ Erodiade, awo ayanœ dœ Filipo á tshe to lima she. ");
INSERT INTO kxf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gbambanœ nene, Yowane pa lima fœ Erode adœke: «Œ lili dœ ɓœ adœke ɓœ ka ga tœ awo aya zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mbœrœ o'onœ asœke, Erodiade za lima ókó Yowane ga lœ ye, œ yi lima ndœ kœwo she kashe awa gugu damba lima tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Gbambanœ nene, Erode sœ lima kœlɨsœ Yowane mbœrœ tshe wu lima sœnœ adœke tshe kœdœ uzu á tshe sœ ndjii œdœ yerœ, yé tshe sœ lima kœgbɔndœ ye. Dœ lɔndɔ á Erode kœsœ lima kœdji Yowane, tshe wuwu lima sœ œrœ kœmbœrœ tœnœ nene. Ataa atamœ ndje gbaa, tshe sœ lima dœ ogo kœdji she. ");
INSERT INTO kxf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Andaa anga olo bale, awa kɔrɔ fœ Erodiade dœ lɔkɔ angbo kœzu Erode. Erode e angbo kœgbe dœ olo kœzu she. Tshe e agbozu kumu akwa nœ ye dœ pe endje nœ tshapa aturugu œdœ ndje pe agbozu tshapa ogo Galilayi á kœkurutshelœ yanga nœ ye dœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yawuru nœ Erodiade li ɓa sœnda, œ vitœ ye yé œ ga tœ Erode dœ azu á tshe e endje ndœ angbonœ tɔpanœ kpuru. Á gbozugo Erode pa fœ yawuru sœmœ adœke: «Yɔndœ œrœ kɔ á ɓœ yindœ nœ, dœ mœ za fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Erode wa ɨgɨ ye dœ ɔshɔ adœke: «Œrœ neke kɔ á ɓœ e osho ndœ nœ, mœ ko fœ ɓœ. Œdœ ɓœ kœgbe ndje dœ tshakala ogo á mœ sœ pa nœ, mœ wa fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yawuru wuta œ yu ayinœ adœke: «Œrœ gaɗe dá mœ kœ'e osho ndœ nœ a?» Ayinœ gi fœ she adœke: «E osho ndœ kumu Yowane, ayi kœza batisimu.» ");
INSERT INTO kxf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yawuru gbɔgbɔtœ ye wuta tœnœ ga tshatshu gbozugo Erode, œ pa fœ she adœke: «Mœ yindœ nœ adœke ɓœ za kumu Yowane, ayi kœza batisimu ga lœ kalango ngɔngɔ asœke fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Œ za lima oyo tœ lɔsu Erode tœ kœdji ata. Yé awa kœfa o'o gugu lima nene mbœrœ á tshe wa lima ɨgɨ ye utshu azu kɔ á tshe e lima endje ndœ angbo nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pe kpœtœmœ, tshe vwa anga turugu adœke tshe na œ gu dœ kumu Yowane fœ œne. Turugunœ na ɓa lœ kánga, œ wa ɨgɨ Yowane, ");
INSERT INTO kxf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","œ za kumu ye ga lœ kalango, œ gu dœ tœnœ fœ yawurunœ á tshe za fœ ayinœ. ");
INSERT INTO kxf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ayambarœ nœ Yowane dji o'onœ atamœ, œ na œ za oko ye á shi ɓa lœ udu. ");
INSERT INTO kxf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aayi avwanœ fatœ endje gu ga ndœ Yisu, œ pandœ œneke kɔ á ndje mbœrœ lœ ana kœyisœrœ nœ endje kɔ fœ she. ");
INSERT INTO kxf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yisu pa fœ endje adœke: «'E nɔtœ 'e ngerrr ga mabunœ œ yatœ 'e teasho kane.» Mbœrœ azu lœ lima kœdaratœ endje tɔpanœ kpuru, anga ndje kœna anga ndje kœgu á awa adœke Yisu dœ ayambarœ nœ ye yi anga œrœ hiaru ga lœ ama endje gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Endje ɔ ga lœ agba, œ gitœ endje ga tœ osho á azu gugu lima tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Azu ndjoro wu endje kœna tœnœ atamœ, œ vwanga endje dœ ada endje yé á wuta ɓa tœ oshonœ á endje sœ kœna ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kœjerœ Yisu lœ agba atake, tshe wu azu ndjoro, œ za oyo fœ she tœ lɔsu ye mbœrœ endje sœ ɓata apata neke á ayengɔ endje gugu nene, á tshe tetœ kœyisœ œrœ ndjoro fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɓata ɔlɔ ro ye, ayambarœ nœ ye gitœ endje ndoo dœ she, œ pa fœ she adœke: «Orosho, asœ kœdœ tshelœ kpagagasho, ɔlɔ ro yé a lœpe kpœke. ");
INSERT INTO kxf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pandœ nœ fœ azunœ ndjoro asœke adœke endje wuta ga lakpɨ too ga lœ kɨndɨ ɨndɨrɨ tœ azœ œ para kœzɨrœ.» ");
INSERT INTO kxf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yé Yisu gi fœ endje adœke: «'E para rœgo dœ tœ 'e á kœto fœ endje.» Endje pa fœ she adœke: «Ɓœ yindœ nœ adœke a na œ yɔ mapa ndœ denari kama bisha yekane á kœto fœ endje a?» ");
INSERT INTO kxf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Á Yisu kœyu endje adœke: «'E sœ dœ mapa kotoo? 'E na dœ́ wu kane.» Endje na œ dɨ, œ pa fœ she adœke: «A sœ dœ mapa mindu dœ ageatshalangu bisha.» ");
INSERT INTO kxf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yisu pa fœ ayambarœ nœ ye adœke: «'E pa fœ endje adœke endje kputœ endje ga atɨ ga pa gusu.» ");
INSERT INTO kxf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Endje lœ ga atɨ œ kputœ endje ga tœnœ kama bale (100), anga endje zazu bisha dœ ndjokpa (50). ");
INSERT INTO kxf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yisu ko mapa sœmœ mindu dœ pe ageatshalangu bisha asœmœ, œ me sho ga lafo œ kɨ fœ Ndjaba. Tshe kavwa tshelœ mapanœ, œ ko fœ ayambarœ nœ ye adœke endje kurutshelœnœ tœ azunœ. Tshe kuru ndje tshelœ ageatshalangunœ bisha asœmœ tœ azu kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Azu kɔkɔ zɨ yé uvu endje sú. ");
INSERT INTO kxf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ayambarœnœ ngbɔɓa udu rœgonœ á sœpe lima manda endje ga lœ kingi ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ayakoshe á ndje zɨ lima œrœnœ lœ kutu mindu (5.000). ");
INSERT INTO kxf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hara manda nœ, Yisu vwa ayambarœ nœ ye kpa kœɔ ga lœ agba kœzu utshunœ á kœkate she ɓa ɨtshi ungu ɓa tœ awa tshalakpɨ Betesayida; œ gi udu azu kɔ ga tœ ogo endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Manda kœkatœ endje tɨ, tshe ɔ ga pa kaga ndœ kœkɨ fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kœwuta ga tœ adɨla, agba lœ lima ɓa uguru ungu, yé Yisu sœ kutɨ ye ɓa tœ ama ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tshe wu lima adœke kœi kayi li lima tœ ayambarœ nœ ye mbœrœ yugu to ɓa utshu endje á sœ kœgi endje ga manda nœ. Lœ gurutsha, Yisu na pa ungu dœ ada ye gu tœnœ ga ndœ endje, yé á yindœ kœro endje voro. ");
INSERT INTO kxf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kœwu she kœna pa ungunœ ataa, endje gbe adœke anga ngandoro azu dœmœ á yi ama endje lœ rawa. ");
INSERT INTO kxf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Manda nœ, endje wu she kporo yé awa litœ endje. Trale, Yisu vwa o'o fœ endje adœke: «Lɔsu 'e sœ zɨtɨ; awa mbœmbœrœ 'e nene. Œmœ kœsœ!» ");
INSERT INTO kxf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tshe gitœ ye ndo dœ endje, œ ɔ ga lœ agbanœ yé yugu ka ngbewo. Œ za lima awa fœ endje tɔpanœ kpuru, ");
INSERT INTO kxf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mbœrœ adœke endje wuwusœ tshelœ kata œrœ á tshe mbœrœ adœke mapa gu kpɔɔ nene, mbœrœ ɔgbɔ lɔsu nœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Manda kœzu ungunœ, endje du agba ga tœ mangu, œ wuta ga lakpɨ ogo Genazarete. ");
INSERT INTO kxf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kœjerœ endje kolœ lœ agba ataa, azu gbɔ Yisu kpɔ, ");
INSERT INTO kxf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","œ za ɔrɔ kpatœnœ ndœ kœrɔ ayi koɓa lakpɨ para, œ ko endje dœ kelekpa kpagu tœnœ ga tœ osho á Yisu sœ lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Osho kɔ á Yisu sœ lima kœna tœnœ, œdœ lœ aya ogo too lœ egerœ ogo too ndje ga ɨndɨrɨnœ; endje sœ lima kœko ayi koɓa ga tœ ala awa, kœkɨ fœ Yisu adœke tshe za awa fœ endje adœke ndje goro amba ama lœba ye. Yé, endje para kɔkɔ á ndje goro lima lœba ye, endje she. ");
INSERT INTO kxf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɔlɔ bale, Afarisayi dœ pe anga aayi kœyisœ awa akwa á ndje to ɓa lœ Yerusaleme ngbɔtœ endje dji Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Endje wu anga ayambarœ nœ Yisu kœzɨ œrœ dœ uburu, œ yindœ kœpa adœke endje djudjutɔ kane endje nene. ");
INSERT INTO kxf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ádánœ adœke, Afarisayi dœ pe udu Ayuda kɔ zɨzɨ œrœ utshu kœdjutɔ kane endje kpaa ɓa tœ dingini endje nene. Œtœnœ kœdœ o'o á endje gbɔ manda aata endje. ");
INSERT INTO kxf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Œdœ endje kœto ɓa lœ zando á kœgu, utshu kœzɨrœ, œ li adœke endje djutɔ kane endje yeka. Endje lœpe ndje kœgbɔndœ ata o'o aata endje ndjoro ɓata: mara kœdjutɔ tshelœ yashi dœ pe lɔsú, œdœ ndje gbarœ á ndje mbœrœ dœ wola kowo. ");
INSERT INTO kxf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ádánœ ataa á Afarisayi dœ aayi kœyisœ awa akwanœ yu Yisu adœke: «Mbœrœ gaɗe á ayambarœ nœ zœ za o'o ama aata ndje tɨ yé á zɨ œrœ dœ uburu tœ kane endje ma a?» ");
INSERT INTO kxf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yisu gi fœ endje adœke: «Isaya gbara lima o'o dœ ádá 'e adœke 'e kœdœ awulapatshɔ, á su liya la Buku nœ Ndjaba adœke: “Azunœ asœke donga mœ kolœ lœ ama endje gbambanœ, kashe ɓa tœ lɔsu endje, endje yiyindœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Endje wu oyo kœdonga mœ gbambanœ mbœrœ endje sœ kœyisœ adja œrœ á to ɓa ndœ azu.”» ");
INSERT INTO kxf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yé Yisu pa fœ endje adœke: «'E za awa o'o nœ Ndjaba vwi'i, œ ga kolœ kœpa o'o á to ɓa lœ ama azuzu.» ");
INSERT INTO kxf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yé tshe kpa pa adœke: «'E katœ kœlɨsœ awa o'o nœ Ndjaba kolœ mbœrœ kœyɔrɔndœ o'o á to ɓa lœ ama 'e dœ tœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gbambanœ nene, Moyize pa lima adœke: “Kpa awa aba zœ dœ ayi zœ,” ndje adœke: “Uzu á tshe kœgu œsœ abanœ dœ ayinœ, endje wo she ye.” ");
INSERT INTO kxf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kashe ɓa ndœ 'e, œ kœsœ adœke uzu pa fœ abanœ dœ ayinœ adœke: “Œrœ á mœ yi má ndœ kœza fœ 'e kœdœ korba, mœ gbɔndœ nœ fœ Ndjaba”, ");
INSERT INTO kxf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'e kpa zaza awa fœ she kœmbœrœ œrœ bale fœ abanœ dœ ayinœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ataa, 'e sœ kœgbatshelœ o'o ama Ndjaba mbœrœ o'o ama aata 'e á 'e lœ tœ kœyisœ nœ. Awa bale ndje dœ anga œrœ ndjoro a 'e lœpe kœmbœrœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yisu kpa e azu ndjoro á pa fœ endje adœke: «E'e kɔ 'e dji mœ dœ ɔtshɔnœ yé 'e wusœ nœ adœke, ");
INSERT INTO kxf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","œ dœ́dœ́ œrœ á to ɓa shu á li ga lœ uzu dá ma she tœ ayi uburu nene kashe œneke kɔ á to ɓa tœ lɔsu uzu á wuta dá ma she tœ ayi uburu.  ");
INSERT INTO kxf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Uzu á tshe kœsœ dœ utu ndœ kœdji o'o, tshe dji.» ");
INSERT INTO kxf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yisu katœ azunœ tɨ œ li ga sœnda. Ayambarœ nœ ye tetœ kœyutœ endje ugurutœ endje tœ ádá o'o á tshe wuta má kœpa tœnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tshe gi o'o fœ endje adœke: «E'e ndje, 'e gugu dœ kœwusœrœ ndœ kœdji dœ tshelœ kata o'onœ asœke nene a? 'E wuwusœ nœ damba nene adœke œrœ kɔ á to ɓa shu á li ga lœ uzu fafa uzu tœ ayi uburu nene na a? ");
INSERT INTO kxf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Œneke á to ɓa shu lili ga lɔsu uzu nene, œ li ga lœ uvu yé manda nœ œ wuta lœ ɔkɔ ye ga ushu.» Tshe yi lima ndœ kœma adœke kœzɨrœ bale á dœ uburu gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yisu kpa pa adœke: «O'o á sœ ɓa lœ uzu, œ kœwuta ga ushu dá ma uzunœ tœ ayi uburu. ");
INSERT INTO kxf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mbœrœ adœke tshelœ uzu kœdœ tshalɔsu ye, osho á gbetshelœ kɔ œ wuta tœ kœmbœrœ dœ œrœ ɓata ngbɨndɨrœ, kœzɨ angba, kœwo azu, ");
INSERT INTO kxf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kœpara awo azu too akɔ azu, kœsœ dœ ogo œrœ nœ anga azœ, ókó, kœfara osho, djingili, úkú, kœgu osho, kœzatœ osho, œdœ ndje pe kœmbœrœ ɔgbɔrœ. ");
INSERT INTO kxf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ambárá œrœnœ asœke kɔkɔ kœwuta lœ uzu yeka á ma she tœ ayi uburu.» ");
INSERT INTO kxf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisu áalafo lakpɨnœ asœmœ œ gitœ ye ga lœ ogo á sœ ndoo dœ tshalakpɨ Tire. Tshe li ga sœnda anga anda bale mbœrœ tshe yindœ nœ adœke uzu bale wusœ nœ adœke œne sœ kpœtœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ataa, anga yashe bale á gbolo nœ ye sœ dœ ekpe ɨshirɨ pa ye, djindœ ye œ na kœgote ga utshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yashe sœmœ dœ́dœ́ yuda nene, tshe kœdœ uzu tshalakpɨ Fenisi ɓa lœ ogo Siri. Tshe kɨ fœ Yisu adœke tshe gɔrɔ ekpe ɨshirɨ pa yawuru nœ œne. ");
INSERT INTO kxf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kashe Yisu pa fœ she adœke: «Kaka damba adœke agbolo zɨ œrœ uvu ndje su yekane, mbœrœ œ sœsœ dœ ɔtshɔnœ nene kœkakara kœzɨrœ nœ agbolo á kœko va fœ ayavoro.» ");
INSERT INTO kxf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yashe sœmœ gi fœ she adœke: «Gbozu, œdœ adja o'o. Kashe ayavoro zɨ œrœ á yo tœ ama agbolo ga tshakudu ndaba.» ");
INSERT INTO kxf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yé Yisu gi fœ she adœke: «Mbœrœ o'o á ɓœ pa asœke, gu dœ ɔtshɔnœ. Ekpe ɨshirɨnœ gitœ ye pa gbolo nœ zœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kœgu she kœwuta ɓa sœnda nœ ye atake, tshe wu adœke gbolo nœ ye má lo ga pa kelekpa, yé ekpe ɨshirɨ gi ɓa mámá tœ ye pa ye yé. ");
INSERT INTO kxf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisu wuta lœ ogonœ á sœ ndoo dœ Tire, œ vwanga tɔ lœ Sidona kœgu ndœ mangu Galilayi ɓa uguru ogo á ɨ'ɨrɨnœ kœdœ Tshalakpɨ Ndjokpa. ");
INSERT INTO kxf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Endje na ga ndœ ye dœ anga uzu bale á utu ye be yé á tshe sœsœ kœpa o'o nene. Endje kɨ ga tœ ye adœke tshe to kane ye ga pa ye. ");
INSERT INTO kxf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yisu gi she zara tœ azunœ, œ yi yakɔne ye ga lœ utu ye, œ tu ngusha œ goro dœ tima ye. ");
INSERT INTO kxf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Manda nœ, tshe mesho ga lafo, œ wu faa œ pa adœke: «Efata!» Œ yindœ kœpa adœke: «Kɔrɔ!» ");
INSERT INTO kxf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kolœ tœ farapu, utu ye bibisha kɔrɔ ngbɨɨ yé tshe pa o'o tœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yisu kɔ endje adœke endje mɨmɨndœ nœ fœ uzu bale nene. Atamœ gbaa, endje mɨ tshelœ o'onœ ngele ngele ngele natœnœ djezœ. ");
INSERT INTO kxf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Œ za awa tœ azu kɔ á endje pa adœke: «Œneke kɔ á tshe sœ kœmbœrœ tœnœ sœ dœ ɔtshɔnœ! Tshe sœ kœkɔrɔ ogoro utu ayi bitu, œ sœ kœmbœrœ adœke endjeneke á ndje papa o'o nene, pa o'o.» ");
INSERT INTO kxf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dœ ɔlɔnœ asœmœ, azu kpa ngbɔtœ endje lima dji Yisu. Kœwu adœke kœzɨrœ gugu mbœrœ endje nene, tshe e ayambarœ nœ ye œ pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Oyo azunœ asœke ká mœ waa, mbœrœ a lo dœ endje olo votɔ yé endje gugu dœ kœzɨrœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Œdœ mœ kœgi endje ga ndœ endje dœ ogo ataa, endje mbombo tœ ala awa mbœrœ anga endje ugurunœ to lœ ɨngɨrɨnœ waa.» ");
INSERT INTO kxf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ayambarœ nœ ye gi fœ she adœke: «A gbɔ má rœgo lœ kpagagashonœ asœke kpœta yekane á kœto fœ endje á endje kœzɨ á kœle endje a?» ");
INSERT INTO kxf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yisu yu endje adœke: «'E sœ dœ mapa kotoo?» Endje gi fœ she adœke: «Mindu dœ bisha.» ");
INSERT INTO kxf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yisu fatœ ye œ pa fœ azunœ ndjoro asœmœ adœke endje lœ ga atɨ ga tœ ɔshɔ. Tshe ko mapanœ mindu dœ bisha (7) asœmœ, œ donga Ndjaba, œ kavwa tshelœ nœ, œ ko fœ ayambarœ nœ ye adœke endje kurutshelœ nœ tœ azunœ. ");
INSERT INTO kxf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Endje lœ ndje dœ a'eara ageatshalangu. Yisu donga Ndjaba ndje mbœrœ a'eara ageatshalangu sœmœ, œ pa fœ endje adœke endje kurutshelœ nœ tœ azunœ. ");
INSERT INTO kxf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Azu para kɔkɔ zɨ, œ le ndje œ le. Ayambarœ rɔ ama udu rœgo á sœpe ga lœ kingi mindu dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Azu sœ lima tœ œsœnœ kutu vana. Yisu pa fœ endje adœke uzu dœ uzu gu ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Trale manda nœ, Yisu ɔ ga lœ agba dœ ayambarœ nœ ye tœ kœgu ga lœ ogo Dalmanuta. ");
INSERT INTO kxf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarisayi na ga ndœ Yisu œ tetœ kœpu lœma endje dœ she mbœrœ kœwu lɔsu ye. Endje yu she adœke tshe yisœ anga ambárá œrœ tœ kœma adœke gbɔgbɔ ye to ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yisu wu faa dœ oyo tœ lɔsu ye œ pa adœke: «Mbœrœ gaɗe azu nœ tshakpesheke œ e osho ndœ ambárá! Mœ pa dœ adjapu fœ 'e adœke Ndjaba œ yisœ ambárá bale fœ 'e dœ azu oshonœ asœke nene.» ");
INSERT INTO kxf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tshe kwatœ ye œ katœ endje tɨ, œ ɔ ga lœ agba tœ kœzu ga ɨtshi ungu. ");
INSERT INTO kxf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ayambarœ nœ Yisu djerœndœ kœko kœzɨrœ, œ sœ kolœ dœ mapa bale lœ agba. ");
INSERT INTO kxf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yisu mɨ upu fœ endje adœke: «Ala 'e gbɔ dœ ɔyɔ kœsuku mapa nœ Afarisayi dœ pe ndje œnœ azu nœ Erode kane.» ");
INSERT INTO kxf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ayambarœnœ pa o'o ugurutœ endje adœke: «Tshe sœ kœpa atamœ mbœrœ a gugu dœ mapa nene a!» ");
INSERT INTO kxf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Œ mbœrœ adœke Yisu wu lima sœ nœ á yu endje adœke: «Mbœrœ gaɗe á 'e yutœ 'e ugurutœ 'e adœke 'e gugu dœ mapa nene a? Damba œrrr kpesheke 'e wuwusœ œrœ nene a? Ala 'e kɔkɔrɔ damba nene a? ");
INSERT INTO kxf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","'E lœ dœ ala yeka á wuwu dœ œrœ nene a? Œ lœ dœ utu yeka á djidji dœ o'o nene a? Œndœ œrœ kɔ á mœ mbœrœ djerœ 'e ye a? ");
INSERT INTO kxf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ɔlɔnœ á mœ kavwa lima tshelœ mapa mindu kœto fœ azu kutu mindu (5.000), kingi kotoo á sú dœ udunœ á sœ pe liya a?» Endje gi fœ she: «Ndjokpa dœ bisha.» ");
INSERT INTO kxf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yisu kpa yu adœke: «Ɔlɔnœ á mœ kavwa lima tshelœ mapa mindu dœ bisha (7) ndœ kœto fœ azu kutu vana, kingi kotoo á su dœ udunœ á sœpe liya a?» Endje gi fœ she: «Kingi mindu dœ bisha (7).» ");
INSERT INTO kxf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeka á Yisu pa fœ endje adœke: «Damba 'e wuwusœ œrœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yisu dœ ayambarœ nœ ye wuta ɓa lœ Betesayida. Ɓa zœ endje na dœ anga uzu á ala ye bu, œ kɨ fœ she adœke tshe goro she. ");
INSERT INTO kxf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yisu za kane ye, œ wuta dœ she lakpɨnœ. Tshe tu ngusha ga la ye, œ to kane ye ga pa ye á yu she adœke: «Ɓœ wu gaɗe?» ");
INSERT INTO kxf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ayibula gi fœ she adœke: «Mœ sœ kœwu azu, mœ wu endje ɓata ɔyɔ á sœ tœ ana.» ");
INSERT INTO kxf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yisu kpa goro ala ye, ngbewo tshe she œ te kœwu œrœ kɔ tœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yé Yisu za awa fœ she kœgu ga ndœ ye kashe ngbɔlɔɔ lakpɨ nene. ");
INSERT INTO kxf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisu dœ ayambarœ nœ ye na ga lœ a'eara ogo á sœ dji ɨndɨrɨ Sezaré, ogo gbozu Filipo. Tshe yu endje tœ awa adœke: «Azu sœ kœpa má adœke œmœ kœdœ ɗe?» ");
INSERT INTO kxf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Endje gi fœ she adœke: «Azu pa adœke œɓœ kœdœ Yowane, ayi kœza batisimu, anga endje adœke œɓœ kœdœ Eliya; anga udu endje pa œnœ endje adœke œɓœ kœdœ ongboro anga ayi kœgbara o'o.» ");
INSERT INTO kxf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Atamœ sœmœ, 'e gbe má œnœ 'e adœke œmœ kœdœ má œnœ mœ uzu ɗe? A Petro gi fœ she adœke: «Œɓœ kœdœ Masiya.» ");
INSERT INTO kxf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yisu va tshelœ utu endje lœ ubunœ adœke endje papandœ nœ fœ uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Manda nœ, Yisu tetœ kœyisœ œrœ fœ ayambarœ nœ ye adœke: «Gbolo nœ uzu œ wu oyo waa. Agbɔ Ayuda, agbozu tshapa anganga Ndjaba ndje dœ aayi kœyisœ awa akwa œ yindœ ye nene, endje wo she yeka manda olo votɔ á tshe she lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tshe sœ lima kœpa o'onœ o'ara o'ara yeka á Petro dji ata á e she ga ɨndɨrɨnœ á kɔ she adœke tshe katœ kœpa o'o atamœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yisu fatœ ye œ tondœ ayambarœ nœ ye, œ ngá fœ Petro adœke: «Gitœ zœ tœ mœ, Satana! Gbetshelœ nœ zœ lili dœ œnœ Ndjaba bale nene, kashe œnœ azuzu.» ");
INSERT INTO kxf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Manda nœ kɔ, Yisu e azu para dœ pe ayambarœ nœ ye œ pa fœ endje adœke: «Uzu kœyindœ kœna manda mœ, œ li adœke tshe vwaratœ ye tœ undu ye dœ tœ ye, œ za kurushi nœ ye yeka á kœna manda mœ. ");
INSERT INTO kxf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gbambanœ nene, uzu kɔ á tshe sœ dœ ogo kœsœ dœ soro œ tshu ye; kashe tsheneke á tshe tshu mbœrœ mœ œdœ ndje mbœrœ Ɔtshɔ O'o, œshe dá sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Œdœ uzu kœgbɔ œrœ tshapashɔ sœke kɔkɔ, œ sœ dœ she kotoo ɓata á soro ye ndɨ a? ");
INSERT INTO kxf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Œrœ gaɗe dá tshe yapa dœ soro ye asœmœ a? ");
INSERT INTO kxf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Œdœ uzu kœmbœrœ tshula mbœrœ mœ dœ pe mbœrœ o'o nœ mœ ɓa utshu azu nœ tshakpesheke á endje dœ́ aayi kœmbœrœ ekperœ yé á zazatœ endje fœ Ndjaba nene, Gbolo nœ uzu œ mbœrœ tshula ye ndje dœ ɔlɔ á tshe kwatœ ye lœ mokɔ nœ Abanœ awa bale dœ ayerœ andjelu.» ");
INSERT INTO kxf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisu kpa mɨndœ nœ fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke anga azunœ asœke œ tshu nene utshu kœwu Ogo gbozu nœ Ndjaba kœna dœ gbɔgbɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Manda butshɔ mindu dœ bale, Yisu za Petro, Jake œdœ pe Yowane œ ɔ dœ endje ga pa egerœ kaga. Ɓa zœ, tshe fatœ ye dœ ala endje. ");
INSERT INTO kxf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lœba nœ ye wuta tœ imbinœ urrr, uzu bale pa ɔshɔ á tshe li kœdjutɔ lœba ye adœke œ guru atamœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliya œdœ Moyize wuta ga utshu endje, œ ka á sœ kœpa tshama endje dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petro pa fœ Yisu adœke: «Ayi kœyisœrœ, œ ga waa adœke a lœpe kpœke! A mɔ anda tande votɔ: Bale fœ ɓœ, bale fœ Moyize yé udunœ bale ndje fœ Eliya.» ");
INSERT INTO kxf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kashe tshe wuwu lima sœ o'o á tshe sœ kœpa tœnœ nene, awa li lima tœ ye dœ anganœ kɔkɔ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ondoro jerœ ga pa endje. Ko pe lœ ondoronœ, tshama uzu wu adœke: «Tsheneke kœdœ Gbolo nœ mœ á mœ yindœ ye waa; 'e dji she.» ");
INSERT INTO kxf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe kpœtœmœ, ayambarœ nœ ye mesho djikpata tœ endje, œ wuwu uzu bale nene kolœ Yisu kutɨ ye ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ɓata endje sœ lima kœjerœ kaga, Yisu pa fœ endje adœke endje papandœ œrœ kɔ á endje wu fœ uzu bale nene, œrrr Gbolo nœ uzu kœshe bala lœ akuzu yeka á endje kœmɨndœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Endje gbɔndœ o'onœ ga lɔsu endje, kashe endje tetœ kœyutœ endje adœke: «Ádá o'o nœ kœshe lœ akuzu kœdœ gaɗe ma a?» ");
INSERT INTO kxf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yé ayambarœ nœ ye yu she: «Mbœrœ gaɗe á aayi kœyisœ awa akwa pa lima adœke Eliya œ na utshunœ yekane a?» ");
INSERT INTO kxf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yisu gi o'o fœ endje adœke: «Adjapu, Eliya œ na utshunœ mbœrœ kœguma œrœ kɔkɔ. Ka mbœrœ gaɗe á o'o ama Ndjaba pa liya adœke Gbolo nœ uzu œ wu oyo yé azu œ mbœrœ œrœ kanga fœ she a? ");
INSERT INTO kxf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mœ pa fœ 'e adœke, Eliya na, yé azu mbœrœ fœ she œneke kɔ á endje yi lima ndœ nœ kœli dœ œneke á endje sú ala Buku nœ Ndjaba tœ upu nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɔlɔnœ á Yisu dœ ayambarœ nœ ye votɔ gu ga ndœ udu endje, endje wu azu ndjoro djanga aayi kœyisœ awa akwa á ndje ngbɔtœ endje ga tœnœ yeka á lœ kœshara o'o ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Azunœ wu Yisu, lɔsu endje tshi perea yé endje kpa kœbala she. ");
INSERT INTO kxf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yisu yu endje adœke: «O'o gaɗe da 'e lœ kœsharatœ 'e dœ ayambarœnœ lœ kumu nœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Anga uzu bale lœ ugurutœ azunœ gi o'o fœ she adœke: «Ayi kœyisœrœ, mœ na dœ gbolo yakoshe nœ mœ fœ ɓœ. Tshe sœ dœ ekpe ɨshirɨ pa ye á mbœrœ adœke tshe papa o'o nene. ");
INSERT INTO kxf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tœ osho kɔ á ekpe ɨshirɨnœ œ za gbolonœ, tshe za she vesho, furutsha œ wuta putu putu lœ ama ye, tshe zɨ tshelœ daji ye ngara ngara yeka á gbɔ kwa kwa kwa ga tœnœ. Mœ yu ayambarœ nœ zœ adœke endje gɔrɔ ekpe ɨshirɨnœ pa ye yeka á endje lili kœgɔrɔ she nene asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yisu pa fœ endje adœke: «E'e! 'E sœsœ dœ kœyindœrœ ga ndœ Ndjaba nene a? A lœpe dœ 'e kpœke manda olo koto o? 'E yindœ nœ adœke mœ ru lɔsu mœ mbœrœ 'e manda olo koto o? 'E na dœ gbolonœ fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Á endje za she na tœnœ fœ she. Ekpe ɨshirɨnœ wu Yisu œ tetœ kœyaka gbolonœ tœ ɔgbɔnœ. Gbolonœ te ga atɨ, œ vwɨrɨtœ ye nguru nguru lœ ɔshɔ dœ furutsha lœ ama ye putu putu putu. ");
INSERT INTO kxf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yisu yu abanœ adœke: «Ekpe ɨshirɨnœ mbœrœtœ ye manda ungu koto o?» Abanœ gi fœ she adœke: «Pe lœ gbolo ye. ");
INSERT INTO kxf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ekpe ɨshirɨnœ sœ kœgeta she kpala kpala ga tawo, ga langu adœke tshe tshu ye. Kashe wu oyo 'a, œ mbœrœ œneke á li dœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yisu pa fœ she adœke: «Á kœli dœ mœ a? Œrœ kɔ li kœmbœrœtœ endje fœ uzu tsheneke á tshe kœsœ dœ kœyindœrœ ga ndœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pe kpœtœmœ, aba gbolonœ sá rawa adœke: «Mœ sœ dœ kœyindœrœnœ ataa, mbœrœ adœke mœ katœ sharapu!» ");
INSERT INTO kxf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yisu wu azu kœna ndjoro ga ndœ endje œ nga fœ ekpe ɨshirɨ adœke: «Œɓœ dœ ekpe ɨshirɨ á ɓœ mbœrœ adœke gbolo asœke papa o'o nene, œ djidji o'o nene, mœ vwa ɓœ: Wuta lœ ye, yé kpa kwakwatœ zœ ndœ ye nene!» ");
INSERT INTO kxf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ekpe ɨshirɨnœ ve rawa, œ gaga gbolo dœ ɔgbɔnœ á wuta. Gbolo yɔrɔtshelœtœ ye œ wuta ɓata uzu á tshe tshutshu. Ukpulu azu á ndje sœ lima tœ œsœnœ pa adœke: «Tshe tshu ye.» ");
INSERT INTO kxf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kashe Yisu za kane ye, œ tɨ she ga lafo yé tshe ka dœ ada ye. ");
INSERT INTO kxf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yisu li ga sœnda yé ayambarœ nœ ye yu she adœke: «Mbœrœ gaɗe yekane 'a lili má œnœ 'a kœgɔrɔ ekpe ɨshirɨnœ sœmœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yé Yisu pa fœ endje adœke: «Kolœ avwala dá li tœ kœgɔrɔ dœ mara ekpe ɨshirɨnœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Endje áalafo œ sɔ tɔ lœ ogo Galilayi yé Yisu yiyi lima ndœ nœ adœke azu wusœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mbœrœ tshe sœ lima kœyisœ œrœ fœ ayambarœ nœ ye adœke: «Endje ka Gbolo nœ uzu fœ azu adœke ndje wo she yé manda olo votɔ tshe she.» ");
INSERT INTO kxf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ayambarœnœ djidji lima tshelœ kata o'onœ nene, yé endje sœ lima dœ awa kœyu she. ");
INSERT INTO kxf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Endje wuta ɓa lœ Kaparnawumu, œ li ga sœnda. Yisu yu ayambarœ nœ ye: «O'o gaɗe da 'e sœ lima kœvwarandœ nœ na tœnœ tœ ala awa a?» ");
INSERT INTO kxf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kashe endje lœ ko ko ko, mbœrœ tœ awa, endje sœ lima kœvwarandœ upu adœke œɗe dá dœ egerœ uzu ugurutœ œne kɔ a? ");
INSERT INTO kxf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yisu sœ ga atɨ, œ e ayambarœ nœ ye kɔkɔ ndjokpa dœ bisha yé œ pa fœ endje adœke: «Uzu kœyindœ kœsœ utshunœ, œ li adœke tshe sœ tœ ndɔngɔlɔnœ. Yé ga panœ, tshe dœ ayi akwa nœ anganœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tshe za anga gbolo bale, œ za she tɔ ga ugurutœ endje, œ yi kane ye lœ okoro ye; œ pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Uzu á tshe kœza osho kœsœ fœ aya gbolo mbœrœ ɨ'ɨrɨ mœ, tshe za osho kœsœ fœ adja undu mœ. Yé œshe á tshe kœza osho kœsœ fœ mœ, tshe zaza oshonœ fœ mœ nene, kashe tshe za ndje fœ œshe á tshe vwa mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yowane pa fœ Yisu adœke: «Ayi kœyisœrœ, 'a wu anga uzu bale kœgɔrɔ ekpe ɨshirɨ pa uzu dœ ɨ'ɨrɨ zœ yé 'a kɔ she mbœrœ tshe sœsœ kœsœ dœ azœ awa bale nene.» ");
INSERT INTO kxf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kashe Yisu gi fœ endje adœke: «'E kɔkɔ she nene! Gbambanœ nene, uzu lili kœmbœrœ afá lœ ɨ'ɨrɨ mœ yé manda nœ œ pa ekpe o'o dœ ɨ'ɨrɨ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mbœrœ uzu á tshe kœyiyiangba azœ nene, tshe kœdœ uzu nœ azœ. ");
INSERT INTO kxf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yé uzu kɔ á tshe su ungu kœndjoondjo fœ 'e mbœrœ 'e kœdœ azu nœ Kristu, mœ pa fœ 'e adœke; tshe gbɔ adja œrœ tshangbanœ.» ");
INSERT INTO kxf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Uzu kɔ á tshe mbœrœ adœke aya gbolo á tshe kœsœ dœ kœyindœrœ ga ndœ mœ li ga lœ ekperœ, œ li adœke endje du egerœ badja ga lœ ɨgɨ ye, œ na dœ́ œ geta she ga la egerœ ungu. ");
INSERT INTO kxf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Œ kœsœ adœke kane zœ za ɓœ vwi ga lœ ekperœ, œ li adœke ɓœ ta ye. Œ sœ dœ ɔtshɔnœ adœke ɓœ li ga lœ soro dœ kane zœ bale tœ œsœnœ adœke ɓœ li ga lœ kudu owo dœ kane zœ bibisha.  ");
INSERT INTO kxf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ɓa zœ, “angɔzu kœzɨ kote azu tshutshu nene, yé owo ruru nene.” ");
INSERT INTO kxf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Œdœ ada zœ kœsœ kœyi ɓœ ga lœ ekperœ, vwa ye. Œ sœ dœ ɔtshɔnœ fœ ɓœ kœli ga lœ soro dœ ada zœ bale tœ œsœnœ adœke ɓœ sœpe dœ tœnœ bibisha œ li ga lœ kudu owo.  ");
INSERT INTO kxf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ɓa zœ, “angɔzu kœzɨ kote azu tshutshu nene, yé owo ruru nene.” ");
INSERT INTO kxf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Œdœ ala zœ kœsœ kœyi ɓœ ga lœ ekperœ, tshagavwa ye. Œ sœ dœ ɔtshɔnœ fœ ɓœ kœli ga lœ soro dœ tshakala ala zœ bale tœ œsœnœ adœke ɓœ wu oyo dœ tœnœ bibisha lœ kudu owo. ");
INSERT INTO kxf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɓa zœ, angɔzu á ndje zɨ ɔkɔ azu tshutshu nene yé owo ruru ɓa lima nene. ");
INSERT INTO kxf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gbambanœ nene, endje yamba uzu kɔ dœ owo ɓata á endje yamba ndje dɔngɔ kɔ dœ ɨngbɨrɨ. ");
INSERT INTO kxf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Ɨngbɨrɨ kœdœ ɔtshɔrœ kashe œ kœtshɔtshɔ nene, œ kpa dœ ɨngbɨrɨ nene. Á œ kœsœ adœke ɔtshɔ ɨngbɨrɨ ka lœnœ, endje gi ga lœ nœ koto o? Kaka adœke 'e lœ dœ ɨngbɨrɨ lœ ɔkɔ 'e, œ sœ gee ugurutœ 'e dœ anga 'e.» ");
INSERT INTO kxf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisu gitœ ye kœro ga lœ ogo yuda ɓa kele ungu Yɔrdane. Ɓa zœ, azu ndjoro kpa dji she á tshe sœ kœyisœ œrœ fœ endje ɓata á tshe sœ ɓa lima kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Anga Afarisayi na ga ndœ ye dœ gbetshelœ nœ kœyu tshelœ ye, yeka á endje yu adœke: «Œ li dœ yakoshe kœvwaratœ ye tœ awonœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yisu yu endje adœke: «O'o gaɗe dá Moyize pa lima fœ 'e a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Endje gi adœke: «Moyize za awa nœ kœkatœ ayashe tɨ. Utshu nœ kœkatœ ye, ɓœ su mbeti nœ kœvwaratœ zœ tœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tshe kpa pa fœ endje adœke: «Moyize za lima awa o'onœ asœmœ fœ 'e mbœrœ ɔgbɔ lɔsu nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kashe utshu nœ kœmbœrœ œrœ kɔ pa ɔshɔ asœke, Ndjaba mbœrœ lima yakoshe dœ yashe. ");
INSERT INTO kxf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ádánœ á yakoshe œ katœ abanœ dœ ayinœ tɨ, á ngbɔtœ ye ga tœ œsœnœ dœ awonœ, ");
INSERT INTO kxf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yeka á endje bisha œ wuta uzu bale. Endje kpa sœsœ azu bisha nene kashe uzu bale. ");
INSERT INTO kxf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ataa, œneke á Ndjaba ngbɔɓa ga tœnœ, uzu œ ndjɔ tshelœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kœwuta endje ɓa sœnda, ayambarœ nœ ye kpa yu she tœ o'onœ má asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Á tshe kœgi fœ endje adœke: «Uzu kɔ á tshe katœ awonœ tɨ á kpa to anga angbɨ yashe, tshe mbœrœ angba budu ga tœ ayendɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Œ kœsœ ndje adœke yashe kœkatœ akɔnœ á kpa kœi anga angbɨ yakoshe, tshe sœ kœmbœrœ angba budu.» ");
INSERT INTO kxf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Azu na dœ agbolo fœ Yisu adœke tshe to kane ye ga pa endje yeka ayambarœ nœ ye sœ lima kœgeta endje. ");
INSERT INTO kxf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kœwu atamœ, œ za ókó fœ Yisu yé tshe pa fœ ayambarœ nœ ye adœke: «'E katœ agbolo endje na ga ndœ mœ, 'e kɔkɔ endje nene mbœrœ Ogo gbozu nœ Ndjaba sœ mbœrœ azu á ndje lœ ɓata endje. ");
INSERT INTO kxf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ uzu kœza osho kœsœ mbœrœ Ogo gbozu nœ Ndjaba ɓata gbolo nene, tshe li ga zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Á Yisu djendœ endje ga tœ ɨgɨ ye á to kane ye ga pa endje. ");
INSERT INTO kxf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ɓata Yisu sœ lima kœro tœ awa, anga uzu kpa œ gote ga tshakudu ye, œ yu she adœke: «Ɔtshɔ ayi kœyisœrœ, œ li adœke mœ mbœrœ gaɗe á kœgbɔ soro neke á kaka nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yisu pa fœ she adœke: «Mbœrœ gaɗe á ɓœ e mœ ɔtshɔ uzu a? Ɔtshɔ uzu bale gugu nene kolœ Ndjaba tshebabale kutɨ ye. ");
INSERT INTO kxf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ɓœ wusœ awa o'o adœke: “Wowo uzu nene, papara awo uzu nene, zɨzɨ angba nene, wawa o'o dœ wala ga pa uzu nene, mbœmbœrœ ngbɨndɨrœ fœ uzu nene, lɨsœ aba zœ dœ ayi zœ.”» ");
INSERT INTO kxf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uzunœ gi fœ she adœke: «Ayi kœyisœrœ, mœ sœ kœmbœrœtœ mœ lindœ nœ kɔ pe tœ gbolo mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yisu shokɔ she, yé dœ ala nœ ayo, œ pa fœ she adœke: «Œ sœpe œrœ bale, gu œ ka œrœ nœ zœ para kɔkɔ, œ kurutshelœ ngendjanœ kɔkɔ tœ aayi oyo á kœgbɔ kœgbɔrœ ɓa lafo. Manda nœ, fatœ zœ œ na manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Manda o'onœ asœmœ, tshe sœ ko ko ko yé œ gu dœ oyo tœ ye, mbœrœ tshe sœ lima dœ œrœ waa. ");
INSERT INTO kxf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yisu mesho djitœ ye œ pa fœ ayambarœ nœ ye adœke: «Œ sœ tœ ɔgbɔnœ bala tœ aayi kœgbɔrœ tœ kœli ga lœ Ogo gbozu nœ Ndjaba!» ");
INSERT INTO kxf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","O'onœ ndjingɨvwɨ ayambarœ nœ ye. Yé Yisu kœpa pa fœ endje adœke: «Agbolo nœ mœ, Kœli ga lœ Ogo gbozu nœ Ndjaba gbɔɔgbɔ. ");
INSERT INTO kxf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Œ gbɔɔgbɔ adœke agea ɓata shamo li tɔ lœ ogoro ɨmbɨlɨ. Kashe œ kpa gbɔ kœrosœ nœ tœ ayi kœgbɔrœ adœke tshe li ga lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Uvuru endje i gara lœ nœ, á endje tetœ kœyutœ endje ugurutœ endje adœke: «Atamœ, uzu ɗe dá li kœshe tœnœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yisu tondœ endje, œ pa adœke: «Ɓa tœ azu, œ li nene; kashe tœ Ndjaba, œrœ kɔ œ li ye. Gbambanœ nene, Ndjaba li kœmbœrœ œrœ kɔkɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yé Petro pa fœ she adœke: «Wu kane, a katœ œrœ nœ 'a tɨ kɔ, á na manda zœ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yisu gi fœ she adœke: «Mœ pa fœ 'e dœ adjapu adœke, œ kœsœ adœke uzu katœ anda nœ ye, dœ ndje aayanœ, ayingɔnœ, ayinœ, abanœ, agbolo nœ ye, kɨndɨ nœ ye tɨ mbœrœ upu nœ mœ ndje dœ pe mbœrœ upu Ɔtshɔ O'o, ");
INSERT INTO kxf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dœ oshonœ asœke, tshe gbɔ anga anda, aya, ayingɔ, ayi, agbolo, kɨndɨ œdœ ndje œrœ kanga; yeka dœ oshonœ á na manda nœ, á tshe gbɔ soro neke á ka nene. ");
INSERT INTO kxf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Azu ndjoro á ndje sœ utshunœ, endje sœ bala tœ ndɔngɔlɔnœ, yé endje nœ ndɔngɔlɔnœ œ te bala azunœ tshatshu nœ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yisu dœ ayambarœ nœ ye sœ lima tœ awa kœɔ gu tœnœ ga lœ Yerusaleme. Yisu te lima utshu endje, yé awa li lima tœ azunœ á ndje lœ lima kœna manda ye, lɔsu endje sœ lima ga lafo. Yisu kpa ko ayambarœ nœ ye ndjokpa dœ bisha ga ɨndɨrɨ tœ ye, á tetœ kœpa o'o tœ upu œrœ a yindœ kœmbœrœtœ ye fœ endje atake: ");
INSERT INTO kxf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«'E wu, a ɔ kɔ ɓa lœ Yerusaleme. Endje ka Gbolo nœ uzu fœ agbozu tshapa anganga Ndjaba ndje dœ aayi kœyisœ awa akwa. Endje wa agbɔ ngbanga ga pa ye adœke endje wo she, yé œ za she fœ angbɨɨ azu. ");
INSERT INTO kxf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Endje mɔ she, œ tu ngusha ga tœ ye, œ sɔ she dœ ndjapa, œ wo she, yeka manda olo votɔ á tshe she lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ajake dœ Yowane, agbolo nœ Zebedayi, na ga ndœ Yisu, œ yu she adœke: «Ayi kœyisœrœ, 'a yindœ nœ adœke ɓœ mbœrœ œrœ neke á a yu ɓœ tœnœ fœ 'a.» ");
INSERT INTO kxf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Á Yisu kœyu endje adœke: «Œrœ gaɗe dá 'e yindœ nœ adœke mœ mbœrœ fœ 'e a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Endje gi fœ she adœke: «Œ kœsœ adœke ɓœ sœ kœsœ lœ mokɔ nœ zœ, za awa fœ 'a kœsœ ga ɨndɨrɨ tœ zœ, anga uzu bale ga pa kuni zœ, yé anga ga pa gele.» ");
INSERT INTO kxf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Á Yisu kœpa fœ endje adœke: «'E wuwusœ œrœnœ a 'e esho ndœ nœ asœke nene. Adja 'e li kœndjo yashi kanganœ á mœ ndjo bala ye a? 'E li ndje kœgbɔ batisimunœ á mœ gbɔ bala ye a?» ");
INSERT INTO kxf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yé endje gi fœ she adœke: «A li dœ tœnœ ye.» A Yisu gi fœ endje adœke: «Kpœtœpu, 'e ndjo yashi kanganœ á mœ ndjo ye, yé 'e gbɔ batisimu á mœ gbɔ ye. ");
INSERT INTO kxf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kashe tœ kœza awa fœ uzu kœsœ ga atɨ ga pa kuni mœ too ga pa gele mœ, asœmœ wuwu mœ nene. Mbœrœ tœnœ kœdœ osho á sœ fœ endjeneke má Ndjaba guma fœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Udu ayambarœnœ ndjokpa dji o'onœ atamœ œ tetœ kœso ókó ga tœ Ajake dœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yisu e endje para kɔkɔ œ pa fœ endje adœke: «'E wusœ nœ adœke agbozugo yindœ nœ adœke azu lœpe kolœ tshakudu tshagbozu nœ endje. Yé agboro azu yi ndje ndœ kœma kolœ gbɔgbɔ endje ga pa aaya azu. ");
INSERT INTO kxf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Œneke sœsœ kœmbœrœtœ endje lœ guru tœ 'e nene. Kashe, œ kœsœ adœke uzu gbe kœsœ tœ egerœ uzu ugurutœ 'e, œ li adœke tshe fatœ ye tœ ayi akwa nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Œ kœsœ adœke anga uzu ugurutœ 'e yindœ kœsœ utshunœ, œ li adœke tshe dœ kanga nœ 'e para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mbœrœ Gbolo nœ uzu nana adœke azu mbœrœ akwa fœ she nene, kashe tshe na tœ kœmbœrœ akwa fœ azu dœ pe ndje kœzatœ ye fœ kuzu mbœrœ kœshe ukpu azu.» ");
INSERT INTO kxf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisu dœ ayambarœ nœ ye wuta ɓa lœ Yeriko. Ɓata á endje sœ kœwuta awa bale dœ azu ndjoro, anga ayibula á ɨ'ɨrɨ ye kœdœ Bartime, gbolo nœ Time, sœ lima ɨndɨrɨ awa tœ kœyɔndœ œrœ. ");
INSERT INTO kxf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tœ kœdji adœke Yisu uzu Nazarete dœke, tshe tetœ kœ'e osho: «Yisu, Gbolo nœ Davidi, wu oyo mœ!» ");
INSERT INTO kxf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Azu ndjoro rá she adœke tshe sœ koko, á tshe kpa tá tshandœ rawanœ dœ ɔgbɔnœ adœke: «Gbolo nœ Davidi, wu oyo mœ!» ");
INSERT INTO kxf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yisu ka yé œ pa adœke: «'E e she fœ mœ.» Endje e ayibula sœmœ œ pa fœ she adœke: «Indji zœ ga waa, áalafo, tshe sœ kœ'e ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tshe za yɔgbɔdɔ lœba nœ ye vwi ga atɨ, œ su gbuu á na ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yisu yu she adœke: «Ɓœ yindœ nœ adœke mœ mbœrœ gaɗe fœ ɓœ a?» Ayibula gi fœ she adœke: «Ayi kœyisœrœ, kolœnœ adœke mœ kpa wu osho.» ");
INSERT INTO kxf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yisu pa fœ she adœke: «Gu zœ, kœyindœrœ nœ zœ she ɓœ ye.» Trale tshe wu osho œ te ndje tœ kœna manda Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisu dœ ayambarœ nœ ye ndo dœ Yerusaleme, ndo dœ tshalakpɨ Betefaje œdœ Betani, gu ndœ kaga ɔyɔ Olive. Tshe vwa anga ayambarœ nœ ye bisha adœke: ");
INSERT INTO kxf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«'E na ɓa lakpɨ á sœ ɓa utshu 'e ɓa 'e asœmœ. 'E kœwuta ɓa zœ, 'e wu aya ane á endje du she kpœtœmœ, á uzu bale ɔɔ damba ga pa ye nene. 'E vwara she œ gu dœ she ga mœ. ");
INSERT INTO kxf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Œdœ uzu kœyu 'e adœke: “Mbœrœ gaɗe á 'e mbœrœ œrœ ata a?” E gi o'o fœ she adœke: “Gbozu da gbe dœ she yé tshe gi kane ye tœ ye fœ 'e katsha.”» ");
INSERT INTO kxf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Endje ro œ gbɔ aya ane á endje du she ɓa shu ɓa lœ bɨngɨ ndo dœ manda ga ɨndɨrɨ ala awa á endje vwara she. ");
INSERT INTO kxf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Anga azunœ á endje lœ lima lœ bɨngɨnœ pa fœ endje adœke: «Œrœ gaɗe dá 'e mbœrœ ataa a? Mbœrœ gaɗe a 'e sœ kœvwara aya anenœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Endje gi o'o kolœ ɓata á Yisu mɨ má ndœ nœ fœ ndje, yé endje za awa fœ endje kœgu dœ she. ");
INSERT INTO kxf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Endje gu dœ aya ane sœmœ fœ Yisu, œ gbara ala lœba nœ endje ga pa ye yeka á Yisu ɔ á sœ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Azu ndjoro saka ndje lœba nœ endje ga tœ ala awa, anga endje ko kako ɔyɔ á ndje de ɓa lœ kɨndɨ. ");
INSERT INTO kxf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Azu neke á ndje lœ lima utshunœ dœ pe endjeneke á endje lœ manda ye lœ lima kœpa adœke: «Ozana! Ndjaba gbɔndœ tsheneke á tshe na dœ ɨ'ɨrɨ ye! ");
INSERT INTO kxf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ndjaba gbɔndœ akwa gbozunœ á na asœke, Ogo gbozu nœ aba azœ dœ Davidi! Ozana fœ Ndjaba ɓa lafo!» ");
INSERT INTO kxf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisu li lima ga lœ Yerusaleme, yé œ na ga lœ anda Tepelo. Manda kœwu osho kɔkɔ ɨndɨrɨ tœ ye, tshe wuta awa bale dœ ayambarœ nœ ye ndjokpa dœ bisha tœ kœgu ga lœ Betani mbœrœ ɔlɔ ro ye. ");
INSERT INTO kxf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Osho kɔrɔ lima pa nœ, lɔkɔ adœke endje wuta ga lœ Betani, ogo mi Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tshe wu ɔyɔ fige lœ ɨngɨrɨnœ dœ kakonœ tœnœ, œ na kœpara tshelœnœ adœke œne gbɔ ete anga elenœ zœ. Kœndo she dœ tœnœ, tshe wu kolœ kakonœ mbœrœ œ dœ́dœ́ lima olo kœle figenœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yisu darandœ ɔyɔ figenœ á pa adœke: «Adja uzu kpa zɨ ele zœ nene.» Yé ayambarœ nœ ye dji lima o'o nœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Manda nœ endje na ga lœ Yerusaleme. Yisu li ga lœ Tepelo œ tetœ kœgɔrɔ azu á ndje sœ lima kœka œrœ nœ endje dœ pe endjeneke á ndje sœ lima kœyɔ œrœ kpaa ga ushu. Tshe ɨvwɨ ndaba nœ azu kœyapa ngendja, œ geta ngande nœ ayi kœka ambepa. ");
INSERT INTO kxf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yisu vwaratœ ye adœke, uzu bale vwavwanga dœ gbarœ nœ ye to sœnda Tepelonœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yé tshe tetœ kœyisœ œrœ fœ endje adœke: «'E wuwusœ nœ nene a? Endje sú ɓa la Buku nœ Ndjaba adœke: “Anda nœ mœ kœdœ anda kœza avwala mbœrœ azu lœ ogo kɔkɔ.” Kashe 'e fa tœ wutu nœ aayi angba!» ");
INSERT INTO kxf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Agbozu tshapa anganga Ndjabanœ dœ aayi kœyisœ awa akwanœ dji ataa, œ tetœ kœpara awa tœ kœwo she. Kashe endje sœ lima kœkpa awa ye mbœrœ kœyisœrœ nœ ye gbɔ lima osho tœ lɔsu azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dœ kɨdala, Yisu dœ ayambarœ nœ ye wuta lakpɨnœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kpa kœvwanga endje dœ tshamazɨ, endje wu adœke ɔyɔ fige ɔrɔ kpa ga tœ eshenœ. ");
INSERT INTO kxf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Œndœ o'onœ libi te lœ Petro, tshe pa fœ Yisu adœke: «Ayi kœyisœrœ, wu kane, ɔyɔ figenœ á ɓœ dara libi ndœ nœ ɔrɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yisu gi fœ endje adœke: «'E sœ dœ kœyindœrœ ga ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mœ sœ kœpa dœ adjapu fœ 'e adœke œ kœsœ adœke uzu pa fœ kaganœ asœke adœke: “Gitœ zœ kpœke yé œ te ga la kota”, á tshe kœsœsœ dœ sharapu tœ lɔsu ye nene, á sœ dœ kœyindœrœ adœke o'onœ á œne pa œ mbœrœtœ endje ye, œ mbœrœtœ endje fœ she tako. ");
INSERT INTO kxf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ádánœ á mœ sœ kœpa fœ 'e adœke: Œneke kɔ á 'e e osho ndœ nœ lœ avwala ɓa ndœ Ndjaba, 'e yindœ nœ adœke 'e gbɔ kɔ, Ndjaba œ to fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Œ kœsœ adœke 'e ka kœza avwala fœ Ndjaba, á 'e kœsœ dœ o'o tœ lɔsu 'e ga tœ anga uzu, 'e djerœndœ nœ yeka á Aba 'e á tshe sœ ɓa lafo kœdjerœndœ ekperœ nœ 'e.  ");
INSERT INTO kxf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kashe œdœ 'e kœsœsœ kœdjerœndœ ekperœ nœ anga 'e nene, Aba 'e á tshe sœ ɓa lafo œ djerœ ndje ndœ ekperœ á 'e mbœrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Endje kpa kwa ga lœ Yerusaleme, yé dœ lɔndɔ á Yisu sœ kœro ga lœ Tepelo, agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa dœ pe agbɔ Ayuda na ga ndœ ye, ");
INSERT INTO kxf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","á yu she adœke: «Ɓœ gbɔ awa kœmbœrœ akwa nœ zœ asœke kpœta a? Uzu ɗe ndje dá za awa kœmbœrœ akwa ataa fœ ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yisu gi fœ endje adœke: «Mœ yindœ kœyu 'e dœ o'o bale, œ kœsœ adœke 'e gi o'o fœ mœ gbá yekane á mœ kœyisœ osho á mœ gbɔ awa kœmbœrœ dœ œrœnœ asœ kɔ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Œɗe dá vwa lima Yowane kœza batisimu fœ azu a? Œ dœ lima Ndjaba too azu? 'E gi o'o fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yé endje tetœ kœfa o'o ugurutœ ndje adœke: «Œ kœsœ adœke a gi fœ she atake: “Ndjaba dá vwa lima she”, tshe yu azœ adœke mbœrœ gaɗe a yiyi lima ndœ o'o ama ye nene a? ");
INSERT INTO kxf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Œ kpa kœsœ adœke a gi adœke: “Azu dá vwa lima she”, œ li ndje nene.» Gbambanœ nene, endje sœ lima kœkpa awa azu mbœrœ azu kɔ wu lima sœnœ adœke Yowane kœdœ lima adja ayi kœgbara o'o ama Ndjaba kpœtœpu. ");
INSERT INTO kxf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yeka á endje gi fœ Yisu adœke: «A wuwusœ nœ nene.» Á Yisu kœgi fœ endje ndje adœke: «Œmœ ndje awa bale, mœ yi ndje sœ uzu á tshe za awa nœ kœmbœrœ œrœnœ asœke kɔ fœ 'e nene.» ");
INSERT INTO kxf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisu kpa tetœ kœpa o'o fœ endje lœ ndœma toro adœke: «Anga uzu bale djo lima kɨndɨ nœ ye, œ shi ada vinu. Tshe tɔ gbadjadja dji tœnœ tshakpata, œ dji kudu mbœrœ kœpu dœ ele vinunœ; œ mɔ ɨngɨrɨ anda gbara ga lafo á kœsœ tshakudunœ yeka á kœmesho pa vinunœ. Manda nœ, tshe guma o'o ugurutœ ye dœ azu kœmbœrœ akwa kɨndɨnœ, œ na ana. ");
INSERT INTO kxf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ɔlɔ kœkɔ ele vinunœ li, yé tshe vwa anga ayi akwa nœ ye fœ endjeneke á endje lœ ɓa lœ kɨndɨnœ adœke endje vwa œsœ œnœ œne ele vinunœ fœ œne. ");
INSERT INTO kxf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Endje za she œ ɓi she kɔrɔnɔ kɔrɔnɔ, œ gi she tshakane ye gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tshe kpa vwa anga angbɨ ayi akwa fœ endje, endje ɓi ɔkɔrɔ tsheneke mœ, œ gu she ga panœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tshe vwa votɔ uzu fœ endje, yé endje wo tsheneke mœ. Ayengɔ kɨndɨ kpa vwa anga azu ndjoro, endje ɓi anga aayi avwanœ á tshe vwa endje asœmœ, œ wo anga endje œ wo. ");
INSERT INTO kxf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ayengɔ kɨndɨnœ sœpe dœ uzu tshebabale, kolœ gbolo nœ ye á tshe yindœ ye waa. Tshe vwa she fœ endje tœ ndɔngɔlɔnœ dœ gbetshelœ adœke: “Endje kpa ndara ete awa gbolo nœ mœ ye.” ");
INSERT INTO kxf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ɔlɔ á endje wu gbolo nœ ye kœna ga ndœ endje, endje guma o'o lœ oporo tœ endje adœke: “'E wu, gbolonœ á tshe sœpe dœ kɨndɨnœ manda aba nœ dœke. A wo she yeka á kɨndɨnœ kœte œnœ azœ!” ");
INSERT INTO kxf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Endje za she œ wo she, œ za oko ye vwi zara ga ushu lœ kɨndɨnœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Ata ayengɔ kɨndɨnœ œ mbœrœ gaɗe? Tshe na œ wo aayi akwa kɨndɨnœ kɔkɔ yé œ kpa za akwanœ fœ anga angbɨ aayi akwa. ");
INSERT INTO kxf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Damba 'e dɨdɨ o'onœ asœke ala buku nœ Ndjaba nene a? Endje su adœke: “Badja á ayi kœmɔ anda za vwi'i, œtœnœ dá wuta badja á anda œ shi mbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gbozu Ndjaba dá mbœrœ akwa nœ asœmœ: Yé a wu, œ ga tœ ala azœ waa!”» ");
INSERT INTO kxf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Agbozu ayuda para awa tœ kœza she ga lœ kánga manda o'o ama ye asœmœ mbœrœ endje wu lima sœnœ adœke tshe pa o'onœ tœ œne. Yé kœwu adœke azu ngba lima waa, endje ka lima tœ ye, á guda ye. ");
INSERT INTO kxf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Manda nœ, endje vwa anga Afarisayi dœ pe azu nœ Erode fœ Yisu, mbœrœ á endje kœgbɔ she manda ndœma ye. ");
INSERT INTO kxf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Endje na œ yu she adœke: «Ayi kœyisœrœ, 'a wusœ nœ adœke ɓœ sœ kœpa okporo o'o, ɓœ sœsœ ndje kœkatœ zœ tɨ fœ uzu adœke tshe li ga lœ zœ dœ ekpe o'o nene. Ɓœ kpakpa awa uzu nene, œ wuwu ndje tshatshu uzu nene, kashe ɓœ sœ kœyisœ adja awa Ndjaba. Yé pa fœ 'a kane, œ li adœke azu yɔ lapo nœ Sezare a? A yɔ too a yɔ nene?» ");
INSERT INTO kxf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɓata Yisu wu lima sœ gbetshelœ nœ endje, tshe pa fœ endje adœke: «Mbœrœ gaɗe á 'e yu tshelœma mœ a? 'E na dœ anga ngendjanœ gamœ dœ a wu kane» ");
INSERT INTO kxf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Endje na dœ anganœ bale. Yisu pa fœ endje adœke: «Tshatshu uzunœ asœke dœ pe ɨ'ɨrɨ ye á ndje su asœke kœdœ œnœ ɗe?» Endje gi fœ she adœke: «Œnœ Sezare.» ");
INSERT INTO kxf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yisu pa fœ endje adœke: «'E gi œrœ nœ Sezare fœ Sezare, œnœ Ndjaba kœdœ œnœ Ndjaba.» Endje ka tshikɨngɨ mbœrœ o'onœ á tshe gi fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Anga Asadukayi na ga ndœ Yisu. Endje pa œnœ endje adœke kœshe lœ akuzu gugu nene. Á yu lima Yisu atake: ");
INSERT INTO kxf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Ayi kœyisœrœ, Moyize su liya mbeti fœ 'a adœke: Œdœ uzu kœsœ dœ ayanœ á tshe kœto yashe á endje kœzuzu gbolo dœ she nene, á tshe kœtshu, œ li adœke tshe to koya manda ayanœ mbœrœ á tshe kœzu gbolo lœ œsœ ayanœ á tshe tshu asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mbœrœ tœnœ ataa, anga ayazu mindu dœ bisha (7) lœ ayizu bale. Eyanœ za yashe, œ zuzu uzu dœ she nene yé œ tshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bishanœ to yashenœ manda ye, œ zuzu uzu dœ she nene, œ tshu ndje ye. Votɔnœ awa bale. ");
INSERT INTO kxf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ugurutœ endje mindu dœ bisha á ndje to yashe sœmœ, anga bale zuzu gbolo dœ she nene. Yé manda nœ kɔ, yashenœ za awa œ tshu ndje ye. ");
INSERT INTO kxf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ataa, dœ olo nœ kœshe lœ akuzu, yashenœ œ dœ awo ɗe, mbœrœ endje mindu dœ bisha kɔ to lima she tœ awo endje yema a!» ");
INSERT INTO kxf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yisu pa fœ endje adœke: «Koto á œndœ tœ 'e œ ro 'e ata a? Ádánœ kœdœ adœke 'e wuwusœ buku nœ Ndjaba dœ pe gbɔgbɔ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɔlɔ kœshe lœ akuzu, azu œ totœ endje nene kashe endje lœ ɓata aandjelu ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Á kœdœ tœ o'o nœ kœshe lœ akuzu, 'e dɨdɨ ala mbeti nœ Moyize tœ o'o á Ndjaba pa lima fœ she ala owo á sœ lima kœtshi lœ ɔyɔ nene a? Ndjaba pa lima fœ Moyize adœke: “Œmœ kœdœ Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Ndjaba nœ Yakobo.” ");
INSERT INTO kxf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tshe dœ́dœ́ Ndjaba nœ akuzu nene, tshe kœdœ Ndjaba nœ azu á ndje sœ dœ soro. 'E lœ adja lœ djingili.» ");
INSERT INTO kxf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anga ayi kœyisœ awa akwa dji endje kœvwarandœ o'onœ ataa, œ wu adœke Yisu gi adja o'o fœ Asadukayinœ. Á gitœ ye ndoo dœ Yisu á yu she adœke: «Awa o'o gaɗe dá ropa anganœ lœ awa akwa a?» ");
INSERT INTO kxf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yisu gi adœke: «Alinœ kœdœ: Azu Israyele, 'e dji kane, Gbozu, Ndjaba nœ azœ sœ tshebabale. ");
INSERT INTO kxf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yindœ Gbozu Ndjaba nœ zœ dœ lɔsu zœ bale, dœ ɨshirɨ zœ kɔ, dœ gbetshelœ nœ zœ kɔ dœ pe gbɔgbɔ zœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bisha awa o'o dœke: Yindœ yanga zœ ɓata ɓœ yindœtœ zœ dœ tœ zœ. Anga upu á ro œneke bisha gugu nene.» ");
INSERT INTO kxf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ayi kœyisœ awa akwa pa fœ she adœke: «Adjapu, ayi kœyisœrœ, ɓœ pa okporo o'o, Ndjaba sœ tshebabale yé anga ɓata she gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yé kœyindœ ye dœ lɔsu zœ bale, dœ kœwusœrœ nœ zœ kɔ, dœ gbɔgbɔ zœ kɔ œdœ ndje kœyindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ, ropa kœsho agea pa wopa fœ Ndjaba œdœ tokóró kɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisu wu adœke tshe gi o'o tœ uzu nœ kœwusœrœ, œ pa fœ she adœke: «Ɓœ ndo tœ kœte uzu Ogo gbozu nœ Ndjaba.» Anga uzu bale á tshe kpa yu she dœ o'o gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ɔlɔnœ á Yisu sœ lima tœ kœyisœ œrœ ɓa lœ Tepelo, tshe yu adœke: «Œ mbœrœ kotoo á aayi kœyisœ awa akwa pa adœke Masiya kœdœ gbolo nœ Davidi a? ");
INSERT INTO kxf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ɔtshɔ Ɨshirɨ mbœrœ akwa lœ Davidi, yé tshe pa tœ ye dœ tœ ye adœke: “Gbozu Ndjaba mɨndœ nœ fœ Gbozu nœ mœ adœke: Sœ ga atɨ ga pa kuni mœ œrrr mœ kœko ayingba zœ gatshakudu ada zœ yekane.” ");
INSERT INTO kxf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi dœ tœ ye e she Gbozu yé mbœrœ gaɗe á tshe kpa fa gbolo nœ ye a?» Azu ndjoro sœ lima kœdji she dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lœ kœyisœ œrœ nœ ye, tshe pa lima adœke: «Ala 'e gbɔ dœ aayi kœyisœ awa akwa kane: Endje yindœ kœyisœtœ endje kœro dœ yɔgbɔdɔ lœba tœ ala azu yeka á 'e kœbala endje lœ ukpulu azu. ");
INSERT INTO kxf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Endje yindœ kœsœ lœ ngande á sœ ɓa utshunœ lœ sinagoga œdœ pe kœsœ ɓa tœ œsœ agboro azu lœ angbo. ");
INSERT INTO kxf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Endje u ayashe koya œ ko œrœ tœ endje kɔ, endje yindœ kœ'e osho œrrr fœ Ndjaba yeka azu kœgbe adœke œne dá dœ ɔtshɔ azu. Mbœrœ tœnœ ataa, Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ endje.» ");
INSERT INTO kxf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisu sœ ga atɨ ɓa sœnda Tepelo, ga ɨndɨrɨ gbarœ tokóró á sœ kœwu mara kœto œrœ nœ azu fœ Ndjaba. Ayi kœgbɔ ukpulu œrœ sœ lima kœto egerœ ngendja. ");
INSERT INTO kxf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Atamœ yeka anga yashe koya á tshe dœ ayi oyo á akɔnœ tshu, na ndje á ko kolœ aya ngendja œnœ ye bibisha va ga lœ gbarœ tokórónœ. ");
INSERT INTO kxf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yé Yisu e ayambarœ nœ ye, œ pa fœ endje: «Mœ pa fœ 'e dœ okporo o'o adœke yashe koya nœ asœke to œnœ ye kœropa azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gbambanœ nene, azu kɔ ko ngendja neke á sœsœ dœ akwa ɓa ndœ endje nene, kashe œshe, tshe ko œneke kɔ á tshe sœ dœ tœnœ, á sœ má adœke tshe zɨ dœ œrœ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lɔndɔ á Yisu sœ lima kœwuta sœnda Tepelonœ, anga ayambarœ nœ ye pa fœ she adœke: «Ayi kœyisœrœ, wu kane! Wu ogboro badjanœ asœ, wu egerœ zamɨtɨ andanœ asœ!» ");
INSERT INTO kxf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yisu pa fœ she adœke: «Ɓœ wu egerœ andanœ asœmœ? Anga badjanœ bale œ ka pe lafo nene, endje ndɨ tshelœnœ para ye.» ");
INSERT INTO kxf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisu na kœsœ ga atɨ ɓa pa kaga ɔyɔ Olive kpœ tshatshu Tepelo. Petro, Jake, Yowane œdœ Andere á endje sœ lima kpœsœnœ dœ she yu she adœke: ");
INSERT INTO kxf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Pa fœ 'a kane. Dœ ɔlɔ gaɗe dá œrœnœ asœmœ œ mbœrœ má tœ endje a? Yé œrœ gaɗe dá ma má adœke olonœ tɔ ye a?» ");
INSERT INTO kxf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yisu pa fœ endje adœke: «Ala 'e gbɔ, uzu bale fafara 'e nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Azu ndjoro œ na bala dœ ɨ'ɨrɨ mœ, yé œ pa adœke: “Œmœ kœdœ Masiya.” Endje fara azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ɔlɔ á 'e kœsœ kœwu koshe lakpɨ too kœdji o'o nœ koshe zara, awa zaza 'e nene. Œ li adœke œrœ ataa mbœrœtœ endje utshunœ, kashe œ dœ́dœ́ damba kœka tshapashɔnœ dœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Azu tshelœ ogo bale œ tetœ koshe dœ azu tshelœ anga ogo, yé anga ogo gbozu œ nga ndje koshe dœ anga ogo gbozu. Ɔshɔ œ turutœ ye lœ ogo kɔ, yé egerœ ogo œ za osho djigi. Œ sœ ngbewo ɓata oyo á yashe œ wu utshu kœzu gbolo nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Kashe ala 'e gbɔ pa undu 'e kane. Endje tɔ bala meza pa 'e, endje ɓi bala 'e kɔ lœ Sinagoga, endje yu ama 'e dœ ala agbozugo dœ pe ndje agboro agbozu mbœrœ mœ, yé 'e pa bala o'o mbœrœ upu nœ mœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mbœrœ œ sœ adœke Ɔtshɔ O'o wuta ga ndœ azu kɔ lœ ogo utshunœ adœke ndɔngɔlɔ osho œ ka. ");
INSERT INTO kxf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Á kœsœ adœke endje ko 'e na tœnœ ga tœ osho kœwa ngbanga, 'e tɔtɔ lɔsu 'e tœ o'o á 'e pa nene. Dœ lɔkɔnœ asœmœ, 'e pa o'o neke á wuta lœ gbetshelœ nœ 'e. Mbœrœ o'onœ toto lœ 'e dœ tœ 'e nene, kashe Ɨshirɨ nœ Ndjaba dá to o'onœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uzu œ va atɔ ayanœ ndœ kuzu, aba gbolo œ za gbolo nœ ye adœke endje wo she ye. Agbolo œ gbɔ upu dœ aayi kœzu endje yé œ mbœrœ adœke endje wo endje ye. ");
INSERT INTO kxf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Azu kɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ. Kashe uzu neke á tshe ru lɔsu ye œrrr kpa ga tœ kœka oshonœ, tshe gbɔ soro.» ");
INSERT INTO kxf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Uzu á tshe kœdɨ mbeti nœ asœke, tshe gbe dœ tœnœ dœ ɔtshɔnœ kane: Á kœsœ adœke 'e wu ekpe Ayi kœndɨ œrœ ɓa tœ osho á li dœ she kœsœ tœnœ nene, œ li adœke azu ogo Yuda kpa œ kotœ endje yiwa tœnœ ɓa pa kaga. ");
INSERT INTO kxf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tsheneke á tshe kœsœ bala ɓa pa anda, tshe kpa jerœ ga atɨ tœ kœrɔ gbarœ nœ ye ɓa sœnda yeka á kœkpa dœ tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tsheneke á tshe kœsœ bala ɓa lœ kɨndɨ, tshe kpa fatœ ye ndœ kœgu ɓa lakpɨ ndœ kœza lœba nœ ye nene! ");
INSERT INTO kxf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Egerœ oyo mbœrœ ayashe á ndje lœ bala dœ nguzu œdœ endjeneke á ndje sœ kœko ɔngɔ ga lœ ama agbolo dœ ɔlɔnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","'E kɨ fœ Ndjaba adœke œ mbœmbœrœtœ endje dœ olo kpengba ɨzɨ nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mbœrœ dœ lɔkɔnœ asœmœ, azu œ wu bala œrœ kanga œneke á endje wuwu anganœ bale nene kœtotœ ali kœmbœrœ tshapashɔ, dœ lɔkɔ á Ndjaba mbœrœ tshalafo dœ pe tshaatɨ œrrr ga tœ kpesheke nœ asœke, yé mara neke kpa mbœrœtœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Œdœ Gbozu kœgbe má lima tœ kœgi átá olonœ nene, uzu bale œ sœpe má dœ soro nene, kashe mbœrœ endjeneke á tshe ke endje dá tshe gi átá olonœ ga utshunœ. ");
INSERT INTO kxf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«A kœsœ adœke uzu pa fœ 'e adœke: “'E wu, Masiya dœke! 'E wu, tshe sœ ɓa e!” 'E yiyindœ nœ fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gbambanœ nene, azu á ndje pa adœke œne kœdœ Masiya dœ pe aayi kœgbara o'o nœ wala œ wuta bala ndjoro. Endje mbœrœ afá dœ pe ambárá œrœ ndjoro tœ kœgbɔ awa kœbɨlɨ dœ endjeneke á Ndjaba ke endje. ");
INSERT INTO kxf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kashe 'e, ala 'e gbɔ kane! Mœ pandœ nœ kɔ fœ 'e utshunœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Manda olo kœwu œrœ kanganœ asœmœ, osho œ bu yé ɔlɔ œ tɔ nene, ");
INSERT INTO kxf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","angerepe œ yo ga atɨ œdœ œrœ nœ gbɔgbɔ kɔ ɓa lafo œ turutœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yeka á 'e wu Gbolo nœ uzu kœna lœ ondoro dœ gbɔgbɔ djigi œdœ lœ mokɔ. ");
INSERT INTO kxf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tshe vwa bala aandjelu nœ ye tœ osho kɔ pa ɔshɔ dœ tshalafo ndœ kœngbɔɓa bala endjeneke á Ndjaba ke endje.» ");
INSERT INTO kxf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«'E gbɔ œrœ lœ kœyisœ œrœ á ɔyɔ fige œ yisœ nœ kane. Ɔlɔnœ á 'e kœwu kako ɔyɔ fige á sœ kœyo tœ ganeanœ kɔ, á tafonœ kœwuta, 'e wusœ nœ adœke olo kœlu ngwarœ ndo ye. ");
INSERT INTO kxf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Œ sœ ndje atamœ fœ 'e, ɔlɔ á 'e kœwu ndje œrœ ata kœmbœrœtœ endje, 'e wusœ nœ adœke Gbolo nœ uzu ndoo ye, tshe sœ lœ manda 'e. ");
INSERT INTO kxf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mœ sœ kœpa adjapu fœ 'e, azu nœ tshakpesheke, endje ro kɔ nene á œrœnœ œ mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tshalafo dœ tshapa ɔshɔ œ ro, yé o'o ama mœ œ ro nene.» ");
INSERT INTO kxf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kashe ɔlɔnœ, uzu bale œ wusœ nœ nene, œdœ andjelu ɓa lafo, œdœ Gbolo nœ uzu, endje wuwusœ nœ nene, kolœ Aba bale dá wusœ nœ. ");
INSERT INTO kxf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","«Ala 'e gbɔ, yé 'e lolo nene mbœrœ 'e wuwusœ olonœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Œ sœ ɓata anga uzu na ana, á katœ manda gbagba nœ ye tɨ fœ aayi kœgbɔndœ nœ. Á pa fœ endje adœke endje ko ala endje tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'E ko ala 'e tœnœ mbœrœ 'e wuwusœ ɔlɔ kœgu ayengɔ anda nene, dœ akɨdala, dœ abutshɔ, lœ ɨkɨ kɔngato too dœ tshamazɨ, ");
INSERT INTO kxf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","mbœrœ tshe wuwuta ngbangi œ gbɔ 'e yé 'e sœ tœ olo nene. ");
INSERT INTO kxf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","O'o á mœ pa fœ 'e, mœ sœ kœpa fœ azu kɔ: 'e lolo nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Œ sepe lima olo bisha tœ angbo nœ Pake œdœ pe ndje œnœ mapa neke á susuku nene yeka agbozu tshapa anganga Ndjaba œdœ ndje aayi kœyisœ awa akwa para lima awa adœke œne za Yisu ndœ kœwo she. ");
INSERT INTO kxf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Endje pa ugurutœ endje adœke: «A zaza she lœ lɔndɔ angbonœ nene mbœrœ azu œ vwaratœ endje ye.» ");
INSERT INTO kxf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yisu sœ lima lœ Betani ɓa sœnda nœ ayi boroma Shimu kœzɨ œrœ, anga yashe bale na dœ ungu yombo nœ ye lœ anga á endje mbœrœ dœ badja albatre. Yombonœ asœmœ dœ adja narde á amanœ gbɔ dœ panœ. Tshe kavwa ama anganœ á su yombonœ ga lœ kumu Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Anga azunœ á ndje lœ lima tœ œsœnœ oma dœ ókó á pa lœ ugurutœ endje adœke: «Mbœrœ gaɗe á tshe ndɨ ungu yombo nœ ye atamœ a? ");
INSERT INTO kxf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Endje za má yombonœ asœmœ, œ za yɔ œrœ œ gbɔ denari kœropa kama votɔ á kœkurutshelœ nœ tœ ayi oyo!» Tshelœ endje ɔɔrɔ gboo ga tœ yashenœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yé Yisu pa adœke: «'E katœ ye yé, mbœrœ gaɗe á 'e suku dœ she a? Tshe mbœrœ ɔtshɔrœ ga tœ mœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ayi oyo, 'e lœ dœ endje ɔlɔ dœ ɔlɔ yé ɔlɔnœ á lɔsu 'e kœyindœ nœ, 'e mbœrœ ɔtshɔrœ fœ endje zœ. Kashe œmœ, a lœlœpe dœ 'e waa nene. ");
INSERT INTO kxf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Œrœ á sœ má adœke tshe mbœrœ dá tshe mbœrœ asœmœ: Tshe sú ungu yombo ga tœ mœ utshu nœ kœshi mœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mœ sœ kœpa dœ okporo o'o fœ 'e adœke, osho kɔ á endje pandœ Ɔtshɔ O'o, endje gbe dœ œrœ á yashe sœke mbœrœ asœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudasi Isikariote, anga bale lœ ayambarœ nœ Yisu ndjokpa dœ bisha, na ga ndœ agbozu tshapa anganga Ndjaba kœza Yisu yɔ œrœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kœdji o'onœ ataa, endje sœ dœ yanga œ dɨ mbulu kœko ngendja fœ she. Yudasi te lima tœ kœmirœtshelœ ye ndœ olo ga ɗe dá œne kœza she fœ endje. ");
INSERT INTO kxf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dœ olo angbo nœ mapa á susuku nene, á endje wo lima aya apata pa angbo Pakenœ. Yeka ayambarœ nœ Yisu yu she adœke: «Ɓœ yindœ nœ adœke a na ɓata á kœguma kœzɨrœ Pakenœ fœ ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A tshe vwa anga ayambarœ nœ ye bisha adœke: «'E na ɓa lœ egerœ ongbo, 'e gbɔtœ 'e dœ anga yakoshe á tshe za lɔsú ungu ga lœ kumu ye. 'E te mangba ye ");
INSERT INTO kxf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","yé osho á tshe li ga tœnœ, 'e pa fœ ayengɔnœ adœke: “Ayi kœyisœrœ yu adœke: Osho á mœ zɨ Pakenœ dœ ayambarœ nœ mœ sœ kpœta a?” ");
INSERT INTO kxf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tshe yisœ anga gbɔshɔ œneke á sœ tœ egerœnœ ɓa lafo dœ œrœ neke á li lœnœ kɔkɔ, yeka á 'e kœguma kœzɨrœnœ ɓa zœ fœ azœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ayambarœ ro ɓa lœ ongbo, œ gbɔ œneke kɔ á tshe pa má tœnœ fœ endje asœmœ, yé á endje guma kœzɨrœ Pakenœ kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dœ akɨdala, tshe yikumu ye dœ ayambarœ nœ ye ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ɔlɔ á endje sœ pa kœzɨrœ, Yisu pa fœ endje adœke: «Mœ sœ kœpa dœ okporo o'o fœ 'e adœke, anga uzu bale ugurutœ 'e á tshe sœ kœzɨ œrœ dœ mœ kpœtœ œsœnœ œ ka mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kœdji o'o ataa, œ za oyo tœ lɔsu endje, yé endje tetœ kœyu she uzu dœ uzu adœke: «Œdœ mœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tshe gi fœ endje adœke: «Œdœ anga yanga 'e ugurutœ 'e ndjokpa dœ bisha, á 'a sœ kœngbɔ kane a lœ gbarœ kœzɨrœ dœ she bale asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gbambanœ nene, Gbolo nœ uzu œ tshu ɓata á endje sú lima ala buku nœ Ndjaba tœ upu nœ ye. Kashe oyo nœ uzu á tshe ka Gbolo nœ uzu fœ angbɨ azu! Œ sœ má dœ ɔtshɔnœ mbœrœ uzunœ adœke adja endje zuzu she nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ɔlɔ á ndje sœtœ kœzɨ œrœ, Yisu za mapa œ donga Ndjaba, œ kavwa tshelœnœ, œ ko fœ ayambarœ nœ ye, yé œ pa adœke: «'E ko, asœ kœdœ undu mœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Manda nœ, tshe za ndje yashi, yé manda kœdonga Ndjaba, tshe za fœ endje, á endje kɔ ndjo. ");
INSERT INTO kxf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yé á tshe mɨndœ nœ fœ endje adœke: «Asœ kœdœ indji mœ, indji á guma ayo ugurutœ Ndjaba dœ azu, á tu mbœrœ azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mœ sœ kœpa dœ adjapu fœ 'e adœke, mœ kpa ndjo vinu nene œrrr lɔkɔnœ á mœ ndjo bala tafonœ ɓa lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Manda kœdonga Ndjaba dœ itshi, endje wuta ndœ kœɔ ga pa kaga ɔyɔ Olive. ");
INSERT INTO kxf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisu pa fœ endje adœke: «E'e kɔ 'e katœ mœ tɨ ye, mbœrœ endje sú ala Buku nœ Ndjaba adœke: “Mœ wo bala ayi kœgbɔndœ apata yé apatanœ œ ndjɔtshelœtœ endje kpa ye.” ");
INSERT INTO kxf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kashe manda kœshe mœ lœ kuzu, mœ na bala utshu 'e ga lœ Galilayi.» ");
INSERT INTO kxf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro pa fœ she adœke: «Ataa azu kɔ kœkatœ zœ tɨ, mœ katœ zœ tɨ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Á Yisu gi fœ she adœke: «Mœ pa fœ ɓœ dœ adjapu adœke, dœ abutshɔnœ asœke, utshu nœ bisha ɨkɨ kɔngato, ɓœ pa adœke ɓœ wuwusœ mœ nene awa votɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A Petro kpa pa fœ she adœke: «Œ kœli adœke a tshu dœ ɓœ, mœ pa bale nene adœke mœ wuwusœ zœ nene.» Yé udu ayambarœnœ pa ndje awa bale. ");
INSERT INTO kxf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Manda nœ, Yisu dœ ayambarœ nœ ye wuta ɓa lœ anga osho bale á ɨ'ɨrɨnœ kœdœ Getesemane á tshe pa fœ endje adœke: «'E lœ ga atɨ kpœke mœ na kœkɨ fœ Ndjaba kane.» ");
INSERT INTO kxf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tshe za Petro, Jake œdœ Yowane po tœ ye. Œ tetœ kœza oyo fœ she yé awa li she gɔrɔ. ");
INSERT INTO kxf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Á tshe pa fœ endje adœke: «Lɔsu mœ sœ tshé tshé dœ oyo adœke mœ tshu ye. 'E lœpe kpœke kashe 'e lolo nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tshe gitœ ye tœ endje teasho ga utshunœ, œ gote ga lœ ɔshɔ, œ kɨ fœ Ndjaba adœke awa œrœnœ á yindœ kœmbœrœtœ endje, gitœ endje tœ œne. ");
INSERT INTO kxf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tshe pa adœke: «Aba mœ, ɓœ li kœmbœrœ œrœ kɔ, gi yashi kanganœ asœke utshu mœ. Mbœmbœrœ œneke á mœ yindœ nœ nene kashe mbœrœ œneke á li dœ gbetshelœ nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tshe fatœ ye, œ gu ga ndœ endje, œ gbɔ endje lœ olo. Tshe e Petro œ yu she adœke: «Shimu, ɓœ lo lo a! Ɓœ sœsœ dœ gbɔgbɔ tœ kœsœ uburu tœ ala zœ manda ada ɔlɔ bale nene a? ");
INSERT INTO kxf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'E lolo nene, yé œ kɨ fœ Ndjaba adœke Satana fafara 'e nene. Ɨshirɨ uzu gbe dœ kœmbœrœ ɔtshɔrœ yeka á undu ye gugu dœ gbɔgbɔ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Manda nœ, tshe kpa kwatœ ye tœ bishanœ kœkɨ fœ Ndjaba kolœ dœ o'onœ á tshe pa má utshunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tshe kpa gu ga ndœ ayambarœnœ, œ gbɔ endje kolœ lœ olo, ndara olonœ na lima pa endje, awa endje gi lima o'o fœ she gugu nene. ");
INSERT INTO kxf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tshe kwa tœ votɔnœ, œ pa fœ endje adœke: «'E sœpe kœlo tœnœ œdœ pe kœyatœ 'e a? Ɔlɔnœ to ye! 'E wu kane, endje na kœza Gbolo nœ uzu gatshakane ayi kœmbœrœ ekperœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","E áalafo, a na! Ayi kumu mœ má na ye!» ");
INSERT INTO kxf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lɔndɔ á Yisu sœpe kœpa o'o kolœnœ atake, Yudasi, anga ayambarœ lœ andjokpa dœ bisha yi kumu ye. Tshe na awa bale dœ azu ndjoro dœ ɨngɨrɨ yakamba œdœ pe ndɨndɨ ɔyɔ tshakane endje. Agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa œdœ agbɔ Ayuda dá vwa lima endje. ");
INSERT INTO kxf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudasi á tshe za Yisu yɔ œrœ pa lima tshelœ o'o dœ endje adœke: «Uzu á mœ kœuru tshelœ utu ye, œshe dœmœ. 'E za she, yé ala 'e gbɔ yeka á 'e kœgu dœ she.» ");
INSERT INTO kxf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Trale Yudasi wuta, œ na ndo dœ she á pa fœ she adœke: «Ayi kœyisœrœ!» Ngbewo á uru tshelœ utu ye. ");
INSERT INTO kxf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Azunœ tepa Yisu, á za she. ");
INSERT INTO kxf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yeka anga yanga endje á tshe sœ lima kpœtœmœ gbota ɨngɨrɨ yakamba nœ ye á de anga ayi akwa nœ egerœ nganga Ndjaba, á wa utu ye ndja. ");
INSERT INTO kxf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yisu pa fœ endje adœke: «'E na dœ ɨngɨrɨ yakamba dœ pe ndje ndɨndɨ ɔyɔ tshakane 'e ndœ mœ ɓata œmœ kœdœ ayi angba a? ");
INSERT INTO kxf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ɔlɔ dœ ɔlɔ, mœ sœ lima lœguru tœ 'e, mœ yi ndje lima œsœ œrœ lœ Tepelo, yé 'e zaza mœ lima nene. Kashe œneke kɔ wuta mbœrœ adœke o'o ala buku nœ Ndjaba kœmbœrœtœ ye.» ");
INSERT INTO kxf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ayambarœnœ kɔ katœ ye tɨ, yé œ kpa kpɨrɨ. ");
INSERT INTO kxf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anga gbolo yakoshe bale na lima manda ye, tshe i lima akpa ayi lœba ga tœ ɨgɨ ye. Endje za she. ");
INSERT INTO kxf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","A tshe katœ akpa ayi lœbanœ tɨ, á djɔ dœ ɔrɔ kpendro. ");
INSERT INTO kxf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Endje za Yisu gutœnœ ɓa utshu egerœ nganga Ndjaba. Agbɔ ayudanœ ndje dœ aayi kœyisœ awa akwanœ dœ pe agbozu nœ anganga Ndjabanœ kɔ ngbɔtœ endje gasœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro sœ lima kœna manda Yisu yima yima lœ ɨngɨrɨnœ œrrr ɓa uguru gbagba anda nœ egerœ nganga Ndjaba, yé á sœ lima ga ɨndɨrɨ owo awa bale dœ ayi akwa nœ gbozu nœ anganga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Agbozu tshapa anganga Ndjaba dœ agboro aayi kœwa ngbanga, sœ kœpara lima awa adœke œne gbɔ anga uzu á tshe kœpa anga tshenea o'o goro œsœ Yisu, á œne kœgbɔ awa kœwo she. Yé endje gbɔgbɔ œnœ endje lima uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mbœrœ ɨlɨ azunœ sœ lima kœko o'o ga pa ye, kashe ama endje sœsœ lima bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anga endje áalafo, œ za ɓishu ga pa ye adœke: ");
INSERT INTO kxf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«A dji lima she adœke: “Œmœ, mœ ndɨ bala tshelœ anda Tepelonœ á azu mbœrœ dœ kane endje ye, yeka manda olo votɔ á mœ kpa mɔ anga tafonœ œneke á azu œ li kœmbœrœ dœ kane endje nene.”» ");
INSERT INTO kxf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ata atamœ gbaa, o'o ama endje sœsœ lima ndje awa bale nene. ");
INSERT INTO kxf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yé á egerœ nganga Ndjaba áafo gbara lœ ugurutœ azu á endje ngbɔtœ endje asœmœ, á yu Yisu adœke: «Ɓœ ɨɨ ama zœ ndœ o'o œneke kɔ á azu œ ko ga pa zœ asœke nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yé Yisu sœ œrœ nœ ye ko ko ko, œ ɨɨ ama ye bale nene. Egerœ nganga Ndjabanœ kpa yu she adœke: «Ɓœ kœdœ Masiya, Gbolo nœ Ndjaba á azu œ donga she a?» ");
INSERT INTO kxf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yisu gi adœke: «Œ̃, œmœ kœdœ she. Yé 'e wu bala Gbolo nœ uzu kœsœ ga atɨ ga pa kuni Ndjaba á tshe sœ dœ gbɔgbɔ kɔ, yé 'e wu ndje bala she kœjerœ lœ ondoro ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kœdji ataa, egerœ nganga Ndjaba oma dœ ókó, œ suru tshelœ lœba tœ ye, yé á pa adœke: «Ádá kpa kœdji atimu tœ azœ gugu nene! ");
INSERT INTO kxf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","'E dji she kœpa ngbɨndɨ o'o goro œsœ Ndjaba a! 'E gbe má œnœ 'e dœ tœnœ kotoo?» Yé ngbɨɨ endje wa ga tœ ye adœke: «Tshe li dœ kuzu!» ");
INSERT INTO kxf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Anga endje ugurunœ tetœ kœtu ngusha ga tœ ye, kœgwa ala ye dœ lœba, kœdu she, á lœ kœyu she adœke: «Pandœ uzunœ á tshe du ɓœ!» Yé aayi akwanœ tshu ga paye á sœ kœda ala ye. ");
INSERT INTO kxf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ɓata á Petro sœpe lima ɓa atɨ ɓa lœ gbagba, anga yashe akwa nœ egerœ nganga Ndjaba yi kumu ye. ");
INSERT INTO kxf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tshe wu Petro ɓa ɨndɨrɨ owo, á tondœ ye œrrr, á yu she adœke: «Œɓœ ndje, ɓœ kœdœ lima anga uzu nœ Yisu, uzu Nazarete.» ");
INSERT INTO kxf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petro vusœ nœ á pa adœke: «Mœ wuwusœ ye nene yé mœ sœ ndje gene nœ o'onœ á ɓœ sœ kœpa tœnœ.» Tshe áafo œ wuta œ ká ɓa tœ manda gbagbanœ. ");
INSERT INTO kxf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yashe sœmœ wu she œ tetœ kœmɨndœ nœ fœ azu á ndje lœ lima kpœtœmœ adœke: «Uzunœ á tshe sœ ɓa e, kœdœ anga azunœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petro kpa vusœ nœ. Manda nœ teasho, azu á ndje lœ lima kpœtœmœ kpa yu Petro adœke: «Adjapu, ɓœ kœdœ anga uzunœ mbœrœ ɓœ kœdœ uzu tshelœ Galilayi.» ");
INSERT INTO kxf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petro tetœ kœdarama ye dœ pe kœwa ɨgɨ ye adœke: «Mœ wuwusœ yakoshenœ a 'e pa tœ ye asœmœ nene.» ");
INSERT INTO kxf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngbewo, á kɔngato kpa kɨ tœ bishanœ. Yé Petro gbe tshelœ ye ndœ o'onœ á Yisu pa lima fœ she adœke: «Utshunœ adœke kɔngato kɨ awa bisha ɓœ pa wa ɓœ wuwusœ mœ nene awa votɔ.» Tshe wuta dœ ɔgbɔ ga ushu, yeka a kɨ. ");
INSERT INTO kxf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dœ tshamazɨ tuu, agbozu tshapa anganga Ndjaba vwarandœ o'o dœ agbɔ Ayuda, aayi kœyisœ awa akwa œdœ pe aayi kœwa ngbanga para kɔkɔ. Endje i Yisu ga tœnœ, œ na dœ she fœ Pilato. ");
INSERT INTO kxf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato yu she adœke: «Œɓœ kœdœ gbozugo nœ Ayuda a?» Yisu gi fœ she adœke: «Œɓœ dá pa ataa.» ");
INSERT INTO kxf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Agboro agbozu tshapa anganga Ndjaba pa wala ga pa ye tɔpanœ kpuru. ");
INSERT INTO kxf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato kpa yu she: «Ɓœ ɨ ama zœ nene a? Dji o'o á endje pa ga pa zœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kashe Yisu gigi o'o bale nene, yé uvuru Pilato kpa ye. ");
INSERT INTO kxf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lɔkɔ angbo Pake lœ ngbugu bale dœ bale kɔ, Pilato sœ lima kœkatœ ayi kánga bale, tsheneke á endje kœyɔndœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yé tsheneke á endje e she Barabase sœ lima lœ kánga dœ anga azu á endje nga koshe œrrr á wo uzu. ");
INSERT INTO kxf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Azu ndjoro na ga ndœ Pilato, œ tetœ kœyu she adœke tshe kpa mbœrœ anga œrœnœ á tshe mbœrœ ɓalima fœ œne asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato gi fœ endje adœke: «'E yindœ nœ adœke mœ za awa fœ gbozu nœ Ayuda dœ́ tshe gu da ye a?» ");
INSERT INTO kxf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mbœrœ tshe wu lima sœnœ adœke agbozu tshapa anganga Ndjabanœ mbœrœ úkú ga tœ Yisu yeka á na dœ she fœ œne asœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Agbozu tshapa anganga Ndjabanœ bɨlɨ azu ndjoro kœyu Pilato adœke endje za awa fœ Barabase adœke tshe gu da ye. ");
INSERT INTO kxf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kpa yu endje adœke: «Mœ mbœrœ gaɗe dœ uzu á 'e e she adœke gbozugo nœ Ayuda a?» ");
INSERT INTO kxf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Endje ta rawa kɔkɔ adœke: «Wo she ɓa pa kurushi!» ");
INSERT INTO kxf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato gi fœ endje adœke: «Œrœ gaɗe dá tshe mbœrœ a?» Endje kpa ve rawa tœ ɔgbɔnœ adœke: «Wo she ɓa pa kurushi!» ");
INSERT INTO kxf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato vwara Barabase tœ kœza yanga fœ azu, œ za Yisu adœke endje ɓi she dœ ndjapa, œ za she ga tshakane endje adœke endje wo she ɓa pa kurushi. ");
INSERT INTO kxf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aturugu li dœ Yisu ga lœ gbagba anda nœ gbozugonœ, œ e tœ endje para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Endje verœ yɔgbɔdɔ odoro lœba ga tœ ye, œ verœ kpoto ishi ga tœ kumu ye. ");
INSERT INTO kxf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Manda nœ, endje tetœ kœmɔ she adœke: «Abala, gbozugo nœ Ayuda!» ");
INSERT INTO kxf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Endje sɔ kumu ye dœ adja wara, œ tu ngusha ga tœ ye, yé œ ká kœgote dœ pe kœtra kumu endje ga atɨ ga tshatshu ye. ");
INSERT INTO kxf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Manda kœmɔ she, endje sɔ lima odoro lœbanœ á endje verœ ga tœ ye yeka á kpa verœ adja lœba nœ ye ga tœ ye, á to she wuta tœnœ ndœ kœwo she. ");
INSERT INTO kxf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Anga uzu bale, ɨ'ɨrɨ ye kœdœ Shimu, uzu tshalakpɨ Sirene, aba kœzu Alekezandre dœ pe Rufusi, to lima ɓa lœ kɨndɨ á sœ kœgu dœ awanœ asœmœ. Aturugu za she dœ ɔgbɔ á pa adœke tshe za átá kurushinœ tœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Endje to Yisu natœnœ ɓa tœ osho á ɨ'ɨrɨnœ kœdœ Gologota, ádánœ adœke: «Osho gbayashi kɔrɔ.» ");
INSERT INTO kxf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Endje sú vinu á ndje ngbɔɓa dœ shundɔɗɔ ɔyɔ, œ za fœ Yisu adœke tshe ndjo kashe tshe vwaratœ ye tœ kœndjo tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Endje kuru she ga pa kurushi, œ ta wuka pa lœba nœ ye tœ kœwu adœke uzu dœ uzu œ gbɔ œneketa. ");
INSERT INTO kxf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Endje ɓi she ga pa kurushi lima dœ ada ɔlɔ mindu dœ vana. ");
INSERT INTO kxf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Endje su ádá kœwo she lima ga pa tsheporo ɔyɔ adœke: «Gbozugo nœ Ayuda». ");
INSERT INTO kxf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Endje kpa kuru anga aayi angba bisha ga pa kurushi ga ɨndɨrɨ tœ ye, anga ga pa kuni, anga ga pa gele ye.  ");
INSERT INTO kxf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ataa, œ mbœrœtœ endje dœ mara á endje sú lima ala mbeti adœke: «Endje dɨ lima she ga ugurutœ aayi angba.» ");
INSERT INTO kxf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Azu á ndje sœ lima kœvwanga tœ awa tɔ kpœtœmœ sœ kœgu she, kœvwi kumu endje kœpa pe adœke: «Ha, ɓœ pa lima adœke ɓœ ndɨ tshelœ egerœ zamɨtɨ anda Tepelo á kpa mɔ tshandœnœ manda olo votɔ, ");
INSERT INTO kxf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ɓœ she tœ zœ dœ tœ zœ œ jerœ pa kurushinœ ga atɨ nene a?» ");
INSERT INTO kxf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Awa bale, agboro agbozu tshapa anganga Ndjabanœ dœ aayi kœyisœ awa akwanœ mɔ tœ endje ugurutœ endje á pa adœke: «Tshe she lima anga azu, tshe sheshe tœ ye dœ tœ ye nene a! ");
INSERT INTO kxf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Masiya, Gbozu nœ Israyele, tshe jerœ pa kurushinœ yeka á a kœwu á kœyindœ nœ.» Ayi angba á endje kuru ndje endje lima dœ she ga pa kurushi fa ndje tœ endje kpœtœtœ kœgu she. ");
INSERT INTO kxf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dœ kakpi ɔlɔ, osho wu kporokoto pa ɔshɔ djigi œrrr ga tœ ada ɔlɔ votɔ manda kakpi ɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kœwuta ga tœ ada ɔlɔ nœ asœmœ, Yisu tá ɔgbɔ rawa adœke: «Eloyi, Eloyii, lema sabakatani?» Œ yindœ kœpa adœke: «Ndjaba nœ mœ, Ndjaba nœ mœ, mbœrœ gaɗe á ɓœ katœ mœ tɨ a?» ");
INSERT INTO kxf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anga azu á endje lœ lima kpœtœmœ pa adœke: «'E dji kane, tshe sœ tœ kœ'e Eliya!» ");
INSERT INTO kxf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Anga uzu kpa œ nduru ndɔhɔrɔ gala ikpi vinu á vwele ga tœ kumu wara yeka á yi ga tœ ama ye adœke tshe ndjo dœ kœpa pa adœke: «'E kaka a wu Eliyanœ á tshe na tœ kœza she ga atɨ pa kurushinœ.» ");
INSERT INTO kxf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kashe Yisu ta ɔgbɔ rawa trale dœ kœtshu she. ");
INSERT INTO kxf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yé egerœ lœba á endje du ɓa sœnda Tepelo suru tshelœtœ ye bisha kœto ɓa lafo kpa ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gbozu tshapa aturugu á tshe sœ lima ɓa utshu ye wu mara kuzu á Yisu tshu, á pa adœke: «Adja uzu asœ kœdœ Gbolo nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Anga ayashe ka lima zara á lœ kœtondœ osho, ugurutœ endje Mareya uzu Magadala, dœ Mareya ayi aya Jake œdœ Joze, dœ pe Salome. ");
INSERT INTO kxf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Endje sœ lima kœna manda ye tœ kœmbœrœ akwa fœ she lɔkɔ á tshe sœ lima ɓa lœ Galilayi. Anga azu ndjoro á endje ɔ lima dœ she ga lœ Yerusaleme lœ ndje lima kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Dœ adɨla, ɓata tœnœ kœdœ lɔkɔ sabata, Yozefu uzu tshelœ Arimateyo na ga ndœ Pilato. Tshe kœdœ lima ndje anga uzu ugurutœ agboro ayi kœwa ngbanganœ, á tshe sœ ndje lima dœ gbetshelœ nœ Ogo gbozu nœ Ndjaba. Tshe ru tœ lɔsu ye á na kœyu she á kœza oko Yisu á kœshi. ");
INSERT INTO kxf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Œ za awa fœ Pilato kœdji adœke Yisu tshu. Tshe e gbozu tshapa aturugunœ á yu she adœke Yisu tshu ata œndœ nœ dɨ ye a? ");
INSERT INTO kxf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Manda kœdji gbozu tshapa aturugunœ, tshe za awa fœ Yozefu kœza oko Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yozefu yɔ lœba kuzu, œ ɨ she tœ kurushi, œ vwele she dœ lœba akuzunœ, á za she ga lœ udu tshelœ badja bale á tshe yɔ. Yé á vwɨrɨ egerœ tame ga pa ogoro kudunœ. ");
INSERT INTO kxf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mareya uzu Magadala dœ Mareya ayi Joze ká lima kœwu osho á endje za oko Yisu ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Olo sabata ro ye, Mareya uzu Magadala dœ Mareya ayi Yakobo dœ Salome yɔ yombo kœna kœdja dœ oko Yisu. ");
INSERT INTO kxf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pe dœ amazɨ tuu dœ ɔlɔ yenga, á sœ adœke ɔlɔ mbœrœ œsœ kœwuta tœnœ á endje ro ga pa udu. ");
INSERT INTO kxf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Endje sœ lima kœpulœma endje natœnœ adœke: «Œɗe dá vwɨrɨ tame tœ manda udunœ fœ azœ a?» ");
INSERT INTO kxf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kœmesho ataa, endje wu adœke endje vwɨrɨ ɓamama egerœ tamenœ pa udu ga ɨndɨrɨ nœ. ");
INSERT INTO kxf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kœli ga lœ udu, endje wu anga gbolo yakoshe, tshe sœ ga pa kuni endje á verœ yɔgbɔdɔ lœba tœ imbinœ, awa za endje. ");
INSERT INTO kxf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kashe tshe pa fœ endje adœke: «Awa zaza 'e nene. 'E sœ kœpara Yisu uzu Nazarete á endje kuru kpœke she ga pa kurushi. Tshe shé ye, tshe sœsœpe kpœke nene. 'E wu uwu oshonœ á endje shi she tœnœ. ");
INSERT INTO kxf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yé 'e gu œ pandœ nœ fœ ayambarœ nœ ye œdœ pe Petro adœke: “Tshe ro utshu 'e ga lœ Galilayi da ye, 'e wu she ɓa zœ ɓata á tshe pa lima fœ 'e.”» ");
INSERT INTO kxf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Endje wuta katsha lœ udunœ, œ za ɔrɔ kpagu tœnœ yé uvuru endje yu. Endje papa o'o fœ uzu bale nene mbœrœ awa li lima tœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yisu she dœ amazɨ nœ ali olo lœ pɔsɔ, œ matœ ye utshu nœ fœ Mareya uzu Magadala á tshe gɔrɔ lima ekpe ɨshirɨ mindu dœ bisha (7) pa ye. ");
INSERT INTO kxf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tshe gu œ pandœ nœ fœ azu á tshe sœ lima sœnda bale dœ ɨkɨ œdœ ngola lœ ala endje dœ she. ");
INSERT INTO kxf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kashe, kœdji adœke Yisu sœ dœ soro yé œne wu she dœ ala œne tako, endje yiyi lima ndœ nœ ga tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mangba nœ, tshe matœ ye fœ anga anga endje bisha lœguru tœ endje á ndje sœ lima kœro ga lœ anga ogonœ. ");
INSERT INTO kxf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Anga endje asœmœ gu œ kpa pandœ nœ fœ endje. Ata gbaa, endje yiyi lima ndœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Manda nœ kɔ, Yisu kpa matœ ye fœ ayambarœ nœ ye ndjokpa dœ bale, ɔlɔ á endje sœ lima awa bale pa ndaba tœ kœzɨ œrœ. Yé tshe bala endje mbœrœ upu sharapu œdœ pe ɔgbɔ lɔsu nœ endje, mbœrœ adœke endje yiyi lima ndœ kœyindœ o'o ama azu á endje pa lima adœke œne wu she dœ soro nene. ");
INSERT INTO kxf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tshe za o'o fœ endje adœke: «'E na djelœ ogo kɔ, œ pandœ Ɔtshɔ O'o fœ azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uzu á tshe kœyindœ nœ, yé á kœgbɔ batisimu, tshe gbɔ soro. Kashe uzu tsheneke á tshe kœyiyindœ nœ nene, Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Azu neke á endje kœyindœ nœ, endje mbœrœ mara œrœ nœ asœke: Endje gɔrɔ ekpe ɨshirɨ dœ ɨ'ɨrɨ mœ, endje pa tafo o'o ama ogo, ");
INSERT INTO kxf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","á kœsœ adœke endje tepa ayakoro too adœke endje ndjo ekpe ɔyɔ, œrœ bale œ mbœrœ tœ endje nene. Endje to kane endje ga pa ayi koɓa, yé endje she.» ");
INSERT INTO kxf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Manda kœza o'o fœ endje, Gbozu Yisu ɔ ga lafo, yé á sœ ga atɨ ga pa kuni Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ayambarœnœ na lima kœpandœ o'onœ tœ osho kɔ. Gbozu Yisu mbœrœ lima akwa dœ endje awa bale. Tshe yi lima œsœ mara œrœ kɔ á li adœke endje kœmbœrœ yeka á kœma adœke o'onœ á endje pa kœdœ okporo o'o.");
INSERT INTO kxf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Gbozu Teofile, azu ndjoro tetœ kœsu mbeti tœ œrœ á mbœrœ lima tœ endje ugurutœ azœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Endje pandœ œrœnœ ɓata á endje dji lœ ama endjeneke á endje dœ atimu, á endje wu dœ ala endje lima pe tœ alinœ, yé á wuta aayi kœyisœ o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mbœrœ tœnœ ataa, œmœ ndje, mœ yu osho dœ ɔtshɔnœ tœ œneke kɔ á mbœrœ lima tœ endje kœto ɓa tœ adanœ. Yé gbozu Teofile, mœ wu dœ ɔtshɔnœ adœke mœ su œtœnœ ngbɨ fœ ɓœ liaka mara á mbœrœ lima tœ endje bale dœ bale dœ awanœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mœ sœ kœmbœrœ ataa, mbœrœ á ɓœ kœwusœ nœ adœke œneke kɔ á endje yi lima sœ nœ fœ ɓœ kœdœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lɔkɔ á Erode dœ lima gbozugo Yuda, anga nganga Ndjaba bale á ɨ'ɨrɨ ye kœdœ Zakariya sœ lima zœ. Tshe sœ lœ uwu anganga Ndjaba nœ Abiya. Awonœ kœdœ lima anga uzu bale lœ aata Aro, ɨ'ɨrɨ ye kœdœ Elisabete. ");
INSERT INTO kxf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Endje bibisha kœdœ lima azu á endje sœ ndjii ɓa utshu Ndjaba, yé endje sœ lima kœmbœrœtœ endje lindœ awa akwa œdœ lindœ awa o'o nœ Gbozu dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kashe endje gugu lima dœ gbolo nene, mbœrœ Elisabete kœdœ lima yashe mara. Ga pa nœ dœmœ, ungu endje bibisha ro lima sœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dœ anga ɔlɔ bale, Zakariya na kœmbœrœ akwa nœ anganga Ndjaba mbœrœ tœnœ kœdœ lima lɔkɔ nœ uwu anganga Ndjaba á tshe sœ lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lindœ mara nœ kœmbœrœ akwa nœ anganga Ndjaba, endje yu lima kadangba yeka á ke she adœke tshe li ga lœ œyerœ osho nœ Gbozu ndœ kœsho yombo ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lɔkɔ nœ kœsho yombonœ, azu ndjoro sœ lima ɓa shu ndœ kœza avwala. ");
INSERT INTO kxf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tshokombele, anga andjelu nœ Gbozu wuta ga tœ ye, œ ka ga tœ kuni ndaba á endje sho yombo panœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lɔkɔ á Zakariya wu she, uvuru ye i gara yé awa litœ ye kpakpakpa. ");
INSERT INTO kxf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kashe andjelu pa fœ she adœke: «Zakariya, sœsœ dœ awa nene mbœrœ Ndjaba dji avwala nœ zœ ye. Awo zœ dœ Elisabete œ zu bala gbolo yakoshe fœ ɓœ, ɓœ ta ɨ'ɨrɨ ye adœke Yowane. ");
INSERT INTO kxf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Upu nœ ye œ za egerœ yanga fœ ɓœ, yé azu ndjoro œ sœ dœ yanga tœ kœzu she. ");
INSERT INTO kxf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gbambanœ nene, tshe dœ bala egerœ uzu tœ ala Gbozu. Tshe ndjo bala vinu œdœ anga ipi á mbœrœ osho nene, yé Ɔtshɔ Ɨshirɨ œ su bala she pe ɓa lœ ayinœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tshe mbœrœ bala adœke azu Israyele ndjoro fatœ endje gu tœnœ ga ndœ Gbozu, Ndjaba nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tshe na ɓata ayi avwa nœ Ndjaba dœ ɨshirɨ œdœ gbɔgbɔ nœ Eliya, mbœrœ kœgi ayo ga ugurutœ agbolo dœ aaba endje œdœ pe kœyisœ œrœ fœ azu gbɔkumu adœke endje sœ dœ kœwusœtœ nœ azu á endje sœ ndjii, mbœrœ kœguma azu á endje li fœ Gbozu.» ");
INSERT INTO kxf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya yu andjelu adœke: «Mœ wusœ nœ kotoo? Mbœrœ œmœ kœdœ yagbozu yé awo mœ fa yawaza ye.» ");
INSERT INTO kxf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Andjelu gi fœ she adœke: «Œmœ kœdœ andjelu Gabriyele, mœ sœ kœka ɓa utshu Ndjaba mbœrœ kœmbœrœ akwa nœ ye. Œshe dá vwa mœ mbœrœ adœke mœ pa fœ ɓœ dœ œ mɨndœ Ɔtshɔ O'onœ asœ fœ ɓœ ndje. ");
INSERT INTO kxf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kashe ɓata á ɓœ yiyindœ nœ adœke o'o ama mœ sœ kœmbœrœtœ endje dali dœ olo á mœ gbe dœ tœnœ nene asœmœ, ɓœ fa tɔndu yé ɓœ kpa pa o'o nene œrrr ga tœ olo adœke œneke kɔ á mœ pandœ nœ fœ ɓœ, mbœrœtœ endje.» ");
INSERT INTO kxf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dœ lɔkɔnœ asœmœ, azu sœ lima kœkate Zakariya, yé œ sœ kœyutœ endje tœ ádá á œndœ ye sœ lima kœdɨ tœnœ ɓa lœ œyerœ oshonœ ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kashe lɔkɔ á tshe wuta lima, tshe lili lima kœpa o'o ga tœ azu á endje ngbɔtœ endje asœmœ nene. Azunœ wusœ nœ lima adœke tshe wu œrœ lœ ulu ɓa tœ œyerœ oshonœ ɓa zœ. Tshe sœ lima kœma œrœ fœ endje kolœ lœ tɔndunœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lɔkɔ á akwa nœ Zakariya ɓa lœ Tepelo ka lima ndœ olonœ asœmœ, tshe gu ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Manda nœ teasho atake, awonœ dœ Elisabete gbɔ nguzu, yé œ zatœ ye yiwa tœnœ manda yapu mindu. Tshe sœ lima kœpa adœke: ");
INSERT INTO kxf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«'E wu egerœ œrœ á Gbozu mbœrœ fœ mœ asœ! Ngɔngɔ asœke, tshe fa ala ye ndœ mœ á yindœ kœgi mœ lœ œneke á sœ lima kœza tshula fœ mœ tœ ala azu.» ");
INSERT INTO kxf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Manda yapu mindu dœ bale, Ndjaba vwa andjelu Gabriyele ɓa lœ anga ongbo Galilayi bale á ɨ'ɨrɨ kœdœ Nazarete. ");
INSERT INTO kxf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tshe vwa she ɓa ndœ anga yawuru bale á tshe yindœ kœtotœ ye dœ anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Yozefu, uzu tshelœ bɨngɨ nœ Davidi. Ɨ'ɨrɨ yawurunœ kœdœ lima Mareya. ");
INSERT INTO kxf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Andjelu li ga ndœ ye œ pa fœ she adœke: «Sœ dœ yanga! Gbozu Ndjaba ma ɔtshɔ lɔsu ga ndœ zœ. Tshe sœ awa bale dœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kumu Mareya kpa tatalikiri tœ o'onœ asœmœ ye. Tshe te lima tœ kœyutœ ye tœ ádá abalanœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Andjelu kpa kœpa fœ she adœke: «Mareya, sœsœ dœ awa nene mbœrœ Ndjaba ma ɔtshɔ lɔsu ga ndœ zœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lœ ondonœ asœke, ɓœ gbɔ nguzu, yé ɓœ zu bala gbolo yakoshe, œ ta ɨ'ɨrɨ ye adœke Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tshe dœ bala egerœ uzu, yé Ndjaba á tshe ropa œrœ kɔ œ e she adœke tshe kœdœ Gbolo nœ œne. Gbozu Ndjaba œ za she bala tœ gbozugo manda atanœ dœ Davidi. ");
INSERT INTO kxf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tshe dœ gbozu tshapa azu Israyele waa dœ waa, yé akwa tshagbozu nœ ye œ ka nene.» ");
INSERT INTO kxf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mareya yu andjelu adœke: «Ka ɓata á mœ wuwu damba sœ yakoshe nene asœ, œ mbœrœtœ endje kotoo?» ");
INSERT INTO kxf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Andjelu gi fœ she adœke: «Ɔtshɔ Ɨshirɨ œ jerœ bala ga pa zœ, yé gbɔgbɔ nœ Ndjaba á tshe ropa œrœ kɔ œ tshu ɓœ ngbɨlɨ ɓata tshaagujara. Mbœrœ tœnœ ataa, gbolo á ɓœ zu she œ sœ yerœ yé endje e she adœke Gbolo nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wu ka, ayo zœ dœ Elisabete á endje e she yashe mara asœmœ, tshe gbɔ nguzu lœ yawaza tœ ye. Yé ngɔngɔ asœke, nguzunœ mbœrœ yapu mindu dœ bale. ");
INSERT INTO kxf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gbambanœ nene, œrœ á ropa Ndjaba gugu nene.» ");
INSERT INTO kxf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yé Mareya gi fœ she adœke: «Œmœ kœdœ ayi akwa nœ Gbozu; kaka adœke œneke kɔ á ɓœ pandœ nœ, mbœrœtœ endje ga tœ mœ.» Yé andjelu gitœ ye tœ ye ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lœ olo manda nœ, Mareya áalafo œ gbɔgbɔtœ ye na tœnœ ga lœ anga ongbo bale á sœ ɓa pa kaga lœ ogo Yuda. ");
INSERT INTO kxf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tshe wuta ɓa zœ œ li ga lœ anda nœ Zakariya, yé œ bala Elisabete. ");
INSERT INTO kxf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lɔkɔ á Elisabete dji abala nœ Mareya, gbolo turu ɓa lœ ye, yé Ɔtshɔ Ɨshirɨ su she kperœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tshe ta ɔgbɔ rawa yé œ pa adœke: «Ndjaba to kane ye ga pa zœ kœropa ayashe kɔ œdœ pe ga pa gbolo á tshe sœ lœ zœ! ");
INSERT INTO kxf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Œmœ kœdœ œɗe adœke ayi Gbozu nœ mœ na kœtitœ mœ a? ");
INSERT INTO kxf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gbambanœ nene, lɔkɔ á mœ dji abala nœ zœ, gbolo turu ɓa lœ mœ dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Œɓœ kœdœ uzu nœ yanga mbœrœ á ɓœ dji o'o á Gbozu Ndjaba pa fœ ɓœ, yé á yindœ nœ adœke œ mbœrœtœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dœ tœnœ ataa, Mareya kœpa adœke: «Mœ sœ kœdonga Gbozu Ndjaba dœ lɔsu mœ bale, ");
INSERT INTO kxf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","yé lɔsu mœ su dœ yanga mangba Ndjaba á tshe dœ ayi kœshe mœ, ");
INSERT INTO kxf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mbœrœ á tshe gbe dœ mœ dœ amba ayi akwa nœ ye. Ádánœ ataa, kœto kpesheke œdœ ɔlɔ dœ ɔlɔ, azu œ e mœ yashe nœ yanga, ");
INSERT INTO kxf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mbœrœ Ndjaba nœ gbɔgbɔ kɔ mbœrœ egerœ œrœ fœ mœ. Œshe kœdœ Ndjaba á tshe sœ yerœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɔlɔ dœ ɔlɔ, tshe sœ kœwu oyo endjeneke á endje sœ kœkpawa ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tshe ma gbɔgbɔ kane yakoshe nœ ye, yé œ ndjɔ tshelœ azu á endje sœ dœ lɔsu nœ kœzatœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tshe ko agbozugo ga atɨ pa ngande tshagbozu nœ endje, yé œ tɨ endjeneke á endje gugu dœ ádá nene, ga lafo. ");
INSERT INTO kxf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tshe to œrœ ndjoro fœ endjeneke á endje sœ dœ ogo, yé œ gi azu á endje sœ dœ œrœ ndjoro tshakane endje gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tshe tɨ kane agbolo Israyele á endje dœ ayi akwa nœ ye ga lafo, kœli dœ ɔtshɔ lɔsu nœ ye ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tshe mbœrœ ga ndœ Abrayamo œdœ alɨvunœ waa dœ waa ɓata á tshe za lima uvu fœ aata azœ.» ");
INSERT INTO kxf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mareya mbœrœ lima ga pa œrœ nœ́ yapu votɔ ɓa ndœ Elisabete yeka á gu ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Olo kœzu nœ Elisabete li lima, yé tshe zu gbolo yakoshe ga pa ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Amashenga nœ ye œdœ pe ayonœ djindœ nœ adœke Gbozu Ndjaba má ɔtshɔ lɔsu ga ndœ ye, yé œ sœ lima dœ yanga awa bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kœwuta ga tœ olo mindu dœ votɔ manda kœzunœ, endje na kœwa gbolonœ tœ gaza, yé œ yi lima ndœ kœta ɨ'ɨrɨ abanœ dœ Zakariya ga pa ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kashe ayinœ za o'o, œ pa adœke: «Œ̃ œ̃ nene, ɨ'ɨrɨ ye œ dœ Yowane.» ");
INSERT INTO kxf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Endje pa fœ she adœke: «Anga uzu bale lœ bɨngɨ nœ zœ gugu dœ ɨ'ɨrɨnœ asœmœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yé endje yi kane endje ga tœ aba gbolo, mbœrœ kœwusœ ɨ'ɨrɨ á tshe gbe ma œnœ ye kœta ga tœ gbolonœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariya e osho ndœ œrœ á endje sú mbeti ga pa nœ, yé œ su adœke: «Ɨ'ɨrɨ ye kœdœ Yowane.» Azu kɔ kɨ lima tœ œsœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pe tœ œsœnœ, Zakariya kpa tetœ kœpa o'o ye: Tshe tetœ kœdonga Ndjaba dœ ɔgbɔ tshama ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Awa litœ amashenga nœ ye kpakpakpa, yé azu kɔ pa kaga lœ ogo Yuda tetœ kœpandœ œrœnœ á mbœrœtœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Endjeneke kɔ á endje dji lima o'onœ, endje gbɔndœ nœ ga tœ lɔsu endje yé œ tetœ kœyutœ endje adœke: «Gbolo asœke œ te bala œɗe?» Gbɔgbɔ nœ Gbozu Ndjaba sœ lima adja dœ she awa bale. ");
INSERT INTO kxf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ɔtshɔ Ɨshirɨ su Zakariya, aba aya gbolonœ kperœ yé tshe tetœ kœgbara o'o ama Ndjaba adœke: ");
INSERT INTO kxf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«A donga Gbozu, Ndjaba nœ azu Israyele, mbœrœ tshe gbe dœ azu nœ ye, yé á gi endje lœ kanga. ");
INSERT INTO kxf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tshe vwa anga ayi kœshe azu á tshe sœ dœ gbɔgbɔ, fœ azœ ugurutœ aata ayi akwa nœ ye dœ Davidi. ");
INSERT INTO kxf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tshe mbœrœ œneke á tshe pa lima ndœ nœ katshatsha, lœ ama ayerœ aayi kœgbara o'o nœ ye adœke, ");
INSERT INTO kxf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","œne ko azœ tshakane ayingba azœ œdœ tshakane endjeneke kɔ á endje sœ kœyiangba azœ. ");
INSERT INTO kxf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tshe ma ɔtshɔ lɔsu ga ndœ aata azœ, yé œ djedjerœndœ œyerœ madu nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gbambanœ nene, Ndjaba za lima uvu fœ ata azœ dœ Abrayamo adœke, ");
INSERT INTO kxf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","œne gi azœ tshakane ayingba azœ ye, á kœza awa fœ azœ kœmbœrœ akwa nœ ye dœ awa nene, ");
INSERT INTO kxf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","adœke a wuta ayerœ azu, œ sœ ndjii utshu œne, ɔlɔ dœ ɔlɔ lœ soro azœ.» ");
INSERT INTO kxf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Á Zakariya kœpa adœke: «Yé œɓœ, gbolo nœ mœ, ɓœ dœ bala ayi kœgbara o'o nœ Ndjaba á tshe ropa œrœ kɔ. Gbambanœ nene, ɓœ na utshu Gbozu mbœrœ kœguma awa ye. ");
INSERT INTO kxf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yé ɓœ yisœ nœ fœ azu nœ ye adœke, tshe sœ kœna kœshe endje, lœ awa nœ kœdjerœndœ ekperœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gbambanœ nene, Ndjaba nœ azœ sœ dœ ɔtshɔ lɔsu, tshe sœ dœ lɔsu kœwu oyo waa. Tshe vwa ɨshirɨ ɔlɔ á to ɓa lafo ga pa azœ ɓata œneke á wuta dœ tshamazɨ. ");
INSERT INTO kxf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ɨshirɨ ɔlɔnœ œ tɔ ga pa endjeneke kɔ á endje sœ lœ ubu osho œdœ endjeneke á endje sœ kœkpa awa kuzu, mbœrœ kœyisœ awa nœ kœsœ gee fœ azœ.» ");
INSERT INTO kxf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gbolonœ sœ lima kœgerœ tœnœ yé Ndjaba za lima gbɔgbɔ fœ she, tshe sœ lima kœsœ ɓa lœ kpagagasho œrrr ga tœ lɔkɔ kœwuta she ga tœ ala azu Israyele. ");
INSERT INTO kxf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dœ lɔkɔnœ asœmœ, Sezare Oguste á tshe dœ egerœ gbozugo Roma, za o'o fœ azu tshelœ ogo nœ ye kɔ adœke endje ro kœsu ɨ'ɨrɨ endje gala buku. ");
INSERT INTO kxf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ali kœsu ɨ'ɨrɨ azu gala bukunœ asœmœ dœmœ. Kiriniyuse dá dœ lima gbozu tshapa ogo Siri dœ lɔndɔnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Uzu dœ uzu kɔ gu lima ga lœ adja ongbo nœ ye mbœrœ adœke endje sú ɨ'ɨrɨ ye gala buku. ");
INSERT INTO kxf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yozefu to ndje ɓa lœ Nazarete, ongbo tshelœ ogo Galilayi, yeka á ro ga lœ Beteleme ɓa lœ ogo Yuda, ongbo á endje zu lima Davidi lœnœ. Gbambanœ nene, Davidi kœdœ lima ata Yozefu. ");
INSERT INTO kxf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tshe na lima ɓa zœ dœ awonœ dœ Mareya á tshe sœ lima dœ nguzu, mbœrœ adœke endje sú ɨ'ɨrɨ endje gala buku. ");
INSERT INTO kxf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dœ lɔkɔ á endje sœ lima ɓa lœ Beteleme, olo adœke tshe zu, li lima ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tshe zu eya nœ ye tœ gbolo yakoshe, œ vwele she dœ lœba yé á za she ga pa gbarœ kœzɨrœ nœ agea, mbœrœ osho gugu lima mbœrœ endje ɓa tœ osho kœsœ á sœ mbœrœ agene nene. ");
INSERT INTO kxf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aayi kœgbɔndœ ayarœ á endje sœ ɓa lœ kɨndɨ yé á sœ kœsœ ɨndɨrɨ ukpulu ayarœ nœ endje dœ butshɔ, sœ ndje lima lakpɨnœ asœmœ zœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Anga andjelu nœ Gbozu Ndjaba bale wuta ga tœ endje, mokɔ nœ Gbozu za endje djigi, yé awa litœ endje kpakpakpa. ");
INSERT INTO kxf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kashe andjelu pa fœ endje adœke: «'E sœsœ dœ awa nene, mbœrœ mœ na kœpandœ Ɔtshɔ O'o fœ 'e; o'o neke á za yanga kœropanœ fœ azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dœ butshɔ asœke, ɓa lœ ongbo nœ Davidi, endje zu ayi kœshe azu; á tshe kœdœ Kristu, Gbozu nœ azœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yé ambárá œrœ á 'e wusœ ye mbœrœ tœnœ dœke: 'e gbɔ anga aya gbolo á endje vwele she dœ lœba, yé á za she ga lœ gbarœ kœzɨrœ nœ agea.» ");
INSERT INTO kxf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tshokombele, anga aandjelu ndjoro to ɓa lafo œ ngbɔtœ endje ga tœ œsœnœ dœ she, yé á tetœ kœdonga Ndjaba adœke: ");
INSERT INTO kxf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Mokɔ nœ Ndjaba matœ ye ɓa lafo! Yé kœsœ gee sœ dœ azu á endje yindœ ye ɓa pa ɔshɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lɔkɔ á aandjelu fatœ endje kœɔ ga lafo, ayi kœgbɔndœ ayarœ pa œnœ endje adœke: «A na œrrr ɓa lœ Beteleme, œ wu œrœ á wuta ɓa zœ kane; œneke á Gbozu Ndjaba yisœ nœ fœ azœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Endje gbɔgbɔ lima tœ endje rotœnœ ga zœ yé œ gbɔ Mareya, Yozefu œdœ pe aya gbolo á ndje za she ga lœ gbarœ kœzɨrœ nœ agea. ");
INSERT INTO kxf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lɔkɔ á endje wu lima she, endje tetœ kœpandœ o'o á andjelu pa fœ endje tœ upu nœ gbolonœ fœ Amareya dœ Yozefu. ");
INSERT INTO kxf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yé azu para á endje lœ lima kœdji œneke á aayi kœgbɔndœ ayarœnœ sœ kœpandœ nœ asœmœ, kɨtœ œsœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Andaa Mareya sœ lima kœgbɔndœ o'onœ kɔ ga lɔsu ye, yé œ sœ kœpara ádánœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Manda nœ, aayi kœgbɔndœ ayarœnœ fatœ endje kœgu gangba endje dœ kœdonga Ndjaba œdœ dœ kœza mokɔ fœ she tœ œneke kɔ á endje wu yé á dji. Gbambanœ nene, œrœnœ kɔ mbœrœtœ endje ɓata á andjelu pandœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Manda olo mindu dœ votɔ, olo kœwa gbolo tœ gaza li lima ye. Endje ta ɨ'ɨrɨ Yisu ga pa ye. Œtœnœ kœdœ ɨ'ɨrɨ á andjelu ma lima utshunœ adœke ayinœ gbɔ nguzu. ");
INSERT INTO kxf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lɔkɔ á olo kœdjutɔ kote Amareya dœ Yozefu yeka á endje kœfa ayerœ azu tœ ala Ndjaba, lindœ awa akwa nœ Moyize li lima, endje to Yisu na tœnœ ga lœ Tepelo ɓa lœ Yerusaleme mbœrœ kœma she fœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gbambanœ nene, endje sú ɓala Buku nœ awa akwa nœ Gbozu adœke: «Ali gbolo yakoshe kɔ á endje zu she utshunœ, endje za she fœ Gbozu Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Œ li ndje adœke Amareya dœ Yozefu za ndje tokóró dœ akalambonga bisha too dœ ambepa bisha, ɓata á awa akwa nœ Gbozu pa ndje tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dá asœmœ, anga uzu á ɨ'ɨrɨ ye kœdœ Shimeyo, sœ lima ɓa lœ Yerusaleme. Œshe kœdœ lima uzu á tshe sœ ndjii dœ pe kœlɨsœ Ndjaba. Tshe sœ lima kœkate tsheneke á tshe na mbœrœ kœgi agbolo Israyele lœ oyo. Ɔtshɔ Ɨshirɨ sœ lima dœ she, ");
INSERT INTO kxf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","yé œ ma fœ she adœke tshe wu Masiya á Gbozu Ndjaba œ vwa she, utshunœ adœke tshe tshu. ");
INSERT INTO kxf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɨshirɨ to Shimeyo na tœnœ ga lœ Tepelo. Lɔkɔ á agbozu nœ Yisu na dœ she ga lœ Tepelo kœmbœrœ liaka œneke á endje sú ɓa la buku nœ awa akwa tœ upu nœ ye, ");
INSERT INTO kxf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Shimeyo za she ga tshaabrœ ye, yé œ tetœ kœdonga Ndjaba adœke: ");
INSERT INTO kxf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ngɔngɔ asœke Gbozu, kaka adœke ayi akwa nœ zœ, ro dœ kœsœ gee ɓata á ɓœ pa lima ndœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gbambanœ nene, mœ wu ayi kœshe á ɓœ vwa she dœ adja ala mœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ɓœ guma ayi kœshenœ asœmœ mbœrœ azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tshe sœ ɓata ɔlɔ á tɔ ga pa angbɨ azu, yé tshe dœ mokɔ mbœrœ azu Israyele á endje dœ́ agbolo nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aba Yisu œdœ ayinœ katœ ama endje tɨ ɔsɔ tœ œneke á Shimeyo sœ lima kœpa tœnœ tœ upu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Shimeyo to kane ye ga pa endje yé œ pa fœ Mareya, ayi Yisu adœke: «Ndjaba ke gbolo asœ mbœrœ lœ awa nœ ye, azu ndjoro lœ Israyele œ yo too œ she. Tshe dœ bala ambárá nœ Ndjaba kashe azu œ vwaratœ endje tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tshe ma gbetshelœ nœ azu á zatœ endje yiwa tœnœ ɓa lɔsu endje ngbɨ ga ushu. Yé tœ ɓœ dœ Mareya, oyo nœ zœ œ sœ bala ɓata endje sú ɓœ peara dœ ɨngɨrɨ yakamba.» ");
INSERT INTO kxf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Anga yashe kœgbara o'o bale á ɨ'ɨrɨ ye kœdœ Ana, sœ lima zœ. Œshe kœdœ yawuru nœ Fanuwele, uzu tshelœ mara nœ Azere. Tshe wuta lima ɔgbɔ yawaza ye. Tshe i lima akɔnœ pe lœ yawuru tœ ye, yé endje mbœrœ ungu mindu dœ bisha (7) yeka á yakoshenœ tshu. ");
INSERT INTO kxf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Manda nœ, tshe sœpe lima tœ yashe koya yé œ sœ dœ ungu zazu vana dœ vana (84). Tshe gigi lima tœ ye lœ Tepelo nene. Kashe butshɔ dœ ɔlɔ, tshe sœ lima kœmbœrœ akwa fœ Ndjaba lœ awa nœ kœyotshelœma ye œdœ pe kœza avwala. ");
INSERT INTO kxf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tshe yi kumu ye pe dœ lɔkɔnœ asœmœ, yé œ tetœ kœdonga Ndjaba dœ kœpa o'o tœ upu nœ gbolonœ fœ endjeneke á endje sœ lima kœkate adœke Ndjaba she Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lɔkɔ á Ayozefu dœ Mareya mbœrœ lima œneke kɔ á awa akwa nœ Gbozu sœ kœyɔndœ nœ, endje gu lima ndœ ogo Galilayi, ɓa lœ Nazarete á dœ ongbo nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gbolonœ sœ lima kœgerœ tœnœ dœ undu ye œdœ dœ kœwusœtœ, yé kane Ndjaba sœ lima pa ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ungu bale dœ bale, agbozu nœ Yisu sœ lima kœro ga lœ Yerusaleme ndœ angbo Pake. ");
INSERT INTO kxf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lɔkɔ á Yisu sœ lima dœ ungu ndjokpa dœ bisha, endje na dœ she ga lœ Tepelo ɓata á mbœrœ ɓalima tœ ye lœ mara nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lɔkɔ á angbonœ ka lima, Ayozefu dœ Mareya fatœ endje kœgu tœnœ, kashe Yisu sœ lima pe lœ Yerusaleme yé agbozu nœ ye wuwu she nene. ");
INSERT INTO kxf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Endje gbe lima adœke Yisu te manda azu á œne sœ kœgu tœ awanœ dœ endje asœmœ. Endje lo olo bale lœ ana yé osho kɔrɔ, endje tetœ kœpara she lœ ugurutœ ayo endje œdœ pe lœ ugurutœ anga endje. ");
INSERT INTO kxf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kashe endje gbɔgbɔ lima she nene. Endje kwa ga lœ Yerusaleme kœpara she. ");
INSERT INTO kxf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Endje totœ kœpara she œrrr manda olo votɔ á gbɔ lima she ɓa lœ Tepelo. Tshe sœ ga atɨ ɓa ugurutœ aayi kœyisœrœ œ sœ kœdji endje, dœ kœyu endje dœ o'o. ");
INSERT INTO kxf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Azu kɔ á endje sœ lima kœdji she, ka lima tœ ama endje tɨ ɔsɔ tœ kœwusœrœ nœ ye dœ pe o'o á tshe sœ kœgi tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lɔkɔ á agbozu nœ ye wu she, endje i gbɔndjuru yé ayinœ pa fœ she adœke: «Gbolo nœ mœ, mbœrœ gaɗe á ɓœ mbœrœ mara œrœ ata fœ 'a? A'a dœ aba zœ, 'a para ɓœ dœ awa.» ");
INSERT INTO kxf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tshe gi fœ endje adœke: «Mbœrœ gaɗe á 'e para mœ a? 'E wuwusœ nœ nene adœke œ li adœke mœ sœ ɓa lœ anda nœ Aba mœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kashe agbozu nœ ye djidji lima tshelœ kata œneke á tshe pa fœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yisu gu awa bale dœ endje ga lœ Nazarete; tshe sœ lima kœmbœrœtœ ye lindœ o'o endje. Ayinœ gbɔndœ œrœ á mbœrœtœ endje asœmœ kɔ ga tœ lɔsu ye. ");
INSERT INTO kxf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisu sœ lima kœgerœ tœnœ dœ undu ye œdœ lœ kœwusœtœ, yé œ sœ kœmbœrœ ɔtshɔrœ á sœ kœza yanga fœ Ndjaba œdœ pe fœ azu. ");
INSERT INTO kxf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lɔkɔ á Tibere, egerœ gbozu tshapa ogo Roma mbœrœ lima ungu ndjokpa dœ mindu tœ akwa, anga agbozugo sœ ndje lima kœmbœrœ akwa tshagudɨ ye. Agbozugonœ kœdœ lima Pose Pilato á tshe sœ lima pa ogo Yuda, Erode pa ogo Galilayi, ayanœ dœ Filipo sœ lima pa ogo Eturi œdœ Trakonitide, yé Lisaniase sœ lima pa ogo Abilene. ");
INSERT INTO kxf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yé Ana œdœ Kayifa kœdœ lima agbozu tshapa anganga Ndjaba. Dœ lɔndɔnœ asœmœ, Ndjaba pa o'o fœ Yowane, gbolo nœ Zakariya ɓa lœ kpagagasho. ");
INSERT INTO kxf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yowane tetœ kœna djelœ ogo kɔ á sœ ɨndɨrɨ ungu Yɔrdane, yé œ sœ kœmɨndœ o'o fœ azu adœke: «'E fatshalɔsu 'e dœ́ œ gbɔ batisimu yeka á Ndjaba kœdjerœndœ ekperœ nœ 'e kɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɓata Isaya, anga ayi kœgbara o'o su lima ala mbeti nœ ye adœke: «Anga uzu sœ kœta rawa ɓa lœ kpagagasho adœke: 'E guma ala awa Gbozu, 'e yɔrɔ ala awa ye ndjii. ");
INSERT INTO kxf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'E be kudu kɔ, kaga dœ koto kɔ œ fa akpala osho. 'E yɔrɔ ala awa á sœ tœ dengɔngɔnœ. 'E guma awa á sœ dœ kudu adœke œ sœ kpaa. ");
INSERT INTO kxf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yé azu kɔ œ wu kœshe nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ukpulu azu na lima ga ndœ Yowane adœke tshe za batisimu fœ œne. Tshe sœ lima kœpa fœ endje adœke: «Ukpulu ekpe ayakoro! Uzu ɗe dá yisœ nœ fœ 'e adœke 'e kpa awa ókó nœ Ndjaba á ndo kœna tœnœ a? ");
INSERT INTO kxf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'E mbœrœ œrœ á sœ kœma adœke 'e fatshalɔsu 'e ye, yé 'e papa mbœrœ 'e dœ tœ 'e nene adœke: “Abrayamo kœdœ ata azœ” Gbambanœ nene, mœ sœ kœmɨndœ nœ fœ 'e adœke, Ndjaba li kœfa badja asœke tœ aata Abrayamo. ");
INSERT INTO kxf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gonda sœ yindjindjinœ mbœrœ kœvwa dœ ɔyɔ tɔtœ œshenœ kɔ ye. Ɔyɔ kɔ á elenœ kœgaga nene, endje de yé œ ko va ga tœ owo.» ");
INSERT INTO kxf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Azu sœ lima kœyu Yowane adœke: «Ataa, œrœ gaɗe dá 'a kœmbœrœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tshe gi lima fœ endje adœke: «Uzu á tshe kœsœ dœ lœba okoro bisha, tshe za anganœ bale fœ tsheneke á tshe gugu dœ tœnœ nene. Yé uzu á tshe kœsœ dœ kœzɨrœ, tshe mbœrœ ndje awa bale.» ");
INSERT INTO kxf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aayi kœko ngendja lapo na ndje lima adœke Yowane za batisimu fœ œne, yé œ yu she adœke: «Ayi kœyisœrœ, œrœ gaɗe dá 'a kœmbœrœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tshe gi fœ endje adœke: «'E kaka laponœ fœ azu kœrosœ amanœ á endje za fœ 'e nene.» ");
INSERT INTO kxf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aturugu yu ndje lima she awa bale adœke: «Ka 'a, œrœ gaɗe dá 'a kœmbœrœ a?» Tshe gi fœ endje adœke: «'E koko ngendja tshaabrœ azu dœ ɔgbɔ nene; 'e papa ndje o'o dœ wala ga pa uzu nene. Kashe 'e gbe kolœ dœ ngendja tshangba akwa nœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Azu sœ lima kœkate Masiya, uzu dœ uzu sœ lima kœgbe adœke Yowane kœdœ ete she. ");
INSERT INTO kxf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yé Yowane pa fœ endje kɔ adœke: «Œmœ, mœ sœ kœza batisimu fœ 'e dœ ungu; kashe tsheneke á tshe na manda mœ, tshe ropa mœ dœ gbɔgbɔ ye; mœ lili kœka ga utshu ye dœ pe kœzu uwu œrœda nœ ye nene. Œshe, tshe za bala batisimu lœ Ɔtshɔ Ɨshirɨ œdœ dœ owo fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tshe za gbarœ kœpe dœ tshelœ indji ngwarœ ga tshaabrœ ye. Manda kœpe tœnœ, tshe gumasœ indji ngwarœnœ gala kogba nœ ye, yé œ ko oforonœ va ga tœ owo neke á ru nene.» ");
INSERT INTO kxf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ataa, Yowane mɨ lima anga angbɨ upu ndjoro fœ endje, yé œ yisœ Ɔtshɔ O'o fœ azu. ");
INSERT INTO kxf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dœ lɔkɔnœ asœmœ, Yowane gbagbara Erode á tshe dœ́ gbozugo Galilayi mbœrœ á tshe to lima Erodiade, awo ayanœ œdœ pe anga ngbɨndɨrœ ndjoro á tshe mbœrœ lima. ");
INSERT INTO kxf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yé ga pa upu á tshe mbœrœ kɔ, tshe kpa za Yowane ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Manda kœza batisimu fœ azu kɔ, Yowane za ndje batisimu fœ Yisu. Dœ lɔkɔ á Yisu sœ lima kœza avwala fœ Ndjaba, tshalafo kɔrɔ ngbɨ. ");
INSERT INTO kxf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ɔtshɔ Ɨshirɨ jerœ ga pa ye ɓata mbepa, yé tshama to ɓa lafo œ pa adœke: «Œɓœ kœdœ Gbolo nœ mœ á mœ yindœ zœ waa; mbœrœ ɓœ, mœ sœ dœ yanga.» ");
INSERT INTO kxf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisu sœ lima dœ ungu ga pa œrœ nœ́ zazu bale dœ ndjokpa (30) yeka á tetœ kœmbœrœ akwa nœ ye. Azu gbe lima adœke œshe kœdœ gbolo nœ Yozefu á tshe dœ́ Yozefu dœ gbolo nœ Eliya, ");
INSERT INTO kxf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yé Eliya kœdœ gbolo nœ Mata, Mata kœdœ gbolo nœ Levi, Levi kœdœ gbolo nœ Meleki, Meleki kœdœ gbolo nœ Yanayi, yé Yanayi kœdœ gbolo nœ Yozefu. ");
INSERT INTO kxf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yozefu kœdœ gbolo nœ Matatiase, Matatiase kœdœ gbolo nœ Amose, Amose kœdœ gbolo nœ Nawume, Nawume kœdœ gbolo nœ Eseli, yé Eseli kœdœ gbolo nœ Nagayi. ");
INSERT INTO kxf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi kœdœ gbolo nœ Maate, Maate kœdœ gbolo nœ Matatiase, Matatiase kœdœ gbolo nœ Semeyine, Semeyine kœdœ gbolo nœ Yoseke, yé Yoseke kœdœ gbolo nœ Yoda. ");
INSERT INTO kxf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda kœdœ gbolo nœ Yonane, Yonane kœdœ gbolo nœ Resa, Resa kœdœ gbolo nœ Zorobabele, Zorobabele kœdœ gbolo nœ Salatiyele, yé Salatiyele kœdœ gbolo nœ Neri. ");
INSERT INTO kxf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri kœdœ gbolo nœ Meleki, Meleki kœdœ gbolo nœ Adi, Adi kœdœ gbolo nœ Kosame, Kosame kœdœ gbolo nœ Elemadame, yé Elemadame kœdœ gbolo nœ Ere. ");
INSERT INTO kxf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere kœdœ gbolo nœ Yisu, Yisu kœdœ gbolo nœ Eliezere, Eliezere kœdœ gbolo nœ Yorime, Yorime kœdœ gbolo nœ Mata, yé Mata kœdœ gbolo nœ Levi. ");
INSERT INTO kxf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi kœdœ gbolo nœ Shimeyo, Shimeyo kœdœ gbolo nœ Yuda, Yuda kœdœ gbolo nœ Yozefu, Yozefu kœdœ gbolo nœ Yoname, yé Yoname kœdœ gbolo nœ Eliyakimi. ");
INSERT INTO kxf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimi kœdœ gbolo nœ Meleya, Meleya kœdœ gbolo nœ Mena, Mena kœdœ gbolo nœ Matata, Matata kœdœ gbolo nœ Nata, yé Nata kœdœ gbolo nœ Davidi. ");
INSERT INTO kxf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi kœdœ gbolo nœ Yese, Yese kœdœ gbolo nœ Obede, Obede kœdœ gbolo nœ Boaz, Boaz kœdœ gbolo nœ Sala, yé Sala kœdœ gbolo nœ Nashone. ");
INSERT INTO kxf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashone kœdœ gbolo nœ Aminadabe, Aminadabe kœdœ gbolo nœ Adimine, Adimine kœdœ gbolo nœ Arni, Arni kœdœ gbolo nœ Eserone, Eserone kœdœ gbolo nœ Perese, yé Perese kœdœ gbolo nœ Yuda. ");
INSERT INTO kxf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda kœdœ gbolo nœ Yakobo, Yakobo kœdœ gbolo nœ Izaka, Izaka kœdœ gbolo nœ Abrayamo, Abrayamo kœdœ gbolo nœ Tera, yé Tera kœdœ gbolo nœ Nahore. ");
INSERT INTO kxf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahore kœdœ gbolo nœ Seruge, Seruge kœdœ gbolo nœ Rewu, Rewu kœdœ gbolo nœ Pelege, Pelege kœdœ gbolo nœ Ebere, yé Ebere kœdœ gbolo nœ Shela. ");
INSERT INTO kxf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela kœdœ gbolo nœ Kenane, Kenane kœdœ gbolo nœ Arpakesade, Arpakesade kœdœ gbolo nœ Seme, Seme kœdœ gbolo nœ Nowa, yé Nowa kœdœ gbolo nœ Lameke. ");
INSERT INTO kxf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke kœdœ gbolo nœ Matusaleme, Matusaleme kœdœ gbolo nœ Enoke, Enoke kœdœ gbolo nœ Yerede, Yerede kœdœ gbolo nœ Malaleyele, yé Malaleyele kœdœ gbolo nœ Kenane. ");
INSERT INTO kxf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane kœdœ gbolo nœ Enoke, Enoke kœdœ gbolo nœ Sete, Sete kœdœ gbolo nœ Adamo, yé Adamo kœdœ gbolo nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ɔtshɔ Ɨshirɨ su lima Yisu kperœ lɔkɔ á tshe to ɓa langu Yɔrdane á gu; yé Ɨshirɨ nœ Ndjaba to she na tœnœ ga lœ kpagagasho. ");
INSERT INTO kxf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tshe lo lima ɓa zœ olo zazu bisha, yé á djaboro na kœwu lɔsu ye. Tshe zɨzɨ lima œrœ lœ olonœ asœmœ nene, yé manda nœ ogo litœ ye kpakpakpa ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Djaboro pa fœ she adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, pa fœ badja asœke œ fatœ ye tœ mapa.» ");
INSERT INTO kxf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yisu gi fœ she adœke: «Endje su ɓala Buku nœ Ndjaba adœke: “Uzu œ sœ dœ soro kolœ mbœrœ mapa nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Djaboro 'ɔ dœ she œrrr ɓa tœ anga osho á sœ ɓa lawutsha, œ yisœ Ogo gbozu nœ tshapashɔ djigi fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yé œ pa fœ she adœke: «Mœ ko ogonœ asœke dœ gbɔgbɔnœ œdœ œrœ tshelœnœ kɔ fœ ɓœ. Gbambanœ nene, Ndjaba za lima fœ mœ; mœ li kœza fœ uzu neke á mœ yindœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Œdœ ɓœ kœgote ga utshu mœ, œrœnœ kɔ œ te œnœ zœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yisu gi fœ she adœke: «Buku nœ Ndjaba pa adœke: “Ɓœ gote ga utshu Gbozu Ndjaba nœ zœ, yé ɓœ donga kolœ she tshebabale.”» ");
INSERT INTO kxf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Djaboro kpa na dœ she ɓa lakpɨ Yerusaleme œ za she ɓa pa kumu Tepelo, yé á pa fœ she adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, to ɓa ke œ ɨ tshirɨ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gbambanœ nene, endje sú ɓala Buku nœ Ndjaba adœke: “Ndjaba œ za awa fœ aandjelu nœ ye adœke endje gbɔndœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yé ga pa nœ: “Endje za ɓœ dœ kane endje ga atɨ mbœrœ á ɓœ kœzaza ada zœ tɔ badja nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yisu gi fœ she adœke: «Endje sú ɓa la Buku nœ Ndjaba adœke: “Papara awa kœwu lɔsu Gbozu Ndjaba nœ zœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Manda kœwu lɔsu Yisu dœ aka mara afara kɔ, djaboro gitœ ye tœ ye kœkate œrrr ga tœ anga olo á tshe za. ");
INSERT INTO kxf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yisu su dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ, œ kwatœ ye ga lœ Galilayi yé ɨ'ɨrɨ ye za lima osho djigi. ");
INSERT INTO kxf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tshe sœ lima kœyisœ œrœ ɓa lœ Sinagoga nœ endje, yé azu kɔ sœ kœpandœ œsœ mokɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisu na ga lœ Nazarete, tshalakpɨ á tshe gerœ lœnœ. Dœ lɔkɔ sabata, tshe li ga lœ Sinagoga lindœ mara ye. Tshe áalafo ndœ kœdɨ o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Endje za buku á ayi kœgbara o'o Isaya su, fœ she. Tshe gbara ala bukunœ ga tœ osho á endje sú adœke: ");
INSERT INTO kxf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ɨshirɨ nœ Gbozu sœ pa mœ mbœrœ á tshe ke mœ adœke mœ yisœ Ɔtshɔ O'o fœ ayi oyo. Tshe vwa mœ kœmɨndœ nœ fœ aayi kánga adœke endje wuta lœ kánga nœ endje ye, yé fœ aayibula adœke endje kpa wu osho. Tshe vwa mœ adœke mœ ko azu á endje sœ kœmbœrœ œrœ kanga fœ endje ga ushu, ");
INSERT INTO kxf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","yé mœ pandœ nœ fœ azu adœke, ungu á Gbozu yindœ kœma ɔtshɔ lɔsu nœ ye li ye.» ");
INSERT INTO kxf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Manda kœdɨ bukunœ, Yisu dje ga tœnœ œ gi fœ ayi akwa tshelœ Sinagoga, yé œ sœ ga atɨ. Azu kɔ á endje sœ lima sœndanœ, ko ala endje djɔrrr ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yé tshe tetœ kœpa fœ endje adœke: «O'onœ á 'e dji la bukunœ kpesheke asœ, œ mbœrœtœ endje ye.» ");
INSERT INTO kxf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Azu kɔ sœ lima kœpa ɔtshɔ o'o tœ upu nœ Yisu. Endje katœ ama endje tɨ ɔsɔ tœ ɔtshɔ o'o á tshe sœ lima kœpa tœnœ, yé œ tetœ kœyutœ endje adœke: «Œ dœ́dœ́ gbolo nœ Yozefu dœke nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yisu mɨndœ nœ fœ endje adœke: «Mœ wu adja sœ nœ adœke 'e pa ndœma toro asœ fœ mœ: “Monganga, shetœ zœ dœ tœ zœ.” 'E kpa pa ndje fœ mœ adœke: “'A wusœ neke kɔ á ɓœ mbœrœ lima ɓa lœ Kaparnawumu ye. Mbœrœ ndje tshetœ œrœnœ asœmœ ɓa lœ ongbo nœ zœ dœ tœ zœ ɓa ke.”» ");
INSERT INTO kxf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yé tshe kpa pa adœke: «Mœ sœ kœmɨndœ nœ fœ 'e dœ adjapu adœke, endje yiyindœ ayi kœgbara o'o ɓa lakpɨ á endje zu she tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mœ sœ kœpa fœ 'e dœ adjapu adœke, ayashe koya do lima panœ ɓa lœ Israyele lɔkɔ á Eliya sœ lima kœgbara o'o ye. Dœ lɔkɔ nœ asœmœ ndje, yavuru nini lima nene œrrr manda ungu votɔ dœ yapu mindu dœ bale, yé egerœ ogo za lima tshapa ɔshɔ djigi. ");
INSERT INTO kxf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Andaa, Ndjaba vwavwa lima Eliya fœ anga bale lœ ugurutœ endje nene. Kashe tshe vwa she kolœ ɓa ndœ anga yashe koya ɓa lœ Sarepeta, ɓa lœ ogo Sidona. ");
INSERT INTO kxf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aayi boroma sœ lima ndjoro lœ ogo Israyele lɔkɔ á Elisa dœ lima ayi kœgbara o'o. Andaa anga bale sheshe lima nene, kashe kolœ Namane á tshe kœdœ uzu ogo Siri dá she.» ");
INSERT INTO kxf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kœdji lima o'onœ asœmœ ataa, azu kɔ á endje sœ ɓa lœ Sinagoga, suku dœ ókó tɔpanœ kpuru. ");
INSERT INTO kxf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Endje áalafo ndœ Yisu œ gi she wuta tœnœ ga shu lœ ongbo, yé œ to she na tœnœ ɓa tœ leta kumu koto á endje mbœrœ ongbo nœ endje ga panœ mbœrœ á kœgeta she ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kashe tshe ro tɔ ugurutœ endje, yé œ pu œsœ awa tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisu na ga lœ Kaparnawumu, ongbo tshelœ ogo Galilayi, yé œ sœ lima kœyisœ œrœ fœ azu kɔ dœ lɔkɔ sabata. ");
INSERT INTO kxf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Azu kɨ lima tœ mara kœyisœrœ nœ ye waa, mbœrœ tshe sœ lima kœpa o'o ɓata uzu á tshe sœ dœ tshagbozu. ");
INSERT INTO kxf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anga uzu á tshe sœ lima dœ ekpe ɨshirɨ pa ye sœ ndje lima lœ Sinagoganœ. Tshe ta rawa dœ ɔgbɔ tshama ye adœke: ");
INSERT INTO kxf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ha! Yisu uzu Nazarete, ɓœ yindœ kœmbœrœ gaɗe tœ 'a? Ɓœ na mbœrœ kœwo 'a? Mœ wusœ zœ dœ ɔtshɔnœ: Œɓœ kœdœ œyerœ uzu á Ndjaba vwa she.» ");
INSERT INTO kxf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yisu ra ekpe ɨshirɨ sœmœ adœke: «Sœ koko yé œ wuta lœ uzunœ asœke!» Pe kpœtœ œsœnœ, ekpe ɨshirɨnœ za she vesho ga ugurutœ azu yé œ wuta lœ ye, kashe œ mbœmbœrœ ekperœ tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Azu kɔ kɨ lima tœ œsœnœ yé œ tetœ kœyutœ endje adœke: «Asœ kœdœ mara o'o gaɗe? Tshe pa o'o dœ tshagbozu œdœ pe dœ gbɔgbɔ fœ ekpe ɨshirɨ, yé ekpe ɨshirɨ wuta ye.» ");
INSERT INTO kxf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yé ɨ'ɨrɨ Yisu za osho djigi lœ tshakala ogonœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisu wuta lima lœ Sinagoga, œ na ɓa sœnda nœ Shimu. Ayi mbeya Shimu sœ lima dœ ɔgbɔ koɓa biwa, yé endje kɨ fœ Yisu adœke tshe she she. ");
INSERT INTO kxf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yisu gitœ ye ndo dœ she, œ pa o'o dœ ɔgbɔ yé koɓa biwanœ katœ ye yé! Pe kpœtœ œsœnœ, tshe áalafo œ tetœ kœmbœrœ akwa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dœ kɨdala, azu na lima dœ mara koɓa nœ endje ngbangbangba fœ Yisu. Tshe to kane ye ga pa endje bale dœ bale, yé endje she ye. ");
INSERT INTO kxf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ekpe ɨshirɨ wuta ndje lima lœ azu ndjoro dœ kœta rawa adœke: «Œɓœ kœdœ Gbolo nœ Ndjaba!» Kashe Yisu ra lima aekpe ɨshirɨnœ adœke endje pupu o'o bale nene. Gbambanœ nene, endje wusœ nœ adœke Yisu kœdœ Masiya. ");
INSERT INTO kxf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lɔkɔ á osho kɔrɔ, Yisu wuta lœ ongbonœ asœmœ œ na ga lœ kpagagasho. Azu ndjoro na lima kœpara she. Lɔkɔ á endje gbɔ she, endje yiyindœ nœ adœke tshe gitœ ye tœ œne nene. ");
INSERT INTO kxf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kashe Yisu pa fœ endje adœke: «Œ li adœke mœ mɨ ndje ndœ Ɔtshɔ O'o nœ ogo Gbozu Ndjaba ɓa lœ anga angbɨ ongbo. Gbambanœ nene, mbœrœ tœnœ dá Ndjaba vwa mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yé tshe yi lima sœ œrœ djelœ Sinagoga lœ ogo Yuda. ");
INSERT INTO kxf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dœ anga ɔlɔ bale, Yisu sœ lima kœyisœ œrœ ɨndɨrɨ mangu Genazarete, yé azu ndjoro ndɨvwɨrɨ she mbœrœ kœdji o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tshe wu agba bisha ɓa tœ mangunœ, kashe ayi kœpara ageatshalangu jerœ œ sœ kœdjutɔ gbanda nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yisu 'ɔ ga lœ anga agbanœ bale á dœ́ œnœ Shimu, yé œ pa fœ she adœke tshe katœ mangunœ œ gi agbanœ teasho ga uguru ungu. Tshe sœ ga atɨ ga lœ agba yé œ tetœ kœyisœ œrœ fœ ukpulu azu. ");
INSERT INTO kxf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lɔkɔ á tshe yisœ œrœnœ á ka ye, tshe pa fœ Shimu adœke: «Gi agbanœ ɓa tœ œsœ dili ungu, yé 'e vwi gbanda nœ 'e mbœrœ kœko ageatshalangu.» ");
INSERT INTO kxf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Shimu gi fœ she adœke: «Ayi kœyisœrœ, 'a wu oyo dœ butshɔ 'owara, 'a gbɔgbɔ œrœ bale nene. Kashe ɓata á ɓœ pa fœ mœ ye, mœ vwi gbandanœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Endje vwi gbanda œ ko lima ageatshalangu ndjoro, yé tshelœ gbanda nœ endje te lima tœ kœsuru tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Endje wu ata, œ gavwa anga anga endje á endje sœ ɓa lœ anga angbɨ agba adœke, endje na dœ́ œne gbota gbandanœ dœ endje. Endje na, yé œ ko ageatshalangu œrrr kperœ dœ agba bibisha. Ama agba sœ pe lima teasho adœke œ nduru dœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lɔkɔ á Shimu Petro wu ata, tshe gote dœ matshukuda ye ga utshu Yisu yé œ pa adœke: «Gbozu, gitœ zœ tœ mœ lœ ɨngɨrɨnœ, mbœrœ œmœ kœdœ ayi kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Awa za lima Shimu dœ anganœ kɔ á endje na dœ endje, tœ kœwu ageatshalangu ndjoro á endje vwi endje. ");
INSERT INTO kxf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Awa za ndje lima Ajake dœ Yowane, agbolo nœ Zebedayi á endje dœ lima aanga Shimu. Kashe Yisu pa fœ Shimu adœke: «Sœsœ dœ awa nene. Kœto kpesheke, ɓœ kpa dœ ayi kœpara ageatshalangu nene kashe ɓœ te ayi kœpara azu.» ");
INSERT INTO kxf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Endje gi agba nœ endje kɔ ga tœ mangu, œ katœ œrœ kɔ yé œ te manda ye. ");
INSERT INTO kxf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɔlɔ bale, Yisu sœ lima ɓa lœ anga ongbo bale á anga ayi boroma sœ lœnœ. Lɔkɔ á tshe wu lima Yisu, tshe na œ gote ga utshu ye, œ kɨ fœ she adœke: «Ayi kœyisœrœ, œdœ ɓœ kœyindœ nœ, ɓœ she mœ adœke mœ wuta yerœ.» ");
INSERT INTO kxf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yisu yi kane ye, œ goro she yé á pa fœ she adœke: «Mœ yindœ nœ adœke ɓœ she ye.» Pe tœ œsœnœ, koɓa boromanœ kœkatœ uzunœ asœmœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yisu kœpa fœ she adœke: «Papandœ nœ fœ uzu bale nene, kashe gu œ matœ zœ fœ nganga Ndjaba, yé œ to tokóró ɓata á Moyize pa lima ndœ nœ mbœrœ kœma fœ azu adœke ɓœ she lœ koɓa ye.» ");
INSERT INTO kxf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Endje sœ lima kœpa o'o tœ œrœ á Yisu sœ kœmbœrœ tœnœ djezœ ngbangbangba. Azu ndjoro sœ lima kœngbɔtœ endje mbœrœ kœdji she, yé œ sœ ndje kœshe lœ koɓa nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kashe Yisu gitœ ye ugurutœ azu, œ na ga lœ kpagagasho mbœrœ kœza avwala. ");
INSERT INTO kxf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dœ anga olo bale, Yisu sœ kœyisœ œrœ atake, Afarisayi œdœ agbozu kœyisœ awa akwa sœ lima zœ. Endje to lima dje lakpɨ ogo Galilayi, lakpɨ ogo Yuda œdœ ndje lœ ongbo Yerusaleme. Gbɔgbɔ nœ Gbozu Ndjaba sœ lima dœ Yisu, yé tshe sœ kœshe aayi koɓa. ");
INSERT INTO kxf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yé azu za anga uzu á ada ye tshu ga pa kondja, œ na dœ she. Endje sœ lima kœpara awa adœke œne li dœ she ga sœnda œ za she ɓa utshu Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kashe ɓata á azu ngba lima tɔpanœ kpuru, awa adœke endje li dœ she gugu nene. Endje ɔ, œ kɔrɔ ogoro ɓa pa anda yé œ yi she dœ kondjanœ ɓa ugurutœ azu, ndjii kpœtshu Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lɔkɔ á Yisu wu kœyindœrœ nœ endje, tshe pa fœ ayi koɓanœ adœke: «Mœ djerœndœ ekperœ nœ zœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aayi kœyisœ awa akwa dœ Afarisayi te lima tœ kœgbetshelœ endje adœke: «Tsheneke kœdœ uzu ɗe á sœ kœgu œsœ́ Ndjaba ataa? Œɗe dá li tœ kœdjerœndœ ekperœ nœ uzu a? Œ dœ́dœ́ Ndjaba kutɨ ye nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kashe Yisu wu lima sœ gbetshelœ nœ endje kɔ, yé œ yu endje adœke: «Mbœrœ gaɗe á 'e gbe o'o tœ lɔsu 'e atake a? ");
INSERT INTO kxf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kœpa fœ uzunœ adœke: “Mœ djerœndœ ekperœ nœ zœ” too kœpa adœke: “Aalafo œ na ana”, o'o neketa dá dœ́ ɔgbɔ o'o a? ");
INSERT INTO kxf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kashe mœ pa o'onœ asœke mbœrœ á 'e kœwusœ nœ adœke kpœ pa ɔshɔ asœ, Gbolo nœ uzu dá sœ dœ gbɔgbɔ mbœrœ kœdjerœndœ ekperœ.» Yé tshe kœpa fœ uzu á ada ye tshu adœke: «Mœ pa fœ ɓœ, alafo œ za kondja nœ zœ yé œ gu ga sœnda nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pe kpœtœ œsœnœ, uzunœ áalafo dœ ala azu kɔ, œ za gbarœ á tshe lo ga panœ, yé œ gu ga sœnda nœ ye dœ kœdonga mokɔ nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Uvuru azu kɔ kpa lima lœ nœ, endje donga Ndjaba yé awa ko endje kɔ, á endje pa adœke: «A wu kpesheke œrœ á a wuwu ɓa lima nene.» ");
INSERT INTO kxf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Manda nœ, Yisu wuta yé œ wu anga ayi kœko ngendja lapo bale á ɨ'ɨrɨ ye kœdœ Levi, tshe sœ ɓa lœ anda kœko ngendja lapo. Tshe pa fœ she adœke: «Na manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi katœ œrœ nœ ye kɔ, œ áafo yé œ na manda ye. ");
INSERT INTO kxf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Manda nœ, Levi mbœrœ egerœ angbo ɓa sœnda nœ ye fœ Yisu. Azu kœko ngendja lapo ndjoro, dœ pe anga azu sœ lima kœzɨ œrœ dœ endje awa bale. ");
INSERT INTO kxf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Afarisayi dœ aayi kœyisœ awa akwa te lima tœ kœpulœma endje, yé œ yu ayambarœ nœ Yisu adœke: «Mbœrœ gaɗe á 'e sœ kœzɨ œrœ yé á sœ kœndjo œrœ awa bale dœ aayi kœko ngendja lapo œdœ pe aayi kœmbœrœ ekperœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yisu kœgi fœ endje adœke: «Œ dœ́dœ́ azu á tshelœ ɔkɔ endje sœ yerœ dá gbe kœna kœwu monganga nene, kashe kolœ aayi koɓa dá gbe ndœ kœna kœwu she. ");
INSERT INTO kxf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mœ nana kœ'e azu á endje sœ ndjii nene, kashe mœ na mbœrœ azu kœmbœrœ ekperœ adœke endje fatshalɔsu endje.» ");
INSERT INTO kxf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Anga azu yu lima Yisu adœke: «Ayambarœ nœ Yowane ayi kœza batisimu œdœ pe endje nœ Afarisayi sœ lima kœyotshelœma endje mbœrœ kœza avwala fœ Ndjaba. Kashe mbœrœ gaɗe á ayambarœ nœ zœ sœ kœzɨ œrœ, á sœ kœndjo œrœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yisu kœgi fœ endje adœke: «Œdœ endje kœ'e azu ndœ angbo totœ, yé uzu á tshe to yashenœ sœpe damba tœ œsœnœ dœ endje, 'e li kœpa fœ azunœ asœmœ adœke endje yotshelœma endje ye a? Œ̃ œ̃ nene. ");
INSERT INTO kxf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kashe lɔkɔ á endje kœza akɔ yashenœ ugurutœ anganœ, dá ɔlɔnœ á endje yotshelœma endje dœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisu kpa pa anga ndœma toro bale fœ endje adœke: «Uzu bale zaza ndœma tafo lœba œ pi ga pa ongboro lœba nene. Œdœ tshe kœmbœrœ ataa, tshe ndɨ tafo lœbanœ, yé ndœma tafo lœba lili dœ ongboro lœbanœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uzu bale susu tafo ipi á sœ kœyu damba vavava ga lœ ongboro anga nene. Atamœ nene, tshelœ anga œ 'u dœ katsha tafo ipinœ á sœ kœyu vavava asœmœ: Tshelœ anga œ ndɨ yé ipi œ tu kpa ga lœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kashe œ li adœke endje sú tafo ipi ga lœ tafo anga. ");
INSERT INTO kxf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yé uzu bale á tshe yindœ kœndjo tafo ipi manda ongboro ipi gugu nene. Gbambanœ nene, endje pa walaka adœke: “Ongboro ipi dá tshɔ kœropa tafonœ.”» ");
INSERT INTO kxf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dœ anga ɔlɔ sabata bale, Yisu sœ lima kœro tɔ lœ kɨndɨ ble awa bale dœ ayambarœ nœ ye. Yé ayambarœnœ sœ lima kœverœ indji blenœ, œ sœ kœkɔrɔnɔ dœ kane endje yé á sœ kœzɨ indjinœ. ");
INSERT INTO kxf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anga Afarisayi yu endje adœke: «Mbœrœ gaɗe á 'e sœ kœmbœrœ œneke á awa akwa pakata nœ dœ olo sabata a?» ");
INSERT INTO kxf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yisu gi fœ endje adœke: «'E dɨdɨ œneke á Davidi mbœrœ anga ɔlɔ bale á ogo mi lima she dœ azu nœ ye á tshe na tœ awa dœ endje nene a? ");
INSERT INTO kxf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tshe li dœ endje ɓa lœ anda nœ Ndjaba, yé œ zɨ mapa á endje to dœ tokóró fœ Ndjaba. Tshe zɨ yé œ to anganœ fœ azu á endje na tœ awa nœ dœ she, mapa á sœ má kolœ mbœrœ anganga Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yisu kpa gi fœ endje adœke: «Gbolo nœ uzu kœdœ ayengɔ lɔkɔ sabata.» ");
INSERT INTO kxf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Œ kpa wuta ga tœ anga lɔkɔ sabata bale, Yisu li ga lœ Sinagoga œ tetœ kœyi lima sœ œrœ. Anga uzu bale á kuni ye tshu, sœ lima kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aayi kœyisœ awa akwa œdœ pe Afarisayi mesho lima lœ ala endje kœwu too Yisu œ she uzunœ asœmœ dœ lɔkɔ sabata, yeka á œne kœgbɔ awa kœtɔ meza pa ye. ");
INSERT INTO kxf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kashe tshe wu lima sœ gbetshelœ nœ endje, yé œ pa fœ uzunœ á kane ye tshu asœmœ adœke: «Aalafo, œ na œ ka ɓa ugurunœ.» Uzunœ áalafo œ na œ ka ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Manda nœ, Yisu yu endje adœke: «Œrœ gaɗe dá awa akwa nœ azœ yindœ nœ adœke a mbœrœ kolœ dœ lɔkɔ sabatanœ a? Œ yindœ nœ adœke a mbœrœ ɔtshɔrœ too a mbœrœ ekperœ a? Kœshe uzu too kœwo she a?» ");
INSERT INTO kxf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tshe tondœ endje kɔ, yé œ pa fœ uzu koɓanœ adœke: «Yɔrɔ tshelœ kane zœ!» Tshe yɔrɔ tshelœ kane ye, yé kane ye gumatœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tshelœ aayi kœyisœ awa akwa œdœ Afarisayi sœ gboo dœ ókó, yé endje tetœ kœvwarandœ o'o ugurutœ endje tœ œrœ neke á endje mbœrœ ga tœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lœ ɔlɔnœ asœmœ, Yisu ɔ ga pa kaga mbœrœ kœza avwala, yé œ donga Ndjaba butshɔ 'owara. ");
INSERT INTO kxf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lɔkɔ á osho kɔrɔ, tshe e ayambarœ nœ ye œ rɔtshelœ endje ndjokpa dœ bisha, yé á ta ɨ'ɨrɨ «aayi avwa» ga pa endje. ");
INSERT INTO kxf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ɨ'ɨrɨ aayi avwanœ ndjokpa dœ bisha dœke: Shimu á Yisu za ndje ɨ'ɨrɨ Petro ga pa ye œdœ ayanœ dœ Andere, Jake œdœ Yowane, Filipo œdœ Bartelemi, ");
INSERT INTO kxf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie œdœ Toma, Jake gbolo nœ Alefe œdœ Shimu á tshe sœ ndje lima ugurutœ azu á endje sœ kœpara adœke ogo nœ œne gbɔ lipanda, ");
INSERT INTO kxf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudasi, gbolo nœ Jake œdœ Yudasi Isikariote á tshe ka lima Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisu to dœ endje ɓa pa kaga, yé œ jerœ œ ka ga tœ osho á sœ kpaa. Dá asœmœ, ayambarœ nœ ye œdœ azu ndjoro: Azu tshelœ ogo Yuda kɔ, azu tshalakpɨ Yerusaleme, azu tshalakpɨ Tire œdœ pe Sidona sœ lima kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Endje na lima kœdji Yisu œdœ kœpara awa kœshe lœ koɓa nœ endje. Endjeneke á endje sœ lima dœ ekpe ɨshirɨ, she lima ye. ");
INSERT INTO kxf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Uzu kɔ sœ lima kœpara awa kœgoro she mbœrœ gbɔgbɔ sœ lima kœwuta lœ ye, yé á sœ kœshe azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisu tondœ ayambarœ nœ ye œ pa adœke: «Yanga nœ 'e á 'e dœ́ aayi oyo, gbambanœ nene, Ogo gbozu nœ Ndjaba sœ mbœrœ 'e! ");
INSERT INTO kxf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yanga nœ 'e á 'e sœ dœ ogo ngɔngɔnœ asœke, gbambanœ nene, 'e gbɔ kœzɨrœ ndjoro! Yanga nœ 'e á 'e sœ tœ ɨkɨ ngɔngɔnœ asœke, gbambanœ nene, 'e mɔtœ 'e zœ! ");
INSERT INTO kxf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Œdœ azu kœyiangba 'e, á kœgɔrɔ 'e, á kœgu 'e yé á sœ kœpa tœ ekperœ nœ 'e mbœrœ a 'e yindœ Gbolo nœ uzu, 'e sœ dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lɔkɔ á œrœ nœ asœmœ kœmbœrœtœ endje, 'e sœ dœ yanga œ i ga lafo dœ yanga mbœrœ egerœ œrœ sœ kœkate 'e ɓa lafo. Ataa dá aata endje sœ kœmbœrœ lima œrœ kanga fœ aayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kashe oyo nœ 'e dœ́ aayi kœgbɔrœ, gbambanœ nene, 'e gbɔ œrœ tshangba œnœ 'e ye! ");
INSERT INTO kxf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Oyo nœ 'e á 'e sœ dœ œrœ ndjoro ngɔngɔnœ asœke, gbambanœ nene, ogo œ mi 'e zœ! Oyo nœ 'e á 'e sœ kœmɔtœ 'e ngɔngɔnœ asœke, gbambanœ nene, 'e sœ lœ oyo, yé 'e kɨ bala zœ! ");
INSERT INTO kxf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Oyo nœ 'e œdœ azu kœsœ kœpatœ ɔtshɔrœ nœ 'e, gbambanœ nene, œtœnœ kœdœ mara á aata endje mbœrœ lima ga tœ aayi kœgbara o'o nœ wala!» ");
INSERT INTO kxf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kashe mœ sœ kœpa fœ 'e á 'e sœ kœdji mœ asœke, adœke: 'E yindœ ayingba 'e œ mbœrœ ɔtshɔrœ fœ endjeneke á endje sœ kœyiangba 'e. ");
INSERT INTO kxf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","'E kɨ fœ Ndjaba tshe to kane ye ga pa endjeneke á endje sœ kœdarandœ 'e, yé œ za avwala fœ she mbœrœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Œdœ uzu kœda baga zœ, fa tshakalanœ fœ she dœ́ tshe da ndje. Œdœ uzu kœza yɔgbɔdɔ lœba nœ zœ, katœ lœba okoro nœ zœ tɨ fœ she tshe za ndje. ");
INSERT INTO kxf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","To œrœ fœ uzu neke kɔ á tshe esho ndœ œrœ tœ zœ. Yé œdœ uzu kœza œrœ nœ zœ, yuyu she adœke tshe gi fœ ɓœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'E mbœrœ fœ anga 'e adja ɓata œneke á 'e yindœ nœ adœke endje mbœrœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Œdœ 'e kœyi kolœ ndœ endjeneke á endje yindœ 'e, œrœ tshangbanœ á 'e gbɔ kœdœ gaɗe? Awa bale ndje, aayi kœmbœrœ ekperœ yiyi ndje ndœ endjeneke á endje lœ kœyindœ endje! ");
INSERT INTO kxf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yé œdœ 'e kœsœ kolœ kœmbœrœ ɔtshɔrœ fœ endjeneke á endje mbœrœ ɔtshɔrœ fœ 'e, œrœ tshangbanœ á 'e gbɔ kœdœ gaɗe? Aayi kœmbœrœ ekperœ sœ ndje kœmbœrœ atamœ. ");
INSERT INTO kxf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Œdœ 'e kœsœ kœdaka kuɗa kolœ fœ endjeneke á 'e sœ kœgbe kœgbɔ anga œrœ ɓa ndœ endje, œrœ tshangbanœ á 'e gbɔ kœdœ gaɗe? Ayi kœmbœrœ ekperœ sœ ndje kœdaka kuɗa fœ ayi kœmbœrœ ekperœ yeka á endje gi tshangbanœ awa bale fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kashe 'e yindœ azu neke á endje yiangba 'e, œ mbœrœ ɔtshɔrœ fœ endje. Œdœ 'e kœdaka œrœ tœ kuɗa fœ endje, 'e sœsœ dœ gbetshelœ adœke endje gi fœ 'e nene. Dœ tœnœ ataa, 'e gbɔ œrœ tshangbanœ dœ egerœnœ, yé 'e te agbolo nœ Ndjaba á tshe ropa œrœ kɔ. Gbambanœ nene, mbœrœ tshe sœ kœmbœrœ ndje ɔtshɔrœ fœ endjeneke á endje sœ kœmbœrœ ekperœ fœ she, œdœ pe fœ aayi katshalɔsu. ");
INSERT INTO kxf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'E sœ dœ ɔtshɔ lɔsu ga tœ azu ɓata á Aba 'e sœ dœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«'E wawa o'o ga pa uzu bale nene, yeka á Ndjaba kœwa ndje bala o'o ga pa 'e nene. 'E wawa agbɔ ngbanga ga pa anga 'e nene, yeka á Ndjaba kœwawa ndje agbɔ ngbanga bala ga pa 'e nene. 'E wu oyo anga 'e yeka á Ndjaba kœwu ndje bala oyo 'e. ");
INSERT INTO kxf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'E to œrœ fœ anga 'e, yeka á Ndjaba kœto ndje œrœ fœ 'e: Gbambanœ nene, tshe to œrœ ga lœ ngbade lœba nœ 'e ndjoro, tshe nduru yé œ yeme œtœnœ adœke œ su kperœ. Ndjaba œ to œrœ fœ 'e kolœ lindœ œneke á 'e sœ kœto tœnœ fœ anga 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yisu kpa pa dœ ndœma toro fœ endje adœke: «'E wu anga ayibula kœyisœ awa fœ yanganœ dœ ayibula ye a? Œdœ tshe kœto she ataa, endje yo kɔ bibisha ga lœ kudu nene a? ");
INSERT INTO kxf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yambarœ roropa ayi kœyisœrœ fœ she nene. Kashe yambarœ kɔ á tshe wusœ œrœ dœ ɔtshɔnœ, tshe wuta ndje ɓata ayi kœyisœrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mbœrœ gaɗe á ɓœ sœ kœtondœ oforo ebe á sœ lœ ala aya zœ, yé á gbegbe ndœ maɓaya á sœ lœ ala zœ nene a? ");
INSERT INTO kxf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɓœ sœ kœpa fœ aya zœ adœke: “Aya mœ, kaka mœ tshakavwa oforo ebe á sœ lœ ala zœ”, œɓœ á ɓœ sœsœ kœwu maɓaya á sœ lœ ala zœ nene, ɓœ pa má ata kotoo? Wulapatshɔ, tshakavwa maɓaya á sœ lœ ala zœ utshunœ œ wu osho ngbɨ, yeka á kœtshakavwa oforo ebe á sœ lœ ala aya zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Ɔtshɔ ɔyɔ zuzu ekpe leyɔ nene, yeka á dœ ɔyɔ á sœ dœ koɓa kœzu ɔtshɔ leyɔ nene. ");
INSERT INTO kxf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Endje wusœ ɔyɔ dœ ɔyɔ mangba elenœ. Endje kɔkɔ ele fige ɓa tœ batima nene. Endje kɔkɔ ndje lekpɔ ɓa lœ nduku akpala nene. ");
INSERT INTO kxf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɔtshɔ uzu sœ kœma ɔtshɔrœ á sœ ɓa lɔsu ye, yé ekpe uzu sœ kœma ekperœ á sœ ndje ɓa lɔsu ye. Gbambanœ nene, o'o kɔ á wuta lœ ama uzu, œ to ɓa lɔsu ye á su kperœ dœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mbœrœ gaɗe á 'e sœ kœ'e mœ adœke: “Gbozu, Gbozu”, yé á sœsœ kœmbœrœ neke á mœ sœ kœpa tœnœ fœ 'e nene a? ");
INSERT INTO kxf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Uzu kɔ á tshe na ga ndœ mœ, á tshe dji o'o ama mœ yé á za ga tœ akwa, tshe li dœ ɗe? Mœ sœ kœpa fœ 'e adœke: ");
INSERT INTO kxf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tshe li dœ uzu á tshe mɔ anda: Tshe dji kudu kiti anda ngbɨɨ œ gbɔ badja, yeka á ko briki ga lœ œporonœ. Lɔkɔ á ungu su, œ tara kpɔɔ ga tœ ada andanœ, kashe andanœ kakavwa lima nene, mbœrœ endje mɔ lima kiti andanœ ngbɨrɨ. ");
INSERT INTO kxf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kashe tsheneke á tshe dji o'o ama mœ yé á zaza ga tœ akwa nene, tshe sœ ɓata uzu á tshe djidji kudu kiti anda nœ ye á wuta ga pa badja nene, á mɔ ga pa ɔshɔ gbambanœ. Lɔkɔ á ungu su ga tœ ada andanœ, œ kavwa yé tshelœnœ ndjɔ djigi ye.» ");
INSERT INTO kxf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lɔkɔ á Yisu pa o'o nœ ye kɔ fœ azu á endje sœ lima kœdji she, tshe na ga lœ Kaparnawumu. ");
INSERT INTO kxf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Anga gbozu tshapa aturugu tshelœ Roma sœ lima dœ anga kanga nœ ye bale á tshe yindœ ye tɔpanœ kpuru. Kanganœ asœmœ sœ lima dœ koɓa, ndoo dœ kuzu. ");
INSERT INTO kxf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lɔkɔ á gbozu tshapa aturugunœ dji upu nœ Yisu, tshe vwa anga agbɔ agbozu Ikrizia adœke endje na œ kɨ fœ she dœ́ tshe na œ she kanga nœ œne. ");
INSERT INTO kxf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Endje wuta ɓa ndœ Yisu, yé œ kɨ fœ she kpœpanœ kpœpanœ adœke: «Uzunœ á tshe vwa 'a kœdœ ɔtshɔ uzu, œ li adœke ɓœ mbœrœ œrœ á tshe pa tœnœ, fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gbambanœ nene, tshe yindœ ogo nœ azœ yé œshe dá mɔ Sinagoga fœ azœ.» ");
INSERT INTO kxf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yé Yisu gu tœ awanœ bale dœ endje. Lɔkɔ á tshe wuta lima ndoo dœ anda, gbozu tshapa aturugu vwa anganœ mbœrœ kœpa fœ Yisu adœke: «Ayi kœyisœrœ, wuwu oyo tœ zœ nene, mbœrœ mœ sœsœ ndjii adœke ɓœ kœli ga lœ anda nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mbœrœ tœnœ ndje ataa á mœ wa adœke, mœ na dœ tœ mœ œrrr ga ndœ zœ nene; kashe pa kolœ o'o bale dœ́ kanga nœ mœ á mœ yindœ ye waa, she. ");
INSERT INTO kxf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Œmœ ndje, mœ sœ dœ agbozu tshapa mœ á mœ sœ kœdji endje, yé dœ aturugu á endje sœ tshakudu mœ. Œdœ mœ kœpa fœ anga bale adœke: “Na”, ngbewo tshe na da ye. Œdœ mœ kpa kœpa ndje fœ anga adœke: “Na ga mœ”, ngbewo tshe na ye. Yé œdœ mœ kœpa ndje fœ kanga nœ mœ adœke: “Mbœrœ œrœnœ asœ”, ngbewo tshe mbœrœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lɔkɔ á Yisu dji o'onœ asœmœ, tshe sœ dœ yanga ga ndœ ye. Tshe fatœ ye ga ndœ ukpulu azu á endje sœ lima kœna manda ye, yé œ pa fœ endje adœke: «Mœ sœ kœmɨndœ nœ fœ 'e adœke, œdœ ndje ɓa ugurutœ azu Israyelenœ gbaa, mœ gbɔgbɔ mara kœyindœrœ sœke nene.» ");
INSERT INTO kxf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lɔkɔ á azunœ á gbozu tshapa aturugu vwa endje, gu ɓa sœnda nœ gbozu tshapa aturugunœ ɓa zœ, endje gbɔ ayi akwanœ tshe sœ dœ ɔtshɔ ɔkɔ ye. ");
INSERT INTO kxf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Manda nœ, Yisu ro ga lœ anga ongbo bale á ɨ'ɨrɨnœ kœdœ Nayine. Ayambarœ nœ ye œdœ pe ukpulu azu ndjoro sœ lima kœna tœ awanœ bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lɔkɔ á endje wuta lima ndoo tœ kœli ga lœ ongbonœ atake, endje gbɔtœ endje dœ ukpulu azu ndjoro á endje sœ lima kœna ndœ kœshi kuzu: Œ dœ lima gbolo yakoshe tshebabale nœ anga yashe koya. Azu tshelœ ongbonœ ndjoro na lima tœ awa bale dœ yashenœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lɔkɔ á Gbozu wu yashenœ asœmœ, oyo ye ká she yé tshe pa fœ she adœke: «Kpa kɨkɨ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yisu gitœ ye ga utshunœ œ goro ngbongbo kuzunœ. Azu á endje za lima ngbongbonœ ka, yé Yisu pa adœke: «Ovoro gbolo yakoshe, mœ pa fœ ɓœ, jo ye!» ");
INSERT INTO kxf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngbewo kuzunœ sœ ga atɨ, œ tetœ kœpa o'o. Yé Yisu za she fœ ayinœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Awa li lima tœ azu para kɔkɔ, yé endje te lima tœ kœdonga Ndjaba adœke: «Egerœ ayi kœgbara o'o wuta ga lœ ugurutœ azœ!» Yé œ kpa pa ndje adœke: «Ndjaba na kœshe azu nœ ye!» ");
INSERT INTO kxf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yé o'o tœ́ upu nœ œrœnœ á Yisu mbœrœ asœmœ za tshelœ lœ ogo Yuda œdœ tshalakpɨ kɔ á sœ ɨndɨrɨnœ ndjengene. ");
INSERT INTO kxf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ayambarœ nœ Yowane pandœ akwa kɔ á Yisu mbœrœ asœmœ fœ she. Tshe e anga endje bisha ugurutœ endje, ");
INSERT INTO kxf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yé œ vwa endje fœ Gbozu Yisu kœyu she adœke: «Œɓœ kœdœ Masiya á tshe sœ kœna tœnœ a, too 'a kate anga angbɨ uzu?» ");
INSERT INTO kxf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lɔkɔ á endje wuta ɓa ndœ Yisu, endje pa fœ she adœke: «Yowane ayi kœza batisimu vwa 'a ɓa ndœ zœ mbœrœ kœyu ɓœ adœke: “Œɓœ kœdœ Masiya á tshe sœ kœna tœnœ a, too 'a kate anga angbɨ uzu?”» ");
INSERT INTO kxf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kolœ dœ lɔndɔnœ asœmœ, Yisu she azu ndjoro lœ koɓa nœ endje, lœ kœndɨ nœ endje. Tshe gɔrɔ ekpe ɨshirɨ pa endje yé œ she ndje aayibula. ");
INSERT INTO kxf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Manda nœ, tshe gi lima fœ azu á Yowane vwa endje adœke: «'E gu œ pandœ neke á 'e wu dœ ala 'e yé á dji dœ utu 'e, fœ she. 'E pandœ nœ adœke: “Aayibula tetœ kœwu osho, azu á ada endje tshu tetœ kœna ana, aayi boroma she, aayi bitu tetœ kœdji o'o, akuzu kwatœ endje ga lœ soro, yé endje pandœ Ɔtshɔ O'o fœ aayi oyo. ");
INSERT INTO kxf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yanga nœ uzu á tshe kakatœ kœyindœrœ nœ ye ga ndœ mœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lɔkɔ á aayi avwa nœ Yowane gu lima da ye, Yisu tetœ kœpa tœ upu nœ Yowane fœ ukpulu azu asœmœ adœke: «Œrœ gaɗe dá 'e na kœwu tœnœ ɓa lœ kpagagasho a? 'E na kœwu mulu á yugu sœ kœmea tœnœ kpangi kpangi a? Œ̃ œ̃ nene. ");
INSERT INTO kxf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yé ata œrœ gaɗe dá 'e na lima kœwu tœnœ a? 'E na kœwu uzu á tshe verœ ɔtshɔ lœba a? Œ̃ œ̃ nene. Gbambanœ nene, azu á endje sœ kœverœ ɔtshɔ lœba, yé á sœ dœ œrœ waa, endje sœ ɓa lœ anda nœ agbozugo. ");
INSERT INTO kxf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ata 'e na lima ndœ kœwu gaɗe? 'E na kœwu anga ayi kœgbara o'o a? Œ̃, kashe mœ sœ kœmɨndœ nœ fœ 'e adœke tshe rosœ ayi kœgbara o'o ye. ");
INSERT INTO kxf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gbambanœ nene, Yowane kœdœ uzu á endje pa o'o tœ upu nœ ye ɓa la buku nœ Ndjaba adœke: “Mœ vwa ayi avwa nœ mœ utshu zœ mbœrœ kœguma ala awa zœ.”» ");
INSERT INTO kxf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yé Yisu kpa pa adœke: «Mœ sœ kœmɨndœ nœ fœ 'e adœke lœ ugurutœ azu tshapashɔ asœ kɔ, uzu bale á tshe ropa Yowane gugu nene. Kashe aya uzu ɓa lœ ogo Gbozu nœ Ndjaba ropa ye ye.» ");
INSERT INTO kxf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Azu para kɔkɔ dœ pe aayi kœko ngendja lapo á endje dji o'o má Yowane pa, wusœ nœ adœke Ndjaba sœ ndjii yé œ gbɔ lima batisimu nœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kashe Afarisayi œdœ aayi kœyisœ awa akwa vwaratœ endje kœyindœ œrœ á Ndjaba yindœ kœmbœrœ fœ endje, yé œ tshapu kœgbɔ batisimu nœ Yowane ye.» ");
INSERT INTO kxf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yisu kpa pa adœke: «Mœ li mara azu nœ asœ dœ azu ɗe? Endje li dœ azu ɗe? ");
INSERT INTO kxf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Endje liili dœ agbolo á endje sœ ɓa ushu, yé á sœ kœ'etœ endje lœ tœ endje adœke: “'A 'uru ngbake fœ 'e, kashe 'e vivi ipi nene! 'A ɓi itshi kuzu fœ 'e, kashe 'e kɨkɨ nene!” ");
INSERT INTO kxf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gbambanœ nene, Yowane ayi kœza batisimu na, œ vwaratœ ye tœ kœzɨ mapa œdœ kœndjo ipi, 'e pa adœke: “Tshe sœ dœ ekpe ɨshirɨ pa ye!” ");
INSERT INTO kxf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gbolo nœ uzu na œ sœ kœzɨ mapa dœ kœndjo ipi, 'e pa adœke: “'E wu uzunœ asœ, tshe gbe kolœ dœ kœzɨrœ œdœ kœndjorœ, yé anganœ kœdœ aayi kœko ngendja lapo œdœ pe azu kœmbœrœ ekperœ.” ");
INSERT INTO kxf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kashe kœwusœtœ nœ Ndjaba matœ ye ndjii lœ awa nœ azu kɔ á endje yindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anga Farisayi bale vwa osho fœ Yisu adœke tshe na kœzɨ œrœ ɓa ndœ œne. Yisu li ga sœnda nœ Farisayinœ asœmœ, yé œ sœ ga ɨndɨrɨ ndaba kœzɨrœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kashe anga yashe bale á akwa tshelœ ye gaga nene sœ lima lœ ongbonœ asœmœ. Lɔkɔ á tshe dji adœke Yisu sœ kœzɨ œrœ ɓa ndœ Farisayi, tshe za yombo kperœ dœ anga albatre yé œ na dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tshe ka djagamanda Yisu, œ gote ndoo dœ ada ye. Tshe sœ lima tœ ɨkɨ, yé ngola ye sara œ gba lima tshapa ada Yisu. Tshe turu dœ sukumu ye, œ ndjoro tshapanœ dœ ama ye, yé manda nœ á su lima yombo kpɔɔ kpɔɔ ga panœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lɔkɔ á Farisayinœ á tshe vwa osho ndœ Yisu asœmœ wu atamœ, tshe pa ɓa lœ ye dœ tœ ye adœke: «Œdœ uzunœ asœ kœdœ má adja ayi kœgbara o'o, tshe wu ma sœ nœ adœke yashenœ á tshe goro œne asœmœ, œshe kœdœ ayi kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu za o'o yé œ pa fœ Farisayinœ asœmœ adœke: «Shimu, mœ sœ dœ anga o'o kœpa tœnœ fœ ɓœ.» Shimu gi fœ she adœke: «Pa 'onœ zœ, Ayi kœyisœrœ!» ");
INSERT INTO kxf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yé Yisu kœpa adœke: «Azu bisha sœ lima dœ kuɗa nœ anga uzu bale. Anga bale daka lima egerœ ngendja, yé anga yanganœ daka œnœ ye teasho. ");
INSERT INTO kxf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɓata á endje bibisha lili lima kœgi kuɗanœ nene, ayengɔ kuɗanœ wu oyo endje yé œ katœnœ ye. Lœ ugurutœ endje bisha asœmœ, uzu ɗe dá yindœ ayengɔ ngendjanœ asœmœ kœropa nœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Shimu gi fœ she adœke: «Mœ wu adœke uzu á kuɗa sœ lima dœ egerœnœ lœ kumu ye dá yindœ ye tɔpanœ kpuru.» Yisu kœpa fœ she adœke: «Ɓœ gi adja o'o.» ");
INSERT INTO kxf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Manda nœ, tshe fatœ ye ga ndœ yashenœ yé œ pa fœ Shimu adœke: «Ɓœ wu yashenœ asœ? Mœ li ɓa sœnda nœ zœ yé ɓœ susu ungu fœ mœ adœke mœ djutɔ dœ ada mœ nene, kashe tshe djutɔ ada mœ dœ ngola ye, yé œ turu dœ sukumu ye. ");
INSERT INTO kxf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɓœ nana œ uru tshelœ utu mœ nene, kashe tshe kakatœ kœndjoro tshapa ada mœ tœ kœli mœ á mœ li gamœ asœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɓœ djadja tshapa kumu mœ dœ kada nene, kashe tshe su yombo kpɔɔ ga pa ada mœ. ");
INSERT INTO kxf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ ɓœ adœke: Ndjaba djerœndœ ekperœ nœ ye para mbœrœ egerœ kœyindœsho á tshe ma. Kashe tsheneke á endje djerœndœ ekperœ nœ ye teasho, tshe ma ndje kœyindœsho teasho.» ");
INSERT INTO kxf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yé Yisu kœpa fœ yashenœ adœke: «Mœ djerœndœ ekperœ nœ zœ para ye.» ");
INSERT INTO kxf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Azu á endje sœ ɨndɨrɨ ndaba kœzɨrœ bale dœ she, te lima tœ kœyutœ endje lœ tœ endje dœ tœ endje adœke: «Uzunœ asœ kœdœ ma œnœ ye ɗe yeka á li ndœ kœdjerœndœ ekperœ nœ azu a?» ");
INSERT INTO kxf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kashe Yisu kœpa fœ yashenœ adœke: «Kœyindœrœ nœ zœ she ɓœ ye. Gu dœ kœsœ gee.» ");
INSERT INTO kxf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Manda nœ, Yisu na lima djelœ ongbo œdœ dje lakpɨ mbœrœ kœyisœ Ɔtshɔ O'o tœ upu nœ Ogo gbozu nœ Ndjaba. Ayambarœ nœ ye ndjokpa dœ bisha na lima awa bale dœ she, ");
INSERT INTO kxf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","œdœ ndje ayashe á tshe gɔrɔ ekpe ɨshirɨ pa endje, dœ anga endje á tshe she endje lœ koɓa: Mareya á endje e she uzu Magadala á Yisu gɔrɔ ekpe ɨshirɨ mindu dœ bisha (7) pa ye, ");
INSERT INTO kxf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","dœ Jane, awo Suza á tshe dœ egerœ uzu tshelœ buro nœ Erode, dœ Suzana œdœ pe anga endje ndjoro á endje sœ lima kœto œrœ nœ endje fœ she dœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Azu ndjoro to lima djelœ ongbo dœ ongbo œ na kœngbɔtœ endje dœ Yisu. Yé tshe pa dœ ndœma toro adœke: ");
INSERT INTO kxf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Anga uzu na lima ndœ kœlu ngwarœ ga lœ kɨndɨ nœ ye. Lɔkɔ á tshe sœ lima kœlu ngwarœnœ rotœnœ, anga indjinœ yo ga ɨndɨrɨ ama awa, azu na panœ yé ayanu de ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Anga indjinœ yo ga lœ oporo badja. Œ ko ye, kashe œ ɔrɔ lima mbœrœ eshenœ gbɔgbɔ lima ungu lœ ɔshɔ nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Anganœ yo ga lœ ishi. Œ gerœ lima dœ tœnœ awa bale yé œ vwele ɔtshɔ ngwarœnœ, awa adœke œ gerœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kashe anganœ yo ga lœ ɔtshɔ ɔshɔ. Œ gerœ yé œ le kpo'oro kpo'oro. Kumunœ bale dœ bale sœ lima dœ indjinœ kama bale (100) tœnœ.» Yé Yisu kpa pa adœke: «Uzu á tshe kœsœ dœ utu nœ kœdji o'o, tshe dji!» ");
INSERT INTO kxf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ayambarœ nœ ye yu she lima tœ ádá ndœma toronœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tshe gi fœ endje adœke: «Mbœrœ 'e, 'e wusœ ádá o'o nœ Ogo gbozu nœ Ndjaba á zatœ endje yiwa tœnœ ye; kashe mbœrœ anga endje, endje dji kolœnœ ɓata ndœma toro. Ataa, “endje li kœtondœ œrœ, kashe endje wu nene; endje li kœdji o'o, kashe endje dji tshelœ katanœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yisu mɨndœ nœ fœ endje adœke: «'E dji ádá ndœma toronœ asœmœ: Ngwarœnœ asœmœ, kœdœ o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Anga azu lœ ɓata ama awa á indji ngwarœ te ga tœnœ. Endje kœdji O'o ama Ndjaba, Djaboro na œ kakara tœ lɔsu endje kparawa adœke endje sœsœ dœ kœyindœrœ nene yé á Ndjaba kœsheshe ndje endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Anga endje sœ ɓata ɔshɔ badja. Endje dji o'o dœ ɔtshɔnœ yé œ yindœ nœ dœ yanga, kashe eshenœ lili ɔshɔ nene. Endje yindœ nœ kolœ kwatake œndœ nœ œ dɨ nene, yé lɔkɔ á endje kœli ga lœ ɔgbɔ o'o, endje ka ngbɨrɨ lœ kœyindœrœ nœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Indji ngwarœ neke á yo ga ugurutœ ɔyɔ ishi sœ kœma endjeneke á endje sœ kœdji o'o tœ ɔtshɔnœ, kashe gbetshelœ, ogo kœgbɔ œrœ ndjoro œdœ pe yanga á sœ kœfara azu lœ soro ndɨ tshelœ o'o ama Ndjaba kɔ tœ endje ye, awa adœke leyɔnœ gbɔ, gugu nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Anga endje sœ ɓata indji ngwarœ á yo ga lœ ɔtshɔ ɔshɔ. Endje sœ kœdji o'o, œ sœ kœgbɔndœ nœ ga lɔsu endje dœ ɔtshɔnœ. Endje shi gbɨ lœ nœ yé œ sœ kœzu ɔtshɔ leyɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yisu pa fœ endje adœke: «Uzu tata owo ga tœ miinda mbœrœ kœza lɔsú tshu ga pa nœ too mbœrœ kœza ɓa tshakudu kelekpa nene. Kashe endje za gbara ɓa pa anga œrœ ɓa lafo mbœrœ adœke azu kɔ á endje li ga sœnda, kœmesho ngbɨ tœ ɨshirɨnœ. ");
INSERT INTO kxf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gbambanœ nene, œrœ kɔ á zatœ endje yiwa tœnœ, œ matœ endje ga shu yé ugurutœ œrœ kɔ á sœ kœmbœrœtœ endje lœ ubunœ, endje wusœ nœ yé œ ma ga shu ngbɨ. ");
INSERT INTO kxf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'E sœ dœ gbɔdjela tœ mara á 'e sœ kœdji dœ o'o. Gbambanœ nene, uzu á tshe sœ dœ œrœ ndjoro, endje to anganœ ga panœ fœ she. Kashe tsheneke á tshe gugu dœ œrœ nene, endje gbɔtœ œneke teasho á tshe sœ kœza gbetshelœ nœ ye ga panœ asœmœ tœ ye yé.» ");
INSERT INTO kxf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ayi Yisu dœ aayanœ na lima manda ye, kashe awa adœke endje wuta ɓa zœ gugu lima nene mangba ukpu azu. ");
INSERT INTO kxf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Endje pandœ nœ fœ she adœke: «Ayi zœ dœ pe aaya zœ ka ɓa shu; endje gbe kœwu ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kashe Yisu gi fœ azu kɔkɔ adœke: «Ayi mœ dœ pe aaya mœ kœdœ endjeneke á endje sœ kœdji o'o ama Ndjaba, yé á sœ kœza tœnœ ga tœ akwa.» ");
INSERT INTO kxf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anga ɔlɔ bale, Yisu ɔ ga lœ agba dœ ayambarœ nœ ye. Tshe pa fœ endje adœke: «A zu ga atshi egerœ ungu adanga.» Yé endje tetœ kœzu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lɔkɔ á endje sœ lima kœzu ungunœ, Yisu lo ye. Trale, ndavuru yugu za gu tœnœ kpɨkpɨkpɨ ga pa ungu. Ungu tu lima ga lœ agba œ ɔ dœ tœnœ tshé tshé tshé, yé agbanœ yindœ kœnduru dœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ayambarœ gitœ endje ndoo dœ Yisu œ jo she lœ olonœ, yé á pa fœ she adœke: «Gbozu, Gbozu, a tshu ke a!» Yisu jo lœ olo œ ra yugu œdœ pe loko á sœ kœyakpa ungunœ asœmœ, yé yugu ka, osho yi tá. ");
INSERT INTO kxf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yisu yu ayambarœ nœ ye adœke: «Kœyindœrœ nœ 'e sœ kpœta a?» Kashe awa li lima tœ endje kpa kpa kpa, uvuru endje i gara yé endje tetœ kœyutœ endje lœ ugurutœ endje adœke: «Uzunœ asœke kœdœ ɗe? Tshe sœ kœpa o'o fœ yugu dœ ungu, yé œ sœ kœmbœrœtœ endje lindœ nœ!» ");
INSERT INTO kxf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Endje zu ga atshi œ wuta ga lœ ogo nœ Ageresaye á za tshatshu ye tɔtœnœ dœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lɔkɔ á Yisu jerœ lœ agbanœ ga tœ ɔshɔ, anga uzu tshelœ ongbonœ bale to ɓa zœ, œ na para tshatshu ye. Uzunœ asœmœ sœ lima dœ ekpe ɨshirɨ pa ye. Tshe veverœ lœba œ lolo lima ɓa sœnda nene œndœnœ dɨ ye. Kashe tshe lo lima kolœ ɓa pa udu. ");
INSERT INTO kxf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lɔkɔ á tshe wu Yisu, tshe ve rawa œ te ga tœ ada ye, yé œ kɨ dœ ɔgbɔ fœ she adœke: «Yisu, Gbolo nœ Ndjaba á tshe ropa œrœ kɔ, ɓœ yindœ kœmbœrœ œrœ gaɗe tœ mœ a? Mœ kɨ fœ ɓœ, gágága kumu mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gbambanœ nene, Yisu pa lima fœ ekpe ɨshirɨ adœke tshe gitœ ye pa ye. Ekpe ɨshirɨnœ sœ lima kœndanga she kpœpanœ kpœpanœ, endje sœ lima kœi kane ye dœ ada ye dœ djingiri, kashe tshe sœ lima kœsɔ tshelœ nœ, yé ekpe ɨshirɨnœ sœ lima kœza she natœnœ ga lœ kpagagasho. ");
INSERT INTO kxf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yisu yu she adœke: «Ɨ'ɨrɨ zœ kœdœ ɗe?» Tshe gi fœ she adœke: «Ɨ'ɨrɨ mœ kœdœ ndjoro.» Gbambanœ nene, aekpe ɨshirɨ ndjoro dá sœ lima pa ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yé aekpe ɨshirɨnœ asœmœ sœ lima kœdɨtshelœma endje fœ Yisu adœke tshe koko œne va ga lœ kudu owo nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dá asœmœ, egerœ ukpulu akɔso sœ lima kœzɨ œrœ ɓa pa kaga. Aekpe ɨshirɨ asœmœ dɨ lima tshelœma endje adœke Yisu za awa fœ œne dœ́ œne na œ li ga lœ akɔso. Dœ tœnœ ataa, Yisu za awa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aekpe ɨshirɨnœ wuta lœ uzu asœmœ, œ kpa yé œ li gɔrrr ga lœ akɔso. Akɔso sœmœ ndjoro to ɓa pa kaga 'uru 'uru 'uru dœ ɔrɔ tra tœnœ œrrr ga la egerœ ungu adanga, yé œ nduru kɔkɔ ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lɔkɔ á aayi kœgbɔndœ akɔsonœ wu œrœ á mbœrœtœ endje ataa, endje kpagu kœmɨndœ nœ fœ azu ɓa lœ ongbo, œdœ ndje fœ anga endje á endje sœ lœ kɨndɨ. ");
INSERT INTO kxf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Azu wuta lima mbœrœ kœwu œrœ á mbœrœtœ endje asœmœ. Endje na ndoo dœ Yisu yé œ gbɔ lima uzunœ á aekpe ɨshirɨ gitœ endje pa ye asœmœ, tshe verœ lœba ga tœ ye, yé œ sœ dœ ɔkɔ ye dœ ɔtshɔnœ ɓa tœ ada Yisu. Awa li lima tœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Endjeneke á endje wu lima œrœ á mbœrœtœ endje kɔ asœmœ, endje mɨndœ mara á uzunœ á ekpe ɨshirɨ sœ lima pa ye, she dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yé azu kɔ lœ ogo Geresaye pa fœ Yisu adœke tshe gitœ ye lœ ogo nœ œne ye. Gbambanœ nene, endje sœ lima dœ awa waa ye. Yé Yisu ɔ ga lœ agba œ gu da ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Uzu á aekpe ɨshirɨ wuta lœ ye asœmœ, yu Yisu adœke œne na dœ she awa bale. Kashe tshe vwaratœ ye, yé œ pa fœ she adœke: ");
INSERT INTO kxf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Gu ga sœnda nœ zœ yé œ mɨndœ œneke kɔ á Ndjaba mbœrœ fœ ɓœ.» Tshe gu yé œ tetœ kœmɨndœ œrœ á Yisu mbœrœ fœ she djelœ ongbo kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lɔkɔ á Yisu kwatœ ye lima ga tœ makaga egerœ ungu adanganœ, azu ndjoro na para tshatshu ye mbœrœ endje para kɔkɔ sœ lima kœkate she. ");
INSERT INTO kxf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Anga uzu á ɨ'ɨrɨ ye kœdœ Jaeruse, œshe kœdœ gbozu tshapa Sinagoga. Tshe na lima œ gote ga tshu Yisu, yé œ kɨ fœ she adœke tshe na ɓa ndœ œne. ");
INSERT INTO kxf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gbambanœ nene, tshe sœ lima dœ yawuru nœ ye tshebabale á tshe sœ lima dœ ungu ndjokpa dœ bisha. Yawurunœ sœ lima ndoo dœ kuzu. Lɔkɔ á Yisu sœ lima kœna ga zœ, azu ndjoro sœ lima kœpoporo she. ");
INSERT INTO kxf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Anga yashe bale á tshe mbœrœ ungu ndjokpa dœ bisha dœ koɓa indji, sœ lima kpœtœmœ. Tshe ndɨ ngendja nœ ye kɔ á tshe sœ dœ tœnœ dje ndœ amonganga, kashe uzu bale á tshe li lima kœshe she gugu nene. ");
INSERT INTO kxf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tshe gitœ ye ndoo ɓa ngba Yisu yé œ goro ama lœba ye. Pe kpœtœ œsœnœ, indji katœ kœi tœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yisu yu adœke: «Uzu ɗe dá turutœ mœ a?» Azu kɔ vusœ nœ, yé Petro pa adœke: «Gbozu, azu ndjoro kpa dji ɓœ, yé œ sœ kœturutœ zœ tœ osho kɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kashe Yisu pa adœke: «Anga uzu turutœ mœ, mbœrœ mœ wu adœke anga gbɔgbɔ wuta lœ ɔkɔ mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yashe koɓanœ wusœ nœ adœke Yisu wusœ œne ye. Tshe na dœ kœgugu tœnœ œ te ga tshu Yisu, yé œ pandœ ádá á tshe turutœ ye dœ mara á tshe she ngbewo lœ koɓa nœ ye, ɓa utshu azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yisu pa fœ she adœke: «Yawuru nœ mœ, kœyindœrœ nœ zœ she ɓœ ye. Gu dœ kœsœ gee.» ");
INSERT INTO kxf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisu sœpe damba kœpa o'o lœ ama ye ataa, anga ayi avwa to ɓa sœnda nœ gbozu tshapa Sinagoga yé œ pa fœ she adœke: «Yawuru nœ zœ tshu ye. Ndandanga ayi kœyisœrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kashe Yisu dji o'onœ asœmœ yé œ pa fœ Jaeruse adœke: «Awa zaza ɓœ nene, sœ kolœ dœ kœyindœrœ, yé tshe she ye.» ");
INSERT INTO kxf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lɔkɔ á Yisu wuta ɓa sœnda ɓa zœ, tshe zaza lima awa kœli ga sœnda dœ she fœ uzu bale nene, kashe kolœ Petro, Yowane, Jake œdœ pe aba gbolo dœ ayi gbolonœ asœmœ dá tshe za awa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Azu kɔ sœ lima kœkɨ tœnœ yé œ sœ kœdɨtshelœma endje. Yisu pa adœke: «'E kɨkɨ nene. Tshe tshutshu nene, kashe tshe sœ tœ olo.» ");
INSERT INTO kxf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Endje sœ lima kœmɔ she mbœrœ endje wu lima sœ nœ adœke tshe tshu ye. ");
INSERT INTO kxf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Andaa, Yisu tepa kane ye, yé œ pa dœ ɔgbɔ adœke: «Gbolo nœ mœ, áalafo!» ");
INSERT INTO kxf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɨshirɨ ye kwa ga lœ nœ yé trale tshe kœalafo. Yisu pa fœ endje adœke endje to kœzɨrœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Agbozu nœ ye sœ lima kœkɨtœ œsœnœ, kashe Yisu pa fœ endje adœke endje papandœ œrœ á mbœrœtœ endje asœmœ fœ uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisu ngbɔɓa andjokpa dœ bishanœ á to gbɔgbɔ œdœ kœlɨsœtœ fœ endje mbœrœ kœgɔrɔ dœ ekpe ɨshirɨ œdœ pe kœshe koɓa. ");
INSERT INTO kxf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tshe vwa endje kœyisœ upu nœ akwa tshagbozu nœ Ndjaba œdœ pe kœshe aayi koɓa. ");
INSERT INTO kxf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yé tshe pa fœ endje adœke: «'E zaza œrœ bale potœ 'e lœ ananœ nene: Œdœ tshɔngbɔlɔ, œdœ ngbade, œdœ kœzɨrœ, œdœ ngendja; uzu bale nana dœ lœba bisha nene. ");
INSERT INTO kxf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Osho kɔ á endje kœza osho kœsœ fœ 'e tœnœ, 'e lo kolœ lœ andanœ asœmœ œrrr ga tœ olo á 'e katœ tshakpœtœmœ tɨ. ");
INSERT INTO kxf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Osho kɔ á azu kœvwaratœ endje tœ 'e tœnœ, 'e katœnœ tɨ, yé œ gɔrɔ trusha tshada 'e ga atɨ kpœtœmœ ndœ kœma fœ endje adœke endje mbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ayambarœ i tɔ tœ awa, œ na kœyisœ Ɔtshɔ O'o dje lakpɨ bale dœ bale, œ sœ ndje kœshe aayi koɓa. ");
INSERT INTO kxf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erode, gbozugo tshapa ogo Galilayi, dji lima ndœ œneke kɔ á mbœrœtœ endje asœmœ. Kashe tshe wuwu lima sœ œrœ á tshe mbœrœ nene. Gbambanœ nene, anga azu sœ lima kœpa adœke: «Yowane ayi kœza batisimu dá she lœ akuzu asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anga endje sœ lima kœpa adœke: «Eliya dá wuta asœmœ.» Anga endje kpa sœ lima kœpa ndje adœke: «Anga ayi kœgbara o'o bale ugurutœ aayi kœgbara o'o liya utshunœ, dá she lœ akuzu asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kashe Erode pa ngbɨ adœke: «Mœ wa lima ɨgɨ Yowane ayi kœza batisimu ye. Tsheneketa dá mœ kpa sœ kœdjindœ ye kœpa mara o'onœ asœmœ kɔ a?» Yé tshe tetœ kœpara awa adœke œne wu Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ayi avwa gu ga ndœ Yisu œ pandœ œneke kɔ á endje mbœrœ fœ she. Yisu to endje, yé œ gitœ ye dœ endje ga ɨndɨrɨ anga ongbo á ɨ'ɨrɨnœ kœdœ Betesayida. ");
INSERT INTO kxf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kashe azu ndjoro djindœ o'onœ, yé œ na manda ye. Yisu za osho kœsœ fœ endje, yé œ tetœ kœpa lima o'o fœ endje tœ upu nœ Ogo gbozu nœ Ndjaba. Tshe she ndje lima aayi koɓa á endje yindœ kœshe tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dœ lɔkɔ á ɔlɔ tetœ kœdɨ tœnœ, ayambarœ ndjokpa dœ bisha gitœ endje ndoo dœ she, œ pa fœ she adœke: «Za awa fœ ukpulu azunœ asœke, endje gu œ lo ɓa lakpɨ œdœ ɓa lœ kɨndɨ nœ endje yeka á kœgbɔ osho kœlo tœnœ dœ pe kœzɨrœ. Gbambanœ nene, a sœ ɓa ke ɓa lœ kpagagasho.» ");
INSERT INTO kxf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kashe Yisu pa fœ endje adœke: «'E to kœzɨrœ fœ endje dœ tœ 'e!» Yé ayambarœ gi fœ she adœke: «A sœ kolœ dœ mapa mindu œdœ ageatshalangu bisha gbambanœ. Ɓœ sœ ete kœyindœ nœ adœke 'a na dœ́ œ yɔ kœzɨrœ fœ azunœ asœ kɔ a?» ");
INSERT INTO kxf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ayambarœnœ papa ataa gbambanœ nene, ayakoshe sœ lima ga pa œrœ nœ́ kutu mindu (5.000). Yisu pa fœ ayambarœ nœ ye adœke: «'E pa fœ endje adœke endje sœ ga atɨ, azu zazu bisha dœ ndjokpa (50) lœ ukpulu azu bale dœ bale.» ");
INSERT INTO kxf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Endje mbœrœtœ endje lindœ nœ, yé œ guma adœke azunœ kɔ sœ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yisu ko mapa mindu œdœ pe ageatshalangu bisha asœmœ, œ mesho ga lafo, yé œ tetœ kœza avwala pa nœ fœ Ndjaba. Tshe kurutshelœnœ yé œ ko fœ ayambarœ adœke endje kurutshelœnœ tœ ukpulu azunœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Azu para kɔkɔ zɨ lima, yé uvu ndje sú. Ayambarœnœ ngbɔɓa lima udu kœzɨrœnœ á sœpe manda endje, ga lœ kingi ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dœ anga ɔlɔ bale, Yisu sœ lima kœza avwala kutɨ ye, yé ayambarœ nœ ye na œ gbɔ she. Tshe yu endje lima adœke: «Azu sœ kœpa má adœke œmœ kœdœ ɗe?» ");
INSERT INTO kxf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Endje gi adœke: «Azu sœ kœpa adœke œɓœ kœdœ Yowane ayi kœza batisimu; anga endje adœke ɓœ kœdœ Eliya; anga endje kpa sœ ndje kœpa adœke, œɓœ kœdœ anga ayi kœgbara o'o bale ugurutœ aayi kœgbara o'o liya á she lœ akuzu asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yisu yu endje adœke: «'E gbe má œnœ 'e adœke œmœ kœdœ ɗe?» Petro gi fœ she adœke: «Œɓœ kœdœ Masiya á Ndjaba vwa she.» ");
INSERT INTO kxf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yisu va tshelœ utu endje adœke endje papandœ nœ fœ uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tshe kpa pa adœke: «Œ li adœke Gbolo nœ uzu wu oyo waa yekane. Agbozu Ikrizia, agbozu tshapa anganga Ndjaba œdœ ndje aayi kœyisœ awa akwa œ vwaratœ endje tœ ye. Endje wo she, yé tshe she lœ akuzu manda olo votɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Manda nœ, tshe pa fœ azu kɔ adœke: «Œdœ uzu kœyindœ kœna manda mœ, œ li adœke tshe vwaratœ undu ye dœ tœ ye, œ za kurushi nœ ye ɔlɔ dœ ɔlɔ yeka á kœna manda mœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gbambanœ nene, uzu á tshe sœ dœ ogo kœsœ dœ soro, tshe tshu; kashe tsheneke á tshe tshu mbœrœ mœ, œ sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yé œ kœsœ adœke uzu gbɔ œrœ kɔ á sœ pa ɔshɔ kashe á tshe kœgbɔgbɔ soro á ka nene, œrœ gaɗe dá tshe gbɔ manda kœgbɔ œrœ tshapashɔnœ a? ");
INSERT INTO kxf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gbambanœ nene, œdœ uzu kœmbœrœ tshula mœ œdœ pe ndje o'o nœ mœ, œmœ Gbolo nœ uzu, mœ mbœrœ ndje tshula ye lɔkɔ á mœ kwa bala tœ mœ lœ mokɔ nœ mœ, dœ œnœ Aba œdœ œnœ ayerœ aandjelu. ");
INSERT INTO kxf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Adja mœ sœ kœpa fœ 'e adœke, lœ ugurutœ azu á endje sœ kpœke asœ, anga endje œ tshu utshu kœwu Ogo gbozu nœ Ndjaba nene.» ");
INSERT INTO kxf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Olo mindu dœ votɔ manda kœpa o'onœ asœmœ, Yisu za Petro, Yowane œdœ pe Jake potœ ye, yé œ ɔ dœ endje ga pa kaga mbœrœ kœza avwala. ");
INSERT INTO kxf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lɔkɔ á tshe sœ lima kœza avwala, tshatshu ye yapatœ ye, yé lœba ye kpa wuta dœ œmbinœ rurrr. ");
INSERT INTO kxf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Trale, azu bisha sœ lima kœpa tshama endje dœ she. Azunœ asœmœ kœdœ Amoyize dœ Eliya. ");
INSERT INTO kxf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Endje wuta lima dœ mokɔ nœ Ndjaba, yé œ sœ lima kœpa o'o tœ mara á akwa nœ Yisu œ ka lœ awa nœ kuzu ye ɓa lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro œdœ anganœ á endje na tœ awanœ dœ endje lo lima kpakpakpa ye. Kashe lɔkɔ á endje jo lima, endje wu mokɔ nœ Yisu œdœ pe azu bisha á endje ka kpœtœ œsœnœ dœ she. ");
INSERT INTO kxf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dœ lɔndɔ á azunœ asœmœ kuru lima tshelœtœ endje dœ Yisu, Petro pa fœ she adœke: «Gbozu, œ sœ dœ ɔtshɔnœ adœke a sœ kpœke. A mɔ gbanda votɔ: Anganœ bale mbœrœ ɓœ, anganœ bale mbœrœ Moyize, yé anganœ bale mbœrœ Eliya.» Tshe wuwu lima sœ o'o á tshe sœ lima kœpa tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lɔkɔ á tshe sœ lima kœpa o'o atake, ondoro jerœ kpɨlɨ ga pa endje. Kœwu adœke ondoronœ jerœ ga pa endje ataa, awa za ayambarœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tshama kœpa o'o lœ ondoronœ adœke: «Tsheneke kœdœ Gbolo nœ mœ, œshe dá mœ ke she. 'E dji she.» ");
INSERT INTO kxf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Manda tshamanœ kœpa o'o, Yisu sœ lima pe kolœ kutɨ ye. Ayambarœ sœ lima kokoko, yé endje papandœ œneke á endje wu lima fœ uzu bale nene dœ lɔkɔnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Olo manda nœ, endje to lima ɓa pa kaga œ sœ kœgu tœnœ, azu ndjoro na para tshatshu Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yé anga uzu bale ɓa ugurutœ ukpulu azunœ tetœ kœta rawa adœke: «Ayi kœyisœrœ, mœ kɨ fœ ɓœ adœke ɓœ tondœ gbolo yakoshe nœ mœ kane, mbœrœ œshe kœdœ gbolo yakoshe nœ mœ tshebabale dœ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɨshirɨ sœ kœza she trale dœ kœta rawa kpala kpala. Ɨshirɨnœ sœ kœyaka she, tshe dɔtœ ye ndeɔr ndeɔr ndeɔr, yé furutsha ama ye oma putu putu. Ɨshirɨnœ mbœrœ tœ ye le'ere le'ere yeka á gitœ ye pa ye, kashe katsha nene. ");
INSERT INTO kxf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mœ kɨ fœ ayambarœ nœ zœ adœke endje gɔrɔ she, kashe endje lili nene.» ");
INSERT INTO kxf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yisu pa fœ endje adœke: «E'e dœ aekpe azu, 'e sœsœ dœ kœyindœrœ nene! Mœ kpa sœpe dœ 'e awa bale manda olo kotoo yeka á kœru lɔsu mœ tœ ɔtshɔ 'e? Manda nœ, tshe pa fœ yakoshenœ adœke: Na dœ gbolo nœ zœ gamœ!» ");
INSERT INTO kxf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lɔndɔ á gbolonœ na ndoo dœ Yisu, ekpe ɨshirɨnœ za she vesho ga tœ ɔshɔ yé, tshe dɔ tœ ye ndeɔr ndeɔr. Kashe Yisu nga dœ ɨshirɨnœ adœke tshe wuta, yé á tshe wuta lœ gbolonœ yeka á tshe gi she fœ abanœ. ");
INSERT INTO kxf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yé azu kɔ katœ ama endje tɨ ɔsɔ tœ kœwu egerœ gbɔgbɔ nœ Ndjaba. Ɓata á azu kɔ sœ lima kœkɨtœ œsœ́ œneke kɔ á Yisu mbœrœ, tshe pa fœ ayambarœ nœ ye adœke: ");
INSERT INTO kxf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«'E dji œneke á mœ yindœ kœpa tœnœ fœ 'e asœke dœ ɔtshɔnœ kane: Endje ka Gbolo nœ uzu ga tshakane azu.» ");
INSERT INTO kxf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kashe ayambarœ nœ ye djidji tshelœ kata ndœma toronœ asœmœ nene. Ádánœ mamatœ endje ngbɨ nene mbœrœ á endje kœdjidji tshelœ katanœ nene. Yé endje kpa awa kœyu Yisu tœ ádánœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ayambarœ te lima tœ kœgbugburu tshelœ o'o mbœrœ kœwusœ tsheneke á tshe dœ egerœ uzu lœ ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yisu wu lima sœ gbetshelœ nœ endje kɔ, œ za anga aya gbolo ga ɨndɨrɨ tœ ye, ");
INSERT INTO kxf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yé á pa fœ endje adœke: «Uzu kɔ á tshe za osho kœsœ fœ gbolo asœke dœ ɨ'ɨrɨ mœ, dá tshe za osho kœsœ fœ mœ. Yé uzu á tshe za osho kœsœ fœ mœ, za ndje osho kœsœ fœ tsheneke á tshe vwa mœ. Gbambanœ nene, uzu á tshe sœ teasho lœ ugurutœ 'e kɔ, œshe dá dœ egerœ uzu.» ");
INSERT INTO kxf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowane pa fœ Yisu adœke: «Gbozu, 'a wu anga uzu bale, tshe sœ kœgɔrɔ ekpe ɨshirɨ dœ ɨ'ɨrɨ zœ, yé 'a para awa kœkɔ she mbœrœ tshe sœsœ awa bale dœ azœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kashe Yisu gi fœ she adœke: «'E kɔkɔ she nene, mbœrœ tsheneke á tshe kœyiyiangba 'e nene, œshe kœdœ uzu nœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lɔkɔ á olo kœ'ɔ Yisu ga lafo ndo lima, tshe wu dœ ɔtshɔnœ adœke œne ro ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tshe vwa aayi avwa utshu ye. Endje tetœ awa, œ na œ li ga lakpɨ Samariya mbœrœ kœguma osho kœsœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kashe azu tshalakpɨnœ zaza osho kœsœ fœ she nene, mbœrœ tshe sœ kœna ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kœwu ataa, ayambarœ nœ ye, Jake œdœ Yowane pa adœke: «Gbozu, ɓœ yindœ nœ adœke 'a pa fœ yavuru ɓa lafo, œ sɔ œ ko azunœ asœmœ dœ́ endje ju trulu ye a?» ");
INSERT INTO kxf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kashe Yisu fatœ ye ga ndœ endje, yé œ gbagbara endje. ");
INSERT INTO kxf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yé endje na ga lœ anga angbɨ tshalakpɨ. ");
INSERT INTO kxf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lɔkɔ á endje sœ lima kœna tœ ala awa, anga uzu pa fœ Yisu adœke: «Mœ na manda zœ tœ osho kɔ á ɓœ na tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yisu gi fœ she adœke: «Angbangewo sœ dœ ogoro endje yé ayanu sœ ndje dœ koma endje. Kashe Gbolo nœ uzu gugu dœ osho kœlo tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tshe pa fœ anga uzunœ adœke: «Na manda mœ.» Uzunœ asœmœ gi fœ she adœke: «Za awa fœ mœ dœ́ mœ na œ shi aba mœ utshunœ yekane.» ");
INSERT INTO kxf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kashe Yisu gi fœ she adœke: «Katœ akuzu dœ́ endje shi akuzu nœ endje. Tœ ɓœ nœ zœ, na kœmɨndœ upu nœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Anga uzu kpa pa fœ she adœke: «Gbozu, mœ yindœ kœna mangba zœ, kashe za awa fœ mœ dœ́ mœ na œ pu dœ azu tshelœ bɨngɨ nœ mœ utshunœ yekane.» ");
INSERT INTO kxf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yisu gi fœ she adœke: «Uzu á tshe kœza ngapo mbœrœ kœdjo kɨndɨ yé á sœ kœmesho ga ngba ye, tshe lili kœmbœrœ akwa mbœrœ Ogo gbozu nœ Ndjaba nene.» ");
INSERT INTO kxf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Manda nœ, Gbozu ke anga ayambarœ zazu votɔ dœ ndjokpa dœ bisha, yé œ vwa endje bisha bisha utshu ye dje lœ ongbo œdœ pe dje lakpɨ á tshe yindœ kœna lœ nœ dœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tshe pa fœ endje adœke: «Leyɔ doro ndjoro ɓa lœ kɨndɨ, kashe ayi kœkɔ tœnœ ngbangba nene. Mbœrœ tœnœ ataa, 'e kɨ fœ ayengɔ leyɔnœ adœke tshe vwa anga aayi akwa mbœrœ kœkɔ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'E na zœ! Mœ sœ kœvwa 'e ɓata apata ɓa ugurutœ amuru. ");
INSERT INTO kxf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Œdœ ngendja, œdœ ngbade, œdœ œrada, 'e zaza œrœ bale nene. 'E kaka tœ ala awa waa mbœrœ kœgo o'o dœ azu nene. ");
INSERT INTO kxf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Lɔkɔ á 'e kœli ɓa sœnda nœ uzu, 'e pa utshunœ adœke: “Kœsœ gee sœ sœndanœ asœke.” ");
INSERT INTO kxf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Œdœ uzu nœ kœsœ gee kœsœ sœndanœ, kœsœ gee nœ 'e œ sœ pa ye. Á kœsœsœ atamœ nene, kœsœ geenœ œ kwa ga ndœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'E sœ ɓa sœndanœ asœmœ, 'e zɨ œrœ dœ́ œ ndjo œrœ á endje to fœ 'e. Gbambanœ nene, œ li adœke ayi akwa gbɔ œrœ tshangba akwa nœ ye. 'E lolo lœ anda bale dœ bale na tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Œdœ 'e kœwuta ga lœ ongbo yé á endje kœza osho kœsœ fœ 'e tœnœ, 'e zɨ œneke á endje to fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","'E she aayi koɓa á endje sœ kpœtœmœ, yé œ pa fœ endje adœke: “Ogo gbozu nœ Ndjaba wuta œrrr ga ndœ 'e ye.” ");
INSERT INTO kxf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kashe lœ ongbo á 'e kœli ga lœ nœ yé á endje kœzaza osho kœsœ fœ 'e nene, 'e wuta ga tœ ala awa dœ́ œ pa adœke: ");
INSERT INTO kxf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“'A gɔrɔ trusha tshelœ ongbo nœ 'e á tɔpe tshada 'a ga atɨ fœ 'e. Andaa 'e wusœ nœ adœke, Ogo gbozu nœ Ndjaba wuta ga ndœ 'e ye.” ");
INSERT INTO kxf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mœ sœ kœmɨndœ nœ fœ 'e adœke: Dœ lɔkɔ kœwa ngbanga pa azu, ngbanga nœ azu tshelœ ongbonœ asœmœ œ sœ dœ ɔgbɔnœ kœropa œnœ azu Sodomo.» ");
INSERT INTO kxf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Oyo nœ 'e, azu tshalakpɨ Koraze! Oyo nœ 'e, azu tshalakpɨ Betesayida! Gbambanœ nene, œdœ afá á mœ mbœrœ ɓa ndœ 'e kœmbœrœ má tœ endje ɓa lakpɨ Tire œdœ ɓa lakpɨ Sidona, azu tsha ɓa zœ œ verœ má sake yé œ sœ ga lœ vorowo, mbœrœ kœma adœke œne fatshalɔsu œne ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbœrœ tœnœ ataa, dœ olo kœwa ngbanga, endje wa o'o nœ azu Tire œdœ azu Sidona tœ ɔgbɔnœ ɓata œnœ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yé e'e dœ azu Kaparnawumu, 'e gbe adœke 'e 'ɔ œrrr ga lafo zœ a? 'E jerœ bala œrrr ɓa lœ ogo nœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yisu kpa pa fœ ayambarœ nœ ye adœke: «Uzu á tshe dji o'o ama 'e; dá tshe dji ndje o'o ama mœ ye. Yé tsheneke á tshe kœyiyindœ o'o ama 'e nene, dá tshe yiyi ndje ndœ o'o ama mœ nene. Dœ tœnœ ataa tshe yiyi ndje ndœ tsheneke á tshe vwa mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ayambarœ zazu votɔ dœ ndjokpa dœ bisha gu lima dœ yanga, yé œ pa adœke: «Gbozu, aekpe ɨshirɨ mbœrœtœ endje lindœ o'o ama 'a dœ lɔkɔ á 'a pu o'o fœ endje dœ ɨ'ɨrɨ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yisu pa fœ endje adœke: «Mœ wu lima Satana, tshe to ɓa lafo, œ te ga atɨ ɓata kœyerœwa yavuru. ");
INSERT INTO kxf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'E dji mœ kane! Mœ za awa fœ 'e adœke 'e zuru ayakoro œdœ akpalakongo dœ ada 'e, yé gbɔgbɔ 'e ropa œnœ yingba 'e. Ekperœ bale œ mbœrœtœ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ataa atamœ gbaa, 'e sœsœ dœ yanga mbœrœ á aekpe ɨshirɨ mbœrœtœ endje lindœ o'o ama 'e nene, kashe 'e sœ dœ yanga mbœrœ á Ndjaba su ɨ'ɨrɨ 'e ga la buku nœ ye ɓa lafo.» ");
INSERT INTO kxf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pe kpœtœ œsœnœ, Ɔtshɔ Ɨshirɨ za yanga fœ Yisu yé tshe pa adœke: «Aba, œɓœ kœdœ Gbozu nœ tshalafo œdœ tshapashɔ! Mœ donga ɓœ mbœrœ ɓœ ma œneke á ɓœ za yiwa tœnœ tœ azu á endje sœ dœ kœwusœtœ dœ pe azu á endje sœ dœ kœwusœrœ, yé á yisœ nœ fœ a'eara azu. Adjapu Aba, œbœ dá yindœ nœ adœke œ mbœrœtœ ye atamœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aba mœ katœ œrœ kɔ fœ mœ. Uzu œ wusœ ádá Gbolo nene, kashe kolœ Aba dá wusœ nœ; uzu bale œ wusœ ádá Aba nene, kashe kolœ Gbolo dá wusœ nœ œdœ pe endjeneke á Gbolo yindœ kœyisœ ye fœ endje.» ");
INSERT INTO kxf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Manda nœ, Yisu fatœ ye ga ndœ ayambarœ nœ ye œ pa fœ endje dœ kutɨ endje adœke: «Yanga nœ azu á endje sœ kœwu œneke á 'e sœ kœwu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gbambanœ nene, mœ pa ngbɨ fœ 'e adœke aayi kœgbara o'o œdœ agbozugo ndjoro gbe kœwu œneke á 'e sœ kœwu tœnœ, kashe endje wuwu nene. Endje gbe lima kœdji œneke á 'e dji, kashe endje djidji lima nene.» ");
INSERT INTO kxf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anga ayi kœyisœ awa akwa bale áalafo lima mbœrœ kœwu lɔsu Yisu, yé á yu she adœke: «Ayi kœyisœrœ, œrœ gaɗe dá mœ kœmbœrœ yeka á kœgbɔ soro neke á ka nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yisu gi fœ she adœke: «O'o gaɗe dá endje sú ɓa la buku nœ awa akwa a? Ɓœ dɨ ma œnœ zœ kotoo?» ");
INSERT INTO kxf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uzunœ gi fœ she adœke: «Œ li adœke ɓœ yindœ Gbozu Ndjaba nœ zœ dœ lɔsu zœ bale, dœ ɨshirɨ zœ djigi, dœ gbɔgbɔ zœ œdœ pe dœ gbetshelœ nœ zœ kɔ. Œ li ndje adœke ɓœ yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yisu pa fœ she adœke: «Ɓœ gi o'onœ dœ ɔtshɔnœ. Mbœrœ atamœ yeka á kœgbɔ soro neke á ka nene.» ");
INSERT INTO kxf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kashe ayi kœyisœ awa akwanœ yi lima ndœ kœma adœke œne tete dœ o'o nene, œ yu Yisu adœke: «Yé ataa, œɗe dá dœ yanga mœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yisu gi fœ she adœke: «Anga uzu bale to lima ɓa lœ Yerusaleme œ sœ kœro ga lœ Yeriko, yé œ wuta ga tœ ayi angba. Endje verœ lœba tœ ye, œ ko œrœ kɔ tœ ye, yé œ ɓi she ndoo dœ kuzu yeka á katœ ye dœ kœro endje. ");
INSERT INTO kxf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Manda nœ teasho, anga nganga Ndjaba bale sœ lima kœro dœ awanœ asœmœ. Lɔkɔ á tshe wu uzunœ asœmœ, tshe sha pa ye, yé œ ro zara da ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Manda nœ, anga Levi wuta ndje ga tœ oshonœ asœmœ. Lɔkɔ á tshe wu uzunœ asœmœ, tshe sha pa ye, yé œ ro zara da ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kashe anga uzu Samariya bale á tshe sœ lima kœna gene, wuta ga tœ uzunœ asœmœ. Lɔkɔ á tshe wu she, oyo ye ka she. ");
INSERT INTO kxf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tshe gitœ ye ndoo dœ she, œ djutɔ uku tœ ye, yé œ ta kada œdœ vinu ga la nœ. Manda nœ, tshe za she ga pa mbarata nœ ye, œ na dœ she ga tœ anda nœ agene, yé á gbɔndœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Osho kɔrɔ pa nœ, tshe ko langere ngendja bisha fœ ayengɔ kœgbɔndœ anda nœ agenenœ, yé œ pa fœ she adœke: “Gbɔndœ uzunœ asœke. Œdœ ɓœ kœndɨ anga angbɨ ngendja pa ye kœropa nœ, mœ gi fœ ɓœ lɔkɔ á mœ kœgu tɔ kpœke.”» ");
INSERT INTO kxf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yé Yisu kpa yu ayi kœyisœ awa akwanœ adœke: «Ɓa tœ zœ nœ zœ, œɗe lœ ugurutœ azunœ asœmœ votɔ dá matœ ye adœke œshe kœdœ yanga uzu á ayi angba ɓi she a?» ");
INSERT INTO kxf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ayi kœyisœ awa akwanœ gi adœke: «Tsheneke á tshe wu oyo ye, yé á gbɔndœ ye asœmœ.» Ngbewo Yisu kœpa fœ she adœke: «Gu zœ, yé œ mbœrœ ndje atamœ.» ");
INSERT INTO kxf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lɔkɔ á Yisu dœ ayambarœ nœ ye sœ lima tœ awa, tshe wuta ga lœ anga tshalakpɨ bale, yé anga yashe bale lakpɨnœ á ɨ'ɨrɨ ye kœdœ Marta, za osho kœsœ fœ she ɓa sœnda nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tshe sœ lima dœ anga yingɔnœ á ɨ'ɨrɨ ye kœdœ Mareya. Tshe sœ lima ga atɨ ɓa tœ ada Yisu, yé á sœ kœdji o'o á tshe sœ lima kœpa tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta sœ lima dœ akwa ngbangbangba á ropa ye. Tshe na ndoo dœ Yisu œ pa fœ she adœke: «Gbozu, mara á yingɔ mœ ka kolœ tœ mœ tɨ kutɨ mœ kœmbœrœ akwa kɔ asœke, sœsœ kœmbœrœ œrœ bale ɓa ndœ zœ nene a? Pa fœ she tshe na, œ tɨ kane mœ ga lafo.» ");
INSERT INTO kxf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gbozu Yisu gi fœ she adœke: «Marta, Marta, mœ wu adœke lɔsu zœ sœ ga lafo yé ɓœ sœ kœdɔtœ zœ mbœrœ œrœ ndjoro. ");
INSERT INTO kxf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kashe wusœ nœ adœke kolœ œrœ tshebabale dá sœ dœ ádá kœrosœ nœ. Œtœnœ dá Mareya ke œnœ ye asœmœ, uzu bale œ kakara tœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dœ anga ɔlɔ bale, Yisu sœ lima kœza avwala fœ Ndjaba ɓa tœ anga osho bale. Lɔkɔ á tshe za avwalanœ á ka, anga yambarœ nœ ye bale pa fœ she adœke: «Gbozu, yisœ mara kœza avwala fœ 'a ɓata á Yowane yi lima sœ nœ fœ ayambarœ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yisu pa fœ endje adœke: «Lɔkɔ á 'e kœsœ kœza avwala, 'e pa adœke: “Aba, œ li adœke azu kɔ lɨsœ œyerœ ɨ'ɨrɨ zœ kaka adœke Ogo gbozu nœ zœ jerœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","To rœgo á li adœke 'a zɨ ɔlɔ dœ ɔlɔ fœ 'a. ");
INSERT INTO kxf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Djerœndœ ekperœ nœ 'a, gbambanœ nene a'a ndje, 'a sœ kœdjerœndœ ekperœ nœ anga azu á endje sœ kœmbœrœ fœ 'a. Yé gbɔndœ 'a adœke 'a lili ga lœ ekperœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yisu kpa pa fœ endje adœke: «Œ kœdœ adœke anga uzu bale lœ ugurutœ 'e kœsœ dœ yanganœ yé á na ga ndœ ye dœ ɔgbɔ butshɔ mbœrœ kœpa fœ she adœke: “Yanga mœ, daka mapa votɔ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gbambanœ nene, anga yanga mœ bale á tshe sœ kœna gene yi kumu ye ga ndœ mœ ngɔngɔ asœke, yé mœ gugu dœ œrœ kœto fœ she bale nene.” ");
INSERT INTO kxf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yé á kœsœ adœke yanganœ á tshe lo ɓa sœnda gi fœ she adœke: “Katœ mœ, ndandanga mœ nene mbœrœ mœ tshu manda nœ mœ ga tœnœ ye. A'a dœ agbolo nœ mœ á sœ tœ olo; mœ áalafo ndœ kœza mapa fœ ɓœ nene.” ");
INSERT INTO kxf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mœ sœ kœpa fœ 'e adœke: Ataa œdœ tshe kœáalafo ndœ kœko mapa fœ she mbœrœ á tshe dœ́ yanganœ nene, tshe áalafo yé œ to œneke kɔ á yanganœ gbe dœ tœnœ fœ she mbœrœ á yanganœ shi ngbɨrɨ dœ kœ'e she kpœ pa nœ kpœ pa nœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Mbœrœ tœnœ ataa, mœ sœ kœpa fœ 'e adœke: 'e kœyɔndœ œrœ, endje to fœ 'e. 'E kœpara œrœ, 'e gbɔ ye. 'E kœnge manda, endje kɔrɔ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gbambanœ nene, uzu kɔ á tshe yɔndœ œrœ, endje to fœ she; tsheneke á tshe para œrœ, tshe gbɔ; yé tsheneke á tshe nge manda, endje kɔrɔ fœ she ye. ");
INSERT INTO kxf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aba gbolo neketa ugurutœ 'e dá yindœ nœ adœke œne za yakoro fœ gbolo nœ œne tœ œsœ́ ageatshalangu á tshe yɔndœ nœ a? ");
INSERT INTO kxf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Too œdœ tshe kœyɔndœ oporo ngato, tshe za kpalakongo fœ she a? ");
INSERT INTO kxf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ataa, œdœ e'e á 'e dœ́ aekpe azu, 'e kœwusœ kœto ɔtshɔrœ fœ agbolo nœ 'e, Aba azœ á tshe sœ ɓa lafo œ vwaratœ ye tœ kœto Ɔtshɔ Ɨshirɨ fœ endjeneke á endje yɔndœ nœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Anga uzu bale sœ dœ ekpe ɨshirɨ pa ye. Ekpe ɨshirɨnœ asœmœ mbœrœ adœke uzunœ papa o'o nene. Lɔkɔ á Yisu gɔrɔ ekpe ɨshirɨnœ pa ye, ngbewo tshe tetœ kœpa o'o yé azu ndjoro kɨ lima tœ œsœnœ waa. ");
INSERT INTO kxf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kashe anga azu pa lima adœke: «Tshe sœ kœgɔrɔ ekpe ɨshirɨnœ dœ gbɔgbɔ nœ Belezebula á tshe dœ gbozu tshapa aekpe ɨshirɨ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Anga endje yi lima ndœ kœwu lɔsu ye, yé œ pa fœ she adœke tshe mbœrœ anga afá bale á sœ kœma adœke gbɔgbɔ nœ ye to ɓa ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kashe Yisu wu lima sœ gbetshelœ nœ endje, œ pa fœ endje adœke: «Œdœ azu lakpɨ ogo bale kœsœ kœnga koshe ugurutœ endje, tshalakpɨnœ œ ndɨ, yé anda œ yo para kɔkɔ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Œdœ Satana kœsœ kœnga koshe ga tœ ye dœ tœ ye, Ogo gbozu nœ ye œ shi pa ɔshɔ koto o? Gbambanœ nene, 'e sœ kœpa adœke mœ sœ kœgɔrɔ ekpe ɨshirɨ dœ gbɔgbɔ nœ Belezebula. ");
INSERT INTO kxf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yé ataa œdœ mœ kœsœ kœgɔrɔ ekpe ɨshirɨ dœ gbɔgbɔ nœ Belezebula, azu nœ 'e sœ ndje kœgɔrɔ endje dœ gbɔgbɔ nœ ɗe? 'E kœpa ataa, azu nœ 'e œ wa bala ngbanga ga pa 'e dœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kashe œdœ mœ kœsœ kœgɔrɔ ekpe ɨshirɨ pa azu dœ gbɔgbɔ nœ Ndjaba, dá œ sœ kœma adœke Ogo gbozu nœ Ndjaba wuta ga ndœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Lɔkɔ á uzu gbɔgbɔ kœza œrœ koshe á sœ kœgbɔndœ anda nœ ye, œrœ bale œ turutœ œrœ nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kashe œdœ anga angbɨ uzu á tshe ropa ye dœ gbɔgbɔ kœyi kumu ye á gɔrɔ she, tshe gbɔtœ œrœ koshe nœ ye á tshe za lɔsu ye ga pa nœ asœmœ ye. Tshe kurutshelœ œrœ kɔ á tshe ko tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Uzu á tshe sœsœ awa bale dœ mœ nene, œshe kœdœ yingba mœ. Yé tsheneke á tshe sœsœ kœtɨ kane mœ adœke 'a ngbɔɓa azu nene, sœ kœndjɔtshelœ endje.» ");
INSERT INTO kxf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Lɔkɔ á ekpe ɨshirɨ kœgitœ ye pa uzu, tshe na djezœ lœ kpagagasho mbœrœ kœpara osho kœsœ tœnœ. Œdœ tshe kœgbɔgbɔ osho kœsœ tœnœ nene, tshe pa ɓa lœ ye adœke: “Mœ kwatœ mœ ga lœ anda nœ mœ á mœ wuta lœ nœ.” ");
INSERT INTO kxf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tshe kwatœ ye yé œ wu adœke endje ngbɔ tshasœnda, œ guma œrœ tshelœnœ dœ awanœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kœwu ataa, tshe na œ e anga aekpe ɨshirɨnœ mindu dœ bisha (7) á endje ropa ye, endje gu œ li ga sœndanœ, yé œ sœ kpœtœmœ. Mara kœsœ uzunœ asœmœ kpa sœ tœ ekpenœ kœrosœ œneke utshunœ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lɔkɔ á Yisu pa o'onœ asœmœ á ka, anga yashe á tshe sœ lima ɓa uguru ukpulu azu, pa fœ she adœke: «Yanga nœ yashe á tshe gbɔ nguzu zœ á zu ɓœ, yé á gbɔndœ zœ dœ ɔngɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kashe Yisu gi fœ she adœke: «Azu á endje sœ kœdji o'o ama Ndjaba yé á sœ kœza ga tœ akwa, endje asœmœ dá sœ dœ yanga kœropanœ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ɓata á azu ndjoro sœ lima kœngbɔtœ endje ga ɨndɨrɨ Yisu, tshe tetœ kœpa o'o fœ endje adœke: «Azu nœ tshakpesheke asœ kœdœ aekpe azu. Endje yindœ nœ adœke œne wu anga ambárá afá bale á sœ kœma adœke mœ to ɓa ndœ Ndjaba. Kashe endje wu bale nene, kolœ ambárá œneke á Ndjaba ma lœ awa nœ Yona. ");
INSERT INTO kxf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gbambanœ nene, ɓata á azu Ninive wu lima ambárá lœ awa nœ Yona, Gbolo nœ uzu œ dœ ambárá mbœrœ azu nœ tshakpesheke. ");
INSERT INTO kxf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dœ lɔkɔ kœwa ngbanga, gbozu yashe tshapa ogo ɓa lœ Sudi, œ tɔ meza pa azu nœ tshakpesheke. Gbambanœ nene, tshe to ɓa lœ ndɔngɔlɔ tshakala ogo pa ɔshɔ á na kœdji o'o á sú dœ kœwusœtœ nœ Salomo. Kashe anga uzu á tshe sœ ɓa ke, tshe ropa Salomo ye. ");
INSERT INTO kxf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dœ lɔkɔ kœwa ngbanga, azu tshalakpɨ Ninive œ tɔ meza pa azu nœ tshakpesheke. Gbambanœ nene, azu Ninive fatshalɔsu endje lɔkɔ á Yona yisœ o'o ama Ndjaba fœ endje. Kashe anga uzu á tshe sœ ɓa ke, tshe ropa Yona ye.» ");
INSERT INTO kxf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Uzu bale tata owo ga tœ miinda mbœrœ kœza yiwa tœnœ too kœza ga tshakudu lɔsu nene; kashe tshe za ga pa gbarœ á endje za miinda ga pa nœ mbœrœ adœke azu kɔ á endje li ga sœnda, mesho ngbɨ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miinda nœ undu zœ kœdœ ala zœ. Œdœ ala zœ kœsœ dœ ɔtshɔnœ, undu zœ djigi œ sœ ndje lœ ɨngbɨsho. Kashe œdœ ala zœ kœsœ dœ koɓa, undu zœ ndje œ sœ lœ ubu osho. ");
INSERT INTO kxf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ataa, sœ dœ gbɔdjela adœke miinda á sœ ɓa ndœ zœ, œ dœ ubu osho nene. ");
INSERT INTO kxf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Œdœ undu zœ djigi kœsœ tœ ɨngbɨsho yé anga osho bale kœsœsœ lœ ubu osho nene, undu zœ œ sœ lœ ɨngbɨsho ɓata ɨshirɨ miinda á tshi ga tœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lɔkɔ á Yisu pa o'o á ka, anga Farisayi bale e she adœke tshe na dœ́ œ zɨ œrœ ɓa ndœ œne. Yisu na œ li ga sœnda nœ ye, yé œ sœ ga ɨndɨrɨ ndaba kœzɨrœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kœwu lima adœke Yisu djudjutɔ kane ye ɓata awa akwa pa tœnœ utshu kœzɨrœ nene, Farisayinœ kɨtœ œsœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yé Gbozu kœpa fœ she adœke: «E'e dœ Afarisayi, 'e sœ kœdjutɔ kolœ tshapa yashi œdœ tshapa saani, kashe lɔsu 'e sú dœ ogo kœzɨ angba œdœ pe dœ ókó. ");
INSERT INTO kxf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E'e kœdœ agbakɨndɨ! Ndjaba á tshe mbœrœ tshapa œrœ, œ dœ́dœ́ she dá mbœrœ ndje tshœlœnœ nene a? ");
INSERT INTO kxf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'E ko œrœ á sœ ɓa lœ yashi œdœ œneke ɓa lœ saane nœ 'e, tœ makabo fœ aayi oyo. Yé atamœ, œrœ kɔ á 'e mbœrœ, œ sœ yerœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kashe oyo nœ 'e dœ́ Afarisayi! Mbœrœ 'e sœ kœto bale lœ ndjokpa lœ kako dɔngɔ ɓata tshalumba, dimbili œdœ tshelœ aka dɔngɔ kɔ, fœ Ndjaba. Kashe 'e sœ kœdjerœndœ kœmbœrœ œrœ á sœ ndjii œdœ pe kœyindœ Ndjaba. Œrœ á li adœke 'e mbœrœ dœmœ, kashe 'e kaka ndje tœ asœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Oyo nœ 'e dœ Afarisayi! Mbœrœ ɓa lœ Sinagoga, 'e yindœ kœsœ kolœ ɓa utshunœ ɓa tœ osho agboro azu, yé œ sœ kœyi kolœ ndœ nœ adœke azu bala 'e ɓa tœ œsœ́ angbɔtœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oyo nœ 'e! Mbœrœ 'e sœ ɓata tshapa udu á anga œrœ bale sœsœ pa nœ nene, yé á azu wuwusœ nœ nene á sœ kœna tɔpanœ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yé kœdji o'onœ ataa, anga ayi kœyisœ awa akwa nœ Ayuda bale pa fœ Yisu adœke: «Ayi kœyisœrœ, o'onœ á ɓœ pa asœmœ, ɓœ sœ kœgu ndje 'a!» ");
INSERT INTO kxf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yisu gi fœ she adœke: «Oyo nœ 'e ndje dœ aayi kœyisœ awa akwa nœ Ayuda! Mbœrœ 'e sœ kœko ogboro kongba ga pa kumu azu, kashe 'e tuturutœ anganœ dœ yɔkɔne 'e bale nene tœ kœtɨ kane endje. ");
INSERT INTO kxf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Oyo nœ 'e! Mbœrœ 'e sœ kœguma tshapa udu aayi kœgbara o'o á endje tshu, andaa aata 'e dá wo lima endje. ");
INSERT INTO kxf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ataa, 'e sœ kœma adœke 'e yindœ œrœ á aata 'e mbœrœ lima ye. Gbambanœ nene, endje wo lima aayi kœgbara o'o yé á 'e sœ kœguma tshapa udu endje. ");
INSERT INTO kxf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mbœrœ tœnœ ataa dá Ndjaba lœ kœwusœtœ nœ ye, pa adœke: “Mœ vwa bala aayi kœgbara o'o œdœ aayi avwa fœ endje; endje wo anga endje, yé œ mbœrœ œrœ kanga ga tœ anga endje.” ");
INSERT INTO kxf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mbœrœ tœnœ ataa, Ndjaba œ za djofele fœ azu nœ tshakpesheke mangba kuzu nœ aayi kœgbara o'o kɔ á endje wo lima endje, kœto ɓa tœ ali kœmbœrœ tshapashɔ, ");
INSERT INTO kxf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kœto kpœtœ kuzu Abele œrrr ga tœ œnœ Zakariya á endje wo lima she ɓa uguru ndaba tokóró œdœ œyerœ osho. Adjapu, mœ sœ kœmɨndœ nœ ngbɨ fœ 'e adœke, azu nœ tshakpesheke œ gbɔ djofele tshaangbanœ. ");
INSERT INTO kxf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Oyo nœ 'e dœ aayi kœyisœ awa akwa nœ ayuda! Mbœrœ 'e za herela nœ kœwusœrœ: E'e dœ tœ 'e 'e lili ga zœ nene, yé 'e sœ kœpakata endjeneke á endje yindœ kœli tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lɔkɔ á Yisu wuta lœ andanœ asœmœ, ayi kœyisœ awa akwa nœ ayuda dœ pe Afarisayi, sœ dœ ókó yé œ te lima tœ kœyu she tœ mara tshelœ áká o'o kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Endje sœ lima dœ gbetshelœ nœ kœgɨ uku ga tœ awa ye yeka á kœgbɔ she lœ o'o ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dœ lɔkɔnœ asœmœ, azu ngbɔtœ endje kofokofo ga tœnœ dœ mara adœke endje zurutœ endje. Yisu pa utshunœ fœ ayambarœ nœ ye adœke: «'E gbɔndœtœ 'e tœ ɔyɔ kœsuku mapa nœ Afarisayi, œ yindœ kœpa adœke œrœ wulapatshɔ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gbambanœ nene, œneke kɔ á zatœ endje yiwa tœnœ œdœ pe œneke kɔ á patœ endje lœ ubunœ, œ wuta. ");
INSERT INTO kxf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mbœrœ tœnœ ataa, o'o kɔ á 'e pa lœ ubunœ, azu kɔ œ dji ngbɨ dœ ɔlɔ. Yé o'o kɔ á 'e pa ga lœ utu anga uzu ɓa lœ gbɔshɔ, œ wuta ga shu ga pa anda ye.» ");
INSERT INTO kxf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Mœ sœ kœpandœ nœ fœ 'e dœ anga mœ adœke: 'e kpakpa awa azu á endje wo ɔkɔ nene, mbœrœ endje kpa mbœrœ œrœ bale manda nœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mœ sœ kœyisœ uzu á li adœke 'e kpa awa ye fœ 'e: 'e kpa awa Ndjaba á tshe sœ dœ gbɔgbɔ kœvwi 'e ga lœ kudu owo manda kuzu 'e. Mœ pa fœ 'e adœke œshe dá 'e kœkpa awa ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Endje kaka a'eara ayanu mindu dœ ama ngendja teasho nene a? Kashe Ndjaba djedjerœndœ anga bale lœ ugurutœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Œdœ ndje sukumu 'e, Ndjaba dɨ kɔ. Awa mbœmbœrœ 'e nene, gbambanœ nene, œsœ 'e lɨ kœropa a'eara ayanu.» ");
INSERT INTO kxf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mœ sœ kœpa fœ 'e atake: Tsheneke á tshe matœ ye ngbɨ ɓa utshu azu adœke œne kœdœ uzu nœ mœ, Gbolo nœ uzu œ ma ndje she ngbɨ ɓa utshu aandjelu nœ Ndjaba adœke œshe kœdœ uzu nœ œne. ");
INSERT INTO kxf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kashe tsheneke á tshe vwaratœ ye tœ mœ ɓa utshu azu kɔ; œmœ dœ Gbolo nœ uzu, mœ vwara ndje tœ mœ tœ ye ɓa utshu aandjelu nœ Ndjaba kɔ, adœke mœ wuwusœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yé ekpe o'o á uzu kɔ œ pa tœ upu nœ Gbolo nœ uzu, Ndjaba œ djerœndœ ekperœ nœ ye. Kashe tsheneke á tshe kœgusœ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dœ lɔkɔ á endje kœto 'e na tœnœ ɓa utshu Sinagoga too ɓa utshu aayi kœwa ngbanga too ɓa utshu agbozu nœ Lita, 'e tɔtɔ lɔsu 'e tœ mara á 'e gi dœ o'o fœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gbambanœ nene, Ɔtshɔ Ɨshirɨ œ yisœ o'o á li adœke 'e pa kolœ pe dœ ada ɔlɔnœ asœmœ fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anga uzu ɓa ugurutœ ukpulu azu pa fœ Yisu adœke: «Ayi kœyisœrœ, pandœ nœ fœ aya mœ dœ́ tshe kurutshelœ œrœ á aba 'a katœ nœ tɨ fœ 'a, tœ mœ dœ she.» ");
INSERT INTO kxf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yisu gi fœ she adœke: «Œɗe dá za mœ tœ ayi kœwa ngbanga too tœ ayi kœkurutshelœ œrœ nœ 'e a?» ");
INSERT INTO kxf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Manda nœ, tshe pa fœ endje kɔ adœke: «Ala 'e gbɔ kane! 'E sœsœ dœ egerœ lɔsu mbœrœ kœgbɔ œrœ tshapashɔ asœke nene. Gbambanœ nene, soro nœ uzu sœsœ mbœrœ œrœ nœ ye nene, œdœ tshe kœdœ ndje ayi kœgbɔrœ gbaa.» ");
INSERT INTO kxf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yé manda nœ, Yisu pa anga ndœma Toro bale fœ endje adœke: «Anga ayi kœgbɔrœ bale sœ lima dœ egerœ kɨndɨ nœ ye á tshe sœ lima kœgbɔ rœgo lœ nœ waa. ");
INSERT INTO kxf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tshe sœ lima kœgbe tshelœ ye yé œ sœ kœyutœ ye adœke: “Œrœ gaɗe dá mœ kœmbœrœ a? Mœ gugu dœ osho kœngbɔɓa rœgo nœ mœ kɔ ga tœnœ nene.” ");
INSERT INTO kxf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tshe kpa pa adœke: “Œrœ á mœ mbœrœ dœke: Mœ ndɨ tshelœ kogba nœ mœ, yé œ mɔ anga yɔngɔngɔnœ á li adœke mœ ngbɔɓa ble œdœ anga œrœ nœ mœ kɔ ga lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Manda nœ, mœ kpa pa tœ upu nœ mœ dœ tœ mœ adœke: Mœ sœ dœ œrœ waa mangba ungu ndjoro. Œ li adœke mœ yatœ mœ, mœ zɨ œrœ, mœ ndjo œrœ yé œ sœ dœ yanga.” ");
INSERT INTO kxf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kashe Ndjaba pa fœ she adœke: “Ɨndɨ, dœ butshɔ asœke ɓœ sœ dœ soro nene. Yé œrœnœ á ɓœ ngbɔɓa tsho tsho tsho ga tœnœ asœke œ dœ œnœ ɗe?”» ");
INSERT INTO kxf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yisu kpa pa adœke: «Asœ kœdœ œneke á wuta ga tœ uzu á tshe ngbɔɓa œrœ tshapashɔ kolœ mbœrœ she dœ tœ ye, kashe á dœ́dœ́ ayi kœgbɔrœ ɓa utshu Ndjaba nene.» ");
INSERT INTO kxf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Manda nœ, Yisu pa fœ ayambarœ nœ ye adœke: «'E wu ádánœ á mœ pa fœ 'e adœke: 'e zaza lɔsu 'e ga lafo tœ upu nœ kœzɨrœ á 'e gbe dœ tœnœ mbœrœ soro, too tœ upu nœ lœba á 'e gbe dœ tœnœ mbœrœ ɔkɔ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gbambanœ nene, soro nœ uzu ropa kœzɨrœ, yé undu uzu ropa lœba ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'E tondœ adiigbaga: endje lulu ngwarœ nene yé œ kɔkɔ ndje ngwarœ ɓa lœ kɨndɨ nene. Endje gugu dœ kudu too dœ kogba kœngbɔɓa rœgo nœ endje ga lœnœ nene, kashe Ndjaba sœ kœto rœgo fœ endje. E'e, œsœ 'e lɨ kœropa ayanu. ");
INSERT INTO kxf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Œɗe lœ ugurutœ 'e dá li kœza anga olo soro nœ ye ga panœ lœ awa nœ gbetshelœ á tshe sœ dœ tœnœ a? ");
INSERT INTO kxf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Œdœ 'e kœsœsœ dœ gbɔgbɔ kœmbœrœ aya œrœ nene, mbœrœ gaɗe á 'e za lɔsu 'e ga lafo tœ udu œrœ a? ");
INSERT INTO kxf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'E tondœ mara á ndɔkɔ leyɔ sœ kœgboro dœ tœnœ ɓa lœ kɨndɨ. Œ sœsœ kœmbœrœ akwa nene, yé œ susu ndje lœba nene. Kashe mœ sœ kœpa fœ 'e adœke, ataa Salomo á tshe dœ ayi kœgbɔrœ gbaa, tshe gbɔgbɔ lima lœba á ga ɓata anga ndɔkɔ leyɔnœ asœmœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Œdœ Ndjaba kœverœ lœba ga tœ oforo á sœ lœ kɨndɨ kpesheke asœ, yé ɓa mbatsha á endje li ndœ kœko va ga tœ owo; kœropa nœ kɔ, œnœ 'e dœ́ azu á 'e sœ dœ kœyindœrœ teasho, Ndjaba œ mbœrœ œrœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«'E zaza lɔsu 'e ga lafo tœ upu nœ œrœ gaɗe dá 'e zɨ too á 'e ndjo nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Azu tshapashɔnœ asœke á endje wuwusœ Ndjaba nene dá sœ kœpara œrœnœ asœmœ kɔ. Kashe e'e, 'e sœ dœ anga Aba 'e bale á tshe wusœ nœ adœke 'e gbe dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'E para utshunœ Ogo gbozu nœ Ndjaba; yé udu œrœ kɔkɔ, Ndjaba œ to fœ 'e manda nœ.» ");
INSERT INTO kxf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Aya ukpulu apata nœ mœ, 'e sœsœ dœ awa nene. Gbambanœ nene, Aba 'e sœ dœ yanga kœza ogo tshagbozu nœ ye fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","'E ka œrœ nœ 'e yé œ ko ngendjanœ tœ makabo fœ ayi oyo. 'E su ngbade ngendja á li kœndɨ tœnœ bale nene, 'e gbɔndœ œrœ ndjoro ɓa lafo, mbœrœ ɓa zœ, aayi angba œ zɨ angbanœ nene, akɔkɔ œ zɨ nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gbambanœ nene, osho á kœgbɔrœ nœ 'e sœ tœnœ, lɔsu 'e sœ ndje kpœtœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«'E verœ lœba akwa, œ kotœ 'e ga lœ vola, yé œ gbɔndœ miinda nœ 'e adœke œ ruru nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'E sœ ɓata aayi akwa á endje sœ kœkate gbozu nœ endje adœke lɔkɔ á tshe kœto ɓa tœ œsœ ngbɔtœ totœ á gu, yé á nge manda yeka œne kœkɔrɔ fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yanga nœ aayi akwa á gbozu nœ endje kœgu, á gbɔ endje dœ óvóró ala endje. Mœ sœ kœpa dœ adjapu fœ 'e adœke: Tshe verœ lœba akwa, œ pa fœ endje adœke endje sœ ga atɨ mbœrœ kœzɨ œrœ, yé tshe ko rœgo na tœnœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Œdœ tshe kœkwatœ ye dœ midi nœ butshɔ too ndje lœ ɨkɨ kɔngato, yé á tshe kœgbɔ aayi akwanœ dœ óvóró ala ndje, endje sœ dœ yanga waa. ");
INSERT INTO kxf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«'E wusœ œneke dœ ɔtshɔnœ: Œdœ ayengɔ anda kœwusœ ada ɔlɔ á ayi angba œ na dœ tœnœ, tshe katœ ye adœke tshe kavwa manda anda nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","E'e ndje, œ kotœ 'e ga lœ vola! Gbambanœ nene, Gbolo nœ uzu œ na dœ ada ɔlɔ neke á 'e wuwusœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yé Petro yu adœke: «Gbozu, ɓœ sœ kœpa ndœma Toronœ asœmœ kolœ fœ 'a too fœ azu kɔ?» ");
INSERT INTO kxf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gbozu gi fœ she adœke: «Atamœ œɗe dá dœ kapeta á tshe yɔrɔtœ ye yé á sœ dœ kœwusœrœ adœke gbozu za she ga pa aayi akwa nœ ye mbœrœ kœkurutshelœ rœgo tœ endje dœ lɔkɔnœ á li a? ");
INSERT INTO kxf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yanga nœ ayi akwa neke á gbozu nœ ye kœgu á gbɔ she lœ ama akwanœ. ");
INSERT INTO kxf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Adjapu, mœ sœ kœmɨndœ nœ ngbɨ fœ 'e adœke gbozu œ za she tœ kapeta tshapa œrœ nœ ye kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kashe œdœ ayi akwanœ kœpa adœke: “Gbozu nœ mœ œ gu katsha nene”, yé á tetœ kœɓi udu anga ayi akwanœ: Agbolo yakoshe œdœ ayawuru; œdœ tshe kœzɨ œrœ yé á ndjo œrœ á mbœrœ she, ");
INSERT INTO kxf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","gbozu nœ ayi akwanœ asœmœ œ gu dœ olo œdœ pe dœ ada ɔlɔ á tshe wuwusœ nœ nene, tshe ɓi ayi akwanœ œ gɔrɔ she yé œ mbœrœ œrœ kanga fœ she ɓata á endje mbœrœ ga tœ endjeneke á endje sœsœ dœ kœyindœrœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Ayi akwa á tshe wusœ œrœ á gbozu nœ ye sœ kœyindœ nœ yé á tshapu kœgumatœ ye yindjindjinœ, tshe sɔ she dœ ndjapa awa ndjoro. ");
INSERT INTO kxf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kashe ayi akwa á tshe kœwuwusœ œrœ á gbozu nœ ye yindœ nœ nene, yé á mbœrœ ataa, gbozunœ œ sɔ she dœ ndjapa awa ndjoro nene. Uzu á endje kœto œrœ fœ she ndjoro, endje yu she tœ œrœ ndjoro. Yé tsheneke á endje ko œrœ fœ she ropa nœ, endje kpa yu she tœ œrœ kœropa nœ.» ");
INSERT INTO kxf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yisu pa adœke: «Mœ na kœyi owo ga pa ɔshɔnœ asœ, yé ogo nœ mœ adœke owonœ tetœ kœtshi tœnœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mœ yindœ kœgbɔ batisimu, yé œ li adœke mœ wu oyo œrrr ga tœnœ adœke œ mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'E gbe adœke mœ na kœza kœsœ gee ɓa pa ɔshɔnœ asœke a? Œ̃ œ̃ nene, mœ pa fœ 'e adœke mbœrœ upu nœ mœ azu œ li ga lœ kœkurutshelœtœsho. ");
INSERT INTO kxf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngɔngɔnœ asœke, azu mindu á endje sœ sœnda bale, endje kurutshelœtœ endje: Azu votɔ œ yindœ anga endje bisha nene, yé azu bisha œ yi ndje ndœ anga endje votɔ nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aba œ yindœ gbolo yakoshe nœ ye nene, yé gbolo yakoshe œ yi ndje ndœ abanœ nene. Ayi gbolo œ yindœ yawuru nœ ye nene, yé yawuru œ yi ndje ndœ ayinœ nene. Yinɨ yashe œ yindœ awo gbolo yakoshe nene, yé awo gbolo nœ ye dœ yakoshe œ yi ndje ndœ yinɨnœ dœ yashe nene.» ");
INSERT INTO kxf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yisu pa ndje lima fœ ukpulu azu adœke: «Œdœ 'e kœwu ondoro á za tɨtɨtɨ ɓa tœ osho á ɔlɔ œ li tœnœ, atamœ 'e pa kolœnœ adœke: “Yavuru œ ni zœ”, ngbewo œ mbœrœ adja tœ ye ata ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yé œdœ 'e kœwu yugu kœto ɓa lœ sudi kœza gu tœnœ, yé á 'e pa adœke: “osho œ owo zœ”, ngbewo œ mbœrœ adja tœ ye ata ye. ");
INSERT INTO kxf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","E'e dœ awulapatshɔ, 'e li kœwusœ ambárá œrœ tshapa ɔshɔ œdœ œnœ tshalafo, kashe mbœrœ gaɗe á 'e wuwusœ ádá œrœ nœ tshakpesheke á sœ kœmbœrœtœ ye asœke nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yisu kpa pa adœke: «Mbœrœ gaɗe á 'e wawa ngbanga dœ tœ 'e tœ œneke á sœ ndjii nene a? ");
INSERT INTO kxf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Œdœ ɓœ kœsœ kœna dœ uzu á ɓœ sœ dœ o'o dœ she ga utshu ayi kœwa ngbanga, mbœrœ adœke 'e guma o'onœ lœ ugurutœ 'e dœ she tœ ala awa. Ɓœ mbœrœ atamœ kpa awa adœke ayi kœwa ngbanganœ kœzaza ɓœ ga tshakane aprusu nene, yé aprusunœ kœvwivwi ɓœ ga lœ kánga nene. ");
INSERT INTO kxf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mœ sœ kœpandœ nœ fœ ɓœ adœke, ɓœ wuta lœ kánga nene œrrr ga tœ kœgi ngendja kɔ ye kane.» ");
INSERT INTO kxf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dœ lɔkɔnœ asœmœ, anga azu na ga ndœ Yisu ndœ kœpandœ upu nœ azu Galilayi á Pilato wo lima endje lɔkɔ á endje sœ kœza tokóró fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yisu kœgi fœ endje adœke: «'E gbe adœke azu Galilayinœ asœmœ kœdœ aekpe azu á endje ropa udu azu Galilayi kɔ dœ ekperœ yekane á tshu kuzunœ asœmœ a? ");
INSERT INTO kxf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mœ sœ kœpa fœ 'e adœke, wala dœmœ. Kashe œdœ 'e kœfafatshalɔsu 'e nene, e'e para 'e tshu ndje ɓata endje. ");
INSERT INTO kxf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yé azu ndjokpa dœ mindu dœ amanœ votɔ lœ Yerusaleme á endje tshu lima lɔkɔ á egerœ anda ɓa lœ Silowe kavwa, 'e gbe adœke ekperœ nœ endje ropa œnœ azu para lœ Yerusaleme ye a? ");
INSERT INTO kxf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mœ sœ kœpa fœ 'e adœke, wala dœmœ. Kashe œdœ 'e kœfafatshalɔsu 'e nene, e'e para 'e tshu ndje ɓata endje.» ");
INSERT INTO kxf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yé Yisu kœpa Ndœma Toro asœke fœ endje adœke: «Anga uzu bale lu lima ɔyɔ fige ga lœ kɨndɨ nœ ye. Anga ɔlɔ bale, tshe na ndœ kœkɔ ele figenœ, kashe tshe gbɔgbɔ nene. ");
INSERT INTO kxf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yé tshe pa fœ ayi akwa tshelœ kɨndɨ nœ ye adœke: “wu kane, ungu votɔ kɔ, mœ sœ kœna ndœ kœkɔ ele fige asœ yé mœ sœsœ kœgbɔ tœnœ nene. De ga atɨ ye. Œ sœ kœndɨ ɔshɔ gbambanœ.” ");
INSERT INTO kxf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kashe ayi akwa kɨndɨnœ gi fœ she adœke: “Gbozu, kpa katœnœ dœ ungunœ asœke kane; mœ dji kudu dji adanœ, œ va oforo ga zœ. ");
INSERT INTO kxf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anganœ nene ungu manda nœ, œ le zœ. Á œ kœsœsœ ataa nene, ɓœ kœde ga atɨ.”» ");
INSERT INTO kxf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dœ anga ɔlɔ sabata bale, Yisu sœ lima kœyisœ œrœ ɓa lœ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Anga yashe bale sœ lima dœ ekpe ɨshirɨ á lu she manda ungu ndjokpa dœ mindu dœ amanœ votɔ, tshe lu vwerele, yé tshe lili ndœ kœyɔrɔ tshelœtœ ye ndjii nene. ");
INSERT INTO kxf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kœwu she ataa, Yisu e she œ pa fœ she adœke: «Yashe, ɓœ she ye, koɓa nœ zœ ka ye.» ");
INSERT INTO kxf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tshe to kane ye ga pa ye; trale atake, yashe kœka ndjii yé œ kœtetœ kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kashe gbozu tshapa Sinagoga wu lima tœ ekpenœ mbœrœ á Yisu she uzu dœ ɔlɔ sabata, yé œ pa fœ ukpulu azunœ adœke: «A sœ dœ olo mindu dœ bale nœ kœmbœrœ akwa; 'e na lœ olonœ asœmœ á endje kœshe 'e, kashe dœ ɔlɔ sabata nene.» ");
INSERT INTO kxf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Gbozu kœgi fœ she adœke: «E'e kœdœ aayi tshelœma, 'e sœsœ kœkɔrɔ angombe too ambarata nœ 'e dœ ɔlɔ sabata adœke endje na ndœ kœndjo ungu nene a? ");
INSERT INTO kxf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yé yashe asœ, ata Abrayamo á Satana i ɓa lima she ga tœnœ manda ungu ndjokpa dœ mindu dœ amanœ votɔ, œ lili má adœke mœ vwara she dœ ɔlɔ sabata nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Manda o'onœ asœ, ayingba ye gbɔ tshula kashe ukpulu azu para sœ lima dœ yanga nœ ɔtshɔ akwa á Yisu sœ kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yisu kœpa adœke: «Œrœ gaɗe dá li dœ Ogo gbozu nœ Ndjaba? Mœ li dœ œrœ gaɗe? ");
INSERT INTO kxf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Œ lili dœ a'eara ele mutarde á uzu œ ko angwanœ ndœ kœlu ga lœ kɨndɨ nœ ye. Œ ko, œ gerœ ɓata ɔyɔ á ayanu œ mbœrœ koma endje ga lœ ganeanœ.» ");
INSERT INTO kxf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yisu kpa pa adœke: «Œrœ gaɗe dá mœ li dœ Ogo gbozu nœ Ndjaba ma a? ");
INSERT INTO kxf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ogo gbozu nœ Ndjaba lili dœ ɔyɔ kœsuku mapa á yashe œ to ga ndœ zuwa ndjoro lœ egerœ gbarœ adœke œ suku.» ");
INSERT INTO kxf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisu ro lima tɔ lœ ongbo dœpe lakpɨ kœyisœ œrœ fœ azu tœ awa ndœ kœro ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Anga uzu kœyu she adœke: «Gbozu, azu á endje she bala, endje ngba zœ a?» Yisu kœgi fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«'E pa avwara ndœ kœli tœ manda neke á sœ teasho. Gbambanœ nene, mœ sœ kœpa fœ 'e adœke azu ndjoro œ para bala awa ndœ kœli tœnœ, kashe endje li nene. ");
INSERT INTO kxf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Lɔkɔ á ayengɔ anda kœalafo á tshu manda nœ ye ga tœnœ, e'e, 'e sœ ɓa shu, 'e tetœ kœnge manda yé œ pa adœke: “Gbozu, kɔrɔ manda fœ 'a.” Kashe tshe gi fœ 'e adœke: “Mœ wuwusœ osho á 'e to tœnœ nene!” ");
INSERT INTO kxf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yé, 'e pa fœ she adœke: “A zɨ lima œrœ yé œ ndjo lima œrœ kpœsœnœ bale dœ ɓœ, ɓœ yisœ œrœ dje lœ ongbo nœ 'a.” ");
INSERT INTO kxf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kashe tshe kpa pa fœ 'e adœke: “Mœ wuwusœ osho á 'e totœnœ nene, 'e gitœ 'e ɨndɨrɨ mœ ga zœ, e'e para dá sœ lima kœmbœrœ œrœ á sœsœ ndjii nene.” ");
INSERT INTO kxf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Dœ lɔndɔnœ asœmœ, 'e tetœ ɨkɨ dœpe kœzɨ tshelœ da iji 'e, lɔkɔ á 'e kœwu Abrayamo, Izaka, Yakobo œdœ pe aayi kœgbara o'o para á endje sœ ɓa lœ Ogo gbozu nœ Ndjaba; yé e'e, endje ko 'e va ga shu. ");
INSERT INTO kxf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Azu ndjoro œ to ɓa tœ osho á ɔlɔ œ wuta tœnœ œdœ ɓa tœ osho á ɔlɔ œ li tœnœ, ɓa tœ nɔrœ dœ pe ɓa tœ sudi, yeka á na kœgbɔ osho ɓa lœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","«Yé ataa, azu á endje sœ tœ ndɔngɔlɔnœ kpesheke, endje te azu nœ kœsœ utshunœ, yé anga azu á endje sœ lima utshunœ, œ te azu nœ ndɔngɔlɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kolœ dœ ɔlɔnœ asœmœ, anga azu Farisayi na ga ndœ Yisu, œ pa fœ she adœke: «Gitœ zœ kpœke, œ na ga tœ anga osho, mbœrœ Erode yindœ kœwo ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yisu kœgi fœ endje adœke: «'E na œ pa fœ uzunœ á tshe sœ ɓata rawo kœko angato asœmœ adœke, mœ sœ kœgɔrɔ ekpe ɨshirɨ dœ pe kœshe ayi koɓa kpesheke dœ ɓa mbatsha, tœ votɔ olonœ dá akwa nœ mœ ka ye. ");
INSERT INTO kxf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kashe œ li adœke mœ áalafo ndœ awa ana nœ mœ kpesheke, ɓa mbatsha œdœ pe ɓambiya, mbœrœ œ lili adœke ayi kœgbara o'o tshu ɓa shu nene, kashe ɓa lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusaleme, Yerusaleme, œɓœ á ɓœ sœ kœwo aayi kœgbara o'o yé á sœ kœve endjeneke á Ndjaba sœ kœvwa endje fœ 'e dœ badja! Awa ndjoro, mœ yi lima ndœ kœngbɔɓa azu nœ zœ ga tœ œsœnœ bale ɓata á ayi ngato œ ngbɔɓa ayanœ dœ ombo ye ga tshakudu ye, kashe 'e yiyi lima ndœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mbœrœ tœnœ ataa, Ndjaba œ gi ala ye pa tshalakpɨ nœ 'e ye. Mœ sœ kœpa fœ 'e, 'e kpa wu mœ nene œrrr ga tœ lɔkɔ á 'e pa adœke: “Kaka Ndjaba to kane ye ga pa uzu á tshe na dœ ɨ'ɨrɨ Gbozu!”» ");
INSERT INTO kxf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dœ anga ɔlɔ sabata bale, Yisu na lima ɓa sœnda nœ anga gbozu nœ Afarisayi ndœ kœzɨrœ. Azu á endje sœ lima ɓa zœ sœ kœtondœ Yisu dœ kœwusœrœ. ");
INSERT INTO kxf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Anga uzu bale á kotœ ye memerœ dœ koɓa ungu, ka lima ɓa utshu ye. ");
INSERT INTO kxf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yisu kœyu ayi kœyisœ awa akwa dœpe Afarisayi adœke: «Awa akwa nœ ogo nœ azœ sœ kœza awa fœ uzu adœke tshe she ayikoɓa dœ ɔlɔ sabata a too nene?» ");
INSERT INTO kxf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kashe endje sœ lima kokoko. Yé Yisu kœtepa ayikoɓanœ asœmœ, œ she she, yé á za awa fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Manda nœ, Yisu kœpa fœ endje adœke: «Uzu ɗe ugurutœ 'e á gbolo yakoshe nœ ye too ngombe nœ ye kœte ga lœ kudu dœ ɔlɔ sabata, á tshe jerœ katsha ndœ kœza she nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yé endje lili kœgi lima o'o bale ndœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu wu lima mara á Afarisayi á tshe e endje, sœ ndœ kœpara ɔtshɔ osho yeka á sœ lima kœsœ ga tœnœ, yé á pa lœ ndœma toro fœ endje para kɔkɔ adœke: ");
INSERT INTO kxf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Œdœ uzu kœ'e ɓœ ndœ angbo nœ totœ, nana œ sœ ɓa utshunœ nene. Mbœrœ anganœ, endje e ndje uzu á œsœ ye lɨ kœropa zœ. ");
INSERT INTO kxf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yé á kœsœ adœke tshe na manda nœ, á ayi angbonœ pa fœ ɓœ adœke: “Katœ osho tɨ fœ she.” Ataa dœ tshula tœ ala zœ kɔ, ɓœ na œ sœ ɓa tœ ndɔngɔlɔnœ. ");
INSERT INTO kxf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kashe, endje kœ'e ɓœ ɓa tœ œsœ angbo, na œ sœ ɓa tœ ndɔngɔlɔnœ. Yeka á ayi angbonœ kœna, á kœpa fœ ɓœ adœke: “Yanga mœ, aalafo œ na œ sœ ɓa utshunœ.” Ataa dá œsœ zœ œ lɨ tœ ala endjeneke á 'e sœ dœ endje pa ndaba kœzɨrœ bale. ");
INSERT INTO kxf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gbambanœ nene, uzu kɔ á tshe zatœ ye dœ tœ ye ga lafo, endje ku she ga atɨ, yé tsheneke á tshe zatœ ye ga atɨ, endje tɨ she ga lafo.» ");
INSERT INTO kxf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Manda nœ, Yisu kœpa fœ uzu á tshe e she adœke: «Œdœ ɓœ kpa kœsœ dœ angbo, e e anga zœ, aaya zœ, aayo zœ, amashenga nœ zœ á endje dœ aayi kœgbɔrœ nene. Gbambanœ nene, endje e ndje ɓœ ndœ œnœ endje, yé œ gi œrœ nœ zœ asœmœ kɔ fœ ɓœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kashe œdœ ɔlɔ á ɓœ kœsœ dœ angbo, e aayi oyo, agbakɨndɨ azu, aayi gbada œdœ pe aayibula ndœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ataa ɓœ sœ dœ yanga mbœrœ endje gugu dœ œrœ kœgi fœ ɓœ nene, kolœ Ndjaba dá gi fœ ɓœ lɔkɔ á tshe she bala ɔtshɔ azu lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kœdji o'onœ asœmœ ataa, anga uzu bale á tshe sœ lima ugurutœ azu á endje sœ lima pa ndaba kœzɨrœ yu Yisu adœke: «Yanga nœ uzu á tshe gbɔ osho lœ angbo á Ndjaba œ mbœrœ bala ɓa lœ ogo tshagbozu nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yisu kœpa fœ she adœke: «Anga uzu bale yi lima ndœ kœmbœrœ egerœ angbo nœ ye, yé tshe e azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ada ɔlɔ nœ kœzɨrœ li, tshe vwa ayi akwa nœ ye fœ azu á tshe e má endje adœke: “'E na ga mœ, ngɔngɔnœ asœke mœ guma œrœnœ para ye.” ");
INSERT INTO kxf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kashe endje para, awa bale, endje tetœ kœyɔndœ nœ adœke tshe wu oyo œne. Ali uzunœ pa adœke: “Mœ totœ kœyɔ kɨndɨ bale, yé œ li adœke mœ na kœwu tœnœ, mœ kɨ fœ ɓœ adœke ɓœ wu oyo mœ.” ");
INSERT INTO kxf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Anga pa œnœ ye adœke: “Mœ totœ kœyɔ angombe ndjokpa, yé mœ yindœ kœna kœwu endje œdœ endje kœsœ dœ gbɔgbɔ kœmbœrœ akwa, mœ kɨ fœ ɓœ adœke ɓœ wu oyo mœ.” ");
INSERT INTO kxf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Anga kpa pa adœke: “Mœ totœ kœto yashe ngɔngɔnœ asœke; mbœrœ tœnœ ataa mœ na nene.” ");
INSERT INTO kxf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Ayi akwanœ gu œ pandœ o'onœ kɔ ɓata á endje pa asœmœ fœ gbozu nœ ye. Gbozu anda su dœ ókó yé œ pa fœ ayi akwa nœ ye adœke: “Na katsha ɓa tœ osho kœka œrœ œdœ ɓa tœ ala awa lœ ongbo, œ gu dœ ayi oyo, agbakɨndɨ azu, aayi gbada œdœ aayibula.” ");
INSERT INTO kxf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Manda nœ teasho, ayi akwa gu œ pa adœke: “Gbozu, mœ mbœrœ neke á ɓœ pa ɓama tœnœ ye, kashe osho sœpe.” ");
INSERT INTO kxf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Gbozu kpa pa fœ ayi akwa nœ ye adœke: “Na dœ awa kɨndɨ, œ tovworogbo azu adœke endje li, mbœrœ á anda nœ mœ kœsu dœ azu. ");
INSERT INTO kxf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gbambanœ nene, mœ pa fœ 'e adœke uzu bale ugurutœ azu á mœ e ɓamama endje utshunœ asœmœ, œ gbɔ osho lœ angbo nœ mœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ukpulu azu ndjoro sœ lima kœro tœ awanœ dœ Yisu, tshe kœfatœ ye yé á kœyu endje adœke: ");
INSERT INTO kxf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Œdœ uzu kœyindœ kœna manda mœ, á kœsœpe kœyindœ abanœ, ayinœ, awonœ, agbolo nœ ye, aayanœ, ayingɔnœ œdœ pe soro ye dœ tœ ye kœropa mœ, tshe te yambarœ nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tsheneke á tshe kœzaza kurushi nœ ye yé á te manda mœ nene, tshe te yambarœ nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Gbambanœ nene, œdœ uzu kœyindœ kœmɔ egerœ anda, tshe mbœrœ kotoo? Utshunœ tshe sœ ga atɨ, œ mirœ tshelœ ye tœ ama œrœ kɔ á li ndœ kœmɔ dœ andanœ. Manda nœ, tshe wu œdœ ngendja á tshe sœ dœ tœnœ œ li kœka dœ akwanœ. ");
INSERT INTO kxf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kashe œdœ tshe kœmbœrœ kiti andanœ, á andanœ kœkaka nene, azu kɔ á endje wu, ataa endje tetœ kœmɔ she ");
INSERT INTO kxf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yé œ pa adœke: “Uzu asœ te lima tœ kœmɔ anda, kashe tshe lili kœmbœrœ akwanœ adœke œ ka nene!” ");
INSERT INTO kxf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Awa bale ndje, œdœ anga gbozugo á tshe sœ dœ aturugu kutu ndjokpa kœyindœ kœnga koshe dœ anga gbozugo á tshe sœ dœ aturugu kutu zazu bale, tshe mbœrœ kotoo? Utshunœ tshe mirœ tshelœ ye, œ tondœ mara á tshe nga dœ koshenœ mbœrœ á kœza yanganœ vesho. ");
INSERT INTO kxf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Œdœ tshe kœwu adœke œne li kœza she vesho nene, ɓata á yanganœ sœpe lœ ɨngɨrɨnœ, tshe vwa azu nœ ye fœ she adœke œne djitœ œne dœ she.» ");
INSERT INTO kxf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yisu kpa pa adœke: «Awa bale ndje ataa, uzu kɔ ugurutœ 'e á tshe kœkakatœ œrœ nœ ye kɔ á tshe sœ dœ tœnœ nene, tshe li kœdœ yambarœ nœ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ɨngbɨrɨ kœdœ ɔtshɔrœ. Kashe œdœ œ kœnganga nene, endje gi ɔtshɔnœ ga lœnœ kotoo? ");
INSERT INTO kxf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Endje li kœdjanga tshelœnœ dœ ɔshɔ too kœko ɓata oforo á endje lu dœ dɔngɔ ɓa lœ kɨndɨ nene, kashe endje za va e ga shu ye. Kaka uzu á tshe kœsœ dœ utu nœ kœdji dœ o'o, tshe dji.» ");
INSERT INTO kxf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aayi kœko ngendja lapo dœ pe aayi ngbɨndɨrœ na ga ɨndɨrɨ Yisu ndœ kœdji she. ");
INSERT INTO kxf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Afarisayi dœ pe aayi kœyisœ awa akwa tetœ kœle lœ ma endje adœke: «Uzu asœ sœ kœyindœ aayi ngbɨndɨrœ, yé œ sœ kœzɨ œrœ tœ œsœnœ dœ endje!» ");
INSERT INTO kxf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yé Yisu pa lœ ndœma toro fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Œdœ anga uzu bale ugurutœ 'e kœsœ dœ apata nœ ye kama bale (100) yé anga bale kœyiwa, tshe katœ udu endje zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) tɨ lœ gusu yé œ na kœpara tsheneke asœmœ œrrr œ gbɔ she yekane nene a? ");
INSERT INTO kxf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yé lɔkɔ á tshe kœgbɔ she, tshe za she dœ yanga ga pa ɨgɨ ye, ");
INSERT INTO kxf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yé œ gu dœ she ga ndœ ye. Manda nœ, tshe e anganœ dœ amashenga nœ ye ndœ kœpandœma nœ fœ endje adœke: “'E na ga mœ a kurutshelœ yanganœ asœ dœ 'e, mbœrœ mœ gbɔ pata nœ mœ á tshe yiwa kpœke ye!” ");
INSERT INTO kxf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mœ sœ kœpandœ nœ fœ 'e adœke, yanga ɓa lafo œ sœ bala atamœ, mbœrœ anga ayi ngbɨndɨrœ bale á tshe kœfatshalɔsu ye. Yanganœ œ ropa yanga mbœrœ ɔtshɔ azu zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) á endje sœ ndjii yé á gbegbe ndœ kœfatshalɔsu endje nene.» ");
INSERT INTO kxf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Œdœ ndje anga yashe bale kœsœ dœ langere ngendja nœ ye ndjokpa yé á anganœ bale yiwa, tshe ta owo, tshe ngbɔ osho yé œ para œrrr yé œ gbɔ yekane nene a? ");
INSERT INTO kxf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yé lɔkɔ á tshe kœgbɔ, tshe e anganœ dœ pe amashenga nœ ye ndœ kœpandœ nœ fœ endje adœke: “'E na ga mœ a kurutshelœ yanganœ asœke dœ 'e, langere ngendja nœ mœ á yiwa kpœke, mœ gbɔ ye!” ");
INSERT INTO kxf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mœ sœ kœpa fœ 'e adœke, aandjelu nœ Ndjaba œ sœ dœ yanga ataa, mbœrœ anga ayi ngbɨndɨrœ bale á tshe kœfatshalɔsu ye.» ");
INSERT INTO kxf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisu kpa pa adœke: «Anga yakoshe bale sœ lima dœ agbolo yakoshe nœ ye bisha. ");
INSERT INTO kxf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɨngɨnœ pa fœ abanœ adœke: “Aba, kurutshelœ œrœ á ɓœ sœ dœ tœnœ, œ ko œsœ œnœ mœ fœ mœ.” Yé, abanœ kurutshelœ œrœnœ tœ endje bisha dœ ayanœ. ");
INSERT INTO kxf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Manda olo teasho, ɨngɨ gbolo yakoshenœ ko œnœ ye œrœnœ yɔ œrœ para, yé œ ro ga lœ anga ogo zara. Ɓa zœ, tshe li ga lœ djingili, yé œ ndɨ ngendja nœ ye para. ");
INSERT INTO kxf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","«Manda kɨndɨ ngendja nœ ye para kɔkɔ, egerœ ogo li ga lœ ogonœ asœmœ, yé tshe li ga lœ oyo. ");
INSERT INTO kxf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tshe na œ li akwa ɓa ndœ anga uzu ogonœ asœmœ, uzunœ vwa she ga lœ kɨndɨ nœ ye mbœrœ kœgbɔndœ akɔso. ");
INSERT INTO kxf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tshe sœ lima dœ ogo kœzɨ leyɔ á akɔsonœ sœ kœzɨ tœnœ, kashe uzu bale toto fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tshe tetœ kœgbe tshelœ ye, yé œ pa adœke: “Aayi akwa nœ aba mœ para sœ kœzɨ œrœ ɓata á endje yindœ nœ, kashe ɓa ke, mœ sœ kœtshu dœ ogo! ");
INSERT INTO kxf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mœ gu ga ndœ aba mœ, yé œ pa fœ she adœke: Aba, mœ mbœrœ lima ekperœ fœ Ndjaba œdœ pe fœ ɓœ. ");
INSERT INTO kxf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mœ kpa lili ndœ kœsœ tœ gbolo yakoshe nœ zœ nene, kashe fa mœ tœ anga ayi akwa nœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yé tshe tetœ awa ndœ kœgu ga ndœ abanœ. Abanœ wu she lima lœ ugunœ, yé oyo ye ka she, á tshe kœkpa dœ ɔrɔ para tshatshu ye œ kœtepa ye dœ kœuru tshelœ utu ye. ");
INSERT INTO kxf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gbolo yakoshe kœpa fœ she adœke: “Aba, mœ mbœrœ ekperœ fœ Ndjaba œdœ pe fœ ɓœ, mœ kpa lili adœke ɓœ e mœ gbolo yakoshe nœ zœ nene.” ");
INSERT INTO kxf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kashe abanœ pa fœ ayi akwa nœ ye adœke: “'E na dœ ɔtshɔ lœba ga mœ katsha œ verœ ga tœ ye, œ yi bingi ga tœ yɔkɔne ye œ verœ œrada ga tœ ada ye. ");
INSERT INTO kxf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'E na dœ́ za ɔtshɔ ovoro ngombe á tshe sœ dœ ojoro, œ wo she. A mbœrœ angbo œ zɨ she. ");
INSERT INTO kxf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gbambanœ nene, gbolo yakoshe nœ mœ á e wu she asœke, tshu lima yé á kpa kwatœ ye dœ soro asœ, tshe yiwa lima yé á mœ gbɔ she asœ.” Yé endje tetœ kœmbœrœ angbo. ");
INSERT INTO kxf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Dœ lɔndɔnœ asœmœ, eya gbolo yakoshe nœ ye sœ lima ɓa lœ kɨndɨ. Lɔkɔ á tshe to lima ɓa lœ kɨndɨ kœgu she, ndoo dœ anda atake, tshe dji œsœ itshi dœ pe ipi. ");
INSERT INTO kxf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tshe kœ'e anga ayi akwa, yé á kœyu she tœ œrœ á sœ kœmbœrœtœ endje ɓa sœnda. ");
INSERT INTO kxf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ayi akwanœ kœgi fœ she adœke: “Aya zœ dá gu, yeka á aba zœ wo ɔtshɔ ovoro ngombe á tshe sœ dœ ojoro mbœrœ á tshe wu she kœgu tœnœ dœ ɔtshɔ ɔkɔ ye.” ");
INSERT INTO kxf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Eyanœ dji ataa, œ so ókó, yé œ vwaratœ ye kœli anda ye. Abanœ wuta ndœ kœu she. ");
INSERT INTO kxf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kashe tshe gi fœ abanœ adœke: “Aba, mœ mbœrœ akwa ɓata kanga fœ ɓœ manda ungu ndjoro, mœ vwavwaratœ mœ tœ anga awa o'o nœ zœ bale nene, kashe ɔlɔ bale á ɓœ za anga ngombe nœ zœ fœ mœ adœke mœ mbœrœ angbo dœ she dœ anga mœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kashe lɔkɔ á gbolo yakoshe nœ zœ asœ gu, œshe á tshe ndɨ œrœ nœ zœ ndœ agugatɨ, ɓœ wo ɔtshɔ ovoro ngombe á tshe sœ dœ ojoro mbœrœ she!” ");
INSERT INTO kxf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yé abanœ kœpa fœ she adœke: “Gbolo nœ mœ, œɓœ, ɓœ sœ œnœ zœ dœ mœ waa kpœke. Œrœ nœ mœ para kœdœ œnœ zœ. ");
INSERT INTO kxf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kashe, œ li adœke a mbœrœ angbo œ sœ dœ yanga, mbœrœ aya zœ asœke tshu lima yé á kwatœ ye dœ soro asœke. Tshe yiwa lima yé á mœ gbɔ she asœke.”» ");
INSERT INTO kxf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Manda nœ, Yisu pa fœ ayambarœ nœ ye adœke: «Anga ayi ngendja sœ lima dœ kapeta nœ ye, yé anga azu na œ pandœ nœ fœ she adœke kapetanœ sœ kœndɨ œrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tshe kœ'e kapeta œ pa fœ she adœke: “O'o gaɗe dá mœ dji dœ ɨ'ɨrɨ zœ ata a? Ma mara á ɓœ mbœrœ akwa dœ ngendja fœ mœ dœ́ mœ wu, mbœrœ ngɔngɔ asœ ɓœ kpa dœ́dœ́ kapeta nœ œrœ nœ mœ nene.” ");
INSERT INTO kxf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Kapeta kœtetœ kœpu lœ ma ye adœke: “Gbozu nœ mœ yindœ kœza akwa tshakane mœ. Mœ mbœrœ kotoo? Mœ gugu dœ gbɔgbɔ ndœ kœdjo kɨndɨ nene. Mœ sœ dœ tshula kœyɔndœ œrœ. ");
INSERT INTO kxf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mœ wusœ œrœ á mœ mbœrœ ye! Mœ tetœ kœyindœ azu á endje kœyindœ mœ kœna ga ndœ endje ɔlɔ á akwa kapeta nœ mœ kœka.” ");
INSERT INTO kxf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tshe e uzu dœ uzu á tshe sœ lima dœ kuɗa nœ gbozu nœ ye, yé œ yu tsheneke á tshe na utshunœ adœke: “Kuɗa nœ gbozu sœ lima lœ kumu zœ kotoo?” ");
INSERT INTO kxf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Uzunœ kœgi fœ she adœke: “Ngbongolo kada kama bale (100).” Kapeta kœpa fœ she adœke: “Za mbeti kuɗa nœ zœ, sœ ga atɨ œ su adœke: Ngbongolo kada zazu bisha dœ ndjokpa.” ");
INSERT INTO kxf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tshe kpa yu anga adœke: “Ɓœ sœ dœ kuɗanœ kotoo?” Uzunœ gi fœ she adœke: “Sake nœ indji ble kama bale (100).” Kapeta kœpa fœ she adœke: “Za mbeti kuɗa nœ zœ, yé œ su adœke: Zazu vana.” ");
INSERT INTO kxf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gbozu donga ekpe kapetanœ mbœrœ á tshe mbœrœ akwa nœ ye dœ kœwusœrœ, yé œ pa adœke: “Azu á endje sœ kœgbe dœ kœgbɔ œrœ nœ tshapashɔ asœke sœ hara hara lœ kœmbœrœ ayo ugurutœ endje dœ anga endje kœropa endjeneke á endje dœ́ azu nœ ɨngbɨsho.”» ");
INSERT INTO kxf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisu kpa pa adœke: «'E mbœrœ ayo dœ azu lœ awa nœ kœgbɔrœ nœ tshapashɔnœ asœke á sœ kœfara osho mbœrœ á 'e kœgugu dœ tœnœ nene, yeka á Ndjaba kœza osho kœsœ nœ waa dœ waa fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Uzu á tshe kœzatœ ye ndjii lœ aya akwa, tshe za ndje tœ ye ndjii lœ egerœ akwa. Yé tsheneke á tshe dœ ayi wala lœ aya akwa, tshe dœ ndje ayi wala lœ egerœ akwa. ");
INSERT INTO kxf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Œdœ 'e kœsœsœ kœzatœ 'e ndjii lœ mara kœmbœrœ akwa dœ ngendja á dœ œrœ afara nene, œɗe dá to adja ɔtshɔrœ fœ 'e a? ");
INSERT INTO kxf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yé œdœ 'e kœmbœmbœrœtœ 'e ndjii lœ kœza œrœ nœ anga azu ga tœ akwa nene, œɗe dá to œrœ neke á sœ mbœrœ 'e fœ 'e a? ");
INSERT INTO kxf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ayi akwa bale lili kœmbœrœ akwa fœ agbozu bisha nene. Gbambanœ nene, œdœ tshe kœsœ kœyindœ anga bale, tshe yiangba anga; too œdœ tshe kœzatœ ye ga ndœ tsheneke utshunœ, tshe vwaratœ ye tœ anga. 'E lili adœke 'e mbœrœ akwa fœ Ndjaba dœ kœdœ akanga nœ ngendja nene.» ");
INSERT INTO kxf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afarisayi á endje yindœ ngendja waa, dji lima o'onœ ataa yé œ tetœ kœmɔ Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yisu kœpa fœ endje adœke: «E'e, 'e sœ kœmatœ 'e ɓata azu á endje sœ ndjii tœ ala azu, kashe Ndjaba wu lɔsu 'e ye. Gbambanœ nene, œneke á azu sœ kœza dœ ádá waa, Ndjaba wu tœ ekpenœ. ");
INSERT INTO kxf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Œndœ buku nœ awa akwa nœ Moyize œdœ buku á aayi kœgbara o'o su lima, dɨ œrrr ga tœ kœna Yowane ayi kœza batisimu. Dœ lɔndɔnœ asœmœ, endje sœ lima kœyisœ Ɔtshɔ O'o nœ Ogo gbozu nœ Ndjaba, yé uzu dœ uzu sœ kœpa lima avwara ndœ kœli ga zœ. ");
INSERT INTO kxf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Andaa tshalafo dœ tshapashɔ œ yiwa ye, kashe endje wa œrœ bale lœ awa akwa nene, œdœ ndje tshakanea a'eara uwu mbeti nene. ");
INSERT INTO kxf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Yakoshe kɔ á tshe katœ awonœ tɨ yé á to ata anga, tshe mbœrœ angba budu. Tsheneke á tshe to yashe á akɔnœ katœ ye tɨ, tshe sœ kœmbœrœ ndje angba budu.» ");
INSERT INTO kxf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Anga uzu bale kœdœ lima ayi kœgbɔrœ, tshe verœ kolœ ɔtshɔ lœba nœ ngendja. Ɔlɔ dœ ɔlɔ tshe sœ lima kœzɨ ɔtshɔrœ ɓata uzu sœ dœ angbo. ");
INSERT INTO kxf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Anga ayi oyo á ɨ'ɨrɨ ye kœdœ Lazaro, sœ lima kœlo ɓa pa manda anda nœ ye; tshe sœ lima dœ uku gbadja tœ kotœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tshe sœ lima kœyindœ kœzɨ kutirɨ kœzɨrœ á sœ kœyo ɓa tshakudu ndaba kœzɨrœ nœ ayi kœgbɔrœ sœmœ kashe tshe lili lima nene. Yé ayavoro sœ ndje lima kœna kœla tshala uku gbadja nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ayi oyo tshu, yé aandjelu to she na tœnœ ndoo dœ Abrayamo. Ayi kœgbɔ œrœ tshu ndje, yé endje shi she. ");
INSERT INTO kxf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ayi kœgbɔ œrœ sœ lima kœwu oyo waa ɓa lœ ogo nœ akuzu. Tshe mesho ga lafo atake, œ wu Lazaro á tshe sœ ndoo dœ Abrayamo. ");
INSERT INTO kxf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tshe kœve rawa adœke: “Aba mœ dœ Abrayamo, wu oyo mœ dœ́ œ vwa Lazaro tshe yi yɔkɔne ye ga la ngu dœ́ œ sa ga pa tima mœ kane, mbœrœ mœ sœ kœwu oyo ɓa la wo ɓa ke waa.” ");
INSERT INTO kxf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kashe Abrayamo pa fœ she adœke: “Gbolo nœ mœ, wusœ nœ adœke ɓœ gbɔ lima œrœ tshapashɔ lœ soro zœ ndjoro, kashe Lazaro sœ lima dœ oyo kœrosœ nœ. Ngɔngɔ asœke, oyo nœ ye ka ye, andaa œɓœ, ɓœ sœ kœwu oyo. ");
INSERT INTO kxf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ga pa nœ, egerœ kudu wa mapaka ugurutœ zœ dœ a'a ye. Uzu œ to ɓa ke œ na ga ndœ 'e ɓa zœ nene, uzu œ to ndje ɓa ndœ 'e ɓa zœ œ na ndje ga ndœ 'a nene.” ");
INSERT INTO kxf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ayi kœgbɔrœ kœpa adœke: “Mœ sœ kœdɨ tshelœma mœ fœ ɓœ, aba, vwa Lazaro ɓa sœnda nœ aba mœ, ");
INSERT INTO kxf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mbœrœ mœ katœ aaya mœ mindu ɓa zœ. Tshe mɨndœ nœ fœ endje mbœrœ adœke endje kœnana ɓa tœ osho á mœ wu oyo tœnœ ɓa ke asœ nene.” ");
INSERT INTO kxf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrayamo kœpa fœ she adœke: “Aaya zœ wusœ buku nœ awa akwa nœ Moyize dœ pe kœmɨ upu nœ aayi kœgbara o'o, yé endje dji œ za ga tœ akwa.” ");
INSERT INTO kxf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ayi kœgbɔrœnœ kpa pa adœke: “Œ sœsœ ataa nene Abrayamo aba mœ, œdœ uzu kœtshu lima, yé á wuta á na ga ndœ endje, endje fatshalɔsu endje ye.” ");
INSERT INTO kxf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kashe Abrayamo kpa kœgi fœ she adœke: “Œdœ endje kœdjidji Moyize dœ pe aayi kœgbara o'o nene, œdœ ndje uzu á tshe kœtshu, á she, á na ga ndœ endje, endje yi ndje ndœ o'o ye nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisu pa fœ ayambarœ nœ ye adœke: «Œrœ á sœ kœyi azu ndœ kœmbœrœ ekperœ sœ zœ. Kashe oyo nœ tsheneke á tshe yi anganœ ga lœ ekperœ! ");
INSERT INTO kxf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Œ li dœ she adœke endje du egerœ badja ga tœ ɨgɨ ye œ vwi she ga la egerœ ungu. Œ sœ dœ ɔtshɔnœ mbœrœ she ata tœ œsœnœ adœke tshe yi anga gbolo bale lœ agbolo asœ ga lœ ekperœ. ");
INSERT INTO kxf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'E sœ dœ gbɔdjela! «Œdœ aya zœ kœmbœrœ ekperœ fœ ɓœ, gbagbara she. Yé œdœ tshe kœgbetshelœ ye ndœnœ á fatshalɔsu ye, wu oyo ye. ");
INSERT INTO kxf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Œdœ tshe kœmbœrœ ekperœ fœ ɓœ awa mindu dœ bisha (7) lœ ɔlɔ bale, yé á na ndje ga ndœ zœ awa mindu dœ bisha (7) kœpa fœ ɓœ adœke: “Œneke á mœ mbœrœ sœ tœ ekpenœ”, wu kolœ oyo ye.» ");
INSERT INTO kxf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aayi avwa kœpa fœ Gbozu adœke: «Mbœrœ adœke kœyindœrœ nœ 'a gerœ.» ");
INSERT INTO kxf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Gbozu kœgi adœke: «Œdœ adja 'e kœsœ má dœ kœyindœrœ dœ egerœnœ ɓata ele ɔyɔ á ɨ'ɨrɨnœ kœdœ mutarde, 'e pa má fœ ɔyɔ asœ adœke: “Gitœ zœ kpœke œ na œ tɔ ɓa la kota ɓa e”, yé œ mbœrœtœ ye liaka o'o 'e ye.» ");
INSERT INTO kxf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Uzu ɗe ugurutœ 'e á tshe kœsœ dœ ayi akwa nœ ye á tshe djo kɨndɨ too á tshe gbɔndœ ayarœ, yé á ayi akwanœ to ɓa lœ kɨndɨ á gu, á tshe pa fœ she kpuru adœke: “Na katsha œ zɨ œrœ a?” ");
INSERT INTO kxf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Œ̃ œ̃ nene, tshe pa fœ she adœke: “Fa kœzɨrœ fœ mœ, yapa lœba zœ yeka á kœko kœzɨrœ ga pa ndaba fœ mœ. Mœ kœzɨ œrœ á kœndjo œrœ yeka á ɓœ kœzɨ á kœndjo ndje œnœ zœ manda nœ.” ");
INSERT INTO kxf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gbozu lili kœgi ɔtshɔrœ fœ ayi akwanœ mbœrœ œrœ neke á tshe pa tœnœ fœ she, yé á tshe mbœrœ liakanœ nene a? ");
INSERT INTO kxf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Œ sœ ndje awa bale mbœrœ 'e, œdœ 'e kœmbœrœ neke kɔ á endje pa tœnœ fœ 'e, 'e pa adœke: “A'a kœdœ ayi akwa gbambanœ, 'a mbœrœ kolœ akwa neke á li adœke 'a mbœrœ.”» ");
INSERT INTO kxf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ɓata á Yisu sœ lima kœro ga lœ Yerusaleme, tshe ro tɔ lœ ogo Samariya œdœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ɔlɔ á tshe li lima ga lakpɨ anga ongbo bale, aayi boroma ndjokpa na ndœ kœtogba dœ she. Endje ka lima zara, ");
INSERT INTO kxf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","yé œ tetœ kœ'e she dœ ɔgbɔ adœke: «Yisu, ayi kœyisœrœ, wu oyo 'a kane.» ");
INSERT INTO kxf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yisu wu endje œ pa fœ endje adœke: «'E na œ matœ 'e fœ anganga Ndjaba.» Andaa kœna ga zœ, tœ ala awa, endje she ye. ");
INSERT INTO kxf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Anga bale ugurutœ endje, kœwu adœke œne she ye, á kwatœ ye dœ kœdonga Ndjaba dœ agbɔ tshama ye. ");
INSERT INTO kxf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tshe gote ga tœ ada Yisu, œ tara kumu ye ga atɨ yé œ za mershe fœ she. Kashe uzunœ asœmœ lima kœdœ uzu Samariya. ");
INSERT INTO kxf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yé Yisu kœpa adœke: «Ataa œ dœ́dœ́ endje ndjokpa kɔkɔ dá she nene a? Anga endje mindu dœ vana, sœ œnœ endje kpœta a? ");
INSERT INTO kxf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Anga uzu ugurutœ endje gbegbe ndœ kœkwa kœdonga Ndjaba nene, kashe kolœ genenœ asœke!» ");
INSERT INTO kxf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yé Yisu kœpa fœ she adœke: «Alafo, œ gu zœ. Kœyindœrœ nœ zœ she ɓœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afarisayi kœyu she adœke: «Ɔlɔ gaɗe dá akwa tshagbozu nœ Ndjaba œ na a?» Yisu kœgɨ fœ endje adœke: «Akwa tshagbozu nœ Ndjaba œ na dœ mara adœke uzu wu nene. ");
INSERT INTO kxf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","«Endje pandœ nœ adœke: “Wu, tœnœ dá sœ asœ, too œtœnœ dá sœ ɓa e” nene. Gbambanœ nene, akwa tshagbozu nœ Ndjaba sœ ugurutœ 'e zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yé Yisu kœpa fœ ayambarœ nœ ye adœke: «Osho sœ kœndo tœnœ zœ, osho á 'e sœ dœ ogo nœ kœwu amba anga olo bale ugurutœ olo nœ Gbolo nœ uzu, kashe 'e wu nene. ");
INSERT INTO kxf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Endje tetœ kœpa fœ 'e adœke: “Tshe sœ ɓa 'e”, too “tshe sœ ɓa ke.” Kashe, 'e nana ga zœ nene, 'e kpakpa ndje ɔrɔ ga zœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gbambanœ nene, ɔlɔ á Gbolo nœ uzu œ na, œ sœ ɓata Yavuru á yerœwa ɓa lafo, yé á ɨshirɨnœ œ za osho djigi. ");
INSERT INTO kxf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kashe utshunœ, œ li adœke tshe wu oyo waa, yé azu nœ ngɔngɔnœ asœke vwaratœ endje tœ ye yekane. ");
INSERT INTO kxf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Lɔndɔ á olo kœna Gbolo nœ uzu kœli, œrœ œ mbœrœtœ endje ɓata œnœ lɔkɔ nœ Nowa lima. ");
INSERT INTO kxf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Azu sœ lima kœzɨ œrœ dœ kœndjo œrœ, endje sœ lima kœtotœ endje dœ kœko ayawuru nœ endje ndœ totœ œrrr ga tœ olo á Nowa li lima ga lœ egerœ agba, yeka á yavuru ni lima, á ungu su lima pa ɔshɔ kpɔlirɔ, yé á wo endje lima para. ");
INSERT INTO kxf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Œ sœ ndje ɓata œnœ lɔkɔ nœ Lota lima: Azu sœ lima kœzɨ œrœ dœ kœndjo œrœ, endje sœ kœyɔ œrœ dœ kœka œrœ, endje sœ lima kœlu œrœ ga lœ kɨndɨ dœ kœmɔ anda. ");
INSERT INTO kxf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kashe olo kœwuta lima Lota lœ Sodomo, Ndjaba vwa owo ɓata yavuru, œ to ɓa lafo kœyo ga atɨ dœ pe jiwonœ á dɨ yeee, yeka á wo lima azu para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Œ mbœrœ bala tœ endje ataa lɔkɔ á Gbolo nœ uzu œ ma bala tœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Dœ olonœ asœmœ, uzu á tshe kœsœ ɓa pa kumu anda á œrœ nœ ye sœ ɓa sœnda, tshe kpa gerœ ga atɨ kœza tœnœ nene; œ sœ ndje ataa fœ uzu á tshe kœsœ ɓa lœ kɨndɨ, tshe kpa kwatœ ye ga mangba ye nene. ");
INSERT INTO kxf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'E gbetshelœ 'e tœ upu nœ awo Lota kane. ");
INSERT INTO kxf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uzu neke á tshe para awa ndœ kœgbɔndœ soro ye, tshe tshu; kashe tsheneke á tshe gbɔndœ nœ nene dá she. ");
INSERT INTO kxf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mœ sœ kœpandœ nœ fœ 'e, lœ butshɔnœ asœmœ, ayakoshe bisha œ lopa gbarœ bale: Endje za anga bale, yé anga œ sœpe. ");
INSERT INTO kxf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ayashe bisha œ sœ kœtɔ œrœ tœ œsœnœ bale: Endje za anga bale, yé anga œ sœpe.  ");
INSERT INTO kxf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ayakoshe bisha œ sœ kœmbœrœ akwa ɓa lœ kɨndɨ, endje za anga bale yé anga œ sœpe.» ");
INSERT INTO kxf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ayambarœ nœ Yisu yu she adœke: «Œrœnœ atamœ œ mbœrœtœ endje kpœta Gbozu?» Yé tshe kœgi fœ endje adœke: «Osho á oko uzu œ sœ tœnœ, dá adivumbala, œ na kœngbɔtœ endje ɓa zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yisu pa ndœma toro asœke mbœrœ kœma fœ endje adœke endje shi gbɨ lœ kœza avwala, endje gbɔgbɔ dɔkɔngɔ nene. ");
INSERT INTO kxf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tshe pa fœ endje adœke: «Anga ayi kœwa ngbanga á tshe kpakpa awa Ndjaba nene yé á lɨlɨ ndje œsœ uzu bale nene, sœ lima ɓa lœ anga ongbo bale. ");
INSERT INTO kxf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yé anga yashe koya sœ lima kœna ga ndœ ye ɔlɔ dœ ɔlɔ kœpa fœ she adœke: “Wa ngbanga ugurutœ mœ dœ ayingba mœ asœke kane.” ");
INSERT INTO kxf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Katshatsha ayi kœwangbanganœ sœ ɓa lima kœvwaratœ ye, yé tshe sœ kœpa dœ tœ ye adœke: “Ataa mœ kœkpakpa awa Ndjaba nene yé á kœlɨlɨsœ azu nene, ");
INSERT INTO kxf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kashe ɓata á yashe koya asœ sœ kœndanga mœ, mœ wa ɔtshɔ ngbanga fœ she mbœrœ á tshe kpa kœkwakwatœ ye ndœ kœtshanga kumu mœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yé Gbozu kpa kœpa ga pa nœ adœke: «'E dji o'o á ayi kœwangbanga á tshe sœsœ ndjii nene, sœ kœpa tœnœ dœ ɔtshɔnœ kane! ");
INSERT INTO kxf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yé dœ mara ataa, Ndjaba œ wa ɔtshɔ ngbanga ga tœ azu á tshe ke endje á endje sœ kœkɨ ga tœ ye butshɔ dœ ɔlɔ nene a? Tshe gbeletœ ye ndœ kœtɨ kane endje ga lafo ye a? ");
INSERT INTO kxf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mœ sœ kœpa fœ 'e ngbɨ adœke: Tshe wa ɔtshɔ ngbanga fœ endje katsha ye. Kashe lɔkɔ á Gbolo nœ uzu œ kwa bala, tshe gbɔ azu á endje sœ dœ kœyindœrœ ga ndœ Ndjaba pa ɔshɔ zœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tshe kpa pa ndœma toro asœke fœ anga azu á endje sœ kœgbe adœke œne sœ ndjii tœ ala Ndjaba, yé á sœ kœgu œsœ anga endje adœke: ");
INSERT INTO kxf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Anga azu bisha na lima ga lœ Tepelo ndœ kœza avwala; anga bale kœdœ Farisayi yé anga kœdœ ayi kœko ngendja lapo. ");
INSERT INTO kxf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisayinœ ka ga lafo, œ sœ lima kœza avwala tœ upu nœ ye dœ tœ ye adœke: “Uu Ndjaba, mœ sœ kœdonga ɓœ mbœrœ mœ sœsœ ɓata anga azu nene, endje kœdœ aayi angba, aayi djingili, aayi angba budu, mœ sœsœ ndje ɓata ayi kœko ngendja laponœ á tshe sœ ɓa e asœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mœ sœ kœyotshelœma mœ olo bisha lœ pɔsɔ bale, yé œ sœ kœto œrœ bale lœ ndjokpa lœ œrœ nœ mœ kɔ á mœ sœ kœgbɔ tœnœ fœ ɓœ.” ");
INSERT INTO kxf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ayi kœko ngendja lapo sœ œnœ ye zara; tshe yiyi lima ndœ kœmesho ga lafo nene, kashe tshe sœ kœda okoro ye yé œ sœ lima kœpa adœke: “Uu Ndjaba, wu oyo mœ dœ ekpe uzu á mœ sœ asœke.” ");
INSERT INTO kxf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","«Yisu kœpa fœ endje adœke: “Mœ sœ kœmɨndœ nœ fœ 'e, ayi kœko ngendja lapo wuta lima ndjii tœ ala Ndjaba lɔkɔ á tshe gu ga ndœ ye, kashe œ dœ́dœ́ Farisayinœ nene. Gbambanœ nene, uzu kɔ á tshe tɨtœ ye dœ tœ ye ga lafo, Ndjaba œ ku she ga atɨ, kashe tsheneke á tshe zatœ ye ga atɨ, Ndjaba œ tɨ she ga lafo.”» ");
INSERT INTO kxf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Azu sœ lima kœna ndje dœ aaya agbolo fœ Yisu mbœrœ adœke tshe to kane ye ga pa endje. Kœwu ataa, ayambarœ sœ lima kœgeta endje. ");
INSERT INTO kxf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kashe Yisu e agbolo ga ndœ ye, yé á kœpa adœke: «'E katœ agbolo dœ́ endje na ga ndœ mœ! 'E kɔkɔ endje nene, mbœrœ ogo Gbozu Ndjaba sœ mbœrœ azu á endje sœ ɓata endje. ");
INSERT INTO kxf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mœ sœ kœpa dœ adjapu fœ 'e adœke: Uzu neke á tshe yiyindœ ogo Gbozu Ndjaba ɓata gbolo nene, tshe li bala ga zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Anga gbozu tshapa ayuda bale yu Yisu adœke: «Ɔtshɔ ayi kœyisœrœ, œrœ gaɗe dá mœ kœmbœrœ á kœgbɔ soro á ka nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yisu kœpa fœ she adœke: «Mbœrœ gaɗe á ɓœ e mœ ɔtshɔ uzu a? Uzu bale sœsœ dœ ɔtshɔnœ nene, kolœ Ndjaba kutɨ ye. ");
INSERT INTO kxf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ɓœ wusœ awa o'o ye: “Mbœmbœrœ angba budu nene, wowo uzu nene, zɨzɨ angba nene, papa wala ga pa uzu nene, lɨsœ aba zœ dœ pe ayi zœ.”» ");
INSERT INTO kxf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gbozu tshapa ayudanœ asœmœ kœgi adœke: «Mœ sœ kœmbœrœtœ mœ ɓa lima liakanœ pe lœ gbolo mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisu kœdji ataa yé á kœpa fœ she adœke: «Œ sœpe œrœ bale á ɓœ mbœmbœrœ nene: Œrœ kɔ á ɓœ sœ dœ tœnœ, ka œ kurutshelœ ngendjanœ tœ aayi oyo. Ataa, ɓœ gbɔ bala kœgbɔrœ ɓa lafo. Manda nœ, na ga mœ yé œ te manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lɔkɔ á tshe dji o'onœ asœmœ ataa, oyo za she waa, mbœrœ œshe kœdœ lima ayi kœgbɔrœ. ");
INSERT INTO kxf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisu wu adœke tshe sœ lima dœ oyo, œ pa adœke: «Tœ adœke aayi kœgbɔrœ li ga lœ Ogo gbozu nœ Ndjaba, œ sœ tœ ɔgbɔnœ. ");
INSERT INTO kxf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gbambanœ nene, agea á ɨ'ɨrɨ ye kœdœ Shamo li kœli tɔ lœ ogoro ɨmbɨlɨ dœ ɔtshɔnœ, kashe œ kpa gbɔ kœrosœ nœ adœke ayi kœgbɔrœ li ga lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Azu á endje sœ lima kœdji o'onœ asœmœ yu adœke: «Atamœ, œɗe dá li kœshe tœnœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yisu kœgi adœke: «Œrœ á azu lili ndœ kœmbœrœ tœnœ nene, Ndjaba œ mbœrœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yé Petro pa adœke: «Dji 'a kane. 'A katœ œrœ nœ 'a yé œ te manda zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yisu kœgi fœ endje adœke: «Mœ sœ kœpa dœ adjapu fœ 'e adœke, uzu kɔ á tshe katœ anda nœ ye, awonœ, ayingɔnœ, abanœ dœ aayanœ too agbolo nœ ye mbœrœ kœzatœ ye ndœ Ogo gbozu nœ Ndjaba, ");
INSERT INTO kxf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tshe gbɔ œrœ kœropanœ dœ osho asœke. Yé dœ osho á na manda nœ, tshe gbɔ ndje soro á ka nene.» ");
INSERT INTO kxf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisu ko ayambarœ nœ ye ndjokpa dœ bisha, œ pa fœ endje adœke: «'E dji kane, a sœ kœro ga lœ Yerusaleme, yé ɓa zœ dá o'o para á aayi kœgbara o'o su lima tœ upu nœ Gbolo nœ uzu œ mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Endje za she ga tshakane azu á endje wuwusœ Ndjaba nene. Endje mɔ she, endje gu she dœ pe kœtu ngusha ga tœ ye; ");
INSERT INTO kxf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","manda kœsɔ she dœ ndjapa, endje wo she. Yé manda olo votɔ, tshe she lœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kashe, ayambarœ wuwu lima sœ œrœ bale lœ nœ nene. Ádá o'onœ za lima tœ endje yiwatœ nœ tœ endje ye. Endje djidji lima tshelœ kata o'onœ á Yisu yi lima ndœ kœpa tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lɔkɔ á Yisu wuta lima ndoo dœ Yeriko, anga ayibula sœ lima ga atɨ ga tœ ama awa, á sœ kœyɔndœ œrœ. ");
INSERT INTO kxf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kœdji œsœ azu ndjoro kœro tœ awa, tshe yu lima osho adœke: «Œrœ gaɗe dá sœ kœmbœrœtœ endje asœmœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Endje pandœ nœ fœ she adœke: «Yisu, uzu Nazarete dá ro asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tshe kœta rawa adœke: «Yisu Gbolo nœ Davidi, wu oyo mœ kane!» ");
INSERT INTO kxf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Azu á endje sœ lima kœna utshunœ, te lima tœ kœgbagbara she adœke tshe sœ koko. Kashe, tshe kpa ta rawa dœ ɔgbɔ adœke: «Gbolo nœ Davidi, wu oyo mœ kane!» ");
INSERT INTO kxf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yisu ka, yé œ pa adœke endje na dœ she fœ œne. Lɔndɔ á ayibula sœmœ wuta ndoo, Yisu yu she adœke: ");
INSERT INTO kxf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Œrœ gaɗe dá ɓœ yindœ nœ adœke mœ mbœrœ fœ ɓœ a?» Tshe kœgi adœke: «Gbozu, mœ yindœ kpa kœwu osho.» ");
INSERT INTO kxf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yisu kœpa fœ she adœke: «Wu osho. Kœyindœrœ nœ zœ she ɓœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Petœ œsœnœ tshe wu osho, yé œ te lima kœna manda Yisu dœ kœdonga Ndjaba. Kœwu tœnœ ataa, azu kɔ tetœ kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Manda kœli Yisu ga lœ Yeriko, tshe ro lima tɔ lœ ongbonœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Anga uzu á ɨ'ɨrɨ ye kœdœ Zakayo, sœ lima ɓa zœ; œshe kœdœ gbozu tshapa aayi kœko ngendja lapo, yé œshe lima kœdœ ayi kœgbɔrœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tshe sœ lima kœpara awa kœwu Yisu adœke œshe kœdœ œɗe; kashe ɓata á tshe sœ lima tœ ondonœ, awa adœke tshe wu she gugu lima nene mbœrœ azu ro lima sœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tshe kpa utshunœ, œ ɔ ga lœ ɔyɔ á ɨ'ɨrɨnœ kœdœ Sikomore, mbœrœ kœwu Yisu á tshe yi lima ndœ kœro tɔ kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lɔkɔ á Yisu wuta kpœtœ oshonœ asœmœ, tshe mesho ga lafo yé œ pa fœ she adœke: «Zakayo, jerœ ga atɨ katsha, mbœrœ kpesheke œ li adœke mœ lo ɓa sœnda nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Katsha Zakayo kœjerœ ga atɨ katsha yé œ za osho kœsœ fœ she dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kœwu tœnœ ataa, azu kɔ te lima tœ kœpulœma endje adœke: «Uzu asœ na kœlo ɓa ndœ ayi ngbɨndɨrœ!» ");
INSERT INTO kxf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kashe Zakayo na ga tshu Gbozu œ pa adœke: «Wu, Gbozu, mœ kurutshelœ œrœ nœ mœ kpekpeka, œ ko tshakalanœ fœ aayi oyo, yé œdœ mœ kœza lima œrœ nœ anga uzu dœ ɔgbɔ, mœ gi ga manda nœ fœ she awa vana.» ");
INSERT INTO kxf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yé Yisu kœgi fœ she adœke: «Kpœsheke, ɓœ she dœ azu tshasœnda nœ zœ ye, mbœrœ œɓœ kœdœ ndje anga ata Abrayamo. ");
INSERT INTO kxf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gbambanœ nene, Gbolo nœ uzu na ndœ kœpara œdœ kœza kœshe fœ azu á endje djingili.» ");
INSERT INTO kxf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɓata á azu sœ lima kœdji o'onœ asœmœ, Yisu kpa pa lœ ndœma toro asœ mbœrœ tshe sœ lima ndoo dœ Yerusaleme. Azu sœ lima kœgbe adœke Ogo gbozu nœ Ndjaba œ matœ ye pe kpœtœ œsœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ataa, Yisu kœpa adœke: «Anga uzu bale lœ mara nœ agbozu á œsœ endje lɨ, yi lima ndœ kœna ga lœ anga angbɨ ogo, mbœrœ azunœ ɓa zœ kœza œne tœ gbozu yekane á œne kœfatœ œne á kœgu á kœdœ gbozu tshapa ogo nœ œne. ");
INSERT INTO kxf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Utshu kœro she, tshe e anga aayi akwa nœ ye ndjokpa œ ko langere ngendja nœ ye ndjokpa fœ uzu dœ uzu yé œ pa fœ endje adœke: “'E kotœ 'e ɓishu dœ ngendjanœ œrrr ga tœ olo á mœ gu.” ");
INSERT INTO kxf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kashe azu ogo nœ ye sœ lima kœyiangba ye, yé œ vwa anga azu manda ye ndœ kœpa adœke: “'A yiyindœ nœ adœke tshe te gbozu tshapa 'a nene.” ");
INSERT INTO kxf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Andaa manda kœza akwa gbozugonœ fœ she, tshe gu œ e aayi akwa nœ ye á tshe ko lima ngendja fœ endje ndœ kœwusœ ngendja á uzu dœ uzu gbɔ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Uzu á tshe na utshunœ matœ ye œ pa adœke: “Gbozu, mœ gbɔ langere ngendja ndjokpa ga pa œneke á ɓœ ko lima fœ mœ.” ");
INSERT INTO kxf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tshe kœpa fœ she adœke: “Œ sœ dœ ɔtshɔnœ, œɓœ kœdœ ɔtshɔ ayi akwa, ɓata á ɓœ mbœrœtœ zœ lindœ nœ lœ aya akwa atake, mœ za ɓœ tœ gbozu tshapa ongbo ndjokpa.” ");
INSERT INTO kxf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bisha uzu na yé œ pa adœke: “Gbozu, mœ gbɔ langere ngendja mindu ga pa œneke á ɓœ ko lima fœ mœ.” ");
INSERT INTO kxf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tshe kœpa ndje fœ she adœke: “Mœ za ɓœ tœ gbozu ga pa ongbo mindu.” ");
INSERT INTO kxf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Anga kpa kœna yé œ kœpa adœke: “Gbozu, wu langere ngendja nœ zœ dœke, mœ guma lima sœ nœ ga lœ lœba. ");
INSERT INTO kxf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gbambanœ nene, awa zœ za lima mœ waa, mbœrœ ɓœ gbɔɔgbɔ: Ɓœ sœ kœko œrœ á dœ́dœ́ œnœ zœ nene, ɓœ sœ kœkɔ ele ngwarœ neke á dœ́dœ́ ɓœ dá lu nene.” ");
INSERT INTO kxf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tshe kœpa fœ she adœke: “Ekpe ayi akwa! Kolœ liaka o'o ama zœ, mœ wa ngbanga ga tœ zœ. Ɓœ wu lima sœ nœ adœke œmœ kœdœ uzu á mœ gbɔɔgbɔ, mœ ko œrœ neke á dœ́dœ́ œnœ mœ nene yé œ kɔ ele ngwarœ neke á œ dœ́dœ́ mœ dá lu nene. ");
INSERT INTO kxf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yé mbœrœ gaɗe á ɓœ zaza má ngendja nœ mœ ga lœ anda nœ kœgumasœ ngendja nene a? Atamœ á mœ kœgu má, á endje kœgi fœ mœ dœ anga œrœ ga pa nœ nene a?” ");
INSERT INTO kxf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Manda nœ, tshe kœpa fœ azu á endje sœ lima kpœmœ adœke: “'E za langere ngendja nœ ye tshakane ye, yé œ za fœ tsheneke á tshe sœ dœ tœnœ ndjokpa.” ");
INSERT INTO kxf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Endje pa fœ she adœke: “Gbozu, tshe sœ dœ anga langere ngendjanœ ndjokpa zœ!” ");
INSERT INTO kxf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tshe kœgi adœke: “Mœ sœ kœpa fœ 'e adœke, uzu kɔ á tshe sœ dœ œrœ, endje kpa to anganœ ga pa nœ fœ she kœrosœ nœ, kashe tsheneke á tshe gugu dœ œrœ nene, endje gbɔtœ œneke teasho á tshe sœ dœ tœnœ tshakane ye. ");
INSERT INTO kxf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tœ ayingba mœ, azu á endje yiyi lima ndœ nœ adœke mœ dœ gbozu tshapa endje nene, 'e na dœ endje ga mœ dœ́ œ wa ɔngɔrɔ endje kpœtshu mœ.”» ");
INSERT INTO kxf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Manda kœpu o'onœ asœmœ ataa, Yisu te utshunœ kœɔ ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lɔkɔ á tshe ndo dœ tshalakpɨ Betefaje œdœ Betani, ndoo dœ tshapa kaga á ɨ'ɨrɨnœ kœdœ kaga ɔyɔ Olive, tshe vwa ayambarœ bisha utshunœ, ");
INSERT INTO kxf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yé œ pa adœke: «'E ro ɓa lakpɨ á sœ ndjii utshu azœ asœke. Kœli 'e tshendja, 'e wu aya ane á endje du she kpœtœmœ yé á uzu bale ɔɔ damba ga pa ye nene, 'e vwara she œ gu dœ she ga mœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yé œdœ uzu kœyu 'e adœke: “Mbœrœ gaɗe á 'e vwara she a?” 'E gi fœ she adœke: “Gbozu dá gbe dœ she.”» ");
INSERT INTO kxf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aayi avwanœ na, œ wu ndje kolœ œrœnœ ɓata á Gbozu pandœ nœ fœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lɔkɔ á endje sœ kœvwara anenœ, ayengɔ ye yu endje adœke: «Mbœrœ gaɗe á 'e vwara anenœ asœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Endje gi adœke: «Gbozu dá gbe dœ she.» ");
INSERT INTO kxf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Endje gu dœ anenœ fœ Yisu, manda nœ endje ko yɔgbɔdɔ lœba nœ endje va ga pa ye, á za Yisu ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lɔkɔ á Yisu sœ ndœ kœro tœnœ, azu sœ lima kœsaka lœba nœ endje ga tœ ala awa. ");
INSERT INTO kxf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kœndo dœ awa á jerœ ga tœ kaga ɔyɔ Olive, ayambarœ nœ Yisu ndjoro sœ dœ yanga, œ tetœ kœdonga Ndjaba dœ avwara mbœrœ afá á Yisu mbœrœ á endje wu. ");
INSERT INTO kxf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Endje sœ lima kœpa adœke: «Kaka Ndjaba to kane ye ga pa gbozugo á tshe na dœ ɨ'ɨrɨ ye. Kaka kœsœ gee sœ ɓa lafo yé mokɔ nœ Ndjaba matœ ye ɓa zœ!» ");
INSERT INTO kxf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kashe anga Afarisayi á endje sœ lima ugurutœ ukpulu azunœ, pa fœ Yisu adœke: «Ayi kœyisœrœ, pa fœ ayambarœ nœ zœ adœke endje sœ koko!» ");
INSERT INTO kxf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yisu kœgi adœke: «Mœ sœ kœpa fœ 'e adœke: Œdœ endje kœsœ koko, badja œ ta rawa.» ");
INSERT INTO kxf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lɔkɔ á Yisu ndo dœ ongbonœ yé á wu, tshe kɨ mbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tshe pa lima adœke: «Uu Yerusaleme, œdœ ɓœ kœwu má sœ œrœ á na ndœ kœza kœsœ gee fœ ɓœ, œ sœ má dœ ɔtshɔnœ waa. Kashe ngɔngɔnœ asœke, œ zatœ ye yiwa tœnœ tœ ala zœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yé wusœ nœ adœke, bala mbatsha, ayingba zœ œ tɔ gbadjadja nœ endje dji ɓœ djikpata, œ kpakundœ zœ dje tœ osho kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Endje ndɨ tshalakpɨ nœ zœ, œ wo ɓœ œdœ agbolo nœ zœ para. Endje katœ anga badja bale tɨ ga pa anganœ nene, mbœrœ ɓœ wuwu lima sœ lɔkɔ á Ndjaba na ndœ kœtɨ kane zœ ga lafo nene.» ");
INSERT INTO kxf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Manda nœ, Yisu li ga lœ Tepelo, œ tetœ kœgɔrɔ azu á endje sœ lima kœka œrœ. ");
INSERT INTO kxf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tshe pa lima fœ endje adœke: «Endje sú ɓa la Buku nœ Ndjaba adœke: “Anda nœ mœ œ dœ bala anda nœ kœza avwala, kashe 'e fa tœ wutu nœ aayi angba.”» ");
INSERT INTO kxf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yisu sœ lima ɔlɔ dœ ɔlɔ kœyisœ œrœ ɓa lœ Tepelo. Agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa œdœ ndje pe agbozu tshapa azu sœ lima kœpara awa kœwo she. ");
INSERT INTO kxf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kashe endje gbɔgbɔ lima awa nene, gbambanœ nene, azu ndjoro za lima lɔsu endje djigi ndœ kœdji kolœ she. ");
INSERT INTO kxf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anga ɔlɔ bale, Yisu sœ lima kœyisœ œrœ fœ azu ɓa lœ Tepelo, œ sœ lima kœpandœ Ɔtshɔ O'o yé agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa œdœ pe agbozu Ikrizia yi kumu endje. ");
INSERT INTO kxf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Endje yu she adœke: «Pandœ nœ fœ 'a ka, tshagbozu nœ zœ to kpœta a? Œɗe ndje dá za gbɔgbɔ kœmbœrœ tœnœ fœ ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tshe gi fœ endje adœke: «Œmœ ndje, mœ yindœ kœyu 'e dœ anga o'o bale. 'E pandœ nœ fœ mœ ka: ");
INSERT INTO kxf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Batisimu á Yowane sœ lima kœza tœnœ, to ɓa lafo too ɓa ndœ azu?» ");
INSERT INTO kxf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Endje tetœ kœsharatœ endje lœ tœ endje adœke: «Œdœ a kœpa adœke: “Œ to ɓa lafo”, tshe pa adœke: “Mbœrœ gaɗe á a yiyi lima ndœ nœ fœ she nene a?” ");
INSERT INTO kxf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yé œdœ a kpa kœgi adœke: “Ɓa ndœ azu, azu para œ ve azœ dœ badja yé œ kœwo azœ mbœrœ endje wusœ nœ adœke Yowane kœdœ lima ayi kœgbara o'o.”» ");
INSERT INTO kxf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yeka á endje kœgi fœ she adœke: «'A wuwusœ uzu á tshe vwa lima she nene.» ");
INSERT INTO kxf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yé Yisu kœpa fœ endje adœke: «Œmœ ndje, mœ pandœ osho á tshagbozu nœ mœ to tœnœ fœ 'e nene.» ");
INSERT INTO kxf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Manda nœ, Yisu tetœ kœpa ndœma toro fœ azu adœke: «Anga uzu lu lima ɔyɔ vinu ga lœ kɨndɨ nœ ye, œ guma o'o ugurutœ ye dœ anga aayi akwa adœke endje djo tshelœ kɨndɨnœ yeka á œne kœkurutshelœ ele vinunœ dœ endje, yé œ na ana manda olo ndjoro. ");
INSERT INTO kxf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Olo kœkɔ ele vinunœ li, tshe vwa anga ayi akwa nœ ye ɓa ndœ endjeneke á endje sœ ɓa lœ kɨndɨ adœke endje vwa œnœ œne œsœ́ ele ɔyɔnœ fœ œne. Kashe aayi akwa ɓa lœ kɨndɨnœ za she œ ɓi she œrrr, œ gi she tshakane ye gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ayengɔ kɨndɨ kpa vwa anga angbɨ ayi akwa, endje kpa za she, œ ɓi she œrrr, œ gu she, yé œ kpa gi she tshakane ye gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tshe kpa vwa votɔ anga, endje to uku tœ ye yé œ vwi she ga shu. ");
INSERT INTO kxf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yekane á ayengɔ kɨndɨnœ kœpa adœke: “Gaɗe dá mœ kœmbœrœ a? Mœ vwa gbolo yakoshe nœ mœ á mœ yindœ ye waa, anganœ endje dji she dœ ɔtshɔnœ.” ");
INSERT INTO kxf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kashe, kœwu gbolo yakoshe nœ ye kœna tœnœ, aayi kœdjo tshelœ kɨndɨ vinunœ tetœ kœpalœtœ endje adœke: “E wu ayi kœsœpe dœ œrœ manda abanœ dá na asœ; a wo she yeka á kɨndɨnœ kœte œnœ azœ!” ");
INSERT INTO kxf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Endje wuta dœ she lœ kɨndɨnœ ga ushu yé œ wo she. «Ataa, ayengɔ kɨndɨnœ œ mbœrœ œrœ gaɗe tœ endje a? ");
INSERT INTO kxf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tshe na, œ wo aayi akwanœ para kɔkɔ, yé œ za akwa kɨndɨnœ fœ anga angbɨ aayi akwa.» Lɔkɔ á azu dji o'onœ ataa, endje pa adœke: «Œ̃ œ̃ nene, œ mbœrœtœ endje atamœ nene!» ");
INSERT INTO kxf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kashe Yisu mesho ga lœ ala endje, œ pa adœke: «O'o ala mbetinœ asœ yindœ kœpa adœ gaɗe: “Badja á aayi kœmɔ anda za vwi'i, œtœnœ dá te sharagunda?” ");
INSERT INTO kxf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Uzu kɔ á tshe te ga pa badjanœ asœmœ, tshe kɔ ngende ngende, yé tsheneke á badjanœ œ te ga pa ye, œ ndɨ tshelœ ye krœna ye.» ");
INSERT INTO kxf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aayi kœyisœ awa akwa dœ pe agbozu tshapa anganga Ndjaba para lima awa ndœ kœza she ga lœ kánga dœ ɔlɔnœ asœmœ, kashe awa azu dá za lima endje. Gbambanœ nene, endje wu lima sœ nœ adœke Yisu pa ndœma toronœ asœmœ fœ œne. ");
INSERT INTO kxf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yé endje tetœ kœvu Yisu. Endje vwa azu á endje sœ kœmatœ endje adœke endje kœdœ azu á endje sœ ndjii fœ she. Azunœ asœmœ sœ lima kœkate kœdji ekpe o'o lœ ama ye yeka á kœgbɔ awa nœ kœtɔ meza pa ye ɓa ndœ agbozu tshalakpɨ œdœ ɓa ndœ gbozugo. ");
INSERT INTO kxf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Endje yu she dœ o'o atake: «Ayi kœyisœrœ, 'a wusœ nœ adœke o'o á ɓœ sœ kœpa tœnœ yé á sœ kœyisœ nœ sœ dœ awanœ. Ɓœ sœsœ kœtondœ tshatshu azu nene yé ɓœ sœ kœyisœ awa Ndjaba fœ azu lindœ adjapu. ");
INSERT INTO kxf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pandœ nœ fœ 'a ka, 'a li kœyɔ lapo nœ Sezare ye a, too nene?» ");
INSERT INTO kxf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yisu wusœ ekpe gbetshelœ nœ endje lima, yé œ pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«'E ma anga langere ngendja bale fœ mœ kane. Tshatshu uzu ɗe œdœ ɨ'ɨrɨ ɗe dá endje sú ga alanœ a?» Endje gi adœke: «Œnœ Sezare.» ");
INSERT INTO kxf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tshe kœpa fœ endje adœke: «Tœnœ dœ mœ! 'E za œrœ nœ Sezare fœ Sezare, œnœ Ndjaba fœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Endje lili lima kœgbɔ she dœ ekperœ lœ o'onœ á tshe pa ɓa utshu azu kɔ asœmœ nene, kashe endje ka lima tœ ama endje tɨ ɔsɔ tœ o'o á tshe sœ lima kœgi tœnœ, yé œsœ endje yi lima taa. ");
INSERT INTO kxf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Anga Asadukayi na ga ndœ Yisu. Endje dá sœ kœpa adœke kœshe lœ akuzu gugu nene. Endje yu Yisu adœke: ");
INSERT INTO kxf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Ayi kœyisœrœ, Moyize su lima awa akwa fœ 'a adœke: “Œdœ uzu kœsœ dœ ayanœ á tshe za yashe á kœzuzu gbolo dœ she nene yé á tshu, œ li adœke ayanœ to yashe koyanœ mbœrœ kœmbœrœ angwa fœ ayanœ á tshe tshu asœmœ.” ");
INSERT INTO kxf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Andaa, anga aaya lœ yabo bale sœ lima mindu dœ bisha (7). Eyanœ to yashe, œ zuzu gbolo dœ she nene, yé œ tshu. ");
INSERT INTO kxf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bishanœ to yashe koyanœ yé œ tshu awa bale, ");
INSERT INTO kxf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","manda nœ, votɔnœ kpa to ndje she, œ tshu ye. Ko atamœ sœmœ œrrr endje mindu dœ bisha tshu para, anga bale zuzu gbolo dœ she nene. ");
INSERT INTO kxf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɓa tœ ndɔngɔlɔnœ, yashenœ tshu ndje ye. ");
INSERT INTO kxf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yé ataa, yashenœ asœmœ, lɔkɔ á akuzu œ kpa she, tshe dœ awo ɗe, mbœrœ endje mindu dœ bisha kɔ to lima she tœ awo endje yema a!» ");
INSERT INTO kxf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yisu kœpa fœ endje adœke: «Ɓa pa ɔshɔ asœ, ayashe dœ ayakoshe œ totœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kashe ayakoshe dœ pe ayashe á endje tshu, á Ndjaba wu adœke endje li kœshe lœ akuzu yé á li kœli ga lœ tafo ogo neke á na manda nœ, endje kpa totœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Endje kpa tshu nene; gbambanœ nene, endje sœ ɓata aandjelu. Endje kœdœ agbolo nœ Ndjaba mbœrœ á endje she lœ akuzu ye. ");
INSERT INTO kxf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyize pa lima ngbɨ adœke azu á endje tshu, endje she bala lœ kuzu. Gbambanœ nene, ala mbeti á pa o'o tœ upu nœ ɔyɔ á owo sœ lima kœtshi lœnœ, tshe e lima Gbozu adœke “Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Ndjaba nœ Yakobo.” ");
INSERT INTO kxf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ndjaba dœ́dœ́ Ndjaba nœ akuzu nene, kashe Ndjaba nœ asoro. Gbambanœ nene, azu kɔ sœ dœ soro mbœrœ she.» ");
INSERT INTO kxf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Anga aayi kœyisœ awa akwa za o'o œ pa adœke: «Ayi kœyisœrœ, ɓœ pa o'o nœ zœ dœ ɔtshɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gbambanœ nene, endje kpa gugu lima dœ awa ndœ kœyu anga o'o nene. ");
INSERT INTO kxf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yisu kœyu endje adœke: «Koto yeka á azu sœ kœpa adœke Masiya kœdœ gbolo nœ Davidi a? ");
INSERT INTO kxf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gbambanœ nene, Davidi dœ tœ ye pa ɓa la buku nœ Itshi nœ Ayuda adœke: “Gbozu Ndjaba pa fœ Gbozu nœ mœ adœke, sœ ga atɨ ga pa kuni mœ œrrr ");
INSERT INTO kxf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","adœke mœ fa ayingba zœ ga tshagudɨ ada zœ yekane.” ");
INSERT INTO kxf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Adja Davidi dœ tœ ye sœ kœ'e she Gbozu. Yé dœ mara gaɗe dá Masiya kpa fa gbolo nœ Davidi a?» ");
INSERT INTO kxf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yisu kœpa fœ ayambarœ nœ ye tœ ala azu kɔ á endje sœ lima kœdji she adœke: ");
INSERT INTO kxf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ala 'e gbɔ dœ aayi kœyisœ awa akwa á endje sœ kœro dœ yɔgbɔdɔ lœba tœ endje, á endje sœ kœyindœ nœ adœke azu sœ kœbala œne tœ osho á ukpulu azu sœ tœnœ. Endje yi kolœ ndœ kœsœ ga tœ osho á sœ utshunœ lœ Sinagoga dœ pe osho kœsœ nœ agbozu azu lœ angbo. ");
INSERT INTO kxf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Endje sœ kœbɨlɨ ayashe koya mbœrœ kœyi angwa œrœ tœ endje. Yé œdœ endje kœsœ kœza avwala fœ Ndjaba, œndœ endje œ dɨ œrrr tœ kœma adœke œne kœdœ ɔtshɔ azu. Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ endje.» ");
INSERT INTO kxf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu mesho œ wu aayi kœgbɔrœ á endje sœ lima kœko ngendja nœ endje ga lœ gbarœ makabo ɓa lœ Tepelo. ");
INSERT INTO kxf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tshe wu ndje anga yashe koya á tshe dœ ayi oyo, kœko ndje a'eara langere ngendja nœ ye bisha ga zœ. ");
INSERT INTO kxf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yé Yisu kœpa adœke: «Adja mœ sœ kœpa fœ 'e adœke, yashe koyanœ asœ á tshe dœ ayi oyo dá ko ngendja nœ ye kœropa azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gbambanœ nene, ngendja á endje ko asœ, endje sœsœ dœ œrœ kœmbœrœ dœ tœnœ nene, kashe œshe, tshe ko ngendja nœ ye kɔ á sœ má adœke tshe zɨ dœ œrœ.» ");
INSERT INTO kxf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anga azu sœ lima kœpa o'o tœ upu nœ Tepelo, yé œ sœ lima kœpa adœke œ ga waa dœ mara á endje mbœrœ dœ ɔtshɔ badja dœ pe œrœ á azu to fœ Ndjaba. Kashe Yisu pa adœke: ");
INSERT INTO kxf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Lœ olo manda nœ, œrœnœ kɔ á 'e wu asœmœ, anga badja bale á kpa sœpe ga pa anganœ œ gu nene. Endje ndɨ tshelœnœ para kɔkɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yé endje yu she adœke: «Ayi kœyisœrœ, lɔkɔ gaɗe dá œrœnœ asœmœ œ wuta ndje a, ambárá gaɗe dá matœ endje ɔlɔ á œrœnœ œ mbœrœtœ endje a?» ");
INSERT INTO kxf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yisu gi adœke: «Ala 'e gbɔ, uzu bale fafara 'e nene. Gbambanœ nene, azu ndjoro œ na bala dœ ɨ'ɨrɨ mœ yé œ pa adœke: “Œmœ kœdœ Masiya”, yé lɔkɔnœ li ye! Kashe 'e tete manda endje nene. ");
INSERT INTO kxf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɔlɔ á 'e kœsœ kœdji o'o nœ kœtɔ kowo œdœ azu á endje sœ kœoma dœ anga endje, awa zaza 'e nene. Gbambanœ nene, œ li adœke œrœ ataa wuta utshunœ yeka, kashe œ dœ́dœ́ damba kœka tshapashɔnœ ngɔngɔnœ asœ dœmœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yé tshe kpa pa fœ endje adœke: «Ogo gbozu dœ ogo gbozu œdœ pe ogo dœ ogo œ tɔ kowo lœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɔshɔ œ turu tœ osho kɔ, yé ekpe koɓa œdœ egerœ ogo œ za osho kɔ. Œrœ á za awa tœ azu œdœ ambárá afá œ matœ endje ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Kashe utshu œrœnœ asœke kɔ, endje ɓi 'e œ mbœrœ œrœ kanga fœ 'e, endje tɔ meza pa 'e ɓa lœ Sinagoga, endje ko 'e va ga lœ anda kánga, endje gbota 'e na tœnœ ɓa utshu agbozugo dœ pe agboro agbozu mangba ɨ'ɨrɨ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mara œrœ ataa œ za awa fœ 'e ndœ kœma o'o tœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Atamœ, 'e tɔtɔ lɔsu 'e tœ mara á 'e pa dœ ngbanga nene. ");
INSERT INTO kxf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gbambanœ nene, mœ to o'o œdœ kœwusœtœ ga lœ 'e dœ mara adœke, anga ayingba 'e bale á tshe li tœ kœshara o'onœ lœ ama 'e too kœvwaratœ ye tœnœ œ gu nene. ");
INSERT INTO kxf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aaba 'e œdœ aayi 'e, aaya 'e, aayo 'e œdœ anga 'e œ vaɔtɔ 'e, œ wo ndje anga anga 'e ugurutœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Azu kɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ, ");
INSERT INTO kxf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kashe anga sukumu 'e bale œ yiwa nene. ");
INSERT INTO kxf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'E shi gbɨ lœ kœyindœrœ nœ 'e yeka á kœgbɔ soro neke á ka nene.» ");
INSERT INTO kxf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Lɔkɔ á 'e kœwu adœke aturugu kpa dji ongbo Yerusaleme djikpata, 'e wusœ nœ adœke olo kœndɨ tshelœ ongbonœ ndo ye. ");
INSERT INTO kxf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Atamœ, azu á endje sœ ɓa lœ ogo Yuda œ kpa ga pa kaga, endjeneke á endje sœ ɓa lœ ongbo Yerusaleme œ wuta ga shu. Azu á endje sœ ɓa lœ kɨndɨ, endje kpa gu ga lœ ongbo nene! ");
INSERT INTO kxf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gbambanœ nene, ɔlɔnœ asœmœ œ dœ ɔlɔ kœtɔ geda, yekane œneke á endje pa ala Buku nœ Ndjaba kœmbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Dœ ɔlɔnœ asœmœ, oyo œ sœ mbœrœ ayashe má endje sœ dœ nguzu dœ pe endjeneke á endje sœ kœza ɔngɔ ga lœ ama agbolo. Gbambanœ nene, azu tshelœ ogonœ asœmœ œ wu egerœ oyo, yé Ndjaba œ ma ókó nœ ye ga tœ azu. ");
INSERT INTO kxf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Anga azu œ tshu kuzu nœ ɨngɨrɨ yakamba, endje ko anga endje gu tœnœ tœ kœfa endje tœ akanga dje lœ angbɨ ogo kɔ. Angbɨ azu œ ndɨ tshalakpɨ Yerusaleme kpakpakpa œrrr adœke olo nœ endje ka yekane.» ");
INSERT INTO kxf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ambárá œrœ œ matœ endje ɓa la ɔlɔ, ɓa la yapu œdœ ɓa la angerepe. Yé ɓa pa ɔshɔ, azu lœ angbɨ ogo para œ sœ dœ awa, tshama ungu kota dœ lokonœ œ za ndje awa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Azu œ tshu dœ awa lɔkɔ á endje gbe dœ œrœ á mbœrœ bala tœ endje pa ɔshɔ kɔ, mbœrœ gbɔgbɔ nœ tshalafo œ turu. ");
INSERT INTO kxf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dœ tœnœ ataa, endje wu Gbolo nœ uzu á tshe kwa lœ ondoro dœ gbɔgbɔ kɔ œdœ lœ mokɔ. ");
INSERT INTO kxf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lɔkɔ á œrœ ata kœtetœ kœmbœrœtœ nœ, 'e shi gbɨ yé œ kpa sœ dœ gbɔgbɔ mbœrœ olo nœ kœwuta 'e lœ ekperœ ndo ye.» ");
INSERT INTO kxf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Manda nœ, Yisu pa ndœma toro fœ endje adœke: «'E wu ɔyɔ fige asœ dœ pe anga ɔyɔ para: ");
INSERT INTO kxf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lɔkɔ á 'e kœwu adœke kakonœ tetœ kœtɔ tœnœ, 'e wusœ nœ adœke olo ungu yavuru ndo ye. ");
INSERT INTO kxf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Awa bale ndje, ɔlɔ á 'e kœsœ kœwu œrœ ata kœwuta tœnœ, 'e wusœ nœ adœke Ogo gbozu nœ Ndjaba ndo ye. ");
INSERT INTO kxf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Dœ adjapu, mœ sœ kœpa fœ 'e adœke azu nœ tshakpesheke œ ka kɔ nene, yeka á œrœ asœke œ mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tshalafo dœ tshapa ɔshɔ œ ro ye, kashe o'o ama mœ œ ro nene.» ");
INSERT INTO kxf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ala 'e gbɔ, 'e ndɨndɨ lɔsu 'e dœ upu nœ kœmbœrœ angbo, dœ kœndjo ipi œrrr adœke œ mbœrœ 'e too mbœrœ oyo nœ tshapashɔ asœ nene, adœke olonœ asœmœ kœwuwuta ga tœ 'e ngbangi ");
INSERT INTO kxf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ɓata úkú dá endje gɨ nene. Gbambanœ nene, œ wuta ga tœ azu tshapashɔ para. ");
INSERT INTO kxf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kashe ala 'e gbɔ, 'e za avwala ɔlɔ dœ ɔlɔ mbœrœ á kœsœ dœ gbɔgbɔ nœ kœwuta lœ œrœnœ kɔ á na bala, yeka á 'e kœli kœka ga utshu Gbolo nœ uzu.» ");
INSERT INTO kxf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dœ ɔlɔ, Yisu sœ lima kœyisœ œrœ ɓa lœ Tepelo, kashe dœ butshɔ, tshe na kœlo ɓa pa kaga á ɨ'ɨrɨnœ kœdœ kaga ɔyɔ Olive. ");
INSERT INTO kxf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yeka á dœ amazɨ, á azu œ na ga ndœ ye ɓa lœ Tepelo mbœrœ kœdji she. ");
INSERT INTO kxf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Egerœ angbo nœ kœzɨ mapa á susuku nene á endje e ɨ'ɨrɨnœ Pake asœmœ, ndo lima ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Agbozu tshapa anganga Ndjaba dœ pe aayi kœyisœ awa akwa sœ lima kœpara awa ndœ kœwo Yisu, kashe endje sœ lima kœkpa awa azu. ");
INSERT INTO kxf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yé Satana li lima ga tœ lɔsu Yudasi Isikariote, á tshe kœdœ lima bale lœ andjokpa dœ bishanœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tshe na ndœ kœvwarandœ o'o dœ agbozu tshapa anganga Ndjaba dœ pe agbozu tshapa aayi kœgbɔndœ Tepelonœ, yé œ pa o'o dœ endje pa mara kœza Yisu yɔ œrœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Endje sœ dœ yanga yé œ pa fœ she adœke œne ko ngendja fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasi yindœ nœ yé œ tetœ kœpara awa á sœ tœ ɔtshɔnœ mbœrœ kœza she yaa fœ endje adœke azu kœwuwusœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lɔkɔ angbo nœ mapa á susuku nene ndo, yé œ li adœke endje wo aaya apata á kœzɨ pa angbonœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yisu kœvwa Apetro dœ Yowane adœke: «'E na dœ́ œ fa kœzɨrœ Pakenœ fœ azœ, yeka á a kœzɨ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yé endje kœyu Yisu adœke: «Ɓœ yindœ nœ adœke 'a na kœfa kœzɨrœnœ ɓata a?» ");
INSERT INTO kxf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Á tshe kœgi fœ endje adœke: «Kœli 'e ga lœ ongbonœ, 'e togba dœ anga yakoshe dœ lɔsú ungu lœ kumu ye. 'E te manda ye gu tœnœ ga tœ anda á tshe li, ");
INSERT INTO kxf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yé 'e pa fœ ayengɔ andanœ adœke: “Ayi kœyisœrœ yu ɓœ adœke osho á œne zɨ kœzɨrœ angbo Pake dœ ayambarœ nœ œne sœ kpœta a?” ");
INSERT INTO kxf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yé tshe yisœ anga gbɔshɔ ɓa lafo, á endje guma dœ œrœ kɔ lœnœ; 'e fa kœzɨrœ angbonœ kpœtœmœ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Endje na œ gbɔ œrœ kɔ ɓata á tshe pa má tœnœ fœ endje, yé œ fa kœzɨrœ Pakenœ kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lɔndɔ á ada ɔlɔ kœzɨrœ li ye, Yisu sœ ga ɨndɨrɨ ndaba kœzɨrœ awa bale dœ aayi avwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yé tshe kœpa fœ endje adœke: «Adja mœ yindœ kœzɨ Pake asœ dœ 'e utshu kœwu oyo nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gbambanœ nene, mœ sœ kœpa fœ 'e adœke, mœ kpa zɨ anganœ nene œrrr ga tœ ɔlɔ á mbœrœ bala tœ endje ɓa lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yé tshe za kopo, œ donga Ndjaba yé á pa adœke: «'E za œ su tshelœnœ tœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gbambanœ nene, mœ sœ kœpa fœ 'e ataa: Mœ kpa ndjo vinu nene œrrr ga tœ lɔkɔ á Ogo gbozu nœ Ndjaba œ ma bala tœ endje.» ");
INSERT INTO kxf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Manda nœ, tshe kœza mapa œ donga Ndjaba, œ kavwa tshelœnœ yé œ kœkurutshelœ nœ tœ endje dœ kœpa adœke: «Asœ kœdœ undu mœ dá mœ to fœ 'e asœ. 'E mbœrœ ataa á kœgbe bala dœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kolœnœ ataa, tshe za kopo manda kœzɨrœ, á pa adœke: «Yashi asœ kœdœ tafo ayo lœ indji mœ á tu mbœrœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kashe 'e wu kane: Kane uzu á tshe sœ kœza mœ yɔ œrœ, za kœzɨrœ pa ndaba awa bale dœ mœ kpœke. ");
INSERT INTO kxf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gbambanœ nene, Gbolo nœ uzu œ gu ɓata á Ndjaba pa lima tœnœ. Kashe oyo nœ uzu á tshe za she yɔ œrœ! ");
INSERT INTO kxf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yé endje tetœ kœyutœ endje lœ tœ endje adœke uzu ɗe ugurutœ endje dá yindœ kœmbœrœ œrœ ataa. ");
INSERT INTO kxf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Endje tetœ kœgbugburutshelœ o'o lœ tœ endje mbœrœ kœwusœ uzu á tshe ropa anganœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yisu kœpa fœ endje adœke: «Agbozugo tshapa angbɨ ogo sœ kœmbœrœ akwa nœ endje dœ gbɔgbɔ, yé endjeneke á endje sœ kœgbɔndœ ogo yi ɓalima ndœ nœ adœke azu e œne “ɔtshɔ azu”. ");
INSERT INTO kxf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tœ 'e, 'e mbœmbœrœ œnœ 'e ata nene, kashe œ li adœke tsheneke ugurutœ 'e á tshe ropa 'e, tshe sœ ɓata rodonga, yé œ li adœke tsheneke á tshe sœ tœ gbozu, tshe sœ ɓata ayi akwa. ");
INSERT INTO kxf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yé ataa, œɗe dá ropa anganœ a? Uzu neke á tshe sœ pa ndaba too tsheneke á tshe sœ kœko kœzɨrœ fœ azu a? Œ dœ́dœ́ uzu á tshe sœ pa ndaba nene a? Kashe tœ mœ, mœ sœ ugurutœ 'e ɓata uzu kœmbœrœ akwa fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«E'e kœdœ azu á 'e kaka lima tœ mœ tɨ nene lɔkɔ á mœ li lima ga lœ kœwu lɔsu. ");
INSERT INTO kxf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yé œmœ, mœ za akwa ogo gbozu fœ 'e ɓata á Aba mœ za ndje lima fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ataa, 'e zɨ bala œrœ œ ndjorœ pa ndaba dœ mœ awa bale ɓa lœ Ogo gbozu nœ mœ, yé 'e sœ ndje bala ga pa ngande tshagbozu mbœrœ kœwa ngbanga nœ mara ndjokpa dœ bisha lœ ogo Israyele.» ");
INSERT INTO kxf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gbozu pa fœ Shimu adœke: «Shimu, Shimu, Satana esho ndœ gbɔgbɔ adœke œne pe tshelœ 'e ɓata á endje pe tshelœ indji ble. ");
INSERT INTO kxf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kashe œmœ, mœ za avwala tœ upu nœ zœ mbœrœ adœke kœyindœrœ nœ zœ kœ kaka nene. Yé œɓœ, lɔkɔ á ɓœ kœkwatœ zœ, ɓœ to gbɔgbɔ fœ aaya zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro pa fœ she adœke: «Gbozu, œdœ lœ kánga œdœ lœ kuzu, mœ yindœ nœ adœke mœ li, too mœ tshu dœ ɓœ awa bale.» ");
INSERT INTO kxf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yisu gi adœke: «Mœ sœ kœpa fœ ɓœ ngbɨ, Petro, utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ adœke ɓœ wuwusœ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yé tshe kœpa fœ endje adœke: «Lɔkɔ á mœ vwa lima 'e, œdœ ngendja, œdœ ngbade, œdœ œrœ ada, 'e zaza lima œrœ bale nene. Atamœ 'e sœsœ lima dœ œrœ nene a?» Endje gi adœke: «'A sœ lima dœ œrœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tshe pa fœ endje adœke: «Kashe ngɔngɔ asœ, uzu á tshe kœsœ dœ ngendja, tshe za; awa bale ndje mbœrœ uzu á tshe sœ dœ ngbade. Yé tsheneke á tshe gugu dœ ɨngɨrɨ yakamba nene, tshe ka yɔgbɔdɔ lœba nœ ye dœ́ œ yɔ dœ anganœ bale. ");
INSERT INTO kxf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gbambanœ nene, mœ sœ kœpa ngbɨ fœ 'e, œ li adœke o'o á endje sú ɓala buku nœ Ndjaba mbœrœtœ endje ga tœ mœ liakanœ: Endje dɨ she ga ugurutœ aayi kœmbœrœ ngbɨndɨrœ. Dœ tœnœ ataa, o'o á endje pa lima tœ upu nœ mœ, œ mbœrœtœ endje ye.» ");
INSERT INTO kxf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Endje kœpa adœke: «Gbozu, ɨngɨrɨ yakamba bisha dœke». Tshe kœgi fœ endje adœke: «Œ li ye». ");
INSERT INTO kxf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisu wuta œ ro ga pa kaga ɔyɔ Olive ɓata á tshe ro ɓa lima, yé ayambarœ nœ ye na manda ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lɔndɔ á tshe yi kumu ye ɓa zœ, tshe pa fœ endje adœke: «'E za avwala nœ 'e fœ Ndjaba adœke 'e kœlili ga lœ kœbɨlɨ osho nœ Satana nene.» ");
INSERT INTO kxf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Manda nœ, tshe gitœ ye zara tœ endje, œ gote dœ koda ye yé œ tetœ kœza avwala fœ Ndjaba adœke: ");
INSERT INTO kxf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Aba, œdœ ɓœ kœyindœ nœ, ɓœ mbœrœ adœke yashi oyonœ asœke gitœ ye utshu mœ ye. Mbœmbœrœ œrœ á mœ yindœ nœ nene, kashe mbœrœ œrœ á ɓœ yindœ nœ.»  ");
INSERT INTO kxf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ataa, anga andjelu to ɓa lafo œ wuta ga ndœ ye mbœrœ kœto gbɔgbɔ fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lɔsu ye su lima dœ oyo, tshe kpa za avwala ga pa nœ ga pa nœ fœ Ndjaba, yé ɨlɨ sara tœ ye tea tea ga tœ ɔshɔ ɓata indji. ");
INSERT INTO kxf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Manda kœza avwalanœ, Yisu áalafo œ gu ga ndœ ayambarœ nœ ye œ gbɔ endje, endje mɔ œ lo ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tshe pa fœ endje adœke: «Koto o! 'E lo ye a? 'E áalafo yé œ za avwala fœ Ndjaba adœke 'e lili ga lœ kœwu lɔsu nœ Satana nene.» ");
INSERT INTO kxf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tshe sœpe damba kœpa o'o trale atake, ukpulu azu kœyi kumu endje. Anga bale ugurutœ andjokpa dœ bishanœ asœmœ á ɨ'ɨrɨ ye kœdœ lima Yudasi, te utshu endje. Tshe na ndoo dœ Yisu ndœ kœbala she dœ kœuru tshelœ utu ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kashe Yisu pa fœ she adœke: «Yudasi, ɓœ za Gbolo nœ uzu fœ angbɨ azu lœ awa nœ kœuru tshelœ utu ye a?» ");
INSERT INTO kxf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lɔkɔ á azu á endje ro tœ awanœ dœ Yisu wu lima œrœ á yindœ kœmbœrœtœ endje, endje yu she adœke: «Gbozu, 'a nga koshe dœ endje dœ ɨngɨrɨ yakamba a?» ");
INSERT INTO kxf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yé anga bale ugurutœ endje gbota ɨngɨrɨ yakamba nœ ye, œ de ayi akwa nœ egerœ nganga Ndjaba, á wa utu ye dja ga pa kuni ndja tœnœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kashe Yisu pa adœke: «'E katœ nœ dœ́ endje mbœrœ œrœ á endje yindœ nœ.» Á za utu ye tɔ ga ngbanœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Manda nœ, Yisu pa fœ azu á endje na lima kœza she, agbozu tshapa anganga Ndjaba, agbozu tshapa azu á endje gbɔndœ Tepelo dœ pe agbozu Ikrizia ayuda adœke: «'E na dœ ɨngɨrɨ yakamba dœ pe ndɨndɨ ɔyɔ ndœ mœ ɓata œmœ kœdœ ayi angba a? ");
INSERT INTO kxf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ɔlɔ dœ ɔlɔ á mœ sœ lima dœ 'e lœ Tepelo, 'e tuturutœ mœ nene. Kashe ngɔngɔ asœke kœdœ olo nœ 'e œdœ gbɔgbɔ akwa nœ aayi butshɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Endje za Yisu, œ gu dœ she ɓa lœ anda nœ egerœ nganga Ndjaba. Petro sœ lima kœna manda endje lœ ɨngɨrɨnœ. ");
INSERT INTO kxf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɓata á endje ngbɔ lima egerœ owo ga lœ gbagba á ngbɔtœ endje ga ɨndɨrɨnœ, Petro na œ sœ ga ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Anga yashe akwanœ bale wu she kœsœ ga ɨndɨrɨ owonœ, tshe shokɔ she yé œ pa adœke: «Uzu asœ ɓa e sœ ndje lima dœ she awa bale.» ");
INSERT INTO kxf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kashe Petro 'eatœ ye, œ pa adœke: «Yashe, mœ wuwusœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Teasho manda nœ, anga uzu kpa wu she, œ pa adœke: «Œɓœ ndje kœdœ uzu nœ endje.» Petro gi adœke: «Œ̃œ̃, œ dœ́dœ́ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ga pa œrœ nœ́ ada ɔlɔ bale manda nœ, anga uzu kpa shi kɔɗɔɔ dœ o'onœ adœke: «Adja upu, uzu asœ ɓa e sœ lima dœ she awa bale; ga panœ dœmœ, œshe kœdœ uzu Galilayi.» ");
INSERT INTO kxf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petro kœgi adœke: «Mœ wuwusœ o'o á ɓœ yindœ kœpa tœnœ asœmœ nene.» Petœ œsœnœ á tshe sœ lima pe kœpa o'o lœma ye, trale kɔngato kœkɨ. ");
INSERT INTO kxf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gbozu fatœ ye œ tondœ Petro, yé Petro kœgbe dœ o'o á Gbozu pa lima fœ she adœke: «Utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petro wuta yé œ tetœ ɨkɨ tshuru tshuru tshuru. ");
INSERT INTO kxf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ayakoshe á endje sœ lima kœsœ ɨndɨrɨ Yisu, tetœ kœmɔ she dœ pe kœɓi she. ");
INSERT INTO kxf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Endje i tshatshu ye ga tœnœ dœ lœba á sœ kœyu she adœke: «Ma adœke œɓœ kœdœ ayi kœgbara o'o! Uzu ɗe dá ɓi ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yé endje sœ ndje lima kœgu she dœ ekpe o'o waa. ");
INSERT INTO kxf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lɔkɔ á osho kɔrɔ, agbɔ Ayuda, agbozu tshapa anganga Ndjaba œdœ aayi kœyisœ awa akwa ngbɔtœ endje ga tœnœ, yé œ na dœ Yisu ɓa tœ egerœ angbɔtœ kœwa ngbanga nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Endje pa fœ she adœke: «Œdœ ɓœ kœdœ Masiya, pandœ nœ fœ 'a.» Yisu gi fœ endje adœke: «Œdœ mœ kœpandœ nœ fœ 'e, 'e yindœ nœ ga ndœ mœ nene; ");
INSERT INTO kxf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","yé œdœ mœ kœyu 'o, 'e gi o'o fœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kashe ngɔngɔ asœ, Gbolo nœ uzu œ sœ ga tœ kuni Ndjaba nœ gbɔgbɔ.» ");
INSERT INTO kxf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Endje para kɔkɔ yu adœke: «Œɓœ kœdœ Gbolo nœ Ndjaba a?» Tshe kœgi fœ endje adœke: «E'e dœ tœ 'e 'e sœ kœpa tœnœ adœke, œmœ kœdœ Gbolo nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Endje kœpa adœke: «Ádá kœgbe dœ anga timu kpa gugu nene! Gbambanœ nene, azœ dœ tœ azœ a dji o'onœ lœ adja ama ye dœ tœ ye!» ");
INSERT INTO kxf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Azu para á endje sœ lima tœ œsœ egerœ angbɔtœnœ áalafo yé œ na dœ she ɓa utshu Pilato. ");
INSERT INTO kxf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Endje tetœ kœtɔ meza pa ye dœ o'onœ adœke: «'A gbɔ yakoshe asœ, tshe sœ kœdjingili tshelœ kumu azu ogo nœ azœ: Tshe sœ kœpakata azu ndœ kœyɔ lapo nœ Sezare, tshe sœ kœpa adœke œne kœdœ Masiya, œne ndje kœdœ gbozugo.» ");
INSERT INTO kxf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kœyu she adœke: «Œɓœ kœdœ gbozugo nœ Ayudanœ a?» Yisu kœgi fœ she adœke: «Œɓœ dá sœ kœpa ataa.» ");
INSERT INTO kxf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato pa fœ agbozu tshapa anganga Ndjaba dœ pe ukpulu azunœ á endje na lima adœke: «Mœ wuwusœ anga o'o á li adœke mœ wa ɔgbɔ ngbanga ga tœ yakoshe asœ liaka nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kashe endje shi kɔɗɔɔ adœke: «Tshe sœ kœdjingili tshelœ kumu azu dœ kœyisœ œrœ adœke azu oma lakpɨ. Tshe tetœ nœ lœ ogo Galilayi, lœ ogo Yuda œrrr á wuta dœ tœnœ ɓa ke asœke.» ");
INSERT INTO kxf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Manda kœdji endje, Pilato kœyu endje adœke: «Yakoshe asœ kœdœ uzu Galilayi a?» ");
INSERT INTO kxf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yé endje yindœ nœ ngbɨ adœke œshe kœdœ uzu Galilayi. Kœdji adœke Yisu kœdœ uzu ogo á Erode kœdœ gbozunœ, tshe vwa she ga ndœ Erode, mbœrœ lœ olo asœmœ tshe na lima kpœmœ ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kœwu Yisu atake, Erode sœ dœ yanga tɔpanœ kpuru. Gbambanœ nene, tshe sœ lima kolœ kœdjindœ œtrœ ye, yé œ sœ dœ ogo kœwu she. Tshe sœ lima kœgbe adœke Yisu œ mbœrœ anga afá dœ ala œne zœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tshe yu she dœ o'o ga pa nœ ga pa nœ, kashe Yisu gigi 'o bale fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Agbozu tshapa anganga Ndjaba dœ pe aayi kœyisœ awa akwa sœ lima kœtɔ meza pa ye dœ agbɔ. ");
INSERT INTO kxf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erode dœ pe aturugu nœ ye te lima tœ kœmɔ Yisu, œ sœ lima kœgu œsœ ye. Endje verœ ɔtshɔ lœba á ga waa ga tœ ye, yé œ gi she fœ Pilato. ");
INSERT INTO kxf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pe dœ ɔlɔnœ asœmœ, Erode œdœ Pilato á endje sœ lima kœyiangbatœ endje utshunœ, tetœ kœyindœtœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kpa e agbozu tshapa anganga Ndjaba, agbozugo dœ pe azu ogo kɔ, ");
INSERT INTO kxf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yé á kœpa fœ endje adœke: «'E na dœ yakoshe asœ fœ mœ ɓata uzu á tshe sœ kœdjingili tshelœ kumu azu tœ awa á sœ ndjii, kashe œmœ á mœ yu she utshu 'e, mœ gbɔgbɔ anga œrœ á li adœke mœ wa ɔgbɔ ngbanga ga tœ ye liakanœ ugurutœ o'o á 'e tɔ meza pa ye ndœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Gbozu Erode gbɔgbɔ ndje she dœ ekpe 'o nene, yeka á gi she fœ azœ gamœ asœke. Mbœrœ tœnœ ataa, anga œrœ á tshe mbœrœ á li dœ kuzu gugu bale nene. ");
INSERT INTO kxf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ataa, mœ sɔ kolœ she dœ ndjapa, œ za awa fœ she ye.»  ");
INSERT INTO kxf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lɔkɔ angbo nœ Pake bale dœ bale, Pilato sœ ɓalima kœvwara anga uzu bale lœ anda kánga. ");
INSERT INTO kxf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Endje tetœ kœtarawa para kɔkɔ adœke: «Wo uzunœ asœmœ ye! Œ katœ Barabase fœ 'a!» ");
INSERT INTO kxf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Endje za lima Barabase ga lœ anda kánga mbœrœ anga kœoma dœ o'o á wuta lima lœ ongbo, á tshe wo lima uzu lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kpa yu ndje dœ gbetshelœ adœke œne katœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kashe endje tara rawa adœke: «Tshe tshu pa kurushi, tshe tshu pa kurushi!» ");
INSERT INTO kxf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tœ votɔnœ, tshe kœpa fœ endje adœke: «Ekperœ gaɗe á yakoshe asœ mbœrœ a? Mœ gbɔgbɔ anga œrœ bale á tshe mbœrœ á li adœke tshe tshu nene. Mœ yindœ kœɓi kolœ she, yé œ za awa fœ she.» ");
INSERT INTO kxf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kashe endje sœ kolœ kœta rawa dœ agbɔ adœke tshe tshu pa kurushi, yé rawa nœ endje sœ kolœ kœgerœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yé Pilato kœwa ɓata á endje yɔndœ nœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tshe kœkatœ uzu á tshe za she vwi ga lœ anda kánga mbœrœ kœoma dœ 'o œdœ mbœrœ kœwo uzu, yé á endje sœ lima kœyɔndœ ye. Kashe tshe pa adœke endje mbœrœ dœ Yisu ɓata á endje yindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ɓata á aturugu sœ lima kœna dœ Yisu, endje togba dœ anga uzu bale á ɨ'ɨrɨ ye kœdœ Shimu, uzu tshalakpɨ Sirene. Tshe to lima ɓa lœ kɨndɨ á sœ kœgu tœnœ yé endje za she dœ ɔgbɔ, œ za kurushinœ ga pa kanga ye adœke tshe za manda Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ukpulu azu yaba yaba sœ lima kœna manda ye. Endje ngbɔ lima dœ anga ayashe á endje sœ lima kœda okoro endje, á sœ lima kœdɨtshelœama endje tœ upu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yisu kœfatœ ye ga ndœ endje á kœpa fœ endje adœke: «Ayashe Yerusaleme, 'e kɨkɨ mœ nene! Kashe 'e kɨtœ 'e dœ tœ 'e dœ pe agbolo nœ 'e! ");
INSERT INTO kxf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gbambanœ nene, lɔkɔnœ ndo á endje pa adœke: “Yanga nœ ayashe mara, dœ endjeneke á endje zuzu damba nene, dœ endjeneke á endje zaza damba ɔngɔ ga lœ ama agbolo nene asœmœ!” ");
INSERT INTO kxf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Azu œ tetœ kœpa fœ kaga adœke: “Te ga pa 'a” yé œ pa fœ koto adœke: “Ko 'a yiwa tœnœ!” ");
INSERT INTO kxf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gbambanœ nene, œdœ endje kœmbœrœ atake ga tœ tungboyu ɔyɔ, endje mbœrœ kotoo tœ ɔɔrɔ ɔyɔ a?» ");
INSERT INTO kxf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Endje na ndje lima dœ anga aayi ngbɨndɨrœ bisha adœke endje wo endje awa bale dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kœwuta endje ga tœ osho má endje e tœnœ adœke: «Gbayashi kɔrɔ», endje kuru Yisu ga pa kurushi dœ pe aayi ngbɨndɨrœ asœmœ bisha, anga ga pa kuni anga ga pa gele. ");
INSERT INTO kxf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yé Yisu pa adœke: «Aba, djerœndœ ekperœ nœ endje gbambanœ nene, endje wuwusœ œrœ á endje sœ kœmbœrœ tœnœ nene.» Yé endje ta wuka pa lœba nœ Yisu, œ kurutshelœ nœ tœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Azu ndjoro ka lima ɓa zœ yé œ sœ kœwu tœnœ. Agbozu ayudanœ tetœ kœmɔ she, œ pa adœke: «Tshe she lima anga azu. Œdœ tshe kœdœ adja Masiya á Ndjaba ke she asœmœ, kaka tshe shetœ ye dœ tœ ye!» ");
INSERT INTO kxf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aturugu mɔ ndje lima she. Endje na lima ndoo dœ she, œ za ikpi vinu fœ she, ");
INSERT INTO kxf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yé œ pa adœke: «Œdœ ɓœ kœdœ gbozugo nœ Ayuda, shetœ zœ dœ tœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Endje su ndje lima mbeti á ɓi ga tœ kumu kurushinœ adœke: «Uzunœ asœke kœdœ gbozugo nœ Ayuda.» ");
INSERT INTO kxf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anga ayi ngbɨndɨrœnœ bale á endje kuru she ga pa kurushi tetœ kœgu she, œ pa adœke: «Œ dœ́dœ́ ɓœ kœdœ Masiya nene a? She tœ zœ dœ tœ zœ œ she ndje a'a!» ");
INSERT INTO kxf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kashe anga gbagbara she yé œ pa adœke: «Ɓœ kpa awa Ndjaba nene a? Œrœ á endje mbœrœ fœ azœ, œtœnœ dá endje mbœrœ ndje fœ she! ");
INSERT INTO kxf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tœ azœ, djofelenœ asœ li dœ azœ; gbambanœ nene, œneke á a gbɔ kœdœ œrœ tshangba œneke á a mbœrœ. Kashe œshe, tshe mbœmbœrœ ekperœ teasho nene.» ");
INSERT INTO kxf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Manda nœ, tshe pa fœ Yisu adœke: «Yisu, gbe dœ mœ lɔkɔ á ɓœ kwa bala tœ zœ kœmbœrœ akwa gbozu nœ zœ kane.» ");
INSERT INTO kxf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yisu kœgi fœ she adœke: «Mœ sœ kœpa fœ ɓœ dœ adjapu adœke, kpesheke, ɓœ sœ dœ mœ awa bale ɓa lœ Paradizo.» ");
INSERT INTO kxf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Œ na kœwuta ndoo dœ kakpi ɔlɔ, osho bu kporokoto pa ɔshɔ djigi œrrr ga tœ ada ɔlɔ votɔ manda kakpi ɔlɔ, ");
INSERT INTO kxf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ɔlɔ kpa tɔtɔ nene. Yé egerœ lœba á endje du ɓa sœnda Tepelo asœmœ suru tshelœtœ ye bisha. ");
INSERT INTO kxf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yisu ta rawa dœ ɔgbɔ yé œ pa adœke: «Aba, mœ katœ ɨshirɨ mœ ga tshakane zœ.» Manda kœpa o'onœ asœke, ngbewo tshe tshu ye. ");
INSERT INTO kxf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kœwu œrœ kɔ á mbœrœ lima tœ endje, gbozu tshapa aturugu Roma donga Ndjaba, œ pa adœke: «Œkporo o'o, yakoshe asœke kœdœ uzu á tshe sœ ndjii.» ");
INSERT INTO kxf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yé azu ndjoro á endje ngbɔɓa lima tœ endje kpœtœmœ, wu œrœnœ á mbœrœ lima tœ endje asœmœ, yé œ fatœ endje gu tœnœ dœ kœda okoro endje dœ oyo. ");
INSERT INTO kxf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aayi kœna manda Yisu para kɔkɔ, dœ pe ayashe á endje to lima dœ she ɓa lœ ogo Galilayi, ka lima zara á sœ kœtondœ œrœnœ kɔ á sœ lima kœmbœrœtœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Anga uzu bale á ɨ'ɨrɨ ye kœdœ Yozefu, anga ayi kœwa ngbanga nœ Ayuda, tshe kœdœ lima ɔtshɔ uzu, uzu á tshe sœ ndjii. ");
INSERT INTO kxf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Uzu tshalakpɨ Arimateyo, tshe za lima lɔsu ye djigi kœkate dœ lɔkɔ á Ndjaba œ tetœ kœmbœrœ akwa tshagbozu nœ ye. Tshe vwara lima tœ ye tœ ngbanganœ á endje wa ga tœ Yisu dœ pe œrœnœ á endje mbœrœ ga tœ ye asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tshe na ga ndœ Pilato kœyu she adœke, œne za oko Yisu. ");
INSERT INTO kxf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yé tshe na œ ɨ oko Yisu tœ kurushi ga atɨ, œ vwele dœ imbi lœba yé œ na kœshi tœnœ ɓa lœ kudu á endje dji lœ badja. Endje shishi lima anga uzu bale ga lœ kudunœ asœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tœnœ kœdœ lima olo bale utshu sabata, olo kœguma œrœ yé lɔkɔnœ asœmœ ndo lima ye. ");
INSERT INTO kxf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ayashe á endje to lima dœ Yisu ɓa lœ ogo Galilayi asœmœ, na lima awa bale dœ Yozefu. Endje na lima kœwu kudunœ yé œ wu mara á endje shi dœ oko Yisu ga lœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Manda nœ, endje gu ga manda endje, œ guma kada dœ pe yombo ndœ kœna kœdja ga tœ kote Yisu. Dœ lɔkɔ sabata, endje yatœ endje liaka œneke á awa akwa pa tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dœ ɔlɔ yenga lœ gurutsha, ayashenœ ro ga pa udu dœ yombonœ á endje guma lima asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kœwuta endje ɓa zœ, endje gbɔ adœke endje vwɨrɨ egerœ badjanœ tœ ama kudunœ ye. ");
INSERT INTO kxf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Endje li ɓa lœ kudunœ ɓa zœ, kashe endje gbɔgbɔ lima oko Gbozu Yisu nene. ");
INSERT INTO kxf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Uvuru endje i gara, yé trale endje wu azu bisha á endje verœ lœba á tshiitshi, endje ka ndoo dœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Awa za endje, endje kœtra kumu endje ga atɨ, yé azu asœmœ kœyu endje adœke: «Mbœrœ gaɗe á 'e sœ kœpara uzu á tshe sœ dœ soro ugurutœ akuzu a? ");
INSERT INTO kxf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tshe sœsœ kpœke nene, kashe tshe she ye. 'E gbe dœ o'o á tshe pa lima fœ 'e lɔkɔ á tshe sœpe lima ɓa lœ Galilayi kane. ");
INSERT INTO kxf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tshe pa lima adœke: “Œ li adœke endje za Gbolo nœ uzu ga tshakane ekpe azu, endje wo she ɓa pa kurushi, yé manda olo votɔ, tshe she lœ akuzu ye.”» ");
INSERT INTO kxf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ataa, œndœ o'onœ á Yisu pa lima asœmœ kœte lœ ayashenœ asœmœ, ");
INSERT INTO kxf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","endje to ɓa pa udu ɓa zœ, œ gu œ pandœ o'onœ kɔ fœ ayambarœnœ ndjokpa dœ bale asœmœ dœ pe udu endje kɔ. ");
INSERT INTO kxf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ayashenœ lima kœdœ: Mareya uzu Magadala, Jane œdœ Mareya ayi Jake. Anga angbɨ ayashe á endje ro lima awa bale dœ endje mɨ ndje ndœ nœ fœ aayi avwa. ");
INSERT INTO kxf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aayi avwanœ gbe lima œne endje adœke o'onœ á endje pa asœmœ kœdœ o'o nœ ayi iyi, yé endje yiyi lima ndœ nœ ga tœ ayashenœ nene. ");
INSERT INTO kxf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petro áafo, œ kpa ga pa udunœ ɓa zœ, œ tɨ, œ wu kolœ a'eara imbi ndœma lœba. Œ gu ga ndœ ye, yé œ tetœ kœkɨtœ œsœ œrœ á mbœrœ tœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kolœ dœ lɔkɔnœ asœmœ, anga azu bisha ugurutœ endje na lima ga lakpɨ Emawuse. Kœto lœ Yerusaleme œrrr ga lœ Emawuse, endje mbœrœ ada ɔlɔ bisha nœ ana. ");
INSERT INTO kxf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kœna endje, endje tetœ kœpa o'o tœ œrœnœ á mbœrœ lima tœ endje asœmœ na tœnœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ɓata á endje sœ lima kœkɨtœ œsœnœ dœ pe kœsharatœ endje, Yisu dœ tœ ye te ga ndœ endje, œ tetœ kœna dœ endje tœ awanœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kashe, ala endje bu lima tœ kœwusœ nœ adœke Yisu dœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yisu kœyu endje adœke: «O'o gaɗe dá 'e sharatœ 'e ugurutœ 'e tœ awa lœ kumu nœ a?» Yé endje kœka tshikɨngɨ dœ oyo. ");
INSERT INTO kxf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yeka á anga bale ugurutœ endje, á ɨ'ɨrɨ ye kœdœ Kleyopase, kœgi fœ she adœke: «Kolœ œɓœ bale lœ Yerusaleme asœke dá wuwusœ o'o á ro kpœke nene a?» ");
INSERT INTO kxf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tshe kœyu endje adœke: «O'o gaɗe e?» Endje kœgi fœ she adœke: «O'o nœ Yisu uzu Nazarete. Œshe kœdœ lima ayi kœgbara o'o nœ Ndjaba. Tshe sœ lima dœ gbɔgbɔ nœ kœmbœrœ œrœ dœ pe kœpa o'o utshu Ndjaba œdœ azu. ");
INSERT INTO kxf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yeka agbozu tshapa anganga Ndjaba dœ pe agbozu nœ azœ ka she, á kuru she ga pa kurushi, á wo she ye. ");
INSERT INTO kxf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'A ko lima lɔsu 'a ga pa ye adœke œshe dá Ndjaba vwa she ndœ kœshe azu Israyele. Kashe œ ro kpesheke olo votɔ á œrœnœ mbœrœtœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","'A wusœ nœ lœ awa nœ anga ayashe ugurutœ 'a á endje za o'onœ ga atɨ yekane á tshanga kumu 'a. Gbambanœ nene, endje kpa lima lœ gurutsha ga pa udunœ ɓa zœ, ");
INSERT INTO kxf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kashe endje gbɔgbɔ oko ye nene. Endje fatœ endje œ gu á pa fœ 'a adœke, aandjelu wuta á pa fœ œne adœke, tshe kpa sœpe dœ soro. ");
INSERT INTO kxf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anga anga 'a na ɓa pa udunœ ɓa zœ, œ gbɔ œrœnœ kɔ liaka œneke á ayashenœ gu á pandœ nœ fœ 'a asœmœ, kashe anga œrœ bale kœdœ adœke endje wuwu she nene.» ");
INSERT INTO kxf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yé tshe kœpa fœ endje adœke: «Uu, azu á endje sœsœ dœ kœwusœrœ nene, o'o kɔ á aayi kœgbara o'o pa ɓa lima, 'e yiyindœ nœ katsha nene! ");
INSERT INTO kxf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'E wuwusœ nœ nene a? Œ li adœke Masiya wu oyo yeka á kœsœ lœ mokɔ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Manda nœ, á tetœ kœmɨndœ o'o á endje sú tœ upu nœ ye la buku nœ Ndjaba, kœto tœ Moyize œrrr ga tœ aayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kœndo dœ ogo á endje yi lima ndœ kœna ga lœnœ, Yisu mbœrœ ɓata œnœ sœ kœna œnœ œne lœ ɨngɨrɨnœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Endje kœpa fœ she adœke: «Sœpe dœ 'a mbœrœ ɓa mámá œrrr ɔlɔ dɨ ye, osho bu ndje ye.» Yé tshe kœli ndœ kœlo dœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Endje ngbɔtœ endje ɨndɨrɨ ndaba ndœ kœzɨrœ, tshe kœza mapa, kœdonga Ndjaba, kœva tshelœnœ ndœ kœkurutshelœ nœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Trale ala endje kœkɔrɔ, á endje kœwusœ nœ adœke œshe dœmœ. Œne kpa mesho atake, tɨtɨvwɨrɨ tshe kœyiwa tœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Endje kœtetœ kœyutœ endje, anga manda yanganœ adœke: «Ɔlɔ á tshe sœ kœpa o'o dœ azœ tœ awa dœ pe kœmɨndœ o'o ama Ndjaba la buku, œ sœ kœju lɔsu azœ ɓa ta owo a?» ");
INSERT INTO kxf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pe kpœtœ œsœnœ, endje áafo œ gu ga lœ Yerusaleme, yé á gbɔ ayindœ Yisu ndjokpa dœ bale á endje ngbɔɓa tœ endje dœ pe anga anga endje ");
INSERT INTO kxf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","á sœ kœpa lima adœke: «Adjapu, Gbozu she lœ akuzu ye, tshe matœ ye fœ Shimu.» ");
INSERT INTO kxf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yé ayindœ Yisu bisha asœmœ, kœpandœ o'o á ro tœ awa Emawuse fœ endje, dœ pe mara á endje wusœ Yisu ɔlɔ á tshe va tshelœ mapa. ");
INSERT INTO kxf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ɓata á endje sœpe lima damba kœpa o'onœ, trale Yisu wuta ga ugurutœ endje, á kœpa fœ endje adœke: «Kœsœ gee sœ dœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Uvuru endje i gara dœ awa, mbœrœ endje gbe adœke endje wu ngandoro. ");
INSERT INTO kxf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yé tshe kœpa fœ endje adœke: «Mbœrœ gaɗe dá lɔsu 'e sœ ga lafo a? Mbœrœ gaɗe dá 'e sœ dœ ashara ata a? ");
INSERT INTO kxf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'E wu tshakane mœ dœ ada mœ, œmœ dœmœ. 'E goro mœ dœ́ œ wu, ngandoro sœsœ dœ songba dœ pe ngbabi ɓata á mœ sœ dœ tœnœ asœ nene.» ");
INSERT INTO kxf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Manda o'onœ asœmœ, tshe kœma tshakane ye dœ ada ye fœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɓata á yanga sœ zœ dœ pe uvuru endje á i gara, endje yiyi lima damba ndœnœ nene, Yisu kœpa fœ endje adœke: «'E sœ dœ kœzɨrœ tœnœ kpœke zœ a?» ");
INSERT INTO kxf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Endje za anga ndɨndɨ ageatshalangu á endje zoozo fœ she. ");
INSERT INTO kxf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yé tshe za œ zɨ tœ ala endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Manda nœ, tshe pa fœ endje adœke: «'E wu, ɔlɔ á mœ sœ lima damba dœ 'e, mœ pa lima fœ 'e adœke: O'o á endje sú lima la buku awa akwa nœ Moyize, la buku nœ aayi kœgbara o'o dœ pe la œnœ Itshi, œ mbœrœtœ endje liakanœ.» ");
INSERT INTO kxf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mbœrœ tœnœ ataa, Yisu kɔrɔ kœwusœrœ nœ endje ndœ kœwusœ ádá buku nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tshe pa fœ endje adœke: «Ɓata á o'o ama Ndjaba sœ lima kœpa tœnœ: Endje ndanga Masiya œrrr ga tœ kœwo she, kashe manda olo votɔ tshe she ugurutœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Œ li adœke, endje mɨndœ ɨ'ɨrɨ ye lœ angbɨ ogo kɔ kœto lœ Yerusaleme, mbœrœ adœke azu fatshalɔsu endje á Ndjaba kœdjerœndœ ekperœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mbœrœ e'e dá dœ atimu nœ œrœnœ kɔ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yé œmœ, mœ vwa Ɔtshɔ Ɨshirɨ fœ 'e ɓata á Aba mœ pa lima ndœ nœ. 'E sœ damba lœ Yerusaleme kpœke œrrr ga tœ olo á gbɔgbɔ nœ Ndjaba kœjerœ ga pa 'e yekane.» ");
INSERT INTO kxf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Manda nœ, Yisu to endje na tœnœ ndoo dœ Betani. Tshe tɨ kane ye ga lafo, á to kane ye kapa endje. ");
INSERT INTO kxf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lɔndɔ á tshe sœ lima kœto kane ye ga pa endje, tshe katœ endje yé œ ɔ ga lafo. ");
INSERT INTO kxf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Manda kœdonga she, endje gu dœ yanga ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɔlɔ dœ ɔlɔ endje sœ lima kœna kœdonga Ndjaba ɓa lœ Tepelo.");
INSERT INTO kxf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Utshunœ adœke Ndjaba mbœrœ tshalafo dœ tshapashɔ, O'o sœ lima zœ. O'o sœ lima awa bale dœ Ndjaba, yé O'o kœdœ lima Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","O'o sœ lima awa bale dœ Ndjaba utshunœ adœke tshe mbœrœ tshalafo dœ tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ndjaba mbœrœ œrœ kɔ dœ awa nœ ye, yé anga œrœ bale mbœmbœrœtœ ye kpi tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","O'o sœ lima dœ soro, yé soro kœdœ lima ɨngbɨsho nœ azu. ");
INSERT INTO kxf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yé ɨngbɨsho matœ ye lœ ubu osho kashe ubu osho sœsœ dœ gbɔgbɔ tœ kœwo ɨshirɨnœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ndjaba vwa lima anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Yowane. ");
INSERT INTO kxf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tshe na lima ɓata timu mbœrœ kœpa o'o tœ upu nœ ɨngbɨsho. Tshe na adœke azu para kɔkɔ sœ dœ kœyindœrœ ga ndœ ɨngbɨshonœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tshe dœ́dœ́ lima ɨngbɨsho má nene, kashe tshe na lima adœke œne pandœ adja o'o tœ upu nœ ɨngbɨshonœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","O'onœ kœdœ lima adja ɨngbɨsho, œneke á na ga pa ɔshɔnœ asœke yé œ tɔ ga ndœ azu para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","O'o sœ lima pa tshapashɔnœ asœke. Ndjaba mbœrœ lima tshapashɔnœ asœke dœ awa nœ ye kashe azu tshapashɔ wuwu lima sœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O'o na lima ga lœ ogo nœ ye dœ tœ ye, kashe azu nœ ye zaza lima osho kœsœ fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Andaa, mbœrœ azu neke á endje za lima osho kœsœ fœ she, á sœ lima dœ kœyindœrœ dœ ɨ'ɨrɨ ye, tshe za lima awa fœ endje adœke endje te agbolo nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Endje tete agbolo nœ Ndjaba lœ indji dœ pe lœ mara nœ azu nene, ɓata á yakoshe œ zu gbolo tœ yashe liaka ogo nœ endje nene, kashe Ndjaba dá zu lima endje liaka gbetshelœ nœ ye dœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yé O'o wuta uzu, œ lo ugurutœ azœ. A wu mokɔ nœ ye, yé œtœnœ kœdœ mokɔ á Ndjaba Aba za fœ Gbolo nœ ye tshebale, á tshe sú dœ ɔtshɔ lɔsu œdœ adjapu. ");
INSERT INTO kxf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowane te lima tœ kœpandœ o'o tœ upu nœ ye, á gbara lima o'o adœke: «'E wu uzu á mœ mɨ lima ndœ o'o tœ upu nœ ye lɔkɔ á mœ pa adœke: “Tshe sœ kœna manda mœ, kashe tshe ropa mœ ye, gbambanœ nene, utshu mœ tshe sœ lima zœ.”» ");
INSERT INTO kxf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lœ ɔtshɔ lɔsu nœ ye, tshe to kane ye ga pa azœ para kɔkɔ, yé tshe kpa to anganœ ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ndjaba za lima awa akwa fœ azœ lœ awa nœ Moyize, kashe ɔtshɔ lɔsu nœ ye œdœ pe adja o'o nœ ye na ga ndœ azœ dœ awa nœ Yisu Kristu. ");
INSERT INTO kxf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Adja uzu bale wuwu Ndjaba nene, kashe Gbolo nœ Ndjaba tshebale á tshe kœdœ Ndjaba, yé á sœ awa bale dœ Abanœ, œshe dá yisœ Ndjaba fœ azœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yé asœke kœdœ o'o á Yowane pa lima lɔkɔ á agbozu tshapa Ayuda á endje lœ lima lœ Yerusaleme vwa lima anganga Ndjaba œdœ pe alevite ndœ kœyu she adœke: «Œɓœ kœdœ uzu ɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tshe vwavwara lima tœ ye tœ kœgi o'o nene, tshe pa lima o'ara adœke: «Mœ dœ́dœ́ Kristu nene.» ");
INSERT INTO kxf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Á endje kœyu she adœke: «Ataa, ɓœ kœdœ má œɗe e? Œɓœ kœdœ Eliya a?» Á tshe kœgi adœke: «Mœ dœ́dœ́ she nene.» «Œɓœ kœdœ ayi kœgbara o'o a?» Á tshe kœgi adœke: «Œ̃.» ");
INSERT INTO kxf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Endje kœpa fœ she adœke: «Atamœ, œɓœ kœdœ má ɗe e? Mbœrœ œ li adœke 'a gu dœ o'o fœ azu á endje vwa 'a. Ɓœ pa kotoo tœ zœ dœ tœ zœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Á tshe gi fœ endje adœke: «Œmœ kœdœ “tshama á sœ kœkɨ ɓa lœ kpagagasho adœke, 'e guma ala awa Gbozu!”» Ɓata ayi kœgbara o'o Isaya pa lima. ");
INSERT INTO kxf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Andaa azu á endje vwa lima endje fœ Yowane kœdœ lima Afarisayi. ");
INSERT INTO kxf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Endje kpa yu she adœke: «Œdœ ɓœ kœdœ́dœ́ Kristu nene, ɓœ dœ́dœ́ Eliya nene, á dœ́dœ́ ndje ayi kœgbara o'o nene, mbœrœ gaɗe á ɓœ sœ kœza batisimu fœ azu a?» ");
INSERT INTO kxf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yowane kœgi fœ endje adœke: «Mœ sœ kœza batisimu fœ azu ɓa la ungu. Kashe anga uzu bale sœ ugurutœ 'e á 'e wuwusœ ye nene, ");
INSERT INTO kxf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","tshe na manda mœ, yé mœ li kœzu uwu œrada nœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Œneke kɔ mbœrœ lima tœ endje ɓa lœ Betani ɓa kele ungu Yɔrdane ɓa tœ osho á Yowane sœ lima kœza batisimu fœ azu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Osho kɔrɔ pa nœ, Yowane wu Yisu kœna ga ndœ ye á pa adœke: «Wu Aya Pata nœ Ndjaba á tshe gi ekperœ pa azu tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Œshe dá mœ pa lima o'o tœ upu nœ ye adœke: “Anga uzu bale œ na manda mœ, kashe tshe ropa mœ ye; gbambanœ nene, utshunœ adœke mœ wuta ga pa ɔshɔ asœ, tshe sœ lima zœ.” ");
INSERT INTO kxf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Œmœ ndje, mœ wuwu lima sœ ye nene, kashe mœ na kœza batisimu ɓa la ungu á kœmbœrœ adœke azu Israyele kœwusœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yowane kpa pa adœke: «Mœ wu Ɔtshɔ Ɨshirɨ ɓata mbepa á tshe to ɓa lafo á jerœ kœsœ ga pa ye. ");
INSERT INTO kxf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yé mœ wuwu lima damba sœ ye nene, kashe Ndjaba á tshe vwa mœ ndœ kœza batisimu fœ azu ɓa la ungu dá pa fœ mœ adœke: “Uzu á ɓœ wu Ɨshirɨ kœjerœ kœsœ ga pa ye, œshe dá za batisimu nœ Ɔtshɔ Ɨshirɨ fœ azu.” ");
INSERT INTO kxf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yé œmœ, mœ wu lima yeka á sœ kœpa tœ upu nœ ye adœke, œshe kœdœ Gbolo nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Olo bale manda nœ, Yowane kpa sœ lima kpœtœ oshonœ asœmœ dœ anga ayambarœ nœ ye bisha. ");
INSERT INTO kxf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Lɔkɔ á tshe wu Yisu kœro tœnœ, tshe pa adœke: «Wu Aya Pata nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ayambarœ nœ Yowane dji o'onœ á tshe pa lima asœmœ yé œ na manda Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yisu fatœ ye ngarrr œ wu, endje sœ kœna manda œne, á yu endje adœke: «'E sœ kœpara gaɗe?» Endje gi fœ she adœke: «Rabi, ɓœ sœ kœlo ɓata a?» ");
INSERT INTO kxf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tshe gi fœ endje adœke: «'E na gamœ yeka á kœwu.» Œ sœ lima ada ɔlɔ vana manda kakpi ɔlɔ. Endje na lima, œ wu osho á tshe sœ lima kœlo tœnœ, yé œ sœ lima kpœtœmœ awa bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anga bale ugurutœ abishanœ á endje dji o'o ama Yowane, á na manda Yisu asœmœ kœdœ lima Andere, aya Shimu Petro. ");
INSERT INTO kxf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tshe na utshunœ œ gbɔ ayanœ dœ Shimu, á pa fœ she adœke: «'A gbɔ Masiya» – Œ yindœ kœpa adœke «Kristu». – ");
INSERT INTO kxf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tshe to Shimu na ga ndœ Yisu. Á Yisu kœshokɔ she kukuku, á kœpa adœke: «Œɓœ kœdœ Shimu, gbolo nœ Yowane. Endje e ɓœ Sefase.» – Œ yindœ kœpa adœke «Petro». ");
INSERT INTO kxf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Osho kɔrɔ pa nœ, Yisu gbe kœkwa ga lœ Galilayi. Tshe gbɔ lima Filipo á pa fœ she adœke: «Na manda mœ!» ");
INSERT INTO kxf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Andaa Filipo kœdœ lima uzu tshalakpɨ Betesayida, osho á endje zu Andere œdœ Petro tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Manda nœ, Filipo na œ gbɔ Natanayele á pa fœ she adœke: «'A gbɔ uzunœ á endje sú o'o lima tœ upu nœ ye ga la awa akwa nœ Moyize œdœ aayi kœgbara o'o: Œshe kœdœ Yisu, gbolo nœ Yozefu uzu tshalakpɨ Nazarete.» ");
INSERT INTO kxf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Á Natanayele kœyu she adœke: «Lœ Nazarete, adja anga ɔtshɔrœ œ wuta zœ a?» Á Filipo kœpa fœ she adœke: «Na gamœ, yé œ wu.» ");
INSERT INTO kxf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisu wu Natanayele kœna lima ga ndœ ye, á pa tœ ye adœke: «Tsheneke kœdœ adja uzu Israyele, tshe pa kolœ adja o'o fœ azu.» ");
INSERT INTO kxf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yeka á Natanayele kœyu she adœke: «Ɓœ wusœ mœ ɓata a?» Yisu kœpa fœ she adœke: «Lɔkɔ á ɓœ sœ ɓa tshakudu ɔyɔ fige, mœ wu ɓœ utshunœ adœke Filipo e ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayele kœpa fœ she adœke: «Rabi, ɓœ kœdœ Gbolo nœ Ndjaba, ɓœ kœdœ gbozugo nœ azu Israyele.» ");
INSERT INTO kxf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yisu kœgi fœ she adœke: «Ɓœ sœ dœ kœyindœrœ ga ndœ mœ mbœrœ á mœ pa fœ ɓœ adœke mœ wu má ɓœ ɓa tshakudu ɔyɔ fige a? Ɓœ kpa wu ogboro œrœ á ropa œneke.» ");
INSERT INTO kxf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Á Yisu kpa kœpa adœke: «Mœ pa fœ 'e dœ adjapu adœke, 'e wu bala tshalafo kœkɔrɔ tœnœ dœ aandjelu nœ Ndjaba kœɔ kœjerœ pa Gbolo nœ uzu.» ");
INSERT INTO kxf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Olo bisha manda nœ, angbo totœ sœ lima ɓa lapkɨ Kanana lœ ogo Galilayi. Ayi Yisu sœ lima ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yé endje e ndje lima Yisu dœ ayambarœ nœ ye kœna ndœ angbonœ. ");
INSERT INTO kxf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɓata vinu ka lima ye, ayi Yisu pa fœ she adœke: «Azu kpa gugu dœ vinu nene.» ");
INSERT INTO kxf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kashe Yisu gi fœ she adœke: «Yashe, o'o gaɗe tœ zœ dœ mœ a? Ada ɔlɔ nœ mœ lili damba nene.» ");
INSERT INTO kxf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ayinœ kœpa fœ azu kœmbœrœ akwa adœke: «'E mbœrœ œneke kɔ á tshe pa tœnœ fœ 'e adœke 'e mbœrœ.» ");
INSERT INTO kxf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngarambo mindu dœ bale á endje mbœrœ dœ badja lœ lima kpœtœmœ. Ayuda mbœrœ lima ngarambonœ asœmœ mbœrœ kœdjutɔ dœ kotœ endje utshu kœ'e Ndjaba. Tshelœ ngarambo bale dœ bale li lima litere ndoo dœ kama bale (100). ");
INSERT INTO kxf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisu pa fœ ayi akwa adœke: «'E su ungu pete ga lœ ngarambonœ asœke.» Endje su ungu ga lœ nœ yé œ su pete pete. ");
INSERT INTO kxf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Á Yisu pa fœ endje adœke: «Ngɔngɔ asœke, 'e su, œ na dœ tœnœ fœ ayengɔ angbonœ.» Yé endje sú œ na dœ tœnœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tshe dji ɔtshɔ ungunœ á wuta lima vinu. Tshe wuwu lima sœ osho á vinunœ to tœnœ nene, kashe ayi akwanœ á endje sú lima ungunœ, á na dœ tœnœ fœ she dá wu lima sœ nœ. Tshe e ndje yakoshe totœnœ, ");
INSERT INTO kxf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","á pa fœ she adœke: «Uzu kɔ te ɓalima tœ kœsu ala vinu fœ azu lœ angbo, yé azu kœndjo œrrr á kœmbœrœ endje yekane á aa su saɓala manda nœ. Kashe ɓœ gbɔndœ ala vinunœ œrrr ga tœ ngɔngɔ asœke a!» ");
INSERT INTO kxf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ali kœtetœ kœmbœrœ ambárá afá nœ Yisu sœ lima ɓa lakpɨ Kanana, lœ ogo Galilayi. Tshe ma lima mokɔ nœ ye lœ awa kœfa œrœnœ asœke, yé ayambarœ nœ ye sœ lima dœ kœyindœrœ ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Manda nœ, tshe jerœ lima ga lœ Kaparnawumu awa bale dœ ayinœ, dœ aayanœ œdœ pe ayambarœ nœ ye. Œndœ endje dɨdɨ lima ɓa zœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɓata olo angbo pake nœ Ayuda ndo lima ye, Yisu ɔ lima ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kœli she ga lœ Tepelonœ atake, tshe gbɔ azu á endje lœ tœ kœka angombe, apata œdœ pe ambepa. Tshe gbɔ ndje lima azu kœyapa ngendja á endje lœ ga ɨndɨrɨ meza nœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kœwu ataa, tshe mbœrœ ndjapa dœ uwu, œ gɔrɔ dœ endje kɔ, œdœ apata œdœ angombe nœ endje. Tshe gɨgɨ tshelœ ngendja nœ aayi kœyapa ngendja, œ ɨvwɨ meza nœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tshe pa fœ aayi kœka ambepa adœke: «'E gitœ 'e dœ œrœ kɔ kpœke, 'e fafa anda nœ Aba mœ ɓata anda kœka œrœ nœ 'e lœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ayambarœ nœ ye kœgbe dœ o'onœ á endje sú ga la Buku nœ Ndjaba adœke: «Uu Ndjaba, ayo á mœ sœ dœ tœnœ ga tœ anda nœ zœ ju mœ ɓata owo.» ");
INSERT INTO kxf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yé agbozu Ikrizia kœyu she adœke: «Ambárá afá gaɗe dá ɓœ mbœrœ yeka á kœma fœ 'a adœke ɓœ gbɔ awa ndœ kœmbœrœ œrœ atake a?» ");
INSERT INTO kxf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yisu gi fœ endje adœke: «'E ndɨ tshelœ anda Tepelo asœke, yé manda olo votɔ mœ kpa mɔ anganœ ga mangba nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Agbozu Ayudanœ kpa yu she adœke: «Endje mɔ anda Tepelo asœke manda ngbugu zazu bisha dœ mindu dœ bale (46), yé œɓœ á ɓœ sœ ke, ɓœ li tœ kœmɔ tœnœ manda olo votɔ a?» ");
INSERT INTO kxf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kashe Yisu pa lima tœ Tepelo nœ undu ye. ");
INSERT INTO kxf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Œrrr manda nœ, dœ lɔkɔ á Ndjaba she lima Yisu lœ akuzu dá ayambarœ gbe dœ o'onœ á tshe pa lima tœnœ ataa. Endje yi lima ndœ o'o á Buku nœ Ndjaba pa œdœ pe o'onœ á tshe pa. ");
INSERT INTO kxf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lɔkɔ á Yisu sœ lima lœ Yerusaleme, dœ lɔndɔ angbo pake, azu ndjoro sœ lima dœ kœyindœrœ ga ndœ ɨ'ɨrɨ ye mbœrœ ambárá afá ndjoro á tshe sœ lima kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kashe Yisu zaza lima lɔsu ye ga pa endje nene mbœrœ tshe wu lima sœ endje dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ádá adœke endje pa lima o'o fœ she tœ upu nœ azu gugu nene, mbœrœ œshe dœ tœ ye tshe wu lima sœ o'o á sœ tœ lɔsu endje kɔ. ");
INSERT INTO kxf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Nikodeme, sœ lima ugurutœ Afarisayi, yé œ dœ́ lima anga gbozu tshapa Ayuda. ");
INSERT INTO kxf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Anga butshɔ bale, tshe na ga ndœ Yisu œ pa fœ she adœke: «Rabi, 'a wusœ nœ adœke Ndjaba dá vwa ɓœ adœke ɓœ yisœ œrœ fœ 'a mbœrœ uzu œ li kœmbœrœ ambárá afá ɓata á ɓœ mbœrœ asœke œdœ Ndjaba kœsœsœ dœ she awa bale nene.» ");
INSERT INTO kxf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yé Yisu gi fœ she adœke: «Mœ pa fœ ɓœ dœ adjapu adœke, uzu bale œ li kœwu Ogo gbozu nœ Ndjaba nene œdœ endje kpa kœzuzu she tœ bishanœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodeme kœyu she adœke: «Mara gaɗe dá uzu á tshe gbɔ ye á endje kpa zu she tœ bishanœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yisu gi fœ she adœke: «Mœ pa fœ ɓœ dœ adjapu adœke, uzu bale lili tœ kœli ga lœ Ogo gbozu nœ Ndjaba nene œdœ endje kœzuzu she dœ awa nœ ungu œdœ ndje dœ awa nœ Ɔtshɔ Ɨshirɨ nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Œneke á to lœ undu uzu kœdœ undu uzu; yé œneke á to lœ Ɨshirɨ, kœdœ ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Uvuru zœ kpakpa lœ zœ nene mbœrœ o'onœ á mœ pa fœ ɓœ adœke: “Œ li adœke endje zu 'e lœ awa nœ tshalafo.” ");
INSERT INTO kxf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yugu sœ kœna tœ osho á yindœ nœ, yé ɓœ sœ kœdji œsœnœ kashe ɓœ wusœ osho á to tœnœ too osho á sœ kœna ga tœnœ nene. Asœke kœdœ mara œrœ á sœ kœmbœrœtœ ye mbœrœ uzu kɔ á endje zu she lœ awa nœ Ɨshirɨ.» ");
INSERT INTO kxf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Á Nikodeme kœpa fœ she adœke: «Mara œrœ atake œ li kœmbœrœtœ ye koto o?» ");
INSERT INTO kxf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yisu gi fœ she adœke: «Œɓœ kœdœ ayi kœyisœrœ fœ azu Israyele yé ɓœ wuwusœ œrœnœ asœke nene a? ");
INSERT INTO kxf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mœ sœ kœpa fœ ɓœ dœ adjapu adœke: 'a sœ kœpa o'o tœ upu nœ œrœ á 'a wusœ nœ œdœ pe œneke á 'a wu, kashe 'e wu o'o nœ 'a gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Œdœ mœ kœpa o'o tœ œrœ á sœ kœmbœrœtœ ye pa ɔshɔ asœke fœ 'e á 'e kœdjidji mœ nene, 'e yi má ndœ o'o ama mœ kotoo œ kœsœ adœke mœ pa o'o tœ œrœ á mbœrœtœ ye ɓa lafo fœ 'e a? ");
INSERT INTO kxf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gbambanœ nene, uzu bale ɔɔ ɓa lafo nene, kolœ Gbolo nœ uzu á tshe to ɓa lafo á jerœ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Ɓata Moyize i lima anga yakoro á endje mbœrœ she de yarakowo ga tœ ɔyɔ ndœ kœtɨ she ga lafo ɓa lœ kpagagasho, awa bale azu œ za Gbolo nœ uzu œ tɨ she ga lafo, ");
INSERT INTO kxf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","yekane uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ ye, tshe gbɔ soro neke á ka nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gbambanœ nene, Ndjaba yindœ tshapashɔ waa yeka á vwa Gbolo nœ ye tshebale adœke uzu kɔ á tshe yindœ ye, tshe tshu nene, kashe tshe sœ dœ soro á ka nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ndjaba vwavwa Gbolo nœ ye ga pa ɔshɔ mbœrœ kœwa ngbanga ga tœ tshapashɔ nene, kashe Ndjaba vwa she adœke tshapashɔ gbɔ kœshe lœ awa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«Uzu á tshe kœsœ dœ kœyindœrœ ga ndœ ye, Ndjaba œ wa ngbanga ga tœ ye nene. Kashe uzu á tshe kœsœsœ dœ kœyindœrœ ga ndœ ye nene, Ndjaba wa ɓalima o'o ga tœ ye yé mbœrœ á tshe sœsœ dœ kœyindœrœ ga ndœ ɨ'ɨrɨ Gbolo tshebale nœ Ndjaba nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yé ngbanga kœwa tœnœ dœke: Ɨngbɨsho na ga pa tshapashɔ, kashe azu yindœ ubu osho kœropa ɨngbɨsho, mbœrœ akwa tshelœ endje sœ tœ ekpenœ. ");
INSERT INTO kxf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Atamœ, uzu kɔ á tshe sœ kœmbœrœ ekperœ, yiangba ɨngbɨsho. Tshe na ga ndœ ɨngbɨsho nene kparawa adœke ekperœ nœ œne wuta ngbɨ ga ushu. ");
INSERT INTO kxf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kashe uzu á tshe te manda adja o'o, sœ kœna ga ndœ ɨngbɨsho adœke endje wu ngbɨ adœke akwa á tshe sœ kœmbœrœ tœnœ sœ kœlɨsœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Manda nœ, Yisu na awa bale dœ ayambarœ nœ ye ga lœ ogo Yuda. Tshe lo lima awa bale dœ endje ɓa zœ yé œ sœ kœza lima batisimu fœ azu. ");
INSERT INTO kxf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yowane za ndje lima batisimu fœ azu ɓa lakpɨ Eno ndoo dœ Salime mbœrœ ungu lœ lima kpœtœmœ waa. Azu sœ lima kœna ga ndœ ye yé œ sœ kœgbɔ batisimu. ");
INSERT INTO kxf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Andaa, endje zaza lima damba Yowane ga lœ kánga nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɔlɔ bale, anga ayambarœ nœ Yowane te lima tœ kœgbugburu tshelœ o'o dœ anga uzu Yuda bale tœ upu nœ kœdjutɔ kote utshu nœ kœ'e Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Endje na lima ga ndœ Yowane, œ yu lima she adœke: «Rabi, uzu á tshe sœ lima dœ ɓœ ɓa atshi ungu Yɔrdane, œshe á ɓœ pa o'o tœ upu nœ ye asœmœ; wusœ nœ adœke, tshe sœ ndje kœza batisimu fœ azu yé azu kɔ sœ kœna ga ndœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yowane gi fœ endje adœke: «Uzu gbɔ kolœ œrœ á Ndjaba œ to fœ she.» ");
INSERT INTO kxf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","E'e dœ tœ 'e, 'e li kœpandœ nœ adœke 'e dji lima mœ kœpa adœke: «Mœ dœ́dœ́ Kristu nene, kashe Ndjaba vwa mœ kœwuta utshunœ adœke tshe na.» ");
INSERT INTO kxf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ayi kœto yashe kœdœ akɔ yashe. Kashe yanga ayi kœto yashe œ ka kpœ ɨndɨrɨ ye yeka á dji she. Tshe sœ dœ yanga tœ kœdji tshadɔngɔrɔ ayi kœto yashenœ. Yanganœ asœmœ kœdœ œnœ mœ, yé lɔsu mœ sú ngɔngɔ asœ dœ tœnœ pete. ");
INSERT INTO kxf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Œ li adœke uzunœ asœmœ wuta egerœ uzu, yé mœ sœ œnœ mœ teasho. ");
INSERT INTO kxf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Uzu á tshe to ɓa lafo ropa œrœ kɔ. Uzu tshapashɔ kœdœ uzu tshapashɔ yé tshe pa kolœ o'o tshapashɔ. Tsheneke á tshe to ɓa lafo, ");
INSERT INTO kxf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","tshe sœ kœpa o'o tœ œrœ á tshe wu yé á dji. Kashe uzu bale yiyindœ œneke á tshe sœ kœmɨndœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Uzu á tshe kœyindœ o'o nœ ye, uzunœ asœmœ yi ndje ndœ nœ adœke Ndjaba pa kolœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tsheneke á Ndjaba vwa she pa kolœ o'o nœ Ndjaba mbœrœ Ɨshirɨ nœ Ndjaba sœ lœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ndjaba Aba yindœ Gbolo nœ ye, yé œ za she tœ gbozu tshapa œrœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Uzu á tshe sœ dœ kœyindœrœ ga ndœ Gbolonœ asœke, tshe gbɔ soro á ka nene. Kashe tsheneke á tshe kœvwaratœ ye tœ kœsœ dœ kœyindœrœ ga ndœ Gbolonœ, tshe gbɔ soronœ nene, yé ókó nœ Ndjaba œ sœ waa pa ye.» ");
INSERT INTO kxf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afarisayi dji lima ndœ nœ adœke Yisu sœ lima dœ ayambarœ waa yé œ sœ kœza batisimu fœ azu kœropa Yowane. ");
INSERT INTO kxf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kashe Yisu dœ tœ ye zaza lima batisimu fœ azu nene, ayambarœ nœ ye dá sœ lima kœza batisimunœ. ");
INSERT INTO kxf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ɔlɔ á Yisu dji o'onœ á endje sœ lima kœpa tœnœ, tshe katœ ogo Yuda tɨ yé œ gu ga lœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Andaa tœ kœgu she ga zœ, œ li lima adœke tshe ro tɔ lœ ogo Samariya. ");
INSERT INTO kxf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tshe wuta ndoo dœ anga tshalakpɨ Samariya á ɨ'ɨrɨnœ kœdœ Sishare. Sishare sœ ndoo dœ kɨndɨ á Yakobo za lima fœ gbolo nœ ye dœ Yozefu. ");
INSERT INTO kxf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Œtœnœ kœdœ ndje osho á kudu ungu nœ Yakobo sœ tœnœ. Yisu mɔ lœ ana, yé œ sœ ga atɨ ga tœ ama kudu ungunœ. Œ sœ lima ndoo dœ kakpi ɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Anga yashe Samariya bale na ndœ kœsu ungu á Yisu pa fœ she adœke: «Su ungu fœ mœ dœ mœ ndjo.» ");
INSERT INTO kxf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ayambarœ nœ ye kɔ wuta lima ga lœ ongbo mbœrœ kœpara kœzɨrœ. ");
INSERT INTO kxf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yashe Samariyanœ kœpa fœ Yisu adœke: «Œɓœ kœdœ uzu Yuda, mbœrœ gaɗe á ɓœ eshondœ ungu kœndjo ɓa ndœ œmœ dœ́ uzu Samariya?» Mbœrœ Ayuda mbœmbœrœ ɓalima ayo dœ Asamariya nene ma! ");
INSERT INTO kxf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yisu kœgi fœ she adœke: «Œdœ ɓœ kœwu má sœ œrœ á Ndjaba œ to, œdœ pe uzu á tshe esho ndœ ungu kœndjo ndœ zœ asœke; œɓœ dá yu má she ndœ ungu yeka á tshe su má ungu á za soro fœ azu fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yashe Samariya kœyu she adœke: «Gbozu, ɓœ sœsœ dœ œrœ kœsu dœ ungu nene, yé kudu ungunœ li waa, ataa ɓœ gbɔ ungu á za soro fœ azu ɓata ma a? ");
INSERT INTO kxf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ata 'a dœ Yakobo dá za kudu ungunœ asœke fœ 'a. Tshe ndjo ndje lima ungunœ œshe dœ agbolo nœ ye œdœ pe ayarœ nœ ye. Ataa ɓœ gbe adœke ɓœ ropa ye ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yisu gi fœ she adœke: «Uzu kɔ á tshe ndjo ungu asœke, tshe kpa sœ dœ ogo ungu. ");
INSERT INTO kxf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kashe uzu á tshe ndjo ungu á mœ su fœ she, tshe kpa sœ dœ ogo ungu nene. Gbambanœ nene, ungu á mœ su fœ she œ sœ lœ ye ɓata kumu ungu á za soro á ka nene.» ");
INSERT INTO kxf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yashe Samariya kœpa fœ she adœke: «Gbozu, su ungunœ á ɓœ pa tœnœ asœke fœ mœ, adœke ogo ungu kpa mimi mœ nene yé mœ kpa nana kpœke ndœ kœsu ungu nene.» ");
INSERT INTO kxf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yisu kœpa fœ she adœke: «Na œ e akɔ zœ dœ́ 'e kwatœ 'e dœ she ɓa ke.» ");
INSERT INTO kxf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yashe Samariya pa fœ she adœke: «Mœ gugu dœ yakoshe nene.» Á Yisu kœpa fœ she adœke: «Adjapu adœke ɓœ gugu dœ yakoshe nene. ");
INSERT INTO kxf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gbambanœ nene, ɓœ ɨ ayakoshe mindu yé tsheneke á ɓœ sœ dœ she ngɔngɔ asœke dœ́dœ́ akɔ zœ nene. Ɓœ pa adja o'o.» ");
INSERT INTO kxf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Á yashe kœkɨ paa adœke: «Gbozu, mœ wu adœke œɓœ kœdœ ayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aata 'a donga Ndjaba pa kaga asœke, kashe e'e dœ́ Ayuda, 'e pa adœke osho á li kœdonga Ndjaba tœnœ kœdœ Yerusaleme.» ");
INSERT INTO kxf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yisu kœpa fœ she adœke: «Yashe, dji mœ kane. Anga ɔlɔ œ tɔ á 'e kpa donga Ndjaba Aba ɓa pa kaga too ɓa lœ Yerusaleme nene. ");
INSERT INTO kxf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","E'e dœ́ Asamariya, 'e sœ kœdonga Ndjaba kashe 'e wuwusœ ye nene. Kashe a'a dœ́ Ayuda, 'a sœ kœdonga Ndjaba neke á 'a wusœ ye mbœrœ kœshe wuta lœ awa nœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kashe dœ anga ɔlɔ bale, yé ɔlɔnœ tɔ ye, adja azu kœdonga Ndjaba, endje donga she dœ Ɨshirɨ œdœ pe lœ adjapu. Gbambanœ nene, Ndjaba yindœ nœ adœke azu donga œne dœ maranœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndjaba kœdœ Ɨshirɨ, yé endje á endje yindœ kœdonga she li kœdonga she dœ Ɨshirɨ œdœ pe lœ adjapu.» ");
INSERT INTO kxf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yashe Samariya kœpa fœ she adœke: «Mœ wusœ nœ adœke Masiya, á tshe kœdœ Kristu, œ na zœ. Ɔlɔ á tshe kœna, tshe mɨndœ œrœ kɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yisu kœgi fœ she adœke: «Œmœ kœdœ she, œmœ á mœ sœ kœpa o'onœ fœ ɓœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dœ lɔndɔnœ asœmœ, ayambarœ nœ Yisu yi kumu endje, yé uvuru endje kpa lœ nœ tœ kœwu adœke tshe sœ kœpa o'o dœ yashe. Kashe anga bale yuyu she nene adœke: «Ɓœ sœ kœpara gaɗe e? Too o'o gaɗe dá 'e sœ kœpa dœ she a?» ");
INSERT INTO kxf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yé yashenœ katœ lɔsú ungu nœ ye tɨ kpœtœmœ, yé á kpagu kœpandœ nœ fœ azu ɓa lakpɨ adœke: ");
INSERT INTO kxf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«'E na dœ́ wu anga yakoshe bale á tshe sœ ɓa e kane, tshe pandœ œrœ kɔkɔ á mœ mbœrœ fœ mœ. Œrrr á tshe dœ ete Kristu a?» ");
INSERT INTO kxf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ataa, azu wuta lœ ongbo, œ na ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kolœ kpœtœmœ, ayambarœ nœ ye tetœ kœtovworogbo she adœke tshe zɨ œrœ. Endje pa fœ she adœke: «Rabi, zɨ rœgo kane.» ");
INSERT INTO kxf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kashe Yisu gi fœ endje adœke: «Mœ sœ dœ kœzɨrœ á 'e wuwusœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ayambarœ kœtetœ kœyutœ endje ugurutœ endje adœke: «Ataa anga uzu na dœ kœzɨrœ fœ she a?» ");
INSERT INTO kxf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yisu kœpa fœ endje adœke: «Kœzɨrœ nœ mœ dœke: œ li adœke mœ mbœrœ œrœ á ayi kœvwa mœ yindœ nœ, œdœ ndje kœgi akwa á tshe vwa mœ ndœ kœmbœrœ tœnœ ga tœ ndɔngɔlɔnœ. ");
INSERT INTO kxf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","E'e, 'e sœ kœpa adœke: “Œ sœpe yapu vana tœ kœkɔ ngwarœ.” Kashe œmœ, mœ pa fœ 'e adœke, 'e wu kɨndɨ dœ ɔtshɔnœ; leyɔ doro ye œ sœ ndoo tœ kœkɔ tœnœ! ");
INSERT INTO kxf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Uzu á tshe kœkɔ, tshe gbɔ ngendja tshangba akwa nœ ye, yé tshe ngbɔɓa leyɔnœ mbœrœ soro á ka nene. Uzu á tshe lu leyɔ ga lœ kɨndɨ dœ pe tsheneke á tshe kɔ, endje sœ dœ yanga awa bale. ");
INSERT INTO kxf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gbambanœ nene, azu pa anga gbaguru adœke: “Uzu gɨ ngwarœ kashe ayi kœkɔ tœnœ sœ kpi”. ");
INSERT INTO kxf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mœ vwa 'e ndœ kœkɔ leyɔ tshelœ kɨndɨ á œ dœ́dœ́ 'e dá djo nene. Anga angbɨ azu dá djo kɨndɨnœ yeka á 'e li ga lœ akwanœ manda endje tœ kœkɔ leyɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɨlɨ azu Samariya kpœlœ ongbonœ asœmœ sœ lima dœ kœyindœrœ ga ndœ Yisu mbœrœ o'o á yashenœ pa adœke: «Tshe pandœ œrœ kɔ á mœ mbœrœ, fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ádánœ ataa, lɔkɔ azu Samariya na lima ga ndœ ye, endje kɨ lima ga tœ ye adœke tshe sœpe dœ œne. Yisu mbœrœ lima kpœtœmœ olo bisha. ");
INSERT INTO kxf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Anga azu kpi ndjoro kpa sœ ndje lima dœ kœyindœrœ ga ndœ Yisu mbœrœ o'o á tshe sœ lima kœpa tœnœ dœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Endje pa lima fœ yashenœ adœke: «Ngɔngɔ asœ, 'a sœsœ dœ kœyindœrœ ga ndœ ye kolœ mbœrœ o'o á ɓœ pa fœ 'a nene. 'A sœ dœ kœyindœrœ ga ndœ ye mbœrœ 'a dji ndje o'o á tshe pa dœ tœ ye. Yé 'a wusœ nœ adœke œshe kœdœ adja ayi kœshe azu tshapashɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Manda kœlo olo bisha kpœtœmœ, Yisu áafo œ na ga lœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tshe pa lima dœ tœ ye adœke: «Azu lɨlɨsœ ayi kœgbara o'o ɓa lœ ogo nœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɔlɔ á tshe wuta ga lœ Galilayi, azu sœ dœ yanga mbœrœ kœwuta she ga lœ ogo nœ endje; mbœrœ á endje na ndje lima ndœ angbo pake ɓa lœ Yerusaleme, yé œ wu œrœ kɔ á tshe mbœrœ lima. ");
INSERT INTO kxf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tshe kwa lima tœ ye ga lakpɨ Kanana lœ ogo Galilayi ɓa tœ osho á tshe fa lima ungu tœ vinu. Ɓa zœ, anga gbozu tshapa akwa nœ lita bale lakpɨ Kaparnawumu sœ lima dœ gbolo yakoshe nœ ye á tshe sœ dœ koɓa. ");
INSERT INTO kxf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɔlɔ á tshe dji adœke Yisu to ɓa lœ ogo Yuda œ na ga lœ Galilayi, tshe na ga ndœ ye, yé œ kɨ fœ she adœke tshe na œ she gbolo nœ œne á tshe yindœ kœtshu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yisu kœpa fœ she adœke: «Œdœ 'e kœdjidji má ndœ ambárá afá œdœ pe ɔtshɔ akwa á azu pandœ nœ gooo asœke nene, 'e sœ má dœ kœyindœrœ ga ndœ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yé gbozu akwa nœ litanœ pa fœ she adœke: «Gbozu, wuta ga ndœ mœ utshunœ adœke gbolo nœ mœ kœtshu.» ");
INSERT INTO kxf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yisu kœgi fœ she adœke «Gu zœ, gbolo nœ zœ she ye.» Yakoshe kœyindœ o'o á Yisu pa fœ she, yé œ gu da ye. ");
INSERT INTO kxf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tshe sœ damba tœ awa kœgu she atake, aayi akwa nœ ye kœna para tshatshu ye á kœpa fœ she adœke: «Gbolo nœ zœ she ɓamama ye.» ");
INSERT INTO kxf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tshe yu endje adœke, gbolo nœ œne she dœ ada ɔlɔ gaɗe e? Endje kœpa fœ she adœke: «Ada ɔlɔ bale manda kakpi ɔlɔ libi dá koɓanœ katœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aba gbolonœ kœwusœ nœ adœke kolœ dœ ada ɔlɔnœ asœmœ libi dá Yisu pa fœ œne adœke: «Gbolo nœ zœ she ye.» Ataa, œshe dœ pe azu tshasœnda nœ ye kɔ endje sœ dœ kœyindœrœ ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Asœ kœdœ bisha ambárá afá á Yisu mbœrœ lɔkɔ á tshe to ɓa lœ Yuda á kwatœ ye ga lœ ogo Galilayi. ");
INSERT INTO kxf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Manda nœ, anga angbo nœ Ayuda sœ lima ɓa lœ Yerusaleme, yé Yisu na ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Andaa ɓa lœ ongbonœ, endje dji lima ungu kœdjutɔ kotœ azu á ɨ'ɨrɨnœ dœ o'o ama Ayuda kœdœ Betezata ndoo dœ manda gbagba nœ apata. Awa kœna ga tœ ungunœ sœ lima mindu, ");
INSERT INTO kxf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","yé aayi koɓa ndjoro lo lima lœ ala awanœ asœmœ: Ayibula, azu á tshakala ada endje ndɨ œdœ pe endjeneke á ada endje tshu. Endje sœ lima kœkate yakpa ungunœ kœturu tœnœ; ");
INSERT INTO kxf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","gbambanœ nene, anganœ andjelu sœ lima kœjerœ tœnœ yé œ sœ lima kœturu tœ ungu. Yekane ali ayi koɓa á tshe kœjerœ ga lœ yakpa ungunœ, tshe she lima lœ koɓa nœ ye. Œdœ koɓanœ kœdœ lima koɓa gaɗe gbaa, œ katœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Anga yakoshe bale á tshe lo lima dœ koɓa ngbugu zazu bale dœ ndjokpa dœ mindu dœ amanœ votɔ (38) sœ lima kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisu wu she á tshe lo ga atɨ yé kœdji adœke œndœ ye dɨ dœ koɓa tɔpanœ kpuru, tshe kœpa fœ she adœke: «Ɓœ yindœ kœshe tœnœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ayi koɓanœ kœgi o'o fœ she adœke: «Gbozu, mœ gugu dœ uzu á tshe kœnduru mœ ga la ngunœ lɔkɔ á yakpa ungunœ œ tetœ kœmbœrœ tœnœ nene. Mœ kœgea œrrr adœke mœ wuta ga zœ atake, anga uzu jerœ ga la nœ utshu mœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yisu pa fœ she adœke: «Aalafo, œ za kondja nœ zœ œ na ana.» ");
INSERT INTO kxf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Trale ayi koɓa kœshe ye. Tshe áafo, œ za kondja nœ ye, yé œ tetœ ana. Andaa œrœnœ asœmœ kɔ mbœrœ lima tœ endje dœ lɔkɔ sabata. ");
INSERT INTO kxf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ayuda kœpa fœ uzunœ á Yisu she she adœke: «Asœke kœdœ lɔkɔ sabata, œ lili adœke ɓœ za kondja nœ zœ yé œ na ana dœ tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kashe tshe gi fœ endje adœke: «Uzunœ á tshe she mœ lœ koɓanœ asœke, œshe dá pa fœ mœ adœke mœ za kondja nœ mœ, yé œ na ana.» ");
INSERT INTO kxf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Endje kœyu she adœke: «Yakoshenœ á tshe pa fœ ɓœ adœke ɓœ za kondja nœ zœ, yé œ na ana asœmœ kœdœ œɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kashe ayikoɓanœ á Yisu she she kpa wuwu lima sœ ye nene mbœrœ tshe wuta lima œnœ ye lœ ukpulu azunœ á endje sœ lima kpœtœmœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Œrrr manda nœ, Yisu kœgbɔ she ɓa lœ anda Tepelo á kœpa fœ she adœke: «Wu, ɓœ she ngɔngɔ asœ ye. Kpa mbœmbœrœ ekperœ nene kparawa adœke ɓœ kpa gbɔ anga ɔgbɔ koɓa kœropa œneke nene.» ");
INSERT INTO kxf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yakoshe kœna, œ kœpandœ nœ fœ Ayuda adœke Yisu dá she œne. ");
INSERT INTO kxf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kotœ lœ kumunœ, Ayuda para lima awa kœza o'o fœ Yisu mbœrœ á tshe mbœrœ œrœnœ asœmœ dœ lɔkɔ Sabata. ");
INSERT INTO kxf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kashe Yisu pa fœ endje adœke: «Aba mœ sœ kœmbœrœ akwa œrrr kpesheke, yé œmœ ndje mœ sœ tœ kœmbœrœ akwa.» ");
INSERT INTO kxf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Manda o'onœ á tshe pa asœmœ, Ayuda para lima awa adœke œne wo she. Œ dœ́dœ́ kolœ mbœrœ á tshe mbœrœ akwa dœ lɔkɔ sabata nene, kashe mbœrœ á tshe pa ndje adœke Ndjaba kœdœ adja Aba œne, á zatœ ye adœke œne li dœ she. ");
INSERT INTO kxf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yisu za o'o yé œ pa fœ endje adœke: «Mœ pa fœ e dœ adjapu adœke, Gbolo nœ Ndjaba lili kœmbœrœ œrœ á to tœ lɔsu ye dœ tœ ye nene, kashe tshe mbœrœ œrœ á tshe wu abanœ kœmbœrœ tœnœ. Gbambanœ nene, œrœ á Aba œ mbœrœ dá Gbolo œ mbœrœ adja tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mbœrœ Aba yindœ Gbolo, tshe sœ kœyisœ œneke kɔ á tshe mbœrœ fœ she. Tshe kpa yisœ ogboro œrœ kœropa œneke fœ she adœke 'e kœwu, uvuru 'e kpa lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ɓata Aba œ she akuzu á za soro fœ endje, awa bale Gbolo œ za soro fœ azu neke á tshe yindœ kœza fœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aba œ wa ngbanga ga tœ uzu bale nene, kashe tshe za Gbolo nœ ye tœ gbozu kœwa ngbanga pa azu, ");
INSERT INTO kxf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","adœke azu kɔ lɨsœ Gbolo ɓata á endje lɨ ndje œsœ Abanœ. Uzu á tshe kœlɨlɨsœ Gbolo nene, tshe lɨlɨ ndje œsœ Abanœ á tshe vwa she nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Mœ sœ kœpa fœ 'e dœ adjapu adœke uzu á tshe dji o'o ama mœ, á tshe kœsœ dœ kœyindœrœ ga ndœ tsheneke á tshe vwa mœ asœke, uzunœ sœ dœ soro á ka nene. Mœ wa ɔgbɔ ngbanga ga tœ ye nene, kashe tshe wuta lœ kuzu, yé tshe sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mœ pa fœ 'e dœ adjapu adœke, lɔndɔnœ sœ kœna tœnœ, yé œ na ngɔngɔ asœ ye, akuzu œ dji tshama Gbolo nœ Ndjaba. Yé endjeneke á endje dji tshama ye, endje sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gbambanœ nene, ɓata Aba kœdœ soro dœ tœ ye, awa bale tshe za fœ Gbolo kœdœ soro dœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yé tshe za Gbolo tœ gbozu kœwa ngbanga pa azu mbœrœ œshe kœdœ Gbolo nœ uzu. ");
INSERT INTO kxf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Adja 'e koko ama 'e tɨ ɔsɔ nene! Gbambanœ nene, anga ɔlɔ sœ kœna tœnœ, á akuzu kɔ á endje sœ lœ koto œ dji tshama ye, ");
INSERT INTO kxf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","yeka endjeneke á endje mbœrœ lima ɔtshɔrœ, Ndjaba œ she endje mbœrœ kœgbɔ soro, kashe endjeneke á endje mbœrœ ekperœ, Ndjaba œ she endje adœke Gbolo nœ uzu wa ɔgbɔ ngbanga pa endje. ");
INSERT INTO kxf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Œmœ, mœ lili kœmbœrœ œrœ á to ɓa lɔsu mœ dœ tœ mœ nene. Mœ wa ngbanga kœli dœ œneke á mœ sœ kœdji tœnœ yé kœwa ngbanga nœ mœ sœ ndjii mbœrœ mœ sœsœ kœpara awa kœmbœrœ œrœ á to ɓa lɔsu mœ nene, kashe œneke á lɔsu ayi kœvwa mœ yindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Œdœ mœ kœpa o'o tœ upu nœ mœ dœ tœ mœ, uzu bale á tshe dji mœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kashe œdœ anga angbɨ uzu kœpa o'o tœ upu nœ mœ, mœ wusœ nœ adœke o'onœ á tshe pa tœ upu nœ mœ asœmœ dœ́ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'E vwa lima azu fœ Yowane, yé tshe pa lima o'o tœ upu nœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tœ œmœ, mœ sœsœ dœ ogo adœke uzu pa o'o tœ upu nœ mœ nene, kashe mœ sœ kœpa o'o ataa adœke 'e gbɔ kœshe. ");
INSERT INTO kxf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowane sœ lima ɓata miinda á endje ta owo ga tœ nœ yé á tshi. 'E yi lima ndœ kœsœ dœ yanga lœ anga osho tœ ɨshirɨ ye. ");
INSERT INTO kxf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Andaa, mœ sœ dœ anga œrœ á pa o'o tœ upu nœ mœ á ropa o'o á Yowane pa. Œtœnœ kœdœ akwa á Aba za fœ mœ adœke mœ mbœrœ. Mœ sœ kœmbœrœ tœnœ yé œtœnœ dá sœ kœpa o'o tœ upu nœ mœ adœke Aba vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Aba á tshe vwa mœ pa o'o tœ upu nœ mœ dœ tœ ye. Kashe bale 'e djidji tshama ye yé 'e wuwu tshatshu ye nene, ");
INSERT INTO kxf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","yé 'e sœsœ kœgbɔndœ o'o ama ye ga tœ lɔsu 'e nene mbœrœ á 'e sœsœ dœ kœyindœrœ ga ndœ ayi avwa nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'E sœ kœyamba Buku nœ Ndjaba mbœrœ á 'e gbe kœgbɔ soro á ka nene lœ awanœ: Andaa, œtœnœ dá sœ kœpa o'o tœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yé 'e yiyindœ kœna ga ndœ mœ yeka á kœgbɔ adja soro nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Mœ gbegbe adœke azu donga mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kashe mœ wusœ 'e ye. 'E sœsœ dœ kœyindœsho ga ndœ Ndjaba nene. ");
INSERT INTO kxf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aba mœ dá vwa mœ yé 'e vwaratœ 'e kœza osho kœsœ fœ mœ. Kashe œdœ anga uzu kœna dœ mara nœ ye dœ tœ ye bale, 'e za osho kœsœ fœ she ye. ");
INSERT INTO kxf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'E yindœ kœdonga kolœ anga 'e, yé á endje kœdonga ndje 'e. Kashe 'e papara awa adœke kolœ Ndjaba kœdonga 'e nene asœke, ataa 'e sœ má dœ kœyindœrœ ga ndœ mœ koto o? ");
INSERT INTO kxf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kashe 'e gbegbe adœke mœ va ɔtɔ 'e fœ Aba mœ nene. Kolœ Moyize á 'e ko lima lɔsu 'e ga tœ ye asœmœ, œshe dá va ɔtɔ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Œdœ 'e kœsœ dœ kœyindœrœ ga ndœ Moyize, 'e sœ má ndje dœ kœyindœrœ ga ndœ mœ mbœrœ tshe sú mbetinœ tœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kashe ɓata 'e yiyindœ o'o á tshe sú nene, 'e yi má ndœ o'o ama mœ koto o?» ");
INSERT INTO kxf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Manda nœ, Yisu zu ga atshi egerœ ungu adanga Galilayi á anga ɨ'ɨrɨnœ kœdœ ndje Tiberiade. ");
INSERT INTO kxf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Azu ndjoro sœ lima kœna manda ye mbœrœ á endje wu ambárá afá á tshe sœ lima kœmbœrœ tœnœ lœ kœshe aayi koɓa asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mbœrœ tœnœ atamœ, Yisu ɔ ga pa kaga yé œ sœ ga atɨ awa bale dœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Œ sœ lima ndoo dœ Pake á dœ́ angbo nœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisu mesho, œ wu azu ndjoro á endje sœ tœ kœna ga ndœ ye. Á kœyu Filipo adœke: «A yɔ kœzɨrœ kpœta yeka á to fœ azunœ asœke á endje kœzɨ a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tshe yu lima oshonœ ataa tœ kœwu lɔsu Filipo, gbambanœ nene, tshe wu lima sœ œrœ á li adœke tshe mbœrœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo kœgi fœ she adœke: «Œdœ a kœyɔ ndje kœzɨrœ mangba denari kama bisha gbaa, œ li adœke uzu dœ uzu gbɔ teasho teasho nene.» ");
INSERT INTO kxf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yé anga yambarœ bale á ɨ'ɨrɨ ye kœdœ Andere, aya Shimu Petro kœpa fœ she adœke: ");
INSERT INTO kxf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Anga ovoro gbolo yakoshe kpœke sœ dœ mapa mindu á endje mbœrœ dœ zuwa orje œdœ pe ageatshalangu bisha kashe œ li mbœrœ azunœ kɔkɔ asœke za a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yisu kœpa adœke: «'E pa fœ azu adœke endje lœ ga atɨ.» Yé endje kœsœ ga atɨ ga pa gusu á sœ lima yaba yaba kpœtœmœ. Ayakoshe sœ lima ga pa œrœ nœ́ kutu mindu (5.000). ");
INSERT INTO kxf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeka á Yisu ko mapanœ, á za avwala fœ Ndjaba, á kurutshelœnœ tœ azu á endje lœ lima kpœtœmœ. Tshe kpa ko ndje ageatshalangunœ, œ mbœrœ ndje awa bale, yé endje zɨ kœli dœ ogo nœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ɓata uvu azu su ye, Yisu pa fœ ayambarœ nœ ye adœke: «'E ngbɔɓa udu œrœ á sœpe manda endje ga tœnœ adœke anganœ teasho yiyiwa nene.» ");
INSERT INTO kxf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Endje ngbɔɓa ama udu œrœnœ, yé kingi ndjokpa dœ bisha sú dœ ndɨndɨ mapa manda azunœ á endje zɨ lima. ");
INSERT INTO kxf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Azu wu ambárá afá á Yisu mbœrœ asœmœ œ pa adœke: «Adjapu, tsheneke kœdœ adja ayi kœgbara o'o nœ Ndjaba á tshe sœ kœna ga pa ɔshɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ɓata á Yisu wu lima sœ nœ adœke endje yindœ kœna kœza œne tœ ɔgbɔnœ adœke œne te gbozugo, tshe gi lima tœ ye kpœtœmœ, yé œ ɔ dœ kutɨ ye ga pa kaga. ");
INSERT INTO kxf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lɔkɔ á osho tetœ kœte mburumburu, ayambarœ nœ ye jerœ ga tœ mangu egerœ ungu adanga, ");
INSERT INTO kxf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","endje ɔ lima ga lœ agba bale mbœrœ kœna ga lœ Kaparnawumu, ɓa atshi ungunœ. Osho bu lima ye, yé Yisu yiyi lima damba kumu ye ga ndœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Egerœ yugu na kpɨkpɨkpɨ, yé loko za tshalangu djigi. ");
INSERT INTO kxf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ayambarœ i kayi œ vwi endje tœ mangu ga tœ œrœ nœ́ kelometere ndoo dœ mindu too mindu dœ bale, á endje kœwu Yisu kœna pa ungu gutœnœ ga tœ egerœ agba, yé awa litœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Á Yisu kœpa fœ endje adœke: «Œmœ dœmœ, awa mbœmbœrœ 'e nene!» ");
INSERT INTO kxf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Endje yi lima ndœ nœ adœke tshe ɔ ga lœ egerœ agbanœ, kashe katsha, kumu egerœ agbanœ za ama osho ga tœ mangu á endje gbe lima kœna ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Osho kɔrɔpa nœ, azunœ ndjoro á endje sœpe lima ɓa atshi ungunœ wusœ nœ adœke egerœ agba sœpe bale yé Yisu ɔɔ lima ga lœ egerœ agba awa bale dœ ayambarœ nœ ye nene. Endje zu lima ungunœ dœ kutɨ endje. ");
INSERT INTO kxf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kashe anga ogboro agba to ɓa lakpɨ Tiberiade, yé œ na ndoo dœ oshonœ á endje zɨ lima mapa tœnœ manda kœza mershe nœ Gbozu Yisu fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lɔkɔ á ukpulu azu wu adœke Yisu œdœ ayambarœ nœ ye sœsœ kpœtœmœ nene, endje ɔ ga lœ ogboro agbanœ asœmœ œ ro ga lœ Kaparnawumu mbœrœ kœpara Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Endje gbɔ she ɓa atshi ungunœ, yé á yu she adœke: «Rabi, ɓœ wuta kpœke dœ ada ɔlɔ koto o?» ");
INSERT INTO kxf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yisu gi fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke, 'e para awa mœ mbœrœ á 'e zɨ mapa á le 'e, kashe 'e papara mœ mbœrœ á 'e wu ambárá afá á mœ mbœrœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Adja 'e mbœmbœrœ akwa mbœrœ kœgbɔ kœzɨrœ á ndɨ nene, kashe 'e mbœrœ akwa mbœrœ kœgbɔ kœzɨrœ á œndœnœ œ dɨ, yé á to soro á ka nene fœ azu. Gbolo nœ uzu dá to kœzɨrœnœ asœmœ fœ 'e mbœrœ œshe dá Aba dœ Ndjaba za she ga pa ngande tshagbozu.» ");
INSERT INTO kxf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Endje kœgi fœ she adœke: «Œ li adœke 'a mbœrœ gaɗe tœ kœmbœrœ akwa á Ndjaba yindœ nœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tshe kœgi fœ endje adœke: «Akwa á Ndjaba yindœ nœ adœke 'e mbœrœ, kœdœ kœsœ dœ kœyindœrœ ga ndœ tsheneke á tshe vwa she.» ");
INSERT INTO kxf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Endje kpa kœyu she adœke: «Kashe œɓœ a, ambárá afá gaɗe dá ɓœ mbœrœ yeka á 'a kœwu yekane á kœyindœ o'o ama zœ a? Akwa gaɗe dá ɓœ mbœrœ a? ");
INSERT INTO kxf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aata 'a zɨ liya mane ɓa lœ kpagagasho ɓata á endje sú ala Buku nœ Ndjaba adœke: “Tshe to kœzɨrœ á dœ mapa á to ɓa lafo fœ endje.”» ");
INSERT INTO kxf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yisu kœgi fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke, œ dœ́dœ́ Moyize dá to mapanœ á to liya ɓa lafo fœ 'e nene, kashe Aba mœ dá sœ kœto adja mapa á to ɓa lafo fœ 'e asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gbambanœ nene, kœzɨrœ á Ndjaba œ to, kœdœ œneke á to ɓa lafo yé á za soro fœ azu tshapashɔnœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Azunœ kœpa fœ she adœke: «Gbozu, to kolœ kœzɨrœnœ asœmœ sheko fœ 'a.» ");
INSERT INTO kxf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yé Yisu kœpa fœ endje adœke: «Œmœ kœdœ kœzɨrœ á za soro fœ azu. Uzu á tshe kœna ga ndœ mœ, ogo œ mi she bale nene yé uzu á tshe sœ dœ kœyindœrœ ga ndœ mœ, ogo ungu kpa mi she bale nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kashe mœ pa fœ 'e adœke: 'E wu mœ tako, yé 'e sœsœ dœ kœyindœrœ ga ndœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Azu neke á Aba ko endje fœ mœ, endje na ga ndœ mœ yé uzu á tshe na ga ndœ mœ, mœ za bala she vwi'i nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gbambanœ nene, mœ toto ɓa lafo œ jerœ tœ kœmbœrœ œrœ á lɔsu mœ yindœ nœ nene, kashe mœ na mbœrœ kœmbœrœ œneke á lɔsu ayi kœvwa mœ yindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Œrœ á lɔsu ayi kœvwa mœ yindœ nœ adœke mœ mbœrœ dœke: Adja anga uzu bale ugurutœ azu á tshe ko endje fœ mœ yiyiwa nene kashe mœ she endje lœ kuzu dœ ndɔngɔlɔ olo. ");
INSERT INTO kxf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Œrœ á lɔsu Aba mœ yindœ nœ kœdœ adœke, uzu á tshe kœwu gbolo nœ ye, á kœsœ dœ kœyindœrœ ga ndœ ye, tshe gbɔ soro á ka nene, yé mœ she she lœ akuzu dœ ndɔngɔlɔ olo.» ");
INSERT INTO kxf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tɨ kpœtœmœ, Ayuda kœtetœ kœpulœma endje mbœrœ o'o á Yisu pa adœke: «Œmœ kœdœ kœzɨrœ á to ɓa lafo, yé á jerœ.» ");
INSERT INTO kxf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Endje kœpa adœke: «Œ dœ́dœ́ Yisu dœke na a, gbolo nœ Yozefu a? Á 'a wusœ abanœ dœ ayinœ ndje na a? Kotoo á tshe pa ngɔngɔ asœke adœke œne to ɓa lafo á jerœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yisu kœgi fœ endje adœke: «'E katœ kœpulœma 'e ugurutœ 'e ye na! ");
INSERT INTO kxf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Uzu bale œ li kœna ga ndœ mœ nene œdœ Aba á tshe vwa mœ kœtoto she na tœnœ nene, yekane á mœ kœshe she lœ akuzu dœ ndɔngɔlɔ olo. ");
INSERT INTO kxf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Endje sú ala mbeti nœ aayi kœgbara o'o adœke: “Ndjaba œ yisœ œrœ fœ azu kɔkɔ.” Uzu kɔ á tshe dji Aba, á yindœ œrœ á tshe yisœ nœ, tshe na ga ndœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Œ yindœ kœpa adœke uzu bale wuwu Aba nene, kolœ tsheneke á tshe to ɓa ndœ Ndjaba; œshe dá wu Aba. ");
INSERT INTO kxf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mœ sœ kœpa fœ 'e dœ adjapu adœke uzu tsheneke á tshe kœsœ dœ kœyindœrœ ga ndœ mœ, tshe sœ dœ soro á ka nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Œmœ kœdœ kœzɨrœ á za soro fœ azu. ");
INSERT INTO kxf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aata 'e zɨ liya mane ɓa lœ kpagagasho, yé endje tshu lima ye. ");
INSERT INTO kxf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Asœ kœdœ kœzɨrœ á to ɓa lafo á jerœ adœke, uzu á tshe kœzɨ, tshe tshu bala nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Œmœ kœdœ kœzɨrœ á za soro fœ azu, œ to ɓa lafo á jerœ asœke. Uzu á tshe kœzɨ kœzɨrœnœ asœke, tshe sœ bala dœ soro á ka nene. Kœzɨrœnœ á mœ za fœ she kœdœ songba mœ. Mœ za adœke tshapashɔ gbɔ soro.» ");
INSERT INTO kxf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kolœ pa o'o asœke, ayuda te lima tœ kœyutœ endje ugurutœ endje dœ ɔgbɔ adœke: «Kotoo á uzunœ asœke pa adœke œne za songba œne fœ azœ yekane á kœzɨ a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yisu kœpa fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke œdœ 'e kœzɨzɨ songba Gbolo nœ uzu yé œ ndjo pe indji ye nene, 'e sœ dœ soro lœ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Uzu tsheneke á tshe zɨ songba mœ, á ndjo ndje indji mœ, sœ dœ soro á ka nene, yé œmœ mœ she she lœ kuzu dœ ndɔngɔlɔ olo. ");
INSERT INTO kxf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gbambanœ nene, songba mœ kœdœ adja kœzɨrœ, yé indji mœ kœdœ adja kœndjorœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Uzu á tshe zɨ songba mœ á ndjo indji mœ, sœ lœ mœ yé œmœ mœ sœ ndje lœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yé ɓata Aba á tshe vwa mœ sœ dœ soro á mœ sœ dœ soro lœ awa nœ ye, ataa uzu á tshe kœzɨ songba mœ, tshe gbɔ soro lœ awa nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Asœ kœdœ kœzɨrœ á to ɓa lafo á jerœ. Œ sœsœ ɓata kœzɨrœ á aata 'e zɨ liya nene. Mbœrœ endje zɨ liya kœzɨrœ asœmœ yé endje tshu. Kashe uzu á tshe zɨ kœzɨrœnœ asœke, tshe sœ dœ soro á ka nene.» ");
INSERT INTO kxf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisu pa lima o'onœ asœke ɓa lœ Kaparnawumu, lɔkɔ á tshe sœ lima tœ kœyisœ œrœ ɓa lœ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Manda kœdji she, ɨlɨ ayambarœ nœ ye tetœ kœpa adœke: «O'onœ asœ gbɔɔgbɔ, adja œɗe dá dji a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kashe ɓata á Yisu wu lima sœ nœ adœke ayambarœ nœ œne sœ tœ kœpulœma endje, tshe pa fœ endje adœke: «Mbœrœ gaɗe á o'onœ asœke ndjingɨvwɨ tshelœ kumu 'e a? ");
INSERT INTO kxf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Œ kœsœ má adœke 'e wu Gbolo nœ uzu kœ ɔ ga tœ osho á tshe to lima tœnœ, œ sœ koto o? ");
INSERT INTO kxf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɨshirɨ dá za soro fœ azu. Ɔkɔ lili tœ kœmbœrœ œrœ ataa nene. O'onœ á mœ pa fœ 'e asœke kœdœ Ɨshirɨ œdœ pe soro. ");
INSERT INTO kxf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kashe kolœ ugurutœ 'e asœke, anga endje á endje yiyindœ o'o ama mœ nene, endje lœ zœ.» Gbambanœ nene, Yisu wu lima sœ endjeneke á endje sœsœ dœ kœyindœrœ nene œdœ pe tsheneke á tshe ka bala she. ");
INSERT INTO kxf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Á tshe kpa kœpa adœke: «Adja ádánœ á mœ pa fœ 'e adœke uzu bale œ na ga ndœ mœ nene œ kœdœ́dœ́ Aba dá za awa fœ she kœna tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kœto kpœtœmœ, ɨlɨ anga ayambarœ nœ ye gitœ endje manda ye, yé œ katœ kœna tœ awa bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Á Yisu kœyu ayambarœnœ ndjokpa dœ bisha adœke: «Ka e'e nœ 'e a, 'e gigitœ 'e nœ 'e nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yeka á Shimu Petro kœgi fœ she adœke: «Gbozu, 'a kpa na má ga ndœ uzu ɗe? Œɓœ dá sœ dœ o'onœ á za soro á ka nene. ");
INSERT INTO kxf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","'A sœ dœ kœyindœrœ, yé 'a wusœ nœ adœke œɓœ kœdœ Œyerœ Uzu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yisu pa fœ endje adœke: «Œmœ dá ke 'e ndjokpa dœ bisha kashe ugurutœ 'e kɔ, anga uzu bale kœdœ djaboro.» ");
INSERT INTO kxf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tshe sœ lima kœpa tœ Yudasi, gbolo nœ Shimu Isikariote mbœrœ œshe kœdœ lima uzu á tshe ka Yisu. Œshe kœdœ lima anga yambarœ ugurutœ andjokpa dœ bishanœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Manda nœ, Yisu sœ lima kœna lœ ogo Galilayi. Tshe yiyi lima ndœ kœna lœ ogo Yuda nene mbœrœ Ayuda sœ lima kœpara awa ndœ kœwo she. ");
INSERT INTO kxf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Andaa angbo nœ ayuda á dœ angbo gbanda tande ndo lima ye. ");
INSERT INTO kxf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aaya Yisu kœpa fœ she adœke: «Gitœ zœ kpœke, yé œ na ga lœ ogo Yuda adœke ayambarœ nœ zœ wu ndje akwa á ɓœ sœ tœ kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Uzu mbœmbœrœ œrœ lœ ubunœ nene œdœ tshe kœgbe adœke azu wusœ œne. Ɓata á ɓœ sœ kœmbœrœ akwa atake, matœ zœ dœ tœnœ ga ushu tshapashɔ wusœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gbambanœ nene, aayanœ dœ tœ endje sœsœ lima dœ kœyindœrœ ga ndœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yisu kœpa fœ endje adœke: «Ɔlɔ nœ mœ tɔtɔ damba nene. Tœ e'e nœ 'e, ɔlɔ kɔ sœ dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tshapashɔ œ li tœ kœyiangba 'e nene, kashe œmœ, œ yiangba mœ mbœrœ á mœ sœ kœpandœ nœ ngbɨ adœke akwa nœ ye sœ tœ ekpenœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","'E ɔ ndœ angbonœ zœ. Kashe œmœ, mœ ɔ ga zœ nene mbœrœ ɔlɔ nœ mœ tɔtɔ damba nene.» ");
INSERT INTO kxf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Manda kœpa o'onœ ataa, tshe sœpe lima tɨ lœ Galilayi. ");
INSERT INTO kxf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lɔkɔ á aayanœ áafo á ro ndœ angbonœ da ye, Yisu áalafo yaa œ na ndje ga zœ dœ mara adœke azu wuwusœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dœ lɔkɔ á ala angbonœ doro, agbozu Ikrizia sœ lima kœpara she yé endje sœ lima kœyu osho adœke: «Tshe sœ kpœta a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Endje ndɨvwɨrɨ lima o'o waa tœ upu nœ ye. Anga azu pa lima adœke: «Uzunœ asœke kœdœ ɔtshɔ uzu.» Yé anga endje pa ndje adœke: «Œ̃ œ̃ nene, œshe kœdœ ayi kœdjingili tshelœ kumu azuzu.» ");
INSERT INTO kxf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yé uzu bale papa o'o o'ara tœ upu nœ ye nene mbœrœ á endje lœ lima dœ awa agbozu Ikrizia. ");
INSERT INTO kxf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kœwu adœke tshelœ angbonœ za, Yisu na lima ga lœ anda Tepelo, yé œ tetœ kœyisœ œrœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Uvuru Ayuda kpa lima lœnœ, yé endje pa lima adœke: «Uzunœ asœ dɨdɨ œrœ nene, yé kotoo á tshe sœ dœ kœwusœrœ tshaata a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yisu kœgi o'o fœ endje adœke: «Œrœnœ á mœ sœ kœyisœ nœ asœke toto ɓa ndœ mœ nene, kashe œ to ɓa ndœ tsheneke á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Œdœ uzu kœgbe kœmbœrœ œrœneke á Ndjaba yindœ nœ, tshe wusœ nœ adœke kœyisœrœnœ asœke to ɓa ndœ Ndjaba, too mœ sœ kœpa o'o tœ upu nœ mœ dœ tœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Uzu á tshe sœ kœpa o'o tœ upu nœ ye dœ tœ ye, tshe sœ kœpara awa adœke azu donga œne. Kashe uzu tsheneke á tshe sœ kœpara awa adœke azu donga ayi kœvwa she, tshe kœdœ uzu nœ adja o'o, yé ekperœ gugu lœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Œ dœ́dœ́ Moyize dá za liya awa akwa fœ 'e nene a? Kashe uzu bale ugurutœ 'e á tshe sœ kœmbœrœtœ ye liakanœ gugu nene. Mbœrœ gaɗe á 'e sœ kœpara awa ndœ kœwo mœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Á ukpulu azunœ kœpa fœ she adœke: «Ekpe ɨshirɨ sœ pa zœ a! Œɗe dá sœ kœpara awa ndœ kœwo ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yisu kpa kœza o'o á kœpa fœ endje adœke: «Mœ mbœrœ kolœ akwa bale yé œvuru 'e kɔkɔ kpa lœnœ ataa! ");
INSERT INTO kxf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyize za liya o'o fœ 'e adœke 'e wa agbolo yakoshe nœ 'e tœ gaza. Œ dœ́dœ́ Moyize kœdœ ali uzu kœmbœrœ tœnœ nene, kashe œ to liya ɓa ndœ aata 'e, yé 'e sœ kœza ga tœ akwa dœ lɔkɔ Sabata. ");
INSERT INTO kxf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Á 'e kœwu adœke kœwa anga gbolo yakoshe dœ lɔkɔ Sabata kœndɨndɨ awa akwa nœ Moyize nene, mbœrœ gaɗe á 'e so ókó ga tœ mœ mbœrœ á mœ she uzu djigi dœ lɔkɔ sabata a? ");
INSERT INTO kxf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'E katœ kœwa ngbanga liaka œrœ á 'e wu dœ ala 'e ye, kashe 'e wa ngbanga dœ mara á sœ ndjii kane.» ");
INSERT INTO kxf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Anga azu lœ Yerusaleme sœ lima kœpa adœke: «Œ dœ́dœ́ uzunœ á endje sœ kœpara she á kœwo she dœke nene a? ");
INSERT INTO kxf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","'E wu, œshe dá pa o'o o'ara o'ara á uzu kœpa o'o fœ she gugu nene asœke! Ataa agbozu tshapa azœ wu ete œsœnœ adœke œshe kœdœ Kristu ye na a? ");
INSERT INTO kxf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Andaa a wusœ osho á yakoshenœ asœke to tœnœ ye, kashe Kristu, uzu bale œ wu bala sœ osho á tshe to tœnœ á yi kumu ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeka á Yisu á tshe sœ lima kœyisœ œrœ lœ anda Tepelonœ pa adœke: «'E wusœ mœ ye! 'E wu ndje sœ osho á mœ to tœnœ ye! Mœ nana dœ tœ mœ nene. Tsheneke á tshe vwa mœ, tshe kœdœ adja o'o; œshe á 'e wuwusœ ye nene asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Œmœ, mœ wusœ ye mbœrœ á mœ to ɓa ɨndɨrɨ ye, yé œshe dá vwa mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Endje para lima awa kœtepa ye kashe uzu bale toto lima kane ye ga tœ ye nene mbœrœ á olo ye lili damba lima nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Azu ndjoro lœ ukpulu azunœ sœ lima dœ kœyindœrœ ga ndœ ye. Endje pa lima adœke: «Lɔkɔ á Kristu œ na, tshe mbœrœ ambárá afá kœropa œneke á tsheneke œ mbœrœ asœke ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Œneke á ukpulu azu sœ kœpulœma endje tœ upu nœ ye li ga lœ utu Afarisayi. Ataa, agbozu tshapa anganga Ndjaba œdœ Afarisayi vwa lima atshendjerœ nœ endje ndœ kœna kœtepa ye. ");
INSERT INTO kxf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yisu kœpa fœ endje adœke: «Mœ sœpe dœ 'e manda olo teasho, yé manda nœ, mœ gu ga ndœ tsheneke á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'E para bala mœ kashe 'e gbɔ mœ nene. Gbambanœ nene, osho á mœ sœ tœnœ, 'e li kœna ɓa zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayuda kœte lima tœ kœyutœ endje ugurutœ endje adœke: «Tshe na má gata yekane á a gbɔ she nene a? Tshe na manda azunœ á endje ndjɔtshelœtœ endje djelœ angbɨ azu a? Tshe na ndœ kœyisœ œrœ fœ angbɨ azunœ a? ");
INSERT INTO kxf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ádá o'onœ á tshe pa asœke kœdœ gaɗe: 'E para bala mœ, kashe 'e gbɔ mœ nene. Yé osho á mœ sœ tœnœ, 'e li kœna ɓa zœ nene!» ");
INSERT INTO kxf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ndɔngɔlɔ olo kœka angbo kœdœ ɓalima ɨkpɨlɨ olo angbonœ. Dœ ɔlɔnœ asœmœ, Yisu ka lœ angbonœ œ tetœ kœmɨndœ o'o adœke: «Œdœ uzu kœsœ dœ ogo ungu, kaka tshe na ga ndœ mœ yé œ ndjo. ");
INSERT INTO kxf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Uzu á tshe kœsœ dœ kœyindœrœ ga ndœ mœ, egerœ ungu á za soro œ tara tœ lɔsu ye, ɓata á endje sú ala Buku nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisu pa lima o'onœ asœ tœ upu nœ Ɨshirɨ á azu á endje sœ dœ kœyindœrœ ga ndœ ye œ gbɔ má. Yé Ndjaba zaza lima damba awa fœ azu kœgbɔ Ɨshirɨnœ nene mbœrœ Ndjaba gigi mokɔ nœ ye fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Manda kœdji o'onœ asœke, anga azu lœ ukpulu azunœ pa lima adœke: «Adja tsheneke kœdœ ayi kœgbara o'o tako.» ");
INSERT INTO kxf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Anga endje pa lima adœke: «Kristu dœmœ.» Kashe anga udu endje pa ndje lima adœke: «Adja Kristu œ li kœwuta lœ Galilayi a? ");
INSERT INTO kxf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buku nœ Ndjaba papa adœke tshe wuta bala lœ aata Davidi yé œ sœ ɓa lakpɨ Beteleme ogo obo Davidi nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ataa, azu kuru lima tshelœtœ endje kpœ lœ kumu Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Anga endje yi lima ndœ kœtepa ye kashe uzu bale toto lima kane ye ga tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Atshendjerœ gu lima ga ndœ agbozu tshapa anganga Ndjaba œdœ pe Afarisayi á endje pa fœ endje adœke: «Mbœrœ gaɗe á 'e gugu dœ she nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Atshendjerœ kœgi adœke: «Bale anga uzu papa o'o ɓata yakoshe asœmœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afarisayi kœpa fœ endje adœke: «E'e kɔ, tshe djingili ndje tshelœ kumu 'e a? ");
INSERT INTO kxf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Œdœ ugurutœ agbozu Ikrizia œdœ ugurutœ Afarisayi, anga uzu bale wuta dœ kœyindœrœ ga ndœ ye ye a? ");
INSERT INTO kxf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Azunœ ndjoro asœmœ, anga bale á tshe wusœ awa akwa gugu nene. Azu á endje darandœ endje dœmœ!» ");
INSERT INTO kxf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kashe anga uzu bale ugurutœ Afarisayi á ɨ'ɨrɨ ye kœdœ Nikodeme, œshe á tshe na lima utshunœ ga ndœ Yisu, pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Awa akwa nœ azœ wawa ngbanga ga tœ uzu utshu kœdji she too kœwusœ œrœ á tshe mbœrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Á endje kœyu she adœke: «Atamœ œɓœ kœdœ uzu Galilayi, œɓœ ndje a? Mirœ tshelœ zœ dœ ɔtshɔnœ yé ɓœ wusœ nœ adœke ayi kœgbara o'o wuwuta bale lœ ogo Galilayi nene.»  ");
INSERT INTO kxf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Manda nœ, uzu dœ uzu gu ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kashe Yisu ɔ lima ga pa kaga á ɨ'ɨrɨnœ kœdœ kaga ɔyɔ Olive. ");
INSERT INTO kxf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ɔlɔ á osho kɔrɔ, Yisu kwatœ ye ga lœ anda Tepelo. Ɓata azu ndjoro na lima ga ndœ ye, tshe sœ ga atɨ, œ tetœ kœyisœ œrœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aayi kœyisœ awa akwa œdœ pe Afarisayi za anga yashe bale na tœnœ fœ Yisu. Endje gbɔ yashenœ asœmœ kœlo dœ yakoshe á tshe dœ́dœ́ akɔnœ nene, yé á za she tɔ ɓa ugurutœ azu. ");
INSERT INTO kxf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Endje kœyu Yisu adœke: «Ayi kœyisœrœ, 'a ɔ pa yashe asœke endje sœ kœlo dœ yakoshe á tshe dœ́dœ́ akɔnœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ala awa akwa, Moyize za awa fœ 'a adœke 'a ve mara yashe atake dœ badja. Ataa, ɓœ pa œnœ zœ kotoo?» ");
INSERT INTO kxf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Endje yu lima Yisu á kœwu lɔsu ye yeka á kœtɔ meza pa ye. Kashe Yisu djo ga atɨ, œ tetœ kœwa œrœ ga lœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɓata endje yɔrɔ lima pa kœyu she kpala kpala, Yisu áafo œ pa fœ endje adœke: «Uzu á tshe kœmbœmbœrœ ekperœ bale nene, tshe ve yashe asœke dœ badja utshunœ.» ");
INSERT INTO kxf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tshe kpa djo ga atɨ yé œ sœ kolœ tœ kœwa œrœ ga lœ ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lɔkɔ á endje dji o'o á Yisu pa asœmœ, endje te lima tœ kœgitœ endje bale dœ bale kœto tœ agbozu, yé Yisu sœpe lima kutɨ ye. Ɓata á yashenœ á endje kpa lima dji she sœpe lima kpœtœmœ, ");
INSERT INTO kxf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisu áafo yé œ pa fœ she adœke: «Yashe, endje sœ kpœta a? Uzu bale wawa ngbanga ga tœ zœ nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tshe kœgi adœke: «Uzu bale nene, Gbozu.» Á Yisu kœgi fœ she adœke: «Œmœ ndje awa bale, mœ wa ngbanga ga tœ zœ nene. Gu zœ, kashe kpa mbœmbœrœ ekperœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisu kpa pa fœ endje adœke: «Œmœ kœdœ ɨngbɨsho nœ tshapashɔ. Uzu á tshe na manda mœ, tshe na lœ ubu osho nene, kashe tshe gbɔ ɨngbɨsho á za soro fœ azu.» ");
INSERT INTO kxf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afarisayi kœpa fœ she adœke: «Ɓœ sœ kœpa o'o tœ zœ dœ tœ zœ, yé o'onœ á ɓœ pa dœ́dœ́ adja o'o nene.» ");
INSERT INTO kxf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yisu kœgi fœ endje adœke: «Œ sœ tako adœke mœ sœ kœpa o'o tœ mœ dœ tœ mœ, kashe o'onœ á mœ sœ kœpa tœ mœ asœmœ kœdœ adja o'o, mbœrœ mœ wusœ osho á mœ to tœnœ œdœ pe osho á mœ sœ kœna ga tœ nœ. Kashe e'e, 'e wuwusœ osho á mœ to tœnœ œdœ pe osho á mœ sœ kœna ga tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'E sœ kœwa o'o adja ɓata azu, kashe œmœ, mœ wa o'o pa uzu bale nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yé œ kœli adœke mœ wa o'o, mœ wa o'onœ liaka adja o'o mbœrœ mœ sœsœ dœ kutɨ mœ nene: Ayi kœvwa mœ sœ ndje dœ mœ awa bale. ");
INSERT INTO kxf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Endje sú ala awa akwa nœ 'e adœke, œdœ azu bisha kœpa kolœ o'o bale dœ ádá œrœ, o'onœ á endje pa asœmœ kœdœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mœ sœ kœpa o'o tœ mœ dœ tœ mœ, yé Aba á tshe vwa mœ sœ ndje kœpa o'o tœ upu nœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Endje kpa kœpa fœ she adœke: «Aba zœ sœ kpœta a?» Yisu kœgi fœ endje adœke: «'E wuwusœ mœ nene yé 'e wuwusœ Aba mœ nene. Œdœ 'e kœwu má sœ mœ, 'e wu má ndje sœ Aba mœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisu pa lima o'onœ asœke ɔlɔ á tshe sœ lima kœyisœ œrœ ɓa lœ anda Tepelo ɓa tœ osho á endje ko ngendja makabo ga tœnœ. Uzu bale toto lima kane ye ga tœ ye nene mbœrœ olo ye lili lima damba nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisu kpa pa fœ endje adœke: «Mœ gu da ye, 'e para bala mœ kashe 'e tshu lœ ekperœ nœ 'e. Osho á mœ na ga tœnœ, 'e li kœna ɓa zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayuda kœyu lima tœ endje ugurutœ endje adœke: «Tshe sœ dœ gbetshelœ nœ kœwotœ ye dœ tœ ye a? Mbœrœ á tshe pa adœke: “Osho á mœ na ga tœnœ, 'e li kœna ɓa zœ nene a?”» ");
INSERT INTO kxf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yisu kœpa fœ endje adœke: «E'e kœdœ azu tshaatɨ, œmœ kœdœ uzu tshalafo. 'E kœdœ azu tshapashɔnœ asœke, kashe mœ dœ́dœ́ uzu tshapashɔnœ asœke nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mbœrœ tœnœ dá mœ pa fœ 'e adœke 'e tshu lœ ekperœ nœ 'e. Gbambanœ nene, œdœ 'e kœyiyindœ nœ adœke œmœ, mœ sœ zœ nene, 'e tshu lœ ekperœ nœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Endje kœyu Yisu adœke: «Œɓœ kœdœ uzu œɗe e?» Yé tshe kœgi fœ endje adœke: «Œmœ kœdœ tsheneke á mœ pa o'o fœ 'e katshatsha utshunœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mœ sœ dœ o'o ndjoro kœpa œdœ pe kœwa tœ upu nœ 'e. Kashe tsheneke á tshe vwa mœ kœdœ uzu nœ adja o'o yé œneke á mœ dji ɓa ndœ ye, œtœnœ dá mœ sœ kœpa fœ tshapashɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Endje wuwu lima sœ nœ nene adœke Yisu sœ lima kœpa o'onœ fœ œne tœ Aba. ");
INSERT INTO kxf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yisu kpa kœpa fœ endje adœke: «Ɔlɔ á 'e tshi Gbolo nœ uzu ga lafo, 'e wusœ nœ adœke “œmœ, mœ sœ zœ”. 'E wu ndje sœ nœ adœke mœ mbœmbœrœ œrœ bale dœ tœ mœ nene, kashe mœ sœ kœpa o'o á Aba yisœ nœ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tsheneke á tshe vwa mœ sœ awa bale dœ mœ, tshe katœ mœ tɨ kutɨ mœ nene, mbœrœ mœ sœ kœmbœrœ kolœ œrœ á za yanga fœ she.» ");
INSERT INTO kxf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ɓata á Yisu sœ lima kœpa o'o ataa, azu ndjoro wuta lima dœ kœyindœrœ ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yisu pa fœ Ayuda á endje yi lima ndœ o'o ama ye adœke: «Œdœ 'e kœsœpe kœgbɔndœ o'o ama mœ ga tœ lɔsu 'e, 'e kœdœ adja ayambarœ nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ataa, 'e wusœ adja o'o tœ upu nœ Ndjaba yé adja o'onœ œ ko 'e lœ kanga ga ushu ye.» ");
INSERT INTO kxf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Endje kœpa fœ she adœke: «Abrayamo kœdœ ata 'a yé 'a dœ́dœ́ ɓalima akanga nœ uzu nene. Kotoo á ɓœ pa adœke 'a wuta lœ kanga ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yisu kœgi fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke, uzu kɔ á tshe sœ kœsœ kœmbœrœ ekperœ, kœdœ kanga nœ ekperœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kanga sœsœ waa lœ anda nene, kashe gbolo anda dá sœ waa. ");
INSERT INTO kxf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Œdœ Gbolo kœko 'e ga ushu lœ kanga, 'e wuta adja lœnœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mœ wusœ nœ adœke Abrayamo kœdœ ata 'e. Kashe 'e sœ kœpara awa kœwo mœ mbœrœ á 'e yiyindœ kœdji o'o ama mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mœ sœ kœpandœ œneke á mœ wu ɓa ndœ Aba mœ, yé 'e sœ kœmbœrœ œneke á aba 'e mɨndœ nœ fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Endje kœpa fœ she adœke: «Aba 'a kœdœ Abrayamo.» Yé Yisu kœpa fœ endje adœke: «Œdœ 'e kœdœ agbolo nœ Abrayamo, 'e mbœrœ akwa nœ Abrayamo. ");
INSERT INTO kxf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Andaa, 'e sœ ngɔngɔ asœ kœpara awa ndœ kœwo mœ, œmœ á mœ pa adja o'o á mœ dji ɓa ndœ Ndjaba. Abrayamo mbœmbœrœ œrœ á li dœ tœnœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kashe 'e, 'e sœ kœmbœrœ akwa nœ aba 'e.» Endje kœgi fœ she adœke: «'A dœ́dœ́ agbolo gugatɨ nene, 'a sœ kolœ dœ aba bale á tshe kœdœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Á Yisu kœpa fœ endje adœke: «Œdœ Ndjaba kœdœ má Aba 'e, 'e yi má ndœ mœ ye. Gbambanœ nene, mœ to ɓa ndœ ye yeka á na asœke. Mœ nana dœ tœ mœ nene kashe œshe dá vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mbœrœ gaɗe á 'e sœsœ kœdji tshelœ kata o'o nœ mœ nene a? Mbœrœ gaɗe á 'e lili kœdji o'o ama mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aba 'e, œshe kœdœ djaboro yé 'e sœ dœ ogo kœmbœrœ gbetshelœ nœ aba 'e. Tshe kœdœ ayi kœwo azu ɓalima katshatsha. Tshe papa adja o'o nene mbœrœ adja o'o gugu lœ ye nene. Lɔkɔ á tshe kœpa wala, mara kœpa o'o nœ ye dœmœ mbœrœ tshe kœdœ ayi wala œdœ aba wala. ");
INSERT INTO kxf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kashe œmœ, mœ pa œnœ mœ adja o'o yé mbœrœ tœnœ ataa, 'e sœsœ kœdji mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Uzu ɗe ugurutœ 'e kɔ dá li kœma adœke mœ mbœrœ ekperœ a? Yé œdœ mœ kœpa adja o'o, mbœrœ ga ɗe á 'e yiyindœ kœdji mœ nene a? ");
INSERT INTO kxf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Uzu tsheneke á tshe kœdœ uzu nœ Ndjaba, tshe dji o'o ama Ndjaba; ɓata 'e dœ́dœ́ azu nœ Ndjaba nene, 'e li kœdji o'o ama mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayudanœ gi fœ Yisu adœke: «Œdœ 'a kœpa fœ ɓœ adœke œɓœ kœdœ uzu Samariya yé ekpe ɨshirɨ sœ pa zœ, 'a pa wala dœmœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yisu gi fœ endje adœke: «Mœ sœsœ dœ ekpe ɨshirɨ pa mœ nene, kashe mœ sœ kœlɨsœ Aba mœ yeka á 'e vwaratœ 'e kœlɨsœ mœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mœ sœsœ kœpara ndje adœke azu donga mœ nene. Kashe anga uzu sœ zœ á sœ kœmbœrœ adœke azu donga mœ yé œshe dá sœ kœwa o'o. ");
INSERT INTO kxf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ uzu kœsœ kœgbɔndœ o'o ama mœ, tshe wu bala kuzu nene.» ");
INSERT INTO kxf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayudanœ kœpa fœ she adœke: «Ngɔngɔ asœ, 'a wusœ nœ adœke ekpe ɨshirɨ sœ pa zœ. Abrayamo tshu, aayi kœgbara o'o tshu ndje, yé œɓœ, ɓœ pa adœke: “Uzu á tshe kœgbɔndœ o'o ama zœ, tshe wu bala kuzu nene.” ");
INSERT INTO kxf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ɓœ gbe adœke ɓœ ropa aba 'a dœ Abrayamo á tshe tshu ye a? Œdœ ndje aayi kœgbara o'o á endje tshu, ataa adja ɓœ sœ kœzatœ zœ ɓata œɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Á Yisu kœpa fœ endje adœke: «Œdœ mœ kœsœ má kœdongatœ mœ dœ tœ mœ, kœdongatœsho nœ mœ œ sœ má gbambanœ. Aba mœ dá sœ kœdonga mœ, œshe á 'e sœ kœpa tœ ye adœke: “Tshe kœdœ Ndjaba nœ 'a”, ");
INSERT INTO kxf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","andaa 'e wuwusœ ye nene. Œdœ mœ kœpa adœke mœ wuwusœ ye nene, mœ tsha ayi wala ɓata 'e. Kashe mœ wusœ ye yé mœ sœ kœgbɔndœ o'o ama ye. ");
INSERT INTO kxf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aba 'e dœ Abrayamo sœ lima dœ yanga dœ agbe adœke œne wu olo kœzu dœ mœ. Tshe wu lima olonœ yé œ za lima yanga fœ she.» ");
INSERT INTO kxf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayudanœ kœgi fœ she adœke: «Ɓœ wuwuta damba dœ ungu zazu bisha dœ ndjokpa nene, yé ɓœ pa adœke ɓœ wu Abrayamo a?» ");
INSERT INTO kxf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Á Yisu kœgi fœ endje adœke: «Mœ sœ kœpa fœ 'e dœ adjapu adœke, utshu adœke endje zu Abrayamo, “mœ sœ zœ.”» ");
INSERT INTO kxf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ayudanœ kœko badja kœve dœ she, kashe Yisu zatœ ye yiwa tœnœ yé œ wuta lœ anda Tepelo ye. ");
INSERT INTO kxf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ɔlɔ bale, Yisu sœ kœro tœnœ yé œ wu anga yakoshe bale á endje zu she ala ye bu trale. ");
INSERT INTO kxf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ayambarœ nœ ye kœyu she adœke: «Rabi, mbœrœ gaɗe á endje zu yakoshe asœke trale ala ye bu a? Ataa, œ to lœ ekperœ nœ ye, too œ to lœ ekperœ nœ aayi kœzu she a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yisu kœgi fœ endje adœke: «Œ toto lœ ekperœ nœ ye too lœ ekperœ nœ aayi kœzu she nene. Kashe œneke wuta ga tœ ye mbœrœ á Ndjaba kœyisœ akwa nœ ye lœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ɓata á osho kɔrɔ, œ li adœke a mbœrœ akwa nœ uzu á tshe vwa mœ. Osho ndo tœ kœbu tœnœ, yé uzu bale kpa li tœ kœmbœrœ akwa nene. ");
INSERT INTO kxf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ɓata á mœ sœ damba pa tshapashɔ, œmœ kœdœ ɨngbɨsho nœ tshapashɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Manda kœpa o'onœ asœke, Yisu kœtu ngusha ga tœ ɔshɔ, á kœmbœrœ kpata dœ tœnœ yé œ kœpi ga pa ala ayibulanœ, ");
INSERT INTO kxf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","á kœpa fœ she adœke: «Na œ djutɔ kote zœ ɓa la kudu ungu á endje dji á ta ɨ'ɨrɨnœ Silowe.» – Ádá ɨ'ɨrɨ Silowe kœdœ «Ayi avwa» – Ayibula kœna œ kœdjutɔ kote ye yé kœfatœ ye ndœ kœgu she, tshe kœte lima tœ kœwu osho. ");
INSERT INTO kxf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amashenga nœ ye œdœ pe azu á endje sœ lima kœwu she kœ'eshondœ œrœ, yu lima tœ endje adœke: «Œ dœ́dœ́ Tsheneke á tshe sœ lima atɨ á sœ kœ'eshondœ œrœ dœke nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Anga azu pa lima adœke: «Œshe dœmœ.» Anga endje pa ndje adœke: «Œ̃ œ̃, uzunœ tsha ɓata sheshe.» Kashe ayibulanœ yi lima ndœ nœ adœke: «Adja œmœ dœke.» ");
INSERT INTO kxf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Endje kœyu she adœke: «Ala zœ kɔrɔ kotoo?» ");
INSERT INTO kxf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tshe kœgi fœ endje adœke: «Yakoshenœ á endje sœ kœ'e ɨ'ɨrɨ ye adœke Yisu dá mbœrœ kpata, á pi ga pa ala mœ yé á pa fœ mœ adœke: “Na dœ́ djutɔ kote zœ ɓa la ungu Silowe.” Mœ na ɓa zœ, yé manda kœdjutɔ kote mœ, ala mœ kɔrɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Endje kœyu she adœke: «Uzunœ asœmœ sœ kpœta a?» Tshe kœgi fœ endje adœke: «Mœ wuwusœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Anga azu to yakoshe á ala ye bu lima asœmœ natœnœ ga ndœ Afarisayi. ");
INSERT INTO kxf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Andaa Yisu mbœrœ lima kpata á kɔrɔ ala ye dœ tœnœ dœ lɔkɔ sabata. ");
INSERT INTO kxf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Afarisayi kœyu ndje œnœ endje yakoshe asœmœ tœ kœwusœ mara œrœ á mbœrœ fœ she adœke tshe tetœ kœwu osho. Tshe kœpa fœ endje adœke: «Tshe pi kpata ga pa ala mœ, mœ djutɔ kote mœ yé mœ sœ kœwu osho.» ");
INSERT INTO kxf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Anga Afarisayi pa lima adœke: «Uzunœ asœke dœ́dœ́ uzu nœ Ndjaba nene mbœrœ á tshe mbœrœ œrœ asœ dœ lɔkɔ Sabata.» Anga endje pa ndje adœke: «Ayi kœmbœrœ ekperœ œ gbɔ awa kœmbœrœ mara ambárá afá atake kotoo?» Yé azu kuru lima tshelœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Afarisayi kpa kœyu ayibula á koɓa nœ ye ka asœmœ adœke: «Yé œɓœ, ɓœ sœ dœ o'o gaɗe tœ upu nœ uzunœ á tshe mbœrœ á ala zœ kɔrɔ asœke a?» Tshe kœgi fœ endje adœke: «Œshe kœdœ ayi kœgbara o'o.» ");
INSERT INTO kxf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Utshunœ adœke agbozu yudanœ e aayi kœzu she ndœ kœdji endje, endje yiyi lima ndœ nœ nene adœke ala yakoshenœ bu lima yeka á ngɔngɔ asœke ala ye kɔrɔ. ");
INSERT INTO kxf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ayudanœ kœyu aayi kœzu she adœke: «Adja yakoshe asœ kœdœ gbolo yakoshe nœ 'e a? 'E pa adœke ala ye bu trale á 'e zu dœ she a? Ka œ mbœrœ kotoo ngɔngɔ asœ á tshe sœ kœmesho?» ");
INSERT INTO kxf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ayi kœzu yakoshe sœmœ kœpa adœke «'A wusœ nœ adœke œshe kœdœ gbolo nœ 'a yé ala ye bu trale yekane á 'a zu she dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kashe 'a wuwusœ œrœ á mbœrœ adœke tshe tetœ kœwu osho ngɔngɔnœ asœke nene. 'A wuwu ndje sœ uzu á tshe kɔrɔ ala ye nene. 'E yu she, tshe dœ́dœ́ gbolo nene, tshe sœ dœ o'o kœpa fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aayi kœzu she pa lima o'o asœmœ ataa mbœrœ endje sœ lima dœ awa agbozu yudanœ. Mbœrœ Ayuda guma lima o'o ugurutœ endje adœke: Uzu kœyindœ nœ adœke Yisu kœdœ Kristu, œ li adœke endje gɔrɔ she ga ushu lœ Sinagoga ye. ");
INSERT INTO kxf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ádánœ á ayi kœzu ayibula pa lima adœke: «'E yu she, tshe dœ́dœ́ gbolo nene, tshe sœ dœ o'o kœpa fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Afarisayi kpa e yakoshe á tshe dœ́ lima ayibula yé œ kpa kœyu she adœke: «Pa adja o'o utshu Ndjaba. 'A wusœ nœ adœke uzu á tshe she ɓœ kœdœ ayi kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tshe kœgi fœ endje adœke: «Mœ wuwusœ nœ nene œdœ œshe kœdœ ayi kœmbœrœ ekperœ. Kashe œneke á mœ wusœ nœ tshebale kœdœ adœke ala mœ bu lima ye, yé ngɔngɔ asœke mœ sœ kœwu osho.» ");
INSERT INTO kxf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Afarisayi kœyu she adœke: «Œrœ gaɗe dá tshe mbœrœ fœ ɓœ a? Adja gaɗe dá mbœrœ adœke ala zœ kɔrɔ a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yakoshenœ kœgi fœ endje adœke: «Mœ mɨndœ nœ fœ 'e kashe 'e vwaratœ 'e kœdji mœ ye. 'E kpa yindœ nœ adœke mœ pa bisha o'o gaɗe e? 'E yi ndje má ndœ kœte ayambarœ nœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Afarisayinœ kœtetœ kœgu she á kœpa fœ she adœke: «Adja œɓœ kœdœ yambarœ nœ ye, yé a'a, 'a kœdœ ayambarœ nœ Moyize. ");
INSERT INTO kxf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'A wusœ nœ adœke Ndjaba pa lima o'o fœ Moyize kashe œshe asœmœ, 'a wuwusœ osho á tshe to tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yakoshe kœpa fœ endje adœke: «Kœdji œneke á 'e pa asœke, uvuru mœ kpa lœ nœ ye. Gbambanœ nene, 'e pa adœke 'e wuwusœ osho á tshe to tœnœ nene andaa œshe dá kɔrɔ ala mœ! ");
INSERT INTO kxf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A wusœ nœ adœke, Ndjaba gigi o'o ndœ avwala nœ ayi kœmbœrœ ekperœ nene; kashe œdœ uzu kœsœ kœlɨsœ ye, á sœ kœmbœrœ œneke á tshe yindœ nœ, tshe gi o'o ndœ avwala nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bale endje djidji ɓalima o'o adœke anga uzu kɔrɔ ala uzu á endje zu she trale dœ bula nene. ");
INSERT INTO kxf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Œ kœdœ́dœ́ Ndjaba dá vwa yakoshe asœke nene, tshe mbœrœ má œrœ bale nene.» ");
INSERT INTO kxf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Afarisayi kœpa fœ she adœke: «Œɓœ á kœto tœ kœzu ɓœ œrrr kpesheke ɓœ sœ kolœ ekperœ asœke, œrœ gaɗe dá ɓœ yindœ kœyisœ nœ fœ 'a!» Yé endje kœgɔrɔ she lœ Sinagoga ga ushu. ");
INSERT INTO kxf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yisu dji adœke Afarisayi gɔrɔ yakoshe asœmœ ga ushu, yé œ na œ gbɔ she á yu she adœke: «Adja ɓœ sœ dœ kœyindœrœ ga ndœ Gbolo nœ uzu zœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yakoshe asœmœ kœyu she adœke: «Gbozu, œshe kœdœ œɗe yeka á mœ kœsœ dœ kœyindœrœ ga ndœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yisu kœgi fœ she adœke: «Ɓœ wu she ye, œshe dá sœ kœpa o'o fœ ɓœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yakoshe kœpa fœ she adœke: «Gbozu, mœ sœ dœ kœyindœrœ.» Yé tshe kœgote ga utshu ye. ");
INSERT INTO kxf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Á Yisu kœpa adœke: «Mœ na ga pa tshapashɔ asœke mbœrœ kœwa ngbanga, adœke aayibula sœ kœwu osho yé azu á endje sœ lima kœwu osho te ayibula.» ");
INSERT INTO kxf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yekane anga Afarisayi á endje lœ ndje lima tœ œsœnœ, á sœ kœdji o'onœ asœmœ kœyu she adœke: «A'a, ɓœ gbe adœke a'a ndje kœdœ aayibula a?» ");
INSERT INTO kxf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yé Yisu kœgi fœ endje adœke: «Œdœ 'e kœdœ má aayibula, 'e mbœrœ má ekperœ nene. Kashe ɓata ngɔngɔ asœ á 'e sœ kœpa adœke “'a sœ kœwu osho zœ”, ekperœ nœ 'e sœpe.» ");
INSERT INTO kxf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisu kpa pa fœ endje adœke: «Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ uzu kœkatœ kœli ga lœ gbagba nœ apata lœ manda nœ, á kœli tœ anga ogoro kpi, uzu asœmœ kœdœ ayingba too ayi kœndɨ œrœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kashe uzu tsheneke á tshe li ga lœ gbagba lœ manda nœ, kœdœ ayi kœgbɔndœ apata. ");
INSERT INTO kxf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tshendjerœ manda sœ kœkɔrɔ manda fœ she yé apata sœ kœdji tshama ye. Apata á endje kœdœ endje nœ ye, tshe sœ kœ'e pata dœ pata dœ ɨ'ɨrɨ ye yé tshe sœ kœto endje wuta tœnœ ga ushu. ");
INSERT INTO kxf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lɔkɔ á tshe kœto endje wuta tœnœ kɔ ga ushu, tshe te utshu endje yé apata yɔrɔ manda ye mbœrœ á endje sœ kœdji tshama ye kporo. ");
INSERT INTO kxf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bale apata œ yɔrɔ manda angbɨ uzu nene. Endje œ kparawa ye mbœrœ endje sœsœ kœdji tshama angbɨ azu kporo nene.» ");
INSERT INTO kxf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisu pa lima ndœma toro asœke fœ azu kashe endje djidji lima tshelœ kata o'onœ á tshe gbe kœpa fœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeka á Yisu kœpa adœke: «Mœ pa fœ 'e dœ adjapu adœke, œmœ kœdœ manda gbagba nœ apata. ");
INSERT INTO kxf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Azu kɔ á endje na utshu mœ kœdœ ayingba œdœ aayi kœndɨ œrœ. Kashe apata djidji lima endje nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Œmœ kœdœ manda. Uzu á tshe kœli dœ awa nœ mœ tshe gbɔ bala soro. Tshe li bala, tshe wuta bala yé tshe gbɔ bala kœzɨrœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ayingba sœ kœna kolœ ndœ kœzɨ angba, kœwo œrœ œdœ kœndɨ tœnœ. Œmœ, mœ na adœke azu gbɔ soro yé œ sœ dœ soro á ropa nœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Œmœ kœdœ ɔtshɔ ayi kœgbɔndœ apata. Ɔtshɔ ayi kœgbɔndœ apata œ zatœ ye fœ kuzu mbœrœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uzu á tshe kœdœ́dœ́ ayi kœgbɔndœ apata nene, tshe mbœrœ akwa ko ndœ ngendja, mbœrœ apata dœ́dœ́ endje nœ ye nene. Ataa œdœ tshe kœwu muru kœna tœnœ, tshe katœ apata tɨ œ kpa ye. Murunœ œ za anga pata yé œ ndjɔ tshelœ udu endje ngbangbangba. ");
INSERT INTO kxf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'E wu œrœ á mbœrœtœ endje, gbambanœ nene, uzunœ sœ kolœ kœmbœrœ akwa mbœrœ ngendja yé œ sœsœ dœ oyo mbœrœ apata nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Œmœ kœdœ ɔtshɔ ayi kœgbɔndœ apata. Mœ wusœ apata nœ mœ yé endje wu ndje sœ mœ, ");
INSERT INTO kxf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ɓata Aba wusœ mœ á mœ wu sœ ye, mœ sœ kœzatœ mœ fœ kuzu mbœrœ apata nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mœ sœ dœ anga apata á endje sœsœ lœ gbagbanœ asœke nene. Mbœrœ endje asœmœ, œ li adœke mœ to ndje endje, endje dji bala tshama mœ yé endje œ wuta ukpulu apata tshebale œdœ ayi kœgbɔndœ endje tshebale. ");
INSERT INTO kxf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Aba yindœ mœ mbœrœ á mœ sœ kœzatœ mœ fœ kuzu yeka manda nœ á mœ kpa sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Œ sœsœ adœke anga uzu wo mœ nene, kashe œmœ dœ tœ mœ dá zatœ mœ fœ kuzu. Mœ sœ dœ gbɔgbɔ adœke mœ tshu, yé mœ sœ ndje dœ gbɔgbɔ adœke mœ kpa sœ dœ soro. Asœke kœdœ awa o'o á Aba mœ za fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kpœpa kœpa o'o á Yisu pa asœmœ, Ayudanœ kpa kuru lima tshelœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yé ɨlɨ endje ugurunœ pa lima adœke: «Ekpe ɨshirɨ sœ pa ye. Tshe sœ dœ iyi yé mbœrœ gaɗe á 'e sœ kœdji she a?» ");
INSERT INTO kxf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anga udu endje kœpa adœke: «Œ dœ́dœ́ o'o nœ uzu á tshe sœ dœ ekpe ɨshirɨ dœke nene. Anga ekpe ɨshirɨ mbœrœ ɓalima adœke ayibula wu osho a?» ");
INSERT INTO kxf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Œtœnœ kœdœ lima yapu á ɨzɨ œ mi waa, lɔkɔ angbo kœgbe dœ olo á endje za lima avwala pa anda Ndjaba ɓa lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yisu sœ lima kœna œ kœgu ɓa lœ Tepelo ngbɔlɔɔ tshakudu Kɔlɔne andanœ á endje e ɨ'ɨrɨnœ adœke Kɔlɔne nœ Salomo. ");
INSERT INTO kxf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayuda kœngbɔɓatœ endje dji Yisu á kœpa fœ she adœke: «Ɓœ sœ tœ kœkate gaɗe tœ kœpa má fœ 'a adœke œɓœ kœdœ Kristu a? Pandœ nœ fœ 'a dœ́ 'a wusœ nœ ngbɨ.» ");
INSERT INTO kxf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yisu kœgi fœ endje adœke: «Mœ pandœ nœ fœ 'e kashe 'e sœsœ kœyindœ o'o ama mœ nene. Akwa á mœ sœ kœmbœrœ tœnœ dœ ɨ'ɨrɨ Aba mœ dá sœ kœpa o'o tœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kashe 'e sœsœ dœ kœyindœrœ ga ndœ mœ nene mbœrœ á 'e dœ́dœ́ apata nœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Apata nœ mœ sœ kœdji tshama mœ, mœ wusœ endje yé endje sœ kœro manda mœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yé œmœ, mœ sœ kœza soro á ka nene fœ endje. Endje tshu bala bale nene, yé uzu á tshe ko endje tshakane mœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aba mœ á tshe ko endje fœ mœ, tshe ropa azu kɔ. Uzu bale á tshe sœ dœ gbɔgbɔ kœkakara œrœ tshakane Aba gugu nene. ");
INSERT INTO kxf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Œmœ dœ Aba 'a sœ uzu bale.» ");
INSERT INTO kxf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayudanœ kpa kœko lima badja adœke œne ve dœ she. ");
INSERT INTO kxf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kashe Yisu kœpa fœ endje adœke: «Œmœ, mœ mbœrœ akwa ndjoro á to ɓa ndœ Aba, yé 'e wu dœ ala 'e. Ataa akwa neketa dá 'e yindœ kœve mœ dœ badja mbœrœ tœnœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayudanœ kœgi fœ she adœke: «Œ dœ́dœ́ mbœrœ upu nœ ɔshɔ akwa dá 'a yindœ kœve ɓœ dœ badja nene, kashe 'a yindœ kœve ɓœ kolœ mbœrœ á ɓœ sœ kœgu œsœ Ndjaba. Ɓœ kœdœ kolœ uzu yé ɓœ fatœ zœ tœ Ndjaba!» ");
INSERT INTO kxf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yisu kœpa fœ endje adœke: «Endje su ala awa akwa nœ 'e adœke: Mœ pa: “E'e kœdœ andjaba.” ");
INSERT INTO kxf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yé Ndjaba e endjeneke á tshe pa o'o fœ endje ala Buku nœ ye adœke andjaba. Andaa a wusœ nœ adœke œneke á endje sú ala Buku nœ Ndjaba œ sœpe waa dœ waa. ");
INSERT INTO kxf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yé œmœ, Aba ke mœ yé œ vwa mœ ga pa tshapashɔ asœke. 'E pa adœke: “Mœ sœ kœgu œsœ Ndjaba” mbœrœ á mœ pa tœ mœ adœke mœ kœdœ Gbolo nœ Ndjaba a? ");
INSERT INTO kxf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Œdœ mœ kœsœsœ kœmbœrœ akwa nœ Aba mœ nene, 'e vwaratœ 'e tœ kœsœ dœ kœyindœrœ ga ndœ mœ! ");
INSERT INTO kxf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ká mœ kœsœ kœmbœrœ akwanœ zœ, á 'e kœsœsœ dœ kœyindœrœ ga ndœ mœ nene gbaa, œ yindœ akwanœ asœke yeka á 'e kœwu sœ nœ dœ ɔtshɔnœ adœke Aba sœ lœ mœ, yé mœ sœ lœ Aba.» ");
INSERT INTO kxf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Trale endje kpa kœpara awa tœ kœtepa ye á tshe kœtɔ tshakane endje ye. ");
INSERT INTO kxf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yisu kœkwatœ ye ga atshi ungu Yɔrdane ɓa tœ osho á Yowane te lima tœ kœza batisimu fœ azu yé á sœ ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Azu ndjoro sœ lima kœna ga ndœ ye yé á sœ lima kœpa adœke: «Yowane mbœmbœrœ lima ambárá afá bale nene. Kashe o'o kɔ á tshe pa lima tœ upu nœ yakoshe asœke, kœdœ lima adja o'o.» ");
INSERT INTO kxf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yé ɓa zœ, azu ndjoro sœ lima dœ kœyindœrœ ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Lazaro sœ lima dœ koɓa. Tshe sœ lima ɓa lœ Betani, ɓa lakpɨ nœ Amareya dœ yingɔnœ dœ Marta. ");
INSERT INTO kxf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mareyanœ asœke kœdœ yashenœ á tshe su lima ungu yombo ga pa ada Yisu, á turu dœ sukumu ye. Œshe dá yingɔnœ dœ Lazaro sœ lima dœ koɓa. ");
INSERT INTO kxf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ayingɔnœ bisha asœke vwa lima uzu mbœrœ kœpandœ nœ fœ Yisu adœke: «Gbozu, yanga zœ á ɓœ yindœ ye sœ dœ koɓa.» ");
INSERT INTO kxf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yisu djindœ o'onœ, œ pa adœke: «Koɓa nœ Lazaro œ wo she nene, yé œ sœ mbœrœ kœyisœ mokɔ nœ Ndjaba yekane á azu kœza mokɔ fœ Gbolo nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Andaa Yisu yi lima ndœ Marta dœ yingɔnœ œdœ pe lazaro. ");
INSERT INTO kxf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yisu dji adœke Lazaro sœ dœ koɓa gbaa, kashe tshe kpa mbœrœ lima olo bisha tœ osho á tshe sœ lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Manda nœ, tshe kœpa fœ ayambarœ nœ ye adœke: «A kwatœ azœ, œ gu ga lœ ogo Yuda.» ");
INSERT INTO kxf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ayambarœnœ kœgi fœ she adœke: «Rabi, ngɔngɔngɔ kpœke, Ayudanœ yi lima ndœ kœve ɓœ dœ badja yé ɓœ kpa sœ kœgbe kœkwatœ zœ ga zœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yisu kœgi fœ endje adœke: «Olo bale sœsœ dœ ada ɔlɔ ndjokpa dœ bisha nene a? Œdœ uzu kœna ana dœ ɔlɔ, tshe gbota ada ye nene mbœrœ á tshe sœ kœwu ɨngbɨsho nœ tshapashɔnœ asœke. ");
INSERT INTO kxf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kashe œ kœsœ adœke uzu sœ kœna ana dœ abutshɔ, tshe gbota ada ye mbœrœ ɨngbɨsho gugu tœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Manda kœpa o'onœ asœ, Yisu kpa kœpa adœke: «Yanga azœ dœ Lazaro sœ tœ olo, yé mœ sœ kœna ndœ kœjo she.» ");
INSERT INTO kxf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ayambarœ kœgi fœ she adœke: «Gbozu, œdœ tshe kœsœ tœ olo, tshe she ye.» ");
INSERT INTO kxf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yisu yi lima ndœ kœma adœke Lazaro tshu ye, kashe ayambarœ gbe lima adœke Yisu pa o'o tœ adja olo. ");
INSERT INTO kxf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Á Yisu kœpa fœ endje ngbɨ adœke: «Lazaro tshu ye, ");
INSERT INTO kxf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","yé mœ sœ dœ yanga mbœrœ 'e gugu lima tœ œsœnœ ɓa zœ nene yeka á 'e kœsœ dœ kœyindœrœ. Kashe 'a na ga ɨndɨrɨ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yeka á Toma á endje e ndje she Meya kœpa fœ anga ayambarœnœ adœke: «A ngbɔ kɔ œ na ga zœ dœ́ œ tshu awa bale dœ she.» ");
INSERT INTO kxf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lɔkɔ á Yisu wuta, endje pa fœ she adœke endje shi Lazaro œ mbœrœ olo vana. ");
INSERT INTO kxf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ɓata tshalakpɨ Betani sœ ndoo dœ Beteleme manda ana nœ Kelometere votɔ gbambanœ, ");
INSERT INTO kxf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayuda ndjoro na lima ga ɨndɨrɨ Amareya dœ Marta kœu endje manda kuzu yingɔ endje. ");
INSERT INTO kxf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lɔkɔ á Marta dji adœke Yisu sœ tœ awa, tshe na para tshatshu ye kashe Mareya sœpe lima ɓasœnda. ");
INSERT INTO kxf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta kœpa fœ Yisu adœke: «Gbozu, œdœ ɓœ kœsœ má lima kpœke, kuzu œ wo má yingɔ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kashe ngɔngɔ nœ asœke ndje, mœ wusœ nœ adœke œneke kɔ á ɓœ eshondœ nœ ga ndœ Ndjaba, tshe to fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yisu kœpa fœ she adœke: «Ndjaba œ she yingɔ zœ lœ kuzu zœ.» ");
INSERT INTO kxf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta kœgi adœke: «Adjapu, mœ wusœ nœ adœke Ndjaba œ she she dœ lɔkɔ nœ kœshe akuzu tœ ndɔngɔlɔ olo.» ");
INSERT INTO kxf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Á Yisu kœpa fœ she adœke: «Œmœ kœdœ Ayi kœshe azu lœ kuzu œdœ pe Ayi kœza soro. Uzu á tshe kœsœ dœ kœyindœrœ ga ndœ mœ, ngɔngɔ asœke œdœ tshe kœtshu gbaa, tshe kpa sœpe dœ soro. ");
INSERT INTO kxf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yé uzu kɔ á tshe kœsœ dœ soro, á sœ dœ kœyindœrœ ga ndœ mœ, tshe tshu bale nene. Ɓœ sœ dœ kœyindœrœ ataa?» ");
INSERT INTO kxf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta kœgi adœke: «Adjapu Gbozu, adja mœ yindœ nœ adœke œɓœ kœdœ Kristu, Gbolo nœ Ndjaba á tshe sœ kœna ga pa tshapashɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Manda o'onœ asœke, Marta kœaafo, kœna kœ'e Mareya á kœpa fœ she lœ hoyanœ adœke: «Ayi kœyisœrœ sœ kpœke yé œ sœ kœ'e ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kœdji kolœnœ ataa, Mareya kœaafo gbara, á kœna ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yisu lili lima damba ga lakpɨnœ nene, tshe sœpe lima ɓa tœ oshonœ á Marta gbɔ she tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ayudanœ sœ lima sœnda dœ Mareya yé œ sœ lima kœpara awa kœu she. Gba, endje kœwu she kœaafo kœwuta ga ushu yé endje kœte manda ye. Endje gbe lima adœke tshe sœ kœro ete kœkɨ tœnœ ɓa pa udu. ");
INSERT INTO kxf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lɔkɔ á Mareya wuta ɓa tœ osho á Yisu sœ lima tœnœ, á wu she; tshe te lima ga tœ ada ye á pa fœ she adœke: «Gbozu, œdœ ɓœ kœsœ má lima kpœke, kuzu œ wo má yingɔ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kœwu adœke Mareya sœ tœ ɨkɨ yé Ayuda á endje na lima dœ she awa bale yo ndje dœ ɨkɨ, lɔsu Yisu su dœ oyo yé uvuru ye i gara lœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Á Yisu kœyu adœke: «'E shi she kpœta a?» Endje kœgi fœ she adœke: «Gbozu, na gamœ dœ́ œ wu.» ");
INSERT INTO kxf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Á Yisu kœkɨ. ");
INSERT INTO kxf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayudanœ kœpa lima adœke: «'E wu, ɓata á tshe yi lima ndœ Lazaro!» ");
INSERT INTO kxf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Anga azu kœpa adœke: «Œshe á tshe kɔrɔ ala ayibula, mbœrœ gaɗe á tshe mbœrœ adœke kuzu za Lazaro nene na a?» ");
INSERT INTO kxf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lɔsu Yisu kpa su lima dœ oyo, yé tshe na lima ga pa udu. Tœnœ kœdœ lima kudu badja á endje vwɨrɨ egerœ badja ga tœ amanœ. ");
INSERT INTO kxf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yisu kœpa adœke: «'E vwɨrɨ egerœ badjanœ asœke.» Yeka á Marta á tshe kœdœ yingɔ kuzunœ kœpa fœ she adœke: «Gbozu, tshe fu ye mbœrœ tshe mbœrœ lœ koto olo vana.» ");
INSERT INTO kxf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yisu kœgi fœ she adœke: «Mœ papa fœ ɓœ adœke: Œdœ ɓœ kœsœ dœ kœyindœrœ, ɓœ wu bala mokɔ nœ Ndjaba nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Endje kœvwɨrɨ egerœ badjanœ. Á Yisu kœmesho ga lafo á kœpa adœke: «Aba, mœ sœ kœza mershe fœ ɓœ mbœrœ á ɓœ dji mœ. ");
INSERT INTO kxf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mœ wu má sœ nœ adœke ɓœ sœ kolœ kœdji mœ zœ. Kashe mœ pa o'o mbœrœ ukpulu azu á endje sœ ɨndɨrɨ mœ asœke adœke endje sœ dœ kœyindœrœ adœke œɓœ dá vwa mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Manda kœpa o'onœ asœ, Yisu pa dœ avwara adœke: «Lazaro, wuta ga ushu!» ");
INSERT INTO kxf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yé uzu á tshe tshu má lima ye kœwuta dœ uwu lœba á endje vwele dœ ada ye, dœ kane ye, œdœ ndje pe ndœma lœba á endje vwele dœ tshatshu ye. Yisu kœpa fœ azu adœke: «'E vwara uwu lœba tœ ye, œ katœ ye tɨ tshe gu.» ");
INSERT INTO kxf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kolœ ugurutœ Ayuda á endje na lima ga ndœ Mareya yé á wu œrœ á Yisu mbœrœ lima asœmœ, ɨlɨ endje wuta lima dœ kœyindœrœ ga ndœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kashe anga endje ugurunœ, na lima kœgbɔtœ endje dœ Afarisayi á pa lima ndœ œrœ á Yisu mbœrœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mbœrœ tœnœ ataa, agbozu tshapa anganga Ndjaba dœ Afarisayi ngbɔ lima tœ endje ɓa lœ anda kœwa ngbanga nœ azu nœ Ndjaba á pa adœke: «A mbœrœ kotoo? Yakoshe asœke sœ kœmbœrœ ambárá afá waa ye kea? ");
INSERT INTO kxf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Œdœ a kœkatœ ye tɨ kœmbœrœ ataa, azu kɔ œ sœ kœyindœrœ ga ndœ ye, yé azu Roma œ na kœndɨ œyerœ osho nœ azœ œdœ pe ogo nœ azœ ye!» ");
INSERT INTO kxf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Anga bale ugurutœ endje á ɨ'ɨrɨ ye kœdœ lima Kayifa, tshe kœdœ lima egerœ nganga Ndjaba dœ ungunœ asœmœ. Tshe kœpa fœ endje adœke: «'E zaza ada o'onœ asœ nene ");
INSERT INTO kxf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","yé 'e wuwu ndje sœ nœ nene adœke œ sœ dœ ɔtshɔnœ mbœrœ 'e adœke uzu bale tshu lœ kumu azu para yekane á ogo nœ azœ kœndɨndɨ djigi nene.» ");
INSERT INTO kxf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O'onœ toto lima lœ Kayifa dœ tœ ye nene, kashe ɓata œshe kœdœ lima egerœ nganga Ndjaba dœ ungunœ asœmœ, Ndjaba za o'o ga lœ ama ye kœgbara lima adœke œ li adœke Yisu tshu mbœrœ azu ogo. ");
INSERT INTO kxf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Œ sœsœ kolœ mbœrœ azu ogo nene, kashe œ sœ ndje mbœrœ agbolo nœ Ndjaba á endje ndjɔtshelœtœ endje djezœ adœke endje ngbɔɓatœ endje œ wuta bale. ");
INSERT INTO kxf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pe dœ ɔlɔnœ asœmœ, agbozu Ikrizianœ gbɔ lima gbetshelœ nœ kœwo Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ádánœ á Yisu kpa sœsœ lima kœna œdœ kœwuta ngbɨ ga ugurutœ Ayudanœ nene dœke. Kashe tshe gi lima tœ ye ndoo ga lœ kpagagasho, œ sœ ɓa lakpɨ bale á ɨ'ɨrɨnœ kœdœ Efrayime, yeka á sœ ɓa zœ dœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Andaa angbo nœ Pake ndo kœte lima tœnœ, azu ndjoro ɔ lima ga lœ Yerusaleme utshu angbo mbœrœ kœdjutɔ kolœ endje á kœza avwala fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Endje sœ lima kœpara Yisu, yé ɓata endje sœ lima ɓa lœ Tepelo, endje sœ lima kœyutœ endje ugurutœ endje adœke: «'E gbe kotoo? Œrrr á tshe na ndœ angbonœ asœke nene a!» ");
INSERT INTO kxf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yeka á agbozu tshapa anganga Ndjaba œdœ Afarisayi kœza o'o fœ azu adœke: «Œdœ uzu bale kœwu lima sœ osho á Yisu sœ tœnœ, tshe yi lima sœ nœ yeka á endje kœtepa ye.» ");
INSERT INTO kxf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Olo mindu dœ amanœ bale utshu angbo Pake, Yisu na lima ga lœ Betani, tshalakpɨ á tshe she lima Lazaro lœ kuzu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓa zœ, endje fa kœzɨrœ fœ Yisu, yé Marta dá kuru lima tshelœ kœzɨrœnœ á endje sœ lima kœzɨ tœnœ awa bale dœ Lazaro. ");
INSERT INTO kxf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mareya za ungu yombo á endje mbœrœ dœ adja narde á amanœ gbɔ dœ panœ ga lœ anga. Tshe za lima anganœ, œ su yombonœ ga pa ada Yisu yé œ turu dœ sukumu ye. Tshafu yombonœ za lima tshasœnda djigi. ");
INSERT INTO kxf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anga yambarœ nœ Yisu bale á ɨ'ɨrɨ ye kœdœ Yudasi Isikariote, œshe á tshe va ɔtɔ Yisu, pa adœke: ");
INSERT INTO kxf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Mbœrœ gaɗe á ka má yombonœ œ gbɔ denari kama votɔ dœ́ kurutshelœnœ tœ aayi oyo nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasi papa lima o'onœ mbœrœ á tshe gbe dœ aayi oyo nene, kashe mbœrœ á tshe kœdœ ayi angba. Kashe ɓata tshe kœdœ lima ayi kœgbɔndœ ngbade ngendja, tshe sœ lima kœzɨ angba ngendja á endje sœ kœko tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yisu kœpa adœke: «'E toto oyo fœ she nene. Tshe mbœrœ œtœnœ mbœrœ kœgbe dœ olo á endje za bala dœ mœ ga lœ koto. ");
INSERT INTO kxf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","'E sœ awa bale dœ aayi oyo ɔlɔ dœ ɔlɔ kashe œmœ, mœ sœsœpe dœ 'e ɔlɔ dœ ɔlɔ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayuda ndjoro dji lima adœke Yisu sœ lœ Betani. Endje sœsœ lima kœna ga zœ kolœ mbœrœ Yisu bale nene, kashe endje na lima ndje mbœrœ kœwu Lazaro á Yisu shé lima she lœ kuzu. ");
INSERT INTO kxf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mbœrœ tœnœ ataa, agbozu tshapa anganga Ndjabanœ wa lima o'o adœke œne wo ndje Lazaro ye, ");
INSERT INTO kxf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mbœrœ Ayuda ndjoro ka lima tœ endje tɨ, yé œ sœ lima dœ kœyindœrœ ga ndœ Yisu lœ kumu ye. ");
INSERT INTO kxf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Osho kɔrɔ pa nœ, Ayuda ndjoro á endje na lima ndœ angbo Pakenœ dji adœke Yisu œ na lima ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Endje de kako ngima yé œ wuta para tshatshu ye. Endje sœ lima kœta rawa adœke: «Mokɔ fœ Ndjaba! Kaka Ndjaba to kane ye ga pa tsheneke á tshe sœ kœna dœ ɨ'ɨrɨ Gbozu, gbozugo Israyele!» ");
INSERT INTO kxf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisu wu ovoro ane yé œ na œ ɔ ga pa ye ɓata á endje sú ala Buku nœ Ndjaba adœke: ");
INSERT INTO kxf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Azu tshelœ ongbo Siyona, awa zaza 'e nene! 'E wu, gbozu nœ 'e dá na asœke, tshe ɔ ga pa ovoro ane.» ");
INSERT INTO kxf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ayambarœ nœ Yisu wuwu damba lima sœ œneke á sœ kœro tœnœ asœmœ nene. Œrrr manda kœɔ she lima ga lafo ga lœ mokɔ nœ ye yekane á œndœnœ te lima lœ endje adœke endje sú lima o'onœ tœ upu nœ ye, yé endje mbœrœ ga tœ ye kolœ adja œneke á endje sú. ");
INSERT INTO kxf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Azu kɔ á endje sœ lima dœ Yisu lɔkɔ á tshe she lima Lazaro yé á e she adœke tshe wuta ga ushu, endje sœ lima kœpandœ o'o tœ œneke á endje wu. ");
INSERT INTO kxf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mbœrœ tœnœ dá azu ndjoro sœ lima kœna para tshatshu Yisu; gbambanœ nene, endje dji lima ndœ ambárá afá á tshe mbœrœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yeka Afarisayi kœpa ugurutœ endje adœke: «'E sœ kœwu tœnœ, 'e kpa li kœmbœrœ œrœ bale nene mbœrœ azu kɔ yɔrɔ kolœ manda ye.» ");
INSERT INTO kxf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɔlɔ angbo li yé anga angbɨ azu ro ndje lima ga lœ Yerusaleme mbœrœ kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Endje na ga ndœ Filipo, uzu tshalakpɨ Betesayida lœ ogo Galilayi, á kœpa lima fœ she adœke: «Gbozu 'a gbe kœwu Yisu.» ");
INSERT INTO kxf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo kœna kœpa fœ Andere á endje na dœ she kœpandœ nœ fœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yisu kœpa fœ endje adœke: «Ngɔngɔ asœ, ada ɔlɔ li adœke Gbolo nœ uzu gbɔ mokɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mœ sœ kœpa fœ 'e dœ adjapu adœke œdœ ele ble kœlili ga lœ ɔshɔ á gba nene, œ sœpe kolœ tœnœ bale. Kashe œ kœli ga lœ ɔshɔ á kœgba, œ ko yekane á zu elenœ ndjoro. ");
INSERT INTO kxf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Uzu á tshe kœyindœ soro ye, tshe sœpe dœ tœnœ nene; kashe tsheneke á tshe kœvwaratœ ye kœtɔpe tœnœ pa tshapashɔnœ asœke, tshe gbɔndœ nœ waa dœ waa. ");
INSERT INTO kxf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Œdœ uzu kœyindœ kœmbœrœ akwa fœ mœ, œ li adœke tshe ro manda mœ yé osho á mœ sœ tœnœ dá ayi akwa nœ mœ œ sœ ndje tœnœ. Œdœ uzu kœsœ kœmbœrœ akwa fœ mœ, Aba œ donga she.» ");
INSERT INTO kxf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ngɔngɔ asœ, lɔsu mœ sœ ga lafo yé o'o gaɗe dá mœ kœpa a? Mœ pa adœke: «Aba, she mœ tœ ada ɔlɔnœ asœke a? Kashe œ sœ mbœrœ ada ɔlɔnœ asœke dá mœ na. ");
INSERT INTO kxf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aba, mbœrœ adœke azu donga ɨ'ɨrɨ zœ.» Yé anga tshama wu ɓa lafo adœke: «Mœ mbœrœ, yé mœ kpa mbœrœ adœke azu donga ɨ'ɨrɨ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ukpulu azu á endje lœ lima tœ œsœnœ á dji o'onœ asœke pa adœke: «Yavuru dá sɔ asœmœ.» Anga endje pa ndje adœke: «Anga aandjelu dá pa o'o fœ Yisu.» ");
INSERT INTO kxf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yisu gi adœke: «Tshamanœ á kɨ asœmœ, kɨkɨ mbœrœ mœ nene kashe œ kɨ mbœrœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ngɔngɔ asœ dá Ndjaba œ wa ngbanga nœ tshapashɔ asœke, yé ngɔngɔ asœ tshe vwi gbozu tshapashɔnœ ga ushu. ");
INSERT INTO kxf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yé œmœ, ɔlɔ á endje kœtɨ mœ ga lafo pa ɔshɔ, mœ gbota bala azu para kɔkɔ ga ndœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tshe pa lima o'o asœ mbœrœ kœyisœ mara kuzu á tshe tshu dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ukpulu azunœ kœgi fœ she adœke: «A dɨ ala mbeti awa akwa adœke, Kristu œ sœ dœ soro waa dœ waa. Ka kotoo á ɓœ pa adœke endje ɓi Gbolo nœ uzu ga pa kurushi á za she tɔ ga lafo a? Gbolo nœ uzunœ asœmœ kœdœ œɗe?» ");
INSERT INTO kxf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yisu kœgi fœ endje adœke: «Ɨngbɨsho sœ damba ugurutœ 'e manda olo teasho. 'E na ana ɓata á 'e sœ dœ ɨngbɨsho mbœrœ adœke ubu osho kœndondondoro 'e nene. Gbambanœ nene, uzu á tshe sœ kœna lœ ubu osho, wuwusœ osho á tshe sœ kœna ga tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ɓata 'e sœ dœ ɨngbɨsho, 'e sœ dœ kœyindœrœ ga ndœ ɨngbɨsho á 'e kœwuta agbolo nœ ɨngbɨsho. Manda kœpa o'onœ asœke, Yisu gitœ ye ugurutœ azu ndjoronœ yé œ zatœ ye yiwa tœnœ tœ endje.» ");
INSERT INTO kxf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ayuda wu lima ambárá afá ndjoro á Yisu mbœrœ gbaa, kashe endje sœsœ lima dœ kœyindœrœ ga ndœ ye nene, ");
INSERT INTO kxf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","liaka o'o á ayi kœgbara o'o Isaya pa lima adœke: «Gbozu Ndjaba, œɗe dá yindœ o'o á 'a pa lima? Yé Gbozu Ndjaba má lima gbɔgbɔ nœ ye fœ uzu œɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaya kpa pandœ ádá á azu vwara lima tœ endje tœ kœsœ dœ kœyindœrœ: ");
INSERT INTO kxf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Tshe mbœrœ adœke ala endje bu, mbœrœ á endje kœwuwu osho nene, tshe za ndje œrœ tshu ga pa kœwusœrœ nœ endje, mbœrœ endje kœwusœ œrœ nene, yeka endje kœfatœ endje ga ndœ ye nene, adœke tshe she endje.» ");
INSERT INTO kxf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya gbara lima o'onœ asœ mbœrœ á tshe wu lima mokɔ nœ Yisu yeka á pa lima o'o tœ upu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Andaa anga agbozu yuda ndjoro sœ lima dœ kœyindœrœ ga ndœ Yisu. Kashe kolœ mbœrœ awa Afarisayi, endje lili lima kœma tœnœ ngbɨ nene adœke endje gɔrɔ endje lœ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Endje yi lima ndœ nœ adœke azu donga œne kœropa œneke á Ndjaba œ donga dœ œne ye. ");
INSERT INTO kxf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisu pa ngbɨ adœke: «Uzu á tshe sœ dœ kœyindœrœ ga ndœ mœ, tshe sœsœ kolœ dœ kœyindœrœ ga ndœ mœ nene; tshe sœ dœ tœnœ ga ndœ tsheneke á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yé uzu á tshe sœ kœwu mœ, sœ ndje kœwu tsheneke á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Œmœ, mœ kœdœ ɨngbɨsho. Mœ na ga pa tshapashɔ adœke uzu á tshe kœsœ dœ kœyindœrœ ga ndœ mœ sœ lœ ubu osho nene. ");
INSERT INTO kxf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Œdœ uzu kœsœ kœdji o'o ama mœ á kœgbɔgbɔndœ nœ nene, œ dœ́dœ́ mœ dá wa ngbanga pa ye nene; gbambanœ nene, mœ nana mbœrœ kœwa ngbanga pa tshapashɔ nene kashe mœ na ndœ kœshe tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Uzu á tshe kœvwaratœ ye tœ mœ á kœsœ kœdji o'o ama mœ nene, tshe gbɔ ayi kœwa ngbanga pa ye: O'o á mœ pa œ wa ngbanga pa ye bala tœ ndɔngɔlɔ olo. ");
INSERT INTO kxf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mœ papa o'o tœ mœ dœ tœ mœ nene, kashe Aba á tshe vwa mœ dá za o'o fœ mœ dœ tœ ye adœke mœ pa yé œ mɨndœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yé mœ wusœ nœ adœke awa oo nœ ye kœdœ soro á ka nene. Œneke á mœ sœ kœpandœ nœ, mœ sœ kœpa tœnœ ɓata Aba pa fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Œ sœpe lima olo bale tœ angbo Pake. Yisu wu lima sœ nœ adœke olo kœkatœ tshapashɔnœ tɨ á kœgu ga ndœ Aba œne li ye. Tshe yi lima ndœ ayambarœ nœ ye á endje sœ pa ɔshɔ, yé œ yi ndje ndœ endje œrrr ga tœ ndɔngɔlɔnœ. ");
INSERT INTO kxf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yisu sœ lima kœzɨrœ awa bale dœ ayambarœ nœ ye. Andaa Satana za gbetshelœ ga lɔsu Yudasi Isikariote, gbolo nœ Shimu adœke tshe ka Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisu wu lima sœ nœ adœke Aba za tshagbozu nœ tshapa œrœ kɔ fœ œne. Œne to ɓa ndœ Ndjaba yé œne sœ kœgu ga ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yisu áafo ɨndɨrɨ ndaba kœzɨrœ, œ verœ lœba œnœ tshapanœ tœ ye, œ za anga akpa lœba œ i ga lœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Manda nœ, tshe su ungu ga lœ saane, œ tetœ kœdjutɔ ada ayambarœ nœ ye, á sœ kœturu dœ lœbanœ á tshe i ga lœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kœwuta ga tœ Shimu Petro, tshe kœpa fœ she adœke: «Gbozu œɓœ dá djutɔ ada mœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yisu kœgi adœke: «Ngɔngɔ asœ, ɓœ wuwusœ œrœ á mœ sœ kœmbœrœ tœnœ asœke nene kashe ɓœ wu bala sœ nœ manda nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro kœpa fœ she adœke: «Œ̃œ̃ nene, ɓœ djutɔ ada mœ bale nene.» Yisu kœgi fœ she adœke: «Œdœ mœ kœdjudjutɔ ada zœ nene, ɓœ gbɔ œrœ bale ɓa ndœ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Á Petro kœpa fœ she adœke: «Gbozu, œ kœsœ adja ataa, djudjutɔ kolœ ada mœ nene, djutɔ ndje kane mœ œdœ pe kumu mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yisu kœgi fœ she adœke: «Uzu á tshe kœdjutɔ kote ye, œ li adœke tshe djutɔ kolœ ada ye, gbambanœ nene, tshe sœ djigi yerœ. Yé e'e, 'e sœ yerœ kashe œ dœ́dœ́ e'e kɔ dá sœ yerœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tshe wu lima sœ tsheneke á tshe ka she dœ ɔtshɔnœ yekane á pa adœke: «'E dœ́dœ́ e'e kɔ dá sœ yerœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Manda kœdjutɔ ada endje, tshe kpa verœ lœba tshapanœ ga tœ ye, œ kwa ga pa ndaba kœzɨrœ, á pa adœke: «'E wusœ ádá œrœ á mœ mbœrœ fœ 'e asœke ye a? ");
INSERT INTO kxf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'E sœ kœ'e mœ Ayi kœyisœrœ, 'e e ndje mœ Gbozu. 'E sœ kœ'e mœ tako mbœrœ œmœ kœdœ ayi kœyisœrœ, œmœ kœdœ ndje Gbozu. ");
INSERT INTO kxf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ɓata œmœ á mœ dœ́ ayi kœyisœrœ, á dœ Gbozu, mœ djutɔ ada 'e, œ li adœke e'e ndje, 'e djutɔ ada 'e ugurutœ 'e dœ anga 'e. ");
INSERT INTO kxf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gbambanœ nene, œdœ mœ kœna œrrr ga tœ kœdjutɔ ada 'e, œmœ á mœ dœ́ Ayi kœyisœrœ œdœ ndje Gbozu, e'e ndje 'e djutɔ ada 'e ugurutœ 'e dœ anga 'e. ");
INSERT INTO kxf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mœ pa fœ 'e dœ adjapu adœke, ayi akwa roro gbozu tshapa ye nene, yé ayi avwa roropa ayi kœvwa she nene. ");
INSERT INTO kxf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Œdœ 'e kœwusœ nœ ataa, 'e sœ dœ yanga œdœ 'e kœza o'onœ asœke ga tœ akwa. ");
INSERT INTO kxf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mœ sœsœ kœpa o'o fœ 'e kɔkɔ nene yé mœ wusœ endjeneke á mœ ke endje. Œ li adœke o'o á endje sú ala Buku nœ Ndjaba mbœrœtœ endje: “Uzunœ á 'a zɨ lima kœzɨrœ awa bale dœ she, œshe dá wuta uzu kœka mœ.” ");
INSERT INTO kxf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mœ sœ kœpa o'o fœ 'e ngɔngɔ asœke utshunœ adœke o'onœ wuta, yeka á 'e kœsœ dœ kœyindœrœ adœke “mœ sœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mœ sœ kœpa fœ 'e dœ adjapu adœke uzu á tshe za osho kœsœ fœ tsheneke á mœ vwa she, za ndje osho kœsœ fœ mœ. Yé uzu á tshe za osho kœsœ fœ mœ, tshe za osho kœsœ fœ tsheneke á tshe vwa mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Manda kœpa o'onœ asœ, lɔsu Yisu sœ ga lafo yé tshe pa 'oara adœke: «Mœ sœ kœpa fœ 'e dœ adjapu adœke, anga uzu bale ugurutœ 'e œ ka mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ayambarœ kœte lima tœ kœmesho ugurutœ endje yé á sœ lima kœyutœ endje tœ kœwusœ uzu á tshe pa o'o tœ ye asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Anga yambarœ bale, tsheneke á Yisu yi lima ndœ ye, sœ lima kpœndɨrɨ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Shimu Petro mbœrœ ala ye fœ she adœke tshe yu Yisu tœ uzunœ á tshe sœ kœpa o'onœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Á yambarœnœ asœmœ kœgitœ ye ga lakoro Yisu á kœyu she adœke: «Gbozu, uzunœ á ɓœ patœ ye asœmœ kœdœ œɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yisu gi adœke: «Uzu á mœ kœyi ndɨndɨ mapa ga la ungu kœzɨrœ á kœza fœ she dá œshe dœmœ.» Atamœ, Yisu kœza ndɨndɨ mapanœ á kœza fœ Yudasi Isikariote á tshe kœdœ gbolo nœ shimu. ");
INSERT INTO kxf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Lɔkɔ á Yudasi za ndɨndɨ mapanœ tshakane Yisu, Satana kœli ga lœ Yudasi. Yisu kœpa fœ she adœke: «Œneke á ɓœ yindœ kœmbœrœ tœnœ, mbœrœ katsha.» ");
INSERT INTO kxf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Uzu bale ugurutœ endje á endje sœ lima pa ndaba kœzɨrœ á tshe wu lima sœ ádá o'onœ á tshe pa fœ she gugu nene. ");
INSERT INTO kxf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ɓata ngbade kœgbɔndœ ngendja sœ lima ɓa tshakane Yudasi, anga endje gbe lima adœke Yisu pa fœ she adœke tshe yɔ œrœ á endje sœ dœ ogonœ mbœrœ angbo too ndje adœke tshe to anga œrœ fœ aayi oyo. ");
INSERT INTO kxf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi zɨ ndɨndɨ mapa asœmœ, yé trale œ wuta ga ushu. Osho bu lima ye. ");
INSERT INTO kxf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Manda kœwuta Yudasi ga ushu, Yisu kœpa adœke: «Ngɔngɔ asœke, mokɔ nœ Gbolo nœ uzu matœ ye, yé mokɔ nœ Ndjaba ma ndje tœ ye lœ awa nœ Gbolo nœ uzu. ");
INSERT INTO kxf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndjaba œ ma mokɔ nœ Gbolo nœ uzu dœ tœ ye, yé œndœnœ œ dɨ nene á tshe mbœrœ œtœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Agbolo nœ mœ, mœ sœpe dœ 'e kolœ manda olo teasho. 'E para mœ yé ɓata á mœ pa fœ Ayuda: Osho á mœ na ga tœnœ, 'e li kœna ɓa zœ nene. Œtœnœ dá mœ sœ ndje kpa kœpa ngɔngɔ asœ fœ 'e asœke. ");
INSERT INTO kxf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mœ sœ kœza tafo awa o'o fœ 'e: 'e yindœtœ 'e ugurutœ 'e. Œ li adœke 'e yindœtœ 'e ugurutœ 'e ɓata á mœ yindœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Atamœ, azu kɔ œ wusœ nœ adœke e'e kœdœ ayambarœ nœ mœ lœ awa nœ kœyindœsho á 'e sœ dœ tœnœ ugurutœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Shimu Petro yu she adœke: «Gbozu, ɓœ na ga ta a?» Yisu kœgi fœ she adœke: «Osho á mœ sœ kœna ga tœnœ, ɓœ li kœna ga tœnœ ngɔngɔ asœke nene, kashe ɓœ na bala mangba mœ manda nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro kœpa fœ she adœke: «Gbozu, mbœrœ gaɗe á mœ li kœna mangba zœ ngɔngɔ asœke nene a? Gbambanœ nene, mœ gumatœ mœ mbœrœ kœzatœ mœ fœ kuzu tœ upu nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yisu kœgi adœke: «Adja ɓœ gumatœ zœ mbœrœ kœzatœ zœ fœ kuzu mbœrœ mœ ye a? Mœ sœ kœpa fœ ɓœ dœ adjapu adœke, utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisu kpa pa fœ endje adœke: «Lɔsu 'e tɔtɔ nene. 'E sœ dœ kœyindœrœ ga ndœ Ndjaba, yé œ sœ ndje dœ kœyindœrœ ga ndœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ɓa lœ anda nœ Aba mœ, osho kœsœ sœ ndjoro. Œ kœdœ́dœ́ má adjapu nene, mœ pa má ndœ nœ fœ 'e nene. Kashe mœ sœ kœna ɓa zœ kœguma osho á 'e kœsœ bala tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yé manda kœna mœ ndœ kœguma oshonœ fœ 'e, mœ kwa bala tœ mœ ndœ kœko 'e adœke osho á mœ sœ tœnœ; 'e sœ ndje bala tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'E wusœ awa á sœ kœna ga tœ osho á mœ sœ kœna ga tœnœ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma kœpa fœ she adœke: «Gbozu, 'a wuwusœ osho á ɓœ sœ kœna ga tœnœ bale nene. Ataa 'a wu má sœ nœ kotoo?» ");
INSERT INTO kxf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yisu kœgi fœ she adœke: «Œmœ kœdœ awa, œmœ kœdœ adja o'o, œmœ kœdœ ndje soro. Uzu bale lili kœwuta ɓa ndœ Aba, œdœ tshe kœwuwuta ɓa ndœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Œdœ 'e kœwu má sœ mœ, 'e wu má ndje sœ Aba mœ ye. Ngɔngɔ asœke, 'e wusœ ye, yé 'e wu ndje she ye.» ");
INSERT INTO kxf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Á Filipo kœpa fœ she adœke: «Gbozu, yisœ Aba fœ 'a yé 'a kpa gbe dœ anga œrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yisu kœgi fœ she adœke: «Filipo, ɓalima a sœ dœ 'e œrrr asœke, ɓœ wuwusœ mœ nene a? Uzu á tshe wu mœ, wu ndje Aba. Mbœrœ gaɗe á ɓœ pa adœke: “Yisœ Aba fœ 'a?” ");
INSERT INTO kxf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɓœ yiyindœ nœ adœke mœ sœ lœ Aba yé Aba sœ lœ mœ nene a? O'o á mœ sœ kœpa fœ 'e toto lœ mœ dœ tœ mœ nene. Kashe Aba á tshe sœ lœ mœ dá sœ kœmbœrœ adja akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'E yindœ o'o ama mœ: Aba sœ lœ mœ yé mœ sœ lœ Aba. Œdœ 'e kœyiyindœ o'o ama mœ nene, 'e yindœ nœ kolœ mbœrœ akwanœ asœke. ");
INSERT INTO kxf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mœ sœ kœpa dœ adjapu fœ 'e adœke: Uzu á tshe kœsœ dœ kœyindœrœ ga ndœ mœ, tshe mbœrœ ndje akwa á mœ sœ tœ kœmbœrœ tœnœ. Tshe mbœrœ bala ndje ogboro akwa kœropa œneke, mbœrœ mœ sœ kœgu ga ndœ Aba. ");
INSERT INTO kxf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yé œrœ kɔ á 'e eshondœ nœ dœ ɨ'ɨrɨ mœ, mœ mbœrœ bala œtœnœ dœ mara adœke mokɔ nœ Aba matœ ye lœ Gbolo. ");
INSERT INTO kxf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Œdœ 'e kœ'eshondœ œrœ dœ ɨ'ɨrɨ mœ, mœ mbœrœ bala œtœnœ.» ");
INSERT INTO kxf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Œdœ 'e kœyindœ mœ, 'e mbœrœtœ 'e liaka awa o'o nœ mœ, ");
INSERT INTO kxf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","œmœ, mœ kɨ fœ Aba adœke tshe vwa anga ayi kœtɨ kane manda mœ fœ 'e, á tshe kœsœ dœ 'e awa bale waa dœ waa. ");
INSERT INTO kxf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Œshe kœdœ Ɨshirɨ nœ adja o'o, tsheneke á tshapashɔ œ li kœza osho kœsœ fœ she nene; gbambanœ nene, tshe sœsœ kœwu she yé œ wu ndje sœ ye nene. Kashe e'e, 'e wusœ ye yé mbœrœ tshe sœ awa bale dœ 'e yé tshe sœ lœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mœ ka bala tœ 'e tɨ tœ ayasuru nene, kashe mœ sœ kœkwatœ mœ ndœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Manda olo teasho, tshapashɔ œ kpa wu mœ nene. Kashe e'e, 'e wu bala mœ mbœrœ á mœ sœ dœ soro yé 'e sœ ndje bala dœ soro. ");
INSERT INTO kxf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dœ lɔkɔnœ asœmœ, 'e wu bala sœ nœ adœke mœ sœ lœ Aba, 'e sœ lœ mœ yé mœ sœ lœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Uzu á tshe sœ kœdji awa o'o nœ mœ á sœ kœza ga tœ akwa, sœ kœyindœ mœ. Aba mœ œ yindœ uzu á tshe sœ kœyindœ mœ. Œmœ, mœ yi bala ndœ ye yé mœ ma bala tœ mœ fœ she.» ");
INSERT INTO kxf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (œ dœ́dœ́ Yuda Isikariote nene) kœyu she adœke: «Gbozu, mbœrœ gaɗe á ɓœ matœ zœ kolœ fœ 'a kashe fœ tshapashɔ nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yisu kœgi fœ she adœke: «Œdœ uzu kœyindœ mœ, tshe lɨ bala sœ o'o ama mœ. Aba mœ œ yindœ ye yé œmœ dœ pe Aba 'a na ga ndœ ye, œ guma osho kœsœ nœ 'a ɓa ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Uzu á tshe kœyiyindœ mœ nene, tshe lɨsœ o'o ama mœ nene. O'o á 'e sœ kœdji mœ kœpa tœnœ toto lœ mœ nene kashe œ to ɓa ndœ Aba á tshe vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mœ pa o'o asœ fœ 'e damba á mœ sœpe lima awa bale dœ 'e ");
INSERT INTO kxf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kashe Ayi kœtɨ kane 'e á tshe dœ́ Ɔtshɔ Ɨshirɨ á Aba œ vwa bala she dœ ɨ'ɨrɨ mœ, tshe yi bala sœ œrœ kɔ yé œ kpa pa bala ndœ œneke kɔ á mœ pa fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Mœ sœ kœkatœ kœsœ gee fœ 'e, œtœnœ kœdœ kœsœ gee nœ mœ á mœ sœ kœza fœ 'e. Mœ zaza kœsœ geenœ fœ 'e liaka œneke á tshapashɔ œ za nene. Adja lɔsu 'e tɔtɔ nene yé awa mbœmbœrœ ndje 'e nene. ");
INSERT INTO kxf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'E dji mœ lima kœpa fœ 'e adœke: “Mœ ro da ye, yé mœ kpa kwatœ mœ ga ndœ 'e.” Œdœ 'e kœyi má ndœ mœ, 'e sœ má dœ yanga kœwu adœke mœ sœ kœna ga ndœ Aba, gbambanœ nene Aba gerœ kœropa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mœ pandœ o'onœ asœ fœ 'e ngɔngɔ asœke, utshunœ adœke œrœnœ wuta; mbœrœ lɔkɔ á kœwuta yekane á 'e kœyindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kœto kpesheke, mœ kpa pa tshama mœ dœ 'e nene, gbambanœ nene, gbozu tshapashɔ asœ sœ kœna tœnœ. Tshe dœ́dœ́ gbozu tshapa mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kashe tshe na mbœrœ á tshapashɔ kœwusœ nœ adœke mœ yindœ Aba yé mœ sœ kœmbœrœ kolœ œneke á Aba za fœ mœ adœke mœ mbœrœ. 'E aafo dœ́ a gitœ azœ kpœke ye.» ");
INSERT INTO kxf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Œmœ kœdœ adja ɔyɔ vinu yé Aba mœ kœdœ ayi kœmbœrœ akwa kɨndɨ vinunœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ganea kɔ á tɔ ga tœ mœ á kœle nene, tshe de ye. Yé ganea á kœle, tshe gbɔndœ nœ adœke œ kpa le tɔpanœ kpuru. ");
INSERT INTO kxf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kœyisœrœ nœ á mœ yisœ nœ fœ 'e asœke guma 'e. ");
INSERT INTO kxf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'E zatœ 'e ga tœ mœ ɓata á mœ zatœ mœ ga tœ 'e. Ɓata ganea á kœsœsœ tœ ɔyɔ nene, œ zu elenœ nene; awa bale ndje 'e zu nene œdœ 'e kœzazatœ 'e ga tœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Œmœ kœdœ ɔyɔ vinu yé e'e kœdœ ganeanœ. Œdœ uzu kœsœ lœ mœ á mœ sœ lœ ye, tshe zu leyɔ tɔ pa nœ kpuru; gbambanœ nene, 'e li kœmbœrœ œrœ bale kpi tœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uzu á tshe kœsœsœ lœ mœ nene, Aba mœ œ za she vwi'i ɓata ganea asœmœ yé tshe ɔrɔ ye. Ɔɔrɔ ganea, endje zoma, œ ko va ga tœ owo yé œ ju. ");
INSERT INTO kxf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Œdœ 'e kœsœ lœ mœ, á o'o mœ kœsœ lœ 'e, 'e eshondœ œrœ á 'e gbe dœ tœnœ yé 'e gbɔ. ");
INSERT INTO kxf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Œrœ á ma mokɔ nœ Aba mœ kœdœ adœke 'e zu leyɔ tɔ pa nœ kpuru yé 'e dœ ayambarœ nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Ɓata Aba yindœ mœ, œmœ ndje mœ yindœ 'e; 'e sœ lœ kœyindœsho nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Œdœ 'e kœlɨsœ awa o'o nœ mœ, 'e sœ lœ kœyindœsho nœ mœ, ɓata á mœ lɨsœ awa o'o nœ Aba mœ á sœ lœ kœyindœsho nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Mœ pandœ œneke fœ 'e adœke 'e sœ dœ yanga ɓata mœ, yé lɔsu 'e kœsu pete dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Awa o'o nœ mœ dœke: 'E yindœtœ 'e ugurutœ 'e ɓata á mœ yindœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Egerœ kœyindœsho á uzu li kœma kœdœ kœzatœ ye fœ kuzu mbœrœ anganœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'E dœ anga mœ, œdœ 'e kœsœ kœmbœrœ œrœ á mœ pandœ nœ fœ 'e adœke 'e mbœrœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mœ kpa e 'e aayi akwa nene, mbœrœ aayi akwa wuwusœ œrœ á ayengɔ ye œ mbœrœ nene. E'e kœdœ anga mœ; gbambanœ nene, œneke kɔ á mœ dji ɓa ndœ Aba mœ, mœ pandœ nœ fœ 'e adœke 'e wusœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Œ dœ́dœ́ 'e dá ke mœ nene, œmœ dá ke 'e á ko 'e ga tœ akwa adœke 'e na, œ zu ɔtshɔ leyɔ yé œndœ akwanœ dɨ. Atamœ, Aba œ to fœ 'e œneke kɔ á 'e eshondœ nœ dœ ɨ'ɨrɨ mœ ɓa ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Œneke á mœ sœ kœ'eshondœ nœ ga ndœ 'e kœdœ adœke, 'e yindœtœ 'e ugurutœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Œdœ tshapashɔ kœyiangba 'e, 'e wusœ nœ adœke tshe yiangba mœ utshunœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Œdœ 'e kœdœ má lima azu tshapashɔ, tshapashɔ œ yi má ndœ 'e. Kashe 'e dœ́dœ́ azu tshapashɔ nene mbœrœ á mœ ke 'e á ko 'e ga ɨndɨrɨnœ, ádá á tshe sœ kœyiangba 'e dœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'E gbe dœ o'o á mœ pa lima fœ 'e adœke: “Ayi akwa roropa gbozu nœ ye nene.” Œdœ endje kœmbœrœ œrœ kanga fœ mœ, endje mbœrœ ndje œrœ kanga fœ 'e ndje awa bale. Œdœ endje kœlɨsœ o'o ama mœ, endje lɨ ndje sœ œnœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yé kpœ lœ kumu ɨ'ɨrɨ mœ, endje mbœrœ œrœ asœke kɔ ga tœ 'e, mbœrœ á endje wuwusœ uzu á tshe vwa mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Œdœ mœ kœnana má lima nene, á mœ kœpapa má ndje lima o'o fœ endje nene, endje mbœrœ má ekperœ nene. Kashe ngɔngɔ asœ endje kpa gugu dœ o'o kœpa tœ upu ekperœ nœ endje nene. ");
INSERT INTO kxf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Uzu á tshe kœyiangba mœ, yi ndje angba Aba mœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Œdœ mœ kœmbœmbœrœ lima ugurutœ endje akwa má anga angbɨ uzu œ mbœrœ nene, endje mbœrœ má ekperœ nene. Kashe ngɔngɔ asœke ɓata á endje wu œtœnœ ye, œ sœpe kœyiangba mœ dœ Aba mœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kashe œneke wuta yeka á o'o á endje sú lima ala awa akwa nœ endje kœmbœrœtœ ye. Endje su lima adœke: “Endje yiangba mœ gbambanœ.” ");
INSERT INTO kxf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Uzu neke á tshe na ndœ kœtɨ kane 'e, œ na zœ: Œshe kœdœ Ɨshirɨ nœ adja o'o á tshe to ɓa ndœ Aba. Mœ vwa bala she fœ 'e lœ awa nœ Aba yé tshe pa bala o'o tœ upu nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","E'e ndje, 'e pa o'o tœ upu nœ mœ mbœrœ á 'e sœ lima dœ mœ awa bale pe tœ ali kœtetœ kœmbœrœ akwa nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mœ pa o'onœ asœ kɔ fœ 'e adœke 'e kakatœ kœyindœrœ nœ 'e tɨ nene. ");
INSERT INTO kxf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Endje gɔrɔ 'e lœ anda Sinagoga. Ga pa nœ, ɔlɔ œ tɔ dœ anga osho, azu á endje wo 'e œ gbe adœke œne sœ ndje kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Endje mbœrœ ataa mbœrœ endje wuwusœ Aba œdœ ndje mœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kashe mœ pa tœnœ fœ 'e adœke bala olo nœ endje kœli yekane á œndœnœ œ te lœ 'e adœke mœ turu lima tœ o'o asœke fœ 'e ye.» «Mœ papa lima o'o fœ 'e utshunœ nene mbœrœ á mœ sœ lima awa bale dœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kashe ngɔngɔ asœke, mœ sœ kœgu ga ndœ tsheneke á tshe vwa mœ. Yé uzu bale ugurutœ 'e sœsœ kœyu mœ nene adœke: “Ɓœ gu gata a?” ");
INSERT INTO kxf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kashe lɔsu 'e su dœ oyo mbœrœ á mœ pa fœ 'e atamœ. ");
INSERT INTO kxf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yé œ li adœke mœ pa adja o'o fœ 'e: Œ ga waa mbœrœ 'e adœke mœ gu da ye, mbœrœ œdœ mœ kœgugu nene, tsheneke á li adœke tshe na kœtɨ kane 'e, œ na nene. Œdœ mœ kœgu da ye yekane á mœ vwa she fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yé lɔkɔ á tshe kœna, tshe ma djingili nœ tshapashɔ fœ she tœ upu nœ ekperœ, upu nœ kœsœ ndjii œdœ pe kœwa ngbanga. ");
INSERT INTO kxf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tœ upu nœ ekperœ, mbœrœ á endje sœsœ dœ kœyindœrœ ga ndœ mœ nene; ");
INSERT INTO kxf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","tœ upu nœ kœsœ ndjii, mbœrœ á mœ sœ kœgu ga ndœ Aba yé 'e kpa wu mœ nene; ");
INSERT INTO kxf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","tœ upu nœ kœwa ngbanga, mbœrœ á Ndjaba wa ɔgbɔ ngbanga ga tœ gbozu tshapashɔnœ asœke œ ka ye. ");
INSERT INTO kxf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mœ sœ dœ anga o'o ndjoro tœ kœpa fœ 'e, kashe 'e li kœdji tshelœ katanœ damba ngɔngɔ asœke nene. ");
INSERT INTO kxf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lɔkɔ á Ɨshirɨ nœ adja o'o œ na, tshe za awa fœ 'e adœke 'e wusœ adja o'o para kɔkɔ. Tshe pa bala o'o tœ upu nœ ye dœ tœ ye nene kashe o'o neke á tshe dji, yé œ mɨ ndje ndœ œrœ neke kɔ á wuta manda nœ. ");
INSERT INTO kxf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tshe yi bala sœ mokɔ nœ mœ; gbambanœ nene, tshe mɨ bala ndœ œneke á tshe gbɔ ɓa ndœ mœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Œrœ kɔ á Aba sœ dœ tœnœ kœdœ œnœ mœ, ádánœ á mœ pa adœke tshe mɨ bala ndœ œneke á tshe gbɔ ɓa ndœ mœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Manda olo teasho, 'e kpa wu mœ nene, yeka manda nœ á 'e kpa wu mœ» ");
INSERT INTO kxf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yé anga ayambarœ nœ ye yutœ endje ugurutœ endje adœke: «Œneta dá kɨ lœ ama ye ataa: “Manda aya olo, 'e kpa wu mœ nene, yeka teasho manda nœ á 'e kpa wu mœ”, too ndje: “Mœ gu ga ndœ Aba.” ");
INSERT INTO kxf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ádá olo teashonœ á tshe sœ kœpa tœnœ kœdœ gaɗe e? 'A wuwusœ o'o á tshe yindœ kœpa tœnœ nene!» ");
INSERT INTO kxf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yisu wu lima sœ nœ adœke endje yi lima ndœ kœyu œne yé á pa fœ endje adœke: «'E sœ kœyutœ 'e ugurutœ 'e tœ ádá o'o á mœ pa: “Manda aya olo, 'e kpa wu mœ nene, yeka teasho manda nœ á 'e kpa wu mœ.” ");
INSERT INTO kxf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mœ sœ kœpa fœ 'e dœ adjapu adœke 'e kɨ, 'e ta rawa kashe tshapashɔ œ sœ dœ yanga. 'E sœ dœ oyo kashe oyo nœ 'e œ fatœ endje tœ yanga. ");
INSERT INTO kxf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lɔkɔ á yashe nguzu œ zu, tshe wu oyo mbœrœ olo kuzu she li ye. Manda kœwuta gbolo, tshe kpa gbe dœ oyo á tshe wu nene, tshe sœ kolœ dœ yanga mbœrœ uzu á tshe zu she ga pa tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mbœrœ tœnœ ataa dá e'e ndje ngɔngɔ asœ, 'e sœ dœ oyo kashe mœ kpa wu 'e yé lɔsu 'e œ su dœ yanga neke á uzu bale œ za tœ lɔsu 'e nene. ");
INSERT INTO kxf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Yé dœ lɔkɔnœ asœmœ, 'e kpa yu mœ dœ upu bale nene. Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ 'e kœ'eshondœ anga œrœ ɓa ndœ Aba dœ ɨ'ɨrɨ mœ, tshe to bala tœnœ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Œrrr kpesheke 'e yɔyɔ damba ndœ œrœ bale dœ ɨ'ɨrɨ mœ nene. 'E yɔndœ nœ yé 'e gbɔ bala yeka á lɔsu 'e kœsu dœ yanga.» ");
INSERT INTO kxf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mœ pandœ œneke kɔ fœ 'e lœ ndœma toro. Ɔlɔnœ kœtɔ, mœ kpa pa o'o fœ 'e ataa nene, kashe mœ mɨndœ o'o ngbɨ tœ upu nœ Aba. ");
INSERT INTO kxf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lɔkɔnœ asœmœ, 'e eshondœ œrœ dœ ɨ'ɨrɨ mœ andaa mœ pa fœ 'e adœke mœ za avwala fœ Aba tœ upu nœ 'e nene. ");
INSERT INTO kxf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gbambanœ nene, Aba yindœ 'e dœ tœ ye mbœrœ á 'e yindœ mœ, á sœ dœ kœyindœrœ adœke mœ to ɓa ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mœ to ɓa ndœ Aba yé á na ga pa ɔshɔ. Ngɔngɔ asœ mœ katœ tshapashɔ tɨ œ sœ kœgu ga ndœ Aba.» ");
INSERT INTO kxf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ayambarœ nœ ye kœpa fœ she adœke: «Wu ngɔngɔ asœke ɓœ sœ kœsɔ ala o'onœ ngbɨ, œ ka ndje tœ kœpa o'o lœ ndœma toro ye. ");
INSERT INTO kxf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ngɔngɔ asœke 'a wusœ nœ adœke ɓœ wusœ œrœ kɔ, yé ádá adœke uzu yu ɓœ gugu nene. Mbœrœ tœnœ dá 'a yindœ nœ adœke ɓœ to ɓa ndœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisu kœgi fœ endje adœke: «'E yindœ nœ ngɔngɔ asœke a? ");
INSERT INTO kxf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'E wu adœke ɔlɔnœ yindœ kœtɔ tœnœ yé œ tɔ ye á 'e ndjɔtshelœtœ 'e, uzu dœ uzu dœ awa nœ ye á katœ mœ tɨ dœ kutɨ mœ. Kashe mœ sœsœ dœ kutɨ mœ nene, mbœrœ Aba sœ dœ mœ awa bale. ");
INSERT INTO kxf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mœ pa o'onœ asœke fœ 'e adœke 'e sœ dœ kœsœ gee lœ mœ. 'E wu oyo pa tshapashɔnœ asœ kashe 'e shi gbɨ! Mœ ropa tshapashɔ dœ gbɔgbɔ ye.» ");
INSERT INTO kxf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Manda kœpa o'onœ asœ, Yisu meosho ga lafo œ pa adœke: «Aba, ɔlɔnœ tɔ ye. Yisœ mokɔ nœ Gbolo nœ zœ adœke Gbolo nœ zœ yi ndje œsœ œnœ zœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yé mbœrœ tshagbozu á ɓœ za fœ she ga pa azu kɔ, tshe za soro neke á ka nene fœ azu kɔ á ɓœ ko endje fœ she. ");
INSERT INTO kxf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Andaa soro á ka nene, œtœnœ kœdœ adœke endje wusœ zœ á ɓœ dœ́ adja Ndjaba tshebale, œ wu ndje sœ Yisu Kristu á ɓœ vwa she. ");
INSERT INTO kxf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mœ yisœ mokɔ nœ zœ fœ azu pa ɔshɔnœ asœke, mœ mbœrœ akwa kɔ á ɓœ za fœ mœ adœke mœ mbœrœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yé Ngɔngɔ asœke, Aba, gi mœ ga lœ mokɔ á mœ sœ lima lœ nœ utshunœ adœke tshalafo dœ pe tshaatɨ sœ zœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mœ má ɨ'ɨrɨ zœ fœ azu á ɓœ ke endje pa tshapashɔ á ko endje fœ mœ. Endje kœdœ lima azu nœ zœ, á ɓœ ko endje fœ mœ yé endje dji o'o ama zœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Endje wusœ nœ ngɔngɔ asœke adœke, œneke kɔ á ɓœ ko fœ mœ to ɓa ndœ zœ, ");
INSERT INTO kxf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","adœke o'o á mœ pa fœ endje kœdœ o'o á ɓœ to fœ mœ. Endje dji œtœnœ, œ wu adja sœ nœ adœke mœ to ɓa ndœ zœ, yé endje yindœ nœ adœke œɓœ dá vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Mœ sœ kœza avwala mbœrœ endje, mœ sœsœ kœza avwala mbœrœ azu tshapashɔ nene, kashe mbœrœ endjeneke á ɓœ ko endje fœ mœ. Endje kœdœ azu nœ zœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yé œneke kɔ á mœ sœ dœ tœnœ kœdœ œnœ zœ ɓata œneke kɔ á dœ́ œnœ zœ kœdœ œnœ mœ. Mokɔ nœ mœ matœ ye lœ awa nœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mœ kpa sœsœpe pa tshapashɔ nene, kashe endje sœpe pa tshapashɔnœ asœke, andaa mœ sœ kœgu ga ndœ zœ. Œyerœ Aba, gbɔndœ endje lœ ɨ'ɨrɨ zœ á ɓœ za fœ mœ adœke endje wuta uzu bale ɓata œɓœ dœ mœ a sœ uzu bale. ");
INSERT INTO kxf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lɔkɔ á mœ sœ lima dœ endje, mœ sœ lima kœgbɔndœ endje lœ ɨ'ɨrɨ zœ á ɓœ za fœ mœ. Mœ gbɔ lima ndœ endje yé anga bale djidjingili awa nene kolœ tsheneke á li lima adœke tshe djingili awa yekane á œneke á endje sú ala Buku nœ zœ kœmbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Ngɔngɔ asœke, mœ sœ kœgu ga ndœ zœ. Mœ sœ kœpa o'onœ asœ damba mœ sœpe pa ɔshɔ adœke endje sú dœ yanga ɓata á mœ sú dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mœ yi lima sœ o'o ama zœ fœ endje, yé azu tshapashɔ yiangba endje mbœrœ endje dœ́dœ́ azu tshapashɔ nene ɓata œmœ, mœ dœ́dœ́ uzu tshapashɔ nene. ");
INSERT INTO kxf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mœ sœsœ kœyu ɓœ adœke ɓœ gi endje pa tshapashɔ nene kashe ɓœ gbɔndœ endje tœ ekperœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Endje dœ́dœ́ azu tshapashɔnœ asœke nene ɓata mœ dœ́dœ́ uzu tshapashɔ nene. ");
INSERT INTO kxf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mbœrœ adœke lœ awa nœ adja o'o, endje te ayerœ azu. O'o ama zœ kœdœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ɓata á ɓœ vwa mœ ga pa tshapashɔ, awa bale mœ vwa endje ga pa tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mœ sœ kœza soro mœ mbœrœ endje adœke endje te adja azu nœ zœ lœ awa nœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Mœ sœsœ kœza avwala kolœ mbœrœ ayambarœ nœ mœ nene, mœ za ndje avwala mbœrœ azu kɔ á endje sœ dœ kœyindœrœ ga ndœ mœ lœ awa o'o ama endje. ");
INSERT INTO kxf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kaka adœke endje para kɔkɔ endje sœ uzu bale ɓata œbœ Aba á ɓœ sœ lœ mœ, á mœ sœ lœ zœ; endje ndje, endje sœ lœ azœ yeka á tshapashɔ kœwusœ nœ adœke œɓœ dá vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yé œmœ, mœ za mokɔ á ɓœ za fœ mœ fœ endje adœke endje sœ uzu bale ɓata á a sœ dœ ɓœ uzu bale, ");
INSERT INTO kxf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","œmœ lœ endje ɓata œɓœ lœ mœ, adœke endje wuta adja bale yekane á azu tshapashɔ kœwusœ nœ adœke œɓœ dá vwa mœ, yé ɓœ yindœ endje ɓata á ɓœ yindœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Aba, ɓœ dá ko endje fœ mœ. Mœ yindœ nœ adœke osho á mœ sœ tœnœ, endjeneke á ɓœ ko endje fœ mœ sœ ndje tœnœ awa bale dœ mœ, adœke endje wu mokɔ á ɓœ za fœ mœ. Gbambanœ nene, ɓœ yi lima ndœ mœ utshu adœke ɓœ mbœrœ tshapashɔ. ");
INSERT INTO kxf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aba á ɓœ sœ ndjii, tshapashɔ wuwusœ zœ nene kashe mœ wusœ zœ yé endjeneke á endje sœ asœke, endje wusœ nœ adœke œɓœ dá vwa mœ. ");
INSERT INTO kxf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mœ yisœ ɨ'ɨrɨ zœ fœ endje yé mœ kpa yisœ nœ adœke kœyindœsho nœ zœ ga ndœ mœ sœ lœ endje yé œmœ dœ tœ mœ lœ endje.» ");
INSERT INTO kxf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Manda o'onœ asœke, Yisu ro awa bale dœ ayambarœ nœ ye ɓa kele yangangu Sedroni. Anga aya kɨndɨ sœ lima ɓa zœ á tshe li ga lœnœ dœ ayambarœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasi á tshe ka she wu lima sœ oshonœ; gbambanœ nene, Yisu sœ lima kœngbɔtœ ye kpala kpala dœ ayambarœ nœ ye ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudasi te utshu ukpulu aturugu, dœ aayi kœgbɔndœ anda Tepelo á agbozu tshapa anganga Ndjaba œdœ Afarisayi vwa endje. Endje wuta ɓa lœ aya kɨndɨnœ dœ owo tadja, dœ miinda œdœ pe œrœ kœnga dœ koshe. ");
INSERT INTO kxf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yé Yisu á tshe wu lima sœ œrœ kɔ á mbœrœ ga tœ ye, na á yu endje adœke: «'E sœ kœpara ɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Endje gi fœ she adœke: «Yisu, uzu Nazarete.» Á Yisu kœpa fœ endje adœke: «Œmœ dœke.» Andaa, Yudasi á tshe ka she sœ ndje lima ugurutœ azunœ zœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lɔkɔ á Yisu pa fœ endje adœke «Œmœ dœke», endje gitœ endje kɨtrɨkɨtrɨ ga mangbanœ yé œ yo ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yisu kpa kœyu endje adœke: «'E sœ kœpara ɗe e?» Endje kœgi adœke: «Yisu, uzu Nazarete.» ");
INSERT INTO kxf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Á Yisu kœpa fœ endje adœke: «Mœ pa fœ 'e adœke, œmœ dœke. Œdœ 'e kœsœ tœ kœpara mœ, 'e katœ endjeneke tɨ dœ endje gu.» ");
INSERT INTO kxf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Œ sœ ataa yeka á o'o á tshe pa lima kœmbœrœtœ ye. Tshe pa lima adœke: «Endjeneke á ɓœ ko endje fœ mœ, anga bale djidjingili awa nene.» ");
INSERT INTO kxf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ataa, Shimu Petro á tshe sœ lima dœ ɨngɨrɨ yakamba, gbota lœ ɔkɔnœ á wa utu ayi akwa nœ egerœ nganga Ndjaba ndja tœnœ. Œ dœ lima utu ga pa kuni nœ ayi akwa á ɨ'ɨrɨ ye kœdœ Malkusu. ");
INSERT INTO kxf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kashe yisu pa fœ Petro adœke: «Gi ɨngɨrɨ yakamba nœ zœ ga lœ ɔkɔnœ. Ɓœ gbe adœke mœ vwaratœ mœ tœ kœndjo yashi kanganœ á Aba za fœ mœ ye a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ukpulu aturugunœ dœ gbozu tshapa endje œdœ pe aayi kœgbɔndœ anda Tepelo á Ayuda vwa endje na œ za Yisu, œ i she ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Endje gu dœ she utshunœ ɓa ndœ Ana. Tshe kœdœ lima aba mbeya Kayifa á tshe dœ lima egerœ nganga Ndjaba lœ ungunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Œshe dœ́ Kayifa dá pa lima fœ Ayuda adœke: «Œ sœ dœ ɔtshɔnœ adœke uzu bale tshu lœ kumu azu kɔ.» ");
INSERT INTO kxf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shimu Petro dœ anga yambarœ bale na lima manda Yisu. Ɓata egerœ nganga Ndjaba wu lima sœ anga yambarœnœ dœ ɔtshɔnœ, tshe li awa bale dœ Yisu ga lœ gbagba anda nœ egerœ nganga Ndjabanœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kashe Petro sœpe lima œnœ ye ɓa pa gbagba ndo dœ manda nœ. Yé yambarœnœ á egerœ nganga Ndjaba wu lima sœ ye asœmœ kœwuta, á kœyu yashe kœgbɔndœ manda gbagbanœ, á to Petro li ga lœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yashe akwanœ á tshe sœ lima kœgbɔndœ manda gbagba kœyu Petro adœke: «Œɓœ ndje, œdœ ɓœ kœdœ anga yambarœ nœ yakoshe asœke nene a?» Petro kœgi adœke: «Œ dœ́dœ́ mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aayi akwa dœ pe aayi kœgbɔndœ anda Tepelo ngbɔ lima owo mbœrœ ɨzɨ, yé á sœ lima kœya kote endje ɨndɨrɨnœ. Petro sœ lima awa bale dœ endje á ka ndje ɨndɨrɨ owonœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Egerœ nganga Ndjaba tetœ kœyu Yisu tœ ayambarœ nœ ye œdœ pe œrœnœ á tshe yi lima sœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Á Yisu kœgi fœ she adœke: «Mœ pa o'o ngbɨ fœ azu tshapashɔ. Mœ yi lima sœ œrœ ɓa lœ Sinagoga dœ pe ɓa lœ Tepelo ɓa tœ osho á Ayuda kɔ sœ kœngbɔɓatœ endje. Mœ papa anga o'o wutœnœ œ wu nene. ");
INSERT INTO kxf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mbœrœ gaɗe á ɓœ yu mœ a? Yu azu á endje dji mœ mbœrœ endje wusœ o'o á mœ pa dœ ɔtshɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kœdji Yisu ataa, anga ayi kœgbɔndœ egerœ nganga Ndjaba kœda ala ye á kœpa fœ she adœke: «Mara kœgi dœ o'o fœ gbozu nganga Ndjaba dœke a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yisu kœgi fœ she adœke: «Œdœ mœ kœpa tœ ekpenœ, ma fœ mœ adœke mœ pa ekpe o'o. Á mœ kœpa ɔtshɔ o'o, mbœrœ gaɗe á ɓœ da mœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Á Ana kœvwa Yisu dœ uwu á endje i dœ she tœ ye ga ndœ Kayifa egerœ nganga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lœ nœ kɔ asœmœ, Petro sœ kolœ ɓa lœ gbagba á sœ kœya kote ye. Endje kœpa fœ she adœke: «Adja ɓœ dœ́dœ́ anga yambarœ nœ yakoshe asœke nene a?» Petro kœ'eatœ ye adœke: «Œ dœ́dœ́ mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Anga ayi akwa nœ egerœ nganga Ndjabanœ, á tshe dœ́ ayo nœ uzu á Petro wa lima utu ye, kœpa fœ she adœke: «Œ dœ́dœ́ ɓœ dá mœ wu kpœke 'e dœ she ɓa lœ kɨndɨ nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro kpa kœ'eatœ ye, yé trale kɔngato kœkɨ. ");
INSERT INTO kxf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Manda nœ, endje to Yisu ɓa ndœ Kayifa á ro dœ she ɓa lœ egerœ anda olo nœ gbozugo Roma. Kashe dœ amazɨ tuu, agbozu yuda á endje na lima dœ she lili ga sœnda nene kparawa kœli ga lœ angwa yekane á kœzɨ rœgo Pake. ");
INSERT INTO kxf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato kœwuta ga ndœ endje á kœyu endje adœke: «Mbœrœ gaɗe á 'e na kœtɔ meza pa yakoshe asœke a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Endje gi adœke: «Œdœ tshe kœmbœmbœrœ má ekperœ nene, ádá kœna má dœ she fœ ɓœ kœdœ gaɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kœpa fœ endje adœke: «'E za she œ wa o'o dœ tœ 'e ga tœ ye liaka awa akwa nœ 'e.» Ayudanœ kœpa adœke: «Endje zaza awa fœ 'a adœke 'a wo uzu nene.» ");
INSERT INTO kxf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Œneke wuta mbœrœ kœma o'o á Yisu pa lima tœ kœyisœ mara kuzu á tshe tshu bala dœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato li ga sœnda, á e Yisu, yé á yu she adœke: «Œɓœ kœdœ gbozugo nœ Ayuda a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yisu kœgi fœ she adœke: «Ɓœ pa ataa dœ tœ zœ too anga azu dá pa fœ ɓœ atamœ tœ upu nœ mœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kœgi: «Œmœ kœdœ uzu Yuda a? Adja azu ogo nœ zœ dœ agbozu tshapa anganga Ndjaba dá za ɓœ fœ mœ, œrœ gaɗe dá ɓœ mbœrœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yisu kœgi adœke: «Ogo gbozu nœ mœ dœ́dœ́ œnœ tshapashɔnœ asœke nene. Œ kœdœ má œnœ tshapashɔ asœke, aayi kœte manda mœ œ nga má koshe tshangba mœ adœke endje za mœ fœ ayuda nene. Kashe Ogo gbozu nœ mœ, lœ ngɔngɔ asœke dœ́dœ́ œnœ tshakpœke nene.» ");
INSERT INTO kxf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato kœyu she adœke: «Ɓœ dœ gbozugo a?» Yisu kœgi adœke: «Œɓœ dá pa adœke œmœ kœdœ gbozugo. Endje zu mœ yé mœ na ga pa ɔshɔ mbœrœ kœpa o'o tœ upu nœ adja o'o. Uzu kɔ á tshe na manda adja o'o, tshe dji o'o á mœ pa.» ");
INSERT INTO kxf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Á Pilato kœyu she adœke: «Adja o'o kœdœ gaɗe e?» Pa o'onœ asœke, Pilato kœwuta á kœgbɔ Ayuda ɓa ushu, á pa fœ endje adœke: «Tœ œmœ nœ mœ, mœ gbɔgbɔ anga ekperœ bale á li ndœ kœwa ngbanga ga tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ka ɓata ungu dœ ungu, œ li adœke mœ vwara anga uzu bale dœ lɔkɔ Pake, 'e yindœ nœ adœke mœ vwara gbozugo nœ Ayuda a?» ");
INSERT INTO kxf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yé endje kœtetœ kœta rawa adœke: «Œ dœ́dœ́ tshenekemœ nene, kashe Barabase!» Andaa Barabase kœdœ lima ayi kœmbœrœ ngbɨndɨrœ. ");
INSERT INTO kxf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Á Pilato kœza awa adœke endje za Yisu yé œ sɔ she dœ ndjapa. ");
INSERT INTO kxf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aturugu djo lima kpoto dœ ishi, œ za ga tœ kumu ye, yé œ verœ yɔgbɔdɔ odoro lœba ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Endje gi lima tœ endje ndoo dœ she yé œ pa lima adœke: «Abala, gbozugo nœ Ayuda!» Yé œ tetœ kœda tshatshu ye. ");
INSERT INTO kxf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kpa kœli ga sœnda á kœpa fœ Ayuda adœke: «'E dji mœ ka! Mœ sœ kœna kœto she wuta tœnœ fœ 'e. Kashe 'e wusœ nœ adœke mœ gbɔgbɔ anga ekperœ bale lœ ye tœ kœwa ngbanga ga tœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yisu wuta lima ga ushu. Tshe verœ lima kpoto dœ ishi tœnœ œdœ pe egerœ odoro lœba. Yeka á Pilato pa adœke: «Yakoshenœ dœke!» ");
INSERT INTO kxf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lɔkɔ á agbozu tshapa anganga Ndjaba dœ aayi kœgbɔndœ anda Tepelo wu lima she, endje te lima tœ kœta rawa adœke: «Wo she ɓa pa kurushi! Wo she ɓa pa kurushi!» Á Pilato kœpa fœ endje adœke: «'E za she dœ tœ 'e œ wo she pa kurushinœ. Kashe œmœ, mœ gbɔgbɔ anga œrœ bale lœ ye tœ kœwa ngbanga ga tœ ye nene.» ");
INSERT INTO kxf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayuda kœgi fœ she adœke: «'A sœ dœ awa akwa bale, yé awa akwanœ pa adœke tshe li dœ kuzu; gbambanœ nene, tshe pa adœke œne kœdœ Gbolo nœ ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lɔkɔ á Pilato dji o'onœ atamœ, awa li tœ ye kpakpakpa. ");
INSERT INTO kxf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tshe kœli ga sœnda, á kœyu Yisu adœke: «Œɓœ kœdœ uzu ɓata a?» Kashe Yisu ɨɨ ama ye bale dœ o'o fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yé Pilato kœpa fœ she adœke: «Ɓœ yiyindœ kœgi o'o fœ mœ nene a? Ɓœ wuwusœ nœ nene adœke mœ sœ dœ gbɔgbɔ tœ kœza awa fœ ɓœ, ɓœ gu ɓata á mœ sœ ndje dœ gbɔgbɔ tœ kœwo ɓœ pa kurushi nene a?» ");
INSERT INTO kxf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kashe Yisu gi adœke: «Ɓœ sœsœ dœ gbɔgbɔ bale pa mœ nene, kolœ œneke á Ndjaba za fœ ɓœ. Mbœrœ tœnœ ataa, uzu á tshe ka mœ fœ ɓœ mbœrœ egerœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kœto kpœtœmœ, Pilato para lima awa ndœ kœvwara she kashe Ayuda te lima tœ kœta rawa dœ ɔgbɔ adœke: «Œdœ ɓœ kœvwara she dá ɓœ dœ́dœ́ yanga Sezare nene. Gbambanœ nene, uzu kɔ á tshe pa adœke œne kœdœ gbozugo, sœ kœyiangba Sezare.» ");
INSERT INTO kxf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato kœdji ataa á kœto Yisu wuta tœnœ, á tshe kœsœ ga atɨ ɓa tœ osho kœwa ngbanga á ɨ'ɨrɨnœ kœdœ «osho kœsœ á endje guma dœ badja ga lafo.» – Dœ o'o ama ogo nœ Ayuda kœdœ «Gabata». ");
INSERT INTO kxf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Œ sœpe lima olo bale utshu angbo pake ndoo dœ kakpi ɔlɔ Pilato kœpa fœ Ayuda adœke: «Gbozugo nœ 'e dœke!» ");
INSERT INTO kxf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kashe endje lœ kolœ kœta rawa adœke: «Wo she ye! Wo she ye! Wo she pa kurushi!» Pilato kœpa adœke: «Mœ wo gbozugo nœ 'e ɓa pa kurushi a?» Agbozu tshapa anganga Ndjaba kœpa adœke: «'A sœsœ dœ anga gbozugo nene, kolœ Sezare tshebale.» ");
INSERT INTO kxf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mbœrœ tœnœ ataa, Pilato kœvwara Yisu fœ endje adœke endje wo she ɓa pa kurushi. Endje kœza Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tshe za kurushi nœ ye dœ tœ ye, œ wuta kœro ga tœ osho á endje ta ɨ'ɨrɨnœ adœke «osho gbayashi kɔrɔ», á endje e dœ o'o ama ogo Ayuda adœke «Gologota.» ");
INSERT INTO kxf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɓa zœ dá endje kuru lima Yisu ga pa kurushi awa bale dœ aayi angba bisha; bale ga pa kuni, bale ga pa gele yé Yisu sœ lima kpœgurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato za lima awa adœke endje sú anga mbeti œ ɓi ga pa kurushinœ. Mbetinœ pa adœke: «Yisu uzu Nazarete, gbozugo nœ Ayuda.» ");
INSERT INTO kxf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayuda ndjoro dɨ lima mbetinœ mbœrœ osho á endje ɓi lima Yisu ɓa pa kurushi tœnœ sœ lima ndoo dœ tshelœ ongbo. Ga pa nœ dœmœ, endje kpa su lima mbetinœ dœ o'o ama ogo nœ Ayuda, dœ o'o ama ogo nœ azu Roma ndje dœ o'o ama ogo Agreke. ");
INSERT INTO kxf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Agbozu tshapa anganga Ndjaba nœ Ayudanœ pa lima fœ Pilato adœke: «Susu adœke “gbozugo nœ Ayuda nene”, kashe adœke “uzunœ asœke pa adœke œne kœdœ lima gbozugo nœ Ayuda.”» ");
INSERT INTO kxf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kœgi fœ endje adœke: «Œneke á mœ su, mœ su ye.» ");
INSERT INTO kxf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Manda kœɓi Yisu ga pa kurushinœ, aturugu ko lœba nœ ye, œ kurutshelœ nœ vana yé uzu dœ uzu gbɔ œsœ œnœ ye. Œ sœpe lima kolœ egerœ ɨngɨrɨ lœba nœ ye á endje guguma kœsu tœnœ nene asœmœ, œtœnœ kœdœ akpa lœba bale á endje sú ɓa tœ ɨgɨ ye œrrr ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aturugu pa lima ugurutœ endje adœke: «A susuru tshelœ œneke nene. A ta wuka á kœwusœ uzu á tshe za lœba œneke.» Œneke wuta lima adœke ataa mbœrœ o'o á endje sú ala Buku nœ Ndjaba kœmbœrœtœ ye. Endje su lima adœke: «Endje kurutshelœ lœba nœ mœ tœ endje, yé endje ta wuka pa egerœ ɨngɨrɨ lœba nœ mœ.» 'E wu œrœ á aturugu mbœrœ lima. ");
INSERT INTO kxf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Anga ayashe ka lima ndoo dœ kurushinœ. Ayashe asœmœ kœdœ lima Mareya ayi Yisu, dœ yingɔ ayinœ dœ Mareya, awo Kolopase œdœ ndje Mareya uzu Magadala. ");
INSERT INTO kxf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yisu kœwu ayinœ, á kœwu ndje ndoo dœ she yambarœ á tshe yi lima ndœ ye. Yisu kœpa fœ ayinœ adœke: «Yashe, wu gbolo nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Á kpa kœpa ndje fœ yambarœnœ adœke: «Wu ayi zœ.» Pe dœ ada ɔlɔnœ asœmœ, yambarœnœ kœza Mareya ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Manda nœ, ɓata á Yisu wu lima sœ nœ adœke akwa nœ œne ka kɔ ye, adœke o'o á endje sú ala Buku nœ Ndjaba kœmbœrœtœ ye, tshe pa adœke: «Ogo ungu sœ kœmi mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Anga yashi sœ lima kpœtœmœ, á su dœ ikpi vinu. Aturugu yi ndɔhɔrɔ ga la ikpi vinunœ, á vwele ga tœ ganea ɔyɔ Izope, á yi ga tœ ama Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lɔkɔ á Yisu ndjo ikpi ipinœ asœmœ, tshe pa adœke: «Akwa nœ mœ ka kɔ ye.» Tshe tara kumu ye ga atɨ yé œ tshu ye. ");
INSERT INTO kxf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Andaa, ɓata œ dœ lima biko mindu utshu lɔkɔ sabata - Sabatanœ asœmœ kœdœ lima egerœ lɔkɔ sabata, agbozu yuda yiyi lima ndœ nœ adœke oko endje sœpe pa kurushi nene. Endje na lima kœyu Pilato adœke œne na œ kavwa tshelœ ada endje yé œ gbota endje ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Á aturugu kœna, á kœkavwa tshelœ ada ali uzunœ ye, œ kpa na œ kavwa œnœ anga bishanœ ye, á endje ɓi lima endje ga pa kurushi awa bale dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yé kœwuta endje ndoo dœ Yisu atake, endje wu adœke tshe tshu ɓamama ye. Mbœrœ tœnœ dá endje kakavwa lima tshelœ ada ye nene. ");
INSERT INTO kxf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kashe anga turugu bale su djokoro Yisu dœ udu yé ngbewo indji dœ ungu wuta. ");
INSERT INTO kxf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uzu tsheneke á tshe wu lima dœ ala ye pa lima o'o tœ upunœ, yé o'o á tshe pa kœdœ adja o'o. Uzunœ asœmœ wusœ nœ adœke œne pa o'o á dœ́ adja o'o adœke e'e ndje, 'e yindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Œ wuta lima atamœ adœke o'o á endje sú ala Buku nœ Ndjaba kœmbœrœtœ ye. Endje su lima adœke: «Endje kavwa bala tshelœ anga ngbabi ye bale nene.» ");
INSERT INTO kxf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Endje su ndje lima anga o'o ala Buku adœke: «Endje wu bala uzunœ á endje sú she.» ");
INSERT INTO kxf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Manda nœ kɔ, Yozefu uzu Arimateyo, á tshe dœ́ anga yambarœ nœ Yisu lœ ubunœ, na lima kœyu Pilato adœke œne za oko Yisu. Pilato za lima awa fœ she yé tshe na lima œ za oko Yisu. ");
INSERT INTO kxf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodeme á tshe na lima ga ndœ Yisu dœ abutshɔ, na ndje dœ yombo á endje mbœrœ dœ mire á ngbɔɓa dœ ɔyɔ alowe á wuta litere zazu bale dœ ndjokpa. ");
INSERT INTO kxf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Endje za oko Yisu, œ vwele dœ a'eara lœba á endje yi ga la kada yombo liaka akwa Ayuda œ mbœrœ utshu kœshi akuzu nœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Anga kɨndɨ tshamadungba sœ lima ndoo dœ osho á endje kuru lima dœ Yisu ga pa kurushi, yé anga tafo udu bale á endje dji lima lœ badja, á damba endje shishi uzu ga lœnœ nene sœ lima lœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɓata á dœ lima olo ndoo dœ lɔkɔ sabata, yé kœwu adœke kudunœ sœ lima ndoo kpœtœmœ, endje shi lima Yisu ga lœnœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɔlɔ yenga pe dœ amazɨ á osho sœpe kœde damba howaa, Mareya uzu Magadala na ga pa udu. Tshe wu adœke azu ɨvwɨ badja á endje vwɨrɨ lima ga tœ ama kudunœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tshe kpagu dœ ɔrɔ ga ndœ Shimu Petro dœ yambarœnœ á Yisu yi lima ndœ ye á kœpa fœ endje adœke: «Endje za Gbozu lœ koto yé a wuwusœ osho á endje za she tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Á Apetro dœ yambarœnœ asœmœ wuta lima kœna ga pa udunœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Endje te lima tœ ɔrɔ bibisha kpa tœnœ awa bale, kashe anga yambarœnœ kpa kœropa Petro yé œ wuta utshunœ ga pa udunœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tshe ti ga lœ udunœ yé œ wu ndœma lœba lœnœ kashe tshe lili lima ga lœ udunœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Petro wuta œnœ ye manda ye, œ li ga lœ udunœ, œ wu ndje ndœma lœbanœ asœmœ atɨ ɓa zœ, ");
INSERT INTO kxf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ndje dœ pe lœba á endje za lima tshu ga pa kumu ye. Lœbanœ sœsœ lima tœ œsœnœ bale dœ a'eara ndœma lœbanœ nene. Kashe œ sœ lima kpi ga tœ anga angbɨ osho. ");
INSERT INTO kxf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Trale, anga yambarœnœ á tshe wuta má utshunœ kœli ga lœ udunœ, œ wu yekane á yindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Œrrr ga tœ ɔlɔnœ asœmœ, ayambarœ wuwu lima damba sœ ádá o'o á endje sú adœke Ndjaba œ she bala Yisu lœ akuzu nene. ");
INSERT INTO kxf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Manda nœ, ayambarœnœ bibisha fatœ endje kœgu ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mareya ka lima ɓa ushu ndoo dœ tshapadunœ á sœ lima tœ ɨkɨ. Tshe sœ lima tœ ɨkɨ, œ sœ ndje kœti ga lœ udunœ. ");
INSERT INTO kxf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Á tshe kœwu aandjelu bisha á endje verœ imbi lœba. Endje lœ ga atɨ ɓa tœ osho á endje za lima oko Yisu ga tœnœ; anga bale ɓa tœ osho á endje fa kumu ye ga tœnœ yé anga ɓa tœ œsœ ada ye. ");
INSERT INTO kxf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aandjelunœ kœyu Mareya adœke: «Mbœrœ gaɗe á ɓœ kɨ a, yashe?» Tshe kœgi fœ endje adœke: «Endje za oko Gbozu nœ mœ yé mœ wuwusœ osho á endje za she tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tshe kœfatœ ye manda kœgi o'onœ, œ wu Yisu á tshe ka lima kpœtœmœ kashe tshe wuwu lima sœ nœ adœke Yisu dœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yisu kœyu she: «Mbœrœ gaɗe á ɓœ kɨ a, yashe? Œɗe dá ɓœ sœ kœpara she a? Mareya gbe adœke ayi kœguma tshelœ kɨndɨ tshamadungbanœ dœmœ yeka á pa fœ she adœke: Œdœ ɓœ dá za oko ye, yisœ oshonœ á ɓœ za she ga tœnœ dœ́ mœ na œ za she.» ");
INSERT INTO kxf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yisu kœpa fœ she adœke: «Mareya!» Tshe i gbandjuru á pa fœ she adœke: «Rabuni» - Œ yindœ kœpa dœ o'o ama ogo Ayuda adœke «Ayi kœyisœrœ». ");
INSERT INTO kxf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yisu kœpa fœ she adœke: «Gogoro mœ nene mbœrœ mœ ɔɔ damba ga ndœ Aba mœ nene.» Kashe, gu œ pandœ nœ fœ aaya, mœ sœ kœgu ga ndœ Aba mœ á tshe kœdœ Aba 'e, ga ndœ Ndjaba nœ mœ á tshe kœdœ Ndjaba nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mareya uzu Magadala kœgu á kœpandœ nœ fœ ayambarœ adœke: «Mœ wu Gbozu, yé 'e dji œneke á tshe pa fœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kolœ dœ adɨla yenganœ asœmœ, ayambarœ ngbɔɓa lima tœ endje ɓa sœnda. Endje tshu lima manda kperœ ga tœnœ kparawa Ayuda. Yisu na lima œ ka ɓa ugurutœ endje á pa fœ endje adœke: «Kœsœ gee sœ dœ e'e.» ");
INSERT INTO kxf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Manda kœpa fœ endje ataa, tshe kœma tshakane ye œdœ pe djokoro ye fœ endje. Lɔsu ayambarœ su dœ yanga mbœrœ kœwu Gbozu. ");
INSERT INTO kxf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yé Yisu kpa kœpa fœ endje adœke: «Kœsœ gee sœ dœ e'e! Ɓata Aba vwa mœ, œmœ ndje mœ sœ kœvwa 'e.» ");
INSERT INTO kxf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Manda kœpa o'onœ asœke, tshe uru ɨzɨ ga pa endje, á pa adœke: «'E gbɔ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Azu neke á 'e djerœ bala ndœ ekperœ nœ endje, Ndjaba œ djerœndœ nœ. Yé endjeneke á 'e vwaratœ 'e tœ kœdjerœndœ ekperœ nœ endje, Ndjaba œ vwara ndje tœ ye tœ kœdjerœndœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Andaa lɔkɔ á Yisu má lima tœ ye fœ ayambarœ ɓa sœnda, Toma, anga andjokpa dœ bishanœ á endje e she Didime gugu lima nene. ");
INSERT INTO kxf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Anga udu anganœ pa lima fœ she adœke: «'A wu Gbozu!» Kashe tshe pa fœ endje adœke: «Œdœ mœ kœwuwu tshangba uku sete tshakane ye nene, œdœ mœ kœyiyi yɔkɔne mœ ga lœ kudu setenœ nene, yé œdœ mœ kœyiyi kane mœ ga lœ djokoro ye nene, mœ yi ndœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Andaa olo mindu dœ votɔ manda nœ, ayambarœ kpa ngbɔɓa lima tœ endje ɓa sœnda, œ tshu manda kperœ ga tœnœ yé Toma sœ lima ugurutœ endje. Yisu na lima œ ka ɓa ugurutœ endje á pa adœke: «Kœsœ gee sœ dœ 'e!» ");
INSERT INTO kxf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Manda nœ tshe pa fœ Toma adœke: «Yi yɔkɔne zœ kpœke dœ́ œ wu tshakane mœ. Yi kane zœ œ nduru ga lœ djokoro mœ. Katœ sharapu, œ te uzu nœ kœyindœrœ.» ");
INSERT INTO kxf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma kœgi fœ she adœke: «Gbozu nœ mœ œdœ Ndjaba nœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yisu kœpa fœ she adœke: «Ɓœ yindœ nœ mbœrœ á ɓœ wu mœ a? Yanga nœ azu neke á endje wuwu nene, kashe endje yindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisu mbœrœ lima anga angbɨ ambárá afá ndjoro dœ ala ayambarœ nœ ye, kashe endje súsú kɔ ga la bukunœ asœke nene. ");
INSERT INTO kxf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kashe œneke á endje sú ga la bukunœ asœke sœ mbœrœ á 'e kœyindœ nœ adœke Yisu kœdœ Kristu, Gbolo nœ Ndjaba. Œdœ 'e kœsœ dœ kœyindœrœ ga ndœ ye, 'e gbɔ soro dœ ɨ'ɨrɨ ye. ");
INSERT INTO kxf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Manda nœ, Yisu kpa matœ ye fœ ayambarœ nœ ye ɓa tœ mangu egerœ ungu adanga Tiberiade. Tshe ma lima tœ ye fœ endje dœ mara atake: ");
INSERT INTO kxf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shimu Petro, Toma á endje e ndje she Didime, Natanayele uzu tshalakpɨ Kanana ɓa lœ ogo Galilayi, agbolo nœ Zebedayi, œdœ pe anga angbɨ ayambarœ bisha sœ lima kpœtœ œsœnœ bale. ");
INSERT INTO kxf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Shimu Petro kœpa fœ endje adœke: «Mœ sœ kœtara ndœ kœvwɨ gbanda.» Yé endje kœpa fœ she adœke: «'A ro dœ ɓœ.» Endje ro lima œ ɔ ga lœ egerœ agba kashe dœ butshɔnœ asœmœ, endje gbɔgbɔ œrœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lɔkɔ á osho tetœ kœkɔrɔ tœnœ, Yisu ka lima ga tœ mangu kashe ayambarœnœ wuwu lima sœ nœ adœke œshe dœmœ nene. ");
INSERT INTO kxf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yisu kœpa fœ endje adœke: «Agbolo, 'e gbɔgbɔ anga ageatshalangu teasho nene a?» Endje kœgi fœ she adœke: «Œrœ bale nene.» ");
INSERT INTO kxf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yisu kœpa fœ endje adœke: «'E vwi gbandanœ ga pa kuni yé 'e œ gbɔ endje ye.» Endje kœvwi gbandanœ, yé ageatshalangu do lima pa nœ dœ mara adœke endje lili lima kœgbota tœnœ ga ushu nene. ");
INSERT INTO kxf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yambarœ á Yisu yi lima ndœ ye kœpa fœ Petro adœke: «Gbozu dœmœ!» Lɔkɔ á tshe dji adœke Gbozu dœmœ, tshe kœverœ lœba ga tœ ye; gbambanœ nene, tshe sœ lima kpendro, á tshe kœte lima ga la ngu. ");
INSERT INTO kxf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Udu ayambarœnœ kœgu dœ egerœ agbanœ dœ kœgbota gbandanœ pete dœ ageatshalangu: endje sœsœ lima lœ ɨngɨrɨnœ tœ ama osho nene, ga pa œrœ nœ́ metere kama bale (100). ");
INSERT INTO kxf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lɔkɔ á endje wuta ga tœ mangu, endje wu lima jiwo á endje ko ageatshalangu dœ pe mapa ga pa nœ. ");
INSERT INTO kxf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yisu kœpa fœ endje adœke: «'E na dœ ageatshalangunœ á 'e wuta kœgbɔ endje asœke gamœ.» ");
INSERT INTO kxf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Shimu Petro kœɔ ga lœ egerœ agba á kœgbota gbandanœ ga atɨ dœ agboro ageatshalangu lœ nœ kama dœ zazu bisha dœ ndjokpa dœ votɔ (153). Agea ngba lima waa kashe tshelœ gbanda susuru lima nene. ");
INSERT INTO kxf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yisu kœpa fœ endje adœke: «'E na œ zɨ œrœ.» Anga uzu bale ugurutœ endje á tshe ɨ lima ama ye tœ kœyu she adœke: «Dá œɓœ kœdœ ɗe e?» gugu nene. Endje wu lima sœ nœ dœ ɔtshɔnœ adœke Gbozu dœmœ. ");
INSERT INTO kxf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yé Yisu na, œ za mapa á kurutshelœ nœ tœ endje, á mbœrœ ndje awa bale dœ ageatshalangunœ. ");
INSERT INTO kxf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Asœ kœdœ lima awa votɔ kœmatœ Yisu fœ ayambarœ nœ ye kœto tœ lɔkɔnœ á Ndjaba she lima she lœ kuzu. ");
INSERT INTO kxf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Manda kœzɨ œrœ, Yisu kœyu Shimu Petro adœke: «Shimu, gbolo nœ Yowane, ɓœ yindœ mœ kœropa endjeneke kɔ a?» Yé tshe kœgi adœke: «Œ̃, Gbozu, ɓœ wusœ nœ adœke mœ yindœ zœ.» Yisu kœpa fœ she adœke: «Gbɔndœ apata nœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tœ bishanœ, Yisu kpa yu she adœke: «Shimu, gbolo nœ Yowane, ɓœ yindœ mœ?» Petro gi adœke: «Œ̃, Gbozu, ɓœ wusœ nœ adœke mœ yindœ zœ ye.» Yisu kœpa fœ she adœke: «Sœ uzu nœ kœgbɔndœ apata nœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tœ votɔnœ, Yisu yu she adœke: «Shimu, gbolo nœ Yowane, ɓœ yindœ mœ?» Oyo kœza Petro kœwu adœke Yisu kpa yu she tœ votɔnœ adœke: «Ɓœ yindœ mœ?» Yé tshe kœpa fœ she adœke: «Gbozu, œɓœ á ɓœ wusœ œrœ kɔ, ɓœ wusœ nœ dœ ɔtshɔnœ adœke mœ yindœ zœ ye.» Á Yisu kœpa fœ she adœke: «Gbɔndœ apata nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mœ sœ kœpa fœ ɓœ dœ adjapu adœke ɔlɔ á ɓœ sœpe lima aya gbolo, ɓœ du lima uwu tshapa lœba nœ zœ dœ tœ zœ, œ na lima tœ osho á ɓœ yi lima ndœ nœ. Kashe ɔlɔ á ɓœ kœwuta yagbozu, ɓœ ko kane zœ ga lafo yé anga uzu kpi dá ɨ uwu ga pa lœba fœ ɓœ, yé á to ɓœ na tœnœ ɓa tœ osho á ɓœ yiyindœ nœ nene.» ");
INSERT INTO kxf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yisu pa lima ataa mbœrœ kœma mara á Petro œ yisœ mokɔ nœ Ndjaba lœ kuzu ye. Manda kœpa o'onœ asœke, Yisu pa fœ she adœke: «Na manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro kœfatœ ye, á kœwu yambarœ á Yisu yi lima ndœ ye, tsheneke á dœ lɔkɔ á endje sœ lima kœzɨ œrœ á tshe dɨ lima tœ ye ga lakoro Yisu yekane á yu she adœke: «Gbozu, œɗe dá ka bala ɓœ a?» ");
INSERT INTO kxf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lɔkɔ á Petro wu lima she, tshe pa fœ Yisu adœke: «Ka œshe a Gbozu, œrœ gaɗe dá mbœrœ fœ she a?» ");
INSERT INTO kxf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yisu kœgi fœ she adœke: «Œ kœsœ adœke œndœ ye dɨ œrrr ga tœ kpa kœkwa mœ, œnœ zœ lœ nœ kœdœ gaɗe? Œɓœ, na manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kœto pa o'onœ asœke dá o'o kɨ gooo ugurutœ alaya adœke yambarœnœ asœmœ œ tshu nene. Andaa Yisu papa lima fœ she nene adœke: tshe tshu nene. Kashe tshe pa adœke: «Œdœ mœ kœyindœ nœ adœke œndœ ye dɨ œrrr ga tœ kpa kœkwa mœ, œnœ zœ lœ nœ kœdœ gaɗe e?» ");
INSERT INTO kxf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Adja yambarœnœ asœmœ dœ tœ ye dá pandœ o'onœ asœke, á su ga la mbeti yé 'a wusœ nœ adœke œneke á tshe pa kœdœ adja o'o. ");
INSERT INTO kxf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisu mbœrœ lima anga angbɨ œrœ ndjoro á kœsœ má adœke endje sú kɔ bale dœ bale, mœ gbe adœke, osho œ li mbœrœ kœko bukunœ ga tœnœ pa ɔshɔ asœke nene.");
INSERT INTO kxf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Gbozu Teofile, ɓa la ali mbeti á mœ su fœ ɓœ, mœ pandœ œrœ kɔ á Yisu mbœrœ lima œdœ pe ndje œneke kɔ á tshe yi lima sœ nœ kœto ɓa tœ adanœ ");
INSERT INTO kxf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","œrrr ga tœ olo kœɔ she lima ga lafo. Utshu kœɔ she, tshe za o'o fœ aayi avwa nœ ye dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tshe ma lima tœ ye fœ endje manda kuzu á tshe tshu tœ kœma fœ endje adœke tshe sœ dœ soro. Tshe ma lima tœ ye fœ endje yé œ tetœ kœpa o'o tœ upu nœ Ogo gbozu nœ Ndjaba manda olo zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Anga lɔkɔ bale á tshe sœ lima kœzɨ œrœ dœ endje, tshe za o'o fœ endje adœke: «'E gigi damba tœ 'e lœ Yerusaleme nene kashe 'e kate œneke á Aba pa lima ndœ nœ adœke œne za fœ 'e ɓata á 'e dji lima lœ ama mœ. ");
INSERT INTO kxf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gbambanœ nene, Yowane za lima batisimu nœ ungu, kashe lœ ondonœ asœke, Ndjaba œ za batisimu nœ Ɔtshɔ Ɨshirɨ fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aayi avwanœ á endje ngbɔɓa lima tœ endje, yu Yisu adœke: «Gbozu, kolœ ngɔngɔnœ asœke dá ɓœ gi tshagbozu nœ ogo Israyele a?» ");
INSERT INTO kxf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tshe kœpa fœ endje adœke: «O'o nœ 'e gugu mbœrœ kœwusœ ada ɔlɔnœ too olonœ á Aba za lœ tshagbozu nœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kashe Ɔtshɔ Ɨshirɨ œ jerœ ga pa 'e, yé 'e gbɔ gbɔgbɔ mbœrœ kœna kœmɨndœ o'o nœ mœ lœ Yerusaleme, lœ ogo Yuda œdœ lœ Samariya djigi œrrr vesho ga tœ osho kɔ pa ɔshɔ.» ");
INSERT INTO kxf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Manda kœgi o'onœ ataa, tshe ɔ ngarrr dœ ala endje ga lafo yé œ yiwa lœ ondoro tœ ala endje. ");
INSERT INTO kxf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɓata á endje sœpe lima kœmesho ɨrɨrrr ga lafo, anga azu bisha dœ imbi lœba á endje ka lima ndoo dœ endje ");
INSERT INTO kxf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kœpa fœ endje adœke: «Azu Galilayi, mbœrœ gaɗe á 'e sœpe kœmesho ga lafo a? Yisunœ á tshe ɔ dœ ala 'e asœmœ, tshe kwa ndje bala tœ ye ɓata á 'e wu she kœɔ tœnœ ga lafo asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Manda nœ, aayi avwanœ to ɓa pa kaga ɔyɔ Olive yé œ jerœ ga lœ Yerusaleme; kaganœ sœ lima ga pa œrœ nœ́ Kelometere bale tœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lɔkɔ á endje wuta, endje li ga lœ gbɔshɔ á endje lœ lima kœlo lœ nœ ɓa lafo. Œ dœ lima Petro, Yowane, Jake dœ Andere; Filipo dœ Toma; Bartelemi dœ Matie; Jake gbolo nœ Alefe, Shimu uzu kœ'e osho ndœ lipanda œdœ pe Yudasi gbolo nœ Jake. ");
INSERT INTO kxf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Endje kɔ, endje sœ lima dœ gbetshelœ bale, yé œ ngbɔɓatœ endje mbœrœ kœkɨ fœ Ndjaba ɔlɔ dœ ɔlɔ awa bale dœ anga ayashe ɓata Mareya á tshe zu Yisu œdœ pe ndje aaya Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lœ anga olonœ asœmœ bale, Petro áalafo ɓa ugurutœ ayindœ Yisu kama bale dœ zazu bale á endje ngbɔɓa lima tœ endje, yé œ pa ngbɨ adœke: ");
INSERT INTO kxf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Aaya, œ li adœke o'o á Ɔtshɔ Ɨshirɨ pa lima ndœ nœ ala Buku nœ Ndjaba, lœ ama gbozu Davidi tœ upu nœ Yudasi á tshe to lima azu na tœnœ ndœ kœza Yisu, mbœrœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Andaa Yudasi sœ lima awa bale dœ 'a yé tshe sœ lima ndje dœ akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Uzunœ asœmœ yɔ lima kɨndɨ dœ ngendja á endje ko lima fœ she manda ekperœ nœ ye. Tshe te lima dœ kumu ye, uvu ye de wuruu yé sheta ye yaranga ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Azu lœ Yerusaleme kɔ wusœ o'o asœke. Ádánœ á endje e ɨ'ɨrɨ kɨndɨnœ dœ o'o ama ogo endje adœke: Hakeldama, œ yindœ kœpa adœke “ɔshɔ indji”. ");
INSERT INTO kxf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yé endje sú ala mbeti nœ Itshi adœke: “Tshelœ gbagba nœ ye œ fa gusu yé uzu bale œ sœ lœ nœ nene.” Yé ga pa nœ dœmœ: “Anga angbɨ uzu œ za akwa nœ ye.” ");
INSERT INTO kxf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","A sœ dœ anga azu á endje na lima tœ awa dœ 'a dœ lɔkɔ á Gbozu Yisu sœ lima pa 'a, ");
INSERT INTO kxf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kœto kpœpa batisimu nœ Yowane œrrr ga tœ olo kœɔ she ga lafo. Œ li adœke anga uzu bale ugurutœ endje, te timu awa bale dœ 'a ndœ kœmɨndœ kœshe nœ ye ugurutœ akuzu.» ");
INSERT INTO kxf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Endje yisœ azu bisha: Yozefu á endje e she Barsabase á endje donga ndje she dœ ɨ'ɨrɨ Yustushe œdœ pe Matiase. ");
INSERT INTO kxf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yé manda nœ endje za avwala nœ endje para kɔkɔ adœke: «Œɓœ, Gbozu á ɓœ wusœ lɔsu uzu kɔ. Yisœ uzu tsheneke á ɓœ ke she ugurutœ azu bisha asœke ");
INSERT INTO kxf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","adœke tshe mbœrœ akwa nœ aayi avwa lœ kudu Yudasi á tshe katœ nœ tɨ, á na ga tœ osho á li dœ she asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Endje ta wuka mbœrœ kœgbɔ uzu bale yé wukanœ te ga pa Matiase. Ádánœ á tshe li ga ugurutœ aayi avwanœ ndjokpa dœ bale dœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lɔkɔ á olo angbo Patekɔte li, ayindœ Yisu ngbɔɓatœ endje para kɔkɔ ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Trale, ɨngɨrɨ to ɓa lafo ɓata egerœ yugu yé œ su tshelœ anda á endje sœ lima tœnœ djigi. ");
INSERT INTO kxf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Endje wu œrœ á wuta ga ndœ endje ɓata owo, œ kurutshelœtœ endje á sœ ga pa kumu uzu dœ uzu. ");
INSERT INTO kxf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Endje para kɔkɔ gbɔ Ɔtshɔ Ɨshirɨ yé œ tetœ kœpa angbɨ o'o ama ogo ɓata á Ɨshirɨ to fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Anga Ayuda nœ ɔtshɔ lɔsu sœ ndje lima lœ Yerusaleme, endje to lima djelœ ogo kɔ pa ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ɨngɨrɨ yugunœ za lima osho djigi, yé ukpulu azu ngbɔɓatœ endje œ sœ kœkɨtœ œsœnœ, mbœrœ uzu dœ uzu sœ lima kœdji o'o dœ adja o'o ama ogo ye. ");
INSERT INTO kxf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Endje kɨtœ œsœnœ, œ sœ dœ yanga yé á pa adœke: «Azunœ asœ para kɔkɔ á endje pa o'o asœ, dœ́dœ́ azu Galilayi nene a? ");
INSERT INTO kxf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Œ mbœrœ koto á uzu dœ uzu lœ ugurutœ azœ sœ kœdji endje dœ o'o ama ogo ye a? ");
INSERT INTO kxf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ugurutœ azœ, a sœ dœ Aparte, Amede dœ Elame, azu ogo Mezopotami, azu ogo Yuda dœ kapadose, azu ogo Ponte dœ Azi, ");
INSERT INTO kxf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","azu ogo Friji dœ Pafili, azu ogo Ezipito dœ azu tshakala ogo Sirene ɓa lœ Libi; anga endje kœdœ endjeneke á endje to lœ Roma, ");
INSERT INTO kxf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","adja Ayudanœ œdœ azu neke á endje wuta aayi kœdonga Ndjaba nœ Ayuda asœmœ; azu ogo Krete dœ endje nœ Arabi. Kashe azœ para kɔkɔ, a dji endje kœpa o'o dœ ama ogo azœ, kœgbara ogboro œrœ á Ndjaba mbœrœ.» ");
INSERT INTO kxf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Endje kɔkɔ, endje kɨ lima tœ œsœnœ, yé œ yutœ endje adœke: «Œ yindœ kœpa adœke gaɗe dœ mœ a?» ");
INSERT INTO kxf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kashe anga azu sœ lima kœmɔ endje adœke: «Ipi dá mbœrœ endje asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yé Petro kœza o'o ugurutœ aayi avwa ndjokpa dœ bale á endje sœ lima tœ œsœnœ, á kœpa dœ ɔgbɔ adœke: «E'e dœ Ayuda œdœ pe 'e dœ azu para kɔkɔ á 'e sœ lœ Yerusaleme kpœke, 'e wusœ œneke á sœ kœrotœ nœ, 'e dara utu 'e yé œ dji mœ dœ ɔtshɔnœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wala, azunœ asœke ndjondjo ipi ɓata á 'e sœ kœgbe tœnœ asœmœ nene: mbœrœ a sœ damba kolœ dœ ada ɔlɔ mindu dœ vana gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kashe œneke á sœ kœmatœ endje ngɔngɔ asœke kœdœ o'o á ayi kœgbara o'o Jowele pa lima. Tshe gbara lima adœke: ");
INSERT INTO kxf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ndjaba pa adœke: Lɔkɔ kœka tshapashɔ, mœ vwa Ɨshirɨ nœ mœ ga pa azu kɔ, agbolo yakoshe œdœ pe ayawuru nœ 'e œ te aayi kœgbara o'o, alanga nœ 'e œ wu bala œrœ lœ ulu, ayagbozu nœ 'e œ wu ndje bala œrœ lœ ulu. ");
INSERT INTO kxf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Adjapu, ɔlɔnœ asœmœ mœ vwa Ɨshirɨ nœ mœ ga pa aayi akwa nœ mœ dœ ayakoshe œdœ pe ayashe, yé endje te bala aayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mœ mbœrœ bala ogboro œrœ ɓa lafo, yé œ ma ambara afá ɓa pa ɔshɔ ɓa ke: indji œ tu, owo œ tshi yé ngawo œ da. ");
INSERT INTO kxf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ɔlɔ œ fa butshɔ, yé yapu œ sœ ɓata indji, utshunœ adœke olo kœna Gbozu li, egerœ olo œdœ olo nœ mokɔ. ");
INSERT INTO kxf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yé uzu kɔ á tshe kɨ dœ ɨ'ɨrɨ Gbozu, tshe she.” ");
INSERT INTO kxf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Azu tshelœ Israyele, 'e dji o'o mœ: Yisu, uzu tshœlœ Nazarete kœdœ lima uzu á Ndjaba ma gbɔgbɔ nœ ye fœ 'e lœ ye dœ awa nœ kœmbœrœ afá, ogboro œrœ œdœ kœma ambárá œrœ ɓa ugurutœ 'e ɓata á 'e wusœ nœ dœ tœ'e. ");
INSERT INTO kxf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Uzunœ asœmœ, 'e za lima she ga tshaabrœ azu á endje wuwusœ Ndjaba nene, yekane á endje wo she á kuru she ga pa kurushi lindœ agbe nœ Ndjaba á tshe guma. ");
INSERT INTO kxf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kashe Ndjaba she she, yé œ gbota she lœ kanga nœ kuzu mbœrœ œ lili adœke kuzu ropa ye dœ gbɔgbɔ nene. ");
INSERT INTO kxf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidi pa lima o'o tœ upu nœ ye adœke: “Ɔlɔ dœ ɔlɔ mœ sœ kœwu Gbozu utshu mœ, mbœrœ á tshe sœ ga tœ kuni mœ adja awa œ za mœ bale nene. ");
INSERT INTO kxf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mbœrœ tœnœ ataa, lɔsu mœ su dœ yanga yé ama mœ œ ɓi ndje itshi dœ yanga. Ga pa nœ kɔ, undu mœ œ yatœ ye lœ kœsœ gee mbœrœ á mœ za lɔsu mœ ga tœ zœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gbambanœ nene, Gbozu, ɓœ katœ mœ tɨ lœ ogo nœ akuzu nene, ɓœ yi ndje ndœ nœ adœke œmœ dœ́ œyerœ uzu nœ zœ mœ fu lœ koto akuzu nene. ");
INSERT INTO kxf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɓœ yi lima sœ awa soro fœ mœ, lɔsu mœ œ su dœ yanga mbœrœ kœsœ awa bale dœ ɓœ.” ");
INSERT INTO kxf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Aaya, œ li adœke mœ pa o'ara fœ 'e tœ upu nœ ata azœ dœ Davidi: tshe tshu lima, endje shi she yé tshapa udu ye sœpe damba œrrr kpesheke ndœ azœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kashe œshe kœdœ lima ayi kœgbara o'o, yé tshe wusœ nœ adœke Ndjaba dara lima ama ye adœke anga gbolo tshelœ ye œ te gbozu manda ye. ");
INSERT INTO kxf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi wu lima sœ œrœ á yindœ kœwuta bala tœnœ, yé tshe gbara lima o'o kœshe nœ Masiya. Tœnœ dá tshe pa lima adœke: “Tshe sœsœpe lima lœ ogo nœ akuzu nene, yé tshe fufu lima nene.” ");
INSERT INTO kxf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Adja Ndjaba she Yisu lœ akuzu. A'a para kɔkɔ kœdœ atimu nœ o'onœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ndjaba za she ɓa tœ kuni ye, œ to Ɔtshɔ Ɨ'ɨrɨ á tshe pa lima tœ ye fœ she á tshe kurutshelœ nœ tœ 'a ɓata á 'e sœ kœwu tœnœ á sœ kœdji tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davidi ɔɔ ga lafo nene gbaa, kashe tshe pa adœke: “Gbozu Ndjaba pa fœ Gbozu nœ mœ: sœ ga atɨ ga tœ kuni mœ, ");
INSERT INTO kxf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","œrrr ga tœ lɔkɔ á mœ fa azu á endje yiangba zœ, ga tshada zœ ɓata mbata.” ");
INSERT INTO kxf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Azu Israyele, 'e wusœ nœ dœ ɔtshɔnœ adœke: Yisu á 'e kuru she lima ga pa kurushi asœmœ, Ndjaba mbœrœ adœke tshe fa Gbozu, yé œ fa Kristu.» ");
INSERT INTO kxf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lɔkɔ á azu dji o'onœ asœmœ ataa, lɔsu endje ka endje, yé endje yu Petro œdœ pe anga udu aayi avwa adœke: «Aaya, 'a mbœrœ gaɗe?» ");
INSERT INTO kxf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petro gi fœ endje adœke: «'E fatshalɔsu 'e: uzu dœ uzu gbɔ batisimu dœ ɨ'ɨrɨ Yisu Kristu yeka á Ndjaba kœdjerœndœ ekperœ nœ 'e. Yé Ndjaba œ to Ɔtshɔ Ɨshirɨ fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gbambanœ nene, o'o nœ Ɔtshɔ Ɨshirɨ á Ndjaba pa lima tœnœ, œ sœ mbœrœ e'e dœ agbolo nœ 'e, œdœ ndje pe azu á endje sœ lœ ɨngɨrɨnœ, endjeneke á Gbozu Ndjaba nœ azœ œ 'e bala endje.» ");
INSERT INTO kxf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro kpa pa o'o ndjoro fœ endje. Tshe pa ala o'o kɔ adœke endje yindœ œneke á œne pa, yé œ gbota gbetshelœ nœ endje dœ kœpa adœke: « 'E yindœ soro á Ndjaba za fœ 'e mbœrœ á kœgitœ 'e ugurutœ azu osho asœ á ɔtshɔ endje gaga nene!» ");
INSERT INTO kxf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Endje neke á endje yi lima ndœ o'o nœ ye, endje gbɔ batisimu. Yé dœ ɔlɔnœ asœmœ, azu ga pa œrœ nœ́ kutu votɔ te lima ga ndœ ukpulu ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Endje zatœ endje djigi ga tœ kœyisœrœ nœ aayi avwa yé œ sœ kœngbɔɓatœ endje lœ yazu, œ sœ kœkurutshelœ mapa tœ endje dœ pe kœkɨ fœ Ndjaba kpœtœ œsœnœ awa bale. ");
INSERT INTO kxf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Awa li lima tœ endje kpa kpa kpa ye: Aayi avwa mbœrœ ogboro œrœ yé œ má ndje ambáránœ. ");
INSERT INTO kxf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ayindœ Yisu para kɔkɔ sœ lima kpœtœ œsœnœ bale yé œ ngboɓa œrœ nœ endje kɔ ga tœ nœ bale. ");
INSERT INTO kxf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Endje ka lima kɨndɨ nœ endje ndje dœ œrœ nœ endje á kurutshelœ ngendjanœ dœ mara adœke uzu dœ uzu gbɔ liaka ogo nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Endje sœ lima kœngbɔɓatœ endje ɔlɔ dœ ɔlɔ ɓa lœ Tepelo, yé œ sœ lima kœzɨ œrœ kpœtœ œsœnœ bale ɓa lœ anda nœ endje. Endje sœ lima kœzɨ œrœ dœ yanga œdœ ɔtshɔ lɔsu. ");
INSERT INTO kxf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Endje sœ lima kœdonga Ndjaba, yé azu kɔ yi lima ndœ endje waa. Ɔlɔ dœ ɔlɔ, Gbozu sœ kœyi endjeneke á endje gbɔ kœshe ga ugurutœ azu Ikrizia. ");
INSERT INTO kxf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Anga kɨdala bale dœ ada ɔlɔ votɔ, Apetro dœ Yowane ro lima kœdonga Ndjaba ɓa lœ Tepelo. ");
INSERT INTO kxf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Anga yakoshe bale á ada ye tshu tshakudu ye pe lœ gbolo ye sœ lima kœsœ ndoo dœ manda gbagba Tepelo á endje e «Ɔtshɔ Manda». Endje sœ lima kœna dœ she ɔlɔ dœ ɔlɔ ga zœ mbœrœ á tshe kœyɔndœ œrœ tshakane azu á endje sœ kœli ga lœ Tepelonœ. ");
INSERT INTO kxf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lɔkɔ á tshe wu Petro œdœ Yowane kœli ga lœ Tepelonœ, tshe yɔndœ œrœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yé Apetro dœ Yowane tondœ ye, œ pa fœ she adœke: «Tondœ 'a.» ");
INSERT INTO kxf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uzunœ tondœ endje dœ gbetshelœ adœke endje to œrœ fœ œne zœ. ");
INSERT INTO kxf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Á Petro kœpa fœ she adœke: «Mœ gugu dœ ngendja bale nene, kashe œneke á mœ sœ dœ tœnœ, mœ to fœ ɓœ: dœ ɨ'ɨrɨ Yisu Kristu, uzu Nazarete, áalafo œ na ana!» ");
INSERT INTO kxf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petro za kuni ye, œ tɨ she ga lafo. Trale, ada ye dœ tshelœ porongato ada ye yɔrɔ tshelœ tœ endje; ");
INSERT INTO kxf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","yé gbɨkɨvwɨgbɨ, tshe áalafo œ tetœ ana. Tshe li awa bale dœ aayi avwa ga lœ Tepelonœ, œ ka, œ i kpitikpiti dœ pe kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Azu para kɔkɔ sœ lima kœwu she kœna ana œdœ pe kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Azu tra she tuu, œ pa adœke: «Œ dœ́dœ́ œshe dá sœ kœsœ lima ɓa pa ɔtshɔ manda Tepelo yekane á sœ kœyɔndœ œrœ nene a!» Uvuru endje kpa lima lœ nœ tœ kœwu œrœ á mbœrœtœ endje lima fœ uzunœ á ada ye tshu asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɓata á uzu sœmœ yiyi lima ndœ kœgitœ ye tœ Apetro dœ Yowane nene, azu para do ga lafo œ sœ kœkpa ga ndœ endje ngbɔlɔɔ tshakudu mbarasane á endje e ɨ'ɨrɨnœ adœke mbarasane nœ Salomo. ");
INSERT INTO kxf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petro kœwu endje á kœpa adœke: «Azu Israyele, mbœrœ gaɗe á uvuru 'e œ kpa lœ nœ tœ kœshenœ asœke a? Mbœrœ gaɗe dá 'e sœ kœtondœ 'a ɓata gbɔgbɔ nœ 'a dœ tœ 'a too manda Ndjaba á tshe sœ dœ 'a dá mbœrœ adœke á uzunœ asœke na ana a? ");
INSERT INTO kxf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","'E wusœ nœ adœke Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Yakobo, Ndjaba nœ aata azœ, œshe dá ma mokɔ nœ ayi akwa nœ ye dœ Yisu. E'e dá ka lima she adœke endje wo she; yé ɔlɔ á Pilato yi lima ndœ kœkatœ ye tɨ, 'e vwara lima tœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'E vwaratœ 'e tœ uzu á tshe sœ yerœ, á sœ ndjii, yeka á yu lima Pilato adœke tshe za anga ayi kœwo azu fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","'E wo lima Gbozu nœ soro, kashe Ndjaba she she ugurutœ akuzu yé 'a kœdœ atimunœ. ");
INSERT INTO kxf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ngɔngɔ asœ 'e wu yakoshe asœke. 'E wusœ ye dœ ɔtshɔnœ: ɨ'ɨrɨ Yisu dá she she mbœrœ 'a sœ dœ kœyindœrœ ga ndœ ye. Mbœrœ gbɔgbɔ nœ ɨ'ɨrɨ ye dá tshe wuta dœ ɔtshɔ ɔkɔ ɓata á 'e wu utshu 'e para kɔkɔ asœke. ");
INSERT INTO kxf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Kashe aaya, mœ wusœ nœ adœke e'e dœ agbozu nœ 'e, 'e mbœrœ lima atamœ mbœrœ á 'e wuwusœ adja o'o nene. ");
INSERT INTO kxf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kashe Ndjaba mbœrœ ndœma ye á tshe pa lima tœnœ lœ ama aayi kœgbara o'o. Tshe pa lima adœke Masiya á tshe na, tshe wu oyo waa. ");
INSERT INTO kxf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mbœrœ tœnœ atamœ, aaya, 'e fatshalɔsu 'e dœ́ œ kwa ga ndœ Ndjaba. Œdœ 'e kœmbœrœ ataa, tshe mbœrœ adœke ekperœ nœ 'e yiwa ye. ");
INSERT INTO kxf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Atamœ ndje, Gbozu Ndjaba œ mbœrœ adœke 'e gbɔ ɔtshɔ olo nœ kœyatœ 'e, yé tshe vwa Masiya á tshe ke lima she utshunœ katshatsha mbœrœ 'e asœmœ, fœ 'e. Œshe kœdœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kashe ngɔngɔ asœke, Yisu Kristu œ sœ ɓa lafo œrrr ga tœ lɔkɔ á œrœ kɔ œ gumatœ ye liaka œneke á Ndjaba pa lima ndœ nœ lœ ama ayerœ aayi kœgbara o'o nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyize pa lima adœke: “Gbozu Ndjaba œ vwa bala ayi kœgbara o'o bale ɓata mœ, tshe dœ anga aya 'e. 'E dji bala œneke kɔ á tshe pa fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Azu á endje tshapu kœdji she, endje sœ ugurutœ azu nœ Ndjaba nene yé endje tshu.” ");
INSERT INTO kxf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yé aayi kœgbara o'o kɔ, kœto kpœpa Samwele œrrr ga tœ azu á endje sœ angba ye, uzu dœ uzu gbara lima o'o tœ upu nœ lɔkɔnœ asœke. ");
INSERT INTO kxf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","E'e kœdœ agbolo nœ ayi kœgbara o'o, 'e kœdœ ndje agbolo ayo á Ndjaba guma lima dœ aata azœ lɔkɔ á tshe pa lima fœ Abrayamo adœke: “Lœ awa nœ aata zœ, mœ to kane mœ ga pa azu kɔ pa ɔshɔ.” ");
INSERT INTO kxf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mbœrœ 'e dá Ndjaba vwa ayi akwa nœ ye utshunœ. Tshe vwa she adœke tshe to kane ye ga pa 'e, yé uzu dœ uzu katœ kœmbœrœ ekperœ.» ");
INSERT INTO kxf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lɔkɔ á Apetro dœ Yowane sœpe kœpu o'o, agbozu tshapa anganga Ndjaba, gbozu tshapa aayi kœgbɔndœ Tepelo œdœ Asadukayi, yi lima kumu endje. ");
INSERT INTO kxf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Endje sœ lima dœ ókó tɔpanœ kpuru kœwu adœke aayi avwa sœmœ bisha sœ kœyisœ œrœ yé œ sœ kœpandœ nœ adœke ɓata á Yisu shé lœ kuzu, azu á endje tshu lima, endje she ndje lœ kuzu. ");
INSERT INTO kxf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Endje tepa endje, œ ko endje va ga lœ kánga œrrr ga tœ kœkɔrɔ osho mbœrœ ɔlɔ dɨ lima ye. ");
INSERT INTO kxf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lœ ugurutœ azu á endje dji lima Ɔtshɔ O'o, azu ndjoro sœ lima dœ kœyindœrœ ga ndœ Yisu, yé ayindœ Yisunœ wuta azu ga pa œrœ nœ́ kutu mindu (5.000) dœ ɔlɔnœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Osho kɔrɔ pa nœ yeka á agbozu tshapa Ayuda, agbozu Ikrizia, aayi kœyisœ awa akwanœ á endje sœ lœ Yerusaleme, ngbɔɓa lima tœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ana á tshe dœ́ egerœ nganga Ndjaba, dœ Kayifa, dœ Yowane, dœ Alekezandre œdœ pe azu kɔ lœ bɨngɨ nœ agboro anganga Ndjaba dá ngbɔɓa lima tœ endje ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Endje to Apetro dœ Yowane ro tœnœ ga utshu endje, yé endje yu endje adœke: «'E mbœrœ œrœnœ asœke dœ gbɔgbɔ ndje pe dœ ɨ'ɨrɨ ɗe e?» ");
INSERT INTO kxf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yé Petro á tshe sœ lima dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ kœpa fœ endje adœke: «Agbozu tshapa azu ogo œdœ agbozu, ");
INSERT INTO kxf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'a mbœrœ ɔtshɔrœ fœ uzu á ada ye tshu yekane á endje sœ kœyu 'a kpesheke adœke 'a pandœ mara œrœ á 'a mbœrœ á uzunœ asœ she. ");
INSERT INTO kxf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ataa œ li adœke e'e kɔkɔ œdœ azu Israyele, 'e wusœ nœ dœ ɔtshɔnœ adœke uzunœ á tshe ka utshu 'e asœke, tshe she mbœrœ ɨ'ɨrɨ Yisu Kristu, uzu Nazarete á 'e kuru lima she ga pa kurushi yeka á Ndjaba she she lœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Œshe kœdœ badja á e'e dœ aayi kœmɔ anda za lima vwi'i, tshe fa badja á anda œ shi mbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Azu œ gbɔ kœshe kolœ ɓa ndœ ye. Gbambanœ nene, pa ɔshɔnœ asœke, anga angbɨ ɨ'ɨrɨ á Ndjaba za adœke azu gbɔ kœshe lœ awanœ, gugu nene.» ");
INSERT INTO kxf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kœwu adœke Apetro dœ Yowane ka kolœ mbɨmbɨmbɨ ga pa o'o nœ endje, aayi kœwa ngbanga i lima gbandjuru mbœrœ endje kœdœ amba azu á endje wuwusœ œrœ nene. Kashe endje wu ndje lima sœ nœ adœke endje kœdœ azu á endje sœ lima awa bale dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kashe ɓata á endje sœ lima kœtondœ uzunœ á tshe she, á tshe ka lima utshu endje, awa kœgi o'o tœ endje gugu lima nene. ");
INSERT INTO kxf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Á endje kœza awa fœ Apetro dœ Yowane kœwuta damba ga shu yé endje kœtetœ kœyutœ endje ugurutœ endje: ");
INSERT INTO kxf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«A mbœrœ gaɗe tœ azunœ asœke a? Mbœrœ azu para kɔkɔ lœ Yerusaleme wusœ nœ ngbɨ adœke, endje dá mbœrœ afá asœ, yé a shara nene. ");
INSERT INTO kxf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kashe œ li adœke a mbœrœ kɔ adœke o'onœ tete lœ utu azu para kɔkɔ nene. A za uvuru endje adœke endje kpa papa o'o bale dœ ɨ'ɨrɨ uzu nœ endje asœmœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Manda nœ, endje 'e endje, œ pakata endje kœpa o'o œdœ pe kœyisœ œrœ dœ ɨ'ɨrɨ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kashe Apetro dœ Yowane gi fœ endje adœke: «Œrœ gaɗe dá sœ ndjii utshu Ndjaba a? 'A dji 'e too 'a dji Ndjaba? 'E wa ngbanganœ dœ tœ 'e kane. ");
INSERT INTO kxf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yé tœ a'a nœ 'a, 'a vu ama 'a tœ œrœ á 'a wu dœ ala 'a yé á dji dœ utu 'a nene.» ");
INSERT INTO kxf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kœdji o'onœ ataa, aayi kœwa ngbanganœ gbagbara endje œrrr œ katœ endje tɨ. Endje gbɔgbɔ lima awa ndœ kœwa ngbanga ga tœ ɔkɔ endje nene gbambanœ nene, azu para kɔkɔ sœ lima kœdonga Ndjaba mbœrœ œrœnœ á wuta. ");
INSERT INTO kxf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yakoshenœ á endje she she lœ awa nœ afá asœmœ, sœ lima dœ ungu kœropa zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Apetro dœ Yowane gu ga ndœ anga endje lɔkɔ á aayi kœwa ngbanganœ mɨ lima kane endje tœ endje, œ pandœ neke kɔ á agboro anganga Ndjaba dœ agbɔ Ayuda pa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Manda kœdji o'onœ, aka endje para kɔkɔ awa bale, endje za avwala fœ Ndjaba dœ o'onœ atake: «Gbozu Ndjaba, œɓœ dá mbœrœ tshalafo, dœ ɔshɔ, dœ ungu œdœ pe œneke kɔ á sœ lœnœ, ");
INSERT INTO kxf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","œɓœ dá za o'onœ asœke lœ awa nœ Ɔtshɔ Ɨshirɨ ga lœ ama ata 'a dœ Davidi á tshe kœdœ ayi akwa nœ zœ: “Mbœrœ gaɗe á ogo kɔ sœ kœturu tœnœ, yé mbœrœ gaɗe á azu sœ kœvwarandœ kœmbœrœ œrœ kashe œ gugu dœ ádá nene? ");
INSERT INTO kxf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Agbozu tshapa ɔshɔ gumatœ endje, yé agbozu kuma akwa ngbɔtœ endje mbœrœ kœnga koshe ga tœ Gbozu Ndjaba œdœ pe ga tœ Masiya nœ ye.” ");
INSERT INTO kxf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gbamba nœ nene, œtœnœ kœdœ adjapu adœke Aerode dœ Pose Pilato ngbɔɓatœ endje dœ angbɨ azu œdœ pe azu ogo Israyele ɓa lœ ongbonœ asœke mbœrœ kœnga koshe ga tœ Yisu, œyerœ ayi akwa nœ zœ á tshe dœ Masiya nœ zœ. ");
INSERT INTO kxf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dœ tœnœ ataa, endje mbœrœ liaka gbetshelœ nœ zœ kɔ á ɓœ za lima dœ gbɔgbɔ œdœ œneke kɔ á ɓœ yi lima ndje ndœ nœ dœ tœ zœ. ");
INSERT INTO kxf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yé ngɔngɔ asœke Gbozu, tondœ mara á endje ndanga 'a asœke yé œ to uvuru fœ aayi akwa nœ zœ dœ́ endje mɨndœ o'o ama zœ dœ gbɔgbɔ kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","To kane zœ ga pa kumu azu kɔ mbœrœ adœke kœshe azu, ambárá œrœ dœ pe afá, mbœrœtœ endje dœ ɨ'ɨrɨ Yisu á tshe dœ œyerœ ayi akwa nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Manda kœza avwala nœ endje, osho á endje sœ lima tœnœ turu yé endje para kɔkɔ, endje gbɔ Ɔtshɔ Ɨshirɨ œ tetœ kœpandœ Ɔtshɔ O'o dœ gbɔgbɔ. ");
INSERT INTO kxf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ukpulu azu á endje fa lima ayindœ Yisu, sœ lima dœ lɔsu œdœ pe dœ gbetshelœ bale. Anga uzu bale pa pa lima adœke œrœ nœ œne sœ pa undu œne dœ tœ œne nene, kashe endje sœ kœngbɔɓa lima kɔ ga tœ œsœnœ bale. ");
INSERT INTO kxf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aayi avwa nœ Yisu sœ lima kœmɨndœ o'o kœshe nœ Gbozu Yisu ugurutœ akuzu dœ gbɔgbɔ, yé Ndjaba sœ lima kœza ɔtshɔ lɔsu ye ga pa endje kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Uzu bale dœ́dœ́ lima ayi oyo ugurutœ endje nene. Gbambanœ nene, endjeneke á endje sœ lima dœ kɨndɨ too dœ anda, endje ka lima œ na dœ ngendjanœ, ");
INSERT INTO kxf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yé œ ko fœ aayi avwa. Lœ kœkurutshelœ nœ, uzu dœ uzu sœ lima kœgbɔ lindœ œneke á li dœ she. ");
INSERT INTO kxf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Anga uzu bale lœ mara nœ Alevi sœ ndje lima ugurutœ endje. Ɨ'ɨrɨ ye kœdœ Yozefu á endje zu she lakpɨ Shipre. Aayi avwa e ndje lima she Barnabase, œ yindœ kœpa adœke «uzu kœto gbɔgbɔ». ");
INSERT INTO kxf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tshe sœ ndje lima dœ kɨndɨ nœ ye, yé œ ka, œ na dœ ngendjanœ yeka á ko fœ aayi avwa. ");
INSERT INTO kxf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anga uzu bale á ɨ'ɨrɨ ye kœdœ Anania, dji lima tœ ye dœ awonœ yé œ ka kɨndɨ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Manda nœ, endje sœ lima dœ egerœ lɔsu dœ awonœ, yé œ gumasœ tshakala ngendjanœ mbœrœ endje yeka á na dœ udunœ fœ aayi avwa. ");
INSERT INTO kxf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kashe Petro pa adœke: «Anania, mbœrœ gaɗe á Satana li ga lɔsu zœ ata a? Ɓœ fara Ɔtshɔ Ɨshirɨ, yé œ gbɔtœ tshakala ngendja kɨndɨ. ");
INSERT INTO kxf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ɓœ ka má tœ kœka kɨndɨnœ ye nene a? Too ɓœ kœka, mbœrœ gaɗe ɓœ mbœrœ má œrœ á ɓœ yindœ nœ dœ ngendjanœ nene a? Gbetshelœnœ asœmœ li ga lɔsu zœ koto o? Œ dœ́dœ́ azu dá ɓœ fara endje nene, kashe Ndjaba dá ɓœ fara she asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lɔkɔ á tshe dji o'onœ asœmœ ataa, tshe nɔ vwɨ œ te, œ tshu ye. Awa za azu á endje dji lima o'onœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Agbolo modo vwele lima she dœ lœba, yé œ na œ shi she ye. ");
INSERT INTO kxf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Manda ada ɔlɔ votɔ, awonœ wuwusœ œneke á mbœrœtœ endje nene, yé œ li tɔndu tɔndu ga sœnda ga zœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro kœyu she adœke: «Pandœ nœ fœ mœ kane, pa ngendja kɨndɨnœ á 'e ka dœ mœ a?» Tshe kœyindœ nœ adœke: «Adjapu, pa ngendjanœ dœ mœ!» ");
INSERT INTO kxf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yé Petro kpa yu she adœke: «Mbœrœ gaɗe á ɓœ djitœ zœ dœ akɔ zœ á fara Ɔtshɔ Ɨshirɨ nœ Gbozu Ndjaba a? Dji kane, azu á endje to tœ kœshi akɔ zœ, endje ka ɓa lœ manda ɓa zœ. Œɓœ ndje awa bale, endje shi ndje ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pe kpœlœ ma ye atake, tshe te ga tœ ada Petro œ tshu ye. Lɔkɔ á agbolo modo li lima, endje wu adœke tshe tshu ye, yé œ za lima she á na á shi ndje she ndoo dœ akɔnœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Egerœ awa li lima tœ azu Ikrizia œdœ pe azu á endje dji lima ndœ o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aayi avwa sœ lima kœmbœrœ afá ndjoro, yé œ sœ lima kœma ambáránœ ɓa ugurutœ azu. Ayindœ Yisu sœ lima kœngbɔtœ endje kɔ ɓa tshakudu mbarasane nœ Salomo dœ gbetshelœ bale. ");
INSERT INTO kxf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Uzu á tshe gugu dœ kœyindœrœ nene œ li kœli ga ndœ endje nene, andaa azu sœ lima kœpandœ ɔtshɔrœ nœ ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ayakoshe dœ pe ayashe ndjoro sœ lima kœfatshalɔsu endje ga ndœ Gbozu, yé œ sœ lima ga ugurutœ ayindœ Yisu asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Endje sœ lima kœwuta dœ aayi koɓa ga tœ ala awa, yé œ sœ lima kœko endje ga pa kelekpa œdœ ga pa kondja mbœrœ adœke Petro kœsœ kœro tœnœ, á ɨshirɨ ye kœna ga pa anga endje ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anga ukpulu azu ogo á sœ mashenga dœ Yerusaleme na ndje lima dœ aayi koɓa œdœ pe azu á ekpe ɨshirɨ sœ pa endje, yé endje she lima para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dœ lɔkɔnœ asœmœ, egerœ nganga Ndjaba œdœ endjeneke kɔ á endje sœ ɨndɨrɨ ye, œ yindœ kœpa adœke azu tshelœ ngbɔtœ nœ Asadukayi, endje sœ lima dœ ókó. ");
INSERT INTO kxf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Endje ko aayi avwa, yé œ vwi endje ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kashe dœ butshɔ, andjelu nœ Gbozu kɔrɔ manda kánga yé œ ko endje ga shu, á pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«'E na œ sœ ɓa lœ Tepelo. Yé ɓa zœ, 'e pandœ o'o upu nœ tafo soro fœ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Manda kœdji o'onœ, endje ro pe dœ amazɨ tuu ga lœ Tepelo, yé œ tetœ kœyisœ œrœ ɓa zœ. Egerœ nganga Ndjaba yikumu ye, œshe œdœ azu á endje sœ ɨndɨrɨ ye. Endje e lima osho ndœ angbɔtœ nœ endje dœ agboro azu kœwa ngbanga, yé œ vwa azu adœke endje e aayi avwa á endje sœ ɓa lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kashe lɔkɔ á aayi akwa wuta lima ɓa lœ kánga ɓa zœ, endje gbɔgbɔ lima endje nene. Endje gu yé œ pa adœke: ");
INSERT INTO kxf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«'A wu manda kánganœ, endje tshu dœ ɔtshɔnœ yé aayi kœgbɔndœ manda nœ ka ga pa nœ. Kashe lɔkɔ á 'a kɔrɔ atake, a wuwu uzu bale ɓa lœ nœ ɓa zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kœdji o'onœ ataa, gbozu nœ aayi kœgbɔndœ Tepelo œdœ pe agboro anganga Ndjaba i gbɔndjuru tœ upunœ, yé œ tetœ kœyutœ endje tœ neke á mbœrœtœ endje asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kashe anga uzu na lima œ pandœ nœ fœ endje adœke: «'E wu, azu á 'e ko lima endje ga lœ kánga asœmœ, endje ka ɓa lœ Tepelo yé œ sœ kœyisœ œrœ fœ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yé gbozu tshapa aayi kœgbɔndœ Tepelo na dœ aturugu nœ ye, œ to aayi avwa lœ zɨtɨnœ kparawa adœke azu kœveve œne dœ badja nene. ");
INSERT INTO kxf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Endje na dœ endje ga lœ osho kœwa ngbanga, yé egerœ nganga Ndjaba te lima tœ kœwa ngbanga ga pa endje. ");
INSERT INTO kxf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tshe pa fœ endje adœke: «'A kɔ 'e lima dœ ɔgbɔ tœ kœyisœ œrœ dœ ɨ'ɨrɨ uzu asœmœ ye. 'E wu, 'e mbœrœ œrrr kœyisœrœ nœ 'e za tshelœ ongbo Yerusaleme djigi. Atamœ, 'e yindœ kœmɨndœ nœ adœke a'a dá wo yakoshenœ asœke a?» ");
INSERT INTO kxf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kashe Apetro dœ anga udu aayi avwa gi adœke: «Œ li adœke a mbœrœtœ azœ lindœ o'o ama Ndjaba, kashe œ dœ́dœ́ lindœ œnœ azu nene. ");
INSERT INTO kxf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ndjaba nœ aata azœ she Yisu á e'e, 'e wo lima she á za she ga pa kurushi ugurutœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tshe za she ga pa kuni ye, œ fa she tœ Gbozu œdœ ayi kœshe azu mbœrœ adœke azu Israyele fatshalɔsu endje yekane á Ndjaba kœdjerœndœ ekperœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yé tshe vwa 'a ndœ kœmɨndœ o'onœ asœke, a'a œdœ Ɔtshɔ Ɨshirɨ á Ndjaba za fœ azu neke á endje sœ kœmbœrœtœ endje liaka o'o ama ye.» ");
INSERT INTO kxf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kœdji o'onœ ataa, aayi kœwa ngbanga sœ dœ ókó tɔ pa nœ kpuru, yé œ yindœ kœwo aayi avwa. ");
INSERT INTO kxf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kashe anga Farisayi bale á ɨ'ɨrɨ ye kœdœ Gamaliyele, œshe kœdœ egerœ ayi kœyisœ awa akwa á azu kɔ yindœ ye, sœ lima kpœtœmœ zœ. Tshe áalafo ɓa ugurutœ aayi kœwa ngbanga asœmœ, yé á pa adœke endje ko damba aayi avwa ga shu kane. ");
INSERT INTO kxf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Manda nœ, tshe pa ngbɨ adœke: «Azu tshelœ Israyele, 'e gbetshelœ 'e tœ œneke á 'e yindœ kœmbœrœ fœ azu asœke kane. ");
INSERT INTO kxf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Œndœnœ dɨdɨ damba nene, Teyudase má kpœke tœ ye ɓata uzu á œsœ ye lɨ, yé azu ga pa œrœ nœ́ kama vana te mangba ye. Endje wo she yé endjeneke kɔ á endje te lima mangba ye, endje kurutshelœtœ endje dœ ɔrɔ yé anga œrœ bale kpa gugu manda endje nene. ");
INSERT INTO kxf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«Manda ye, dœ lɔkɔ kœdɨ azu, Yudasi uzu tshelœ Galilayi kpa wuta, yé azu ndjoro te mangba ye. Kashe œshe ndje tshe tshu lima, yé endjeneke kɔ á endje te lima mangba ye kpa kuru ndje tshelœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ngɔngɔ asœke, mœ pa fœ 'e adœke 'e kpa gbegbe dœ azunœ asœke nene; 'e katœ endje dœ́ endje ro. Mbœrœ œdœ gbetshelœ too akwa nœ endje kœto ɓa ndœ azu, œ yiwa dœ tœ endje zœ. ");
INSERT INTO kxf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Œdœ œ kœto ɓa ndœ Ndjaba, 'e li kœwo tœnœ nene. 'E mbœmbœrœ adœke 'e gbɔ o'o dœ Ndjaba nene!» Aayi kœwa ngbanga para kɔkɔ yindœ o'o Gamaliyele ngbɨɨ. ");
INSERT INTO kxf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yé œ kpa e aayi avwa, œ sɔ endje dœ ndjapa. Manda kœmɨ upu fœ endje adœke endje kpa tata ɨ'ɨrɨ Yisu nene, endje katœ endje tɨ. ");
INSERT INTO kxf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aayi avwa gitœ endje utshu aayi kœwa ngbanga yé lɔsu endje sú dœ yanga, mbœrœ á endje wu oyo mangba ɨ'ɨrɨ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɔlɔ dœ ɔlɔ, œdœ ɓa lœ Tepelo too ɓa sœnda, endje sœ kolœ kœyisœ œrœ nœ endje dœ pe kœpandœ Ɔtshɔ O'onœ adœke Yisu kœdœ Masiya. ");
INSERT INTO kxf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dœ lɔkɔnœ asœmœ, ayindœ Yisu wuta lima ndjoro. Ayudanœ á endje zu endje lima lœ angbɨ ogo, á endje sœ kœpa o'o ama Greke tetœ kœpulœma endje tœ upu nœ anga endje á endje zu endje ɓa lœ ogo Israyele. Gbambanœ nene, endje pa lima adœke ɔlɔ dœ ɔlɔ á endje sœ kœkurutshelœ œrœ, endje sœsœ kœgbe dœ ayashe koya á endje to lœ angbɨ ogo dœ ɔtshɔnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aayi avwa ndjokpa dœ bisha ngbɔɓa ayindœ Yisu kɔ ga tœ œsœnœ, yé œ pa adœke: «Œ lili adœke 'a katœ kœyisœ o'o ama Ndjaba tɨ yé œ gbe kolœ dœ akwa nœ kœzɨrœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mbœrœ tœnœ ataa, aaya, 'e ke azu mindu dœ bisha (7) ugurutœ 'e á ɔtshɔ endje ga, endjeneke á endje sú dœ Ɔtshɔ Ɨshirɨ œdœ pe kœwusœtœ yeka á a kœza akwanœ asœmœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tœ a'a nœ 'a, 'a sœpe kœza avwala œdœ kœyisœ Ɔtshɔ O'o.» ");
INSERT INTO kxf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ayindœ Yisu para kɔkɔ yindœ o'onœ asœmœ ngbɨɨ fœ endje. Endje ke Etiene, uzu nœ kœyindœrœ œdœ Ɔtshɔ Ɨshirɨ, Filipo, Prokɔre, Nikanɔre, Timo, Paremenase œdœ pe Nikola á tshe kœdœ uzu á tshe yindœ Ndjaba nœ Ayuda ɓa lœ ongbo Atiɔshe. ");
INSERT INTO kxf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Endje ma endje fœ aayi avwa yeka á endje za avwala, yé á to kane endje ga pa endje. ");
INSERT INTO kxf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","O'o ama Ndjaba sœ lima kœza osho kɔ, yé ayindœ Yisu kpa ngba tɔpanœ kpuru lœ Yerusaleme. Anganga Ndjaba ndjoro fa lima lɔsu endje, œ yindœ o'o nœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ɔtshɔ lɔsu œdœ pe gbɔgbɔ nœ Ndjaba su lima Etiene kperœ, tshe fa lima œrœ yé œ má ambáránœ lœ ugurutœ azu. ");
INSERT INTO kxf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kashe dœ lɔkɔ asœmœ, azu tshelœ Sinagoga á endje e endje «akanga á endje za awa fœ endje», endje kœdœ anga azu ogo Sirene, dœ anga azu ogo Alekezandri, dœ anga azu tshelœ Silisi œdœ pe endje nœ Azi tetœ kœgbugburu tshelœ o'o dœ Etiene. ");
INSERT INTO kxf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kashe ɓata á tshe sœ lima kœpa o'o lœ kœwusœtœ á Ɔtshɔ Ɨshirɨ to fœ she, awa adœke endje shara she gugu lima nene. ");
INSERT INTO kxf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Endje fara lima azu dœ kowo mbœrœ á endje kœpa adœke: «'A dji she kœpa ekpe o'o ga tœ Moyize œdœ pe ga tœ Ndjaba!» ");
INSERT INTO kxf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Endje bɨlɨ azu, agbɔ Ayuda œdœ aayi kœyisœ awa akwa. Yé endje na ndoo dœ Etiene œ bopa ye, á to she rotœnœ ga lœ angbɔtœ kœwa ngbanga. ");
INSERT INTO kxf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Endje na dœ ekpe atimu ɓa zœ, yé á endje pa adœke: «Uzunœ á tshe sœ asœke kakatœ kœpa o'o tœ œyerœ Tepelo nœ zœ œdœ pe tœ awa akwa nœ Moyize nene. ");
INSERT INTO kxf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","'A dji she kœpa adœke, Yisu, uzu tshelœ Nazaretenœ asœmœ œ ndɨ tshelœ Tepelo asœke, yé œ yapa ndje mara kœsœ nœ aata azœ á Moyize ka lima tœ nœ fœ azœ.» ");
INSERT INTO kxf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Endjeneke kɔ á endje sœ lima tœ œsœ angbɔtœ kœwa ngbanganœ, endje to lima ndœ Etiene, yé œ wu tshatshu ye ɓata œnœ andjelu. ");
INSERT INTO kxf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Egerœ nganga Ndjaba yu Etiene adœke: «Œneke á endje pa dœ ɨ'ɨrɨ zœ kœdœ adja o'o a?» ");
INSERT INTO kxf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiene gi adœke: «Alaya mœ œdœ pe alaba mœ, 'e dji mœ kane. Ndjaba nœ mokɔ wuta lima ga tœ ata azœ dœ Abrayamo lɔkɔ á tshe sœ lima ɓa lakpɨ Mezopotami, utshunœ adœke tshe gu kœmbœrœ ogo Harane. ");
INSERT INTO kxf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tshe pa lima fœ she adœke: “Katœ ogo zœ œdœ pe bɨngɨ nœ zœ tɨ, yé œ gu ndœ ogo á mœ yisœ nœ fœ ɓœ.” ");
INSERT INTO kxf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yé Abrayamo katœ ogo nœ ye ɓa lakpɨ Kalade tɨ, œ ro kœmbœrœ ogo ɓa lakpɨ Harane. Aba Abrayamo tshu ɓa zœ yé manda kuzu ye, Ndjaba gi lima Abrayamo ga lœ ogo á 'e sœ lœ nœ ngɔngɔ asœke. ");
INSERT INTO kxf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kashe Ndjaba fafa lima Abrayamo tœ ayengɔ ɔshɔnœ bale nene, á œdœ ndje osho nœ kœto ada ye ga tœnœ nene. Kashe tshe pa lima ndœ nœ fœ she adœke œne za bala ogonœ asœke fœ she dœ aatanœ, andaa œshe dœ́ Abrayamo gugu lima damba dœ gbolo nene. ");
INSERT INTO kxf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yé Ndjaba kpa pa lima fœ she atake: “Aata zœ œ mbœrœ bala angbɨ ogo. Endje te bala akanga ɓa zœ, yé œ wu oyo manda ungu kama vana. ");
INSERT INTO kxf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kashe œmœ Ndjaba, mœ pa adœke mœ wa bala ngbanga ga tœ ogo á endje te akanga lœ nœ. Manda nœ, endje wuta ɓa zœ yé œ gu ndœ kœza avwala fœ mœ kpœtœ oshonœ asœke.” ");
INSERT INTO kxf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","«Ndjaba lu madu dœ Abrayamo yé ambáránœ kœdœ kœwa gaza ayakoshe. Mbœrœ tœnœ dá Abrayamo wa gbolo nœ ye dœ Izaka tœ gaza ɔlɔ á tshe mbœrœ olo mindu dœ votɔ manda kœzu she. Awa bale Izaka wa lima gbolo nœ ye dœ Yakobo yé Yakobo wa ndje agbolo yakoshe nœ ye ndjokpa dœ bisha, á endje dœ́ aata azœ tœ gaza.» ");
INSERT INTO kxf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Aata azœ mbœrœ lima uku ga tœ Yozefu yé œ ka lima she mbœrœ kœte kanga ɓa lœ Ezipito, kashe Ndjaba sœ lima dœ she awa bale. ");
INSERT INTO kxf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tshe gi she lœ oyo nœ ye kɔ, œ to kœwusœtœ fœ she yé á mbœrœ adœke tshe wuta ɔtshɔ uzu utshu Farawo, gbozugo Ezipito. Farawo za she tœ ayi kœtondœ ogo Ezipito œdœ pe œrœ tshasœnda nœ ye kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","A sœ atake, egerœ ogo za Ezipito œdœ pe ogo Kanana djigi. Oyo ro lima sœ nœ yé awa kœgbɔ kœzɨrœ gugu lima tœ aata azœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lɔkɔ á Yakobo dji lima adœke kœzɨrœ sœ ɓa lœ Ezipito, tshe vwa aata azœ utshunœ. ");
INSERT INTO kxf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tœ bisha kœro endje ga zœ, Yozefu pandœtœ ye fœ aayanœ, yé œ pandœ mara nœ ye fœ Farawo. ");
INSERT INTO kxf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Manda nœ, Yozefu vwa osho adœke endje para abanœ dœ Yakobo œdœ pe ayonœ kɔ na tœnœ. Endje sœ lima kɔ azu zazu votɔ dœ ndjokpa dœ mindu. ");
INSERT INTO kxf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo na ga lœ Ezipito, yé œ tshu ɓa zœ œdœ ndje pe aata azœ. ");
INSERT INTO kxf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Endje ko lima oko endje ro tœnœ ɓa lœ Sikeme yeka á shi endje ɓa lœ udu á Abrayamo yɔ lima tshakane agbolo nœ Amore. ");
INSERT INTO kxf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ɓata á olo kœmbœrœ œrœ má Ndjaba pa lima tœnœ fœ Abrayamo ndo ye, aata azœ zu lima azu yé œ kpa wuta ndjoro lœ ogo Ezipito, ");
INSERT INTO kxf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","yekane á anga tafo gbozugo á tshe wuwu lima sœ o'o tœ upu nœ Yozefu nene, za akwa kœgbɔndœ ogo Ezipito. ");
INSERT INTO kxf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gbozugonœ sœ lima kœfara azu nœ azœ, tshe ma lima ekpe ɔtshɔ ye fœ aata azœ œrrr ga tœ kœpa fœ endje adœke endje ko aaya agbolo nœ endje á endje sœpe kœɔ ɔngɔ va e mbœrœ adœke endje tshu ye.» ");
INSERT INTO kxf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dœ lɔkɔnœ asœmœ dá endje zu lima Moyize. Tshe kœdœ lima ɔtshɔ gbolo tœ ala Ndjaba. Tshe mbœrœ lima yapu votɔ ɓa lœ anda nœ abanœ. ");
INSERT INTO kxf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yé manda nœ, endje katœ ye tɨ, yawuru nœ Farawo za she œ gbɔndœ ye lima ɓata adja gbolo nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Endje yi lima sœ œrœ tshelœ Ezipito kɔ fœ she, yé tshe sœ lima dœ gbɔgbɔ lœ o'o œdœ pe lœ akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Lɔkɔ á tshe wuta lima ga tœ ungu zazu bisha, tshe gbɔ gbetshelœ kœro ɓa ugurutœ aayanœ, azu tshelœ Israyele. ");
INSERT INTO kxf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tshe wu lima uzu Ezipito kœɓi anga uzu Israyele bale. Mbœrœ kœnga pa ayanœ asœmœ œdœ pe kœtɔ geda tshangba ye, tshe ɓi uzu Ezipitonœ yerœwa fœ kuzu. ");
INSERT INTO kxf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tshe gbe lima adœke aaya œne wusœ nœ adœke Ndjaba œ she endje lœ awa nœ œne. Andaa endje wuwu lima sœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Olo bale manda nœ, Moyize kɔ tshelœ azu Israyele bisha á endje sœ tœ koshe, yé œ ngbɔɓa endje ga tœnœ dœ o'o atake: “Anga mœ, e'e kœdœ aayazu! Mbœrœ gaɗe á 'e ɓitœ 'e a?” ");
INSERT INTO kxf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kashe tsheneke á tshe sœ kœɓi yanganœ gɔrɔ Moyize dœ o'o take: “Uzu ɗe dá za ɓœ tœ gbozu œdœ ayi kœwa ngbanga pa 'a? ");
INSERT INTO kxf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɓœ yindœ kœwo mœ ɓata á ɓœ wo libi uzu Ezipito a?” ");
INSERT INTO kxf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kœdji o'onœ asœmœ ata, Moyize kpa œ zatœ ye yiwa tœnœ ɓa lœ ogo nœ Amadiane. Tshe zu lima agbolo bisha ɓa zœ.» ");
INSERT INTO kxf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Manda ungu zazu bisha, andjelu wuta ga tœ ye ɓala laɓa owo, ɓa lœ a'eara ɔyɔ á sœ ɓa lœ kpagagasho kaga Sinayi. ");
INSERT INTO kxf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyize i gbɔndjuru lɔkɔ á tshe wu œrœnœ asœmœ. Œne gitœ œne ndoo á kœtondœ nœ kane, tshe dji tshama Gbozu Ndjaba kœpa adœke: ");
INSERT INTO kxf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Œmœ kœdœ Ndjaba nœ aaba zœ, Ndjaba nœ Abrayamo, nœ Izaka dœ pe Yakobo.” Awa litœ Moyize kpa kpa kpa ye; awa adœke tshe tondœ oshonœ gugu tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Á Gbozu Ndjaba kœpa fœ she adœke: “Gi ada zœ lœ œrada mbœrœ osho á ɓœ ka ga tœnœ kœdœ œyerœ osho. ");
INSERT INTO kxf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Adjapu, mœ wu oyo á azu nœ mœ sœ kœwu tœnœ ɓa lœ ogo Ezipito, œ dji ndœ ɨkɨ endje; mbœrœ tœnœ ataa dá mœ jerœ kœshe endje. Na zœ, mœ yindœ kœvwa ɓœ ngɔngɔ asœke ɓa lœ Ezipito.” ");
INSERT INTO kxf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Tshetœ Moyize á azu Israyele gɔrɔ lima she á pa fœ she adœke: “Œɗe dá za ɓœ tœ gbozu œdœ ayi kœwa ngbanga a?” Œshe dá Ndjaba vwa she ɓata gbozu, ɓata ayi kœshe azu lœ awa nœ andjelu á tshe wuta ga ndœ ye ɓa lœ a'eara ɔyɔ. ");
INSERT INTO kxf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Œshe dá ko endje wuta tœ nœ ga shu lœ ogo Ezipito. Tshe fa œrœ yé œ má ambáránœ lœ ogo Ezipito, ɓa tœ egerœ ungu Fala œdœ ɓa lœ kpagagasho manda ungu zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyize dá kpa pa fœ azu Israyele adœke: “Ndjaba œ to bala ayi kœgbara o'o bale ɓata mœ fœ 'e lœ ugurutœ aaya 'e.” ");
INSERT INTO kxf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Œshe dá ka lima lœ ugurutœ aata azœ dœ pe andjelu á tshe pa lima o'o fœ she ɓa pa kaga Sinayi. Moyize dá sœ lima kœgbɔ o'o nœ soro ɓa ndœ Ndjaba mbœrœ kœyisœ nœ fœ azœ. ");
INSERT INTO kxf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Kashe aata azœ yiyi lima ndœ kœdji she nene; endje vwaratœ endje tœ ye yé œ yi lima ndœ kœkwatœ endje ga lœ ogo Ezipito. ");
INSERT INTO kxf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Endje pa lima fœ Aro adœke: “Mbœrœ anga andjaba fœ 'a adœke endje gbɔndœ 'a, mbœrœ Moyize má á tshe ko azœ wuta tœnœ ga shu lœ ogo Ezipitonœ asœmœ, 'a wuwusœ œrœ á wuta ga tœ ye nene.” ");
INSERT INTO kxf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Endje mbœrœ lima ɨshirɨ aya ngombe dœ ɔlɔnœ asœmœ œ sœ kœto okoro ga tœnœ, yé œ mbœrœ angbo dœ yanga mbœrœ œneke á endje mbœrœ lima dœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tœ kœgi œrœ tshangbanœ fœ endje, Ndjaba dɔ tshapa ye gbɔ endje yé œ katœ endje adœke endje donga angerepe ɓa lafo, ɓata á endje sú ɓa la mbeti nœ ayi kœgbara o'o adœke: “Azu Israyele, œmœ dá 'e to lima agea œdœ pe tokóró fœ mœ manda ungu zazu bisha ɓa lœ kpagagasho a? ");
INSERT INTO kxf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Œ̃ œ̃ nene. 'E za gbanda tande nœ ndjaba Moloke, œdœ ɨshirɨ nœ ndjaba angerepe nœ e'e dœ Refane, ɨshirɨnœ á 'e mbœrœ dœ tœ 'e á sœ kœdonga tœnœ asœmœ. Mbœrœ tœnœ ataa, mœ gɔrɔ 'e lœ ogo nœ 'e dœ́ œ vwa 'e waa ɓa kele Babilone.” ");
INSERT INTO kxf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Aata azœ sœ lima dœ gbanda tande á sœ kœma adœke Ndjaba sœ dœ azœ awa bale ɓa lœ kpagagasho. Ndjaba pa lima fœ Moyize adœke tshe mɔ anda tandenœ ɓata œneke á tshe wu lima. ");
INSERT INTO kxf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aata azœ gbɔ gbanda tande ɓa ndœ aba endje, yé œ te œnœ endje. Lɔkɔ á Yosuwa sœ lima kœgbɔndœ endje, endje li dœ tœnœ djelœ ogo neke á endje gbɔtœnœ lœ koshe, ogo á Ndjaba gɔrɔ azu lœnœ utshu endje. Gbanda tandenœ sœ kpœtœmœ œrrr ga tœ lɔkɔ á Davidi wuta lima gbozugonœ. ");
INSERT INTO kxf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidi gbɔ ɔtshɔrœ ɓa ndœ Ndjaba, yé œ yu osho adœke œne mɔ anda fœ Ndjaba nœ Yakobo. ");
INSERT INTO kxf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kashe Salomo dá mɔ lima andanœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Andaa Ndjaba á tshe ropa œrœ kɔ sœsœ lœ anda á azu mbœrœ dœ kane endje nene. Ɓata á Ndjaba pa lœ awa nœ aayi kœgbara o'o adœke: ");
INSERT INTO kxf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Tshalafo kœdœ osho tshagbozu nœ mœ, yé ɔshɔ kœdœ osho kœto ada mœ ga tœnœ. Anda gaɗe dá 'e mɔ fœ mœ a? Yé osho gaɗe dá mœ kœyatœ mœ tœnœ a? ");
INSERT INTO kxf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Œ dœ́dœ́ kane mœ dá mbœrœ œrœnœ asœmœ kɔ nene a?” ");
INSERT INTO kxf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Etiene kpa pa fœ azu kœwa ngbanga adœke: “Azu gbɔkumu, lɔsu 'e œdœ utu 'e be pa 'e tœ upu nœ Ndjaba, 'e sœ kœvwaratœ 'e ɔlɔ dœ ɔlɔ tœ Ɔtshɔ ɨshirɨ. 'E sœ adja awa bale ɓata aata 'e. ");
INSERT INTO kxf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aayi kœgbara o'o neketa dá aata 'e ndandanga she nene a? Endje wo lima endjeneke á endje sœ kœpandœ kœna uzu á tshe sœ ndjii. Yé ngɔngɔ nœ asœke, tshetœ ye dá 'e va ɔtɔ ye yé á wo she. ");
INSERT INTO kxf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'E dji awa akwa nœ Ndjaba á aandjelu pandœ nœ fœ 'e, yé œ tshapu kœza ga tœ akwa ye.”» ");
INSERT INTO kxf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lɔkɔ á aayi kœwangbanga dji o'onœ asœmœ ataa, tshatshu endje fa agba ɔkɔ, yé endje zɨ tshelœ daji endje gbagbara gbagbara dœ ókó ga tœ Etiene. ");
INSERT INTO kxf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kashe ɓata á Etiene su lima dœ Ɔtshɔ Ɨshirɨ, tshe tondœ tshalafo, œ wu mokɔ nœ Ndjaba œdœ Yisu á tshe ka ga tœ kuni ye. ");
INSERT INTO kxf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tshe pa adœke: «'E wu, mœ tondœ tshalafo ngbɨ yé Gbolo nœ uzu ka ga tœ kuni Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kœdji o'onœ ata, endje ve ɔgbɔ rawa yé œ be utu endje ga tœnœ. Manda nœ, endje tshu kɔ ga pa ye. ");
INSERT INTO kxf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Endje gbota she lœ ongbo ga shu yeka á tetœ kœve lima she dœ badja. Atimunœ ka lima tœ lœba nœ endje ga tœ ada anga gbolo yakoshe bale á ɨ'ɨrɨ ye kœdœ Sawulo. ");
INSERT INTO kxf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lɔkɔ á endje sœ lima kœve Etiene dœ badja, tshe sœ lima kœza avwala adœke: «Gbozu Yisu, za ɨshirɨ mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Manda nœ, tshe te dœ matshukuda ye, yé œ ve ɔgbɔ rawa adœke: «Gbozu, gbegbe dœ ekperœ nœ endje nene.» Manda kœpu o'o asœmœ, tshe tshu ye. ");
INSERT INTO kxf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawulo sœ lima ugurutœ azu á endje yindœ nœ adœke endje wo Etiene ye. Dœ ɔlɔnœ asœmœ, Ikrizia tshelœ Yerusaleme te lima tœ kœwu ɔgbɔ œrœ kanga. Kolœ aayi avwa dá lœpe lima lœ Yerusaleme kashe ayindœ Yisu para kɔkɔ kuru lima tshelœtœ endje lœ ogo Yuda œdœ pe lœ Samariya. ");
INSERT INTO kxf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Azu nœ ɔtshɔ lɔsu shi lima Etiene manda kœkɨ she dœ oyo kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Andaa Sawulo sœ lima kœpa avwara kœndɨ Ikrizia. Tshe sœ lima kœli anda bale dœ bale yekane á gbota ayindœ Yisu, ayakoshe, ayashe yé á gu kœko endje va ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Endjeneke á endje ndjɔ lima tshelœtœ endje, tetœ kœpandœ Ɔtshɔ O'o djelœ ogo djezœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo na œnœ ye ɓa lœ anga ongbo bale lœ Samariya, œ sœ kœyisœ œrœ dœ upu nœ Kristu ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ukpulu azu kɔ yindœ o'o ama Filipo mbœrœ á endje sœ lima kœdji she, á sœ ndje kœwu afá á tshe sœ lima kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ekpe ɨshirɨ ndjoro sœ lima kœwuta lœ aayi koɓa dœ kœve ɔgbɔ rawa. Azu ndjoro á ada endje tshu œdœ pe agbakɨndɨ she ndje lima ye. ");
INSERT INTO kxf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yé egerœ yanga sœ lima lœ ongbonœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Anga uzu má ɨ'ɨrɨ ye kœdœ Shimu, á tshe sœ ndje utshunœ lœ ongbo sœmœ, sœ lima kœfa œrœ tsharawo yé azu tshelœ Samariya kɨ lima tœ œsœnœ waa. Tshe zatœ ye lima ɓata egerœ uzu. ");
INSERT INTO kxf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Azu para kɔkɔ, kœto tœ aaya agbolo œrrr ga tœ agbozu, dji lima she tɔpanœ kpuru. Endje pa lima adœke: «Yakoshenœ asœke sœ dœ gbɔgbɔ nœ Ndjaba, á endje e tœnœ egerœ gbɔgbɔ.» ");
INSERT INTO kxf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Endje zatœ endje lima ga tœ ye mbœrœ kœfa œrœ tsharawo nœ ye á sœ kœza uvuru endje lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kashe lɔkɔ á endje dji lima Ɔtshɔ O'o á Filipo yisœ nœ tœ upu tshagbozu nœ Ndjaba œdœ pe ɨ'ɨrɨ Yisu Kristu, ayakoshe œdœ ayashe gbɔ lima batisimu. ");
INSERT INTO kxf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Shimu yindœ nœ dœ tœ ye, yé œ gbɔ batisimu. Manda nœ, tshe te mangba Filipo. Tshe sœ lima kœwu ogboro ambárá œdœ pe afá á Filipo sœ kœmbœrœ tœnœ, œ kɨ tœ œsœnœ dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aayi avwa á endje sœ lima ɓa lœ Yerusaleme dji adœke, azu tshelœ Samariya yindœ Ɔtshɔ O'o, yé œ vwa Apetro dœ Yowane fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lɔkɔ á endje wuta ɓa zœ, endje 'e tshalafo mbœrœ azu Samariya adœke endje gbɔ Ɔtshɔ Ɨshirɨ, ");
INSERT INTO kxf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","mbœrœ Ɨshirɨ jejerœ lima damba ga pa uzu bale ugurutœ endje nene; endje gbɔ lima kolœ batisimu dœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Apetro dœ Yowane to kane endje ga pa endje, yé azu Samariya gbɔ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kashe lɔkɔ á Shimu wu adœke aayi avwa to kane endje ga pa endje yeka á endje gbɔ Ɔtshɔ Ɨshirɨ, tshe yindœ kœto ngendja fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Œ pa fœ endje adœke: «'E to ndje gbɔgbɔnœ asœke fœ mœ, mbœrœ œdœ mœ kœto kane mœ ga pa anga azu, endje gbɔ ndje Ɔtshɔ Ɨshirɨ.» ");
INSERT INTO kxf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petro kœgi fœ she adœke: «Kaka Ndjaba mbœrœ adœke ɓœ yiwa awa bale dœ ngendja nœ zœ, mbœrœ á ɓœ gbe adœke endje yɔ œrœ á Ndjaba œ to fœ azu gbambanœ dœ ngendja. ");
INSERT INTO kxf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɓœ lili kœsœ dœ 'a awa bale lœ akwanœ asœke nene, ɓœ gbɔ ndje anga œrœ bale lœ nœ nene, mbœrœ á lɔsu zœ sœsœ ndjii ɓa utshu Ndjaba nene. ");
INSERT INTO kxf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fa tshalɔsu zœ yé œ donga Gbozu á œ kœli yekane á tshe djerœndœ ekpe gbetshelœ á li ga lɔsu zœ. ");
INSERT INTO kxf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mbœrœ tœnœ ataa, mœ wu adœke ɓœ sœ dœ egerœ lɔsu, yé ɓœ fa kanga nœ ngbɨndɨrœ.» ");
INSERT INTO kxf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Shimu gi adœke: «Adja e'e kœdonga Gbozu mbœrœ mœ, kparawa adœke œneke á 'e pa kœwuwuta ga tœ mœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Manda kœgbara o'o ndje dœ kœyisœ o'o ama Gbozu, Apetro dœ Yowane kwatœ endje lima ga lœ Yerusaleme. Kœgu endje tœ ala awa, endje yi lima sœ Ɔtshɔ O'o lakpɨ ndjoro lœ ogo Samariya. ");
INSERT INTO kxf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɔlɔ bale, andjelu nœ Gbozu pa fœ Filipo adœke: «Aafo œ na yorrr dœ awa á ro ga lœ Sudi, tœ awa á jerœ kœto lœ Yerusaleme kœna ga tœ Gaza. Tœnœ kœdœ awa á azu kpa sœsœ kœna tœnœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ngbewo, Filipo áalafo dœ kœro she. Kœna she yorrr tœ awanœ asœmœ, tshe wu anga uzu tshelœ ogo Etiopi bale, á tshe dœ́ egerœ ayi akwa nœ Kandase, gbozu yashe ogo Etiopi. Uzunœ asœmœ kœdœ ndje lima ayi kœgbɔndœ ngendja œdœ ukpulu œrœ nœ gbozu yashenœ yekane á ro lima ga lœ Yerusaleme mbœrœ kœdonga Ndjaba, ");
INSERT INTO kxf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yé á sœ kœgu tœnœ ga ndœ ye. Tshe sœ lima ga lœ share nœ ye œ sœ kœdɨ mbeti á ayi kœgbara o'o Isaya su. ");
INSERT INTO kxf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɔtshɔ Ɨshirɨ kœpa fœ Filipo adœke: «Gitœ zœ ga utshunœ œ togba dœ sharenœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo na dœ ɔrɔ, œ dji uzu ogo Etiopinœ á tshe sœ kœdɨ mbeti á ayi kœgbara o'o Isaya su dœ avwara ga lafo. Á tshe kœyu she adœke: «Adja ɓœ wusœ ádá œneke á ɓœ dɨ asœke ye a?» ");
INSERT INTO kxf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Uzunœ gi fœ she adœke: «Œdœ uzu kœyisœ ádánœ ngbɨ fœ mœ nene, mœ wu má sœ nœ koto o?» Yé tshe e Filipo adœke tshe ɔ œ sœ ga ɨndɨrɨ œne. ");
INSERT INTO kxf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Œneke á endje sú lima ɓa la mbetinœ á tshe sœ kœdɨ lima tœnœ dœke: «Tshe sœ ɓata pata á endje na dœ she ga tœ osho kœwo apata, tshe sœ ɓata aya pata á tshe kɨkɨ utshu ayi kœlɨ usu kote ye nene, tshe ɨɨ lima ama ye bale nene. ");
INSERT INTO kxf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Endje za tshula fœ she, yé œ wa ɔgbɔ ngbanga ga pa ye. Œɗe dá pa bala o'o mbœrœ agbolo tshangba ye a? Gbambanœ nene, endje wa tshelœ olo ye pa ɔshɔ.» ");
INSERT INTO kxf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uzu ogo Etiopi sœmœ yu Filipo adœke: «Wu oyo mœ kane, œɗe dá ayi kœgbara o'o patœ ye ataa? Tshe patœ ye dœ tœ ye too tshe patœ anga angbɨ uzu?» ");
INSERT INTO kxf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo kœto kpœpa œneke á endje sú ɓa la mbeti asœmœ yeka á yisœ Ɔtshɔ O'o nœ Yisu fœ she. ");
INSERT INTO kxf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Endje ngbɔtœ awa ana nœ endje œ na œrrr, œ wuta ga tœ anga ungu á sœ ɓa ɨndɨrɨ awa, yé uzu Etiopi kœyu adœke: «Wu ungu asœke, œrœ gaɗe dá pakata mœ ndœ kœgbɔ batisimu a?»  ");
INSERT INTO kxf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo kœpa fœ she adœke: «Œdœ ɓœ kœyindœ nœ dœ lɔsu zœ bale, mœ za batisimu fœ ɓœ ye.» Yé uzu sœmœ kœgi fœ she adœke: «Mœ yindœ nœ adœke Yisu Kristu kœdœ Gbolo nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tshe kœpa fœ ayi kœkpa dœ share adœke endje ka kpœke. Afilipo kœjerœ dœ she ga la ngu yé Filipo kœza lima batisimu fœ she. ");
INSERT INTO kxf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lɔkɔ á endje wuta langunœ, Ɨshirɨ nœ Gbozu za Filipo yé uzu Etiopi kpa wuwu she nene. Kashe tshe te lima tœ awa kœgu she dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo wuta ɓa lakpɨ Azote, yé tshe ro kœyisœ Ɔtshɔ O'o na tœnœ lœ ongbo bale dœ bale djezœ œrrr vesho ga lakpɨ Sezaré. ");
INSERT INTO kxf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dœ lɔkɔnœ asœmœ, Sawulo sœ kolœ dœ gbetshelœ nœ kœmbœrœ œrœ kanga fœ azu Ikrizia œdœ pe kœpara awa nœ kœyiangwa endje. Tshe na ga ndœ egerœ nganga Ndjabanœ, ");
INSERT INTO kxf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","œ yɔndœ mbeti á za awa fœ she kœli djelœ Sinagoga á sœ lakpɨ Damaseke. Œdœ tshe kœwuta ɓa zœ á gbɔ azu, ayakoshe too ayashe má endje sœ kœza awa Yisu, tshe i endje dœ djingiri yé œ gu dœ endje ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lɔkɔ á tshe te lima tœ awa yé á wuta lima ndoo dœ Damaseke, ɨshirɨ owo to ngbai ɓa lafo œ jerœ ga pa ye zakpɨ. ");
INSERT INTO kxf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tshe te ga tœ ɔshɔ, œ dji tshama uzu kœpa adœke: «Sawulo, Sawulo, mbœrœ gaɗe á ɓœ mbœrœ œrœ kanga fœ mœ ataa?» ");
INSERT INTO kxf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tshe yu adœke: «Gbozu, œɓœ kœdœ ɗe?» Yé tshamanœ kœgi adœke: «Œmœ kœdœ Yisu, œmœ á ɓœ mbœrœ œrœ kanga fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kashe aalafo œ li ga lœ ongbo, yé ɓa zœ dá endje pandœ œneke á li adœke ɓœ mbœrœ, fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Azu á endje na tœ ala awa dœ Sawulo ka lima, œ sœ kokoko; endje dji lima tshama uzu kashe endje wuwu lima she nene. ");
INSERT INTO kxf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawulo áalafo lœ ɔshɔ, kashe ataa tshe kɔrɔ ala ye gbaa, tshe wuwu lima osho bale nene. Anganœ á tshe na lima tœ ala awanœ dœ endje dá za ama kane ye yeka á gbota she duru duru rotœnœ ga lakpɨ Damaseke. ");
INSERT INTO kxf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tshe mbœrœ lima olo votɔ lœ bula; tshe zɨzɨ lima œrœ yé œ ndjo ndje ungu nene. ");
INSERT INTO kxf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Anga yindœ Yisu bale á ɨ'ɨrɨ ye kœdœ Anania sœ lima ɓa lœ Damaseke. Gbozu e she lœ ulu adœke: «Anania!» Tshe gi fœ she adœke: «Mœ sœ kea, Gbozu!» ");
INSERT INTO kxf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gbozu kpa pa adœke: «Na dœ ala awa má endje e tœnœ awa Ndjii, œ yu osho ɓa lœ anda nœ Yudasi tœ anga yakoshe tshalakpɨ Tarse bale á ɨ'ɨrɨ wu Sawulo. Tshe sœ kœza avwala ɓa zœ, ");
INSERT INTO kxf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","yé lœ ulu, tshe wu anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Anania kœli yé á to kane ye ga pa ye adœke tshe kpa wu osho.» ");
INSERT INTO kxf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania gi adœke: «Gbozu, mœ dji azu ndjoro kœpa o'o tœ yakoshenœ asœke œdœ kœpandœ ngbɨndɨrœ kɔ á tshe mbœrœ fœ azu kœyindœ zœ ɓa lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yé ngɔngɔ asœ, tshe wuta ɓa ke dœ mbeti á tshe gbɔ ɓa ndœ agbozu tshapa anganga Ndjaba mbœrœ kœi endjeneke kɔ á endje e ɨ'ɨrɨ zœ lœ ama endje, dœ djingiri.» ");
INSERT INTO kxf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kashe Gbozu pa fœ she adœke: «Na zœ, gbambanœ nene, mœ ke yakoshenœ asœmœ tœ uzu akwa nœ mœ, yé kpœpa ye dá ɨ'ɨrɨ mœ œ to lœ ogo nœ angbɨ azu, ɓa utshu agbozugo œdœ pe ndje ɓa utshu azu Israyele. ");
INSERT INTO kxf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Œmœ dœ tœ mœ, mœ yisœ mara á li dœ she kœwu œrœ kanga mbœrœ ɨ'ɨrɨ mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania ro œ li ga lœ anda, œ to kane ye ga pa Sawulo yé œ pa adœke: «Aya mœ, Sawulo! Gbozu dá vwa mœ. Yisu á tshe wuta lima ga tœ zœ tœ ala awa á ɓœ na lima tœnœ, œshe dá vwa mœ adœke ɓœ kpa tondœ osho yé œ gbɔ Ɔtshɔ Ɨshirɨ.» ");
INSERT INTO kxf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pe kpœtœ œsœnœ, œrœ ɓata djepe yo lœ ala ye dœ́ Sawulo. Tshe tetœ kœwu osho, œ áalafo yé œ gbɔ batisimu. ");
INSERT INTO kxf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Manda nœ, tshe zɨ œrœ yeka á uvuru gu ga lœ nœ. Tshe mbœrœ lima olo teasho dœ ayambarœ nœ Yisu á endje sœ lima lœ Damaseke. ");
INSERT INTO kxf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Œndœ ye dɨdɨ lima nene á tshe tetœ kœpandœ nœ lœ Sinagoga adœke, Yisu kœdœ Gbolo nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Endjeneke kɔ á endje sœ lima kœdji she, endje katœ ama endje tɨ ɔsɔ yé œ pa adœke: «Œ dœ́dœ́ yakoshe asœ dá sœ lima kœmbœrœ œrœ kanga fœ azu á endje yindœ ɨ'ɨrɨ Yisu ɓa lœ Yerusaleme nene a? Tshe nana lima ndœ kœi endje dœ djingiri, yé á kœgu dœ endje fœ agbozu tshapa anganga Ndjaba nene a?» ");
INSERT INTO kxf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kashe gbɔgbɔ kœyisœ Ɔtshɔ O'o nœ Sawulo gerœ lima dœ pa nœ: ɓata á tshe sœ lima kœma ngbɨ adœke Yisu kœdœ Masiya, Ayuda á endje mbœrœ lima ogo lakpɨ Damaseke kpa gugu lima dœ o'o ndœ kœgi fœ she nene. ");
INSERT INTO kxf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Œndœnœ dɨ manda nœ œrrr atake, Ayuda vwarandœ upu kœwo she. ");
INSERT INTO kxf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kashe Sawulo wusœ kœvwarandœ upu nœ endje asœmœ ye. Endje sœ kœgbɔndœ egerœ manda ongbonœ butshɔ dœ ɔlɔ mbœrœ á endje kœwo she. ");
INSERT INTO kxf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dœ anga butshɔ bale, ayambarœ nœ ye za she ga lœ kingi, œ gi she dœ uwu yorrr ga atɨ dja gakele gbagba. ");
INSERT INTO kxf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sawulo wuta ɓa lœ Yerusaleme œ yindœ kœli ga ugurutœ ayindœ Yisu, kashe endje kpa lima awa ye kɔ mbœrœ endje yiyi lima ndœ nœ katsha nene adœke tshe te yindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yé Barnabase za she po tœ ye, œ gi she fœ aayi avwa. Tshe pandœ mara á Sawulo wu Gbozu tœ ala awa œdœ mara á Gbozu pa lima o'o fœ she. Tshe kpa pa ndje fœ endje mara á tshe sœ lima kœyisœ œrœ ngbɨ dœ ɨ'ɨrɨ Yisu ɓa lœ Damaseke. ");
INSERT INTO kxf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pe ndœ lɔkɔnœ asœmœ, Sawulo te ga ndœ endje yé endje tetœ kœyisœ œrœ ngbɨ dœ ɨ'ɨrɨ Gbozu lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tshe pa lima o'o fœ Ayuda á endje sœ kœpa o'o ama Greke yé endje sœ lima kœgbugburu tshelœ o'o dœ endje. Kashe endje sœ lima kœpara awa ndœ kœwo she. ");
INSERT INTO kxf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aayanœ lœ Yisu dji o'onœ ataa, œ to she ro tœnœ ga lœ Sezaré yeka á gbɔ awa kœgi she ga lœ Tarse. ");
INSERT INTO kxf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Azu Ikrizia sœ lima gee lœ ogo Yuda djigi, lœ ogo Galilayi œdœ pe ndje lœ Samariya. Endje sœ lima kœkpa awa Gbozu, yé Ɔtshɔ Ɨshirɨ za lima gbɔgbɔ fœ endje adœke kœyindœrœ nœ endje gerœ. ");
INSERT INTO kxf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro á tshe sœ lima kœro dje lœ ogonœ asœmœ kɔ, na dœ anga ɔlɔ bale ɓa ndœ ayindœ Yisu á endje sœ lima ɓa lœ Lida. ");
INSERT INTO kxf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tshe gbɔ anga yakoshe á ɨ'ɨrɨ ye kœdœ Ene á tshe lo ga atɨ dœ koɓa mangba ungu mindu dœ votɔ, gbambanœ nene, ada ye tshu lima tshakudu ye. ");
INSERT INTO kxf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro pa fœ she adœke: «Ene, Yisu Kristu she ɓœ ye. Aalafo œ guma gbarœ olo zœ!» Yé katsha Ene áalafo. ");
INSERT INTO kxf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Azu kɔ lakpɨ Lida œdœ pe endje nœ akpala osho Sarone wu she ataa, œ fatshalɔsu endje ga ndœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anga yashe bale sœ lima ɓa lœ Yope, œshe lima kœdœ yindœ Yisu; endje e she lima Tabita. Endje fa tshelœ ɨ'ɨrɨnœ lima dœ o'o ama Greke «Dorkase», œ yindœ kœpa adœke «mbele». Tshe sœ lima kœmbœrœ ɔtshɔrœ waa, yé œ sœ kœto œrœ fœ aayi oyo. ");
INSERT INTO kxf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Dœ olonœ asœmœ, tshe gbɔ koɓa yé œ tshu. Manda kœdjutɔ she, endje za she ga lœ gbɔshɔ ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓata á tshalakpɨ Lida sœ ndoo dœ Yope, ayindœ Yisu dji lima ndœ nœ adœke Petro sœ lœ Lida, œ vwa azu bisha dœ o'o fœ she adœke: «Vava ada zœ nene, na ga ndœ 'a katsha ga mœ kane.» ");
INSERT INTO kxf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petro na ga ndœ endje katsha. Lɔkɔ á tshe wuta ɓa zœ, endje 'ɔ dœ she ɓa lœ gbɔshɔ á sœ ɓa lafo, yé ayashe koya para kɔkɔ ka ga utshu ye dœ ngola lœ ala endje. Endje yisœ lœba okoro œdœ pe yɔgbɔdɔ lœba á Dorkase sœ lima kœmbœrœ tœnœ lɔkɔ á tshe sœ dœ soro. ");
INSERT INTO kxf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro gɔrɔ azu ga shu para kɔkɔ œ gote dœ matshukuda ye, yé œ kɨ fœ Ndjaba. Manda nœ, tshe fatœ ye yorrr ga tœ oko uzunœ, œ pa adœke: «Tabita, áalafo.» Tshe kɔrɔ ala ye œ tondœ Petro, œ yɔrɔtshelœtœ ye yé œ sœ ga atɨ dœ budu ye. ");
INSERT INTO kxf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petro bopa kane ye œ tɨ she ga lafo, yé œ e ayindœ Yisu œdœ pe ayashe koya yeka á ma she dœ soro fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Endje dji o'onœ lœ ongbo Yope djigi, yé azu ndjoro fatshalɔsu endje ga ndœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro lo olo ndjoro ɓa lakpɨ Yope ɓa ndœ Shimu á tshe dœ ayi kœguma ɔkɔ agea. ");
INSERT INTO kxf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Anga yakoshe bale ɓa lœ Sezaré, ɨ'ɨrɨ ye kœdœ Korneye; œshe kœdœ gbozu tshapa ukpulu aturugu lœ Roma á endje e tœnœ «ukpulu aturugu tshelœ Itali». ");
INSERT INTO kxf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tshe sœ dœ kœyindœrœ ga ndœ Ndjaba, œ sœ kœkpa awa ye awa bale ndje dœ azu tshasœnda nœ ye. Dœ tœnœ ataa, tshe sœ lima kœto œrœ fœ Ayuda á endje sœ lima dœ oyo, yé œ sœ ndje kœkɨ lima fœ Ndjaba ɔlɔ dœ ɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Anga ɔlɔ bale, dœ ada ɔlɔ votɔ manda kakpi ɔlɔ, tshe wu andjelu nœ Ndjaba lœ ulu kœli ga ndœ ye, yé andjelunœ e she adœke: «Korneye!» ");
INSERT INTO kxf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneye tondœ ye dœ awa, yé œ gi fœ she adœke: «O'o gaɗe, Gbozu?» Andjelu pa fœ she adœke: «Ndjaba dji avwala nœ zœ œdœ pe ɔtshɔrœ á ɓœ sœ kœmbœrœ tœnœ fœ aayi oyo yé tshe djedjerœndœ zœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ngɔngɔ asœke, vwa azu ɓa lakpɨ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro gu tœnœ ga mœ. ");
INSERT INTO kxf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tshe sœ kœlo ɓa ndœ anga ayi akwa kœguma ɔkɔ agea á ɨ'ɨrɨ ye kœdœ Shimu; á anda nœ ye sœ ɓa tœ ama egerœ ungu.» ");
INSERT INTO kxf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lɔkɔ má andjelu á tshe pa o'o fœ she yiwa, Korneye e anga aayi akwa nœ ye bisha œdœ pe anga turugu nœ ɔtshɔ lɔsu á tshe sœ tshakudu ye katshatsha. ");
INSERT INTO kxf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tshe yisœ œrœ kɔ á mbœrœtœ ye fœ endje, yé œ vwa endje ɓa lakpɨ Yope. ");
INSERT INTO kxf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Osho kɔrɔ pa nœ, endje sœpe tœ awa kœro tœnœ œ wuta ndoo dœ Yope, Petro ɔ ga tœ akpala osho ɓa pa kumu anda mbœrœ kœza avwala fœ Ndjaba. Ɔlɔ wuta lima ga pa œrœ nœ́ kakpi ɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kashe tshe sœ lima dœ ogo, yé œ yindœ kœzɨ œrœ. Lɔkɔ á endje sœ lima kœfa kœzɨrœ fœ she, tshe wu œrœ lœ ulu. ");
INSERT INTO kxf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tshe wu tshalafo kɔrɔ yé anga œrœ ɓata egerœ lœba tshapa meza á endje du uwu ga tœ amanœ vavana kɔ sœ kœjerœ ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yé agea kɔ á ada endje sœ vana, endjeneke á endje sœ kœ'ɔrɔ dœ lavu endje tœ ɔshɔ œdœ pe endjeneke á endje sœ kœru ɓa lafo, sœ lima ɓa lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tshe dji tshama uzu kœpa fœ she adœke: «Petro! Áafo, œ wo ageanœ asœ yé œ zɨ endje.» ");
INSERT INTO kxf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petro gi fœ she adœke: «Bale nene, Gbozu. Mbœrœ lœ soro mœ, mœ zɨzɨ œrœ uburu too ekperœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tshe kpa dji tshama uzu kœpa fœ she tœ bishanœ adœke: «Œneke á Ndjaba mbœrœ yerœ, œ lili dœ ɓœ kœpa adœke œtœnœ kœdœ œrœ uburu nene.» ");
INSERT INTO kxf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tshamanœ wu awa votɔ yé katsha manda nœ, œrœnœ ɔ ga lafo. ");
INSERT INTO kxf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petro sœ kœyutœ ye tœ ádá œrœ á tshe wu lœ ulu atake, tshokombele azu á Korneye vwa endje á endje sœ kœyu osho djezœ djezœ tœ anda nœ Shimu, kœyi kumu endje ga pa egerœ manda gbagba. ");
INSERT INTO kxf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Endje e osho yé, œ yu adœke: «Shimu á anga ɨ'ɨrɨ ye kœdœ Petro sœ kœlo kpœke a?» ");
INSERT INTO kxf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petro sœpe lima kolœ kœgbe tshelœ ye tœ œrœ á tshe wu lœ ulu asœmœ, kashe Ɨshirɨ pa fœ she adœke: «Wu, azu votɔ á endje sœ kœpara ɓœ asœke. ");
INSERT INTO kxf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aafo œ Jerœ yé œ gu tœ awanœ bale dœ endje. Awa zaza ɓœ nene mbœrœ œmœ dá vwa endje.» ");
INSERT INTO kxf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petro jerœ ga ndœ endje, œ pa fœ endje adœke: «Œmœ dœke. Uzunœ á 'e sœ kœpara she kœdœ œmœ. 'E na ndœ gaɗe?» ");
INSERT INTO kxf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Endje gi fœ she adœke: «Gbozu tshapa ukpulu aturugu á ɨ'ɨrɨ ye kœdœ Korneye dá vwa 'a. Œshe kœdœ ɔtshɔ uzu á tshe sœ kœkpawa Ndjaba, yé Ayuda para kɔkɔ yindœ ye waa. Anga andjelu nœ Ndjaba bale dá pandœ nœ fœ she lœ ulu adœke tshe 'e ɓœ ɓa lœ anda nœ ye á kœdji œneke á ɓœ pa fœ she.» ");
INSERT INTO kxf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro pa adœke endje li gasœnda, yé œ yisœ osho olo fœ endje. Osho kɔrɔ pa nœ bale, tshe gu tœ awanœ dœ endje. Anga ayindœ Yisu lakpɨ Yope gu tœ awanœ dœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yé tœ bisha olo manda nœ, tshe wuta ga lœ Sezaré. Dá asœmœ ɓa ndœ Korneye, tshe e ayo nœ ye œdœ pe anganœ á tshe yindœtœ ye dœ endje waa, yeka á endje sœ lima kœkate endje. ");
INSERT INTO kxf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lɔkɔ á Petro yi kumu ye, Korneye na para tshatshu ye œ gote ga tœ ada ye mbœrœ kœma ɔtshɔ lɔsu ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petro pa fœ she dœ kœtɨ she ga lafo adœke: «Aalafo, œmœ ndje kœdœ amba uzu gbambanœ.» ");
INSERT INTO kxf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Manda nœ, tshe sœ kœpu o'o dœ Korneye li tœnœ ga sœnda, tshe wu azu ndjoro á endje ngbɔtœ endje ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tshe pa ngbɨ fœ endje adœke: «Ɓata á 'e wusœ nœ, œ sœ dœ ekpenœ adœke Ayuda yindœ angbɨ uzu too kœsœ dœ she tœ œsœnœ bale. Kashe Ndjaba má fœ mœ adœke, mœ papa fœ uzu bale adœke œshe kœdœ ayi uburu too adœke Ndjaba vwaratœ ye tœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mbœrœ tœnœ ataa dá mœ vwavwaratœ mœ kœna ga mœ lɔkɔ á ɓœ vwa osho ndœ mœ nene. Kashe ngɔngɔ asœke, mœ yindœ kœwusœ ádá á ɓœ 'e mœ ga mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneye kœgi fœ she adœke: «Mœ sœ lima kœza avwala fœ Ndjaba ɓa sœnda nœ mœ, œ mbœrœ lima olo votɔ dœ ada ɔlɔ votɔ manda kakpi ɔlɔ. Mœ sœ atake, anga uzu bale á tshe verœ imbi lœba uruuu ka ga utshu mœ, ");
INSERT INTO kxf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","yé œ pa fœ mœ adœke: “Korneye, Ndjaba dji avwala nœ zœ yé œ djedjerœndœ œrœ á ɓœ to lima fœ aayi oyo nene. ");
INSERT INTO kxf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Vwa anga uzu ɓa lœ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro kœgu ɓa ke. Tshe sœ kœlo ɓa sœnda nœ Shimu, ayi kœguma ɔkɔ agea á anda nœ ye sœ ɓa tœ mangu egerœ ungu.” ");
INSERT INTO kxf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mœ vwa uzu ndœ kœpara ɓœ, yé ɓœ yindœ kœna tœnœ dœ ɔtshɔnœ. Ngɔngɔ asœke, a'a kɔ 'a ka ga utshu Ndjaba mbœrœ kœdji œneke á Gbozu za awa fœ ɓœ adœke ɓœ pandœ nœ fœ 'a.» ");
INSERT INTO kxf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yé Petro za o'o œ pa adœke: «Mœ wu adja sœ nœ ngɔngɔ asœ adœke Ndjaba keke azu mbœrœ tshatshu endje nene. ");
INSERT INTO kxf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yé lœ ogo kɔ, uzu á tshe sœ kœkpawa Ndjaba yé á sœ kœmbœrœ œrœ á sœ ndjii, Ndjaba œ yindœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tshe vwa o'o fœ azu tshelœ Israyele, Ɔtshɔ O'o kœsœ gee lœ awa nœ Yisu Kristu á tshe dœ Gbozu nœ azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","«'E wusœ œneke á wuta lima utshunœ ɓa lœ Galilayi, lœ ogo Yuda djigi dœ lɔkɔ á Yowane sœ lima kœyisœ œrœ, á sœ ndje kœza batisimu fœ azu. ");
INSERT INTO kxf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","'E wusœ mara á Ndjaba to gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ fœ Yisu á tshe dœ uzu Nazarete. Tshe na djetœ osho kɔ dœ kœmbœrœ ɔtshɔrœ, tshe she endjeneke para á endje dœ lima akanga nœ djaboro, mbœrœ Ndjaba sœ lima awa bale dœ she. ");
INSERT INTO kxf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Yé a'a, 'a kœdœ atimu nœ œrœ kɔ á tshe mbœrœ ɓa lœ ogo nœ Ayuda œdœ ɓa lœ Yerusaleme. Endje wo she œ kuru she ga pa kurushi. ");
INSERT INTO kxf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kashe Ndjaba she she ugurutœ akuzu manda olo votɔ, yé œ to uvuru fœ she adœke tshe kpa matœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Œ dœ́dœ́ mbœrœ azu djigi nene, kashe fœ 'a á Ndjaba ke 'a katshatsha utshunœ ɓata atimu. 'A zɨ œrœ œ ndjo œrœ awa bale dœ she manda kœshe she ugurutœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mbœrœ tœnœ ataa, tshe pa fœ 'a adœke 'a yisœ nœ fœ azu yé œ ma ndœlanœ fœ endje adœke, œshe dá Ndjaba za she ndœ kœwa ngbanga pa asoro œdœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Aayi kœgbara o'o kɔ pa lima tœ ye adœke uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ Yisu, lœ gbɔgbɔ nœ ɨ'ɨrɨ ye dœ́ Yisu dá Ndjaba œ djerœndœ ekperœ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lɔkɔ á Petro sœpe lima kœpu o'o, Ɔtshɔ Ɨshirɨ jerœ ga pa endjeneke kɔ á endje dji lima o'o ye. ");
INSERT INTO kxf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayindœ Yisu á endje kœdœ Ayuda á endje na lima tœ awanœ dœ Petro ka lima tœ ama endje tɨ ɔsɔ kœwu adœke: Ɔtshɔ Ɨshirɨ á Ndjaba vwa, jerœ ndje lima ga pa angbɨ azu. ");
INSERT INTO kxf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yé endje sœ lima kœdji angbɨ azunœ kœdonga Ndjaba ndje kœpa o'o ama ogo á endje sœsœ lima kœdji tœnœ nene. Petro kpa kœpa adœke: ");
INSERT INTO kxf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɓata á azu asœke gbɔ ndje Ɔtshɔ Ɨshirɨ ɓata azœ, œɗe dá kpa kɔ endje tœ kœgbɔ batisimu dœ ungu a?» ");
INSERT INTO kxf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tshe za o'o adœke endje za batisimu fœ endje dœ ɨ'ɨrɨ Yisu Kristu. Manda nœ, angbɨ azunœ yu she adœke œne yatœ œne dœ she manda olo teasho kane. ");
INSERT INTO kxf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aayi avwa œdœ ayindœ Yisu á endje sœ lima ɓa lœ Yuda dji adœke angbɨ azu yi ndje ndœ o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lɔkɔ á Petro ɔ ga lœ Yerusaleme, anga ayindœ Yisu á endje dœ́ Ayuda, tetœ kœgbugburu tshelœ o'o dœ she ");
INSERT INTO kxf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","adœke: «Ɓœ li ga ndœ angbɨ azu yé œ zɨ œrœ dœ endje!» ");
INSERT INTO kxf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yé Petro pandœ œneke kɔ á ro, kœto ɓa tœ adanœ bale dœ bale fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Lɔkɔ á mœ sœ lima kœkɨ fœ Ndjaba ɓa lakpɨ Yope, mœ wu œrœ lœ ulu: anga œrœ bale ɓata egerœ lœba tshapa meza á endje du uwu ga tœ amanœ vavana kɔ. Œrœnœ asœmœ to ɓa lafo, œ jerœ ga atɨ ndɔɔ ndoo dœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mœ to lima ndœ nœ yima yé œ wu agea gusu á ada endje sœ vana, endjeneke á endje ɔrɔ dœ lavu endje œdœ pe endjeneke á endje ru ɓa lafo. ");
INSERT INTO kxf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Manda nœ, mœ dji tshama uzu kœpa fœ mœ adœke: “Petro! Aalafo, œ wo agea asœke yé œ zɨ endje.” ");
INSERT INTO kxf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yé mœ pa adœke: “Bale nene, Gbozu. Gbambanœ nene, lœ soro mœ, mœ zɨzɨ œrœ uburu too ekperœ nene.” ");
INSERT INTO kxf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Tœ bishanœ, tshama uzu to ɓa lafo adœke: “Œneke á Ndjaba mbœrœ yerœ, œ lili dœ ɓœ kœpa adœke œtœnœ kœdœ uburu nene.” ");
INSERT INTO kxf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Œrœnœ wu ata awa votɔ, yé œ ɔ ga lafo. ");
INSERT INTO kxf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yé tshokombele, azu tshelœ Sezaré votɔ yi kumu endje ɓa tœ anda á 'a sœ tœnœ. Endje na ndœ kœpara mœ. ");
INSERT INTO kxf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɔtshɔ Ɨshirɨ pa fœ mœ adœke mœ gu katsha tœ awanœ dœ endje. Ayakoshenœ mindu dœ bale á mœ to endje rotœnœ ga mœ asœke, 'a na tœ awanœ dœ endje œrrr ɓa lœ Sezaré yé œ li dœ endje kɔ ga lœ anda nœ yakoshenœ asœmœ á ɨ'ɨrɨ ye kœdœ Korneye. ");
INSERT INTO kxf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tshe pandœ mara á andjelu wuta ga tœ ye ɓa sœnda yé á pa fœ she adœke: “Vwa anga uzu ɓa lœ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro, tshe gu ɓa ke. ");
INSERT INTO kxf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tshe pandœ o'o á za kœshe fœ ɓœ dœ azu tshasœnda nœ zœ kɔ.” ");
INSERT INTO kxf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Lɔkɔ á mœ sœ kœpa o'o, Ɔtshɔ Ɨshirɨ jerœ ga pa endje ɓata á jerœ lima utshunœ ga pa azœ. ");
INSERT INTO kxf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mœ gbe tshelœ mœ ndœ o'o á Gbozu pa lima adœke: “Yowane za lima batisimu nœ ungu, kashe e'e, 'e gbɔ batisimu lœ Ɔtshɔ Ɨshirɨ.” ");
INSERT INTO kxf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Œdœ Ndjaba kœto ɔtshɔrœ fœ azunœ asœke ɓata á tshe to fœ azœ á ayindœ o'o Gbozu Yisu Kristu, œmœ kœdœ œɗe yeka á kɔ Ndjaba tœ kœmbœrœ œrœ a?» ");
INSERT INTO kxf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Manda kœdji o'onœ asœmœ, endje sœ koko yé œ za mokɔ fœ Ndjaba dœ kœpa adœke: «Adjapu, Ndjaba to ndje awa kœfatshalɔsu œdœ pe awa kœgbɔ soro fœ angbɨ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Œrœ kanga á mbœrœtœ endje lima dœ lɔndɔ á endje wo lima Etiene, mbœrœ adœke ayindœ Yisu ndjɔ lima tshelœtœ endje ngbangbangba djezœ. Anga endje ro lima ga lœ Fenisi, ga lœ Shipre œdœ ga lœ Atiɔshe; kashe endje sœ lima kœyisœ Ɔtshɔ O'o nœ Ndjaba kolœ fœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Andaa, anga endje ugurutœ endje á endje kœdœ azu tshelœ Shipre œdœ Sirene, endje na ɓa lœ Atiɔshe yé œ yi ndje sœ Ɔtshɔ O'o nœ Gbozu Yisu fœ Agreke. ");
INSERT INTO kxf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gbɔgbɔ nœ Gbozu sœ lima dœ endje awa bale dœ mara adœke azu ndjoro fatœ endje ga ndœ Gbozu yé œ wuta ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Azu Ikrizia lœ Yerusaleme dji o'onœ, yé œ vwa Barnabase ɓa lœ Atiɔshe. ");
INSERT INTO kxf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lɔkɔ á Barnabase yi kumu ye á wu mara ɔtshɔrœ á Ndjaba mbœrœ fœ ayindœ Yisunœ asœmœ, tshe sœ dœ yanga yé œ pa fœ endje kɔ adœke endje za lɔsu endje djigi fœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabase kœdœ ɔtshɔ uzu, tshe sœ dœ Ɔtshɔ Ɨshirɨ œdœ pe kœyindœrœ waa. Ukpulu azu ndjoro te lima azu nœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Manda nœ, Barnabase na kœpara Sawulo ɓa lœ Tarse. ");
INSERT INTO kxf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tshe gbɔ she ɓa zœ œ gu dœ she ga lœ Atiɔshe. Endje bibisha, endje mbœrœ lima ungu bale ɓa lœ Ikrizianœ asœmœ yé œ yisœ œrœ fœ azu ndjoro. Ɓa lœ Atiɔshe dá endje e ɨ'ɨrɨ «Akristu» tœ alinœ ga tœ ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dœ lɔkɔnœ asœmœ, anga aayi kœgbara o'o to ɓa lœ Yerusaleme œ sœ kœna ga lœ Atiɔshe. ");
INSERT INTO kxf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anga bale á ɨ'ɨrɨ ye kœdœ Agabuse, á Ɔtshɔ Ɨshirɨ sœ kœma œrœ fœ she, mɨndœ nœ adœke egerœ ogo œ za tshapashɔ djigi lœ ondonœ zœ. Manda nœ, œ mbœrœtœ endje lima dœ lɔndɔ á Klode dœ lima gbozugo Roma. ");
INSERT INTO kxf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mbœrœ tœnœ ataa, ayindœ Yisu wa o'o adœke œne vwa œrœ fœ anga œne á endje sœ ɓa lœ Yuda. Uzu dœ uzu œ to liaka gbɔgbɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Endje mbœrœ lindœ œneke á endje wa, yé œ vwa œrœ á endje gbɔ, lœ awa nœ Abarnabase dœ Sawulo fœ agbozu lœ ogo Yuda. ");
INSERT INTO kxf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dœ lɔndɔnœ asœmœ, gbozugo Erode sœ lima kœmbœrœ œrœ kanga fœ anga azu Ikrizia. ");
INSERT INTO kxf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tshe mbœrœ adœke endje wo Jake, aya Yowane, dœ ugu kamba. ");
INSERT INTO kxf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yé lɔkɔ á tshe wu adœke œrœ má œne mbœrœ za yanga fœ Ayuda waa, tshe kpa pa adœke, endje za Petro. Œ sœ lima dœ lɔkɔ angbo nœ mapa á susuku nene. ");
INSERT INTO kxf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tshe bopa ye œ vwi she ga lœ kánga, yé œ pa fœ ukpulu aturugu vana á ngbɔɓa aturugu vana vana, mbœrœ kœgbɔndœ ye. Tshe sœ kœgbe lima adœke manda angbo Pake yeka á œne kœdji she ɓa utshu azu para kɔkɔ. ");
INSERT INTO kxf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Endje gbɔ lima ndœ Petro ɓa lœ kánga, kashe azu Ikrizia kaka lima tœ kœza avwala dœ ɨ'ɨrɨ ye fœ Ndjaba nene. ");
INSERT INTO kxf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erode yi lima ndœ kœwa ngbanga nœ ye tœ ala azu para kɔkɔ. Dœ butshɔnœ asœmœ, Petro lo ɓa ugurutœ aturugu bisha, endje i she vwagbagba dœ djingiri bisha yé aayi kœgbɔndœ manda ka ɓa utshu manda kánganœ. ");
INSERT INTO kxf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kashe tshokombele, andjelu nœ Gbozu yikumu ye, yé ɨshirɨ owo za osho djigi. Andjelu turutœ ye œ jo she, á pa fœ she adœke: «Aalafo katsha!» Djingirinœ kœzu tœ kane Petro. ");
INSERT INTO kxf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yé andjelu kpa pa fœ she adœke: «I uwu tshapa lœba nœ zœ, œ soro uwu œrada nœ zœ.» Petro mbœrœtœ ye lindœ o'o ye. Andjelu kpa pa adœke: «Verœ yɔgbɔdɔ lœba nœ zœ yé œ te manda mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro wuta lœ kánga œ te manda andjelu. Tshe gbe œnœ ye adœke œneke á andjelu mbœrœ asœmœ dœ́dœ́ adja œrœ nene, kashe œne wu œrœ lœ ulu. ");
INSERT INTO kxf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Endje ro ali azu kœgbɔndœ manda, manda nœ endje ro bisha endje yé œ wuta ga tœ manda yarakowo á wuta kpuru ga lœ ongbo: mandanœ kɔrɔ dœ tœ ye utshu endje. Lɔkɔ á endje wuta ga shu, endje ro tshatœ ama gbɔlɔ, yé tɨtɨvwɨrɨ andjelu kœyiwa ye. ");
INSERT INTO kxf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Uvuru Petro kœkwa ga lœ nœ, á tshe kœpa adœke: «Ngɔngɔ asœke, mœ wu adœke œ dœ́ adjapu: Gbozu vwa andjelu nœ ye á tshe vwara mœ tshakane Erode dœ pe lœma ekperœ á Ayuda guma ndœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Manda kœgbe tshelœ ye tœ œneke á mbœrœ fœ she, tshe gu ga lœ anda nœ Mareya, ayi Yowane á anga ɨ'ɨrɨ ye kœdœ Marke. Azu ndjoro sœ lima kœdonga Ndjaba ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Lɔkɔ á tshe nge manda, anga yawuru akwa bale á ɨ'ɨrɨ ye kœdœ Rode, na mbœrœ kœkɔrɔ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tshe dji tshama Petro œ sœ dœ yanga, œ tshapu kœkɔrɔ manda, yé œ kpa dœ ɔrɔ mbœrœ kœpandœ nœ adœke, Petro ka ɓa pa manda ɓa shu. ");
INSERT INTO kxf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Endje pa fœ she adœke: «Iyi sœ lœ kumu zœ a!» Kashe tshe pa fœ endje adœke, œneke á œne sœ kœpa fœ endje kœdœ adjapu. Á endje kœpa adœke: «Asœmœ kœdœ andjelu á tshe sœ kœgbɔndœ Petro dœmœ.» 16 ");
INSERT INTO kxf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petro sœpe kolœ kœnge manda. Lɔkɔ á endje kɔrɔ manda, endje wu she yé œ i gbɔndjuru. ");
INSERT INTO kxf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tshe mbœrœ kane ye fœ endje adœke endje sœ koko, yé œ pandœ mara á Gbozu za she ga shu lœ kánga fœ endje. Tshe kpa pa adœke: «'E na œ pandœ nœ fœ Jake œdœ pe fœ anga ayindœ Yisu.» Manda nœ, tshe wuta yé œ na ga tœ angbɨ osho. ");
INSERT INTO kxf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Osho kɔrɔ, aturugu yakatœ endje ngbangbangba. Endje tetœ kœyutœ endje lœtœ endje adœke Petro fatœ ye tœ ɗe! ");
INSERT INTO kxf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erode vwa azu kœpara Petro œrrr toroboka, endje gbɔ gbɔ she nene. Tshe yu aayi kœgbɔndœ manda kánganœ, yé á pa adœke endje wo endje ye. Manda nœ, Erode to ɓa lœ ogo Yuda œ na ga lœ Sezaré, yé œ mbœrœ olo teasho ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erode sœ lima dœ geda dœ azu ogo Tire œdœ azu ogo Sidona. Azu ogonœ bibisha asœke yindœ kœwuta ga utshu ye. Endje u Blastuse á tshe dœ uzu tshapa ayi akwa nœ Erode, œ dji o'o tshelœ ye. Endje na kœyu Erode adœke tshe mbœrœ adœke œne sœ gee. Gbambanœ nene, ogo nœ endje gbɔ œrœ kœto ɓa lœ œnœ ye dœ gbozugo. ");
INSERT INTO kxf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dœ lɔkɔnœ á endje guma tœ kœgbɔtœ endje, Erode verœ lœba tshagbozu nœ ye, œ sœ ga pa ngande gbozu nœ ye, yé œ tetœ kœpu o'o ɓa utshu azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Azu tetœ kœta rawa adœke: «Asœ kœdœ tshama ndjaba, œ dœ́dœ́ œnœ uzu nene!» ");
INSERT INTO kxf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kashe, pe tœ œsœnœ, andjelu nœ Gbozu ɓi Erode mbœrœ á tshe tshapu kœdonga Ndjaba tɨ, yé á sœ kœlɨsœtœ ye adœke œne kœdœ Ndjaba. Angɔzu zɨ she lœ ɔkɔnœ yé tshe tshu. ");
INSERT INTO kxf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","O'o ama Ndjaba ka aka osho kɔ, yé azu á endje yindœ nœ wuta lima ndjoro. ");
INSERT INTO kxf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lɔkɔ á akwa nœ Abarnabase dœ Sawulo ka lima lœ Yerusaleme, endje za lima Yowane á anga ɨ'ɨrɨ ye kœdœ Marke potœ endje á gu dœ she. ");
INSERT INTO kxf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aayi kœgbara o'o œdœ aayi kœyisœrœ sœ lima ɓa lœ Ikrizia nœ Atiɔshe. Œ dœ lima Barnabase, Shimeyo á anga ɨ'ɨrɨ ye kœdœ Ubu Uzu œdœ pe Lukiyuse uzu tshelœ Sirene, dœ Sawulo œ ga ndœ Manaene yanga Erode á tshe sœ lima kœna tœ awanœ dœ she pe dœ tshagbolo ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Anga ɔlɔ bale á endje sœ lima kœdonga Gbozu yé á sœ kœyotshelœma endje, Ɔtshɔ Ɨshirɨ pa adœke: «'E ko Abarnabase dœ Sawulo ga ɨndɨrɨnœ mbœrœ adœke endje mbœrœ œrœ œneke á mœ e endje ndœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yé manda kœyotshelœma endje dœ pe kœdonga Ndjaba, endje to kane endje ga pa endje yé œ za awa fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ɓata á Ɔtshɔ Ɨshirɨ vwa Barnabase dœ Sawulo, endje na ɓa lakpɨ Selœsi, œ ɔ egerœ agba ɓa zœ yeka á ro ga lœ Shipre. ");
INSERT INTO kxf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lɔkɔ á endje wuta ga lœ Salamine, endje tetœ kœmɨndœ o'o ama Ndjaba ɓa lœ Sinagoga nœ Ayuda. Yowane á anga ɨ'ɨrɨ ye kœdœ Marke sœ ndje lima kpœtœmœ mbœrœ kœtɨ kane endje. ");
INSERT INTO kxf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Manda kœzu tshiki para œrrr kœwuta ɓa lœ Pafose, endje gbɔ anga ayi kœpandœ ulu bale á ɨ'ɨrɨ ye kœdœ Bare Yisu; œshe kœdœ Yuda á tshe zatœ ye ɓata ayi kœgbara o'o. ");
INSERT INTO kxf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tshe sœ lima ɓa ndœ gbozu Sereyuse Pawuluse á tshe kœdœ ayi kœwusœrœ, á tshe e Barnabase dœ Sawulo mbœrœ tshe sœ lima dœ ogo kœdji o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kashe ayi kœpandœ ulu Elimase (ɨ'ɨrɨ Bare Yisu dœ Greke dœmœ) yiyi lima ndœ o'o ama endje nene, yé œ para awa kœndɨ tshelœ gbetshelœ nœ gbozu asœmœ adœke tshe sœsœ kœyindœrœ ga ndœ Yisu nene. ");
INSERT INTO kxf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yé Sawulo á anga ɨ'ɨrɨ ye kœdœ Polo á Ɔtshɔ Ɨshirɨ su she kperœ, za ala ye kukuku ga tœ ye, ");
INSERT INTO kxf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","yé œ pa adœke: «Œɓœ, afara œdœ pe ekperœ su ɓœ kperœ. Œɓœ kœdœ gbolo nœ djaboro, uzu á tshe yiyindœ djakata o'o nene. Ɓœ katœ kœndɨ awa nœ Gbozu á sœ ndjii nene a? ");
INSERT INTO kxf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ngɔngɔ asœke, kane Ndjaba sœ pa zœ. Ɓœ fa ayibula, yé ɓœ wu ɔlɔ nene œrrr ga tœ olo á tshe yindœ nœ.» Pe kpœtœ œsœnœ, tshelœ ala ye wu shuu yé osho bu kporokoto tœ ye. Tshe fatœ ye djikɨrɨli djikɨrɨli kœpara uzu adœke tshe za ama kane œne. ");
INSERT INTO kxf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lɔkɔ á gbozugo wu œneke á mbœrœtœ endje, tshe te yindœ Yisu; gbambanœ nene, o'o ama Gbozu za lima uvuru ye lœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polo dœ anganœ á tshe na tœ awa dœ endje ɔ lima ga lœ egerœ agba ɓa lœ Pafose, œ ro ga lœ Perje ɓa lœ Pafili. Yé Yowane katœ endje, œ kwatœ ye ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Endje katœ tshalakpɨ Perje tɨ, yé œ wuta ɓa lœ Atiɔshe nœ ogo Pisidi. Lɔkɔ sabata, endje li ga lœ Sinagoga yé œ sœ lima ga atɨ. ");
INSERT INTO kxf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Manda kœdɨ buku á ngbɔɓa awa akwa nœ Moyize dœ œnœ aayi kœgbara o'o, agbozu tshelœ Sinagoga pa fœ endje adœke: «Aaya, 'e kœsœ dœ anga o'o á sœ kœto gbɔgbɔ fœ uzu, 'e pa!» ");
INSERT INTO kxf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polo áalafo œ mbœrœ kane ye, yé œ pa adœke: «Azu tshelœ Israyele œdœ pe e'e dœ angbɨ azu á 'e sœ kœkpa awa Ndjaba, 'e dji mœ kane. ");
INSERT INTO kxf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ndjaba nœ azu Israyele ke aata 'a. Tshe mbœrœ adœke endje ngba lɔkɔ á endje sœ lima ɓa lœ Ezipito. Manda nœ, tshe ko endje lima ga shu dœ gbɔgbɔ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tshe gbɔndœ endje lima ɓa lœ kpagagasho manda ungu zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Manda nœ, tshe wo lima ogo mindu dœ bisha lœ ogo Kanana yé œ kurutshelœ nœ tœ azu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Œtœnœ kɔ mbœrœ lima ga pa œrœ nœ́ ungu kama vana dœ zazu bisha dœ ndjokpa (450). «Manda nœ, tshe ko aayi kœwa ngbanga fœ endje œrrr ga tœ ayi kœgbara o'o Samwele. ");
INSERT INTO kxf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Endje yu osho tœ gbozugo yé Ndjaba za Sawulo, gbolo nœ Kise á tshe kœdœ uzu lœ mara nœ Bendjame, fœ endje. Tshe sœ pa endje manda ungu zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Manda kœza Sawulo ga shu tœ akwa, Ndjaba za Davidi tœ gbozugo. Tshe ma o'o nœ ye ngbɨ adœke: “Mœ gbɔ Davidi, gbolo nœ Yese, uzu á lɔsu mœ yindœ ye. Tshe mbœrœ œneke kɔ á mœ gbe dœ tœnœ.” ");
INSERT INTO kxf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ɓa lœ aatanœ dá Ndjaba za Yisu tœ ayi kœshe azu Israyele ɓata á tshe pa lima tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Utshu kœna lima Yisu, Yowane pandœ nœ lima fœ azu Israyele adœke endje fatshalɔsu endje, yé œ gbɔ batisimu. ");
INSERT INTO kxf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yé lɔkɔ á Yowane mbœrœ lima akwa nœ ye á ka ye, tshe sœ lima kœpa adœke: “'E gbe adœke œmœ kœdœ eɗe e? Œ dœ́dœ́ mœ kœdœ tsheneke á 'e kate she nene! Kashe anga uzu á tshe na manda mœ, mœ li kœzu uwu œrada nœ ye nene.” ");
INSERT INTO kxf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«E'e dœ aaya mœ, aata Abrayamo ndje dœ angbɨ azu á 'e sœ kœkpa awa Ndjaba asœke, endje vwa Ɔtshɔ O'onœ asœke á pandœ kœshe fœ azœ. ");
INSERT INTO kxf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Azu Yerusaleme œdœ pe agbozu tshapa endje wuwusœ Yisu nene, endje wuwu ndje sœ ádá o'o má aayi kœgbara o'o su á endje sœ kœdɨ tœnœ ɔlɔ sabata bale dœ bale nene. Kashe endje wa ɔgbɔ ngbanga ga pa Yisu liaka o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ataa endje para lima awa kœwo she œrrr toro ye, endje kapa Pilato adœke tshe wo she. ");
INSERT INTO kxf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lɔkɔ á endje mbœrœ lima œneke kɔ á Buku nœ Ndjaba pandœ nœ tœ upu nœ ye, endje za lima she pa kurushi ga atɨ, yé œ shi lima she ɓa lœ anga udu bale. ");
INSERT INTO kxf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kashe Ndjaba she lima she lœ akuzu ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tshe wuta lima lœ olo ndjoro ga tœ endjeneke á endje na lima dœ she awa bale kœto ɓa lakpɨ Galilayi œrrr ga lœ Yerusaleme, endje á endje kœdœ atimu ngɔngɔ asœke ɓa utshu azu ogo Israyele. ");
INSERT INTO kxf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«A'a ndje, 'a sœ kœyisœ Ɔtshɔ O'onœ asœke fœ 'e, œrœ á Ndjaba pa lima tœ nœ fœ aata 'a adœke œne mbœrœ, ");
INSERT INTO kxf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tshe mbœrœ fœ azœ má a dœ agbolo nœ endje, lɔkɔ á tshe she lima Yisu lœ akuzu ɓata á endje sú ɓala bisha mbeti nœ Ɨtshi adœke: “Œɓœ kœdœ gbolo nœ mœ, kœto kpesheke, œmœ dá zu ɓœ.” ");
INSERT INTO kxf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ndjaba pa lima adœke œne shé she lœ akuzu, yé tshe gba nene. Tshe pa lima ngbɨ adœke: “Mœ to kane nœ mœ dœ adja œyerœ kœto kane ga pa 'e, ɓata á mœ pa lima ndœ kœto fœ Davidi.” ");
INSERT INTO kxf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mbœrœ tœnœ dá Davidi pa ndje ala anga mbeti adœke: “Ɓœ katœ œyerœ uzu nœ zœ adœke tshe gba nene.” ");
INSERT INTO kxf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lɔkɔ á Davidi sœpe lima dœ soro, tshe mbœrœ lima œneke á Ndjaba yisœ nœ. Manda nœ, tshe tshu lima, endje shi she ndoo dœ aatanœ yé ɔkɔ ye gba. ");
INSERT INTO kxf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kashe tsheneke á Ndjaba shé she, gbagba lima nene. ");
INSERT INTO kxf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Aaya mœ, 'e wusœ nœ dœ ɔtshɔnœ adœke mangba Yisu dá endje pandœ o'o kœdjerœndœ ekperœ fœ 'e á awa akwa nœ Moyize lili lima ndœ kœvwara 'e lœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ ye, tshe wuta uzu ndjii tœ ala Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mbœrœ tœnœ ataa, 'e sœ dœ gbɔdjela mbœrœ á o'o neke á aayi kœgbara o'o su kœwuwuta ga tœ 'e nene: ");
INSERT INTO kxf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“'E wu kane! E'e dœ adjipudji, 'e katœ ama 'e tɨ ɔsɔ yé œ ndjɔtshelœtœ 'e! Gbambanœ nene, mœ yindœ kœmbœrœ anga œrœ bale lœ soro 'e, œrœ neke á 'e yindœ nœ nene, œdœ uzu kœpandœ nœ fœ 'e.”» ");
INSERT INTO kxf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lɔkɔ á Polo dœ Barnabase sœ lima kœwuta tœnœ, endje tetœ kœkɨ fœ endje adœke endje kwa dœ ɔlɔ sabata manda nœ œ kpa yisœ o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Manda angbɔtœnœ, Ayuda œdœ pe angbɨ azu á endje sœ kœkpa awa Ndjaba te manda Polo dœ Barnabase. Lœ o'o á endje sœ kœpa tœnœ, Polo dœ Barnabase pa fœ endje adœke: «'E zatœ 'e djigi ga tœ ɔtshɔrœ nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lɔkɔ sabata manda nœ, œ sœ ɓata azu kɔ lœ ongbo ngbɔtœ endje lima mbœrœ kœdji o'o ama Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kœwu ukpulu azunœ ataa, Ayuda mbœrœ uku yé œ tetœ kœgu Polo dœ kœyiangba o'o ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Polo dœ Barnabase mɨndœ nœ dœ awanœ adœke: «Œ li má lima adœke endje yisœ Ɔtshɔ O'onœ asœke utshunœ fœ 'e! Ɓata á 'e vwaratœ 'e tœnœ, yé á wa ngbanga dœ tœ 'e adœke 'e lili kœgbɔ soro nœ wa dœ wa nene asœmœ, 'a fatœ 'a ngɔngɔ asœ ga ndœ angbɨ azu. ");
INSERT INTO kxf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Awa akwanœ á Gbozu pa tœnœ fœ 'a dœke: “Mœ za ɓœ ɓata ɔlɔ kœtshi pa angbɨ azu lœ ogo kɔ, mbœrœ adœke ɓœ yisœ o'o nœ kœshe œrrr tɔ ga tœ ndɔngɔlɔ osho.”» ");
INSERT INTO kxf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kœdji o'onœ asœmœ ataa, angbɨ azu tetœ kœdonga Gbozu dœ yanga. Endjeneke á endje sœ lima mbœrœ soro nœ wa dœ wa, endje te lima ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","O'o ama Gbozu za lima tshelœ ogonœ djigi. ");
INSERT INTO kxf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kashe Ayuda bɨlɨ ayashe á œsœ endje lɨ, á endje sœ kœdonga Ndjaba œdœ pe agbozu tshapa ongbo. Endje mbœrœ œrœ kanga ga tœ Polo dœ Barnabase, yé œ gɔrɔ endje lœ ogo nœ endje ye. ");
INSERT INTO kxf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Polo œdœ Barnabase gɔrɔ trusha tshada endje fœ endje, yé œ ro ga lœ Ikoniyume. ");
INSERT INTO kxf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dá asœmœ ayindœ Yisu ɓa lakpɨ Atiɔshe sœ lima dœ yanga waa, yé œ su dœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO kxf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Polo œdœ Barnabase na ɓa lakpɨ Ikoniyume œ li ndje ga lœ Sinagoga nœ Ayuda œ pa o'o yé Ayudanœ dœ pe Agreke ndjoro te lima ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kashe Ayuda neke á endje yiyi lima ndœ nœ nene, to gbetshelœ kœmbœrœ ekperœ ga tœ ayindœ Yisu fœ angbɨ azu. ");
INSERT INTO kxf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Andaa Polo œdœ Barnabase mbœrœ lima olo ndjoro ɓa lœ Ikoniyume. Endje pa lima o'o dœ awa nene lœ kœyindœrœ nœ endje ga ndœ Gbozu. Kœwu tœnœ ataa, Gbozu ma adœke o'onœ á endje sœ kœpa tœnœ tœ upu ɔtshɔrœ nœ ye kœdœ adja o'o, á tshe to gbɔgbɔ nœ kœfa œrœ dœ kœma ambáránœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Azu tshelœ ongbo kurutshelœtœ endje: anga endje yindœ Ayuda yé anga endje yindœ aayi avwa. ");
INSERT INTO kxf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Angbɨ azu, Ayuda dœ pe agbozu tshapa endje vwara lima ndœ kœmbœrœ œrœ kanga ga tœ Polo dœ Barnabase œdœ kœve endje dœ badja. ");
INSERT INTO kxf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Endje wusœ o'onœ yé œ kpa gu tœnœ dœ awa ongbo Listre œdœ Derbe lœ ogo Likawoni œdœ pe ndje ogo para ɨndɨrɨnœ. ");
INSERT INTO kxf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Endje sœ lima kœpa ndje ndœ Ɔtshɔ O'o ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Anga yakoshe bale á ada ye tshu, sœ lima ɓa lakpɨ Listre. Ɓata á endje zu lima she tœ ayi vwɨrɨtɨ, tshe nana lima ana bale nene. ");
INSERT INTO kxf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Anga ɔlɔ bale á tshe sœ kœdji o'o á Polo sœ kœpa tœnœ, Polo za ala ye kukuku ga tœ ye, yé œ wu adœke tshe sœ dœ kœyindœrœ mbœrœ kœshe tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Polo pa dœ ɔgbɔ fœ she adœke: «Aalafo œ ka ndjii dœ ada zœ!» Yakoshenœ i ga lafo yé œ tetœ kœna lima ana. ");
INSERT INTO kxf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kœwu œneke á Polo mbœrœ asœmœ, azu ndjoro oma kekeke œ pa dœ o'o ama ogo Likawoni adœke: «Andjaba fatœ endje tœ azu yé á jerœ ga ndœ azœ asœke.» ");
INSERT INTO kxf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Endje e Barnabase «Zewuse», yé œ e Polo «Ermese» mbœrœ œshe dá sœ lima kœmɨndœ o'o. ");
INSERT INTO kxf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nganga ndjaba lœ anda nœ Zewuse á sœ ɓa ushu nœ ongbo, na dœ akɔ angombe á endje guma endje dœ flere. Œshe œdœ azu ndjoro, endje yi lima ndœ kœsho endje tœ tokóró fœ Polo dœ Barnabase. ");
INSERT INTO kxf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Dœ lɔndɔ á endje dji ataa, endje súru lima tshelœ lœba tœ endje yé œ gbɔgbɔtœ endje dœ ana gutœnœ ga lœ ukpulu azu. Endje pa dœ ɔgbɔ adœke: ");
INSERT INTO kxf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Uu aaya, mbœrœ gaɗe á 'e mbœrœ ataa? A'a kœdœ ndje azu ɓata 'e! 'A sœ kœpandœ Ɔtshɔ O'o fœ 'e adœke 'e katœ œrœ á ádánœ gugu nene, mbœrœ kœfatœ 'e ga ndœ Ndjaba á tshe sœ dœ soro yé á mbœrœ tshalafo, dœ ɔshɔ, dœ egerœ kota œdœ pe œneke kɔ á sœ lœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lɔkɔ nœ aata azœ, tshe ka lima tœ azu ogo para kœza awa nœ endje dœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kashe atamœ gbaa, tshe kakatœ kœma adœke œne sœ zœ lœ awa nœ ɔtshɔrœ nœ ye fœ endje nene. Ɔtshɔrœnœ asœmœ dœke: tshe vwa yavuru fœ 'e mbœrœ kœmɔ ɔshɔ tshelœ kɨndɨ nœ 'e adœke 'e gbɔ kœzɨrœ á li, yé lɔsu 'e sœ dœ yanga.» ");
INSERT INTO kxf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ataa ukpulu azunœ dji lima o'o nœ aayi avwa gbaa, endje sœ lima dœ sharapu utshu kœkatœ kœza tokórónœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anga Ayuda á endje to ɓa lœ Atiɔshe œdœ ɓa lœ Ikoniyume, te ga ndœ ukpulu azu asœmœ. Endje ve lima Polo dœ badja, yé œ gbe adœke tshe tshu ye yeka á gbota she lœ ongbo ga shu. ");
INSERT INTO kxf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kashe lɔkɔ á ayindœ Yisu ngbɔtœ endje ga ɨndɨrɨ ye, tshe áalafo yé œ kwatœ ye ga lœ ongbonœ. Osho kɔrɔ pa nœ, endje ro dœ Barnabase ga lœ Derbe. ");
INSERT INTO kxf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Endje pandœ Ɔtshɔ O'o lœ ongbo Derbe yé œ gbɔ ayindœ Yisu ndjoro. Manda nœ, endje kpa kwatœ endje tɔ lœ Listre, lœ Ikoniyume œdœ pe tɔ lœ Atiɔshe. ");
INSERT INTO kxf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Endje sœ lima kœto gbɔgbɔ ga tœ lɔsu ayindœ Yisu yé œ pa fœ endje adœke endje shi gbɨ lœ kœyindœrœ. Endje pa adœke: «Œ li adœke a wu oyo waa yeka á kœli ga lœ tshagbozu nœ Ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lœ Ikrizia bale dœ bale, endje ke agbozu Ikrizia fœ endje, œ donga Ndjaba dœ kœyotshelœma endje, yé œ katœ endje tɨ fœ Gbozu á endje sœ dœ kœyindœrœ ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Endje ro tɔ lœ Pisidi, yé á na ga lœ Pafili. ");
INSERT INTO kxf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Endje pandœ Ɔtshɔ O'o ɓa tœ Perje, manda nœ á ro ga lœ Atali. ");
INSERT INTO kxf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Endje ɔ ga lœ egerœ agba ɓa zœ yé á gu ga lœ Atiɔshe nœ Siri, tshalakpɨ á endje ko lima endje ga tshakane Gbozu adœke endje gbɔ ɔtshɔrœ nœ Ndjaba mbœrœ akwa á endje totœ kœmbœrœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lɔkɔ á endje wuta lima ga lœ Atiɔshe, endje ngbɔɓa azu Ikrizia yé œ pandœ œneke kɔ á Ndjaba mbœrœ lima fœ endje dœ pe mara á tshe kɔrɔ awa kœyindœrœ fœ angbɨ azu. ");
INSERT INTO kxf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yé endje lo olo ndjoro tœ œsœnœ bale dœ ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Anga ayakoshe to ɓa lœ Yuda, œ tetœ kœyisœ œrœ fœ aayazu lœ Yisu adœke: «Œdœ 'e kœvwaratœ 'e tœ kœwa gaza ɓata awa akwa nœ Moyize pandœ nœ, 'e gbɔ kœshe nene.» ");
INSERT INTO kxf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Polo œdœ Barnabase vwaratœ endje tœ kœyisœ œrœ nœ ayakoshenœ asœmœ, œ gbugburu tshelœ o'o dœ endje tœ upunœ. Manda nœ, endje wa adœke Polo œdœ Barnabase, ndje dœ anga aayazu lœ Yisu ɔ ga lœ Yerusaleme ndœ kœgbɔtœ endje dœ aayi avwa œdœ agbɔ Azu Ikrizia mbœrœ kœyɔrɔ o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Azu Ikrizia lœ Atiɔshe to œrœ á li mbœrœ ananœ fœ endje. Kœro endje tɔ lœ Fenisi dœ Samariya, endje sœ kœpandœ mara á angbɨ azu fa lɔsu endje yé œ za yanga waa fœ aayazu lœ Yisu para. ");
INSERT INTO kxf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɔlɔ á endje wuta ga lœ Yerusaleme, azu Ikrizia, aayi avwa dœ pe agbozu Ikrizia za osho kœsœ fœ endje yé endje pandœ œrœ kɔ á Ndjaba mbœrœ lœ awa nœ endje fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kashe anga ayindœ Yisu á endje to lœ Afarisayi za o'o œ pa adœke: «Œ li adœke angbɨ azu á endje wuta ayindœ Yisu wa gaza, œ lɨ ndje sœ awa akwa nœ Moyize.» ");
INSERT INTO kxf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aayi avwa œdœ agbozu Ikrizia ngbɔɓatœ endje mbœrœ kœgbe o'o tœ upunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Manda kœgbugburu tshelœ o'o œrrr, Petro áalafo yé œ pa adœke: «Aaya, 'e wusœ nœ adœke Ndjaba ke lima mœ ugurutœ 'e katshatsha ndœ kœpandœ Ɔtshɔ O'o fœ angbɨ azu adœke endje dji, œ yindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yé Ndjaba á tshe wusœ lɔsu azu para kɔkɔ, za Ɔtshɔ Ɨshirɨ fœ endje tœ kœma adœke œne yi ndje ndœ endje awa bale ɓata á tshe mbœrœ ndje fœ azœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tshe yiyi ko ndœ azœ yé œ vwaratœ ye tœ endje nene; gbambanœ nene, lœ awa nœ kœyindœrœ nœ endje ga ndœ Yisu, tshe djutɔ ekperœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ngɔngɔ asœ, mbœrœ gaɗe á 'e sœ kœshokɔ o'o dœ Ndjaba a? 'E yindœ kœza egerœ gbarœ á azœ dœ aata azœ, a zaza lima nene ga pa kumu ayindœ Yisu a? ");
INSERT INTO kxf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kashe a wusœ nœ adœke, a she kolœ mangba ɔtshɔ lɔsu nœ Gbozu Yisu, yé endje ndje awa bale.» ");
INSERT INTO kxf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Manda nœ, azu lœ kokoko ndœ kœdji Polo œdœ Barnabase, á endje sœ kœmɨndœ œrœ á sœ kœma mara œrœ á Ndjaba mbœrœ lœ awa nœ endje ugurutœ angbɨ azunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lɔkɔ á endje pa o'o nœ endje á ka, Jake áalafo œ pa adœke: «Aaya, 'e dji mœ kane. ");
INSERT INTO kxf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shimu wuta kœmɨndœ nœ fœ azœ mara á Ndjaba gbe ɓalima katshatsha á ke anga azu ugurutœ angbɨ azu adœke endje dœ azu nœ œne. ");
INSERT INTO kxf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Œrœ á Ndjaba mbœrœ li dœ o'o ama aayi kœgbara o'o. Gbambanœ nene, Ndjaba pa adœke: ");
INSERT INTO kxf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Manda nœ kɔ, mœ kpa kwatœ mœ ndœ kpa kœmɔ anda nœ Davidi á te. Agbanœ á sœ atɨ, mœ kpa mɔ tshandœnœ, yé mœ kpa za ga lafo. ");
INSERT INTO kxf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kœto kpœtœmœ, udu azu œ para awa Gbozu, œdœ pe angbɨ azu kɔ á mœ ke endje. Œmœ Gbozu dá pa o'onœ asœke, mœ sœ kœguma o'o nœ mœ ");
INSERT INTO kxf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","á mœ gbe ɓalima katshatsha.”» ");
INSERT INTO kxf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jake kpa kœpa adœke: «Mœ gbe œnœ mœ adœke œ lili adœke a mbœrœ œrœ kanga fœ azu á endje fatshalɔsu endje fœ Yisu nene. ");
INSERT INTO kxf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kashe a su kolœ mbeti fœ endje adœke, endje zɨzɨ agea á to ɓa pa ndaba nœ andjaba nene, endje zɨzɨ songba agea á tshe tshu á indji ye tutu nene, endje zɨzɨ indji nene yé adja endje mbœmbœrœ angba budu nene. ");
INSERT INTO kxf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mbœrœ katshatsha ɓalima, endje yisœ awa akwa nœ Moyize dje lakpɨ kɔ mbœrœ á endje sœ kœdɨ tœnœ lɔkɔ sabata bale dœ bale lœ anda ngbɔtœ.» ");
INSERT INTO kxf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ataa aayi avwa, dœ agbozu Ikrizia œdœ pe azu Ikrizia para kɔkɔ wu dœ ɔtshɔnœ adœke, endje ke anga azu ugurutœ œne dœ́ vwa endje ɓa lœ Atiɔshe awa bale dœ Polo œdœ Barnabase. Yekane á endje ke Yuda á anga ɨ'ɨrɨ ye kœdœ Barsabase œdœ pe Sila. Endje bibisha kœdœ azu á endje sœ lima kœlɨsœ endje ugurutœ ayindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mbeti á endje sú ga tshakane endje pa adœke: «Aaya 'a dœ angbɨ azu á 'e sœ lœ Atiɔshe, lœ Siri, œdœ ndje lœ Silisi: aayi avwa, dœ agbozu Ikrizia œdœ azu Ikrizia para kɔkɔ za abala fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","A dji adœke anga azu á endje to ɓa ndœ 'a ɓa ke, á na ga ndœ 'e kœdjingili tshelœ kumu 'e, endje ndɨ gbetshelœ nœ 'e kashe œ dœ́dœ́ 'a dá vwa endje nene. ");
INSERT INTO kxf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ádánœ á 'a wa kɔ dœ lɔsu 'a bale adœke 'a ke anga azu dœ́ vwa endje fœ 'e. Endje ro tœ awanœ dœ aaya 'a á 'a yindœ endje waa, Polo œdœ Barnabase ");
INSERT INTO kxf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","á endje za soro endje djigi mbœrœ akwa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO kxf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","'A vwa Yuda dœ Sila adœke endje kpa pandœ œneke kɔ á 'a su ala mbetinœ asœke fœ 'e dœ ama endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gbambanœ nene, Ɔtshɔ Ɨshirɨ dœ pe a'a wa adœke, 'a kpa za egerœ gbarœ ga pa kumu 'e nene. Kashe œrœ á li dœ 'e kœmbœrœ tœnœ dœke: ");
INSERT INTO kxf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","adja 'e zɨzɨ agea á to ɓa pa ndaba nœ andjaba nene, 'e zɨzɨ indji nene, 'e zɨzɨ songba agea á tshe tshu á indji tutu nene, 'e mbœmbœrœ angbabudu nene. Œdœ 'e kœlɨsœ œrœnœ asœke kɔ, dá 'e mbœrœ dœ ɔtshɔnœ waa. 'E sœpe dœ ɔtshɔnœ.» ");
INSERT INTO kxf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Endje za awa fœ endje yé endje ro ga lœ Atiɔshe. Lɔkɔ kœwuta endje ɓa zœ, endje ngbɔɓa ayindœ Yisu, œ za mbetinœ fœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Manda kœdɨ mbetinœ, ayindœ Yisu sœ lima dœ yanga waa mbœrœ mbetinœ guma gbetshelœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda dœ Sila á endje dœ lima aayi kœgbara o'o, endje mɨ upu fœ endje adœke endje shi gbɨ yé œ gbɔndœ kœyindœrœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Endje mbœrœ lima olo teasho kpœtœmœ. Manda nœ, ayindœ Yisu za awa fœ endje adœke endje gu dœ kœsœ gee ga ndœ azu á endje vwa lima endje.  ");
INSERT INTO kxf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kashe Sila wa lima kœsœpe œnœ ye kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Polo œdœ Barnabase sœ lima œnœ endje ɓa lœ Atiɔshe. Ɓa zœ, endje sœ kœyisœ œrœ œdœ pe kœmɨndœ Ɔtshɔ O'o nœ Gbozu awa bale dœ anga azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Olo teasho manda nœ, Polo pa fœ Barnabase adœke: «A kwatœ azœ lakpɨ bale dœ bale á a yi lima sœ o'o ama Gbozu tœnœ dœ́ œ wu mara á aaya azœ sœ dœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabase yi lima ndœ kœkwa dœ Yowane á anga ɨ'ɨrɨ ye kœdœ Marke. ");
INSERT INTO kxf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kashe Polo gbe adœke kœkwa dœ she œ li nene, mbœrœ tshe ka lima tœ endje tɨ ɓa lœ Pafili, œ vwara lima tœ ye kœna dœ endje lœ ma akwa nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mbœrœ tœnœ ataa, endje djidji lima tœ endje nene, yé endje kurutshelœtœ endje. Barnabase za Marke po tœ ye, œ za egerœ agba œ ro ga lœ Shipre, ");
INSERT INTO kxf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kashe Polo ke Sila ndœ kœro dœ she. Manda nœ, ayindœ Yisu ko endje ga tshakane Ndjaba adœke ɔtshɔ lɔsu nœ Gbozu gbɔndœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Endje ro lima tɔ lœ Siri œdœ Silisi, œ yisœ œrœ fœ azu Ikrizia adœke endje gbɔndœ kœyindœrœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polo li ndje ga lœ Derbe dœ pe Listre. Ɓa zœ anga yindœ Yisu á ɨ'ɨrɨ ye kœdœ Timote, gbolo yakoshe nœ anga uyu Yuda á tshe yindœ Yisu, abanœ dœ́dœ́ Yuda nene. ");
INSERT INTO kxf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ɔtshɔ ye ga lima waa ugurutœ aayanœ lœ Listre dœ pe Ikoniyume. ");
INSERT INTO kxf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polo gbe lima kœgu dœ she awa bale. Kœwu adœke Ayuda lœ ndjoro tœ oshonœ ɓa zœ, tshe za she, œ wa she tœ gaza lindœ awa akwa nœ Ayudanœ, mbœrœ Ayuda kɔ á endje sœ lima dœ endje tœ œsœnœ wu lima sœ nœ adœke abanœ dœ́dœ́ Yuda nene. ");
INSERT INTO kxf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lœ ongbo á endje ro lima tœnœ, Polo dœ Sila sœ lima kœmɨndœ o'o á aayi avwa nœ Yisu dœ agbozu lœ Yerusaleme wa, á endje sœ kœpa fœ endje adœke endje mbœrœ tœ endje lindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Azu Ikrizia sœ lima kœru lɔsu endje lœ kœyindœrœ nœ endje, ɔlɔ dœ ɔlɔ anga azu sœ lima kœli ga ndœ endje yé endje te lima kœngba tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Polo œdœ Sila na lœ Friji œdœ pe lœ Galate; gbambanœ nene, Ɔtshɔ Ɨshirɨ pakata lima endje kœpandœ Ɔtshɔ O'o ɓa lœ Azi. ");
INSERT INTO kxf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kœwuta endje ga tœ ndɔngɔlɔ ogo Misi, endje gbe kœro ga lœ Bitini yeka á Ɨshirɨ nœ Yisu pakata endje. ");
INSERT INTO kxf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Endje ro tɔ lœ Misi yé œ jerœ ga lœ Trowase. ");
INSERT INTO kxf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Anga butshɔ bale, Polo kœwu œrœ lœ ulu: anga yakoshe Masedwane bale na ga ndœ ye, œ ka kœdɨ tshelœma ye fœ she adœke: «Fa djaga lœ Masedwane, mbœrœ kœtɨ kane 'a ga lafo!» ");
INSERT INTO kxf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Manda kœwu œrœ lœ ulu nœ Polo asœmœ, trale 'a para awa kœro ga lœ Masedwane, mbœrœ 'a wu lima sœ nœ adœke Ndjaba sœ kœ e 'a kœna kœpandœ Ɔtshɔ O'o ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","'A ɔ ga lœ egerœ agba lœ Trowase, 'a za awa ndjii ndœ Samotrase mbœrœ á osho kœkɔrɔ á 'a kœwuta ga lœ Neyapolise. ");
INSERT INTO kxf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yé ɓa zœ 'a na ga lœ Filipo, egerœ ongbo lœ ogo Masedwane, azu á endje sœ lœ nœ sœ tshakudu tshagbozu nœ ogo Roma. Œndœ 'a dɨ lima teasho lœ ongbonœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Dœ lɔkɔ sabata, 'a wuta lœ ongbonœ kœna ga lakpɨ ogo neke á sœ ndoo dœ ama ungu, tœnœ kœdœ lima œsœ osho nœ kœdonga Ndjaba, yeka á 'a sœ ga atɨ, á pa o'o dœ ayashe á endje ngbɔtœ endje kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Anga bale ugurutœ endje, ɨ'ɨrɨ ye kœdœ Lidi, œshe kœdœ lima yashe lœ ongbo Tiyatire á tshe sœ kœka odoro lœba yé á wu lima sœ kœdonga Ndjaba. Tshe dji 'a yé Ndjaba kɔrɔ gbetshelœ nœ ye adœke tshe yindœ o'o kɔ á Polo pa. ");
INSERT INTO kxf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Manda kœgbɔ batisimu, œshe dœ azu sœnda nœ ye para, tshe pa fœ 'a adœke: «Œdœ 'e kœwusœ nœ adœke, œmœ kœdœ uzu á mœ yindœ Ndjaba ye, 'e na œ lo ɓa ndœ mœ.» Yé tshe tovworogbo 'a kœyindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɔlɔ bale á 'a sœ lima kœna ndœ kœ e Ndjaba, anga yashe kanga bale á tshe sœ lima dœ ekpe ɨshirɨ nœ kœgbara o'o sœ ugurutœ 'a. Ayengɔ ye sœ lima kœgbɔ œrœ waa manda akwa nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tshe te manda 'a dœ Polo, yé œ sœ kœpa dœ ɔgbɔ adœke: «Ayakoshenœ asœ kœdœ aayi akwa nœ Ndjaba á tshe ropa œrœ kɔ; endje sœ kœyisœ awa kœgbɔ kœshe fœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yé tshe mbœrœ ataa manda olo ndjoro. Polo mɔ dœ she, á kœfatœ ye yé á kœpa fœ ɨshirɨnœ adœke: «Dœ ɨ'ɨrɨ Yisu Kristu, mœ pa fœ ɓœ adœke: wuta lœ yashe asœke!» Trale ɨshirɨ wuta lœ ye yé. ");
INSERT INTO kxf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɓata aayengɔ yashe kanga asœmœ wu adœke œne kpa gbɔ œrœ lœ awa nœ ye nene, endje tepa Polo œdœ Sila œ gbota endje na tœnœ fœ agbozu kœwa ngbanga œrrr ɓa la wutu ga utshu azu kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Endje ko endje na tœnœ fœ agbozunœ asœmœ yé œ pa adœke: «Ayakoshenœ asœ kœdœ Ayuda, endje ndɨ tshalakpɨ nœ azœ kpa ye. ");
INSERT INTO kxf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Endje sœ kœpara awa ndœ kœyisœ angbɨ mara kœsœ neke á azœ dœ́ azu Roma á lili adœke a mbœrœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yé œ ɨvwɨ azu kekeke ga tœ Polo œdœ Sila. Agbozu kœwa ngbanga kœza o'o adœke endje sɔ lœba tœ endje dœ́ œ ɓi endje dœ ndjapa. ");
INSERT INTO kxf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Manda kœɓi endje dœ ndjaba, endje ko endje va ga lœ kánga, yé œ pa fœ ayi kœgbɔndœ manda kánga adœke ala ye gbɔ dœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ayi kœgbɔndœ manda kánga dji ataa, œ ko endje li tœnœ waa ɓa ndœ kumu gbɔshɔ kánga yé œ soro ada endje dœ djingiri. ");
INSERT INTO kxf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dœ butshɔ, Polo œdœ Sila tetœ kœza avwala fœ Ndjaba dœ pe kœdonga she dœ itshi yé anga aayi kánga dji endje. ");
INSERT INTO kxf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kolœ ngbangi atake, ɔshɔ turu dœ ɔgbɔ, muru anda turu, Trale manda kɔrɔ wuu, yé tshelœ djingiri sɔ tœ aayi kánga para. ");
INSERT INTO kxf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ayi kœgbɔndœ manda kánga kœjo, œ kœwu adœke manda kánga kɔrɔ wuu á kœgbe adœke aayi kánga kpa para kɔkɔ ye. Tshe kœgbota ugu yakamba nœ ye á yindœ kœwotœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Á Polo kœra she dœ ɔgbɔ adœke: «Wowotœ zœ nene, 'a lœ para kɔkɔ zœ!» ");
INSERT INTO kxf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ayi kœgbɔndœ manda kánga kœ'e osho ndœ owo, kœgbɔgbɔtœ ye li tœnœ dœ awa, á kœgote ga tœ ada Polo dœ Sila. ");
INSERT INTO kxf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Manda nœ, tshe kœto Polo œdœ Sila wuta tœnœ ga shu, á kœpa fœ endje adœke: «Agbozu, œrœ gaɗe dá mœ kœmbœrœ yeka á kœshe a?» ");
INSERT INTO kxf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Polo œdœ Sila kœgi fœ she adœke: «Sœ dœ kœyindœrœ adœke Yisu kœdœ Gbozu yekane á tshe kœshe ɓœ awa bale dœ azu tshasœnda nœ zœ.» ");
INSERT INTO kxf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Endje kœpandœ o'o ama Gbozu fœ she, dœ azu kɔ á endje sœ lima sœnda nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kolœ dœ abutshɔnœ asœmœ, ayi kœgbɔndœ manda kánga na dœ endje na tœnœ œ djutɔ uku tœ endje yé pe kpœtœmœ tshe gbɔ batisimu awa bale dœ azu tshasœnda nœ ye kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tshe to Polo dœ Sila gu tœnœ ga sœnda nœ ye, œ to kœzɨrœ fœ endje, yé tshe sœ lima dœ yanga awa bale dœ azu tshasœnda nœ ye kɔ, mbœrœ endje yi lima ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Osho kɔrɔ pa nœ, agbozu kœwa ngbanga vwa aturugu fœ ayi kœgbɔndœ manda kánga adœke: «Tshe za awa fœ azu asœmœ!» ");
INSERT INTO kxf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Á tshe kœpa fœ Polo adœke: «Agbozu kœwa ngbanga vwa osho fœ mœ adœke mœ za awa fœ 'e. Ngɔngɔ asœke, 'e li kœwuta tœnœ, yé œ gu dœ kœsœ gee.» ");
INSERT INTO kxf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kashe Polo pa fœ aturugu adœke: «Endje yuyu lima 'a nene, œ ɓi 'a tœ ala azu kɔ, andaa a'a kœdœ adja azu Roma. Endje ko 'a va ga lœ kánga, yé endje yindœ kœko 'a ngɔngɔ asœ ga shu lœ ubunœ. Œ mbœrœtœ endje atamœ nene. Ɔtshɔ nœ kœdœ adœke endje na ga mœ dœ tœ endje œ ko 'a ga shu!» ");
INSERT INTO kxf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Aturugunœ gu œ pandœ nœ fœ agbozu kœwa ngbanganœ, yé awa za endje mbœrœ kœdji adœke endje kœdœ ndje azu Roma. ");
INSERT INTO kxf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Endje na kœkɨ fœ Polo dœ Sila adœke endje wu oyo œne. Manda nœ, endje za awa fœ endje kœwuta lœ kánga yé œ pa fœ endje adœke endje wuta lœ ongbo ye. ");
INSERT INTO kxf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Manda kœwuta endje lœ kánganœ, endje na ga lœ Lidi. Ɓa zœ, endje gbɔ ayindœ Yisu œ pa fœ endje adœke endje shi gbɨ lœ kœyindœrœ nœ endje, yé manda nœ endje ro da ye. ");
INSERT INTO kxf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Endje ro tɔ lœ Afipolisi dœ Apoloni yeka á wuta ga lœ Tesalonike, ɓa zœ Ayuda sœ lima dœ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ɓata á tshe mbœrœ ɓa lima katshatsha, Polo li ga lœ Sinagoganœ. Manda lɔkɔ sabata votɔ, tshe sœ lima kœpu o'o pa Buku nœ Ndjaba awa bale dœ azu á endje sœ kpœtœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tshe sœ lima kœyisœ nœ fœ endje ngbɨ adœke, œ li adœke Masiya wu oyo, œ tshu, œ she ugurutœ akuzu. Tshe pa fœ endje adœke: «Yisunœ á mœ mɨndœ ye fœ 'e asœke kœdœ Masiyanœ.» ");
INSERT INTO kxf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Anga Ayuda ugurutœ endje yindœ o'o á Polo pa, yé œ te ga ndœ Polo dœ Sila. Awa bale ndje dœ angbɨ azu Agrekenœ ndjoro á endje donga Ndjaba œdœ pe ndje ayashe ndjoro á azu sœ kœlɨsœ endje, te ga ndœ Polo dœ Sila. ");
INSERT INTO kxf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kashe anga Ayudanœ mbœrœ úkú. Endje rɔ anga ekpe azu á endje na tœ ala awa kpɔɔ, œ zɨ tshelœ o'o dœ endje yé œ ndɨ kœsœ gee lakpɨ ogo. Endje na ɓa sœnda nœ Jasone kœpara Polo dœ Sila á kœko endje wuta tœnœ ga utshu azu tshalakpɨnœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ɓata á endje gbɔgbɔ Polo dœ Sila nene, endje za Jasone awa bale dœ anga ayindœ Yisu, œ gbota endje gu tœnœ ga utshu aayi kœwa ngbanga tshalakpɨnœ asœmœ, yé œ pa adœke: «Azu á endje djingili tshelœ kumu azu pa ɔshɔ djigi, endje dá wuta ngɔngɔ asœ ɓa ke asœke. ");
INSERT INTO kxf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasone za osho kœsœ fœ endje ɓa sœnda nœ ye yé endje kɔ, endje mbœmbœrœ œrœ á awa akwa nœ gbozugo Roma yindœ nœ nene; endje pa adœke anga angbɨ gbozu kpi sœ zœ, yé ɨ'ɨrɨ ye kœdœ Yisu.» ");
INSERT INTO kxf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","O'o ama endje za ókó fœ azu para kɔkɔ, œ za ndje ókó fœ agbozu tshelœ ongbonœ, ");
INSERT INTO kxf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","yé endje dɨ lima ngendja fœ Jasone œdœ anga ayindœ Yisunœ yekane á endje za awa fœ endje adœke endje gu. ");
INSERT INTO kxf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pe dœ lɔkɔnœ asœmœ dœ abutshɔ, ayindœ Yisu gi Polo œdœ Sila ga tœ awa á endje ro ga lœ Bere. Endje wuta ɓa zœ yé œ na ga lœ Sinagoga nœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ayuda nœ Bere sœ lima dœ ɔtshɔ lɔsu kœropa endjeneke lœ Tesalonike, endje yindœ Ɔtshɔ O'o dœ lɔsu endje djigi, yé ɔlɔ dœ ɔlɔ, endje sœ lima kœdɨ Mbeti nœ Ndjaba, mbœrœ kœwu œdœ ádá o'onœ á Polo œdœ Sila pa asœmœ kœdœ adjapu. ");
INSERT INTO kxf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Anga azu ndjoro ugurutœ endje sœ dœ kœyindœrœ ga ndœ Yisu, yé ugurutœ azu Greke, ayashe ndjoro á azu œ lɨsœ endje dœ pe ayakoshe. ");
INSERT INTO kxf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kashe, ɔlɔ á Ayuda lœ Tesalonike dji adœke Polo sœ kpa kœmɨndœ Ɔtshɔ O'o lœ Bere, endje wuta ɓa zœ yé œ tetœ kœndɨ tshelœ gbetshelœ nœ azu ndjoro. ");
INSERT INTO kxf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yé pe kpœtœmœ, ayindœ Yisu gi Polo na tœnœ ga tœ ama egerœ ungu kashe Asila dœ Timote lœpe lima œnœ endje kpœtœmœ lœ Bere. ");
INSERT INTO kxf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Azu á endje za lima Polo kpatœnœ œrrr ɓa lœ Atene, endje gu dœ o'o adœke Sila dœ Timote ro katsha manda œne. ");
INSERT INTO kxf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ɔlɔ á Polo sœ lima kœkate Asila dœ Timote lœ Atene, tshe sœ dœ oyo tœ lɔsu ye mbœrœ kœwu adœke ongbonœ sœ lima dœ andjaba waa lœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tshe sœ lima kœpa o'o pa o'o ama Ndjaba dœ Ayuda œdœ angbɨ azu á endje sœ kœdonga Ndjaba lœ Sinagoga œdœ pe ndje azu neke á tshe li kœgbɔtœ ye dœ endje ɔlɔ dœ ɔlɔ ala wutunœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Anga azu kœwusœrœ á endje sœ kœyisœ gbetshelœ nœ Aepikure ndje dœ astoyise tetœ kœpa o'o dœ she. Anga endje sœ lima kœpa adœke: «O'o gaɗe dá kulupunœ asœ œ pa ata a?» Anga endje á endje dji she kœpa o'o tœ upu nœ Yisu œdœ pe tœ o'o kœshe nœ ye lœ kuzu pa adœke: «Œ sœ ɓata tshe kœdœ ayi kœyisœ o'o ama andjaba tshelœ anga angbɨ ogo.» ");
INSERT INTO kxf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yé endje za she, œ ro dœ she ga tœ osho kœwa ngbanga tœnœ á ɨ'ɨrɨnœ kœdœ Areopaje yé œ yu she adœke: «'A li kœwusœ tafo kœyisœrœ nœ zœ á ɓœ sœ kœyisœ nœ asœ nene a? ");
INSERT INTO kxf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Gbambanœ nene, asœ kɔ kœdœ tafo œrœ yé ɓœ sœ kœpa o'o á sœ kœko uvuru 'a lœnœ, yé 'a yindœ kœwusœ ádánœ.» ");
INSERT INTO kxf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mbœrœ azu kɔ lœ ogo Atene œdœ pe agene á endje sœ ɓa zœ, sœ ɔlɔ dœ ɔlɔ kolœ mbœrœ kœdji too mbœrœ kœpatœ œsœ tafo œrœnœ á wuta asœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yé Polo ka kpœguru Areopaje, œ pa adœke: «E'e dœ azu lœ Atene, mœ wu adœke e'e kœdœ azu á 'e sœ kœzatœ 'e waa ga tœ andjaba nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ɔlɔ á mœ sœ kœna lœ ongbo nœ 'e, mœ sœ kœwu œrœ á 'e gɨ á ko tɔ ɓata andjaba nœ 'e œdœ pe ndaba á 'e mbœrœ á su mbeti ga tœ nœ adœke: “Fœ anga ndjaba á 'a wuwusœ ye nene.” Andaa mœ na kœpandœ Ndjaba á 'e sœ kœdonga she, ataa 'e wuwusœ ye nene. ");
INSERT INTO kxf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ndjabanœ asœke kœdœ tsheneke á tshe mbœrœ tshapa ɔshɔ asœ dœ œrœ kɔ pa nœ, œshe kœdœ Gbozu nœ tshalafo dœ tsha atɨ. Tshe sœsœ lœ anda á azu mbœrœ dœ kane endje nene. ");
INSERT INTO kxf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tshe sœsœ dœ gbetshelœ adœke azu gbe dœ œne ɓata tshe sœ dœ ogo anga œrœ nene, kashe œshe dá sœ kœto soro fœ azu kɔ, dœ ɨzɨ á azu œ wu asœmœ œdœ pe udu œrœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","«Kœto tœ uzu bale, tshe mbœrœ azu kɔ adœke endje sœ pa ɔshɔnœ asœke. Kashe utshu kœmbœrœ endje, tshe dɨ olo kœsœ nœ endje yé œ wa mapaka ogo kɔ á li adœke endje sœ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ndjaba mbœrœ endje adœke endje para œne, œdœ endje kœsœ kœtaɓa osho na tœnœ, endje gbɔ œne á œne sœsœ lœ ɨngɨrɨnœ tœ azœ nene asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gbambanœ nene, “lœ awa nœ ye dá a sœ dœ soro, á sœ kœna ana, yé á sœpe dœ soro.”» «Mbœrœ tœnœ atamœ dá anga aayi kœsu itshi nœ 'e pa lima ndœ nœ adœke: “Azœ kœdœ ndje agbolo nœ ye.”» ");
INSERT INTO kxf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Ɓata azœ kœdœ agbolo nœ ye, a katœ kœgbe adœke Ndjaba li dœ œrœ á endje gɨ dœ ɔrœ, dœ kowo œdœ dœ badja á endje mbœrœ dœ kane liaka gbetshelœ nœ uzu. ");
INSERT INTO kxf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Utshunœ liya, Ndjaba djerœndœ nœ kɔ gbambanœ nene, azu wuwu lima sœ œrœ á endje sœ kœmbœrœ tœnœ nene. Kashe ngɔngɔ asœke, tshe pa fœ azu kɔ, tœ osho kɔ adœke endje fatshalɔsu endje. ");
INSERT INTO kxf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mbœrœ tœnœ ataa, tshe guma anga olo bale tœ kœwa ngbanga pa azu para dœ mara ndjii lœ awa nœ uzu á tshe ke she. Tshe she uzunœ asœmœ lœ akuzu mbœrœ kœma fœ azu adœke œne dá ke she.» ");
INSERT INTO kxf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kœdji adœke Polo pa o'o nœ kœshe lœ akuzu, anga endje tetœ ɔmɔ, yé anga endje pa fœ she adœke: «'A kpa dji ɓœ kœpa o'o asœ lœ anga olo.» ");
INSERT INTO kxf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ataa, Polo kœwuta lima ugurutœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kashe, anga endje na lima manda ye, yé œ te ayindœ Yisu. Azunœ dœke: Denise anga ayi kœwa ngbanga lœ Areopaje dœ anga yashe bale á ɨ'ɨrɨ ye kœdœ Damarise œdœ pe anga azunœ. ");
INSERT INTO kxf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Manda Atene, Polo ro ga lœ Koriti. ");
INSERT INTO kxf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tshe togba dœ anga uzu Yudanœ bale ɨ'ɨrɨ ye kœdœ Akila, endje zu she ɓa lœ ogo Pone. Tshe to lima kolœ olonœ asœmœ ɓa lœ Itali awa bale dœ awonœ dœ Prisile, mbœrœ gbozugo Klode za o'o adœke Ayuda para wuta lœ Roma. Polo sœ lima kœna ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Yé ɓata á endje sœ lima lœ akwa bale, ayi kœmbœrœ ɔkɔ agea dœ gbanda, tshe gu ndœ kœlo ɓa ndœ endje yé endje sœ liya kœmbœrœ akwanœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lɔkɔ sabata bale dœ bale, Polo sœ lima kœmɨndœ Ɔtshɔ O'o sœnda Sinagoga œdœ pe kœtetœ kœfa gbetshelœ nœ Ayuda dœ Agreke. ");
INSERT INTO kxf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lɔkɔ á Atimote dœ Sila yi lima kumu endje kœto lœ Masedwane, Polo zatœ ye tɨ djigi ndœ Ɔtshɔ O'o, tshe ma fœ Ayuda adœke Yisu kœdœ Masiya. ");
INSERT INTO kxf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kashe endje sœ lima kœshara she dœ kœgu she, Polo mea lœba ye, œ pa fœ endje adœke: «Indji 'e œ sœ pa kumu 'e dœ tœ 'e, mœ sœ yerœ lœ nœ, yé kœto kpesheke, mœ na ga ndœ angbɨ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Manda kœgitœ ye kpœtœmœ, tshe na ga ndœ anga uzu bale á ɨ'ɨrɨ ye kœdœ Titiuse Justuse, á tshe kœdœ uzu kœdonga Ndjaba nœ Ayuda yé anda nœ ye sœ lima ɨndɨrɨ Sinagoga. ");
INSERT INTO kxf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispuse, gbozu tshapa Sinagoganœ asœmœ, yi lima ndœ Gbozu, œshe dœ azu tshasœnda nœ ye para. Anga azu ndjoro lœ Koriti á endje sœ ndje lima kœdji Polo, yi ndje ndœ Yisu yé œ gbɔ batisimu. ");
INSERT INTO kxf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Anga butshɔ bale, Gbozu pa fœ Polo lœ ulu adœke: «Sœsœ dœ awa nene, sœsœ ndje koko nene, ");
INSERT INTO kxf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","gbambanœ nene, mœ sœ dœ ɓœ awa bale. Uzu bale œ li kœto kane ye ga tœ zœ á kœmbœrœ œrœ kanga fœ ɓœ nene, mbœrœ ɨlɨ azu á endje sœ lœ ongbonœ asœ kœdœ azu nœ mœ.» ");
INSERT INTO kxf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Polo lo lœ Koriti ungu bale dœ yapu mindu dœ bale, ndœ kœyisœ o'o ama Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lɔkɔ á Galiyo kœdœ lima gbozugo Akayi, Ayuda zɨ tshelœ o'o ndœ kœmbœrœ ekperœ tœ Polo, endje za she œ na dœ she ɓa tœ osho kœwa ngbanga. ");
INSERT INTO kxf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yé œ pa adœke: «Uzu asœ sœ kœdjingili tshelœ kumu azu dœ o'o adœke endje donga Ndjaba neke á awa akwa ogo nœ azœ wa adœke 'a dodonga she nene.» ");
INSERT INTO kxf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Polo kœyindœ kœpa o'o kane, Galiyo kœgi fœ Ayuda adœke: «Œ kœdœ má adœke uzu asœ mbœrœ ekperœ, too œ ta ɓango, mœ dji ma 'e ye. ");
INSERT INTO kxf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kashe ɓata œ sœ tœ upu nœ kœshara o'o ugurutœ ye tœ kœyisœrœ, dœ anga ɨ'ɨrɨ œdœ pe ndje awa o'o nœ 'e dœ tœ 'e, œ wu 'e. Mœ yiyindœ mara ngbanga atake nene.» ");
INSERT INTO kxf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yé á gɔrɔ endje tœ œsœ kœwa ngbanga ye. ");
INSERT INTO kxf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Endje para tepa Sosetene gbozu tshapa Sinagoga, œ ɓi she ɓa utshu osho kœwa ngbanga. Kashe Galiyo gbegbe lima dœ tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Œndœ Polo dɨ lima waa lœ Koriti, manda nœ á tshe katœ aayanœ lœ Yisu, á za awa kœro ga lœ Siri. Prisile dœpe Akila ro lima tœ awanœ dœ she. Ɓa tœ mangu nœ ongbo Sakre utshu kœli she ga lœ egerœ agba, tshe tshowa sukumu ye pa ye mbœrœ uvu á tshe za liya fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɔlɔ á endje wuta ga lœ Efeze, Polo katœ Akila dœ Prisile tɨ kpœtœmœ á na œnœ ye ga lœ Sinagoga ndœ kœpa o'o dœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓata endje kpœtœmœ sœ lima kœdɨ tshelœma endje adœke œndœ ye dɨ dœ œne kane, Polo vwaratœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kashe ndœ kœro lima she ga utshunœ, tshe pa o'o fœ endje adœke: «Mœ kwa bala tœmœ ga ndœ 'e, œdœ Ndjaba kœyindœ nœ.» Tshe kœɔ ga lœ egerœ agba la ungu lœ Efeze. ");
INSERT INTO kxf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kœjerœ ga lœ Sezaré, tshe ro ga lœ Yerusaleme mbœrœ kœbala azu tshelœ anda Ndjaba, manda nœ dœ kœro she ga lœ Atiɔshe. ");
INSERT INTO kxf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɓa zœ, olo ye ngbangba lima nene. Manda nœ, tshe kœkwa lakpɨ bale dœ bale lœ ogo Galate dœ Friji, tshe ka kœpa fœ ayindœ Yisu adœke endje shi gbɨ lœ kœyindœrœ nœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Anga uzu Yuda bale ɨ'ɨrɨ ye kœdœ Apolo, uzu lakpɨ Alekezandri lœ ogo Ezipito, na lima ga lœ Efeze. Œshe kœdœ uzu nœ kœwusœ kœpa o'o dœ ɔtshɔnœ, œ wu ndje sœ Buku nœ Ndjaba tœ ɔtshɔnœ waa. ");
INSERT INTO kxf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Endje yi lima sœ œrœ fœ she tœ upu nœ awa nœ Gbozu. Ɨshirɨ ye su dœ gbɔgbɔ, tshe mɨndœ o'o yé œ yisœ œrœ tœ pu nœ Yisu dœ ɔtshɔnœ waa. Kashe tshe wu lima kolœ œsœ batisimu á Yowane za lima fœ azu. ");
INSERT INTO kxf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tshe sœ lima kœpandœ Yisu dœ gbɔgbɔ kɔ lœ Sinagoga. Kashe manda kœdji she, Prisile œdœ Akila e she ɓa ndœ endje, yé œ kpa ma adja awa nœ Ndjaba fœ she. ");
INSERT INTO kxf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ɓata á tshe sœ lima dœ gbetshelœ nœ kœro ga lœ Akayi, ayanœ lœ Yisu sœ dœ yanga nœ agbe nœ ye, yé œ su mbeti fœ ayindœ Yisu ɓa zœ adœke endje za osho kœsœ fœ she. Manda kœwuta she ɓa zœ, tshe tɨ kane ayindœ Yisu ndjoro dœ ɔtshɔ lɔsu nœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Gbambanœ nene, tshe pa ngbɨ fœ Ayuda tœ ala azu adœke endje dji awa adja o'o, yé œ sœ lima kœma lœ awa nœ Buku nœ Ndjaba adœke Yisu kœdœ Masiya. ");
INSERT INTO kxf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɔlɔ á Apolo sœ lima ɓa lœ Koriti, Polo ro lima tɔ lœ kaga lœ aya Azi yeka á jerœ ga lœ Efeze. Ɓa zœ, tshe gbɔ lima anga ayindœ Yisu, ");
INSERT INTO kxf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","á yu endje adœke: «'E gbɔ lima Ɔtshɔ Ɨshirɨ ɔlɔ á 'e te ayindœ Yisu ye a?» Endje kœgi fœ she adœke: «'A djidji ndje anga nœ adœke Ɔtshɔ Ɨshirɨ sœ zœ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Polo kpa kœyu endje adœke: «Ka batisimu gaɗe dá 'e gbɔ a?» Endje kœgi fœ she adœke: «'A gbɔ batisimunœ á Yowane ayi kœza Batisimu yisœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Polo kœgi adœke: «Adjapu Yowane sœ lima kœza batisimu fœ azu á endje fatshalɔsu endje, yé tshe sœ lima kœpa fœ endje adœke endje yindœ uzu á tshe na manda œne, œ yindœ kœpa adœke Yisu.» ");
INSERT INTO kxf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Endje dji o'onœ asœmœ, yé œ gbɔ lima batisimu dœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polo kœto kane ye ga pa endje, yé endje kœgbɔ Ɔtshɔ Ɨshirɨ. Endje tetœ kœpa tafo o'o ama ogo dœ pe kœmɨndœ o'o á to ɓa ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Azu wuta lima kɔkɔ ga pa œrœ nœ́ ndjokpa dœ bisha. ");
INSERT INTO kxf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Polo sœ lima kœro ga lœ Sinagoga, yé lœ yapu votɔ, tshe sœ lima kœyisœ œrœ tœ upu nœ Ogo gbozu nœ Ndjaba dœ awa nene, yé œ pa o'o dœ mara adœke endje á endje dji she, yindœ o'o á tshe sœ kœpa tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kashe anga azu sœ lima dœ gbɔkumu, œ vwaratœ endje tœ kœyindœ nœ yé œ sœ kœmɔ awa nœ Gbozu kpœtœ ala angbɔtœ. Polo katœ endje tɨ œ ko ayindœ Yisu potœ ye, yé œ tetœ kœyisœ œrœ fœ endje ɔlɔ dœ ɔlɔ ɓa lœ anda lakɔrɔ nœ Tiranuse. ");
INSERT INTO kxf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tshe mbœrœ lima ataa manda ungu bisha yeka á azu kɔ á endje sœ lœ ogo Azi, œdœ Ayuda œdœ Agreke, endje dji lima o'o nœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ndjaba sœ lima kœmbœrœ ogboro œrœ lœ awa nœ Polo. ");
INSERT INTO kxf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mbœrœ tœnœ ataa, anga azu sœ lima kœgu dœ siriki á goro ɔkɔ Polo fœ aayi koɓa. Koɓa nœ endje ka lima tœ endje yé ekpe ɨshirɨ gi lima tœ ye pa azu. ");
INSERT INTO kxf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Anga Ayuda á endje sœ lima kœro dje tœ osho kɔ kœgɔrɔ ekpe ɨshirɨ pa azu koɓa asœmœ yamba lima kœgɔrɔ ekpe ɨshirɨ dœ ɨ'ɨrɨ Gbozu. Endje pa lima adœke: «Mœ pa fœ 'e adœke dœ ɨ'ɨrɨ Gbozu Yisu á Polo œ yisœ œrœ tœ upu nœ ye asœmœ, 'e wuta ye!» ");
INSERT INTO kxf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Azu á endje le lima œrœ nœ asœmœ kœdœ agbolo yakoshe mindu dœ bisha (7) nœ anga gbozu nganga Ndjaba nœ Ayuda á ɨ'ɨrɨ ye kœdœ Seva. ");
INSERT INTO kxf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kashe ɔlɔ bale, ekpe ɨshirɨ gi lima fœ endje adœke: «Yisu a? Mœ wusœ ye, yé mœ wu ndje sœ Polo. Kashe e'e a, 'e kœdœ aɗe e?» ");
INSERT INTO kxf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yé yakoshe á tshe sœ dœ ekpe ɨshirɨnœ pa ye kœi ga ugurutœ endje dœ gbɔgbɔ kɔ, œ kœtetœ kœɓi lima endje, œ suru tshelœ lœba, dœ pe kœtu uku tœ endje, á endje tɔ lima sœnda dœ ɔrɔ á kpa ye. ");
INSERT INTO kxf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Azu para lœ Efeze, Ayuda dœ pe angbɨ azu dji lima o'onœ asœmœ, yé awa za endje yeka á endje lɨ lima œsœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Azu ndjoro á endje yi lima ndœ Yisu, tetœ kœna tœnœ mbœrœ kœpandœ ekperœ á endje mbœrœ lima dœ tshama endje ga lafo. ");
INSERT INTO kxf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Anga endje ndjoro á endje sœ lima kœfa œrœ tsharawo, ko œrœ nœ endje para ga shu, yé á endje sho lima ukpulunœ tœ ala azu para. Endje dɨ lima œrœnœ kɔ mbœrœ kœwusœ amanœ, œ wu lima adœke mbetinœ kɔ á endje sho li dœ Langere ngendja kutu zazu bisha dœ ndjokpa (250.000). ");
INSERT INTO kxf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mbœrœ tœnœ ataa, Ɔtshɔ O'o za lima osho, azu ndjoro yi lima ndœ nœ lœ awa nœ gbɔgbɔ nœ Gbozu. ");
INSERT INTO kxf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Manda o'onœ asœmœ, Polo wa o'o lœ awa nœ Ɨshirɨ kœro ga lœ Yerusaleme yé tshe vwanga tɔ lœ Masedwane dœ pe Akayi. Tshe pa ndje adœke: «Ɔlɔ á mœ kœwuta ɓa zœ, œ li ndje adœke mœ kpa ro ndje ga lœ Roma.» ");
INSERT INTO kxf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tshe vwa anga anganœ bisha, Atimote dœ Eraste ga lœ Masedwane, yé œ sœpe damba œnœ ye lima kœlo lœ Azi. ");
INSERT INTO kxf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kolœ dœ lɔndɔnœ asœmœ dá egerœ djingili wuta lima tœ upu nœ awa nœ Gbozu ɓa lœ Efeze. ");
INSERT INTO kxf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Anga ayi kœfatshelœ ɔrœ, á ɨ'ɨrɨ ye kœdœ Demetriyuse, sœ lima kœmbœrœ a 'eara anda tepelo nœ Artemise dœ kœwo, yé œ sœ lima kœte ngendja fœ endje waa. ");
INSERT INTO kxf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tshe ngbɔɓa lima aayi kœfatshelœ ɔrœ dœ pe anga aayi akwa kɔ á endje sœ lima kœmbœrœ mara akwanœ asœmœ, á pa fœ endje adœke: «'E wusœ nœ ye anga mœ; a kœsœ dœ ɔtshɔnœ, œ to kolœ manda akwa nœ azœ asœ. ");
INSERT INTO kxf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yé 'e sœ kœwu tœnœ too 'e sœ kœdji azu kœpa adœke: Polonœ asœmœ sœ kœmɨndœ nœ adœke andjaba á azu mbœrœ endje dœ kane endje dœ́dœ́ ɔtshɔ andjaba nene. Azu ndjoro dji o'onœ yé œ fa lɔsu endje ndœ nœ. Tshe mbœmbœrœ kolœ ɓa lœ Efeze nene, kashe dje ndje lœ Azi para. ");
INSERT INTO kxf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Œ dœ́dœ́ kolœ azœ dá o'onœ asœ œ ndɨ akwa nœ azœ nene, kashe œ ndɨ ndje anda Tepelo nœ egerœ ndjaba yashe Artemise. Azu œ wu andanœ gbambanœ yé endje kpa lɨsœ nœ nene. Mbœrœ Azi dœ pe ogo djigi sœ lima kœdonga ndjabanœ asœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Manda kœpa o'onœ asœmœ ataa, azu kɔ á endje dji djerœ ókó, œ sœ kœta rawa adœke: «Artemise, egerœ ndjaba yashe lœ ongbo Efeze!» ");
INSERT INTO kxf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Azu tshelœ ongbonœ djigi oma dœ o'o kekeke. Endje ko anga Polo á endje na tœ awa akwanœ bale dœ she, Agayuse dœ pe Aristarke azu Masedwane, na tœnœ ga la wutu mɔlɔ. ");
INSERT INTO kxf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polo yi lima ndœ kœwuta ga utshu azunœ ga zœ, kashe ayambarœ pakata she yé. ");
INSERT INTO kxf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Anga aayi akwa nœ lita á endje dœ lima anga Polo mɨ lima upu fœ she adœke, tshe kpa nana ga la wutu mɔlɔnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Dœ lɔndɔnœ asœmœ, uzu dœ uzu sœ lima kœta rawa nœ ye dœ o'o nœ ye kpikpikpi, yé azu ndjoro ugurutœ endje kpa wuwusœ ádá á endje ngbɔtœ endje ndœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Anga azu lœ ukpulu azunœ mɨndœ upunœ fœ anga uzu bale á ɨ'ɨrɨ ye kœdœ Alekezandre á Ayuda gavwa she ɓa utshu endje. Á tshe yi kane ye ga lafo ndœ kœyu o'o. ");
INSERT INTO kxf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kashe ɔlɔ á ndje wusœ nœ adœke œshe kœdœ uzu Yuda, endje kpa ta rawa manda ada ɔlɔ bisha adœke: «A donga Artemise lœ Efeze!» ");
INSERT INTO kxf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Manda nœ, anga gbozu tshelœ ongbonœ u endje ga tœnœ yé á pa adœke: «Azu Efeze, uzu ɗe dá wuwusœ nœ adœke ongbo Efeze sœ dœ anda tepelo nœ Artemise œdœ pe œrœ á endje gɨ á to ɓa lafo á te nene a? ");
INSERT INTO kxf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Uzu bale œ shara o'onœ asœ nene, œ li adœke a sœ koko, yé a katœ kœmbœrœ œrœ á ádánœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Azu á 'e to endje na tœnœ ga mœ asœ gugu œsœ ndjaba nœ azœ nene, endje zɨzɨ ndje angba nene. ");
INSERT INTO kxf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Œ kœsœ adœke Demetriyuse dœ pe azu akwa nœ ye asœ sœ dœ o'o dœ uzu, uzunœ na œ tɔ meza pa ye, ayi kœwa o'o sœ zœ dœ pe olo ngbanga sœ ndje zœ. ");
INSERT INTO kxf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yé anga o'o kœsœ ndje zœ, osho á azu œ ngbɔtœ endje ga tœnœ kœguma o'o, œ wa o'onœ zœ. ");
INSERT INTO kxf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A gbɔ o'o tœ œrœ á a ngbɔtœ azœ ga tœnœ kpesheke á mbœrœ asœ. Azu œ e azœ tœ aayi kœoma dœ o'o. Gbambanœ nene, anga uzu kœtɔ meza pa azœ, o'o nœ kœpa tœnœ œ gu nene.» Manda o'onœ asœ, tshe pa fœ azu adœke endje gu ga mangba endje. ");
INSERT INTO kxf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɔlɔ á djingili o'onœ ka ye, Polo ngbɔɓa ayambarœ ga tœnœ œ mɨ upu fœ endje, œ bala endje dœ kœza awa ga lœ Masedwane. ");
INSERT INTO kxf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kœro she tɔ lœ ogonœ asœmœ, tshe mɨ lima upu waa fœ ayanœ lœ Yisu, manda nœ á wuta ga lœ Grese. ");
INSERT INTO kxf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tshe mbœrœ lima yapu votɔ ɓa zœ. Ɔlɔ á tshe yi lima ndœ kœɔ ga lœ egerœ agba kœro ga lœ Siri, ɓata Ayuda sœ lima kœvwarandœ ye á tshe dji, á kpa kwa dja ga lœ Masedwane. ");
INSERT INTO kxf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Anganœ lœ ana kœdœ lima: Sapatrose gbolo yakoshe nœ Piruse uzu Bere, Aristarke dœ pe Sekunduse azu Tesalonike, Gayushi uzu Derbe, Timote, Tishike dœ pe Trofime azu ogo Azi. ");
INSERT INTO kxf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kœwuta ga lœ ogo Masedwane, endje ro lima œnœ endje utshunœ kœkate 'a ɓa lœ Trowase. ");
INSERT INTO kxf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yé a'a nœ 'a, manda angbo nœ mapa á susuku nene, á ɔ ga lœ egerœ agba tœ mangu Filipo œ mbœrœ olo mindu, á togba dœ endje lœ Trowase á mbœrœ pɔsɔ bale dœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dœ ɔlɔ yenga dœ akɨdala, 'a ngbɔ lima tœ 'a ga tœnœ ndœ kœkurutshelœ mapa, Polo sœ kœmɨndœ 'o ama Ndjaba fœ aayanœ lœ Yisu œrrr ga tœ tshaguru butshɔ mbœrœ œ li lima adœke osho kœkɔrɔ tshe ro. ");
INSERT INTO kxf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Miinda sœ lima zœ lœ gbɔshɔ ɓa lafo á angbɔtœ 'a ga lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Anga djagbala yakoshe á ɨ'ɨrɨ ye kœdœ Etike, tshe sœ lima ga tœ ape ɨzɨ, olo za she kpakpakpa, ɓata Polo kaka lima damba tœ o'onœ nene, lœ olo, tshe djɔ œ te kœto ɓa tœ votɔ gbɔshɔ ɓa lafo œrrr ɓa atɨ. Kœyindœ kœti she ga lafo atake tshe tshu lima ye. ");
INSERT INTO kxf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Polo jerœ ga atɨ, á na katsha ga ndœ ye á za she ga lakoro ye á pa adœke: «Awa zaza 'e nene, tshe sœpe dœ soro!» ");
INSERT INTO kxf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kpa kœɔ she ga lafo ga zœ, Polo kurutshelœ mapa tœ endje yé endje zɨ, manda nœ tshe pa 'o œrrr o 'ara yeka á ro. ");
INSERT INTO kxf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Gbolo yakoshe asœmœ she ye, endje gu dœ she ga ndœ endje, yé lɔsu azu para kɔkɔ zɨ tɨɨ. ");
INSERT INTO kxf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","'A afo utshunœ, œ li ga lœ egerœ agba ndœ kœro ga lœ Asose. 'A yindœ kœza Polo ga ndœ 'a mbœrœ tshe yi lima ndœ kœro ga zœ dœ ada ye. ");
INSERT INTO kxf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɔlɔ á tshe gbɔ 'a ɓa lœ Asose, 'a za she ga ndœ 'a ga lœ egerœ agba mbœrœ kœro ga lœ Mitilene. ");
INSERT INTO kxf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Osho kɔrɔ panœ, 'a to kpœtœmœ 'a na ndoo dœ tshiki Kio. Manda olo bale 'a wuta ga tœ tshiki Samose, tœ bisha olo yeka á 'a wuta ga lœ Mile. ");
INSERT INTO kxf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polo wa lima adœke œne ka lœ Efeze nene, mbœrœ olo œ ro tœ œne lœ ogo Azi waa. Ogo nœ ye kœdœ lima kœwuta katsha ga lœ Yerusaleme lɔkɔ Patekɔte. ");
INSERT INTO kxf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ɓa lœ Mile, Polo vwa osho ndœ agbozu Ikrizia lœ Efeze. ");
INSERT INTO kxf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɔlɔ á endje wuta ga ndœ ye, tshe pa fœ endje adœke: «'E wusœ ɔtshɔ mœ ugurutœ 'e, kœto tœ ali olo mœ á mœ na ga ndœ 'e lœ ogo Azi. ");
INSERT INTO kxf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mœ zaza tœmœ lœ ama akwa nœ Gbozu nene, mœ mbœrœ akwa dœ ngola lœ ala mœ, mœ wu oyo waa mbœrœ Ayuda sœ lima kœvwarandœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mœ zaza anga œrœ á li kœtɨ kane 'e yiwatœ nœ tœ 'e nene, mœ mɨndœ Yisu fœ 'e, mœ yisœ œrœ fœ 'e lœ ukpulu azu too ɓa sœnda nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","O'o mœ sœ lima kœ'e Ayuda dœ Agreke adœke endje fa lɔsu endje fœ Ndjaba dœ pe kœyindœ Gbozu nœ azœ dœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ngɔngɔ asœ, Ɨshirɨ sœ kœvwa mœ ga lœ Yerusaleme, mœ wuwusœ neke á wuta ga tœ mœ ɓa zœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kashe œneke á mœ wusœ nœ kœdœ lœ ongbo kɔ á mœ ro lœ nœ, Ɔtshɔ Ɨshirɨ sœ kœma fœ mœ adœke, kánga dœ pe œrœ oyo kɔ sœ kœkate mœ. ");
INSERT INTO kxf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kashe mœ wu adœke soro mœ sœ ɓata œrœ gbambanœ, ogo nœ mœ kœdœ mœ na œrrr ga tœ ndɔngɔlɔ akwa nœ mœ, yé ga tœ kœka akwa á Gbozu Yisu za fœ mœ adœke: mœ mɨndœ Ɔtshɔ O'o nœ ɔtshɔ lɔsu nœ Ndjaba ga ndœ azu. ");
INSERT INTO kxf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ngɔngɔ nœ asœ, mœ wusœ nœ adœke 'e kpa wu mœ nene, e'e má mœ sœ lima ugurutœ 'e mbœrœ kœpandœ Ogo gbozu nœ Ndjaba fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mbœrœ tœnœ ataa á mœ sœ kœpandœ nœ fœ 'e kɔ kpesheke adœke: indji 'e œ tu ga lœ kumu mœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Gbambanœ nene, mœ zaza anga o'onœ yiwa tœnœ tœ 'e nene, mœ pandœ awa akwa nœ Ndjaba para fœ 'e ye. ");
INSERT INTO kxf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","'E gbɔndœtœ 'e dœ tœ 'e, yé œ gbɔndœ azu á Ɔtshɔ Ɨshirɨ ko 'e tœ aayi kœgbɔndœ endje. 'E gbɔndœ Ikrizia nœ Ndjaba ɓata aayi kœgbɔndœ apata. 'E gbɔndœ nœ mbœrœ Ndjaba dá yɔ dœ indji Gbolo nœ ye dœ tœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mœ wusœ nœ adœke aekpe azu œ na manda mœ, endje sœ ɓata amuru, endje wu oyo apatanœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ugurutœ 'e ndje, anga anga 'e œ tetœ kœpa wala mbœrœ kœgbota ayindœ Yisu ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ataa, ala 'e gbɔ, adja œndœ tœ 'e roro 'e nene. 'E gbe dœ ungu votɔ butshɔ dœ ɔlɔ dœ ngola lœ la mœ, mœ sœ lima kolœ kœna manda uzu dœ uzu ndœ kœgi she ga ugurutœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Yé ngɔngɔ asœ, mœ sœ kœko 'e ga tshakane Ndjaba, Ɔtshɔ O'o nœ ɔtshɔ lɔsu nœ ye gbɔndœ 'e, œ li kœza gbɔgbɔ fœ 'e ndje dœ kœko œrœ kɔ á tshe guma mbœrœ azu á tshe ke endje fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mœ sœsœ lima dœ ogo œrœ nœ uzu bale nene, œdœ ngendja, ɔrœ too lœba. ");
INSERT INTO kxf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","'E wusœ nœ dœ tœ 'e adœke mœ mbœrœ lima akwa dœ kane mœ dœ tœ mœ yé á gbɔ œrœ á li dœ mœ dœ pe anga mœ á mœ na tœ awanœ bale dœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mbœrœ tœnœ ataa, mœ sœ lima kœma fœ 'e adœke, 'e mbœrœ akwa yeka á kœto œrœ fœ endjeneke á endje mɔmɔ ugurutœ 'e, 'e gbe dœ o'o á Gbozu Yisu pa dœ tœ ye lima adœke: “Yanga nœ kœto œrœ fœ azu ropa œnœ kœgbɔ tœnœ ye.”» ");
INSERT INTO kxf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Manda o'onœ, Polo gote ga atɨ dœ endje para ndœ kœ e Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Endje para endje tetœ ɨkɨ ye, œ yo ga dagɨ Polo ndœ kœ'uru tshelœ utu ye. ");
INSERT INTO kxf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Endje sœ lima dœ oyo mbœrœ Polo pa fœ endje adœke, œne kpa wutœ œne dœ endje nene. Manda nœ á endje gi she na tœnœ œrrr ga lœ egerœ agba. ");
INSERT INTO kxf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Manda kœkurutshelœtœ 'a dœ endje, 'a li ga lœ egerœ agba, 'a ro ga lœ tshiki Kose, osho kɔrɔ panœ 'a wuta ga lœ Rode, kœto kpœtœmœ dá 'a ro ga lœ Patara. ");
INSERT INTO kxf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kpœtœmœ, 'a gbɔ anga egerœ agba á sœ kœro ga lœ Fenisi, yeka 'a ɔ ga lœ nœ á ro. ");
INSERT INTO kxf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kœndo dœ Shipre, 'a katœ tshikinœ ga pa gele 'a, 'a za awa Siri, 'a jerœ ɓa lœ Tire ɓa tœ osho á endje yi lima ndœ kœko œrœ lœ egerœ agba ga shu. ");
INSERT INTO kxf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","'A mbœrœ lima pɔsɔ bale kpœtœmœ mbœrœ 'a gbɔ ayindœ Yisu. Lœ awa nœ Ɨshirɨ, endje pa fœ Polo adœke tshe nana ga lœ Yerusaleme nene. ");
INSERT INTO kxf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kashe ɔlɔ á olo 'a ka, endje na kœkatœ 'a ga tœ awa dœ awo endje dœ pe agbolo nœ endje. Yeka á 'a gote ɓa tœ mangu yé á za avwala. ");
INSERT INTO kxf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Manda kœbala ndangba tœ 'a dœ endje, 'a ɔ ga lœ egerœ agba yeka á endje gu ga ndœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kœto lœ Tire, 'a ro œrrr ga lœ Petolemayise, 'a mbœrœ kpœtœmœ olo bale ndœ kœbalatœ 'a dœ aaya 'a lœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Osho kɔrɔ panœ, 'a ro ga lœ Sezaré, ɓa zœ 'a ro ga ndœ ayi kœyisœ Ɔtshɔ O'o á ɨ'ɨrɨ ye kœdœ Filipo, 'a lo ɓa ndœ ye. Œshe kœdœ anga aayi kœtɨ kane aayi avwa á 'a ke lima endje mindu dœ bisha (7) lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tshe sœ dœ ayawuru vana á endje sœpe dœ akpɔnœ, á sœ kœgbara o'o á to ɓa ndœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yé 'a mbœrœ olo ndjoro lima kpœtœmœ, anga ayi kœgbara o'o to lœ Yuda œ na, ɨ'ɨrɨ ye kœdœ Agabuse. ");
INSERT INTO kxf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kœgbɔ 'a, tshe za uwu tshapa lœba nœ Polo á i dœ ada ye dœ pe kane ye, á pa adœke: «Ɔtshɔ Ɨshirɨ pa adœke mara á Ayuda œ i bala dœ ayengɔ uwu tshapa lœbanœ asœ ɓa lœ Yerusaleme á za she fœ anga angbɨ azu dœmœ.» ");
INSERT INTO kxf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Manda kœdji o'onœ asœ, a'a dœ pe aaya lœ Yisu lœ ongbonœ, dɨ tshelœma 'a fœ Polo adœke, tshe nana ga lœ Yerusaleme nene. ");
INSERT INTO kxf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kashe Polo gi adœke: «Mbœrœ gaɗe dá 'e sœ kœkɨ tœnœ á sœ kœyi awa ga lɔsu mœ a? Mœ guma tœ mœ ndje adœke, endje za mœ ga lœ kánga dœ pe kœwo mœ ɓa lœ Yerusaleme mangba ɨ'ɨrɨ Gbozu Yisu ye.» ");
INSERT INTO kxf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ɓata á tshe yiyindœ o'o nœ 'a lima nene, 'a katœ kœshosho she yé á pa adœke: «Kaka adœke Gbozu mbœrœ lindœ gbetshelœ nœ ye.» ");
INSERT INTO kxf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Manda olo teasho, 'a guma tœ 'a ndœ kœro ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Anga ayindœ Yisu lœ Sezaré á 'a ro tœ awanœ dœ endje lima, endje gbɔ osho kœlo tœnœ fœ 'a ɓa ndœ anga uzu bale lœ Shipre, ɨ'ɨrɨ ye kœdœ Manasone, œshe kœdœ anga yindœ Yisu ɓalima katshatsha. ");
INSERT INTO kxf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ɔlɔ á 'a wuta ga lœ Yerusaleme, alaya lœ Yisu uru tshelœ utu 'a dœ yanga. ");
INSERT INTO kxf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Osho kɔrɔ panœ, 'a ro tœ awanœ bale dœ Polo ga ndœ Jake, osho á agbozu kuma akwa kɔ lœ Ikrizia œ ngbɔtœ endje ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Manda kœbala endje, Polo pandœ œrœ kɔ á Ndjaba mbœrœ lima dœ she awa bale lœma akwa nœ ye ugurutœ angbɨ azu. ");
INSERT INTO kxf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Endje dji Polo, yé œ donga Ndjaba. Á pa fœ she adœke: «Ɓœ wu, aya, Ayuda andjoro yindœ Yisu, endje kɔ sœ kœpara awa kœmbœrœtœ endje liaka awa akwa á Ndjaba za fœ Moyize dœ lɔsu endje bale. ");
INSERT INTO kxf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kashe endje dji adœke, ɓœ yisœ œrœ fœ Ayuda para á endje sœ lœ oporotœ angbɨ azu adœke, endje katœ awa akwa nœ Moyize yé œ ka ndje tœ kœwa agbolo nœ endje tœ gaza dœ pe kœmbœrœ œrœ mara ogo nœ azœ. ");
INSERT INTO kxf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","A mbœrœ kotoo? Mbœrœ endje dji ndœ zœ adœke ɓœ sœ kpœke zœ. ");
INSERT INTO kxf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mbœrœtœ zœ lindœ neke á 'a pa fœ ɓœ asœke. 'A sœ dœ anga azu vana á endje dra ama endje fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ko endje potœ zœ dœ́ 'e na œ mbœrœ adœke ɔkɔ 'e sœ yerœ, gi œrœ tokóró tshangba endje. Endje li ndje kœwa sukumu endje yé azu para œ gbe adœke o'o á kɨ dœ ɨ'ɨrɨ zœ kœdœ wala. Kashe œ li ndje adœke ɓœ mbœrœtœ zœ liaka awa akwa. ");
INSERT INTO kxf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yé mbœrœ angbɨ azu á endje te ayindœ Yisu, 'a su mbeti dœ o'o á 'a wa adœke: endje zɨzɨ œrœ á endje to dœ okoro fœ andjaba nene, indji, dœ agea á indji ye tutu ga atɨ nene, yé endje mbœmbœrœ angba budu nene.» ");
INSERT INTO kxf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Osho kɔrɔ panœ, Polo ko ayakoshe asœmœ yé œ mbœrœ adœke ɔkɔ œne sœ yerœ awa bale dœ endje. Endje na dœ endje ga lœ Tepelo mbœrœ kœpandœ kœka olo nœ kœmbœrœ adœke ɔkɔ œne sœ yerœ, yekane á uzu dœ uzu kœzo agea tokórónœ ga utshu Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Œ sœpe lima teasho adœke olo mindu dœ bisha nœ kœmbœrœ adœke ɔkɔ azu sœ yerœ ka, yeka Ayuda lœ ogo Azi wu Polo lœ Tepelo. Endje bɨlɨ azu ndjoro ndœ ye yé á za she. ");
INSERT INTO kxf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Endje sœ lima kœta rawa adœke: «Azu Israyele, 'e na ga mœ œ tɨ kane 'a ga lafo! Uzunœ á tshe sœ kœyisœ œrœ fatœnœ djezœ, á tshe sœ kœndɨ tshelœ kœlɨsœtœ ogo Israyele, á yiyindœ awa akwa nœ Moyize nene, á tshe ko angbɨ azu ga lœ Tepelo, á ndɨ œyerœ osho dœke.» ");
INSERT INTO kxf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mbœrœ endje wu lima Trofime uzu Efeze dœ she ɓa lœ ongbo á gbe adœke Polo li dœ she ga lœ Tepelo. ");
INSERT INTO kxf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tshelœ ongbo djigi turu dœ o'onœ, yé azu ndjoro na lima ye. Endje tepa Polo lœ Tepelo œ wuta dœ she ga shu, trale dœ kœtshu mandanœ ga tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ɓata á endje sœ lima ndœ kœpara awa kœwo she, o'onœ wuta lima ɓa ndœ gbozu tshapa aturugu nœ Roma lœ Yerusaleme adœke: «Ekpe o'o li ga lœ Yerusaleme ye!» ");
INSERT INTO kxf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Katsha, tshe ngbɔɓa aturugu dœ agbozu tshapa endje, á endje na ga tœ osho á o'o sœ tœnœ. Lɔkɔ á azu wu aturugu dœ gbozu tshapa endje yeka á katœ kœɓi Polo. ");
INSERT INTO kxf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yé gbozu tshapa aturugu na ndoo dœ she, á za 'o fœ endje adœke endje i Polo ga tœnœ dœ djingiri bisha. Manda nœ á tshe yu osho adœke œshe kœdœ ɗe yé œrœ gaɗe dá tshe mbœrœ a. ");
INSERT INTO kxf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kashe lœ ukpulu azu, uzu dœ uzu sœ kœta rawa dœ o'o nœ ye kpi, ɓata gbozu nœ aturugu sœ lima kœdji ádá o'onœ dœ ɔtshɔ nœ nene mbœrœ ukpulu azu, á wa adœke endje gu dœ Polo ga lœ pada nœ aturugu. ");
INSERT INTO kxf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lɔkɔ á endje wuta ga pa esekaliye, aturugu za Polo ga lafo mbœrœ azu sœ lima kœndanga endje waa. ");
INSERT INTO kxf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yé azu kɔ te manda endje dœ rawa adœke: «'E wo she!» ");
INSERT INTO kxf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ɔlɔ á endje yindœ kœli dœ she ga lœ padanœ, Polo pa fœ gbozu nœ aturugunœ adœke: «Ɓœ yindœ nœ adœke mœ pa o'o ye a?» Tshe gi fœ she adœke: «Ɓœ wu ndje sœ o'o ama Greke ye! ");
INSERT INTO kxf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Œ dœ́dœ́ ɓœ kœdœ uzu Ezipito á tshe za djingili lœ olo á ro kpœke ga ugurutœ azu, yé á bɨlɨ azu á kpa ndje dœ azu koshe kutu vana ga lœ kpagagasho nene a?» ");
INSERT INTO kxf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Polo gi fœ she adœke: «Œ̃œ̃ nene, œmœ kœdœ uzu Yuda, endje zu mœ lœ Tarse lœ ogo Silisi. Œmœ kœdœ gbolo ongbo á ɨ'ɨrɨnœ to waa. Wu oyo mœ, œ za awa fœ mœ, mœ pa o'o fœ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tshe za awa fœ she, Polo ka ga pa esekaliye, œ tɨ kane ye ga lafo ndœ kœma adœke azu katœ kœta rawa, azu wu œ sœ kokoko. Yé tshe tetœ kœpa 'o fœ endje dœ o'o ama ogo Ayuda á dœ Ebre adœke: ");
INSERT INTO kxf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Alaba dœ pe alaya, 'e dji o'o ngbanga nœ mœ á mœ yindœ kœgi ngɔngɔ asœke ga utshu 'e kane.» ");
INSERT INTO kxf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kœdji adœke Polo sœ kœpa 'o fœ endje dœ o'o ama Ebre, osho kpa yi taa, yé á tshe pa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Œmœ kœdœ uzu Yuda, endje zu mœ lœ Tarse lœ ogo Silisi, kashe mœ gerœ lœ ongbonœ asœ, mœ mbœrœ lakɔrɔ á sœ kœyisœ o'o á pandœ awa akwa nœ aata azœ tshakudu Gamaliyele, œmœ kœdœ lima uzu á mœ zatœ mœ waa fœ Ndjaba ɓata 'e para kɔkɔ á 'e sœ kœmbœrœ tœnœ kpesheke. ");
INSERT INTO kxf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mœ sœ ndje lima kœwo azu á ndje sœ kœza awa Gbozu, mœ ko ayakoshe dœ pe ayashe va ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Egerœ nganga Ndjaba dœ ukpulu agbozu tshapa azu o'o œ pa ndje ndœmanœ fœ 'e ye. Endje dá vwa lima mœ adœke mœ na œ katœ mbeti á sœ kœza awa fœ mœ kœro ndœ aaya mœ dœ Ayuda á endje sœ ɓa lœ Damaseke. Mœ na lima ga zœ ndœ kœko azunœ asœmœ, kœgu dœ endje ga lœ Yerusaleme mbœrœ á endje kœgbɔ djofele.» ");
INSERT INTO kxf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Mœ sœ lima lœ awa ana, yé lɔkɔ á mœ ndo dœ tshalakpɨ Damaseke, ngbangi dœ gbɔku ɔlɔ atake, ɨshirɨ owo to ɓa lafo œ za mœ djigi. ");
INSERT INTO kxf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mœ te ga atɨ, yé œ dji tshama uzu kœ'e mœ adœke: “Sawulo, Sawulo, mbœrœ gaɗe á ɓœ mbœrœ œrœ kanga fœ mœ ata a?” ");
INSERT INTO kxf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mœ gi adœke: “Œɓœ kœdœ œɗe, Gbozu?” Tshama uzu kpa pa adœke: “Œmœ kœdœ Yisu ɓa lœ Nazarete, œmœ dá ɓœ mbœrœ œrœ kanga fœ mœ asœmœ.” ");
INSERT INTO kxf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Anga mœ á 'a na lima dœ endje wu ɨshirɨ owonœ ye, kashe endje djidji lima o'onœ á uzunœ sœ kœpa tœnœ fœ mœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mœ yu adœke: “Œrœ gaɗe dá mœ kœmbœrœ a, Gbozu nœ mœ?” Yeka á Gbozu gi fœ mœ adœke: “Alafo œ na ga lœ Damaseke, yé ɓa zœ, endje yisœ akwa á li adœke ɓœ mbœrœ.” ");
INSERT INTO kxf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɓata ɨshirɨ owonœ bu lima ala mœ ye, anga mœ dá za kane mœ wuta tœnœ ga lœ Damaseke. ");
INSERT INTO kxf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Anga uzu lima bale ɓa zœ ɨ'ɨrɨ ye kœdœ Anania, œshe kœdœ uzu nœ ɔtshɔ lɔsu, tshe sœ kœgbɔndœ awa akwa nœ Moyize waa, yé Ayuda para á endje sœ lima kpœtœmœ sœ kœpa ɔtshɔ o'o nœ ye waa. ");
INSERT INTO kxf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tshe na œ gbɔ mœ œ pa fœ mœ adœke: “Sawulo, aya mœ, ala zœ kɔrɔ!” Trale ala mœ kɔrɔ yé mœ mesho œ wu she. ");
INSERT INTO kxf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yeka á tshe kœpa fœ mœ adœke: “Ndjaba nœ aata azœ ke ɓœ adœke ɓœ wusœ œrœ á tshe yindœ nœ, ɓœ wu uzu á tshe sœ ndjii yé ɓœ dji o'o nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mbœrœ ɓœ dœ́ bala timu nœ ye utshu azu para, tœ œrœ á ɓœ wu dœ pe neke á ɓœ dji. ");
INSERT INTO kxf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ɓœ sœ kœkate œrœ gaɗe? 'A ro ɓœ gbɔ batisimu dœ ɨ'ɨrɨ Yisu yé œ ta ɨ'ɨrɨ ye dœ́ ekperœ nœ zœ kœyiwa.” ");
INSERT INTO kxf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Mœ gu ga lœ Yerusaleme, yé anga ɔlɔ bale mœ sœ kœ'e Ndjaba ɓa lœ Tepelo, mœ wu œrœ lœ ulu. ");
INSERT INTO kxf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mœ wu lima Gbozu á tshe sœ kœpa fœ mœ adœke: “Katœ Yerusaleme ngɔngɔ asœ tɨ, mbœrœ azunœ œ yi bala ndœ o'o á ɓœ pa fœ endje dœ ɨ'ɨrɨ mœ nene.” ");
INSERT INTO kxf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mœ gi adœke: “Kashe Gbozu, endje wusœ nœ adœke mœ sœ lima kœna kœli ga lœ Sinagoga kœko azu á endje sœ dœ kœyindœrœ ga ndœ zœ, œ ɓi endje yé œ ko endje gu tœnœ ga lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɔlɔ á endje wo lima Etiene, timu nœ zœ, mœ sœ lima zœ; mœ yindœ nœ ga ndœ endje, yé œ gbɔndœ lœba nœ endje.” ");
INSERT INTO kxf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Yeka á Gbozu pa fœ mœ adœke: “Na zœ, mœ yindœ kœvwa ɓœ lœ ɨngɨrɨnœ, ɓa ndœ angbɨ azu.”» ");
INSERT INTO kxf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ayuda á endje sœ lima kpœtœmœ dji o'o nœ ataa, œ oma dœ Polo yé œ tetœ kœta rawa adœke: «'E wo mara uzu atake ye! Tshe lili kœsœpe dœ soro nene!» ");
INSERT INTO kxf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓata endje sœ lima kœta rawa, kœko lœba nœ endje va e dœ pe kœgɨ trusha ga lafo, ");
INSERT INTO kxf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","gbozu tshapa aturugu pa adœke endje za Polo li tœnœ ga lœ pada œ sɔ she, yeka á kœwusœ ádá rawanœ á endje ta pa ye asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Endje sœ kœi she dœ uwu ga tœnœ, Polo yu gbozu nœ aturugu adœke: «Œ li adœke endje ɓi gbolo ogo Roma utshu kœwa ngbanga nœ ye ye a?» ");
INSERT INTO kxf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Manda kœdji o'onœ ataa, gbozu nœ aturugunœ pandœ nœ fœ gbozu tshapa endje adœke: «Ɓœ mbœrœ kotoo! Mbœrœ uzu asœ kœdœ gbolo ogo Roma!» ");
INSERT INTO kxf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Gbozu tshapa aturugu kwatœ ye œ yu Polo adœke: «Pandœ nœ fœ mœ ka, adja ɓœ kœdœ gbolo ogo Roma a?» Polo yindœ nœ adœke: «Œ̃.» ");
INSERT INTO kxf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Gbozu tshapa aturugu kpa pa adœke: «Œmœ, mœ ko egerœ ngendja ndœ kœfa gbolo ogo Roma.» Polo pa adœke: «Œmœ, mœ kœdœ adja gbolo ogo Roma.» ");
INSERT INTO kxf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Trale, azu á endje sœ lima kœɓi she, gitœ endje ɨndɨrɨ ye yé. Awa za ndje lima gbozu tshapa aturugunœ mbœrœ kœwusœ nœ adœke œnœ i gbolo ogo Roma ga tœnœ dœ uwu. ");
INSERT INTO kxf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Osho kɔrɔ panœ, gbozu tshapa aturugu yindœ kœwusœ ádá á Ayuda sœ kœza o'o ga pa Polo. Tshe zu djingiri tœ ye, yé manda nœ á e angbɔtœ nœ agbozu tshapa anganga Ndjaba dœ pe aayi kœwa ngbanga para, á jerœ dœ Polo, á za she tɔ ga utshu endje. ");
INSERT INTO kxf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polo ko ala ye tɔ lœ la agboro aayi kœwa ngbanganœ, á pa fœ endje adœke: «Alaya, soro mœ sœ yerœ utshu Ndjaba œrrr ga tœ ngɔngɔ asœke yé lɔsu mœ sœ dœ kœsœ gee mbœrœ tœnœ.» ");
INSERT INTO kxf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kashe egerœ nganga Ndjaba á ɨ'ɨrɨ ye kœdœ Anania za o'o fœ azu á endje sœ ndoo dœ Polo adœke endje du ama ye. ");
INSERT INTO kxf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Yé Polo pa fœ she adœke: «Ndjaba œ ɓi ɓœ, ɓœ sœ ɓata imbi muru anda á kavwa! Ɓœ sœ ɓa zœ mbœrœ kœwa ngbanga pa mœ liaka œneke á awa akwa pandœ nœ, yé ɓœ kpa katœ awa akwa tɨ œ pa adœke endje da mœ a?» ");
INSERT INTO kxf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Azu á endje ka lima ndoo dœ Polo pa fœ she adœke: «Ɓœ gu egerœ nganga Ndjaba a?» ");
INSERT INTO kxf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Polo gi fœ endje adœke: «Alaya, mœ wuwusœ nœ nene adœke œshe kœdœ egerœ nganga Ndjaba. Gbambanœ nene, Buku nœ Ndjaba pa adœke: “Ɓœ pa ekpe o'o goro œsœ gbozu tshapa azu nœ zœ nene.”» ");
INSERT INTO kxf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Polo wu lima sœ nœ adœke anga aayi kœwa ngbanganœ kœdœ Asadukayi, yé anga endje kœdœ Afarisayi. Mbœrœ tœnœ, tshe pa o'o ga utshu endje adœke: «Aaya, œmœ kœdœ uzu Farisayi, aata mœ kœdœ Afarisayi. Endje yindœ kœwa ngbanga pa mœ mbœrœ á mœ za lɔsu mœ ga pa neke á pa adœke azu á endje tshu, endje she bala lœ akuzu ye.» ");
INSERT INTO kxf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Trale manda o'onœ á Polo pa ataa, a'ea wuta ugurutœ Afarisayi dœ pe Asadukayi, yé endje kurutshelœtœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gbambanœ nene, Asadukayi pa adœke azu á endje tshu endje she lœ akuzu nene yé aandjelu dœ pe ɨshirɨ azu gugu nene. Kashe Afarisayi yi œnœ endje ndœ o'onœ asœmœ kɔ. ");
INSERT INTO kxf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","O'o wuta lima ngbangbangba, yé anga aayi kœyisœ awa akwa á endje dœ Afarisayi áafo, œ vwaratœ endje dœ ɔgbɔ, œ pa adœke: «'A wuwusœ ekperœ bale á yakoshe asœ mbœrœ nene. Anganœ nene ɨshirɨ dá pa o'o fœ she a, too andjelu a?» ");
INSERT INTO kxf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ɓata o'onœ sœ lima kœgerœ tœnœ, kœkpa awa adœke endje súru tshelœ Polo nene, gbozu tshapa aturugu za o'o adœke aturugu jerœ œ za Polo ugurutœ endje dœ́ œ gi she ga lœ pada. ");
INSERT INTO kxf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dœ abutshɔ manda nœ, Gbozu wuta ga utshu Polo á pa fœ she adœke: «Ka ngbɨrɨ, ɓata á ɓœ pa djakata o'o tœ upu nœ mœ lœ Yerusaleme kpœke, awa bale œ li adœke ɓœ mbœrœ ndje ataa ɓa lœ Roma.» ");
INSERT INTO kxf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Osho kɔrɔ panœ pe dœ amazɨ, anga Ayuda ngbɔtœ endje ga tœnœ mbœrœ kœvwarandœ o'o. Endje dara ama endje adœke, œne zɨ œrœ nene, œ ndjo ndje œrœ nene œrrr adœke œne wo Polo yekane. ");
INSERT INTO kxf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Azu á endje dara lima ama endje sœ kœropa zazu bisha. ");
INSERT INTO kxf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Endje ro ga ndœ agbozu tshapa anganga Ndjaba œdœ pe agbɔ Ayudanœ œ pa adœke: «'A dara ama 'a dœ ɨ'ɨrɨ Ndjaba adœke, 'a kpa zɨ œrœ nene yé 'a ndjo ndje ungu nene œrrr adœke 'a wo Polo yekane. ");
INSERT INTO kxf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yé e'e dœ́ agboro aayi kœwa ngbanga kɔ, 'e vwa osho fœ gbozu tshapa aturugu adœke, endje za Polo na tœnœ mbœrœ 'e kpa tondœ o'o nœ ye kpœrœ kpœrœ kane. Kashe kolœ 'a, 'a gbe adœke 'a wo she utshunœ adœke tshe yi kumu ye kpœke.» ");
INSERT INTO kxf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kashe gbolo yakoshe nœ yingɔ Polo dji lengere o'onœ asœmœ, œ na ga lœ pada ndœ kœva Polo nea dœ o'onœ. ");
INSERT INTO kxf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Yé Polo kœ'e anga turugu á tshe kœdœ gbozu tshapa aturugu kama, á kœpa fœ she adœke: «Na dœ gbolo yakoshe asœ fœ gbozu tshapa 'e, tshe sœ dœ o'o kœpandœ nœ fœ she.» ");
INSERT INTO kxf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Turugunœ asœmœ kœna dœ gbolo yakoshenœ asœmœ fœ gbozu tshapa endje, œ kœpa fœ she adœke: «Ayi kánga Polo dá e mœ á pa adœke, mœ na dœ gbolo yakoshe asœ fœ ɓœ, mbœrœ tshe sœ dœ o'o kœpa fœ ɓœ.» ");
INSERT INTO kxf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Gbozu tshapa aturugu kœza ama kane ye, kœgitœ ye dœ she ga ɨndɨrɨnœ, kœyu she adœke: «O'o gaɗe dá ɓœ yindœ kœpandœ nœ fœ mœ a?» ");
INSERT INTO kxf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Gbolo yakoshenœ kœgi fœ she adœke: «Ayuda zɨ tshelœ o'o ndœ kœfara ɓœ adœke, ɓœ za Polo na tœnœ ɓa mbatsha ga utshu agboro aayi kœwa ngbanga. Endje mbœrœ adœke œne gbe kœtondœ o'o nœ ye dœ ɔtshɔnœ kane. ");
INSERT INTO kxf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kashe yiyindœ nœ nene. Gbambanœ nene, endje lœ kœropa azu zazu bisha á endje gɨ uku ga tœ awa ye. Endje dara ama endje dœ ɨ'ɨrɨ Ndjaba adœke œne zɨ œrœ nene, œ ndjo ndje ungu nene œrrr adœke œne wo Polo yekane. Adja endje gumatœ endje kɔ yé œ sœ kolœ kœkate adœke ɓœ yindœ nœ awa bale dœ œne.» ");
INSERT INTO kxf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Utshu kœza awa fœ gbolo yakoshenœ, gbozu tshapa aturugunœ pa fœ she adœke: «Kpa mɨmɨndœ nœ fœ anga uzu bale nene.» ");
INSERT INTO kxf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Gbozu tshapa aturugu kœ'e anga aturugu nœ ye bisha, kœpa fœ endje adœke: «'E gumatœ 'e mbœrœ kœro ga lœ Sezaré, dœ ada ɔlɔ mindu dœ vana lœ butshɔ asœ, e ko aturugu kama bisha, endjeneke á endje ɔ ga pa ambarata zazu votɔ dœ ndjokpa dœ azu kœnɔ wele kama bisha. ");
INSERT INTO kxf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","'E ko ndje ambarata mbœrœ kœgi dœ Polo dœ soro fœ gbozu Felikisi.» ");
INSERT INTO kxf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yé tshe kœsu mbeti adœke: ");
INSERT INTO kxf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Abala nœ zœ. Œmœ Klode Lisiyase, mœ sœ kœsu mbetinœ asœke fœ ɓœ dœ gbozu Felikisi, á endje lɨsœ zœ waa asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayuda za uzu asœ yé œ yindœ kœwo she. Lɔkɔ á mœ dji adœke œshe kœdœ gbolo ogo Roma, mœ na dœ aturugu nœ mœ á za she tshakane endje. ");
INSERT INTO kxf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ɓata á mœ yi lima ndœ kœwusœ ádá o'o á endje tɔ lima meza pa ye ndœ nœ, mœ na dœ she ga utshu agboro aayi kœwa ngbanga nœ Ayuda. ");
INSERT INTO kxf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mœ wu adœke, endje tɔ mezanœ pa ye mbœrœ o'o á wu awa akwa nœ endje dœ tœ endje. Kashe tshe mbœmbœrœ anga ekperœ bale á li adœke endje wo she too endje za she ga lœ kánga nene. ");
INSERT INTO kxf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ɓata endje pandœ nœ fœ mœ adœke, Ayuda sœ dœ ekpe gbetshelœ tœ kœwo she, mœ vwa she fœ ɓœ, œ pa fœ endje adœke endje na ndje kœtɔ mezanœ pa ye ɓa utshu zœ.» ");
INSERT INTO kxf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aturugu mbœrœtœ endje liaka o'o á gbozu tshapa endje pa. Endje za Polo yé œ gi she na tœnœ butshɔ butshɔ œrrr ga ndœ Atipatrisi. ");
INSERT INTO kxf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Osho kɔrɔ panœ, aturugu á endje sœ lima kœna dœ ada endje kwatœ endje ga lœ padanœ, yé á katœ endjeneke á endje ɔ ga pa ambarata kœro tœ awanœ dœ Polo. ");
INSERT INTO kxf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lɔkɔ á endje wuta ga lœ Sezaré, ayi kœkpa dœ ambarata za mbetinœ fœ gbozu tshapa ogo lœ ongbonœ, yé œ katœ Polo tɨ ga tshakane ye. ");
INSERT INTO kxf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gbozu tshapa ogo lœ ongbo Yuda kœdɨ mbetinœ yé á yu Polo tœ kœwusœ ogo nœ ye. Manda kœwusœ nœ adœke œshe kœdœ uzu lœ ogo Silisi, ");
INSERT INTO kxf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tshe pa fœ she adœke: «Mœ dji ɓœ dœ lɔkɔ á azu kœtɔ meza pa zœ kœyikumu endje.» Tshe kœpa fœ aturugu nœ ye adœke endje gbɔndœ Polo ɓa sœnda nœ gbozu Erode. ");
INSERT INTO kxf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Manda olo mindu, gbozu nganga Ndjaba Anania wuta ɓa lœ Sezaré awa bale dœ agbɔ Ayuda ndje dœ ayi kɔkɔ bale á ɨ'ɨrɨ ye kœdœ Tertuluse. Endje wuta ga utshu gbozu Felikisi ndœ kœtɔ meza pa Polo. ");
INSERT INTO kxf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Endje e Polo, yé Tertuluse tetœ kœpa œnœ ye ngbanganœ dœ o'o atake: «Gbozu Felikisi, mœ lɨsœ zœ waa! Œ ga mbœrœ kœwusœtœ nœ zœ dá ɓœ guma ogonœ asœ adœke œ ga waa. Mbœrœ ɓœ dá 'a sœ dœ adja kœsœ gee lœ ogo nœ 'a. ");
INSERT INTO kxf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","'A lɨsœ zœ, gbozu Felikisi, mbœrœ œrœ kɔ 'a gbɔ tœ osho dœ osho. ");
INSERT INTO kxf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kashe mœ yiyindœ kœwo ada ɔlɔ nœ zœ nene. Mœ kɨ fœ ɓœ adœke ɓœ sœ dœ ɔtshɔ lɔsu ndœ kœdji mœ teasho kane. ");
INSERT INTO kxf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","'A wu adœke uzu asœ kœdœ ekpe uzu tɔpanœ kpuru, tshe sœ kœli dœ djingili ga ugurutœ Ayuda tœ osho kɔ, yé œshe kœdœ gbozu tshapa Anazareye. ");
INSERT INTO kxf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tshe yi ndje lima ndœ kœndɨ Tepelo á dœ œyerœ anda nœ Ndjaba dœ uburu yeka á 'a za she.  'A yi lima ndœ kœwa ngbanga ga tœ ye liaka awa akwa nœ 'a, ");
INSERT INTO kxf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kashe gbozu tshapa aturugu á tshe dœ́ Lisiyase, kakara she dœ ɔgbɔ tshakane 'a, ");
INSERT INTO kxf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","yeka á vwa 'a adœke 'a na kœtɔ meza pa ye ɓa ndœ zœ. Œdœ ɓœ kœyu she dœ tœ zœ, ɓœ wu adœke o'o á 'a tɔ meza pa ye ndœ nœ kœdœ adja o'o.» ");
INSERT INTO kxf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Manda o'o nœ ye, Ayuda para kœyindœ nœ adœke: «Adja upu dá tshe pa.» ");
INSERT INTO kxf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gbozu tshapa ogo lœ ongbo kœza awa fœ she ndœ kœpa o'o. Polo kœgi adœke: «Mœ wusœ nœ adœke œɓœ dá wa ngbanga ɓa lima lœ ogo nœ 'a manda ungu ndjoro. Mœ sœ dœ yanga ndœ kœpa o'o utshu zœ. ");
INSERT INTO kxf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɓœ kœyu ndje osho dœ tœ zœ, œ mbœrœ kolœ olo ndjokpa dœ bisha ɔlɔ á mœ ro ga lœ Yerusaleme kœdonga Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ɔlɔ bale á endje na á gbɔ mœ ɓa sœnda Tepelo too ɓa lœ Sinagoga too lœ ongbo, á mœ sœ tœ œbœrœ, too kœvwa azu adœke endje shoka ama dœ anga endje gugu nene. ");
INSERT INTO kxf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Azu asœ tɔ meza pa mœ kolœnœ gbambanœ. ");
INSERT INTO kxf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Andaa œneke á mœ yindœ nœ kœdœ adœke mœ sœ kœmbœrœ akwa fœ Ndjaba nœ aata 'a lœ awa nœ Gbozu kashe endje pa adœke awanœ dœ́dœ́ ɔtshɔ awa nene. Mœ yi ndje ndœ o'o á endje sú ala mbeti nœ awa akwa œdœ pe œneke á aayi kœgbara o'o pa. ");
INSERT INTO kxf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Œmœ dœ pe endje, 'a sœ kœza lɔsu 'a ga pa Ndjaba tœ œneke á pa adœke ɔtshɔ azu œdœ ekpe azu œ she bala lœ akuzu. ");
INSERT INTO kxf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mbœrœ tœnœ ataa á mœ sœ kœpa avwara adœke mœ mbœrœ ekperœ utshu Ndjaba nœ mœ œdœ pe azu nene. ");
INSERT INTO kxf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Mœ mbœrœ ungu ndjoro lœ ana, yé á mœ gu mbœrœ kœto œrœ fœ azu ogo nœ mœ œdœ pe makabo fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yeka á endje na á gbɔ mœ lœ awa kœmbœrœ adœke ɔkɔ mœ sœ yerœ ɓa lœ Tepelo. Kashe azu sœsœ lima ndjoro nene, yé œbœrœ gugu ndje nene. ");
INSERT INTO kxf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Anga Ayuda lœ Azi, endje dá sœ lima kpœtœmœ, endje dá li má ndœ kœtɔ meza pa mœ œdœ endje kœsœ má dœ o'o dœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yé azu á endje sœ asœ, endje pandœ ekperœ á mœ mbœrœ lima ɔlɔ á endje sœ kœyu mœ utshu ayi kœwa ngbanga. ");
INSERT INTO kxf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Too kolœ manda rawa á mœ ta dœ o'o adœke: “Mbœrœ á mœ yindœ nœ adœke akuzu œ she lœ akuzu dá 'e yindœ kœwa ngbanga ga tœ mœ a?”» ");
INSERT INTO kxf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikisi á tshe wu lima sœ o'o nœ ayindœ Yisu dœ ɔtshɔnœ, kœpa fœ endje adœke: «'E gu zœ, ɔlɔ á Lisiyase gbozu tshapa aturugu œ na, dá mœ kœwa ngbanga nœ 'e.» ");
INSERT INTO kxf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tshe kœvwa anga turugu ndœ kœgi Polo ga lœ kánga. Kashe tshe sœsœ kœnga tœ ye nene, tshe za awa fœ azu nœ ye ndœ kœna kœwu she. ");
INSERT INTO kxf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Manda olo teasho, Felikisi kœna ɓa lœ kánga dœ awonœ á ɨ'ɨrɨ ye kœdœ Drusile, œshe kœdœ uyu Yuda. Tshe e Polo mbœrœ tshe sœ lima dœ ogo ndœ kœdji o'o nœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kashe, ɓata á Polo sœ lima kœmɨndœ o'o nœ ɔtshɔ ɔtshɔ uzu, mara nœ kœgbɔndœ tœ zœ dœ uzu dœ pe mara á Ndjaba œ wa bala ngbanga nœ azu, awa za Felikisi yé tshe pa adœke: «Ɓœ lii kœgu œnœ zœ ngɔngɔ asœ da ye. Mœ e ɓœ bala manda nœ.» ");
INSERT INTO kxf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tshe sœ kœgbe adœke Polo œ to ngendja fœ œne, yeka á sœ lima kœ'e she kpœpanœ kpœpanœ ndœ kœpa o'o dœ she. ");
INSERT INTO kxf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Manda ungu bisha, Porsiyuse Festuse kœza akwa manda Felikisi. Ɓata á Felikisi yindœ nœ adœke Ayuda yindœ œne, á ka lima tœ Polo tɨ lœ kánga. ");
INSERT INTO kxf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Olo votɔ manda kœwuta Festuse ga lœ ogonœ asœmœ, tshe to ɓa lœ Sezaré œ ro ga lœ Yerusaleme. ");
INSERT INTO kxf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Agbozu tshapa anganga Ndjaba dœ pe agbozu Yuda na kœtɔ meza pa Polo fœ she. Endje yu lima she kpœpanœ kpœpanœ adœke ");
INSERT INTO kxf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","tshe za awa fœ œne dœ́ œne to she gu tœnœ ga lœ Yerusaleme. Andaa, endje vwara lima ndœ kœwo she tœ ala awa. ");
INSERT INTO kxf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kashe Festuse gi adœke tshe sœ lœ kánga ɓa lœ Sezaré, yé œne yindœ kœro dœ tœ œne ga zœ ngɔngɔnœ asœke. ");
INSERT INTO kxf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tshe kpa pa ga pa nœ adœke: «Œ li adœke agbozu tshapa 'e ro tœ awanœ bale dœ mœ ɓa lœ Sezaré, yé œ kœsœ adœke uzunœ asœmœ mbœrœ lima ekperœ á endje kœtɔ mezanœ pa ye.» ");
INSERT INTO kxf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festuse mbœrœ lima kolœ olo mindu dœ votɔ too ndjokpa gbambanœ ɓa ndœ endje kpœtœmœ, yeka á gu ga lœ Sezaré. Osho kɔrɔpa nœ, tshe sœ ga atɨ ɓa tœ osho kœwa ngbanga yé á za awa adœke endje na œ to Polo na tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lɔkɔ á Polo yi kumu ye, Ayuda á endje to lima ɓa lœ Yerusaleme ndɨvwɨrɨ she yé œ te lima tœ kœpa ogboro o'o ga pa ye, ogboro o'o neke á endje kœyu endje tœ ádá o'onœ, endje li kœpandœ nœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kashe Polo pa lima ngbanga nœ ye adœke: «Œdœ ga tœ awa akwa nœ Ayuda, œdœ ga tœ Tepelo too fœ egerœ gbozugo, mœ mbœmbœrœ ekperœ bale nene.» ");
INSERT INTO kxf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festuse yindœ kœza yanga fœ Ayuda yé œ yu Polo adœke: «Ɓœ yindœ kœro ga lœ Yerusaleme adœke endje wa ngbanga nœ zœ ɓa utshu mœ a?» ");
INSERT INTO kxf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Polo gi adœke: «Mœ ka ga utshu osho kœwa ngbanga nœ egerœ gbozugo, yé kpœke dá endje wa ngbanga nœ mœ. Mœ mbœmbœrœ ekperœ bale fœ Ayuda nene ɓata á ɓœ wusœ nœ dœ ɔtshɔ nœ dœ tœ zœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Œdœ adja mœ kœmbœrœ má ekperœ, yé á mbœrœ ekperœ neke á li dœ kuzu, mœ vwaratœ mœ ndœ kœtshu tœnœ nene. Kashe œdœ o'o á endje tɔ meza pa mœ ndœ nœ kœdœ́dœ́ okporo o'o nene, uzu bale á tshe za mœ ga tshakane endje gugu nene. Mœ yindœ nœ adœke mœ wuta ga utshu egerœ gbozugo.» ");
INSERT INTO kxf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festuse kœte ga ndœ aayi kœmɨ upu nœ ye, œ kœgi fœ Polo adœke: «Ɓata á ɓœ yindœ kœwu egerœ gbozugo ndœ kœwa ngbanga nœ zœ, ɓœ ro ga utshu ye tako.» ");
INSERT INTO kxf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Olo teasho manda nœ, gbozu Agripa dœ pe yingɔ nœ á ɨ'ɨrɨ ye kœdœ Berenise, ro ga lœ Sezaré yé œ na kœwu Festuse. ");
INSERT INTO kxf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ɓata œndœ ndje dɨ lima ndje kpœtœmœ, Festuse pandœ o'o nœ Polo fœ Agripa adœke: «Anga yakoshe bale á Felikisi ka lima tœ ye tɨ lœ kánga sœ kpœke. ");
INSERT INTO kxf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Lɔkɔ á mœ na lima ga lœ Yerusaleme, agbozu tshapa anganga Ndjaba dœ pe agbɔ Ayuda na kœtɔ meza pa ye, yé endje pa fœ mœ adœke mœ wa ɔgbɔ ngbanga ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yeka á mœ gi fœ endje adœke, awa akwa nœ azu Roma pa adœke: œdœ endje kœtɔ meza pa uzu, œ li adœke endje dji she tshe pa o'o ɔkɔ ye ɓa utshu aayi kœtɔ mezanœ yekane á endje kœwa ngbanga ga tœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Endje kœaafo, á 'a kœgu tœ awanœ dœ endje ga mœ. Mœ kpakpalatœ mœ lɔkɔ á osho kɔrɔ nene, yé mœ na œ sœ ga atɨ ɓa tœ osho kœwa ngbanga yeka á vwa osho adœke endje gu dœ uzunœ ga mœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Azunœ á endje tɔ meza pa ye áafo kashe endje papa anga ngbɨndɨ o'o tœ upu nœ ye liaka œneke á mœ gbe má kœdji tœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Endje sœ lima kœshara upu dœ she pa mara kœdonga Ndjaba nœ endje dœ tœ endje, ndje tœ upu nœ anga uzu á ɨ'ɨrɨ ye kœdœ Yisu á tshe tshu ye, yeka á Polo kpa pa adœke, tshe sœ dœ soro zœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mœ wuwu lima sœ œrœ á mœ mbœrœ tœ kœwa mara ngbanga atamœ nene. Mbœrœ tœnœ dá mœ yu Polo adœke tshe yindœ nœ dœ́ endje na ga lœ Yerusaleme adœke endje wa ngbanga pa ye tœ o'onœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kashe Polo yindœ nœ lima adœke œne wuta ɓa utshu egerœ gbozugo yeka á tshe kœwa ngbanga pa o'o nœ œne. Yé á kœpa adœke endje gbɔndœ ye lœ kánga œrrr ga tœ olo á mœ vwa she fœ egerœ gbozunœ.» ");
INSERT INTO kxf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa kœpa fœ Festuse adœke: «Mœ yi ndje ndœ kœdji ndje yakoshenœ asœmœ.» Festuse kœgi fœ Agripa adœke: «Ɓa mbatsha ɓœ dji she zœ.» ");
INSERT INTO kxf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Osho kœkɔrɔ pa nœ, Agripa dœ Berenise na, dœ azu ndjoro, yé œ li dœ kœlɨsœtœ ga sœnda awa bale dœ agbozu tshapa aturugu dœ pe agbozu tshapa ongbo. Festuse vwa osho yé endje na œ za Polo gu tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festuse kœpa adœke: «Gbozu Agripa œdœ pe 'e kɔ á 'e sœ dœ 'a atɨ asœke, 'e wu yakoshenœ asœ. Ayuda ndjoro na kœtɔ meza pa ye ɓa ndœ mœ, ɓa lœ Yerusaleme, dœ pe ndje ɓa lakpɨnœ asœke. Endje pa dœ ɔgbɔ adœke, tshe lili kœsœpe dœ soro nene. ");
INSERT INTO kxf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɓa ndœ mœ, mœ wusœ nœ adœke tshe mbœmbœrœ anga ekperœ bale á li adœke tshe tshu lœ kumunœ nene. Kashe ɓata á Polo dœ tœ ye yindœ nœ adœke, egerœ gbozu kœwa ngbanga pa œne, mœ wa o'o tœ kœvwa she fœ egerœ gbozunœ. ");
INSERT INTO kxf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ɓata á mœ wuwusœ o'o neke á mœ kœsu pa ye fœ egerœ gbozu nene, dá mœ sœ kœyu she utshu 'e, utshu œɓœ dœ gbozu Agripa, adœke ɓœ yu she yeka á mœ kœgbɔ o'o kœsu fœ she tœ upu nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mœ wu adœke œ sœsœ dœ ɔtshɔnœ nene kœvwa ayi kánga fœ egerœ gbozu œdœ ádá o'o á endje tɔ meza pa ye kœsœsœ ngbɨ nene.» ");
INSERT INTO kxf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa kœpa fœ Polo adœke: «Mœ za awa fœ ɓœ ndœ kœpa ngbanga nœ zœ.» Polo kœtɨ kane ye ga lafo ndœ kœpa o'o yé œ pa adœke: ");
INSERT INTO kxf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Gbozu Agripa, mœ sœ dœ yanga kpesheke ndœ kœpa ngbanga ɓa utshu zœ tœ o'o kɔ á Ayuda tɔ meza pa mœ tœnœ, ");
INSERT INTO kxf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","gbambanœ nene, ɓœ wusœ mara kœmbœrœtœ nœ Ayuda dœ pe kœshara upu pa mara kœdonga Ndjaba nœ endje dœ ɔtshɔnœ. Mœ kɨ fœ ɓœ adœke lɔsu zœ zɨ tɨɨ á ɓœ kœdji mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ayuda para wusœ soro mœ pe dœ gbolo mœ ye, mbœrœ mœ gerœ lœ Yerusaleme ugurutœ azu ogo nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Endje wusœ mœ katshatsha. Œdœ endje kœyindœ nœ, endje pa adœke œmœ kœdœ anga Afarisayinœ á endje ro anga Ayuda dœ kœdonga Ndjaba dœ pe kœlɨsœ awa akwa nœ azœ waa. ");
INSERT INTO kxf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yé ngɔngɔ asœke, mœ sœ kœpa ngbanga mbœrœ á mœ za lɔsu mœ ga pa anga o'o á Ndjaba pa lima fœ aata azœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mara azu ndjokpa dœ bisha (12) lœ Israyele sœ kœdonga Ndjaba butshɔ dœ ɔlɔ dœ lɔsu adœke œne wu œrœnœ asœmœ. Uu gbozu Agripa! Mangba o'onœ á mœ za lɔsu mœ ga tœ nœ asœmœ dá Ayuda tɔ meza pa mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ayuda, mbœrœ gaɗe á 'e gbe adœke Ndjaba œ she azu á endje tshu lœ kuzu nene a? ");
INSERT INTO kxf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Œmœ ndje lima, mœ sœ kœpakata azu adœke endje yiyindœ Yisu uzu Nazarete nene. ");
INSERT INTO kxf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Œtœnœ dá mœ mbœrœ lima lœ Yerusaleme. Agbozu tshapa anganga Ndjaba za awa fœ mœ yé mœ ko ayindœ Yisu ndjoro gu tœnœ ga lœ kánga. Yé œ kœsœ lima adœke endje wo endje ye, mœ sœ lima kœyindœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mœ mbœrœ lima kɔ adœke endje wu œrœ kanga lœ Sinagoga, adœke endje katœ kœyindœrœ nœ endje ga ndœ Yisu tɨ ye. Tshelœ mœ fa lima ga tœ endje dœ mara adœke, mœ sœ lima kœza awa endje œrrr dje lœ ongbo á sœ lœ ɨngɨrɨnœ.» ");
INSERT INTO kxf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Mbœrœ tœnœ ataa, mœ sœ lima kœna ɔlɔ bale ga lœ Damaseke dœ mbeti á agbozu tshapa anganga Ndjaba su fœ mœ adœke œ za awa nœ kœmbœrœ œrœ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Uu gbozu! Tɨ damba tœ ala awa, ndoo dœ midi, mœ wu ɨshirɨ owo á ropa ɔlɔ kœto ɓa lafo kœjerœ ga pa mœ, dœ pe anga mœ á 'a sœ lima kœro tœ awanœ dœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","'A kœyo kɔ ga lœ ɔshɔ, mœ kœdji tshama uzu kœ e mœ dœ o'o ama Ebre adœke: “Sawulo, Sawulo, mbœrœ gaɗe á ɓœ sœ kœmbœrœ œrœ kanga fœ mœ a? Ɓœ sœ kœwu oyo tœ zœ ɓata yaburu á ayengɔ ye du uwu ga lœ ɨgɨ ye á sœ kœgbota she á tshe sœ kœvwaratœ ye tœ kœna manda ye.” ");
INSERT INTO kxf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Mœ kœyu adœke: “Œɓœ kœdœ ɗe, Gbozu?” Gbozu kœpa adœke: “Œmœ kœdœ Yisu, œmœ dá ɓœ mbœrœ œrœ kanga fœ mœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kashe alafo, œ ka dœ ada zœ! Wu, mœ wuta ga ndœ zœ mbœrœ kœfa ɓœ tœ ayi akwa nœ mœ. Ɓœ dœ́ timu nœ mœ adœke ɓœ pandœ nœ fœ azu mara á ɓœ wu dœ mœ kpesheke dœ pe œneke á mœ kpa yisœ nœ fœ ɓœ manda nœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Œdœ ɓa ndœ Ayuda, œdœ ɓa ndœ angbɨ azu, mœ gbɔndœ zœ tœ osho kɔ á mœ vwa ɓœ tœnœ, ");
INSERT INTO kxf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","mbœrœ kœkɔrɔ ala endje, ndœ kœgi endje lœ ubu osho ga tœ ɨngbɨsho, mbœrœ endje vwaratœ endje tœ Satana yé œ na ga ndœ Ndjaba. Œdœ endje kœsœ dœ kœyindœrœ ga ndœ mœ, mœ djerœndœ ekperœ nœ endje yé œ za osho kœsœ ugurutœ ayerœ azu nœ Ndjaba fœ endje.”» ");
INSERT INTO kxf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kœto tœ olonœ asœmœ, gbozu Agripa, mœ mbœrœ œneke kɔ á to ɓa ndœ Ndjaba á tshe yisœ nœ fœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Utshunœ, mœ tetœ kœmɨndœ nœ fœ azu tshalakpɨ Damaseke dœ Yerusaleme. Manda nœ, mœ mɨndœ nœ fœ azu tshelœ ogo Yuda kɔ ndje dœ angbɨ azu. Mœ sœ kœpa fœ endje adœke endje fatshalɔsu endje, œ na ga ndœ Ndjaba yé œ mbœrœ akwa á sœ kœma adœke endje fa adja tshalɔsu endje ye. ");
INSERT INTO kxf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ádánœ á Ayuda tepa mœ ɓa lœ Tepelo, á yindœ kœwo mœ dœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kashe Ndjaba sœ kœgbɔndœ mœ œrrr ga tœ kpesheke, yé mœ sœpe damba dœ soro mbœrœ kœpa œneke asœke fœ azu para kɔkɔ, fœ agbolo ndje fœ agbozu. Œneke á mœ sœ kœpandœ nœ asœke kœdœ kolœ œneke á aayi kœgbara o'o œdœ mbeti nœ Moyize pa lima ndœ nœ adœke œ wuta. ");
INSERT INTO kxf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Endje mɨ lima ndœ nœ adœke, Masiya œ wu oyo, yé œ tshu yeka á she lœ akuzu utshu azu kɔ. Tshe mɨndœ o'o nœ Ndjaba á sœ ɓata ɔlɔ á za kœshe fœ Ayuda dœ pe angbɨ azu.» ");
INSERT INTO kxf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Polo sœpe damba kœpa ngbanga, á Festuse pa o'o dœ ɔgbɔ adœke: «Iyi te lœ kumu zœ a! Œrœnœ á ɓœ wusœ nœ waa dá mbœrœtœ zœ asœke a!» ");
INSERT INTO kxf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kashe Polo kœgi adœke: «Mœ sœsœ dœ iyi nene, gbozu Festuse, o'onœ á mœ sœ kœpa tœnœ kœdœ adja o'o, yé ádánœ sœ zœ. ");
INSERT INTO kxf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gbozu Agripa dji o'onœ asœke, yé mœ li kœpa o'o ɓa utshu ye dœ awa nene. Tshe wusœ o'onœ asœ bale bale kɔ, gbambanœ nene, œ mbœmbœrœtœ endje wutœnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Gbozu Agripa, ɓœ yindœ o'o á aayi kœgbara o'o pa lima ye a? Mœ wusœ nœ adœke ɓœ yindœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kœpa fœ Polo adœke: «Œ sœpe teasho adœke ɓœ fa gbetshelœ nœ mœ adœke mœ wuta uzu nœ Kristu!» ");
INSERT INTO kxf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Polo gi adœke: «Olo sœ ndoo, olo sœ lœ ɨngɨrɨnœ, mœ sœ kœ'e Ndjaba mbœrœ œɓœ dœ pe azu para á endje sœ kœdji mœ kpesheke asœ adœke 'e wuta ɓata mœ, kashe endje ii 'e dœ uwu ga tœnœ ɓata mœ nene!» ");
INSERT INTO kxf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Gbozu Agripa kœaafo awa bale dœ gbozu ongbo Festuse dœ Berenise, dœ pe azu para á endje sœ lima kpœtœmœ, ");
INSERT INTO kxf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","yé kœgitœ endje ga ɨndɨrɨnœ, kœpa lœ ugurutœ endje adœke: «Uzunœ asœ mbœmbœrœ ekperœ á li adœke a wo she too a za she ga lœ kánga nene.» ");
INSERT INTO kxf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa kœpa fœ Festuse adœke: «Œdœ uzu asœ kœyɔyɔ lima ndœ nœ adœke gbozu Roma kœwa o'o nœ œne nene, dá a za má she ga shu ye.» ");
INSERT INTO kxf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ɔlɔ á endje gbe adœke 'a ro ga lœ Itali dœ egerœ agba, endje za Polo dœ pe anga aayi kánga fœ anga gbozu nœ aturugu bale á ɨ'ɨrɨ ye kœdœ Juliyuse, tshe kœdœ gbozu uguru ukpulu aturugu lœ ogo Roma á endje e endje adœke «ukpulu aturugu nœ egerœ gbozu.» ");
INSERT INTO kxf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","'A ɔ ga lœ egerœ agba á to ɓa lœ Adramite á yindœ kœro kœka ga tœ mangu lœ ogo Azi. 'A ro lima tœ awanœ dœ Aristarke uzu Tesalonike lœ ogo Masedwane. ");
INSERT INTO kxf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Osho kɔrɔ pa nœ, 'a ka lima ɓa tœ Sidona, Juliyuse sœ kœmbœrœ ɔtshɔrœ ga tœ Polo, á za awa fœ she kœna ndœ kœwu anganœ á endje kœto œrœ á tshe sœ dœ ogonœ fœ she. ");
INSERT INTO kxf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Manda kœkatœ Sidona tɨ, 'a áafo, œ ro ndoo dœ tshiki lœ Shipre mbœrœ yugu sœ lima kœgi 'a ga ngbanœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","'A zu ungu kota ga tœ ama ungu ndoo dœ Silisi œdœ Pafili, yeka á 'a wuta ga lœ Mire lœ ogo Lisi. ");
INSERT INTO kxf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɓa zœ, gbozu nœ aturugu wu anga egerœ agba á to ɓa lœ Alekezandri, á sœ kœro ga lœ Itali, á ko 'a ga lœ nœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","'A mbœrœ lima olo ndjoro la ngu mbœrœ egerœ agba sœ lima kœkpa yima yima, yé 'a wu lima oyo á wuta lima ga lœ Kinide. Ɓata 'a lili kœna ndjii ga zœ nene mbœrœ yugunœ á sœ kœndanga 'a, 'a fa dja ga lœ Salemone tœ osho á tshiki Krete ko 'a yiwa tœnœ tœ yugunœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Yé manda nœ, 'a mbœrœ oyo tœ 'a, á wuta ga tœ osho á ɨ'ɨrɨnœ kœdœ Ɔtshɔ Mangu ndoo dœ ongbo Lase. ");
INSERT INTO kxf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kashe œndœ 'a dɨ lima lœ ananœ waa, yé loko dopa nœ, awa adœke egerœ agba na ana gugu nene. Olo á Ayuda œ yo tshelœ ama endje ro lima ye, á Polo kœpa fœ endje adœke: ");
INSERT INTO kxf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Anga mœ, mœ wu adœke ana asœ ngaanga dœ azœ. Anganœ ete, egerœ agba dœ pe œrœ kɔ á sœ lœ nœ œ ndɨ, azœ ndje 'a tshu.» ");
INSERT INTO kxf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kashe gbozu nœ aturugu vwaratœ ye kœdji Polo, yé á dji kolœ ayi kœkpa dœ egerœ agba dœ pe ayingɔ egerœ agbanœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɓata mangunœ gaga lima adœke endje sœ tœnœ dœ lɔkɔ nœ ɨzɨ nene, ɨlɨ azu yindœ nœ adœke œne ro. Endje yindœ kœro ga lœ Fenikise, anga mangu ogo Krete, á sœ ga tœ osho á ɔlɔ œ li tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Aya yugu to ɓa aki á sœ kœna tœnœ, yé endje gbe adœke œne li kœmbœrœ œneke á œne yindœ nœ. Endje gbota longonœ yé œ afo kœro tœnœ kperœ tœ ama mangu tshiki Krete. ");
INSERT INTO kxf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kashe œndœnœ dɨ teasho, ndavuru yugu á to ga pa gele ndo dœ osho á ɔlɔ œ wuta tœnœ, ɓa pa kaga tshiki á jerœ ga pa endje. ");
INSERT INTO kxf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yugunœ gi agba dœ ɔgbɔ ga manda nœ, awa adœke 'a mbœrœ anga œrœ gugu nene yé 'a katœ nœ tɨ adœke œ gi 'a. ");
INSERT INTO kxf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Á ro tɔ ɨndɨrɨ aya tshiki bale á ɨ'ɨrɨnœ kœdœ Koda á sœ lima kœwandœ ata gbɔgbɔ yugunœ pa 'a, yé uvuru 'a kpa lima lœ nœ tœ kœza aya agba kœshe dœ azu. ");
INSERT INTO kxf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Manda kœtɨ tœnœ ga lafo, endje ko ogboro uwu á du ga tœ egerœ agbanœ mbœrœ loko kœkakavwa nene. Ɓata awa kœshi pa mindu dja ga tœ Libi sœ lima kœza endje, endje geta egerœ maɓaya á endje du ga tœ egerœ agbanœ vwi ga la ngu, á tetœ kœna la ngu yima yima. ");
INSERT INTO kxf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Osho kɔrɔ pa nœ, ɓata yugunœ sœpe lima kœvwi 'a dœ agbɔnœ, 'a tetœ kœko ata gbarœ va ga la ngu. ");
INSERT INTO kxf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Yé olo bisha manda nœ, aayi kœmbœrœ akwa lœ egerœ agbanœ dœ tœ endje, te ndje tœ kœko œrœ kote egerœ agbanœ va e. ");
INSERT INTO kxf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","'A kpa sœ lima kœwu ɔlɔ too angerepe nene, manda olo ndjoro, yugu sœ kœna kolœ dœ agbɔ, yé gbetshelœ nœ soro kpa gugu lima lœ kumu 'a nene. ");
INSERT INTO kxf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Azu á endje lœ lima lœnœ zɨzɨ œrœ nene manda olo ndjoro, yé Polo afo ugurutœ endje á pa adœke: «'E wu, anga mœ, œdœ 'e kœdji lima o'o mœ, á 'a sœpe lœ Krete, gbarœ œdœ œrœ kote egerœ agba œ ndɨ má nene. ");
INSERT INTO kxf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kashe ngɔngɔ asœ, mœ sœ kœpa fœ 'e adœke 'e ru lɔsu 'e, uzu bale ugurutœ 'e œ tshu nene, kolœ egerœ agba dá ndɨ. ");
INSERT INTO kxf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndjaba nœ mœ á mœ mbœrœ akwa fœ she vwa anga andjelu fœ mœ dœ abutshɔnœ asœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Tshe pa fœ mœ adœke: “Polo, awa zaza ɓœ nene, œ li adœke ɓœ pa ngbanga utshu egerœ gbozu yeka. Ndjaba œ she azu para lœ egerœ agbanœ asœ mbœrœ ɔtshɔ lɔsu nœ ye ga ndœ zœ.” ");
INSERT INTO kxf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","'E ru lɔsu 'e alaya, gbambanœ nene, mœ za lɔsu mœ ga tœ Ndjaba yé œrœ œ mbœrœtœ ye liaka œneke á andjelu pandœ nœ fœ mœ asœmœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kashe egerœ agbanœ œ zatœ ye tɔ ama ɔshɔ tœ ama anga tshiki bale.» ");
INSERT INTO kxf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Manda pɔsɔ bisha, egerœ yugunœ vwi 'a lima na tœnœ œrrr ga la egerœ ungu á ɨ'ɨrɨnœ kœdœ Adriyatike. Kœndo dœ ɔgbɔ butshɔ, azu akwa tshelœ egerœ agba gbe adœke 'a ndo dœ ama ɔshɔ ye. ");
INSERT INTO kxf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Endje du uwu ga tœ badja, á vwi ga la ngu ndœ kœwusœ dili ungunœ. Endje wu adœke ungunœ li metere zazu bale dœ ndjokpa dœ amanœ mindu dœ bisha. Yé endje gitœ endje ga utshunœ, œ kpa vwi uwunœ, á wu adœke œ sœ dœ metere zazu bisha dœ amanœ mindu dœ votɔ. ");
INSERT INTO kxf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Endje sœ lima dœ awa adœke egerœ agbanœ zazatœ ye tɔ badja nene. Mbœrœ tœnœ ataa, endje du longo vana ga tœ budunœ, á ko va ga la ngu, yé á sœ lima kœkate dœ lɔsu endje ga lafo adœke osho kɔrɔ. ");
INSERT INTO kxf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ɓata aayi akwa yi lima ndœ kœkpa tœnœ, endje gi lima aya agba kœshe dœ azu ga la ngu yé œ fara adœke œne jerœ ga lœ nœ á kœdu longonœ ga utshu egerœ agbanœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Polo kœpa fœ gbozu nœ aturugu dœ pe aturugu adœke: «Œdœ azu asœ kœsœsœpe lœ egerœ agbanœ asœ nene, e'e, 'e sœpe dœ soro nene.» ");
INSERT INTO kxf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yeka á aturugu na, á wa tshelœ uwu tœ aya agbanœ, yé á ka tœnœ tɨ á te ga la ngu. ");
INSERT INTO kxf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kœkate adœke osho kɔrɔ, Polo kœkɨ ga tœ azu para adœke endje zɨ œrœ. Tshe pa fœ endje adœke: «'E wu, œ mbœrœ kpesheke pɔsɔ bisha á 'e sœ kœgugu dœ awa yugu yé á zɨzɨ anga œrœ bale nene asœke. ");
INSERT INTO kxf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mœ sœ kœkɨ ga tœ 'e adœke 'e zɨ œrœ, gbambanœ nene, œ li adœke 'e mbœrœ ataa yekane á kœshe. Uzu bale ugurutœ 'e œ tshu nene.» ");
INSERT INTO kxf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Manda kœpa ataa, Polo za mapa, á gi mershe fœ Ndjaba tœ ala endje para, á tetœ kœzɨ tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yeka á endje gbɔ gbɔgbɔ á tetœ kœzɨ œnœ endje rœgonœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A'a para lœ egerœ agbanœ 'a sœ lima azu kama bisha dœ zazu votɔ dœ ndjokpa dœ amanœ mindu dœ bale. ");
INSERT INTO kxf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Manda kœzɨrœ, uvu azu para su, yé endje tetœ kœko ble va ga la ngu mbœrœ egerœ agbanœ kœlɨlɨ nene. ");
INSERT INTO kxf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Manda kœkɔrɔ osho, aayi kœmbœrœ akwa lœ egerœ agba wu adœke œne ndo dœ ɔshɔ ye. Kashe endje wuwu lima sœ ogo mangunœ nene, ɓata á endje wu osho á ungu li ga lœ mindu, endje gbe kœpara awa kœza agba ga tœ ama ɔshɔ ɓa zœ. ");
INSERT INTO kxf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Endje wa uwu tœ longonœ á katœ nœ tɨ ga la egerœ ungunœ, endje vwara kayi œ jerœ ga la ngu. Manda nœ, endje du lœba siriki ga utshunœ adœke yugu kœmbœrœ tœnœ á kœvwi egerœ agbanœ ga utshunœ yé œ tetœ kœna gutœnœ ga tœ ama ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kashe egerœ agbanœ shi pa mindu á sœ uguru gbɔgbɔ ungu bisha. Tshatshu egerœ agbanœ li lima ga lœ mindu, œ sœsœ lima kœturutœ ye nene, yé gbɔgbɔ loko kavwa lima budunœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aturugu kœwu adœke egerœ agba sœ kœndɨ tœnœ, á gbe kœwo aayi kánga mbœrœ endje kœdɔ ungu yeka á kœkpa nene. ");
INSERT INTO kxf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kashe gbozu nœ aturugu yindœ kœshe lima Polo, yé á pakata aturugunœ, yé á pa fœ azu neke á endje wusœ ungu adœke endje i ga la nœ, œ dɔ zutœnœ ga pa ɔshɔ. ");
INSERT INTO kxf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Anga endje zu dœ maɓaya too dœ agba ndɨndɨ egerœ agbanœ. Mara á azu para zu lima ungu dœ ɔtshɔ nœ dœ mœ. ");
INSERT INTO kxf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Manda kœshe 'a, 'a dji adœke ɨ'ɨrɨ tshikinœ asœ kœdœ Malte. ");
INSERT INTO kxf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ayengɔ ogonœ mbœrœ ɔtshɔrœ fœ 'a. Endje ngbɔ egerœ owo, á e 'a para ga ɨndɨrɨnœ, mbœrœ yavuru sœ kœni tœnœ yé ɨzɨ sœ waa. ");
INSERT INTO kxf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Polo rɔ lima agba yawo á za vwi ga ta wo, anga yakoro wuta mbœrœ katsha owonœ, á de kane ye á tɔpe tœnœ. ");
INSERT INTO kxf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kœwu adœke yakoronœ de kane Polo, ayengɔ ogonœ pa lœ tœ endje adœke: «Adjapu, yakoshe asœ kœdœ ayi kœwo azu, tshe tshɔ lœnœ la ngu, kashe ayi kœwa ngbanga tshalafo yiyindœ nœ adœke tshe sœ dœ soro nene.» ");
INSERT INTO kxf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Yé Polo vwi tshelœ kane ye, yakoronœ te ga ta wo, kashe katsha yakoronœ mbœmbœrœ she nene. ");
INSERT INTO kxf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Anga azunœ sœ lima kœkate kœwu mara á katsha yakoronœ œ mbœrœ she too ndje tshe gbɔ kukuku œ tshu, kashe endje ka œrrr anga œrœ bale mbœmbœrœ nene. Endje kœfa tshelœ o'o ama endje á kœpa adœke: «Yakoshe asœ kœdœ anga ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Egerœ uzu bale ndo dœ osho á sœ ɨndɨrɨnœ á ɨ'ɨrɨ ye kœdœ Publiyuse, sœ lima dœ osho kœsœ ndo dœ tshikinœ asœmœ kpœtœmœ. Tshe za osho kœsœ fœ 'a dœ ɔtshɔ lɔsu yé 'a lo kpœtœmœ olo votɔ. ");
INSERT INTO kxf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aba Publiyuse sœ lima dœ koɓa biwa œdœ pe awa. Polo na kœwu she, á e Ndjaba tœ ayi koɓanœ, á to kane ye ga pa ye ngbewo á koɓa nœ ye kœka ye. ");
INSERT INTO kxf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Manda nœ, anga azu tshikinœ á endje sœ lima dœ koɓa, na ga ndœ Polo ndœ kœgbɔ kœshe yé tshe she endje ye. ");
INSERT INTO kxf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Endje lɨsœ 'a lima waa, ɔlɔ á 'a jerœ ga la ngu ndœ kœro tœnœ, endje to œrœ kɔ á 'a sœ lima dœ ogonœ fœ 'a. ");
INSERT INTO kxf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","'A mbœrœ yapu votɔ lœ Malte, manda nœ 'a ɔ ga lœ egerœ agba, á sœpe lima lœ tshiki lœ ɨzɨ á sœ ɓa zœ. Tœnœ kœdœ lima egerœ agba tshelœ Alekezandri á ɨ'ɨrɨ ye kœdœ: «Ameya ndjaba.» ");
INSERT INTO kxf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","'A na œrrr yé œ wuta ɓa lakpɨ Sirakuse, yé 'a mbœrœ kpœtœ olo votɔ. ");
INSERT INTO kxf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kœto kpœtœmœ, 'a afo kpœtœ, 'a za tshandɨrɨ mangunœ œ ro œrrr gbuu ga lœ Rejio. Osho kɔrɔ pa nœ, yugu to dja ga mangba 'a yé á tagala 'a manda olo bisha á 'a wuta ga lœ Puzole. ");
INSERT INTO kxf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ɓa zœ, 'a gbɔ anga ayindœ Yisu, á endje kɨ ga tœ 'a adœke 'a mbœrœ dœ œne pɔsɔ bale, yeka manda nœ á 'a kœli ga lœ Roma. ");
INSERT INTO kxf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aaya lœ Yisu ɓa lœ Roma dji ndœ 'a, á na para tshatshu 'a, á kate 'a ɓa lœ zando Apiuse œdœ osho á endje e «anda agene». Lɔkɔ á Polo wu endje, tshe gbɔ gbɔgbɔ, yé œ za mershe fœ Ndjaba. ");
INSERT INTO kxf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kœyi kumu 'a ga lœ Roma, endje za awa fœ Polo ndœ kœgbɔ anda nœ ye kœlo tœnœ dœ pe turugu á tshe sœ kœza ala ye tœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Manda olo votɔ, Polo kœvwa osho fœ agbozu tshapa Ayuda ndœ kœngbɔtœ endje ga tœ nœ. Ɔlɔ á endje ngbɔtœ endje ga tœnœ, Polo kœpa fœ endje adœke: «Alaya, mœ mbœmbœrœ ekperœ ga tœ azu ogo nœ azœ nene, too ga tœ o'o á aata azœ katœ nœ tɨ fœ azœ nene, yeka á Ayuda nœ Yerusaleme tɔ meza pa mœ fœ azu nœ Roma asœ. ");
INSERT INTO kxf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Endje yu osho œ yindœ kœkatœ mœ; gbambanœ nene, endje gbɔgbɔ ekperœ bale á mœ mbœrœ yeka á endje kœwa o'o ndœ kœwo mœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kashe Ayuda vwaratœ endje ye, mœ sœsœ lima dœ anga œrœ kœmbœrœ tœnœ nene, á mœ yɔndœ nœ adœke gbozugo Roma kœwa ngbanga nœ mœ. Kashe mœ sœsœ dœ gbetshelœ kœndɨ ogo nœ azœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mbœrœ tœnœ ataa á mœ vwa osho ndœ 'e adœke a pa 'o mbœrœ tœnœ kane. Adja upu adœke endje i kane mœ mbœrœ uzu á azu Israyele sœ kœza lɔsu endje ga tœ ye.» ");
INSERT INTO kxf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Endje gi fœ she adœke: «'A gbɔgbɔ anga mbeti á to lœ Yuda mbœrœ o'o nœ zœ nene, yé lœ ugurutœ alaya á endje na asœ, anga bale á tshe na dœ ndœ trœrœ zœ too tshe pa ekpe o'o mbœrœ ɓœ gugu nene. ");
INSERT INTO kxf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kashe 'a yindœ kœdji ɓœ kœmɨndœ neke á ɓœ na dœ tœnœ mbœrœ osho kɔ, azu sœ kœvwaratœ endje tœ awa nœ zœ á ɓœ zatœ zœ ndœ nœ.» ");
INSERT INTO kxf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Endje kœdɨ mbulu dœ Polo, yé lɔkɔnœ, endje kœna ndjoro ga lœ bɨngɨ nœ ye. Kœto dœ amazɨ œrrr kpii, Polo sœ kolœ kœyisœ 'o tœ upu nœ Ogo gbozu nœ Ndjaba fœ endje kœto tœ mbeti nœ Moyize dœ pe œnœ aayi kœgbara o'o mbœrœ kœma fœ endje adœke endje yindœ Yisu. ");
INSERT INTO kxf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Anga endje sœ lima kœyindœ o'o á tshe sœ kœpa tœnœ, kashe anga endje vwaratœ endje kœyindœ nœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kœgu endje tœ awa, endje sœ lima kœdjitœ endje lœ tœ endje nene; á Polo kpa kœpa ga pa nœ fœ endje adœke: «Tœnœ kœdœ adja o'o nœ Ɔtshɔ Ɨshirɨ á ayi kœgbara o'o Isaya mɨ lima ndœ nœ fœ aata 'e adœke: ");
INSERT INTO kxf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Na ga ndœ azu asœmœ yé œ pa fœ endje adœke: 'e dji dœ ɔtshɔnœ kashe 'e wusœ adanœ nene, 'e mesho dœ ɔtshɔnœ kashe 'e wu dœ ɔtshɔnœ nene. ");
INSERT INTO kxf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Gbambanœ nene, lɔsu azu asœ gbɔɔgbɔ; endje be utu endje dœ pe ala endje ye, mbœrœ endje yiyindœ kœwu œrœ nene, yé œ yiyi ndje ndœ kœdji o'o nene, endje yiyindœ kœfa lɔsu endje fœ mœ dœ́ Ndjaba nene. Yé mœ she bala endje koto o?”» ");
INSERT INTO kxf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Polo kœpa fœ endje adœke: «'E wusœ nœ adœke, Ndjaba vwa kœshe fœ anga angbɨ azu; endje, endje dji bala zœ.»  ");
INSERT INTO kxf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kœdji Polo ataa, Ayuda gitœ endje yé œ tetœ kœshara o'o ugurutœ endje dœ tœ endje. ");
INSERT INTO kxf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Polo mbœrœ lima ungu bisha tshakudu anda dœ ngendja nœ ye dœ tœ ye, yé tshe sœ kœpa o'o dœ azu kɔ á endje sœ lima kœna ga ndœ ye. ");
INSERT INTO kxf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tshe sœ lima kœmɨndœ Ogo gbozu nœ Ndjaba, kœyisœ o'o nœ Gbozu Yisu Kristu dœ awa nene, yé uzu bale kœpakata she gugu lima nene.");
INSERT INTO kxf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Œmœ Polo, ayi akwa nœ Yisu Kristu mœ sœ kœsu mbetinœ asœke fœ 'e. Ndjaba e mœ mbœrœ kœdœ ayi avwa yé tshe ke mœ ndœ kœpandœ Ɔtshɔ O'o nœ ye. ");
INSERT INTO kxf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ɔtshɔ O'onœ á Tshe pa lima ndœ nœ lœ awa nœ aayi kœgbara o'o ala œyerœ Buku, ");
INSERT INTO kxf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","tœ upu nœ Gbolo nœ ye, á endje zu she ɓata uzu lœ uwu aata Davidi. ");
INSERT INTO kxf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Á lœ awa nœ Ɔtshɔ Ɨshirɨ, Ndjaba she lima she lœ akuzu. Tshe yi lima sœ nœ adœke, tshe kœdœ gbolo nœ œne á tshe sœ dœ gbɔgbɔ waa. ");
INSERT INTO kxf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Dœ awa nœ ye œdœ mbœrœ mokɔ nœ ye dá Ndjaba ma ɔtshɔ lɔsu nœ ye ga ndœ mœ yeka á e mœ adœke mœ te ayi avwa nœ ye, dœ́ mœ gbara fœ angbɨ azu kɔ adœke endje sœ dœ kœyindœrœ ga ndœ Yisu Kristu, yé œ dji o'o ama ye. ");
INSERT INTO kxf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","E'e ndje, 'e lœ ugurutœ azunœ asœmœ mbœrœ á Yisu Kristu e ndje 'e. ");
INSERT INTO kxf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ga ndœ 'e dœ́ azu Roma kɔ, Ndjaba yindœ 'e yé tshe e 'e adœke 'e wuta ayerœ azu. Kaka adœke Aba azœ dœ Ndjaba œdœ Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu nœ endje fœ 'e, yé œ za kœsœ gee fœ 'e. ");
INSERT INTO kxf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Utshunœ kɔ, mœ donga Ndjaba nœ mœ lœ awa nœ Yisu Kristu mbœrœ 'e para kɔkɔ. Gbambanœ nene, tshapashɔ djigi sœ kœpa o'o tœ upu nœ kœyindœrœ nœ 'e. ");
INSERT INTO kxf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mœ kœsœ tœ kœyisœ Ɔtshɔ O'o nœ Gbolo nœ Ndjaba, mœ sœ kœmbœrœ akwa nœ Ndjaba dœ lɔsu mœ bale. Yé tshe wusœ nœ adœke mœ sœ tœ kœpa adja o'o, adœke mœ sœ kœgbe dœ e'e lœ avwala nœ mœ. ");
INSERT INTO kxf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ɔlɔ dœ ɔlɔ, mœ sœ kœkɨ fœ Ndjaba adœke œdœ tshe kœyin