﻿USE sofia;
DROP TABLE IF EXISTS sofia.kwj_vpl;
CREATE TABLE kwj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kwj_vpl WRITE;
INSERT INTO kwj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Delehaꞌa Jisas Kurais ri atei hima le hi wuhi. Jisas ri atei, Defit. Wowani Defit ga ri atei, Epuraham. ");
INSERT INTO kwj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epuraham rini Aisak ni rawani Aisak ga Jekop ni rawani Jekop Juta ga ri hiparakambwe lenga wunu ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juta rini Peres hima pe Sira ni ra. E, fi nuwai hi ti, Tema. Peres rini Heseron ni ra. Wowani Heseron ga Ram ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ete wowani Ram ga Aminatap ni ra. Wowani Aminatap ga Nason ni ra. Wowani Nason ga Salumon ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ete wowani Salumon ga Boas ni ra. Boas ri nuwai, Rehap. Wowani Boas ga Opet ni ra. Opet ri nuwai, Rut. Wowani Opet ga Jesi ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ete wowani Jesi ga King Defit ni ra. Wowani Defit ga Solomon ni ra. Solomon ri nuwai, Yuraiya to metengei tini hopwero. ");
INSERT INTO kwj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ete wowani Solomon Riyapoam ni ra. Wowani Riyapoam ga Apaisa ni ra. Wowani Apaisa ga Esa ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ete wowani Esa ga Jehosafat ni ra. Wowani Jehosafat ga Joram ni ra. Wowani Joram ga Asaiya ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ete wowani Asaiya ga Jotam ni ra. Wowani Jotam ga Ehas ni ra. Wowani Ehas ga Hesekaiya ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ete wowani Hesekaiya ga Manasa ni ra. Wowani Manasa ga Emos ni ra. Wowani Emos ga Josaiya ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ete wowani Josaiya Jokonaiya ga ri hiparakambwe lenga wunu ri ra. Ka gisi Isurel himako wunu raꞌaini Bapilon ko ki hima kicha hinga wunu andosiro. ");
INSERT INTO kwj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bapilon ko ki wu dasini Jekonaiya Sialitiyel ni ra. Wowani Sialitiyel ga Serapapel ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ete wowani Serapapel ga Apaiyat ni ra. Wowani Apaiyat ga Elaiyakim ni ra. Wowani Elaiyakim ga Eso ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ete wowani Eso ga Setok ni ra. Wowani Setok ga Ekim ni ra. Wowani Ekim ga Elaiyat ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ete wowani Elaiyat ga Eliesa ni ra. Wowani Eliesa ga Matan ni ra. Wowani Matan ga Jekop ni ra. ");
INSERT INTO kwj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ete wowani Jekop ga Josep ni ra. Wosiwani Josep Mariya ni hopwe. Wosiwani Mariya to Jisas ni rasiwani apa, Kurais, hi rini wu nandau. ");
INSERT INTO kwj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Epuraham kale ri hima kupu hinga tinda ete ta tani Defit ki ambwero ti, tapaꞌangi tapaꞌangi hatachi opuriꞌopuri. Wowani Defit ele ri hima kupu hinga tinda ete ta tani Bapilon ko ki wu daro gisi ambwero ti, tapaꞌangi tapaꞌangi hatachi opuriꞌopuri. Ka Bapilon ko ki wu daro gisi ete ta tani Kurais sukwaro gisi tiki ambwero ti tapaꞌangi tapaꞌangi hatachi opuriꞌopuri. ");
INSERT INTO kwj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Kurais ni raro mwanji mu ka hinga sukwaro. Ri nuwai Mariya Josep ni hopwe kinani mwanji ya wu inji. Wosiwani funda fi tukuya nambwe fi dani Mariya Gotri Himamwale to tini yohosiwani che tinga ya ti da. ");
INSERT INTO kwj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ti hurache, Josep, rini hima kipe naha. O keke ri humwe Mariya ni huruhumba ti ri ha ki ri diyaha. O hinga keke nimba gainani tini andosiwa ti da ki. ");
INSERT INTO kwj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep o tini ete ri hambwandani, tukuki tiki ri tukuyaneheiwani Apukolaka i ensel fori rini tambwa tani ya rini sawe, “Josep, Defit i che, apa mi humwe Mariya mi toro ki aki kei. Ma mendi, o sembe ga dau che oti, o Gotri Himamwale to tini haro. ");
INSERT INTO kwj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Apa hurahama che ni o ti rakonda. Wowa hi rihi ti, Jisas, ma uchasi. Hinde wowani, rini himiyama hurahama wui kapwa sumbu rani ri humbwesini wunu ai ri ratano hima.” ");
INSERT INTO kwj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Delehaꞌa sumbu siraro ti, o imbihumbwa Apukolaka to Gotri mwanji bwarakarandaro hima foi takisopo ki sawero mwanji mwe naha sukwa kinani siraro. Ka Gotri mwanji bwarakarandaro hima ete sawe: ");
INSERT INTO kwj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ma mendi, humwe chongo foti sembe tinga ti dani, hurahama che fori o ti rakonda. Wowa hi rihi ti, Emanuwel, ma ku uchasi.” O hi mwanji mu mwe ti ka hinga: Gotri nunu ga ete dau. ");
INSERT INTO kwj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ete wowani Josep tukuyandaro ti, ri ai saini Apukolaka i ensel rini sawero hinga ri humwe hinga ya ri toro. ");
INSERT INTO kwj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Woroti Josep ri humwe ga tukuya nambwe ete da dawani ri humwe hurahama che ya ti ra. Wowani ri hi ti, Jisas, ya ri uchasi. ");
INSERT INTO kwj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jutiya mapwa tokwe Herot to king apukolaka daro gisi tiki Mariya Jisas ni Betelehem ko tiki ya ti ra. Ti rasiwani dani ini nika sukwa mapwa tokwe dau hambwandau himako Jerusalem ko tiki wu tani ya wu sawe, ");
INSERT INTO kwj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ka che ako, Jutiya himako i king apukolaka waꞌaino che soki dau? Rini ni mekuro isangi nika sukwa tokwe nu heiro. Wosini rini ni lotu nu wo ki nu tanda.” ");
INSERT INTO kwj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ete wowani Herot king apukolaka o mwanji hinga ri mendikoni ete ri apapana. Wowani Jerusalem pe himiyama hurahama wunu okwe o hingambwa ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wofunu Herot ele Jutiya kipe puris hima i apukolaka lenga Gotri lo mwanji hambwandau hima lenga wunu ri wausini ya wunu ri sili, “Ka Kurais so ko ki sirakondau?” ");
INSERT INTO kwj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ete wowani wunu ga ya rini wu sawe, “Jutiya ki dau Betelehem ko tiki. Imbihumbwa Gotri mwanji bwarakarandaro hima ka hinga sawero, ");
INSERT INTO kwj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mini Jutiya kipe Betelehem. Mini apa Jutiya ni aulindau hima laka lei nindo ki jepini mi sirinandau hinga ti, mina. Minambwe naha. Hinde wowani, mini ki hima apukolaka fo sukwakondau, wowa rindo ai hima kupu, Isurel, leni ri aulindakonda.’” ");
INSERT INTO kwj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","O mwanji hinga ti Herot ri mendifuni nika sukwa mapwa tokwe dau hambwandau hima ele ni ya wunu sili, “Hinde gisi naha ki ka isangi siraro?” ");
INSERT INTO kwj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wowani rini wu sawewani wunu ri humbwewani Betelehem ko tokwe wu ikowani ya ri sawe, “Ku ini tau kwambu ku ani ka che ma ku wakinehei. E, ku heiwa mwanji ti ma ku ani humbwewa a mendi. Wowa ani okwe ani ini rini ni a lotu wo.” ");
INSERT INTO kwj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wowani wunu king apukolaka ri mwanji ti wu mendisini ya wu i. Wondawani ka isangi imbihumbwa nika sukwa mapwa tokwe wu heiro o isangi to ai mwaseni ini o che tukuyandau aka tuwo tenge naha ki ya da. ");
INSERT INTO kwj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wosiwani o isangi ni wu heikoni sembe wuhi ti kipe naha ya i. ");
INSERT INTO kwj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ete wosini o aka ki wu raruni wu heiwani o che ri nuwai Mariya ga ya da. Wondawani, wu opulisini seke wuhi ti wu ombungwesini o che ni ya lotu wo. Wosini bokis wuhi ti wu tukwasini ele mwaꞌambwe kipe naha ya rini wu ha, gol, kuwa chele hiki saindau paura ti, e, kuwa chele mwaꞌambwe hi foti, sanda. ");
INSERT INTO kwj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wosini wu tukuyandawani Gotri niliki tukuki tiki autangi mwanji wunu hani ya sawe, “Apa Herot tambwa ku ai i kei.” Ete wowani nurumbu numbo ba fotiki wui ko tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wu isiwani Apukolaka i ensel fo tani Josep ni tukuki tiki ya rini sawe, “Ma saini mi che humwe rani Isip ko laka tokwe akini i. Wosini Isip ko laka tiki ya ma ete dawa mwanji fo mini a sawewa pwe mi bwe ta. Hinde wowani, Herot o hurahama che ni wakineheisini o rini yeni si ki ri hambwandau.” ");
INSERT INTO kwj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","O hinga nawani Josep saini ri che humwe rani Isip ko tokwe niliki ya ete wu i. ");
INSERT INTO kwj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wu isini Isip ko tiki ete wu da dani Herot haro gisi tiki ya wu ambwe. O sumbu hinga siraro ti, ka Apukolaka i mwanji bwarakarandaro hima ri takisopo tiki bwaro mwanji hingambwa mwe naha siraro. Ka hinga ri sawero, “Hurahama che ahi Isip ko tiki o da. Wosiwani rini ani uchawani taro.” ");
INSERT INTO kwj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dani ini Herot hambwahiro, kale nika sukwa mapwa tokwe dau hambwandau hima le rini gamboro. O keke sembe rihi ti enge omwesika ya rini a. Ete wokoni hima fwele ri humbwewani Betelehem ko ga o ko ni takaisini dau ko ele ga tinda ya wu i. Wu ini hurahama che asama fisi diki nambwe ele che hinga tinda ete ya wu yeni si. O sumbu hinga Herot wosiro ti, kale hambwandau himako rini sawero mwanji tini ri ai kilisini asama fisi ni diki nambwe che leni wu ye ki ri sawero. ");
INSERT INTO kwj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ka sumbu hinga ti, Gotri mwanji bwarakarandaro hima, Jeremaiya, to sawero hingambwa siraro. Ka hinga ri sawero. ");
INSERT INTO kwj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wu mendiwani Rama ko tiki ata fo gindani au laka ya ichakanda. Resel to ele ti che le keke ya ti ichakanda. Wondawani ele himiyama hurahama ti sembe hinde tini wu wahapi kumbwa. Hinde wowani, kale ti che tini ga da nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Wosiwani dani ini Herot ya ha. Ete wosiwani Isip ko tiki Apukolaka i ensel Josep tambwa tukuki tiki tani ya rini sawe, “Ma saini o che ri nuwai ga ma fini rani Isurel ko tokwe ai i. Ka che ni yeni si ki hambwandaro hima le hahiro.” ");
INSERT INTO kwj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ete wowani Josep ri saini ri che humwe ga Isurel ko tokwe ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wu ini ya ri mendi, Akeleyas to ri yapai Herot i wa tiki Jutiya lei King apukolaka ri etiro ti. O keke Josep o mapwa ki ri i kinani ya ri aki. Wowani tukuki fotiki Gotri Josep ni sawewani Galili mapwa tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ri ini ko fotiki ya ri liti. O ko hi ti, Nasaret. Woro o sumbu hinga sukwaro ti, Gotri mwanji bwarakarandaro hima lei mwanji hingambwa mwe naha siraro. Wunu ete sawero: “Wunu apa Nasaret pe hima hinga ya rini wu uchakonda.” ");
INSERT INTO kwj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka gisi ki uku yasindau hima, Jon, ya ri sukwa. Wosini Jutiya mapwa ki dau hima da nambwe michi tiki ri dasini ele kipe himiyama hurahama leni Gotri mwanji ti ya wunu ri bwanda. ");
INSERT INTO kwj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wondani ka hinga ya wunu ri sawe, “Kunu kapwa sumbu kuhi ti gumwa ma ku si. Hewen ki da kwambu ti tani takaihiro.” ");
INSERT INTO kwj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Imbihumbwa Gotri mwanji bwarakarandaro hima ri, Aisaiya, to Jon ni ka hinga ri sawero, “Hima da nambwe michi ki hima fori ri takisopo ki ri uchani ka hinga o ri sawenda, ‘Apukolaka ri numbo ma ku nambusini ri ino numbo rihi ti ma ku norukwe.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon kamel kopika tiki wosiro nikaꞌari hime ti ri injisini leti ti himamandemu tiki ri dahapisini omwengape tinga fuku ki dau mwanungwa uku tinga ri andaro. ");
INSERT INTO kwj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka gisi ki Jerusalem kipe hima le, Jutiya pe hima le, e, Jotan gara ki takaisini dau hima le okwe, wunu tinda Jon tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wu tani wui kapwa sumbu amwei wu saweni gumwa wu siwani Jon Jotan gara tiki uku ti ya wunu ri yasi. ");
INSERT INTO kwj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wondawani Jon ri heiwani Farisi hima le, e, Satiyusi hima le uku wunu yasi kinani ya wu ta. Wowani ya wunu ri sawe, “Kunu kapwa hopo to raro che hinga. Namoto kunu sawewani Gotri nomo omwesika kunu hakondau sumbu tini ku hanjaꞌai ki ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","E, kapwa sumbu kuhi mwe naha gumwa ku siro ti nawa, o sumbu kuhi ni chikindau ahirahi mwe kipe ma ku wa. ");
INSERT INTO kwj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kunu inaka kuhi tiki ka hinga apa ku hambwa kei, ‘Epuraham o nui atei.’ O kunu a sawenda! Gotri dele humokuto ni ri sawewa Epuraham i che hinga wu sirano. ");
INSERT INTO kwj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Le laka ti me mu tiki o da. E, ahirahi mwe ti kipe wanda nambwe me ti tinda seni hi tiki humbwesiwa uno. ");
INSERT INTO kwj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Kapwa sumbu kuhi ti gumwa ku siro keke uku minde ki o kunu a yasisinda. Woroti hima fori ai gumwa tokwe tano ti, rini ai kwambu tini ri dikikondau. Ani ai hambwa ti kapwacheche naha, rindo ri hambwa ti omwesika naha. Rini kunu ni uku ri yasino ti, o Gotri himamwale ki hi hinga okunda ki kunu ri yasino. ");
INSERT INTO kwj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Rini sawol hinga tapa rihi tiki ri torosindau. Wosini witi tikisapu tini ri rani rumbwesini witi mwe ti aka tiki ya ri rawarukonda. Wosini o tikisapu usungwahanda nambwe hi tiki ri tuno.” ");
INSERT INTO kwj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ka gisi ki Jisas Galili ri hanjaꞌaisini Jotan gara tokwe ya ri i. Rini Jon uku rini yasi kinani rini tambwa ri iro. ");
INSERT INTO kwj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wowani Jon rini etipesini ya ri sawe, “Hinde wowani ani tambwa mi taro? Uku ti mindo ma ani yasi.” ");
INSERT INTO kwj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ete wowani Jisas mwanji wasa ya rini sawe, “Tambwa mini a sawero hingambwa ma wosi. E, sumbu kipe ti tinda nu chikiwa o kipe naha.” Ete wowani Jon ri mwanji tini ya ri sirina. ");
INSERT INTO kwj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wosini Jisas ni uku yasisiwani metengei ete fwa ri hanjaꞌaisini ya ri sukwa. Wokowani niri ti tuhuwasiwani Jisas ri heiwani Gotri Himamwale ti apwenumwa hinga hangani sikani mwa tenge rihi ki ya liti. ");
INSERT INTO kwj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ete wowani tumwa foti niri we tiki ya uchani sawe, “Dohaꞌa ai che, ani rini keke a wondau. Ani rini keke ani eripendau.” ");
INSERT INTO kwj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wosiwani ka gisi ki Saiten rini simiyanehei kinani Gotri Himamwale Jisas ni humbwewani hima da nambwe michi tiki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wosini Jisas ahirahi nambwe 40 gisi hinga ya ri da. Ete ri da dawani iche tinga ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iche tinga ri handawani rini simiyaneheino hima fori rini tambwa tani ya ri sawe, “E, mini Gotri Che naha nawa, dohaꞌa humokuto mi sawewa sa jamekoni bereti hinga sa sira.” ");
INSERT INTO kwj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ete wowani Jisas mwanji wasa rini hani ka hinga ya ri sawe, “Gotri mwanji ka hinga sawero, ‘Bereti to hima lei himamwale hinde apa okula kumbwa. Mina. Gotri takisopo tiki sukwandau mwanji tumbwa hima lei himamwale okulano.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","O hinga ri nawani Saiten Jerusalem ko tokwe rini raꞌaini rakauni Gotri aka laka tuwo kaumbwa naha ya rini esi. ");
INSERT INTO kwj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Wosini ya rini sawe, “E, mini Gotri Che naha nawa, ma chunani rai. Gotri mwanji ete sawero: ‘Apa Gotri ri ensel leni sawewa wu tani humokuto foti seke mini yehekuno keke wui tapa tenge tiki mini wu lisisini o mini rakaikonda.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wowani Jisas ya rini sawe, “Gotri mwanji kumbwa ka hinga ai sawesinda, ‘Mini apa Apukolaka, mi Gotri, ni simiyanehei kei.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ete ri nawani Saiten Jisas ni ai ra ra kimba hime laka fotiki ya rini rakau. Rakausini Saiten Jisas ni nuwe pe ele ko kwambu hinga tinda ete, e, ele wui mwaꞌambwe kipe naha hinga tinda ete ya rini mekusi. ");
INSERT INTO kwj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wosini Jisas ni ya ri sawe, “E, mi ombungweni mi opulisini ani ni lotu mi wowa, apa delehaꞌa mwaꞌambwe hinga tinda ete o mini ani hakonda.” ");
INSERT INTO kwj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ete wowani Jisas ga rini sawe, “Saiten, ma akini i! Gotri mwanji ete sawero, ‘Apukolaka, mi Gotri, tunumbwa ma lotu wo. Apukolaka ri tau naha tunumbwa ma randa.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","O hinga ri sawewani Saiten rini andosini ya i. Wowani ensel fwele tani Jisas ni ya wu okula. ");
INSERT INTO kwj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wosiwanumbwa Jisas mendiwani Jon kalapus tiki ya rini rawaru. Wosiwani Galili mapwa tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wosini Nasaret ko ri hanjaꞌaisini ri ai ini Kapaneyam ko tiki ya ri da. Kapaneyam ko ti, Sepulan lei nuwe ambwe ga Nafatalai lei nuwe ambwe ga o wui nuwe nindo tiki dau fwa gamba tiki dau. ");
INSERT INTO kwj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ka sumbu sukwaro ti, imbihumbwa Gotri mwanji bwarakarandaro hima ri, Aisaiya, bwaro mwanji hingambwa mwe naha siraro. Rini ete sawero, ");
INSERT INTO kwj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulan mapwa, Nafatalai mapwa, fwanjuwei tokwe indau numbo, e, Jotan gara indau kachi tokwe, ele mapwa ki dau Galili kipe hima kupu ba fwele. ");
INSERT INTO kwj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wunu hundu tiki wu dau ti, hi omwesika okundau ti, wu heiro. Ele himiyama hurahama wunu nurungundume naha ki wu dau ti, apa lindana ti wunu ki sirahiro.” ");
INSERT INTO kwj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka gisi naha ki Jisas ri tau ri rasaini Gotri mwanji ti ri bwani ya ri sawe, “Kapwa sumbu kuhi gumwa ma ku si. Hewen pe kwambu ti tani takaihiro.” ");
INSERT INTO kwj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wosini Jisas Galili fwa gamba tiki eti eti ini heiwani Saimon, ri hi fori, Pita, ri analongo Anduru ga tukwa fwa we tiki ya fi humbwenda. Tukwa fi humbweni omwe torondau sumbu ti o fi ya tau. ");
INSERT INTO kwj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Wondawani Jisas ya fini sawe, “Ma ki tani ani sirina. Wowa apa kini ani ondiyawa hima ani tambwa ki rata.” ");
INSERT INTO kwj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wowani metengei ete tukwa fi andosini Jisas ni fi sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Biya hinga ri ini ri heiwani analongo fopi, Jemis hima pi Jon, fi yapai Sepeti ga kanu we tiki tukwa ya wu wonorukwenda. Wondawani Jisas ya fini ucha. ");
INSERT INTO kwj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ete wowani metengei ete fi yapai kanu we tiki fi andosini rini sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas kale Galili ko hinga tinda ri ini, himiyama hurahama leni wui lotu wo aka tiki ya wunu ondiyakandiyanda. Wondani Jisas Gotri kwambu hima i sembe aulino mwanji kipe naha ni ri bwandani, kale himiyama hurahama ele wui hahungo hinga tinda ete, e, ele wui kapwa tape hinga tinda ete kipe ya ri ai wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jisas ri wosindaro ele sumbu hinga Siriya mapwa laka hinga tinda ete ichiꞌuchawani ya wu mendi. Ete wokoni ele ba fo ba fo hahungo mendindau hima le, seke kapwa tapa kapwa hima le, talihapa dinga ba hima le, seke tapa rikirikinandau hima le, e, himamwale kapwa tinga dau hima le, rini tambwa wunu ratawani kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wondawani kale himiyama hurahama miyafo naha Galili mapwa pe, Dekapolis mapwa tokwe pe, Jerusalem pe, Jutiya mapwa pe, e, Jotan o kachi mapwa tokwe pe, tinda wu tani ya rini wu sirina. ");
INSERT INTO kwj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ete wowani Jisas ka himiyama hurahama miyafo naha ri heifuni kimbache foriki ya ri rau. Ri rau ri lilindawani ri himache le rini tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wowani Jisas ri ondiyakandiyani mwanji ya wunu ri sawe. ");
INSERT INTO kwj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hima fwele wunjenga ete wu hambwawa, wunu Gotri miyaningisopo ki wunu chikinda nambwe. Wowa sa wu eripeꞌaripe. Hinde wowani, hewen pe kwambu o wuhi. ");
INSERT INTO kwj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ichakandau hima le, wunu sa wu eripeꞌaripe. Hinde wowani, Gotri wunu okulawa sembe wuhi o wunu wahapikonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Hima waha hima le, wunu sa eripeꞌaripe. Hinde wowani, ichakai Gotri seke wange o ya wu sirinakonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Sumbu kipe keke iche tinga wunu handau himako sa wu eripeꞌaripe. Hinde wowani, ichai Gotri wunu hawa o wunu talekonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Hima le keke wondau hima le sa wu eripeꞌaripe. Hinde wowani, ichai Gotri hima keke wondau sumbu wasa o wunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Sembe wuhi ti fwa hinga halayasindau hima le, wunu sa wu eripeꞌaripe. Hinde wowani, ichai Gotri o wu heikonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ele hima anayewani alase ki raindau hima le, wunu sa wu eripeꞌaripe. Hinde wowani, ichai Gotri ri che o wunu nakonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ele hima sumbu kipe wu sirinandawani hima ba fwele nomo wunu handau le, wunu sa wu eripeꞌaripe. Hinde wowani, hewen pe kwambu ti o wuhi. ");
INSERT INTO kwj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“E, sembe ani ni ku haro keke hima ba fwele kapwa sumbu kunu wu woni kapwa mwanji ti kunu wu bwani nimba kunu gambowa, kunu ma nimba ku eripeꞌaripe. ");
INSERT INTO kwj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kunu sembe kuhi ti ma ku eripeꞌaripenda. Mwaꞌambwe kipe naha ti hewen ko tiki o dani kunu nikisinda. Woro o hingambwa Gotri mwanji bwarakarandaro hima le wunu okwe nomo wu raro. ");
INSERT INTO kwj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kunu dohaꞌa nuwe ki dau hima lei nindo tiki soliwo hinga ku dau. E, ka soliwo au anda nambwe nawa hinde hinga apa nu wowa au ai ano? Ka soliwo tapa hinga ti, tau nambwe nimba dano. O keke hima le diyahani wu humbweꞌisini seke ki wu yititahumu sindau. ");
INSERT INTO kwj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kunu do nuwe ki dau hima i nindo tiki hi okundau hinga ku dau. E, ko laka foti kimba laka dau mwangi tiki dawa, o apa hinde yani kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hinde na hima to lamu okusini hungwe tako tiki lisino? Mina. Wu okusini tei tenge tiki owesiwa ele aka we tiki dau hima hinga tinda hi ti wu heino. ");
INSERT INTO kwj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","O hinga ku wowa hi kuhi ti kale biya himiyama hurahama i miyaningisopo tiki sa okundawa, o kui sumbu kipe ti sa wu hei. Wondawa kui Yapai hewen ko tiki dau, ri hi tunumbwa ya sa wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kunu apa ka hinga hambwa kei, ani Gotri chengi ki dau Moses kaisiro Gotri lo mwanji tinga Gotri mwanji bwarakarandaro hima i mwanji tinga a humbu ki a taro. Woro mina. Ani o tini a humbu ki a ta nambwe. Ani ele mwanji ni tinda ani ai chiki ki a taro. ");
INSERT INTO kwj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mwe naha ki kunu a sawendau. Do niri ga do nuwe ga humbuno gisi sukwakonda. Woro, apa Gotri chengi ki dau Gotri lo mwanji kairo himikiche fori hinde humbu kumbwa. Gotri chengi ki dau lo mwanji sawesindau sumbu ti tinda ete mwe naha sirakonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","E, hima fori Gotri lo mwanjiche fori ri toroni gumwa tokwe ri humbweꞌisini ri sumbu ni hima fweleni o hingambwa wu wo ki ri mekuwa ori hima hewen ko tiki ri hi ti kapwacheche. E, hima forito Gotri lo mwanji tini sirinandani ele himiyama hurahama leni norukweni ri ondiyakandiyandawa, rini hewen ko tiki hi rihi ti apukolaka. ");
INSERT INTO kwj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mwe naha ki kunu a sawendau. E, kui sumbu kipe ti, kale Gotri lo mwanji hambwandau himako ga Farisi himako ga wui sumbu kipe tini Gotri miyaningisopo ki wunu ku diki nambwe nawa, apa ka Gotri kwambu tinga dau ko tiki hinde ku raru kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kunu ku mendiro, kui atei hima tororo mwanji kati: ‘Apa hima fo yeni si kei. E, hima fori saini hima foni yeni siwa ori hima ni kotimwono.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Woro o tini kunu a sawendau: Hima fori ri hiparakambwe foni sembe enge awa rini koti wo ki sa i. Hima fori ri hiparakambwe ni saweholiyawa rini kanisol apukolaka tambwa sa i. E, hima fori ete sawewa, ‘Mini ambwatinambwati naha.’, wowa rini hi laka ki ri raino. ");
INSERT INTO kwj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“E, mi anguꞌomwe ti humokuto tei tokwe mi ratawa, mi hiparakambwe fori mini omwemendindau ti, ma hambwasini pwe. ");
INSERT INTO kwj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","O nomo mini ki ete dawa ele anguꞌomwe humokuto tei mu tiki ma andosini, ma ini mi hiparakambwe ga ma ki wonorukwesini ai tani pwe, mi anguꞌomwe ti Gotri ni bwe ha. ");
INSERT INTO kwj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“E, hima fori mini kotimwo ki numbo tiki funda ki indawa rini ga metengei ete ma ki wonorukwe. Foki apa koti mendindau hima laka i tapa tenge tiki o mini ri owekonda. Wowa o hima laka ga apa apungwandai kicha hima ri tapa tenge tiki o mini ri owekonda. Ete wowa apungwandai kicha hima ga kalapus we tiki mini rawarukonda. ");
INSERT INTO kwj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mwe naha ki mini a sawendau. Kalapus mi iwa kapwa sumbu mi woro ya tinda ete mi chiki nambwe nawa apa kalapus ti hinde mini andosi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kunu, imbihumbwa kate sawero ku mendiro: ‘Apa anahopwero sumbu ni kapwa sumbu ai wo kei.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Woroti ando ka hinga kunu a sawendau. E, hima fori ri miya ti humwe fotini ri heini ete ri okokonandawa, ori hima ri inaka tiki anahopwendau sumbu tini walambe ri wohiro. ");
INSERT INTO kwj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“E, tapa mama tokwe pe miya mihi to mini matinani raꞌaini kapwa sumbu wowa, ma ongorini humbweꞌi. O hinga mi wowa mini kipe mi dano. Minambwe nawa, o miya kapwa mihi keke hi tiki mini rawaino. ");
INSERT INTO kwj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E, tapa mama mihi to mini matinawani kapwa sumbu mi woni mi hichakowa o tapa mama ma takutoni humbweꞌi. O hinga mi wowa mini kipe mi dano. Minambwe nawa, o tapa kapwa mihi keke hi tiki mini rawaino. ");
INSERT INTO kwj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Imbihumbwa ka hinga sawero: ‘E, hima fori ri humwe ri humbu kinawa, anahopwesini ai humbundau chengi ti sa tini ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Woro o tini kunu a sawendau. E, hima fori, ri humwe hima fonga kapwa sumbu fo ti wo nambwe, nindumwasari tini ri humbuwa ti ini hima foriki ti ai torowa, ti hurache tini humburo keke anahopwendau sumbu tini walambe ti wosindau. E, hima fori imbihumbwa hima fo diyahani ri andosiro humwe tini ri hopwewa, o rini anahopwendau sumbu tini walambe ai ri wondau. ");
INSERT INTO kwj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Atei hima torosiro mwanji fo ku mendiro ti ka hinga: ‘Apa nimba gamboni kari kau mwe naha na kei. E, kari kau mwe naha mi nani sumbu foti mi wo kinawa, Apukolaka i miyaningisopo tiki mwe naha ma ete wo.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Woro o tini kunu a sawendau. Apa kari kau mwe naha na kei. Minambwe naha kunu a nasindau. Apa hewen pe mwaꞌambwe fotini kui mwanji okula ki ku ucha kei. Hinde wowani, hewen oti Gotri ko. ");
INSERT INTO kwj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Apa nuwe pe mwaꞌambwe fotini kui mwanji okula ki ku ucha kei. Hinde wowani, nuwe oti Gotri seke yitindau. Apa Jerusalem ko hi tini kunu okula ki ku ucha kei. Hinde wowani, Jerusalem ko oti King Apukolaka i ko laka. ");
INSERT INTO kwj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","E, apa mi mwa tini mwanji mini okula ki ucha kei. Hinde wowani, apa mwa kopika mihi foti mi wosiwa wamwaꞌa ke hinga hinde sira kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Ei’ gambwa ‘Mina’ gambwa ma ku sawenda. Ori yakito. Kale inakahambwa mwanji ku sawendau ti Saiten ki sukwandau. ");
INSERT INTO kwj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Injelembwa ka hinga wu sawero ti ku mendiro: ‘E, hima fori mi miya ti ongoriwa, mini okwe wasa ma rini ongori. E, hima fori mi fu ti ri yetupuwa, mini okwe ri fu ti wasa ma rini yetupu.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Woro o tini kunu a sawendau. Apa kapwa sumbu woro hima ni wasa ai wo kei. Minambwe naha. E, hima fori warama tiki mini ri yetapewa, warama angi tokwe ma tinda rini hasiwa sa mini yetape. ");
INSERT INTO kwj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hima fori mini kotimwoni ki pe siyoti mihi ti ri raꞌai kinawa, heiye pe siyoti okwe ma tinda ete rini ha. ");
INSERT INTO kwj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","E, hima fori mini amayiti amayitini numbo fai tiki ki i ki mini ekichasiwa mini ga mi ai rini ra ra numbo hime tiki ma ki i. ");
INSERT INTO kwj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","E, hima fori mwaꞌambwe keke mini ri siliwa, ma rini ha. E, hima fori mini ki mwaꞌambwe fwele nimba ri raꞌai kinawa, apa gumwa rini si kei. ");
INSERT INTO kwj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kunu imbihumbwa ku mendiwani ete sawero ti: ‘Mini mi hima sopu ni ma okokona. Wosini o mini omwemendindau hima ni sembe kapwa ma rini hambwa.’ ");
INSERT INTO kwj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Woroti ete o kunu a sawenda. Kunu ele kunu omwemendindau hima leni ma ku okokonasini wunu keke Gotri ni ma ku uchahambwawa Gotri ele kapwa sumbu kunu ni wosindau hima leni sa wunu okula. ");
INSERT INTO kwj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","O hinga ku wosiwa kunu hewen ko tiki dau kui Yapai ri che hinga ku dano. Kui Yapai Gotri rini tapwaki nika ti ele kapwa hima le keke ri wosini, e, hima kipe le keke okwe ri wosiwani sukwanda. Wosini mwa ti o hingambwa ele sumbu kipe wosindau hima le keke, e, kapwa sumbu wosindau hima le keke funda ete ri wosiwani sikandau. ");
INSERT INTO kwj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","E, kunu ele kunu okokonandau hima lembwa ku okokonawa bwele mwaꞌambwe wasa hinga tini Gotri kunu hano? Takisi ya torondau hima le okwe wunu o hingambwa wu wosindau. ");
INSERT INTO kwj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kunu kui hiparakambwe lenga ku anaweseꞌawa ele biya hima ba fweleni bwele sumbu hinga ki wunu ku dikino? Hinde wowani, kale biya hima ba fwele okwe o hingambwa wu wosindau. ");
INSERT INTO kwj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kunu kipe naha kumbwa ma funda ete ku da, ka kui Yapai hewen ko tiki kipe naha kumbwa ri dau hinga. ");
INSERT INTO kwj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kunu hambwafwaꞌai, apa sumbu kipe kuhi ti wui miyaningisopo ki hima kunu hei kinani ku wosinda kei. E, o sumbu hinga ku wosiwa apa kui Yapai hewen ko ki ri dau ti, mwaꞌambwe wasa hinde kunu ha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mwaꞌambwe ti bwarichape hima ni ku ha kinawa, apa hambangini ti hima i miyaningisopo tiki wuichi wuichi mwaꞌambwe raꞌai ku ha kei. Kunu apa kale hima lotu wondau aka ki, e, numbo ki wu raruni hi wuhi tini wu rasai ki nimba gamboni wu wondau sumbu hinga ku wo kei. Mwe naha ki kunu a sawendau. Hima le hi wuhi wu rasairo keke wunu sumbu wasa wuhi wu torohiro. ");
INSERT INTO kwj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ele bwarichape hima fweleni mi okula kinawa, apa tapa usanji mihi ti tapa mama wosindau sumbu kipe tini heini hi rasai kei. ");
INSERT INTO kwj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","O hinga mi wosiwa apa ele hima okulandau sumbu mihi ti yanisini dawa mi Yapai wanisini dau mwaꞌambwe ele ni amwei ri heini mwaꞌambwe wasa o mini hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Gotri ni ku uchahambwa kinawa kunu apa nimba gambondau himako le wosindau hinga ku wosi kei. Wunu hima leto wunu hei ki lotu wondau aka laka ki, e, numbo laka gamba tiki saini wu etisini Apukolaka ni uchahambwandau hinga wu uchahambwandau tini wu okokonandau. Mwe naha ki kunu a sawendau. Wunu wu wosindaro sumbu wasa wuhi wu tororo. ");
INSERT INTO kwj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Woroti, Apukolaka ni mi uchahambwa kinawa, mi tukuyandau aka tipa mihi ki ma raruni aka ti mi ai dimisini mi Yapai yanisini dau tini ma rini uchahambwa. Wowa Yapai mihi, ele wanisini dau mwaꞌambwe hinga tinda ri heindau ki, mwaꞌambwe wasa o ai mini hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Apukolaka ni ku uchahambwa kinawa, apa sembe ha nambwe hima ba fweleto mwanji miyafo Gotri ni bwandau hinga ku bwanda kei. Wunu ka hinga wu hambwandau, mwanji miyafo wu bwawa Gotri apa o wunu mendikonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kunu apa wui sumbu tini ku sirina kei. Hinde wowani, kui Yapai ni ku ucha nambwe ku dawani rini ele mwaꞌambwe ku heifundau ti rini metengei hambwasindau. ");
INSERT INTO kwj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ka hinga ma ku uchahambwa: Nui yapai Apukolaka, mini hewen ko tiki mi dau, hi mihi ti kipe naha tumbwa ya sa wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kwambu mihi sa tani sa nunu aulinda. Wosiwa mi okokona tumbwa hewen ko tiki wu sirinandau sumbu hinga nunu do nuwe ki o hingambwa nu sirinanda. ");
INSERT INTO kwj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Apa ahirahi ti do gisi ki nu ano hinga ma nunu ha. ");
INSERT INTO kwj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kapwa sumbu nuhi ti ma rani rumbwe, kale hima kapwa sumbu nunu wosiwani nu rani nu humbwero hinga. ");
INSERT INTO kwj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Apa simiyanehei sumbu hinga ki nunu raꞌai kei. Saiten tapa tenge ki nu dano keke ma nunu leningimbani rata. Kwambu laka mihi tinga hi laka mihi tinga mihi kumbwa sa ete da ete da. Mwe naha. ");
INSERT INTO kwj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ma ku mendi. E, kunu ele biya himiyama hurahama kapwa sumbu wuhi ti ku rani ku rumbwewa, kui Yapai, hewen ko ki dau ti, rini okwe kui kapwa sumbu ti o ri rani rumbwekonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","E, kunu ele himiyama hurahama lei kapwa sumbu ku rani ku rumbwe nambwe ti nawa, apa kui Yapai, hewen ko ki ri dau, ti okwe kapwa sumbu kuhi ti hinde rani ri rumbwe kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wosini ahirahi ti Gotri ku hambwa ki ku haki kinawa apa miyaningisopo kuhi ti nimba gambondau hima lei sumbu hinga ku rata kei. Wunu wu hakini kapwa miya naha wu sirandau. O hinga wu wosiwa ele himiyama hurahama ka hinga wunu hambwa ki, dele bai hima ahirahi hakindau. Mwe naha ki kunu a sawendau. Wunu o sumbu wasa wuhi ti wu tororo. ");
INSERT INTO kwj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Woroti, mini ahirahi ti mi haki kinawa, weli ti mi toroni mwa simba mihi tiki ma hindini uku ti miyaningisopo mihi ma yoko. ");
INSERT INTO kwj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wosiwa ele hima ahirahi mi hakindau sumbu hinga hinde apa wu hambwa kumbwa. Mi Yapai yanisini dau tombwa o tini ri hambwandau. O keke mi Yapai ele yanisindau mwaꞌambwe tinda ri heindau ti, wasa o mini hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kunu apa mwaꞌambwe kipe naha kuhi le do nuwe ki ku waunda kei. Dohaꞌa nuwe ki dau owechehopoche le ele mwaꞌambwe ni wu andawa mwaꞌambwe fwele se ya yekonda. Wondawani hili yandau hima le okwe aka ti setapweningisini raruni mwaꞌambwe le hili wu yandau. ");
INSERT INTO kwj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","O hinga ti keke mwaꞌambwe kipe kuhi ti hewen ko kipe sumbu ni ku sirinani ma ku wo. O hinga ku wowa hewen ko ki mwaꞌambwe kipe ni ku waundau. Hewen ko tiki, owechehopoche le andau sumbu ti, se yendau sumbu ti, e, hili yandau sumbu ti, ele sumbu hinga ti da nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mwaꞌambwe kipe mihi dau ko tiki inaka mihi okwe o ko ki dau. ");
INSERT INTO kwj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Miya nuhi ti lamu hinga. E, Miya mihi ti kipe naha ete dawa tape mihi ti tinda lindana sindau hinga. ");
INSERT INTO kwj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","E, miya mihi ti sawa, tape mihi ti mini hundu sindau hinga. O hinga keke sembe mihi ki dau hi ti oku nambwe nawa hundu ti omwesika naha. ");
INSERT INTO kwj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hima fori hacha fisi ki tau ti hinde ri ra kumbwa. Apa o hinga ti forini sembe amwaka ri ani fori keke ri wono. Wosini forini sirinakoni apa forini gumwa sino. Kunu apa Gotri numbo tinga ya mwaꞌambwe tandau numbo tinga fisi ku sirina kei. ");
INSERT INTO kwj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“O keke ka kunu a sawenda, kunu apa kui sembe tupu keke inaka bongo miyafo ku hambwani ete sawe kei, ‘Apa ahirahi bweleni nu ano? Uku sumbwe bweleni nu ano?’ Wondani apa kui tape ti keke ku hambwani ete ku sawe kei, ‘Ka bwele nikaꞌari ki nu injino?’ O sumbu hinga ti, himamwale kuhi ti ahirahi kekembwa ku woni, e, hima tape kuhi ti nikaꞌari ti kekembwa ku wondau. Woroti, himamwale kuhi ti, ele ahirahi ni dikini tape kuhi ti ele nikaꞌari ni dikindau. ");
INSERT INTO kwj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Me pe apwe le ma ku mauni hei. Wunu mwaꞌambwe keke inaka tenge wu hambwanda nambwe. Wunu ahirahi le kisini wu eini wu ratani aka tiki wu waunda nambwe. Kui Yapai hewen ki dau tombwa rindo ahirahi ti wunu ri yakwandau. Woro kunu apwe leni ku dikindau. ");
INSERT INTO kwj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hinde na hima kuhi forito rinjenga ri inaka tiki himamwale rihi tini kamindache ri ai ondiyasiwa gisi huwe hinga ino? Minambwe naha. ");
INSERT INTO kwj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Hinde wowani kunu nikaꞌari mwaꞌambwe ti keke inaka tenge miyafo naha ku hambwandau? Kale rupwa ki dau wariko ma ku hei. Hinde hinga wu sirandau? Wunu tau kwambu wu rani nikaꞌari wu wosinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Woroti ete kunu a sawenda. Imbihumbwa Solomon rini mwaꞌambwe kipe miyafo naha. Woroti rini ka wariko buyani kaꞌapwe kipe naha sirandau hinga tini ri dikisini ri soꞌoi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Apa dele fuku ki saindau ki le, icheki sarepi tiki wu yekutosini hi tiki wu humbwewa uno. Woroti, kale nimba dau ki le Gotri to wariko kipe wunu hani nimba wunu ri enependau. O hinga keke kunu dele himiyama hurahama ku dau ti, mwe naha ya ma ku hambwa. Gotri kipe naha o kunu gwarosikonda. Sembe ha sumbu kuhi ti kapwacheche naha. ");
INSERT INTO kwj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kunu apa inaka tenge miyafo naha ku hambwandani ete ku sawe kei, ‘Ka bwele a ni nu ano? Ka uku sumbwe bweleni nu ano?’ ");
INSERT INTO kwj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mina. Ele hima ba fweleto ele mwaꞌambwe keke ete wondani ra ki wu hambwandau. Woroti, kui Yapai hewen ko tiki dau to rini ri hambwasindau, ahirahi ku andani nikaꞌari le ku injisini ku dau tini. ");
INSERT INTO kwj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Woroti o keke kunu ri sumbu kipe tinga ri kwambu tinga ma ku wakinehei. Wosiwambwa kale mwaꞌambwe kipe Gotri o kunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","O hinga ti keke, kunu icheki kipe mwaꞌambwe tini ku hambwa kei. Icheki kipe mwaꞌambwe kuhi ti icheki pwe ku bwe hambwa. O gisi kipe nomo mihi ti, o o gisi ki mi bwe ra. ");
INSERT INTO kwj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kunu apa hima fwelei sumbu ni kili kei. Foki apa Gotri okwe o kunu kilikonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kale hima i sumbu ni kilindau tapa hinga ti, ichai Gotri okwe o hingambwa o kunu kilikonda. E, kale hima fweleni ku heini ku hambwasini wunu ku wosindau hingambwa ichai Gotri okwe o hingambwa o kunu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hinde wowani mi hiparakambwe miya tiki mi misini kapwa rungoche fori dau ti mi heindau, woro mindo mi hambwa nambwe, mi miya tiki kapwa rungo laka foti dau ti? ");
INSERT INTO kwj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bwele keke mi hiparakambwe forini ete mi sawendau, ‘Apwai, ani mi miya pe kapwa rungo ti a rani a rawaka ki,’ woroti mini okwe kapwa rungo laka foti mi miya ki o da? ");
INSERT INTO kwj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mini nimba gambo hima. Metengei mi miya tiki dau me rungo laka tini ma rani humbweꞌi. Wosini miya mihi ti norukweni mi hei hei pwe mi hiparakambwe miya pe kapwa rungo ti mi bwe rani rumbwe. ");
INSERT INTO kwj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Apa Gotri okokonandau mwaꞌambwe kipe naha mihi ti asa tini si kei. E, apa soluwara kipe yaso kipe naha mihi le fe tini si kei. Foki apa wu yititambisekoni jamekoni o kunu sekonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kunu Gotri ni mwaꞌambwe keke ma ete ku uchahambwanda. Wowa o mwaꞌambwe Gotri o kunu ri hakonda. Kunu mwaꞌambwe keke ma ete ku wakinda. Wowa ku wakini o ku heikonda. Aka lengenumbo ma ete ku yenda. Wowa Gotri o kunu dungwasikonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","E, hima fori Gotri ni ete ri uchahambwandau ti, mwaꞌambwe ete ri torondau. Hima fori mwaꞌambwe ti ri hei kinani ete wakindau ti, ori hima o mwaꞌambwe heindau. E, hima fori aka lengenumbo tini ete ri yendau ti, Gotri o aka lengenumbo ti rini dungwasindau. ");
INSERT INTO kwj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“E, che fori tani ri yapai ni nakuhopo mwanji rini bwawa, apa ri yapai humokuto tini rini hanoꞌo? Mina. ");
INSERT INTO kwj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","E, che fori tani ri yapai ni fwaiꞌomwe mwanji rini nawa, apa kapwa hopo tini rini hanoꞌo? O okwe mina. ");
INSERT INTO kwj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kunu, kapwa hima le, kale che kuhi ni mwaꞌambwe kipe naha ti ku handau. O keke ma ku hambwa, hewen ko ki dau Yapai kuhi okwe, rini ni uchahambwandau hima leni mwaꞌambwe kipe naha ti kui che leni ku handau hinga kunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kale biya hima ele sumbu kipe kunu ni wo ki ku okokonandau hingambwa kunu okwe o hingambwa ma wunu wo. Moses kaisiro Gotri lo mwanji ga Gotri mwanji bwarakarandaro hima i mwanji okwe wui mwanji mu mwe ti o hingambwa. ");
INSERT INTO kwj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kunu numbo cheche ki ma ku ini ku raru. Hi tokwe raindau numbo ti omwesika naha, wosini bwanja laka. Himiyama hurahama miyafo naha o numbo ni wu sirinani indau. ");
INSERT INTO kwj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Woro, himamwale kipe torondau numbo ti tingiche, wosini tau kwambu naha. Ka numbo tingiche hima funda funda naha tombwa rarundau. ");
INSERT INTO kwj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kunu kale Gotri mwanji gamboni bwarakarandau hima leni ma ku hambwafwaꞌai. Wunu omwe tupu tini injisini hima kipe hinga wu gambosini kunu tambwa ele tanda. Woro, sembe we wuhi ti fuku pe kapwa asa hinga. ");
INSERT INTO kwj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wui sumbu ki ahirahi mwe sukwawa kunjenga amwei naha o wunu ku kilikonda. Mondo tuko ti lame chele kapwa kupu ki sirandauꞌu? Wate mwe ti gama ki wandauꞌu? Mina. ");
INSERT INTO kwj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Woro hingambwa ele me kipe hinga mwe kipe naha tumbwa wandani, e, me kapwa hinga mwe kapwa naha tumbwa wandau. ");
INSERT INTO kwj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","E, me kipe ti mwe kapwa hinde apa wa kumbwa. Wowa me kapwa ti mwe kipe hinde apa wa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ele me, mwe kipe wanda nambwe hinga ti, wu seni wu humbweꞌini wu wausini hi tiki tinda ete wu tundau. ");
INSERT INTO kwj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Woro kale nimba gamboni Gotri mwanji bwarakarandau hima lei sumbu ki sukwandau ahirahi tini ku heisinimbwa o hingambwa o wunu ku hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kunu himiyama hurahama ka hinga apa ku hambwa kei. Ani ni ‘Apukolaka, Apukolaka,’ uchandau hima le tinda ete hewen ko ki wu raruno. Woro mina. Ai Yapai okokona tini sirinani indau hima tombwa hewen ko ki raruno. ");
INSERT INTO kwj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ka gisi jipe tawa ele himiyama hurahama miyafo ani sawekonda, ‘Apukolaka, Apukolaka, nunu hi mihi tiki Gotri mwanji nu bwandani hi mihi tiki kale himamwale kapwa nu rani nu humbweꞌindani, e, mi hi tukumbwa kale ba fo ba fo sumbu kwambu nu wo nambweꞌe?’ ");
INSERT INTO kwj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Woro o gisi kumbwa ka hinga wunu a sawekonda, ‘Ani kunu a hikisandau. Kunu kapwa sumbu ku wondaro hima. Ma ku akini i.’ ");
INSERT INTO kwj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“E, hima fori ele ai mwanji ni ri mendini ani ni ri sirinandawa ori hima inakahambwa to aka rihi ti humokuto tenge tiki ri kiro hinga. ");
INSERT INTO kwj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wosiwani mwa laka yeni, fwa omwesika taleni, e, ausuwa kwambu naha ki sini o aka hinde apa lendo kumbwa. Hinde wowani, o aka humokuto tenge miyafo nindo tiki ri kiro. ");
INSERT INTO kwj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","E, hima fori ele ai mwanji ni ri mendini ri sirina nambwe nawa ori hima ambwatinambwati to hapi mwai tenge tiki aka ri kiro hinga. ");
INSERT INTO kwj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wosiwani ausuwa hapa tinga saini mwa laka yeni fwa omwesika talekoni aka o tini ekichakowani metengei ete lendoni walambe naha ete iro.” ");
INSERT INTO kwj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas ele mwanji rihi ri bwani ri humbukowani ele himiyama hurahama miyafo naha o mwanji ni wu mendini ete ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hinde wowani, rini Gotri lo mwanji hambwandau hima hinga wunu ri ondiyakandiya nambwe. Mina. Rini kwambu torosini randau hima hinga wunu ri ondiyakandiyandaro. ");
INSERT INTO kwj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wosini rini kimba oti ri hanjaꞌaisini ya ri rai. Wowani ele himiyama hurahama miyafo rini sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wowani sechi okwe andau hima fori tani Jisas mu tiki ri ombungwesini ya ri sawe, “Apukolaka, sembe mihi au mini saiwa mi ani okulawa hahungo ahi sa humbuwa tape kipe naha a sira.” ");
INSERT INTO kwj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wowani Jisas tapa rihi ti dachinani rini haiyesini ya rini sawe, “Sembe ahi ti au ani sainda. Mini kipe ma wosi.” Ete wowani metengei ete sechi okwe rihi ti ete humbuwani ori hima kipe naha ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wosiwani Jisas ya ri sawe, “Ma mendisini hambwafwaꞌai. O sumbu mi ini apa hima forini sawe kei. Gotri aka laka ki dau puris hima tambwa ma ini mi tape ti ma rini meku. Wosini Moses kaisiro Gotri lo mwanji sawendau hinga sumbwe dau anguꞌomwe mi torosini kipe ti mini wosiro ti keke Gotri ni ya ma ha. Mi hasiwa ele hima miyafo sa wu hambwa, sechi okwe mihi ti humburo.” ");
INSERT INTO kwj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ete wosini Jisas Kapaneyam ko tiki ri raruwani 100 au anaye hima le wui apukolaka, rini Rom kipe, ri tani mwanji miyafo ki ka hinga ya rini sili, ");
INSERT INTO kwj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apukolaka, ai tau ra himache fori hahungo omwesika naha ri mendindani aka ki o kaka tukuyanda. Talihapa rihi ti funda dinga ba naha. Wosini amwaka omwesika naha ri mendindau.” ");
INSERT INTO kwj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ete wowani Jisas ga mwanji wasa ya rini sawe, “Ani ini kipe o rini a wosikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ete wowani ele au anaye hima lei wui apukolaka rini ga mwanji wasa ka hinga ya ai rini sawe, “Apukolaka ani hima kapwacheche. Ai aka tiki mi sira to sa biya da. Mwanji tini ma nimba sawewa tau ra himache ahi kipe sa wosi. ");
INSERT INTO kwj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hinde wowani, ani okwe hi chele hima ri tako tokwe a dawani rindo ani aulisindau. Dele ai au anaye himache le okwe ai tako tokwe wu dau. E, ai himache forini ete rini a sawewa, ‘Mini ma i,’ wowa rini apa ri i sindau. E, ai himache ba forini ete a sawewa, ‘Mini ma ta,’ wowani rini ya ri tau. E, ai tau ra himache foni ete a sawewa, ‘Mini do tau ma ra,’ wowani o tau ya ri rau.” ");
INSERT INTO kwj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ete wani Jisas o mwanji ni ri mendikoni ya ri apapana. Wokoni ele rini sirinani indau hima leni ya ri sawe, “Mwe naha ki kunu a sawendau. Isurel hima foni ani heiwani dori hima, ri sembe ha sumbu hinga fo da nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Woro apa kunu a sawenda. Himiyama hurahama miyafo nika sukwa mapwa tokwe, e, nika rai mapwa tokwe ele wu takonda. Wu tani Epuraham, Aisak, Jekop wunu ga hewen ko tiki wu litini ahirahi o wu akonda. ");
INSERT INTO kwj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Woroti, Gotri rihi naro Isurel hima kupu le, sembe ha nambwe leni, ri sawewa hundusindau hoko ki wunu rawarano. Wosiwa ka mapwa ki ichaka omwesika naha ti wu ichakandani, fu wuhi ti wu tangindomunandano.” ");
INSERT INTO kwj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wosini Jisas au anaye hima lei wui apukolaka ori ni ya ri sawe, “Mini ya ma i. Ai okokona ti, mini ki sukwano sumbu ti sembe mi ani haro hinga o sukwakonda.” Wosiwani o ri sawero gisi naha ki ori hima ri tau ra himache kipe ya ete ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wosini Jisas Pita i aka tiki ri raruni ri heiwani Pita atako ti hahungondani tape hi ti ya tini sainda. ");
INSERT INTO kwj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Wowani Jisas ti tapa ti ya ri toro. Wosiwani o tape hi tini saindaro ti ya humbu. Ete wowani ti saini Jisas ahirahi tini ya ti ratoronda. ");
INSERT INTO kwj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dani ini sunduya ki ele himamwale kapwa dau himiyama hurahama miyafo ni wu rani Jisas tambwa ya wu rata. Wowani mwanji ri sawewani ele himamwale kapwa sira akini ya inda. Wondawani ele hahungo dau hima le kipe ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O hinga ri wosiro ti, imbihumbwa Gotri mwanji bwarakarandaro hima ri, Aisaiya, bwaro hinga ya ri chiki. Aisaiya ka hinga ri bwaro: “Rinjenga hahungo nuhi ti ri rani ri raꞌairo.” ");
INSERT INTO kwj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wosini Jisas ri heiwani himiyama hurahama miyafo rini ni haweisiwani ya ri sawe, “Ma, fwanjuwei angi tokwe nu rachi.” ");
INSERT INTO kwj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ete wowani Gotri lo mwanji hambwandau hima fori tani ya rini sawe, “Ondiyakandiyandau hima, ai okokona ti, ele mapwa hinga mi ino ti mini a sirinani funda si i ki.” ");
INSERT INTO kwj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wowani Jisas ga mwanji wasa ya rini sawe, “Dache le wunu nuwe sopu tiki dau. Me pe apwe le wunu woto wuhi tiki wu tukuyandau. Woro dori Hima ri Che to mwa rihi ti mwasakimbe ri rasaisini ri tukuyano michi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ete wowani himache rihi foringa ya rini sawe, “Apukolaka, mi ani ohounawa ani ini ai yapai ani eini a sisini pwe.” ");
INSERT INTO kwj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ete wowani Jisas ya ri sawe, “Sa biya da. Ani hikisandau hima leto wui nindo tiki haro hima ni sa wu eini si. Woro mini ani ni ma sirinani tawa si i.” ");
INSERT INTO kwj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wosini Jisas kanu tenge tiki ri rauwani ele ri himache okwe ya rini wu sirinani ya wu rau. ");
INSERT INTO kwj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ete wowani ausuwa laka fwanjuwei o tiki saikowani fwa oti yembekinani ya wunu yewalikonda. Woro Jisas rini tukuyandaro. ");
INSERT INTO kwj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wondawani wu ini rini wu yetelesini ya rini wu sawe, “Apukolaka, mini ma nunu okula. Walambe ya nunu ikondau.” ");
INSERT INTO kwj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wowani ya wunu ri sawe, “Hinde wowani ku akindau? Sembe kuhi Gotri ni ku haro ti kapwacheche naha.” Wosinumbwa ri saini ausuwa tinga fwa o tinga ya ri sawe. Wokowani ausuwa oti humbuwani fwa oti gamweche ai yembekina nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","O hinga ri wosisiwani wunu inaka tenge miyafo naha wu hambwandani ya wu sawe, “Kari hinde na hima hinga ri dasini fwa tinga ausuwa tinga ri sawewani ri mwanji ni sirinani gainaro?” ");
INSERT INTO kwj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wosini Jisas ri ini fwanjuwei angi tokwe Gatara lei nuwe tiki ya ri rachi. Wowani himamwale kapwa dau hima fisi, matimat tiki fi daro ti, fi tani ya rini fi hei. Fini au hima naha. O keke ele himiyama hurahama o numbo wu i kinani ya wu akinda. ");
INSERT INTO kwj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Woro findo hapa tinga fi uchani ya fi sawe, “Mini Gotri che, bwele sumbu hinga tini nunu mi wosikondau? Mwanji nunu mi bwano gisi jipe ti wayambwa. Ahaꞌa nimba nunu ni amwaka mi ha kinani mi taroꞌo?” ");
INSERT INTO kwj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wondawani fe miyafo naha apahime hingache wu dani nuwe wu uyanda. ");
INSERT INTO kwj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wowani ele himamwale kapwa to hapa tinga wu uchani Jisas ni ka hinga ya wu sawe, “E, nunu mi rani mi humbwe kinawa, kale biya fe miyafo naha dau ki ma nunu humbwewa nu ini nu raru.” ");
INSERT INTO kwj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wowani ya wunu ri sawe, “Ma ku i.” Ete wowani opi hima fisi wu andosini wu ini ele fe ki ya wu raru. Wowani ele fe hapa tinga wu namani wu ini kapwa kimba tiki wu raini fwanjuwei o ki uku sumbwe ti wu ani ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ete wowani ele fe aulini dau hima le okwe wu akini wu ini ko laka ki wu raruni ele sumbu hinga sukwaro tini tinda ya wu sawe. Wu sawero bomo foti himamwale kapwa ga daro hima fisi opi ki sukwaro sumbu tini wu sawero. ");
INSERT INTO kwj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ete wowani o ko laka kipe himiyama hurahama le Jisas ni wakini wu tani ya rini wu hei. Wosini mwanji kwambu tiki ya rini wu sawe, kahaꞌa nuwe wuhi ri andosini mapwa fo tokwe ri i kinani. ");
INSERT INTO kwj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ete wowani Jisas kanu tenge tiki ai ri rauni ri litisini fwanjuwei angi tokwe dau ri ko tokwe ya ri rachi. ");
INSERT INTO kwj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ri rachisiwani talihapa dinga ba hima forini tei tenge tiki rini wu owesini Jisas tambwa ya rini wu rata. Wowani Jisas wui inaka ti ri heiwani rini ni sembe ti wu hasindau. Wosiwani Jisas talihapa dinga ba wosiro hima o rini ya ri sawe, “Ai che, sembe mihi sa wahapisi. Mi kapwa sumbu ti a rani a humbweꞌihiro.” ");
INSERT INTO kwj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ete wowani kale Gotri lo mwanji kipe naha hambwandau hima fwele wui inaka tiki ka hinga ya wu hambwa, “Dori hima Gotri ni saweholiyandau.” ");
INSERT INTO kwj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","O hinga wu hambwawani Jisas wui inaka ti ri hambwahiro. Wosini ya wunu ri sawe, “Hinde wowani kui inaka ki o inaka kapwa hinga ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Woro, so mwanji to amwei naha, e, ete a sawewa, ‘Mi kapwa sumbu a rani a humbweꞌihiro,’ wo ete a sawewa, ‘Kipe mi wosini ma saini ya i’? ");
INSERT INTO kwj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dori Hima ri Che kwambu torosini do nuwe pe hima i kapwa sumbu rani humbwendau, o sumbu ni ku hambwa kinani apa sumbu fo kunu a mekukonda.” Jisas o hinga ri sawesini talihapa dinga ba dau hima ori ni ya sawe, “Ma saini mi minatopo toroni mi aka tokwe ya i.” ");
INSERT INTO kwj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O hinga ri nawani ri saini ri aka tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ete wowani kale himiyama hurahama miyafo o tini wu heini wu akikoni ya wu hambwa, Gotri ka kwambu hinga o hima ni haro tini. Wondani Gotri hi tini ya wu rasai. ");
INSERT INTO kwj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dani ini Jisas ri ini ri heiwani, hima fori takisi ya torondau aka tiki lininda, hi rihi ti Matiyu. Wowani Jisas ya rini sawe, “Mini ma tani ani sirina.” Ete wowani ri saini ri tani Jisas ni ya ri sirina. ");
INSERT INTO kwj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dani ini Jisas aka we rihi tiki linindani ahirahi ri andawani takisi ya toro hima miyafo naha, e, Gotri lo mwanji hikisandau hima miyafo naha ya wu ta. Wu tani Jisas ga ri himache lenga wu litisini ahirahi ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wu andawani ele Farisi hima Jisas himache leni wu heini ya wu sawe, “Hinde wowani kui Apukolaka ri ele takisi ya torondau hima, e, Gotri lo mwanji hikisandau hima lenga ahirahi ri andau?” ");
INSERT INTO kwj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wowani Jisas o hinga ri mendini ya ri sawe, “Hahungo mendinda nambwe hima le wunu apa dokita tambwa hinde wu i kumbwa. Mina. Hahungo mendindau hima letombwa apa dokita tambwa ino. ");
INSERT INTO kwj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kunu ma ini Gotri chengi tiki dau ka mwanji ni ma ku hambwanda. Gotri ete sawero: ‘Ani anguꞌomwe ani ni handau sumbu ti a diyaha. Ani hima keke wondau sumbu tini ani okokonandau.’ Ani ele hima kipe ni ucha ki a ta nambwe. Mina. Ani ele kapwa sumbu wondau hima le kekembwa a taro.” ");
INSERT INTO kwj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","O gisi hinga ki gisi fo Jon ri himache le Jisas tambwa tani ya rini wu sawe, “Hinde wowani nunu ga ele Farisi hima lenga ahirahi nu hakindawani ele himache mihi to ahirahi hakinda nambwe?” ");
INSERT INTO kwj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wowani Jisas ga ya wunu sawe, “E, hima fori humwe apambwa naha hopwesini ele ri hima kupu lenga ete ri dawa ele hima sembe nomo hinde wu a kumbwa, mina. Woro dani ini ichekaimbwa rini toroningini raꞌaino gisi kumbwa ri hima kupu le ahirahi ti ya wu hakikonda. ");
INSERT INTO kwj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Hima fori nikaꞌari ako sumbu foti ratasini nikaꞌari simba sopu fotini apa hinde kapa kumbwa. O hinga ri wosiwa, apa o nikaꞌari ako sumbu sopu o tini yekichani kapasiro gamba tokwe ai lefeheno. Wosiwa sopu ti apa omwesika naha. ");
INSERT INTO kwj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","E, hima fori waini uku ako ti omwe tupu ki wosiro kowe simba tiki apa hinde guto kumbwa. O hinga ri wowa apa waini uku oti sukwa talekoni omwe tupu ki wosiro kowe o tini lefehewa waini uku oti lohohonani sikano. Woro hima fori omwe tupu ki wosiro kowe ako ki waini uku ako gutono ti, apa kipe naha tumbwa ete dano.” ");
INSERT INTO kwj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas o mwanji ni ete wunu ri sawendawani hi ucha hima laka fori ri tani ri mu tiki ri ombungwesini ya ri sawe, “Ai himiyama che ti apa chumbwa naha kumbwa ete haro. Woroti mi tani tapa mihi ti ti tape tenge tiki ma owewa sa ai tani wanda.” ");
INSERT INTO kwj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wowani Jisas saini ya rini sirinani ya ri i. Rini sirinani iwani Jisas himache le okwe ya fini sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wondawani humwe foti okwe o ki ya ti da. O humwe akawe ti daro asama ti tapaꞌangi tapaꞌangi ini hatachi fisi ti daro. Woro o humwe to Jisas gumwa tiki takai ti ini Jisas i nikaꞌari tumafu tini ya ti toro. ");
INSERT INTO kwj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hinde wowani, inaka tihi tiki ka hinga ti hambwandaro, “Ani ini tapa ahi ti nikaꞌari tumafu rihi kumbwa ani torowa kipe naha ani wosino.” ");
INSERT INTO kwj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O hinga ti hambwasini ti torowani Jisas jamekoni tini heikoni ya tini sawe, “Ai che, sembe nihi sa wahapisini sa da. Sembe ani ni ni haro ti keke apa kipe ti ni wosihiro.” Ete wowani metengei ete o humwe kipe ya ti wosi. ");
INSERT INTO kwj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wosini Jisas o hiꞌucha hima ri aka tokwe ya ri i. Ri ini ri heiwani hima fwele hambangini ti wuichindawani himiyama hurahama fwele wu ichakandani wasamba miyafo naha ya wu wonda. ");
INSERT INTO kwj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wondawani Jisas ya wunu sawe, “Kunu ma akini i. O bai humwe che ha nambwe, nimba tukuyandau.” Ete wowani wunu rini ni ya wu sawehingi. ");
INSERT INTO kwj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wondawani ele himiyama hurahama miyafo ri sawewani wu sirawani, Jisas raruni o humwe chongoche i tapa ri torowani ya ti sai. ");
INSERT INTO kwj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wosiwani o mwanji to ele mapwa laka hinga tinda ete ya chiki. ");
INSERT INTO kwj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wosini Jisas o ko ri andosini ya ri i. Wondawani miya sa hima fisi ri gumwa tokwe rini sirinani ini ka hinga ya fi ucha, “Mini Defit i che, sini keke mi woni ma sini okula.” ");
INSERT INTO kwj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ete fi uchandawani aka tiki ya ri raru. Ri raruwani miya sa hima fisi opi rini tambwa ya fi i. Fi ini fi raruwani Jisas ya fini sawe, “Miya kihi ti kipe a wosi kinani sembe ani ni mwe naha ki haroꞌo?” Wowani fini ga ya rini sawe, “Ei, Apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ete wowani tapa rihi ti miya fihi tiki ri owesini ya ri sawe, “Kini ani ni sembe mwe naha ki haro ti keke miya kihi ti kipe sa kini wosi.” ");
INSERT INTO kwj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wowani miya fihi ti ya fi ripa. Wosiwani Jisas mwanji kwambu fo ka hinga ya fini sawe, “Kini hambwafwaꞌai. Foki apa hima fori mendi ki.” ");
INSERT INTO kwj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Worotito fi ini hoko tokwe fi raruni Jisas fini wosiro sumbu o tini ele mapwa hinga tinda ete ya fi saweni inda. ");
INSERT INTO kwj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","O hinga fi wondawani hima fwele himamwale kapwa dasini takisopo rihi dimisiro hima o rini Jisas tambwa ya wu rata. ");
INSERT INTO kwj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wu ratawani Jisas o himamwale kapwa ni sawewani ya akini i. Wowani o mwanji bwanda nambwe hima ri apa mwanji ya ri bwanda. O hinga ri wosiwani ele himiyama hurahama wu apapanani ka hinga ya wu sawe, “Imbihumbwa ka hinga sumbu Isurel ko tiki sukwa nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ete wowani ele Farisi hima to ka hinga ya wu sawe, “Rini ele himamwale kapwa rani ri humbweꞌindau ti, o himamwale kapwa aulindau hima laka i kwambu torosini ele himamwale kapwa rani ri humbweꞌindau.” ");
INSERT INTO kwj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Wosini Jisas ele ko laka ga ko cheche ga tinda ete ri ini Kurais tani ele hima i sembe aulino Gotri mwanji ti o wui lotu wo aka tiki wunu ondiyakandiyandani ele wui hahungo ba fo ba fwele kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wondani ele himiyama hurahama miyafo ni ri heini sembe rihi ti wunu keke ya ri wonda. Hinde wowani, sembe wuhi ti nomo miyafo wu andani hahungo miya hinga ya wu siranda. Wunu fe asa, yapai chele nambwe hinga. ");
INSERT INTO kwj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wowani ri himache leni ya ri sawe, “Ahirahi miyafo rupwa tiki otokunasindau. Woroti tau ra himache miyafo nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","O hinga keke o yapai chele tau hima ni ma ku ucha, wowa tau ra hima fwele ri rumbwewa sa wu ini ahirahi tuko oti numbuni sa rini wu wausi.” ");
INSERT INTO kwj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas ele ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi leni ri uchawani rini tambwa wu tawani Gotri kwambu ti ya wunu ri ha. Wosiwa himamwale kapwa rani wu humbwewa ele himiyama hurahama hahungo wuhi ti kipe wunu wosi ki. ");
INSERT INTO kwj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kale ri tapaꞌangi tapaꞌangi hatachi fisi himache hi wuhi ti kale: Metengei naha ri esiro hima, hi rihi ti, Saimon, hi rihi foti Pita, rini ga ri analongo, Anduru. Wowani Jemis, rini Sepeti che, rini ga ri analongo, Jon. ");
INSERT INTO kwj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ete wowani Filip hima pi Batolomiyu. Wowani Tomas hima pi Matiyu, rini takisi ya torondau hima. Ete wowani Alafiyas i che, Jemis hima pi Tatiyas. ");
INSERT INTO kwj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Wowani Saimon, Jutiya ko keke gangambanindau hima fori, rini ga Jutas Isukariyot, Jisas ni miho lei tapa tenge ki haro hima. ");
INSERT INTO kwj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas ele tapaꞌangi tapaꞌangi hatachi fisi himache rihi leni ri humbwewani wu ikowani ya wunu ri sawe, “Ku ini ele biya hima ba fwele tambwa apa ku raru kei. E, ku ini apa Sameriya himako wui ko ki ku raru kei. Minambwe naha kunu a nasindau. ");
INSERT INTO kwj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kunu fe che asa che hinga ichiꞌucharo Isurel ri hima kupu le tambwa ma ku ini, ");
INSERT INTO kwj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ka mwanji hinga ni ma wunu ku sawe, “Hewen ko kipe Gotri kwambu ti hima i sembe auli kinani tani takaihiro.” ");
INSERT INTO kwj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wondani hahungo dau hima le kipe ku wosini, e, haro hima le ma ku ai rasainda. Ete wondani sechi okwe aro hima le kipe wunu ku wosindani himamwale kapwa dau hima le okwe ma ku sawewa o himamwale kapwa sa sirani sa inda. Hima okula kinani kunu ani haro kwambu ti ya tiki ku ra nambwe. O keke hahungo hima le ma nimba ku rasainda. Apa o ki ya ku toro kei. ");
INSERT INTO kwj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ku ikoni ya ti kui kowe tiki ku warosini ku raꞌai kei. ");
INSERT INTO kwj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wondani apa barasipeni ti, siyoti fisi, su ti, e, diyandau kumbo ti, apa ku rani i kei. Minambwe naha. Hinde wowani, tau ahi ra ki ino hima ri hima le o rini yakwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ku ini ko laka foꞌo ko che fo ku raruwa norukweni ma ku hei, hinde na hima rito sumbu rihi ga inaka rihi tinga kipe naha. Wowa ori hima ga ya ma ku da. Dani ini o ko ku hanjaꞌaikoni pwe rini ku hanjaꞌaisini ku bwe i. ");
INSERT INTO kwj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","E, ku ini aka foriki ku raruwa o aka chele hima ni Gotri sembe wahapi rini ha kinani ma rini weseꞌa. ");
INSERT INTO kwj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ete wowa o aka chele hima mwe ri kunu ri ohounawa Gotri sembe wahapi ti mwe naha o wunu ri hakonda. E, kunu ri ohouna nambwe nawa Gotri sembe wahapi ti kunu ki o ai takonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","E, ko fokipe hima le kunu raꞌaini wui aka tokwe kunu wu rakaruni kui mwanji ti wu mendi nambwe nawa, o ko ki wu dau aka lengu wuhi ku hanjaꞌaisini ku ikoni seke hapi ti ma ku yemburunasini ma funda ete ku i. ");
INSERT INTO kwj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mwe naha ki kunu a sawendau, ichai Gotri ele himiyama hurahama ri mwanji wunu bwano gisi ti tawa Sotom ko ga Gomora ko ga o ko fisi ni Gotri wosiro sumbu kapwacheche hinga, o ko ni wosino sumbu tito omwesika laka fo. ");
INSERT INTO kwj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ma ku mendi, ani fe che asa che hinga kunu a humbwekondau, kapwa asa lei nindo tiki. Woroti kunu walaꞌasa le wu hambwa hambwa wu ichiꞌuchandau hinga o sumbu hingambwa ku torosini ku wosino sumbu ti ma norukweni ku hambwasini pwe ku bwe ra. Wosini apweyilo wahapisini dau sumbu hinga tunumbwa ku sirinani sumbu kipe ma ku wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kunu hima leni ma ku hambwafwaꞌainda. Apa kanisol wuhi o kunu kotimwosini lotu wondau aka wuhi tiki kunu rakarusini o kunu tanambwandakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wondani apa wunu hi ahi tini wu rakai ki o wu hambwakonda. Wosini ele hiꞌucha hima laka lenga king apukolaka le wunu tambwa o kunu raꞌaikonda. O hinga kunu wosisiwa Gotri mwanji ti wunu ga ele hima ba fwelei miyaningisopo tiki o ku bwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kunu kotimwo ki wu raꞌaiwa apa ku akini inakambongo ku hambwani ete ku sawe kei, ‘Bwele mwanji tini apa nu bwano?’ O amwa kumbwa ete Gotri ku bwarakarano mwanji ti o kunu sawekonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hinde wowani, kunjenga apa mwanji ti hinde ku bwarakara kumbwa. Mina. Kui Yapai, Gotri, ri Himamwale kipe tito tani inaka kuhi ki rarusini rindo kui takisopo tiki o ri bwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ai hi keke hima fori ri analongo forini kotimwowa hima ba fwele wu tani o rini wu yeni wu sikonda. Yapai fori okwe apa ri che rini o hingambwa o wosikonda. Che le apa wui nuwai yapai ni o hingambwa o wu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Apa ele himiyama hurahama ai hi keke sembe kapwa o kunu hambwakonda. Woroti ai himache fori ani naha ni ete ri hambwandano ti, gisi jipe rihi humbuwa ai Yapai Gotri o rini raꞌaikonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","E, ko laka foki walambe sumbu kunu wu wosiwa ma ku akini ko laka fo tokwe ma ku i. Mwe naha ki o kunu a sawenda. Tau kuhi ti Isurel ko laka le ku humbu nambwe ete dawa, do Hima ri Che o ri ai takonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sukul wondau che ri ri tikisa ni dikinda nambwe, e, tau ra himache fori ri hacha ni dikinda nambwe. Mina. ");
INSERT INTO kwj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sukul che ri tikisa rihi hambwandau hinga ri hambwawa oti kipe naha. Woro, tau ra himache o hingambwa, ri hacha rini hinga etiwa oti kipe naha. Aka chele hima mwe ri, ani ni Saiten hi tiki ani wu uchasindau. Woro hingambwa apa o aka kumbwa ani ga dau hima leni kapwa hi naha ki kunu uchasikondau. ");
INSERT INTO kwj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kunu apa wunu aki kei. Woro ele yanisini dau sumbu le amwei sukwakondau. Wowa ele yanisini bwandau mwanji okwe hima le wu mendini ya wu hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Do mwanji niliki tiki kunu a sawendau ti kunu ga ele hima i miyaningisopo ki tapwaki naha ki ma ku sawe. Dohaꞌa mwanji usari naha wasamba sopu tiki kunu a sawewani ku mendindau ti, kunu ga mwangi hinga ki ma rau ku etisini hapa tinga ma ku sawe. ");
INSERT INTO kwj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Apa kunu hima tape tini yeni sindau kapwa hima leni ku aki kei. Wunu himamwale kuhi tini sumbu fo hinde kunu wosi kumbwa. Mina. Dohaꞌa hima naha numbwa ma ku aki, hi laka tiki himamwale tinga hima tape tinga kunu uno ti keke. ");
INSERT INTO kwj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Dohaꞌa ko kipe hima le raisi apwe fisi tini 10 toea tiki wu randau. Woro kui Yapai to ohouna nambwe nawa dele raisi apwe hinga fori hinde nuwe ki sika kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kale che, mwa kuhi tiki dau mwa nimbi ti tinda ri gandisindau. ");
INSERT INTO kwj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","O keke kunu apa ku aki kei. Kunu apwe cheche leni ku dikisindau. ");
INSERT INTO kwj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hima fori ai hi tini himiyama hurahama lei miyaningisopo tiki ri bwano ti, ani okwe hi rihi ti ai Yapai hewen ko tiki dau ti ri miyaningisopo ki a bwano. ");
INSERT INTO kwj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Woro hima fori hi ahi tini himiyama hurahama lei miyaningisopo ki ri yaniwa ani okwe hi rihi ti ai Yapai hewen ko tiki ri dau ti ri miyaningisopo tiki a yanikonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kunu apa ete ku hambwa kei, ani do nuwe ki a taro ti sumbu wahapi a wosi ki a taro. Mina. Ani kui nindo ki au mu ti musu ki a taro. ");
INSERT INTO kwj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hinde wowani, ani a taro ti, omwemendi sumbu a wosikondau. Hurahama che ri ri yapai ni omwemendiwa himiyama che ti ti nuwai ni omwemendikonda. Wowa naruhumwe ti ti tukwahapa ni omwemendikonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Apa hima fori ani ni sembe mwe naha ri hawa, ri hima kupu le o rini omwemendikonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hima fori ri nuwai yapai kekembwa mama ri woni ani keke kapwacheche ri wondau ti, ori hima hinga rini ai nau mina. E, hima fori ri himiyama che hurahama che le kekembwa mama ri woni ani keke kapwacheche ri wondau ti, ori hima rini ai nau mina. ");
INSERT INTO kwj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hima fori me yapweke rihi ti ri kichani ani ni ri sirina nambwe siwa, rini ai nau hinga mina. ");
INSERT INTO kwj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","E, hima fori ri himamwale tumbwa ri enependano ti, ichai himamwale rihi ti walambe rini i sindau. E, hima fori ri himamwale ti ani keke ri ohumbwewa, ichai himamwale rihi ti ri torosino ti ete da ete dano. ");
INSERT INTO kwj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hima fori kunu ni sumbu kipe ri wosini kunu enependau ti, ori hima ani ni sumbu kipe ri wosindau. E, hima fori ani ni ri sumbu kipe ri wosini ri ani enependau ti, ori hima Gotri okwe rini enependau. Gotri ani ri humbwewani do nuwe ki a taro. ");
INSERT INTO kwj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hima fori ka hinga ri hambwawa, ‘Ani Gotri mwanji bwarakarandau hima ni sumbu kipe a woni rini ani enepeno,’ wosini ori Gotri mwanji bwarakarandau hima ni ri aka tokwe raꞌaiwa, Gotri mwanji bwarakarandau hima ori ni ri handau hingambwa ori hima wosiro sumbu wasa keke Gotri o hingambwa rini hakonda. E, hima fori ka hinga ri hambwawa, ‘Ani sumbu kipe wosindau hima kipe rini sumbu kipe a woni rini ani enepeno,’ wosini ori hima kipe ni ri aka tokwe ri raꞌaiwa, o sumbu kipe wosindau hima kipe ni ri handau hingambwa ori hima wosiro sumbu wasa keke Gotri o hingambwa rini hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E, hima fori hi nambwe himache ahi forini ri heini ka hinga ri hambwawa, ‘Ani Jisas himache ka rini ani okula ki,’ wosini uku sumbwe ti kapu tiki tisini rini hano hima ri, mwe naha ki kunu a sawendau, ori hima ri sumbu wasa kipe mwe naha ri toro sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi leni tau rano mwanji tini wunu ri saweni ri humbusini o ko ri andosini ele ko ele ko takaisini dau ko tokwe ri ini Gotri mwanji tini ri sawendani ya wunu ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wondawani Jon kalapus tiki ri dani Kurais Apukolaka randau tau ti ya ri mendi. Wosini ri himache fwele Jisas tambwa ya ri humbwe. ");
INSERT INTO kwj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wosiwani wu ini rini ni ya wu sili, “Ka Gotri chengi ki sawesiwani takondau hima ri, mindoꞌo, mina, hima forini nu nikisinoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ete wowani Jisas ga mwanji wasa ya wunu sawe, “Ma ku ini Jon ni ele mwanji ku mendiro ti, e, ele sumbu ku heiro ti ma rini ku sawe. ");
INSERT INTO kwj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ele miyasa hima le miya wuhi ti ai wu heindau. Seke kapwa hima le ai wu ichiꞌuchandau. Sechi okwe aro hima le kipe ai wosindau. Wasamba kiti hima le mwanji ai wu mendindawani haro hima le ai wu saindau. Wondawani bwarichape hima le Gotri mwanji ya wu mendinda. ");
INSERT INTO kwj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","E, hima fori ai mwanji tini ri mendini inaka walefo ri hambwa nambwe nawa rini sa ri eripenda.” ");
INSERT INTO kwj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon himache le wu ai isiwani, Jisas ele himiyama hurahama ni Jon sumbu ni ka hinga ya ri sawe, “Imbihumbwa ka hima nambwe michi ku iro ti, bwele mwaꞌambwe forini hei ki ku iro? Ani hambwawani ausuwa to suwa tini sini bwapiꞌi bwapitandau tini ku hei ki ku iroꞌo? Mina. ");
INSERT INTO kwj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wo kunu bwele mwaꞌambwe tini ku hei ki ku iro? Ani hambwawani hima fori kaꞌapwe kipe naha foti wosiwani ku hei ki ku iroꞌo? Mina. Ele hima kaꞌapwe kipe naha soꞌoisini dau le wunu king apukolaka i aka tukumbwa dau. ");
INSERT INTO kwj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hinde wowani kundo ku iro? Gotri mwanji bwarakarandau hima forini hei ki ku iroꞌo? Ei, mwe naha ki kunu a sawenda. Ori hima ele biya Gotri mwanji bwarakarandaro hima fweleni dikisindau. ");
INSERT INTO kwj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ori hima ni Gotri chengi tiki ka hinga sawesindau, ‘Ma mendi, ai mwanji bwano hima ri, mini ni mwaseni o ri ikonda. Rini numbo mihi tini o nambusikonda.’ ");
INSERT INTO kwj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ani mwe naha tiki kunu a sawenda: Uku yasindau hima Jon ori tombwa dele nuwe ki sukwaro hima leni dikindau. Woro, ani ni sembe hasini hewen ko ki dau kwambu tini tororo kapwacheche naha forito Jon ni dikindau. ");
INSERT INTO kwj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jon uku wunu yasindaro gisi ti ambwesini ete ta tani apa okwe hima fwele hewen ko kwambu wu raru kinani wu gangambanini tau kwambu ete wu randau. Woro ele himako wu raruhiro. ");
INSERT INTO kwj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ele Moses kaisiro lo mwanji tinga Gotri mwanji bwarakarandaro hima le kaisiro chengi ele ga Kurais tano tini ete wu sawero. Wosiwanumbwa Jon mwaseni ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Woroti ku mendi kinawa ma mendi. Gotri chengi ki sawesiro Kurais ni mwaseni tano hima, Ilaicha, tahiro. Rini Jon. ");
INSERT INTO kwj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","E, hima rini wasamba chele ti ka mwanji ya sa ri mendi. ");
INSERT INTO kwj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Do gisi ki dau himiyama hurahama ele bwele mwanji hinga tini wunu a yepeno? Wunu kale kichapwache hinga, apweli ki wu wausini ele biya kichapwache fweleni ka hinga uchandau, ");
INSERT INTO kwj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nunu hambangini ti kunu keke nu wuichindau ti, kunu hukwa ra ra seke ku yitinda nambwe. Nunu hima keke ichakandau hukwa tini nu randau ti, kunu ku ichakanda nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon tani ahirahi tinga waini uku tinga ri a nambwe. Wosiwani ya wu sawe, ‘Himamwale kapwa rini ga o da.’ ");
INSERT INTO kwj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Da hinga woni dori Hima ri Che tani rini ahirahi tinga waini uku tinga ya ri a. Wowani ele hima ya sawe, ‘Ma hei, rini ahirahi ti fe hinga ri andani waini uku mama ri ani humbundau. Rini takisi ya toro hima lenga kapwa hima lenga nau funda wu anatororo.’ Woro, hima fori Gotri hambwa tiki tau randau ti nawa, ichai o tau to amwei o wokonda.” ");
INSERT INTO kwj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ko laka fweleki Jisas sumbu kwambu ba fo ba fo ri woro ti, wundo wu heini kapwa sumbu wuhi gumwa wu sisini sembe wu ha nambwe. O keke Jisas mwanji kwambu tiki ya wunu sawenda. ");
INSERT INTO kwj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ka hinga ya ri sawe, “Kunu Korasin lenga Besaita lenga! Kunu keke a woro ti, ku hambwa nambwe! Hima fori Taiya ko ga Saiton ko ga ba fo ba fo sumbu ele kui ko tiki a wosiro hinga ri wosipo, injelembwa kapwa Taiya lenga Saiton lenga himisombo wu yeni goro wu hindisini nuwe tiki wu dilembendani wundo wu woro kapwa sumbu tini sembe nomo wu hambwakoro. ");
INSERT INTO kwj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Woroti kunu a sawenda, Taiya hima lenga Saiton hima lenga Gotri mwanji bwano gisi ki wu mendino amwaka ti, kundo ku mendino amwaka omwesika hinga mina. ");
INSERT INTO kwj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kunu ele Kapaneyam ko pe hima le, hewen ko tiki apa hinde kunu rakau kumbwa. Mina. Kunu hi tiki tinda ete ku raino. E, hima fori Sotom ko tiki sumbu kina hinga foti kui ko tiki a woro hinga ri wosipo Sotom ko napo kipe tumbwa ete dakoro. ");
INSERT INTO kwj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka hinga keke kunu a sawendau, Gotri mwanji bwano gisi ti tawa Sotom ko pe hima le mendino amwaka ti kundo ku mendino amwaka omwesika hinga mina.” ");
INSERT INTO kwj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","O gisi kumbwa Jisas ka hinga ya sawe, “Ai yapai Gotri, hewen ko tinga nuwe tinga mini Apukolaka. Mini ni a weseꞌanda, hinde wowani, mini dele mwaꞌambwe ni do nuwe kipe inaka kipe hambwandau hambwa omwesika tororo hima leni mi yanisini, ele kichapwache hinga waꞌairo hima lembwa mi mekusiro. ");
INSERT INTO kwj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ei, ai Yapai, inaka mihi ti o hinga to sa. ");
INSERT INTO kwj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ele mwaꞌambwe hinga tinda ete ai tapa tenge tukumbwa mi ani haro. Hima fori, dori Hima ri Che ni kipe naha ri hambwanda nambwe. Yapai, mindombwa mi hambwandau. Hima fori Yapai Gotri ni kipe naha hambwanda nambwe. Dori ri che tombwa rini hambwandau. Ele hima hinga dori Hima ri Che to Yapai ni wunu mekusi nambwe nawa apa Yapai ni hinde wu hambwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kunu ele tau kwambu ku randani nomo laka ku rani ku mweꞌimwaꞌindau hima le, ani tambwa ma ku tawa himati kunu ani ha. ");
INSERT INTO kwj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wosini o kunu ani hano tau tini ma ku randani ai sumbu tini ma ku hambwani sirinanda. Hinde wowani, ani ele hima keke a wondani mwanji ti usariche wunu a bwandani, hi ahi tini a rakaindau. O hinga ku wowambwa kui himamwale himatino. ");
INSERT INTO kwj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ele tau kunu ani hano ti o tau kwambu nambwe. E, ele nomo ku ra ki kunu ani hano ti, oti nomo nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dani ini himati gisi foriki Jisas witi rupwa nindo tiki ri himache lenga wu ini iche wunu hawani witi oti wu kwani wu yefurunasini ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","O hinga wu wondawani Farisi hima le wunu heisini Jisas ni ya wu sawe, “Ma hei. Mi himache le himati gisi ki ka sumbu hinga wu wosindau ti, minambwe naha nu nasindau.” ");
INSERT INTO kwj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wowani Jisas mwanji wasa ya wunu ri sawe, “Kunu Defit wosiro sumbu ti Gotri chengi tiki kaisiro tini ku hambwa nambweꞌe? Ani a sawendau ti, imbihumbwa Defit ga ri himache lenga icherihapari nimba wu daro gisi tini a sawendau. ");
INSERT INTO kwj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wunu Gotri aka tiki wu rarusini wu heiwani Gotri ni anguꞌomwe hinga haro bereti ti ya da. Wosini o tini rukoni ya wu a. O bereti hinga ti puris hima tombwa wu andau. ");
INSERT INTO kwj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ka Gotri chengi tiki dau lo mwanji tini ku hambwa nambweꞌe, ete sawero ti, puris hima le Gotri aka laka ki puris tau wuhi himati gisi ki wu randau ti, wunu kapwa sumbu wosinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Worotini kunu a sawenda: Dori hima ahaꞌa ki dau ti Gotri aka laka tini dikindau. ");
INSERT INTO kwj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kunu ka mwanji ni norukweni ma ku hambwa: ‘Ani Gotri ni anguꞌomwe ha sumbu ti a diyaha. Ani hima keke wondau sumbu tini ani okokonandau.’ O hinga ku hambwapo kapwa sumbu nambwe hima leni mwanji nomo hinde ku hakoro ambwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dori Hima ri Che tombwa himati gisi tini ri aulindau.” ");
INSERT INTO kwj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wosini Jisas o michi ri hanjaꞌaisini lotu wondau aka fo tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wosini ri heiwani tapa kapwa hima fori o ki ya da. Wondawani hima fwele Jisas ni wu kotimwo kinani ya rini wu sili, “Apa ka himati gisi ki hahungo hima forini nu wonorukwewa sainoꞌo, mina?” ");
INSERT INTO kwj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ete wowani Jisas ga ya wunu ri sawe, “E, hima fori kui nindo ki ri dau ti, rini sipisip rihi funda. Woro o sipisip himati gisi fotiki wa we tiki raisiwa ori yapai chele hima ka sipisip wa we tiki rairo tini ri ai ri rasukwanoꞌo, mina? ");
INSERT INTO kwj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hima le sipisip ni dikindau. O hinga keke himati gisi tiki hima okulandau sumbu kipe ma nu wosi. Hinde wowani, Gotri lo mwanji o sumbu hinga ni ohounasindau.” ");
INSERT INTO kwj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wosini ori hima ni ya ri sawe, “Tapa mihi ti ma dachina.” Wowani ya ri dachina. Ete wowani o tapa kapwa rihi ti o tapa angi kipe dau hinga ya ai wosi. ");
INSERT INTO kwj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ete wowani ele Farisi hima wu ini forukumbwa wu wausini Jisas ni wu yeno mwanji tini ya wu anambwa anambwanda. ");
INSERT INTO kwj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wondawani Jisas wui mwanji ti ri hambwahiro. Wosini o ko ri hanjaꞌaisini ya ri i. Wondawani ele himiyama hurahama rini sirinani wu iwani ele hahungo daro hima leni kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wosini Jisas hi rihi ti ele biya hima fweleni wu saweni ino ti keke minambwe ya wunu ri na. ");
INSERT INTO kwj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","O sumbu hinga ti, imbihumbwa Gotri mwanji bwarakarandaro hima, Aisaiya, ri takisopo tiki sawero mwanji hingambwa ya sukwa. Aisaiya to ka hinga ete sawero, ");
INSERT INTO kwj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Karihaꞌa hima rini ai tau ra himache, rini ani esisindau. Ani rini keke ete a wondani sembe ahi ti rini ni kipe naha ani eripendau. Wosini Himamwale ahi ti rini ni ani owesindau. Wosiwa rini, hima le sirinano sumbu kipe tini ele hima ba fwele tinda ete ri bwano. ");
INSERT INTO kwj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Rini anangiya mwanji apa hinde ri bwa kumbwa. Rini enge rini akoni mwanji ti hapa tinga apa hinde ri bwa kumbwa. Apa numbo laka ki ri indani ata laka hinde ri gi kumbwa. Wosiwa hima o ki ri ata tini hinde wu mendi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Rini suwa foti lehepusindau tini ri heiwa hinde apa ri lepweke kumbwa. E, lamu wiki foti kamindache naha hi okusindau tini ri heiwa apa hinde tinda ri yetipina kumbwa. Rini ele hima i sembe we ki sumbu kipe rihi ti tale ki tau rihi ti ete ri randano. ");
INSERT INTO kwj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wondawa ele hima ba fwele sembe rini ni wu hasini ete rini wu nikisindano.” ");
INSERT INTO kwj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka gisi ki hima fori rini tambwa ya wu rata. Kari hima rini himamwale kapwa rini ga dawani miya rihi ti sawani takisopo rihi ti dimisindau. Wowani Jisas kipe ya rini wosi. Ete wowani ori hima miya ti ri maꞌaikaꞌaini mwanji ti ya ri bwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ete wowani ele himiyama hurahama miyafo wu heini wu apapanafuni ya wu sawe, “Dori hima Defit cheꞌe, mina?” ");
INSERT INTO kwj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ete wowani Farisi hima le wu mendini ya wu sawe, “Ori hima Belesepul kwambu tiki himamwale kapwa ri rani ri rumbwendau. Belesepul rini himamwale kapwa lei wui apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","O hinga wu bwawani rini wui inaka ti ri hambwasini ya wunu ri sawe, “King apukolaka ga ri himache lenga ko laka foki wu dasini wu huwasini wu anangiyani anayendawa, apa o ko laka walambe i sindau. E, ko laka fokiꞌi, aka fo kumbwa dau hima le wunjenga wu huwasini wu anangiyani anayendawa o ko lakaꞌa, o aka hinde apa yakina kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Woro o hingambwa Saiten ri ko ki nerimbe fisi wu huwasini wu anayendani wunjenga wu rumbweꞌi rumbwetandawa, apa ri ko ti hinde yakina kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ete ku ani sawendau ti, Belesepul ri kwambu tiki himamwale kapwa a rani a humbwendau. O hinga ti keke kui himache le wunu namoi kwambu tiki himamwale kapwa rani humbwendau? O hinga ti nawa kui himache letombwa o kunu kotimwokonda. ");
INSERT INTO kwj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","E, Gotri Himamwale tito ani okulasiwani himamwale kapwa a rani a humbwendau nawa, kunu ya ma ku hambwa, Gotri kwambu ti kunu ki tahiro. ");
INSERT INTO kwj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“E, hima fori ri ini hima kwambu naha foi aka tiki ri raruni ri mwaꞌambwe le apa hinde ri rasira kumbwa. Mina. Ori hima i kwambu ti kupu tiki ri injisinimbwa apa ri raruni ele mwaꞌambwe rihi ri rasirano. ");
INSERT INTO kwj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hima fori rini ai nau nambwe nawa ori hima rini ai miho. E, hima fori, ani ga hima le si wau nambwe ti nawa, rini ele hima ni ri ohumbwewani wu ichiꞌuchandau. ");
INSERT INTO kwj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“O keke kunu a sawendau. Hima fori ele kapwa sumbu ri woni ele saweholiya mwanji ri bwano ti, Gotri o tini rani ri humbwe sindau. Woro hima forito Gotri Himamwale tini ete saweholiyandawa, apa Gotri ri kapwa sumbu ti hinde ri rani ri humbwe kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hima fori dori Hima ri Che ni sawesiyaꞌaiwa, Gotri o kapwa sumbu ri rani rumbwekonda. Woroti ori hima to Gotri Himamwale tini ete saweholiyandawa Gotri apa ga ichekai ga kapwa sumbu rihi ti hinde ri rani ri humbwe kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Me kipe ti tuko kipe naha tumbwa wandau. E, kapwa me ti, o me tuko kapwa naha tumbwa wandau. Hima le me fo heini wu hambwa kinawa, o me kipeꞌe kapwa, wowa tuko tiki ya wu hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kunu kapwa hima le kapwa hopo hinga, mwanji kipe ti hinde hinga ku bwakondau? Hima i sembe ki inakahambwa to talesini takisopo ki mwanji ti bwandau. ");
INSERT INTO kwj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hima kipe ri, sumbu kipe miyafo ri sembe tiki talesiwani sumbu kipe miyafo ri wosindau. Wosiwani kapwa sumbu miyafo wosindau kapwa hima ri, ri sembe ti kapwa inaka tombwa ete rini talesiwani kapwa sumbu miyafo naha ri wosindau. ");
INSERT INTO kwj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Worotini kunu a sawendau. Mwanji laka bwano gisi tiki Gotri ele himiyama hurahama ni ele tikisapu mwanji hinga wu bwandaro tini o wunu ri silindakonda. ");
INSERT INTO kwj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mindo dohaꞌa nuwe ki mi bwaro mwanji keke Gotri o mini sawekondau, mini hima kipeꞌe kapwa hima.” ");
INSERT INTO kwj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ka gisi ki Gotri lo mwanji hambwandau hima lenga Farisi hima lenga ya rini wu sawe, “Ondiyakandiyandau hima, nunu nui okokona ti, mini sumbu kwambu naha fo ma wosiwa nu heini nu hambwa, mini Gotri ki mi taro.” ");
INSERT INTO kwj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ete wowani rini ga mwanji wasa ya wunu ri sawe, “Kapwa sumbu wosindani gambolombo gotri ni sirinandau apa kipe himiyama hurahama dele Gotri sumbu kwambu mwe tini nimba wu hei kinani wu gindau. Woroti apa o sumbu kwambu hinde wunu a meku kumbwa. Gotri mwanji bwarakarandaro hima ri, Jona, ri sumbu kwambu tumbwa o wunu a mekukonda. ");
INSERT INTO kwj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ka imbihumbwa Jona fwaiꞌomwe laka sembe we tiki niliki ga tapwaki ga gisi namili ri daro hinga dori Hima ri Che nuwe sopu tiki niliki tinga tapwaki tinga gisi namili ri dano. ");
INSERT INTO kwj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Gotri mwanji laka bwano gisi tawa Ninefa pe hima le wu etisini apa dele dau hima lei kapwa sumbu tini ya wu kilindakonda. Hinde wowani, Ninefa pe hima le wunu Jona mwanji tini wu mendini kapwa sumbu wuhi ti gumwa wu sisini sembe wuhi ti wu haro. Woroti hima fori apa dori dau ti, rini Jona ni dikisini dau. ");
INSERT INTO kwj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","E, Gotri mwanji laka bwano gisi tawa nika sukwa nika rai saut waku angi tokwe taro kwini humwe to etisini apa dele dau hima lei kapwa sumbu tini o ya ti kilindakonda. Hinde wowani, o kwini tini niri ambwe nuwe ambwe ki ti daro to ti tasini ti mendiro, Solomon to ri hambwa kipe tini tini sawero tini. Woroti hima fori apa dori dau to Solomon ni dikisini dau. ");
INSERT INTO kwj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“E, himamwale kapwa foti hima foni hanjaꞌaisini rini michihapa fotiki ini ri himatino michi tini ri waki wakini ri hei nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Wofunu ya ri sawe, ‘Ani ai ini imbihumbwa a daro aka tokwe ani ai ino.’ O hinga ri bwasini ya ri ai ri i. Ri ini o aka ri heiwani, yapai chele hima nambwe tikisapu ti ri hanjisini kaꞌapwe ti wosini ya yechikinasinda. ");
INSERT INTO kwj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ete wowani ri ai ini rini dikini kapwa sumbu mama wosindau tapaꞌangi hatachi fisi himamwale kapwa ri ra ra ya wu ta. Wosini o aka hukwe rihi ki wu raruni ya wu da. Wondawani imbihumbwa ori hima kapwa sumbu wai hinga ri wondaro ti, apa kapwa sumbu miyafo naha ri wondau. Woro hingambwa apa dele dau himiyama hurahama le o sumbu hinga wosikondau.” ");
INSERT INTO kwj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ele himiyama hurahama leni mwanji ti ete wunu ri sawendawani ri nuwai ga ri hipache lenga wu tani hoko tiki ya wu eninda. Hinde wowani, wunu rini ga mwanji ti wu bwa kinani wu taro. ");
INSERT INTO kwj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wowani hima fori ya rini sawe, “Mini ma mendi. Mi nuwai ga mi hipache lenga tani hoko tiki kale kwai eninda. Wunu mini ga mwanji wu bwa ki wu taro.” ");
INSERT INTO kwj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ete wowani Jisas ori hima ni mwanji wasa ya ri sawe, “Ai nuwai namo? Ai hipache le namo?” ");
INSERT INTO kwj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wosini ele ri himache leni tapa ba wunu ri ondiyasini ya ri sawe, “Ma hei, ai nuwai ga ai hiparakambwe lenga, delehaꞌa. ");
INSERT INTO kwj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","E, hima fori ai Yapai, hewen ko ki dau, ri okokona tini ri sirinawa rini ai hiparakambwe, ai kahaiche, ai nuwai.” ");
INSERT INTO kwj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","O gisi ki Jisas aka ri andosini hoko tokwe ya raru. Wosini fwanjuwei gamba tiki ya ri lininda. ");
INSERT INTO kwj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wondawani himiyama hurahama miyafo naha tani rini ga ya wu wau. O hinga wowani rini kanu fotiki ri rauni ri litiwani himiyama hurahama miyafo naha hapi mwai tiki ya wu eninda. ");
INSERT INTO kwj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wosiwani mwanji yepe miyafo naha ki wunu ri bwandani ka hinga ya ri sawe, “Ma ku mendi, hima fori raisi wapa ti rupwa tiki ri yesinani ri humbwe ki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Wosini ri humbwendawani raisi wapa fwele numbo gamba tiki ya sika. Sikasiwani apwe le hangani sikani ya tinda wu a. ");
INSERT INTO kwj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Raisi wapa fwele humokuto tenge tiki ya rai, nuwe miyafo da nambwe michi o tiki. Nuwe oti kaimbwa mina. Wosiwani fwamwe metengei ete ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ete wondawani nika sukwani ya ye. Ele raisi wapa tingini sukwaro ti nene kwambu i nambwe. Wosiwani nika yewani hopweneni ya rikaꞌai. ");
INSERT INTO kwj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Raisi wapa fwele lame chele ki nindo tiki ya rai. Wosiwani lame chele ki oti saini tinda ete ya yekicha. ");
INSERT INTO kwj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","E, raisi wapa fwele nuwe kipe tiki ya rai. Wosini mwe ti ya wa. Wapa foriki mwe ti 100 hinga ya wa. Wapa foriki mwe ti 60 hinga ya wa. Ete wowani wapa foriki mwe ti 30 hinga ya wa. ");
INSERT INTO kwj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hima wasamba chele ti dohaꞌa mwanji sa ri mendi.” ");
INSERT INTO kwj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wosiwani Jisas himache le tani ka hinga tini ya rini sawe, “Hinde wowani mwanji yepe tini wunu mi sawero?” ");
INSERT INTO kwj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ete wowani rini ga mwanji wasa ka hinga ya wunu sawe, “Gotri hewen kipe kwambu torono numbo yanisindau ti kunu ni mekuro, woro ele biya hima ni, mina. ");
INSERT INTO kwj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","E, hima fori mwaꞌambwe rihi fwele dawa, Gotri apa fwele ga ri ai hawa rindo apa mwaꞌambwe miyafo naha. E, hima fori mwaꞌambwe fisiche naha dawa, Gotri o mwaꞌambweche okwe apa ri ai raꞌaino. ");
INSERT INTO kwj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mwanji yepe tini wunu a sawendau bomo ti ka. Miya wuhi ti wu maꞌaikaꞌaindau ti, mwaꞌambwe fotini wu heinda nambwe. Wasamba wuhi ti yayanasindau ti, mwanji fotini wu mendini wu hambwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Woro o sumbu ni ele himiyama hurahama ni Gotri mwanji bwarakarandaro hima ri, Aisaiya, ka hinga ya ri sawe, ‘Kunu Gotri mwanji ti mwe naha ku mendino. Woroti mwanji mu mwe tini hinde apa ku hambwa kumbwa. Kunu kui miya ti ku heindano. Woroti, mwaꞌambwe fori hinde apa ku hei kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hinde wowani, dele himiyama hurahama lei inaka ti emendiki naha. Wasamba wuhi ti mwanji fo mendino tini tinda diyahasindau. Wasamba wuhi ti funda kitinambusindau. Miya wuhi ti funda dasikinasindau. Ele sumbu hinga wunu nu wosi nambwe napo miya wuhi ti mwaꞌambwe fo wu heini wasamba wuhi ti mwanji wu mendini inaka wuhi ti mwanji mu ti wu hambwakoro. Wopo apa numbo hukwe wu hanjaꞌaisini ani tambwa tawa kipe wunu a wosikoro.’ ");
INSERT INTO kwj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Woro kunu ma ku eripenda. Hinde wowani, miya kuhi ti mwaꞌambwe ti o ku heinda. E, wasamba kuhi ti mwanji o ku mendinda. ");
INSERT INTO kwj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mwe naha tiki kunu a sawendau. Imbihumbwa pe Gotri mwanji bwarakarandaro hima le, e, Gotri sumbu ni sirinandaro hima kipe le, o apa ku heindau hinga tini wu hei kinani au wunu saindaro. Woroti wu hei nambwe. Apa o ku mendindau mwanji hinga tini wu mendi kinani au wunu saindaro ti, o mwanji ni wu mendi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Apa mwanji mu mwe ti ma ku mendi, hima fori raisi wapa ti tau tiki ri rumbwe ki ri iro mwanji yepe ti. ");
INSERT INTO kwj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kale raisi wapa numbo gambwa ki sikaro ti, dele hima hinga ni sawendau. Wunu Gotri kwambu tini sawekawendau mwanji ti wu mendini o mwanji mu mwe wu hambwa nambwe. Wosiwani Saiten tani wui sembe ki siro mwaꞌambwe tini metengei ri raꞌairo. ");
INSERT INTO kwj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kale raisi wapa fwele humokuto tenge tiki sikaro ti, dele hima hinga ni sawendau. Wunu Gotri mwanji ni wu mendini wu eripeni wui sembe ki wu torondau. ");
INSERT INTO kwj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Woro nanji wuhi kaimbwa rai nambwe. O keke gisi miyafo wu i hinga. Dani inumbwa hima fwele Gotri mwanji tini wu yititakicha kinani wunu ni kapwa sumbu ti wu woni nomo ti wunu hakowani, wunu metengei ete ya wu hichakou. ");
INSERT INTO kwj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kale raisi wapa fwele lame chele ki nindo tiki sikaro ti, dele hima hinga ni sawendau. Wunu Gotri mwanji wu mendindau. Woroti do nuwe pe sumbu tinga ya mwaꞌambwe ti keke wu hambwani funda wu okokonakowani ele mwaꞌambwe to Gotri mwanji ti yekichasindau. Wosiwani raisi mwe wandau hinga wu wa nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Woroti kale raisi wapa nuwe kipe tiki sikaro ti, dele hima hinga ni sawendau. Wunu Gotri mwanji wu mendini mwanji mu mwe ti wu torosindau. Wosiwani fwele mwe ti 100 hinga wu wani fwele mwe ti 60 hinga wu wani fwele 30 hinga ya wu wa.” ");
INSERT INTO kwj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wosini Jisas mwanji yepe foti ka hinga ya ai wunu sawe, “Hewen pe kwambu ti raisi wapa kipe fweleni tau rihi tiki sindau hima hinga. ");
INSERT INTO kwj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wosiwani ele himiyama hurahama wu tukuyandawani rini omwemendindau hima fori tani ri tau nindo tiki kapwa ki so ri sisini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dani ini raisi wapa kipe oti saini mwe ti ya wakondawani wu heiwani kapwa ki tinga funda anangausini ya wu eninda. ");
INSERT INTO kwj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ete wowani ele ri tau ra himache le tani ori tau chele hima ni ya wu sawe, ‘Apukolaka, nunu ete nu hambwaro, ka mi rupwa ki raisi wapa kipe tunumbwa mi siro. Wo hinde wowani ka kapwa ki to sukwaro?’ ");
INSERT INTO kwj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ete wowani ya wunu ri sawe, ‘Nui miho forito o hinga ri wosiro.’ Wowani ri tau ra himache lenga ya rini wu sawe, ‘Nu ini ka kapwa ki nu sipini forukumbwa nu waunoꞌo?’ ");
INSERT INTO kwj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Wowani ya wunu ri sawe, ‘Mina. Foki kapwa ki ti ku sipikoni apa ki kipe tinga ku sipino. ");
INSERT INTO kwj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Anaꞌape ma ete fini ku andosiwa sa ete fi da. Wowa o raisi rikaꞌaiwa gipi tiki kutono gisi tiki pwe ele tau ra himache leni a bwe sawe, wowa ele kapwa ki metengei wu sipini tene tiki wu upwatino, hi tiki tu ki. E, raisi mwe kipe ti ahirahi owendau aka ahi tiki forukumbwa wu wausino.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wosini Jisas mwanji yepe foti ka hinga ya ai wunu ri sawe, “Hewen pe kwambu ti me fo hi ti, masitet, o tuko hinga. ");
INSERT INTO kwj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka masitet tuko kapwacheche naha, ele ahirahi tuko apuko hinga. Apa hima fori ka masitet tuko raꞌaini ri tau tiki sisiwa, saini apukolaka ini tau pe ahirahi leni dikino. Wosini me laka hinga saisiwani apwe le tani tali tapa tiki woto yesini dano.” ");
INSERT INTO kwj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wosini mwanji yepe foti ka hinga ya ai wunu ri sawe, “Hewen pe kwambu ti bereti ki owesiwani hehenandau wo, yis, hinga. Humwe foti hungwe laka kipe falawa tini uku gutosini o yis rawaisini jaunjamekowa dani ini falawa hinga tinda ete hehenani sukwano.” ");
INSERT INTO kwj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas ele mwanji ni himiyama hurahama leni ri sawekawendaro ti, mwanji yepe tukumbwa ete wunu ri sawendaro. ");
INSERT INTO kwj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O sumbu, ka Gotri mwanji bwarakarandaro hima fori ka hinga sawero hingambwa mwe naha rini ki ete ya sukwa. “Apa takisopo ani haunani mwanji yepe a sawekonda. Kale mwaꞌambwe injelembwa kapwa do nuwe wosiro gisi ambwesini ete ta tani apa okwe yanisini daro tini amwei kunu a sawekondau.” ");
INSERT INTO kwj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wosini Jisas ele himiyama hurahama ri hanjaꞌaisini aka we tokwe ya ri raru. Wowani ri himache le rini tambwa wu tani ya rini wu sawe, “Ka kapwa ki tau tiki sukwaro mwanji yepe mu mwe ti ma nunu ondiyakandiya.” ");
INSERT INTO kwj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wowani Jisas mwanji wasa ya ai wunu ri sawe, “E, hima fori raisi wapa kipe siro ti, rini dori Hima ri Che ni sawendau. ");
INSERT INTO kwj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Woro tau mwe ti dohaꞌa nuwe ni sawendau. E, raisi wapa kipe ti o Gotri kwambu tinga dau himiyama hurahama leni sawendau. E, kapwa ki ti o Saiten ni sirinandau himiyama hurahama leni sawendau. ");
INSERT INTO kwj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","E, ka omwemendindaro hima ri tau tiki kapwa ki siro ti, ori Saiten ni sawendau. Ka raisi mwe gipi tiki kutono gisi oti dohaꞌa nuwe humbuno gisi jipe tini sawendau. Kale tau ra himache, o ele ensel hima leni sawendau. ");
INSERT INTO kwj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ka kapwa ki fotukumbwa wu wausini hi tiki wu turo hinga, ichai dohaꞌa nuwe humbuno gisi jipe ki o hingambwa hima fweleni wu wosino. ");
INSERT INTO kwj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dori Hima ri Che ensel hima leni ri humbwewa Gotri aulindau nuwe tiki wu tani, hima kapwa sumbu wo kinani wui sembe yero hima lenga kale kapwa sumbu wondaro hima lenga ki hinga wunu sipini wausini ");
INSERT INTO kwj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hi laka tiki wunu rawaino. Ka hi laka ki wu raisini wu ichakandani fu wuhi tini wu tangindomunandano. ");
INSERT INTO kwj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wondawa ka gisi ki Gotri ni ete hambwandaro himiyama hurahama kipe le wui yapai kwambu tinga dau ko kipe naha tiki kwai nikahako hinga wunu taiyasino. Hima wasamba chele ti dohaꞌa mwanji sa mendi. ");
INSERT INTO kwj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Hewen pe kwambu ti oti tau fotiki yanisiro ya kowe hinga. Wosiwani hima foringa heisini rini ga o kumbwa norukweni ri ai yani. Wosiwani eripeꞌaripe rihi tito omwesika naha. Ete wosini ri ini ele ri mwaꞌambwe hinga tinda ya wungwa ri jisini o tau ni ya ri rakonda. ");
INSERT INTO kwj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“E, mwanji yepe foti ka hinga. Hewen pe kwambu ti, yaso kipe naha naha leni wakindau hima fori hinga. ");
INSERT INTO kwj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wosini forini ri heini ri okokonani ele mwaꞌambwe rihi hinga ya wungwa ri jisini yaso kipe naha naha o tini ya ri rakonda. ");
INSERT INTO kwj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“E, mwanji yepe foti ka hinga. Hewen pe kwambu ti, soluwara ki rawaisini ba fo ba fo fwaiꞌomwe le rasukwandau tukwa omwesika hinga. ");
INSERT INTO kwj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wosini tukwa oti fwaiꞌomwe ti raruni talesiwani wu longoni michi tokwe ya wu rasukwa. Wosini wu kili kili kipe ti hungwe foki apu wu rawai rawai kapwa ti hungwe foki apu wu rawai rawai. ");
INSERT INTO kwj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Woroti dohaꞌa nuwe humbuno gisi ti o hingambwa wosino. Ensel hima le tani kale Gotri ni hambwasindau hima kipe nindo leki dau kapwa hima leni yekino. ");
INSERT INTO kwj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wosini ka hi laka ki wunu rawaino. Ka hi laka ki wu raisini wu ichakandani fu wuhi ti wu tangindomunandano.” ");
INSERT INTO kwj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wosini Jisas ya wunu sili, “Kunu dele mwanji mu mwe ti tinda ete ku hambwandauꞌu?” Wowani ya wu sawe, “Ei.” ");
INSERT INTO kwj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ete wowani ka hinga ya wunu ri sawe, “O hinga keke, Gotri lo mwanji kipe naha hambwandani hewen pe kwambu tini norukweni hambwandau hima le, wunu aka chele hima mwe hinga. Mwaꞌambwe owendau aka tipa rihi tiki ri raruni mwaꞌambwe akoꞌo mwaꞌambwe hukwe lenga ri okokona ki tinda ete ra ra ya ri ratau.” ");
INSERT INTO kwj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wosini Jisas kale mwanji yepe hinga tinda ri sawesini, o ko andosini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ri ini hima laka ri sairo ko tiki ri raruni ele himiyama hurahama miyafo ni wu lotu wondau aka laka wuhi tiki Gotri mwanji ti ya wunu ri ondiyakandiyanda. Ete wowani wu apapanani ya wu sawe, “Dori hima ka hambwa ga ele ba fo ba fo sumbu kwambu ga sotiki ri rataro? ");
INSERT INTO kwj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Do che hai aka wondau hima ri che mina. E, Mariya ri nuwai mina. E, Jemis, Josep, Saimon, Jutas hima, ri hipache mina. ");
INSERT INTO kwj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ri kahaiche le okwe nunu ga dau. Woro dele hambwa hinga sotiki ri rataro?” ");
INSERT INTO kwj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","O hinga wu bwakoni rini ni inaka bongo ya wu hambwa. Wowani Jisas ya wunu sawe. “Gotri mwanji bwarakarandau hima, ri hi ti ele ko hinga tinda chikisindau. Woro, ri hima kupu lenga ri ko minde ga hi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wowani ba fo ba fo sumbu kwambu ka ko ki ri wo nambwe. Hinde wowani, sembe ti wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wowani ka gisi ki, Galili mapwa ni aulindaro king apukolaka, Herot, Jisas i mwanji suwa ti ya ri mendi. ");
INSERT INTO kwj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wosini ri tau ra himache leni ya ri sawe, “Kari hima uku yasindaro hima, Jon, hasini ai sairo. O hinga keke dele kwambu tinga dau sumbu rini ki do ete sukwanda.” ");
INSERT INTO kwj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mwanji mwe ka hinga: Mwase, Herot, Jon ni toroni ratani seni tiki rini injisini kalapus tiki ya rini rawaru. Bwele keke Jon kalapus tiki ri raruro? Humwe fo hi ti, Herotiyas, Herot i analongo, Filip, to tini hopwero, woro tindo mwanji mu ti ya ti musu. ");
INSERT INTO kwj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hinde wowani, injelembwa Jon Herot ni ka hinga ri sawero ti keke, “Do humwe, mi analongo humwe, tini mi ratani mi hopwero ti, kipe mina, kapwa.” ");
INSERT INTO kwj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ete wowani Herot Jon ni ri yeni ri si ki ri hambwaro, woro kale himiyama hurahama keke ya ri aki. Hinde wowani, wunu ka hinga wu hambwaro, Jon ori Gotri mwanji bwarakarandau hima. ");
INSERT INTO kwj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gisi foki hima fwele tani Herot ga wu wausini, ri nuwai rini raro gisi tini ya wu hambwanda. Wondawani Herotiyas i himiyama che ti wui nindo tiki hukwa ti ti ra ra seke ti yitindawani Herot o tini ete ri okokonanda. ");
INSERT INTO kwj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wowani tini ni mwaꞌambwe ri ha kinani ya ri sawe, “Mwe naha kari kau, mwaꞌambwe kipe naha foti keke ni ani siliwa, nini ani ha sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ete wowani nuwai o ti che ni sembe ti yewani ya ti sawe, “E, uku yasindau hima Jon i mwa ni peleti tenge tiki ma owesini ma ani ha.” ");
INSERT INTO kwj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","O hinga ti sawewani, king sembe ti nomo naha ya rini a. Woro rini ga funda linindani ahirahi wu andau hima lei miyaningisopo tiki, mwe naha kari kau ri naro keke ri hambwafuni ya ri sawe, “Do mwaꞌambwe ma tini ha.” ");
INSERT INTO kwj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wosini hima fo ri humbwewani kalapus wondau aka tokwe ri ini Jon kwele tini ya ri takuto. ");
INSERT INTO kwj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Rini takutosini mwa rihi ti peleti tenge fotiki owesini ratani o humwe chongo ni ya tini ha. Wowani ti nuwai tambwa ya ti raꞌai. ");
INSERT INTO kwj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ete wosiwani Jon ri himache le tani hima tape dinga ti raꞌaini ya wu si. Wu sisini wu ini Jisas ni ya wu sawe. ");
INSERT INTO kwj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wowani Jisas o mwanji ri mendini o michi ri andosini kanu foki ri rauni ri litisini hima da nambwe michi fotiki rini bati ya ri i. Wowani ele himiyama hurahama o tini wu mendisini wui ko wu andosini rini wu sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ini kanu ri andosini fwa gamba tiki ri etisini ri heiwani himiyama hurahama miyafo ya wu da. Wowani sembe mwe naha wunu keke ri woni ele wui hahungo hima fweleni kipe ti ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wondawani sundukowani ri himache le rini tambwa wu tani ya rini wu sawe, “Do michi hima nambwe michi, nika ti sisinahiro. Ma wunu humbweꞌiwa ele wui ko tokwe sa wu ini ahirahi ti wakini sa wu a.” ");
INSERT INTO kwj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ete wowani Jisas ya wunu sawe, “Bwele keke wunu a humbweꞌiwa wu ino? Kunjenga ahirahi ma wunu hawa sa wu a.” ");
INSERT INTO kwj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wowani ya rini wu sawe, “Nunu ahirahi miyafo nambwe. Nunu bereti tapaꞌangi ga fwaiꞌomwe ti fisi tombwa dau.” ");
INSERT INTO kwj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ete wowani ya ri sawe, “Opi ahirahiche ma ani rata.” ");
INSERT INTO kwj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wosini ele himiyama hurahama ri sawewani ki tenge tiki wu litisiwani o tapaꞌangi bereti ga fwaiꞌomwe fisi ga ri torosini hewen tokwe ri mauni Gotri ni ri weseꞌasini o fwaiꞌomwe ga o bereti ga ri lepikasini ri himache leni ri hasiwani ele himiyama hurahama ni ya wu haꞌi hatanda. ");
INSERT INTO kwj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wowani o ahirahi wu a awani sembe ti ya wunu tale. Ete wowani ahirahi gomu gamwe ti wu rukoni tapaꞌangi tapaꞌangi hatachi fisi hala tiki ya wu waro. ");
INSERT INTO kwj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","O ahirahi wu aro hima hinga tinda ete 5,000, kichapwa himiyama lenga gandi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ete wosini Jisas, ri himache le wu mwaseni wu i kinani wunu ekichasiwani kanu tenge tiki wu rau wu litisini fwanjuwei angi tokwe ya wu rachi. Wondawanumbwa rinjenga ele himiyama hurahama leni ri humbwewani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wu isiwani rini ri Yapai ni ri uchahambwa kinani kimba laka tiki ya ri rau. Sunduya iwani rini bati o kimba ki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wondawani kanu oti fwanjuwei wemi ki indawani ausuwa laka ti saini kanu indau soko tokwe sini fwa o tini yembekinawani tani kanu o tini hapa tinga ya ye. O keke kanu i kinani ya anakwendau. ");
INSERT INTO kwj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kapwa apwe gindawani Jisas fwanjuwei tenge tiki ri eti eti ele ri himache le tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wondawani rini wu heiwani fwa tenge tiki eti eti ri tandawani wu akini ya wu sawe, “Ka ambusuwa foꞌo?” O hinga wu bwakoni ata ti ya wu gi. ");
INSERT INTO kwj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ete wowani metengei ete Jisas ri mendini ya wunu ri sawe, “Kunu yakinani ma ku eti. Ando a tandau. Apa ku aki kei.” ");
INSERT INTO kwj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ete wowani Pita mwanji wasa ka hinga ya ri sawe, “Apukolaka, e, mini naha nawa ma ani sawewa mini tambwa fwa tenge tiki ani eti eti a ta.” ");
INSERT INTO kwj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wowani Jisas ya rini sawe, “Ma ta.” Ete wowani Pita kanu ri hanjaꞌaisini fwa tenge tiki ri eti eti Jisas tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ri indani ausuwa tini ri heini ri akikoni fwa we tiki kamindache ya ri rai. Wofunu ri uchani ya ri sawe, “Apukolaka, ma ani okula.” ");
INSERT INTO kwj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ete wowani metengei ba ete Jisas tapa dachinani Pita ni ri torosini ya rini sawe, “Sembe mi haro ti kapwacheche naha. Hinde wowani, mini inaka fisi mi hambwandau?” ");
INSERT INTO kwj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wosini kanu tenge tiki fi rauwani, ausuwa laka oti ya humbu. ");
INSERT INTO kwj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ete wowani ele hima kanu tenge tiki wu daro ti, rini wu lotu woni ya wu sawe, “Mwe naha, mini Gotri Che.” ");
INSERT INTO kwj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","O fwanjuwei wu yetikinani wu rachini Genesaret mapwa ki ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wosiwani ele kipe hima le ya wu hambwa, o Jisas to taro. O hinga wu hambwakoni mwanji ti ele ko takai hinga tinda ete wu humbweꞌi humbwetawani hahungondaro hima wuhi le rini tambwa ya wu rata. ");
INSERT INTO kwj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wosini ya rini wu sili, “Dele nui hahungondau hima le nikaꞌari sumbu mihi tunumbwa sa wu toro.” Ete wosiwani ele hahungo hima rini tororo leto tinda ete kipe ti ya wu wosi. ");
INSERT INTO kwj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ka gisi ki Farisi hima fwelenga Gotri lo mwanji hambwandau hima fwelenga Jerusalem wu andosini Jisas tambwa wu tani ya wu sawe, ");
INSERT INTO kwj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Hinde wowani kale mi himache le nui atei hima to owero sumbu tini wu sirinanda nambwe? Ahirahi wu akoni Gotri miyaningisopo tiki kipe wu sira kinani tapa wuhi ti wu yokonda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wowani Jisas mwanji wasa ya wunu ri sawe, “Hinde wowani o kui sumbu hukwe tumbwa ete ku sirinandani Gotri lo mwanji tini ku sawesiyaꞌaindau? ");
INSERT INTO kwj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gotri ete sawero, ‘Mini mi nuwai yapai ni sumbu kipe mi woni mwanji fihi tini ma sirina. E, hima fori ri nuwaiꞌi ri yapai ni kapwa mwanji ri bwano ti, ori hima sa ri ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Woroti kundo o mwanji ku jamekosini ka hinga ku sawendau: ‘E, hima fori ri nuwai yapai ni ete ri sawewa, “Kini ani hakoro ya mwaꞌambwe hinga Gotri aka laka ki ani owero,” ");
INSERT INTO kwj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","woro o sumbu hinga to kipe, o ya mwaꞌambwe ki ri nuwai yapai ni okulano sumbu to sa biya da.’ O mwanji hinga ku sawendau ti keke Gotri mwanji tini ku takichasini kui sumbu hukwe tumbwa ku rasaindau. ");
INSERT INTO kwj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kunu nimba gambo hima! Gotri mwanji bwarakarandaro hima, Aisaiya, ka hinga ete kunu sawero, ");
INSERT INTO kwj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Delehaꞌa himiyama hurahama hi ahi tini takisopo wuhi tiki nimba rasaindau. Woroti sembe wuhi tito ani ni apahime naha ete dau. ");
INSERT INTO kwj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wosini hima to wosiro sumbu tunumbwa wu ondiyakandiyani sawe, “Dohaꞌa oti Gotri mwanji.” Wosini nimba ani ni ete wu lotu wondau.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wowani Jisas kale himiyama hurahama ni ri uchawani wu tawani ya wunu ri sawe, “Norukweni ma ku mendini ku hambwa. ");
INSERT INTO kwj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Takisopo ki rawaindau ahirahi le hima ni kisi wonda nambwe. Mina. Ka sembe we kipe mwaꞌambwe to takisopo ki sukwani hoko tokwe sirandau tito hima ni kisi wondau.” ");
INSERT INTO kwj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wondawani o gisi ki ri himache le tani ya rini wu sawe, “Mini mi mendinda nambweꞌe, kale Farisi hima le do mwanji mihi ni wu mendisini mini ni sembe enge ti wu andau ti?” ");
INSERT INTO kwj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wowani mwanji wasa ka hinga ya wunu ri sawe, “Ai Yapai hewen ko tiki ri dau ti, rini rupwa chele. Kale rupwa pe mwaꞌambwe hinga rinjenga ri si nambwe leni nanji tinga tinda ete ri gwano. ");
INSERT INTO kwj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma wunu ku andosiwa sa wu da. Wunu miyasa, wosini miyasa hima leni numbo ti wu mekundau. Woroti miyasa fori miyasa hima forini numbo ti ri mekusino ti, o fini anaꞌape fi ini wa tiki fi raino.” ");
INSERT INTO kwj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wowani Pita Jisas ni mwanji wasa ya ri sawe, “Mini do mwanji yepe mi bwaro ti, mwanji mu mwe ti ma sawewa nu mendi.” ");
INSERT INTO kwj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ete wowani Jisas ya wunu sawe, “Kunu okwe hikisafakisa. ");
INSERT INTO kwj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wo kunu ku hambwanda nambweꞌe? Kale ahirahi hinga takisopo ki rawaiwani sembe we tiki raindau ti, semewa ki yindau. ");
INSERT INTO kwj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","E, takisopo ki hoko tokwe sukwandau mwaꞌambwe oti inaka to sawekawendawani ya sukwanda. O sumbu hinga tombwa hima i sembe ti kisi wondau. ");
INSERT INTO kwj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kale inaka ki sukwandau sumbu ti ka hinga: kapwa inaka rata, hima ni yeni si ti, hima i humwe ni sawe, hili ya, nimba gambo, saweholiya sumbu, e, kale wembisa sumbu. ");
INSERT INTO kwj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kale sumbu hinga tombwa tinda ete hima i sembe ti kisi wondau. Woroti, hima le tapa yoko nambwe ahirahi ano ti, o sumbu hinga ti apa hima i sembe hinde kisi wo kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wosini Jisas o ko ri andosini Taiya, Saiton mapwa tokwe ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wowani Kenan pe humwe foti tani ya ti ucha, “Apukolaka, mini Defit i che. Ani keke mi woni ma ani okula. Himamwale kapwa ti ai himiyama che ki raisini walambe sumbu wosindau.” ");
INSERT INTO kwj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wowani Jisas mwanji wasa fo ai tini ri sawe nambwe. Ete wowani ri himache leto rini tambwa wu tani rini silisini ya rini wu sawe, “Dohaꞌa humwe ucha ucha nunu sirinandau ti, ma tini sawewa sa i.” ");
INSERT INTO kwj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","O hinga wu sawewani Jisas mwanji wasa ya ai wunu ri sawe, “Gotri ele Isurel pe yapai chele nambwe fe che asa che le kekembwa ri ani rumbwewani a taro.” ");
INSERT INTO kwj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","O hinga ri sawesiwani o humwe to tani Jisas mu tiki ti raini ti ombungwesini ya ti sawe, “Apukolaka, ma ani okula!” ");
INSERT INTO kwj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ete wowani Jisas mwanji wasa ti ya tini ri sawe, “Apa ai che le ahirahi ti hoko pe asa tini ani ha hinga.” ");
INSERT INTO kwj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ete wowani oti humwe ya ai sawe, “Apukolaka, mwe naha ki mi sawero. Woro asa le wui yapai hima awani gomu sikandau tini rukoni wu andau.” ");
INSERT INTO kwj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","O hinga ti sawewani, Jisas ga mwanji wasa ya tini ai sawe, “O bai humwe, sembe ani ni ni handau ti, omwesika naha. Sumbu fo keke ni ani silindau ti, oti nini ki o sukwakonda.” Ete wowani o gisi kumbwa ti himiyama che kipe ya ti ai wosi. ");
INSERT INTO kwj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wosini Jisas o ko andosini Galili fwanjuwei takai tokwe ya ri i. Ri ini kimba tiki ri rauni ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ete wondawani himiyama hurahama miyafo naha rini tambwa tani ya wu wau. Wunu ele seke kapwa hima, miyasa hima, talihapa nambwe hima, mwanji bwanda nambwe hima, e, ba fo ba fo hahungo mendindau hima, ele ni ya wu rata. Wu ratani Jisas i seke mu tiki ya wu owe. Wosiwani kipe ya wunu ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","O hinga ri wosisiwani ele himiyama hurahama inaka miyafo naha ya wu hambwa. Hinde wowani, ele mwanji bwanda nambwe hima le mwanji ai bwandawani, ele talihapa nambwe hima kipe ai wosindawani, ele seke kapwa ai ichiꞌuchandawani, e, ele miyasa hima le ya ai maꞌaikaꞌainda. O keke Isurel pe Gotri hi ni ya wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dani ini Jisas ri himache leni uchawani tawani ya ri sawe, “Ani dele himiyama hurahama keke a wondau. Wunu ani ga gisi namili wu dani wunu ahirahi nambwe. Iche tinga wunu handawa hinde apa wunu a sawewa wu i kumbwa. Foki apa numbo tiki misisiweri wunu dino.” ");
INSERT INTO kwj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wowani ri himache le ya rini sawe, “Dohaꞌa michi hima nambwe. Apa bereti miyafo naha soki nu ratasini dele himiyama hurahama miyafo naha ni nu hano?” ");
INSERT INTO kwj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ete wowani Jisas ya wunu ai sawe, “Kunu bereti geni kunu dau?” Wowani ya wu sawe, “Nunu tapaꞌangi hatachi fisi bereti ga fwaiꞌomwe fisiche tombwa dau.” ");
INSERT INTO kwj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ete wowani Jisas ele himiyama hurahama leni sawewani nuwe tiki ya wu liti. ");
INSERT INTO kwj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wosisini ele tapaꞌangi hatachi fisi bereti ga fwaiꞌomweche fwelenga ri torosini, Gotri ni ri weseꞌasini ya ri lepika. Wosini ri himache leni ya ri ha. Wowani ri himache lenga raꞌaini ele hima ni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wosiwani ele himiyama hurahama miyafo naha wu awani sembe ti ete wunu tale. Ete wosiwani ele ahirahi gomu gamwe nimba dau ti wu rukoni tapaꞌangi hatachi fisi hala ki ya wu waro. ");
INSERT INTO kwj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ele ahirahi aro hima le 4,000 hima hinga. E, che humwe lenga wu gendi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Da hinga woni Jisas ele himiyama hurahama ni sawewani ya wu i. Wosini rini kanu tenge tiki rauni Makatan mapwa tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi hima lenga Satiyusi hima lenga Jisas ni simiyanehei kinani ya wu ta. Wu tani hewen pe sumbu kwambu tini ri wosiwa wu hei kinani ya rini wu sawe. ");
INSERT INTO kwj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ete wowani rini ga mwanji wasa ya wunu ri sawe, “E, niliki ki isangi le ku heiwa ku hambwakonda, ‘Icheki gisi kipe naha.’ ");
INSERT INTO kwj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E, nurumbu tiki niri hiki ti ku heiwani mwa roni sukwasini da. Wowani ya ku saweu, ‘O hinga ti apa kapwa gisi, mwa ti ya yekonda.’ Ei, mwe naha, niri ti sumbu tini kipe naha ku kilindau. Woroti apa Gotri ondiyasiwani sukwandau do gisi sumbu tini ku heini ku hambwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kunu kapwa hima le, Gotri ni saweholiya hima naha. Gotri sumbu kwambu ni ku hei kinani gamboni ku gindau. Wondau ti, apa sumbu kwambu foti hinde kunu a mekusi kumbwa, mina. Jona ki sukwaro sumbu numbwa kunu a mekukondau.” Wosini Jisas wunu hanjaꞌaisini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas himache ele o fwanjuwei wu yetikinasini ya wu hambwa, bereti fwele wu ra ra wu i nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ete wowani Jisas ya wunu ri sawe, “Kunu kipe naha ku hambwandani Farisi hima lenga Satiyusi hima lenga hehenandau wo, yis, wuhi ti ku hambwafwaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wosiwani wunjenga ya wu anambwa anambwanda, “Hinde wowani, bereti nu rata nambwe ti keke ri bwandau.” ");
INSERT INTO kwj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wowani Jisas wui mwanji ti ri hambwani ya wunu ri sawe, “Kunu sembe ha sumbu kuhi ti kapwacheche naha. Hinde wowani kunjenga ka hinga ete ku anambwandau, ‘Nunu bereti nambwe’? ");
INSERT INTO kwj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ka tini ku hambwanda nambweꞌe? Ele 5,000 hima ka tapaꞌangi bereti tini ku haꞌi hatawani wu ani wu wofuwani ahirahi gomu le hala geni ku waroro? ");
INSERT INTO kwj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E, kunu ka tapaꞌangi hatachi fisi bereti kale 4,000 hima leni ku haꞌi hatawani wu ani wu wofuwani ahirahi gomu ti hala geni ku waroro? ");
INSERT INTO kwj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hinde wowani ka hinga ku hambwa nambwe? Ani bereti mwanji tini kunu a sawe nambwe. Ani ete a sawero, ‘Kunu Farisi hima lenga Satiyusi hima lenga wui hehenandau wo, yis, o tini ku hambwafwaꞌai.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wowani ete ya wu hambwa. Rini hehenandau wo, yis, tini wu hambwafwaꞌai kinani ri sawe nambwe, mina. Rini Farisi hima lenga Satiyusi hima lenga wundo ondiyakandiyandau mwanji wuhi tini wu hambwafwaꞌai kinani ri sawero. ");
INSERT INTO kwj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas ri saini ri himache lenga Sisariya Filipai mapwa tokwe wu ini ri himache leni ya ri sili, “Kale himiyama hurahama dori Hima ri Che ni hi ti hinde hinga wu uchandau?” ");
INSERT INTO kwj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ete wowani ya wu sawe, “Fwele ete sawendau, ‘Ori uku yasindau hima ri, Jon, to ai sairo.’ E, Fwele ete sawendau, ‘Ori Ilaicha,’ wowani fwele saweu, ‘Ori Jeremaiya.’ Fwele saweu, ‘Ori Gotri mwanji bwarakarandau hima.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ete wowani Jisas ele ri himache leni ya ri sawe, “Wo kundo hinde hinga ku ani hambwandau?” ");
INSERT INTO kwj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ete wowani Saimon Pita to mwanji wasa ya rini sawe, “Mini Kurais, himamwale ga dau Gotri Che funda naha.” ");
INSERT INTO kwj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wowani Jisas ga Saimon ni mwanji wasa ya ri sawe, “Saimon, Jona i che, mini ma eripeꞌaripe. Do nuwe kipe hima forito do mwanji mini mekusi nambwe. Mina. Ai Yapai, hewen ki dau, to do mwanji mini mekuro. ");
INSERT INTO kwj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Apa mini a sawenda. Mini Pita. Pita mwanji mwe ti ‘humokuto.’ Ani ni sembe hano hima leni do humokuto tenge tiki wunu ani esino. Wosiwa heli kwambu ti hinde wunu diki kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Apa hewen pe kwambu ti tukwano ki ti mini ani hakonda. E, sumbu fweleni do nuwe ki minambwe mi nawa Gotri okwe hewen ko ki o hingambwa ri wosikonda. E, sumbu fweleni do nuwe ki mi ohounawa Gotri okwe hewen ko ki o hingambwa ri wosikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wosini Jisas ele ri himache leni mwanji kwambu naha ki ya wunu ri sawe, “Apa hima fweleni ete ku sawe kei, ani Kurais.” ");
INSERT INTO kwj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","O gisi hinga ambwesini ete i ini Jisas ri himache leni rini ki sukwano sumbu leni ka hinga ya wunu ri mekunda, “Jerusalem ko ki ani iwa, ko aulindau mekupu le, puris hima laka le, e, Gotri lo mwanji hambwandau hima le amwaka ani hani ani yewa ani hasini gisi namili iwa ani ai saino.” ");
INSERT INTO kwj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ete wowani Pita biya hinga rini raꞌaisini mwanji kwambu tiki ya rini sawe, “Apukolaka, minambwe naha! Kahaꞌa sumbu hinga apa mini ki sukwa hinga.” ");
INSERT INTO kwj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ete wowani Jisas ri jamekosini Pita ni ya ri sawe, “Saiten, mini ai gumwa tokwe ma tani i. Mindo ai numbu ti o mi ichakisinda. Mini Gotri inaka tini mi sirinanda nambwe. Mina. Mini hima i inaka tumbwa mi sirinandau.” ");
INSERT INTO kwj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wosini Jisas ri himache leni ya ri sawe, “E, hima fori ani ni ri sirina kinawa ori hima hi rihi tini sa rakaisini me yapweke rihi ti ri kichani sa ri ani sirina. ");
INSERT INTO kwj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","E, hima fori ri himamwale tini ete ri enepesiwa himamwale rihi ti humbuno. E, hima fori ani ni hambwani himamwale rihi ti ri ohumbwewa, ichai o hima himamwale rihi ri ai torono. ");
INSERT INTO kwj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","E, hima fori nuwe pe mwaꞌambwe hinga tinda ete ri torosiwa himamwale rihi humbuwa apa kale mwaꞌambwe hinde hinga rini okulano? Apa ori hima bwele ya mwaꞌambwe ni ri hawa o himamwale rihi ri ai ratano? ");
INSERT INTO kwj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dori Hima ri Che ri Yapai okusindau hi tinga ri ensel le ra ra funda wu takonda. O gisi ki do nuwe ki dau himiyama hurahama lei kipe sumbu kapwa sumbu wasa wunu ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mwe naha ki kunu a sawendau. Hima fwele do ki enindau ti, hinde apa wu ha kumbwa. Minambwe naha. Ete wu dasini dori Hima ri Che Gotri kwambu tinga tawa wu heisinimbwa.” ");
INSERT INTO kwj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wosiwani gisi ti tapaꞌangi hatachi funda isiwani Jisas to Pita, Jemis, ri analongo, Jon, wunu ra ra kimba hime laka fotiki ya wu rau. Wosini wundombwa ya wu da. ");
INSERT INTO kwj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wu dani wu heiwani Jisas tape ti jamekoni ba fo hinga ya ai sira. Wowani ri miyaningisopo ti nika hinga okukoni ri nikaꞌari le wamwa naha hi hinga ya ete oku. ");
INSERT INTO kwj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wosiwani wu heiwani Moses hima pi Ilaicha sikani Jisas ga mwanji ya wu anambwanda. ");
INSERT INTO kwj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wowani Pita o tini ri heikoni Jisas ni ya ri sawe, “Apukolaka, dohaꞌa ki nu dawani kipe naha. E, mi ohounandau ti nawa, dohaꞌa ki teikwara akache namili a kisi, fo mini keke, fo Moses keke, e, foti Ilaicha keke.” ");
INSERT INTO kwj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O hinga ete ri bwandawani, hi hinga okundau hiki wamwa ti sikani ya ete wunu yoho. Wowani o hiki we tiki tumwa foti ka hinga uchani ya wunu sawe, “Dori Che o ai Che, rini keke a wondani sembe ahi rini keke kipe naha ani hambwanda. Woro ri mwanji tini ma ku mendi.” ");
INSERT INTO kwj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ete wowani ri himache le o mwanji wu mendikoni miyaningisopo wuhi ti nuwe tiki wu opulisini aki omwesika naha ki ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wowani Jisas wui mu tiki takai tani wunu ri torosini ya wunu ri sawe, “Ma ku sai. Apa ku aki kei.” ");
INSERT INTO kwj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","O hinga ri sawewani wu mauni hima fo wu hei nambwe, Jisas tombwa ya da. ");
INSERT INTO kwj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wosini o kimba ete wu raindani, Jisas mwanji kwambu ki ya wunu ri sawe, “Apa hima foni do ku heiro sumbu sawe kei, kui inaka ki sa ete dawa, dori Hima ri Che hasini ai saino gisi tiki pwe.” ");
INSERT INTO kwj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ete wowani ri himache le ya rini wu sili, “Hinde wowani kale Gotri lo mwanji hambwandau hima le ete wu sawendau, Ilaicha to Kurais ni mwaseni tano?” ");
INSERT INTO kwj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wowani mwanji wasa ya wunu ri sawe, “Ei, mwe naha, Ilaicha to tani ele mwaꞌambwe tinda ete ri wonorukweno. ");
INSERT INTO kwj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Woroti kunu a sawendau, Ilaicha taro. Wosiwani hima le rini ni wu hambwa nambwe. Mina. Wunu wui okokona tunumbwa wu sirinandani kapwa sumbu ba fo ba fweleni rini wu wosiro. O hingambwa dori Hima ri Che ni walambe o wu wosikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas o hinga sawewani ri himache le ya wu hambwa, oti uku yasindaro hima ri, Jon, ni ri sawero. ");
INSERT INTO kwj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wosini wu ini himiyama hurahama miyafo dau michi tiki ya wu raru. Wowani hima fori Jisas tambwa ri tani ya ri ombungwe. ");
INSERT INTO kwj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wosini ya ri sawe, “Apukolaka, mini ai hurahama che keke ma wo. Rini apwe yitindani hima tape rihi ti walambe naha isindau. Ei, gisi miyafo naha hi tiki ri raindani fwa tiki ri raindau. ");
INSERT INTO kwj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wondawani mi himache le tambwa rini a raꞌaiwani himamwale kapwa rihi ti wu rani wu humbweꞌi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wowani Jisas mwanji wasa ya rini sawe, “Kunu sembe kipe ku ha nambwe hima tiya. Kui inaka ti sawesiyaꞌai tumbwa ku hambwandau. Gisi geni apa kunu ga ete a dano? Numbo geni apa kunu keke ete a wondano? O che ani tambwa ma ani rata.” ");
INSERT INTO kwj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wowani Jisas o himamwale kapwa ni mwanji kwambu ki sawewani, o hima wapache ni andosini ya i. Wowani metengei ete kipe ya ri ai wosi. ");
INSERT INTO kwj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wosiwani ri himache letombwa yanini wu tani Jisas ni ya wu sawe, “Hinde wowani ka himamwale kapwa nundo nu rani rumbwe kinani nu simiyafuro?” ");
INSERT INTO kwj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wowani ya wunu ri sawe, “Sembe ku handau ti, mwe naha ku ha nambwe. O hinga keke ku simiyafuro. Ei, mwe naha ki kunu a sawendau, sembe kuhi ku handau ti, ka masitet tukoche hinga mwe naha ku hasini do kimba ni ete ku sawewa, ‘Ma saini o biya tokwe ini eti,’ wowa apa ino. Ete wowambwa ele sumbu hinga tinda ete ku wono.  ");
INSERT INTO kwj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Woroti ka himamwale kapwa rani humbweꞌino ti, numbo ba fo nambwe, mina. Ahirahi hakindani Gotri ni ete uchahambwandau numbo tombwa oto.” ");
INSERT INTO kwj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wosini Galili mapwa ki funda wu indani Jisas ele ri himache ni ya ri sawe, “Dori Hima ri Che hima lei tapa tenge tiki o wu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Wowa rini wu yeni wu sisiwa gisi namili iwa ri ai ri saino.” Ete wowani ri himache le sembe wuhi ti nomo naha ya wunu i. ");
INSERT INTO kwj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wosini Kapaneyam ko ki wu ini wu raruwani Gotri aka laka keke takisi ya torondau hima le Pita tambwa wu tani ka hinga ya rini wu sawe, “Ka kunu ondiyakandiyandau hima ori Gotri aka laka keke takisi ya handauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wowani Pita ya sawe, “Ei, o ri hakonda.” Wosini aka we tokwe ri raruwani Jisas mwanji rasaini ya rini sawe, “Saimon, hinde hinga mi hambwandau? Do nuwe ki dau king apukolaka le wunu ele takisi ya namoki wu torondau? Wundo wui che leki wu torondau, hima fweleki wu torondau?” ");
INSERT INTO kwj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wowani Pita ya sawe, “Hima ba fweleki wu torondau.” Ete wowani Jisas ya rini sawe, “O hinga nawa king apukolaka le wui che le takisi ya handa nambwe. Ani hewen kipe King Apukolaka i che. ");
INSERT INTO kwj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Woro o hingambwa apa nu wosiwa nunu wu bwano. Woro o sumbu hinga sukwano ti nu diyahandau. O hinga keke fwanjuwei tokwe ma ini huku ti ma wali. Wosini o metengei mi rono fwaiꞌomwe ti takisopo ti ma toroni haunasini mi heiwa humokuto ya foti kai dakonda. O ya ti mini keke, e, ani keke takisi ya hinga ma wunu ha.” ");
INSERT INTO kwj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","O gisi ki ri himache le tani ya rini wu sawe, “Namo naha to Gotri kwambu aulindau hewen ko tiki funda mwasendau?” ");
INSERT INTO kwj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wowani Jisas che forini uchawani ri tawani ele ri himache i nindo tiki ya rini esi. ");
INSERT INTO kwj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Wosini ya ri sawe, “Mwe naha ki kunu a sawendau. E, sumbu hukwe kuhi ku hanjaꞌaisini muku pe che sumbu hinga ku sira nambwe nawa, apa ka hewen pe Gotri kwambu aulindau sumbu ki hinde ku raru kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hima fori hi rihi tini rakaisini do kichapwache hinga ri sirawa rini ele hima fweleni ri dikisini Gotri kwambu aulindau hewen ko tiki rindo apukolaka. ");
INSERT INTO kwj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“E, hima fori ani ni hambwani ka che hinga forini enepeni ratawa, ori hima ani ni enependau. ");
INSERT INTO kwj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“E, ani ni sembe hasindau do kichapwache hinga forini kapwa sumbu mekusiwa ri hichakowa, ori hima miyatapa hinga ti kwele rihi tiki humokuto laka injisini fwa laka ki sa rini rawai. O sumbu hinga rini wosino ti wai hinga, hi tokwe ri raino to kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Do nuwe ki dau hima ele, hima leni kapwa sumbu tiki ai wunu raꞌaindau keke fiya kapwa naha. Mwe naha, do kapwa sumbu hinga ele mapwa ki sukwandau. Woroti o sumbu hinga wosindau hima, rini fiya kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","E, tapa mihi toꞌo seke mihi to kapwa sumbu tokwe mini raꞌaiwa ma takutoni humbweꞌi. Wosiwa tapa funda riꞌi seke funda ritombwa dawa ete da ete da himamwale kipe mi torono. Foki tapa fisiꞌi seke fisi mihi dawa usungwaha da nambwe hi tiki o mini rawaikonda. ");
INSERT INTO kwj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","E, miya mihi tito mini rani kapwa sumbu tokwe mini raꞌaiwa o miya kapwa ma gorini humbweꞌi. Wosini miya funda tombwa dawa ete da ete da himamwale kipe mi torono. Foki miya mihi fisi ete dawa apa mini toroni hi tiki o mini rawaikonda. ");
INSERT INTO kwj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kunu hambwafwaꞌainda, foki do che hinga fweleni ete ku sawe ki, mini kichapwache. Mina. Hinde wowani, wunu okulandau hewen ko kipe ensel leto wu heisini mwanji ti ai Yapai hewen ko ki dau tambwa raꞌaindau. ");
INSERT INTO kwj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hinde wowani, dori Hima ri Che ri sikaro ti, ele kapwa sumbu wondau hima leni ai ri rata ki ri sikaro. ");
INSERT INTO kwj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kunu hinde hinga ku hambwandau? E, hima fori sipisip rihi ti 100 hinga dau. Woro fori yanisiwa apa ri waki nambwe sinoꞌo? Mina. Apa ele 99 sipisip kimba ki ri andosini o sipisip funda waniro tini ri ai ri wakino. ");
INSERT INTO kwj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mwe naha ki kunu a sawendau. Ri wakini o sipisip funda ri heisinimbwa ele 99 sipisip yani nambwe leni dikini ya ri eripeꞌaripekonda. ");
INSERT INTO kwj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Woro hingambwa apa kui Yapai, hewen ko tiki dau, ri inaka ti do che hinga fori apa humbuno tini ri okokonanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“E, mi hiparakambwe fori kapwa sumbu mini wosiwa, ma ini rini ga barikapwa ki linindani kapwa sumbu ri woro ti amwei ma rini sawe. Wowa mi mwanji ri mendiwa, mi hiparakambwe ga tapa ti ma ki anayengunasini sembe wahapi ki ma ki da. ");
INSERT INTO kwj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","E, mi mwanji ri mendi nambwe nawa, hima fisiꞌi funda hinga mi ra ra rini tambwa ma i. O hinga ku wosiwa ri mendi nambwe nawa kunu hima fisiꞌi namili to koti wono gisi ki mwanji amwei rini ni ku sawekonda. ");
INSERT INTO kwj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wui mwanji ri mendi ki ri diyahawa sios mekupu hima leni ma sawe. E, Sios mekupu hima lei mwanji okwe ri mendi ki ri diyahawa, ma rini andosiwa ele hoko pe hima hinga takisi ya toro hima hinga sa ri da. ");
INSERT INTO kwj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mwe naha ki kunu a sawendau. E, sumbu fweleni do nuwe ki minambwe ku nawa Gotri okwe hewen ko ki o hingambwa ri wosikonda. E, sumbu fweleni do nuwe ki ku ohounawa Gotri okwe hewen ko ki o hingambwa ri wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Woroti numbo fonga kunu a sawe. E, kunu hima fisi fopi do nuwe ki mwaꞌambwe fo keke sembe funda fi hani o mwaꞌambwe keke Gotri ni fi uchahambwano ti, ai Yapai hewen ko ki dau ti apa fini ha sindau. ");
INSERT INTO kwj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ei, hima fisi namili hinga hi ahi tini wu hambwasini michi foki wu wauwa, ani wui nindo tiki a dano.” ");
INSERT INTO kwj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ka gisi ki Pita Jisas tambwa tani ya rini sawe, “Apukolaka, ai hiparakambwe fori kapwa sumbu ete ani wosindawa numbo geni kapwa sumbu rihi a rani a humbweꞌino? Ani hambwawani numbo tapaꞌangi hatachi fisi hingaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wowani Jisas ka hinga ya rini sawe, “Ani numbo tapaꞌangi hatachi fisi hinga mini a sawenda nambwe. Mina. Mini a sawe, gisi gisi kapwa sumbu mini wosindau hima fo dawa kapwa sumbu rihi ti ma ete rani rumbweꞌinda. ");
INSERT INTO kwj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“O hinga keke hewen pe kwambu ti mwanji yepe ki a sawewa ka hinga, king apukolaka foto dau hinga. O king apukolaka ele ya mwaꞌambwe rihi nimba raꞌairo ri himache lenga ri wonorukwe ki ri hambwasini gisi ti ya ri owe. ");
INSERT INTO kwj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wosiwani o gisi tawani ri litisini ya mwaꞌambwe nimba huwandari raꞌaindaro hima leni ya wunu ri sawenda. Wondawani ya ti 10 miliyon kina hinga miyafo naha huwandari raꞌaindaro hima ni rini tambwa ya wu rata. ");
INSERT INTO kwj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Woroti wasa ri ai hano ti ya nambwe. Ete wowani king apukolaka kwambu tiki ya rini sawe, ori hima ri che humwe le, e, ri mwaꞌambwe lenga ya wungwa ri jisini huwandari ri raꞌairo ya mwaꞌambwe wasa ai ha ki. ");
INSERT INTO kwj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ete wowani o tau ra himache king apukolaka mu tiki ri ombungwesini ya rini sawe, ‘Ani keke mi woni ma ani nikisi! Wowa ele ya mwaꞌambwe huwandari a raꞌairo ti wasa ratani mini a bwe ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wowani o tau ra himache ni aulindau king apukolaka to rini heini rini keke woni huwandari ri raꞌaindaro ya mwaꞌambwe rini hanjaꞌaisini rini sawewani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ete wowani hoko tokwe ri raruni tau funda fi randau ri nau forini ya ri hei. O ri nau ya ti rini ki huwandari ri raꞌairo ti 100 kina hinga. Wosini o tau funda fi randau ri nau ni kwele fu tiki ri toroni ambitonambusini ya ri sawe, ‘Mini ya mwaꞌambwe huwandari mi raꞌaindaro ti, tinda mi ai hani humburoꞌo?’ ");
INSERT INTO kwj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“O hinga ri bwawani tau funda fi randau ri nau ori seke rakai ombungwesini ya rini sili, ‘Ani keke mi woni ma ani nikisi! Wowa ya mwaꞌambwe wasa ratani mini a bwe ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wowani rini diyaha. Wosini o ri nau ni kalapus tiki ya rini rawaru. Wosiwa ya wasa wakini ri hawambwa. ");
INSERT INTO kwj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ete wowani ele tau funda wu randau himache fwele o sumbu ni wu heini sembe nomo wu ani rini keke woni wu ini wui king apukolaka ni ele sumbu hinga rini wosindaro tini ya rini wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ete wowani o ri tau ra himache ni ri uchasini ya ri sawe, ‘Mini tau ra himache kapwa naha! Metengei mi ani heini mi ichakawani ele huwandari mi raꞌaindaro ya mwaꞌambwe le mini ani hanjaꞌairo. ");
INSERT INTO kwj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ani mini keke a woro. Woro mini ga tau funda ki randau nau mihi fori keke o hingambwa mi wopo kipe naha.’ ");
INSERT INTO kwj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wowani ri apukolaka enge rini ani kalapus aulindau hima lei tapa tenge tiki ya rini ha, wosiwa ele huwandari ri raꞌairo ya le tinda ri hawambwa. ");
INSERT INTO kwj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","E, kunu okwe kui sembe ki, kui hiparakambwe kunu wosiro kapwa sumbu ku rani ku humbwe nambwe nawa, ai Yapai hewen ko tiki ri dau rini okwe o sumbu hinga tunumbwa kunu wosino.” ");
INSERT INTO kwj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas ele mwanji hinga tinda ri bwani ri humbusini Galili mapwa ri hanjaꞌaisini ya ri i, Jutiya mapwa laka Jotan fwa angi kachi tokwe. ");
INSERT INTO kwj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wosiwani himiyama hurahama miyafo rini wu sirinani wu indawani hahungondau hima miyafo le kipe ya ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Wondawani Farisi hima fwele tani rini simiyanehei ki ya rini wu sawe, “Gotri lo mwanji ti hima fori humwe hopwesiwani sumbu fo wowani ai tini humbundau sumbu tini ohounasini dauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wowani Jisas ga mwanji wasa ya ri sawe, “Dohaꞌa mwanji, Gotri chengi ki dau tini ku heini ku hambwa nambweꞌe, ka hinga sawero ti: ‘Injelembwa kapwa Gotri ele mwaꞌambwe hinga tinda ri wosisini opi humwe hura ya ri wosi’?” ");
INSERT INTO kwj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wosini ya ri sawe, “Hima fori ri nuwai yapai hanjaꞌaisini ri ini ri humwe ga ya funda fi dakonda. ");
INSERT INTO kwj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","O keke fini apumbwa apu fi litinda nambwe, mina. Fini forukumbwa ya fi litiu. Woro o sumbu Gotri sawesiro ti, hima fotoꞌo finjenga hinde apa anahumbu kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wowani Farisi hima lenga ya rini sawe, “Hinde wowani Moses injelembwa Gotri lo mwanji nunu hasini ete nunu sawero, ‘Hima fori ri humwe humbu kinawa humwe humbu chengi sa kaini o humwe ni ri hasini sa tini humbu’?” ");
INSERT INTO kwj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ete wowani Jisas ga ya wunu sawe, “Ele kui inaka emendiki naha ku dawani heifuni Moses humwe humbuno sumbu tini kunu ohounaro. Woroti injelembwa kapwa Gotri humwe hura wosiro gisi ki o lo mwanji hinga sira nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka hinga kunu a sawe. E, hima fori ri humwe ti, hima foringa kapwa sumbu ti wo nambwe, nimba tini ri humbusini humwe foni ri hopwewa, ori hima to rinjenga fi anahopwero sumbu tini walambe ri woro.” ");
INSERT INTO kwj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wowani ri himache le ya sawe, “E, hima ri humwe ni humbuno sumbu ti mi sawero hinga nawa, apa hima fori humwe ni ri hopwe hinga, hima wapa hinga ri da ki.” ");
INSERT INTO kwj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","O hinga wu bwawani ya ri sawe, “Himiyama hurahama miyafo do kui mwanji hinga hinde wu sirina kumbwa. Mina. Gotri ohounano hima tombwa hima wapa wu dano. ");
INSERT INTO kwj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ma ku mendi, humwe ni hopwenda nambwe hima le numbo ba fweleki o hinga wu dau. Hima fwele wui nuwai o hinga ete wunu raro. Hima fwele wui hima tape kupu walambe wunu wu wosiwani hima wapa wu dau. Wowani hima fwele Gotri hewen kipe kwambu ni ri hambwasini humwe hopwendau sumbu minambwe ri nasindau. Woro hima fwele do sumbu hinga wu sirina kinawa apa wu sirina sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","O gisi ki hima fwele wui che le rini tambwa ya wu rata. Wunu ete wu hambwaro, rindo ri tapa ti ele che tape tenge wuhi tiki ri owesini Gotri ni ri uchahambwawa kipe naha wunu okulanda ki. Wokowani ri himache leto mwanji kwambu tiki ya wunu bwa. ");
INSERT INTO kwj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Wowani Jisas ga ya wunu sawe, “Ma ku haraꞌaiwa ele che ani tambwa sa wu rata. Apa wunu etipe kei. Mina. Hewen kipe kwambu ti ele che hinga dau hima leni okulandau.” ");
INSERT INTO kwj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wowani tapa rihi ti ele che tape tenge tiki ri oweni ri okulasinimbwa o michi ri hanjaꞌaisini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wosiwani hima fori Jisas tambwa tani ya ri sawe, “Ondiyakandiyandau hima, bwele sumbu kipe hinga tini a wosini ete da ete da himamwale kipe a torono?” ");
INSERT INTO kwj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ete wowani Jisas ya rini sawe, “Hinde wowani sumbu kipe keke mi ani silindau? Gotri rindombwa hima kipe to sa. E, ete da ete da himamwale mi toro kinawa, ele Gotri sawero lo mwanji tinda ma ete sirina.” ");
INSERT INTO kwj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wowani ori hima ya rini sawe, “Kale bwele lo mwanji tini a sirinano?” Wowani Jisas ya rini sawe, “Kalehaꞌa lo mwanji ni: ‘Apa hima yeni si kei. Apa hima i humwe sawe kei. Apa hili ya kei. E, apa hima foni mwanji gambo kei. ");
INSERT INTO kwj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mini mi nuwai yapai mwanji tini ma sirinanda. Wosini minjenga mi okokonandau hingambwa kale biya hima ba fwele o hingambwa ma okokona.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wowani ori hima wapa ya rini sawe, “Dele lo mwanji hinga tinda a sirinandau. Woro bwele lo mwanji hinga ni a sirinanda nambwe?” ");
INSERT INTO kwj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wowani Jisas ya rini sawe, “E, mini sumbu kipe naha tumbwa ete mi sirina kinawa, ma ini mwaꞌambwe mihi le ya wungwa mi jisini ele heifundau hima leni ma humwasini wunu haꞌi hata. Wosiwambwa mini ga ichai hewen ko tiki mwaꞌambwe miyafo mi wauno. O tau hinga mi rani mi humbusini ma tani ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ete wowani ori hima wapache o mwanji ni ri mendini ri hambwafuni inaka tenge miyafo ya ri hambwa. Wokoni ya ri i. Hinde wowani, rini mwaꞌambwe miyafo naha. ");
INSERT INTO kwj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ete wowani Jisas ri himache leni ka hinga ya ri sawe, “Mwe naha ki kunu a sawendau, ya chele hima ri Gotri sumbu kipe tini sirinani hewen kipe kwambu aulindau ki raru ki simiyandau ti, tau kwambu naha. ");
INSERT INTO kwj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Woro ai kunu a sawekonda. Omwe laka foti nikaꞌari kapandau nili sopu tiki raru ki apa ete simiyandano. O hingambwa kari ya chele hima hewen kipe Gotri kwambu sumbu ki ri raru ki simiyafuno.” ");
INSERT INTO kwj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ete wowani ri himache le ka mwanji ni wu mendikoni ete wu apapanani ya wu sawe, “O sumbu hinga nawa Gotri namoni ri raꞌaikondau?” ");
INSERT INTO kwj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wowani Jisas miya wunu numbwa misisini ya wunu sawe, “Hima i kwambu to mina. Woro Gotri kwambu kumbwa ele sumbu hinga apa ri wosino.” ");
INSERT INTO kwj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","O hinga ri sawesiwani, Pita ga mwanji wasa ka hinga ya rini sawe, “Ma hei, nunu ele mwaꞌambwe nuhi nu hanjaꞌaisini ya mini nu sirinanda. Woroti apa bwele mwaꞌambwe wasa ni nu torono?” ");
INSERT INTO kwj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wowani Jisas ya wunu sawe, “Mwe naha ki kunu a sawendau. Dele mwaꞌambwe ako naha sirano gisi ki, dori Hima ri Che ri, hi omwesika laka torosini king apukolaka litindau tei tenge ki ri litino. O gisi ki kunu okwe ku ani sirinandaro ti, ka tapaꞌangi tapaꞌangi hatachi fisi litindau tei tenge ki ku litisini tapaꞌangi tapaꞌangi hatachi fisi Isurel hima mu leni ku aulino. ");
INSERT INTO kwj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E, hima fori hi ahi tini ri sirinaro keke ri tiyamwakichamwa ti, ri hiparakambwe le, ri kahaiche le, ri nuwai yapai le, ri che le, e, ri aku tau le ri hanjaꞌairo ti, rini ele ri hanjaꞌairo mwaꞌambwe wasa hinga miyafo naha ai torosini ete da ete da himamwale ri torono. ");
INSERT INTO kwj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Woro, ele mwaseni sirinandaro himako fwele wu ai jepiwa ele jepiro himako fweleto tani wunu dikini mwaseni wu ikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Hima ni aulindau hewen pe kwambu ti, mwanji yepe ki a sawewa ka hinga: Waini rupwa ni aulindau yapai chele hima hinga. Nurumbumbwa, ete ri saini waini tau rihi rano himache fwele rata ki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ri ini hima fwele ri heiwani wunu o gisi funda kumbwa silifa ya funda wu toro kinani mwanji ti rini ga ya wu inji. Wowani ori waini rupwa hima mwe ri wunu humbwewani ri tau tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wosiwani nika sukwani 9 kilok hinga indawani hima waundau michi ki ri ai ini ri heiwani hima fwele wausini ya nimba wu da. ");
INSERT INTO kwj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wowani ya wunu ri sawe, ‘Kunu okwe ku ini ai waini rupwa ki tau ku ranoꞌo? Wowa tau ku rano chiki hinga ya ti kunu ani ha.’ Wowani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dani ini ori hima nika gondi naha ga nika raini 3 kilok hinga ikondawani ri ai ini o hingambwa tumbwa ete ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Wosini da hinga woni rai rai nika yendawani ri ai ini ri heiwani hima fwele ai wu wausini ya wu da. Wowani ya wunu ri sawe, ‘Hinde wowani ahaꞌa gisi funda laka nimba ku dau?’ ");
INSERT INTO kwj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ete wowani wunu ga mwanji wasa ya ai wu sawe, ‘Nunu hima fo tau nu ra ki nunu ondiyasi nambwe.’ “Wowani ya wunu ri sawe, ‘Kunu okwe ma tani ai tau tokwe ku i.’ ");
INSERT INTO kwj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hunduwani tau chele hima mwe ri, ri tau ra himache leni aulindau hima ni ya ri sawe, ‘Ma wunu uchawa sa wu tawa ya ti ma wunu ha. Ele gumwa ki naha ki taro tau ra himache leni metengei ma wunu ha ha ini pwe metengei naha taro tau ra himache le bwe ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ele tau ra himache rai rai nika ki wu ini tau raro hima le wu tani silifa ya funda funda ya wu toro. ");
INSERT INTO kwj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ete wowani ele metengei naha nurumbu ki wu ini tau raro himako le ka hinga ya wu hambwa, ‘O ya laka o nu torokonda.’ Woroti mina. Wunu okwe silifa ya funda funda numbwa ya wu toro. ");
INSERT INTO kwj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","O keke sembe enge wu ani o tau chele hima mwe ni gumwa tokwe ya rini wu bwanda. ");
INSERT INTO kwj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wondani ka hinga ya rini wu sawe, ‘Dele gumwa ki naha ki taro hima le wunu tau kamindache naha wu raro. Wosiwani ya ti wunu mi haro ti, nunu mi haro hingambwa mi haro. Woroti nundo metengei nurumbu naha nu tani tau nu randawani nika sukwani nui tape tenge ki ye yeni ete rai.’ ");
INSERT INTO kwj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wowani tau chele hima ori wui nindo tiki dau tau ra himache forini mwanji wasa tini ka hinga ya ri ai sawe, ‘Ai nau, ani kapwa sumbu fo mini a wo nambwe. Do nurumbu mwanji kunu ga nu injiro hingambwa silifa ya funda funda o kunu ani ha to. ");
INSERT INTO kwj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ya mihi ma toroni ya mi i. Ai okokona tiki o ya mini ani haro hingambwa kale biya gumwa ki taro hima leni o hingambwa ani haro. ");
INSERT INTO kwj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","O ai okokona hingambwa ani haro. Woro ai okokona ki ya ahi ani ha hingaꞌa? Hinde wowani sembe amwaka mi andau? Wo sumbu kipe wunu a wosiro kekeꞌe?’ ");
INSERT INTO kwj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Woro o hingambwa to sa: Ele gumwa ki taro hima le wu mwasewa ele mwasero hima le ai tani jepino.” ");
INSERT INTO kwj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wosini Jisas Jerusalem ko laka tokwe ri ikoni ri Himache tapaꞌangi tapaꞌangi hatachi fisi le numbwa ri rani ya ri i. Wondani numbo tiki Jisas ka hinga ya wunu sawe, ");
INSERT INTO kwj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ma ku mendi. Nu ini Jerusalem nu raruwa, dori Hima ri Che ni puris hima laka le, e, Gotri lo mwanji hambwandau hima lei tapa tenge tiki o rini wu hakonda. Wosiwa rini wu kotimwosini rini yewa ri hano mwanji tini ya wu injikonda. ");
INSERT INTO kwj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wosini hima kupu ba fweleni rini wu hasiwa rini saweholiyandani rini tanambwasini me yapweke tiki rini yewa ya ri hakonda. Wosiwa gisi namili iwa ri ai saino.” ");
INSERT INTO kwj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","O gisi ki Sepeti humwe fi che pinga Jisas tambwa ya wu ta. Wu tani fi nuwai nuwe tiki ti ombungwesini sumbu foti keke ya rini ti sili. ");
INSERT INTO kwj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wowani Jisas ya tini sawe, “Nini bwele mwanji tini ni ani sawekondau?” Ete wowani ya rini ti sawe, “Ma ohounawa dopi ai che King Apukolaka hinga mi linindano gisi ki mini ga takaini fi litinoꞌo, fori mi tapa mama tokwe litiwa fori tapa usanji tokwe sa liti?” ");
INSERT INTO kwj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","O hinga ti sawewani Jisas ga mwanji wasa ka hinga ya wunu sawe, “Kunu ku hikisasini do mwanji ku ani siliro. Woro ando amwaka a mendikondau hingambwa kunu okwe o hingambwa ku mendinoꞌo?” Wowani ya rini fi sawe, “Ei, si mendi sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wowani Jisas ya ai fini sawe, “Mwe naha amwaka a mendino hinga ki mendino. Woroti namoto ai tapa mama tokwe litiwa namoto ai tapa usanji tokwe litino ti, o ai tau mina. Dopi tei litino hima pi, ai Yapai tombwa fini otokunasindau.” ");
INSERT INTO kwj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ete wowani ele ri tapaꞌangi tapaꞌangi himache le o mwanji ni wu mendini opi wui hiparakambwe fisi ni sembe enge ti ya fini wu a. ");
INSERT INTO kwj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","O hinga wu wowani Jisas wunu uchawani rini tambwa wu tawani ya wunu ri sawe, “Kunu ku hambwandau, ele hima ba fwele wui king apukolaka le wui himache leni aulindau ti, mwanji kwambu tiki wu bwandawani wu mendini wu akikoni ya wu sirinau. ");
INSERT INTO kwj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Woro o sumbu hingambwa apa kui nindo tiki sukwa hinga, minambwe naha. E, hima fori kui nindo ki kunu aulino hima laka hinga ri eti kinawa, rini kui himache hinga kui tako tiki sa ri da. ");
INSERT INTO kwj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E, hima fori kui apukolaka ri eti kinawa, rini kui tau ra himache hinga sa ri da. ");
INSERT INTO kwj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Woro hingambwa dori Hima ri Che ri taro ti, hima leto rini okula ki ri ta nambwe, mina. Rini do nuwe kipe hima leni ri okula ki ri taro, wosini himamwale rihi ti ele himiyama hurahama keke wungwa ri jisiwa wunu ri ai ri rata kinani.” ");
INSERT INTO kwj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wosini Jeriko wu hanjaꞌaisini ya wu i. Wondawani himiyama hurahama miyafo Jisas ni wu sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ete wondawani miyasa hima fisi opi numbo takai naha ki ya fi lininda. Fi linindani fi mendiwani wu uchani ya wu sawe, “Jisas ahaꞌa numbo ki o tanda.” Ete wowani hapa tinga ka hinga ya fi ucha, “Apukolaka, mini Defit i che, sini keke mi woni ma sini okula!” ");
INSERT INTO kwj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wowani ele hima fi gaina kinani mwanji kwambu tiki hapa tinga ya fini wu sawe. Wondawani fini hapa tinga ka hinga ya fi ai ucha, “Apukolaka, mini Defit i che, sini keke mi woni ma sini okula!” ");
INSERT INTO kwj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ete wowani Jisas etisini fini uchani ya fini sawe, “Kini bwele sumbu hinga tini kini a wosi kinani ki ani uchandau?” ");
INSERT INTO kwj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wowani ya rini fi sawe, “Apukolaka, si miya kipe mi wosi kinani mini si uchandau.” ");
INSERT INTO kwj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ete wowani Jisas fini keke woni, tapa rihi ti fi miya ki ri owewani metengei ete fi ripakoni ya fi maꞌaikaꞌai. Wosini rini fi sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wu ini Jerusalem wu takaisini Olif kimba laka wa ki dau Betefasi ko ki ya wu raru. Wosini Jisas ri himache fisi ri humbwewani fi ikowani ");
INSERT INTO kwj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ya fini sawe, “Ki ini ko cheche ki raruni o ko cheche ki ma ki maꞌaikaꞌainehei. Wokoni metengei ete dongi fo o ki heikonda, kupu tiki wu injisiwani che tinga o fi eninda. Woroti, opi dongi ma ki hungosini che ga nuwai ga ma ki ani rata. ");
INSERT INTO kwj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","E, hima fori mwanji fo kini sawewa, ka hinga ya ma ki sawe, ‘Si Apukolaka tau chele. Wowani heifuni nuwai ga che ga ete si raꞌaindau.’ Metengei ete o hinga ki bwawa o kini ohounawa ki takonda.” ");
INSERT INTO kwj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dohaꞌa sumbu sukwaro ti, injelembwa Gotri mwanji bwarakarandaro hima fori bwaro mwanji hingambwa sukwaro. Ka hinga ri sawero: ");
INSERT INTO kwj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saiyon pe hima leni ka hinga ma ku sawe: ‘Ma ku hei, kui king Apukolaka kunu tambwa o tanda. Dongi che tenge ki ri litisini hima wahapi sumbu tinga o tanda.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wosiwani Jisas himache opi fi ini o fini ri sawesiro hingambwa ya fi wosi. ");
INSERT INTO kwj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wosini opi dongi nuwai ga che tinga ya fi rata. Fi ratasini tapa huwe siyoti fihi ti opi dongi tenge ki ya kau fi yeto. Wosiwani Jisas o tenge ki ri litisini ya ri tanda. ");
INSERT INTO kwj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wondawani ele himiyama hurahama miyafo nikaꞌari wuhi le numbo tiki wu yeto yeto ya wu inda. Wondawani hima fwele me tali tini wu yekuto yekuto ratani numbo tiki ya wu yeto yeto inda. ");
INSERT INTO kwj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wowo hima fwele Jisas ni dikisini wu mwaseni wu indau lenga fwele jepini tandau lenga ka hinga ya wu uchanda, “Defit i che ni ma nu eripeꞌaripe! Gotri ri kwambu ti Apukolaka hi tiki tandau ori hima ni sa ri okula. Gotri hi tunumbwa ma nu rasai!” ");
INSERT INTO kwj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas ini Jerusalem ko laka ki ri raruwani o ko kipe himiyama hurahama le wu apapanani ya wu sawe, “Dorihaꞌa hinde na hima?” ");
INSERT INTO kwj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ete wowani rini ga indaro hima le ya wu sawe, “Jisas mwe ri oto, rini Galili mapwa ki dau Nasaret pe Gotri mwanji bwarakarandau hima.” ");
INSERT INTO kwj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Wosini Jisas Gotri aka laka we tiki ri raruni wungwa jindau hima leni ya wunu ri sahumwa. Wondani Gotri aka laka ki ya leni anaha anahandau hima lei tei leni ri yisiyesindani, apwenumwa ki ya wungwa jindaro hima le linindaro tei okwe ri toroni ya ri humbwenda. ");
INSERT INTO kwj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wosini ya wunu ri sawe, “Gotri chengi ete sawero: ‘Aka ahi ti ka hinga wu sawekondau, Gotri ni uchahambwandau aka.’ Woroti kundo hiliya hima hinga ku tani o Gotri aka ki ku yanisini ku wondau.” ");
INSERT INTO kwj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wosini Jisas Gotri aka laka o tiki kwai ri dawani, miyasa hima le, e, seke kapwa hima fwele rini tambwa wu tawani kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ete wondawani puris hima laka lenga Gotri lo mwanji hambwandau hima lenga Jisas ele hima apapanandau sumbu ni ri wosindawani o tini ya wu hei. Wondawani ele che to Gotri aka laka we ki wu uchani ka hinga ya wu sawenda, “Defit i che ni ma nu eripeꞌaripe!” Ete wowani opi sumbu ni wu heikoni sembe wuhi ti enge ya wunu a. ");
INSERT INTO kwj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wokoni ya rini wu sawe, “Ka mwanji wu bwandau tini mi mendindauꞌu?” Wowani Jisas ya wunu ri sawe, “Ei, a mendinda. Woroti, kunu ka Gotri mwanji chengi tiki dau, ku hambwa nambweꞌe, ka hinga ete sawero ti: ‘Mini ele kichapwache ga ele muku andau che lenga takisopo wuhi ti mi haunasiwani hi mihi wu rasaini wu uchandau’?” ");
INSERT INTO kwj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ete wosini wunu ri hanjaꞌaisini ko laka hoko tokwe ri raruni Betani ko ki ri isini o niliki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nurumbumbwa ete Jisas ko laka tokwe ri ai ri raru kinani ri indawani iche tinga ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wokoni ri maꞌaini ri heiwani me hi foti, fik, o ri ino numbo gamba naha ki ya eninda. Woroti takai ri i ri heiwani mwe fwele wa nambwe, mina. Minga le tombwa dawani ri heifuni ya ri sawe, “Mwe apa mi ai wa hinga. Minambwe naha a nasindau.” Ete wowani metengei ete me mwe oti ya ete rikaꞌai. ");
INSERT INTO kwj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wowani ri himache le o sumbu ni wu heikoni wu apapanani ya wu sawe, “Hinde wowani o bai fik me metengei ete rikaꞌairo?” ");
INSERT INTO kwj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ete wowani Jisas mwanji wasa ya wunu ri sawe, “Mwe naha ki kunu a sawendau, e, sembe mwe naha ku hani sembe fisi ku da nambwe nawa do fik me ni a wosiro sumbu hinga kunu okwe ku wosikonda. Woroti do sumbu numbwa mina, ele sumbu hinga tinda ku wosino. E, ete ku sawewa, ‘Do kimba, ma saini o bai soluwara ki chunani rai,’ wowa apa rai sindau. ");
INSERT INTO kwj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E, sembe ku hasini Gotri ni ku uchahambwawa, ele mwaꞌambwe keke ku uchahambwaro ti tinda ku toro sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wosini Jisas Gotri aka laka ki ri rarusini ele himiyama hurahama ni ya wunu ri ondiyakandiyanda. Wondawani puris hima laka lenga Isurel pe mekupu hima lenga rini tambwa wu tani ya wu sawe, “Mini bwele kwambu hinga ni mi torosini dele tau hinga mi randau? Namoto do kwambu mini haro?” ");
INSERT INTO kwj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wowani Jisas ga mwanji wasa ka hinga ya wunu ri sawe, “Ani okwe mwanji fotini kunu a silineheikondau. E, mwanji wasa ahi ku sawewambwa ani ga bwele kwambu hinga a torosini dele tau a randau tini kunu a saweno. ");
INSERT INTO kwj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Woro uku yasindaro hima, Jon, kwambu soki ri torosini tau rihi ri randaro? Kwambu rihi ti Gotri to rini haroꞌo, hima leto rini haro?” O tini wu mendikoni wunjenga ya wu anambwa anambwa, “E, ete nu sawewa, ‘O Gotri to haro,’ wowa apa ka hinga o nunu ri sawekonda, ‘Wo hinde wowani sembe rini ni ku ha nambwe?’ ");
INSERT INTO kwj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","E, ete nu sawewa, ‘O hima leto rini haro,’ wowa apa ele hima ni nu heini nu akikonda. Hinde wowani, wunu tinda ete ka hinga wu hambwandau, Jon ori Gotri mwanji bwarakarandaro hima fo.” ");
INSERT INTO kwj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wofunu Jisas ni mwanji wasa ka hinga ya wu sawe, “Nunu nu hikisandau.” Wowani Jisas ga ya wunu sawe, “O hinga ti, ani okwe apa kunu a sawe hinga, kwambu soki a torosini dele tau a randau. ");
INSERT INTO kwj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Woro, kunu ka mwanji yepe ni hinde hinga ku hambwakondau? Yapai fori dawani ri hurahama che pi fisi. Wowani yapai ini mwa laka che ni ya ri sawe, ‘Ai che, apa ma ta ini waini rupwa ki tau ti randa.’ ");
INSERT INTO kwj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wowani che mwa laka rihi ori ya sawe, ‘Ani a diyaha.’ Wosinumbwa dani ini inaka rihi ti jamekowanimbwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wowani yapai ai ini ri hipache ni ri che mwa laka ni sawero hingambwa ya ri sawe. Ete wowani ya ri ohouna, ‘Ei, yapai, ani ikonda.’ Woroti ori che i nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Woro opi che fisi ki namoto yapai mwanji mendini sirinaro?” Ete wowani ele puris hima laka lenga Isurel pe mekupu hima lenga ya wu sawe, “Che mwa laka rito sirinaro.” Wowani Jisas ya wunu ri sawe, “Mwe naha ki kunu a sawendau, takisi ya torondau hima lenga numbo tenge humwe lenga kunu dikisini mwaseni wu ini Gotri aulindau kwambu wu raru sindau. ");
INSERT INTO kwj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Hinde wowani, uku yasindaro hima, Jon, tani sumbu kipe tunumbwa kunu mekundaro ti, sembe rini ni ku ha nambwe. Wondawani takisi ya torondaro hima lenga numbo tenge humwe lenga rini ni sembe wu haro. Woro o sumbu ni ku heisini inaka kuhi ti ku jamekoni sembe kuhi ti rini ni ku ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mwanji yepe fonga ma ku ai mendi. Hima fori nuwe tipa omwesika laka o ki waini sino rupwa tau ri woni waini tuko ri kisini ini ti ya ri injisi. Wosini o tau we ki waini uku dahakino tangi laka fo ya ri esisi. Wosini o rupwa kumbwa kwai o rupwa aulino hima keke aka huwe laka fo ya ri kisi. Ete wosini o rupwa rihi tau ra hima fwele tapa tenge ki ya ri hasi, wosiwa waini ki wungwa jiro ya wu toro toro ya tipa rihi rini wu handa ki. Ete wosini rini ko sumbwe foki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dani ini ele waini mwe numbuno gisi takai tawani o yapai chele rupwa ri tau ra himache fweleni ya ri humbwe, wosiwa wu ini waini mwe rihi fwele wu numbu ki. ");
INSERT INTO kwj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wosiwani wu iwani rupwa ki tau randau hima le ele ri tau ra himache leni wu heini, forini kumbo ba wu tanambwasini, forini wu yewani hawani, forini humokuto ba wu ekeheni ya rini wu ye. ");
INSERT INTO kwj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ete wowani yapai chele rupwa ri himache fweleni ri ai humbwewani ya wu i. Metengei iro tau ra himache le miyafo mina. Wowani ele tau randau hima le wunu heini o sumbu hingambwa tunumbwa ya wunu wosi. ");
INSERT INTO kwj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dani inumbwa ri hurahama che ni ri humbwewani wunu tambwa ri ikowani Yapai ka hinga ya ri hambwa: ‘Do hurahama che ahi ri mwanji o wu mendikonda.’ ");
INSERT INTO kwj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wowani o rupwa tau randau hima le rini ni wu heini ka hinga ya wu anambwa, ‘Ichai dorihaꞌa che ri yapai seke wange o sirinakonda. O keke ma rini nu yeni nu si. Wosini ri yapai rupwa dohaꞌa nundo nu raꞌai.’ ");
INSERT INTO kwj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wosini rini rani rupwa hoko tokwe rini rakwaisini rini yewani ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Woro ka mwanji ni ku hambwawani hinde hinga? Ichai yapai chele rupwa mwe ri tani rupwa tau randau hima leni hinde hinga ri wosikonda?” ");
INSERT INTO kwj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ete wowani ya rini wu sawe, “Apa ele kapwa hima ni walambe sumbu naha ki wunu ri wosi sindau. Wosini o waini rupwa, tau ra hima anandi fweleni ri hasiwa wundo aulindano. Wowa o waini mwe numbuno gisi ki rihi hinga humwasini norukweni raꞌaini rini wu hano.” ");
INSERT INTO kwj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wowani Jisas ya wunu sawe, “Gotri chengi ki dau mwanji fo ku heini ku hambwa nambweꞌe, ka hinga sawero ti?: ‘Dohaꞌa humokuto aka wondau hima leto dukweleni rumbwero tito humokuto kipe naha ai waꞌaisini o aka ni mwe naha ekikinasindau. Apukolaka to o sumbu hinga ri wowani siraro ti nu heiwani kipe naha.’ ");
INSERT INTO kwj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Woro o keke kunu a sawendau. Apa Gotri aulindau kwambu rihi kunu hasiro ti, ri ai raꞌaini ele himiyama hurahama ahirahi mwe naha wandau hima leni o ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","E, hima fori do humokuto tenge ki ri raiwa ori hima talihapa rihi ti apa funda ete rini tukumorino. E, do humokuto to hima fori tape tenge tiki sikawa ori hima ni funda ete rini yembisewa hapi hinga ri sira sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wowani ele puris hima laka lenga Farisi hima lenga Jisas o mwanji yepe ri bwaro tini wu mendini ya wu hambwa, ‘Do nunu ni ri sawero.’ ");
INSERT INTO kwj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ete wokoni rini ni wu toroningikoni ele himiyama hurahama ni wu heini ya wu aki. Hinde wowani, ele hima wunu wu hambwandau, Jisas rini Gotri mwanji bwarakarandau hima. ");
INSERT INTO kwj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Wosini Jisas mwanji yepe foti ka hinga ya ai wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hewen pe kwambu ti nuwe pe king apukolaka fori sumbu hinga. Ri hurahama che humwe ri hopwekowani ori king apukolaka ahirahi laka fo ya ri otokuna. ");
INSERT INTO kwj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wosini metengei naha ele hima fwele humwe hopweno ahirahi wu a ki wunu ri sawehambwaro leni ri rata kinani ri tau ra himache fweleni ri humbwewani ya wu i. Wowani wu ta nambwe wu diyahasini ya wu da. ");
INSERT INTO kwj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wofunu ri himache fwelenga ri ai humbwewani wu ikowani ya wunu ri sawe, ‘Ku ini ele hima a sawehambwaro leni ka hinga ma ku sawe, “Ma ku mendi, king apukolaka ahirahi otokunahiro. Bulumakau hura fwelenga hehenaro omwe laka rihi fwelenga nu yeni ete nu woro. Ele mwaꞌambwe hinga tinda ete otokunasindau. Ma ku saiwa nu ini humwe hopweno ahirahi laka nu a.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wosiwani ele ri himache wu ini kale mwanji hinga tinda wunu sawewani ele mwanji ni wu mendini wu sai wu ta nambwe, wunu diyaha. Wunu fori saini ri tau tokwe iwani, fori saini ri ya tau ra ki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wowani hima fweletombwa king apukolaka tau ra himache rihi leni wu toronambusini wunu ningitengini wunu yewani ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","O hinga wu wosiwani king apukolaka sembe enge ri akoni au anaye himache rihi leni ri humbwewani wu ini ele ri tau ra himache ni yero hima leni wu yeni wui ko ti ya wu tu. ");
INSERT INTO kwj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Wosini king apukolaka ri tau ra himache leni ya ri sawe, ‘Humwe hopwe kinani woro ahirahi le otokunasini ya da. Wondawani ele a sawehambwaro hima le wu wosindaro sumbu wuhi ti ai miyaningisopo ki chiki nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","O keke ma ku ini ele numbo sopu ki hima fwele ku heini takisopo mwanji ki ma wunu sawewa sa wu tani humwe hopwekondau ahirahi fwele sa wu a.’ ");
INSERT INTO kwj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","O hinga ri bwasiwani ele ri tau ra himache wu ini ele numbo ki kapwa hima lenga, e, hima kipe lenga wunu heini sawe sawe ya wu raꞌai. Wosini funda wu tani o humwe hopweni ahirahi ano aka tipa ki wu litisiwani wunu heiwani hima miyafo naha. ");
INSERT INTO kwj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ele himiyama hurahama raruni wu wausiwani king apukolaka wunu hei ki o aka tipa ki ya ri raru. Ri raruni ri heiwani hima fori humwe hopwekondau gisi ki soꞌoino nikaꞌari kipe tini ri soꞌoi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ete wowani king apukolaka ya rini sawe, ‘Ai nau, hinde wowani humwe hopweno gisi ki soꞌoino nikaꞌari kipe mi soꞌoi nambwe ahaꞌa ki mi siraro?’ Wowani rini mwanji nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ete wowani king apukolaka ri tau ra himache leni ka hinga ya wunu ri sawe, ‘Seke tapa ma rini injisini kari kwai hundusindau hoko tokwe ma rini rawaru. Wosiwa o hundu ki sa ri dani ri ichakandani fu rihi tini sa ri ai tangindomunanda.’ ");
INSERT INTO kwj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ei mwe naha, Gotri hima miyafo naha rini sirina kinani ri uchandau, woroti rini wui sumbu tini ri hei hei funda funda rihi ri na kinani ri rakarundau.” ");
INSERT INTO kwj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ka gisi ki Farisi hima le ini mwanji ka hinga wu injini ya wu sawe, “Ka bwele mwanji hinga ni nu gambosini Jisas nu toroꞌinjino?” Woro wui inaka ti, kale hima bitawa wu risiwani fe raindau hinga ri raiwa rini wu toroꞌinji kinani. ");
INSERT INTO kwj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wokinani wui himache lenga ele Herot inaka ni ohounani sirinandau himache lenga wu humbwewani Jisas tambwa wu ini ka hinga ya rini wu sawe, “Ondiyakandiyandau hima, nunu nu hambwandau, mini hima kipe naha. Mwanji mwe naha kumbwa ele himiyama hurahama ni Gotri sumbu tini mi ondiyakandiyandau. Mini hi chele hima lenga hi nambwe hima lenga sumbu apumbwa apu wunu ni mi wosinda nambwe, mina. Mini ele hima i inaka ni hambwa hambwa mi sirinanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wondau hinga ma nunu sawe. Hinde hinga mi hambwandau. Takisi ya ti Sisa apukolaka ni wu hanoꞌo, mina?” ");
INSERT INTO kwj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Woroti Jisas wui kapwa inaka ti metengei ba ri hambwakoni ya ri sawe, “Kunu nimba gambo hima tiya, hinde wowani ku gamboni ku ani simiyaneheindau? ");
INSERT INTO kwj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi ya handau humokuto ya foti ma ku ratawa ani hei.” Wowani humokuto ya foti wu ratani ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wosiwani ya wunu ri sili, “Dohaꞌa ya ki dau hima i himamwale tinga hima hi tinga namohi?” ");
INSERT INTO kwj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wowani ya wu sawe, “Sisa, apukolaka hi.” Ete wowani ya wunu ri sawe, “E, Sisa ya mwaꞌambwe ti, o Sisa ni ma ku ai ha. E, Gotri mwaꞌambwe ti, o Gotri ni ma ku ai ha.” ");
INSERT INTO kwj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ete wowani ka mwanji ni wu mendini wu apapanakoni rini wu hanjaꞌaisini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wondawani o gisi kumbwa ele Satiyusi hima fwele Jisas tambwa ya wu ta. Ele hima wunu ete sawendau, matimat ki siro hima le hinde ai sai kumbwa. Wundo wu tani Jisas ni ka hinga ya wu sili, ");
INSERT INTO kwj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ondiyakandiyandau hima, Moses Gotri chengi ki ete nunu sawero, ‘E, hima fori humwe ri hopwesini che ti ra nambwe ri hawa, o ri hipache rito o humwe ni himanguto sa ri rasini ri apwai keke okulasiwa chefahima wili.’ ");
INSERT INTO kwj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Woro apa mwanji fo ya mini nu sawekonda. Injelembwa analongo hima lembwa nui nindo tiki wu daro ti tapaꞌangi hatachi fisi. Wui apwai mwa laka ri humwe fo ri hopwesini ya ri ha, woro rini che nambwe. Wosiwani ri diya rito o humwe ni himanguto ya ri ra. ");
INSERT INTO kwj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ete wosini rini o hingambwa che fo ra nambwe ya ri ha. Wowani ri diya fori o hingambwa. Wowani ri diya fwele o hingambwa, funda funda wu hopwe hopwe wu i ini tapaꞌangi hatachi fisi analongo hima kale tinda ete ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wunu tinda wu hani humbusiwanimbwa jipe naha ki o humwe okwe ya ha. ");
INSERT INTO kwj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Woro ka mwanji ma nunu sawe. Ka matimat ki siro hima le ai wu saino gisi tawa kale tapaꞌangi hatachi fisi analongo hima o humwe ni namoi humwe hinga tini nano? Mi hambwanda, wunu tinda o humwe numbwa wu hopwero to sa.” ");
INSERT INTO kwj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ete wosiwani Jisas mwanji wasa wuhi ti ya wunu ri sawe, “Kunu Gotri chengi ki dau mwanji tinga Gotri kwambu tinga ku hambwanda nambwe. Wosini ambwatinambwati mwanji do ku bwanda. ");
INSERT INTO kwj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matimat tiki siro hima le ai wu saino gisi tawa do anahopwendau sumbu hinga apa hinde wu wosi kumbwa. Mina. Kale kau hewen ko ki dau ensel hingambwa wu dano. ");
INSERT INTO kwj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Woro matimat ki siro hima le ai wu saino sumbu o tini kunu a silineheikondau. Gotri o sumbu ni ri kaini ri humbwero tini ku heini ku hambwa nambweꞌe? Ka hinga ri sawero, ");
INSERT INTO kwj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ani Epuraham Gotri, Aisak Gotri, e, Jekop Gotri.’ Do Gotri haro himako wui Gotri mina, himamwale tinga ete da ete da himako wui Gotri.” ");
INSERT INTO kwj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ete wowani ele himiyama hurahama o ri bwaro mwanji tini wu mendikoni ete ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas o mwanji ni ri bwawani Satiyusi hima le ete ya wu gingai. Wowani Farisi hima le o mwanji ni wu mendikoni ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Woro wui nindo tiki Gotri lo mwanji hambwandau hima fori ya da. Rindo Jisas ni ri simiyanehei kinani ya ri sili, ");
INSERT INTO kwj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ondiyakandiyandau hima, hinde na lo mwanji to funda ri kipe naha, lo mwanji fweleni funda ete dikindau?” ");
INSERT INTO kwj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wowani Jisas ya rini sawe, “‘Kari kau Apukolaka o mi Gotri. Rini keke ma woni, sembe mihi ti, inaka mihi ti, hambwa mihi ti, ma tinda ete rini ha.’ ");
INSERT INTO kwj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Do Gotri lo mwanji to kipe naha funda ete mwasesindau. ");
INSERT INTO kwj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wosini o mwanji ki ri ai ondiyaro lo mwanji ti ka hinga: ‘Mi hima tape keke mi wondau hingambwa ele biya hima ba fwele keke o hingambwa ma wo.’ ");
INSERT INTO kwj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dopihaꞌa lo mwanji fisi pito ele Moses kairo Gotri lo mwanji ga ele Gotri mwanji bwarakarandaro hima le kairo mwanji ga wui mwanji mu naha.” ");
INSERT INTO kwj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi hima le wausini ete wu dawani Jisas ya wunu sili, ");
INSERT INTO kwj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kunu hinde ku hambwandau, Kurais ka namoi anitafenita?” Wowani ya rini wu sawe, “Defit i anitafenita.” ");
INSERT INTO kwj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ete wowani ya ri sawe, “Wo hinde wowani Gotri Himamwale kipe Defit ni ondiyakandiyawani Defit, Apukolaka, rini nandau? Defit rinjenga ka hinga sawe: ");
INSERT INTO kwj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Apukolaka, ai Apukolaka ni ka hinga sawe, ‘Mini ai tapa mama ki ma liti. Wosiwambwa miho mihi leni mi seke tako ki wunu a rawarusiwa wu dano.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","O mwanji ni ma ku hambwa. Defit rinjenga Kurais ni, Apukolaka, ri nandau. O hinga keke Kurais, Defit anitafenita hingambwa ri dau ti, mina.” ");
INSERT INTO kwj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas o mwanji ri bwasiwani hima fori ri mwanji wasa rini sawe nambwe. Wokoni o gisi kumbwa rini ni wu heini ya wu aki. Wosini mwanji fwele ai rini wu sili nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wosinumbwa Jisas mwanji ti ri himache lenga ele himiyama hurahama ga ya wunu ri sawekawenda. ");
INSERT INTO kwj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mwanji mwe ti ka hinga ya ri sawe: “Gotri lo mwanji hambwandau hima lenga Farisi hima lenga Moses wa ki wu etisini Gotri lo mwanji kunu wu ondiyakandiyandau. ");
INSERT INTO kwj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Woro ele Gotri lo mwanji kunu wu bwaro ti, ku mendini ya ma ku sirina. Woro wu wosindau sumbu leni ku heini apa wunu ku sirina kei, minambwe naha. Hinde wowani, Gotri lo mwanji kipe naha wu sawe sawe wunu o tini wu sirinanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wunu kale hurache hinga, nomo ti wui humwe leni tinda wu hasiwani wu fwendisini nomo kwambu wu rani wu indawani wui hurache le gamweche ri wunu okulanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wunu ele sumbu hinga wu wosindau ti, nimba ele hima leto wunu hei kinani wu wosindau. Ei, mwe naha, wunu Gotri lo mwanji kairo nikaꞌari kupu ti wui mwakambe tinga wui tapa ga ficha hinga wu soꞌoisini, e, nikaꞌari kipe laka wuhi le kaꞌapwe ti miyafo naha nikaꞌari gamba gamba tiki wu wosiro tini wu soꞌoindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wondani ahirahi laka woni oweni wu andau gisi ga, e, lotu wondau gisi ga wunu takumwa ki dau hambwandau hima laka lei tei kumbwa wu litindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","E, wunu hima wausindau michi naha ki wunu weseꞌandani ondiyakandiyandau hima hinga wunu ucha kinani wu okokonandau. ");
INSERT INTO kwj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Woroti hima le ondiyakandiyandau hima hinga apa kunu ucha hinga. Minambwe naha. Gotri tombwa ondiyakandiyandau hima kuhi, kunu tinda ete hiparakambwe tumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Do nuwe ki dau hima forini apa kui Yapai ku na hinga. Hewen ko ki dau hima funda naha Gotri numbwa kui Yapai ku nano. ");
INSERT INTO kwj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Apa hima le kunu ni ‘Apukolaka’ kunu ucha hinga. Kui Apukolaka funda naha, rini Kurais. ");
INSERT INTO kwj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kui nindo tiki dau hima laka ri, kui tau ra himache hinga sa ri da. ");
INSERT INTO kwj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","E, hima fori hi rihi tunumbwa ri rasaiwa, Gotri hi rihi ti ri rakaino. E, hima fori hi rihi ti ri rakaiwa, Gotri hi rihi ti ri rasaino. ");
INSERT INTO kwj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Himiyama hurahama le Gotri kwambu wu hei ki wu rarukondawani kundo wunu ni ku ai etipendau. Hinde wowani, ku raru nambwe ku dasini hima le rarukowani o numbo ni ku ai ichakindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Himanguto humwe leni nimba wunu ku gambosini wui aka ti kundo hili ti ku raꞌaindau. Wosini o kapwa sumbu kuhi ku yani kinani Gotri ni gamboni huwe laka ku uchahambwandau. O sumbu keke amwaka wasa kunu ki o takonda. ");
INSERT INTO kwj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Kunu soluwara laka ki ku ichiꞌuchandani, e, nuwe mapwa laka ki ku ichiꞌuchandani hima leni kui himache hinga wu eti kinani wunu ku ratandau. Wosini hima fori kui himache hinga ri waꞌaisiwa hi tokwe ino hima kunu hinga ri sira ki rini ku ratandau. O hinga rini ku wosisiwani ori hima ku wosindau sumbu hinga ri wosikoni apa kunu dikihiro. ");
INSERT INTO kwj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kunu miyasa hima hinga ku sirasini hima leni numbo ku mekusindau ti, kunu hambwafwaꞌai! Ka hinga ku sawendau, ‘E, hima fori Gotri aka laka ni saweni mwe naha kari kau ri nano ti, o sumbu laka mina. Woro hima forito Gotri aka laka ki dau gol ni ri saweni mwe naha kari kau ri nawa, o ri sawero mwanji hingambwa sa ri wosi.’ ");
INSERT INTO kwj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kunu ambwatinambwati, kunu miyasa! Bwele mwaꞌambwe to mwasendau? Gol to mwasendauꞌu, gol ni rakaruwani kipe naha sukwandau Gotri aka laka to mwasendau? Ani hambwawani Gotri aka laka to mwasendau. ");
INSERT INTO kwj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wosini ete ku sawendau, ‘E, hima fori Gotri ni anguꞌomwe handau humokuto tei ni uchani mwe naha kari kau ri nawa, o sumbu laka mina. Woro hima fori humokuto tei tenge ki dau anguꞌomwe leni ri uchani mwe naha kari kau ri nawa, o ri sawero mwanji hingambwa sa ri wosi.’ ");
INSERT INTO kwj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kunu miyasa hima! Bwele mwaꞌambwe to mwasendau? Anguꞌomwe to mwasendauꞌu, anguꞌomwe ni owesiwani kipe naha sirandau humokuto tei to mwasendau? Ani hambwawani humokuto tei to mwasendau. ");
INSERT INTO kwj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","O hinga keke hima fori humokuto tei ni uchani mwe naha kari kau ri nandau ti, o hima hinga humokuto tei ga o tei tenge ki dau anguꞌomwe lenga ri mwanji okulasi kinani opi mwaꞌambwe ki mwe naha kari kau ri nandau. ");
INSERT INTO kwj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","E, hima fori Gotri aka laka tini uchani mwe naha kari kau ri nandau ti, o hima hinga Gotri aka laka ga o aka ki dau Gotri ga ri mwanji okula kinani opi hi ki mwe naha kari kau ri nandau. ");
INSERT INTO kwj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","E, hima fori hewen ko ni uchani mwe naha kari kau ri nandau ti, rini hewen ko ki dau Gotri tei ga o tei ki linindau Gotri ga ri mwanji okula kinani opi hi ki mwe naha kari kau ri nandau. ");
INSERT INTO kwj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Kale rupwa ki dau kichahopucha le ku raro ti, ku humwasini tene tapaꞌangi tapaꞌangi ku owesini tene foti Gotri ni ha ki ya ku ratau. Woro Gotri lo mwanji kipe naha fwele ku hanjaꞌairo le kale: Hima ni kipe na kapwa nanda nambwe sumbu ti, hima keke wondau sumbu kipe ti, e, mwanji mwe naha bwandau sumbu ti. Kale ahirahi ratani Gotri ni ku handau sumbu ti apa ku hanjaꞌai kei, woroti dele sumbu kipe ni ma ku toronambusini ku sirina. ");
INSERT INTO kwj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kunu miyasa hima le, ele hima ni numbo ku mekusi kinani ku wondau! Woro, kunu si le isenge kuhi tiki raisiwani ku roni ku humbwesini ku andau. Woroti kwandi to raisiwani o ga funda ete ya ku au. ");
INSERT INTO kwj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga kunu hambwafwaꞌai! Kunu sembe fisi hima! Kunu hatumwa hapa ti hoko tokwembwa ku yokondau, woro we tokwe kwai hili yandau sumbu tinga kui okokona ni ku sirinandau sumbu ti sukwani kwai kunu talesindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kunu Farisi hima, kunu miyasa! Metengei naha hatumwa we tini kwai ma yoko. Wowambwa hoko tokwe sara kipe o sirakonda. ");
INSERT INTO kwj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kunu Gotri lo mwanji hambwandau hima lenga Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Kunu matimat hinga, hoko tokwe peni wamwa hindisiwani heiwani kipe naha. Woroti matimat wa ti kai hima haro hapa lenga tikisapu lenga mu musundau. ");
INSERT INTO kwj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Woro kunu o hingambwa ku dau. Hima leto hoko tokwe kunu heini ete wu hambwandau, ele hima kipe. Woro sembe we kuhi tito sembe fisi sumbu ga Gotri lo mwanji ni yetupwandau sumbu ga ele to kwai funda kunu talesindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kunu Gotri lo mwanji hambwandau hima lenga kunu Farisi hima lenga, kunu hambwafwaꞌai! Kunu sembe fisi hima! Kunu Gotri mwanji bwarakarandaro hima le keke matimat aka ku kisini hima kipe naha haro lei matimat ni kaꞌapwe ku wosisindau. ");
INSERT INTO kwj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wondani ku sawe, ‘Nui melokoꞌatei hima ga ete nu dapo, apa wunu nu okulasini Gotri mwanji bwarakarandaro hima leni hinde apa nu yekoro ambwa.’ ");
INSERT INTO kwj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Woro do mwanji hinga ni ku bwandau ti, kunu okwe wui anitafenita hinga ku bwandau. Do kui melokoꞌatei to injelembwa Gotri mwanji bwarakarandaro hima leni yeni siro. Woro kunu okwe o hingambwa ku wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Woro hingambwa ma ku ini kui melekoꞌatei le wu rasaini wosindaro sumbu hingambwa ma ku wosini sa chiki. Wowa kui sumbu kapwa naha sa sukwa. ");
INSERT INTO kwj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kunu kapwa hopo hinga! Gotri kunu kotimwowa hi tiki ku raikonda. Wo hinde hinga apa ku akini ku ino? ");
INSERT INTO kwj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“O keke ma ku mendi. Ani Gotri mwanji bwarakarandau hima fwelenga, hambwa kipe hambwandau hima fwelenga, e, Gotri mwanji ondiyakandiyandau hima fwelenga ete wunu a humbwewa kunu tambwa o wu ikonda. Wosiwa fwele ku yeni ku sindani, fwele ku yeni me yapweke tiki wunu ku yengundani, e, fweleni ku lotu wondau aka kuhi ki wunu ku tanambwandano. Wondawa ko laka foki wu raruwa o sumbu hingambwa wunu ku wosiwa ko laka foki wu ai iwa o hingambwa ya wunu ku wosindakonda. ");
INSERT INTO kwj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ele hima kipe naha ni nindumwasari wunu ku yeni ku sindaro sumbu keke amwaka omwesika naha o ku mendikonda. Injelembwa kapwa kui melokoꞌatei to hima kipe naha fori, Epel, ni ku yeni ku siro gisi ki ku ambwesini ete ta tani Sekaraiya ki ya ku ambwe. Sekaraiya Berekaiya che, ni o Gotri aka laka ga Gotri ni anguꞌomwe handau humokuto tei ga fi nindo naha ki rini ku yeni ku siro. ");
INSERT INTO kwj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mwe naha ki kunu a sawendau. Kunu dele himiyama hurahama apa do ku dau ti, ele kapwa sumbu hinga tinda kui melokoꞌatei wosindaro ti keke ichai amwaka omwesika laka ya ku mendikonda. ");
INSERT INTO kwj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, kunu Gotri mwanji bwarakarandau hima le ku yeni ku sindani, Gotri kunu tambwa humbwero ri tau ra himache fweleni humokuto ba wunu ku takeheni wunu ku yendau! Numbo miyafo a tani kale apwetoko che nuwai tipi sopu tiki wu rarundau hinga kunu a ratani a waukondawani mina, kunjenga ku diyaharo. ");
INSERT INTO kwj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Woroti ma ku mendi, apa ko kuhi hangwaicha ki dau aka simba hinga waꞌaino. ");
INSERT INTO kwj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ei, mwe naha kunu a sawendau. Ai miyaningisopo foti hinde apa ku ani ai hei kumbwa, waya kunjenga ka hinga ku sawewambwa: ‘Apukolaka hi tiki tandau hima o rini Gotri ri kwambu sa rini ha.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wosini Jisas Gotri aka laka ri hanjaꞌaisini ri iwani ri himache le rini tambwa wu tani Gotri aka laka ga o tini takaisini dau aka fwelenga rini wu mekusi. ");
INSERT INTO kwj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ete wowani mwanji ya wunu ri sawe, “Kunu dele humokuto kipe naha hinga tinda ku heindauꞌu? Mwe naha ki kunu a sawendau, dele humokuto hinde apa wu hanjaꞌaisiwa ki heiye hinde da kumbwa. Apa tinda wu lendosini o wu rawaikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wosini Jisas Olif kimba ki ri linindawani ri himache letombwa tani ya rini wu sawe, “Ma nunu sawe, hinde gisimbwa, Gotri aka wu lendono sumbu sukwano? Bwele sumbu tito mwaseni sirawa ete nu hambwano, mindo mi ai mi tano gisi ti tahiro, do nuwe ya humbukonda?” ");
INSERT INTO kwj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wowani Jisas ga mwanji wasa ka hinga ya wunu ri sawe, “Kunu hambwafwaꞌaisini ku da. Foki hima fori apa o kunu gambokonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Apa hima miyafo naha wu tani hi ahi tini wu yepeni wu uchani ka hinga o wu sawekonda, ‘Ani andombwa Kurais.’ Wokoni himiyama hurahama miyafo apa o wu gambokonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wondawa au anayendau atahukwa tini ku mendindani au anayeno mwanji suwa tini o ku mendindakonda. O keke kunu hambwafwaꞌaisi. Apa ku apapana kei. Do sumbu kunu a sawendau ti, o sukwakonda, woro, Gotri gisi jipe humbuno tito wayambwa. ");
INSERT INTO kwj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Wondawa ko laka fo saini lo laka fonga opi anayendakonda. King apukolaka fori ri himache fwelenga saini ini king apukolaka fori ri himache fwelenga o wu anayendakonda. Wondawa mapwa fweleki minawe laka dindawa mapwa fweleki iche omwesika laka o wu handakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kale sumbu hinga sukwakondau ti, himiyama to che ra kinani gwai amwaka metengei naha mendindau hinga. ");
INSERT INTO kwj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Woro o gisi ki kunu wu raꞌaisiwa amwaka tinga nomo tinga kunu ha ha o kunu yeni sindakonda. Wondawa hi ahi keke ele mapwa kipe himiyama hurahama tinda ete apa sembe enge o kunu andakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wondawa o gisi kumbwa hima miyafo naha Gotri ni sembe handau sumbu ti tinda ete wu hanjaꞌaikondau. Wosini wu anaꞌomwemendindani hiparakambwe wuhi leni wunu ye kinani sambe sambe ya wunu raꞌaindakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wondawa gambolamboni Gotri mwanji bwarakarandau hima fwele wu saini hima miyafo naha ni apa o wu gambondakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","O hinga wondawa ele kapwa sumbu miyafo naha sukwakondau, wowa hima miyafo naha hima keke wo sumbu o wu hanjaꞌaikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Woro hima fwele o gisi hinga ki kwambu tiki ete wu da dawa gisi jipe tawa ele hima Gotri ai wunu raꞌaino. ");
INSERT INTO kwj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Woro Gotri kwambu ni sawendau do mwanji kipe ni ele nuwe mapwa hinga tinda ete wu bwarakarani wu iwa, ele himiyama hurahama wu mendisiwambwa, gisi jipe o takonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gisi jipe tano gisi ki injelembwa Gotri mwanji bwarakarandaro hima Daniyel ri bwaro mwanji hinga sarahumwarandau kapwa hima fori sukwani Gotri aka laka ki raruni ri etikonda sumbu ti o ku heikonda.” Hima fori do a kairo mwanji ni ri heini ri hambwawa rini sa hambwafwaꞌai. ");
INSERT INTO kwj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Wowa o gisi ki Jutiya mapwa ki dau himiyama hurahama le wu saini wu akini kimba laka tiki sa wu rau. ");
INSERT INTO kwj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hima fori wu litikatindau aka tuwo ki kau ri dawa apa ri aka we tokwe ri raini ri raruni ri usalikamba le ri toro hinga. ");
INSERT INTO kwj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hima fori tau tiki dano ti, apa ri ai ini tapa huwe siyoti rihi ti ri ruko hinga. ");
INSERT INTO kwj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Woro ka gisi ki che sembe ga dau humwe lenga che ni muku handau humwe lenga walambe sumbu fiya wunu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","O keke tikiningo tano gisiꞌi himati gisi ku akini ino keke Gotri ni ma ete ku uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ka gisi ki nomo omwesika naha takondau. Injelembwa do nuwe metengei naha wosisiwani ete ta tani apa okwe do nomo hinga sukwa nambwe. Woro ichai sukwakondau ele nomo i nindo ki ka nomo to omwesika naha. ");
INSERT INTO kwj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","E, Gotri gisi faiche ri owe nambwe nawa, apa ele himiyama hurahama tinda ete wu tikehekondau. Woro mina, Gotri ele hima rihi naro le keke ri hambwafuni gisi faiche hinga ya ri owekonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ka gisi ki, hima fori ete kunu ri sawewa, ‘Ma ku hei, Kurais ahaꞌa ki o da,’ wowa fori ete ri sawewa, ‘Mina, ka biya kwakwa hinga ki o da,’ wowa kunu apa o mwanji ni mendini ku sirina kei. ");
INSERT INTO kwj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hinde wowani, hima fwele tani ka hinga gamboni apa o kunu sawekonda, ‘Ani andombwa Kurais,’ wowa fwele sawekonda, ‘Andombwa Gotri mwanji bwarakarandau hima.’ Wondani hima rasaindau sumbu wu wondani sumbu ba fo ba fo apa ele wu wosindakonda. Ete wondani Gotri rihi nasiro himiyama hurahama leni wu gamboni raꞌai kinani o wu simiyandakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dele mwanji kunu a sawero ti, sumbu mwe sira nambwe kunu a sawenda. ");
INSERT INTO kwj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“E, ete kunu wu sawewa, ‘Ma ku hei, hima da nambwe michi ki kari kaka da,’ wowa apa o michi ki ku i kei. E, ete wu sawewa, ‘Ma ku hei, aka we tiki kari kaka lininda,’ wowa apa o tini ku mendini ku sirina kei. ");
INSERT INTO kwj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hinde wowani, dori Hima ri Che ai tano ti, niri tiki lewaunawani hi okuni ele mapwa hinga taiyani indau hinga amwei ri ai tano. ");
INSERT INTO kwj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Tau ti tusiwani kwambi wanindawa kandiyasa le hangani wu tani o michi ki ya wu waukonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wosiwa nomo laka rano gisi oti ini humbukowa, metengei ete tapwaki nika ti dasikinani hunduwa, nikahako ti hinde apa okuni taiya kumbwa. Ete wokowa ele isangi hinga tinda ete gwani ya namaꞌi namatandakonda. Wowa niri tiki dau mwaꞌambwe kwambu naha le kau ya raꞌaichiꞌuchandakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","O gisi kumbwa niri tiki sumbu fo sirawa, nuwe ki dau hima le dori Hima ri Che ai tano tini wu heikoni ya wu ichakakonda. Wondani wu heiwa dori Hima ri Che Gotri kwambu ga okuni taiyandau hi laka tinga ri soꞌoisini niri tiki dau hiki tenge tiki ri eti eti ya ri sikakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wondawa hambangini tinga fu tinga hapa tinga wuichindawa ri ensel le ri humbwewa wu sikani ele mapwa ele mapwa ki dau rihi ri nasiro himiyama hurahama ele ni wu ratani ya wu waundakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ka fik me ni ma ku hambwa. Uku ti o me tali ki ini kopika ti anandi ai sirawa, ya ku hambwakonda, gisi kipe naha dani nika ti ya yendakonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","O hingambwa ichai ku heiwa dele sumbu hinga tinda ete sukwawa ya ma ku hambwa, ri ai tani lengenumbo takai naha ki ri etihiro. ");
INSERT INTO kwj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mwe naha ki kunu a sawendau, kunu do nuwe ki ku dano himiyama hurahama le ku ha nambwe ete ku dawa dele sumbu hinga tinda sirano tini ku heino. ");
INSERT INTO kwj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Niri tinga nuwe tinga humbuno. Woro ai mwanji tito hinde apa humbu kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Woro, hima fori do gisi ga do amwa ga hinde apa ri hambwa kumbwa. Hewen ko ki dau ensel hima le wunu hambwanda nambwe. Dori ri Che okwe ri hambwanda nambwe. Yapai tombwa o gisi ri hambwandau. ");
INSERT INTO kwj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dori Hima ri Che ri ai tano sumbu ti, Nowa dawani wu wosindaro sumbu hingambwa o wu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Fwa laka ti taleni sukwa nambwe gisi ki hima le ahirahi le wu andani uku sumbwe le wu andani wu anahopwendani ete i ini Nowa sipi tiki ri raruro gisi ki ya wu ambwe. ");
INSERT INTO kwj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Woro wunu sumbu fo sukwano tini wu hambwa nambwe, wunu ele sumbu hukwe wuhi numbwa ya wu wosinda. Wondawani fwa laka ete taleni sukwani wunu yewaliwani ele himiyama hurahama tinda ete uku sumbwe wu ani ya wu ha. Woro dori Hima ri Che ai tano gisi okwe o hingambwa o wu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","O gisi ki hima fisi tau tiki fi dawa, Gotri forini ri raꞌaisini forini tau tiki ya ri hanjaꞌaisikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Humwe fisi nakuhopo ti fi bangendawa, Gotri foni ri raꞌaisini foni o michi kumbwa ya ri hanjaꞌaisikonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","O keke ma ku hambwafwaꞌaisini ku da. Kui Apukolaka ai tano gisi ti ku hambwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Do sumbu hinga ni ma ku hambwa. Hima fori niliki tani hima fori aka ni setapweningisini ri raruni mwaꞌambwe ri raꞌai kinani ri otokunaro tini o aka chele hima mwe ori o tini hambwasini niliki aulini ri dapo apa hili ya hima ori hili hinde ri yakoro ambwa. ");
INSERT INTO kwj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","O hinga keke kunu ma ku hambwafwaꞌainda. Hinde wowani, dori Hima ri Che ri ai tano ti ku hikisafwaꞌaisini ku dawa ete ri tano. ");
INSERT INTO kwj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Hinde na tau ra himache rito sumbu rihi kipe naha, wosini tau norukweni ri randau? Ka tau ra himache to oto. Ri apukolaka tau kipe randau hima ori ni ele ri tau ra himache leni ri auli kinani ya rini esisi, wosiwa ahirahi norukweni wunu ri yakwanda ki. ");
INSERT INTO kwj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wondawa dani ini ri apukolaka ai tani rini heiwani injelembwa ri sawero hingambwa ri sirinani ri wosindau ti nawa, o tau ra himache sa ri eripe. ");
INSERT INTO kwj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mwe naha ki kunu a sawendau, o sumbu hinga ri wowa o ri apukolaka rini esisiwa ele mwaꞌambwe rihi hinga tinda ete rindombwa aulindano. ");
INSERT INTO kwj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Woro ka tau ra himache tombwa kapwa inaka ri hambwani ka hinga ri sawewa, ‘Apa ai apukolaka amahani hinde ri ai ta kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wosini ele tau funda wu randau himache leni ri yendani, ri ini uku sumbwe ani ambwatinambwatindau hima ba fwelenga ya wu ichiꞌuchanda. ");
INSERT INTO kwj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","O hinga ri wondani ri hikisafwaꞌaisini ri dawa gisi foki o ri apukolaka ete ya ri ai takonda. ");
INSERT INTO kwj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wosini o ri tau ra himache ni heini walambe sumbu naha ki ya rini wosikonda. Wosini rini rawaisiwa o ki ele gambolombondau hima lenga ri dani ri ichakandani fu rihi ti ya ri ai tangindomunandakonda. ");
INSERT INTO kwj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Woro o gisi tawa hewen ko ki dau Gotri kwambu ti dele tapaꞌangi tapaꞌangi humwe chongo leni yepero hinga o sirakonda. Hima fori humwe apambwa ri hopwe ki ya ri takonda. Wokondawani wunu ele humwe chongo lamu wuhi lenga wu nangini ya wu i, ri tawa numbo tiki rini wu heini wu ra ra wu ta ki. ");
INSERT INTO kwj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tapaꞌangi humwe le wunu ambwatinambwati, e, tapaꞌangi humwe le wunu inakahambwa. ");
INSERT INTO kwj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ele ambwatinambwati humwe le, wunu uku ti lamu kumbwa wu mongosini o lamu numbwa wu nangini ya wu i. Woroti botoli ki dau karasini raꞌaino ti ya wu hikisa. ");
INSERT INTO kwj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ete wowani ele inakahambwa humwe le wunje karasini ti botoli tiki hisiwasi wu mongosini lamu wuhi tinga rani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wosiwani kari hima humwe apambwa hopwe ki takondau hima ri huwainani ri ta nambwe. Wofunu ele humwe miya ga wunu hipiwani ya wu tukuya. ");
INSERT INTO kwj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ete wondawani nili alase naha ki tumwa laka foti ya ucha: ‘Humwe hopwekondau hima ri apambwa ya tau. Ma ku ini numbo tiki rini ku heini ma rini ku ra ra ku ta.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ete wowani ele humwe chongo wu saini wui lamu le ya wu otokunanda. ");
INSERT INTO kwj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wowani ele ambwatinambwati humwe le ele inakahambwa humwe leni ya wu sawe, ‘Karasini gamwe ma nunu gutosi. Lamu nuhi ti ya usungwahakondau naha.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ete wowani ele inakahambwa humwe le mwanji wasa ya wunu sawe, ‘Mina, do karasiniche hinga kunu ga nunu ga apa hinde chiki kumbwa. Sutuwa tokwe ma ku ini kuhi ti apu ma ku ra.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ete wowani karasini ra ki wu isiwani o humwe hopwekondau hima ri ya ta. Wowani ele lamu otokunaro humwe le rini ga o humwe hopweni ahirahi laka ano aka tiki wu raruwani duwa ti ya dimi. ");
INSERT INTO kwj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wosiwanumbwa ele tapaꞌangi humwe chongo le wu tani ya wu sawe, ‘Apukolaka, apukolaka, aka ma tukwawa nu sira.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ete wowani mwanji wasa ya wunu ri sawe, ‘Mwe naha ki kunu a sawendau. Ani kunu ani hikisandau.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","O sumbu hinga keke kunu hambwafwaꞌaisi. Ri tano gisi ti kunu ku hikisandau. ");
INSERT INTO kwj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Woro hingambwa o gisi tawa Gotri kwambu ti, hima fori ko sumbwe naha ki ri ikoni ele ri himache ni tau ti ri haꞌi hatandau hinga. Ori hima ri tau ra himache leni ri uchawani wu tawani ele mwaꞌambwe rihi hinga wui tapa tenge tiki hisiwasi ya wunu ri haꞌi hata. ");
INSERT INTO kwj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ele tau ra himache wu randau tau kwambu wuhi tini ri heini ri hambwasini ya ti ya wunu ri haꞌi hatanda. Forini 5,000 kina hinga ete ya ri ha, wosini forini 2,000 kina hinga ya ri ha, ete wosini forini 1,000 kina hinga ya ri ha. O hinga wunu ri wosisini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri isiwani metengei ete o 5,000 kina hinga tororo hima ri, o ya kumbwa ya tau ai ri rawani 5,000 kina hinga ya ai sukwa. ");
INSERT INTO kwj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wowani 2,000 kina hinga tororo hima ori o hingambwa ri wowani 2,000 kina hinga ya ai sukwa. ");
INSERT INTO kwj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ete wowani 1,000 kina hinga tororo hima ori, o ya ri raꞌaini wa ri eisini o wa ki ya ri yanisi. ");
INSERT INTO kwj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Gisi miyafo naha isiwanimbwa ele tau ra himache wui apukolaka ya ri ai ta. Wosini ele tau ra himache ya wunu ri haro leni mwanji wunu ga ri bwani ya wu norukwenda. ");
INSERT INTO kwj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wondawani o 5,000 kina hinga raꞌairo hima ori ri takoni ya tau ri rawani sukwaro 5,000 kina ga ete nangini ri tani ya ri sawe, ‘Apukolaka, mwase mini 5,000 kina hinga mi ani haro. Woro o ya ki ani ga a raꞌaisini ya tau a rawani 5,000 kina hinga ai sukwaro.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wowani ri apukolaka ya rini sawe, ‘Mini tau ra himache kipe naha, tau mihi ti kipe naha mi hambwafwaꞌaisini kipe tumbwa mi randaro. Ka tau cheche mi hambwafwaꞌaisini kipe tumbwa mi randaro keke, ai okokona ti, dele ai tau miyafo mindombwa ete mi aulino. Ma tani ani ga si eripeꞌaripe.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Wowani o 2,000 kina raꞌairo hima okwe tani ya ri sawe, ‘Apukolaka, mini 2,000 kina hinga mi ani haro. Woro, ma hei, 2,000 kina a raꞌaisini ani ga ya tau a rawani 2,000 kina hinga ai sukwaro.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ete wowani ri apukolaka ya rini sawe, ‘Mini tau ra himache kipe naha, tau mihi ti kipe naha mi hambwafwaꞌaisini kipe tumbwa mi randaro. Ka tau cheche mi hambwafwaꞌaisini kipe tumbwa mi randaro keke, ai okokona ti, dele ai tau miyafo mindombwa mi aulino. Ma tani ani ga si dani si eripeꞌaripe.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Wowanumbwa 1,000 kina raꞌairo hima ori rini okwe tani ya ri sawe, ‘Apukolaka, ani ani hambwasindau, mini mwanji kwambu tiki mi bwandau hima. Hima fwele tau woni ahirahi kisiwani mi ini ya mi eiu. Nuwe tipa foki hima fori me tuko humbwesiwani saini tuko wasiwani, mi ini tuko ti ya mi numbuu. ");
INSERT INTO kwj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","O keke mini ani akifuni 1,000 kina mihi ti nuwe tiki ani eini a yanisiro. Woro, ya mwe ti kahaꞌa.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ete wowani ri apukolaka mwanji wasa ya rini sawe, ‘Mini tauwofu himache! Ka mi hambwafwaꞌaisindau to sa, hima fori tau woni ahirahi kisiwani ani ini ya ani eiu, e, hima fori nuwe tipa foki me tuko humbwesiwani saini tuko wasiwani ani ini ya a numbuu. ");
INSERT INTO kwj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","O hinga nawa, ya ahi ti bengi tiki mi rawaisipo kipe. Wosipo ai a tani o ya chiki ahi ga a toroni ya fwelenga ai a torokoro. ");
INSERT INTO kwj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","O keke, o 1,000 kina ri tapa tenge ki dau ti ma ku ratani 10,000 kina torosindau ori hima ni ma ku ha. ");
INSERT INTO kwj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hinde wowani, hima fori mwaꞌambwe fwele rini dawa mwaꞌambwe fwelenga ai rini hano. Woro hima fori mwaꞌambwe fisiche hinga rini ga dawa, o mwaꞌambwe rihi raꞌai sindau. ");
INSERT INTO kwj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","O keke dori tau ra himache kapwa ma ku toroni kari kwai hundusindau hoko ki ma rini ku rawaru. Wosiwa o michi ki amwaka laka ri mendini ri ichakandani fu rihi ti sa ri tangindomunanda.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ichai dori Hima ri Che ele ensel ga king apukolaka hinga ri ai tano. Wosini o gisi ki king apukolaka to linindau tei ki ri litino. ");
INSERT INTO kwj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wosiwa ele mapwa ki dau himiyama hurahama le wu tani ri miyaningisopo ki wu wausiwa ri hei hei nerimbe fisi ya wunu ri humwasikonda, kale omwe aulindau hima sipisip lenga meme lenga wu humwasiwani nerimbe fisi wu etindau hinga. ");
INSERT INTO kwj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Woro hingambwa hima fwele tapa mama rihi tokwe ri esisini hima fwele tapa yanji tokwe ya ri esikonda. ");
INSERT INTO kwj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wosiwa King Apukolaka ele ri tapa mama tokwe etiro hima leni ka hinga ya ri sawekonda, ‘Kunu ai Yapai kwambu tini ku tororo. O keke ma ku tani Gotri kwambu aulindau ko ki ma ku raru. Ai Yapai do nuwe metengei naha ri wosiro gisi ki kunu ni ri hambwasini o ko ri otokunaro. ");
INSERT INTO kwj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hinde wowani, injelembwa iche ani handawani ahirahi ku ani handaro. Uku sumbwe hi tinga ani saindawani uku sumbwe ku ani hawani ani andaro. Ani ko ba fope hima hinga a tawani ani keke ku woni kui aka tiki ku ani rakaruro. ");
INSERT INTO kwj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nikaꞌari nambwe a dawani nikaꞌari ku ani hawani ani injindaro. Hahungo a mendindawani ku ani enependaro. E, kalapus tiki a dawani ku tani ku ani heindaro.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wowa ele hima kipe lenga mwanji wasa ka hinga ya rini wu sawekonda, ‘Apukolaka, hinde gisi ki iche ga mini hawani mini nu heini ahirahi mini nu haro? E, hinde gisi ki uku sumbwe hi ga mini saiwani mini nu heini uku sumbwe mini nu haro? ");
INSERT INTO kwj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hinde gisi ki mini ko ba fokipe hima fo hinga mi tawani mini nu heini nui aka tiki mini nu rakaruro? Hinde gisi ki nikaꞌari nambwe mi dawani, nikaꞌari mini nu haro? ");
INSERT INTO kwj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hinde gisi ki siki mi wondawani, e, kalapus tiki mi dawani mini nu aulindaro?’ ");
INSERT INTO kwj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Wowa King Apukolaka ga mwanji wasa ka hinga ya wunu ri sawekonda, ‘Mwe naha ki kunu a sawendau. Ele sumbu hinga ai hiparakambwe fori hi nambwe forini ku wosiro ti, o ani ni ku wosiro.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wosini ele tapa yanji ki enindau hima leni ka hinga ya ri sawekonda, ‘Kunu hi tiki ku raino himako! Ma ani ku andosini ku ini ai Yapai Saiten ga rini ni sirinandau himamwale kapwa lenga wu rai kinani ri otokunaro usungwaha da nambwe hi ki ku rai. ");
INSERT INTO kwj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hinde wowani, injelembwa iche ga ani hani a dawani ahirahi ku ani yakwa nambwe, uku sumbwe hi tinga ani saindawani uku sumbwe ku ani ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ani ko ba fokipe hima hinga a tawani ani keke ku woni kui aka tiki ku ani rakaru nambwe. E, nikaꞌari nambwe a dawani nikaꞌari foti ku ani hawani ani inji nambwe. Siki a mendindani, e, kalapus tiki a dawani ku tani ku ani auli nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ete wowa wunu ga mwanji wasa ka hinga ya rini wu sawekonda, ‘Apukolaka, hinde gisi ki iche mini handawani uku sumbwe hi tinga mini saindawani, e, ko fokipe hima hinga mi tawani, nimba mini nu heindaro. Wondani nikaꞌari mi heifundawani, siki mi mendindawani, e, kalapus tiki mi dawani mini nu heirasirani sumbu kipe mini nu wosi nambwe?’ ");
INSERT INTO kwj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Wowa rini ga mwanji wasa ka hinga ya wunu ri sawekonda, ‘Mwe naha tiki kunu a sawendau, kunu kalahaꞌa ai hiparakambwe fori, hi nambwe forini sumbu kipe ku wosi nambwe keke ani ni sumbu kipe ku wosi nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","O sumbu keke dele himako amwaka laka ti ete ya wu mendindakonda. Woro sumbu kipe sirinandaro hima leto wunje ete da ete da himamwale kipe ya wu torokonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas ele mwanji hinga tinda ri bwani ri humbusini o gisi kumbwa ri himache leni ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ku hambwandau, gisi fisi ini humbuwa gisi laka fo, hi ti, Pasofa, o sukwakonda. Wosiwa dori Hima ri Che rini omwemendindau hima lei tapa tenge tiki rini wu hawa rini toroni me yapweke tiki o rini wu yekonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Woro o gisi ki puris hima lei wui hima laka lenga Juta hima kupu le wui mekupu lenga wu tani puris hima apukolaka fori aka kumbwa ya wu wau, hi rihi ti, Kayafas. ");
INSERT INTO kwj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wu wausini Jisas ni gambosini rini wu raꞌaini wu yewa ri hano mwanji fweleni wu bwani ya wu injinda. ");
INSERT INTO kwj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wondani ya wu sawe, “Apa do Pasofa gisi laka ki o sumbu hinga nu wosi hinga. Foki apa himiyama hurahama leni au mu nu musuno.” ");
INSERT INTO kwj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wondawani Jisas Betani ko tiki sechi okwe aro hima fori, Saimon, ri aka tiki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wondawani humwe foti humokuto ki wosiro botoli tiki dau kuwa kipe tandau weli ti, ya laka ki raro tini, ti nangini rini tambwa ya ti ta. Ti ta ti raruni ti heiwani tei tiki ya ri lininda. Wondawani o kuwa kipe tandau weli ni ti toroni Jisas mwa tiki ya ti owehena. ");
INSERT INTO kwj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wowani ri himache le o tini wu heikoni sembe enge ti ya wunu a. Wokoni ya wu sawe, “Hinde wowani do weli nimba ti timbendau? ");
INSERT INTO kwj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","E, nunu do weli hinga hima foki ya wungwa nu jipo, o ya miyafo nu torosini ele bwarichape hima leni ya nu hau.” ");
INSERT INTO kwj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Wowani Jisas wui inaka tini ri heini ri hambwasini ya wunu ri sawe, “Hinde wowani do humwe ni nomo ku handau? Tini sumbu kipe naha ni ti ani wosiro to sa. ");
INSERT INTO kwj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gisi gisi ele bwarichape hima kunu ga dau. Woro ani kunu ga gisi miyafo hinde apa a da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Doti humwe do kuwa kipe tandau weli ai tape tiki ti owehenaro ti, matimat ki wu ani eini sino sumbu keke ti otokunaro. ");
INSERT INTO kwj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mwe naha ki kunu a sawendau. Dele nuwe mapwa hinga tinda ete do Gotri mwanji kipe ele hima wu bwani indani o humwe ani wosiro sumbu okwe o wu bwani indakonda, wosiwa ti woro sumbu tini inaka miyafo wu hambwandakonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ka gisi ki tapaꞌangi tapaꞌangi hatachi fisi himache rihi fori, hi rihi ti, Jutas Isukariyot, rindo puris hima hima laka le tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ri ini ya ri sawe, “Ya geni ku ani hawa Jisas kui tapa tenge tiki kunu ani hano?” Ete wowani silifa ya ti mekumbo namili ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Woro o gisi ki ambwesini Jisas ni wui tapa tenge tiki ri hano numbo tini ya ri wakinda. ");
INSERT INTO kwj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bereti hehenandau wo, yis, owe nambwe kale gisi laka nindo ki metengei naha sukwandau gisi ki, ri himache le rini tambwa wu tani ya wu sawe, “Mi okokona ti soki ahirahi nu otokunasiwa mi tawa Pasofa ahirahi nu ano?” ");
INSERT INTO kwj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wowani ya ri sawe, “Ma ku ini ko laka ki ku raruni hima fori ku heini ma ete rini ku sawe, ‘Ondiyakandiyandau hima ete sawero. Gisi ahi takaihiro. Ani ai himache lenga Pasofa ahirahi mi aka tiki nu a ki.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wowani wu ini Jisas wunu sawesiro hingambwa ori hima ni wu sawesini Pasofa ahirahi ti ya wu otokunanda. ");
INSERT INTO kwj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wosiwani sunduya ki ri tani ri himache tapaꞌangi tapaꞌangi hatachi fisi lenga o tei ki ya wu liti. ");
INSERT INTO kwj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wosini ahirahi wu andani ya ri sawe, “Mwe naha ki kunu a sawendau, kunu forito ani omwemendindau hima lei tapa tenge tiki o ri ani hakonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ete wowani sembe amwaka wu akoni funda funda ya rini wu sili, “Apukolaka andoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ete wowanumbwa mwanji wasa ka hinga ya ri ai sawe, “Hima mwe ri ri tapa ti ani ga disi we tiki funda si rawairo. ");
INSERT INTO kwj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ei, mwe naha, dori Hima ri Che Gotri chengi sawero hingambwa ya ri hakonda. Woro dori Hima ri Che ni rini omwemendindau hima leni hano hima ri sa fiya walambe rini i! Kari hima nuwai rini ra nambwe napo kipe ri dakoro.” ");
INSERT INTO kwj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ete wowani Jisas ni omwemendindau hima lei tapa tenge ki hakondau hima ri, Juta, to mwanji wasa ya ri sawe, “Ondiyakandiyandau hima, andoꞌo?” Wowani Jisas ya rini sawe, “Ei, mindo o mi sawenda to.” ");
INSERT INTO kwj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pasofa ahirahi wu andawani Jisas bereti fo torosini Gotri ni ri weseꞌani ri lepikasini ri himache leni ri hasini ya ri sawe, “Ma toroni ku a. O ai hima tape.” ");
INSERT INTO kwj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wosinumbwa kapu tiki dau waini uku ri torosini Gotri ni ri weseꞌasini wunu hasini ya wunu ri sawe, “Kunu tinda ete do waini uku ma ku a. ");
INSERT INTO kwj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dohaꞌa o ai fi, woro o fi ki Gotri mwanji fo kwambu ki o injisinda. Himiyama hurahama lei kapwa sumbu rani rumbwe kinani ai fi o owehenakonda. ");
INSERT INTO kwj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kunu a sawendau. Ani apa waini uku ani ai a hinga, ichaimbwa kunu ga ai Yapai dau ko kipe naha ki funda nu wausinimbwa nu ano.” ");
INSERT INTO kwj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wosini hukwa fo wu rasini wu sirani wu ini Olif kimba laka ki ya wu rau. ");
INSERT INTO kwj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ete wosini Jisas ya wunu sawe, “Sembe ku ani haro ti, apa niliki ki kunu tinda ete ku akitiwotikoni ku hichako sindau. Gotri chengi ki ete sawero, ‘Sipisip aulindau hima ni a yewa, ele sipisip anasawe hinga akini berumbuchini ele ikonda.’ ");
INSERT INTO kwj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Woroti ani ai a saini ando a mwaseni Galili mapwa ki ani ikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ete wowani Pita mwanji wasa ka hinga ya ri sawe, “E, ele hima sembe haro ti, mini ni wu heini wu hichakowa ani apa sembe ani haro ti hinde apa a hichako kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wowani Jisas ya rini sawe, “Mwe naha ki mini a sawendau. Do niliki ki apwetoko gi nambwe ete dawa hi ahi tini numbo namili o mi hamisakonda.” ");
INSERT INTO kwj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wowani Pita ya rini sawe, “Ani mini ga ete si hano. Apa ete a sawe hinga, ‘Ani mini ani hikisandau.’ Minambwe naha!” Ete wowani ele ri himache okwe o hingambwa ya wu sawe. ");
INSERT INTO kwj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wosini Jisas ga ri himache lenga michi fo hi ti, Gerisemani, uchandau michi o ki ya wu i. Wosini ri himache leni ya ri sawe, “Kunu ahaꞌa ki ma ku linindawa, ani ini o biya ki Gotri ni ani uchahambwa.” ");
INSERT INTO kwj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ri ikoni Pita ga Sepeti hurahama che fisi ga ri rani ya wu i. Wosini sembe rihi ti nomo sukwakoni ri hambwawani walambe naha ya i. ");
INSERT INTO kwj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wokoni ya wunu ri sawe, “Sembe ahi nomo naha tumbwa ihiro. O keke ya ani hakondau. Kunu ahaꞌa ki ma ku hambwafwaꞌaisini ani ga ku da.” ");
INSERT INTO kwj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wosini biya hinga ri ini ri ombungwesini miyaningisopo nuwe tiki ri rakaisini Gotri ni ka hinga ya ri uchahambwa, “Ai Yapai, Gotri, mi ohounawa do ai sembe nomo ma rani rumbweꞌi. Woroti, mini apa ai okokona tunumbwa sirina kei, mina. Mini mi okokona tunumbwa ma sirina.” ");
INSERT INTO kwj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wosini ri himache le tambwa ri ai ini ri heiwani wunu ya tukuyanda. Wowani Pita ni ya ri sawe, “Hinde wowani ku tukuyandau? Wo ani ga ku dau ti, ka gisi faiche hinga ku hambwafwaꞌaisini ku da hingaꞌa? ");
INSERT INTO kwj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ma ku hambwafwaꞌaisini ku dani Gotri ni ku uchahambwanda, foki apa kunu simiyaneheino sumbu fwele o kunu sukwakonda. Mwe naha, sembe kuhi au saindau, woro talihapa kuhi ti yakinano to mina.” ");
INSERT INTO kwj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wosini numbo fonga ri ai ini ka hinga ya ri uchahambwa, “Ai Yapai, Gotri, do amwaka a mendino tini a ratako kinani a wondau ti, o tini minambwe mi nawa mi okokona tunumbwa ya ma sirina.” ");
INSERT INTO kwj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wosini ri ai tani ri heiwani miya ga wunu hipiwani wu ai tukuyahiro. ");
INSERT INTO kwj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ete wowani wunu ri hanjaꞌaisini ri ai ini tambwa ri uchahambwaro hingambwa Gotri ni ri uchahambwawani numbo namili ya i. ");
INSERT INTO kwj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wosinumbwa ri himache le tambwa ri ai tani ya ri sawe, “Kunu ete ku tukuyandani ku himatindauꞌu? Ma ku mendi, gisi mwe takaihiro. Dori Hima ri Che kapwa sumbu wondau hima lei tapa tenge tiki ya wu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ma ku saiwa nu i. Ma ku hei, ani omwemendindau hima lei tapa tenge tiki ani hano hima mwe ri tani takaihiro.” ");
INSERT INTO kwj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas o mwanji ni ete ri bwandawani tapaꞌangi tapaꞌangi hatachi fisi himache rihi fori, Jutas, ya ri ta. Hima miyafo naha hachangipi huwe lenga mesaripa lenga wu nangini rini ga ya wu ta. Isurel hima kupu lei puris hima laka lenga mekupu hima lenga wunu humbwewani wu taro. ");
INSERT INTO kwj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Numbo ki apambwa wu tandani Jisas ni wu hambwano sumbu foni Jutas ya wunu ri sawe, “Ani ini ori hima ni a yakosini rini ni a tumwatamwaꞌawa ya ma ku hambwa, Jisas ori. Wowa ya ma rini ku toroningi.” ");
INSERT INTO kwj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wu tani rindo metengei ete Jisas ni ya ri sawe, “Ondiyakandiyandau hima, Seꞌe.” Wokoni rini lomongosini ya rini tumwatamwaꞌa. ");
INSERT INTO kwj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Wowani Jisas ya rini sawe, “Ai nau, sumbu fo mi ani wosi ki mi taro ti nawa, o metengei ya ma ete wo.” Ete wowani wu tani Jisas ni ya wu toroningi. ");
INSERT INTO kwj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wowani Jisas ga dau hima forito hachangipi huwe rihi longoni torosini puris hima apukolaka ri tau ra himache ni sekosini wasamba tokwe rini tangesewani o wasamba nuwe tiki ya rai. ");
INSERT INTO kwj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ete wowani Jisas ya rini sawe, “Hachangipi huwe mihi oti daro michi kumbwa ma ai soꞌoi. Ele hima hachangipi huwe ki au anayendau ti, ichai hachangipi to ai wunu sewa wu humbuno. ");
INSERT INTO kwj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka sumbu hinga ni mi hambwanda nambweꞌe? Ani ai Yapai ni a silipo nerimbe tapaꞌangi tapaꞌangi hatachi fisi au anaye hima leni dikino ensel le miyafo naha ri ani hano. ");
INSERT INTO kwj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Woro o hinga a wowa Gotri chengi tiki injelembwa sawero sumbu mwe naha hinde hinga sirano? O keke Gotri chengi ki sawero sumbu hingambwa sa ete sira.” ");
INSERT INTO kwj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wosini o gisi kumbwa ete Jisas ele hima miyafo naha enindawani ya ri sawe, “Ku ani raꞌai ki hachangipi huwe lenga mesaripa lenga ku nangini ku taro ti, hili ya hima forini ku toroꞌinji kinani ku taroꞌo? Gisi gisi himiyama hurahama leni Gotri aka laka we tiki wunu ani ondiyakandiyandawani ka hinga ku tani ku ani toroningi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dohaꞌa sumbu hinga sukwandau ti, injelembwa Gotri mwanji bwarakarandaro hima leto kairo hingambwa sukwandau.” O hinga wowani Jisas ri himache le rini wu hanjaꞌaisini ya wu akini i. ");
INSERT INTO kwj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisas ni toroningiro hima le puris hima apukolaka, Kayafas, tambwa ya rini wu raꞌai. Wondawani Gotri lo mwanji hambwandau hima lenga, mekupu hima laka lenga wu wausini ya wu lininda. ");
INSERT INTO kwj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Rini wu raꞌaindawani Pita rini sirinani apahime hinga wusariche nawosi nawosi ya ri inda. Ri ini puris hima apukolaka i aka tini ini injisiro ti ri raruni apungwandai kicha himako lenga ya ri lininda. Wosini bwele sumbu hinga rini wu wosino tini ri hei ki. ");
INSERT INTO kwj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wondawani puris hima laka lenga kanisol hima lenga Jisas ni mwanji gambono hima leni ya wu wakinda, wowa rini wu yewa ri ha ki. ");
INSERT INTO kwj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wondawani hima miyafo naha wu tani mwanji gambo fwele ya rini wu bwanda. Woroti rini wu yewa ri hano numbo foti wu waki nambwe. Dani inumbwa hima fisi ya sira. ");
INSERT INTO kwj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Fi sirani ya fi sawe, “Dori hima ete sawero. ‘Ani apa do Gotri aka laka a lendosini gisi namili kumbwa ai a rasaino.” ’ ");
INSERT INTO kwj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ete wowani puris hima apukolaka ri saiꞌetisini Jisas ni ya sawe, “Mini mwanji wasa foti mi bwa hingaꞌa? Hinde wowani dele mwanji wundombwa mini bwandau?” ");
INSERT INTO kwj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wowani Jisas rini mwanji foti ri bwa nambwe. Ete wowani puris hima apukolaka ya rini sawe, “Gotri hi tiki mini a silindau, mwe naha kari kau ma na. Mini Kurais, Gotri Cheꞌe, mina?” ");
INSERT INTO kwj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ete wowani Jisas ya rini sawe, “O mi sawe to. Woroti kunu a sawendau, ichai dori Hima ri Che ku heiwa kwambu ga dau Gotri tapa mama tokwe ri linindani hewen ko tiki dau hiki tenge tiki ri etisini ri ai tano.” ");
INSERT INTO kwj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas o hinga ri sawewani, puris hima apukolaka sembe enge rini akoni nikaꞌari rihi ti ri lefehesini ya ri sawe, “Rini Gotri ni saweholiyaro! Apa hima fweleni ri woro sumbu kili kinani ku ai ucha kei. Dori hima apachumbwa naha ki ku mendiwani Gotri ni saweholiyahiro. ");
INSERT INTO kwj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hinde hinga ku hambwandau?” Ete wowani ya wu sawe, “Rini kapwa sumbu chele, rini ri ha sindau.” ");
INSERT INTO kwj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wokoni sungwa ti miyaningisopo tokwe rini wu yisisini ya rini wu ye. Wowani hima fwele rini wu yetapesini ");
INSERT INTO kwj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ya wu sawe, “Mini Kurais nawa ma sawe, hinde na hima to mini yero?” ");
INSERT INTO kwj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wondawani, Pita, aka ni haweini injiro ini we tokwe ya ri lininda. Wondawani tau ra humwe fo tani ya rini sawe, “Mini okwe Galili mapwa kipe Jisas ga funda ki daro.” ");
INSERT INTO kwj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wowani Pita ele hima i mwakambe naha ki ka hinga ya ri sawe, “Ani do mwanji ni bwandau ti, ani hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ete wowani biya hinga ri ai ini o aka rarususirasi tiki ya ri eninda. Wowani tau ra humwe fo ai tani rini heisini ele rini takaisindau himiyama hurahama leni ya ti sawe, “Dorihaꞌa hima Nasaret ko kipe Jisas ga daro.” ");
INSERT INTO kwj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ete wowani Pita ri ai hamisani ya ri sawe, “Mwe naha kari kau, ani ori hima ani hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ai dani ikowani hima fwele o ki enindaro le wu tani Pita ni ya wu sawe, “Mwe naha, mini wui hima kupu fo. Mwanji gale mihi tito amwei mini wohiro.” ");
INSERT INTO kwj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ete wokowani Pita mwanji kwambu ki hapa tinga ka hinga ya ri sawe, “Mwe naha kari kau, ani ori hima ani hikisandau. Minambwe naha.” O hinga ri sawesiwani apwetoko ti ya gi. ");
INSERT INTO kwj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Wokowani Pita Jisas ka rini sawero mwanji ni ya ri ai hambwa, “Apwetoko gi nambwe dawa numbo namili o mi ani hamisakonda.” Pita o tini ri hambwakoni hoko tokwe ri raruni ya ri ichakanda. ");
INSERT INTO kwj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","O nili humbusini lindanawani puris hima laka lenga Isurel ko kipe mekupu hima laka lenga Jisas ni wu yewa ri hano mwanji tini funda wu bwani ya wu mendi. ");
INSERT INTO kwj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wosini seni kupu ki rini wu injisini gapiman apukolaka hima ri tambwa wu raꞌaini ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisas ni omwemendindau hima leni haro hima ri, Jutas, ri heiwani Jisas ni kapwa sumbu woro hima hinga rini wu nasini nomo le ya rini wu handa. Wowani o tini ri heifuni inaka rihi ti ai jamekoni ri hambwafuni ele silifa ya mekumbo namili ri tororo ti, ri ai ri raꞌaini ele puris hima laka lenga mekupu hima laka lenga ya wunu ri ai ha. ");
INSERT INTO kwj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wosini ya ri sawe, “Kapwa sumbu naha ni a woro. Kapwa sumbu fo wonda nambwe hima ni rini omwemendindau hima leni ani haro, o keke ya ri hakonda.” Wowani wunu ga ya wu sawe, “O sumbu nunjenga nu wosi nambwe, o mihi fo.” ");
INSERT INTO kwj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ete wowani Jutas ele silifa ya Gotri aka laka we tiki ri rumbweꞌisini ri sirani ini rinjenga hataikupu ti ya ri fwali. ");
INSERT INTO kwj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wowani puris hima laka le ele silifa ya wu rukosini ya wu sawe, “Ahaꞌa hima ni ye kinani wasinguya longoro ya. Ka ya tapa hinga apa Gotri aka laka ki dau ya lenga funda nu owe hinga.” ");
INSERT INTO kwj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wosini o ya ki nuwe ki hungwe sindau hima ri nuwe tipa foni wu ra kinani mwanji funda wu bwani wu mendisini ya wu ra. Wunu ete wu hambwaro, o nuwe nu rasini matimat nu wosiwa hima kicha hinga taro hima le keke sa da. ");
INSERT INTO kwj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ete wosiwani o nuwe tipa hi ti, Hima Fi Nuwe, ya wu uchasi. Wosiwani o nuwe tipa hi uchasiro o ete da. ");
INSERT INTO kwj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ka sumbu hinga ti, injelembwa Gotri mwanji bwarakarandaro hima ri, Jeremaiya, ri takisopo ki bwaro hingambwa mwe naha ya sukwa. Ete ri sawero, “Wunu silifa ya ti mekumbo namili wu rukoro. Ya mwe oti Isurel hima kupu le rini ni yeni si kinani wasinguya longoro ya. ");
INSERT INTO kwj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wosini Apukolaka ani sawero hingambwa o silifa ya ki nuwe ki hungwe sindau hima ri nuwe tipa fotini ya wu ra.” ");
INSERT INTO kwj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wosini ele hima Jisas ni gapiman apukolaka i miyaningisopo tiki wu esisiwani gapiman apukolaka ya rini sili, “Mini Juta hima kupu lei king apukolakaꞌa?” Wowani Jisas ya sawe, “O mi sawenda to.” ");
INSERT INTO kwj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wosiwani puris hima laka lenga mekupu hima lenga wunu ya rini wu kotimwonda. Wondawani rini mwanji wasa foti ri bwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ete wowani gapiman apukolaka, Pailat, ya rini sawe, “Mini dele hima mini wu kotimwondau mwanji le mi mendinda nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wowani Jisas mwanji wasa fo gapiman apukolaka Pailat ni ri sawe nambwe. Ete wowani gapiman apukolaka inaka miyafo ya ri hambwa. ");
INSERT INTO kwj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ele asama hinga Pasofa gisi laka ki ele himiyama hurahama kalapus hima forini wu rawara kinani gapiman apukolaka ni wu uchani wu sawewani o gapiman apukolaka ori hima ni hanjaꞌaiwani ya ri sirau. ");
INSERT INTO kwj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka gisi ki kapwa hima naha fori kalapus tiki ya ri da, hi rihi ti, Jisas Barapas. Ele hima rini ni wu hambwandau. ");
INSERT INTO kwj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wosiwani ele himiyama hurahama wausiwani Pailat apukolaka ya wunu ri sawe, “Kui okokona ti namo ni kunu tambwa a rawarano? Jisas Barapas ni a rawaranoꞌo, Kurais hi ki wu uchandau Jisas ni a rawarano?” ");
INSERT INTO kwj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Woroti rini ri hambwanda, wunu Jisas Kurais numbwa sembe amwaka wunu andawani ori hima ni ri tapa tenge ki wu haro. ");
INSERT INTO kwj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wosini Pailat apukolaka koti mendindau tei tiki ri linindawani ri humwe mwanji foti ka hinga ti humbwewani ya ta, “Mini apa kapwa sumbu nambwe hima ori ni sumbu foti minjenga wosi kei. Hinde wowani, niliki a tukuyaneheini rini ni ani heisini nomo laka foti do a mendinda.” ");
INSERT INTO kwj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wondawani puris hima laka lenga mekupu hima laka lenga ele hima i sembe ni ya wu yeni rasainda, wowa Pailat Barapas ni ri hanjaꞌaisini Jisas ni ri yewa ha ki. ");
INSERT INTO kwj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ete wowani gapiman apukolaka ya ai wunu ri sawe, “Dopi hima fisi enindau ti, kui okokona ti, namoni ani hanjaꞌaino?” Wowani ya wu sawe, “Barapas.” ");
INSERT INTO kwj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wowani Pailat apukolaka ya wunu ri sawe, “O hinga nawa bwele sumbu hinga ni Kurais hi ki wu uchandau Jisas ni a wosino?” Wowani wunu tinda ete ya wu sawe, “Me yapweke tiki ma rini ye!” ");
INSERT INTO kwj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ete wowani Pailat apukolaka ya wunu ri sawe, “Ori hima bwele kapwa sumbu foni ri woro?” Ete wowani hapa tinga wu ai uchani ya wu sawe, “Me yapweke tiki ma rini ye!” ");
INSERT INTO kwj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wofunu Pailat ya ri hambwa, “Ani bati hinde rini ani okula kumbwa. Foki apa au mu wu musuno.” Wosini uku rini ratawani ele himiyama hurahama lei miyaningisopo ki tapa rihi ri yokoni ri goloni ri rawakasini ya ri sawe, “Dorihaꞌa hima hawa, o ai nomo mina, o kui nomo fo.” ");
INSERT INTO kwj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ete wowani ele himiyama hurahama mwanji wasa ya wu ai sawe, “Dohaꞌa nomo nunu ga nui che lenga nu ra kinawa sa dawa nu ra.” ");
INSERT INTO kwj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ete wowani Pailat Barapas ri hanjaꞌaiwani wunu tambwa iwani, hima fweleni ri sawewani Jisas ni wu tanambwasiwani au anaye hima lei tapa tenge tiki ya ri ha, wowa wundo me yapweke tiki rini wu ye ki. ");
INSERT INTO kwj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wosiwani gapiman apukolaka ri au anaye himache le Jisas ni ra ra gapiman apukolaka aka we ki rini wu rakarusiwani ele au anaye himako tinda ete tani ya rini wu hawei. ");
INSERT INTO kwj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wosini ri nikaꞌari wu dangoni wu humbweꞌisini king apukolaka hinga rini wu hei kinani nikaꞌari naro fotini ya rini wu soꞌoisi. ");
INSERT INTO kwj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ete wosini lame chele kupu tiki king apukolaka letindau mwalinjangwei hinga wu balisini mwa rihi ki ya wu letisi. Wosini suwa kumbo foti tapa mama rihi tokwe wu hasini tatumbu ti rini ni wu ombungwesini ya rini wu saweholiyanda. Wondani ya rini wu sawe, “Seꞌe, mini Juta hima kupu lei king apukolaka!” ");
INSERT INTO kwj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wondani sungwa ti rini wu yisindani, o suwa kumbo kumbwa wu torosini mwa rihi ki ya wu dininda. ");
INSERT INTO kwj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ele sumbu hinga wu woni rini wu saweholiyasinimbwa, o nikaꞌari naro wu dangosini nikaꞌari rihi ki ya ai rini soꞌoisi. Wosini me yapweke tiki rini ye kinani ya rini wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wu indani Sairini hima fori ya wu hei, hi rihi ti, Saimon. Rini wu heisini Jisas me yapweke tini ri kicha kinani ya rini wu ekichasi. ");
INSERT INTO kwj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wosini wu ini michi foki ya wu raru, o michi hi ti, Golikota. Golikota mwanji mu mwe ti ka hinga: Hima mwa hapa dau michi. ");
INSERT INTO kwj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wosini o michi ki awani kwe indau marasini uku ga waini uku fwelenga anahulehusiro tini Jisas a kinani ya wu ha. Wowani ri a ki ri simiyaneheiwani mina, ri a nambwe. ");
INSERT INTO kwj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wosini me yapweke tiki rini wu yesini, o mu kumbwa ri nikaꞌari ni funda funda hisiwasi wu raꞌai kinani minga ti ya wu heinda. ");
INSERT INTO kwj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wosini o michi ki wu litisini ya rini wu aulinda. ");
INSERT INTO kwj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mwa rihi heiye tokwe rini wu yero mwanji mu ni ka hinga kau o wu kaisiwani da: Dori Jisas, Juta hima kupu lei King Apukolaka. ");
INSERT INTO kwj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Woro Jisas takai ki hili ya hima fopini o wu yesinda, fori tapa mama tokwe forito tapa yanji tokwe. ");
INSERT INTO kwj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wosiwani numbo ki ichiꞌuchandaro himiyama hurahama le rini wu hei hei mwa wuhi ti wu rakairasukwandani ya rini wu saweholiyanda. ");
INSERT INTO kwj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wondani ya wu sawenda, “Mini Gotri aka laka ni mi lendosini gisi namili kumbwa mi rasaindau hima. Woro mini Gotri Che nawa minjenga ma ai okulani me yapweke ti ma hanjaꞌaisini ma sika!” ");
INSERT INTO kwj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wondawani puris hima laka le, Gotri lo mwanji hambwandau hima le, e, mekupu hima laka le wunu okwe ka hinga ya wu saweholiyanda, ");
INSERT INTO kwj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hima fweleni ri okularo. Woro rinjenga ri ai okulano ti mina. E, rini Isurel pe King Apukolaka nawa me yapweke ti sa ri hanjaꞌaisini ri sikawa nu heini sembe rini ni nu ha to. ");
INSERT INTO kwj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sembe Gotri ni ri hasini ri sawendaro, ‘Ani Gotri Che.’ Gotri o hinga rini keke ri wondau ti nawa ya sa rini okula.” ");
INSERT INTO kwj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wondawani hili ya hima opi me yapweke tiki fini wu yero ti, fini okwe Jisas ga kau funda wu dani o hingambwa ya rini fi saweholiyanda. ");
INSERT INTO kwj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nika gondi naha tiki dawani ele nuwe mapwa hinga tinda ete hundusini ete da dawani nika ti raini 3 kilok ya i. ");
INSERT INTO kwj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nika ti raini 3 kilok iwani Jisas hapa tinga ka hinga ya ri ucha, “Eli, Eli, lema sapakitani.” Mwanji mu mwe ti ka hinga, “Ai Gotri, ai Gotri, hinde wowani mi ani hanjaꞌairo?” ");
INSERT INTO kwj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wowani hima fweleto takaini enindaro ti, o mwanji ni wu mendini ya wu sawe, “Kari biya hima Ilaicha ni uchandau.” ");
INSERT INTO kwj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wokoni metengei ete wundo forito namani ri ini uku rarundau sopu chele mwaꞌambwe ri ratasini awani fu naha indau uku tiki ri rawaini ri rasukwasini Jisas ni hawa a kinani suwa kumbo tiki fwarisini ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wokowani fweleto sawe, “Waya, nu nikisifuni pwe. Ilaicha tani rini okulakondau poꞌumo mina?” ");
INSERT INTO kwj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ete wowani Jisas hapa tinga ri ai uchakoni ri hingitinakoni ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wowani o gisi kumbwa ete o nikaꞌari laka Gotri aka laka ki yechikinasiro ti tumwafu ki ambwesini lefeheni raini humbuwani tokwe tokwe ya i. Wokowani minawe dini nuwe raꞌichiꞌuchandawani humokuto laka ele ya tuhuwanda. ");
INSERT INTO kwj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wondawani matimat tukwawani Gotri ni sembe hasini haro hima le ya wu ai sainda. ");
INSERT INTO kwj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wunu wu saisiwani dani ini Jisas ai saisiwanimbwa Gotri rihi naro ko laka ki wu raruni wu indawani hima le ya wunu heinda. ");
INSERT INTO kwj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wosiwani au anaye hima le wui apukolaka ga Jisas ni aulindaro hima lenga minawe dini nuwe raꞌichiꞌucharo ele sumbu hinga ni wu heini aki omwesika ki ya wu aki. Wokoni ya wu sawe, “Mwe naha dori hima Gotri Che.” ");
INSERT INTO kwj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wondawani humwe miyafo naha ya wu da, wunu imbihumbwa Galili mapwa ki wu hanjaꞌaisini wu tani Jisas ni wu okulandaro. Woro ele humwe to apahime hinga wu etisini wu maꞌaini ya rini wu heinda. ");
INSERT INTO kwj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Woro humwe fo o wui nindo tiki enindau ti, hi tihi ti, Mariya Makitala. Wowani humwe foti, Mariya, Jemis hima pi Josep nuwai. Ete wowani humwe foti Sepeti che fisi fi nuwai. ");
INSERT INTO kwj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wosiwani sisinawani Arimatiya ko kipe ya chele hima fori ya ta, hi rihi ti, Josep. Rini okwe Jisas ni sirinandau hima fo. ");
INSERT INTO kwj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ri tani Pailat tambwa ri ini Jisas hima tape dinga ni ri raꞌaini ri si kinani ya rini sili. Wowani Pailat au anaye hima ele ni ri sawewani Jisas hima tape dinga ti Josep ni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wowani Josep o ri hima tape ri raꞌaini nikaꞌari wamwa ako naha tiki ya rini beni. ");
INSERT INTO kwj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wosini o hima tape dinga ri raꞌaini humokuto laka fo ki goro matimat ako rihi ki ya rini si. Wosini humokuto beiye laka ri dukweleni ratani o humokuto sopu ki ya ri ichaki. O hinga ri wosini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wondawani Mariya Makitala ga humwe ba fo hi ti, Mariya, ga ya fi da. Fini matimat takai ki fi linindani o sumbu ni ya fi heinda. ");
INSERT INTO kwj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wosiwani Juta hima kupu lei himati gisi keke ahirahi hinga le wu otokunandau gisi ti humbusiwani ai lindanawani puris hima laka lenga Farisi hima lenga wu tani Pailat mu kumbwa ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wosini ya wu sawe, “Hima apukolaka, nunu mwanji foni nu hambwandau, ka nimba gambondaro hima ri mwase ri dasini ka hinga ri sawero ti: ‘Gisi namili iwa ani ai a saino.’ Woro o tini nu hambwandau. ");
INSERT INTO kwj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","O keke mini ma wunu sawewa o matimat norukweni sa wu diminambusini wu aulindawa gisi namili sa ini sa humbu. Foki ri himache le yanini wu tani hili yani rini wu raꞌaisini himiyama hurahama leni ete wu sawe ki, ‘Rini matimat ki ri ai saihiro.’ Wosiwa apa do nimba gambo mwanji to injelembwa pe nimba gambo mwanji o ni o dikikonda.” ");
INSERT INTO kwj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ete wowani Pailat ya wunu sawe, “Au anaye hima fwele ma ku rani ku ini o rini siro matimat ti ku hambwandau hingambwa ma norukweni ku auli.” ");
INSERT INTO kwj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ete wowani wu ini o matimat wu diminambusini o humokuto beiye ki wupa fo wu owesini ele au anaye himako ni wu sawesiwani o matimat ni ya wu aulinda. ");
INSERT INTO kwj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wosiwani himati gisi ini humbusiwani lindanasiwani Sande nurumbu, Mariya Makitala ga humwe ba fo Mariya ga matimat ni hei kinani ya fi ta. ");
INSERT INTO kwj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wokowani metengei ete minawe laka ete ya di. Wowani Gotri ensel fo hewen ko andosini ri sikani o humokuto beiye dukweleni humbweꞌisini o humokuto beiye tenge ki ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Miyaningisopo rihi ti niri to lepakinandau hinga okundani nikaꞌari rihi ti niri wamwa tini heindau hinga sirasiwani ya lininda. ");
INSERT INTO kwj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wokowani au anaye hima ele matimat o tini wu aulinindaro ti, rini wu heini wu akini seke tapa wunu rikirikinakoni haro hima hinga ya ete wu sira. ");
INSERT INTO kwj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ete wokowani ensel hima ori opi humwe fisi ni ya ri sawe, “Kini apa aki kei. O kini ani hambwanda, kini me yapweke tiki wu yero hima ri, Jisas, ni hei ki ki taro. ");
INSERT INTO kwj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Woro rini ahaꞌa ki da numbwa. Rini imbihumbwa ri sawero hingambwa ri ai sairo! Ma ki tani rini wu siro michi ti ki hei. ");
INSERT INTO kwj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wosini ma ete ki imaꞌini ri himache leni ka hinga ma ki sawe, ‘Rini matimat ri hanjaꞌaisini ri ai sairo. Wosini rindo mwaseni Galili mapwa ki o inda. Wosiwa apa ku ini o ki o rini ku heikonda.’ O kini a sawehito. Ya ma ki i.” ");
INSERT INTO kwj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wowani opi humwe fisi fi akindaro ti, eripeꞌaripe omwesika laka foki ete fi eripeꞌaripendani metengei ete matimat fi hanjaꞌaisini ri himache leni fi sawe kinani ya fi namani fi i. ");
INSERT INTO kwj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ete indawani Jisas numbo ki fini ri heini ya fini sawe, “Kapiche, seꞌe.” Ete wowani takai fi ini ri seke ki fi yakonambusini rini ni ya fi lotu wo. ");
INSERT INTO kwj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wowani Jisas ka hinga ya fini sawe, “Kini apa aki kei. Ma ki ini ai hiparakambwe leni ma ki sawewa Galili mapwa ki sa wu i. Wosini o ki wu tani sa apa wu ani hei.” ");
INSERT INTO kwj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wosiwani opi humwe fisi numbo tini ete fi indawani, matimat tini aulindaro au anaye hima fwele wu ini ko laka ki wu raruni ele sumbu hinga tinda wu heiro tini puris hima laka leni ya wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wosiwani puris hima laka ele, mekupu hima laka lenga wu wausini mwanji foti ya wu inji. Wosini au anaye hima leni ya miyafo wu hasini ");
INSERT INTO kwj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ya wu sawe, “Ka hinga ma ku sawe, ‘Nunu nu tukuyandawani ri himache le niliki ki wu tani ri hima tape ti hili yani wu raꞌairo.’ ");
INSERT INTO kwj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","E, gapiman apukolaka do mwanji ri mendini kunu siliwa nunu ga mwanji fwele o rini nu sawekonda, wowa apa kunu kipe. Inaka tenge miyafo hinde apa ku hambwa kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ete wowani au anaye hima ele o ya wu torosini wunu sawero mwanji hingambwa ya wu sirina. Wosiwani do mwanji Juta hima kupu lei nindo tiki ichiꞌuchandani, o mwanji to do ya ete da. ");
INSERT INTO kwj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ete wosiwani ri tapaꞌangi tapaꞌangi hatachi funda himache ele Galili mapwa ki wu ini Jisas wunu sawesiro kimba o ki ya wu rau. ");
INSERT INTO kwj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wosini o kimba ki Jisas ni ya wu hei. Wokoni rini ni ya wu lotu wo. Ete wowani wunu fweleto inaka fisi ya wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Wosiwani Jisas wunu tambwa takai tani ka hinga ya wunu ri sawe, “Gotri hewen ki dau mwaꞌambwe lenga nuwe ki dau mwaꞌambwe lenga tinda ani auli kinani kwambu omwesika laka ri ani haro. ");
INSERT INTO kwj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","O keke ma ku ini ele himiyama hurahama ni ai himache hinga ma ku rata. Wosini Yapai hi ti, Che hi ti, e, Gotri Himamwale hi ti, ele hi wuhi ki uku ti ma wunu ku yasi. ");
INSERT INTO kwj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wosini o kunu a sawesiro mwanji hinga tinda ete ma wunu ondiyakandiyawa ele mwanji hinga tinda ete norukweni sa wu sirinanda. Ma ku mendi. Ani kunu ga gisi gisi ete a dawa do nuwe humbuno.” ");
INSERT INTO kwj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Kurais, Gotri Che, ri mwanji kipe siraro ti ka hinga. ");
INSERT INTO kwj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gotri mwanji bwarakarandaro hima ri, Aisaiya, ri chengi tiki kaisiro: “Gotri ri Che ni ete sawe, ‘Ma mendi, hima fo a humbwewa mini mwaseni ino. Wowa mwanji ahi saweno. Rini mini keke mi numbo ri nambuno. ");
INSERT INTO kwj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hima da nambwe michi tiki ri dani ri uchani ya ri sawe, “Apukolaka i numbo ma ku nambu. Ele ri numbo cheche okwe ya ma ku norukwe.” ’” ");
INSERT INTO kwj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","O mwanji sawero hinga Jon sirawani hima da nambwe michi tiki ele hima ni uku ri yasindani ya sawe, “Kapwa sumbu kuhi ni gumwa ma ku sisini sembe Gotri ni ku hawa uku kunu yasisiwa Gotri kui kapwa sumbu sa humbwe.” ");
INSERT INTO kwj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wowani ele Jutiya mapwa kipe hima hinga, ele Jerusalem ko pe hima hinga, Jon tambwa ya wu i. Wu ini kapwa sumbu wu wondaro ti hima miyafo i mwakambe tiki wu sawewani Jon uku ti ya wunu yasi. ");
INSERT INTO kwj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon o nikaꞌari, omwe laka fo kamel tupu tiki wosiro, o tini ri injisini leti ti himamandemu tiki ri injisini omwengape tinga mwanungwa uku tinga ya ri anda. ");
INSERT INTO kwj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wosini Gotri mwanji ya ri sawe, “Hima fo ai gumwa tiki o takonda. Ri kwambu ti ai kwambu tini dikino. Ando a randau tau kapwacheche. Rindo ri rano tau omwesika naha. ");
INSERT INTO kwj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ani uku minde ki kunu a yasisiwani o hima Gotri Himamwale ki kunu ri ai ri yasino.” ");
INSERT INTO kwj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ete wosini gisi foki Jisas Galili ko fo, Nasaret, andosini ri tawani Jon Jotan gara tiki uku ya rini yasi. ");
INSERT INTO kwj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Rini yasisiwani ri ai ri sukwandau tinga metengei niri ti heiwani tapwasiwani Gotri Himamwale apwenumwa hinga Jisas tambwa ya sika. ");
INSERT INTO kwj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sikasiwani tumwa foti niri we tiki ya sawe, “Mini ai Che. Ani mini ni ete ani okokonanda. Ani mini keke ani eripenda.” ");
INSERT INTO kwj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wosini isiti nambwe Gotri Himamwale Jisas ni humbwewani hima da nambwe michi tiki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisas o hima da nambwe michi tiki gisi ti 40 ri dawani Saiten kapwa sumbu fwele ya rini simiyanehei. Wondawani Jisas fuku pe omwe lenga ri dawani ensel miyafo ya rini okulanda. ");
INSERT INTO kwj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wosiwani Jon kalapus tokwe isiwani Jisas Galili mapwa tokwe tani Gotri mwanji kipe bwani ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Gisi mwe takaisinda. Wowani Gotri kwambu hima i sembe aulindau oti takaihiro. O keke kunu kapwa sumbu kuhi ti gumwa ma ku sisini Gotri mwanji kipe tini sembe kuhi ma ku ha.” ");
INSERT INTO kwj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wosini Jisas Galili fwa gamba tiki eti eti ini heiwani Saimon ga ri analongo Anduru ga tukwa ti fwa we tiki ya fi rawainda. O tukwa rawaindau oti fi ya tau. ");
INSERT INTO kwj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wowani Jisas ya fini sawe, “Kini ma ki tani ani sirina. Wowa kini ani ondiyasiwa kini hima ani keke ki rata.” ");
INSERT INTO kwj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ete wowani metengei tukwa oti fi andosini Jisas ni fi sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wosini biya hinga wu ini Jisas maꞌaini heiwani Sepeti che pi Jon ga Jemis ga, fini kanu tiki tukwa ti ya fi wonorukwenda. ");
INSERT INTO kwj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Fi wondawani fini ri uchawani fi yapai Sepeti ga ele ya tau randau hima fwelenga kanu tiki wu dawani fini wunu fi andosini Jisas ni fi sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wosini wunu Kapaneyam ko tokwe ya wu i. Wu ini himati gisi fo tawani metengei lotu wondau aka tiki wu raruni Jisas hima miyafo leni ya ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wondawani ri mwanji ni wu mendini ya wu apapana. Hinde wowani, Jisas kale Gotri lo mwanji hambwandau hima hinga ri ondiyakandiyanda nambwe. Rini Gotri kwambu ri torosindau hinga ya ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka gisi hima fo o lotu wondau aka tiki dawani himamwale kapwa rini ga da. Ori hima to uchani ya sawe, ");
INSERT INTO kwj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas, Nasaret ko kipe, mini bwele sumbu ni nunu mi wosi ki mi tandau? Mini hinde, nunu mi ye kinani mi taroꞌo? Ani mini ani hambwanda. Mini Gotri hima kipe naha.” ");
INSERT INTO kwj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wowani Jisas kwambu tiki ya ri sawe, “Ata ma gaina! Wosini ma rini andosini ma i.” ");
INSERT INTO kwj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ete wowani o himamwale kapwa ori hima ni yetupwani humbwewani seke tapa ri rikirikinawani o himamwale kapwa ata laka ti ri gikoni rini andosini ya i. ");
INSERT INTO kwj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wowani ele himiyama hurahama miyafo o tini wu heini mwale ti ya wunu sukwani i. O sumbu anandi hinga wosiwani wunu wu anambwa anambwani ya wu sawe, “Ka bwele sumbu hinga ni ri wosiro? Ri mwanji ako tandau ti, kwambu tinga dau. Rini himamwale kapwa leni mwanji bwandawani wunu ri mwanji wu mendini ya wu sirinanda.” ");
INSERT INTO kwj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ete wosisiwani Jisas wosiro sumbu oti metengei ini ele Galili ko hinga ya ete chiki. ");
INSERT INTO kwj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wosini wunu lotu wondau aka ti wu andosini hoko tokwe wu raruni Saimon ga Anduru ga fi aka tiki ya wu raru. Jemis hima pi Jon okwe funda ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wu isini wu heiwani Saimon atako tape hi saindani tei tiki ya ete ti tukuyanda. Wowani Saimon atako handau tini Jisas ni metengei ya wu sawe. ");
INSERT INTO kwj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wu sawewani rini tini tambwa ri ini ti tapa ri torosini ya tini rasai. Ete wosiwani tape hi ti tini saindaro ti kipe ya tini wosi. Wowani ti saini wunu keke ahirahi ya ti wonda. ");
INSERT INTO kwj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wosiwani hunduya ini sisinawani ele siki wondau hima lenga himamwale kapwa dau ele hima ga Jisas tambwa ya wunu rata. ");
INSERT INTO kwj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wondawani o ko pe hima hinga tinda o aka lengu ki fotukumbwa wu wau kinani ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wu tasiwani Jisas hahungondau hima miyafo kipe ti wunu ri wosindani ele hima ga dau himamwale kapwa miyafo wunu ri rani ya ri rumbwenda. Ri rumbwesiwani himamwale kapwa le rini hambwandawani Jisas ya wunu sawe, “Kunu mwanji fo bwa kei.” ");
INSERT INTO kwj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wosini lindana nambwe nurumbumbwa, Jisas saini aka andosini hima nambwe michi ki ri ini Gotri ni ya ri uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wondawani Saimon ga ri nau lenga Jisas ni wu sirinani rini wu wakini wu ini ");
INSERT INTO kwj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","rini wu heini ya wu sawe, “Ele himiyama hurahama hinga tinda mini hei kinani o wu wakinda.” ");
INSERT INTO kwj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ete wowani ya wunu ri sawe, “Ma nu i, ele ko takai hinga. Nu ini ani ele ko kipe hima hinga leni Gotri mwanji a sawe ki. Hinde wowani, o keke a taro.” ");
INSERT INTO kwj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wosisini Jisas ele Galili ko hinga tinda ya ri i. Ri isini wu lotu wondau aka leki Gotri mwanji wunu sawendani himamwale kapwa miyafo ri rani ya ri rumbwenda. ");
INSERT INTO kwj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wosini gisi foki sechi okwe andau hima fo rini tambwa mwaꞌambwe keke ri sili kinani ri tani seke ri ombungwesini ya ri sawe, “Sembe mihi au mini saiwa, mini kipe o mi ani wosikonda.” ");
INSERT INTO kwj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","O hinga ri sawewani Jisas rini heini sembe rihi ti rini keke miyafo naha ya ri wo. Wosini ri tapa ti dachinani ori hima ri haiyesini ya ri sawe, “Sembe ahi ti au ani sainda. Kipe ti ma wosi.” ");
INSERT INTO kwj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","O hinga ri sawewani sechi okwe oti metengei ete humbuwani kipe ti ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wowani Jisas kwambu tiki ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ma mendi, apa mi ini o sumbu hima foni sawe kei. Woroti puris hima fori tambwa mi ini mi tape ti ma rini meku. Wosini Moses kaisiro Gotri lo mwanji sawendau hinga sumbwe dau omwe mi torosini kipe ti mi wosiro keke Gotri ni ya ma ha. Wosiwa himiyama hurahama miyafo sechi okwe mihi ti humburo oti sa wu hambwa.” ");
INSERT INTO kwj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas o hinga rini sawesiwani ori hima metengei ri ini mwanji miyafo ri bwandani o sumbu rini ki sukwaro tini ya ri saweꞌi sawetanda. O keke Jisas apa ko tokwe hima amwei tiki hinde ai i kumbwa. O hinga keke hima nambwe ko tiki ya ri da. Wondawani ele himiyama hurahama rini tambwa ele mapwa ele mapwa tokwe ya wu tanda. ");
INSERT INTO kwj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wosini gisi fwele isiwani Jisas Kapaneyam ko tokwe ya ri ai i. Wosiwani ele himiyama hurahama wu mendiwani Jisas ai tani aka rihi tiki ya da. ");
INSERT INTO kwj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wowani himiyama hurahama le tani fotukumbwa ya wu wau. Wu wauwani aka we ti kwai talewani ete tani rarusirasi tiki ya ambwe. Wondawani Jisas Gotri mwanji ti ya ri bwanda. ");
INSERT INTO kwj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ete wondawani hima opuriꞌopuri seke kapwa hima forini Jisas tambwa kicha kicha ya wu rata. ");
INSERT INTO kwj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wosini hima miyafo keke ori hima ni aka we tokwe hinde wu rakaru kumbwa. Wofunu ori hima ni wu ai ra ra humokuto tenge tiki yiti yiti aka tenge tiki wu rakauni Jisas eninda michi naha ki ya wu lepongo. Wu lepongosini ori hima tei tenge tiki tukuyandawani Jisas mu tiki ya wu rawai. ");
INSERT INTO kwj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","O keke Jisas wui sembe ti ri heiwani sembe ti rini numbwa hasiwani o seke kapwa hima ni ya ri sawe, “Ai che, kapwa sumbu mihi a rani a humbweꞌihiro.” ");
INSERT INTO kwj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jisas o mwanji hinga ni sawesiwani Gotri lo mwanji hambwandau hima fwele o michi ki wu lilindau leto inaka wuhi ki oti numbwa ya wu hambwanda, ");
INSERT INTO kwj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hinde wowani ka hima ka hinga sawendau? O hinga rini Gotri ni saweholiyandau. Hinde na hima to apa kapwa sumbu rani rumbwe kumbwa. Gotri tombwa wono.” ");
INSERT INTO kwj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","O hinga wu hambwandawani Jisas metengei wui inaka ti ri inaka ki ri hambwasini ya wunu ri sawe, “Hinde wowani ka hinga ni inaka kuhi tiki ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","So mwanji to ani keke amwei naha, o seke kapwa hima ni a sawewa, ‘Kapwa sumbu mihi a rani a humbweꞌihiro,’ e, ete a sawewa, ‘Ma saini tei mihi mi toroni ya ma i?’ ");
INSERT INTO kwj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dori Hima ri Che kwambu naha. Ahaꞌa nuwe ki kapwa sumbu rani ri humbwendau. O tini ku hambwa kinani.” O hinga ri sawesini seke kapwa hima o rini ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ando mini a sawenda, ma saini tei mihi mi toroni ya ma i.” ");
INSERT INTO kwj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wowani ri saini metengei tei rihi ri torosini ele himiyama hurahama miyafo rini wu heindawani ya ri i. Ri indawani ele himiyama hurahama miyafo wu apapanani Gotri hi numbwa ya wu rasai. Wosini ya wu sawe, “Injelembwa ete ta tani apa okwe ka sumbu hinga nu heinda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wosini gisi foki Jisas saini fwa mwai o ki ri ai ri indawani ele himiyama hurahama miyafo rini tambwa wu ai tasiwani Gotri mwanji ya wunu ri sawenda. ");
INSERT INTO kwj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wosini ri ini Alafiyas che, Lifai, ri heiwani rini takisi ya torondau aka tiki ya ri lininda. Ri linindawani Jisas ya rini sawe, “Mini ma tani ani sirina.” Wowani ri saini rini sirinani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wosini isiti nambwe, Jisas ga ri himache lenga Lifai aka tiki ahirahi keke wu linindawani takisi ya torondau hima miyafo lenga Moses kaisiro lo mwanji hikisandau hima miyafo lenga wunu okwe ahirahi keke funda ya wu lininda. Woro ele hima hinga Jisas ni sirinandau hima miyafo naha. ");
INSERT INTO kwj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wondawani Gotri lo mwanji hambwandau Farisi hima fwele o ki dani wu heiwani Jisas Moses kaisiro Gotri lo mwanji hikisandau hima lenga takisi ya torondau hima lenga ahirahi ti andawani Jisas himache leni ya wu sawe, “Hinde wowani rini kale takisi ya torondau hima lenga Moses kaisiro Gotri lo mwanji hikisandau hima lenga ahirahi ri andau?” ");
INSERT INTO kwj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wowani Jisas o mwanji mendini ya wunu ri sawe, “Kipe tumbwa dau hima le apa dokita ni hinde wu ucha kumbwa. Hahungo mendindau hima letombwa dokita tambwa wu ino. Ani hima kipe keke a ta nambwe. Ani kapwa hima le kekembwa a taro.” ");
INSERT INTO kwj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","O gisi ki, Jon himache lenga Farisi hima lenga wui sumbu tini sirinani ahirahi wu hakindaro. Wondawani hima fwele Jisas tambwa wu tani ya rini wu sawe, “Hinde wowani Jon himache lenga Farisi hima lenga ahirahi wu hakindawani mi himache letombwa ahirahi ti wu hakinda nambwe?” ");
INSERT INTO kwj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wowani Jisas ya wunu sawe, “Humwe hopweno hima ri ri nau ga dawa ahirahi hinde wu haki kumbwa. Mina. Humwe hopweno hima wunu ga dawa ahirahi wu andani wu eripeno. ");
INSERT INTO kwj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wosiwa gisi fo tawa humwe hopweno hima ori ni toroni raꞌaiwa ri nau le ya ri andosikonda. Wowambwa o gisi kumbwa ahirahi wu hakino.” ");
INSERT INTO kwj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wosini sumbu ako tinga sumbu hukwe tinga fini anarano keke Jisas mwanji yepe ki ya wunu sawe, “Hinde na hima to nikaꞌari ako sumbu torosini nikaꞌari simba sopu tiki ri owesini ri kapa kumbwa. Mina. O hinga ri wowa o nikaꞌari ako sumbu kaparo ki o nikaꞌari simba ai leterikowa apa sopu ti omwesika laka wono. ");
INSERT INTO kwj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hinde na hima to apa hacha uku, waini ako ri torosini meme tupu ba naro kowe simba tiki guto kumbwa. Mina. O hinga ri wowa apa o hacha uku waini o kowe simba ni ekichakoni apa leterino. Wowa o kowe simba ga hacha uku waini ga tinda ete walambe ino. O keke hima le hacha uku ako ti meme tupu ba naro kowe ako tukumbwa gutondau.” ");
INSERT INTO kwj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wosini himati gisi foki Jisas witi rupwa nindo tiki indawani ri himache le ahirahi keke witi so ya wu lefurunanda. ");
INSERT INTO kwj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wowani Farisi hima le Jisas ni ya wu sawe, “Ma mendi. Hinde wowani mi himache le himati gisi tiki minambwe naro sumbu ti wu wondau?” ");
INSERT INTO kwj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wowani Jisas ya wunu sawe, “Kunu Jutiya pe king apukolaka fori, Defit, ri woro sumbu tini saweni kairo chengi tini ku hambwa nambweꞌe, mina? Injelembwa Defit ga ri himache lenga wu dani ahirahi nambwe keke iche tinga ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wowani Apaiyata puris hima apukolaka daro gisi ki, Defit Gotri aka laka we tiki ri raruni puris hima na numbwa wu ano bereti foti Gotri ni haro tini ri heini o tini ri rukoni ri asini ri himache leni gamwe ya ri ha.” ");
INSERT INTO kwj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wosini Jisas ya ai wunu sawe, “Gotri himati gisi ti hima keke owesiro. Woroti rini hima ni himati gisi keke wosi nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dori Hima ri Che tombwa himati gisi aulindau.” ");
INSERT INTO kwj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wosini gisi foki Jisas lotu wondau aka tiki ya ri ai ri raru. Ri rarusini hima forini ri heiwani tapa nangi rihi ti dinga ba naha. ");
INSERT INTO kwj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wowani hima fwele kwai daro le Jisas ni ete wu misindani ya wu hambwa, “Apa himati gisi ki o tapa dinga ba hima ni kipe ri wosinoꞌo, mina?” Hinde wowani, wunu Jisas ni wu kotimwo kinani. ");
INSERT INTO kwj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wondawani Jisas tapa dinga ba hima ori ni ya ri sawe, “Ma saini tani hima nindo tiki eti.” ");
INSERT INTO kwj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wosini ya wunu ri sawe, “Himati gisi tiki bwele tau ni Moses ohounaro? Kipe sumbu wondau tiniꞌi, kapwa sumbu wondau tini? Hima okulandau tiniꞌi, hima yendau tini?” ");
INSERT INTO kwj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wowani wunu mwanji nambwe. Ete wowani sembe enge wunu ri andani wunu jaunjamekoni wunu ri heiwani wui sembe ti emendiki naha. Wondawani ri sembe ti wunu keke ichakandawani o hima ni ya ri sawe, “Mi tapa ti ma dachina.” Wowani ri dachinawani tapa rihi imbihumbwa daro hingambwa ya ai wosi. ");
INSERT INTO kwj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wowani ele Farisi hima metengei ete wu ini Herot himache lenga fotukumbwa wausini Jisas ni wu yeno mwanji ti ya wu bwanda. ");
INSERT INTO kwj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wondawani Jisas ri himache lenga o michi wu andosini fwa mwai tokwe ya wu i. Wu isiwani hima le Galili mapwa tokwe tawani, Jutiya mapwa tokwe tawani, ");
INSERT INTO kwj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem ko tokwe tawani, Itumiya mapwa tokwe tawani, Jotan gara o kachi angi tokwe tawani, Taiya ko, Saiton ko tokwe tawani, hima walefo naha. Wunu Jisas wosiro sumbu ele ni wu mendini rini tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wu tasiwani Jisas ri himache leni ya ri sawe, “Hima miyafo naha ani tambwa tani ya ani ginakondau. Kanu fo ma ku ratani ani takaisiwa sa da.” ");
INSERT INTO kwj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hinde wowani, rini hima miyafo ni kipe ri wosiwani ele hahungondau hima miyafo wunu Jisas ni wu haiye kinani rini tambwa wu lesisinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wowani himamwale kapwa le Jisas ni wu heini ri mu tiki wu ombungwesini uchani ya wu sawe, “Mini Gotri Che.” ");
INSERT INTO kwj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wowani kwambu tiki ya wunu ri sawe, “Kunu apa amwei ani ku wo kei.” ");
INSERT INTO kwj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gisi fo Jisas kimba ki rausini ri okokonandau hima lenumbwa ri uchawani rini tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wu tasiwani hima tapaꞌangi tapaꞌangi hatachi fisi ri toroni ri himache hinga wu sira kinani o hi ki ya wunu uchasi. O hinga ri wosiro ti, wunu rini ga ete wu dani Jisas wunu humbwewa Gotri mwanji wu sawendani, ");
INSERT INTO kwj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Gotri kwambu wu torosini himamwale kapwa wu rani wu humbwenda kinani. ");
INSERT INTO kwj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisas o hinga ri himache le tapaꞌangi tapaꞌangi hatachi fisi hima ri esisini Saimon ri hi ako ti ya rini uchasi, Pita. ");
INSERT INTO kwj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Wosini Jemis, Sepeti che, rini ga ri analongo Jon ga fi hi ako ti, Boanesis, Jisas o hinga ya fini uchasi. Boanesis mwanji mwe ti ka hinga: Niri tiki kuro che. Hinde wowani, fini metengei apapanandau. ");
INSERT INTO kwj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Wosini Anduru, Filip, Batolomiyu, Matiyu, Tomas, Jemis Alafiyas che, Tatiyas, Saimon rini Jutiya ko keke gangambanindau hima fo, ");
INSERT INTO kwj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jutas Isukariyot rini Jisas ni omwemendindau kapwa hima le tapa tenge tiki hasiwani rini yero. ");
INSERT INTO kwj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wosini Jisas aka tokwe ya ri ai i. Wosiwani hima walefo tani wu wausiwani Jisas ga ri himache lenga ahirahi ti bwele amwa ki wu a kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wosiwani ri hima mu le wu mendiwani sawe, “Jisas ambwatihiro.” Wowani wunu Jisas ni wu rata kinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wondawani Gotri lo mwanji hambwandau hima fwele Jerusalem wu daro ti wu sikani ya wu sawe, “Belesepul, Saiten hi fori, rini ga dau. O keke o himamwale kapwa apukolaka i kwambu tiki himamwale kapwa miyafo ri rani ri rumbwendau.” ");
INSERT INTO kwj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wowani wunu ri uchawani wu tawani mwanji yepe tiki ya wunu ri sawe, “Hinde hinga Saiten apa Saiten ni rani humbweno? ");
INSERT INTO kwj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ko tiya laka fotiki hima miyafo dani wu lehuwasini wu anayendawa o ko tiya laka hinde apa yakina kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aka fokumbwa hima le dani wu lehuwasini wu anayendawa apa o aka hinde yakina kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","O hingambwa Saiten rini sirinandau himamwale kapwa miyafo ga wu dani wu lehuwasini wu anayendawa Saiten hinde apa yakina kumbwa. Mina, humbuno. ");
INSERT INTO kwj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hima fori apa hima kwambu naha foi aka tiki nimba raruni ri usalikamba hinde toro kumbwa. Mina. Ori hima i kwambu ri injisinimbwa apa ri aka pe usalikamba le ri torono.” Woro Jisas hima kwambu o rini injiro hima ni rinjenga ri yepero. ");
INSERT INTO kwj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Wosini Jisas ete sawe, “Mwanji mwe naha tini a sawendau. Hima lei kapwa sumbu lenga Gotri ni wu saweholiyandau sumbu tinga tinda ete Gotri rani humbwekonda. ");
INSERT INTO kwj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Woroti hima fori Gotri Himamwale kipe ni ete saweholiyawa Gotri ori kapwa sumbu hinde apa rani ri humbwe kumbwa. Mina. O kapwa sumbu rini ga ete da ete dano.” ");
INSERT INTO kwj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas o mwanji hinga ni sawero ti, o ka wui mwanji keke. Wunu ete sawero, “Jisas himamwale kapwa tinga dau.” ");
INSERT INTO kwj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ka gisi Jisas i nuwai ga ele ri hipache fwelenga wu tani hoko tiki wu etisini Jisas ni wu hei kinani hima forini wu sawewani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ri ini ri sawewani hima miyafo Jisas ni ini hinga wu injisini wu linindau leto ya rini wu sawe, “Ma mendi, mi nuwai ga mi hipache fwelenga hoko tiki dani mini ni o wu wakinda.” ");
INSERT INTO kwj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wowani mwanji wasa ya wunu ri sawe, “Ai nuwai namo? Ai hipache namo?” ");
INSERT INTO kwj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wosini ele hima miyafo Jisas ni haweisini wu linindawani ri jaunjamekoni wunu ri heisini ya ri sawe, “Ma hei, kunu ai nuwai, ai hiparakambwe. ");
INSERT INTO kwj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hima fo Gotri okokona tini ri sirinawa ori hima ai hiparakambwe, ai kahaiche, ai nuwai.” ");
INSERT INTO kwj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wosini gisi foki Jisas fwa mwai tiki hima leni Gotri mwanji ni ondiyakandiyandau tau ti ya ri ai rasai. Wosini ele himiyama hurahama miyafo rini tambwa tani ya wu wau. Wu wausiwani kanu fo fwa we tiki dawani Jisas o kanu tenge tiki ya ri lininda. Ri linindawani ele himiyama hurahama miyafo fwa mwai tiki ya wu da. ");
INSERT INTO kwj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wondawani Jisas mwanji yepe miyafo ki ya wunu ri ondiyakandiyanda. Wunu ri ondiyakandiyani ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ma ku mendi! Hima fori dani raisi wapa rupwa tiki humbwe kinani ya ri i. Ri ini ri humbwendawani raisi wapa fwele numbo gamba tiki sikaro. ");
INSERT INTO kwj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sikasiwani apwe miyafo hangani sikani o raisi wapa ya wu a. ");
INSERT INTO kwj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wowani raisi wapa fwele humokuto miyafo dau nuwe tiki ya sika. Woroti o nuwe kaimbwa mina. O nuwe ki famwe ti metengei ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sukwasiwani nene apambwa torondawani nika sukwani yewani o famwe ti ya hopwene. ");
INSERT INTO kwj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wosiwani raisi wapa fwele lame chele ki nindo tiki sikaro. Sikasiwani o lame chele ki saini o tuko ki sukwaro famwe ni yewalisiwani o famwe mwe wa nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wosiwani raisi wapa fwele nuwe kipe tiki sikaro. Sikasiwani famwe laka sukwani rauni kwinini mwe ti ya wa. Wu saisini foti mwe ti 30 ya wa. Wowani foti mwe ti 60 ya wa. Wowani foti mwe ti 100 ya wa.” ");
INSERT INTO kwj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ete wosini ya wunu ri sawe, “Hima fori wasamba chele ti do mwanji sa mendi.” ");
INSERT INTO kwj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas bati dawani rini ga ichiꞌuchandau hima le, kale tapaꞌangi tapaꞌangi hatachi fisi himache lenga ka mwanji yepe ni Jisas ni ya wu sili. ");
INSERT INTO kwj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wu siliwani ya wunu ri sawe, “Gotri kunu keke Gotri kwambu hima i sembe aulindau mwanji yani ti amwei woro. Woro ele hoko pe hima ni mwanji yepe tukumbwa wunu ri sawenda. ");
INSERT INTO kwj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wondani, ‘Wunu miya tukumbwa wu hei hei mwaꞌambwe fo wu heinda nambwe. Wunu wasamba tiki wu mendi mendi mwanji foni wu mendinda nambwe. O hinga wu wowa, wui sembe ti Gotri ni hinde apa wu ha kumbwa. Wowa Gotri wui kapwa sumbu hinde ri rani rumbwe kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wosini Jisas ya wunu sawe, “Hinde wowani kunu ka mwanji yepe ku hambwanda nambwe? O hinga nawa kale mwanji yepe miyafo hinde hinga apa ku hambwakonda? ");
INSERT INTO kwj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ka hima raisi wapa humbwendau oti rini Gotri mwanji tini humbwendau. ");
INSERT INTO kwj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kale raisi wapa fwele numbo gamba tiki sikaro oti ele hima fweleni sawero. Wunu Gotri mwanji wu mendisiwani Saiten metengei tani Gotri mwanji wui sembe tiki daro tini ya ri rani ri humbwe. ");
INSERT INTO kwj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","O hingambwa kale raisi wapa fwele humokuto miyafo dau nuwe tiki sikaro oti hima fweleni sawero. Wunu Gotri mwanji wu mendini wu eripeni metengei wui sembe tiki o Gotri mwanji ya wu toro. ");
INSERT INTO kwj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Woroti wunu nene da nambwe keke gisi miyafo wu i nambwe. Hinde wowani, Gotri mwanji wu tororo keke simiyanehei sumbu wunu ki sukwandawani hima fwele kapwa sumbu ti wunu wu wondawani amwaka miyafo wu mendikoni metengei ya wu hichakou. ");
INSERT INTO kwj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kale raisi wapa fwele lame chele ki nindo tiki sikaro oti hima fweleni sawero. Wunu Gotri mwanji wu mendini ");
INSERT INTO kwj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wui nuwe pe mwaꞌambwe keke inaka miyafo wu hambwani wui okokona ti ya mwaꞌambwe miyafo keke wu wondau. Wowani ele wui okokona miyafo to Gotri mwanji ti ya yekicha. O keke mwe wa nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kale raisi wapa fwele nuwe kipe tiki sikaro oti hima fweleni sawero. Wunu Gotri mwanji wu mendini sembe wuhi ki kipe naha ya wu toro. Wosiwani mwe kipe ya wa. Wu saisini foti mwe ti 30, wowani foti mwe ti 60, wowani foti mwe ti 100 ete ya wau.” ");
INSERT INTO kwj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wosini ya wunu ri sawe, “Hinde na hima ta lamu ratani hungwe we tikiꞌi tei tako tiki lisi kumbwa. Mina. Lamu lisindau tei tenge tukumbwa lisindau. ");
INSERT INTO kwj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wowani ele mwaꞌambwe yanindau ti gisi fo amwei wono. Kapwa sumbu yekichandau sumbu ti gisi fo amwei wono. ");
INSERT INTO kwj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hima fo wasamba chele ti ahaꞌa mwanji sa mendi.” ");
INSERT INTO kwj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wosini ya wunu ri sawe, “Ka mwanji ku mendindau norukweni ma ku hambwa. Apa kunu hima ni ku kilindau hinga wayambwa Gotri o hingambwa o kunu ri kilikonda. Kunu ri kilisini gamwe o ai kunu ri kilikonda. ");
INSERT INTO kwj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","O keke mwaꞌambwe miyafo torosindau hima Gotri fwelenga ai rini hano. Wowa mwaꞌambwe torosinda nambwe hima Gotri mwaꞌambwe fisiche ri tororo oti Gotri ai raꞌaino.” ");
INSERT INTO kwj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wosini ya ri sawe, “Gotri kwambu hima i sembe aulindau ti oti raisi wapa nuwe tiki humbwendau hima fo hinga. ");
INSERT INTO kwj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ri humbwesini niliki ri tukuyasini tapwaki ri ichiꞌuchandawani o raisi wapa saini kwinini ya rau. O raisi wapa hinde hinga raundau ti ri hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nuwe tinjenga wowani o raisi wapa rausini tongo sukwasinimbwa so ti wasini mwe ti ya wau. ");
INSERT INTO kwj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wosini hehenani nipisiwani o hima gipi tiki ya kutou, hinde wowani, numbundau gisi tahiro.” ");
INSERT INTO kwj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wosini Jisas ya ri ai sawe, “Gotri kwambu hima i sembe aulindau ti hinde hinga nu saweno? Bwele mwanji yepe ni nu hambwasini nu saweno? ");
INSERT INTO kwj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gotri kwambu hima i sembe aulindau ti masitet, kupucha fo, o tuko hinga. O masitet kupu tuko nuwe tiki humbwewani kapwacheche naha dawani ahirahi tuko hinga tinda ele to oti ni dikindau. ");
INSERT INTO kwj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wosiwani o masitet tuko saini rauni omwesika ini ele rupwa pe kupucha hinga ni tinda ete ya diki. Wosiwani o masitet talitapa we ki apwe miyafo tani apwe woto ya wu yeu.” ");
INSERT INTO kwj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kale mwanji yepe ele himiyama hurahama ni ri bwaro hinga Jisas hima i inaka tiki dau hinga wunu ni mwanji ri sawendaro. ");
INSERT INTO kwj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rini mwanji mu mwe amwei naha ki ri sawe nambwe. Rini mwanji yepe tukumbwa ya wunu ri sawenda. Woro rini bati ri himache lenga wu dani kale mwanji yepe ri bwaro mwanji mwe ti ya wunu ri sawekawenda. ");
INSERT INTO kwj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","O gisi kumbwa hunduya, Jisas ri himache leni ya ri sawe, “Ma nu rachi, fwa angi tokwe.” ");
INSERT INTO kwj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wosini himiyama hurahama miyafo wu andosini Jisas linindaro kanu tenge tiki wu tani wu rauni wu litisini Jisas ni ya wu raꞌai. Wondawani kanu fwele wunu ga ya i. ");
INSERT INTO kwj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wu indawani ausuwa omwesika naha ya si. Sindawani fwa ekichani tani kanu tiki hapa tinga yewani uku kanu we tiki raini ya talekonda. ");
INSERT INTO kwj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wondawani Jisas kanu soko gumwa tokwe ri dani mwasakimbe rasaisini ya ri tukuyanda. Ri tukuyandawani rini wu yetelesini ya rini wu sawe, “Apukolaka, nunu uku sumbwe nu ani nu hakondau ti mi hambwanda nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wowani Jisas saini o ausuwa laka ni kwambu tiki sawesini fwa oti ni ya ri sawe, “Yakito. Ma humbu!” Ri sawewani ausuwa metengei ete humbuwani apa ata fo ai gi numbwa. ");
INSERT INTO kwj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wosini ri himache leni ya ri sawe, “Hinde wowani ku akindau? Kunu sembe kuhi ani ni ku ha nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wowani aki laka wu akikoni wunjengambwa ya wu anambwa, “Do hinde na hima to dawani ausuwa tinga fwa tinga ri mwanji ni wu mendini wu sirinandau?” ");
INSERT INTO kwj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wosini dani ini fwa angi tokwe ya wu rachi. O michi, Gerasa mapwa ki dau nuwe tipa. ");
INSERT INTO kwj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wosini Jisas kanu andosini mwai tokwe ri rausiwani himamwale kapwa lenga dau hima fori metengei Jisas ni hei kinani ya ri ta. ");
INSERT INTO kwj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","O hima matimat tiki ri dawani hima le rini toroni inji kinani wu simiyandaro. Seni kupu ki okwe rini wu toroni wu inji ki, mina. ");
INSERT INTO kwj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hinde wowani, nili tapwa ambwe seke injindau seni tikiꞌi seni kupu tiki rini wu injindawani o seke injindau seni yekutondani o seni kupu lekutondaro. Wondani hinde na hima to rini toro kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rini niliki tapwaki ele matimat ki ele kimba ki ata laka ri gindani humokuto tiki tape rihi ya ri kutonda. ");
INSERT INTO kwj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wondawani Jisas sumbwe tiki dawani o hima rini heisini Jisas tambwa namani ya ri i. Ri ini Jisas mu tiki ri ombungwesini hapa tinga uchani ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Jisas, kari kaumbwa dau Gotri Che. Mini ani ni hinde mi wokonda? Gotri hi ki mini a sawenda. Apa amwaka ani ha kei.” ");
INSERT INTO kwj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hinde wowani o hima Jisas ni ka hinga sawero? Jisas rini ni ka mwanji hinga ni ete sawero keke, “Himamwale kapwa, o hima ma andosini sirani i.” ");
INSERT INTO kwj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wosini Jisas ya rini sili, “Mi hi namo?” Wowani ya ri sawe, “Ai hi ti Lekiyon. Hinde wowani, nunu miyafo naha.” ");
INSERT INTO kwj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ete wosini Jisas ni kwambu tiki ya ri sawe, “Mini mapwa foki apa nunu humbwe kei.” ");
INSERT INTO kwj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wondawani fe miyafo naha kimba alase tiki wu dani nuwe uyani ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wondawani ele himamwale kapwa miyafo Jisas ni wu uchani ya wu sawe, “Ma nunu humbwewa nu ini ele fe miyafo sembe tiki nu raru.” ");
INSERT INTO kwj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O hinga wu sawewani, Jisas wunu ohounawani o hima wu andosini sirani wu ini ele fe miyafo sembe ki ya wu raru. Wu raruwani ele fe miyafo namani anandiki anandiki wu ini kimba laka ki dau fwa ki ya wu rai. Wosini uku sumbwe wu ani ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wowani ele fe aulindau hima wu akini ini ele wui ko ki, e, ele wui michi ki o mwanji ya wu sawe. Wu sawewani ele himiyama hurahama miyafo o sumbu woro tini wu hei kinani Jisas tambwa ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wu ini himamwale kapwa miyafo ga daro hima ni wu heiwani ri inaka ti kipe wosisini nikaꞌari ako ri injisini ya ri lininda. Wowani oti ni wu heini ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wu akindawani norukweni heiro hima leto himamwale kapwa lenga daro ori hima wosiro sumbu ga ele fe miyafo wosiro sumbu ga ya wunu sawekawenda. ");
INSERT INTO kwj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wosini wunu Jisas ni wu silini ya wu sawe, “Ma saini nui nuwe andosini ma i.” ");
INSERT INTO kwj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wowani Jisas wunu andosini ini kanu ki ri raundawani o himamwale kapwa ga daro hima ya rini sawe, “Ani mini ga ani i ki.” ");
INSERT INTO kwj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wowani Jisas minambwe rini nani ya ri sawe, “Ma i, mi aka tokwe, mi hima kupu le tambwa. Mi ini Apukolaka mini wosiro sumbu ga mini okularo sumbu ga ya ma wunu sawe.” ");
INSERT INTO kwj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wowani o hima Jisas andosini ya i. Ri ini Dekapolis mapwa ki Jisas rini wosiro sumbu hima ni ya ri sawenda. Ri sawewani ele himiyama hurahama ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wosini Jisas fwa angi tokwe ya ri ai sika. Wosiwani himiyama hurahama miyafo rini tambwa tani ya wu wau. Wu waundawani Jisas fwa mwai ki ya eninda. ");
INSERT INTO kwj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wondawani lotu wondau aka ni aulindau hima laka fo, ri hi Jairas, tani Jisas ni ri heisini ri mu tiki ri ombungwesini ");
INSERT INTO kwj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mwanji miyafo ri silini ya ri sawe, “Ai himiyama che ya hakondau naha. Ma tani tapa mihi ki ma tini toro. Wowa kipe sa wosini sa da.” ");
INSERT INTO kwj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ete wowani, Jisas rini ga ya fi i. Fi indawani ele himiyama hurahama miyafo Jisas ni wu sirinani wu ini ri gumwa tiki ya wu anatakai anatakainda. ");
INSERT INTO kwj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wondawani wui nindo tiki humwe foti ya da. Tini akawe tiki dani asama tapaꞌangi tapaꞌangi hatachi fisi ki fi numbwa dau. ");
INSERT INTO kwj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O siki keke dokita miyafo tambwa ti indani ele ti usalikamba ga ya tinga tinda ete wunu keke hasini amwaka miyafo ya ti mendinda. Wondawani o ti siki kipe tini wosino nani, mina. O siki kapwa naha ete tini mendinda. ");
INSERT INTO kwj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wondawani Jisas mwanji suwa tini ti mendisini ti da dani Jisas taro tini ti mendisini rini ga tandau hima nindo tiki ti ini Jisas nikaꞌari gumwa tiki ya ti toro. ");
INSERT INTO kwj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hinde wowani, tini ete ti hambwandaro, “Jisas nikaꞌari tumbwa a torowa rini kipe ya ani wosino.” ");
INSERT INTO kwj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","O hinga ti wosiwani metengei ete o ti siki mwe ete humbu. Ete humbukowani ti tape ti ti mendiwani o siki ete humbu. ");
INSERT INTO kwj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wowani Jisas metengei ri kwambu iro ti ri inaka tiki ri hambwani ri gumwa tokwe jamekoni ya wunu ri sawe, “Namoto ai nikaꞌari tororo?” ");
INSERT INTO kwj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wowani ri himache le ya rini sawe, “Ma hei. Ele himiyama hurahama miyafo mini takai takaini tandau. Hinde wowani mi sawendau, Namoto mini tororo?” ");
INSERT INTO kwj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wowani Jisas jaunjamekoni o rini tororo hima ni hei kinani ya ri wakiteki. ");
INSERT INTO kwj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wondawani o humwe tini wosiro sumbu ti hambwandani ti akini Jisas tambwa ti tani ri mu tiki ti ombungwesini ti rikirikinani ele tini wosiro sumbu mwe tinda ete ya rini sawe. ");
INSERT INTO kwj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Rini sawewani ya tini ri sawe, “Ai che, sembe nihi ani ni ni haro keke kipe ti nini wosiro. Ma i. Ini kipe tumbwa ma da. Nomo nihi ma ete humbu.” ");
INSERT INTO kwj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ete sawendawani hima fwele o lotu wondau aka aulindau hima laka i aka wu andosini wu tani ya rini wu sawe, “Mi himiyama che hahiro. Ondiyakandiyandau hima ni tau kwambu hinde mi handau?” ");
INSERT INTO kwj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","O hinga wu bwandawani mwanji wuhi ri mendini au rini sai nambwe. Wowani o lotu wondau aka aulindau hima laka ni ya ri sawe, “Apa aki kei. Sembe mihi ani numbwa ma ete ha.” ");
INSERT INTO kwj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O hinga ri sawesini Jisas hima miyafo rini ga wu ino keke minambwe ri nasini ri himache fwelenumbwa, Pita, Jemis, ri analongo Jon numbwa rani o lotu wondau aka aulindau hima laka i aka tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wosini Jisas heiwani hima le ata miyafo gindani au laka ya wu ichakanda. ");
INSERT INTO kwj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wondawani Jisas aka we ki raruni ya wunu ri sawe, “Hinde wowani ku ichakani ata laka ku gindau? O himiyama che ha nambwe. Nimba tukuyandau.” ");
INSERT INTO kwj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wowani ri mwanji keke ya wu hingi. Wu hingindawani Jisas rindombwa ele hima miyafo humbwewani hoko tokwe wu sirasiwani o himiyama che i nuwai yapai ga, ele ri himache namili ga rani o himiyama che dau aka tipa fotiki ya wu raru. ");
INSERT INTO kwj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wu rarusini Jisas o che i tapa ri torosini ya tini ri sawe, “Talita kumi.” O mwanji jamekowa ka hinga, “Himiyama che, ani nini a sawe. Ma sai.” ");
INSERT INTO kwj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wowani metengei ti saini ya ti i. O himiyama che, ti asama tapaꞌangi tapaꞌangi hatachi fisi. O sumbu wu heikoni ete ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wowani Jisas hapa tinga ya wunu sawe, “O sumbu apa amwei ku wo kei.” Wosini ya wunu sawe, “Ahirahi fwele ma tini hawa sa ti a.” ");
INSERT INTO kwj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wosini gisi foki Jisas o michi andosini hima laka ri sairo ko tokwe ya ri i. Ri iwani ri himache le rini ni ya wu sirina. ");
INSERT INTO kwj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wosiwani himati gisi fo tawani lotu wondau aka tiki Gotri mwanji hima leni ya ri sawenda. Ri sawendawani hima miyafo ri mwanji wu mendini wu apapanani ya wu sawe, “Ka hima ka mwanji soki rataro? Ka hambwa rini ga dau ti, bwele hambwa hinga rini ga dawani kale kwambu naha wondau sumbu ri wosindau? ");
INSERT INTO kwj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ka hima aka rasaindau himaꞌa, mina! Rini Mariya i che. Ri hipache le, Jemis, Josis, Jutas, Saimon. Ri kahaiche le okwe nunu ga ahaꞌa da.” O hinga wu sawendani kapwa inaka ya rini wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ete wowani Jisas ya wunu sawe, “Gotri mwanji bwarakarandau hima le ele ko hinga tinda ete hi wuhi ti omwesika. Woroti hima laka sairo ko wuhi ki wu iwani o ko kipe hima lenga wui hiparakambwe lenga hi wuhi tini wu rasainda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wowani o ri ko ki kwambu naha wondau sumbu ri wo nambwe. Siki wondau hima fwelenumbwa ri tapa ri torowani kipe ti ya wu wosi. ");
INSERT INTO kwj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","O hinga wu wowani wunu wui sembe Jisas ni wu ha nambwe keke ri sembe ti wunu keke amwaka ya ri anda. Wondawani ele rini takaisinda ko tokwe ri ini Gotri mwanji ya ri sawenda. ");
INSERT INTO kwj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ete wosini kale ri tapaꞌangi tapaꞌangi hatachi fisi himache leni ri uchawani wu tawani fisi fisi ya wunu ri humbwe. Ya wunu ri humbwekoni himamwale kapwa rani rumbwendau kwambu ti ya wunu ha. ");
INSERT INTO kwj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wosini ya wunu sawe, “Numbo ku ini ku diyano kumbo funda numbwa ma ku toro. Bereti raꞌai kei. Kowe raꞌai kei. Nikaꞌari kowe tiki ya ti waro kei. ");
INSERT INTO kwj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su ma ku owe. Siyoti ti fisi apa ku owe kei.” ");
INSERT INTO kwj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wosini ya ai wunu sawe, “Ku ini aka fotiki ku raruni ete ku da dasini ku ikoni o ko ku hanjaꞌaisini mapwa fo tokwe ya ma ku ai i. ");
INSERT INTO kwj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko foki ku ai iwa o ko kipe hima le kunu rakaruni kui mwanji wu mendi nambwe nawa, ma wunu golo ni ku rawakasini ma ku andosini ya ma ku i. Hinde wowani, Gotri mwanji ku bwawani wu mendi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wosiwani ele ri himache wu ini ele hima ni ya wu sawe, “Kapwa sumbu kuhi ti gumwa ma ku si.” ");
INSERT INTO kwj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wosini himamwale kapwa rani wu rumbwendau tinga siki wondau hima leni olif me tuko uku wu hindiwani kipe ya wu wosinda. ");
INSERT INTO kwj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wondawani gisi foki king apukolaka Herot ele wui sumbu ya ri mendi. Hinde wowani, Jisas hi apa amwei sukwahiro. Wondawani hima fwele ete sawe, “Uku yasindau hima Jon to hasini ai saisini kale kwambu naha sumbu wosindau.” ");
INSERT INTO kwj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wowani fwele sawe, “Ori imbihumbwa pe Ilaicha.” Fwele sawe, “Ori Gotri mwanji bwarakarandau hima, imbihumbwa Gotri mwanji bwarakarandaro hima hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wowani Herot ele mwanji ni ri mendini ya ri sawe, “Mwase, Jon i kwele a takutoro. Woro apa o hima ai saihiro.” ");
INSERT INTO kwj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hinde wowani Herot ka hinga sawero? Mwase, hima fwele ri humbwewani ini Jon toroni kalapus tokwe raꞌaini seni tiki ya rini inji. Bwele keke Jon kalapus raruro? Humwe fo, hi ti, Herotiyas, tini ga Filip ga fi anahopwesini fi dawani Herot, Filip analongo, to ai tini ratani ya ri hopwe. ");
INSERT INTO kwj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","O keke Jon Herot ni ya ri sawe, “Mini mi analongo humwe ni mi ratani mi hopwero keke kapwa sumbu mi woro.” ");
INSERT INTO kwj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wowani Herot humwe, Herotiyas, Jon ni sembe enge ete andani rini yeni si kinani mina, ti hurache, Herot keke ete ti simiyandaro. ");
INSERT INTO kwj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hinde wowani, Herot ri hambwawani Jon hima kipe naha, ri sembe halaya naha, o keke rini akindani kipe naha rini aulindau. Wondani Jon ri mwanji ni ri mendini inaka miyafo ya ri hambwanda. Woro Herot, Jon ri mwanji ni ri mendi ki o keke ete ri wonda. ");
INSERT INTO kwj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wondawani gisi foki Herotiyas numbo mwe naha ya ti waki. Nuwai Herot ni raro gisi ai tawani o gisi keke ahirahi laka ri owesini gapiman tau rini okulandau hima apukolaka fwelenga au anaye hima apukolaka fwelenga Galili mapwa pe hima apukolaka fwelenga wunu ri uchawani wu tani ahirahi wu andani ya wu eripeꞌaripenda. ");
INSERT INTO kwj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ete wondawani Herotiyas himiyama che ti raruni hukwa ra ra seke ti yitindawani Herot ga ele ahirahi wu andau hima lenga funda ete ya tini wu okokonanda. Wowani king Herot o himiyama che ni ya ri sawe, “Bwele mwaꞌambwe naha tini ni okokonawa nini ani hano. ");
INSERT INTO kwj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gotri ani heindawani mwanji mwe naha tini apa ete a sawendau. Ni okokona ti ai nuwe a fikasini nini angi fo ani angi fo o hinga ni nawa oti okwe a wono.” ");
INSERT INTO kwj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wowani ka himiyama che ai sirani ti nuwai ni ya ti sawe, “Bwele mwaꞌambwe keke rini a silino?” Wowani ti nuwai ya ti sawe, “Uku yasindau hima Jon i mwa tini.” ");
INSERT INTO kwj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wowani metengei ti ai raruni king tambwa ini ya rini ti sawe, “Ani ai okokona ti, apa funda ete uku yasindau hima Jon i kwele ma takutosini disi tenge fotiki owesini ma ani rata. Oti ai okokona.” ");
INSERT INTO kwj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O hinga ti sawesiwani king sembe ti nomo miyafo ya rini a. Woroti tambwa ri sawero ri mwanji keke rini ga andau hima apukolaka le keke ri hambwafuni ti mwanji ti ya ri ohouna. ");
INSERT INTO kwj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wosini metengei king apukolaka, hima takutondau hima fo humbwewani kalapus aka tokwe ini Jon i kwele ti ya ri takuto. ");
INSERT INTO kwj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ri takutosini Jon i mwa ti disi tenge fotiki owesini ratani o himiyama che ni ya ri ha. Ri hasiwani o himiyama che raꞌaini ti nuwai ni ya ti ha. ");
INSERT INTO kwj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","O hinga wosiwani Jon ri himache le wu mendini wu tani Jon i tape wu raꞌaini matimat tiki ya wu eini si. ");
INSERT INTO kwj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dani ini kale Jisas himache ai tani Jisas ga fotukumbwa ya wu wau. Wu wausini ele wu wosiro sumbu ga ele mwanji hima leni wu ondiyakandiyandaro sumbu ga tinda ete Jisas ni ya wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wosini wu dawani hima miyafo wunu tambwa ichiꞌuchandawani bwele amwa ki ahirahi wu ano? Wondawani Jisas ya wunu sawe, “Ma ku tawa nunu bati hima da nambwe michi fotiki nu ini nu himati.” ");
INSERT INTO kwj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wosini wunu bati wu ini kanu tenge tiki wu rauni wu litisini hima da nambwe michi fo tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wu indawani ele hima miyafo wunu heini wu hambwandau tinga wu namani wu dikisini wu ini o michi ki ya wu da. ");
INSERT INTO kwj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wu isini wu dawani Jisas fwa gamba tiki sikasini ri heiwani hima miyafo naha. Ri heiwani wunu fe che asa che hinga wu dawani wunu aulino hima da nambwe. Wowani wunu keke ri woni ri mwanji ri bwani ya wunu ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ri ondiyakandiyandawani hunduya ete indawani ele ri himache rini tambwa wu tani ya rini wu sawe, “Do michi hima da nambwe michi. Apa hunduya ihiro. ");
INSERT INTO kwj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ma wunu sawewa sa wu ini ele takaisindau rupwa tikiꞌi ko tiki wu ini wunjenga ahirahi sa wu ra.” ");
INSERT INTO kwj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wowani Jisas mwanji wasa ya wunu sawe, “Kunjenga ahirahi ma wunu ku ha.” Wowani Jisas ni ya wu sawe, “Nunu asama funda tau rani torondau ya laka hinga nu ranimbwa nu ini wunu keke ahirahi miyafo nu rani nu ratano.” ");
INSERT INTO kwj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wowani ya wunu ri sawe, “Bereti geni kunu dau? Ma ku ini ku hei.” Wowani wu hambwasini ya rini wu sawe, “Bereti tapaꞌangi, fwaiꞌomwe ti fisi.” ");
INSERT INTO kwj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wowani Jisas wunu sawewani wu ini ele hima hinga tinda ete wunu wu okulani wu humwasini ki tenge tiki ya wu lininda. ");
INSERT INTO kwj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wu linindani hima mu fwele 100 hima hinga wau. Hima mu fwele 50 hima hinga wau. ");
INSERT INTO kwj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wondawani Jisas o bereti tapaꞌangi ga o fwaiꞌomwe fisi ga ri rukoni toroni niri tokwe ri mausini Gotri ni weseꞌasini o bereti ya ri lepika. Ri lepikasini ri himache leni ya ri ha. Wosiwani wu ini ele hima ni ya wu hani wu inda. O fwaiꞌomwe okwe Jisas lepikasini ele hima ni ya wunu ha. ");
INSERT INTO kwj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wowani ele hima hinga tinda ete wu ani sembe wuhi ya wunu tale. ");
INSERT INTO kwj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wowani ele bereti wu aro gamwe ele fwaiꞌomwe wu aro gamwe hara laka leki warosini wu heiwani ele hara tapaꞌangi tapaꞌangi hatachi fisi ya tale. ");
INSERT INTO kwj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ele hurahama ahirahi aro tinda ete 5,000 hinga. ");
INSERT INTO kwj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wosini Jisas ri himache leni amaha amahawani kanu tiki wu rauni wu litisini wu mwaseni fwa angi tokwe ya wu rachi. O ko hi ti, Besaita. Fwa angi tokwe wu rachindawani Jisas ele hima miyafo ni humbwewani ya wu ichiꞌucha. ");
INSERT INTO kwj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tinda wu ichiꞌuchasiwani Jisas kimba tiki Gotri ni uchahambwa kinani ya ri rau. ");
INSERT INTO kwj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wosiwani hunduya iwani, o kanu fwa nindo tiki dawani Jisas tombwa o kimba ki ya ri eninda. ");
INSERT INTO kwj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ri enindani ri himache le ri heiwani ausuwa laka wu indau tokwe sindawani kanu i kinani tau kwambu ya wu randa. Ete wu wondawani niliki ete dawani kapwa apwe gindau amwa ki Jisas fwa tenge tiki eti eti wunu tambwa ya ri i. Ri ini ya wunu ri dikikonda. ");
INSERT INTO kwj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wondawani ele ri himache rini heiwani fwa tenge tiki eti eti ri indawani ete ya wu hambwa, “O ambusuwa!” Wokoni ata ti au laka ya wu gi. Hinde wowani, wunu tinda ete rini wu heini aki laka ki wu akiro. ");
INSERT INTO kwj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ete wowani metengei wunu uchani ya ri sawe, “Sembe kuhi kwambu naha sa ete da. Ando a tandau. Apa aki kei.” ");
INSERT INTO kwj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O hinga ri sawesini wunu tambwa ri ini kanu tenge tiki ri rauwani o ausuwa laka ete humbu. Wowani mwale ti ete ya wunu sukwani i. ");
INSERT INTO kwj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hinde wowani, ka bereti kale hima miyafo ni haro sumbu ni wu hambwa nambwe. Mina. Sembe wuhi emendiki naha ete dau. ");
INSERT INTO kwj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wosini dani ini wu rachini Genesaret mapwa tokwe ya wu i. Wu ini kanu wuhi ti fwa gamba tiki ya wu injisi. ");
INSERT INTO kwj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wu injisini nuwe tokwe wu sikawani ele hima miyafo Jisas ni wu heini metengei ya wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wowani wu imaꞌaini ele mapwa hinga tinda ete wu ini siki wondau hima leni tei tiki wu owesini wu kichani Jisas ni ya wu wakitekinda. ");
INSERT INTO kwj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wondawani ele ko hinga, ele ko laka hinga, ele mapwa tinda ete ri iwani siki wondau hima leni hima miyafo wausindau michi tiki ratani andosini Jisas ni ya wu sili, “Ma tawa dele siki wondau hima le sa mini toro. Minambwe mi nawa nikaꞌari sumbu mihi tunumbwa sa wu toro.” Wowani ele rini tororo hima tinda ete siki wuhi ti kipe ti ya wu wosi. ");
INSERT INTO kwj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wondawani Farisi hima fwelenga Gotri lo mwanji hambwandau hima fwelenga Jerusalem wu andosini Jisas tambwa wu tani ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wu wausini wu heiwani Jisas himache fwele Farisi hima i sumbu, tapa yokosini andau sumbu, hinga wu wosi nambwe. Wunu tapa kisi tinga ahirahi ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tapa yokosini andau o Farisi hima i sumbu ni ele Farisi hima, ele Juta hima kupu hinga tinda ete wu sirinandaro. Wondani wunu atei sumbu tini wu toronambusini tapa wuhi yokosinimbwa ahirahi wu ano. ");
INSERT INTO kwj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O hinga wondani wunu hima miyafo waundau michi, maketi tokwe wu isini wu ai tani tape wuhi uku ya nambwe nawa apa ahirahi wu a hinga. Ka sumbu hinga wu toronambusindau ti, sumbu miyafo naha. Sumbu foti ka hinga: ele disi, ele hachahungwe hinga tinda ete, e, ele ahirahi andau tei yokondau ti. ");
INSERT INTO kwj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","O hinga wu wondawani ele Farisi hima, ele Gotri lo mwanji hambwandau hima Jisas ni wu silini ya wu sawe. “Hinde wowani mi himache le atei hima i sumbu wu sirinanda nambwe? Tapa wuhi ti kisi tinga ahirahi ete toroni wu andau.” ");
INSERT INTO kwj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wowani Jisas ya wunu sawe, “Gotri mwanji bwarakarandaro hima Aisaiya ku yani yani kapwa sumbu ku wondau keke mwe naha ri chengi tiki ka hinga kaisindau: ‘Dele hima wui takisopo tukumbwa hi ahi ti kipe naha wu rasaindau. Woroti wui sembe ti ani ni apahime naha dau. ");
INSERT INTO kwj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wondani hima to owero sumbu tini Gotri lo mwanji hinga nimba wu hambwasini hima leni wu ondiyakandiyandau. O hinga wu wondani ani ni nimba gamboni wu lotu wondau.’ ");
INSERT INTO kwj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kunu Gotri lo mwanji apa ku hanjaꞌairo. Wosini hima owero sumbu tunumbwa ete ku toronambusindau.” ");
INSERT INTO kwj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wosini Jisas ete ya wunu sawe, “Hima owero sumbu ku toronambusini Gotri lo mwanji mwe ku hikisandani ku hambwasini mwanji nimba ku gambondau. ");
INSERT INTO kwj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Hinde wowani ka hinga a sawero? Gotri lo mwanji ete sawe, ‘Mi nuwai yapai ni sembe wahapi ma ha.’ Wosini ai sawe, ‘Hima fori nuwai yapai ni kapwa mwanji bwawa ma rini yewa sa ha.’ ");
INSERT INTO kwj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wowani kunu ga ka Gotri lo mwanji ni ku jamekosini ka hinga ku ai bwandau, ‘Hima fori ri nuwai yapai ni sawe, “Kini ani hakoro mwaꞌambwe ahi Gotri ni ani haro,” ");
INSERT INTO kwj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","o hinga nawa ri nuwai yapai keke ri okulandau sumbu sa biya da.’ ");
INSERT INTO kwj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","O hinga ete ku sawendani kui atei hima owero sumbu ku toronambusini Gotri mwanji tikisapu hinga ku toroni ku humbweꞌindau. Tambwa a sawero kapwa sumbu hinga ni miyafo ku wondau.” ");
INSERT INTO kwj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wosini Jisas himiyama hurahama miyafo ni ai uchani ya wunu ri sawe, “Kunu tinda ete, ai mwanji ma ku mendini ku hambwa. ");
INSERT INTO kwj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hoko tokwe dau mwaꞌambwe hima foki raisini o hima i sembe ti kisi hinde wo kumbwa. Mina. Ele sumbu hima i sembe we tiki sukwandau tombwa o hima i sembe ni kisi wondau. ");
INSERT INTO kwj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hima fo wasamba chele do mwanji sa mendi.” ");
INSERT INTO kwj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wosini ele himiyama hurahama miyafo ri andosini aka fo tokwe ya ri i. Wosini ri himache le ka mwanji yepe ni Jisas ni ya wu sili. ");
INSERT INTO kwj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wu siliwani ya wunu ri sawe, “Kunu okwe ka mwanji yepe ku hambwanda nambweꞌe? Ele mwaꞌambwe hoko tokwe dau hinga tinda ete hima ki raisini o hima i sembe ti kisi hinde wo kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hinde wowani, hoko tokwe dau mwaꞌambwe hima i inaka tokwe i nambwe. Mina. Hima i sembe we tokwe raisini semewa ki ya raiu.” O hinga ri sawero ti, Jisas ele ahirahi hinga tinda ete hima keke kipe ri naro. ");
INSERT INTO kwj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mwanji fo ete ya ri sawe, “Ele sumbu hima i sembe we tiki sukwandau o tombwa hima i sembe kisi wondau. ");
INSERT INTO kwj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Hinde wowani, hima i sembe we tiki sukwandau ti ka hinga: kapwa inaka, hima i humwe ni sawe, hili ya, hima yeni si, anahopwesini kapwa sumbu ai wo, ");
INSERT INTO kwj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","miya tiki heini okokona, ele kapwa sumbu, nimba gambo, inaka ki sawekawe sumbu, sembe enge a, Gotri ni saweholiya, rinjenga ri hi numbwa rasai, e, ambwatinambwati sumbu. ");
INSERT INTO kwj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kalehaꞌa kapwa sumbu hinga tinda ete hima i sembe we tiki dasini hoko tokwe sirani o hima ni kisi wondau.” ");
INSERT INTO kwj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wosini gisi foki Jisas ai saini o ko ri andosini Taiya mapwa tokwe ya ri i. Ri ini apa hima rini heino keke ri diyahandani aka tiki ri raruni ri yani kinani, mina. Hinde ri yani kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Woro humwe fo Jisas taro mwanji tini ya ti mendi. O humwe, ti himiyama che ti, himamwale kapwa tinga dau. Wowani Jisas taro mwanji ti mendisini metengei ete Jisas tambwa ti ini ri mu tiki ti ombungwesini Jisas ni ti silini ya ti sawe, ");
INSERT INTO kwj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","“Ai che ga dau himamwale kapwa ma rani ma humbwe.” Ka humwe Girik pe humwe, Siriya mapwa ki dau, Finisiya ko tiki tini raro. ");
INSERT INTO kwj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisas ni o hinga ti silini ti sawewani Jisas ya tini sawe, “Apa nui che leni ahirahi nu hawa wu awa sembe wuhi sa tale. Woro o ahirahi toroni asa tini nu humbweꞌi hinga.” Jisas Juta hima kupu leni che hinga yepeni o humwe ni asa hinga sawero. ");
INSERT INTO kwj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wowani o humwe mwanji wasa ai ya rini sawe, “Apukolaka, mwe naha mi sawero. Woro ahirahi andau tei tako tiki dau asa leto ele che i ahirahi gomu ni andau.” ");
INSERT INTO kwj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wowani Jisas ya tini sawe, “O mwanji wasa kipe ni bwaro keke ma ai i. Himamwale kapwa himiyama che ni apa andosini ihiro.” ");
INSERT INTO kwj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wowani aka tihi tokwe ti ai ti ini ti himiyama che ti heiwani o himamwale kapwa tini andosini isiwani tei tenge tiki ya ti tukuyanda. ");
INSERT INTO kwj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wosini gisi foki Jisas Taiya mapwa andosini Saiton mapwa dikini ini Dekapolis mapwa nindo tiki i ini Galili fwa tiki ya ri ai ta. ");
INSERT INTO kwj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ri ai tasiwani wasamba kitisini mwanji bwanda nambwe hima forini Jisas tambwa wu ratasini rini wu silini ya wu sawe, “Tapa mihi do hima ni ma toro.” ");
INSERT INTO kwj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wowani Jisas ele himiyama hurahama miyafo ri andosini rini rani fi ini fini bati dani Jisas tapa tongo o hima i wasamba tiki ri owesini sungwa yini o hima i tarukwe ki ya ri owe. ");
INSERT INTO kwj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ri owesini niri tokwe ri mausini ata gamindache gisini ya ri sawe, “Efata.” O mwanji jamekowa ka hinga: “Apa ma mendi.” ");
INSERT INTO kwj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wowani o wasamba rini kitisiro metengei kipe ete wosindau tinga ri takisopo haunani mwanji kipe naha ya ri bwanda. ");
INSERT INTO kwj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wosini Jisas kwambu tiki ya wunu sawe, “Apa ahaꞌa sumbu hima foni ku sawe kei.” Jisas o hinga wunu sawesiwani, mina. Wunu wu anambwa anambwawani o mwanji ya ichiꞌucha. ");
INSERT INTO kwj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","O mwanji ichiꞌuchandawani hima miyafo wu apapanani ya wu sawe, “Ele ri wosiro sumbu tinda ete kipe naha. Kale wasamba kitisiro apa wu mendindani kale mwanji bwanda nambwe apa mwanji wu bwandau.” ");
INSERT INTO kwj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ka gisi ki, himiyama hurahama miyafo tani fotukumbwa ya ai wu wau. Wausini ahirahi nambwe ya wu da. Wowani Jisas ri himache leni uchawani wu tawani ya wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ani dele hima miyafo keke inaka miyafo ani hambwandau. Hinde wowani, wunu ani ga gisi namili wu dani ahirahi wu anda nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iche tinga wu handau. O keke aka wuhi tokwe wunu a humbwewa wu ini wui numbo tiki misisiweri wunu dini wu hichakono. Dele hima fwele ko sumbwe ki wu tasini wu dau.” ");
INSERT INTO kwj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wowani ele ri himache mwanji wasa ya rini sawe, “Do hima da nambwe michi ki hinde na hima to ahirahi rani dele hima miyafo ni hawa wu ani sembe wuhi taleno?” ");
INSERT INTO kwj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wowani Jisas ya wunu sili, “Bereti geni kunu dau?” Wowani ya wu sawe, “Tapaꞌangi hatachi fisi.” ");
INSERT INTO kwj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ete wowani Jisas ele hima ni sawewani nuwe tiki ya wu liti. Wu linindawani Jisas ele bereti tapaꞌangi hatachi fisi rukoni torosini Gotri ni weseꞌasini ya ri lepika. Ri lepikasini ele ri himache ni hasini ya ri sawe, “Ma humwasini wunu ha.” Wowani ya wu humwasi. ");
INSERT INTO kwj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Fwaiꞌomwe fisiche naha dawani oti okwe Jisas Gotri ni weseꞌasini wu humwasi kinani ele ri himache ni ya ri sawe. ");
INSERT INTO kwj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wowani wu humwasiwani wu ani sembe wuhi ya wunu tale. Wowani ahirahi wu aro gamwe wu rukoni hara laka tapaꞌangi hatachi fisi ete ya wu waro. ");
INSERT INTO kwj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kale ahirahi aro hima i nindo tiki enindaro hurahama tinda ete 4,000 hinga, walefo naha. ");
INSERT INTO kwj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wowani rini ga ri himache lenga metengei kanu tenge tiki wu rauni Dalamanuta mapwa tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wu isiwani Farisi hima le tani Jisas ni mwanji au hinga wu bwandani rini wu simiyanehei kinani ya wu sili, “Gotri mini ga dawa kwambu naha wosindau sumbu ma nunu meku.” ");
INSERT INTO kwj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wowani Jisas mendini ri sembe ti nomo miyafo andawani ya ri sawe, “Hinde wowani do apa pe himako kwambu naha wosindau sumbu keke wu ani silindau? Mwanji mwe naha ki kunu a sawendau. Apa kwambu naha wosindau sumbu do apa pe himako ni a meku hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","O hinga ri sawesini Jisas wunu andosini kanu tenge tiki ai rauni fwa angi tokwe ya ai ri sika. ");
INSERT INTO kwj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Fwa angi tokwe wu sikandani ri himache le ete ya wu hambwa, bereti fwele wu rukoni wu rata nambwe. O keke apa bereti funda tombwa kanu we tiki ya da. ");
INSERT INTO kwj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wowani Jisas autangini ya wunu ri sawe, “Farisi hima i bereti hehenandau wo, yis, ga Herot i bereti hehenandau wo, yis, ga kipe naha ma ku hambwafwaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wowani wunjenga wu anambwa anambwani ya wu sawe, “Bereti nunu ga da nambwe keke Jisas nunu sawero.” ");
INSERT INTO kwj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","O hinga wu hambwandawani Jisas hambwani ya wunu sawe, “Hinde wowani kunjengambwa bereti kunu ga da nambwe keke ku anambwandau? Kunu kui inaka tiki ku hambwanda nambweꞌe? Kui sembe emendiki naha ete dauꞌu? ");
INSERT INTO kwj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miya kuhi dawani ku heinda nambweꞌe? Wasamba kuhi dawani ku mendinda nambweꞌe? Ete ku hikisandauꞌu? ");
INSERT INTO kwj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ka gisi bereti tapaꞌangi tumbwa a lepikasini kale 5,000 hurahama leni ani hasiwani hara laka geni ki ahirahi gamwe ku waroro?” Wowani ya wu sawe, “Tapaꞌangi tapaꞌangi hatachi fisi.” ");
INSERT INTO kwj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wowani Jisas ya ri ai sawe, “Gisi foki ai bereti tapaꞌangi hatachi fisi numbwa a lepikasini kale 4,000 hurahama leni ani hasiwani hara laka geni ki ahirahi gamwe ku waroro?” Wowani ya ai wu sawe, “Tapaꞌangi hatachi fisi.” ");
INSERT INTO kwj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ete wowani ya wunu ri sawe, “Woro kale ni ku hambwa nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wosini Besaita ko tokwe ya wu i. Wu isiwani miya sasindau hima foni Jisas tambwa ya wu rata. Wu ratasini Jisas ni wu silini ya wu sawe, “Tapa mihi do hima ma toro.” ");
INSERT INTO kwj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wowani Jisas o miya sasindau hima ri torosini ra ra ko hoko tokwe ya fi i. Fi isini Jisas o hima i miya tiki sungwa yisini ri tapa pi rini torosini ya rini sili, “Mwaꞌambwe mi heindauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wowani o hima maꞌaini ya ri sawe, “Hima fwele ani heiwani wunu me hinga kale kaka wu ichiꞌuchanda.” ");
INSERT INTO kwj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wowani Jisas ri tapa pi o hima i miya tiki ya ri ai owe. Wosiwani ete ri misindani ri miya kipe ya ete wosi. Kipe ete wosiwani apa ele mwaꞌambwe hinga tinda ete amwei naha ya ri heiu. ");
INSERT INTO kwj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wosini Jisas rini ni aka tokwe humbwewani ri ikowani ya ri sawe, “Dohaꞌa ko tokwe apa ai i kei.” ");
INSERT INTO kwj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wosini Jisas ga ri himache lenga saini ko laka fo, Sisariya Filipai, takaisindau ele ko mapwa tokwe ya wu i. Wu ini numbo tiki Jisas ele ri himache ni ya ri sili, “Hima le ani ni hinde hinga wu hambwandau?” ");
INSERT INTO kwj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wowani ya rini wu sawe, “Hima fwele ete sawe, Mini uku yasindaro hima Jon. Fwele sawe, Mini imbihumbwa pe Ilaicha. Fwele sawe, Mini kale Gotri mwanji bwarakarandaro hima fo hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O hinga wu sawewani Jisas ya wunu sili, “Wo kundo, ani ni hinde hinga ku hambwandau?” Wowani Pita mwanji wasa ya rini sawe, “Mini mindombwa Kurais.” Kurais mwanji mwe ti ka hinga: Gotri ri tau ra kinani humbwero hima. ");
INSERT INTO kwj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ete wowani Jisas ya wunu sawe, “Apa mi ani hambwaro Kurais hi ti hima foni amwei wo kei.” ");
INSERT INTO kwj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wosini ka hinga ya wunu ai ri ondiyakandiyanda, “Dori Hima ri Che amwaka miyafo ri mendino. Kale ko aulindau hima laka lenga kale puris hima laka lenga kale Gotri lo mwanji hambwandau hima lenga wundo gumwa rini sisini rini yewa ya ri hakonda. Ri hasini gisi namili iwa ri ai saino.” ");
INSERT INTO kwj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rindo ka mwanji ni amwei naha ya wunu sawe. Wowani Pita rini ra ra numbo gamba tokwe rini raꞌaisini kwambu tiki ya rini sawe, “Mi hano hinga ani hambwa numbwa.” ");
INSERT INTO kwj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wowani Jisas jamekoni ele ri himache leni ri heisini Pita ni mwanji kwambu tiki ya ri ai sawe, “Saiten, mini ma tani ai gumwa tokwe i. Mini Gotri inaka tini mi sirinanda nambwe. Mina. Mini hima i inaka tunumbwa mi sirinandau.” ");
INSERT INTO kwj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wosini ele himiyama hurahama ga ri himache lenga wunu ri uchawani ya wu ta. Wowani ya wunu ri sawe, “E, hima fori ani ni sirina kinawa hi rihi ti rinjenga sa rakaisini me yapweke rihi ti ri kichani sa ani sirinani ta. ");
INSERT INTO kwj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","E, hima fori o ri himamwale numbwa ri hambwandawa, o himamwale rihi humbuno. E, hima fori inaka ti ani ga Gotri mwanji kipe ga hambwandani apa himamwale rihi andosiwa, o ri himamwale ri ai torono. ");
INSERT INTO kwj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wo hima fori do nuwe pe mwaꞌambwe hinga tinda ete ri torosini ka himamwale rihi humbusiwa, kale mwaꞌambwe hinga to apa hinde rini okulano? ");
INSERT INTO kwj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Apa ka hima bwele mwaꞌambwe ni hasini himamwale rihi ri ai torono? ");
INSERT INTO kwj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","E, hima fori do nuwe pe kapwa sumbu ete wondani Gotri ni hikisasini bwaꞌi bwatandau hima le wui nindo tiki dani, ai hi tinga ai mwanji ga ri yanisiwa, ichai dori Hima ri Che ele Gotri ni okulandau ensel kipe lenga ri Yapai okundau hi tinga ri ai tawa o hima ni ri saweno, ‘Hi mihi a hikisandau.” ’ ");
INSERT INTO kwj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wosini ya wunu ri sawe, “Mwe naha ki kunu a sawendau. Apa dohaꞌa ki enindau hima fwele ha hinga. Ete wu dawa Gotri kwambu hima i sembe aulindau ti kwambu ga sirano.” ");
INSERT INTO kwj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wosiwani gisi fo tapaꞌangi hatachi funda isiwani Jisas Pita, Jemis, Jon wunu ra ra kimba hime laka fotiki ya wunu rakau. Wosini wundombwa ya wu da. Wu dani wu heiwani Jisas tape ti jamekoni ba fo hinga ya ai sira. ");
INSERT INTO kwj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wokowani ri nikaꞌari le wu heiwani wamwa naha hinga ya okusinda. Woro dohaꞌa nuwe pe hinde na hima to mwaꞌambwe yokowa ka wamwa naha hinga sira kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wosiwani kale Jisas himache namili heiwani Ilaicha hima pi Moses Jisas ga mwanji ya wu anambwanda. ");
INSERT INTO kwj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wowani Pita o tini heisini Jisas ni ya ri sawe, “Apukolaka, ahaꞌa ki nu dawani kipe naha. Aka namili nu kikonda, Moses keke fo, Ilaicha keke fo, mini keke fo.” ");
INSERT INTO kwj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hinde wowani, wu akindani ri bwano mwanji hikisandani o hinga ri bwaro. ");
INSERT INTO kwj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ete wowani hiki hinga sikani ya wunu yoho. Wowani tumwa foti hiki we tiki uchani ya sawe, “O ai Che mwe naha. Rini ani okokonandau. Ri mwanji ma ku mendi.” ");
INSERT INTO kwj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wowani metengei ete ya wu maꞌaikaꞌai. Wu maꞌaikaꞌaini hima fo wu hei nambwe. Jisas numbwa wu heiwani wunu ga ya da. ");
INSERT INTO kwj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wosini o kimba wu andosini wu sikandani Jisas ka hinga minambwe wunu nani ya ri sawe, “Kale sumbu ku heiro ti apa ku ini hima fweleni sawe kei. Waya dori Hima ri Che matimat andosini ai saino gisi ki pwe amwei ku bwe wo.” ");
INSERT INTO kwj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wowani o mwanji wu toronambusini wunjenga wu anambwa anambwani ya wu sawe, “Ka matimat andosini ai saino mwanji mwe mu ti hinde na hinga?” ");
INSERT INTO kwj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wosini ya rini wu silinehei, “Hinde wowani kale Gotri lo mwanji hambwandau hima le ka hinga sawendau, Gotri chengi tiki kaisindau ti, Ilaicha to Kurais ni mwaseni tano?” ");
INSERT INTO kwj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wowani Jisas ri mwanji wasa ka hinga ya ri sawe, “Ei, mwe naha wu sawendau. Ilaicha to mwaseni tani ele mwaꞌambwe hinga ri wonorukweno. Wo hinde wowani ka mwanji Gotri chengi tiki dau, ka hinga sawero ti: dori Hima ri Che amwaka miyafo ri mendindawa hima le rini ningitengini ya rini saweholiyandakonda? ");
INSERT INTO kwj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Woroti apa kunu ni a sawendau. Ilaicha taro. Ri tasiwani wundo wui inaka leki wu okokonandau sumbu ni wu sirinani kapwa sumbu rini wu wosiro, Gotri chengi sawero hinga.” Jisas uku yasindaro hima, Jon, ni o hinga Ilaicha naro. ");
INSERT INTO kwj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wosini ele himache rihi tambwa ya wu i. Wu ini wu heiwani himiyama hurahama miyafo wunu ga ya wu wausinda. Wondawani Gotri lo mwanji hambwandau hima fwele mwanji tiki au hinga wunu ga ya wu anayenda. ");
INSERT INTO kwj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wondawani ele himiyama hurahama Jisas ni wu heikoni wu apapanani rini tambwa namani wu ini ya rini wu weseꞌa. ");
INSERT INTO kwj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wu weseꞌawani ya wunu ri sili, “Kunu bwele mwanji ni au hinga ku anayendau?” ");
INSERT INTO kwj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wowani hima fori ele himiyama hurahama miyafo i nindo tiki daro to Jisas ni mwanji wasa ya ri sawe, “Ondiyakandiyandau hima! Ai hurahama che mini tambwa a rataro. Hinde wowani, himamwale kapwa rini ga dani takisopo rini dimisiwani mwanji hinde ri bwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gisi gisi o himamwale kapwa ete rini toronambusini nuwe tiki rini rawaindau. Wondawani sungwa wamwa takisopo rihi tiki sukwandawani, ri fu ti gingandani, ri tape rikirikinandani apwe yitindau. Woro mi himache leni a sawewani, mina. O himamwale kapwa wu rani humbwe nambwe. Wu wofuro.” ");
INSERT INTO kwj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wowani Jisas o hinga ri mendisini ele himiyama hurahama ni ya ri sawe, “Kunu do apa pe hima sembe kipe naha ku ha nambwe. Gisi geni apa kunu ga ete a dawa sembe kipe ku ani hano? Gisi geni apa kunu keke nomo ai ete a randano? O che ma ku ani rata.” ");
INSERT INTO kwj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wowani o che Jisas tambwa ya wu rata. Wu ratasiwani o himamwale kapwa Jisas ni heikoni metengei ete o che ni ya yetupwa. Wowani o che nuwe tiki raisini ya ri jaunjamekonda. Wondawani sungwa wamwa takisopo rihi tiki ya sukwanda. ");
INSERT INTO kwj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wondawani Jisas o che i yapai ni ya ri sili, “Ka gisi geni ka sumbu hinga ri wondaro?” Wowani ya ri sawe, “Kichapwache ri daro gisi tiki ete ri mendindaro. ");
INSERT INTO kwj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ete ri mendindawani gisi miyafo o himamwale kapwa to rini toroni hi tiki fwa tiki rini rawaindaro, rini yewa ri ha kinani. E, mini kwambu naha nawa nunu keke mi woni ma nunu okula.” ");
INSERT INTO kwj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wowani Jisas ya rini sawe, “O hinga hinde mi sawendau? Sembe kwambu naha mi hawa kale mwaꞌambwe hinga tinda mi torono.” ");
INSERT INTO kwj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wowani metengei ete o che ri yapai ya uchani sawe, “Sembe ani haro. Woro kapwacheche. Ma ani okula.” ");
INSERT INTO kwj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas heiwani himiyama hurahama miyafo ete namani tandawani o himamwale kapwa ni kwambu tiki ya ri sawe, “Takisopo dimisindau wasamba kitisindau himamwale kapwa! Mini a sawendau. Mini o che ma andosini i. Apa tani rini ga ai da kei.” ");
INSERT INTO kwj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wowani himamwale kapwa o to kapwa ata ri sikowani o che hapa tinga rikirikinakowani rini andosini sirani ya i. Wowani o che haro hinga dawani ele hima miyafo ya wu sawe, “O che hahiro.” ");
INSERT INTO kwj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ete wowani Jisas ri tapa tiki rini toroni rasaiwani ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wosini dani ini Jisas aka tiki ya raru. Wosiwani ri himache letombwa dani ya rini wu sili, “Hinde wowani ka himamwale kapwa nundo nu rani nu humbwe kinani nu simiyafuro?” ");
INSERT INTO kwj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wowani Jisas ya wunu sawe, “Mwaꞌambwe foto mina. Gotri ni uchahambwandau tombwa apa ka himamwale kapwa hinga rani humbweno.” ");
INSERT INTO kwj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wosini o michi wu andosini Galili mapwa nindo tiki ya wu inda. Wondani Jisas apa hima fori wu dau michi hambwano keke rini o tini diyaha. ");
INSERT INTO kwj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hinde wowani, kale ri himache leni ri ondiyakandiyandani ka hinga ya wunu ri sawe, “Apa dori Hima ri Che ni ele hima i tapa tenge tiki o wu hakonda. Wosiwa rini yewa ri hasini gisi namili iwa ri ai saino.” ");
INSERT INTO kwj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wowani wunu o mwanji mu mwe ti wu hambwa nambwe. Wosini rini sili ki ya wu akinda. ");
INSERT INTO kwj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wosini ete wu ini Kapaneyam ko ki ya wu ambwe. Wosini aka we tiki wu rarusini Jisas ri himache leni ya ri sili, “Numbo tiki bwele mwanji tini ku anambwa anambwandaro?” ");
INSERT INTO kwj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wowani wunu mwanji nambwe. Hinde wowani, numbo tiki wu anambwa anambwandaro ti, namoto wunu mwaseni wui apukolaka hinga waꞌaino. ");
INSERT INTO kwj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wowani ri litisini ele ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi leni uchawani ya wu ta. Wu tawani ya wunu sawe, “E, hima fori ele hima ni mwaseni apukolaka waꞌai kinawa, rindo sa jepini ele hima ni okulani tau randau himache hinga sa da.” ");
INSERT INTO kwj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wosini che forini rasirani wui nindo tiki esisini, o che ni toroni lomongosini ya wunu sawe, ");
INSERT INTO kwj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hima fori hi ahi ni hambwani ka che hinga fori keke wono ti, oti ani keke wondau. E, hima fori ani keke wono ti, ori ani kekembwa wonda nambwe, mina. O ai yapai keke okwe ri wondau. Rindo ani humbwewani a taro.” ");
INSERT INTO kwj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wosiwani Jon ete ya sawe, “Ondiyakandiyandau hima, hima fori nu heiwani hi mihi ki himamwale kapwa ri rani ri humbwendaro. Rini nunu ga ichiꞌuchanda nambwe hima. O keke rini ni minambwe nu naro.” ");
INSERT INTO kwj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wowani Jisas ete ya wunu sawe, “Kunu apa rini ni minambwe ku na kei. Hinde wowani, hima fori ai kwambu torosini ai hi ki sumbu kwambu wosindano ti, o rini apa metengei kapwa mwanji hinde ani bwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hima fori nunu omwemendi nambwe sino ti, o rini nui nau. ");
INSERT INTO kwj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","E, hima fori kunu heini ete ri hambwawa, kunu Jisas ni sembe handau hima, wosini kunu ni uku sumbwe gamindache hinga hawa, mwe naha ki kunu a sawendau, ichai apa mwaꞌambwe wasa Gotri to rini hano. ");
INSERT INTO kwj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“E, hima fori ani ni sembe haro do che kapwacheche hinga forini ri sumbu ri mekusiwani o sumbu ni ri sirinani kapwa sumbu ai woni ani ni gumwa siwa, wowa o hima hinga humokuto beiye ti kwele rihi tiki injisini fwa laka tiki rini rawaino, o sumbu kapwacheche hinga. Woro hi tokwe ri raino to kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","E, tapa mihi fotini mi sirinani kapwa sumbu mi ai woni gumwa mi ani siwa, o tapa mihi ma kuto. Wowa tapa mihi angi tumbwa dawa himamwale ako mi torono, o kipe. Apa tapa mihi fisi ete dawa usungwaha da nambwe hi tiki mi ino, o kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","O hi ki owechehopoche hima i tape tini andani hinde apa wu ha kumbwa. Hi ti okwe hinde apa usungwaha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","E, seke mihi fotini mi sirinani kapwa sumbu mi ai woni gumwa mi ani siwa, o seke mihi ma takuto. Wowa seke mihi angi tumbwa dawa himamwale ako mi torono, o kipe. Apa seke mihi fisi ete dawa hi tiki mi ino, o kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","O hi ki owechehopoche hima i tape tini andani hinde apa wu ha kumbwa. Hi ti okwe hinde apa usungwaha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","E, miya mihi fotini mi sirinani kapwa sumbu mi ai woni gumwa mi ani siwa, o miya mihi ma gorini ma humbweꞌi. Wowa apa miya angi tumbwa dawa Gotri ko tokwe mi raruno, o kipe. Apa miya mihi fisi dawa hi tiki mini rawaino, o kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","O hi ki owechehopoche hima i tape tini andani hinde apa wu ha kumbwa. Hi ti okwe hinde apa usungwaha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Hinde wowani, simiyanehei gisi tawa Gotri ele hima ni soliwo ele ahirahi ni wondau hinga wosino. ");
INSERT INTO kwj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Soliwo mwaꞌambwe kipe. Woro soliwo au to humbuwa, hinde na hinga apa ku wosiwa soliwo ti au ai ano? Kui sembe we tiki soliwo au ni ma ku owe. Wosini kui hima lenga ma ku wahapini kipe kumbwa ku liti.” ");
INSERT INTO kwj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wosini Jisas ri saini o michi ri andosini Jutiya mapwa tokwe ini Jotan gara tokwe ya ri rachi. Wowani ele himiyama hurahama wu tani ya wu ai wau. Wausiwani ri sumbu tini ri ai sirinani Gotri mwanji tini ya wunu ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wondawani ele Farisi hima le rini tambwa tani ya rini simiyanehei. Wokinani ya wu sawe, “Hima fori ri humwe humbuno ti, Gotri lo mwanji nuhi o tini ohounandauꞌu, mina?” ");
INSERT INTO kwj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wowani Jisas mwanji wasa ya wunu sawe, “Moses mwase, bwele mwanji ni kui atei hima leni sawero?” ");
INSERT INTO kwj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wowani ya wu sawe, “Moses nunu ohounaro ti ka hinga: Hima fori ri humwe humbu kinawa o ri humwe humbuno chengi sa kaisini humwe sa ri humbu.” ");
INSERT INTO kwj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wowani Jisas ya wunu sawe, “Ele kui inaka emendiki naha ku dawani ri heifuni Moses o mwanji o hinga kunu kaisiro. ");
INSERT INTO kwj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Imbihumbwa mu naha ki, Gotri mwaꞌambwe le ri wosisini hura humwe ro wosiro. ");
INSERT INTO kwj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","O keke apa hima fori ri nuwai yapai andosini ri tani ri humwe ga fi anahaiyeni fi dano. ");
INSERT INTO kwj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wowa fi tape ti apa funda ete ya fi da dakonda. Fi tape ti apumbwa apu apa fi ai fi da hinga. Fi tape funda naha. ");
INSERT INTO kwj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","O hinga keke Gotri to ondiyasiro do sumbu apa hima fori ai fini lehima hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wosini dani ini aka tokwe wu isini ele ri himache to ka sumbu hinga ni ya rini ai wu sili. ");
INSERT INTO kwj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wowani ya wunu ri ai sawe, “E, hima fori ri humwe ni ri humbusini humwe fotini ri ai hopwewa, o hima fi anahopwero sumbu tini kapwa sumbu ri wondau. ");
INSERT INTO kwj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E, humwe ti okwe o hingambwa. O ti hurache ni ti humbusini hima foriki ti ai iwa, o humwe okwe fi anahopwero sumbu tini kapwa sumbu ti wondau.” ");
INSERT INTO kwj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wosiwani hima fwele ele wui che ni Jisas tambwa ya wu rata, Jisas tapa rihi wunu torowa Gotri wunu okula kinani. Wowani ri himache leto kwambu tiki ya wunu sawenda. ");
INSERT INTO kwj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ete wowani Jisas o hinga heikoni sembe enge ya wunu ri a. Wowani ya wunu sawe, “Ele kichapwache ma ku haraꞌaiwa ani tambwa sa wu ta. Kunu apa wunu torosi kei. Hinde wowani, Gotri kwambu hima i sembe aulindau ti, oti kale kichapwache hinga le keke dau. ");
INSERT INTO kwj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mwanji mwe naha tiki kunu a sawendau. E, hima fori Gotri kwambu ni kichapwache hinga toro nambwe nawa, apa o ki hinde raru kumbwa. Mina.” ");
INSERT INTO kwj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","O hinga ri sawesini ri tapa ki ele kichapwache ni ri toroni wunu ratani ri tapa ti wui tape tenge tiki owesini Gotri wunu okulano mwanji ti ya wunu ri handa. ");
INSERT INTO kwj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wosini Jisas saini ri himache lenga ya i. Wu indawani hima fo namani tani ri mu tiki ombungwesini ya rini sili, “Ondiyakandiyandau hima kipe, apa hinde hinga a wosini ete da ete da himamwale ako a torono?” ");
INSERT INTO kwj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wowani Jisas ete ya rini sawe, “Hinde wowani kipe mi ani nandau? Hima fori, mina, Gotri tombwa kipe. ");
INSERT INTO kwj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gotri lo mwanji kipe mi hambwandau: Apa hima yeni si kei. Apa fi anahopwero sumbu tini kapwa sumbu wo kei. Apa hili ya kei. Apa hima foni mwanji nimba gambo kei. Apa hima foi mwaꞌambwe nimba gamboni mihi na kei. Mi nuwai yapai kipe naha ma aulindani fi mwanji tini ma sirina.” ");
INSERT INTO kwj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wowani ori hima Jisas ni ya ri sawe, “Ondiyakandiyandau hima, imbihumbwa kichapwache a daro gisi ete ta tani apa okwe ele sumbu hinga ete a sirinandau.” ");
INSERT INTO kwj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wowani Jisas miya rini numbwa misini heikoni rini keke wokoni ya rini sawe, “Sumbu funda naha keke mi heifundau. Ma ini ele mwaꞌambwe mihi hinga tinda ete ya wungwa ma ji. Wosini ele ya mi torosini ele ya nambwe hima ni ma ha. Wowa apa mwaꞌambwe kipe naha mihi hewen ko tiki mi wauno. O hinga mi wosini ma tani ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wowani o hima ka mwanji hinga ni ri mendini sembe rihi ti amwaka rini andani ya ri i. Hinde wowani, ri usalikamba miyafo naha. ");
INSERT INTO kwj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wowani Jisas ele ri himache ni maꞌaikaꞌaini ri heisini ya ri sawe, “Kale mwaꞌambwe miyafo dau hima le Gotri kwambu hima i sembe aulindau o ki wu raruno ti, o kapwa tau naha.” ");
INSERT INTO kwj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wowani o ri mwanji ni wu mendini ele ri himache ya wu apapana. O hinga wowani Jisas mwanji foti ya wunu ri ai sawe, “Ai che le, hima forito ka Gotri kwambu hima i sembe aulindau, o ki raruno ti, o tau kwambu naha. ");
INSERT INTO kwj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ka omwe laka, hi ti kamel, apa tani nikaꞌari kapandau nili sopu tiki rarunoꞌo, mina? Ya hima naha fori apa Gotri kwambu hima i sembe aulindau, o ki raruno okwe o hingambwa.” ");
INSERT INTO kwj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ete wowani ele ri himache wu apapanani wunjenga ya wu anambwa anambwa, “O hinga nawa namoto ka himamwale ako naha torosini ete da ete dano?” ");
INSERT INTO kwj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wowani Jisas miya wunu misisini ya wunu sawe, “Ele hima wunjenga wui kwambu ki, mina. Gotri rindombwa oto. Gotri tombwa apa kale sumbu tinda ete ri wosino.” ");
INSERT INTO kwj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wowani Pita mwanji foti Jisas ni ya sawe, “Ma mendi, nunu ele mwaꞌambwe nuhi tinda ete nu andosini mini numbwa ya nu sirinanda. O keke bwele mwaꞌambwe tini apa nunu mi hakondau?” ");
INSERT INTO kwj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ete wowani Jisas ya ri sawe, “Mwe naha tiki kunu a sawendau. Hima fori ani ga ai mwanji kipe naha tinga mendini ri aka ri andosini ri apwai, kahai, nuwai, yapai, che, e, rupwa ete ri andosiwa, ");
INSERT INTO kwj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","apa mwaꞌambwe fo andosiro keke Gotri to mwaꞌambwe wasa 100 hinga miyafo naha rini hano. Wosiwa o nuwe ki ete ri dani aka miyafo, apwai miyafo, kahai miyafo, nuwai miyafo, che miyafo, e, rupwa miyafo ete ri torono. Woro ri torono gisi tiki hima fwele kapwa sumbu ti rini wowa sembe nomo rini ano. Wosini do nuwe ri andosini ka himamwale ako naha ri toroni ete ri da ete ri dano. ");
INSERT INTO kwj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hima miyafo hima i miyaningisopo ki mwasero leto Gotri miyaningisopo ki gumwa tokwe ya wu ai jepikonda. E, ele jepi jepi tandaro hima ele to wunu ai dikisini mwaseni ya wu ikonda.” ");
INSERT INTO kwj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wosini Jerusalem ko ki wu raru kinani numbo tiki ya wu inda. Wondani Jisas to mwaseni wunu ga ya ri i. Wowani ele ri himache apapanani inaka walefo ya wu hambwanda. Ete wowani himiyama hurahama ele to akini ya wunu sirinanda. Wowani Jisas ele ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi ele ni numbo gamba tokwe ya ri raꞌai. Ri raꞌaisini o rini ki metengei sukwakondau sumbu tini ya wunu ri ai sawe, ");
INSERT INTO kwj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ma ku mendi. Apa Jerusalem ya nu rarukonda. Wowa dori Hima ri Che ni ele puris hima laka le, Gotri lo mwanji hambwandau hima lei tapa tenge tiki o wu hakonda. Wosiwa wundo rini kotimwosini rini yewa ri hano mwanji tini funda wu bwani ya wu mendikonda. Wosini ele hima ba fweleni ya rini wu hakonda. ");
INSERT INTO kwj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wosiwa rini saweningitengini sungwa le rini yisindani rini tanambwasini rini yewa ya ri hakonda. Wosiwa gisi namili iwa ya ri ai saikonda.” ");
INSERT INTO kwj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wosiwani Sepeti che pi, Jemis hima pi Jon, findo rini tambwa tani ya rini fi sawe, “Ondiyakandiyandau hima, sini si okokona ti, mwaꞌambwe fori keke mini si siliwa o sumbu ma sini wosisi.” ");
INSERT INTO kwj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wowani ya fini ri sawe, “Bwele sumbu hinga tini kini ni a wosi kinani ki ani silindau?” ");
INSERT INTO kwj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wowani ya rini fi sawe. “Ichai mindo king apukolaka hinga funda mi dawa sini fisi, ma sini ohounawa sini fori mi tapa mama tokwe litiwa fori mi tapa usanji tokwe sa liti.” ");
INSERT INTO kwj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O hinga fi sawewani Jisas ya fini sawe, “Kini ki hambwasini ki ani silinda nambwe. Apa do amwaka a mendikondau hinga tini ki mendinoꞌo? Apa do nomo a rakondau hinga tini ki ranoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ete wowani ya rini fi sawe, “Si wo sindau.” O hinga fi sawewani Jisas ya fini sawe, “Mwe naha, do amwaka a mendikondau hinga o ki mendikonda, do nomo a rakondau hinga o ki rakonda. ");
INSERT INTO kwj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Woroti namoto ai tapa mama tokwe litiwa namoto ai tapa usanji tokwe litino, woro o ai tau na numbwa. Mina. Ai tako tokwe apukolaka hinga dano hima le Gotri rindombwa otokunasinda.” ");
INSERT INTO kwj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wosiwani ri tapaꞌangi tapaꞌangi himache le o tini ya wu mendi. Wosini Jon hima pi Jemis ni sembe wuhi kapwa enge ti ete ya wunu a. ");
INSERT INTO kwj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wowani Jisas wunu uchawani rini tambwa ya wu ta. Wosiwani ya wunu ri sawe, “Kunu ku hambwandau, kale ko aulindau hima laka, wunu kwambu chele, wui ko pe hima leni wu yititakichandau. Wondani wui apukolaka le kwambu naha tiki wunu aulindau. ");
INSERT INTO kwj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Woro ka sumbu hinga ti apa kui nindo tiki da hinga. Mina. Hima fori kui nindo tiki apukolaka hinga da kinawa, o hinga rini kui tau ra himache hinga sa da. ");
INSERT INTO kwj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","E, hima fori kui nindo tiki mwaseni apukolaka fo hinga da kinawa, rini kui tako ki sa ete ri da. ");
INSERT INTO kwj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hinde wowani, dori Hima ri Che dohaꞌa nuwe ki taro ti, hima to rini okula ki ri ta nambwe. Mina. Rini ele himiyama hurahama keke ri hima tape ri ohumbwesini wunu okulani himamwale ako wunu hasini ai wunu rata ki ri taro.” ");
INSERT INTO kwj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wosini wunu Jeriko ko tokwe ya wu i. Dani ini Jeriko andosini ya ri ai i. Ele ri himache ga ele himiyama hurahama ga rini ga ya wu i. Wondawani miya sasindau hima fori, ri hi Batimiyas, Timiyas che, rini numbo gamba tiki linindani ele himiyama hurahama ni ya mwaꞌambwe keke wunu uchandau. ");
INSERT INTO kwj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wondani ka hinga ya ri mendisi, Nasaret pe Jisas o tanda. Wosiwani hapa tinga ri uchani ya ri sawe, “Jisas, king apukolaka Defit che. Mini ani keke mi woni ma ani okula.” ");
INSERT INTO kwj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wowani ele hima mwanji kwambu tiki ya rini sawe, “Mini ma gaina.” O hinga wu sawewani hapa tinga ete ya ri ai ucha, “King apukolaka Defit che. Ani keke mi woni ma ani okula.” ");
INSERT INTO kwj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wowani Jisas tani etisini ya ri sawe, “Ma rini ku uchawa sa ta.” O hinga sawewani miya sasindau hima o rini uchani ya wu sawe, “Sembe mihi kipe sa i. Apa mini ma sai. Rini mini uchanda.” ");
INSERT INTO kwj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wowani heiye tiki soꞌoiro nikaꞌari rihi rawakasini metengei ete ri etini Jisas tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ri iwani Jisas ya rini sawe, “Mi okokona ti, hinde hinga mini a wosi ki?” Wowani o miya sasindau hima ete ya rini sawe, “Ondiyakandiyandau hima! Ai a maꞌaikaꞌai ki.” ");
INSERT INTO kwj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wowani Jisas ya rini sawe, “Apa ma i. Ani ni sembe mi haro keke kipe mini wosihiro.” O hinga wowani metengei ete miya rihi ti kipe ya rini wosi. Wowani miya rihi apa ya ri heiu. Wosini Jisas ni numbo tiki sirinani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wosini Jerusalem ko ti takai hinga dawani Olif kimba alase tiki dau Betefasi ko tinga Betani ko tinga ya wu takai. Wosini Jisas ri himache fisi pini wu ino mapwa tokwe humbwewani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Fi ikowani ya fini sawe, “Ma ki ini o ko ki maꞌaini ki heindau ki ma ki raru. O ko ki ki raruwa omwe laka fo, hi ti dongi, injisiwani dau o tini metengei o ki heikonda. Hima fori o dongi tenge ki liti nambwe. O apambwa sairo dongi ki hungosini ma ki ani rata. ");
INSERT INTO kwj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","E, ki hungondawa hima fori ete kini sawewa, ‘Hinde wowani o hinga ki wondau?’ wowa ka hinga ma ki sawe, ‘Apukolaka ahaꞌa mwaꞌambwe ki tau chele. Wosini metengei ai ratano.” ’ ");
INSERT INTO kwj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wowani ya fi i. Fi ini fi heiwani dongi foti aka duwa fotiki wu injisiwani numbo gamba tiki ya eninda. Wowani o tini ya fi hungo. ");
INSERT INTO kwj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fi hungondawani takai enindaro hima ele to ya fini sawe, “Hinde wo ki o dongi ki hungondau?” ");
INSERT INTO kwj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ete wowani Jisas fini sawero hingambwa ya fi sawe. O hinga fi sawewani ele hima fini ohounawani o dongi ya fi hungo. ");
INSERT INTO kwj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wosini o dongi Jisas tambwa ya fi rata. Fi ratasini heiye tiki fi soꞌoiro fi nikaꞌari ti fi dangosini o dongi tenge ki Jisas liti kinani ya fi yeto. Wowani Jisas rauni o tenge ki ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wosiwani ele hima miyafo wui nikaꞌari ti numbo tiki wu yeto yeto ya wu inda. Wondawani hima fwele tau tokwe wu ini me tali le wu se se ratani numbo tiki ya wu owenda. ");
INSERT INTO kwj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ete wondawani mwaseni indau himiyama hurahama le, jepi jepi indau himiyama hurahama le ka hinga ya uchani sawenda, “Gotri ni ma ku eripeꞌaripe. Apukolaka hi tiki tandau do hima ni Gotri kwambu ti sa rini ha. ");
INSERT INTO kwj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gotri nui metele Defit ni bwasiro apa do tandau nunu aulino Apukolaka rini ga Gotri kwambu ti sa ete da. Gotri hi tini ma ku rasai!” ");
INSERT INTO kwj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wondawani Jisas Jerusalem ko ki ya ri raru. Wosini Gotri aka laka ki ri rarusini ele mwaꞌambwe hinga ri maꞌaikaꞌaini ya ri hei. Wondawani nika ti ya rai. Ete wowani ele ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi rani ya wu i, Betani ko tokwe. ");
INSERT INTO kwj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wosini dani ini lindanawani Betani wu andosini wu tandani Jisas iche tinga ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wowani kwai hinga ri maꞌaini heiwani me hi fo ti, fik, o tini ri heiwani minga miyafo naha gwarosinda. O hinga ri heisini mwe wasino nani hei ki takai ya ri i. Ri ini me mu tiki ya ri raru. Wosini ri heiwani o me mwe wa nambwe. Mina. Minga naha tumbwa ya da. Hinde wowani, o me mwe wanda nambwe gisi tiki ri iro. ");
INSERT INTO kwj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wowani Jisas o me ni ya ri sawe, “Apa do me mwe ai wa kei. Minambwe naha.” Ete wowani ele ri himache o tini ya wu mendi. ");
INSERT INTO kwj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wosini wu ini Jerusalem ko tiki ya wu raru. Wu rarusini Jisas ini Gotri aka laka we tiki raruni ya mwaꞌambwe keke wungwa jindaro hima leni kwambu tiki sawendawani sirani ya wu inda. Wondawani Gotri aka laka takisi ya ha kinani tandau hima leni silifa ya ni anaha anahandau hima ele i tei ga ele apwenumwa ki ya wungwa jindaro hima lei linindau tei mwaꞌambwe lenga toroni sahumwani ya ri rumbwenda. ");
INSERT INTO kwj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wosini Jisas ya wungwa jindau mwaꞌambwe leni toroni Gotri aka laka we tiki ini raꞌaindau o tini minambwe ya ri na. ");
INSERT INTO kwj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O hinga ri wosini wunu ondiyakandiyani ya ri sawe, “Gotri chengi tiki ete sawesindau, ‘Aka ahi tini ka hinga wu uchano: Dele nuwe pe hima hinga Gotri ni weseꞌano aka.’ Wowani mina. Do Gotri aka ku wondau sumbu keke hili ya hima leto yanindau michi hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wosiwani ele puris hima laka le, Gotri lo mwanji hambwandau hima le o tini ya wu mendi. Wu mendisini rini yewa ri hano numbo tini ya wu wakinda. Hinde wowani, kale hiꞌucha hima Jisas ni wu akindaro. Ele himiyama hurahama hinga Jisas ri mwanji ni wu mendini wu apapanandawani o tini heikoni wu akindaro. ");
INSERT INTO kwj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wosini hunduya iwani Jisas ga ri himache lenga Jerusalem andosini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wosini lindanawani nurumbumbwa ya wu i. Wu indani wu heiwani o me, hi ti fik, ya rikaꞌaisinda. Ele minga ga nanji, talitapa hinga tinda ete rikaꞌairo. ");
INSERT INTO kwj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita injele o bwasiro mwanji tini hambwani ya ri sawe, “Ondiyakandiyandau hima, ma hei. Injele walambe i ki mi sawesiro me oti apa rikaꞌaihiro.” ");
INSERT INTO kwj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wowani Jisas mwanji wasa ete ya wunu sawe, “E, hima fori sembe Gotri ni mwe naha hasini, ");
INSERT INTO kwj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","rini do kimba ni ete ri sawewa, ‘Mini ma saini chunani ini fwa laka tiki rai,’ wosini o hima sembe fisi ri hambwa nambwe ri inaka ki ete ri sawewa, ‘Do mwanji ahi mwe naha o sukwakonda,’ wowa, mwe naha ki kunu a sawendau, apa mwaꞌambwe o hima sawero hinga o sukwakonda. ");
INSERT INTO kwj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mwaꞌambwe fo ku toro ki Gotri ni ku uchahambwa kinawa, sembe ku hasini ka hinga ma ku sawe, ‘Ei, nunu ka mwaꞌambwe mwe naha o nu torokonda,’ o hinga ku nawa o mwaꞌambwe ku sawero hinga sukwa sindau. ");
INSERT INTO kwj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“E, gisi fo ku saini ku etisini Gotri ni ku uchahambwakoni hima fori kapwa sumbu kunu wosiro tini ku ai hambwawa kui inaka tiki o ri kapwa sumbu ma ku rani humbwe. O hinga ku wosiwambwa kui Yapai hewen ko tiki dau to rindo apa kui kapwa sumbu o ri rani humbwekonda. ");
INSERT INTO kwj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Woro hima fwele kunu ni wu woro kapwa sumbu ni ku rani ku humbwe nambwe siwa, kui Yapai hewen ko ki dau okwe kapwa sumbu kuhi hinde ri rani ri humbwe kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wosini Jerusalem ko ki wu ai rarusini Jisas Gotri aka laka we ki raruni ya ri ichiꞌuchanda. Wondawani ele puris hima laka lenga Gotri lo mwanji hambwandau hima lenga, e, kale Jerusalem ko aulindau mekupu lenga rini tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wosini ya rini wu sawe, “Mini bwele kwambu hinga tini mi torosini kale tau hinga mi randau? Namoto ka kwambu mini hasiwani ele tau hinga mi randau?” ");
INSERT INTO kwj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wowani Jisas ya wunu sawe, “Ani okwe mwanji fotini kunu a silikondau. Wowa mwanji wasa ku ani sawewambwa apa ani ga ele tau a randau kwambu ti kunu a saweno. ");
INSERT INTO kwj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ka uku yasindaro hima, Jon, ele hima ni uku yasindaro sumbu ti ku hambwawani, namoto o tau keke kwambu rini haro? Gotri to rini haroꞌo, hima foto rini haro? Ku hambwawa ma ani sawe.” ");
INSERT INTO kwj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wowani wunjenga wu anambwa anambwa, “E, ete nu sawewa, ‘Gotri to kwambu Jon ni haro,’ wowa apa ete o ri sawekonda, ‘Wo hinde wowani sembe rini ni ku ha nambwe?’ ");
INSERT INTO kwj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","E, ete nu sawewa, ‘Hima leto kwambu rini haro,’ woro apa o mwanji nu sawe hinga.” Hinde wowani, ele himiyama hurahama keke wu akindaro. Ele himiyama hurahama wunu ya wu hambwanda, Jon rini Gotri kwambu torosini Gotri mwanji bwarakarandaro hima. ");
INSERT INTO kwj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wofunu Jisas ni mwanji wasa ya wu sawe, “Nunu mwanji wasa nu hikisandau.” Ete wowani Jisas ya ai wunu sawe, “Ani okwe apa kunu a sawe hinga, ka tau a randau kwambu ahi ti.” ");
INSERT INTO kwj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wosini Jisas mwanji yepe fweleni ya wunu sawe, “Hima fori tau ti ri wosini kupu fo, hi ti waini, o tini ya ri sinda. Wosini ini ti haweini ya ri injinda. Wosini o kupu mwe dahakini uku ti rawaino hungwe laka ti oweno wa tini ya ri ei. Wosini o kupu mwe ni aulini dano hima keke aka hime laka fo ya ri kisi. Ete wosini o waini rupwa ya tau rano hima fwelei tapa tenge tiki ya ri ha. Wosini ko sumbwe foki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dani ini waini mwe ti wano gisi tiki ri himache forini ele waini tau randau hima le tambwa ya ri humbwe, o rupwa ki waro mwe rihi gamwe rini wu rata ki. ");
INSERT INTO kwj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wowani o ri himache wu torosini kapwa tapa naha ki ya rini ye. Wosini rini ai humbwewani nimba nimba ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wowani himache forini ai humbwewani wunu tambwa ya ai i. Ri iwani wu saini mwa tokwe rini yehuwasini ya rini saweholiya. ");
INSERT INTO kwj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ete wowani himache foringa ya ri ai humbwe. Wowani o ri himache wu yeni dinga ya wu wosi. Ete wosiwani himache miyafo ri humbweꞌiwani ya wu ta. Wowani fwele wu yewani akini iwani fweleni wu yeni dinga ya wu wosi. ");
INSERT INTO kwj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ete wowani funda naha ri ya da. O ri okokonandau ri che mwe naha tombwa. Dani ini jipe naha ti o ri che humbwewani waini tau randau hima le tambwa ya i. Wosini ya ri hambwa, ‘Apa ai che ri mwanji tini o wu mendikonda.’ ");
INSERT INTO kwj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wowani ele tau randau hima leto wunjengambwa wu anambwa anambwani ya wu sawe, ‘Dori che to apa ri yapai seke wange o sirinakonda. Ma rini nu yeni dinga ti nu wosi. Wosini apa do rupwa nunjenga nu toro.’ ");
INSERT INTO kwj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","O hinga wu nakoni rini toroni ratasini rini wu yewani ya ri ha. Wosini hima tape rihi ti toroni hoko tokwe ya rini wu rawara. ");
INSERT INTO kwj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“O hinga apa ka waini rupwa chele hima mwe ri hinde hinga apa ri wono? Apa ri tani o rupwa we ki kwai tau randau hima ele ni ri yeni dinga wosino. Wosino o tau hima ba fweleni ri hano.” ");
INSERT INTO kwj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ete wosini ya ri sawe, “Kunu Gotri chengi tiki kaisiro mwanji ku hambwa nambweꞌe? Ete sawero: ‘Ka worumbo ni aka kindau hima leto humbwero ti, apa kipe naha ai saini o aka ni ekikinasinda. ");
INSERT INTO kwj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Apukolaka to o sumbu wosiwani sukwawani nui miya ki nu heiwani kipe naha.” ’ ");
INSERT INTO kwj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wowani kale hima laka o mwanji ni wu mendini ete ya wu hambwa, Jisas ka mwanji yepe hinga ti o nunu ni ri hambwasini ri sawero. Wosini sembe enge ti rini wu ani rini toronambusi kinani, mina. Hinde wowani, ele himiyama hurahama ni wu akiro. Wu wofuni rini wu andosini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wosini Farisi hima fwelenga Herot himache fwelenga wunu humbwewani Jisas tambwa ya wu i. Wu ini Jisas ni toro kinani mwanji fwele rini wu gamboni ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","“Ondiyakandiyandau hima, nunu mini nu hambwandau. Mini mwanji mwe naha bwandau hima. Hima mwanji ti hinde hinga mini bwandau tini inaka tenge miyafo mi hambwanda nambwe. Gotri mini mekuro numbo numbwa mi sirinandau. Mini hi chele hima ga hi nambwe hima ga funda ete mi okokonandau. Wondani Gotri sumbu kipe ni ele himiyama hurahama wunu ni mwanji mwe naha ki mi ondiyakandiyandau. Mi hambwawani nunu takisi ya ti Rom pe king apukolaka, Sisa, ni nu hanoꞌo, mina? Hinde hinga mi hambwandau?” ");
INSERT INTO kwj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wowani Jisas wu gambondau ri inaka ki ya ri hambwa. Wosini ya wunu sawe, “Bwele keke ku ani simiyaneheindau? Ya humokuto fo ma ratawa ani hei.” ");
INSERT INTO kwj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wowani ya fo ya wu rata. Ete wowani ya wunu sawe, “Dohaꞌa himamwale ga do hi ga namohi?” Wowani ya wu sawe, “Sisa, Rom pe king apukolaka hi.” ");
INSERT INTO kwj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wowani Jisas mwanji ya wunu sawe, “Sisa mwaꞌambwe to o ma ai rini ku ha. Gotri mwaꞌambwe ti o Gotri ni ma ku ha.” Wowani inaka wuhi ti wu apapanani ya wu hambwanda. ");
INSERT INTO kwj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wowani Satiyusi hi uchandau hima fwele Jisas tambwa ya wu ta. Kalehaꞌa hima wunu ete sawendau, “Hima hasini hinde ai sai kumbwa.” Wosini ya rini wu sawe, ");
INSERT INTO kwj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ondiyakandiyandau hima, Moses kaisiro mwanji ete nunu sawero, ‘Hima fori hasiwani ri humwe ete dani fini che nambwe nawa, o ri analongo rindo o humwe ni hopwesini che rasiwa o haro ri analongo ni sa okula.’ ");
INSERT INTO kwj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Apa wunu hiparakambwe lembwa tapaꞌangi hatachi fisi ya da. Wosiwani apwai mwa laka rito humwe ya rata. Wosini dani ini ya ri ha. Rini che nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wowani rini ga diya rito o humwe ni ya ri ai hopwe. Wosini ya ri ha. Woro fini che nambwe. Wowani ri diya ti o hingambwa ya ai wo. ");
INSERT INTO kwj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","O hingambwa woni ele tapaꞌangi hatachi fisi analongo tinda ete o humwe numbwa wu hopwero. Wosini wunu tinda che nambwe ya wu ha. Jipe naha ki o humwe okwe ya ti ha. ");
INSERT INTO kwj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Woro apaꞌichai ele haro hima wu ai saino gisi tawa apa o humwe namoi humwe? Mi hambwandauꞌu? Ele tapaꞌangi hatachi fisi tinda o tini hopwero to sa.” ");
INSERT INTO kwj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wowani Jisas ete ya wunu sawe, “Kunu Gotri chengi ga Gotri kwambu ga ku hambwanda nambwe. O hinga keke mwanji walambe o ku bwanda. ");
INSERT INTO kwj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kale haro himiyama hurahama wu ai saino gisi tawa apa ele humwe ni hopwendau sumbu, ele hura lindau sumbu wu humbuno. Wosini Gotri tau okulandau ensel hinga wu dano. ");
INSERT INTO kwj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Kale haro hima ai saino sumbu tini Gotri chengi tiki sawendau ti, ku hambwa nambweꞌe, kale me cheche foki hi saindawani Gotri to Moses ni sawero mwanji kati? Gotri Moses ni ete sawero, ‘Ani Epuraham Gotri, Aisak Gotri, Jekop Gotri.’ ");
INSERT INTO kwj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ele hima himamwale tinga haro, Gotri wuhi mina. Ele hima himamwale tinga ete da ete da, Gotri wuhi. Mwanji kuhi ti ambwatinambwati mwanji hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wosiwani Gotri lo mwanji hambwandau hima fori ya ta. Ri tani ri mendiwani mwanji tiki au hinga ya wu anayenda. Wondani Jisas mwanji wasa kipe naha tumbwa ya wunu sawenda. O tini ri heisini Jisas ni ya ri ai sili, “Bwele Gotri lo mwanji to ele Gotri lo mwanji ni dikini funda ri kipe naha?” ");
INSERT INTO kwj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wowani Jisas mwanji wasa ya rini sawe, “Gotri lo mwanji funda ri kipe naha ti ka hinga: ‘Kunu Isurel hima kupu le, ma ku mendi! Gotri Apukolaka nuhi rindombwa funda naha. ");
INSERT INTO kwj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mi Apukolaka Gotri kekembwa ma woni mi sembe tinda ete, mi himamwale tinda ete, mi inaka tinda ete, mi kwambu tinda ete ma rini ha.’ ");
INSERT INTO kwj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","O lo mwanji gumwa ki tandau Gotri lo mwanji kipe naha ti ka hinga: ‘Minjenga mi okokonandau hinga ele biya hima keke o hingambwa ma wo.’ Lo mwanji ba fwele dopi lo mwanji fisi ni dikinda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wowani ka Gotri lo mwanji hambwandau hima to Jisas ni ete ya ri sawe, “Ondiyakandiyandau hima, mwanji mihi kipe. Mwe naha tiki mi sawendau. Gotri rindombwa funda naha. Fori rini hinga da nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nunu rini numbwa ma nu okokonani nui sembe tinda ete, nui hambwa tinda ete, nui kwambu tinda ete ma rini nu ha. Nunjenga nu okokonandau hinga ele biya hima ni o hingambwa ma nu okokona. Ei, kapi lo mwanji fisi ni nu sirinandau ti, omwe raꞌaini tei tiki owesini tinda ete tuni Gotri ni handau sumbu ga Gotri ni anguꞌomwe handau sumbu fwelenga wunu ni dikindau.” ");
INSERT INTO kwj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas o hinga rini mendisini ete ya ri hambwa, rindo kipe naha hambwasini mwanji wasa sawero. Ete wosini Jisas ya rini sawe, “Gotri kwambu ti o mini takaisini da.” Wosiwani hima fwele Jisas ni mwanji fwelenga wu ai wu silikoni ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wosini Jisas ka Gotri aka laka ki dani ele himiyama hurahama ni mwanji ti ya ri sawenda, “Hinde wowani kale Gotri lo mwanji hambwandau hima leto Gotri chengi tiki sawero Kurais ka ni ete wu sawendau, ‘Kurais rini Defit anitafenita fori?’ ");
INSERT INTO kwj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Woro Gotri Himamwale kipe ti Defit ga dani hambwa ti rini hasiwani mwanji ti ri bwaro, ‘Apukolaka ri Apukolaka ahi ni ete sawe: “Mini tapa mama ahi tokwe ma liti. Mi linindawa ichai ele mi miho a toroni seke tako mihi tiki a rawarusiwa wu dano.’” ");
INSERT INTO kwj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Defit rinjenga Kurais ni, Apukolaka rihi, ri nandau. O hinga nawa Kurais ni ri anitafenita fo hinga apa hinde ri sawe kumbwa.” Ete wowani ele himiyama hurahama ri mwanji ni wu mendikoni ya wu eripe. ");
INSERT INTO kwj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wosini Jisas wunu ondiyakandiyani ya ri sawe, “Kunu kale Gotri lo mwanji hambwandau hima leni ma ku hambwafwaꞌainda. Wunu nikaꞌari hime laka tini soꞌoisini ichiꞌuchandau tini wu okokonandau. Wunu ele himiyama hurahama apweli tiki wunu weseꞌa kinani o tini wu okokonandau. ");
INSERT INTO kwj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wondani lotu wondau aka tiki wu raruni hi chele hima leto litindau tei wuhi ki wu litindau. Wondani wu ini a laka owesindau tei tiki michi kipe ki wu litindau. ");
INSERT INTO kwj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wondani wu ini ele himanguto ni wu gambosini aka wuhi lenga usalikamba wuhi lenga wuhi wu nandau. Wondani wu gamboni Gotri ni huwe laka ete wu uchahambwandau. Kale wui sumbu keke, Gotri mwanji bwano ka gisi jipe naha tawa apa nomo laka foti wu ra sindau.” ");
INSERT INTO kwj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wosini Jisas Gotri aka laka ki ya rawaindau hungwe takai naha ki ya lininda. Wondani ri heiwani ele himiyama hurahama ya naro ti hungwe tiki ya wu rawainda. Wondawani ya miyafo dau hima ele to miyafo naha ya wu rawainda. ");
INSERT INTO kwj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ete wondawani ya nambwe himanguto foti tani ya naro pumbwa fisi ya ti rawai. ");
INSERT INTO kwj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wowani Jisas ele ri himache ni uchawani rini tambwa wu tawani ya wunu ri sawe, “Mwe naha ki kunu a sawendau. Do himanguto ya tihi ti rawairo ti, o hungwe ki ya ete rawaindaro himako ni ti dikiro. ");
INSERT INTO kwj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dele hima hinga wunu tinda ete ya chele. Wondani wui ya fwele hungwe we tiki rawairo. Woroti tini ya heifundau naha. Wofunu ahirahi rani ti akoro ya jipe naha tinda ete ti raꞌaini o rawaisinda.” ");
INSERT INTO kwj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wosini Jisas o Gotri aka laka andosini ya ri i. Ri indawani ri himache fori ya rini sawe, “Ondiyakandiyandau hima, dele Gotri aka kiro humokuto omwesika laka, aka kipe naha le ma hei!” ");
INSERT INTO kwj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wowani Jisas mwanji wasa ka hinga ya rini sawe, “Kale aka laka mi heindauꞌu? Humokuto fo wu andosiwa kiheiye hinde apa da kumbwa. Mina. Apa funda ete wu lendoni wu humbwewa raino.” ");
INSERT INTO kwj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wosini dani ini Jisas ka Olif kimba laka ki litisini kachi maꞌaineheiwani Gotri aka laka ti ya eninda. Wondawani ri himache opuriꞌopuri, Pita, Jemis, Jon, Anduru wundombwa tani ya rini wu sili, ");
INSERT INTO kwj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Mini ma nunu sawe, hinde gisi tambwa mi sawero sumbu sukwano? Bwele sumbu hinga to metengei naha sukwawa apa nu hambwano, kale sumbu to takaihiro, o ya sukwakonda?” ");
INSERT INTO kwj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wowani Jisas mwanji wasa ya wunu ai sawe, “Kunu ma ku hambwafwaꞌai, foki hima fori apa o kunu gambokonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hima miyafo tani apa hi ahi tini gamboni ka hinga o wu sawekonda, ‘Ani andombwa dori to.’ Wosini apa ele himiyama hurahama ni o ya wu gambondakonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Wosini dani ini ichai au anayendau ata tinga au anayeno mwanji suwa tinga ku mendiwa nawa apa apapana kei. O au ta kinawa ya sa ta. Woroti gisi jipe humbuno ti wayambwa. ");
INSERT INTO kwj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ko fokipe hima le saini ko fokipe hima lenga au ti wu anayeno. Ko fweleni aulindau king apukolaka ri himache le saini king apukolaka fori ri himache lenga au ti wu anayeno. Mapwa fweleki minawe ti dindawa mapwa fweleki kapwa iche miyafo wunu hano. Kale gisi hinga ki mendino amwaka ti himiyama to che ra kinani metengei naha gwai amwaka mendindau hinga. ");
INSERT INTO kwj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kunjenga ma ku hambwafwaꞌaindani ku da. Apa kunu kotimwo kinani ele wui hiꞌucha hima le tambwa o kunu raꞌaikonda. Wosini lotu wondau aka tiki kunu rakwaisini o kunu tanambwasikonda. Wosini apa kunu raꞌaini hiꞌucha hima laka le, ele ko aulindau king apukolaka le, wui mwakambe tiki ani keke o kunu esikonda. Wowa mwanji kipe ahi tini o wunu ku sawekonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ele mapwa kipe hima hinga mwanji kipe ahi tini metengei sa wu mendi. Wosiwambwa gisi jipe o takonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kupu tiki kunu injisini kunu kotimwo ki kunu ra ra ino gisi tawa, mwanji hinde hinga ku bwano keke ku aki kei. Mina. Ele ku bwano mwanji hinga tinda ete Gotri to o kunu hakonda. Wosiwa o gisi kumbwa o mwanji ma ku bwa. O mwanji kunjenga ku bwa hinga. Mina. Gotri Himamwale kipe to kunu ondiyandawa ku bwandano. ");
INSERT INTO kwj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wondano gisi ki hiparakambwe fori ri hiparakambwe foni omwemendini au himako i tapa tenge tiki hawa rini wu yewa ri hano. Wondawa yapai hima wui che leni o hingambwa wu wosindano. Wondawa ele che nuwai yapai ni enge ti akoni gumwa wu sisini wu ini au himako ni wu sawewa tani wunu yewa wu hano. ");
INSERT INTO kwj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ete wondawa hi ahi ti kunu ga dau o keke apa ele hima tinda sembe amwaka ti o kunu akonda. E, hima fori ani keke kwambu naha ete ri dani ka gisi jipe naha humbuno ki ri ambwewa ori hima apa Gotri ai rini raꞌaino. ");
INSERT INTO kwj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ichai ku heiwa sarahumwarandau kapwa hima naha o sukwakonda. Ri sukwasini rindo ri hi na nambwe michi tiki ete ri etikonda.” Do chengi ni hambwandau hima, kipe naha ma ku hambwa. Wosiwa ka gisi Jutiya pe himiyama hurahama le sa wu akini kimba tokwe sa wu i. ");
INSERT INTO kwj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hima fori aka heiye tokwe dawa apa usalikamba toro ki raini aka we tokwe raru kei. Sa akini i, kimba tokwe. ");
INSERT INTO kwj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hima fori tau tiki dano ti apa ri ai jamekoni tani nikaꞌari rihi ti ruko kei. ");
INSERT INTO kwj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka gisi hinga tawa ani hambwawani fiya kapwa naha, kale sembe ga dau humwe le, che leni muku handau humwe le keke. ");
INSERT INTO kwj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","O keke kunu Gotri ni ma ku uchahambwanda, o sumbu mwa miyafo yeni tikiningo naha ano gisi tiki sukwano keke. ");
INSERT INTO kwj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hinde wowani, kale gisi ki apa nomo miyafo naha wu rano. Imbihumbwa Gotri mwaꞌambwe metengei naha ri wosiro ambwe naha ki ete ta tani apa okwe o sumbu hinga sukwa nambwe. Icheꞌapaki okwe ka nomo hinga hinde sukwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Apukolaka ele gisi faiche nunu keke owe nambwe napo, apa ele himiyama hurahama tinda ete ya wunu humbu. Woro ele hima Gotri to rihi naro keke ele gisi faiche ya ri owekonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wondawa ka gisi ki hima fori tani ete kunu sawewa, ‘Ma hei, Kurais ahaꞌa ki dau,’ e, fori ete sawewa, ‘O biya ki o da,’ wowa apa rini ni kui sembe mwe naha ku ha kei. ");
INSERT INTO kwj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Hinde wowani, apa hima fwele tani gamboni o ete kunu sawekonda, ‘Ani Kurais,’ e, ‘Ani Gotri mwanji bwarakarandau hima fo.’ Wosini apa kwambu naha wosindau sumbu le, tau ba fo ba fwele o kunu mekundakonda, wui okokona ti, ele hima Gotri to rihi naro leni gamboni wunu raꞌai kinani. ");
INSERT INTO kwj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","O hinga keke ma ku hambwafwaꞌainda. Ele sukwano sumbu hinga tinda ete apa naha kumbwa kunu a sawehiro. ");
INSERT INTO kwj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ka nomo laka rano gisi ele humbusiwambwa nika hunduno gisi o sukwakonda. O hinga wokowa nikahako ti apa oku hinga. ");
INSERT INTO kwj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wowa isangi le gwani o namaꞌi namatandakonda. Wondawa kale niri pe mwaꞌambwe kwambu naha le raꞌichiꞌuchandano. ");
INSERT INTO kwj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wondawa ka gisi ki wu heiwa dori Hima ri Che niri wamwa tenge ki ri litisini tandawa kwambu omwesika tinga okundau hi omwesika tinga apa rini ga dano. ");
INSERT INTO kwj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wosini ka gisi ki Gotri tau okulandau ensel leni ri humbwewa wu ini ele rihi naro niri ambwe nuwe ambwe ki dau himiyama hurahama leni wu ratani o wu waukonda. ");
INSERT INTO kwj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Me fo, hi ti, fik, o mwanji yepe ma ku hambwa. Burunandaro fik ki tongo ako ti ai sukwawa o gisi ki kunu ma ku hambwa, nika tumbwa yeno gisi takaihiro. ");
INSERT INTO kwj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Woro o hingambwa, ichai ku bwe hei. Kale sumbu hinga sukwawa ku bwe hambwa, ri ai ri tani lengenumbo tiki takaihiro. ");
INSERT INTO kwj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mwe naha tiki kunu a sawendau. Kale sumbu hinga tinda sukwawambwa do nuwe pe mwaꞌambwe hinga tinda humbuno. ");
INSERT INTO kwj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Do niri ga do nuwe ga humbuno. Woro ai mwanji tito hinde humbu kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hima fori ka gisi ga ka amwa ga hambwanda nambwe. Gotri tau okulandau hewen pe ensel le okwe hikisandau. Dori Che okwe hikisandau. Yapai rindombwa hambwandau. ");
INSERT INTO kwj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Kunu hambwafwaꞌai. Hinde wowani, ka gisi tano ti kunu ku hikisanda. ");
INSERT INTO kwj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","O sumbu, hima foto ri aka andosini mapwa fo tokwe indau hinga. Ri ikoni ele ri tau randau himache leni saweni tau ti hinawana wunu haꞌi hatasiwa mwaꞌambwe aulini wu da ki. Wondani hima forini lengenumbo naha tiki ri esisiwa, kipe naha ete ri aulini da ki. ");
INSERT INTO kwj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","O hinga keke kipe naha ma ku aulinda. Kunu ku hikisandau, aka chele yapai ai tano gisi ti. Kunu ku hambwanda nambwe, hunduya ki ri tanoꞌo, nili kowe ki ri tanoꞌo, apwetoko gino amwa tiki ri tanoꞌo, nurumbumbwa ete ri tano ti. ");
INSERT INTO kwj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Apa metengei ete ri ai tani ri heiwa ete ku tukuyanda hinga. ");
INSERT INTO kwj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Do mwanji kunu ni ani handau ti, ele himiyama hurahama keke tinda ete ani handau. Ma ku hambwafwaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasofa gisi laka ga bereti hehenandau wo, yis, owe nambwe gisi laka ga opi gisi laka, gisi fisi ini sukwakondawani ele puris hima laka lenga Gotri lo mwanji hambwandau hima ele ga ya wu anambwanda, “Hinde hinga apa nu wosini Jisas ni nu gamboni nu toroꞌinjisini nu yewa ri hano?” ");
INSERT INTO kwj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wondani ya wu sawe, “Ka gisi laka ki o hinga apa nu wo hinga. Apa kale bai himiyama hurahama rini keke wu wokoni au ti wu saino.” ");
INSERT INTO kwj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wosini Jisas saini Betani ko tokwe ri ini sechi okwe aro hima Saimon aka we tiki ya ri raru. Ri raruni tei tiki ri linindawani humwe fo ya ta. O humwe to humokuto fo, hi ti, alapasta, o tiki wosiro botoli we tiki dau kuwa kipe naha tandau ya miyafo naha ki randau weli, hi ti, narutu, o tini ra ra ya ti ta. Wosini o botoli ti yendungwasini kuwa kipe weli naha oti Jisas mwa tiki ya ti owehena. ");
INSERT INTO kwj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wondawani hima fwele daro ti, tini ni sembe amwaka ya tini wu a. Wokoni wunjenga ka hinga ya wu anambwa anambwa, “Bwele keke ka kuwa kipe weli naha nimba ti timbendau? ");
INSERT INTO kwj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","E, ka mwaꞌambwe ni ya wungwa nu ji ki nu humbweꞌipo, apa hima fori asama funda ya tau rani torondau ya hinga ya nu torou. Wosini napo kale ya nambwe hima leni nu hau.” O hinga wu anambwakoni o humwe ni kwambu tiki ya wu sawe. ");
INSERT INTO kwj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ete wowani Jisas ya ri sawe, “Ma tini ku ando. Hinde wowani nomo tini ku handau? Tini sumbu kipe naha tini ti ani wosiro. ");
INSERT INTO kwj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nili tapwa ambwe bwarichape hima le kunu ga dau ti, ele gisi hinga ete wunu ku okula kinawa ma wunu ku okula. Woro ando apa kunu ga hinde ete a da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O humwe ti wosi ki ti hambwandaro sumbu ti, ti wosihiro. O kuwa kipe weli naha tape ahi tiki ti hindiro ti, matimat tiki a rai kinani ti ani otokunaro. ");
INSERT INTO kwj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mwe naha ki kunu a sawendau. Dohaꞌa nuwe ki ele mapwa hinga tinda ete Gotri mwanji kipe wu bwano gisi tawa do humwe ani wosiro sumbu okwe ete wu bwandani tini ni hinde wu hikisa kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wosiwani gisi fo, ele tapaꞌangi tapaꞌangi hatachi fisi himache fori, Jutas Isukariyot, to ele puris hima laka le tambwa Jisas ni wui tapa tenge tiki ha kinani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wowani o tini wu mendikoni wu eripeꞌaripeni ya ti rini ha kinani mwanji funda wu bwani ya wu mendi. Wosiwani Jutas Jisas ni wui tapa tenge tiki ri ha kinani numbo ri wakindani ya ri wohambwakahambwanda. ");
INSERT INTO kwj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wosiwani bereti hehenandau wo, yis, owe nambwe gisi laka ya sukwa. Ka gisi ki Juta hima kupu le sipisip wu yeni gisi laka, Pasofa, keke ahirahi wu otokunandau. Wowani ele ri himache Jisas ni mwanji ya wu sawe, “Hinde mi hambwandau? Nu ini gisi laka, Pasofa, keke ahirahi soki nu otokunandawa mi tani mi ano?” ");
INSERT INTO kwj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wowani Jisas ri himache fisi humbwewani fi ikowani ya fini sawe, “Ki ini ko laka tiki ki raruni ki heiwa numbo tiki hima fori hungwe laka ti uku tinga kichani indawa, rini ni ma ki sirinani ki i. ");
INSERT INTO kwj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wosini aka fotiki ri raruwa, yapai chele aka ni ka hinga ma ki sawe, ‘Ondiyakandiyandau hima sihi ete sawero, “Ai himache lenga gisi laka, Pasofa, keke ahirahi ani ano aka tipa so?’” ");
INSERT INTO kwj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wowa heiye tokwe dau aka tipa laka tini o kini mekusikonda. Litino tei ti ahirahi oweno tei ti o otokunasinda. Kini o aka we ki nunu keke ahirahi ma ki otokunanda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ete wowani opi himache fisi rihi ya fi i. Fi ini ko laka ki fi raruni Jisas o fini sawesiro hinga ya fi wosi. Wosini gisi laka, Pasofa, keke ahirahi ti ya fi otokunanda. ");
INSERT INTO kwj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wosiwani nika raini hunduya iwanimbwa Jisas ele himache rihi tapaꞌangi tapaꞌangi hatachi fisi ga ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wu tani tei tenge tiki wu linindani ahirahi ya wu anda. Wondani Jisas ya sawe, “Mwe naha ki kunu a sawendau, kui nindo tiki dau hima forito apa ani ni omwemendindau hima lei tapa tenge tiki ri ani hakonda. Hima mwe ri ani ga do anda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wowani ele himache rihi sembe nomo ti ya wunu a. Ete wowani funda funda ya rini wu sili, “Andoꞌo? Ani mina.” ");
INSERT INTO kwj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ete wowani Jisas ya wunu sawe, “Tapaꞌangi tapaꞌangi hatachi fisi kui nindo tiki o lininda. Ri tapa ti disi we tiki funda do si rawainda. ");
INSERT INTO kwj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ei mwe naha, dori Hima ri Che o hakonda, Gotri chengi rini sawero hingambwa. Woro o hima hinga fiya kapwa naha, dori Hima ri Che ni omwemendindau hima lei tapa tenge tiki ri hano ti. O keke Gotri amwaka miyafo rini hakondau. Kari hima hinga ri nuwai hinde wowani rini raro?” ");
INSERT INTO kwj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ahirahi ete wu andani Jisas bereti fo rukoni Gotri ni ri weseꞌasini ri lepikani ya wunu ha. Wosini ya ri sawe, “Ma ku toro. Oti ai hima tape.” ");
INSERT INTO kwj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wosini waini kapu ti ri rukosini Gotri ni ri weseꞌasini wunu hawani ya wu a. ");
INSERT INTO kwj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ete wosini ya wunu sawe, “Ahaꞌa hima fi ahi, ele hima keke wungwa a ji ki a dawehenakonda. Fi ahi a dawehenakondau ti, Gotri hima ga funda bwani mendiro mwanji ti mwe naha sukwa kinani. ");
INSERT INTO kwj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mwanji mwe naha ki kunu a sawendau. Do waini uku apa ani ai a hinga. Waya Gotri kwambu ele mwaꞌambwe ni funda ete aulindano hewen ko kumbwa waini uku anandi ani ano.” ");
INSERT INTO kwj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ete wosini Gotri ni wu weseꞌani hukwa wu rasini, Olif kimba tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wosini Jisas ete ya wunu sawe, “Kunu sembe ku ani haro himako tinda ete ku hichakono. Gotri ri chengi tiki ete sawe: ‘Sipisip aulindau hima ni a yewa ri sipisip le tinda akini ino.’ ");
INSERT INTO kwj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wosini ani ai saisini a mwaseni Galili mapwa ki ani ino.” ");
INSERT INTO kwj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wowani Pita ete ya rini sawe, “E, sembe haro hima le wunu tinda ete wu hichakowa, ani apa hinde a hichako kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ete wowani Jisas ya rini sawe, “Mwe naha ki mini a sawendau. Apa niliki apwetoko ti numbo fisi gi nambwe ete dawa hi ahi ti o mi yanikonda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wowani Pita kwambu tiki ya ri ai sawe, “Mini ga ani ga funda sini ye kinani wu hambwano gisi sukwawa, o gisi okwe hi mihi ti apa hinde a yani kumbwa.” Ete wowani ele ri himache okwe tinda o mwanji hingambwa ya wu bwa. ");
INSERT INTO kwj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ete wosini michi fotiki ya wu i, o michi mwe, hi ti, Gerisemani. Wosini Jisas ele ri himache ni ya ri sawe, “Kunu ahaꞌa ki ma ku linindawa ani o biya ki Gotri ni ani uchahambwa.” ");
INSERT INTO kwj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ete wosini Pita, Jemis, Jon wunu ni rani funda ya wu i. Wu indani sembe rihi ki nomo naha ri mendikoni ri hambwawani kapwa naha ti ya i. ");
INSERT INTO kwj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wowani ya wunu ri sawe, “Sembe ahi ti nomo naha. Apa ani ha sindau. Kunu ahaꞌa ki ma ku dasini ku hambwafwaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wosini biya hinga ri ini, nuwe tiki ri raisini Gotri ni ya ri uchahambwa, Gotri rini okulawa ka sembe nomo miyafo ri mendindau amwa ti ini humbuno keke. ");
INSERT INTO kwj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wosini ka hinga ya ri sawe, “Yapai, mindombwa ele sumbu hinga tinda mi wosindau. Ai okokona ti do amwaka ai sembe we ki a mendindau ti ma rumbwe. Woro ando ai inaka ti mina, mini mi inaka tumbwa ma sirina.” ");
INSERT INTO kwj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wosini Jisas ya ri ai i. Ri ini ri heiwani ri himache le tukuyahiro. Wowani Pita ni ya ri sawe, “Saimon, mini gisi faiche hinga mi dani mi hambwafwaꞌainda hingaꞌa? ");
INSERT INTO kwj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kunu ku hambwafwaꞌaindani Gotri ni ma ku uchahambwanda, apa kunu simiyaneheino Saiten to tano keke. Mwe naha, inaka ti au saindawani talihapa tito yakinanda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wosini ri ai ini metengei naha Gotri ni ri uchahambwaro hingambwa gumwa ki Gotri ni ya ri ai uchahambwa. ");
INSERT INTO kwj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ete wosini ri ai tani ri heiwani ele ri himache ya wu ai tukuyanda. Hinde wowani, miya wuhi ti nomo naha. O keke Jisas ni saweno mwanji ti ya wu hikisa. ");
INSERT INTO kwj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wosini numbo namili ri ai isini ri ai tani ri heini ya wunu ri sawe, “Kunu ete ku himatindani ku tukuyandauꞌu? Yakito. Gisi mwe naha ti takaihiro. Apa dori Hima ri Che raꞌaini kapwa sumbu wondau hima lei tapa tenge tiki o hakonda. ");
INSERT INTO kwj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ma ku sai. Wowa ya nu i. Ani raꞌaini ele hima i tapa tenge tiki ani hano hima ri apa tahiro.” ");
INSERT INTO kwj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas o mwanji ni ete ri bwandawani, Jutas, Jisas himache fori, metengei ete ya ri ta. Hima miyafo okwe gipi lenga kumbo lenga wu toroni rini ga ya wu ta. Kale puris hima laka le, Gotri lo mwanji hambwandau hima le, ko aulindau mekupu hima laka le wunu rumbwewani ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jisas raꞌaini ele hima i tapa tenge tiki hano hima kari hambwa fo wunu hani ka hinga sawesiro, “A tumwatamwaꞌano hima mwe ri Jisas. Wowa ma rini ku toronambusini kipe ku hambwafwaꞌaini ma rini ku raꞌai.” ");
INSERT INTO kwj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ete wowani Jutas metengei Jisas tambwa ri raruni ya ri sawe, “Ondiyakandiyandau hima.” Wokoni ya rini tumwatamwaꞌa. ");
INSERT INTO kwj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ete wokowani ele wui tapa tinda ete Jisas ni ya wu toronambu. ");
INSERT INTO kwj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wowani wui nindo tiki takai naha enindau hima fori gipi rihi ri longoni puris hima lei apukolaka, ri tau ra himache forini ri yekoni wasamba ti ri yekutowani ya sika. ");
INSERT INTO kwj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ete wowani Jisas ya wunu sawe, “Gipi lenga kumbo lenga ku nangini ku ani toronambu kinani ku taroꞌo? Hima yeni hili yandau hima fo hinga ku ani hambwandauꞌu? ");
INSERT INTO kwj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gisi gisi Gotri aka laka ki a raruni ete kunu ani ondiyakandiyandaro. Wondawani ku ani toronambu nambwe. Woro Gotri chengi ki kaisiro sumbu apa amwei naha sukwakonda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wowani ele ri himache rini andosini akini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wondawani hima wapa fori nikaꞌari wamwa tumbwa injisini Jisas ni sirinani ya tanda. Ete wowani ya rini wu toronehei. ");
INSERT INTO kwj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","O hinga wu wosiwani o nikaꞌari wamwa laka ri andosini nimba nimba akini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wosini Jisas ni rani puris hima lei apukolaka ri tambwa ya wu raꞌai. Wu raꞌaisiwani puris hima laka le, ko aulindau mekupu hima laka le, Gotri lo mwanji hambwandau hima le wu tani ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ete wondawani Pita Jisas ni gumwa tokwe sirina sirina ri i ini puris hima lei apukolaka ri aka lengenumbo ti ri rarusini ele apungwandai kicha himako lenga ri linindani wunu ga hi ti ya ri waruꞌunda. ");
INSERT INTO kwj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wondawani kale puris hima laka lenga kanisol hima laka lenga wundo Jisas ni yeni sino numbo tini waki kinani hima fweleni uchani ya wu sawe, “Ma ku tani ri wosiro sumbu ti ku bwawa nu mendi.” Wowani wu tani wu bwa bwani, mina. Rini yeni sino numbo foti wu wakifuro. ");
INSERT INTO kwj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hinde wowani, mwanji wuhi ti funda i nambwe, o nimba rini wu ye kinani mwanji ti gamboni wu bwandaro. ");
INSERT INTO kwj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wondawani hima fwele etisini Jisas ni amwaka ha kinani gamboni ka hinga ya wu bwanda, ");
INSERT INTO kwj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nunjenga nu mendiwani ete ri sawero, ‘Hima tapa ki kiro Gotri aka laka doti a lendosini gisi namili iwa hima to kinda nambwe Gotri aka foti ani ai a rasaino.” ’ ");
INSERT INTO kwj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Woro o wui mwanji okwe funda i nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wowani puris hima lei apukolaka ori to etisini hima i nindo tiki ini Jisas ni ya ri sawe, “Mini mwanji fori mi bwa hingaꞌa? Dele hima to nomo mini hano mwanji wu bwandau ti, mi hambwandauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ete wowani Jisas mwanji fo rini sawe nambwe. Takisopo dimisini ya ri da. Wowani o puris hima lei apukolaka to ete ya rini sili, “Mini Kurais, Gotri funda kipe naha, ri Cheꞌe, mina?” ");
INSERT INTO kwj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wowani Jisas ya sawe, “Ani andombwa. Dori Hima ri Che kwambu naha dau Gotri tapa mama tokwe ri litisini dani ini niri wamwa tenge ki ri ai tano, o sumbu tini apa o ku heikonda.” ");
INSERT INTO kwj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wowani o hima laka to Jisas rini Gotri hinga ri naro tini ri hambwafuni o ri soꞌoisindau nikaꞌari rihi lefehesini ya ri sawe, “Nunu apa hima fweleni nu ai uchawa wu tani ri sumbu fwele wu sawe hinga, mina. Yakito. ");
INSERT INTO kwj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kunu ku mendihiro, rini Gotri ni saweholiyaro ti. Hinde ku hambwandau?” Ete wowani wunu tinda ete mwanji funda wu bwani wu mendisini ya wu sawe, “O ri kapwa sumbu keke ya sa ri ha.” ");
INSERT INTO kwj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ete wosiwani hima fwele sungwa ti rini yisindani, nikaꞌari ti miyaningisopo rihi ki wu ichakisini tapa wu lemunjini wu ye ye ya wu sawe, “Ma sawe to! Namoto mini yendau?” Wosiwani ele apungwandai kicha himako rini ra ra isini ya rini yetape. ");
INSERT INTO kwj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ete wondawani Pita ini injisiro aka laka o ki kwai ya ri da. Ri dawani puris hima lei apukolaka ri tau ra humwe foti ya ti ta. ");
INSERT INTO kwj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ti tani Pita ni ti heiwani hi ti ya ri waruꞌunda. Wowani o humwe rini misisini ya ti sawe, “Mini okwe Nasaret ko pe hima Jisas ga mi daro.” ");
INSERT INTO kwj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wowani Pita minambwe laka tumbwa ri nani ya ri sawe, “O mwanji hinga ti ani a hikisandau.” Ete wosini o aka laka michi fo tokwe ya ri i. Ri indawani apwetoko ti numbo funda ri ya ete gi. ");
INSERT INTO kwj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wowani o tau ra humwe ai tani ai rini ti heini bakitai enindau hima ele ni ya wunu ti sawe, “Dori hima, rini Jisas hima kupu fo.” ");
INSERT INTO kwj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wowani Pita minambwe laka tumbwa ri ai nani ya ri sawe, “Mina, ani a hikisandau.” Da hinga woni enindau hima ele to Pita ni ya ai wu sawe, “Mwe naha, mini Jisas hima kupu fo. Mi mwanji gale nu mendiwani mini Galili pe hima hinga.” ");
INSERT INTO kwj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wowani Pita mwanji kwambu tiki ya wunu sawe, “Funda mwe naha ki kunu a sawendau. Hinde nimba kunu a gambo kumbwa. Gotri ani heindau. Ku sawendau ori hima hi ti a hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","O hinga ri sawekowani metengei ete apwetoko ti numbo fisi ya gi. Ete wokowani Pita Jisas rini sawero mwanji o tini ya ri ai hambwa. Mwase Jisas ete rini sawero, “Apaꞌichai ai hi ti numbo namili mi yanisiwambwa apwetoko ti numbo fisi o gikonda.” Wosini Pita o tini ri ai hambwakoni sembe rihi ti kapwa naha iwani ya ri ichaka. ");
INSERT INTO kwj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wosiwani nurumbumbwa naha ele puris hima laka le, ko aulindau mekupu hima laka lenga Gotri lo mwanji hambwandau hima lenga Jutiya pe kanisol hima laka lenga funda wu wausini mwanji fo funda wu bwani ya wu mendi. Wosini Jisas ni seni kupu tiki wu injisini raꞌaini Pailat ni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wosiwani Pailat ya rini sili, “Mini Juta hima kupu lei king apukolakaꞌa?” Wowani Jisas ya sawe, “O mi bwanda to.” ");
INSERT INTO kwj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ete wowani ele puris hima laka le mwanji miyafo ki au hinga ya rini wu yenda. ");
INSERT INTO kwj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ete wondawani Pailat ya rini ai sawe, “Ma mendi, kale wui mwanji au hinga mini yendau ti, mini ga mwanji wasa mi ai sawe hingaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","O hinga ri bwawani Jisas mwanji wasache fori ri bwa nambwe. Wowani Pailat inaka walefo ya ri hambwanda. ");
INSERT INTO kwj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka Pasofa gisi laka ki Juta hima kupu leto Pailat ni uchani ka hinga wu sawendau, “Nu okokonandau kalapus hima fori ma andowa sirani sa inda.” Wowani Pailat rini andowani sirani ya ri iu. ");
INSERT INTO kwj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Woro ka gisi ki kalapus tiki daro hima fo, ri hi ti Barapas. Rindo hima fwelenga au wu saini gapiman hima fweleni wu yeni dinga ti wu wosiro. O sumbu keke wunu ga kalapus funda ri raruro. ");
INSERT INTO kwj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wosiwani ele himiyama hurahama wu tani Pailat ni uchani ya wu sawe, “Asama asama mi wosindau hinga o hingambwa kalapus hima fori apa ma haraꞌaiwa sa sira.” ");
INSERT INTO kwj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Wowani Pailat mwanji wasa ya wunu sawe, “Kui sembe ti hinde na hinga, ka Juta hima kupu lei king apukolaka ani andowa kunu tambwa i kinaniꞌi?” ");
INSERT INTO kwj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hinde wowani, rini ri hambwandaro, kale puris hima laka leto Jisas ni sembe amwaka wu ani rini kotimwo ki wu raꞌairo. ");
INSERT INTO kwj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wondawani puris hima laka leto ele himiyama hurahama leni sembe ya wu rasainda, wowa Pailat ni uchani wu sawewa Jisas mina, Barapas ni ri andowa ta kinani. ");
INSERT INTO kwj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ete wondawani Pailat ya ai wunu sawe, “Dori hima, Juta hima kupu lei king apukolaka, o hi ki ku uchandau hima ni hinde hinga apa rini a wosino?” ");
INSERT INTO kwj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wowani wu ai uchani ya wu sawe, “Me yapweke tiki ma rini ye!” ");
INSERT INTO kwj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wowani Pailat ya wunu sawe, “Hinde wowani? Bwele kapwa sumbu tini ri woro keke?” O mwanji hinga ri bwakowani gamwe tinga uchani ya wu ai sawe, “Me yapweke tiki ma rini ye!” ");
INSERT INTO kwj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ete wowani Pailat himiyama hurahama ele ni wui okokona ni ri sawesini Barapas ni ri andowani wunu tambwa ya ri i. Ri indawani Pailat sawewani Jisas ni raꞌaini tanambwasiwani au anaye hima lei tapa tenge tiki ya rini ha, me yapweke tiki rini ye kinani. ");
INSERT INTO kwj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wowani ele au anaye hima Jisas ni gapiman aka laka lengu tokwe wu raꞌaisini ele biya wui au anaye hima kupu fweleni wu uchawani ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wosini Jisas ni nikaꞌari naro foti ya rini wu soꞌoisi. Wosini kupulame foti wu ratani jangwe hinga wu balisini mwa rihi tiki king apukolaka hinga ya rini wu letisi. ");
INSERT INTO kwj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wosini tapa wuhi ti wu rasaisini ya wu sawe, “Seꞌe! Juta hima kupu lei king apukolaka!” ");
INSERT INTO kwj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ete wosini suwa kumbo hinga tiki wu torosini mwa rihi tiki ya rini wu dininda. O hinga wosini sungwa rini yisindani ri mu tiki wu ombungwesini mwa ti rini ni ya wu rakai rasukwanda. ");
INSERT INTO kwj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","O hinga rini wu saweningitengisini, o nikaꞌari naro wu dangosini ri nikaꞌari ni ai rini wu owesini me yapweke tiki rini ye kinani ya rini wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wondawani hima fori, hi ti Saimon, rini Sairini pe hima, Alekisanda hima pi Rufus yapai, rindo ka ko laka tokwe raru ki tandawani Jisas i me yapweke ti ri kicha kinani ya rini wu ekichasi. ");
INSERT INTO kwj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","O hinga wosini Jisas ni wu ra ra michi fotiki ya wu i. O michi hi ti, Golikota, mwanji mu mwe ti ka hinga: Hima Mwa Hapa. ");
INSERT INTO kwj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wosini uku fo hi ti, waini, o ki uku kwe fo gutoro o tini Jisas ni ya wu ha, ri mendino amwaka okula kinani. Ete wowani Jisas a nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ete wosini me yapweke tiki ya rini wu ye. Kini wu yesini ri nikaꞌari ni hisiwasi funda funda wu raꞌai kinani minga wu heisini ele nikaꞌari ni ya wu humwasi. ");
INSERT INTO kwj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nika sukwani 9 kilok hinga iwani, me yapweke tiki rini wu yero. ");
INSERT INTO kwj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wosini me tako fotiki Jisas ni wu kotimwondaro mwanji kairo tini me yapweke tiki kau wu yesiwani o da. Kairo mwanji ti ka hinga: Juta hima kupu lei king apukolaka. ");
INSERT INTO kwj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wosini au woni hili yandaro hima fopi fisi okwe Jisas ga funda ya wu ye. Fori ri tapa mama tokwe wu yesini, fori ri tapa usanji tokwe ya wu ye. ");
INSERT INTO kwj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ele sumbu hinga sukwaro ti, Gotri chengi tiki kaisiro ka mwanji, “Rini ni kapwa hima leni hambwandau hinga wu hambwaro,” woro o mwanji hinga amwei naha sukwaro. ");
INSERT INTO kwj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wosiwani ele hima numbo ki wu ichiꞌuchandani mwa wuhi wu raꞌichiꞌuchandani ya rini saweholiyanda, “Sa! Ka Gotri aka laka lendosini gisi namili iwa ai rasaino hima ri mindoꞌo? ");
INSERT INTO kwj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Apa minjenga ma okulani, me yapweke tiki ma sikawa nu hei to!” ");
INSERT INTO kwj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wondawani kale puris hima laka le, Gotri lo mwanji hambwandau hima le wunu okwe ka hinga ya rini wu saweningitenginda, “Ori hima hima leni ri okulandaro. Woro rinjenga apa hinde ri okula kumbwa. ");
INSERT INTO kwj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kurais, Isurel pe king apukolaka, ma sikawa nu heini pwe, sembe ti nu bwe ha.” Ete wondawani hima fisi Jisas ga me yapweke ki yero hima pi okwe Jisas ni ya fi saweholiyanda. ");
INSERT INTO kwj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wosiwani nika gondi, 12 kilok hinga, iwani hundu tani ele nuwe hinga tinda yohosini ete da dawani nika raini 3 kilok ya i. ");
INSERT INTO kwj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wowani o gisi kumbwa Jisas hapa tinga uchani ri mwanji tiki ya ri sawe, “Eloi, Eloi, lamasapakutani?” O mwanji mu mwe ka hinga, “Ai Yapai Gotri! Ai Yapai Gotri! Hinde wowani mi ani andoro?” ");
INSERT INTO kwj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ete wowani takai naha enindaro hima fwele o mwanji wu mendini ya wu sawe, “Ma mendi, kari Ilaicha ni uchandau.” ");
INSERT INTO kwj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wowani hima fori namani ini uku raundau sopu chele mwaꞌambwe foti uku fo hi ti, waini, awani fu naha, o ki rawaisini rasukwani suwa kumbo tiki opakaisini Jisas a kinani ya rini ha. Wosini ya ri sawe, “Waya, nu nikisifuni pwe, apa Ilaicha rini numwani rasikanoꞌo, mina?” ");
INSERT INTO kwj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ete wowani Jisas au laka ri gikoni ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wowani o gisi naha ki Gotri aka laka we ki dau nikaꞌari laka foti alase naha ki lefeheni tokwe tokwe ya i. ");
INSERT INTO kwj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisas ri hawani au anaye hima lei apukolaka Jisas mu tiki enindaro ti, ri haro sumbu ri heisini ya ri sawe, “Mwe naha, dori hima Gotri Che.” ");
INSERT INTO kwj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wondawani humwe fwele apahime hinga wu enindani ele sumbu ni ya wu heinda. Wui nindo tiki humwe foti Mariya Makitala, foti Mariya, Jemis hi tipa ga Josis ga fi nuwai, humwe foti Salomi. ");
INSERT INTO kwj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Imbihumbwa Jisas Galili mapwa ki dawani kale humwe namili rini wu sirinandani tau rini wu okulandaro. Wondawani humwe miyafo o hingambwa wu wondani Jisas ga Jerusalem ko ki wu rarusini wu daro. ");
INSERT INTO kwj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Icheki hinga Juta hima kupu lei himati gisi sukwakondawani apa hinga ele mwaꞌambwe hinga ya wu otokunanda. Woro ka gisi hunduya, Arimatiya pe hima fo, Josep, ya ta. Rini Jutiya pe kanisol hima laka fo, hi rihi ti kipe naha. Rini okwe Gotri kwambu hima i sembe aulindau ti do nuwe ki sirano tini nikisindau. Wosini Josep ri aki nambwe ri ini ri raruni Pailat mu tiki ya ri eti. Ri etisini Pailat ni Jisas hima tape keke ya ri sili. ");
INSERT INTO kwj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ete wowani Pailat wohambwakahambwani ya ri sawe, “Wo, kari hahiroꞌo?” Wosini au anaye hima i apukolaka ni uchawani tawani ya ri sili, “Jisas hahiroꞌo, mina?” ");
INSERT INTO kwj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ete wowani ei ri nawani Pailat Josep ni ya ri ohouna. ");
INSERT INTO kwj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wosiwani Josep nikaꞌari wamwa fo ya ri ra. Wosini Jisas hima tape dinga ri rasikani nikaꞌari wamwa o ki rini gwarosini humokuto laka ki gosiro sopu tiki ya rini eini si. Wosini Josep humokuto beiye foti dukwele dukwele ri ratani o humokuto sopu ya ri ichaki. ");
INSERT INTO kwj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wondawani Mariya Makitala ga Josis nuwai, Mariya, ga fi dani Jisas ni siro michi ni ya fi heinda. ");
INSERT INTO kwj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wosiwani himati gisi ini humbusiwani Makitala pe Mariya ga Jemis nuwai, Mariya, ga Salomi ga haro hima i dinga tini hindino kuwa kipe uku ya wu ra, Jisas tape ki wu hindi kinani. ");
INSERT INTO kwj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wosini apambwa lindanakowani, mwaseni sairo gisi Sande, matimat tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wondani wunjenga ya wu anambwa anambwanda, “Namoto nunu okulani do humokuto beiye sopu ki dau dukwelewa raino?” ");
INSERT INTO kwj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wowani miya wu misini wu heiwani humokuto o matimat sopu ki da nambwe, mina. O humokuto omwesika hima foto dukwelewani rairo. ");
INSERT INTO kwj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wosini matimat ki wu raruni wu heiwani hima wapa fori nikaꞌari hime wamwa tini soꞌoisini tapa mama tokwe ya lininda. Rini wu heikoni ete ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wowani wunu ni ya ri sawe, “Kunu apa apapana kei. Ani ani hambwanda, kunu me yapweke tiki yero Nasaret pe Jisas ni ku wakindau. Woro rini ai sairo. Ahaꞌa ki da nambwe. Ma hei, o rini eini siro michi ti! ");
INSERT INTO kwj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ku ini ri himache lenga Pita ga ma wunu ku sawe, Rini mwaseni Galili mapwa tokwe o inda. Apaꞌichai Galili mapwa ki o rini ku heikonda, injelembwa kunu ri sawero hingambwa.” ");
INSERT INTO kwj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wowani ele humwe rikirikinandani sembe wuhi ete wu apapanani hoko tokwe wu sirani wu akini namani ya wu i. Wu ini numbo tiki hima foni mwanji fo wu sawe nambwe. Hinde wowani, o wu akindaro.  ");
INSERT INTO kwj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Apambwa ya lindanakowani mwaseni sairo gisi Sande, Jisas ya ai sai. Wosini metengei Makitala pe Mariya tambwa ya sira. Injelembwa Jisas o humwe ni ri okulani tini ga daro himamwale kapwa tapaꞌangi hatachi fisi rani humbwero. ");
INSERT INTO kwj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wasiwani Mariya, Jisas ga ichiꞌuchandaro hima le sembe wuhi nomo ini wu ichakandawani, wunu tambwa ti ini ya wunu ti sawe, ");
INSERT INTO kwj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jisas rini kwambu ga dau. Rini ani heiro!” Wowani o mwanji wu mendini sembe wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wosiwani dani ini ri himache fisi ko laka fi andosini ya fi i. Fi indawani Jisas tape ba fo hinga sirasini fi mu tiki ya ri sukwa. ");
INSERT INTO kwj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wosiwani fi ai fi tani ele ri himache leni fi sawewani fini ni sembe ti wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ete wosiwanumbwa dani ini ele ri tapaꞌangi tapaꞌangi hatachi funda himache rihi a ti wu andawani, Jisas o wui mu tiki ya ri sukwa. Wosini sembe wuhi ti wu ha nambwe, emendiki naha ete daro keke kwambu tiki ya wunu ri sawe. Hinde wowani, kale himiyama hurahama ai sairo Jisas ni heisini tani sawewani sembe ti wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wowani ya ri sawe, “Do nuwe pe ele mapwa ele mapwa tokwe ma ku ini ai mwanji kipe ti ele hima ni tinda ma ku sawewa sa mendi. ");
INSERT INTO kwj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hima fori sembe ri hasiwa uku rini yasino ti, ori apa Gotri rihi nani rini raꞌaino. E, hima fori sembe ha nambwe nawa, ori apa Gotri rini sawewa humbuno. ");
INSERT INTO kwj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ani ni sembe haro hima le wui tapa ki, apa Gotri sumbu kwambu naha ri wosikonda. Hi ahi ki apa himamwale kapwa leni wu rani wu rumbweno. Wondani wu bwanda nambwe mwanji anandi hinga ni wu bwano. ");
INSERT INTO kwj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ete wondani ele kapwa hopo tapa tiki wu torondani Saya wosiro uku ti wu asini hinde apa wu ha kumbwa. Wondani tapa wuhi ti hahungondau hima ni wu torowa, ori hima kipe ai wosino.” ");
INSERT INTO kwj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Apukolaka Jisas mwanji ti o hinga wunu ri haꞌi hatasiwanimbwa Gotri hewen ko tokwe ya rini rakau. Wosiwani Gotri tapa mama tokwe ya ri lininda. ");
INSERT INTO kwj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ete wosiwani ele ri himache wu ini o ri mwanji kipe naha ele mapwa tokwe hinga tinda ya wu sawenda. Wondawani Apukolaka wunu ga tau funda wu randawani wui nindo ki sumbu kwambu naha miyafo sirandawani ele hima o tini wu heindani Jisas ri mwanji ni mwe naha ya wu hambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Apukolaka Tiofilas, mwase hima miyafo Gotri nui nindo tiki ele sumbu hinga tinda ri wosisiwani sukwaro ti, wui tapa tiki ele mwanji ni wu kai kinani wu simiyandaro. ");
INSERT INTO kwj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wunu ele hima to metengei naha ele sumbu ni wui miya naha tiki heisini Gotri mwanji hinga nunu sawero mwanji ni wu mendini wu kairo. ");
INSERT INTO kwj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Woro keke ani okwe do mwanji a kaisini mini ni a humbweꞌi ki ani okokonandau. Hinde wowani, ani gisi miyafo ele siraro sumbu mu mwe ni kipe naha ani hambwa kinani mwanji miyafo a sili sili tau kwambu a randaro. Woroti apa ele ni norukweni mini a kaisikonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","O hinga a wosiwa mini kipe naha mi hambwa ki, ka mwanji mini ni wu ondiyakandiyaro ti o mwe naha. ");
INSERT INTO kwj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jutiya ko ki Herot king apukolaka ete ri dawani o ki puris hima fori ya da, hi rihi ti Sekaraiya. Rini Apaisa ki sukwaro puris hima kupu fo. Humwe rihi ti Eron hima kupu ki taro, hi tihi ti Ilisapet. ");
INSERT INTO kwj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Fini Gotri miyaningisopo tiki kipe naha tumbwa ete fi dani ele Apukolaka i lo mwanji hinga tinda ete, e, ri chengi tiki dau ele mwanji hinga tinda ete norukweni fi sirinandaro. ");
INSERT INTO kwj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Woro fini che nambwe. Ilisapet che randa nambwe, tini cherangifarangi ete ti dau. Wowani mekupu ya fi ti. ");
INSERT INTO kwj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekaraiya rini puris hima kupu lenga puris tau ra ki ya wu ta. Wosini Sekaraiya Gotri miyaningisopo tiki puris tau hinga ya ri randa. ");
INSERT INTO kwj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wunu puris hima i sumbu tini wu sirinani wui sumbu ni wu wosini Sekaraiya ni ya wu esi, wosiwa Apukolaka i aka tipa kipe ki ri raruni kuwa kipe tandau mwaꞌambwe ri tu ki. ");
INSERT INTO kwj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wosiwani o kuwa kipe tandau mwaꞌambwe ni ri tundawani himiyama hurahama miyafo o aka hoko o ki wu wausini Gotri ni ya wu uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wondawani Apukolaka i ensel sukwani ri tundau humokuto tei tapa mama tokwe ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wosiwani ensel hima ori ni ri maꞌaini ri heini ri apapanakoni ete ya ri aki. ");
INSERT INTO kwj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ete wowani ensel hima ori ya rini sawe, “Sekaraiya, mini apa aki kei. Gotri mi uchahambwa ti ri mendiro. Mi humwe Ilisapet hurahama che foti ti rakonda. Wowa hi rihi ti ka hinga ma uchasi, Jon. ");
INSERT INTO kwj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ete wowa sembe mihi ti kipe tumbwa mi dani o mi eripendakonda. Ri tawa himiyama hurahama miyafo okwe o rini wu eripekonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Rini Apukolaka i miyaningisopo tiki hi omwesika laka ri torono. Rini waini uku tinga uku sumbwe kwambu tinga hinde apa ri a kumbwa. Ri nuwai sembe we tiki ete ri dawa, Gotri Himamwale funda rini talekondau. ");
INSERT INTO kwj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wosiwa rindo Isurel pe himiyama hurahama leni wui Apukolaka Gotri tambwa o wunu ri ratakonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Rini Ilaicha sumbu tinga ri kwambu tinga ri torosini Apukolaka ni ri mwaseni ri takondau. Wosini rindo yapai hima lei inaka ri jamekowa wui che lenga sembe wahapi wu oweno. Wondani Gotri mwanji ni sawesiyaꞌaindau himako wui inaka ti ri jamekowa sumbu kipe tini wondau himako i inaka tini wu torono. O hinga ri wo wo, rini hima lei sembe tini ri otokunasiwa Apukolaka tano tini wu nikisindano.” ");
INSERT INTO kwj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ete wowani Sekaraiya ga mwanji wasa ensel ni ya ri sawe, “Hinde hinga ani hambwano, do mi sawero mwanji mwe nahaꞌa mina? Ani mekupu a tihiro, wosiwani ai humwe okwe o hingambwa.” ");
INSERT INTO kwj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wowani ensel ga mwanji wasa ka hinga ya ai rini sawe, “Ani Gepuriyel, ani Gotri miyaningisopo tiki ani enindau. Gotri rinjenga ani humbwewani a taro ti, mwanji mini a bwani mwanji kipe naha mini a sawehambwa ki a taro. ");
INSERT INTO kwj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Woro apa ma mendi. Do mini a sawero mwanji ahi ni sembe mi ha nambwe keke, takisopo mihi ti mini o dimisikonda, wosiwa mwanji hinde apa mi bwa kumbwa, waya dele sumbu hinga sukwawambwa. Do ai mwanji mini a sawero ti, o sukwano gisi ki mwe naha sukwa sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wondawani ele himiyama hurahama Sekaraiya ni wu nikisindau le inaka miyafo ya wu hambwanda, ka bwele sumbu hinga to ka Gotri aka tipa we ki rini wosisiwani ete ri anayitindau. ");
INSERT INTO kwj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dani inumbwa ya ri sira, wosini mwanji wunu ri bwa ki mina, hinde ri bwa kumbwa. O hinga wowani ya wu hambwa, kari hima Gotri aka tipa kipe we ki sumbu anandi fo ri heiro. Sekaraiya rini takisopo ki mwanji ti hinde hinga wunu ri saweno, wofunu tapa tiki ya nimba ri ondiyakandiyanda. Takisopo rihi ti rini diminamburo. ");
INSERT INTO kwj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ete wosini Sekaraiya tau rihi humbusinimbwa, ri ko tokwe ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fi dani ikowani ri humwe Ilisapet sembe tinga ya ti da. O keke nika tapaꞌangi ba ti yanisini ya ti da. Wondani ya ti sawe, ");
INSERT INTO kwj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Apukolaka ele himiyama hurahama lei miyaningisopo tiki huruhumba ani andau keke ri heifuni do che ri ani hakondau.” ");
INSERT INTO kwj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisapet che tinga ti dawani nika tapaꞌangi hatachi funda ikowani Gotri ri ensel Gepuriyel ni ri humbwewani Galili mapwa laka ki dau ko foki ya ri i, ko mwe hi ti, Nasaret. ");
INSERT INTO kwj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ri ini hima fori hopwe kinani wu ondiyasiro humwe chongo fo tambwa ya ri i. Ori hima hi rihi ti Josep. Rini Defit hima kupu fo. O humwe chongo hi tihi ti, Mariya. ");
INSERT INTO kwj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gepuriyel tini tambwa ini ya tini ri sawe, “O bai humwe, seꞌe. Gotri ri hima keke wo sumbu nini ri hasinda. Apukolaka nini ga o da.” ");
INSERT INTO kwj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya o mwanji ti mendikoni ete apapanani ya ti hambwa, “Ka bwele fo mwanji?” ");
INSERT INTO kwj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ete wowani ensel ya tini sawe, “Mariya, apa aki kei. Gotri ri hima keke wo sumbu o nini ri hasinda. ");
INSERT INTO kwj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ma mendi, sembe ga ni dasini hurahama che fo o ni rakonda. Wosini hi ti ka hinga ma rini uchasi, Jisas. ");
INSERT INTO kwj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Rindo hima apukolaka dakondau. Wowa ka hinga o apa rini wu uchakonda, kari kaumbwa naha dau Gotri Che. Wosiwa Gotri rini ondiyasiwa ri metele Defit daro hinga king apukolaka ori dakonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Rini Jekop hima kupu leni king apukolaka hinga ete ri aulindano. Wosiwa ri aulindau kwambu ti hinde apa humbu kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ete wowani Mariya ga ensel ni ya sawe, “Ka sumbu hinde hinga apa sirano? Ani hima foriki hura a litowa.” ");
INSERT INTO kwj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wowani ensel ga mwanji wasa ka hinga ya tini ri sawe, “Gotri Himamwale kipe nini ki o takonda, wosiwa kari kaumbwa naha dau Gotri kwambu o nini gwarosikonda. Wowa ichai o che ni rasiwa, ka hinga o wu uchakonda, rini halaya naha, rini Gotri Che. ");
INSERT INTO kwj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ma mendi, ni hima kupu fo Ilisapet mekupu tihiro, woro tini okwe hurahama che ti ti sembe we tiki o ya da. Injelembwa ete wu sawendaro, tini apa che hinde ti ra kumbwa, cherangifarangi. Wosiwani sembe ga ti da dawani nika ti tapaꞌangi hatachi funda ri apa ya inda. ");
INSERT INTO kwj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gotri sumbuche fo hinde ri wosifu kumbwa, tinda ete ri wosindau.” ");
INSERT INTO kwj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ete wowani Mariya ya sawe, “Ma mendi, ani Apukolaka i tau ra humwe, o mi sawendau sumbu hinga ani ki sira kinawa sa sira.” Ete wowani ensel tini hanjaꞌaisini ya i. ");
INSERT INTO kwj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","O gisi hinga Mariya saini imaꞌini kimba ele ki dau Jutiya mapwa kipe ko laka foki ya i. ");
INSERT INTO kwj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ti ini Sakaraiya aka tiki ti raruni Ilisapet ni ya ti weseꞌa. ");
INSERT INTO kwj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilisapet, Mariya tini weseꞌaro ni ti mendikowani Ilisapet sembe we tiki dau che o ya apapana. Wosiwani Gotri Himamwale kipe ti Ilisapet sembe ki ya tini tale. ");
INSERT INTO kwj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ete wosiwani hapa tinga ti uchani ya ti sawe, “Gotri nini okulandau kwambu ti ele biya humwe ni ri handau kwambu tini dikiro. O ni sembe we tiki dau che okwe Gotri ri kwambu o rini ri hasinda. ");
INSERT INTO kwj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ani hinde na humwe hinga a dawani ai Apukolaka ri nuwai ani tambwa taro? ");
INSERT INTO kwj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma mendi, wasamba ahi ti ni ani weseꞌaro ti a mendikowani ai sembe we tiki dau che apapanani eripeꞌaripero. ");
INSERT INTO kwj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nini sembe ti mwe naha ka hinga ni hasindau, Apukolaka nini sawero hingambwa ichai o hingambwa o ri wosikonda. Worokeke ma eripeꞌaripe.” Ilisapet to o hinga ya ti sawe. ");
INSERT INTO kwj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ete wowani Mariya ya sawe, “Sembe ahi ti Apukolaka i hi tini a rasaindau. ");
INSERT INTO kwj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Himamwale ahi ti ani ratandau Gotri ni eripendau. ");
INSERT INTO kwj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ani ri tau ra humwe, woroti ani kapwa humwe, nimba rindo ani keke woro. Apa ga ichekai ga okwe himiyama hurahama le wu sawekonda, Gotri kipeheki omwesika laka ri ani haro tini. ");
INSERT INTO kwj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gotri rini kwambu naha, sumbu laka foti ri ani wosiro. Hi rihi ti halaya naha sini dau. ");
INSERT INTO kwj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hima keke wo sumbu rihi ti rini ni akindani ri tako tokwe dau hima leni ri rawakandau ti, apa ga ichekai ga o sumbu hingambwa ete ri wosino. ");
INSERT INTO kwj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ri tapa tiki kwambu chele sumbu miyafo ri wosindani inaka tiki hi wuhi numbwa nimba rasaindau hima leni ri humbwewani apumbwa apu wu ichiꞌuchandau. ");
INSERT INTO kwj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rini ele king apukolaka i kwambu tini ri rakaisini, ele hi nambwe dau hima leni ri rasaindau. ");
INSERT INTO kwj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rini iche wunu handau hima leni ri okulawani mwaꞌambwe miyafo naha wunu ki talesindau. E, ya mwaꞌambwe chele hima le wunu ri sawewani ya nimba wu inda. ");
INSERT INTO kwj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rini hima keke wo sumbu rihi ete ri hambwandani ri tau ra himache Isurel ni ri okularo. ");
INSERT INTO kwj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ka nui metele ni ete ri sawero hinga, ‘Ani Epuraham ga ele ri anitafenita lenga wunu keke ete a woni wunu ani okulandano.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya Ilisapet ga nika namili hinga ti dawanimbwa ti ko tokwe ya ti ai i. ");
INSERT INTO kwj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Che rano gisi tawani Ilisapet gwai amwaka ya ti mendi. Wokoni hurahama che ti ya ti ra. ");
INSERT INTO kwj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wosiwani o ko kipe hima lenga ti hima kupu lenga Apukolaka Ilisapet keke woni tini okularo mwanji tini wu mendini tini ga funda ya wu eripeꞌaripe. ");
INSERT INTO kwj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gisi ti tapaꞌangi ini hatachi namili tawani o che hima tape kupu wu kuto ki ya wu ta. Wosini ri yapai Sekaraiya hi tiki rini wu uchasi ki. ");
INSERT INTO kwj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ete wowani o che nuwai ya sawe, “Mina. Hi rihi ti ka hinga nu uchasino, Jon.” ");
INSERT INTO kwj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ete wowani wunu ga ya tini sawe, “Ni hima kupu lei nindo ki hi foti o hinga uchasi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wosini yapai ni tapa ba wu ondiyakandiyani ya wu sili, “Ka che ni hinde na hi tiki mi uchasi ki?” ");
INSERT INTO kwj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ete wowani ri sawewani me takoche foti wu ratawani ka hinga ya ri kai: “Hi rihi ti Jon.” Ete wokowani inaka miyafo ya wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wokowani Sekaraiya takisopo ti haunakowani tarukwe rihi oti alekusiro ti ya ai dungwa. Wowani mwanji ri bwakoni Gotri hi ti ya ri rasai. ");
INSERT INTO kwj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ete wowani o ko kipe hima ele ya wu aki. Wowani ele sumbu wosiro mwanji suwa to Jutiya mapwa kipe kimba leki dau ele ko hinga tinda ete ini ya chiki. ");
INSERT INTO kwj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wowani ele hima mwanji suwa o tini wu mendini inaka miyafo wu hambwani ya wu sawe, “Ichai kari che hinde na hima hinga ri sirano?” Hinde wowani, ka hinga wu hambwani, Apukolaka i kwambu ti rini ga o da. ");
INSERT INTO kwj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gotri Himamwale kipe ti ri yapai Sekaraiya ki talesiwani Gotri mwanji bwarakarandau hima hinga ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isurel hima kupu lei Gotri Apukolaka i hi tini ma rasaiwa nu rasai. Rindo ri tani himiyama hurahama rihi le keke woni nunu okulani ri ai ratani, ");
INSERT INTO kwj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ri tau ra himache, Defit, ri anitafenita lei nindo ki hima forini nunu ri ai ratano hima kwambu naha hinga ya rini esi. ");
INSERT INTO kwj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ka ri wosiro ti, imbihumbwa Gotri mwanji bwarakarandaro hima kipe naha rihi lei takisopo ki ri bwaro hingambwa ri wosiro. ");
INSERT INTO kwj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ka ai nunu ratano hima ri nui miho lei tapa tenge tiki nunu ri ai ratani ele sembe amwaka nunu andau hima lei tapa tenge tiki ri ai nunu ri ratano. ");
INSERT INTO kwj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ri bwasiro ti, nui metele keke ri woni wunu ri okulani imbihumbwa wunu ga injiro mwanji kipe naha rihi tini ete ri hambwandano. ");
INSERT INTO kwj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Rini mwe naha kari kau ri nasini nui metele Epuraham ga mwanji ri injiro tini ri ai hambwasini o hingambwa nunu ri wosikonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nunu omwemendindau hima lei tapa tenge tiki ai nunu ri ratasiwa, ri tau ti nu aki nambwe nu randa ki. ");
INSERT INTO kwj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wondani ele gisi nuhi hinga tinda ete sembe halaya naha tiki nu dasini ri sumbu kipe ti nu sirinani ri miyaningisopo ki ele tau rihi ya nu randakonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ai che, Jon, mini okwe kari kaumbwa naha ki dau Gotri mwanji bwarakarandau hima hinga o mini wu uchakonda. Mindo mi mwaseni mi ini Apukolaka i numbo ti mi otokunano. ");
INSERT INTO kwj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mindo ele ri himiyama hurahama leni mi ondiyakandiyawa wu hambwakonda, Gotri wui kapwa sumbu ri rani ri humbwesini ai wunu ri ratano. ");
INSERT INTO kwj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hima keke wo sumbu ti nui Gotri ki talesindau. Woroki hewen ko kipe lindana ti o nunu rumbwewa sikakonda. ");
INSERT INTO kwj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wosini ele hundu ki wu dasini kapwa sumbu wuhi keke hakondau hima le keke ri okusindakonda. Wosiwa numbo ri mekusindawa nui seke ti sumbu wahapi kumbwa nu ichiꞌucha ki.” ");
INSERT INTO kwj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dani ini o che, Jon, hima laka saini himamwale rihi ti kwambu ya i. Wosini hima da nambwe michi tiki ri dani Isurel hima kupu lei miyaningisopo tiki amwei sirano gisi ki ya ri ambwe. ");
INSERT INTO kwj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka gisi ki Sisa Okasitas, Rom pe king apukolaka, himiyama hurahama lei hi ti chengi ki kai kinani lo mwanji foti ya wunu ri ha. ");
INSERT INTO kwj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ka sumbu, Sairiniyas, Siriya mapwa ki Sisa tako tokwe gapiman apukolaka ri daro gisi ki metengei naha ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","O keke ele himiyama hurahama hinga hi wunu kai kinani wui ko minde tokwe ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep rini Defit ri anitafenita fo. O keke ri saini Galili mapwa kipe Nasaret ko laka ri hanjaꞌaisini Jutiya mapwa ki dau Defit ri ko laka ki ya ri i. O ko hi ti, Betelehem. ");
INSERT INTO kwj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Rini ga ri humwe Mariya ga ya fi i, hi fihi wu kai ki. O gisi ki Mariya sembe ga ya ti da. ");
INSERT INTO kwj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","O ko ki ete fi dawani Mariya che ra ki gwai ya ti mendi. ");
INSERT INTO kwj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wokoni hurahama che ti ya ti ra, wosini nikaꞌari tiki gwarosini bulumakau le andau topo tiki rini andosiwani ya ri tukuyanda. Hinde wowani, hima tukuyandau aka ti hima miyafo naha tukuyandawani fi tukuyano aka nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","O mapwa ki sipisip aulindau hima le niliki tiki wui sipisip wu aulindani hoko tiki ya wu da. ");
INSERT INTO kwj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ete wondawani Gotri ensel wunu tambwa ya ri ta, wowani Apukolaka ri hi laka wu dau michi tiki wunu taiyasiwani wunu o tini wu heini ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ete wokowani ensel ya wunu sawe, “Kunu apa aki kei. Ma ku mendi, ani ele himiyama hurahama tinda ete wu eripekondau mwanji kipe tini kunu a ratandau. ");
INSERT INTO kwj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Do gisi ki Defit ko ki humwe foti che raro. O che kunu ai ri ratano hima. Rini Kurais Apukolaka. ");
INSERT INTO kwj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Apa ku ini ku heino hinga o kunu a sawehambwanda: Ku ini ku heiwa che forini nikaꞌari tiki wu yembenisini bulumakau le andau topo tiki rini andosiwani o ri tukuyanda.” ");
INSERT INTO kwj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","O ensel o hinga wunu sawekowani metengei ete hewen ko kipe au anaye ensel miyafo naha sirani ori ensel ga ya wu da. Wondani Gotri hi tini ka hinga ya wu rasainda, ");
INSERT INTO kwj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kari kaumbwa naha ki dau Gotri hi tini ma rasai! Wowa do nuwe ki sembe wahapi sumbu ti Gotri eripendau hima leki sa da.” ");
INSERT INTO kwj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ele ensel hima wunu hanjaꞌaisini hewen ko tokwe wu ai rausiwani, sipisip aulindau hima le ka hinga ya wu anambwa anambwa, “Betelehem ko ki nu ini Apukolaka nunu mekuro sumbu ni nu hei.” ");
INSERT INTO kwj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wokoni metengei ya wu i. Wu ini wu heiwani Mariya hima pi Josep fi linindawani, che fihi ti bulumakau ahirahi andau topo tiki ya tukuyanda. ");
INSERT INTO kwj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wu heisinimbwa, o che i mwanji ti wu mendiro ti ya wu sawehambwa. ");
INSERT INTO kwj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ete wowani ele hima ele sipisip aulindau hima lei mwanji tini wu mendini inaka miyafo ya wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Woro Mariya ele sumbu hinga sukwasiwani ti mendiro ti ti inaka tiki ya ti hambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ele sipisip aulindau hima le, ensel wunu sawero hingambwa wu mendini wu heiro ti keke Gotri hi tini wu rasai rasai rini ni wu eripendani wui tau tokwe ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Che rasiwani dani ini gisi ti tapaꞌangi ini hatachi namili isiwani ori che hima tape kupu wu kutosini hi ti ya wu uchasi, Jisas. Nuwai rini ra nambwe sembe we ki ete ri dawani ensel o hi ya rini uchasi. ");
INSERT INTO kwj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses lo mwanji sawero hinga fichuku ga fi daro ti, uku fini yasiwani kipe fi wosini nuwai yapai o fi che fi ra ra Apukolaka ni ha ki Jerusalem ko ki ya fi raꞌai. ");
INSERT INTO kwj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Apukolaka i lo mwanji foti ka hinga kaisinda: “Ele metengei naha ku rano hurahama che mwa laka le o Apukolaka ni ma ku ha.” ");
INSERT INTO kwj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nuwai yapai okwe Apukolaka i lo mwanji ka sawero hingambwa “apwenumwa fisi hura ga noko ga, nambwe nawa, ko ki enependau apwenumwa che fisi ni” fi raꞌaini Gotri ni fi ha ki. ");
INSERT INTO kwj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka gisi ki hima fori Jerusalem ko laka ki ya ri da, hi rihi ti Simiyon. Rini Gotri ni akindau hima kipe naha. Rini Isurel hima kupu leni sembe wahapi hakondau hima rini ya ri nikisinda. Gotri Himamwale kipe Simiyon ga dau. ");
INSERT INTO kwj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gotri Himamwale ete rini sawesiro, apa amahani hinde ri ha kumbwa, mina, waya Kurais Apukolaka ri heisinimbwa. ");
INSERT INTO kwj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gotri Himamwale ri sembe ki rini yeni rasaiwani Gotri aka laka we tiki ya ri raru. Wosiwani nuwai yapai Jisas ni Gotri lo mwanji sawero hingambwa fi wosi ki ya fi rata. ");
INSERT INTO kwj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ete wowani Simiyon o che ni tapa rihi tiki ri yakosini Gotri hi tini ri rasaini ya ri sawe. ");
INSERT INTO kwj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apukolaka, apa ani mi tau ra himache ma ani haraꞌaiwa sembe wahapi ki injelembwa mi ani sawero hinga ani ha. ");
INSERT INTO kwj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ai miya naha ki mi rumbwewani taro ai nunu ratano hima ri ani heihiro. ");
INSERT INTO kwj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Himiyama hurahama le tinda ete wui miyaningisopo naha ki amwei rini mi woro. ");
INSERT INTO kwj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Rini okundau lamu hinga ele biya hima kupu ba fweleni ri taiyasino. Wosini mi Isurel hima kupu leni hi omwesika laka ri hano.” ");
INSERT INTO kwj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ete wowani Jisas nuwai yapai Simiyon sawero mwanji tini fi mendini inaka miyafo ya fi hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyon Gotri kwambu wu toro kinani wunu keke Gotri ni ri uchahambwasini o ri che nuwai Mariya ni ya ri sawe, “Ma mendi, Gotri ori che ni ri ondiyasiro ti, Isurel hima kupu miyafo rini ki wu hichakondawa wunu miyafo rini ki kwambu ki wu etino. Gotri rupwa woro awa hinga rini ni esisiwani hima miyafo kapwa mwanji rini wu bwandano. ");
INSERT INTO kwj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","O keke hima miyafo wui inakahambwa ti amwei sukwandano. Wowa hachangipi huwe foti ni apwehukutoku tiki o nini yehekukonda.” ");
INSERT INTO kwj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gotri mwanji bwarakarandau humwe foti ya da, hi tihi ti Ana. Tini Asa hima kupu fo, Fanuwel, ri che. Humwe mwe mekupu naha tihiro. Imbihumbwa hura ti lisini hurache ga asama tapaꞌangi ini hatachi fisi ya fi da. ");
INSERT INTO kwj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Dani ini ti hurache hasiwani ya nimba ti da. Apa ti asama ti 84 hinga ya ti da. Tini Gotri aka laka ti ti hanjaꞌainda nambwe, ahirahi ti hakisini Gotri ni ti uchahambwandani niliki tapwaki Gotri tau ni ete ti randau. ");
INSERT INTO kwj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","O gisi ki tini okwe wunu tambwa takai ti tani Gotri ya ri weseꞌa. Wosini Gotri Jerusalem ni okulani ai ratano sumbu tini nikisindau hima leni o che mwanji ti ya wunu ti sawe. ");
INSERT INTO kwj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ele Apukolaka lo mwanji sawero hinga tinda ete norukweni wu sirinani wu wosisini, Galili mapwa ki dau Nasaret ko wuhi tokwe ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wosiwani o che apuko saini kwambu rini tindawani hambwa kipe naha rini ki ya talenda. Gotri hima keke wo sumbu rini ga ya da. ");
INSERT INTO kwj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisas ri nuwai yapai fini ele asama hinga chikini Jerusalem ko ki, Pasofa, wu uchandau gisi laka hei ki fi indau. ");
INSERT INTO kwj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas ri asama ti tapaꞌangi tapaꞌangi hatachi fisi ri dawani ri nuwai yapai ka gisi laka sumbu ni fi sirinani Jerusalem ki ya fi rau. ");
INSERT INTO kwj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wosini o Pasofa gisi laka humbuwani ya wu ai i. Wondawani hima wapache, Jisas, rini Jerusalem ko ki ya ete ri da. Wosiwani ri nuwai yapai ri daro tini fi hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Fini ete fi hambwaro, rini himiyama hurahama fwelenga ori inda. Wosini, gisi funda laka fi ini ele fi hima kupu le, e, ele fi nau le wui nindo tiki ya rini fi wakiteki. ");
INSERT INTO kwj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Rini fi waki wakini fi hei nambwe. Wofunu Jerusalem ko laka tokwe rini waki ki ya fi ai i. ");
INSERT INTO kwj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Fi waki waki gisi namili hinga isiwanimbwa Gotri aka laka ki fi raruni fi heiwani fi che, Jisas, ondiyakandiyandau hima lei nindo tiki ri linindani wui mwanji tini ri mendindani rini ga wasa ai wunu ri silinda. ");
INSERT INTO kwj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ele ri mwanji tini mendindaro hima le ri hambwa tinga ri mwanji wasa wunu sawero tinga wu heisini ya wu apapana. ");
INSERT INTO kwj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wondawani fini rini fi heikoni ete fi apapana. Wokoni ri nuwai ya rini sawe, “Ai che, hinde wowani do sumbu hinga sini mi wosiro? Mi nuwai yapai si inaka ti funda ete nomo naha sini mi hasiwani mini si wakini si taro.” ");
INSERT INTO kwj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wowani rini ga mwanji wasa ka hinga ya fini sawe: “Hinde wowani ani ni ki wakindau? Kini ki hambwanda nambweꞌe, ani ai Yapai aka kumbwa ete a dano ti?” ");
INSERT INTO kwj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ete wowani fini ri sawero mwanji mu mwe ti fi hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wosinumbwa ri saini ri nuwai yapai ga Nasaret ko tokwe ya wu ai i. Wosini gisi gisi fi mwanji tini ete ya ri sirinanda. Wosiwani ri nuwai ele sumbu hinga sukwaro ti inaka tihi ki ya ete ti hambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas hima laka saisini hambwa rihi ti kipe naha ya sira. Wosiwani Gotri ga ele hima ga rini ni funda ete wu okokonandau. ");
INSERT INTO kwj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom pe king apukolaka, Sisa Taipiriyas, aulindau asama rihi ti 15, o gisi Pondiyas Pailat Jutiya mapwa ki gapiman apukolaka ri daro. Wondawani Herot Galili mapwa ki wui king apukolaka ri dawani ri apwai, Filip, Ituriya mapwa ga Terakonaitis mapwa ga wui king apukolaka ri dawani, Laisaniyas Apilini mapwa ki wui king apukolaka ya ri da. ");
INSERT INTO kwj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wondawani Anas hima pi Kaiyafas fini puris hima i apukolaka ya fi da. O gisi ki Sekaraiya che ri, Jon, hima da nambwe michi tiki ri dawani Gotri mwanji ti rini ki ya ta. ");
INSERT INTO kwj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wosini Jotan gara mapwa tokwe dau ele ko ki ri ini himiyama hurahama leni Gotri mwanji ti ya ri bwa, wowa kapwa sumbu wuhi gumwa wu sisiwa uku wunu yasiwa, Gotri kapwa sumbu wuhi ti ri rani ri rumbweꞌi ki. ");
INSERT INTO kwj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ri wosiro sumbu ti, ka Gotri mwanji bwarakarandaro hima ri Aisaiya ri chengi tiki kairo hingambwa ri wosiro. Aisaiya ete sawe, “Hima da nambwe michi tiki hima fori ri takisopo ki ri uchani ya ri sawe, ‘Apukolaka i numbo ma ku nambusini ri ino numbo ti ma ku norukwe. ");
INSERT INTO kwj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Apa ukunumbowa ti o wu yekichakonda, wosini ele kimba laka ga kimba cheche ga wu huwawa, o beni sikakonda. Ele numbo lehepuro ti wu dachinani ele numbo humokuto miyafo dau ti kipe wu norukwekonda. ");
INSERT INTO kwj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wowa ele hima ya wu heikonda, Gotri ai nunu ratandau tau ti.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Himiyama hurahama miyafo Jon uku wunu yasi kinani wu tawani ya wunu ri sawe, “Kunu kapwa hopo lei che. Namoto kunu ondiyakandiyawani ete ku hambwandau, ichai ka sirano Gotri sembe enge a sumbu ku akini ini ku dikino? ");
INSERT INTO kwj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kapwa sumbu kuhi ti mwe naha gumwa ku siro ti nawa, o sumbu ni chikindau sumbu kipe ma ku wosi. Kunjenga mwanji ti rasaisini ka hinga ku sawe kei, ‘Epuraham o nui atei.’ O kunu a sawenda, Gotri dele humokuto ri sawewa Epuraham anitafenita hinga sirano. ");
INSERT INTO kwj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Femwangi ti me mu tiki o da. Ele me tuko ti kipe wa nambwe nawa, ele me hinga tinda seni hi tiki rumbweꞌino.” ");
INSERT INTO kwj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","O hinga ri sawewani, ele hima ya rini wu sili, “O hinga ti nawa, hinde hinga nu wono?” ");
INSERT INTO kwj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wowani rini ga mwanji wasa ka hinga ya ri sawe: “Hima fori siyoti fisi dawa foti siyoti nambwe hima ni ma ha. E, hima fori ahirahi rini dawa rini o hingambwa sa ri wo.” ");
INSERT INTO kwj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi ya torondau hima le okwe uku wunu yasi ki wu tani ya rini wu sawe, “Ondiyakandiyandau hima, hinde hinga nu wosino?” ");
INSERT INTO kwj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wowani ya wunu ri sawe, “Takisi ya ti ku toro kinawa, gapiman apukolaka o kunu sawero hingambwa chikini ma ku toro, apa ya wuhi fwelenga gamboni ku raꞌai kei.” ");
INSERT INTO kwj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ete wowani au anaye hima fwele okwe ya rini sili, “Hinde hinga nu wosino?” Ete wowani ya wunu ri sawe, “Kunu apa hima leni nimba ku yeni ya wuhi ti ku raꞌai kei. E, hima fweleni nimba gamboni wunu kotimwo kei. Tau kuhi keke ya ku toro ki sawero hingambwa ku eripeni o ya numbwa ma ku toro.” ");
INSERT INTO kwj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ele himiyama hurahama Kurais tano tini ete wu nikisindaro ti, wunu wui inaka leki ka hinga ya wu wohambwakahambwa, “Jon ka Kurais umo, mina?” ");
INSERT INTO kwj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ete wowani Jon ga mwanji wasa ya wunu ri sawe, “Ani uku tiki kunu a yasindau. Ichai hima fori tano ti, ri kwambu ti ai kwambu ni dikindau. Ani hima kipe na numbwa ri seke ki dau su kupu ti apa a hungono. Rini Gotri Himamwale ki hi hinga okundau ki kunu ri yasino. ");
INSERT INTO kwj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Rini sawol hinga tapa rihi tiki ri torosini witi tikisapu tini ri rani rumbwesini witi mwe ti aka tiki ya ri rawarukonda. Ete wosini tikisapu usungwahanda nambwe hi tiki ri tuno.” ");
INSERT INTO kwj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon o hinga mwanji ba fwelenga ri bwani ele himiyama hurahama i sembe wuhi yeni rasaini Gotri mwanji kipe ti ya wunu ri sawe. ");
INSERT INTO kwj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","King apukolaka Herot, Jon to mwanji kwambu tiki ri apwai humwe, Herotiyas, ni ri ai hopwero sumbu tinga ele kapwa sumbu fwele ri wosiro ga rini sawewani ");
INSERT INTO kwj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","rini toroni kalapus tiki ya rini rawaru. O sumbu hinga ri woni ele kapwa sumbu ri wosindaro ni ri ai ondiyani kapwa sumbu naha fonga ya ri ai wosi. ");
INSERT INTO kwj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ele himiyama hurahama uku wunu yasisiwani wu dawani Jisas okwe uku ya rini yasi. Uku rini yasisiwani Gotri ni ri uchahambwandawani niri ti ete tukwa. ");
INSERT INTO kwj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wokowani ri heiwani Gotri Himamwale apwenumwa hinga rini tambwa ya sika. Ete wowani hewen ko tiki kau tumwa foti ya ucha, “Mini ai che. Ani mini keke a wondau. Sembe ahi ti mini ni kipe naha ani eripendau.” ");
INSERT INTO kwj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas ri asama ti 30 hinga ri dawani metengei naha ri tau ya ri rasai. Himiyama hurahama le wunu ete wu hambwandaro, rini Josep i che. Josep rini Hilai i che. ");
INSERT INTO kwj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Wowani Hilai rini Matat i che. Wowani Matat rini Lifai i che. Wowani Lifai rini Melikai che. Ete wowani Melikai rini Janai che. Wowani Janai rini Josep che. ");
INSERT INTO kwj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Wowani Josep rini Matataiyas che. Ete wowani Matataiyas rini Emos i che. Wowani Emos rini Neam che. Wowani Neam rini Esilai che. Wowani Esilai rini Nakai che. ");
INSERT INTO kwj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wowani Nakai rini Meat che. Wowani Meat rini Matataiyas i che. Ete wowani Matataiyas rini Semen i che. Wowani Semen rini Josek che. Wowani Josek rini Jota che. ");
INSERT INTO kwj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wowani Jota rini Joanan che. Wowani Joanan rini Resa che. Ete wowani Resa rini Serapapel che. Wowani Serapapel rini Sialitiyel che. Wowani Sialitiyel rini Nerai che. ");
INSERT INTO kwj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ete wowani Nerai rini Melikai che. Wowani Melikai rini Etai che. Wowani Etai rini Kosam che. Wowani kosam rini Elimatam che. Wowani Elimatam rini Er che. ");
INSERT INTO kwj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ete wowani Er rini Josuwa i che. Wowani Josuwa rini Eliesa che. Wowani Eliesa rini Jorim che. Wowani Jorim rini Matat che. Wowani Matat rini Lifai che. ");
INSERT INTO kwj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Wowani Lifai rini Simiyon che. Wowani Simiyon rini Juta che. Wowani Juta rini Josep che. Wowani Josep rini Jonam che. Wowani Jonam rini Elaiyakim che. ");
INSERT INTO kwj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ete wowani Elaiyakim rini Meliya che. Wowani Meliya rini Mena che. Wowani Mena rini Matata che. Wowani Matata rini Netan che. Wowani Netan rini Defit che. ");
INSERT INTO kwj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ete wowani Defit rini Jesi che. Wowani Jesi rini Opet che. Wowani Opet rini Boas che. Wowani Boas rini Salumon che. Wowani Salumon rini Nason che. ");
INSERT INTO kwj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ete wowani Nason rini Aminatap che. Wowani Aminatap rini Atimin che. Wowani Atimin rini Anai che. Wowani Anai rini Hesiron che. Wowani Hesiron rini Peres che. Wowani Peres rini Juta che. ");
INSERT INTO kwj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ete wowani Juta rini Jekop che. Wowani Jekop rini Aisak che. Wowani Aisak rini Epuraham che. Wowani Epuraham rini Tira i che. Wowani Tira rini Neho che. ");
INSERT INTO kwj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ete wowani Neho rini Serak che. Wowani Serak rini Reu che. Wowani Reu rini Pelek che. Wowani Pelek rini Epe che. Wowani Epe rini Sela che. ");
INSERT INTO kwj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ete wowani Sela rini Kenan che. Wowani Kenan rini Apakisat che. Wowani Apakisat rini Sem che. Wowani Sem rini Nowa che. Wowani Nowa rini Lamek che. ");
INSERT INTO kwj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ete wowani Lamek rini Metusala che. Wowani Metusala rini Inok che. Wowani Inok rini Jaret che. Wowani Jaret rini Mahalalel che. Wowani Mahalalel rini Kenan che. ");
INSERT INTO kwj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ete wowani Kenan rini Inos che. Wowani Inos rini Set che. Wowani Set rini Atam che. Ete wowani Atam rini Gotri che. ");
INSERT INTO kwj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gotri Himamwale Jisas ki raini talesiwani Jisas Jotan gara hanjaꞌaisini ya ri ai ta. Wowani Gotri Himamwale rini rumbwewani hima da nambwe michi tiki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","O hima da nambwe michi tiki ri daro gisi ti 40 hinga. Wondawani Saiten ya rini simiyanehei. Kale gisi hinga ki Jisas ahirahi a nambwe, o keke iche tinga ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wowani Saiten ya rini sawe, “E, mini Gotri che nawa, do humokuto ma sawewa bereti hinga sa sira.” ");
INSERT INTO kwj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ete wowani Jisas ga mwanji wasa ya rini sawe, “Gotri chengi ete sawero, ‘Bereti to hima lei himamwale hinde apa okula kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wowani Saiten rini rani gimba laka tiki rini rakausini metengei ete do nuwe kipe mwaꞌambwe kipe hinga tinda ete ya rini meku. ");
INSERT INTO kwj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Wosini Saiten ya rini sawe, “Ele wui kwambu hinga tinda ete, e, hi laka wu uchandau mwaꞌambwe hinga tinda ete mini numbwa ani hano. Dele mwaꞌambwe ani ni hanjaꞌaisiwani a torosindau. Woro hima forini ani ha kinawa o ani hano. ");
INSERT INTO kwj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","E, ani ni mi ombungweni mi lotu wowa, dele mwaꞌambwe hinga tinda ete mini numbwa ani hano.” ");
INSERT INTO kwj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ete wowani Jisas mwanji wasa ka hinga ya rini sawe, “Gotri chengi ete sawero: ‘Gotri mi Apukolaka numbwa ma lotu wo, wosini ri tau naha numbwa ma randa.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wowani Saiten Jisas ni ai ra ra Jerusalem ko ki ini Gotri aka laka tuwo kaumbwa naha ki rini rakauni ya ri esi. Wosini ya sawe, “E, mini Gotri che nawa ma chunani rai. ");
INSERT INTO kwj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gotri chengi ete sawero: ‘Gotri ri ensel leni sawewa wu tani o mini wu aulindakonda.’ Wosini Gotri chengi ai sawero: ");
INSERT INTO kwj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Wunu wui tapa tenge tiki mini wu siyausikonda, ete wowa humokuto fu foti hinde mini yeheku kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ete wowani Jisas mwanji wasa ya rini sawe, “Gotri mwanji ka hinga o da: ‘Mini apa Apukolaka, mi Gotri, ni simiyanehei kei.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saiten ele sumbu hinga Jisas ni ri simiyafuni rini hanjaꞌaisini ri ini gisi fotini ya ri ai nikisi. ");
INSERT INTO kwj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gotri Himamwale kwambu tiki Jisas Galili mapwa tokwe ya ri ai i. Wowani ri mwanji suwa to ele mapwa hinga tinda ete ya chiki. ");
INSERT INTO kwj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisas ele himiyama hurahama ni wui lotu wo aka tiki wunu ri ondiyakandiyandawani ele himiyama hurahama hi rihi tini ya wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Gisi fo Jisas Nasaret ko ki ya i. O ko ki kichapwache gisi ete ri dani hima laka ri sairo. Woro himati gisi foki gisi gisi ri wosindau hingambwa lotu wondau aka tiki ri rarusini Gotri mwanji ri hambwa ki ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wosiwani Gotri mwanji bwarakarandaro hima ri Aisaiya kairo chengi tini ya rini wu ha. Wowani o chengi ri bwanisini ka hinga kairo tipa tini ya ri waki: ");
INSERT INTO kwj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Apukolaka i Himamwale ti ani ki dau. Ani Gotri mwanji ti ele bwarichape hima leni a bwarakara kinani ri ani ondiyasiro. Mwanji ti ka hinga a bwa kinani ri ani rumbwewani a taro: ‘Kunu kalapus tiki ku dau hima le, kalapus ma ku hanjaꞌaisini ya ku i. Wowa kunu ele miyasa hima le, ma ku ai maꞌaikaꞌai.’ Ri ani rumbwewani a taro ti, hima i tako tokwe dasini nomo omwesika randau hima leni ani okulawa lalaunasini wu dawa ");
INSERT INTO kwj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Apukolaka hima leni ri ai ratano gisi kipe rihi tini a sawehambwa ki a taro.” ");
INSERT INTO kwj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas chengi ti ri ai benini rini takaini enindau hima ni ri ai hasini ya ri liti. Ete wowani lotu wondau aka we tiki litiro himiyama hurahama le miya wuhi ti rini numbwa ya ete wu misi. ");
INSERT INTO kwj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wondawani takisopo haunakoni ya wunu ri sawe, “Do Gotri mwanji ti, ani hambwawani ku mendiro hingambwa apa mwe naha sukwahiro.” ");
INSERT INTO kwj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ete wowani hi rihi tini wu rasaindani ele mwanji kipe ri takisopo ki ri bwandau tini inaka miyafo ya wu hambwanda. Wondani ya wu sawe, “Dori hima Josep che. Hinde wowani ka sumbu hinga ri wondau?” ");
INSERT INTO kwj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wowani mwanji ti ya wunu ri sawe, “Mwe naha, kunu apa ka mwanji yepe hinga ki ku ani sawekonda, ‘Dokita, minjenga mi hima tape ti kipe ma ai wosi. Kapaneyam ko ki mi wosiro sumbu ti nu mendiro. Woro hingambwa do mi ko minde naha ki o hingambwa ma wo.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wosini ya ri ai sawe, “Mwe naha ki kunu a sawendau: Gotri mwanji bwarakarandau hima fori ri ko minde naha ki ri bwawani himiyama hurahama le ri mwanji ni wu eripenda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mwe naha ki kunu a sawendau: Ilaicha daro gisi ki himanguto miyafo naha Isurel ko ki wu daro. O gisi ki Gotri niri ti sowani mwa ye nambwe asama ti namili, wosini nika ti tapaꞌangi ini hatachi funda. Wosiwani iche laka gisi ti ele mapwa hinga tinda ete ya ta. ");
INSERT INTO kwj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wowani Gotri Ilaicha ni rumbwewani Isurel ko kipe himanguto humwe fo tambwa ri i nambwe. Mina. Saiton mapwa ki dau Sarefat ko kipe himanguto humwe fo tambwa ri iro. ");
INSERT INTO kwj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ka Gotri mwanji bwarakarandaro hima ri Ilaisa ri daro gisi ki, Isurel ko ki sechi okwe andaro hima miyafo naha daro. Woro wui nindo tiki hima fori sechi okwe rihi ti kipe rini wosi nambwe. Mina. Siriya ko kipe hima fori Neman tombwa kipe rini wosiro.” Jisas o hinga ya ri sawe. ");
INSERT INTO kwj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wowani ele hima o lotu wondau aka we tiki wu daro ti, o mwanji ni wu mendini sembe enge ti ya wunu a. ");
INSERT INTO kwj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wokoni wu saini Jisas ni wu saweni ko hoko tokwe ya rini wu raꞌai. Ka ko wuhi o gimba naha ki kau dau. Wosini gimba tumwafu tokwe rini wu ra ra wu ratani o gimba ki rini wu rawai ki. ");
INSERT INTO kwj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wokowani wui nindo tiki ri wilini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ri ini Galili mapwa laka ki dau Kapaneyam ko ki ya ri rai. Wosini himati gisi ki wiki wiki himiyama hurahama leni ya ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wondani ri mwanji ti wu mendini ya wu apapana. Hinde wowani, mwanji rihi ti kwambu ga dawani. ");
INSERT INTO kwj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","O lotu wondau aka we tiki himamwale kapwa tinga dau hima fori ya kwai da. Rindo hapa tinga uchani ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Nasaret pe Jisas, hinde hinga nunu mi wosi kinani mi taro? Do walambe sumbu nunu mi wosi kinani mi taroꞌo? Mini ani hambwanda. Mini Gotri hima kipe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ete wowani Jisas mwanji kwambu tiki ya rini sawe, “Mini ma gainani ori hima mi hanjaꞌaisini ma i.” Ete wowani o himamwale kapwa ori hima ni yeni rumbwewani ele hima i nindo tiki ri yoꞌombosileni ri raindawani, o himamwale kapwa rini andosini ya i. Woro ori hima walambe rini i nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ete wokowani ele hima wu apapanakoni wunjenga ka hinga ya wu anambwa anambwa, “Ka bwele mwanji hinga ri bwaro? Himamwale kapwa ni ri bwaro mwanji rihi ti, kwambu ga dau, hi chele hima to bwaro mwanji hinga. O keke himamwale kapwa le ri mwanji tini wu mendini o hima ni wu hanjaꞌaisini ya akini iu.” ");
INSERT INTO kwj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wosiwani Jisas mwanji suwa tito ele mapwa ki dau ko hinga tinda ete ya chiki. ");
INSERT INTO kwj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas saini o lotu wondau aka ri hanjaꞌaisini Saimon aka tiki ri ini ya ri raru. Saimon atako tape hi omwesika tini saindawani ya ti hahungonda. Wowani Jisas tini okula kinani ya rini wu ucha. ");
INSERT INTO kwj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ete wowani ri ini ti tukuyandau topowa takai ri etisini tini saindau tape hi o tini ya ri sawe. Wowani o tape hi tini saindaro ti ya humbu. Wokowani metengei ete o humwe saini wui ahirahi ti ya ti wonda. ");
INSERT INTO kwj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nika ya raikondawani hima le wui hima kupu lei nindo ki hahungo ba fwele mendindau hima leni rini tambwa ya wu rata. Wosiwani ri tapa ti ele himiyama hurahama lei tape tenge tiki funda funda ri owesini ya wunu kipe ri ai ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wondawani himamwale kapwa le himiyama hurahama ele ni andosini funda ya wu inda. Wondani ele himamwale kapwa ka hinga wu uchani wu sawenda, “Mini Gotri Che.” Wowani mwanji kwambu tiki wunu ri saweni mwanji wu bwano ti minambwe ya wunu na. Hinde wowani, wunu wu hambwanda, rini Kurais. ");
INSERT INTO kwj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lindanawani nurumbumbwa Jisas ri saini o ko ri hanjaꞌaisini hima da nambwe michi tiki ya ri i. Wondawani ele himiyama hurahama rini waki waki rini tambwa ya wu i. Wosini wunu ri hanjaꞌaisini ri ino keke rini ni wu torosi kinani ya wu wonda. ");
INSERT INTO kwj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wowani ya wunu ri sawe, “Ani ele biya ko laka ki dau hima le okwe wunu ni Gotri aulindau kwambu ni sawero mwanji kipe ni a bwa ki ani ino. Hinde wowani, Gotri ani rumbwewani a taro ti, do tau ni ra ki a taro.” ");
INSERT INTO kwj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wosini Jutiya lei lotu wondau aka tiki Gotri mwanji ti ya wunu sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gisi gisi Genesaret fwanjuwei hapimwai o ki ri enindawani himiyama hurahama miyafo Gotri mwanji wu mendi kinani wu gina gina tani ya rini wu hawei. ");
INSERT INTO kwj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wowani fwanjuwei ki ri maꞌaini ri heiwani kanu cheche fisi hapimwai ki ya da. Fwaiꞌomwe tukwa tiki randaro hima ele opi kanu wu hanjaꞌaisini raini tukwa ti ya wu yokonda. ");
INSERT INTO kwj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ete wondawani Saimon kanu tiki ri rauni ya ri liti. Wosini Saimon ni ya ri sawe, o kanu ni ekichawa hapimwaiche dikini fwa tiki gamwe i ki. Wosiwani kanu tenge o ki ri litisini Gotri mwanji ti ya wunu ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ele mwanji wunu sawesinimbwa Saimon ni ya ri sawe, “Kanu ti fwa alase tokwe ma wowa sa i, wosini tukwa le fwa alase ki ma ku rawaisini fwaiꞌomwe ku ra.” ");
INSERT INTO kwj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wowani Saimon mwanji wasa ya rini sawe, “Apukolaka, do niliki laka ki tau kwambu naha ki nimba ete nu randaro ti, fwaiꞌomweche fo nu ra nambwe. Woro mi ani sawero mwanji keke tukwa ti fwa ki a rawai.” ");
INSERT INTO kwj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","O hinga wu wosiwani fwaiꞌomwe miyafo naha rawani wu dirimaꞌarimawani tukwa ti leterikoro naha. ");
INSERT INTO kwj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ete wosiwani wui nau le kanu fotiki daro hima le wunu okula ki wu uchawani wu tani kanu fisi tiki fwaiꞌomwe ele ya wu rasukwa. Ete wowani o kanu fisi matinani raikoro naha. ");
INSERT INTO kwj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wowani Saimon Pita o tini ri heifuni, Jisas seke mu tiki takai ri ombungwesini ya ri sawe, “Apukolaka, ma ani hanjaꞌaisini ma i! Ani kapwa sumbu a wondau hima.” ");
INSERT INTO kwj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Fwaiꞌomwe miyafo naha wu raro tini ri heini ya ri aki. Ete wowani ele hima rini ga daro okwe ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sepeti che, Jemis hima pi Jon, fini Saimon ga tau funda randau, woro fini okwe ete ya fi apapana. Wowani Jisas Saimon ni ya sawe, “Mini apa aki kei. Ichai himiyama hurahama leni o hingambwa o mi ratakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ete wowani kanu oti wu ratani wu yenjimbelesini ele mwaꞌambwe wuhi wu hanjaꞌaisini rini ni sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gisi fo Jisas ko laka foki ri dawani sechi okwe ti hima tape lenga rini aro hima fori o ko kumbwa ya ri da. Woro ori hima Jisas ni ri heikoni ri miyaningisopo mu tiki ri opulisini rini ni ri uchani ya sawe, “Apukolaka, sembe mihi au mini saiwa kipe mi ani wosino.” ");
INSERT INTO kwj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wowani Jisas tapa rihi ri dachinani rini torosini ya rini sawe, “Sembe ahi ti au ani sainda. Kipe ti ma wosi.” Wokowani metengei ete sechi okwe rihi oti ete humbu. ");
INSERT INTO kwj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wosiwani Jisas mwanji kwambu tiki ya rini sawe, “Apa mi ini hima forini sawe kei, minambwe naha. Mi ini hima tape mihi ti puris hima ni ma mekusini Moses sawero hinga anguꞌomwe mi torosini kipe mini wosiro ti keke Gotri ni ma ha. Wowa hima le wu heini sa wu hambwa, sechi okwe mihi ti humburo.” ");
INSERT INTO kwj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisas o hinga sawero ti mina, mwanji suwa rihi tito ele mapwa hinga ya inda. Wondawani hima miyafo naha ri mwanji tini wu mendi ki, e, hahungo wuhi ti kipe wunu wosi kinani ya wu tanda. ");
INSERT INTO kwj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wondawani Jisas gisi miyafo hima da nambwe michi tiki ri ini Gotri ni ya ri uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gisi foki himiyama hurahama leni ri ondiyakandiyandawani Farisi hima lenga, lo mwanji tini hambwandau hima lenga o kumbwa ya wu lininda. Wunu fwele Galili mapwa ki tawani, fwele Jutiya mapwa ki tawani, e, fwele Jerusalem ko ki taro. Jisas Apukolaka i kwambu ki ele hahungondau hima ni kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wondawani hima fwele hima forini tei tiki ya rini kichani wu rata. Ori hima talihapa ti funda ete dinga ba naha. Wosini ori hima ni aka we tiki wu rakaruni Jisas mu naha ki wu owe ki. ");
INSERT INTO kwj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Woro numbo ti wu heiwani o numbo funda ete hima miyafo naha talesindau. Wofunu aka tenge tiki wu rauni aka tenge o ki owero humokuto beiyeche fwele ya wu dungwa. Wosini o hahungo hima tei ki tukuyandaro ti sopu wu wosiro o ki rini wu rawaisini ele himiyama hurahama i nindo naha ki dau Jisas miyaningisopo mu tiki ya rini wu owe. ");
INSERT INTO kwj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wosiwani Jisas sembe ha sumbu wuhi tini ri heini ya ri sawe, “Ai nau, kapwa sumbu mihi ti a rani a rumbwehiro.” ");
INSERT INTO kwj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ete wowani lo mwanji hambwandau hima lenga Farisi hima lenga wunjenga ka hinga ya wu anambwa anambwanda, “Kari hinde na hima hinga ri dasini Gotri ni ete ri saweholiyandau? Hima minde fori apa kapwa sumbu ti hinde ri rani ri rumbwe kumbwa. O Gotri rindombwa randa tau.” ");
INSERT INTO kwj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ete wowani Jisas wui inaka ti ri hambwahiro. Wosini mwanji wasa ka hinga ya wunu ri sawe, “Hinde wowani kale sumbu hinga kui inaka ki ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Woro kapi mwanji fisi ki so mwanji ni a bwano to amwei naha, e, ete a sawewa, ‘Mi kapwa sumbu a rani a rumbwehiro,’ e, ete a sawewa, ‘Mini ma saini i’? ");
INSERT INTO kwj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma ku hambwa, Hima ri Che dori do nuwe ki hima i kapwa sumbu rani rumbwendau kwambu ri torosindau. Woro o tini kipe naha ku hambwa kinani.” Jisas o hinga ri sawesini talihapa dinga ba hima ori ni ya ri sawe, “Mini a sawenda, ma saini mi tukuya topo mi rani mi aka tokwe ma i.” ");
INSERT INTO kwj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wokowani metengei ete ele himiyama hurahama i miyaningisopo naha ki ya ri sai. Ri saini ri tukuyaro topo rihi ti ri rani Gotri hi tini ri rasaindani ri aka tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ete wowani ele hima miyafo naha ya wu apapana. Wokoni Gotri ni aki omwesika laka ki wu akindani Gotri hi tini wu rasaini ya wu sawe, “Apa sumbu ba fo naha fotini nu heihiro.” ");
INSERT INTO kwj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","O sumbu humbusiwani Jisas ri ini ri heiwani takisi ya torondau hima fori takisi ya torondau aka tiki ya ri lininda. Hi rihi ti Lifai. Wosini Jisas ya rini sawe, “Mini ma tani ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ete wowani ri saini ele mwaꞌambwe ri hanjaꞌaisini Jisas ni sirinani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Fi ini Lifai aka tiki Jisas keke ahirahi laka foti ya ri wo. Wosiwani takisi ya torondau hima fwele, e, hima ba fwele okwe tani fini ga wu linindani ahirahi ti ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wondawani Farisi hima lenga wui hima kupu fwele Gotri lo mwanji hambwandau hima fwelenga Jisas himache leni mwanji miyafo ki wunu bwani ya wu sawe, “Hinde wowani ahirahi tinga uku sumbwe tinga ele takisi ya torondau hima lenga Gotri lo mwanji hikisandau hima lenga ku andau?” ");
INSERT INTO kwj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ete wowani Jisas mwanji wasa ti ya wunu ri sawe, “Hahungo mendinda nambwe hima le dokita tambwa wu inda nambwe. Mina. Hahungo mendindau hima letombwa dokita tambwa wu indau. ");
INSERT INTO kwj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ani sumbu kipe wosindau hima leni ani uchawa wu tani sembe wu ha ki a ta nambwe. Mina. Ani kapwa sumbu wosindau hima leni ani uchawa wu tani kapwa sumbu wuhi gumwa wu sini sembe wu ha ki a taro.” ");
INSERT INTO kwj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wowani Jisas ni ka hinga ya wu sawe: “Jon himache le ahirahi ti duwe miyafo naha wu hakisini Gotri ni wu uchahambwandau. Ete wowani Farisi hima le wui himache o hingambwa. Wondawani mi himache leto ahirahi tinga uku sumbwe tinga ya wu anda.” ");
INSERT INTO kwj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wowani Jisas ya wunu sawe, “Apa kui nau fori, kunu ga dau ti, humwe ri hopwekowa ahirahi ti ku hakinoꞌo, mina? ");
INSERT INTO kwj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Woro dani ini humwe hopweno hima ori ni toroningini raꞌaino gisi tawa, o gisi kumbwa ahirahi ti ya wu hakikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wosini Jisas mwanji yepe foti okwe ka hinga ya wunu ri sawe: “Hima fori nikaꞌari ako tini kapwacheche ri lefehesini nikaꞌari simba ni oweni kapanda nambwe. E, hima fori o hinga ri wosino ti, o nikaꞌari ako naha ni walambe ri wondau, wosiwa nikaꞌari ako sumbu oti apa nikaꞌari simba ga opi hingambwa hinde sira kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","E, hima fori waini uku ako ti meme tupu ki wosiro kowe simba ki gutonda nambwe. Ori hima o hinga ri wosiwa, waini uku ako oti meme kupu simba ni matinawa lefehekoni waini uku ako oti nuwe tiki dawehenano. Wowa meme kupu simba okwe lenikino. ");
INSERT INTO kwj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hima le waini uku ako ti meme tupu ako ki wosiro kowe kumbwa sa guto. ");
INSERT INTO kwj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hima le waini uku hukwe asini rini waini uku ako tini diyahandau. Wosini ri saweu, ‘Waini uku hukwe ti kipe naha.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Himati gisi foki Jisas witi rupwa nindo tiki ri raruni ya ri inda. Wondawani ri himache le witi fwele bomo tinga ya wu kwa. Wosini tapa wuhi tiki wu singalewani mwe ti sikawani ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wondawani Farisi hima fwele o tini wu heisini ya wunu sawe, “Ka himati gisi ki minambwe nasindau sumbu ti, hinde wowani ku wosindau?” ");
INSERT INTO kwj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ete wowani Jisas mwanji wasa ya wunu sawe, “Ka Defit wosiro sumbu ti Gotri chengi ki kaisiro ti ku hambwa nambweꞌe? Ka hinga sawero: Gisi foki rini ga ri himache lenga iche wunu hawani ");
INSERT INTO kwj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Defit Gotri aka laka we tiki ri raruni Gotri ni anguꞌomwe hinga haro bereti ti ya ri ruko. Ka bereti hima leni minambwe nasindau, puris hima tombwa ano. Ete wowani Defit asini ele ri himache fweleni ya ri ha. Kunu ahaꞌa sumbu Gotri chengi ki dau ni ku hambwanda nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wosini ya ri ai wunu sawe, “Hima ri Che dori himati gisi tini ri aulindau.” ");
INSERT INTO kwj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Himati gisi foki lotu wondau aka tiki ri raruni ele himiyama hurahama ni Gotri mwanji ti ya wunu ri ondiyakandiyanda. O michi ki tapa mama tokwe walambe iro hima fori ya da. Tapa rihi mwe ti dinga ba naha. ");
INSERT INTO kwj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wondawani lo mwanji hambwandau hima lenga Farisi hima lenga Jisas ni ya wu misinda, apa himati gisi ki ka hahungo hima ni kipe ri wosikondauꞌu, mina. Wondani Jisas ni wu kotimwono numbo tini ya wu wakinda. ");
INSERT INTO kwj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wowani rini wui inaka ti ri hambwahiro. Wosini tapa dinga ba hima ori ni ya ri sawe, “Mini ma saini hima nindo naha ki eti.” Wowani ri saini ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Wosiwani Jisas ya wunu sawe, “Ani kunu a silineheikondau: Himati gisi ki sumbu kipe nu wosinoꞌo, kapwa sumbu tini nu wosino? Hima kipe wu da ki nu okulanoꞌo, hima ni walambe sumbu tini nu wosino?” ");
INSERT INTO kwj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ete wosini ele hima ni ri maꞌaikaꞌaini ri hei hei ori hima ni ya ri sawe, “Tapa mihi ti ma dachina.” Ete wowani ori hima tapa rihi ti ri dachinawani kipe naha ya ai i. ");
INSERT INTO kwj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ete wowani sembe wuhi ti enge omwesika ya wunu a. Wokoni wunjenga ya wu anambwa anambwa, “Jisas ni hinde hinga nu wosino?” ");
INSERT INTO kwj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka gisi Jisas Gotri ni ri uchahambwa kinani gimba dau mapwa tokwe ya ri i. Wosini Gotri ni ya ri uchahambwanda. Niliki hinga ete ri uchahambwandawani ete lindana. ");
INSERT INTO kwj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wowani nika sukwawani ri himache le ri uchawani ya wu ta. Wowani ele ri tapaꞌangi tapaꞌangi hatachi fisi himache rihi leni hi wuhi ‘Jisas Himache’ ya wunu ri uchasi. ");
INSERT INTO kwj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Fori Saimon, Jisas hi ba fonga ai rini uchasi, Pita. Wowani Anduru rini Saimon analongo. Wowani hima fopi Jemis hima pi Jon. Ete wowani fopi Filip hima pi Batolomiyu. ");
INSERT INTO kwj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Wowani hima fopi Matiyu hima pi Tomas. Wowani fori Jemis, Alafiyas che. Wowani Saimon hi rihi foti Selot. ");
INSERT INTO kwj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Wowani Jutas, Jemis che. Wowanumbwa Jutas Isukariyot, rini Jisas ni omwemindindau hima le tapa tenge tiki rini haro. ");
INSERT INTO kwj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wosini Jisas ri Himache lenga wu raini wu ini nuwe wataki kipe foki ya wu eti. Wosini ri heiwani ri himache hinga waꞌairo hima miyafo naha, Jutiya mapwa laka kipe hima le, Jerusalem kipe hima le, e, Soluwara takai ki dau Taiya himako ga Saiton himako ga wunu okwe o ki ya wu da. ");
INSERT INTO kwj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wu taro ti, ri mwanji ti wu mendindawa hahungo wuhi ti kipe ri wosi ki. Himiyama hurahama fwele himamwale kapwa to walambe sumbu wunu wosindaro ti, Jisas kipe ya ai wunu wosinda. ");
INSERT INTO kwj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wondawani himiyama hurahama miyafo tapa wuhi ti rini ni wu toro ki. Hinde wowani, kwambu rini ki sukwani ini ele himiyama hurahama ni kipe ri wosindawani. ");
INSERT INTO kwj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wosini Jisas ele ri himache leni miya ri hei hei ya ri sawe: “Bwarichape hima le kunu ma ku eripe. Hinde wowani, Gotri aulindau kwambu ti kuhi. ");
INSERT INTO kwj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Apa iche handau hima le, kunu ma ku eripe. Hinde wowani, ichai sembe kuhi ti o kunu talekonda. “Apa ichakandau hima le, kunu ma ku eripe. Hinde wowani, ichai o ku hingikonda. ");
INSERT INTO kwj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ichai Hima ri Che dori keke hima le kunu saweni minambwe kunu nawa ku indawa, kapwa mwanji ti kunu bwani hi kuhi tini kapwa hi rata ki ka hinga kunu wu uchawa, kunu kapwamiya, wowa kunu ma ku eripe. ");
INSERT INTO kwj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","O sumbu hinga kunu wosino gisi ki, ma ku kipeheki. Hukwa ma ku rani ku eripeꞌaripe. Hinde wowani, mwaꞌambwe wasa hewen ko tiki ku torono ti omwesika laka. Injelembwa wui metele hima Gotri mwanji bwarakarandaro hima leni o hingambwa wu wosindaro. ");
INSERT INTO kwj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Woroti, ya mwaꞌambwe chele himako, kunu fiya hambwafwaꞌai! Hinde wowani, do nuwe ki dau eripeꞌaripe sumbu tini ku torohiro. ");
INSERT INTO kwj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Apa ahirahi ti sembe tupu ki talendau hima le, kunu fiya hambwafwaꞌai! Hinde wowani, ichekai iche o ai ku hakonda. “Apa hingindau hima le, kunu fiya hambwafwaꞌai! Hinde wowani, ichai sembe amwaka kunu akoni ku ichakakonda. ");
INSERT INTO kwj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","E, ele hima hinga tinda ete hi kuhi tini wu rasaiwa, fiya hambwafwaꞌai! Hinde wowani, injelembwa wui metele hima o hingambwa nimba gamboni Gotri mwanji ni bwarakarandaro hima lei hi ni wu rasaindaro. ");
INSERT INTO kwj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Worotini apa ai mwanji ni mendindau hima, kunu, ni a sawendau: Ele kui miho hima le keke ma ku wo. Wosini ele kunu omwemendindau hima leni sumbu kipe ti ma wunu ku wosi. ");
INSERT INTO kwj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wondani saya kunu wosindau hima le keke Gotri wunu okula kinani mwanji kipe ti ma wunu ku ha. E, wondani ele kunu saweholiyandaro hima le keke Gotri ni ma ku uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","E, hima fori warama tokwe mini yetapewa, warama angi tokwe ma ai rini ha. E, hima fori heiye pe nikaꞌari tini ri leningini raꞌaiwa apa ki pe nikaꞌari ri raꞌaikowa minambwe rini na kei. ");
INSERT INTO kwj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hima fori mwaꞌambwe keke ri uchawa, o ma rini ha. E, hima fori mwaꞌambwe mihi tini ri raꞌaiwa apa ai mini ha ki mwanji kwambu tiki rini sawe kei. ");
INSERT INTO kwj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sumbu kipe ti ele hima kunu wosiwani ku okokonandau hingambwa, kunu okwe o hingambwa ma wunu wo. ");
INSERT INTO kwj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“E, kunu keke wondau hima le keke ku wowa, bwele sumbu kipe wasa tini ku torono? Kapwa sumbu wosindau hima le okwe wunu keke wondau hima le keke wu wondau. ");
INSERT INTO kwj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","E, sumbu kipe kunu wosindau hima leni sumbu kipe ku wosiwa, bwele sumbu kipe wasa tini ku torokondau? Kapwa sumbu wosindau hima le okwe o sumbu hingambwa wu wosindau. ");
INSERT INTO kwj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","E, hima ni mwaꞌambwe ku hano ti, mwaꞌambwe wasa kuhi mwe naha kunu hakonda hima numbwa ku okulawa, apa bwele sumbu wasa kipe tini ku ai torono? Kapwa sumbu wondau hima le okwe wunu kapwa sumbu wondau hima leni mwaꞌambwe handau ti, o mwaꞌambwe wasa hingambwa ya wu ai torokonda. ");
INSERT INTO kwj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Woroti kunu ele kui miho hima le keke ma ku wo. Wondani sumbu kipe tini ma wunu ku wosinda. Wosini mwaꞌambwe ti ele hima ni ma ku ha, ku hasini apa ete ku hambwa kei, mwaꞌambwe wasa kuhi sa ai kunu ha. O hinga ku wosiwa, ichai kunu o kui wasa omwesika naha ku toroni kari kaumbwa naha ki dau Gotri che hinga ku dano. Hinde wowani, rini ni weseꞌanda nambwe hima le okwe wunu keke ri wondani, kapwa hima le okwe wunu keke ri wondau. ");
INSERT INTO kwj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kunu ele hima keke ma ku wo, ka kui Yapai wunu keke ri wondau hingambwa. ");
INSERT INTO kwj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kunu apa hima leni kili kei. O hinga ku wosiwa Gotri okwe apa hinde kunu kili kumbwa. Wosini kunu apa koti mendindau hima wosindau hinga hima i kapwa sumbu ti ku kili kei. O hinga ku wosiwa Gotri okwe apa kui kapwa sumbu hinde ri kili kumbwa. Kunu ele hima i kapwa sumbu tini ma ku rani ku humbwe, wowa Gotri okwe kui kapwa sumbu ti ri rani ri humbweno. ");
INSERT INTO kwj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kunu ele hima ni mwaꞌambwe ti ma ku ha, wowa Gotri okwe mwaꞌambwe o kunu hakonda. O hinga ku wosiwa ele hima ga kunu wu hambwasini, wunu ga wasa ai wu waro warowa sukwa taleni yekehewa ratani ya ai kunu hakonda. Ele hima ni ku handau chiki hingambwa Gotri okwe o chiki hingambwa wasa o ai kunu ri hakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wosini Jisas mwanji yepe fotinga ka hinga ya wunu ri sawe, “Miyasa hima fori apa miyasa hima forini torosini numbo rini meku meku fi inoꞌo? Mina. Apa fini anaꞌape wa tiki fi raino. ");
INSERT INTO kwj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukul che ri apa ri tikisa ni hinde diki kumbwa. Ele sukul tau hinga tinda kipe ri rani ri humbusinimbwa ri tikisa hingambwa ya ri sirau. ");
INSERT INTO kwj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Hinde wowani mi hiparakambwe miya ki dau kapwa rungo cheche ni mi heindau, woroti minjenga mi hambwa nambwe, kapwa rungo laka foti mi miya tiki dau tini? ");
INSERT INTO kwj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hinde wowani mi hiparakambwe ni ka hinga mi saweno, ‘Apwai, ani mi miya ki kapwa rungo cheche foti dau ti a rani a rumbweꞌi ki,’ woroti mini mi miya tiki dau kapwa rungo laka foti mi hei nambwe? Mini nimba gambo hima! Metengei mi miya ki dau kapwa rungo laka ti ma rani humbwesini pwe. Wosini norukweni mi hei hei pwe mi hiparakambwe miya ki dau kapwa rungo cheche mi rani mi bwe humbwe. ");
INSERT INTO kwj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Me kipe ti mwe kapwa wanda nambwe. O hingambwa me bwaro ti mwe kipe tini wanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hima le mwe tini wu kilisinimbwa ya wu hambwau, ka me kapwaꞌa kipe. Hame ti mondo kupu tiki wanda nambwe. E, wate ti gama tiki wanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hima kipe ri inaka kipe rihi ki sumbu kipe naha tumbwa ete sukwandau. Wondawani kapwa hima ri inaka kapwa rihi ki kapwa sumbu tumbwa ete sukwandau. Hima i inaka ki talesindau mwaꞌambwe ti takisopo tito amwei bwandau. ");
INSERT INTO kwj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Hinde wowani ani ni ‘Apukolaka Apukolaka,’ ku ani uchandani, mwanji ahi tini ku sirinanda nambwe? ");
INSERT INTO kwj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","E, hima fori ani tambwa tani, ai mwanji tini ri mendini ri sirinano ti, ori hima hinga ni mwanji yepe tiki kunu a sawekawekonda. ");
INSERT INTO kwj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kari hima, hima forito aka kwambu naha tini kindau hinga. Metengei naha worumbo wa tini ri eisini, simeni ti o wa ki ri rawaiwani raini o nuwe ki tiki kai dau humokuto beiye laka tiki raini ya aleku. Wosinumbwa aka ti o tenge tiki ya ri ki. Wosiwani mwa yeni gara omwesika laka taleni o aka ni ekichawani o aka lendo nambwe. Hinde wowani, kari hima aka ti kwambu naha ri kiro. ");
INSERT INTO kwj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","E, ai mwanji tini mendini ri sirinanda nambwe hima ri, rini simeni ti worumbo wa tiki ri rawai nambwe nimba nuwe tenge tiki aka ri kindau hima hinga. Wosiwani mwa laka yeni gara taleni o aka ekichawani metengei ete lendoni raini walambe naha ya ete i.” ");
INSERT INTO kwj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ele mwanji hinga himiyama hurahama leni ri saweni ri humbusini Kapaneyam ko tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","O ko ki 100 au anaye hima lei wui apukolaka ya da, wondawani funda ete ri okokonandau ri tau ra himache fori ya da. Woro o tau ra himache rihi hahungo omwesika laka ri mendini kamindache naha ya ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Au anaye hima le wui apukolaka ri mendiwani Jisas o ki ya da. Wondawani Juta hima kupu lei wui mekupu hima leni ri humbwewani rini tambwa ya wu i, rini wu uchawa ri tani tau ra himache ni kipe ri wosi ki. ");
INSERT INTO kwj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wu ini Jisas tambwa wu raruni mwanji miyafo tiki ya rini wu sili, “Rini hima kipe naha, o keke ma rini okulawa ri tau ra himache kipe sa wosi. ");
INSERT INTO kwj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Rini Juta hima kupu le wunu keke ri wondau. Rinjenga nui lotu wondau aka nuhi ti ri kiro.” ");
INSERT INTO kwj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ete wowani Jisas wunu ga ya ri i. Ri ini o aka ri takaiwani au anaye hima le wui apukolaka ri nau fweleni ri rumbweni wui takisopo ki Jisas ni ka hinga ya ri sawe: “Apukolaka, ani tambwa mi tano tau kwambu sa biya da. Ani hima kipe nanumbwa mi tani ai aka ki mi raruno. ");
INSERT INTO kwj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Woro hingambwa ani okwe hima kipe nanumbwa mini tambwa a tano. O keke mwanji tini ma nimba sawewa, ai tau ra himache kipe sa wosi. ");
INSERT INTO kwj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hinde wowani, ani okwe ani aulindau hima laka i tako tokwe a dasini tau rihi a randau. Wondawani anjenga ai tako tokwe dau au anaye hima fweleni ani aulisindau. E, forini ete a sawewa, ‘Mini ma i,’ wowani ya ri iu. Wosini forini a sawewa, ‘Mini ma ta,’ wowani ya ri tau. Ai tau ra himache forini ete a sawewa, ‘Mini do tau ma ra,’ wowani ya ri rau.” ");
INSERT INTO kwj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas o mwanji ni ri mendini ori hima ni inaka miyafo ya ri hambwa. Wokoni ri jamekoni ele rini sirinani taro himiyama hurahama leni ka hinga ya ri sawe: “Kunu a sawenda, Isurel ko ki ani heiwani hima fori sembe ha sumbu ti ka hima hinga da nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wowani au anaye hima lei wui apukolaka wunu humbwewani wu taro hima le o aka tokwe wu ai ini wu heiwani o tau ra himache kipe ai rini wosiro. ");
INSERT INTO kwj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Da hinga woni Jisas ko foki ya ri i, o ko hi ti Nen. Ri himache lenga ele himiyama hurahama miyafo naha rini sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ri ini o ko ni ini injisiro lengenumbo ri takaikowani, haro hima wapa forini wu kichani ya wu rata. Nuwai ti che funda naha rito haro. Ti hurache okwe injelembwa haro. O ko laka kipe himiyama hurahama le o himanguto ga ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Apukolaka o himanguto ni heini, sembe rihi ti tini keke woni o humwe ni ya ri sawe, “Apa ichaka kei.” ");
INSERT INTO kwj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wosini takai ri ini haro hima tukuyandau tei tini tapa rihi ki ya toro. Wosiwani rini kicharo hima ele ya wu eti. Wowani Jisas ya sawe, “Hima wapache, o mini a sawenda, ma sai.” ");
INSERT INTO kwj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ete wowani haro hima wapa ori saini litisini mwanji ti ya ri bwanda. Wosiwani Jisas rini sawewani ri nuwai tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wowani ele himiyama hurahama wu akikoni Gotri hi tini wu rasaindani ya wu sawe, “Gotri mwanji bwarakarandau hima laka fori nui nindo tiki sukwahiro.” Wosinumbwa ya wu sawe, “Gotri ri himiyama hurahama leni ri okula ki tahiro.” ");
INSERT INTO kwj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wosiwani do Jisas mwanji ti Jutiya mapwa laka ki, e, ele mapwa ele mapwa hinga ki ya ichiꞌucha. ");
INSERT INTO kwj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon himache le ele sumbu hinga tinda ete ya rini sawe. ");
INSERT INTO kwj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wowani Jon ri himache fisi ni ri uchawani fi tawani Apukolaka ni mwanji fi sawe ki fini ya ri humbwe. Mwanji rihi mwe ti ka hinga: “Ka ta ki naro hima mwe ri mindoꞌo, forini nu ai nikisino?” ");
INSERT INTO kwj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wosiwani opi hima fini Jisas tambwa fi raruni ya fi sawe, “Uku yasindau hima ri Jon ka mwanji hinga ni mini ri sili ki sini ri humbwewani si taro, ‘Ka ta ki naro hima mwe ri mindoꞌo, hima forini nu ai nikisino?” ’ ");
INSERT INTO kwj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka gisi ki Jisas himiyama hurahama lei hahungo ti kipe wunu ri wosindani, himamwale kapwa wunu ki dawani ri sawewani sirani akini indawani miyasa hima le kipe ri wosisiwani wu ai maꞌaikaꞌaindaro. ");
INSERT INTO kwj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wowani Jisas mwanji wasa ka hinga ya fini ri sawe, “Ma ki ini Jon ni ele sumbu ki heiro ti, e, ele mwanji ki mendiro ti, ma ki sawe. Miyasa hima le ai wu maꞌaikaꞌaindawani seke kapwa hima le ai wu ichiꞌuchanda. Sechi okwe aro hima le kipe ai wu wosindawani, wasamba kitiro hima le mwanji ti ai wu mendinda. Wondawani haro hima le ai wu saindawani, bwarichape hima Gotri mwanji ti ya wu mendinda. ");
INSERT INTO kwj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","E, hima fwele ai mwanji tini wu mendini inaka bongo wu hambwa nambwe nawa, wunu sa eripe.” ");
INSERT INTO kwj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon mwanji ni rataro hima opi fi isiwani, Jisas ele himiyama hurahama leni Jon ni ya wunu ri sawe, “Ka hima da nambwe michi tiki bwele mwaꞌambwe tini hei ki ku iro? Ausuwa saini suwa fotini raꞌaiꞌichiꞌuchandau tini hei ki ku iroꞌo? Mina. ");
INSERT INTO kwj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bwele mwaꞌambwe tini hei ki ku iro? Nikaꞌari kipe naha ni soꞌoisindau hima ni hei ki ku iroꞌo? Mina. Nikaꞌari kipe naha ti kiheiye soꞌoindani mwaꞌambwe kipe le keke ya humbwendau hima le wunu king apukolaka i aka tukumbwa wu dau. ");
INSERT INTO kwj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wo kunu bwele tini hei ki ku iro? Gotri mwanji bwarakarandau hima forini hei ki ku iroꞌo? Ei, mwe naha ki kunu a sawendau, rini Gotri mwanji bwarakarandau hima, woro rini ele biya Gotri mwanji bwarakarandau hima fweleni ri dikiro. ");
INSERT INTO kwj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ori hima ni Gotri chengi ti ete sawero. ‘Ma mendi, ai mwanji tini bwa ki ino hima ri rini a humbwewa o mini mwaseni ikonda. Wosini rindo mi numbo ori nambuno.’ ");
INSERT INTO kwj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kunu a sawenda: Jon do nuwe ki sukwaro ele hima hinga ni ri dikisindau. Woro, ani ni sembe hasini Gotri kwambu tororo kapwacheche naha forito Jon ni ri dikisindau.” ");
INSERT INTO kwj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","O Jisas mwanji ni ele himiyama hurahama hinga tinda ete, e, takisi ya torondau hima le okwe, ya wu mendi. Wunu imbihumbwa Jon uku wunu yasisiwani ka hinga ya wu hambwa, Gotri wunu mekuro numbo ti kipe naha. ");
INSERT INTO kwj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ete wowani Farisi hima ga lo mwanji hambwandau hima lenga wunu Jon tapa tiki uku wunu yasi nambwe. O keke Gotri numbo kipe naha ti wunu mekuro tini gumwa wu siro. ");
INSERT INTO kwj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas ya wunu sawe, “Bwele mwanji yepe hinga tiki do gisi kipe himiyama hurahama leni a saweno? Wunu hinde na hima hinga? ");
INSERT INTO kwj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wunu apweli tiki linindau kichapwache hinga. Wunu fwele wunu fweleni ka hinga wu uchandau: ‘Nunu kunu keke hambangini ti nu wuichindau ti, kunu hukwa ku rani seke ku yitinda nambwe. E, nunu hima keke ichakandau hukwa tini nu randau ti, kunu ku ichakanda nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uku yasindau hima ri Jon tani ahirahi tinga uku sumbwe tinga a nambwe. Wowani ya ku sawe, ‘Himamwale kapwa rini ga dau.’ ");
INSERT INTO kwj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Apa Hima ri Che dori tani ahirahi tinga uku sumbwe tinga ri awani ku sawe, ‘Ma hei, rini ahirahi ti fe hinga ri andani, uku sumbwe mama ri andau. Rini takisi ya torondau hima lenga Gotri lo mwanji hikisandau hima lenga wui nau.’ O hinga ku sawendau. ");
INSERT INTO kwj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gotri hambwa tini wu tororo hima le, wundombwa norukweni wu kilindau, Gotri hambwa ti mwe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi hima fori Jisas ga ahirahi fi a kinani ya ri ucha. Wowani Jisas ini ori Farisi hima ga fi litisini ahirahi ti ya fi anda. ");
INSERT INTO kwj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wondawani kapwa sumbu wondau humwe foti o ko laka ki ti dau ti, mwanji suwa foti ti mendiwani Jisas tani Farisi hima foringa ri aka tiki ahirahi ti ya fi anda. Wowani o humwe weli ti humokuto tiki wosiro botoli kipe naha tiki gutosiro tini ti nangini ya ti ta. ");
INSERT INTO kwj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wosini Jisas gumwa tiki seke mu tiki ti etisini ti ichakanda. Wondani ti meriꞌuku tihi ti dawehenani sikani Jisas seke ki apesiwani ti mwa nimbi ki ya ti hindinda. Wosini Jisas seke tiki ti tumwatamwaꞌasini weli ti ya ti hindinda. ");
INSERT INTO kwj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wondawani Jisas ni uchawani taro Farisi hima ori ka sumbu ni ri heini ka hinga ya ri hambwa: “E, rini Gotri mwanji bwarakarandau hima naha napo, o bai humwe rini wosindau sumbu ti, e, ti sumbu ti okwe ri hambwano. Tini kapwa sumbu wondau humwe.” ");
INSERT INTO kwj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wowani Jisas ori hima i inaka ti ri hambwani ya ri sawe, “Saimon, ani mwanji foti mini ni a sawekondau.” Wowani Saimon ya ri sawe, “Ondiyakandiyandau hima, mi mwanji ma ani sawe to.” ");
INSERT INTO kwj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ete wowani Jisas ya rini sawe, “Hima fisi hima foriki ya ti nimba rini ki fi rataro, wosini ichakai fi ai hakonda. Hima fori ya ti 5,000 hinga ri torowani, hima fori ya ti 500 kina hinga ya ri toro. ");
INSERT INTO kwj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Woro fini o ya wasa fi ai ha ki mina, fini ya nambwe. Wosiwani ori hima ya rihi nimba ya fini ha. Woro fini hinde na hima forito rini keke ete ri wondano?” ");
INSERT INTO kwj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wowani Saimon mwanji wasa ka hinga ya ri sawe: “Ani ani hambwawani kari hima to, ya omwesika naha nimba ri rataro ti, o ya ri ai hano ti minambwe rini naro.” Ete wowani Jisas ya rini sawe, “Kipe naha mi hambwaro.” ");
INSERT INTO kwj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wosini ri jamekoni mapwa o humwe ni ri sisini, Saimon ni ya ri sawe, “Ahaꞌa humwe mi heiroꞌo? Mi aka we tiki a sirawani uku mi ani hawani seke ahi ti a yoko nambwe. Woro do humwe to meriꞌuku tihi tiki seke ahi ti ti yokosini gisaha kinani ti mwa nimbi tiki ya ti hindi. ");
INSERT INTO kwj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mini ani ni mi tumwatamwaꞌa nambwe. Woro a tani mi aka tiki a sirawani do humwe ai seke tini ete ya tumwatamwaꞌanda. ");
INSERT INTO kwj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mini ai mwa nimbi ti weli mi hindi nambwe. Woro do humwe ai seke tiki kuwa kipe weli ti hindiro. ");
INSERT INTO kwj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Woroti ya mini a sawekonda: Kapwa sumbu miyafo ti woro ti, ele kapwa sumbu a rani a rumbwero, o keke ani keke omwesika ti wondau. E, hima fori kapwa sumbu ti kapwacheche hinga ri woro hinga ri hambwawani ri kapwa sumbu a rani a rumbweno ti, rini kapwacheche ani keke ri wondau.” ");
INSERT INTO kwj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wosini Jisas o humwe ni ya ri sawe, “Ni kapwa sumbu a rani a rumbwehiro.” ");
INSERT INTO kwj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wowani ele hima rini ga funda wu linindaro ti, rini ni wu heini wunjenga wui nindo tiki ka hinga ya wu anambwa anambwa: “Dori hinde na hima hinga ri dasini ka kapwa sumbu ri rani ri rumbwendau?” ");
INSERT INTO kwj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wowani Jisas o humwe ni ya sawe, “Sembe ni haro ti keke kipe nini wosiro. Ma ai isini sembe nihi ti wahapisini ya ma da.” ");
INSERT INTO kwj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Da hinga woni Jisas ele ko laka ga ele ko cheche ga funda funda ri ini Gotri aulindau kwambu tinga ri mwanji kipe tinga ele himiyama hurahama ni ya wunu ri bwanda. Wondawani ri tapaꞌangi tapaꞌangi hatachi fisi Himache rihi le rini ga ya wu inda. ");
INSERT INTO kwj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ete wondawani Jisas imbihumbwa wunu ga daro himamwale kapwa ri rani ri humbwewani hahungo wuhi okwe kipe wunu ri wosindaro humwe le rini ga ya wu inda. Humwe fo Mariya hi tihi foti ka hinga o tini wu uchanda, Mariya Makitala. Injelembwa Jisas tini ki tapaꞌangi ini hatachi fisi himamwale kapwa ri rani ri humbwero. ");
INSERT INTO kwj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, Herot aka aulindau hima fori hi ti Chusa, ri humwe, e, Susana, wosini humwe fwele okwe rini ga ya wu i. Kale humwe wunu Jisas ga ri himache lenga wui tau wunu okula kinani wui ya mwaꞌambwe tini wu humbwendau. ");
INSERT INTO kwj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hima miyafo ele ko ele ko ki wu tani Jisas mu tiki ya wu wau. Wosiwani mwanji yepe foti ka hinga ya wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hima fori ini tau tiki ahirahi wapa ti ri yesinani ya ri humbwe. Ri humbwewani ahirahi wapa fwele numbo tiki ya sika. Wosiwani hima le yitini singalendawani apwe le sikani ya anda. ");
INSERT INTO kwj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wowani ahirahi wapa fwele nuwe miyafo da nambwe humokuto tenge tiki ya sika. Wosini fwamwe le sukwaro ti, nuwe ti uku nambwe keke nika yekowani hopweneni ya rikaꞌai. ");
INSERT INTO kwj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wowani ahirahi wapa fwele lame chele ki nindo tiki ya sika. Wosiwani lame chele ki oti okwe saini fwamwe sukwaro ti ya yekicha. ");
INSERT INTO kwj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wowani ahirahi wapa fwele nuwe kipe tiki rairo ti fwamwe le dingini omwesika saini mu foki tuko miyafo naha 100 hinga ya wa.” Jisas o hinga sawesini, hapa tinga ka hinga ri uchani ya ri sawe, “Hima wasamba chele ti saiyayanasini do mwanji sa ri mendi.” ");
INSERT INTO kwj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wosiwani ri himache le o mwanji yepe mu mwe wu hambwa ki ya rini wu sili. ");
INSERT INTO kwj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wowani ya ri sawe, “Gotri aulindau kwambu ti mwanji mu yanisiro ti rinjenga o kunu ri mekusiro. Woro ele biya himiyama hurahama leto wunu mwanji yepe numbwa wu mendindau. O keke miya ti wu maꞌaikaꞌaindau ti, mwaꞌambwe fotini wu heinda nambwe. Wasamba wuhi ti mwanji wu mendindau ti, mwanji mu tini wu hambwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Woro o mwanji yepe ti mwanji mu mwe ti ka hinga: Ka ahirahi wapa o Gotri mwanji ni sawero. ");
INSERT INTO kwj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ahirahi wapa fwele numbo tiki sikaro ti, o kale hima hinga ni sawero. Wunu Gotri mwanji mendisiwani Saiten tani o Gotri mwanji wui sembe tiki daro tini ai rani ri rumbwe. Rini ete hambwandau, ‘Foki sembe wu hasiwa Gotri ai wunu raꞌaino.’ ");
INSERT INTO kwj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ahirahi wapa fwele nuwe miyafo da nambwe humokuto tenge tiki sikaro ti, o kale hima hinga ni sawero. Wunu Gotri mwanji mendini torosini o tini wu eripendau. Woro nene ti nuwe tiki raini ambomuna nambwe. Wunu sembe ti gisi faiche kumbwa wu hasiwani simiyanehei sumbu foti wunu wosikowani ya wu ai iu. ");
INSERT INTO kwj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wowani ahirahi wapa fwele lame chele ki nindo tiki rairo ti o ka hinga, hima le Gotri mwanji wu mendisini wu ikowani, ele sembe nomo, ele ya mwaꞌambwe, e, dele nuwe kipe eripeꞌaripe sumbu leto ai wunu yekichandau. Wosiwani wunu ahirahi tuko wandau hinga wu wanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wowani kale ahirahi wapa fwele nuwe kipe tiki sikaro ti o ka hinga, hima le Gotri mwanji wu mendini inaka tiki wu toronambundau. Sembe wuhi tinga sumbu wuhi tinga kipe naha, wosini kwambu naha ki wu etisini wu randawani ahirahi tuko miyafo wandau hinga ya wu wanda. ");
INSERT INTO kwj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hima le lamu ti okusini hungwe tako ki, e, tei tako ki wu owenda nambwe. Mina. Wunu lamu okusini tei tenge tiki wu lisindau. Wowa hima le aka we tokwe wu sirakoni o lamu okundau ni wu heino. ");
INSERT INTO kwj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ele yanisini dau mwaꞌambwe ichai amwei sirano. Ele mwaꞌambwe hima yanisindau ti ichai amwei sirawa hima le o tini hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kunu hambwafwaꞌaisini mwanji ti norukweni ku mendi. E, hima fori sumbu kipe fo rini ki dawa, Gotri miyafo naha ai rini hano. E, hima fori sumbu kipe fo rini ga da nambwe, woro ete ri hambwandawa sumbuche foti rini ga dau, woro o sumbuche rihi okwe Gotri rani rumbweno.” ");
INSERT INTO kwj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ka gisi ki Jisas nuwai ga ri hipache lenga rini tambwa ya wu ta. Wu tani wu heiwani himiyama hurahama miyafo naha wausiwani rini tambwa takaini wu i ki, mina. ");
INSERT INTO kwj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wowani hima fwele heisini ya rini sawe, “Mi nuwai ga mi hipache lenga mini hei kinani wu tani hoko tiki kale kwai eninda.” ");
INSERT INTO kwj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ete wowani rini ga mwanji wasa ka hinga ya wunu ri sawe, “Himiyama hurahama le Gotri mwanji wu mendini wu sirinano ti, wunu ai nuwai, wunu ai hiparakambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gisi foki Jisas ga ri himache lenga kanu foki ya wu rau. Wosini ya wunu ri sawe, “Ma kari kwai fwanjuwei angi tokwe nu i.” Wosini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kanu oti indawani Jisas rini ya ri tukuyanda. Wondawani ausuwa laka foti o fwanjuwei ki saini fwa o tini yembekinawani tani kanu we tiki raini talekondawani o tini heini ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wokoni wu ini Jisas ni wu yetelesini ya wu sawe, “Apukolaka, Apukolaka, uku sumbwe nu ani nu hakondau naha.” Wowani ri saini ausuwa o tinga fwa yembekinandaro tinga mwanji kwambu ki ya sawe. Ete wowani ausuwa o tinga fwa yembekinandaro tinga humbuwani, fwa oti ai yembekina nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wosini ya wunu ri sawe, “Sembe ku haro ti, soki dau?” Ete wowani wu akindani inaka miyafo ya wu hambwa. Wondani wunjenga ka hinga ya wu anambwa anambwa, “Dori hinde na hima hinga ri dasini ka ausuwa laka ga ka fwa yembekinandaro tinga ri sawewani ri mwanji fi mendini fi humburo.” ");
INSERT INTO kwj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wosinumbwa wu ini Gekesa lei mapwa tokwe wu ini ya wu raru. Ka mapwa o Galili fwanjuwei angi tokwe dau. ");
INSERT INTO kwj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas o kanu ki ri sikasini hapimwai tokwe ri isiwani o ko kipe hima fori rini tambwa ya ri ta. Himamwale kapwa miyafo ori hima ga dau. Asama miyafo rini nikaꞌari ti ri inji nambwe. Rini aka forukumbwa ri tukuya nambwe. Mina. Rini matimat kumbwa ete ri dau. ");
INSERT INTO kwj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Woro ori hima Jisas ni ri heini ata ri gini nuwe ki ri raini ri seke mu naha ki ri opulisini ata ti hapa tinga ka hinga ya ri ucha, “Jisas, kari kaumbwa naha ki dau Gotri Che, bwele sumbu hinga tini mi ani wosikondau? Seꞌe, mini apa nomo ani ha kei.” ");
INSERT INTO kwj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O mwanji hinga sawero ti, Jisas o himamwale kapwa ori hima ni ri hanjaꞌai ki mwanji kwambu ki ri sawewani himamwale kapwa o to ya ucha. Gisi gisi o himamwale kapwa to ori hima ni ete ri toronambusindau. Hima le gisi gisi rini heini rini torosini seni ti seke tapa tiki rini injisiwani ele seni rini injisiro ti ri lekutoni ri rumbwendau. Wosini o himamwale kapwa rini rani hima da nambwe michi tiki rini raꞌaindau. ");
INSERT INTO kwj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wowani Jisas ya rini sawe, “Hi mihi ti namo?” Ete wowani ya ri sawe, “Hi ahi Lekiyon.” Hinde wowani, himamwale kapwa miyafo naha rini ga dau. ");
INSERT INTO kwj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wowani ele himamwale kapwa mwanji miyafo ki Jisas ni ya wu sili, “Apa kaimbwa naha soko ambwenda nambwe wa tiki nunu rawai kei!” ");
INSERT INTO kwj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wondawani fe miyafo naha kimba cheche ki takai hinga wu enindani ya wu uyanda. Ete wowani himamwale kapwa mwanji miyafo ki Jisas ni ka hinga ya wu sili, “Ma nunu humbwewa kale kau fe leki nu ini nu raru!” Ete wowani Jisas wunu ohounawani ele fe ki wu raru ki ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ele himamwale kapwa ori hima ni wu hanjaꞌaisini wu ini ele fe ki ya wu raru. Ete wowani ele fe anasawe hapa tinga wu namani wu ini fwa dau kapwa michi naha foki ya wu rai. Wu raini wu yoꞌosikitani uku sumbwe wu ani ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ete wowani fe aulindaro hima le o tini wu heikoni ya wu akini i. Wu ini ele sumbu wu heiro tini o ko kipe himiyama hurahama lenga ele ko cheche ki dau hima lenga ya wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wowani ele himiyama hurahama o sumbu ni wu hei kinani Jisas tambwa wu tani ori hima ni ya wu hei. Ele himamwale kapwa rini ga daro rini hanjaꞌaisiwani ri dasini inaka ri hambwani nikaꞌari ti ri injisini Jisas seke mu tiki takaini ya ri lininda. Ete wowani ele himiyama hurahama o sumbu ni wu heini ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wondawani ele sumbu ni heiro hima leto injelembwa himamwale kapwa rini ga daro ti apa kipe naha ri ai iro sumbu mwanji mu mwe ti ya wunu sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gekesa mapwa ki dau hima le Jisas ni ya wu sawe, “Mini nunu ma hanjaꞌaisini ya ma i.” Wunu akindani o hinga ya wu sawe. Ete wowani Jisas kanu tiki ri rauni ri litisini ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wokoni ele himamwale kapwa rini hanjaꞌaisini iro hima ori Jisas ni ka hinga mwanji miyafo ki ya ri sili, “Ani mini ga funda si i ki.” Wowani Jisas ri ko tokwe rini humbwewani ri ikowani ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mi ko tokwe ma ai ini Gotri ele sumbu laka mini wosiro tini ma wunu sawekawe.” Ete wowani ori hima ini o ri ko ki dau himiyama hurahama ele ni Jisas rini wosiro sumbu laka tini ya wunu ri sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas ri ai tawani ele himiyama hurahama ya wu eripe. Wunu rini ni wu nikisindaro. ");
INSERT INTO kwj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wondawani hima fori ya ta, hi rihi ti Jairas. Rini lotu wondau aka tini aulindau hima. Ri tani Jisas seke mu tiki ri ombungwesini inaka funda ri owesini ka hinga ya ri sili, “Mini ai aka tokwe ma ta.” ");
INSERT INTO kwj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Rini che rihi funda naha, himiyama che tombwa, asama tihi ti tapaꞌangi tapaꞌangi hatachi fisi. Woro kamindache naha ya ti hakondau. Ete wowani Jisas indawani himiyama hurahama miyafo naha rini wu sirinani wu tani rini wu haweini ya wu anatakai anatakainda. ");
INSERT INTO kwj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wondawani humwe foti o ki ya ti da. Asama tapaꞌangi tapaꞌangi hatachi fisi akawe ti dawani hima fori ka ti hahungo okulawani kipe tini wosi nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Woro o humbwe to Jisas gumwa tiki takai ti tani ti tapa ti ri nikaꞌari tumwafu tiki ya ti toro. O hinga ti wosiwani metengei ete o ti hahungo ete humbukoni kipe ya ti wosi. ");
INSERT INTO kwj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wowani Jisas ya sawe, “Namoto tapa tiki ani tororo?” Ete wowani wunu tinda ete ya wu sawe, “Ani mina. Ani mina.” Ete wowani Pita ya sawe, “Apukolaka, himiyama hurahama miyafo naha mini takai takai tani wu anangina ananginanda.” ");
INSERT INTO kwj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wowani Jisas ya sawe, “Fori tapa ti ani ni tororo. Hinde wowani, a mendiwani kwambu ahi fwele ani hanjaꞌaihiro.” ");
INSERT INTO kwj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wowani o humwe ya ti hambwa, tini apa rini ni hinde ti yani kumbwa. O keke ti rikirikinani ti tani ri seke mu tiki ti ombungwesini ele himiyama hurahama lei miyaningisopo tiki tapa tihi ti Jisas ni tororo sumbu mu mwe tini ya ti sawekawe. Wosini ya ti sawe, “Hahungo ahi ti metengei ete humburo.” ");
INSERT INTO kwj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wowani Jisas ya tini sawe, “Ai che, sembe nihi ti ti ani haro ti keke kipe o ai nini wosiro. Ma isini sembe nihi wahapisini ya ma da.” ");
INSERT INTO kwj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mwanji ti ete ri bwandawani ka hima laka aka ki dau hima fori tani o hima laka ni ya ri sawe, “Che mihi haro. Apa tau kwambu ti ondiyakandiyandau hima ni ha kei.” ");
INSERT INTO kwj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wowani Jisas o mwanji ni ri mendini mwanji wasa ka hinga ya rini sawe, “Mini apa aki kei. Sembe mihi ti ma ete handa. Wondawa che mihi ti kipe tini wosino.” ");
INSERT INTO kwj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ete wowani Jisas o mekupu hima ri aka tokwe ri ini ri rarukoni ri sawewani ele himiyama hurahama rini ga wu raru nambwe. Mina. Pita, Jon, Jemis, e, o che ti nuwai yapai wundombwa rini ga ya wu raru. ");
INSERT INTO kwj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wondawani ele himiyama hurahama wunu o che keke ya wu ichakanda. Ete wondawani Jisas ya wunu sawe, “Kunu ichaka kei, do humweche ha nambwe nimba tukuyandau.” ");
INSERT INTO kwj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ete wowani ri mwanji keke ya wu hingi. Wunu ete wu hambwanda, o hahiro. ");
INSERT INTO kwj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisas o himiyama che i tapa ki ri torosini ya sawe, “Ai che, ma sai.” ");
INSERT INTO kwj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ete wowani himamwale tihi ti ai tani raruwani metengei ete ya ti sai. Wowani Jisas ya wunu sawe, “Ahirahi fwele ma tini ku hawa sa ti a.” ");
INSERT INTO kwj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wowani o che ti nuwai yapai fini ete fi apapana. Ete wowani Jisas mwanji kwambu tiki ya fini sawe, “Kini apa hima forini do sumbu ki sawe kei.” ");
INSERT INTO kwj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas ri tapaꞌangi tapaꞌangi hatachi fisi Himache rihi leni ri uchawani wu tawani himamwale kapwa wu rani wu humbweno kwambu ti, e, hahungo wu sawewa humbuno kwambu ti ya wunu ha. ");
INSERT INTO kwj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wosini Gotri aulindau kwambu ti mwanji ti wu bwani hahungo hima leni kipe wu wosi kinani ya wunu ri humbwe. ");
INSERT INTO kwj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wu ikowani ya wunu ri sawe, “Ku ikoni apa ku rani ku raꞌichiꞌuchandau mwaꞌambwe tinga ku raꞌai kei. Apa diyandau kumbo ti, kowe ti, bereti, e, ya ti raꞌai kei. Siyoti okwe, fisi ku rani ku raꞌai kei. ");
INSERT INTO kwj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","E, ku ini aka foki ku raruwa, o aka kumbwa ete ku da. Wosini ku ikoni pwe o aka ku hanjaꞌaisini ku bwe i. ");
INSERT INTO kwj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","E, ku iwa wui aka tiki kunu wu rakaru nambwe nawa, o ko laka ku hanjaꞌaisini ku ikoni seke hapi ti o ko ni ku yemburunasini ma funda ete ku i, wowa ele hima wui sumbu ti sa wu hambwa.” ");
INSERT INTO kwj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ete wowani ele ko hinga ya wu i. Wu ini ele mapwa hinga tinda ete Gotri mwanji kipe ti wu bwandani hahungo hima le kipe ya wu wosinda. ");
INSERT INTO kwj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","King Herot ele mwanji suwa ni ri mendini inaka rihi ti emendiki naha ete rini i. Hinde wowani, hima fwele ete sawe, “Jon matimat ki ai sairo,” ");
INSERT INTO kwj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","wowani fwele sawe, “Ilaicha sukwaro,” fwele sawe, “Injelembwa Gotri mwanji bwarakarandaro hima fori ai sairo.” ");
INSERT INTO kwj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wowani Herot ya sawe, “Jon kwele a takutoro. Woro kari hinde na hima hinga rito ri mwanji suwa ti a mendindau?” Wosini Jisas ni ri hei ki au ti ya rini sai. ");
INSERT INTO kwj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ele ri Himache wu ai tasini ele sumbu wu wosiro ni Jisas ni ya wu sawehambwanda. Wosiwani wunu ri rani wundombwa foki ya wu i, o ko hi ti Besaita. ");
INSERT INTO kwj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wosiwanumbwa ele himiyama hurahama o sumbu ni wu hambwani rini wu sirinani ya wu i. Rini tambwa wu tawani rini wunu ni heini ya ri eripe. Wosini Gotri aulindau kwambu ti mwanji tini ya wunu ri sawenda. Wondani hahungo hima le kipe ya wunu ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wondawani hunduya ikowani ri tapaꞌangi tapaꞌangi hatachi fisi Himache rihi le tani ya rini wu sawe, “Mini ele bai himiyama hurahama ma wunu sawewa wui ko mapwa tokwe sa wu ini ahirahi wu wakini wu ani sa ya wu tukuya. Dohaꞌa michi nu dau ti o hima nambwe michi.” ");
INSERT INTO kwj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ete wowani Jisas ya wunu sawe, “Kunjenga ahirahi ti ma wunu ku ha.” Wowani ya wu sawe, “Nunu ahirahi miyafo mina. Bereti ti tapaꞌangi ba, fwaiꞌomwe ti fisi opi tombwa do da. Nu ini sutuwa ki ahirahi le dele himiyama hurahama keke nu ranoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ka michi ki 5,000 hima hinga wu daro. Wowani Jisas ri himache leni ya ri sawe, “Ma wunu ku sawewa sa wu huwasini hima kita ti funda funda 50 hinga sa wu wauni wu liti.” ");
INSERT INTO kwj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wowani ri himache le o hinga wu sawewani ele himiyama hurahama ya wu liti. ");
INSERT INTO kwj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wowani Jisas o bereti tapaꞌangi ga fwaiꞌomwe fisi o ga ri torosini hewen ko ki ri mauni ya ri weseꞌa. Wosini ri lepika lepikasini ri himache leni ya ri ha. Wosiwani wundo wu humwasini ele himiyama hurahama leni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wowani wu ani sembe ti ya wunu tale. Ete wowani ele ahirahi tipa gamwe le wu ratani wu wausini hala ti tapaꞌangi tapaꞌangi hatachi fisi ya wu wa. ");
INSERT INTO kwj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gisi foki Jisas rini bati Gotri ni ri uchahambwandawani ri himache le rini ga ya wu da. Wu dawani ya wunu ri sili, “Kale himiyama hurahama hi ti hinde hinga wu ani uchandau?” ");
INSERT INTO kwj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wowani mwanji wasa ya rini wu sawe, “Fwele ete mini wu uchandau, mini uku yasindau hima Jon. Wowani fwele ete mini uchandau, mini Ilaicha. Ete wowani fwele ete sawe, injelembwa Gotri mwanji bwarakarandaro hima rito ri ai sairo.” ");
INSERT INTO kwj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wowani ya wunu ri sawe, “Wo kunjenga hinde hinga ku ani uchandau?” Ete wowani Pita mwanji wasa ya rini sawe, “Mini Kurais. Isurel pe hima leni mi okula kinani Gotri mini ondiyasiro.” ");
INSERT INTO kwj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wowani Jisas mwanji kwambu tiki wunu ri saweni minambwe ya wunu na, apa o hi ni hima forini wu saweno ti keke. ");
INSERT INTO kwj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wosini ya ri sawe, “Dori Hima ri Che amwaka miyafo ri mendino, mekupu hima le, puris hima laka le, e, lo mwanji hambwandau hima le rini ni gumwa wu sisini rini wu yeno, wosiwa gisi namili iwa ri ai saino.” ");
INSERT INTO kwj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wosini ele ri himache tinda ete wunu ni ya ri sawe, “E, hima fori ani ni ri sirina kinawa, hi rihi ti sa ri rakaisini ele gisi hinga ri me yapweke ti ri kichani sa ani sirina. ");
INSERT INTO kwj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","E, hima fori himamwale rihi tini ete ri toronambusiwa, o ri himamwale humbuno. E, hima fori ani ni ri hambwani ri himamwale ti ri ohumbweno ti, himamwale rihi ti kipe naha ete dano. ");
INSERT INTO kwj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","E, hima fori do nuwe kipe ya mwaꞌambwe hinga tinda ete ri ratani ri wauwa, himamwale rihi walambe naha rini iwa, kale ri mwaꞌambwe hinde hinga apa rini okulano? ");
INSERT INTO kwj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","E, hima fori ani ga ai mwanji tinga amwei ri bwa ki mina, huruhumba ri ani hawa, dori Hima ri Che okwe hi rihi okundau tinga, ri Yapai hi okundau tinga, e, Gotri ensel hi okundau tinga ri tawa rini okwe ori hima ni huruhumba ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mwe naha ki kunu a sawendau. Kunu dele ku enindau hima fwele hinde apa ha kumbwa, waya Gotri aulindau kwambu ti ku heisinimbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas o mwanji ri bwasiwani, gisi tapaꞌangi hatachi namili isiwani, Pita, Jon, e, Jemis wunu ri rani gimba ki Gotri ni ri uchahambwa ki ya wu rau. ");
INSERT INTO kwj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wu rausini Gotri ni ri uchahambwandawani miyaningisopo rihi ti ba fo naha sirakowani nikaꞌari rihi ti hi to okundau hinga wamwa naha ete ya sira. ");
INSERT INTO kwj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wondawani hima fisi rini ga mwanji ya wu anambwanda, hima mwe pi Moses hima pi Ilaicha. ");
INSERT INTO kwj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Fini Gotri okundau hi tinga fi tani Jisas Gotri okokona tini ri sirinani Jerusalem ko laka ki ri hano mwanji ti rini ga ya fi sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wondawani Pita ga ri nau fisi miya ga wunu hipiwani ya wu tukuya ki, woro wu tukuya nambwe wu linindani wu heiwani hi hinga okundau Jisas ga rini ga enindau hima o pinga ya wu da. ");
INSERT INTO kwj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka hima fisi Jisas ni fi hanjaꞌaisini fi ikowani Pita Jisas ni ka hinga ya ri sawe, “Apukolaka, ahaꞌa ki nu dawani kipe naha. Nikaꞌari aka namili nu kino, mini keke fo, Moses keke fo, e, Ilaicha keke fo.” Pita norukweni ri hambwa nambwe, wosini o mwanji ri sawero. ");
INSERT INTO kwj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","O mwanji ni ete ri bwandawani hiki foti sikani wunu yohowani ete ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wowani tumwa foti o hiki we ki ya ucha, “Ori ai Che. Rini ani ondiyasiro. Ri mwanji ma ku mendi.” ");
INSERT INTO kwj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","O tumwa uchasiwani wu heiwani Jisas tombwa ya da. Wosiwani wunu takisopo wu dimisini ka gisi ki ka sumbu wu heiro ti hima forini wu sawe nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","O gisi humbusiwani nurumbu o kimba wu andosini wu sikani wu tawani himiyama hurahama miyafo naha wu tani Jisas ni numbo tiki ya rini wu hei. ");
INSERT INTO kwj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wowani ele himiyama hurahama i nindo tiki dau hima fori ya ri ucha, “Ondiyakandiyandau hima, mini ni a silindau, do hurahama che ahi ma hei. Ani hurahama che ahi funda naha. ");
INSERT INTO kwj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Himamwale kapwa foto rini toronambusiwani ata ti walambe tumbwa ri gindau. O himamwale kapwa to rini toroni raꞌichiꞌuchandawani sungwa wamwa naha tombwa wapweni ri takisopo ki sukwandau. Wondani hima tape rihi ti walambe naha tumbwa rini indani gamweche ri rini andosinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi himache le mu tiki himamwale kapwa wu rani wu humbwe kinani ani ichakaro. Woro wunu wu simiyafuro.” ");
INSERT INTO kwj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wowani Jisas mwanji wasa ya rini sawe, “Kunu apa do ku dau himiyama hurahama, kunu Gotri ni sembe mwe naha ku ha nambwe, wosini inaka kuhi ti walambe naha isindau. Gisi geni kunu ga ete a dani kui nomo ti a randano? Che mihi ma rata.” ");
INSERT INTO kwj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ete wowani ri che tandawani himamwale kapwa o to rini toroni raꞌichiꞌuchandawani nuwe tiki ri raini ya apweyitinda. Wowani Jisas himamwale kapwa o tini mwanji kwambu tiki sawewani o che kipe ri ai wosiwani yapai ni ya ri ai ha. ");
INSERT INTO kwj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ete wowani ele himiyama hurahama Gotri kwambu omwesika tini wu heini ya wu apapana. Hima le ele ri wosiro sumbu ni wu heini wu apapanasini wu dawani Jisas ri himache leni ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kunu wasamba ti ma ku owesini do mwanji ku mendi! Ichekiyaiki hinga dori Hima ri Che rini omwemendindau hima lei tapa tenge tiki wu hano.” ");
INSERT INTO kwj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wowani wunu o mwanji ya wu hikisa. Mwanji mu mwe ti wunu yanisini dawani wunu wu hambwa nambwe. Woro wunu o mwanji ni rini wu sili kinani ya wu akinda. ");
INSERT INTO kwj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ri himache le wui nindo tiki mwanji foti ya sukwa. Mwanji tiki au hinga wu anayendani ya wu sawe, namoto wui apukolaka. ");
INSERT INTO kwj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wowani Jisas do inaka tapa hinga wunu ki dau ti ya ri hambwa. Wosini kichapwache forini ri ratani ri mu tiki ya ri esi. ");
INSERT INTO kwj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ete wosini ya wunu ri sawe, “Hima fori hi ahi ki do kichapwache ni ri sembe ki ri rakwaino ti, o ani ni rakwaindau. E, ani ni rakwaindau hima ri, o ani humbwewani a taro hima rini rakwaindau. E, kui nindo tiki hima fori kichapwache naha hinga ri sirano ti, rindo kui nindo tiki apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wowani Jon ga mwanji wasa ya rini sawe, “Apukolaka, nu heiwani hima fori hi mihi tiki himamwale kapwa ri rani ri humbwendau. Woro rini nunu ga ri ichiꞌuchanda nambwe, o keke minambwe rini nu naro.” ");
INSERT INTO kwj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ete wowani Jisas ya rini sawe, “Kunu apa ri tau tini minambwe rini ku na kei. Kunu omwemendinda nambwe hima ri o kui nau.” ");
INSERT INTO kwj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gotri Jisas ni hewen ko tokwe ri raꞌaikondau gisi takai ya tanda. O keke Jisas Jerusalem ko tokwe ri i kinani inaka rihi ki kwambu ki ya ri hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wosini hima fweleni ri mwanji ti ri hasiwani o mwanji ni mwaseni ya wu raꞌai. Ele hima wu ini Sameriya lei ko tiki wu raruni ri mwaꞌambwe leni ya wu otokunanda. ");
INSERT INTO kwj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wondawani ele kipe hima le wunu Jisas ni wui aka tiki wu rakwai kinani wu diyaha. Hinde wowani, wunu ete wu hambwa, rini Jerusalem ko ki ri ikonda. ");
INSERT INTO kwj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ete wowani ri himache fisi, Jemis hima pi Jon, o sumbu fi heifuni rini ni ya fi sawe, “Apukolaka, mi okokona ti, hewen ko kipe hi ti Gotri ni si uchawa ri rawakawa dele himako unoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ete wowani Jisas jamekoni fini heini mwanji kwambu tiki ya fini bwa. ");
INSERT INTO kwj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wosini ko ba foki ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Numbo ki wu indawani hima fori ya rini sawe, “Ele mapwa hinga mi indawa ete mini a sirinani si indano.” ");
INSERT INTO kwj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wowani Jisas ya rini sawe, “Kapwa asa le wunu nuwe sopu tiki wu tukuyandau, e, apwe le wunu woto tiki wu tukuyandau, woro dori Hima ri Che rini mwasakimbe rasaisini ri tukuyano ti aka nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wosini hima forini ya ri sawe, “Mini ma tani ani sirina.” Ete wowani ya ri sawe, “Ma ani ohounawa ani ini ai yapai a sisini pwe.” ");
INSERT INTO kwj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wowani Jisas ya rini sawe, “Sa biya da, haro hima hinga waꞌairo leto o rini sikonda. Woro mini ma ini Gotri aulindau kwambu ti mwanji tini ma wunu bwarakara.” ");
INSERT INTO kwj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wowani hima ba foringa ya rini sawe, “Apukolaka, ani mini a sirina ki. Woro ma ani ohounawa ani ini ai hiparakambwe lenga tapa ti nu anayengunani nu anaweseꞌasini pwe.” ");
INSERT INTO kwj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wowani Jisas ya rini sawe, “E, hima ri kari sitiya ti ri toroni numbo miyafo gumwa tokwe ri ai jamekoni ri maꞌaiwa, rini Gotri aulindau kwambu ti mwanji bwano tau ti hinde kipe ri ra kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wosinumbwa Apukolaka 72 hima hinga wunu ri esisini rini mwaseni wu i kinani fisi fisi ya wunu ri humbwe. Ele ko laka ga ko cheche ga ri i ki hambwandaro ko hinga tinda ete ya wunu ri humbwe. ");
INSERT INTO kwj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wunu ri humbwekoni ya wunu ri sawe, “Ahirahi miyafo tau tiki nipi nipisindau, woro tau ra himache miyafo mina. O keke Yapai chele tau ni ma ku uchahambwawa tau ra himache fwele sa ri humbwewa wu ini ele ahirahi nipiro le rinje sa rini wu numbuni wausi. ");
INSERT INTO kwj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ya ma ku i. Woro, ma ku mendi, sipisip che leni kapwa asa nindo tiki humbwekondau hinga kunu a humbwekondau. ");
INSERT INTO kwj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Apa ya warondau kowe ti, mwaꞌambwe warondau kowe ti, e, su ti ku raꞌai kei. Apa himiyama hurahama fwele numbo tiki ku heini wunu weseꞌa kei. ");
INSERT INTO kwj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","E, ku ini aka foki ku raruni, metengei o aka kipe hima leni ka hinga ma ku sawe: ‘Do aka ki dau himiyama hurahama le, sembe wahapi sumbu kunu ga o da.’ ");
INSERT INTO kwj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","E, sembe wahapi hima fori o aka ki dawa, o sembe wahapi sumbu wunu ga da ki Gotri ni ku uchahambwaro ti ai tani ori sembe wahapi hima kumbwa o dakonda. E, o aka ki sembe wahapi hima fori da nambwe nawa, o sembe wahapi sumbu wunu ku haro ti ai jamekoni tani kunje o ai kunu ga o dakonda. ");
INSERT INTO kwj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","O aka kumbwa ete ku dawa ahirahi lenga uku sumbwe ga kunu handawa ya ma ku anda. Hinde wowani, tau ra himache ri randau tau wasa rihi ti mwe naha sa ri toro. Apa ele aka ele aka ku raruni ku da kei. ");
INSERT INTO kwj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ku ini ko laka foki ku raruwa kunu wu heini wui aka tokwe kunu wu raꞌaisini ahirahi ti humwasini kunu hawa o ma ku a. ");
INSERT INTO kwj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wondani o ko kipe hahungo hima le kipe ma wunu ku wosinda. Wosini ma wunu ku sawe, ‘Gotri aulindau kwambu ti tani kunu takaihiro.’ ");
INSERT INTO kwj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","E, ku ini ko laka foki ku raruwa, kunu wu rani wui aka we tokwe wu rakaru nambwe nawa, ma ku ini o ko laka ki dau numbo ki ku etisini ma ku sawe, ");
INSERT INTO kwj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Do ko laka kipe hapi kuhi ti seke nuhi ki apero ti, nu ai yemburunawani kunje o ai isinda. Woro kunu hambwafwaꞌaisi to: Gotri aulindau kwambu tani takaihiro.’ ");
INSERT INTO kwj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kunu a sawenda, gisi jipe tawa Sotom ni wosiro sumbu kapwacheche hinga, do ko laka ni wosino sumbu tito omwesika laka fo. ");
INSERT INTO kwj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kunu Korasin kipe himako ga Besaita kipe himako ga, kunu fiya kapwa naha! Kui ko ki kwambu chele sumbu ambwe sumbu ambwe a wosiro hinga Taiya ko ga Saiton ko ga a wosipo wunu injelembwa kapwa nikaꞌari simba wu injisini himisombo tape wuhi ki wu hindisini kapwa sumbu wuhi gumwa wu sikoro ambwa. ");
INSERT INTO kwj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gotri mwanji bwano gisi ki Taiya ko ga Saiton ko ga mendino amwaka ti wai hinga, kundo ku mendino amwaka tito omwesika laka fo. ");
INSERT INTO kwj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kunu Kapaneyam ko kipe hima, kunu hewen ko ki kunu rakaunoꞌo? Mina. Kunu ambwenda nambwe wa tiki ku raino.” ");
INSERT INTO kwj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wosini ri himache leni ya ri sawe, “Hima fori kui mwanji tini ri mendiwa, o ai mwanji tini ri mendino. E, hima fori kui mwanji tini gumwa ri siwa, o ani ni gumwa ri sino. E, hima fori ani ni gumwa ri siwa, o ri ani humbwewani a taro hima rini gumwa ri sino.” ");
INSERT INTO kwj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dani ini ele 72 tau ra himache le wu ai tasini ya wu eripenda. Wondani ya wu sawe, “Apukolaka, hi mihi ki himamwale kapwa leni nu sawendawani nui mwanji ti mendini sirinandaro.” ");
INSERT INTO kwj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wowani ya wunu ri sawe, “Ani heiwani Saiten niri tito lepakinaro hinga hewen ko ki sikaro. ");
INSERT INTO kwj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ma mendi, ani kwambu ti kunu ani hasinda, wosiwa ele au hopo ga ele namindawapi ga ku yitindani ele kunu omwemendindau hima lei kwambu tini ku diki sindau. Wowa mwaꞌambwe foto apa hinde walambe kunu i kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Woro kundo ku eripeꞌaripeni ka hinga ete ku sawe kei: ‘Himamwale kapwa nui mwanji tini wu sirinandau.’ Mina. Kunu Gotri hi kuhi ti hewen ko tiki ri kairo tini ma ete ku eripeꞌaripenda.” ");
INSERT INTO kwj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka gisi ki Gotri Himamwale ti Jisas sembe tini yewani ri eripeꞌaripeni ya ri sawe, “Yapai, mini hewen ko ga nuwe ga mini Apukolaka. Hi mihi tini a rasaindau. Dele mwaꞌambwe inaka kipe tororo hima lenga hambwandau hima lenga wunu mi yanisini kichapwa leni mi mekuro. Ei, Yapai o sumbu hinga sukwaro ti, mi okokona kumbwa sukwaro. ");
INSERT INTO kwj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ai Yapai ele mwaꞌambwe hinga tinda ete ai tapa tenge tiki tinda ri ani haro. Hima fori ri Che ni hambwanda nambwe. Ri Yapai tombwa rini hambwandau. E, hima fori ri Yapai ni hambwanda nambwe. Ri Che ga ri Che to Yapai ni meku kinani ondiyasiro hima lenga wundombwa rini hambwandau.” ");
INSERT INTO kwj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wosini ri himache letombwa rini ga wu dawani miyaningisopo ti ri jamekoni wunu ni ri hei hei ya ri sawe, “Hima le ele mwaꞌambwe ku heindau tini wu heiwa, wunu sa wu eripe. ");
INSERT INTO kwj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kunu a sawenda: Injelembwa Gotri mwanji bwarakarandaro hima lenga king apukolaka hima lenga o apa ku heindau sumbu hinga tini wu hei kinani ete wu wondaro, woro wu hei nambwe. E, do apa ku mendindau mwanji hinga tini wu mendi kinani ete wu wondaro, woro wu mendi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lo mwanji hambwandau hima fori Jisas ni simiyanehei ki ri saini ri etisini ya ri sawe, “Ondiyakandiyandau hima, hinde hinga a wosiwa ete da ete da himamwale kipe ri ani hano?” ");
INSERT INTO kwj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wowani Jisas ya rini sawe, “Bwele mwanji tito lo mwanji tiki dau? Mi hambwawani hinde?” ");
INSERT INTO kwj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ete wowani mwanji wasa ka hinga ya ri sawe: “‘Gotri o mi Apukolaka, mi sembe ti tinda ete, mi inaka ti tinda ete, mi kwambu ti tinda ete, e, mi hambwa ti tinda ete rini numbwa mi hasini rini keke ma wo.’ Wosini ‘mi hima tape keke mi wondau hingambwa, hima ba fori keke o hingambwa ma wo.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wowani Jisas ya rini sawe, “O to, mwanji wasa mwe ti o mi sawenda. O hinga ma wosi. Wosiwa himamwale mihi kipe tumbwa ete dano.” ");
INSERT INTO kwj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ete wowani lo mwanji hambwandau hima ori hi rihi kapwa rini ino tini ri diyahani Jisas ni ya ri ai sili, “Wo ‘hima ba fori’ namoni sawero?” ");
INSERT INTO kwj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wowani Jisas mwanji wasa ka hinga ya rini sawe: “Hima fori Jerusalem andosini Jeriko ko tokwe ya ri rai. Wondawani kapwa hima fwele numbo tiki rini wu heini kapwatapa naha rini yesini ri usalikamba leni wu toroni ya wu i. Wosiwani numbo tiki ya ri da, kamindache naha ri hakoro. ");
INSERT INTO kwj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wosiwani o gisi kumbwa puris hima fori o numbo ki ya ta. Ri tani ori hima ri heiwani ri tukuyandawani numbo gamba gamba ri i i rini hei hei ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ete wosiwani Lifai hima kupu fori o numbo kumbwa ri tani ori hima ri heiwani tukuyandawani numbo gamba gamba ri i i rini hei hei ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ete wosiwanumbwa Sameriya ko kipe hima fori o numbo ki ri tani ri heiwani hima fori ya tukuyanda. Wondawani rini ni heini rini keke ya ri wo. ");
INSERT INTO kwj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wosini rini tambwa takai ri ini, weli tinga waini uku tinga rini owesini ya rini inji. Wosini rini tororasaini ri dongi tenge tiki ya rini lisi. Ete wosini rini raꞌaini hima le tukuyandau aka ki ya rini enependa. ");
INSERT INTO kwj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","O gisi humbusiwani nurumbu 10 kina ri rukoni hima tukuyandau yapai chele aka ni ri hasini ya ri sawe, ‘Mini dori hima ni norukweni ma enependa. E, ya ti chiki nambwe nawa ani ai a tano gisi ki ya fonga ai mini ani hano.’ ");
INSERT INTO kwj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Apa mi hambwawani hinde hinga? Kale hima namili nindo ki hinde na hima forito hiliya hima rini yero ka hima keke funda ete ri wo?” ");
INSERT INTO kwj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ete wowani lo mwanji hambwandau hima ori ya ri sawe, “Rini keke woni rini okularo hima ori to.” Wowani Jisas ya rini sawe, “Ma ini o sumbu hingambwa ma wo.” ");
INSERT INTO kwj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wosini wu ini Jisas ko foki ya ri raru. Wowani humwe foti hi tihi ti Mata, tindo rini ra ra ti aka we tiki ya rini rakwai. ");
INSERT INTO kwj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata hipache foti o aka we ki ya kwai ti da, hi tihi ti Mariya. Tindo tani Apukolaka i seke mu tiki takai ti litisini ri mwanji tini ya ti mendinda. ");
INSERT INTO kwj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wondawani Mata ahirahi leni ti wondani, inakahambwa inakahambwa sumbu leni ya ti hambwanda. Wondani Mata ini Jisas ni ya sawe, “Apukolaka, ka ni mi hambwanda nambweꞌe, ai hipache ani hanjaꞌaisini nimba ti linindawani andombwa ahirahi ti ani otokunandau? Woro ma tini sawewa sa saini tani sa ani okula.” ");
INSERT INTO kwj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ete wowani Apukolaka mwanji wasa ya tini sawe, “Mata, Mata, inaka miyafo tini ni hambwandawani sembe nihi ti mwaꞌambwe miyafo keke walambe nini indau. ");
INSERT INTO kwj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Woroti mwaꞌambwe foti kekembwa nu heifu hinga. Mariya o mwaꞌambwe ni ti toro kinani ti linindau. Woro o sumbu kipe tihi ti apa minambwe tini nu na hinga.” ");
INSERT INTO kwj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jisas michi foki Gotri ni ya ri uchahambwanda. O sumbu ri humbusiwani ri himache fori ya rini sawe, “Apukolaka, Gotri ni uchahambwandau sumbu ma nunu ondiyakandiya, ka injelembwa Jon ri himache leni ondiyakandiyaro hinga.” ");
INSERT INTO kwj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wowani ya wunu ri sawe, “Gotri ni uchahambwano gisi ki ka hinga ma ku sawe: ‘Yapai, hi mihi ti kipe naha tumbwa sa ete dawa hima le sa wu rasainda. Aulindau kwambu mihi ti sa ta. ");
INSERT INTO kwj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ahirahi ele gisi hinga nu ano ti, ma nunu ha. ");
INSERT INTO kwj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ele kapwa sumbu nuhi ma rani humbwe. Nunu okwe kale hima kapwa sumbu wosiwani nu rani nu humbwendau. Apa simiyanehei sumbu tiki nunu raꞌai kei.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wosini ya wunu ri sawe, “E, kui nindo tiki hima fori ri nau fo dawani, nili alase ki ri ini ya ri sawe, ‘Ai nau, bereti namili ma ani ha. ");
INSERT INTO kwj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ai nau fori numbo ki tani sukwani ani heiro, woro ani rini a yakwano ti ahirahi nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ete wowani aka we tiki tukuyandau ri nau ri mwanji wasa ya rini sawe, ‘Mini apa ani ni tau kwambu ani ha kei. Aka ti a dimihiro, wosiwani ai che le tei tiki ani ga dele tukuyanda. Apa hinde a saini ahirahi mini ani ha kumbwa.’ Woro ku hambwawani hinde hinga? ");
INSERT INTO kwj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kunu a sawenda, yapai chele aka saini ri nau keke ri hambwani ahirahi rini hinde ri ha kumbwa. Mina. Woro ori hima ete uchani ekichasi ekichasindawa apa ri saini ri heifundau mwaꞌambwe rini hano. ");
INSERT INTO kwj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Worokeke kunu a sawenda: Kunu Gotri ni ma ete ku uchahambwanda, wowa Gotri o kunu hakonda. Kunu mwaꞌambwe ni ma ete ku wakindawa o ku heikonda. Kunu aka duwa ni ma ete yenda, Gotri aka duwa o kunu tukwasikonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hinde na hima fori Gotri ni mwaꞌambwe fo keke ete ri uchahambwano ti, o mwaꞌambwe ri torono. E, hinde na hima fori mwaꞌambwe ni ete ri wakino ti, o mwaꞌambwe ri heino. E, hinde na hima fori aka duwa ete ri yendano ti, Gotri o rini tukwasikonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“E, kui nindo tiki che fori ri yapai ni fwaiꞌomwe keke ri sawewa, apa kapwa hopo ni rini hanoꞌo? Mina. ");
INSERT INTO kwj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","E, ri che ri yapai ni apwetoko la fo rini ha ki ri sawewa, apa yapai kapwa hopo tini rini hanoꞌo? O okwe mina. ");
INSERT INTO kwj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Woro kunu kapwa sumbu ku wondau hima kui che leni mwaꞌambwe kipe tumbwa ku handau sumbu tini ku hambwasindau, o hinga ti nawa Yapai hewen ko tiki ri dau ti rini ni uchahambwandau hima leni Gotri Himamwale kipe o ri hakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas himamwale kapwa hima foriki dasini takisopo dimisiro hima ni kipe ya ri wosinda. Himamwale kapwa o sirani isiwani mwanji bwanda nambwe hima ori mwanji ti ya ri bwa. Ete wowani ele himiyama hurahama o tini wu heini inaka tenge miyafo ya wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wowani hima fwele ya sawe, “Himamwale kapwa lei wui apukolaka, Belesepul, ri kwambu tiki himamwale kapwa ri rani ri humbwendau.” ");
INSERT INTO kwj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wosini hima fwele rini simiyanehei kinani ya rini wu ucha, wowa hewen ko kipe kwambu chele sumbu fo wupa wo sumbu hinga ri wosi ki. ");
INSERT INTO kwj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wowani rini wui inaka ti ri hambwasini ya wunu ri sawe, “E, ko laka ki king apukolaka ri himache le huwasini wu anayendawa o ko laka walambe ino. E, aka foki wu dau analongo hima le wu huwasini wu anayendawa o aka apa hinde yakinani wu eti kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","E, Saiten okwe o hingambwa, ri himache le wu huwasini wu anayendawa apa o wui ko laka hinde hinga yakinani wu etino? Woro ete ku ani sawendau, ani Belesepul kwambu tiki himamwale kapwa a rani a humbwendau. ");
INSERT INTO kwj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","E, Belesepul kwambu tiki himamwale kapwa a rani a humbwendau nawa, namoto kale kui himache leni okulawani himamwale kapwa rani humbwendau? O hinga ku ani sawewa, ele kui himache leto koti torondau hima hinga etisini kui mwanji ni o kunu wu kilikonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Woro, ani Gotri kwambu tiki himamwale kapwa a rani a humbwendau ti nawa, Gotri aulindau kwambu ti kunu ki tahiro. ");
INSERT INTO kwj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“E, hima kwambu naha fori rambu ti ri torosini ri aka tini ri aulindawa, mwaꞌambwe rihi le kipe tumbwa ya dau. ");
INSERT INTO kwj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","E, rini ni dikindau au anaye hima kwambu naha fori tani rini ga fi anayeni dikisini ele ri rambu ga hachangipi huwe ga ri torosiwa kwambu rini haro ti ya leningikonda. Wosinumbwa ele ri mwaꞌambwe ri humwasini ri hima kupu leni ya ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Hima fori ai nau nambwe nawa, rini ai miho. Hima fori ani ga ele sipisip si wau nambwe nawa, o rindo ele sipisip ni ri enginawani wu ichiꞌuchandau. ");
INSERT INTO kwj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“E, himamwale kapwa fori hima foriki dawani rini hanjaꞌaini sirani isini ri fwa nambwe mapwa foki himatino michi tini ya ri wakinda. Woro ri himatino michi ri wakifuni ya ri sawe, ‘Ani ai ini injelembwa a daro aka hukwe ahi ki a dano.’ ");
INSERT INTO kwj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ri ini ri heiwani o aka ri hanjini kaꞌapwe le ri woni yechikina yechikinasinda. ");
INSERT INTO kwj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ete wowani ri ai ini rini ni dikini kapwa sumbu mama wondau tapaꞌangi hatachi fisi himamwale kapwa leni ya ri rata. Wosini o aka ki wu raruni ya wu da. O keke ka hima injelembwa kapwa sumbu wai hinga ri wondaro ti, apa kapwa sumbu omwesika naha ki funda ete ri wondau.” ");
INSERT INTO kwj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ele mwanji hinga ri bwandawani ele himiyama hurahama lei nindo ki humwe fo hapa tinga ti uchani ya ti sawe, “Ka humwe injelembwa mini rasini muku ti mini handaro ti, tini sa ti eripeꞌaripe.” ");
INSERT INTO kwj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wowani Jisas ya sawe, “Mina. Ele hima Gotri mwanji ni wu mendini wu sirinandau tombwa, wunu sa wu eripeꞌaripe.” ");
INSERT INTO kwj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Himiyama hurahama miyafo wu tani wu wausiwani ka hinga ya wunu ri sawe: “Do apa kipe himiyama hurahama le wunu kapwa. Wunu Gotri kwambu tini nimba wu hei kinani kwambu chele sumbu fo keke wu uchandau. Woro apa kwambu chele sumbu foti wunu a meku hinga. Jona ki sukwaro sumbu numbwa wunu a mekukonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Injelembwa Ninifa kipe hima le Gotri wunu wosikondau sumbu ni mwe naha wu hambwa kinani Gotri Jona ni wupa ya ri owe. Woro o hingambwa apa dori Hima ri Che okwe apa dele dau himiyama hurahama le keke Gotri wupa ya rini owekonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ichai Gotri ele himiyama hurahama leni mwanji ri bwano gisi ki, nika rai tokwe miyaningisopo sini tapa yanji waku angi tokwe taro kwini humwe foti dele dau hima lenga funda wu saisini tindo wui kapwa sumbu tini ya ti kilindakonda. Hinde wowani, ka kwini humwe tini niri ambwe nuwe ambwe ti daro tito ti tani Solomon hambwa kipe rihi tini ti mendiro. Woro apa Solomon ni dikiro hima ri dohaꞌa da. ");
INSERT INTO kwj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gotri ele himiyama hurahama leni mwanji bwano gisi ki, Ninifa pe hima le dele dau hima lenga funda wu saisini wui kapwa sumbu tini ya wu kilindakonda. Hinde wowani, Ninifa pe hima le Jona wunu bwandaro mwanji ti wu mendini kapwa sumbu wuhi gumwa wu siro. Woro apa Jona ni dikiro hima dohaꞌa da. ");
INSERT INTO kwj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hima le lamu okusini tei tako tiki, e, hungwe tako tiki wu rawarunda nambwe. Mina. Wunu lamu okusini lamu lisindau tei tenge tiki wu owendau, wowa ele hima raruni o lamu okundau ti sa wu hei. ");
INSERT INTO kwj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miya mihi ti hima tape ki okundau lamu hinga. E, miya mihi ti kipe nawa, hima tape mihi ti okwe lindanasindau. E, miya mihi ti kapwa nawa, hima tape mihi ti okwe hundusindau. ");
INSERT INTO kwj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","O keke mini hambwafwaꞌai. Foki o lamu ri sembe tiki kwai dau ti, apa usungwaha ki. ");
INSERT INTO kwj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","E, ele hima tape mihi tinda ete lindanandani sunduche foti mini ga da nambwe nawa, ele hima tape mihi, lamu tito okuni taiyandau hinga ete mini o hingambwa taiyandano.” ");
INSERT INTO kwj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas o mwanji wunu ri sawesiwani Farisi hima fori ahirahi fi a kinani ya rini ucha. Wowani ri aka we tiki ri raruni tei tiki ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Woro, Jisas Juta hima kupu lei sumbu tini sirinani uku ri ya nambwe tei tiki ri litiwani Farisi hima ori rini heisini inaka miyafo ya ri hambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ete wowani Apukolaka ya rini sawe, “Kunu Farisi hima, hatumwa lenga hungwe lenga hoko tokwembwa ku yokondau. Woro kui sembe we ti kwai hili ya sumbu tinga kapwa sumbu tinga kunu talesindau. ");
INSERT INTO kwj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kunu ambwatinambwati hima! Hoko tokwe dau mwaꞌambwe tini wosiro Gotri, we tokwe dau mwaꞌambwe ti okwe ri wosi nambweꞌe? ");
INSERT INTO kwj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","E, ele mwaꞌambwe kunu ki kwai dau ti ele bwarichape hima le keke ku woni ma wunu ha. O hinga ku wosiwa kunu ki dau hoko kipe mwaꞌambwe ti, e, we kipe mwaꞌambwe ti tinda ete halaya naha. ");
INSERT INTO kwj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Woro kunu Farisi hima, kunu hambwafwaꞌai! Kunu lekekwasa le, lombo le, e, kupucha ba fweleni tapaꞌangi tapaꞌangi kita hinga ku wausini kita funda ri Gotri ni ya ku hau. Woro kunu sumbu kipe tini, e, Gotri keke wondau sumbu tini ku sirinanda nambwe. E, ka sumbu ni metengei ma ku wo. Woro ele sumbu ba fwele okwe ku hanjaꞌai nambwe nawa, o to kipe naha. ");
INSERT INTO kwj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kunu Farisi hima le, kunu hambwafwaꞌai! Kunu hima le kunu hei kinani lotu wondau aka we tiki takumwa naha ki ku linindani, e, hima le hima wausindau michi tiki kunu weseꞌanda ki ku okokonandau. ");
INSERT INTO kwj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kunu hambwafwaꞌai! Kunu awa fwasi nambwe matimat hinga, hima le matimat dau tini wu hikisani o tenge ki wu ichiꞌuchandau.” ");
INSERT INTO kwj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wowani lo mwanji hambwandau hima fori mwanji wasa ya rini sawe, “Ondiyakandiyandau hima, o mwanji hinga mi bwaro ti, huruhumba omwesika nunu mi handau.” ");
INSERT INTO kwj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ete wowani Jisas ga ya sawe, “Kunu lo mwanji hambwandau hima, kunu okwe hambwafwaꞌai! Kunu ele himiyama hurahama wui bendu ki mwaꞌambwe nomo laka leni ku hasiwani wu kicha ki tau kwambu naha wu randau. Woroti kunu tapa gamweche ku dachinani wunu ni ku okula ki ku hambwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kunu hambwafwaꞌai! Kui metele hima Gotri mwanji bwarakarandaro hima leni yeni wu siro. Wosiwani kunu o wui matimat hukwe ni ku ai norukwendau. ");
INSERT INTO kwj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","O hinga wu wo wo, kui metele wosiro sumbu tini ku ohounandau, wosini hima leni o wui sumbu ni amwei ku sawendau. Hinde wowani, kui metele to Gotri mwanji bwarakarandaro hima leni wu yeni wu sisiwani wui matimat ni ku ai norukwendau. ");
INSERT INTO kwj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“O keke Gotri hambwa kipe naha ri hambwasini ri sawero, ‘Ani ni mwanji bwarakarandau hima lenga ai tau randau himache lenga a rumbwewa wunu tambwa wu iwa, fweleni wu yeni wu sini, fweleni walambe sumbu wunu wu wosino.’ ");
INSERT INTO kwj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","O keke, apa dele dau himiyama hurahama, injelembwa Gotri do nuwe wosiro gisi ki ambwesini ete ta tani Gotri mwanji bwarakarandaro hima leni wui metele le wu yeni wu siro sumbu keke nomo ti ya wu rakonda. ");
INSERT INTO kwj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Injelembwa metengei naha Epel ni wu yeni sisiwani ete ta tani apa Sekaraiya ni Gotri ni anguꞌomwe handau tei ga Gotri aka tipa kipe ga fi nindo naha ki rini wu yeni siro. Ei, mwe naha ki kunu a sawendau, ele kapwa sumbu wuhi keke apa dele dau himiyama hurahama le wunu mwanji chele. ");
INSERT INTO kwj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kunu lo mwanji hambwandau hima, kunu hambwafwaꞌai! Kunu hambwa kipe dau aka ki tini ku raꞌaihiro. Wosini kunjenga o aka ku raru nambwe ku dasini ele raru ki simiyandau hima lei numbo tini ku ai ichakindau.” ");
INSERT INTO kwj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wosini Jisas o aka we ri hanjaꞌaisini hoko tokwe ri raruwani lo mwanji hambwandau hima lenga Farisi hima lenga mwanji miyafo ki rini wu yendani ya rini wu omwemendinda. Wondani ri takisopo ki mwanji wasa ri ha kinani ele sumbu ba fweleni ya rini wu silineheinda. ");
INSERT INTO kwj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wondani funda rini ni ya ete wu heinda, ri takisopo ki mwanji foti walambe ri bwawa o mwanji ki rini ni wu kotimwo ki. ");
INSERT INTO kwj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Da hinga wowani himiyama hurahama miyafo naha, apa hinde gendi kumbwa, woro wunu wu wauni funda ete wu anatakai anatakaini hima fwele seke ti fweleni ya yitinda. Ka gisi ki Jisas metengei naha ri himache leni ka hinga ya wunu ri sawe: “Kunu Farisi hima lei bereti ni owesiwani hehenandau wo, yis, tini ku hambwafwaꞌai. Yis mwe ti gambolombo sumbu wuhi tini a sawendau. ");
INSERT INTO kwj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ele sumbu hinga tinda ete wu ichakisiwani dau ti amwei sukwano. Wowa ele yanisiro sumbu ti hima le ya wu hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","O keke ele mwanji hundu tiki ku bwaro ti, ele himiyama hurahama ni nika tinga wu mendino. E, ele mwanji aka we ki kwai usariche ku bwaro ti, aka hoko ki wu etisini amwei wu bwano. ");
INSERT INTO kwj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ai nau le, ka hinga kunu a sawenda: Kunu apa hima tape tumbwa yeni sino hima leni ku aki kei. Wunu o sumbu hinga wu wosisini sumbu ba fotinga hinde apa wu wosi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Woro ku akino hima rini o kunu a mekusikonda: Ori hima naha ni ya ma ku akinda. Rindo himamwale tinga yeni sindau ti, hima ni toroni hi tiki rawaindau kwambu ri torosindau. Ei, mwe naha ki kunu a sawendau, kari hima ni ya ma ku aki. ");
INSERT INTO kwj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ku hambwandau, hima le tapaꞌangi raisiꞌapwe cheche leni humokuto ya fisi ki wu randau. Woro Gotri raisiꞌapweche forini ri hikisanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rini kui mwa nimbi tinda ete ri gendisindau. O keke kunu apa aki kei. Kunu kale raisiꞌapwe cheche leni ku dikisindau. ");
INSERT INTO kwj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Woro kunu a sawenda: E, hima fori hi ahi tini ele himiyama hurahama i miyaningisopo ki amwei ri bwano ti, dori Hima ri Che okwe ori hima ni Gotri ensel lei miyaningisopo tiki amwei ri bwano. ");
INSERT INTO kwj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","E, hima fori ele himiyama hurahama i miyaningisopo tiki hi ahi tini gumwa ri siwa, ani okwe Gotri ensel lei miyaningisopo tiki ori hima ni gumwa rini a sino. ");
INSERT INTO kwj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Hima fori dori Hima ri Che ni kapwa mwanji ri bwano ti, Gotri o ri kapwa sumbu o ri rani ri humbwekonda. Woro hima fori Gotri Himamwale ni ri saweholiyano ti, Gotri apa o ri kapwa sumbu hinde rani ri humwe kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“E, hima le kunu toroni lotu wondau aka ki kunu wu raꞌaini, e, gapiman apukolaka lenga hi chele hima lenga wunu tambwa kunu wu raꞌaini miyaningisopo wuhi tiki kunu wu esisiwa, apa ku akini ete ku hambwa kei, ‘Ka bwele mwanji wasa hinga tini nu hambwasini apa nu bwano?’ ");
INSERT INTO kwj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Do amwa ki ete ku enindawa Gotri Himamwale wunu ku bwano mwanji ti o kunu mekusikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ele himiyama hurahama i nindo tiki dau hima fori Jisas ni ka hinga ya ri sawe: “Ondiyakandiyandau hima, ai okokona ti ai apwai ni ma sawewa si yapai ya mwaꞌambwe le ri humwasini fwele sa ri ani ha.” ");
INSERT INTO kwj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wowani Jisas ya rini sawe, “Hinde wowani? Namoto kui mwanji mendini kilindau hima hinga, e, ya mwaꞌambwe humwasindau hima hinga ri ani esiro?” ");
INSERT INTO kwj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wosini ya wunu ri sawe, “Kunu kipe naha ku hambwafwaꞌai! Apa ya mwaꞌambwe ti keke ku okokona kei. Hinde wowani, hima fori ya mwaꞌambwe miyafo naha dau ti, apa ele ya mwaꞌambwe rihi ki ete da ete da himamwale kipe hinde ri toro kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wosini mwanji yepe foti ka hinga ya wunu ri sawe: “Ya mwaꞌambwe chele hima fori tau rihi tiki ahirahi miyafo naha nipi nipisindau. ");
INSERT INTO kwj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wosiwani ya mwaꞌambwe chele hima ori inaka miyafo ka hinga ya ri hambwa, ‘Apa hinde hinga a wosino? Ahirahi ahi le ani oweno ti aka nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wofunu ya ri sawe, ‘Ka hinga a wosino. Ahirahi ahi owendau aka o ni a lendosini aka laka foti a kino. Wosini ele witi ahi, e, ya mwaꞌambwe ahi ele o aka laka kumbwa a rawaruno. ");
INSERT INTO kwj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wosini ete ya ani hambwa: Ele ya mwaꞌambwe ahi le asama miyafo naha dano. Wondawa ahirahi uku sumbwe ahi tunumbwa ani ani, ani eripeꞌaripendani ya a himati.’ ");
INSERT INTO kwj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ete wowani Gotri rini heini ya rini sawe, ‘Mini ambwatinambwati hima! Do niliki ki o mi hakonda. Wowa kale mi ya mwaꞌambwe aka fotukumbwa mi wausiro ti namoto apa raꞌaikonda?’ ");
INSERT INTO kwj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Woro ya mwaꞌambwe miyafo wunje wu waundau hima le o hingambwa. Wunu Gotri miyaningisopo ki bwarichape hima naha.” ");
INSERT INTO kwj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wosini Jisas ri himache leni ya ri sawe, “O keke kunu a sawendau, apa himamwale kunu andosino ti keke ku hambwani ete ku sawe kei, ‘Ka bwele ahirahi ni nu ano?’ E, kui hima tape ti keke inaka miyafo ku hambwani apa ete ku sawe kei, ‘Ka bwele nikaꞌari ni nu sini hima tape nuhi ti nu ichakino?’ ");
INSERT INTO kwj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","E, himamwale ti ahirahi tini dikindau. E, hima tape ti nikaꞌari tini dikindau. ");
INSERT INTO kwj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kale niri pe apwe ni ma ku hambwa. Wunu witi ti wu sindani ahirahi mwe ti wu waunda nambwe. Wunu ahirahi ni oweno aka wuhi nambwe. Woro Gotri to ahirahi ti nimba wunu yakwandau. Woro kunu himiyama hurahama le apwe leni funda ete ku dikisindau. ");
INSERT INTO kwj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","E, kui nindo tiki hima fori inaka tenge miyafo ri hambwani, apa ri inaka ki himamwale rihi tini kamindache ri ai ondiyasiwa gisi gamwe ga inoꞌo? ");
INSERT INTO kwj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","E, ka sumbu cheche ni ku wosifundau ti nawa, hinde wowani ele sumbu ba fwele keke inaka tenge miyafo ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kale wariko ni ma ku hambwa. Wunu tau kwambu wu rani kaꞌapwe wuhi ti wu wosinda nambwe. Woroti kunu a sawenda. Injelembwa Solomon nikaꞌari kipe naha leni ri sindaro ti, do wariko hinga tini ri diki nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ei mwe naha, apa ele fuku tiki saindau ki le icheki hinga wu yekutoni hi tiki wu humbwewa uno, woro kale ki tapa miya hinga ti Gotri to wariko kipe wunu hani nimba wunu ri enependau. O tini ma ku hambwa, Gotri kipe naha o kunu ri enependakonda. Kunu sembe ku haro ti, kui sembe ha sumbu kapwacheche naha! ");
INSERT INTO kwj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","O keke apa inaka tenge miyafo ku hambwani ete ku sawe kei, ahirahi ga uku sumbwe ga bwele ni ku ano. Apa o tini inaka miyafo ku hambwa kei. ");
INSERT INTO kwj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Do nuwe kipe Gotri ni hambwanda nambwe hima le, wunu ele mwaꞌambwe keke tau kwambu wu wo wo wu wakindau. Woro kui Yapai hewen ko tiki dau to rini hambwasindau, kunu okwe ele mwaꞌambwe to kunu okulawani ku dau ti. ");
INSERT INTO kwj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Woro metengei naha ka tini ma wo: Gotri aulindau kwambu ti ma ku wakinehei. Wowa dele mwaꞌambwe hinga Gotri o kunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kunu dele ai fe che asa che, kunu apa aki kei. Kui Yapai eripeꞌaripeni aulindau kwambu rihi ti o kunu ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ele usalikamba kuhi ya wungwa ma ku ji. Wosini ele ya heifundau hima leni ma ku ha. O hinga ku wosini simba yinda nambwe ya kowe tini ku wosini hewen ko tiki se yinda nambwe mwaꞌambwe kipe tumbwa ma ku wau. Hewen ko tiki ele mwaꞌambwe waninda nambwe, hili ya hima le takai tanda nambwe, e, owechehopoche le mwaꞌambwe leni anda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ele mwaꞌambwe kipe kuhi dau ko kumbwa inaka kuhi okwe o ko ki ya da. ");
INSERT INTO kwj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nikaꞌari ti ku lehepuni faicheri ku injini leti mwalekupu tiki ku dahapisini lamu ti okuni ya ma ku otokuna. ");
INSERT INTO kwj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kale hima wui apukolaka humwe hopwe kinani woro ahirahi laka ri asini ri ai tano tini wu nikisindau hinga ma ku otokunasini nikisinda. E, ri tani dawa ti ri yewa, metengei ete wu mendini ya wu tukwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","E, wui apukolaka hima ori tani ri heiwa, ri tau ra himache wu tukuya nambwe wu nikisindawa ele tau ra himache sa wu eripe. Mwe naha ki kunu a sawe, apukolaka rinjenga nikaꞌari ti ri lehepuni faiche ri ri injini leti ti mwalekupu tiki ri dahapisini tei ki wu liti kinani ya wunu ri sawekonda. Wosiwa rinjenga ri saini ahirahi le ya wunu ri tisikonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Apukolaka nili alase kiꞌi, kapwa apwe gindau amwa ki ri ai tani ri heiwa ele tau ra himache wu tukuya nambwe wu dau nawa, ele tau ra himache sa wu eripe. ");
INSERT INTO kwj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ka sumbu ni ma ku hambwa: E, yapai chele aka mwanji suwa fori ka hinga ri mendiwa, apa hili ya hima fori ri aka ki hili ya ki tano, wosiwa ri aulindawa apa o hili ya hima ri aka ti hinde ri lembuningisini ri raru kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kunu okwe ma ku hambwafwaꞌaisini ku da. Dori Hima ri Che tano gisi kunu ku hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wowani Pita ya sawe, “Apukolaka do mwanji yepe nunu numbwa mi sawendauꞌu, mina dele hima okwe mi sawendau?” ");
INSERT INTO kwj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ete wowani Apukolaka ya wunu sawe, “Hinde na tau aulindau hima forito hambwafwaꞌaisini ri tau ni norukweni ri randau? Apukolaka rini ni esisiwa ele tau ra himache ni ri aulindani, ahirahi hano amwa ki ri tau ra himache leni ahirahi le norukweni ri handakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wondawa ri Apukolaka ri ai tani ri heiwa, ri tau ra himache o mwanji rini sawesiro hingambwa ri wosindawa, o tau ra himache sa ri eripe. ");
INSERT INTO kwj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mwe naha ki kunu a sawendau, ri apukolaka rini esisiwa ele mwaꞌambwe rihi hinga tinda ete rindombwa aulino. ");
INSERT INTO kwj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Woro ori tau ra himache ri inaka ki ete ri hambwawa, ‘Ai apukolaka amahani hinde ta kumbwa,’ wosini ele tau ra himache le, e, tau ra humwe leni wunu ri yendani uku sumbwe kwambu ri andani ya ri ambwatinambwatinda. ");
INSERT INTO kwj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","E, o tau ra himache ri apukolaka gisi foki tano keke ri nikisi nambwe, o sumbu hinga tini ete ri wondawa, ri apukolaka gisi foki ete ri ai tano, woro o gisi hinde ri hambwa kumbwa. Ri apukolaka ai tani ri heini walambe naha ki ete rini yeno, wosini ele hima wui tau ni hambwafwaꞌaini randa nambwe hima lenga ri kilini rumbwewa wunu ga ri dano. ");
INSERT INTO kwj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“O tau ra himache ri apukolaka i inaka tini ri hambwasindau, woro rinjenga ri otokunasini apukolaka i inaka tini ri sirina nambwe. O keke apukolaka hapa tinga rini tanambwa sindau. ");
INSERT INTO kwj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Woro o tau ra himache ri apukolaka i inaka tini ri hikisasini kapwa sumbu hinga fotini ri wowa, o keke ri apukolaka gasa kumbo tiki rini yekondau ti, apa kapwacheche hinga rini tanambwano. Hima fori mwaꞌambwe miyafo naha rini haro ti, ele mwaꞌambwe chiki hingambwa wasa sa ri ai ha. E, hima fori tau ra kinani tau omwesika naha rini haro ti, o tau chiki hingambwa tau sa ri rawa ahirahi mwe o hingambwa sa sukwa. ");
INSERT INTO kwj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ani hi okundau tini do nuwe ki a rumbwe ki a taro. Ani ai okokona naha ti do hi metengeimbwa ete okuni lilinandapo kipe naha. ");
INSERT INTO kwj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ani amwaka chele uku ni a yakondau. Woro o sumbu hinga ani ki sukwa nambwe ete a dawa, sembe ahi ti nomo naha. ");
INSERT INTO kwj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Woro ani a taro ti, ku hambwawani do nuwe ki dau au kuhi tini a humbu kinani a taroꞌo? Mina. O kunu a sawenda: Ani himiyama hurahama leni a huwa kinani a taro. ");
INSERT INTO kwj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Apa ga ichekai ga okwe, aka fokumbwa hima le tapaꞌangi hinga wu dano ti, nerimbe fisi ya wu huwakonda. Wosini hima namili hima fisi ni omwemendindawa, hima fisi ga ele hima namili ni ya fi omwemendindakonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yapai ri hurahama che ni omwemendiwa, hurahama che ri yapai ni omwemendikonda. Wowa nuwai ti himiyama che ni omwemendiwa, himiyama che ga ti nuwai ni ti omwemendikonda. Wowa tukwahapa saini ti naruhumwe ni ti omwemendiwa, ti naruhumwe ga saini ti tukwahapa ni omwemendikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wosini ele himiyama hurahama okwe ya ri sawe, “Hiki ke ti ku heiwani nika raindau mapwa tokwe roni sukwawani metengei ete ya ku saweu, ‘Mwa ti ya yekonda.’ Wowani mwe naha mwa ti ya yeu. ");
INSERT INTO kwj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E, ausuwa ti uku funda ete gesahasindau michi tokwe sini tandawani ku heini ya ku saweu, ‘Nika ti au naha ya yekonda.’ Wowani mwe naha nika ti au naha ya yeu. ");
INSERT INTO kwj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Woro kunu nimba gambo hima! Nuwe kipe sumbu ga niri pe sumbu ga ku heini mwe naha ku kilindau. Wo hinde wowani do apa sukwandau sumbu tini ku heini norukweni ku kilinda nambwe? ");
INSERT INTO kwj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Hinde wowani kunjenga norukweni ku hambwani sumbu kipe tini ku kilinda nambwe? ");
INSERT INTO kwj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","O mini kotimwono hima ga koti wondau aka ki funda ki indawa, o gisi ki ete numbo alase ki rini ga mwanji ti ma ki wonorukwe. Foki koti mendindau hima ri tambwa mini raꞌaiwa, koti mendindau hima ori apungwandai kichandau hima lei tapa tenge tiki mini ri hawa apungwandai kicha hima ele kalapus tiki apa o mini rawarukonda. ");
INSERT INTO kwj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mini a sawenda: Wosiwa kalapus aka tiki amahani apa hinde mi sira kumbwa. Wayambwa koti mendindau hima mini siliro ya hinga tinda ete, humokuto yache okwe mi hani mi chikiwambwa.” ");
INSERT INTO kwj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","O gisi kumbwa ete hima fwele o ki wu wausiro ti, gapiman apukolaka Pailat Galili kipe hima fweleni wosiro sumbu tini Jisas ni ya wu sawe. Pailat wui hima fi tinga Gotri ni anguꞌomwe handau omwe fi tinga funda ete anahulehuro. ");
INSERT INTO kwj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wowani Jisas mwanji wasa ya wunu sawe, “Ku hambwawani, kale Galili kipe hima Galili pe hima ba fweleni dikini wundombwa kapwa sumbu mama wu woro ti keke sembe namo wu aroꞌo? ");
INSERT INTO kwj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mwe naha ki kunu a sawenda: Minambwe naha! E, sembe ku ha nambwe nawa, kunu okwe o hingambwa ku humbuno. ");
INSERT INTO kwj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ka Siloam aka huwe laka lendoni sikani kale 18 hima ni yewani wu haro ti, ku hambwawani wui kapwa sumbu ti, Jerusalem ki dau hima ba fwele wui kapwa sumbu tini wu dikiroꞌo? ");
INSERT INTO kwj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mwe naha ki kunu a sawenda: Minambwe naha! E, sembe ku ha nambwe nawa, kunu okwe o hingambwa ku humbu sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wosini mwanji yepe foti ya wunu ri sawe, “Hima fori fik me foti ri raꞌaini waini rupwa rihi ki ri sisiro tini tuko fwele ri numbu ki ya ri ta. Ri tani ri heiwani tuko fo wa nambwe, mina. ");
INSERT INTO kwj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wofunu o rupwa ni aulindau himache ni ya ri sawe, ‘Ma mendi. Asama namili do fik tuko ni a numbu ki a tani ani heiwani tuko foti wa nambwe. O keke ma seni humbweꞌi. Hinde wowani nuwe uku kipe nimba ini humbundau?’ ");
INSERT INTO kwj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wowani o rupwa ni aulindau tau ra himache ri mwanji wasa ya rini sawe, ‘Apukolaka, mi ani hanjaꞌaisiwa do asama tombwa sa da. Wosiwa nuwe ti kipe i kinani me mu takai ki haweini wa ti ani eisini bulumakau se ti a ratani o ki a rawaikonda. ");
INSERT INTO kwj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wosiwa ai tano asama foki tuko ti wawa, kipe naha. E, wa nambwe nawa, mi seni bwe rumbweꞌi.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Himati gisi ki Jisas ele himiyama hurahama ni lotu wondau aka we ki mwanji le ya wunu ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wondawani himamwale kapwa ga dau humwe foti o ki ya ti da. O himamwale kapwa to hahungo tini hasiwani ti daro asama ti 18. Wosiwani o humwe mwangi hapa ti boloiya ete wosiwani dachikinani ti eti kinani ti simiyandaro. ");
INSERT INTO kwj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wowani Jisas tini heisini ri uchawani ti tawani ya tini ri sawe, “O bai humwe, ni hahungo a rani a humbwehiro.” ");
INSERT INTO kwj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wokoni ri tapa ti o humwe tape tenge ki ri torokowani, metengei ete dachikinani ya ti eti. Wosini o humwe Gotri hi tini ya ti rasai. ");
INSERT INTO kwj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ete wowani o lotu wondau aka aulindau mekupu hima ori Jisas himati gisi ki o humwe ni kipe ri wosiro ti keke rini ni sembe enge ti ya ri a. Wosini mekupu hima ori ele himiyama hurahama ni ya ri sawe, “Tau rano gisi ti tapaꞌangi hatachi funda. E, hima fori kui hahungo ti kipe ri wosi kinani ku okokonawa tau rano gisi tiki pwe ku bwe ta. Apa himati gisi ki o sumbu hinga ku rata kei.” ");
INSERT INTO kwj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ete wowani Apukolaka mwanji wasa ya rini sawe, “Kunu gambolombo hima tiya! Himati gisi ki kunu tinda ete bulumakau dau aka tokwe ku ini kui bulumakau le, e, dongi le uku sumbwe wu a kinani ku raꞌaindau. ");
INSERT INTO kwj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dohaꞌa humwe o Epuraham i anitafenita. Woro Saiten to tini toronambusiwani asama ti 18 hinga ete ti daro. Hinde wowani? Himamwale kapwa tini toronambusindau ti, woro himati gisi a rani a humbweno ti kapwaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","O hinga ri sawewani sembe enge rini andaro hima le mwanji nambwe huruhumba ya wu a. Ete wowani ele himiyama hurahama ele sumbu kipe naha ri woro ti keke ya wu eripeꞌaripe. ");
INSERT INTO kwj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wosini Jisas mwanji yepe foki ai ya wunu ri sawe, “Ka Gotri aulindau kwambu ti bwelefo hinga? Bwelefo hinga tini a yepeni o tini a sawekaweno? ");
INSERT INTO kwj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ani hambwawani ka masitet tukoche fo hinga. Woro hima fori o masitet tukoche raꞌaini ri rupwa tiki ya ri sisi. Wosiwani dani ini me laka hinga ya sai. Ete wosiwani apwe le tani talitapa ki woto le ya wu yenda.” ");
INSERT INTO kwj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wosini ya ri ai sawe, “Ka Gotri aulindau kwambu bwele mwaꞌambwe hinga fotini a yepeni a sawekaweno? ");
INSERT INTO kwj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oti bereti ni owesiwani hehenandau wo, yis, hinga. Humwe foti yis ti hungwe laka we ki dau falawa tinga ti rawaisini uku ti gutosini ya ri jaunjamekonda. Wosiwani dani ikowani falawa oti funda ete hehenani ya sukwa.” ");
INSERT INTO kwj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas ko laka fweleki ri indani, e, ko cheche fweleki ri indani ele himiyama hurahama ni Gotri mwanji tini ya wunu ri ondiyakandiyanda. O hinga ri wo wo Jerusalem ko tokwe ya ri inda. ");
INSERT INTO kwj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wondawani hima fori ya rini sawe, “Apukolaka, Gotri hima funda hima funda numbwa raꞌainoꞌo?” Wowani Jisas ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Lengenumbo cheche ki mi raru kinawa tau kwambu fwesini ma ra. Mini a sawenda: Hima miyafo wu raru kinani wu wondano, woro apa wu simiyafuno. ");
INSERT INTO kwj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yapai chele aka saini aka duwa ti ya ri dimikonda. Ete wosiwa ku tani hoko tiki ku etisini duwa ti ku ye ye ku ucha ucha ka hinga ya ku sawendakonda: ‘Apukolaka, duwa ma tukwawa nu sira!’ Wowa rini ga mwanji wasa ya kunu sawekonda, ‘Ani kunu a hikisandau, kunu so ko kipe.’ ");
INSERT INTO kwj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wowa ya rini ku sawekonda, ‘Nunu mini ga ahirahi tinga uku sumbwe tinga funda nu andani mindo nui numbo ki mi enindani nunu ni Gotri mwanji ti mi ondiyakandiyandaro.’ ");
INSERT INTO kwj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ete wowa rini ga ya kunu sawekonda, ‘Ani kunu a hikisandau, kunu so ko kipe hima. Kunu tinda ete kapwa sumbu ku wondau hima, ma ku i!’ ");
INSERT INTO kwj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wosiwa ku heindawa Epuraham, Aisak, Jekop, e, ele Gotri mwanji bwarakarandaro hima le Gotri kwambu tinga dau ko tiki kwai wu enindawa, kunu minambwe ri nasiwa hoko tiki ya ku dakonda. Hoko tiki ku dani ku ichakandani fu kuhi tini ya ku tangindomunandakonda. ");
INSERT INTO kwj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wondawa nika sukwa mapwa tokwe, nika rai mapwa tokwe, e, waku angi waku angi tokwe kipe ele himiyama hurahama hinga miyafo wu tani wu raruni Gotri kwambu tinga dau hewen ko tiki funda wu linindani ahirahi le ya wu andakonda. ");
INSERT INTO kwj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ei, mwe naha, hima fwele jepini wu tandaro le wu mwaseni wu iwa, ele hima mwaseni wu indaro le ya wu ai jepikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ori gisi kumbwa ete Farisi hima fwele tani ya rini sawe, “Do ko ma hanjaꞌaisini ko ba foki ma i. Herot mini yeni si ki ri hambwanda.” ");
INSERT INTO kwj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wowani Jisas ya wunu sawe, “Ma ku ini o kapwa asa ni ete ku sawe; ‘Ma mendi, apa ga ichaki ga himamwale kapwa le a rani a rumbwendani, e, hahungo mendindau hima leni kipe a wosindano. E, gisi namili ki tau ahi ti a humbuno.’ ");
INSERT INTO kwj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Woro apa, icheki, e, yaiki, ani indano. Hinde wowani, apa Gotri mwanji bwarakarandau hima fori ko ba foki rini yeni si hinga. Minambwe naha, Jerusalem ko kumbwa rini yeni sino. ");
INSERT INTO kwj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, mini Gotri mwanji bwarakarandau hima leni mi yeni mi sindani, Gotri ele ri tau ra himache mini tambwa ri humbwewani wu iro hima leni humokuto ba wunu mi yendau. Numbo miyafo ki ka apwetoko nuwai ti che leni ratani ti tipi sopu tiki ti waundau hinga mi che leni a ratani a wau ki a woro. Wokowani kunu ku diyaha. ");
INSERT INTO kwj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma mendi, Gotri kui aka ti funda ete ri hanjaꞌaihiro. Kunu a sawenda: Apa ai miyaningisopo foti hinde ku ai ku ani hei kumbwa, waya kunjenga ka ku ani sawewambwa: “Apukolaka hi tiki tano hima ri hi tini ma nu rasai!” ");
INSERT INTO kwj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Himati gisi foki Jisas Farisi hima lei wui apukolaka hima ri aka tiki ahirahi a ki ya ri raru. Wosiwani wunu rini ni ya wu misinda. ");
INSERT INTO kwj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hima tape hehenaro hima fori rini ga takaini ya ri lininda. ");
INSERT INTO kwj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Wowani Jisas ori hima ni heisini ele lo mwanji hambwandau hima lenga Farisi hima lenga wunu ni ya ri sili, “Himati gisi ki hahungo hima leni kipe wunu nu wosino ti kipeꞌe, kapwa?” ");
INSERT INTO kwj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ete wowani mwanji wasa foti rini wu sawe nambwe. Wowani ori hima ni tapa tiki ri toroni kipe rini ri wosisini sawewani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wosini ya wunu ri sawe, “E, kui nindo tiki hima fori, ri che foritoꞌo ri bulumakau to uku elesindau wa laka we tiki raisiwa, apa kari hima metengei ete ini rini rasukwa hingaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ete wowani wunu ga mwanji wasa wu bwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas o ahirahi woro hima to uchawani taro hima le ri heiwani takumwa naha ki owero tei kumbwa wu liti ki ya wu wonda. Wowani ri heifuni mwanji yepe fotini ka hinga ya wunu sawe: ");
INSERT INTO kwj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“E, hima fori humwe hopweno ahirahi laka mi a ki mini uchawa, apa mi ini takumwa ki dau tei ki liti kei. Foki hi mihi tini dikindau hi chele hima laka forito o tei ki litikonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","O hima ga mini ga kini uchawani ki taro hima o to tani apa ka hinga o mini sawekonda, ‘Mini do takumwa ki dau tei ti dori hima ni ma hawa sa ri liti.’ Wowa mini huruhumba naha tinga mi ini jipe naha ki dau tei ki ya mi litikonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E, hima fori ahirahi mi a kinani mini uchawa, mi ini jipe naha ki dau tei ki ya ma liti. O hinga mi wosiwa, ori mini uchawani mi taro hima ori mini tambwa tani ka hinga o mini sawekonda, ‘Ai nau, ma tani do takumwa ki dau tei kipe ki liti.’ O hinga mini ri wosiwa, mini ga ahirahi andau hima lei wui miyaningisopo ki mini hi laka. ");
INSERT INTO kwj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hima fori rinjenga hi rihi tini ri rasaino ti, Gotri o hi rihi ai rini rakaino. Woro hima fori hi rihi tini ri rakaiwa, Gotri o hi rihi rini rasai sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wosini o ahirahi ri a ki rini uchawani ri iro hima o rini ya sawe, “E, ahirahi laka fo mi wosini apa mi nau le, mi hiparakambwe le, mi hima kupu le, e, o ko kumbwa funda ku dau ya chele hima leni ucha kei. Foki ahirahi wasa mihi wu wosini aka wuhi ki mi a ki o mini wu uchakonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E, ahirahi laka mi wosini ele bwarichape hima le, ele hima tape wuhi walambe iro hima le, ele seke kapwa hima le, e, ele miyasa hima, wunu ni ma ucha. ");
INSERT INTO kwj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wowa ele hima miya hinga le apa ahirahi wasa hinde mini wu ha kumbwa. Wowa mini o keke o mi eripeꞌaripekonda. Hinde wowani, ichai hima kipe naha le matimat ki ai saino gisi ki Gotri mwaꞌambwe wasa mihi o mini hakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wowani wui nindo tiki dani ahirahi rini ga andaro forito o mwanji ri mendini Jisas ni ya ri sawe, “Hima fori Gotri kwambu ga dau hewen ko ki ri raruni ri litini ahirahi ri ano ti rini sa ri eripeꞌaripe.” ");
INSERT INTO kwj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ete wowani Jisas ya rini sawe, “Hima fori ahirahi laka ri otokunakoni hima miyafo naha ri uchawani do ahirahi laka woro ki ya wu takonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Woro ahirahi laka tini wu ano gisi tawani ri tau ra himache forini ri humbwewani ri ini ta kinani ucharo hima leni ya ri sawe, ‘Kunu ma ta. Ele ahirahi hinga tinda ete ri otokunahiro.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Woro ele hima wunu funda funda wu diyahani mwanji wasa wuhi ya wu sawenda. Hima fori sawe, ‘Ai hima kapwa, ani nuwe tipa fo ya tiki a raro ti, ani ini ani heikondau. Seꞌe, apa hinde a ta kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wowani hima ba fori sawe, ‘Ai hima kapwa, ani tau ra bulumakau ti tapaꞌangi tapaꞌangi a raro, woro rupwa tiki wunu a raꞌaini a simiyaneheikondau, seꞌe, apa hinde a ta kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ete wowani hima ba fori ga sawe, ‘Ani humwe ti apambwa naha ani hopwero. O keke apa hinde ani i kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ete wowani o tau ra himache ai ini ele mwanji hinga wu bwaro tini ri apukolaka ni ya ri sawe. Wowani yapai chele aka sembe enge ri ani ri tau ra himache ori ni ya ri ai sawe, ‘Metengei ete ma ini o ko laka ki indau numbo laka le, e, numbo cheche ki dau bwarichape hima le, hima tape wuhi walambe iro hima le, miyasa hima le, e, seke kapwa hima le, wunu mi ra ra ai aka we tiki ma wunu rasira.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ete wosiwani tau ra himache ori ya sawe, ‘Apukolaka, mi sawero hinga a wosiro. Woro tei fwele ya nimba da.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ete wowani apukolaka o tau ra himache ni ya ri ai sawe, ‘Ele numbo laka ki ma ai ini, tau keke ini injiro ini gimba ini gimba ma ini ele himiyama hurahama ai aka we tiki ma ani rasirasi. Aka ahi hima tombwa tale kinani ani okokonanda. ");
INSERT INTO kwj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mini a sawenda: Kale hima injelembwa wunu ani ucharo hima le, wunu fori ai a ti apa hinde wu a kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Himiyama hurahama miyafo Jisas ga wu indawani ri jamekoni wunu ri heini ya wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“E, hima fori ani ni sirinani ri nuwai yapai, ri che humwe le, ri hiparakambwe le, ri kahaiche le, e, ri himamwale ni omwemendi nambwe nawa, rini apa ai himache hinga hinde ri da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","E, hima fori ri me yapweke ti ri kichani ani ni ri sirina nambwe nawa, rini apa ai himache hinga hinde ri da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Hinde wowani? E, kui nindo tiki hima fori aka huwe laka fori kaumbwa naha ri ki kinawa, metengei ri litisini o aka keke ri humbweno ya hinga tini ri gendisini ya ri hambwau, ‘Do ya ki ka aka laka apa a kini a humbukondau umo, mina?’ ");
INSERT INTO kwj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","E, metengei o hinga ri wo nambwe nawa, simeni numbwa ri owesini aka mwe ti hinde ri humbu kumbwa. Wowa ele hima o sumbu ni wu heini, ori aka kindau hima ni ya wu saweholiyandakonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wondani ya wu sawekonda, ‘Dori hima do aka ri ki ki tau ti ri rasairo, woro ri humbu nambwe.’ ");
INSERT INTO kwj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“E, king apukolaka fori au anaye hima lenga wu ini king apukolaka fonga wu anaye kinawa, metengei ri litisini ya ri hambwau, ‘Anjenga au anaye himache ahi le 10 tausen, wowani ai miho king apukolaka 20 tausen au anaye himache rihi lenga ri rani ya ri tanda. Apa hinde hinga rini ga si anayeni rini ai enginawa ri ikondau umo, mina?’ ");
INSERT INTO kwj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","E, ete ri hambwawa, ‘Apa hinde a diki kumbwa,’ wowa rini ga anayeno king apukolaka apahime dawa, hima fweleni ri humbwewa rini tambwa wu ini au etipe ki mwanji wahapi ki ya wu bwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“O hingambwa kui nindo tiki hima fori ele ri usalikamba hinga tinda ete ri rumbwe nambwe nawa rini apa ai himache hinga hinde ri da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Soliwo oti ahirahi kipe. E, o soliwo au humbuwa, hinde nu ai wowa o soliwo au ai ano? ");
INSERT INTO kwj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka soliwo tapa hinga ti apa tau tiki nu owe hinga, e, bulumakau se hinga nuwe ni okula hinga. Au anda nambwe soliwo tapa hinga ti nimba wu humbwendau. Hima wasamba chele ti do mwanji sa ri mendi.” ");
INSERT INTO kwj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisi ya torondau hima lenga lo mwanji hikisandau hima lenga Jisas mwanji wu mendi kinani rini tambwa takai ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wowani Farisi hima lenga Gotri lo mwanji hambwandau hima lenga mwanji kwambu tiki ka hinga ya wu sawe, “Dori hima Gotri lo mwanji hikisandau hima leni ri rakarusini funda wu linindani ahirahi wu andau.” ");
INSERT INTO kwj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ete wowani Jisas ka mwanji yepe ni ya wunu ri sawe: ");
INSERT INTO kwj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“E, kui nindo ki hima fori 100 sipisip rihi ya da. Woro sipisip fori yanisiwa, 99 sipisip ele mapwa foki wunu ri hanjaꞌaisiwa wu dawa rini o sipisip funda yaniro tini ya ri wakindakonda, waya ri heiwambwa ri ai tano. ");
INSERT INTO kwj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O sipisip ni ri wakini heiwa ri bendu tenge tiki ri opuchani ri eripeꞌaripeni ya ri ai takonda. ");
INSERT INTO kwj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ri ai tani ri ko tiki ri rarusini, ri nau le, e, o ri ko kumbwa funda wu dau hima le ri uchawa wu tani ya wu waukonda. Wosiwa wunu ri sawekonda, ‘Kunu ani ga ma ku eripeꞌaripe! Sipisip ahi fori yanisiwani a wakini ani ai heini a rataro!’ ");
INSERT INTO kwj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kunu a sawenda: O hingambwa kapwa sumbu wondau hima funda ri kapwa sumbu rihi gumwa ri sisini sembe ri hawa hewen ko tiki rini keke omwesika ya wu eripeꞌaripekonda. Do eripeꞌaripe sumbu ti kapwa sumbu nambwe 99 hima kipe le keke eripeꞌaripekondau sumbu tini dikisindau. ");
INSERT INTO kwj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“E, humwe foti ya silifa tihi le tapaꞌangi tapaꞌangi, woro ya silifa fori yanisiwa, lamu ti ti okusini tikisapu ti hanji hanji ya ti wakindakonda, waya ti heisinimbwa. ");
INSERT INTO kwj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","O ya ni ti wakini ti heisiwa, ti nau le, e, o ko kumbwa funda wu dau hima le, ti uchawa wu tani wu wausiwa ka hinga ya wunu ti sawekonda: ‘Kunu ani ga ma ku eripeꞌaripe! Ya silifa ahi foti yanisiwani, a wakini ani heini ani ai rukoro!’ ");
INSERT INTO kwj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kunu a sawenda: O hingambwa kapwa sumbu wondau hima funda ri kapwa sumbu rihi gumwa ri sisini sembe ri hawa Gotri ensel le ya wu eripeꞌaripekonda.” ");
INSERT INTO kwj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wosini Jisas mwanji yepe fonga ya ai wunu sawe, “Hima fori ri hurahama che fisi. ");
INSERT INTO kwj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hipache rito yapai ni ya sawe, ‘Yapai, ani ete ani hambwanda, ele mwaꞌambwe mihi hinga tinda ete ma sini humwasini ahi hinga ya ma ani ha.’ Ete wowani fi yapai ele mwaꞌambwe rihi hinga ri humwasini ya fini haꞌi hata. ");
INSERT INTO kwj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wowani isiti nambwe hipache rito ele ri mwaꞌambwe hinga tinda ete ri rani ko sumbwe naha foki ri isini ya ri da. O ko ki ri dani ya rihi ele kapwa sumbu ri wondani ya ri ohumbwenda. ");
INSERT INTO kwj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ele ri ya mwaꞌambwe ri humbweꞌi humbwetawani iche omwesika laka ka ko ki ya ta. Wowani rini ya mwaꞌambwe nambwe naha ya ri da. ");
INSERT INTO kwj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ete wowani o ko ki dau hima foriki ya tau ri ra kinani rini tambwa ya ri i. Ri iwani ori hima fe rihi ni ri auli kinani fe ini tokwe rini humbwewani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wosini rini ele fe andau mwaka tupu tini ri awa sembe rihi ti rini tale kinani ete ya ri okokonanda. Woro hima fori ahirahi rini yakwanda nambwe naha. ");
INSERT INTO kwj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wosini ri yapai ga ri daro inaka ti ai tawani o tini ri kilisini ya ri sawe, ‘Ai yapai ri tau ra hima le wunu ahirahi miyafo naha, tinda hinde wu a kumbwa. Woro ando do ki a dani iche miyafo naha ani handau. ");
INSERT INTO kwj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Apa ani ai a saini ai yapai tambwa ya ani ikonda. Wosini ete rini a saweno, ‘Yapai, ani Gotri miyaningisopo ga mi miyaningisopo ga kapwa sumbu naha ki a wosiro. ");
INSERT INTO kwj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Apa ani hima kipe nanumbwa mi che hinga mi ani uchano. Ma nimba mi tau ra himache hinga ma ani esisi.’” ");
INSERT INTO kwj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","O hinga ri hambwasini ri saini yapai tambwa ya ri ai i. “Apahime hinga ri indawani ri yapai maꞌaini ya rini hei. Wosini sembe ti rini keke ya ri wo. Wokoni ri namani ri ini, ri che ni ri yakosini ya rini tumwatamwaꞌanda. ");
INSERT INTO kwj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wowani ri che ka hinga ya rini sawe, ‘Yapai, ani Gotri miyaningisopo ga mi miyaningisopo ga kapwa sumbu naha ki a wosiro. Apa ani hima kipe nanumbwa mi che hinga mi ani uchano.’ ");
INSERT INTO kwj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ete wowani yapai ri tau ra himache leni ya wunu ri sawe, ‘Ma ku ini nikaꞌari huwe kipe naha ahi oti ma ku ratamatani rini soꞌoisi. Wosini ficha kipe naha foti tapa nungusenge rihi ki ma rini soꞌoisi. Ete wosini su foti seke rihi ki ma rini soꞌoisi. ");
INSERT INTO kwj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wosini hehenaro bulumakau che foni ma yeni ku rata. Wowa ahirahi tinga woni nu andani nu eripeꞌaripenda. ");
INSERT INTO kwj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hinde wowani, dori ai che ri haro ti, himamwale tinga ai tani sukwaro. Ri yaniro, woroti nu ai wakini rini nu heiro.’ O keke ahirahi laka foti woni ya wu a. ");
INSERT INTO kwj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wondawani ri che mwa laka ri rupwa tiki ya ri da. Woroti ko tokwe ri ai tani ko tipi ki ri etisini ri mendiwani waku yeni hukwa randau ata ti ya ri mendi. ");
INSERT INTO kwj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wosini tau ra himache forini ri uchawani iwani ya rini sili, ‘Bwele sumbu tini wu wosindau?’ ");
INSERT INTO kwj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ete wowani tau ra himache ori ya rini sawe, ‘Mi hipache ri ai tasiwani, mi yapai hehenaro bulumakau che fori ri yero. Hinde wowani, ri che ha nambwe kipe naha dawani ai rini heiro.’ ");
INSERT INTO kwj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ete wowani che mwa laka ori sembe enge ri ani aka we ki ri raru nambwe. Wowani ri yapai rini tambwa ini sembe rihi wahapisi kinani mwanji miyafo ki ya rini sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ete wowani o che mwa laka mwanji wasa ri yapai ni ka hinga ya rini sawe: ‘Asama miyafo naha tau mihi ti mi tau ra himache hinga nimba ete a randaro. Mi mwanji tini gisi foki a sawesiyaꞌai nambwe naha. Woroti meme che fotini mi ani hawani ai nau lenga woni nu andani nu eripeꞌaripe nambwe. Minambwe naha. ");
INSERT INTO kwj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka mi che ele mi mwaꞌambwe hinga tinda ete ele numbo tenge humwe keke tinda ete ri ohumbwero. Wosini ri ai tawani rini keke mi woni o hehenandau bulumakau che ni mi yero!’ ");
INSERT INTO kwj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wowani yapai ka hinga ya rini sawe: ‘Ai che, gisi gisi mini ani ga funda si dau. Dele ai mwaꞌambwe hinga tinda ete mihi ba. ");
INSERT INTO kwj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Woro apa funda ma nu eripeꞌaripewa sembe nuhi ti kipe sa i. Hinde wowani, ka mi hipache ri haro ti, himamwale tinga ai tani sukwaro. Rini yaniro, worotini nu ai wakini rini nu heiro.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas himache rihi leni mwanji yepe foti ya ri sawe, “Ya chele hima foriki ri tau aulindau hima fori ya da. Gisi fo hima fwele tani ya chele hima ori ni ri tau aulindau hima ni mwanji kwambu tiki ka hinga ya rini sawe: ‘Mi tau aulindau hima ri mi mwaꞌambwe le nimba ri ohumbwendau?’ ");
INSERT INTO kwj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ete wowani ri tau aulindau hima ori ni ri uchawani ri tawani ya rini sawe, ‘Ka sumbu hinga mi wosiro mwanji a mendiro. Hinde wowani o sumbu hinga mi wosiro? Mi ini ele ya tau ahi mi randaro ti, chengi tiki norukweni mi kaisini o chengi ani tambwa ma rata. Hinde wowani, mini ele ai mwaꞌambwe apa mi ai aulinda hinga.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ete wowani tau aulindau hima ori, ri inaka ki ka hinga ya ri hambwanda: ‘Apa hinde hinga a wosino? Ai apukolaka i tau ani aulindau ti, apa ya ri ani humbukonda to. Ani a yakinanimbwa apa nuwe ani eini ya tau a rano. Hima leni ahirahi keke ani anakahawendano ti, ani apa huruhumba. Ori o to, ani hambwa kipe naha fo ani hambwahiro. ");
INSERT INTO kwj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O sumbu hinga a wosiwa apukolaka tau ani aulindau ti ri ani humbuwa, hima le wui aka tokwe wu ani rakaruno.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ete wosini ri apukolaka i mwaꞌambwe nimba raꞌaindaro hima leni funda funda ri uchawani rini tambwa ya wu ta. Hima fori metengei naha tawani tau aulindau hima ori ya rini sili, ‘Mini ai apukolaka ri mwaꞌambwe le nimba geni mi raꞌairo?’ ");
INSERT INTO kwj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wowani ya ri sawe, ‘100 daram weli ni a raꞌairo.’ Ete wowani tau aulindau hima ori ya rini sawe, ‘Ele mwaꞌambwe nimba mi raꞌairo tini kairo chengi mihi dohaꞌa da. Apa ma litisini 50 daram weli hinga ma kai.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wosiwani dani ini hima ba foringa tawani tau aulindau hima ori ya rini sili, ‘Ele mwaꞌambwe nimba mi raꞌairo le geni?’ Wowani ya ri sawe, ‘100 witi kowe laka lenumbwa a raꞌairo.’ Ete wowani ya rini sawe, ‘Ele mwaꞌambwe nimba mi raꞌairo tini kairo chengi mihi ti dohaꞌa da. Apa 80 witi kowe laka hinga ma kai.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ete wowanumbwa apukolaka ri tau aulindau kapwa hima ori ni hambwafwaꞌaisini rinjenga ri okularo keke hi rihi ti ya rini rasai. Hinde wowani, do nuwe kipe hima le nuwe pe tau wuhi ti kipe naha wu hambwafwaꞌaisini wunjenga wu okulandau ti, lindana kipe hima leni wu dikisindau. ");
INSERT INTO kwj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“O keke kunu a sawenda: Do nuwe kipe ya mwaꞌambwe kuhi ti ele himiyama hurahama ni ma wunu okulawa kui nau hinga sa wu sira. Wowa ichai ele ya mwaꞌambwe kunu humbuno gisi ki, ele hima kunu rani aka we wuhi tiki kunu rakarusiwa kipe tumbwa ete ku da ete ku dano. ");
INSERT INTO kwj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“E, hima fori mwaꞌambwe cheche ni norukweni ri auliwa, o mwaꞌambwe laka okwe norukweni ri auli sindau. E, hima fori mwaꞌambwe cheche forini norukweni ri auli nambwe nawa, mwaꞌambwe laka okwe norukweni hinde apa ri auli kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","E, do nuwe kipe ya mwaꞌambwe ni norukweni ku aulinda nambwe nawa, apa hewen kipe mwaꞌambwe kipe naha ti namoto kunu andowa ku aulinda kumbwa? ");
INSERT INTO kwj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E, hima ba fwelei mwaꞌambwe ni norukweni ku aulinda nambwe nawa, kui mwaꞌambwe leni namoto kunu andosiwa ku aulinda kumbwa? ");
INSERT INTO kwj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tau ra hima fori hacha fisi ki tau fisi hinde apa ri ra kumbwa. Apa hacha forini ri okokonani hacha forini sembe amwaka ri ano. Wosini apa hacha fori mwanji tini ri sirinani hacha forini gumwa ri sino. Kunu apa Gotri tau ga ya tau ga anaꞌape hinde ku toro kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi hima le wunu ya kekembwa wu okokonandau. O keke Jisas ele mwanji hinga ri bwandau ti wu mendini ya rini wu saweholiyanda. ");
INSERT INTO kwj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ete wowani ya wunu ri sawe, “Kunu ele sumbu kipe kuhi tini ele hima i miyaningisopo ki amwei ku wo kinani ku okokonandau. Woro Gotri kui inaka ti ri hambwasindau. Ele hima i nindo ki hi chele mwaꞌambwe ti, Gotri miyaningisopo ki bwelefo cheche hinga. ");
INSERT INTO kwj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Gotri lo mwanji ga Gotri mwanji bwarakarandaro hima kairo chengi lenga wui tau ti wu ra rawani Jon sukwaro gisi ki ya ambwe. Jon sukwaro gisi ki ete ta tani apa okwe Gotri aulindau kwambu ti mwanji kipe ti ele hima ya wu mendindau. Wosini ele hima hinga tinda ete Gotri aulindau kwambu ki wu raru kinani tau kwambu wu randau. ");
INSERT INTO kwj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Niri ga nuwe ga humbuno sumbu amwei naha, woro Gotri lo mwanji tini kairo himikiche foti humbuno sumbu ti kwambu naha, hinde apa humbu kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ele hima hinga tinda ete wui humwe wu humbusini humwe anandi ni wu hopwewa, o humwe hopwendau sumbu tini walambe wu wosindau. E, hima fori injelembwa hima forito humburo humwe ni ri ai hopwewa, rini okwe anahopwendau sumbu tini walambe ri wosindau. ");
INSERT INTO kwj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Injelembwa ya chele hima fori ya da. Gisi gisi rini siyoti kipe naha kipe naha lenumbwa ri soꞌoindani nikaꞌari naro tunumbwa ri sindaro. Wondani gisi gisi ahirahi kipe numbwa ete ri andaro. ");
INSERT INTO kwj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wondawani ri aka lengenumbo takai ki bwarichape hima fori ya da. Hi rihi ti Lasaras. Okwechenakweche miyafo naha ri tape ki ya da. ");
INSERT INTO kwj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wondani rini ori ya chele hima ahirahi andawani ahirahi gomu tei tako ki raindaro tini ri awa sembe rini tale kinani ya ri hambwanda. Wondawani asa le tani o okwe rihi ni tarukwe wuhi ki ya wu beronda. ");
INSERT INTO kwj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Dani ini bwarichape hima ori ya ha. Wowani ensel le sikani rini wu kichani hewen ko tokwe wu rakausiwani Epuraham ga ya fi da. Ete wosiwanumbwa ya chele hima ori hawani ya rini wu eini si. ");
INSERT INTO kwj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wosiwani himamwale rihi ti ini hi tiki raisini amwaka omwesika laka ki ya ri mendinda. Wondani kau ri mauni ri heiwani Epuraham apahime naha ki Lasaras ga ya fi da. ");
INSERT INTO kwj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wowani ya chele hima ori uchani ka hinga ya ri sawe: ‘Ai yapai Epuraham, ani keke mi woni Lasaras ma humbwewa sa ri tani tapa tongo rihi ki ukuche fori ri haiyesini sa ratani tarukwe ahi ki sa ri ani owesiwa tarukwe ahi ti gamweche ri tikiningo hinga a mendi. Do hi ki a dani amwaka omwesika naha ki a mendindau.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ete wowani Epuraham ya rini sawe, ‘Ai che, ma ai hambwanehei. Injelembwa himamwale mihi ga nuwe ki mi dani mini mwaꞌambwe kipe naha lenumbwa mi raꞌaindaro. Wondawani Lasaras mwaꞌambwe kapwa naha lenumbwa ri raꞌaindaro. Woro keke apa do ko ki rini kipe tumbwa ri dawa, mini amwaka omwesika naha ki mi mendinda. ");
INSERT INTO kwj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Woro o tombwa mina, nui nuwe tipa ga kui nuwe ga Gotri wa laka foti fikasindau. O keke ka ko ki dau hima le do wa laka ni wu yetikinani kunu tambwa hinde apa wu rachi kumbwa. Wowa o kachi nangi ki ku dau hima le do wa laka hinde apa ku yetikinasini nunu tambwa hinde ku rau kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ete wowani ya chele hima ori ya sawe, ‘Yapai, o hinga keke mini a silinda, Lasaras ni ma ai rumbwewa ai yapai ko tokwe sa ri ai ini sawehambwa. ");
INSERT INTO kwj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ai hiparakambwe le tapaꞌangi ba o kaka da. Woro Lasaras sa ai ini mwanji kwambu naha ki sa wunu ri sawehambwa. Foki wunu okwe do amwaka laka a mendindau ko ki apa wu tano keke.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ete wowani Epuraham ya sawe, ‘Moses kairo Gotri lo mwanji ga Gotri mwanji bwarakarandaro hima lei mwanji ga wunu ki o da. O mwanji ni sa wu mendi.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wowani ya chele hima ori ya sawe, ‘Mina, yapai Epuraham. O mwanji keke sembe hinde apa wu ha kumbwa. E, matimat siro hima forito ai saini wunu tambwa iwambwa o tini wu heinimbwa apa sembe wu hano.’ ");
INSERT INTO kwj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ete wowani Epuraham ga ya rini sawe, ‘E, Moses kairo Gotri lo mwanji ga Gotri mwanji bwarakarandaro hima lei mwanji ga wu mendi nambwe nawa, hima fori matimat ki ai ri saiwa o sumbu ni wu heini sembe wuhi ti apa hinde wu ha kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ri himache leni ya ri sawe, “Himiyama hurahama hichakono simiyanehei sumbu mwe naha ya sukwakonda. Woro hima fori sumbu fo ri wosiwa hima fwele wu hichakowa, ma fiya rini keke wo. ");
INSERT INTO kwj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","E, dele kichapwache forini ri mekuwa kapwa sumbu ki ri hichakowa, o hima miya hinga ti humokuto laka foti kwele rihi ki injisini soluwara ki sa rini rawai. O sumbu hinga rini wosino ti wai hinga, hi tokwe ri raino to kapwa naha. Woro kunu kunjenga hambwafwaꞌaisini ku da. ");
INSERT INTO kwj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“E, mi hiparakambwe forito kapwa sumbu ri wowa, mwanji kwambu tiki ma rini sawe. E, ri wosiro kapwa sumbu gumwa ri siwa, kapwa sumbu rihi ti ma rumbwe. ");
INSERT INTO kwj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","E, gisi funda kumbwa kapwa sumbu ti mini ni tapaꞌangi hatachi fisi ri wosisini, o gisi kumbwa numbo tapaꞌangi hatachi fisi ri ai tani ete ri sawewa, ‘Kapwa sumbu mini a wosiro, mi ani ando,’ o hinga ri bwawa kapwa sumbu rihi ma rani rumbwe.” ");
INSERT INTO kwj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ele ri Himache le ya rini wu sawe, “Mini ma nunu okulawa Gotri ni sembe nu handau ti omwesika naha sa i.” ");
INSERT INTO kwj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wowani wui Apukolaka ya wunu ri sawe, “E, sembe ku haro ti, ka masitet tukoche hinga ku hapo, do me tuko andau ni ete ku sawepo, ‘Mini nanji tinga ete ma gwani saini ini soluwara ki eti,’ wowa o me kui mwanji mendini sirina sindau. ");
INSERT INTO kwj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“E, kui nindo tiki hima fori ri tau ra himache fori tau tiki nuwe ri tapu tapusiniꞌi, sipisip leni ri aulisini sunduya iwani aka tokwe ri ai tawa, apa ri apukolaka ete rini sawenoꞌo, ‘Ma tamata litini ahirahi a’? ");
INSERT INTO kwj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mina. Apa o ete rini sawekonda, ‘Ahirahi ahi ti mi husini nikaꞌari wamwa mi injisini peleti ki mi tisini ma rata. Wowa metengei ani ani uku sumbwe ani asiwa pwe mini apa bwe a.’ ");
INSERT INTO kwj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Woro apa ka ri tau ra himache ri mwanji mendini sirinandau keke rini weseꞌano umo? Mina. ");
INSERT INTO kwj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Woroti kunu okwe o hingambwa, e, Gotri ele sumbu hinga tinda ete ku wosi kinani kunu sawero tini ku wosisini, ka hinga ma ku sawe, ‘Nunu tau ra himache kapwacheche, nu ra kinani nunu haro tau tumbwa nu raro.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wosini Jisas Jerusalem mapwa tokwe ri indani Sameriya mapwa ga Galili mapwa ga opi ko laka nindo naha ni ya ri inda. ");
INSERT INTO kwj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ri ini ko foki ri rarukowani tapaꞌangi tapaꞌangi sechi okwe aro hima le tani numbo tiki ya rini wu hei. Wosini apahime ki ete wu etisini, ");
INSERT INTO kwj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hapa tinga wu uchani ka hinga ya wu sawe: “Nui Apukolaka, Jisas, nunu keke mi woni ma nunu okula!” ");
INSERT INTO kwj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wowani wunu ri heini ya wunu ri sawe, “Ma ku ini hima tape kuhi ti puris hima leni ma ku meku.” Ete wowani wu ai jamekoni wu iwani hima tape wuhi le kipe naha ya wu ai sira. ");
INSERT INTO kwj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wowani wui nindo ki dau hima fori ri hima tape ni ri ai heiwani kipe naha wowani ya ri ai i. Ri ai indani Gotri hi tini hapa tinga ri uchani ya ri rasainda. ");
INSERT INTO kwj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wosini Jisas seke mu tiki ri opulini mwa rihi ti nuwe tokwe ri malisini ya rini weseꞌa. Kari hima rini Sameriya kipe hima. ");
INSERT INTO kwj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wowani Jisas o sumbu ni ri heini ya ri sawe, “Ani ete ani hambwa, ele tapaꞌangi tapaꞌangi sechi okwe aro hima le kipe wosiro. Woro kale tapaꞌangi hatachi opuriꞌopuri seleki dau? ");
INSERT INTO kwj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ele hima i nindo ki ai tani Gotri hi tini rasairo ti, do hima kupu ba foritombwaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wosini ya rini sawe, “Ma saini ma i. Gotri ni sembe mi haro tombwa kipe ai mini wosiro.” ");
INSERT INTO kwj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gisi foki Farisi hima le ya rini sili, “Hinde gisimbwa Gotri aulindau kwambu tano?” Ete wowani Jisas mwanji wasa ya ai wunu sawe, “Gotri aulindau kwambu tano gisi ti himiyama hurahama wui miya ki hinde apa wu hei kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wosini apa ka hinga hinde wu sawe kumbwa, ‘Ma hei, o biya ki o da,’ e, ‘Kari kau ki o da.’ Ma mendi. Gotri aulindau kwambu ti kui nindo ki o da.” ");
INSERT INTO kwj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wosini Jisas ri himache leni ya ri ai sawe, “Ichai gisi mwe tawa dori Hima ri Che ri gisi foni ku hei kinani au kunu saindau. Woroti hinde apa ku hei kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wondawa apa ka hinga o kunu sawendakonda, ‘Ma ku ini hei, kari kau ki o da,’ e, ‘Ma ku ini hei, ka biya ki o da.’ O hinga wu bwawa apa ku ini wunu sirina kei. ");
INSERT INTO kwj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Niri tiki kururumbararani hi hinga okukoni ele mapwa hinga tinda ete ya taiyau. Woro dori Hima ri Che ri ai takowa o gisi ki o hingambwa ri dakonda. ");
INSERT INTO kwj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Woroti metengei naha amwaka omwesika laka ri mendindawa apa dele dau hima le gumwa ti rini sisiwambwa. ");
INSERT INTO kwj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nowa ri daro gisi ki wu wosindaro sumbu hingambwa dori Hima ri Che ai tano gisi ki o hingambwa o wu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa ri daro gisi ki, hima le ahirahi ga uku sumbwe lenga wu andani wu anahopwendani wu dawani Nowa sipi tiki ya ri raru. Ete wowani mwa laka ti yeni fwa laka ti taleni ele himiyama hurahama miyafo naha walambe ete ya wunu i. ");
INSERT INTO kwj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot daro gisi okwe o hingambwa. Hima le ahirahi kipe le wu woni uku sumbwe lenga wu andani, mwaꞌambwe kipe le ya wuhi ki wu randani, mwaꞌambwe wuhi le hima leki ya wungwa wu jindani, ahirahi le wu ki ki tau le wu wondani, e, aka le kindani ya wu da. ");
INSERT INTO kwj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wondawani Lot Sotom ko ri hanjaꞌaisini ri indawani o gisi kumbwa ete hi tinga humokuto fo, hi ti, Salifa, tinga niri tiki mwa hinga sikakoni ele himiyama hurahama hinga tinda ete walambe ya ete wunu i. ");
INSERT INTO kwj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Woro hingambwa dori Hima ri Che tani amwei sirano gisi ki o hingambwa o wosikonda. ");
INSERT INTO kwj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ka gisi ki hima fori aka tenge rihi ki kau ri dawa ri usalikamba le ri aka we ki kwai dawa, apa ri rai ri raruni ri usalikamba le rasira kei. O hingambwa ba hima fori tau ki ri dano ti, apa ri aka tokwe ai i kei. ");
INSERT INTO kwj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot humwe ni sukwaro sumbu ti ma ku hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","E, hima fori ri himamwale ni ete ri toronambusiwa, o himamwale rihi humbuno. E, hima fori ri himamwale ni ri ohumbwewa, ri himamwale ti kipe naha tumbwa dano. ");
INSERT INTO kwj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“O kunu a sawenda: Ka gisi niliki hima fisi tei fokumbwa fi tukuyandawa, Gotri forini raꞌaisini forini ya ri hanjaꞌaisikonda. ");
INSERT INTO kwj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Humwe fisi witi tini fi yemburindawa Gotri humwe foni raꞌaisini humwe foni ya ri hanjaꞌaisikonda. ");
INSERT INTO kwj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hima fisi tau ki fi dani tau fi randawa, Gotri hima forini raꞌaisini hima forini ya ri hanjaꞌaisikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wowani ka mwanji ni wu mendini ya wu sawe, “Apukolaka, ka sumbu hinga so michi ki sukwakondau?” Ete wowani Jisas ya wunu sawe, “Hima dinga tukuyandau michi ki apwekumboni le sikani waundau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wosini Jisas wunu wu diyaha hinga gisi gisi Gotri ni ete wu uchahambwanda kinani mwanji yepe fonga ri ai saweni ya wunu ri ondiyakandiya. ");
INSERT INTO kwj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ka hinga ya ri sawe: “Ko laka foki koti mendindau hima laka fori ya da. Kari koti mendindau hima laka rini Gotri ni ri akinda nambwe, wosini hima keke ri wonda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wondawani himanguto humwe foti o ko laka ki ya ti da. Gisi gisi koti mendindau hima laka ori tambwa ti tani ya ti sawenda, ‘Ani ni omwemendindau hima ri walambe naha ya ri ani ikondau. Ani keke mi woni ma rini kotimwo.’ ");
INSERT INTO kwj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Metengei naha koti mendindau hima laka ori tini ri okula ki diyaha. Woro dani inumbwa ri inaka ki ka hinga ya ri hambwa: ‘Ani Gotri ni ani akinda nambwe, wosini hima keke a wonda nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Woro do himanguto humwe gisi gisi ani tambwa tani tau kwambu tini ti ani handau. O keke ti mwanji ti a mendini koti a toro. Foki gisi gisi ete ti ta tawa hima tape ahi ti apa diyahano.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wosini Apukolaka ya wunu sawe, “Ka koti mendindau kapwa hima ri mwanji ti ku mendiro. ");
INSERT INTO kwj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Woro hinde hinga? Gotri rihi nasiro himiyama hurahama le gisi gisi rini ni ete wu uchahambwandawa, apa Gotri wunu keke ri woni amahani wunu ri okula nambwe ete ri nikisindanoꞌo? Mina. Gotri wunu okula kinani koti ri torokonda. ");
INSERT INTO kwj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","O kunu a sawenda: Metengeimbwa ete wunu ri okulani mwanji norukweni ri kilikondau. Woro ichai dori Hima ri Che do nuwe ki ri ai tano gisi ki ele himiyama hurahama ri heiwa Gotri ni sembe ha sumbu ti wunu ki dano umo, mina?” ");
INSERT INTO kwj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hima fwele wunjenga wui inaka ki ete wu hambwandau, wunu hima kipe, wondani hima ba fweleni ete wu hambwandau, wunu kapwa hima lembwa. Ele hima miya hinga ni Jisas mwanji yepe tiki ");
INSERT INTO kwj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ka hinga ya wunu sawe: “Hima fisi Gotri ni uchahambwa kinani Gotri aka laka tokwe ya fi i. Hima fori Farisi hima. Wowani forito takisi ya torondau hima. ");
INSERT INTO kwj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi hima ori saiꞌetisini ri inaka ki ka hinga Gotri ni ya ri uchahambwa: ‘Yapai Gotri, ani ele biya hima ba fwele wosindau sumbu hinga a wosinda nambwe, o keke mini a weseꞌandau. Wunu hili yandani, mi miyaningisopo ki chikinda nambwe kapwa sumbu wu wosindani, hura lisindau humwe ni kapwa sumbu wu wosindau. Woro ani mina. Ani dori takisi ya torondau hima hinga mina. ");
INSERT INTO kwj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ele wiki hinga tinda ete ahirahi ti gisi fisi ani hakindau. Ele ahirahi mwaꞌambwe hinga tinda ete a ratandau, tapaꞌangi tapaꞌangi a humwasini funda ri ya mini ani hau.’ ");
INSERT INTO kwj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wowani takisi ya torondau hima ori saini apahime ya ri eti. Wosini miyaningisopo rihi ti hewen ko tokwe ri mau nambwe. Mina. Ri inaka ti ri yetupwa yetupwa ya ri sawe, ‘Yapai Gotri, ani kapwa sumbu a wondau hima. Ani keke mi woni ma ani okula!’ ");
INSERT INTO kwj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“O kunu a sawenda: Kari takisi ya torondau hima, Gotri hima kipe naha rini nasiwani ri aka lengu tokwe ya ri ai i. Woro Farisi hima ori mina. Hima fori hi rihi tunumbwa ri rasaiwa, Gotri hi rihi rini ai rakaino. E, hima fori hi rihi tini ri rakaiwa, Gotri hi rihi rasai sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wondawani hima fwele wui che leni Jisas tambwa ya wu ratanda. Jisas tapa ti ele wui che tape tenge ki wunu ri owe ki wu okokonandau. Ete wowani ri himache le o tini wu heikoni mwanji kwambu tiki ya wunu bwa. ");
INSERT INTO kwj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wowani Jisas ele che ni ri uchawani rini tambwa takai wu tawani ya ri sawe, “Ma ku haraꞌaiwa ele kichapwache ani tambwa sa wu ta, apa wunu etipe kei. Gotri aulindau kwambu ti ele hima miya hinga keke dau. ");
INSERT INTO kwj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mwe naha ki kunu a sawendau: Hima fori Gotri aulindau kwambu tini kichapwache sumbu hinga ri toro nambwe nawa, apa hinde o ki ri raru kumbwa. Minambwe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wosiwani Gapiman hima laka fori ya rini sili, “Ondiyakandiyandau hima kipe, ka bwele sumbu hinga ni a wosini ete da ete da himamwale kipe a torono?” ");
INSERT INTO kwj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wowani Jisas ya rini sawe, “Hinde wowani hima kipe mi ani nandau? Gotri naha tombwa hima kipe naha. ");
INSERT INTO kwj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gotri lo mwanji o mi hambwanda. ‘Apa hima i humwe sawe kei. Apa hima yeni si kei. Apa hili ya kei. Apa hima foni mwanji gambo kei. Mini mi nuwai yapai mwanji ni ma mendini sirina.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wowani hima laka ori ga ya sawe, “Kichapwache a daro gisi ki ete ta tani apa okwe Gotri lo mwanji ele tinda a sirinandau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ete wowani Jisas o mwanji mendisini ya rini sawe, “Wo sumbu fo keke mi heifundau. Wowa nawa ele mwaꞌambwe mihi tinda ete hima fweleki ya wungwa ma jisini ele ya ma humwasini bwarichape hima leni ma ha. O hinga mi wosiwa, mini hewen ko tiki kau mwaꞌambwe kipe naha tombwa mi wauno. Wosini ma tani ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ete wowani hima laka ori o mwanji ni ri mendini sembe rihi ti nomo naha ya ete i. Hinde wowani, rini ya mwaꞌambwe chele hima naha. ");
INSERT INTO kwj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wowani Jisas rini heini ya sawe, “Mwaꞌambwe miyafo naha dau hima le Gotri aulindau kwambu ki wu raru kinani wu simiyandau, tau kwambu naha. ");
INSERT INTO kwj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ka fe laka, kamel, nikaꞌari kapandau nili sopu tiki raru kinani simiyandau hingambwa ya chele hima ri Gotri aulindau kwambu ki raru kinani ri simiyandau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wowani ele hima o mwanji ni wu mendini ya wu sawe, “E, o hinga nawa, namoto apa ete da ete da himamwale kipe torono?” ");
INSERT INTO kwj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ete wowani Jisas ya sawe, “Hima le wosi ki simiyandau mwaꞌambwe Gotri tombwa wosi sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wowani Pita ya sawe, “Ma mendi, nunu nui ko pe mwaꞌambwe hinga tinda nu hanjaꞌaisini mini ni nu sirinani nu taro.” ");
INSERT INTO kwj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wowani Jisas ya wunu sawe, “Mwe naha ki kunu a sawendau: Hima le Gotri aulindau kwambu ni wu hambwasini wui aka le, wui che humwe le, wui hiparakambwe le, e, wui nuwai yapai hima wu hanjaꞌaisiwa, ");
INSERT INTO kwj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dohaꞌa nuwe ki wu dano gisi ki Gotri ele ri hanjaꞌairo mwaꞌambwe wasa hinga miyafo naha ai wunu hano. Wosiwa ichai sukwano gisi ki ete da ete da himamwale ni wu torono.” ");
INSERT INTO kwj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wosini Jisas tapaꞌangi tapaꞌangi hatachi fisi Himache rihi leni ri raꞌaisini ya wunu ri sawe, “Ma mendi, apa Jerusalem ko laka ki ya nu rarukonda. Wowa injelembwa Gotri mwanji bwarakarandaro hima le dori Hima ri Che ni Gotri chengi ki wu kairo mwanji hinga tinda ete apa mwe naha ya sukwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Apa rini ni hima kupu ba fwelei tapa tenge ki o rini wu hakonda. Wosiwa rini wu saweholiyandani kapwa sumbu fwele rini wu wosindani sungwa ti ya rini wu yisindakonda. ");
INSERT INTO kwj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wosini kupu tiki rini wu tanambwasini rini wu yewa ya ri hakonda. Wosiwa gisi namili iwa ya ri ai saikonda.” ");
INSERT INTO kwj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ete wowani ri himache le o mwanji ni funda ete ya wu hikisa. Hinde wowani, mwanji mu mwe ti wunu ni yanisiwani wunu ri bwaro mwanji oti wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wosini ri ini Jeriko ko ti ri takaiwani miyasa hima fori numbo gamba ki linindaro ti ele himiyama hurahama ni ya mwaꞌambwe keke ya wunu ri uchanda. ");
INSERT INTO kwj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wondani ri mendiwani himiyama hurahama miyafo naha o numbo ki wu tandawani hima fweleni ya ri sili, “Kale bwele sumbu ni wu wosindau?” ");
INSERT INTO kwj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wowani ya rini wu sawe, “Nasaret pe Jisas to tandau.” ");
INSERT INTO kwj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ete wowani ya ri ucha, “Jisas, Defit che, ani keke mi woni ma ani okula!” ");
INSERT INTO kwj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wowani mwaseni taro hima le mwanji kwambu tiki ya rini wu sawe, “Mini ma gaina.” Ete wowani hapa tinga ri ai uchani ya ri sawe, “Mini Defit che, ani keke mi woni ma ani okula!” ");
INSERT INTO kwj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wowani Jisas tani etisini ya wunu sawe, “Ani tambwa ma rini ku rata.” Ete wowani takai ri tawani Jisas ya rini sili, ");
INSERT INTO kwj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bwele sumbu hinga mini a wosi kinani mi ucharo?” Wowani ya ri sawe, “Apukolaka, ani ai a maꞌaikaꞌai ki.” ");
INSERT INTO kwj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ete wowani Jisas ya rini sawe, “Miya mihi ma ripa. Sembe mihi Gotri ni mi haro ti keke kipe ai mini wosiro.” ");
INSERT INTO kwj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ete wowani metengei ete miya rihi ti kipe wosikowani ya ri ai maꞌaikaꞌai. Wosini Gotri hi tini ri rasaindani, Jisas ni sirinani ya ri i. Ete wowani ele himiyama hurahama o sumbu ni wu heikoni Gotri hi tini ya wu rasai. ");
INSERT INTO kwj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wosini Jisas Jeriko ko ki ri rarusini ya ri inda. ");
INSERT INTO kwj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hima fori o ki ya da, hi rihi ti Sakiyas. Rini takisi ya torondau hima le wui apukolaka, rini ya chele hima naha. ");
INSERT INTO kwj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Woro rini Jisas ni heini hambwa ki, rini hinde na hima, woroti himiyama hurahama miyafo naha wausiwani Sakiyas rini hei ki mina, ya ri simiyanda. Hinde wowani, rini hima fai. ");
INSERT INTO kwj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wofunu Jisas ni ri hei kinani rindo mwaseni namani ini fik me foki ya ri rausi. Rini ete ri hambwa, Jisas apa do numbo ki o takonda. ");
INSERT INTO kwj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wosiwani Jisas ini o me mu ki ri etisini ri mauni rini heisini ya rini sawe, “Sakiyas, ma sikamaka. Apa mi aka ki a dano.” ");
INSERT INTO kwj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ete wowani sembe rihi ti ri eripeꞌaripeni ri sikani Jisas ri rani ri aka tokwe ya rini raꞌai. ");
INSERT INTO kwj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wowani ele hima hinga tinda ete o tini wu heini mwanji kwambu tiki ka hinga ya wu sawe, “Kapwa sumbu wondau hima fori aka ki ri ini ya fi tukuyakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wosini Sakiyas etisini Apukolaka ni ya ri sawe, “Apukolaka, ma mendi. Apa mwaꞌambwe ahi le tinda ete alase ti a huwasini tipa foti bwarichape hima leni ani hano. E, hima forini a gambosini ri mwaꞌambwe le a raꞌairo ti, numbo opuriꞌopuri ai rini ani hano.” ");
INSERT INTO kwj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Wowani Jisas ya rini sawe, “Apa do aka ki dau himiyama hurahama le Gotri ai wunu raꞌaihiro. Kari hima okwe rini Epuraham i che. ");
INSERT INTO kwj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dori Hima ri Che rini kapwa numbo ki waniro hima leni wunu ri ai rata ki ri taro.” ");
INSERT INTO kwj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka mwanji wu mendisiwanimbwa mwanji yepe fonga ai ya wunu ri sawe. Hinde wowani, rini Jerusalem ko ti ri takaindawani ya wu hambwanda, apa naha kumbwa ete Gotri aulindau kwambu ti amwei naha o sirakonda. ");
INSERT INTO kwj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ya ri sawe, “Hima apukolaka fori ko sumbwe foki ya ri ikonda, wosiwa king apukolaka hinga rini wu esisiwa ichai ri ko tokwe ri ai ta ki. ");
INSERT INTO kwj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ri ikoni tau ra himache tapaꞌangi tapaꞌangi leni ri uchawani wu tawani ya ti mekumbo tapaꞌangi mekumbo tapaꞌangi ya wunu funda funda ri haꞌi hatanda. Wosini ya wunu ri sawe, ‘O ya ma ku raꞌaini tau ku rani fwelenga ma ku ai torondani a tano gisi ti ku nikisinda.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Woro ri ko kipe hima le rini omwemendindau. O keke ri isiwani hima fwele wu humbwewani ri gumwa tokwe ya wu i. Wu ini ele hima ni ya wu sawe, ‘Nunu dori hima nui king apukolaka hinga ri etino ti nu diyaha.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“O hinga wu bwaro ti mina, king apukolaka hinga rini esisiwani dani ini ya ri ai ta. Ri ai tani ya ri sawe, ‘Imbihumbwa ele ya ani haro tau ra himache ma wunu uchawa sa wu ta. Wowa ani hambwa, ele funda funda wunu ani haro ya ti ya tau wu rawani geni ai sukwaro.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Wowani metengei naha hima fori tani ya ri sawe, ‘Apukolaka ya mekumbo tapaꞌangi mi ani haro ki a raꞌaini ya tau a rawani 5 handet kina hinga ai sukwaro.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wowani apukolaka ka hinga ya rini sawe, ‘Mini tau ra himache kipe, o tau cheche hinga ni mi hambwafwaꞌaini mi aulindaro. O hinga keke kwambu ti mini ani hasiwa do tapaꞌangi tapaꞌangi ko laka o mi aulikonda.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ete wowani tau ra himache foringa ai tani ya ri sawe, ‘Apukolaka, o ya mekumbo tapaꞌangi mi ani haro ki a raꞌaini ya tau a rawani 250 kina hinga sukwaro.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wowani apukolaka ya rini sawe, ‘Mini ani ondiyasiwa ko tapaꞌangi o mi aulikonda.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ete wowani tau ra himache foringa ai tani ya rini sawe, ‘Apukolaka ya mekumbo tapaꞌangi mihi mi ani haro ti ahaꞌa. Nikaꞌari sumbu ki ani injisini ani owesiro. ");
INSERT INTO kwj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hinde wowani, mini ani heiwani mini au hima naha. Hima fori mwaꞌambwe foti owesiwani o mi ini mi ratandau, e, hima fo ahirahi ti kisiwani o mi eindau. O keke mini ani akisindau.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ete wowani apukolaka tau ra himache ori ni ka hinga ya ri sawe: ‘Mini tau ra himache kapwa naha! O mi sawero mwanji keke mini a kotimwokonda. Ei mwe naha, o mi hambwanda, ani hima kwambu naha, hima fo mwaꞌambwe owesiwani o a raꞌaindau, e, ahirahi hima fo kisiwani o ani eindau. O hingaꞌa? ");
INSERT INTO kwj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wo hinde wowani ya ahi ti mi raꞌaini bengi ki mi owe nambwe? O hinga mi wosipo ani ai a tani ya fwelenga a torokoro.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wosini ele rini ga takai enindau hima leni ya wunu ri sawe, ‘O ya mekumbo tapaꞌangi oti ma leningini raꞌaini 5 handet ya dau hima rini ma ku ha!’ ");
INSERT INTO kwj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ete wowani ele hima ga ya rini wu sawe, ‘Apukolaka rini ya ti 5 handet kina hinga o rini da.’ ");
INSERT INTO kwj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Wowani ya ri ai sawe, ‘O kunu a sawenda to. E, hima fori mwaꞌambwe fwele rini ga dau ti, mwaꞌambwe fwelenga ai rini ani ha sindau. E, hima fori mwaꞌambwe miyafo rini ga da nambwe, fisiche naha ri torosindau ti, o mwaꞌambwe fisiche ai rini a leningino. ");
INSERT INTO kwj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Woro ele ai miho wui king apukolaka hinga ani eti kinani wu diyaharo hima ele ma wunu ratasini ai miyaningisopo tiki ma wunu yewa sa wu ha!” ’ ");
INSERT INTO kwj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ele mwanji hinga tinda ri bwasini rindo mwaseni Jerusalem indau numbu ki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ri ini kimba fo hi uchandau ti, Olif, o kimba ki takaisini dau ko fisi Betefasi ko ga Betani ko ga, opi ko ni ri takaisini ri himache fisi ri rumbwewani mwaseni ya fi i. ");
INSERT INTO kwj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Fi ikowani ya fini ri sawe, “Ma ki ini kari kwakwa ko cheche ki ma ki raru. O ko ki ki raruni akisai dongi che foti kupu tiki wu injisiwani dau ti o ki heikonda. Imbihumbwa hima fori o dongi tenge ki liti nambwe. Woro o tini ma hungoni ki rata. ");
INSERT INTO kwj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","E, hima fori ka hinga kini sawewa: ‘Hinde wowani o dongi ki hungondau?’, ete wowa mwanji wasa ka hinga ma rini ki sawe: ‘Apukolaka tau chele.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wosini Jisas fini humbwewani fi ini ele fini sawekawero mwaꞌambwe hinga tinda ya fi hei. ");
INSERT INTO kwj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wosini o akisai dongi ni kupu ti fi hungondawani yapai chele dongi tani ka hinga ya fini sawe: “Hinde wowani o akisai dongi kupu ti ku hungondau?” ");
INSERT INTO kwj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ete wowani ya fi sawe, “Apukolaka ahaꞌa dongi ki tau chele.” ");
INSERT INTO kwj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ete wosini o dongi fi rani Jisas tambwa ya fi rata. Wosiwani nikaꞌari wuhi le wu toroni o dongi tenge ki wu yetosiwani Jisas o tenge ki ri rauni ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wosini o dongi tenge ki ri indawani ele himiyama hurahama nikaꞌari wuhi le wu toroni numbo ki ya wu yeto yeto inda. ");
INSERT INTO kwj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wondawani ri tani Olif hi uchandau kimba andosini raindau numbo ti ri takaindawani ele ri himache hinga tinda wu eripendani Gotri hi ti ya wu rasainda. Hinde wowani, wunu Jisas wosiro ele kwambu chele sumbu ambwe sumbu ambwe ni wu heiro tini ya wu hambwanda. ");
INSERT INTO kwj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wu uchani ka hinga ya wu sawenda: “Apukolaka hi ki tandau dori King Apukolaka ni nu eripeni hi rihi ma nu rasai! Hewen ko ki sembe wahapi sumbu sa ete da. Kari kaumbwa naha ki hi omwesika naha sa ete okunda.” ");
INSERT INTO kwj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wondawani ele himiyama hurahama lei nindo ki dau Farisi hima fwele Jisas ni ka hinga ya wu sawe: “Ondiyakandiyandau hima mi himache le mwanji kwambu ki ma wunu sawewa sa wu gaina.” ");
INSERT INTO kwj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wowani rini ga mwanji wasa ya wunu ri sawe, “E, kunu a sawenda, wunu gainawa apa humokuto leto Gotri hi wu uchani wu rasai sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ri tani Jerusalem ko ti ri takaini o ko laka ni ri heikoni ya ri ichaka. ");
INSERT INTO kwj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ri ichakani ya ri sawe, “E, do gisi kumbwa sembe wahapi sumbu ni mi hambwandapo o kipe. Woro apa ka sumbu yanisiwani mi hei numbwa. ");
INSERT INTO kwj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma mendi, ichekai gisi fo tawa, mi miho le tani tinda mini hokoni ulume seni injisini o mini wu misindakonda. ");
INSERT INTO kwj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wondani mini ga mini ki dau che mihi lenga walambe naha o kunu ikonda. Apa mini ki dau humokuto beiye ki kiro ele mwaꞌambwe ni funda ete wu lendosiwa humokuto foti humokuto foi tenge tiki hinde da kumbwa. Hinde wowani, Gotri mini okula ki taro gisi tini mi hambwa nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wosini ri ini Gotri aka laka we ki ri raruni ele ya tau randau hima leni mwanji kwambu tiki wunu sawendawani sirani ya wu inda. ");
INSERT INTO kwj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wosini ka hinga ya wunu ri sawe: “Gotri mwanji ete sawero: ‘Aka ahi ti Gotri ni uchahambwandau aka hinga dano.’ Wosiwani kundo o sumbu hinga ku wowani ani heiwani hili ya hima leto tani yanindau michi hinga.” ");
INSERT INTO kwj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisas gisi gisi ele hima ni Gotri aka laka we ki kwai ya wunu ri ondiyakandiyanda. Ete wondawani puris hima wui hima laka le, Gotri lo mwanji hambwandau hima le, e, himiyama hurahama leni aulindau mekupu hima le, wunu tinda Jisas ni yeno numbo tini ya wu wakinda. ");
INSERT INTO kwj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Woro ele himiyama hurahama to ri mwanji ni wasamba wu owesini wu mendindawani ele hima laka le rini yeno numbo fo wu wakini wu hei nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gisi foki Jisas ele himiyama hurahama ni Gotri aka laka we ki kwai Gotri mwanji ti ya wunu ri sawenda. Wondawani puris hima wui hima laka le, Gotri lo mwanji hambwandau hima le, e, ele wui mekupu hima wunu tinda rini tambwa ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wu tani ya rini wu sawe, “Ma nunu sawe. Mini bwele kwambu hinga mi torosini o tau mi randau? Namoto o kwambu mini haro?” ");
INSERT INTO kwj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ete wowani rini ga mwanji wasa ka hinga ya ai wunu ri sawe: “Ani okwe mwanji foti kunu a silineheikondau. Ku hambwawa ma ku ani sawe: ");
INSERT INTO kwj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon hima leni uku yasindaro sumbu ti, hewen ko ki taro sumbuꞌu, hima inaka ki ri wondaro sumbu?” ");
INSERT INTO kwj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ete wowani wunjenga ka hinga ya wu anambwa anambwanda: “E, ete nu sawewa, ‘O hewen ko ki taro sumbu,’ wowa apa ka hinga ori sawekonda, ‘Wo hinde wowani sembe kuhi ti ri bwaro mwanji mendini ku ha nambwe?’ ");
INSERT INTO kwj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","E, ete nu sawewa, ‘O hima i inaka ki hambwa hambwa wondaro sumbu,’ wowa apa dele himiyama hurahama humokuto ki nunu wu takehekonda. Hinde wowani, wunu Jon ni Gotri mwanji bwarakarandau hima hinga sembe mwe naha wu hasindau.” ");
INSERT INTO kwj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wofunu Jisas ni ka mwanji wasa hinga ni ya wu sawe: “Nunu nu hikisandau, ka uku ri yasindaro kwambu soki taro.” ");
INSERT INTO kwj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wowani Jisas ya wunu sawe, “Ani okwe namoi kwambu a torosini tau ahi a randau ti kunu a sawe hinga.” ");
INSERT INTO kwj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wosini Jisas mwanji yepe fo ele himiyama hurahama ni ka hinga ya ri sawe: “Hima fori tau rihi ki waini me le ya ri si. Wosini waini rupwa oti hima fweleto ya tau hinga wu ra kinani wui tapa tenge ki ya wunu ri ha. Ete wosini rini ko sumbwe naha foki ri isini ya ri da. ");
INSERT INTO kwj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wosini waini tuko numbundau gisi tawani ri tau ra himache forini ri humbwewani waini tuko rihi fwele ri rata ki ya ri i. Wosiwani o waini rupwa ki randau hima le wu saini rini wu yeni wu humbwewani nimba nimba ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wowani tau ra himache forini ya ri ai humbwe. Ete wowani o tau ra himache okwe o hingambwa rini yeni kapwa sumbu naha rini wosini ai rini humbwewani nimba nimba ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ete wowani tau ra himache foringa ya ri ai humbwe. Wowani rini wu yesini toroni hoko tokwe ya rini rawaru. ");
INSERT INTO kwj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","O keke yapai chele rupwa ori ya sawe, ‘Hinde hinga apa a wono? Ai hurahama che o da, funda ete rini keke a wondau. Woro o ai che ni a humbwewa ri mwanji o wu mendikonda.’ ");
INSERT INTO kwj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ri iwani o waini rupwa ki ya tau randau hima le rini heini wunjenga ka hinga ya wu anambwa anambwa: ‘Dori hima ichekai ri sekewa tapawa hinga ya ri sirinakonda. O keke ma rini nu yeni si. Wosini do waini rupwa nundo nu raꞌai.’ ");
INSERT INTO kwj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","O hinga wu bwakoni rini wu toroni waini rupwa hoko tokwe rini wu rawarusini rini yewani ya ri ha. Hinde hinga ku hambwandau? Kari yapai chele rupwa apa hinde hinga wunu ri wosino? ");
INSERT INTO kwj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Apa ri ai tani ele waini rupwa ki tau randau hima le o ri yeni sikonda. Wosini o waini rupwa laka hima ba fweleni o ri ai hakonda.” Jisas o mwanji hinga ri bwawani ele hima ri mwanji ni wu mendini ya wu sawe, “Apa o sumbu hinga wosi hinga, minambwe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ete wowani Jisas wunu hei hei ya wunu ri sawe, “Do Gotri chengi ki dau mwanji mu mwe ti hinde hinga? ‘Aka rasaindau hima le kapwa wu nani wu humbwero humokuto oti apa ele humokuto ba fweleni dikini rindo takumwa tokwe enindau worumbo hinga o ya ri ekikinasinda.’ ");
INSERT INTO kwj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","E, hima fori o humokuto tenge ki ri sikano ti, talihapa rihi ti tukumorino. E, do humokuto to hima fori tenge ki sikano ti, ori hima ni funda ete rini yembisewa hapi hinga ri sira sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ete wowani Gotri lo mwanji hambwandau hima le, e, puris hima lei wui hima laka le wunu tinda ete ya wu hambwa, Jisas do mwanji yepe wunu naha ni ri sawero. O keke o gisi naha kumbwa wu saini Jisas ni ya wu toroni inji ki. Wokoni ele himiyama hurahama ni wu ai heini ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wosini rini ni ete ya wu misinda. Wondani hima fweleni wu humbwewani hima kipe hinga wu gamboni waꞌaisini rini tambwa ya wu i. Wu ini ele sumbu ri wosindau ni ya wu heinda, wosiwa gapiman hima apukolaka i tapa tenge ki rini wu hano mwanji bomo fo wu toro kinani ya wu wakinda. ");
INSERT INTO kwj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wondani ya rini wu sili, “Ondiyakandiyandau hima, nu hambwasinda, mini ele himiyama hurahama ni mwanji mwe naha kumbwa mi bwani wunu mi ondiyakandiyandau. Mini hima i hi laka ti keke mi akinda nambwe. Mina. Mini ele himiyama hurahama ni Gotri sumbu kipe ti mwanji mwe naha kumbwa wunu mi ondiyakandiyandau. ");
INSERT INTO kwj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Woro hinde hinga mi hambwandau? Takisi ya ti Sisa king apukolaka ni nu hano sumbu ti kipeꞌe, kapwa?” ");
INSERT INTO kwj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wowani Jisas mwanji gambo wuhi ti amwei naha ri hambwasini ya wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Humokuto ya foti ma ku ani ratawa ani hei. Do ya ki dau hima i himamwale ga, e, hima hi ga namohi?” Wowani ya wu sawe, “Sisa king apukolaka hi.” ");
INSERT INTO kwj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ete wowani ya wunu ri sawe, “Sisa king apukolaka i mwaꞌambwe ti o Sisa ni ma ku ai ha, e, Gotri mwaꞌambwe ti o Gotri ni ma ku ai ha.” ");
INSERT INTO kwj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","O hinga ri sawewani ele himiyama hurahama i nindo ki ri mwanji bomo foti wu toro ki wu wofuro. wunu o mwanji wasa wuhi ni ri bwaro ti keke wu apapanakoni mwanji nambwe gainasini ya wu eninda. ");
INSERT INTO kwj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wosiwani Satiyusi hima fwele Jisas tambwa ya wu ta. Satiyusi hima le wunu ka hinga wu sawendau, “Hima matimat ki wu sindau ti hinde apa ai sai kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wu tani ya rini wu sawe, “Ondiyakandiyandau hima, Moses Gotri lo mwanji foti kaisini ka hinga nunu sawero, ‘E, hima fori humwe hopwesini dani ini che nambwe ri hasiwa, ri hipache to o humwe sa ri ai himanguto rasini ri apwai che ti sa fi wosisi.’ ");
INSERT INTO kwj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Woro imbihumbwa analongo hiparakambwe le tapaꞌangi hatachi fisi ya wu da. Wosiwani o wui apwai mwa laka rito humwe fo ri ratasini ri hopwero ti che nambwe ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ete wowani ri diya rito o humwe ya ri ai hopwe. Wosini che nambwe ya ri ai ha. ");
INSERT INTO kwj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wowani ri diya to o hingambwa ya ri ai wo. Ele tapaꞌangi hatachi fisi analongo hiparakambwe le o hingambwa wu woni wunu che fo wunu ti rasi nambwe ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wosiwani dani ikoni o humwe okwe ya ti ha. ");
INSERT INTO kwj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Woro ele haro hima wu ai saino gisi ki ka humwe namoi humwe hinga ti dano? Mi hambwandau, ele tapaꞌangi hatachi fisi hiparakambwe o humwe numbwa wu hopwero.” ");
INSERT INTO kwj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ete wowani Jisas ya wunu sawe, “Apa do gisi himiyama hurahama le wu anahopwenda. ");
INSERT INTO kwj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Woro ichai Gotri wunu chikini ohounaro himiyama hurahama le wu ai saini himamwale kipe tinga ete wu dano ti, wunu apa anahopwendau sumbu hinga hinde wu sirina kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wosini hinde apa wu ai ha kumbwa. Kale Gotri ensel dau hingambwa wu dano. Gotri ai wunu rasairo ti keke ri che hinga o wu dakonda. ");
INSERT INTO kwj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Woro Moses okwe ele hima hasini ai saino bomo ni ya nunu ri ondiyakandiyanda. Michi foki ri isini ri heiwani meche foriki hi okuni sukwandawani mwanji foti ka hinga ya sawe: Apukolaka rini ‘Epuraham Gotri, Aisak Gotri, e, Jekop Gotri.’ ");
INSERT INTO kwj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Woro o hingambwa Gotri ele haro himako wui Gotri mina. Gotri rini ele himamwale tinga dau hima lei wui Gotri. Hinde wowani, Gotri miyaningisopo ki ele hima hinga tinda ete wui himamwale ti ete dau.” ");
INSERT INTO kwj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","O mwanji ri sawewani lo mwanji hambwandau hima fwele mwanji wasa ya rini wu ai sawe, “Ondiyakandiyandau hima, mwe naha ki mi sawendau.” ");
INSERT INTO kwj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wokoni mwanji fo ai rini wu sili ki ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wowani mwanji fonga ya wunu ri sawe, “Hinde wowani ka hinga wu sawendau, Kurais rini Defit che? ");
INSERT INTO kwj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Woro Sam chengi foki Defit rinjenga ete ri sawero: ‘Apukolaka ai Apukolaka ni ka hinga sawero: “Mini ai tapa mama tokwe ma lininda. ");
INSERT INTO kwj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Wondawa mi miho le wunu a wosiwa mi seke tako ki wu dano.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Woro Defit rinjenga Kurais ni Apukolaka rini naro. O hinga nawa Kurais hinde hinga Defit che hinga ri dau?” ");
INSERT INTO kwj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ele himiyama hurahama hinga tinda wu dasini Jisas mwanji ni ya wu mendinda. Wondawani ri himache leni ya sawe, ");
INSERT INTO kwj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kunu lo mwanji hambwandau hima leni ku hambwafwaꞌainda. Wunu hima i miyaningisopo ki nikaꞌari huwe laka tini wu sisini wu ichiꞌuchanda kinani wu okokonandau. E, wunu hima le waundau apweli ki wunu weseꞌanda kinani wu okokonandau. Wondani lotu wondau aka laka we ki himiyama hurahama le miyaningisopo sindau mapwa tokwe wu liti ki wu okokonandani, e, ahirahi andau gisi ti wunu takumwa naha ki dau tei ki wu liti kinani wu okokonandau. ");
INSERT INTO kwj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wunu ele himanguto leni gambosini wui ya mwaꞌambwe ti wundo hili yandani, e, hima le wunu hei kinani nimba gamboni huwe laka Gotri ni wu uchahambwandau. O keke hima i sumbu kilino gisi tawa ele lo mwanji hambwandau himako nomo omwesika ki wu ra sindau.” ");
INSERT INTO kwj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wosini miya ti ete ri heindawani ya chele hima le wu tani Gotri aka laka ki dau bokis ki ya le ya wu rawainda. ");
INSERT INTO kwj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wondawani ete ri heiwani himanguto foti ti tani ya naro fisi numbwa ya ti rawai. ");
INSERT INTO kwj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wosiwani Jisas ya sawe, “Mwe naha ki kunu a sawendau, do himanguto ya ti rawairo ti ele hima leni ti dikisini miyafo naha ti rawairo. ");
INSERT INTO kwj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hinde wowani, wunu tinda ete ya miyafo wunu ki dawani fwelenumbwa Gotri ni anguꞌomwe handau hinga wu haro. Woro do humwe tini bwarichape naha ya miyafo tini ki da nambwe. O ya jipeche ahirahi rani ti akoro ti tinda ete ti rawairo.” ");
INSERT INTO kwj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hima fwele Gotri aka laka ni ka hinga ya wu sawe: “Wunu do Gotri aka laka ni humokuto kipe naha lenga hima le Gotri ni huwandari haro mwaꞌambwe kipe lenga ele ki kaꞌapwe wosisindau.” Wowani Jisas ya wunu sawe, ");
INSERT INTO kwj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Apa dele mwaꞌambwe ku heindau ti, ichai gisi fo tawa, ele kiheiye dau humokuto hinde apa alekusi kumbwa, tinda ete wu dungwa dungwa wu rumbweꞌiwa o raindakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ete wowani Jisas ni ya wu ai sili, “Ondiyakandiyandau hima, bwele gisi ki ele sumbu hinga sukwano? Bwele sumbu hinga to metengei wupa hinga sukwawa nu hambwano, ele sumbu ya sukwakonda?” ");
INSERT INTO kwj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wowani Jisas ya sawe, “Kunu hambwafwaꞌainda, foki hima le o apa kunu gambokonda. Apa hima miyafo wu tani hi ahi ki ka hinga o wu sawekonda: ‘Hima mwe ri ani sa to,’ wosini ka hinga ori sawekonda: ‘Gisi mwe takaihiro.’ Woro apa wui mwanji ku mendini ku sirina kei. ");
INSERT INTO kwj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wondani ichai au laka anayekondau mwanji suwa le ku mendini apa ku aki kei. Kale sumbu hinga to metengei o ya sukwakonda. Woro gisi jipe humbuno ti amahani hinde apa sukwa kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wosini ya ri ai sawe, “Hima mu fwele saini hima mu fwelenga o wu anayendakonda. Wondawa king fori ri au anaye himache le saini king ba fo, ri au anaye himache lenga o wu anayekonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ete wondawa minawe laka ti nuwe ki o dikonda. Wondawa mapwa fweleki iche miyafo naha wunu handani hahungo omwesika laka o wu wondakonda. Ete wondawa ku akino sumbu anandi lenga sumbu omwesika naha lenga wupa wo sumbu hinga niri ki o sukwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Woro dele sumbu hinga sukwa nambwe dawa hima le kunu wu toronambusini walambe sumbu fwele o kunu wu wosindakonda. Wondani wui lotu wondau aka we ki kwai kunu kotimwosini kalapus tiki o kunu wu rawarukonda. Wosini wunu hi ahi ni wu rakai ki wu hambwasini apa kunu raꞌaini king apukolaka lenga gapiman apukolaka lenga wui miyaningisopo tiki o kunu esikonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wosiwa o gisi ki kunu Gotri ni sembe ku haro sumbu ni amwei wunu ku saweno. ");
INSERT INTO kwj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Woro o gisi sukwa nambwe dawa inaka kuhi kwambu ki ku etisini kunjenga ka hinga ma ku sawe, ‘Ani bwele mwanji wasa wunu a saweno tini inaka tenge miyafo ani hambwa hinga.’ ");
INSERT INTO kwj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anjenga ai mwanji ti kui takisopo we ki a rawakwani hambwa kipe ti o kunu ani hakonda. Wowa ai mwanji ti ele kunu omwemendindau hima leni ku bwawa, kui mwanji ti hinde apa wu sawesiyaꞌaini rakai kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Kui nuwai yapai, kui hiparakambwe le, kui hima kupu le, e, kui nau le, wunu apa kunu omwemendindau hima lei tapa tenge tiki o kunu wu hakonda. Wowa kui nindo ki dau fweleni o kunu yeni sikonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Hi ahi ti kunu ga dau keke hima le sembe enge ti o kunu wu andakonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Woro ka tini ma ku hambwa, kui mwa ki dau mwa nimbi fori hinde apa lekutoni sika kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Woro kwambu ki ma ete ku etinambusini ku dani himamwale kipe kuhi ti ku ai toro. ");
INSERT INTO kwj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","E, ichai ku heiwa au anayendau hima le wu tani Jerusalem ko laka ni wu jambaniwa ya ma ku hambwa, ko laka oti walambe ino gisi takaihiro. ");
INSERT INTO kwj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","O gisi ki Jutiya mapwa ki dano hima le wu akini ini kimba ki sa wu rau. Wowa Jerusalem ko laka ki dano hima le o ko laka wu hanjaꞌaisini wu akini mapwa fo tokwe sa wu i. Wondawa ko cheche ki dano hima le apa ko laka tokwe wu ai raru kei. ");
INSERT INTO kwj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ka gisi o Gotri kapwa sumbu wasa hakondau gisi. O keke ka Gotri chengi ki dau mwanji hinga tinda mwe naha sukwakondau. ");
INSERT INTO kwj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka gisi ki ele che sembe ga dau humwe le, e, che muku handau humwe le keke fiya kapwa naha! Nomo omwesika naha do nuwe ki sukwakondau. Hinde wowani, Gotri sembe enge a ti ele himiyama hurahama ni o wunu rawakakonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hachangipi huwe laka to wunu fweleni kutoni humbukondau. Wui miho le kalapus tiki wunu rawarusini ai wunu ra ra hima ba fwele alase ki o wunu raꞌaikonda. Wosiwa ele hima kupu ba fwele au seke Jerusalem ko laka ki wu yitindani i ini hima leni aulindau kwambu wuhi humbuno gisi ki ya wu ambwekonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sumbu ba fwele tapwaki nika ki, niliki nika ki, e, isangi leki sukwani wupa wo sumbu hinga ya sirakonda. Ete wondawa ele nuwe mapwa ki dau himiyama hurahama hinga tinda ete soluwara saini yembekina yembekina tani yepunandano ata ni wu mendindani sembe wuhi ti walambe naha wunu indani ya wu akindakonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wondani ele himiyama hurahama miyafo nuwe ki sukwano sumbu ni wu hambwandani inaka wuhi ti aki omwesika naha ki wu akindani miya wuhi ti misisiweri ti ya wunu yendakonda. Hinde wowani, ele isangi mwaꞌambwe hinga niri tiki dau ti, tinda ete raꞌichiꞌuchakondau. ");
INSERT INTO kwj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ete wosiwambwa hima le wu heiwa, dori Hima ri Che niri wamwa tenge ki ri litisini kwambu omwesika tinga okundau hi omwesika tinga ya ri takonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dele sumbu hinga metengei sukwakondawa o gisi naha ki kunu ma ku saini ku etisini mwa kuhi ti niri tokwe ya ma ku mau. Gotri ai kunu raꞌaino gisi takaihiro.” ");
INSERT INTO kwj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wosini mwanji yepe foti ya wunu ri ai sawe, “Kunu fik me ga kale biya me ba fwelenga ma ku hei. ");
INSERT INTO kwj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","E, kopika anandi ti sirawani ya ku hambwau, nika tumbwa ya yekonda. ");
INSERT INTO kwj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Woro o hingambwa kale sumbu sirawa ya ma ku hambwa, Gotri aulindau kwambu tani takaihiro. ");
INSERT INTO kwj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mwe naha ki kunu a sawendau: Apa o gisi ki dano himiyama hurahama le hinde wu ha kumbwa, waya ete wu dawa ele sumbu hinga tinda sirasiwambwa. ");
INSERT INTO kwj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Do niri ga nuwe ga humbuno, woro mwanji ahi to hinde humbu kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Woro kunu hambwafwaꞌai. Foki kapwa uku mama ku andani ambwatinambwati sumbu le ku wosindani hima tape ni enepeno mwaꞌambwe keke inaka tenge miyafo ku hambwanda ki. E, o sumbu hinga to kunu ichakiwa, apa Apukolaka tano gisi ti metengei ete kunu wakineheikondau, omwe ti bitawa ki funda hikisasini raindau hinga. ");
INSERT INTO kwj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka gisi sukwakondau sumbu ti ele nuwe mapwa ki dau hima hinga tinda ete wunu chikikondau. ");
INSERT INTO kwj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","O keke kunu ete hambwafwaꞌaindani gisi gisi Gotri ni ma ku uchahambwandawa Gotri kwambu kunu hani kunu okulandawa kale sumbu hinga sukwawa ku ratakosini dori Hima ri Che miyaningisopo ki funda ku eti ki.” ");
INSERT INTO kwj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gisi gisi Jisas ele himiyama hurahama ni Gotri aka laka ki ya wunu ri ondiyakandiyanda. Wosini hunduwani ri ini kimba fo, hi ti Olif, o kimba ki ya ri tukuyanda. ");
INSERT INTO kwj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wondawani ele himiyama hurahama hinga tinda ete nurumbumbwa wu saini ri mwanji wu mendi kinani Gotri aka laka tokwe ya wu inda. ");
INSERT INTO kwj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pasofa wu uchandau bereti hehenandau wo, yis, owe nambwe gisi laka ti ya sukwakonda. ");
INSERT INTO kwj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wondawani ele puris hima laka lenga Gotri lo mwanji hambwandau hima ele ga himiyama hurahama miyafo leni wu akindani ya wu anambwa, “Bwele numbo hinga ki Jisas nu yeno?” ");
INSERT INTO kwj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","O mwanji hinga wu anambwandawani Saiten Jutas sembe ki ya raru, hi rihi foti Isukariyot. Hima mwe ri rini tapaꞌangi tapaꞌangi hatachi fisi Jisas Himache fori. ");
INSERT INTO kwj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wosiwani ri ini ele puris hima laka lenga, e, Gotri aka laka aulindau hima laka lenga Jisas ni wui tapa tenge ki ri hano mwanji tini ya wu anambwa. ");
INSERT INTO kwj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wosiwani wu mendisini wu eripeꞌaripeni ya rini wu hano mwanji ti o gisi kumbwa ya wu inji. ");
INSERT INTO kwj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jutas o ya rini wu hano mwanji ri mendini ri ohounasini Jisas ri toroni wui tapa tenge tiki ri oweno numbo tini ya ri wohambwakahambwanda. Woro ri okokona ti, himiyama hurahama miyafo rini ga da nambwe gisi foki wu ini rini wu toroni inji ki. ");
INSERT INTO kwj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Wosiwani bereti hehenandau wo, yis, owe nambwe gisi laka ya sukwa. Ka gisi laka ki Pasofa ahirahi keke sipisip che ya wu yekonda. ");
INSERT INTO kwj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ete wowani Jisas, Pita hima pi Jon ni ya fini ri sawe, “Ma ki ini Pasofa ahirahi ti ma ki otokunasiwa apa nu tani nu a.” ");
INSERT INTO kwj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wowani fini ga ya rini fi sawe, “Mi okokona ti so aka ki si otokunano?” ");
INSERT INTO kwj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ete wowani ya fini ri sawe, “Ma ki mendi. Ki ini ko laka ki ki raruni ki heiwa hima fori hachahungwe laka ki uku ti ri tisini ri tani numbo tiki o kini heikonda. Wowa ma rini ki sirinani o aka ri raruro ki ma ki raru. ");
INSERT INTO kwj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wosini o aka chele hima mwe ni ya ma ki sawe, ‘Ondiyakandiyandau hima ete mini sawero, “Ai himache lenga Pasofa ahirahi nu ano aka tipa so?’” ");
INSERT INTO kwj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wowa kiheiye aka woro heiye tokwe dau aka tipa laka foti o kini ri mekusikonda. O aka tipa we ki kwai litino tei ti, ahirahi ano tei ti wu otokunasinda. Woro o aka tipa ki Pasofa ahirahi ti ma ki otokunanda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","O mwanji hinga fini ri sawewani ya fi i. Fi ini fi heiwani ele sumbu hinga tinda ete Jisas sawero hingambwa ya sukwa. Wosiwani Pasofa ahirahi ti ya fi otokunanda. ");
INSERT INTO kwj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gisi mwe tawani Jisas tei tiki ya ri liti. Wosiwani ri Himache le okwe rini ga funda ya wu liti. ");
INSERT INTO kwj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wosini ya wunu ri sawe, “Kunu ga do Pasofa ahirahi ani a ki ete a nikisindaro. Pasofa ahirahi nu asini pwe, amwaka ti a bwe mendi. ");
INSERT INTO kwj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Apa ka hinga kunu a sawenda: Pasofa ahirahi hinde apa ani ai a kumbwa, waya ka sumbu mu mwe ti Gotri aulindau kwambu ti amwei naha sukwano gisi ki chikiwambwa.” ");
INSERT INTO kwj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ete wosini kapu ga ri rukoni Gotri ni ri weseꞌasini ya wunu ri sawe, “Ahaꞌa ma ku toroni kui nindo ki ku humwasini ku a. ");
INSERT INTO kwj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ando kunu a sawendau: Apa ambwesini apaꞌichekai okwe ka waini uku hinde ani a kumbwa, ete da dani Gotri aulindau kwambu amwei naha sukwano gisi kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wosini bereti ri rukosini Gotri ni ri weseꞌasini lepikani wunu hasini ya ri sawe, “Dohaꞌa ai hima tape, kunu okula ki o kunu ani handau. O sumbu hinga ete ku wosindani ani ni ma ku hambwanda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wu asini kapu waini uku ti okwe o hingambwa ri wosini ya sawe, “Dohaꞌa kapu waini uku ti, ai fi ni sawero. O fi ki Gotri mwanji ako injikondau, woro kunu okula kinani o a dawehenakonda. ");
INSERT INTO kwj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Woro ma hei, miho himako i tapa tenge tiki ani oweno hima ri do tei ki ani ga funda si lilinda. ");
INSERT INTO kwj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hima ri Che dori Gotri imbihumbwa rini ondiyasiro numbo tunumbwa ri sirinano, woro miho himako tapa tenge rini oweno hima rini ma fiya rini keke wo.” ");
INSERT INTO kwj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","O hinga ri sawesiwani wunjenga wu anasili anasilindani ya wu sawe, “Namoto apa ka sumbu hinga rini wosikondau?” ");
INSERT INTO kwj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wosini ele ri himache le mwanji tiki au hinga wu anayeni ya wu sawe, “Nui nindo ki namoto nui apukolaka?” ");
INSERT INTO kwj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wowani ya wunu ri sawe, “Kalehaꞌa nuwe pe king apukolaka le kwambu chele, wosini hima leni kwambu tiki aulini dawani ele hima ri mwakambe ki rini ni ‘hima keke wo hima naha’ ya wu nandau. ");
INSERT INTO kwj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Woroti apa o hinga ku wo kei. Mina. E, hima fori kui nindo tiki apukolaka ri dau ti nawa, rini hima wapa hinga sa da. Kui nindo ki hima fori kunu aulini mwanji bwandau hima hinga ri dau nawa, rini wui tau ra himache hinga sa da. ");
INSERT INTO kwj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Namoto apukolaka, tei tiki linindani ahirahi andau hima toꞌo, ahirahi tisini hima le tambwa ratandau hima rito? Tei tiki linindani ahirahi andau hima rito apukolaka. Woroti ani kui nindo tiki ahirahi a tisini hima le tambwa ratandau hima hinga a dau. ");
INSERT INTO kwj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“E, kale simiyanehei sumbu hinga ani ki sukwawani, ku ani andosi nambwe, kunu ani ga ete ku daro. ");
INSERT INTO kwj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ai Yapai aulindau kwambu ti ri ani haro. Woro hingambwa aulindau kwambu ti kunu ni o ani hakonda. ");
INSERT INTO kwj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wosiwa ani aulindau ko ki tei tiki ku litisini ahirahi ku ani uku sumbwe o ku andakonda. Wosini king apukolaka litindau tei tiki ku litisini tapaꞌangi tapaꞌangi hatachi fisi Isurel hima mu leni ku kilikondau. ");
INSERT INTO kwj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, mini ma mendi. Saiten hima le raisi tini yekindau hinga kunu ni ri simiyanehei kinani Gotri ni ri uchawani rini ohounaro. ");
INSERT INTO kwj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Woroti sembe ha sumbu mihi humbuno keke ani mini ani okula kinani Gotri ni ani uchahambwaro. O keke ichai mi ai kwambu ki mi etiwa, mi hiparakambwe le ma wunu okula.” ");
INSERT INTO kwj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wowani Pita ya rini sawe, “Apukolaka, ani mini ga kalapus tokwe si ino ti, e, mini ga ani hano ti ani otokunasindau.” ");
INSERT INTO kwj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wowani Jisas mwanji wasa ya rini sawe, “Pita mini a sawendau. Apa do niliki ki apwetoko gi nambwe dawa, numbo namili o ete mi sawekonda, ‘Ani Jisas a hikisandau.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wosini ya wunu ri sawe, “Imbihumbwa kunu a humbwewani ku iro ti, ya kowe ti, mwaꞌambwe warondau kowe ti, seke su ti ku ra ra ku i nambwe. Woro o gisi ki mwaꞌambwe fo keke ku heifundaroꞌo?” Wowani wunu ga ya sawe, “Mina.” ");
INSERT INTO kwj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wowani ka hinga ya wunu ri sawe: “Woro apa hima fo ya kowe dawa sa toro. Mwaꞌambwe warondau kowe ti okwe o hingambwa. Hachangipi huwe laka heifundau hima ri nikaꞌari rihi ti wungwa sa jisini hachangipi huwe laka rihi foti sa ra. ");
INSERT INTO kwj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hinde wowani, Gotri chengi ete sawero, ‘Kale kapwa hima ga funda rini wu wauro.’ Worotini kunu a sawendau, ka sumbu hingambwa ani ki o sukwakonda. Ei, Gotri chengi ani sawero mwanji hinga tinda ete mwe naha ya sukwakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wowani ya wu sawe, “Apukolaka ma hei. Nunu hachangipi huwe laka fopi dohaꞌa da.’ Wowani ya wunu ri sawe, “Opi yakito.” ");
INSERT INTO kwj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ete wosini hoko tokwe ri raruni ele gisi ki ri wondaro hinga Olif gimba tokwe ya ri i. Wowani ri himache le rini wu sirinani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wu ini o michi ki wu rarusini ya wunu ri sawe, “Simiyanehei sumbu kunu ki sukwano keke Gotri ni ma ku uchahambwanda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wosini wunu ri andosini humokuto takehewani sikani ambwendau hinga kwakwa hinga ya ri i. Wosini seke ri ombungwesini Gotri ni ka hinga ya ri uchahambwa: ");
INSERT INTO kwj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Yapai, mi okokona nawa do sembe nomo ani ki dau ti ma rani rumbweꞌi. Woroti, mini apa ai okokona tunumbwa sirina kei. Mina. Mi okokona tunumbwa ma sirina.” ");
INSERT INTO kwj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ete wowani hewen pe ensel foti sikani sembe rihi ya rini okula. ");
INSERT INTO kwj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wowani Jisas nomo naha ri mendikoni kwambu tiki au laka Gotri ni ya ri uchahambwanda. Wondawani huru ti fi hinga nuwe tokwe ya sikanda. ");
INSERT INTO kwj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gotri ni ri uchahambwasini saini ri himache le tambwa ya ri i. Ri ini wunu ri heiwani sembe wuhi ti nomo naha iwani ya wu tukuyanda. ");
INSERT INTO kwj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wondawani ya wunu ri sawe, “Hinde wowani ku tukuyandau? Ma saini Gotri ni ma ku uchahambwanda. Foki simiyanehei sumbu kunu ki sukwakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas mwanji ete ri bwandawani hima miyafo naha ya wu ta. Jutas, kale tapaꞌangi tapaꞌangi hatachi fisi Himache fori, woro rindo ya wunu mwaseni ya ri ta. Ri tani Jisas ni tumwatamwaꞌa kinani ya rini takai. ");
INSERT INTO kwj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wowani Jisas ya rini sawe, “Jutas, Hima ri Che dori ni mi tumwatamwaꞌasini miho lei tapa tenge tiki rini mi owekondauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wowani Jisas ri himache le funda rini ga wu daro ti, wu heiwani sumbu fo sukwakondawani ya wu sawe, “Apukolaka, nui gipi huwe ki wunu nu yenoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ete wu sawekoni wui nindo ki hima forito puris hima i apukolaka ri tau ra himache forini yekoni tapa mama tokwe pe wasamba rihi ni yekutowani ete sika. ");
INSERT INTO kwj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wowani Jisas o hinga ri heikoni ya ri sawe, “O sumbu hinga ya ma ete hanjaꞌai.” Wosini ori hima i wasamba tiki tapa ti ri torowani wasamba rihi ti kipe ya ai rini wosi. ");
INSERT INTO kwj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wosini rini toroni inji ki wu taro puris hima laka le, Gotri aka laka aulindau hima laka le, e, hima mekupu laka leni mwanji ti ya wunu ri sawe, “Ku ani toroꞌinji ki hachangipi huwe lenga me kumbo lenga ku nangini ku taro ti, hili ya hima forini ku toroꞌinji kinani ku taroꞌo? ");
INSERT INTO kwj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gisi gisi Gotri aka laka we tiki kunu ga ete a dawani tapa kuhi tiki ku ani toro nambwe. Woro apa kui gisi sairo, o keke hundu ti kwambu tito aulindau.” ");
INSERT INTO kwj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","O hinga ri bwasini ri dawani rini wu toroꞌinjini ya wu raꞌai. Wosini puris hima le wui apukolaka aka tiki ya rini wu rakaru. Wondawani Pita wunu ri sirinani ri ini apahime hinga ya ri da. ");
INSERT INTO kwj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ele hima aka tini haweini injiro ini we ki hi laka ti wu diyasini ya wu linindani hi ya wu waruꞌunda. Wondawani Pita okwe ri ini wunu ga ya ri liti. ");
INSERT INTO kwj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Wosini Pita hi ti ri waruꞌundawani tau ra humwe foti rini heini miya ti rini dorinasini ya rini sawe, “Do hima Jisas ga daro.” ");
INSERT INTO kwj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ete wowani Pita minambwe ri nandau tinga ya ri sawe, “Mina, ani rini a hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Da hinga wokoni hima fori ai rini heikoni ya ri sawe, “Mini okwe ri hima kupu fo.” Wowani Pita ya sawe, “Kale che, ani mina.” ");
INSERT INTO kwj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ete wowani amwa funda hinga iwani hima foringa ai rini heisini ya ri sawe, “Mwe naha, dori hima okwe rini ga daro. Hinde wowani rini Galili pe hima.” ");
INSERT INTO kwj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wowani Pita ya sawe, “Kale che, dohaꞌa mwanji mi bwandau ti ani a hikisandau.” O mwanji hinga ete ri bwandawani apwetoko ti ya gi. ");
INSERT INTO kwj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Wowani Apukolaka jamekoni Pita ni ya ri hei. Ete wowani Pita imbihumbwa Apukolaka rini sawesiro ka mwanji ni ya ri ai hambwa, “Apa do niliki apwetoko gi nambwe dawa numbo namili ai hi tini mi hamisakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita hoko tokwe ai raruni au laka ya ri ichaka. ");
INSERT INTO kwj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisas ni heini aulindaro himako rini wu saweholiyani ya rini yenda. ");
INSERT INTO kwj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wosini nikaꞌari sumbu ti miya tiki rini wu injisini rini wu ye ye ya rini wu sawe, “Ma nunu sawe, namoto mini yendau?” ");
INSERT INTO kwj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wosini mwanji miyafo naha kapwa tokwe ya rini wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wondawani nika ti sukwawani Isurel pe mekupu hima laka le, puris hima laka le, e, lo mwanji hambwandau hima laka le tani ya wu wau. Wosiwani Jisas ni ele kanisol hima le wauro aka ki raꞌaiwani ya wu sawe, ");
INSERT INTO kwj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ma nunu mi sawe to. Mini Kuraisiꞌi, mina?” Ete wowani ya wunu ri sawe, “E, kunu a sawewa sembe apa hinde ku ha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E, mwanji fwele kunu a siliwa, mwanji wasa ti hinde apa ku ani sawe kumbwa. ");
INSERT INTO kwj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Woro apa ki ambwesini ete i ini Hima ri Che dori ele kwambu ga dau Gotri tapa mama tokwe ya ri linindakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wowani wunu tinda ete ya wu sawe, “O hinga ti nawa, mini Gotri che mwe nahaꞌa?” Wowani ya wunu ri sawe, “Kunjenga ete ku sawendau, ori ando.” ");
INSERT INTO kwj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wowani ya wu sawe, “Apa mwanji anandi fo nu ai mendi hinga, mina. Ri takisopo tiki ka hinga ete ri sawewani nu mendihiro.” ");
INSERT INTO kwj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ete wosini wunu tinda ete wu saini rini wu rani Pailat apukolaka tambwa ya wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wosini rini wu kotimwokoni ya wu sawe, “Nunu dori hima nu heiwani nui hima kupu lei sembe tini yeni rasaini kapwa numbo ki wunu ri raꞌaindau. Wondani takisi ya ti Sisa apukolaka ni nu ha kinani minambwe nunu naro. Wosini rinjenga ya ri sawenda, rini rindombwa Kurais, king apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wowani Pailat ya rini sili, “Mini Juta hima kupu lei king apukolakaꞌa?” Wowani rini ga Pailat ni mwanji wasa ya ri sawe, “Minjenga o mi sawenda to.” ");
INSERT INTO kwj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ete wowani Pailat puris hima laka ga ele himiyama hurahama ga wunu ni ya ri sawe, “Ani dori hima i kapwa sumbu fori a wakini ani hei numbwa.” ");
INSERT INTO kwj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ete wowani wunu ga mwanji kwambu ki ka hinga ya wu sawe: “Rini ele Jutiya mapwa hinga tinda ete ri ini ele himiyama hurahama wui sembe ni yeni rasaini au mu sindau. Galili mapwa ki ri ambwesini o sumbu numbwa ri wo wo ri ta tani ahaꞌa.” ");
INSERT INTO kwj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wowani Pailat o mwanji wuhi ni ri mendini ya wunu ri sili, “Dori hima rini Galili kipe himaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wowani ya wu sawe, Jisas Herot aulindau nuwe tipa kipe. Ete wowani Herot tambwa ya rini raꞌai. Ka gisi Herot okwe Jerusalem ko ki ri daro. ");
INSERT INTO kwj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wowani Herot Jisas ni heini ya ri eripeꞌaripe. Hinde wowani, ri mwanji suwa numbwa ri mendindani gisi huwe laka hinga rini hei kinani ri nikisindaro. Rini Jisas kwambu chele sumbu fo ri wosiwa ri hei kinani ri okokonandau. ");
INSERT INTO kwj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O keke Herot mwanji miyafo naha ya rini silineheinda. Wowani Jisas mwanji wasa fori rini bwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wondawani puris hima laka lenga Gotri lo mwanji hambwandau hima laka lenga wu tani takai wu etisini hapa tinga uchani ya rini wu kotimwo. ");
INSERT INTO kwj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ete wowani Herot ga ele ri au anaye himache lenga horukwe sumbu rini wu wosi wosi ya rini wu saweholiyanda. Wosini nikaꞌari kipe naha foti wu ratani rini wu injisini Pailat tambwa rini rumbwewani ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Injelembwa Herot Pailat ga fi anaꞌomwemendindaro. Woro apa do gisi kumbwa fini nau fi anatororo. ");
INSERT INTO kwj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wowani Pailat puris hima laka le, mekupu hima laka le, e, ele himiyama hurahama okwe wunu ri uchawani wu tani ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ete wowani ya wunu ri sawe, “Kunu dori hima ani tambwa ku ratasini ete ku sawero, rini himiyama hurahama lei sembe ni ri yeni rasaini kapwa numbo ki wunu ri raꞌaindau. Wowani o mwanji ni kui miyaningisopo naha ki do rini a sili. Woro ma mendi. Ani dori hima ni a wakini ku kotimworo kapwa sumbu fo rini ki ani hei numbwa. ");
INSERT INTO kwj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot okwe o hingambwa. Wofunu rini humbweꞌiwani nunu tambwa ai taro. Ma mendi, dori hima kapwa sumbu naha fo ri woro ti nawa, apa rini nu yewa ri hano. Woro rini yewa hano kapwa sumbu hinga fo rini ani hei nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nimba rini a tanambwasini rini ani hanjaꞌaiwa sa ri i.” ");
INSERT INTO kwj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ka gisi ki Pailat ga ele himiyama hurahama ga mwanji fo ka hinga wu injisinda: Pasofa gisi laka ki Pailat kalapus hima forini ri hanjaꞌaiwa wunu tambwa ino. ");
INSERT INTO kwj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wowani ele himiyama hurahama ga wunu ga hapa tinga wu uchani ya wu sawe, “Ori hima ma yewa sa ha, wosini Barapas ni ma hanjaꞌaiwa nunu tambwa sa ta.” ");
INSERT INTO kwj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barapas rini ko laka ki gapiman hima laka leni au mu ti ri sisini hima ni yewani haro. O keke kalapus tiki rini wu rawaruro. ");
INSERT INTO kwj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Woro Pailat Jisas ni ri hanjaꞌaiwa i kinani mwanji fonga ya ai wunu sawe. ");
INSERT INTO kwj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ete wowani wu uchani ka hinga ya wu sawe: “Me yapweke tiki ma rini ye! Me yapweke tiki ma rini ye!” ");
INSERT INTO kwj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wowani numbo namili ya ai wunu sawe, “Hinde wowani? Dori hima bwele kapwa sumbu foni ri woro? Ani rini nu yewa hano kapwa sumbu fo ri woro ani hei numbwa apa nu yewa ri hano. O keke nimba rini a tanambwasini ani hanjaꞌaiwa sa ri i.” ");
INSERT INTO kwj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ete wowani Jisas ni me yapweke tiki ri yewa ha kinani hapa tinga ete ya wu ucha. Wu uchani wu sawero ata ti Pailat mwanji ni yekicharo. ");
INSERT INTO kwj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wofunu Pailat wui mwanji numbwa ya ri sirina. ");
INSERT INTO kwj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ele himiyama hurahama kalapus tiki daro hima ni wu ai raꞌai kinani rini wu uchawani ori hima ni ri hanjaꞌaisiwani wunu tambwa iro. Kari hima ko laka ki gapiman hima laka leni au ti ri sisini hima ni ri yewani haro. Wosini Pailat Jisas ni wui inaka tini sirinani wui tapa tenge tiki ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wowani Jisas ni wu ye ki wu raꞌaindau numbo ki Sairini ko kipe hima fori, Saimon, rini ni ya wu toro. Saimon rini ri ko cheche ri andosini Jerusalem ko laka tokwe ri raru kinani apambwa taro. Wosini Jisas ri me yapweke ti wamwaꞌangu tenge rihi tiki wu owesiwani ri kichani Jisas ni sirinani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wondawani himiyama hurahama miyafo naha rini sirinani wu indawani humwe fwele wu ichaka ichaka rini keke hukwa wu ra ra ya wu inda. ");
INSERT INTO kwj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ete wowani Jisas jamekoni ele humwe ni ri heini ya wunu sawe, “Kunu Jerusalem kipe humwe, kunu apa ani keke ku ichaka kei. Mina. Kunu keke kunjenga ku ichakandani kui che le keke ma ku ichakanda. ");
INSERT INTO kwj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ma mendi, ichai gisi fo sukwawa ka hinga o wu sawekonda, ‘Cherangifarangi ete dau himiyama le, che ra nambwe himiyama le, e, che ni muku handa nambwe himiyama le, wunu sa wu eripeꞌaripe.’ ");
INSERT INTO kwj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Woro o gisi ki himiyama hurahama le kimba leni ete wu sawekonda, ‘Kunu nui tape tenge tiki ma huwani sika!’ Wosini ele kimba cheche ni o wu sawekonda, ‘Kunu ma huwani sikani nunu yekicha!’ ");
INSERT INTO kwj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Apa me sumbwe ni o sumbu hinga wu wosikondau ti nawa, rikaꞌairo me ni bwele sumbu hinga wu wosikondau?” Jisas o hinga ya sawe. ");
INSERT INTO kwj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wunu kapwa sumbu wondaro hima fisi okwe Jisas ga funda fini wu ye ki ya wu raꞌainda. ");
INSERT INTO kwj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wu ini michi foki ya wu raru, o michi mwe hi ti, Hima Mwa Hapa. O michi naha ki me yapweke tiki ya rini wu ye. Wosini o kapwa hima fisi okwe ya wu ye, hima fori Jisas tapa mama tokwe wu yeni forini tapa yanji tokwe ya wu ye. ");
INSERT INTO kwj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wosiwani Jisas ya sawe, “Yapai, mini wui kapwa sumbu ma rani rumbwe. Hinde wowani, wunu do wu wosindau sumbu wu hikisandau.” Wosiwani wunu minga ti wu hei hei nikaꞌari rihi leni hisiwasi ya wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wondawani ele himiyama hurahama wu etisini ya wu heinda. Ete wondawani mekupu hima laka ele ka hinga ya rini wu saweholiyanda: “Rini hima ba fweleni ri okulandaro. E, rini mwe naha Gotri ondiyasiro hima, Kurais, nawa, rinjenga sa ri ai okula.” ");
INSERT INTO kwj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wondawani au anaye hima le okwe rini ni ya wu saweholiyanda. Wosini takai wu tani awani fu indau waini uku ti a kinani rini hasini ");
INSERT INTO kwj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ka hinga ya rini wu sawe: “E, mini Juta hima kupu lei king apukolaka mwe naha nawa, minjenga ma ai okula.” ");
INSERT INTO kwj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Himiki foti mwa tuwo rihi tiki kau yesiro ti ka hinga sawe: Dori hima rini Juta hima kupu lei King Apukolaka. ");
INSERT INTO kwj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wowani kapi kapwa hima fisi me yapweke tiki wu yero pi, forito Jisas ni ka hinga ya ri saweholiya: “Mini ka Gotri ondiyasiro hima, Kuraisiꞌi? Wowa minjenga mi okulani, ma ete sini okula.” ");
INSERT INTO kwj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wowani angi tokwe enindau hima rito o mwanji ni ri mendini mwanji kwambu naha ki ya rini bwa, “Gotri ni mi akinda nambweꞌe? Mini okwe ri randau nomo hingambwa o mi randa. ");
INSERT INTO kwj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sini ni wu yewa si hawa o sumbu kipe. Hinde wowani, sini do nomo si randau ti, o kapwa sumbu si woro chiki hingambwa si randau. Woro dorihaꞌa hima to kapwa sumbu fo ri wo nambwe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wosini ya ri sawe, “Jisas, ichai ko mihi ki mi ai rauwa, ani ni ma hambwa.” ");
INSERT INTO kwj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wowani Jisas ya rini sawe, “Mwe naha ki mini a sawendau: Mini apa naha ki ete ani ga ka ko kipe naha ki si dano.” ");
INSERT INTO kwj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wosiwani nika ti gondi naha ki ya da. Ete wondawani tapwaki nika ti usungwahawani hundu tombwa sirani ele nuwe mapwa hinga tinda yohosini ete da dawani 3 kilok hinga ya ete i. ");
INSERT INTO kwj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wosiwani Gotri aka laka ki yekichinasiro nikaꞌari laka ti nindo naha ki lefeheni tokwe tokwe ya i. ");
INSERT INTO kwj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Wokowani Jisas hapa tinga uchani ka hinga ya sawe: “Yapai, ai himamwale ti mi tapa tenge tiki o ani owenda.” O hinga ri sawesini ete ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wowani au anaye hima lei wui apukolaka o sumbu ni ri heikoni, Gotri hi tini ri rasaini ya ri sawe, “Mwe naha, dori hima rini hima kipe naha.” ");
INSERT INTO kwj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wondawani ele himiyama hurahama rini ni wu hei kinani wu tani wu wauro ti, ele sumbu hinga sukwawani wu heikoni sembe amwaka wu akoni inaka wuhi ti wu yetupwa yetupwa ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wondawani Jisas ri nau lenga ele humwe Galili ko ki wu ambwesini rini wu sirinani wu taro humwe lenga wunu tinda ete apahime hinga wu etisini ele sumbu hinga tinda ete sukwandaro ti ya wu heinda. ");
INSERT INTO kwj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Woro ka gisi ki hima fori ya da, hi rihi ti Josep. Rini Juta hima kupu lei ko laka fo, hi ti Arimatiya, o ko kipe. Rini kanisol hima fo, wosini rini sumbu kipe wosindau hima kipe naha. ");
INSERT INTO kwj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Woro rini kanisol hima fwele i inaka ga wui sumbu ga kipe ri ohouna nambwe. Rini Gotri aulindau kwambu numbwa ri nikisindau. ");
INSERT INTO kwj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Woro ori hima to Pailat apukolaka tambwa ri ini Jisas hima tape ni ri raꞌaini ri si kinani ya rini sili. ");
INSERT INTO kwj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wosini Jisas hima tape ti ri rasikasini nikaꞌari wamwa foki rini benisini matimat ki ya rini si. Ka matimat o humokuto laka fotini wu goro. Wosini imbihumbwa hima foni o ki wu si nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ka gisi Furaide, sunduya ki sukwakondau himati gisi keke mwaꞌambwe leni otokunandau gisi. ");
INSERT INTO kwj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ele humwe Galili ko ki wu ambwesini Jisas ni wu sirinani wu taro humwe le Josep ni sirinani wu ini o matimat ki Jisas hima tape ti Josep hinde na hinga ri siro ti norukweni ya wu ai hei. ");
INSERT INTO kwj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wu heisini wui aka lengu tokwe ya wu ai i. Wosini kuwa kipe tandau marasini tinga weli tinga ya wu otokunanda. Wosini himati gisi ki lo mwanji sawero hingambwa ya wu himati. ");
INSERT INTO kwj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wosini mwaseni saindau gisi, Sande, ki nurumbumbwa ete wu saini matimat tokwe ya wu i. Wu ikoni mwase ele wu otokunasiro kale kuwa kipe tandau mwaꞌambwe le funda wu rani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wu ini wu heiwani o humokuto sopu ni ichakisiro humokuto beiye laka oti tukwasinda. ");
INSERT INTO kwj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wosiwani wu raruni kwai wu heiwani Apukolaka Jisas hima tape ti da nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wofunu inaka tenge miyafo wu hambwafuni wu ambwatisini ya wu eninda. Wondani wu heiwani hima fisi wunu ki takaini ya fi eninda, nikaꞌari fihi ti funda ete hi hinga okuni taiyandau. ");
INSERT INTO kwj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wondawani ele humwe wu akini miyaningisopo wuhi ti nuwe tokwe ya wu rakai. Wowani opi hima fisi ya wunu sawe, “Hinde wowani himamwale tinga dau hima ni ku wakini do hima siro michi tiki ku taro? ");
INSERT INTO kwj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rini ahaꞌa ki da numbwa. Rini ri ai sairo! Woro kunu ka Galili ko ki ri dani kunu ri sawero mwanji ni ya ma ku ai hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ka hinga kunu sawero ti: ‘Dori Hima ri Che kapwa sumbu wondau hima lei tapa tenge tiki o rini wu hakonda. Wowa wundo me yapweke tiki o rini wu yekonda. Wosiwa gisi namili iwa ori ai saikonda.” ’ ");
INSERT INTO kwj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wowani Jisas imbihumbwa wunu sawero mwanji ni ya wu ai hambwa. ");
INSERT INTO kwj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wosini o matimat wu hanjaꞌaisini ya wu ai i. Wu ini ele tapaꞌangi tapaꞌangi hatachi funda Himache rihi lenga ele hima ba fwelenga wunu ni ele sumbu wu heiro leni ya wunu sawenda. ");
INSERT INTO kwj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kale humwe hi wuhi ti, Makitala pe Mariya, Joana, e, Jemis nuwai Mariya. Woro wunu ga ele humwe ba fwele okwe ri Himache leni o mwanji ni wu sawero. ");
INSERT INTO kwj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wowani ele ri Himache ya wu hambwa, dele humwe mwanji leni nimba wu gambondau. Wosini wui mwanji tini mwe naha wu na nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Woro Pita to ri saini namani matimat tokwe ya ri i. Ri ini o humokuto sopu ni ri maruni ri heiwani nikaꞌari letombwa ya kwai da. Wosini o mwaꞌambwe ri heiro ni inaka miyafo ri hambwandani aka lengu tokwe ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Woro o gisi kumbwa wui nindo tiki hima fisi findo ko cheche foki ya fi i, o ko cheche hi ti, Emeyas. Ka numbo Jerusalem ko laka hanjaꞌaisini Emeyas ko tokwe indau, 11 kilomita ambwe hinga. ");
INSERT INTO kwj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Numbo ti fi i i ele sumbu hinga sukwaro ni fi anambwa anambwa ya fi inda. ");
INSERT INTO kwj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Fi i i mwanji ti fi bwa bwa anasili sili fi indawani Jisas fini takai ki sirani fini ga funda ya wu i. ");
INSERT INTO kwj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Woro fi miya ti ichakisiwani Jisas ni fi hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Wowani Jisas ya fini sawe, “Bwele mwanji tini bwa bwa ki indau?” Ete ri nawani sembe nomo fi akoni ya fi eti. ");
INSERT INTO kwj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wowani hima fori, hi rihi ti Kiliopas, rindo mwanji wasa ti ya rini sawe, “Jerusalem ko ki mi daro ti, mindombwa dele gisi hinga o ko laka ki sukwandaro sumbu ele ni mi hikisandauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O hinga ri sawewani Jisas ya fini sili, “Bwele sumbu tito sukwaro?” Ete wowani ka hinga ya rini fi sawe: “Ka Nasaret pe hima Jisas ki sukwaro sumbu ni si sawendau. Rini Gotri mwanji bwarakarandaro hima, woro Gotri miyaningisopo tiki, e, himiyama hurahama lei miyaningisopo tiki mwanji ri bwandaro tinga sumbu ri wosindaro tinga ele sumbu ni kwambu omwesika tinga ri wosindaro. ");
INSERT INTO kwj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Woro nui puris hima laka lenga mekupu hima laka lenga ori hima ni gapiman tapa tenge tiki rini wu owesini rini yeni si ki mwanji ti wu injisiwani me yapweke tiki rini wu yero. ");
INSERT INTO kwj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nunu imbihumbwa ka hinga nu hambwandaro: ‘Kari hima to nunu Isurel pe hima lei nomo ni ri rani ri rumbwewa nu lalaunano.’ Woro mwanji fonga o da. O sumbu hinga sukwaro ti, gisi ti apa namili hinga ya inda. ");
INSERT INTO kwj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wosiwani apa chumbwa nurumbu nui hima kupu humwe fwele wu tani nunu sawewani nu apapanaro. Ele humwe nurumbumbwa kwandi tinga matimat tokwe wu iro. ");
INSERT INTO kwj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Wu ini Jisas hima tape dinga ti wu hei nambwe. Wosini wu ai tani ya wu sawe, ‘Nu ini ensel fopini nui miya kumbwa nu heiwani ete nunu sawe, “Jisas himamwale tinga dau.’” ");
INSERT INTO kwj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wosiwani nui nindo tiki daro hima fwele saini matimat tokwe wu ini heiwani himiyama le sawero sumbu hingambwa. Woro rini wu hei nambwe.” ");
INSERT INTO kwj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wowani Jisas ya fini sawe, “Kini ambwatinambwati naha. Kale Gotri mwanji bwarakarandaro hima le sawero ele mwanji hinga tinda ete sembe ku handa nambwe. Kini inaka kihi ti emendiki naha. ");
INSERT INTO kwj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hinde wowani ki hambwa nambwe, mwe naha ka hinga wu sawero ti? E, Kurais amwaka ti ri mendisinimbwa Gotri ki hi omwesika rihi ri torono.” ");
INSERT INTO kwj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wosini Moses kairo chengi le, e, ele Gotri mwanji bwarakarandaro hima le kairo chengi le, ele chengi ki ri ambwesini ele Gotri chengi hinga ki rini ni bwaro mwanji mu mwe ti ya wunu ri sawekawe. ");
INSERT INTO kwj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Woro wu ini o fi indau ko ti ya wu takai. Wowani Jisas ete ri inda ki ya ri wo. ");
INSERT INTO kwj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wowani findo rini fi torosisini ya sawe, “Mini sini ga ma da. Nika ti raihiro, ya hundukonda.” Wowani ri heifuni ri raruni fini ga ya ri da. ");
INSERT INTO kwj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wosini ahirahi ti wu akoni Jisas fini ga litisini bereti ri rukosini Gotri ni ri weseꞌasini ri lepikani ya fini ha. ");
INSERT INTO kwj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","O hinga ri wosiwani sembe we pe miya fihi fi ripawani ya rini fi hambwa. Wowani o ki ete ri gainasiwani rini fi ai hei nambwe. ");
INSERT INTO kwj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wowani ya fi anambwa anambwa, “Numbo tiki nu tandani nu anambwandawani Gotri chengi pe mwanji mu mwe ti sini ri sawekawendaro ti, ka gisi naha ki sembe sihi ti hi hinga ete saindaro.” ");
INSERT INTO kwj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","O hinga fi bwasini fi saini metengei Jerusalem ko tokwe ya fi ai i. Fi ini fi heiwani ele tapaꞌangi tapaꞌangi hatachi funda Himache lenga wui nau fwelenga funda wu wausini ");
INSERT INTO kwj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ya wu sawenda, “Apukolaka mwe naha ai saisini Saimon mu ki ri sukwaro.” ");
INSERT INTO kwj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wowani fini ga ele numbo tiki sukwaro sumbu ga bereti ri lepikandawani rini ni fi hambwaro sumbu ga ya wunu fi sawe. ");
INSERT INTO kwj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","O mwanji hinga ni ete wu bwandawani Jisas wui nindo tiki ri sukwani ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wowani rini wu heikoni wu apapanani ya wu aki. Wunu ete wu hambwaro, oti ambusuwa to siraro. ");
INSERT INTO kwj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wowani ya wunu ri sawe, “Hinde wowani ku apapanandau? Hinde wowani inaka fisi ku hambwandau? ");
INSERT INTO kwj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Seke tapa ahi ti ma hei. Ando a dau. Tapa kuhi ma ku ani toromendinehei. Ambusuwa ti do ku ani heindau hinga hima tape tinga hapa tinga da nambwe.”  ");
INSERT INTO kwj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O hinga ri bwakoni ri seke tapa ti ya wunu ri meku. ");
INSERT INTO kwj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wowani ya wu eripeꞌaripe. Woro sembe ti mwe naha wu ha nambwe ete wu wohambwakahambwandawani ya wunu ri sawe, “Hinde, kunu ahirahi fwele dohaꞌa ki dauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wowani wu turo fwaiꞌomwe tipa foti ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wowani oti ni toroni wui miyaningisopo ki ya ri a. ");
INSERT INTO kwj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wosini ya wunu ri sawe, “Imbihumbwa kunu ga a dani ka kunu a sawe to: Moses kaisiro Gotri lo mwanji, ele Gotri mwanji bwarakarandaro hima kairo chengi, e, Sam chengi, ele chengi hinga ki sawero mwanji hinga tinda ete mwe mwe naha o sukwakonda.” ");
INSERT INTO kwj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wosini Gotri chengi ni wu hambwa kinani inaka wuhi ri wosiwani wulisiwani ");
INSERT INTO kwj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ya wunu ri sawe, “Gotri chengi ka hinga sawero: Kurais amwaka ri mendisiwa gisi namili iwa matimat tiki ri ai saino. ");
INSERT INTO kwj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wosiwa ri hi tukumbwa do nuwe mapwa laka kipe hima leni Gotri mwanji kipe wu bwandawa kapwa sumbu wuhi gumwa wu sisini sembe Gotri ni wu hawambwa Gotri wui kapwa sumbu ti ri rani ri rumbweno. Woro do tau hinga Jerusalem ko tiki metengei wu rasaikonda. ");
INSERT INTO kwj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kunu dele sumbu hinga ni ku heini ku mendiro ni amwei o ku sawekonda. ");
INSERT INTO kwj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma mendi. Ka mwaꞌambwe Yapai kunu ha ki bwasiro ti, apa kunu tambwa a rumbwewa o sikakonda. Kunu do ko laka ki ma ete ku dawa hewen pe kwambu ti kunu tambwa tani sa kunu yoho.” ");
INSERT INTO kwj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wosini wunu ri raꞌaini Betani ko tiki wu ambwesini ri tapa ti ri rasaini Gotri kwambu wu toro kinani mwanji ti ya wunu ha. ");
INSERT INTO kwj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","O sumbu hinga ri wo wo wunu ri andosiwani Gotri hewen ko tokwe ya rini rakau. ");
INSERT INTO kwj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wosiwani eripeꞌaripe omwesika tinga Jerusalem ko tokwe ya wu ai i. ");
INSERT INTO kwj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wosini gisi gisi wunu Gotri aka laka tiki Gotri hi tini ya ete wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Do nuwe wosi nambwe gisi tiki Mwanji ti ete daro. Do Mwanji Gotri ga daro. Woro o Mwanji to Gotri. ");
INSERT INTO kwj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Metengei naha do Mwanji Gotri ga daro. ");
INSERT INTO kwj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rini naha kumbwa Gotri dele mwaꞌambwe hinga tinda ete ri wosiro. E, mwaꞌambwe foti numbo foriki sukwa nambwe. Mina. Ele mwaꞌambwe hinga tinda ete rini kumbwa sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Rini ki himamwale dau. Wondauku himamwale oti hima leni lindana ti handau. ");
INSERT INTO kwj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lindana oti hundu tiki okundau. Wondawani hundu ti o tini ichakinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hima fori ya ta. Hi rihi ti, Jon. Gotri to rini humbwewani ri taro. ");
INSERT INTO kwj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri taro ti, ka lindana ni amwei ri sawewa hima le ri mwanji ni wu mendini Gotri ni sembe ti wu ha ki. ");
INSERT INTO kwj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Rinjenga ka lindana, mina. Rini nimba o lindana ni amwei ri sawe ki ri taro. ");
INSERT INTO kwj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka lindana mwe naha, ele himiyama hurahama ni taiyandakonda. Woro o to do nuwe ki ya takonda. ");
INSERT INTO kwj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wosini do nuwe ki ya ri da. Gotri rini kumbwa do nuwe ri wosiro. Woro nuwe pe himiyama hurahama le rini ni wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ri ko tokwe ri tawani ri hima kupu le rini toroni rakaru nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Woro hima fwele rini rakaruni sembe rini numbwa wu haro keke Gotri ri che hinga wu waꞌaino kwambu ti ya wunu ri ha. ");
INSERT INTO kwj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Woroti nuwai yapai fi tiki, hima tape okokona ki, e, hima i inaka ki Gotri che hinga wu sira nambwe. Mina. Gotri tombwa rinjenga wunu ri wosiwani ri che hinga wu siraro. ");
INSERT INTO kwj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ka Mwanji to hima minde hinga sirasini nui nindo ki ya da. Wosiwani ri kwambu omwesika laka ti nu heiro. Kwambu mwe ti, Gotri Che funda naha i ri kwambu, woro Yapai to rini humbwewani ri taro. Rini ki hima keke wo sumbu tinga mwanji mwe naha mu tinga talesindau. ");
INSERT INTO kwj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ori hima ni amwei ri bwandani ka hinga uchani ya ri sawe: “Injelembwa ka ete kunu a sawero hima mwe ri ori to, ‘Ai gumwa ki takondau hima ri rindo apukolaka. Hinde wowani, ani ra nambwe dawani rini injelembwa ete ri daro.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rini ki talesiro hima keke wo sumbu rihi ki nunu tinda ete funda funda ele mwaꞌambwe kipe naha rihi nu torosindau. ");
INSERT INTO kwj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hinde wowani, Gotri ri lo mwanji ti Moses i tapa tenge tiki nunu haro. Woro hima keke wo sumbu tinga mwanji mwe naha mu tinga Jisas Kurais ki sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hima fori Gotri miyaningisopo ti gamweche ri heinda nambwe. Minambwe naha. Woro Gotri ni takaisini dani rini hinga dau ka ri Che funda naha tombwa Gotri nunu ri mekusiro. ");
INSERT INTO kwj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem ko ki dau Juta himako i mekupu hima le wui puris hima fwelenga Lifai hima fwelenga wunu humbwewani wu ini Jon ni ya wu sili, “Mini namo?” ");
INSERT INTO kwj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wowani Jon mwanji foti ri yani nambwe, hima amwei tiki hapa tinga uchani ya ri sawe, “Ani Kurais mina.” ");
INSERT INTO kwj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ete wowani ya rini wu ai sili, “Wo o hinga ti nawa, mini Ilaichaꞌa?” Wowani ya ri sawe, “Mina.” Wowani ya wu ai sawe, “Wo mini ka Gotri mwanji bwarakarano hima mindoꞌo?” Wowani mwanji wasa ya wunu ri sawe, “Mina.” ");
INSERT INTO kwj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wofunu ka hinga ya rini wu sawe, “Wo mini namo? Ma nunu sawewa nunu humbwero hima le tambwa o mi mwanji nu raꞌai. Wo minjenga hinde hinga mi sawendau?” ");
INSERT INTO kwj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wowani Jon ya sawe, “Ani imbihumbwa Gotri mwanji bwarakarandaro hima ri Aisaiya ka hinga bwaro hingambwa a dau, ‘Hima fori hima da nambwe michi tiki ri uchani ka hinga o ri sawenda: Apukolaka keke numbo ma ku wonorukwesiwa sa ri ta.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wosiwani Farisi hima leto humbwero hima le tani ");
INSERT INTO kwj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ya rini wu sili, “Mini Kurais mina, Ilaicha mina, e, mini ka Gotri mwanji bwarakarano hima mina, wo hinde wowani dele himiyama hurahama ni uku ti wunu mi yasindau?” ");
INSERT INTO kwj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wowani Jon mwanji wasa ya wunu sawe, “Ani uku minde ki wunu a yasindau. Woro hima fori kui nindo tiki o ri da. Woro kunu rini ni ku hikisandau. ");
INSERT INTO kwj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hima mwe ri ai gumwa ki jepi jepi ori tanda. Woro ani hima kipe na numbwa ri su kupu ti a hungono.” ");
INSERT INTO kwj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ka sumbu Jotan gara angi tokwe dau Betani ko ki sukwaro. O gara kumbwa Jon ele himiyama hurahama ni uku wunu ri yasindaro. ");
INSERT INTO kwj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wosiwani lindanawani Jon heiwani Jisas rini tambwa ya ta. Wowani Jon ya sawe, “Ma hei, o bai hima rini Gotri Sipisip Che. Rindo apa do nuwe ki dau himiyama hurahama lei wui kapwa sumbu ri rani ri humbweno. ");
INSERT INTO kwj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dori hima ni imbihumbwa ka ete a sawe, ‘Hima fori ai gumwa ki ri tano ti, ori hima ai apukolaka. Hinde wowani, ani ra nambwe dawani imbihumbwa rindombwa ete daro.’ ");
INSERT INTO kwj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ani anjenga rini ani hambwa nambwe. Ani a tani dele hima ni uku minde ki wunu a yasindau ti, o hinde wowani, Isurel leni dori hima amwei wunu a meku kinani.” ");
INSERT INTO kwj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wosini Jon amwei naha ka hinga ya ri sawe, “Ani ani heiwani Gotri Himamwale ti hewen ko hanjaꞌaisini apwenumwa hinga sikani rini ki ya liti. ");
INSERT INTO kwj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ani anjenga rini ani hambwa nambwe. Ka ani humbwewani a tani ele himiyama hurahama ni uku minde ki wunu a yasindau, woro o hima to ani sawe, ‘Mi heiwa Gotri Himamwale sikani hima foi tenge tiki litiwa ya ma hambwa, ori hima ele himiyama hurahama ni uku ri yasino ti, Gotri Himamwale ki ri yasino.’ ");
INSERT INTO kwj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Woro anjenga o sumbu ni ani heisini a bwarakarandau: Dori hima rini Gotri Che.” ");
INSERT INTO kwj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","O gisi lindanawani Jon ai saini etiwani ri himache fisi saini rini ga ya funda wu eti. ");
INSERT INTO kwj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wosini wu heiwani Jisas wunu tambwa ya ri ta. Wowani Jon ya sawe, “Ma hei, kari bai hima Gotri Sipisip Che.” ");
INSERT INTO kwj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ete wowani opi ri himache fisi o mwanji ri bwawani fi mendikoni rini fi sirinani ya fi i. ");
INSERT INTO kwj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Wowani Jisas jamekoni fini heiwani rini fi sirinani fi tawani ya fini ri sawe, “Kini bwele mwaꞌambwe ni ki wakindau?” Wowani ya rini fi sawe, “Rapai, mini so aka ki mi dau?” “Rapai” hi ti ka hinga nu jamekondau: “Ondiyakandiyandau hima.” ");
INSERT INTO kwj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wowani ya fini ri sawe, “Ma ki tani ki hei.” Ete wowani fi ini o ri dau aka ti ya fi hei. Wosini o gisi nika tinga rini ga ya fi da. Hinde wowani, o 4 kilok sunduya hinga ihiro. ");
INSERT INTO kwj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anduru, Saimon Pita i analongo rini Jon mwanji ni mendini Jisas ni fi sirinani fi iro hima fo. ");
INSERT INTO kwj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Woro Anduru ri ini ri analongo Saimon ni metengei ri heini ya rini sawe, “Mesaiya nu heihiro.” “Mesaiya” hi ti nu jamekowani ka hinga: “Kurais.” ");
INSERT INTO kwj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wosini Anduru Jisas tambwa ya rini raꞌai. Ete wowani Jisas rini heini ya rini sawe, “Mini Saimon, Jon i che. Ichai hi ako mihi ti Sifas.” “Sifas” hi mwe ti nu jamekowani ka hinga: “Pita.” (Do mwanji “Pita” Kwanga mwanji ki jamekowa “Humokuto”) ");
INSERT INTO kwj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","O gisi lindanawani Jisas Galili mapwa tokwe ri i ki ri hambwandani Filip ni ri heini ya ri sawe, “Mini ma ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip rini Besaita ko kipe hima, woro Anduru hima pi Pita fini okwe o ko kipembwa. ");
INSERT INTO kwj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wowani Filip ini Nataniyel ni ri heini ya rini sawe, “Moses ka imbihumbwa Gotri lo mwanji ki hi rihi tini kaiwani Gotri mwanji bwarakarandaro hima le okwe o hi numbwa wu kaisiro hima ri, nu heihiro. Rini Nasaret ko kipe Jisas, Josep i che.” ");
INSERT INTO kwj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wowani Nataniyel ya rini sawe, “Wo bwele sumbu kipe fotito Nasaret ko ki sukwakondau?” Ete wowani Filip ya rini sawe, “Ma tani pwe bwe hei.” ");
INSERT INTO kwj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wowani jisas heiwani Nataniyel rini tambwa tandawani, ka hinga rini ni ya wunu ri sawe: “Ma hei, rini Isurel hima kupu lei nindo ki hima mwe naha fori. Mwanji gambo foti rini ga da nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Wowani Nataniyel ya rini sawe, “Hinde wowani mi ani hambwandau?” Ete wowani Jisas mwanji wasa ka hinga ya rini sawe, “Tambwa Filip mini ucha nambwe fik me mu ki mi linindawani o gisi ki mini ani heiro.” ");
INSERT INTO kwj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Wowani Nataniyel ga mwanji wasa ya rini sawe, “Ondiyakandiyandau hima, mini Gotri Che, Isurel lei King Apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ete wowani Jisas ga mwanji wasa ka hinga ya rini sawe, “Mwe naha ki o mini a sawenda, fik me mu ki mi linindawani mini ani heiro sumbu a sawero keke sembe ma haro. Woro ichai dohaꞌa sumbu cheche ni dikindau sumbu omwesika laka to sukwawa o mi heikonda.” ");
INSERT INTO kwj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wosini Jisas mwanji fonga ya ai rini sawe, “Mwe naha ki kunu a sawendau: Ichai hewen ko ti tukwawa ku heiwa dori Hima i Che tenge ki Gotri ensel le ya wu raususikasindakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wosiwani gisi fisi ini humbusiwani lindanawani hima fori Galili mapwa ki dau Kena ko ki humwe ti ya ri hopwekonda. Wondawani Jisas nuwai o michi ki ya ti da. ");
INSERT INTO kwj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisas ga ele ri himache ga wu uchawani wunu okwe humwe hopwekondau sumbu ni wu hei ki ya wu tasinda. ");
INSERT INTO kwj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dani ini waini uku ti humbusiwani Jisas nuwai ya rini sawe, “Dele himako waini uku nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wowani Jisas ya tini sawe, “O bai humwe, o ai tau, o ni tau mina. Ani amwa ahi ti ta nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wowani ri nuwai ele tau ra himache leni ya ti sawe, “E, mwanji fo ri bwawa, o mwanji numbwa ya ma ku sirina.” ");
INSERT INTO kwj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","O michi kumbwa humokuto ki wosiro tapaꞌangi hatachi funda hungwe le ya da. Hungwe mwe le, Juta hima le wui lo mwanji ni sirinani ele hinga ki uku wu yandau. Wunu funda funda 20 galen gikiꞌi 30 galen giki fwa ambwe hinga ete wu torondau. ");
INSERT INTO kwj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wosiwani Jisas ya wunu sawe, “Uku ti kale bai hungwe ki ma ku guto.” Wowani ele hungwe hinga wu gutowani ya tinda sukwatale. ");
INSERT INTO kwj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ete wosiwani ya wunu ri sawe, “Uku gamwe ma gutoni ahirahi aulindau hima tambwa ma ku raꞌai.” Wowani wu gutosini ya wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Wowani ahirahi aulindau hima ori o uku ri aneheiwani waini uku muningi hinga ya ri mendi. Woro rini hambwa nambwe, ka waini uku wu ratororo sumbu ti. Uku gutoro tau ra himache letombwa wunu hambwandau. Wosini ahirahi aulindau hima ori humwe hopwekondau hima o rini ya ri ucha. ");
INSERT INTO kwj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wosini ya rini sawe, “Ele hima hinga tinda ete waini uku kipe naha tini mwaseni wu haꞌi hatasiwani wu uchawani taro hima le o waini uku ni wu ani humbusiwanimbwa waini uku tako tokwe hinga tini gumwa ki wunu ai handau. Woroti mindo waini uku apambwa mi ratandau ti okwe kipe naha tumbwa mi rataro.” ");
INSERT INTO kwj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ka sumbu hinga Galili mapwa tokwe dau ko, Kena, tiki Jisas ri wosiro ti, kwambu chele sumbu ambwe sumbu ambwe metengei naha ri wosiro. Hi hinga okundau kwambu rihi ti ri himache leni o hingambwa wunu ri mekuwani wunu sembe ti rini ni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ete wosinumbwa Jisas ga ri nuwai ga ri hipache lenga, e, ri himache lenga Kapaneyam ko tokwe ya wu i. Wosini gisi fisi namili hinga o ko laka ki ya wu da. ");
INSERT INTO kwj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juta hima kupu lei Pasofa gisi laka takaiwani Jisas Jerusalem ko tokwe ya i. ");
INSERT INTO kwj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ri ini Gotri aka laka we tiki ri heiwani bulumakau, sipisip, e, apwenumwa leni hasini ya torondau hima le wu dawani, ya anaha anahani tau randau hima le tei wuhi ki kwai ya wu lininda. ");
INSERT INTO kwj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wondawani Jisas fekeleruhu hinga fotini ri rukoni tanambwandau kupu hinga ri wosisini Gotri aka laka we tiki daro omwe le, bulumakau lenga sipisip lenga, ya wunu yeni hoko tokwe ya ri rawaru. Wosini ya anaha anahani tau randau hima lei tei leni ri toroni ri jamekowani humokuto ya le yesinakoni ya salesi. ");
INSERT INTO kwj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wosini apwenumwa hasini ya torondau hima ele ni ya ri sawe, “Ele mwaꞌambwe kuhi ma ku raꞌai. Apa ai Yapai aka laka ti mwaꞌambwe wungwa jindau aka hinga ku wosi kei.” ");
INSERT INTO kwj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wosiwani ri himache le Gotri chengi tiki dau mwanji fotini ka hinga ya wu ai hambwa, “Mi aka ti kipe naha da kinani ani okokonandau ti, ai sembe hi hinga naha saindau.” ");
INSERT INTO kwj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wowani Juta hima kupu le o sumbu hinga wu heikoni ya rini wu sawe, “Kwambu chele sumbu ambwe foti ma nunu mekusiwa nu heitoni ete nu sawe, ‘Oto, do kwambu hinga tini mi torosini o sumbu hinga mi wosiro.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wowani Jisas ga mwanji wasa ti ya wunu ri sawe, “Do Gotri aka laka ma ku lendosiwa ani ga gisi namili naha tukumbwa ani ai rasaino.” ");
INSERT INTO kwj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wowani Juta hima kupu le mwanji wasa ya rini sawe, “Ka himame fisi ini tapaꞌangi hatachi funda asama ki wu kiro Gotri aka laka tini gisi namili naha kumbwa mindo mi ai rasainoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Woro ka Gotri aka laka mwanji Jisas ri sawero ti, oti ri hima tape tini yepero. ");
INSERT INTO kwj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Dani ini Gotri wa tiki rini ai rasaisiwani ri himache le imbihumbwa ri bwasiro mwanji ka tini ya wu ai hambwa. Wosini Gotri chengi tinga Jisas bwasiro mwanji o tinga sembe ti ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas Pasofa gisi laka ki Jerusalem ko ki ri dasini, himiyama hurahama i nindo ki kwambu chele sumbu ambwe sumbu ambwe ri wosindawani o tini wu heini ri hi ni sembe ti ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Woro Jisas sembe ti wunu owe nambwe, e, rinjenga wui tapa tenge tiki ri hima tape ti ri owe nambwe. Hinde wowani, ele hima hinga tinda ete ri hambwasindau. ");
INSERT INTO kwj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Rini hambwa ti keke heifunda nambwe, o keke hima forito tani hima foi sumbu ti rini sawehambwanda nambwe. Mina. Hinde wowani, rinjenga hima i inaka ti tinda ri hambwasindau. ");
INSERT INTO kwj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hima fori ya da, hi rihi ti Nikotimas. Rini Farisi hima fori, wosini rini Juta hima kupu leni aulindau kanisol fori. ");
INSERT INTO kwj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Woro kari hima Jisas tambwa niliki ri tani ya rini sawe, “Ondiyakandiyandau hima, nu hambwandau, Gotri to ondiyakandiyandau hima hinga mini humbwewani mi taro. E, Gotri hima foringa da nambwe nawa, dele kwambu chele sumbu ambwe le mi wosindau hinga hinde apa ri wosi kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wowani Jisas ga mwanji wasa ya rini sawe, “Mwe naha ki mini a sawendau, e, hima fori ai rini rawa ako naha sira nambwe nawa, Gotri aulindau kwambu ti hinde ri hei kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Wowani Nikotimas ya rini sawe, “Hinde hinga wowa mekupu tiro hima rito apa ai rini rawa ako naha sirano? Hinde, nuwai sembe we tiki ai ri rarusiwa che ako hinga ai rini ranoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Wowani Jisas mwanji wasa ya rini sawe, “Mwe naha ki mini a sawendau. Hima fori fwa tinga Gotri Himamwale tinga fini ki rawa ako naha sira nambwe nawa, ori hima hinga Gotri aulindau kwambu hinde apa ri raru kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hima tape tiki raro ti, oti hima tape. E, Gotri Himamwale ki raro ti, oti himamwale. ");
INSERT INTO kwj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Kunu ai rawa ako naha ma ku ai sira,’ do mwanji hinga kunu a sawero ti keke apa inaka tenge miyafo ku hambwa kei. ");
INSERT INTO kwj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E, ausuwa ti, ti okokona tumbwa sirinandani ele mapwa ele mapwa tokwe sindau. Wondawani ausuwa sindau ata tumbwa nu mendindani indau mapwa ti tandau mapwa ti nu hikisandau. Woroti Gotri Himamwale ki rawa ako naha sirano hima le okwe o sumbu hingambwa.” ");
INSERT INTO kwj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wowani Nikotimas ga mwanji wasa ya rini sawe, “Ka sumbu hinde hinga apa sukwano?” ");
INSERT INTO kwj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Wowani Jisas ga ya rini sawe, “Mini Isurel lei ondiyakandiyandau hima fori, woro dele sumbu hinga ni mi hambwanda nambweꞌe? ");
INSERT INTO kwj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mwe naha ki mini a sawendau. Nunu nu hambwandau mwanji tini nu bwandani nui miya tiki nu heiro sumbu leni amwei nu sawendau. Wondawani amwei nu wondau sumbu nuhi tini gumwanamwa ku sindau. ");
INSERT INTO kwj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ani do nuwe ki sirandau sumbu leni kunu a sawendawani sembe ku handa nambwe, e, hewen ki sirano sumbu leni kunu a sawewa sembe ti hinde hinga apa ku hano? ");
INSERT INTO kwj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hima fori hewen ko tiki raru nambwe naha. Woro hewen ko ki sikaro Hima i Che dori tombwa oto. ");
INSERT INTO kwj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Imbihumbwa Moses hima da nambwe michi tiki ka hopo ni ri rasaini kumbo tenge tiki ri owero. Woro hingambwa Hima i Che dori ni o hingambwa o wu wosikonda. ");
INSERT INTO kwj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wosiwa sembe rini ni wu hano himako ete da ete da himamwale ti wu torokonda. ");
INSERT INTO kwj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Gotri delehaꞌa nuwe pe himiyama hurahama le keke omwesika naha ri wondau ki ri Che funda naha wunu ri haro. O hinga ri wosiro ti, hinde na hima rito sembe rini ni ri hawa walambe hinde rini i kumbwa, ete da ete da himamwale ako ti ri torokonda. ");
INSERT INTO kwj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hinde wowani, Gotri dele nuwe pe hima leni ri kilini kapwa hima naha wunu ri na kinani ri Che ri ri humbwe nambwe. Mina. Hima leni ri ai rata kinani rini humbwewani ri taro. ");
INSERT INTO kwj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sembe rini ni haro hima ri, rini mwanji nambwe. Sembe rini ni ha nambwe hima ri, rini mwanji chele, kapwa hi ri torohiro. Hinde wowani, ka Gotri Che funda naha i hi ni sembe ri ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gotri kilindau sumbu mu mwe ti ka hinga: Lindana ti do nuwe ki sikaro, wosiwani hima le hundu tini wu okokonandani lindana tini wu diyaha. Hinde wowani, wui sumbu ti kapwa naha. ");
INSERT INTO kwj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hinde na hima fori kapwa sumbu ri wondau ti, lindana ni miho ri tangindani lindana tokwe ri ta ki ri diyahandau. Hinde wowani, lindana to kapwa sumbu rihi amwei rini wono keke ri akindau. ");
INSERT INTO kwj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Woro hinde na hima forito sumbu mwe naha ni ri sirinandau ti, lindana tokwe ri tandau. Wosiwa hima le amwei naha rini wu heini ya wu hambwakonda, Gotri kumbwa ele sumbu ri woro.” ");
INSERT INTO kwj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ka sumbu humbusiwanimbwa Jisas ga ri himache lenga Jutiya mapwa tokwe ya wu i. Wu ini o mapwa ki gisi fwele wu dani himiyama hurahama leni uku ti ya wunu ri yasinda. ");
INSERT INTO kwj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wondawani Jon okwe himiyama hurahama leni Selim ko takai ki dau Inon fwa tiki uku ti ya wunu ri yasinda. Hinde wowani, ka michi ki fwa miyafo naha dau. Wondawani himiyama hurahama le hopoye hopoyendani wu tani uku ti ya wu yanda. ");
INSERT INTO kwj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ka sumbu hinga sukwaro ti, Herot Jon ni kalapus ki ri rawaru nambwe gisi ki sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wondawani mwanji foti Jon himache lenga Juta hima kupu foringa wui nindo ki ya sukwa. Mwanji mwe ti, Juta hima lei uku ya sumbu mu ni wu anambwa anambwanda. ");
INSERT INTO kwj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wunu Jon tambwa wu tani ya rini wu sawe, “Ondiyakandiyandau hima, kari hima imbihumbwa Jotan gara kachi tokwe mini ga ri dawani ri hi mu mwe tini amwei mi sawero ti, apa ele himiyama hurahama ni uku ti ri yasindawani wunu tinda ete rini kekembwa ya wu inda.” ");
INSERT INTO kwj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wowani Jon mwanji wasa ka hinga ya ri sawe, “E, hewen ko kipe Gotri hima forini mwaꞌambwe ti rini ha nambwe nawa, rinjenga apa hinde ri toro kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imbihumbwa a sawero mwanji kati kui wasamba ki kunjenga ku mendiro, ‘Ani Kurais mina, ani Gotri to ani humbwewani rini keke mwaseni a taro.’ ");
INSERT INTO kwj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","E, hima forini hopwekondau humwe oti, o hima rihi. Woro humwe ni hopwekondau ka hima ni okulandau nau rihi fori ri etisini wasamba owesini ya ri wangasinda. Wondani humwe ni hopwekondau hima o ri ata tini ri mendikoni nimba ya ri eripeꞌaripenda. Woro o ri nau eripeꞌaripe sumbu hingambwa ai sembe ki sukwatalesindau. ");
INSERT INTO kwj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hi rihi ti heiye tokwe sa raundawa, hi ahi ti tako tokwe sa rainda.” ");
INSERT INTO kwj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hima ri me ki sikaro ti, rini ele mwaꞌambwe hinga tinda heiye tokwe ri dau. Woro hima ri nuwe ki ri sairo ti, rini do nuwe kipe, nuwe kipe mwaꞌambwe leni ri bwandau. E, hima me ki ri sikaro ti, rini ele mwaꞌambwe hinga tinda heiye tokwe ri dau. ");
INSERT INTO kwj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Rini ele ri heini ri mendiro mwaꞌambwe leni amwei ri bwandau. Wondawani hima forito o ri mwanji ni ri ratani inaka ki ri toronambusi nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Woro hima fori ka mwanji ni ratani ri toronambusiro ti, rini o sumbu hinga keke ka mwanji ni ri ohounandau, “Gotri rini mwanji mwe naha kumbwa ri bwandau.” ");
INSERT INTO kwj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kari hima Gotri rini humbwewani ri taro ti, rini Gotri mwanji numbwa ri bwandau. Hinde wowani, Gotri ri Himamwale tipache tumbwa rini ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yapai ri Che keke funda ete ri woni ele mwaꞌambwe hinga tinda ete ri tapa tenge ki ri hasindau. ");
INSERT INTO kwj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hima fori ori Che ni sembe hano ti, rini ete da ete da himamwale kipe ri torono. E, hima fori ori Che ni sawesiyaꞌaino ti, rini ete da ete da himamwale kipe hinde ri toro kumbwa. Minambwe naha. Gotri sembe enge a ti rini ki o ya ete dakonda. ");
INSERT INTO kwj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ka gisi kumbwa Farisi hima le mwanji foti ka hinga ya wu mendi: “Jisas ri himache hinga waꞌaisiwani uku wunu ri yasindau hima le miyafo naha sukwandani ele Jon himache ni dikisini indau.” ");
INSERT INTO kwj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Woro Jisas rinjenga uku ti ri yasi nambwe. Ri himache letombwa uku wu yasindaro. ");
INSERT INTO kwj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisas kale Farisi hima lei inaka ti ya ri mendi. Wosini Jutiya mapwa ri hanjaꞌaisini Galili mapwa tokwe ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Woro Sameriya ko nindo ki indau numbo ki ri i ki ri inaka ya rini ondiyasi. ");
INSERT INTO kwj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O Sameriya indau numbo ki ri ini ko laka foki ya ri raru. O ko mwe hi ti, Saika. Do Saika ko ti, imbihumbwa Jekop ri che Josep ni haro nuwe tipa ni takaisindau. ");
INSERT INTO kwj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Woro o ko ki Jekop uku ti kinani ri eiro wa ti ya da. Jisas ri indawani talihapa rihi ti rini mendifuwani o uku ti wa ki ya ri lininda. Woro nika ti gondi naha ki ya da. ");
INSERT INTO kwj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wondawani Sameriya kipe humwe foti o wa ki uku ti ki ya ti ta. Wowani Jisas ka hinga ya tini sawe, “Uku sumbwe ma ani hawa ani a.” ");
INSERT INTO kwj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ri himache le ahirahi ra ki ko laka tokwe wu iro. ");
INSERT INTO kwj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wowani Sameriya ko kipe humwe ya rini sawe, “Mini Juta hima kupu fo, e, ani Sameriya pe humwe, hinde wowani ete mi sawero, ‘Uku sumbwe ma ani hawa ani a’?” Hinde wowani, Juta hima kupu le Sameriya himako ga funda wu etinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wowani Jisas ga mwanji wasa ya tini ri sawe, “E, nini Gotri peresen tinga do uku sumbwe keke nini sawendau hima ga fini ni kipe naha ni hambwani ninjenga ori hima ni silipo himamwale ga dau uku sumbwe nini ri hakoro.” ");
INSERT INTO kwj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wowani o humwe ya rini sawe, “Apukolaka, mini hatumwa nambwe, do wa ki dau fwa kaimbwa naha. Woro ka himamwale ga dau uku soki mi ratakondau? ");
INSERT INTO kwj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nui atei Jekop do wa ni eisiwani elero fwa nunu ni ri haro. Woro metengei naha rini ga ri che lenga ele bulumakau sipisip lenga o kumbwa funda wu andaro. Woro mini rini ni mi dikisindauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ete wowani Jisas ga mwanji wasa ka hinga ya tini sawe, “Ele hima hinga tinda ete do fwa ni wu awa amwiningi wunu rikaꞌaini uku sumbwe hi keke ai wunu saino. ");
INSERT INTO kwj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","E, hima forini do ai uku sumbwe rini ani hawa ri ano ti, gisi fo amwiningi rihi ti rini rikaꞌaini uku sumbwe hi keke hinde ri ai wo kumbwa, mina. Ka uku sumbwe rini ani hano ti, fwa elendau hingambwa rini elesino. Wosiwa o fwa gisi gisi rini ki ete sukwandani ete da ete da himamwale kipe rini handano.” ");
INSERT INTO kwj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wowani o humwe ya rini sawe, “Apukolaka, o uku sumbwe mihi ma ani hawa ani a. Wowa ichai uku sumbwe hi tinga ani saiwa do wa eiro fwa tokwe uku ti ki hinde apa ani ai tanda kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wowani Jisas ya tini sawe, “Ma ai ini hurache nihi ni ucha ucha ki bwe ai ta.” ");
INSERT INTO kwj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ete wowani o humwe ga mwanji wasa ka hinga ya ti sawe, “Ani hurache nambwe.” Wowani Jisas ya tini sawe, “O mwe naha ki ni sawendau, nini hurache nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hinde wowani, imbihumbwa ni hurache le tapaꞌangimbwa. Woro apa hima foringa ni dau ti, o ni hurache mina. O mwanji nihi mwe naha.” ");
INSERT INTO kwj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wowani o humwe ya rini sawe, “Apukolaka, apambwa ani hambwahiro, mini Gotri mwanji bwarakarandau hima fo. ");
INSERT INTO kwj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nui atei hima wunu ka gimba ki wu ini Gotri ni wu lotu wondaro. Wowani kundo, Juta hima kupu le, ya ku saweu, Gotri ni lotu nu wono michi o Jerusalem ko laka kumbwa dau.” ");
INSERT INTO kwj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ete wowani Jisas ya tini sawe, “O bai humwe, nini ai mwanji numbwa ma sirina. E, gisi foti o sukwakonda. Wowa o gisi ki hima le do gimba ga Jerusalem ko laka ga opi kumbwa Yapai ni hinde wu lotu wo kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kunu ku hambwanda nambwe hima ni ku lotu wondau. Nunu nu hambwandau hima ni nu lotu wondau. Hinde wowani, Gotri hima ai ratandau sumbu ti, o nunu Juta hima kupu leki sukwandau. ");
INSERT INTO kwj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mwe naha Gotri ni lotu wono hima le himamwale tinga mwanji mu mwe naha tinga rini ni lotu wu wono gisi mwe ti ya tanda, apa sukwahiro. Hinde wowani, Yapai ele lotu wondau hima miya hinga le keke ri wondau. ");
INSERT INTO kwj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gotri rini himamwale. O keke hima le rini ni wu lotu wo kinawa himamwale tinga mwanji mu mwe naha tinga sa rini wu lotu wo.” ");
INSERT INTO kwj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wowani o humwe ya rini sawe, “Ani hambwanda, Kurais hi uchandau Mesaiya o takonda. Ri tano gisi tiki ele sumbu hinga tinda ete nunu ri sawekaweno.” ");
INSERT INTO kwj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Wowani Jisas ya tini sawe, “Ando sa to, ani ga mwanji do ya si bwanda.” ");
INSERT INTO kwj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","O hinga ri sawendawani ri himache le ya wu ai ta. Wu ta wu heiwani humwe fonga mwanji ti fi anambwandawani wunu inaka miyafo ya wu hambwanda. Wofunu rini ga mwanji ti wu anambwani ete rini wu sawe nambwe, “Bwele mwaꞌambwe ni mi ra kinani tini mi silindau?”, “Hinde wowani tini ga mwanji ti ki anambwandau?” ");
INSERT INTO kwj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wosini o humwe hatumwa tihi ti ti hanjaꞌaisini ko laka tokwe ti ai ini ele hima ni ya ti sawe, ");
INSERT INTO kwj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ma ku tani dele imbihumbwa a wosindaro sumbu le ani sawero hima ri ku hei. Hinde, rini Kuraisiꞌi?” ");
INSERT INTO kwj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wowani o ko laka wu andosini Jisas tambwa ya wu i. ");
INSERT INTO kwj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wu tandawani ri himache le ya rini sawe, “Apukolaka, ahirahi ma a.” ");
INSERT INTO kwj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wowani ya wunu ri sawe, “Ku hambwanda nambwe ahirahi fo ani ki o da.” ");
INSERT INTO kwj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wowani ri himache letombwa wunjenga ya wu anambwani sawe, “Hinde, hima foto ahirahi ti rini rataroꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ete wowani Jisas ya wunu sawe, “Ahirahi ahi ti ka hinga: Ani humbwewani a taro hima i okokona tumbwa a sirinani o ri tau a humbu ki. ");
INSERT INTO kwj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“E, kunu ete ku sawendau: ‘Aku eino gisi ti nika opuriꞌopuri ete dau.’ Woroti kunu a sawe, tau kuhi ti norukweni ma ku orotoronehei, ahirahi mwe ti wosihiro. ");
INSERT INTO kwj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ahirahi eino hima ri rini tau wasa rihi ri torondani ete da ete da ahirahi leni ya ri waunda. Wondani ahirahi kindau hima ringa ahirahi eindau hima ringa fini anaꞌape ya fi eripendakonda. ");
INSERT INTO kwj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","O keke do mwanji mwe naha, ‘Hima fori ahirahi ti ri kisiwa hima ba forito o ahirahi ri eino.’ ");
INSERT INTO kwj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kunu a humbwero ti, imbihumbwa ku ra nambwe tau tokwe ku ini ahirahi ku ei ki kunu a humbwero. Hima ba fweleto tau kwambu wu rasiwani kunu amwei tiki ku ini ahirahi le ku eini ku waundau.” ");
INSERT INTO kwj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sameriya pe hima miyafo ka humwe i mwanji tini wu mendikoni Jisas ni sembe ti ya wu ha. Hinde wowani, o humwe ka hinga sawero keke, “Imbihumbwa a wosiro sumbu hinga tinda ete ri ani sawetukwaro.” ");
INSERT INTO kwj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ete wokoni Sameriya pe hima le rini tambwa tani wunu ga ri da kinani ya rini wu torosi. Wosiwani o ko ki gisi fisi ya ri da. ");
INSERT INTO kwj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wondawani hima miyafo naha o ri mwanji minde ni wu mendi mendi sembe ya rini wu handa. ");
INSERT INTO kwj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wondani o humwe ni ya wu sawe, “Ni mwanji tumbwa nu mendini sembe ti do hima ni nu ha nambwe. Mina. Ri mwanji minde ni nunjenga nu mendini ka hinga nu hambwandau, ka hima naha tombwa dele nuwe pe himiyama hurahama leni ai raꞌaindau.” ");
INSERT INTO kwj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka gisi fisi ini humbuwani Jisas o ko andosini Galili mapwa tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisas rinjenga mwanji ti ka hinga amwei ya ri sawenda, “Gotri mwanji bwarakarandau hima ri ko mu tiki rini hi nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ri ini Galili ko tiki ri raruwani Galili pe hima le rini heikoni ya wu eripeꞌaripe. Hinde wowani, wunu okwe Jerusalem ko tiki wu dasini ka Pasofa gisi laka ki ri wosiro ele sumbu hinga tinda ete wu heiro. ");
INSERT INTO kwj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wosini ri ai ini Galili mapwa tokwe dau Kena ko ki ya ri raru. O ko ki mwasembwa fwa ti ri jamekowani waini uku hinga siraro. Woro Kapaneyam ko tiki king tau ra himache fori dawani ri hurahama che ri ya hahungonda. ");
INSERT INTO kwj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Woro o hima Jisas Jutiya ko andosini Galili mapwa tokwe taro mwanji ti ri mendini rini tambwa ri ini rini ni ya ri atasimbwatasi, ri tani kamindache naha hakondau ri che ni ri okulawa kipe rini ai wosi ki. ");
INSERT INTO kwj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wowani Jisas ya rini sawe, “E, kwambu chele sumbu ambwe sumbu ambwe le ku hei nambwe nawa sembe ti hinde ku ha kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wowani king tau ra himache ori ya rini sawe, “Apukolaka ma huwainani sika, apa ai che ha ki.” ");
INSERT INTO kwj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wowani Jisas ya rini sawe, “Ma i. Mi che himamwale ga o ai ri da.” Wowani ori hima Jisas i mwanji ni sembe ri hani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ete ri indawani ri himache le numbo tiki rini wu heini ya rini wu sawe, “Mi che himamwale ga ai da.” ");
INSERT INTO kwj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wowani ya wunu ri sili, “Bwele amwa naha ki kipe hinga ri mendiro?” Wowani ya wu sawe, “Injele nika ti gondi naha ki daro ti, gamindache ri yekwehimewani tape hi ti rini humburo.” ");
INSERT INTO kwj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","O hinga wu nawani ri yapai ya hambwa, injele ka amwa naha hinga ki Jisas ete rini sawero, “Mi che himamwale ga o ai ri da.” Wosini rini ga ri hima kupu lenga tinda ete sembe ti ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas Jutiya mapwa ri andosini Galili mapwa tokwe ri raruni ka sumbu ya ri wosi. Wowani kwambu chele sumbu ri wosiro ti, numbo fisi ya i. ");
INSERT INTO kwj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wosiwani dani ini Juta hima kupu lei gisi laka foti tawani Jisas Jerusalem ko tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ko tiki Sipisip hi uchandau lengenumbo takai ki fwanjuweiche fori ya da. O fwanjuwei hi ti Hipuru mwanji tiki ka hinga wu uchandau, Betesita. O fwanjuwei gamba ki tapaꞌangimbwa kiro tapa aka ti ya da. ");
INSERT INTO kwj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wondawani ele tapa aka ki hahungo hima le miyafo naha ya wu lininda. Wunu miyasa hima fwele, seke kapwa hima fwele, e, talihapa dingambwa hima fwele ete ya wu lininda. Wondani fwa ti imbikiꞌembeki kinani ya wu nikisinda. ");
INSERT INTO kwj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hinde wowani, gisi fweleki Apukolaka i ensel rito sikani o fwanjuwei ki raisini hakweitakweiwani imbikiꞌembekindau. Wondawa metengei naha o fwa we ki raino hima ri, hahungo rihi ti kipe ri ai wosino. ");
INSERT INTO kwj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hima fori o tapa aka we ki daro ti, ri hahungo ri mendindawani 38 asama hinga ya ete i. ");
INSERT INTO kwj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas ori hima ri heiwani tukuyandawani ya ri hambwa, asama miyafo naha ete ri hahungondaro. Wosini Jisas ya rini sawe, “Tape mihi kipe wosi ki mi okokonandauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wowani hahungo hima ori ya sawe, “Hima laka, fwanjuwei ti imbikiꞌembekiwani namoto ani okulani ani toroni rawaino? Mina. Anjenga a rai ki a wondau, wondawani mina, hima fweleto mwaseni ani dikisini ya wu raindau.” ");
INSERT INTO kwj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wowani Jisas ya rini sawe, “Ma saini topo mihi toroni ya i.” ");
INSERT INTO kwj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wowani metengei naha ori hima i tape ti kipe naha rini wosiwani saini ri topo ri toroni ya ri i. Ka sumbu sukwaro gisi ti, Juta hima kupu lei himati gisi foki sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wowani Juta hima kupu le kipe wosiro hima o rini ya wu sawe, “Apa himati gisi. Topo kichani i kei. Nui lo mwanji o tini minambwe nasindau.” ");
INSERT INTO kwj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wowani mwanji wasa ti ya wunu ri sawe, “Ka kipe ani wosiro hima ri ete ani sawe, ‘Topo mihi ma toroni i.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wowani ya rini wu sili, “Namoto topo mihi toroni mi i ki mini sawero?” ");
INSERT INTO kwj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wowani kipe wosiro hima ori ya hikisa. Hinde wowani, ka michi ki himiyama hurahama miyafo naha dawani Jisas wunu andosini ete iro. ");
INSERT INTO kwj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dani inumbwa Jisas Gotri aka laka we tiki rini heini ya rini sawe, “Ma mendi. Apa kipe ti mi wosihiro. Kapwa sumbu ti ai wo kei. Ma ai wowa apa nomo omwesika naha foti o mini ki sukwakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wowani ori hima ini Juta hima kupu leni ya ri sawe, “Kipe ani wosiro hima ori Jisas sa to.” ");
INSERT INTO kwj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ete wowani Juta hima kupu le Jisas ni sembe enge ti ya wu anda. Hinde wowani, hima ti gisi ki o sumbu hinga ri wosiro ti keke. ");
INSERT INTO kwj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ete wowani Jisas ga mwanji wasa ya wunu sawe, “Yapai ahi ele gisi hinga tau ete ri randau. Woro hingambwa ani okwe do tau ete a randau.” ");
INSERT INTO kwj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ete wowani Juta hima kupu le Jisas ni wu yewa ha kinani gamwe tinga mwe naha ya wu hambwa. Hinde wowani, himati gisi sumbu wuhi numbwa ri yetupwasini ri wo nambwe, foti ka hinga ri sawero, Gotri o ri Yapai naha. O mwanji hinga ri bwaro keke, rini Gotri hingambwa rinjenga ri naro. ");
INSERT INTO kwj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ete wowani Jisas mwanji wasa ka hinga ya wunu ri sawe, “Mwanji mwe naha ki kunu a sawendau: Che ri ri inaka ki sumbu foti hinde apa ri wosi kumbwa, mina. O ri Yapai wosindau sumbu hinga ni ri heisini hambwa hambwa ya ri wosiu. Ele sumbu hinga tinda ete Yapai wosindau hingambwa Che okwe ya wosiu. ");
INSERT INTO kwj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yapai Che keke funda ete ri wondau, o keke ri wosindau sumbu hinga tinda ete ya rini mekuu. Woro kale sumbu ni dikindau tau laka ni o rini mekukonda. Wondawa kunu inaka miyafo ya ku hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yapai matimat ki haro hima leni ai ri rasaisini himamwale ako ri ai handau. Woro o hingambwa Che ri okwe ri okokonandau hima leni himamwale ako ri ai handau. ");
INSERT INTO kwj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yapai hima forini hinde ri kili kumbwa. Ele hima ni kilino tau hinga tinda ete ri Che numbwa ri hasindau. ");
INSERT INTO kwj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Wosiwa ele hima hinga Yapai hi tini rasaindau hingambwa Che ri hi ni o hingambwa wu rasai kinani. Hima le Hima i Che dori hi tini wu rasai nambwe nawa, ka rini humbwewani taro Yapai hi ti hinde wu rasai kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mwanji mwe naha ki kunu a sawendau: Hima ri ai mwanji ni ri mendini ani humbwewani a taro hima rini sembe ti ri hawa, rini ete da ete da himamwale kipe ti rini ga dano. Wosiwa rini apa koti ki hinde ri eti kumbwa, mina. Rini handau sumbu ni ri dikisini apa himamwale ako ga ri dau. ");
INSERT INTO kwj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Mwanji mwe naha ki kunu a sawendau: Gisi fo o sukwakonda, woro apa sukwahiro. O keke matimat ki siro hima le Gotri Che i tumwa ni ya wu mendikonda. Wondawa ri mwanji ni mendini sirinaro hima le himamwale kipe ya wu torokonda. ");
INSERT INTO kwj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yapai himamwale mu naha rini ki dau. Woroki ri Che rini kwambu ri hawani rini okwe himamwale chele. ");
INSERT INTO kwj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rini Hima ri Che, o keke ri Yapai ele hima i mwanji ni ri kilino kwambu ti rini haro. ");
INSERT INTO kwj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Woro kunu apa ka tini inaka tenge miyafo ku hambwa kei. Matimat ki siro ele hima hinga tinda ete ri tumwa ni wu mendino gisi ya tanda. ");
INSERT INTO kwj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","O gisi tawa wunu matimat wu hanjaꞌaisini o wu ai saikonda. Wondawa sumbu kipe wosindaro hima le wu ai saini himamwale ako wu torosini ya wu dakonda. Woro kapwa sumbu wondaro hima le wu ai saini koti ki wu etini huruhumba ya wu heikonda. ");
INSERT INTO kwj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ani anjenga ai inaka ki sumbu foti hinde apa a wosi kumbwa. Ani ai Yapai mwanji numbwa a sirinani hima lei sumbu a kilindau. Woro hima ni kilindau sumbu ahi ti kipe naha. Hinde wowani, o ai okokona ni a sirinanda nambwe. Ani ka ani humbwewani a taro hima ri okokona tumbwa a sirinandau. ");
INSERT INTO kwj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“E, ani bati nawa, do mwanji anjenga a bwandau ti, o mwe naha mina. ");
INSERT INTO kwj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Woro hima fori dasini ani okulani ani ni amwei ri sawewa o ani hambwanda, o mwanji ri ani sawero ti mwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Imbihumbwa Jon ni mwanji ku humbwewani iro. Wosiwani rini mwanji mwe naha tini amwei naha kunu ri sawero. ");
INSERT INTO kwj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ani hima foto etisini ani ni okulani mwanji ri bwa ki inaka miyafo ani hambwanda nambwe. Ani Gotri ai kunu raꞌai kinani do mwanji a bwandau. ");
INSERT INTO kwj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon rini lamu to okundani taiyandau hinga. Wondawani kunu ri daro gisi fwele kumbwa rini ki taiyandau hi ni ku eripe kinani kui inaka ki ya ku hambwasi. ");
INSERT INTO kwj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Woro Jon ani okulani amwei ani ni sawero sumbu ni dikindau mwaꞌambwe ti a torosindau. Dele tau hinga a randau ti, ele tau hinga ai Yapai to ani haro to mwanji hinga ani keke amwei bwandani ele himiyama hurahama ni ya mekunda, Yapai to ani humbwewani a taro. ");
INSERT INTO kwj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ani humbwewani a taro Yapai to rinjenga ani ni amwei sawero. Woro ori hima i tumwa ti ku mendindani ri miyaningisopo ti ku heinda nambwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wondani ri mwanji okwe kui sembe we ki kwai da nambwe. Hinde wowani, Yapai humbwewani taro dori hima ni sembe ku ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kunu Gotri chengi ele ni mwanji mu mwe ku hambwa kinani tau kwambu ku randau. Wondani ka hinga ku hambwandau, o chengi minde ki ete da ete da himamwale kipe ku torono. Woro ele chengi ki dau himiki hinga tinda ete ani numbwa amwei sawesindau. ");
INSERT INTO kwj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wosiwani himamwale kipe ku toro kinani ani tambwa ku tanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Hima le ani ni hi omwesika wu ani uchano tini ani ohounanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Woro kunu ani hambwasinda, kunu kui sembe ti Gotri keke ku wonda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ani Yapai hi ki a tasiwani kunu ai mwanji ti ku mendini ku toronda nambwe. E, hima fori tani hi rihi numbwa ri bwawa ri mwanji ni ku mendini ya ku torokonda. ");
INSERT INTO kwj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kunjenga kui nindo ki hi laka kunu uchasi ki ku okokonandau. Wondani Gotri funda naha ki tandau hi laka tini ku toro ki ku okokonani ku wakineheinda nambwe. O hinga ti, Gotri ni sembe ti hinde hinga ku hakondau? ");
INSERT INTO kwj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kunu apa ete ku hambwa kei, ani ai Yapai miyaningisopo ki kunu a kotimwono. Mina. Kunu kotimwono hima ri, o Moses. Woro kari hima to kunu okulano nani ete ku nikisindau. ");
INSERT INTO kwj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","E, Moses mwanji ni sembe kuhi ti ku hawambwa, ai mwanji okwe sembe ku hano. Hinde wowani, rindo ani ni kairo. ");
INSERT INTO kwj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Woro ka ri kairo mwanji ni sembe ku ha nambwe keke apa a sawendau mwanji tini hinde hinga sembe ku hano?” ");
INSERT INTO kwj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","O sumbu ri humbusini dani ini Jisas Galili fwanjuwei angi tokwe ya ri i, o fwa hi foti, Taipiriyas. ");
INSERT INTO kwj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wondawani himiyama hurahama miyafo naha rini sirinani ya wu inda. Hinde wowani, hahungo hima leni kwambu fwele ri wosiro sumbu tini ka wu hei to. ");
INSERT INTO kwj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ete wondawani Jisas gimba ki rauni ri himache lenga ya ri lininda. ");
INSERT INTO kwj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","O gisi Juta hima kupu lei Pasofa gisi laka ti ya takaisinda. ");
INSERT INTO kwj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wosini Jisas ri maꞌaikaꞌaini ri heiwani himiyama hurahama miyafo naha rini tambwa ya wu tanda. Wondawani Filip ni ya ri sawe, “Dele himiyama hurahama miyafo naha wu ano bereti soki apa nu rano?” ");
INSERT INTO kwj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O hinga rini sawero ti, nimba rini simiyaneheiro. Rini rinjenga ri wosino sumbu ti ri hambwasinda. ");
INSERT INTO kwj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ete wowani Filip ga mwanji wasa ti ka hinga ya rini sawe, “E, tau rawani asama funda humbukondawani torono ya hinga nu raꞌaini bereti le nu rani nu ratasiwa, apa dele himiyama hurahama anasawe hinga tinda ete kapwache kapwache wu awa hinde apa wunu chiki kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wowani ri himache fori, Anduru, Saimon Pita i analongo, rito ya sawe, ");
INSERT INTO kwj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Che fori bereti tapaꞌangi ga fwaiꞌomwe fisi ga dohaꞌa ri torosinda. Woroti delehaꞌa himiyama hurahama miyafo hinde apa wunu chiki kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Wowani Jisas ya wunu sawe, “Ele himiyama hurahama ma ku sawewa sa wu liti.” O michi ki ki miyafo naha ya da. Wowani ele hima hinga ya wu liti. Woro wu litiro hima mwe le 5,000 hinga. ");
INSERT INTO kwj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Wu litisiwani Jisas o bereti ri torosini Gotri ni ri weseꞌasini ele hima ni ri humwasini ya wunu ha. Wosini ka fwaiꞌomwe fisi ni o hingambwa ya ri wosi. Wosiwani wui okokona tiki wu ano hinga ya wu anda. ");
INSERT INTO kwj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wu ani wunu chikiwani ri himache leni ya ri sawe, “Ele ete dau atiparatipa fokumbwa ma ku wau, apa ahirahi fwele nimba dani walambe i ki.” ");
INSERT INTO kwj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wowani ka tapaꞌangi bereti wu ani andosiro atiparatipa le fokumbwa wu wausini hala tapaꞌangi tapaꞌangi ini hatachi fisi ya ete wu waro. ");
INSERT INTO kwj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ele himiyama hurahama o kwambu chele sumbu hinga ri wosiro tini wu heini ya wu sawe, “Mwe naha, rini do nuwe ki sika ki bwasiro Gotri mwanji bwarakarano hima kari to sikaro.” ");
INSERT INTO kwj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wowani Jisas ya ri hambwa, rini wu toroni raꞌaini wui king apukolaka hinga rini wu esi ki. O hinga keke wunu andosini rini bati gimba tokwe ya ri ai rau. ");
INSERT INTO kwj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","O gisi hunduwani Jisas i himache le fwanjuwei tokwe ya wu rai. ");
INSERT INTO kwj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wu raini kanu tenge tiki wu rauni fwanjuwei angi tokwe Kapaneyam ko ki ya wu i ki. Wondawani ya hundu, woro Jisas wunu tambwa i nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wondawani ausuwa laka ti sindawani fwa au ti ya sainda. ");
INSERT INTO kwj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kanu tenge tiki fwa wu tindawani tapaꞌangi tumbwaꞌa tapaꞌangi hatachi funda kilomita hime hinga ya wu inda. Wondani wu heiwani Jisas fwa tenge ki ri eti eti wunu tambwa takaini ya ri tanda. O tini wu heikoni ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wowani ya wunu ri sawe, “Ando a tandau. Apa ku aki kei.” ");
INSERT INTO kwj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wowani rini wu toroni kanu tenge tiki wu rakaru ki ya wu okokona. Wosiwani kanu oti wu i kinani wu indaro ko ki metengei ya ete raru. ");
INSERT INTO kwj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dani ini lindanawani ele himiyama hurahama fwanjuwei angi tokwe daro leto ya wu hambwa, injele kanu miyafo wu hei nambwe funda naha tombwa daro, woro Jisas o kanu tenge ki ri himache lenga ri rau nambwe, ele ri himache letombwa rauni wu iro. ");
INSERT INTO kwj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Woroti Taipiriyas ki taro kanu fwele okwe Apukolaka ka bereti Gotri ni ri weseꞌasini wu aro michi takai tiki tani yenjimbelesini ya da. ");
INSERT INTO kwj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ele himiyama hurahama wu heiwani Jisas ga ri himache lenga da numbwa. Wowani kanu tenge fweleki wu rauni Kapaneyam ko tokwe Jisas ni wakini ya wu i. ");
INSERT INTO kwj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wu ini fwanjuwei angi tokwe rini wu heini ya wu sawe, “Ondiyakandiyandau hima, ahaꞌa ki hinde gisi mi taro?” ");
INSERT INTO kwj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wowani Jisas mwanji wasa ya wunu ri sawe, “Mwanji mwe naha ki kunu a sawendau: Do ku ani wakitekindau ti, kwambu chele sumbu ku heiro ti keke mina, ka bereti ku awani sembe ti kunu talero keke ku ani wakitekindau. ");
INSERT INTO kwj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Apa kapwasino ahirahi keke tau ku ra kei. Mina. Kunu ka ete da ete da ahirahi keke tau ma ku ra. Ahirahi mwe ti ete da ete da himamwale ni sawero. Woro ka ahirahi hinga ti Hima ri Che dori to kunu hano. Yapai Gotri o sumbu hinga Che to wosi kinani ri ohounani ri wupa ya rini wosi.” ");
INSERT INTO kwj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","O hinga ri nawani ya rini wu sawe, “Hinde na hinga nu wosini apa Gotri tau ti nu rano?” ");
INSERT INTO kwj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wowani Jisas ga mwanji wasa ya wunu sawe, “Gotri tau ti ka hinga: Kunu Gotri humbwewani taro hima ka rini sembe ti ma ku ha.” ");
INSERT INTO kwj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wowani ya rini wu sawe, “Mini apa bwele kwambu chele sumbu fotini mi wosiwa nu heitoni mi mwanji tini nu sirinani sembe ti nu hano? Bwele sumbu ni mi wosino? ");
INSERT INTO kwj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","E, nui atei hima, hima da nambwe michi tiki mana ti wu aro. Woro Gotri chengi o sumbu ni ka hinga sawero, ‘Rini hewen kipe bereti wu a kinani wunu ri haro.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wowani Jisas ya wunu sawe, “Mwanji mwe naha ki kunu a sawendau: Moses hewen pe bereti tini kunu ha nambwe. Mina. Ai Yapai to hewen pe bereti mwe naha tini kunu handau. ");
INSERT INTO kwj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hinde wowani, ka kunu handau bereti mwe ti, hewen ko ti andosini nuwe tokwe sikani nuwe pe himiyama hurahama leni himamwale ti ri handau.” ");
INSERT INTO kwj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wowani ya rini wu sawe, “Apukolaka, ka bereti gisi gisi ma ete nunu handa.” ");
INSERT INTO kwj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wowani Jisas ya wunu sawe, “Ani andombwa himamwale ga dau bereti. Ani tambwa tano hima ri, iche ti hinde apa rini ha kumbwa. E, hima ani ni sembe ri hano ti, uku sumbwe hi ti hinde apa rini sai kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Woro, kunu a sawero. Ku ani heiro ti, sembe ku ani ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yapai ani ni haro himiyama hurahama hinga tinda ete ani tambwa wu tano. E, hima ani tambwa wu tano ti, ele hima gumwa hinde wunu a si kumbwa. Minambwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hinde wowani, ani hewen ko ti ani hanjaꞌaisini a sikaro ti, ai okokona ni a sirina ki a sika nambwe, mina. Ani ani humbwewani a sikaro hima ri okokona ni a sirina kinani a sikaro. ");
INSERT INTO kwj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ori hima ani humbwewani a taro ri okokona ti ka hinga: Apa dele ri ani haro himiyama hurahama fori ani hanjaꞌaiwa walambe rini i hinga, mina. Gisi jipe humbuno ki ai wunu a rasaino. ");
INSERT INTO kwj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hinde wowani, ai Yapai ri okokona ti ka hinga: Ele hima hinga tinda ete Hima ri Che dori ni wu heini sembe rini wu haro ti, wunu ete da ete da himamwale kipe wu torono. Wosiwa gisi jipe ki ai wunu a rasaino.” ");
INSERT INTO kwj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","O mwanji hinga ri bwasiwani Juta hima kupu fwele rini ni kapwa inaka wu hambwandani ya wu anambwa anambwanda. Hinde wowani, Jisas ete sawero keke, “Ani andombwa hewen ko ki andosini sikaro bereti.” ");
INSERT INTO kwj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wondani ya wu sawe, “Dori hima Jisas, Josep i che. Ri nuwai yapai nu hambwanda. Hinde wowani ete ri sawero, ‘Ani hewen ko ti ani hanjaꞌaisini a sikaro’?” ");
INSERT INTO kwj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wowani Jisas ga mwanji wasa ka hinga ya ri sawe, “Apa kunjenga kui nindo ki kapwa inaka ku hambwandani mwanji miyafo ku anambwa anambwa kei. ");
INSERT INTO kwj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hima fori rinjenga ri okokona ki ani tambwa hinde ri ta kumbwa, mina. Ani humbwewani a taro Yapai to hima forini toroni longowa ori hima ani tambwa ri tano. Wosiwa gisi jipe humbuno ki ai rini a rasaino. ");
INSERT INTO kwj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Gotri mwanji bwarakarandaro hima le kairo chengi ki ete sawe, ‘Gotri ele himiyama hurahama ni ri ondiyakandiyano.’ Ele hima hinga tinda ete Yapai mwanji ni wu mendini rini ni wu hambwani wu sirinandau le, wunu ani tambwa tandau. ");
INSERT INTO kwj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Hima fori Yapai hei nambwe. Dori hima Gotri ga dasini ri sikaro to ori hima tombwa Yapai heiro. ");
INSERT INTO kwj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mwanji mwe naha ki kunu a sawendau: Hima fori sembe ani ni hano ti, ete da ete da himamwale rini ga dano. ");
INSERT INTO kwj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ani andombwa himamwale ga dau bereti. ");
INSERT INTO kwj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Imbihumbwa kui metele hima le hima da nambwe michi ki mana tini wu aro. Woro wu haro. ");
INSERT INTO kwj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Woro hewen ko ti sikaro bereti dohaꞌa da. E, hima fori o bereti ni ri awa, hinde apa ri ha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ani himamwale ga dau bereti, hewen ko ti ani hanjaꞌaisini a sikaro. E, hima fori do bereti ni ri ano ti, rini himamwale ga ete ri dano. Do bereti o ai hima tape, do nuwe ki dau hima le himamwale kipe ni wu toro kinani wunu ani hakondau.” ");
INSERT INTO kwj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ete wowani Juta hima kupu le wunjenga wui nindo tiki mwanji au hinga ya wu anayendani ya wu sawe, “Hinde wowa kari hima ri hima tape ti nunu ri hawa nu ano?” ");
INSERT INTO kwj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Wowani Jisas ga ya ai wunu sawe, “Mwanji mwe naha ki kunu a sawendau: E, Hima ri Che dori ri hima tape ga ri fi ga ku a nambwe nawa, kunu apa ete da ete da himamwale ga hinde ku da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","E, hima fori hima tape ahi ga fi ahi ga ri ano ti, ete da ete da himamwale rini ga dano. Wondawa gisi jipe ki ai rini a rasaino. ");
INSERT INTO kwj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hinde wowani, hima tape ahi ti o ahirahi minde naha, e, fi ahi ti o uku sumbwe minde naha. ");
INSERT INTO kwj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","E, hima ri hima tape ahi ga fi ahi ga ri andau ti, rini ani ki dawani ani rini ki a dau. ");
INSERT INTO kwj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Himamwale ga dau Yapai ri ani humbwewani a tasini ri kwambu ki himamwale ga a dau. Woro o hingambwa hima fori hima tape ahi ri ano ti, rini ai kwambu ki himamwale ga ri dano. ");
INSERT INTO kwj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dohaꞌa o hewen ko andosini sikaro bereti. Dohaꞌa bereti o imbihumbwa nui metele hima le asini wu haro hinga mina. Hima fori do bereti ni ano ti, rini himamwale kipe ri torosini ete da ete dano.” ");
INSERT INTO kwj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas kapaneyam lei lotu wondau aka ki wunu ondiyakandiyandani do mwanji hinga ni wunu sawero. ");
INSERT INTO kwj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ete wowani ri himache le o mwanji wu mendini ya wu sawe, “Do mwanji kapwatako naha. Namoto apa mendini toro kumbwa?” ");
INSERT INTO kwj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Woro Jisas ri inaka ki ya ri hambwa, ri himache le ri bwasiro mwanji o tini inaka tenge miyafo wu hambwandawani. Wokoni ya wunu ri sawe, “Do ai mwanji to inaka kuhi ti kunu jamekoroꞌo? ");
INSERT INTO kwj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E, Hima ri Che dori ku heiwa, o ri taro ko ki ri ai rauwa hinde hinga wai? ");
INSERT INTO kwj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Gotri Himamwale tito hima ni ete da ete da himamwale ti handau. Hima tape nuhi ti gamweche ri hinde apa nunu okula kumbwa. Do mwanji kunu a sawero ti, o ete da ete da himamwale. ");
INSERT INTO kwj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Woro kui nindo tiki dau hima fwele sembe wu ha nambwe.” Imbihumbwa kapwa Jisas sembe ha nambwe hima ele ga rini omwemendini hima lei tapa tenge ki rini hano hima ele ga wunu ni ri hambwasino. ");
INSERT INTO kwj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wosini mwanji gamweche ga ya ri ai sawe, “Do mwanji bomo mu keke ka hinga kunu a sawero: ‘E, Yapai hima forini kwambu ti ri ha nambwe nawa, ori apa ani tambwa hinde ri ta kumbwa.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","O mwanji hinga ri bwani humbuwani, Jisas himache miyafo naha rini hanjaꞌaisini ya wu i. Wosini rini ga wu ai i nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wowani Jisas tapaꞌangi tapaꞌangi hatachi fisi Himache rihi leni ya ri sawe, “Kunu okwe ku ani hanjaꞌaisini ku i kiꞌi?” ");
INSERT INTO kwj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Wowani Saimon Pita ga mwanji wasa ka hinga ya rini sawe: “Apukolaka, namo tambwa nu ino? Ete da ete da himamwale ga dau mwanji mini ga dau. ");
INSERT INTO kwj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nunu sembe ti Gotri ni nu hasini nu hambwanda, mini Gotri humbwero Hima Kipe Funda Naha.” ");
INSERT INTO kwj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wowani Jisas ga mwanji wasa ka hinga ya ri sawe, “Kunu hinde, tapaꞌangi tapaꞌangi hatachi fisi ai Himache hinga kunu ani esi nambweꞌe? Woro kui nindo tiki dau hima fori himamwale kapwa rini ga o da.” ");
INSERT INTO kwj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hima mwe ri Jutas ni sawero, Saimon Isukariyot i che. Rini kale tapaꞌangi tapaꞌangi hatachi fisi Himache fo, woro dani ini rindo Jisas ni yeno hima lei tapa tenge ki o rini ni ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","O sumbu hinga humbusiwani Jisas Galili mapwa kumbwa ya ri ichiꞌuchanda. Rini Jutiya mapwa tokwe ri i ki ri diyahandau. Hinde wowani, o ki dau Juta hima kupu le rini yeni si kinani wu hambwandawani. ");
INSERT INTO kwj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ka gisi ki Juta hima kupu lei gisi laka foti, ka hinga wu uchandau, Nikaꞌari Ba Kiro Gisi Laka, ya takai. ");
INSERT INTO kwj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wowani ri hipache le ya rini sawe, “Mini do ko ma hanjaꞌaisini Jutiya mapwa ki ma ini sumbu fwele mi wowa mi himache le wu heini sa wu hambwa. ");
INSERT INTO kwj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","E, hima fori hima lei miyaningisopo ki amwei ri da kinawa, rini sumbu fwele yanini ri wosinda nambwe. E, dele sumbu hinga mi wosindau ti nawa, dele himiyama hurahama i miyaningisopo ki amwei ma eti.” ");
INSERT INTO kwj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ri hipache le okwe rini ni sembe wu ha nambwe. O keke ka mwanji hinga ti wu sawero. ");
INSERT INTO kwj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ete wowani Jisas ya wunu sawe, “Ani ai gisi mwe naha ti ta nambwe. Dele gisi hinga o kui gisi mwe naha tumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Do nuwe ki dau himiyama hurahama le hinde apa kunu omwemendi kumbwa. Wunu ani numbwa wu omwemendindau. Hinde wowani, wu wosindau kapwa sumbu wuhi ni amwei wunu a sawendau ti keke. ");
INSERT INTO kwj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kunjenga ma ku ini gisi laka kuhi ti ku hei. Ani o gisi laka kuhi ti hinde apa ani inehei kumbwa. Hinde wowani, gisi mwe naha ahi ti ta nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","O mwanji hinga wunu ri sawesini rini Galili mapwa ki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jisas hipache le ka gisi laka wu hei kinani wu isiwanimbwa, rini okwe ya i. Woro ri iro ti, amwei ri i nambwe, gainani ri iro. ");
INSERT INTO kwj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wondawani Juta hima kupu le o gisi laka ki rini ni wu wakindani ya wu sawe, “Kari hima soki dau?” ");
INSERT INTO kwj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wondawani ele himiyama hurahama rini keke mwanji miyafo ki ya wu anambwanda. Ete wondani fwele sawe, “Rini hima kipe.” Wowani fwele sawe, “Mina, rini himiyama hurahama leni ri gambolombondau.” ");
INSERT INTO kwj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Woro wunu ele Juta hima kupu le keke wu akindani wunu forito mwanji rini ni sawe nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ka gisi laka i nindo ki Jisas Gotri aka laka ki ri rarusini ele himiyama hurahama ni Gotri mwanji ti ya wunu ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wondawani Juta hima kupu le wu apapanani ya wu sawe, “Hinde wowani dori hima ka hambwa laka ri hambwandau? Rini sukul ri wo nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wowani Jisas ga mwanji wasa ka hinga ya wunu sawe, “Do mwanji kunu a sawendau ti, o ai mwanji mina. O ri ani humbwewani a taro hima ri ri mwanji. ");
INSERT INTO kwj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","E, hima fori Gotri okokona tini ri sirina ki ri hambwandau ti, rini apa do a sawendau mwanji mu mwe ti amwei naha ka hinga ri hambwakonda: Do a bwandau mwanji ti, Gotri to sawero mwanjiꞌi, ai inakahambwa mwanji ni a bwandau. ");
INSERT INTO kwj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hima fori mwanji fwele ri inakahambwa ki ri bwandau ti, o hi rihi tini ri rasai ki ri wondau. E, hima fori rini humbwewani ri taro hima ri hi ni ri rasai ki ri rawa, rini sumbu mwe naha tini sirinandau hima, gambondau sumbu fo rini ki da nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Imbihumbwa Moses Gotri lo mwanji ni kunu ha nambweꞌe? Woro kui nindo ki hima fori o Gotri lo mwanji ni sirinanda nambwe. Bwele mu keke ku ani yeni si ki ku anakwendau?” ");
INSERT INTO kwj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wowani ele himiyama hurahama mwanji wasa ka hinga ya rini sawe, “Himamwale kapwa fo mini ki o da. Namoto mini yeni si ki anakwendau?” ");
INSERT INTO kwj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ete wowani Jisas ga mwanji wasa ka hinga ya wunu sawe, “Ani kwambu chele tau fo a wosiwani kunu tinda ete ku apapanaro. ");
INSERT INTO kwj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses hima tape kupu kutondau sumbu tini kunu sawendiriro. Mwe naha, do hima tape kupu kutondau sumbu rini ki sira nambwe. O rini ni mwaseni sukwaro metele hima nuhi ki siraro. O keke apa kundo himati gisi ki kui che leni hima tape kupu ti ku kutondau. ");
INSERT INTO kwj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kunu Moses lo mwanji ni kipe naha ku sirina kinani ku hambwandau, wosini himati gisi ki kui che leni hima tape kupu ti ku kutondau. Woro himati gisi ki ani okwe o hingambwa hahungo hima forini kipe tumbwa ai rini a wosisiwani bwele keke sembe enge a ti ku ani andau? ");
INSERT INTO kwj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Apa miya ki nimba hei hei hima i sumbu ti kili kei. Ele mwaꞌambwe ki dau sumbu tinda ete kipe naha ma hambwasini pwe mi bwe kili.” ");
INSERT INTO kwj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wosiwani Jerusalem ko kipe himiyama hurahama fwele ya wu sawe, “Ele hima rini yewa ri ha kinani wu anakwendau hima mwe ri kari toꞌo? ");
INSERT INTO kwj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wo ma hei to! Mwanji ti hima wausindau apweli ki ri bwandawani wunu ga mwanji wasa foti rini wu sawenda numbwa. Mekupu hima ele mwe naha wu hambwandau poꞌo, rini Kurais? ");
INSERT INTO kwj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Woro nunu nu hambwanda, dori hima ri taro ko minde rihi ti. E, Kurais tano gisi ti, hima fori ri taro ko minde rihi ti hinde apa ri hambwa kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas Gotri aka laka we ki ri dani ele hima ni Gotri mwanji ti wunu ri ondiyakandiyandani ri uchani ka hinga ya ri sawe, “Ani ku ani hambwani ko minde ahi ti okwe o ku hambwanda! Woro anjenga ai okokona ki a ta nambwe. Ani humbwewani a taro hima ri, ri sumbu ti mwe naha. Woro kunu rini ku hikisandau. ");
INSERT INTO kwj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ani rini ani hambwanda. Ani rini ga a daro tito ri ani humbwewani a taro.” ");
INSERT INTO kwj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","O keke rini toroꞌinji kinani ya wu anakwe. Woroti ri gisi mwe ti ta nambwe. O keke hima fori tapa ti rini owe nambwe, mina. ");
INSERT INTO kwj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ele himiyama hurahama lei nindo ki hima miyafo sembe ti rini ni wu hasini ya wu sawe, “Kurais tano gisi ki kwambu chele sumbu ambwe sumbu ambwe miyafo naha ri woni dori hima wosindau kwambu chele sumbu leni ri dikinoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi hima le wu mendiwani ele hima miyafo Jisas ri wosiro kale sumbu hinga leni ya wu bwanda. Wowani puris hima i apukolaka lenga Farisi hima lenga ori hima ni toroꞌinji kinani apungwandai kicha hima fweleni wu humbwewani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas ya sawe, “Gisi faiche naha kunu ga a dasini ani humbwewani a taro hima ri tambwa ya ani ai ikonda. ");
INSERT INTO kwj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wosiwa ku ani wakini hinde apa ku ani hei kumbwa. Wondani o a dano ko ki hinde apa ku ta kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ete wowani Juta hima kupu le wunjenga ka hinga ya wu anambwanda, “Ka so mapwa naha ki ri isiwa hinde apa rini nu wakini nu hei kumbwa? Ka nui hima kupu le Girik lei ko leki hima kicha hinga wu dau ki ri ini Girik hima leni ri ondiyakandiyakondauꞌu? ");
INSERT INTO kwj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ka ete ri sawero ti, ‘Apa ku ani wakini hinde ku ani hei kumbwa,’ wosini ka hinga ete ri ai sawero ti, ‘Kunu a dano ko ti hinde apa ku ta kumbwa,’ woro kapi mwanji mu mwe ti hinde hinga?” ");
INSERT INTO kwj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka gisi laka i gisi jipe ti gisi omwesika naha. Woro o gisi ki Jisas saini etisini ka hinga ri uchani ya ri sawe, “E, hima fori uku sumbwe hi tinga rini saiwa, ori hima ani tambwa sa ri tani uku sumbwe ti sa ri a. ");
INSERT INTO kwj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dohaꞌa mwanji Gotri chengi ki ka hinga sawesindau: Hima fori sembe ani ni ri hano ti, himamwale ga dau uku ti ri sembe ki ete sukwani elendano.” ");
INSERT INTO kwj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas ka mwanji hinga ri sawero ti, Gotri Himamwale ni ri sawero. Rini ni sembe haro hima le ka Gotri Himamwale ni waya o wu torokonda. Ka gisi ki hima le Gotri Himamwale tini wu toro nambwe, hinde wowani, Jisas ri ai saini hi omwesika ri toro nambwe ri dawani. ");
INSERT INTO kwj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wowani himiyama hurahama fwele o mwanji ni wu mendini ya wu sawe, “Mwe naha, dori hima rini ka Gotri mwanji bwarakarano hima to do tasinda.” ");
INSERT INTO kwj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wondawani fwele sawe, “Rini Kurais.” Ete wowani fwele ya wu sili, “Hinde, Kurais to ka Galili mapwa ki takondauꞌu? ");
INSERT INTO kwj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","E, Gotri chengi ete sawero, Kurais rini Defit hima kupu fo hinga imbihumbwa Defit daro ko, Betelehem, ko ki sukwano.” ");
INSERT INTO kwj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","O hinga wu bwa bwa nerimbe fisi ya wu huwa. ");
INSERT INTO kwj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hima fwele rini toroꞌinji kinani wu woro ti, hima fori tapa rini toro nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ete wosiwani apungwandai kicha hima le, puris hima lei apukolaka le, e, Farisi hima le tambwa ya wu ai i. Wowani ya wunu sawe, “Hinde wowani rini ku rata nambwe?” ");
INSERT INTO kwj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ete wowani apungwandai kicha hima lenga mwanji wasa ka hinga ya wu sawe, “Imbihumbwa hima fori, kari hima bwandau mwanji hinga bwa nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wowani Farisi hima lenga ya wu sawe, “Rini kunu okwe kunu gamboroꞌo? ");
INSERT INTO kwj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nunu mekupu hima lenga Farisi hima lenga, ku heiwani nunu fori rini ni sembe nu haroꞌo? ");
INSERT INTO kwj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mina. Woro kale himiyama hurahama Gotri lo mwanji wu hikisandau. O keke Gotri wunu wosiwani huruhumba naha wu sirasindau.” ");
INSERT INTO kwj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wowani Nikotimas, imbihumbwa Jisas tambwa iro wui hima kupu forito ya wunu ri sawe, ");
INSERT INTO kwj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ka nui lo mwanji hima ni nindumwasari nomo rini nu ha ki nunu ohounaroꞌo? Mina. Ri mwanji ti nu mendini ri wosiro sumbu ti norukweni nu hambwasini pwe.” ");
INSERT INTO kwj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wowani wunu ga mwanji wasa ti ka hinga ya rini wu sawe: “Wo mini okwe Galili hima foriꞌi? Gotri chengi ti ma norukweni heini hambwa. Gotri mwanji bwarakarandau hima fori Galili mapwa ki hinde sukwa kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ete wosini ele hima wui aka lengu tokwe hisiwasi ya wu ichiꞌucha. Ete wowani Jisas Olif kimba laka tokwe ya ri i. ");
INSERT INTO kwj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wosini lindanakondawani nurumbumbwa ri saini Gotri aka laka tokwe ya ri ai i. Wosiwani himiyama hurahama miyafo rini haweini ya wu wau. Wosiwani ri litisini ya wunu ri ondiyakandiyanda. ");
INSERT INTO kwj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wondawani Gotri lo mwanji ni ondiyakandiyandau hima lenga Farisi hima lenga anahopwesini walambe sumbu ai wosiro humwe fotini ya wu rata. Wu ratani o humwe hima wemi naha ki ya rini wu esi. ");
INSERT INTO kwj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wosini Jisas ni ka hinga ya wu sawe, “Ondiyakandiyandau hima, do humwe anahopwesini walambe sumbu ti wondawani hima le tini heifikaro. ");
INSERT INTO kwj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses lo mwanji ete nunu sawero, do humwe miya hinga ti humokuto ti ma nu takehe. Mini hinde hinga mi sawekondau?” ");
INSERT INTO kwj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ka mwanji hinga rini wu sawero ti, rini wu kotimwono numbo foti wu waki kinani ekeme wosindau hinga rini wu simiyaro. Wowani Jisas ri litini mwa ti ri onongosini tapa tongo rihi ki nuwe tiki ya ri kainda. ");
INSERT INTO kwj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wondawani rini wu sili siliwani ri saini ri etisini ya wunu ri sawe, “Kui nindo ki hima fori kapwa sumbu fo rini ki da nambwe nawa, humokuto foti metengei naha do humwe ni sa ri takehe.” ");
INSERT INTO kwj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wosini ri ai litini mwa ti ri onongosini nuwe ki ya ri ai kainda. ");
INSERT INTO kwj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ete wowani o mwanji ni wu mendikoni wunu funda funda wu saini hoko tokwe ya wu raru. Mekupu hima le mwaseni wu raruwani wunu fwele ya wu jepi. Wosini Jisas wu hanjaꞌaisiwani barikapwa ri dawani o humwe to ri miyaningisopo ki ya ti eninda. ");
INSERT INTO kwj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Wondawani Jisas saini etisini o humwe ni ya ri sawe, “O bai humwe, hima mwe le soki dau? Hinde, hima fori nini kotimwo nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wowani o humwe ga ya sawe, “Apukolaka, hima nambwe.” Ete wowani Jisas ya tini sawe, “Ani okwe nini a kotimwo nambwe. Ya ma i, wosini ichekai kapwa sumbu fo ai wosi kei.” ");
INSERT INTO kwj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wosini Jisas ya ri ai wunu sawe, “Ani nuwe ki okundau hi. Ani sirinano hima ri hundu tiki hinde apa ri i kumbwa, mina. Rini himamwale ga dau hi tini ri torono.” ");
INSERT INTO kwj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wowani Farisi hima le ya rini sawe, “Mini mi inakahambwa mwanji ni minjenga mi okula kinani amwei mi bwandau. O keke mwanji mihi ti mwe naha mina.” ");
INSERT INTO kwj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ete wowani Jisas ga mwanji wasa ya wunu sawe, “O mwe naha, ani ai inakahambwa mwanji leni anjenga ani okula kinani amwei a sawendau. Woro o ai mwanji mwe naha. Hinde wowani, a taro ko ti ani hambwanda, e, ani ai ino ko ti okwe ani hambwanda. Woro kunu a taro ko tinga ani ai ino ko tinga ku hikisandau. ");
INSERT INTO kwj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kunu nuwe pe sumbu tini ku sirinani hima ni ku kilindau. Ani hima forini a kilinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","E, hima ni a kili kinapo, ani norukweni rini a kilino. Hinde wowani, ani bati mina, ani humbwewani a taro Yapai to ani ga funda si randau. ");
INSERT INTO kwj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo mwanji kuhi ki ka hinga sawesindau: E, hima fisi o mwanji hinga numbwa hima i mwakambe ki amwei fi bwawa, o mwanji fihi mwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ani anjenga ani okulani mwanji ahi numbwa amwei a bwandau, wondawani ani humbwewani a taro Yapai to ai gumwa ki ri etisini ani keke o mwanji numbwa ri bwandau.” ");
INSERT INTO kwj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wowani ya rini wu sili, “Yapai mihi soki dau?” Wowani Jisas ga mwanji wasa ya ri sawe, “Ani ga ai Yapai ga sini ku hambwanda nambwe. E, ani ku ani hambwapo ai Yapai okwe ku hambwau.” ");
INSERT INTO kwj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ele mwanji hinga ri bwaro ti, Gotri aka laka we ki kwai anguꞌomwe owendau aka tipa ki ele himiyama hurahama ni ri ondiyakandiyandani ri bwaro. Woro hima fori rini toroꞌinji nambwe. Hinde wowani, gisi rihi mwe ti ta nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Wosini ya ai wunu ri sawe, “Ani ya ani ikondau, wosiwa ku ani wakikonda. Wondani kunu kapwa sumbu kuhi tinga ya ete ku handakonda. Ani ino ko ti hinde apa ku ta kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ete wowani Juta hima kupu le ya wu sawe, “Hinde wowani ete ri sawero, ‘Kunu ani ino ko ti hinde apa ku ta kumbwa’? Ka rinjenga ri ai yeni ri sikondau poꞌumo?” ");
INSERT INTO kwj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wowani ya wunu ri sawe, “Kunu do kai nuwe ki ku taro. Ani kari kau me ki a taro. Kunu ahaꞌa nuwe kipe hima tiya. Ani do nuwe kipe hima mina. ");
INSERT INTO kwj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","O keke kunu a sawehiro, kapwa sumbu kuhi tinga ete ku hakonda. E, ani ka hima hinga ani nandau tini sembe ku ani ha nambwe nawa, kapwa sumbu kuhi tinga ya ete ku handakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wowani ya rini wu sili, “Wo mini namo?” Ete wowani Jisas mwanji wasa ya wunu ri sawe, “Ani imbihumbwa ete kunu a sawendaro hima tombwa. ");
INSERT INTO kwj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ani kunu a kilino mwanji miyafo ani ki dau. Woro kari ani humbwewani a taro hima ori, ri sumbu ti mwe naha. Ele mwanji hinga tinda ete rini ki a mendiro ti, do nuwe ki dau himiyama hurahama leni a sawendau.” ");
INSERT INTO kwj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wowani ri Yapai ni sawero mwanji rihi ti wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wosini Jisas ya wunu sawe, “Ichekai Hima ri Che dori ni o ku rasaikonda, wosini o gisi kumbwa ka hima hinga ani nandau tini ku ani hambwakonda. Wosinumbwa o ku hambwakonda, ani mwanji foti ai inaka ki a bwanda nambwe mina, Yapai ani ondiyakandiyaro mwanji hinga numbwa a bwandau. ");
INSERT INTO kwj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kari ani humbwewani a taro hima ri ani ga o da. Rini ani hanjaꞌaisiwani barikapwa a da numbwa. Mina. Hinde wowani, gisi gisi ele sumbu hinga ri okokonandau tumbwa a wondau.” ");
INSERT INTO kwj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","O mwanji hinga ri bwawani himiyama hurahama miyafo sembe ti ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wosiwani Jisas Juta hima kupu le sembe rini ni haro hima leni ya ri sawe, “E, kunu ani ondiyakandiyaro mwanji tini ku toronambuwa kunu ai himache minde naha. ");
INSERT INTO kwj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wondani mwanji mwe naha tumbwa ku hambwandano. Wosiwa o mwanji mwe naha tombwa kunu wosiwa lalaunasini ete ku dano.” ");
INSERT INTO kwj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wowani wunu ga mwanji wasa ti ka hinga ya wu sawe: “Nunu Epuraham hima kupu. Nunu gisi fo hima fori nunu ekichasiwani nindumwasari ri tau ra himache hinga nu da nambwe. Woro hinde wowani ka mwanji hinga ni nunu mi sawero, ‘Kunu lalaunasini ku dano’?” ");
INSERT INTO kwj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Wowani Jisas ga mwanji wasa ya wunu ri sawe, “Mwanji mwe naha ki kunu a sawendau: Ele hima hinga tinda ete kapwa sumbu wu wondau ti, o wui kapwa sumbu tito apukolaka hinga etisini wunu ekichasindau. ");
INSERT INTO kwj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nindumwasari tau ra himache fori ya tiki rini rataro hima i aka ki ri hima kupu fo hinga hinde apa ete ri da kumbwa mina, ri che minde naha tombwa ri aka ki ete ri dano. ");
INSERT INTO kwj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","O keke Hima ri Che dori kunu wosiwani lalaunasini ku dau ti, kunu lalaunasini mwe naha ku dau. ");
INSERT INTO kwj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ani, ani hambwanda, kunu Epuraham hima kupu. Woro ku ani yeni si ki ku anakwendau. Hinde wowani, kui sembe we ki ai mwanji fo ku toro nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ani ai Yapai miyaningisopo ki ani heiro mwaꞌambwe tini kunu a bwandau. Wowani kunu kui yapai kunu sawero sumbu ni ete ku sirinandau.” ");
INSERT INTO kwj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ete wowani wunu ga mwanji wasa ka hinga ya wu sawe, “Nui yapai Epuraham.” Wowani Jisas ya wunu sawe, “E, mwe naha kunu Epuraham anitafenita napo, Epuraham wosindaro sumbu hinga napo, ku wosiu. ");
INSERT INTO kwj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ani Gotri ki a rataro mwanji mwe naha numbwa tinda ete kunu a sawendau. Woro apa o keke ku ani yeni si ki ku anakwendau. Epuraham o sumbu hinga ri wosi nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kunu kui yapai wosindau sumbu hinga numbwa ku wosindau.” Wowani wunu ga ya rini wu sawe, “Nunu nui nuwai hima numbo tenge humwe hinga wosini nunu ra nambwe. Nui Yapai funda naha ritombwa dau, rini Gotri.” ");
INSERT INTO kwj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ete wowani Jisas ga ya wunu sawe, “E, Gotri kui Yapai mwe naha napo, o ku ani okokonano. Hinde wowani, ani Gotri ga a daro tito a tasini do a da. Ani ai okokona ki a ta nambwe mina, Gotri to ani humbwewani a taro. ");
INSERT INTO kwj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hinde wowani ai mwanji norukweni ku ani hambwanda nambwe? Do mwanji mu mwe ti ka hinga: Kunu ai mwanji ti wasamba yayanasini ku mendinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Kunu kui yapai, Saiten, to kunu raro. Wosiwani kunu kui yapai ri okokona tunumbwa ku sirina ki au kunu saindau. Imbihumbwa kapwa rini hima ete ri yeni ri sindaro. Wondani rini sumbu mwe naha tini ri sirinanda nambwe. Hinde wowani, sumbu mwe naha rini ki da nambwe. Nimba gambo mwanji ri bwandau ti, o ri sumbu ni ete ri sirinandau. Rini mwanji nimba gambondau hima, wosini rindombwa mwanji nimba gambondau hima ele wui yapai. ");
INSERT INTO kwj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ani mwanji mwe naha ki a bwandau. Woro o keke kunu ai mwanji ni sembe ku handa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kui nindo ki hinde na hima naha foto ani ki dau kapwa sumbu foti amwei ri wono? E, mwanji mwe naha ki a bwandau nawa, wo hinde wowani mwanji ahi tini sembe ku handa nambwe? ");
INSERT INTO kwj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gotri ri che ri, rini ele Gotri mwanji hinga tinda ri mendindau. Woro kunu Gotri che mina. O keke kunu ri mwanji ku mendinda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wowani Juta hima kupu lenga mwanji wasa ya rini sawe, “Mwanji mwe naha ki ka mini nu sawendau ti mi hambwanda nambweꞌe: Mini Sameriya ko kipe hima, wosiwani himamwale kapwa foti mini ki o da?” ");
INSERT INTO kwj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wowani Jisas ga mwanji wasa ya ri sawe, “Ani himamwale kapwa foti ani ki da numbwa. Mina. Ani ai Yapai hi tini a rasaindawani kunu hi ahi tini ku rakai kinani ku wondau. ");
INSERT INTO kwj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ani hi ahi tini a rasai ki a wonda nambwe. Woro hi ahi tini ri rasaindani koti mendindau hima hinga fo o da. ");
INSERT INTO kwj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mwanji mwe naha ki kunu a sawendau: E, hima fori mwanji ahi ni ri sirinano ti, rini hinde apa ri ha kumbwa. Minambwe naha.” ");
INSERT INTO kwj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ete wowani Juta hima kupu lenga ya rini sawe, “Apa mini nu hambwahiro, himamwale kapwa mini ga dau. Epuraham hasiwani Gotri mwanji bwarakarandaro hima le okwe haro. Wosiwani apa ka hinga o mi sawenda, ‘E, hima fori mwanji ahi ni ri sirinano ti, rini hinde apa ri ha kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Hinde hinga mi hambwandau? Mini ka nui atei Epuraham ni mi dikisindauꞌu? Rini haro. Gotri mwanji bwarakarandaro hima le okwe haro. Mini bwele hima hinga minjenga mi hambwandau?” ");
INSERT INTO kwj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wowani Jisas ga mwanji wasa ya ri sawe, “E, ani hi ahi tunumbwa a rasaiwa, hi ahi ti tikisapu hinga. Woro ai Yapai, rini kui Yapai hinga ku nandau ti, rindo hi ahi ti ri rasaindau. ");
INSERT INTO kwj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Woro kunu rini ni ku hambwanda nambwe. Ani rini ani hambwanda. E, ete a sawepo, ‘Ani rini ani hambwanda nambwe,’ wopo ani apa kunu hingambwa mwanji nimba a gambono. Woro ani rini ani hambwandani ri mwanji norukweni a sirinandau. ");
INSERT INTO kwj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Kui atei Epuraham gisi ahi ri hei ki ri hambwaro tini nimba ete ri eripeꞌaripero. O tini ri heisini sembe rihi ti kipe naha ya i.” ");
INSERT INTO kwj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wowani Juta hima kupu le ya rini sawe, “Mini asama mihi ti 50 hinga i nambwe, woro Epuraham mi heiroꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ete wowani Jisas ya wunu sawe, “Mwe naha ki kunu a sawendau: Epuraham sukwa nambwe dawani ani ete a daro.” ");
INSERT INTO kwj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","O hinga ri bwawani Jisas ni humokuto ba wu ekeheni rini wu ye kinani humokuto ti ya wu ruko. Wokowani Jisas Gotri aka laka ri hanjaꞌaisini ri yanini hoko tokwe ya ri raru. ");
INSERT INTO kwj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wosini Jisas ini miyasa hima fori ya ri hei. Ri nuwai rini raro gisi ki miya ete rini sasiro. ");
INSERT INTO kwj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wowani Jisas himache le ya rini sili, “Ondiyakandiyandau hima, namoto kapwa sumbu wosiwani ori che miya sasiwani ri nuwai ete rini raro? Ori hima mwe to kapwa sumbu woroꞌo, ri nuwai yapai to kapwa sumbu woro?” ");
INSERT INTO kwj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Wowani Jisas ga mwanji wasa ka hinga ya ri sawe: “Dori hima kapwa sumbu wo nambwe, e, ri nuwai yapai kapwa sumbu wo nambwe. Mina. Do sumbu hinga sukwaro ti, apa Gotri tau ti dori hima ki amwei o sirakonda. ");
INSERT INTO kwj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Apa lindanasindau, o keke ka ani humbwewani a taro hima ri tau ti ma nu randa. Hundu o ya tanda, wowa hima fori tau hinde apa ra kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Do nuwe ki a dano gisi ete dawa, ani do nuwe ki lindana hinga.” ");
INSERT INTO kwj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O hinga ri bwasini sungwa ti nuwe ki ri yini nuwe ga apenesini goro oti ri toroni ori hima i miya tiki ya ri hindi. ");
INSERT INTO kwj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wosini ya rini sawe, “Ma ini Siloam fwanjuwei ki uku ti ma ya.” Siloam hi mwe ti nu jamekowani ka hinga: “Humbwewani iro.” Wowani ri ini o fwa ki uku ti ya ri ya. Wosini kipe ri wosisini ri ai tani ya ri maꞌaikaꞌainda. ");
INSERT INTO kwj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wondawani o ri ko kumbwa funda wu dau hima le, e, imbihumbwa rini heiwani ya mwaꞌambwe keke wunu ni uchandaro hima le ya wu sawe, “Dori hima ka litisini ele hima ni ya mwaꞌambwe keke uchandaro himaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wowani fwele sawe, “E, ori hima o to.” Wowani fwele sawe, “Mina. Ka bai hima ori hima hingambwa, woro rini hima ba fo.” Ete wowani ori hima rinjenga ya ri sawe, “O ando sa to.” ");
INSERT INTO kwj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wowani ya rini wu sawe, “Hinde wowani miya mihi ti kipe ai mini wosiro?” ");
INSERT INTO kwj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ete wowani rini ga mwanji wasa ti ka hinga ya ri sawe: “Jisas hi ete wu uchandau kari hima, rindo nuwengoro ri apenesini ai miya ki ya ri ani hindi. Wosini ya ri ani sawe, ‘Ma ini Siloam fwanjuwei ki uku ti ma ya! Wowani ani ini uku a yawani kipe ani wosisiwani ya a maꞌaikaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wowani ya rini wu sawe, “Kari hima soki dau?” Ete wowani ya ri sawe, “Ani a hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wowani imbihumbwa miya rini sasiro hima ori ni Farisi hima le tambwa ya rini wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Woro Jisas nuwengoro ri apenesini ori hima i miya ki ri hindiwani ori hima miya ti kipe ai rini wosiro gisi ti himati gisi foki ri wosiro. ");
INSERT INTO kwj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wosiwani ya rini wu ai sili, “Miya mihi ti kipe hinde hinga wai mini wosiro?” Wowani ya ai wunu sawe, “Nuwengoro ti ai miya ki ri hindiwani ani ini uku ti a yawani miya ahi ti ani ai riparo.” ");
INSERT INTO kwj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ete wowani Farisi hima fwele ya wu sawe, “Gotri kari hima ni humbwewani ta nambwe. Hinde wowani, rini himati gisi ni ri sirina nambwe.” Ete wowani hima fwele sawe, “E, hima fori kapwa sumbu ga dano ti, ka kwambu chele sumbu hinga hinde hinga apa ri wosino?” O hinga wu anambwakoni nerimbe fisi ya wu huwa. ");
INSERT INTO kwj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wosini miyasa hima ori ni ya wu ai sawe, “Kari hima miya mihi ti kipe ri wosiro. Wosiwani mini hinde hinga rini mi saweno?” Wowani ya ri sawe, “Rini Gotri mwanji bwarakarandau hima fo.” ");
INSERT INTO kwj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wowani ele Juta hima kupu le miya sasiwani ete rini raro ori hima apa kipe ai rini wosiwani ri maꞌaikaꞌaindau sumbu ni sembe wu ha ki wu diyaha. Wofunu o miya ai maꞌaikaꞌaindau hima, ri nuwai yapai ni ya wu ucha. ");
INSERT INTO kwj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ete wowani fi tawani ka hinga ya fini wu sili: “Dohaꞌa ki cheꞌe? Ka ki sawewani nu mendiro miya sasiwani ete raro che kihi dohaꞌaꞌa? Woro hinde wowani apa ri ai maꞌaikaꞌaindau?” ");
INSERT INTO kwj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wowani ri nuwai yapai mwanji wasa ya fi sawe, “Si hambwanda, do che o si che, miya sasiwani ete rini raro che sihi. ");
INSERT INTO kwj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Woro hinde wowani apa ri ai maꞌaikaꞌaindau, o sumbu hinga si hikisandau. E, miya kipe rini wosiro hima ri okwe si hikisandau. Kundo ma rini ku silinehei. Hima laka ri saihiro. Mwanji ti rinjenga ori bwakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ri nuwai yapai o hinga fi sawero ti, Juta hima kupu le keke fi akifuni fi sawero. Hinde wowani, Juta hima kupu le mwanji ti ka hinga wu injiro: E, hima fori Jisas hi tini ete ri sawewa, rini Kurais, wowa apa lotu wo aka wuhi ki rini toroꞌepikinawa funda ete sirani ri ino. ");
INSERT INTO kwj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","O sumbu hinga keke ri nuwai yapai ka hinga fi sawero, “Si che hima laka sairo. Ma rini ku silinehei.” ");
INSERT INTO kwj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wowani imbihumbwa miya sasiro hima ori ni wu ai uchawani ri tawani numbo fisi ya rini wu sawe, “Mini Gotri hi tini ma rasai. Nunu nu hambwanda, kari hima rini kapwa sumbu wondau hima.” ");
INSERT INTO kwj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ete wowani rini ga mwanji wasa ka hinga ya ri sawe: “E, ani a hikisandau, rini kapwa sumbu wondau hima poꞌo, mina. Ani sumbu fonumbwa ani hambwanda. Imbihumbwa miya ani sasiro tito apa ya ani ai maꞌaikaꞌainda.” ");
INSERT INTO kwj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wowani ya rini wu sawe, “Bwele sumbu hinga mini wosiro? Miya mihi ti hinde hinga mini ri okulawani riparo?” ");
INSERT INTO kwj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ete wowani rini ga mwanji wasa ka hinga ya ri sawe: “Kunu a sawero ti, ai mwanji ku mendi numbwa. Hinde wowani ku ai mendi ki? Kunu okwe ri himache hinga ku sira kiꞌi?” ");
INSERT INTO kwj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wowani kapwa mwanji ki ya rini wu saweholiya, “Mindombwa ri himache. Nunu Moses himache. ");
INSERT INTO kwj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nunu nu hambwasinda, Gotri ri mwanji ti Moses ni ri bwaro. Woro kari hima rini so mapwa ki ri taro, nunu rini nu hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wowani ori hima ga mwanji wasa ya wunu ri sawe, “O kui mwanji ba fo naha! Kunu ku hikisandau so mapwa ki ri taro ti, woro rindo miya ahi ti ri riparo! ");
INSERT INTO kwj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nunu nu hambwanda, Gotri kapwa sumbu wondau hima lei mwanji ti ri mendinda nambwe. E, hima fori Gotri ni lotu wondani Gotri ri okokona tunumbwa ri sirinandano ti, Gotri ri mwanji mendindau. ");
INSERT INTO kwj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Imbihumbwa kapwa ki ete ta tani miya sasiwani nuwai ete rini raro hima i miya ti ai ripasiro sumbu ti nu mendinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","E, Gotri kari hima ni ri humbwewani ri ta nambwe napo, apa sumbu fo hinde ri wosikoro ambwa.” ");
INSERT INTO kwj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wowani wunu ga mwanji wasa ya rini wu sawe, “Kapwa sumbu keke o hinga mini rasiwani o ki ete mi dau. Wosini apa nunu ni mi ai ondiyakandiyakondauꞌu?” O mwanji hinga rini wu bwakoni ya rini wu toroꞌepikina. ");
INSERT INTO kwj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas ri mendiwani ele hima rini saweni epikinawani ri iro. Woro ori hima ni ri ai heini ya ri sawe, “Mini Hima ri Che dori ni sembe mi haroꞌo, mina?” ");
INSERT INTO kwj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wowani mwanji wasa ya ri sawe, “Apukolaka, namoni mi sawendau? Mi ani sawewa sembe ti rini ani ha.” ");
INSERT INTO kwj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ete wowani Jisas ya rini sawe, “O rini mi heihiro. Rini dohaꞌa mwanji mini ga si bwandau.” ");
INSERT INTO kwj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wowani ori hima ya sawe, “Apukolaka, mwe naha sembe ani handau.” Ete ri nakoni seke ri ombungweni Jisas ni ya ri lotu wo. ");
INSERT INTO kwj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wowani Jisas ya sawe, “Ani hima leni a kili kinani do nuwe ki a sikaro. Woro keke ele miyasa himako kipe wu ai heindawa miya heindau himako ele ai wunu sakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wowani Farisi hima fwele rini ga takaini daro le ka mwanji hinga wu mendini ya rini wu sawe, “Wo, nunu okwe miyasaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wowani Jisas ya wunu sawe, “E, miyasa hinga ku dapo, kunu kapwa sumbu nambwe. Woro ete ku sawendau, ‘Miya nuhi ti kipe nu heindau,’ o hinga ku sawendau ti keke kapwa sumbu kunu ki ete dau.” ");
INSERT INTO kwj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Mwe naha ki kunu a sawendau: Sipisip ini lengenumbo naha tiki rarunda nambwe ini alase tiki rauni kwai ai raindau ti, ori hima hinga rini hiliya hima, e, mwaꞌambwe matinani raꞌaindau. ");
INSERT INTO kwj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Woro, lengenumbo naha tiki rarundau hima ori, rini sipisip aulini dau hima. ");
INSERT INTO kwj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lengenumbo aulini dau hima ri rini keke lengenumbo ti ya ri tukwasi. Wowani ri raruni sipisip ele ni hi wuhi ki wunu ri uchawani ata rihi ti ya wu mendi. Wowani hoko tokwe ya wunu ri rakwai. ");
INSERT INTO kwj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ele ri sipisip hinga tinda ete hoko tokwe ri rakwaisini rindo ele sipisip ni mwaseni ya ri iu. Wowani ele sipisip ri ata gale ti wu mendikoni rini sirinani ya wu iu. ");
INSERT INTO kwj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hima ba forini hinde apa wu sirinani wu i kumbwa. Mina. Apa rini heini akini ino. Hinde wowani, o ri ata gale ti wu hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas do mwanji yepe hinga wunu ri sawesiwani wunu o mwanji yepe mu mwe ti wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ete wowani Jisas ya ai wunu sawe, “Mwe naha ki kunu a sawendau: Ani andombwa sipisip lei lengenumbo. ");
INSERT INTO kwj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ele hima hinga tinda ete ani ni mwaseni taro le, wunu hiliya hima, e, mwaꞌambwe matinani raꞌaindau. Woro ele sipisip wui mwanji ti wu mendinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ani andombwa lengenumbo. E, hima fori ani tambwa ri tani ri raruwa, Gotri apa ai rini ratano. Wosiwa apa rini o lengenumbo ki ri rarususirasindani ahirahi ti ri wakini ano. ");
INSERT INTO kwj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Hiliya hima ri sumbu fo keke tanda nambwe, rini sipisip leni hili raꞌai ki, wunu yeni si ki, e, walambe wunu i ki tandau. Woro ando a taro ti, himamwale ti wu torowa o tito wui sembe ki wunu tale kinani a taro. ");
INSERT INTO kwj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ani sipisip aulindau hima kipe naha. Woro sipisip aulindau hima kipe naha ri o ri sipisip leni okula ki ri himamwale ti ri ohumbwendau. ");
INSERT INTO kwj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hima fori ya kekembwa sipisip nimba ri aulindau ti, rini yapai chele sipisip mina. Ori hima hinga fuku pe asa ri heiwa tawa ele sipisip ri andosini akini ino. Wowa fuku pe asa oti ele sipisip ni enginaꞌi enginatani ya wunu sendano. ");
INSERT INTO kwj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Hinde wowani, o sumbu hinga ri wosiro ti, rini ya kekembwa tau randaro hima. Rini ele sipisip keke gamweche ri ri wo nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ani sipisip aulindau hima kipe naha. Ani ai sipisip le wunu ani hambwandawani wunu okwe ani wu hambwandau. ");
INSERT INTO kwj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","O sumbu to, Yapai ani ni ri hambwandawani ani okwe Yapai ani hambwandau hinga. Woro ai himamwale ti ele sipisip keke ani ohumbweno. ");
INSERT INTO kwj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ani sipisip ba fwele okwe dau, woro wunu do ini we pe mina. Wunu okwe a rata ki inaka kwambu ki ani hambwanda. Wunu a ratasiwa ai mwanji ya wu mendikonda. Wosini nerimbe funda naha hinga wu dawa, hima funda naha tombwa wunu aulindano. ");
INSERT INTO kwj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yapai ani keke ri wondau. Hinde wowani, ai himamwale ti ani ohumbwesini o tini ani ai torokondau. ");
INSERT INTO kwj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hima fo ai himamwale ti hinde apa raꞌai kumbwa. Mina. Ai okokona kumbwa apa ai himamwale ti ani andosino. Ai himamwale ti ani andosino kwambu ga ai himamwale ani ai torono kwambu ga a torosindau. Woro do kwambu ai Yapai ani hasiwani a torosindau.” ");
INSERT INTO kwj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juta hima kupu le o mwanji ni wu mendini wunjenga wui nindo ki ya wu huwa. ");
INSERT INTO kwj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wosini hima miyafo naha ya wu sawe, “Himamwale kapwa ti rini ga dau, wondawani ori ambwatinambwatindau. Bwele keke ri mwanji ti ku mendindau?” ");
INSERT INTO kwj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ete wowani fwele ya wu sawe, “Ele mwanji ri sawero ti, himamwale kapwa tinga dau hima i mwanji hinga mina. Himamwale kapwa tito apa hinde hinga ri wowa ka miyasa hima i miya ti ripano?” ");
INSERT INTO kwj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dani ini Jerusalem ko tiki gisi laka foti ya sukwa. Imbihumbwa Gotri aka laka wu ai tukwaro gisi tito ya ai ta. Ka gisi oti tikiningo andau gisi. ");
INSERT INTO kwj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O gisi ki Jisas Gotri aka laka ki dau Solomon tapa aka tako ki ya ri inda. ");
INSERT INTO kwj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wondawani Juta hima kupu le tani rini wu haweini wu etisini ya rini wu sili, “Numbo geni apa nui sembe ti mi wosindawa inaka fisi nu hambwandano? E, mini Kurais nawa, amwei ma nunu sawefika.” ");
INSERT INTO kwj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wowani Jisas mwanji wasa ya ri sawe, “Kunu a sawero ti, sembe ku ha nambwe. Kale kwambu chele sumbu ai Yapai hi ki a wosindau tito hi ahi ti amwei wondau. ");
INSERT INTO kwj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Woroti kunu sembe ku ha nambwe. Hinde wowani, kunu ai sipisip mina. ");
INSERT INTO kwj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ani ai sipisip le ai mwanji ti wu mendindau. Ani wunu ni ani hambwandawani wunu okwe wu ani sirinandau. ");
INSERT INTO kwj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ani ete da ete da himamwale ti wunu ani handau, wosiwa hinde apa walambe wunu i kumbwa. Minambwe naha. E, hima fori ai tapa tenge tiki hinde apa wunu ri raꞌai kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E, wunu ni ri ani haro Yapai to ele mwaꞌambwe hinga tinda ete ri dikisindau. Woro ai Yapai tapa tenge tiki wu dau ti, hima fo apa tani hinde wunu raꞌai kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ani ga ai Yapai ga sini funda naha.” ");
INSERT INTO kwj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ete wowani ele Juta hima kupu le rini wu ekehe kinani humokuto ti ya wu ai ruko. ");
INSERT INTO kwj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Wowani Jisas ya wunu sawe, “Yapai ani okulawani kwambu chele sumbu miyafo naha kunu a mekuhiro. Wowani bwele sumbu ahi naha ni ku hambwasini humokuto ti ku ani takehekondau?” ");
INSERT INTO kwj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wowani Juta hima kupu le mwanji wasa ya rini sawe, “Mi wosiro sumbu fo keke humokuto mini nu takehenda nambwe, mina. Gotri ni mi saweholiyani minjenga Gotri mi naro keke.” ");
INSERT INTO kwj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Wowani Jisas ga mwanji wasa ti ya wunu sawe, “Kui lo mwanji ki Gotri ka hinga ri sawesinda: ‘Kunu gotri le.’ ");
INSERT INTO kwj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gotri ri mwanji ni mendini tororo himako ni “gotri” hinga wunu ri ucharo. Woro o sumbu Gotri chengi ki kaisindau ti, mwe naha tumbwa. Apa Gotri chengi nimba gambo hinga. ");
INSERT INTO kwj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yapai to rihi minde ri ani nasini ani humbwewani do nuwe ki a sikaro. Wosini ka ete a sawenda, ‘Ani Gotri Che.’ Woro o keke ka hinga ku ani sawendau: ‘Mini Gotri ni mi saweholiyandau. Wo hinde wowani o mwanji hinga ku sawendau? ");
INSERT INTO kwj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“E, ai Yapai tau tini a randa nambwe nawa, apa ai mwanji tini sembe ha kei. ");
INSERT INTO kwj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Woro ri tau tini a randau ti nawa, e, ai mwanji tini sembe ku ha ki au kunu sainda nambwe nawa, apa a randau tau ahi leni sembe ma ku ha. O hinga ku wosini kipe naha ya ma ku hambwa, Yapai ani ga dawani ani rini ga a dau.” ");
INSERT INTO kwj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ete wowani rini wu toroꞌinjikowani wunu ri dikisini ya ri i. ");
INSERT INTO kwj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wosini Jotan gara angi tokwe ri ai rachini ini Jon metengei naha hima leni uku wunu yasindaro michi tiki ri raruni o ki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wondawani himiyama hurahama miyafo rini tambwa wu tani ya wu sawe, “Mwe naha, Jon kwambu chele sumbu ambwe sumbu ambwe ri wosi nambwe. Woroti Jon do hima ni ri bwaro mwanji hinga tinda ete mwe naha tumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wowani ka michi ki hima miyafo naha sembe Jisas ni ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hahungondau hima fori ya da, hi rihi ti, Lasaras, Betani ko kipe. Betani oti Mariya ga ti apwai Mata ga fi ko. ");
INSERT INTO kwj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ka Mariya to Apukolaka ni sanda ti dawehenaro humwe, wosini ti mwa kopika tiki ri seke ti ti hindiro. Woro ti mindahara Lasaras to hahungondau. ");
INSERT INTO kwj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","O hinga keke ri kahaiche pi fisi Jisas ni mwanji sawehambwa ti fi humbweni ya fi sawe, “Apukolaka, o mi okokonandau hima ri apa hahungondau.” ");
INSERT INTO kwj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wowani Jisas o tini mendini ya ri sawe, “O hahungo sumbu ti hima handau sumbu ki hinde apa ambwe kumbwa. Mina. O hahungo ti himiyama hurahama le Gotri hi tini wu rasai ki sukwasini dau. O hinga wu wowa Gotri Che okwe apa hi laka ri torono.” ");
INSERT INTO kwj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas Mata ga ti hipache ga, e, Lasaras ga ete wunu keke ri wondau. ");
INSERT INTO kwj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mwanji sawehambwa fihi ri mendiwani Lasaras hahungondawani gisi fisi o michi ki ya ai ri da. ");
INSERT INTO kwj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka gisi fisi ini humbuwani ri himache leni ya ri sawe, “Jutiya mapwa tokwe ma nu ai i.” ");
INSERT INTO kwj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wowani ri himache le ya rini sawe, “Ondiyakandiyandau hima, imbihi naha Juta hima kupu le humokuto ti mini wu takehekosiwani apa o michi ki mi ai mi i kiꞌi?” ");
INSERT INTO kwj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wowani Jisas mwanji wasa ti ya wunu sawe, “Gisi funda riki tapwaki ti tapaꞌangi tapaꞌangi hatachi fisi amwa da nambweꞌe? E, hima fori tapwaki ri ino ti, hinde apa ri hichako kumbwa. Hinde wowani, do nuwe lindanasiwani ri heindau. ");
INSERT INTO kwj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Woro, niliki tiki ri iwa, ri hichakono. Hinde wowani, lindana ri heinda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","O hinga ri sawesinimbwa, wunu ya ri ai sawe, “Nui nau Lasaras tukuyahiro. Wosiwani ani ini rini a yetele.” ");
INSERT INTO kwj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wowani ri himache le ya rini sawe, “Apukolaka, ri tukuyandau ti nawa, kipe ai rini wosino.” ");
INSERT INTO kwj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas Lasaras to haro sumbu ni ri sawendawani ele ri himache leto wu hambwaro, Lasaras o nimba ri tukuyandau. ");
INSERT INTO kwj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ete wosiwanumbwa Jisas amwei ya wunu sawe, “Lasaras hahiro. ");
INSERT INTO kwj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Woro o gisi ani rini ga a da nambwe sumbu ti kunu keke ya ani eripendau. Hinde wowani, o sumbu keke sembe o ku hakonda. Apa rini tambwa ma nu i.” ");
INSERT INTO kwj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Wowani Tomas, hi foti ka hinga wu uchandau, Titimas, rindo ele himache fwele ni ya ri sawe, “Nunu okwe ma nu ini rini ga funda ete nu ha.” ");
INSERT INTO kwj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wowani Jisas ini o ko raruni ya ri hambwa, Lasaras gisi opuriꞌopuri wa we ki ri daro. ");
INSERT INTO kwj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ko ti Jerusalem ko laka ga anatakai, kilomita namili hinga. ");
INSERT INTO kwj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wondawani Juta hima kupu miyafo Mata hima pi Mariya ni sembe wahapi fini ha kinani fini tambwa ya wu ta. Hinde wowani, fi mindahara haro ti keke. ");
INSERT INTO kwj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata mendiwani Jisas ya tanda, wowani numbo tokwe rini hei ki ya ti i. Wondawani Mariya aka tiki ya ti da. ");
INSERT INTO kwj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata numbo ki Jisas ni heini ya rini ti sawe, “Apukolaka, ahaꞌa ki mi dapo, ai mindahara hinde hakoro ambwa.” ");
INSERT INTO kwj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Woro ani hambwanda, e, Gotri ni mwaꞌambwe fo keke mi uchahambwawa, apa mini ha sindau.” ");
INSERT INTO kwj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wowani Jisas ya tini sawe, “Apa ni mindahara o ai saikonda.” ");
INSERT INTO kwj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wowani Mata ya rini sawe, “Ani hambwanda, gisi jipe kumbwa rini ga ele himiyama hurahama ga funda wu ai saino.” ");
INSERT INTO kwj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ete wowani Jisas ya tini sawe, “Andombwa hasini ai saindau sumbu mu, e, andombwa himamwale ga dau sumbu mu. E, hima fori sembe ani ni ri hawa, himamwale ga ete ri dano, woro hima tape rihi ti humbuno. ");
INSERT INTO kwj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E, ele himamwale ga dau hima hinga tinda sembe ani ni wu hawa, apa hinde wu ha kumbwa, mina. Ete da ete da himamwale kipe ga ete wu dano. Ka mwanji ni sembe ni handauꞌu, mina?” ");
INSERT INTO kwj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wowani Mata ga Jisas ni ya ti sawe, “Ei, Apukolaka. Sembe ani hasindau, mini Kurais, mini Gotri Che. Mini do nuwe ki mi ta kinani Gotri imbihumbwa mini esisiro.” ");
INSERT INTO kwj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata o mwanji hinga sawesini ti ini ti hipache Mariya ni ya ti ucha. Wowani ti tawani tini ra ra aka sipi tokwe tini raꞌaisini usariche ya tini sawe, “Ondiyakandiyandau hima dohaꞌa tasinda. Wosini nini ri uchanda.” ");
INSERT INTO kwj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya o mwanji ni ti mendini metengei ete ri saini Jisas tambwa ya ti i. ");
INSERT INTO kwj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ko ki raru nambwe. Rini Mata rini heiro michi kumbwa ete ri dau. ");
INSERT INTO kwj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ele Juta hima kupu le, Mariya i sembe ti wu wahapisi kinani aka we ki tini ga wu daro leto wu heiwani metengei ete ti saini hoko tokwe ti raruwani tini wu sirinani ya wu i. Wunu ete wu hambwaro, ti ichaka ki matimat ki ti indau. ");
INSERT INTO kwj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya Jisas dau michi tiki ti raruni Jisas ni ya ti hei. Wokoni ri seke mu ki ti opulisini ya rini ti sawe, “Apukolaka, e, ahaꞌa ki mi dapo, apa ai mindahara ri hinde apa ri hakoro ambwa.” ");
INSERT INTO kwj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wowani Jisas tini heiwani ya ti ichakanda. Wondawani tini ga taro Juta hima kupu ele wunu okwe ya wu ichakanda. Ete wondawani rini okwe sembe nomo naha ri akoni ichakakoro naha. ");
INSERT INTO kwj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wosini ya ri sawe, “Soki rini ku andosiwani ri tukuyandau?” Wowani ya rini wu sawe, “Apukolaka, ma tani hei.” ");
INSERT INTO kwj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wowani Jisas ya ichaka. ");
INSERT INTO kwj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wowani Juta hima kupu le ya wu sawe, “Ma hei, rini do hima keke kipe naha ri wondaro.” ");
INSERT INTO kwj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ete wowani fwele ya sawe, “Dori hima miyasa hima ni kipe wosiro hima. Woro hinde wowani Lasaras ni ri okula nambwe, wosipo ri ha nambwe ri dakoro?” ");
INSERT INTO kwj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ete wowani Jisas sembe nomo naha ri ai akoni matimat tokwe ya ri i. Ka matimat humokuto laka foti wu goro sopu. Wosiwani humokuto beiye laka foti o sopu ta ni dimisindau. ");
INSERT INTO kwj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Wosini Jisas ya sawe, “Do humokuto beiye ma ku tukwa.” Wowani ori hima haro ri kahaiche Mata to ya rini sawe, “Apukolaka, ri hasiwani gisi opuriꞌopuri ihiro. O keke kapwa kuwa naha ya takondau.” ");
INSERT INTO kwj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wowani Jisas ya tini sawe, “Tambwa nini a sawero, e, sembe mwe naha ni hawa hi hinga okundau Gotri sumbu ni hei sindau.” ");
INSERT INTO kwj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wowani humokuto beiye oti ya wu tukwa. Ete wowani Jisas niri ki mausini ya ri sawe, “Yapai, mini a weseꞌanda, hinde wowani, mini ani uchahambwaro ti, mi ani mendihiro. ");
INSERT INTO kwj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ani ani hambwanda, gisi gisi mini ani uchahambwandau ti, mi ani mendindau. Woro dele himiyama hurahama do ki wu enindawani wunu keke do mwanji hinga mini a sawero, wosiwa sembe wu ha kinani, minjenga mi ani humbwewani a taro.” ");
INSERT INTO kwj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","O mwanji hinga ri bwasini hapa tinga ya ri ucha, “Lasaras, mini ma saini sira!” ");
INSERT INTO kwj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wowani haro hima ori saini ya ri sira. Seke tapa rihi ti nikaꞌari ti rini benisiwani miyaningisopo rihi ti nikaꞌari ti rini gwarosiro. Wowani Jisas ya wunu sawe, “Nikaꞌari ma rini hungosiwa sa ri i.” ");
INSERT INTO kwj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariya ni hei ki taro Juta hima kupu le Jisas wosiro o sumbu ni wu heini wunu miyafo sembe ti ya rini wu ha. ");
INSERT INTO kwj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ete wowani wunu fwele Farisi hima tambwa wu ini Jisas wosiro sumbu tini ya wu sawenda. ");
INSERT INTO kwj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wosiwani puris hima laka lenga Farisi hima lenga kanisol hima leni wu wausini ya wu sawe, “Kari hima bwele sumbu hinga rini nu wosino? Rini kwambu chele sumbu ambwe miyafo ri wosindau. ");
INSERT INTO kwj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","E, rini nu hanjaꞌaisiwa ete ri dawa apa dele hima miyafo rini numbwa sembe o wu hakonda. Wowa Rom pe hima le tani nunu ga nui hima kupu lenga walambe nunu wu woni nui Gotri aka laka ti o apa wu lendokonda.” ");
INSERT INTO kwj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wowani wui nindo ki dau hima fori, hi ti Kaiyafas, rini o asama ki puris hima i apukolaka hinga ri dau, woro rindo ya ri sawe, “Kunu gamweche ri ku hambwanda nambwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kunu ka mwanji ni ku hambwanda nambwe naha: Apa hima funda naha ri ri hasini ele hima hinga tinda nunu ri okulano sumbu ti kipe, apa nui hima kupu le tinda walambe ino sumbu ti nunu keke kipe mina.” ");
INSERT INTO kwj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ka mwanji hinga ri bwaro ti, ri inaka kumbwa ri hambwasini ri bwa nambwe, mina. Rini o asama ki aulindau puris hima i apukolaka. O keke Gotri mwanji bwarakarandau hima hinga ri bwaro, Jisas hasini Juta hima kupu leni okulano sumbu tini. ");
INSERT INTO kwj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Woro Juta hima kupu le numbwa ri okula ki mina. Rini dele nuwe mapwa ki dau Gotri che hinga tinda ri wausiwa hima kupu funda naha wu da kinani ri hakondau. ");
INSERT INTO kwj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Wosiwani wunu o gisi naha ki rini yewani hano mwanji tini ya wu bwani injinda. ");
INSERT INTO kwj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","O keke Jisas Juta hima kupu lei nindo ki amwei ri ichiꞌucha nambwe. Wowani o ko ete ri hanjaꞌaisini ko fo, hi ti Ifirem, hima da nambwe mapwa gamba tokwe dau, o ko tokwe ya ri i. Ri ini ri himache lenga ya wu da. ");
INSERT INTO kwj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wondawani Juta hima kupu lei Pasofa gisi laka ya takai. Wokowani ele ko ele ko ki dau hima le o gisi laka keke wui hima tape ti wu yokowa Gotri miyaningisopo ki kipe ai sira kinani Jerusalem ko laka ki ya wu i. ");
INSERT INTO kwj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wosini Jisas ni wu wakini wu hei kinani wu wondani Gotri aka laka we ki wu etisini wunjenga ka hinga ya wu anambwa anambwanda: “Hinde hinga ku hambwandau? Rini apa gisi laka nuhi ri hei ki ri takondau umo?” ");
INSERT INTO kwj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Puris hima laka lenga Farisi hima lenga ka mwanji hinga wu bwasinda: “E, hima fori Jisas so michi ki ri dau ti ri hambwawa, nunu ni sa ri sawehambwawa rini nu toroꞌinji ki.” ");
INSERT INTO kwj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wondawani gisi ti tapaꞌangi hatachi funda iwa Pasofa gisi laka sukwakondawani o gisi ki Jisas Betani ko tokwe ya ri i. Ka ko Jisas Lasaras ni wa we ki rini rasairo ko. ");
INSERT INTO kwj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wosiwani rini keke a laka ya wu ekikina. Wosini Mata ahirahi tindawani Lasaras to Jisas ga ahirahi andau hima lenga ya ri lininda. ");
INSERT INTO kwj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wondawani Mariya ya laka ki randau botoli ki talesindau weli kuwa kipe, hi ti naruto, ya ti rata. Wosini Jisas seke ki ti dawehenasini ti mwa kopika kumbwa ya ai rini hindi. Wowani o weli kuwa kipe naha ti sukwani aka we o ki ya ete ichiꞌucha. ");
INSERT INTO kwj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Wowani ri himache fori, Jutas Isukariyot, ichai rindo Jisas ni omwemendindau hima lei tapa tenge ki hano, woro rindo ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ka weli kuwa kipe nu raꞌaini hima foringa ya wungwa nu jipo asama funda tau rani nu torono ya laka hinga nu torou. Wosipo o ya nu raꞌaini bwarichape hima leni nu ha to!” ");
INSERT INTO kwj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O mwanji hinga ri bwaro ti, rini ele bwarichape hima keke ri woni ri sawe nambwe. Mina. Hinde wowani, rini hili ya hima. Rindo ya kowe ti ri aulindaro ti, o ki warondau ya gamweche hili ti raꞌaindaro. ");
INSERT INTO kwj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Woro Jisas ya sawe, “Ma tini hanjaꞌaisiwa sa da. Ka weli kuwa kipe tihi ti owesiwani daro ti, ai hima tape eini sino gisi keke ti owesiro. ");
INSERT INTO kwj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bwarichape hima le kunu ga nilitapwa ambwe ete wu dau. Woro ani kunu ga nilitapwa ambwe hinde a da kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ete wondawani Juta hima kupu miyafo wu mendiwani Jisas o ko ki ri dau. Wowani rini tambwa ya wu i. Wunu Jisas numbwa wu hei ki wu i nambwe. Mina. Wunu imbihumbwa Jisas wa we tiki rasairo Lasaras okwe rini wu hei ki wu iro. ");
INSERT INTO kwj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wowani ele puris hima laka le Lasaras ni wu yeni si kinani mwanji ti wu bwani ya wu injinga. ");
INSERT INTO kwj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Hinde wowani, Juta hima kupu miyafo Lasaras ni wu heikoni wui apukolaka le wu andosini Jisas numbwa sembe ti wu handaro keke. ");
INSERT INTO kwj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wosiwani lindanawani ele himiyama hurahama miyafo ka gisi laka ni wu hei ki tasini dau le wu mendiwani Jisas Jerusalem ko tokwe tanda. ");
INSERT INTO kwj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ete wowani naku tongo hinga le wu ra ra wu ini numbo tiki rini heini ya wu ucha: “Gotri hi tini ma nu rasai. Apukolaka i hi tiki tandau dori hima i hi tini ma nu rasai. Isurel lei King Apukolaka ri hi tini ma nu rasai.” ");
INSERT INTO kwj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Wondawani Jisas, hosi hinga fo, hi ti, dongi, akisai sairo fotini ri wakisini o tenge ki ri rauni ya ri liti. O sumbu hinga sukwaro ti, ka Gotri mwanji sawero hinga sukwaro: ");
INSERT INTO kwj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saiyon ko laka, apa aki kei. King Apukolaka mihi ya tau. Akisai dongi tenge tiki litisini ori tanda.” ");
INSERT INTO kwj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Metengei naha ri himache le ka mwanji mu mwe ti wu hambwa nambwe. Dani inumbwa Jisas hewen ko tokwe ri ai rauwanimbwa ya wu hambwa, ka Gotri chengi rini ni sawesiwani kale hima ele sumbu hinga rini ni wu wosiro. ");
INSERT INTO kwj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lasaras wa we tiki dawani Jisas rini uchani ai rini rasairo sumbu ni heiro himiyama hurahama to o Jisas wosiro sumbu ni ya wu bwani inda. ");
INSERT INTO kwj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Himiyama hurahama miyafo o kwambu chele sumbu ri wosiro tini wu mendiro ti keke rini wu hei kinani numbo tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wowani ele Farisi hima wunjenga wu anambwa anambwani ya wu sawe, “Ma hei, tau nuhi ti kipe inda nambwe. Wondawani ele himiyama hurahama hinga tinda rini ni sirinani ihiro.” ");
INSERT INTO kwj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Himiyama hurahama miyafo naha ka gisi laka ki Jerusalem ko tiki Gotri ni wu lotu wo ki wu rauro ti, wui nindo ki Girik pe hima fwele okwe ya wu da. ");
INSERT INTO kwj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ele Girik pe hima le Filip tambwa ya wu ta, Filip rini Galili mapwa tokwe dau Besaita ko kipe. Wosini ya rini wu sili, “Hima laka, nunu Jisas ni nu hei ki.” ");
INSERT INTO kwj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Wowani Filip ini Anduru ni sawe. Wowo findo fi ini Jisas ni ya fi sawe. ");
INSERT INTO kwj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wowani Jisas ga mwanji wasa ya sawe, “Hima ri Che dori hi laka torono gisi mwe ti apa sukwahiro.” ");
INSERT INTO kwj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mwe naha ki kunu a sawendau. E, witi wapa ti nuwe tiki sikasini hani kupwaꞌai nambwe nawa, o tindombwa naha dano. E, ri hani kupwaꞌaiwa, ri ai sukwani ahirahi mwe miyafo naha ai wano. ");
INSERT INTO kwj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hima fori ri himamwale tunumbwa ri enependano ti, himamwale rihi humbuno. E, hima fori dohaꞌa nuwe ki ri himamwale tini ri diyahawa, ori hima hinga ti ri himamwale ti ri toronambusiwa ete da ete dano. ");
INSERT INTO kwj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","E, hima fori ai tau ti ri randau ti, ori sa ani sirina. Wosiwa ka a dau ko tukumbwa apa ai tau ra himache ri o kumbwa ani ga si dano. E, hima fori ai tau rano ti, ori hima apa ai Yapai hi laka ti rini hano. ");
INSERT INTO kwj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Apa sembe ahi ti saitalekoni apapanandau. O keke hinde hinga a saweno? Ka hinga a sawenoꞌo, ‘Yapai, do amwa kipe nomo ma rani humbweꞌi’? Mina. Apa o hinga a sawe hinga. Oti o hinga keke do amwa ki a taro. ");
INSERT INTO kwj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yapai, hi mihi ti ma wowa omwesika sa sai.” Jisas o hinga ri bwawani, mwanji foti hewen ko tiki sukwani ka hinga ya sawe: “Hi ahi ti a wowani apukolaka saihiro, woroti numbo fonga ani ai wokonda.” ");
INSERT INTO kwj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wowani himiyama hurahama le ri mu tiki takaini wu enindaro leto o tini mendini ya wu sawe, “Niri ti o kunda,” wowani hima fwele ya sawe, “Ensel forito mwanji ti o rini sawenda.” ");
INSERT INTO kwj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wowani Jisas ya wunu sawe, “Do ata gale ani ni okula ki sukwa nambwe. Mina. O kunu ni okula ki sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gotri apa do nuwe pe himiyama hurahama leni wunu kilikonda. Wosini do nuwe ni aulindau hima apukolaka ri rini humbwewa ri ikonda. ");
INSERT INTO kwj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","E, do nuwe ki a dau ti, wu ani toroni rasaino gisi tawa, ele himiyama hurahama hinga tinda ete a matinani ani tambwa a ratano.” ");
INSERT INTO kwj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Woro o hinga ri sawero ti, ri hano numbo tini ri sawero. ");
INSERT INTO kwj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wowani himiyama hurahama le ya rini wu sawe, “Moses kaisiro lo mwanji ti ka hinga nu mendiro: Kurais ete da ete dano. Wo hinde wowani ete mi sawero, ‘Hima ri Che ni wu toroni wu rasaino’? Woro ka Hima ri Che namo?” ");
INSERT INTO kwj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Wowani Jisas ka hinga ya wunu sawe, “Kamindache naha lindana ti kunu ga o ete dakonda. Apa lindana ti kunu ga ete dawa, o lindana ki ma ete ku inda. Apa hundu ti kunu yoho ki. Hundu tiki indau hima ri, rini ri indau numbo ti ri hikisandau. ");
INSERT INTO kwj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Woro kunu o lindana kunu ga ete dau ki, o lindana ni sembe ti ma ku ha, wosini apa lindana i che hinga ku sira. Jisas o mwanji hinga ri sawesini, wunu ri andosini wui miyaningisopo ki ya ri yani. ");
INSERT INTO kwj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kwambu chele sumbu ambwe sumbu ambwe miyafo naha wui miyaningisopo ki ri wosindawani sembe ti rini ni wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","O hinga keke Gotri mwanji bwarakarandaro hima ri, Aisaiya, sawero mwanji ti mwe naha ya sukwa. Aisaiya ete sawero: “Apukolaka, namoto nui mwanji ni sembe haro? Wosiwani Apukolaka ri kwambu ti namoni ri mekuro?” ");
INSERT INTO kwj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ka mwanji keke Jisas ni sembe ti wu ha nambwe. Woro Aisaiya ri mwanji fotiki o sumbu ni ka hinga ri sawero: ");
INSERT INTO kwj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gotri wui miya ti wunu ri wosiwani saro. Wosini inaka ti humokuto hinga ri wosiro. O hinga keke mwaꞌambwe ti miya tiki hinde wu heini, inaka wuhi ki hinde kipe wu hambwani, sembe ti wu ani hawa kipe hinde wunu a wosi kumbwa. Mina.” ");
INSERT INTO kwj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya do mwanji hinga ri kairo ti, hi hinga okundau Kurais sumbu tini ri heisini rini ni kairo. ");
INSERT INTO kwj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mwe naha, mekupu hima le miyafo sembe ti rini ni wu haro. Woro Farisi himako ni wu akini wui sembe ha sumbu ti amwei wu wo nambwe. Ka hinga wu hambwaro, apa lotu wo aka tiki wunu toroꞌepikinawa wu sirano. ");
INSERT INTO kwj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wunu Gotri to wui hi ti rasaino ti wu okokonanda nambwe, mina. Wunu wui okokona ti hima leto wui hi tini wu rasai ki. ");
INSERT INTO kwj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Wosiwani Jisas uchani ya ri sawe, “Hima fori sembe ani ni haro ti, o ri sembe ti ani numbwa ri ha nambwe, ori ani humbwewani a taro Yapai ni sembe ti ri haro. ");
INSERT INTO kwj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Woro ori hima ani ni heindau ti, ori ani humbwewani a taro Yapai ni ri heindau. ");
INSERT INTO kwj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ani lindana hinga do nuwe ki a taro. O keke hima fori ani ni sembe ri hawa ori hima hundu tiki hinde ri da kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","E, hima fori ai mwanji tini ri mendini o tini ri sirina nambwe nawa, apa hinde rini a kili kumbwa. Hinde wowani, ani nuwe pe hima lei mwanji tini kilindau hima hinga a ta nambwe. Mina. Ani wunu ni ai a raꞌai ki a taro. ");
INSERT INTO kwj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ani ni gumwa sini ai mwanji ti mendi nambwe hima ri, mwanji rini kilino sumbu ti ya dau. Ka mwanji a bwaro to, gisi jipe tiki ori hima ni ai kilikonda. ");
INSERT INTO kwj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hinde wowani, o mwanji ai inaka tiki a bwa nambwe, mina. Ani humbwewani a taro Yapai to bwele mwanji hinga hinde hinga a saweno tini ri ani sawendiriro. ");
INSERT INTO kwj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Woro ani hambwandau, Yapai ri ani sawendiriro ti, ete da ete da himamwale tini rata ki sawendiriro. Wosiwani ele mwanji hinga tinda a bwandau ti, Yapai a sawe ki ani sawendiriro hingambwa a sawendau.” ");
INSERT INTO kwj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasofa gisi laka takai naha tasiwani Jisas ya ri hambwa, do nuwe ri andosini Yapai tambwa ri ino gisi ti sukwahiro. Wowani do nuwe ki dau himiyama hurahama rihi le keke ya ri wo. Wunu keke ri woni ri i ini ambwe naha ki ya ri ambwe. ");
INSERT INTO kwj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hunduya tiki ahirahi ti wu andawani Saiten tani Saimon che, Jutas Isukariyot, ri sembe we tiki raisini Jisas ni miho lei tapa tenge tiki ri oweno inaka tini ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Woro Jisas, Yapai ele mwaꞌambwe hinga tinda ete ri tapa tenge tiki haro ti, e, Gotri rini humbwewani ri taro, woro rini tambwa ri ai ino ti okwe tinda ri hambwasindau. ");
INSERT INTO kwj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wosini Jisas ahirahi ti andosini saini heiye pe nikaꞌari rihi ti tangosini tawol foti ri rukoni hima mandemu tiki ya ri inji. ");
INSERT INTO kwj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","O hinga ri wosini uku ti disi we tiki ri gutosini ri himache lei seke ti funda funda wunu ri yoko yoko hima mandemu ki ri injiro tawol o tiki uku ti ya wunu ri hindi hindi inda. ");
INSERT INTO kwj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wowo Saimon Pita tambwa ya ri ta. Wowani Pita ya rini sawe, “Apukolaka, seke ahi ti mi yokokondauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wowani Jisas mwanji wasa ti ya rini sawe, “Apa a wosindau sumbu mu mi hambwanda nambwe, woro ichai o mi hambwakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wowani Pita ga ya rini sawe, “Seke ahi ti apa ani yoko kei. Minambwe naha.” Wowani Jisas mwanji wasa ti ya rini sawe, “E, seke mini a yoko nambwe nawa, apa ani ga hinde mi da kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ete wowanumbwa Saimon Pita ya rini sawe, “O hinga ti nawa, Apukolaka, seke tumbwa ani yoko kei, tapa ti okwe mwa ti okwe ma ete ani yoko.” ");
INSERT INTO kwj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wowani Jisas ya rini sawe, “Uku yaro hima ri uku apa ri ai ya hinga, seke tumbwa ri yokowa ri hima tape tinda kisi nambwe. Kunu kisi nambwe ku dau, woro kunu tinda ete mina.” ");
INSERT INTO kwj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Miho lei tapa tenge tiki rini oweno hima ri ri hambwasindau. O keke ka ete ri sawe to, “Kunu tinda ete kisi nambwe, mina.” ");
INSERT INTO kwj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas seke ti wunu yokosini, ri nikaꞌari ri ai soꞌoisini ri litiro tei tokwe ri ai ini litisini ya wunu ri sawe, “Do kunu a wosiro sumbu mu ti ku hambwandauꞌu? ");
INSERT INTO kwj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","‘Ondiyakandiyandau hima,’ e, ‘Apukolaka,’ o hinga ete ku ani uchandau. Woro o hinga ku uchandau ti, kipe naha. Hinde wowani, ani o hingambwa. ");
INSERT INTO kwj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ani ondiyakandiyandau hima, e, ani apukolaka, woroto kui seke ti a yokoro. O hinga nawa, apa kunu okwe kui hiparakambwe lei seke ti ma ku anayoko anayokosi. ");
INSERT INTO kwj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ahaꞌa sumbu a wosiro ti, himamwale hinga kunu a mekusiro. O keke kunu okwe a wosiro hingambwa ma ku wosi. ");
INSERT INTO kwj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mwe naha ki kunu a sawendau: Tau ra himache ri, ri apukolaka ni dikinda nambwe. E, mwanji raꞌai hima ri, o rini humbwewani ri iro hima ni dikinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","E, dele sumbu hinga ni ku hambwasini mwe naha ku wosiwa Gotri kwambu o kunu ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ani kunu ni tinda ete a sawenda nambwe. Ani ahi a naro hima le ani hambwandau. Woro ka mwanji Gotri chengi ki dau ti, mwe naha sukwakondau: ‘Ani ga bereti andau hima fori seke rihi rasaini o ri ani tatikachikonda.’ ");
INSERT INTO kwj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Do sumbu hinga sukwa nambwe dawani apa o mwanji ni do kunu a sawenda. Woro ichai o sumbu sukwawa ya ku hambwakonda, ani kari Hima. ");
INSERT INTO kwj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mwe naha ki kunu a sawendau: E, hima fori ori a humbwewani iro tau ra hima ni ri toroni rakarundau ti, ori hima ani ni ri toroni rakarundau. E, hima fori ani ni ri toroni rakaruwa, ori ani humbwewani a taro ai Yapai ni ri toroni rakarundau.” ");
INSERT INTO kwj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas o mwanji hinga ri sawekoni sembe rihi ti nomo naha ya i. Wosini ka mwanji hinga ya ri sawe, “Mwe naha ki kunu a sawendau: Kui nindo ki dau hima fori ani omwemendindau hima lei tapa tenge tiki o ri ani hakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","O mwanji hinga ri bwawani ri sawero hima ni wu hikisafuni ri himache le wunu funda funda miya ti ya wu anamisinda. ");
INSERT INTO kwj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas ri okokonandau ri himache fori to Jisas ga takaini funda ya fi lininda. ");
INSERT INTO kwj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Wondawani Saimon Pita to sumbu fo ri hima tape ki ri uyangosini ya rini sili, “Ma rini silinehei, namoni ri sawendau.” ");
INSERT INTO kwj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wowani Jisas himache ori ri mu tokwe ri yekwehimesini ya rini sawe, “Apukolaka, namoni mi sawero?” ");
INSERT INTO kwj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Wowani Jisas ga mwanji wasa ya ri sawe, “Do a tipa disi tiki a rawaisini o rini ani hakonda. Wowa ya ma ku hambwa, ori hima sa to.” Wosini o a tipa disi ki ri rawaisini Saimon che, Jutas Isukariyot ni ya ri ha. ");
INSERT INTO kwj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jutas o ahirahi ri torowani o amwa naha kumbwa Saiten ri sembe we ki ya raru. Wosiwani Jisas ya rini sawe, “Sumbu fo mi wosi ki mi hambwandau ti ma huwainani wosi.” ");
INSERT INTO kwj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wowani tei ki litiro hima le wui nindo ki hima fori Jisas Jutas ni sawero mwanji mu mwe ti ri hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jutas ya kowe wuhi ri aulindawani wunu fwele ka hinga ya wu hambwa, Jisas ka mwanji hinga rini sawero ti, gisi laka keke ahirahi mwaꞌambwe wungwa ri ji kiꞌi, e, bwarichape hima leni mwaꞌambwe ri ha ki rini saweroꞌo. ");
INSERT INTO kwj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jutas o ahirahi tipa ri torosini metengei hoko tokwe ri raruni ri heiwani hunduro. ");
INSERT INTO kwj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Rini hoko tokwe raruni ri isiwani Jisas ya sawe, “Apa Hima ri Che dori hi omwesika laka ri torohiro. Wosiwani Gotri okwe rini kumbwa hi omwesika laka ri torohiro. ");
INSERT INTO kwj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","E, Gotri Hima ri Che ki hi omwesika laka ri tororo ti nawa, Gotri ga o ri Che ni rini ki dau hi omwesika naha ya ri hakonda, woro metengei ete hi omwesika ti o ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ai che le, gisi faiche naha kunu ga a dakondau. Ani isiwa o ku ani wakindakonda. Woro Juta hima kupu leni a sawero mwanji hingambwa apa do kunu a sawenda: Kunu apa ani ino ko ti hinde apa ku ta kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lo mwanji anandi fori kunu a sawe: Kunu kui hiparakambwe lenga ma ku anakekewonda. Ani kunu keke funda ete a wondau hingambwa kunu okwe ele hiparakambwe lenga ma ku anakekewonda. ");
INSERT INTO kwj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","E, kui hiparakambwe lenga mwe naha ku anaꞌokokonandawa, hima le ka hinga o ya kunu hambwakonda, kunu ai himache.” ");
INSERT INTO kwj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wowani Saimon Pita ya rini sawe, “Apukolaka, soki mi ikonda?” Wowani Jisas ga mwanji wasa ya sawe, “Ani ino ko ti hinde apa mi ani sirinani mi ta kumbwa. Waya ichekaimbwa mi ani sirinano.” ");
INSERT INTO kwj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wowani Pita ya rini sawe, “Apukolaka, hinde wowani apa mini a sirina hinga? Mini ani okula ki himamwale ahi ani ohumbwe sindau.” ");
INSERT INTO kwj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wowani Jisas ga mwanji wasa ya rini sawe, “Ani ni mi okula ki himamwale mihi mi ohumbwekondauꞌu? Mwe naha ki mini a sawendau: Apwetoko gi nambwe ete dawa hi ahi ti numbo namili o mi hamisakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Apa sembe kuhi ti apapanani saitale kei. Kunu Gotri ni sembe ku hani, ani okwe sembe ti ma ku ani ha. ");
INSERT INTO kwj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ai Yapai aka ki aka tipa ti miyafo naha. E, minambwe napo imbihumbwa ete kunu a sawekoro. Ani ani ikondau, kui ko ti ani otokuna ki. ");
INSERT INTO kwj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E, ani ini kui ko ani otokunasiwa ani ai tani ani ga ku da kinani a raꞌaikonda. Wosiwa a dau ko kumbwa kunu okwe ani ga funda nu da ki. ");
INSERT INTO kwj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Woro kunu ka ko tokwe ani ikondau numbo ti ku hambwandau.” ");
INSERT INTO kwj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wowani Tomas ya rini sawe, “Apukolaka, soki mi ikondau? Nunu nu hikisandau. Hinde hinga ka numbo apa nu hambwano?” ");
INSERT INTO kwj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ete wowani Jisas ya rini sawe, “Ani andombwa numbo, ani andombwa mwanji mwe naha, e, ani andombwa himamwale mu naha. Hima fori ai Yapai tambwa numbo ba foriki hinde apa ri i kumbwa. Minambwe naha. Ani naha kumbwa ri ino. ");
INSERT INTO kwj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","E, mwe naha ku ani hambwapo, apa ai Yapai okwe ku hambwakoro. Do gisi naha ki ku ambwesini, rini ku hambwani rini ku heihiro.” ");
INSERT INTO kwj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Wowani Filip ya rini sawe, “Apukolaka, Yapai ma nunu mekusi, wowa nunu o numbwa nu sirina.” ");
INSERT INTO kwj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ete wowani Jisas ya rini sawe, “Filip, gisi miyafo naha kunu ga a daro ti, mi ani hikisandauꞌu? Hima fori ani ni ri heindau ti, o Yapai ni ri heindau. Wo hinde wowani ete mi sawero, ‘Yapai ma nunu mekusi’? ");
INSERT INTO kwj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ani Yapai ga a dawani Yapai ani ga dau, o tini sembe mi handa nambweꞌe? Mwanji kunu a sawendau ti, o ai inakahambwa ki kunu a sawenda nambwe, mina, oti Yapai ani ga dasini ri tau hinga rinjenga ri randau. ");
INSERT INTO kwj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kunu do mwanji ni sembe ma ku ha: Ani Yapai ga a dawani Yapai ani ga dau. E, minambwe nawa, ele kwambu chele tau hinga a raro tini ma ku hambwani sembe ti ani ni ku ha. ");
INSERT INTO kwj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Mwe naha ki kunu a sawendau: Hima fori sembe ani ni ri hano ti, ele tau hinga a raro ti, rini okwe ri ra sindau. Wosini tau laka ri rani ani a raro tau ni ri dikino. Hinde wowani, ani Yapai tambwa ani ikondau. ");
INSERT INTO kwj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wosiwa ele sumbu hinga tinda hi ahi ki ku ani siliwa a wosi sindau. Wowa o keke Yapai ri Che ki hi omwesika ti ri torokonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ele sumbu hinga hi ahi ki ku ani siliwa, o a wosi sindau. ");
INSERT INTO kwj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“E, ani keke ku wondau ti nawa, ele lo mwanji ahi mwe naha ku sirinakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ani Yapai ni a silikonda, wowa kunu okulano hima ri o kunu ri hakonda. Wosiwa ori hima kunu ga ete da ete dakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dori hima mwanji mwe naha bwandau Himamwale Kipe. Nuwe ki dau himiyama hurahama le hinde apa rini wu rakaru kumbwa. Hinde wowani, wunu rini wu heini rini wu hambwanda nambwe. Woro kundo rini ku hambwandau. Hinde wowani, apa kunu ga ri dau to kui sembe we ki o kwai ri dakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ani apa kunu ani hanjaꞌaisiwa chenguto hinga hinde ku da kumbwa, minambwe naha. Kunu tambwa a takondau. ");
INSERT INTO kwj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kamindache naha, do nuwe ki dau himiyama hurahama le hinde apa wu ai ani hei kumbwa. Woro kundo ku ani hei sindau. Hinde wowani, ani himamwale ga a dau, kunu okwe himamwale ga ku dakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Woro o gisi kumbwa ani ai Yapai ga a dawani, kunu ani ga ku dawani, ani kunu ga a daro sumbu ti, o ya ku hambwakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","E, hima fori lo mwanji ahi ti ri torosini kipe naha ri sirinano ti, ori hima ani keke funda ete ri wondau. E, hima fori ani keke ri wondau ti, ai Yapai okwe o rini keke wonda. Wowa ani okwe rini keke a woni anjenga rini a mekukonda.” ");
INSERT INTO kwj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas o mwanji hinga ri bwawani hima fori, Jutas, rini Jutas Isukariyot mina, woro rindo Jisas ni ka hinga ya ri sawe, “Apukolaka, minjenga nunu ni mi mekukondau, wo hinde wowani do nuwe ki dau himiyama hurahama leni minjenga wunu mi meku hinga?” ");
INSERT INTO kwj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Wowani Jisas ga mwanji wasa ya rini sawe, “E, hima fori ani keke wowa, rindo ai mwanji ti ri sirinakonda. Wowa ai Yapai ori hima keke ri wokonda. Wosini rini tambwa si tani rini ki si aka si kisini rini ga si dano. ");
INSERT INTO kwj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","E, hima fori ani keke ri wonda nambwe ti, rini ai mwanji ni ri sirinanda nambwe. Woro dele mwanji ku mendindau ti, o ai mwanji mina. O ri ani humbwewani a taro Yapai ri mwanji. ");
INSERT INTO kwj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ani kunu ga ete a dasini dele mwanji hinga ni o kunu a sawenda. ");
INSERT INTO kwj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Woro kunu okulano hima ri, Gotri Himamwale Kipe, woro ori hima ni hi ahi ki Yapai rini humbwewa ori takonda. Wowa rindo ele mwanji hinga tinda kunu ri ondiyakandiyani ele inaka kuhi ri yeni ri rasaiwa ele kunu a sawero mwanji tinda ete ya ku ai hambwandakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Sembe wahapi sumbu o kunu ani andosinda. Sembe wahapi sumbu ahi ti o ya kunu ani handa. Ani sembe wahapi sumbu kunu ani handau ti, do nuwe kunu handau hinga mina. Sembe kuhi ti apapanani apa ku aki kei. ");
INSERT INTO kwj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ka mwanji kunu a sawero ti ku mendihiro: ‘Ani, ani ikondau. Wosini kunu tambwa ani ai tano.’ E, imbihumbwa ani keke ku wopo, apa Yapai tambwa ani ikondau ti ku eripeꞌaripeu. Hinde wowani, Yapai ani ni dikisindau. ");
INSERT INTO kwj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Do sumbu hinga sukwa nambwe dawani o sumbu ni apa do kunu a sawesinda. Woro o sumbu sukwawa, sembe o ku hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Huwe laka apa kunu ga hinde a bwa kumbwa. Hinde wowani, do nuwe aulindau mekupu hima laka ya tanda. Woro, ri kwambu ti hinde ri ani diki kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Woro ai okokona ti, do nuwe ki dau himiyama hurahama le sa wu hambwa, ani Yapai keke a wondani Yapai ani sawendiriro sumbu hinga numbwa a wosindau. Woro ma ku saiwa ya nu i. ");
INSERT INTO kwj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ani waini me ba minde naha. Wowani ai Yapai rini yapai chele rupwa. ");
INSERT INTO kwj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E, me tali ahi fwele mwe wa nambwe nawa, Yapai to seni humbwendau. E, mwe wandau me tali le, o mwe miyafo ai wa kinani Yapai to faiche ri kutoni ri wonorukwendau. ");
INSERT INTO kwj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Do kunu a sawero mwanji keke, kunu wonorukwesiwani kipe naha ku sirahiro. ");
INSERT INTO kwj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kunu ani ki ma ku dawa, ani ga kunu ki a da. E, me tali foti waini ba ki ambomuna nambwe tinjenga barikapwa ti dawa mwe ti hinde wa kumbwa. Woro o hingambwa, kunu ani ki ku da nambwe nawa, apa ahirahi mwe hinga hinde kunu wa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ani waini me ba. Wowani kunu talitapa. Hima fori ani ki dawani ani ga rini ki a dau ti, ori hima mwe miyafo wakondau. E, ku ani hanjaꞌaiwa, sumbuche fo hinde apa ku wosi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","E, hima fori ani ki da nambwe nawa, me tali seni humbweꞌisiwani rikaꞌaindau hinga rini humbweꞌino. Wosini ele me tali raꞌaini fotukumbwa wausini hi tiki rawaiwa ukondau. ");
INSERT INTO kwj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“E, kunu ani ki ku dau, e, ai mwanji ti kunu ki dau ti nawa, apa ele sumbu hinga ku toro ki ku okokonandau ti, ele keke Gotri ni ma ku uchahambwa. Wowa o kunu ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","E, mwe miyafo naha kunu ki wawa, ai Yapai hi omwesika ri toro sindau. O keke kunu ai himache hinga ku dano. ");
INSERT INTO kwj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ai Yapai ani keke wondau hingambwa ani o hingambwa kunu keke a wondau. Hima keke wondau sumbu ahi ki ma ku da. ");
INSERT INTO kwj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","E, ai lo mwanji ni ku sirinawa, ai hima keke wo sumbu we ki kwai ku da sindau, ka ai Yapai ri lo mwanji a sirinani ri hima keke wo sumbu we ki kwai a dau hinga. ");
INSERT INTO kwj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Do mwanji kunu ni a sawero ti, ai eripeꞌaripe sumbu ti kui sembe we ki dawa kui eripeꞌaripe sumbu ti kunu tale ki. ");
INSERT INTO kwj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lo mwanji ahi ti ka hinga: Ani kunu keke a wondau hingambwa kunu ele kui hiparakambwe lenga ma ku anakekewonda. ");
INSERT INTO kwj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","E, hima fori ri himamwale ti ele ri nau keke ri ohumbweno ti, ori hima i hima keke wo sumbu ni dikindau hima keke wo sumbu fo da nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E, mwe naha ki kunu a sawendau, ai lo mwanji tini ku sirinawa, kunu ai nau. ");
INSERT INTO kwj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ani apa kunu ni ai tau ra himache hinga ani ucha hinga, mina, hinde wowani, tau ra himache ri ri apukolaka ri randau tau ti ri hikisandau. Woro ele mwanji hinga ai Yapai takisopo ki a mendiro ti tinda do kunu a sawero. O keke ai nau hinga kunu ani uchandau. ");
INSERT INTO kwj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Kundo ani ni kuhi ku ani na nambwe, mina. Ando ahi kunu a nasindau. O sumbu hinga a wosiro ti, ku iwa ahirahi mwe kunu ki wawa o mwe ete dawa hi ahi ki Yapai mwaꞌambwe fo kunu ha ki rini ni ku uchahambwawa kunu ri handa ki. ");
INSERT INTO kwj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lo mwanji ahi kunu ani haro ti ka hinga: Kunu ele kui hiparakambwe lenga ma ku anakekewonda. ");
INSERT INTO kwj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“E, do nuwe ki dau himiyama hurahama le kunu omwemendiwa ya ma ku hambwa, metengei naha ani ni wu omwemendiro. ");
INSERT INTO kwj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","E, kunu do nuwe kipe napo, do nuwe ki dau hima le wui hima kupu hinga o kunu wu okokonakonda. Woro kunu do nuwe kipe hima mina, do nuwe ki ku daro ti ahi kunu a nasiwani o ku da. O hinga keke do nuwe ki dau himiyama hurahama le o kunu omwemendinda. ");
INSERT INTO kwj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kunu do kunu a sawero mwanji ti ma ku ai hambwa: Tau ra himache ri ri apukolaka ni dikinda nambwe. Wunu ani ni walambe sumbu wu wosiro ti nawa o hingambwa apa o kunu wu wosikonda. E, ai mwanji wu sirinaro ti nawa, kui mwanji okwe o wu sirinakonda. ");
INSERT INTO kwj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ai hi keke, wunu ele sumbu hinga kunu wu wosikondau. Hinde wowani, wunu ka ani humbwewani a taro hima ri wu hikisandau. ");
INSERT INTO kwj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“E, a tani mwanji wunu a sawe nambwe napo, wunu kapwa sumbu nambwe wu dakoro. Woro apa kapwa sumbu wuhi wu yanino ti, numbo nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","E, hima fori ani ni ri omwemendindau ti, o ai Yapai okwe ri omwemendindau. ");
INSERT INTO kwj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","E, hima fori a raro tau hinga randa nambwe. Woro o tau a ra nambwe napo, apa wunu kapwa sumbu nambwe wu dakoro. Woro wunu kale kwambu chele sumbu a wosiro ti wu heisini ani ga ai Yapai ga sini ni ete wu omwemendindau. ");
INSERT INTO kwj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Woro o wui sumbu, wui lo mwanji foki kairo ka mwanji hinga mwe naha sukwahiro: ‘Wunu nindumwasari wu ani omwemendindaro.’ ");
INSERT INTO kwj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Woro ai Yapai ga dau kunu okulano hima ri a humbwewa kunu tambwa o takonda. Kunu okulano hima mwe ri, mwanji mwe naha ki bwandau Himamwale, Yapai andosini o takonda. Ri tawa ani ni amwei ri saweno. ");
INSERT INTO kwj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wondawa kunu okwe ani ni amwei ma ku sawekawe. Hinde wowani, metengei naha tau a rasairo gisi ku ambwesini ani ga ete ku daro. ");
INSERT INTO kwj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Sembe ha sumbu kuhi ku hanjaꞌaino keke, dele mwanji hinga kunu a sawero. ");
INSERT INTO kwj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wunu lotu wo aka wuhi ki kunu wu toroni rawarakonda. Mwe naha, gisi fo takonda, o gisi hinga ki hima fori kunu ri yeni sisini ka hinga ri hambwakonda, rini o sumbu ni anguꞌomwe hinga Gotri ni ri haro. ");
INSERT INTO kwj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wunu Yapai ni wu hambwanda nambwe, e, ani ni wu hambwanda nambwe o sumbu hinga wu wosino. ");
INSERT INTO kwj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Woro do sumbu hinga kunu a sawero ti, ichai hima le o sumbu hinga kunu wosino gisi tawa, do kunu ani autangindau mwanji tini ku ai hambwa ki. “Ani kunu ga a daro keke dele mwanji metengei naha kunu a sawe nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Woro apa ka ani humbwewani a taro hima ri tambwa ya ani ikondau. E, kunu ga a dawani kui nindo tiki hima fori ka hinga ani sili nambwe, ‘Sete mi ikondau?’ Mina. ");
INSERT INTO kwj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Do mwanji kunu a sawewani sembe kuhi ti apa nomo naha. ");
INSERT INTO kwj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Woro mwe naha ki kunu a sawendau: Kunu ani andosini ani ino sumbu ti kunu keke kipe naha. Hinde wowani, ani i nambwe nawa, kunu okulano hima ri kunu tambwa hinde ta kumbwa. E, ani ini rini ni kunu tambwa a humbwewa o ri takonda. ");
INSERT INTO kwj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ri tani apa nuwe pe hima leni ri kiliwa kapwa sumbu mu naha ti, sumbu kipe mu naha ti, e, Gotri kilino sumbu mu naha ti tinda ete wu hambwano. ");
INSERT INTO kwj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kapwa sumbu mu naha ni wu hambwano sumbu mu mwe ti ka hinga: Wunu sembe ani ni wu ha nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Sumbu kipe mu naha ni wu hambwano sumbu mu mwe ti ka hinga: Ani Yapai tambwa ani ikondau, wosiwa hinde apa ku ani ai hei kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gotri kilino sumbu mu naha ni wu hambwano sumbu mu mwe ti ka hinga: Do nuwe ni aulindau mekupu hima laka ori Gotri rini kiliro. ");
INSERT INTO kwj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kunu ani hakondau mwanji ti miyafo naha ya dau, woro o nomo apa hinde ku kicha kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Woro ichai ka mwanji mwe naha bwandau Himamwale tito ri tawa ele mwanji mwe naha kumbwa kunu ri raꞌaino. Apa ri inakahambwa mwanji hinde ri bwa kumbwa. Mina. Ri mendino mwanji tumbwa ri bwandani ichai sukwano sumbu okwe kunu saweno. ");
INSERT INTO kwj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Rini ai mwanji ti ri torosini ini kunu ni o bwakonda, o hinga keke hi omwesika ani ni ri hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yapai mwaꞌambwe hinga tinda ete ahi. O hinga keke ete a sawero: Ai mwanji ti ri torosini raꞌaini kunu ni ri bwano. ");
INSERT INTO kwj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kamindache naha hinde apa ku ani ai hei kumbwa. Woro kamindache naha ku ani ai heikondau.” ");
INSERT INTO kwj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wowani ri himache le wunjenga ka hinga ya wu anambwa anambwa: “Do nunu sawero mwanji mu mwe ti hinde na hinga, ka ete ri sawero ti, ‘Kamindache naha hinde apa ku ani ai hei kumbwa,’ e, ‘Woro kamindache naha ku ani ai heikonda,’ wosini fo ka hinga ri sawero, ‘Hinde wowani, Yapai tambwa ani ikondau’?” ");
INSERT INTO kwj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wondani ya wu sawe, “Ka mwanji, ‘Kamindache’ ri sawero ti, hinde na hinga? Do ri sawero mwanji mu mwe ti nunu nu hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas mwanji rini wu sili ki wu okokonandau sumbu tini ri hambwasini ya wunu ri sawe, “Kunu do kunu a sawero mwanji mu mwe tini ku hambwa ki ku anasili anasilindauꞌu, ka ete a sawero ti: ‘Kamindache naha hinde apa ku ani ai hei kumbwa,’ e, ‘Woro kamindache naha ku ani ai heikonda’? ");
INSERT INTO kwj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mwe naha ki kunu a sawendau: Kunu au laka ku ichakandani moko ku andano. Wondawa nuwe pe himiyama hurahama le ya wu eripeꞌaripendakonda. Sembe kuhi ti nomo naha ino, woro o sembe nomo kuhi ai jamekowa apa eripeꞌaripe to kunu ki sukwano. ");
INSERT INTO kwj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Humwe fo che rano amwa takai tawani amwaka ti ya ti mendiu. Wosini che oti ti rasini amwaka o tini ai ti hambwanda nambwe, mina, o do nuwe ki ti raro che ori keke ya ti eripeꞌaripeu. ");
INSERT INTO kwj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kunu okwe o hingambwa. Apa sembe nomo o ku akonda. Woro dani ini kunu ani ai heiwa ku eripeꞌaripekondau. Wosiwa hima forito apa ka kui eripeꞌaripe hinde rani humbweꞌi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Woro o gisi ki mwaꞌambwe fo keke apa hinde ku ani sili kumbwa. Mwe naha ki kunu a sawendau: E, ai hi tiki Yapai ni mwaꞌambwe fo keke ku uchahambwawa apa o kunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Imbihumbwa ete ta tani apa okwe ai hi tiki mwaꞌambwe fo keke Gotri ni ku uchahambwa nambwe. Woro apa ma ku uchahambwanehei, wowa o kunu hakonda. Wosiwa sembe kuhi ki eripeꞌaripe to o talekonda. ");
INSERT INTO kwj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Dele mwanji hinga mwanji yepe tiki kunu a sawero. Woro gisi fo tawa, o gisi ki mwanji yepe tiki hinde apa kunu a sawe kumbwa, mina, Yapai ni amwei kunu a saweno. ");
INSERT INTO kwj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Woro o gisi ki ai hi tiki ku uchahambwano. Do a sawendau ti, kunu keke Gotri ni anjenga ani uchahambwakondau sumbu tini kunu a sawenda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mina. Yapai rinjenga kunu keke ri wondau. Hinde wowani, ani keke ku woni sembe ti ku hasinda, ani Gotri ga a dasini a taro. ");
INSERT INTO kwj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Imbihumbwa Yapai ga a daro, wosini rini ani andosini nuwe tokwe a sikaro. Apa nuwe ti ani andosini Yapai tambwa ani ai raukonda.” ");
INSERT INTO kwj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ete wowani ri himache le ya sawe, “E, apambwa amwei mi bwandau, mwanji yepe ki mi bwanda nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Apa nu hambwandau, hima mini sili kinani mi nikisinda nambwe. Mina. Ele mwaꞌambwe hinga tinda mi hambwandau. O keke sembe ti mini nu hani ete nu hambwa, mini Gotri ga mi dasini mi taro.” ");
INSERT INTO kwj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wowani Jisas mwanji wasa ti ya wunu sawe, “Apa sembe ku hahiroꞌo? ");
INSERT INTO kwj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gisi fo o takonda, woro apa tahiro. Kunu funda funda ku berimbuchini ko hinawana tokwe o ku ikonda. Wokoni ani numbwa ku andosiwa a dano. Woro ani andombwa, mina, Yapai ani ga dau. ");
INSERT INTO kwj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ai okokona ti, ani ga sembe wahapi ki ku da ki. O keke do mwanji kunu a sawero. Nuwe tiki kunu nomo chele. Woro kwambu ki ma ku eti. Ani do nuwe pe sumbu hinga tinda ete a dikiro.” ");
INSERT INTO kwj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas o hinga ri sawesini hewen tokwe ri mauni ya sawe, “Yapai o amwa sukwahiro. Mi Che ni hi laka ma ha, wowa mi Che ringa hi laka sa mini ha. ");
INSERT INTO kwj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hinde wowani, ele hima ni aulino kwambu ti rini mi hahiro, wosiwa rini mi haro ele himiyama hurahama hinga tinda ete da ete da himamwale wunu ri ha ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ete da ete da himamwale ti ka hinga: Wunu mini hambwandau, mini mindombwa Gotri mwe naha, wosini Jisas Kurais ni wu hambwandau, mindo mi humbwewani ri taro. ");
INSERT INTO kwj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Hi hinga okundau sumbu mihi ti do nuwe pe himiyama hurahama leni a mekuro. A ra kinani mi ani hasiro tau ti tinda a humburo. ");
INSERT INTO kwj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yapai, injelembwa nuwe sukwa nambwe gisi ki ani mini ga a dani, ani hi chele hima. Woro apa miyaningisopo mihi ki o hi laka ma ai ani ha to. ");
INSERT INTO kwj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Do nuwe ki mi ani haro hima hinga mi hi tini a sawewani tinda wu mendisinda. Wunu mihi, ani ni mi haro. Wosiwani mi mwanji ti kipe naha wu sirinandau. ");
INSERT INTO kwj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Apa ya wu hambwasindau, ele sumbu mi ani haro hinga tinda mini kumbwa taro. ");
INSERT INTO kwj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hinde wowani, ele mi ani haro mwanji hinga tinda ete wunu ani haro. Wowani ele ni wu tororo. Wunu mwe naha wu hambwasindau, mini ga a dasini a taro ti. Wosini sembe wu hasindau, mindo mi ani humbwewani a taro. ");
INSERT INTO kwj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Woro wunu keke mini ni ani uchahambwandau. Ani dele nuwe pe hima le keke mini ani uchahambwanda nambwe. Ani ele mi ani haro hima le keke mini ani uchahambwanda. Hinde wowani, wunu mihi. ");
INSERT INTO kwj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ele mwaꞌambwe ahi hinga tinda ete mihi. Wowani ele mwaꞌambwe mihi hinga tinda ete ahi. O keke ani wunu ki hi omwesika a tororo. ");
INSERT INTO kwj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Apa do nuwe ki hinde a da kumbwa. Wunu do nuwe ki wu dau. Ani mini tambwa a tandau. Halayasini dau Yapai, mi ani haro hi ki dau kwambu ki ma wunu haweini aulindawa funda naha si dau hinga wunu o hingambwa funda naha sa wu da. ");
INSERT INTO kwj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wunu ga a daro gisi ki ka mi ani haro hi ki kipe naha wunu ani aulini a dawani wunu kipe tumbwa wu daro. Wunu fori walambe rini i nambwe, woro walambe i ki ondiyasiro hima ri funda naha tombwa. Woro o sumbu hinga sukwaro ti, mi mwanji mwe naha sukwa kinani. ");
INSERT INTO kwj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Apa mini tambwa a tandau. Woro do nuwe ki ete a dani dele mwanji hinga mini a sawendau. Wowa wunu eripeꞌaripe sumbu ahi ni wu torowa wui sembe ki ete taleni wunu chikisi ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Mi mwanji ti wunu ani haro. Wosiwani do nuwe pe himiyama hurahama le wunu ni miho tangindau. Hinde wowani, wunu do nuwe pe mina, woro hingambwa ani okwe do nuwe pe mina. ");
INSERT INTO kwj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Do nuwe ki wunu mi raꞌai ki mini ani uchahambwa nambwe, mina, haweini wunu mi auli kinani mini ani uchahambwanda, wosiwa kari kapwa hima hinde apa walambe wunu wosi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wunu dohaꞌa nuwe pe mina, woro hingambwa ani okwe dohaꞌa nuwe pe mina. ");
INSERT INTO kwj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mwanji mwe naha ki ma wunu yarisiwa mihi minde naha sa wu da. Mwanji mihi ti mwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imbihumbwa mi ani humbwewani a sikani do nuwe pe himiyama hurahama lei nindo tiki a daro. Woro hingambwa wunu okwe a humbwewani wu ini do nuwe pe himiyama hurahama lei nindo tiki ete wu da. ");
INSERT INTO kwj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wunu ani okula kinani anjenga a yarisini mihi minde naha a siraro, wosiwa wunu okwe wunu yarisiwa mihi minde naha wu sira ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Woro do wunu numbwa okula ki ani uchahambwanda nambwe, mina, oti hima le wui mwanji ti mendini sembe ani ni hano hima le okwe wunu okula ki ani uchahambwandau. ");
INSERT INTO kwj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O hinga a wosindau ti, Yapai, mini ani ki mi dawani ani mini ki a dau hingambwa wunu tinda ete funda naha wu sirasini sini ki wu da ki, wosiwa nuwe pe himiyama hurahama le do mi ani humbwewani a taro tini sembe wu ha ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi ani haro hi hinga okundau mwaꞌambwe ti wunu ni ani haro, wosiwa sini funda naha si dau hinga wunu o hingambwa funda naha wu da ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ani wunu ki a dawani mini ani ki mi dau. Woro hingambwa sembe funda naha wu sira ki ani okokonandau. Wosiwa nuwe pe himiyama hurahama le wu hambwa ki, mindo mi ani humbwewani a sikaro, e, ani keke mi wondau hingambwa wunu keke mi wondau. ");
INSERT INTO kwj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Yapai, ai okokona ti, dele himiyama hurahama mi ani haro le, a dau ko tukumbwa ani ga funda ete nu da ki, wosini imbihumbwa nuwe ti wosi nambwe dawani, ka gisi ki mi ani okokonandau keke mi ani haro hi laka ahi ti wu hei ki. ");
INSERT INTO kwj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yapai kipe naha, nuwe pe himiyama hurahama le mini wu hambwanda nambwe. Woro ani mini ni ani hambwandau. Dele ai himache le wu hambwandau, mindo mi ani humbwewani a taro. ");
INSERT INTO kwj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi hi ti amwei wunu a mekuro, woro waya gamwe tinga amwei ai wunu a mekukonda. Wosiwa mi ani okokonandau sumbu hingambwa wunu ki dawa anjenga wunu ki a da ki.” ");
INSERT INTO kwj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas o mwanji hinga ri uchahambwasini ri himache lenga wu ini Kitiron fwatorowa ti yetikinani ya wu rachi. Olif rupwa foti o michi ki dau. Wowani Jisas ga ri himache lenga o rupwa we ki ya wu raru. ");
INSERT INTO kwj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jutas, miho lei tapa tenge tiki rini oweno hima, rini okwe o rupwa ri hambwandau. Hinde wowani, nilitapwa ambwe Jisas ri himache lenga o rupwa ki ete wu waundaro. ");
INSERT INTO kwj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","O hinga keke Jutas au anaye hima kita foringa, puris hima laka lenga Farisi hima lenga wu humbwero apungwandai kicha hima fwelenga, numbo wunu ri ondiya ondiya o rupwa ki ya wu ta. Wunu lamu le, chika le, e, au anaye mwaꞌambwe le toroni ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas, rini ni wu wosiro sumbu hinga tinda ri hambwasini wunu tambwa takai ri ini ya wunu sawe, “Namoni ku wakindau?” ");
INSERT INTO kwj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wowani mwanji wasa ti ya rini wu sawe, “Nunu Nasaret pe Jisas ni nu wakindau.” Wowani Jisas ya wunu sawe, “Ori ando sa to.” Wondawani Jutas, ele hima i tapa tenge tiki rini owero hima ri, wunu ga ya eninda. ");
INSERT INTO kwj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas ete wunu sawewani, “Ori ando sa to,” wowani kamindache wu ai sukuni wu ikoni nuwe tiki ya ete wu rai. ");
INSERT INTO kwj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","O hinga wu wowani ya ri ai wunu sili, “Namoni ku wakindau?” Wowani ya wu sawe, “Nasaret pe Jisas.” ");
INSERT INTO kwj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ete wowani Jisas ka hinga ya wunu sawe, “Tambwa kunu a sawero, ori ando sa to. E, ani ni ku wakiwa, dele hima ma ku andowa sa i.” ");
INSERT INTO kwj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O sumbu hinga sukwaro ti, imbihumbwa ri bwaro mwanji ti mwe naha sira ki sukwaro. Ri bwaro mwanji mwe ti ka hinga: “Apa dele ri ani haro himiyama hurahama fori ani hanjaꞌaiwa walambe rini i hinga.” ");
INSERT INTO kwj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita gipi huwe laka foti daro. O gipi ri longoni puris hima lei apukolaka ri tau ra himache forini tapa mama tokwe pe wasamba ti ya ete ri tafehe. Tau ra himache mwe ri, hi rihi ti Malikas. ");
INSERT INTO kwj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wosiwani Jisas Pita ni ya sawe, “Gipi ti, ti kowe tiki ma ai waro. Do Yapai ani haro amwaka chele kapu ti, apa ani a hingaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wosiwani au anaye hima kita fotinga wui apukolaka ga, e, apungwandai kicha Juta hima kupu lenga Jisas ni wu toroni kupu tiki ya rini wu inji. ");
INSERT INTO kwj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wosini metengei Anas tambwa ya rini wu raꞌai. Rini Kaiyafas nitaku, Kaiyafas o asama ki puris hima lei apukolaka ri daro. ");
INSERT INTO kwj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafas kale Juta hima kupu leni ka ete sawero hima: “Kipe naha nawa, ele himiyama hurahama ni okula ki hima funda naha ri sa ha.” ");
INSERT INTO kwj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ga himache foringa, Jisas ni sirinani ya fi i. Puris lei apukolaka, ori himache ri hambwandau. O keke puris lei apukolaka i aka we tokwe Jisas ga ya fi raru. ");
INSERT INTO kwj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wosiwani Pita rarususirasi takai tiki hoko tokwe ya ri eninda. Wondawani ka puris lei apukolaka ri hambwandau himache rito ri ai tani lengenumbo aulini dau humwe o tini ri sawesini Pita ni ya ri rakaru. ");
INSERT INTO kwj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lengenumbo aulini dau humwe oti Pita ni ya sawe, “Hinde, mini okwe kari hima i himache hinga mi da nambwe?” Wowani Pita ya sawe, “Ani mina.” ");
INSERT INTO kwj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ka nili tikiningo. Wondawani tau ra himache lenga apungwandai kicha himako ga hi foti wu haweini wu enindani ya wu waruꞌunda. Wondawani Pita okwe wunu ga enindani hi ti ya ri waruꞌunda. ");
INSERT INTO kwj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Puris apukolaka ori Jisas ni ri himache lenga ele hima ni ri ondiyakandiyaro mwanji lenga ya rini sili. ");
INSERT INTO kwj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Wowani Jisas mwanji wasa ti ya rini sawe, “Ani himiyama hurahama leni mwanji ti apweli ki wunu a sawendaro. Ani gisi gisi Juta hima kupu le waundau lotu wo aka wuhi tiki, e, Gotri aka laka ki wunu ani ondiyakandiyandaro. Ani mwanji foti a yanini a bwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hinde wowani mi ani siliro? A bwawani mendiro hima leni ma wunu sili. Wundo a sawero mwanji ti wu hambwandau.” ");
INSERT INTO kwj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","O mwanji hinga ri bwawani apungwandai kicha hima fori rini ni takaini enindaro ti, Jisas ni yetapesini ya ri sawe, “O mwanji wasa hinga puris hima lei apukolaka ni mi sawendauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wowani Jisas ga mwanji wasa ya rini sawe, “E, kapwa mwanji fo a sawero ti nawa, o tini amwei ma sawe. E, mwanji kipe ni a bwaro ti nawa, hinde wowani mi ani yero?” ");
INSERT INTO kwj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wosiwani Jisas rini injisiro hinga ete dawani Anas, puris hima lei apukolaka, Kaiyafas, tambwa ya rini humbwe. ");
INSERT INTO kwj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita hi takai ki ri enindani ri waruꞌundawani rini wu heini ya rini wu sawe, “Mini okwe ri himache hinga mi da nambweꞌe?” Ete wowani ya ri sawe, “Ani mina.” ");
INSERT INTO kwj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wowani puris hima lei apukolaka ri tau ra himache fori, woro rini Pita to wasamba ki tafehero ka hima i hima kupu fo, rindo Pita ni ya ri sawe, “Mwe naha, mini ani heiwani rini ga olif rupwa ki funda ki daro.” ");
INSERT INTO kwj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ete wowani Pita ya ri ai sawe, “Mina.” Wokowani o amwa naha kumbwa apwetoko ti ya ete gi. ");
INSERT INTO kwj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ete wosiwani Kaiyafas wu hanjaꞌaisini Jisas wu rani gapiman apukolaka aka tokwe ya rini wu raꞌai. Ka amwa nurumbumbwa. Woro wu ini, wunu gapiman apukolaka i aka we ki wu raru nambwe. Hinde wowani, wunu ete wu hambwaro, “Foki apa sembe we nuhi kisi nunu wowa Pasofa ahirahi ti hinde apa nu a kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","O keke wunu hoko ki wu dawani Pailat wunu tambwa sirani ya wunu sawe, “Kunu do hima ni bwele sumbu keke rini ku kotimwo ki?” ");
INSERT INTO kwj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ete wowani wunu ga mwanji wasa ya rini wu sawe, “E, dori hima kapwa sumbu wonda nambwe hima napo apa mini tambwa hinde rini nu ratakoro ambwa.” ");
INSERT INTO kwj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Wowani Pailat ya wunu sawe, “Ma rini ku raꞌaini kui lo mwanji ki kunjenga rini ku kili.” Wowani Juta hima kupu le ya rini sawe, “Hima foni nu yeni nu sino kwambu ti nunu ha nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","O hinga wu sawero ti, imbihumbwa Jisas ri hano numbo ni rinjenga ri sawero mwanji to mwe naha sukwa kinani. ");
INSERT INTO kwj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wowani Pailat gapiman aka ki ri ai raru. Wosini Jisas ni ri uchawani ri tawani ya rini sili, “Mini Juta hima kupu lei king apukolakaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Wowani Jisas mwanji wasa ya ri sawe, “Ka minjenga mi inaka ki mi hambwasini mi ani silindauꞌu, hima forito mini sawesiwani mi ani silindau?” ");
INSERT INTO kwj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ete wowani Pailat ga mwanji wasa ya ri sawe, “Hinde, ani Juta hima kupu foꞌo? Mi hima kupu lenga puris hima laka lenga ani tambwa mini wu rataro. Bwele sumbu ni mi wosiro?” ");
INSERT INTO kwj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Wowani Jisas ga mwanji wasa ya ri sawe, “Aulindau kwambu ahi ti, do nuwe kipe mina. Wopo, apa ai tau ra himache le wu anayendapo hima fori Juta hima kupu le tapa tenge ki ri ani hakoro ambwa. Woro, aulindau kwambu ahi ti dohaꞌa nuwe kipe mina.” ");
INSERT INTO kwj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wowani Pailat ya rini sawe, “Wo, mini king apukolaka foꞌo?” Ete wowani Jisas mwanji wasa ya rini sawe, “O mi sawenda to, ani king apukolaka. Ai nuwai do nuwe ki ani rasiwani a dau ti, o do mwanji numbwa a bwa ki a taro: Ani tau ahi ti mwanji mwe naha numbwa a bwandau. Ele hima hinga tinda ete mwanji mwe naha numbwa wu sirinandau ti, wunu ai mwanji ti wu mendindau.” ");
INSERT INTO kwj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Wowani Pailat ya rini sawe, “Mwanji mwe naha bwelefo mwaꞌambwe?” O mwanji hinga ri sawesini ri saini Juta hima kupu le tambwa ya ri ai raru. Ri raruni ya wunu ri sawe, “Ani rini a kotimwono sumbu foti a wakini ani hei numbwa. ");
INSERT INTO kwj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Woro kui sumbu foti ka hinga: Pasofa gisi laka ki kalapus tiki dau hima forini kunu ani hanjaꞌaiwa ri indau. Kui okokona ti, Juta hima kupu lei king apukolaka ni kunu ani hanjaꞌaiwa ri inoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wowani ka hinga ya wu ai ucha, “Rini mina! Barapas ma hanjaꞌaisi!” Barapas rini hima ni yendani hima i mwaꞌambwe tini hili yani ri raꞌaindaro. ");
INSERT INTO kwj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wowani heifuni Pailat sawewani Jisas ni ya tanambwa. ");
INSERT INTO kwj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wosiwani au anaye hima le kupu lame ki mwalinjangwei hinga wu balisini mwa rihi ki kau ya wu letisi. Wosini nikaꞌari narongwehe foti ya rini wu injisi. ");
INSERT INTO kwj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wosini wu ini ri mu ki wu etisini ya wu sawe, “Juta hima kupu lei king apukolaka, seꞌe!” Wosini ya rini wu yetape. ");
INSERT INTO kwj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Wosiwani Pailat hoko tokwe ri ai ri raruni ya wunu sawe, “Ma ku hei, hoko tokwe kunu tambwa rini a rasiranda. Woro ma ku hambwa, ani rini a kotimwono kapwa sumbu fo rini ki ani hei numbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wowani Jisas hoko tokwe ya ri sira. O lame chele kupu ki wu balisiro mwalinjangwei ti mwa rihi ki ete dawani nikaꞌari narongwehe oti okwe rini wu injisiro hinga ya ete da. Wosiwani Pailat ya wunu sawe, “Ma hei, ori hima dohaꞌa!” ");
INSERT INTO kwj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wowani puris hima laka lenga apungwandai kicha hima lenga rini ni wu heikoni ka hinga ya wu ucha, “Me yapweke tiki ma rini ye! Me yapweke tiki ma rini ye!” Wowani Pailat ya wunu sawe, “Kunjenga ma rini raꞌaini me yapweke tiki ma rini ku ye. Ani rini a kotimwono kapwa sumbu fo a wakini ani hei nambwe.” ");
INSERT INTO kwj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ete wowani Juta hima kupu lenga mwanji wasa ya rini wu sawe, “Nunu nui lo mwanji foti ka hinga sawero, dori hima sa ete ri ha. Hinde wowani, ka hinga ri sawero keke, ‘Ani Gotri Che.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ete wowani Pailat o mwanji ri mendini funda ete ya ri aki. ");
INSERT INTO kwj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wosini gapiman aka we ki ri ai ri raruni Jisas ni ya ri sawe, “Mini so ko kipe hima?” Wowani Jisas mwanji wasa rini sawe nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wowani Pailat ya rini sawe, “Hinde wowani mwanji wasa ahi mi ani sawe nambwe? Ani mini ani hanjaꞌaiwa mi ino ti, e, me yapweke tiki mini a yeno ti okwe, ani kwambu chele. Ka tini mi hambwanda nambweꞌe?” ");
INSERT INTO kwj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Wowani Jisas ga mwanji wasa ya ri sawe, “E, kari kau ki dau Gotri kwambu mini ha nambwe nawa, apa mi ani rakaino kwambu ti mini ki hinde da kumbwa. O keke mi tapa tenge tiki ri ani haro hima ri, ri kapwa sumbu ti omwesika naha, kapwa sumbu mihi ni ri dikisindau.” ");
INSERT INTO kwj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wowani Pailat o mwanji hinga ni ri mendifuni rini hanjaꞌaiwa ri ino numbo ni ya ri waki. Wokowani Juta hima kupu le ka hinga ya wu ucha, “E, ori hima mi hanjaꞌaiwa iwa, mini Sisa king apukolaka i nau mina! Hima fori rinjenga king apukolaka hinga ri nano ti, rini Sisa ni ri omwemendindau!” ");
INSERT INTO kwj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ete wowani Pailat o mwanji hinga ri mendifuni Jisas ri ra ra hoko tokwe ya rini rakaru. Wosini rini Wataro Humokuto wu uchandau michi ki koti mendindau tei tenge ki ya ri liti. Woro Hipuru mwanji ki o michi ni ka hinga wu uchandau, Gapata. ");
INSERT INTO kwj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","O gisi Pasofa gisi laka keke mwaꞌambwe ti otokunandau gisi. Wondawani nika sukwani gondi hinga ya i. Pailat Juta hima kupu leni ya sawe, “Ma ku hei, do kui king apukolaka!” ");
INSERT INTO kwj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ete wowani ya wu ucha, “Ma rini ye! Ma rini ye! Me yapweke tiki ma rini ye!” Wowani Pailat ya wunu sawe, “Kui okokona ti, kui king apukolaka ni me yapweke tiki a ye kiꞌi?” Ete wowani puris hima laka le mwanji wasa ya wu sawe, “Nunu king apukolaka nuhi ba fo nambwe! Sisa tombwa!” ");
INSERT INTO kwj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ete wowani Jisas ni me yapweke tiki rini wu ye kinani Pailat wui tapa tenge tiki ya rini ha. ");
INSERT INTO kwj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wowani Jisas ni ya wu toro. Wosiwani Jisas rinjenga me yapweke ti ri kichani ko laka oti ri hanjaꞌaisini ri ini michi foki ya wu raru. O michi hi ti ete wu uchandau, Hima Mwa Hapa. Hipuru mwanji ki ete wu sawendau, Golikota. ");
INSERT INTO kwj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Woro o michi ki me yapweke tiki ya rini wu ye. Wosini hima fisi opi kumbwa kukwasakicha ya fini wu ye. Wosiwani Jisas nindo tiki ya da. ");
INSERT INTO kwj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Wosiwani Pailat to mwanji tipa foti ri kaisiro ti wu ratani me yapweke ki ya wu yesi. Ka ri kairo himiki mwe ti ete sawero: Nasaret kipe Jisas, Juta hima kupu lei King Apukolaka. ");
INSERT INTO kwj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisas ni me yapweke tiki rini wu yero michi ti, ko laka takai ki dau. Wosiwani Juta hima kupu le miyafo o himiki kaisiro tini ya wu hambwanda. Pailat o mwanji kau kairo ti Hipuru mwanji tiki, Latin mwanji tiki, e, Girik mwanji tiki, ele mwanji namili ki kau ri kaisiro. ");
INSERT INTO kwj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wosiwani Juta hima kupu lei puris hima laka le Pailat ni ya wu sawe, “Apa ka mwanji hinga kai kei: ‘Juta hima kupu lei King Apukolaka.’ Mina. Ka hinga ma kai: ‘Dori hima ete sawero, “Ani Juta hima kupu lei king apukolaka.’” ");
INSERT INTO kwj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ete wowani Pailat ga mwanji wasa ya ri sawe, “Ando a kairo, a kairo hinga ya sa ete da.” ");
INSERT INTO kwj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Au anaye hima le Jisas ni me yapweke tiki rini wu yesini heiye pe nikaꞌari rihi le tokwe opuriꞌopuri ya wu huwa. Wosini ele au anaye hima opuriꞌopuri hinga funda funda ya wu raꞌai. Wosini ki pe nikaꞌari rihi okwe ya ete wu raꞌai. Nikaꞌari mwe wosiro ti, nimba kapa nambwe, ete rauni sikaro hinga wosiro. ");
INSERT INTO kwj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wosini au anaye hima le ka hinga ya wu sawe, “Apa dohaꞌa nikaꞌari rihi nu lefehe hinga. Mina. Satu tini nimba nu yeni nu hei, namoto dikiwa ori hima to o nikaꞌari sa ri raꞌai.” O sumbu hinga wu wosiro ti, Gotri chengi ki sawero ka mwanji hingambwa ya ete sukwa: “Heiye pe nikaꞌari ahi le wu humwasini ya wu raꞌai. Wosini ki pe nikaꞌari ahi keke satu ti wu yeni ya wu hei.” Au anaye hima ele o sumbu hinga ya wu wosi. ");
INSERT INTO kwj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Wondawani Jisas nuwai ga, ti hipache ga, Mariya Kilopas humwe ga, e, Makitala pe Mariya ga, wunu tinda ete Jisas ni yero me yapweke mu ki takaini ya wu eninda. ");
INSERT INTO kwj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Wondawani Jisas heiwani ri nuwai ga ri okokonandau himache rihi ga o ki ya fi eninda. Wondawani Jisas nuwai ni ya ri sawe, “Ai nuwai, o bai hima o ni che.” ");
INSERT INTO kwj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wosini o ri himache ni ya ri ai sawe, “O bai humwe o mi nuwai.” Wowani o gisi kumbwa ri himache ori Mariya ni ri enepe kinani ri aka tokwe ya tini raꞌai. ");
INSERT INTO kwj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ele sumbu hinga ini humbusiwani ya ri hambwa, ele tau rihi ri randaro ti tinda humburo. Wosinumbwa Jisas ya ri ai sawe, “Ani uku sumbwe hi ga ani sainda.” Woro do mwanji Gotri chengi tiki kaisiro hingambwa ete sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Botoli foti kwe chele uku tombwa talesindau ti ya da. Wosiwani uku rarundau sopu chele mwaꞌambwe foti wu torosini kwe chele uku ya wu guto. Wosini me kumbo foki wu injisini Jisas takisopo ki owe ki ya wu rawau. ");
INSERT INTO kwj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wowani Jisas o uku kwe ri asini ya ri sawe, “Yakito.” O mwanji hinga ri bwakoni mwa ti ri ongokoni himamwale rihi ti sirani iwani ya ete ri ha. ");
INSERT INTO kwj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","O gisi Pasofa gisi laka keke mwaꞌambwe otokunandau gisi. Woro ka gisi humbuwa ai saino gisi ti, Pasofa sukwakondau himati gisi. O keke Juta hima kupu le wui okokona ti, o himati gisi ki haro hima tape foti me yapweke tiki apa kau da hinga. O keke seke ti wunu yepwekesini hima tape wuhi ti wu numwani rasika kinani Pailat ni ya wu sawe. ");
INSERT INTO kwj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wosiwani au anaye hima ele wu ini Jisas ga kukwasakicha ki wu yesiro hima fisi opi ni seke ti ya fini wu yepweke. ");
INSERT INTO kwj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wosini wu ini Jisas ni wu heiwani rini haro. Ete wowani heifuni seke rini wu yepweke nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Woro au anaye hima forito rambu tiki meleheku rihi ki ya rini yeheku. Wokowani metengei ete fi tinga uku tinga ya sika. ");
INSERT INTO kwj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","O sumbu ni heiro hima rito mwanji do amwei ri bwandau. Woro o mwanji amwei ri bwandau ti, mwe naha. Wosini rinjenga ri hambwandau, mwanji mwe naha ri bwandau. O keke sembe ti ma ku ha. ");
INSERT INTO kwj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ele sumbu hinga sukwaro ti, Gotri chengi ki sawero hingambwa mwe naha ya ete sukwa. Gotri mwanji mwe ti ka hinga: “Hima tape ki dau hapa rihi foti hinde apa wu yepweke kumbwa.” ");
INSERT INTO kwj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gotri chengi kumbwa dau mwanji ba foti ka hinga sawero: “Apa meleheku ki wu yehekuro hima ni o wu heindakonda.” ");
INSERT INTO kwj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","O sumbu hinga humbusiwani Arimatiya ko kipe Josep tani Jisas hima tape ri raꞌai kinani Pailat ni ya ri sawe, Josep rini Jisas himache fo, woro Juta hima kupu le keke ri akifuni ri sembe ha sumbu tini ya ri yani. Wowani Pailat Josep ni ohounawani ri ini Jisas hima tape ti ya ri numwa. ");
INSERT INTO kwj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotimas, imbihumbwa metengei Jisas tambwa niliki ki ri taro hima, woro rini okwe Josep ga ya fi ta. Rini me fisi fi tiki anahulehusiro kuwa kipe tandau uku ni ya ri rata. O mwaꞌambwe nomo tihi ti 30 kilo nomo hinga. ");
INSERT INTO kwj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Fi tani Jisas hima tape fi numwasini Juta hima kupu le hima si kinani wosindau sumbu ni fi sirinani kuwa kipe tandau uku fi hindi hindi nikaꞌari laka foti ya rini benisi. ");
INSERT INTO kwj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas ni me yapweke tiki rini wu yero michi ki rupwa foti ya da. Wosiwani o rupwa ki matimat ako foti wu gosiro ti ya da, hima forini o matimat ako ki wu si nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","O gisi o Juta hima kupu le, Pasofa gisi laka keke mwaꞌambwe otokunandau gisi. E, o matimat fi takai ki ya da. Opi sumbu keke Jisas ni o matimat ki ya fi si. ");
INSERT INTO kwj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande, apambwa lindanandawani, Makitala kipe Mariya saini matimat tokwe ya ti i. Ti ini ti heiwani matimat sopu ni ichakisiro humokuto beiye laka ti dukwelesiwani ya da. ");
INSERT INTO kwj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wofunu ti ai namani ti ini Saimon Pita ga Jisas funda ete okokonandaro himache ga, fini tambwa ya ti i. Ti ini ya fini ti sawe, “Nui Apukolaka matimat ki sisiro ti wu raꞌaihiro. Nu hikisandau soki rini wu owesinda!” ");
INSERT INTO kwj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wowani Pita ga ori himache foringa o ko fi hanjaꞌaisini matimat tokwe ya fi i. ");
INSERT INTO kwj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Fini anaꞌape ete fi namani fi ikoni ori himache fori Pita ni dikisini rindo mwaseni matimat ki ya ri raru. ");
INSERT INTO kwj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wosini ri opulisini ri takoni ri heiwani nikaꞌari letombwa ya da. Woro ri raru nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wondawani Saimon Pita jepi jepi tani matimat sopu ki ya ri raru. Ri raruni ri heiwani nikaꞌari lembwa ya da. ");
INSERT INTO kwj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wokoni Jisas mwa ki benisiro nikaꞌari foti okwe ya ri hei. Ka nikaꞌari ele nikaꞌari ba fwelenga funda da nambwe. Mina. O apu benini tini owesiro. ");
INSERT INTO kwj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wosiwanumbwa o matimat ki mwaseni taro himache ri okwe ya ri raru. Ri raruni ele mwaꞌambwe ni ri heini sembe ti ya ha. ");
INSERT INTO kwj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Woro Gotri chengi ki sawero hinga Jisas matimat ki mwe naha ai saino mwanji ti fi hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wosini opi himache fisi aka fihi tokwe ya fi ai i. ");
INSERT INTO kwj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wosiwani Mariya matimat hoko tokwe takai ki ti etisini ya ti ichakanda. Ete wondani ti opulisini ti ichaka ichaka matimat sopu ki ya ti takonda. ");
INSERT INTO kwj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Wokoni ti heiwani ensel fisi nikaꞌari wamwa fi soꞌoisini ya fi lininda. Fini Jisas hima tape ni wu andosiro michi kumbwa fi linindaro ti, fori mwa siro tokwe litiwani fori seke siro tokwe liti. ");
INSERT INTO kwj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wowani Mariya ni ya fi sawe, “O bai humwe, hinde wowani ni ichakandau?” Wowani ya fini ti sawe, “Ai Apukolaka wu raꞌaini wu owero michi ti a hikisandau.” ");
INSERT INTO kwj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","O mwanji hinga ti bwasini ti jamekoni ti heiwani Jisas ya eninda. Woro Mariya Jisas nani ti hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wowani Jisas ya tini sawe, “O bai humwe, hinde wowani ni ichakandau? Namoni ni wakindau?” Wowani Mariya ete ya ti hambwa o rupwa aulindau hima po, wondaunani ya ti sawe, “Hima laka, e, rini mi raꞌaini michi foki mi owero ti nawa, o michi ma ani sawesiwa ani ini rini a rata.” ");
INSERT INTO kwj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wowani Jisas ya tini sawe, “Mariya.” Wowani Mariya jamekoni Hipuru mwanji ki ya ti sawe, “Raponai.” Mwanji mwe ti ka hinga: “Ondiyakandiyandau hima.” ");
INSERT INTO kwj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ete wowani Jisas ya tini sawe, “Apa ani toronambu kei. Hinde wowani ani kau ai Yapai tambwa ani ai rau nambwe. Woro nini ai hiparakambwe le tambwa ni ini ka hinga ma wunu sawe: ‘Ani kau ani ai rausini ani ga kunu ga nui Yapai, e, ani ga kunu ga nui Gotri, rini tambwa ani indau.” ’ ");
INSERT INTO kwj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ete wowani Makitala pe Mariya ini Jisas himache leni ya ti sawe, “Apukolaka ani heiro.” Wosini Jisas tini sawero ele mwanji ni ya wunu ti sawe. ");
INSERT INTO kwj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","O gisi Sande sunduya ki, ele himache fotukumbwa wu wausini Juta hima kupu keke wu akini aka ti wu dimisini ya wu da. Wondawani Jisas tani wui nindo tiki ri etisini ya wunu ri sawe, “Sembe kuhi ti sa ete wahapisini da.” ");
INSERT INTO kwj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","O hinga ri bwasini, ri tapa ti, e, ri meleheku ti ya wunu ri mekusi. Wowani ele himache Apukolaka wu heikoni sembe wuhi ti ya wu eripe. ");
INSERT INTO kwj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wowani Jisas ga ai wunu sawe, “Sembe kuhi sa ete wahapisini da. Yapai ani humbwewani a taro, woro hingambwa kunu a humbwewa ku ino.” ");
INSERT INTO kwj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","O hinga ri bwasini, ri takimahai ti wunu ri wuichini humbwesini ya wunu ri sawe, “Himamwale Kipe ma ku toro. ");
INSERT INTO kwj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","E, hima fwelei kapwa sumbu ti ku rani ku humbwewa, o kapwa sumbu humbuhiro. E, hima fwelei kapwa sumbu ti ete ku yekichasiwa, kapwa sumbu wuhi ti o ete yekichasiwani da.” ");
INSERT INTO kwj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas ele ri himache le tambwa ri taro gisi ki ele tapaꞌangi tapaꞌangi hatachi fisi himache wui nindo tiki himache fori wunu ga da nambwe. Hi rihi ti Tomas, ri hi foti Ditimas. ");
INSERT INTO kwj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","O keke himache fwele ya rini sawe, “Nunu Apukolaka nu heiro.” Wowani Tomas ya wunu sawe, “E, ri tapa pe nili wange ti ani heini, ai tapa tongo ti nili wange rihi ti a toromendi nambwe nawa, e, ri meleheku wange ti a toromendi nambwe nawa, sembe ti hinde apa ani ha kumbwa. Minambwe naha.” ");
INSERT INTO kwj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dani ini tapaꞌangi hatachi namili gisi iwanimbwa Jisas himache le Tomas okwe depi o aka kumbwa kwai ya ai wu da. Ele aka duwa hinga tinda ete wu dimisini kwai wu dawani Jisas tani wui nindo tiki ete ri etisini ya ri sawe, “Sembe kuhi ti sa ete wahapisini da.” ");
INSERT INTO kwj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wosini Tomas ni ya ri sawe, “Tapa mihi ti ahaꞌa ki ma humbwewa sa ta. Tapa ahi ti ma hei. Wosini tapa mihi ti mi ai humbwewa meleheku ahi tiki ma toromendinehei. Inaka tenge fisi hambwandau sumbu ma hanjaꞌai, wosini sembe ti ma ha.” ");
INSERT INTO kwj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wowani Tomas ga mwanji wasa ti ya rini sawe, “Mini ai Apukolaka, mini ai Gotri.” ");
INSERT INTO kwj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wowani Jisas ya rini sawe, “Mi ani heiro ti keke sembe ti mi ani haroꞌo? Ani ni hei nambwe wu dani sembe ani ni handau hima le, ele hima hinga sa wu eripeꞌaripe.” ");
INSERT INTO kwj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas ri himache lei miyaningisopo ki kwambu chele sumbu ambwe sumbu ambwe ba fwele okwe ri wosindaro, woro ele ni do chengi ki a kai nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Woro dele mwanji a kairo ti, kunu sembe ku hasini Jisas ni Kurais, e, Gotri Che hinga ku nani sembe ha sumbu kuhi keke ri hi ki himamwale ti ku toro ki. ");
INSERT INTO kwj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dani ini Taipiriyas fwanjuwei takai tiki Jisas ri himache le mu ki ya ri ai sukwa. Wunu ki sukwaro sumbu ka hinga: ");
INSERT INTO kwj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas hi rihi foti Ditimas, Galili mapwa tokwe dau Kenan ko kipe Nataniyel, Sepeti che fisi, e, Jisas himache ba fopi okwe, wunu fotukumbwa ya wu da. ");
INSERT INTO kwj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wondani Saimon Pita ya wunu sawe, “Ani fwaiꞌomwe ai ki ani indau.” Wowani ya wu sawe, “Nunu okwe mini ga nu ino.” Wosini wu ini kanu fotiki ya wu rau. Woro ka gisi niliki fwaiꞌomweche foti wu ra nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nika ti ya sukwakondawani, Jisas fwamwai tiki ya ri eti. Wosiwani ele himache Jisas nani wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wondawani Jisas ya wunu sawe, “Ai che le, fwaiꞌomwe fwele ku raroꞌo?” Wowani ya wu sawe, “Mina.” ");
INSERT INTO kwj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wowani ya wunu ri sawe, “Tukwa ti kanu tapa mama tokwe ma ku rawai, wosini omwe fwele o ku rokonda.” Wowani o tukwa wu rawaisiwani fwaiꞌomwe miyafo naha ete raisiwani o tukwa hinde wu ai longoni wu rasukwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wondawani Jisas ka ri okokonandau himache rito Pita ni ya ri sawe, “Rini Apukolaka.” Wowani Saimon Pita, hoko tokwe soꞌoiro nikaꞌari rihi ti tangoni owesini tau ti ri randaro ti, “Rini Apukolaka” ri naro mwanji tini ri mendindau tinga o nikaꞌari rihi ti ri ai soꞌoisini fwa we tiki chunani ya ri rai. ");
INSERT INTO kwj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wowani himache fwele kanu we ki wu dasini o tukwa ga fwaiꞌomwe ele ga longo longo ya wu i. Hinde wowani, fwamwai ti 100 meta hinga wu takaindawani. ");
INSERT INTO kwj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wosini fwamwai tiki wu sukwani wu heiwani hi lama fwele ya unda. Wondawani fwaiꞌomwe ti hi tenge tiki undawani bereti fwele okwe ya waninda. ");
INSERT INTO kwj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wondawani Jisas ya wunu sawe, “Apa chumbwa ku raro fwaiꞌomwe fwele ma rata.” ");
INSERT INTO kwj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","O hinga ri sawewani Saimon Pita kanu tenge tiki ai rauni tukwa ti longoni hapimwai tokwe ya ri rasukwa. Fwaiꞌomwe laka letombwa 153 hinga o tukwa ki ete sukwani tale. Omwe miyafo naha, woro tukwa oti tukuto nambwe. ");
INSERT INTO kwj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Wosiwani Jisas ya wunu sawe, “Ma tani ku a.” Wowani himache forito ete rini sili nambwe, “Mini namo?” Hinde wowani, wu hambwandau, rini Apukolaka. ");
INSERT INTO kwj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas tani bereti ri rukoni ya wunu ha. Wosini fwaiꞌomwe ti okwe o hingambwa ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dohaꞌa wa tiki ri ai saisini numbo namili Jisas ri himache lei miyaningisopo tiki ri sukwaro. ");
INSERT INTO kwj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wu ani humbusiwani Jisas Saimon Pita ni ya sawe, “Saimon, Jon i che, dele hima ni mi dikisini mindo mwe naha ani keke ete mi wondauꞌu?” Wowani Pita ya sawe, “Ei, Apukolaka. Mi hambwandau, ani mini keke a wondau.” Wowani Jisas ya rini sawe, “Ai fe che asa che le ahirahi ti ma hawa sa a.” ");
INSERT INTO kwj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wosini numbo fonga ya ri ai rini sawe, “Saimon, Jon i che, mwe naha ani keke mi wondauꞌu mina?” Wowani Pita ya rini sawe, “Ei, Apukolaka, mini mi hambwandau, ani mini keke a wondau.” Wowani Jisas ya rini sawe, “Ai fe che asa che le ma aulini enependa.” ");
INSERT INTO kwj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wosini numbo namili ya ri ai rini sili, “Saimon, Jon i che, ani keke mi wondauꞌu?” Wowani Pita sembe amwaka ti ya rini a, numbo namili ka hinga rini siliro ti keke, “Ani keke mi wondauꞌu?” Wosini Jisas ni ya ri sawe, “Apukolaka, mini ele mwaꞌambwe hinga tinda ete mi hambwasindau. Woro mi hambwandau, ani mini keke a wondau.” Wowani Jisas ya rini sawe, “Ai fe che asa che leni ahirahi ti ma hawa sa a. ");
INSERT INTO kwj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Mwe naha ki mini a sawendau, hima wapa mi daro gisi ki, mini leti kupu ti mi injisini mi ino michi hinga mi okokona tiki mi indaro. E, ichai mekupu mi tisiwa, tapa ti mi rasaisiwa, hima foto leti kupu ti mini injisini mi i ki mi diyahandau michi tokwe mini ra ra indano.” ");
INSERT INTO kwj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas do mwanji hinga ri bwaro ti, ichai Pita ri hani Gotri hi tini ri rasaino numbo tini ri sawero. Wosinumbwa Pita ni ya ri sawe, “Ma ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita jamekoni heiwani Jisas okokonandau himache ori fini sirinani ya ta. Hima mwe ri mwasembwa ka ahirahi andaro gisi tiki Jisas i inaka mu takai ki litisini ete sawero hima, “Apukolaka, namoto miho lei tapa tenge tiki mini owekondau?” ");
INSERT INTO kwj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita rini heisini Jisas ni ya sawe, “Apukolaka, dori hima to hinde na hinga?” ");
INSERT INTO kwj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wowani Jisas ya rini sawe, “E, ani ai a tano gisi ki ete ri da ki ani okokonawa, hinde, ka mindo mi tauꞌu? Mini mi ani sirina.” ");
INSERT INTO kwj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","O mwanji rihi keke mwanji suwa ti hiparakambwe lei nindo ki ka hinga ya ichiꞌucha, ka himache apa hinde ha kumbwa. Woro Jisas ete sawe nambwe, ri ha hinga. Mina, ete ri sawero, “E, ani ai a tano gisi ki ete ri da ki ani okokonawa, hinde, ka mindo mi tauꞌu?” ");
INSERT INTO kwj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dohaꞌa ori himache to dele mwanji hinga amwei ri bwani ele ni ri kairo. Wosiwani nu hambwandau, amwei ri bwaro mwanji ti mwe naha. ");
INSERT INTO kwj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas wosiro sumbu ba fwele okwe miyafo naha ete dau. Woro hima fori ele sumbu hinga ni funda funda ri kaisiwa buku le sukwapo, ani hambwawani, do nuwe tipa laka tinda ete ele buku ni hinde apa torokoro ambwa. ");
INSERT INTO kwj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Seꞌe, Tiofilas, ka imbihumbwa a kairo chengi oti Jisas to wosiro ele sumbu ga ele hima ni ri ondiyakandiyandaro mwanji tini a kairo. ");
INSERT INTO kwj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","A kaini ani ambwero mwanji jipe naha ti, oti Gotri Himamwale Jisas ni sawesiwani ele ri himache rihi naro leni wu rano tau tini kwambu tiki wunu ri sawero. Wosiwani Gotri rini rani hewen ko tiki ya rini rakau. ");
INSERT INTO kwj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas metengei naha amwaka ti ri mendini me yapweke tiki ri haro. Wosinumbwa ele ri himache mu tiki gumwa kumbwa ya ri sukwa. Ri sukwasini sumbu miyafo ya ri wosi, wowa apa wu hambwa kinani, rini ri haro ti ri ai sairo. Ete ri dawani gisi ti 40 ki rini wu heiwani, Gotri kwambu ni ya wunu ri sawe. ");
INSERT INTO kwj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Rini wunu ga ete ri dani kwambu tiki ya wunu ri sawe, “Apa kunu Jerusalem ko ti ku hanjaꞌai kei. Ma ku dani ai yapai kunu ha kinani ri bwasiro mwaꞌambwe ti ku nikisinda. Ani okwe ka imbihumbwa kunu a sawe to, ");
INSERT INTO kwj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘E, Jon to ele himiyama hurahama ni fwa minde tiki uku o wunu ri yasiro. Woro gisi miyafo i hinga Gotri Himamwale kipe ki kunu yasino.” ’ ");
INSERT INTO kwj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ka gisi ki ele ri himache funda ete wu wausini ya rini wu sili, “Apukolaka, do gisi kumbwa mini Isurel hima kupu lei king apukolaka mi waꞌaisini funda nunu mi aulinoꞌo?” ");
INSERT INTO kwj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ete wowani mwanji wasa ti ya wunu ri sawe, “O kui tau mina. Ai Yapai ri owero gisi ti kunu ku hikisandau. Rinjenga o sumbu sukwano gisi tini ri hambwandau. ");
INSERT INTO kwj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Woroti, ma ku mendi, gisi miyafo i hinga Gotri Himamwale kipe kunu tambwa sikawambwa apa kwambu ti ku toro sindau. Wosinumbwa ai mwanji ti Jerusalem ko tiki ku bwani, e, ele Jutiya mapwa ku bwani, ele Sameriya mapwa ku bwani ini do nuwe laka hinga ete funda ku chikino.” ");
INSERT INTO kwj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ele mwanji hinga ri bwani ri humbusiwani ele hima miya rini numbwa wu misindawani ya ri rau. Ri rauwani niri wamwa ti hiki hinga tito sikani ya rini rakau. Ete wowani wunu ya rini wu hei ki heifu. ");
INSERT INTO kwj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri rausiwani wunu niri tini ete wu maundawani o gisi naha kumbwa hima fopi fisi wunu ga ya fi eti. Hima mwe pi fini nikaꞌari wamwa tini fi injiro. ");
INSERT INTO kwj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Woro findo ya fi sawe, “Kunu Galili pe hima le, hinde wowani ku etisini niri tini ku maundau? O ku heiwani raundau Jisas, oti Yapai Gotri to hewen ko tokwe ai rini rakaundau. Ichai, do ri rauwani ku heiro hingambwa o ri ai takonda.” ");
INSERT INTO kwj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","O hinga fi bwasiwani ele hima o kimba, hi ti Olif, oti wu hanjaꞌaisini Jerusalem ko tokwe ya wu i. Ka kimba hi ti Olif, oti Jerusalem ko tini takaisini dau, himati gisi tiki Juta hima kupu leni ohounawani wu indau numbo fai hinga wu iro. ");
INSERT INTO kwj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ele hima wu ini Jerusalem ko laka ti wu raruni wui me aka ki kiheiye aka tipa wuhi tiki ya wu rau. Hi wuhi le kale: Pita, Jon, Jemis, Anduru, Filip hima pi Tomas, Batolomiyu hima pi Matiyu, Jemis yapai rihi Alafiyas, Saimon Jutiya ko keke gangambanindau hima, Jutas yapai rihi Jemis. ");
INSERT INTO kwj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kale hima tiya hinga wunu sembe funda naha wu hambwani Gotri ni wu uchahambwandani ya wu da. E, himiyama le, Mariya Jisas ri nuwai, Jisas ri hipache le, wunu okwe funda wu wausini Gotri ni ya wu uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","O gisi ki Pita ri saini ele ri hiparakambwe lei nindo tiki ri etisini mwanji fo ya ri bwakonda. Hima mwe le wu wausini wu daro ti 120 hinga. ");
INSERT INTO kwj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pita ya ri sawe, “Ai hiparakambwe le, mwanji foti Gotri chengi tiki dau ti, imbihumbwa Gotri Himamwale kipe tito Defit takisopo tiki bwaro. Rini Jutas ni ri bwaro. Kari hima to Jisas ni toroni injiro hima leni numbo tini ri mekusiro. Woroti apa o sumbu chengi tiki kaisiro hinga siraro. ");
INSERT INTO kwj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Imbihumbwa Jutas nunu ga ichiꞌuchandaro hima. Rini okwe dohaꞌa tau funda nunu ga ri raro.” Pita o hinga ya wunu ri sawe. ");
INSERT INTO kwj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kari hima Jutas nuwe tipa foti ri raro ti ya mwe ti kapwa sumbu tini wungwa ri jiro. O nuwe tipa ri rasini ri onjohokinani mwarimwari nuwe tiki ri raiwani sembe rihi ti fikakoni setuwapu hinga tinda ete nuwe tiki ya sika. ");
INSERT INTO kwj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","O hinga rini wosiwanumbwa Jerusalem pe hima le o sumbu ni ya wu hambwa. Wosini ka nuwe tipa wui mwanji tiki ka hinga wu uchandau, Akeletama. O mwanji jamekowa ka hinga, “Hima fi sikaro nuwe.” ");
INSERT INTO kwj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wosini Pita ya ai sawe, “Dohaꞌa mwanji imbihumbwa Sam chengi tiki kairo ti ka hinga: “Aka rihi ti sa nimba da. Hima fori apa o aka rihi ki da kei.” Sam chengi tipa fotiki kairo mwanji fo ka hinga ai sawero: “Hima forito ri tau wa tiki sa eti.” ");
INSERT INTO kwj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“O keke apa hima forini nui nindo tiki nu wakini Juta ri tau wa tiki nu esino. Jisas Apukolaka ga ichiꞌuchandani ri wosindaro sumbu hinga ni heiro hima forini nu esino. ");
INSERT INTO kwj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon imbihumbwa ele himiyama hurahama ni uku ti yasindawani Jisas tau mu ti ri rasaisini ete ri ra ra ri ta tani Gotri Jisas ni rakauro gisi tiki ya ri ambwe. O sumbu hinga tinda heiro hima forini apa nu esino. Wosiwambwa apa do tau nu randau tau hinga ri rani ai sairo Jisas hi tini ri saweno.” ");
INSERT INTO kwj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita o hinga ri bwani hima fisi ya wu esi. Fori Josep, Basapas hi ba fo rini uchandau, hi rihi foti Jasitas. E, hima fori Mataiyas. ");
INSERT INTO kwj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wosini Gotri ni ka hinga ya wu uchahambwa, “Apukolaka, mindombwa ele hima i sembe mi hambwandau. Apa ma nunu mekusi, hinde na hima ni nunu mi ondiyasino, ");
INSERT INTO kwj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","wosiwa Jutas wa tiki ai etisini do mi himache tau hinga ri rano? Jutas dohaꞌa tau mihi hanjaꞌaisini ri hani ri iro.” ");
INSERT INTO kwj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wosini Gotri ni wu uchahambwasini fini keke tapa wuhi wu rasaiwani Mataiyas to Gotri okokona ya ri eti. Wowani ele tapaꞌangi tapaꞌangi hatachi funda himache lenga ya ri eti. ");
INSERT INTO kwj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ete wowani Pendikos gisi tawani o gisi okwe aka laka fokumbwa wunu tinda ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wosiwani metengei ete ata laka foti hewen ko tiki ausuwa laka sindau hinga ya gi. Wokoni o ata gale wu linindaro aka laka ki ete raru. ");
INSERT INTO kwj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wowani hi ti tarukwe hinga sirakoni huwa huwa ele hima wui tape tenge tiki funda funda ya wunu liti. ");
INSERT INTO kwj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wosiwani Gotri Himamwale kipe funda wunu talesini wunu okulandawani mwanji ba fo ba fo hinga ya wu bwanda. ");
INSERT INTO kwj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","O gisi ki, Jerusalem ko tiki Juta hima kupu fwele ele mapwa ele mapwa tokwe tasini ya wu da. Wunu Gotri ni akindau hima. ");
INSERT INTO kwj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ka ata giwani ele hima miyafo wu tani ya wu wau. Wosini wu mendiwani Jisas ri himache le ele hima i mwanji minde hinga wu bwawani ete wu apapana. ");
INSERT INTO kwj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wokoni inaka miyafo wu wohambwakahambwakoni ya wu sawe, “Hinde na hinga? Do mwanji bwandau hima le wunu Galili kipe hima lembwa. ");
INSERT INTO kwj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hinde wowani nui mwanji hinga funda funda wu bwandau? Nu mendiwani nui nuwai yapai bwandau mwanji gale hinga! ");
INSERT INTO kwj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nunu ele ko ele ko ki nu taro, nunu fwele Patiya kipe, fwele Mitiya kipe, e, fwele Ilam kipe. Nunu fwele Mesopotemiya mapwa tokwe nu taro, fwele Jutiya, fwele Kapatosiya, fwele Pondas, e, fwele Esiya, ");
INSERT INTO kwj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","e, fwele Firisiya, fwele Pamufiliya, fwele Isip, e, fwele Lipiya, Sairini takai ki dau. Nunu fwele Rom ki nu dau Juta hima kupu ga wui sumbu torosindau hima lenga, nu tasini ahaꞌa ki nu dau. Nunu fwele Kuwit kipe, fwele Arepiya kipe. Nunu tinda ete ma nu mendi, nui mwanji ba fo ba fweleki ele Gotri wosiro sumbu laka tini wu bwandau.” ");
INSERT INTO kwj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wokoni ele hima wu apapanani inaka miyafo naha ya wu hambwanda. Wondani wunjenga ka hinga tini ya wu anambwa, “Dohaꞌa bwele sumbu hinga?” ");
INSERT INTO kwj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ete wondani hima fwele ka hinga ya wunu saweholiya, “Waini uku ako miyafo naha asini wu ambwatinambwatindau.” ");
INSERT INTO kwj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ete wowani Pita ele tapaꞌangi tapaꞌangi hatachi funda lenga ri etisini hapa tinga ri uchani ele himiyama hurahama miyafo leni ka hinga ya ri sawe, “Kunu ele Juta hima kupu, kunu ele hima fwele Jerusalem ku tasini ku dau okwe, kunu wasamba ma ku owesini mwanji ahi ti ku mendini dohaꞌa sumbu ku hambwa. ");
INSERT INTO kwj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kunu hinde ku hambwandau, dele himako ambwatinambwatindauꞌu? Mina. Hinde wowani apambwa nurumbu, 9 kilok ya iu. ");
INSERT INTO kwj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gotri mwanji bwarakarandaro hima Jowel imbihumbwa ri chengi ki ele sumbu ni ka hinga sawero: ");
INSERT INTO kwj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Gotri ka hinga ya sawe, ‘Gisi jipe takaiwa ai Himamwale kipe ele himiyama hurahama ni humbweno. Wowa ele kui himiyama hurahama che Gotri mwanji wu bwarakarandano. Wosini ele kui hima wapa leni a wosiwa wunu tukuyaneheindau hinga ele sumbu ambwe wu heino. Wosini ele kui mekupu le wu tukuyaneheiwa sumbu fwele wunu a mekusino. ");
INSERT INTO kwj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O gisi kumbwa Himamwale kipe ahi ti ai tau ra himiyama hurahama le okwe a humbweno. Wosiwa Gotri mwanji wu bwarakarandano. ");
INSERT INTO kwj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Wosini kari kau niri ni a wosiwa sumbu ba fo hinga sirano. E, kari kai nuwe ni a wosiwa sumbu ba fo hinga sirano. O hinga a wosiwa ka nuwe ki fi tinga hi tinga hiki omwesika laka tinga o sirakonda. ");
INSERT INTO kwj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wosini nika ti a jamekowa o hundukonda. Niliki nika ti a jamekowa naro o sirakonda. Wowambwa Apukolaka ri gisi ti o sirakonda. O gisi rihi omwesika laka kwambu naha. ");
INSERT INTO kwj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wosiwa hima fwele Apukolaka hi tini mwe naha uchawa wunu okulani raꞌaikonda.” ’ Gotri mwanji bwarakarandaro hima Jowel o hinga sawero. ");
INSERT INTO kwj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Wosini Pita tombwa ya ri ai sawe, “Kunu Isurel hima kupu le, kunu dohaꞌa mwanji ma ku mendi. Ani Nasaret pe Jisas ni kunu a sawekondau. Kunu ku hambwandau, ka kui nindo tiki ri dasini Gotri kwambu tiki ba fo ba fo sumbu kwambu ri wosindaro ti. O sumbu hinga ri wosindaro ti, oti ku heini ku hambwa kinani, rini Gotri to rini humbwewani ri taro. ");
INSERT INTO kwj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Imbihumbwa kapwa Gotri to rinjenga ri hambwani funda bwani mendiro mwanji hinga ori hima ni kui tapa tenge ki ri owero. Wosiwani ele kapwa hima wui tapa tenge tiki rini ku hasini ku sawewani me yapweke tiki rini wu yeni wu siro. ");
INSERT INTO kwj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wosiwani ori hima amwaka mendini ri haro ti, Gotri oti ni rani humbwesini rini ai rasairo. Hinde wowani, o rini eini siro wa ti hinde apa rini toronambusi kumbwa. ");
INSERT INTO kwj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E, Defit okwe o hingambwa rini numbwa imbihumbwa ri chengi Sam ki sawero: “Ani ani heiwani Apukolaka ri ani ni takaisini ete ri dau. Rini ani takaisini dani kwambu ti ani handau. Wosiwa sumbu foti hinde ani yetupwa kumbwa. ");
INSERT INTO kwj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wondawani sembe ahi ti kipe naha sukwandawani kipeheki mwanji tumbwa a bwandau. Wosini anjenga mwaꞌambwe kipe tini a nikisindau. ");
INSERT INTO kwj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Apa ambusuwa lei ko tiki mi ani hanjaꞌaisiwa a da hinga. Hima kipe naha mihi ti mi ani hanjaꞌaisiwa wa tiki apa ai tape ti kupwaꞌai hinga. ");
INSERT INTO kwj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","E, himamwale ako torono numbo ti mi ani mekusihiro. Mini ani ga ete mi dawa, apa ete ani eripendano.” Defit o hinga ri sawero. ");
INSERT INTO kwj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ai hiparakambwe le, ma ku mendi. Defit sawero mwanji oti rinjenga ri sawe nambwe. Hinde wowani, rini imbihumbwa ri haro. Wosiwani rini wu eini wu siro. Ri wa mwe ti nui nindo tiki ete da dani apa ya ete da. ");
INSERT INTO kwj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Woroti, Defit rini Gotri mwanji bwarakarandaro hima. Rini Gotri rini ga mwanji funda mwe naha fi bwani fi mendiro ka tini ri hambwandaro, “Ichai mi anitafenita forini mini hinga king apukolaka rini ani esikonda.” ");
INSERT INTO kwj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Defit o sumbu ni Gotri wosiwa ichai sirano ti rini ri hambwandaro. Wosini Kurais ri ai saino sumbu tini ete ya ri sawe, “Gotri apa rini hanjaꞌaisiwa ambusuwa ko tiki ete ri da hinga. Wosiwa hima tape rihi ti apa kupwaꞌai hinga.” ");
INSERT INTO kwj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","O mwanji hinga keke Jisas mwe Gotri ai rini rasairo. Nunu tinda ete nu heisini ka hinga nu sawendau. ");
INSERT INTO kwj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Apa Jisas hewen ko tiki ri rausini Gotri tapa mama tokwe ya ri dau. Ri Yapai Gotri to Himamwale kipe rihi rini ha kinani sawero hinga ya rini ha. Woro hinga apa o Himamwale ri humbwewani sikawani ka ku mendisini ku heini ku hambwahito. ");
INSERT INTO kwj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Defit rini hewen ko tiki ri rau nambwe. Woroti rinjenga imbihumbwa ri chengi Sam ki ete ri sawero: “Apukolaka ai Apukolaka ni ka hinga ri sawero: ‘Mini ai tapa mama tokwe mi linindawa ");
INSERT INTO kwj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ichai ele mi miho hima a sawewa mi seke tako tiki wu dano.” ’ ");
INSERT INTO kwj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Apa kunu Isurel pe hima le, ka tini ya ma ku hambwa. Ka me yapweke ki ku yero Jisas Gotri rini ni Apukolaka esisindau. Rini Kurais.” Pita o hinga ya wunu ri sawe. ");
INSERT INTO kwj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","O mwanji hinga tini wu mendini sembe amwaka ya wunu a. Wowani Pita ga ele himache fwelenga wunu ni ya wu sawe, “Nui hiparakambwe le, apa hinde hinga nu wosino?” ");
INSERT INTO kwj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wowani Pita ya wunu ri sawe, “Kunu tinda ete funda funda sembe kuhi ti kapwa sumbu kuhi gumwa ma ku sisini Jisas Kurais ri hi tiki uku ti ma ku yawa, Gotri kapwa sumbu kuhi ti sa rani sa rumbwe. O hinga ku wosiwambwa apa Gotri Himamwale kipe rihi ti kunu ri hano. ");
INSERT INTO kwj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Imbihumbwa Gotri Himamwale kipe ti kunu ri ha kinani ri sawero ti apa kunu ga kui chechehimache lenga ele himiyama hurahama apahime dau le okwe wunu ri hakondau. Gotri to wunu uchawani rini tambwa wu tawambwa Himamwale kipe rihi ni wunu ri hakondau.” ");
INSERT INTO kwj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wosini Pita ele mwanji fwelenga wunu ri sawesini mwanji kwambu fonga ya wunu ri sawe, “Kunu hambwafwaꞌai, apa ele kapwa hima lenga walambe funda kunu ino keke sembe kuhi ti ma ku ha.” ");
INSERT INTO kwj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wowani ele hima Pita i mwanji ni wu mendini wu sirinawani uku ti ya wunu yasi. Wowani o gisi ki Gotri ele sembe haro hima hinga raꞌaiwani 3,000 hinga ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wosini wunu ele Jisas himache lei mwanji ni kipe naha wu mendini ele hiparakambwe leni wu okulani a funda wu ani, Gotri ni ya funda wu uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Wondawani ele sembe haro himako Gotri ni wu akindawani Gotri ele himache lei tapa tiki ba fo ba fo sumbu ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ete wowani ele himiyama hurahama sembe ti Kurais numbwa wu hasini ya funda wu da. Wosini ele mwaꞌambwe wuhi wu hambwawani funda ete wui mwaꞌambwe hinga. ");
INSERT INTO kwj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wosini ele wui nuwe tipa fwelenga mwaꞌambwe wuhi fwelenga ele hima ga wungwa wu jindaro. Wosini o ya wu torosini wu ratani, ele bwarichape hima, e, ahirahi nambwe hima leni wu humwasini ya wu haꞌi hata. ");
INSERT INTO kwj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wunu sembe funda ete wu dani gisi gisi Gotri aka laka tokwe funda wu indaro. Wunu ele aka ele aka ki wu wausini ahirahi ti funda wu andani sembe kipe naha wu hambwandani ya wu eripenda. ");
INSERT INTO kwj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gisi gisi wunu Gotri hi tini ete wu rasaindawani ele himiyama hurahama wunu heini sembe wuhi ti wunu ni wu eripendaro. Ele gisi hinga Gotri hima fweleni ri ai ratawani sembe ha himako miyafo naha ya inda. ");
INSERT INTO kwj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gisi fo nika raini 3 kilok iwani Pita hima pi Jon Gotri aka laka tokwe Gotri ni uchahambwa kinani ya fi i. Juta hima kupu le Gotri aka laka ki o amwa hinga gisi gisi Gotri ni wu uchahambwandaro. ");
INSERT INTO kwj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","O Gotri aka laka takai ki seke kapwa hima fori o ki ya ri lininda. Ri nuwai o hinga ete rini raro. Gisi gisi ele hima rini ratani Gotri aka laka lengenumbo foriki, hi ti, Kipe Naha, tiki ya rini lisisi. Wosiwani ele hima miyafo naha o Gotri aka laka ki rarundawani ya mwaꞌambwe keke ete ya ri uchanda. ");
INSERT INTO kwj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Woro ori hima to Pita hima pi Jon Gotri aka laka ki fi rarukowani ya ete fini ri heikoni ya keke ya fini ri ucha. ");
INSERT INTO kwj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wowani Pita hima pi Jon miya kwambu tiki ya rini fi misi. Fi misini Pita ya rini sawe, “Mini sini ni ma hei.” ");
INSERT INTO kwj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wowani miya ri jamekoni fini ni ya ri hei. Rini ete ri hambwaro, “Mwaꞌambwe fwele o fi ani hakonda.” ");
INSERT INTO kwj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wowani Pita ya rini sawe, “Ani ya nambwe. Do mwaꞌambwe ani ga dau ti, mini ani hakondau ti, Nasaret ko kipe Jisas Kurais hi tiki mini a sawekonda. Mini ma saini ma i!” ");
INSERT INTO kwj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wosini Pita tapa mama rihi tiki rini toroni ya rini rasai. Wowani metengei ba tatumbu rihi ti ri mendiwani kwambu naha ti ya i. ");
INSERT INTO kwj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wosini ri sipikinani ri etini ya ri i. Sipikilepikini ri ichiꞌuchandani Gotri hi tini ri rasaindani Gotri aka laka we tiki fini ga ya funda wu raru. ");
INSERT INTO kwj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wowani ele himiyama hurahama rini heiwani ri ichiꞌuchandani Gotri hi tini ya ri rasainda. ");
INSERT INTO kwj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wowani ya wu hambwa, “Do hima Gotri aka laka lengenumbo foriki, hi ti, Kipe Naha, uchandau tiki linindaro hima, wosini ya mwaꞌambwe ti keke uchandaro hima.” Woroto rini wu heiwani kipe naha ya ri ai ri wosi. Wowani wu apapanani inaka wuhi ti endiki naha ya wunu i. ");
INSERT INTO kwj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wosiwani ori hima Pita hima pi Jon ni torosini sirina sirina ri indawani ele apapanaro himiyama hurahama miyafo rini ni wu hei kinani wu namani wu ini Juta hima kupu lei king apukolaka fori Solomon imbihumbwa kiro, Solomon Tapa Aka, nandau tiki ya wu wau. ");
INSERT INTO kwj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wowani Pita wunu heifuni ele himiyama hurahama ni ka hinga ya ri sawe, “Kunu Isurel hima kupu le, hinde wowani inaka tenge miyafo ku hambwandau? Bwele keke sini ni miya ku misindau? Kunu ka hinga ete ku hambwandauꞌu, o sumbu hinga ti, si kwambu, e, Gotri ni hambwandau sumbu sihi tiki si wosiwani kipe ri wosini ri indauꞌu, oto? Minambwe naha! ");
INSERT INTO kwj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O sumbu sukwaro ti, nui metele Epuraham, Aisak, Jekop hima i wui Gotri to ri tau ra himache ri, Jisas hi tini ri rasairo. Hima mwe ri kale miho hima lei tapa tenge tiki o ku ha to. Woro Pailat ri inaka ti rini hanjaꞌaiwa ri i ki. Wowani kunu, mina. Kunu rini ni gumwa ku siro, Pailat mwakambe tiki. ");
INSERT INTO kwj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Wosini kunu kari hima kipe naha, sumbu kipe naha wosindau hima rini gumwa ku sisini hima yeni siro hima ori ni Pailat ni ku uchani ya ku sawe, hanjaꞌaiwa sira kinani. ");
INSERT INTO kwj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wosini ori numbo kipe naha ki nunu raꞌaino hima rini ya rini ku yeni ku si. Woroti ori hima Gotri ai rini ri rasairo. Wowani sini o sumbu si miya tiki si heisini si bwandau. ");
INSERT INTO kwj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sini Jisas ni sembe sihi ti si hasindau hima. O keke Jisas to ri hi tiki dori hima ni okulasiwani kipe naha rini wosisiwani apa o sumbu ni ku heini ku hambwandau. Jisas tombwa sini okulasiwani si sembe ti rini ni si haro. O sembe ha sumbu keke do kwambu kui miyaningisopo tiki rini wosiwani ku heihito. ");
INSERT INTO kwj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ai hiparakambwe le, mwe naha ani hambwanda. Kunu ku hambwa nambwe ka sumbu hinga ti ku wosiro. Kui apukolaka le okwe wunu o hingambwa wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ka mwanji hinga ti, Gotri imbihumbwa ri mwanji bwarakarandaro hima lei wui takisopo ki sawero, ri Che ri Kurais to nomo rano. O sumbu hinga ku wosiro ti, oti o Gotri sawero mwanji hinga ni ete ku sirinaro. ");
INSERT INTO kwj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Woroti, apa o kui kapwa sumbu gumwa ma ku si. Wosini sembe kuhi ti ma ku hawa, Gotri kapwa sumbu kuhi ti sa ri rani ri rumbwewa hima kipe naha ku sira. ");
INSERT INTO kwj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","O hinga ku wosiwa apa Apukolaka to kwambu ako ti sa kunu ha. Wosini Jisas ni ri humbwewa kunu tambwa sa ai ta. Hima mwe ri imbihumbwa Gotri to ondiyasiro hima ri, hi rihi ti Kurais. ");
INSERT INTO kwj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hima mwe ri apa hewen ko tiki ri dani mwaꞌambwe tinda ete ako naha sira kinani Gotri to sawesiro gisi tini ri nikisinda, imbihumbwa ka Gotri mwanji bwarakarandaro hima kipe naha lei wui takisopo ki ri sawero hinga. ");
INSERT INTO kwj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Moses ka hinga ri sawero, ‘Kui Apukolaka Gotri, apaꞌichai kui hiparakambwe forini kui nindo tiki ani hinga ri mwanji bwarakarano hima hinga o ri esikonda. Wosiwa kunu ori hima i mwanji ti ma ku mendini kunu ele ri bwano mwanji hinga tinda ma ku sirina. ");
INSERT INTO kwj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","E, ele hima hinga o Gotri mwanji bwarakarandau hima ni wu mendini wu sirina nambwe ti nawa apa Gotri tinda wunu yewa wu humbuno. Wowa apa wunu Gotri hima kupu hinga hinde wu da kumbwa.’ ");
INSERT INTO kwj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Imbihumbwa Gotri mwanji bwarakarandaro hima ri, Samiyel ga ri gumwa ki taro Gotri mwanji bwarakarandaro hima lenga bwaro ti apa mwe naha sukwa sukwa ya inda. ");
INSERT INTO kwj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Kunu ele mwanji bwarakarandaro hima lei anitafenita. Kunu Gotri to mwanji ti kui atei hima ga funda wu bwani wu mendiro mwaꞌambwe tini o ya ku toronda. Imbihumbwa Epuraham ni ete ri sawero, Mi anitafenita keke dele nuwe kipe hima hinga wunu okulano mwanji ahi ti wunu ani hakondau. ");
INSERT INTO kwj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gotri ri tau ra himache ai rini ri rasairo. Wosini rini humbwewani rindo metengei kunu tambwa ya ri ta, wosiwa Gotri kunu okulawa kunu funda funda kapwa sumbu kuhi gumwa ku sisini kipe naha ku sira kinani.” ");
INSERT INTO kwj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ele himiyama hurahama ni mwanji fi bwandawani puris hima fwele, Gotri aka laka aulindau hima laka ri, e, Satiyusi hima le okwe ya ete wu ta. ");
INSERT INTO kwj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wosini fi mwanji wu mendini ya wu hambwa, opi hima ele himiyama hurahama ni mwanji fi bwandau ti, Jisas hasini ai sairo hingambwa ele haro hima le okwe tinda ai saino. O keke fini ni sembe amwaka laka wu mendikoni fini toroni kalapus tokwe ya fini raꞌai. ");
INSERT INTO kwj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","4","Wosini o gisi sunduya kumbwa ele hima fini toroni kalapus fini wosiwani niliki fi tukuyawani ya lindana. Ele himiyama hurahama miyafo o fi mwanji ni wu mendini sembe wuhi wu haro ti, hurahama lembwa wu gendiwani 5,000 hinga sukwaro. ");
INSERT INTO kwj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dani lindanawani ele Juta hima kupu wui kanisol lenga, ele wui mekupu ga ele Gotri lo mwanji hambwandau hima laka lenga Jerusalem ko tiki ya wu ta. ");
INSERT INTO kwj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wosini puris hima i apukolaka ri Anas, Kaiyafas, Jon, Alekisanda, e, puris hima i apukolaka ri hima kupu lenga ya funda wu wau. ");
INSERT INTO kwj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wosini opi Jisas himache ni wui miyaningisopo tiki fini wu esisini ka hinga ya fini wu sili, “Kunu bwele kwambu hinga tini ku torosini namoi hi hinga tini ku uchandani ka sumbu hinga ku wosindau?” ");
INSERT INTO kwj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wowani Pita Gotri Himamwale kipe rini ki talesindau tiki ya wunu ri sawe, “Kunu Isurel hima kupu wui kanisol lenga mekupu lenga, ");
INSERT INTO kwj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","apa kunu kari seke kapwa hima ni kipe si wonorukwero ti keke sini ku sili ki ku hambwandani, e, kari hima ni hinde hinga kipe si wonorukwero tini ku mendi kinawa, ");
INSERT INTO kwj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kunu tinda ete ma ku hambwawa Isurel hima kupu le okwe sa wu hambwa. Ka Nasaret pe Jisas Kurais hi rihi tiki dori hima kipe wosiro. Wosini apa kui miyaningisopo ki ori eninda. Kunu Jisas ni me yapweke tiki rini ku yero ti, Gotri to wa we tiki ai rini rasairo. ");
INSERT INTO kwj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hima mwe ri Jisas imbihumbwa Gotri chengi tiki rini ni kaisini ka hinga sawero, ‘Ele aka tau randau hima leto o worumbo ni kapwa wu nani wu humbwero tito apa o aka ni kipe naha ekikinasindau.’ Woro kunu kale aka tau randau hima hinga. Hinde wowani, kunu Jisas ni kapwa ku nani ku yeni ku siro. ");
INSERT INTO kwj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hinde na hima forito apa nunu ri okula kumbwa. Dele mapwa laka hinga Gotri nunu ai ri ratano hi ti hima hi anandi foni ri meku nambwe, O Jisas hi numbwa.” ");
INSERT INTO kwj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wondawani wunu Pita hima pi Jon ni wu heiwani fini fi aki nambwe, kwambu tinga ya fi bwanda. Wowani ya wu hambwa, fini imbihumbwa sukul fi wo nambwe, fini chengi hambwa hima mina. Fini hi nambwe hima. O hinga keke inaka tenge miyafo ya wu hambwanda. Woroti wunu hambwanda, imbihumbwa fini Jisas ga fi ichiꞌuchandaro. ");
INSERT INTO kwj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wokoni wu heiwani fi sawewani kipe wosiro hima ori fini ga ri etiwani wunu mwanji fori wu ai fini wu bwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wofunu fini sawewani kanisol aka fi hanjaꞌaisini hoko tokwe ya fi raru. Fi raruni fi indawani wunu mwanji ti ka hinga ya wu anambwa, ");
INSERT INTO kwj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Apa kapi hima fisi hinde hinga nu wosino? Fini sumbu kwambu foti fi wosiwani Jerusalem ko pe hima hinga tinda o sumbu wu hambwasinda. Apa nundo hinde nu yani kumbwa. ");
INSERT INTO kwj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Apa o mwanji ete dawa ele mendi nambwe hima leki o ichiꞌuchakonda. O keke apa fini ni kwambu tiki ya nu sawekonda. Wowa apa fini hima fweleni Jisas hi ki fi ai sawe hinga.” ");
INSERT INTO kwj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wosini wu uchawani fi ai tawani kwambu tiki ya fini sawe, “Apa do Jisas hi ki ai saweni ele hima ni o hi ki ondiyakandiya kei.” ");
INSERT INTO kwj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ete wowani Pita hima pi Jon mwanji wasa ti ka hinga ya wunu fi sawe, “Wo Gotri mwanji si hanjaꞌaisini kui mwanji tini si mendini si sirina kiꞌi? O sumbu hinga ti Gotri miyaningisopo tiki kipeꞌe? Kunjenga ma ku hambwanehei. ");
INSERT INTO kwj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sini apa hinde si gaina kumbwa. Sini si heiwani ele ri wosindaro sumbu ti, e, ri bwawani si mendindaro mwanji ti ete si bwandano.” ");
INSERT INTO kwj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ete wowani ele hiꞌucha hima mwanji kwambu foti wu ai autangini fini wu sawesini wu hanjaꞌaiwani ya fi i. Wunu ele himiyama hurahama keke wu akindaro. Ele himiyama hurahama wunu Gotri hi tini ya wu rasainda, Gotri ka sumbu hinga ni wosiro ti keke. Wosiwani ele hiꞌucha hima laka nomo fini hano numbo ti wu simiyafuro. ");
INSERT INTO kwj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ka Gotri kwambu ki fi okulawani kipe ri wosiro hima ori, ri daro asama rihi ti 40 hinga. ");
INSERT INTO kwj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kanisol hima fini wu hanjaꞌaisiwani fi hima tipa le tambwa fi ini ele puris hima i apukolaka lenga ele mekupu lenga fini bwaro tini tinda ete ya wunu fi sawenda. ");
INSERT INTO kwj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wowani o mwanji wu mendisini sembe funda wu hambwandau tinga Gotri ni hapa tinga ka hinga ya wu uchahambwa, “Apukolaka, mindo niri tinga nuwe tinga mi wosini, Soluwara ti okwe mi wosini, e, mwaꞌambwe hinga tinda dele ki dau ti mi wosiro. ");
INSERT INTO kwj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Imbihumbwa mi Himamwale kipe ti mi himache ri, nui metele, Defit, ri takisopo tiki mwanji fori ka hinga Sam chengi ki mi sawero. Himamwale kipe mihi ti ete sawe, ‘Hinde wowani ele hima kupu ba fwele sembe enge wu andau? Hinde wowani ele hima hinga kapwa inaka wu hambwandau? ");
INSERT INTO kwj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ele nuwe laka kipe king apukolaka le wunu au keke wu saini wu ini ele kanisol hima ga Apukolaka ri tau ra kinani uchasiro hi ti, Kurais, ni wu rakai kinani ya wu wauꞌi wauta.” ’ ");
INSERT INTO kwj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Mwe naha, Herot hima pi Pondiyas Pailat ga ele hima kupu ba fwelenga Isurel hima kupu le okwe wunu funda wu wausini Jisas hi tini ya wu sawesiyaꞌai. Rini mi tau ra himache kipe naha mihi, imbihumbwa ka mi ondiyasi to. ");
INSERT INTO kwj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wunu wu wauro ti ka sumbu imbihumbwa mi inakahambwa ni mi woni kwambu tiki mi ondiyasiro tini wundo wu wosiro. ");
INSERT INTO kwj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apukolaka, apa ma hambwanehei to, dele aki mwanji wu bwandau ti. Wosini nunu mi tau ra himache mihi le ma nunu okula. Wosiwa nunu nu aki hinga kwambu tiki mi mwanji ti nu bwa. ");
INSERT INTO kwj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wosini mi tapa ti ele hahungondau hima leni mi torowa kipe sa wu wosisini Jisas mi tau ra hima kipe naha hi rihi tiki sumbu kwambu miyafo ti sa sira.” ");
INSERT INTO kwj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","O hinga wu uchahambwani humbuwani, o aka wu wausiro ti ete ya raꞌichiꞌucha. Ete wokowani Gotri Himamwale kipe ti wunu talesiwani Gotri mwanji ti ya wu bwa. Wunu wu aki nambwe mwanji ti au laka hapa tinga wu uchani ya wu bwanda. ");
INSERT INTO kwj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wunu ele sembe ha himako wunu inaka funda ya wu hambwanda. Hima fori ri mwaꞌambwe ti ri heini ete ri sawe nambwe, “Dohaꞌa mwaꞌambwe ahi naha.” Mina. Ele mwaꞌambwe wuhi funda ete wuhi tumbwa. ");
INSERT INTO kwj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ele Jisas himache wunu ai sairo Jisas hi numbwa wu sawendau ti, kwambu tinga ya inda. Wowani Gotri hima keke wono sumbu ti omwesika naha ki ya wunu ri rawaka. ");
INSERT INTO kwj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wui nindo tiki daro hima forito a keke mwaꞌambwe keke ri heifu nambwe. Wunu fwele nuwe chele, aka chele. Wosini ele biya hima fweleki ya wungwa wu jindaro. Wosini o wungwa wu jiro ya ti wu ai ratani ");
INSERT INTO kwj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ele Jisas himache lei mu tiki wu owesiwani wunu ga ele heifundau hima leni ya wu ai haꞌi hata. ");
INSERT INTO kwj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Hima fori wui nindo riki daro hima, ri hi ti Josep. Wowani ele Jisas himache lenga hi foti Banapas ya rini wu uchasi. O hi mwanji mu mwe ti ka hinga: “Hima i sembe tini okulandau.” Rini Lifai hima kupu fo, Saipuras kipe hima. ");
INSERT INTO kwj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Rindo nuwe tipa rihi foti ya wungwa hima foringa ya ri ji. Wosini o ya ete ri ra ra ele Jisas himache le tambwa ri ratani wui mu tiki ya ri andosi. ");
INSERT INTO kwj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hima fori o da, hi rihi ti, Ananaiyas. Humwe rihi, hi tihi ti, Sapaira. Ananaiyas hima foringa ri nuwe tipa fotini ya wungwa ya ri ji. ");
INSERT INTO kwj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wosini ri humwe ga fi anambwasini o ri tororo ya tipa ti finje ya fi torosi. O hinga fi wosini Ananaiyas ya tipa tunumbwa ri raꞌaini Jisas himache mu tiki ya ri owe. ");
INSERT INTO kwj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wowani Pita ya sawe, “Ananaiyas, hinde wowani Saiten mi sembe ki talesiwani Gotri Himamwale ni mi gambondau? Hinde wowani o nuwe ki mi tororo ya tipa ti mi yanisindau? ");
INSERT INTO kwj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Imbihumbwa do nuwe tipa ni wungwa mi ji nambwe dawani o mi nuwe tipa tumbwa. Apa wungwa mi jisini mi raro ya ti tinda mihi tumbwa. Hinde hinga mi wono, o mi inaka. Woro, hinde wowani do sumbu mi inaka ki mi hambwaro? Mini hima ni mi gambonda nambwe, mina, do Gotri ni mi gambosindau.” ");
INSERT INTO kwj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wowani Ananaiyas o mwanji ni ri mendikoni ri raini ete ya ri ha. Ete wowani ele hima o mwanji ni wu mendikoni aki omwesika laka ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wowani hima wapa fwele wu tani hima dinga rihi nikaꞌari tiki wu injisini wu kichani wu raꞌaini ya wu eini si. ");
INSERT INTO kwj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ete wowani kamindache hinga dani ikowani ri humwe Sapaira ya ti sira. Tini o sumbu siraro ti hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wowani Pita ya tini sawe, “Do ya nuwe kihi chikini kini haro ya tinda ki rataroꞌo?” Wowani ya ti sawe, “Ei, tinda si rataro.” ");
INSERT INTO kwj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ete wowani Pita ya ai tini sawe, “Hinde wani mwanji funda ki bwani ki mendisini Apukolaka ri Himamwale kipe tini ki simiyaneheindau? Ma mendi, ni hurache ni eini siro hima le tani lengenumbo takai ki ele kwai eninda. Apa o nini kichani wu raꞌaikonda.” ");
INSERT INTO kwj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ete wowani metengei ete Pita seke mu tiki ti raini ete ya ti ha. Wowani ele hima wapa wu sirani wu heiwani o humwe haro. Ete wowani wu kichani wu raꞌaini ti hurache takai ki tini ya wu eini si. ");
INSERT INTO kwj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wowani ele lotu wondau himako ga ele hima fwelenga o mwanji wu mendikoni wunu tinda ete aki ti omwesika naha ki ya wu aki. ");
INSERT INTO kwj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ele Jisas himache ba fo ba fo sumbu kwambu hinga le miyafo naha ele himiyama hurahama nindo tiki ete wu wondaro. Wosiwani ele sembe haro hima le sembe funda naha wu dani imbihumbwa Solomon kiro tapa aka tiki funda ete ya wu waunda. ");
INSERT INTO kwj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ete wondawani ele hima fwele wu akindani ele sembe ha himako ga wu wau nambwe. Woroti ele sembe ha himako i wui hi tini ya wu rasainda. ");
INSERT INTO kwj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","O hinga wondawani ele himiyama hurahama miyafo naha Apukolaka ni sembe ti wu hani ele sembe ha himako ga ya funda wu inda. ");
INSERT INTO kwj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wondani ele Jisas himache wosiro sumbu kwambu wu heisini himiyama hurahama miyafo hahungo hima leni wu kichani hoko tokwe wu rasirani numbo tiki owesiro ba fo ba fo tei tenge tiki ya wunu andosinda. Wunu wui inaka ti hahungo hima walefo naha heifuni ka hinga ya wu hambwa, “Apa Pita ri tani ri tapa nunu funda funda ri torosini kipe hinde ri wosi kumbwa. Minambwe nawa nika sa rini yewa himamwale rihi tito nui tenge ki iwa sa nunu kipe wosi.” ");
INSERT INTO kwj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wondawani Jerusalem ko laka takai kipe hima le okwe ele wui hahungo hima le, himamwale kapwa wosiwani walambe indau hima le wu ra ra wu tani funda ya wu wau. Wosiwani ele hahungo hima hinga tinda ete kipe ya ai wunu wosi. ");
INSERT INTO kwj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wosiwani puris hima i apukolaka ringa rini ga tau funda randau hima tipa le, Satiyusi hima tiya ga, wunu sembe amwaka laka ti Jisas himache leni ya wu mendi. ");
INSERT INTO kwj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wosini wu saini Jisas himache leni wu toroni ele kapwa hima ga kalapus laka tiki ya wunu rawaru. ");
INSERT INTO kwj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wosiwani Apukolaka i ensel fo niliki tani lengenumbo tukwasini Jisas himache leni hoko tokwe ya wunu ri rasira. Wosini ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kunu ma ini Gotri aka laka we tiki ma ku rarusini ele himiyama hurahama ni himamwale ako torono mwanji tini ma ku sawe.” ");
INSERT INTO kwj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wowani ele Jisas himache o tini wu mendini nurumbumbwa Gotri aka laka tokwe ya wu i. Wosini Gotri mwanji tini ele hima ni ya wu bwanda. Wondawani ele puris hima i apukolaka lenga wui hima tipa lenga wu wausini kanisol hima lenga Isurel hima kupu wui mekupu ga wunu uchawani wu tani ya funda wu wau. Wosini ele kalapus aulindau himako ni mwanji ya wu raꞌai, ele Jisas himache leni wu rata kinani. ");
INSERT INTO kwj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wowani apungwandai kichandau hima le o mwanji raꞌai kinani kalapus aka tokwe ya wu i. Wu ini wu heiwani Jisas himache le da numbwa. Wowani wu ai wu ini mwanji ka hinga ya wu sawe, ");
INSERT INTO kwj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ka kalapus aka lengenumbo nu heiwani kwambu naha tiki dimisiro. Wosiwani aulindau hima le ele aka tipa lengenumbo hinga funda funda ete ya wu eninda. Wosiwani nunjenga ele aka tipa nu tukwasini nu heiwani hima fori kwai da nambwe.” ");
INSERT INTO kwj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wowani Gotri aka laka aulindau hima laka ori ga ele puris hima i apukolaka lenga o mwanji ni wu mendini inaka miyafo naha ya wu hambwa. Wokoni ya wu sawe, “Bwele sumbu hinga to sukwakondau?” ");
INSERT INTO kwj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wosiwani hima fori sirani ya wunu sawe, “Ma mendi, ele kalapus aka ki ku rawaruro hima le, apa Gotri aka laka we ki wu enindani himiyama hurahama leni Gotri mwanji tini ele kaka wu bwanda.” ");
INSERT INTO kwj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wowani Gotri aka laka aulindau hima laka ga ele ri tako tokwe dau himache lenga wunu toroni rata kinani ya wu i. Woroti wu ini wunu ye nambwe, mina. Wunu ele himiyama hurahama keke wu akindaro. Wofunu wunjenga ya wu hambwa, “Foki dele himiyama hurahama humokuto humbweni nunu yeno.” ");
INSERT INTO kwj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wosini fini wu ratani kanisol hima lei mwakambe tiki ya fini wu esi. Esisiwani puris hima i apukolaka ri ya wunu sawe, ");
INSERT INTO kwj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nunu mwanji kwambu tiki kunu nu sawero to sa, ka hi ni apa ele himiyama hurahama ni ai ku saweno keke. Woroti, do Jerusalem ko laka hinga o kui mwanji tombwa ini talesindau. Ete wosini kunu nunu ni ku sawendau, ori hima nundo nu yero nani.” ");
INSERT INTO kwj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wowani Pita ga ele Jisas himache lenga mwanji wasa ya wunu sawe, “Nunu Gotri mwanji ni nu sirinandau sumbu to sa mwase. Nunu hima i mwanji tunumbwa nu sirina hinga. ");
INSERT INTO kwj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kundo Jisas ni me yapweke tiki rini ku yewani ri haro. Wosiwani nui atei Gotri to rini ai rasairo. ");
INSERT INTO kwj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wosiwani Gotri rini rakauni ri tapa mama tiki rini lisisinda. O keke rini apa nunu ni numbo ri mekusini nunu raꞌaindau hima. Nunu Isurel hima kupu leto kapwa sumbu nuhi gumwa nu sisini rini ni sembe nu hawa, kapwa sumbu nuhi ti ri rani ri humbwekonda. ");
INSERT INTO kwj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nunu ele sumbu nu heisinimbwa mwanji nu bwandau. Wondawani Gotri Himamwale kipe okwe nunu ga dani o hingambwa o bwanda. Gotri mwanji ni sirinandau himiyama hurahama leni Himamwale kipe rihi ti wunu ri handau.” ");
INSERT INTO kwj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wowani o mwanji ni wu mendini sembe wuhi enge ya wunu a, Jisas himache leni wu yewa ha ki. ");
INSERT INTO kwj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ete wosini kanisol hima forito ya ri eti. Rini Farisi hima fori, ri hi ti Gameliyel. Rini Gotri lo mwanji tini ondiyakandiyandau hima. Wosiwani ele himiyama hurahama ri hi tini wu rasaindau. Woro o hima to etisini ya wunu sawe, “Ma wunu sawewa sa wu raruni biya hinga wu ini sa wu eninda.” ");
INSERT INTO kwj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ete wosini ele kanisol hima fweleni ya ri sawe, “Kunu Isurel hima kupu le, kunu dele hima ni sumbu fo ku wosi kinawa kunu hambwafwaꞌaisitoni. ");
INSERT INTO kwj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kunu ku hambwandau, injelembwa hinga Tiutas ri saini ete ri sawero ti, ‘Ani hi chele hima laka.’ Wosiwani 400 hima hinga rini ni sirinandaro. Ete wowani gapiman au anaye himako rini yewani ya ri ha. Wowani rini ni sirinandaro hima le wu akini wu ichiꞌuchawani o tau ete humburo. ");
INSERT INTO kwj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wosiwanumbwa dani ini gapiman ele himiyama hurahama ni hi wuhi ti kaindawani, Galili pe Jutas ori hima to himiyama hurahama fwele wui inaka tini ya ri rasai, wowa rini ga wu ini ele gapiman hima lenga wu anayeni wunu humbwewa wu i ki. O hinga ri wowani rini wu yewani ya ri ha. Wowani sembe rini ni handaro hima le wu akini ya wu ichiꞌucha. ");
INSERT INTO kwj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Woroti o hinga keke kunu a sawendau, kunu dele hima ma wunu hanjaꞌaisiwa sa wu da. E, wui inaka ki do tau wu randau nawa apaꞌichai o humbukonda. ");
INSERT INTO kwj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","E, Gotri ki siraro tau nawa apa hinde wunu ku ichaki kumbwa. Foki Gotri ga o ku anayekonda.” ");
INSERT INTO kwj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ete wowani Gameliyel mwanji tini ya wu sirina. Wosini Jisas himache ele ni wu uchawani wu tawani ya wunu yemwakuto. Ete wosini mwanji kwambu ki ya wunu sawe, “Apa Jisas hi tini ku bwa kei.” O hinga wunu bwasini wunu hanjaꞌaiwani ya wu i. ");
INSERT INTO kwj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wowani Jisas himache le kanisol aka wu andosini hoko tokwe ya wu raru. Wosini ya wu eripe, hinde wowani, Jisas hi keke huruhumba sumbu wunu ki sukwaro. ");
INSERT INTO kwj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wosini ele gisi hinga Gotri aka laka ki, e, himiyama hurahama lei aka tiki ya wunu ondiyakandiyanda. Wondani ya wu sawenda, Jisas rini Kurais, Gotri ri tau ra kinani humbwero hima. ");
INSERT INTO kwj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka gisi ki Gotri ni sembe haro himako miyafo naha ya sira. Wosini Girik mwanji ki bwandau sembe haro hima fweleto Hipuru mwanji ki bwandau sembe haro hima fweleni sembe nomo hinga ya wu hambwa. Wosini ya wu sawe, “Ele gisi laka hinga kunu ele ahirahi heifundau himiyama hurahama numbwa ku yakwandani, nui nindo ki dau himanguto le kipe ku yakwanda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","O hinga wu bwawani ele tapaꞌangi tapaꞌangi hatachi fisi Jisas himache le ele Gotri ni sembe haro himako ni wu uchawani ya wu ta. Wowani ya wu sawe, “E, Gotri mwanji ti nu hanjaꞌaisini ahirahi tini nu humwasino ti o hinga kipe mina. ");
INSERT INTO kwj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","O sumbu hinga ti nawa, nui hiparakambwe le, kunu tapaꞌangi hatachi fisi hima fwele kui nindo tiki ma ku wakinehei. Ele himiyama hurahama miyaningisopo ki sumbu kipe wosindau hima le, Gotri Himamwale kipe raini talesiwani hambwa kipe hambwandau hima leni ma ku esi. Wosiwa ele hima apa do tau ki wunu nu esisiwa sa wu aulindani sa wu randa. ");
INSERT INTO kwj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wowa nunjenga Gotri ni nu uchahambwandani ri mwanji ti nu bwanda.” ");
INSERT INTO kwj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wowani ele himiyama hurahama wunu o mwanji ni ya wu ohouna. Wosini Sitifen ni ya wu esi, rini sembe rihi ti Gotri ni kwambu naha ri haro hima. Wosiwani Gotri Himamwale kipe ti rini ki talesindau. Rini wu esini, Filip wu esini, Porokoras, Naikena, Taimon, Pamenas, Nikolas ya wu esi. Nikolas, rini Andiok ko pe hima. Imbihumbwa rini Juta hima kupu lei sumbu tini torosiro hima. ");
INSERT INTO kwj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wosini Jisas himache lei miyaningisopo ki dele hima ni wu esisiwani Gotri ni wu uchahambwasini tapa wuhi ti ya wunu owe. ");
INSERT INTO kwj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ete wosiwani Gotri mwanji ya ichiꞌucha. Ete wowani hima miyafo naha wu mendini Jerusalem ko tiki Gotri ni wui sembe ti ya wu ha. Ete wowani puris hima fwele okwe sembe wuhi ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gotri Sitifen keke ri wondani kwambu rini hasiwani rini ba fo ba fo sumbu kwambu ti ele himiyama hurahama nindo tiki ya ri wosinda. ");
INSERT INTO kwj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ete wowani hima fwele wu saini mwanji ti Sitifen ga ya wu anambwa anambwa. Hima mwe le wunu Juta hima kupu lei lotu wo sumbu fotini wu sirinandau. Wu lotu wondau aka mwe hi ete wu sawendau, Lalaunasindau Hima. Hima mwe le wunu Sairini, Alekisandiriya, Silisiya, e, Esiya kipe. ");
INSERT INTO kwj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ete wowani Gotri Himamwale kipe ti Sitifen ni hambwa kipe naha ti rini hasiwani ele hima ri mwanji ti wu diki ki heifuro. ");
INSERT INTO kwj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wofunu mwanji gambo foti hima fweleni yanini wu sawesiwani ele hima wu ini ya wu gambo, “Nunu nu mendiwani rini Gotri ga Moses ga ri saweholiyaro.” ");
INSERT INTO kwj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ete wu bwakoni ele himiyama hurahama i sembe ti wu rasaini, ele mekupu, e, ele Gotri lo mwanji hambwandau hima lei sembe ya wu rasai. Ete wokoni wu ini Sitifen ni wu toroni kanisol hima tambwa ya wu raꞌai. ");
INSERT INTO kwj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wosini ele mwanji rini gambono hima fwele wu esisiwani ya wu sawe, “Gisi gisi dori hima Moses kaisiro Gotri lo mwanji ga Gotri aka laka ga ri saweholiyandau. ");
INSERT INTO kwj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nu mendiwani ete ri sawe, Nasaret pe Jisas to do Gotri aka laka lendosini Moses nunu haro lo mwanji ti ri humbusini sumbu anandi ri ai ri oweno.” ");
INSERT INTO kwj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ete wowani ele kanisol hima wu linindaro ti, Sitifen ni miya kwambu tiki rini misini wu heiwani ri miyaningisopo ti Gotri ensel hinga naha. ");
INSERT INTO kwj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ete wowani puris hima lei wui apukolaka ya ri sawe, “Ka mwanji mwe nahaꞌa?” ");
INSERT INTO kwj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ete wowani Sitifen ga mwanji wasa ya ri sawe, “Ai hiparakambwe lenga ai yapai hima ga, ma ku mendi. Imbihumbwa nui metele, Epuraham, Haran mapwa tokwe ri i nambwe dani rini Mesopotemiya ki ete ri daro. Woro o gisi ki lindana ga dau Gotri rini tambwa ya sika. ");
INSERT INTO kwj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wosini ya rini sawe, ‘Mini do mi nuwe ga mi hiparakambwe lenga ma andosini ma saini nuwe tipa fo mini a mekusino tokwe i.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Wowani Epuraham ri saini Kalatiya lei nuwe ti ri hanjaꞌaisini ri ini Haran ki ya ri liti. Wondawani ri yapai hasiwanimbwa Gotri rini ai sawewani ri tani apa do ku linindau nuwe tiki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Woroti, Gotri Epuraham ni nuwe tipache foti rihi naha waꞌai kinani rini ha nambwe, mina. Woroti, Epuraham rini che nambwe ri daro gisi tiki Gotri mwanji ka hinga funda bwani mendiro: Ani Gotri do nuwe mini ani hasiwa mi anitafenita le ichai o torosikonda. ");
INSERT INTO kwj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wosini Gotri ka hinga ai sawero: ‘Mi anitafenita le do nuwe hanjaꞌaisini hima kupu ba fwelei nuwe ki wu dano. Wowa mi anitafenita ele wui tau ra himache hinga wu sirawa tau kwambu ti 400 asama hinga o wunu hakonda. ");
INSERT INTO kwj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wosiwa ichai ele himiyama hurahama o wunu a kotimwokonda, mi anitafenita leni amwaka omwesika tinga kapwa tau tinga wunu haro ti keke. Wosiwambwa mi anitafenita le o nuwe wu hanjaꞌaisini wu tani hi ahi ti dohaꞌa nuwe ki wu rasaindano.’ Gotri o hinga ri sawero. ");
INSERT INTO kwj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wosini Epuraham ri hima tape kupu ri kuto kinani Gotri rini sawero ti, ka hima i tape kupu kutondau sumbu ti Gotri funda bwani mendiro mwanji ichai mwe naha sirakonda. Wosiwanumbwa dani Epuraham Aisak ni ri rasiwani gisi ti tapaꞌangi hatachi namili iwani o hima tape kupu ya ri kuto. Wosiwani Aisak ga Jekop ni ya ri ra. Wowani Jekop ga kale tapaꞌangi tapaꞌangi hatachi fisi che leni ya ri ra. Woroti wunu apa Isurel hima kupu lei wui metele. ");
INSERT INTO kwj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kale nui metele wunu wui hipache, Josep, ni sembe kapwa wu hambwaro. Wokoni ele hima kupu ba fwelenga ya wungwa ya rini wu ji. Wowani rini wu rani Isip ko laka tokwe ya rini raꞌai. Wondawani Gotri rini ga ete ya da. ");
INSERT INTO kwj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Gotri rini okulasiwani ele nomo rihi ete ya humbu. Wosini Gotri hambwa kipe naha rini handawani Isip pe king apukolaka ga mwanji ti ri bwandawani king apukolaka rini keke ya wonda. O keke Isip leni torosino hima hinga, e, king apukolaka aka pe mwaꞌambwe aulindano hima hinga ya rini esisi. ");
INSERT INTO kwj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Da hinga woni Isip ko ga Kenan ko ga iche laka wunu hawani nomo laka ya wu randa. Ete wondawani nui metele ahirahi hinde hinga apa wu wakino? Ahirahi wuhi tinda humburo. ");
INSERT INTO kwj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wondawani Jekop mwanji ya ri mendi, ahirahi Isip ko ki dawani. Wowani ri che leni metengei naha ya ri humbwe. ");
INSERT INTO kwj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dani ini gumwa ki wu ai iwani Josep ri hiparakambwe leni ya ri sawe, ‘Ani Josep.’ O hinga ri sawewani Isip ko kipe king apukolaka ya ri hambwa, ‘Dele Josep hima kupu.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ete wowani Josep mwanji ya ri humbwe, ri yapai Jekop rini tambwa ta ki. Wowani rini ga ele ri hima kupu lenga wu saini ya wu i. Wunu tinda ete 75. ");
INSERT INTO kwj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Wu ini Isip ko ki ya wu raru. Wosini Jekop o ki ri dani ya ri ha. Wowani ri che le okwe ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ete wowani hima tape dinga wuhi ti wunu kichani Sekem wa we ki wunu si kinani ya wu raꞌai. O matimat imbihumbwa Epuraham Sekem ko ki Hamo i che lenga ya wungwa ri jiro nuwe tipa ki dau. Woro o ki ya wunu eini si. ");
INSERT INTO kwj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","“Dani ini Gotri imbihumbwa Epuraham ni mwanji funda bwani mendiro o mwanji mwe naha sirano gisi takai tandawani Isurel hima kupu le hima miyafo naha wu sirasini Isip ko ki ya wu da. Dani ini hima anandi fori king apukolaka Isip ko tiki ya ri eti. Woro rindo Josep ni ri hikisandau. ");
INSERT INTO kwj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rini kapwa inaka ri hambwasini nui metele leni tau kwambu ri hawani ele nui metele amwaka miyafo ya wu mendi. Wowani mwanji kwambu tiki ya ri sawe, ele wui che hoko tiki wu hanjaꞌaisiwa wu ha kinani. ");
INSERT INTO kwj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","O gisi ki Moses ri nuwai ya rini ra. Rini che kipe naha, Gotri rini keke wondau. Wowani nuwai yapai rihi aka we tiki rini enepesiwani nika namili ya i. ");
INSERT INTO kwj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wosiwani dani inumbwa hoko tiki rini andosiwani, king apukolaka i himiyama che tindo rini heini raꞌaini ti che hinga ya rini enependa. ");
INSERT INTO kwj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wondawani Moses Isip ko ki dau hambwa kipe hinga tinda ete ri hambwasini mwanji ri bwandau ti, e, tau rihi ti okwe, rini hima kwambu naha ya ri sira. ");
INSERT INTO kwj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Wosini Moses asama rihi ti 40 hinga isiwani ri hiparakambwe, Isurel hima kupu leni ri okula kinani ri i ki ya ri hambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Gisi foki ri ini ri heiwani Isip fori Isurel hima kupu forini walambe naha ya rini wosinda. Wowani o hinga ri heifuni o Isurel hima kupu ni ri okulani rini yero wasa keke Isip hima o rini ri yeni dinga ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wosini ya ri hambwa, foki ri hima kupu le ka hinga wu hambwano, Gotri to Moses tapa ki o nunu okulakonda. Woro, wunu o hinga wu hambwa nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wowani gisi fonga ai iwani Moses heiwani ri hima kupu fisi ya fi anayenda. Wondawani ri ini au fihi tini ri toro kinani ya fini ri sawe, ‘Ei, kini hiparakambwe, hinde wowani kinjenga walambe ki wondau?’ ");
INSERT INTO kwj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ete wokowani ri hiparakambwe ni walambe wosindau ori forito Moses tapa ti ri yetupwani ya ri ai ri humbwe. Wosini ya ri sawe, ‘Namoto ete mini sawe, mini ahaꞌa ki nui apukolaka, koti mendindau hima hinga mi dano? ");
INSERT INTO kwj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Woro mini ani ni mi ye kiꞌi, injele Isip pe hima forini mi yero hinga?’ ");
INSERT INTO kwj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","O hinga ri sawewani Moses akini ya ri i. Ri ini Mitiyan le nuwe tiki hima kicha hinga ri dasini humwe ti ri hopweni hurahama che fisi ya ri wosi. ");
INSERT INTO kwj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wosini dani ini asama ti 40 iwani Gotri ensel hima da nambwe michi ki Moses mu tiki ya ri sika, Sainai hi uchandau kimba takai ki. Wosini o ensel meche foki hi saindawani o hi nindo ki ya ri eninda. ");
INSERT INTO kwj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wowani Moses o sumbu sukwaro tini ri heisini inaka miyafo ya ri hambwanda. Wosini takai ri hei kinani ri iwani Apukolaka ya rini sawe, ");
INSERT INTO kwj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ani mi atei hima i Gotri. Ani Epuraham, Aisak, e, Jekop hima i Gotri.’ Wowani Moses rikirikinani ri heino tini ya ri aki. ");
INSERT INTO kwj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ete wowani Apukolaka ya rini sawe, ‘Seke mihi ki dau su ti ma dango. O michi mi enindau nuwe ti kipe naha, hinde wowani ani Gotri to a dau. ");
INSERT INTO kwj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ai himiyama hurahama leni Isip ko ki ele kapwa sumbu wunu wosiwani wui ichaka ti a mendiro. Apa wunu ni ani okulani nomo wuhi a rani a humbwe kinani a sikaro. O keke mini ma saini Isip ko tokwe mini a humbwewa i.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses mwe ri, imbihumbwa wunu ri mwanji ti wu yetupwasini ete wu sawero hima, ‘Namoto mini sawesiwani apa mini nunu ni mi aulini koti nuhi mi mendindau?’ Woro ori hima to Gotri rini humbwewani rini wunu ai ratano hima hinga wunu aulino hima hinga ya ri i. Gotri tau rini ondiyasiro ti ensel foni ri humbwewani ka meche foki hi hinga saindawani sikani Moses ni Gotri mwanji ri sawero. ");
INSERT INTO kwj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wosiwani 40 asama hinga Moses wunu rani raꞌai raꞌai ba fo ba fo sumbu kwambu ti Isip ko ki, ka Fwa Naro ki, e, hima da nambwe nuwe tiki ri wosindaro. ");
INSERT INTO kwj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","O Moses tombwa Isurel hima kupu leni sawe, ‘Apaꞌichai Gotri kui hiparakambwe forini ani hinga ri mwanji bwarakarano hima hinga o ri esikonda.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wosiwani dani inumbwa hima da nambwe nuwe ki wu wausini ori Moses tombwa wunu ga ete ya ri da. Wosini ka mwanji rini sawero ensel ga nui metele lenga Sainai kimba ki ya ri da. Ri dasini Gotri mwanji ti ya ri toro. Mwanji mwe ti, tini himamwale tinga dau. Wosini nunu ni ri haro. ");
INSERT INTO kwj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Wosiwani nui metele le wunu o mwanji ni wu mendi nambwe. Mina. Wunu ya rini wu yetupwa. Wosini sembe okokona wuhi ti Isip ko tini ya wu ai hambwa. ");
INSERT INTO kwj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wokoni Eron ni ya wu sawe, ‘Mini nui inakahambwa gotri fo ma nunu wosisiwa, rindo sa ri mwaseni nui apukolaka hinga sa ri i. Ka Isip ko tiki nu dawani nunu rataro Moses rini soriki ri isindau? Nunu nu hikisandau.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ka gisi ki mwaꞌambwe kipe naha ki bulumakau che hinga ya wu wosi. Wosisini o nimba gambo gotri ni omwe wu yesini ya wu handa. Wosini o wui tapa tiki wu wosiro mwaꞌambwe tini ya wu eripenda. ");
INSERT INTO kwj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ete wowani wui sumbu keke Gotri ga gumwa wunu ri sisini wunu ri hanjaꞌaisiwani wunu nikahako tini, isangi tini, tapwaki nika tini, e, ele mwaꞌambwe hinga tini wu uchahambwani ya wu lotu wonda, Gotri mwanji bwarakarandaro himako i chengi tiki sawero hingambwa: ‘Kunu Isurel hima kupu, imbihumbwa kunu hima da nambwe nuwe tiki 40 asama hinga ku daro. Wosini bulumakau ti ku yendani sipisip ti ku yendani ku handaro ti, o sumbu hinga ani ni ku wosindaroꞌo? Minambwe naha! ");
INSERT INTO kwj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kunu kui gotri Molok keke nikaꞌari ba kiro akache ti ku kisini ku kicha kicha ratani, e, isangi hinga ni ku wosiro kui gotri, Refani, ni ete ku kichani ya ku rata. Delehaꞌa mwaꞌambwe kui tapa tiki ku wosiro ti kunu o tini ku lotu wo ki ku wondau. O hinga ti keke apa kunu a rani Bapilon mapwa tokwe kunu a humbwesiwa ku dano.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Imbihumbwa nui melokoꞌatei hima wunu hima da nambwe nuwe tiki wu dasini o gisi ki wunu nikaꞌari ba kiro aka tiki wu lotu wondaro. O aka wu kiro ti Gotri wunu ga dau tini wu heini wu hambwa kinani. O nikaꞌari ba wu kiro lotu wondau aka ti Gotri to Moses ni ri mekusiwani ri heiro himamwale hingambwa tini wu ai wosiro. ");
INSERT INTO kwj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wosiwanumbwa nui atei hima wunu o sumbu hinga tini ete wu ra ra wu ta tawani Josuwa ga wu raruni hima ba fwelei nuwe ti keke wu yeni wu ginasini o nuwe wu tororo. O gisi ki o nikaꞌari ba kiro lotu wondau aka wu ratasini dohaꞌa nuwe ki wu owesiwani ete da dawani Defit siraro gisi ya sukwa. ");
INSERT INTO kwj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wosiwani Gotri ri inaka ti Defit ni ri hasiwani Defit ri metele, Jekop, lotu wondaro Gotri keke aka foti ri ki kinani Gotri ni ya ri uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Woro rindo ri ki nambwe, ri che Solomon to aka ti Gotri keke ya ri kisi. ");
INSERT INTO kwj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Woroti, kari kau hewen ki dau Gotri rini hima to kindau aka tiki hinde ri da kumbwa. Ri mwanji bwarakarandaro hima kari to sawero hinga: ");
INSERT INTO kwj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Apukolaka ete sawero, Niri oti a linindau tei. E, nuwe ti seke a yitindau. Bwele aka hinga tini ani keke ku kisiwa a litini a himatino? ");
INSERT INTO kwj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ai tapa tiki dele mwaꞌambwe hinga tinda ete a wosiro.’ ");
INSERT INTO kwj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kunu Gotri ni sawesiyaꞌai hima tiya. Kunu kui sembe ti emendiki naha, Gotri ni hikisasini dau hinga. Kui wasamba ti kitisindau. Gisi gisi kunu Gotri Himamwale kipe ni ku yetupwandau, kui atei metele wosindaro sumbu hingambwa. ");
INSERT INTO kwj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gotri kui melokoꞌatei hima tambwa ele ri mwanji bwarakarandaro hima ni ri humbwewani wunu forini kapwa sumbu wu wosi nambweꞌe? Mina, wunu tinda ete kapwa sumbu wunu wu wosiro. Wunu ori hima kipe naha to tano mwanji tini bwandaro hima leni wu yeni wu sindaro. Wosiwani apa kunu ga ele rini omwemendindau hima lei tapa tenge tiki rini ku hasiwani ya rini wu yeni wu si. ");
INSERT INTO kwj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kunu Gotri lo mwanji ensel to sawehambwaro tini ku torosini o tini ku sirina nambwe.” Sitifen o hinga ya ri sawe. ");
INSERT INTO kwj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wowani ele kanisol hima o mwanji wu mendiwani wui sembe ni yewani amwaka naha. Ete wowani fu wuhi ti wu tanginginani Sitifen ni sembe enge ya wu a. ");
INSERT INTO kwj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wowani Sitifen Gotri Himamwale kipe rini talesindau ki niri tiki ya ri mau. Ri mauni lindanasini dau ko ti ri heini Gotri tapa mama tokwe enindau Jisas ni ya ri hei. ");
INSERT INTO kwj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wosini Sitifen ya sawe, “Ma ku mendi. Ani a mauni ani heiwani niri ti tukwasiwani Hima ri Che Gotri tapa mama tokwe enininda.” ");
INSERT INTO kwj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","O hinga ti ri bwawani wu mendikoni ata ti au laka wu gindani wasamba wuhi ti ya wu yekiti. Ete wokoni wu saini wu namani wu ini Sitifen ni ya wu toro. ");
INSERT INTO kwj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wosini o ko laka hoko tokwe rini rawarasini humokuto ti ya rini wu ekehenda. Ele metengei rini kotimwondaro hima leto siyoti wuhi wu hungosini hima wapa fori mu tiki ya wu owesi, hi rihi ti Sol. ");
INSERT INTO kwj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wosini wunu Sitifen ni humokuto tiki wu ekeheni ya fiya rini wu yenda. Wondawani Sitifen Apukolaka ni ka hinga ya ri uchahambwa, “Apukolaka Jisas, mini ai himamwale ti ma rakau.” ");
INSERT INTO kwj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ete ri bwakoni tatumbu ti ri ombungwesini au laka uchani ya ri sawe, “Apukolaka, mini apa do kapwa sumbu wasa ai wunu wosi kei.” Sitifen o hinga ri bwakoni ya fiya ri ha. ");
INSERT INTO kwj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sitifen ni wu ye kinani wu bwandaro mwanji ti Sol o tini ohounandaro. Sitifen ni yero gisi kumbwa Jerusalem pe sios hima leni walambe sumbu naha wunu wosino sumbu ti ete ya sira. O hinga wowani Jisas ni sembe haro hima ele akini Jutiya, Sameriya mapwa tokwe ya wu i. Wondawani Jisas himache letombwa Jerusalem ko tiki ete ya wu da. ");
INSERT INTO kwj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wosiwani ele Gotri sumbu mwe tini sirinandau hima fweleto Sitifen ni wu raꞌaini rini eini sisini rini keke moko wu andani ichaka omwesika naha ya wu ichakanda. ");
INSERT INTO kwj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ete wondawani Sol ele sios hima leni walambe sumbu ya ri wosinda. Ele aka ele aka ri raruni himiyama ga hurahama ga ri toroni raꞌaini kalapus wondau aka tiki ya wunu ri rawaru. ");
INSERT INTO kwj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","O hinga wosiwani Jisas ni sembe haro hima le akini ele ko ele ko wu isini Gotri mwanji ti ya wu bwanda. ");
INSERT INTO kwj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Wondawani Filip Sameriya mapwa tokwe dau ko laka fotiki ri ini Jisas rini Kurais, Gotri ri tau ra kinani humbwero hima, o mwanji ni ya ete wunu ri bwanda. ");
INSERT INTO kwj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ete wondawani ele himiyama hurahama miyafo Filip ni wu heiwani, ele Gotri wosindau ba fo ba fo sumbu leni ri wosindawani wasamba wuhi ti wu owesini ri mwanji tini ya wu mendinda. ");
INSERT INTO kwj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wondawani ele himiyama hurahama fwele himamwale kapwa wunu ga daro ti, ata laka gini wunu andosini ya i. Wondani talihapa dinga ba hima fwelenga seke kapwa hima fwelenga o ki kipe ya wunu ai ri wosi. ");
INSERT INTO kwj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Wosiwani ele himiyama hurahama eripeꞌaripe omwesika naha tiki o ko laka ki ya wu eripenda. ");
INSERT INTO kwj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","O ko laka ki hima fori ya da, hi rihi ti Saimon. Imbihumbwa ete ta tani apa okwe rini ele saya wosi, e, humwe wapi wosindau mwaꞌambwe ri wondawani ele Sameriya pe himiyama hurahama le inaka miyafo naha ki wu hambwandawani rini ka hinga ri sawendau, “Ani hima apukolaka.” ");
INSERT INTO kwj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wowani ele hi chele himiyama hurahama lenga, hi nambwe hima le okwe wunu tinda ete inaka tenge tiki rini wu hambwandani ya wu sawe, “Dori hima ka, Omwesika, hi tini uchandau Gotri kwambu tini torosindau.” ");
INSERT INTO kwj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ele himiyama hurahama au wunu saini Saimon sumbu tini wu hei kinani ete wu dau. Hinde wowani ori hima to gisi miyafo naha ele ba fo ba fo sumbu hinga le ri wondawani inaka miyafo ete wu hambwandaro. ");
INSERT INTO kwj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Da hinga woni Filip Gotri kwambu wunu aulino mwanji kipe tinga Jisas Kurais hi tinga ya wunu ri sawe. Wosiwani ele himiyama hurahama miyafo sembe hawani uku ti ya wunu yasi. ");
INSERT INTO kwj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon okwe sembe ri hani uku ti rini yasiwani Filip ga funda ya ri da. Wondawani Filip ba fo ba fo sumbu ri wosindawani ri heindani inaka miyafo ya ri hambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ete wondawani Jisas himache le Jerusalem ko ki wu dani wu mendiwani Sameriya pe hima le Gotri mwanji ya wu toro. O hinga wu mendini Pita hima pi Jon ni wu humbwewani wunu tambwa ya fi i. ");
INSERT INTO kwj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Fi ini fi raini Gotri ni ya fi uchahambwa, Gotri wunu okulawa Gotri Himamwale kipe wu toro ki. ");
INSERT INTO kwj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Hinde wowani Gotri Himamwale kipe wunu ki sika nambwe. Jisas hi tiki uku tini nimba wunu yasiro. ");
INSERT INTO kwj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wosiwani apambwa tapa fihi tape tenge wuhi ki owewanimbwa Gotri Himamwale kipe ya wunu rai. ");
INSERT INTO kwj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ete wowani Saimon Jisas himache pini ri heiwani tapa fihi tape tenge wuhi ki wunu owewani Gotri Himamwale kipe ya wunu rai. Wowani ya rihi ti fini tambwa ri ratasini ya ri sawe, ");
INSERT INTO kwj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Kapi che, kindo ki torosindau kwambu fo ma ki ani ha. Wosiwa hima foi tape tenge ki tapa ahi ti ani owewa Gotri Himamwale kipe sa rini rai.” ");
INSERT INTO kwj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ete wowani Pita ya rini sawe, “Gotri ni ya mihi ti mi hawa Gotri mini okulawa tapa mihi hima i tape tenge ki mi owewa Himamwale kipe o hima ki raino hinga mi hambwandauꞌu? Minambwe naha. O hinga mi hambwandau nawa ya mihi ga mini ga walambe ete mini i sindau. ");
INSERT INTO kwj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gotri tau si randau hingambwa hinde apa mi ra kumbwa. Minambwe naha. Sembe mihi ti Gotri miyaningisopo ki chikinda nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","O hinga keke kapwa sumbu mihi gumwa ma sisini Gotri Apukolaka ni ma uchahambwanehei, sembe mihi ki dau kapwa inaka o tini ri rani ri humbweno umo. ");
INSERT INTO kwj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mini ani heiwani sembe mihi ti si tau ni mi okokonandani sembe amwaka laka mi andau. Wondani mini chikinda nambwe kapwa sumbu to mini ichakisindau.” ");
INSERT INTO kwj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ete wowani Saimon mwanji wasa ka hinga ya ri sawe, “Gotri Apukolaka ni ma ki uchawa sa ri ani okula. Wosiwa ele sumbu ki ani sawero ti apa ani ki ai sira hinga.” ");
INSERT INTO kwj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ete wowani Jisas himache pi ele himiyama hurahama ni Gotri Apukolaka i mwanji tini ya fi bwarakaranda. Fi bwasini dani inimbwa Jerusalem ko tokwe ya fi ai i. Numbo fi indani Sameriya mapwa ki dau ele ko ele ko hima leni Gotri mwanji kipe tini fi bwa bwa ya fi inda. ");
INSERT INTO kwj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wosiwani Apukolaka ri ensel Filip ni ya ri sawe, “Mini ma saini ini Jerusalem ko hanjaꞌaisini Gasa ko tokwe raindau numbo mapwa tokwe ma raru.” Do numbo indau mapwa hima nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ete wowani Filip saini ya ri i. O numbo ki ri ini Itiyopiya pe hima fori ya ri hei. Ori hima Itiyopiya pe kwini humwe apukolaka, hi ti Kandesi, ti tako tokwe dau hima laka. Rini Kandesi ya mwaꞌambwe hinga rindombwa aulindau. Ori hima Jerusalem ko ki taro, Gotri ni lotu wo ki. ");
INSERT INTO kwj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wosini Gotri ni lotu woni ri humbusini apa numbo ki ya ri ai inda. Hosi longondau kari rihi tiki ri litisini Gotri mwanji bwarakarandaro hima Aisaiya kairo chengi ni ri hambwa hambwa ya ri inda. ");
INSERT INTO kwj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wondawani Gotri Himamwale kipe Filip ni ya sawe, “Mini ma ini ka biya hosi longondau kari tinga takaini i.” ");
INSERT INTO kwj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ete wowani Filip namani takai ri ini ri mendiwani ori hima Gotri mwanji bwarakarandaro hima Aisaiya chengi tini ya ri hambwanda. Wondawani Filip ya rini sawe, “Do mwanji mu mwe mi hambwasini mi hambwandauꞌu, mina?” ");
INSERT INTO kwj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wowani ori hima ga mwanji wasa ka hinga ya rini sawe, “E, hima fori numbo ani meku nambwe nawa, apa bweleni ani hambwano?” Wosini Filip ni ya ri sawe, “Mini ma sukwani ani ga liti.” ");
INSERT INTO kwj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","O hima hambwandaro Gotri mwanji tipa foriki ka hinga sawe: “Sipisip hinga ya rini wu rata, rini wu yewa ri ha kinani. Sipisip che sembi wu kutowani ata ginda nambwe hinga kari hima o hinga takisopo rihi hauna nambwe. ");
INSERT INTO kwj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hi rihi wu rakaisini norukweni rini wu koti wo nambwe. Hima fori ri anitafenita lei mwanji ni hinde apa ri sawe kumbwa. Hinde wowani, rini wu yewani himamwale rihi do nuwe andosini iro.” ");
INSERT INTO kwj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wowani ori hima Filip ni ya ri sawe, “Ani mini a silindau. Gotri mwanji bwarakarandaro hima ori namoni sawesiwani ka mwanji hinga ni ri bwaro? Rinjenga ri bwaroꞌo, hima forini ri bwaro?” ");
INSERT INTO kwj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ete wowani Filip takisopo haunani Aisaiya ri chengi ki kairo Gotri mwanji o tini ri bwandani Jisas ni wosiro sumbu tini ya rini sawekawenda. ");
INSERT INTO kwj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wondani o numbo fi i ini fwatoroche foti ya fi hei. Fi heini kwini apukolaka tako tokwe dau ori hima laka to ya ri sawe, “Ma hei, fwa o bai da. Bwele sumbu to ani ichakisiwani uku mi ani yasi nambwe a dau?”  ");
INSERT INTO kwj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wowani Filip ya rini sawe, “E, sembe mihi ti mwe naha mi hawambwa o sumbu hinga ti mi wono.” Wowani rini ga ya ai rini sawe, “Ani Jisas Kurais Gotri Che ni sembe ani haro.” ");
INSERT INTO kwj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","O hinga fi anambwakoni ori hima hosi longondau kari ni ri sawewani ya eti. Wosiwani Filip ga ori hima laka ga fwa tokwe ya fi rai. Fi raini Filip ori hima ni uku ya ri yasi. ");
INSERT INTO kwj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wosini fwa oti fi andosini fi sukwani fi etikowani metengei ba ete Apukolaka ri Himamwale sikani Filip ni ya raꞌai. Wowani ori hima Filip ni ai hei nambwe. Wofunu ri kipehekini ri ikondau numbo ki ya ri i. ");
INSERT INTO kwj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wondawani Filip Asitot ko tiki ya ri sukwa. Wosini ele ko laka hinga tinda ete Gotri mwanji ti ya ri bwanda. O hinga ri wo wo Sisariya ko tokwe ya ri ai i. ");
INSERT INTO kwj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wondawani Sol rini ele Gotri ni sembe haro hima leni ri yeni ri si kinani mwanji kwambu tiki ri bwandani puris hima i apukolaka tambwa ya ri i. ");
INSERT INTO kwj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ri ini ri sawewani ori hima chengi fori Damasukas kipe Juta hima kupu lei lotu wondau aka fweleni aulindau hima leni ya ri kaisinda. Wosini o ri kairo chengi Sol ni ya ri ha. Chengi mwe ti ka hinga ri kairo: “E, dori hima Sol himiyama hurahama fweleni heiwa wunu do sembe ha numbo hinga tini ete wu sirinandawa, wunu ri toroni kalapus tiki wunu ri owesini sa wunu ri ra ra Jerusalem ko tokwe sa wunu rata.” ");
INSERT INTO kwj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wosiwani Sol ya ri i. Ri ini Damasukas ko ti ri takaindawani hewen kipe hi hinga ti okuni lepakinakoni miyaningisopo rihi tini ya oku. ");
INSERT INTO kwj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wowani Sol nuwe tiki ri raini ri tukuyandani ri mendiwani tumwa foti ka hinga ya sawe, “Sol, Sol, hinde wowani walambe sumbu mi ani wosindau?” ");
INSERT INTO kwj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ete wowani Sol ga mwanji wasa ya ri sawe, “Apukolaka, mini hinde na hima?” Ete wowani ya ri sawe, “Ani Jisas, ka walambe sumbu ete mi ani wosindau. ");
INSERT INTO kwj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Woroti apa ma saini ko laka tokwe ma ini raruni mi dawambwa hima forito ri tani mi rano tau ti o mini ri sawekonda.” ");
INSERT INTO kwj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wondawani Sol ga wu iro hima ele mwanji nambwe ya wu eninda. Wunu o bwandau mwanji ni wu mendindani hima mwe ri wu hei kinani ya wu wakitekinda. ");
INSERT INTO kwj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Wosiwani Sol ri saini miya ti ri ripasini ri hei kinani, mina. Miya rihi halinja naha. Wowani ele rini ga wu iro hima leto tapa tiki rini wu toro toro wu ini Damasukas ko ti ya wu raru. ");
INSERT INTO kwj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wosini gisi namili ri heinda nambwe ri dani a nambwe uku sumbwe nambwe ya ri da. ");
INSERT INTO kwj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wondawani Jisas ni sirinandau hima fori rini o Damasukas ko kumbwa ya ri da. Hi rihi ti Ananaiyas. Rini tukuyaneheisini ri heindau hinga mwaꞌambwe fo amwei ri heiwani Apukolaka to ya rini sawe, “Ananaiyas.” Ete wowani ri huwesini ya ri sawe, “Apukolaka, ani do a da.” ");
INSERT INTO kwj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ete wowani Apukolaka ya rini sawe, “Mini ma saini do numbo, hi ti Dachikina, uchandau tiki i. Mi ini Jutas aka tiki Tasas ko pe hima fori o ri da. Ma rini hei, hi rihi ti Sol. Gotri ni ori kaka uchahambwanda. ");
INSERT INTO kwj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ori hima okwe tukuyaneheindau hinga mwaꞌambwe fo amwei ri heiwani hima fori, ri hi ti Ananaiyas, rini tambwa tani tapa rihi ti ri mwa tenge tiki ya ri owe, kipe rini wosiwa ri ai maꞌaikaꞌai kinani.” Apukolaka o hinga ya ri sawe. ");
INSERT INTO kwj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ete wowani Ananaiyas ga mwanji wasa ka hinga ya rini sawe, “Apukolaka ani a mendiwani hima fwele ete wu sawendaro, rini mini ni sembe haro hima fweleni Jerusalem ko tiki kapwa sumbu wunu ri wosindaro hima. ");
INSERT INTO kwj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ri tororo kwambu ti puris himako i wui apukolaka leki ri tororo. Ri tororo kwambu ti rini mini ni wu lotu woni mini ni wu uchahambwandau hima leni ri toroni kalapus tiki owe kinani.” ");
INSERT INTO kwj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","O hinga ri bwawani Apukolaka ka hinga ya ri sawe, “Mini ma saini ete i. Kari hima, Sol, rini ai tau ra himache. Rini ani ondiyasiro tau rihi ti, rini hi ahi tini ri rani ele hima ba fwele tambwa, king apukolaka le tambwa, e, Isurel hima kupu le tambwa ri raꞌichiꞌuchandano. ");
INSERT INTO kwj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ani rini a mekusiwa tau ahi ri randawa nomo tinga amwaka tinga ete rini ki sirandawa rini mwanji ahi tini ri bwani ri indano.” ");
INSERT INTO kwj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ete wowani Ananaiyas ri ini o aka ki ri raruni ri tapa ti Sol tenge tiki ri owesini ya ri sawe, “Ai apwai Sol, Jisas Apukolaka to mini tambwa numbo tiki ri sikaro. Wosini rindombwa dori ani humbwewani mini tambwa a tasinda, miya mihi ti mi ai ripasiwa Gotri Himamwale kipe ti apa mini ki tale kinani.” ");
INSERT INTO kwj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ete wowani Sol miya ki ichakisiro mwaꞌambwe ti fese ari hinga tito metengei naha dungwani ya sika. Wosiwani ri maꞌaikaꞌaindau tinga ri saini ri iwani uku ti ya rini yasi. ");
INSERT INTO kwj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wosiwanumbwa Sol ahirahi ti ri ani tape rihi ti ya yakina. Wosini gisi fwele Sol Jisas ni sirinandau hima lenga Damasukas ko tiki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wosini metengei naha ri saini Jisas hi tini Damasukas ko tiki dau ele Juta hima kupu lei lotu wondau aka hinga tinda ri ini ya ri sawe, “Dorihaꞌa Jisas rini Gotri Che minde naha.” ");
INSERT INTO kwj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ete wowani ele hima ri mwanji o tini wu mendindau tinga wu apapanani ya wu sawe, “Dori hima rini ka ri sawendau Jisas hi tini ele himiyama hurahama Jerusalem ko tiki wu uchahambwandawani walambe sumbu wunu ri wosindaro. Wosini apa do ki ri taro ti, ele sembe haro himiyama hurahama ni ri toroni kalapus tiki ri owesini wunu ra ra puris himako i apukolaka le tambwa wunu raꞌai ki ri taro.” ");
INSERT INTO kwj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Woroti Sol ri mwanji ti ri bwandau ti, kwambu naha ki sirawani ele Damasukas ki dau Juta hima kupu fwele ri mwanji tini wu mendikoni wu apapanani mwanji wasa wu bwa nambwe. Hinde wowani, Sol mwe naha ya wunu sawekawe, “Jisas rindombwa Kurais.” ");
INSERT INTO kwj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Dani gisi miyafo iwani Juta hima kupu le Sol ni wu yeni wu si kinani mwanji ti funda wu bwani ya wu mendi. ");
INSERT INTO kwj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ete wowani Sol o wui mwanji ni ya ri mendi. Wunu ele hima niliki tapwaki ko laka kipe lengenumbo leni ya wu aulinda, ri iwa rini wu yeni si kinani. ");
INSERT INTO kwj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ete wondawani ele ri himache ele to niliki tiki o humokuto ini ki rini rakausini hala laka fotiki rini wu warosini hoko tokwe ya rini wu rawai. ");
INSERT INTO kwj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wosiwani Jerusalem ko tokwe ri ini Jisas ni sirinandau hima lenga funda wu wau ki ri iwani wunu rini ni ya wu aki. Wunu ete wu hambwaro, rini Jisas ni sirinandau hima, mina. ");
INSERT INTO kwj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ete wowani Banapas to Sol ni ra ra Jisas himache le tambwa ya rini raꞌai. Wosini Sol to Apukolaka ni numbo tiki ri heiwani Apukolaka to mwanji ti rini sawekawero sumbu o ni ya wunu ri sawe. Wosini Banapas tombwa Sol Damasukas ko tiki ri etisini Jisas hi ti au laka ri sawendaro tini ya wunu ri ai sawenda. ");
INSERT INTO kwj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wosiwanumbwa Sol Jerusalem ko tiki ri dani wui nindo tiki ya funda wu ichiꞌuchanda. Wondani Apukolaka i hi ti au laka ri bwandani ri akitiwo ti nambwe ya ri da. ");
INSERT INTO kwj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wosini rini ele Juta hima kupu Girik mwanji wu bwandau lenga ya wu anambwa anambwanda. Wondawani wunu rini wu yeno numbo tini ya wu wakinda. ");
INSERT INTO kwj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dani inumbwa, ele ri hiparakambwe wu mendifuni Sisariya ko tokwe rini wu rakaisini Tasas ko tokwe ya rini humbwewani ya ri i. ");
INSERT INTO kwj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ete wowanumbwa Jutiya pe, Galili pe, Sameriya pe, sembe ha himako kipe tumbwa ya wu da. Wui nindo tiki mwanjiche fori wu anangiya nambwe. Wunu Apukolaka i tako tokwe wu dawani Gotri Himamwale kipe ti wui sembe ti wunu okulandawani himiyama hurahama miyafo tani sembe wuhi ti ya wu handa. ");
INSERT INTO kwj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ele mapwa hinga Gotri mwanji bwa ki ri isini Lita ko laka okwe ri raini Jisas ni sembe haro himiyama hurahama lenga o ko laka ki ya ri da. ");
INSERT INTO kwj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wosini o ko laka ki hima fori ya ri hei, hi rihi ti Iniyas. Talihapa rihi ti dinga ba. Wosini o siki keke tei tukumbwa ri tukuyandaro asama rihi ti tapaꞌangi hatachi namili. ");
INSERT INTO kwj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wosini Pita ya rini sawe, “Iniyas, Jisas Kurais rindo kipe o mini wosikonda. Mini ma saini tukuya topo mihi norukwe.” Ete wowani metengei ete ya ri sai. ");
INSERT INTO kwj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","O hinga ri wowani Lita ko pe hima ga Saron ko pe hima ga wunu tinda ete rini ni wu heikoni Apukolaka ni sembe ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa ko laka ki Jisas ni sirinandau humwe fo ya ti da, hi tihi ti Tapita. Girik mwanji tiki tini uchandau hi ti, Dokas. Tini gisi gisi mwaꞌambwe keke heifundau hima leni ti okulandani sumbu kipe tini ya ti wosinda. ");
INSERT INTO kwj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Woro gisi foki ti hahungoni ya ti ha. Wosiwani hima tape dinga tihi ti uku wu yasisini kiheiye aka tipa foki ya tini andosi. ");
INSERT INTO kwj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lita ko ti Jopa ko takai ki dau. Ete wowani Jisas ni sirinandau himako ya wu mendi, Pita Lita ko laka ki ri dawani. Wosini hima fisi wu humbwewani rini tambwa fi ini ka hinga ya rini fi sili, “Mini nunu tambwa ma tamata, apa anayiti kei.” ");
INSERT INTO kwj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ete wowani Pita saini fini ga funda ya wu i. Ri ini ri raruwani rini ra ra kiheiye aka tipa o ki ya rini rakau. Ele himanguto okwe wu tani Pita takai ki wu etisini ya wu ichakanda. Wu ichakandawani Dokas wunu keke ti wosiro kiheiye nikaꞌari ele ni ya rini wu mekusinda. ");
INSERT INTO kwj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wondawani Pita ele hima ni sawewani hoko tokwe ya wu sira. Wowani seke ri ombungwesini Gotri ni ya ri uchahambwa. Wosini miyaningisopo rihi ti o haro humwe tape tini ri hei hei ya ri sawe, “Tapita, nini ma sai.” Wowani o humwe miya ripani Pita ni ti heikoni ti saini ya ti liti. ");
INSERT INTO kwj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Wowani Pita tapa tihi ri toroni ri rasaiwani ya ti eti. Ete wowani Pita ele Jisas ni sembe haro hima lenga, e, ele himanguto ga ri uchawani wu tawani hasini sairo Dokas ni ya wunu ri ai ha. ");
INSERT INTO kwj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wosiwani o mwanji to Jopa ko laka ki ete ini ya raru. Wowani o ko kipe himiyama hurahama miyafo Apukolaka ni sembe ya wu ha. ");
INSERT INTO kwj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wosini Jopa mapwa ki Pita gisi miyafo naha ri daro. Rini bulumakau tupu ki mwaꞌambwe wosindau hima ga gisi miyafo ya ri da, hi rihi ti Saimon. ");
INSERT INTO kwj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ka Sisariya ko laka ki hima fori ya da, hi rihi ti Koniliyas. Rini 100 au anaye himako wui apukolaka. Kale au anaye himako ni wu uchandaro ti wunu Itali mapwa tokwe pe. ");
INSERT INTO kwj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Woroti rini Gotri ni lotu wondau hima. Ele ri aka ki funda wu dau hima hinga wunu Gotri ni akindau. Wosini ya mwaꞌambwe le Jutiya pe bwarichape hima le keke ri handau. O hinga ri wo wo rini Gotri ni ete ri uchahambwandau. ");
INSERT INTO kwj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dani ini gisi fo, nika rai amwa 3 kilok hinga iwani mwaꞌambwe foti tukuyaneheindau hinga amwei ya ri hei. Ri heiwani Gotri ensel rini tambwa raruni ya rini sawe, “Koniliyas.” ");
INSERT INTO kwj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wowani Koniliyas rini heini ya aki. Wosini ya rini sawe, “Hima laka, hinde?” Wowani ensel ga ai Koniliyas ni sawe, “Gotri ni mi uchahambwandaro ti o mini mendiro. Ele bwarichape himiyama hurahama leni mi okulandaro ti Gotri o tini ri heini ri eripenda. ");
INSERT INTO kwj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mini hima fwele ma humbwewa Jopa ko tokwe sa ini hima fori sa waki, hi rihi ti Saimon, e, hi rihi foti Pita. Wu ini sa apa rini ra ra ta. ");
INSERT INTO kwj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ori hima, ri hi tipa Saimon aka tiki o kwakwa da, rini bulumakau tupu ki mwaꞌambwe fwele wosindau. Aka rihi ti soluwara gamba tiki o da.” ");
INSERT INTO kwj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wosini ensel Koniliyas ni ri sawesini ya ri ai i. Wowani Koniliyas ri tau ra himache fisi ga ri tako tokwe dau au anaye hima foringa ya ri ucha. Ri tako tokwe dau hima ori rini Gotri ni akindani gisi gisi Koniliyas ga funda ete ri dau. ");
INSERT INTO kwj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wosini Koniliyas ele hima namili ni rini ki sukwaro sumbu ni kipe naha ri sawesini wunu ri humbwewani Jopa ko tokwe ya wu i. ");
INSERT INTO kwj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wu ini numbo tiki ya wu tukuya. Lindanawani wu ai ini ka Jopa ko laka ya wu takai. Wondawani ka gisi Pita Gotri ni uchahambwa kinani aka tuwo ki kau wosiro tei tenge tiki ri rauni ri heiwani nika ti gondi tiki ya da. ");
INSERT INTO kwj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Wowani Pita iche tinga rini hawani ahirahi ya ri a ki. Wondawani ahirahi ti ete wu otokunandawani mwaꞌambwe foti tukuyaneheindau hinga rini ki ya sira. ");
INSERT INTO kwj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wowani ri heiwani niri ti tukwasiwani nikaꞌari omwesika laka hinga tito ya sira. Mwaꞌambwe mwe ti sumbu opuriꞌopuri torosini hanjaꞌaiwani nuwe tokwe ya sikanda. ");
INSERT INTO kwj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ka mwaꞌambwe we ki kwai daro ti kale ba fo ba fo omwe le, hopo le, e, apwe le ete kwai daro. ");
INSERT INTO kwj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wowani tumwa fori Pita ni ka hinga ya sawe, “Pita, ma saini dele omwe yesini a.” ");
INSERT INTO kwj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ete wowani Pita ya sawe, “Apukolaka, ani apa ani a hinga. Ani mindo minambwe mi naro kapwa omwe leni ani anda nambwe.” ");
INSERT INTO kwj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wowani o tumwa numbo fisi ka hinga ya ai rini sawe, “Mwaꞌambwe ti Gotri to wosiro ti o kipe, dohaꞌa mwaꞌambwe mini apa kapwa na kei.” ");
INSERT INTO kwj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ka sumbu numbo namili ya ai sukwa. Ete wosini metengei o mwaꞌambwe niri tokwe ya ai rau. ");
INSERT INTO kwj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ete wowani Pita inaka walefo hambwandani ya sawe, “Do tuku hinga ani heiro mu naha ti, ka hinde hinga?” O hinga ete ri hambwandawani Koniliyas wunu humbwero kale hima namili ete ya wu raru. Wunu Saimon aka tini ele hima ni wu sili sili wu i ini lengenumbo rihi tiki wu raruni ya wu eti. ");
INSERT INTO kwj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wosini ka hinga ya wu sawe, “Saimon, hi rihi foti Pita, rini dohaꞌa ki dauꞌu, mina?” ");
INSERT INTO kwj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Wondawani Pita ka tuku hinga tini ete ri hambwandawani Gotri Himamwale kipe ti ya rini sawe, “Ma mendi, hima namili o mini wakinda. ");
INSERT INTO kwj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mini ma sai raini wunu ga ma i. Mini apa inaka walefo hambwa kei. Anjenga wunu a humbwewani wu taro.” ");
INSERT INTO kwj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wowani Pita ele hima tambwa raini ya ri sawe, “O ku wakini ku tandau hima ri, ani sa to. Bwele keke ku taro?” ");
INSERT INTO kwj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ete wowani ya wu sawe, “Koniliyas, rini 100 au anaye himako lei apukolaka, rindo nunu humbwewani nu taro. Rini hima kipe naha, Gotri ni ri akindau. Juta hima kupu le ete rini sawendau, Rini hima kipe naha. Gotri ensel forito ete rini sawero, mini ri sawewa mi ini aka rihi tiki