﻿USE sofia;
DROP TABLE IF EXISTS sofia.kwi_vpl;
CREATE TABLE kwi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kwi_vpl WRITE;
INSERT INTO kwi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristowa kwal an ñamin kwal uztuza wian kit ka munara: Davidpa kwalkas Abrahampa kwalkas. ");
INSERT INTO kwi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamne Isaacpa papihsh azi. Isaacne Jacobwa papihsh azi. Jacobne Judáwa papihsh azi. Uskas paiña aimpihshtuzpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáne Fareswakas Zarawakas papihsh azi. Tamarne uspawa akkuhsh azi. Faresne Esrompa papihsh azi. Esromne Arampa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramne Aminadabpa papihsh azi. Aminadabne Naasónpa papihsh azi. Naasónne Salmónpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónne Boozpa papihsh azi. Rahabne paiña akkuhsh azi. Boozne Obedpa papihsh azi. Rutne paiña akkuhsh azi. Obedne Isaíwa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíne katsa ɨninmika Davidpa papihsh azi. Katsa ɨninmika Davidne Salomónpa papihsh azi. Usne Uríaspa ashampara mɨlta. Uríaspa ashampane Salomónpa akkuhsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónne Roboampa papihsh azi. Roboamne Abíaspa papihsh azi. Abíasne Asawa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asane Josafatpa papihsh azi. Josafatne Jorampa papihsh azi. Joramne Uzíaspa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasne Jotampa papihsh azi. Jotamne Acazpa papihsh azi. Acazne Ezequíaspa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasne Manaséspa papihsh azi. Manasésne Amónpa papihsh azi. Amónne Josíaspa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasne Jeconíaspakas paiña aimpihshtuzpakas papihsh azi. Sun payukin Babilonia suras awane Judío awaruza piznat kit uspawa surakima kal kin mɨlnara. ");
INSERT INTO kwi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sun kitpane, Jeconíasne Salatielpa papihsh azi. Salatielne Zorobabelpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelne Abiudpa papihsh azi. Abiudne Eliaquimpa papihsh azi. Eliaquimne Azorpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorne Sodocpa papihsh azi. Sodocne Aquimpa papihsh azi. Aquimne Eliudpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudne Eleazarpa papihsh azi. Eleazarne Matánpa papihsh azi. Matánne Jacobpa papihsh azi. ");
INSERT INTO kwi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobne Joséwa papihsh azi. Joséne Maríawa ampu azi. Maríane Jesúspa akkuhsh azi. Jesúsne, Mesíaskas, Dios nɨrɨtmikakas, muntɨt. ");
INSERT INTO kwi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sunkanain catorce kwaltuzne Abramtas Davidtakima uzat kit ka munara. Davidtas Babilonia awa Judío awaruza piznat kit mɨlnarakima, mamaz catorce kwaltuzne uzara. Sun payuras mamaz catorce kwaltuzne uzara, Dios nɨrɨtmika kawinakima. ");
INSERT INTO kwi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sunkana Jesucristone kawirɨt. Paiña akkuhshne Josékasa kasara kin namtɨt, pareju uztachasmin. Pareju uztachasmin, usne pɨja wa wanmalta, Dios Sɨnam Izpul akwa. Dios Sɨnam Izpulne Maríara winta, sun pashpa mɨlnapa. ");
INSERT INTO kwi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joséne, paiña ampune, uskasa kasara kin namtɨt. Wat awa azi. Mane María pɨja warɨt mɨrawane, usne sun awa iztakin Maríara kwaimtus kainanashitchi. Usne Maríara puintain kwaishimtu, awa piankamamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sun mintuasmin, pitmɨzta. José kainkizpamtuasmin, Anpatpa ángelne Joséra ka kaizta: —Mɨza. Nune Davidpa kwal i. Nune Maríara mɨlna ishkumun, up ashampa namnapa. Maríane sun painkul mɨjanpai, Sɨnam Izpul akwa. ");
INSERT INTO kwi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Usne maza painkul mɨjanpai. Nune ussa Jesús munnaka. Awa ussa Jesús munaanazi, Judío awaruza watsat mɨlnamtu akwa, kwail kiamanpa, ka kizta. ");
INSERT INTO kwi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sunkana kirɨt, wan awa Anpat kaizta aizpa nɨjkulanapa. Dios kainammmikane ka kaizta: ");
INSERT INTO kwi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nimpihsh ashampane pɨja wanazi. Usne maza painkul mɨjanazi. Uspane ussa Emanuel munanazi.” (Sun mun kizkane, “au Diosne aukasa uztu” kizmuspas.) ");
INSERT INTO kwi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kainkizpamtu izkultawane, Joséne Anpatpa ángel ɨninta aizpa kit kit Maríara mɨlta, paiña ashampakana. ");
INSERT INTO kwi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Uspane pareju pitpailtachi, pashpa mɨlnakima. Pashpa mɨlkane, Joséne ussa Jesús munta. ");
INSERT INTO kwi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús Belén pɨpulukin kawimɨzkane, Herodesne Judea sura mikwa azi. Sun payu wat piantuzne, pãn puzmumans attuzne, katsa Jerusalén pɨpulura piannara. Kɨma izat akwa, uspane anza wat piankamara. ");
INSERT INTO kwi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Uspane ka mɨmaara: —¿Mɨntama sun pashpa mɨlta? Usne Judío awaruza ɨninnanazi. ¿Mɨntama tui? Aune paiña kɨma pãn puzmukin izanash. Sun akwa aune apain aanash, ussa wakpuj wainñana. ");
INSERT INTO kwi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Katsa mikwa Herodeskas wan Jerusalén pɨpulukin uztuzkas sun mɨat kit ishkuara. ");
INSERT INTO kwi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Suasne Herodesne wan pariya ɨnintuzakas Moisés kaizta aizpa kamtamtuzakas akwanara, Cristo mɨnta kawishina kiz mɨmana. ");
INSERT INTO kwi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uspane ka kaizara: —Belén pɨpulukin, Judea sukin kawinazi. Sunkanain Dios kainammmikane ka parɨt: ");
INSERT INTO kwi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belén pɨpulune Judea sukin ainki pɨpulu i. Akkwan awa an ainki pɨpulukin uzamtuchikas, anza katsa mikwane sun pɨpulukin kawinazi, ap Judío awaruza kiwainanapa.” ");
INSERT INTO kwi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Suasne Herodesne kɨma iztaruza puintain akwanat kit ka mɨmanara: —¿Chi payuma kɨma izanash? Mɨmarawane, usne kɨma kai izpanka piankamta. ");
INSERT INTO kwi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Suasne usparuza Belén pɨpulura ɨninnat kit ka kaiznara: —Ta ɨat kit an pashpa sairain. Ussa wanmaltawane, apain kail kit nawa kainanaka, nakas ussa wakpuj wainna, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mikwa kaizta aizpa mɨarawane, kɨma izmuruzne ɨamɨzta. Paiña suras puztachasmin, pashpa tura ɨarachasmin, uspane sun kɨmara pãn puzmukin ñamin izarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kɨma iztuasmin, uspane kwisha wat minñat kit ");
INSERT INTO kwi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","yalta nappat kit pashparakas Maríarakas, paiña akkuhshta, izara. Suasne uspane pashpa tukin wakpuj wainñara. Kwiztane uspa kara aizpa azpiz kit urukas inciensokas mamaz mirra piamkas ukkat kit ussa mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kwiztane kɨmu izmuruz kainkizpamtuasmin, pittamtuasmin, Diosne usparuza kurunnara, Herodes tuwara kaiyamanpa. Suasne uspane uspa sura mamaz miwarain kaiyamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɨmu izmuruz kaiyarawane, Joséne kainkizpamtuazi. Anpatpa ángelne ussa izpan kit ka kaizta: “Kuhsakti. Nukas pashparakas paiña akkuhshtakas Egipto sura azain ɨrain. Sua nukkulti, na kaiznakima. Herodesne pashpara sainanpain, ussa piantana,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joséne kuhs kit pashparakas paiña akkuhshtakas munat kit amtawara pɨpulukis puzat kit Egipto surakima ɨara. ");
INSERT INTO kwi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Suain nukkulara, Herodes inakima. Egipto sura nukkultɨt akwa, uspane Anpatpa kainammmika kaizta aizpa kiarɨt. Sunkana kaizta: “Nane ap painkulta Egipto suras akwarau.” ");
INSERT INTO kwi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes wat pianturuz awa kaiyarachi piankamtawane, usne kwisha pilchapuzta, uspa ussa kutkwarɨt akwa. Suasne Herodesne wan ampu pashparuza, kuna asmin paas añokima, Belén pɨpulurakas kasharuzakas piantana ɨninnara. Sun kɨma izaruzne, sun wat piantuzne, “paas año pɨnnapain,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Suasne Jeremías kainammmikane parat aizpa sunkana kirɨt: ");
INSERT INTO kwi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Akkwan ashampa tɨnta azamtuasmin, wan ashampane Rama pɨpulukin mɨara. Wan Israel ashamparuzne azara, uspa painkul akwa. Uspa tayaltɨt akwa, mɨnminkas usparuza kiwainnasachi, uspa painkultuz iarɨt akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes irawane, Joséne kainkizpanmɨzta Egipto sura. Suasne Anpatpa ángelne ussa izpan kit ka kaizta: ");
INSERT INTO kwi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kuhs kit pashparakas paiña akkuhshtakas mɨl kit kail kit Israel surakima, pashpara piantashimtuz iarɨt akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Suasne Joséne kutpat kit pashparakas paiña akkuhshtakas mɨl kit Israel sura kaiyara. ");
INSERT INTO kwi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Arquelaone papihshkanain mikwa namɨz kit Judea sura ɨninmɨzta. Usne Herodespa painkul azi. Joséne Arquelaowa sun piankam kit Judea sura ɨn ishkwarɨt. Mamasa José kainkizpamtuasmin, Diosne ussa Galilea sura ɨnka kizta. Galilea sura pianatpane, usne Nazaret pɨpulura uzna ɨrɨt. Dios kainammmika parɨt aizpa sunkana kirɨt: “Awane ussa Nazaret pɨpulukis atmika mun munanazi”. ");
INSERT INTO kwi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sun payura Juanne, awaruza pikin munnammikane, Judea sura ɨrɨt. Awa sun pul sura ɨakane, Juanne usparuza Dios watsal pit kainanat ");
INSERT INTO kwi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kit kaiznara: “U kwail kiarɨt aizpa maiztain, ma Dios awaruza ɨninnashimtu akwa. Diosne awaruza us kaizta aizpa mɨanapa akwanamtu, au kwail kiamanpa.” ");
INSERT INTO kwi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ñamin Isaíasne, Dios kainammmikane, sunkana Juanpa parɨt: “Mɨnpazha pul sura awaruza tɨnta kwinta kinat kit ka kaiznanazi: ‘Uruzpain watsarain, Anpat kuruntu aizpa kianapa. Une Dios iztakin nil uzarawa,’ ” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa pĩn kwara aizpa camello ashkasa sɨpta. Aya tɨt pɨjakin kuhtɨt. Ittalkanakas mishkikas kwat. ");
INSERT INTO kwi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén pɨpuluras awakas wan Judea suras awakas wan Jordán pimakin uztuzkas puzat kit ussa mɨna aara. ");
INSERT INTO kwi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Uspane uspa kwail akwa tayalat kit uspa kwail kiarɨt aizpa kaizara, Dios usparuza wat kulninnanapa. Suasne Juanne usparuza Jordán pira munnanara. ");
INSERT INTO kwi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mɨnpazha Fariseo awaruza kanpamtuzkas mɨnpazha Saduceo awaruza kanpamtuzkas Juanta aara, usparuza munnanapa. Aakane, Juanne usparuza kaiznara: “¿Une apkin aamtumakkiwas? Une kain pɨrail kaizmuruzkana mai. U kamtakana mai, sula kumtu akwa. U pit kaizamtu aizpa kamta pininukana mai. Dios kwail kirɨttuza ilnamtu akwa, u kwail kiamtu aizpa chɨhkarain. ");
INSERT INTO kwi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dios uruza iltachasmin, u kwail kiarɨt aizpa maiztawa, wan awa u Diosta kaiyarɨt piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Une ‘aumin Abrahampa kwal makpas’ kizamtu. Sun minñamtu akwa, Diosne uruza sapnamanazi. Diosne sun katsa ukkasa Abrahampa kwal namninnashina. ");
INSERT INTO kwi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Diosne uruza ilnanapain. Mane une katsa tɨkanain izarɨt, pippa wakainkanain. Wan tɨ pippa wakainne, tɨt kit ĩnta kiain kit ĩn paktarawa. ");
INSERT INTO kwi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","U kwail kiarɨt aizpa Diosta kaizarawane, Dios uruza wat kulninnarawane, nane uruza watcha pira kwazikasa munna kinanash. Na uruza pira kwazikasa munnanamtukas, mamazne nakin anza tɨnta anazi, sun pitmin kainanapa. Na uruza pira kwazikasain munnanamtukana, usne paiña Sɨnam Izpulta ɨnninnazi, ukasa tuanpa, uruza kiwainanapa. Uskas kwail kimtuza ilnanazi. Usne wan awakin anza tɨnta mikwa namtɨt. Na uskana tɨnta chi akwa, nane paiña kiwainmikakana namtɨt ish, us kaizta aizpa kin. Us kwisha wat akwa, nane ussa wat kiwainnapa piankamsachish. ");
INSERT INTO kwi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Usne tɨkasa chara aya kihshkul kit tɨmkasa suninapain. Sunkanain usne awaruza kwail kiarɨt aizpa kiznanazi. Wat awaruzne wat chara pippakanain wanmaktat kit mamaz yalta watsanazi. Awa chara aya impaktamtukanain, Jesúsne kwail awaruza naizninnanazi. Sun ĩnne kwikain.” Sunkana Juanne Fariseo kampamtuzakas Saduceo kanpamtuzakas pilchashina. ");
INSERT INTO kwi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Suasne Jesúsne Galilea suras puz kit Jordán pirakima piannara, Juan ussa munnapa. ");
INSERT INTO kwi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan ussa munna kishitchi akwa, Juanne Jesústa ka kaizta: —Nune nawa munna kinatkin. Nu nakima amtukas, nane nua chinkas mɨlasachish, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesúsne ussa ka sɨnkara: —Mane nune nawa munna kinatpa, wan Dios aumɨza kaizta aizpa kinpa. Suasne Juanne ussa pikin munnara. ");
INSERT INTO kwi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan ussa kapal muntawane, Jesúsne piras puzta. Masain chiyu kai kultakane, Jesúsne Dios Izpulta izta. Sunne utkurukana chiyuras kihsh kit ussa taizta. ");
INSERT INTO kwi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Suasne awane Dios chiyuras kaizka mɨara. Dios ka kaizta: “Anne ap painkul i. Ussa pashimtus. Uskasa kwisha warish,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kwiztane Dios Izpulne Jesústa pul sura mɨlta, Satanás ussa kwail kininshit akwa, Dios ɨninta aizpa kimanpa. ");
INSERT INTO kwi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesúsne cuarenta payukima payuwarakas amtawarakas kwatchi. Kwiztane yak kimɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Suasne Diablone ustukin pianara. Ussa kwail kininshimtu akwa, ussa kaizta: —Nu “na Dios Painkul ish” kiztune, suasne an ukkasa pan sari, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesúsne ussa sɨnkara: —Diosne paiña pɨnkɨhta ka parɨt: “Awane kumirain kuat kit uzanazi. Kumira kwatkas, awane Dios pit para aizpa izarawa, an wat uzanapa.” ");
INSERT INTO kwi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Suasne Diablone Jesústa Diospa pɨpulura, Jerusalén pɨpulura, mɨl kit iglesia yal mitmal kunninta. ");
INSERT INTO kwi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Sua ussa kaizta: —Nune “na Dios Painkul ish” kizta. Katmizna akkis pɨlainti, awa nua izat kit nɨjkulanapa. Dios pɨnkɨhta ka parɨt: “Diosne paiña ángeltuza ɨninnanazi, nua kiwainanapa. Uspane uspa chihtɨkasa nua sappaanazi, mittɨ ukta kilmanpa.” ");
INSERT INTO kwi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesúsne sɨnkara: —Diosne pɨnkɨhtakas ka parɨt: “Up Anpat Diosta kwail kinpa kishininmun”. ");
INSERT INTO kwi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mamasa Diablone Jesústa katsa ɨnkal ɨzara mɨl kit chiwal watsal sura ussa anta. Ussa wan pãn sun suras iznintawane, ");
INSERT INTO kwi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Diablone ussa kaizta: —Nawa wakpuj waintane, nane nu iztu aizpa nua mɨlanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Suasne Jesúsne ussa kaizta: —Satanás, nu akkis ɨt. Dios pɨnkɨhta ka parɨt: “Anpat Diostain wakpuj waintawa, us kaizta aizpa kin. Mamazta wakpuj wainkain,” ka parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Suasne Satanásne Jesústas paimpa ɨrɨt. Sun urain ángeltuzne ussa kiwainñara. ");
INSERT INTO kwi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juanta kajchira sɨptɨt mɨrawane, Jesúsne Galilea sura kailta. ");
INSERT INTO kwi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret pɨpulukis puztawane, Jesúsne Capernaum pɨpulura uzna ɨrɨt. Sun pɨpulune pimamin uz. Sua Zabulón sukas Naftalí sukas kashain uz. ");
INSERT INTO kwi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Diosne sun kinintɨt. Isaíasne, Dios kainammimikane, ñamin ka pat kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón suras awakas Naftalí suras awakas Jordán pi kwakara, pãn puzmuras, uzamtu. Suane Judío awachiruzne Galilea pi kwakara uzamtu. ");
INSERT INTO kwi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Diosta pianchi akwa, uspane tɨlkwilkinkana uzara. Diosta piankamturuzne watsal kiarɨnazi, kaikinkana uzamtu akwa. Ñamin irɨt awakanain uzarakas, mane uspane kai kultɨt miwara chaamtu.” ");
INSERT INTO kwi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sun payuin Jesúsne kamtanamɨz kit kaiznara: “Ayukta maiztain, an kwail kiamanpa, Dios awaruza mamin ɨninnashimtu akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galilea pimamin chamtuasmin, Jesúsne paas aimpihshta izta. Mazane Simónkas Pedrokas muntɨt. Mamazne Andrés muntɨt. Uspane pishkaru pizmuruz azi. Uspa pira ɨmmu kiainpailmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Suasne Jesúsne usparuza kaiznara: —Kanpazhain, ap kammuruz namanapa. Ñamin pishkaruin pizpailta. Kawarain makis nane uruza ɨninnanash, mamaz awaruza kamtananapa, ap kammuruz namanapa. ");
INSERT INTO kwi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Masain uspane uspa ɨmmu chɨhkat kit ussa kanpailta, kamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ma pitchin ɨmtuasmin, Jesús mamaz paas aimpihshta izta. Uspane Santiagokas Juankas muntɨt. Uspane Zebedeowa painkul azi. Uspane paiña papihshkasa kanuara pishkaru sulmu putpailta. Jesúsne usparuza akwanara, uskasa wanmak kit ɨn. ");
INSERT INTO kwi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Masain uspane papihshta tuij ɨt kit kanuaras kihsh kit ussa kanpailta. ");
INSERT INTO kwi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesúsne wan Galilea suwara ɨmɨz kit wan Judío kammu yalta nap kit awara kamtanara. Usne Dios watsal pit kamtanara. Usne Dios awaruza ɨnnashimtu kamtanara. Wan inturuzakas wan ishturuzakas kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria sura uztuzkas Jesúspa piankamara. Uspane wan inturuzakas wan ishturuzakas wan naizaruzakas Jesúspakin karaara, Jesús usparuza kakulninnanapa. Saliz piztɨttuzakas ultu piztɨttuzakas chasachiruzakas ussa karaara, Jesús usparuza kakulninnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Akkwan Galilea suras awane Jesús ɨmtumal aara. Mɨnpazha Decápolis pɨpuluras awane aara. Mɨnpazha Jerusalén pɨpuluras awane aara. Mɨnpazha Judea suras awane aara. Jordán pi kwakaras awakas, pãn puzmumals, aara. ");
INSERT INTO kwi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Akkwan awa wanmakkarɨt iznarawane, Jesúsne ɨnkal ɨzara nut kit sua uzta. Paiña kammuruzne ussa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Usne paiña pit usparuza kamtanamɨz kit sunkana kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Diosta piankamshimturuzne Dios kaizta aizpa kiat kit watsal uzanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Awa tayalamtukas, Diosne usparuza wat kiwainanazi, tayalamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Na mamazkin an warish kiztuchimikane an watsal uznazi, Dios an sukin pa kin namta akwa. ");
INSERT INTO kwi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nil kishimturuzkas wat kishimturuzkas an watsal uzanazi, Dios pashimtu aizpa kiamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Diosne mamaztuza kiwainmuruza kiwainnanazi, watsal uzanapa. ");
INSERT INTO kwi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ayukta kaijchura sɨnam sarɨttuzne an watsal kulat kit Diosta izanazi. Dios ayukta kaijchura sɨnam saninnamtu akwa, uspane an wat kulat kit Diosta izanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Awaruza kalpain uzanapa paninturuzne kalpain uzanazi. Diosne usparuza ‘u ap pashparuz mai’ kiznanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Awa nil uztuzakas Dios kaizta aizpa kimtuzakas pizamtukas, awa usparuza kwail kiashimtukas, Diosne paiña ɨninturuza, paiña ɨnintukin watsal uzninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Une ap wat kanpamtuz mai. Mamaz awane na akwa ‘u kwail awa mai’ kizanazi. Awane na akwa uruza kwail kianazi. Uspane na akwa u kwail kiamtu pɨrail appanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sunkana uruza kinakane, watsal kiat kit watsal nɨjkultain. Diosne chiyura uruza watsal mɨlam mɨlananazi. Ñamin Dios kainammtuz uzasmin, awane kawarain usparuza naizninnara.” ");
INSERT INTO kwi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ñam ñara nɨrane, ña pɨtkain. Une ñamkanain wat uztain, awa an kwail kiamanpa. Wat ñam chine, ñara kulkain. Tɨhwi. Ñam kultachine, kiakpɨntɨm, awa mittɨ kuliztɨnpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Une au sukin wat uztain, mamaz awara watsal kamtananapa, watsal uzanapa. Une impil kai aiztukanain nil uzarawa, awa nil uzna piankamanapa. Pɨpulu malta uztane, wanne pɨpulura kai izanazi. Kulasachi. ");
INSERT INTO kwi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kawarain alampara puttane, tɨm ampal unanchi. Kancha alampara kwashta kantawa, wan awa tukin kai izanapa. ");
INSERT INTO kwi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kawarain une awa iztakin watsal uztain, awa u wat kiamtu aizpa izanapa. U wat kirɨt aizpa izarane, uspane u Taitta Dios chiyuras kwisha wari kizanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Une nawa nil minñamtuchi. Une Moisés kaizta aizpakas Dios kainammtuz kamtara aizpakas piankamamtu. Uspa kamtara aizpa kwaimanash. Nane apa arau, u wan Dios kaizta aizpa watcha piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nane watcha kaiznamtus. Aune chiyura iztumakpas. Aune an sura uztumakpas. Chiyukas an sukas azain pailsachi. Kawarain wan Dios ɨnintu aizpa pailmanazi. Paiña pitkas paiña kamtamkas pailmanazi, wan chiwal kinkima. ");
INSERT INTO kwi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Katmizna Dios ɨnintu aizpa kimtuchimikane, Dios ɨnintu aizpa kiman kamtamtumikane, Dios ɨnintukin katsa awakana nammanazi. Dios ɨnintu aizpa kimturuzkas mamaztuza sunkanain kinpa kamtamtuzkas, Dios ɨnintukin an katsa awakana namanazi. ");
INSERT INTO kwi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Uruza kainanamtus. Une Moisés kaizta aizpa kamtamtuzkinkas Fariseo awakinkas an watsal uzarawa. An watsal uzamtukine, une Dios ɨnintukin nappasachi.” ");
INSERT INTO kwi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Une ñamin uztuza kamtanara aizpa mɨara. Usparuza ka kiznara: ‘Mamazta piantaman. Mɨnpazhara piantarɨtmikane katsa mikwara kwail ilninna ɨtpa,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sunkana nain kaiznamtus: aimpihshkasa pilchapuztumikane mikwara ilninna ɨtpa. Mɨnpazha aimpihshta kwail pit parakane, katsa mikwara ilninna ɨtpa. Mɨnpazha aimpihshta nune ‘tɨmpa i’ kiztamikane ĩnta ɨrɨshina. ");
INSERT INTO kwi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sunkana kirain. Diosta chiwazha mɨlam mɨlamtuasmin, aimpihshta kwail kirɨt nɨjkulkane, up mɨlan mɨlkain. ");
INSERT INTO kwi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kancha up mɨlan mɨlamtukin tuij ɨtpa. An ñancha aimpihshkasa wat kultawa. Up aimpihshkasa wat kultawane, suasne kailtawane, up mɨlan Diosta mɨlatpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mɨnpazha nu kwail kirɨt kizkane, katsa mikwara ɨmtuasmin, nune azain nu kwail kirɨt kizmumikakasa nɨjkultawa, izmuruz namanapa. Katsa mikwane nua policíara ɨninshina, kajchira sɨpninna. ");
INSERT INTO kwi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Watcha kaiztus. Suain kajchiras puzsachi, nu wan pial tanakima.” ");
INSERT INTO kwi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Une ñamin uruza kamtara aizpa mɨara. Uruza ka kiznara: ‘Mamazpa ashampara sanachi,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sunkana nane uruza kaiznamtus. Mɨnpazha ashampara iztane, ashampara sashimtu mintane, usne me ashampara piz kit sarɨtkana uztu. ");
INSERT INTO kwi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mane nune kasu waj. Mɨnpazha kwail aizpa kin iztumikane sunpa kwail kin min kit kwail kishina. Chinkas kwail aizpa kin izman, kwail minmanpa, kwail kishimanpa. Kasukasa kwail izturuzkas kwail kishimturuzne ĩnta ianazi. Katmizna kwail aizpa kin izman, ĩnta ɨamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Awane chihtɨ waj. Awane uspa chihtɨkasa kwail kiashina. Chihtɨkasa kwail kishimtuzne maizarawa, uspa chihtɨkasa kwail kiamanpa. Paiña chihtɨkasa kwail kishimtumikane ĩnta ɨrɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Sunkas une ñamin uruza kamtara aizpa mɨara. Usparuza ka kiznara: ‘Mɨnpazha paiña ashampara kwairane, kwaina pɨnkɨh pat kit ussa chɨhkatpa,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Me nain mamaz tuntu uruza kurunnamtus. Mɨnpazha ashampa mamaz ampukasa pittachimikasha kwairane, usne ashampara kwail kinintu. An ashampane mamazkasa uztɨnazi. Mɨnpazha ashampa kwairɨtmikakasa kasara kimtune, uskas kwail kimtu.” ");
INSERT INTO kwi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Sunkas une ñamin uruza kamtara aizpa mɨara. Uruza ka kiznara: ‘U anpat iztakin sun kin namta aizpa maintachin kiarawa,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Me nain mamaz tuntu uruza kurunnamtus. Kwinta kimtuasmin, nil pit paraarawa. Kain pit kaizman. Chiwazha kin namtuasmin, chiyura nu kaizta aizpa mɨna akwanchi. Chiyura akwatne, nune Diosta akwantu, nu kaizta aizpa mɨnapa. ");
INSERT INTO kwi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Chiwazha kin namtuasmin, au sukin nu kaizta aizpa mɨna akwanchi. Sun au sura kaiztane, nune Diosta, paiña su ɨnintukin, akwantu. Jerusalén pɨpulura nu kaizta aizpa mɨna akwanchi. Jerusalén pɨpulura akwatne, Jerusalénpa katsa mikwasha nu kaizta aizpa mɨna akwantu. ");
INSERT INTO kwi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chiwazha kin namtuasmin, up kɨzpukasa sunkana kin nammun, up tɨlkaya ash putchã ash chikninsachi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nune ‘watchain’ kaizti. ‘Watcha chine, watcha chi’ kizti. Mamaz tuntu pit kaiztane, nune Diablo pit kaiztɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sunkas une ñamin uruza kamtara aizpa mɨara. Uruza ka kiznara: ‘Kasukin kɨzmumikane kwarain kɨzmumikawa kasu uktawa. Sulakin kɨzpianmumikane kawarain sula kɨzpianmikawa sula uktawa.’ ");
INSERT INTO kwi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sunkana nain uruza kurunnamtus: Nua kwail kirɨtmikasha puija kwail kinchi. Maza nua matsɨhkin kuzkane, mamazpa matsɨhkin kuzshina pianninti kizti. ");
INSERT INTO kwi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɨnpazha mikwasha up kamisha uknapa ɨninkane, ɨsal kwam kamishakas ussa mɨlatpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mɨnpazha nua maza kilómetro kakwakima kwana ɨninkane, nune kutña kilómetrokima ɨtpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɨnpazha chiwazha paikukane, mɨlatpa. Mɨnpazha chiwazha nua nampizkane, nammɨlatpa, kaiztachin.” ");
INSERT INTO kwi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sunkas une ñamin uruza kamtara aizpa mɨara. Uruza ka kiznara: ‘Izmuruza pashinarawa. Aliztuza aliz kultawa,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Me nain mamaz tuntu uruza kurunamtus. Aliztuza pashinarawa. Uruza kwail kimtuz akwa Diosta paikwatpa. ");
INSERT INTO kwi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Sunkana kitne, une chiyura Taitta pashparuzkana uzanazi. Diosne kwail awaruzakas wat awaruzakas pãn malninamtu. Usne wat kimtuz surakas nilchi kimtuz surakas alu kinintu. ");
INSERT INTO kwi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","U uruza pashimtuzain pashinarakas, une uruza pashinamtuchiruza pashinarawa, Dios uruza chiwazha mɨlananapa. Kwail kimtuzne usparuza pashinamturuzakas pashiamtu. ");
INSERT INTO kwi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","U izmuruzain ‘wat kɨntɨre’ kiznarane, une Diosta pianchiruzkana uzamtu. Diosta pianchiruzne usparuzpain kawarain kiamtu. ");
INSERT INTO kwi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","U chiyuras Papihshne chinkas kwail kit chi. Kawarain u chiyura Papihsh uztukanain watsal uz kit watsal kirain.” ");
INSERT INTO kwi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“U mamaz awa akwa watsal kal kikane, sun kal awa iztakin kinchi. Sunkana awa iztakin kitne, u chiyuras Papihshne uruza chinkas mɨlanamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Katmizna we mɨjtuza kiwainamtune, u kiamtu aizpa mɨnpazhara kainanachi. Awa iztakin an katsa namshimtumikane awa wanmakmukinkas awa pianamal chamtukinkas kianazi, mamaztuz paiña watsal kal kimtu aizpa izanapa, mamaztuz nua watsal kal kirɨt kizanapa. Uspane chiwazha mɨlam me sapparɨt, awa uspa wat kiarɨt kizara akwa. ");
INSERT INTO kwi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","We mɨjchiruza kiwainamtune, mɨnainkas u wat izmuruzakas kainanachi. ");
INSERT INTO kwi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mamaztuza kiwainamtune, puintain kitpa. U chiyuras Papihsh u puintain kiarɨt aizpa iztane, usne uruza chiwazha mɨlam mɨlananazi.” ");
INSERT INTO kwi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“U Diosta paikuamtune, awa iztakin an katsa namshimtumikakana Diosta paikwanchi. Uspane awa Judío kammu yalkinkas pianamal awa wanmakkamtukinkas kunamtu, awa usparuza izanapa. Watcha kaiznamtus. Sunkasane uspane me wan mɨlan mɨj. ");
INSERT INTO kwi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sunkana nu Diosta paikwantune, kalmal nap kit pɨjta sɨp kit up chiyuras Papihshta paikwatpa. Usne nukasa tu. Up chiyuras Papihshne nu puintɨt paikwantu aizpa mɨt kit nua paiña mɨlam mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nu Diosta paikumtune, Diosta pianchiruzkana paikwanchi. Uspane akkwan kain pit kwinta kiamtu. Akkwan pit kwinta kiamtune, uspane Dios usparuza mɨmtu minñamtu. ");
INSERT INTO kwi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Uspakana kiamtu aizpa kinchi. Paikwatchasmin, u chiyuras Papihshne u we mɨj aizpa me pian. ");
INSERT INTO kwi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Katmizna une sunkanain Diosta paikwarain: ‘Nune au chiyura Papihsh i. Nu sɨnammika akwa, awane nua wakpuj wainñashina. ");
INSERT INTO kwi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apa anka, awaruza ɨninnana. Chiyura uztuasmin, nune wanta watsal ɨninta. Kawarain au sura uztuzakas at kit wan watsal ɨninti, apain nu kishimtu aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Payu aizpa au kumira we mɨj aizpa kwinanaka. ");
INSERT INTO kwi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Au kwail kiamtu aizpa sɨnam sananaka. Aune aumɨza kwail kittuza wat kulshinamakpas. Kawarain nune au kwail kiamtu aizpa sɨnam sanaka. ");
INSERT INTO kwi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aumɨza kiwainchain, kwail kiamanpa. Awara kwail kininmika aukin akane, aumɨza watsat mɨlnanaka, kwail kiamanpa. Nuin wanta ɨninnamtu. Nuin anza tɨntamika i. Nuin an watsal iznazi, pailta payukima. Pailtu.’ ");
INSERT INTO kwi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","U uspa kwail kiarɨt aizpa wat kulnarane, kawarain u chiyuras Papihshkas u kwail kiarɨt aizpa wat kulninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mɨnpazha mamazpa kwail kiarɨt aizpa wat kultuchine, kawarain u Papihshne u kwail kiarɨt aizpa wat kulmanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Dios akwa kumtukine, tayal kit chanchi. Une wat iztɨt awakana uzman. Uspane tayal kit matsɨh kittachi chaamtu, awa uspa kuamtuchi izanapa. Nane watcha uruza kainanamtus. Uspane uspa mɨlam mɨj me. ");
INSERT INTO kwi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kancha Dios akwa kwashimtukine, matsɨh kit kit watsal ularawa, ");
INSERT INTO kwi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","awa u Dios akwa kumtuchi izamanpa. U chiyuras Papihsh u kuamtuchi piankamnazi. U Papihshne, wan kularɨt aizpa izmumikane, Dios akwa kumtuchimikasha chiwazha mɨlam mɨlanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Au sukinne kwazpa kulshiman. Kɨriyune au sukin pĩn tɨttu. Apane wan pɨttɨmtu. Apane walkumkas nap kit walkuamtu. ");
INSERT INTO kwi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Une chiyura kwazpa kulnintain. Suane kɨriyune pĩn tɨtmanazi. Suane chinkas pɨtkain. Suane walkumkas walkwan napkain. ");
INSERT INTO kwi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chiyurain wa aizpa pashimturuzne chiyurain wa aizpa minñat kit pashianazi.” ");
INSERT INTO kwi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kasu izkultane, awane kai izamtu. Kawarain kai iztamikane, wat kimtumikane, wat aizpa piankam kit wan wat kal nil kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kasu kai iztuchimikane mɨmtuchimikakana i. Suasne sun awa chiwazha watsal kal kisachi. Wat mɨrachimakane tɨlkwil chamtumikakana chanazi, wat kin pianchi akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mɨnminka paas anpatta kiwainasachi. Maza anpatta pashitne, mamazta pashimanazi. Maza anpatta kiwainshitne, mamazta kiwainsachi. Kawarain pialmin pashitmikane sun urain Diosta pashimanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Katne, nane uruza kurunamtus. Apa uzamtuasmin, kumira kwan kawa minman. Kwazi kwan kawa minman. Ɨmtura kamisha kwana kawa minman. Awa akkwan kumira mɨjkas, nil uzna an wari. Awa wat camisha kwakas, nil uzna an wari. Suntuz mɨjchikas, ishkuman, Dios uruza iznamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chitchu ɨsalpara iztain. Chitchuruzne pippa wakain. Pippa pakkain. Ɨranchura pippa watsakain. Sunkana u chiyuras Papihshmin uspa kumira kwinamtu. Diosne chitchukin uruza anza wat kwinanazi, u chitchukin anza tɨnta mai akwa. ");
INSERT INTO kwi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","An katsa kawishimtumikane paas kwajta an aks kawisachi. ");
INSERT INTO kwi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","U we mɨj aizpa kawa minñamtuasmin, u pĩnmin akwa mintakiwa. Sun ɨnkal wishta iz kit piankamtain. Wish kal kikainkas, pĩnkas sɨpkainkas, wishne watsal iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomónne, katsa ɨninmikane, paiña watsal pĩn kwaksham kwaara. Mane an kainanamtus. Wishne Salomónpa pĩnkin anza watsal iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosne wish kwiznintu, watsal iznapa. Maza payura wish chiktakas, wishne mamaz payura it kit pɨt kit impaktɨm. U Diosta we nɨjkulamtukas, Diosne mama uruza an wat kwira kinamtu. ");
INSERT INTO kwi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Katmizna ishkuman. Kumira we mɨjkas, ¿Chima kuwiznapai? kawa mɨmanachi. Pĩn kwaam we mɨjkas, ¿Chima kwaan ɨpai? mɨmanachi. ");
INSERT INTO kwi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diosta pianchiruzne sunmin min kit pashiamtu. U chiyuras Papihshne u we aizpa wan pian. ");
INSERT INTO kwi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Katmizna une an ñancha Diosta paikwarain, Dios uruza paiña iztukin ɨninnanapa. Suasne Diosta paikwatpa, uruza paiña uztukin nil namninnanapa, watsal uzanapa. Kwiztane Diosne u wenamtu aizpa uruza mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pailta payu awane akkwan tuntu kal kiarawa. Up kal tɨlwara kishimtu aizpa kawa mintuasmin, sun kalpa tɨlawara mintawa. Katmizna ma payu sun kalpa naizman.” ");
INSERT INTO kwi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Une mamazta kwail kirɨt kiznachi, Dios uruza kwail kiarɨt kizmanpa. ");
INSERT INTO kwi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sun akwa nu mamazta nu kwail kirɨt kiztane, Diosne sunkanain nua kwail kirɨt kiznazi. Nu mamazpa kwail kirɨt mintane, Diosne sunkanain nu kwail kirɨt minnazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ainki pak aimpihshpa kasura naptane, usne kai izsachi. Ñana tɨ up kasura naptane, nune izmanazi. Kawarain akkwan kwail kimtumikane we kwail kimtumikasha nu kwail kirɨt kizsachi. ");
INSERT INTO kwi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Katsa tɨ up kasura waasmin, nune aimpihshpa ainki pak paiña kasura naptɨt aizpa uksachi. ");
INSERT INTO kwi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nu wat awakanain namtɨt chamtukas, nune maiztachi. An ñancha up kasuras katsa tɨ uktawane, suasne nune kai izshina, aimpihshpa ainki pak kasuras ukna. Sunkana kamtanamtus: Nune Diosta paikwatpa, Dios up kwail wat kulnapa. Kwizta nune mamazta kiwainanazi, Dios usparuza wat kulnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Une mɨshimtuchiruza Dios watsal pitpa kaiznaman. Uspane aliz kwizakanain uruza kwashina. Une mɨshimtuchiruza Dios pitpa kaiznaman. Uspane kuzukanain mai. Uspane wanta mittɨ tat kit kulamtu.” ");
INSERT INTO kwi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“U we aizpa Diosta paikwarain. Usne u wenamtu aizpa mɨlananazi. U we aizpa sairain, wanmalna. Diosta akwarain. Pɨjtakin tak tak kimtune, Diosne pɨjtakin chɨhtnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paikwatmikane sapnazi. Saimtumikane wanmalnazi. Pɨjtakin tak tak kikane, us akwa pɨjta chɨhtnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Papihshne painkulta kwira kinazi. Painkul kumira paikukane, papihshne uk kwinmanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Painkul pishkaru paikukane, papihshne kamta kwinmanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","U kwail kiamtukas, une chiwazha wat mɨlam aizpa pashparuza kwinnashina. Up chiyuras Papihshne paikumtuza an akkwan watsal mɨlam kwinnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Awa uruza kiwainakane, une watsal uz. Kawarain une mamaztuza kiwainnarawa. Mamaztuza kiwainnarane, une Moisés kaizta aizpakas Dios kainammmika para aizpakas kiamɨznazi.” ");
INSERT INTO kwi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Au sura uztuasmin, sɨp pɨjtakimin naptain, nil miwara ɨnpa. Kancha mamaz aiz pɨjta wa. Aiz pɨjta naptawane, akkwan awane sun aiz miwara ĩntakima ɨamtu. ");
INSERT INTO kwi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sɨp pɨjta wa akwa, pɨnmal mi akwa, awane sun sɨp mira sayasachi. Akkwanchi awaruzne chiyura uzna nuasachi.” ");
INSERT INTO kwi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Une kwail kamtamtuza kwiraruin cha izanaka, uspa kamtamtu aizpa mɨamanpa. Uspane wat awakanain izat kit u uzkin wanmakkanazi. Wat awa makpas kizamtukas, uspane pɨrail appat kit wan awara kwail kininnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Une kwail kamtamtuza piankamanazi, uspa kwail kiamtu akwa, watcha kamtamtuchi akwa. Kawarain tɨrinul pu tɨttas pakkain. Wankail tɨ pippa pu tɨttas pakkain. ");
INSERT INTO kwi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sunkanain wat tɨne wat pippa wam. Kwail tɨne kwail pippa wam. ");
INSERT INTO kwi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wat tɨne kwail pippa wakain. Sunkanakas kwail tɨne wat pippa wakain. ");
INSERT INTO kwi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wan tɨ wat pippa wakainne, kwat kit ĩnta paktam. ");
INSERT INTO kwi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kawarain une kwail kamtamtuza piankamanazi, uspa kwail kiamtu akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wan nawa ‘ap anpat’ kizmuruzne Dios ɨnintukin nappamanazi. Chiyuras Papihsh kaizta aizpa kimturuzne nappanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sun payu taizkane, akkwan awane nawa ka kizanazi: ‘Ap wat Anpat, aumɨza mɨzhain. Nua akwantuasmin, aune Dios watsal pit kainaramakpas. Nua akwantuasmin, aune awaras saliztuza ɨnintamakpas. Nua paikwantuasmin, aune akkwan iztasparɨt kal kitmakpas,’ kizanazi. ");
INSERT INTO kwi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Suasne nane uruza sɨnkanat kit sunkana kaiznanash: ‘U nawa nɨjkularachi akwa, nakis paimpa ɨrain. Une pailta payukima kwail kiarɨt,’ kiznanash.” ");
INSERT INTO kwi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Katmizna wan na kaizta aizpa mɨraruzkas na ɨninta aizpa kimtuzkas wat mɨmturuzkana mai. Usne, yal samtumikane, ukkin sara, nainmanpa. ");
INSERT INTO kwi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Katsa alu kimɨzkane, pi kulmɨz kit tɨnta inkwa pamɨzta yalkin. Sunkana yalne naintachi, ukkin yal sarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na kaizta aizpa mɨmtuchimikakas na ɨninta aizpa kimtuchimikakas tɨmpa awakana i. Usne pi ksukin yal sammikakana i. ");
INSERT INTO kwi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Katsa alu kimɨztawane, pi kulmɨz kit tɨnta inkwa pamɨzta yalkin. Suasne pi wan kwara. Wan karɨt.” ");
INSERT INTO kwi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús wan kapal kamtarawane, wan awane us kamtara aizpa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Usne Moisés parɨt aizpa kamtamtuzkana kamtanarachi. Usne mikwakana tɨnta kamtanara. ");
INSERT INTO kwi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús ɨzaras kihshkane, akkwan awane ussa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aya pɨttɨtmikane Jesústa kasha at kit Jesús iztakin wakpuj wain kit ka akwara: —Anpat. Ap ña ishtu nawa namtashitne, namtazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Suasne Jesúsne paiña chihtɨkasa ussa pat kit ka kaizta: —Watcha, nane nua namtashimtus. Me namtɨt, kizta. Sun kizkane, usne aya pɨttɨtmikara wat namnintɨt. ");
INSERT INTO kwi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesúsne ussa kaizta: —Mɨri. Nu wat parɨt aizpa mɨnainkas kainamman. Na kaiztu aizpa kitpa. Judío pariyara ɨt kit Moisés mɨlan ɨninta aizpa mɨlatpa. Sun kitpane, wan awane nu wat namtɨt piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaum pɨpulura piannakane, Romano suldaru ɨninmikane Jesústa at kit ka akwara: ");
INSERT INTO kwi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Anpat mɨzha. Ap kiwainmumikane ap yalta kamara ishtu tui. Anne chasachi, kwisha ishtu akwa. Usne kwisha naiztu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesúsne ussa ka kaizta: —Nane ɨnash, ussa namtana, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɨninmikane ussa ka sɨnkara: —Anpat mɨzha. Nane wat awakana chish, nu ap yalta napnapa. Ap kiwainmumikawa namtari kizkane, usne watcha namtɨt kirɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kawarain ap mikwane nawa ɨnintu. Nakas aptuza ɨninnamtus. Mamazta “ɨt” kizkane, usne ɨm. Mamazta “anka” kizkane, usne am. Ap kiwainmumikasha “chiwazha kinpa” ɨninkane, kim. Katmizna nu ap kiwainmumikasha wat namtɨt kizkane, nane us wat namtɨnazi pianish. ");
INSERT INTO kwi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Us kaizta aizpa mɨrawane, Jesúsne iztaspat kit ussa kanpamtuza kaiznara: —Watcha kaiznamtus. An ampune Diosta wat nɨjkultu. Mɨnminkas Israel awaruztas sunkana nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nane uruza kaiznamtus. Akkwan Israel chi awane pãn puzmuwaraskas pãn payapmuwaraskas Dios ɨnintukin piannanazi. Israel awaruz pianamtuchasmin, uspane an ñamin wanmakkanazi. Abrahamkasakas Isaackasakas Jacobkasakas uzat kit kuanazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel awaruzne, an ñancha akwattuzne mizurainkas Dios ɨnintukin nappamanazi, nɨjkularachi akwa. Tɨlkwilta ɨninnarawane, uspane azat kit sula sɨt sɨt kianazi, naizamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Suasne Jesúsne ɨninmumikasha kaizta: —Up yaltain ɨnka. Nu nɨjkulta aizpa sunkana kirɨt. Sun urain paiña kiwainmumikane kakultɨt. ");
INSERT INTO kwi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesúsne Pedrowa yalta ɨt. Suane usne Pedrowa suegrara kamara tu izta. Imu piztɨt tuazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús paiña chihtɨkasa ussa pizkane, imu kanintɨt. Usne kuhsak kit chiwazha kumira usparuza kumira kwinnamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tɨlparɨkane, awane Jesús tukin akkwan saliz piztɨttuza karaara. Jesúsne maza pit kaizkain salizta puzninnara. Wan inturuzakas kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Diosne sun kinintɨt. Isaías kainammmikane ñamin ka pat kit kaizta: “Usmin au ishtu aizpakas au naiztu aizpakas kaninta,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesúsne akkwan awara iznara. Jesús tukin kasha aakane, Jesúsne paiña kammuruza pi kwakara ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Suasne Moisés kaizta aizpa kamtammikane at kit Jesústa ka kaizta: —Anpat mɨri. Nane nua kanpashimtus, mɨnta ɨkwarakas up kammumika namna, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesúsne ussa sɨnkara: —Ɨnkal kwizane paiña yal kul mɨj. Chitchukas yal mɨj. Nane ampu namtɨtmika ish. Sunkana nane mɨnta kwaizkulna mɨjchish. Mɨnpazha nawa kanpashitne, nane an sukin chinkas ussa kin namsachish. ");
INSERT INTO kwi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mamaz kanpammikane ussa kaizta: —Anpat mɨri. Ap taitta irɨkane, nane an ñancha ussa kamna ɨnash. Ussa kamtawane, kwiztane nua kanpanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús ussa sɨnkara: —Ma kanpazha. Diosta pianchiruzne awa irɨtkanain uzamtu. Diosta pianchiruzne irɨttuza kamarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesúskas paiña kammuruzkas kanuawara waat kit ɨara. ");
INSERT INTO kwi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Masain tɨnta inkwa pamɨzta. Pine kanuara unainapain parɨt. Jesúsne pittɨt tuazi. ");
INSERT INTO kwi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Suasne kammuruzne ussa kasha aat kit ussa izkulnin kit ussa kaizara: —Anpat mɨzain. Aumɨza watsat mɨlchain. Aune kanua pi unainapainmakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Usne kaiznara: —¿Une chikishma katne ishkupuspas? Une nawa wat nɨjkulamtuchi, kiznara. Suasne usne kuhsak kit pirakas inkwarakas kaizta: “Inkwa pamun. Pi kialmun.” Suasne inkwakas parachi. Pikas kalpain parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kanpanaruzne iztaspaat kit kaizara: —¿Usne mɨnma kasa? Inkwakas pikas us kaizta aizpa mɨamtu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús pi kwakara, Gadara sura, piannakane, paas ampune pantióntas puzpail kit ussa kasha pianailta. Saliztuzne paasta pizarɨt. Paasas kwisha aliz warain. Mɨnminkas sun miwara pɨnsachi. ");
INSERT INTO kwi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesústa ka kwianmɨzpailta: —Nune Dios Painkul i. ¿Aumɨza chima kishimtus? ¿Nune aumɨza an ñancha naizninna amas? Ma payu narɨt payu chi, kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kashain akkwan kuzuruzne kuamtu pura. ");
INSERT INTO kwi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Saliztuzne Jesústa ka paikwara: —Aumɨza puznintane, kuzura ɨninchain, kuzura piznapa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesúsne kaiznara: —Sua ɨrain, kiznara. Jesús saliztuza puzninkane, saliztuzne kuzura pizara. Usparuza piznarawane, masain wan kuzuruzne ɨzaras pirakima azain kihshat kit pira ɨat kit pi kwaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Suasne kuzu izmuruzne ishkuat kit pɨpulura azain ɨara. Pianarawane, uspane uspa izara aizpa awaruza kainanamɨzta. Saliz puznintuzpa kainanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Suasne akkwan pɨpuluras awane Jesús tukin ɨara. Sua pianarawane, uspane Jesústa paikuara, uspa sukis ɨnpa. ");
INSERT INTO kwi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Suasne Jesúsne kanuara waat kit pi kwak kit paiña pɨpulura piannarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sua uspane chasachi intura kamara tukin iptɨt muaara. Chasachi intura karattuza iznarawane, Jesúsne uspa wat nɨjkulamtu piankam kit intura kaizta: —Ap painkul mɨri. Tayalmun. Nane nu kwail kit aizpa me wat kultɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Suasne mɨnpazha Moisés kaizta aizpa kamtamtuzne usparuzpain ka minñara: “Sun ampune paiña pitkasain Diospa kwail kiztu.” ");
INSERT INTO kwi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesúsne uspa minñamtu aizpa piankam kit usparuza mɨmanara: —¿Une chikishma katne kwail minñamtuas? ");
INSERT INTO kwi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Chikishma katne na kimtu aizpa mɨmamuspas? “Nane paiña kwail kit aizpa wat kulshinas. Kawarain paiña kamakis kuhsninshinas.” ");
INSERT INTO kwi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nane uruza na kimtu aizpa annanash, ampu namtɨtmika an sukin ɨnintu piankamanapa. Nakas paiña kwail kirɨt aizpa wat kulninshinas. Nane au su uztuza ɨninshinamtu, kiznara. Suasne Jesúsne chasachi intumikara kaizta: —Kuhsak kit up kama mɨl kit up yalta ɨrɨnka. ");
INSERT INTO kwi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chasachi intumikane kuhsak kit paiña yalta ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Awa sun kirɨt aizpa izarawane, uspane ishkuamɨzta. Dios an ampura watsal kal kinpa kiwainta akwa, uspane Dios kwisha wari kizara. ");
INSERT INTO kwi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Miwara ɨmtuasmin, Jesúsne maza awara, Mateo muntɨtmikara, izta. Usne Roma gobierno pial sapmu yalkin kal kimtuazi. Ustukin piannakane, Jesúsne ussa kaizta: —Nawa kanpazha, ap kammumika namnapa. Suasne Mateone kuhsak kit ussa kanpara. ");
INSERT INTO kwi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sun payu Jesúskas paiña kammuruzkas Mateowa yalta kwan ɨara. Akkwan Roma gobiernowa pial sapmuruzkas mamaz kwail kimtuzkas piannaara, uspakasa kwan. Judío ɨnintuzne “uspa kwail awa mai” minñara, Judío awa ɨninta aizpa mɨarachi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseo awa sun izarawane, uspane Jesústa kanpamtuza ka mɨmaara: —¿Chikishma up kamtam pial sapmuruzkasakas mamaz kwail kimtuzkasakas kumtu? mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sun mɨrawane, Jesúsne kaiznara: —Nane tuttulkana ish. Kwail kimmikane ishtumikana i. Imtuchiruzne tuttul pashikain. Imtuin tuttul pashimtu. ");
INSERT INTO kwi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","An watsal pit para aizpa piankamtain. Sun pit an ñamin Dios pɨnkɨhta ka parɨt: “U wakara piantana karamtukas, nane sun mɨlam pashitchish. Mamaztuza kiwainna an wari,” ka parɨt. Nane wat awa makpas mintuzne akwanamtuchish. Nane kwail kiarɨttuza akwanamtus, kwail kiarɨttuza wat kulnana. ");
INSERT INTO kwi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan munnammikawa kammuruzne Jesústa ɨat kit mɨmaara: —¿Chikitma up kanpamtuzne Dios akwa pala kwatchin payura kuamtu? Uspa akwa impa chi. Aukas Fariseo awakas pishta payu kuamtuchimakpas. Au akwa impa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesúsne sɨnkanara: —Kasara pishtakin akwattuzne kasara kimtumika akwa tayalamtuchi. Usne usparuzkasa tuasmin, uspane kuamtu. Impachi. Kawarain ap kammuruz nakasa purasmin, uspane kuamtu. Impachi. Mamaz payura ap izmuchiruzne nawa pizara. Nane apain tuamanash. Sun payu taizkane, ap kammuruzne tayal kit kuamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nane masas kamtam uruza kamtananamtu. Ɨlapawa kamtamkanachi. An masas kamtam mɨmtumikane ɨlapawa kamtam mɨkain. Paasas kamtam kiasachi. Sunkanain mɨnminkas pɨtta pĩnta yalsachi masas pĩnkasa. Masas pĩnkasa yaltane, masas sɨpparawane, pɨttɨt pĩnne an pihsharɨm. ");
INSERT INTO kwi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sunkanain masas chappi pɨtta ayara ultuchi, sulnapa. Masas chappi pɨtta ayara ultane, chappi sulkane, ayane pihshat kit chappi puz kit wan karɨnazi. Katmizna sultachasmin, masas chappi masas ayara wintawa, chappi sulnapa, paasas kamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús sun kiznamtuasmin, Judío ɨninmikane ussa at kit us tukin wakpuj wain kit kaizta: —Ap pashune mamin ire. Nu at kit up chihtɨkasa ussa parane, usne kakul kit mamasa uznazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesúsne kuhsak kit uskasakas kammuruzkasakas ɨamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Suasne maza intu ashampane Jesús tukin ɨt. Doce añokima paiña aimpi pulparachi akwa, usne kwisha naizta. Jesúspa kwizpa at kit Jesúspa kwaksham puntakin paara. ");
INSERT INTO kwi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Usmin ka minta: “Paiña pĩnta paarane, wat paakwarakas,” minta. ");
INSERT INTO kwi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesúsne puij chat kit ashampara iz kit kaizta: —Ashampa mɨzha. Tayalmun. Nu nawa wat nɨjkulta akwa, nu wat pari, kizta. Ashampane sun urain wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Judío awa ɨninmikawa yalta piannakane, Jesúsne akkwan kanta usamturuzakas akkwan azamturuzakas iznara. Uspane aat kit pashpara izara. Ussa watsat taara, kamna ɨnpain. Usne kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Akkis puztain, nimpihsh ashampa irachi akwa. Pittɨt tui, kiznara. Sun mɨamtuasmin, uspane Jesústa ishanara. ");
INSERT INTO kwi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Awaruza puzninnarawane, Jesúsne kalmalta nap kit nimpihsh ashampawa chihtɨ pizta. Suasne usne kuhsak kit kunta. ");
INSERT INTO kwi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wan awane sun sukin Jesús kit aizpa piankamara. ");
INSERT INTO kwi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Suas puztawane, paas kasu izsachiruzne ussa kanpail kit ussa tɨnta kwianpailta: —Aumɨza mɨzhain. Davidne up antikwa pampawa papihsh ara. Nu mikwa Davidpa kwal akwa, nu Diospa nɨrɨtmika akwa, aumɨza kiwainchain, kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús yalkin napkane, paasas kasu izsachiruzne us tukin ailta. Jesúsne usparuza ka mɨmara: —¿U nawa nɨjkultukiwas. Na uruza izkulninshinaki? Uspane kaizpailta: —Watcha, Anpat. Aune nua nɨjkultuas, au paikumtu aizpa kinpa, kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Suasne Jesúsne uspa kasura paat kit kaiznara: —U nawa nɨjkultu akwa, une masain wat izashinai. ");
INSERT INTO kwi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Uspa kasune izkulpailta. Suasne Jesúsne “sun kit aizpa mɨnainkas kainanamun,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tas puzpailtawane, uspane wan awaruza Jesús uspa akwa kirɨt aizpa kainanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kasu izsachiruz puzpailkane, mɨnpazha Jesústukin aara. Uspane saliz piztɨt parasachimikasha karaara. ");
INSERT INTO kwi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús salizta puzninkane, parasachimikane, paramɨzta. Awane iztaaspat kit kaizara: —Aune Israel sura mizurainkas sunkanane iztakimakpas. ");
INSERT INTO kwi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo awane ka kaizamɨzta: —Salizpa katsa mikwane Jesústa kiwaintu, mamaz saliztuza puzninnanapa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesúsne wan ainki pɨpulurakas wan katsa pɨpulurakas chamɨzta, Judío kammu yalkin kamtanana. Usne Dios watsal pit kainanara, awa Dios ɨnintukin uzanapa. Usne wan inturuzakas wan ishturuzakas kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wan awaruza iznamtuasmin, Jesúsne usparuza kiwainnashira. Uspane kwisha tayalat kit kwaizarɨt. Uspane pɨrikukana chaamtu, izmumika mɨjchin. ");
INSERT INTO kwi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Suasne Jesúsne paiña kammuruza kaiznara: —Akkwan pippa pakna wakas, akkwan kal kimtuzne purachi. ");
INSERT INTO kwi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Katmizna pakmuwamikasha paikwarain, awaruza paiña pakmura pakninna ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Suasne Jesúsne paiña doce kammuruza akwanat kit kiwainnara, kwail saliztuza puzninnanapa, wan tuntu intukas wan tuntu ishtukas kakulninarɨnpa. ");
INSERT INTO kwi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Doce ɨnintuzne ka munmazi: An ñancha akwatmikane paas tuntu muntɨt. Simónne Pedrokas muntɨt. Paiña aimpihshne Andrés muntɨt. Santiagokas Juankas aimpihshpara. Sun paasne Zebedeowa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipekas Bartolomékas purazi. Mamaz Tomáskas munazi. Mateone, Roma gobierno pial ñamin saptɨtmikane, azi. Santiagone, Alfeo painkul, azi. Mamaz Tadeo muntɨt. ");
INSERT INTO kwi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simónne Cananeokas muntɨt. Judasne Iscariotekas muntɨt. Usne Jesústa Judío awa ɨnintuza chɨhkanara, Judío awa ussa pizanapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesúsne sun doce kammuruza sun watsal pit kainanapa ɨninnara. An ñamin usparuza ka kainanara: “Judío awachiruz uzamtukin ɨman. Samaria awawa pɨpulura napman. ");
INSERT INTO kwi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mane Israel awaruza, sun pɨriku karɨtkana puraruza, an watsal pit kwinta kin ɨrain. ");
INSERT INTO kwi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Diosne chiyuras ɨninana anpain. Kainawas ɨrain. ");
INSERT INTO kwi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Intura kakulninnarain. Irɨttuzakas kuhsninnarain. Pɨrɨt aya ishturuza watsaninnarain. Saliztuza puzninnarain. Na uruza kain mɨlanarɨt akwa, mamaztuza kain mɨlanarain. ");
INSERT INTO kwi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","U pial tuhkin win kwaaman. ");
INSERT INTO kwi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kumirakas tuhta kwaaman. Maizmu kamishakas kwaaman. Mamaz zapatokas kwaaman. Tɨwilkas muman. Yalpamikane Diospa kal kimmikasha mɨlanarawa, us we mɨj aizpa sappanapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ainki pɨpulurakas katsa pɨpulurakas piannatpane, mɨnpazha wat awara sait kit yal mɨlazha kiztain. Paiña yalta nukkultain, ɨnkima. ");
INSERT INTO kwi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sun kwalpa yalta naptawane, wat kɨntɨre kiztain. U akwa Diosta paikwantus, Dios uruza kiwainnanapa, ka kiztain. ");
INSERT INTO kwi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nuri kizkane, yal mɨlamtus kizkane, yalpamikane wat uznazi, nua sapta akwa. Yalpamika yal mɨlamtus kizmakane, kakishapu kaizman. Diosta paikwantus, nua kiwainanapa kaizman. Usne wat uzmanazi, nua saptachi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nuri kizmakane, u kaizara aizpa mɨashimakane, sun yalkiskas sun pɨpulukiskas puztain. Puzarawane, uspa iztakin mittɨ pil puhstɨtne ulpiantawa, sun awa kwail kiarɨt piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Watcha kaiznamtus. Diosne an pɨpuluras awaruza anza naizninnanazi, Dios kaizta aizpa mɨarachi akwa. An ñamin Sodoma pɨpulura uztuzkas Gomorra pɨpulura uztuzkas akkwan kwail kiarakas, uspane an wewazha naizanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nawa mɨzha. Mane nane uruza kwail awa uzamtukin ɨninnamtus. Uspane aliz awa pura. Uspane kwail awa mai. Uspane ɨnkal kwizakana pura. Uruza kwail kiashimtu. Une uspawa nɨj kit wat mintawa, uspa iztakin nil uzna. Sunkana une usparuzkasa waya kiman. ");
INSERT INTO kwi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sun aliz awaruza kwiraruin. Mɨnpazha aliz awane uruza ɨninmika tukin ilna mɨlnanazi, u nawa piankamtu akwa, nawa kanpamtu akwa. Judío kammu yalkin mɨlnanazi, tɨwilkasa aim kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","U nawa piankamtu akwa, uspane uruza piznat kit mikwarakas mamaz ɨninmikarakas chɨhkananazi. U na akwa naizamtuasmin, une Judío awaruzakas Judío awachiruzakas na uruza kaizta aizpa parananazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Uruza mikwara chɨhkanakane, miza paran kawa minman. Paramtu payu taizkane, au Diosne uruza sun watsal pit paraninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Papihshpa Sɨnam Izpulne uruza kiwaininnanazi, paiña pit mikwaruza parananapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aimpihshne aimpihshta mikwaruza chɨhkanazi, piantaninnapa. Papihshne painkulta chɨhkanazi. Painkultuzne papihshta mikwara chɨhkanazi, piantaninnapa. ");
INSERT INTO kwi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","U nawa nɨjkulamtu akwa, akkwan awane uruza pashinamanazi. Sunkana minpa payu sun naizmu tailchatne, une ap ɨnintura nakasa uzanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mamaz awa uruza pɨpulura pizashikane, tas puzat kit mamaz pɨpulurakima ɨrain. Nane watcha kaiznamtus. Dios Painkul piannatchasmin, une wan Israel pɨpulura ɨanazi, Dios watsal pit usparuza kainanapa. Wan pɨpulura ɨtchasmin, Dios painkulne piananazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kammumikane paiña kamtammikakin anza wat chi. Kiwainmikane paiña anpatkin an katsa chi. ");
INSERT INTO kwi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kammumikane kamtam uztakanain uztawa. Kiwainmikane anpatkanain namtawa. Awa nawa aliz kularɨtne, Beelzebú nawa piztɨt kaizarɨtne, uspane kawarain uruzpa kaizarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Katmizna une aliz kulamtuza ishkuman. Awane chiwazha puintɨt aizpa chiwal piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na uruza impara imparain kamtanamtukas, une na kamtarɨt aizpa mɨnpazhara ɨninnat kit tɨnta kainarain, wan mɨanapa. Na uruza puintain paramtukas, une na parɨt aizpa wan awa uzkin mɨnpazhara ɨninnat kit kainarain. ");
INSERT INTO kwi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Uruza piantashimtumikara ishkuman. Uruza piantamtukas, uspane up izpulta piantasachi. Diosmin awaruzakas uspawa izpultuzakas ĩnta kaninshina. Ussa ishkuarawa. ");
INSERT INTO kwi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ainki chitchu painintane, une akkwan chin saptu. Maza chitchuin irɨkane, u chiyuras Papihshne sunkas pian. Usne sunkana kinintu. Dioskas chiwazha kimtu aizpa pian kit aumɨza iztu. ");
INSERT INTO kwi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Usne au chiwal kɨzpu ashkima wintɨt. Usne uruzpa wan pian. ");
INSERT INTO kwi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Katmizna une ishkuman. Akkwan chitchu purakas, une wan chitchukin anza wat mai.” ");
INSERT INTO kwi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mɨnpazha awaruza ‘Jesústa nɨjkultus’ kiztane, nakas ap chiyuras Taittara ‘usne ap izmumika i’ kiznash. ");
INSERT INTO kwi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mɨnpazha ‘Jesústa nɨjkultuchish’ kiztane, nakas ap chiyuras Taittara ‘usne ap izmumika chi’ kiznash.” ");
INSERT INTO kwi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nane an sukin arachish, wan awa kalpain uzanapa. Sunkana miman. Na at akwa, awane aliz kulamɨz kit usparuzpain waya kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na an sukin arɨt akwa, awane usparuzpain aliz kulanazi. Pashparuzne papihshkasa aliz kulanazi. Pashuruzne akkuhshkasa aliz kulanazi. Pashu kiznaruzne suegrakasa aliz kulanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Awane uspa kwaltuzpain waya kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Papihshtakas akkuhshtakas nawakin an akkwan pashiamtumikane ap kanpammika namsachi. Painkultakas pashurakas nawakin an akkwan pashiamtumikane ap kanpammika namsachi. ");
INSERT INTO kwi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na akwa naizshimtuchimikane, na akwa ishimtuchimikane, ap kanpammika namsachi. ");
INSERT INTO kwi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na akwa ishimtuchimikane wan karɨnazi. Na akwa wan karɨntumikane nakasa chiyura uznazi.” ");
INSERT INTO kwi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mɨnpazha u kaizta aizpa mɨraruzne kawarain na kaizta aizpa mɨanazi. Mɨnpazha na kaizta aizpa mɨraruzne kawarain nawa ɨnintumikara mɨanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dios pit kainammmika akane, une Diospa kainammtuza wat kinarawa. Suasne ukas paiña mɨlamkana sappanazi. Wat awa akane, une wat kimtuza wat kinarawa. Suasne ukas paiña mɨlamkana sappanazi. ");
INSERT INTO kwi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ap an ainki kammumikasha tɨh kwazi kwintamikane mɨlam sapnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Paiña doce kammuruza uspa kal kianapa kainanarawane, Jesúsne Galilea sukin uztuza ɨt kit Dios watsal pit awaruza kamtanara. ");
INSERT INTO kwi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sun payuin Juanne kajchira sɨptɨt wa. Jesús kirɨt aizpa piankamtawane, Juanne mɨnpazha kammuruza ɨninnara, Jesúskasa kwinta kin. ");
INSERT INTO kwi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ka mɨmaara: “¿Nune Dios ɨnintamikakish? ¿Nune chiyuras atmikakish? Nu Dios ɨnintachimakane, ¿Aune mamazta saishinasa?” mɨmara. ");
INSERT INTO kwi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesúsne sɨnkanara: “Juanta ɨat kit u izamtu aizpakas u mɨamtu aizpakas ussa kainarain. ");
INSERT INTO kwi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sunkanain ussa kainarain. Kasu izsachiruzkas izamtu. Mittɨ chasachiruzkas chaamtu. Aya pɨrɨt ishturuzkas wat paraamtu. Mɨkaintuzkas mɨamtu. Irɨttuzkas kuhsaamtu. Awane Dios watsal pit puizaruza kainanamtu. ");
INSERT INTO kwi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nawa nɨjkulmɨztuzne watsal kianazi, u na kirɨt aizpa izara akwa. Katmizna Juan nawa nɨjkulmɨztune, usne watsal kinazi.” ");
INSERT INTO kwi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpa ɨnintuz kaiyarawane, Jesúsne Juanpa awaruza kainanamɨz kit mɨmanara: “¿Chikishma pul sura Juan tukin ɨara? Une najtɨt awara izarachi. Usne pɨt tɨ inkwa pamtukana chi. Tɨskana i. Ulpianmuchi. ");
INSERT INTO kwi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Najtɨt awara izna ɨarakine, ¿Chikishma une ɨara? ¿Watsal pĩn kwarɨtmikara izna ɨamanas? Watsal pĩn kwarɨtmikane katsa mikwa yalkimin uztu. ");
INSERT INTO kwi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Watsal pĩn kwarɨtmikara izna ɨkine, ¿Chima iziznash? ¿Dios kainammikara izna ɨamanas? Watcha. Une Dios kainammikara izara. Juanne wan Dios kainammtuzkin anza tɨnta i. ");
INSERT INTO kwi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","An ñamin Dios pɨnkɨhta Juanpa ka parɨt: ‘Nane ap ɨnintumikara, up ɨmtumal an ñancha ɨninnash, sun amtu payura wan watsat mɨjanpa.’ ");
INSERT INTO kwi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Watcha kaiznamtus. Makima mɨnminkas, Juan munnamikakin an tɨnta katsa uztachi. Dios ɨnintukin an we tɨnta uztumikane Juankin an katsa i, Dios pit mɨrɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan munnammika atkima ma payukima akkwan awane Dios pit mɨashit kit Dios ɨnintura nappashimtu. Dios ɨnintura sɨptɨtkas, Dios pit mɨashimturuzne sua wanmakkamɨz kit nuppainashimtu, sua nappana. ");
INSERT INTO kwi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan uztakima, wan Dios kainammtuzkas Moiséskas Dios ɨnintu kinpa kainaara. Diosne apain ɨninnazi, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na kaizta aizpa mɨshitne, Elíaspa mɨrain. An Juanne, Dios pit kainammmikane, Elías i. Diosne ussa ɨninna namta. ");
INSERT INTO kwi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Katmizna na kaiznara aizpa mɨrain. ");
INSERT INTO kwi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma payu uztuza ¿Chima kizanasa? Uspane pashpakanain mai. Pɨpulu salmukin salamtuasmin, uspa izmuruza ka kwiannamtu: ");
INSERT INTO kwi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aune karaskwil uspusanash, kuki kianapa. Une kukitchi. Au tayaltɨt kanta kaiztuasmin, une mizurainkas azarachi,’ kiznaara. ");
INSERT INTO kwi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kawarain une uspakanain mai. Juan akane, mamazkasa kumira kwatchi akwa, mamazkasa chappi kwatchi akwa, une ‘ussa kwail saliz piztɨt’ kizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mane nane, ampu namtɨtmikane, arau. Na wan chiwal kumtu akwa, une nawa pirɨtmin chammikakanakas kwisha kumtu chammikakanakas kizamtu. Une nawa ka kizamtu: ‘Ap izmuruzne kwail awa mai. Ap izmuruzne Roma gobierno pial sapmuruz mai,’ kizamtu. Watcha, u nil minñamtune, une na kaizta aizpa watcha i piankamanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesúsne akkwan pɨpuluruza akkwan iztaspaarɨt kal kirɨt. Awa uspa kwail kiarɨt aizpa maizarachi akwa, Diosta kaiyarachi akwa, Jesúsne usparuza pilchapuz kit ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Corazín pɨpulukin uztuzkas Betsaida pɨpulukin uztuzkas kwisha akkwan naizarɨnazi. Na uspa pɨpuluruza akkwan iztasparɨt kal kitkas, uspane nawa nɨjkularachi. Tiro pɨpulukin uztuzkas Sidón pɨpulukin uztuzkas sun iztasparɨt kal izaratne, uspane ñamin uspa kwail kiarɨt aizpa maizashinat kit Diostakas kaiyashinara. Tayalara akwa, uspane tɨlkaya pĩn kwaarɨmashina. Tayalta akwa, uspane putchã imkas kɨzpura sɨntɨrashina. ");
INSERT INTO kwi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Katmizna, nane uruza ka kaiznamtus. Ilnam payu taizkane, une na kaizta aizpa mɨrachiruzne an akkwan naizanazi. Tiro pɨpulu uzturuzkas Sidón pɨpulu uzturuzkas an wemin naizanazi. ");
INSERT INTO kwi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum pɨpulukin uztuzne au pɨpulu anza watsal pɨpulu i minñamtu. Kancha u pɨpulu azpian kit wan karɨnazi. Wan irɨttuzpa izpultuzne irɨttukin ɨat kit kwisha naizarɨnazi. Une na iztasparɨt kal kirɨt aizpa izara. Sun iztasparɨt kal Sodoma pɨpulukin kiaratne, Sodoma pɨpulu uztuzne Diosta nɨjkulashina, Dios uspa kwail kiarɨt aizpa wat kulnanapa. An pɨpulune azpiansachiari. Sun iztasparɨt kal izaratne, Soldoma pɨpulune makima tuashina. ");
INSERT INTO kwi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Katmizna uruza kaiznamtus: Ilnam payu taizkane, Capernaum pɨpulura uztuzne Sodoma pɨpulu uztuzkin anza tɨnta naizarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","An payu Jesúsne paiña Papihshta ka kaizta: “Nune wari. Nune Anpat i. Nune chiyurakas an surakas ɨnintui. Nune sun kamtam puintɨt mɨj, piankamtɨttuz chi mɨamanpa. Nu sun kamtam we piantuza piankamninnamtu akwa, nane nua kwisha wari kiztus. ");
INSERT INTO kwi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Watcha, nune ap Taitta i. Sunkana kishirɨt. ");
INSERT INTO kwi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nu ap Taitta akwa, nune nu pashit aizpa nawa wan kinpa chɨhkarɨt. Papihshmin Painkulta wat pian. Painkulminkas Papihshta wat pian. Painkulkas mamaztuza nanaat kit kiwainnamtu, Papihshta piankamɨznapa. Paiña Papihshta sun kiztawane, usne awaruza ka kiznara: ");
INSERT INTO kwi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kwaiztɨttuzkas an tailsachiruzkas nawa at kit nɨjkulchain. Na u kwail kiarɨt aizpa wat kul kit kwaizkulninnanash. ");
INSERT INTO kwi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nawa azhain, na kamtara aizpa mɨanapa. Nane uruza impara imparain paranamtus, piankamanapa. Nane aliz awa chish. Nane uruza kiwainanash, up kaijchu kwaizkulnapa. ");
INSERT INTO kwi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nane nawa kammuruza kiwainnanash. Na uruza kamtamtu aizpa kin samchi.” ");
INSERT INTO kwi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sun payura Jesúsne kwaizkultu payura sauwara ɨrɨt. Paiña kammuruzne yak kiamɨz kit chara pippa pakkamɨzta kwan. ");
INSERT INTO kwi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo awa sun izarawane, Jesústa kaizara: —Izti. Up kammuruzne kal kiamtu. Kwaizkultu payura kal kinchi. ");
INSERT INTO kwi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Usne sɨnkanat kit mɨmanara: —Katsa mikwa Davidkas paiña izmuruzkas ñamin yak kiara. ¿Une uspa kiara aizpa pɨnkɨhta izamanas? ");
INSERT INTO kwi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uspane Diospa yalkin nappat kit Diosta kwintɨt pan kuara. Uspa kiarɨt aizpa impa. Diospa pariyarain Diosta kwintɨt pan kuashina. Uskas paiña izmuruzkas sun pan kuashitchikas, Diosne usparuza ilnarachi. ");
INSERT INTO kwi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Une Moisés pɨnkɨhta parɨt aizpa piankamarachi. Pariyaruzne kwaizkultu payura Diospa yalkin kal kiamtu, kwaizkultachin. Uspane kwail kiarachi. ");
INSERT INTO kwi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nane uruza watcha kaiznamtus. Nane u iztakin chamtus. Nane Diospa yalkin anza tɨnta ish. ");
INSERT INTO kwi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Une Dios pɨnkɨhta parɨt aizpa piankamarachi. Pɨnkɨhta ka parɨt: “Nane mamaztuza pashinanapa pashimtus, usparuza kiwainnana. U ampu wakara na akwa piantarakas, u nawa mɨlamtu aizpa pashimanash.” Us kaizta aizpa mɨaratne, une ap kammuruz kwail kiarɨt kaiznasachi. ");
INSERT INTO kwi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Suas nane, ampu namtɨtmikane, kain payukas kwaizkultu payukas ɨnintus. ");
INSERT INTO kwi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Suas Jesúsne tas ɨt kit pɨpulura piannat kit Judío kammu yalta napta. ");
INSERT INTO kwi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Suane maza chihtɨ chɨhpailtɨt ampune tuara. Jesústa kwail kimtu kizshimturuzne pura. Uspane Jesústa mɨmaara: —¿Nune kwaizkultu payura an intumikasha kakulninshimas? ¿Mɨn nua ɨninta, an intura kakulninnapa? Moisés pɨnkɨhta parɨtkin kwaizkultu payura kakulninna parɨt chi. ");
INSERT INTO kwi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesúsne sɨnkanara: —Kwaizkultu payura pɨriku pil kulta taiztane, ¿pɨrikura tainakna ɨmtukish? Watcha, nune pɨrikura ɨt kit tainaknazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Maza ampune pɨrikukin anza wari. Kwaizkultu payu taiztukas, mamaztuza wat kishina. ");
INSERT INTO kwi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Suasne ishtura kaizta: —Up chihtɨ nil sari. Nil sakane, mamaz chihtɨkanain wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesús ishtura kakulnintawane, Fariseo awaruzne puzat kit wanmakkat kit Jesústa piantana minñamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sun piankamtawane, Jesúsne tas puzta. Akkwan awane ussa kanpaara. Usne wan inturuza kakultanara. ");
INSERT INTO kwi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Usne usparuza kurunnara, mɨnainkas us intura kakulnintu kainammanpa. ");
INSERT INTO kwi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ñamin Isaíasne, Diospa kainammmikane, uz kit Jesúspa parat. Sun payura Jesúsne Isaías parɨt aizpa kirɨt. Isaíasne sunkana parɨt: ");
INSERT INTO kwi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anne ap kiwainmika i. Nane ussa narau. Usne na pashimtumika i. Ussa narɨt akwa, nane kwisha warish. Nane ap Sɨnam Izpul ɨninnash, ussa kiwainnapa, wan Judío awachiruza ap watsal pit kainananapa. ");
INSERT INTO kwi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Usne mɨnainkas waya kimanazi. Kwiantuchi akwa, mɨnminkas pɨpulukin ussa mɨamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tɨntachiruza kiwainanazi. We nɨjkulturuzakas tayalturuzakas kiwainanazi, us nil kimtu aizpa pailnakima. ");
INSERT INTO kwi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Akkwan Judío awachiruzne ussa tɨrizat kit nɨjkulanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Suasne awane saliz piztɨtmikara Jesús tukin karaara. Paiña kasu izsachi. Pitkas parasachi. Jesús ussa kakulnintawane, sun ampune kasu kai panintɨt. Parashina. Wat panintɨt. ");
INSERT INTO kwi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wan awane iztaspaat kit mɨmaara: “¿Usne Davidpa kwal ki? ¿Dios ɨnintamika ki?” ");
INSERT INTO kwi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo awa sun mɨnarawane, kaizara: “Saliztuza puzninamtukas, sun ampune Beelzebú akwa, saliz ɨninmika akwa, puzninnamtu,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesúsne uspa minñamtu aizpa piankamta. Suasne usne Fariseo awaruza ka kaiznara: “Ɨnintuzkas uspa kiwaintuzkas usparuzpain waya kiamɨzkane, uspane wan kaarɨnazi, uspa paimpa paimpa ɨamtu akwa. Pɨpulura uztuzkas usparuzpain waya kimɨztune, kwaltuzkas usparuzpain waya kiamɨztane, wan kaarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sunkanakas Satanáspa saliz saliztain puznintane, usparuzpain waya kiamɨzkane, wan kaarɨnazi, uspa paimpa paimpa ɨamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Une nawa Beelzebú akwa salizta puznintu kizamtu. Na sun kitne, ¿Mɨnma u kanpamtuza kiwainamtui, salizta puzninnapa? Beelzebú usparuza sun kinpa kiwainnarachi akwa, une mɨzkaiztu, Beelzebú nawa mizurainkas kiwainta chi akwa. Katmizna nilchi minñamtu. U kanpamtuzne uruza nil chi kiamtu kizanazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Diosne nawa nat kit ɨninta, paiña Sɨnam Izpul akwa saliztuza puzninnanapa. Katmizna na kamtamtu aizpa piankamtain. Diosne nawa apain ɨninta, umɨza ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ñamin yalpamikasha tɨtkasa kuhtakine, mɨnminkas paiña yalta walkwan nappasachi. Yalpamikasha kuhtnintawane, walkummikane yalta napshina, walkwan. Na Beelzebúwa yalta napta akwa, Beelzebúra kuhta akwa, nane saliztuza puzninamɨztus. ");
INSERT INTO kwi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nawa kanpamtuchimikane nawa aliz kulnazi. Ap kal kiwaintuchimikane ap kal kaninnazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Diosne chiwazha kwail kirɨttuzakas chiwazha awara kwail kaiztɨttuzakas wat kulninnanazi. Sunkana Diosne mizurainkas Sɨnam Izpulpa kwail pit kaiztumikasha wat kulmananzi. ");
INSERT INTO kwi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Diosne ampu namtɨtmikawa kwail pit kaiztumikasha wat kulninnazi. Me Diosne mizurainkas paiña Sɨnam Izpulpa kwail pit kaiztamikasha wat kulmanazi. Makas mamaz payurakas wat kulmanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tɨ pippa wakane, une wat tɨkas kwail tɨkas pian. Wat tɨne wat pippa wam. Kwail tɨne kukain pippa wam. Sunkanain wattuzne wat kiamtu. Kwailtuzne kwail kiamtu. ");
INSERT INTO kwi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Une kamtakanain mai, sula kuamtu akwa. U pit kaizara aizpa kamta pininukana mai. U kwail akwa, une wat pit paraasachi. U parakane, une ayuktas kwail minñamtu aizpa paranazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wat awane ayukta wat minñamtu aizpa paranazi. Kwail awane ayukta kwail minñamtu aizpa paranazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ilmu payu taizkane, wan awane uspa kain pit kaizara aizpa nɨjkulanazi. Sun payura Diosne usparuza ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wat pit paramturuzne uspa pit akwa naizamanazi, uspa wat awa akwa. Kwail pit paramturuzne uspa kwail pit akwa naizanazi, uspa kwail awa akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Suasne mɨnpazha Fariseoruzkas Moisés kaizta aizpa kamtamtuzkas ussa kaizara: —Kamtam, mɨri. Nu chiwazha iztasparɨt kal kika, izshipuspas, au Dios nua ɨninta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesúsne sɨnkanara: “Une, ma uztuzne, kwail awa mai. Une Diosta pashiamtuchi. Une nawa paikuamtu, iztaspat kal kinpa. Chinkas kimanash, awa izmanpa. Une Jonásta, Dios kainammmikasha, kirɨt aizpa izanazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonásne kutña payukas kutña amtakas katsa pikamta, pusunta, waara. Kawarain chiyuras Ampu namtɨtmikane kutña payukas kutña amtakas pilta kamtɨt tuanazi. ");
INSERT INTO kwi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ilmu payu taizkane, Nínive pɨpulura uztuzne ma payu uztuza kwail kiarɨmti kiznanazi. Jonás Nínive pɨpulu uztuza Dios pit kaiznakane, Nínive awane Jonás kaizta aizpa nɨjkulat kit uspa kwail kiarɨt aizpa maizat kit Diosta kaiyara. Nane Jonáskin anza tɨnta ish. Une nawa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ilmu payu taizkane, Sabane, attish suras ashampa mikwane ma uztuza kwail kiarɨmti kiznanazi. Sun ashampane Salomón tukin ɨt, us wat pian aizpa mɨna. Nane Salomónkin anza tɨnta ish. Me une na kaiztu aizpa mɨashimtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Maza saliz awaras puzkane, salizne pilchiwara saimtu cha, kwaizkulna. Kwaizkulna wanmaltakine, ");
INSERT INTO kwi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sun awarain kailtɨnash mintu. Sun awarain kailshitne, sun awara wanmal kit ussa iztu. Mɨnminkas mama ussa piztachi. Yal charalkanain iztɨt uz. Usne pishkarɨt yalkana iztɨt. Ayukmal watsal iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Suasne salizne ɨt kit siete anza kwail saliztuza kana ɨmtu, ussa pizanapa, sua uzanapa. Kwiztane sun ampune an anza kwail uznazi. Kawarain ma payu uztuzne an ñanchakin anza kwail uzanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús awaruza paranamtuasmin, paiña akkuhshkas aimpihshtuzkas piannaara. Uspane yal pianamal nukkulat kit uskasa kwinta kishiara. ");
INSERT INTO kwi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mɨnpazha Jesústa kaizara: —Up akkuhshkas up aimpihshtuzkas pianamal pura. Nukasa kwinta kishiamtui, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesúsne ussa sɨnkat kit mɨmara. —¿Mɨnma ap akkwa i? ¿Mɨnma ap aña i? kizta. ");
INSERT INTO kwi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Suasne Jesúsne paiña kammuruza chihtɨ annat kit kaiznara: —Uspane ap akkwakanain mai. Uspane ap añakanain mai. ");
INSERT INTO kwi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ap chiyuras Taitta pashimtu aizpa kimtumikane ap akkwakanain i, ap añakanain i, ap kuakanain i, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sun payuin Jesúsne yaltas puz kit pimakin at kit uzta. ");
INSERT INTO kwi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Akkwan awa us tukin wanmakkamtuasmin, Jesúsne kanuara wat kit uzta. Wan awane pi ksukin uzara. ");
INSERT INTO kwi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Suasne Jesúsne akkwan kamtam kwintakasa ka kwinta kinara: “Pippa malmumikane pippa malna puzmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Malmɨztuasmin, akkwan pippa chine mimakin taizara. Suasne chitchu aat kit sakkat kit kuara. ");
INSERT INTO kwi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Anpa pippane uktainkas akkwan ainkih pilchirainkas taizara. Akkwan pil chi akwa, pippane azain chikkara. ");
INSERT INTO kwi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pãn malkane, tɨne pul pat kit iarɨt, mujtɨt waj chi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Anpa pippane pu tɨkin taizara. Pu pippane chikkat kit mamaz pippara ɨsal ipta, wamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Anpa pippane wat pilpara taizat kit akkwan pippa waara. Anpa tɨne cien pippakima waara. Anpa tɨne sesenta pippakima waara. Anpa tɨne treinta pippakimain waara. ");
INSERT INTO kwi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na kaizta aizpa piankamshitne, piankamtain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kwiztane kammuruzne Jesústakin kasha ɨat kit ussa mɨmaara: “¿Chikitma awaruza kamtam kwintakasa paramtus?” ");
INSERT INTO kwi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Usne sɨnkanara: “Diosne uruza impara imparain us kamtɨt aizpa piankamninnamtu. Mamaztuzne us kamtamtu aizpa piankamamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Diosne piantuza kiwainanazi, an akkwan piankamanapa. Na kaizta aizpa mɨmtuchiruzne us pitchin piankamtu aizpa karɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Katmizna kamtam kwintakasa usparuza paranamtus. Yawa na kimtu aizpa izamtukas, uspane nawa mɨashimtuchi. Yawa na kaizta aizpa mɨamtukas, uspane piankamashimtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaíasne, Dios kainammmikane, sun awa kiamtu aizpa ka parɨt: ‘Sun pit watcha mɨrakas, une mɨamanazi. Wan kiarɨt aizpa iztakas, une piankammanazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sun awane Dios kaizta aizpa mɨashimtuchi. Uspa kail sɨptɨtkana akwa, uspane nawa nɨjkulamanazi. Uspane nawa kaiyamanazi, na usparuza kakulninnanapa, uspa kwail wat kulanapa.’ ");
INSERT INTO kwi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na kit aizpa izamtu akwa, umin mɨat kit wat uzanazi. Na kaizta aizpa mɨamtu akwa, umin piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Watcha kaiznamtus. Akkwan Dios pit kainammtuzkas wat awaruzkas an payura u izamtu aizpa izashiara. Uspane sun izarachi. Uspane u mɨamtu aizpa mɨshiara. Uspane sun mɨarachi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mane une pippa maltu kamtam kwinta mɨrain, piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nane sun kamtam kwinta kwinta kinamtu, u miza Dios awaruza ɨninnamtu piankamanapa. Dios pit mɨamtukas, uspane Dios kaizta aizpa mɨmtuchiruzkana mai. Suasne Diablone amtu, pippa warɨt aizpa nakannapa, Dios pit kamtara aizpa mɨamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mamaztuzne pippa uk pilpara taizarakanain mai. Sun pit mɨarawane, uspane sun pit sappat kit wat kulat kit sun pit kishiara. ");
INSERT INTO kwi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wat mɨarachi akwa, sun awane akkwan payukima tailchaamtuchi. Sun pit akwa naizamtune, uspane an nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sun pit kwayamtɨmtu. Mamaztuzne pippa pu patmukin taiztakanain mai. Sun pit mɨamtukas, uspane pailta payu usparuzpain minñat kit usparuzpa kal kiamtu. Pãn kulshiamɨztu. Katmizna sun pit mɨara aizpa usparuza wat uzna kiwainnamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mamaztuzne pippa wat pilkin taiztakanain mai. Sun pit mɨarawane, uspane wat piankamara. Mɨararuzne nil uzshiat kit wat kishiamɨztu. Uspane wat pippakanain mai. Wat pippane cien pippakima puzta. Anpane sesenta pippakimain puzta. Anpane treinta pippakimain puzta.” ");
INSERT INTO kwi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kwiztane Jesúsne mamaz kamtam kwinta ka kwinta kinara: “Une Dios an sura uztuza ɨninnamtu piankamtain. Sunkana usne ɨninnamtu. Ampune nan pilta wat pippa malta. ");
INSERT INTO kwi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Maza amta pittamtuasmin, aliz awane at kit chara pippakin kwail pippa wat kit ɨt. ");
INSERT INTO kwi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chara pippa chikkakane, pippa kwizakane, parejuin kwail tɨ pippakas kwizara. ");
INSERT INTO kwi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Suasne sun izarawane, kiwainaruzne pamikara ɨat kit kaizara: ‘Anpat up nanmal maltane, aune wat pippa malwiznash. ¿Mizamaka kwail tɨkas chara pippa tɨkas puzamtu?’ mɨmaamtu. ");
INSERT INTO kwi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pamikane kaiznara: ‘Mɨnpazha nawa aliz awa sun wara.’ Suasne kiwainturuzne an mɨmaara: ‘¿Kwail tɨ puhsnawizna?’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Usne sɨnkanara: ‘Ma puhsnachi. Kwail tɨ puhstane, parejuin chara tɨkas puhsshina. ");
INSERT INTO kwi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Parejuin chiknintawa, paknakima. Suasne kal kimtuza ɨninnanash, kwail tɨ an ñancha pakkanapa. Kwail tɨ pippa paktawane, wanku sat kit ĩnta paktana ɨninnash. Kwiztane wat tɨ pak kit watsamkin watsanpa ɨninnash.’ ” ");
INSERT INTO kwi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesúsne mamaz kamtam kwinta kwinta kinara: “Diosne apa sunkana ɨninnamtu. Maza ampune paiña nan sura mostaza pippa wana ɨt. ");
INSERT INTO kwi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","An pippane ainki i. Sun pippa wara chikkane, tɨne mamaz tɨkin an katsa kawirɨmtu. Chitchune sun tɨ tailpurakin aat kit yal saamtu.” ");
INSERT INTO kwi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesúsne mamaz kamtam kwinta kwinta kinara: “Diosne apa sunkana ɨninnamtu. Maza ashampane pan sashimɨztu, kutña waz chara pippa kɨrɨtkasa. Usne kiñakanain winta, wan sulnapa.” ");
INSERT INTO kwi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesúsne kammuruza kamtam kwintakasain kwinta kinamɨzta. Awaruza kamtanamtuasmin, usne kamtam kwintain paranamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jesúsne Dios kainammmika para aizpa kirɨt. Sunkana parɨt: “Nane awaruza kamtam kwintakasa kwinta kinanash. Dios an su sarasmin, Diosne makima sun kamtam watsarɨt mɨj. Mane nane sun kamtam kwinta kinanash.” ");
INSERT INTO kwi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Suasne Jesúsne awara “ɨru” kiz kit yalta napta. Kammuruz ussa kasha aakane, ussa ka kaizara: “Aumɨza kwail pippa chikta kamtam kwinta piankamninchain,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Suasne Jesúsne kammuruza kaiznara: “Nane, Dios Painkulne, wat pippa wammikane, ish. ");
INSERT INTO kwi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nan sune au sukana i. Wat pippane Dios ɨninturuzkana mai. ");
INSERT INTO kwi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kwail pippane aliz awakana mai. Kwail pippa wammikane Diablo i. Pakta payune minpa payukana i. Sun payura wan pailtɨnazi. Pakmuruzne ángelkana mai. ");
INSERT INTO kwi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pakmuruzne kwail tɨ nakkaat kit ĩnta kiaintu, impaktanapa. Wan payu pailka, sunkanain kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dios Painkulne paiña ɨnintukish paiña ángeltuza ɨninnanazi, mamaztuza kwail kininturuzakas kwail kimturuzakas wanmakninnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Usne usparuza ĩnta kiakpɨnanazi. Suane uspane azat kit sula sɨt sɨt kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Suasne kwiztane Dios kaizta aizpa kimturuzne Papihsh ɨnintukin uzanazi. Uspane Dios iztukin wat kianat kit pãn aiztukanain puranazi. Na kaizta aizpa mɨrain.” ");
INSERT INTO kwi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Dios ɨnintukin uztumikane akkwan puintɨt pial pilta sairamikana i. Sun puintɨt pial sairawane, an ampune suain mamasa puina ɨmtu. Watsal ɨmtuasmin, usne wan mɨj aizpa painin kit sun su paintu, puintɨt pial ukkana.” ");
INSERT INTO kwi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Dios ɨnintukin uztumikane watsal in saimtumikakana i. ");
INSERT INTO kwi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kwisha muin in wanmaltawane, usne wan mɨj aizpa painin kit sun in paintu.” ");
INSERT INTO kwi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dios ɨnintukin uzturuzne pishkarukanain mai. Sulmuruzne sulmura pira kiain kit akkwan tuntu pishkaru sulamtu. ");
INSERT INTO kwi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pishkaru sulmukasa sulkane, sulmuruzne sulmu piras tainaktu, pi ksurakima. Suasne uspane uzat kit pishkaru naantu. Uspane wat pishkarune tɨmta win kit watsam. Kwailne kiakpɨntu. ");
INSERT INTO kwi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Minpa payura sunkanain kinazi. Ángeltuzne chiyuras puzat kit kwailtuzakas wattuzakas paimpa nanazi. ");
INSERT INTO kwi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Uspane kwailtuza ĩnta kiakpɨnnanazi. Suane azat kit sula sɨt sɨt kianazi.” ");
INSERT INTO kwi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesúsne mɨmanara: —¿Une sun kamtam wan mɨamtukiwas? Uspane sɨnkaara: —Watcha. Mɨanash, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Suasne Jesúsne kaiznara: —Dios pit kammumikane Diospa piankamtu. Sun Dios ɨnintukin uztumikane paiña ɨninmika kamtamtu aizpa piankamnazi. Suasne usne yalpa mikakana namnazi. Yalpamikane masas kamtamkas an ña kamtamkas us watsarɨt aizpa kamtana ukkashina. ");
INSERT INTO kwi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wan kamtam kwinta kainanarawane, Jesúsne suas ɨt ");
INSERT INTO kwi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kit paiña sura, Nazaret pɨpulura, piannat. Suane Jesúsne Judío kammu yalta kamtanamɨzta. Awa iztaspaarɨt akwa, awane usparuzpain mɨmaara: —Sun ampune sun pian aizpa ¿mɨnta kamta? Sun ampune sun iztasparɨt kal kimtu aizpa ¿Miza ka kimtu? kizara. ");
INSERT INTO kwi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Usne tɨ kihtmumikawa painkul i. Paiña akkuhshne María mun i. Santiagokas Josékas Simónkas Judaskas paiña aimpihshtuzpain mai. ");
INSERT INTO kwi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Paiña kwampihshtuzkas aukasa uzamtu. Usne ¿mɨnta wan kamta? ");
INSERT INTO kwi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Katmizna uspane us kaizta aizpa mɨashitchi. Me Jesúsne kaiznara: —Diosne kainammika mamaz suras akane, awane ussa wat minñamtu. Dios kainammika paiña suras akane, sun pɨpulura uztuzne ussa an wekas minñamtu. Paiña yalta uztuzne ussa an we minñamtu. ");
INSERT INTO kwi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Katmizna Jesúsne sun pɨpulura akkwan iztasparɨt kal kitchi, uspa ussa wat nɨjkularachi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sun payune Herodesne Jesúspa mɨra. Usne Galilea sura ɨnin kit ");
INSERT INTO kwi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","paiña kiwaintuza kaiznara: “Anne Juan munnammika i. Usne irɨttas kuhsta. Katmizna usne an iztasparɨt kal kimɨzta,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ñamin Herodesne Juanta pizna ɨninta, ussa kuh kit kajchira sɨpna. Herodeskas Felipekas aimpihshtuzpain azi. Herodesne paiña aimpihshpa ashampara mɨltɨt. Sun ashampane Herodías muntɨt. Herodías akwa Herodesne Juanta sɨpninta. Juanne Herodesta kaiztɨt: “Sun ashampara, up kwiñara, mɨlnachi,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Juanta piantashimtukas, Herodesne ussa piantarachi, awa ishkumtu akwa. Wan awane Juan Dios kainammmika azi minñara. ");
INSERT INTO kwi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodespa año kapal pishta taizkane, Herodíaspa pashune akwattuza iztakin puz kit kukin ɨrɨt. Herodesne wari min kit ");
INSERT INTO kwi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nimpihsh ashampara kaizta: “Nane nu chiwazha paikumtu aizpa Dios iztakin nua mɨlan namtus,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nimpihsh ashampane akkuhshta kwinta kin ɨt. Akkuhsh ussa kurunkane, nimpihsh ashampane Herodesta kaizta: “Mamazta ɨninti, Juan munammikawa kɨzpu pɨlattukin karanpa,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sun pit mɨrawane, Herodesne tayalta. Tayaltukas, usne us paikwat aizpa mɨlat. Pishta akwattuz us mɨlan namta aizpa mɨara akwa, Herodesne mamaztuza ɨninnara, us paikwara aizpa kin. ");
INSERT INTO kwi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Suasne usne mamazta kajchira ɨninta, Juanpa kɨzpura tɨtnapa. ");
INSERT INTO kwi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Suasne uspane pɨlattura karaat kit nimpihsh ashampara mɨlaara. Usne akkuhshta chɨhkara. ");
INSERT INTO kwi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Suasne Juanpa kammuruzne aat kit irɨtta muat kit pilta kamaara. Kwiztane Jesústa kainana ɨara. ");
INSERT INTO kwi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sun mɨrawane, Jesúsne tas puz kit kanuara wat kit pul sura ɨrɨt. Mazainpain ɨrɨt. Jesúspa tukin piankamarawane, awane pɨpulukis puzat kit mittɨwara pimawara us tukin ɨamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kanuakis kihshtawane, Jesúsne akkwan awara iznara. Usne usparuza kiwainshinat kit intuza kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tɨl pamɨzkane, nashmɨzkane, Jesúspa kammuruzne us tukin aat kit kaizara: —Nashtɨmtui. Akkine mɨnminkas uzchi. Awaruza pɨpulura ɨrain kiznari, chiwazha painapa kwan. ");
INSERT INTO kwi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesúsne sɨnkanara: —Usparuza ɨninman. Umin usparuza kwinnari, kuanapa. ");
INSERT INTO kwi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Uspane kaizara: —Akkine aune cinco panminkas paas pishkaruinkas mɨjmakpas. ");
INSERT INTO kwi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesúsne kaiznara: —U mɨj aizpa nawa kararain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Suasne Jesúsne awaruza pɨtkin uzanapa ɨninnara. Suasne usne cinco pankas paas pishkarukas sap kit chiyura izak kit Diosta aishtaish kizta. Kwiztane pankas pishkarukas kɨz kit kammuruza mɨlanara. Uspane awaruza nailnara. ");
INSERT INTO kwi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wan kuat kit tukkarɨt. Kwatpane, uspane pitti pitti tiztɨt sakkat kit doce tɨmta winñara. ");
INSERT INTO kwi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cinco mil ampune kuara. Ashamparuzkas pashparuzkas wiantachin kuara. ");
INSERT INTO kwi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Suasne Jesúsne kammuruza kanuara waanapa ɨninnara, an ñancha pi kwakara piannaanapa. Ɨamtuasmin, Jesúsne awaruza ɨru kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Usparuza “ɨru” kiznarawane, usmin malta nura, Diosta paikwan. ");
INSERT INTO kwi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tɨl pamɨzkane, us suain nukkultuasmin, kammuruzne kanuawara pi paizkakin ɨamtuazi. Ɨamtuasmin, katsa tɨnta inkwa kanuara nuppainmɨzta. Pine tɨnta palakpɨntu. ");
INSERT INTO kwi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tɨlawain Jesúsne uspa tukin ɨt. Pi ɨsalparain mittɨwara ɨmtuazi. ");
INSERT INTO kwi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Uspa tukin pianamtuasmin, kammuruzne ussa pi ɨsalpara chamtu izara. Uspane ishkuat kit kwianara: —Irɨt izpul izpuspas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Suasne Jesúsne usparuza parat kit kaiznara: —Une tɨnta kultain. Na ish. Ishkuman. ");
INSERT INTO kwi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Suasne Pedrone sɨnkara: —Anpat. ¿Nu kish? Nu sua chamtuasmin, nawa chanpa ɨnincha, nu kuntakima, pi ɨsalpara ɨn. ");
INSERT INTO kwi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesúsne kaizta: —Nawa at, kizta. Pedrone kanuaras kihsh kit pi ɨsalpara ɨmɨzta, Jesús kuntakima. ");
INSERT INTO kwi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kwisha tɨnta inkwa iztuasmin, Pedrone ishkwat kit pira unainmɨz kit ka kwianmɨzta: —Anpat kiwaincha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɨrattuin Jesúsne ussa piz kit tainak kit kaizta: —¿Chitma nawa wat nɨjkulmas? ");
INSERT INTO kwi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kanuara nuilkane, inkwane pamtuchi parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Suasne kanua waruzne Jesús iztukin wakpuj wainñat kit kaizara: —Watcha. Nune Dios Painkul i, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Uspane pi kwakkat kit Genesaret sura pianaara. ");
INSERT INTO kwi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sun suras awa Jesúspa piankamarawane, uspane wan awaruza Jesús pianarɨt kainanara. Piankamarawane, uspane Jesús tukin imturuza karaara. ");
INSERT INTO kwi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Uspane Jesústa paikuara, ishturuz paiña pĩnkin paanapa. Wan paiña pĩnkin paararuzne kakularɨt. ");
INSERT INTO kwi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Suasne mɨnpazha Fariseo awaruzkas Moisés kaizta aizpa kamtamtuzkas Jerusalén pɨpuluras puzat kit Jesústa tukin aat kit mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Up kammuruzne ¿Chikishma ñamin iarɨt kamtamtuz kainara aizpa mɨamtuchi? Kuamɨztune, uspane chihtɨ kittarazi, uspa kwail kiarɨt aizpa kihana. ");
INSERT INTO kwi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesúsne sɨnkanat kit mɨmanara: —Une ¿Chikishma Dios kaizta aizpa mɨamtuchi? Umin u ɨlaparuz manta kiamtu aizpa minñamtu, Dios uruza manta kinamtu aizpa kiamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosne awaruza ɨninnat kit ka kaiznara: “Une papihshtakas akkuhshtakas wat nɨjkulat kit wat kiarawa.” Kawarain “Mɨnpazha papihshtakas akkuhshtakas kwail paramtune, awa ussa piantarawa, inapa.” ");
INSERT INTO kwi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kancha umin papihshtuzpakas akkuhshtuzpakas ka kamtanamtu: “Papihshtakas akkuhshtakas mɨlanashimtukine, une ka kizarawa: ‘Nane na papihshtakas akkuhshtakas mɨlasachish, na wan mɨj aizpa Diosta mɨlat akwa.’ ");
INSERT INTO kwi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","U sun kamtamtu akwa, une ‘au papihshtuzakas au akkuhshtuzakas kiwainsachimakpas’ minñamtu. U sunkana kamtaamtune, u kwalta kiwaintuchine, une Dios manta kimtu aizpa kiamtuchi. U ɨlaparuz kamtanamtu aizpa mɨashimtu akwa, une kwail kiamtu. ");
INSERT INTO kwi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","U papihshtakas u akkuhshtakas kiwainamtuchi akwa, une we nɨjkulamtu, Dios kaizta aizpa kiamtuchi akwa. Isaíasne, Dios kainammmikane, ñamin uruzpa nil kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘An awa uspa pitkasain nawa wat kizamtukas, uspane nawa wat nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nawa wakpuj wainñamtukas, uspane nawa piankamamtuchi. Kamtanamtuasmin, uspane “au kamtamne Diospa kamtam i” kizamtu. Sunkana chi. Uspane uspain kamtam kamtanamtu.’ ” ");
INSERT INTO kwi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sun kiztawane, Jesúsne akkwan awaruza wanmakninnat kit kaiznara: —Na kaiztu aizpa mɨrain, piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chiwazha kumira kumtukas, kumira kumtumikasha kwail namninmanazi. Me kwail pit kaiztamikane kwail kimmikakana namnazi. ");
INSERT INTO kwi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Suasne Jesúspa kammuruzne us tukin aat kit kaizara; —Nu kaizta aizpa akwa, Fariseo awane nukasa aliz kulaarɨt. ¿Sun piankamtukish? kizara. ");
INSERT INTO kwi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Usne sɨnkanara: —Ap chiyuras Taittane paiña kamtam chɨhkanara. Usne nil chi kamtamtuzakas nilchi nɨjkultuzakas pailnintɨnazi. Awane usparuza kwail tɨkana puhstɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Usparuza kurunnaman. Sun we pian kamtamtuzne mamaz we piantuza kamtanamtu. Wan karɨnazi. Sun kwail kamtamtuzne kasu izsachiruzkana mai. Kasu izsachimika kai izsachimikasha taintane, paasas kulkin taiziltɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedrone Jesústa kaizta: —An kamtam kwinta aumɨza piankamninchain. ");
INSERT INTO kwi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesúsne mɨmanara: —Une we piankaamtu. ¿Une mɨsachimakkiwas? ");
INSERT INTO kwi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Kumira kwat aizpa pianchimakkiwas? Wan kumira kwat aizpa pusunmal wa. Kwiztane awaras puztu. ");
INSERT INTO kwi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Awa chiwazha ayuk kaijchira minñamtukas, kwiztane awane pitkasa paramtu. Kwail pit kaiztamikane kwail kimtu. ");
INSERT INTO kwi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wan kwailne kaijchuras puzamtu. Kwail mintumikakas, awara piantamtumikakas, mamazpa ashampakasa pittumikakas mamazpa ampukasa pittumikakas, walkumtumikakas, pɨrail kaiztumikakas, mamazta kwail pit paramtumikakas kaijchukin min kit chiwazha kwail kimtu. ");
INSERT INTO kwi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sunpawa kwail kimtumikane, Dios iztakin kwail kit kit ayukta sɨnam chi namnazi. Chihtɨ kittuchi kwatmikane Dios iztakin kwail kimtuchi. Usne ayukta sɨnam i. ");
INSERT INTO kwi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tas puztawane, Jesúsne mamaz sura ɨt kit Tiro pɨpulurakas Sidón pɨpulurakas pianara. ");
INSERT INTO kwi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cananea suras ashampane sun sura uzta. Usne Judío awa chi. Usne Jesús tukin ɨt kit ka kwianta: —Anpat. Nawa mɨzha. Nune ñamin ɨnintamika Davidpa kwal i. Nawa kiwaincha. Kwail saliz ap pashura pizta akwa, ap pashune kwisha naizmɨztui, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesúsne ussa sɨnkarachi. Suasne paiña kammuruzne Jesústa aat kit ka paikuara: —An ashampa paiña pashu akwa paikumtu akwa, us paikumtu aizpa kit kit ussa attishta ɨninti. Usne au kwizpa tɨnta kwiantu. ");
INSERT INTO kwi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Suasne Jesúsne an ashampara kaizta: —Diosne nawa Israel awaruza ɨninta. Uspane pɨriku karɨtuzkanain uzamtu, pɨriku izmumika mɨjchi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ashampane kasha ɨt kit us iztakin wakpuj wain kit kaizta: —Anpat mɨzha. Kiwaincha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesúsne ussa sɨnkara: —Nane Judío awaruza kiwainarawash. Sunkana pashpawa kumira nakasachish, kwizaruza kwinna. Kawarain nane Judío awaruza kiwainnarawash, Judío awachiruza kiwainnarachin. ");
INSERT INTO kwi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Usne kaizta: —Watcha Anpat. Nu watcha i kaiztukas, kwizakas pamikawa misharɨras pak taizka sak kit kum. Sunkana, na Judío awachi akwa, nawa pitchin kiwaincha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Suasne Jesúsne ussa kaizta: —Ashampa mɨzha. Nu kwisha wat nɨjkultɨt akwa, nu pashimtu aizpa kinash, kizta. Sun urain paiña pashune kakultɨt. ");
INSERT INTO kwi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesúsne tas puz kit Galilea pimamin pianara. Kwiztane maza ɨzara nut kit sua uzta. ");
INSERT INTO kwi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kwisha akkwan awane us tukin aara. Uspane chasachiruzakas kasu izsachiruzakas pit parasachiruzakas sail puil patturuzakas pimpul kwail mɨjtuzakas an akkwan inturuzakas karaara, Jesús kakulninnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jesús kit aizpa izarawane, awa sun izararuzne iztaspaarɨt. Pit parasachiruzakas paraara. Sail puil patturuzne wat parɨt. Chasachiruzne chaara. Kasu izsachiruzne izara. Watsal iztasparɨt kal izarɨt akwa, uspane Israel awawa Dios kwisha wari kizamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Suasne Jesúsne kammuruza akwanat kit kaiznara: —An awane nakasa kutña payukima chaamtu. Mane uspa kumira mɨjchi akwa, kiwainashimtus. Nane usparuzpa yalta ɨninnashimtuchish, uspa kumira kwatchi akwa, miwara najarɨn akwa. ");
INSERT INTO kwi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Suasne paiña kammuruzne mɨmara. Apain akkwan awa uzamtuchi akwa, —¿Mɨntama kumira sayanapai? An sukinne mɨnminkas uz chi, chiwazha paina, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúsne mɨmanara: —Une ¿Yawa pan mɨjmakpas? kiznara. Uspane kaizara: —Siete pankas akkwan pishkaruchikas mɨjmakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Suasne Jesúsne awaruza ɨninnara, pilta uzanapa. ");
INSERT INTO kwi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Usne siete pankas pishkarukas sap kit Diosta aishtaish kizta. Suasne kɨz kit kammuruza nailnara. Uspane awaruza nailnara. ");
INSERT INTO kwi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wanne tuktakima kuat. Wan kwatpane, uspane tiztɨt aizpa siete tɨmta winñara. ");
INSERT INTO kwi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ampara mil ampune kuara. Ashampakas pashpakas winñamtachin kuara. ");
INSERT INTO kwi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kwiztane Jesús awara “ɨru” kiz kit kanuara wat kit Magdala sura ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo awakas Saduceo awakas Jesústa ɨat kit paikuara, chiwazha chiyuras iztaspat kal kinpa. Us iztasparɨt kal kikane, uspane ussa kwail kimtu kizshiara, awa us akwa kwail minñanapa. ");
INSERT INTO kwi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesúsne usparuza sɨnkanara: “Nashmɨzkane, kwanam parɨkane, une ‘tɨlawa watsal kɨnnazi,’ kizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɨnmɨzkane, ‘Une mane kwail payu anpai’ kizamtu, ‘wanish sɨptɨt akwa, chiyu kwanam iztɨt akwa.’ U chiyura kimtu aizpa wat piankas, une ma payu na kimtu aizpa wat piankamasachi. ");
INSERT INTO kwi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","U kwail awa chiyuras iztasparɨt kal izshiamtukas, une Diosta an wat piankamashitchi. Diosta kanpaashimtuchi akwa, une kwail cha ashampakana chaamtu. Mane iztaspat kal u iztukin kimanash. Une mamaz tuntu kal izanazi. Une Jonásta kit aizpakana izanazi.” Suasne Jesúsne awaras ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pi kwakkarawane, kammuruzne pan mɨlna mainñarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Suasne Jesúsne kaiznara: —Fariseo kamtamtu aizpakas Saduceo kamtamtu aizpakas kwiraruin. Uspa kamtamtu aizpa kiñakana i. Kiñane chiwazha sulnin kit wan chiwal maiznamtu. ");
INSERT INTO kwi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Suasne kammuruzne usparuzpain kaizamɨzta: —Au pan karatchi akwa, Jesúsne sunkana kaiztu. ");
INSERT INTO kwi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesúsne uspa minñamtu aizpa nɨjkul kit kaiznara: —¿Chikishma pan karazamanas kizamtuas? Une nawa wat nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Na kaizta aizpa wat mɨmtuchimakkiwas? Nane cinco pankasain cinco mil awara nailnarau. ¿Yawa pak tiztɨt tɨmta winñara? ¿Nɨjkultuchimakkiwas? ");
INSERT INTO kwi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nane siete pankasa ampara mil awara nailnarau. ¿Yawa pak tiztɨt tɨmta winñara? ¿Nɨjkultuchimakkiwas? ");
INSERT INTO kwi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Mizama na kaizta aizpa nɨjkulamtuchi? Nane panpa paramtuchish. Kiñawa paramtuchish. Nane Fariseo kamtamtu aizpakas Saduceo kamtamtu aizpakas paramtus, u uspa kamtaamtu aizpa kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Suasne kammuruzne Jesús kaizta aizpa piankamarɨt. Jesúsne panpa kiña kamtanarachi. Usne Fariseo kamtampakas Saduceo kamtampakas kamtanara, uspa kamtamtu aizpa kiamanpa. Kuiraruin. ");
INSERT INTO kwi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Filipowa Cesarea sura pianatpane, Jesúsne kammuruza mɨmanara: —Awane ampu namtɨtmikawa paraamtu. Uspane ¿nane mɨnma i kizamtu? ");
INSERT INTO kwi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Uspane sɨnkaara: —Mɨnpazha nune Juan munnammika i kizamtu. Mamaztuzne “nune Elías, ñamin Dios kainammmika i” kizamtu. Mamaztuzne nune Jeremías, ñamin Dios kainammmika, i kizamtu. Mɨnpazha “nune mamaz ñamin uztamika, Dios pit kainammmika i” kizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Suasne Jesúsne mɨmanara: —Une ¿Chima minmuspas? Nane ¿mɨnma ish? ");
INSERT INTO kwi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Suasne Pedrone kaizta: —Nune Dios nɨrɨtmika i. Nune Cristo muntɨtmika i. Nune chiyuras Dios Painkul i, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesúsne Pedrora, Jonáspa painkulta, sɨnkara: —Nune watsal kianazi. Mɨnminkas nu pian aizpa nɨjkulnintachi. Ap chiyuras Taittain sunmin nua nɨjkulninta. ");
INSERT INTO kwi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nane up mun maizninnash. Ñamin nune Simón muntɨt. Nu nawa kaizta akwa, nane makis nua Pedro munnintus. Nu tɨnta akwa, mɨnminkas nua maizsachi. Nane wan nawa piantuzakas wan na kamtamtu aizpa mɨmturuzakas kiwainnanash, na kaizta aizpa nɨjkulanapa, an kamtam akwa tɨnta ukkana namanapa. Uspa purakis wan ĩnkin saliztuzne nawa piantuza anuppasachi. ");
INSERT INTO kwi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nane nua ɨninmika namninnash, Dios kaizta aizpa mɨmturuza kurunnanapa, nu Dios akwa parananapa. Nune awaruza chiwazha wat aizpakas chiwazha kwail aizpakas kamtananazi. Nu wat kimturuza u wat kiamtu kiznarane, Dioskas sunkana kiznazi. Nu kwail kimtuza u kwail kiamtu kiznarane, Dioskas sunkana kiznazi. ");
INSERT INTO kwi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Suasne Jesúsne kammuruza ka kurunnara: —Mɨnainkas “nane Dios nɨrɨtmika ish” kizman. ");
INSERT INTO kwi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sun payuin Jesúsne paiña kammuruza “nane Jerusalén pɨpulura ɨrɨnash” kainanamɨzta. “Judío ɨlaparuzkas katsa pariya ɨnintuzkas Moisés parɨt aizpa kamtamtuzkas nawa kwisha naizninanazi. Uspa nawa piantarawane, nane kutña payura irɨttas kuhsnash.” ");
INSERT INTO kwi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedrone Jesústa paimpa mit kit tɨnta pilchapuz kit kaizta: —Nu kaizta aizpa kaizmun. Nu kaizta aizpa nua kimanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesúsne puijchat kit Pedrora kaizta: —Nakis paimpa ɨri. Nune Satanáskana mintu. Nune nawa kiwaintuchi, Dios pashimtu aizpa kin. Nu awakana mintu akwa, nune Dios mintukana mintuchi. ");
INSERT INTO kwi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Suasne Jesúsne kammuruza kaiznara: —Mɨnpazha nawa kanpammika namshitne, usne usmin pashit aizpakin maintawa, Dios pashimtu aizpa kin. Naiztukas, kurishta irɨmtukas, usne nawa kanpamɨztawa. ");
INSERT INTO kwi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nawa kanpashitchimikakas au sura watmin uzshitmikakas paiña izpul karɨnazi. Na akwa irɨtmikakas, na akwa uzshitmikakas, paiña izpul kamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mɨnpazha wan sukin pura aizpa kana kitkas, izpul karɨtmikane chinkas mɨjchianazi. Kwazpamikane paiña izpul watsat mɨlnana pial tasachi. ");
INSERT INTO kwi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nane, Ampu namtɨtmikane, chiyuras anash. Na akane, ap Papihshne nawa paiña ángeltuzakas ɨninnanazi. Usne nawa piantuza chiwazha mɨlam tananazi. Ap kal kimturuzne sun mɨlam sappanazi. ");
INSERT INTO kwi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Watcha kaiznamtus. Mɨnpazha ma payu uztuzne iamanazi, Ampu namtɨtmika awaruza ɨninnamtu izanakima. Usne katsa mikwakana iztɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis payu pailkane, Jesúsne Pedrorakas Santiagorakas Juantakas, paas aimpihsh parain, paimpa akwanat kit kwash ɨzarakima minara. ");
INSERT INTO kwi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Suane usne uspa iztakin mamaz tuntukanain maiztɨt. Paiña matsɨhne pãn naztamkana malta. Paiña kwaksham impilkanain putchã iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Masain uspane Moiséstakas Elíastakas izara. Uspa paas Jesúskasa kwinta kiamtazi. ");
INSERT INTO kwi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedrone Jesústa kaizta: “Anpat, kwisha wat tumakpas akkine. Nu pashitne, nane kutña ainki yal sanash. Mazane up, mazane Moiséspa, mazane Elíaspa.” ");
INSERT INTO kwi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro paramtuasmin, naztam wanish taiz kit usparuza sɨpnara. Diosne wanishkin kaiznara: “Anne ap painkul i. Ussa kwisha pashimtus. Usne ap narɨtmika i. Us kimtu aizpa wari pianish. Us kaiztu aizpa mɨrain.” ");
INSERT INTO kwi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sun mɨrawane, kwisha ishkuamtu akwa, paiña kammuruzne matsɨh pilta wainñara. ");
INSERT INTO kwi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Suasne Jesúsne uspa purakin ɨt kit usparuza panat kit kaiznara. “Kuhsaktain. Ishkuman,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kasu izkulakane, uspane mɨnainkas izarachi. Jesústain izara. ");
INSERT INTO kwi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kwash ɨzaras kihshamtuasmin, Jesúsne ka kurunnara: —U izara aizpa mɨnainkas kainamman, Ampu namtɨtmika irɨttas kuhsnakima. ");
INSERT INTO kwi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Katmizna paiña kammuruzne Jesústa mɨmaara: —Moisés parɨt aizpa kamtamtuzne “Elías Cristokin, Ampu namtɨtmikakin, an ñancha anazi” kizamtu. ¿Chikishma sun kizamti? ");
INSERT INTO kwi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesúsne sɨnkanara: —Watcha, Elíasne an ñancha atmika azi. Usne awaruza kurunnanazi, wan watsananapa. ");
INSERT INTO kwi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nane kaiznamtus. Awa ussa piankamarachikas, Elíasne me arɨt. Uspane uspa kwail kishiarɨt aizpa ussa kiarɨt. Sunkanain awane Ampu namtɨtmikasha naizninat kit piantanazi. ");
INSERT INTO kwi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Suasne paiña kammuruzne Jesús Juan munnammikawa kaizta piankaamara. ");
INSERT INTO kwi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Awa purakin piannaakane, maza ampune Jesústa at kit us panakin wain kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Anpat. Ap painkulta kiwainti. Usne ul kit kwisha naizmɨztu. Kwisha akkwan pijikima ĩntakas pirakas taizta. ");
INSERT INTO kwi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na up kammuruza karanarakas, uspane ussa kakulnintachi. ");
INSERT INTO kwi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesúsne wan awaruza kaiznara: —Une mama nawa nɨjkulamtuchi. Une watcha piankamashitchi. Nane ukasa akkwan payuchin uznash. Uruza tailchasachish. Up painkulta apa nawa karat, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sun urain Jesúsne salizta tɨnta kaiz kit ɨnin kit pashparas puzninta. Sun urain wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kwiztane kammuruzne Jesúskasa paimpa kwinta kiat kit ka mɨmaara: —¿Chitma aune saliz puzninsachimakpas? kizara. ");
INSERT INTO kwi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Usne sɨnkanara: —Nawa we nɨjlulamtu akwa, une salizta puzninsachi. Watcha kaiznamtus. Ma pitchin nɨjkultumikane “sun ɨzara pi kwakara ɨt” kizshina. Suasne sun ɨza kwakara ɨrɨnazi. Wemin nɨjkultumikane akkwan chiwazha kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dios akwa pala kwatchin chamtuasmin, Diosta paikuamtuasmin, une sun tuntu salizta puzninshinai. ");
INSERT INTO kwi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea suwara parejuin chaamtuasmin, Jesúsne kaiznara: —Kwail awaruzne nawa, Ampu namtɨtmikara, pizat kit mamaztuza chɨhkaanazi, nawa piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nawa piantarawane, kutña payura kuhnash. Us kaizta aizpa mɨarawane, uspane kwisha tayalamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesúskas, paiña kammuruzkas, Capernaum pɨpulura piannaakane, Dios yalkis awaruzne, pial sapmuruzne, Pedrora ɨat kit mɨmaara: —Up kamtam Dios yalkin napkane, ¿Up kamtammikane pial tanasa? kizara. ");
INSERT INTO kwi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrone sɨnkanara: —Watcha. Usne pial sapmuruza pial tamtu. Kwiztane Pedrone Jesús tukin yalta napta. Pedro parachasmin, Jesúsne an ñancha ussa kaiz kit parat: —Pedro, nune ¿Chi mintus? Wan sukin katsa mikwaruzne gobiernowa pial sappamtu. ¿Mɨnmikama katsa mikwara pial tamtu? ¿Uspa sukin uztuzne pial taamtuki? ¿Mamaz suras anupparɨttuzne pial taamtuki? kizta. ");
INSERT INTO kwi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedrone sɨnkara: —Mamaz suras anupparɨttuzne pial taamtu. Jesúsne kaizta: —Suasne, au Diosta piankamamtu akwa, Dios aumɨza ɨninamtu akwa, aune Dios yalta napna sun pial taasachimakpas. Sun Dios yal ɨninturuz na kaizta aizpa piankamasachi akwa, taarawamakpas, usparuza aizappamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mane na kaiztu aizpa nu kitpa, pial sapmuruz aliz kulamanpa. Pira ɨt kit ñampi pira kiainti. An ñancha pishkaru tainaktash. Nune pishkaru pitta pial wanmalnazi. Sun pialkasa na akwakas nu akwakas pial sapmuruza tanashina. ");
INSERT INTO kwi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maza payune kammuruzne Jesústa ɨat kit mɨmaara: —Dios ɨnintukin ¿Mɨnma an tɨntamika i? ");
INSERT INTO kwi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Suasne Jesúsne pashpara akwat kit uspa paizkakin kunnin kit ");
INSERT INTO kwi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kaiznara: —Watcha kaiznamtus. U mintu aizpa maizarachine, pashpakanain namarachine, une Dios ɨnintukin nappamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dios ɨnintukin an tɨnta namtamikane “nane an warish” minmanazi. Usne an pashpakanain namtawa, “nane an tɨnta ish” mintachin. ");
INSERT INTO kwi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mɨnpazha na akwa an pashparakanain kiwainshimtune, nawakas wat min kit saptu. ");
INSERT INTO kwi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mɨnpazha an pashparuzakanain, nawa we tɨnta nɨjkultuza, kwail kininnarane, uspane kwisha naizarɨnazi. Mamazta kwail kimtuchasmin, ina an wari. Anza wari katsa kɨmu ukkasa paiña tɨmpukin kuh kit pi pɨnta kiakpɨnna. ");
INSERT INTO kwi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Au sukin akkwan tuntu kwail wa. Mɨnpazha nawa nɨjkulturuza kwail kininturuzne an sura kwisha naizarɨnazi. Apas awa mamaztuza kwail kininnamtukas, mamaztuza kwail kininturuzne an akkwan naizanazi, uspa kwail kiarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Katmizna, uruzpain kwiraruin. Awane chihtɨkas mittɨkas waj. Uspa chihtɨkasa kwail kimturuzkas kwail kin chamturuzkas maizarawa, uspa mittɨkas kwail kiamanpa, awa kwail kiamtukin chamanpa. Chihtɨkasa kwail kimtuzkas awa kwail kiamtukin chamturuzkas Dios uztukin nappasachi. Ĩnta ɨanazi. ");
INSERT INTO kwi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Awane kasu waj. Chiwazha kwail saimtumikane kwail min kit kinazi. Kwail kin saimtuchimikane Dios uztukin napnazi. Kasukasa kwail sait kit kimtumikane ĩnta ɨrɨnazi. Katmizna kwail saiman, ĩnta ɨamanpa.” ");
INSERT INTO kwi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mɨrain. Pashparuzpakas nawa wat we piantuzpakas kwail minñanachi. Watcha kaiznamtus. Ángeltuzne nawa we piantuza iznat kit au chiyuras Taitta iztakin pura. Uspane pailta payukima Diosta izamtu. ");
INSERT INTO kwi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ampu namtɨtmikane apa at, ussa pianchiruzakas karɨttuzakas watsat mɨlnana. ");
INSERT INTO kwi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sun kwinta mɨrain. Maza ampune cien pɨriku mɨj. Maza pɨriku karɨkane, pɨrikuwamikane noventa y nueve pɨrikuruza ɨzara kwaittarɨt kit maza pɨriku karɨtmikara saimɨztu. ");
INSERT INTO kwi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Karɨt pɨrikura wanmaltane, usne sun pɨriku akwa anza wat kultɨt uz. Usne noventa y nueve pɨriku kaarachiruzpa wemin mintu. ");
INSERT INTO kwi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sunkanain au chiyura Papihshne nawa we piantuza, pashpakanaintuza, kiwainninnashimtu. Mazantuz karɨntukas, usne usparuza watsat mɨlnashimtu.” ");
INSERT INTO kwi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mamaz awa nua kwail kikane, nune ussa paimpa ɨt kit us kwail kit aizpa piankamnintawa. Nu kaizta aizpa mɨrane, usne up izmuruz namnazi. ");
INSERT INTO kwi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Us nua mɨshimakane, paastakas kutñarakas wanmaknintawa. Suasne nune uspa iztakin paiña kwail kit aizpa kainarawa, kutñaruz piankamnapa. ");
INSERT INTO kwi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Suasne uruza mɨshimakane, nune iglesia wanmakmuruza us kwail kit aizpa piankamninarawa. Iglesia wanmakmuruz kaizara aizpa mɨshimakane, une ussa ka mintain: Nune Dios pianchimikakana i. Nune Diosta nɨjkultuchikana i. ");
INSERT INTO kwi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Watcha kaiznamtus. Une awaruza chiwazha wat aizpakas chiwazha kwail aizpakas kamtananazi. U wat kimtuza ‘u wat kiamtu’ kiznarane, Dioskas sunkana kiznazi. U kwail kimtuza ‘u kwail kiamtu’ kiznarane, Dioskas sunkana kiznazi. ");
INSERT INTO kwi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mamaz pitkas uruza kaiznamtus. An sukin paas awane nɨjkul kit nɨjkulpailshina. Diosta paikukane, ap chiyuras Taittane u pashimtu aizpa mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paaskas kutñakas na akwa wanmakkakane, nane uspa paizkakin tuanash.” ");
INSERT INTO kwi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Suasne Pedrone Jesústa ɨt kit mɨmara: —Anpat. Ap aña nawa kwail kitne, ¿Yawa pijikima paiña kwail kimtu aizpa wat kultawaish? ¿Ussa siete pijikima wat kultawaki? ");
INSERT INTO kwi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesúsne sɨnkara: —Ussa siete pijikimain wat kulman. Nune aimpihshta an akkwankima, ciento cuarenta pijikima, ussa kwail kirɨt aizpa wat kultawa. ");
INSERT INTO kwi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Katmizna, nane maza kamtam kwinta kainanash, miza Dios ɨnintu piankamanapa. Katsa mikwane paiña kiwainmuruza akwanara, paiña pialpa pui aizpa kwinta kin. ");
INSERT INTO kwi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paiña pialpa kwinta kimɨztuasmin, mikwane mazara ɨninta, maza kwisha puimikasha karan. Usne 10.000 kilo pial puiara. ");
INSERT INTO kwi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Paiña kiwainmika wan pial mɨjchi akwa, usne paiña pui aizpa tasachi. Suasne pamikane paiña pit ɨninta, kiwainmikarakas paiña ashamparakas paiña painkultuzakas wan mɨj aizpa paininnapa, pui aizpa taanapa. ");
INSERT INTO kwi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Suasne kiwainmikane pamika iztakin wakpuj wain kit paikwat: ‘Anpat mɨzha. Ma pitchin tɨrizti, pial sainakima. Nua wan tanash,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Us akwa tayaltu akwa, pamikane ussa kiwainshit kit us wan pui aizpa wat kulta. Chinkas saptachin, ussa chɨhtta. ");
INSERT INTO kwi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tas puztawane, sun kiwainmikane mamaz kiwainmikara wanmalta. Usne ussa we pui. Ussa kwilkin tulpiz kit kaizta: ‘Nu pui aizpa tazha.’ ");
INSERT INTO kwi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Suasne paiña kiwainmikane us iztakin wakpuj wain kit kaizta. ‘Ma pitchin tɨrizti. Na pui aizpa tanash,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sunkana usne tɨrizshitchi. Usne puimikara kajchira sɨpninta, pui aizpa tanakima. ");
INSERT INTO kwi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mamaz kiwaintuz sun izarawane, uspane kajchira sɨptɨtmika akwa kwisha tayalat kit uspa pamikara sun kit aizpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Suasne pamikane an ñancha pui wat kultɨtmikasha akwanpa ɨnin kit kaizta: ‘Nune kwail kiwainmika i. Nu nawa paikwara akwa, nane wan nu pi aizpa wat kultau. ");
INSERT INTO kwi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nukas na nu pui aizpa wat kultɨtkana mamaz kiwainmikasha wat kulkamtish.’ ");
INSERT INTO kwi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Suasne anpatne kwisha pilchapuz kit ussa kajchira ɨnin kit ussa sɨpta, naiznapa, wan chiwal pui aizpa tanakima.” ");
INSERT INTO kwi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kapal kwinta kitpane, Jesúsne kaiznara: —Une u aimpihsh kwail kiat aizpa watcha wat kularakine, u chiyuras Taittane u kwail kiamtu aizpa wat kulmanazi. ");
INSERT INTO kwi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kapal sun pit kamtanarawane, Jesúsne Galilea sukis puz kit Judea sura ɨt. Jordán pi pãn puzmumal piannara. ");
INSERT INTO kwi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kwisha akkwan awane ussa kanpaarɨt. Suane inturuza kakultanara. ");
INSERT INTO kwi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Suasne mɨnpazha Fariseo awane Jesús tukin aara, ussa kwail kininna. Ussa ka mɨmaara: —Ampu paiña ashampara an pashitkine, ¿Ampune chiwazha akwa ussa kwaishinaki? mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesúsne sɨnkanara: —Une Dios paiña pɨnkɨhta panintɨt aizpa izara. An ñamin awa sarawane, Diosne “ampurakas ashamparakas sara.” ");
INSERT INTO kwi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ankas kaiznara: “Sun akwa ampune paiña papihshtakas paiña akkuhshtakas paimpa ɨnazi, paiña ashampara wanmakna. Paasas maza awakanain namnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sunkana uspane paas awa chi. Maza awain. Katmizna Dios ampurakas ashamparakas wanmakninta akwa, mɨnminkas sun paasta kwainnachi, paimpa uzmanpa. ");
INSERT INTO kwi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Suasne Fariseo awane Jesústa mɨmaara: —Moisés ka parɨt: “Ashampara kwaishitne, ampune ashampara kwaina pɨnkɨh chɨhkatpa.” ");
INSERT INTO kwi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesúsne sɨnkanara: —U Dios pashit aizpa kiashimtuchi akwa, Moisésne kwaina pɨnkɨh chɨhkashina kiznara, ashampara kwainapa. An ñamin Diosne sunkana pashitchi. ");
INSERT INTO kwi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nane sunkana kaiznamtus. Ashampa mamaz ampukasa pittane, paiña ampune paiña ashampara kwaina kit chɨhkashina. Paiña ashampa mamazkasa pittukine, usne paiña ashampara kwaisachi. Sun ampu paiña ashampa mamaz ampukasa pittachimikasha kwairane, sun ampune kwail kinazi, mamaz ashampara mɨltane. Sun kwairɨt ashampara mɨltumikane kwail kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kammuruzne Jesústa kaizara: —Ampu paiña ashampara kwaisachine, anza wat ashampara mɨlnachi, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesúsne sɨnkanara: —Wanne Dios kaizta aizpa piankamasachi. Diosne ashampara mɨltumikasha kiwainnashina, paiña ashampakasa wat uznanpa. ");
INSERT INTO kwi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pashparasmin mɨnpazha ampune kasara kisachi. Awane mamaztuza kasara kininarachi. Mɨnpazha ampune ashampara mɨlshitchi, Dios ɨnintukin kal kinpa. Na kuruntu aizpa mɨshimturuzne na kaizta aizpa piankamtawa. ");
INSERT INTO kwi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Suasne uspane mɨnpazha pashparuza Jesúspakin karaara, paiña chihtɨkasa paat kit uspa akwa Diosta paikwanpa. Kammuruzne pashparuza karamtuza pilchaapuzta. ");
INSERT INTO kwi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Suasne Jesúsne kaiznara: —Nakin pashpa karaman kizman. Awane an pashpakanain Dios ɨnintukin uzanazi. ");
INSERT INTO kwi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pashparuza paiña chihtɨkasa paanarawane, suas ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maza musittune Jesúspakin ɨt kit mɨmara: —Wat Anpat. ¿Chi wat kalma kinpai, chiyura pailta payukima uzna? kizta. ");
INSERT INTO kwi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesúsne sɨnkara: —¿Chitma nawa wari kiztus? Diosmin wari. Sunkana chiyura uzshitne, Dios kaizta aizpa kiri, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Musittune kaizta: —¿Chima kinpai? Diosne akkwan pit ɨninta. Jesúsne sɨnkara: —“Awara piantamun. Mamaz ashampakasa pitmun. Walkumun. Mɨnainkas pɨrail kaizmun. ");
INSERT INTO kwi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Papihshpakas akkuhshpakas wat mintawa. Nuin pashimtukanain makin uztuza pashinarawa,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Musittune sɨnkara: —Nane pashpa asmin nu kaizta aizpa kirau. ¿Anne chima kinpai? ");
INSERT INTO kwi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsne kaizta: —Nu wan nil kishitne, nune wan mɨj aizpa painin kit puizara mɨlanarash. Sunkana kitne, nune chiyura pãn kulnazi. Kwiztane nakin at kit nawa kanpazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sun mɨrawane, musittune tayal kit ɨrɨt, kwisha kwazpa akwa. ");
INSERT INTO kwi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Suasne Jesúsne kammuruza kaiznara: —Watcha kaiznamtus: “Kwazpamikane kwisha sam i, Dios ɨnintukin napna.” ");
INSERT INTO kwi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mamasa kaiznamtus. Camellone chɨhku kasura napsachi. Kawarain pãn kulshitmikane Dios ɨnintukin napsachi. ");
INSERT INTO kwi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sun mɨarawane, kammuruzne kwisha iztaspaat kit usparuzpain mɨmaara: —Kwazpa awa Dios ɨnintukin nappasachine, suasne mɨnminkas watsat mɨlmanazi. ");
INSERT INTO kwi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesúsne usparuza iznat kit kaiznara: —Awane usparuzpain watsat mɨlnasachi. Diosmin chiwazha awaruza watsat mɨlnashina. ");
INSERT INTO kwi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Suasne Pedrone Jesústa kaizta: —Aune wan mɨj aizpa chɨhkarɨtmakpas, nua kanpana. ¿Chima saptawaime? ");
INSERT INTO kwi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesúsne sɨnkanara: “Watcha kaiznamtus. Mamaz payura Diosne wanta masas namnintɨnazi. Sun payura nane, Ampu namtɨtmikane, Dios ɨnintukin uz kit kwisha naztam malnash. Une, ap kanpamturuzne, doce ɨnintukin nakasa uzanazi, doce Israelpa kwaltuza ɨninnana. ");
INSERT INTO kwi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nawa kanparamikane, mɨnpazha na akwa yalkas, aimpihshtakas, kwampihshtakas, papihshtakas akkuhshtakas painkultakas paiña sukas chɨhkatmikane, apain an akkwan pijikima sappanazi. Kwiztane chiyura pailta payukima uzanazi. ");
INSERT INTO kwi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","An sukin an tɨntaruzne Dios ɨnintukin an we tɨntakana namanazi. An sukin an we tɨntaruzne Dios ɨnintukin an tɨntaruzkana namanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Suasne Jesúsne ka kamtanamɨzta: “Dios ɨninkane, usne su pamikakana i. Su pamikane tɨlawain ɨt kit kal kimtuza sainara, wankail pippa pakna. ");
INSERT INTO kwi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Usne kal kimtuza pial tana namninnat kit paiña sura ɨninnara, kal kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nueve urara pakane, usne awa wanmakchamkin ɨt kit awa kal kishimturuza sainara. ");
INSERT INTO kwi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Usne kaiznara: ‘Ukas ap kal kin ɨrain. Nane nil tananash,’ kiznara. Uspane kal kin ɨara. ");
INSERT INTO kwi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pamikane mamasa paizka payu pakakas, kutña urakas puzta, kal kimtuza sainana. Usne sun pitmin kaiznat kit ɨninnara, paiña kal kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cinco ura pakakas, usne awa wanmakchamkin puzta. Mamaz kal kimtuchiruza wanmaknat kit kaiznara: ‘¿Chitka une akki mansɨh pura, kal kimtuchin?’ mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Uspane kaizara: ‘Mɨnminkas aumɨza kal kin namninnarachi.’ Suasne usne kaiznara: ‘Une ap sura kal kin ɨrain. U kal kit aizpa tananash,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tɨlpamɨzkane, pamikane paiña kal ɨninmikara kaizta: ‘Kal kimtuza akwanat kit pial tanamɨzti. Kwizta piannattuzakas an ñancha tanamɨzti. An ñancha pianattuzakas an kwizta tanamɨzti,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Suasne cinco horara naptuzne ɨat kit maza payus kal kitkana sappara. ");
INSERT INTO kwi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kwiztane an ñancha mansɨh naptuzne ɨara, uspa pial sappana. Uspane an akkwan sapnash minñara. Uspane maza payus kal kit kitkana kapal sappara. ");
INSERT INTO kwi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pial sapparawane, uspane pamikara pilchapuzamɨz kit ");
INSERT INTO kwi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kaizara: ‘An kwizta aaruzne maza urain kal kiarakas, nune usparuza aumɨzakanain tanara. Aune mansɨh kalkas ikas tailchatmakpas,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pamikane sɨnkanat kit mazara kaizta: ‘Izmuruz. Nane nua kwail kain kinintachish. Nane nukasa sunpawa pial tana namtau. ");
INSERT INTO kwi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Up pial sap kit ɨt. Nane kwizta kal kin atmikashakas nuakanain sun pawain tashimtus. ");
INSERT INTO kwi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nane ap pialkasa na pashit aizpa kishinash. Nane uspa akwa wat kinarau. Nune pilchapuznachi.’ Sun kwinta sunkana pailti. ");
INSERT INTO kwi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dios ɨnintukin sunkanain anazi. An kwizta naptumikane an ñancha naptumikakana namnazi. An ñancha naptumikane an kwizta naptumikakana namnazi. Dios akkwantuza ussa kanpaana akwannarɨtkas, usne akkwanchin nanarɨt.” ");
INSERT INTO kwi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalén pɨpulu miwara ɨmtuasmin, Jesúsne paiña doce kammuruza paimpa mɨlnat kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mane aune Jerusalén pɨpulura numɨztumakpas. Tane Judasne nawa, Ampu namtɨtmikasha, pariya ɨninturuzakas Moisés kaizta aizpa kamtamtuzakas chɨhkaanazi, na inapa kizanapa. ");
INSERT INTO kwi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Uspane nawa Judío awachiruza chɨhkaanazi, nawa ishaanapa, nawa aim kianapa, nawa tɨra patpiantanapa. Kutña payu pailtɨkane, nane mamasa kuhsnash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Suasne Santiagokas Juankas, aimpihsh parain, uspa akkuhshkasa Jesús tukin aara. Uspane Zebedeo painkul mai. Akkuhshne Jesús iztakin wakpuj wainta, chiwazha paikwan. ");
INSERT INTO kwi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesúsne ussa mɨmara: —Nune ¿Chima pashiras? Usne kaizta: —Na paikwantu aizpa kiri. Nane ap paas painkul u nukasa ɨninnapa pashirash, maza numal uznapa, mamaz kwiyamal uznapa. ");
INSERT INTO kwi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesúsne aimpihshtuza sɨnkanara: —Une u paikuamtu aizpa pianchi. Nane kwisha naiztɨnash. ¿Une nakanain naizmu tailchashina? Uspane sɨnkailta: —Aune naizmu tailchashinawas. ");
INSERT INTO kwi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesúsne kaiznara: —Watcha kaiznamtus. Une kwisha naizmu tailchailnazi, awa uruza kwisha naizninamtu akwa. Nakasa ɨninna uzashimtukas, nane uruza ap numalta ap kwiyamalta uznapa kizsachish. Ap Taittane apmamin uztuza nanarɨt me, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mamaz diez kammuruz sun mɨarawane, uspane paas aimpihshtuza pilchapuzara. ");
INSERT INTO kwi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesúsne kammuruza akwanat kit kaiznara: —Une katsa mikwawa wat pian. Judío awachi ɨninturuzne wan awaruza ɨninnamtu. Katsa mikwaruzne tɨnta ɨninnamtu, uspa kal kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Uruzpain sunkana kiman. Kancha sunkana kiarain. Uruzpain an katsa namshitmikane mamazta kiwainnarawa. ");
INSERT INTO kwi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mɨnpazha an ñancha ɨninmika namshitne, usne kiwainmikakana namshina, mamaztuza kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kawarain Ampu namtɨtmikane awaruza ɨninnana atchi. Awaruza kiwainnana azi. Usne awa akwa inna azi, akkwan awa sɨptɨttuza chɨhtnana. ");
INSERT INTO kwi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó pɨpuluras puzamtuasmin, akkwan awane Jesústa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Suane paas kasu izsachiruzne mikin uzpailta. Jesús pɨntu mɨmtazasmin, paasne kwianpailta: —Anpat. Nune Ɨninmika Davidpa kwal i. Aumɨza kiwaincha. ");
INSERT INTO kwi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mamaz awaruzne usparuza chinkas kaizmun kiznara. Sun kaizarakas, uspane an tɨnta kwianpailta: —Anpat. Nune Ɨninmika Davidpa kwal i. Aumɨza kiwainchain. ");
INSERT INTO kwi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Suasne Jesúsne kun kit kasu izsachiruza akwat kit mɨmara: —U akwa ¿Chima kinpai? ");
INSERT INTO kwi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Uspane sɨnkailta: —Anpat. Au kasura izkulnincha. ");
INSERT INTO kwi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Suasne Jesúsne usparuza kiwainshit kit uspa kasukin paanara. Sun urain sun paas izsachiruzne izkulpail kit Jesústa kanpailta. ");
INSERT INTO kwi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén pɨpulura piannanpain. Betfagé pɨpulura piannachasmin, uspane Olivos ɨzara kunnara. Jesús paas kammuruza akwanat kit ɨninnat kit ");
INSERT INTO kwi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kaiznara: —Au izkwakpara pɨpulura ɨrain. Suane maza ashampa burra kantɨt wanmalpailnazi, ainki ampu burrokasa. Burrara chɨht kit paasas nawa karaanaka. ");
INSERT INTO kwi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mɨnpazha uruza chiwazha kaizkane, ka kaiztain: “Anpatne paasas pashimtu. Masakin an kwizta kailninnanazi,” kiznaka. ");
INSERT INTO kwi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sunkana Dios kainammmika para aizpa kirɨt. Sunkana parɨt: ");
INSERT INTO kwi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén pɨpulu uztuza kaiztain: ‘Iztain. Up katsa mikwane amtui. Us wat akwa, kalpain uztu. Burrora anuztui. Ainki kwa kamtɨtchi burrora anuztui.’ ” ");
INSERT INTO kwi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Suasne paas kammuruzne ɨil kit Jesús kaizta aizpa kiilta. ");
INSERT INTO kwi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ashampa burrara pashpa burrokasa karailtawane, kammuruzne uspa pĩn ainki burrora palkwanat. Jesúsne anuzta. ");
INSERT INTO kwi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Akkwan wanmaktuzne uspa pĩn mikin kɨhamɨzta. Mamaztuzne tɨ kɨhwil tɨttat kit Jesús pɨntukin kɨhamɨzta, mi watsanapa. ");
INSERT INTO kwi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","An ña ɨmtuzkas an kwizta ɨmtuzkas ka kwisha watsal kwianamɨzta: “An Diospa ɨninmikane, an Davidpa kwalmikane, kwisha wari. An ñamin Davidne mikwa azi. Au Anpatne kwisha wari. Chiyuras Diosne kwisha wari,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalén pɨpulura napkane, akkwan pɨpulu uztuzne kwisha kwiat kit kaizara: —Sunne ¿mɨnma kai? ");
INSERT INTO kwi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Awane kaiznara: —An kainammmikane Jesús i. Usne Galilea suras, Nazaret pɨpuluras, ara. ");
INSERT INTO kwi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesúsne katsa Diospa yalkin nap kit wan paininturuzakas paimturuzakas pianamal tɨnta ɨninnara. Pial maizmuruzpa misharɨrakas utkuru paininmuruzpa uzmukas kiakpɨnnat ");
INSERT INTO kwi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","kit kaiznara: —Dios pɨnkɨhta ka parɨt: “Diosne paiña yal sara, awa sua Diosta paikwanpa.” Une ap yalta nappamtu, awa mɨj aizpa walkuana. ");
INSERT INTO kwi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kwiztane mɨnpazha kasu izsachiruzkas chasachiruzkas Jesús tukin aara. Usne kakultanara. ");
INSERT INTO kwi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Katsa pariya ɨnintuzkas Moisés kaizta aizpa kamtamtuzkas Jesús iztasparɨt kal kit aizpa izara. Pashparuzkas katsa Dios yalkin ka kwianara: “David ɨninmikawa pampa pashpane kwisha wari.” Judío awa ɨnintuz sun mɨarawane, uspane Jesústa aliz kulat ");
INSERT INTO kwi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","kit kaizara: —¿Uspa kizamtu aizpa mɨmtukish? Jesúsne sɨnkanara: —Watcha mɨmtus. ¿Une Dios pɨnkɨh parɨt aizpa izarachimakkiwas? Ka parɨt: “Ainki pashparuzkas pashpa chitchu kumturuzkas Dios kwisha wari nil kizanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Suasne Jesúsne usparuza kwainat kit sun pɨpuluras puz kit Betania pɨpulura pitna napta. ");
INSERT INTO kwi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tɨlawain Jesúsne Jerusalén pɨpulura kail kit yak kira. ");
INSERT INTO kwi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Usne higuera tɨ mikin iz kit kashara ɨt. Tɨ kɨhmin waj wanmalta. Suasne Jesúsne higuera tɨra kaizta: —Mizurainkas pippa wamanazi. Sun payukis higuera tɨ pulpalmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mamaz payura sun tɨ izarawane, kammuruzne iztaspaat kit mɨmaara: —An tɨne ¿mizamaka azain pulpaltɨmtu? Me inapain iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesúsne sɨnkanara: —Watcha kaiznamtus. Chiwazha Diosta paikukane, une Diosta wat nɨjkularawa, us kaizta aizpa maintachin. Sun minñamɨztane, ukas sunkana higuera tɨra kiashinazi. Sunkana kalkas an tɨnta kalkas kiashina. Ɨzara ɨaninshimtune, “une ɨzara pirain ɨri” kizashina. Suasne ɨzane u ɨnintu aizpa kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Diosta nɨjkulturuz Diosta paikuakane, usne u paikuamtu aizpa kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Suasne Jesúsne Dios katsa yalkin nap kit kamtanamɨzta. Katsa pariya ɨnintuzkas ɨlapa Judío ɨnintuzkas Jesústa ɨat kit mɨmaara: —¿Chikishma sun kimtus? ¿Mɨnma nua ɨninta, sun kinpa? ");
INSERT INTO kwi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesúsne sɨnkanara: —Nakas chiwazha uruza mɨmanash. Na uruza mɨmanara aizpa sɨnkaarane, katne nakas mɨnma nawa ɨninta ap kal kinpa sɨnkananash. ");
INSERT INTO kwi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Mɨnma Juan munnammikara ɨninta? ¿Diosne ussa ɨnintaki? ¿Awane ussa ɨnintaki? Uspane usparuzpain tɨnta kwinta kiamɨz kit kaiznamɨzta: “Aune Dios ussa ɨninta kisachimakpas. Au sun kizakane, usne sunkana aumɨza kiznazi: ‘Suasne une ¿chikishma us kaizta aizpa nɨjkularachi?’ ");
INSERT INTO kwi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aune ‘awa ussa ɨninta’ kizsachimakpas, awa aumɨza ishkwinninnamtu akwa, wan awa Dios Juanta ɨninta minñamtu akwa. Au sun kizarane, awane aumɨza chiwazha kiashina.” ");
INSERT INTO kwi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jesústa sɨnkaat kit kaizara: —Mɨnma Juanta ɨninta pianchimakpas. Suasne Jesúsne kaiznara: —Nakas mɨnma nawa ɨninta an kal kin uruza kainammanash. ");
INSERT INTO kwi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesúsne kaiznara: —An kamtam kwinta wat mɨrain. Maza ampune paas painkul mɨjara. Maza painkulta kaizta: “Painkul, ap wankail pippa warɨtkin kal kirash.” ");
INSERT INTO kwi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Painkulne ussa sɨnkara: “Kishitchish.” Kwiztane us minta aizpa maiz kit kal kin ɨt. ");
INSERT INTO kwi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Suasne papihshne mamazta izna ɨt kit sunkanain kizta. Usne papihshta sɨnkara: “Watcha kal kinash.” Kwiztane usne ɨtchi. ");
INSERT INTO kwi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Mɨnmika papihsh pashit aizpa kirɨt? Uspane kaizara: —An ñanchamika papihsh pashit aizpa kirɨt. Suasne Jesúsne kaiznara: —Watcha kaiznamtus. Une kwiztamikakana mai. Gobierno pial sapmuruzkas kwail ashamparuzkas ukin an ñancha Dios ɨnintura nappanazi. ");
INSERT INTO kwi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan munnanammikane at kit uruza miza uzna kamtanara. Une us kaizta aizpa nɨjkularachi. Kancha Gobierno pial sapmuruzkas kwail ashamparuzkas us kaizta aizpa nɨjkulara. Wan sun izarakas, une maizarachi. Nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mamaz kamtam kwinta mɨrain. “Su pamikane paiña sukin wankail pippa wana ɨt. Usne sun sukin kinta. Wankail pippa kɨm yal sara. Usne kwash yal sara, izmumika wankail pippa sau iznapa. Suasne usne kal kimtuza unanat kit attishta ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Paktu payu taizkane, su pamikane paiña kiwaintuza ɨninnara, paiña paimpa sapnapa. ");
INSERT INTO kwi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kal kimtuzne kiwaintuza piznara. Mazara aim kiara. Mamazta piantaara. Mamazta uk kiara. ");
INSERT INTO kwi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Su pamikane anza akkwan kiwaintuza ɨninnara. Kal kimtuzne wanta sunkanain kinara. ");
INSERT INTO kwi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Minpara usne paiña painkulta ɨninta. Usne ka minta: ‘Uspane ap painkul kaizta aizpa mɨanazi.’ ");
INSERT INTO kwi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Paiña painkulta amtuasmin, kal kimtuzne paiña painkulta izarawane, uspane usparuzpain kaizara: ‘Anne su sapmumika i. Ussa piantana ɨzhain, paiña su pakin.’ ");
INSERT INTO kwi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sunkana ussa pizat kit paiña sukis ukkat kit piantaara. ");
INSERT INTO kwi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Suasne Jesúsne mɨmanara: —Supamika akane, ¿Chima kinsa, sun kal kimtuzkasa? ");
INSERT INTO kwi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Usne kaizara: —Usne sun kwail awaruza tɨnta naizninnanazi, inakima. Suasne usne mamaz kal kimtuza unananazi, paiña paimpa pippa sapnapa. ");
INSERT INTO kwi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Suasne Jesúsne mɨmanara: —¿Une Dios parɨt aizpa izarachimakkiwas? Sunkana parɨt: ‘Yal samturuzne an watsal uk kiakpɨnara. Kwiztane Diosne sun watsal ukkasa yal sarɨt. Aune us sarɨt aizpa kwisha wari minpuspas.’ ");
INSERT INTO kwi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Katmizna kainammtus. U Diosta mɨashimtuchi akwa, une Dios ɨnintukin nappasachi, uskasa ɨninna. Diosne mamaztuza napninnanazi, uskasa uzanapa, uskasa ɨninnanapa. Dios kaizta aizpa kishimturuzne Dios ɨnintura nappanazi. ");
INSERT INTO kwi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","An ukta naintumikane pak pak kɨztɨnazi. Uk mɨnpazhara taiztane, ussa kɨrɨnazi. Nane an ukkana ish. Nawa aliztuzne naizarɨnazi, pak pakkanain namanakima. Nawa kiakpɨnturuzne wan kaat kit polvokana namarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Katsa pariya ɨnintuzkas Fariseo awaruzkas Jesús kaizta aizpa mɨarawane, uspane Jesús usparuza kamtam kwinta kitta piankamara. ");
INSERT INTO kwi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Katmizna uspane ussa pizshiara. Akkwan awa Jesús Dios kainammmika i mɨamtu akwa, ɨnintuzne awa akwa ishkuat kit ussa pizarachi. ");
INSERT INTO kwi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesúsne mamasa usparuza paramɨz kit mamaz kamtam kwinta kiznara: ");
INSERT INTO kwi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diosne paiña ɨnintura sunkana kimtu. Katsa mikwane paiña painkul akwa kasara kin pishta sara. ");
INSERT INTO kwi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Paiña kiwaintuz kasara pishtara akwattuza ɨninnarakas, uspane aashitchi. ");
INSERT INTO kwi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mamasa mamaz kiwaintuza, ɨninnara ka kaiznanapa: Akwarɨttuza kaiztain: ‘Nane kumkin kapal sarɨt mɨjish. Nane pɨntɨt wakara piantarau. Wan kapal sarɨt me. Kasara kit pishtara aanaka.’ ");
INSERT INTO kwi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Akwarɨttuzne mɨashitchi. Mazane paiña sura ɨt. Mamazne paiña chiwazha paininmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mamaztuzne mikwawa kiwaintuza piznat kit aim kiara, piantanakima. ");
INSERT INTO kwi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Suasne mikwane kwisha aliz kul kit paiña suldaruruza ɨninnara, paiña kiwaintuza piantamtuza piantanapa, uspa pɨpulura impaktanapa. ");
INSERT INTO kwi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kwiztane paiña kiwaintuza kaiznara: ‘Wan kapal sarɨt, kasara kit pishta izna. Nawa paashitchi akwa, akwarɨttuzne aasachi, na kaizta aizpa mɨashitchi akwa. ");
INSERT INTO kwi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Katmizna une pɨpulu pianamal ɨrain. Wan puizaruzakas uspa wanmaltukin akwanarain, kasara kit pishta izaanapa,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kiwaintuzne pɨpulura pianamal puzat kit wanmaltaruza wanmakninnara. Kwailtuzakas wattuzakas wanmakninnara. Uspane yalta nappara, yal punnakima. ");
INSERT INTO kwi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Suasne mikwane yalta napta, akwarɨttuza iznana. Usne maza ampu pishtara cham kamisha kwachira izta. ");
INSERT INTO kwi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Usne ussa kaizta: ‘Izmumika. ¿Mizamaka naptau, pishtara cham kamisha kwachine?’ Usne puñain parɨt. ");
INSERT INTO kwi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Suasne mikwane kumira nailmuruza kaiznara: ‘Ussa mittɨkas chihtɨkas kuh kit pianamal, tɨlkwilmal, ɨninti. Suane azat kit sula sɨt sɨt kinazi.’ ");
INSERT INTO kwi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Akkwan awaruz akwanarakas, Dios akkwan chin nanarɨt.” ");
INSERT INTO kwi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Suasne Fariseo awane suas ɨat kit wanmakkat kit usparuzpain kwinta kiara. Uspane usparuzpain nɨjkulat kit Jesúskasa kwinta kishiara, Jesús kwail pit paraninnapa. ");
INSERT INTO kwi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sunkana uspane uspa kammuruzakas Herodespa kanpamtuzakas Jesústa ɨninnara, ka kaizanapa: —Anpat. Nu watcha kiztu akwa, nu wat awa i pianmakpas. Nune Dios ɨnintu aizpa kamtanamtu, awa nil uzanapa. Nune awa minñamtu aizpa mɨrachi. Nune wantuza nil kaiznamtu, ishkwatchin. ");
INSERT INTO kwi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nu mintu aizpa aumɨza kainazhain. ¿Aune pial, Cesarta, Roma pɨpulu katsa mikwara, tana watsa? ");
INSERT INTO kwi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesúsne uspa kwail minñamtu aizpa piankamta. Uspane Jesústa kwail kizninshiara, awa us akwa kwail minñanapa. Usne kaiznara: —Une nil chammuruzkana uzamtuchi. ¿Chikishma kwail kiamtus nawa? ");
INSERT INTO kwi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Une pial mikwara tamtu aizpa anchain. Uspane ussa maza pial karaara. ");
INSERT INTO kwi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pial iztawane, Jesúsne mɨmanara: —Pialkin ¿mɨnpa matsɨh makai? Pialkin ¿mɨnpa mun parɨt makai? ");
INSERT INTO kwi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Uspane sɨnkaara: —Cesarpa matsɨh, Roma mikwawa matsɨh, pialkin uz, kizara. Suasne Jesúsne kaiznara: —Une apas sukin mikwara paiñawa mɨlarawa. Ukas au Diostakas watcha paiñawa mɨlarawa. ");
INSERT INTO kwi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sun mɨarawane, uspane iztaspaat kit ussa tuij ɨara. ");
INSERT INTO kwi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sun payune mɨnpazha Saduceo awane us tura izna ɨara. Uspane irɨtmika irɨttas kuhstuchi kiz kamtaamtu. Katmizna uspane ussa kaizara: ");
INSERT INTO kwi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Kamtam, mɨri. Moisésne sunkana pat kit kaizta: “Ampu ashampara mɨltane, pashpa mɨjki irakane, aimpihshne paiña aimpihsh irɨt ashampara mɨltawa, pashpa mɨjan. Pashpa kawirane, irɨt aimpihshpa pashpakanain kawirarawa.” ");
INSERT INTO kwi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mane auruzpain siete aimpihsh uzara. An ɨlapamikane ashampara mɨl kit irɨt, pashpa mɨjchin. Pashpa mɨjchi akwa, aimpihsh kanmikane sun ashampara mɨlta. ");
INSERT INTO kwi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aimpihsh kanmikakas sunkanain irɨt. Mamaz aimpihsh kanamikakas sunkana kirɨt. Wan siete aimpihshtuza sunkana kiarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wan siete aimpihshkasa uztawane, ashampakas irɨt. ");
INSERT INTO kwi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mane irɨttas kuhstu payura taizkane, ¿Mɨnmikama siete aimpihshtas ashampara mɨlnasa? Wanne sun ashampara mɨlarɨt. Sun akwa irɨttuzne irɨttas kuhsamanazi, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sun akwa Jesúsne sɨnkanara: —Une ñanta kiarɨt, u Dios pɨnkɨhta parɨt aizpa pianchi akwa. Une Dios kishimtu aizpa piankamarachi. ");
INSERT INTO kwi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Awa irɨttas kuhsarawane, ampune ashampara mɨlmanazi. Pashurakas mɨlmanazi. Wanne Diospa ángelkana chiyura puranazi. ");
INSERT INTO kwi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mane irɨttuzne irɨttas kuhsanazi. Watcha, une Dios parɨt aizpa izara. Sunkana kaiztɨt: ");
INSERT INTO kwi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nane Abrahampa Dios ish. Isaacpa Dios ish. Jacobwa Dios ish,” kiznara. Abrampakas Isaackas Jacobkas ñamin iarɨtkas, uspane Dioskasa uzamti. Diosne irɨttuzpa Dios chi. Diosne uztuza ɨninnamtu, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús kamtamtu aizpa mɨarawane, awane iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesúsne Saduceo awaruza nil sɨnkanat kit puña paninnarɨt, ussa mamasa mɨmamanpa. Suasne sun mɨarawane, Fariseo awane wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mamaz Fariseone, Moisés kaizta aizpa kamtammikane, Jesústa kwail kizninshit kit mɨmara: ");
INSERT INTO kwi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Kamtam mɨri. Diosne akkwan ɨnim pɨnkɨhta para. ¿Mɨn ɨnimma an tɨnta i? ");
INSERT INTO kwi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesúsne kaiznara: —“Une Anpat Diosta pashiarawa. Kaijchuras nɨjkulat kit ussa pashiarawa. Wan izpulkasa ussa pashiarawa. Diospa minñamtuasmin, Diostain pashiarawa.” ");
INSERT INTO kwi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","An ñancha ɨnimne tɨnta ɨnim i. ");
INSERT INTO kwi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mamaz ɨnimne an ñancha ɨninkana i. Sunkana parɨt: “Une u izmuruza pashinarawa, u uruzpain pashiamtukanain.” ");
INSERT INTO kwi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","An paas ɨnim mɨarane, une wan Moisés para aizpakas wan Dios kainammmika kamtara aizpakas kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo awa me wanmaktɨttuasmin, ");
INSERT INTO kwi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsne mɨmanara: —Une ¿Chi Ampu namtɨtmikawa minñamtu? Usne ¿Mɨnma painkul i? Uspane sɨnkaara: —Usne Davidpa kwalpa painkul i. Usne ñamin mikwa Davidpa kwaltas kawira. ");
INSERT INTO kwi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Suasne Jesúsne kaiznara: —Dios Izpulne Davidta minninta, Cristo ap Anpat i kiznapa. ¿Chikishma sun kiztɨt? ");
INSERT INTO kwi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Davidne ka kizta: “Diosne ap Anpatta ka kaizta: Nune nakasa ap ɨnintukin uzti, Wan aliz awaruza ɨninnanakima.” ");
INSERT INTO kwi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidne “Cristo ap Anpat i” kizta. ¿Davidpa painkulkas ashinaki? ");
INSERT INTO kwi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mɨnminkas us kaizta aizpa akwa maza pitminkas sɨnkaasachi. Sun payukis mɨnminkas ussa an mɨmaarachi. ");
INSERT INTO kwi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Suasne Jesúsne wan puraruzakas paiña kammuruzakas ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés para aizpa kamtamtuzkas Fariseo awaruzkas Moisés parɨt aizpa piankamat kit awaruza kamtananamtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Katmizna uspa kamtamtu aizpa mɨat kit kiamɨztawa. Uspa uzamtukana uzman. Uruza chiwazha kianapa kurunamtuasmin, uspane mamaz tuntu kiamtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Uspane awaruza uspain minñamtu aizpa kinpa kurunnamtu. Uspa kaizamtu aizpa kwisha sam. Uspa kaizamtu aizpa kwisha us kwakanain i. Uspane uspain kaizamtu aizpa kiashitchi. ");
INSERT INTO kwi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Suntuzne chiwazha kiamtu, awa usparuza izanapa, awa uspawa wat minñanapa. Uspane Dios pit ainki pɨnkɨhta pat kit ip kit ainki cajónta winñara. Suasne uspane sun ainki cajóntuza kɨnijkinkas sailkinkas akkal tɨtkasa kanarɨt, awa usparuza an wat izanapa. Uspane mamaz awawa ainki cajónkin anza katsa cajón saara. ");
INSERT INTO kwi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Awa pishtara ɨakane, uspane yalta ɨat kit anza wat uzmura sayamtu, awa usparuzpa wat minñanapa. Kammu yalta nappakane, uspane nappat kit an wat uzmura sayamtu, awa iztakin usparuza an tɨnta namninnana. Sun akwa aune mamaz awakinkas an wat makpas minñara. Uspakas watsal aks tɨt uspa kwaksham, kantɨt piltakima. Sun akwa aune mamaz awakinkas an wat makpas minñara. ");
INSERT INTO kwi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pɨpulumal pɨntuasmin, awa usparuza ‘kamtam kakishapu’ kizakane, uspane ‘an wat awa mai’ minñamtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Une uruzpain an katsa mika namninman, awa uruza kamtam i kizamanpa. Une aimpihshtuzpakanain mai. Une maza kamtammin mɨj. Usne Cristo i. ");
INSERT INTO kwi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Une an sukin mɨnainkas ‘ap taitta’ kizman. Une maza Taittain mɨj. Usne chiyura uz. ");
INSERT INTO kwi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Uruzpain mazara ‘kamtammika’ akwanchi. Une kamtammikane mɨj. Usne Cristo i. ");
INSERT INTO kwi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wantuza kiwainmumikane uruzpain an tɨnta namtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Usmin an tɨnta namshimtumikane an wewazhain namtɨnazi. Usmin an wemin namtɨmtumikane an tɨntawazha namtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Moisés para aizpa kamtamtuzkas Fariseo awaruzkas mɨzhain. Uruzmin awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Une chiyu pɨjta sɨppamtu, awa sua nappamanpa. Ukas sua nappashimtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","U Moisés para aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruzmin awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Une ampu irɨtpa ashampawa yal walkuamtu. Kwiztane une awa iztukin Diosta paikuamtu, awa uruza izanapa, u wari kizanapa. Sun kiamtu akwa, une an kwisha akkwan naizarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","U Moisés para aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruzmin awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Wan suwara pɨnamtuasmin, akkwan ñam pira kwakkamtuasmin, une mazara sayamtu, u kamtamtu aizpa kinpa. An kammumikara kamtawane, usne ukin anza kwail nam kit ĩnta an akkwan naiznazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Une kwisha naizarɨnazi. U kamtanamtukas, une kasu izsachimikakana mai, u kamtaamtu aizpa wat piankamamtuchi akwa. Une ka kamtamtu: ‘Mɨnpazha Dios katsa yal akwa chiwazha kin namtu. Usne sunpa Dios katsa yalkin kiztu, iztumika us kaiztu aizpa mɨnapa. Dios katsa yal akwa kin namtumikane us kin namtɨt aizpa kinchi. Mɨnpazha uru akwa Dios katsa yalkin chiwazha kin namtune, usne us kin namtu aizpa kitpa,’ u kizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Une tɨmpa awakana mai. Une u kaizamtu aizpa wat mɨamtuchi. Une kasu izsachiruzkana mai, u kamtamtu aizpa wat piankamamtuchi akwa. Dios katsa yalne urukin an tɨnta i, Diospa yal sun urura Dios akwa paimpa namnintɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Une ankas ka kizamtu: ‘Mɨnpazha Dios katsa yalkin mɨlam misharɨ akwa chiwazha kin namtu. Usne sunpa Dios katsa yalkin kiztu, iztumika us kaiztu aizpa mɨnapa. Dios katsa yalkin mɨlam misharɨ akwa kin namtumikane us kin namtɨt aizpa kinchi. Mɨnpazha chiwazha mɨlam Diospa katsa yalkin mɨlam misharɨra tarane, sun mɨlam akwa kin namtumikane us kin namtɨt aizpa kitpa,’ u kizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Une kasu izsachiruzkana mai, u kamtamtu aizpa wat mɨamtuchi akwa. Dios katsa yalkin mɨlam misharɨne mɨlamkin an tɨnta i, Dios paiña yalkin mɨlam misharɨ sun mɨlamtu aizpa sɨnam namnintu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dios katsa yalkin mɨlam misharɨ akwa kin namtumikane mɨlam misharɨ akwa kin namtuchi. Mɨlam misharɨ akwa kin namtumikane wan mɨlam misharɨkin ɨsalpara tarɨt akwa, kin namtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɨnpazha Dios katsa yal akwa kin namtumikane Dios katsa yal akwa kin namtuchi. Uskas Dios akwa kin namtu, us sua uztu akwa, us sua ɨnintu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chiyu akwa kin namtumikane Diospa uzmu akwa kin namtu, tas Dios ɨnintu akwa, ta Dios uztu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","U Moisés para aizpa kamtamtuzkas Fariseo awakas mɨzhain. Uruzmin awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. U chiwazha diez mɨjne, une Diosta maza mɨlamtu. Diez menta kɨh mɨjne, une maza kɨh Diosta mɨlamtu. Aniskas cominokas mɨjne, une diezkis maza Diosta mɨlamtu. U muinchi kɨh Diosta mɨlamtukas, une Dios kamtamtu aizpa mɨashimtuchi. Diospa kamtamne u kamtamkin anza tɨnta i. Une nil uzarawa. Une mamaztuza kiwainnarawa. Une Diosta wat nɨjkularawa. Une sunkana kiarawa, mamaz ɨnimkas maintachin. ");
INSERT INTO kwi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Une kasu izsachiruzkana mai, u kamtamtu aizpa wat piankamamtuchi akwa. Une we kamtamtu aizpa mɨamtu. Une an tɨnta kamtamtu aizpa mɨamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","U Moisés para aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruzmin awa iztakin wat awakana, kwail kitchiruzkana, izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Une pɨlatturakas tasarakas ɨsalpara kitmuruzkana mai. Une pɨlattukas tasakas ayukman kittachin. U kwail kitchiruz awakanain namninamtukas, une ayukmal pil pattɨtkanain mai, u walkuamtu akwa, u kwazpa kulashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo awaruz mɨzhain. Une kasu izsachiruzkana mai, u kamtamtu aizpa wat piankamamtuchi akwa. Une an ñancha uruzpain ayukmarain kihanintain. Ayukmaltain kiharawane, u pianamal kiharɨt manazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","U Moisés para aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruz awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Une awa ɨrɨt kamkin yalkanain izarɨt. Awane sun yaltuza putchã nɨarɨt, ɨsalpara watsal izanapa. Ayukmalne irɨt sɨhkas wan kwailkas wakularɨt. ");
INSERT INTO kwi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Une irɨt kamkin yalkanain mai. Une ɨsalpara awa iztakin sɨnam izarɨt. Une ayukmal kaijchumal kwail minñamtu. Sun akwa une kwail kiashimtu. ");
INSERT INTO kwi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","U Moisés para aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruzmin awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Katmizna une kwisha naizarɨnazi, u kwail kiamtu akwa. Ñamin Diospa kainammtuz iarɨkane, u pamparuzne irɨt kamkin yal saara. Uspane irɨt awawa kamkin yalta ɨat kit uspa kamkin yal watsal sanara, uspa sun awaruza pashinat annanapa. ");
INSERT INTO kwi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ukas ka kaizamtu: ‘Au ñamin irɨt kwal uzta payura uzaratne, aune uspakana Dios pit kainammtuza piantarachimanatpas.’ ");
INSERT INTO kwi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sun pit kizamtuasmin, une u irɨttuzpa kwal mai piankamamtu. Une u ñamin irɨt kwalkana mai, uspa Dios pit kainammtuza piantaarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Une ñamin irɨttuzpa kwalpa kwail kal kamamtu aizpa kiamɨznazi, wan pailnakima. Une u pampawa kalkin anza kwail kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Une kamtakana mai, sula kumtu akwa. U pit kaizamtu aizpa kamta pininukana mai. U ĩnta naizamtuasmin, une mizurainkas ĩntas puzamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Katmizna nawa mɨzhain. Nane u uzamtukin Dios pit kainaruzakas wat piantuzakas kamtamtuzakas ɨninnamtus. Une mɨnpazharuzakas kurishta patpian kit piantananazi. U uztukin aakane, une mɨnpazharuzakas kammu yalkin aim kianazi. Une mɨnpazharuzakas wan pɨpulu aizpa sayanazi, usparuza pizanapa. ");
INSERT INTO kwi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","U ñamin uztɨt kwal wan wat awa piantarɨt akwa, une kwisha naizarɨnazi. U kwalne wat awaruza, wat Abeltakis Zacaríastakima piantaara. U kwalne sun unam misharɨkin kasha Dios katsa yalta Zacaríasta, Berequíaspa painkulta, piantaara. ");
INSERT INTO kwi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Watcha kaiznamtus. An ñamin uztuz wat awaruza piantanarɨtkas, ma uztuzne uspa kiarɨt akwa kwisha naizarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalén pɨpulura uztuzne nawa mɨzhain. Une Dios pit kainammtuza piantaara. Une Dios ɨnintuza ukkasa aim kiara. Nane Jerusalén pɨpulura uztuza wanmakshininnamɨztau. Aral kamne aral pashpara ilsap ayukman wanmakninñamtu. Sunkanain nane uruza wanmakshinamɨztau. Une sun pashiarachi. ");
INSERT INTO kwi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nawa mɨzhain. U pɨpulu azpiannapain. ");
INSERT INTO kwi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nane uruza ka kaiznamtu: ‘Une nawa akkwan payurakima izamanazi, na chiyuras kailnakima. Suasne une Dios ɨnintamikane kwisha wari,’ kizanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesúsne Dios katsa yalkis puzta. Ɨamtuasmin, paiña kammuruzne ussa kasha aat kit ussa Dios katsa yalta anamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesúsne sɨnkanara: —Une ma payu sun wan izamtu. Na nua kaiztu aizpa watcha i. An Dios katsa yalkin wan uk taizanazi. Awane wan uk kiakpɨnanazi, wan azpiannapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Suasne Jesúskas paiña kammuruzkas Olivos tɨ kunkin ɨzara nuara. Jesús sua uzasmin, paiña kammuruzne paimpa kaizara: —Aumɨza kainazhain. ¿Miza urama sun kirɨnsa? ¿Nu mamasa kailtuchasmin, au sukin chima kirɨnasa? Wan minpa payura ¿chima kirɨnsa? kizara. ");
INSERT INTO kwi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Suasne Jesúsne kaiznara: “Kuiraruin uzizanaka, mɨnainkas uruza kain kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Akkwan awa nakana namashimtuasmin, uspane ‘Nane Dios nɨrɨtmika ish,’ kizanazi. Pɨrail kaizamtu akwa, uspane akkwantuza kwisha kain kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Awane kasha surakas attishtas surakas waya kianazi. Sun awa waya kiamtu mɨamtane, une ishkwaman. Sunkana watcha kianazi. Mama minpa payu taiztuchi. ");
INSERT INTO kwi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maza sura uztuzne mamaz sura uztuzkasa waya kianazi. Katsa mikwane paiña awa wanmaknat kit mamaz mikwakasa waya kianazi. Awane yak kiarɨnazi. Katsa ki puranazi. Wan su ulanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sunkasa awane naizamɨznazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Suasne awane uruza ɨnintuza chɨhkanazi, uruza kwail kiat kit piantanapa. U nawa kanpaamtu akwa, wan awane uruza pashiamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sun payune akkwan awane na kaiztu aizpa mama nɨjkulamanazi. Usparuzpain pashiamtuchi akwa, uspane usparuzpain mamaztuza chɨhkaanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Akkwan nilchi kainammtuzne aat kit akkwan awaruza kain kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Akkwan kwail kiamtu akwa, awane usparuzpain pashiamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nane minpa payurakima nawa kanpamtuza watsat mɨlnanash. ");
INSERT INTO kwi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wan sura uztuzne Dios watsal pit mɨanazi, us ɨnintukin uzanapa. Kwiztane minpa payu taiznazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Daniel ñamin parɨt aizpa kirɨnazi. Kwail awane Dios sɨnam yalta nappat kit sua kwail kiarɨnazi, awa sua Diosta wakpuj wainñamanpa. ‘Uspane Dios iztakin kwisha kwail kianazi.’ Sun pɨnkɨh izturuzne Daniel parɨt aizpa piankamtain. ");
INSERT INTO kwi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Katmizna sun iztawane, Judea su uztuzne ɨnkal ɨzara aza ɨarawa, usparuza kulanapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yal ɨsalta kwaizkulturuzne ayukman napman, chiwazha ayukmal wa aizpa ukkana. ");
INSERT INTO kwi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nanmal kal kimturuzne yalta kailman, uspa pĩn wa aizpa ukkana. ");
INSERT INTO kwi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sun payura ashampa pɨja wararuzkas chitchu kwintaruzkas kwisha naizarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diosta paikuamɨztain, alu kimtu payurakas kwaizkultu payurakas ɨamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sun payu taizkane, awane kwisha naizarɨnazi. Dios an su sarakima, awane sunkana naizarachi. Sunkanane mamasa awane an naizamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Diosne sun naizmu payu an azain pailninnazi, wan awa iamanpa. Dios narɨttuza pashinamtu akwa, usne sun payura an azain pailninnazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Suasne sun payurane awane ‘Iztain, Dios ɨnintamikane, Cristone, apa tui,’ kizanazi. ‘Iztain, Dios ɨnintamikane, Cristone, sua tui,’ kizanazi. Mɨnpazha sun uruza kizakane, mɨman. ");
INSERT INTO kwi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Akkwan pɨrail kaizmuruzne chaat kit ‘nane Dios nɨrɨtmika ish’ kizanazi. ‘Nane Diospa kainammmika ish’ pɨrail kizanazi. Uspane iztasparɨt kal kianazi, Dios narɨttuzakas kain kianapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nane an ñamin uruza sun kurunnarau. ");
INSERT INTO kwi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Katmizna usparuzakas kwiraruin. ‘Sua sak pul pilkin tui’ kizkane, sua ɨman. ‘Kalmain tui’ kizkane, ussa mɨman. ");
INSERT INTO kwi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dios Painkul akane, awane ussa kai izanazi. Ippane azain pãn puzmukis, pãn payapmal, naztam kwankim. Sunkana Ampu namtɨtmikane azain anazi, wan awa ussa izanapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kalpa irɨkane, pɨkumtuzne irɨttukin azain wanmakkanazi. Naiztɨntu payu taizkane, sunkanane kwail kiarɨttuzne naizarɨnazi. Awane sun urain wan kaarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ ‘Wan naizmu payu pailtawane, sun payura pãnne malmanazi. Palapchakas aizmanazi. Kɨmukas chiyuras taizanazi. Wanne chiyura wa aizpa ulanazi.’ ");
INSERT INTO kwi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Suasne Ampu namtɨtmikane chiyuras anazi, wan awa ussa izanapa. Suasne wan awane azanazi. Ampu namtɨtmikane, katsa mikwakanain, wanishkasain anazi, wan awaruza tɨnta ɨninnana. Usne awa iztakin watsal iztɨt izpannanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iru karaskwil ustuasmin, usne paiña ángeltuza ɨninnanazi, wan narɨttuza akwaninana. Uspane narɨttuza wan chiwal suras wanmakninnanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nane uruza higuera tɨ kamtam kwinta kainammtus. Sun piankamtain. Higuera tɨ kuna kɨh kwizmɨzkane, une pulpanapain pian. ");
INSERT INTO kwi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sunkana wan na kaizta aizpa izakane, minpa payu taiznapain piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Watcha kaiznamtus. Ma payu uztuz iarachasmin, wanne na kaizta aizpa kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wan chiyukas wan pilkas pailtɨmtukas, ap pitne, na kaizta aizpa, mizurainkas pailmanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Na amtu payura mɨnpazha awainkas pianchi. Chiyuras ángelkas pianchi. Nane, Dios Painkulkas, pianchish. Taitta Diosmin na amtu payura pian. ");
INSERT INTO kwi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé uzasmin, awane wan pashiat aizpa kiara. Ampu namtɨtmika akane, awane kawarain kapal kianazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sun payura an sukin pi pɨntachasmin, awane kuamɨz kit chappi kuamɨz kit kasara kit kit pashu mɨlaara, Noé katsa kanuara napta payukima. ");
INSERT INTO kwi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Uspane pi pɨnmɨztu payu pianchimara, alu kimtukima, wantuza pi kwanakima. Sunkanain awane uzanazi, Ampu namtɨtmika kailtu payukima. ");
INSERT INTO kwi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sun amtu payune paas ampune nanmal tuwaiyanazi. Mazara mɨlnazi. Mamazta tuij ɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Paas ashampane pia kɨmtaɨnazi. Mazara mɨlnazi. Mamazta tuij ɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Une iz kit tɨriztain. Une Anpat amtu payu pianchi. ");
INSERT INTO kwi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yalpamikawa wat piankamtain. Walkummikane amtawara chamtu. Walkum amtu payura pianakane, yalpamikane izkultɨt tuanazi, pitnachin. Usne walkummikara paiña yalta walkwan napninnachi. ");
INSERT INTO kwi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Katmizna kawarain ukas kapal sarain. Us amtuchi mintuasmin, sun payura Ampu namtɨtmikane ashina.” ");
INSERT INTO kwi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wat kiwainmumikane anpat pashit aizpa min kit kimtu. Yalpamikane paiña yalta ussa kain tattɨmtu, wanta wat urara kumira kwinnapa, wan mɨj aizpa iznapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Anpat kailkane, paiña anpat kaizta aizpa kimtumikane wat kulnazi, anpat ɨninta aizpa kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Watcha kaiznamtus. Anpatne wan mɨj aizpa kiwainmikasha kain tattɨnazi, anpat mɨj aizpa iznapa. ");
INSERT INTO kwi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sunkana kwail kiwainmumikane ‘anpat azain kailmanazi’ minmɨznazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Suasne usne mamaz kiwaintuza kwail kinamɨztu. Usne kumira kwat kit pirɨttuzkasa chappi kumɨztu. ");
INSERT INTO kwi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kiwaintuz sun amtu payu pianchi akwa, kiwaintuzne anpatta tɨrizamtuchi. Suasne paiña anpatne sun payura kailnazi. ");
INSERT INTO kwi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Anpatne ussa kwail awakasa uzna ɨnin kit ussa tɨnta il kit ĩnta naizninnazi. Suasne usne az kit sula sɨt sɨt kinazi, Diosta pianchiruzkasa ĩnta naiztu akwa.” ");
INSERT INTO kwi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Suasne Diosne sunkana ɨninnazi. Diez nimpihsh kiwain ashamparuzne alampara muara. Uspane kasara kim pishta ɨara, ampura wanmalana. ");
INSERT INTO kwi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco kiwaintuzne wat minñarachi, uspa alampara putnapa watsaana. Mamaz cincoruzne wat minñara, uspa alampara putnapa watsaana. ");
INSERT INTO kwi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kapal sarɨtchiruz alampara mɨlarakas, uspane alampara pi mɨlarachi, mamasa alampara ulna. ");
INSERT INTO kwi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kapal sarɨttuzne alamparakas an alampara ulmu pikas mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ampu kanpain mɨjmika azain amtuchi akwa, wan nimpihsh ashamparuzne pitshiamɨz kit masain pittarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kakwamta pakane, suasne awane ka kwianara: ‘Kanpain mɨjmikane amtui. Puzat kit ussa wanmalnarain,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Diez nimpihsh ashampane izkulat kit uspa alamparara wat saarɨt, kai aiznapa. ");
INSERT INTO kwi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kapal sarachiruzne kapal sararɨttuza kaizara: ‘Au alampara kwirɨmtu. Pitchin alampara pi mɨlazhain,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kapal sarɨttuzne sɨnkaara: ‘Mɨlasachimakpas. Mɨlatne, aune kapal mɨjchiashinamakpas. An wat tintara ɨt kit umin paina ɨrain,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cinco nimpihsh ashampa, kapal sarachiruz, alampara pi paina ɨamtuasmin, ampu kanpain mɨjmikane at. Suasne nimpihsh ashamparuzne kapal sarɨttuzne, uskasa kasara kit pishtara nappara. Suasne pɨjta sɨppara. ");
INSERT INTO kwi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","An kwiztane mamaz nimpihsh ashamparuzne aat kit ka akuamɨzta: ‘Anpat. Anpat. Mɨri. Pɨjta chɨhti,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Usne sɨnkanara: ‘Watcha kaiznamtus. U kapal watsaarachi akwa, une nappasachi. Uruza pianchish,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Suasne Jesúsne ka kaiznara: ‘Wan kapal sawizanaka, u Ampu namtɨtmika amtu payura pianchi akwa,’ kiznara.” ");
INSERT INTO kwi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Diosne sunkana ɨninnazi. Mamaz sura ɨtchasmin, maza ampune paiña kiwaintuza wanmakninnat kit paiña pial usparuza chɨhkanarɨt, pial pamikawa kal kianpa. ");
INSERT INTO kwi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Usne pakaish pakaish maza mazara uspa pial mɨlanarɨt, us pashimtu aizpa kinpa. Usne mazara, wat kal kinpa pianmikasha, cinco mil pial mɨlat. Mamazta, we kal kinpa pianmikasha, paas mil pial mɨlat. Mamazta an we kal kinpa pianmikasha, maza milmin pial mɨlat. Wanne pial sappara, sun pialkasa paiña kal kiana, an pial kana kiana. Pial chɨhkarawane, pialpamikane masain mamaz sura ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco mil pial saptamikane sun pialkasa chiwazha pait kit paininta. Sunkana usne an cinco mil pial kana kira. ");
INSERT INTO kwi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Paas mil pial saptamikane sunkanain kit kit an paas mil pial kana kira. ");
INSERT INTO kwi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pial pamikawa pial saptawane, maza mil pial saptamikane pil kul sat kit pial pilta puinta. ");
INSERT INTO kwi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Akkwan payu pailtawane, anpatne kail kit sunpawa pial saptaruzkasa wianmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","An ñancha cinco mil pial saptamikane at kit cinco mil pialkas cinco mil kana kit aizpakas pamikasha chɨhkat kit kaizta: ‘Anpat. Nune nawa cinco mil chɨhkaish. Nane an cinco mil kana kirau. Wan sapti,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pamikane sɨnkara: ‘Kwisha wat. Nune kwisha nil kiwainmumika i. Nune na pashimtu aizpa nil kirɨt. Nu pitchinkasa wat kirɨt akwa, nane nua an akkwan chɨhkattarɨnash. Nakasa at kit nakasa wat kulnaka.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kwiztane paas mil pial saptamikane at kit pamikara kaizta: ‘Anpat, nune nawa paas mil pial chɨhkaish. Nane an paas mil kana kirau. Wan sapti,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pamikane sɨnkara: ‘Kwisha wat. Nune kwisha nil kiwainmumika i. Nune na pashimtu aizpa nil kirɨt. Pitchinkasa wat kirɨt akwa, nane nua an akkwan chɨhkattarɨnash. Nakasa at kit nakasa wat kulnaka,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Minpa maza mil pial saptamikane at kit pamikara kaizta: ‘Anpat. Nane up kiwaintuza kwisha tɨnta ɨninnamtu pianish. Uspa up sukin kal kiamtu akwa, nune pial saptu. Uspa up sukin pippa pakkamtu akwa, nune uspa pippa paktu aizpa saptu. ");
INSERT INTO kwi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Katmizna nane ishkwat kit up pial pilta puina ɨrau. Up pial sapti.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pamikane sɨnkara: ‘Nune kwail kiwainmika i. Arakan i. Nune na kimtu aizpa nilchi mintu. Ap sukin na kal kimtuchikas, na pippa wamtuchikas, nane chiwazha pakta aizpa sapnash. Nune sun pian. ");
INSERT INTO kwi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Sunkana mintane, nune ap pial watsamtukin watsakamtish, an pial kana kinpa. Sunkana nane ap pial kana kit aizpa sapshinas.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pamikane sua puraruza kaiznara: ‘Ussa maza mil pial nakat kit diez mil pial mɨjmikasha mɨlari. ");
INSERT INTO kwi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Akkwan mɨjmikane an akkwan sapnazi, tiznakima. Pitchin mɨjmikane us mɨj aizpa karɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","An tɨnta kal kishimtuchimikasha tɨlkwilmal ɨnintain. Suane usne az kit sula sɨt sɨt kinazi, Diosta pianchiruzkasa naiztu akwa,’ kiznara.” ");
INSERT INTO kwi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ampu namtɨtmika paiña ángeltuzkasa akane, usne watsal iz kit paiña uzmukin chiyura uznazi. ");
INSERT INTO kwi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wan suras awane paiña iztakin wanmakkanazi. Usne pɨriku izmumikana i. Pɨriku izmumikane pɨrikuruzkas cabraruzkas paimpa ɨninnanazi. Kawarain Ampu namtɨtmikane wan awaruza paimpa ɨninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Usne wattuza paiña numalpara ɨninnanazi, uskasa tuanpa. Kwailtuza paiña kwiyamarain ɨninnanazi, usparuza ilnanapa. ");
INSERT INTO kwi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Suasne mikwane numal kuntuza ka kaizazi: ‘Une arain. Diosne uruza wat kiwainnanazi, paiña ɨnintukin puranpa. Au su sarachasmin, usne uruza wanmakninna minta, u uskasa uzanapa. ");
INSERT INTO kwi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na yak kikane, une nawa kwinñash. Na kwazi kilkane, une nawa kwazi kwinñash. Na u sura uzasmin, une u yal nammɨlash. ");
INSERT INTO kwi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na pĩn wekas, une nammɨlash. Na ishtukas, une nawa iznash. Na kajchira warakas, une nawa iznash.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Suasne waruzne sɨnkanazi: ‘Anpat. ¿Miza urama aune nu yak kira iztamakpas? ¿Miza urama aune nua kumira kwintamakpas? ¿Miza urama aune nu kwazi kikka izaramakpas? ¿Miza urama nua kwazi kwintamakpas? ");
INSERT INTO kwi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Miza urama nu mamaz sura chamtu awakana iztamakpas? ¿Miza urama nua yal nammɨlaramakpas? ¿Miza urama nu pĩn we aizpa mɨlaramakpas? ");
INSERT INTO kwi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Miza urama aune nua intura iztamakpas? ¿Miza urama aune nua kajchira wara izna ɨramakpas?’ ");
INSERT INTO kwi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ɨninmikane usparuza sɨnkananazi: ‘Watcha kaiznamtus. Une an we tɨntaruza, nawa we piantuza, kiwainanara. Usparuza wat kiwainarɨt akwa, une nawa wat kiarɨt.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Suasne Mikwane kwiyamal puraruza kaiznanazi: ‘Nakis paimpa ɨmɨztain. U kwail kiarɨt akwa, une ĩnta ɨrain, sua pailta payukima uzanapa. Diosne ĩnta sara, Diablokas paiña ángeltuzkas sua puranpa, sua naizanapa. ");
INSERT INTO kwi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na yak kirakas, une nawa kwinamash. Na kwazi kiktakas, une kwazi kwinamash. ");
INSERT INTO kwi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mamaz suwara charakas, une nawa yal nammɨlaamash. Na pĩn we mɨjkas, une nawa pĩn mɨlaamash. Na inturakas, une nawa izaamash. Kajchira warakas, une nawa izaamash.’ ");
INSERT INTO kwi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Suasne uspane mɨmaanazi: ‘Anpat miza uruma aune nu yak kimta izaramakpas. ¿Miza urama nua kumira kwintachimakpas? ¿Miza urama aune nu kwazi kiktura izaramakpas? ¿Miza urama kwazi kwintachimakpas? ¿Miza urama nua mamaz sura izaramakpas? ¿Miza urama nua yal nammɨlatchimakpas? ¿Miza urama nua pĩn we aizpa izaramakpas? ¿Miza urama pĩn mɨlatchimakpas? ¿Miza urama aune nu intura izaramakpas? ¿Miza urama nua kajchira iztamakpas? ¿Miza urama nua kajchira izna ɨtchimakpas?’ ");
INSERT INTO kwi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","46","Mikwane usparuza sɨnkananazi: ‘Watcha kaiznamtus. Une an we tɨntaruza nawa we piantuza, kiwainnarachi. Usparuza wat kiwainarachi akwa, kawarain une nawa wat kiwaintachi. Suasne suntuzne pailta payukima ĩnta naizarɨnazi. Wattuzne Dios iztakin pailta payukima chiyura wat uzanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wan kapal kaiznarawane, Jesúsne kammuruza kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pa payu pailtɨkane, une Pascua pishta taiztu pianmai. Awane Ampu namtɨtmikara chɨhkaanazi, tɨra patpian piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sun payuin katsa pariya ɨnintuzkas Moisés para aizpa kamtamtuzkas Judío ɨlaparuzkas Caifáspa katsa yal pianakin wanmakkara. Caifásne an katsa pariyamika azi. ");
INSERT INTO kwi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Suasne uspane Jesúspa pɨrail kaizninna minñashira, ussa piz kit piantana. ");
INSERT INTO kwi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Uspane usparuzpain kaizara: —Pishta chasmin, ussa piznachiwamakpas, awa kwisha pilchapuzamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesúsne Betania pɨpulura ɨra, Simónpa yalkin nukkulna. Simónne pɨttɨt aya kakultɨtmika azi. ");
INSERT INTO kwi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús misharɨkin kumtuasmin, maza ashampane piam pih ulmu karat kit kashara at. An ulmune alabastro ukkasa sarɨt. An watsal piam pihne kwisha muin. Jesús uzasmin, an ashampane piam pih Jesúspa kɨzpukin paranta. ");
INSERT INTO kwi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kammuruz sun izarawane, aliz pilchapuzat kit kaizamɨzta: —¿Chikishka an piam pih kain pattarɨmtu? ");
INSERT INTO kwi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Akkwan pialkasa painninshinari, puizaruza kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesúsne uspa kaizamtu aizpa mɨt kit kaiznara: —¿Chikishka an ashampara kwail kizappamtu? Us nawa sun kirɨt aizpa wari. ");
INSERT INTO kwi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Puizaruzne pailta payu uruzpain uzanazi. Nane ukasa pailta payura uzmanash. ");
INSERT INTO kwi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","An piam pih ap kɨzpukin parantuasmin, an ashampane na imtu payura kapal sarɨt, nawa kamna. ");
INSERT INTO kwi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nane watcha kaiznamtus. Dios watsal pitne wan sura kainarɨnazi. Sun pit mɨraruzne an ashampa kit aizpa mɨat kit an ashampawa minñanazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mazane, doce kammuruztas, Judas Iscariotene muntɨt. Usne katsa pariya ɨnintuzkasa kwinta kin ɨt ");
INSERT INTO kwi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kit kaiznara: —Na uruza Jesústa chɨhka namtune, ¿Yawa pialma nawa taanapas? Suasne uspane treinta pial tana namaara. ");
INSERT INTO kwi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sun payuras Judasne wat urain saimɨzta, ussa usparuza chɨhkan. ");
INSERT INTO kwi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sun Pascua pishtara awane pan kiñakasachin kuara. An ñancha pishta payura paiña kammuruzne Jesústa tukin aat kit mɨmaara: —¿Mɨntama Pascua kumira saanapai, an kumira kwan? ");
INSERT INTO kwi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Usne sɨnkanara: —Sun pɨpulura ɨat kit maza ampuwa yalta piannarain. Ussa kaiztain: “Anpatne ka kiztu: ‘Na imtu payu kasha panapain. Nane ap kammuruzkasa up yalta ɨmtus, Pascua pishta kumira kwan.’ ” ");
INSERT INTO kwi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kammuruzne Jesús ɨninta aizpa kiil kit Pascua kumira sailta. ");
INSERT INTO kwi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Amta tɨl parɨkane, Jesúskas paiña doce kammuruzkas misharɨkin uzaara. ");
INSERT INTO kwi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kuamtuasmin, Jesúsne kaiznara: —Watcha kaiznamtus. Maza uruztas nawa kwailtuza chɨhkanazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Suasne uspane tayalmɨz kit mazanta mazanta ussa mɨmaamɨzta: —Anpat. ¿Na sun kinsa? ");
INSERT INTO kwi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesúsne sɨnkanara: —Na uruzkasa an kumira kumtukas, mazane, nakasa kumtumikane, nawa kwailtuza chɨhkanazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dios pɨnkɨhkin Ampu namtɨtmika irɨnazi parɨt. Us irɨkas, ussa kwailtuza chɨhkatmikane kwisha naiztɨnazi. An ampu kawirachiatne, an warashina. ");
INSERT INTO kwi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Suasne Judasne, ussa kwailtuza chɨhkatmikane, Jesústa mɨmara: —Anpat. ¿Nane nua chɨhkansa? Jesúsne sɨnkara: —Watcha. Nu sun kaizta aizpa kinazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kuamtuasmin, Jesúsne pan piz kit Diosta aishtaish kizta. Pan kɨztawane, usne kammuruza kwinat kit kaiznara: —Kwarain. An panne ap ña i. ");
INSERT INTO kwi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Suasne usne maza vino waz piz kit Diosta aishtaish kizta. Waz annamtuasmin, kaiznara: —Une an waztain wan kwarain. ");
INSERT INTO kwi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","An vinone ap aimpi i. Na imtu akwa, Diosne ukasa masas contrato kin namtɨnazi. Ap aimpi puztu akwa, nane akkwan awa kwail kiarɨttuza wat kulnanash. ");
INSERT INTO kwi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nane an vino kumanash, ap Taittawa ɨnintukin napnakima. Suane aune mamasa kuiznawas. ");
INSERT INTO kwi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kanta kizarawane, uspane Olivos tɨ kun ɨzara nuara. ");
INSERT INTO kwi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Suasne Jesúsne kaiznara: —Ma amtane uruzne nakis paimpa ɨat kit nawa chɨhkaamɨznazi. Une Dios pɨnkɨhta parɨt aizpa ka kianazi. “Nane pɨriku pamikasha ininnash. Suasne pɨrikuruzne paimpa maza mazain ɨanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na irɨttas kuhstawane, u Galilea sura ɨamtuchasmin, nane ukin an ñancha ɨnash. ");
INSERT INTO kwi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedrone ussa sɨnkara: —Wan nukis paimpa ɨamtukas, nane nukis ɨmanash. ");
INSERT INTO kwi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Suasne Jesúsne ussa kaizta: —Watcha kaiztus. An amtain aral kayu aztuchasmin, nune kutña pijikima “ussa pianchish” kiznazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro kaizta: —Na nukasain imtukas, nane “nua pianchish” kizmanash. Wan kammuruzne sunkanain kizara. ");
INSERT INTO kwi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Suasne Jesúskas paiña kammuruzkas Getsemaní nanmalkin pianaara. Usne kaiznara: —Na an ta Diosta paikwan ɨmtuasmin, une apain uztain. ");
INSERT INTO kwi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Usne Pedrorakas paas Zebedeo painkultakas ta mɨlnara. Usne kwisha tayalmɨz kit ishkwatkana mimɨzta. ");
INSERT INTO kwi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Suasne kaiznara: —Nane ayuktain, ap kaijchurain, kwisha tayaltus, inakima. Akkin nukkul kit nakasa izkultain. ");
INSERT INTO kwi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Suasne Jesúsne an attishta ɨt kit matsɨh pilta wain kit Diosta paikwat kit kaizta: “Ap Taitta mɨzha. Na ishimtuchish. Nawa naizninmun. Na naiztukas, na pashimtu aizpa kimun. Nu pashimtu aizpa kiri,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Suasne paiña kammuruz purakin ɨt. Usne usparuza pittɨt tu wanmalnat kit Pedrora kaizta: —¿Une maza urain nakasa izkulasachimakkiwas? ");
INSERT INTO kwi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Izkulat kit Diosta paikwarain, kwail kiamanpa. Watcha kaiznamtus. Nil kiashimtukas, une tailchaamanazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mamasa ɨt kit sunkana Diosta paikwat: “Ap Taitta mɨzha. Na ishimtuchish. Nawa naizninmun. Na imanpa chɨhshitne, sun kiri. Sun kisachine, mama nu pashit aizpa kiri. Na pashimtu aizpa kimun. Nuin pashimtu aizpa kiri.” ");
INSERT INTO kwi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Suasne Jesúsne mamasa kail kit paiña kammuruz pittɨt pura wanmalnara. Uspane kwisha pittashira. ");
INSERT INTO kwi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Usne usparuza tuij ɨnat kit mamasa Diosta paikwat kit sun pitmin kaizta. ");
INSERT INTO kwi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Suasne kammuruz purakin ɨt kit kaiznara: —Mane pit kit kwaizkultain. Iztain. Awane me aanapain. Uspane Ampu namtɨtmikara kwail awaruza chɨhkaanpain. ");
INSERT INTO kwi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kuhs kit ɨmɨrachain. Nawa chɨhkamtumikane me amtui. ");
INSERT INTO kwi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús paramtuasmin, Judasne, maza kammumikane, piannat. Uskas kwisha akkwan awakas mashti kwizkasakas tɨkasakas aara. Pariya ɨninturuzkas Judío awa ɨlapa ɨninturuzkas usparuza ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasne, sun chɨhkatmikane, usparuza izpa sat kit kaiznara: “Nane mazara matsɨhkin putchunnash. Sunne u saimtumika i. Ussa mɨltain.” Sunkana ñamin kaiznara. ");
INSERT INTO kwi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Suasne Judasne Jesústa kasha at kit kaizta: —Anpat. Kakishapu. Usne Jesústa matsɨhkin putchunta. ");
INSERT INTO kwi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsne sɨnkara: —Izmuruz. Nune nakin kakishapu kizna atchi. Nu minta aizpa kiri. Suasne awaruzne Jesústa kasha aat kit pizaat kit mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ussa mɨlaamtuasmin, mazane Jesúspa kammumikane, paiña mashti kwiz ukkat kit katsa pariyawa kiwainmikasha kail yalta. ");
INSERT INTO kwi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Suasne Jesúsne ussa kaizta: —Up mashti watsat. Mashtikasa waya kimikane sunkasa mashti kwizkasa inazi. ");
INSERT INTO kwi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na ap Taittara paikwatne, usne mamin nawa doce ángeltuzpa kwaltuza, ɨninshina, waya kit kit nawa kiwainapa. ¿Sun pianchikish? ");
INSERT INTO kwi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma payu sun paikumanash, Dios pɨnkɨhta parɨt aizpa kinpa. ");
INSERT INTO kwi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Suasne Jesúsne awaruza kaiznara: —¿Chikishma mashti kwizkasakas tɨkasakas aamtu, nawa pizna? Nane walkumchi ish. Nane pailta payu Dios katsa yalkin uruza kamtanamɨztau. Suane une nawa pizamash. ");
INSERT INTO kwi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma payu une wan kiamtu aizpa izamtu. Dios kainammtuz sunpa ñamin kwinta kiarakas, ma payu Diosne paiña pɨnkɨhkin parɨt aizpa pailtɨmtu. Suasne wan kammuruzne Jesústa chɨhkaat kit ɨarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesústa piztaruzne ussa Caifás tukin mɨlaara. Usne katsa pariya ɨninmika azi. Moisés kaizta aizpa kamtamtuzkas Judío ɨlaparuzkas sua wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrone attishtas kanpara, katsa pariyawa yalta piannarakima. Piannarawane, usne nanmalta ɨt kit policía awaruzkasa uzta, chiwazha kimtu aizpa izna. ");
INSERT INTO kwi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Katsa pariya ɨninturuzkas, ɨlaparuzkas, wan Judío ɨninturuzkas pɨrail kaizmuruza sayamɨzta, Jesús kwail kirɨt kizana. Judío ɨnintuzne Jesústa piantana ɨninashira. ");
INSERT INTO kwi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Akkwan awa aat kit pɨrail kaizarakas, mɨnminkas Jesús kwail kirɨt nɨjkularachi. Minparane paas pɨrail kaizmuruzne ail ");
INSERT INTO kwi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kit ka kaizpailta: —An ampune ka kaizta: “Katsa Dios yal azpiantawane, nane kutña payura mamaza sashinash.” ");
INSERT INTO kwi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Suasne katsa pariya ɨninmikane kuhs kit Jesústa mɨmara: —¿Sɨnkamankish? ¿Uspa kaizamtu aizpa nilki? ");
INSERT INTO kwi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesúsne puñain parɨt. Suasne katsa pariyane ussa kaizta: —Diosne chiyura uz kit nu kaiztu aizpa mɨmtu. ¿Nu Cristo muntɨtmika kish? ¿Nu Dios Painkul kish? Dios iztukin aumɨza watcha kaizchain. ");
INSERT INTO kwi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsne sɨnkanara: —Watcha, na ish. Nane an uruza kaiznamtus. “Une Ampu namtɨtmikara Diospa numal ɨnintukin izanazi. Chiyuras wanishkasain amtuasmin, une ussa izanazi.” ");
INSERT INTO kwi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sun mɨrawane, katsa pariyane aliz kul kit paiña pĩn pshat kit awaruza kaiznara: —An ampune Diospa kwail pit paramtu. Mamaz awara saimtuchimakpas, us kwail kirɨt aizpa kizna. Une us Diospa kwail pit paramtu mɨamtu. ");
INSERT INTO kwi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Miza minñamtuas? kizara. Uspane kaizara: —Kwail kiztu akwa, usne irawa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Suasne uspane matsɨhkin ilpi kiat kit chihtɨkasa aim kiara. Mamaztuzne matsɨhkin kuzat kit ");
INSERT INTO kwi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kaizara: —Nune “nane Dios nɨrɨtmika ish” kiztu. Katmizna, Dios nua kiwaintu akwa, ¿mɨnma nua kuzamtu? kainazhain, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro pianamal uzasmin, maza ashampa kiwainmikane at kit Pedrora kaizta: —Nukas Jesúskasa, Galilea sura atmikakasa, chara. ");
INSERT INTO kwi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedrone wan iztakin pɨrail kiz kit kaizta: —Nu kaiztu aizpa pianchish. ");
INSERT INTO kwi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro pɨjta napmura ɨmtuasmin, mamazne ussa iz kit puraruza kaiznara: —Jesús, Nazaret pɨpuluras at mika, apa chamtuasmin, an ampukas Jesúskasa chara. ");
INSERT INTO kwi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mamasa Pedrone pɨrail kiz kit kain kaizta: —Dios iztakin nane an ampura pianchish, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","An kwizta puraruzne Pedrora kasha aat kit kaizara: —Watcha. Nukas usparuzkasa chatmika i. Nune usparuzkanain paramtu. ");
INSERT INTO kwi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Suasne Pedrone akkwan piji kaizmɨzta: —Na pɨrail kaizmɨztane, Diosne nawa ininshina. An ampura pianchish. Sun urain aral kayune azta. ");
INSERT INTO kwi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Suasne Pedrone Jesús kaizta aizpa nɨjkulta. Ñamin Jesúsne ussa kaizta: “Aral kayu aztachasmin, nune kutña pijikima, ‘ussa pianchish’ kiznazi.” Pedrone tas puz kit kwisha tɨnta azta. ");
INSERT INTO kwi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɨnmɨzkane, wan pariya ɨninturuzkas Judío ɨlaparuzkas nɨjkulat kit Jesústa piantana minñara. ");
INSERT INTO kwi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Uspane Jesústa kuhat kit ussa Pilatora, Roma mikwara, chɨhkara. ");
INSERT INTO kwi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judío ɨninturuzne awaruza paikwaara, Jesústa piantanapa. Sun piankamtawane, Judasne, Jesústa chɨhkatmikane, tayalmɨzta, awa Jesústa piantashit akwa. Usne pariya ɨninturuzakas Judío ɨlaparuzakas ɨt kit treinta pialkasa kail kit ");
INSERT INTO kwi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","kaiznara: —Nane kwail kirau, na kwail kitchimikasha innapa chɨhkat akwa. Uspane sɨnkaara: —Nu ussa chɨhkat akwa, nune nu kimtu aizpa mintawa. Nuin sun kirɨt. ");
INSERT INTO kwi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Suasne Judasne tas puz kit Dios yalkin pial pattara. Suasne ɨt kit usmin kwil tɨt kuh kit usmin kan kit ira. ");
INSERT INTO kwi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pariya ɨninturuzne sun pial sakkat kit kaizara: —Judas an pialkasa ampura piantana paininta akwa, aune Diospa pial sapmukin taasachimakpas. ");
INSERT INTO kwi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Suasne uspane sun pialkasa pil paina pashiara. Uspane pail sammikawa nanmal payara, mamaz suras awaruza kamnana. ");
INSERT INTO kwi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Katmizna makima “sun pilne aimpi nanmal” muntɨt, an pialkasa awa mazara piantanapa pait akwa. ");
INSERT INTO kwi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeremíasne, Dios kainammmikane, sun kirɨt aizpa ka pɨnkɨhta parɨt: “Uspane treinta pial sappara. Israel awane sunpawa pial taana nɨjkulara, awara paina. ");
INSERT INTO kwi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Uspane sun pialkasa pail sammikawa nanmal payara. Uspane chiwazha Anpat nawa ɨnintɨt aizpa kiara,” Jeremías kizta. ");
INSERT INTO kwi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús Pilatokin panasmin, usne Jesústa mɨmara: —¿Nune Judío awawa mikwa kish? Jesúsne ussa kaizta: —Nu kaizta aizpa watcha i. ");
INSERT INTO kwi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pariya ɨninturuzkas Judío ɨlaparuzkas us kwail kirɨt kizmɨztuasmin, Jesúsne usparuza sɨnkanarachi. ");
INSERT INTO kwi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatone ussa mɨmara: —¿Uspa nua kwail kizamtu aizpa mɨmtuchikish? ");
INSERT INTO kwi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesúsne ussa chinkas sɨnkamɨztachi. Katsa ɨninmikane iztasparɨt. ");
INSERT INTO kwi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pascua pishta tuasmin, Romano mikwane maza kajchira wamikara chɨhtuazi. Usne awa narɨtmikara chɨhtshina. ");
INSERT INTO kwi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Suane maza kwisha kwailmikane kajchira wara. Usne Barrabás muntɨt. Akkwan awane paiña kwail kirɨt aizpa piankaamara. ");
INSERT INTO kwi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Awa wanmakkamtuasmin, Pilatone mɨmanara: —¿Une chima pashiamtu, na kinpa? ¿Barrabásta chɨhtawasa? ¿Jesústa, chɨhtawasa? ¿Dios nɨrɨtmika muntɨtmikara chɨhtawasa? ");
INSERT INTO kwi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatone sun mɨmara, Jesústa chɨhtshimtu akwa. Awa Jesúskasa aliz kulamtu akwa, uspane Jesústa chɨhkaara. Pilatone sun piankamta. ");
INSERT INTO kwi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato paiña ɨnintukin uzasmin, paiña ashampane paiña pit ussa ɨnin kit kaizta: “An ampukasa kimun. Usne wat awa i. Amtawara kainkizpamtuasmin, nane us akwa kwisha naiztau.” ");
INSERT INTO kwi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pariya ɨnintuzkas Judío ɨlaparuzkas wan awaruza tɨnta kurunnara, Pilatora paikwan, Barrabás chɨhtna, Jesústa piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Katsa mikwane mamasa usparuzkasa paranat kit mɨmanara: —¿Sun paastas mɨnmikama chɨhtna pashiamtu? Uspane sɨnkaara: —Barrabásta chɨhtti. ");
INSERT INTO kwi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatone mɨmanara: —¿Jesúskasa chima kinpai? ¿Dios nɨrɨtmika muntɨtmikakasa chima kinpai? Cristora munamtu. Wan awane sɨnkaara: —Ussa kurishta pat piantarawa. ");
INSERT INTO kwi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Suasne Pilatone kaiznara: —¿Usne chi kwail kirɨt? Uspane an tɨnta kwianamɨzta: —Ussa kurishta pat piantari. ");
INSERT INTO kwi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato kaizta aizpa mɨarachi akwa, ussa kwisha pilchapuzara akwa, Pilatone kwazi kanapa ɨnin kit awa iztakin paiña chihtɨ kit kit kainanara: —Nane an wat ampura piantanapa ɨninmanash. Umin ussa ininñaanazi. ");
INSERT INTO kwi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wan awane sɨnkaara: —Nu ussa inapa ɨnintane, aune au paikwat aizpa nɨjkulnamakpas. Au ussa kwail kiarɨtne, aukas au pashparuzkas us akwa naizshinamakpas. ");
INSERT INTO kwi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Suasne Pilatone Barrabásta chɨhtta. Jesústa ilna ɨnintawane, Pilatowa kiwainturuzne Jesústa Roma suldaruruza chɨhkanara, kurishta pat pian kit piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Suasne ɨninmikawa suldaruruzne Jesústa Roma ɨninmikawa yalta mɨlara. Wan suldaruruzne Jesúspa mamin pɨlsaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Suasne uspane paiña pĩn nakaat kit kwanamkana pĩn, mikwawa kwakshamkana, kwaninñaara. ");
INSERT INTO kwi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Uspane akkwan pu tɨt iptɨt kit mikwawa chuttakana saara. Suasne paiña kɨzpukin sɨnaara. Maza mikwawa tɨkana paiña numal chihtɨkin pizninara. Suasne uspane us iztakin wakpuj wainñat kit ussa ishanat kit kaizara: —¡Nune Judío awara mikwa i! Wat kɨntɨre, kizara. ");
INSERT INTO kwi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Uspane ussa ilpi kiat kit sun mikwawa tɨkasa kɨzpukin pianara. ");
INSERT INTO kwi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ussa ishanarawane, uspane kwanamkana pĩn nakaat kit paiña pĩn kwaninñara. Suasne ussa mɨlaara, ussa kurishta patpian piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Puzamɨztuasmin, Roma suldaruruzne maza Cirene suras ampura wanmalara. Usne Simón mun. Uspane ussa Jesúspa us kurish munana ɨninara. ");
INSERT INTO kwi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sunkanain uspane Gólgota ɨza munkin pianaara. Sun Gólgota ɨzane “irɨt kɨzpukana iz kit ka muntɨt.” ");
INSERT INTO kwi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Suane uspane Jesústa tain vino kwanpa kwinñara, ishmanpa. Kwaiztawane, usne chinkas kwashitchi. ");
INSERT INTO kwi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ussa kurishta inapa pat piantawane, suldaruruzpain ukkasa salara, Jesúspa pĩn kana kin. Dios kainammmika kaizta aizpa sunkana kirɨt. Ka kizta: “Uspane salat kit ap watsal kwaksham kana kinazi. Uspane usparuza ap pĩnkas naiyanazi,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Suasne sua uspane uzara, Jesústa izana. ");
INSERT INTO kwi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uspane tɨ akkalta paat kit Jesúspa kɨzpu ɨsal pattara. Sun pitne ka kizta: ANNE JESÚS I. USNE JUDÍO AWAWA MIKWA I. ");
INSERT INTO kwi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Uspane uskasa paas walkummikarakas tɨra pat pianara. Mazara paiña numal mamaz kurishta pattara. Mamazta paiña kwiyamal mamaz kurishta pattara. ");
INSERT INTO kwi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pɨnturuzne ussa kwail pit kizara. Uspa kɨzpu kialtuasmin, uspane ");
INSERT INTO kwi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ka kaizamɨzta: —Nune akkwan pit kaizta. Nune an Diospa yal kutña payura mamaza sanash kizta. Katmizna nuin kiwainti. Nuin Dios painkul kane, nuin kurishtas kihshti. ");
INSERT INTO kwi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pariya ɨnintuzkas Moisés kaizta aizpa kamtamtuzkas, Fariseo awaruzkas Judío ɨlaparuzkas ussa ishanat kit usparuzpain kaizara: ");
INSERT INTO kwi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Us mamaztuza watsat mɨlnarakas, usmin watsat mɨlsachi. Israel awa mikwa kane, usne kurishtas kihshshina, au us kaizta aizpa nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Diosta nɨjkultune, usne makis Diosta ussa watsat mɨlnapa paikwatpa. Dios ussa pashimtune, Diosne ussa kiwainshina, us “Dios painkul ish” kizta akwa. ");
INSERT INTO kwi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jesúskasa kurishta pat piantɨtkas, an paas walkumtuzkas Jesústa kwail kaizpailta. ");
INSERT INTO kwi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Paizka payukis kutña urakima wan sura tɨlkwil paarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sun kutña urain Jesúsne paiña Hebreo pitkasain tɨnta ka kwianta: “Eli, Eli, ¿lema sabactani?” (Au pitkasain ka kizta: “Ap Dios, Ap Dios. ¿Chishma nawa kwairɨt?”) ");
INSERT INTO kwi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɨnpazha sua puraruzne mɨat kit kaizara: —An ampune Elías kainammmikara akumtu. ");
INSERT INTO kwi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sun urain mazane usparuztas ãĩn ɨt kit pimpuh kana ɨt. Pimpuhta tain vinokasa parantawane, an ampune pimpuh tɨkin tat kit Jesústa kashara nuninta, tuknapa. ");
INSERT INTO kwi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mamaztuzne kaizara: —Sun kimun. Elías kiwaina amtuka, izanapas. ");
INSERT INTO kwi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús mamasa tɨnta kwiantawane, ira. ");
INSERT INTO kwi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sun urain nain pĩn kantɨt Diospa yalkin kwashtas pihshara, piltakima. Sun nain pĩn akwa, mamaz kanmal sɨptɨt. Pilne ulta. Ukkas kɨzara. ");
INSERT INTO kwi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pantiónpa yal azpianara. Akkwan Diosta piantuza irɨttas kuhsara. ");
INSERT INTO kwi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kuhsarawane, pantión yalkis puzara. Jesús irɨttas kuhstawane, an kuhsararuzne Diospa watsal Jerusalén pɨpulura nappara. Suane akkwan awane usparuza izara. ");
INSERT INTO kwi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Suasne suldaru ɨninmikakas Jesústa izmuruzkas ulmu mazara. Wan kiarɨt aizpa izara akwa, uspane kwisha ishkuat kit kaizara: —Watcha. An ampune Dios Painkul ara. ");
INSERT INTO kwi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Suane akkwan ashampane attishtas izara. Uspane Jesústa kiwainat kit Jesústa Galilea suras kanpaara. ");
INSERT INTO kwi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maríakas Magdalena pɨpuluras ara. Mamaz Maríakas ara. An Maríane Santiagowa akkuhshkas Joséwa akkuhshkas ara. Zebedeowa painkultuzpa akkuhshkas ara. ");
INSERT INTO kwi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nashmɨzkane, maza kwazpa ampune ara. An Arimatea pɨpuluras awane José muntɨt. Uskas Jesústa kammumika azi. ");
INSERT INTO kwi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Suasne usne Pilatora izna ɨt kit Jesús irɨtta paikwara, ussa kamna. Suasne Pilatone ussa chɨhkanpa ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joséne irɨtmika kurishtas mushat kit muin sɨnam pĩn ip kit ");
INSERT INTO kwi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","paiñain masas uk kulta kamta. Suasne usne ñamin sun kul kapal sarɨt, ussa sua kamnapa. Katsa ukkasa sun kulta sɨptawane, ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Suane Magdalena suras Maríakas mamaz Maríakas kamkin izawara uzara. ");
INSERT INTO kwi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pascua pishta kapal watsarawane, tɨlawarane, kwaizkultu payura, Sábado payura, pariya ɨninturuzkas Fariseo awaruzkas Pilatora izna ɨat ");
INSERT INTO kwi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kit kaizara: —Mikwa, aumɨza mɨzhain. Uzasmin, an pɨrail kaizmumikane “kutña payura irɨttas kakulnash” kizta. ");
INSERT INTO kwi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Katmizna up kiwaintuza kamkin izna ɨninnari kutña payurakima. Suasne paiña kammuruzne amtawara aamanazi, irɨtta walkwan. Jesús uzasmin, “nane Dios ɨnintamika ish” kizta. Paiña kammuruz “us irɨttas kakultɨre” kizarane, an minpa pɨrail an ñancha pɨrailkin anza kwail namnazi. ");
INSERT INTO kwi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatone kaiznara: —Une an kiwaim suldaruruza mɨltain, kamkin anza wat izanapa, mɨnminkas nappamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Suasne uspane kamkin ɨat kit sɨpmu ukkin watsal sɨppara, mamaztuz nappamanpa. Suasne suldaru kiwaintuza chɨhkanarɨt, izanapa. ");
INSERT INTO kwi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kwaizkultu payu pɨnkane, domingo payu kɨnmɨzta. An domingo payu kɨnmɨzkane, Magdalena pɨpuluras Maríakas mamaz Maríakas kamkin izna ɨilta. ");
INSERT INTO kwi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Amtazasmin, masain pilpara tɨnta ul samɨzta. Anpatpa ángelne chiyuras kihsh kit piannat kit uk sɨptɨt tainkat kit ukkin uzta. ");
INSERT INTO kwi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","An ángelne ippakana naztam aizta. Paiña pĩn putchã iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sun izarawane, suldaruruzne ulat kit ishkuara. Ishkuamtu akwa, uspane irɨttuzkanain namarɨt. ");
INSERT INTO kwi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Suasne ángelne ashamparuza kaiznara: —Ishkuman. Nane u Jesústa, piantarɨtmikasha, saimtuas pianish. ");
INSERT INTO kwi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Usne akki tuchi. Ukasa uzasmin, usne uruza kainanat kit us kaizta aizpa kirɨt. Usne me irɨttas kuhsta. Mɨnta ussa kamtakin iztain. ");
INSERT INTO kwi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Azain ɨat kit paiña kammuruza ka kaiznarain: “Irawane, usne me irɨttas kuhsta. Galilea sura ɨrain. Usne ukin an ñancha ɨmtu. Sua ussa izanazi.” Nane apain atpaish, sun uruza kaiznana. ");
INSERT INTO kwi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Suasne ashamparuzne azain kamkis ɨilta. Ishkuamtukas, wat minñara. Ãĩn ɨntazasmin, ɨil kit paiña kammuruza sun pit kainailta. ");
INSERT INTO kwi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɨmtazasmin, Jesúsne usparuza kasha at kit “kakishapu” kizta. Suasne uspane Jesústa ail kit wakpuj wainpail kit chihtɨkasa mittɨkin ippailta. ");
INSERT INTO kwi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Usne usparuza kaiznara: —Ishkuman. Ap kammuruza kainarain, Galilea sura ɨanapa. Tane uspane nawa izanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ashampa ɨmtazasmin, mɨnpazha suldaruruzne pɨpulura ɨat kit pariya ɨninturuza sun kirɨt aizpa kaiznara. ");
INSERT INTO kwi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","An pariya ɨninturuzne Judío ɨlaparuzkasa kwinta kin ɨara, maza pitmin nɨjkulana. Suasne uspane kwisha akkwan pial suldaruruza mɨlanat ");
INSERT INTO kwi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kit kaiznara: —Sunkana kaiztain: “Au amtawara pittamtuasmin, Jesúspa kammuruzne aat kit irɨtta walkuara”. ");
INSERT INTO kwi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mikwa sun piankamtane, aune uruza kiwainshinamakpas, uruza ilnamanpa. ");
INSERT INTO kwi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Suasne Suldaruruzne pial sappara, awa usparuza kaizara aizpa kin. Sunkana Judío awaruzne makima kaizamtu. ");
INSERT INTO kwi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Suasne once kammuruzne Galilea sura ɨzarakima ɨat kit Jesús usparuza ɨnintakin piannara. ");
INSERT INTO kwi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesústa izarawane, uspane ussa wakpuj wainñara. Mɨnpazha ussa nil nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Suasne Jesúsne usparuza kasha ɨt kit kaiznara: —Diosne nawa kiwainta, wan chiyurakas wan au sukinkas tɨnta ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Katmizna wan awaruza ɨat kit kamtanarain, ap kammuruza namninnanapa. Sun nɨjkulturuza kwazikasa munnarain, Taitta Diostakas Dios Painkultakas Sɨnam Izpultakas kanpaamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na uruza kamtanara aizpa usparuza kamtanarain, na kainara aizpa kianpa. Sunkas nɨjkultain. Nane wan payurakima ukasa tuanash, au su pailnakima. Pailti.");
INSERT INTO kwi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sunkana Dios watsal pit masamtu. Sun pitne Jesucristowa, Dios Painkulpa, kainarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Antikwain Isaíasne, Dios pit kainammmikane, kainat kit pɨnkɨhta para. Jesúspa kiz kit pɨnkɨhta ka para: “Mɨrain. Diosne paiña ɨninmika ɨninnazi, an ñancha Jesúspa mi watsanapa. ");
INSERT INTO kwi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mazane pul sura ɨt kit akkwan awa tuchira ka tɨnta paranazi: ‘Au wat Anpatpa mi nil sarain,’ ” kiz kit ka para. ");
INSERT INTO kwi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Suas Juanne pul sura, akkwan awa tuchira, akkwan awara munnanara. Ka akkwan piji kainanara: —U kwail kwizninnat kit munnarain, Dios u kwail kiarɨt aizpa kanintɨnpa, uruza maizanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Akkwan awane Judea suras Jerusalén pɨpuluras Juanparakima taizara, ussa mɨana. Uspane Diosta kaizara: —Watcha. Aune kwail kianashɨ. Sun kizakane, Juanne Jordán Pira usparuza munnanara. ");
INSERT INTO kwi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanne kwaksham kwara. Mamaz kalpa, camello ashkasa kwaksham sɨp kit kwara. Aya kɨra ip kit kuhta. Usne pak, ittalkanakas, mishkikas kwarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kamtanamtuasmin, Juanne kaiznara: “Mazane mamaz payura ap kwizpa anazi. Usne nakin anza tɨnta ɨninmika i. Nane paiña kiwainmika ish. Us an tɨnta namtɨt akwa, nane paiña zapato tɨt chɨhtshitchish. Nane ussa wat kiwainnapa piankamsachish. ");
INSERT INTO kwi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nane watcha umɨza kwazikasain munnanamtus. Usne umɨza ayukta Sɨnam Izpul winnanazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mamaz payura Jesúsne Nazaret pɨpuluras, Galilea suras, puz kit Jordán pira ara. Juanne Jesústa munnara Jordán Pira. ");
INSERT INTO kwi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mane Jesús piras salaktawane, chiyu azkane, Jesúsne Dios Izpulta utkurukana iztɨt. Dios Izpulne taiz kit ussa uzta. ");
INSERT INTO kwi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Diosne chiyuras ussa kwianta: “Nune ap painkul i. Nua pashimtus. Nane nua narɨt,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mane Dios Izpulne ussa pul sura, awa tuchira, ɨninta. ");
INSERT INTO kwi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta payura pul sura, awa tuchira, tuazi. Satanásne Jesústa kwail kinashimtu, us kwail kinpa. Ɨnkal kalpakasa tuazi. Ángeltuzkas purazi, ussa kiwaina. ");
INSERT INTO kwi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Suldaruruz Juanta piz kit kajchira sɨpparɨkane, Jesúsne ɨt kit Galilea sura Dios watsal pit kainanara. ");
INSERT INTO kwi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Awaruza ka kiznara: “Diosne sun payu narɨt, awaruza ɨninnanapa, usparuza watsat mɨlnanapa. U kwail kwizninnat kit Dios watsal pit nɨjkultain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesúsne Galilea Pimamin chamtuasmin, Jesúsne Simóntakas Andréstakas aimpihshtuzpain iznara. Uspane pishkaru ɨmmu kiainpailta. Pailta payu pishkaru sulpailta. ");
INSERT INTO kwi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesúsne usparuza ka kaiznara: —Nakasa at kit piankamnarain. Ñamin pishkaru sulpailta. Kawarain awara akwananaka, Diosta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mane uspane pishkaru ɨmmu chɨhkat kit ussa kanpailta. ");
INSERT INTO kwi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesúsne pitchin an ñancha ɨt kit Santiagorakas Juantakas, Zebedeo painkulta iznara. Uspane katsa kanuara pishkaru ɨmmu yalpailta. ");
INSERT INTO kwi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mane usne usparuza akwanara. Uspane uspa papihshta, Zebedeora, chɨhkailta. Usne kanuara kiwaintuzkasa nukkulara. Ussa kanpailta. ");
INSERT INTO kwi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uspane Capernaum pɨpulukin pianaat kit nappara. Mane Jesúsne kwaizkultu payura Judío kammu yalkin nap kit awaruza kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Uspane paiña kammukasa iztaspaarɨt. Uspane ka kizara: —Nune katsa mikwakana tɨnta kamtanamtu. An Moisés kaizta aizpa kamtamtuzne sunkana kamtaamtuchi, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta Judío kammu yalta maza ampune, saliz piztɨtmikane tuazi. ");
INSERT INTO kwi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Usne kwian kit Jesústa Nazaret pɨpuluras kiz mɨmara: —¿Aumɨzane chima kinash? ¿Amas, aumɨza puzninnana? Nane nua pianish. Nune Diostas sɨnammika i, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesúsne ussa ɨnin kit tɨnta kaizta: —¡Puñain! ¡Awaras puzti! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kwail salizne awara ulnin kit tɨnta kwianta. Suasne Jesúsne salizta awaras puzninta. ");
INSERT INTO kwi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wan awane ishkuara. Usparuza ka mɨmaara: —¿Anne chi i? Masas kammu i. Katsa mikwakana kamtamtu. Ɨninkane, kwail saliztuzne ussa mɨamtu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Azain sun awane, wan Galilea sura uztuzne, Jesúspa piankamaara. ");
INSERT INTO kwi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Judío kammu yaltas puzarawane, suasne Simónpa yalkinkas Andréspa yalkinkas nappara, Santiagokasa Juankasa. ");
INSERT INTO kwi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sua Simónpa suegrane kamara immukasa ishtu tuazi. Uspane Jesústa kainaara: —Paiña suegra ishtu tuazi, kainaara. ");
INSERT INTO kwi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesúsne at kit up chihtɨra piz kit ussa kuhsakninta. Suasmesa immu kara. Suasne Simónpa suegrane usparuza kumira kwinnara. ");
INSERT INTO kwi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Amtane pãn payaptɨkane, Galilea suras awane ishturuzakas kwail saliz piztɨttuzakas ussa karaara. ");
INSERT INTO kwi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Akkwan pɨpulukis awane Jesús tukin pɨjtakin wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Usne akkwan tuntu ishturuza wat paninnara. Usne akkwan kwail saliztuza puzninnara. Usne kwail saliz puznintɨttuza chi paranintachi. Saliztuzne ussa piankam kit kaizara: “Jesúsne Dios Painkul i,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tɨlawain tɨlkwilmin Jesúsne kuhsak kit awa tuchira ɨt kit Diosta paikwat. ");
INSERT INTO kwi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simónne mamaz awaruzkasa an kwizta kanpaara. ");
INSERT INTO kwi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Uspane ussa sait kit kaizara: —Chiwal awaruzne nua sayamtu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Usne usparuza kaiznara: —Ɨzhain, mamaz kasha pɨpulurain, Dios pit kwinta kinpa. Katmizna chiyuras arau, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Usne Judío kammu yalta Galilea suwara ɨt kit Dios pit kwinta kit kit saliztuza awaras puzninnara. ");
INSERT INTO kwi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maza ampune, aya pɨttɨt ishtumikane, ussa at kit tɨnta paikwat kit wain kit kaizta: —Namtashitne, namtashina. Namtazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Us akwa mintane, Jesúsne paiña chihtɨkasa ussa paat kit kaizta: —Nua namtanash. Nua wat pari, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mane aya pɨtta ishtu karɨt. Wat kultɨt. ");
INSERT INTO kwi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Suasne mamin Jesúsne ussa paiña yalta ɨnin kit ka tɨnta kainara: ");
INSERT INTO kwi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nune wat parɨt. Mɨnainkas paranamun. Nu wat parɨt akwa, pariyara ɨt kit nua Diospa yal pariyara antash. Ussa Moisés ñamin kaizta aizpa mɨltash. Usne nu akwa Diosta mɨlnazi. Sunkana wan awane nu wat parɨt piankamanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sun ampune puz kit wanta sun namtɨt aizpa kwinta kinamɨzta. Akkwan awa Jesús tukin wanmakkara akwa, Jesúsne awa iztakin pɨpulukin napsachi. Attishta, awa tuchira, aara. Uspane pul sura ussa salkularɨt. ");
INSERT INTO kwi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mamaz payura us Capernaum pɨpulura naptawane, awane us yalta tu piankamara. ");
INSERT INTO kwi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kwisha akkwan awa wanmakkarɨt akwa, mamazne nappasachi. Sun yal pɨjtakin mɨnminkas nappasachi. Sua usne usparuza Dios watsal pit kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Suasne mamaztuz aara. Sun ampara ampune chasachi intura Jesúspakin muat kit karaara. ");
INSERT INTO kwi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Akkwan awa akwa Jesús tura nappasachikane, uspane yal ɨsalta nuara. Yal kɨh uktawane, kul saara. Katsa kul saarawane, uspane ussa kamakasa inkihshaara. ");
INSERT INTO kwi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesúsne ampara nɨjkularɨt aizpa pian. Sunkana minñara: “Jesúsne ishtumikara watsashina,” minñamtu. Jesúsne chasachi intura ka kizta: —Painkul, mɨzha. Up kwail wat kulninnash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mane mamaz Moisés kaiztɨt aizpa kamtamtuzne sua uzat kit usparuzpain, minñara: ");
INSERT INTO kwi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Jesúsne pɨrail kaiztu. Usne usmin Dioskana namtu. Diosmin kwail kaninshinaka,” minñamtu. ");
INSERT INTO kwi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mane Jesúsne uspa minñarɨt aizpa ayukta piankamta. Katmizna usparuza ka kiznara: —¿Chikishma sunkana mipuspas? ");
INSERT INTO kwi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chasachi intura samchi kizna: “Up kwail wat kulnash.” Kawarain samchi kizna: “Kuhsakti. Up kama kuhsari. Chat,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Piankamtain. Diosne nawa, Ampu namtɨtmikara, ɨninta, awara kiwainanapa. Katmizna u sura at kit u kwail wat kulninnamtus, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Usne chasachi intura ka kizta: —Nane nua kaiztus. Kuhsakti. Up kama kuhsari. Ɨrash yaltakima, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Usne usmin kuhsak kit paiña kamakasa ip mut kit usparuztas puzta. Wan awaruzne iztaspaarɨt. Ka kizara: —Diosne kwisha wari. Diosne kwisha katsa i. Ñamin sunkanane iztakimakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mamasa Jesúsne yaltas puz kit katsa pirakima ɨra. Akkwan awane ussa wanmakkara. Sua usne usparuza Dios pɨnkɨh kamtanara. ");
INSERT INTO kwi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tas pimawarain pɨntawane, usne Levíra, Alfeowa painkulta, izta. Sun awane Roma gobierno pial sapmukin uz kit kal kira. Jesúsne ussa ka kaizta: —Kanpazha, ap kammumika namnapa, kizta. Usne kuhsak kit Jesústa kwizpa ɨra. ");
INSERT INTO kwi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesúsne Levíwa yalta ɨt kit uskasa kuantuazi. Akkwan Roma gobierno pial sapmuruzkas, kwail kimtuzkas misharɨra uzat kit kuara, Jesúskasa paiña kammuruzkasa. An akkwan sun awakanane ussa kanpaat kit kamashimtu. ");
INSERT INTO kwi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesúskas kwail kimtuzkas gobierno pial sapmuruzkas kuamtazi. Moisés kaizta aizpa kamtamtuzkas Fariseo awaruzkas tuat kit usparuza izara. Usparuza izarawane, ka Jesúspa kammuruza mɨmanara: —¿Chikishma Jesúsne Roma gobierno pial sapmuruzkasa kwail kimtuzkasa kuamtui? mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sun mɨrawane, Jesúsne usparuza kaiznara: —Ishtukine, tuttul pashikain. Ishtune, tuttul pashimtu. Nakas tuttulkana ish. Nane at kit awaruza sainarau, kwail awaruza wat paninnana. Wat awa makpas minturuza sainamtuchish, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan munnammikawa kammuruzkas Fariseo awaruzkas akkwan payurakima Diosta paikumtune, kuamtuchi. Impa. Uspane Jesústa aat kit kaizara: —Up kammuruz Diosta paikukane, kuamtu. Impachi. ¿Kwailchiki? Juanpa kammuruzkas Fariseo awaruzkas Diosta paikukane, kuamtuchi. Impa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesúsne usparuza kaiznara: —Ampu ashampa kanpain mɨjne, kasara kishitne, izmuruzne wanmakkamtu, kasara kimmikakasa watsal kulanapa. Kumira kwinkane, kuamtu. Sun payura izmuruzne kumira kuanazi. Impachi. ");
INSERT INTO kwi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ampu kasara kitpane, mamaz payura usne izmuruztas ukkanazi. Sun payura paiña izmuruzne kuamanazi. (Kawarain mamaz payura awane nawa ukkanazi. Nawa ukkarawane, ap izmuruzne izat kit piankamanazi. Sun payura kuamanazi, tayalamtu akwa.) Jesúsne an masas kamtam awara kamtanara, antikwain kamtam chɨhkaanapa. ");
INSERT INTO kwi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Usne ankas kamtanara: —Kwaksham pakkultane, mɨnchi masas liensokasa yaltuchi. Masas liensokasa yaltane, masasne sɨpparɨm. Suasne an pshat kit pakkultɨm. ");
INSERT INTO kwi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kawarain chappi sultane, mɨnminkas chappi ɨlapa kalpa ayara wintu. Ɨlapa kalpa ayara wintane, chappi tain sultɨm. Chappi tain sultawane, ɨlapa kalpa aya psharɨnazi. Chappikas puztɨnazi. Paasas karɨnazi. Chappi sulkane, masas kalpa ayara wintawa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kwaiztɨt payura Jesúsne chara sauwara ɨzi. Pɨnmɨztune, paiña kammuruzne chara pippa pakkamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo awaruzne ussa kaizara: —Izti. Up kammuruz chara pippa pakkamtu. Antikwa kamtamne ka kizta: “Kwaizkultu payura kal kiman”, kiztu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesúsne usparuza kaiznara: —Une Dios pɨnkɨh izara. Ñamin Davidne paiña izmuruzkasa yak kiarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Usne Dios yalta napta. Abiatar katsa pariya uzkane, Abiatarne an pan Diosta tara aizpa ussa kwinta. Antikwa kamtam ka kizta: “Sun pan pariyaruzpain kuamtu. Mamazne kwasachi,” kizta. Davidne kwat kit izmuruza kwinnara. Usne kwail kitchi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesúsne ankas usparuza kaiznara: —Diosne an ñancha awa sara. Awa sarawane, Diosne kwaizkultu payu sara, awa kwaizkulanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Katmizna usne ka kiznara: —Nane, Ampu namtɨtmikane, awara wanmak kit kiwainamtus. Nane kwaizkultu payura awaruza kurunnashina, chiwazha kinpa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mamasa Jesúsne Judío kammu yalta napta. Maza ampune chihtɨ chɨhpailtɨt tuazi. ");
INSERT INTO kwi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mɨnpazha Fariseo awane Jesústa izat kit ka minñara: “Jesúsne kwaizkultu payura ussa kakulninshinasa,” minñara. Sunkana minñara, ussa kwail kizanapa. ");
INSERT INTO kwi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Suasne Jesúsne ampu chihtɨ chɨhpailtɨtmikasha kaizta: —Apain paizkakin kunanka, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Usne usparuza mɨmanara: —Kwaizkultu payura ¿Chima kinpai? ¿Wat kin? ¿Kwail kin? ¿Kakulninna? ¿Piantana? ¿Chima kinpai? mɨmanara. Sɨnkaashitchi akwa, uspane puñain paarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Usne usparuza iznat kit aliz paranara. Uspa akwa Jesúsne tayalta, uspa watcha mɨashitchi akwa. Usne ampura kaizta: —Up chihtɨ nil sari, kizta. Sun ampune paiña chihtɨ nil sarɨt. Paiña chihtɨ mamaz chihtɨkana namtɨt. ");
INSERT INTO kwi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tas Fariseo awaruzne puzarɨt. Uspane Herodes izmuruzkasa kwinta kiat kit usparuzpain kaizara: “¿Mizama ussa piantanapai?” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesúsne paiña kammuruzkasa ɨarɨt katsa pirakima. Akkwan Galilea suras awakas kwizpa kanpaara. Judea suras awakas aara. ");
INSERT INTO kwi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Akkwan awane Jesús sarɨt aizpa paraara. Jesúspa mɨarawane, akkwan aara. Judea suras Jerusalén pɨpuluras aara. Idumea pɨpuluras aara. Akkwan awane Jordán Pi kwakaras aara. Akkwan awane Tiro pɨpuluraskas Sidón pɨpuluraskas aara. ");
INSERT INTO kwi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Usne kammuruza ka kaizara: —Akkwan awane wanmakkamtui. Akkwan awa akwa ainki kanua watsarain, awa nawa nuppainmanpa. Nawa nuppainñarane, kanuara uznash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ñamin akkwan ishturuza kakulnintawane, uspane nuppainñara, ussa paanapa. ");
INSERT INTO kwi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Awa kwail saliz piztɨttuzne sua aazi. Ussa izkane, kwail salizne awara wainnin kit kwianninñara: —Nune Dios Painkul i, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesúsne salizta kainanara: —Awaruza “nane Dios Painkul ish” kaizman, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesúsne kwash ɨzara nura. Mɨnpazha kanpashimturuza akwanara. Uspakas us uzkin nuara. ");
INSERT INTO kwi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Sun doce ampuruza nanarawane, usne paiña ɨnintuz munninnara. Jesúsne nanara, uskasa tuanpa, Dios pit kainanapa, Dios pitkasa salizta puzninnanapa, ishtura kakulninnanapa. ");
INSERT INTO kwi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesúsne an doce ampura ka nanara. Mazane Simón mun. Jesúsne Simónpa mun maizta. Mane Pedro mun. ");
INSERT INTO kwi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Mamazne Santiagokas Juankas aimpihshtuzpain. Sun paasne Zebedeo painkul azi. Jesúsne uspa mun maizta. Mane Boanerges muntɨt. (“Azain awa muntɨt.”) ");
INSERT INTO kwi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anpane Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago, Alfeo painkul, Tadeo, Simón, Cananeo suras, ");
INSERT INTO kwi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote munarɨt. Judas Iscariote kutña año pailtɨkane, ussa kwail awara chɨhkanara, ussa piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Suasne Jesúsne maza yalta kail kit napta. Mamasa akkwan awane Jesústa paiña kammuruzkasa wanmakkara. Akkwan awa akwa, uspane kuasachi. ");
INSERT INTO kwi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Paiña izmuruz sun kit aizpa mɨrawane, ɨara, tas ussa mɨlnapa. Uspane usparuzpain kizara: “Usne nukkukana paramtu,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisés kaizta aizpa kamtamtuzne Jerusalén pɨpuluras kihshat kit Jesúspa ka kizara: “Beelzebúwa salizne ussa piztɨt. Usne sun katsa saliz akwa mamaz salizta puznintu,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesúsne usparuza akwat kit masas pit kamtamkasa kamtanara: “Satanásne paiña saliz puzninmanazi. ");
INSERT INTO kwi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mamaz suras awane usparuzpain waya kitne, sun awane pareju uzasachi. ");
INSERT INTO kwi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kwalne usparuzpain waya kitne, aliz paratne, sun kwalne pareju uzasachi. ");
INSERT INTO kwi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanáskas paiña izmuruzkas paiña salizkas usparuzpain waya kit kit paimpa ɨakane, paiña katsa mikwa nukkulmanazi. Pailtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tɨnta yalpamika paiña yalta uztane, mɨnminkas walkwan napsachi. An tɨnta awa at kit tɨnta yalpamikasha tɨt kuhtawane, paiña yalta nap kit us mɨj aizpa walkwashina. (Kawarain nakas Satanásta kana kit kit paiña saliz awaras puznintus.) ");
INSERT INTO kwi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","An usparuza kaiznara: Watcha. Nane wan kwail kit aizpa, Diosta kwail kwinta kit aizpa, watkulnashinash. ");
INSERT INTO kwi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mɨnpazha Dios Izpulta kwail kwinta kitne, nane sun kwail ussa chi wat kulmanash. Sun kwailne wat kulsachiwal. Diosne usparuza pailta payu ĩnta naizninnanazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesúsne sunkana kainanara, sun awa kwail saliz Jesústa piztɨt kizarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Suas Jesúspa akkuhshkas aimpihshtuzkas aat kit pianamal kunara. Uspa pit ɨnin kit Jesústa akwat. ");
INSERT INTO kwi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Akkwan awane ussa sulmin uzat kit kaizara: —Izti. Up akkwakas up añaruzkas pianamal uzamtu. Uspane nua sait kit akwantu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Usne usparuza sɨnkanat kit kaiznara: —¿Mɨnma ap akkwa i? ¿Mɨnma ap aña i? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Suasne Jesúsne sulmin paiña uztukin iznat kit kaiznara: —Apain une ap akkwakana, ap añakana mai. ");
INSERT INTO kwi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mɨnpazha Dios ussa ɨnintu aizpa kimtumikane ap añakana i, ap kuakana i, ap akkwakana i, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mamasa Jesúsne pimakin kamtanamɨzta. Kwisha akkwan awane wanmakkarɨt. Suasmesa usne kanuara wat kit uzta. Wan awane pimakin kunara. ");
INSERT INTO kwi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Usne usparuza akkwan masas kamtamkasa kamtanara. Kamtamtune, usparuza ka kiznara: ");
INSERT INTO kwi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mɨrain. Maza awane ɨra, chara pippa malna. ");
INSERT INTO kwi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Us maltakane, pitchinmin miwara taizara. Chitchuruzne aat kit kuara. ");
INSERT INTO kwi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pitchin pippane uk pilpara, akkwan pil tuchira, taizara. Ainkih pilchira taiztawane, pippane azain chik kit kwizara. ");
INSERT INTO kwi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pãn malkane, tɨ kwiz kit kiyarɨt, akkwan mujtɨt wajchi akwa. ");
INSERT INTO kwi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","An pitchin pippane patmu mujtɨtpara taizara. Pippakas patmukas chikkara. Watchi kunkain. Chi wakain. ");
INSERT INTO kwi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","An akkwan pippane wat pilta taizat kit chikkat kit kunara. Chara watsal wakane, pakkarɨt. Maza tɨrain treinta pippa puzara. Mamaz tɨrain sesenta pippa puzara. Mamaz tɨrain cien pippa puzara,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Suasne Jesúsne an kaiznara: “Piankamshitne, mɨshitne, nawa mɨzhain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Akkwan awa kaiyarawane, doce kammuruzkas paiña izmuruzkas ussa kaizara: “Aumɨza sun masas kamtam kwinta kainchanaka, mɨanapa,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesúsne usparuza ka kaiznara: “Nane, Dios ɨnintamikane, umɨza kamtanamtus, mɨanapa, Dios uruza ɨninnashimtu piankamanapa. Nane Diosta mɨashimtuchiruza masas kamtam kwintakasa kamtanamtus. ");
INSERT INTO kwi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yawa wat iztakas, piankamamanazi. Yawa wat mɨrakas, mɨamanazi. Wat mɨamtuchi akwa, uspane Diosta kaiyasachi. Uspa kwail wat kulnasachi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesúsne usparuza kaiznara: “An masas kamtam kwinta u mɨamtuchi akwa, nane uruza mamasa kainananash. Watsal mɨrain, an piankamanapa, wan masas kamtam kwinta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chara pippa malmumikakas Dios pit kwinta kimmikakas kawarain i. Sun pippane Dios pitkana i. ");
INSERT INTO kwi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pitchin pippane miwara taizara. Pippa miwara taiztawane, Satanásne kwizpa at kit pippa saktu, chiktachasmin. Kawarain awa Dios pit mɨrawane, Satanásne at kit ayuktas Dios pit ukkamtu. ");
INSERT INTO kwi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Mamaz pippane uk pilpara taizara. Uk pilpara taizarawane, katsa mujtɨt wajchi akwa, azain kiyarɨm. Kawarain awa Dios pit saptawane, mɨrawane, usne Dios pit ayukta watsakain. Awa ussa kwail kitpane, Dios pit akwa ussa iltawane, usne Dios pit kwait kit Dios pit mɨshimtuchi. ");
INSERT INTO kwi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mamaz pippane patmu mujtɨtpara taizara. Kawarain awane Dios pit mɨmtu. ");
INSERT INTO kwi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Dios pit mɨrawane, kwizta sun awane wat mɨshitchi. Chiwal pashimtu. Pialkas saimtu. Kwail kishimtu. Suasne Dios pit kwait kit maintɨm. Uspane pippakana kunsachi, wakain. ");
INSERT INTO kwi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mamaz pippane wat pilta taizara. Sun pippane chik kit kun kit waara. Maza pipparain treintakima sesentakima cienkima puzara. Kawarain Dios pit mɨmturuzne Diosta piankamat kit wat kianazi,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesúsne usparuza mɨmanara: “¿Alampara tɨm paltammuskiwas? ¿Alampara kamakasa paltammuskiwas? Tas alampara tapɨlara unam, aiznapa, awa kai izanapa. ");
INSERT INTO kwi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kawarain ap kamtam pit puintɨtkas, mamaz payura awa mɨanazi. Ap kamtam pit mɨashitchikas, mamaz payura awa piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Piankamshitne, mɨshitne, mɨrain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","An kaiznara: “Watsal mɨrain. Pitchimin mɨshitne, pitchimin piankamnazi. Watsal mɨshitne, an akkwan piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Piankamshitne, Diosne usparuza kiwainamtu, an akkwan piankamanapa. Dios pit piankamshitkine, wan mɨj aizpa kaninnazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesúsne usparuza ka kamtanara: “Diospa gobiernone maza pippakanain i. Maza ampune pippa pilta maltu. ");
INSERT INTO kwi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pippa malmumika amtawara pittɨttuasmin, payuwara izkultuasmin, sun pippane chik kit kunmu. Pippa malmumikane miza chikmu pianchi. Miza kunmu pianchi. ");
INSERT INTO kwi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pippane pilta kain chikmu. Pippa chiktawane, tɨ kunmu. Kuntawane, pippa waam. ");
INSERT INTO kwi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pippa inkane, usne awara mashtikasa ɨnintu, pippa paknapa,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesúsne an kaiznara: “Diosne awaruza sainamtu, usparuza ɨninnanapa. An kamtam kwinta mɨrain. Diospa gobierno maza kwalkana aiztɨm. Diospa kwal aiztɨm. Masas kamtam kwintakasa kamtananash, awa piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Diospa gobiernone maza ainki pippakana i. Mamaz an ainki pippane wachi. ");
INSERT INTO kwi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sun pippa wakane, chikmu. Chiktawane, kwisha azain kawirɨm. Katsa tailpura kawirɨm, tɨ ayukmal chitchu yal sanapa. Sunkana Diospa kwal kawirɨm,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kawarain Jesúsne sun masas kamtam kwintakasa kamtanara, awa piankamanakima. ");
INSERT INTO kwi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesúsne masas kamtam kwintakasa chi paranarachi. Jesúsne paiña kammuruza sun masas kamtam kwintara kamtanara, piankamanakima. ");
INSERT INTO kwi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sun payura tɨl pakane, Jesúsne kammuruza kaiznara: —Pi kwakara ɨzhain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Akkwan awaras puzarawane, paiña kammuruzne Jesúskasa kanuara waat kit kwakara ɨara. Akkwan kanuakas usparuzkasa ɨara. ");
INSERT INTO kwi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Katsa tɨnta inkwa pamɨzta. Inkwane pira nuppain kit kwazi kanuara palakpɨnta. Pi punmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsne kanua pɨlmal tut kit kwakmura pitta. Uspane ussa izkulnin kit mɨmaara: —Anpat. Aune pi kwaanapain makpas, kizara. ¿Nune nɨjchimakish? ");
INSERT INTO kwi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Usne izkul kit kuhsak kit inkwara kaizta: —¡Inkwa pamun! kizta. Pira kaizta: —¡Kialmun! ¡Kalpain! kizta. Inkwane pailta. Pine kalpain parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Usne kammuruza mɨmanara: —¿Chitma ishkuanas? ¿Diosta nɨjkultuchimakkiwas? Diosne umɨza kwira kinanazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Uspane kwisha ishkuarɨt. Usparuzpain kaizara: —¿Sunne mɨnma kai? Parakane, inkwane pailta. Parakane, pine kialta, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Uspane pi kwakkara ɨat kit Gerasa surakima pianaara. ");
INSERT INTO kwi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kanuaras puzarawane, maza ampune, pantiónpara chammikane, Jesús tukin ara. Salizne sun ampura pizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sun ampune pantiónta uzta. Mɨnminkas ussa tɨt kuhsachi, cadenakasa kuhsachi. ");
INSERT INTO kwi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ñamin akkwan piji awane ussa pimpulkinkas cadenakasa kuhshira. Chihtɨkinkas kuhshira. Usmin chihtɨkin iru kuhta pakmalta. Pimpulkinkas iru kuhta pakmalta. Mɨnminkas ussa tak kamtasachi. ");
INSERT INTO kwi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pailta payukas amtakas pantiónparakas ɨnkalparakas kwianta. Usne usmin ukkasa kiltɨt. ");
INSERT INTO kwi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesústa attishtas iztawane, usne ãĩn ɨt kit ussa wakpuj wainta. ");
INSERT INTO kwi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tɨnta kwian kit Jesústa ka mɨmara: —¿Nawane chima kinash? Nune Jesús i. Nune an katsa Diospa Painkul i. Chiyura uztu. Nawa naizninmun, kiz kit paikwat. ");
INSERT INTO kwi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesúsne kwail salizta akkwan piji kaiznara: —Awaras puzninti, kizta. Kwail salizne ɨshitchi. ");
INSERT INTO kwi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Suasne Jesúsne ka mɨmara: —¿Nune chi munish? kizta. Saliztuzne ka kizara: —Aune “akkwan” munmakpas. Aune akkwan makpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sun saliztuzne Jesústa an tɨnta paikuaara: —Aumɨza mamaz sura ɨninmun, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwisha akkwan kuzune kashain ɨnkalta kuaamtuazi. ");
INSERT INTO kwi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sun saliztuzne ussa an tɨnta paikuaara: —Aumɨza kuzuruza pizna ɨninchain, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Suasne usne usparuza kuzuruza ɨninnara. Wan kwail saliztuzne ɨat kit kuzuruza pizara. Suas sun paas mil kuzune ãĩn pilchiraras taizarɨt. Pira taizat kit pi kwaarɨt. Iara. ");
INSERT INTO kwi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kuzu kwira kimtuzne ishkuat kit ãĩn ɨat kit pɨpuluras awarakas sun suras awarakas sun pit kainanara. Tas awane aara, Jesús kirɨt aizpa izana. ");
INSERT INTO kwi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uspane Jesúspakin aara. Sua uspane akkwan saliz piztɨt mɨjatmikasha izara. Sun ampune uz kit wan kwat kit wat mintu. Pɨpuluras awane ishkuara. ");
INSERT INTO kwi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Saliz piztɨt mɨjatmikasha izararuzne wan awaruza ka kainanara: —Saliz piztɨt mɨjatmikane wat mintu. Saliztuz kuzuruza piznarawane, kuzune pi kwaara, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Suasne awane Jesústa an tɨnta paikuaamtu: —¡Au suras ɨmɨzti! kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús kanuara wakane, saliz piztɨt mɨjatmikane Jesústa paikwat: —Nukasa ɨshimtus, nukasa tuan, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesúsne ussa ɨninmai, uskasa kanpanapa. Ussa kaizta: —Up kwalta kailtɨnka. Usparuza “Dios saliztuza puzninnara” kainanana ɨnka. Diosne nua kiwainta kiznarain, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sun ampune tas ɨt kit Decápolis suras awaruza Jesús us akwa sarɨt aizpa kwinta kinara. Wan awane sun akwa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús katsa pi kwakara kanuawara kwaktawane, akkwan awane ussa wanmakkara. Usne katsa pimamin nukkulta. ");
INSERT INTO kwi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sua maza awane, Jairo munmikane, at kit Jesúspa mittɨkin wakpuj wainta. Usne Judío kammu yal manta kimika azi. ");
INSERT INTO kwi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Usne ussa tɨnta paikwat kit kaizta: —Ap pashu ainki inapain i. At kit up chihtɨkasa ussa paananka, wat panapa, uznapa, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesúsne uskasa ɨra. An akkwan awane kwizpa ɨat kit nuppain kit Jesústa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maza ashampane wan awakasa tuazi. Usne doce añokima paiña aimpi puz kit pul parachi. ");
INSERT INTO kwi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Usne akkwan tuttulkasa kwisha naizta. Wan pial mɨj aizpa tara. Wat parachi. Anpa piztɨt. ");
INSERT INTO kwi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Awane ussa Jesúspa kwinta kiara. Ishtura wat panintu, kizta. An ashampakas Jesúspa mɨra. Usne akkwan awakasa kwizpa aara. Usne paiña kwaksham paara. ");
INSERT INTO kwi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sunkana usmin minta: “Paiña kwakshammin paarane, usne nawa wat paninnazi,” minta. ");
INSERT INTO kwi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ussa paarawane, sun urain paiña aimpi pul parɨt. Usne ayukta paiña ishtu wat parɨt nɨjkulta. ");
INSERT INTO kwi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesúsne usmin mazainta wat panintɨt nɨjkulta. Akkwan awa ustukin wanmakkarakas, usne ãĩn puij chat kit mɨmanara: —¿Mɨnma ap kwaksham paara? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Paiña kammuruzne ussa kaizara: —Nune akkwan awara iznamtu. Uspane wanmakkat kit nua nuppainñara. “¿Mɨnma ap kwaksham paara? ¿Mɨmamtukish?” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Usne wan awara iznamɨzta, paiña kwaksham paarɨtmikasha saina. ");
INSERT INTO kwi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sun ashampa ayukta wat parɨt nɨjkulkane, at kit ishkwat kit ul kit ussa wakpuj wainta. Usne Jesústa kaizta: —Nane up kwaksham paarau. Wat paru, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúsne ussa kaizta: —Nu nawa nɨjkultɨt akwa, nane nua watcha wat paninnash. Watmin ɨnka. Up ishtu wat pari, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kwinta kimtuasmin, mazantuzne manta kimmikawa yaltas aat kit Judío kammu yal manta kimmikasha kaizara: —Up pashu me irɨt. Kamtammikasha, Jesústa, anne aizapmun, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesúsne uspa kaizara aizpa mɨrachi. Usne Judío kammu yal manta kimmikasha kaizta: —Ishkumun. Watsal nɨjkulti. Nane up pashura watsashinash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pedrokas Santiagokas Juankas, Santiagowa aimpihsh, Jesúskasa ɨara. Jesúsne mɨnainkas napninnarachi. ");
INSERT INTO kwi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Manta kimmikawa yalta piannaakane, Jesúsne akkwan awara iznara. Uspane azat kit tɨnta kwianaara. ");
INSERT INTO kwi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Naptawane, usne usparuza kaiznara: —¡Kwianman! ¡Azaman! kiznara. Sun awane manta kimmikawa pashu irɨt nɨjkulara. Usne kaiznara: —Sun pashpane pittui. Uznazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sun kwinta kitpane, uspane Jesústa ishanaara. Jesúsne usparuza piannamal ɨninnara. Uskas papihshkas akkuhshkas paiña izmuruzkas pashpa tukin nappara. ");
INSERT INTO kwi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Paiña chihtɨ piz kit ussa paiña pitkasa kaizta: —Talitta kumi, kizta. (Sunkana awa pit kizta: “Pashpa ainki, kuhsak kit kunti,” kizta.) ");
INSERT INTO kwi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sun urain sun pashpane kuhsak kit chara. Usne doce año pailtɨt. Main uspane kwisha iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Usne pashpawa papihshtakas akkuhshtakas manta kit kit kaiznara: “Mɨnainkas u pashu wat parɨt, kaizman. Jesús ussa kuhsakta, uznapa, kaizman,” kiznara. Pashura chiwazha kwintain, kwanpa, ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesúsne suas ɨt kit paiña sura piannara. Paiña kammuruzne kwizpa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kwaizkultu payura usne Judío kammu yalta ɨt kit kamtanamɨzta. Kwisha akkwan awane ussa mɨara. Kwisha akkwan pian akwa, iztaspaarɨt akwa, usparuzpain mɨmaara: —¿Mɨnma an kamtam ussa kamtara? Iztain. Usne kwisha akkwan awaruza wat paninnamtu. ");
INSERT INTO kwi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Anne apas yal sammikaki? Usne Maríawa painkul i. Santiagokas, Josékas, Judaskas, Simónkas paiña aimpihshtuzpain apain uzamtu. Paiña kwampihshtuzkas au pɨpulura uzamtu, kizara. Suasne uspane ussa aliz kulat kit izkiarachi. ");
INSERT INTO kwi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesúsne usparuza ka kizanara: —Mamaz suras awane “Dios pit kainammmikane wari” minñamtu. Dios pit kainammmika paiña sura ɨtne, paiña su awakas, paiña kwalkas, paiña yalta uzturuzkas ussa wat minñamtuchi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Suane Jesúsne akkwan ishturuza wat paninnasachi. Pitchimin ishturuza chihtɨkasa paat kit wat paninnara. ");
INSERT INTO kwi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Usmin uspawa iztasparɨt, paiña pɨpuluras awa Jesústa nɨjularachi akwa. Suasne usne akkwan ainki pɨpuluwara chat kit awara kamtanara. ");
INSERT INTO kwi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Usne sun doce kammuruza akwanat kit kaiznara: —Umɨza paas paas ɨninnanash. Kwail saliztuza awaras puzninnarain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Usne usparuza ankas kaiznara: —Attishta ɨamtune, kasmin ɨwizanaka. Pankas, tuhkas, pialkas kwaman. Tɨwilkasa ɨrain. ");
INSERT INTO kwi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Zapato nuk kit ɨrain. Paas kamisha kwaman. ");
INSERT INTO kwi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yalta naptane, suain pitwizanaka, ɨmtu payukima. ");
INSERT INTO kwi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Awane umɨza uspa pɨpulura napninamakane, up pit mɨshiamakane, tas puztain. Uspa iztakin mittɨ pil puhstɨt ulpiantawa, uspa kwail kiarɨt aizpa piankamanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Suasne kammuruzne paas paas ɨat kit Dios pit kainanaara, awa kwail kiarɨt aizpa maizanapa. ");
INSERT INTO kwi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Uspane akkwan kwail saliztuza puzninnara. Pihshpikasa ishturuza nɨnat kit usparuza wat paninnara. ");
INSERT INTO kwi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodesne manta kimmikane, awa Jesúspa kwinta kiarɨt aizpa mɨra. Wantuzne Jesús ara kwisha wat pianmazi. Usne Jesúspa ñanta mɨt kit kaizta: —Juan munnammikane irɨtkas, me kuhsta. Katmizna usne akkwantuza wat paninnamtu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mamaztuzne kaizara: —Usne Elías i. Mamaztuzne kaizara: —Dios pit kainammmika i. Usne ñamin Dios pit kainammmikakana i, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","An mɨrawane, Herodesne kaizta: —Juanne, na kɨzpu tɨttamikane, irɨt. Tas kuhsta akwa, ma uztu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ñamin Felipene, Herodespa aimpihshne, Herodíaskasa kasara kirɨt. Kwizta Herodesne paiña aimpihshpa ashampara kasara kirɨt. Herodías akwa Herodesne awara ɨninta, Juanta piznapa. Usne Juanta tɨtkasa kuh kit kajchira sɨpta. Herodíasne Juanta kwisha aliz kultɨt. Usne Juanta piantashina. Juanne Herodesta akkwan piji tɨnta kainara: “Paiña aimpihshpa ashampara kasara kitne, watchi,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodíasne Juanta piantamanamtɨt. Herodesne uspa wat kwinta kit kit Juanta kwail kishitchi. Herodesne Juanta watsat kit kaizta: “Juanne wat awa i. Diosta pian i,” kizta. Katmizna paiña ashampane Juanta piantashininsachi. Herodesne Juanta impara impara mɨra. Juanne ussa kaizta: “Wat uztuchi,” kizta. Herodesne ussa mɨshira. Juanta mɨrawane, Herodesne ayukta kwail minta. ");
INSERT INTO kwi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wat payura, us kawira payura, Herodesne akkwan gobierno awaruzakas, suldaru awaruzakas, Galilea suras anpattuzakas kumira kwinnara. Sun payura Herodíasne Juanta piantaninta. ");
INSERT INTO kwi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sun payura Herodíaspa pashune kumira unamkin nap kit ku kimɨzta. Herodeskas paiña izmuruzkas kwisha wat kulazi. Katmizna sun manta kimmikane Herodíaspa pashura kaizta: —Chiwazha paikukane, sunpawa tanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mamasa an tɨnta ussa ka kin namta: —Chiwazha paikukane, sunpawa tanash. Na kakwa mɨj aizpa tanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Usne tas puz kit akkuhshta mɨmara: —¿Chima paikwanash? kizta. Herodíasne pashura kaizta: —Juan munnammikawa kɨzpu tɨt kit karanka, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sun urain musittune manta kimmikakin ãĩn nap kit paikwat kit kaizta: —Mamin Juan munnammikawa kɨzpu pashu. Pɨlattura unari, izna, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sun manta kimmikane kwisha tayalta. Usne ussain minta: “Ap izmuruzne na kaizta aizpa mɨara. Nane uspa iztakin na kaizta aizpa kimanash kaizsachish,” minta. ");
INSERT INTO kwi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Suasne manta kimmikane suldaru awara ɨninta, Juanpa kɨzpu karanpa. ");
INSERT INTO kwi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Usne kajchira ɨt kit tɨmpukin kɨzpu tɨtta. Usne pɨlattura kɨzpukasa karat kit musittura mɨlat. Musittune akkuhshta mɨlara. ");
INSERT INTO kwi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sun mɨarawane, Juanpa kammuruzne ɨat kit ussa muat kit pilta kamaara. ");
INSERT INTO kwi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mamaz sura kaiyarawane, sun doce ɨnintuzne Jesús tura wanmakkat kit ussa chiwazha kiarɨt aizpakas chiwazha kamtanarɨt aizpakas kaizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwisha akkwan awa Jesús tukin aarɨt akwa, uspane kuasachi. Katmizna Jesúsne usparuza kaiznara: —Mamaz sura, awa tuchira, ɨzhain, pitchin kwaizkulana, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Suasne Jesúskas paiña kammuruzkas kanuawara ɨara, pul surakima. ");
INSERT INTO kwi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Akkwan awane uspa ɨamtura izat kit ussa piankaara. Sua pɨpuluras awane mittɨwara ãĩn chaara, uspakin an ñancha piannaana. Uskasa wanmakkaara. ");
INSERT INTO kwi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kanuaras kihshtawane, Jesúsne akkwan awaruza iznat kit usparuza kiwainshinara, uspa pɨrikukana izarɨt akwa, uspa kwira kimchiruzkana izarɨt akwa. Usne usparuza akkwan kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nashtɨmtuasmin, paiña kammuruzne ussa aat kit kaizara: —Sun sune pul i. Awa purachi. Nashtui. ");
INSERT INTO kwi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Usparuza ɨninnari, ɨanapa, kasha sura kasha pɨpulura chiwazha paitkuanapa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Usne usparuza sɨnkanara: —Umin kumira kwinnari, kuiznapa, kiznara. Uspane ussa kaizara: —Sunpawa pan paitkwashitne, aune, paas cien payurakima kal kitpamakpas. Aune sunpawa pial mɨjchimakpas, awaruza kumira kwinnana, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Usne usparuza mɨmanara: —¿Yawa panma mɨjmakpas? ¡Izna ɨrain! kiznara. Sairawane, uspane kaizara: —Aune cinco pankas paas pishkarukas mɨjmakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Suasne Jesúsne kaiznara: —Pɨtkin uzninwizanaka, akkwantuzne apain akkwantuzne anta, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Uspane sunpawa uzninnara, cienkimakas cincuentakimakas. ");
INSERT INTO kwi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Usne cinco pankas paas pishkarukas sapta. Chiyura izak kit Diosta aishtaish kizta. Usne pan kɨz kit kammuruza kwinnara, wanta nailnanapa. Usne paas pishkarukas wanta nailnara. ");
INSERT INTO kwi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wan awane kuat kit tukkarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Akkwan pitti pitti tizara. Kammuruzne doce tɨmta pankasa pishkarukasa sap winñara. ");
INSERT INTO kwi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kwisha akkwan awane kuara. Usparuzpain cinco mil ampune kuara. ");
INSERT INTO kwi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Suasne usne paiña kammuruza kanuara ɨninnara, uspa an ñancha kwakkanapa, Betsaida pɨpulurakima. Kwiztane usne wanta ɨninnara uspa yaltakima. ");
INSERT INTO kwi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wantuza ɨninnarawane, usne ɨzara Diosta paikwan ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tɨlkwil parɨkane, kammuruzne kanuawara ɨat kit katsa pi paizkara piannaara. Jesúsne mazainpa piltain nukkultɨt. ");
INSERT INTO kwi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Usne usparuza iznara, tɨnta tailtuasmin. Inkwane tɨnta pamtu akwa, uspane wat kwakkasachi. Tɨlawain, tɨlkwilmin usne usparuza mittɨwarain pi ɨsal ɨsal atchara. Usne usparuza pɨnnash minta. ");
INSERT INTO kwi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Uspane ussa pi ɨsal chara izarawane, usparuzpain minñat kit kwianñara: “Ɨra awa izpul iztumakpas,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wanne ussa izat kit ishkuarɨt. Mamin Jesúsne usparuza kwinta kit kit kaiznara: —Uruza kwira kinanash. Tɨnta kultain. Nane Jesús ish. Ishkuman, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesús kanuara warawane, usne inkwa pailninta. Uspane us akwa ishkuat kit iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús pan wanta nailnarawane, uspane Jesús wan kit aizpa mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kwakara kwakkaarawane, uspane Genesaret sura piannaat kit kanuara pimamin kantaara. ");
INSERT INTO kwi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanuaras kihsharawane, akkwan Genesaret pɨpuluras awane Jesústa piannaara. ");
INSERT INTO kwi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sun awane wan surakima ɨat kit ishturuza kwaara, Jesús tukin piannankima. ");
INSERT INTO kwi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús ainki pɨpulurakas katsa pɨpulurakas ɨnkalparakas ɨmtuasmin, awane ishturuza kwaat kit mikin taara. Uspane Jesústa paikuara: “Aune up kwaksham puntakin paashimtumakpas, wat panapa,” kizara. Ussa paakane, ishtune wat parɨt. Jesúsne ishturuza wat paninnarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo awakas mamaz Moisés kaizta aizpa kamtamtuzkas Jerusalén pɨpuluras aat kit Jesústa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Uspane Jesús kammuruza iznara. Sun kamtamtuz kuamtuasmin, uspawa chihtɨ kittarachi. Moisés kiarachi akwa, uspane Jesúspa kammuruza aliz paraara. ");
INSERT INTO kwi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Uspa chihtɨra akkwan piji kittakine, wan Judío awakas Fariseo kamtamtuzkas kuakain. Uspane antikwa pit, ɨlapa ampu kaizara aizpa, mɨara. Uspane sunkana nil chi minñamtu: “An kumira kwatne, chihtɨ kittakine, uspane kwail kiamtu.” ");
INSERT INTO kwi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pɨpuluras kaiyarawane, usparuza sɨnam kittakine, kuakain. An akkwan antikwa kamtam watsaamtu. Antikwa awa sunkana kizara: “Wan kittawa. Wazkas, pailkas, paiyittarakas misharɨkas kittawa,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseo awakas mamaz Moisés kaizta aizpa kamtamtuzkas Jesústa kainaara: —Up kammuruz kuakane, chihtɨ kittamtuchi. Une ɨlaparuz kamtamtu aizpa watsaamtuchi. ¿Chikishma antikwa kamtamtu aizpa mɨamtuchi? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesúsne usparuza sɨnkanara: —U akwa wat minñamtu akwa, une kwail kiamtu. Isaíasne, Dios pit kainammmikane, uwa paranara, u paas pit kwinta kiamtu akwa. Ñamin sunkana umɨza kaiznara: “Sun awane uspa pitkasain ‘Diosta wat i’ kaizamtukas, uspa kaijchura Diosta pashiamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Diosta paikuamtukas, Diosta wakpuj wainñamtukas, uspane Diosta pashiamtuchi. Uspain kamtam kamtaamtu.” ");
INSERT INTO kwi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Une Dios pit kamtaamtuchi. Une Dios manta kit aizpa chɨhkaarɨt, antikwa kamtam mɨashimtu akwa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesúsne usparuza an kaiznara: —Une Dios kamtanarɨt aizpa chɨhkaarɨt, antikwa kamtamtɨt aizpa kianpa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ñamin Moisésne ka kaizta: “Papihshtakas akkuhshtakas wat kaiz kit kirain. Papihshtakas akkuhshtakas kwail kiztamikasha inintawa,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Me umin sunkana kamtat kit kaizamtu: “Pial mɨjmikane papihshtakas, akkuhshtakas mɨlatkiwa, paiña pial Dios akwa watsarɨt akwa. Katmizna usparuza kiwainnapa mɨlanamtuchi.” ");
INSERT INTO kwi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sunkana une u pialkasa papihshtakas akkuhshtakas kiwainnasachi. ");
INSERT INTO kwi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Katmizna antikwa kamtam awaruza kamtanamtuasmin, une Dios pitta kain kininamtu, kiznara. Sunkanain an akkwan antikwa kamtam kainanamtu. ");
INSERT INTO kwi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Usne awara akwanat kit usparuza kaiznara: —¡Une nawa mɨt kit piankamarain! ");
INSERT INTO kwi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Awa akkwan piji chihtɨ kittakine, kumira kwatne, sun kumira ussa ayukta kwail kininsachi. Chiwazha ayukmal kaijchura min kit kirane, sunmin ussa kwail kinintu. ");
INSERT INTO kwi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na kuruntu aizpa mɨrain. ");
INSERT INTO kwi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wan awa kaiyarawane, Jesúsne maza yalta napta. Sua paiña kammuruzne ussa masas kamtampa mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesúsne usparuza mɨmanara: —¿Une wat mɨmtuchimakkiwas? Une sun awakana minñamtu. Diosne wan kumira kwintɨt, kwanpa. Chiwazha kumira kwatne, sun kumira ussa kwail kininsachi. ");
INSERT INTO kwi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sun kumira ayukta kaijchukin napkain. Pusunmal naptu. Naptawane, tas puzmu, kiznara. Sunkana Jesúsne kaiznara, awa piankamanapa, nil minñanapa. Diosne wan kumira sɨnam sarɨt, kuanapa. ");
INSERT INTO kwi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesúsne an kaiznara: —Chiwazha ayukmal kaijchura min kit kwail kitne, sunmin ussa kwail kinintu. ");
INSERT INTO kwi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wan kwailne ayuktas, kaijchuras puztu. Kwail mintane, usmin kwail parɨm. Ashampa kanpain mɨj pittane, usmin kwail parɨm. Walkumtumikane kwail parɨm. Awara piantamtumikane kwail parɨm. Mamazpa ashampakasa pittane, mamazpa ampukasa pittane, usmin kwail parɨm. ");
INSERT INTO kwi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mamazkin an paashitne, usmin kwail parɨm. Mamazta kwail kitmikane kwail parɨm. Pɨrail kaiztumikane kwail parɨm. Pailta payu kwail kishit kit wat mɨshitkine, usmin kwail parɨm. Patna pashimtumikane kwail parɨm. Mamazpa kwail kiztamikane kwail parɨm. Nane mamazkin an warish mintamikane kwail parɨm. Nilchi mintumikane, kwail kimtumikane kwail parɨm. ");
INSERT INTO kwi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sun wan kwailne ayuktas puzamtu. Sunmin ussa kwail panintu, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tas Jesúsne kuhsak kit mamaz sura ɨra. Tiro pɨpulukas Sidón pɨpulukas sulmin uz. Usne yalta nap kit mara. Puintain napshira, sun awa piankamamanpa. Usne usmin kulasachi. ");
INSERT INTO kwi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sun urain maza ashampane ussa piankamta. Kwail salizne paiña pashura piztɨt. Suasmesa sun ashampane at kit Jesúspa mittɨkin wakpuj wainta. ");
INSERT INTO kwi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Usne mamaz suras ara. Usne Judío awaras chi. Griego pit kwinta kit kit Sirofenicia suras ara. Usne ussa paikwat: —Kwail salizne ap pashura pizta. Ussa puzninti, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesúsne ussa kaizta: —An ñancha au pashparuza kumira kwinnarawamakpas. Kumira tizkane, kwizara kwintawa. Kawarain an ñancha Judío awaruza kwira kinnarawa. Suasne kwiztane mamaz awaruza kwira kinnarawa, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","An ashampane ussa sɨnkara: —Watcha, ap Anpat. Nakas kwizakana ish. Pashpa kukane, pitchin pak taizkane, kwizane tizka sak kum. Katmizna ap pashura wat paninnaka, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesúsne ussa kaizta: —Kwisha watsal sɨnkazi. Katmizna up yaltain kailtɨnka. Sun kwail salizne up pashuras me puzta, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Paiña yalta kailtawane, sun ashampane paiña pashura kamara tukin izta. Usne pashpara saliz puznintɨt wanmalta. ");
INSERT INTO kwi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Suasne Jesúsne Tiro suras kail kit Sidón suras pɨnta. Usne Decápolis suras pɨnta Galilea Pirakima. ");
INSERT INTO kwi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sua awane maza ampura ussa karaara. Sun ampune mɨsachi. Uskas wat kwinta kisachi. Awane us akwa Jesústa paikwara, paiña chihtɨkasa ussa paanapa, wat panapa kizara. ");
INSERT INTO kwi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesúsne ussa paimpa mit kit paiña chihtɨ tɨppu kailkin napninta. Suasne Jesúsne paiña chihtɨ tɨppura ilpi ɨtkularɨt kit parasachimikawa yankwijara paara. ");
INSERT INTO kwi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chiyura izaktawane, ayukta tɨnta pshtat kit paiña pitkasa kaizta: “¡Efatá!” kizta. (Sunne ɨnkal awa pitkasa kiztu: “¡Pit ɨsakti!” kizta.) ");
INSERT INTO kwi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Suasne sun urain usne mɨra. Paiña yankwija chɨhkultawane, wat kwinta kimɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Usne awara kaiznara: —Anne mɨnainkas kaizman, kiznara. Akkwan piji mɨnainkas kaizman kiznarakas, sun awane mɨashitchi. Jesús kaizman kiztakas, uspane an akkwan kaiznara. ");
INSERT INTO kwi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Uspane kwisha akkwan iztaspaat kit kaizara: “Usne wan watsal kirɨt. Usne mɨkaintuza mɨninnashina. Usne parakaintuza paraninnashina,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mamaz payura akkwan awane wanmakkara. Sun awa kumira mɨjchi akwa, Jesúsne paiña kammuruza akwanat kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nane sun awaruza kiwainashimtus. Kutña payukima nakasa puranash. Uspane chi kum mɨjchimai. ");
INSERT INTO kwi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kumira mɨjchine, uspa yaltakima ɨninnarane, miwara najarɨnazi. Maza mazain attishtas aara, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Paiña kammuruzne ussa mɨmaat kit sɨnkaara: —Apane, awa tuchira, ¿miza kumirama sun awara kwinnanapai? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Usne usparuza mɨmanara: —¿Yawa panma mɨjmakpas? kiznara. Uspane kaizara: —Siete pan mɨjmakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Usne wanta kaiznara: —Piltain uztain, kiznara. Siete pan saptawane, Diosta kaizta: —Aishtaish, kizta. Usne pan kɨz kit kammuruza mɨlanara, awara nailnanapa. Uspane panne wanta kwinnara. ");
INSERT INTO kwi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Uspane pitchin pishkarukas mɨjmara. Diosta aishtaish pishkaru akwa kiztawane, kammuruza kaiznara: —Sunkas wan awara kwinnarain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Uspane kuat kit tukkara. Kuarawane, pitti pitti tizara. Paiña kammuruzne pitti pitti siete tɨmta winñara. ");
INSERT INTO kwi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ampara mil ampu kuaara. Kuarawane, Jesúsne usparuza uspa yalta ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Suasne Jesúsne paiña kammuruzkasa kanuara waat kit Dalmanutara sura ɨara. ");
INSERT INTO kwi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseo awane aat kit ussa tɨnta kwinta kiara. Uspane us kwail kinpa ussa kaizara: —Nu Diostas atne, chiwazha iztasparɨt kal Diostas izninchain, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesúsne ayukta tɨnta pshtat kit uspa akwa tayal kit kaiznara: —Une chiwazha Diostas iztasparɨt kal izshiamtu. Dios nawa chiyuras ɨnintakas, nane umɨza chinkas izninnamanash. ");
INSERT INTO kwi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesúsne sun awara tuij ɨnat kit mamasa kanuara wat kit pi kwakara ɨra. ");
INSERT INTO kwi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kammuruzne pan mainñat kit karaarachi. Maza panmin kanuara mɨjara. ");
INSERT INTO kwi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesúsne usparuza manta kit kit kaiznara: —¡Mɨrain! ¡Kwiraruin! ¡Kwail awakana uzman! Fariseo awaruzkas Herodes kamtamtuzkas nil kamtaamtuchi. Paiña kamtam kiñakana i. Kiñane chappira sulnintu. Paiña kamtamne kiñakana awara maizanazi. ");
INSERT INTO kwi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesúspa kammuruzne usparuzpain sun kwinta kiat kit kaizara: —Pan mɨjchimakpas. Katmizna Jesúsne sunkana kwinta kira, kizara. Jesúsne Fariseo kamtampa paranara. Uspane wat mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesúsne uspa minñamtu aizpa piankamta. Uspane ussa mɨasachi. Katmizna usparuza kaiznara: —¿Nɨjkulamanas? ¿Mɨamanas? ¿Izamanas? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Une kasu wajmai. ¿Izmuskiwas? Une kail wajmai. ¿Mɨmuskiwas? ¿Nɨjkulmuskiwas? ");
INSERT INTO kwi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cinco pan kɨztawane, cinco mil ampura nail kit kwinnarau. ¿Yawa pan tɨzta tɨmta winñanash? kiznara. Uspane ussa kaizara: —Doce tɨmta winñanashɨ, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ankas Jesúsne kaiznara: —Siete pan tɨztawane, ampara mil awara nail kit kwinnarau. ¿Yawa pan tɨzta tɨmta winñanash? kiznara. Uspane ussa kaizara: —Siete tɨmta winñanashɨ, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Usne usparuza kaiznara: —¿Mama nawa nɨjkultuchimakkiwas? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kwiztane Jesúskas paiña kammuruzkas Betsaida pɨpulukin aara. Mɨnpazha awane awa izsachira Jesústa karat kit tɨnta paikuat: —¡Ussa paari, kasu izkulnapa! kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesúsne an awa izsachira chihtɨra piz kit ussa pɨpulukis mɨlta. Sua ilpikasa paiña kasukin nɨra. Paiña chihtɨkasa ussa paarawane, ussa mɨmara: —¿Mane izshinakish? kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sun awane izak kit kaizta: —Nane awara iztus. An awane tɨkana chamtui iztus, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Suasne mamasa Jesúsne chihtɨkasa kasukin pal pizta. Suas sun awane tɨnta iz kit wat izkulta. Wanta kai izta. ");
INSERT INTO kwi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesúsne ussa paiña yalta ɨnin kit kaizta: —¡Up yalta kailti! ¡Pɨpulukin napmun! ¡Mɨnainkas kainammun! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesúskas paiña kammuruzkas akkwan ainki pɨpulura ɨara. Kashara Filipowa Cesarea pɨpulu uz. Ɨamtuasmin, usne paiña kammuruza mɨmanara: —Uspa nawa parakane, ¿Nawa chima kizamtui? ¿Mɨnma na ish kaizamtui? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Uspane ussa sɨnkaara: —Mamaztuzne “nune Juan munnammika i” kizamtu. Mɨnpazha “Nune Elías, Dios pit kainammmika, i” kizamtu. Mamaztuzne “Mamaz Dios pit kainammmika i, kizamtu,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Usparuza mɨmanara: —¿Une nawa chima kizamtu? ¿Nane mɨnma ish? mɨmanara. Pedrone ussa sɨnkara: —Nune Dios nɨrɨtmika i. Diosne nua au sura ɨnintɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesúsne usparuza kaiznara: —Watcha. Nane Cristo ish. Sun mɨnainkas kaizman, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Usne usparuza kamtanamɨz kit kaiznara: —Nane, Ampu namtɨtmikane, awaruza kiwainanamtus. Awaruza kiwainashimtukas, nane kwisha naiznash. Ɨlapa ampuruzkas, katsa pariyaruzkas, Moisés kaizta aizpa kamtamtuzkas nawa kwayarɨnpas. Nawa piantarɨnpas. Nawa piantarawane, mamasa uznash. Kutña payura kuhsnash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesúsne us intu payuwa kaiznara, wan awa wat piankamanapa. Pedrone ussa paimpa mɨl kit tɨnta kaizta: —¡Sunkanane paramun! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesúsne kail kit puijchat kit mamaz kammuruza iz kit Pedrora ka kaizta: —¡Nawa chɨhkazha! Nune Satanáskana kwinta kimtu. Nune Dioskana mintuchi. Awakana mintu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tas Jesúsne wan awaruzakas paiña kammuruzakas ussain akwannat kit kaiznara: —Mɨnpazha ap kammuruz namashitne, ¡nakasa aat kit na kamtamtu aizpa piakamanaka! ¡U pashit aizpa chɨhkawizanaka! Nawa kanpamtuzne naizarɨnazi. Nakanain uzwizanaka, naiznakima, kurishta innakima. Sunkana ap kwizpa awizanaka. ");
INSERT INTO kwi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wan uspain watsamturuzne iat kit wan kaarɨnazi. Mɨnpazha na akwa irane, Dios watsal pit akwa irane, Diosne usparuza uzninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wan su mɨjne, wan pial mɨjne, sunkanane awane chiyura uzasachi, irɨtne. ");
INSERT INTO kwi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Irɨtmikane pial tasachi, chiyura uzna. ");
INSERT INTO kwi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mɨnpazha kwail awa iztakin, nil nɨjkultachiruzkin, nawakas ap kamtampakas mɨtsal kiarane, nane, Ampu namtɨtmikane, usparuza mɨtsal kinanash. Ap watsal Taittakas paiña sɨnam ángeltuzkas na amtu payura aanazi. Sun payura nane nawa mɨtsal kirɨttuza mɨtsal kinanash. ");
INSERT INTO kwi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesúsne ma pitchin usparuza ka kaiznara: —Watcha kaiznamtus. Mɨnpazha apa uzturuzne azain iamanazi, Dios awaruza ɨninnanakima. Mɨnpazha Dios awaruza ɨninnashimtu piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis payu pailka, Jesúsne Pedrorakas Santiagorakas Juantakas kwash ɨzara minara. Usparuzpain purara. Jesúsne uspa iztakin maizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paiña kwakshamne maiz kit an putchã, puztɨt. Akkwan piji pattane, paiña kwaksham an putchã puzsachi. ");
INSERT INTO kwi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Suane paiña kammuruzne Elíastakas Moiséstakas izara. Ñamin apain uzpailta. Uspane chiyuras ail kit Jesúskasa kwinta kiilta. ");
INSERT INTO kwi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Suane Pedrone Jesústa kwinta kimɨzta. Us kaizta aizpa wat pianchi akwa, ishkwat akwa. Katmizna usne ka kaizta: —Kamtam, aune wat puramakpas. Kutña ɨranchu sazhain, ukas Moiséskas Elíaskas aukasa tuanpa, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Suasne wanish at kit wanta sɨpnara. Diosne wanish ayukmalsɨh kaiznara: “Anne ap painkul i. Nane ussa pashimtus. Ussa mɨrain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sun urain kutñaruzne Elíastakas Moiséstakas izarachi. Dios kutñaruza kwinta kitpane, Jesústain izara. ");
INSERT INTO kwi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ɨzaras kaiyamtuasmin, Jesúsne usparuza kaiznara: —Une izarɨt aizpa mamaztuza kainanaman. Nane Ampu namtɨtmika ish. Nawa piantarɨkane, uspane nawa pilta kamanazi. Nawa kamtawane, nane piltas salaktɨnash. An kwiztane awara sunpa kainanarain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Uspane uspa izarɨt aizpakas Jesús kaizta aizpakas watsarɨt. Usparuzpain us parɨt aizpa mɨmara: “¿Miza piltas kuhstɨmtu?” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Uspane ussa kaizara: —Moisés kaizta aizpa kamtamtuzne ka kaizamtu: “Elíasne Cristokin ñancha anazi. Cristone an kwizta anazi. ¿Elías an ñancha atki?” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesúsne usparuza sɨnkanara: —Watcha. Mazane Elíaskana Cristokin ñancha ara, wan nil sanapa, awa Diosta kaiyanapa. Ñamin Dios pit ka parɨt: “Kwail awane nawa, ampu namtɨtmikasha, ilninnanazi. Nawa izshiamanazi,” ka parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nane umɨza ka kaiznamtus: —Mazane Elíaskana watcha ara. Mamaz awane uspa kiashit aizpa kiat kit ussa piantaarɨt. Sunkana Dios pitta parɨt, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɨzaras kihsharawane, uspane sun nueve kammuruzkasa mamasa wanmakkaara. Akkwan awane sun nueve kammuruzkasa wanmakkaarɨt. Moisés kaizta aizpa kamtamtuzne usparuzkasa tɨnta kwinta kiarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Suasne wan awane Jesústa izat kit kwisha iztaspaarɨt. Uspane ussa ɨat kit kaizara: —Kai kɨntɨre, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesúsne usparuza mɨmanara: —¿Uspakasa chima kwinta kiamtu? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mazane sun akkwantas Jesústa sɨnkara: —Kamtam. Nane ap painkul apa kararau. Salizne ussa piztɨt. Ap painkulne sun saliz akwa kwinta kisachi. ");
INSERT INTO kwi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ussa pizkane, sun salizne ap painkulta pilta nainnintu. Ap painkul ilpi puz kit sula sɨt sɨt kimtu. Pilta nain kit tɨs pat kit kialtu. Nane up kammuruza kaiznarau: “Ap painkulta saliz puznintain,” kiznarau. Uspane saliz puzninsachi. Puzninna pianchi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesúsne paiña kammuruza sɨnkanara: —Ukas an akkwan awakas Dios pit nɨjkularachi. Na akwan payukima uruza kamtanarakas, une nawa mama mɨamtuchi. Une Dios aumɨza kiwainsachi, minñamtu. ¡Pashpara apa kararain! kaiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pashparane ussa karaarɨt. Kwail saliz Jesústa iztawane, salizne pashpara ulninta. Pashpane pilta nain kit tɨzak pɨn kit pittas ilpi puzta. ");
INSERT INTO kwi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesúsne papihshta mɨmara: —¿Yawa payukima sunkana uztu? mɨmara. Usne kaizta: —Ainkiasmin. ");
INSERT INTO kwi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kwail salizne ussa akwan piji ĩnta ɨninta, inapa. Pirakas ɨninta, pi kwanapa. ¡Aumɨza kiwainchain! ¡Kiwainshitne, kiwainchain! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsne papihshta kaizta: —Diosne Dios pit nɨjkulshimtumikasha kiwainshimtu. Diosne wan kishina, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Suasne papihshne kwian kit kaizta: —Dios pit nɨjkultus. Kiwaincha, an akwan nɨjkulna, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Akkwan awane Jesúspakin aat kit wanmakkara. Suasne Jesúsne salizta kaizta: —Nune pashpara mɨmanpa kininta. Pashpara paramanpa kininta. ¡Pashpara chɨhkat kit puzninti! ¡Ussa mamasa pizmun! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tas sun salizne tɨnta kwian kit pashpara mamasa tɨnta ulnin kit puzta. Pashpane irɨtkana iztɨt. Akkwan awane kaizara: —Pashpane irɨt, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Me Jesúsne paiña chihtɨ piz kit ussa kunninta. Pashpane kunta. ");
INSERT INTO kwi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús maza yalta naptawane, paiña kammuruzne paimpain ussa mɨmaara: —¿Chikishma aune kwail salizta puzninsachimakpas? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesúsne usparuza kaiznara: —Diosta kwinta kitkine, Diosta paikwatkine, sun salizkanane puzsachi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tas puzarawane, uspane Galilea sura kailnain ɨara. Jesúsne mɨnainkas uspa ɨamtura kainarachi, paiña kammuruza kamtanashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesúsne ka kiznara: —Awane nawa, Ampu namtɨtmikara, mamaztuza annanazi, nawa pizanapa. Nawa piantarawane, kutña payura mamasa kuhsnash. ");
INSERT INTO kwi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Me uspane Jesús kaizta aizpa mɨasachi. Ishkuarɨt akwa, uspane sunpa mɨmaarachi. ");
INSERT INTO kwi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum pɨpulukin piannaara. Yalta naptawane, Jesúsne usparuza ka mɨmanara: —Miwara ɨamtuasmin, ¿chi kwinta kipuspas? mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Uspa miwara ɨamtuasmin, uspane usparuzpain “mɨnma anza katsa azi” paraara kiz kit. Katmizna uspane puñain paarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Suasne Jesúsne uz kit sun doce kammuruza akwanat kit ka kaiznara: —Mɨnpazha katsa mikwakana namashitne, an ainki namtawa. Kiwainmumikakana namtawa, wanta kiwainnana, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesúsne maza pashpara uspa iztakin kunin kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mɨnpazha maza pashpara ap akwa saptane, nawakas sapnazi. Mɨnpazha nawa, Dios ɨnintamikasha saptane, usne nawakas ap Taittarakas sapnazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juanne Jesústa kaizta: —Kamtam, aune maza ampura izanashɨ. Usne nu akwa akwan kwail saliztuza puzninnara. Usne au kwizpa kanpamtuchi. Ussa ka kizanashɨ: “Jesústa paikwat akwa, salizta puzninmun,” kizanashɨ, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesúsne sɨnkara: —Sunkanane kaizmun. Na akwa wat kimtumikane an kwizta nawa kwail parasachi. ");
INSERT INTO kwi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aukasa waya kishimtuchimikane aumɨza kiwainamtu. ");
INSERT INTO kwi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Watcha umɨza kaiznamtus. Une Cristora piantuz mai. Katmizna mɨnpazha na akwa umɨza kwazi kwintane, umɨza wat kitne, usne Dios mɨlamtu aizpa sapnazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesúsne ka kaiznara: “Dios pit we mɨramikasha kwail kinpa kininman. Dios pit we mɨramikasha kwail kinpa kinintane, Diosne ussa naiznintɨnazi. An watshimasa katsa ukkasa paiña tɨmpukin kuh kit ussa katsa ñam pira kiakpɨnna. ");
INSERT INTO kwi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Up chihtɨkasa kwail kirane, an watshimasa chihtɨ tizpianna, kwail kimanpa. An watshimasa maza chihtɨkasain chiyura nap kit uzna. Kwail kimtumikane paas chihtɨkasa ĩnta napnazi. Sua naiztɨnazi. Sua ĩnne kwikain. ");
INSERT INTO kwi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Chat kit kwail kitne, an watshimasa mittɨ tizpianna, kwail kimanpa. An watshimasa maza mittɨkasain chiyura nap kit uzna. An kwailshimasa paas mittɨkasa ĩnta nap kit uzna. Anne an kwail i. Sua kwail chatmikane naiztɨnazi. Sua ĩnne kwikain. ");
INSERT INTO kwi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kasukasa iz kit kwail kitne, kasu uktawa, kwail kimanpa. An watshimasa maza kasukasain chiyura Dios ɨnintura nap kit uzna. An kwailshimasa paas kasukasa ĩnta nap kit uzna. Anne an kwail i. ");
INSERT INTO kwi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sua kwail kimtuzne naizarɨnazi. Sua ĩnne kwikain. ");
INSERT INTO kwi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wan Diosta piantuzne naizarɨnazi, an wat namanapa. Sunkana kumira ñam sarane, kumira an wat puztɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ñamne wari. Ñamne kumira wintane, ñam kulmu. Ñam kultakine, tɨh. Wat chi. Uruzpain wat kit kit kalpain uztain.” Sunkana Jesúsne kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Suasne Jesúsne Capernaum pɨpuluras puz kit Judea surakima ɨrɨt. Jordán pi kwakara tuazi. Akkwan awane ussa mamasa wanmakkara. Suasne Jesúsne usparuza mamasa kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseo kamtamtuzne ussa kashara aat kit ka mɨmaara, us kwail paranpa: —Ampune ashampa mɨjne, ¿Ussa kwaishina watki? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Suasne Jesúsne usparuza sɨnkanara: —Ñamin Moisésne ¿Umɨza chima kizkwin? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Uspane ussa sɨnkaara: —Moisés ka kaizta, “Ashampa kwaishitne, kwairɨm pɨnkɨh pat kit ussa mɨlatpa, kwaina,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Suasne Jesúsne usparuza kaiznara: —Moisésne umɨza ka kiznara, u Diosta chi mɨashimtuchi akwa. ");
INSERT INTO kwi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ñamin Dios wan sarawane, usne ampukas ashampakas sara. ");
INSERT INTO kwi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Katmizna ampu ashampara mɨltane, usne paiña papihshtakas paiña akkuhshtakas chɨhkatpa, paiña ashampakasa uzna. ");
INSERT INTO kwi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sun paas awane maza kwal namta. Suasmesa sun paasne mazakanain uznazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Katmizna Dios ampurakas ashamparakas wanmaktune, awane usparuza kwaikain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yalta kaiyarawane, paiña kammuruzne mamasa ussa sunpa mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesúsne usparuza kaiznara: —Mɨnpazha ashampa kwait kit mamazkasa kasara kitne, ampune Dios iztakin kwail kirɨm, mamaz ashampakasa uztu akwa. ");
INSERT INTO kwi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mɨnpazha ampu kwait kit mamazkasa kasara kitne, ashampane Dios iztakin kwail kirɨm, mamaz ampukasa uztu akwa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Suasne awane pashparuza Jesústa karaara, paiña chihtɨkasa paananapa, Dios usparuza kiwainanapa. Paiña kammuruzne usparuza kaiznara: —¡Jesúspakin karaman! kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesúsne sun iz kit usparuza aliz pat kit kaiznara: —Usparuza karaman, “kaizman” kiznara. Pashparuza kaiznara: —Nawa azhain. Diosne sun pashpa nawa mɨamturuzkana akwanamtu, usparuza ɨninnana. ");
INSERT INTO kwi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Watcha watsal kaiznamtus. Diosne umɨza ɨninnashimtu. Pashparuzne Diosta watsal mɨashimtu. Ukas pashpa Diosta mɨamtukana mɨrain. Kawarain Diosta mɨrain, Dios umɨza ɨninnanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pashpara munat kit chihtɨ paanat kit Diosta uspa akwa akwannara, Dios usparuza kiwainanapa. ");
INSERT INTO kwi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús miwara ɨmtuasmin, maza ampune azain at kit ussa wain kit ka kaizta: —Nune wat kamtam i. ¿Chima kinpai, Dioskasa chiyura pailta payukima uzna? kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsne ussa mɨmara: —¿Nawane chitma wari kiztus? Diosmin wari, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jesúsne ussa kaizta: Nune Dios manta kit aizpa pian: “Awara piantamun. Mamazpa ashampakasa pitmun. Walkumun. Awaruzpa kwail kizmun. Mamaz mɨj aizpa pashimun. Up taittawakas up akkwawakas wat kaiznari,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sun ampune Jesústa sɨnkara: —Kamtam, pashpaasmin sunkana kirau, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesúsne ussa iz kit pashit kit kaizta: —Maza tuntune kitchi. We. Ɨt kit wan mɨj aizpa painin kit sun pial puizaruza mɨlananaka, chiyura Dios nua mɨlamtu aizpa sapnapa. Tas ap kwizpa at kit nawa kanpazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sun mɨrawane, usne tayalmɨzta. Paiña pampa pial akwa, sun ampune Jesústa mɨshitchi. Tas kailta. ");
INSERT INTO kwi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Awaruza iznamtuasmin, Jesúsne paiña kammuruza kaiznara: —Kwazpa kultɨttuzne Dios ɨnintukin wat nappasachi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Paiña kammuruzne paiña pit akwa iztaspaarɨt. Suasne Jesúsne usparuza mamasa kaiznara: —Izmuruz, mɨzha. Kwisha sam i, Dios ɨnintura napna. “Pãn kultumikane Dios ɨnintura napnash,” minman. ");
INSERT INTO kwi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Iyu chɨhku kulta tɨm. Maza kalpakanane, camello mun. Sun kalpane chɨhku kulta tɨsachi. Kawarain kwazpa kultɨtmikane paiña pial akwa Dios ɨnintura napsachi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sunpa mɨarawane, uspane kwisha iztaspaat kit usparuzpain kaizara: —Suasne mɨnminkas chiyura napsachi, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúsne usparuza iznat kit kaiznara: —Awane usmin watsat mɨlnasachi, Dios ɨnintura uzna. Diosmin awaruza watsat mɨlnashina, Dios wan chiwal kishimtu akwa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro ussa ka kaizta: —¡Izti! Aune wanta chɨhkat kit up kwizpa apuspas, piankamna, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsne sɨnkara: —Watcha kaiznamtus. Mazantuzne ap akwakas Dios watsal pit akwakas paiña yalkas paiña aimpihshkas paiña kwampihshkas paiña akkuhshkas paiña papihshkas paiña pashpakas up sukas chɨhkaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Diosne wan chɨhkarɨttuza an akkwan mɨlananazi. Chiwazha chɨhkarɨtne, Diosne usparuza an akkwankima apain mɨlananazi. Mamaz yalkas aimpihshkas kwampihshkas akkuhshkas pashpakas sukas mɨlananazi. Na uruza wat kinamtukas, mamaz awane umɨza naizninnanazi. Mamaz payura nane uruza chiyura pailta payukima uzninnanash. ");
INSERT INTO kwi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","An sukin uzamtuasmin, katsa mikwaruzne, apas awaruza ɨninnamtu. Katsa mikwaruzne an we katsa namanazi. Diosne apas kiwainamtuza katsa mikwakanain namninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesúskas paiña kammuruzkas miwara Jerusalén pɨpulura nuarɨmtuazi. Jesúsne an ñancha ɨzi. Paiña kammuruzne iztaspaarɨt. An kwizta amturuzne ishkuara. Jesúsne doceruza paimpa mɨlnat kit mamasa kaiznara: —Awane mamaz payura nawa kwail kianazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“¡Iztain! Jerusalén pɨpulura ɨamɨztumakpas. Suane Judío awane nawa, Ampu namtɨtmikara, pizanazi, katsa pariyaruzakas Moisés kaizta aizpa kamtamtuzakas chɨhkaanapa. Uspane nawa piantaana kizanazi. Tas uspane mamaz awara nawa chɨhkaanazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mamaz awane nawa ishananazi. Nawa pashiamtuchi akwa, nawa ilpi kianazi. Nawa iyanazi. Nawa piantaanazi. Kutña payu pailtawane, nane mamasa kuhsnash,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiagokas Juankas, Zebedeo painkultuzne, Jesús turakima ɨilt kit ussa kaizpailta: —Kamtam, au paasne nua chiwazha paikwashimtuas, chiwazha kinpa, kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesúsne usparuza mɨmanara: —¿Uruz akwa chima kinpai? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Uspane ussa kaizara: —Nu chiyura nukane, aune nu ɨnintukin nukasa uzshimtuas. Mazarane numal uzninti. Mamazta kwiyamal uzninti, kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesúsne usparuza sɨnkanara: —Une u paikumtu aizpa wat pianchi. Nane naiztɨnash. ¿Une nakana naizshinamakkiwas? Nane naiz kit tailchannash. ¿Une nakana naiz kit tailchashinamakkiwas? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Uspane ussa sɨnkaara: —Au paasne naizshinawas, kizpailta. Jesúsne usparuza kaiznara: —Une nakana naizpailnazi. Une nakana naiz kit tailchailnazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","U nakana naizarakas, nane mazara up numal uzshina, mazara ap kwiyamal uzshina, kaiznasachish. Diosne narɨttuza paiña numalkin paiña kwiyamalkin uzninanazi. ");
INSERT INTO kwi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mamaz diez kammuruz sun mɨarawane, uspane Santiagorakas Juantakas aliz kulaara. ");
INSERT INTO kwi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesúsne usparuza akwanat kit kaiznara: —Une miza mamaz awa ɨninnamtu pianmai. Sun ɨninturuzne usmin katsa mikwakana namamtu, an akkwan awaruza ɨninnanapa. Awaruza ɨninnakane, kwisha tɨnta ɨninnamtu. ");
INSERT INTO kwi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Uruzpain ɨninmikakana namman. U anza katsa mikwakana namashitne, kiwainmumikakanain namtain, pailta awara kiwainnanapa. ");
INSERT INTO kwi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Katsa mikwakana namashitne, ñamin ussain kiwainmumikakana namtawa, wanta kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nain, Ampu namtɨtmika ish. Nane atchish, awa nawa kiwainnapa. Nane apa arau, awara kiwainnana. Nane awa akwa inash, akkwan awa chiyura uzanapa. ");
INSERT INTO kwi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Suasne Jesúskas paiña kammuruzkas Jericó pɨpulura pianaara. Uspane akkwan awakasa Jericó pɨpulura puzakane, izsachimikane mi mamin uzta. Puiza akwa usne chiwazha paikumtu azi. Usne Bartimeo mun. Usne Timeowa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mɨnpazha ussa ka kizara: —Jesúsne, Nazaret pɨpuluras, kasha amtui, kizara. An mɨkane, Bartimeone kwian kit ka kaizmɨzta: —¡Jesús, Davidpa pampa, nawa kiwaincha! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Akkwanne ussa kaizara: —Kwianmun. Puñain, kizara. Sun akwa an tɨnta kwian kit kaizta: —Davidpa pampa, nawa kiwaincha, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesúsne kun kit kaiznara: —Ussa akwarain, kiznara. Uspane Bartimeora akwat kit kaizta: —Ishkumun. Kuhsakti. Usne nua akwantu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Usne paiña ijmu kiakpɨn kit kuhsak kit Jesús turakima ɨra. ");
INSERT INTO kwi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesúsne ussa mɨmara: —¿Nu akwa chima kinpai? kizta. Izsachimikane ussa kaizta: —Kamtam, ¡Kasu izkulnincha! kizta. ");
INSERT INTO kwi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesúsne ussa kaizta: —Nune “Jesús nawa izkulninnazi” nɨjkulta. Katmizna nune wat parɨt. Ɨmɨzti, kizta. Sun urain izkulninkwera. Kasu izkultawane, usne Jesústa kwizpa kanpara. ");
INSERT INTO kwi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesúskas paiña kammuruzkas kasharakima Jerusalén pɨpulura pianaara. Betfagé pɨpulukas Betania pɨpulukas an kashain uz. Maza ainki ɨzane kaiwarain tu. Sua akkwan olivos tɨ warɨt. Jesúsne paas kammumikasha ɨnin kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Sun pɨpulura ɨrain. Pɨpulura piannakane, mamaz ainki caballora kantɨt pana izpailnazi. Ñamin mɨnminkas caballora anuztachi. Caballo chɨht kit tainñanka. ");
INSERT INTO kwi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mɨnpazha umɨza ka mɨmanazi: “¿Chikiztama caballo chɨhtuas?” mɨmanazi. Suas ussa kaiztain: “Ap Anpatne caballo pashimtui, anuzna. An kwizta usne umɨza caballora kailninnanazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sun paas kammuruzne ɨil kit caballo wanmalpailta. Pɨjtakin kantɨt pana. Uspane caballo chɨhtpailta. ");
INSERT INTO kwi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɨnpazha kasha panaruzne usparuza kaiznara: —¿Chikishma caballora chɨhtuas? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Paas kammuruzne usparuza Jesús kaizta aizpa kaiznarawane, uspane caballora an paaskasa ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Uspa paasne Jesús turakima caballora tainpailta. Awaruzne caballo punsɨhkin uspa pĩn ampalara. Jesúsne caballora anuzta. ");
INSERT INTO kwi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Akkwan awane mikin uspa pĩn kɨhara. Anpane akkwan kwazpil kɨhkas chappil kɨhkas tɨt kit mikin kɨhtara, mi watsal puznapa. ");
INSERT INTO kwi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Akkwan awane ussa an ñancha ɨara. Anpane kwizpa aara. Pailta awane ka kwianara: “Diosne kwisha wari. Diosne nua ɨninta, au Anpat namnapa. Nukas kwisha wari. ");
INSERT INTO kwi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Diosne nua ɨninta, awaruza kiwainnapa. Nune au pampa David mikwakana ɨninnazi. Diosne, chiyura uzmikane, kwisha wari,” kizara. ");
INSERT INTO kwi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesúsne Jerusalén pɨpulura piannarawane, Dios katsa yalta napta. Wanta iznarawane, usne paiña doce kammuruzkasa Betania pɨpulura kailta, nashtɨmtu akwa. ");
INSERT INTO kwi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tɨlawane Betania pɨpuluras puzarawane, Jesúsne yak kira. ");
INSERT INTO kwi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesúsne attishtas maza tɨra izta. An tɨne higuera mun. Kɨh wa. Usne ɨt kit izta, pippa saina. Pianatpane, pippa iztachi. Kɨhmin izta. Pippa wachi. ");
INSERT INTO kwi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesúsne tɨra kaizta: —An tɨras mɨnminkas pippa kuamanazi, kizta. Paiña kammuruzne us kaizta aizpa mɨara. ");
INSERT INTO kwi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalén pɨpulura piannakkara. Jesúsne Dios katsa yalta nap kit paininturuza pianamal ɨninnara. Paimturuzkas pianamal ɨninnara. Jesúsne pial maizmuruzpa misharɨ kiakpɨnara. Utkuru painintuzpa misharɨkas kiakpɨnara. ");
INSERT INTO kwi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesúsne wanta kaiznara: —Dios katsa yalpara kainsɨh mɨlnachi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesúsne usparuza kaiz kit ka kamtanamɨzta: —Diosne ñamin pɨnkɨhta ka panintɨt: “Wan suras awane ap katsa yaltakima aanazi, nawa paikwan.” Walkumtuzne katsa kulta kulaamtu. Une ap yalkin wanmakkamtu, awaruza walkwan, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús kaizta aizpa mɨarawane, katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas Jesúspa ishkuat kit Jesústa piantana minñara. Wan awane Jesúspa iztaspaarɨt, paiña kamtarɨt aizpa mɨarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","An tɨl pamɨzkane, Jesúskas paiña kammuruzkas pɨpuluras puzara. ");
INSERT INTO kwi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tɨlawain miwara ɨamtuasmin, uspane sun higuera tɨra izara. Tɨ kwalkas mujtɨtkas irɨt. ");
INSERT INTO kwi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Suasne Pedrone nɨjkul kit ka kaizta: —Kamtam, ¡Izti! An higuera tɨra nu “pippa wamanazi” kaizta aizpa irɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsne usparuza sɨnkanara: —Diosta nɨjkultain. ");
INSERT INTO kwi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Watcha kaiznamtus. Diosta paikukane, Diosta watcha ka min kit nɨjkultane, nune an ɨnkalta ka kizshina: “An ɨnkalta katsa pirakima ɨnintus.” Ka kiztawane, an ɨnkal ɨnazi. Diosta kaijchukasa wat nɨjkultane, Diosne nu tɨriztu aizpa kinazi. “Dios nawa kiwainsachi” mintane, Diosne nu kaizta aizpa kimanazi. ");
INSERT INTO kwi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Katmizna u chiwazha pashitne, Diosta paikwarain. Diosta nɨjkultain, Dios nua mɨlashimtu aizpa sapnapa. ");
INSERT INTO kwi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dios iztakin paikukane, umɨza kwail kittɨttuza wat kultain. U mamaz kwail kittɨttuza wat kultane, u chiyuras Taittane umɨza wat kulnanazi. U kwail kihananazi. ");
INSERT INTO kwi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","U mamazta wat kultukine, u chiyuras Taittane umɨza wat kulnamanazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Suasne Jesúskas paiña kammuruzkas Jerusalén pɨpulura kaiyara. Jesúsne Dios katsa yalta piannakane, katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas Judío ɨlapa ampuruzkas aara. ");
INSERT INTO kwi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesús iztakin aat kit ka mɨmaara: —¿Nua mɨnma ɨninta, Diospa yaltas awara kinakpɨn ɨninna? mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsne usparuza sɨnkanara: —Nakas uruza mɨmananash. Sɨnkazhain. Sɨnkarane, nakas umɨza mɨnma nawa ɨninta sɨnkananash. ");
INSERT INTO kwi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Mɨnma Juan munammikasha ɨninta? ¿Diosne ussa ɨninma? ¿Awa ussa ɨninma? ¡Sɨnkazhain! kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Uspane usparuzpain tɨnta kwinta kiat kit kaizara: “Aune Diosne ussa munnanapa ɨninta kaizsachimakpas. Sunkana kiztane, Jesúsne aumɨza ka mɨmananazi: ‘¿Chikiztama ussa nɨjkulamanas? ");
INSERT INTO kwi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aune awa kaizsachimakpas, ussa munnanapa ɨninta.’ Sunkana kiztane, wan awane aumɨza kwail paraanazi. Akkwan awane Dios Juanta ɨninta minñamtu. Uspane ‘Juan Dios pit kainammmika azi’ minñamtu,” ka usparuzpain kaizara. Uspa awawa ishkwarɨt akwa, ");
INSERT INTO kwi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","katmizna uspane Jesústa sɨnkaara: —Aune mɨnma Juanta ɨninta pianchimakpas, kizara. Jesúskas usparuza kaiznara: —Nakas mɨnma nawa ɨninta Dios yaltas awara kiakpɨn ɨninna uruza kaiznamanash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesúsne katsa pariyaruzakas Moisés kaizta aizpa kamtamtuzakas ɨlapa ampuruzakas masas kamtam kwintakasa kamtanamɨzta: “Maza ampune, su pamikane, wankail tɨt pippa paiña pilkin wara. Paiña pilkin kintɨt mɨjazi. Pil kɨht kit akkal alpara uk tarɨt, wankail pippa kuztɨt tulpiznapa. Ainki yalmin sara, wan su izna. Su pamika sun kal kimturuza nailnakin chɨhkat kit attishta ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Paktu payu akane, su pamikane paiña kiwainmumikasha paiña sura ɨninta, nail kit paiña paimpa sapnapa. ");
INSERT INTO kwi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Su kal kimturuzne kiwainmumikasha pizat kit aim kiara. Uspane ussa chinkas mɨlarachi. Uspane kainmin ussa ɨninaara. ");
INSERT INTO kwi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mamasa su pamikane mamaz kiwainmumikasha ɨninta. Uspane ussa pizat kit kɨzpukin aim kiat kit ussa kwail kiarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Usne kwizta mamazta ɨninta. Uspane ussa piantaarɨt. An akkwanta ɨninnara. Uspane akkwanta ilnarɨt. Anparuza piantanarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Su pamikane paiña painkulkasa uzta. Ussa pashire. An kwizpane ussa ɨninta. ‘Ap painkulta kwail kiamanazi,’ minta. ");
INSERT INTO kwi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Paiña painkulta izarawane, su kal kimturuzne usparuzpain kaizara: ‘Su sapmumikane amtui. Ussa piz kit piantana ɨzhain. Ussa piantarawane, aune paiña su pakiwiznapas,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Uspane ussa pizat kit piantaara. Irɨkane, uspane ussa wankail pippa piltas pianmal kiakpɨnara, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Suasne Jesúsne pariyaruzakas Moisés kaizta aizpa kamtamtuzakas ɨlapa ampuruzakas kaiznara: ‘¿Su pamikane chima kinazi? Usne paiña sura kail kit su kal kimtuza piantananazi. Suas paiña sukin mamaz kal kimtuza chɨhkananazi,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesúsne kaiznara: Une Dios pit pɨnkɨhta izarɨt. Ka parɨt: ‘Yal sammikane wat uk kiakpɨntɨt. An kwizta usne sun kiakpɨntɨt uk sak kit sam wara, yal naina akwa. ");
INSERT INTO kwi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Au Anpat Dios us kishit aizpa sarɨt akwa, Aune Dios kit aizpa kwisha wari kizmuspas,’ ka parɨt,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sun awane Jesús sun kamtam kwintakasa usparuza paranamtu minñara. Uspa ussa pizshiarakas, uspane akkwan awa akwa ishkuat kit Jesús tukis ɨara. ");
INSERT INTO kwi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fariseo awaruzkas Herodes kanpamtuzkas mazantuza Jesústa ɨninñara, us nil chi kwinta kininpa. ");
INSERT INTO kwi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Uspane ussa aat kit kaizara: —Kamtam. Aune nu watcha paramtu pianmakpas. Nune pailta awara kawarain paranamtu. Nune izmuruzakas aliz awaruzakas kawarain paranamtu, ishkwatchin. Nune awa Dios ɨnintɨtkana uzanapa kamtanamtu. Roma pɨpulura Emperadorne katsa mikwa i. Usne apas awara ɨninnamtu. ¿Mizama kai? ¿Pial ussa tanapas? ¿Pial ussa tamanapas? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesúsne uspa minñamtu aizpa pian. Uspane nil chi minñara. Suasne Jesúsne usparuza kaiznara: —Une nawa kwail kiashinintu. ¡Maza pial kararain izna! kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Uspane ussa pial karaara. Usne usparuza mɨmanara: —¿Mɨn awa kɨzpuma izamtuas? ¿Mɨn munma pialta parɨt? kiznara. Uspane kaizara: —Au pɨpulu Emperador mikwa kɨzpura izamtuas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesúsne usparuza kaiznara: —Emperadorpa pial ussa tarain. Emperador ɨnintu aizpa kirain. Kawarain Diospa pial ussa tarain. Dios manta kit aizpa mɨrain, kiznara. Uspane paiña pitkasa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceo awaruzne Jesústa aara. Uspane nil chi min kit mamaztuza kamtanamtu. Awa irawane, mamasa kuhsamtuchi minñamtu. Uspane Jesústa sunpa mɨmaara: ");
INSERT INTO kwi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Kamtam, Moisésne ñamin aumɨza ka pattɨt, “Ampu irane, pashpa mɨjchi irane, paiña ashampane mazain uz. An impara irɨtmikawa aimpihshne paiña ashampara mɨltawa, us akwa pashpa mɨjan,” ka parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Siete aimpihshtuzpain uzara. Aimpihsh ɨlapamikane ashampa mɨlta. Ashampa pashpa mɨltachasmin, ampune irɨt. Usne pashpa mɨjchi irɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Suasne kanmika aimpihshne paiña ashampara mɨlta. Uskas pashpa mɨjchi irɨt. Kawarain kanmika aimpihshne pashpa mɨjchi irɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sunkana siete aimpihshtuzne sun ashampara mɨlara. Pashpa mɨjchi iarɨt. An kwiztane sun ashampakas irɨt. ");
INSERT INTO kwi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Awa irɨt mamasa kuhstane, ¿mɨnmika sun ashampara mɨlnasa? wan siete aimpihshtuzpain ussa mɨlarɨt akwa, ka kizara. ");
INSERT INTO kwi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","25","Jesúsne usparuza sɨnkanara: —Nune ñanta kiat kit Dios parɨt aizpa pianchime. Diosne wan kishina. Awa irɨttuza kuhstawane, chiyura ashampane ampura mɨlkain. Ampune ashamparakas mɨlkain. Uspane ángelkanain puranazi. Ángelne ashampara mɨlkain. Katmizna une nil minñamtuchi. ");
INSERT INTO kwi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nane awa irɨttuzpa umɨza kainanash, uspa kuhsamtu akwa. Une ñamin Moisés pɨnkɨh parɨt aizpa pianmai. Suane Moisés impaktɨmtu tɨra iztuasmin, Diosne ussa ka kwinta kirɨt: “Nane Dios ish. Abrahampa Dios ish. Isaacpa Dios ish. Jacobwa Dios ish.” ");
INSERT INTO kwi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uspane an ñancha iarɨt. Uspa iarawane, Diosne usparuza kwinta kinara. Katmizna uspane ma payu uzamtu. Une awa irɨttuz kuhsamtuchi kizamtu. Une ñanta minñamtu, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús Saduceo awaruza wat sɨnkamtawane, Moisés kaizta aizpa kamtammikane kamtanarɨt aizpa mɨt kit Jesús tukin at kit mɨmaara: —Nu usparuza watsal sɨnkanarɨt akwa, nawa sɨnkazha. Diosta akkwan ɨnim pit para. ¿Chi ɨninta pit an wari? kizta. ");
INSERT INTO kwi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesúsne sɨnkara: —Diosne an ñamin an watsal ɨnim pit ka manta kinara: “Israel awa, mɨrain. Au anpatne Dios i. Mamaz diosne uzchi. ");
INSERT INTO kwi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ka akwaizna u Anpatta, u Diosta pashirain u kaijchukin. Mintuasmin, Diosta pashirain. Kal kimtuasmin, Diosta pashirain.” ");
INSERT INTO kwi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Suasne Diosne kwizta mamaz ɨnim pitka manta kinara: “Up kwalta pashirain. Kawarain izmuruzakas pashinarain.” Mamaz an kwisha wat ɨnim pit wachi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Moisés kaizta aizpa kamtammikane ussa kaizta: —Kamtam. Nune nilkas watchakas sɨnkamtu. Diosne mazain i. Mamaz diosne uzchi. ");
INSERT INTO kwi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Diosta pashitpa. U kaijchukin Diosta pashitpa. Mintuasmin, Diosta pashitpa. Kal kimtuasmin, Diosta pashitpa. Izmuruza pashitpa up kwalkana. Sunkana kiarane, une Dios ɨnintu aizpa kianazi. Maintas une wakara paktana Diosta mɨlara. Chiwazha Diosta mɨlaarɨtkas, Diostakas izmuruzakas pashinana anza wari, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesúsne sun Moisés kaizta aizpa kamtammika watsal sɨnkara minta. Katmizna Jesúsne ussa kaizta: —Nune Diospa ɨnintukin kasha pianpain. Diosne nua ɨninshimtu, kizta. Tas mɨnminkas ussa mɨmaashitchi. ");
INSERT INTO kwi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesúsne Dios katsa yalkin awara kamtanat kit kaiznara: —Moisés kaizta aizpa kamtamtuzne “Cristone Davidpa kwal i” kizamtu. ¿Chikishma sun kaizamtu? ");
INSERT INTO kwi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidne, Dios Sɨnam Izpul akwa, ñamin kaiz kit “Cristone ap Anpat i”, parɨt: “Diosne Cristora ka kaizta: ‘Ap makin uzti, nakasa ɨninnapa, nua aliztuza anuppanakima,’ ” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ñamin Diosne Cristora ka kaizta: Davidne “Cristo ap Anpat i” kiztui. Katmizna Cristone Davidpa kwalkas Davidpa Anpatkas i, kiznara. Sunkana Jesúspa usparuza kamtanara akwa, kwisha akkwan awane ussa wat mɨashira. ");
INSERT INTO kwi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesúsne akkwan awa wanmaktɨttuza kamtanat kit kaiznara: “¡Kwiraruin! Moisés kaizta aizpa kamtamtuzkana uzman. Uspane aks kwaksham kwashiamtu. Uspane sun kwakshamkasa pɨpuluwara chashiamtu, awa usparuza ‘wat kɨntɨre’ kizanapa. ");
INSERT INTO kwi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Uspane Judío kammu yalta akkwan awa purakin uzshiamtu. Uspane pishtara an ñancha chat kit an wat uzmura uzshiamtu. ");
INSERT INTO kwi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɨnkwa mɨj aizpa walkwatpane, uspane tɨnta kukaizamtu, awa uspa pɨrail appamtu minñamanpa. Diosne usparuza tɨnta ilnanazi, naiznanakima,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesúsne Dios katsa yalta pial sapmukin kashain kunta. Akkwan awa pial taamtu aizpa izta. Pampa pial mɨjtuzne akkwan pial taara. ");
INSERT INTO kwi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Maza ɨnkwane, mazainpa uzmikane, at kit pial sapmukin paas pialmin winta. ");
INSERT INTO kwi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Suasne Jesúsne paiña kammuruza ussain akwanat kit ka kaiznara: —Watcha kaiznamtus. An ɨnkwane kwisha puiza i. Usne pial sapmukin at kit wan tararuzkin an akkwan tara. Anpa kwazparuzne an wemin taara. ");
INSERT INTO kwi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Anpa kwazparuzne pial tiztɨt mɨj aizpa taarɨt. Puiza ɨnkwane wan mɨj aizpa tarɨt, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Dios katsa yaltas puztawane, maza kammumikane Jesústa kaizta: —Kamtam. ¡An kalpial izti! Awane sun katsa yal katsa ukkasa saara, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesúsne ussa kaizta: —Nune an katsa yalta iztu. Mamaz awane kwizpa aat kit wan ukta azpianat kit kiakpɨnanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesúskas paiña kammuruzkas ainki ɨzara, akkwan olivos tɨ warɨtkin piannaat kit uzara. Uspane ainki ɨzakis Dios katsa yalta izara. Pedrokas Santiagokas Juankas Andréskas paimpa ussa ka mɨmaara: ");
INSERT INTO kwi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Chi payurama awane an Dios yal azpian kit kiakpɨnasa? Sɨnkazhain. Pailtɨmtu payu taizkane, ¿Chima kirɨnsa? ¿Mizurama sun kirɨmtu? Aune piankamshimtumakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesúsne usparuza sɨnkanara: “Awane umɨza kut kuanazi. Katmizna usparuza izizanaka. ");
INSERT INTO kwi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Akkwan awane aat kit nil chi ka kizanazi, ‘Nane Dios namtɨtmika ish. Diosne nawa ɨninta,’ nil chi kizanazi. Uspane akkwanta kut kuanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kasha uztuzkas attishta uztuzkas waya kianazi. Akkwan awa waya kiamtu mɨakane, ishkuman. Waya kiamtukas, mama wan pailtuchi. Pitchin we. ");
INSERT INTO kwi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mamaz suras awane mamaz awakasa waya kianazi. Maza gobiernone mamaz gobiernokasa waya kianazi. Su ulmune akkwan sukin at kit ulnazi. Kumira pailmɨztawane, awane yak kiarɨnazi. Awane sunkana naizarɨnazi. Sunkana kiarane, awane akkwan naizamɨznazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Uruzpain iztain. Judío awane umɨza uspa mikwaruza chɨhkananazi. Uspane umɨza Judío kammu yalkin na akwa iyananazi. Uspane umɨza katsa mikwashakas ainki ɨninmikashakas na akwa chɨhkaanazi. Suane une uspa mɨrakin ‘Jesústa nɨjkulamtumakpas’ kizanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wan pailtachasmin, Dios pit piantuzne Dios watsal pit wan awara kainnanarawa. An kwizta wan pailtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ilmuruzne umɨza piznat kit mikwasha chɨhkaanazi. Usparuza sɨnkanamtuasmin, ishkuman. Sun payura paiña pit sɨnkarane, Diosne umɨza kiwainnanazi, paiña pit sɨnkanapa. Sunkas Dios Izpulne umɨza kiwainnanazi, paiña pit kwinta kinpa. ");
INSERT INTO kwi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aimpihshne paiña aimpihshta mamaz awara chɨhkanazi, irɨnpa. Papihshne paiña painkulta mamaz awara chɨhkanazi, irɨnpa. Pashparuzne papihshtakas akkuhshtakas aliz paranat kit piantaninnanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wan awane umɨza na akwa aliz paraanazi. Imtu payurakima tailchatne, Diosne umɨza watsat mɨlnanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Danielne, Dios pit kainammmikane, ñamin ka para: ‘Kwail awane Diablokana Dios yalta uzanazi. Sua usne uzasachi.’ Dios pɨnkɨh izturuzne sunpa piankamtain. Sun iztawane, sua sun kwail awa Dios yalta uzakane, Judea suras ɨarawa, ɨnkalta kulana. ");
INSERT INTO kwi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yal ɨsalta uzturuz sun mɨrane, yal ayukmal napman. Chiwazha ayukta watsarɨt mɨj aizpa ukkaman. ");
INSERT INTO kwi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Saumal kal kimturuzne yalta pĩn ukkana kailman. ");
INSERT INTO kwi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ashampa pɨja waruzne, pashpa chitchu kwintaruzne, sun payura naizarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sun payu akane, Diosta paikwatpa, alu kimanpa, ");
INSERT INTO kwi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","sun payura awa kwisha naizamtu akwa. Dios an su sarakima, awane sunkana naizarachi. An kwiztane awane sunkana naizamanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Akkwan payurakima naizarane, akkwan awane uzamanazi. Katmizna Diosne naiztɨmtu payu azain pailninnazi. Dios paiña narɨttuza pashinamtu akwa, usne sun payura azain pailninnazi, usparuza watsarɨt mɨlnana. ");
INSERT INTO kwi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Awane ka kiznazi: ‘Izti. Apa Cristo tui. Izti. Sua tui.’ Sun kizkane, mɨman. ");
INSERT INTO kwi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Awane aanazi, ‘nane Cristo ish’ kish kit. Mɨnpazha ‘nane Dios pit kainammika ish’ pɨrail kaizanazi. Uspane chiwazha wat kal kianazi. Uspa kal kiarɨt akwa, awane iztaspaanazi. Uspane Dios narɨttuza kut kuashianazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mɨrain. Iztain. Naizamtuchasmin, nane sunta umɨza kainanamtus.” ");
INSERT INTO kwi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sun naiztɨmtu payu pailtawane, ‘pãnkas palapchakas malmanazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kɨmakas chiyuras taizarɨnazi. Wan chiyura pura aizpa ul kit taizarɨnazi.’ ");
INSERT INTO kwi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Suasne wan awane nawa, Ampu namtɨtmikara, izanazi. Nane wanishkasain chiyuras anash, katsa mikwakana ɨninnana. Kwisha watsal iztɨt anash. ");
INSERT INTO kwi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Suasne nane ap ángeltuza ɨninnanash, Dios narɨttuza wanmakninnanapa. Nane pailta suraskas chiyuraskas wanmakninnanash. ");
INSERT INTO kwi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nane chiwazha kamtananash. Sun sura higuera tɨ kɨhne wan taizarɨm. Tɨ kɨhwil kwizmɨzkane, alu pulparɨm. ");
INSERT INTO kwi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kawarain awa naizamɨzkane, nane chiyuras kailnapain ish. Na kaiztu aizpa piankamtain. ");
INSERT INTO kwi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Watcha kaiznamtus. Ma uztuz iarachasmin, nane uruza kaiznamtu aizpa kianazi. ");
INSERT INTO kwi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wan chiyukas wan pilkas paiyarɨnazi. Ap pitne mizurainkas pailmanazi. Nane na kaizta aizpa watcha kinash. ");
INSERT INTO kwi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mamaz payura kailtɨnash. Chiyuras ángeltuzne sun payu pianchimai. Nakas, Dios Painkulne, sun pianchish. Ap Taitta Diosmin pian. ");
INSERT INTO kwi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ukas na kailtu payura pianchimai. Katmizna mɨrain. Iztain. Diosta paikwarain. ");
INSERT INTO kwi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nane umɨza kamtam kwinta kamtanamtus. Maza ampune attish sura ɨrɨmtu. Paiña yaltas ɨrɨkane, usne kiwaintuza akwanat kit ɨninnara, uspa kal kianapa. Usne yal watsammikasha, ‘Watsal iznaka,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mɨnminkas sun su pamika kailtu payu pianchimai. Sunkanain kailnash. Katmizna iztain. ¿U anpatne miza urama anazi? ¿Nashka? ¿Kakwamta? ¿Tɨlawain? ¿Payuin? Une pianchi. ¡Katmizna watsal izanaka! ");
INSERT INTO kwi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Paiña kailtu payura tɨrizamtuasmin, aune ussa sait kit paiña kal kiarawamakpas. ");
INSERT INTO kwi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Umɨzakas wantuzakas ka kaiznamtus. ‘Izanaka,’ ” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua pishta izna paas payu we. Sun pishta iztune, awane kuamtu. Pan sarane, kiña winkain. Katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas Jesústa puñain sait kit ussa kut kuashit kit pizshiamtu, ussa piantana. ");
INSERT INTO kwi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Uspane usparuzpain kaizara: —Jesústa pishta payura piztane, wan awane aukasa waya kianazi. Katmizna ussa pizamanawas, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesúsne Betania pɨpulura ɨt kit Simónpa yalta napta. Simónne ñamin ish kit ña pɨtta. Jesús misharɨ uz kit kumtuasmin, ashampane kwisha muin piam pih karara. Piam pihne nardo mun. Usne nardo winmura karara. Winmune alabastro ukkasa sarɨt. Usne winmu kɨz kit Jesús kɨzpura piam pih paranta. ");
INSERT INTO kwi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɨnpazha sun ashampara aliz kulat kit usparuzpain kizara: —An piam pihne pattamtu. Sun pihne kwaiman. ");
INSERT INTO kwi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mazane piam pih paininshina. Kal kimmika añora kal kitne, sunpawa pial kana kimtu. Piam pih painintawane, sunpawa pial puizara mɨlanashina, kizara. Uspane ashampara aliz kularɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesúsne usparuza kaiznara: —Ussa aizapman. Ussa aliz kulaman. Usne nawa watsal kirɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Puizaruzne ukasa pailta payu uzamtu. Puizara wat kishitne, wat kishina. Akkwan payuchikima nane ukasa uzmanash. ");
INSERT INTO kwi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sun ashampane wat kit kit nawa piam pih paranta. Na inapain akwa, usne an ñamin na imtu payura nawa piam pihkasa nɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Watcha kaiznamtus. Wan suras awane an ashampa Jesústa kirɨt aizpa mɨanazi. Dios watsal pit mɨamtuz sun ashampawa mɨakane, uspane ka kaizanazi: “Usne Jesústa kwisha wat kirɨt,” kizanazi. ");
INSERT INTO kwi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Suasne Judasne, Iscariotewa painkulne, Jesúspa doce kammuruzkasa charɨt. Usne katsa pariya ɨnintuza ɨt kit usparuza kaiznara: —Nane umɨza Jesústa annash, ussa pizanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Katsa pariyaruzne Judas kaizta aizpa mɨashit kit ussa kaizara: —Aumɨza kiwainshitne, Jesústa anchain, ussa pizna. Aune nua pial tanapas, kizara. Judasne Jesústa chɨhkan nam kit ka minta: “Nane mamaz payu tɨriznash, Jesústa annana, ussa pizanapa,” minta. ");
INSERT INTO kwi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mane pan kum pishta kasha taiztui. Sun pishtara pan sarane, kiña winkain. Sun Pascua pishtara pɨriku piantam. An payura Jesúspa kammuruzne ussa mɨmaara: —¿Aune mɨnpa ɨanapai, Pascua kumira ainana? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesúsne paas kammuruza ɨninnat kit kaiznara: —Pɨpulura ɨrain. Suane maza ampura, kwazi winmu ultɨt kwaamikasha, wanmalnazi. Ussa kanparain. ");
INSERT INTO kwi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Us yalta napkane, yalpamikasha kaiztain: “Kamtamne paiña pit ɨnin kit ka nua kaiztu: Yal nammɨlazha, ap kammuruzkasa Pascua kumira kuana,” sunkana kiztain. ");
INSERT INTO kwi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Suasne usne umɨza katsa ɨsaltɨt kalmal annanazi. Sun ɨsaltɨt kalmal watsarɨt. ¡Suane kumira sana ɨrain! kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Paas kammuruzne ɨil kit pɨpulura piannailta. Wan Jesús kaizta aizpa wanmalpail kit sua Pascua kumira ainailta. ");
INSERT INTO kwi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɨl parɨmtura Jesúsne doce kammuruzkasa piannat kit ɨsaltɨt kalmal nappara. ");
INSERT INTO kwi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Uspa misharɨkin kuamtuasmin, Jesúsne usparuza kaiznara: —Watcha kiznamtus. Mazane, apa nakasa kumtumikane, nawa kwail awara chɨhkanazi, nawa pizanapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Uspane tayalmɨz kit maza mazain ussa mɨmaara: —¿Na nua kwail awara chɨhkanasa? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesúsne usparuza kaiznara: —Une doce purai. Mazane nakasa kumtumikane nawa kwail awara chɨhkananazi, nawa pizanapa. ");
INSERT INTO kwi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dios pɨnkɨhpa ñamin “Ampu namtɨtmikane inazi” kiz parɨt. Mazane nawa, Ampu namtɨtmikara, kwail awara chɨhkanazi, nawa pizanapa. Diosne ussa ilnazi. Sun kwail ampu kawirarakine, an wat ashina, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kuamtuasmin, Jesúsne pan piz kit kɨz kit Diosta aishtaish kizta. Usne usparuza kwinat kit ka kaiznara: —Anne saptain. An pan sap kumtune, ap ña irɨt nɨjkultain. Katmizna an pan ap ña i, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Suasne usne maza waz vinokasa piz kit Diosta aishtaish kiztawane, usparuza kwinnara. Wan kuara. ");
INSERT INTO kwi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Usne usparuza kaiznara: —An vino sap kumtune, ap aimpi puztɨt mintain. Diosne ap aimpi akwa awaruza watsat mɨlnanara, uspa kwail sɨnam sananapa. ");
INSERT INTO kwi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Watcha kaiznamtus. Apane wankail vinone mamasa kumanash. Chiyura nurawane, nane Dios ɨnintukin mamasa kwanash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kanta kizarawane, uspane ainki ɨzara nuara. Sun ɨzane Olivos mun. ");
INSERT INTO kwi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesúsne usparuza kaiznara: —Ishkuamtu akwa, mɨtsal kiamtu akwa, une nawa chɨhkaanazi. Nawa mainarɨnazi. Ñamin Dios pɨnkɨhta sunkana ka panintɨt: “Pɨriku kwira kimmikasha piantarɨkane, pɨrikuruzne ishkuat kit ɨarɨnazi,” parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nawa mamasa kuhstawane, suasne nane ukin an ñancha Galilea sura ɨnash, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedrone ussa kaizta: —Wan Jesústa pianchish kizaamtukas, nane sun kizmanash. Nane nua kanpanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesúsne ussa sɨnkara: —Watcha kaiznamtus. Ma amtane aral kayu aznazi. Aral kayo pakima aztuchasmin, nune kutña pijikima “Nane Jesústa pianchish,” kiznazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Usne Jesústa kwisha tɨnta kaizta: —Nawa piantashimtukas, nane Jesústa pianchish kaizmanash, kizta. Wantuzne kawarain kaizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesúskas paiña kammuruzkas ɨara tɨ warɨtta, Getsemaní munkin. Usne paiña kammuruza kaiznara: —U apain purasmin, nane anta Diosta paikwan ɨru, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Usne uskasa Pedrorakas Santiagorakas Juantakas minara. Jesúsne kwisha tayal kit kwisha ishkwat kit naizmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Usne usparuza kaiznara: —Na inapain akwa, nane kwisha tayaltus. Apain nukkultain. Izanaka, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Suasne Jesúsne kasha ɨt kit piltakima wainta. Suane Jesúsne Diosta paikwara, naizmanpa, imanpa. ");
INSERT INTO kwi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Suasne kaizta: “Ap Taittane, nune wan kishina, na imanpa. Nane naizshitchish. Nawa kiwaincha. Na pashit aizpa kimun. Nu kishit aizpa kiri,” kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesúsne kutña kammuruz tura kailta. Uspane pittarɨt. Pedrora mɨmara: —¿Simón, pittɨmas? ¿Maza urakima izkulsachikish? ");
INSERT INTO kwi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Izkulat kit Diosta paikwarain, kwail kiamanpa. U wat min kit wat kiashimtukas, une kwaizarɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Suasne mamasa Jesúsne kail kit Diosta paikwat kit sum pitmin kaizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mamasa kutña kammuruz tura kail kit iznara. Uspa kasu pittaara. Uspane Jesústa miza sɨnkana pianchi me. ");
INSERT INTO kwi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kutña pijikima kail kit kutña kammuruza mɨmanara: —¿Pittarɨmanas? ¿Kwaizkularɨmanas? Pailtɨt me. Mane naiztɨnash. Mazane nawa, Ampu namtɨtmikara, kwail kim awaruza chɨhkaanazi, nawa pizanapa. ");
INSERT INTO kwi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kuhsmɨztain. Ɨmarazhain. Nawa kwail kim awaruza chɨhkammikane anpain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Judasne, maza sun doce kammuruztas, Jesús kwinta kimtukin pianara. Akkwan awakas aara tɨ kwicharɨtkasakas tɨkasakas. Katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas Judío ɨlapa ɨnintuzkas usparuza ɨninnarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasne, kwail awaruza chɨhkammikane, usparuza ñamin ka kaiznara: “Mazainta wat kɨntɨre kiz kit matsɨhkin putchunnash. Ussa piz kit mɨltain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kasha atpane, Judasne Jesústa ɨt kit putchun kit kaizta: —Wat kɨntɨre, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Suasne sun awane ussa pizat kit ussa mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Maza sua panatmikane mashti uk kit katsa pariyawa kiwainmumikawa kail yalta. ");
INSERT INTO kwi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesúsne usparuza sɨnkanat kit mɨmanara: —¿Kwisha kwail awara sayamtukiwas? ¿Chikishma nakin tɨ kwicharɨtkasakas tɨkasakas nawa pizamtukiwas? ");
INSERT INTO kwi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pailta payu Dios katsa yalta umɨza kamtanarau. Sua nawa pizamash. Ñamin Dios pit pɨnkɨhta ka panintɨt: “Kwail awane Dios Painkulta pizanazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Suasne wan kammuruzne Jesústa tuij ɨat kit ãĩn ɨara. ");
INSERT INTO kwi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Maza musittune pĩn sayammin kwaat kit Jesús kwizpa kanpara. Mɨnpazha ussa pizshiara. ");
INSERT INTO kwi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sun musittune piltɨm sat kit paiña sayam pĩn tɨwij ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sun awane Jesústa katsa pariyarakima taina ɨara. Suane wan katsa pariyaruzkas Judío ɨlaparuzkas Moisés kaizta aizpa kamtamtuzkas wanmakkarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrone Jesúspa kwizpa kanpat kit katsa pariyawa yal piannamkin ara. Suane uskas suldarukas impuhskin uzat kit i kulara. ");
INSERT INTO kwi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wan katsa pariyaruzkas wan mikwaruzkas Jesúspa kwail kizmumikasha sayara, ussa piantanapa. Uspane mɨnainkas sayarachi. ");
INSERT INTO kwi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Akkwan awa ussa pɨrail kaizarakas, uspane kawara kaizarachi. ");
INSERT INTO kwi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mɨnpazha sua chat kit kunat kit ussa ka pɨrail kaizara: ");
INSERT INTO kwi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Aune ussa kaizka mɨanashɨ: “Awane an Dios yal saara. Awa an sarɨtkas, nane azpian kit kiakpɨnnash. Kutña payura mamaz sanash. Awane sun yal saamanazi,” ka pɨrail kizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sun kwinta kittuzne kawara kizarachi. ");
INSERT INTO kwi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Katsa pariyane paizkakin kun kit Jesústa mɨmara: —¿Sɨnkamankish? ¿Nuwa kaizamtu aizpa mɨmtukish? ¿Watcha nua kaizamtuki? mɨmara. ");
INSERT INTO kwi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Me Jesúsne puñain tuazi. Sɨnkarachi. Pariyane ussa mamasa mɨmara: —¿Nune Cristo kish? ¿Nune au wat Dios Painkul kish? mɨmara. ");
INSERT INTO kwi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesúsne sɨnkara: —Nane Cristo ish. Une nawa, Ampu namtɨtmikara, izanazi. Nane au katsa Diospa numal tuanash. Suane nane Dioskasa wattuza ɨninnanash. Na chiyuras kailkane, une nawa wanishta izanazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Suasne katsa pariyane pilchapuz kit paiña pĩn pihshara, aliz kularɨt akwa. Suasne usne kaizta: —Mamaz izmumikasha saishitchimakpas. ");
INSERT INTO kwi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Une us Diosta kwail pararɨt aizpa mɨara. ¿Ussa chima kianapai? kiznara. Wanne nɨjkulat kit kaizara: —Ussa piantarawa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mɨnpazha ussa ilpi kiamɨzta. Paiña kasu palpiz kit ussa aim kuzara. Suasne ussa kaizara: —Mane nune izsachi. ¿Mɨnma nua kuzzi? Kainazhain, kizara. Suldaruruzkas paiña matsɨhta kuzara. ");
INSERT INTO kwi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedrone yal pianamal tuazi. Pariyawa kiwainmikane sua ara. ");
INSERT INTO kwi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Usne Pedro impuhskin ikultuas izta. Kiwainmikane ussa iz kit kaizta: —Nukas Jesúskasa, Nazaret pɨpuluras awakasa, chara, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrone ussa kaizta: —Jesústa pianchish. Nu kwinta kit aizpa we pianish, kizta. Pedrone piannamkis puzta. Suasne aral kayu azta. ");
INSERT INTO kwi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kiwainmumikane Pedrora mamasa izta. Usne awa kasha puraruza kaiznara: —Sun ampune Jesúspa kammumika i, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrone mamasa kaizta: —Jesústa pianchish, kizta. Ɨrattura mamazne Pedrora mamasa kaizta: —Watcha. Nune uspakasa cha. Nune Galilea awa i. Nune Galilea suras awakana paramtu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Suasne Pedrone mamasa pɨrail apmɨz kit kaizta: —Watcha kaiztukine, Diosne nawa naiznintawa. Sun ampura pianchish, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sun urain aral kayu mamasa azta. Aral kayu azkane, Pedrone Jesús ussa kwinta kit aizpa nɨjkulta. Jesúsne ñamin ka kaizta: “Aral kayu pakima aztuchasmin, nune ‘Jesústa pianchish’ kiznazi,” kizta. Suasne Pedrone tɨnta azmɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɨnmɨzkane, katsa pariyaruzkas Judío ɨlapa ampuruzkas Moisés kaizta aizpa kamtamtuzkas Judío awara ɨnintuzkas wanmakkat kit usparuzpain kwinta kiara. Uspane Jesústa kuhat kit Pilato mikwara karaara. ");
INSERT INTO kwi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatone ussa mɨmara: —¿Nune Judío awawa mikwa kish? kizta. Jesúsne ussa sɨnkara: —Nu kaiztu aizpa watcha i, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Katsa pariyaruz Jesús akkwan kwail kirɨt kizarɨtkas, Jesúsne puñain parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Katmizna Pilatone ussa mamasa mɨmara: —¿Sɨnkashichikish? Mɨri. Uspane nua akkwan kwail kirɨt kizamtu, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesúsne Pilatora chinkas sɨnkarachi. Katmizna Pilatone wat iztasparɨt. ");
INSERT INTO kwi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pascua pishta iztuasmin, Pilatone maza kajchira sɨptɨtmikasha chɨhtmu azi. Pilatone awa paikuamtumikasha kajchira chɨhtmu azi. ");
INSERT INTO kwi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Maza ampune, Barrabásne, kajchira sɨptɨt wara. Uskas an akkwankas sɨptɨt waara, uspa gobierno awakasa waya kit kit awara piantaarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akkwan awane wanmakkat kit Pilatora kaizamɨzta: —An Pascua pishtarakas maza kajchira sɨptɨtmikasha chɨhti, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatone usparuza sɨnkanat kit mɨmanara: —¿Na Judío awa mikwasha chɨhshinaki? kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatone katsa pariyaruz minñarɨt aizpa pian. Wan awane Jesústa pashiarɨt akwa, katsa pariyaruzne Jesústa aliz kulat kit Jesústa pizashira. ");
INSERT INTO kwi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Katsa pariyaruzne awara wanmakninnat kit pilchapuzninnat kit kaiznara: —Jesústane pashitchimakpas. Barrabásta chɨhtninti, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatone usparuza mamasa sɨnkanat kit mɨmanara: —¿An ampukasa chima kinpai? Une “Jesús Judío awara mikwa i” kizamtu, kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Suasne uspane tɨnta kwianara: —Ussa kurishta iru patpian kit piantarawa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatone usparuza mɨmanara: —¿Chikiztama sun kizamtu? ¿Usne chi kwail kirɨt? kiznara. Uspane an akkwan kwianat kit kaizara: —Ussa kurishta iru patpian kit piantarawa, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Katmizna Pilatone Barrabásta chɨhtninta, wan awa puñain puranpa. Jesústa tɨtkasa iltawane, Pilatone ussa chɨhtninta, suldaru kurishta iru patpian kit piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Suldaruruzne ussa Roma mikwawa yaltakima taintawara karaara. An katsa yalne Pretorio muntɨt. Suane uspane wan suldaruruza wanmakninñara. ");
INSERT INTO kwi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Uspane Jesústa ishtam kwakshamkasa kwaaninñara. Uspane pu tɨt ippat kit paiña kɨzpu ɨsalta sɨnaara. ");
INSERT INTO kwi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Uspane ussa ishanat kit ka kaizamɨzta: —Judío awa mikwa, wat uznaka, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Uspane ussa tɨwilkasa kɨzpukin piannara. Uspane ussa ilpikas kiara. Uspane ussa ishanat kit wakpuj wainñara. ");
INSERT INTO kwi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ussa ishanarawane, ishtam kwaksham uknin kit paiña pĩn ussa kwaninaara. Uspane ussa tainñara, kurishta iru patpian kit piantanapa. ");
INSERT INTO kwi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Uspane Jesústa miwara tainñamɨzta. Suane Simónne miwara pɨnmɨzta. Cirene suras arɨt. Nantas arɨt. Simónne Alejandrowa papihsh azi. Usne Rufowa papihsh azi. Suldaruruzne Simónta kaizara: —Jesúspa kurish muri, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Uspane Jesústa ainki ɨzarakima miara. Ainki ɨzane Gólgota mun. (Mamaz pitkasa “kɨzpu sɨh” muntɨt.) ");
INSERT INTO kwi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mamazne ussa vino pihkasa kwinta. Sun pihne mirra mun. Usne kwashitchi. ");
INSERT INTO kwi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Uspane ussa kurishta iru patpianara. Suldaruruzne ainki ukkasa salara, paiña kwaksham kana kinpa. Paiña pĩn usparuzpain naiyara. ");
INSERT INTO kwi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nueve urara ussa kurishta iru patpian kit piantara, inapa. ");
INSERT INTO kwi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Uspane tapɨlara sun pit ka paara: JUDÍO AWAWA MIKWA wan awa izanapa. Sun akwa uspane ussa piantaara. ");
INSERT INTO kwi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Suldaruruzne paas walkumkas kurishkin iru patpian kit piantaara. Mazane Jesúspa numal patpianara. Mazane Jesúspa kwiyamal patpianara. ");
INSERT INTO kwi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ñamin Dios pɨnkɨhta ka panintɨt: “Jesúsne kwail awakasa inazi,” parɨt. ");
INSERT INTO kwi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Awa pɨnmuruzne ussa ishanat kit kɨzpu kialat kit kwail kizara: —Nune katsa Dios yal azpian kit kiakpɨnnash. Azpiantawane, nune kutña payurakima mamaz yal sanash. ");
INSERT INTO kwi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Nuin sun kurishtas kihshti! uzna, ishanat kit kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas usparuzpain ishanat kit kaizara: —Us mamaztuza uzninnarakas, usmin uzninsachi. ");
INSERT INTO kwi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristone, Judío awawa mikwane, sun kurishtas kihshshina. Nu Cristo kane, kihshti, au izanapa. Kurishtas kihshtane, aune nua nɨjkulanapas, kizara. Kurishta iru patpianmuruzkas ussa kwail kizpailta. ");
INSERT INTO kwi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Paizka payukis kutña urakima pailta sura tɨlkwil pamɨzta. ");
INSERT INTO kwi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kutña urara Jesúsne Judío pitkasa ka tɨnta kwianta: “Eloi, Eloi, ¿lema sabactani?” kizta. (Awa pitkasa ka kiztu: “Ap Dios, Ap Dios, ¿Chikiztama nawa kwaias?” kizta.) ");
INSERT INTO kwi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mɨnpazha kasha panaruzne sun mɨat kit kaizara: —Mɨrain. Elíasta, Dios kainammmikasha, akwantu, kizara. ");
INSERT INTO kwi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mazane chihtɨ punta pimpuh karat. Usne vino tain pimpuhta paranta. Usne pimpuhta aks tɨra tat kit ussa kwinta, vino tuk kwanpa. Ussa kwintawane, usne ussa tuij ɨt kit ka kaizta: —Ussa izwizsan. ¿Elíasne Jesústa kurishtas kihshninnasa? kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Suasne Jesúsne tɨnta kwian kit ira. ");
INSERT INTO kwi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dios yalta nain pĩn kintɨt kwashtas pihsharɨt. ");
INSERT INTO kwi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Suldarune, Romano ɨninmikane, Jesústa izak kunta. Jesús irɨka iztawane, ka kaizta: —Watcha. An ampune Dios Painkul i, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mazantuz ashampakas attishtas aara. Magdalena pɨpuluras Maríakas tuazi. Salomékas tuazi. Mamaz Maríakas tuazi. Usne paas painkul mɨlta. Santiagone an ainkinmika i. Joséne an ɨlapamika i. ");
INSERT INTO kwi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea suwara chaasmin, sun ashamparuzne ussa kanpaat kit kiwainñara. An akkwan awakas Jesúskasa Jerusalén pɨpulura aara. ");
INSERT INTO kwi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesúsne viernes nashka irɨt. Viernes payura sun Judío awane kumira ainamɨzmu, sábado payu ainamanpa. ");
INSERT INTO kwi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Pãn pianaptɨkane, Joséne, Arimatea suras, ara. Uskas Judío awa katsa mikwa azi. Uskas Dios ɨnintu payura tɨriztuazi. Us ishkumtuchi akwa, usne Pilatora ɨt kit kaizta: —Jesústa kamshimtus, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatone iztaspat kit ka minta: —¿Me irɨtki? kish mɨmara. Usne suldaru ɨninmikasha ɨnin kit kaizta: —¿Jesúsne me irɨtki? mɨmara. ");
INSERT INTO kwi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Suldaru ɨninmikane Pilatora kaizta: —Ire, kizta. Suasne Pilatone Jesústa chɨhkat kit Joséra kaizta: —Nune ussa kamnaka, kizta. ");
INSERT INTO kwi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joséne ñamin watsal pĩn paira. Jesústa kurishtas kihshnintawane, pĩn ussa ampal tara. Tas uk kulta nukta. Uk kulne ñamin sarɨt. Tas usne katsa uk pɨjtakin nuppain kit sɨpta. ");
INSERT INTO kwi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maríakas Magdalena pɨpuluras, mamaz Maríakas Joséwa akkuhshkas us nuktukin izpailta. ");
INSERT INTO kwi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado kwaizkultu payu pailtawane, Maríakas Magdalena pɨpuluras, Salomékas mamaz Maríakas, Santiagowa akkuhsh, piam pih pait karaara, Jesústa piam pihkasa nɨttana. ");
INSERT INTO kwi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo payura tɨlawain pãn malmɨzkane, uspane kamkin ɨara. ");
INSERT INTO kwi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Uspane usparuzpain mɨmaara: —¿Uk kulkis mɨnma tainkulansa? kizara. ");
INSERT INTO kwi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Uk kulta izarawane, uspane ukta paimpa izara. Sun katsa ukta kulkis tainkularɨt izara. Nakuhsarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kulta napparawane, uspane ángelta, musittukana, izara. Usne putchã kwaksham kwaa. Numarain uzta. Uspane ishkuara. ");
INSERT INTO kwi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Usne usparuza kaiznara: —Ishkuman. Une Jesústa Nazaret pɨpuluras sayamtu. Une kurish patpian kit piantarɨtmikasha sayamtu. Usne kuhsat kit uztu. Apane tuchi. ¡Us tuatkin iztain! ");
INSERT INTO kwi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Paiña kammuruzakas Pedrorakas ɨat kit ka kaizanaka: “Jesúsne Galilea sura nukin an ñancha ɨrɨmtu. Tane une ussa izanazi. Us kaiztakanain umɨza kaiznamtus,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sun ashamparuzne ulat kit ishkuat kit uk kultas puzat kit ɨara. Katmizna mɨnainkas chinkas kaizarachi. ");
INSERT INTO kwi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tɨlawain, domingo payura, Diosne Jesústa kultas salakninta, mamasa uznapa. Suasne, Jesúsne an ñancha mamazta, Magdalena suras Maríara, izpanta. Ñamin Jesúsne ussa siete kwail saliztuza puzninta. ");
INSERT INTO kwi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maríane Jesúspa izmuruza ɨt kit usparuza Jesús uztu kiznara. Jesús irɨt akwa, uspane kwisha tayalat kit azarɨt. ");
INSERT INTO kwi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Usne usparuza kaiznara: —Jesúsne uztui. Nane ussa iztau, kiznara. Uspane ussa nɨjkulashitchi. ");
INSERT INTO kwi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mamaz payura paas kammuruzne nanta ɨmɨzpailta. Jesúsne usparuza kasha ara, uspakasa chan. Usne ñan iztɨt. ");
INSERT INTO kwi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Uspa paasne anpa kammuruza kail kit kaizpailta: —Aune ussa iztamakpas, kiznara. Uspakas nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mamaz payura once kammuruzne uzat kit kumira kuara. Suane Jesúsne usparuza ɨra, ussa izanapa. Dios watcha Jesústa mamasa kuhsnintɨtkas, uspane izara aizpa nɨjkulashitchi. Uspa Dios Jesústa mamasa kuhsnintɨt aizpa nɨjkulashitchi akwa, Jesúsne usparuza tɨnta pilchashinara. ");
INSERT INTO kwi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Suasne Jesúsne usparuza kaiznara: “Wan suwara ɨrain. Pailta awaruza Dios watsal pit kainarain. ");
INSERT INTO kwi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","U Dios watsal pit nɨjkulturuza munnanarane, Diosne usparuza watsat mɨlnanazi. Dios watsal pit nɨjkultuchiruzne, paiña kwail akwa ĩnta naizarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dios pit nɨjkultuzne, Jesústa paikumtuzne, kwail saliz puzninnanazi. Uspane mamaz pit paraanazi. Sunkanane Diosne usparuza kiwainanazi, awa Diosta piankamnanapa. ");
INSERT INTO kwi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kamta pizarane, usparuza kuamanazi, tañu kiamanpa. Pininu kwatne, usparuza kwail kiamanazi. Uspane ishtumikasha Diosta paikuat kit uspa chihtɨkasa paanazi. Sunkanane uspane wat paarɨnazi,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Suasne Jesús, au Anpat, paiña kammuruza kwinta kinarawane, Diosne Jesústa chiyura nuninta. Suane Jesúsne Dios numal uz kit Dioskasa ɨninnamtu. ");
INSERT INTO kwi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Paiña kammuruzne ɨat kit pailta suwara Dios pit kainanara. Jesúsne, au Anpatne, usparuza kiwainnara, ishturuza wat paninnapa, an watsal iztasparɨt kal kianapa. Katmizna akkwan awane Jesúspa mɨarɨt aizpa Jesústa nɨjkulara. Pailti.");
INSERT INTO kwi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Watcha i. Akkwan awane sun kwinta kirɨt aizpa awaruzpain pɨnkɨh pashiara. ");
INSERT INTO kwi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chiwazha kirɨt aizpa izmuruzne, Dios pit kammuruzne, an ñamin sun kwinta aumɨza kamtanarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","An ñamin wan pɨnkɨh Jesúspa parɨt aizpa iztau. Makima na sun kwinta watsal kamtɨt akwa, nakas nua, Teófilora, pɨnkɨh pashimtus. Na nua pashimtu akwa, nane impara imparain wan sun kirɨt aizpa pamtus, ");
INSERT INTO kwi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nua wan kamtarɨt aizpa wat piankamnapa. ");
INSERT INTO kwi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes, Judío awaruzpa mikwa, Judea sukin uzasmin, maza pariyane, Zacarías muntɨtmikane, uzta. Paiña ira pampa Abíasne pariya aramin. Paiña ashampane Isabel mun. Paiña ira pampa Aarónne pariya aramin. ");
INSERT INTO kwi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Uspa paasne Dios iztakin wat uzpait kit wan Dios ɨninta aizpa mɨilta. Mɨnminkas uspa paasta kwail kirɨt kizarachi. ");
INSERT INTO kwi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Uspane pashpa mɨjchiara, Isabel pashpa mɨlsachi akwa. Usne ɨlapa azi; ashampakas ɨnkwa azi. ");
INSERT INTO kwi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Maza payune usne paiña pariya kwalkasa Dios yalta kiwaina ɨrɨt. Ussa narawane, Zacaríasne Dios yal ayukmal napta, wat piam incienso paktana. ");
INSERT INTO kwi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Us ayukmal wat piam incienso paktamtuasmin, wan awane pianamal Diosta paikuara. ");
INSERT INTO kwi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Suane Diospa ángelne Zacarías tukin kun kit ussa izpanta. Usne wat piam incienso paktamtukin, numal misharɨkin kunta. ");
INSERT INTO kwi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ángelta iztawane, Zacaríasne iztaspat kit kun kirɨt. Chinkas kisachi. Ishkwarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ángelne ussa kaizta: —Zacarías, an ishkumun, Dios nu paikwat aizpa mɨra akwa. Up ashampane, Isabelne, ampu pashpa mɨlnazi. Nune ussa Juan munnazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nune kwisha wat kultɨnazi. Us kawira akwa, akkwan awane wat kularɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Usne Dios iztakin tɨnta namnazi. Chappikas chappi tainkas kumanazi. Diospa Sɨnam Izpulne pashpara piznazi, mɨltachasmin. ");
INSERT INTO kwi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Usne Judío awaruza akwananazi, uspa Anpatta, uspa Diosta, kaiyanapa. ");
INSERT INTO kwi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Diospa ɨnintamika amtuchasmin, an Juanne ussa an ñancha ɨnazi, wan watsanpa. Usne an ñancha Elías uzmikakanain uznazi. Dios Sɨnam Izpulne ussa kiwainazi, Diospa tɨnta paranpa. Usne papihshtuza ka kurunnanazi: “Up pashparuza paashirain. Usne kwail awaruza maizninnanazi, wat awakana uzanapa. Suasne awa sunkana kiat kit kamarane, awane Diospa ɨnintamikasha mɨat kit sappanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacaríasne ángelta mɨmara: —¿Mizama ap ashampa pashpa mɨlshina? Nane ɨlapa ish. Ap ashampakas ɨnkwa i, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángelne ussa sɨnkara: —Nane Gabriel munish. Nane Dios uzkin kunish. Usne nawa nua kwinta kininpa ɨninchish, nu sun watsal pit mɨnapa. ");
INSERT INTO kwi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mane mɨri. Nu na kaizta aizpa nɨjkultachi akwa, nune paramanazi, up painkul kawinakima. Nueve mish pailka, sun kirɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sun kimtuasmin, awane pianamal kunat kit Zacaríasta tɨrizara. Uspane usparuzpain minñara: “¿Chitma katne Dios yal ayukta tɨriztu arau? ¿Chitma puzmas?” ");
INSERT INTO kwi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías puztawane, usparuza paramanamta. Suasne uspane Zacarías chiwazha Diospa yal ayukmal izta nɨjkulara. Awaruza paiña chihtɨkasa annamtuasmin, usne puñain para. Ussa kirɨt aizpa parasachi. ");
INSERT INTO kwi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Paiña kal Diospa yalta pailtawane, Zacaríasne paiña yalta kailta. ");
INSERT INTO kwi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mamaz payura paiña ashampane, Isabelne, pɨja warɨt. Cinco mishtakima yalkimin uz kit ka minta: ");
INSERT INTO kwi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ap Anpatne sun payura nawa kiwainzish, pɨja wana. Mane nane awa iztakin mɨtsal chiish.” ");
INSERT INTO kwi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel pɨja warawane, seis mish pailtɨka, Diosne ángel Gabrielta Galilea sura, Nazaret pɨpulura, ɨninta, ");
INSERT INTO kwi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","maza nimpihsh ashampara kwinta kinpa. Usne María munta. Mama ampukasa pittachi. Usne maza ampura kasara kin namtɨt azi. Sun ampune José munta. Paiña ira pampa Davidne mikwa arakwain. ");
INSERT INTO kwi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángelne María tukin nap kit kaizta: —Kakishapu. Diosne nua wat kit kit kiwainshimtu. Anpatne nua pashit kit nukasa ɨmtu, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ángelta iztane, Maríane ishkwat kit ángel kaiztu aizpa minta. “¿Usne chikishma sun nawa kwinta kimtu?” minta. ");
INSERT INTO kwi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Suasne ángelne ussa kaizta: —María. Ishkumun. Diosne nua wat kit kit kiwainshimtu. ");
INSERT INTO kwi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mɨri. Mane nune pɨjakasa anpai. Painkul mɨjanpai. Ussa Jesús munnaka. ");
INSERT INTO kwi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Usne tɨnta namnazi, chiyuras amtu akwa. Usne chiyuras Dios Painkul munnazi. Anpat Diosne ussa Davidkin anza katsa mikwakana namnazi, Davidkanain ɨninapa. ");
INSERT INTO kwi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Usne pailta payukima Israelpa kwalta ɨninnanazi. Paiña ɨnintu aizpa pailmanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Suasne Maríane ángelta mɨmara: —Ampu mɨjkine, ¿mizama painkul mɨlnapai? kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángelne ussa sɨnkara: —Diosne Sɨnam Izpul akwa nu tukin anazi. Katsa Diosne nua tɨnta kiwainazi, pashpa pɨja wanapa. Katmizna up kawintu pashpane Dios pashimtu aizpa kinazi. Dios Painkulkas munnazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na nua kaiztu aizpa mɨri. Up kwal, Isabelne, ɨnkwa i. Wan awane ussa “Pashpa wasachi,” kizara. Maneme usne seis mish pɨja warɨt tu. ");
INSERT INTO kwi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diosne chikas wantain kishinai. ");
INSERT INTO kwi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Suasne Maríane ussa sɨnkara: —Nane ap Anpatpa kiwainmumika ish. Watcha, nune nawa kaizta aizpa sari, kizta. Suasne ángelne ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sun payune Maríane wan watsat kit maza pɨpulukin Judea ɨnkal sura azain ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacaríaspa yalta nap kit Isabelta kaizta: “Manta kail ish,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel Maríawa pit mɨrane, paiña pashpa pɨjakin kialta. Suasne Dios Sɨnam Izpulne Isabelta pizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Suasne usne tɨnta kaizta: —Diosne wan ashampakin nua anza watsal kiwainnazi. Diosne nu mɨltu pashpara wat kiwainazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ap Anpatpa akkuhsh nawa kwinta kin at akwa, kwisha wat kultus. ");
INSERT INTO kwi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mɨri. Nu nawa kakishapu kiztawane, ap painkulne pɨjara tɨnta kialta. Usne watsal kultuazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ap Anpatne nua kin namtɨt aizpa kinazi. Nune wat kulnazi, us kin namtɨt aizpa nɨjkulta akwa, kaizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Suasne Maríane min kit paiña kaijchuras kaizta: “Ap Anpat katsa i. ");
INSERT INTO kwi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ap Diosne, ap watsat mɨlmumikane, kwisha wat i, nawa kwisha wat mintɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Usne nawa, paiña kiwainmumikasha, kiwainshira. Makis wan awane nawa kaizanazi: Diosne ussa wat ashampa namninta. ");
INSERT INTO kwi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ap katsa Diosne na akwa akkwan kirɨt. Usne sɨnammika muntɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Usne wan Diosta wat minturuzakas Diosta wakpuj wainamtuzakas iznat kit kiwainanazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Usne katsa kal sara. Diosne anza katsa mintuza an ainkinkanain namninnara, uspa minñara aizpa kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Usne katsa mikwaruza uspa ɨninmukis taizninnanazi. Usne kiwaintuza watsat mɨlnara. ");
INSERT INTO kwi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Usne chiwazha we mɨjtuza wan mɨlanara. Usne kwazpa awaruza kɨlmin ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Usne paiña Judío kwaltuza, paiña kiwaintuza, pailta payurakima kiwainnara. ");
INSERT INTO kwi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sunkanain usne au an ñancha ira kwaltakas Abrahamtakas Abrahampa kwizta kwal uzamturuzakas kin namnara.” ");
INSERT INTO kwi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Isabelkasa kutña mish uztawane, Maríane papihshpa yalta kailta. ");
INSERT INTO kwi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sunpawa payu pailtɨkane, ishtu kirɨkane, Isabelne paiña painkul nishta. ");
INSERT INTO kwi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dios ussa wat kirɨt aizpa mɨarawane, kasha izmuruzkas kwaltuzkas kaizara: “Au Anpatne nu wat kirɨt. Uspane uskasa wat kularɨt.” ");
INSERT INTO kwi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho payu pailtawane, uspane ampu pashpara muara, pashpa aya tɨtnapa, circuncisión kinpa, Judío awaruza ɨnintɨt aizpa kinpa. Uspane kaizara: “Usne Zacarías papihshkanain munnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Paiña akkuhshne kaizta: —Zacarías munnachi. Juan munnazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Uspane ussa sɨnkaara: —Up kwalne sun mun mɨjchi, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Suasne papihshta saiaat kit mɨmaara, ¿Miza munashinasa, awa piankamanapa? ");
INSERT INTO kwi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Usne pɨnkɨh paikwat kit para: “Usne Juan mun i.” Wan awane iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sun urain Zacaríasne paiña pit ɨsak kit paiña yankwija chɨhkul kit kaizta: —Diosne kwisha wari, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Suasne wan kasha izturuzne iztaspaarɨt. Wan awane Judea ɨnkal sura sun kirɨt aizpa wantuza kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sun kwinta mɨmturuzne usparuzpain mɨmaara: “Sun pashpane ¿Chima kinazi?” kizara. Dios ussa kiwainshimtu akwa, Diosne an pashpara an tɨnta namnazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacaríasne, pashpawa papihshne, Dioskasa paramtu uzta. Dios Sɨnam Izpulne ussa piz kit kiwainmɨzta. Zacaríasne Dios akwa parat kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Judío awawa Diosne, au Anpatne, kwisha wari. Usne apain at kit paiña kwaltuza watsat mɨlnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Usne tɨnta watsat mɨltamikasha ɨninta. Sun kiwainmikane ñamin pampa Davidpa kwal i. ");
INSERT INTO kwi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","An ñamin Diosne paiña kainammtuz akwa sun pit kin nam kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Usne aumɨza watsat mɨlnashina, aliz awa aumɨza anuppamanpa, aumɨza aliz kulamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Diosne sunkas kaizta: au ira kwaltuza nanat kit kiwainanash. Uruza kin namtɨt aizpa mainmanash. ");
INSERT INTO kwi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sun pitmin au papihshta, Abrahamta, sunkana tɨnta kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Usne aumɨza watsat mɨlnanazi, waya kimtuz aumɨza chinkas kiamanpa. Usne aumɨza paiña kiwainmu namninnanazi, paiña kal kianapa, ishkwatchin. ");
INSERT INTO kwi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dios iztakin uzamtuasmin, aune pailta payukima us wat kuruntu aizpa kiat kit Diosta wakpuj waintamakpas. ");
INSERT INTO kwi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mane nua, ap painkul pashpara paranash. Nune chiyuras kainammmika munnazi. Nukas up Anpatpa miwara an ñancha ɨnazi, paiña mi watsanapa. ");
INSERT INTO kwi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nukas Dios paiña kwaltuza watsat mɨlnana piankamninnanazi. Uspa kwail kiarɨt aizpa wat kulna piankamninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios aumɨza pashinamtu akwa, usne aumɨza kiwain kit chiyuras amtumikasha ɨninnazi. Suasne wan awane ussa piankamashina. ");
INSERT INTO kwi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Paiña ɨnintumika akwa Diosne kwail kim uzturuzakas, irɨn ishkumtuzakas, watsat mɨlnanazi. Usne aumɨza wat miwara ɨninanazi, kalpain uzanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","An katsa kawimtuasmin, pashpane pailta payukima Diosta an pashimɨzta. Wan kawirawane, usne pul sura ɨt kit uzta, Judío awaruz ussa piankamnakima. Kwiztane uspane us kaizta aizpa mɨara. ");
INSERT INTO kwi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sunkana kirɨt. Katsa mikwa Augustone paiña pit wan sura ɨninnara, wan awara wiannanapa. ");
INSERT INTO kwi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma wiana masamtuasmin, ainki mikwa Cirenione, Siria sura ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Katmizna wan awane uspa kwalpa pɨpulura ɨara, wiantɨt puranpa. ");
INSERT INTO kwi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Suasne Joséne Galilea suras Nazaret pɨpuluras ɨt kit Judea sura nura, Belén pɨpulurakima. Katsa mikwa Davidne ñamin sua kawira. Joséne Davidpa kwal azi. ");
INSERT INTO kwi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Usne kanpa ashampakasa nuilta, wiantɨt puranpa. Maríane Josékasa kasara kin namtɨtkas, usne me pɨja warɨt. ");
INSERT INTO kwi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Uspa paas Belén pɨpulura tuasmin, Maríane ishtu kinpain pamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Suane usne an ñancha painkul pashpa mɨt kit pĩnkasa ipkanat kit punkira winta. Mamaz yal nanchi akwa, usne wakara ɨranchura ɨt kit pashpara punkira winta. ");
INSERT INTO kwi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sun surane pɨriku izmuruzne pɨt saukin pɨrikura izara. Kɨnsɨh uzkɨnnara. ");
INSERT INTO kwi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Suasne Anpatpa ángelne azain at kit uspa paizkakin kun kit usparuza izpannara. Anpatne uspa uzkin kai malninta. Suas uspane kwisha ishkuara. ");
INSERT INTO kwi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ángelne usparuza kaiznara: “Ishkuman. Nane umɨza watsal pit kainananamtus, wan awa kwisha wat kulanapa. ");
INSERT INTO kwi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨrain. Ma payu watsat mɨlmumikane Davidpa pɨpulura nishta. Sun Anpatne Dios nɨrɨtmika i. ");
INSERT INTO kwi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ussa sayamtuasmin, une u izta aizpa piankamtain. Sunkanane sun pashpane pĩnkasa kanat kit punkira izakpara tuanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sun urain an ángelkas an akkwan ángelkasa chiyuras Diosta ka kaizara: ");
INSERT INTO kwi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Diosne kwisha wari. Chiyuras Diosne katsa i. Usne awaruza kiwainanazi, kalpain uzanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ángel usparuzkis ɨarawane, chiyumarain kaiyarawane, sun pɨriku izmuruzne usparuzpain kaizara: —Belén pɨpulura ɨzhain, chiwazha kirɨt aizpa izna. Anpat aumɨza kaiznarɨt aizpa piankamna ɨzhain. ");
INSERT INTO kwi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Uspane azain ɨat kit Maríarakas Josérakas pashparakas sayat kit wanmalnara. Wanmaltawane, uspane pashpara punkira izakpara tu izara. ");
INSERT INTO kwi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pashpara izarawane, uspane ángel usparuza kaiznara aizpa Jesúspa papihshtuzakas wan awaruzakas kainanara. ");
INSERT INTO kwi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wan pɨriku izmuruz kaizara aizpa mɨraruzne iztaspaarɨt, watsat mɨlmumikawa paarat akwa. ");
INSERT INTO kwi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríane wan mɨntu aizpa ayuk kaijchura watsat kit sunpa minta. ");
INSERT INTO kwi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pɨriku izmuruzne kaiyat kit kaizara: —Au chiyuras Diosne kwisha wari, kizara. Chiwazha mɨra aizpakas izta aizpakas sunkanain kirɨt. ");
INSERT INTO kwi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho payu pailtawane, ampu pashpa aya tɨttawane, circuncisión kitpane, uspane ussa Jesús munnara. An ñancha María pɨjara wachasmin, ángelne sun mun ussa munta. ");
INSERT INTO kwi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pashpa kawirawane, Josékas Maríakas Moisés kaizta aizpa kiara, uspa sɨnam puranpa. Suas uspane pashpara Jerusalén pɨpulura mɨlarɨt, Taitta Diosta anna. ");
INSERT INTO kwi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sunkana Anpatne ɨnin kit para: “Wan an ñancha ampu mɨltamikasha Anpatta chɨhkatpa. Diosne us akwa ussa paimpa akumtu,” ka parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Anpatne sunkana awaruza ɨnin kit ka para: “Paas munkul mɨlna mɨjchine, awane paas pashpa utkuru piantana mɨltawa. Paas pashpa utkuru mɨjchine, awane paas munkul piantana mɨltawa, ka parɨt. Katmizna Josékas Maríakas paas chitchu Diosta mɨlta, Moisés ɨnintɨt aizpa kinpa.” ");
INSERT INTO kwi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mane mɨri. Maza ampune, Simeón munmikane, Jerusalén pɨpulura uzta. Usne nil uz kit Diosta paikwara. Usne Dios nɨrɨtmika amtu payu tɨrizta, us Israel awaruza kiwainnanakima. Diospa Sɨnam Izpulne ussa piz kit ");
INSERT INTO kwi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","sunpa ussa piankamninta. Ussa kaizta: “Irachasmin, nune Cristora, Anpat ɨnintumikasha, iztɨnazi,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Diospa Izpulne Simeónta Diospa yalta ɨninta. Kwiztane, Jesúspa papihshkas akkuhshkas Jesústa Simeón tukin karailta. Uspane Moisés ɨninta aizpa kishiailta. ");
INSERT INTO kwi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónne ussa sap kit mut kit “Diosne kwisha wari,” kiz kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ap Anpatne, nune nawa kin namta aizpa kirɨt. Mane nane, up kiwainmumikane, kalpain irɨnash, ");
INSERT INTO kwi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","na ap kasukasain up watsat mɨlmumikasha iztɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nune ussa watsarɨt mɨj, wan awa ussa izanapa. ");
INSERT INTO kwi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Usne Judío awachiruza kiwainnanazi, Diosta piankamanapa. Israel awaruzne us akwa wat kulanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josékas Jesúspa akkuhshkas Simeón pashpawa kaizta aizpa kwisha iztaspailta. ");
INSERT INTO kwi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Suasne Simeónne usparuza kaiznara: “Diosne uruza me wat kirɨt,” kiznara. Suasne usne Maríara, Jesúspa akkuhshta kaizta: “Izti. Sun pashpane Dios nɨramika i. Us kaizta aizpa mɨamtuchi akwa, akkwan Israel awaruzne wan kaarɨnazi. Usne mamaztuza, us kaizta aizpa mɨmturuza, watsat mɨlnanazi. Akkwan awane ussa nɨjkulamanazi. Ussa kwail paraanazi. ");
INSERT INTO kwi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jesús usparuza kurunnakane, akkwan awane uspa kaijchukin Jesúspa minñamtu aizpa nɨjkulanazi. Une ayukmarain kwisha naizanazi, tɨ kwiz kaijchukin pamtukanain,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Suane maza ashampane, Dios pit kainammmikane, tuazi. Ana munta. Usne Fanuelpa pashu azi. Aserpa kwal azi. Mane usne kwisha ɨnkwa azi. Nimpihshasmin kasara kirɨt. Siete año paiña ampukasa uztawane, Aserpa ampune irɨt. ");
INSERT INTO kwi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ochenta año amparakasa mazainpain Diospa yalta kashara uzta. Sua payuwarakas amtawarakas Anpatta kiwainmɨz kit Diosta wakpuj wainmɨzta. Diosta paikumtuasmin, usne pala kwatchi. ");
INSERT INTO kwi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sun urain Anane uspa tukin at kit Diosta aishtaish kiz kit wan awaruza Jesúspa kainanara. Uspane Diospa nɨrɨtmikasha tɨrizat kit sayara, wan Israel awaruza watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Suasne Josékas Maríakas Dios ɨninta aizpa kiarawane, uspane Galilea sura usparuzpa pɨpulura, Nazaret pɨpulura, kaiyamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sun pashpane kawit kit an tɨnta namtɨt. Kwisha wat pianmika nammɨzta. Diosne ussa kwisha kiwainta. ");
INSERT INTO kwi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mane paiña papihshkas paiña akkuhshkas año aizpa Jerusalén pɨpulura ɨilta, Pascua pishta izna. ");
INSERT INTO kwi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","43","Jesús doce año pɨntɨkane, cham pishta taizkane, kutñaruzne Jerusalén pɨpulura nuara. Pishta pailtawane, kailpailta. Pashpa Jesúsne Jerusalén pɨpulurain nukkultɨt. Paiña kwalne Jesús nukkultɨt pianchi. ");
INSERT INTO kwi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Uspane maza payus ɨara. Uskasa mamaz awakasa aamtuka minpailta. Uspa kwaltuzakas izmuruzakas sayara. ");
INSERT INTO kwi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ussa wanmaltachi akwa, Jerusalén pɨpulura ussa saina kailpailta. ");
INSERT INTO kwi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kutña payu taiztawane, ussa Diospa yalta wanmalpailta. Usne kamtam purakin tuazi. Uspa kamtɨt aizpa mɨt kit usparuza mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Us akkwan pian akwa, us usparuza sɨnkanarɨt akwa, wan mɨraruzne us akwa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Paiña papihshkas akkuhshkas ussa iztawane, iztaspailta. Paiña akkuhsh ussa kaizta: —Ap painkul. ¿Chikishmaka aumɨza sunkana kirau? Izti. Up taittakas nakas ishkuat kit nua sairamakpas. Aune nu karɨt min kit tayal kit kwisha tɨnta sairamakpas. ");
INSERT INTO kwi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Suasne Jesúsne usparuza sɨnkanara: —¿Chikishmaka nawa sayamtuanas? Ap Papihshpa tukin tuatpaish, ap Papihsh kaiztu aizpa piankamna. ¿Une sun pianchiwail? ");
INSERT INTO kwi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Us “Dios paiña papihsh i” paramtuasmin, uspane us kaizta aizpa mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Suasne usne uspakasa Jerusalén pɨpulukis kihsh kit Nazaret pɨpulura nappara. Usne uspa kaizta aizpa mɨt kit kirɨt. Paiña akkuhshne sun kirɨt aizpa ayuk kaijchura watsat kit minta. ");
INSERT INTO kwi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sunmesa Jesúsne an katsa kawit kit an wat pianmika namta. Diosne ussa pashira. Awaruzne us akwa wat minñara. ");
INSERT INTO kwi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Katsa mikwane, Tiberione, quince añokima ɨninta. Sun payura usne an ampara ainki mikwaruza ɨninnara. Poncio Pilatone Judea sura ɨninta. Herodesne Galilea sura ɨninta. Paiña aimpihshne, Felipene, Iturea surakas Traconite surakas ɨninta. Lisaniasne Abilinia sura ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sun payuwara Anáskas Caifáskas, katsa pariyaruz, uzpailta. Suasne sun payura Diosne, Zacaríaspa painkulta, Juanta, pul sukin para. ");
INSERT INTO kwi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Usne Jordán pimawarain chat kit akkwan pijikima sun pit awaruza tɨnta kainanara: “U kwail kiamtu aizpa maizat kit chɨhkarain. U kwail kirɨt aizpa tayalamtune, Diosne uruza sɨnam saninnanazi. Suasne nane uruza munnanash,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","An ñamin Isaíasne uzta. Sun Dios pit kainammmikane kaiz kit sunkana pɨnkɨhta para: “Mazane pul sukis ka tɨnta paranazi: ‘Au Anpatpa mi watsaninnanaka, nil sanapa. ");
INSERT INTO kwi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mi pil piwail kirɨkane, pil winnazi. Wan ɨnkalkas wan ɨzakas sak sanazi. Kailsa mikas nil sanazi. Kwash mikas sak sanazi. Awa wan mi nil sashiana minñamtukas, Diosne wan awaruza wat namninnashimtu. ");
INSERT INTO kwi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wan awane Dios ɨnintamikasha, watsat mɨlmumikasha, izanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Akkwan awane Juanpakin puzara, us usparuza munnanapa. Usne usparuza ka kiznara: “Une kamta kwalkana mai. Dios uruza ilna akane, une ɨkkainsachi. ");
INSERT INTO kwi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wat tɨne wat pippain wamtu. Kawarain kwail kirɨt aizpa maiztumikane, paiña kwail chɨhkamtumikane, awa iztukin wat kinazi, awa us maiztɨt piankamanapa. Uruzpain ka minman: ‘Aune Abrahampa kwal makpas, Dios uruza wat kinat kit sappanapa.’ Nane uruza watcha kaiznamtus. Dios pashpa kawirashimtune, kal chi. Usne sun ukkasa Abrahampa pashpa namninnashina. ");
INSERT INTO kwi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mɨnpazha mujtɨt tɨ kwalta pialpinkasa kwanapainsarɨt. Tɨ wat pippa wamtukine, kwat kit ĩnta kiakpɨnnazi. Une sun tɨkana mai. Diosne u minñamtu aizpa kaninnazi. Sunkanane Diosne kwail kirɨt aizpa chɨhkamtuchiruza ilnashinazi.” ");
INSERT INTO kwi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Suasne, akkwan awane ussa mɨmaara: —¿Aune chima kianapai? kizara. ");
INSERT INTO kwi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanne usparuza sɨnkanara: —Paas kamisha mɨjmikane mamaz mɨjchimikasha mɨlatpa. Kumira mɨjmikane mɨjchimikasha nail kit kwintawa. ");
INSERT INTO kwi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Roma gobiernowa pial sapmuruzne ussa ɨara, Juan usparuza munninnanapa. Juanta mɨmaat kit kaizara: —Aune ¿Chima kianapai? kizara. ");
INSERT INTO kwi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanne usparuza sɨnkanara: —Gobierno ɨninta aizpa an muin puisaman. ");
INSERT INTO kwi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mamaztuzkas suldaruruzkas ussa mɨmaara: —Aune ¿chima kianapai? kizara. Usne usparuza sɨnkanara: —Mɨnainkas walkuman. Mamazta pɨrail kaizman, us mɨj aizpa ukkana. Gobierno awa pial nua takane, sun pialkasa wat kultain. ");
INSERT INTO kwi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wan awane chiwazha izna tɨriztu purazi. Sunkas usparuzpain mɨmat kit minñara: “¿Juanne Dios ɨnintamika sa?” minñara. ");
INSERT INTO kwi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juanne wan usparuza sɨnkanara: “Nane uruza kwazikasa munnanash. Mazane nakin anza tɨnta anazi. Nane uskana watchish. Na paiña kiwainmikakas, nane an wat awa chish, ussa wat kiwainnapa piankamsachish. Sun amtumikane Diospa Sɨnam Izpulta ɨninnazi, ukasa tuanpa, uruza kiwainnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Awaruzne chara pippakanain pura. Uspane chara ayakasa narɨt. Chara aya kihshkultawane, wat awane tɨmkasa ulpiannazi. Aya kihshkultukin pishkarawane, usne chara pippa wantat kit mamaz yalta watsanazi. Usne chara ayara impaktanazi. Sun ĩnne kwikain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sunkana Juanne awaruza kurunnat kit kamtanat kit Dios watsal pit kaiznara. ");
INSERT INTO kwi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Uskas Herodesta, ɨninmikasha, kaizta: “Nune kwail kirai, aimpihshpa ashampara mɨltɨt akwa. Nukas an akkwan kwail kirai,” ussa kaizta. ");
INSERT INTO kwi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","An wan kwail kimtuasmin, usne mamaz kwail kirɨt. Usne kwizta Juantakas kajchira sɨpninta. ");
INSERT INTO kwi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mane akkwan awara munnarawane, Juanne Jesústakas munta. Jesús Diosta paikumtuasmin, chiyura kai izta. ");
INSERT INTO kwi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chiyuras Diospa Izpulne utkurukana iztɨt. Jesústa kihshta. Mazane chiyuras kaizta: —Nune ap painkul i. Nua nat kit pashimtus, nu na kishit aizpa kimtu akwa, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesúsne treinta año panapain. Suasne usne kamtanamɨzta. Awane ka “Jesúsne Joséwa painkul azi” minñara. ");
INSERT INTO kwi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Joséne Elíwa painkul azi. Usne Matatpa painkul azi. Usne Levíwa painkul azi. Usne Melquiwa painkul azi. Usne Janawa painkul azi. Usne Joséwa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Usne Matatíaspa painkul azi. Usne Amóspa painkul azi. Usne Nahúmpa painkul azi. Usne Esliwa painkul azi. Usne Nagaiwa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Usne Maatpa painkul azi. Usne Matatíaspa painkul azi. Usne Semeiwa painkul azi. Usne Josecpa painkul azi. Usne Judáwa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Usne Joanánpa painkul azi. Usne Resawa painkul azi. Usne Zorobabelpa painkul azi. Usne Salatielpa painkul azi. Usne Neriwa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Usne Melquiwa painkul azi. Usne Adiwa painkul azi. Usne Cosampa painkul azi. Usne Elmadampa painkul azi. Usne Erpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Usne Jesúspa painkul azi. Usne Eliezerpa painkul azi. Usne Jorimpa painkul azi. Usne Matatpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Usne Levíwa painkul azi. Usne Simeónpa painkul azi. Usne Judáwa painkul azi. Usne Joséwa painkul azi. Usne Jonampa painkul azi. Usne Eliaquimpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Usne Meleawa painkul azi. Usne Menawa painkul azi. Usne Matatawa painkul azi. Usne Natánpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Usne Davidpa painkul azi. Usne Isaíwa painkul azi. Usne Obedwa painkul azi. Usne Boozpa painkul azi. Usne Salawa painkul azi. Usne Nassónpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Usne Aminadabpa painkul azi. Usne Adminpa painkul azi. Usne Arniwa painkul azi. Usne Esrompa painkul azi. Usne Farespa painkul azi. Usne Judáwa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Usne Jacobpa painkul azi. Usne Isaacpa painkul azi. Usne Abrahampa painkul azi. Usne Taréwa painkul azi. Usne Nacorpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Usne Serugpa painkul azi. Usne Ragaupa painkul azi. Usne Pelegpa painkul azi. Usne Heberpa painkul azi. Usne Salawa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Usne Cainánpa painkul azi. Usne Arfaxadpa painkul azi. Usne Sempa painkul azi. Usne Noéwa painkul azi. Usne Lamecpa painkul azi. ");
INSERT INTO kwi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","38","Usne Matusalénpa painkul azi. Usne Enocpa painkul azi. Usne Jaredpa painkul azi. Usne Mahalaleelpa painkul azi. Usne Cainánpa painkul azi. Usne Enóspa painkul azi. Usne Setpa painkul azi. Usne Adánpa painkul azi. Diosne Adánta sara. ");
INSERT INTO kwi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sɨnam Izpul Jesústa piztawane, Jesúsne Jordán piras kailta. Diospa Izpulne ussa pul sura mɨlta. ");
INSERT INTO kwi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta payukima Diablone ussa ɨnin kit kwail kininshira. Sun payu kwatchi. Sunpawa payu pailnakima yak kira. ");
INSERT INTO kwi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Suasne Diablone ussa kaiz kit mɨmara: —¿Watcha Dios painkul kish? mɨmara. Suasne sun ukkasa pan sari, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesúsne ussa sɨnkara: —Dios pɨnkɨhta ka parɨt: “Awane pankasain uzasachi. Awane Dios kamtamtu aizpa pashiarawa,” parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Suasne Diablo ussa kwash ɨnkal ɨzara mirawane, Diablone ussa azain wan chiwal sura izninta. ");
INSERT INTO kwi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Diablone ussa kaizta: —Nane nua wan chiwal su mɨlashinas, ɨninnapa, wat uznapa. Nu wan iztu aizpa nawa chɨhkarɨt akwa, nane wan mɨj aizpa mamazta chɨhkashinas. ");
INSERT INTO kwi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nawa wakpuj wain kit paikwatne, nane nua wan mɨlanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Suasne Jesúsne ussa sɨnkara: —Sunkana Dios pɨnkɨhta ka para: “Nune up Diostain, up Anpattain, wakpuj wain kit ussain kiwainti,” para. ");
INSERT INTO kwi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Suasne Diablone ussa Jerusalén pɨpulura mit kit ussa Diospa yal mitta kunninpanat. Suane ussa kaizta: —Nu Dios Painkulne, nuin mittas nain kit pilta taizti, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dios pɨnkɨhta ka parɨt: “Anpatne paiña ángeltuza ɨninnanazi, nua iz kit kiwainnapa. ");
INSERT INTO kwi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nua usparuzpa chihtɨkasa sap mɨlanazi, ukta taiz kit kilmanpa.” ");
INSERT INTO kwi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mane Jesúsne ussa sɨnkara: —Mamaz pitkas Dios pɨnkɨhta ka para: “Up Diosta, up Anpatta, ɨninmun, nu pashit aizpa kinpa, kwail kinpa. Diosne nawa pashimtu akwa, na Diosta nɨjkultu akwa, nane nu ɨnintu aizpa kimanash.” ");
INSERT INTO kwi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Suasne wan pailtawane, kapal Jesústa kwail kininshitpane, Diablone Jesústas paimpa ɨt kit akkwan payurakima atchi. ");
INSERT INTO kwi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesúsne Galilea sura kailtuasmin, Dios Izpulne ussa tɨnta kiwainta. Sun suwarane akkwan awane Jesúspa kwinta kiara. ");
INSERT INTO kwi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesúsne kammu yalta kamtanara. Awane kaizara: “Usne kwisha wat kirɨt”, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Suasne Jesúsne Nazaret pɨpulura, us kawira pɨpulura, kail kit naptɨt. Usne kwaizkulmu payura kammu yalta us kamtɨt aizpa nap kit kun kit Dios pit izta. ");
INSERT INTO kwi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Usne Isaías pɨnkɨh parɨt aizpa sapta. Pɨnkɨh nakuhsat kit sunkana izta: ");
INSERT INTO kwi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anpatpa Izpulne nakasa ɨmtu. Katmizna usne nawa nara, puizaruza Dios watsal pit kainanapa, kajchira sɨptɨttuza chɨhnanapa, kasu sɨptɨttuza mamasa izanapa, iltɨttuza an naizamanpa, ");
INSERT INTO kwi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","sun watsal payura Dios awara kiwainanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Suasne Jesúsne pɨnkɨh ip kit kammu yal kiwainmumikasha kailnin kit uzta. Wan kammu yalkin uztuzne ussa izara. ");
INSERT INTO kwi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Usne usparuza kaiznamɨzta: “U sun Dios pit parɨt aizpa iztuasmin, ma payu Diosne wan parɨt aizpa watcha kimɨzta.” ");
INSERT INTO kwi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wan awane Jesúspa iztaspaat kit usparuzpain kaizara: “Usne nilkas watkas parara. Paramtuasmin, watsal pitmin kwinta kit. Watsal paramtukas, ¿usne Joséwa painkulmin ki?” mɨmara. ");
INSERT INTO kwi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesúsne usparuza kaiznara: “Une watcha nawa sunkana kizanazi: ‘Tuttulne, nuin watsari. Chiwazha Capernaum pɨpulura kirɨt aizpa kawarain apain, up sukinkas, sari,’ ” kizara. ");
INSERT INTO kwi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ankas usparuza kaiznara: “Nane umɨza watcha kaiznamtus: ‘Kamtammika paiña sura uztuzkas, sun pɨpulura uztuzkas paiña pit mɨashitchi.’ ");
INSERT INTO kwi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nane umɨza watcha kaiznamtus: ‘An ñancha akkwan ampu irɨt ashamparuzne Israel sura uzara. Sun payu Elíasne tuazi. Kutña año kakwakasa alu kimakane, akkwan awane kwisha yak kiara. ");
INSERT INTO kwi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dios Elíasta Israel awaruza kiwainnanapa ɨnintachikas, Diosne ussa Sarepta pɨpulura ɨninta, maza ampu irɨt ashampara kiwainapa. Sidón pɨpulune kasha uz. ");
INSERT INTO kwi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nane umɨza an kwinta kiznanash. Eliseo, Dios pit kainammmika, uzasmin, akkwan aya pɨtta ishturuzne Israel sura uzara. Sua turakas, usne usparuza sun ishtu wat paninnarachi. Usne Naamánmin Siria suras awarain paiña ishtu wat paninta.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wan kammu yalkin Jesús kaizta aizpa mɨraruzne Jesústa pilchapuzara. ");
INSERT INTO kwi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Katmizna uspane kuhsak kit ussa pɨpulukis pianamal tɨnta ɨninñara, pilchirarakima. Uspane Jesústa kwash pilchiramans kiakpɨnashira, inapa. ");
INSERT INTO kwi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Uspa ussa pilchiramans kiakpɨntachi akwa, usne uspa paizkakis puz kit ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Suasne Jesúsne Capernaum pɨpulura, Galilea sura, kihsh kit ɨt kit kwaizkulmu payura usparuzpa kammu yalta kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Katsa mikwakana kamtanara akwa, wan awane Jesúspa kamtampa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Maza ampune kammu yalta tuara. Salizne ussa piz kit ussa tɨnta ka kaizninta: ");
INSERT INTO kwi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Nune Jesús i. Nazaret pɨpuluras i. ¿Aumɨza naizninnamas? Nane nuwa pianish. Nune Diostas sɨnammika i, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesúsne ussa kaizta: —Sunkana kaizmun. Puñain. Ampuras puzti, kizta. Sun mɨrawane, salizne ussa awa paizkakin piltain nainninta. Suasne ampuras ɨrɨt, ampura kwail kitchin. ");
INSERT INTO kwi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wan awane iztaspaat kit usparuzpain kaizara: —Jesúsne tɨnta paramtu. Us tɨnta akwa, usne salizta kaiz kit puzninta. Salizta ɨnintawane, ampuras puzninta, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sun suwarane akkwan awane Jesús kit aizpa piankamara. ");
INSERT INTO kwi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Suasne Jesús kammu yaltas puztawane, Simón Pedrowa yalta napta. Suane Pedrowa suegra ishtu tuazi, imukasa. Uspane ussa paikuara, ussa wat paninnapa. ");
INSERT INTO kwi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesúsne ussa ɨt kit iz kit imu kaninta. Sun urain wat parɨt. Usne kuhsak kit kumira sat kit usparuza kwinnara. ");
INSERT INTO kwi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sun payu pãn payaptɨkane, awane akkwan tuntu ishturuza Jesústa karaara. Usne usparuza paanat kit wanta wat paninnara. ");
INSERT INTO kwi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jesúskas mɨnpazha saliztuza puzninnara. Puzarawane, salizne ka kwianara: —Nune Dios painkul i, kizara. Uspa Jesúspa pian akwa, Jesúsne usparuza paraninnarachi. Uspane Jesúsne Dios painkulpa azi pianmara. ");
INSERT INTO kwi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kɨntɨkane, Jesúsne pɨpulukis ɨt kit pul sura, awa tuchira, ɨrɨt. Awane ussa sayara. Ussa sayarawane, ustukin wanmalara. Uspane ussa “Akkis ɨmun” kaizara. ");
INSERT INTO kwi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesúsne usparuza kaiznara: —Dios watsal pit mamaz pɨpulukin uztuza kainanashimtus. Diosne awara ɨninnashimtu. Katmizna sun akwa Diosne nawa ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Suasne usne Judea suwara ɨt kit kammu yalta Dios pit kamtanara. ");
INSERT INTO kwi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Maza payune Jesúsne Genesaret pimamin tuazi. Akkwan awane aat kit ussa sɨppanakima nuppainñaara, Dios pit mɨana. ");
INSERT INTO kwi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesúsne paas kanua pimamin pura izta. Pishkaru sulmuruzne kanuaras puzara, uspa ɨmmu kittana. ");
INSERT INTO kwi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Usne Simónpa kanuara wat kit ussa kaizta: —Akkis nuppainti, attishchin. Usne kanuara wat kit Dios pit awaruza kamtanara. ");
INSERT INTO kwi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kapal kainanarawane, usne Simónta kaizta: —Kanuawara pi pɨnta ɨt kit ɨmmukasa kiaintawa, pishkaru sulna, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónne ussa sɨnkara: —Kamtam. Aune kɨnsɨh pishkaru sultuanash, mazainkas piztachi. Pishkaru sulmarampailtakas, nu kaizta aizpa sulmukasa piznash. ");
INSERT INTO kwi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sun sulpailtawane, kwisha akkwan katsa pishkaru sulpailta, sulmu pihshanapain pawal. ");
INSERT INTO kwi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Suasne uspane uspa kal kimtuza mamaz kanuara sayanara, aat kit kiwainapa. Uspane aat kit paas kanuara winñara, pira unainapain pawal. ");
INSERT INTO kwi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sun iztawane, Simón Pedrone Jesústa wakpuj wain kit kaizta: —Ap Anpatne, na tukis ɨtpa. Nane kwail kirɨtmika ish, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simónkas kal kimtuzkas ussa iztaspaara, kwisha akkwan pishkaru sulta akwa. ");
INSERT INTO kwi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiagokas Juankas, Zebedeo painkul, Simónpa izmuruzne Simónkasa kal kimtuazi. Uspakas iztaspailta. Jesúsne Simónta kaizta: —Ishkumun. Ñamin pishkaru sulpailta. Kawarain makis nune awara akwananaka, Diosta piankamanapa, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Suasne pimamin kanuawara kaiyarawane, uspane wan mɨjat aizpa chɨhkat kit ussa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesúsne maza pɨpulura pɨntuas. Suane ampune, aya pɨtta ishtumikane, tuazi. Jesústa iztawane, usne at kit wakpuj wain kit ussa paikwara: —Ap Anpat. Nawa sɨnam sashitne, ap ishtu sɨnam sashina. ");
INSERT INTO kwi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesúsne chihtɨkasa nil sat kit ussa paat kit kaizta: —Nua sɨnam sanash. Me namtɨre. Sun urain sun aya pɨtta ishtumikane wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesúsne ussa kaizta: —Sunpa mɨnainkas paranamun. Ɨt kit nuin pariyara antash. Ussa Moisés ñamin ɨninta aizpa mɨlti, awa Dios nua sɨnam sara aizpa piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pailta payu an akkwan awane us kirɨt aizpa mɨara. Kwisha akkwan awane wanmakkara, ussa mɨanapa, usparuzpa ishturuza wat paninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesúsne awakis ɨt kit nan sura, awa tuchira, mara, Diosta paikwan. ");
INSERT INTO kwi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mamaz payura Jesúsne kamtanamtu tuazi. Kashara mɨnpazha Fariseo awaruzkas Moisés kaizta aizpa kamtamtuzkas uzara. Uspane Galilea su pɨpuluraskas, Judea suraskas, Jerusalén pɨpuluraskas aara. Diosne Jesústa kiwainta, awaruza wat paninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Suasne mɨnpazha ampune chasachi ishtumikasha kamara muaara. Uspane ussa yalta napshiara, ishtumikasha Jesús tukin taana. ");
INSERT INTO kwi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Uspane uskasa nappasachi, akkwan awa akwa. Suasne uspane yal kɨh ɨsalta nuara. Kɨhkin kul sarawane, uspane ussa kamarain Jesús tukin inkihshaara. ");
INSERT INTO kwi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesúsne uspa nɨjkultu aizpa pian. Sunkana minñara: “Jesúsne ishtumikasha wat paninshinaka,” minñara. Katmizna Jesúsne usparuza kaiznara: —Izmumika, mɨzha. Nane up kwail kirɨt aizpa sɨnam sanash, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Suasne Moisés kaizta aizpa kamtamtuzkas Fariseo awaruzkas usparuzpain mɨmat kit ka kaizara: “¿Sun awane mɨnma kai? Usne Diosta kwail kiztu. ¿Mɨnma kwail sɨnam sashimtu? Diosmin kwail kirɨt aizpa sɨnam sashina,” kizara. ");
INSERT INTO kwi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús uspa mɨmara aizpa nɨjkultawane, usne usparuza ka mɨmanat kit sɨnkanara: —¿Une chikishma ayukta, u kaijchukin, minñat kit mɨmaamtu? ");
INSERT INTO kwi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na “up kwail kirɨt aizpa sɨnam sanintus” kiztane, sunne samchi i kaizna. Na “kamaras kuhs kit kun kit chat” kiztane, sunne anza sam i kaizna. ");
INSERT INTO kwi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Une sun piankamtawa. Diosne nawa, Ampu namtɨtmikara, sun sura ɨninta, kwail kirɨttuza sɨnam saninnanapa. Katmizna chasachi ishtumikasha kaizta: —Mɨri. Kuhsak kit kun kit kama kuhsat kit yalta charash, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sun urain usne paizkakis kuhsakta. Paiña kama us pitmukin kuhsat kit yalta ɨra “Diosne kwisha wari,” kiz kit. ");
INSERT INTO kwi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wan awane sunta iztaspaat kit ishkuat kit usparuzpain kaizara: —Diosne kwisha wari. Sunkanane an ñamin aune iztakimakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pɨpuluras puztawane, Jesúsne Levíra, Roma gobierno pial sapmu yalkin izta. Levíne Roma gobierno pial sapmumika azi. Jesúsne ussa kaizta: —Nakasa at. Nawa kanpazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Suasne Levíne tas kuhsak kit wansɨh chɨhkat kit ussa kanpara. ");
INSERT INTO kwi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Suasne Levíne Jesús akwa paiña yalta pishta sat kit akkwan kumira sat kit akkwan pial sapmuruzakas mamaz awarakas nailnara, pareju kuanapa. ");
INSERT INTO kwi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sunkana Fariseo awaruzkas Moisés kaizta aizpa kamtamtuzkas paiña kammuruza pilchapuzara. Uspane Jesústa kammuruza kwail kaiznat kit mɨmanara: —¿Chikishma une kuamtu sun Roma gobierno pial sapmuruzkasa kwail kimtuzkasa? mɨmaanara. ");
INSERT INTO kwi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesúsne usparuza sɨnkanara: —Ishtuchiruzkas wat parɨttuzkas watsammikara pashikain. Ishturuzne watsammikara pashiamtu. ");
INSERT INTO kwi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nane wat kimtuza akwanamtuchish. Kwail kimtuza akwanamtus, uspa kwail kiarɨt aizpa maizanapa, uspa kwail kiamtu aizpa chɨhkaanapa, Diosta kaiyanapa. ");
INSERT INTO kwi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Uspane Jesústa kaizara: —Juanpa kammuruzkas Fariseowa awaruzkas kawarain akkwan piji tɨlawain pala kwatchasmin, Diosta paikuamtu. Anpane, up kammuruzne kuamtu. ");
INSERT INTO kwi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesúsne usparuza sɨnkanara: —Kasara kimtune, ampuwa izmuruzne kuanazi, kumira kwinkane. Impa chi. ");
INSERT INTO kwi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Awa ashampa kanpain mɨjmikasha piantarane, wanne tayalanazi. Mamaz payura, kwail awa nawa mɨlarawane, ap kammuruzne tayalat kit pala kwatchin puranazi. ");
INSERT INTO kwi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Usne usparuza mamaz kamtam kwinta paranara: —Pĩn pɨtta kwarane, pĩn pakkultane, mɨnminkas masas pĩn pshat kit ɨsalpara yalkain. Sunkana yaltane, pɨtta pĩn pihshanazi. Masas pĩn pɨttara yaltawane, pɨtta pĩnne watsal iztuchi. ");
INSERT INTO kwi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mɨnminkas masas vino pɨtta kalpa ayara winsachi. Sunkana wintane, masas vinone aya pɨttara pihshat kit vino puztɨm. Ayakas karɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Masas vino sultane, masas ayara wintawa. ");
INSERT INTO kwi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Akkwan añokima vino sultɨt mɨjne, mɨnminkas masas vino kukain. Tainne an wat kizmu, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jesúskas paiña kammuruzkas kwaizkulmu payura chara sauwara pɨnara. Kammuruzne chara pippa pakkat kit chihtɨkasa nusat kit kuara. ");
INSERT INTO kwi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sun izarawane, Fariseo awaruzne Jesústa ka kizara: —Up kammuruzne kal kiamtu. Moisés aumɨza kamtamnat kit aumɨza ka kiznara: “Kwaizkulmu payu kal kiman,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesúsne usparuza sɨnkanara: —Au an ñamin mikawa Davidkas paiña izmuruzkas yak kiakane, uspane kuara. ¿Sun kwinta iztamakkiwas? ");
INSERT INTO kwi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Usne Dios yalta nap kit pan Diosta tarɨt aizpa sap kit kwat kit izmuruza nailnara. Pariyain sun pan kuashina. Ñamin Moisés kamtamnat kit kaiznara: “Mamaz awara sun pan nailnamun,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesúsne usparuza an sɨnkanara: —Nane, Ampu namtɨtmika, ish. Kwaizkulmu payurakas chiwazha wat mintu aizpa kinash. ");
INSERT INTO kwi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mamaz kwaizkulmu payura Jesúsne Judío kammu yalta nap kit Dios pit kamtanamɨzta. Mazane, numal chihtɨ tuiltɨtmikane, tuazi. ");
INSERT INTO kwi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés kaizta aizpa kamtamtuzkas Fariseo awaruzkas Jesústa izara. “¿Kwaizkulmu payura ussa namtanasa?” minñara, Jesús kwail kimtu kizanapa. ");
INSERT INTO kwi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Anpane Jesúsne uspa minñamtu aizpa pianara. Chihtɨ tuiltɨtmikasha kaizta: —Kuhs kit paizkakin kunti, kizta. Usne paizkakin kuhs kit kunta. ");
INSERT INTO kwi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesúsne usparuza mɨmanara: —¿Kwaizkulmu payura awara chima kinpai? ¿Wat kin? ¿Kwail kin? ¿Kiwain kit wat sana? ¿Piantana? mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Suasne Jesúsne wan awaruza iznat kit ishtumikara kaizta: —Up chihtɨ nil sari, kizta. Paiña chihtɨ nil sarawane, chihtɨ tuiltɨtmikane wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Uspane Jesústa kwisha pilchapuzara. Usparuzpain chi kwail Jesústa kishiamtu aizpa minñara. ");
INSERT INTO kwi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sun payu Jesúsne ɨzara Diosta paikwan ɨra. Kɨnsɨh Diosta paikwara. ");
INSERT INTO kwi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kɨnmɨzkane, Jesúsne kammuruza akwannara. Suasne doceruza nanarawane, Jesúsne usparuza paiña ɨnintaruz munnara. ");
INSERT INTO kwi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sunkana uspane ka munnara. Simónpa mun maiztɨt. Mane usne Simón Pedro mun i. Mamazne, Simónpa aimpihshne, Andrés mun i. Santiagokas, Juankas, Felipekas, Bartolomékas, ");
INSERT INTO kwi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateokas, Tomáskas, Santiagokas (Alfeowa painkul), Simón Celote munmikakas, ");
INSERT INTO kwi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judaskas (Santiagowa painkul), Judas Iscariotekas munnara. Usne, minpara munmikane, Jesústa annara, awa ussa pizanapa. ");
INSERT INTO kwi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesúsne uspakasa ɨzaras kihshat kit sakkimin kunara. Akkwan kammuruzkas akkwan awakas wanmakkara. Judea suras awakas Jerusalén pɨpuluras awakas aara. Tiro pɨpuluras awakas Sidón pɨpuluras awakas aara, ussa mɨana, uspa ishturuza kakulninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Usne awaras kwail saliztuza puzninnara. ");
INSERT INTO kwi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wan awane ussa mɨshiara. Dios Jesústa kiwainta akwa, Jesúsne akkwantuza wat paninnara. ");
INSERT INTO kwi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesúsne kammuruza iznat kit kaiznara: “Puizaruzne wat puranazi, Dios usparuza kiwainnat kit ɨninnamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ma payu yak kimturuzne wat puranazi. Tukkanazi. Tayalturuzne wat puranazi. Ishananazi. ");
INSERT INTO kwi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Awa umɨza naizninamtukas, uruza pashinamtuchikas, uruza kwail kizamtukas, u munpa kwail minñamtukas, une wat puranazi, u ap kanpamtuz namarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sun payura watsal uzizanaka. Dios umɨza chiwazha chiyura mɨlanamtu akwa, wat puraizanaka. Kawarain uruzpa an ñancha kwalne Dios kainammtuzakas kwail kiara. ");
INSERT INTO kwi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma payu uztuzne, kwazpa kultɨt uzturuzne, tayalanazi. Une apa wan wat sappat kit wat uzamtu. ");
INSERT INTO kwi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ma payu tukta kumturuzne tayalanazi. Mamaz payura yak kianazi. Ma payu ishanturuzne tayalat kit azanazi. ");
INSERT INTO kwi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Akkwan awa u akwa wat paarakas, une naizarɨnazi. Wat uzizanaka. An ñamin awaruzne wat chi kamtamtuza kawarain wat pit kwinta kiara.” ");
INSERT INTO kwi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nane nawa mɨmtuza kaiznamtus: U aliztuza pashirain. Umɨza aliz kulkane, usparuza wat kirain. ");
INSERT INTO kwi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","¡Umɨza kwail kizkane, usparuza watsal pit pararain! Umɨza kwail kikane, us akwa Diosta paikwarain. ");
INSERT INTO kwi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mɨnpazha up matsɨhkin patkane, mamaz kanmal antain. Mɨnpazha up kamisha nakakane, mamaz kamisha ussa mɨlarain. ");
INSERT INTO kwi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","¡Mɨnpazha chiwazha paikukane, sunkanain mɨlarain! Mɨnpazha nu mɨj aizpa nakakane, na mɨj aizpa kailnincha, kizman. ");
INSERT INTO kwi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sunkanain kitpa. Une wan awaruza wat kirain. Une mamaz awa uruza wat kinpa pashiamtu. Ukas mamaztuza kawarain wat kirain. ");
INSERT INTO kwi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nu up izmuruzain pashimtune, Diosta tɨrizman, nua chiwazha mɨlanapa. Dios uruza wat kiwainshimtu akwa, sunkana une wantuza wat kishinarawa. Kwail kimtuzkas mamaz kwail kimtuzakas kawarain pashiamtu. ");
INSERT INTO kwi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kawarain uruza wat kimturuzain wat kiamtune, une chinkas kana kisachi. Kainsɨh. Wan kwail kimtuzne usparuzpain kawarain wat kiamtu. ");
INSERT INTO kwi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mamazta pui nammɨlamtune, une mamaz payura nu puimɨlat aizpa sapna tɨriztu. Kainsɨh. Sunkanane kwail kimtuzne kwail kimtuza pui nammɨlamtu, kawarain sapna. ");
INSERT INTO kwi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","U aliz awaruza pashinat kit usparuza wat kinarawa. Usparuza pui mɨlarain, sapna tɨriznachi. Sunkana kitne, une u watsal mɨlam sappanazi. Chiyuras Diosne uruza paiña kwalkanain namninnanazi, Dios kwail kimturuzakas aishtaish kiztuchiruzakas kiwain kit mɨlanamtu akwa. Uskas sunkanain awaruza kiwainat kit mɨlanarawa. ");
INSERT INTO kwi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Au Taitta Diosne awaruza kiwain kit mɨlanamtu. Ukas kawarain awara kiwainat kit mɨlanarain.” ");
INSERT INTO kwi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mamazta ‘nune kwail kirɨt’ kizmun. Sunkana kimtune, Diosne u kwail kirɨt aizpa kainananazi. Mamazpa kwail sɨnam sarane, Dioskas u kwail kiarɨt aizpa sɨnam sanazi. ");
INSERT INTO kwi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mamaz we mɨjkane, ussa mɨlarain. Dioskas umɨza kwisha akkwan mɨlananazi, tiznakima. Diosne u mamaz awara mɨlamtukanain uruza mɨlananazi.” ");
INSERT INTO kwi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Suasne Jesúsne kamtam kwinta kammuruza kwinta kinara: “Kasu sɨptɨtmika mamaz kasu sɨptɨtmikasha chihtɨkasa taintawane, paasas kulkin taizpailshina. ");
INSERT INTO kwi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kamtammikane an akkwan pian. Kammumikane an we pian. Kammumika na wan mɨj aizpa kamarawane, usne kamtamkana namnazi. ");
INSERT INTO kwi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ainki tɨ pak u aimpihshpa kasura naptane, une sunta nɨjkulamtu. Katsa pak u kasura naptane, une sunta nɨjkulashitchi. ");
INSERT INTO kwi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Katsa tɨ pak up kasura naptane, up kasu sɨptawane, une u aimpihshta ka kaizsachi: ‘up kasuras an ainki tɨ pak uknash.’ Wat pit paratpane, une wat uzamtuchi. An ñancha katsa tɨ pak up kasuras uktawane, suasne ainki tɨ pak iz kit u aimpihshpa kasuras pak uktawa. Sunkana, Dios u kwail kiarɨt aizpa sɨnam sarawane, une mamaztuza kiwainashina.” ");
INSERT INTO kwi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Wat tɨne kwail pippa wakain. Kawarain kwail tɨne wat pippa wakain. ");
INSERT INTO kwi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Katmizna pippa waakane, wamtumikane sun tɨra pian. Mɨnminkas wat pippa palakkuppa tɨras paksachi, kukain pippa akwa. Mɨnminkas wankail pippa kwail tɨras paksachi, kwail pippa wamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wat kimtumikane kaijchuras min kit wat kimtu. Kwail kimtumikane kaijchura kwail min kit kwail kimtu. Awane kaijchura wa aizpa paramtu.” ");
INSERT INTO kwi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nune ‘ap anpat i’ kiztumikane chiwazha na kaiztu aizpa mɨt kit kirain. ");
INSERT INTO kwi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nane uruza kamtam kwinta kinash. Nawa amtumikakas, ap pit mɨmtumikakas, na kaizta aizpa kimtumikakas maza awakanain mai. ");
INSERT INTO kwi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sun awane yal sara. Ainkih kul uktakima kɨhtawane, usne ukta yal sara. Pi pɨnkane, yal nainshina. Yal ukta sarɨt akwa, pine yal kwasachi. ");
INSERT INTO kwi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Anpane na kaizta aizpa mɨmtumika ap pit kimtuchine, mamaz awakanain uztu. Sun awane yal sashira. Pil ɨsalta yal sara. Pi pɨntawane, yal nain kit pi kwarɨt. Wan karɨt,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Awara paiña pit kwinta kit pailtawane, Jesúsne Capernaum pɨpulura kail kit napta. ");
INSERT INTO kwi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Suane maza suldarune uzta, paiña wat kiwainmikakasa. Suldarune ussa wat minta. Usne inapain tuazi. ");
INSERT INTO kwi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesúspa mɨrawane, suldarune Hebreo ɨlapa awaruza Jesús tura ka paikuan ɨninnara: “¿Ashimtukish ap kiwainmikasha wat kakulninna?” mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesús tura aakane, uspane ussa kwisha tɨnta paikuat kit kaizara: —Sun suldarune kwisha wari. Ussa kiwaintawa, ");
INSERT INTO kwi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","us au Israel kwalta pashinamtu akwa, au kammu yal sarɨt akwa, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Suasne Jesúsne uspakasa ɨra. Jesús yal kashara akane, suldarune izmuruza Jesús tura ɨninnat kit ussa kaizara: —Ap Anpat, an kashara amun. Anne aizapmun. Nune ap yalta napmun. ");
INSERT INTO kwi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na tɨnta chi akwa, nane nua ɨtchish, nua saina. Katmizna ap kiwainmikasha “wat pari” kiztane, wat parɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mamaz an katsa mikwane nawa ɨnintu. Nakas suldaruruza ɨninnamtus. Mamazta “ɨt” kizkane, ɨm. Mamazta “at” kizkane, am. Ap kiwainmikasha, “sun sari” kizkane, sam. Katmizna ap kiwainmikasha “wat pari” kiztane, wat parɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sun suldaru kaizta aizpa mɨrawane, Jesúsne iztasparɨt. Kun kit akkwan kanpamtuza kaiznara: —Nane Israel awaruztas sun suldarukana iznarachish. Usne ap pit wat nɨjkultu. Usne na kaiztu aizpa min kit piankamtu. ");
INSERT INTO kwi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɨnintɨttuz kaiyarawane, uspane kiwainmikasha wat parɨt wanmalara. ");
INSERT INTO kwi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sun kitpane, Jesúskas paiña kammuruzkasa akkwan mamaz awaruzkasa Naín pɨpulura ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pɨpulu napmukin kashara piannakane, uspane ampu irɨtta muamturuza izara. Akkwan pɨpuluras awakas irɨtmikasha kamna ɨara. Sun ampu irɨtpa ashampane sun pɨpulura uzta. Paiña painkulne irɨt. Maza painkulmin mɨjazi. ");
INSERT INTO kwi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Painkul irɨtpa akkuhshta iztawane, Jesúsne us akwa tayal kit kiwainshit kit kaizta: —Azmun, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Suasne ɨt kit ataúdta paara. Ataúdta paamtuasmin, irɨtta muamturuzne kunara. Suasne Jesúsne irɨtta kaizta: —Musittu, kuhsakti, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Suasne irɨtmikane kuhsak kit paramɨzta. Jesúsne ussa akkuhshta chɨhkara. ");
INSERT INTO kwi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sun izarawane, wanne ishkuat kit kaizara: —Diosne kwisha wari. Usne aumɨza Dios pit kainammmikasha ɨninta. Diosne paiña kwalta kiwaina ara. ");
INSERT INTO kwi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wan awane Judea suraskas kasha suraskas Jesús kit aizpa piankamara. ");
INSERT INTO kwi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanpa kammuruzne sunpa ussa kaizara. ");
INSERT INTO kwi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Juanne ussain paas kammuruza akwara. Usne usparuza Jesús tukin ɨninnara ka mɨmana: —¿Nune Diospa ɨnintamikakish? ¿Mamazta tɨrizanas? mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sun Juanpa kammuruzne Jesústa aat kit kaizara: —Juanne, sun munnammikane, aumɨza ɨninara ka mɨmaana: ¿Nune Diospa ɨnintamikakish? ¿Mamazta tɨriznas? mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sun urain Jesúsne Juanpa izmuruzpa iztakin akkwan ishturuza wat paninnara. Naizturuzakas wat paninnara. Saliztuza puzninnara. Akkwan kasu sɨptɨttuza kasu izkulninnara. ");
INSERT INTO kwi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Suasne Jesús usparuza sɨnkanara: —Ɨt kit Juanta u izara aizpakas u mɨara aizpakas ka kaiztain: “Mane kasu sɨptɨttuza kasu izkulninamtu. Chasachiruza chaninnamtu. Aya pɨtta ishturuza sɨnam sanamtu. Mɨkaintuza mɨninnamtu. Irɨttuza kuhsninnamtu. Puizaruzne Dios watsal pit mɨamtu. ");
INSERT INTO kwi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chiwazha na kit aizpakas na kaizta aizpakas chɨhkamtuchimikane, wat puranazi. Mama nawa nɨjkulmɨzti,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa ɨnintuz tas puzarawane, Jesúsne awaruza akwanat kit Juanpa ka kiznamɨzta: “Pul sura ɨarawane, ¿Chima izanas une? Tɨnta inkwane pakane, chiwazha pɨtne ulpiantu. An ampune, Juanne, pɨtkana ulpiantachi, tɨnta akwa. ");
INSERT INTO kwi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sua ɨarawane, ¿Chima izanas une? Sua ampura watsal pĩn kwarɨt izarachi. Mɨrain. Ampune watsal pĩn kwaarɨtkas akkwan wat kumira kwarɨtkas gobierno awakana uzamtu. ");
INSERT INTO kwi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sua ɨarawane, ¿Chima izanas une? ¿Diospa kainammmikasha izamanas? Watcha. Une Dios kainammmikasha izara. Usne an katsa kainammmika azi. ");
INSERT INTO kwi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpa Dios pɨnkɨhta ka parɨt: ‘Izti. Nane ap ɨninmikasha nukin an ñancha ɨninnash. Usne up mi watsanazi,’ ka parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Watcha kaiznamtus. Juanne wan awaruzkin an tɨnta i. Juan an tɨnta arakas, an we tɨntamikane, Dios ɨnintura uztumikane, Juankin anza tɨnta i,” ka kiztus. ");
INSERT INTO kwi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesús kaizta aizpa mɨarawane, akkwan awakas, gobierno pial sapmuruzkas us kaizta aizpa nɨjkulat kit kaizara: “Dios watcha i.” Sun akwa, Juanne usparuza pira munnanarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sunkana Juanne Fariseo pariya awaruzakas Moisés kaizta aizpa kamtamtuzakas pira munnanarachi, Dios usparuza kaizta aizpa mɨashitchi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Suasne Jesúsne ka kwinta kinara: “¿Makis awane miza izarɨt? ");
INSERT INTO kwi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Uspane pashpakana mai. Pashpane paizka pɨpulura salat kit usparuzpain kaizara: ‘An música usturakas, une ku kiarachi. Au tayaltu kanta kiztakas, une azarachi,’ kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan, pira munnammika akane, usne akkwan kumirakas vinokas kwatchi. Sun akwa, une ‘Salizne ussa piztɨt,’ kaizamtu. ");
INSERT INTO kwi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ampu namtɨtmikane kumirakas vinokas kwarɨt. Sun akwa, une uspa kaizamtu: ‘Izti. Usne akkwan kumira kumtu. Pirɨt cha. Paiña izmuruzne Roma gobierno pial sapmuruzkas kwail kimtuzkas mai,’ kizamtu. ");
INSERT INTO kwi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Awane, Diospa piankammuruzne, Dios wari piankamanazi. Mamaz Diospa kainammtuza mɨamtuchi akwa, uspane Diosta piankamasachi.” ");
INSERT INTO kwi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Maza Fariseo awane Jesústa akwara, uskasa kwan. Katmizna Jesúsne Fariseowa yalta kwan ɨrɨt. Jesúsne misharɨkin uzta. ");
INSERT INTO kwi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Suasne maza kwail kirɨt ashampane sun pɨpulura uzta. Sun ashampa Jesús Fariseowa yalta naptɨt kamtawane, usne at kit piam pih alabastro uk winmura win kit karara. ");
INSERT INTO kwi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sun ashampa Jesúspa kwizpa, paiña mittɨkin, kumtuasmin, azmɨzta. Jesúspa mittɨkin kappikasa pulishmɨzkane, usne Jesúspa mittɨra paiña ashkasa pulchaknin kit paiña mittɨkin putchunta. Suasne paiña mittɨra piam pih nɨra. ");
INSERT INTO kwi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo awane, Jesústa kwan akwatmikane, sun izta. Ayukta ka minta: “Sun ampune watcha Dios kainammmika tuatne, usne sun ashampawa piankamshina. Sun ashampane, ussa paramikane, kwail uz kit kwail kimtu,” minta. ");
INSERT INTO kwi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Suasne Jesúsne ussa sɨnkara: —Simón, chiwazha nua kwinta kishimtus. Jesústa sɨnkara: —¡Kamtam, nawa kizshimtune, kainazha! kizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesúsne ussa kamtam kwinta ka kainara: —Kwazpa ampune paas awara pui mɨlara. Mazainta quinientos pial pui mɨlara. Mamazta cincuenta pial pui mɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sun paas pui saptɨttuza tasachi akwa, suasne pui mɨlatmikane paasta pui aizpa kaninta. Mane kainazha. ¿Mɨnma an kwazpamikasha an pashinasa? ");
INSERT INTO kwi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónne ussa sɨnkara: —Anza pui kaninmikane ussa anza pashimtu. Jesúsne ussa sɨnkara: —Nune nil min kit kaizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ashampara puijchatpane, Jesúsne Simónta ka kaizta: —An ashampara izti. Na up yalta naptakas, nune nawa kwazi karashitchi, ap mittɨra kitna. Nu ap mittɨ kitna ɨnintachikas, an ashampane paiña kappikasa ap mittɨra pulishnin kit paiña ashkasa ap mittɨ pulchaktara. ");
INSERT INTO kwi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na up yalta naptane, nune nawa wat saptachi. Nune Israel awa wantuza kimtu aizpa kitchi. Nawa putchuntachi. Nune Judío awa kiamtu aizpa kitchi. Na up yalta naptakima, an ashampane ap mittɨkin putchunmɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nune ap kɨzpura piam pih parantachi. Sunkana usne ap mittɨra piam pihkasa nɨra. ");
INSERT INTO kwi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Katmizna nua kaiztus. Dios paiña akkwan kwail kirɨt aizpa sɨnam sarɨt akwa, usne nawa akkwan pashimɨztu. Dios mamazta pitchin kwail sɨnam sarane, usne akkwan pashikain, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesúsne ashampara kaizta: —Up kwail kirɨt aizpa sɨnam sarɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Akwattuzne usparuzpain ka minñamɨzta: —¿Anne mɨnmika ka i? Usne kwailkas sɨnam saninnamtu, minñara. ");
INSERT INTO kwi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Usne ashampara kaizta: —Nu na kaizta aizpa nɨjkulta akwa, Diosne up kwail sɨnam saninta. Diosne nua watsat mɨltɨt. Watmin ɨnka, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sun kitpane, Jesúsne akkwan ainki pɨpuluwarakas akkwan katsa pɨpuluwarakas ɨra, Dios watsal pit kainaana, Dios doce awaruza ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Doce kammuruzkas mɨnpazha ashamparuzkas ussa kanpaara. Jesúsne sun saliztuz ashampa piztɨttuztas puzninnat kit ishturuza wat paninnara. Usne Magdalena muntɨt Maríaras siete saliz piztɨttuza puzninnara. ");
INSERT INTO kwi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juanane, Cuzawa ashampane, kanpara. Cuzane Herodespa kiwainmika azi. Susanakas an akkwan ashampakas usparuza uspa mɨjat aizpa kiwainñara. ");
INSERT INTO kwi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kwisha akkwan awane pɨpuluras puzat kit wanmakkara, Jesústa mɨana. Usparuza sun kamtam kwinta kinara: ");
INSERT INTO kwi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Malmumikane pippa malna ɨra. Pippa maltuasmin, chiwazha pippa miwara taizara. Suane awa miwara chamtuasmin, pippara mittɨ kulta. Chitchukas pippa sak kuara. ");
INSERT INTO kwi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mamaz pipparuzne ukta taizara. Chikkarawane, kwazi chi akwa azain pulparɨt. ");
INSERT INTO kwi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mamaz pipparuz pu tɨtkin taizara. Chik kit kuntawane, pu tɨtne pippara kawininkain. ");
INSERT INTO kwi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mamaz pipparuz wat pilpara taizat kit chikkat kit kunara. Wan pippa warawane, maza tɨne maza cien pippakanain waara.” Sun kiztawane, usne tɨnta ka kwiannara: “U kail waj akwa, na kaizta aizpa wat minñat kit mɨrain. Katmizna ap pit mɨrain.” ");
INSERT INTO kwi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Paiña kammuruzne ussa paikuara, usparuza kamtam kwinta kamtananapa, piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Usparuza kaiznara: “An ñancha une miza Dios ɨnintu pianchi. Mane na umɨza kamtanashimtukas, nane mamaztuza kamtam kwintakasa kwinta kinamtus, izmuruz kamamanpa, mɨmturuz piankamamanpa.” ");
INSERT INTO kwi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Sun kamtam kwinta sunkana i. Pippane Dios pitkana i. Miwara chakane, awane sun pit mɨamtu. ");
INSERT INTO kwi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Miwara ɨmmikane Dios pit mɨmtu. Sunkana sun urain Satanáne kanpat kit Dios pit kaijchuras, ayuktas, ukkamtu, awa Dios pit nɨjkulamanpa, Dios usparuza watsat mɨlnamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mamaz pippane uk pilpara taiztu. Uk pilpara ɨmturuzne Dios pit mɨat kit watsal kulat kit sappara. Mujtɨt waj chi akwa, ɨrattukimain Dios pit mɨarawane, uspane Dios pit mainñamtu, Satanás usparuza kwail kininnashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mamaz pippane pu pilpara taiztu. Pu pilpara ɨmturuzne Dios pit mɨara. Uspa kal akwa, pial pashiara akwa, watmin uzshiara akwa, pippane Dios pitkanain kunkain. Dios pit pippakanain kwayarɨm. ");
INSERT INTO kwi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mamaz pippane wat pilpara taiztu. Dios pit mɨarawane, uspane Dios pit kwisha wat kaijchura watsamtu, pippa waanakima.” ");
INSERT INTO kwi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Putmumikane alampara tɨmkasa paltakain, tãn kɨhkasa tamajarukasa paltakain. Sunkana putmumikane alampara kwash kanmu, napmuruz kai izanapa. Sunkana awane Dios kamtamtu aizpa piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mamaz payura awane wan puintɨt aizpa nɨjkulanazi. Awane chiwazha sɨptɨt aizpa piankamat kit kai izanazi. ");
INSERT INTO kwi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Katmizna, watsal mɨrain. Akkwan kamtumikane an akkwan piankamnazi. We kammumikane us mintu aizpa, us mɨj aizpa, karɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesúspa akkuhshkas aimpihshtuzkas ussa kashain aara. Akkwan awa akwa, ussa izarachi. ");
INSERT INTO kwi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mamazne kainara: —Up akkwakas up añaruzkas pianamal kunat kit nua izshiamtu. ");
INSERT INTO kwi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Usparuza sɨnkanara: —Ap akkwakas ap añaruzkas pianamal kunamtukas, nane uspawa ap kwalkanain mintuchish. Wan Dios pit mɨmturuzkas Dios kaizta aizpa kimturuzkas ap akkuhshkana mai, ap añakana mai. ");
INSERT INTO kwi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maza payune Jesúskas paiña kammuruzkas kanuara waara. Sua usparuza ka kaiznara: —Aiz pi kwakara ɨzhain. Suasne ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aiz pi paizkara ɨamtuasmin, Jesúsne pittɨt tuazi. Tɨnta inkwa pira pamɨzta. Pine kanuara palakpɨnmɨzta. Kanua pira unainapain. ");
INSERT INTO kwi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Suasne uspane ussa ɨat kit izkulninnat kit kaizara: —Kamtam. Kamtam. Pi kwanapainmakpas. Jesúsne kuhsak kit kaizta: —Inkwane, kari. Pine, kialmun, kizta. Inkwane karɨt. Pine kalpain parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Suasne kaiznara: —¿Nɨjkultuchimakkiwas nawa? Uspane ishkuat kit iztaspaat kit usparuzpain ka kizara: “¿Mɨnma kai sunne? Jesús inkwarakas pirakas kaiz kit ɨninkane, inkwakas pikas ussa mɨmtu.” ");
INSERT INTO kwi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea suras puzarawane, uspane Gerasa sura kwakkaara. ");
INSERT INTO kwi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús kanuaras kihsh kit pilta kuntawane, maza pɨpuluras awane, saliz pizarɨt ampune, ussa wanmalta. Akkwan payurakima pĩn kwaarachi. Yalta uztachi akwa, pantióntain tuazi. ");
INSERT INTO kwi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesústa iztawane, usne kwian kit ussa wakpuj wain kit ka kaizta: —¿Nawa chima kinash? Katsa Diosne chiyura uz. Nune Dios Painkul i. Nane nua paikumtus, nawa naizninmanpa, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús saliztuza puztain kizarakas, salizne sunkana kaizamtuazi. An ñamin sun saliztuzne ussa akkwan piji piztɨt. Awane paiña chihtɨkas mittɨkas cadenakasa kantɨt mɨjazi, ussa watsanpa. Kantɨtkas, usne cadena pakalta, usmin chɨhkulnapa. Suasne salizne ussa pul surakima, awa tuchira, mɨltɨt. ");
INSERT INTO kwi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Suasne Jesúsne salizta mɨmara: —¿Une chi mun? Usne sɨnkara: —Akkwan mun makpas, ka kizta. Akkwan saliztuzne ussa pizarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Uspane ussa paikuara: “Ainkih kulta aumɨza ɨninmun.” ");
INSERT INTO kwi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akkwan kuzune ainki ɨzamamim kumira sait kuamtu. Uspane kuzuruza napna paikuara. Jesúsne usparuza chɨhkara, kuzuruza nappanapa. ");
INSERT INTO kwi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Suasne saliztuzne ampuras puzat kit kuzuruza pizara. Wan kuzuruzne malpara ãĩn kihshat kit pira taizara. Wanne pi kwaarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sun kit aizpa izarawane, kuzu izmuruzne ishkuat kit sun kwinta pɨpuluras awara, nantas awara, kainana ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sun awane pɨpuluras puzara, sun kit aizpa izana. Uspane Jesústa aat kit an ampura izara. Jesúsne an ampuras saliztuza puzninnara. Sun ampune Jesús panakin uz kit pĩn kwat kit wat minta. Uspane ishkuara. ");
INSERT INTO kwi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sun kit aizpa izmuruzne nantas awaruza saliz puznintɨtmika wat parɨt kainanara. ");
INSERT INTO kwi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Suasne wan Gerasa suras awane Jesústa paikuara, usparuztas puztɨnpa, uspa ishkwarɨt akwa. Suasne kanuara warawane, Jesúsne kwakara kailmɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Saliz mɨjatmikane paikwara, uskasa ɨn. Jesúsne ussa kaizta: —Nakasa ɨmun. ");
INSERT INTO kwi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Up kwalta kail kit Dios nu akwa kit aizpa kainanaka. Ampune paiña kwalta kail kit paiña pɨpulura uztuza Jesús us akwa kit aizpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús pi kwakara kwaktawane, akkwan awane ussa tɨrizat kit ussa watsal sappara. ");
INSERT INTO kwi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Suane maza ampune, Jairo muntɨtmikane, ara. Usne Judío awa kammu yal ɨninmika azi. Usne Jesúspa mittɨkin wakpuj wain kit paiña yalta ɨnpa paikwara, ");
INSERT INTO kwi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","paiña pashuin ishtu akwa. Usne doce añoin kawirɨt. Inapain azi. Jesús ɨmtuasmin, akkwan awane ussa sɨpkimain nuppainñara. ");
INSERT INTO kwi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Maza ashampane ussa kanpara. Usne doce añokimain paiña aimpi pulparachi. Mɨnminkas ussa wat panintachi. Usne kwizpa at kit Jesúspa pĩn puntakin paara. Paiña pĩnkin paamtuasmin, sun urain paiña aimpi puztɨt aizpa pul para. ");
INSERT INTO kwi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Suasne Jesúsne ussa mɨmara: —¿Mɨnma nawa paara? kizta. Mɨnminkas sɨnkarachi. Suasne Pedrone ka kizta: —Anpat, akkwan awane nua kashara sɨpkimain nuppainñara, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesúsne kaiznara: —Mɨnpazha ap pĩnkin paara. Nane mazara wat panintɨt pianish, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wat parɨt nɨjkultuasmin, usmin kulamanamtɨkane, sun ashampane Jesústa at kit ul kit wakpuj wainta. Usne wan awa izarakin “nane Jesústa paarau,” kaizta. Sun urain usne “nawa wat parɨt” kizta, wan awa mɨanapa. ");
INSERT INTO kwi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesúsne ussa sɨnkara: —Nawa nɨjkultɨt akwa, wat pari. Watmin ɨnka, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús mama paramtuasmin, mɨnpazha ɨninmikawa yaltas at kit Jairora kaizta: —Up pashu irɨt. Kamtammikasha an kaizapmun, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesúsne sun mɨt kit Jairora kaizta: —Ishkumun. Nɨjkulcha. Up pashune wat parɨnazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairowa yalta piannatpane, Jesúsne uskasa akkwanta napninnarachi. Usne yalta napta pitchinkasa, Pedrokasakas, Juankasakas, Santiagokasakas, paiña papihshkasakas paiña akkuhshkasakas. ");
INSERT INTO kwi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wanne azat kit tayalara, irɨt akwa. Jesúsne usparuza kaiznara: —Azaman. Irachi. Pittɨt tui, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Uspane ussa ishanara, watcha irɨt piankamara akwa. ");
INSERT INTO kwi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Suasne Jesúsne paiña chihtɨra piz kit ussa tɨnta kaizta: —Pashpa, kuhsti, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Paiña izpul ussa naptawane, sun urain kuhsakta. Jesúsne chiwazha kwanpa kwintain kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Paiña papihshkas paiña akkuhshkas iztaspaarɨt kunara. Jesúsne kaiznara: —Mɨnainkas sun kit aizpa paranaman, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesúsne doce kammuruza wanmakninnara. Usparuza kiwainnat kit katsa mikwakana namninnara, wan saliztuza puzninnanapa, wan ishturuza wat paninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Usne usparuza ɨninnara, Dios awaruza ɨninnashimtu kainanapa, ishturuza wat paninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Usne kaiznara: —Miwara ɨmtune, kɨlmin ɨtpa. Tɨwilkasakas, tuhkasakas, pankasakas, pialkasakas ɨman. Maizmu kamisha kwaman. ");
INSERT INTO kwi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chiwazha yalta naptane, suain pittain, ɨmtu payurakima. ");
INSERT INTO kwi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pɨpuluras awakas nantas awakas umɨza sappamakane, tas kaiyat kit wan awa iztakin pil mittɨ kiharain, uspa kwail kiarɨt aizpa piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Suasne uspane puzat kit wan pɨpuluwara ɨara, Dios watsal pit kainana, ishturuza wat paninnana. ");
INSERT INTO kwi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodesne, katsa mikwane, Jesús kit aizpa mɨra. Usne Jesúspa kwisha mintuara, mɨnpazha Juan mamasa uznintɨt kaizta akwa. ");
INSERT INTO kwi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mɨnpazha Elías, Dios kainammmika, iztɨt kizara. Mɨnpazha mamaz ñamin ɨlapa irɨt Dios kainammmika mamasa uzninta kizara. ");
INSERT INTO kwi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sun mɨrawane, Herodesne ka kizta: —Juanta kɨzpura tɨtna ɨnintau. Suasne ¿Sunne, mɨnmakai? Chiwazha Jesús kit aizpa mɨrau. Katmizna usne Jesústa azain izshira. ");
INSERT INTO kwi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tas kaiyarawane, ɨnintaruzne ussa chiwazha uspa kiarɨt aizpa kaizara. Usne usparuzain Betsaida pɨpulura minat kit ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sun piankamarawane, akkwan awane ussa an kwizta kanpaara. Usparuza sapnat kit “wat kɨntɨre” kiznarawane, Jesúsne miza Dios awaruza ɨninnashimtu kainanara. Ishturuzakas kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nashmɨzkane, doce kammuruzne ussa aat kit kaizara: —Wan awara pɨpulurakima nantakima ɨninnari, uspa kumira sayanapa, yalkas pitna sayanapa. Apane pul sukin chinkas wachi. ");
INSERT INTO kwi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Usne usparuza kaiznara: —Une usparuza kumira kwinnarain. Uspane sɨnkaara: —Cinco pankas paas pishkarukasain mɨjmakpas. Wanta kumira kwinnana, aune kumira paina ɨtpamakpas. ");
INSERT INTO kwi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sua cinco mil ampu wanmakkara. Jesúsne usparuza kaiznara: —Cincuentakimain wanmakkat kit uzninnari. ");
INSERT INTO kwi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Suasne wanta pilta uzninnara. ");
INSERT INTO kwi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Cinco pankas paas pishkarukas saptawane, Jesúsne chiyura izak kit Diosta “aishtaish” kizta. Sun wan pitti pittin kɨztawane, kammuruza nailnara. Suasne kammuruzne wan awaruza nail kwinnara. ");
INSERT INTO kwi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wan awane kapal kuat kit tukkara. Sun kumira tiztɨt akwa, uspane doce tɨmta winñara. ");
INSERT INTO kwi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maza payune Jesúsne paimpa Diosta paikumtu tuazi. Kasharane kammuruzne uzara. Ka mɨmanara: —Awane ¿Mɨnma na ish kizamtu? ");
INSERT INTO kwi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka sɨnkaara: —Mɨnpazha nune Juan munnammika i, kizamtu. Mamaztuzne nune Elías i kizamtu. Mamaztuzne nune ñamin ɨlapa Dios kainammmika i, kaizamtu. Sunne mamasa irɨttas kuhsninta, kizamtu. ");
INSERT INTO kwi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Usparuza mɨmanara: —Une ¿Mɨnma na ish kaizamtui? Pedrone ka sɨnkara: —Nune Diospa nɨrɨtmika i, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Jesúsne usparuza ka kaiznara: —Na uruza kaiztu aizpa mɨnainkas kainanaman. Diosne nawa, Ampu namtɨtmikara, an sura ɨninta, awa akwa naiznapa. Ɨlapa Judío pariyaruzkas Moisés kaizta aizpa kamtamtuzkas katsa mikwara nawa chɨhkaanazi, nawa piantaanapa. Kutña payu pailtɨka, mamasa kuhs kit uznash. ");
INSERT INTO kwi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sun kainarawane, Jesúsne wanta kaiznara: —Nawa kanpashitmikane usmin mintu aizpa maintawa. Kurishta imtumikane wan chɨhkamtu. Sunkanane ap kanpammikane wan chɨhkanazi, nakasa chanpa. Nawa kanpazhain. ");
INSERT INTO kwi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mɨnpazha uspawain tɨnta kal kiamtu, wat uzanapa. Wat uzamtukas, iarɨnazi. Sunkana wan kaarɨnazi. Diosta kanpamtuzne Dios kuruntu aizpa mɨanazi. Diosne paiña pit mɨmtumikasha watsat mɨlnazi. ");
INSERT INTO kwi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Katmizna kwazpa kultumikane, chiwal mɨjmikane, wansɨh karɨnazi, irɨka. ");
INSERT INTO kwi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mɨnpazha nawa mɨtsal kitne, mɨnpazha na kaizta aizpa mɨtsal kitne, nane, Ampu namtɨtmikane, ussa mɨtsal kinash. Na mamasa chiyuras akane, nane Diospa ángelkana Taitta Dioskana kai malnash. ");
INSERT INTO kwi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Watcha kaiznamtus. Mɨnpazha akki uztuzpain iamanazi, miza Dios awaruza ɨninnamtu piankamanakima. ");
INSERT INTO kwi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho payu pailtawane, Jesúsne Pedrorakas Juantakas Santiagorakas ɨnkal ɨzara minara, Diosta paikwan. ");
INSERT INTO kwi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diosta paikuamtuasmin, Jesúspa matsɨh naztam malkwera. Paiña kwaksham putchãkana namtɨt. ");
INSERT INTO kwi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Suane Moiséskas Elíaskas, paas an ñancha uzattuzkas, uskasa kwinta kiilta. ");
INSERT INTO kwi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sun paasas Jesús panakin naztam malkwera. Uspane Jesús irɨmtu Jerusalén pɨpulura kwinta kiilta. ");
INSERT INTO kwi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrokas paiña izmuruzkas pitshiara. Izkularawane, uspane Jesús naztam namtɨt izara. Paas awarakas Jesúskasa panara izara. ");
INSERT INTO kwi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Paas ampu Jesústas ɨmtazasmin, Pedrone Jesústa ka kaizta: —Kamtam, watmin akki tumakpas. Kutña ɨranchu sanawas: mazane nu akwa, mazane Moisés akwa, mazane Elías akwa, kizta. Pedrone us kwinta kit aizpa pianchi. ");
INSERT INTO kwi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sun kwinta kimtuasmin, wanish usparuza sɨpnara. Wanish usparuza sɨptane, izmuruzne ishkuara. ");
INSERT INTO kwi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Diosne wanish ayukmalsɨh ka kiznara: “Anne ap painkul i. Ussa narau. Ussa mɨrain,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dios kaizta aizpa mɨarawane, uspane Jesústa mazainpain pana izara. Uspane puñain paat kit uspa izara aizpa kainanarachi. Akkwan payurakima mɨnainkas izara aizpa kaiznarachi. ");
INSERT INTO kwi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mamaz payura, Jesúskas paiña kammuruzkas ɨnkaltas kihsharawane, akkwan awane ussa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Maza ampune usparuztas ussa tɨnta ka kaizta: —Nane nua paikumtus, ap painkulta iznapa. Maza painkulmin mɨjish. ");
INSERT INTO kwi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mɨzha. Saliz ussa piztawane, usne tɨnta kwiantu. Salizne ussa ulnintu, ilpi puznakima. Saliz akkwan piji ussa pizkane, pashpane naiz kit kwisha kwaizta. ");
INSERT INTO kwi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nane up kammuruza saliz puzninnapa paikwarau. Puzninmanamarɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesúsne sun payura uztuza sɨnkanara: —Une nawa nɨjkulamtuchi. Une, ma uztuzne, kwail awa mai. Nane uruza wan payurakima tailchamanash. Nane uruza tailchasachish, kiznara. Suasne Jesúsne papihshta kaizta: —Up painkul nawa karash, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pashpara amtuasmin, salizne ussa nainnin kit tɨnta ulninta. Jesúsne salizta parat kit pashparas puzninta. Jesúsne pashpara kakulnin kit paiña papihshta chɨhkara. ");
INSERT INTO kwi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wanne Dios wat kirɨt akwa iztaspaarɨt. Jesús chiwazha kirɨt akwa, wanne iztaspaarɨt. Suasne usne kammuruza ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—An pit wat mɨrain. Mɨnpazha nawa aanazi, Ampu namtɨtmikara pizanapa, katsa mikwara chɨhkanapa. ");
INSERT INTO kwi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kammuruzne Jesús kaizta aizpa piankamarachi. Diosne usparuza sun pit piankamninnarachi. Ishkuara akwa, uspane Jesús kaizta aizpa mɨmaarachi, an piankamana. ");
INSERT INTO kwi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Paiña kammuruzne usparuzpain ka mɨaamɨzta: ¿Mɨnma an tɨnta i? kizara. ");
INSERT INTO kwi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesúsne uspa minta aizpa nɨjkul kit pashpara tain kit us tukin kunnin kit ");
INSERT INTO kwi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","usparuza ka kaiznara: —Une we tɨntaruza an pashpakana sap kit kiwaintawa. We tɨntaruza na akwa kiwaintumikane nawa sap kit kiwaintu. Nawa saptumikane ap Taittara, nawa ɨnintamikasha saptɨnazi. Katmizna uruzpain an we tɨntamikane an tɨnta namtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Suasne Juanne ussa kaizta: —Kamtam. Aune saliz puzninmikasha iztamakpas. Us nua paikukane, usne saliztuza puzninnamtu, us tɨnta ɨnim mɨj akwa. Us aukanain nua kanpamtuchi akwa, aune ussa “Jesústa paikumun, saliztuza puzninnanapa,” kiztamakpas. ");
INSERT INTO kwi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesúsne ussa kaizta: —Sunkana kaizmun. Aukasa aliz chimikane aumɨza kiwainnamtu. ");
INSERT INTO kwi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chiyura nuna kasha pakane, Jesúsne Jerusalén pɨpulumal ɨn min kit ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Usne mɨnpazharuza an ñancha ɨninnara. Uspane Samaria pɨpulura ɨat kit nappara, pitmukin sayana. ");
INSERT INTO kwi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sun Samaria pɨpulura uztuzne ussa yal nammɨlannarachi, us Jerusalén pɨpulumal pianashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Paiña kammuruz, Santiagokas Juankas, sun nɨjkulpailkane, Jesústa ka kizpailta: —Chiyuras uztuza paikuiznapas, ippa ɨninnapa, usparuza kuanapa, ianapa. ");
INSERT INTO kwi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Suasne Jesúsne puij kit paasta pilchanara, uspa sun kaizta akwa. ");
INSERT INTO kwi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ampu namtɨtmikane au sura atchi, awaruza piantana. Usne apain ara, awaruza watsat mɨlnana. Suasne uspane mamaz pɨpulura ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Miwara ɨamtuasmin, maza ampune Jesústa kaizta: —Anpat, mɨnta ɨkwara nua kanpashiras, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesúsne ussa sɨnkara: —Ɨnkal kwizane pil kulta pitmu mɨj. Chitchukas tɨra pitmu mɨj. Sunkana Ampu namtɨtmikane pitmu kwaizkulna mɨjchi. ");
INSERT INTO kwi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesúsne mamazta kaizta: —Nawa kanpazha. Usne sɨnkara: —Anpat, an ñancha ap papihshta pilta kamshimtus, iraka. ");
INSERT INTO kwi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesúsne ussa sɨnkara: —Diosta pianchimikane irɨttuza kamshina. Nune sunkana kinchi. Ɨt kit awaruza Dios aumɨza ɨninnashimtu kainanari. ");
INSERT INTO kwi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mamazne ussa kaizta: —Anpat, nane nua kanpashimtus. An ñancha ap kwaltuza ɨru kiznashimtus. ");
INSERT INTO kwi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesúsne ussa sɨnkara: —Ap kal masamikane ap kal kitpa, pailnakima. Ap kal chɨhkatmikane Dios ɨnintura kiwainsachi. ");
INSERT INTO kwi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sun pailtawane, Anpatne an setenta paas awaruza nannara. Usne an ñancha us iztakin usparuza paas paas wan pɨpuluwara ɨninnara. Usne an kwizta uspa tura ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Usne usparuza kaiznara: “Kwisha akkwan pakna wa. Sunkana pakmuruzne we. Saupamikasha paikwatpa, saura an pakmuruza ɨninna, wan pakkanapa. ");
INSERT INTO kwi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Une ɨrain. Mɨzhain. Nane umɨza, pɨriku pashparuzkana ɨninnamtus, aliz awaruza, ishukanaruza, parananapa. ");
INSERT INTO kwi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pial tuh kwaman; tuh kwaman; mamaz zapato kwaman. Miwara ɨmtune, azain wat kɨntɨre kiznarain. ");
INSERT INTO kwi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chiwazha yalta naptane, an ñancha usparuza ‘wat kɨntɨre, watmin tuanka’ kizanaka. ");
INSERT INTO kwi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu kaizta aizpa wat mɨmturuzne watmin uzanazi. Nu kaizta aizpa wat mɨmchiruzne watchi uzanazi. ");
INSERT INTO kwi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sun yaltain uz kit chiwazha kwintu aizpa kwarain. Kal kimmikane paiña kal kimtu akwa, chiwazha sapshina. Usne sua chi minta chi nukkultawa. Mamaz yalta mamaz yalta chi ɨman, awa nua yal nammɨlamtune. ");
INSERT INTO kwi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pɨpulura piannatpane, awa umɨza yal nammɨlakane, sun yalkimin nukkul kit chiwazha kumira kwintu aizpa kwarain. ");
INSERT INTO kwi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ishturuza kakulnin kit ka kiztain: ‘Apane Diosne umɨza ɨninnashimtu.’ ");
INSERT INTO kwi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pɨpulura piannatpane, awane umɨza yal nammɨlamtukine, tas ɨat kit usparuza ka kaiznarain: ");
INSERT INTO kwi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Sun pil pulpu au mittɨkin puhsta aizpa mittɨras ulpiantumakpas, au kaizta aizpa mɨarachi piankamanapa. Anne piankamtain: Apane Diosne awaruza ɨninnashimtu.’ ");
INSERT INTO kwi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ankas umɨza kaiznamtus: Diosne an pɨpulu uztuza an akkwan naizninanazi. Sodoma pɨpulukin uztuz an we naizarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Corazín pɨpulura uztuzne tayalanazi. Betsaida pɨpulura uztuzne tayalanazi. Nane akkwan watsal iztasparɨt kal sun pɨpuluruza kirau. Na watsal iztasparɨt kitkas, uspane Dios pit mɨashitchi, uspa kwail kiarɨt aizpa sɨnam sananapa. Tiro pɨpulura uztuzkas, Sidón pɨpulura uztuzkas na kaizta aizpa mɨaratne, uspane uspa kwail kiarɨt akwa tayalshinara. Ma payu uspa kwail kiarɨt aizpa wat kulnarachi. ");
INSERT INTO kwi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ilnamtu payu taizkane, Diosne Tiro pɨpulura uztuzakas Sidón pɨpulura uztuzakas an we naizninnanazi. Diosne umɨza, ma uztuza, an ñancha uztakin an akkwan naizninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Une, Capernaum pɨpulura uztuzne, chiyura nuasachi. Une ĩnta taizanazi. ");
INSERT INTO kwi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uruza mɨmturuzne na kaiztu aizpa mɨamtu. Uruza chɨhkamturuzne nawa chɨhkat kit na kaiztu aizpa mɨamanazi. Nawa chɨhkamturuzne, nawa ɨnintamikasha, ap Taittara, chɨhkat kit mɨamanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Setenta paas awaruzne kaiyara. Uspane wat kulat kit kaizara: —Anpat. Au nua paikukane, saliztuzne au kaizta aizpa mɨat kit kiara. ");
INSERT INTO kwi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Usne usparuza kaiznara: —Nane Satanásta chiyuras ippakana taiztu iztau. ");
INSERT INTO kwi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mɨrain. Nane umɨza tɨnta kiwainamtus. Wat kamta kultane, tuil tuil kultane, uspane umɨza kuamanazi. Diablokasakas paiña saliztuzkasakas waya kiarane, une anuppanazi. Chinkas uruza kwail kimanazi. ");
INSERT INTO kwi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nu salizta puznintakas, sun akwa akkwan wat kulamtuchi. Anza akkwan wat kultain, u Dioskasa chiyura uzamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sun urain Dios Izpulne Jesústa wat kulninta. Suasne Jesúsne Diosta kaizta: “Nua aishtaish kiztus. Nune ap Taitta i. Nune chiyurakas an surakas ɨninta. Nune pariyaruzakas kamtamtuzakas nu kit aizpa piankamninnarachi. Uspawa puintɨt mɨjara. Nune we piantuza kiwainara, nu kishimtu aizpa piankamanapa. Taittara aishtaish kiztus. Nu nara aizpakas nu kit aizpakas wari. ");
INSERT INTO kwi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ap Taittane chikas wantain nawa ɨninna chɨhkarɨt. Mɨnminkas Painkulta pianchi. Papihshmin ussa pian. Mɨnminkas Papihshta pianchi. Painkulmin ussa pian. Painkulne mamaztuza kiwainamtu, Papihshta piankamanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesúskas kammuruzkas paimpa tuasmin, Jesúsne usparuza kaiznara: “U chiwazha kimtu aizpa izamtu akwa, une wat kianazi. ");
INSERT INTO kwi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","An ñamin akkwan Dios kainammtuzkas katsa mikwaruzkas u izara aizpa izshiara. Uspane izarachi. Uspane u mɨara aizpa mɨshiara. Sun mɨarachi.” ");
INSERT INTO kwi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Suasne Moisés kaizta aizpa kamtammikane kun kit Jesústa mɨmat kit kaizta: —Kamtam, ¿Chima kinpai, pailta payukima chiyura uzna? mɨmara. ");
INSERT INTO kwi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Usne ussa sɨnkat kit mɨmara: —¿Dios pɨnkɨhta chima parɨt? ¿Nune chi pɨnkɨhta iztus? ");
INSERT INTO kwi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kamtammikane sɨnkara: —Une Anpat Diosta pashitpa, wan kaijchukasa, wan izpulkasa. Ussa tɨnta pashitpa. Mintuasmin, Diosta pashitpa. Une kasha uztuza uruzpain pashinamtukanain pashinarawa. ");
INSERT INTO kwi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesúsne ussa kaizta: —Nil sɨnkash. Sunkana kitne, pailta payurakima chiyura uznazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Us sɨnkara aizpa nil azi mintuasmin, kamtamne Jesústa mɨmara: —Ap kasha uztumika ¿mɨnmaka i? ");
INSERT INTO kwi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesúsne ussa sɨnkat kit an kamtam kwinta ka kaizta: —Maza ampune Jerusalén pɨpuluras miwara kihshtɨmtu. Jericó pɨpulura ɨmtuasmin, walkumtuzne ussa pizat kit pĩn nakaat kit aim kiara. Irɨtkanain tɨwij ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sun urain maza pariyane sun miwara pɨntu. Ussa iztawane, us tumakin pɨntɨt. ");
INSERT INTO kwi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kawarain maza ampune, Levíwa kwaltas, us tukin at kit ussa iztawane, us tumakin pɨntɨt. ");
INSERT INTO kwi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mamaz Samaria pɨpuluras awa ɨmtuasmin, us tukin ara. Ussa iztawane, usne us akwa tayal kit ussa kiwainshira. ");
INSERT INTO kwi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Usne ampu tura ɨt kit us aim kirɨtkin pihshpikas vinokas nɨra, wat panapa. Us aim kirɨtkin pĩn iptawane, usne ussa paiña caballora uzninta. Pitmu yalta karatpane, usne ishtura kiwainta. ");
INSERT INTO kwi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mamaz payura kiwainmikane paas pial tuhtas ukkat kit yalpamikasha mɨlat kit ussa kaizta: “Ussa kiwainti. Chiwazha pial wekane, kailtu payura tanash.” ");
INSERT INTO kwi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mane ¿Nune chima mintus? Kutñaruzne aim kiltɨttukin pɨnara. ¿Mɨnmika walkwarɨtmikasha kiwainta? ¿Mɨnmika izmumika namta? ");
INSERT INTO kwi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kamtamne kaizta: —Walkwarɨtmikasha kiwainmikane izmumika namta. Jesúsne ussa kaizta: —Ɨt kit kawarain kitpa. ");
INSERT INTO kwi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Miwara ɨmtuasmin, Jesúsne ainki pɨpulura napta. Suane ashampane, Marta muntɨtmikane, uzta. Usne yal Jesústa nammɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martawa aizpihshne María muntɨt. Maríane, Jesúspa mittɨkin at kit uzta, Jesús kamtamtu aizpa mɨna. ");
INSERT INTO kwi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mane Martane kwisha patka akwa, Jesústa azain ɨt kit kaizta: —Anpat. Aune akkwan kal mɨjmakpas. Ap aizpihshne nawa chɨhkara, wan kal kinpa. ¿Wat ki? “Nawa kiwaincha,” kizti. ");
INSERT INTO kwi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Anpatne ussa sɨnkara: —Marta. Nu kwisha kal mɨj akwa, nune kwisha patka i. Chikas wantain kimtukas, ");
INSERT INTO kwi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nune chiwazha we kimtu. Maríane nu we kimtu aizpa narɨt. Na kamtamtu aizpa mɨmtu. Mɨnminkas sun ussa nakasachi. ");
INSERT INTO kwi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mamaz payu Jesúsne mamaz nankin Diosta paikumtuazi. Paikwatpane, maza kammumikane ussa kaizta: —Anpat. Juanne paiña kammuruza paikwan kamtanara. Kawarain aumɨza paikwan kamtazhain, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Usne usparuza ka kiznara: —Paikumtune, ka kiztain: “Au Taitta, nu chiyura uztu akwa, nu sɨnam akwa, aune nua wakpuj waintumakpas. Apain anka, awaruza ɨninnana. ");
INSERT INTO kwi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Payu aizpa aumɨza kumira kwinchain. ");
INSERT INTO kwi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Au kwail kirɨt aizpa wat kulnazhain. Kawarain aune aumɨza kwail kirɨttuza wat kulnamtumakpas. Aumɨza kiwainchain, kwail kimanpa.” ");
INSERT INTO kwi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Suasne usne ma pitchin usparuza kaiznara: “Sunkana na paramtu aizpa mintain. Mamazpa izmumikane paiña yalta kakwamta attishtas pianara. Usne chinkas mɨjchi, atmikasha kwinna. Suasmesa usne kasha uzmikasha ɨt kit ka kizta: ‘Kutña pan nammɨlazha, ap izmumikasha kwinna.’ ");
INSERT INTO kwi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sun kasha uzmumikane paiña yal ayuktas, ¿chima sɨnkanazi? Sunkana kizmanazi: ‘Nawa aizapmun. Pɨjta sɨptɨt akwa, ap pashpakas nakas pittamtuas. Nane pan nammɨlan kuhsaksachish. ¿Usne sunkana kiznasa?’ ");
INSERT INTO kwi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sunkana kizmanazi. Ap kasha uzmikasha nawa pan nammɨlan kuhsshitchikas, usne kuhsak kit chiwazha pan nammɨlanazi, na akwan piji paikwara akwa. ");
INSERT INTO kwi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Umɨza ka kiznamtus. Chiwazha wekane, paikwarain, Dios uruza mɨlananapa. Chiwazha saishitne, sairain. Pɨjtakin parakane, Diosne pɨjta chɨhtnazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mɨnpazha chiwazha paikwatne, sapnazi. Mɨnpazha chiwazha sairane, sainazi. Mɨnpazha pɨjtakin kuztane, Diosne usparuza pɨjta chɨhnazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Uruzpain papihsh wai. Painkul papihshta pishkaru paikwatne, ¿papihshne ussa kamta kwinnasa? Kamta kwinmanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Painkul papihshta aral wipu paikwatne, ¿papihshne ussa tuil tuil kwinnasa? Tuil tuil kwinmanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mane une, kwail kimturuzne, chiwazha wat aizpa pashpara mɨlashinanazi. Chiyuras Papihshne chiwazha anza wat mɨlan uruza mɨlananazi. U ussa paikukane, usne paiña Sɨnam Izpulne uruza mɨlananazi.” ");
INSERT INTO kwi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Saliz mɨkain ampura piztɨt akwa, an ampune parakain parɨt. Jesús salizta puznintawane, ampune paramɨzta. Awane sun akwa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sun akwa, mɨnpazha ka kizara: “Usne salizta puzninmɨztu, Beelzebú ussa kiwaintu akwa. Beelzebúne saliz ɨninmika i.” ");
INSERT INTO kwi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ussa izamtuasmin, mamaztuzne ussa ka kaizara: —Chiwazha chiyuras iztasparɨt kal izninchain. ");
INSERT INTO kwi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesúsne uspa minñamta aizpa nɨjkul kit usparuza ka kaiznara: “Wan gobierno awa usparuzpain waya kimtune, wan pailtɨnazi. Suasmesa uspa kal kiarɨt aizpa kaarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kawarain Satanás paiña salizkasa waya kimtune, paiña gobiernone pailtɨnazi. Une na salizta Beelzebú akwa puznintɨt kizamtu. Nil chi kizara akwa, nane uruza sun kiznarau. ");
INSERT INTO kwi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na saliztuza Beelzebú akwa puzninmɨztane, ¿Mɨnma u kanpamtuza kiwainamtui salizta puzninnapa? Beelzebú usparuza sun kinpa kiwainnarachi akwa, une mɨz kiamtu, Beelzebú nawa mizurainkas kiwaintachi akwa. U kanpamtuzne uruza ‘nilchi kiamtu’ kiznanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dios nawa salizta puzninna kiwaintane, une Dios uruza ɨninnashimtu piankamashina. ");
INSERT INTO kwi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tɨnta yalpamika wantain watsarɨt mɨjne, paiña yal wat iztune, usne kalpain uz kit wan watsanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mamaz anza tɨntamika uskasa waya kikane, ussa anupparawane, usne us mɨj aizpa nakanazi, waya kimanpa. ");
INSERT INTO kwi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mɨnpazha nawa kanpamtukine, nakasa aliz i. Usne Diablora kanpamtu. Mɨnpazha nawa awa wanmaknintukine, usne paimpa ɨninnamtu, awa nawa amanpa.” ");
INSERT INTO kwi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kwail saliz awaras puznintawane, salizne uzmura chat kit kwaizkulna saimtu. Kwaizkulsachi akwa, ka mintu: ‘Na sunmin ampuras puztɨtkas, nane mamasa ampurain kailmɨztus.’ ");
INSERT INTO kwi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kailtawane, salizne ampura iztu. Maza yal pishkarɨtkana iztɨt. Watsarɨt iztɨt. ");
INSERT INTO kwi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Suasne sun salizne ɨt kit an siete anza kwail saliz karamtu. Ussa pizat kit nappara, sua uzana. An ñancha ampune naizta. An kwizta ampune anza akkwan naizmɨznazi.” ");
INSERT INTO kwi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús sun kaiztuasmin, maza ashampane usparuzpain ussa tɨnta kwian kit kaizta: —Diosne nua pɨja warammikashakas nua kawiramikashakas wat kulnazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesúsne kaizta: —Dios pit mɨmturuzkas Dios kaizta aizpa kimturuzkas anza akkwan wat kulanazi, Dios kuruntu aizpa mɨamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Akkwan awa wanmakkakane, Jesúsne usparuza ka kaiznamɨzta: “Ma uztuzne kwail kiamtu, chiwazha iztasparɨt kal sayamtu akwa. Une sun izamanazi. Diosne uruza Jonásta kirɨt aizpakana annanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonásne Nínive pɨpulura uztuza Dios pit kainanara. Kawarain Ampu namtɨtmikane ma uztuza Dios pit kainanamtu. ");
INSERT INTO kwi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","An ñamin katsa mikwa ashampane mamaz attish suras Salomón tukin, Israelpa katsa mikwakin, ara, paiña wat pit pian aizpa mɨna. Ilnamtu payu taizkane, Diosne ma payu uztuza kwail kiamtu kiznanazi. Sun ashampane kawarain kaiznanazi. Iztain. Nane Salomónkin anza tɨnta ish. ");
INSERT INTO kwi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ilnamtu payu taizkane, Nínive pɨpulura uztuzne ma uztuza kwail kiamtu kiznanazi. Jonás usparuza Dios pit kaiznarawane, uspane mɨat kit maizat kit kwail kiashitchi. Mane nane Jonáskin anza tɨnta ish.” ");
INSERT INTO kwi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Alampara puttawane, mɨnminkas pilkulta puinsachi, tɨmkasa paltakain. Putmumikane alampara kwashta kanmu, napmuruz kai izanapa. ");
INSERT INTO kwi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","U kasune alamparakana i, wan kai izanapa. Kasu watne, wan kai iztu. Kasu kwailne, wan kai izsachi. ");
INSERT INTO kwi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Katmizna, watmin na kaiztu aizpa mɨrain, watmin piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Alampara aizkane, u kai izamtu. Kawarain na kaizta aizpa mɨmtuzne wat piankamanazi, kwail kiamanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús kwinta kitpane, Fariseo awane Jesústa paikwara, uskasa kwan. Ɨtpane, yalta nap kit misharɨ uzta. ");
INSERT INTO kwi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo awane iztaspara, Jesús an ñancha paiña chihtɨ kittachi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Anpatne ussa kaizta: —U Fariseo awaruzne tasakas pɨlattukas ɨsalpara kittamtu. Ɨsalpara kittamtukas, une ayukta kittamtuchi. U walkumtu aizpakas u kwail kimtu aizpakas kaijchura wa. Sun kwailne u kaijchuras puzamtu. ");
INSERT INTO kwi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Une wat minñamtuchi. Une tɨmpawazha mai. Wan sarɨtmikane ɨsalparakas ayuktakas sarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ayuktain kiharawane, une puizara mɨlashina. Suasne u wan kiamtu aizpa sɨnam namanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","U Fariseo awaruzne tayalat kit kwisha naizanazi. Chiwazha diez mɨjne, une maza Diosta mɨlamtu. Une chiankwa kɨhkas, immu pihshkas, wat kɨhkas mɨjam. Diez mɨjne, une maza Diosta mɨlamtu. Sunne wat. Sun kiamtuasmin, awaruzakas wat kiarawa. U chiwazha mɨj aizpa Diosta mɨlamtuasmin, ussa pashiarawa. Une masain paasas kiarawa. ");
INSERT INTO kwi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","U Fariseo awaruzne tayalat kit naizanazi. Une kammu yalta an wat uzmura uzshiamtu. Une pɨpulu paizkara ɨashimtu, awa u chihtɨra putchunnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","U Moisés kaizta aizpa kamtamtuzkas Fariseo awaruzkas na kuruntu aizpa mɨzhain. Uruz awa iztakin wat awakana izninnamtukas, une ñanta kiamtu. Une tayalat kit naizanazi. Une kamkin awa irɨtkana mai. Awa irɨt kammukin izasachi akwa, awane ɨsalpara chaamtu, wan kwail ayukta pianchi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Moisés kaizta aizpa kamtammikane ussa ka sɨnkara: —Kamtam. Sun kiztuasmin, nune aumɨzakas pilchanamtu. ");
INSERT INTO kwi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesúsne sɨnkara: —U kamtamturuzne tayalat kit naizanazi. Une wan awaruza kwisha akkwan ɨnim ɨninamtu, u pashit aizpa kianapa. Une usparuza kiwainamtuchi, u ɨnintu aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Une tayalat kit naizanazi. U Dios kainammtuza kamanapa yal saarakas, uruzpa an ñancha papihshtuzne Dios pit kainammtuza piantanara. ");
INSERT INTO kwi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Une uspa kiarɨt aizpa pian. Une uspa kiarɨt aizpa nɨjkulara. Uspa Dios kainammtuza piantarawane, une uspa kamkin yal saamɨztu. ");
INSERT INTO kwi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Katmizna Diosne nil min kit ka parɨt: “Nane uruza Dios pit kainammtuzakas ɨnintaruzakas ɨninnanash. Uspane, u irɨt Judío papihshtuzne, Dios pit kainammtuza piantananazi. Mazantuza naizninnanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dios au sura sarakima, awane Dios pit kainammtuza piantanat kit kwail kinarɨt. Diosne ma uzturuza kwail kiarɨt kiznat kit usparuza culpa kinashina. ");
INSERT INTO kwi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sun Judío awane Abelkis Zacaríastakima piantara. Uspane unam misharɨkin kasha Dios yalta piantaara. Nakas watcha kaiznamtus. Ma uztuzne culpa mɨjanazi, Dios pit kainammturuza piantana nɨjkulamtu akwa. Diosne uruza “kwail kiare” kiznanazi. ");
INSERT INTO kwi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","U Dios kaizta aizpa kamtamtuzne naizarɨnazi. Awaruza kiwainshinakas, une Diospa piankamtu aizpa puintɨt mɨjazi, mamaztuza Dios pit piankamamanpa. U Diosta piankamshimtuchiasmin, une Diosta piankamshimturuza kiwainamtuchi. ");
INSERT INTO kwi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús yaltas puztuasmin, Moisés parɨt aizpa kamtamtuzkas Fariseo awaruzkas ussa kwisha aliz kulat kit ussa akkwan mɨmaara, ");
INSERT INTO kwi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","akkwan tuntu kwinta kinpa, chiwazha kwail kizna kininnapa. ");
INSERT INTO kwi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kwisha akkwan mil awa wanmakkamtuasmin, uspane usparuzain mittɨkin kulnamɨzta. Suasne Jesúsne kammuruza ka kaiznamɨzta: “Wat uzizanaka. Fariseo awakana namman. Wat paramtukas, uspane wat kiamtuchi. Uspa kaijchune kwail i. ");
INSERT INTO kwi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awane chiwazha paltarɨt aizpa izanazi. Awane chiwazha puintɨt mɨj aizpa sun ukkat kit piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","U chiwazha amtawara kaizarane, awane payuwara mɨanazi. Chiwazha impara imparain paimpa nankin kaiztane, mamazne yal kwashtas kwiannazi, wan awa mɨanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nane uruza, ap izmuruza, kaiznamtus. Uruza piantamturuza ishkuman. Uruza piantarawane, uspane an kwizta u izpulta an kiasachi. ");
INSERT INTO kwi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nane umɨza kurunnanash, mazainta, Diosta ishkwanpa. Uruza piantashinamikashakas, u izpul ĩnta kiakpɨnshinamikashakas ishkwarain. Mamasa watcha kaiztus; ussa ishkwarain. ");
INSERT INTO kwi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Cinco chitchu paas pialminkasa painim. Diosne mazain chitchuin mainkain. ");
INSERT INTO kwi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Diosne u wan ash kɨzpura waj aizpa wintɨt. Katmizna une ishkuman, Dios uruza akkwan chitchukin anza pashinamtu akwa.” ");
INSERT INTO kwi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Umɨza kaiznamtus. Mɨnpazha wan awara ‘nane Diosta pianish’ kiztane, Ampu namtɨtmikane ussa pianish Diospa ángel iztukin kaiznazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sunkana mɨnpazha wan awara ‘nane Diosta pianchish’ kiztane, nane ussa pianchish Diospa ángel iztukin kaiznash. ");
INSERT INTO kwi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mɨnpazha Dios Painkulta kwail kiztane, paiña kwail wat kulnashina. Sunkanain mɨnpazha Dios Izpulta kwail kiztane, paiña kwail wat kulmanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Awane uruza Dios yalkin kamtamtuzakas, katsa mikwaruzakas, mamaz mikwaruzakas tain mɨlnanazi, uruza naizninnanapa. U miza pakpana minman. U miza kaizna minman. ");
INSERT INTO kwi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sun urarain Diospa Izpulne uruza sɨnkara aizpa kamtananazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mazane awaruztas Jesústa kaizta: —Kamtam, ap añara ap pitti su nail mɨlazha kizti. ");
INSERT INTO kwi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesúsne ussa kaizta: —Mɨnminkas nawa sun su nailnapa chɨhkatchi. ");
INSERT INTO kwi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Usne usparuza kaiznara: —Iztain. Mamazpa pashiman. Kwazpamika akkwan chiwazha mɨjkas, usne us mɨj akwa an akkwan payukima uzsachi. ");
INSERT INTO kwi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Suasne usne usparuza kamtam kwinta kaiznara: “Paiña sura pippa maltawane, kwazpamikane paktu payura akkwan pippa pakta. ");
INSERT INTO kwi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Usne usmin ka minta: ‘¿Chima kinpai? Nane mɨnta pippa watsam chinkas mɨjchish.’ ");
INSERT INTO kwi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Usmin kaizta: ‘Sunkana sanash. Ainki watsam yal azpiantawane, an katsa watsam yal sanash. Suasne wan pippakas wan chiwazha mɨj aizpakas sua watsanash. ");
INSERT INTO kwi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Suasne apminpain kaiznash: “Nane kwisha kwazpa ish. Nane na mɨj aizpakasa akwan añokima uznash. Kwaizkul kit chiwazha kwat kit wat kulnash.”’ ");
INSERT INTO kwi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Suasne Diosne ussa kaizta: ‘Wat pianchi. Nune tɨmpa awa i. An amtain irɨnazi. Irawane, ¿Mɨnma up watsarɨt aizpa sapmɨlnasa?’ ");
INSERT INTO kwi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sunkanain an ampura kirɨnazi. Kwazpa awane, usmin watsat mɨjmikane, wan kaarɨnazi. Chiwazha Dios pashit aizpa kimtuchimikakas wan karɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sun kaiztawane, Jesúsne paiña kammuruza kaiznara: “Uruza kaiznamtus: U we kumtu aizpakas chi minman. U we pĩn kuamtu aizpa chi minman. ");
INSERT INTO kwi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Uznane kumirakin anza tɨnta i. Awane pĩnkin anza tɨnta i. ");
INSERT INTO kwi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Katsa chitchuwa mintain. Uspane pippa wakain. Pippa wat pakkain. Uspane ɨranchukas katsa watsam yalkas sakain. Diosne usparuza kwinamtu. Une chitchukin anza tɨnta i. ");
INSERT INTO kwi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mɨnminkas usmin an aks namninsachi. ");
INSERT INTO kwi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sun pitchin kisachi akwa, une an akkwan chiwazha minman. ");
INSERT INTO kwi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Wishta mintain. Miza chikkamtu iztain. Wishne pilta kal kikain. Wishne pĩn sakain. Watcha uruza kaiznamtus. Salomónne kwisha watsal pĩn kwarakas, an wishne Salomón pĩnkin anza watsal iztɨt. ");
INSERT INTO kwi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosne ma payu pɨtta pilta watsal kwiznintu. Kuntawane, azain nain kit pulchaktat kit ĩnta impaktarɨm. U Diosta we nɨjkulamtukas, Diosne umɨza wishkin anza watsal izninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Katmizna, wanta mintuasmin, ishkuman. Sunkana miman: ‘¿Chi kumirama kwanpai? ¿Chi kwazima kwanpai?’ ");
INSERT INTO kwi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wan an sura uzturuzne chiwazha wan wa aizpa sayamtu. U Dios Taittane u we aizpa pian. ");
INSERT INTO kwi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sun akwa, une an ñancha Diosta sayarawa, uruza ɨninnanapa. An kwizta Diosne u we aizpa uruza mɨlananazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Uruz ap pɨrikukana namarɨt akwa, ishkuman. U Taitta Diosne uruza kiwainnanazi, uskasa ɨninna. ");
INSERT INTO kwi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chiwazha mɨj aizpa painintain. Puizaruza mɨlanarain. Sunkana kimturuzne chiyura kwazpa kulanazi. Suane u pial tuh watsarawa. Suane walkumtuzne asachi. Suane kɨriyukas tuh tɨtsachi. ");
INSERT INTO kwi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chiyura kwazpa kulturuzne chiyuwa minñanazi, sua uzshiamtu akwa.” ");
INSERT INTO kwi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Wan pĩn kwat kit watsarain, kal kin. Alampara put unatpa. ");
INSERT INTO kwi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Une wat kiwainmikakanain uztain. Anpat pishtaras amtuasmin, une tɨriz kit ussa izarawa. At kit pɨjtakin piannapkane, masain wan pɨjta chɨhshina. ");
INSERT INTO kwi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kiwaintuzne izarawa, uspa anpatta izna. Sun kitne, wat kulanazi. Watcha kaiznamtus. Sun kapal sarɨttuzne, ussa izmuruzne, anpatpa uzmura uzanazi. Uspa anpatne usparuza misharɨ kumira nailnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anpatta tɨrizamtuasmin, watsarɨt izmuruzne wat kulanazi, kakwamtakima tɨlawainkimakas tɨrizarakas. ");
INSERT INTO kwi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","An piankamtain. Walkum akane, yalpamikane sun urara piankamsachi. Sun ura piankamtane, izkul kit yal watsashina, walkum napmanpa. ");
INSERT INTO kwi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kawarain, une wan kapal sarain. Ampu namtɨtmikane u tɨrizamtuchi payura anazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedrone ussa mɨmara: —Anpat, ¿Aumɨza sun kamtam kwinta kaiznamtukish? ¿Wan awaruza kaiznamtukish? ");
INSERT INTO kwi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Anpatne kaiznara: “Une wat kiwaintuza namtain, yalpamika ɨnintu aizpa kianapa. Yalpamikane wat kiwainmumikasha wan kal chɨhkamtu, wantuza kumira nailnana. ");
INSERT INTO kwi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kiwainmikane wat kulnazi, yalpamika kaizta aizpa sarane. Akane, yalpamikane us ka kimtu aizpa iznazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Watcha kaiznamtus. Kwiztane yalpamikane wan mɨj aizpa ussa chɨhkanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sunkana kiwainmumikane usmin ka min kit kaiznazi: ‘Ap anpatne azain kailtuchi.’ Suasne usne ampu kiwaintuzakas ashampa kiwaintuzakas aim kiamɨztu. Usne akkwan kumira kwat kit chappi kumɨztu, pinakima. ");
INSERT INTO kwi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kiwainmikane anpat kailtu payura pianchi. Anpatne sun kiwainmika tɨriztuchi payura anazi. Katmizna yalpamika akane, yalpamikane ussa tɨnta ilnazi, mɨmtuchiruzkasa puranpa. ");
INSERT INTO kwi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kiwainmikane anpat ɨnintu aizpa wat pian. Anpat kaizta aizpa kitchine, wan kapal sarachine, anpatne ussa tɨnta ilnazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Anpat kaizta aizpa pianchimikane an we ilnanazi. Dios mɨnpazhara akkwan mɨlatne, Diosne ussa paikumtu, an akkwan kailninna. Dios mɨnpazhara akkwan chɨhkatne, usne ussa an akkwan paikwannazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nane an sura arau, wan awara ilnana. Nane sun awara me naiznamtu pashiras. ");
INSERT INTO kwi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Au sukin uztuza naizarachasmin, nane kwisha naiznash, wan kinkima. ");
INSERT INTO kwi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Une ka minñamtu: ‘Nane an sura arau, wan awa kalpain uzanapa.’ Sunpa akwa atchish. Nane arau, awaruza nailnana. ");
INSERT INTO kwi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Makismin maza kwalne usparuzain waya kianazi. Kutñaruzne paaskasa waya kianazi. Paasne kutñaruza waya kianazi. Cincoruzne paimpa naiyanazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papihshne painkulta waya kinazi. Painkulne papihshta waya kinazi. Akkuhshne pashura waya kinazi. Pashune akkuhshta waya kinazi. Suegrane pashu kiznara waya kinazi. Pashu kiznane suegrara waya kinazi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesúsne akkwan awaruzakas kaiznara: “Wanish sɨpkane, ma payu alu kinazi. Suasne alu kimɨztu. ");
INSERT INTO kwi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inkwa pakane, pãn malkane, i kinazi. Suasne i kimtu. ");
INSERT INTO kwi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","U ‘au piankamtumakpas’ kizamtukas, une wat piankamtuchi. Une suwakas chiyuwakas iznin kit wat pian. Sunkana mane une Dios ukin kimtu aizpa wat piankamamtuchi.” ");
INSERT INTO kwi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Une uruzpain nil min kit nil aizpa narawa. ");
INSERT INTO kwi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sunkana kirain. Katsa mikwara miwara ɨntazasmin, nune nammɨlatmikasha pui aizpa kailnintawa. Pui aizpa kailnintukine, nammɨlatmikane nua katsa mikwara tain ɨnazi. Katsa mikwane nua policíawara chɨhkanazi. Policía awane nua kajchira sɨpnazi. ");
INSERT INTO kwi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Watcha kaiznamtus. Nune kajchiras puzmanazi, wan pui aizpa tanakima.” ");
INSERT INTO kwi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sun payurain mɨnpazha Jesústa ka kizara: —Galilea suras ampuruzne wakara kaarat kit piantara, Diosta mɨlan. Suane Pilatone usparuza piantaninnarɨt. Sunkana usne uspa aimpikas wakara aimpikas naarɨt, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesúsne usparuza sɨnkanara: “¿Chima minñamtu une? Galilea suras irɨttuzne, ¿mamaz Galilea awakin anza akkwan kwail kiarɨtki? ");
INSERT INTO kwi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uspane an akkwan kwail kiarachi. Une kwail kiarɨt aizpa maiztachine, kawarain une iarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","An kwiztane katsa uk yal kihsh nain kit diez y ocho Siloé awaruza appara. ¿Chi minñamtu une? Irɨttuzne mamaz Jerusalén awakin ¿anza akkwan kwail kiarɨtki? ");
INSERT INTO kwi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","An akkwan kwail kiarachi. Une u kwail kirɨt aizpa maizamtukine, une kawarain iarɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesúsne sun kamtam kwinta kainanara: “Ampune higuera tɨ warɨt mɨj wankail saura. Tɨra pippa saina ɨkane, chinkas sairachi. ");
INSERT INTO kwi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Suasne usne wankail sau kal kimmikasha kaizta: ‘Izti. Kutña añoin sun higuera tɨra at kit pippa sairau. Chinkas saimas. Tɨ kwaari. Kainsɨh kun.’ ");
INSERT INTO kwi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kal kimmikane ussa sɨnkara: ‘Anpat, mamaz añokima kawininti. Tɨ kwalkin pil kɨhtawane, nane wakara pɨ winnash, kawinapa. ");
INSERT INTO kwi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mamaz añora pippa wamtune, an wari. Pippa wammakane, suasne tɨ kwaarawa.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Suasne kwaizkulmu payura Jesúsne kammu yalta kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Suane saliz piztɨt ashampane tuara. Salizne ussa nil kunsachi panintɨt. Diez y ocho añokima sumtɨtmin chamtu akwa, usmin nil sasachi. ");
INSERT INTO kwi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ussa izkane, Jesúsne ussa akwat kit kaizta: —Ashampa, up ishtu kakulti. ");
INSERT INTO kwi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Suasne paiña chihtɨ ussa paamtuasmin, sun urain usne nil kun kit Diosta kaizta: “Nune kwisha wari.” ");
INSERT INTO kwi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kammu yal ɨninmikane Jesústa pilchapuzta, Jesús kwaizkulmu payura kakulnintɨt akwa. Usne awaruza kaiznara: —Seis payukima kal kitpamakpas. Seis payukima ishturuza kakulnintawa. Kwaizkulmu payura kakulninkain, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Suasne Jesúsne ussa sɨnkara: —Nune kwail minñamtu. Wat pit paratkas, nune wat kimtuchi. Up wakarakas mulakas pitmu yaltas chɨhtawane, nune kwaizkulmu payura kwazira taina ɨm, kwazi kwinna. ");
INSERT INTO kwi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","An ashampane Abrahampa kwal i. Satanásne diez y ocho añokima sun ishtukasa ussa kuhtɨt mɨjara. ¿An kwaizkulmu payura sun ishtumikasha kakulninshinaki? ");
INSERT INTO kwi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús sun kiztawane, ussa aliztuzne mɨtsal kiamɨzta. Jesús wat kal kit aizpa izarawane, mamaz awaruzne wat kulara. ");
INSERT INTO kwi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Suasne Jesúsne kamtam kwinta kaiznara: “Nane umɨza an kamtam kwinta kainanamtus, miza Dios awaruza ɨninnamtu piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dios kishimtu aizpa mostaza pippakana i. Ampune sun pippa paiña pilta wara. Warawane, chik kit katsa tɨ kunta. Akkwan chitchune aat kit tɨ tailpurara yal saara.” ");
INSERT INTO kwi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mamasa kaiznara: “Nane umɨza an kamtam kwinta kainammtus, miza Dios ɨninnamtu mɨaiznapa. ");
INSERT INTO kwi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dios kishimtu aizpa kiñakana i. Ashampane kutña harina wazkasa pitchin kiñakasa nara, wan harina sulnin kit pan sana.” ");
INSERT INTO kwi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén pɨpulurakima ɨmtuasmin, Jesúsne ainki pɨpulurakas katsa pɨpulurakas nap kit awara kamtanara. ");
INSERT INTO kwi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mɨnpazha ussa mɨmara: —Anpat. ¿Diosne akkwan awara watsat mɨlnanasa? Usne ussa kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Sɨp pɨjtakin, Dios ɨnintukin, sait kit naptawa. An kaiznamtus. Akkwan awane napnash minñamturuzne nappamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yalpamika kuhstawane, usne pɨjta sɨp kit kuhtu. Pianamal panaruzne, pɨjtakin piannap kit Anpatta ka kaizanazi: “Pɨjta chɨhti”. Usne usparuza sɨnkananazi: “Nane u mɨntas mai pianchish. Nane umɨza mama wanmaltachish.” ");
INSERT INTO kwi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Suasne une ussa kaizamɨznazi: “Aune nukasa kuwiznashɨ. Nune aumɨza au pɨpulura kamtanara.” ");
INSERT INTO kwi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Usne kaiznanazi: “Umɨza kaiznamtus. Nane u mɨntas mai pianchish. Mane uruza mama wanmaltachish. Paimpa ɨrain. Une wan kwail kimtuz mai.” ");
INSERT INTO kwi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Suasne une Abrahamtakas Isaactakas Jacobtakas Dios pit kamtamtuzakas Dios ɨnintukin izanazi. Tas kiakpɨntawane, uruzne azat kit sula sɨt sɨt kiamɨznazi, uspakasa uzsachi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Akkwan awane pãn payapmumal suraskas pãn puzmumal suraskas wan suraskas aanazi, Dios ɨnintukin uzana. ");
INSERT INTO kwi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iztain. Kwizta kanpamtuzne an ñancha ɨanazi. An ñancha pianattuzne kwizpa kanpaanazi. ");
INSERT INTO kwi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sun payuin mɨnpazha Fariseo awane aat kit Jesústa kaizara: —Akkis ɨmɨzti, Herodes nua piantashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Usne kaiznara: —Herodesne ɨnkal kwizakana i. Ussa ɨt kit ka kiztain: “Mɨri. Makas tɨlawakas saliz puzninmɨztus. Ishturuza kakulninnamtus. Mamaz payura ap kal pailtɨnash.” ");
INSERT INTO kwi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sunkana nane makas tɨlawakas kazilakas ɨmɨztawash, ap kal pailnakima. An ñamin Dios pit kainammtuzne Jerusalén pɨpulura iara. Nakas Jerusalén pɨpulura irawash. ");
INSERT INTO kwi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén pɨpulu uztuzne Dios pit kainammtuza piantaara. Une Dios ɨnintaruza uk kiat kit piantaara. Aral kam kwaj kwaj kiztawane, paiña pashpane ilsɨhman ayukmal nap uzarɨm. Kawarain nane uruza akwanat kit wanmakninnashirau. Sunkana une nawa wanmakkashitchi. ");
INSERT INTO kwi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iztain. Diosne uruza kwayarɨnazi, paimpa uzanapa, kwairɨt yalkana. Mamasa umɨza kaiznamtus. Une akwan payukima nawa izamanazi. Mamaz payura u nawa izakane, une ka kaizanazi: “Nune kwisha wari. Diosne nua ɨninta.” Sun kizarawane, mamasa une nawa izarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Maza kwaizkulmu payura Jesúsne Fariseo ɨninmikawa yalta kwan ɨrɨt. Mamaztuzne us kimtu aizpa izara. ");
INSERT INTO kwi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Suane Jesús iztakin kiparɨt ampune tuara. ");
INSERT INTO kwi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesúsne Moisés parɨt aizpa kamtamtuzakas Fariseo awaruzakas mɨmanara: —¿Kwaizkulmu payura ishtura kakulninshinaki? mɨmanara. ");
INSERT INTO kwi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Uspane puñain paarɨt. Suasne ussa piz kit parawane, Jesúsne ishtura kakulnin kit paiña yalta ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesúsne usparuza mɨmanara: —Up painkulkas up wakarakas kwaizkulmu payura pi kulta taiztane, sun urain, sun kwaizkulmu payura une ussa pil kultas tainnaknazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Uspane chinkas sɨnkamanamarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pishtara akwattuzne ayukta nappat kit an wat uzmuruza naara. Jesús akwattuz an wat uzmukin naarɨt iztawane, Jesúsne an kamtam kwinta kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Mɨnpazha nua kasara kin pishta akwanakane, an wat uzmu narɨtkin uzman. Nukin anza tɨnta ampu akane, akwatmikane ɨt kit nua kaizshina: ‘An anza tɨnta awane up uzmu narɨtkin uznazi.’ Sun uzmukis puztawane, nune mɨtsal kinazi, mamaz an we uzmura nana saimtuasmin. ");
INSERT INTO kwi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sunkana mɨnpazha nua pishtara akwanakane, ɨt kit minpa uzmura uztawa. Nu minpa uzmura uztuasmin, akwatmikane ka kizshinai: ‘Izmuruz. An wat uzmura uztain.’ Suasne wan akwarɨttuzne nuwa anza tɨnta i minñamɨznazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mɨnpazha ussain anza tɨnta namtashitne, Diosne ussa an we tɨnta namnintɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesúsne an akwatmikasha kaizta: —Paizka payurakas nashkarakas kumira kwinnakane, izmuruzakas aimpihshtuzakas kwaltuzakas kwazparuza akwanamun, uspa nua kwan akwanashimtu akwa. Maizta maizta kuanazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sunkana pishta kumira sarane, puizaruzakas, chasachi inturuzakas, mittɨ kwailtuzakas, kasu sɨptɨttuzakas akwanarain. ");
INSERT INTO kwi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sun kitne, une wat kulanazi. Uspane ukasa kumira maizasachi. Diosne wat uztuza kuhsninnanazi. Sun kuhstu payura Diosne umɨza chiwazha mɨlnanazi, nukasa chinkas maizsachiruza pishtara akwanarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mazane Jesúskasa misharɨkin uzta. Us Jesús kaizta aizpa mɨrawane, ussa kaizta: —Kumira kumtumikane Dios ɨnintukin wat kulnazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesúsne ussa sɨnkara: —Maza ampune kwisha akkwan kumira sanin kit akkwan awara akwaninnara. ");
INSERT INTO kwi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kumira kumtu urara usne paiña kiwaintuza akwarɨttuza ɨninnara ka kizna: “Arain. Kumira kapal sarɨt. Kwanpain.” ");
INSERT INTO kwi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sunkana wanne “nane asachish” kizamɨzta. An ñanchamikane kiwainmikasha ka kaizta: “Nane mamaz su pairau. Nane izna ɨrɨmtus. Ɨmtukine, up anpatta paikwatpa, nawa wat kulnapa.” ");
INSERT INTO kwi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mamazkas kaizta: “Nane diez wakara pairau. Nane usparuza izna ɨrɨmtus, kal kiamtuasmin. Ɨmtukine, up anpatta paikwatpa, nawa wat kulnapa.” ");
INSERT INTO kwi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mamazkas kaizta: “Mamin nane ashampakasa kasara kirau. Katmizna nane ɨsachish.” ");
INSERT INTO kwi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Suasne kiwainmikane paiña anpatta ɨt kit sun awa sɨnkara aizpa piankamninta. Suasne yalpamikane usparuza aliz pat kit kiwainmikasha kaizta: “Azain pɨpulura katsa miwarakas ainki miwarakas ɨtpa. Tas puizaruzakas, chasachi inturuzakas, mittɨ kwailtuzakas, kasu sɨptɨttuzakas, yaltakima kararain, kuanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kiwainmika tas kailtawane, kaizta: “Anpat. Nu kaizta aizpa kirau. Mama nan wai.” ");
INSERT INTO kwi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Anpatne kiwainmikasha kaizta: “Attish miwara ainki miwara ɨt kit awara akwanat kit kararain, ap yalta akkwan awa punanapa. ");
INSERT INTO kwi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nane umɨza kaiznamtus. An ñancha akwattuzne na kumira sarɨt aizpa kuamanazi.” Katmizna an ñancha pishtara akwattuzne Diosta saptuchiruzkana mai, anpatpa pishtara ɨarachi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Akkwan awane ussa kanpaara. Jesúsne puij kit usparuza kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mɨnpazha ap kanpammika namshitne, usne nawa mamazpakin an akkwan pashitpa. Usne paiña papihshtakas akkuhshtakas ashamparakas pashparakas aimpihshtakas kwampihshtakas usminkas an we pashitpa. Usparuza nakin an pashimtumikane ap kammumika namsachi. ");
INSERT INTO kwi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ap kanpammikane nakana naizshitchine, ap kammumika namsachi. ");
INSERT INTO kwi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mɨnpazha katsa yal min kit sashitne, usne an ñancha yawa muin wian iztu. Usne usmin mɨmamtu: ‘¿Kapal pailnapain mɨjish?’ ");
INSERT INTO kwi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wan wiantuchine, yal sana masarawane, wan yal pailmanamtɨkane, wan awane sun izat kit yal sammikasha ishananazi. ");
INSERT INTO kwi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ka kaizanazi: ‘Yal sana masaramikane, yal pailmanamtɨt.’ ");
INSERT INTO kwi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","An mɨrain. Katsa mikwane mamaz katsa mikwara waya kishitne, an ñancha usne ka min kit mɨmamtu: ‘Mamaz katsa mikwa veinte mil awa mɨjne, ¿nane diez mil awakasa waya kitne, kana kishinasa?’ ");
INSERT INTO kwi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kana kimanamtɨkane, mamaz katsa mikwa attishtas amtuasmin, usne paiña pit ɨnin kit ussa paikumtu, izmuruz namnapa, waya kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Katmizna, mɨnpazha wan mɨj aizpa chɨhkamtukine, usne ap kanpammika namsachi.” ");
INSERT INTO kwi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nawa kanpamtuchimakane tɨh ñamkana i. Mane ñamne wari. Sunkana tɨh ñamne, mamasa ñam kulsachi. ");
INSERT INTO kwi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kwail ñamne chiwa palichi. Awane sun kiakpɨntɨm. U kail waj akwa, na kaiztu aizpa mɨrain.” ");
INSERT INTO kwi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wan Roma gobierno pial sapmuruzkas wan kwail kimtuzkas Jesústa kashara wanmakkara, ussa mɨana. ");
INSERT INTO kwi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseo awakas Moisés parɨt aizpa kamtamtuzkas Jesústa kwail kizat kit kaizara: —An ampune kwail kimturuza akwanamtu, uspakasa kwan. ");
INSERT INTO kwi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Suasne Jesúsne an kamtam kwinta kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mɨnpazha cien pɨriku mɨjazi. Maza pɨrikune ɨnkalpara karɨt. Noventa y nueve pɨriku chɨhkarawane, pɨrikuwamikane ɨmtu, pɨriku karɨtta sainakima. ");
INSERT INTO kwi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pɨrikura sairawane, usne watsal kul kit sail waktamta tanak kit mumtu. ");
INSERT INTO kwi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yalta pianatpane, usne izmuruzakas makis uzturuzakas akwanat kit kaiznamtu: ‘Nakasa wat kularawa. Nane an pɨriku karɨtta sairau.’ ");
INSERT INTO kwi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kawarain kaiznamtus. Kwail kimmika paiña kwail kirɨt aizpa maizta akwa, chiyura uztuzne an wat kulanazi. Akkwan awa uspa kwail kiarɨt aizpa maizashimtuchine, chiyura uztuzne wat kulasachi.” ");
INSERT INTO kwi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Maza ashampane diez pial mɨjazi. Maza pial karɨtne, usne impil put kit yal pishkat kit pial saimtu, wanmalnakima. ");
INSERT INTO kwi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pial wanmaltawane, usne izmuruzakas kasha uztuzakas akwanat kit kaiznamtu: ‘Nakasa wat kultain. Nane sun pial karɨt aizpa wanmaltau.’ ");
INSERT INTO kwi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kawarain kaiznamtus. Diospa ángeltuzne wat kulanazi, kwail kitmika paiña kwail kirɨt aizpa maiztane.” ");
INSERT INTO kwi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesúsne mamaz kamtam kwinta kaiznara: “Maza ampune paas painkulkasa uzta. ");
INSERT INTO kwi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","An ainkimikane papihshta kaizta: ‘Taitta. Nawa paimpa su mɨlazha. Papihshne uspa paasta sukas chiwazha saptu aizpakas mɨlanara.’ ");
INSERT INTO kwi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Akkwan payu chikima an ainkimikane paiña wan su painin kit attish sura ɨmɨzta. Kwail kimtu uztuasmin, pane usne paiña su painintɨt pial wan pailta. ");
INSERT INTO kwi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wan pial mɨj aizpa pailtawane, chinkas mɨjchi kirɨt. Pane kumtu mɨjchi akwa, akkwan awakas yak kiara. ");
INSERT INTO kwi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uskas yak kimtu akwa, usne sun su awara ɨt kit kal saira. Sun anpatne ussa paiña sura ɨninta, kuzu kwira kinpa. ");
INSERT INTO kwi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Usne kuzu kum kumira kwashira. Sunkana mɨnminkas ussa kwintachi. ");
INSERT INTO kwi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Usmin min kit nɨjkul kit kaizta: ‘Ap taittane kwisha akkwan kiwaintuza ɨninnamtu. Uspane akkwan kumira mɨj, tizawal. Nain akkin inapain ish, kumtuchi akwa. ");
INSERT INTO kwi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nane ap taitta uztukin kailtɨnash. Sua ka ussa kaiznash: Taitta. Nane Dios iztakinkas nu iztakinkas kwail kirɨt ish. ");
INSERT INTO kwi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nane wat chi ish. Nawa ap painkul i kizmun. Up kiwainmikakana kal kishimtus,’ minta. ");
INSERT INTO kwi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Suasne usne kuhs kit papihshpa yalta kailta. Painkul amtuasmin, papihshne attishta ussa izta. Usne us akwa tayal kit ussa kiwainta. Papihshne ussa ãĩn ɨt kit saiyakwaat kit putchunta. ");
INSERT INTO kwi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Painkulne ussa kaizta: ‘Taitta. Nane Dios iztakinkas nu iztakinkas kwail kirɨt ish. Nane wat chi ish. Nawa ap painkul i kizmun,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Papihshne kiwaintuza kaiznara: ‘Azain an watsal pĩn karatpa, us kwanapa. Sultikashkas paiña chihtɨ tɨppura nuktawa. Zapatokas paiña mittɨkin nuktawa. ");
INSERT INTO kwi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pɨntɨt ainki wakara karat kit piantari. Kuwizsan. Pishta sawizsan. ");
INSERT INTO kwi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na ap painkul irɨtka mintakas, usne uztu. Usne mamaz sumal ɨt kit karɨt. Manta wanmal ish.’ Suasne pishta saamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Painkul ɨlapamikane nanmal kal kimtuazi. Tas kail kit yalta kasha akane, usne música mɨra. Kukiamtu izta. ");
INSERT INTO kwi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Usne maza kiwainmumikasha akwat kit ka mɨmara: ‘¿Sun awane chima kiamtui?’ ");
INSERT INTO kwi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Usne ussa sɨnkara: ‘Up aña ainki kailtai. Watmin kailta akwa, up taittane pɨntɨt wakara nakta.’ ");
INSERT INTO kwi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Painkul ɨlapamikane aliz kul kit yalta napshitchi. Suasne papihshne ustukin ɨt kit kwisha akwara, napnapa. ");
INSERT INTO kwi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Usne papihshta sɨnkara: ‘Izti. Akkwan añokima nua kiwaintuarau. Wan nu kaizta aizpa kirɨtkas, nune nawa pɨriku pashpa mɨlamash, ap izmuruzkasa pishta sana. ");
INSERT INTO kwi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sunkana mane up painkul, kwail ashampakasa pittɨtmika, u pial kwairɨtmika piannakane, nune us akwa pɨntɨt ainki wakara nakta.’ ");
INSERT INTO kwi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Papihshne ussa kaizta: ‘Ap painkul, mɨri. Nune wan payukima nakasa uztu. Wan na mɨj aizpa up i. ");
INSERT INTO kwi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sunkana kwisha wari pishta sana, wat kulana. Aune up aimpihsh irɨtka mintamakpas. Ma uztu. Usne mamaz sumal ɨt kit karɨt. Manta wanmal ish,’ ” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesúsne kammuruza an kamtam kwinta kaiznara: “Kwazpa anpatne su izmumika mɨjazi. Mamaztuzne anpatta kaizara: ‘Up su izmumikane nu mɨj aizpa wat iztuchi. Up pialkas kain kwaimtu.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Suasne anpatne paiña su izmumikasha akwanin kit kaizta: ‘Nu kit aizpa mɨrau. Nu pial tarɨt aizpakas wan nu kit aizpakas kainazha. Nune ap su izmumika an nammanazi.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Su izmumikane usmin minmɨzta: ‘Ap anpat ap kal ukkarane, ¿chima kinpai? Nane pil kal kisachish. Mɨtsalish pial paikwan. ");
INSERT INTO kwi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akkis puzkane, ap kal mɨjchine, nane na kishimtu aizpa pianish, mamaz awa nawa sappanapa.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Suasne izmumikane anpatpa puiruza maza mazain akwanara. An ñancha puimikasha mɨmara: ‘¿Yawama anpatta puikish?’ ");
INSERT INTO kwi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Usne kaizta: ‘Nane cien pihshpi winmu pui ish.’ Usne ussa kaizta: ‘Apain uzti. Pui parɨt pɨnkɨhta sap kit azain cincuenta winmu pui ish pat kit kizti.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Suasne mamaz puimikasha mɨmara: ‘¿Yawama anpatta puikish?’ Usne ussa kaizta: ‘Nane cien chara tɨm pui ish.’ Usne ussa kaizta: ‘Pui parɨt pɨnkɨhta sap kit ochenta chara tɨm pui ish pat kit kizti.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Anpatne kwail su izmumika kirɨt aizpa nɨjkul kit ussa kaizta: ‘Nu yawa kwailkas, nune pɨna pian, up wat kal pailnakima.’ Ma payu uztuzne tɨmpa chi, uspa mɨj aizpa an wat ɨninnashimtu akwa, uspa pashimtu aizpa kana kinpa. Masetne Diosta piantuzne an we kiamtu, mamaztuzkasa wat uzana, chiyura nuana. ");
INSERT INTO kwi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nane uruza ka kurunamtus. Sun izmumikane anpatpa pialkasa kwail kit kit izmuruz namnapa, an sura an akkwan payu uznapa. U pial mɨj aizpa mamaztuza kiwainarain, Dios uruza sapnanapa. Wan pial pailtawane, imtu payura Diosne uruza pialkin an wat chiwazha chiyura mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pitchin pial watsammikane an akkwan pialkas watsanazi, sun pial kain kasta kitchi akwa. Pitchin pial watsamtuchimikane an akkwan pialkas watsamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Apas pial watsamtukine, mɨnminkas uruza chiwazha chiyura mɨj aizpa mɨlanamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Patna nil watsamtukine, mɨnminkas uruzpa mɨlamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Maza kiwainmikane paas anpatta kiwainsachi. Mazara pashitkine, mamazta pashinazi. Mazara kiwainshimtune, mazara kiwainmanazi. Mɨnpazha Diostakas pialtakas parejuin pashimanazi. Diosta pashit kit wakpuj waintane, pialta pashimtuchi.” ");
INSERT INTO kwi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo awane, pial pashimturuzne, wan mɨara. Uspane Jesúspa kwail ultimal kizara. ");
INSERT INTO kwi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Usne usparuza kaiznara: “U awaruzpain wat awakana izninnamtukas, Diosne wan u minñamtu aizpa pian. Awa chiwazha tɨnta i mintuasmin, Diosne awa minñamtu aizpa kwail i,” kiztu. ");
INSERT INTO kwi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Awane Dios pɨnkɨh para aizpakas kamtammika kaizta aizpakas kamtanara, Juan munnammika ankima. Sun payuin, Juan atpane, nane Dios watsal pit kamtanamɨzta, awa Dios ɨnintukin nappanapa. Mane Diosne akkwantuza ɨninnamtu, awa nappashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Chiyukas au sukas karɨnazi. Dios anza ainki pitne kamanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mɨnpazha paiña ashampara kwait kit mamaz ashampakasa kasara kitne, an ampune Dios iztakin kwail kimtu. Ampu mamazpa kwairɨt ashampakasa kasara kitne, usne Dios iztakin kwail kimtu.” ");
INSERT INTO kwi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Maza kwazpa ampune uzta. Usne muin ishtam pĩnkas watsal pĩnkas kwaara. Usne pailta payu kwisha watsal kumira kwara. ");
INSERT INTO kwi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Maza puiza ampune, Lázaro muntɨtmikane, kwazpa awa napmu pɨjtakin uzara. Paiña ña pɨttɨt ishtuazi. ");
INSERT INTO kwi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chiwazha kwazpawa misharɨras pak taizka kwashira. Kwizakas ussa at kit paiña ishtu ña yakshira. ");
INSERT INTO kwi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Puiza ampu irawane, ángeltuzne ussa Abraham tukin watsal chiyura sukin mɨlarɨt. Kwazpa ampukas irawane, pilta kamta. ");
INSERT INTO kwi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Irɨt uztukin naiztuasmin, kwazpamikane izak kit attishtain Abrahamta izta. Lázarokas uskasa uzara. ");
INSERT INTO kwi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kwazpamikane ka tɨnta kwianta: ‘Ap taitta Abraham. Nawa iz kit kiwaincha. Nawa Lázarora ɨninti, tɨppu kwazira painnapa. Paiña tɨppukasa kwazi pɨtnin kit kwincha ap pitkin, tɨh kinpa. An ĩnkin naiztus.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamne ussa kaizta: ‘Ap painkul. Nu miza uzta nɨjkulti. Nune chiwazha wat aizpa sapta. Kawarain Lázarone chiwazha kwail aizpa sapta. Mane usne apain wat uztu. Nune pa kwisha naiztu. ");
INSERT INTO kwi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ankas nɨjkulti. Auruzpain katsa sanja tu. Apa uzmikane nu tukin kwakara kwaksachi. Pa uzmikane auruzakin kwaksachi.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kwazpamikane kaizta: ‘Suasne, taitta, nua paikumtus, Lázarora ap taittawa kwalta ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sua cinco aimpihsh mɨj ish. Usparuza kurunari, an naizmu sura aamanpa.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamne kaizta: ‘Uspane Moisés pɨnkɨh para aizpakas Dios kamtamtuz pɨnkɨh para aizpakas mɨj. Uspane sun pɨnkɨhkin parɨt aizpa izat kit mɨat kit kiarawa.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kwazpamikane sɨnkara: ‘Ap taitta Abram, mɨzha. Uspane usparuza mɨamanazi. Mɨnpazha irɨtmika mamasa irɨttas kuhstane, mɨnpazha usparuza apas ɨmtune, uspane mɨat kit uspa kwail kiamtu aizpa maizanazi.’ ");
INSERT INTO kwi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sunkana Abrahamne ussa kaizta: ‘Moisés kaizta aizpakas Dios kamtamtuz kaizta aizpakas mɨashitkine, uspane mamazta mɨamanazi. Irɨt kuhstumika usparuza ɨmtukas, mɨamanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesúsne paiña kammuruza kaiznara: “Mɨnpazha mamazta kwail kininanazi. Sunkana mamazta kwail kininmikane kwisha naiztɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mamazta kwail kininmikane an watshimasa inna. Katsa kɨmu ukkasa tɨmpukin kuhtawane, awane ussa katsa ñam pira kiakpɨntawa, Dios pit we mɨmtumikasha kwail kimanpa. ");
INSERT INTO kwi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Uruzpain kwiraruin. Aimpihsh kwail kitne, ussa ‘kwail kimun,’ kiztain. Paiña kwail kirɨt aizpa maiztane, nune paiña kwail kirɨt aizpa wat kultawa. ");
INSERT INTO kwi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mɨnpazha nua siete pijikima kwail kirɨtne, us puij kit nua ‘ap kwail kit aizpa min kit chɨhkamtus’ kiztane, nune paiña kwail kit aizpa wat kulnintawa.” ");
INSERT INTO kwi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesúspa ɨnintaruzne Anpatta kaizta: —Aumɨza kiwainchain, Diosta an akkwan nɨjkulana. ");
INSERT INTO kwi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Anpatne kaiznara: —Dios kaizta aizpa nɨjkul kit kitpa. Pitchinmin nɨjkultane, une an katsa tɨra ka parashina: “Piltas puhsnin kit pi pɨnta wari.” Sun kaiztawane, an tɨne nu kaizta aizpa mɨshina. ");
INSERT INTO kwi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kiwainmika nantas akane, pil kɨhtawane, pɨriku iztawane, anpatne ka ussa kaizmanazi: ‘Azain at kit misharɨ kwan uzti.’ ");
INSERT INTO kwi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Anpatne ussa sunkana ka kaiznazi: ‘Up kamisha maiztawane, ap kumira sari. Suasne nawa kumira nail kit kwincha, ap kumira pailnakima. An kwizta nuin kumira kwashina.’ ");
INSERT INTO kwi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Usne kiwainmikasha aishtaish kaizkain, us anpat kaizta aizpa kirɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kawarain u Dios ɨninta aizpa kiarawane, une ka kizarawa: ‘Aune watchi kiwainmika makpas. Aune au anpat kaizta aizpain kitmakpas.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén pɨpulura ɨmtuasmin, Jesúsne Samaria suwarakas Galilea suwarakas pɨnta. ");
INSERT INTO kwi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Pɨpulura naptuasmin, diez aya pɨttɨt ishturuzne kunat kit attishtas Jesústa izara. Ussa paikuara: —Jesús. Au Kamtam. Aumɨza iznat kit kiwainnaka. ");
INSERT INTO kwi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Usparuza iznarawane, Jesúsne kaiznara: —Pariyara ɨrain, uruza iznanapa. Miwara ɨamtuasmin, uspane kakultɨt. ");
INSERT INTO kwi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wat parɨt nɨjkultawane, mazain usparuztas kail kit ka tɨnta kwianta: “Diosne kwisha wari.” ");
INSERT INTO kwi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Usne Jesúspa mittɨkin wakpuj wain kit kaizta: “Aishtaish.” An ampune Samaria sura uzta. ");
INSERT INTO kwi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Suasne Jesúsne mɨmara: —Diez aya pɨttɨt ishturuza kakulninnarau. ¿Mamaz nueve ampu mɨntama purai? ");
INSERT INTO kwi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","An Samaria suras awain kailta, “Diosne wari” kizna. Au Israel kwalne “Diosne wari” kizashitchi. ");
INSERT INTO kwi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesúsne ussa kaizta: —Kuhs kit ɨri. Na kaizta aizpa nɨjkulta akwa, nune kakultɨt. ");
INSERT INTO kwi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo awane Jesústa mɨmaara: —¿Miza urama Dios ansa, awaruza ɨninna? Jesúsne usparuza sɨnkanara: —Mɨnminkas miza Dios ɨnintu izamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awane “Apain pura, sua pura,” kizamanazi. Dios ɨninakane, usne uruza, u kaijchura, ɨninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Suasne usne kammuruza kaiznara: —Akkwan payukima apain uzamtuasmin, une Dios Painkul kailtu payura izshianazi. Une sun amtu payura ussa izamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Awane uruza ka kiznanazi: “Sua iztain. Sua tui. Apain iztain. Apain tui.” Ka kizarane, usparuza kanpaman. ");
INSERT INTO kwi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Amta ippa aztune, ĩn kwan kikimtu. Ippa kwan kikim. Kawarain Ampu namtɨtmikane ippakanain azain anazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","An ñancha usne akkwan naiztɨnazi. Ma payu uztuzne ussa kwayarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Noé uzasmin, wan awane tɨrakukas kumirakas kuara. Ampukas ashampakas kasara kit kit uzara. Noé kanuara warawane, Diosne alu kinin kit pi pɨnninta, wan awa ianakima. Ampu namtɨtmika mamasa akane, awane sunkana uzanazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kawarain Lot uzasmin, wan awane tɨrakukas kumirakas kuara. Uspane pait kit paininara. Pippa waara. Yal saara. ");
INSERT INTO kwi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sunkana an payura Lot Sodoma pɨpuluras puzkane, Diosne ĩnkas uk ĩnkanakas chiyuras taizninnara, wan awa ianapa. ");
INSERT INTO kwi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dios Painkul akane, wan awane sunkana uzanazi. Sun payura uspane ussa izananzi. ");
INSERT INTO kwi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sun naizmu payura mɨnpazha yal ɨsalta puraruzne yal ayukta napman, chiwazha ukkana. Kawarain mɨnpazha nanta kal kitne, yalta kailman. ");
INSERT INTO kwi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotpa ashampa nɨjkultain. Us puij iztuasmin, usne ñam wan namta. ");
INSERT INTO kwi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Us akwa uzshimtumikane wan karɨnazi. Na akwa imtumikane uznazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","An kaiznamtus. Sun amtane paas ampu kamarain pitpailnazi. Diosne mazara chiyura nuninnazi. Mazara tɨwij ɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Paas ashampane sulmin pia kɨilnazi. Diosne mazara chiyura nuninnazi. Mazara tɨwij ɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Paas ampune nanta kal kiilnazi. Diosne mazara nuninnazi. Mazara tɨwij ɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Suasne uspane ussa mɨmaara: —¿Anpat mɨnta sun kirɨnsa? Jesúsne usparuza sɨnkanara: —Kalpa irɨttukin pɨkumne kuana wanmakkanazi. Kawarain mɨnpazha kwail kikane, suain paiña kwail akwa naiztɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesúsne usparuza an kamtam kwinta kaiznat kit kamtanara, pailta payukima Diosta paikuanapa, Dios sɨnkanakima. ");
INSERT INTO kwi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Usparuza kaiznara: “Katsa mikwane, Diosta ishkwatchimikane, mamaz pɨpulura uzta. Wan awaruza wat nɨjchiwal kinara. ");
INSERT INTO kwi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","An pɨpulukimin maza ampu irɨt ashampakas uzta. Usne pailta payu katsa mikwara ɨt kit kaizta: ‘Kiwaincha. Na akwa nil kizha. Maza aliz ampune nawa kwail kirɨt.’ ");
INSERT INTO kwi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Akkwan payukima katsa mikwane ussa kiwainshitchi. An ampu irɨt ashampa ussa kwail kizapta akwa, kwiztane usne ussa kaizta: ‘Diosta ishkwatchikas, wan awaruza wat nɨjchiwal kinarakas, ");
INSERT INTO kwi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","akkwan payukima nawa amtu akwa, usne nawa kaizaptu. Katmizna nane nil kit kit ussa kiwainash, nawa an kaizapmanpa.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Anpatne an kaiznara: “Sun kwail katsa mikwa kaizta aizpa mɨrain. ");
INSERT INTO kwi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Diosne narɨttuza nil kit kit kiwainashinazi. Diosne payuwara amtawara ussa paikumturuz paikuamtu aizpa sɨnkananazi. ");
INSERT INTO kwi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Watcha kaiznamtus. Usne azain nil kit kit kiwainanazi. Sunkana ampu namtɨtmika akane, ¿Dios pit nɨjkulturuza wanmalnasa?” ");
INSERT INTO kwi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesúsne awara mamaz kamtam kwinta kiznara. Mamaztuzne usparuzpain wat makpas minñat kit mamaztuzpa kwail minñara. ");
INSERT INTO kwi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ka kaiznara: “Paas ampune Dios katsa yalta nuilta, Diosta paikwan. Mazane Fariseo awa azi. Mamazne Roma gobierno pial sapmumika azi. ");
INSERT INTO kwi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo awane kun kit usminpain ka kwinta kirɨt: ‘Nane Diosta aishtaish kaiztus, na mamaz awakana chi akwa. Uspane walkumtuz mai. Uspane kwail kimtuz mai. Uspane mamazpa ashampa mɨlamtuz mai. Nane an Roma gobierno pial sapmumikakana chi ish. ");
INSERT INTO kwi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nane domingo aizpa paas piji kumtuchish. Nane kana kit aizpa diez paimpa nail kit maza paimpa puizara mɨlamtus.’ ");
INSERT INTO kwi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gobierno pial sapmumikane attishtain kun kit chiyurain izakshitchi. Us kwail tayaltu akwa, paiña pitchukin paat kit kaizta: ‘¡Dios. Nane kwail kirau. Nawa kiwain kit ap kwail kit aizpa kanincha!’ ");
INSERT INTO kwi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Watcha kaiznamtus. Dios paiña kwail kit aizpa wat kultawane, gobierno pial saptumikane paiña yalta kailta. Mamazne, Fariseo awane, wat kultachin kailta. Mɨnpazha usparuzain anza tɨnta namtashitne, Diosne usparuza an we tɨnta namnintɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mane awane Jesústa pashparuza karaara, usparuza paninnanapa. Kammuruz sun izarawane, uspane awaruza kaiznara: “Pashpa Jesústa karaman.” ");
INSERT INTO kwi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sunkana Jesúsne pashparuza akwanat kit kaiznara: “Une pashparuza nawa anintain. Une ‘Jesústa ɨman’ kizman. Pashparuz Jesústa aashimtu akwa, Diosne usparuza ɨninnashina. Pashpakana uztain, Dios uruza ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Watcha kaiznamtus. Diosne uruza ɨninnashimtu. Pashparuzne Dios kaizta aizpa mɨashimtu. Kawarain Diosta mɨrain, Dios umɨza ɨninnanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Maza katsa mikwane Jesústa mɨmara: —Wat kamtam. ¿Chima kinpai, chiyura pailta payukima uzna? ");
INSERT INTO kwi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsne ussa sɨnkara: —¿Chitma nawa wari kiztus? Diosmin wari. Mɨnminkas wat chi. ");
INSERT INTO kwi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nune Dios ɨninta aizpa pian: “Mamazpa ashampakasa pitmun. Piantamun. Walkumun. Mamazpa pɨrail kaizmun. Up taittawakas up akkwawakas wat paranari.” ");
INSERT INTO kwi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Katsa mikwane kaizta: —Nane ainkiasmin Dios wan ɨninta aizpa kirau. ");
INSERT INTO kwi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sun mɨrawane, Jesúsne ussa kaizta: —Nune mama pitchin we kirɨt. Wan mɨj aizpa painin kit puizara mɨlanari, chiyura kwazpa kulna. Suasne at kit nawa kanpazha, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sun mɨrawane, usne tayalmɨzta, akkwan pial mɨj akwa. ");
INSERT INTO kwi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesúsne ussa iz kit kaizta: —Kwazpamikane Dios ɨnintura wat nusachi. Sua napna sam i. ");
INSERT INTO kwi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camellone caballokana i. Camellone chɨhku kasura mizurainkas napsachi. Kawarain an sam i, kwazpamika Dios ɨnintura napna. ");
INSERT INTO kwi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sun mɨraruzne iztaspaat kit kaizara: —Katne, ¿Mɨnma watsat mɨlshinasa? ");
INSERT INTO kwi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesúsne sɨnkanara: —Diosne awa kimtuchi aizpa kishina. ");
INSERT INTO kwi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedrone Jesústa kaizta: —Izti. Aune au mɨj aizpa tɨwij ɨt kit nua kanparamakpas. ");
INSERT INTO kwi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Usne kaiznara: —Watcha kaiznamtus. Dios ɨninta aizpa mɨmtumika yalkas, ashampakas, kwampihshkas, aimpihshkas, papihshkas, akkuhshkas, pashpakas tɨwij ɨtne, Diosne apain an akkwan mɨlananazi. Mamaz payura Diosne chiyura uzninanazi, pailta payukima. ");
INSERT INTO kwi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesúsne doce kammuruza paimpa akwanat kit kaiznara: “Mane Jerusalén pɨpulura numɨzchain. Sua ñamin Dios kainammmika Ampu namtɨtmikawa parɨt aizpa kinazi. ");
INSERT INTO kwi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Uspane mamaz Judío awachiruza nawa chɨhkaanazi. Uspane nawa ultimal kizanazi. Nawa kwail kizanazi. Nawa ilpi kianazi. ");
INSERT INTO kwi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nawa aim kiat kit piantaanazi. Sunkana kutña payu pailkane, nane kakulnash.” ");
INSERT INTO kwi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kammuruzne Jesús kaizta aizpa chinkas mɨarachi. Jesús kaizta aizpa puintɨt akwa, piankamasachi. ");
INSERT INTO kwi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó pɨpulura kasha piannamtuasmin, kasu sɨptɨtmikane mimamin uz kit pial paikumtuazi. ");
INSERT INTO kwi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Akkwan awa pɨnnamtu mɨrawane, usne awara mɨmanara: “Sun ampune ¿chima kimtui?” ");
INSERT INTO kwi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Uspane ussa sɨnkaara: —Jesúsne, Nazaret pɨpuluras, pɨntu. ");
INSERT INTO kwi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Suasne usne ka tɨnta akwara: —Jesús, nune au ñamin Davidpa pampa pashpa i. Nawa iz kit kiwaincha. ");
INSERT INTO kwi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","An ñancha ɨmturuzne ussa kurunaara, kalpain uznapa. Usne an tɨnta akwat kit kaizta: —Jesús, nune au ñancha Davidpa pampa pashpa i. Nawa iz kit kiwaincha. ");
INSERT INTO kwi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Suasne Jesúsne kun kit kaiznara: —Une ussa nawa kararain. Us Jesúspa kasha piannakane, Jesúsne ussa ka mɨmara: ");
INSERT INTO kwi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Chima nua kinpai? ¿Chima pashimtus? Usne ka sɨnkara: —Anpat. Kasu izkulnincha. ");
INSERT INTO kwi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesúsne ussa kaizta: —Kasu izti. Nawa nɨjkulta akwa, kasu izkulti. ");
INSERT INTO kwi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sun urain usne izkul kit Jesústa kanpat kit kaizta: “Diosne kwisha wari.” Sunta izamtuasmin, wan awane kaizamɨzta: “Diosne kwisha wari,” kizara. ");
INSERT INTO kwi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesúsne Jericó pɨpulura nap kit pɨnmɨztuazi. ");
INSERT INTO kwi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Suane maza ampune, Zaqueo muntɨtmikane, uzta. Usne Roma gobiernowa kal kit kit uspa katsa pial sapmumika azi. Uskas kwazpamika azi. ");
INSERT INTO kwi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Usne Jesústa attishtain iz kit piankamshira. An tam awane akkwan awa akwa ussa izmanamtɨt. ");
INSERT INTO kwi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Suasne usne an ñancha ãĩn ɨra, Jesús sun miwara pɨntu akwa. Suasne usne Jesústa izna tɨra nut kit uzta. ");
INSERT INTO kwi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesúsne us tukin pianat kit ussa izak kit kaizta: —Zaqueo. Azain kihshti. Mane nane nukasa up yalta nukkulnash, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Suasne Zaqueone azain tɨras kihsh kit wat kul kit ussa paiña yalta mɨlta. ");
INSERT INTO kwi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wan awa sunta izarawane, uspane usparuzpain Jesúspa kwail kizat kit ka kaizara: —Jesúsne kwail kimtuzkasa yalta nap kit nukkultu, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kwiztane Zaqueone awaruzpa paizkakin kun kit Anpatta kaizta: —Anpat, izti. Ap kwail kit aizpa min kit chɨhkat akwa, nane kakwa mɨj aizpa puizara mɨlanamtus. Na mamaztuztas an pɨnta saptane, na walkwat aizpa ampara pijikima kailninnanash. ");
INSERT INTO kwi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesúsne ussa kaizta: —Mane Diosne nuakas up kwaltakas u kwail kiarɨt aizpa wat kulnat kit uruza watsat mɨlnara. Une aukanain mama au pampa Abrahampa kwal mai. ");
INSERT INTO kwi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chiyuras ampune apain azi, awa karɨttuza sainana, uspa kwail kiarɨt aizpa wat kulninnana. ");
INSERT INTO kwi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Uspa sunta mɨamtuasmin, Jesúsne mamaz kamtam kwinta kaiznamɨzta. Usne Jerusalén pɨpulura kasha tuazi. Uspane Dios awaruza ɨninna anpain minñara. ");
INSERT INTO kwi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Katmizna Jesúsne kaiznara: “Ainki mikwane attish sura ɨmɨzta, akkwan su sap kit akkwan awaruza ɨninna. Suasne mamaz payura kailshina. Kwizta sun sura saptawane, paiña su kailshina. ");
INSERT INTO kwi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ɨmtuchasmin, usne diez kiwainmuruza akwanara, wan awaruza akkwan pial mɨlan. Usparuza kaiznara: ‘An pialkasa pait kit kana kitpa, na kailnakima.’ ");
INSERT INTO kwi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sunkana sun sukis awaruz ainki mikwasha izashitchi akwa, uspane uspa pit ainki mikwasha ɨnin kit kaizara: ‘Sun ampura, sun ainki mikwasha, aumɨza ɨninnanapa paashitchimakpas,’ kizara. ");
INSERT INTO kwi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sun sura kail kit saptawane, usne mikwakana ɨninmɨzta. Paiña sura kailtawane, usne paiña kiwaintuza, paiña pial mɨlattuza, akwanara. Usne yawa pial kana kiarɨt piankamshira. ");
INSERT INTO kwi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","An ñancha kiwainmikane us tukin ɨt kit kaizta: ‘Anpat. Up pialkasa nane mamaz diez pial kana kirau,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Katsa mikwane ussa kaizta: ‘Wat kirɨt. Nune wat kiwainmika i. Pitchin pialkasa nil kit akwa, nune diez pɨpulura ɨninnazi,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","An kwizta kiwainmikane us tukin ɨt kit kaizta: ‘Anpat. Nane up pialkasa mamaz cinco pial kana kirau,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mikwane ussa kaizta: ‘Nukas cinco pɨpulura ɨninnazi,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mamaz kiwainmikane us tukin ɨt kit kaizta: ‘Anpat. Apain up pial mɨj ish. Up pial pĩntain iptɨt mɨjarau. ");
INSERT INTO kwi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nu tɨnta ɨnintu akwa, nane nua ishkumtuarau. Nu kal kimtuchikas, kana kimtu. Nu pippa mal tuchikas, pippa paktu,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Suasne ainki mikwane ussa kaizta: ‘Nune kwail kiwainmika i. Nu sun kaizta akwa, nane nua kwail kirɨt kiznash. Nune na awara tɨnta ɨnintu pian. Kal kimtuchikas, kana kimtus. Pippa maltuchikas, pippa paktus. ");
INSERT INTO kwi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chikishma ap pial winmukin chɨhkamas, an akkwan kana kinpa? Suasne na kailtu payura ap pial ma pitchinkasa sapshinash.’ ");
INSERT INTO kwi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Usne kasha kuntuza kaiznara: ‘Ap pial mɨjatmikaras nakat kit an diez pial mɨjatmikasha ap pial mɨlarain.’ ");
INSERT INTO kwi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Uspane ussa kaizara: ‘Anpat. Usne me diez pial mɨji.’ ");
INSERT INTO kwi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Katsa mikwane sɨnkanara: ‘Ap pit kaiznamtus. An akkwan mɨjmikane an akkwan sap mɨlanazi. We mɨjmikane us wemin mɨj aizpa nakarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","¿Mɨntama nawa aliz awa purai? Uspane na usparuza ɨninnara pashiarachi. Usparuza apain karat kit na iztukin piantaninnarain,’ ” kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sun kiztawane, Jesúsne Jerusalén pɨpulura numɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé pɨpulurakas Betania pɨpulurakas kasha akane, Olivos ɨzara piannaara. Jesúsne paas kammuruza ɨninnat kit usparuza kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Sun pɨpulura au izkwakpara naptain. Pɨpulu pɨjta naptukin une burra kantɨt wanmalpailnazi. Makima mɨnminkas ussa uztachi mama. Ussa chɨht kit apain kararain. ");
INSERT INTO kwi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mɨnpazha “¿Chikishma burro chɨhtuas?” mɨmakane, “Anpatne ussa anuzshimtu,” kiztain. ");
INSERT INTO kwi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Suasne kanpamtuzne ɨil kit Jesús kaizta aizpa wanmalpailta. ");
INSERT INTO kwi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burro chɨhttuasmin, burrowamikane mɨmara: —¿Chikishma burro chɨhtuas? ");
INSERT INTO kwi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Uspane sɨnkailta: —Anpatne ussa anuzshimtu. ");
INSERT INTO kwi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesústa kararawane, uspane uspa pĩnkasa caballo pashpara palkwanara. Suasne uspane Jesústa ussa anuzninpailta. ");
INSERT INTO kwi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús burrora anuztuasmin, akkwan awane uspa pĩn mikin kɨhaara, Jesústa wat minñamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos ɨzara pɨnarawane, Jerusalén pɨpulura piannamtuasmin, kwisha akkwan kammuruzne wat kulamɨzta. Jesús iztasparɨt kal kit aizpa izara akwa, uspane ka tɨnta kaizara: “Diosne kwisha wari.” ");
INSERT INTO kwi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ankana kaizara: “Dios ɨnintamikane kwisha wari. Katsa mikwa i. An chiyuras atmikane aumɨza watsat mɨlnamtu,” Dioskasa kalpain uzanapa. Aune chiyura Dios kwisha wari kizmuspas ");
INSERT INTO kwi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Akkwan awane purara. Mɨnpazha Fariseo awaruzne kaizara: —Kamtam. Up kanpamtuza sun pit Diosta paramtu aizpa paraninman, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesúsne sɨnkanara: —Umɨza kaiznamtus. Ap kammuruz puñain purane, chinkas kizarakine, an katsa ukne kawarain pit kwianshina. ");
INSERT INTO kwi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén pɨpulura an kasha at kit iztawane, usne Jerusalén pɨpulura uztuz akwa az kit usparuza kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“U Jerusalén pɨpulura uztuzne ma kimtu aizpa wat piankamasachi. Makima une watsal uzna we pian. Mane wan kimtu aizpa uruza puintɨt i, piankamamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mamaz payura, aliz awane aat kit Jerusalén pɨpulu pianamal uzanazi. Uspane apain uztuza salpɨn titsaanazi. Uspane pɨpulu piannakin waya kianazi. ");
INSERT INTO kwi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Uspane yalkas pɨpulu kalpialkas kiakpɨnanazi. Uspane wan pɨpulura uztuza piantananazi. Wan chiwal uk azpian kit kiakpɨnanazi. Dios an pɨpulura uztuza atkas, une ussa nɨjkularachi, uruza watsat mɨlnanapa. Katmizna na kaizta aizpa kirɨnazi.” ");
INSERT INTO kwi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kwiztane Jesúsne Dios katsa yalta nap kit painintuza pianamal ɨninnara. Kwiztane Jesúsne ");
INSERT INTO kwi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","usparuza kaiznara: —Dios pɨnkɨhkin ka parɨt, “Ap yaltain Diosta paikwashina.” Apain une ap yalta walkummikawa kulkana saara. ");
INSERT INTO kwi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pailta payu Jesúsne Dios katsa yalta kamtana ɨra. Katsa pariyaruzkas Moisés kaizta aizpa kamtamtuzkas, Judío pɨpulu ɨnintuzkas ussa piantashiara. ");
INSERT INTO kwi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wan awa ussa kwisha mɨashimtu akwa, uspane Jesústa piantamanamara. ");
INSERT INTO kwi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maza payu Jesúsne Dios katsa yalkin awara kamtanat kit Dios watsal pit kainanamtu tuara. Katsa pariyaruzkas, Moisés kaizta aizpa kamtamtuzkas, ɨlapa Judío ɨninturuzkas ussa ɨat kit ");
INSERT INTO kwi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka kaizara: —¿Miza tuntumaka kimtus? ¿Mɨnma nua ɨninta, nu kimtu aizpa kin? ");
INSERT INTO kwi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Usne usparuza sɨnkanara: —Nakas nua mɨmananash. Mane kainazha. ");
INSERT INTO kwi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juanne, awara munmu kimikane, apain azi. ¿Mɨnma Juanta munna ɨninta? ¿Diosne ussa ɨnintaki? ¿Awane ussa ɨnintaki? ");
INSERT INTO kwi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Uspane usparuzpain kwinta kiat kit kaizara: “Au Dios Juanta ɨnintɨt sɨnkaarane, Jesúsne aumɨza ka mɨmananazi: ‘¿Chikishma ussa nɨjkulashitchi? ¿Chikishma us kaizta aizpa kiashitchi?’ ");
INSERT INTO kwi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Awa Juanta ɨnintɨt sɨnkaarane, apas awane aumɨza uk kiamɨznazi. Uspane Juan Dios pit kainammmika azi watcha minñamtu.” ");
INSERT INTO kwi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Suasne uspane Jesústa sɨnkaara: —Aune mɨnma Juanta, munnammikasha, ɨnintɨt pianchimakpas. ");
INSERT INTO kwi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Suasne Jesúsne usparuza kaiznara: —Nakas uruza mɨnma nawa sun kin ɨnintɨt kaiznamanash. ");
INSERT INTO kwi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesúsne awara kamtam kwinta ka kainanamɨzta: “Maza ampune wankail pɨppa sau warɨt mɨj. Usne mamaz kal kimmikasha paiña sukin unanara, pippa pak kit nailnapa. Suasne mamaz attish sumal ɨrɨt akkwan payukima. ");
INSERT INTO kwi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Paktu payu taizkane, pamikane paiña kiwainmumikasha ɨninta, pamikawa wankail pippa sapnapa. Paiña su kal kimturuzne kiwainmumikasha aim kiat kit ussa chinkas mɨjchi pianamal ɨninara. ");
INSERT INTO kwi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pamikane mamaz kiwainmumikasha ɨninta. Paiña su kal kimturuzne ussa aim kiat kit kwail pit kaiz kit kɨlmin pianamal ɨninara. ");
INSERT INTO kwi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pamikane an kutña piji mamazta ɨninta. Uspane ussa aim kiat kit wankail pippa sauras nuppain ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Suasne wankail sau pamikane usmin minta: ‘¿Chima kinpai? Nane ap pashimtu painkulta ɨninnash. Ussa pashimtus. Uspane ussa kwail kin ishkuanazi.’ ");
INSERT INTO kwi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Uspa ussa izarawane, kal kimturuzne usparuzpain kaizara: ‘Anne su sapmumika i. Ussa piantana ɨzhain, paiña su sapna, supamika namna.’ ");
INSERT INTO kwi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kal kimturuzne ussa su pianamal nuppainñat kit piantaara. Suasne Jesúsne usparuza mɨmanara: ‘Supamikane su kal kimturuza, ¿Chima kirɨsna? ");
INSERT INTO kwi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Usne paiña sukin kailtɨnazi, su kal kimturuza piantanana. Kwiztane paiña su mamaz kal kimturuza chɨhkanazi.’ ” Sun mɨarawane, uspane kaizara: —Sunkana Dios kishimanazi. Aune sun kwail awakana chimakpas. ");
INSERT INTO kwi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesúsne usparuza iznat kit kaiznara: —Une Dios pɨnkɨhta para aizpa piankamtain. Sunkana parɨt: “Yal sararuzne an watsal uk kwairɨt. Kwiztane sun watsal uk kalpialkin wara, yal an tɨnta sana.” ");
INSERT INTO kwi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ukta taiztumikane pitti pittin kɨztɨshina. Uk mɨnpazhara taiztane, ukne ussa pak pak kirɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pariyawa ɨnintuzkas Moisés kaizta aizpa kamtamtuzkas Jesús kaizta aizpa mɨara. Jesús sun kamtam kwinta uspawa kwinta kinara akwa, uspane Jesústa sun payura pizshiara. Awara ishkuamtu akwa, uspane ussa pizasachi. ");
INSERT INTO kwi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Uspane awaruza ɨninnara, Jesústa izna. Uspane wat awakana namninashira, chiwazha Jesús kaizta aizpa mɨanapa. Uspane Jesús ñanta pit kaizta aizpa saishiara, ussa katsa mikwara chɨhkashinamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Uspane ussa ka kaizara: —Kamtam. Aune nu kaiztu aizpakas nu kamtamtu aizpakas nil i pianmakpas. Wan awara kawarain kinamtu. Nune Dios kaizta aizpa watcha kamtanamtu. ");
INSERT INTO kwi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Suasne uspane Jesústa ka mɨmaara: “Cesarne Roma pɨpulu katsa mikwa i. ¿Miza makai? ¿Pial ussa tapuskiwas? ¿Tana watki?” ");
INSERT INTO kwi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesúsne uspa kwail minñara aizpa pian kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Une nawa kwail kin kininshiamtu. Apas pial izna ancha. ¿Mɨnpa awa matsɨhma an pialkin izamtuas? ¿Mɨnpa munma parɨt? Uspane sɨnkaara: —Katsa mikwa Cesarpa matsɨh i. Paiña mun pialkin parɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Usne kaiznara: —Watcha. Roma gobierno katsa mikwara pial tana kizamtune, sun pial Cesarta tarain. Kawarain Dios uruza kaiztu aizpa kirain. ");
INSERT INTO kwi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesúsne uspa mɨmaarɨt aizpa awa iztakin wat sɨnkanara. Uspane ussa kwail parɨt kizamanamarɨt. Uspane us sɨnkara aizpa iztaspaat kit puñain paarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mɨnpazha Saduceo awaruzne ussa aara. Uspane irɨttuz mamasa uzamtuchi minñamtu. Uspane ussa kaizara: ");
INSERT INTO kwi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Kamtam. Moisésne aimpihshpa para. Aimpihsh irɨtne, pashpa mɨjkine, paiña aimpihshne aimpihsh irɨtpa ashampara mɨltawa, us akwa pashpa mɨlna. ");
INSERT INTO kwi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Siete aimpihshtuzpain uzara. An aimpihshne ashampa mɨlta. Usne pashpa mɨltachi irɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mamaz aimpihshne sun ashampara mɨlta. Uskas pashpa mɨjchi irɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mamaz aimpihshne sun ashampara mɨlta. Uskas pashpa mɨjchi irɨt. Chiwal siete aimpihshtuzne sun ashampara mɨlat kit pashpa mɨjchi iarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kwiztane ashampakas irɨt. ");
INSERT INTO kwi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Katmizna, awa mamasa uztawane, “¿Mɨnma an ashampara mɨlshinasa, siete aimpihshtuzpain ussa mɨlaara akwa?” ");
INSERT INTO kwi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesúsne usparuza sɨnkanara: —An sukin ma uztuzne kasara kiamtu. Ampune ashampara mɨltu. Ashampakas ampura mɨltu. ");
INSERT INTO kwi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Diosne nɨjkulturuza nananazi, mamasa uzanapa. Irɨttas uztawane, ampune ashampara mɨlkain. Ashampakas ampura mɨlkain. ");
INSERT INTO kwi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Uspane sua mamasa iamanazi. Dios usparuza mamasa uzninnarawane, uspane Dios painkul manazi. Diospa ángelkanain manazi. ");
INSERT INTO kwi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Watcha. Irɨttuzne mamasa uzanazi. Ñamin Diosne Moisésta tɨ impaktɨmtukin kwinta kira. Sun pɨnkɨhta Anpatne ka kizta: “Nane Abrahampa Dios ish. Isaacpa Dios ish. Jacobwa Dios ish.” Ñamin iarɨtkas, sun kutñaruz makima Dioskasa uzamtu. ");
INSERT INTO kwi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diosne usparuzpa Dios i. Diosne irɨt awaruza ɨninnamtuchi. Diosne wan awa uzamtu pian. Katmizna Diosne akwarɨttuza uzninanazi, us iztakin uzanapa. ");
INSERT INTO kwi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Suasne mɨnpazha Moisés kaizta aizpa kamtamtuzne ussa sɨnkaara: —Kamtam, nune nil kwinta kira. ");
INSERT INTO kwi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ishkumtu akwa, mɨnminkas ussa an mɨmaarachi. ");
INSERT INTO kwi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesúsne mɨmanara: —¿Chikishma awane “Cristo Davidpa painkul i,” kizamtu? ");
INSERT INTO kwi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidne sunkana kanta pɨnkɨhta pat kit “Cristo Anpat i,” kizta. Ka parɨt: “Diosne ap Anpatta kaizta: ‘Nune ap makin uztui. ");
INSERT INTO kwi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nane nu akwa aliztuza waya kinash, usparuza anuppanakima, nu usparuza ɨninnanakima.’ ” ");
INSERT INTO kwi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidne ussa “ap Anpat i” kizta. ¿Uskas pampa Davidpa painkul ki? ");
INSERT INTO kwi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wan awa ussa mɨamtuasmin, Jesúsne paiña kammuruza kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“¡Kwiraruin! Moisés kaizta aizpa kamtamtuza iztain, uspakana uzmanpa. Uspane aks kwaksham kwashiamtu, awa usparuzpa wat minñanapa. Uspane pɨpuluwara chashiamtu, awa usparuza ‘wat kɨntɨre’ kizanapa. Uspane Judío kammu yalta nappat kit an ñancha wat uzmukin uzamtu, awa usparuzpa wat minñanapa. Uspane pishtara an ñancha chaamtu, an wat uzmura sayana, awa uspa an katsa namtɨt piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ampuwa irɨt ɨnkwa mɨj aizpa walkwatpane, uspane awa iztakin akkwan pitkasain kukaizamtu. Uspane pɨrail appamtu. Diosne usparuza tɨnta ilnanazi, akkwan naiznakima.” ");
INSERT INTO kwi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús Dios katsa yalkin tuasmin, usne kwazparuza iznara. Uspane pial sapmukin kunat kit uspa pial sua kiainñara. ");
INSERT INTO kwi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Usne puiza ampu irɨtpa ashampara izta. Sun ashampane paas pialmin mɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesúsne ka kizta: —Watcha kaiznamtus. An puiza ampu irɨtpa ashampane kwazparuzkin an akkwan mɨlara. Kwazparuzne an pitchinmin mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwazparuz uspa pial tizta aizpa Diosta mɨlaarakas, an puiza ashampane wan mɨj aizpa mɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mɨnpazha kammuruzne Dios katsa yalpa ka kaizta: —Awane Dios katsa yal wat ukkasa sara, paiña watsal yal iznapa. Awane chiwazha Diosta mɨlmu, Dios katsa yal awa iztakin watsal iznapa. Suasne Jesúsne kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mamaz payura mamaz awane u wan chiwal izamtu aizpa azpianat kit kiakpɨnanazi, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kammuruzne ussa mɨmaara: —Kamtam. ¿Chi payurama awane katsa yalta azpianninnazi? ¿An payura chima kirɨnsa, au an ñancha piankamanapa? ");
INSERT INTO kwi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesúsne kaiznara: “Kwiraruin. Uruzpain iztain, awaruza ñanta kain kiamanpa. Akkwan awane ‘nane Cristo ɨninmika ish’ kizanazi. Mamaztuzne ka kizanazi: ‘Nane Cristo ish.’ Mamaztuzne kain pit kizanazi: ‘Mane Cristo anpain i,’ kizanazi. Usparuza mɨman. Usparuza kanpaman. ");
INSERT INTO kwi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Gobierno mamaz gobiernokasa waya kikane, awakas katsa mikwakasa waya kikane, ishkuman. An ñancha uspane waya kiarawa. Wansɨhne pailtuchi mama.” ");
INSERT INTO kwi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Suasne Jesúsne kaiznamɨzta: “Mamaz suras awane mamaz suras awakasa waya kianazi. Katsa mikwane mamaz katsa mikwakasa waya kinazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Akkwan suwara tɨnta ulsamɨznazi. Akkwan awane akkwan sura yak kiat kit naizanazi. Katsa kikas awaruza piznanazi. Awane akkwan iztasparɨt kal kasha chiyura izanazi, usparuza ishkuninnakima. ");
INSERT INTO kwi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sun kitchasmin, uspane uruza piznat kit naizninnanazi. Uspane uruza Judío kammu yaltakas kajchirakas sɨpninnanazi. Nu nawa pian akwa, uspane uruza katsa mikwarakas ainki mikwarakas chihtɨra piznat kit tainñanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sun payura une usparuza Dios watsal pit kainananazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sunkanain piankamtain. An ñancha u miza mamaztuza sɨnkana minman. ");
INSERT INTO kwi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nane uruza kiwainanash, usparuza watsal pit kwinta kianapa. An aliz awane u wat pit kwayamanazi. Uspane u kaiztu aizpa ‘kwail i’ kizamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Papihshkas, aimpihshkas, kwalkas, izmuruzkas uruza gobiernora chɨhkanazi. Uspane mɨnpazharuza piantaninanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Akkwan awane na akwa uruza naizninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naizamtukas, u izpulne watsaarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uruza tɨnta namnintain, umin watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Suldaruruzne Jerusalén pɨpulura pɨlzaakane, une awa an pɨpulura azpiananapain piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Suasne Judea sukin uztuzne ɨnkal ɨzara ɨarawa. Jerusalén pɨpulura uztuzne tas puzarawa. Nanta uztuzne pɨpulura napman. ");
INSERT INTO kwi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sun payura Diosne paiña narɨttuza, Israel awaruza, naizninnanazi, Dios pɨnkɨhta parɨt aizpa pailnakima. ");
INSERT INTO kwi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sun payura ashampa pɨja waruzkas ashampa chitchu kwintaruzkas naizarɨnazi. Wan awane kwisha naizarɨnazi, Dios an sukin uztuza ilnamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mɨnpazha iarɨnazi, mashtikasa waya kiamtu akwa. Uspane kajchira waruza mamaz sura mɨlnarɨnazi. Mamaz suras awane, Judío awachiruzne, Jerusalén pɨpulura wan chiwal azpiantɨnazi, wan Judío awachiruza ɨnintu aizpa pailnakima, wan Dios pɨnkɨhta parɨt aizpa pailnakima.” ");
INSERT INTO kwi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Suasne awane parakas, palapcharakas, kɨmarakas, iztasparɨt aizpa izanazi. Wan suras awane chiwazha kimtu aizpa piankamamanazi. Uspane ishkuarɨnazi, ñam pi aztu akwa, inkwa pi nuppaintu akwa. ");
INSERT INTO kwi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","An sura chi kirɨnsa minñamtuasmin, awane nainñarɨnazi, ishkwantu akwa. Wanne chiyura wa aizpa tɨnta ultɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Suasne uspane Chiyuras Ampura izarɨnazi. Us wanishkin amtuasmin, usne uspa izarakin tɨnta nam kit kwisha watsal namtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na kaiztu aizpa kimɨzkane, uruzpain tɨnta namtain. Chiyura izak kit watsal kultain, u akwa pui tarɨtmikane anpain i, umɨza chɨhtna.” ");
INSERT INTO kwi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Usne usparuz mamaz kamtam kwinta kinara: “Higuera tɨrakas, wan tɨrakas, iztain. ");
INSERT INTO kwi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kɨh kwizkane, une pul panapain i piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kawarain na kaiztu aizpa izakane, Diosne awaruza ɨninna anpain. Sun piankamtain. ");
INSERT INTO kwi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Watcha kaiznamtus. Sun Judío awaruzkanain iarachasmin, na wan kaiztu aizpa kirɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chiyukas au sukas pailtakas, ap pit na kaiztu aizpa mizurainkas pailmanazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Iz kit nil uzizanaka. Uruzpain izkultain. Akkwan pishta iztane, kwisha akkwan chappi kwatne, nil minsachi. Sunkana kiman. Chappi kwat kit kumira kwatne, piman. Nɨjmin uztain. Apain uzamtuasmin, kumirain minman. Pialmin minman. Maij sarane, chitchu tɨttarane, azain niltɨm. Aptane, iwal. Kawarain Chiyuras Ampu namtɨtmikane azain anazi. ");
INSERT INTO kwi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chiyuras Ampu namtɨtmikane wan su uztuza azain anazi, chitchu tɨt tarɨt niltukanain. ");
INSERT INTO kwi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pailta payu aizpa izkulat kit Diosta paikwarain, tɨnta kulanapa, an sukin kimtu aizpa uruza ɨamasanapa, Chiyuras Ampu namtɨtmikakasa uzanapa.” ");
INSERT INTO kwi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesúsne pailta payuwara Dios katsa yalta kamtanara. Amtawara usne pɨpuluras puz kit Olivos ɨzara uzta. ");
INSERT INTO kwi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wan awane tɨlawain Dios katsa yalta aara, ussa mɨana. ");
INSERT INTO kwi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pascua pishta kasha pamtu. Sun pishtakin Judío awa pan sarane, kiña winkain. ");
INSERT INTO kwi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Katsa pariyaruzkas Moisés parɨt aizpa kamtamtuzkas Jesústa kain sayat kit pizashimtuazi, ussa piantana. Wan awaruza ishkuara akwa, uspane Jesústa pizarachi. ");
INSERT INTO kwi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Suasne Satanásne Judasta, Iscariote muntɨtmikasha, pizta. Usne kammumika nam kit mamaz once kammuruzkasa chara. ");
INSERT INTO kwi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Usne ɨt kit pariyaruzpa mikwaruzakasa Dios katsa yal izmuruzakasas kwinta kinara, Jesústa usparuza chɨhkanapa. ");
INSERT INTO kwi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Uspane wat kulat kit ussa pial taana namarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Usparuza chɨhkan namtawane, usne wat payura saira, ussa akkwan awa tuchira chɨhkanpa. ");
INSERT INTO kwi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Suasne Pascua pishta taizta. Sun pishta izamtuasmin, pan samtu, kiña wintachin. Uspane pɨrikukas piantam. ");
INSERT INTO kwi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesúsne Pedrorakas Juantakas ɨnin kit ka kaizta: —Ɨt kit Pascua pishta sarain, au kwan. ");
INSERT INTO kwi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Uspane ussa mɨmaara: —Aune ¿Mɨntama pishta sanapai? ");
INSERT INTO kwi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Usne usparuza sɨnkanara: —Mɨrain. Pɨpulura naptazasmin, une maza ampu kwazi kalpu kwamikasha wanmalpailnazi. Ussa kwizpa kanparain, paiña yalta napnakima. ");
INSERT INTO kwi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yalpamikasha ka kiztain: “Kamtamne aumɨza ka mɨmana ɨninta: ¿Mɨnta up kalmal tui? Suane nane Pascua kumira ap kammuruzkasa kwanash.” ");
INSERT INTO kwi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Suasne usne umɨza yalkin kwashta katsa kalmal ananazi. Suane pishta sarain. ");
INSERT INTO kwi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Uspane ɨil kit us kaizta aizpa wanmalpail kit sua Pascua kumira sailta. ");
INSERT INTO kwi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kumtu ura taizkane, Jesúsne misharɨ uzta, paiña ɨnintaruzkasa kwan. ");
INSERT INTO kwi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Usne usparuza kaiznara: —Naiztuchasmin, nane ukasa an Pascua kumira kwashimtus. ");
INSERT INTO kwi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Apain mamaz Pascua kumira kumanash. Chiyura, Dios paiña kwaltuza ɨninnapa akane, nane mamasa Pascua kumira kwanash. ");
INSERT INTO kwi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Taza piztawane, Diosta aishtaish kiztawane, Jesúsne kaiznara: —An taza sap kit vino pi uruza nailtain. ");
INSERT INTO kwi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Uruza kaiznamtus. Makis an sukin an vino pi kumanash, Dios ankima, Dios ɨnintukin, paiña kwaltuza ɨninnana. Suasne sua mamasa sun kwanash. ");
INSERT INTO kwi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pankas saptawane, Diosta aishtaish kiztawane, Jesúsne pan kɨz kit usparuza nail kit kaiznara: —An panne ap ña i. Na u akwa inash. Sun kirain, nawa nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kapal kuarawane, usne taza piz kit kaiznara: —An vino pi ap aimpi i. Ap aimpi puzkane, nane u akwa irɨnazi, u kwail kiarɨt aizpa wat kulnana. Sunkana ñamin Diosne kin namta, u kwail kiarɨt aizpa wat kulnana. ");
INSERT INTO kwi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mane iztain. Nawa chɨhkamtumikane an misharɨ nakasa kumtu. ");
INSERT INTO kwi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chiyuras Ampu namtɨtmika irɨnpa narɨtkas, nawa chɨhkamtumikane kwisha tayal kit naiztɨnazi. ");
INSERT INTO kwi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Uspane usparuzpain mɨmaat kit ka kizara: “¿Mɨnma sun kinsa?” ");
INSERT INTO kwi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Uspane usparuzpain aliz kaizat kit mɨmaara: “¿Auruzpain mɨnmikama an tɨnta mika i?” kizara. ");
INSERT INTO kwi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús usparuza kaiznara: “Mamaz suras katsa mikwane paiña suwara uztuza tɨnta ɨninnamtu. Mɨnpazha katsa mikwaruzne ka kizamtu: ‘Aune awara kiwain namtamakpas.’ ");
INSERT INTO kwi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Katsa mikwa sunkana uzamtukas, une sunkana uzman. An katsaruzne an ainkimikakana namtawa. Ɨnintaruzne kiwainmumikakana namtawa. ");
INSERT INTO kwi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Mɨnminkas an tɨnta i? ¿Misharɨ uzmumika an tɨnta mikaki? ¿Kumira karammika an tɨnta mikaki? Misharɨ uzmumika an katsakas, nane apain arau, awaruza kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Awa nawa naiznintukas, une nakasa maamtu. ");
INSERT INTO kwi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ap Taittane nawa nara, awaruza ɨninnanapa. Kawarain nane uruza nanamtus, nakasa ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Suane une ap ɨnintukin nakasa kuanazi. Suane ap ɨnintukin une uzanazi, doce Judío kwaltuza mɨmanapa, usparuza kaizapnapa.” ");
INSERT INTO kwi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesúsne sun kaizta: —Simón, Simón. Izti. Satanásne Diosta paikwara, uruza ulmalnapa, Diosta an nɨjkulamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nane nu akwa Diosta paikwarau, nu Diosta nɨjkulnapa, Dios pit mainmanpa. Nu nawa kailtawane, up añaruza, ap kammuruza, kiwainnari, an tɨnta namanapa. ");
INSERT INTO kwi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simónne ussa kaizta: —Anpat. Nane nu akwa kajchira ɨnpain, inakima. ");
INSERT INTO kwi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesúsne ussa kaizta: —Pedro, nane nua kaiztus. Ma payu aral kayu aztuchasmin, nune kutña pijikima “nane ussa pianchish” kiznazi. ");
INSERT INTO kwi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Suasne Jesúsne usparuza kaiznara: —An ñancha uruza ɨninnakane, nane uruza pial tuh mɨjchikasakas tuh mɨjchikasakas zapato nukchikasakas ɨninnara. ¿Une chiwazha wemakkiwas? Uspane ussa sɨnkaara: —Chinkas wechimakpas. ");
INSERT INTO kwi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Usne usparuza kaiznara: —Makis, pial tuh mɨjne, kwarawa. Kawarain tuh kwarawa. Mashti mɨjkine, kwaksham painintawa, mashti paina. ");
INSERT INTO kwi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mane nane Dios pɨnkɨhta na akwa parɨt aizpa ka kiznamtus: “Usne kwail awakana naizanazi.” Wan nawa parɨt aizpa kimtu. ");
INSERT INTO kwi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Uspane kaizara: —Anpat. Izti. Apane paas mashti tu. Usne kaiznara: —Min kwinta kirain. ");
INSERT INTO kwi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesúsne pɨpuluras puz kit Olivos ɨzara nura. Sua sunkana ɨkamtɨt. Kammuruzne ussa kwizpa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sua pianakane, usne usparuza kaiznara: “Diosta paikwarain, kwail kishiamanpa.” ");
INSERT INTO kwi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesúsne usparuztas treinta sakima ɨt kit wakpuj wain kit Diosta kaizta: ");
INSERT INTO kwi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ap Taitta. Nu nawa naizninshitchine, nawa naizninmun. Nu kishit aizpa sari. Na kishit aizpa samun,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Maza ángelne chiyuras ara, ussa tɨnta kiwainna. ");
INSERT INTO kwi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akkwan naiztuasmin, Jesúsne an tɨnta Diosta paikwara. Usne kwisha katsa pairara pi pairamɨzta. Kwisha katsa pairara pi aimpikana pilta taizara. ");
INSERT INTO kwi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Paikwatpane, kuhs kit kammuruz purakin kailta. Uspa tayaltu akwa, pittarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Usne kaiznara: —¿Chikishma pittamtuas? Kuhs kit Diosta paikwarain, u kwail kishiamanpa. ");
INSERT INTO kwi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús paiña kammuruzkasa kwinta kimtuasmin, akkwan awane ustukin aara. Judaskas, maza doce kammuruztas, an ñancha ɨra. Jesústa kasha ɨt kit paiña matsɨhkin putchunta. ");
INSERT INTO kwi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús ussa kaizta: —Judas. ¿Nawa putchuntuasmin, nune nawa kwail kimtukish? ¿Nawa kwail awaruza chɨhkamtukish? ");
INSERT INTO kwi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wan kit aizpa izamtuasmin, Jesúskasa uztuzne ussa mɨmaara: —Anpat. ¿Mashtikasa waya kimuskiwas? ");
INSERT INTO kwi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mazane usparuztas katsa pariyawa kiwainmikasha pian kit numal kail yalta. ");
INSERT INTO kwi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesúsne kaizta: —Sunkana kimun. Jesúsne kiwainmikawa kail sɨn kit ussa namtara. ");
INSERT INTO kwi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Suasmesa Jesúsne katsa pariyaruzpa mikwaruzakas, Dios katsa yalpa izmuruzakas, Judío ɨlapa ɨnintuzakas kwinta kinara. Uspane ussa pizshiara, kajchira sɨpna. Usne usparuza mɨmanara: —¿Une mashtikasa tɨ salakasa aamuskiwas, wiyakimmikara pizna? ");
INSERT INTO kwi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nane pailta payukima Dios yalta ukasa tuarau. Suane une nawa pizarachi. Mane une nawa pizashimtu, Diablo tɨlkwilta ɨnintu akwa, paiña kwail kinpa. ");
INSERT INTO kwi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Suasne uspane Jesústa pizat kit katsa pariyawa yalta mɨlara. Pedrone attishta kanpara. ");
INSERT INTO kwi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Uspane yal pianamal ĩn usap kit uzara. Pedrokas usparuzkasa uzta. ");
INSERT INTO kwi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Suasmesa ashampa kiwainmikane Pedrora izta. Ĩn usaptukin uzta. Ussa iztawane, usne kaizta: —An ampune uskasa tuarai. ");
INSERT INTO kwi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedrone ussa kaizta: —Ashampa. Nane ussa pianchish, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","An kwizta mamazne ussa iz kit kaizta: —Nukas Jesúspa kanpammika i, kizta. Pedrone sɨnkara: —Ampu. Nane ussa kanpammika chish, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maza ura pailtawane, mamazne an tɨnta kaizta: —Watcha, an ampukas uskasa tuarai. Usne Galilea suras ara. ");
INSERT INTO kwi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Suasmesa Pedrone kaizta: —Ampu. Nu kaiztu aizpa pianchish, kizta. Sun urain Pedro paramtuasmin, aral kayu azta. ");
INSERT INTO kwi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Suasmesa Jesúsne puij kit Pedrora izta. Pedrone Anpat kaizta aizpa nɨjkulta. Anpatne ussa ñamin ka kiztɨt: “Mane aral kayu aztachasmin, nune nawa kutña pijikima ‘ussa pianchish’ kiznazi.” ");
INSERT INTO kwi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yaltas puztawane, Pedrone tayal kit tɨnta azta. ");
INSERT INTO kwi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesústa watsamturuzne ussa ishanat kit aim kiara. ");
INSERT INTO kwi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Uspane Jesúspa kasukin pĩn pal kit mɨmaara: —¿Nune Dios pian aizpa piankish? Nu iztuchi aizpa kainazhain. ¿Mɨnma nua aim kiazi? kizara. ");
INSERT INTO kwi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Uspane an akkwan kwail pit ussa kaizara. “Nune kwail awa i,” ussa paraara. ");
INSERT INTO kwi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kɨnmɨzkane, wan Judío ɨlapa ɨnintuzne wanmakkara katsa pariyaruzkasa, Moisés pɨnkɨh parɨt aizpa kamtamturuzkasa. Uspane ussa katsa mikwaruzakima tain ɨara. Suane ussa mɨmaara: ");
INSERT INTO kwi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Nune Dios nɨrɨtmika kish? Aumɨza kainazhain. Jesúsne usparuza sɨnkanara: —Na Dios nɨrɨtmika ish kiztane, une nawa nɨjkulamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na umɨza chiwazha mɨmanarane, une nawa sɨnkaamanazi. Une nawa chɨhamanazi. ");
INSERT INTO kwi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Makis nane, Ampu namtɨtmikane, katsa Dios ɨninmukin uznash. ");
INSERT INTO kwi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Uspane ussa mɨmaara: —¿Nune Dios Painkul kish? Jesúsne sɨnkanara: —Umin nawa Dios Painkul i kizamtu. ");
INSERT INTO kwi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Uspane usparuza kaizara: —Masas pit wachi akwa, aune mamaz kainammmikasha mɨshitchimakpas. Aune us kaizta aizpa mɨapuspas. ");
INSERT INTO kwi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wan Judío ɨninturuzne kuhsat kit Jesústa Pilato iztukin, Roma ainki mikwa turakin, mɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Uspane ussa kwail kizamɨz kit Pilatora kaizara: —An ampuwa wan piankamtawane, aune an ampura piztamakpas. Usne au awaruza pilchapuzninnamtu. Usne auruza Roma mikwara, Cesarpa gobiernora, “pial taman” kiztu. Uskas “nane Dios nɨrɨtmika ish” kiztu. “Nane katsa mikwa ish” kiztu, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Suasmesa Pilatone ussa mɨmara: —¿Nune Judío awawa katsa mikwa kish? Usne ussa sɨnkara: —Nuin sun kizta. Watcha i. ");
INSERT INTO kwi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatone katsa pariyaruzakas, wan awaruzakas kaiznara: —Nane an ampura chinkas kwail kitchi wanmaltau. ");
INSERT INTO kwi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Uspane an tɨnta kaizamɨzta: —Usne au awaruza pilchapuzninnamtu. Usne wan Judea sura uztuza kamtanamtu. Galilea suras kamtanamɨzta, an pɨpulurakima, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sun mɨrawane, Pilatone ¿Usne Galilea suras ki? kiz mɨmara. ");
INSERT INTO kwi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Suasne usne Jesús Galilea suras, Herodes ɨnintu suras, tas azi kamta. An payura Herodes Jerusalén pɨpulura tuasmin, Pilatone Jesústa Herodes tukin ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesústa izkane, Herodesne wat kulta. Ñamin us akwa mɨra akwa, Herodesne ussa akkwan payukima izshira, chiwazha iztasparɨt kal kinpa. ");
INSERT INTO kwi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Suasmesa kwisha akkwan piji mɨmarakas, Jesúsne ussa sɨnkarachi. ");
INSERT INTO kwi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Katsa pariyaruzkas Moisés pɨnkɨhta parɨt aizpa kamtamtuzkas kashara kunat kit ussa tɨnta kwail kirɨt kizamtuazi. ");
INSERT INTO kwi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Suasne Herodesne paiña suldarukasa ussa kwail kiat kit ussa ishanara. Ussa kwisha watsal kwakshamkasa kwanintawane, Herodesne ussa ishan kit Jesústa Pilatorakima mamasa ɨninta. ");
INSERT INTO kwi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sun payura Herodeskas Pilatokas izmuruz nampailta. An ñamin uspane aliz. ");
INSERT INTO kwi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Suasne Pilatone katsa pariyaruzakas Judío awaruza ɨnintuzakas Judío awaruzakas akwanat kit ");
INSERT INTO kwi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kaiznara: —Une an ampura nawa karaara. Une an ampu awaruza pilchapuzninnamtu kizamtu. Ussa u iztukin kwisha mɨmarawane, nane an ampu chinkas kwail kitchi wanmaltau. U kaizara aizpa nilchi. ");
INSERT INTO kwi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodeskas an ampu chinkas kwail kitchi wanmalta. Usne ussa aumɨza kailninta. Iztain. Kwail kitchi akwa, nane ussa piantasachish. ");
INSERT INTO kwi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Katmizna ussa chɨhtachasmin, nane ussa aya tɨtkasa ilninnash. ");
INSERT INTO kwi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua pishta iztuasmin, Herodesne maza kajchi sɨptɨtmikasha puznintawa. ");
INSERT INTO kwi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wan awane tɨnta ka kwianñara: —An ampura pizninti, ussa piantanapa. Barrabásta kajchiras puzninti, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","An ñamin Barrabásne awara piantat kit pɨpulu awaruza aizapninnara. Katmizna uspane ussa pizat kit kajchira sɨppara. ");
INSERT INTO kwi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesústa chɨhtninshimtu akwa, Pilatone mamasa usparuza kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Uspane mamasa tɨnta kwian kit kaizara: —Ussa piantari. Kurishta irukasa pat pian piantari, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kutña pijikima usparuza kaiznara: —¿Chikishma? ¿Chi kwail kirɨt usne? Nane an ampu chinkas kwail kitchi wanmaltau. Katmizna ussa aya tɨtkasain ilnintawane, ussa chɨhnash. ");
INSERT INTO kwi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Uspane an akkwan tɨnta kwianat kit paikuara, ussa kurishta irukasa pat pian piantana. Uspa kaizara akwa, pariya ɨnintuz kaizara akwa, Pilatone uspa pashiat aizpa mɨnara. ");
INSERT INTO kwi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Katmizna Pilatone uspa paikwat aizpa kira. ");
INSERT INTO kwi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Suasne Pilatone kajchira sɨptɨtmikasha puzninta. Usne awaruza aizapninnat kit awara piantarɨt. Judío awa paikuara akwa, Herodesne usparuza mɨnara, uspa pashit aizpa kiana. Judío awa Jesústa piantashiamtu akwa, usne Jesústa usparuza chɨhkanara. ");
INSERT INTO kwi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Roma suldaruruz ussa kurishta patpiantana tain mɨlamtuasmin, Simónne Cirene nan suras piannamtuazi. Uspane Simónta kurish munninat kit Jesústa kwizpa kanpaninñara. ");
INSERT INTO kwi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kwisha akkwan awane ussa kanpaara. Akkwan ashampane kwizpa kanpaat kit kwisha tayalat kit us akwa tɨnta azaara. ");
INSERT INTO kwi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesúsne usparuza kɨzpu puij iz kit usparuza kaiznara: —U ashampa Jerusalén pɨpulura uztuzne, mɨzhain. Nawa azman. U akwakas u pashpa akwakas aztain. ");
INSERT INTO kwi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mɨrain. Mamaz payura awane ka kizanazi: “Pashpa mɨltuchimikakas pɨja wachimikakas chitchu kwimchimikakas an wat kulanazi.” ");
INSERT INTO kwi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Suasmesa uspane ɨnkaltakas puttarakas kaizamɨznazi: “Au ɨsalta taiztain. Aumɨza kularain.” ");
INSERT INTO kwi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mɨrain. Uspane uspa pashimtu aizpa nawa kiamɨznazi. Kwiztane uspane uruza an kwail kiamɨznazi. ");
INSERT INTO kwi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","An paas kwail kimtuza tain ɨninara, uskasa piantanapa. ");
INSERT INTO kwi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɨamtuasmin, ɨzara piannaara. An ɨzane awa kɨzpu sɨhkana iztɨt. Suane uspane ussa kurishta irukasa patpiana panaara. Paas kwail kimtuzakas karaara. Uspane mazarakas paiña numal kurishta patpiana panaara. Mamaztakas paiña kwiyamal kurishta irukasa patpiana panaara. ");
INSERT INTO kwi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Suasmesa ussa kurishta pat piantawane, Jesúsne kaizta: —Ap Taitta, mɨzha. Uspa kwail kiarɨt aizpa wat kultain, uspa chiwazha kiamtu aizpa pianchi akwa, kizta. Suldaruruzne ainki ukkasa salara, paiña kwakshamkas mamaz pĩnkas kana kinpa. ");
INSERT INTO kwi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Awaruzne kasha kunat kit wan izara. Katsa mikwaruzkas ussa ishanat kit kaizara: —Usne mamaztuza watsat mɨlnara, uznanapa. Usne usmin uzna kiwainsachi. Dios ussa kiwaintuchi akwa, usne Diospa nɨrɨtmika chi, Diospa narɨtmika chi, kizara. ");
INSERT INTO kwi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suldaruruzkas ussa ishanat kit ussa tish vino kwinna ɨara. ");
INSERT INTO kwi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Uspane ussa kaizara: —Nu Judío awawa katsa mikwane, nuin watsat mɨlti. ");
INSERT INTO kwi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Paiña kɨzpu ɨsalkin ainki tapɨlakin ka paarɨt: ANNE JUDÍO AWAWA KATSA MIKWA I. ");
INSERT INTO kwi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Maza kwail kurishta irukasa patpiantɨtmikakas ussa kwisha kwail ka kizta: —¿Nune Dios nɨrɨtmika kish? Nuin watsat mɨlti. Aumɨzakas watsaat mɨlchain, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mamazne ussa pilchapuz kit kizta: —Sunkana kizmun. Une Diosta ishkwatpa. Nukas, nakas, uskas kawarain naizpuspas, inakima. ");
INSERT INTO kwi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Au paasne naizpuspas, au kwail kiarɨt akwa. An ampune chinkas kwail kit chi. ");
INSERT INTO kwi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Usne ma pitchin Jesústa kaizta: —Jesús. Nu amtu payura, wanta tɨnta ɨninnakane, nawa nɨjkulcha, kizta. ");
INSERT INTO kwi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesúsne ussa sɨnkara: —Watcha, nua kaiztus. Mane nune nakasa watsal sura tuanazi. ");
INSERT INTO kwi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Paizka payurain wan su tɨl parɨt, kutña urakima. ");
INSERT INTO kwi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pãn maltachi. Dios katsa yalta pĩn kantɨt paizkakin pshatkwera. ");
INSERT INTO kwi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Suasmesa Jesúsne tɨnta kwian kit kaizta: —Taitta. Nane ap izpul nua chɨhkamtus, kizta. Sunkana kiztawane, irɨt. ");
INSERT INTO kwi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Suldaru ɨninmikane sun kit aizpa iz kit kaizta: —Diosne kwisha wari. Watcha, an ampune kwail kitchi. ");
INSERT INTO kwi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Akkwan awane sun kirɨt aizpa izana wanmakkara. Sun kit aizpa izarawane, tayalamɨzta. Uspa yalta kaiyamtuasmin, uspane uspa pecho aim kuzara, tayaltɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesúspa izmuruzkas Galilea suras ashampa arɨttuzkas attishtain kunat kit sun kirɨt aizpa izara. ");
INSERT INTO kwi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Suane maza ampune, José muntɨtmikane, tuarai. Usne Judea sura, Arimatea pɨpulura, uzta. Uskas, mamaz Judío ɨnintuzkasa, Judío awaruza ɨninnara. Usne nil uzta, wat awa akwa. ");
INSERT INTO kwi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Usne Judío katsa ɨnintuz kiarɨt aizpa nɨjkultachi. Usne Dios amtu payu tɨrizta, awaruza ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Usne Pilatora ɨt kit kaizta: “Jesúsne irɨt. Nawa chɨhkazha, na ussa uk kulta kamna.” ");
INSERT INTO kwi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Suasmesa Joséne ussa kurishtas utpiz kit ussa putchã pĩnkasa ipta. Suasmesa usne ussa uk kulta kamta. Mɨnainkas an ñancha sun uk kulta tarachi. ");
INSERT INTO kwi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sun viernes payura awane chiwazha kal kiara, awa sábado payura kwaizkulmu akwa. Sun kal kiarawane, sun sábado kwaizkulmu payu mansara. Suasne Sábado tɨlawain kɨnmɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ashampa uskasa Galilea suras arɨttuzne ussa attishtas kanpaara. Uspane ɨat kit ira kam kulkin izara. Miza ussa tarɨt izara. ");
INSERT INTO kwi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Suasmesa uspane uspa yalta kaiyat kit watsal piam pippa kɨat kit watsal piam pihshkas saara, irɨtmikasha nɨna. Uspane Sábado payura kwaizkulara, Moisés ɨnintɨt aizpa kiana. Sun kal kiarawane, sun ashamparuzne sábado payura kwaizkulara, Dios sun payura kal kimanpa ininta akwa. ");
INSERT INTO kwi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo payura tɨlawain kɨntuasmin, uspakas mamaz ashamparuzkas kamkin ɨat kit watsal piam pih saarɨt aizpa mɨlara. ");
INSERT INTO kwi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sun ashamparuz kamkin pianarachasmin, mɨnpazha katsa uk pɨjtara kamtɨt kulkis tainkara. ");
INSERT INTO kwi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kamkin kulta nappamtuasmin, uspane Anpat Jesústa wanmalarachi. ");
INSERT INTO kwi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Uspa izara aizpa minñamtuasmin, sun urain paas ampune uspa mamin kunpailta. Kwisha putchã pĩn kwarɨt. ");
INSERT INTO kwi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ishkuamtu akwa, uspane pilkin wakpuj wainñara. Suasmesa paas ampune usparuza kaiznara: —¿Chima sayamtuas? Uztumikasha kamkin saiman. ");
INSERT INTO kwi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Usne apain tuchi. Kuhsnintɨt. Galilea sura us kaizta aizpa nɨjkultain. Ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Mɨnpazha Ampu namtɨtmikasha chɨhkanintawa, kwail awa ussa piantanapa. Uspane ussa kurishta irukasa patpian piantaanazi, inapa. Kutña payura irɨttas kuhsnazi,” kizta. ");
INSERT INTO kwi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Suasne uspane Jesús kaizta aizpa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kamtɨt kultas kaiyarawane, uspane sun izara aizpa once ɨnintaruzakas wantuzakas kainanara. ");
INSERT INTO kwi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Magdalena suras Maríakas, Juanakas, Maríakas, Santiagowa akkuhsh, mamaz ashamparuzkas uspa izara aizpa Jesús ɨnintuza kainanara. ");
INSERT INTO kwi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jesúspa ɨnintaruz sun pit kain i minñara akwa, uspane ashampa kaizara aizpa nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Suasne Pedrone usparuztas puz kit kamtɨt kulta ãĩn ɨra. Sum kirɨt kit ayukta iztuasmin, usne pĩn mamarain tarɨt izta. Yalta kailtuasmin, usne iztasparɨt, sun kirɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sun payuin paas kammuruzne Jerusalén pɨpuluras puzpailta. Once kilómetro ɨt kit Emaús pɨpulura piannanpain ara. ");
INSERT INTO kwi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Uspane chiwazha kirɨt aizpa kwinta kiwas ɨmtuwaiyara. ");
INSERT INTO kwi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kwinta kiamtazasmin, uspa paas mɨmamtazasmin, Jesúsmin uspa paaskasa wanmak kit chamɨzta. ");
INSERT INTO kwi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesústa izpailtakas, uspa paasne uspakasa chammikasha piankaamas. Diosne uspa paasta piankamnintachi. ");
INSERT INTO kwi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesúsne usparuza mɨmara: —Ɨmtazasmin, ¿chi kwinta kimtuas? Us sun paasta mɨmara akwa, uspa paasne iztaspat kit kunat kit tayalpailta. ");
INSERT INTO kwi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mazane, Cleofas muntɨtmikane, ussa mɨmara: —Wan Jerusalén pɨpulura piannattuzne an payura sun kit aizpa pian. ¿Mizama nuin sun kit aizpa pianchi? ");
INSERT INTO kwi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Usne usparuza mɨmanara: —¿Chi kirɨt? Uspane ussa sɨnkailta: —Jesúsne, Nazaret pɨpulura uztamikane, ire. Usne Diospa an wat tɨnta kainammmika tuazi. Usne akkwan iztasparɨt kal kit kit kwisha watsal pit awaruza kwinta kinara. Wan awane Dios ussa ɨninta piankamara. ");
INSERT INTO kwi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Au katsa pariyaruzkas au katsa mikwaruzkas Jesústa chɨhkaara, Pilato ussa inazi kiznapa. Suasne usne ussa kurishta irukasa patpianninara. ");
INSERT INTO kwi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akkwan payukima aune Jesústa tɨriznashɨ, Judío awaruza chɨhtanapa, Roma awaruz usparuza ɨninamanpa. Jesús irɨtkis, kutña payu pɨntɨt. ");
INSERT INTO kwi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mɨnpazha aukasa cham ashamparuzne aumɨza ishkwinñara. Uspa tɨlawain kamtɨtkin tuasmin, ");
INSERT INTO kwi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesústa izarachi. Suasne uspane aumɨza kaiyat kit “ángelta iztamakpas” aumɨza kaizara. Ángelne “Jesús uzi” kizpailta. ");
INSERT INTO kwi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Au izmuruzne, mamaz wanmaktuzne, ira kamtɨtkin ɨat kit sunkanain ashampa kaizara aizpa wanmalta. Uspakas ussa izarachi. ");
INSERT INTO kwi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Suasne Jesúsne usparuza kaiznara: —Une wat piankamarachi. Une Dios kainammmika kaizta aizpa wat mɨarachi. Nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Chiyura nurachasmin, Cristone sun kit aizpa naiznatkin, tɨnta namna. ");
INSERT INTO kwi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Suasne Jesúsne usparuza wan Dios pit kamtanara. Usne usparuza ussa Moisés pɨnkɨh parɨt aizpakas ussa wan Dios pit kainammtuz parɨt aizpakas kamtanara. ");
INSERT INTO kwi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ɨamtuasmin, uspane sun pɨpulura piannanpain. Jesúsne ñancha ɨshimtukanain kira, pɨpulura napmanpa. ");
INSERT INTO kwi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Uspane ussa kwisha paikwat kit kaizpailta: —Aukasa mari. Me nashtɨmtui. Me tɨl parɨmtui, kizpailta. Suasne usne uspakasa ɨt kit uspa yalta napta. ");
INSERT INTO kwi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Misharɨ uspakasa uzkane, usne pan sap kit Diosta aishtaish kizta. Pan kɨztawane, usne usparuza nailnara. ");
INSERT INTO kwi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dios uspa kasu izkulnintakane, uspane ussa piankampailta. Sun urain usne usparuztas kulara. Masain kakshihtɨt. ");
INSERT INTO kwi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Uspane usparuzpain kaizpailta: —Us aukasa miwara kwinta kimtuasmin, us aumɨza Dios pit kamtamtuasmin, aune kaijchura, ayukta, wat kultuanash. ");
INSERT INTO kwi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Suasne sun urain kunat kit Jerusalén pɨpulura kailmɨzpailta, once ɨnintuzakas mamaztuzakas wanmalmukin wanmakna. Sun wanmakmuruzne uspa paasta kaiznara: ");
INSERT INTO kwi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Watcha. Anpatne irɨttas kuhsta. Pedrokas ussa izta. ");
INSERT INTO kwi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Suasne miwara ɨamtuasmin, uspane usparuza kirɨt aizpa kwinta kinara. Jesús uspakasa pan kɨztawane, uspane ussa piankamara, kizara. Sunkana kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Uspa sunpa kwinta kiamtuasmin, Jesúsne uspa paizkakin kun kit kaiznara: —Dioskasa wat uzwizanaka. ");
INSERT INTO kwi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Uspane kwisha ishkuarɨt, irɨt izpul izwiznas minñarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sunkana Jesúsne kaiznara: —¿Chikishma u izamtu aizpa ishkuamtuas? ¿Chikishma nilchi minñamtuas? ¿Chikishma u kaijchura sun kirɨt aizpa mɨmaamtuas? ¿Chi kirɨt? ");
INSERT INTO kwi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ap chihtɨrakas ap mittɨrakas iztain. Na Jesús ish. Paazha. Iztain. Izpulne ñakas sɨhkas wajchi. Nane ñakas sɨhkas wajish, kiznara. ");
INSERT INTO kwi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sun kainanarawane, Jesúsne usparuza paiña chihtɨkas paiña mittɨkas annara. ");
INSERT INTO kwi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ussa izna wat kulamtukas, uspane mama us sun kaizta aizpa nɨjkularachi. Awa ishkuamtu akwa, awa iztaspamtu akwa, usne mɨmanara: —¿Kumira mɨjchimakkiwas? ");
INSERT INTO kwi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Suasne uspane pitti pishkaru iltakas mishkikas kwinñara. ");
INSERT INTO kwi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Usne sap kit uspa paizkakin kwara. ");
INSERT INTO kwi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Suasne usne kaiznara: —Na ukasa uzasmin, nane ap pit uruza kwinta kinara. Wanne nawa pattɨt aizpa me kirɨt. Moisés pɨnkɨhta para aizpakas, Dios kainammtuz pɨnkɨhta para aizpakas kanta pɨnkɨhta para aizpakas kirɨt. ");
INSERT INTO kwi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Suasmesa Jesúsne usparuza Dios pɨnkɨhta patninta aizpa piankamninnara. ");
INSERT INTO kwi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ankas usne kaiznara: —Dios pɨnkɨhta ka para: “Cristone, Dios nɨrɨtmikane, naiznatkin. Kutña payura irɨttas mamasa kuhsnatkin.” ");
INSERT INTO kwi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Une Jerusalén pɨpuluras wan surakima awaruza Dios pit Jesúspa kainanarawa, kwail kimtuz uspa kwail chɨhkaat kit maizanapa, Dios uspa kwail kiarɨt aizpa wat kulnanapa. ");
INSERT INTO kwi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Une awaruza sun izara aizpa kainanarawa. ");
INSERT INTO kwi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ankas nane, ap Taitta kin namtɨt aizpa, paiña Sɨnam Izpulta, uruza ɨninnanash. Mane an pɨpulukin nukkultain Dios Izpul uruza akane, usne uruza tɨnta namninnanazi. ");
INSERT INTO kwi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Suasne Jesúsne usparuza pɨpulu pianamal mɨlnara, Betania pɨpulurakima. Paiña chihtɨ anaktuasmin, usne uspa akwa Diosta paikwat kit kaiznara: —Dioskasa watmin ɨizanaka. ");
INSERT INTO kwi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Usparuza watmin ɨizanaka kiztawane, Jesúsne usparuztas nurɨt, chiyurakima. ");
INSERT INTO kwi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ussa wakpuj wainñarawane, uspane wat kulat kit Jerusalén pɨpulura kaiyara. ");
INSERT INTO kwi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Uspane pailta payukima Dios katsa yalta nappat kit Dios kwisha wari kizara. Pailti.");
INSERT INTO kwi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Au su sarachasmin, mazane, Pit muntɨtmikane, uzazi. Usne Taitta Dioskasa uzazi. Usne Dioskasa kawarain azi. ");
INSERT INTO kwi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Su sarachasmin, an Pit muntɨtmikane, an ñancha Dioskasa sulmin uzazi. ");
INSERT INTO kwi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Us akwa Diosne wan chiwal sara. Diosne an Pit muntɨtmika akwa chiwal kirɨt. ");
INSERT INTO kwi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","An Pit muntɨtmikane awaruza pailta payukima uzninamtu, awa watcha piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","An Pit muntɨtmikane tɨlkwilta aizmu, impil kai aiztukana. Usne tɨlkwilta chamturuza Diosta piankamninnanazi. Diablowa kwail mikwaruzne Dios kamtamtu aizpa anuppasachi. ");
INSERT INTO kwi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Diosne maza ampura ɨninta. Usne Juan munazi. Awaruza pira munnara. ");
INSERT INTO kwi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Anne at, awaruza aizmumikawa kainanana, us kaizta aizpa mɨat kit piankamat kit an Pit muntɨtmikasha nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanne kai aizmumika chi. Usmin at kit kai aizmumikawa kainanara. ");
INSERT INTO kwi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","An kai aizmumika watcha i. Anne at kit wan awara kai malninamtu. ");
INSERT INTO kwi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","An Pitne au sukin pianara. Diosne us akwa an su sara. An sukin uztuzne ussa piankamarachi. ");
INSERT INTO kwi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paiña sukin pianatkas, an sukin uztuzne ussa sapparachi. ");
INSERT INTO kwi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sunkana mɨnpazha ussa sappamturuzkas us kaizta aizpa nɨjkulamturuzkas Dios painkul namashina. ");
INSERT INTO kwi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Au sukin awaruz uspa pashparuza kawiamtukas, Diosne awaruza namashina, paiña pashparuza kawiranana. Ampune ussain Dios painkul kawirakana namninasachi. Diosmin awaruza paiña painkul namninnashina. ");
INSERT INTO kwi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","An Pit muntɨtmikane awa namta. Usne awaruza pashinat kit kiwainnashimtu. Uskas aumɨza nil kamtanara, Diosta piankamanapa. Usne aukasa an sukin uzta. Aune ussa iztamakpas. Usne kwisha wat kai puzta. Diosne paiña painkultain kwisha tɨnta namninta. ");
INSERT INTO kwi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanne us akwa paranat kit kaizta: “Nane us akwa usparuza kainanarau. Us nawa kwizpa amtukas, usne nakin an ñancha uzta. Usne nakin anza tɨnta i.” ");
INSERT INTO kwi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Usne aumɨza akkwan wat kiat kit kiwainnamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diosne Moisésta ɨninta, awa us kaizta aizpa kianapa. Mane aune Dios aumɨza panashimtu piankamtumakpas, Dios Jesucristo ɨninta akwa, watcha aumɨza kainanapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mɨnminkas Diosta izarachi. Paiña painkulmin Papihshkasa sulmin uztu. Usne aumɨza paiña Papihshta piankamninnarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén pɨpuluras Judío awa ɨninturuzne pariyaruzakas kamtamtuzakas Juanta “¿nune mɨnmas?” mɨmanapa ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Usne nil sɨnkanara: —Nane watsat mɨlmumika chish, kiznara. ");
INSERT INTO kwi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Suasne mamasa kaizat kit mɨmaara: —¿Nune mɨnmas? ¿Elías, Dios pit kainammmikakish? Juanne kaiznara: —Nane chish. Kwizta ussa mɨmaara: —Suasne, ¿Nune mamaz wat kainammumikakish? Usne sɨnkanara: —Nane chish. ");
INSERT INTO kwi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Suasne ussa kaizara: —¿Mane nune mɨnmas? Aune au ɨnintaruza sɨnkarawamakpas. ¿Nuwa chima kiztus? ");
INSERT INTO kwi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanne Isaías kainammmika Juanpa kaizta aizpa sɨnkanara: —Nane pul suwara ka kainammtus: “Nane kwianmumika ish, Anpatpa mi nil saanapa.” ");
INSERT INTO kwi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseo awane uspa Fariseo awaruza Juanta kwinta kinpa ɨninnat kit mɨmaat kit kaizara: ");
INSERT INTO kwi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Nu Dios watsat mɨlmumika chine, Elías chine, kainammumika chine, ¿Chikishma munnanamtus? ");
INSERT INTO kwi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanne sɨnkanat kit kaiznara: —Nane kwazikasa munnanamtus. Mazane u paizkakin kun. Une ussa pianchi. ");
INSERT INTO kwi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Us nakin kwizpa amtukas, usne nakin an ñancha uzta. Usne an tɨnta ɨninmika namnazi. Nane paiña kiwainmumika ish. ");
INSERT INTO kwi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wanne sunkana kirɨt Betania pɨpulukin. Sun pɨpulune Jordán pi pãn puzmumakin uz. Suane Juanne awaruza munnanarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tɨlawara Juanne Jesústa izta. Jesús ussa amtuasmin, Juanne awaruza kaiznara: “¡Iztain! Anne Dios ɨnintamika i. Usne ussa ɨninta, kwail kiarɨttuza wat kultananapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nane us akwa ñamin kaiztau: ‘Mazane ap kwizpa amtu. Usne nakin anza tɨnta ɨnintamika i. Uskas nakin an ñancha uzta.’ ");
INSERT INTO kwi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nakas Dios an ɨnintamikasha pianchi arau. Nane arau, kwazikasa munnana, Israel awaruz ussa piankamanapa.” ");
INSERT INTO kwi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sunkas Juanne kaiznara: “Nane Diospa Izpulta iztau. Sɨnam Izpulne chiyuras taiz kit ussa nukkulta. Sɨnam Izpulne utkurukana iztɨt. ");
INSERT INTO kwi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mama nane Dios ussa ɨninta pianchi arau. Nawa kwazikasa munnana ɨninmikane kaizta: ‘Nune Diospa Izpul maza ampura taiz kit nukkulka iznazi. An ampune awaruza Sɨnam Izpulkasa winninnanazi.’ ");
INSERT INTO kwi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na watcha sun izta akwa, nane uruza ka kaiznamtus: ‘Anne Dios Painkul i.’ ” ");
INSERT INTO kwi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tɨlawara Juankas paiña paas kanpamtuzkasa suain tuara. ");
INSERT INTO kwi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús pɨntura iztuasmin, Juanne kaizta: —Iztain. Anne Dios ɨnintamika i. Usne ussa ɨninta, awa kwail kiarɨttuza wat kultananapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","An paas Juanta kanpamtuzne sun kizka mɨt kit Jesústa kanpailta. ");
INSERT INTO kwi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesúsne ussa kwizpa kanpaka iz kit kaizta: —¿Chima saimtuas? Uspane kaizpailta: —Kamtam, ¿Mɨntama uzish? Usne sɨnkara: —¡Izna arain! ");
INSERT INTO kwi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uskasa ɨil kit us uzkin izpailta. Sun payuin uskasa mailta, ampara urara panapain akwa. ");
INSERT INTO kwi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mazane, Juanta mɨramikane, Jesústa kanpara. Usne Andrés muntɨt. Usne Simón Pedrowa aimpihsh. ");
INSERT INTO kwi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","An mɨmtuchasmin, Andrésne paiña aimpihshta, Simónta, saina ɨt kit kaizta: —Aune Dios watsat mɨltamikasha, wanmaltawas. Anne Dios narɨtmika i. Aune ussa Mesías muntawas. ");
INSERT INTO kwi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Suasne Andrésne Simónta Jesús tura mɨl kit Jesústa karara. Jesús ussa iztawane, kaizta: —Mane nune Simón muntɨt. Up taittane Juan muntɨt. Mane Cefas munnazi. (An munne Pedrokas ukkas kawarain mun). ");
INSERT INTO kwi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tɨlawarane Jesúsne Galilea sura ɨshira. Felipera wanmal kit kaizta: —Kanpazha, ap kammumika namnapa. ");
INSERT INTO kwi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipene Betsaida pɨpuluras azi. Suane Andréskas Pedrokas uzpailta. ");
INSERT INTO kwi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Suasne Felipene Natanaelta sait kit kaizta: —Aune mazara wanmaltamakpas. Moisésne us akwa Dios ɨnin pɨnkɨhta parɨt. Dios kainammtuzkas us akwa paraara. An Jesúsne Joséwa painkul i. Usne Nazaret pɨpuluras i. ");
INSERT INTO kwi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelne kaizta: —Nasaret pɨpuluras chinkas wat puzsachi. Felipene sɨnkara: —At kit ussa izti. ");
INSERT INTO kwi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael Jesús tukin kashara piannamtuasmin, Jesúsne ussa iz kit kaizta: —Ussa izti. Apa wat Israel awa amtui. Watcha kwinta kimtu akwa, usne mamaztuza kain kikain. ");
INSERT INTO kwi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelne ussa mɨmara: —¿Mizama nawa pianish? Jesúsne sɨnkara: —Felipe nua akwatchasmin, nane nu tukin piankamtau. Nune hiquera tɨ kwalkin uzta. ");
INSERT INTO kwi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Suasne Natanaelne kaizta: —Ap kamtam. Nu kaiztɨt akwa, nane nu Dios painkul i pianish. Nune au Judío awawa ɨnintamika i. ");
INSERT INTO kwi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesúsne ussa kaizta: —Nu hiquera tɨ kwalkin uztuasmin, nane nu tukin piankamtau. Na sun kizta akwa, ¿nawa nɨjkulmas? Nune ankin anza katsa kal iznazi. ");
INSERT INTO kwi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesúsne ankas kaizta: —Watcha kaiznamtus. Mamaz payura, une chiyura izakkanazi. Wanish ɨkane, chiyu kai kinazi. Suane une Diospa ángeltuza izanazi. Uspane Jesús tukin, chiyuras ampu tukin, ɨanazi. Tas au sukin kihshanazi. Chiyuras ampu akwa, Dioskas awaruzkas usparuzain kwinta kianazi. ");
INSERT INTO kwi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kutña payura pailka, kasara kit pishta Caná pɨpulura wa. Sun pɨpulune Galilea sukin uz. Jesúspa akkuhshkas sua tuazi. ");
INSERT INTO kwi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pishta sammikane Jesústakas, awaruzakas, paiña kammuruzakas akwanarɨt, kasara pishta izanapa. ");
INSERT INTO kwi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino pailtɨkane, Jesúspa akkuhshne ussa kaizta: —Vino pailtɨt me. ");
INSERT INTO kwi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesúsne ussa sɨnkara: —Akkwa, ¿Chitkishma nawa sunkana kaiztus? Kaizapmun. Wat aizpa nil urara kinash. ");
INSERT INTO kwi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Maríane nailmuruza kaiznara: —¡Us kaiztu aizpa kirain! ");
INSERT INTO kwi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Suane seis kwazi ulmu pura. Ukta sarɨt. Judío awane sun kwazikasa akkwan piji usparuza kitnara. Sun kiarɨt akwa, uspane Dios iztakin sɨnam namarɨt minñaara. Maza ulmu cien botellakima ultu. ");
INSERT INTO kwi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesúsne nailmuruza kaiznara: —¡Ulmura kwazikasa ultain! Puntakima ulaara. ");
INSERT INTO kwi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ultarawane, Jesúsne usparuza kaiznara: —¡Mane pitchin ukkat kit pishta samtumikasha mɨltain! Sunkana kiara. ");
INSERT INTO kwi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pishta sammikane kwazi vino namtɨtta kwaizta. Usne mɨntas puzta pianchi. Nailmuruzpain pianmazi. Uspane kwazi ulara. Pishta sammikane kanpain mɨjmikasha akwat kit kaizta: ");
INSERT INTO kwi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—An ñancha wan awa anza wat vino kwinnamtu. Akwarɨttuz akkwan vino kuarɨkane, suasne muinchi vino kwinamtu. Sunkana nune anza wat vino kwinna makima watsarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesúsne sunkana kira Caná pɨpulukin, Galilea sura. Usne sun an ñancha iztasparɨt kal awara kamtana kira, awa ussa piankamanapa, kwisha wat kal kirɨt kizanapa. Suasne aune, paiña kammuruzne, ussa nɨjkultamakpas. ");
INSERT INTO kwi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sun kitpane, Jesúsne Capernaum pɨpulura kihshta, akkuhshkasa aimpihshtuzkasa kammuruzkasa. Suane uspane akkwan payuchin maara. ");
INSERT INTO kwi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judío awaruzpa Pascua pishta kasha taizkane, Jesúsne Jerusalén pɨpulura ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diospa katsa yalta naptɨkane, usne akkwan awaruza wanmalnara. Mɨnpazha ampu wakarakas, pɨrikukas, utkurukas paininñara. Mamaztuzne misharɨ uzat kit awaruzpa pial maizara, awa wakarakas pɨrikukas utkurukas paina, Diosta mɨlanana. ");
INSERT INTO kwi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sun iztawane, Jesúsne ilmu tɨtkasa sat kit wan awaruzakas pɨrikuruzakas, wakararuzakas Dios yalkis pianamal ɨninnara. Usne pial maizmuruzpa pialtakas misharɨkas kiakpɨntara. ");
INSERT INTO kwi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Utkuru painintuza kaiznara: —¡Akkis sun ukkat kit ɨrain! Ap Taittawa yalkin paininman. Paininmu yal chi. ");
INSERT INTO kwi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Suasne paiña kanpamtuzne Dios pit pɨnkɨhta para aizpa nɨjkulara: “Na up yalta akkwan pashimtu akwa, awane nawa piantanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Suasne Judío awa ɨninturuzne ussa mɨmaara: —¿Chishma sun kimtus? ¿Dios nua ɨninma, sun kin? Dios nua ɨnintane, wat kal kit aumɨza ancha. ");
INSERT INTO kwi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesúsne sɨnkanara: —An Diospa yal azpiantane, nane kutña payura mamasa sanash. ");
INSERT INTO kwi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judío awa ɨninturuzne kaizara: —Awane cuarenta y seis añokima Diospa yal saara. ¿Nune an yal kutña payukima sanakish? ");
INSERT INTO kwi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dios yalpa kaizkane, Jesúsne paiña ña antu, Dios paiña ña irɨttas kuhsninshimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Katmizna, Jesús irɨttas kakultawane, paiña kanpamtuzne sun payu us kaizta aizpa minñat kit Dios pɨnkɨhtakas us kaizta aizpakas nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua pishta asmin, Jesúsne Jerusalén pɨpulura tuazi. Akkwan awane us iztasparɨt kal kimtu aizpa izat kit ussa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wan awaruza pian akwa, Jesúsne usparuza nɨjkulnarachi. ");
INSERT INTO kwi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesús wan awa minñamtu aizpakas kiamtu aizpakas pian akwa, mɨnminkas ussa kamtanashimtuchi, wan awa ayukta minñamtu aizpa pian akwa. Awaruzne maizpa maizamtu. ");
INSERT INTO kwi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nicodemone Judío awaruza ɨninmika azi. Usne Fariseo awakana Diosta wakpuj wainta. ");
INSERT INTO kwi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Usne maza amta Jesús tukin ɨt kit kaizta: —Kamtam. Aune Dios nua ɨninta pianmakpas, aumɨza kamtanana. Dios nua kiwaintu akwa, nune akkwan iztasparɨt kal kimtu, awara kamtanana. ");
INSERT INTO kwi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Suasne Jesúsne ussa kaizta: —Watcha nua kaiztus. Dios awara maiztukine, awane Dios awara mamasa kawirakanain namtachine, Dios ɨnintukin uzna napsachi. ");
INSERT INTO kwi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemone ussa mɨmara: —¿Ɨlapane mizama mamasa kawishinai? Usne akkuhshpa pɨjawara wasachi, mamasa kawina. ");
INSERT INTO kwi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesúsne ussa sɨnkara: —Watcha nua kaiztus. Mɨnminkas Dios ɨnintukin napmanazi, kwazi akwakas Sɨnam Izpul akwakas kawirachine. ");
INSERT INTO kwi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Papihshkas akkuhshkas au sukin pashpa uznapa kawinintu. Diospa Sɨnam Izpulne awawa izpulta namnintu, chiyura uznapa. ");
INSERT INTO kwi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na “wan awa mamasa kawirawa” kizkane, nune iztaspamun. ");
INSERT INTO kwi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Inkwane mɨnpa pamtu. Inkwa ɨka, mɨm. Masetne pa ɨmtu. Masetne apa amtu. Mɨntas amtu pianchimakpas. Mɨnta ɨmtu pianchimakpas. Kawarain aune miza Dios Sɨnam Izpul awaruza maizninna wat pianchimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Suasne Nicodemone mamasa ussa mɨmara: —¿Mizama kai sun? ");
INSERT INTO kwi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesúsne ussa sɨnkara: —Nune Judío awaruza kamtammika i. ¿Nune sun pianchikish? ");
INSERT INTO kwi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Watcha nua kaiztus. Aune pian aizpa paramuspas. Izta aizpakas kwinta kimuspas. Une au kaizta aizpa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nane uruza an sukin kimtu aizpa kwinta kinarau. Nawa nɨjkularachi. Chiyura kimtu aizpa kwinta kitne, une na kaizta aizpa nɨjkulamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mɨnminkas chiyura nurachi. Chiyuras Ampumin chiyura uz kit tas kihshta, awaruza chiyuwa piankamninna. ");
INSERT INTO kwi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés pul sak sura tuasmin, usne iru kamta sat kit tɨra kanta, awa iru kamta izanapa, awa kamta akwa iamanpa. Sunkanain Chiyuras Ampune kurishta patpiannazi, awaruza watsat mɨlnanapa, uspa kwail kiarɨt aizpa wat kultanapa. ");
INSERT INTO kwi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wan ussa nɨjkulararuzne pailta payu uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Diosne au sukin uztuza kwisha pashinara akwa, usne paiña painkulta, mazain mɨjmikasha, au akwa apa ɨninta, ussa nɨjkulararuz ĩnta ɨamanpa. Ussa nɨjkulararuzne pailta payukima wat uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosne paiña painkulta awaruza ilnanapa ɨnintachi. Piru usne ussa ɨninta, awaruza watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Diosne paiña Painkulta nɨjkultumikasha ilninmanazi. Piru Diosne nɨjkultuchimikasha ilnanazi, Dios Painkulta, mazain mɨjmikasha, nɨjkultachi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sunkana Diosne awaruza ilnanazi. Usne paiña painkulta, impil aizmukanain ɨninta, awa ussa piankamanapa. Kwail kiara akwa, awane tɨlkwiltain ɨashira, uspa kwail kiara aizpa kai izamanpa. Watcha pashiarachi. ");
INSERT INTO kwi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwail kimtuzne kai aizmura uzna pashiamtuchi. Uspane watchara aashitchi, uspa kwail kiarɨt aizpa kai piankamamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dios ɨnintu aizpa kishiamtu akwa, watcha kimturuzne kai aizmura ɨamtu. Uspa Dios kaizta aizpa mɨara akwa, wanne uspa kal kai izanazi. ");
INSERT INTO kwi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sun kitpane, Jesúskas paiña kanpamtuzkas Judea sura ɨara. Uspane sua pampa payu maara, awaruza munnana. ");
INSERT INTO kwi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juankas Enón pɨpulura, kasha Salím pɨpulura, munnamɨzta. Suane akkwan kwazi wa. Awa us tukin wanmakkakane, Juanne usparuza munnanara. ");
INSERT INTO kwi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juanta kajchira sɨptachasmin, sunkana kirɨt. ");
INSERT INTO kwi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mɨnpazha Juanta kanpamtuzne maza Judío awakasa tɨnta kwinta kiamɨzta. Uspane yawa piji Judío awa kittamtu kwinta kiara, Dios iztukin sɨnam sana. ");
INSERT INTO kwi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yawa piji Judío awa kittamtu aizpa minñamtu akwa, uspane Juanta ɨat kit kaizara: —Kamtam, izti. Nune aumɨza sun ampuwa wat kainarɨt. Usne, Jesús muntɨtmikane, nukasa pãn puzmuwara, Jordán pinamin, chamtuazi. Mane usne akkwan awara munnanamtu. Uspane ussa kanpaamtu. ");
INSERT INTO kwi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan sɨnkanara: —Dios awara kiwaintachine, awane anza tɨnta namsachi, paiña kal kin. ");
INSERT INTO kwi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Une piankam kit na kaizta aizpa mɨara. Ka kiztau: “Nane Dios narɨtmika chi ish. Diosne nawa ɨninta, us iztakin an ñancha ɨn.” ");
INSERT INTO kwi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na kaizta aizpa uruza piankamninnashimtu akwa, nane an kwinta kinash. Casara kit pishta samtune, ampu kanpain mɨjmikane ashampa kanpain mɨjmikasha mɨj. Ampu kanpain mɨjmikawa izmumikane makin mɨt kit kuntu. Sun parɨt aizpa mɨrawane, watsal mintu. Nakas sunkanain mane watsal mintus, akkwan awa Jesústa ɨamtu akwa, us kaizta aizpa mɨamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Usne anza tɨnta namtawa. Nane an we tɨnta namtawaish. ");
INSERT INTO kwi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kwashpas amtumikane wan awakin anza tɨnta i. Au sukin kawiramikane an sukin kimtu aizpa paramtu. Kwashpas amtumikane wan awakin anza tɨnta i. ");
INSERT INTO kwi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Usne iztɨt aizpakas mɨrɨt aizpakas awara kainanamtu. Akkwan awaruzne us kaiztu aizpa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Us kaizta aizpa nɨjkultumikane Dios kaizta aizpa watcha i kiztu. ");
INSERT INTO kwi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios ɨnintɨtmikane Dios pit paramtu, Dios ussa paiña Sɨnam Izpul mɨlarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Papihshne paiña painkulta pashit kit paiña kal ussa chɨhkara, wan ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Painkulta nɨjkultumikane makis pailta payurakima unazi. Sunkana ussa nɨjkultuchimikane sunkanain uzmanazi. Diosne usparuza ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo awaruzne Jesúspa mɨara. Jesúsne Juankin an akkwan kanpamtuz mɨjara. Uskas an akkwan awaruza munnaninnara. ");
INSERT INTO kwi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesús tukas, paiña kanpamtuzne awara munnanara. Usmin sun kitchi). ");
INSERT INTO kwi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo awaruzne Jesús kimtu aizpa piankammara. Jesús usparuza pilchapuznashitchi akwa, Jesúsne Judea sukis puz kit mamasa Galilea sura kailta. ");
INSERT INTO kwi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɨmtuasmin, usne Samaria suwara pɨnshimtuat kit ");
INSERT INTO kwi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sicar pɨpulura piannara. An pɨpulune mamaz sura kashain uz. Ñamin au irɨt kwal Jacobne paiña painkulta, Joséra, sun su mɨlara. ");
INSERT INTO kwi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Suane Jacobne kwazi kul sarɨt. Miwa ɨmtuasmin kwaiztɨt akwa, Jesúsne kwazi ukkam kulkin uzta. Paizka payu panapain. ");
INSERT INTO kwi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Paiña kammuruz pɨpulura chiwazha kumira paina ɨarɨkane, Samaria pɨpuluras ashampane kwazi kulkin ara, kwazi ukkana. Jesúsne ussa kaizta: —Kwazi kwincha. ");
INSERT INTO kwi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria pɨpuluras ashampane iztasparɨt, au Judío awakas Samaria awakas usparuzpain chinkas naiyamtu akwa. Usne Jesústa ka kaizta: —Nune Judío awa i. Nane Samariakis ashampa ish. ¿Chikishma nawa kwazi paikumtus? ");
INSERT INTO kwi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Suasne Jesúsne ussa sɨnkara: —Nune Dios mɨlashimtu aizpa pianchi. Nune nawa kwazi kwincha kizmumikasha pianchi. Ussa kwazi kwan paikwatne, usne nua kwazi kwinazi, nu pailta payukima uznapa. ");
INSERT INTO kwi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ashampane ussa kaizta: —Anpat. Nune chinkas mɨjki, kwazi ukkana. An kwazi kulne kwisha ainkih i. ¿Nune mɨntas kwazima kwinnash, na uzna? ");
INSERT INTO kwi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Au ñamin irɨt kwalne, Jacobne, an kwazi kul sat kit aumɨza chɨhkanarɨt. Uskas paiña painkultuzkas paiña kalpakas an kulkin kuara. ¿Nune Jacobkin anza tɨnta kish? Nune an Jacobkin aumɨza kiwainsachi. ");
INSERT INTO kwi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesúsne ussa sɨnkara: —An kwazi kwattuzne mamasa kwazi kiyanazi. ");
INSERT INTO kwi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Na kwazi kwinka kwattuzne mizurainkas kwazi kiyamanazi. Nua na kwazi kwintu aizpa kwazi puzmu kulkana puznazi, pailtachin. An kwazine nua uzninnazi, pailta payukima. ");
INSERT INTO kwi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Suasne ussa wat mɨrachi akwa, ashampane kaizta: —Anpat, sun kwazi kwincha, na kwazi kilmanpa, an kwazi kulta amanpa, kwazi ukkana. ");
INSERT INTO kwi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesúsne ussa kaizta: —An ñancha ɨt kit up ampura akwarash. Suasne akkin anka. ");
INSERT INTO kwi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Usne kaizta: —Nane ampu mɨjchish. Suasne Jesúsne kaizta: —Na ampu mɨjchi kizkane, nune watcha kaiztui. ");
INSERT INTO kwi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Makima nune cinco ampu mɨjazi. Nu mɨjmikane up ampu chi. Nu kaizta aizpa watcha i. ");
INSERT INTO kwi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sun mɨrawane, ashampane ussa kaizta: —Anpat. Nu sun nawa pian akwa, nane nu Dios pit kainammmika i piankamtus. ");
INSERT INTO kwi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aune ¿Mɨntama Diosta wakpuj wainñanapai? Au ñamin kwal uzasmin, uspane an ɨzakin Diosta wakpuj wainñara. Mane u Judío awane ka kaizamtu: “Jerusalén pɨpulura Diosta wakpuj wainñarawa.” ");
INSERT INTO kwi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesúsne sɨnkara: —Ashampa. Na kaiztu aizpa nɨjkulti. Mamaz payura awane an ɨzara nuamanazi, Diosta wakpuj wainna. Kawarain uspane Jerusalén pɨpulura ɨamanazi, Diosta wakpuj wainna. ");
INSERT INTO kwi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria pɨpuluras awa Diosta wat pianchi akwa, une ussa wat wakpuj wainñasachi. Sunkana aune ussa wat pianmakpas. Diosne Judío awaruza paiña kwal namninnara, au sukin watsat mɨlmumikasha ɨninnapa. Katmizna aune ussa wakpuj waina wat pianmakpas. ");
INSERT INTO kwi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Sun payura Diosta wakpuj wainna me taiztɨt, wan awa wan suwara ussa wakpuj wainñanapa. Sɨnam Izpulne Taitta Dios watcha kaizta aizpa awaruza piankamninnanazi, an sukin Diosta wakpuj wainñanapa. Diosne Sɨnam Izpul i. Sun Sɨnam Izpulne awaruza kiwainnanazi, awa Diosta wakpuj an wat wainñanapa, watcha piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ashampane ka kaizta: —Dios kin namtɨtmikane, watsat mɨlmumikane, piannanpain pianish. (Usne Cristo i). Us akane, usne aumɨza chiwal kamtananazi. ");
INSERT INTO kwi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesúsne ussa kaizta: —Nane Dios kin namtɨtmikakas, watsat mɨlmumikakas, ish. Nane nukasa paramtus. ");
INSERT INTO kwi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sun urain paiña kammuruzne aara. Jesús maza ashampakasa kwinta kimtu akwa, uspane iztaspaarɨt. Mɨnminkas an ashampa ¿Chima pashimtu? mɨmaarachi. Mɨnminkas Jesústa ¿Chima an ashampara paramtus? mɨmaarachi. ");
INSERT INTO kwi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Suasne ashampane paiña kwazi ulmu chɨhkat kit pɨpulura kail kit awara ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Maza ampura izna arain. Usne wan chiwal piankam kit na kirɨt aizpa nawa kaizta. ¿Anne Dios kin namtɨtmikaki? ¿Usne watsat mɨlmumikaki? ");
INSERT INTO kwi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Suasne awane pɨpuluras puzat kit Jesús tukin aara. ");
INSERT INTO kwi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aamtuasmin, paiña kammuruzne Jesústa paikwat kit kaizara: —Kamtam. Chiwazha kwari. ");
INSERT INTO kwi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Usne kaiznara: —Kumira pashitchi ish. Na kal kirɨt aizpa kumirakin an wari. An kumirawa une pianchi. ");
INSERT INTO kwi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Paiña kammuruzne usparuzpain ka mɨmaamɨzta: —¿Mɨnma kumira ussa karatsa? kizara. ");
INSERT INTO kwi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesúsne kaiznara: —Diosne nawa apa ɨninta, awaruza Diospa kainanapa. Nane us kaizta aizpa kishimtus, pailnakima. Na paiña kal kikane, nane kwisha warish. Kumira kwatkanain i. ");
INSERT INTO kwi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Une sunkana minñamtu: “Mane au Judío awane Samaria su uztuza Dios pit kainammtuchimakpas. Mamaz payura aune Galilea su uztuza Dios pit kainanapas.” Apas awane akkwan piji sunkana kizamtu: “Ampara mish we, chara pippara pakna. Suasne kal kiaznapas.” Mane nane uruza kainammtus: “Umakin iztain. Paktu payukana i. Akkwan awa pura akwa, usparuza Dios pit kaizasan, su pit nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Chara pippa malmuruzne pial sappamtu, uspa kal akwa. Kawarain Dios Pit kainammtuzne sappanazi. Mɨnpazha sun pit kainammtu, mamaztuz sun pit mɨanapa. Kwiztane suntuzne mamasa sun pit mɨat kit nɨjkulanazi. Diosne sun pit kainammtuza tananazi. Wan Dios pit kainammturuzne watsal kulanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Apas awane akkwan piji ka kizamtu: “Maza awa pippa warawane, mamazne sun pippa paktu.” ");
INSERT INTO kwi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sunkana kianazi. Mamazne ukin an ñancha Dios pit kainanara. Nane uruza ɨninnara, awaruza akwananapa, ap kwal namanapa. Katmizna sun awane ap kwal namarɨt, u Dios pit kainarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akkwan sun pɨpulukin uztuzne Jesústa nɨjkulara, Samaria pɨpuluras ashampa kaizta aizpa akwa. Usne ka kaiznara: “Usne wan chiwal piankam kit na kirɨt aizpa nawa kaizta.” ");
INSERT INTO kwi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Katmizna Samaria pɨpulura uztuz Jesús tukin piannarawane, uspane ussa paikuara, usparuzkasa maanapa. Usne usparuzkasa paas payukima mara. ");
INSERT INTO kwi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sunkana an akkwan awane us kaizta aizpa mɨat kit us Dios kin namtɨtmika i, watsat mɨlmumika i, nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uspane an ashampara ka kaizara: —Mane aune ussa nɨjkultumakpas. Nu Jesúspa kainarakas, mane aune us kaizta aizpa mɨramakpas. Aune Dios ussa kin namtɨt pianmakpas. Usne au sukin uztuza watsat mɨlmumika i. ");
INSERT INTO kwi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Paas payura Jesúsne Samaria pɨpuluras puz kit Galilea surakima ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesúsmin kammuruza kaiznara: “Ap sukin uztuzne nawa, Dios kainammikasha, nɨjchi kiamtu.” ");
INSERT INTO kwi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sua ussa nɨjchi kiarakas, Jesúsne Galilea sura piannakane, Galilea sukin uztuzne ussa wat sappat kit “kakishapu” kizara. Ñamin uspane Jerusalén pɨpulura ɨara, Pascua pishta izana. Suane uspane Jesús wan kirɨt aizpa an pishtara izara. ");
INSERT INTO kwi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Suasne Jesúsne Caná pɨpulura, Galilea sura kailta. Ñamin usne sun pɨpulukin kwazi vinora namninta. Suane mikwa ɨninmikane tuazi. Usne Capernaum pɨpulura maza painkul imtu mɨj. ");
INSERT INTO kwi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús Judea suras Galilea sukin pianakane, ɨninmikane Jesúspa mɨt kit izna ɨt kit ka paikwat: —Ap yalta ɨtpa, ap painkulta kakulninna. Inapain i, kizta. ");
INSERT INTO kwi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Suasne Jesúsne kaizta: —Na chiwazha iztasparɨt kal kimtukine, une na Diostas at nɨjkulamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɨninmikane kaizta: —Anpat. Ap painkul irachasmin, azain ussa izna anka. ");
INSERT INTO kwi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Suasne Jesúsne kaizta: —Up yalta kailti. Up painkulne kakultu. An ampune Jesús kaizta aizpa nɨjkul kit ɨra. ");
INSERT INTO kwi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Paiña yalta pianatchasmin, paiña kiwaintuzne yaltas puzat kit ussa wanmalat kit kaizara: —Up painkulne kakulti. ");
INSERT INTO kwi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Suasne usne miza paka kakulta mɨmanara. Uspane sɨnkaara: —Anchik nashka maza urara immu kara. ");
INSERT INTO kwi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Suasne papihshne sun urain paiña painkul kakulmɨzta piankam kit Jesús kaizta aizpa ka nɨjkulta: “Up painkul kakulti.” Katmizna uskas wan paiña kwalkas Jesústa, watsat mɨlmumikara nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea suras Galilea surakima mamasa kailtawane, Jesúsne an kwizta iztasparɨt kal kira. ");
INSERT INTO kwi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Akkwan payuchirain Judío awaruz uspa pishta izamtuasmin, Jesúsne Jerusalén pɨpulura kailta. ");
INSERT INTO kwi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén pɨpulukin, pɨriku pɨjtakin, kwazi piwail uz. Judío awane sun piwail Betzata muntɨt. Cinco ɨranchu piwailmakin uzara. ");
INSERT INTO kwi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akkwan ishturuzkas, kasu izsachiruzkas, chasachiruzkas sɨh pailtɨttuzkas sun ɨranchura uzat kit sun piwail kialnapa tɨrizara. ");
INSERT INTO kwi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Masetne maza ángelne piwailta kihsh kit kwazi kialninta. Kwazi kialtuasmin, an ñancha naptamikane chiwazha ishtu mɨj aizpa wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mazane usparuztas treinta y ocho año ishtuazi. ");
INSERT INTO kwi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesúsne us tukin izta. Us akkwan añokima sua tu pian akwa, Jesúsne ussa mɨmara: —¿Ishtu wat pashimtukish? ");
INSERT INTO kwi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ishtumikane ussa sɨnkara: —Anpat, kwazi kialtukane, mɨnminkas nawa kiwainsachi, piwailta azain kihshninna. Na napshikane, mamazne an ñancha naptu. ");
INSERT INTO kwi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesúsne ussa kaizta: —Kuhsakti. Up kama kuhsak kit chat. ");
INSERT INTO kwi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sun urain an ampune kakul kit paiña kama kuhsak kit chamɨzta. An ampu kwaizkultu payura kakultɨt akwa, ");
INSERT INTO kwi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judío awa ɨninturuzne kakultɨtmikasha kaizara: —Ma payu kwaizkultu payu i. Nune up kama mɨlna ɨninsachi. ");
INSERT INTO kwi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","An ampune usparuza sɨnkanara: —Nawa kakulnintamikane nawa ka kaizta: “Up kama kuhsak kit chat.” ");
INSERT INTO kwi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Suasne uspane ussa mɨmaara: —¿Mɨnmika nua “Up kama kuhsak kit chat” kizta? ");
INSERT INTO kwi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kakultɨtmikane ussa kakulnintamikasha pianchi, Jesús akkwan awa purakis karɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kwiztane, Jesúsne ussa Dios katsa yalta wanmal kit kaizta: —Mɨri. Mane nu kakultɨt akwa, mamasa kwail kimun, an kwail nua pizmanpa. ");
INSERT INTO kwi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","An ampune ɨt kit Judío awa ɨninturuza Jesús ussa kakulninta kainanara. ");
INSERT INTO kwi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Katmizna Judío awa ɨninturuzne Jesústa kwail kishara, us kwaizkulmu payura sun kal kirɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesúsne usparuza sɨnkanat kit kaiznara: —Ap Taittane us kishimtu aizpa payu aizpakas sábado payu aizpakas kal kimtu. Sun akwa nakas payu aizpakas sábado payu aizpakas kal kishinash. ");
INSERT INTO kwi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Katmizna, Judío awa ɨninturuzne Jesústa an piantashiara, uspa kwaizkulmu payu ɨnintu aizpa mɨshimtuchi akwa, Dios ap Papihsh i kizta akwa. Uskas Dioskasa kawarain namtɨt. Sun akwa uspane ussa piantashiara. ");
INSERT INTO kwi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesúsne usparuza Sábado payuwa, uspa kwaizkulmu payuwa, sɨnkanat kit kaiznara: “Watcha kaiznamtus. Nane, Dios Painkulne, apminpain kal kimtuchish. Nane ap Taitta kal kimtu aizpa iztus. Nakas ap Taitta kimtu aizpa kimtus. ");
INSERT INTO kwi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sunkana Taittane nawa paiña Painkulta pashimtu. Uskas an katsa iztasparɨt kal kinpa nawa kiwainnazi. Na sun chasachimikasha kakulnintakas, une sunkin an katsa iztasparɨt kal izaanazi. ");
INSERT INTO kwi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sunkana kirɨnazi. Taitta irɨttuza kuhsninnamtu akwa, usparuza mamasa uzninnamtu akwa, paiña Painkulkas pashimturuza uzninnashina. ");
INSERT INTO kwi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taittane mɨnainkas kwail kirɨt kizmanazi, paiña Painkulta wan cɨhkat akwa, awara kwail kiamtu kiznanapa, awaruza ilnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Suasne wan awane Painkultakas Taittarakas kawarain wat minñanazi. Painkulta, Dios ɨnintamikasha, nɨjchi kimturuzne Papihshtakas nɨjchi kiamtu. ");
INSERT INTO kwi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Watcha uruza kaiznamtus. Na kaizta aizpa mɨmturuzne, nawa ɨnintamikasha nɨjkulturuzne pailta payukima uzanazi. Diosne uspa kwail kiarɨt aizpa ilmanazi, ĩnta pakmanpa, Dioskasa uzanapa. ");
INSERT INTO kwi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Watcha uruza kaiznamtus. Ma payu nɨjkulturuzne na kaiztu aizpa mɨat kit kianazi. Dios Painkul kaizta aizpa mɨraruzne uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Papihshmin awaruza uzninnashina. Sunkana Papihshne painkulta kiwainta, awaruza uzninnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nane chiyuras ish. Diosne nawa narɨt, awa kwail kiarɨt kiznanapa, kwail kimtuza ilnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na uruza kaiztu aizpa iztaspaman. Mamaz payura wan kamkin irɨttuzne nawa mɨanazi. Nane usparuza mamasa kuhsninnanazi. Sun payu taiznapain. ");
INSERT INTO kwi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Wat kirɨttuzne, irɨttas kuhsanazi, pailta payu uzanapa. Kwail kirɨttuzne irɨttas kuhsak kit uspa kwail akwa naizanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ap minpain kal kisachish. Nane ap Papihsh nawa ɨnintu aizpa kimtus, awaruza kwail kiarɨt aizpa kiznanapa. Kwailtuza ilnakane, nane nil aizpa kimtus. Na pashimtu aizpa kimtuchish. Ap Papihsh nawa ɨnintɨt akwa, nane us pashimtu aizpa kishimtus. ");
INSERT INTO kwi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na uruza apminpain paratne, une na kaiztu aizpa watcha chi minñamtu. ");
INSERT INTO kwi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sunkana mamazne, ap Papihshne, nawa wat kainanazi. Us nawa kainammtu aizpa watcha i pianish. ");
INSERT INTO kwi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Une mazantuza ɨninnara, Juanta, munnammikara mɨmanapa. Us nawa sɨnkarɨt aizpa watcha azi. ");
INSERT INTO kwi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Apas awa chiwazha kuruntu aizpa pashiamtukas, nane sunpa pashitchi ish. Mɨshitchish. Nane uruza Juanpa, nawa watcha kainammmikawa, paranamtus, Dios uruza watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanne impil aiztukanain azi, u Dios wat miwara ɨanapa. Paiña pit kamtarɨt aizpa mɨarɨt akwa, une us akwa akkwan payuchin watsal kulara. ");
INSERT INTO kwi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mamazne, ap Papihshne, na akwa wat kainammtus. Paiña pitne Juanpa pitkin anza tɨnta i, ap Papihsh nawa iztasparɨt kal kinpa, kiwainta akwa. Na sun kal kimtu akwa, une Dios nawa ɨninta piankamashina. ");
INSERT INTO kwi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Papihshne, nawa ɨnintamikane, nawa wat kainammtu. Une mizurainkas us uruza kaizta aizpa mɨashitchi. Ukas mizurainkas ussa izarachi. ");
INSERT INTO kwi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Une paiña pit u kaijchura watsamtuchi, u an Papihsh ɨnintamikasha nɨjkulamtuchi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Une Dios pɨnkɨhta izamtu, an wat piankamna. Une Dios pɨnkɨh izturuzne pailta payukima uzanazi ñanta minñamtu. Dios pit nawa paramtukas, ");
INSERT INTO kwi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","une nawa aashimtuchi, nawa nɨjkulana, pailta payu uzana. ");
INSERT INTO kwi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Awa nawa wat paramtukas, nane u watsal pit nawa paramtu aizpa mɨshitchi ish. ");
INSERT INTO kwi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Anpa nane uruza pianish. Une Diosta pashiamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dios nawa ɨnintakas, une nawa sappamtuchi. Mamaz ukin akane, mamaz ussa ɨnintuchikas, une ussa sappashina. ");
INSERT INTO kwi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","U uruzpain wat kizamtu akwa, une wat kulamtu. Diosne mazain uz. U Diosta piankamtuchi akwa, Diosne, mazain uzmikane, uruza wat awa mai kizmanazi. Katmizna une nawa nɨjkulasachi. ");
INSERT INTO kwi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na uruza Papihshpa iztakin u kwail kiamtu kiznash minman. Sun kimanash. Une Moisésta tɨrizamtu, uruza kiwainnanapa. Sunkana usne mizurainkas uruza kiwainmanazi, us u kwail kiamtu aizpa kiznamtu akwa. Une Moisés kamtarɨt aizpa kiashimtu, pailta payukima uznana. Sunkana une chiyura uzamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","U Moisés kaizta aizpa mɨaratne, une nawakas nɨjkulashina, Moisés nawa pɨnkɨhta para akwa. ");
INSERT INTO kwi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","U paiña pɨnkɨh parɨt aizpa nɨjkulamtuchine, une mizurainkas na paramtu aizpa nɨjkulashitchi.” ");
INSERT INTO kwi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kwiztane Jesúsne Galilea Pi kwakara ɨrɨt. Sun pine Tiberiaskas mun. ");
INSERT INTO kwi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kwisha akkwan awane ussa kanpaara, iztasparɨt kal kirɨt aizpa izara akwa. Akkwan ishturuza kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Suasne Jesúsne ɨzara nut kit sua uzta paiña kammuruzkasa. ");
INSERT INTO kwi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pascua pishta, Judío awaruzpa pishta, kasha pamtu. ");
INSERT INTO kwi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Akkwan awa ussa kanpararuza iznarawane, Jesúsne Felipera kaiz kit mɨmara: —¿Mɨntama kumira paina ɨanapai, wan awa kuanapa? ");
INSERT INTO kwi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Usne kaizta, sun Felipe chi kizkwarakas mɨna. Jesúsmin us kishimtu aizpa wat pian. ");
INSERT INTO kwi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Suasne Capernaum pɨpulura ɨamtuasmin, Felipene ussa sɨnkara: —Mɨnpazha paas cien payu kal kitne, kumira paisachi, wanta pitchin nailnana. ");
INSERT INTO kwi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrésne sua tuazi. Uskasa mamaz kammumika azi. Usne Simón Pedrowa aimpihsh. Suasne usne kaizta: ");
INSERT INTO kwi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Akkine maza ampu pashpa panai. Usne cinco chara pippa pankas paas pishkaru iltakas mɨji. Sun nailtane, wan awa kuasachi. ");
INSERT INTO kwi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Suasne Jesúsne ussa kaizta: —Wan awaruza uztain kiznari. Suain akkwan pɨt sau pura. Cinco mil ampuruzpain sua uzara. Ashamparuzkas pashparuzkas uspakasa uzara. ");
INSERT INTO kwi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Suasne Jesúsne pan sap kit Diosta aishtaish kizta. Sun kiztawane, kammuruza kwinnara. Paiña kammuruzne wan uztuza nailnara. Kawarain pishkarukas nailnara, kwashimtu aizpa kuanapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wan tukkarakane, Jesúsne paiña kammuruza kaiznara: —Chiwazha pitti pak tizka chaktain, chinkas kamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cinco chara pippa sarɨt pantas tizat akwa, uspane pitti pitti sakkat kit doce tɨmta winñara. ");
INSERT INTO kwi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Suasne Jesús iztasparɨt kal kirɨt aizpa izarawane, awane kaizara: —Watcha. Usne Dios pit kainammmika i. Diosne ussa kin nam kit au sukin ɨninta. ");
INSERT INTO kwi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Suasne Jesúsne awa minñamtu aizpa nɨjkulta. Uspane ussa paiña mikwa namninashimtu. Usne mamasa kwash ɨzara usparuztas paimpa ɨrɨt, mazain tuan. ");
INSERT INTO kwi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Amta parɨka, Jesúspa kammuruzne aiz pira kihshat kit ");
INSERT INTO kwi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","maza kanuara waat kit aiz pi kwakkamɨzta, Capernaum pɨpulura piannana. Tɨlkwil parɨt me. Jesúsne mama uspa tukin kailtachi. ");
INSERT INTO kwi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Suasne tɨnta inkwa pamɨzta. Aiz pikas tɨnta kialmɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco o seis kilómetros ɨarawane, uspane Jesústa kasha amtu izara. Usne pi ɨsalpara chara. Uspane ishkuara, ira izpulta izara mintɨt akwa. Jesús kwinta kinarawane, uspane ussa piankamara. ");
INSERT INTO kwi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesúsne kaiznara: —Na ish. Ishkuman. ");
INSERT INTO kwi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Suasne uspane ussa kanuara wat sappara. Sun urain sun pilta ɨamtura pianaara. ");
INSERT INTO kwi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tɨlawara pãn puzmukin pimamin puraruzne kammuruz maza kanuawara ɨara pian. Suane maza kanua wa chi. Uspane Jesús uspakasa ɨtchira pian. ");
INSERT INTO kwi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sun urain mamaz kanuaruz Tiberias pɨpulu suras pianaara. Sun sukin Jesúsne Diosta aishtaish kiz kit pan nailnara, awa pan kuanapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesúskas paiña kammuruzkas purachira piankamtawane, awane sun kanuaruza waat kit Capernaum pɨpulura ussa saina ɨara. ");
INSERT INTO kwi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kwakara pianaakane, uspane Jesústa wanmalat kit mɨmaara: —Kamtam, ¿Miza ura apa pianarau? ");
INSERT INTO kwi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesúsne sɨnkanat kit kaiznara: —Watcha kaiznamtus. Une nawa sayamtu, u tuknakima kuat akwa. Nawa sayamtuchi, na iztasparɨt kal kirɨt aizpa piankamta akwa. ");
INSERT INTO kwi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chiwazha pailtɨmtu aizpa saikain. Chiwazha pailmuchi aizpa sairain, uruza pailta payu uzninanapa. Nawa chiyuras Ampura sairain, u we mɨj aizpa sappanapa, pailta payukima uzanapa. Ap Taitta Diosne nawa narɨt kit paiña kal kinpa kiwainta. ");
INSERT INTO kwi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Suasne ussa mɨmaara: —¿Aune chima kianapai, Dios pashimtu aizpa kin? ");
INSERT INTO kwi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesúsne sɨnkanat kit kaiznara: —Dios pashimtu aizpa kiarawa. Une nawa, Dios ɨnintamikasha, nɨjkularawa. ");
INSERT INTO kwi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Suasne sɨnkaara: —¿Chiwazha iztasparɨt kal izninchain, nua nɨjkulanapa? ¿Chi kalma au akwa kinash? ");
INSERT INTO kwi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Au an ñamin kwalne pul sukin maná kumira kuara. Sunkana Dios pɨnkɨhta parɨt: “Diosne usparuza chiyuras kumira kwinnara.” ¡Au iztakin sunkana iztasparɨt kal kiri! ");
INSERT INTO kwi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesúsne sɨnkanara: —Watcha kaiznamtus. Moisésne uruza chiyuras kumira kwinnarachi. Ap Taittain sun watcha chiyuras kumira uruza kwinnara. Sun pankana, nane awaruza chiyura uzninnashina. ");
INSERT INTO kwi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dios maná kumira kwinarakas, usne chiyuras kihshtamikasha ɨninta, awaruza uzninnanapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Suasne uspane paikuara: —Anpat. Aumɨza an kumira kwinchain, pailta payukima uznapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesúsne kaiznara: —Nane Diostas kumirakanain ish. Nane uruza pailta payu uzninnashinas. Nawa amtumikane mizurainkas we nɨjkulanazi, Diosta piankamtu akwa. Nawa nɨjkultumikane pailta payukima Diospa kamshina, Diosta an piankamshimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ñamin sunpa uruza kaiznara. Nawa izarakas, une nawa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wan ap Taitta nawa mɨlamturuzne nawa aamtu. Nane nawa attuza sapnanash, usparuza ap izmuruz namanapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nane chiyuras kihshtau. Na kishimtu aizpa kimtuchish. Ap Taitta nawa ɨninta akwa, nane us pashimtu aizpa kishimtus. ");
INSERT INTO kwi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ap Taitta nawa ɨninta aizpa kinash, us nawa mɨlattuza kamanpa. Nane minpa payura usparuza irɨttas kuhsninnanash. ");
INSERT INTO kwi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ap Taittane, nawa ɨnintamikane, sun kishimtu, wan awa Dios painkulta izat kit nɨjkulanapa, pailta payukima uzanapa. Suasne minpa payura usparuza irɨttas kuhsninnanash. ");
INSERT INTO kwi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Suasne Judío awa ɨninturuzne Jesúspa kwail kizamɨzta, “Nane chiyuras taizta kumira ish” kizta akwa. ");
INSERT INTO kwi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Usparuzpain kaizara: —An ampune Jesús i. Joséwa painkul i. Aune paiña papihshtakas akkuhshtakas pianmakpas. ¿Mizama ka kiztui, “Usne chiyuras kihshta?” ");
INSERT INTO kwi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Suasne Jesúsne sɨnkanat kit kaiznara: —Uruzpain nawa kain kwail kizman. ");
INSERT INTO kwi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ap Taittane, nawa ɨnintamika i. Dios awaruza nawa karamtukine, mɨnminkas nawa asachi. Nane nawa atmikasha minpa payura kuhsninnash. ");
INSERT INTO kwi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios kainammmikane pɨnkɨhta ka parɨt: “Diosne wanta kamtananazi.” Sunkana Taittara mɨamturuzkas us kamtara aizpa piankamturuzkas nawa aanazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mɨnminkas mizurainkas Taittara iztachi. Mazain, Diostas atmikain, Taittara izta. ");
INSERT INTO kwi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Watcha kaiznamtus. Nawa nɨjkulamtumikane pailta payukima uznazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nane kumirakanain ish, awaruza uzninana. ");
INSERT INTO kwi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","U ñancha kwal pul sukin maná kumira kuarakas, wanne iarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nane chiyuras kumirawa paranamtus. Mɨnpazha ussa saptane, mizurainkas imanazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nane an kumira chiyuras taizta aizpa ish. Nawa saptumikane pailta payukima uznazi. Na kumira kwintu aizpa ap ña i. Nane ap ña kwinnanash, wan awa uznanapa. ");
INSERT INTO kwi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Katmizna Judío awa ɨninturuzne Jesúspa tɨnta kwinta kiat kit usparuzpain kaizara: —An ampune ¿Mizama paiña ña kwinshina, au kuwiznapa? ");
INSERT INTO kwi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesúsne kaiznara: —Watcha kaiznamtus. Na u akwa irɨkane, ap aimpi puznazi. Nawa chiyuras ampura saptukine, une watcha uzamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nawa saptumikane pailta payukima uznazi, na us akwa irɨt akwa, ap aimpi us akwa puztɨt akwa. Nane minpa payura ussa kuhsninnash. ");
INSERT INTO kwi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ap ñane watcha kumirakanain i. Ap aimpikas watcha kwazikanain i. ");
INSERT INTO kwi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na u akwa irɨt akwa, nawa saptumikane nakasa wanmaktu. Nakas uskasa wanmalnash. ");
INSERT INTO kwi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ap Taittane, nawa ɨnintamikane, uztu. Nakas us akwa uztus. Sunkanain nawa sapturuzne na akwa uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nane chiyuras amtumikawa paramtus. Nane pankanain namtɨt ish. U ñancha kwal sun kumirakana kuarachi. Sun maná pan kuarakas, kwiztane iara. An chiyuras amtumikasha sapturuzne pailta payukima uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesúsne Capernaum pɨpulura Judío kamtam yalkin sun kamtanara. ");
INSERT INTO kwi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sun kamtam mɨarawane, akwan Jesústa kanpamtuzne ka kaizara: —An kamtam pit kwisha sam i sapna. ¿Mɨnma sun pit mɨshinai? ");
INSERT INTO kwi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesúsne paiña kanpamtuz kain kaizamtu aizpa piankam kit mɨmanara: —¿Ap kamtam mɨasachimakkiwas? ¿Nawa chɨhkashimtumakkiwas? ");
INSERT INTO kwi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nane chiyuras ampune an ñamin ap uzmukin uztau. U mamasa nawa chiyura numtu izarane, ¿Chima minñamtuas? ");
INSERT INTO kwi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospa Izpulmin awaruza uzninnamtu. Awain sun kisachi. Ap pit uruza kaiznamtu: “Diospa Izpulne awaruza uzninnashina.” ");
INSERT INTO kwi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mama mɨnpazha ukis nawa nɨjkulamtuchi. An ñamin Jesúsne nɨjkultuchiruzakas ussa chɨhkamtumikashakas piankam ");
INSERT INTO kwi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","kit kaizta: —Sun akwa nane uruza ka kaiznarau: “Ap Taitta mazara karamtuchine, mɨnminkas nakin asachi.” ");
INSERT INTO kwi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sun urain akkwan paiña kanpamtuzne Jesústa kwaiyat kit uskasa cɨhkaarazi. ");
INSERT INTO kwi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Suasne Jesúsne paiña doce kammuruza mɨmanara: —¿Ukas ɨshimuskiwas? ");
INSERT INTO kwi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedrone sɨnkara: —Anpat. ¿Mɨnama kanpana ɨpai? Up pitne aumɨza uznintu. ");
INSERT INTO kwi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aune nua nɨjkultamakpas me. Aune nua piankamtamakpas. Nune Cristo i. Nune Diospa sɨnammika i. ");
INSERT INTO kwi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesúsne sɨnkanara: —Nane u doceruza nanaraish. Mazane ukis nawa alizmika i. ");
INSERT INTO kwi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sun kizka, Jesúsne Judas Iscariotewa, Simónpa painkulpa, paranara. Judasne doce kammuruztas azi. Jesústa kanpamtukas, ussa chɨhkashina. ");
INSERT INTO kwi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sun kitpane, Jesúsne Galilea suwara chara. Judea sukin ɨshitchi, sua Judío awa ɨnintuz ussa piantashiamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judío awawa katsa pishta kasha pamɨzta. Sun pishtara Judío awane ainki ɨranchu saat kit sua uzara. ");
INSERT INTO kwi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Paiña aimpihshtuzne ussa kaizara: —Apain nukkulmun. Judea sura ɨtpa, nuwa kanpamtuz up kal kimtu aizpa izanapa. ");
INSERT INTO kwi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nu kimtu aizpa puinmun, akkwan awa nu kimtu aizpa piankamanapa. Nune kwisha watsal kal kimtu. Katmizna sun kitpa, wan awa up kal izanapa. ");
INSERT INTO kwi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Paiña aimpihshtuzne us watsat mɨlmumika i nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesúsne kaiznara: —Ma payu nane Jerusalén pɨpulura chamanash. Uruzne chiwazha urara ɨashinai. ");
INSERT INTO kwi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma uztuzne uruza aliz kulamanazi. Uspane nawa aliz kulamtu, na usparuza kwail kiamtu kiznamtu akwa. Katmizna uspane nawa pashiamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Une pishtara ɨrain. Nane ɨmtuchish, na ap wat ɨmtu payu taiztachi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Usparuza sun kiznarawane, Galilea sura nukkulta. ");
INSERT INTO kwi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Paiña aimpihshtuz ɨarawane, Jesúskas izpachin pishtara ɨzi. ");
INSERT INTO kwi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judío awa ɨninturuzne ussa pishtara sayat kit kaizara: —¿Sun ampune mɨntama tusa? ");
INSERT INTO kwi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Awa usparuzpain us akwa kwisha kwinta kiara. Mɨnpazha ka kizara: “An ampune wat amit.” Mamaztuzne ka kizara: “Usne watchi. Usne awaruza kain kinamtu.” ");
INSERT INTO kwi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sunkana mɨnminkas Jesúspa tɨnta pararachi, Judío awa ɨninturuzpa ishkuamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pishta kakwa pamtɨkane, Jesúsne katsa Dios yalkin nap kit awaruza kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judío awane iztaspaat kit kaizara: —An ampune ¿Mizamaka wan piani, pɨnkɨh kamtachine? ");
INSERT INTO kwi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesúsne sɨnkanara: —Ap kamtamne apchi. Nawa ɨnintamikane na kamtamtu aizpa nawa chɨhkara. ");
INSERT INTO kwi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios pashimtu aizpa kitmikane ap kamtampa piankamnazi. Dios nawa kamtamtu akwa, une Diospa piankamanazi. Na mintu aizpa kamtamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Usminpain paramtumikane sunkana kimtu, awa ussa wari paraanapa. Kal kimtumikane paiña kal kitpa, awa ussa ɨninmumikasha wari kizanapa. Sun ampune watcha i. Mizurainkas pɨrail kaiztuchi. ");
INSERT INTO kwi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisésne uruza ɨninnara, paiña ɨnintu aizpa kianapa. Une us kaiznara aizpa kiamtuchi. ¿Chitma une nawa piantashimuspas? ");
INSERT INTO kwi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Awane sɨnkaara: —Salizne nua pizta. ¿Mɨnma nua piantashimtui? ");
INSERT INTO kwi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesúsne sɨnkanat kit kaiznara: —Na maza iztasparɨt kal kwaizkultu payura kit akwa, une sunpa iztaspaarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sunkana Moisésne uruza ampu pashpawa aya tɨtnapa, circuncisión kitpa, ɨninnara. (Moisés sun ɨninnarachikas, u kwalne an ñamin sun kinanapa ɨninnara.) Katmizna une kwaizkulmu payurakas ampu pashpawa aya tɨttamtu. Ankas kal i. ");
INSERT INTO kwi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Une ampu pashpawa aya tɨttamtu, Moisés kaizta aizpa kianapa. Une kwaizkulmu payura sun kiamtu. Na maza ampura kwaizkulmu payura kakulnintune, une ¿chitma nakasa aliz kulamtu? ");
INSERT INTO kwi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","U awa kiamtu aizpa izamtuasmin, usparuza “kwail kiarɨt” kizman. U awa kiamtu aizpa izakane, une uspawa watcha kainarawa. ");
INSERT INTO kwi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Suasne mɨnpazha Jerusalén pɨpulura uztuzne usparuzpain mɨmamɨzta: —¿Awane an ampura piantana sayamtuki? ");
INSERT INTO kwi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mane usne wan iztakin paranamtu. Mɨnminkas chinkas kizamtuchi. ¿Judío ɨnintuzne an ampu Dios nɨrɨtmika i nɨjkulamtuki? ");
INSERT INTO kwi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aune an ampu mɨntas amtu pianmakpas. Dios narɨtmika akane, mɨnminkas mɨntas amtu piankamasachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dios katsa yalta kamtanamtuasmin, Jesúsne sun mɨt kit tɨnta kaiznara: —Une nawa piankamamtu. Une na mɨntas amti pian. Apminpain at chi ish. Usne, watchamika i, nawa ɨninta. Une ussa pianchi. ");
INSERT INTO kwi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nain ussa pianish, us nawa ɨninta akwa. Mane tas arau. ");
INSERT INTO kwi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Suasne awa ussa piz kit sɨpshiarakas, mɨnminkas ussa pizarachi. Mama ussa piztu payu taiztachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Akkwan awane us nɨrɨtmika i nɨjkulara. Mamaztuzne kaizara: “Dios nɨrɨtmika akane, usne, an ampukana, anza iztasparɨt kal kimanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo awa Jesúspa kaizamtu aizpa mɨarawane, uspakas pariya ɨnintuzkas Dios katsa yalkis policíaruza ɨninnara, Jesústa piz kit mɨl kit kajchira sɨpnapa. ");
INSERT INTO kwi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Suasne Jesúsne kaiznara: —Nane ukasa akwan payu chin tunash. Suasne nawa ɨnintamikawarain kailtɨnash. ");
INSERT INTO kwi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","U nawa sayamtukas, une nawa wanmalamanazi. Mɨnminkas na ɨmtura ɨasachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Suasne Judío awane usparuzpain ka mɨmamɨzta: —¿Anne mɨnpa ɨrɨnsa? Usne au iztakis ɨsachi. ¿Usne Griego suwara Judío awaruza kamtana ɨrɨnsa? ¿Diosta pianchiruza kamtana ɨrɨnsa? ");
INSERT INTO kwi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Us kaiztu aizpa piankamsachimakpas. Sunkana kaizta: “Nawa saiyanazi. Nawain wanmalamanazi. Une na ɨmtura ɨasachi.” ");
INSERT INTO kwi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Minpa pishta payune anza katsa i. Sun payura Jesúsne kuhs kit tɨnta kaiznara: —Mɨnpazha kwazi kiltane, nawa anka. Nawa nɨjkultumikane nawa atpa, kwanpa, uznapa. ");
INSERT INTO kwi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jesúsne sunpa kaiz kit kwaziwa kwinta kira, awa kwazi kiltu akwa. Awane kwazi kwanpa pashiamtu, au sukin uzna. Jesúsne ankas Dios pitpa kaiztu: Nawa nɨjkultumikane kwazi kumtu mikakana i. Usne uznazi. ");
INSERT INTO kwi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sun kizkane, Jesúsne paiña Sɨnam Izpulpa kwinta kira. Paiña Sɨnam Izpulne Jesústa nɨjkultuza sapnashinat kit uzninnanazi. Jesús mama irɨttas kuhstachi akwa, Diosne paiña Sɨnam Izpulta mama ɨnintachi, Jesústa an watsal namnapa. ");
INSERT INTO kwi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús kaizta aizpa mɨarawane, mɨnpazha awaruzpain kaizara: —An Dios kainammmikane i. ");
INSERT INTO kwi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mamaztuzne kaizara: —Anne Dios narɨtmika i. Mamaztuzne mamaz tuntu kizara: —Cristone Galilea suras amanazi. ");
INSERT INTO kwi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios pɨnkɨhta ka parɨt: “Cristone Davidpa ɨninmikawa kwaltas puznazi. Usne Belén pɨpulukin kawinazi.” ");
INSERT INTO kwi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Awane Jesús akwa paimpa ɨara. ");
INSERT INTO kwi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mazakanane ussa pizshiara, kajchira sɨpna. Mɨnminkas ussa pizarachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dios katsa yalkis policíane ɨninturuz purakin kaiyara. Pariyaruza ɨnintuzkas Fariseo policíaruzkas mɨmanara: —¿Chikishma Jesústa karaamanash? ");
INSERT INTO kwi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policíane sɨnkanara: —Mɨnminkas an ampukana paratchi. ");
INSERT INTO kwi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Suasne Fariseo awane mɨmanara: —¿Jesúsne uruza kain kinamtukish? ");
INSERT INTO kwi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Au Judío awaruza ɨninturuzne us Dios narɨtmika i nɨjkularachi. Fariseo awaruzkas us Dios narɨtmika i nɨjkularachi. ");
INSERT INTO kwi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","An awane Moisés ɨninta aizpa kanpamtuchiruzne wan karaanazi. Uspane Jesústa mɨat kit ussa kanpaamtu. ");
INSERT INTO kwi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemone, Jesústa amta izna ɨtmikane, Fariseo awaruztas azi. Usne kaiznara: ");
INSERT INTO kwi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Aumɨza ɨnintɨt aizpa pianmakpas. Aune mazara kwail kirɨt kizsachimakpas. An ñancha aune ussa mɨrawamakpas, paiña kwail kirɨt aizpa piankamna. ");
INSERT INTO kwi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Suasne sɨnkaara: —¿Nukas Jesúskana Galilea suras atkish? ¿Nu paiña kanpammika kish? Dios pɨnkɨhta iztane, une Dios kainammika Galilea suras amtuchira piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Suasne wan chiwal usparuzpa yalta kaiyarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Uspa ɨarawane, Jesúsne Olivos ɨzara ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tɨlawara kɨnkane, Jesúsne Dios katsa yalta kailta. Akkwan awane us tukin aara. Usne uz kit usparuza kamtanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Suasne Moisés ɨninta aizpa kamtamtuzkas Fariseo awaruzkas maza ashampara, mamazpa ampukasa pittɨt wanmaltɨtmikasha, Jesústa karaara. Uspane wan iztakin ussa kunninat ");
INSERT INTO kwi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kit Jesústa kaizara: —Kamtam. Aune an ashampara, mamazpa ampukasa pittɨtmikasha, wanmaltamakpas. ");
INSERT INTO kwi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés pɨnkɨhta parat kit aumɨza ɨninta, sun kwail ashampara ukkasa piantanapa. ¿Chima kiztus nune? kizara. ");
INSERT INTO kwi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Uspane sun mɨmaara, ussa kwail kizninna, ussa mikwa iztukin kwail kizninna. Suasne Jesúsne wain kit pul pilta chihtɨ tɨppukasa pamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ussa mɨmaamɨztuasmin, Jesúsne nil sat kit kaiznara: —¡Uruztas chinkas kwail kitchimikane ussa an ñanchain uk kirain! ");
INSERT INTO kwi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mamasa wain kit pul pilta pamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesús kaizta aizpa mɨarawane, uspane uspa kwail kiarɨt aizpa minñara. Ɨlaparuzne an ñancha maza mazain puzat kit ashamparas ɨamɨzta. Wan ɨarawane, Jesúsmin sun ashampakasain sua nukkulta. ");
INSERT INTO kwi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Suasne Jesúsne nil sat kit ussa mɨmara: —Ashampa, nua kwail kirɨt kizturuzne ¿mɨntama purai? ¿Mɨnminkas nua kwail kirɨt kiztuchiki? ");
INSERT INTO kwi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Usne ussa sɨnkara: —Anpat, mɨnminkas nawa kwail kirɨt kiztachi. Jesúsne kaizta: —Nane nu kwail kirɨt aizpa watkulnintus. Ɨt kit an kwail kimun. ");
INSERT INTO kwi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesúsne mamasa paranat kit Fariseo awaruza kaiznara: —Nane impilkanain ish, wan awaruz uspa kaijchukin minñamtu aizpa kai piankamanapa. Nawa kanpararuzne ap kammuruz namanazi. Tɨlta chaamtuchi akwa, nane usparuza uzninnanash. Sun kai impil izarawane, uspane Dioskasa wat uzanazi. ");
INSERT INTO kwi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sun mɨarawane, Fariseo awaruzne kaizara: —Nune up minpain paramtu. Nuin kaiztu aizpa kainsɨh i. ");
INSERT INTO kwi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesúsne sɨnkanara: —Nain paramtukas, na kaizta aizpa watcha i. Nane mɨntas at pianish. Mɨnta ɨmtukas pianish. Une na mɨntas amtukas mɨnta ɨmtukas pianchimai. ");
INSERT INTO kwi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","U na kimtu aizpa izamtukas, une awakanain minñat kit na kwail kimtu kizamtu. Nane mɨnainkas kwail kirɨt kiztuchish. ");
INSERT INTO kwi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mamazta kwail kirɨt kiztakas, na chiwazha kiztu aizpa watcha i. Nain mamazta kwail kirɨt kiznamtuchish. Nakas, ap Taitta nawa ɨninmikakas, awara kwail kiarɨt kiztuas. ");
INSERT INTO kwi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sun pit uruza ɨnintu aizpa sunkana parɨt: “Paas awane kawarain nɨjkulkane, uspa kaizta aiza watcha i.” ");
INSERT INTO kwi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mane nain na pian aizpa kaiztus. Mamazkas, ap Taittakas, nawa ɨnintamikakas, us pian aizpa kawarain kaiztus. ");
INSERT INTO kwi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Suasne uspane mɨmaara: —¿Mɨntama tui up Taitta? Jesúsne sɨnkanara: —Une nawakas ap Taittarakas pianchimai. Nawa piankamtaratne, une ap Taittarakas piankamashina. ");
INSERT INTO kwi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dios katsa yalkin pial sapmukin kamtanamtuasmin, Jesúsne sun kizta aizpa kaiznara. Mɨnminkas ussa pizshiarachi, paiña naiztu payu taiztachi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesúsne mamasa kaiznara: —Nane ɨru. Une nawa sayanazi. Kwail kiamtu akwa, une ianazi. Une na ɨmtura ɨasachi. ");
INSERT INTO kwi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Suasne Judío ɨninturuzne kaizara: —U na ɨmtura ɨasachi kaiztu akwa, ¿Ussain piantamtuki? ");
INSERT INTO kwi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Suasne Jesúsne kaiznara: —U an sukin pura akwa, une apas kal mɨj. Na kwashpas at akwa, nane chiyuras kal mɨj ish. Une an sukin uzamtu. Nane chiyuras atmika ish. ");
INSERT INTO kwi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Katmizna uruza ka kiznarau: “Kwail kiamtu akwa, une ianazi. U na watsat mɨltamika ish nɨjkulamtukine, une kwail kiat kit ianazi.” ");
INSERT INTO kwi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Suasne mɨmaara: —¿Nune mɨntas mas? Nune watsat mɨltamika chi. Jesúsne sɨnkanara: —An ñamin uruza nane mɨnmika i kaiznarau. ");
INSERT INTO kwi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nane uruza akkwan pit kaiznawaish. U kwail akwa, nane uruza kwail kiamtu kiznat kit naizninnanazi. Nawa ɨnintamikane watcha kaiztu. Nane us nawa kaizta aizpa uruza paranamtus. ");
INSERT INTO kwi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Uspane Papihshpa paraka mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Katmizna kaiznara: —Nawa chiyuras Ampura kurishta patpianka, une nawa piankamaanazi. Nane uruza mɨnma ish kiznarau. Apminpain kimtuchish, na ap Taitta nawa kamtara aizpa kamtanamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nawa ɨnintamikane nakasa tu. Ap Taittane nawa kwairachi, na us pashimtu aizpa kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús sun kizkane, kwisha akkwan awane ussa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Suasne Jesúsne Judío awa ussa nɨjkultaruza kaiznara: —U na kamtara aizpa nil kiamɨztane, une ap kammuruz namashina. ");
INSERT INTO kwi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Suasne une watcha piankamanazi. An watcha pitne uruza kwailtas puzninnanazi, Dios uruza watsat mɨlnamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Uspane ussa sɨnkaara: —Aune Abrahampa kwal makpas. Katmizna aune kwail aizpa kimtuchimakpas. Nune au kwail kiamtumakpas kizsachi. ");
INSERT INTO kwi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesúsne kaiznara: —Watcha kaiznamtus. Wan kwail kimtuzne sun kiamtu, kwail kiashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kal kiwainmumikane pailta payu anpatpa yalta kal kimtu. Mɨnminkas ussa chɨht ɨninsachi. Yalpamikakas, paiña kwalkas kal kiwaintuza chɨht ɨninnashina. ");
INSERT INTO kwi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Katmizna Dios Painkulne u kwail kiarɨt aizpa watkulninnashina, us Papihshkasa uztu akwa. Painkul uruza wat kulninnashimtune, usne u kwail kiarɨt aizpa wat kulninnashina, sunpa chɨhtnapa. ");
INSERT INTO kwi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nane u Abrahampa kwal mai pianish. Na kamtara aizpa mɨarachi akwa, une nawa piantaashimtu. ");
INSERT INTO kwi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nane ap Taitta nawa kamtara aizpa paranamtus. Une u Satanás taitta parat aizpa kiamɨztu. ");
INSERT INTO kwi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Uspane sɨnkaara: —Au taittane Abraham i. Jesúsne kaiznara: —U Abrahampa painkultuz watcha aratne, une Abrahamkanain Diosta kanpaashina. ");
INSERT INTO kwi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Diosne nawa watcha kamtara. Na sun watcha uruza kiznarakas, une nawa piantaashimtu. Abrahamne mizurainkas sunkanain kitchi. ");
INSERT INTO kwi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Une u taitta kirɨtkanain kiamtu. U taittane Dios chi. U taittane Abraham chi. Suasne uspane kaizara: —Aune mamaz papihshtas pashpa kawirachimakpas. Au Taitta pianmakpas. Usne Dios i. ");
INSERT INTO kwi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesúsne kaiznara: —Dios u Taitta watcha aratne, une nawa paashina. Na Diostas at akwa, akki tus. Apminpain atchish. Sunkana Diosne nawa ɨninta. ");
INSERT INTO kwi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na kaizta aizpa piankamamtuchi akwa, une ap pit mɨasachi. ");
INSERT INTO kwi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","U taittane Diablo i. Une ustas puzat kit us pashimtu aizpa kiashimtu. Diablone pailta payukima awaruz ianapa pashira. Usne watcha kishitchi, watcha kaiztuchi akwa. Pɨrail kaizkane, usne paiña kaijchuras paramtu. Usne pɨrailmika i. Usne awaruza pɨrail kaizanapa kininamtu. ");
INSERT INTO kwi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Katmizna na watcha kaiznamtukas, une na kaizta aizpa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Une na kwail kirɨt aizpa aansachi. Na watcha kaiznakane, ¿Chikishma na kaizta aizpa nɨjkulamtuchi? ");
INSERT INTO kwi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diosta piantuzne Dios pit mɨamtu. U Diosta pianchi akwa, une us kaizta aizpa mɨamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Suasne Judío awane ussa kwail kizara: —Au kaizta aizpa watcha i. Nune Judío awa chi. Nune Samaria pɨpuluras awakana i. Salizne nua piztɨt. ");
INSERT INTO kwi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsne sɨnkanara: —Saliz nawa piztachi. Nane ap Taittara kwisha wari kiztus. Sunkana une nawa kwail i kizamtu. ");
INSERT INTO kwi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nane awaruza saimtuchi, nawa wari kiznapa. Diosne nawa wari kiznazi. Usne wan iz kit na akwa nil kiznazi. ");
INSERT INTO kwi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Watcha kaiznamtus. Na kamtara aizpa kimturuzne mizurainkas iamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sun mɨarawane, Judío awane sɨnkaara: —Mane aune saliz nua pizta pianmakpas. Abrahamkas wan Dios pit kaiznamtuzkas iarɨt. Nune ka kiztui: “Na kamtara aizpa kimturuzne mizurainkas iamanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Au Taitta Abrahamne irɨt. ¿Nune au Taitta Abrahamkin an katsa kish? Dios kainammtuzkas iarɨt. ¿Nune mɨntasmas? Nu kwail mintui, nu katsamika chi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesúsne sɨnkanara: —Nain watcha ish kaiztane, na kaizta aizpa kainsɨh. Ap Taittane nawa wari kiztu. Ukas us au Dios i kizamtu. ");
INSERT INTO kwi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sunkana une mizurainkas ussa pianchi. Nain ussa pianish. Na pianchish kiztane, nakas ukanain pɨrail kizshina. Nain ussa watcha pianish, us kaiztu aizpa kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","U taitta Abrahamne watsal kira, na amtu payuwa piankamtɨt akwa. Usne sun iz kit watsal kira. ");
INSERT INTO kwi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Suasne Judío awaruzne Jesústa kaizara: —Nune cincuenta años mɨjchi mama. ¿Nune Abrahamta iztakish? ");
INSERT INTO kwi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesúsne sɨnkanara: —Watcha kaiznamtus. Abraham kawirachasmin, nane uzarau. ");
INSERT INTO kwi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Suasne uspane uk chakkara, Jesústa kin. Jesúsne ussa kulat kit Dios katsa yaltas puz kit uspa paizkakis ɨt. ");
INSERT INTO kwi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mamaz payura miwara ɨmtuasmin, Jesúsne maza ampu izsachi kawirɨtmikasha izta. ");
INSERT INTO kwi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Paiña kammuruzne mɨnpazha kwail kirɨt minñat kit mɨmaara: —Kamtam. ¿Chikishma an ampu izsachi? ¿Papihshkas akkuhshkas kwail kirɨtwailki? ¿Usmin kwail kirɨtki? ");
INSERT INTO kwi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesúsne sɨnkanara: —Us izsachikas, paiña kwail kirɨt akwa, kasu tɨlkwil kirɨtchi. Papishtuzkas kwail kiarachi. Usne izsachi kawira, awa Dios kal kimtu aizpa izanapa. ");
INSERT INTO kwi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","An payu asmin aune kal kipuspas. Tɨl pakane, aune kal kisachimakpas. Sunkana pailta payukima nane ap Taittawa kal kitpaish, us paiña kal kinpa, nawa ɨnintɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","An sukin tuasmin, nane impilkanain ish, apas awa uspa kaijchukin minñamtu aizpa kai piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sun kiztawane, Jesúsne pilta ilpi ɨtkulat kit ilpikasa pitchin pilkasa sain kit kasu ɨsalparain izsachimikasha nɨra. ");
INSERT INTO kwi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kwiztane ussa kaizta: —Mane ɨt kit Siloé kwazi piwailta kittas. (Awa pitne Siloé “ɨninta” mun.) Suasne an ampune ɨt kit matsɨhta kit kit paiña yalta iztu kailta. ");
INSERT INTO kwi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Suasne makin uztuzkas ñamin kasu izsachi pial paikwatmikasha iztaruzkas kaizara: —¿An ampune pial paikwan uzatmikaki? ");
INSERT INTO kwi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mɨnpazha kaizara: —Watcha. Us i. Mamaztuzne kaizara: —Us chi. Uskanain iztɨt i. An ampune kaizta: —Watcha. Nane an pial paikumtuatmika ish. ");
INSERT INTO kwi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Suasne ussa mɨmaara: —¿Mizama mane izshinas? ");
INSERT INTO kwi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Usne sɨnkanara: —Maza ampune, Jesús munmikane, pil sat kit ɨsalpara kasura pil nɨt kit kaizta: “Siloé kwazi piwailta ɨt kit kittash.” Ɨrau. Na kitpane, izshinarau. ");
INSERT INTO kwi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Suasne ussa mɨmaara: —¿Sun ampune mɨntama tui? Usne kaiznara: —Pianchish. ");
INSERT INTO kwi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Suasne uspane izsachimikasha, wat parɨtmikasha, Fariseo awa purakin mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesúsne kwaizkulmu payura ilpikasa pil sat kit izsachimikasha wat paninta. ");
INSERT INTO kwi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Suasne Fariseo awane mamasa an ampura ¿Mizama mane kasu izshinai? mɨmaara. Usne kaiznara: —Usne pil kasu ɨsalpara nɨish. Nane kasu kittau. Mane iztus. ");
INSERT INTO kwi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Suasne mɨnpazha Fariseo awaruztas kaizara: —Sun kirɨtmikane Diostas asachi. Usne kwaizkulmu payu nɨjchiwal kimtu. Mamaztuzne kaizara: —Kwail kirɨtmika kane, ¿Mizama akwan wat kal kishinai? Sun kizara aizpa akwa, uspane usparuzpain paimpa naiyara. ");
INSERT INTO kwi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mamasa kasu izsachimikasha mɨmaara: —¿Nune chi kiztu kasu izkulnintamikawa? Usne kaiznara: —Usne Dios pit kainammmika i. ");
INSERT INTO kwi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judío awa ɨninturuzne sun ampu kasu izsachira nɨjkulshiarachi, paiña kasu iztu akwa. Suasne uspane kasu izsachimika wat parɨtpa papihshtakas akkuhshtakas akuat kit ");
INSERT INTO kwi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","mɨmaara: —¿Anne u painkulki? ¿Us kasu izsachi kawirɨt kizamtuki? ¿Mizama mane iztui? ");
INSERT INTO kwi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Papihshkas akkuhshkas sɨnkanara: —Aune au painkul i pianwas. Usne kasu izsachi kawirɨt. ");
INSERT INTO kwi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mane miza iztu pianchiwas. Mɨnma ussa kasu izkulninta pianchiwas. Ussa mɨmarain. Ɨlapa wai. Usmin uruza kainashina. ");
INSERT INTO kwi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Papihshkas akkuhshkas sun kizpailta, Judío ɨninturuza ishkwantu akwa. Uspane usparuzpain nɨjkulara, Jesús Dios narɨtmika i kizmuruza Dios kammu yalkis ukkat kit puzninnana. ");
INSERT INTO kwi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Katmizna paiña papihshkas akkuhshkas sun kizpailta: “Ussa mɨmarain. Ɨlapa wai.” ");
INSERT INTO kwi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Suasne Judío awane mamasa an ñamin kasu izsachimikasha akwaat kit kaizara: —Dios iztakin watcha kaizti. Aune an ampu kwail kimmika i pianmakpas. ");
INSERT INTO kwi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Usne sɨnkanara: —Us kwail kirɨtne, pianchiish. Nain sun pianish. Nane kasu izsachiarau. Mane iztus. ");
INSERT INTO kwi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mamasa mɨmaara: —¿Nua chima kizi? ¿Mizama kizi, up kasu izkulninna? ");
INSERT INTO kwi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Sɨnkanara: —Uruza kaiznarau me. Une mɨamtuchi. ¿Chishma sunmin mamasa mɨashimtuwas? ¿Ukas ussa kanpashiamuskiwas? ");
INSERT INTO kwi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Suasne ussa kwail kizat kit kaizara: —Nune sun ampura kanpam kit us kaiztu aizpa mɨmtu. Aune Moisésta kanpam kit us kaiztu aizpa mɨmtumakpas. ");
INSERT INTO kwi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aune Dios Moisésta parara aizpa pianmakpas. Anne mɨntas at pianchimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Usne sɨnkanara: —U sun kaizamtu akwa, nane iztasparu. ¿Une sun ampu mɨntas amtu pianchimakkiwas? Usne nawa kasu izkulninta. ");
INSERT INTO kwi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Watcha i. Diosne kwail kimtuza mɨmtuchi. Usne Diosta wakpuj waintuzainkas Dios ɨninta aizpa kimturuzainkas mɨnamtu. ");
INSERT INTO kwi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Au su sarasmin, mɨnminkas sunpa mɨarachi. Mizurainkas mɨnminkas kasu izsachi kawirɨtmikasha izkulnintachi. ");
INSERT INTO kwi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sun ampu Diostas atchine, chinkas kisachi. ");
INSERT INTO kwi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Uspane sɨnkaara: —Kawirasmin, nune kwail kira. ¿Nune aumɨza kamtashimtukish? Uspane ussa Dios kammu yaltas ukkat kit puzninara. ");
INSERT INTO kwi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Awa kasu izsachimikasha kammu yalkis ukkat kit ɨninara. Jesús sunpa piankamtawane, usne ussa sait kit wanmal kit mɨmara: —¿Nune chiyuras Ampura nɨjkultukish? ");
INSERT INTO kwi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ampune sɨnkat kit kaizta: —Anpat. ¿Mɨnmas? Mɨnma i kaizcha, na ussa nɨjkulnapa. ");
INSERT INTO kwi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsne ussa kaizta: —Nune ussa iztɨt me. Nain ish. Nane nukasa paramtus. ");
INSERT INTO kwi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Suasne ampu Jesústa wakpuj waintuasmin, kaizta: —Anpat. Nane nu Dios narɨtmika i nɨjkultus. ");
INSERT INTO kwi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Suasne Jesúsne kaizmɨzta: —Nane an sukin arau, awa uspa kwail piankamanapa, Dios usparuza watsat mɨlnanapa, kwail kiamanpa. “Diosta pianmakpas” minturuzne Diospa watsat mɨlmumikasha kwayanazi. ");
INSERT INTO kwi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Suasne sun mɨarawane, mɨnpazha Fariseo awaruztas us panatkin ussa mɨmaara: —Aune watcha Diosta pianmakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesúsne sɨnkanara: —U Diosta pianchine, u kwail kiarɨt aizpa pianchi. U Diosta pianmakpas kizamtukas, une kwail kiarɨt aizpa nukkultu. ");
INSERT INTO kwi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Suasne Jesúsne awaruza kamtanamɨzta. “Watcha kaiznamtus. Pɨrikuwa pɨjtakin napmuchimikane, walkumkanakas mamaztuza kwail kishimmikakanakas mai, mamazpara naptu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pɨjtakin napmumikane pɨriku izmumika i. Usne pɨrikura kiwainamtu. ");
INSERT INTO kwi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pɨjta iztumikane pɨjta chɨhtu, pɨriku izmumika napnapa. Pɨrikune us parɨka piankam kit mɨamtu. Usne pɨrikuwa mun akwanat kit pɨriku wakis ukkanamtu. ");
INSERT INTO kwi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paiña pɨrikuruza puzninarawane, usne uspa purakin an ñancha ɨmtu, mi anna. Pɨrikune ussa kanpaamtu, paiña pit piankamamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Uspane pianchiruza kanpaamtuchi. Katmizna uspane suntuztas ɨamtu, mamazpa pit pianchi akwa.” ");
INSERT INTO kwi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús sun kamtam kwinta kinarakas, uspane us kamtanara aizpa mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Suasne Jesúsne mamasa kaiznara: “Watcha kaiznamtus. Nane pɨjtakana ish, pɨriku nappanapa. ");
INSERT INTO kwi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na iztakin attuzne walkumtuzkas awaruza kwail kiashimturuzkas mai. Pɨrikuruzne uspa pit mɨashitchi. ");
INSERT INTO kwi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nane pɨrikuwa pɨjtakana ish. Nawa saptumikane, nawa nɨjkultumikane, sun pɨjtakinkana napshina. Nane ussa sɨnam sanash. Usne pɨrikukanain nap kit puz kit chiwazha we aizpa mɨjanazi. ");
INSERT INTO kwi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Walkummikane amtu, walkwan, piantana, wan azpianna. Nain arau, uruza uzninnanapa, chinkas wenamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nane wat pɨriku izmumika ish. Wat pɨriku izmumikane pɨriku akwa ishina, usparuza watsat mɨlnana. ");
INSERT INTO kwi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Diablo kwiza akane, kana kimtu mikane, pial sapmumikane, pɨrikura chɨhkanat kit ãĩn ɨmtu, us pɨriku izmumika chi akwa, pɨriku paiña chi akwa. Suasne Diablo kwizane pɨrikuruza piznat kit paimpa paimpa ɨninnamtu. ");
INSERT INTO kwi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pialmin pashit akwa, an ampune pɨrikuras ãĩn ɨmtu. Usne pɨrikuruza wat izshimtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nane wat pɨriku izmumikakana ish. Pɨrikuruzne nawa nɨjkulamturuz mai. Ap Taittane nawa pian. Kawarain Taittara pianish. Sunkanain pɨrikuruza, nawa nɨjkulturuza pianish. Kawarain uspane nawa pian. Nakas uspa akwa ishinas, usparuza sɨnam sanana. ");
INSERT INTO kwi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mamaztuzne, sun Judío chi awaruzne, nawa nɨjkulamtuchi. Nane usparuzakas karatpaish, na kaizta aizpa mɨanapa. Nane wan nawa nɨjkultuza maza kwain wanmakninnanash. Suasne nane, pɨriku izmumikane, usparuza iznanazi, nawa nɨjkularɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na mamaztuz akwa imtu akwa, ap Taittane nawa pashimtu. Usne nawa mamasa uznninnazi. ");
INSERT INTO kwi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mɨnminkas nawa inintuchi. Nane nain chɨhkashimtus, inna. Nakas nawain kuhsshinas, mamasa uzna. Ap Taittane nawa ɨninta, sun kinpa.” ");
INSERT INTO kwi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judío awa ɨninturuz us kaizta aizpa mɨarawane, uspane usparuzpain paimpa ɨara. ");
INSERT INTO kwi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Akkwanne kaizara: “Salizne ussa pizta. Nukku paramtu. ¿Chitma us kaiztu aizpa mɨamtu?” ");
INSERT INTO kwi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mamaztuzne kaizara: “Mɨnminkas, sun kwail saliz piztɨtmikane, sunkana parasachi.” Saliz piztɨtmikane izsachimikasha izkulninsachi. ");
INSERT INTO kwi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Alu kimtu akwa, Jerusalén pɨpulura tɨh pamtu. Judío awaruzne Dios katsa yalpa pishta iznara. ");
INSERT INTO kwi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesúsne Dios katsa yalkin Salomónpa pɨjtawara chamtazi. ");
INSERT INTO kwi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judío awa ɨninturuz ussa pɨlzarawane, uspane mɨmaara: —¿Yawa payukima tɨrizish, aumɨza nil kainarachin? Nu watsat mɨlmumika kane, nil kainachain. ");
INSERT INTO kwi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesúsne sɨnkanara: —Me ñamin uruza kainarɨt. Une na kaizta aizpa nɨjkularachi. Ap Taitta nawa ɨninta akwa, nane us nawa kaizta aizpa kimtus. Na kirɨt aizpa izamtune, une nawa piankamashina. ");
INSERT INTO kwi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","U ap pɨrikukana chi akwa, une nawa nɨjkulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ap pɨrikuruzne, nawa nɨjkulturuzne, ap pit mɨat kit nawa kanpaamtu. Nane usparuza pianish. ");
INSERT INTO kwi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nane pailta payukima usparuza uzninnamtus, mizurainkas kaamanpa. Mɨnminkas usparuza nakis nakamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ap Taittane, nawa suntuza chɨhkarɨtmikane, mamazkinkas anza katsa i. Mɨnminkas usparuza ap Taittaras nakasachi. ");
INSERT INTO kwi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ap Taittakas nakas sulmin was. ");
INSERT INTO kwi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Suasne mamasa Judío awa ɨninturuzne uk chak kit Jesústa kishiamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesúsne kaiznara: —Ap Taitta nawa sun kal kin ɨninta akwa, nane u iztukin kwisha wat kal kirau. Na kal kit akwa, ¿une nawa uk kiashimtukiwas? ");
INSERT INTO kwi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judío awa ɨninturuzne sɨnkaara: —Nu wat kal kirɨt akwa, aune nua uk kiamtuchimakpas. Nu Diospa kwail kiztu akwa, sun kishiamtumakpas. Nune ampuin i. Nune Dios ish kiztu. ");
INSERT INTO kwi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Suasne Jesúsne kaiznara: —Diosne paiña ɨnim uruza ɨninnara. Ka parɨt: “Une dios mai.” ");
INSERT INTO kwi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aune Dios paninta aizpa watcha i pianmakpas. Paiña pit maiztuchi. Diosne paiña pit kainammtuza ɨninnat kit usparuza “dios” munnara. ");
INSERT INTO kwi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Diosne nawa paimpa nat kit an sura ɨninta. Na Dios painkul ish kizkane, une na Diospa kwail kiztu kaizasachi. ");
INSERT INTO kwi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ap Taittawa kal kirɨt aizpa kimakane, nawa nɨjkulman. ");
INSERT INTO kwi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Us kal kikane, nawa nɨjkulamtuchikas, na kimtu akwa nɨjkularain, ap Taittakas nakas maza awakanain uzwas piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Suasne mamasa uspane Jesústa pizshiara, kajchira sɨpna. Sunkana usne usparuztas kimasara. ");
INSERT INTO kwi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Suasne Jesúsne mamasa pãn puzmumal Jordán Pira kail kit Juan an ñamin munnarakin nukkulta. ");
INSERT INTO kwi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Akkwan awane ussa izna ɨat kit kaizara: “Juan chinkas iztasparɨt kal kitchikas, usne wan Jesúspa kwinta kira. Us kaizta aizpa watcha azi.” ");
INSERT INTO kwi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kwisha akkwan awane sun sura ussa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mane nane an ñamin ishtumikawa kwinta kinamtus. Usne Lázaro mun. Uskas paiña paas kwampihshkas Betania pɨpulura uzara. Sun paasne Maríakas Martakas munwail. ");
INSERT INTO kwi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","An Maríane, Lázaro imtumikawa kwampihshne, watsal piam pihshpi Anpatpa mittɨkin pattain kit paiña ashkasa pul chakninta. ");
INSERT INTO kwi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázarowa kwampihshne paiña pit ɨnin kit Jesústa ka kaizpailta: —Anpat. Up wat izmuruz imtu tui. ");
INSERT INTO kwi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sun mɨrawane, Jesúsne kaizta: —Imtukas, Lázarone irɨt nukkulmanazi. Sunkana Lázaro akwa, awane Dios kwisha wari kizanazi. Sun irɨt akwa, awane Diospa painkul kwisha wari kizanazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús Martarakas paiña aizpihshtakas Lázarorakas pashinarakas, ");
INSERT INTO kwi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ussa Lázaro ishtu i kiztakas, Jesúsne us tukin an paas payu mara. ");
INSERT INTO kwi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sun kitpane, usne kammuruza kaiznara: —Mamasa Judea sura ɨzhain. ");
INSERT INTO kwi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Uspane sɨnkaara: —Kamtam. Akkwan payu chin Judío awa ɨninturuzne nua uk kishiara. Nune imasara. ¿Mamasa ta ɨshimtukish? ");
INSERT INTO kwi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús kaiznara: —Pãn doce urakima kai maltu akwa, mɨnpazha au sukin chamtumikane, Taitta pashit aizpa kishiarawa. Na Dios pashit aizpa kimtuasmin, mɨnminkas nawa kwail kisachi. ");
INSERT INTO kwi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sunkana Diosta nɨjkultuchimikane, amtawara chamtumikakana i. Diosta pianchimikane, Dios uztukin pianasachi, Dios kamtamtu aizpa kanpamtuchi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sun kiztawane, Jesúsne an kaiznara: —Au izmumika Lázarone pirɨt tui. Sunkana nane ussa izkulninnash. ");
INSERT INTO kwi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Suasne paiña kammuruzne kaizara: —Anpat. Pittane, usne suas kakultanazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús Lázaro irɨtpa paranamtuasmin, kammuruzne Lázaro pittɨttu minñara. ");
INSERT INTO kwi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Suasne Jesúsne usparuza nil kaiznara: —Lázarone me irɨt. ");
INSERT INTO kwi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na uskasa tuchikas, nane u akwa watsal kultus, u nawa nɨjkulamɨznapa. Ta ussa izna ɨzhain. ");
INSERT INTO kwi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Suasne Tomásne, gemelo muntɨtmikane, mamaz kammuruza kaiznara: —Aukas ɨzhain, an kamtamkasa ina. ");
INSERT INTO kwi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Piannakane, Jesúsne Lázarora ampara payu uk kulta kamtɨt piankamta. ");
INSERT INTO kwi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pɨpulune Jerusalén pɨpulurakima kashawazhain uz. Kutña kilómetrokin uz. ");
INSERT INTO kwi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Akkwan Judea suras awane Maríarakas Martarakas uzkɨnpainna ɨara, kiwainanapa, uspa tayalamanpa, nalpihsh irɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús amtu piankamarawane, Martane ussa wanmalna ɨt. Sunkana Maríane yaltain nukkulta. ");
INSERT INTO kwi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martane Jesústa kaizta: —Anpat. Nu akki tuaratne, ap nalpihsh irakianai. ");
INSERT INTO kwi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sunkana nane nu chiwazha Diosta paikumtu aizpa Dios nua mɨlanazi pianish. ");
INSERT INTO kwi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesúsne kaizta: —Up nalpihshne mamasa uznazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martane kaizta: —Nane nu kaizta aizpa watcha i pianish. Usne mamasa minpa payura irɨttas kuhsnazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Suasne Jesúsne ussa kaizta: —Nane irɨttas kuhsnintumika ish, awaruza uzninnanapa. Irakas, nawa nɨjkultamikane mamasa uznazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wan ka uztuzkas nawa nɨjkultuzkas mizurainkas sunkanain iamanazi. ¿Sun nɨjkultukish? ");
INSERT INTO kwi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ussa kaizta: —Watcha, Anpat. Nune Dios narɨtmika i. Nune Dios painkul, au sura atmika i. Sun nɨjkultus. ");
INSERT INTO kwi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sun kiztawane, Martane aizpihshta, Maríara, akwana ɨt kit puintain kaizta: —Kamtammikane kashain tu. Usne nawa ɨninta, nua akwanpa. ");
INSERT INTO kwi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sun mɨrawane, sun urain Maríane kuhsak kit Jesústa izna ɨmɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesúsne pɨpulura naptachi mama. Usne Marta uskasa wanmaltakin tuara. ");
INSERT INTO kwi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judío awane uskasa yalta purat kit uzkɨnnaara, us tayalmanpa. María kuhsak kit azain puzta izarawane, uspane ussa kanpaara. Us kamkin azna ɨmtuka minñara. ");
INSERT INTO kwi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesús tukin pianarawane, Maríane paiña mittɨkin wakpuj wain kit kaizta: —Anpat. Akki tuaratne, ap nalpihshne irakianai. ");
INSERT INTO kwi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maríakas Judío awa uskasa amturuzkas azara. Sun iznarawane, Jesúsne ayukta kwail maz kit tayal kit ");
INSERT INTO kwi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","mɨmanara: ¿Mɨntama ussa kamanas? Sɨnkaara: —Anpat. Us tukin izna ɨzhain. ");
INSERT INTO kwi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesúsne azta. ");
INSERT INTO kwi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judío awane usparuzpain kaizara: —Usne ussa watcha pashira. ");
INSERT INTO kwi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sunkana mɨnpazha kaizara: —Usne kasu izsachimikasha izkulninta. ¿Usne chiwazha kishinaka, Lázaro imanpa? ");
INSERT INTO kwi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesúsne mamasa ayukta kwail maz kit tayal kit kamkin ara. An kamkin kul azi. Napmukin sɨptɨt tu katsa ukkasa. ");
INSERT INTO kwi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesúsne ka ɨninta: —Uk tainkarain. Martane, irɨtmikawa kwampihshne, kaizta: —Anpat. Kwail piamka. Ampara payu i me kamtɨt. ");
INSERT INTO kwi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesúsne sɨnkara: —Nane nua ka kaiztau: “Nawa nɨjkultune, nune Dios kal kimtu aizpa piankamanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Suasne uspane uk tainkaara. Jesúsne chiyura izak kit tɨnta kaizta: —Ap Taitta. Aishtaish kiztus, pailta payukima nawa mɨmtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nane nu nawa pailta payukima mɨmtu pianish. Mane nane uspa puraruz akwa sun kiztus, nu nawa ɨninta nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sun kiztawane, Jesúsne tɨnta kwianta: —Lázaro, suas puzti. ");
INSERT INTO kwi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Irɨtmikane chihtɨkas mittɨkas iptɨt tu puzta. Matsɨhkas maza pĩnkasa iptɨt. Jesúsne kaiznara: —Iptɨt pĩn chɨhttain, ɨnpa. ");
INSERT INTO kwi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Suasne sun izarawane, akkwan Judío awaruzne Jesústa nɨjkulara. Uspane Maríara kanpanat kit Jesús kit aizpa izara. ");
INSERT INTO kwi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sunkana mɨnpazha usparuztas Fariseo awaruza ɨat kit Jesús kirɨt aizpa kainaara. ");
INSERT INTO kwi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Suasne Fariseo awaruzkas pariya ɨnintuzkas anza katsa Judío ɨnintuzkasa wanmakkat kit kaizara: —¿Aune chima kianapas? An ampune akkwan iztasparɨt kal kimtui. ");
INSERT INTO kwi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sunkana us paiña kal kimɨztune, au ussa chɨhkatne, wanne ussa nɨjkulanazi. Suas Romano awa mikwaruzne aanazi, Dios katsa yalta azpianna, au Judío awa kwalkasa waya kiana, wan chiwal piantanakima. ");
INSERT INTO kwi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sunkana mazane usparuztas, Caifás muntɨtmikane, sun año pariya ɨninmika azi. Usne kaiznara: —Une sun kimtu aizpa pianchimai. ");
INSERT INTO kwi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Une sun piankamtain. Maza ampu au wan Judío awa akwa irane, anza wari. Suasne Romano awaruzne au Judío awaruza piantaamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sunkana Caifásne sun pit paiña minpain kaiztachi. Caifásne sun año katsa pariya azi. Diosne ussa an ñamin sun kimtu aizpa piankamnin kit kizninta: “Jesúsne Judío awaruz akwa inazi.” ");
INSERT INTO kwi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sun Judío awa akwa imtukas, usne mamaz sura uztukas inazi, Dios usparuza maza kwalkanain, Dios painkulkanain wanmakkanapa. ");
INSERT INTO kwi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sun payurain Judío ɨninturuzne Jesústa piantana nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Katmizna Jesúsne Judío awa ɨninturuz purakin izpanarachi. Usne Judea sukis puz kit Efraín pɨpulura ɨt. Sun pɨpulu pul su kashakin uz. Sua nukkulta paiña kammuruzkasa. ");
INSERT INTO kwi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judío awaruzpa Pascua pishta taiznapain. Pascua pishta taiztachasmin, akkwan awane nanmals Jerusalén pɨpulura nuara, Dios iztakin sɨnam saninnanapa, Pascua pishta izanapa. ");
INSERT INTO kwi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Uspane Jesústa sayara. Dios katsa yalta wanmakkamtuasmin, uspane usparuzpain ka mɨmaara: —¿Chima minñamtu? ¿Usne pishtara ansa? ");
INSERT INTO kwi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pariya ɨnintuzkas Fariseo awaruzkas wanta ka ɨninnara: —Mɨnpazha Jesús tura pianne, aumɨza kainanazhain, ussa piz kit kajchira sɨpna. ");
INSERT INTO kwi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis payu Pascua pishta chasmin, Jesúsne Betania pɨpulura, Lázaro uzatta, ɨra. Sua Jesúsne an ñamin ussa irɨttas kuhsnintɨt. ");
INSERT INTO kwi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Suane Jesúspa izmuruzne us akwa kumira saara. Lázaro uskasa misharɨ uz kit kuamtuasmin, Martane kumira nailnara. ");
INSERT INTO kwi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Suasne Maríane maza kakwa botella piam pihshpi karara. Sun pihshpine nardo muntɨt. Kwisha muin azi. Jesúspa mittɨkin pihshpi parantawane, usne paiña ashkasa pulchaktara. Yalnuras piam piara. ");
INSERT INTO kwi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariotene, Simónpa painkulne, Jesústa kammumikane, tuazi. Usne Jesústa chɨhkanmika azi. Usne kaizta: ");
INSERT INTO kwi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—An muin pihshpi painane, mɨnpazhane maza añokima kal kitpa. ¿Chitma sun piam pihshpi painintachi, pialkasa puizaruza mɨlanana? ");
INSERT INTO kwi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Puizaruza kiwainshimtuchikas, usne sun kaizta, us walkwashimtu akwa. Usne Jesústa kammuruzpa pial tuh mɨlta. Pial tuhta watsarakas, usne tas ukkara, us akwa painna. ");
INSERT INTO kwi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Suasne Jesúsne ussa kaizta: —Ussa kaizapmun. Ap kamtu payuwa mintuasmin, usne sun na akwa kirɨt. ");
INSERT INTO kwi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pailta payukima puizaruzne uruzpain uzanazi. Sunkana nane pailta payukima ukasa uzmanash. ");
INSERT INTO kwi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Akkwan Judío awaruzne Jesús Betania pɨpulura naptu piankamara. Jesústa izana ɨarakas, uspane Lázarorakas, Jesús irɨttas kuhsnintamikashakas, izna ɨara. ");
INSERT INTO kwi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Suasne pariya ɨnintuzne Lázarorakas piantana nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Us akwa akkwan Judío awaruzne pariya ɨnintuz kamtarat aizpa chɨhkaara, Jesústa nɨjkulana. ");
INSERT INTO kwi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Akkwan awane Jerusalén pɨpulura Pascua pishta izna ɨara. Tɨlawara Pascua pishta izmuruzne Jesús pɨpulura pianamtu piankamara. ");
INSERT INTO kwi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Suasne uspane kanarɨ kɨh tɨt kit mikin taat kit puzat kit Jesústa wanmalat kit kwiannara: “Diosne kwisha wari.” “Aune Diosta kwisha wari kiztumakpas, paiña ɨnintamika amtu akwa.” “Judío awa katsa mikwa kwisha wari.” ");
INSERT INTO kwi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesúsne burrora wanmal kit ussa anuzta, Dios pɨnkɨhta ka parɨtkana: ");
INSERT INTO kwi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalén pɨpulu uztuz ishkuaman. Izti. U mikwane sua amtui. Maza ainki burrora anuztu.” ");
INSERT INTO kwi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","An ñancha paiña kammuruzne sun parɨt aizpa mɨarachi. Jesús kuhs kit Dios watsal uztukin kailtawane, kwizta uspane us akwa wan parɨt aizpakas ussa kiarɨt aizpakas nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús Lázarora kamkis akwatkane, ussa irɨttas kuhsninkane, Jesúskasa tuattuzne wan izara aizpa kainaara. ");
INSERT INTO kwi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Katmizna awane puzat kit Jesústa wanmalara, iztasparɨt kal kirɨt aizpa piankamara akwa. ");
INSERT INTO kwi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Suasne Fariseo awane usparuzpain kaizara: —Iztain. Mane aune ussa piantachimakpas. Wan awane ussa kanpaamtu. ");
INSERT INTO kwi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pishta tuasmin, akkwanne Jerusalén pɨpulura ɨat kit Diosta wakpuj wainna nuara. Mɨnpazha Griego awakas nuara. ");
INSERT INTO kwi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Suntuzne Felipera, Betsaida pɨpuluras atmikasha, kashara ɨat kit paikuat kit kaizara: —Anpat. Jesústa izshimuspas, uskasa kwinta kin. ");
INSERT INTO kwi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipene Andrésta ɨt kit sun kaizta. Uspa paasne Jesústa ɨil kit sun kainailta. ");
INSERT INTO kwi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesúsne paasta sɨnkanara: —Nane inapain ish. Sun ura taizkane, Diosne awa iztukin chiyuras Ampura, izninnanazi, ussa wat minñanapa. ");
INSERT INTO kwi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Watcha kaiznamtus. Chara pippa pilta taiztane, sun pippane chik kit akkwan pippa wamtu. Na awa akwa imtu akwa, nane akkwan awaruza watsat mɨlnanash. ");
INSERT INTO kwi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Usmin mɨj aizpa pashimtumikane, usmin pashimtumikane, wan kat kit irɨnazi. Sunkana an sura uzasmin, Cristo pashimtumikane pailta payukima uskasa uznazi. ");
INSERT INTO kwi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mɨnpazha na ɨnintu aizpa kishitne, nawa kanpazha. Uskas na tura tuanazi. Ap Taittane na ɨnintu aizpa kishittuza kiwainat kit an tɨnta namninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesúsne ka kizta: —Mane nane ayukta tayaltu maztus. ¿Chima kiznapai? Ap Taittara ka kizsachish: “Kiwaincha, imanpa.” Sunkana kizsachish, na awa akwa ina at akwa. ");
INSERT INTO kwi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Suasne kaizta: “Ap Taitta, wan awaruza kiwaintain, wan awa nu anza wari piankamanapa,” kizta. Suasne Diosne chiyuras sɨnkara: “Awa nu kimtu aizpa piankamarawane, suasne wan awane na anza wat ish piankamanazi. Mane mamasa sun kinash.” ");
INSERT INTO kwi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sua tuattuzne chiwazha azka mɨat kit ippain azta kizara. Sunkana anpane ka kaizara: —Maza ángelne ussa kwinta kira. ");
INSERT INTO kwi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesúsne sɨnkanara: —Aune sun pit mɨaramakpas. Na akwain chi. Diosne uruza paranara, na Diostas at piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mane Diosne uruza an pit piankamninnamtu. Diosne nawa nɨjkulamtuchiruza ilnanazi, uspa kwil kiarɨt akwa. Makas ankas piankamtain. Diosne an sura ɨninmikasha, Satanásta, anupparɨt mɨji. ");
INSERT INTO kwi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nawa kurishta irukasa patpiankane, sun tɨ pilta kunninkane, nane wan suras awaruza nawa akwananash, nawa nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sun kainanamtuasmin, Jesúsne awaruza us sunkana imtu piankamninara. ");
INSERT INTO kwi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Awaruzne sɨnkaara: —Moisés parɨt aizpa akwa, aune Dios narɨtmika mizurainkas imanazi pianmakpas. Sunkana nune chiyuras Ampu kurishta patpiannazi kiznaru. ¿Chikishma sun kiztus? ¿An chiyuras Ampune mɨnma i? ");
INSERT INTO kwi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Katmizna Jesúsne kaiznara: —Nane kai malnintumikane ish. Nakas awaruza na kamtamtu aizpa piankamninmika ish. Nane ukasa akkwan payukimain uzmanash. Na kaizta aizpa mɨrain, piankamanapa, nil uzanapa. Na kaizta aizpa piankamtachiruzne tɨlta chamturuzkana mai. Uspane wan kaarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na ukasa uzasmin, na kaizta aizpa nɨjkultain. An pit uruza kiwainnanazi, nil uzanapa, kaiwara chaanapa. Sun kiznarawane, Jesúsne ɨt kit awaruztas kularɨt, ussa wanmalamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús akkwan iztasparɨt kal usparuzpa izarakin kirɨtkas, uspane ussa nɨjkulashitchi. ");
INSERT INTO kwi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sunkana uspane Isaías, Diospa kainammika, parɨt aizpa kiarɨt. Ka parɨt: “Anpat, uspane au kaiznarɨt aizpa mɨara. Uspa Dios iztasparɨt kal izarakas, uspane nɨjkularachi.” ");
INSERT INTO kwi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Uspane nɨjkularachi, Isaíaskas an kaiz kit ka para akwa: ");
INSERT INTO kwi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Diosne usparuza kasu izsachimikakana namninnara, izamanpa. Usne usparuza nilchi mininnara, wat piankamanapa. Wat piankamtuchi akwa, uspane nawa kaiyasachi, na usparuza sɨnam saninnana. Katmizna nane usparuza kakulninasachish.” ");
INSERT INTO kwi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaíasne sun pit kaiznara, Jesús ussa izpan kit paiña iztakin anza katsa namta. Katmizna usne Jesúspa parɨt. ");
INSERT INTO kwi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sun pit nɨjkularachiruzpa parɨtkas, akkwan Judío awaruza ɨnintuzne Jesústa nɨjkulara. Fariseo awaruz ishkuamtu akwa, uspane nɨjkulara aizpa wan awaruza kwinta kinarachi, Fariseo awa usparuza kammu yaltas ɨninnamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Uspane awa uspawa minñara aizpa ishkuara. Sunkana uspane Dios uspawa mintu aizpa izkiamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesúsne paiña pitkasa tɨnta kaiznara: “Nawa nɨjkultumikane, nawainchi nɨjkultu. Uskas nawa ɨnintumikashakas nɨjkultu. ");
INSERT INTO kwi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nawa iztamikane nawa ɨnintumikashakas iztu. ");
INSERT INTO kwi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nane impilkanain ish. Nane awaruza na kamtamtu aizpa piankamninmika ish. Nane an sura arau, nawa nɨjkulturuz kwail kiamanpa, Diosta pianchiruzkanain tɨlkwilta chamturuzkanain uzamanpa. ");
INSERT INTO kwi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mɨnpazha ap pit mɨamtukas, nane na kaizta aizpa kishitchiruza uspa kwail kiarɨt aizpa annamanash. Nane an sura atchish, awaruzpa kwail kiarɨt aizpa anninnana. Sunkana nane arau, wantuza watsat mɨlnana. ");
INSERT INTO kwi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Diosne nawa pashitchiruzakas, na kaizta aizpa mɨmtuchiruzakas, uspa kwail kiarɨt aizpa piankamninnazi. Minpa payura Diosne awaruza ap pit akwa ilnanazi, ĩnta ɨanpa. ");
INSERT INTO kwi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nane ap minpain paramtuchish. Taittane, nawa ɨnintamikane, na sun kinpa chɨhkarɨt, sun kiz kit kamtanapa. ");
INSERT INTO kwi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ap Taittane sun pit ɨninnara, awa nɨjkulat kit pailta payukima uzanapa. Ap Taittane paiña pit nawa ɨninta, kainanapa. Katmizna sun pitmin paramtus.” ");
INSERT INTO kwi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mane Pascua pishta taiznapain. Jesúsne us imtu payu taiznapain piankamta, an sukis puz kit papihsh uztukin kailna. Usne an sukin ussa nɨjkulturuza pailta payukima kwisha pashinara. Usne us imtu payukima usparuza pashinara. ");
INSERT INTO kwi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sun payura Jesúskas paiña kammuruzkas kumira kuamtuchasmin, Diablone Judas Iscariotera, Simónpa painkulta, pizta, Jesústa kwail awaruza chɨhkana ɨnpa. ");
INSERT INTO kwi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","4","Jesúsne Diostas at piankamta. Diostakima kailmɨztu uskasa uzna piankamta. Paiña Papihsh ussa wan ɨninnapa mɨlatkas, Jesúsne kiwainmikakana misharɨras kun kit paiña ɨsal kwaksham ukkat kit kiham pĩnkas usmin pɨjara ipta. ");
INSERT INTO kwi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kwiztane kwazi uk kit wazta paranta. Suasne paiña kammuruzpa mittɨ kitmɨz kit pɨjaras kiham pĩn ukkat kit pulchaktamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simónpa mittɨ kitmɨzkane, Pedrone Jesústa kaizta: —Anpat, ap mittɨ kitsachi, kizta. ");
INSERT INTO kwi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesúsne ussa sɨnkara: —Mane nune na kimtu aizpa pianchi. Sunkana kwiztane piankamnazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrone ussa kaizta: —Mizurainkas ap mittɨ kitmanazi. Jesúsne ussa sɨnkara: —Na up mittɨ kittukine, nune ap kanmumika namsachi. ");
INSERT INTO kwi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Suasne Pedrone ussa kaizta: —Anpat. Ap mittɨin kitmun. Chihtɨkas kɨzpukas mittɨkas kitcha, kizta. ");
INSERT INTO kwi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sunkana Jesúsne sɨnkara: —Nune wan pinachi. Pikamtɨtmikane paiña mittɨrain kittawa. Diosne u kwail kiarɨt aizpa watkulninnat kit u kaijchukin sɨnam sanara. Mazane sɨnam sarachi, paiña kwail kirɨt aizpa sɨnam kwiznintachi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesúsne mɨn ussa chɨhkamtumika pian. Katmizna ka kizta: “Mazane sɨnam sarachi, paiña kwail kirɨt aizpa sɨnam kwiznintachi akwa.” ");
INSERT INTO kwi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Usparuzpa mittɨ kittawane, usne mamasa paiña kwaksham kuht kit misharɨra uz kit usparuza ka mɨmanara: —¿Une na uruza kit aizpa piankiwas? ");
INSERT INTO kwi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Une nawa kamtamkas anpatkas munamtu. U kaizara aizpa nil kizamtui. ");
INSERT INTO kwi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nane u kamtammikakas u anpatkas ish. U sun piankas, nane, kwaimmikakana uruzpa mittɨra kitnarau. Kawarain ukas, kiwainmumikakanain uruzpa mittɨ kitnarawa. ");
INSERT INTO kwi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nane an watsal kal u iztakin annarau, ukas sunkanain kianapa, na kirɨtkanain kiamɨznapa. ");
INSERT INTO kwi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Watcha kaiznamtus. Kiwainmumikane paiña anpatkin anza katsa chi i. Kawarain ɨnintamikane ɨnintumikakin anza katsa chi i. Kawarain, na ukin anza katsa mika ish. Sun piankas, nane uruzpa mittɨ kitnarau. ");
INSERT INTO kwi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na kaizta aizpa mɨarane, sun kiarane, une watsal kulanazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nane wan uruzpa paramtuchish. Nane ap narɨttuza pianish. Dios pɨnkɨhta parɨt aizpa ka sunkana kirɨt: “Nakasa kumtumikane nawa aliz kul kit nawa kwail kimɨzta.” ");
INSERT INTO kwi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sun kitchasmin, mane nane sun pit kaiznamtus, na pailta payukima uzatmika i nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mane watcha kaiznamtus. Nawa ɨnintumikasha saptumikane nawa sapnazi. Nawa saptamikane nawa ɨnintamikasha sapnazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sun pit kiztawane, Jesúsne kaijchu ayukta tayal kit kwail maz kit kaiznara: —Watcha kaiznamtus. Mazane uruztas nawa kwail awaruza chɨhkananazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kammuruzne mamazta mamazta izamɨzta. Uspane mɨnama paramta mɨasachi. ");
INSERT INTO kwi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maza kammumikane, Jesústa kwisha pashitmikane, paiña makin uzta. ");
INSERT INTO kwi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedrone ussa puintain izpa sara, Jesústa mɨmanapa, mɨnama paramtarau. ");
INSERT INTO kwi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sun kammumikane Jesústa an kasha ɨt kit mɨmara: —Anpat. ¿Mɨnama paramtus? ");
INSERT INTO kwi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesúsne ussa sɨnkara: —Pan pitti wazta wintawane, nane ussa kwinnash. An pan saptumikane sun kinazi. Sun urain usne pan pitti piz kit wazta win kit Judasta, Simón Iscariotewa painkulta, kwinta. ");
INSERT INTO kwi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas an pan saptawane, Satanásne ussa pizta. Jesúsne ussa kaizta: —Nu kishit aizpa azain kiri. ");
INSERT INTO kwi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Misharɨkin uztuzne chikishma sun ussa paraka mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judasne auruzpa pial watsat kit tuhta mɨlta. Mɨnpazha Judas chiwazha we pishta kumira paina ɨrɨzi minñara. Mamaztuzne Judas puizara pial mɨlan ɨrɨzi minñara. ");
INSERT INTO kwi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pan pitti sap kit kwatpane, sun urain Judasne tas puzta. Amta tɨl parɨt me. ");
INSERT INTO kwi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas puztawane, Jesúsne kaizta: —Mane une nawa chiyuras Ampu anza tɨnta i piankamamɨznazi. Us kimtu akwa, Diosne ussa u iztakin anza tɨnta namninnazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chiyuras Ampu Dios anza tɨnta namnintane, Dioskas mamaztuzpa iztakin paiña painkulta us anza tɨnta namninnazi. Sun urain kinazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Une ap wat pashpakanain mai. Mɨzha. Nane ukasa akkwan payu uzmanash. Nane Judío awa ɨninturuza kaiztakanain uruza kawarain kaiznanash. Nawa sayamtukas, une nawa na ɨmtura kanpaamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nane uruza masas ɨnimmu ka mɨlanamtus: Mamazta mamazta pashinarawa. Na uruza pashimtukanain, ukas mamazta mamazta pashinarawa. ");
INSERT INTO kwi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","U mamazta mamazta sunkanain pashinamtune, wan awane u ap kammuruz mai piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedrone Jesústa mɨmara: —Anpat. ¿Mɨntama ɨmtus? Jesúsne ussa sɨnkara: —Ma na ɨmtura kanpamsachikas, nune nawa kwizta kanpanazi. ");
INSERT INTO kwi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrone ussa kaizta: —Anpat. ¿Chikishma nane nua kanpasachish? Nane nu akwa inapain ish. ");
INSERT INTO kwi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesúsne ussa sɨnkara: —Nu na akwa inapain i kiztukas, Aral kayu kutña piji aztachasmin, nune “ussa pianchish” kiznazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Suasne Jesúsne usparuza kaiznara: “Tayalman. Ishkuman. Diosta nɨjkulamtuasmin, nawakas nɨjkultain. ");
INSERT INTO kwi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ap Taitta uzkinne kwisha akkwan uzmu wa. Akkwan uzmu wachiatne, nane uruza kaiznashina. Mane nane u akwa sun uzkin watsana ɨmɨztus. ");
INSERT INTO kwi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sua ɨtpane, sun uzkin watsarawane, mamasa kailnash, uruzakas ta mɨlnanapa, ukas na tukinmin puranpa. ");
INSERT INTO kwi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Une me na ɨmtu mi pianmai.” ");
INSERT INTO kwi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomásne Jesústa sɨnkara: —Anpat, nu ɨmtura pianchimakpas. ¿Aune mizama sun mi piankamshinai? ");
INSERT INTO kwi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesúsne ussa sɨnkara: —Nune na akwa Dios uzkin piananazi. Nune na akwa Diospa watcha piankamnazi. Nane nua pailta payukima uznintus. Nawa nɨjkultumikane ap Taitta uzkin piananazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nawa wat piankamtu akwa, une ap Taittara piankamanazi. Une makis ussa piankamanazi, nawa izta akwa. ");
INSERT INTO kwi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Suasne Felipene kaizta: —Anpat, Taittarain izshimtumakpas. Taittara izninchain. ");
INSERT INTO kwi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ussa sɨnkara: “Felipe, na akkwan payukima nukasa uztakas, ¿Nawa mama pianchikish? Nawa iztamikane Taittarakas iztu. Katmizna ‘Taittara iznincha’ kizmun. ");
INSERT INTO kwi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ap Taittakas nakas maza awakanain was. ¿Sun nɨjkultukish? Na wan uruza kamtara aizpa ap pitkis amtuchi. Ap Taittane sun pit nawa chɨhkara. Taittane, nakasa uztamikane, nawa kiwaintu, us kishimtu aizpa kinpa. ");
INSERT INTO kwi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Une na Taittakasa uztu nɨjkultain. Kawarain Taitta nakasa uztu nɨjkultain. Na uruza kaizta aizpa nɨjkulamtukine, na kal kirɨt akwa nɨjkultain. ");
INSERT INTO kwi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Watcha kaiznamtus. Nawa nɨjkulturuzne na kimtukana kianazi. Na ap Taittara ɨmtu akwa, une nakin anza akkwan kal kianazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nawa kanpamtuzne nawa nɨjkulamturuzne Diosta paikuanazi. Suasne nane uruza u paikumtu aizpa mɨlananash, Taittara anza wari piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nawa kanpamtuz chiwazha paikuarane, nane u paikumtu aizpa mɨlananash.” ");
INSERT INTO kwi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“U nawa pashiamtune, une na ɨninta aizpa kianazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nakas Taittara paikwanash, uruza mamaz kiwainmikasha, paiña Sɨnam Izpulta, ɨninnanapa. Usne ukasa pailta payukima tuanazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sɨnam Izpulne uruza watcha kurunnanazi. Diosta nɨjkultuchiruzne ussa sappamanazi, ussa izasachi akwa, ussa piankamasachi akwa. Une ussa piankamamtu. Usne ukasa uz kit pailta payukima uruza kiwainanazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nane uruza kwairɨt pashpakana kwaimanash. Mamasa kailnash, ukasa tuan. ");
INSERT INTO kwi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","An suras awaruzne, nawa nɨjkultuchiruzne, akwan payuchikimain nawa izamanazi. Une nawa izanazi. Na uztu akwa, na mamasa kuhstu akwa, nane uruzakas uzninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sun payu taizkane, une nakas Taittakas maza awakanain was piankamanazi. Ukas nakas parejuin chaanapas, izmuruzkanain. ");
INSERT INTO kwi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Na ɨninta aizpa pianmikane, na kaizta aizpa mɨmtumikane, suntuzmin nawa pashimtu. Ap Taittane nawa pashitmikasha pashinazi. Nakas ussa pashit kit ussa nanash, nawa wat piankamnapa.” ");
INSERT INTO kwi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasne, Judas Iscariotechine, ussa mɨmara: —Anpat, nune aumɨzain nuwa piankamninnara. ¿Chikishma anparuza nuwa piankamninnarachi? ");
INSERT INTO kwi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesúsne sɨnkara: “Nawa pashimtumikane na kamtamtu aizpa kinazi. Ap Taittane ussa pashinazi. Taittakas nakas nawa pashimtumikakasa uzna amtuas. ");
INSERT INTO kwi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nawa pashitchimikane na kamtamtu aizpa mɨshitchi. Ap pit u mɨamtu aizpa ap pit chi. Ap Taittane, nawa ɨnintamikane, sun pit ɨninta. ");
INSERT INTO kwi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na ukasa chamtuasmin, nane wan kamtam pit kaiznamtus. ");
INSERT INTO kwi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sunkana nane ap Taittara paikwanash, Sɨnam Izpulta, kiwainmikasha uruza ɨninnapa, uruza wan kamtanapa, na uruza kaizta aizpa mainmanpa. ");
INSERT INTO kwi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na ɨmtukas, une Dios akwa kalpain uzanazi. Nakas uruza kalpain uzninnanash. Sunkana an suras awane, nawa nɨjkultuchiruzne, uruza kalpain uzninnasachi. Tayalman. Ishkuman. ");
INSERT INTO kwi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Une an ñamin na kaizta aizpa mɨat kit mamasa sun pitmin ka kaiznamtus: ‘chiyura nuna ɨrɨmtukas, imtukas, mamasa kailnash, ukasa tuan.’ U nawa pashiamtune, une watsal kulanazi, na ap Taittara tukin ɨmtu akwa. Ap Taittane nakin anza tɨnta i. ");
INSERT INTO kwi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ma payu nane chiwazha kinamtu aizpa uruza kainanarau. Sun payu taizkane, une nawa nɨjkulanazi. ");
INSERT INTO kwi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mane akkwan payuchikima uruzkasa paramanash, an sukin ɨnintumika, Satanás, amtu akwa. Usne nawa anuppasachi. ");
INSERT INTO kwi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mane wan awane na ap Taittara pashimtu piankamanazi. Katmizna nane us nawa ɨninta aizpa kirau. ‘Kuhsaktain. Akkis ɨzhain.’ ” ");
INSERT INTO kwi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Suasne Jesúsne an kamtanamɨzta: “Nane watcha wankail tɨtkanain ish. Ap Taittane wankail nanta kal kimmikakana i. ");
INSERT INTO kwi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tɨ kuhia pippa wamakane, usne kuhiara kal piztu. Pippa wakane, usne watsal tɨttu, an akkwan pippa wamɨznapa. ");
INSERT INTO kwi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ukas ap tɨ sailkanain mai. U ap kamtam mɨarɨt akwa, nane u kwail sɨnam sanarau. ");
INSERT INTO kwi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nawa wanmak uzchain. Nakas uruza wanmak uztus. Maza tɨ sailta tɨttane, tɨ sailne wankail pippa wasachi, tɨtta wanmaktachi akwa. Nawa wanmaktɨt uzmakane, kawarain, une watsal uzasachi. Chinkas kiasachi. ");
INSERT INTO kwi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nane tɨtkanain ish. Une tɨ sailkanain mai. Nawa wanmak uztumikane kwisha wat kinazi, au wanmaktɨt uztu akwa. Nakasa wanmaktukine, une chinkas kiasachi. ");
INSERT INTO kwi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Na kaizta aizpa mɨrachimikane kwairɨt tɨt kuhiakana i. Tɨt kuhia pul parɨkane, chak kit ĩnta kiakpɨntɨnazi, ĩnta paktanapa. ");
INSERT INTO kwi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","U nawa wanmaktɨt uzamtune, u na kaizta aizpa mɨarane, nane uruza chiwazha u paikumtu aizpa mɨlannanash. ");
INSERT INTO kwi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ap kal kimtuzne, nil uztuzne, ap Taittara wat kulninnazi. Une awaruza ap Taitta an tɨnta i piankamninnanazi. Suasne awane ap watcha kammuruz namarɨt piankamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nane uruza pashinamtus, ap Taitta nawa pashimtukanain. Na ɨninta aizpa kimɨztain, na uruza pashinanapa. ");
INSERT INTO kwi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","U na ɨninta aizpa kiamtune, nane uruza pashinamɨznash. Ap Taittakas nawa pashimtu, na us ɨninta aizpa kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nane sunkana paramtus, u na wat kulamtukanain uzanapa. ");
INSERT INTO kwi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nane uruza sunkana ɨninnamtus: ‘Une na uruza pashinamtukanain mamazta mamazta pashinarain.’ ");
INSERT INTO kwi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Izmuruza pashitmikane uspa akwa ishinazi. Izmuruz akwa ishitmikane anza wat paiña izmuruza pashinamtu. ");
INSERT INTO kwi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na ɨninta aizpa kittuzne ap izmuruz mai. ");
INSERT INTO kwi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Makis nane uruza ap kal kiwaintuz mai kizmanash, kal kiwainmumikane paiña ɨninmika mintu aizpa pianchi akwa. Nane u ap izmuruz mai kiznat kit ap Taitta nawa wan kaizta aizpa uruza kamtanarau. ");
INSERT INTO kwi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Une nawa nanaarachi. Nain uruza nananarau, na akwa akkwan kianapa, na ɨninta aizpa kizanapa, u na akwa kiamtu aizpa pailmanpa. U sunkana nawa nɨjkulamtune, ap Taittane uruza chiwazha paikumtu aizpa mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nane maza pitmin uruza ka ɨninnash: ‘Mamazta mamazta pashinarain.’ ” ");
INSERT INTO kwi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Awa ukasa aliz kulamtune, an ñancha uspa nakasa aliz kulara piankamtain. ");
INSERT INTO kwi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","U nawa nɨjkulamtuchiruzkasa wanmaktɨt uzaratne, uspane uruza uspa kwalkanain pashiara. Nane uruza nawa nɨjkulamtuchiruztas nanarau, u nakasa tuanpa. Katmizna, uspane ukasa aliz kulamtu, usparuztas puzara akwa. ");
INSERT INTO kwi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na an ñamin kaizta aizpa nɨjkultain: ‘Anpat naiztune, kal kiwainmikakas kawarain naizarɨnazi.’ Awa nakasa aliz kulamtune, uspakas ukasa aliz kularɨnazi. Na kamtara aizpa mɨarane, uspane u kamtara aizpakas mɨanazi. ");
INSERT INTO kwi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nawa ɨnintamikasha piankamtuchi akwa, uspane nawa nɨjkularuza naizninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na usparuza paranat akwa, uspane uspa kwail kiarɨt aizpa piankamara. Mane nawa nɨjkulamtuchiruzne kwail kimtuchish kizasachi. Mɨnminkas uspa kwail wat puinsachi. ");
INSERT INTO kwi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nakasa aliz kulamturuzne ap Taittarakas aliz kulamtu. ");
INSERT INTO kwi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na uspa iztakin sun iztasparɨt kal kitkas, uspane uspa kwail kiarɨt aizpa maizashitchi. Mɨnminkas sunkana kal kitchi. Na kirɨt aizpa izaratkas, uspane nawakas ap Taittarakas aliz kulamtu. ");
INSERT INTO kwi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Uspa ɨnimkin ka parɨt: ‘Na chinkas kwail kitchikas, uspane nawa aliz kulamtu.’ Ma sun kirɨt me. ");
INSERT INTO kwi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nane Taittaras Sɨnam Izpulta, watcha kuruntumikasha, ɨninnash. An uruza kiwainmikane na akwa kainanazi. ");
INSERT INTO kwi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ukas nawa kainanazi, u nakasa an ñancha tuat akwa.” ");
INSERT INTO kwi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús an kamtanamɨz kit kaiznara: “Nane chiwazha uruza kaiznamtus, mamaz miwara chamanpa, na kamtara aizpa nɨjkulamɨznapa. ");
INSERT INTO kwi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judío mikwaruzne uruza kammu yalkis paimpa ɨninnanazi, uspakasa puramanpa. Mamaz payura mɨnpazha uruza piantananazi. Uruza piantanamtukas, uspane Diosta kiwaintu minñarɨnazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Uspane uruza ka kianazi, ap Taittarakas nawakas pianchi akwa. ");
INSERT INTO kwi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sun payu taizkane, awane sunkana uruza kinanazi. Sun uruza kiamtuchasmin, nane uspa kiamtu aizpa kainanamtus. Kwiztane une na kaizta aizpa nɨjkulanazi.” “Ñamin nane uruza paranarachish, na ukasa tuat akwa. ");
INSERT INTO kwi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sunkana nane ap ɨnintumikawarain kailtɨmtus. Mɨnminkas uruztas nawa ¿Mɨnta ɨmtus? mɨmamtuchi. ");
INSERT INTO kwi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na uruza sun kimtu aizpa kainanara akwa, une kwisha tayalmɨztu. ");
INSERT INTO kwi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nane watcha kaiznamtus. Na ɨmtune, u akwa an wari. Na ɨmtuchine, u kiwaintumikane ukasa amanazi. Na ɨmtune, nane uruza kiwainmikasha ɨninnash, ukasa chan. ");
INSERT INTO kwi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Dios Sɨnam Izpul akane, usne nawa nɨjkultuchiruza uspa kwail kiarɨt aizpa piankamninnanazi. Usne awa miza nil uzna piankamninnanazi. Usne Dios wantuza uspa kwail akwa ilnamtu piankamninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nawa nɨjkulamtuchi akwa, uspane kwail kiamtu. ");
INSERT INTO kwi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na an sura nil uztu akwa, nane ap Taittara kailtɨnash. Katmizna une an nawa izamanazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Diosne awaruza paiña pit ɨninta aizpa nil i piankamninnazi, nil uzanapa. Dioskas Satanásta, an sura ɨnintamikasha, naizninnapa ɨnintɨt me. ");
INSERT INTO kwi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na uruza an akwan pit kaizshinamtukas, mane une an akkwan pit mɨasachi. ");
INSERT INTO kwi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sɨnam Izpul akane, watcha kurunmumika akane, usne uruza Diospa watcha piankamninnanazi. Usne uruza watcha kamtananazi. Paiña pitmin paramtuchi akwa, usne paiña Taitta ussa kaizta aizpa paranazi. Usne uruza mamaz payura kirɨmtu aizpa piankamninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Usne na watcha kaizta aizpa uruza kamtaninnanazi. Usne awa iztakin nawa an tɨnta namninnazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nane chiwazha ap Taitta mɨj aizpa mɨjish. Katmizna paiña Sɨnam Izpulne, kiwainmikane, na kaizta aizpa uruza piankamninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Une akkwan payuchikima nawa izamanazi. Suasne kwiztane une nawa mamasa izanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Suasne mɨnpazha kammuruzne usparuzpain ka mɨmaara: —Usne aumɨza ¿Chima paramtusa? “Masetne akkwan payuchikima ussa izanapas,” kiztu. “Masetne kwiztane aune ussa mamasa iznapas,” kiztu. Ankas kiztu, “Ap Taitta uzmura ɨmtu akwa, aune ussa izamanapas.” ");
INSERT INTO kwi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Uspane ka mɨmaamɨzta: “Akkwanchin payukima” kizkane, ¿Chima kizshimtusa? Aune us paramtu aizpa pianchimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Uspa mɨmashimtu aizpa mintu akwa, Jesúsne usparuza kaiznara: “Akkwan payuchin nawa izamanazi. Kwiztane nawa mamasa izanazi. ¿Na kaizta aizpa nawa mɨmashiamtukiwas une? ");
INSERT INTO kwi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nane uruza watcha kaiznamtus. U azat kit tayalamtuasmin, nawa nɨjkultuchiruzne watsal kulanazi. U tayalamtukas, kwiztane une anza watsal kulamɨznazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pashpa mɨltu payu taizkane, ashampane kwisha ishtu maz kit naizmɨztu. Sunkana pashpa mɨltawane, ashampane paiña ishtu main kit watsal kulmɨztu, pashpa mɨltɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ukas sunkanane ma payu tayalmɨznazi. Sunkana nane uruza izna kailnash. Sun urain une watsal kulamɨznazi. Mɨnminkas uruza tayalninmanazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sun payu taizkane, une nawa chinkas paikumanazi. Watcha uruza kaiznamtus. U nawa nɨjkulamtu akwa, u chiwazha Taittara paikuakane, usne uruza mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nawa nɨjkularɨtkas, makima une chinkas ap Taittara paikuarachi, u nawa kanparɨt akwa. Ussa paikwarain, us uruza mɨlananapa, u kwisha watsal kulanapa.” ");
INSERT INTO kwi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Makima nane uruza mamaz kamtam pitkasa paranarau. Sunkana mamaz payura nane uruza kamtam pitkasa paramanash. Sun payura nane ap Taittawa uruza nil parananash, an wat piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sun payu taizkane, u nawa nɨjkulamtu akwa, nane u pashiamtu aizpa ap Taittara paikuanazi. Sun payura nane u akwa Taittara paikumanash, ");
INSERT INTO kwi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taittain uruza pashinamtu akwa. Usne uruza pashinamtu, u nawa pashinamtu akwa, u na Diostas at nɨjkulamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nane Taittaras puz kit an sura arau. Mane nane an sura tuij ɨnash chiyura, ap Taitta uztukin, kailna.” ");
INSERT INTO kwi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kammuruzne ussa kaizara: —Mane nune aumɨza nil paramtui, kamtam pitkasa chin, au piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mane aune nu wan pian aizpa pianmakpas. Mane mɨnminkas nua chinkas mɨmana pashimtuchi, nu awa minñamtu aizpa piankamtu akwa. Katmizna aune nu Diostas at nɨjkultumakpas. ");
INSERT INTO kwi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesúsne sɨnkanara: —Une mama nawa we nɨjkulamtu. ");
INSERT INTO kwi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Iztain. Une maza mazain nawa tuij ɨat kit uruzpa yalta ɨat kit nawa mazain chɨhkaanazi. Sun kimtu aizpa kinpain. Sunkana nane mazain tukianash, ap Taitta nakasa tu akwa. ");
INSERT INTO kwi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nane sun wan uruza kaiznamtus, u watsal kulanapa, u nakasa wanmaktɨt akwa. An sukin uzamtuasmin, une naizarɨnazi. Ishkuman. Nane wan an sura ɨninturuza me anupparɨt ish. Nane Diosta aliz kulamturuzkin an tɨnta ish. ");
INSERT INTO kwi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","An pit kiztawane, Jesúsne chiyura izak kit Diosta paikwara: “Taitta. An payu taiznapain i, awa iztukin up Painkul anza tɨnta namninnapa. Suasne up Painkulne awa iztakin nu anza tɨnta i namninnanazi. ");
INSERT INTO kwi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nune nawa up Painkulta narɨt, wan awaruza ɨninnanapa, wan nawa kammuruza pailta payukima uzninnanapa. Nune usparuza nawa mɨlanara. ");
INSERT INTO kwi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pailta payukima uzshimturuzne nua, maza Diosta, watcha Diosta piankamtawa. Uspane nawakas, nu ɨnintɨtmikashakas, piankamtawa. ");
INSERT INTO kwi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nane an suras awaruza nu anza tɨnta i piankamninnara. Nane nu nawa ɨnintɨt aizpa kin pailtɨt ish. ");
INSERT INTO kwi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mane, ap Taitta, nawa mɨzha. An su sarachasmin, na nukasa uztuasmin, nune nawa anza tɨnta namninta. Up iztakin nawa mamasa anza tɨnta namnincha. ");
INSERT INTO kwi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nune an suras awaruza nanarɨt, nakasa tuan. Nane usparuza nuwa piankamninnarau. Uspane up kwalkanain namanazi. Nune usparuza ɨninnara, nakasa tuanpa. Uspane nu kamtara aizpa kiarɨt. ");
INSERT INTO kwi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mane, uspane wan na kaizta aizpa uptas puztu piankamamtu. ");
INSERT INTO kwi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nane nu nawa kaizta aizpa usparuza kamtanarɨt ish. Uspane sun pit mɨat kit na uptas puztu watcha nɨjkulamtu. Uspane nu nawa ɨninta nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nane nua paikumtus, nu nawa ɨnintɨttuza kiwainnanapa. Nane wan an sukin uztuz akwa paikumtuchish. Nane nua piankamturuz akwa paikumtus, usparuza kiwainanapa. ");
INSERT INTO kwi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wan awa nu nawa ɨnintɨttuza ap i. Wan awa nawa arɨttuza up i. Nawa kammuruzne na anza tɨnta i namninnara. ");
INSERT INTO kwi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ɨrattura nane an sukin tukianash, chiyura nuna. Na nu tukin uztuasmin, uspane an sukin puranazi. Nune, ap Taittane, sɨnammika i. Nu nawa kiwainta akwa, nua nɨjkulturuza kiwainnari, wan nɨjkulturuz wanmak uzanapa. Nakas nukas wanmak uztu akwa, usparuza kiwainnari, kawarain uzanapa. ");
INSERT INTO kwi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na usparuzkasa an sura uztuasmin, Diosne nawa tɨnta kiwainta. Nane usparuza iznat kit watsanarau, nawa nɨjkulara akwa. Usparuza pakpiannamtuasmin, nane mɨnminkas usparuztas kanarachish. Mazain karɨt, Dios pitta parɨt aizpa nil kinpa. ");
INSERT INTO kwi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mane nane nu tura ɨnash. Na an sura uztuasmin, nane an pit an sura uztuza kaiznamtus, uspa watsal kulanapa, nakanain watsal uzanapa. ");
INSERT INTO kwi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na up pit usparuza kaiznarɨtkas, nawa nɨjkulamtuchiruzne usparuza aliz kularɨt. Nawa nɨjkulamturuzne an sukis awakana minñaramtuchi, nawa nɨjkultuchiruz Satanás pashimtu aizpa kiamtu akwa. Nakas an sukis awakanain mintuchish. ");
INSERT INTO kwi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nane nua paikumtuchish, usparuza an sukis ukkanapa. Nane uspa akwa paikumtus, Satanás kwail kimika usparuza kwail kimanpa. ");
INSERT INTO kwi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nawa nɨjkulamturuzne an sukis awakanain minñamtuchi, an sukis awa Satanás pashimtu aizpa kiamtu akwa. Nakas an sukis awakanain mintuchish. ");
INSERT INTO kwi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Usparuza up watcha pit akwa sɨnam sanintain, up kalmin kianapa. Up pit paramtu aizpa watcha i. ");
INSERT INTO kwi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nune nawa an suras awakasa uzna ɨninta. Kawarain nane usparuza an suras awakasa uzna ɨninnanash, up pit kainanapa. ");
INSERT INTO kwi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nane nawa nɨjkulturuzpa ishimtus, usparuz nua chɨhkanapa. Suasne uspane up watcha pit akwa, sɨnam puranazi. ");
INSERT INTO kwi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nane uspa akwain paikumtuchish. Suntuzne mamaz awaruza Dios pit kainananazi. Nakas mamaz payura nawa nɨjkulamturuzpa paikumtus. ");
INSERT INTO kwi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nua usparuzpa paikumtus, wan wanmak uzanapa. Nune, ap Taittane, nakasa wanmak uztu. Nane nukasakas wanmak uztus. Nane uspa wanmaktɨt aukasa uzanapa paikumtus, wan an suras awa nu nawa ɨnintɨt nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nu nawa anza tɨnta namninta akwa, nane sunkanain usparuza an tɨnta namninnanazi. Suasne uspane maza awakanain wanmak uzanazi. Kawarain nukas nakas wanmak uztuas. ");
INSERT INTO kwi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nakas nukas wanmak uztu akwa, usparuzkas nil wanmak uzshianazi. Suasne an suras awane nu nawa ɨninta piankamanazi. Uspane nu nawa pashinamtu piankamanazi. Nune nawa pashimtukanain usparuza pashinamtu. ");
INSERT INTO kwi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ap Taitta, mɨzha. Nane nu nawa ɨnintɨttuz akwa paikwashimtus, uspa na tukin tuanpa, uspa nawa anza tɨnta i izanapa. An su sarachasmin, nune nawa pashit kit nawa anza tɨnta namninta. ");
INSERT INTO kwi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ap Taitta, nuin nil aizpa kimtu. An suras awane nua piankamamtuchi. Nain nua pianish. Mamaztuzkas, na iztakin uzturuzne, nu nawa an sura ɨnintɨt piankamamtu. ");
INSERT INTO kwi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nane nuwa paranarau, uspa nua piankamanapa. Summin usparuza nuwa kwinta kimtanash, na nua pashinamtukanain mamaztuza pashianapa. Sunkanain nane usparuzkasa tunash. Pailti.” ");
INSERT INTO kwi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sun paikwatpane, Jesúskas paiña kammuruzkas yaltas puzat kit Cedrón pi kwakkat kit olivos tɨ wamkin napparɨt. ");
INSERT INTO kwi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasne, ussa chɨhkashimtumikane, sun olivos tɨ wamkin pian, Jesúskas paiña kammuruzkas akkwan payu sua ɨarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Katmizna Judasne Jesústukin olivos tɨ wamkin at kit akkwan awaruza sun miwara annara. Akkwan Roma pɨpuluras suldarukas katsa pariyawa kiwainmuruzkas Fariseowa kiwainmuruzkas sun tɨ wamkin nappaara impilkasakas, mashtikasakas. ");
INSERT INTO kwi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús uspa kiashimtu aizpa pian akwa, Jesúsne usparuza wanmal kit mɨmanara: —¿Mɨnama sayamtuas? ");
INSERT INTO kwi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Uspane ussa sɨnkaara: —Jesústa, Nasaret pɨpulura uzmikasha, saimtumakpas. Jesúsne kaiznara: —Na ish. Judasne, ussa chɨhkamtumikane, uspakasa wanmakta. ");
INSERT INTO kwi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús “na ish” kizkane, uspane kwizta ɨat kit pilta nainñara, ishkuarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Suasne Jesúsne mamasa mɨmanara: —¿Mɨnama sayamtuas? Uspane sɨnkaara: —Jesústa, Nasaret pɨpulura uzmikasha, saimtumakpas. ");
INSERT INTO kwi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesúsne mamasa kaiznara: —Nane “na ish” kiznarau. Nawa sayamtune, ap kammuruza chɨhtnarain, ɨarɨnpa. ");
INSERT INTO kwi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesúsne sunkana kizta, paiña pit kaizta aizpa kirɨnpa. Ka kizta: “Nane ap Taitta akwattuza iznarau. Mɨnainkas kanintachish.” ");
INSERT INTO kwi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Suasne, Simón Pedrone paiña mashti ukkat kit katsa pariyawa kiwainmumikawa numal kail yalta. Usne Malco muntɨt. ");
INSERT INTO kwi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sunkana Jesúsne Pedrora kaizta: —Up mashti watsari. Nawa mɨzha. Nane ap Taitta nawa kinpa ɨninta kishimtus, naiznakima. ");
INSERT INTO kwi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Suldaruwa ɨninmikakas, wan suldarukas, Judío pariyawa kiwainmuruzkas Jesústa pizat kit paiña chihtɨkin kuhtara. ");
INSERT INTO kwi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tas Anáspa yalta mɨlaara. Anásne Caifáspa suegro azi. An añokin Caifásne anza katsa pariya azi. ");
INSERT INTO kwi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","An Caifásne ñamin Judío awa ɨninturuza ka kaiznara: “Maza ampu au wan Judío awaruzpa akwa irane, anza wari.” Suasne Romano awaruzne au wan Judío awaruza piantaamanazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedrokas mamaz kammumikakas Jesústa kanpailta. An kammumikane katsa pariyara wat piankam kit katsa pariyawa ɨnintukin Jesúskasa napta. ");
INSERT INTO kwi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro pianamal pɨjtakin kunasmin, mamaz kammumikane, katsa pariyara pianmikane, puz kit ashampa pɨjta iztamikasha parat, Pedro napnapa. ");
INSERT INTO kwi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nimpihsh pɨjta iztamikane Pedrora iz kit mɨmara: —¿Nune an ampuwa kammumikakish? Pedrone sɨnkara: —Na chi ish. ");
INSERT INTO kwi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tɨh pamtu akwa, kiwainmuruzkas pariyawa kiwainmuruzkas kunat kit imchaj ĩn usappat kit ikulara. Pedrokas uspakasa ikul kit kunazi. ");
INSERT INTO kwi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Katsa pariyane Jesústa paiña kammuruzpakas us kamtamtu aizpakas mɨmara. ");
INSERT INTO kwi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesúsne kaizta: —Nane wan awaruz iztakin paranarau. Nane Judío kammu yaltakas Diospa katsa yaltakas Judío wanmakkamtukinkas kamtanarau. Nane puinta paratchish. ");
INSERT INTO kwi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chitma nawa mɨmamtu? ¡Nawa mɨraruza mɨmarain! Uspane na kaizta aizpa nua kainanazi. Uspane na kaizta aizpa wat pianmai. ");
INSERT INTO kwi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús sun kiztawane, Dios katsa yalkin kiwainmumikane paiña chihtɨkasa Jesústa aim kit kit kizta: —Katsa pariyara sunkana sɨnkamun. ");
INSERT INTO kwi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesúsne sɨnkara: —Na kwail paratne, chi kwail parat aizpa kainazha. Na parat aizpa watne, ¿Chikishma nawa aim kimtus? ");
INSERT INTO kwi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Suasne Anásne Jesústa kuh kit Caifás turakima, an katsa pariyara, ɨninta. ");
INSERT INTO kwi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro kun kit ikultuasmin, uspane ussa mɨmaara: —¿Nune an ampuwa kammumikakish? Pedrone pɨrail kiz kit kaizta: —Na chi ish. ");
INSERT INTO kwi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kwiztane mamaz katsa pariyawa kiwainmumikane sua uz. Ñamin olivos tɨ wamkin Pedrone paiña kwalpa kail yalta. Usne Pedrora kaizta: —Nane nua Olivos tɨ wamkin iztau. ");
INSERT INTO kwi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedrone mamasa pɨrail kaizta. Sun urain aral kayune azta. ");
INSERT INTO kwi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Suasne uspane Jesústa Caifáspa yalkis tainñara, Romano awa ɨninturakima. Kɨnmɨztu akwa, Judío awane ɨnintukin napshiarachi, Pascua pishta taiznapain akwa. Judío awachi yalta napparane, uspane Dios iztakin sɨnamchi namninamtu minñara. Suasne Judío awane Pascua pishta izasachi, Pascua kumira kuasachi. Impa. ");
INSERT INTO kwi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Katmizna Pilatone Judío awakasa paran puz kit kaiznara: —¿Chitma an ampura kwail kirɨt kizamtuas? ");
INSERT INTO kwi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Uspane sɨnkaara: —Us kwail kitchine, aune nua chɨhkasachimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatone kaiznara: —Umin ussa mɨltain. U ɨnimkasain paiña kwail kirɨt aizpa antain. Judío awane sɨnkaara: —Aune, Judío awane, mɨnminkas ininsachimakpas. Romano awain mamazta ininshina. ");
INSERT INTO kwi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesúsne ñamin miza tuntu inasa kiznara. Sunkana us kaizta aizpa kirɨt. ");
INSERT INTO kwi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatone paiña ɨnintukin mamasa nap kit Jesústa tainna ɨnin kit ussa mɨmara: —¿Nune Judío awawa ɨninmikakish? kizta. ");
INSERT INTO kwi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesúsne sɨnkara: —¿Upminpain sun mɨmamtukish? ¿Mamaz mɨmanapa ɨninma? ");
INSERT INTO kwi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatone sɨnkara: —Nane Judío awa chi ish. Up Judío awakas pariyawa ɨnintuzkas nawa chɨhkat. Nune ¿Chima kwail kira? ");
INSERT INTO kwi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesúsne sɨnkara: —Nane an suras ɨnintuzkana ɨnintuchish. Nane an suras ɨninna atchish. Na an suras aratne, ap kiwaintuzne na akwa waya kiashina, Judío awa ɨninturuz nawa chɨhkamanpa. Sunkana nane an suras ɨninna atchish. ");
INSERT INTO kwi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Suasne Pilatone mɨmara: —Suasne ¿Nune ɨninmikakish? Jesúsne sɨnkara: —Nane ɨninmika ish. Nu kaizta aizpa watcha i. Nane an sura arau, watcha pit kamtana. Watcha pit piankamshimtumikane na kaizta aizpa mɨmtu. ");
INSERT INTO kwi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatone kaizta: —Sun watcha pit ¿Chi mai? Mɨnminkas watcha pit piankamsachi. Ussa sun mɨmarawane, Pilatone mamasa Judío awakasa paran puz kit kaiznara: —Uskasa paratpane, nane us kwail kirɨt kizsachish. ");
INSERT INTO kwi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pailta Pascua pishta taizkane, une nawa paikuamtu, na maza kajchira sɨptɨtmikasha chɨhtnapa. Katmizna, ¿nane u akwa u Judío awawa mikwara chɨhtshinasa? ");
INSERT INTO kwi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Suasne uspane akkwan piji tɨnta kwianara: —¡Anne chɨhtmun! Aune paikwashimtumakpas, Barrabásta chɨhtnapa. An Barrabásne walkummika azi. ");
INSERT INTO kwi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Suasne Pilatone Jesústa aim ilnapa ɨninta. ");
INSERT INTO kwi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Suldaru awane pu tɨt ippat kit Jesúspa kɨzpukin sɨnnat kit ishtam kwaksham kwaninta. ");
INSERT INTO kwi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Uspane Jesús tura kasha aat kit ussa ishnat kit kaizara: —Wat kɨntɨre. Nune Judío awawa ɨninmika i, kizara. Uspane paiña matsɨhkin kuzara chihtɨkasa. ");
INSERT INTO kwi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatone paiña yalkis mamasa pianamal Judío awa tukin puz kit kaiznara: —Mɨzhain. Mama suldaruruzne Jesústa ayuktas ukkanazi. Nane ussa u iztakin ukkamtu, u us chinkas kwail kitchira piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús Pilato wakinkas, awaruzpa wakinkas pianarawane, uspane Jesús kɨzpura pu tɨt sɨnat kit Jesústa ishtam kwaksham kwaninta. Pilatone usparuza kaiznara: —An ampura iztain. ");
INSERT INTO kwi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pariya ɨnintuzkas Dios katsa yalkin kiwaintuzkas ussa izarawane, ka kwianamɨzta: —Ussa kurishta patpiantari, kizara. Pilatone kaiznara: —Umin ussa pizat kit kurishta patpiantain. Nane us chinkas kwail kitchi kaiznamtus. ");
INSERT INTO kwi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío awa ɨninturuzne ussa sɨnkaara: —Aune Moisés ɨninta aizpa mɨjmakpas. Sun ɨnimkin parɨt aizpa akwa, usne irawa, “nane Dios painkul ish” kiztu akwa. Us Dios painkul chi akwa, usne kwail kiz kit irawa. ");
INSERT INTO kwi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sun mɨrawane, Pilatone an akkwan ishkwat. ");
INSERT INTO kwi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mamasa paiña ɨnintukin nap kit Jesústa mɨmara: —¿Nune mɨntas mas? Jesúsne chinkas sɨnkarachi. ");
INSERT INTO kwi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Katmizna Pilatone ussa kaizta: —¿Nawa sɨnkamtuchikish? Mɨzha. Nane nua chɨhtninshinas. Nakas nua tɨra patpianninshinas. ");
INSERT INTO kwi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesúsne sɨnkara: —Dios nua ɨninapa naratchine, nune nawa kwail kishinachi. Katmizna nawa chɨhkatmikane nukin anza kwailmika i. ");
INSERT INTO kwi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sun urain Pilato Jesústa chɨhtshimtukas, Judío awa ɨninturuzne ka kwiannamɨzta: —An ampura chɨhttane, nune, Roma pɨpulura katsa mikwawa izmumika chi i. An Jesús muntɨtmika mikwa namshimtune, nune Roma pɨpulura katsa ɨninmikawa izmumika chi i. ");
INSERT INTO kwi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sun pit mɨrawane, Pilatone ɨt kit paiña ɨnimkin uzta. Usne paiña ɨnimkin Jesústa kana ɨnpa ɨninta. An ɨnimne “sak uk” muntɨt. Judío awa pitta Gabata muntɨt. ");
INSERT INTO kwi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paizka payu azi. Mamaz payura Pascua pishta taiztu. Pilatone Judío awaruza kaiznara: —U mikwara iztain. Ussa sappamtuchikas, an kuntɨtmikane u mikwa i. ");
INSERT INTO kwi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Uspane ka kwianara: —Inapa, inapa. Tɨra patpiantain. Pilatone mɨmanara: —¿U mikwara tɨra patpianshinasa? Pariyawa ɨnintuzne sɨnkaara: —Aune mamaz mikwasha mɨshimtuchimakpas. Au mikwane Cesar i. ");
INSERT INTO kwi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Suasne Pilato Jesústa chɨhkatpane, Roma suldaruruzne ussa mɨlara, kurishta patpiannapa. ");
INSERT INTO kwi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesúsne Jerusalén pɨpulukis puz kit kurish mut kit ɨzara nura. An ɨzane “KƗZPU SƗH” muntɨt. (Judíowa pitne Gólgota muntɨt.) ");
INSERT INTO kwi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Suane uspane ussa kurishta patpianara. Mamaz paas awara Jesúspa pamals kurishta patpianara. ");
INSERT INTO kwi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatone an pit panapa ɨninta, kurishta patnapa. An pitne ka parɨt: AN JESÚSNE NASARET PƗPULURAS AZI. USNE JUDÍO AWAWA ƗNINMIKA I. ");
INSERT INTO kwi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Uspane pɨpulu kashara Jesústa tɨra patpiantara. Katmizna akkwan Judío awane sun pit parɨt aizpa izara. Uspane sun pitta Judío awa pitparakas, Roma awa pitparakas, Griego awa pitparakas parɨt. ");
INSERT INTO kwi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Katmizna Judío pariyawa ɨnintuzne Pilatora kaizara: —“Judío awawa ɨninmika” pamun. Usne “nane Judío awawa mikwa ish kizta,” ka pari. ");
INSERT INTO kwi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatone sɨnkanara: —Na parɨt aizpa nukkultui. ");
INSERT INTO kwi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesústa tɨra patpianarawane, suldaruruzne paiña pĩn sappat kit ampara suldaruruzpain naiyara. Uspane paiña kwaksham paimpa watsara. Kwakshamne sɨptachin kwara. ");
INSERT INTO kwi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Suldaruruzne usparuzpain kaizara: —Sun puttɨt pĩn pihshpiztuchimakpas. Salna ɨzhain, mazain sun pĩn kana kinpa. Sun kitpane, Dios pitta parɨt aizpa ka kirɨt: “Ap pĩn usparuzpain naiyara. Salara ap puttɨt pĩn kana kinpa.” Suldaruruzne sunkana kiara. ");
INSERT INTO kwi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesúspa akkuhshkas paiña aizpihshkas Jesús tɨra patpiantukin kunara. Maríakas, Cleofaspa ashampa, Maríakas Magdalena pɨpuluras tuazi. ");
INSERT INTO kwi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesúsne paiña akkuhshta izta. Nane, paiña kammumikane, kasha kun kirau. Usne nawa pashira. Suasne Jesúsne paiña akkuhshta kaizta: —Mɨzha. Anne up painkulkana i. ");
INSERT INTO kwi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Suasne Jesúsne nawa kaizta: —Mɨzha. An ashampane up akkuhshkana i. Sun urain nane ussa mɨlta ap yaltakima. ");
INSERT INTO kwi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sun kitpane, Jesúsne sun urain wan Dios ussa kinpa ɨninta aizpa pailtɨt piankamta. Suasne usne ka kaizta: —Kwazi kiltus, kizta, Dios pɨnkɨhta parɨt aizpa kinpa. ");
INSERT INTO kwi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Makin waz uzazi tish vinokasa. Suldaruruzne aks tɨ piz kit tɨra pimpuh puntakimain ippara. Pimpuhta tish vino paran kit Jesúspa pitta panak kit tukninara. ");
INSERT INTO kwi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesúsne vino kwaiz kit kaizta: —Mane na wan kishimtu aizpa kirɨt me. Kɨzpu waintawane, ira. ");
INSERT INTO kwi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Maza payu we, Pascua pishta izna. Pascua pishtane Judío awawa katsa pishta azi. Katmizna Judío awaruzne kurishta irɨttuza kihshninshiara, kwaizkulmu payura kurishta tuamanpa. Katmizna uspane Pilatora paikuara, mazara ɨninna usparuzpa ñampɨra tɨkasa kalpianapa, an ãĩn ianapa, tas tain kihshanapa. ");
INSERT INTO kwi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Suasne suldaruruzne paas Jesúskasa tɨra patpiantaruza aat kit usparuzpa ñampɨra kalpianara. ");
INSERT INTO kwi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesústa ɨakane, suldaruruzne ussa irɨtta izara. Katmizna paiña ñampɨra kalpianarachi. ");
INSERT INTO kwi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Maza suldaruruztas Jesúspa kuishtiyaskin aks kwiz tɨkasa para. Sun urain aimpikas kwazikas kuishtiyaskis puzta. ");
INSERT INTO kwi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nane, kainammmikane, wan izta aizpa parɨt ish. Na kaizta aizpa watcha i, ukas nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sun kiarɨt, Dios pɨnkɨhta parɨt aizpa kirɨnpa. Ka parɨt: “Paiña sɨh kalamanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mamaz pajte Dios pitta ka parɨt: “Uspane kuishtiyaskin aks kwiz tɨkasa parɨtmikasha izanazi.” ");
INSERT INTO kwi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sun kitpane, Joséne, Arimatea pɨpuluras atmikane, Pilatora paikwara, Jesústa mu kihshat kit kamnapa. Joséne, Jesúspa kammumika azi. Judío awa ɨninturuzpa ishkumtu akwa, usne ussa puinta puintɨtkanain kanpara. Pilatone Joséra ɨninta, Jesústa mu kihshanapa. Joséne ɨt kit mamazkasa Jesústa muara. ");
INSERT INTO kwi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemokas, an ñamin maza amta Jesústa paran ɨtmikakas, treinta kilowa piam pihshkasa ara. Mirrakas áloekas karat. ");
INSERT INTO kwi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Suasne Josékas Nicodemokas Jesústa mut kit pĩnkasa wat piam narɨt pihshkasa ippailta. Judío awane sunkanain irɨttuza watsat kamanapa kiamɨzta. ");
INSERT INTO kwi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesústa kurishta patpiantɨt tukin, warɨt su kashakin azi. An sukinne masas uk kul sarɨt. Sun uk kulta mɨnminkas iramikara tarachi. Sɨnam. ");
INSERT INTO kwi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uspane Jesústa sun kasha uk kulta nukpailta, Judío awawa kwaizkulmu payura taiznapain akwa. ");
INSERT INTO kwi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Maríane, Magdalena pɨpuluras atmikane, Domingo payura, tɨlkwilmin kamtɨtkin ɨt. Sɨptɨt ukne paimpa tu izta. Jesústa iztachi. ");
INSERT INTO kwi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Suasne usne pɨpulura ãĩn kailmɨzta, Simón Pedrorakas mamaz kammumikashakas, Jesús kwisha pashitmikasha, kainana. Usparuza kaiznara: —Mɨnpazha au Anpatta kamtɨt kultas mɨlta. Mɨntama ussa kamtamakka pianchimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Katmizna Pedrokas mamaz kammumikakas pɨpuluras puzpail kit kamkin ɨilta. ");
INSERT INTO kwi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Paasas ãĩn ɨiltakas, mamazne Pedrokin an ãĩn ɨt kit an ñancha kamtɨtkin pianara. ");
INSERT INTO kwi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Usne sumain kit ayukta izta. Iptɨt pĩn attishtain izta, kulta naptachin. ");
INSERT INTO kwi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kwiztane Simón Pedrone at kit kulta masain napta. Uskas iptɨt pĩn izta. ");
INSERT INTO kwi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mamaz pĩnkas, Jesús kɨzpu iptɨt pĩnkas izta. Mamaz pĩnkasain tuchi. Paimpa iptɨt tu izta. ");
INSERT INTO kwi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Suasne mamaz kammumikane, an ñancha atmikane, nap kit sun kirɨt aizpa iz kit Jesús irɨttas kuhsta nɨjkulta. ");
INSERT INTO kwi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Makima uspane Dios pɨnkɨhta parɨt aizpa piankamarachi. Irɨttas kakultu piankamarachi. ");
INSERT INTO kwi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Katmizna kwiztane kammuruzne uspawa yalta kailpailta. ");
INSERT INTO kwi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Suasne María uk kulkin kailta. Sunkana Maríane pianamal uk kul kamtɨtkin kun kit azta. Aztuasmin, usne ayukta izna wain ");
INSERT INTO kwi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kit paas ángelta putchã pĩn kwa izta. Uspane Jesús tuatkin uzpailta. Mazane kɨzpumal uzta. Mamazne mittɨmal uzta. ");
INSERT INTO kwi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ángeltuzne ussa mɨmara: —Ashampa, ¿Chitma aztus? Usne kaiznara: —Aztus, mɨnpazharuz ap Anpatta muarɨt akwa. Nane Jesús irɨt mɨnta taara pianchish. ");
INSERT INTO kwi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sun kiztawane, usne kɨzpu izpujiat kit sua Jesústa izta, ussa piankamtuchin. ");
INSERT INTO kwi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesúsne ussa mɨmara: —Ashampa, ¿Chitma aztus? ¿Mɨnama saimtus? Usne warɨt su izmumika azi min kit ussa kaizta: —Anpat, nu ussa murɨtne, Jesús irɨtta mɨnta taarɨt kainazha, na ussa sait kit muna. ");
INSERT INTO kwi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Suasne Jesúsne kaizta: —¡María! Jesús kaizta aizpa mɨrawane, usne ussa piankam kit puij kit ussa Judío pitkasa kaizta: —¡Rabuni! (Sun pitta “kamtam” kizta.) ");
INSERT INTO kwi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesúsne ussa kaizta: —Nawa pizmun. Ap Taittakasa wanmakna ɨtchish mama. Ɨt kit ap kammuruza “ap Taitta tura numtus” kaiztain. Usne u Taittakas i. Usne ap Dioskas u Dioskas i. ");
INSERT INTO kwi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Suasne Maríane, Magdalena pɨpuluras atmikane, ɨt kit kammuruza “Anpatta iztau” kiz kainanara. Usne Jesús ussa kaiztɨt aizpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sun payuin tɨlkwil pakane, domingo payu azi. Judío awa ɨninturuzpa ishkuarɨt akwa, kammuruzne pɨjta sɨppat kit wanmakkara. Wan pɨjta sɨpparɨtkas, Jesúsne yalta nap kit kammuruzpa paizkakin kun kit kakishapu kiz kit kaiznara: —¡Watmin uztain! ");
INSERT INTO kwi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Sun kiztawane, usne usparuza paiña chihtɨkas paiña pɨjarakas annara. Jesústa izarawane, uspane watsal kulara. ");
INSERT INTO kwi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Suasne Jesúsne usparuza mamasa kaiznara: —¡Watmin uztain! Ap Taittane an sura nawa ɨninta. Sunkanain nakas uruza ɨninnanash. ");
INSERT INTO kwi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Usne usparuza izpanat kit kaiznara: —Mane Diospa Sɨnam Izpulta saptain, uruza kiwainnanapa, ukasa parejuin chaanapa. ");
INSERT INTO kwi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Katmizna Dios kwail kirɨtmikasha wat kultune, ukas ussa sunkanain wat kultawa. Us kwail kirɨt aizpa karɨnazi. Dios kwail kirɨtmikasha wat kultukine, ukas ussa sunkanain wat kulmanazi. ");
INSERT INTO kwi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomásne, maza doceras kammuruzne, gemelokas muntɨt. An ñamin Jesús akane, Tomásne usparuzkasa tuchi. ");
INSERT INTO kwi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kwiztane mamaz kammuruzne ussa kaizara: —Aune Anpatta iztamakpas. Sunkana Tomásne sɨnkanara: —Ussa iztukine, paiña chihtɨ iztukine, irukasa tɨttɨt namtɨt iztukine, nɨjkulmanash. Paiña chihtɨ tɨttɨt namtɨtkin ap tɨppukasa parakine, paiña pɨjakinkas ap chihtɨkasa parakine, nɨjkulmanash. ");
INSERT INTO kwi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho payu pailtawane, kammuruzne mamasa maza yalta wanmakkara. Sun payuin Tomáskas usparuzkasa wanmakta. Wan pɨjta sɨptɨtkas, Jesúsne nap kit usparuzpa paizkakin kun kit kakishapu kaiz kit kaiznara: —Watmin uztain. ");
INSERT INTO kwi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Suasne Tomásta kaizta: —Apain at kit up tɨppukasa, ap chihtɨra paat kit izti. Ap pɨjara up chihtɨkasa paari. Nune nɨjkulshimtuchi. Mane nɨjkulcha. ");
INSERT INTO kwi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Suasne Tomásne kaizta: —Nune ap Anpatkas ap Dioskas i. ");
INSERT INTO kwi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesúsne ussa kaizta: —Nawa iztu akwa, nɨjkultɨmtu. Nawa iztachikas, nawa nɨjkultumikane watsal kulnazi. ");
INSERT INTO kwi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesúsne paiña kammuruzpa iztakin an akwan iztasparɨt kal kirɨt. Wan iztasparɨt kal sun pɨnkɨhta parachi. ");
INSERT INTO kwi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sunkana sunpawa iztasparɨt kal pɨnkɨhta parɨt, ukas Jesús Dios narɨtmika i nɨjkulanapa, u Jesús Dios painkul i nɨjkulanapa, ussa nɨjkulturuz pailta payukima uzanapa. ");
INSERT INTO kwi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Akkwan payuchin pailkane, Jesúsne mamasa paiña kammuruza Tiberias pimamin izpannara. Sunkana kirɨt: ");
INSERT INTO kwi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedrokas Tomáskas, Gemelo muntɨtmika, Natanaelkas, Caná pɨpuluras Galilea suras uzatmika, Zebedeowa painkultuzkas, an paas Jesúspa kammuruzkas wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedrone kaiznara: —Nane pishkaru sulna ɨrɨmtus. Uspane ussa sɨnkaara: —Aukas nukasa pishkaru sulna ɨrɨmtumakpas. Uspane katsa kanuara ɨnpa waara. Sun amtane chinkas sularachi. ");
INSERT INTO kwi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kɨnmɨzkane, Jesúsne pimarain izpan kit kunta. Sunkana paiña kammuruzne Jesústa piankamarachi. ");
INSERT INTO kwi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesúsne mɨmanara: —Izmuruz. ¿Pishkaru sultakiwas? Uspane sɨnkaara: —Chinkas sultachimakpas. ");
INSERT INTO kwi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesúsne kaiznara: —An ɨmmu kanuawa numal kiaintain, pishkaru sulnapa. Sulmu kiaintawane, uspane sulmu ukkaasachi, akkwan pishkaru wa akwa. ");
INSERT INTO kwi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Suasne maza kammumikane, Jesús kwisha pashitmikane, Pedrora kaizta: —An pimamin kunmikane Anpat i. Anpat i mɨrawane, pantalón tukukasain kuh akwa, Simón Pedrone paiña kwaksham kwat kit pira tizainta. ");
INSERT INTO kwi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mamaz kammuruzne cincuenta sa pi ksukis purazi. Sulmu pishkaru punta akwa, uspane tainñat kit kanuawara pi ksurakima pɨlapta. ");
INSERT INTO kwi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pilta kihsharawane, uspane ĩn usaptɨt izara. Sun ĩnkin pishkaru iltɨt tuazi. Pankas sua tuazi. ");
INSERT INTO kwi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesúsne kaiznara: —Mamin sulta pishkaruruz kararain. ");
INSERT INTO kwi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedrone kanuara wat kit sulmu puntɨt katsa pishkarukasa pi ksurakima tainta. Ciento cincuenta y tres katsa pishkaru wiantɨtkas, sulmune pihsharachi. ");
INSERT INTO kwi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesúsne kaiznara: —Aat kit kwanarain. Mɨnminkas kammuruzne “mɨnmaka” mɨmashitchi, us Anpat i pian akwa. ");
INSERT INTO kwi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Suasne Jesúsne kasha at kit pan piz kit usparuza nailnara. Usne pishkarukasa kawarain nailnara. ");
INSERT INTO kwi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Irɨttas kuhstawane, Jesúsne mamasa paiña kammuruza ussa izpannara. Makasa kutña pijikima izpannara. ");
INSERT INTO kwi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kuarawane, Jesúsne Simón Pedrora ka mɨmara: —Simón, Juanpa painkul, mɨzha. An kammuruzne nawa pashiamtu. ¿Nune an kammuruzkin nawa anza pashimtukish? Pedrone ussa sɨnkara: —Watcha Anpat. Nune na nua pashimtura pian. Jesúsne kaizta: —Nawa nɨjkulamturuza iznari. Uspane ap pɨrikukana mai. ");
INSERT INTO kwi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesúsne mamasa ussa mɨmara: —Simón, Juanpa painkul, mɨzha. ¿Nawa pashimtukish? Pedrone sɨnkara: —Watcha, Anpat. Nune na nua pashimtura pian. Jesús kaizta: —Nawa nɨjkulamturuza iznari. Uspane ap pɨrikukana mai. ");
INSERT INTO kwi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesúsne kutña pijikima ussa mɨmara: —Simón, Juanpa painkul, mɨzha. ¿Nawa pashimtukish? Pedrone tayalmɨzta, Jesús kutña pijikima “nawa pashimtukish” mɨmara akwa. Suasne sɨnkara: —Anpat, nune wan chiwal pian. Nune na nua pashimtura pian. Jesúsne kaizta: —Nawa nɨjkulamturuza iznari. Uspane ap pɨrikukana mai. ");
INSERT INTO kwi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Watcha nua kaiztus. Musittu asmin, nune up kwakshammin kwat kit nu ɨshimtura ɨt. Ɨlapa parɨkane, nune up sail tɨs panazi. Suasne mamazne nua pĩn kwanazi. Mamazne nua nu ɨshimtuchira mɨlnazi. ");
INSERT INTO kwi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sun pit paramtuasmin, Jesúsne Pedro miza imtu kainara. Pedro irɨmtukas, awane “Dios kwisha wari” kizanazi. Sun kiztawane, Pedrora kaizta: —¡Nawa kanpazha! ");
INSERT INTO kwi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedrone puij kit Jesústa kwisha pashitmikasha izta. Usne Jesúspa kwizpa kanpara. Ñamin kammuruz Pascua pishta kuamtuasmin, usne Jesúspa mamin kumira kwan uz kit “Anpat, ¿mɨnma nua chɨhkarɨnazi?” mɨmara. ");
INSERT INTO kwi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nawa iztawane, Pedrone Jesústa mɨmara: —Anpat, sunmikane ¿Chima kishinasa? ");
INSERT INTO kwi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesúsne ussa sɨnkara: —Us na kailtɨmtukima uztukas, nune na nua kaiztu aizpa mɨt kit kitpa. Nu nawa kanpazha. ");
INSERT INTO kwi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Katmizna wan kammuruzne an kammumika imanazi minñara. Jesúsne imanazi kiztachi. Ka kizta: “Us na kailtɨmtukima uztukas, nune na nua kaiztu aizpa mɨt kit kitpa.” ");
INSERT INTO kwi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","An kammumikane sun kirɨt aizpa kainat kit parɨt. Us paramtu aizpa watcha i pianmakpas. ");
INSERT INTO kwi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesúsne an akwan iztasparɨt kal kirɨt. Jesús wan kirɨt aizpa pɨnkɨhta parɨtne, mɨnminkas an sura wan pɨnkɨh pana pailsachi. Pailtɨt i.");
INSERT INTO kwi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nane Lucas mun ish. Nua, Teófilora, kakishapu kiz kit an pɨnkɨh pamtus. An ñancha an pɨnkɨhta Jesús wan kit aizpakas us kamtanara aizpakas parau, Jesús chiyura numtu payukima. ");
INSERT INTO kwi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nurachasmin, usne paiña Sɨnam Izpulkasa paiña narɨt ɨnintaruza kamtaninnara, us kamtara aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Irɨttas kakultawane, Jesúsne usparuza cuarenta payurakima, akkwan pijikima, izpannara, us uztu piankamanapa. Akkwan piji usparuza izpan kit Dios awaruza ɨninnashimtu kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mama uspakasa tuasmin, Jesúsne ɨninnat kit kaiznara: —Jerusalén pɨpuluras ɨman. Suain tɨriztain, ap Papihsh umɨza kin namtɨt aizpa sappanakima. Nane sunpa uruza kaiznara. ");
INSERT INTO kwi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Watcha Juanne uruza kwazikasain munnanara. Akkwan payuchin kawarain Sɨnam Izpulne uruza piznanazi. ");
INSERT INTO kwi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Suasne kanpamtuzne Jesústa ka akkwan piji mɨmaara: —Au Anpat, ¿An payura au Israel awara kiwainanakish, au sukin ɨninna? mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Usne usparuza ka sɨnkanaara: —Uruzne an payu piankamamanazi. Au Taittain an payu nanarɨt, us kishit aizpa kin. ");
INSERT INTO kwi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Diosne paiña Sɨnam Izpulta ɨninnazi, u ussa sappanapa. Usne uruza tɨnta kiwainnanazi, na akwa kamtananapa. Suasne une Jerusalén pɨpulurakas wan Judea surakas Samaria surakas wan attish surakas ɨanazi, na akwa kainana. ");
INSERT INTO kwi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesús sun kiztawane, awa izamtuasmin, Diosne ussa chiyura nuninta. Wanish at kit ussa pal kit sɨpta. Ussa an izarachi. ");
INSERT INTO kwi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús numtuasmin, uspane chiyura kwashpa izakkaara. Suasne paas ángelne putchã kamisha kwa usparuza at kit uspakasa kunpailta. ");
INSERT INTO kwi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Usparuza kaiznara: —Galilea suras awa, ¿Chikishmaka chiyura izakpuspas? An Jesúsmin uruztas nurɨtmikain watcha mamasa sunkanain mamaz payura kailnazi. ");
INSERT INTO kwi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Suasne uspane Olivos ɨzakis kihshat kit Jerusalén pɨpulura kaiyarɨt. Moisés usparuza ɨninta aizpa kiashit akwa, uspane kwaizkulmu payura maza kilómetrokima kashain ɨshiara. ");
INSERT INTO kwi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pɨpulukin piannatpane, kwashtɨt yal pitmura nuarɨt. Pedrokas Juankas Santiagokas Andréskas Felipekas Tomáskas Bartolomékas Mateokas Santiago Alfeowa painkulkas Simón Celote munmikakas Judas Santiagowa aimpihshkas usparuzpain pura. ");
INSERT INTO kwi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wan wanmakkara Jesúspa aimpihshkasa paiña akkuhsh, Maríakasa mamaz ashamparuzkasa, Diosta payu aizpa paikuana. ");
INSERT INTO kwi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sun payune Pedrone Cristora nɨjkulturuz paizkakin nil satkunta. Maza cien veintekasa awa purakin. Pedrone ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Cristora piantuz, mɨzhain. Diosne chiwazha paiña pɨnkɨhta panintɨt aizpa ka kirɨt. Sɨnam Izpulne Davidta Judaspa kwinta kininta. Usne an ñancha Judas kit aizpa kwinta kira. Usne Jesústa annara, awa ussa pizanapa. ");
INSERT INTO kwi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Usne au izmumika azi. Aukasa kal kimika azi. ");
INSERT INTO kwi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kwiztane kwail kit akwa, Judasne pial sap kit sun pialkasa su paira. Usne kwashtas kɨzpuwara taiz kit irɨt. Paiña pɨja puzpian kit pɨrɨt puzta. ");
INSERT INTO kwi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalénkin uztuz sun piankamarawane, uspane sun su i Acéldama munara. Usparuzpa pitne ‘aimpi su’ mun. ");
INSERT INTO kwi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sun wan kanta pɨnkɨhta ka parɨt: ‘Paiña kwairɨt yalta suane mɨnminkas uzmuchi.’ Ankas ka parɨt: ‘Mamazne paiña kal kitpa.’ ");
INSERT INTO kwi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Katmizna aune mɨnpazha aukasa wanmakmumikasha nanarawash. Wanmakmumikane awara ka kizshina: ‘Au Anpat Jesús irɨttas kakulta.’ Mama Jesús wan payu aukasa uzasmin, uskas aukasa wanmakta. Juan munnanakima, Jesús kakulnakima, usne aukasa chara.” ");
INSERT INTO kwi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Suasne Dios pit piantuzne, wanmakmuruzne, paas awara nanara. Mazane paas mun muntɨt: José Barsabáskas Justokas. Mamazne Matías muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Suasne uspane uspa Anpatta ka paikuara: “Nune miza wan awa minñamtu pian. Katmizna aumɨza an paastas nu narɨtmikasha izninchain, ");
INSERT INTO kwi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mamaz ɨninmikawa kal kinpa. Judasne sun kal chɨhkat kit us kwail akwa paiña miwara ɨt kit naizta.” ");
INSERT INTO kwi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Suasne uspane awa wanmakkarawane, wankis an watmikasha naara. Sunkanain uspane Matíasta naat kit once ɨnintaruzkasa wianara. ");
INSERT INTO kwi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sun Pentacostés pishta payu taizka, wan Cristora piantuzne mazakwain wanmakkarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Azain chiwazha tɨnta az kit chiyuras taizta. Tɨnta inkwakanain pat kit wan yal ayukmal napta, awa uzkularɨtkin. ");
INSERT INTO kwi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Suasne uspane tɨ ĩn aiztukanain izara. Sun ĩn paimpa paimpain naiyarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sun akwa Sɨnam Izpulne wan awaruza piznara. Suasne uspane mamaz kamtachi pit kwinta kiamɨzta. Izpulne usparuza paraninnara. ");
INSERT INTO kwi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sun payura mamaz suras Judío awaruzne Jerusalén pɨpulura pianara, Diosta wakpuj wain kit Diosta paikwan. Uspane wan suras aara. ");
INSERT INTO kwi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sun aztu mɨarawane, akkwan awane wanmakkat kit iztaspaarɨt. Ɨnintaruz kwinta kiamtuasmin, pakaish pakaish paiña pitmin mɨara. ");
INSERT INTO kwi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Uspane ishkuat kit iztaspaat kit usparuzpain ka mɨmaara: —¿An paramtuzne Galilea suras awa ki? ");
INSERT INTO kwi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Mizamakai? Mane auruzpain usparuza mɨpuspas. Uspane au pit pashpas kawira aizpa paramtu. ");
INSERT INTO kwi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Apane awa purai: Partia suraskas Media suraskas Elam suraskas Mesopotamia suraskas Judea suraskas Capadocia suraskas Ponto suraskas Asia suraskas ");
INSERT INTO kwi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia suraskas Panfilia suraskas Egipto suraskas Libia suraskas kashara Cirene pɨpulura Roma pɨpuluras awakas apain pura. ");
INSERT INTO kwi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mɨnpazha usparuztas Judío awa azi. Mamaztuzne Judío awa namarɨt. An awakas Creta suraskas Arabia suraskas purai. Uspa paraka, aune wan Diospa watsal kal kirɨt aizpa au pitmin mɨpuspas, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wanne iztaspaat kit chi kizmanamara. Usparuzpain mɨmaamɨzta: —¿Chima kizshina sunne? ");
INSERT INTO kwi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mamaztuzne usparuza sun akwa ishanat kit ka kaizara: —Uspane chappi kuat kit piarai, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Suasne Pedrone mamaz once ɨnintaruzkasa nil satkun kit tɨnta parat kit ka paiña Judío kwaltuza paranamɨzta: “Na kaiztu aizpa mɨzhain. Judío awaruzkas, wan Jerusalén pɨpulura uztuzkas, nawa wat mɨrain, piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Uspane pirachimai, umin minñamtukanain. Mama tɨlawain i. Nueve urain i. ");
INSERT INTO kwi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Joelne, Dios pit kainammmikane, an ñancha sun kit aizpa ka kaizta: ");
INSERT INTO kwi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Diosne sun minpa payura kaiztu. Nane ap Izpul wan awara nail kit mɨlananash. U painkulkas pashukas nawa kwinta kianazi. U musitturuzkas u ɨlaparuzkas kainkizpaanazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sun minpa payura nane ap Izpul, ap kiwainmuruza ashamparuzakas ampuruzakas ɨninnat kit mɨlananash. Uspane nawa kwinta kianazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nane kwashpa chiyumal chiwazha watsal kal kinash. Nane uruza an izninnanash, piankamanapa. Wan pailtɨmtuasmin, nane pilkin aimpikas ĩnkas ishkas izninnanash. ");
INSERT INTO kwi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pãnne tɨl parɨnazi. Palapchane kwanam tɨlkwil aimpikanain namtɨnazi. An kwiztane an watsal payu taizkane, au Anpatne paiña kal kimɨznazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mɨnpazha Anpatta paikumtune, usne usparuza watsat mɨlnanazi, ĩnta ɨamanpa.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedrone sun paiña Judío kwaltuza kaizta: “Israel awa, na kaiztu aizpa mɨrain: Diosne Jesústa, Nazarettas munmikasha nat kit uruza ɨninnara, akkwan tuntu iztasparɨt kal u iztakin kinpa. ");
INSERT INTO kwi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Diosmin Jesústa uruza chɨhkatchasmin, usne chiwazha kishimtu aizpa an ñancha pian. Suasne une kwail awaruz ussa ɨninnat kit kurishta iru patpian piantaninta. ");
INSERT INTO kwi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sunkana Diosne ussa irɨttas kakulninta. Jesúsne irɨtpa izpul ɨmtura nukkulsachi, kajchira sɨptɨtmikakana. ");
INSERT INTO kwi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidkas Jesúspa kwinta kit kit ka kaizta: ‘Nane ap Anpatta na iztukin iztau. Usne ap makin uz, awa nawa ishkumanpa. ");
INSERT INTO kwi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Katmizna ap kaijchu watsal ish. Mane watsal pit pararau ap pitkasa. Katmizna mane nakas Diosta tɨriz kit wat kwaizkulnash. ");
INSERT INTO kwi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nune, ap Diosne, ap izpulta irɨttukin kwaimanazi. Nune nawa, up kiwainmumikasha, pashit kit ap ñara pɨtninmanazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nune nawa chiyura num mi kamtara, pailta payu uznapa. Nune nakasa uz, na wat tuanpa,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Cristora piantuz mintain. Nane uruza Davidpa au irɨt Taittawa, nil kwinta kitpaish. Us irawane, uspane ussa kamara. Us kamkin aukasa kashain tu. ");
INSERT INTO kwi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David uzasmin, usne Diospa kainammmika azi. Uskas Dios sun kin namta aizpa pianazi. Diosne ussa ka sun kin namta: ‘Up kwalne, Cristo munmikane, sun su sapmɨlnazi, ɨnninna.’ ");
INSERT INTO kwi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sunkanain Davidne Dios kimtu aizpa ñamin piankam kit Cristo irɨttas kakulnazi ka kwinta kinara: ‘Paiña Izpulkas irɨttuz ɨmtura nukkulmanazi. Paiña ñakas pɨtmanazi.’ ");
INSERT INTO kwi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mane aune sunta izat kit uruza ka kizpuspas: ‘Diosne Jesústa irɨttas kakulninta.’ ");
INSERT INTO kwi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sunkana Diosne ussa nuninta, us uzkin ɨninna. Paiña papihshne, Diosne, paiña Sɨnam Izpul sun kin namtɨt aizpa Jesústa mɨlara. Jesúsne mamin sun wan izara aizpakas wan mɨara aizpakas uruza izninnara. ");
INSERT INTO kwi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Chiyura nurachikas, Davidmin Jesúspa ka kaizta: ‘Ap Diosne ap Anpatta kaizta: Na uzkin uzti, awa nua wat minñanapa. ");
INSERT INTO kwi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nane wan awaruza nu ɨnintu aizpakas, nu kaiztu aizpakas kininnanash.’ ");
INSERT INTO kwi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Une, Israel awane, mɨat kit piankamtain. Nane Jesúspa watcha kaiztus. Une Jesústa iru patpian piantaara. Diosne ussa Anpatkas Cristokas munta.” ");
INSERT INTO kwi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedro kaizta aizpa mɨarawane, uspane uspa kaijchura kwail minñat kit Pedrorakas mamaz ɨnintaruzakas mɨmara: —Ap Israel kwal ¿Chima kianapai? ");
INSERT INTO kwi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Suasne Pedrone sɨnkanara: —Kwail kiarɨt aizpa maiztain. Dios iztakin pailtara munnarain, Jesucristora kanpamtuz namanapa, Dios u kwail kiara aizpa mainninnanapa. Suas Diosne paiña Sɨnam Izpul uruza mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Diosne sun kin namnara aizpa uruzakas uspa pashparuzakas mamaz attishtas awaruzakas mɨlananazi. Au Anpatkas au Dioskas wan awa narɨttuzakas akwarɨttuzakas sun mɨlananazi. ");
INSERT INTO kwi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sunmin kwinta kinara. Pedrone an akkwan pitkasa kurunnat kit paranat kit kaiznara: —Diosta paikwarain, uruza watsat mɨlnanapa, sun kwail awakasa naizamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro kaizta aizpa mɨraruzne munna ɨarɨt. Sun payura kutña mil awane, Dios ɨnintamikasha, Cristora piantuzkasa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sun awaruzne ɨnintaruz kamtanara aizpa mɨamɨz kit sulmin uzat kit Diosta parejuin kwinta kiara. Uspane wanmakkara, usparuzpain kumira nail kit kwan. ");
INSERT INTO kwi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Wan awane iztaspaara, ɨnintaruz iztasparɨt kal kiara akwa. Uspane watsal iztasparɨt kal kiat kit akkwan awara kiwainara, Diosta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wan Cristora nɨjkulturuzne wanmakkat kit chiwazha mɨj aizpa wanta naiyara. ");
INSERT INTO kwi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Uspane chiwazha mɨj aizpa paininara, sun pial pailtara we mɨjtuza nailna. ");
INSERT INTO kwi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uspane pailta payura Diospa yalta wanmakkara. Usparuzpa wan yalta kumira nail kit kuat kit wat kulara. Uspane usparuza kwinñara. ");
INSERT INTO kwi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Uspane ka kaizara: “Diosne kwisha wari.” Wan awane Dios pit piantuzpa minñat kit kaizara: “An awane kwisha wari.” Au Anpat Jesús awaruza watsat mɨlnamtuasmin, usne Dios pit piantuza pailta payu wiannara, uspakasa wanmakkanapa. ");
INSERT INTO kwi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mamaz payura Pedrokas Juankas Diospa katsa yalta kutña urara sulmin nuilta, awa Diosta paikumkin. ");
INSERT INTO kwi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Maza ampune, mittɨ chasachimikane, ainkiasmin ka kawirɨt. Pailta payu suain tuara. Awane pailta payu ussa “watsal” muntɨt pɨjtakin miara, Diospa katsa yal napmukin chihtɨ an kit amtuza pial paikwan. ");
INSERT INTO kwi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedrokas Juankas Diospa katsa yalta nappailmɨzkane, mittɨ chasachimikane usparuza iznat kit chihtɨ an kit pial paikwanara. ");
INSERT INTO kwi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Suasne Pedrokas Juankas ussa izpailta. Pedrone ussa kaizta: —Aumɨza iznaka. ");
INSERT INTO kwi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sun ampune usparuza iznat kit chiwazha mɨlanazi minta. ");
INSERT INTO kwi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedrone ussa kaizta: —Nane pialkas mɨjchish. Urukas mɨjchish. Na mɨj aizpa mɨlanash. Jesucristone Nazaret pɨpuluras azi. Jesúsne nua kuhsninnazi, chanpa. ");
INSERT INTO kwi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Suasne Pedrone paiña chihtɨ numal piz kit kuhspaninta. Azain paiña pimpulkas mittɨ impulkas wat parɨt. ");
INSERT INTO kwi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Suasne mittɨ chasachimikane masain tizak kit mittɨkin kun kit chamɨzta. An kwiztane usne tizak kit uspakasa chat kit Dios katsa yalta naptɨt, “Dios kwisha wari” kizna. ");
INSERT INTO kwi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wan awane us chat kit Diosta kwisha wari kiztu izara. ");
INSERT INTO kwi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Uspane iztaspaat kit ishkuara, chasachimika chamtu akwa. Uspane ussa impara imparain piankamamɨzta. An chasachimikane an ñancha Diospa katsa yalkin “watsal” muntɨt pɨjtakin tuazi, chihtɨ an kit pial paikwan. ");
INSERT INTO kwi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chasachimika Pedrorakas Juantakas chɨhkashitchiasmin, wan awane iztaspaat kit Diospa katsa yalta azain ɨara, Salomón pɨjta muntɨtkin wanmakna. ");
INSERT INTO kwi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sun iztawane, Pedrone awara ka mɨmanara: “Au Israel awa kwal, ¿Chikishma iztaspapuspas? ¿Chikishma aumɨza kwisha izpuspas? Au paasne sun ampura au pit akwa wat panintachi. Aune ussa chanintachimakpas, au paasmin Diosta pian akwa. ");
INSERT INTO kwi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sunkanachi. Diosne sun kirɨt, awa ‘paiña painkul Jesús tɨnta namtɨre’ kizanapa. Abrahamkas Isaackas Jacobkas an Diosta wakpuj wainñat kit paikuara. An Diosne au an ñancha irɨtpa kwalpa Dios i. Une ussa Judío ɨnintuza chɨhkaara. Pilato Jesústa chɨhtshimtuasmin, une Jesústa pashitchimakpas kizara. ");
INSERT INTO kwi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Une Dios sɨnammikashakas nil uzmumikashakas chɨhashitchi. Une maza awara, piantatmikasha, chɨhshiara. ");
INSERT INTO kwi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sunkana une awaruza uzninmumikasha piantaara. Mane Diosne ussa irɨttas kakulninta. Aune uruza sun piankamninnat kit kainanamtumakpas. ");
INSERT INTO kwi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesústa nɨjkultɨt akwa, an ampune wat parɨt. Une ussa izat kit pian. Jesústa nɨjkultɨt akwa, an ampune kapal wat parɨt. Wan awane sun izamtu. ");
INSERT INTO kwi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Sunkana ap Israel awa izmuruz, mɨrain. Ukas u ɨninmuruzkas ussa piantaarɨtkas, une u kiarɨt aizpa wat piankamarachi. ");
INSERT INTO kwi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","An ñancha Diospa kainammturuzne ka kizara: ‘Jesucristone naiznatkin. Sunkanain Diosne sun kirɨt.’ ");
INSERT INTO kwi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Katmizna u kwail kimtu aizpa maiztain. Diostain kailtain, u kwail kiarɨt aizpa sɨnam kwizninnanpa. Sunkanane au Anpat Diosne chiyuras anazi, auruzpa izpulta kiwain kit kwaizkulninnapa. ");
INSERT INTO kwi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ankas Diosne Jesucristora an ñancha naramikasha uruza ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mane Jesucristone chiyura nukkultawa, Dios wan chiwalta masas namtanakima. An ñancha Dios pit kainammtuzne sunpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sunkana Moisésne au irɨt kwalta ka kaiznara: ‘U Anpat Diosne maza kainammmikasha, u kwaltas kawinintamikasha, nakana ɨninnazi. Wan us kaiznara aizpa mɨarawa. ");
INSERT INTO kwi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mɨnminkas an kainammmika kaizta aizpa mɨarakine, Diosne usparuza paiña kwaltas paimpa ɨninnanazi, ianapa.’ ");
INSERT INTO kwi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sunkana Samuel uzasmin, pailta kainammtuzkas kawarain an payu chi kirɨnsa kiz kit kainaara. ");
INSERT INTO kwi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Une kainammtuzpa painkul mai. Diosne kainammtuz akwa uruza kaiznara, an ñancha kin namtɨt aizpa sappanapa. U an ñancha kwal uzasmin, Diosne Abrahamta ka kizta: ‘Nane up kwaltuza kiwainanash, wan awa an sukin uztuza wat kianapa.’ ");
INSERT INTO kwi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Paiña painkulta kakulnintawane, Diosne ussa an ñancha ɨninta, uruza wat kiwainanapa. Usne uruza wat kinara, awa kwail kiarɨt aizpa maizanapa, wan awa kwail kiamanpa.” ");
INSERT INTO kwi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedrokas Juankas wan awaruza paranamtuasmin, Judío awawa pariyaruzkas Diospa katsa yal izmu policíakas Saduceo awaruzkas aara. ");
INSERT INTO kwi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uspane aliz kulaarɨt, uspa paas awaruza kamtanara akwa. Ka kaiznara: “Jesús irɨttas kakulta akwa, awakas irɨttas kakulanazi.” ");
INSERT INTO kwi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Katmizna uspane usparuza piznat kit nashtɨmtura kajchira sɨpnarɨt tɨlawakima. ");
INSERT INTO kwi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Akkwan awane, usparuztas sun pit mɨraruzne, mɨat kit wat nɨjkulara. Dios pit mɨraruza wiantawane, uspane cinco mil ampu panapain wianta. ");
INSERT INTO kwi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tɨlawara kwizta Judío awa ɨnintuzkas ɨlapa ɨnintuzkas Moisés kaizta aizpa kamtamtuzkas Jerusalén pɨpulura wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anásne, pariyaruza ɨninmikane, tuara. Uskas Caifáskasa Juankasa Alejandrokasa wan pariyawa ɨnintuz kwalkasa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Suasne uspane Pedrorakas Juantakas kanapa ɨninnat kit “Paizkakin kuntain” kiznara. Uspane ka mɨmanara: —Nune an chasachimikasha ¿Mizama kuhsninzi? ¿Mɨnma uruza sun kin ɨninzi? ");
INSERT INTO kwi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Suasne Diospa Sɨnam Izpul ussa kiwaintuasmin, Pedrone usparuza ka kiznara: —Judío awa ɨnintuzkas ɨlapa ɨnintuzkas mɨrain. ");
INSERT INTO kwi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","An ishtumikane kuhsak kit chamɨzta. Une aumɨza “¿Mɨnma ussa kuhsakninta?” kiz kit mɨmaamtu. ");
INSERT INTO kwi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Au paasne uruza, wan Israel awaruza, kainammpuspas, us wat parɨt kit miza tuntu kuhsaktɨt piankamanapa. Jesúsne, Nazaret pɨpuluras mikane, ussa kuhsakninta. Une ussain iru patpian kit piantaara. Diosne ussa irɨttas kakulninta. ");
INSERT INTO kwi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","An ñancha Diospa pit ka parɨt: “Jesúsne sam saktɨkana i. Une, yal samtuzkana, ussa kwayarɨt, ussa paashitchi akwa. U ussa paashitchikas, usne awaruza watsat mɨlnanashina.” ");
INSERT INTO kwi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mamaztuzne, mɨnminkas, aumɨza watsat mɨlnasachi. Diosne Jesústa ɨninta, aumɨza watsat mɨlnanapa. Apain mamazta ɨnintachi. ");
INSERT INTO kwi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wanmakmuruzne iztaspaarɨt, Pedrokas Juankas ishwatchin paranara akwa. Uspa paas kammu pianchi minñara. Kain awain minñara. Suasne uspane Jesúskasa chamtu nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","An ampu, kakultɨtmika, sua uspakasa pana izamtu akwa, uspane chinkas sɨnkaarachi. ");
INSERT INTO kwi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Suasne uspane uspa paasta wanmakmukis ɨninnat kit nukkulat kit usparuzpain kwinta kiara. ");
INSERT INTO kwi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ka usparuzpain kaizara: —¿Chima kianapai Pedrokasa Juankasa? Wan Jerusalén pɨpulu uztuzne sun kwisha iztasparɨt kal kirɨt pian. Aune sun kirɨt aizpa kwail i kaizsachimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mane usparuza kurunat kit tɨnta kainarawamakpas, an akkwan awa sun mɨamanpa, mɨnainkas Jesúspa kwinta kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Suasne Pedrorakas Juantakas akwanat kit uspa pit ɨninnat kit kaiznara: —Jesúspa kwinta kiaman; kamtanaman. ");
INSERT INTO kwi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedrokas Juankas sɨnkaailta: —Une minñarawa. U aumɨza “Jesúspa kamtanaman” kaizamtukas, aune Diosta mɨrawamakpas. ");
INSERT INTO kwi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aune izta aizpakas mɨra aizpakas kwinta kimɨztawamakpas. ");
INSERT INTO kwi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","An akkwan aliz pit pararawane, uspane usparuza chɨhkaarɨt. Uspane usparuza ilmanamara, pailta awa Diosta kwisha wari kizara akwa, sun kit akwa. ");
INSERT INTO kwi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mamasa kuhsaktɨtmikane cuarenta año mɨjara. ");
INSERT INTO kwi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chɨhtawane, Pedrokas Juankas uspa izmuruza ɨil kit Judío awa ɨninturuzkas ɨlapa ɨninturuzkas kaizara aizpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sun mɨarawane, wanne sulmin Diosta paikuat kit kaizara: “Au Anpat, nune sukas chiyukas pikas wan chiwalkas sara. ");
INSERT INTO kwi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nune Davidpa au kwalta kwinta kinara. Sɨnam Izpulne Davidta, Dios kiwainmikasha, ka paraninnara: ‘Diosta nɨjkultuchiruzne waya kiamtu. ¿Judío awaruzne uspa kiashimtu aizpa kain minñamtu? ");
INSERT INTO kwi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Au sukin ɨnintuzkas wan pɨpulukin ɨnintuzkas wanmakkamtu, Anpattakas Dios narɨttuzakas waya kianapa.’ ");
INSERT INTO kwi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Watcha. Herodeskas Poncio Pilatokas Judío awachikasa Israel awakasa an pɨpulukin up sɨnam kiwainmikasha waya kin wanmakkara. Jesúsne Dios naramika i. ");
INSERT INTO kwi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Uspa sun kiarachasmin, nune an ñancha uspa minñara aizpa pian, nu mintu aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Maneme au Anpat, usparuza mɨri. Uspane aumɨza naizninanazi kizamtu. Aumɨza kiwainchain, au ishkuamanpa, up pit kwinta kiana. ");
INSERT INTO kwi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nu tɨnta akwa, u kanpamturuza kiwainarain, ishturuza kakulninnanapa. U kiwainmuruzne up painkulta, sɨnam Jesústa, paikuanazi. Usparuza kiwaintain, chiwazha watsal iztasparɨt kal kianapa,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Diosta paikuarawane, uspa uzamtukin ulmɨzta. Sun urain Diospa Sɨnam Izpulne usparuza piznat kit Dios pit wan mɨrakin kainana kiwainnara. ");
INSERT INTO kwi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akkwan Cristora nɨjkulturuzne kawarain minñat kit sulmin kal kishiara. Mɨnminkas chiwazha mɨj aizpa uspain watsarachi. Sunkana wanne chiwazha mɨj aizpa usparuza mɨlanaara. ");
INSERT INTO kwi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɨnintaruzne Anpat Jesús irɨttas kakultɨt kwisha tɨnta kainanamɨzta. Diosne wanta an akkwan kiwainnamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mɨnminkas we mɨjchi. Su mɨjtuzkas yal mɨjtuzkas painin kit pial karaat ");
INSERT INTO kwi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kit ɨnintaruza mɨlanaara. Uspane an pial we mɨjtuza nailnara. ");
INSERT INTO kwi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sunkana Joséne Levíwa kwal kirɨt. Usne Chipre pi paizka sukin kawira. Ɨnintaruzne Joséwa mun maiz kit Bernabé munta, (us mamaztuza watsal pit kiz kit kiwainamtu akwa). ");
INSERT INTO kwi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Sun ampune maza su painin kit ɨnintaruza mɨlanara, mamaztuza kiwainanapa. ");
INSERT INTO kwi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mamaz ampune, Ananías muntɨtmikane, sua uzta. Usne paiña ashampakasa chiwazha su mɨj aizpa paininpailta. Paiña ashampane Safira muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","An ampune paiña ashampakasa pitchin pial paimpa mɨjkultɨt. “Wan pial mɨlarau” kiztuasmin, usne tiztɨt mɨj aizpa ɨnintaruza karara. Kainmin usparuza kishinara. Sɨnam Izpulne Ananías kit aizpa Pedrora piankamninta. ");
INSERT INTO kwi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Suasne Pedrone ussa ka kaizta: —Satanásne nua piz kit napta, Sɨnam Izpulta pɨrail kaizninna. Nune sun kishira, sun su paininta pial chiwazha watsan. ");
INSERT INTO kwi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sun su painintachasmin, up azi. Sun su painintawane, an pial up azi. ¿Chikishma sun kimtus? Nune Diosta pɨrail kaizta. Awara chi, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Sun mɨrawane, Ananíasne nain kit ira. Wanne sunta piankamara aizpa ishkuara. ");
INSERT INTO kwi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Suasne musitturuzne nappat kit ussa pĩn ippat kit muara, pilta kamna. ");
INSERT INTO kwi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kutña ura pailtawane, Ananíaspa ashampane Pedro tukin napta. Usne paiña ampura kirɨt aizpa pianchi. ");
INSERT INTO kwi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrone ussa mɨmara: —Kaizcha. ¿Une supawakin sun su paininmanas? Usne ka kizta: —Watcha. Sunpawa muin. ");
INSERT INTO kwi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Suasne Pedrone ussa kaizta: —Une nɨjkulara, Dios Izpulta pɨrail kaizna. ¿Chikishma sun kiwiznash? Up ampura mut kamtaruzne me aamtu. Uspane sunkanain nua muanazi, pilta kamna. ");
INSERT INTO kwi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sun urain usne Pedro panakin nain kit ira. Musitturuz nappakane, ussa irɨt wanmalara. Uspane ussa ampu kamkin kamna ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wan Jesústa piantuzkas wan sunpa piankamturuzkas ishkuara. ");
INSERT INTO kwi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɨnintaruzne awa purakin watsal iztasparɨt kal kiat kit kwisha akkwan awara kakulninñara. Wanne Salomón muntɨt pɨjtakin wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Awa usparuza wat minñat kit wat awa mai kizarakas, mɨnminkas uspakasa wanmakshiarachi. ");
INSERT INTO kwi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mazantuz ishkuarɨt akwa, akkwan ampukas ashampakas Anpatta nɨjkulat kit Anpatta piantuza wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sun akwa awane ishturuza pianamal karaat kit mikin kamakinkas pĩnkinkas taara. Pedro miwara pɨntuasmin, paiña izpul chamtukin usparuza ɨsalta pɨnnara. ");
INSERT INTO kwi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Akkwan awane kasha pɨpulukis Jerusalén pɨpulura pianaara. Uspane ishturuzakas saliz piztɨttuzakas karaara. Wanne kakularɨt. ");
INSERT INTO kwi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pariya ɨninmikakas Saduceo izmuruzkas ɨnintaruza aliz kulaara, awa usparuza pashinamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Suasne uspane paas ɨnintaruza pizat kit kajchira sɨppara. ");
INSERT INTO kwi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Anpatpa ángelne amtawara at kit kajchi pɨjta chɨh kit usparuza puzninnat kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Katsa Diospa yalta ɨrain. Suain wan awara Jesús awaruza uzninnamtu kainarain.” ");
INSERT INTO kwi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sun mɨiltawane, tɨlawain katsa Dios yalta nap kit awaruza kamtanamɨzta. Katsa pariyakas paiña izmuruzkas wan Israel ɨlapa ɨnintuza akwanara, wanmakkana. Uspane usparuza kajchiras kanapa ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Policía kajchira pianakane, kajchira usparuza wanmalnarachi. Suasne kaiyat kit usparuza ");
INSERT INTO kwi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ka kainanara: —Piannakane, aune sun kajchi sam sɨptɨt wanmalwiznash. Policíakas pɨjtakin wat izappara. Pɨjta chɨhtkane, aune mɨnainkas ayukmal izkitchimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sun mɨarawane, katsa Diospa yal izmu policía ɨninmikakas katsa pariyaruzkas chi kirɨt aizpa pianchi. Usparuzpain chima kiarɨzi mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sun urain maza ampune at kit kaiznara: —Mɨrain. Sun paas ampune, u kajchira sɨptɨttuzne, Dios katsa yalta paizkakin uz kit awara kamtanamtu. ");
INSERT INTO kwi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Suasne Diospa katsa yalta policíane mamaz policíakasa ɨat kit usparuza karaara. Awaruza ishkuamtu akwa, uspane usparuza kwail kiarachi, awa usparuza uk kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Karaarawane, policíane usparuza Israel ɨlapa ɨnintuz wanmaktɨtkin kunninnara. Katsa pariyane kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Aune uruza Jesúspa kamtanachi ɨnintamakpas. ¿Chi kiarɨt une? Une wan Jerusalén pɨpulukin uzturuza kamtanamtu. Une aumɨza sun ampura piantaamakpas kizshiamtu. ");
INSERT INTO kwi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Suasne Pedrokas mamaz ɨnintaruzkas sɨnkaanara: —Diosta mɨrawamakpas. Awara mɨrakiwamakpas. ");
INSERT INTO kwi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Au Diosne, au kwalpa Diosne, Jesústa irɨttas kakulninta. Une ussa irukasa patpian kit tɨra kan kit piantaara. ");
INSERT INTO kwi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Diosne ussa kakulnin kit tɨnta namninta. Usne ussa ɨninmikakas au watsat mɨlmumikakas namnintɨt, u Israel awa kwail kiarɨt aizpa maizanapa, u kwail kiarɨt sɨnam kulnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aune uruza Dios kit aizpa kainapuspas. Diosne paiña Sɨnam Izpul akwa aumɨza piankamninara. Usne paiña Izpulta paiña pit mɨraruza ɨninamtu. ");
INSERT INTO kwi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sun mɨarawane, uspane pilchapuzat kit usparuza piantashiara. ");
INSERT INTO kwi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gamalielne wanmakmuruztas azi. Usne Fariseo awa azi. Usne Moisés kaizta aizpa kamtanara. Wan awane us kwisha wat kirɨt minñara. Usne kun kit ɨnintuza pianamal ɨrattukimain ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kwiztane usne wanmakmuruza kaiznara: “Israel awa mɨrain. An ampuruza u kiashimtu aizpa mamasa wat mintain. ");
INSERT INTO kwi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Teudaspa nɨjkultain. Akkwan payuchin usne at kit ‘nane wat awa ish’ kiznara. Suas ampara cien awane ussa kanpaara. Mɨnpazha ussa piantarawane, paiña kanpamtuzne wan kaarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","An kwiztane awara wiantu payuin Judasne Galilea suras azi. Akkwanne ussa kanpaara, gobiernokasa waya kin. Awa ussa piantaarawane, paiña kanpamtuzne wan kaarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Katmizna nane uruza ka kurunamtus: Usparuza chinkas kiman. Usparuza chɨhttain. Awa mintu aizpakas awa kal kimtu aizpakas pailtɨnazi. ");
INSERT INTO kwi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Uspa Dios kaizta aizpa kiamtune, une usparuza kwayasachi. Dioskasa waya kiman, kiznara.” Uspane Gamaliel usparuza kainara aizpa kiara. ");
INSERT INTO kwi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Suasne uspane ɨnintaruza akwanara. Usparuza ilnarawane, uspane Jesúspa kwinta kiman kiznara. An kwiztane chɨhtnarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɨnintaruzne Israel ɨnintuz wanmakmukis puzpail kit watsal kulpailta, Jesús akwa naizpailta akwa. ");
INSERT INTO kwi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Uspane Diospa katsa yaltakas wan yaltakas Dios watsal pit kamtamɨzta. Jesúspa, Dios ɨninmikawa, pailta payukima kwinta kiamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Payu aizpa kwisha akkwan awane Jesúspa nɨjkulamɨzta. Griego pit paramtuzne aliz kulaat kit Judío pit paramtuza kaiznara: “Une au ashampawa ampu irɨttuza kumira kawarain nailnarachi.” ");
INSERT INTO kwi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Suasne doce ɨnintaruzne wan Jesúspa piankamturuza wanmakninnat kit kaiznara: “Aune Dios pit kainammɨztawamakpas. Dios pit chɨhkarachiwamakpas, kumira nailna. ");
INSERT INTO kwi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Katmizna, ap Diosta piantuz mɨzhain. Siete ampuruza sairain. Wat mintuza, wat piantuza, sairain. Sɨnam Izpul piztɨttuza sairain. Usparuza sun kal kinpa chɨhkarain. ");
INSERT INTO kwi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aune Diosta paikwat kit Dios pit awaruza kamtawamakpas,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wanne sun nɨjkulat kit awara nanara. Estebanne wat nɨjkulta. Sɨnam Izpulne ussa pizta. Felipekas Prócorokas Nicanorkas Timónkas Parmenaskas naarɨt. Nicoláskas naarɨt. Usne an ñamin Antioquía suras at kit Judío awakana namtɨt. ");
INSERT INTO kwi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","An kwiztane uspane usparuza ɨnintaruz purakin karanara. Ɨnintaruzne uspa akwa Diosta paikuat kit uspa chihtɨ usparuza paanara, sun kal kianapa. ");
INSERT INTO kwi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","An akkwan awane Dios pit piankamamɨzta. Jesústa piantuzne Jerusalén pɨpulura wanmakkamɨzta. Akkwan Judío pariyaruzkas Dios pit piankamat kit Jesústa nɨjkulamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanne irɨttuza kakulninnara. Ishturuza wat paninnara. Saliz piztɨttuza puzninnara. Iztasparɨt kal kimɨzta, awa Diosta piankamanapa. Diosne ussa nat kit tɨnta kiwainta, awa iztakin paiña iztasparɨt kal kinpa. ");
INSERT INTO kwi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Suasne mɨnpazha Judío kammu yaltas Estebanta tɨnta mɨmaamɨzta. An kammu yalne chɨhtmumikawa kammu yal muntɨt. Uspakas Cirene pɨpuluras awakas Alejandría pɨpuluras awakas Cilicia pɨpuluras awakas Asia suras awakas sua wanmakkara. Sun ampuruzne Estebanta tɨnta kwinta kiamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sɨnam Izpulne Estebanta kiwainta, usparuza nil kwinta kinpa. Uspane ussa wat sɨnkaarachi. ");
INSERT INTO kwi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Suasne uspane mɨnpazhara pial tanara, pɨrail kaizanapa. “Aune uspa kaizara aizpa mɨramakpas. Usne Moiséspakas Diospakas kwail pit kwinta kira.” Sunkana kiztain. ");
INSERT INTO kwi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sunkana awakas ɨlapa ɨnintuzkas Moisés kaizta aizpa kamtamtuzkas Estebanta pilchapuzamɨzta. Uspane ussa azain ɨat kit pizat kit ɨlapa ɨnintuzpa wanmaktɨtkin mɨlara. ");
INSERT INTO kwi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Uspane pɨrail kaizmuruza sayara, sunkana pɨrail kaizanapa: “An ampune Diospa sɨnam yalkas Moisés ɨninta aizpakas kwail pit kwinta kimɨztu. ");
INSERT INTO kwi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Aune Jesús Nazaret pɨpuluras kaizta aizpa mɨramakpas. ‘Nane Diospa katsa yalta azpiannash,’ kizta. ‘Nane Moisés ɨninta aizpa maiznash, mamaz tuntu uzanpa,’ kizta. Sun mɨramakpas,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Suasne ɨnintuzkas sua wan uztuzkas Estebanta izara. Ussa izamtuasmin, uspane paiña naztam matsɨhta izara. Ángel matsɨhkanain iztɨt izara. ");
INSERT INTO kwi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Suasne katsa pariyane Estebanta ka mɨmara: “¿Nawa uspa kaizara aizpa watcha ki?” mɨmara. ");
INSERT INTO kwi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Usne usparuza ka sɨnkanara: “Au aimpihshtuzkas au Israel awaruza ɨninmuruzkas nawa mɨzhain. An ñamin au taitta Abrahamne Mesopotamia sura uzta. Abraham Harán sura uztachasmin, au chiyuras Diosne ussa izpan kit ");
INSERT INTO kwi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kaizta: ‘Up sukas up kwalkas chɨhkat kit mamaz sura na antu aizpa ɨnka.’ ");
INSERT INTO kwi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Suasne Abrahamne Caldea suras puz kit Harán sura uzna ɨrɨt. Paiña papihsh irawane, Diosne ussa an sukin ma u uzkin karara. ");
INSERT INTO kwi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Usne apain chinkas su ussa mɨlatchi. Mɨnta uzna mɨlatchi. Diosne an su mɨlanash kizta. Nu irɨka, paiña painkultuzne an su sappanazi kizta. Sun payune Abrahamne painkul mɨjchiazi. ");
INSERT INTO kwi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anpane sun urain Diosne ‘up kwal mamazpa sura mamaz awakanain uzanazi’ kaizta. Kiwainmumikakana cuatro cientos añokima kal kianazi. Katsa mikwaruzne usparuza ilnanazi, kal kianapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Diosne ussa an kaizta: ‘Nane uruza naiznintuza ilnat kit naizninanash. An suras puzarawane, uspane apain nawa kiwainat kit nawa paikuanazi,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diosne Abrahamkasa sun kin nam kit ka ɨninta: ‘Nawa nɨjkultuasmin, nune up aya tɨt kit circuncisión kitpa.’ Katmizna Isaac kawirawane, Abrahamne maza domingora paiña painkulpa ayara tɨt kit circuncisión kira. Sunkanain Isaacne Jacobta paiña painkulta kira. Jacobkas sunkanain paiña painkultuza kinara. Uspane au doce Israel pamparuz mai. ");
INSERT INTO kwi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Au Jacobpa painkultuzne au pampawa irɨt kwal mai. Uspa Joséra aliz kulat kit izashitchi akwa, uspane ussa mamaz awaruza paininñara, Egipto sura mɨlnapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Diosne ussa kiwain kit wan kwailtas puzninta. Joséne piankam kit Faraónpa izmumika namta. An katsa mikwane Egipto sukin ɨninta. Usne Joséra nara, Egipto surakas paiñain yaltakas ɨninnapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Suasne Egipto surakas Canaán surakas kumira wachi akwa, awane yak kiat kit naizara. Suane au ñamin papihshtuzne chi kumanamara. ");
INSERT INTO kwi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob chara pippa Egipto sura wa mɨrawane, usne paiña painkultuza, au an ñancha kwal uzturuza, ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Uspa paakima ɨarawane, Joséne paiña aimpihshtuza ussain piankamninta. Sunkanain Faraónne, Egiptokin katsa mikwane, Joséwa kwal piankamta. ");
INSERT INTO kwi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Suasne Joséne papihshtakas paiña kwaltakas kanapa ɨninnara. Paiña kwal setenta y cinco awa wiantɨt. ");
INSERT INTO kwi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sunkanain Jacobkas paiña kwalkas Egipto sura uzna ɨarɨt. Uskas au an ñancha kwalkas ta iarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","An kwiztane uspa kwaltuzne uspa iarɨt kwaltuza Siquem pɨpulura muat kit kamara. An ñancha Abrahamne sun awa irɨt kamkin Siquem su paira. Hamorne Abrahamta sunpawa muin sun su paininta. ");
INSERT INTO kwi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","An ñamin Diosne Abrahamta sun su mɨlan namta, sun su sapnapa. Sun payu taiznapain pakane, Israel awane Egipto sukin an akkwan namara. ");
INSERT INTO kwi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Suasne mamaz mikwane, Joséra pianchimikane, Egipto sukin ɨninmɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","An mikwane au kwalta kain kinat kit naizninnara. Usne au kwalta ɨninnara, uspa mamin kawira pashaparuza pianamal talaij ɨnanapa, sua iarɨnpa. ");
INSERT INTO kwi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","An payune Moisésne kawira. An pashpane kwisha watsal azi. Paiña papihshtuzne uspa yalkin kutña mishkima kawirara. ");
INSERT INTO kwi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kutña mish pailtawane, uspane Moisésta yal pianamal talaij ɨnpa ɨninta. Faraónpa, Egipto mikwawa pashune ussa chak kit paiña painkulkanain kawirara. ");
INSERT INTO kwi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Katmizna uspane Moisésta Egipto awa pian aizpa kamtaninta. Usne kwisha tɨnta awa namta. Paramtune, usne watsal kaizta. Chiwazha kal kitne, usne watsal kira. ");
INSERT INTO kwi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Cuarenta año kawirawane, Moisésne min kit paiña Israel kwalta kwinta kin ɨshira. ");
INSERT INTO kwi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Suasne usne maza Egipto awa paiña kwalta kwail kimtu izta. Katmizna Moisésne paiña kwalta pakpana ɨra. Usne Egipto awara il kit piantara. ");
INSERT INTO kwi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Usne us kit aizpa paiña Israel aimpihshtuz mɨanazi minta. Uspane Dios Moisésta usparuza kiwainna narɨt pianchi. ");
INSERT INTO kwi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tɨlawara Moisésne paas Israel awa waya kimtu iznat kit kiwainashira, waya kimanpa. Usne usparuza kaiznara: ‘Une aimpihshparain i. ¿Chikishma uwarain kwail kimtuas?’ ");
INSERT INTO kwi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Suasne izmumikasha kwail kimtuatmikane Moisésta makin nuppain kit mɨmara: ‘¿Mɨnma nua au ɨninmikakana namzi? ¿Mɨnma nua au mikwa namzi, au kwail kirɨt aizpa kiznapa? ");
INSERT INTO kwi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nune anchik Egipto awara piantara. ¿Nawakas piantashimtukish?’ ");
INSERT INTO kwi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sun mɨrawane, Moisésne ishkwat kit Madián sura ɨra. Suane mamaz awakanain uz kit paas painkul kawirara. ");
INSERT INTO kwi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Moisésne pul sukin, kashara Sinaí ɨzakin, uzta. Cuarenta año pailkane, maza ángelne ussa pu tɨra ĩn aiztukin izpanta. ");
INSERT INTO kwi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisésne us izta aizpa iztasparɨt. Tɨra an wat izna ɨtpane, Moisésne Anpat Dios kaizka mɨra. ");
INSERT INTO kwi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ka kaizta: ‘Nane up kwalpa Dios ish. Abrahamkas Isaackas Jacobkas na iztakin wakpuj wainñat kit paikuara.’ Suasne Moisésne ishkwat kit ulmɨzta. Sunta izshitchi. ");
INSERT INTO kwi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Anpat Diosne ussa kaizta: ‘Up zapato ukti. Sun su mittɨ kultukinne ap su i. ");
INSERT INTO kwi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nane ap awa Egipto sukin kwisha naizamtu pianish. Nane uspa azamtu aizpa mɨnat kit chiyuras kihshtau, usparuza chɨhtnana. Nawa mɨzha. Nane nua Egipto sura ɨninnash,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Israel awa Moisésta izashitchi kizarakas, Diosne Moisésta ángelpara pu tɨ ĩn aiztukin kwinta kit kit uspa ɨninmikakas uspa chɨhtmumikakas namta. ");
INSERT INTO kwi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisésmin au kwaltuza Egipto suras ukkat mɨlnara. Dios ussa kiwainta akwa, usne Egipto surakas kwanam pimarakas pul surakas cuarenta añokima iztasparɨt kal kiara, uspa Diosta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisésmin Israel awara kaiznara: ‘Diosne maza ɨninmikasha paiña kwaltas ɨninnazi, na ɨnintukana ɨninnapa. Ussa mɨrain.’ ");
INSERT INTO kwi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Israel awa pul sukin wanmakkamtuasmin, Moisésne uspakasa uz kit ángelkasa Sinaí ɨzara kwinta kira. Suasne usne sun Dios watsal pit mɨra, aumɨza sun pitmin kamtananapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Au an ñancha kwalne Dios kaizta aizpa mɨashitchi. Ussa izashitchi akwa, uspane Egipto surain kaiyashira. ");
INSERT INTO kwi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Suasne uspane Aarónta paikwat kit kaizara: ‘Nune mamaz dios sari, au iztakin an ñancha ɨnpa. Moisés aumɨza Egipto suras mɨlnarakas, aune ussa chima kirɨt pianchimakpas.’ ");
INSERT INTO kwi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Suasne uspane chiwazha wakara pashpakana iztɨt saara. Pishta saat kit wakara piantat kit wakara pashpakana kunkin chiwazha mɨlaara, sunta wakpuj wainñanapa. Uspa sarɨt aizpa wari minñara. ");
INSERT INTO kwi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Katmizna Diosne usparuza paimpa chɨhkanara, chiyu kɨmara wakpuj wainñanapa. Sunkana Dios kainammmikane pɨnkɨhta ka parɨt: ‘Israel awa mɨrain. Pul sukin cuarenta añokima uzasmin, une na akwa wakara piantarachi. Nawa chinkas mɨlaarachi. ");
INSERT INTO kwi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sunkana nawa wakara mɨlarachikas, une dios Molocpa yal ukasa muara, sunta wakpuj wainñanapa. Ukas dios Refánpa kɨmakas muara, sunta wakpuj wainñanapa. Umin suntuz sat kit wakpuj wainñara. Katmizna nane u suras uknanash,’ Babilonia sura ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Au an ñancha kwalne pul sukin mamaz ainki Dios yal mɨjara, awa Dios uztu piankamanapa. Diosne Moisésta ɨninta, paiña ainki yal sanapa. Usne ussa an ainki yalkana izninta. Sun Dios yal sarawane, ");
INSERT INTO kwi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","au kwalne sun Dios yal sappat kit uspakasa mɨlaara. An kwiztane au sura kaiyamɨztune, au kwalne Josuékasa sun ainki yal karaara, uspa su nappamtukin. Mamaz awa sun sura uzarakas, Diosne sun sukis usparuza attishta ɨninnara. Diosne usparuza sun suras ɨninnara, au kwal sun su sappanapa. Sun ainki Dios yalne sun sukin nukkulta, David uzta payukima. ");
INSERT INTO kwi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Au katsa ɨninmika David nil uzta akwa, Diosne ussa wat pashira. Usne Diosta paikwara, Diospa yal sashimtu akwa. Sua Jacobpa Diosne uzshira. Sua Israel awaruzne au Diosta wakpuj wainñat kit paikuashira. ");
INSERT INTO kwi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kwiztane Salomónmin Dios yal sara. ");
INSERT INTO kwi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Au katsa Diosne awa sara yalkin uztuchi. Dios pit kainammmikane Dios kaizta aizpa ka kaizta: ");
INSERT INTO kwi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nane chiyuras na wan sara aizpa ɨninnamtus. An sune na sara aizpa ainki i.’ Anpatne ka mɨmanara: ‘¿Chi yalma saanapas apane? ¿Mɨntama kwaizkulna ɨnpai? ");
INSERT INTO kwi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nain wan sashit aizpa sarau.’ ");
INSERT INTO kwi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Une Dios kaizta aizpa nɨjkulamtuchi. Une Diosta pianchiruzkana mai. Une Dios kaizta aizpa mɨarachi. Une Dios Izpul kaizta aizpa mɨashitchi. Une u an ña kwal uztakanain uzamtu. ");
INSERT INTO kwi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","U an ña kwalne wan Dios kainammtuza naizninñara. Mamaztuzne Dios nil kimtumika anazi kizara. Uspane sun kainammtuza piantaara. Mane me une sun wat kimtumikasha kwail kiat kit kwail awara chɨhkat kit piantaara. ");
INSERT INTO kwi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diosne ángeltuza ɨninnara, Moisés paiña pit uruza kwinta kinpa. Une sun pit mɨashitchi.” ");
INSERT INTO kwi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sun mɨarawane, uspane pilchapuzaat kit Estebanta aliz pit paraara. ");
INSERT INTO kwi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sɨnam Izpul ussa piztuasmin, Estebanne chiyura izak kit Diosta naztamkana iztɨt izta. Usne Jesús pana Dios ɨninmakin izta. ");
INSERT INTO kwi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Suasne Estebanne ka kaizta: —Iztain. Nane chiyura kai iztus. Nane Dios Painkulta Diospa mamin ɨnintukin iztus, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Uspane kail palpizat kit tɨnta kwiannat kit masain wan ussa pizshiara. ");
INSERT INTO kwi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pɨpulukis ussa ukkat kit uk kiamɨzta, piantana. Uk kiamtuzne, ussa kwail kirɨt kainammtuzne, uspa kamisha musittu panakin taara. An musittune Saulo mun. ");
INSERT INTO kwi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Uspa ussa uk kiamɨztuasmin, Estebanne Diosta paikwat kit kaizta: “Ap Anpat Jesús, ap izpul sapti.” ");
INSERT INTO kwi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kwiztane Estebanne wakpuj wain kit tɨnta ka kwianta: “Ap Anpat. Uspa kwail kiara aizpa sɨnam kwizninnari.” Sun kiztawane, ira. ");
INSERT INTO kwi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulone ussa piantana nɨjkulta. Saulone sun payuin Jerusalén pɨpulukin wan Cristora piantuza kwisha naizninara. Sun aliz awaruz akwa, wan Cristora piantuzne Judea surakimakas Samaria surakimakas ɨara. Ɨnintaruzpain suain nukkulara. ");
INSERT INTO kwi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mɨnpazha awane, Diosta piantuzne, Estebanta kamat kit us akwa kwisha azara. ");
INSERT INTO kwi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sun kiamtuasmin, Saulone Diosta piantuza pizshinat kit wan yalta napta, ampurakas ashamparakas tainana, kajchira sɨpnana. ");
INSERT INTO kwi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalén pɨpulukis ɨmturuzne mɨnta ɨamtuara Dios pit kainaara. ");
INSERT INTO kwi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipene, maza usparuztas, Samaria pɨpulura ɨt kit Cristowa kwinta kinamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Awane wanmakkat kit Felipe kaizta aizpa kwisha wat minñara. Felipene iztasparɨt kal kira, awa Diospa wat piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Felipene kwisha akkwan awara saliz piztɨttuza puzninnara. Saliztuzne usparuztas puzat kit kwian kit ɨara. Usne kaniya nastuzakas wat mittɨ chasachiruzakas kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sun akwa sun pɨpulukis awane kwisha wat kulara. ");
INSERT INTO kwi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Simónne Samaria pɨpulura uzta. Sua akkwan añokima Samaria suwara tañu kimɨzta. Usne wan awaruza kain kinat kit ishkwinnat kit “nane anza tɨntamika ish” kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wan we tɨntaruzkas wan awaruza ɨnintuzkas ussa wat mɨashit kit kaizara: “An ampune an tɨnta i. Usne Diospa katsa kiwainmumika i,” ñanta kizara. ");
INSERT INTO kwi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Uspane ussa wat mɨat kit kanpaara, akkwan añokima usparuza kain kinat kit tañu kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipene usparuza Dios awaruza ɨninnashimtu kainanara. Jesucristo awaruza watsat mɨlnashimtu kamtanamtuasmin, akkwanne Jesucristora nɨjkulara. Dios watsal pit mɨarawane, Felipene ampuruzakas ashamparuzakas munninnara. ");
INSERT INTO kwi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón nɨjkulish kiztawane, Felipene ussa munta. Suasne usne Felipera kanpamɨzta. Felipe iztasparɨt kal kirɨt akwa, usne iztasparɨt. ");
INSERT INTO kwi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ɨnintaruzne Jerusalén pɨpulura purara. Uspane Samaria awa Dios kaizta aizpa mɨarɨt piankamat kit Pedrorakas Juantakas ta ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samaria pɨpulura piannatpane, uspane Diosta paikuara, Diosta piantuz Sɨnam Izpulta sappanapa. ");
INSERT INTO kwi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mama Sɨnam Izpulne usparuza pizna atchi. Anpat Jesústa nɨjkularɨt akwa, Felipene usparuza munninnara. ");
INSERT INTO kwi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Suasne Pedrokas Juankas uspa chihtɨ usparuza panamtuasmin, Sɨnam Izpulne usparuza piznara. ");
INSERT INTO kwi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ɨnintaruz usparuza chihtɨ paanamtuasmin, Simónne Sɨnam Izpul usparuza piznamtu izta. Usne pial mɨlashit kit usparuza ");
INSERT INTO kwi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka kaiznara: —Nawakas an iztasparɨt kal kin kiwaincha, na chihtɨ paaka, Sɨnam Izpul awaruza piznapa, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Suasne Pedrone ussa kaizta: —Up pialkas nukas parejuin karɨnazi. Nune Dios mɨlamtu aizpa pialkasa painash nil chi mintu. ");
INSERT INTO kwi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nune Diosta pianchi. Aukasa sun kal kisachi. Diosne nu kaijchukin nu kwail mintu aizpa pian. Nu kishimtu aizpa nil chi. ");
INSERT INTO kwi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Katmizna nune nu kwail kishimtu aizpa maiz kit chɨhkari. Diosta paikwatpa, nu kwail mintu aizpa kaijchura wat kulnapa. ");
INSERT INTO kwi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nane nu kwail kishimtu aizpa pianish. Pial kana kishimtu akwa, nune ñan miwara ɨshimtu. ");
INSERT INTO kwi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Suasne Simónne ka sɨnkara: —Anpat Jesústa na akwa paikwarain, nu kaizta aizpa, sun nawa kimanpa. ");
INSERT INTO kwi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Awaruza Jesúspa kainanarawane, Dios pit kaiznarawane, Pedrokas Juankas Dios watsal pit akkwan Samariawa pɨpulurakas kainana ɨilta. Suasne Jerusalén pɨpulura kailpailta. ");
INSERT INTO kwi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sun kitpane, Anpatpa ángelne Felipera ka kaizta: “Kuhs kit ɨmɨzti. Jerusalén pɨpuluras Gaza pɨpulura miwara ɨtpa.” An mine pul sura pɨnmu. ");
INSERT INTO kwi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipene kuhs kit ɨt kit miwara etíope ampura wanmalta. An katsa ɨninmikane Candace Etiopía suras ashampa mikwara kiwainta, uspa pial watsanpa. Usne Jerusalén pɨpulura ɨra, Diosta wakpuj wain kit paikwan. ");
INSERT INTO kwi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","An ampune paiña sura kailtɨmtuara. Paiña carro caballo ɨmtuasmin, usne Isaías pɨnkɨh parɨt aizpa iztuara. ");
INSERT INTO kwi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Suasne Sɨnam Izpulne Felipera kaizta: “Carro caballora kashara ɨt kit wanmakti,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kashara ɨt kit Felipne us Isaías pɨnkɨh iztu mɨra. Ussa mɨmara: —¿Nu iztu aizpa mɨmtukish? ");
INSERT INTO kwi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ampune ussa kaizta: —¿Mizama mɨnapai? Mɨnminkas nawa kainarachi. Usne Felipera paikwara, uskasa carrora nut kit uznapa. ");
INSERT INTO kwi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Usne Dios pit ka iztu ara: “Uspane ussa pɨrikukana mɨlta, piantana. Usne pɨriku pashpakana i. Pɨriku ash tɨtmumika ash tɨttane, usne aztachi. Uskas puñain ara. ");
INSERT INTO kwi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Us kwail kitchikas, uspane ussa nil aizpa kiarachi. Mɨnainkas ussa kiwainarachi. Mɨnainkas paiña kwalpa paramanazi. Paiña kwalne ussa piantaara, an sukin uzmanpa.” ");
INSERT INTO kwi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɨninmikane Felipera mɨmara: —Kainazha. An kainammmikane ¿Mɨnpama paramtus? ¿Uspa paramtuki? ¿Mamazpa paramtuki? ");
INSERT INTO kwi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Suasne Felipene sunmin Dios pɨnkɨh iztukin Dios watsal pit, Jesúspa pit, kamtamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ɨmtuwaiyasmin, uspane kwazi wakin piannailta. Ɨninmumikane ussa kaizta: —Apane kwazi wai. ¿Nawa munnasachimakish? ");
INSERT INTO kwi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Felipene ka kaizta: —Nu Jesucristora up kaijchukin nɨjkultane, kishina. Usne sɨnkara: —Nane Jesucristo Dios painkul i nɨjkultus, kizta.) ");
INSERT INTO kwi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Suasne ɨninmumikane carro caballo uzninnapa ɨninta. Paasas pira kihshtawane, Felipene ussa munnara. ");
INSERT INTO kwi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Uspa kwaziras salaktawane, Anpatpa Izpulne masain Felipera mɨlta. Ɨninmikane ussa anne me iztachi. Usne wat kul kit paiña miwara ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipene Azoto pɨpulura tuat kit wan pɨpulukin Dios watsal pit kainanara, Cesarea pɨpulura piannankima. ");
INSERT INTO kwi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sun urain Saulone “Anpatpa piantuza piantananash” tɨnta kainanamɨzta. Katmizna usne katsa pariyara ɨt kit pɨnkɨh paikwara, ussa Israel kammu yalta ɨninnannapa. ");
INSERT INTO kwi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Sun pɨnkɨhkasa Damasco pɨpulura ɨshimtu ara, Dios miwara ɨmtuza piznana. Usne ampuruzakas ashamparuzakas Jerusalén pɨpulura mɨlshinara, usparuza sɨpnana. ");
INSERT INTO kwi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kasha Damasco pɨpulura miwara pianamtuasmin, masain Saulone chiwazha naztam chiyuras taiztɨmtu izta. ");
INSERT INTO kwi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Suasne Saulone pilta nainta. Mazane chiyuras ussa parat kit kaizta: “Saulo. Saulo. ¿Chikishma nawa naiznintus?” ");
INSERT INTO kwi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Suasne Saulone mɨmara: “Anpat ¿Mɨn mas?” kizta. Usne sɨnkara: “Nane Jesús ish. Nu nawa piantuza piantamtu akwa, nune nawa naiznintu,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Suasne Saulone ul kit ishwat kit sɨnkara: “Ap Anpat. ¿Chima kishiras, na kinpa?” kizta. Anpatne ussa sɨnkara: “Kuhs kit pɨpulura napnaka. Suasne nane nua nu kishimtu aizpa kaiznash.” ");
INSERT INTO kwi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulokasa ɨmtuzne ishkuara. Sun pitta mɨarakas, uspane mɨnainkas izarachi. ");
INSERT INTO kwi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kwiztane Saulone piltas kuhsakta. Kasu izkultakas, izsachiwal. Ɨmturuzne paiña chihtɨra pizat kit Damasco pɨpulura tain ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Suane kutña payukima izmanamtɨt tuara. Kumira kwatchiwal. Kwazikas kwatchiwal. ");
INSERT INTO kwi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dios pit pianmikane, Ananías muntɨtmikane, Damasco pɨpulura uzta. Anpatne ussa kainkizpamnin kit ussa kaizta: “Ananías,” kizta. Usne ka sɨnkara: “Anpat. Nane akki tus,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Suasne Anpatne ussa kaizta: “Kuhsak kit ‘Nil’ muntɨt miwara ɨmɨzti. Judaspa yalta piannakane, Tarso suras awara, Saulo muntɨtmikasha, mɨmanaka. ");
INSERT INTO kwi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Usne Diosta paikwat kit chiwazha kainkizpam izta. Kainkizpamtuasmin, Ananíasne sun yalta nap kit paiña chihtɨkasa ussa paara, mamasa iznapa. Sunkana kainkizpamtu.” ");
INSERT INTO kwi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sun mɨrawane, Ananíasne kaizta: “Anpat. Akkwanne nawa sun ampuwa kwinta kiara. Usne Jerusalén pɨpulukin Jesústa piantuza akkwan kwail kinarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mane akki amtui. Katsa pariyaruzne ussa pɨnkɨhkasa ɨninta, Jesústa paikumturuza kajchira sɨpnana.” ");
INSERT INTO kwi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Anpatne sɨnkara: “Ɨt. Nane an ampura narau, nawa mamaz su uztuzakas uspa ɨninturuzakas Israel awaruzakas parananapa. ");
INSERT INTO kwi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nawa kanpashimtu akwa, usne naiznazi. Nane ussa sun naizmu annash.” ");
INSERT INTO kwi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Suasne Ananíasne Saulo tura ɨra. Naptawane, usne paiña chihtɨkasa ussa pat kit kaizta: —Aña Saulo. Nu miwara amtuasmin, Anpat Jesúsne, nua miwara izpamtamikane, nawa ɨninta, nu mamasa iznapa, Dios Izpul nua piznapa. ");
INSERT INTO kwi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sun urain chiwazha piachal iztɨtkana kasuras taizakane, mamasa izta. Suasne Saulone kuhs kit munarɨt azi. ");
INSERT INTO kwi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kwiztane kwat kit mamasa tɨnta kulta. Usne akkwan payuchikima Diosta piantuzkasa Damasco pɨpulura nukkulta. ");
INSERT INTO kwi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kwiztane Saulone Israel kammu yalta kamtanamɨz kit “Jesúsne Dios painkul i” kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wanne us kaizta aizpa iztaspaat kit kaizara: —An ampune Jerusalén pɨpulura Jesústa paikumtuza pizshinamtu. Usne, piznammikane, apain ara, Jesústa piantuza katsa pariyaruza mɨlnana, usparuza sɨppnana. ");
INSERT INTO kwi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulone an tɨnta kainanamɨzta, “Jesús Dios ɨnintamika i” kiz kit. Paiña kamtɨt akwa, ussa Judío awa Damasco pɨpulukin uztuza annuppanarɨt. Uspane Saulora sɨnkaarachi. ");
INSERT INTO kwi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","An imparane, Judío awaruzne nɨjkulara, Saulora piantaana. ");
INSERT INTO kwi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mɨnpazha uspa minñamtu aizpa piankam kit Saulora kaizta. Uspane sun Damasco pɨpulu katsa kalpialkin, pɨjta puzmukin, purara. Uspane, aliztuzne, payuwarakas amtawarakas pɨpulu pɨjta puzmukin izat kit tɨrizara, ussa piantaana. ");
INSERT INTO kwi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tɨlpamɨzkane, Dios pit piantuzne ussa katsa tɨmta win kit katsa uk kalpialtas inkihshara. Sunkana pizamasara. ");
INSERT INTO kwi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalén pɨpulura piannatpane, Saulone Cristora nɨjkulturuza wanmaknashira. Wanne ussa ishkuara. Uspane us Dios pit pianchimika minñara. ");
INSERT INTO kwi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Suasne Bernabéne ussa kiwain kit ɨnintaruza mɨlnara. Usne Saulo Damasco miwara Anpatta izta aizpa kainara. Anpat ussa kwinta kira aizpa kainara. Damasco pɨpulukin nukkultuasmin, usne sun awaruza Jesúspa kwinta kinara, ishkwatchin. Sunkana kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Suasne Saulone uspakasa nukkul kit Jerusalén pɨpulura uspakasa chaara. Usne usparuza Anpatpa kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jesúspa kamtamtuasmin, mɨnminkas ussa kunkitchi. Usne ishkwatchi. Mazantuzne, Judío awaruzne, Griego pit paraara. Uspane tɨnta kwinta kiat kit ussa mɨmaara. Uspane ussa piantashiara. ");
INSERT INTO kwi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sun piankamarawane, Diosta piantuzne Saulora Cesarea pɨpulura miarɨt. Tas ussa Tarso pɨpulura ɨninñara. ");
INSERT INTO kwi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Suasne wanmakmuruzne Judea suraskas Galilea suraskas Samaria suraskas kalpain uzat kit Dios pit an kamamɨz kit an tɨnta namara. Uspane Anpat kuruntu aizpa kishiara. Sɨnam Izpul usparuza kiwainara akwa, an akkwan awane Diosta piankamara. ");
INSERT INTO kwi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Diosta piantuza iznamtuasmin, Pedrone Jesústa piantuza, Lida pɨpulura uztuza, iznana ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Suane Pedrone Eneas munmikasha wanmalta. An chasachimkane ocho añokima kamarain tuara. ");
INSERT INTO kwi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrone kaizta: —Eneas. Jesucristone nua kakultanazi. Kuhsti. Up kama watsari, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Eneasne masain kuhsakta. Lida pɨpulukin uztuzkas Sarón sukin uztuzkas ussa izara. Uspane an ñamin nɨjkulara aizpa chɨhkaat kit Anpatta nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mane Tapitane Dios pit piankam kit Jope pɨpulura uzta. (Usne Griego pitta Dorcas muntɨt.) An ashampane pailta payu wat kinat kit we mɨjtuza kiwainara. ");
INSERT INTO kwi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Maza payune usne imtu kit kit irɨt. Ɨlaparuz aumɨza kamtɨt akwa, aune irɨtta sɨnam pinat kit ussa kwash pitmumal taara. ");
INSERT INTO kwi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope pɨpulune Lida pɨpulura kasha uzara. Pedro Lida pɨpulura uztuasmin, Dios pit piantuzne paas ampura Lida pɨpulura ɨninnara, Pedrora ka paikwanpa, Jope pɨpulura azain anpa. ");
INSERT INTO kwi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Suasne Pedrone uspakasa ɨra. Piannaakane, uspane ussa irɨt tura anna ɨara. Wan ampu irɨt ashamparuzne ussa salpɨn kunara. Azamtuasmin, uspane ussa kwakshamkas kamishakas anara. Ka uzasmin, Dorcasne pĩn sɨp kit usparuza mɨlanara. ");
INSERT INTO kwi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Suasne, Pedrone wanta puzninnat kit wakpuj wain kit Diosta paikwara. Irɨt ashampara iz kit ka kizta: —Tabita, kakulti. Suasne usne kasu izkulkwera. Pedrora iz kit kuhsak kit uzta. ");
INSERT INTO kwi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Usne paiña chihtɨ piz kit kuhsninta. Kwiztane usne Diosta piantuzakas ampu irɨt ashamparuzakas akwanara, ussa izanapa. ");
INSERT INTO kwi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jope pɨpulukin kwisha akkwan awane Jope pɨpulukin sun piankamara. Sun akwa, akkwan awane Anpatta nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedrone an akkwan payura Jope pɨpulura Simónpa yalta mara. Usne aya suintam sammika ara. ");
INSERT INTO kwi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cornelione Cesarea pɨpulura uzta. An suldarura ɨninmikane maza cien suldaruruza Italia suras ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","An wat awane paiña kwalkasa Diosta wakpuj wainñat kit Diosta paikwashira. Usne akkwan pial Judío wenamturuza mɨlanat kit Diosta pailta payu paikwara. ");
INSERT INTO kwi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Maza payu nashka, kutña urara, chiwazha kainkizpara. Usne maza Diospa ángel us tukin napka izta. Ángelne ussa ka kaizta: “Cornelio,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelione ángelta iztaspat kit ishkwat kit mɨmara: “¿Anpat, chima pashimtus?” Suasne ángelne ussa ka kaizta: “Diosne nu paikwat aizpa mɨra. Usne, chiyura uzmikane, nu wenamturuza mɨlanara aizpa piankam kit maintachi. ");
INSERT INTO kwi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Maza awara Jope pɨpulura ɨninnaka, Simónta akwanpa, up yalta karanpa. Pedrokas muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mamaz Simónne, aya suintam sammikane, paiña yal pimara mɨj. Pedrone uskasa uztu. Usne nu kishimtu aizpa kaiznazi.” ");
INSERT INTO kwi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángel kwinta kit kit kailtawane, Cornelione paas kiwainmuruzakas maza suldarura Diosta pianmikashakas, akwanara. ");
INSERT INTO kwi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Us usparuza wan kwinta kinarawane, usne Jope pɨpulura ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tɨlawara uspa miwara kashara Jope pɨpulura ɨamtuasmin, Pedrone payu aizpa yal ɨsalmal nura, Diosta paikwan. ");
INSERT INTO kwi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yak kit kit kwashira. Paiña kumira ainamtuasmin, kainkizpamtuasmin, usne chiwazha izta. ");
INSERT INTO kwi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Chiyura kai maltuasmin, Pedrone katsa pĩn iztɨtkana izta. Anne chiyuras piltakima katsa pĩnkana taizta. ");
INSERT INTO kwi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sun katsa pĩn iptɨtkin, akkwan ampara mittɨ waj kalpakas kamtakas chitchukas waara. ");
INSERT INTO kwi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Suasne Diosne ussa kaizta: “Pedro. Kuhsak kit piantat kit kwat,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrone sɨnkara: “Anpat, nane kumanash. Nane mizurainkas Dios chiwazha kwanchi kizta aizpa kwatchish.” ");
INSERT INTO kwi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Suasne Diosne mamasa parat kit ka kaizta: “Nune chiwazha Dios sɨnam sarɨt aizpa kwashina. Dios sarɨt aizpa kwasachish kizmun,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sun pĩn kutñakima taiztawane, katsa pĩnne chiyurain kailta. ");
INSERT INTO kwi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro Dios ussa kamtashimtu aizpa mintuasmin, Corneliowa ɨnintuzne pɨjtakin aat kit Simónpa yal mɨnta tui kiz mɨmaara. ");
INSERT INTO kwi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pianaarawane, uspane mɨnpazhara ka mɨmaara: “Simóne, Pedro munmikane, ¿Mɨntama tu? ¿Nune ussa yal nammɨlamtukish?” ");
INSERT INTO kwi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro kainkizpamtu aizpa mama mintuasmin, Sɨnam Izpulne ussa kaizta: “Mɨri. Kutña awa nua sayamtu. ");
INSERT INTO kwi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kuhs kit kihsh kit uspakasa kuntachin kanpanari. Nane usparuza ɨninnarau.” ");
INSERT INTO kwi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Suasne Pedrone Corneliowa ɨnintuz purakin kihsh kit kaiznara: —Nane, u sayamtumikasha ish. ¿Chinmaka awiznash? ");
INSERT INTO kwi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Uspane ka sɨnkaara: —Aune Cornelio cien suldaru ɨninmika akwa awiznash. Usne wat awa i. Usne Diosta wakpuj wain kit paikumtu. Wan Judío awane ussa wat minñat kit pashiamtu. Diospa ángelne ussa ka kizta: “Pedrora ɨnin kit akwatpa, paiña yalta ɨnpa. Us kaizta aizpa mɨrawa,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Suasne Pedrone usparuza napninnat kit an amta yal nammɨlanara. Tɨlawarane Pedrone uspakasa ɨra. Mɨnpazha Jope pɨpuluras Diosta piantuzkas ussa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mamaz payurane Cesarea pɨpulura nappaara. Pedrora tɨriztuasmin, Cornelione paiña kwaltakas paiña izmuruzkas akwanara. ");
INSERT INTO kwi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro yalta putnatpane, Cornelione puz kit “wat kɨntɨre” kiz kit ussa wakpuj wainta, Dios ussa ɨnintɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrone ussa kuhsaknin kit kaizta: —Kunti. Nawa wakpuj wainkain. Nane nukana ampu ish. ");
INSERT INTO kwi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Uskasa paramtuasmin, Pedrone nap kit kwisha akkwan awa wanmakkarɨttuza iznara. ");
INSERT INTO kwi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Suasne Pedrone kaiznara: —U na kaiztu aizpa pian. Judío awane Judío chi awaruzkasa wanmakkasachi. Uspa yalta nappasachi. Une sun Moisés ɨninta aizpa pian. Mane Diosne Judío chi awaruzkasa wanmakna impachi kamtash. Dios wan awaruza sapkane, aukas usparuza saptawamakpas. ");
INSERT INTO kwi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Katmizna nu nawa akukane, masain chinkas kiztachi arau. Nane piankamshimtus: ¿Chikishma nawa akupuspas? ");
INSERT INTO kwi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Suasne Cornelione sɨnkara: —Ampara payuin nane sun urara ap yaltain uz kit kumira kwatchish. Kutña urarain Diosta paikwarau. Suane maza ampune naztam pĩn kwarɨt nawa izpanzi ish. ");
INSERT INTO kwi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nawa kaizish: “Cornelio. Diosne nu paikumtu aizpa mɨra. Usne nu we mɨjtuza kiwainnamtu nɨjkulta. ");
INSERT INTO kwi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mazara Jope pɨpulura ɨninti, Simónta kanapa. Usne Pedrokas muntɨt. Usne mamaz Simónpa yalta tu. Sun suintam aya sammikane pimakin uz. Pianakane, usne nukasa paranazi.” ");
INSERT INTO kwi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sunkana mamin ɨnintau, nua saina. Nu wat kirɨt an. Mane Diosne aukasa uz. Anpat nua ɨnintu akwa, aune wan Anpat aumɨza kaizta aizpa mɨshipuspas. ");
INSERT INTO kwi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Suasne Pedrone kwinta kit kit kaiznara: —Mane watcha nane Dios wan awara kawarain kinanapa mɨmtus. ");
INSERT INTO kwi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Diosne wan suras awaruzakas Diosta mɨmtuzakas nil kimtuzakas kiwainat kit sapnanazi. ");
INSERT INTO kwi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosne sun pit Israel awawa kwaltuza paranara. Usne watsal pit kainanara, awa Jesucristo akwa Dioskasa kalpain uzanapa. An Anpatne wanta ɨninashimtu. ");
INSERT INTO kwi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Une wan Judea sura chiwazha kirɨt aizpa wat pian. Juanne, munnamtumikane, sun pit awara kainanara. Usne sun pit Galilea sura kainanamɨz kit munana kainnanara. ");
INSERT INTO kwi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Une Dios Jesústa, Nasaret pɨpuluras atmikara, narɨt pian. Usne paiña Sɨnam Izpulta ɨninta, ussa kiwainnapa. An sukin uztuasmin, usne awaruza wat kinat kit ishturuza kakulninnat kit Satanás akwa naizturuza kakulninnara. Dios uskasa chamtu akwa, usne sun kirɨt. ");
INSERT INTO kwi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aune wan Jesús kit aizpa Judea surakas Jerusalén pɨpulurakas iztamakpas. Kwiztane uspane ussa kurish tɨra patpian kit piantaara. ");
INSERT INTO kwi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kutña payu pailtawane, Diosne ussa irɨttas kakulat kit aumɨza izpaninta. ");
INSERT INTO kwi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wan awaruza izpannintachi. Aumɨzain izpaninta. Diosne aumɨza ñamin nanarɨt, us kirɨt aizpa iznapa, sunpa mamaztuza kainanapa. Us irɨttas kakultawane, uskasa kwatmakpas. ");
INSERT INTO kwi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Usne aumɨza ɨninnara, awara Dios pit kainanapa. Diosne Jesústain katsa mikwakana namnintɨt, wan awaruza, irɨttuzakas uztuzakas, ɨninnanapa. Sun pit awaruza kainanaramakpas. ");
INSERT INTO kwi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","An ñancha Diospa kainammtuzne Jesúspa kwinta kiara. Awa Jesústa nɨjkularane, Diosne uspa kwail kiarɨt aizpa wat kulninnanazi, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mama Pedro kwinta kimtuasmin, Sɨnam Izpulne wan paiña pit mɨraruza piznara. ");
INSERT INTO kwi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judío awane, Dios pit nɨjkulturuzne, Pedrokasa aarɨttuzne, iztaspaarɨt, Sɨnam Izpul Judío awachiruza piznarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Katmizna Judío awachiruzne mamaz pit parat kit “Dios kwisha wari” kizara. Judío awaruzne sun mɨara. ");
INSERT INTO kwi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Suasne Pedrone kaiznara: —Aune sun awaruza munnashinamakpas, Sɨnam Izpul usparuza aumɨzakanain piznara akwa. ");
INSERT INTO kwi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Usne usparuza munnanapa ɨninnara, Jesústa nɨjkularɨt akwa. Kwiztane Pedrora paikuaara, uspakasa akkwan payuchikimain tuanpa. ");
INSERT INTO kwi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɨnintaruzkas Judea suras Jesústa piantuzkas Judío awachiruzpa mɨara. Uspane Dios pit piankamat kit Jesústa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro Jerusalén pɨpulura nut kit kailtawane, Judío Jesústa nɨjkulturuzne Pedrora tɨnta aliz kulat kit ");
INSERT INTO kwi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ka mɨmaara: —¿Chitmaka Judío awachiruza ɨt kit iznat kit uspakasa kwara? ");
INSERT INTO kwi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Suasne Pedrone usparuza wan chiwazha kirɨt aizpa kamtanat kit kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nane Jope pɨpulura tuarau. Diosta paikumtuasmin, chiwazha iztau. Nane katsa pĩnkana chiyuras kihshtu iztau. Ampara pĩn punta iptɨt. Na tukin kihshmɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chi wa aizpa iztuasmin, nane ampara mittɨ waj kalpakas ishukas kamtakas chitchukas iztau. ");
INSERT INTO kwi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Diosne nawa kaizzi ish: “Pedro kuhsti. Piantat kit kwat.” ");
INSERT INTO kwi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pedrone sɨnkara: “Anpat. Kumanash. Mizurainkas Dios chiwazha kuanchi kiztu aizpa kwattarakish.” ");
INSERT INTO kwi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Suasne Diosne chiyuras mamasa kwinta kit kit kaizzi ish: “Nune chiwazha Dios sara aizpa kwashina. Dios sarɨt aizpa kwasachish, kizmun.” ");
INSERT INTO kwi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sun kutñakima iztawane, wanne chiyumarain nuara. ");
INSERT INTO kwi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Sun urain kutña ampune Cesarea pɨpuluras na tu yalkin pianazi. Uspane nawa sayara. ");
INSERT INTO kwi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sɨnam Izpulne uspakasa ɨninzi ish, kunkitchiwal. An seis Diosta piantuzkas nakasa ɨara. Wanne awawa yalkin nappanash. ");
INSERT INTO kwi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Usne maza ángelta izta aumɨza kainara. Usne paiña yalta kun kit kaizta: “Awara Jope pɨpulura ɨninti, Simónta akwan. Usne Pedrokas muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Usne Dios pit nua kaiznazi, Dios nuakas up yalkin uztuzakas watsat mɨlnanapa.” ");
INSERT INTO kwi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na usparuza kaiztuasmin, Sɨnam Izpulne usparuza piznara, aumɨza an ñancha piztakanain. ");
INSERT INTO kwi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Suasne Anpat kaizta aizpa ka nɨjkultau: “Watcha Juanne kwazikasa munnanara. Kawarain Sɨnam Izpulne uruza piznanazi.” ");
INSERT INTO kwi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Diosne paiña Sɨnam Izpulta au Anpat Jesucristora piankamturuza mɨlanara. Kawarain Diosne paiña Izpulta an awaruza mɨlanashira, uspakas Jesústa nɨjkulara akwa. Nane “Dios kishimtu aizpa kwail i” kizmanash. ");
INSERT INTO kwi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Suasne Jesústa piantuz Jerusalén pɨpulukin sun pit mɨarawane, puñain paat kit Diosta kwisha wari kizat kit kaizara: —Sunkana Diosne Judío awachiruzakas kiwainamtu, kwail kiarɨt aizpa maizanapa, Diosta kanpanapa, chiyura uzanapa. ");
INSERT INTO kwi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esteban irawane, mɨnpazha Jesústa nɨjkulturuzne Fenicia surakas Chipre surakas Antioquía pɨpulurakas ɨat kit naizmasara. Suane Dios watsal pit Judío awarain kainanara. Mamaz awara kainanarachi. ");
INSERT INTO kwi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mɨnpazha Jesústa nɨjkulturuzne Chipre suraskas Cirene suraskas Antioquía pɨpulura piannat kit Judío awachiruzakas Dios watsal pit au Anpat Jesúspa kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dios usparuza kwisha kiwainnara akwa, akkwanne antikwa pit kamtɨt aizpa chɨhkaat kit Jesústa nɨjkulamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalén pɨpulura wanmakmuruz sun pit mɨarawane, uspane Bernabéra ɨninñara Antioquía pɨpulurakima. ");
INSERT INTO kwi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pianatpane, Bernabéne Dios usparuza wat kiwainarɨt nɨjkul kit kwisha wat kulta. Usne wanta kurunnara, nil uzanapa, Anpatta kwaiyamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabéne wat awa azi. Sɨnam Izpulne ussa pizta. Diosta wat nɨjkulta. Sunkana akkwan awane Jesústa piankamara. ");
INSERT INTO kwi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Suasne Bernabéne Tarso pɨpulura ɨra, Saulora saina. Ussa wanmaltawane, Antioquíara mɨlta. ");
INSERT INTO kwi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Uspane maza año kapal Cristora piantuzpa wanmakmukin tuat kit kwisha akkwan awara kamtanara. An ñancha Antioquía pɨpulukin, awane Jesústa piantuza, Cristora kanpamtuz munnara. ");
INSERT INTO kwi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sun payune mɨnpazha Dios pit kainammtuzne Jerusalén pɨpulukis Antioquía pɨpulura aara. ");
INSERT INTO kwi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mazane, Agabo muntɨtmikane, Jesústa pianmikane, awa paizkakin kun kit Izpul ussa piankamninta aizpa kainanara. “Wan sura kumira pailnazi” kiznara. Claudio katsa mikwa ɨnintuasmin, us kaizta aizpa kirɨt. ");
INSERT INTO kwi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Suasne Antioquía pɨpuluras Jesústa piantuzne pial wantaamɨzta, Judea sura uztuza ɨninna, Jesústa piantuza kiwainanapa. Wanne uspa mɨj aizpakima mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Sunkana kiarawane, uspane sun pial Bernabékasa Saulokasa ɨninñara, Judío ɨlapa ɨnintuza mɨlanapa. ");
INSERT INTO kwi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sun payune Herodesne, katsa mikwane, Jesústa piantuza piznamɨzta, usparuza naizninnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Usne Santiagora, Juanpa aimpihshta, iru kwizkasa piantaninara. Pan kiñakasa kukain pishta taiznapain paka, usne sun kirɨt. ");
INSERT INTO kwi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sun kitpane, Judío awane wat kularɨt. Suasne Herodesne Pedrorakas pizna ɨninta. ");
INSERT INTO kwi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedrora piztawane, ussa kajchira sɨpninta. Ampara suldarune sulmin ussa izamtu pura. Kwiztakas an amparane kutña pijikima, ussa izamtu pura. Pascua pailka, usne ussa chɨhtnash minta, awa ussa piantanapa. ");
INSERT INTO kwi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sunkana Pedro sam kuhtɨt kajchira tuasmin, Diosta piantuzne, wanmakmuruzne, Diosta tɨnta paikuamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes ussa chɨhtachasmin, sun amtain Pedrone paas suldaruwa paizkakin pittɨt tuara. Pamals chihtɨ kuhtɨt tuara. Mamaz suldaruruzne kajchi sɨpmu pɨjtakin izamtu pura. ");
INSERT INTO kwi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Masain maza Anpatpa ángel izpamtuasmin, kajchira kai malta. Usne Pedrora chihtɨkin paat kit izkultat kit kaizta: “¡Kuhsakti azain!” Suasne iru cadenane Pedrowa chihtɨkis chɨhkulta. ");
INSERT INTO kwi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ángelne ussa kaizta: “Pĩn mɨlti. Mittɨ nukmu kuhti,” kizta. Pedro sun kuhtuasmin, ángelne ussa kaizta: “Up kwaksham kwat kit nawa kanpazha.” ");
INSERT INTO kwi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedrone ángelpa kwizpa kajchiras puzta. Usne ángel kit aizpa wat pianchi. Chiwazha iztus minta. ");
INSERT INTO kwi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Uspane paas izmuruzkimin pɨnpailta. Iru pɨjtakin pianamal piannailkane, pɨjtane kain chɨhkularɨt, puzpailna. Pɨpulu miwara ɨkane, ángelne usain mazantain panaij ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Suasne Pedrone nɨjkul kit usmin kaizta: “Nane nawa kit aizpa watcha nɨjkulish. Anpatne paiña ángelta ɨninta, nawa chɨhtnapa, Herodeskas Judío awakas nawa kishiamtu aizpa kiamampa.” ");
INSERT INTO kwi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sun mintuasmin, Pedrone Maríawa yalta ɨra. Sun ashampane Juanpa akkuhsh ara. Juanne Marcoskas muntɨt. Sun yalkin kwisha akkwanne wanmakkara, Diosta paikwan. ");
INSERT INTO kwi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro pianamal pɨjtakin piannapkane, maza ashampa pashpane, Rode muntɨtmikane, mɨntakas izna puzta. ");
INSERT INTO kwi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedrowa pit nɨjkul kit mɨrawane, usne pɨjta chɨhtachi. Wat kul kit ãĩnmin ayukmal naptɨt, Pedro pɨjtakin panamtu kizna. ");
INSERT INTO kwi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Suasne uspane ussa kaizamɨzta: —Pɨrail, kizara. Usne watcha kiznamɨzta. Ussa mɨarachi akwa, uspane kaizara: —Us chi. Paiña izpulmin izta. ");
INSERT INTO kwi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sun kwinta kimtuasmin, Pedrone pɨjtakin piannapmɨzta. Pɨjta chɨhtawane, uspane ussa izat kit ishkuara. ");
INSERT INTO kwi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Usne chihtɨkasa annara, puñain paarɨnpa. Usne Anpat ussa kajchiras chɨhtɨt kainanat kit kaiznara: —Sunta Santiagorakas Diosta piantuzakas kainarain, kiznara. Suasne yaltas puz kit mamaz sumal ɨrɨt. ");
INSERT INTO kwi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kɨnkane, suldaruruzne ishkuat kit chi kirɨt pianchi. Uspane usparuzpain Pedrowa tɨnta kwinta kiamɨzta, mɨnta Pedro ɨrɨt pianchi akwa. ");
INSERT INTO kwi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodesne ɨnninara, ussa saina. Saimanamarɨkane, sun suldaruruza mɨmanara. Suasne Herodesne suldaruruza piantanapa ɨninta. Kwiztane Herodesne Judea sukis puz kit Cesarea pɨpulura uzna ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodesne Tiro pɨpulukin uztuzkasa Sidón pɨpulu uztuzkasa aliz kulnarɨt. Maza mazain usparuzpain nɨjkulat kit Blastora kwinta kin ɨara, usparuza kwainanapa. Blastone Herodespa kiwainmika azi. Blasto akwa uspane Herodeskasa waya kimanpa paikuara, kalpain uzanapa. Herodespa sukin kumira wa akwa, uspane sun sukin kumira paina ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodesne narɨt payura watsal pĩn kwat kit kwash ɨninmikawa uzmukin uz kit usparuza watsal pit kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Suasne wanmakmuruzne kwianamɨzta: “Sun parammikane ampukanachi. Usne dioskana paramtui,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sun urain Anpatpa ángelne ussa imtu kininta, Herodes “Dios wari” kiztachi akwa. Suasne puil ussa kwat kit ira. ");
INSERT INTO kwi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sun payuin akkwan awane pailta sura Dios pit piankamamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ɨnintaruza pial chɨhkarawane, Bernabékas Saulokas Jerusaléntas kailpail kit Juanta, Marcos muntɨtmikasha mɨlpailta. ");
INSERT INTO kwi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mane Dios pit kainammtuzkas kamtamtuzkas Jesústa piantuzkasa Antioquía pɨpulura wanmakkara. Bernabékas tuara. Simónkas, tɨlapat muntɨtmikakas, tuara. Luciokas Cirene suras tuara. Manaénkas, Herodeskasa Galilea sura kawiatmikakas, tuara. Saulokas tuara. ");
INSERT INTO kwi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Anpat iztakin wanmakkat kit paikuamtuasmin, maza payura kumira kuarachi. Suasne Sɨnam Izpulne kaiznara: “Bernabérakas Saulorakas paimpa ɨnintain, na ɨninta aizpa kal kianapa,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Suasne Diosta paikuarawane, kumira kuarawane, wanmakmuruzne usparuza chihtɨ panat kit “watmin ɨilnaka” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kwiztane Sɨnam Izpul usparuza ɨnintawane, Bernabékas Saulokas Seleucia pɨpulura ɨilta. Tas katsa kanuara waat kit Chipre pi paizka sura ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina pɨpulura pianailtawane, uspane Judío kammu yalta Dios pit kamtanamɨzta. Juankas usparuza kiwaina ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wan pi paizka sukin ɨiltawane, Pafos pɨpulura piannailta. Sua uspane maza Judío awara wanmakpailta. Usne Barjesús munta. Usne tañu kinammika azi. Nane Diospa kainammika ish kiztakas, pɨrail kaizta. ");
INSERT INTO kwi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","An tañu kimikane, Sergio Paulokasa, sun sukin mikwakasa tuazi. An mikwane wat minta. Mikwane Bernabérakas Saulorakas akwanpa ɨninta, Dios pit mɨshimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Elimasne, tañu kim muntɨtmikane, tuara. Usne usparuzkasa nɨjkultachi. Usne uspa kaizta aizpa kancha kainara, Sergio Paulo ɨnintuz kaizta aizpa mɨmanpa. ");
INSERT INTO kwi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulone Pablokas muntɨt. Suasne Sɨnam Izpul ussa piztuasmin, Pablone Elimasta tɨnta iz ");
INSERT INTO kwi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kit kaizta: —Nune Diablowa kwalkana i. Nune wattuza aliz i. Nune kwisha akkwan kwail kishimtu. Nune Anpat kamtara aizpa maizshira, us kaiztu aizpa pɨrail i kiznapa. Sun kimun. ");
INSERT INTO kwi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mane Anpatne nua ilnazi. Akkwan payukima izmananazi, pa izmanpa, kizta. Sun urain paiña kasu izsachi parɨt. Usne kai izmanamta. Usne mamazta saira, paiña chihtɨra tain ɨnpa, izsachi akwa. ");
INSERT INTO kwi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mikwa sun kit aizpa izkane, usne Diosta nɨjkulta. Usne Anpatpa kamtampa iztasparɨt. ");
INSERT INTO kwi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablokas paiña izmuruzkas Pafos sukis ɨat kit kanuara waat kit Panfilia sura ɨara, Perge pɨpulurakima. Juanne usparuztas tɨwij ɨnat kit Jerusalén pɨpulura kailta. ");
INSERT INTO kwi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kwiztane uspane Pergekis Pisidia sura pɨnara, mamaz Antioquía pɨpulurakima. Suane uspane kwaizkulmu payura Judío kammu yalta nap kit uzpailta. ");
INSERT INTO kwi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Suasne Moisés parɨt aizpakas Diospa kainammmika parɨt aizpakas izarawane, kammu yalpa ɨninmikane mazara ka kaiznapa ɨninta: —Aimpihshtuz, mɨrain. Chiwazha pit awaruza kurunnamtune, ma pararain. ");
INSERT INTO kwi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Suasne Pablone kun kit chihtɨkasa anak kit puñain paikwat kit kaiznara: “Israel awa mɨrain. Israel awachiruzkas Diosta piantuzkas nawa mɨzhain. ");
INSERT INTO kwi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel kwaltuzne Diosta wakpuj wainñara. An Diosne au Israel kwaltuza nanara, akkwan usparuza kawinana. Egipto sura mamaz awakana uzasmin, kwiztane usne usparuza tɨnta kiwainara, an sukis ɨanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Usne usparuza pul sura kiwainat kit usparuza cuarenta añokima tailchanara. ");
INSERT INTO kwi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Usne wan Canaán sura uztuza piantaninnara, au an ñancha kwal uspa su sappanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ampara cien año cincuenta añokasa pailtawane, uspane sun su sappara. Kwiztane Diosne ɨnintuza ɨninnara, Israel awaruza ɨninnanapa, Samuel, Diospa kainammmika amtu payukima. ");
INSERT INTO kwi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Suasne uspane an katsa mikwara Diosta paikuara, usparuzpain ɨninnanapa. Suas Diosne Saúlta nara, usparuza ɨninnanapa cuarenta añokima. Usne Cispa painkul azi. Usne Benjamínpa kwal azi. ");
INSERT INTO kwi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kwiztane Diosne Saúlta kwairɨt, ɨninnamanpa. Davidta mikwa namnin kit nat kit kaizta: ‘Nane Davidta, Isaípa painkulta, narɨt ish. Usne wat awa i. Usne na ɨnintu aizpa kinazi.’ ");
INSERT INTO kwi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Davidne Jesúspa pampa ɨlapa azi. Diosne Israel awara sun kin namta, Jesús usparuza watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús atchasmin, Juanne wan Israel awara kainanat kit kaiznara: ‘U kwail kiarɨt aizpa maizat kit munnintain.’ ");
INSERT INTO kwi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Irachasmin, Juanne kaiznara: ‘¿U nawa chi minpuspas? Nane Cristo chish. Mazane nakin anza katsamika ap kwizpa anazi. Nane ussa kiwainmumikakana ish, paiña mittɨ nukmu ukna,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ap Israel aimpihshtuz, mɨrain. Une Abrahampa kwal mai. Israel awachiruzkas Diosta piantuzkas, mɨrain. Diosne pailta awaruza an pit kainanara, usparuza watsat mɨlnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalénta uztuzkas uspa ɨnintuzkas Jesústa piankamarachi. Dios kainammtuz kaizara aizpa mɨarachi. Pailta kwaizkulmu payura Dios pit pɨnkɨh izarakas, uspane mɨarachi. Sunkana Jesústa kwainñamtuasmin, uspane Dios kainammtuz kaizara aizpa kiara. ");
INSERT INTO kwi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesús kwail kitchikas, uspane piantaashit kit Pilatora paikuara, ussa piantaninnapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Suasne Jesúspa Dios pɨnkɨhta para aizpa pailtawane, uspane kurishtas tain kihshat kit uk kulta kamara. ");
INSERT INTO kwi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Diosne ussa irɨttas kakulninta. ");
INSERT INTO kwi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Akkwan payurakima Jesúsne Galilea suras kanpamtuzakas Jerusalén pɨpuluras kanpamtuzakas izpanara. Uspain Israel awaruza uspa izarɨt aizpa Jesúspa kainaamtu. ");
INSERT INTO kwi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Sunkana aune Dios watsal pit uruza kainapuspas. Diosne au ñancha kwaltuza sun watsal pit kwinta kin namnara. ");
INSERT INTO kwi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Aune uspa kwal makpas. Mane Jesústa irɨttas kakulnintawane, Diosne auruza kin namta aizpa kirɨt. Paas kanta pɨnkɨhta ka parɨt: ‘Nune ap painkul i. Mane nane nua kawirau.’ ");
INSERT INTO kwi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diosne ussa irɨttas kakultu aizpa kainarɨt, mamasa imanpa. Dios pɨnkɨhta ka parɨt: ‘Nane Davidta sun wat kin namta aizpa uruza mɨlananash.’ ");
INSERT INTO kwi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Katmizna mamaz kanta pɨnkɨhta ka parɨt: ‘Nune up pashimtumikasha paiña ña pɨtninmanazi.’ ");
INSERT INTO kwi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dios kaizta aizpa kainarawane, paiña kwaltuza kiwainnarawane, Davidne irɨt. Usne papihsh kamkin kamat kit paiña ña pɨttɨt. ");
INSERT INTO kwi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dios Jesústa kakulninta akwa, paiña ña pɨttachi. ");
INSERT INTO kwi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Aimpihshtuz, mɨrain. Une Jesús kit aizpa piankamarawa. Aune Jesús akwa Dios u kwail kirɨt aizpa kaninshina kainapuspas. ");
INSERT INTO kwi_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Diosne Jesústa nɨjkulturuza, us kaizta aizpa mɨraruza uspa kwail kirɨt aizpa wat kulnashina. Diosne Moisés ɨninta aizpa kiamturuza uspa kwail sɨnam sanamanazi. ");
INSERT INTO kwi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Katmizna, kuiraruin, u Dios kainammmika kaizta aizpa naizamanpa. Uspane ka kizara: ");
INSERT INTO kwi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mɨrain. Une Dios kaizta aizpa kwail i kizamtu. Une iztaspaat kit ianazi. Nane Dios ish. U uzamtuasmin, nane chiwazha iztasparɨt kal kinash. Na u iztakin iztasparɨt kal kimtukas, une nɨjkulamanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablokas paiña izmuruzkas Judío awa kammu yaltas puzarawane, Judío awachiruzne usparuza ka paikuara: “Mamaz kwaizkulmu payura aumɨza sun kamtanaka.” ");
INSERT INTO kwi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wanmakmuruz Judío kammu yalkis puzarawane, akkwan Judío awaruzkas Judío awakana namtɨttuzkas Pablorakas Bernabérakas kanpaara. Dios usparuza pashinamtu. Kamtanamtuasmin, uspane usparuza kurunnara, Diosta kanpaanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mamaz sábado payura, kwaizkulmu payura, pɨpuluras awane, mɨza wan chiwal wanmakkara, Dios pit mɨana. ");
INSERT INTO kwi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judío awa kwisha akkwan awaruza iztawane, uspane Pablora aliz kulat kit pashiarachi. Pablo kaizta aizpa nil chi kizamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Suasne Pablokas Bernabékas tɨnta namat kit kaiznara: —Aune Dios pit Judío awaruza an ñancha kainanarawash. Une sun watsal pit mɨashimtuchi. Katmizna une mizurainkas pailta payukima chiyura uzamanazi. Mane aune Judío awachiruza ɨiznapas, Dios pit kamtanana. ");
INSERT INTO kwi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mikwane sun pitkasa aumɨza ɨninat kit kaizta: “Nane nua kai malmukana mamaz awaruza ɨninnarau, wan suras awaruza watsat mɨlnanapa,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sun mɨamtuasmin, Judío awachiruzne wat kulat kit Anpatpa pit kwisha wari kizamɨzta. Dios narɨttuzne Dios pit mɨat kit nɨjkulara, chiyura pailta payukima uzanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sunkana uspane Anpatpa watsal pit wan sura uzturuza kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Suasne Judío awaruzne sun pɨpuluras kwazpa ashamparuzakas kwazpa ampuruzakas wanmakkat kit kwinta kinara, Pablokasa Bernabékasa waya kianapa, uspa sukis ɨanapa. ");
INSERT INTO kwi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Suasne uspane mittɨ nukmu pul pil ulpian kit uspa kwail awakana mai annara. Suasne Iconio pɨpulura ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesústa kammuruzne kwisha wat kulara. Sɨnam Izpulkas usparuza piznara. ");
INSERT INTO kwi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio pɨpulukin Pablokas Bernabékas sulmin Judío awakasa kammu yalta nappailta. Kwinta kitpane, akkwan Judío awaruzkas Griego awaruzkas Dios pit mɨat kit nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judío awa mɨashimtuchiruzne Judío awachiruza kwinta kinara, Jesústa piantuzpa kwail minñanapa. ");
INSERT INTO kwi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Suain akkwan payurakima tut kit ishkwatchin Anpatpa pit kwinta kiilta. Anpatne usparuza kiwainnara, awa uspa kaizta aizpa piankamanapa. Uskas usparuza akkwan tuntu iztasparɨt kal kinpa kiwainnara. ");
INSERT INTO kwi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Akkwan pɨpulukis awaruzne nɨjkularachi. Mɨnpazha Judío awakasa nɨjkulara. Mamaztuzne Dios ɨnintaruzkasa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Suasne Judío awakas Judío awachiruzkas uspa ɨninturuzkas nɨjkulara, usparuza kwail kizana, uk kiana. ");
INSERT INTO kwi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sun piankamarawane, pizamasakane, Pedrokas Bernabékas Licaonia surakas, mamaz kasha surakas, ɨilta, Listra pɨpulurakimakas, Derbe pɨpulurakimakas. ");
INSERT INTO kwi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Akkwan surakima uspane Dios watsal pit kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra pɨpulukinne maza ampune, chasachimikane, tuara. Ka kawirɨt akwa, sua uzara. Usne mizurainkas chatchi. ");
INSERT INTO kwi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Sun ampune Pablo kaizta aizpa mɨmtuara. Pablone ussa iz kit us nɨjkultu aizpa piankamta. Usne ka minta: “Usne nawa wat kakulninshinasa,” minta. ");
INSERT INTO kwi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Suasne Pablone tɨnta ka kaizta: —Kuhsak kit mittɨ nil kunti, kizta. Sun ampune tizak kit chamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Akkwan awane Pablo kit aizpa izat kit Licaonia pitkasa ka kwianamɨzta: —Diostuz awakana namarɨt. Uspane kwashtas aumɨza taizara, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Uspane Bernabé “Zeus dios i” munara. Pablo akkwan kwinta kit akwa, usne “Hermes dios i” munara. ");
INSERT INTO kwi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeuspa pariyane pɨpulu napmukin paiña wanmakmu yal mɨjara. Usne wakara ampuruzkas kwisha akkwan wishkas karara. Usne awakasa wakara ampuruza uspa akwa piantashit kit usparuza wakpuj wainñashimtuara. ");
INSERT INTO kwi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sun nɨjkultazasmin, Pablokas Bernabékas uspa pĩn pihshailta, uspa kiamtu aizpa watchi piankamanapa. Awaruzpain nappail kit kwianara: ");
INSERT INTO kwi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Awaruz, ¿Chikishma sun kipus? Aune ampu ukanain makpas. Aune at kit Dios watsal pit kainammpuspas, u sun kiamtu aizpa chɨhkanapa. Chiwal palichi. U kiamtu aizpa chɨhkat kit Dios chiyura uzmikasha mɨat kit kanparain. Usne wan sara. Chiyukas pilkas pikas wan chiwal sara. ");
INSERT INTO kwi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","An ñamin Diosne pailta awara chɨhkanara, uspain miwara naat kit chaanapa. ");
INSERT INTO kwi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mizurainkas usne aumɨza chɨhkanarachi. Dios wat aumɨza kinamtu akwa, usne aumɨza wat kinamtu, ussa piankamanapa. Diosne alukas chiyuras kininta, pippa pakkuwiznapa. Usne uruza akkwan kumira kwinnara, kuanpa, wat kulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sun wan kwinta kitkas, awane mama uspa akwa wakara piantashiara, usparuza wakpuj wainñanapa. ");
INSERT INTO kwi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Suasne mɨnpazha Judío awaruz Antioquía pɨpuluraskas Iconio pɨpuluraskas piannaakane, uspane uspa minñamtu aizpa maizara. Suasne uspane Pablora uk kiara. Us irɨt minñamtu akwa, uspane ussa tain kit kɨninaara pɨpulu pianamalkima. ");
INSERT INTO kwi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jesústa piantuz Pablo tukin wanmakkarawane, Pablone kuhsak kit mamasa pɨpulura napta. Tɨlawara usne Bernabékasa Derbe pɨpulura ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dios pit kainanarawane, akkwan Derbe pɨpulura uztuzne Jesústa piankamara. Kwiztane uspane Listrarakas Iconiorakas Antioquíarakas kailtailta. ");
INSERT INTO kwi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Uspane wan surakima Jesústa piantuza kwisha kiwainat kit kurunara, Jesústa wat nɨjkulamɨznapa, us kaizta aizpa mɨanapa. Dios ɨnintukin nappashimturuzne kwisha naizarɨnazi kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Uspane ɨlaparuza nanara, wan pɨpulura wanmakmukin Dios pit kamtananapa, Diosta piantuza kurunnanapa. Kumira kumtuchiasmin, Diosta paikuat kit Jesústa nɨjkulturuza kurunara, Anpatpa miwara ɨanapa. ");
INSERT INTO kwi_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia sukimin pɨnpailtawane, Panfilia sura pianailta. ");
INSERT INTO kwi_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge pɨpulukin uzturuza sun pit kainanarawane, uspane Atilia pɨpulura kihshtɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Suane kanuara wail kit Antioquía pɨpulura ɨilta. Sun pɨpulukin an ñamin Jesústa piantuzne Diosta uspa akwa paikuara, Dios usparuza kiwainanapa. Suasne uspane paasta sun kal kinpa ɨninñara. Mane uspa kal kapal wan kirɨt. ");
INSERT INTO kwi_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquía pɨpulura piannailtawane, uspane wanmakmuruza wanmakninñara, Dios yawa usparuza kiwaintɨt aizpa kainananapa. Uspane Judío awachiruzkas Jesústa nɨjkularɨt kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Suane Pablokas Bernabékas Cristora kanpamtuzkasa akkwan payukima nukkulpailta. ");
INSERT INTO kwi_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sun payune mɨnpazha Judea sukis Antioquía pɨpulura attuzne Diosta piantuza kamtanamɨzta. Uspane ka kaiznara: “Moisés ampu pashpa aya tɨt kit circuncisión kiarawa kizara.” Moisés ɨninta aizpa kimtukine, Diosne uruza watsat mɨlnamanazi kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sun akwa, Pablokas Bernabékas uspakasa tɨnta kwinta kiara. Suasne wanmakturuzne Pablorakas Bernabérakas mɨnpazharakas nanara, Jerusalén pɨpulura ɨanapa, ɨnintaruzkasakas iglesiaras ɨlaparuzkasakas sunpa parananapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquía pɨpuluras wanmakmuruzne usparuza ɨninñara. Fenicia suwarainkas Samaria suwarainkas pɨnamtuasmin, uspane Judío awachiruz antikwa pit mɨara aizpa chɨhkarɨt kwinta kiara, Diosta kanpaanapa. Sun pit mɨarawane, wan Cristora piantuzne watsal kulara. ");
INSERT INTO kwi_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablokas Bernabékas Jerusalén pɨpulura piannailtawane, wanmakmuruzkasakas ɨnintaruzkasakas ɨlaparuzkasakas wanmakkat kit Dios kit aizpa usparuza kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mɨnpazha Fariseo awaruzne, Jesústa nɨjkulturuzne, nil kuhspanak kit kaizamɨzta: —Judío awachiruzne, Jesústa nɨjkulturuzne, wan Moisés ɨnintɨt aizpa kiarawa. Uspane uspa ampu pashparuza circuncisión kiarawa, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Suasne ɨnintaruzkas ɨlapa ɨnintuzkas wanmakkara, sun pit iz kit piankamana. ");
INSERT INTO kwi_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kwisha kwinta kiarawane, tɨnta mɨmarawane, Pedrone kuhs kit usparuza kaiznara: —U Diosta piantuz, mɨrain. Une ñamin Dios uruztas nawa narɨt pian. Suasne Diosne nawa ɨninta, Dios watsal pit Judío awachiruza kainananapa, Anpatta nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Diosne wan awa kaijchukin minñamtu aizpa pian. Diosta pashinamturuza nanat kit Sɨnam Izpulta ɨninta, usparuza aumɨzakanain piznanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Usne aumɨzakas usparuzakas kawarain kinarɨt. Uspa Diosta nɨjkularɨt akwa, Diosne uspa kwail kiarɨt aizpa sɨnam kwizninnarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mane, ¿Une Dios Judío awachiruza sun kianapa ɨninshimtumakkiwas? Une usparuza ɨninnasachi, chiwazha anza sam kianapa. Aukas au an ña kwaltuzkas sun kitsachimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sunkana kiman. Aune Dios Jesús akwa aumɨza watsat mɨlnamtɨt nɨjkultamakpas. Kawarain Diosne usparuza pashinat kit watsat mɨlnara. ");
INSERT INTO kwi_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Suasne wanne puñain paat kit Bernabékas Pablokas kwinta kit aizpa mɨara. Uspane Dios chiwazha watsal iztasparɨt kal kiarɨt aizpa Judío awachiruz iztakin kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kwinta kitpane, Santiagone kaiznara: —U Diosta piantuz, mɨzhain. ");
INSERT INTO kwi_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedrone miza Dios Judío awachiruza ñamin kiwainara aumɨza kainanara. Diosne usparuza nanara, paiña kwalkas namanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dios pit kainammtuz pararawane, uspane sun kwinta kiara. Dios pɨnkɨhkin ka para: ");
INSERT INTO kwi_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Sun kitpane, nane mamaz payura kailnash, mɨnpazhara, David mikwarakana, uzninnapa. Mazara, Davidpa kwalkis kakulninnash. Nukkultɨtmikasha mamasa kakulanash. Nane kail kit Jesústa kakulninnash, ");
INSERT INTO kwi_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","wan nukkultaruzkas wan Judío awachiruzkas Anpatta sayanapa, Diosta piantuzkasa wanmakkanapa, usparuza ɨninnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Anpatne, an ñamin kaiztamikane, sunkana paiña pit kaiz kit awaruza piankamninnara.” ");
INSERT INTO kwi_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Katmizna Santiagone min kit ka kurunnamɨzta: Aune Judío awachiruza, Diosta piantuza, tɨnta ɨnintachiwamakpas, Moisés Judío awaruza ɨnintɨt aizpa mɨanapa. Mane uspane ñamin nɨjkularɨt aizpa chɨhkaarawa, Diosta kanpaana. ");
INSERT INTO kwi_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Aune usparuza ka parawamakpas: “Awakanain iztɨt sarɨtta tɨra kumira unatne, kuman. Kasarakirɨtne mamaz ashampara sanachi. Kawarain ashampane mamazpa ampukasa pitsachi. Chiwazha tɨt kuhtɨt kalpa irane, aimpi puztakine, ña kuman. Kalpa pi kwarɨtne, kuman. Aimpikas kuman.” ");
INSERT INTO kwi_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ñamin mɨnpazhane pailta kwaizkulmu payura Moisés kamtamtu aizpa iz kit wan pɨpulura wan kammu yalta kamtanara. ");
INSERT INTO kwi_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Suasne ɨnintaruzkas wan ɨlaparuzkas wan wanmakmuruzkasa mɨnpazharuza usparuztas naat kit Antioquía pɨpulura ɨninnara Pablokasakas Bernabékasakas. Uspane Judas, Barsabás muntɨtmikashakas, Silastakas ɨninñara. An paasne aimpihshtuztas katsa namtɨt. ");
INSERT INTO kwi_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Uspane uspakasa sun pɨnkɨh ɨninñara: Aune, ɨnintaruzkas, ɨlapa Diosta piantuzkas Judío awachiruzakas Antioquía pɨpulura uztuzakas Siria sura uztuzakas Cilicia sura uztuzakas “kakishapu” kizpuspas. ");
INSERT INTO kwi_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mɨnpazha auruztas ɨarakas, aune usparuza ɨninnarachimakpas. Uspane uruza uspa pitkasain kwail kizappat kit naaninnara, uspa Moisés kamtɨt aizpa mɨanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Katmizna au wanne nɨjmin kit mɨnpazharuza auruztas nanaramakpas, uruza izna ɨanapa. Uspane, au paas wat aimpihshtuzkas, Bernabékas Pablokas, ɨanazi. ");
INSERT INTO kwi_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Awa usparuza piantashiarakas, au Anpat Jesucristone usparuza wat kiwainara. ");
INSERT INTO kwi_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sun akwa, aune Judastakas Silastakas uruza ɨnintamakpas, uspa pitkasa sunpa kwinta kianapa, u sun pɨnkɨh para aizpa piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sɨnam Izpulkas aukas nɨjminmakpas, au uruza sunmin kuruntu aizpa kianapa. Aune uruza chinkas ɨninmanash. ");
INSERT INTO kwi_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Awakanain iztɨt sarɨtta tɨra ña unarɨtne, kuman. Kawarain aimpikas kuman. Chiwazha kalpa tɨt kuhtɨt aimpi puztakine, ña kuman. Kasarakirɨtne, mamaz ashampara sanachi. Kawarain ashampane mamazpa ampukasa pitsachi. Au kaizta aizpa kitne, une wat aizpa kianazi. Watmin ɨanaka. ");
INSERT INTO kwi_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sunkana kiztawane, uspane masain ɨat kit Antioquía pɨpulura piannaara. Suane uspane wanmakmuruzkasa wanmakkat kit pɨnkɨh chɨhkaara. ");
INSERT INTO kwi_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aimpihshtuz pɨnkɨhta izarawane, kwisha wat kulara, sun pɨnkɨh usparuza kiwainara akwa. ");
INSERT INTO kwi_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judaskas Silaskas Dios kainammmika tuasmin, uspane akkwan payukima uspa pitkasain Diosta pianturuz Dios pit kamtanat kit tɨnta kiwainnara, tɨnta namanapa. ");
INSERT INTO kwi_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sua akkwan payu pailtɨkane, aimpihshtuzne usparuza “ɨru” kiznara. “Watmin ɨanaka” kizkane, uspane ɨnintaruzpara kaiyara. ");
INSERT INTO kwi_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasmin mama suain nukkulta. ");
INSERT INTO kwi_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablokas Bernabékas mamaz akkwan awakas Antioquía pɨpulura nukkulara. Uspane awaruza kamtanamɨz kit Anpatpa pit kainanamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Akkwan payu taiztawane, Pablone Bernabéra kaizta: —Wan pɨpulura ñamin ɨarɨttain kailmɨzpai, Diosta piantuza iznana. Anpatpa pit mɨraruza ɨmɨzpai, usparuza mamasa kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabéne Juanta uspakasa mishira. Usne Marcoskas muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablone ussa mishitchi, Panfilia pɨpulura usparuza tɨwij ɨt akwa, uspakasa mama kal kiwaintachi akwa. ");
INSERT INTO kwi_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tɨnta kwinta kiarawane, tɨnta pilchapuzarawane, uspane paimpa paimpa ɨilta. Bernabéne Marcosta mit kit kanuara waat kit Chipre sura ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablone Silasta nara, uskasa ɨn. Aimpihshtuzne uspa akwa Diosta paikuara, Dios usparuza kiwainapa. Sun kitpane, ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Uspane Siria suwarakas Cilicia suwarakas pɨnpailta, wanmakmukin izmuruza kamtailnapa, Dios pit an wat piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Derbe pɨpuluwara pɨntawane, Pablone Listra pɨpulura piannara. Suane usne mazakasa, Timoteo muntɨtmikakasa, wanmalta. Usne Dios pit nɨjkulta. Paiña Judío awa akkuhshne Jesústa nɨjkultumika azi. Paiña papihshne Griego awa azi. ");
INSERT INTO kwi_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jesústa piantuz Listra pɨpulura uztuzkas Iconio pɨpulura uztuzkas us akwa wat kwinta kiara. ");
INSERT INTO kwi_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablone Timoteora kanpazha kizta. Judío awa sun sura uzara akwa, Pablone paiña aya tɨtnin kit circuncisión kira. Uspane Timoteowa papihsh Griego awa azi pian. Sun Griego awane sun circuncisión kitchi. ");
INSERT INTO kwi_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Wan pɨpulura pɨnamtasmin, uspane Jesústa piantuza ɨnintaruz nɨjkularɨt aizpa kamtanara. Jerusalén pɨpuluras ɨlapa ɨnintuz kaizara aizpa kamtanara, wan wat mɨanapa. ");
INSERT INTO kwi_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sunkanane wanmakturuzne an nil kiat kit an wat nɨjkulara. Jesústa piantuzne pailta payu an akkwan wanmakkamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Sɨnam Izpulne Pablorakas paiña kanpamtuzakas Asia sura Dios pit kainana ɨninnarachi. Frigia suwarakas Galacia suwarakas pɨntawane, ");
INSERT INTO kwi_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","uspane Misia sumamin pianaara. Bitinia sura napna minñakane, Jesúspa Izpulne usparuza napninnarachi. ");
INSERT INTO kwi_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Suasne Misia suwara pɨnat kit Troas pɨpulura pimara kihshara. ");
INSERT INTO kwi_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Suane Pablone amtawara chiwazha kainkizpara. Maza Macedonia suras awane ussa izpanta. Usne kun kit Pablora paikwat kit kaizta: “Macedonia sura anka, aumɨza kiwainnapa,” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo kainkizparawane, nane, Lucasne, Pablokasa wan watsaiznash, Macedonia sura ɨn. Aune Dios aumɨza ɨninta pianaiznash, Dios watsal pit kainanana. ");
INSERT INTO kwi_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aune Troaskis kanuara nil ɨaiznash, Samotraciara pi paizka sura piannan. Tɨlawara Neápolis pɨpulura pianaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Suas Filipos pɨpulura ɨaiznash. An pɨpulune Macedonia sukin anza katsa azi. Akkwan Roma pɨpulukis awaruzne sua uzara. Suane akkwan payuchikimain tumanash. ");
INSERT INTO kwi_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Aune kwaizkulmu payu pɨpulukis pianamal puziznash pirakima, awa wanmakmukin piannan. Sua awane Diosta paikumkin ɨara. Sua aune uz kit ashampa wanmaktɨttuza Dios watsal pit kwinta kianash. ");
INSERT INTO kwi_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Maza ashampane, usparuztas Lidia muntɨt. Usne Tiatira pɨpulukis at kit sam ishtam pĩn paininmika azi. Sun ashampane Diosta wakpuj wain kit paikwara. Uspa kaizara aizpa mɨra. Anpatne ussa kiwainta, Pablo kamta aizpa nɨjkulnapa. ");
INSERT INTO kwi_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sun ashampakas paiña kwalkas munnarawane, usne aumɨza paikwat kit kaizpailnash: —Nawa nil Anpatta nɨjkultamika ish minñamtune, ap yalta uznarain, kiznara. Usne aumɨza nukkulninpailnash. ");
INSERT INTO kwi_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Maza payune Diosta paikumkin au ɨamtuasmin, aune saliz piztɨt kiwaim ashampara wanmalaiznash. Salizne ussa kiwainta, iznakulan. Us iznakulamtu akwa, paiña anpattuzne akkwan pial kana kiara. ");
INSERT INTO kwi_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","An nimpihsh ashampane Pablorakas aumɨzakas kanpat kit kwian kit saliz akwa ka kaizta: —An ampuruzne an katsa Diosta kiwainñamtu. Uspane usparuza sun pit kainanamɨztu, Dios uruza watsat mɨlnanapa, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nimpihsh ashampane sunkana kira akkwan payukima. Piztɨt ashampa ussa naizninta akwa, minpara Pablone salizta kaizta: —Jesús nawa kiwaintu akwa, nane nua puznintus, ashamparas puznapa. Sun urain salizne ustas tɨwij ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ashampara pamikaruzne ka minñat kit nɨjkulara: “Saliz puztɨt akwa, aune an ashampakasa an pial kana kisachimakpas.” Sun minñarawane, uspane Pablorakas Silastakas pizat kit pɨpulu ɨnintuza nankin mɨlara. ");
INSERT INTO kwi_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Uspane usparuza katsa mikwawakin karat kit kaizara: —An awaruzne aumɨza kiwainamtuchi. Auruzpain pilchapuzamtu. Aumɨza paimpa naiyamtu. An ampuruzne Judío awa mai. ");
INSERT INTO kwi_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Aune Roma awa makpas. Aune uspa kamtara aizpa sapsachimakpas. Uspa kamtara aizpa kisachimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Suasne awane usparuza aim kiamɨzta. Katsa mikwane pĩn uknapa ɨninnara, tɨkasa pianna. ");
INSERT INTO kwi_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kwisha aim kiarawane, kajchira sɨppat kit kajchi izmumikasha usparuza kwisha wat izanapa ɨninta. ");
INSERT INTO kwi_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Sunkana kizkane, kajchi izmumikane usparuza anza ayukmal sɨpnat kit mittɨ tɨkulta nukninta. ");
INSERT INTO kwi_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kakwamta panakima Pablokas Silaskas Diosta paikwamtuaiyasmin, Diosta kanta kiztuaiyasmin, mamaz sɨptɨt waruzne mɨara. ");
INSERT INTO kwi_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Suasne masain su ulmu amɨzta. Kajchi yal saktɨ kwisha tɨnta ulmalta. Sun urain wan pɨjta azkulara. Wan cadena kuhtɨttuz sɨpnaruza chɨhtkul kit taizara. ");
INSERT INTO kwi_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Sun kirɨkane, kajchi izmumikane sun kit aizpa izkulta. Kajchi pɨjta chɨhtkulara iztawane, usne paiña mashti pizta, usmin piantana. Maza sɨptɨtmika kajchiras puzkane, paiña mikwane, ussa kajchi izmumikasha, piantashina. Usne wan sɨptɨttuz kajchira waruza chɨhtaraka minta. ");
INSERT INTO kwi_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablone ussa kwianta: —Nua kwail kimun. Wan akki puramakpas. ");
INSERT INTO kwi_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Suasne izmumikane impil paikwat kit kajchira ayukta ãĩn ɨt kit napta. Ul kit ishkumtuasmin, Pablo tukinkas Silas tukinkas wakpuj wainta. ");
INSERT INTO kwi_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Usne usparuza tas ukkanat kit mɨmara: —Anpattuz. ¿Chima kinpai, Dios nawa watsat mɨlnapa? ");
INSERT INTO kwi_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Uspane sɨnkailta: —Anpat Jesucristora nijkultane, Diosne nua watsat mɨlnazi. Up kwaltakas watsat mɨlnanazi, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pablokas Silaskas Anpatpa pit ussakas paiña yalkin uztuzakas kaizpailta. ");
INSERT INTO kwi_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sun amtain izmumikane usparuza mamaz pɨjtamal mɨlnara, aim kirɨt kitna. Suasne uspane ussakas paiña kwaltakas munnanara. ");
INSERT INTO kwi_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kwiztane paiña yalta mɨlnat kit kumira kwinara. Uskas paiña kwaltuzkas kwisha wat kulara, Diosta nɨjkulara akwa. ");
INSERT INTO kwi_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tɨlawain tɨlawara mikwane policíaruza kajchi izmumikasha ɨninnara, paasta chɨhtnanapa. ");
INSERT INTO kwi_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Suasne kajchi izmumikane Pablora ɨt kit kaizta: —Mikwane nawa ɨninziish, umɨza chɨhtnapa. Une puzshinai, puñain ɨilnapa. ");
INSERT INTO kwi_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablone policíaruza kaiznara: —Mikwane aumɨza wan iztukin tɨkasa piannara. Au Roma pɨpulukis awa akwa, uspane amɨza sunkana kinchi. Aumɨza kwail kizarachasmin, uspane aumɨza kajchira sɨpparɨt. Mane uspane puintain aumɨza chɨhtashimtu. Sunkana kiasachi. Uspain anpa, aumɨza puzninnapa, kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Policíane mikwaruza sun kainanara. Roma pɨpulukis awara ilta akwa, uspane ishkuat ");
INSERT INTO kwi_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","kit Pablorakas Silastakas ɨara, sun kwail kiarɨt kizna. Suasne kajchira aat kit usparuza paikwaara: “Pɨpulukis ɨrain.” ");
INSERT INTO kwi_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kajchiras puzpailtawane, Pablokas Silaskas Lidiawa yalta ɨilta. Izmuruza iznarawane, wantuza wat kiwaintawane, pɨpulukis puz kit ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anfípolis pɨpulukimin Apolonia pɨpulukimin pɨnpailtawane, Pablokas Silaskas Tesalónica pɨpulura piannailta, Judío awa kammu yalkinkima. ");
INSERT INTO kwi_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablone kammu yalta sunkana kamtɨt kamtanamɨzta. Kutña domingokima pailta kwaizkulmu payura uspakasa kwinta kinat kit Dios pit kamtanara. ");
INSERT INTO kwi_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Usne Dios pit iz kit usparuza piankamninara: “Cristo naiznatkin. Irawane, mamasa kakulnatkin.” Ka kaiznara: “Sun Jesúsmin uruza na kaiztu aizpa Dios ɨnintamika i.” ");
INSERT INTO kwi_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Suasne mɨnpazha Judío awane Jesústa nɨjkulat kit Pablorakas Silastakas wanmakkara. Akkwan Griego awa Diosta wakpuj wainturuzkas akkwan kwazpa ashampa wat kirɨttuzkas Jesústa nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Judío awa Jesústa nɨjkultachiruzne aliz kulara, akkwan awa Pablo kaizta aizpa mɨara akwa. Uspane mɨnpazha arakan awaruza wanmakninara, wan awa pilchapuzninamɨznapa. Jasónpa yalta azain ɨat kit pɨjta pakpak kiara, Pablorakas Silastakas sayat kit ukkat kit awaruza chɨhkaanapa. ");
INSERT INTO kwi_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sua usparuza wanmalmanamtɨkane, Jasóntakas izmuruzakas pɨpulu ɨnintuzakima tain ɨat kit kwianara: “An awane wan sura maizninamtu; mane apakas ailta. ");
INSERT INTO kwi_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasónne usparuza paiña yalta nammɨlara. Uspane au mikwa Cesar kaizta aizpa mɨamtuchi. Mamaz an katsa mikwa ɨninna arɨt kizamtu. Usne Jesús muntɨt,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sun mɨarawane, awakas ɨnintuzkas pilchapuzara. ");
INSERT INTO kwi_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasónkas mamazkas usparuza pial tarawane, usparuza chɨhtnara. ");
INSERT INTO kwi_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɨl pakane, izmuruzne Pablorakas Silastakas puznin kit Berea pɨpulura ɨninñara. Piannailtawane, Judío kammu yalta ɨilta. ");
INSERT INTO kwi_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","An Judío awane Tesalónica awakinkas anza wat mazi. Pailta payu Dios pit mɨamtuasmin, uspane Dios pɨnkɨhta parɨt aizpa izara. Pablo kaizta aizpa piankamshiara. ");
INSERT INTO kwi_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Katmizna akkwanne nɨjkulara. Usparuztas akkwan kwazpa Griego awakas akkwan kwazpa Griego ashampa wat kirɨttuzkas nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pablone Berea pɨpulura Dios pit kainanamɨzta. Judío awa Tesalónica pɨpuluras sunpa nɨjkularawane, uspane ta ɨat kit awara pilchapuzninñara. ");
INSERT INTO kwi_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Paiña izmuruzne Pablora tɨriztachi ɨninñara, katsa pimara tuanpa. Silaskas Timoteokas Berea pɨpulura nukkultailta. ");
INSERT INTO kwi_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablora kanpararuzne Atenas pɨpulurakima kanpaara. Pablone kailtaruza paiña pit ɨninta, Silaskas Timoteokas azain kail kit uskasa wanmaknapa. ");
INSERT INTO kwi_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Silastakas Timoteorakas tɨriztuasmin, Pablone Atenas pɨpulura mat kit kwisha tayalta, wan awa akkwan tɨ awakana sarɨtta wakpuj wainñamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Katmizna usne Judío kammu yalta nap kit Judío awaruza tɨnta paranara. Mamaz Griego awaruzakas, Diosta piantuza paranara. Pailta payu kumira paininmukin, awa ɨmkin wanmakturuza paranara. ");
INSERT INTO kwi_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mɨnpazha kamtamtuzne epicúreo munara. Mamaz kamtamtuzne estoicos munara. Uspane Pablokasa kwinta kiamɨzta. Mɨnpazha usparuzpain mɨmara: “An ampune kain paramtu. Usne nukkukana tɨnta paramtui.” Mamaztuzne ka kaizara: “Usne mamaz diospa kamtamtu. Uspane sun kwinta kiara, Pablo watsal pit Jesúspa kainara akwa. Uskas awa irɨttas kakultu kainammɨzta.” ");
INSERT INTO kwi_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Suasne uspane ussa Areópago ɨzakin, uspa wanmakmukin, mɨlaara. Sua ussa ka mɨmaara: ");
INSERT INTO kwi_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","—¿Nu masas kamtam kamtamtu aizpa aumɨza kamtashinakish? Nune aumɨza mamaz tuntukanain kainammtu. Sun wan nu kainammtu aizpa piankamshipuspas, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wan Atenas pɨpulu awakas mamaz suras awa sua uztuzkas chiwazha masas kwinta kirɨt aizpa mɨashimtu. Chiwazha masas pit mɨamtu aizpa kwinta kiashimtu. ");
INSERT INTO kwi_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Suasne Pablone uspa paizkakin Areópago ɨzakin kun kit kaiznara: “Atenas uzturuz mɨzhain. Nane u tɨ awakana sarɨtkin wakpuj wainñamtu pianish. ");
INSERT INTO kwi_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Na u wakpuj waimtukin u wanmakmukin chasmin, nane u chiwazha katsa ukkasa sarɨtkin wanmaltau. Sua sun pit ukkin parɨt: AN DIOSTA PIANCHIMAKPAS. U sun Diosta wakpuj wainñarakas, une ussa pianchi. Nane uruza sun Diospa kainanamtus. ");
INSERT INTO kwi_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","An Diosne au su sara. Chiwazha an sura wa aizpa us sara. Usne chiyukas pilkas pamika i. Usne wakpuj wainmu yalkin awa sarakin uzchi. ");
INSERT INTO kwi_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sun awa ussa kiwainsachikas, Diosne pailta awaruza uzninnara. Ishkas wan chiwalkas aumɨza mɨlanara. ");
INSERT INTO kwi_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Maza ampu sarawane, Diosne wan awara sara, wan chiwal sura uzanapa. Usparuza sarachasmin, Diosne an ñancha mɨnta awa uznakas yawa añora uznakas nanara. ");
INSERT INTO kwi_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Diosne sun kirɨt, awa ussa sayanapa. Ussa sayarane, une Diosta wanmalashina. Watcha Diosne au kashain uz. ");
INSERT INTO kwi_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Usne aumɨza uzninamtu. Usne aumɨza ɨninamtu. Us akwa uzmakpas. Mɨnpazha u kainammmikane ka kaizara: ‘Aune Diospa kwal makpas.’ ");
INSERT INTO kwi_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Aune Diospa kwal makpas kizamtune, aune Dios chiwazha sarɨtkana kizsachimakpas. Dios urukasakas pialkasakas ukkasakas sarɨt i mintachiwamakpas. Awane uspain minñamtu aizpa sara. ");
INSERT INTO kwi_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","An ñancha Dios wan kwail awa kirɨt aizpa ilnarachikas, mane Diosne wan awa pailta sura uzturuza ɨninnamtu, kwail kiarɨt aizpa maizanapa. ");
INSERT INTO kwi_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Katmizna Diosne maza payura nara, wan awaruza nil ilnana. Sun payu taizkane, Diosne Jesús akwa, us narɨtmika akwa, wan awaruza ilnanazi. Diosne ussa irɨttas kakulninta, wan awane ussa izat kit piankamanapa.” ");
INSERT INTO kwi_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Awa irɨttas kakultu mɨarawane, mɨnpazha sunta ishanara. Mamaztuzne ka kaizara: —Mamaz payu sun paraka mɨaiznapas. ");
INSERT INTO kwi_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Suasne Pablone uspa paizkakis puzta. ");
INSERT INTO kwi_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mɨnpazha awane ussa kanpaat kit nɨjkulara. Dionisione, Areópago ɨninmikane, nɨjkulta. Maza ashampakas, Dámaris muntɨtmikakas, mamaztuzkas nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Areópago ɨzakin kwinta kitpane, Pablone Atenas pɨpuluras puz kit Corinto pɨpulura ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Suane usne maza Judío awara wanmalta. Usne Aquila muntɨt. Usne Ponto suras arɨt. An ñamin akkwan payuchin uskas paiña ashampa Priscilakas Italia suras ailta. Katsa mikwane, Claudione, Roma pɨpulukis wan Judío awara ɨninnara, wan puzanapa. Sun akwa, Aquilakas paiña ashampakas Corinto pɨpulura pianailta. Pablone usparuza iznana ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Sun kalmin kal kiamtuasmin, usne usparuzkasa mara, sulmin nain pĩnkasa yal sana. ");
INSERT INTO kwi_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pailta kwaizkulmu payura Pablone Judío kammu yalta ɨra, tɨnta kwinta kinana. Usne Judío awaruzakas Judío awachiruzakas us kamta aizpa mɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silaskas Timoteokas Macedonia suras piannailtawane, Pablone Dios pitmin kainanamɨzta. Judío awaruza nil kiznara, Jesúsne Dios ɨnintamika azi kiz kit. ");
INSERT INTO kwi_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Uspane ussa alizwazha sɨnkaamɨzta. Kwail pit paraamɨzta. Suasne Pablone paiña pĩn ulpian kit Judío awaruza kwainattattɨnash kiz kit kiznara: —Une umin iashitne, une iashina. Nane sɨnam ish. Nane uruza kuruntu aizpa pianish. Makis nane Judío awachiruza kamtana ɨmtus, kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Judío awa kammu yaltas puz kit Ticio Justowa yalta napta. Usne kammu yalmamin uz kit Diosta paikwara. ");
INSERT INTO kwi_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispone, kammu yal ɨninmikane, paiña kwalkasa Anpatta nɨjkulara. Akkwan Corinto awakas Dios pit mɨarawane, uspane nɨjkulat kit munarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Suasne Anpatne Pablora izpan kit kaizta: “Ishkumun. Dios pit kainanamɨzti, puñachin. ");
INSERT INTO kwi_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nane nukasa kiwainna ɨnash. Mɨnminkas apa nua iyamanazi, nua kwail kin. An pɨpulukin kwisha akkwanne nawa piankamanazi.” ");
INSERT INTO kwi_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Sunkana Pablone maza año kakwakasa Corinto pɨpulura tut kit Dios pit usparuza kamtanara. ");
INSERT INTO kwi_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sun payu Galiónne Acaya sukin katsa mikwa azi. Judío awaruzne wanmakkat kit Pablora aliz kulara. Ussa pizat kit katsa mikwakin mɨlat kit ");
INSERT INTO kwi_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","katsa mikwara kaizara: —An ampune wan awara kurunamtu cha, mamaz tuntu Diosta wakpuj wain kit Diosta paikwan. Moisés aumɨza sunkana ɨnintachi. Aune sunkana kisachimakpas, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo kwinta kimtuasmin, Galiónne Judío awaruza kaiznara: —Us gobiernora kwail kitne, us awara kwail kitne, nane u Judío awaruz kaizara aizpa mɨrawaish. ");
INSERT INTO kwi_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Une kamtampakas awawakas uruzpa ɨnintu aizpakas paraamtu. Umin nil sarain. Nane nil aizpakas kwail aizpakas kaizmanash. Na u kamtamtu aizpakas u nɨjkulamtu aizpakas we piankamtɨt akwa, nane chinkas kizsachish. ");
INSERT INTO kwi_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiónne usparuza pianamal ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Suasne wan Griego awane Sóstenesta, Judío kammu yal ɨninmikasha, pizat kit suain katsa mikawakin aim kiara. Galiónne sun izkitchi. ");
INSERT INTO kwi_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablone Corinto pɨpulura mama akkwan payukima nukkulta. Izmuruza “ɨru” kiznarawane, kanuara waat kit Siria surakima ɨra. Priscilakas Aquilakas ɨilta. Cencrea pɨpulura, kanuara waarachasmin, Pablone paiña kɨzpu ash chiwal kihta, us Diosta sun kin namta aizpa kin. ");
INSERT INTO kwi_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Éfeso pɨpulura pianaarawane, Pablone Priscilarakas Aquilarakas tɨwij ɨt kit Judío kammu yalta ɨra. Judío wanmakmuruza paranara. ");
INSERT INTO kwi_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Uspane ussa paikuara, an akkwan payukima tuanpa. Nukkulshitchi. ");
INSERT INTO kwi_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Suasne “ɨru” kiznat kit kaiznara: “(Nane Jerusalén pɨpulurain tuatpaish, pishta izna). Dios nawa kiwaintane, mamasa kailnash, uruza iznana,” kiznara. Suasne kanuara waat kit Éfeso pɨpulukis ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea pɨpulura piannatpane, Pablone Jerusalén pɨpulura ɨra, Dios pit piantuza iznana. Kwiztane Antioquía pɨpulura ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Akkwan payuchi pailkane, Galacia surakas Frigia surakas wan pɨpuluruza ɨra, wan Jesústa piantuza kiwainnana. ");
INSERT INTO kwi_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sun payune Apolosne, Judío awane, Éfeso pɨpulura piannara. Usne Alejandría pɨpulura kawira. An wat kainanmikane Dios pit kwisha watsal parat kit Dios pit wat piankamta. ");
INSERT INTO kwi_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mazane ussa Anpatpa miwa kamtara. Us pian aizpa kwisha wat kwinta kit kit Jesúspa nil kamtanara. Uspane sun payura Juan munnarɨt aizpa pianara. ");
INSERT INTO kwi_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosne Judío kammu yalta kwinta kimɨzta, ishkwatchin. Priscilakas Aquilakas ussa mɨiltawane, uspane ussa paimpa mɨlpail kit Diospa miwa an nil kamtanailta. ");
INSERT INTO kwi_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Suasne Apolos Acaya sura pɨnshimtuasmin, izmuruzne ussa kiwainashit kit maza pɨnkɨh Jesústa piantuza paranat kit ussa “watsal sappanaka” kiznara. Acaya sura piannatpane, usne Diosta nɨjkultuza kamtananara. Diosne ussa kwisha wat kiwainta, sun awa Jesúspa an piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolosne Judío awara tɨnta kwinta kinara. Usne wan awa iztakin Judío awa ñanta minñarɨt aizpa piankamninnara. Uskas Dios pit pɨnkɨhpara “Jesúsne Dios ɨnintamika azi” kiz kit kamtanara. ");
INSERT INTO kwi_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corinto pɨpulura tuasmin, Pablone ɨnkal ɨzara puz kit Éfeso pɨpulura pianara. Suane Jesústa piantuza wanmal ");
INSERT INTO kwi_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","kit Pablone mɨnanara: —Diosta nɨjkulakane, ¿Paiña Sɨnam Izpul sappamanas? Uspane sɨnkaara: —Aune mizurainkas Dios paiña Sɨnam Izpulta ɨnintu mɨrachimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Suasne Pablone mɨmanara: —¿Chima pianmakpas? ¿Miza tuntuma munnamtuas? Uspane sɨnkaara: —Aune Juan awaruza munnara pianmakpas. ");
INSERT INTO kwi_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablone kaiznara: —Watcha, Juanne kwail kirɨt maizturuzain munnanara. Uskas usparuza mamazta nɨjkularawa kaiznara. Usne awaruza kamtanara, Jesústa, an paiña kwizta amtumikasha nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sun mɨarawane, Anpat Jesústa nɨjkultuza munnarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo paiña chihtɨ uspa kɨzpukin paanakane, Sɨnam Izpulne usparuza piznara. Uspane mamaz tuntu pitkasa paraat kit Dios usparuza kaiznara aizpa kainaara. ");
INSERT INTO kwi_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wan doce ampuruzne purazi. ");
INSERT INTO kwi_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablone kutña mishkima Judío kammu yalta ɨmɨzta, Dios pit kainana. Wan awakasa ishkwatchin paranat kit Dios awaruza ɨninnashimtu aizpa piankamninnara. ");
INSERT INTO kwi_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mɨnpazha ussa parashitchi. Jesústa mɨashitchi. Uspane, Jesústa pianchiruzne, awa purakin Diospa miwa kwail paraara. Suasne, Pablone usparuztas paimpa ɨra. Jesústa piantuza Tiranowa kammu yaltakima mɨlnara. Suane pailta payu kwinta kinara. ");
INSERT INTO kwi_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Sunkana paas añokima kamtanara. Wan Asia sura uztuzne Anpat Jesúspa pit mɨara. Kawarain Judío awakas Judío awachikas mɨara. ");
INSERT INTO kwi_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Diosne Pablo akwa kwisha akkwan iztasparɨt kal kira. ");
INSERT INTO kwi_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Sunkana kirɨt. Awane pairara kihamkas uspa pĩnkas karaara, Pablo sun pĩn paanapa. Suasne uspane sun pĩn inturuza mɨlnara, usparuza kakulninnanapa. Piztɨttuztas saliz puzninnara. ");
INSERT INTO kwi_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mɨnpazha wat chi Judío awane, saliztuza puznintuzne, Anpat Jesúspa mun kizshiamtu, salizta puzninna. Uspane salizta kaizara: “Pablone Jesúspa kamtanara. Jesúspa mun kaiztu akwa, nakas uruza puzninnamtus,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Siete painkulne ka kiara. Escevane, uspa Judío papihshne, pariya ɨninmika azi. ");
INSERT INTO kwi_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sun kiakane, kwail salizne sɨnkanara: “Nane Jesústa pianish. Pablorakas pianish. ¿Une mɨnma makpas?” ");
INSERT INTO kwi_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Masain kwail saliz piztɨtmikane usparuza tiznat kit wanta tɨnta piannara. Usne aimpi puznakima kwisha aim kinat kit uspa pĩn pihshanara. Usne yaltas piltɨm ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wan Éfesora uzturuzne, Judío awakas Judío awachikas, sun piankamat kit ishkuara. Uspane Anpat Jesúspa wat minñat kit kwisha wari an akkwan piji kaizara. ");
INSERT INTO kwi_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Akkwan Jesústa nɨjkulturuzne aat kit uspa kwail an ñancha kiara aizpa Diosta kainaara. ");
INSERT INTO kwi_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Akkwan tañu kimtuzne uspa payara pɨnkɨh karaat kit wan awa iztakin ĩnta paktaara. Uspa pɨnkɨh sunpawa muin wiantawane, cincuenta mil pial muin. ");
INSERT INTO kwi_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sunkana an akkwan awane Anpatpa pit mɨashit kit an tɨnta Diosta nɨjkulara. ");
INSERT INTO kwi_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sun kitpane, Pablone min kit Macedonia surakas Acaya surakas ɨshira. Kwiztane Jerusalén pɨpulura ɨshira. An kwiztane “nane Roma pɨpulurakas ɨtpaish” kizta. ");
INSERT INTO kwi_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Suasne paasta, Timoteorakas Erastorakas, paiña kiwainmuruza Macedonia sura ɨninnara. Usmin akkwan payuchikima Asia sukin nukkulta. ");
INSERT INTO kwi_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sun payune awane Dios watsal pit akwa, masas mi akwa pilchapuzara. ");
INSERT INTO kwi_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrione, chiwazha putchã pialkasa sammikane, awara pilchapuzninnara. Sun ampukas paiña kiwaintuzkas pucha pialkasa ainki yal saara. An ainki yalne Dianawa katsa yalkana iztɨt. Uspane maza ashampa diosta, Dianara wakpuj wainñara. Uspane kwisha akkwan pial kana kiara, sun yalkin paininta akwa. ");
INSERT INTO kwi_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Usne usparuzakas sun ainki kal kittuzakas wanmakninat kit usparuza kaiznara: “Izmuruz. Une au kalkasa kana kimtumakpas pian, wat uzanapa. ");
INSERT INTO kwi_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Une Pablo kaizta aizpa mɨara. An ampune au sarɨt diosne ‘Dios chi’ kiztu. Pablone sunkana kirɨt, au Éfeso pɨpulurakas wan Asia surakas au sarɨt diosta mɨamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Awa au kal kwail i kizarane, aune au kal kashinamakpas. Kawarain awane ashampa dios Dianawa yalta wakpuj wainshiamanazi. Watchi minñanazi. Awa Diana wat chi kizamɨzkane, Dianawa yalta wakpuj wainna ɨamanazi. Mane watcha wan awa Asia sura uztuzkas wan awa mamaz sura uztuzkas ussa wakpuj wainñamtu.” ");
INSERT INTO kwi_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetrio kaizta aizpa mɨarawane, uspane kwisha aliz kulat kit kwianara: “Au Diana, Éfeso pɨpuluras, kwisha wari,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Suasne an akkwan awane Éfeso pɨpuluras kwianamɨzta. Uspane Gayorakas Aristarcorakas, Macedonia suras arɨttuza, piznara. An paasne Pablora kanpailta. Wanne uspa wanmakmu yaltakima usparuza tain kit ɨninnaara. ");
INSERT INTO kwi_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablone sua napshira, awara kwinta kinana. Jesústa pianturuzne ussa napninarachi. ");
INSERT INTO kwi_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mɨnpazha ɨnintuzne, Asia suras attuzne, Pablowa izmuruzkas uspa pit ɨninñara, sua napmanpa. ");
INSERT INTO kwi_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wanmakmukin tuasmin, mamaztuzne chiwazha kwianara. Mamaztuzne mamaz pit kwianara. Wan awane pilchapuzara. Anza akkwan awane chikishma wanmakkamtu wat pianchi. ");
INSERT INTO kwi_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mɨnpazha Judío awaruzne Alejandrora nuppainñara, awa paizkakin kunnat kit paranpa. Uspane Alejandrora paikuara, uspa akwa kwinta kin. Alejandrone chihtɨkasa puñain kiznara, Judío awa akwa kwinta kin. ");
INSERT INTO kwi_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Us Judío awa i piankamarawane, uspane paas urakima ka kwianara: “Au Dianane, Éfeso pɨpuluras, kwisha wari,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Suasne pɨpuluwa pɨnkɨh pammikane wanta puñain paninat kit kaiznara: “Éfeso awaruz mɨrain. Wan awane ashampa dios Dianawa pian. Aune Dianawa yalta iztumakpas. Sua awa wakpuj wainñamtu. An Dianawa uk chiyuras taizta pianmakpas. ");
INSERT INTO kwi_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mɨnminkas sun kirɨtchi kisachi. Puñain parain. Chiwazha kwail kitchasmin, wat minñarawa. ");
INSERT INTO kwi_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","An ampuruzne, u karaarɨttuzne, u diospa yalta kwail kizarachi. U ashampa diosta kwail paraarachi. ");
INSERT INTO kwi_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Katmizna Demetriokas uskasa kal kimtuzkas mɨnpazhara kwail kirɨt kizarane, katsa mikwara ɨarawa. Katsa mikwane u kaizamtu aizpa mɨnazi. Suain ɨt kit kwinta kitpa, mamazta kwail kirɨt kizna. ");
INSERT INTO kwi_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mamaz tuntu kwinta kishitne, une katsa mikwa wanmakmukin ɨarawa. ");
INSERT INTO kwi_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ma u sun kiarɨt akwa, Romano ɨnintuzne aashina, u waya kiashimtu kizanapa. ‘Chikishma pilchapuzarɨt’ mɨmaakane, aune kain sɨnkasachimakpas,” kiznara. ");
INSERT INTO kwi_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sun kiztawane, wanne wanmaktukis ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pilchapuztu pailtawane, Pablone Jesústa piantuza akwanat kit kurunnara, usparuza kiwainna. Suasne “ɨru” kiz kit saya kwat kit Macedonia sura ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wan pɨpuluwara ɨmtuasmin, usne kaiznat kit Jesústa piantuza kiwainnara. Kwiztane Grecia sura piannara. ");
INSERT INTO kwi_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Suane kutña mishtakima tuara. Siria sura kanuara ɨnpain pakane, usne Judío awaruz ussa kwail kishiamtu piankamta. Katmizna min kit pilparain kailta. Mamasa Macedonia suwarain pɨnta. ");
INSERT INTO kwi_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sópater, Pirrowa painkulkas, Berea pɨpuluras, Aristarcokas, Segundokas Tesalónica pɨpuluras, Gayokas Derbe pɨpuluras, Timoteokas, Tíquicokas Asia suras, Trófimokas Asia suras, ussa kanpaara. ");
INSERT INTO kwi_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Sun izmuruzne an ñamin ɨat kit Troas pɨpulura aumɨza tɨrizara. ");
INSERT INTO kwi_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pishta pan kiñakasa kumchi pailtawane, aune Filipos pɨpulukis kanuawara puzwiznash. Cinco payura Troas pɨpulura pianaiznash. Suane siete payu maaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sábado amtane aune Diosta piantuzkasa wanmakaiznash, kumira kwan. Suane Pablone Jesústa piantuza kamtanara. Tɨlawa ɨmtu akwa, kakwamtakima akkwan pit paramɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Aune kwash yalta wanmaktɨt puranash. Suane akkwan impil aiztuara. ");
INSERT INTO kwi_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Euticone, musittune, kwashta izkulamkin uzta. Pablo akkwan urakima kamtamtuasmin, usne pitshimɨzta. Kwisha tɨnta pittawane, usne kwashtas izkulamkis taizta. Uspane irɨtmikasha piltas tainak kit kamara taara. ");
INSERT INTO kwi_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Suasne Pablone pulamal kihsh kit irɨtmikasha ɨsalta tut kit sayakwara. Izmuruza kaiznara: —Ishkuman. Irachi. Ka. ");
INSERT INTO kwi_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Uspane musittu irɨtmikasha kamin mɨlat kit kwisha wat kulara. Suasne Pablone kail kit yalta napta. Kumira nailtawane, kuara. Pablone kɨnnakima kwinta kinara, ɨnkima. ");
INSERT INTO kwi_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo pilpara ɨshimtuasmin, aune an ñancha kanuawara Aso pɨpulura ɨaiznash, sua Pablora wanmalna. ");
INSERT INTO kwi_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asora wanmaktawane, Pablone kanuara waat kit aukasa Mitilene pɨpulura ɨaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Suas puzarawane, tɨlawane Quío pɨpulumara pɨnaiznash. Maza payu marawane, aune Samos pɨpulura kanua pianamkin pɨpulura pianaiznash. Trogilio pɨpulura kwaizkultawane, aune Mileto pɨpulura pianaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asia sura akkwan payukima nukkultuchi akwa, Pablone Éfeso pɨpulura ɨtchi. Usne masain Jerusalén pɨpulura piannashira, Pentacostés pishta suain tuan. ");
INSERT INTO kwi_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto pɨpulura mamtuasmin, Pablone wanmakmu ɨnintuza Éfeso pɨpuluras akwanpa ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pianaakane, ka kaiznara: “Na uruzkasa uztuasmin, une na miza uzta wat pian. Sun payura Asia sura piannatpane, ");
INSERT INTO kwi_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","nane kiwainmumikakana pailta payu Anpatta kiwainmɨztau. Ap Anpatpa kal kimtuasmin, nane aztau, Judío awa nawa kwail kiashimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nane uruza wan kainanarau, uruza kiwainshimtu akwa. Wan awa purakinkas uspa yalkinkas Dios pit kainanat kit uruza kamtanarau. ");
INSERT INTO kwi_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judío awaruzakas Judío awachiruzakas kainanarau, uspa kwail kiarɨt aizpa maizanapa, Anpat Jesucristora nɨjkulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mane Jerusalén pɨpulura ɨshimtus, Sɨnam Izpul nawa kaizta aizpa kin. Sua awa nawa kishiamtu aizpa pianchish. ");
INSERT INTO kwi_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wan pɨpulura na ɨmtura, Sɨnam Izpulne nawa ka kaizchish: ‘Awa nawa kajchira sɨp kit tɨnta naizninanazi.’ ");
INSERT INTO kwi_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sun akwa, nane ishkumtuchish. Ishinas. Uzshinas. Chima kishinaka pianchish. Nane ap kal pailtau. Anpat Jesúspa kal wan nawa chɨhkat aizpa kapal kirau. Dios watsal pit kainashinas, Dios awara wat kiwainanapa. ");
INSERT INTO kwi_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mane mɨrain. Nane uruza ɨt kit Dios miza uruza ɨninnashimtu kainanarau. Une nawa mamaz payura mizurainkas izamanazi. ");
INSERT INTO kwi_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Katmizna nane uruza wan Dios nawa chɨhkarɨt aizpa kainanarau. Nane uruza wan kamtanarau. Mɨnminkas nawa kwail kirɨt kizsachi. ");
INSERT INTO kwi_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nane uruza wan Dios kishimtu aizpa kainanarau. ");
INSERT INTO kwi_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Katmizna mane une uruzpain iztain. Sɨnam Izpulne sun kal uruza chɨhkanarɨt, Diosta wanmakmuruza iznat kit kiwainanapa. Diospa painkul irawane, paiña aimpi puztawane, Diosne awaruza akwanara, wanmakkat kit paiña kwalkanain uzanapa. ");
INSERT INTO kwi_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na ɨkane, mamaz kwail kamtamtuzne, ɨnkal kwizakanane, anazi, Diosta piantuza kwail kianapa, nil chi kamtananapa. ");
INSERT INTO kwi_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mɨnpazha uruzpain pɨrail kaizat kit kamtaanazi, Jesústa piantuza watcha mɨamanpa, usparuzain kanpaanapa. ");
INSERT INTO kwi_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Uruzpain iztain. Nɨjkultain. Nane kutña añokima amtakas payukas wan uruza kurunarau. U akwa az kit naiztau. ");
INSERT INTO kwi_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mane, Cristora piantuz mɨrain. Minpara nane Diosta paikumtus, Dios uruza iznanapa. Diosta paikumtus, paiña watsal pit uruza nil uzninnanapa, us kin namtɨt aizpa sappanapa. Diosne ussa chɨhkamturuza kiwainnanazi. ");
INSERT INTO kwi_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nane mamazpa pialkas mamazpa urukas mamazpa pĩnkas pashitchish. ");
INSERT INTO kwi_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sunkana ap chihtɨkasain tɨnta kal kirau, ap pialkasain chiwazha na we aizpa paina. Nakas ap izmuruz we aizpa usparuza mɨlanarau. ");
INSERT INTO kwi_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nane pailta payu uruza sunkana kamtanarau, kal kiaiznapa, we mɨjtuza kiwainanapa. Anpat Jesúspa pit kaizta aizpa mɨrain: ‘Mamaztuza mɨlamtumikane anza wat kulnazi. Saptumikane anza wat kulmanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Sunkana awara kaiznarawane, Pablone wakpuj wain kit Diosta uspa akwa paikwara. ");
INSERT INTO kwi_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wantuzne azat kit Pablora saya kwaara, “ɨru” kizka. ");
INSERT INTO kwi_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","U nawa chinkas izamanazi kiznara akwa, uspane kwisha tayalara. Suasne ussa kanpaara kanuarakima. ");
INSERT INTO kwi_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Izmuruza tɨwij ɨtpane, aune kanuara waat kit Cos sura masain nil ɨaiznash. Tɨlawara Rodas sura ɨaiznash. Suasne Pátarara pɨpulura pianaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Suane Fenicia sura ɨmtu kanua wanmalaiznash. Waat kit ɨaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chipre su pi paizkakin pɨntuasmin, sun sura au puiyawara izat kit pɨnaiznash, Siria surakima. Kwiztane Tiro pɨpulura pimakin pianaiznash, sua chiwazha kanuara wa aizpa chɨhkan. ");
INSERT INTO kwi_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Aune Jesústa piantuza wanmal kit siete payukima maaiznash. Uspane Diospa Izpul kaizta aizpa Pablora kaizara: “Jerusalén pɨpulura ɨsachi,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Siete payu wan kapal marawane, Tiro pɨpuluras ɨaiznash. Wan Jesústa piantuzne, wan ashampakasa pashpakasa auruza kanpaara pɨpulumarakima. Suane pi ksukin wakpuj wainñat kit Diosta paikuanash. ");
INSERT INTO kwi_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Suasne saya kwaat kit “ɨru” kiztawane, kanuara waiznash. Uspane uspa yaltain kaiyara. ");
INSERT INTO kwi_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro pɨpuluras kanuawara ɨat kit minpara Tolemaida pɨpulura pianaiznash. Suane aune Diosta piantuza “kakishapu” kizaiznash. Uspakasa maza payuin nukkulanash. ");
INSERT INTO kwi_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tɨlawara Pablokas uskasa ɨmtuzkas tas ɨat kit Cesarea pɨpulura pianaiznash. Suane aune Felipewa yaltakima ɨaiznash, uskasa mana. Ɨnintaruzne ussa naarɨt, Dios watsal pit kainammmika namnapa. Usne siete narɨttuztas ara. ");
INSERT INTO kwi_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipene ampara pashu mɨjara. Uspane kasara kiarachi. Uspane Dios kaiznara aizpa kainanara. ");
INSERT INTO kwi_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Akkwan payu chikima Cesarea pɨpulura purasmin, Agabone, Dios kainammikane, Judea suras ");
INSERT INTO kwi_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","aumɨza iznana ara. Pablowa aya kɨra piz kit paiña mittɨkas paiña chihtɨkas sun aya kɨrakasa kuht kit kaizta: —Sɨnam Izpul ka kiztui: “Hebreo awane Jerusalén pɨpulura aya kɨrapamikasha kuht kit Judío awachiruza chɨhkaanazi.” ");
INSERT INTO kwi_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sun mɨarawane, aukas Cesarea pɨpulura uztuzkas Pablora paikuamɨzta, Jerusalén pɨpulura chi ɨmanpa. ");
INSERT INTO kwi_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pablone sɨnkanara: —¿Chikishka azpuspas? Une nawa tayalnintu. Uspane nawa cadenakasa kuhshina. Nane kajchira ɨnpain ish. Nane Anpat Jesús akwa Jerusalén pɨpulukin inapain ish. ");
INSERT INTO kwi_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pablo au kaizta aizpa mɨshimtuchi akwa, puñain paarɨnash. Anne ussa kaizmanash. Minpara “Dios pashit aizpa kitpa” kizaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Sun kitpane, aune ɨmɨzna watsaaiznash. Suas Jerusalén pɨpulura ɨaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mɨnpazharuzne Cesarea pɨpuluras, Jesústa piantuzne, aumɨza Mnasónpa yaltakima pitna kanpaara. Usne an ñancha Chipre suras at kit ñamin Jesústa piankamta. ");
INSERT INTO kwi_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalén pɨpulura pianatpane, Diosta piantuzne aumɨza wat sappara. ");
INSERT INTO kwi_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tɨlawara Pablone aukasa ɨat kit Santiagora izaiznash. Suane wanmakmu ɨlaparuzne purara. ");
INSERT INTO kwi_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Usparuza “kakishapu” kiznarawane, Pablone impara imparain usparuza paiña kal kirɨt aizpa kwinta kinara, Judío awachiruz Diosta piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sun mɨarawane, uspane “Dios kwisha wari” kizara. Suasne Pablora kaizara: —Au izmuruz, mɨrain. Mane kwisha akkwan mil Judío awakas Jesústa nɨjkulara. Wanne nil chaamtu. Moisés kamtara aizpa mama kiarawa kizara. ");
INSERT INTO kwi_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Uspane sunkana minñat kit kiznara. Nune Judío awaruza, mamaz sura uztuza, mamaz tuntu kamtanamɨztu. Moisés kaizta aizpa kinchi kizamtu. Ampu pashparuza aya tɨtnachi, circuncisión kinchi kizamtu. Judío awakana uznachi kizamtu. Sunkana nu kamtanarɨt aizpa kizamtu. ");
INSERT INTO kwi_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Aune chima kinpai? Nu arɨt piamkamtane, wan awane wanmakkanazi. ");
INSERT INTO kwi_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aune nua kurunaiznash, au kaiztu aizpa kinpa. Apainne ampara ampune aukasa pura. Uspane Diosta chiwazha kin namat kit Moisés ɨnintɨt aizpa kishiamtu, Dios iztakin sɨnam kulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nukasa usparuza minari. Uspakasa ɨt kit Dios iztakin sɨnam kulninti, Moisés ɨnintɨtkana. Chiwazha uspa pui aizpa pariyara tari. Sun kitpane, uspane kɨzpu ash tɨtninnashina. Sunkana kitne, wan Judío awane nu Moisés kamta aizpa kimtu piankamanazi. Suasne uspane uspa mɨara aizpa watchachi nɨjkulanazi. ");
INSERT INTO kwi_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Aune Judío awachiruzakas pɨnkɨh paramakpas. Aune sun Jesústa nɨjkulturuza kuruntamakpas, chiwazha ña dios awakana sarɨtta mɨlarɨt aizpa kuamanpa. Kalpa kuhtɨt aimpi puztakine, ña kuman. Aimpikas kuman. Ampuruzne mamazpa ashampara sanachi. Ashamparuzne mamazpa ampura sanachi. ");
INSERT INTO kwi_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Suasne tɨlawara Pablone ampara ampura uskasa mɨlnat kit Moisés ɨnintɨt aizpa kit kit Dios iztakin sɨnam kulninnara, uspa kin namtɨt aizpa kianapa. Kwiztane usparuzne Dios katsa yalta nappat kit pariyara miza payu sun sɨnam kulnintu payura pailtu kainara. Sun payura ampara ampune chiwazha Dios ɨninta aizpa mɨlanazi. ");
INSERT INTO kwi_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Siete payu pailnapain. Mɨnpazha Judío awane, Asia suras awane, Pablora Dios katsa yalkin izara. Uspane Pablora pilchapuzat ");
INSERT INTO kwi_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","kit kwianara: “Israel awa, kiwainchain. An ampune wan sura uztuza kamtanamtu cha. Usne au Israel awaruza aliz kulnarɨt. Usne Moisés kamtara aizpa mɨshitchi. Uskas Dios katsa yalta sɨnamchi namnintɨt. Mane Griego awara apain karara, Dios katsa yalta napnapa. Sun akwa, usne sun sɨnam yalkin sɨnamchi namninta.” ");
INSERT INTO kwi_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Uspane sun kizara, ñamin Pablora Éfeso pɨpulukin izara akwa. Sua Trófimone, sun Griego awane, Pablokasa chara. Pablo ussa, sun Griego awara, Dios katsa yalta mɨltɨt minñara. Griego awane sua napsachi. ");
INSERT INTO kwi_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wan pɨpuluras awane aliz pilchapuzat kit ãĩnmin aara. Suasne Pablora pizat kit Dios katsa yaltas tain kɨnaara pianamalkima. Masain pɨjta sɨppara. ");
INSERT INTO kwi_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wan Jerusalén pɨpulukin uztuz pilchapuzamtuasmin, suldaru ɨninmikane me Pablora piantashimtu mɨra. ");
INSERT INTO kwi_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Suasne usne paiña suldaru kiwaintuza wanmakninnat kit awa purakin ãĩnmin pianaara. Suldaru ɨninmikashakas suldaruruzakas izarawane, Judío awane Pablora an aim kiarachi. ");
INSERT INTO kwi_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Suasne suldaru ɨninmikane kasha at kit Pablora piz kit “ussa cadena kuhti” kiznara. Kwiztane “¿nune mɨn mas?” mɨmara. “¿Nune chi kirɨt?” mɨmara. ");
INSERT INTO kwi_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Judío awane mamaz mamazmin kwianara. Suldaru ɨninmikane chinkas mɨsachiwal, pilchapuzamtu akwa. Usne Pablora suldaru kammu yalkin mɨlninnara. ");
INSERT INTO kwi_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Suldaru kammu yal numkin piannatpane, suldarune Pablora kwat kit nuninta, aliz Judío awa ussa pizamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wanne kwizta aat kit ka kwianara: “Usne irawa,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pablo Suldaru kammura naptuasmin, Pablone suldaru ɨninmumikasha kaizta: —Chiwazha kizshinash, kizta. Suldaru ɨninmikane sɨnkara: —¿Nune Griego pit paramtukish? ");
INSERT INTO kwi_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Suasne ¿Nune Egipto awa chikish? ¿Nune akkwan payu ñamin waya kininat kit ampara mil waya kimtuzkasa pul sura mɨlnamas? ");
INSERT INTO kwi_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Suasne Pablone ussa kaizta: —Nane Judío awa ish. Cilicia suras at kit kwisha katsa wat Tarso pɨpulura kawira. Nua paikumtus, na awaruza kwinta kinana. ");
INSERT INTO kwi_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Suldaru ɨninmikane ussa kwinta kininta. Pablone kammu yal numkin kun kit chihtɨkasa awara puñain paninara. Puña parɨkane, Pablone awaruza Hebreo pit kwinta kinat kit ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Israel awaruzkas an Israel awa papihshtuzkas nawa mɨzhain. Nane na kit aizpa kainanash.” ");
INSERT INTO kwi_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebreo pit paraka mɨarawane, uspane an akkwan puñain paarɨt. Pablone usparuza ka kaiznara: ");
INSERT INTO kwi_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nane Judío awa ish. Cilicia sura Tarso pɨpulura kawiraish. Kwiztane Jerusalén pɨpulukin kawirau. Apane Gamalielne, Judío ɨlaparuz kamtamtu aizpa nawa kamtash. Nane pailta payu Dios Judío awaruza kaizta aizpa kishirau. Kawarain ma payu une sunkas kiashimtu. ");
INSERT INTO kwi_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nane ñamin Jesústa piantuza piznarau, piantanakima. Ampuruzakas ashamparuzakas piznat kit kajchira sɨpnarau. ");
INSERT INTO kwi_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pariya ɨnintuzkas wan Judío ɨlapatuzkas nawa piankamara. Uspane nawa pɨnkɨh mɨlaara, Damasco pɨpulura mɨlnapa, Cristora piantuza piznanapa, au Judío ɨninmuruza chɨhkanapa. Nane sua ɨt kit Jesústa piantuza sairau. Jerusalén pɨpulukin karanarau, usparuza ilnana.” ");
INSERT INTO kwi_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Na miwara ɨmtuasmin, Damasco pɨpulura piananpain arau. Sua paizka payu paka masain chiwazhane chiyuras pankanain kwisha malta. Sun iztawane, ");
INSERT INTO kwi_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","pilta naintɨrau. Suas mɨnpazha pit kaizka mɨrau: ‘Saulo, Saulo. ¿Chikishma nune nawa kwail kimtus?’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Suasne ussa mɨmarau: ‘Anpat. ¿Nune mɨnmas?’ kiztau. Nawa sɨnkaish: ‘Nane Jesús Nazaret pɨpuluras ish. Nuin nawa kwail kimtu,’ kizta. ");
INSERT INTO kwi_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nakasa ɨmturuzne sun pankanain izat kit ishkuara. Uspane an pit nawa kwinta kit aizpa mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Suasne kaiztau: ‘Ap Anpat, ¿Chima kinpai?’ Anpatne nawa kaizish: ‘Kuhsak kit Damasco pɨpulura ɨmɨzti. Tane nu wan kishimtu aizpa kiznash.’ ");
INSERT INTO kwi_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Sun pankana nawa aiztu akwa, nane izsachi parish. Katmizna ap kanpamtuzne nawa sailta tainñara, Damasco pɨpulura piannankima. ");
INSERT INTO kwi_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tane maza ampune, Ananías muntɨtmikane, uzta. Usne Moisés kaizta aizpa wat kira. Wan Judío awa Damasco pɨpulura uztuzne us akwa kwisha wat kwinta kiara. ");
INSERT INTO kwi_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananíasne nawa izna ara. Piannatpane, kaizish: ‘Saulo, ap izmumika, mamasa up kasu izkulti.’ Masain wan izkulkwerau. ");
INSERT INTO kwi_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Suasne nawa kaizish: ‘Au kwalpa Diosne ñamin nua narɨt, us kishimtu aizpa piankamnapa. Usne nua narɨt, nilmikasha izna, paiña pitmin mɨna. ");
INSERT INTO kwi_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mane nune awaruza nu Jesúspa piankamta aizpakas izta aizpakas nu mɨra aizpakas kainammɨztawa. ");
INSERT INTO kwi_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mane an tɨrizman. Kuhsak kit munti. Jesústa paikwari, up kwail kirɨt aizpa kwizninnapa.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalén pɨpulura kailtawane, nane Dios katsa yalta nap kit Diosta paikwarau. Suane kainkizpamtuasmin, chiwazha iztau. ");
INSERT INTO kwi_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nane Anpatta iztau. Usne nawa ka kaizish: ‘Jerusalén pɨpuluras puz kit ɨri. Uspane nu nawa kaizta aizpa mɨamanazi.’ ");
INSERT INTO kwi_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Suasne nane ussa kaiztau: ‘Anpat. Uspane na wan Judío kammu yalta ɨrɨt pian. Nane nua nɨjkulturuza piznat kit kajchira sɨpnarau. Nane usparuza aim kinarau. Uspane sun pian. ");
INSERT INTO kwi_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Estebanne up kiwainmika ara. Usne awaruza nuwa kainanara. Ussa piantaamtuasmin, nane sua kun kit ussa piantara aizpa nɨjish. Nakas piantamturuzpa pĩn iztau.’ ");
INSERT INTO kwi_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Suasne Anpatne kaizish: ‘Ɨt. Nane attishta Judío awachiruza ɨninnamtus.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Judío awachira ɨmtus kizka mɨarawane, wanne kwianamɨzta: “Ussa piantarawa, an sukin uzmanpa,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Uspane kwianamɨzta kwisha. Aliz akwa, uspa pĩn ulpianat kit pul pil kwash sunakninñara. ");
INSERT INTO kwi_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Suldaru ɨninmumikane suldaruruza ɨninara, Pablora suldaru kammu yalta mɨlnapa. Usne ussa ilninshira, paranpa. Usne chikishma awa sunkana Pablora aliz kwianamtui kiz piankamshira. ");
INSERT INTO kwi_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ussa tɨtkasa kuhtawane, ussa ilnapain mara. Pablone katsa suldaru ɨninmikasha mɨmara: —¿Romano pɨpuluras awara iltukish? Nune nawa ilsachi, na Roma suras ara akwa. Mama nune nawa katsa mikwara mɨlmas. Katsa mikwane nawa kwail kirɨt kiztachi. ");
INSERT INTO kwi_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sun mɨrawane, suldaru ɨninmumikane ɨt kit katsa suldaru ɨninmikasha sunpa parat kit kaizta: —Kuiraruin. An ampune Romano pɨpuluras awa i. ");
INSERT INTO kwi_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Katsa suldaru ɨninmikane Pablo tukin pianat kit mɨmara: —Kaizcha. ¿Watcha nune Romano awakish? Pablone sɨnkara: —Watcha i. ");
INSERT INTO kwi_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Suasne katsa suldaru ɨninmikane ussa kaizta: —Nane akkwan pial tarau, Romano awa namnapa. Pablone ussa kaizta: —Nane Romano awa ish, kawira akwa. ");
INSERT INTO kwi_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sun mɨarawane, Pablora ilshimturuzkas katsa suldaru ɨninmikakas Pabloras paimpa ɨara. Pablo Romano awa ara nɨjkulakane, uspane ishkuara, ussa pizara akwa, ussa cadena kuhara akwa. ");
INSERT INTO kwi_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tɨlawara katsa suldaru ɨninmumikane Pablowa piankamshira. Chikishma Judío awa Pablora kwail kirɨt kizamtu aizpa piankamshira. Pablowa cadena chɨhtawane, usne pariya ɨnintuzakas Judío katsa mikwaruzakas wanmakninnara. Suasne Pablora akwanat kit uspa purakin kunninta. ");
INSERT INTO kwi_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablone Judío katsa mikwaruza iznat kit kaiznara: —Ap aimpihshtuz, mɨzhain. Nane makima Dios iztakin wat min kit wat uztau. ");
INSERT INTO kwi_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Suasne Ananíasne, pariyawa ɨninmumikane, Pablo kashara uztuza ɨninnara, Pablowa pitkin kuzanapa. ");
INSERT INTO kwi_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablone sɨnkara: —Diosne nua sunkanain kuznazi. Nune kwail awa i. Suain uztuasmin, nune Moisés para akwa nawa kwail kirɨt kiztu. ¿Chikishma nawa kuznapa ɨninnamtus? Nuin Moisés kaizta aizpa mɨmtuchi. ");
INSERT INTO kwi_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sua puraruzne ussa kaizara: —Nune Diospa katsa pariyara kwail kizmun. ");
INSERT INTO kwi_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablone kaiznara: —Aimpihshtuz. Nane an katsa pariya ɨninmumikasha pianchiarau. Dios pɨnkɨhta ka parɨt: “Uspawa ɨninmumikasha kwail kizman.” ");
INSERT INTO kwi_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Suasne mɨnpazha Saduceo awakas Fariseo awakas wanmakkarɨt. Sun nɨjkultawane, Pablone katsa mikwa wanmakturuza ka tɨnta kaiznara: —Ap aimpihshtuz, mɨrain. Nane Fariseo awa ish. Ap kwalkas Fariseo awa mai. Uspane nawa kwail kirɨt kizamtu, na awa irɨttas mamasa kakultu kamtamtu akwa. Watcha, Dios irɨttuza mamasa kakulninnanazi nɨjkultus. ");
INSERT INTO kwi_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Sun mɨarawane, Fariseo awakas Saduceo awakas usparuzpain tɨnta kwinta kiamɨz kit paimpa paimpa wanmakkara. ");
INSERT INTO kwi_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceoruzne awa irɨttas kakultuchi kizamtu. Ángelkas wachi; izpulkas wachi, kizamtu. Fariseoruzne sun wanta nɨjkulamtu. ");
INSERT INTO kwi_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wan tɨnta kwianamɨzkane, mɨnpazha Fariseo awane, Moisés kaizara aizpa kamtamtuzne, kaiznara: —An ampune chinkas kwail kitchi. Ussa mɨshipuspas. Sunkana maza izpul, maza ángel ussa kwinta kitka. ");
INSERT INTO kwi_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tɨnta pilchapuzamtu akwa, Suldarura ɨninmumikane Pablo akwa ishkwara, awa ussa piantashiamtu akwa. Suasne suldaruruza ɨninara, Pablora usparuztas ukkanapa. Mamasa suldaruwa kammu yalkin mɨlta. ");
INSERT INTO kwi_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tɨlawa amtane Anpatne Pablora izpan kit kaizta: “Pablo. Tɨnta kulti. Nune na akwa akki Jerusalén pɨpulukin kwinta kira. Sunkanain Roma pɨpulura na akwa kwinta kitpa.” ");
INSERT INTO kwi_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tɨlawara mɨnpazha Judío awane wanmakkat kit nɨjkulara, Pablora piantana. Uspane ka kin namara: “Aune chinkas kuaizamanapas, ussa piantanakima.” ");
INSERT INTO kwi_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Cincuenta panapain Judío ampuruzne sunkana kin namara. ");
INSERT INTO kwi_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Uspane pariya ɨnintuzparakas Judío ɨlapa ɨnintuzparakas ɨat kit kaiznara: —Aune chinkas kwanchi kin namtamakpas, Pablora piantanakima. ");
INSERT INTO kwi_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mane ukas mamaz Judíowa mikwaruzkas suldarura ɨnimmikwara paikwarain, tɨlawara u purakin Pablora karanpa. Ussa ka kaizti: “Aune ussa an nil mɨmapuspas.” Apa atchasmin, aune tɨrɨzaiznapas, ussa piantana. ");
INSERT INTO kwi_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pablowa sobrinone sun piankam kit suldaru kammukin sunpa Pablora kainana ɨra. ");
INSERT INTO kwi_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Sun mɨrawane, Pablone suldaru ɨninmumikasha akwat kit ussa kaizta: —An musittu suldarura ɨninmumikasha mɨlti. Usne ussa chiwazha kizna mɨji. ");
INSERT INTO kwi_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Suldaru ɨninmumikane katsa suldarura ɨninmumikasha ussa mɨl kit kaizta: —Pablone, sɨptɨtmikane, nawa akwat kit paikwara, sun pashpara akkikima karanpa. Usne nua chiwazha kizna mɨji. ");
INSERT INTO kwi_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Katsa suldarura ɨninmumikane sun pashpara chihtɨkin piz kit mɨl kit paimpa mɨmara: —¿Chima kizshiras nawa? ");
INSERT INTO kwi_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Suasne pashpane kaizta: —Judío awaruzne nɨjkulari, tɨlawara nua paikwan, Judío ɨninmumika wanmaktukin Pablora mɨlnapa. Uspane kaizanazi: “Aune Pablowa an nil mɨmashipuspas.” ");
INSERT INTO kwi_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Usparuza mɨmun. Cincuenta panapain Judío ampuruzne kularɨt tɨrizamtu. Uspane chinkas kuamtuchimakpas kin namara, Pablora piantanakima. Mane uspane up sɨnkamtu aizpa tɨrizat kit Pablora piantanapain. ");
INSERT INTO kwi_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Suasne Suldarura ɨninmumikane pashpara ɨri kiz kit mɨnainkas us kwinta kit aizpa kainanachi, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Suasne katsa suldaru ɨninmikane paas ainki suldaru ɨninmumikasha akwanara, akkwan suldarura wanmakninnanapa. Paas cien suldaru mittɨwarain ɨamtu wianta. Setenta suldaru caballowara anuzamtu wianta. Paas cien suldaru tɨ kwizkasa chaamtu wianta. Wan wanmakkarawane, uspane Cesarea pɨpulura tɨlpaka, nueve urara ɨanapain. ");
INSERT INTO kwi_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ussa an ɨninnara, caballo watsanapa, Pablo anuznapa. Ussa mɨlti, katsa mikwa Félixtakima, watmin piananapa. ");
INSERT INTO kwi_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","26","Uspakasa sun pɨnkɨh pat kit ɨninta: Nane Claudio Lisias mun ish. Nane “kakishapu” kiztus. Nune, Félix muntɨtmikane, au kwisha wat katsa mikwa i. An pɨnkɨh nua ɨnintus. ");
INSERT INTO kwi_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judío awane an ampura pizat kit piantanapain. Us Romano awa i piankamtawane, nane ap suldarukasa ɨt kit usparuztas nakanarau. ");
INSERT INTO kwi_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nane chikishma kwail kizamtui kiz piankamshirau. Katmizna nane ussa Judío katsa ɨnintuz wanmakkarɨt purakin mɨltau. ");
INSERT INTO kwi_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Uspa ɨnim akwa, uspane ussa kwail kirɨt kizamtu. Ussa piantana nilchi. Kajchirakas sɨpna nilchi. ");
INSERT INTO kwi_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Judío awa ussa piantashimtu piankamtawane, nane nu tukin ussa azain ɨnintau. Ussa kwail kirɨt kizmuruza kurunnarau, nu iztakin ɨanapa. Suane uspane us kwail kirɨt aizpa nua kizashina. Anne kaiztuchish. ");
INSERT INTO kwi_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Suasne katsa suldarura ɨninmumika ɨnintu aizpa mɨarawane, wan suldarune Pablora pizat kit amtawara ussa Antípatris pɨpulurakima mɨlara. ");
INSERT INTO kwi_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tɨlawara suldaru mittɨwara ɨmtuzne suldaru kammu yalkin kaiyara. Caballokasa ɨmtuzne Pablokasa ɨamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarea pɨpulura piannaarawane, uspane katsa mikwara pɨnkɨh chɨhkara. Pablorakas sua tɨwij ɨara. ");
INSERT INTO kwi_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pɨnkɨh iztawane, katsa mikwane Pablora mɨmara: “¿Nune mɨntas mas?” Cilicia suras arɨt piankamtawane, ");
INSERT INTO kwi_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ussa kaizta: “Nu kwail kirɨt kizmuruz aakane, nua mɨnash.” Suasne suldarura ɨninta, ussa izanapa, Herodespa ɨnintu yalta. ");
INSERT INTO kwi_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco payu pailtawane, Ananíasne, katsa pariyawa ɨninmikane, Cesarea pɨpulura pianara Judío ɨlapa ɨnintuzkasa. Tértulone, awaruza pakpanammikane, pianara. Uspane katsa mikwa iztakin kwinta kiara, Pablora kwail kirɨt kizna. ");
INSERT INTO kwi_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pablora karaarawane, usne Tértulora paranpa akwara. Suasne Tértulone us kwail kirɨt kizmɨz kit Félixta kaizta: —Anpat. Nawa mɨzha. Nune au katsa mikwa i. Nu kwisha wat min kit nil ɨnintu akwa, aune akkwan payukima kalpain uzpuspas. Ukas au su uzturuza kiwainamtus. ");
INSERT INTO kwi_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Aune nu chiwazha au akwa kira aizpa aishtaish kizpuspas. ");
INSERT INTO kwi_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nane nua kwisha kaizapmanash. Katmizna nua paikumtus, aumɨza pitchin mɨnapa. ");
INSERT INTO kwi_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Aune sun ampura wanmaltɨtmakpas. Usne katsa ki piztɨtkanain iztɨt, awara kaizaptu akwa. Uskas wan sura Judío awara paimpa paimpa wanmakninnamtu. Uskas Nasareno awawa ɨninmika i. ");
INSERT INTO kwi_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Us Diospa katsa yalta sɨnamchi sanintu, Griego awa sua napnintɨt akwa. Sun impa. Katmizna aune ussa piztamakpas. Au mikwa kaizta akwa, aune ussa ilshiaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Suasne Lisiasne, katsa Suldaru ɨninmikane, akkwan suldarukasa aat kit ussa auruztas tɨnta ukkarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Suasne Lisiasne aumɨza ɨninnara, up iztukin ɨanapa, Pablo kwail kirɨt kizna. Nuin ussa mɨmashina. Suasne nune au kaizara aizpa watcha i piankamnazi. ");
INSERT INTO kwi_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Judío awa wanmakmuruzne kawarain watcha i kizara. ");
INSERT INTO kwi_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Suasne katsa Félix mikwane chihtɨkasa Pablora anta, paranpa. Pablone ka kaizta: “Nane nu au sura akkwan añokima ɨnintɨt pianish. Katmizna nane na kit aizpa nua parashimtus, piankamnapa. ");
INSERT INTO kwi_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Paas domingoin Jerusalén pɨpulukin piannarau, Diosta wakpuj wain kit Diosta paikwan. Kawarain nune sun mɨmashinai. ");
INSERT INTO kwi_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Uspane mɨnkasainkas tɨnta kwinta kimtu nawa wanmalarachi. Dios katsa yalkinkas Judío kammu yalkinkas mamaz pɨpulukinkas mɨnainkas kaizaptu nawa wanmalarachi. ");
INSERT INTO kwi_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na kwail kirɨt kizarakas, an awaruzne chinkas annasachi. ");
INSERT INTO kwi_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nane nua watcha kaiztus. Nane Anpatpa masas miwara ɨmtus. Sun miwarain nakas au irɨt kwalkana sun Diostain wakpuj waintus. Uspane ‘sun mine kwail i’ kizamtu. Nane Moisés pɨnkɨh para aizpakas Dios pit kainammtuz kaizara aizpakas nɨjkultus. ");
INSERT INTO kwi_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nakas uspakas kawarain Diosta tɨrizpuspas, us kaizta aizpa kin. Diosne irɨttuzakas kwailtuzakas wattuzakas kakulninnanazi. Sun tɨrizpuspas. ");
INSERT INTO kwi_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Katmizna nane pailta payu wat min kit Dios iztakinkas awa iztakinkas nil uzshimtus. ");
INSERT INTO kwi_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Akkwan añochikimain mamaz sura chatpane, nane ap sumarain kailtau, Judío awara pial mɨlan, wakara piantarɨtkas Diosta mɨlan. ");
INSERT INTO kwi_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na sun kimtuasmin, mɨnpazha Judío awaruzne Asia suras aat kit Dios katsa yalta nawa wanmalash. Na Moisés ɨnintɨt aizpa kitpane, Dios iztakin nawa sɨnam sanintawane, uspane sua nawa izara. Akkwan awa purachi. Mɨnminkas pilchapuzarachi. ");
INSERT INTO kwi_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mɨnpazha atchiruzne na kwail kirɨt aizpa kizashira. Uspain aarawa, up iztakin na kwail kirɨt kizana. ");
INSERT INTO kwi_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Uspa na kwail kirɨt kizashitkine, katne akki puraruzne na kwail kit aizpa kiztain. Na Judío katsa mikwaruz iztakin kuntuasmin, ¿Chima kwail kizzi nane? ");
INSERT INTO kwi_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Uspa iztakin kuntuasmin, nane tɨnta ka kaiznarau: ‘Mane uspane na kwail kirɨt kizamtu, na Dios irɨttuza kakulninnamtu kiztɨt akwa.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Félixne Anpatpa masas miwara wat pian. Usne Pablora kwail kirɨt kizshitchi. Katne usparuza kaiznara: —Lisias, katsa suldarura ɨninmumika, akane, nane na kishimtu aizpa uruza kaiznanash. ");
INSERT INTO kwi_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Suasne Félixne suldaru ɨninmumikasha ɨninta, Pablora iznapa. Ussa sɨpnintachi. Pablowa izmuruzne ussa izashina, ussa kiwainapa. ");
INSERT INTO kwi_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Akkwan payuchin Félixkas Drusilakas, paiña Judío ashampakas, mamasa piannail kit Pablora akwanpa ɨninta, Pablo usparuza Jesúspa kamtanapa. Uspane Jesucristowa piankamshiilta, ussa nɨjkulna. ");
INSERT INTO kwi_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablone usparuza ka kaiznara: —Wat uztain. Kwail kishitne, kiman. Mamaz payura Diosne anazi, kwail kimtuza ilnana. Pablo sun kizkane, Félixne ishkwat kit kaizta: —Ɨmɨzti mane. Mamaz an wat payune mamasa nua akwanash. ");
INSERT INTO kwi_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Félixne Pablora akkwan piji akwara, uskasa kwinta kinpa. Usne Pablo pial tanapa tɨrizta, ussa chɨhtna. ");
INSERT INTO kwi_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paas años sunkanain pailtawane, Félixne Pablora chɨhtshitchi, Judío awaruz pashit aizpa kishimtu akwa. Suasne Félixne an katsa mikwakana puzta. Kwiztane Porcio Festone katsa mikwa namta, Félix ɨnimkin. ");
INSERT INTO kwi_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Suasne Festone at kit katsa mikwa namta. Kutña payu pailtawane, Cesarea suras Jerusalén pɨpulura nura. ");
INSERT INTO kwi_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Suane pariya ɨnintuzkas anza katsa Judío awaruzkas Festora ɨara, Pablo kwail kirɨt aizpa kizna. ");
INSERT INTO kwi_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Uspane ussa paikuara, Pablora Jerusalén pɨpulura mɨlnapa. Uspane ussa miwarain piantana minñara. ");
INSERT INTO kwi_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festone Pablo kajchira wa Cesarea pɨpulura sɨnkara. Us sua ɨshimtu akwa, ");
INSERT INTO kwi_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Festone kaiznara: “U ɨninturuzne nakasa Cesarea pɨpulura ɨarawa. An ampu kwail kirɨtne, une sua us chiwazha kwail kirɨt aizpa kizashina.” ");
INSERT INTO kwi_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jerusalén pɨpulura an diez payukimain marawane, Festone Cesarea pɨpulura kihshta. Tɨlawara paiña ɨnim uzmura uz kit suldarura ɨninta, Pablora karanpa. ");
INSERT INTO kwi_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pablo naptawane, Jerusaléntas Judío awaruzne ussa kashara aat kit kwisha akkwan kwail kirɨt ussa kizamɨzta. Pablora akkwan kwail kirɨt kaizarɨtkas, uspane paiña kwail annasachi. ");
INSERT INTO kwi_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Suasne Pabloin us akwa pakpara: —Nane chinkas kwail kitchish. Judío awawa ɨninta aizpara kwail kitchish. Dios katsa yaltakas kwail kitchish. Romano katsa mikwarakas kwail kitchish. ");
INSERT INTO kwi_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festo Judío awara wat kinashimtu akwa, Pablora mɨmara: —¿Jerusalén pɨpulura ɨshimtukish? Suane nane nu kwail kirɨt aizpa izninnash. ");
INSERT INTO kwi_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablone sɨnkara: —Nane Romano katsa mikwa uzmukin tus. Apane nune nawa kwail kirɨt aizpa kiztawa. Nune Judío awaruza kwail kitchi ish wat pian. ");
INSERT INTO kwi_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Na Moisés kaizta aizpa kitchine, irawash. Na kwail kirɨtne, nune nawa iltawa, inapa. Na uspa kaizara aizpa kitchine, mɨnminka nawa Judío awaruza chɨhkasachi. Nane nua paikumtus, nawa katsa mikwa Cesarta, Roma pɨpulura ɨnintumikasha, ɨninnapa, nawa iznapa. ");
INSERT INTO kwi_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Suasne paiña kurunmuruzkasa kwinta kitpane, Festone kaizta: —Nune paikwara, katsa mikwara ɨn. Katmizna katsa mikwara ɨnazi, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Akkwan payuchin pailtawane, Agripa katsa mikwakas paiña ashampa Berenicekas Cesarea pɨpulura ɨilta, Festora “kakishapu” kizna. ");
INSERT INTO kwi_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Akkwan payuchin sua mantazasmin, Festone ɨninmumikasha Pablowa kwinta kit kit kaizta: —Akkine maza ampune tu. Félixne ussa sɨptattɨt. ");
INSERT INTO kwi_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na Jerusalén pɨpulura tuasmin, pariya ɨnintuzkas ɨlapa Judío ɨnintuzkas nawa aat kit Pablo kwail kirɨt kizamɨzta. Uspane nawa Pablora iyanapa paikuara. ");
INSERT INTO kwi_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nane Romano ɨnintuz kaizara aizpa kiz kit ka sɨnkanarau: —Au Roma awaruzne mɨnainkas piantamtuchi. An ñancha us kwail kirɨt kaizmuruzne wanmakkara, paiña iztakin paiña kwail kirɨt aizpa kizanapa. Awa us kwail kimtus kizamtukas, usmin pakpashina. ");
INSERT INTO kwi_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Suasne uspane nakasa apa aara. Tɨriztachin, tɨlawara nane ap ɨnintukin uz kit Pablora kanapa ɨninnarau. ");
INSERT INTO kwi_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Us kwail kirɨt kaizmuruz akane, uspane ussa chinkas kwail kirɨt kizmanamara. Usne na mintu aizpa kitchi. ");
INSERT INTO kwi_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Uspakas Pablokas nɨjkularachi, miza Diosta wakpuj wainna, Diosta paikwan. Pablone kaiztu: “Jesúsne, irɨtmikane, uzi,” kiztu. ");
INSERT INTO kwi_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Uspa pilchapuzamtu akwa, nane we piankam kit chi kin pianchiarau. Katmizna nane Pablora ka mɨnmarau: “¿Jerusalén pɨpulura ɨshimtukish? Tane uspane nu kwail kirɨt kizshianazi.” ");
INSERT INTO kwi_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mane usne nawa paikwara, katsa mikwara ɨnninnapa, awa ussa kwail kirɨt aizpa kizanapa. Nane ussa kajchira sɨpnintau, na Augusto katsa mikwara ɨninnakima. ");
INSERT INTO kwi_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripane Festora kaizta: —Nakas an ampura mɨshimtus. Festone sɨnkara: —Tɨlawain ussa mɨnazi. ");
INSERT INTO kwi_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tɨlawara Agripakas Berenicekas watsal pĩn kwaat kit pianail kit awa wanmakmukin nappailta. Katsa suldaru ɨnintuzkas pɨpulura ɨnintuzkas purara. Awane sua kɨh ulpianara. Suasne Festone Pablora kanapa ɨnintawane, ");
INSERT INTO kwi_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","kaiznara: —Mɨrain. Au katsa mikwa Agripakas wan awa aukasa wanmakturuzkas mɨrain. Une an ampura, au akki mɨjmikasha izamtu. Us akwa kwisha akkwan Judío awaruzne Jerusalén pɨpuluraskas an pɨpuluraskas aat kit kwianta, nawa an ampu irawa kizanapa. ");
INSERT INTO kwi_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nane paiña kwail kirɨt aizpa wat pianchish, ussa piantana. Mane usmin nawa paikwara, katsa mikwara, Cesarta, ɨnninnapa, us kwail kirɨt aizpa kiznapa. Nane ussa katsa mikwara ɨninshimtus. ");
INSERT INTO kwi_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Makima nane Pablowa chinkas mɨjchish, ap anpatta katsa mikwara pana. Katmizna nane ussa nu iztakin kararau. Nane nua, au mikwa Agripawain iztakin, kararau, ussa mɨmanapa. Suasne nane chiwazha mɨj aizpa Cesarta pɨnkɨh panash. ");
INSERT INTO kwi_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nane nil chi mintus, kajchira sɨptɨtmikasha ɨninnapa, us kwail kirɨt kiztachine. ");
INSERT INTO kwi_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Suasne Agripane Pablora kaizta: —Nuin nu kit aizpa pakpashinai. Pablone chihtɨ anak kit ka paramɨzta: s ");
INSERT INTO kwi_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Au ɨninmika Agripa, mɨzha. Nane watsal kultus, nu iztakin tuan, na kit aizpa kaizna. Judío awane na kirɨt aizpa watcha kizamtuchi. ");
INSERT INTO kwi_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nune miza au Judío awa uzamtu an wat pian. Judío awa nɨjkulamtu aizpa wat pian. Katmizna nua paikumtus, nawa wat mɨnapa.” ");
INSERT INTO kwi_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wan Judío awane nawa ainki asmin pian. Nane uspakasa Jerusalén pɨpulurakas ap surakas uztau. ");
INSERT INTO kwi_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Na musittuasmin, nane Judío Fariseo awa kamtatɨtkanain uztau. Uspane na nil uzta wat pian. Uspane na miza uzta nua kaizashina. ");
INSERT INTO kwi_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Diosne Judío awaruza sun kin namnara, irɨttuza kakulninnana. Na sunpa nɨjkultu akwa, uspane nawa karaarai, nawa kwail kirɨt kizanapa. Nakas au kwalkana Diosta tɨriztus, us kin namta aizpa kinkima. ");
INSERT INTO kwi_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Au doce Judío kwaltuzne Dios sun kin namta aizpa tɨrizamtu, sun kinkima. Katmizna uspane pailta payu Diosta wakpuj wainñamtu. Katsa mikwa Agripane, mɨzha. Na Dios sun kinpa tɨriztu akwa, an Judío awane nawa kwail kirɨt kizamɨztu. ");
INSERT INTO kwi_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","U Judío awa, mɨzhain. ¿Chikishma Dios awara irɨttas kakulnintu nɨjkulamtuchi?” ");
INSERT INTO kwi_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ñamin nakas Jesústa aliz kulna mintu arau. Usne Nazaret pɨpuluras ara. ");
INSERT INTO kwi_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Sunkana Jerusalén pɨpulukin kirau. Judío pariyaruzne pɨnkɨh paat kit nawa sun pɨnkɨh chɨhkat kit nawa ɨninñara, uspa kiashimtu aizpa kin. Nane kwisha akkwan Jesústa nɨjkulturuza kajchira sɨpnarau. Awa usparuza piantanamtuasmin, nakas nɨjkultu arau. ");
INSERT INTO kwi_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nane akkwan piji usparuza ilnarau, ‘Jesústa pianchish’ kaizanapa. Kawarain wan Judío kammu yaltakima sun kirau. Na usparuza kwisha pilchapuznara akwa, nane mamaz surakima usparuza piznashirau.” ");
INSERT INTO kwi_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Katmizna sun kishimtu akwa, nane Damasco pɨpulura ɨmɨztau. Pariya ɨnintuzne nawa pɨnkɨhkasa ɨninñara, uspa paraara aizpa kin. ");
INSERT INTO kwi_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ɨninmumika mɨri. Miwara ɨmtuasmin, nane paizka payura impil chiyuras iztau. Impilne pa kinka anza kai nawakas ap izmuruzakas malta. ");
INSERT INTO kwi_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Suasne aune pilta nainaiznash. Suas nane mazara kwinta kika mɨrau. Usne Hebreo pit paraka nawa kaizta: ‘Saulo, Saulo. ¿Chikishma nawa kwail kimtus? Nawa mɨrakine, nune nuin kwail kimtu. Nune wakara ampukana i. Pamika wakarara tɨ kwizkasa papa kimtukana, usne mittɨ tɨnta kulmu. Nukas aliz kultu, na nua kuruntu aizpa mɨshimtuchi akwa.’ ");
INSERT INTO kwi_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Suasne nane mɨmarau: ‘Anpat, ¿Nune mɨnmas?’ Anpatne nawa kaizzi ish: ‘Nane Jesús ish. Nune nawain kwail kimtu. ");
INSERT INTO kwi_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mane kuhsak kit kunti. Nane nua narɨt, nawa kiwainapa, nu izta aizpa kainanapa. Nane nua izpantau, an impara impara nu iztu aizpa awaruza kainanapa. ");
INSERT INTO kwi_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nane nua Judío awaraskas mamaz awaraskas paimpa chɨhtnash, uspa nua kwail kiamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mane nane nua ɨnintus, Judío awachiruz watcha piankamanapa. Nune tɨlkwilta chamturuza, Satanás miwara ɨmturuza, kurunnarawa, kaira chaanapa, Dios miwara chaanapa. Suasne Diablone usparuza ɨninmanazi, uspa Diosta kaiyara akwa. Nawa nɨjkulamtu akwa, nane uspa kwail kiarɨt aizpa wat kulnanash. Nakas Dios narɨttuza chiwazha chiyura mɨlananash, Dioskasa uzna.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Au Agripa mikwa, mɨzha. Chiwazha chiyuras izpankane, nane Jesús kaizta aizpa mɨt kit kirau. ");
INSERT INTO kwi_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","An ñancha nane Damasco pɨpulura uztuza Dios pit kainanarau. Suasne Jerusalén pɨpulura uztuzakas, wan Judea sura uztuzakas, Judío awachiruzakas Dios pit kainanarau. Nane usparuza akwanarau, uspa kwail kiarɨt maizanapa, Diosta kaiyanapa. Uspane wat kal kiarawa. Mamaz tuntu uzarane, awane uspa maizarɨt awakana uzamtu kizanazi. ");
INSERT INTO kwi_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sun akwa, Judío awaruzne nawa Dios katsa yalkin pizat kit nawa piantashiamtu. ");
INSERT INTO kwi_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Dios nawa makima kiwaintu akwa, nane kun kit wan awaruza chiwal na pian aizpa kainanamtus. Nane Dios pit kainammtuz kaizta aizpakas Moisés kaizta aizpakas sunmin kaiztau. Nane uspa kaizara aizpa kawarain mamasa ka kaiztus: ");
INSERT INTO kwi_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","‘Dios narɨtmikane ishina. Irawane, Diosne ussa irɨttas an ñancha kuhsnazi. Katmizna Diosne Judío awaruzakas mamaz awaruzakas wat kakulninshina, usparuza watsat mɨlnanapa. Jesús uztu akwa, Diosne Jesústa nɨjkulturuza uzninnanazi.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pablo us akwa sun pakpakane, Festone ka kwianta: —Pablo. Nune nukku parɨt. Akkwan pɨnkɨh iz kit nukku parɨt, kizta. ");
INSERT INTO kwi_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pablone Festora sɨnkara: —Au wat mikwa, nane nukku chi ish. Sunkana na kaiztu aizpa watcha i. Nil i. ");
INSERT INTO kwi_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Apane katsa mikwane, Agripane tui. Usne na kaiztu aizpa wat pian. Katmizna nane us iztakin watsal paramtus, ishkwatchin. Uskas wan kiarɨt aizpa wat pian. Wan awane chiwazha kiarɨt aizpa pian. Chinkas kulamtuchi. ");
INSERT INTO kwi_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Katsa mikwa, Agripa, ¿Dios kaizmuruz parɨt aizpa mɨmtukish? Watcha, nune uspa parɨt aizpa mɨmtu. ");
INSERT INTO kwi_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripane Pablora kaizta: —Pitchin pit paramtuasmin, nune nawa Jesústa pianmikakana namninshina. ");
INSERT INTO kwi_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Suasne Pablone sɨnkara: —Watcha, nane pitchin pit pararau. An akkwan pit nua parashimtus. Nane Diosta paikumtus, nuakas wan awaruzakas, nawa mɨmtuzakas Jesústa piankamanapa. Une nakana Jesústa piankamtakanain namashina, cadenakasa kuhtachin. ");
INSERT INTO kwi_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pablo sun kiztawane, katsa mikwakas, ɨninmumikakas, Berenicekas, wan sua uztuzkas, kunat kit ");
INSERT INTO kwi_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","paimpa sun kirɨt aizpa kwinta kin ɨara. Usparuzpain kaizara: —An ampune chinkas kitchi. Kajchira wasachi. Ussa piantasachi. ");
INSERT INTO kwi_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripane Festora kaizta: —Mane an ampu au Cesarta, katsa mikwara, ɨn paikwarɨt akwa, aune ussa chɨhtsachimakpas. ");
INSERT INTO kwi_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Minpa uspane aumɨza Italia sura ɨninnashiara. Festone Pablorakas mamaz sɨptɨttuzakas Julio muntɨtmikasha chɨhkanara, usparuza iznanapa. Julione Augusto suldaru muntuza ɨninnara. ");
INSERT INTO kwi_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Suasne aune katsa kanuara waaiznash. An kanua pimamin Adramitio pɨpuluras arɨt. An kanua Asia suwara pimawarain ɨnpain. Aristarcokas aukasa tuazi. Usne Macedonia suras Tesalónica pɨpuluras arɨt. ");
INSERT INTO kwi_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tɨlawara Sidón pɨpulura pianaiznash. Suane Julione Pablora wat kira, izmuruzpara izna ɨnpa, Pablora kiwainapa. ");
INSERT INTO kwi_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sidón pɨpuluras puzarawane, tɨnta inkwa pamtu akwa, aune Chipre su pi paizkakin mamarain pɨnaiznash, inkwa aumɨza nuppainmanpa. ");
INSERT INTO kwi_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Katsa piwara ɨamtuasmin, aune Cilicia su makiminkas Panfilia su makiminkas pɨnaiznash. Mira pɨpulura Licia sura pianarawane, aune kanuaras kihshaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Suane suldarura ɨninmumikane, Julione, Alejandría pɨpuluras kanuara wanmalta. An kanua Italia sura ɨmtu akwa, aumɨza kanuara waaninpailnash. ");
INSERT INTO kwi_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tɨnta inkwa pamtu akwa, akkwan payukima impara impara ɨaiznash, kasha Gnido pɨpulu makin piannankima. Tɨnta inkwa pamtu akwa, Salmona su makin pɨn kit Creta su pi paizkakin pɨlzaaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Puijna kal akwa, Creta su pimawarain imparain ɨaiznash, kanua piannamkin piannankima. Sun piannamkin Buenos Puertos muntɨt. Lasea pɨpulu kashain uz. ");
INSERT INTO kwi_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Impara ɨamtu akwa, akkwan payu parɨt. (Sua tɨriztuasmin, Pascua pishta taizta.) Katsa alu kishimtu akwa, inkwa tɨnta pashimtu akwa, piwara ɨashichi. Kanua paltainshina. Katmizna Pablone kurunnara: ");
INSERT INTO kwi_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Izmuruz, nawa mɨrain. U kanuawara ɨamɨztune, akkwan kwail aumɨza kirɨnazi. U kanuakas kanuara kwa aizpakas kashina. Aukas ishinamakpas. ");
INSERT INTO kwi_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Suldaru ɨninmumikane, Julione, Pablora mɨrachi. Usne kanuawamika kuruntu aizpa mɨra. Kanua puijmuruz kuruntu aizpa mɨra. ");
INSERT INTO kwi_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Alu kimtu akwa, inkwa pamtu akwa, uspane an kanua piannamkin akkwan payu nukkulashitchi. Kwinta kimtuasmin, an akkwanne tas puzna minñara. Fenice kanua piannamkin Creta su pi paizkakin ɨshiara, ta piannashina. Uspane alu palnakima inkwa pailnakima sua mashiara. An kanua piannamkis mazane pamals puzshina. Pa payapmura kaiwarain azi. ");
INSERT INTO kwi_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Suasne África suras inkwa impara pamɨzkane, uspane ɨn minñara. Pi ayuktas uk tainak kit kasha Creta suwara ɨamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Sun urain an tɨnta inkwa Creta suras pamɨz kit kanuara nuppainta. Pa puzmumals pamtu. ");
INSERT INTO kwi_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Tɨnta inkwa pamɨz kit kanuara paltainmɨzkane, aune kanuara inkwa akwa puijsachimakpas. Au kanuara puijsachi akwa, inkwane nuppain kit aumɨza mɨlta. ");
INSERT INTO kwi_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Aune Cauda su pi paizkakin, inkwa tɨntachi pamtukin, pɨnaiznash. Akkwan kal kitpane, aune ainki kanuara tain kit katsa kanuara watsaaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ainki kanua katsa kanuara ɨsal nuarawane, katsa kanuara tɨtkasa sam kuhara. Suasne Sirte ksuwara pul piwara ɨamtuasmin, uspane ishkuarɨt, inkwa nupamtu akwa. Uspane pĩnkas taizninñara, an azain ɨmanpa. Suasne inkwain aumɨza nuppainta. ");
INSERT INTO kwi_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tɨlawara inkwa tɨnta pamɨztuasmin, uspane uspa chiwazha kanuara wintɨt aizpa kanuaras pira kiakpɨnamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kutña payura uspane uspa chihtɨkasain pĩnkas wan tɨkas tɨtkas kiakpɨnara. ");
INSERT INTO kwi_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Akkwan payukima aune pakas kɨmakas izamanash. Inkwa kwisha tɨnta pamɨztuasmin, kanua paltainmɨzta. Minpara aune auruzpain watcha inapain minaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Au kwisha akkwan payukima kuarachi akwa, Pablone uspa paizkakin kun kit kaiznara: —Izmuruz mɨrain. Na kaiznara aizpa wat mɨana watmare. Creta suras puzmanpa watmare. Mane aune naizpuspas. Une wan mɨj aizpa kaarɨt. ");
INSERT INTO kwi_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","U sun kiarɨtkas, wat min kit tɨnta kultain. Mɨnminkas iamanazi. Kanuarain azpian kit karɨnazi. ");
INSERT INTO kwi_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nane Diospa kiwainmika ish. Ma amta usne paiña ángelta nawa ɨninta. Nawa izpamtuasmin, ");
INSERT INTO kwi_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ángelne nawa kaizzi ish: “Pablo. Ishkumun. Nune katsa Romano mikwara, Cesarta, ɨtpa. Diosne nu akwa wan kanuara waruza kiwainanazi, iamanpa.” ");
INSERT INTO kwi_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Katmizna, ap izmuruz, ishkuman. Nane Diosta nɨjkultus. Paiña ángel nawa kaizta aizpa watcha i pianish. ");
INSERT INTO kwi_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Inkwane aumɨza mamaz su pi paizkara nuppainnanapas. ");
INSERT INTO kwi_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Paas domingo pɨntawane, inkwane kanuara nuppainmɨzta Adriático piwara. Kakwamtane kanua kiwaintuzne nɨjkulara, pilta piannanpain. ");
INSERT INTO kwi_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Uk tɨtkasa pi ayuktakima kiain izara, yawa ainkihkas anizna. Viente sa anizara. An kwiztane mamasa anizara. Quince sa anizara. ");
INSERT INTO kwi_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Katsa ukta patkirɨn akwa, ishkuat kit ampara kwisha katsa uk kuh kit kanua pɨlmal kiainñara, an azain chi ɨmanpa. Ishkuat kit tɨrizara, kɨnnakima. ");
INSERT INTO kwi_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kanua kiwaintuz kanuaras ɨashimtu akwa, uspane katsa kanua pitkis ainki kanua pira inkihshamɨzta. Uk tɨt kuhtɨt kiaintukanain kiara. ");
INSERT INTO kwi_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pablone Juliorakas, suldaru ɨninmikashakas, suldaruruzakas kainanat kit kaiznara: —Uspa katsa kanuara maarakine, une pilta pianasachi. ");
INSERT INTO kwi_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Suasne Suldaruruzne ainki kanuawa tɨt tɨttat kit kanua pira taizninñara. ");
INSERT INTO kwi_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Tɨlawain kɨnmɨzkane, Pablone wanta kurunara, chiwazha kuaiznapa. Usparuza kaiznara: —Me paas domingo une tɨrizamtu, pittarachikas, kuaarachikas. ");
INSERT INTO kwi_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nane uruza paikumtus, chiwazha kuaiznapa. Une kuarawa, najamanpa. Mɨnminkas iamanazi. Chinkas naizamanazi. ");
INSERT INTO kwi_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sun kiztawane, Pablone pan chihtɨkin mut kit wan iztakin Diosta aishtaish kiz kit kuara. ");
INSERT INTO kwi_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Suasne pan nailtawane, wanne wat kulat kit kuamɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Aune kanuara 276 awa wamanash. ");
INSERT INTO kwi_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Uspa kwashit aizpa kuarawane, uspane wan chara pippa pira kiakpɨnnara, kanua an ɨsalmin pɨla kirɨnpa. ");
INSERT INTO kwi_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kɨnmɨzkane, kanua kiwainmuruzne sun pil piankamarachi. Ainki pi wankin izamtuasmin, uspane kanuara puijshiara, pi ksurakima. ");
INSERT INTO kwi_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Katsa uk kuhtɨt tɨttat kit pira taizninñara. Tailmu tɨkas puijmu tɨkas chɨhtara. Suasne inkwa nupaim pĩn kanua pitkin panaara, kanua pi ksurakima ɨmɨznapa. ");
INSERT INTO kwi_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Paas pi wankin ɨmtuasmin, kanua pi ayukta ksura tɨnta uz kira. Kanua pitmalne pi ksura naptɨt. Ɨchiwal. Tɨnta inkwa pamtu akwa, pine kanua pɨlmal azpianmɨzta. ");
INSERT INTO kwi_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Suasne suldaruruzne kuhtɨttuza piantashinara, pi kamtawara ɨamanpa. ");
INSERT INTO kwi_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Suldarura ɨninmikane, Julione, Pablora kiwainshira, imanpa. Katmizna ussa piantashitchi. Usne pi kammuruza an ñancha ɨninnara, pira taizanapa, pilta piannaanapa. ");
INSERT INTO kwi_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kwiztane mamaztuza ɨninnara, tapɨlara ɨanapa, kanua pittira ɨanapa. Sunkana wanne pilta watmin pianaara. ");
INSERT INTO kwi_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Pilta watmin purasmin, su pi paizkakinne Malta muntɨt piankamaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Malta sukin uzturuzne aumɨza kwisha wat kiwainnara. Alu kimtu akwa, tɨh pamtu akwa, uspane katsa ĩn usappat kit aumɨza akwanara, ikulanapa. ");
INSERT INTO kwi_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Suasne Pablone sɨ pul sak kit sɨ pul ĩnta kiainmɨzta. Sun kimtuasmin, ĩn akwa kamtane sɨras puz kit Pablowa chihtɨkin kanta. ");
INSERT INTO kwi_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malta sukin uzturuzne Pablowa chihtɨra kamta kan kirɨt izat kit mamazta mamazta minñat kit kaizara: “An ampune mamaz awara piantamashinai. Pi kwamasarakas, au diosne, nil muntɨtmikane, ussa uzninnasachi,” kizara. ");
INSERT INTO kwi_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pablone kamtara ulpianta, ĩnkin taiznapa. Ussa chinkas kitchi. ");
INSERT INTO kwi_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wanne us kiparɨnazi minñamɨzta. Usne irɨnazi minñamɨzta. Kwisha tɨrizarawane, ussa chinkas kitchi izakane, uspane mamaz tuntu minñat kit Pablowa kaizamɨzta: —Usne maza dios i, kizara. ");
INSERT INTO kwi_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Au piannatkin an pi paizka sukin mikwane sua uzta. Usne kashara paiña su mɨjara. Usne Publio muntɨt. Usne kutña payukima aumɨza yal nammɨlat kit kwisha wat kiwainta. ");
INSERT INTO kwi_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiowa papihshne pitmukin imtu tuara, imukasakas pɨwikasakas. Pablone ussa izna ɨra. Diosta us akwa paikwatpane, ussa chihtɨkasa paat kit ussa kakulninta. ");
INSERT INTO kwi_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Sun kitpane, mamaz imturuzne sun pi paizka sukis ussa aara. Wanta kakulninnara. ");
INSERT INTO kwi_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Uspane aumɨza wat minñat kit kwiztane au we aizpa wantain mɨlaara. Mamasa kanuawara ɨamtuchasmin, uspane au we aizpa aumɨza mɨlaara. ");
INSERT INTO kwi_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kutña mish pailtawane, aune kanuara waat kit su pi paizkakis ɨaiznash. Alu kimɨzta akwa, an kanua an ñamin Alejandría pɨpuluras at kit sua mara. Sun kanua pitkin paas dios kɨzpukanain waj. An diosne Cástorkas Póluxkas muntɨt. ");
INSERT INTO kwi_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Siracusa kanua piannamkin pianarawane, aune kutña payukima maaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Suasne pimamin pɨlzat kit Regio pɨpulura pianaiznash. Tɨlawara inkwa suras pamɨzkane, aune paas payukanain Puteoli pɨpulura pianaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Suane aune mɨnpazha Jesústa piantuzkasa wanmalanash. Uspane aumɨza yal nammɨlanara maza domingokima. Kwiztane Roma pɨpulura ɨaiznash. ");
INSERT INTO kwi_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roma pɨpuluras izmuruzne au aamtu piankamat kit mimal aumɨza wanmalnaara. Mɨnpazha Apio pɨpulura muntɨtkin ɨara. Mamaztuzne kutña pitmu muntɨtkin ɨara. Pablone usparuza iznat kit Diosta aishtaish kizta. Usne kwisha wat kulta. ");
INSERT INTO kwi_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roma pɨpulukin piannatpane, suldaru ɨninmikane, wan kuhtɨttuza kajchira chɨhkanara. Pablone suldaru ɨninmikasha paikwara, paimpa uzna. Sua maza suldarune ussa izta. ");
INSERT INTO kwi_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kutña payu pailtawane, Pablone Roma pɨpuluras Judío awa ɨninturuza akwanpa ɨninnara. Wanmakkarawane, kaiznara: —Añaruz, nawa mɨrain. Nane Judío awaruza chinkas kitchish. Na au an ñancha kwal uztuza kwail kitchikas, Judío awaruzne Jerusalén pɨpulukin nawa pizat kit Romano ɨninturuza chɨhkaara. ");
INSERT INTO kwi_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nawa mɨmarawane, uspane nawa chɨhtshiara, na kwail kitchi akwa. Na kwail kitchikas, uspane nawa piantashiara. ");
INSERT INTO kwi_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Judío awa nawa chɨhtshiarachi akwa, nane Romano katsa mikwara ɨninnapa paikwarau, nawa iznapa, na kwail kirɨt aizpa kiznapa. Nane au awaruza kwail kiarɨt kiznamtuchish. ");
INSERT INTO kwi_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Katmizna, nane uruza akwanarau, uruza iz kit parananapa. Judío awaruzne Dios ɨnintamikasha izshiat kit tɨrizamtu. Na Jesúspa kwinta kimtu akwa, mane nane cadena kuhtɨt tus. ");
INSERT INTO kwi_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Suasne Judío awaruzne kaizara: —Aune Judea sura uzturuztas pɨnkɨh nuwa sappamanash. Judío aimpihsh tas piannamtuzne nuwa kwail kizarachi. ");
INSERT INTO kwi_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aune nu mintu aizpa mɨshipuspas. Aune masas wanmakmuruzpa mɨat kit Jesústa kanpamtuzpa piankamshimtumakpas. Wan awane masas wanmakmuruza aliz kulamtu. ");
INSERT INTO kwi_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Suasne maza payu ussa izna naarawane, kwisha akkwan awane Pablo tukin piannaara. Tɨlawain nashnakima Pablone usparuza Dios awaruza ɨninshinamtui kiz kit nil kainanara. Usne usparuza kamtanat kit us kaizta aizpa watcha i mɨnninnashira. Usne Moisés kaizta aizpakas Dios pit kainammtuz kaizta aizpakas kamtanara, Jesústa piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mɨnpazha Pablo kaizta aizpa nɨjkulara. Anpane mɨarachi. ");
INSERT INTO kwi_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Usparuzpain Pablo kaizta aizpa nɨjkulamtuki akwa, ɨamɨzta. Suasne Pablone minpa pit kaiznara: “Diospa Sɨnam Izpulne an ñancha kwalta watcha kainanara. Usne Isaías kainammmikasha ka paninta: ");
INSERT INTO kwi_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘An awara ɨt kit kaiznari: Dios kainammtuza mɨarakas, une piankamamanazi. Uspa para aizpa izarakas, une nɨjkulamanazi. ");
INSERT INTO kwi_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","An awa piankamashitchi akwa, usparuzpa kailne mɨasachikana parɨt, usparuzpa kasune sɨppatɨtkana parɨt. Katmizna nɨjkulashitchi akwa, mɨashitchi akwa, uspane piankamasachi. Uspane nawa kaiyamanazi, na usparuza watsat mɨlnanapa.’ ” ");
INSERT INTO kwi_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ɨamtuchasmin, Pablone kaiznara: “Mane une piankam kit mɨrain. Makis Diosne paiña pit Judío awachiruza ɨninamtu, usparuza watsat mɨlnanapa. Uspane watcha ussa mɨanazi.” ");
INSERT INTO kwi_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Pablo sun kiztawane, Judío awane ɨat kit usparuzpain tɨnta kwinta kiara.) ");
INSERT INTO kwi_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pablone yal nampiz kit paiña yalta uzta. Paas añokima sua uz kit wan ussa iznamtuza napninnara. ");
INSERT INTO kwi_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pablone Dios awaruza ɨninashimtui. Wanta kaiznat kit Anpat Jesucristowa kamtanara. Mɨnminkas ussa pilchapuzarachi. Pailti.");
INSERT INTO kwi_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nane Pablo mun ish. An pɨnkɨh uruza panamtus. Nakas Jesucristowa kiwainmika ish. Diosne nawa nat kit akwat kit paiña ɨnintamika namta, paiña watsal pit akkwan awaruza kainananapa. ");
INSERT INTO kwi_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Diosne ñamin paiña watsal pit paranana namta. Suasne paiña kainammturuza Dios pit pɨnkɨhta paninnara. ");
INSERT INTO kwi_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Sun pitne Dios Painkulpa, au Anpat Jesucristowa kainammtu. Awakanain kawira. Ñamin paiña pampane David munazi. Ñamin Davidne katsa mikwa azi. Diosne ussa Dios Painkul mun kit paiña Sɨnam Izpul akwa irɨttuztas tɨnta kakulninta. ");
INSERT INTO kwi_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Cristo akwa, Diosne nawa kiwain kit paiña ɨnintamika namta, paiña pit kainanapa, akkwan awa wan suras nɨjkulat kit Dios ɨninta aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Diosne uruzakas, Roma pɨpulura uztuzakas, akwanara, Jesucristora piankamanapa. ");
INSERT INTO kwi_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nane uruza, Roma pɨpulura uztuza, Diosta pashimturuza, an pɨnkɨh panamtus. Mane nane au Diostakas au Anpat Jesucristorakas paikumtus, uruza wat kiwainanapa, kalpain uzanapa. ");
INSERT INTO kwi_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","An ñancha nane Diosta u akwa aishtaish kiztus, Jesucristo uruza tɨnta kiwainnara akwa. Nakas watsal ish, akkwan awa au sukin u Jesucristora nɨjkulamtu aizpa mɨamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nane Diospa kal sap kit tɨnta kal kirau, Dios watsal pitkas paiña painkulpakas kainanapa, pailnakima. Pailta payukima Diosta paikumtasmin, nane uruza minamtus. Diosne na kiztu aizpa watcha i pian. ");
INSERT INTO kwi_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nane Diosta paikumtus, na u uzkinkima piannan, sun minpa payura uruza iznana. Dios sun pashitne, kainchash ɨrɨnash. ");
INSERT INTO kwi_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nane uruza kwisha iznashimtus, Dios Sɨnam Izpul uruza kiwainnamtu kamtanana. Suasne une u kaijchura an tɨnta namanazi. ");
INSERT INTO kwi_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Sunmin kaiznashimtus. Aune auruzpain kiwaintawamakpas. Une an tɨnta kulashina, na nɨjkultu akwa. Nakas an tɨnta kulshinas, u nɨjkulamtu akwa. ");
INSERT INTO kwi_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Cristora nɨjkulturuz, na pampa payukima u uzkin pianashira piankamtain. Chiwazha nawa ɨnintachi. Makima pianasachish. Nane u uzkin awaruza Jesucristora nɨjkulninnashimtus. Mamaz sura sunkana kirau. ");
INSERT INTO kwi_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nane kiwainmumika ish, wan awaruza kiwainana. Nane altɨm awaruzakas musu awaruzakas kiwainashimtus. Nakas pɨnkɨh pianchiruzakas pɨnkɨh piantuzakas kiwainashimtus. ");
INSERT INTO kwi_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Katmizna nane uruzakas, wan Roma pɨpulura uztuzakas, Dios watsal pit kainanashimtus. ");
INSERT INTO kwi_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nane Dios watsal pitpa mɨtsal kimanash. Sun pitkasa Diosne wan Dios pit para aizpa nɨjkulturuza watsat mɨlnanashina. An ñancha Judío awaruzakas, an kwizta Judío chi awaruzakas watsat mɨlnanashina. ");
INSERT INTO kwi_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Diosne paiña watsal pitkas aumɨza mɨnninnamtu, nil uzanapa. Diosne Diosta nɨjkulturuza nil uzninnashinai. Dios pit ka parɨt: “Diosne ussa nɨjultumikasha nil namninnazi, pailta payukima uzanapa.” ");
INSERT INTO kwi_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Chiyuras Diosne wan awaruza Dios kimtu aizpa mɨninnamta. Awa Diosta nɨjkularachi akwa, Diosne usparuza ilnanazi, uspa kwail kiarɨt akwa. Uspa kwail kiamtu akwa, uspane watcha Dios kaiztu aizpa sappashimtuchi. ");
INSERT INTO kwi_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sun akwa Diosne usparuza ilnanazi. Uspane Diospa wat piankamara, us usparuza Diospa annara akwa. ");
INSERT INTO kwi_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Dios an su sarasmin, awane Dios tɨnta i piankamashina. Diosta izasachikas, Diostakas piankamashina, paiña kal an sukin kimtu akwa. Katmizna sun kwail awaruzne Dios iztakin uspa kiarɨt aizpa pakpaasachi. ");
INSERT INTO kwi_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Diospa mɨamtukas, Dios uztu piankas, uspane Dios kwisha wari kizarachi. Diosta “aishtaish” kizarachi. Uspa minñakane, uspane Diospa minñashitchi. Kain minñamtu akwa, uspane tɨmpa awakana minñara. Uspane wat chi minñara. ");
INSERT INTO kwi_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Akkwan pianmakpas kizamtukas, uspane tɨmpa awakana mai. ");
INSERT INTO kwi_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mane uspane Dios uzmikasha wakpuj wainñamtuchi. Tɨ awakana sarawane, sunta wakpuj wainñamtu. Katsa wamkanakas, kalpakanakas, piaintɨkanakas saat kit wakpuj wainñara. ");
INSERT INTO kwi_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Katmizna tɨmpa awa akwa, Diosne usparuza chɨhkanarɨt, wan kwail minñashimtu aizpa kianapa. Usparuzpain akkwan tuntu mɨtsal kwail kiarɨt, uspa ñakin kwail kiarakima. ");
INSERT INTO kwi_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Uspa watcha Diosta nɨjkulashitchi akwa, uspane tɨkasa sarɨt aizpa wakpuj wainñara. Sun tɨne dios chi. Uspane wan dios sarɨt aizpa minñat kit wakpuj wainñara. Diosta, wan saramikasha, wakpuj wainñashitchi. Awane an wat Diostain pailta payukima wakpuj wainñarawa. Sunne watcha i. Ka. ");
INSERT INTO kwi_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Tɨmpa awa sunkana kiamtu akwa, Diosne usparuza chɨhkanarɨt, wan mɨtsal kwail minñamtu aizpa kianapa. Paas ashampane parejuin pitshiilta. Mazane ampukanain namtu. Ashamparuzpain pit kit kwail kiamtu. Sunkana uzam. ");
INSERT INTO kwi_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Kawarain ampuruzne uspa ashamparuza chɨhkamtu, ashampakasa pitmanpa, ampukasa pittana. Paas ampune parejuin pitshiilta. Mazane ashampakanain namtu. Ampuruzpain pit kit kwail kiamtu. Sunkana uzam. Sun kwailne mɨtsal kiarɨt. Katmizna uspa sunkana uzamtu akwa, Diosne usparuza ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Diospa watmin minñamtuchi akwa, uspane Diosta piankamashitchi. Katmizna Diosne usparuza chɨhkananazi, uspa kwail minñamtu aizpa kianapa. ");
INSERT INTO kwi_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Uspane wan tuntu kwail kiashimtu. Mamaztuza kwail kiashimtu. Mamaz mɨjtuzkin an akkwan pashiamtu. Wan awaruza aliz kulamtu. Patna mɨj aizpa pashiamtu. Mamaztuza piantashimtu. Mamazkasa waya kiamtu. Uspane mamaztuza pɨrail appamtu. Akkwan tuntu kwail kiana minñamtu. Mamazpa parakane, kwail paraamtu. ");
INSERT INTO kwi_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Anparuzne mamaztuzpa kwail paramtu. Diosta aliz kulamtu. An we tɨntamikasha aliz paramtu. Usparuzpain “aune an tɨnta makpas” kizamtu. Mamaztuza “aune an tɨnta makpas” kizamtu. Mamaztuza kwail kianapa minñamtu. Uspane papihshtakas akkuhshtakas mɨashimtuchi. ");
INSERT INTO kwi_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Uspa minñarakas, mɨashitchi. Uspa kin namtu aizpa kiamtuchi. Uspa kwaltuza pashiamtuchi. Mamaztuza wat kulashimtuchi. Naizturuz akwa chinkas mazamtuchi. ");
INSERT INTO kwi_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Sun awa Dios kaizta aizpa an wat piankas, Diosne sunkana kwail kimturuza iarɨnazi kiznara. Sun kwail kimturuzne mamaztuz kwail kiamtu aizpa wari kizamtu. ");
INSERT INTO kwi_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Diosne Judío chi awaruza ilnanazi, uspa kwail kiamɨztu akwa. Katmizna mɨnminkas uruztas Judío chi awaruza nu kwail kirɨt kaiznawachi. Judío awa Judío chi awaruza “nu kwail kirɨt” kizturuzne uruzpain Dios iztakin pakpasachi, nukas sun kwailmin kimtu akwa. ");
INSERT INTO kwi_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Dios kimtu aizpa watcha i pianmakpas. Dios Judío chi kwail kirɨttuza ilnanapa ɨninkane, usne nil aizpa kimtu. ");
INSERT INTO kwi_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nu Judío awane Judío chi kwail kimturuzkanain kimtu. Nune Judío chi awaruza “une kwail kiamtu” kiznamtu. Dios kwail kimturuza ilnana ɨninkane, Diosne watcha u Judío awaruzakas tɨnta ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nune Diospa wat mintuchi. Usne wantuza kwisha wat kininnashimtu. Uskas uspa kwail akwa awaruza azain ilnamtuchi. Uskas uruza kwisha pashinamtu. Diosne nua wat kimtu, nu kwail kimtu aizpa chɨhkanpa, nu Diosta anpa, Dios nua maiznapa. ");
INSERT INTO kwi_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nu Dios kaiztu aizpa mɨshimtuchi akwa, nune u kwail kishimtu aizpa chɨhkamtuchi me. Nu Diosta kailtuchi akwa, Diosne nukasa aliz kultu, nu akkwan kwail kirɨt akwa. Dios kimtu aizpa watcha i. Katmizna nua ilna ɨninkane, Diosne nua an tɨnta naizninnazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Diosne wat kimturuza wat kiwainnanazi. Uskas kwail kimturuza ilnanazi, uspa kwail kiarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Diosta saimturuzne mamaztuza wat kinanazi. Diosne suntuza “u watsal kiamti” kiznanazi. Diosne usparuza wat minñanazi. Diosne usparuza pailta payukima chiyura uzninnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Uskas waya kishimturuzakas watcha mɨamtuchiruzakas kwail kiamturuzakas pilchapuznanazi. Usparuza tɨnta ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Diosne wan kwail kimturuza tɨnta naizninnanazi, kwisha ishnakima. An ñancha Judío awaruzne naizanazi. Kwizta Judío chi awaruzne naizanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Diosne wan wat kimturuza “une watsal kiamti” kiznanazi. Usparuza wat minñanazi. Usparuza kalpain uzninnanazi. An ñancha Diosne Judío awaruzakas kwizta Judío chi awaruzakas watsal uzninnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Diosne pailta awaruza kawarain kinanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Judío chi awaruzne Moisés ɨninta aizpa sapparachi. Moisés ɨninta aizpa mɨjchikas, uspane kwail kiat kit mama iarɨnazi. Judío awaruzne Moisés ɨninta aizpa sappazi. Uspa kwail kiamtu akwa, Diosne usparuza Moisés parɨt akwa ilnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Diosne Moisés ɨninta aizpa mɨmturuza wat paninnamanazi. Usne Moisés ɨninta aizpa kimturuza wat paninnanazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Diosne Judío chi awaruza Moisés ɨninta aizpa mɨlanarachi. Awa Moisés ɨninta aizpa sapparachikas, mɨnpazha us ɨninta aizpa kimtune, usne Dios pashimtu aizpa piankam kit kimtu. ");
INSERT INTO kwi_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kaijchura Dios ɨninta aizpa nɨjkulamtu akwa, uspane sun ɨninta aizpa minñat kit kiamtu. Ayukta wa aizpa ussa kuruntu. Masetne kaijchura kwail kirau mintu. Masetne kaijchura wat kirau mintu. ");
INSERT INTO kwi_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Iltu payura taizkane, Diosne awa ayukta puintɨt mɨj aizpa mɨmanazi, usparuza ilnana. Sunkanane nane Jesucristowa watsal pit uruza kainannamtus. ");
INSERT INTO kwi_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Mane u Judío awaruza parananash. Nune “Judío awa ish” kiztu. Nune “Dios ap Dios i” mintu. Nune “na an tɨnta ish” kiztu, Moisés ɨninta pit nuwa mɨlarɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Nune “Dios pashimtu aizpa pianish” kiztu. Dios paiña pit nuwa kamtarɨt akwa, “Mane watmin nanash,” kiztu. ");
INSERT INTO kwi_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nune “kamtammika namtus” kiztu, Diosta we piantuzakas Diosta wat nɨjkultuchiruzakas kamtananapa. ");
INSERT INTO kwi_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Nune “pianchiruza kamtanashimtus” kiztu. Nune “Dios pɨnkɨh panintɨt aizpa nɨjchiruza piankamninamtus,” kiztu, watcha piankamanapa. Nu sunkana mintu aizpa kain. Nu salamtɨt. ");
INSERT INTO kwi_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nu mamazta kamtamtukas, nune nu kamtamtu aizpa kimtuchi. Mamazta walkumun kiztukas, nune walkumtu. ");
INSERT INTO kwi_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nu mamazpa ashampa mɨlmun kiztukas, nune mamazpa ashampara nakat kit mɨltu. Nu dioskana sarɨtta wakpuj wainmun kiztukas, nune sun dios sarɨt uzkin nap kit pial tarɨt aizpa walkumtu. ");
INSERT INTO kwi_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nune “nain an warish” mintu, nu Moisés ɨninta aizpa iztu akwa. Nu Moisés ɨninta aizpa iztukas, nune us ɨnintu aizpa kimtuchine, Diosne nua ilnazi. ");
INSERT INTO kwi_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Dios pɨnkɨhta ka parɨt: “Nu Judío awa Diosta izkitchi akwa, Judío chi awaruzne Diospa kwail paraamtu,” ka kizta. ");
INSERT INTO kwi_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Judío awa Moisés ɨnintu aizpa mɨmturuzne watsal kianazi. Judío awa Moisés ɨnintu aizpa mɨmtuchiruzne, Judío chi awa uztukanain uzamtu. Uspane Diospa kwal namamanazi, tɨtta señal samtuchiruzkana, circuncisión kitchiruzkana. ");
INSERT INTO kwi_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Judío chi awa Moisés ɨnintu aizpa mɨmtune, usne Judío awakanain, tɨtta señal samtumikakanain, circuncisión kirɨtmikakanain, namnazi. Suasne Diosne ussa sapnazi, Dios ɨninta aizpa mɨt kit kirɨt akwa. ");
INSERT INTO kwi_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Sun tɨtta señal samtuchimikane, circuncisión kirɨtchimikane, Moisés ɨninta aizpa mɨmtune, sun tɨtta señal samtumikakana, circuncisión kirɨtmikakanain, namnazi. Suasne sun Judío chi awaruzne Judío awaruza, tɨtta señal samturuza, circuncisión kittuza, Moisés ɨninta aizpa saptɨttuza “kwail kiare” kiznanazi, uspa Moisés ɨninta aizpa mɨarachi akwa. ");
INSERT INTO kwi_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Judío awaruzne “aune Diospa kwal makpas” kizmumai. Une u Judío papihsh akwa, u Judío akkuhsh akwa Diospa kwal namasachi. Tɨtta señal ñara samturuzne, circuncisión kirɨttuzne, une sun akwa Diospa kwal namasachi. ");
INSERT INTO kwi_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Dios Izpulne awa ayukta, paiña kaijchukin, maiz kit Diospa kwal namnintu, Dios ɨnintu aizpa kinpa. Diospa kwalne kaijchukin Diosta nɨjkul kit us kuruntu aizpa kimtu. Diosne kaijchukin maiztɨttuza “une wat awa mai” kiznanazi. ");
INSERT INTO kwi_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Na kaiztu aizpa mɨnaka. Dios Judío awaruza nanarɨt akwa, Diosne Judío awaruza, tɨttɨt señal sarɨttuza, circuncisión kirɨttuza, wat iznamtu. ");
INSERT INTO kwi_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Uspane Diostas akkwan sappara. An ñancha Diosne usparuza akkwan pit kin nam kit Dios pit chɨhkanara, wantuza kamtananapa. ");
INSERT INTO kwi_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Judío awa Dios pit sapparɨtkas, mazantuzne us kaizta aizpa mɨashitchi. Mazantuz us kaizta aizpa mɨashitchikas, Diosne mizurainkas awakanain maizmanazi. Dios kin namtɨt aizpa kimanazi kizmanapas. Watcha Diosn