﻿USE sofia;
DROP TABLE IF EXISTS sofia.kwf_vpl;
CREATE TABLE kwf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kwf_vpl WRITE;
INSERT INTO kwf_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ana etangilana, God saungaꞋinia Ꞌafutana na magalia ma na mamanga. ");
INSERT INTO kwf_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Na magalia nia fioroꞋa, ma na kafo doe ka fungu fafia, ma maꞋe rodo ka buta fafia. Ma na Mangona God tua ma ka Ꞌasua fafona na kafo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ma God ka fata Ꞌuri, “MadakolaꞋanga ke dao naꞋa maꞋi.” ꞋUnaꞋeri goꞋo na madakolaꞋanga ka fuli naꞋa diꞋia nama neꞋe nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma God ka saeleꞋa faꞋinia na madakolaꞋanga, ma nia ka alua naꞋa na dangi ma na rodo kera ka tua matali. ");
INSERT INTO kwf_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma nia ka faꞋasata na madakolaꞋanga neꞋeri Ꞌani na Asoa, ma nia ka saea na maꞋerodo neꞋeri Ꞌani na Rodo. Ma na asoa neꞋeri ka sui naꞋa. Ma na asoa neꞋeri naꞋa neꞋe na etana asoa ana na magalia. ");
INSERT INTO kwf_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Ma God ka fata laꞋu Ꞌuri, “Alua ta kula ke teo Ꞌi safitana na kafo neꞋeri Ꞌiri ke daroꞋia na kafo ka teo Ꞌi lifua ma na kafo ka teo Ꞌi olofa.” Ma na kula neꞋeri ka raꞋe maꞋi diꞋia God nia oga. Na kula neꞋeri nia fulia ma kafo ka daroꞋia ta kafo ka teo Ꞌi lifua ma ta kula ka teo Ꞌi olofa. ");
INSERT INTO kwf_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma nia ka faꞋasata kula neꞋeri Ꞌani na mamanga. Ma na asoa neꞋeri ka sui, na ruana asoa ana magalia. ");
INSERT INTO kwf_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma God ka fata laꞋu Ꞌuri, “Kafo loꞋoko teo Ꞌi olofana mamanga, muke fiku taꞋifau fasi Ꞌiri kula langa langa ke raꞋe maꞋi,” ma na ru neꞋeri ka fuli diꞋia nama ba nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma nia ka saea na kula langa langa neꞋeri Ꞌania Ano, ma nia ka saea na kafo neꞋeri Ꞌania na Asi. Ma God ka lisia na raoꞋa nia ma nia ka saeleꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ma God ka fata laꞋu Ꞌuri, “Ru matamata marako toꞋo toꞋo ki taꞋifau, muke bulao ana ano neꞋe. Ma na ano ka toꞋo nama ana ru matamata marako toꞋo toꞋo ki taꞋifau faꞋinia maga ru kira ki. Ma na maga ru neꞋeri ki ke alu laꞋu na ru neꞋe kira leka faꞋasia.” Ma ru neꞋeri ki ka fuli nama diꞋia neꞋe nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Na ru matamata marako Ꞌoro ki neꞋe taꞋe maꞋi ma ka bulao maꞋi na ano neꞋe, ma na maga ru kira ki ka alu laꞋu na ru neꞋe kira leka faꞋasia. Ma God ka lisia na raoꞋa nia ma nia ka saeleꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ꞋIu na asoa neꞋeri ka sui naꞋa, na uula asoa ana magalia neꞋeriꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma God ka fata laꞋu Ꞌuri, “MadakolaꞋanga ki muke raꞋe maꞋi Ꞌi lofana mamanga Ꞌiri muke daroꞋia na dangi ma na rodo. Na ru neꞋe ki fuana faꞋataꞋilana asoa ki, ma faꞋi ngali ki, ma na kaidaꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Na ru neꞋe ki ke baꞋa teo Ꞌi lifua saena na mamanga ma kike rara maꞋi Ꞌi ano fasi Ꞌiri ka toꞋo ana madakolaꞋanga.” Ma na madakolaꞋanga neꞋeri ki ke fuli nama diꞋia nia saea naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nia ka saungaꞋinia madaꞋafi ka sina ngasingasiꞋa fasi Ꞌiri ka sina ana asoa ki. Ma nia ka saungaꞋinia na madamo neꞋe nia noaꞋa kasi sina ngasingasiꞋa diꞋia na madaꞋafi, fasi Ꞌiri ke sina ana rodo. Ma nia ka saungaꞋinia laꞋu goꞋo na bulubulu ki. ");
INSERT INTO kwf_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ꞋIu God aluda kira ka tua saena na mamanga ma kira ka rara maꞋi Ꞌi ano fasi Ꞌiri ke toꞋo ana madakolaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ꞋIu na madaꞋafi inaꞋu ana sinaꞋa ana na asoa, ma na madamo ka inaꞋu ana sinaꞋa ana rodo. Ma kera ka toꞋolangaꞋinia dangi ka matali faꞋasia na rodo. Ma God ka lisia na raoꞋa nia ma nia ka saeleꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ꞋIu ma asoa neꞋeri ka sui, ma na faina asoa ana magalia neꞋeriꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma God ka fata laꞋu Ꞌuri, “Na iꞋa matamata toꞋotoꞋo ki, muke tua saena asi ma muka faꞋafungua. Ma na faꞋi noꞋo matamata toꞋotoꞋo, muke tua muka lofo kwailiu saena na mamanga.” ");
INSERT INTO kwf_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nia ka saungaꞋinia iꞋa doe ki saena asi, ma gwaꞋi iꞋa matamata toꞋotoꞋo ki logo neꞋe kira faꞋafungua na asi. Ma nia ka saungaꞋinia na faꞋi noꞋo matamata toꞋotoꞋo ki. Ma God ka lisia na raoꞋa nia ma nia ka saeleꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ma nia ka faꞋaleꞋada ma ka fata Ꞌuri ada, “Na gwaꞋi iꞋa ki, nia leꞋa fuamuꞋa muke alu ngela Ꞌoro ꞋamuꞋa fasi Ꞌiri kamu ke faꞋafungua asi neꞋe. Ma na faꞋi noꞋo ki logo, nia leꞋa fuamuꞋa muke toꞋo ana ngela Ꞌoro ki, fasi Ꞌiri muke baꞋa Ꞌoro laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ꞋIu ma asoa neꞋeri ka sui, niaꞋa na limana asoa ana magalia. ");
INSERT INTO kwf_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma God ka fata laꞋu Ꞌuri, “Na ru mauri ki, kamu ke tua saena ano neꞋe. Nia ke toꞋo nama ana ru ꞋaeꞋaela ki Ꞌi fanoa, ma na ru ꞋaeꞋaela doe ki ma na ru ꞋaeꞋaela tiꞋitiꞋi ki saena masuꞋua.” Ma na ru neꞋeri ki ka taꞋe maꞋi ka diꞋia nama neꞋe nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nia ka saungaꞋinia ru matamata ki neꞋe kira toꞋo ana mauriꞋa neꞋe kira tua saena ano neꞋe. Nia ka saungaꞋinia ru ꞋaeꞋaela Ꞌi fanoa ki, ma na ru ꞋaeꞋaela doe ki ma na ru ꞋaeꞋaela tiꞋitiꞋi ki saena masuꞋua. Ma God ka lisia na raoꞋa nia ma nia ka saeleꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ma God ka fata laꞋu Ꞌuri, “Nia leꞋa fuana kuke saungaꞋinia ngwae ki fasi Ꞌiri kira ka diꞋia logo kuluꞋa, ma kira usulia kuluꞋa taꞋifau naꞋa. Kira ke baꞋa gwaungaꞋi fafia na iꞋa ki, faꞋinia faꞋi noꞋo ki, ma na ru ꞋaeꞋaela Ꞌi fanoa ki, ma ma na ru ꞋaeꞋaela doe ki ma na ru ꞋaeꞋaela tiꞋitiꞋi ki saena masuꞋua.” ");
INSERT INTO kwf_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ꞋUnaꞋeri God ka saungaꞋinia na ngwae ki fasi Ꞌiri kira ka diꞋia logo niaꞋa, ma kira usulia niaꞋa taꞋifau naꞋa. God nia saungaꞋinia ngwae ki Ꞌania ngwangwane ma na kini. ");
INSERT INTO kwf_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma God ka faꞋaleꞋadaroꞋo ma ka fata Ꞌuri fuadaroꞋo, “Nia leꞋa fuana koroꞋo ke toꞋo ana ngela Ꞌoro ki Ꞌiri kike baꞋa tua ana kula ki taꞋifau saena magalia. Ma moke ꞋaꞋana fafia ru ki taꞋifau saena magalia. Nau ku alu koroꞋo ke gwaungaꞋi fafia na iꞋa ki, faꞋinia na faꞋi noꞋo ki, ma ru ki taꞋifau neꞋe kira mauri ma kika tua saena na magalia neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Sui God ka fata laꞋu Ꞌuri, “Rongoa basi, ru matamata marako toꞋo toꞋo ki taꞋifau faꞋinia maga ru kira ki ma na fuaꞋi ru kira ki, nau ku aluda taꞋifau naꞋa fuamuroꞋo. Na ru neꞋeri ki, kike kwatea fanga fuamuroꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Bore ma nau ku alua ru matamata marako toꞋo toꞋo ki taꞋifau niꞋi fanga fuana na ru mauri ki taꞋifau saena ano neꞋe: na ru ꞋaeꞋae ki, na faꞋi noꞋo ki, ma na ru ꞋaeꞋaela tiꞋitiꞋi ki saena masuꞋua.” ꞋIu na ru neꞋeri ki fuli ka diꞋia nama ba nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma God ka lisia na raoꞋa nia ki taꞋifau ma nia ka saeleꞋa liu faꞋinia. Na onona asoa ana magalia naꞋa neꞋeriꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ꞋUnaꞋeri na raoꞋa God ki ana saungaꞋilana na mamanga ma na ano faꞋinia na ru neꞋe teo saeni ki niꞋi sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na raoꞋa neꞋeri God fulia ka sui naꞋa, ma na fiuna asoa nia ka mamalo. ");
INSERT INTO kwf_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ma nia ka faꞋaleꞋa fiuna asoa, ma ka toꞋolangaꞋinia fiuna asoa ana wiki nia abu, osiꞋana nia mamalo naꞋa, duꞋungana na raoꞋa nia fuana saungaꞋilana na ru ki taꞋifau nia sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Na ꞋaꞋemae sulia God neꞋe saungaꞋinia naꞋa na mamanga ma na ano faꞋinia na ru ki taꞋifau neꞋe tua adaroꞋo nia Ꞌuri: Ana kaidaꞋi neꞋe Iawe na God nia saungaꞋinia na mamanga faꞋinia na ano ma na ru neꞋe teo adaroꞋo ki, ");
INSERT INTO kwf_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","noaꞋa ta ru Ꞌiri bulao Ꞌua ana na ano, osiꞋana noaꞋa nia kasi kwatea Ꞌua na uta, ma ka noaꞋa Ꞌua ta ngwae neꞋe ke oꞋo Ꞌua ta oꞋola. ");
INSERT INTO kwf_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Na maꞋe busu ki goꞋo neꞋe kwate ma ano ka ngwangasiꞋoraꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ꞋIu na God Iawe ngalia na buli ano ma ka saungaꞋinia Ꞌani taꞋi ngwae, ma nia ka ufi sulia ngongorana fasi Ꞌiri nia ka toꞋo ana mauriꞋa. ꞋUnaꞋeri mala neꞋe ngwae ka fiꞋi mauri. ");
INSERT INTO kwf_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Sui, Ꞌi bali ana fanelana madaꞋafi ana taꞋi kula neꞋe kira saea Ꞌani Ꞌi Iden, na God Iawe nia sasi akaꞋu ana taꞋi kula leꞋa liu, ma nia ka ngalia na ngwae neꞋe nia saungaꞋinia, ma nia ka kwate nia ka tua ana. ");
INSERT INTO kwf_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma nia ka alua na Ꞌai matamata toꞋotoꞋo Ꞌoro ki saena kula neꞋeri. Ma na Ꞌai neꞋeri ki lisilada leꞋa/kwanga liu ma na fuaꞋi ru ki ka leꞋa liu fuana Ꞌanilani. Ma saena tofongana kula neꞋeri, ta ro Ꞌai laꞋu neꞋe kera uu Ꞌi neꞋeri. Ta Ꞌai neꞋe fufuana ke kwate ngwae ke mauri, ma taꞋi neꞋe fufuana ke kwatea ma ngwae ki ka saiana tae neꞋe taꞋa ma tae neꞋe leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ꞋIu taꞋi kafo nia busu maꞋi Ꞌi Iden ma nia ka afe saena oꞋola neꞋeri Ꞌiri ke faꞋangwangasiꞋora. Ana kaidaꞋi na kafo neꞋeri nia afe naꞋa kwau faꞋasia Ꞌi Iden, nia ka alu laꞋu ta fai kafo matamata. ");
INSERT INTO kwf_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Etana kafo neꞋe kira saea Ꞌani Ꞌi Pison neꞋe afe kwau saena kula kira saea Ꞌani Ꞌi Havila, kula neꞋe gol leꞋa liu nia ana. ");
INSERT INTO kwf_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ma gol neꞋeri nia sikasika liu. Ma na ru moko leꞋa liu neꞋe kira saea Ꞌani ‘beliam’ teo Ꞌi Havila, ma na fau lisilana leꞋa liu neꞋe kira saea Ꞌani ‘oniks’ teo Ꞌi neꞋeri logo. ");
INSERT INTO kwf_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ma ruana kafo neꞋe kira saea Ꞌani Ꞌi Gihon, ma nia ka afe kwailiu saena fanoa Ꞌi Kus. ");
INSERT INTO kwf_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ma uula kafo neꞋe kira saea Ꞌani Ꞌi Taegris nia teo karangi ana fanoa Ꞌi Asiria, ana bali Ꞌuana fanelana sina. Ma faina kafo neꞋe kira saea Ꞌani Ꞌi Iufretes. ");
INSERT INTO kwf_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ꞋIu na God Iawe ngalia ngwae neꞋeri ma ka alua nia ka tua ana kula leꞋa neꞋeri fasi Ꞌiri nia ka oꞋo Ꞌi saena ma ka lia sulia na ru neꞋe teo Ꞌi neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma na God Iawe ka fata totongaꞋi Ꞌuri fuana, “ꞋOke Ꞌania fuaꞋi ru ki ana Ꞌai ki saena na kula neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Bore ma taꞋi Ꞌai goꞋo neꞋe nia abu noaꞋa Ꞌoe kosi Ꞌania fuaꞋi ru ki ana. Na Ꞌai neꞋe ke kwatea ma ngwae ki ka saiana tae neꞋe taꞋa ma tae neꞋe leꞋa. DiꞋia Ꞌoko Ꞌania na fuaꞋi ru ki ana Ꞌai neꞋe, Ꞌoke baꞋa mae nama ana asoa neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ma na God Iawe ka fata Ꞌuri, “NoaꞋa nia Ꞌiri leꞋa fuana ngwae neꞋe ke tua taꞋifilia. Nia leꞋa fuana nai saungaꞋinia nama ta taꞋi ngwae kwaima fuana neꞋe totolia ke kwaiꞋafi ana.” ");
INSERT INTO kwf_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ꞋI naꞋo, na God Iawe ngali na buli ano ka saungaꞋinia Ꞌania na ru ꞋaeꞋaela ki neꞋe ke leka fafona ano, faꞋinia faꞋi noꞋo ki neꞋe kike lofo kwailiu Ꞌi lifua saena mamanga. NiniꞋari, Iawe ngalida maꞋi fuana ngwae neꞋeri fasi Ꞌiri nia lisia na ngwae faꞋasatada. Na sataꞋi ru neꞋe ngwae neꞋe ke saeda Ꞌania neꞋe niꞋi teo tari naꞋa ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Na ngwae ka faꞋasata na ru ꞋaeꞋaela ki Ꞌi fanoa, ma na ru ꞋaeꞋaela ki saena masuꞋua, ma na faꞋi noꞋo ki logo. Bore ma noaꞋa nia Ꞌiri dao toꞋona ta ru neꞋe ka kwaima ma ka kwaiꞋafi ana ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","GoꞋo, na God Iawe ka kwatea ngwae neꞋeri ka maliu liu. Sui nia ka lafua taꞋi suli karokaro ana ma ka fono logo Ꞌusia kula neꞋe nia lafua maꞋi faꞋasia ana. ");
INSERT INTO kwf_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma nia ka ngalia suli karokaro neꞋeri, ma ka saungaꞋinia taꞋi kini, ma nia ka ngalia maꞋi fuana na ngwae neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma kaidaꞋi ngwae neꞋeri lisia nia ka fata Ꞌuri fuana God, “Reala kwa! NiaꞋa diꞋia logo nauꞋa! Na sulina saka maꞋi ana suliku, na sulina saka maꞋi ana suliku, ma nonina ka saka maꞋi ana noniku. Satana naꞋa neꞋe ‘kini’, osiꞋana nia saka maꞋi ana ngwangwane.” ");
INSERT INTO kwf_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","DuꞋungana ru neꞋeri, ngwae ke faꞋasia na maꞋa nia faꞋinia teꞋa nia, ma ka tua ratai faꞋinia na Ꞌafe nia, ma kera ke alua naꞋa taꞋi manataꞋanga diꞋia taꞋi ngwae goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ma na ngwae neꞋeri faꞋinia Ꞌafe nia kera ka dadara goꞋo ꞋadaroꞋo, ma noaꞋa kera kasi Ꞌeke goꞋo ꞋanidaroꞋo talada. ");
INSERT INTO kwf_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ꞋIu ana ru ki taꞋifau neꞋe God Iawe nia saungaꞋinida na faꞋi loi naꞋa neꞋe taꞋi ru neꞋe nia kwaꞋatafa liu fuana ꞋosoꞋa. ꞋUnaꞋeri ana taꞋi asoa, na faꞋi loi leka maꞋi ma ka saefilo Ꞌuri ana kini neꞋeri, “ꞋUri ma nia mamana neꞋe God nia saea fuamuroꞋo noaꞋa koroꞋo kasi Ꞌania fufuana Ꞌai ki taꞋifau saena oꞋola neꞋe?” ");
INSERT INTO kwf_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ma kini neꞋeri ka fata Ꞌuri, “NoaꞋa Ꞌuiri Ꞌiira laꞋu. KeroꞋo ke Ꞌania goꞋo ꞋamiroꞋo fufuaꞋi ru ki ana Ꞌai ki saena oꞋola neꞋe, ");
INSERT INTO kwf_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bore ma God ka saea, ‘TaꞋi Ꞌai neꞋe uu goꞋo saena tofongana oꞋola neꞋe noaꞋa koroꞋo kasi Ꞌania nama koroꞋo kasi sama toꞋona fuaꞋi ru ki ana. Si diꞋia koroꞋo Ꞌoia ru abu neꞋeri koroꞋo ke baꞋa mae.’” ");
INSERT INTO kwf_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bore ma faꞋi loi neꞋeri nia fata lala Ꞌuri, “AlaꞋanga neꞋana noaꞋa Ꞌiri mamana. KoroꞋo kasi mae goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God fata ꞋunaꞋeri osiꞋana nia saiana ka sui naꞋa, si diꞋia koroꞋo Ꞌania fuaꞋi Ꞌai neꞋana, maamuroꞋo ke baꞋa Ꞌifi, ma koroꞋo ke baꞋa diꞋia logo niaꞋa, ma koroꞋo ka sai logo ana falafala neꞋe taꞋa ki ma na falafala neꞋe leꞋa ki logo.” ");
INSERT INTO kwf_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Na kini neꞋe nia lisia na Ꞌai neꞋe lisilana leꞋa liu, ma fuaꞋi ru ki bore ka leꞋa logo fuana Ꞌanilani. Ma nia ka oga liua naꞋa neꞋe nia ke kwaꞋatafa. GoꞋo nia ka ngalia naꞋa ti fuaꞋi ru ana Ꞌai neꞋeri, ma ka Ꞌania naꞋa, ma nia ka kwatea logo fuana araꞋi nia, ma nia ka Ꞌania logo. ");
INSERT INTO kwf_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tona goꞋo ma maadaroꞋo ka Ꞌifi naꞋa, ma kera ka lia saiana neꞋe keraꞋa tua dadara naꞋa. KaidaꞋi neꞋeri kera ka taia naꞋa raꞋi figi ki, ma kera ka toro naꞋa ꞋaniꞋi fafidaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ma nia saꞋulafi naꞋa, na God Iawe nia liliu logo Ꞌana ana kula neꞋeri, kera rongoa ma kera ka leka ago naꞋa ꞋadaroꞋo faꞋasia God Ꞌi safitana na Ꞌai ki ana kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bore ma na God Iawe nia ri kwau Ꞌuana na ngwae neꞋeri ka Ꞌuri, “Se, Ꞌuri ma ꞋaeꞋo naꞋa Ꞌi faꞋi kwa?” ");
INSERT INTO kwf_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ma na ngwae neꞋeri olisia ma ka Ꞌuri, “ꞋIu nau ku rongoa Ꞌoko leka maꞋi, ma nau ku maꞋu, niniꞋa nau ku leka ku ago Ꞌi neꞋe, osiꞋana nau ku dadara.” ");
INSERT INTO kwf_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ꞋUnaꞋeri ma God ka fata Ꞌuri fuana, “ꞋUri ma sa tai neꞋe saea neꞋe Ꞌoko dadara kwa? ꞋUri ma Ꞌoko Ꞌania fuana Ꞌai ba nau ku luia koroꞋo kasi Ꞌania?” ");
INSERT INTO kwf_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ma na ngwae neꞋeri ka fata Ꞌuri, “ꞋIu, bore ma na kini ba Ꞌoko alua ka tua faꞋi nau niniꞋa kwatea fuaꞋi Ꞌai neꞋe fuaku, ma nau ku Ꞌania naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ꞋUnaꞋeri goꞋo na God Iawe ka fata ana na kini neꞋeri ka Ꞌuri, “FaꞋuta neꞋe Ꞌoko sasi Ꞌuri kwa?” Ma na kini neꞋeri ka fata Ꞌuri, “Na faꞋi loi naꞋa niniꞋa soke nau kwate ma nau ku Ꞌania fuana Ꞌai neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ꞋIu na God Iawe nia fata Ꞌuri fuana faꞋi loi neꞋeri, “DuꞋungana neꞋe Ꞌoko sasi ru neꞋe, na ꞋafitaꞋiꞋanga ke dao toꞋomu. Ana ru ꞋaeꞋaela ki taꞋifau, ꞋaeꞋo goꞋo neꞋe Ꞌoke toꞋo ana ꞋafitaꞋiꞋanga neꞋe. Nia ka Ꞌita ana kaidaꞋi neꞋe, Ꞌoke ango naꞋa Ꞌania olofamu, ma Ꞌoke Ꞌania naꞋa gegeo ana ano sulia bongi firi leleka ka dao ana kaidaꞋi Ꞌoke mae. ");
INSERT INTO kwf_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nai baꞋa kwatea kini neꞋe ke ꞋailangaꞋi koroꞋo kwailiu, moke tuani fuꞋali lamuroꞋo toꞋotoꞋo kasi mango. Na kwalafa Ꞌoe ma na kwalafa kini neꞋe kera ke tua Ꞌani malimae Ꞌanga adaroꞋo. Ma na kwalafa nia ke baꞋa bulia ngisia gwaumu, ma Ꞌoke baꞋa Ꞌalea buira Ꞌaena.” ");
INSERT INTO kwf_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","God ka fata laꞋu Ꞌuri fuana kini neꞋe, “Nai baꞋa kwate ke ꞋafitaꞋi fuamu ana kaidaꞋi Ꞌoke ina. ꞋOke baꞋa fii liu ana kaidaꞋi Ꞌoke faꞋafuta ngela. Sui ka ꞋunaꞋeri bore Ꞌana, Ꞌoke oga nama Ꞌamu na araꞋi Ꞌoe, ma nia ke gwaungaꞋi fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ꞋUnaꞋeri God ka fata laꞋu Ꞌuri fuana ngwangwane neꞋeri, “Ana kaidaꞋi neꞋe, nai baꞋa faꞋalia ano neꞋe ke taꞋa naꞋa, duꞋungana Ꞌoko rongo sulia fatalana Ꞌafe Ꞌoe, ma Ꞌoko Ꞌania naꞋa fuana Ꞌai ba nau ku luia faꞋasiꞋo noaꞋa Ꞌoe kosi Ꞌania. Ana kaidaꞋi firi ana maurilamu, Ꞌoke baꞋa inaꞋu naꞋa ana rao laga ulafu Ꞌanga Ꞌuana fanga lamu. ");
INSERT INTO kwf_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Na kwalo ngarangaraꞋa ki ma na Ꞌai taꞋa ki kike bulao maꞋi saena na ano. ꞋOke baꞋa Ꞌania goꞋo Ꞌamu na ru neꞋe bulao ki saena ano. ");
INSERT INTO kwf_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ꞋOke baꞋa rao laga ulafu, ma Ꞌoko ꞋidaꞋida, fasi Ꞌiri na ano ke toꞋo ana fanga leleka ka dao ana kaidaꞋi Ꞌoke mae, ma na nonimu ke oli saena na ano niniꞋa nau ku saungaꞋiniꞋo maꞋi ana. Nau ku saungaꞋiniꞋo ana na ano, ma Ꞌoke baꞋa oli laꞋu saena na ano.” ");
INSERT INTO kwf_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ma satana na ngwae neꞋeri neꞋe sa Adam. Ana kaidaꞋi neꞋeri nia ka saea na Ꞌafe nia Ꞌani Ꞌi Eve, osiꞋana niaꞋa naꞋa neꞋe na teꞋa na ngwaꞋi toꞋa mauri ki. ");
INSERT INTO kwf_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ꞋIu na God Iawe saungaꞋinia ifi fuadaroꞋo ana ꞋuliꞋulina na ru mauri ꞋaeꞋaela ki, ma ka faꞋatoroda roꞋo Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ma na God Iawe ka fata Ꞌuri, “KaidaꞋi neꞋe na ngwae nia raꞋe maꞋi ka diꞋia naꞋa kuluꞋa, osiꞋana nia sai naꞋa ana falafala taꞋa ki ma na falafala leꞋa ki. KaidaꞋi neꞋe kulu kasi alaꞋania noaꞋa nia kasi ngalia laꞋu fuaꞋi ru ki faꞋasia na Ꞌai ana mauriꞋa. Si diꞋia nia Ꞌania fuaꞋi ru ki ana na Ꞌai neꞋe, noaꞋa nia kasi mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Sui, na God Iawe ka alua naꞋa ngwae neꞋeri Ꞌi maa faꞋasia na kula leꞋa neꞋeri Ꞌi Iden. ꞋIu, God nia saungaꞋinia na ngwae ana na ano. Ma nia ka alua ngwae neꞋe ka rao naꞋa saena na ano neꞋe, ma ka oꞋofia naꞋa oꞋola nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ꞋI buri Ꞌana God ka alua ngwae neꞋeri Ꞌi maa, nia ka alua na Ꞌainsel ki ka folo Ꞌusia bali Ꞌuana fanelana sina ana kula leꞋa neꞋeri Ꞌi Iden. Ma kira ka folo suli bongi firi Ꞌania sele ni ofoꞋa ki. Na sele neꞋeri ki, na meamea ana mafula neꞋe ke duꞋa maꞋi Ꞌi maani, ma ka liu kalia kula neꞋeri ma noaꞋa kasi mamalo. Na God Iawe nia sasi ꞋunaꞋeri Ꞌiri ka fonea na ngwae ki noaꞋa kira kasi leka karangi maꞋi ana na Ꞌai neꞋe fufuana kwatea ngwae ke mauri firi. ");
INSERT INTO kwf_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ꞋIu sa Adam faꞋinia Ꞌafe nia Ꞌi Eve, keroꞋa tua fiku naꞋa leleka nia ka ina ma ka faꞋafuta naꞋa taꞋi ngela ngwane sa Kein. Ma Ꞌi Eve ka fata Ꞌuri, “ꞋIu Iawe nia kwaiꞋafi aku niniꞋa nau ku ngali maꞋi na ngela ngwane.” ");
INSERT INTO kwf_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ma Ꞌi buri Ꞌana, nia ka faꞋafuta laꞋu ruana ngela ngwane sa Abel. Ma kaidaꞋi sa Abel nia ꞋaꞋana maꞋi, nia ka sarea ma ka lia sulia na sipsip ki. Ma sa Kein ngwae ni rao saena oꞋola. ");
INSERT INTO kwf_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ana ta kaidaꞋi, sa Kein ka ngalia naꞋa ti fanga saena oꞋola nia, ka kwateꞋe Ꞌani na foꞋosi nia fuana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Bore ma sa Abel nia ngalia bibi sipsip eta futa ana na sipsip nia ki, ma nia ka saungia ka mae, ma nia ka ngalia na fasi ru saela ki, ma nia ka foꞋosi ani fuana Iawe. Ma Iawe ka saeleꞋa liu faꞋinia sa Abel ma na foꞋosi nia, ");
INSERT INTO kwf_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bore ma noaꞋa nia kasi ala goꞋo fafia sa Kein faꞋinia na foꞋosi neꞋe nia duꞋafia. ꞋUnaꞋeri sa Kein ka saetaꞋa ka lilisu liu naꞋa, ma na maana ka rada naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Sui Iawe ka fata Ꞌuri fuana sa Kein, “FaꞋuta neꞋe Ꞌoko saetaꞋa liu ma maamu ka rada naꞋa Ꞌira kwa? ");
INSERT INTO kwf_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","DiꞋia Ꞌoke sasi na ru saga, na maamu bore ka lia sae leꞋa logo. Bore ma diꞋia Ꞌoke Ꞌaila Ꞌani sasi na ru saga, taꞋangaꞋa neꞋe nia diꞋia ta ru kwasi neꞋe tua karangi amu, ma ka kwaimaꞋa kwali fuana faꞋali lamu. TaꞋangaꞋa neꞋe oga liua ke liufiꞋo, bore ma Ꞌoke liufia nama.” ");
INSERT INTO kwf_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ana taꞋi asoa sa Kein fata Ꞌuri fuana ngwae futa nia sa Abel, “Koro leka saena oꞋola.” Ana kaidaꞋi keraꞋa tua saena oꞋola, sa Kein ka fuꞋalia ngwae futa nia, ma ka saungia ka mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ꞋUnaꞋeri Ꞌi buri Ꞌana, Iawe ka saefilo Ꞌuri ana sa Kein, “ꞋUri ma ngwae futa Ꞌoe sa Abel nia Ꞌi faꞋi?” Bore ma sa Kein ka fata lala Ꞌuri, “Nau ku Ꞌiri saiana. ꞋUri ma na raoꞋa nai lala neꞋe fuana liaꞋa sulia na ngwae futa nau?” ");
INSERT INTO kwf_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Sui Iawe ka fata Ꞌuri ana, “FaꞋuta neꞋe Ꞌoko sasi na ru taꞋa neꞋe kwa? Nau ku rongoa na Ꞌabuna ngwae futa Ꞌoe inaꞋu ana angiꞋa maꞋi fuaku faꞋasia Ꞌi ano, ma nia ka amasi nau fuana faꞋasaga lana na ru neꞋe! ");
INSERT INTO kwf_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","KaidaꞋi Ꞌoko saungia na ngwae futa Ꞌoe, na Ꞌabuna nia afe toli saena ano, ma na ano ka Ꞌifi fuana ngali lana Ꞌabuna. OsiꞋana ru neꞋeri na ꞋafitaꞋi Ꞌanga ke baꞋa dao nama fafiꞋo. KaidaꞋi Ꞌoko oꞋolia na oꞋola Ꞌoe, noaꞋa nia kasi alua ta fanga. ꞋI niniꞋari noaꞋa Ꞌoe kosi toꞋo naꞋa ana ta ano Ꞌamu saena magalia neꞋe sulia kaidaꞋi ki taꞋifau ana maurilamu. ꞋAeꞋo ngwae naꞋa fuana liu kwailiu Ꞌanga, ma noaꞋa Ꞌoe kosi mango.” ");
INSERT INTO kwf_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","GoꞋo, sa Kein ka fata Ꞌuri fuana Iawe, “Na kwaꞋikwaꞋinga neꞋana nia Ꞌato liu naꞋa fuaku. ");
INSERT INTO kwf_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","KaidaꞋi neꞋe Ꞌoko lali nau naꞋa faꞋasia na ano neꞋe ma noaꞋa nau kusi tua laꞋu ana kula neꞋe Ꞌoko tua ana. Ma kaidaꞋi ki taꞋifau ana mauri laku, nai baꞋa dau goꞋo Ꞌani liu kwailiu Ꞌanga naꞋa. Ma si diꞋia ta ngwae goꞋo Ꞌana ke dao toꞋoku, ma nia ka saungi nau, nai mae naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bore ma Iawe nia fata Ꞌuri ana sa Kein, “NoaꞋa goꞋo. Si diꞋia ta ngwae saungiꞋo Ꞌoko mae, nai baꞋa kwatea kwaꞋikwaꞋinga nia ke fiu fau ki ka liufia kwaꞋikwaꞋinga Ꞌoe.” Sui, na Iawe ka alua maꞋetoto ana, fasi Ꞌiri diꞋia ta ngwae bore Ꞌana dao toꞋona noaꞋa nia kasi saungia ka mae. ");
INSERT INTO kwf_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","GoꞋo, sa Kein ka leka naꞋa kwau Ꞌana faꞋasia kula Iawe nia tua ana. Ma nia ka tua naꞋa ana bali ana fane lana madaꞋafi ana Ꞌi Iden na kula kira saea Ꞌani Ꞌi Nod. ");
INSERT INTO kwf_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Sa Kein faꞋinia Ꞌafe nia kera tua fiku naꞋa, leleka Ꞌafe nia ka ina naꞋa, ma nia ka faꞋafuta taꞋi ngela ngwane, kera ka faꞋasata Ꞌani sa Enok. Ana kaidaꞋi neꞋeri, sa Kein ka saungaꞋinia taꞋi fanoa, ma ka saea Ꞌani Ꞌi Enok sulia satana na ngela nari nia. ");
INSERT INTO kwf_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Sa Enok alua sa Irad. Sa Irad alua sa Mefujael. Sa Mefujael ka alua sa Metusael. Ma sa Metusael ka alua sa Lamek. ");
INSERT INTO kwf_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","AraꞋi neꞋe sa Lamek, nia toꞋo ana ro Ꞌafe ki Ꞌi Ada ma Ꞌi Sila. ");
INSERT INTO kwf_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ꞋI Ada faꞋafuta ngela ngwane neꞋe satana sa Jabal, ma na ngwae neꞋe kira futa olitana sa Jabal ki, kira tua goꞋo saena babala ki, ma na raoꞋa kira neꞋe ngwae kira sare buluka goꞋo ma na nanigot ma na sipsip ki. ");
INSERT INTO kwf_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na satana na ngwae futa sa Jabal neꞋe sa Jubal, ma na ngwae neꞋe kira futa maꞋi olitana sa Jubal ki, kira sai leꞋa liu ana kidili lana na gita ma faꞋinia ufi lana Ꞌau ki. ");
INSERT INTO kwf_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma Ꞌi Sila ka faꞋafuta taꞋi ngela ngwane neꞋe satana sa Tubalken, ma na ngwae neꞋe futa olitana sa Tubalken ki, kira sai leꞋa liu ana saungaꞋilana na ru fuana raoꞋa ki Ꞌania na barasi ma na aean. Na ngwaingwaena sa Tubalken neꞋe satana Ꞌi Naama. ");
INSERT INTO kwf_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sa Lamek nia ngu fuana ro Ꞌafe nia ki ka Ꞌuri, “ꞋI Ada ma Ꞌi Sila ro Ꞌafe nau ki, moro sailinga leꞋa maꞋi fuaku. DiꞋia ta ngwae nama ta Ꞌalako kwaꞋi nau, nai baꞋa saungia ka mae. ");
INSERT INTO kwf_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","DiꞋia ta ngwae saungia sa Kein ka mae, God ke baꞋa kwatea kwaꞋikwaꞋinga nia ke fiu fau ki ka liufia kwaꞋikwaꞋinga sa Kein. Bore ma, diꞋia ta ngwae faꞋalia nauꞋa, kwaꞋikwaꞋinga nia ke fiu akwala ma fiu fau ki ka liufia kwaꞋikwaꞋinga sa Kein.” ");
INSERT INTO kwf_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Sa Adam faꞋinia Ꞌafe nia Ꞌi Eve keroꞋa tua fiku nama ꞋadaroꞋo ka leleka Ꞌi Eve ka faꞋafuta laꞋu ta taꞋi ngela ngwane neꞋe sa Set. Ma Ꞌi Eve ka fata Ꞌuri, “God nia kwatea laꞋu maꞋi ta ngela ngwane laꞋu fuaku, Ꞌiri ka didifulia sa Abel ba sa Kein saungia ka mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sui ꞋunaꞋeri laꞋu Ꞌi buri Ꞌana, sa Set araꞋi ma ka alua taꞋi ngela ngwane ma ka faꞋasata Ꞌani sa Enos. Ana kaidaꞋi neꞋeri mala na ngwae ki ka fiꞋi talaꞋae fuana foꞋosia God Ꞌani satana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Na ꞋaꞋemae sulia kwalafa sa Adam nia Ꞌuri: Ana kaidaꞋi neꞋe God saungaꞋinia na ngwae ki fasi Ꞌiri kira ka diꞋia logo niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","God nia saungaꞋinia ngwae ki Ꞌania ngwangwane ma na kini. Ma nia ka faꞋaleꞋadaroꞋo, ma nia ka saeda roꞋo Ꞌani na Ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sa Adam tuatua ka dao ana 130 faꞋi ngali ki sui, nia ka alua laꞋu taꞋi ngela ngwane neꞋe diꞋia logo niaꞋa talana. Ma nia ka saea na ngela neꞋeri Ꞌania sa Set. ");
INSERT INTO kwf_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sui sa Adam nia ka tua laꞋu sulia 800 faꞋi ngali ki, ma ana kaidaꞋi neꞋeri nia ka alua laꞋu ti ngela ngwane ma ti ngela kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ma ana kaidaꞋi nia mae nia tua naꞋa sulia 930 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","KaidaꞋi sa Set nia dao ana 105 faꞋi ngali ki, nia ka alua sa Enos. ");
INSERT INTO kwf_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sui sa Set ka tua laꞋu sulia 807 faꞋi ngali ki, ma nia ka alua laꞋu ti ngela ngwane ma ti ngela kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ma ana kaidaꞋi nia mae nia tua naꞋa sulia 912 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","KaidaꞋi sa Enos nia dao ana 90 faꞋi ngali ki, nia ka alua sa Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sui sa Enos ka tua laꞋu sulia 815 faꞋi ngali ki, ma ana kaidaꞋi neꞋeri nia ka alua laꞋu ti ngela ngwane ma ti ngela kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ma ana kaidaꞋi nia mae nia tua naꞋa sulia 905 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","KaidaꞋi sa Kenan nia dao ana 70 faꞋi ngali ki, nia ka alua sa Mahelalel. ");
INSERT INTO kwf_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sui sa Kenan ka tua laꞋu sulia 840 faꞋi ngali ki, ma ana kaidaꞋi neꞋeri nia ka alua laꞋu ti ngela ngwane ma ti ngela kini. ");
INSERT INTO kwf_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ma ana kaidaꞋi nia mae nia tua naꞋa sulia 910 ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sa Mahelalel tua sulia 65 faꞋi ngali ki ka sui, nia ka fiꞋi alua sa Jered. ");
INSERT INTO kwf_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sui sa Mahelalel ka tua laꞋu sulia 830 akwala faꞋi ngali ki, nia ka alua laꞋu ti ngela ngwane faꞋinia ti ngela kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma ana kaidaꞋi nia mae nia tua naꞋa sulia 895 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","KaidaꞋi sa Jered nia tua ka dao naꞋa ana 162 faꞋi ngali ki, nia ka alua sa Enok. ");
INSERT INTO kwf_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sui sa Jered ka tua laꞋu sulia 800 faꞋi ngali ki, ana kaidaꞋi neꞋeri nia ka alua laꞋu ti ngela ngwane ma ti ngela kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ma kaidaꞋi nia mae, nia tua ka dao naꞋa ana 962 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","KaidaꞋi sa Enok nia dao ana 65 faꞋi ngali ki, nia ka alua sa Metusala. ");
INSERT INTO kwf_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sui sa Enok ka tua laꞋu sulia 300 faꞋi ngali ki, ma nia ka donga God ana maurilana taꞋifau. Ma nia ka alua laꞋu ti ngela ngwane faꞋinia ti ngela kini. ");
INSERT INTO kwf_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Nia ka donga God ana manatalana taꞋifau leleka God ka lafua faꞋasia na magalia neꞋe kaidaꞋi nia mauri goꞋo Ꞌana. Ma noaꞋa ta ngwae kasi lisia naꞋa. Ana kaidaꞋi neꞋeri nia dao naꞋa ana 365 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","KaidaꞋi sa Metusala nia dao ana 187 faꞋi ngali ki, nia ka alua sa Lamek. ");
INSERT INTO kwf_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sui sa Metusala ka tua laꞋu sulia 782 faꞋi ngali ki, ma nia ka alua laꞋu ti ngela ngwane ma ti ngela kini. ");
INSERT INTO kwf_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ma kaidaꞋi nia mae, nia dao naꞋa ana 969 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","KaidaꞋi sa Lamek nia dao ana 182 faꞋi ngali ki, nia alua taꞋi ngela ngwane. ");
INSERT INTO kwf_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nia ka fata Ꞌuri, “Na ngela neꞋe nia ke baꞋa kwaiꞋafi akulu, fasi Ꞌiri kulu ka taꞋi mamalo tiꞋitiꞋi basi ana raoꞋa ngasi kulu ki ana ano neꞋe, niniꞋa Iawe matalangaꞋinia ka sui naꞋa.” Ma nia ka saea na ngela neꞋeri Ꞌani sa Noa. ");
INSERT INTO kwf_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sui sa Lamek tua laꞋu sulia 595 faꞋi ngali ki. Ma ana kaidaꞋi neꞋeri nia ka alua laꞋu ti ngela ngwane ma ti ngela kini laꞋu goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ma kaidaꞋi nia mae nia dao naꞋa ana 777 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","KaidaꞋi sa Noa nia dao ana 500 faꞋi ngali ki, nia alua uulu ngela ngwane ki. Ma nia ka faꞋa satada Ꞌania sa Siem, sa Ham, ma sa Jafet. ");
INSERT INTO kwf_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ana kaidaꞋi na ngwae ki Ꞌoro naꞋa saena na magalia neꞋe, ma na kini Ꞌoro ki kira futa logo, ");
INSERT INTO kwf_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","na ngela ngwane God ki kira lisia ngela kini Ngwae ki lisilada leꞋa liu, ma kira ngali ta kini goꞋo ada kira oga kike korea, ma kika koreda toꞋotoꞋo naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ꞋUnaꞋeri na Iawe ka fata Ꞌuri, “NoaꞋa nia Ꞌiri leꞋa neꞋe Mango Ꞌaku ka teo tari ana ngwae ki. KiraꞋa na ngwae saena magalia ki goꞋo niniꞋa neꞋe ta asoa kike baꞋa mae. ꞋIta Ꞌi taꞋena kike baꞋa tua goꞋo sulia 120 faꞋi ngali ki.” ");
INSERT INTO kwf_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ma ana kaidaꞋi neꞋeri ma Ꞌi buri Ꞌana logo, ngwae doe liu ki kira tua logo saena magalia. Na ngwae neꞋeri ki futa ana kini Ngwae ki ba na ngela ngwane God ki kira ki koreda ma kika tuatua faꞋinida Ꞌi naꞋo ki. Na ngwae doe liu neꞋeri ki Ꞌi naꞋo, kiraꞋa ngwae mala fuana fuꞋanga ki, ma satada ka talo liu ana fanoa ki. ");
INSERT INTO kwf_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ma kaidaꞋi neꞋeri Iawe ka lisia na ngwae ana magalia kira taꞋa liu naꞋa. KaidaꞋi ki taꞋifau manatalada ngwae ki taꞋifau ka taꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ma na manatana Iawe ka kwaimanatai liu naꞋa. Nia manata sulia neꞋe nia saungaꞋinida ma ka aluda saena magalia neꞋe, ma na manatana ka dila liu naꞋa sulia. ");
INSERT INTO kwf_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Sui Iawe ka fata laꞋu Ꞌuri, “Nau kui baꞋa faꞋasuia na ngwae ba nau ku saungaꞋinida ki faꞋasia na magalia neꞋe. Ma na ru ꞋaeꞋaela ki, faꞋinia ti ru neꞋe ango fafona ano, ma na faꞋi noꞋo ki logo, nai baꞋa faꞋasuida. NauꞋa goꞋo neꞋe nau ku saungaꞋinida. Bore ma Ꞌi taꞋena nau ku manataida liu.” ");
INSERT INTO kwf_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bore ma sa Noa goꞋo neꞋe Iawe nia saeleꞋa liu faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Na ꞋaꞋemae sulia sa Noa nia Ꞌuri: Sa Noa toꞋo ana uulu ngela ngwane ki, ma satada neꞋe sa Siem, sa Ham, ma sa Jafet. Sa Noa goꞋo neꞋe taꞋi ngwae neꞋe tua ꞋoloꞋolo, ma noaꞋa nia Ꞌiri fulia ta ru fuana ngalia kwaꞋi kwaꞋinga ana kaidaꞋi nia tua saena magalia, ma nia ka donga God ana manatalana taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bore ma na ngwae ki taꞋifau ana magalia, kira abula rora ka taꞋa lilisu naꞋa Ꞌi naꞋona God. Kira tuani fuli bareꞋa ma kika dau goꞋo Ꞌani sau ngwaeꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God lisia maꞋi na magalia neꞋe ki, lisilana taꞋa ka lilisu naꞋa, osiꞋana na ngwae ki taꞋifau na falafala kira ki taꞋa liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ꞋUnaꞋeri God ka fata Ꞌuri fuana sa Noa, “OsiꞋana na fanoa nini Ꞌi ano nia fungu naꞋa Ꞌani taꞋangaꞋa neꞋe na ngwae ki fulia, nai baꞋa faꞋasuia ngwae ki taꞋifau. Mamana liu, naꞋi baꞋa malangisia na magalia neꞋe faꞋinia na ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nia neꞋe Ꞌoke ngalia na reba Ꞌai leꞋa ki naꞋa, ma Ꞌoko saungaꞋinia taꞋi faka doe liu, Ꞌoke saungaꞋinia kala maꞋe luma ki Ꞌi saena, ma Ꞌoko saia Ꞌi saena ma Ꞌi iila logo Ꞌania na buli saia ki. ");
INSERT INTO kwf_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ꞋOke saungaꞋinia ketalana ke baꞋa dao ana 135 mita. Ma reba lana ke dao ana 22 mita. Ma fanelana ke dao ana 13 mita. ");
INSERT INTO kwf_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","“Ma kaidaꞋi Ꞌoko saungaꞋinia na luma ana na faka neꞋeri, noaꞋa Ꞌoe kosi Ꞌodoa Ꞌi ninimana leleka ka dao Ꞌi gwaofana. ꞋOke alaꞋania ro bali ninimana ki ke Ꞌifi goꞋo Ꞌani. Gwauni ke raꞋe ka bolo faꞋinia taꞋi ꞋoiꞋa. ꞋOke saungaꞋinia uulu tatafe ki Ꞌi saena, ma Ꞌoko saungaꞋinia taꞋi sina maa Ꞌi ninimana. ");
INSERT INTO kwf_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Nai baꞋa kwatea maꞋi taꞋi kafo afe doe liu ke fungulia magalia neꞋe, ka mumunia ru neꞋe mauri ki taꞋifau Ꞌiri kike funu. Na ru saena na magalia neꞋe ki ke baꞋa mae taꞋi taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bore ma ana kaidaꞋi neꞋe nau kui baꞋa fata Ꞌani taꞋi fau alangaꞋi Ꞌanga faꞋiniꞋo, nai baꞋa tagi suliꞋo saena na faka neꞋeri ma faꞋinia Ꞌafe Ꞌoe ma na uulu ngela Ꞌoe ki faꞋinia uulu Ꞌafe kira ki. Kaumulu taꞋifau muke raꞋe saena faka neꞋeri fasi Ꞌiri muke mauri. ");
INSERT INTO kwf_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ma Ꞌoke baꞋa ngalia ro faꞋi noꞋo ki saena na faka neꞋeri, ma ro ru Ꞌanga ana ru ꞋaeꞋaela, ma na ru ki taꞋifau neꞋe mauri fafona ano neꞋe. Na ru neꞋeri ki Ꞌoke baꞋa ngalia ta taꞋi ru ngwane faꞋinia ta taꞋi ru kini saena na faka faꞋi kaumulu Ꞌiri kike mauri. ");
INSERT INTO kwf_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma Ꞌoke baꞋa ngalia logo ti fanga Ꞌi saena faka neꞋeri ke totoli kaumulu ma na ru neꞋe kira mauri ki logo.” ");
INSERT INTO kwf_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Sui sa Noa ka sasi naꞋa sulia ru ki taꞋifau neꞋe God nia fata totongaꞋi fuana. ");
INSERT INTO kwf_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Aia, God nia ka fata Ꞌuri fuana sa Noa, “KaidaꞋi neꞋe naꞋa ꞋaeꞋo faꞋinia na Ꞌafe Ꞌoe ma na ngela koroꞋo ki, muke leka naꞋa saena na faka neꞋe, osiꞋana nau ku lisia ka sui naꞋa, taꞋi ꞋaeꞋo goꞋo neꞋe Ꞌoko ꞋoloꞋolo liu ka liufia na ngwae ki saena magalia neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ꞋOke ngali akwala ma fai ru ana ru ꞋaeꞋaela sikasika ki, ta fiu ru ana ai ngwane ki, ma ta fiu ru ana ai kini ki. Ma Ꞌoko ngalia logo ro ru Ꞌanga ana ru neꞋe noaꞋa Ꞌiri sikasika ki, ta taꞋi ru ngwane faꞋinia ta taꞋi ru kini. ");
INSERT INTO kwf_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma Ꞌoko ngalia akwala ma fai ru ana ta noꞋo bore Ꞌana. Ta fiu ru ngwane ma ta fiu ru kini. ꞋOke sasi nama ꞋunaꞋeri fasi Ꞌiri neꞋe kaidaꞋi na kafo ke gwaꞋu na ru neꞋeri ki taꞋifau kike kale ma kike alu ngela laꞋu saena magalia taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","KaidaꞋi neꞋe, fiu asoa ki naꞋa neꞋe teo ma nau kui baꞋa kwate na uta doe ke dao maꞋi, ma nia ke baꞋa toꞋo sulia fai akwala asoa ma fai akwala rodo, ma nai baꞋa malangisia na ngwae ki taꞋifau ma faꞋinia ru ki taꞋifau neꞋe nau ku saungaꞋiniꞋi saena na magalia neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma sa Noa ka sasi sulia ru neꞋe God fata totongaꞋi fuana. ");
INSERT INTO kwf_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","KaidaꞋi na kafo afe doe neꞋeri dao ka mumunia ru ki taꞋifau, sa Noa nia tua naꞋa sulia 600 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ma niaꞋa faꞋinia Ꞌafe nia, ma na uulu ngela nia ki faꞋinia uulu Ꞌafe kira ki, kira ka ruꞋu naꞋa saena na faka doe neꞋeri, kira ka ago naꞋa faꞋasia na kafo afe doe neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ma ru ꞋaeꞋaela neꞋe sikasika ki, faꞋinia ai noaꞋa Ꞌiri sikasika ki, ma faꞋi noꞋo ki, ma ru angoango ki, ");
INSERT INTO kwf_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kika leka naꞋa saena faka neꞋeri faꞋinia sa Noa, ma ru ki ana ro ruꞋa, kika leka fiku. Ta taꞋi ru ngwane faꞋinia ta taꞋi ru kini kira ka ruꞋu naꞋa diꞋia nama neꞋe God nia fata totongaꞋi fuana sa Noa. ");
INSERT INTO kwf_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ma na fiu asoa ki Ꞌi buri Ꞌana, na kafo afe doe liu afe ka fungulia na magalia. ");
INSERT INTO kwf_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ana ruana madamo ana akwala asoa ma fiuna asoa ana faꞋi ngali neꞋe sa Noa nia dao naꞋa ana ono talangaꞋi faꞋi ngali ki, na kilu kafo ki saena ano neꞋe niꞋi ka Ꞌifi, ma kafo ka luluasa maꞋi ka doe, ma maꞋe uta doe ki ka toꞋo maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ma na uta neꞋeri ka toꞋo toꞋo leleka ka dao ana fai akwala asoa ma fai akwala rodo. ");
INSERT INTO kwf_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ma ana asoa neꞋeri nama neꞋe sa Noa faꞋinia Ꞌafe nia ma uulu ngela nia ki, sa Siem, sa Ham ma sa Jafet, faꞋinia uulu Ꞌafe kira ki, kira ka raꞋe naꞋa saena na faka neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ma kwalu kaela ru ꞋaeꞋaela naꞋa saena magalia neꞋe, kira leka naꞋa saena na faka faꞋinia sa Noa. Nia toꞋo ana ru ꞋaeꞋaela Ꞌi fanoa ki faꞋinia ru ꞋaeꞋaela ki taꞋifau saena masuꞋua, ai doe ki ma na ai tiꞋitiꞋi ki, ma faꞋi noꞋo ki taꞋifau, kira leka logo saena na faka neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ru ki taꞋifau neꞋe kira toꞋo ana mauriꞋa kira leka ro ruꞋa, ai ngwane faꞋinia ai kini, kira leka naꞋa saena faka faꞋinia sa Noa diꞋia ba God saea. Ma kaidaꞋi kira tua taꞋifau naꞋa saena faka neꞋeri, Iawe ka fono naꞋa Ꞌusia sina maa ana na faka. ");
INSERT INTO kwf_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Na kafo neꞋe ka afe ka doe liu laꞋu, ma nia ka fungu naꞋa fafia magalia neꞋe, leleka ka dao ana fai akwala asoa ki. Ma kaidaꞋi kafo neꞋeri fungu maꞋi ka fungulia kula neꞋe faka nia teo ana, ma kafo ka lafutaꞋinia naꞋa na faka neꞋe, ma ka faꞋolangaꞋinia, ma nia ka faꞋofaꞋo ka leka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Na kafo neꞋe ka inaꞋu ana funguꞋa fafia magalia neꞋe, ma faka neꞋe nia faꞋofaꞋo ka leꞋa goꞋo Ꞌana, ");
INSERT INTO kwf_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","leleka kafo neꞋe ka fungu fafia na faꞋi ua ki, ma ka raꞋe ka leleka Ꞌana. Gwauna faꞋi ua ki bore ka fungu fafiꞋi ka Ꞌato liu. ");
INSERT INTO kwf_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fafona ua ki kafo fungu ka Ꞌato liu, nia koso ka dao karangia fiu mita ki. ");
INSERT INTO kwf_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Ru ki taꞋifau neꞋe toꞋo ana mangoꞋi ru ki neꞋe kira tua ana magalia nini God saungaꞋinida, kaidaꞋi neꞋe nia kuruda, ma kira ka mae taꞋifau naꞋa. Ngwae ki taꞋifau faꞋinia ru ꞋaeꞋaela ki taꞋifau ma na ru angoango ki fafona ano neꞋe ma faꞋi noꞋo ki taꞋifau, God nia malingaꞋinida taꞋifau naꞋa. Sa Noa goꞋo faꞋinia luꞋuluꞋua nia, ma ru ki taꞋifau neꞋe tua faꞋinia saena faka doe neꞋe goꞋo neꞋe kira mauri. ");
INSERT INTO kwf_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ꞋIu na kafo neꞋeri fungu nama Ꞌana ꞋunaꞋeri ka leka sulia taꞋi talangaꞋi asoa ma lima akwala asoa. ");
INSERT INTO kwf_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bore ma God nia manata nama toꞋona Ꞌua sa Noa, ma na ru ki taꞋifau neꞋe kira tua faꞋinia saena na faka neꞋeri, sui nia ka kwatea taꞋi maꞋe iru iru ka iru fafia kafo neꞋeri, ma kafo ka talaꞋae ka koso laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nia ka fono Ꞌusia na kilu kafo ki saena ano, fasi Ꞌiri kafo noaꞋa kasi busu tafa naꞋa maꞋi, ma nia ka faꞋasuia naꞋa uta doe neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ma kafo neꞋeri ka etangia naꞋa gwaꞋunga leleka ka dao naꞋa ana talangaꞋi asoa ma lima akwala asoa. ");
INSERT INTO kwf_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na faka doe neꞋeri ka teo naꞋa Ꞌi gwauna ua doe Ꞌi Ararat ki, ana akwala asoa ma fiuna asoa saena fiuna madamo. ");
INSERT INTO kwf_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Na kafo ka Ꞌidu ka koso laꞋu, ma ana tangafula madamo ana faꞋi ngali neꞋe ana etana asoa ana madamo, ti gwaꞋi ua talaꞋae ka raꞋe naꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Buri Ꞌana fai akwala asoa ki laꞋu, sa Noa ka Ꞌifingia na maa olofolo ana faka neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","8","osiꞋana nia oga ke saiana fasi diꞋia kafo neꞋeri nia gwaꞋu naꞋa ana kula neꞋeri. Aia, nia ka kwatea kwau na taꞋi faꞋi noꞋo doe neꞋe satana na refen, ma ka faꞋa lofotaꞋinia kwau. Bore ma faꞋi noꞋo neꞋeri ka leka ana kula ki taꞋifau, ma nia ka tuani lofo kwailiu goꞋo Ꞌana, leleka ka dao ana kaidaꞋi kafo neꞋeri gwaꞋu ka langa langa naꞋa. Buri Ꞌana laꞋu sa Noa ka kwatea laꞋu kwau na bola, ma ka danga Ꞌania ka lofo laꞋu kwau, ");
INSERT INTO kwf_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","bore ma na bola neꞋeri noaꞋa kasi dao toꞋona ta kula fuana tuaꞋa, osiꞋana na kafo fungu goꞋo Ꞌana Ꞌua fafia ano, ma nia ka oli laꞋu maꞋi saena na faka. KaidaꞋi nia oli maꞋi, sa Noa taga kwau limana sulia sinamaa olofolo, ma na bola neꞋeri ka lofo maꞋi, ma ka toꞋo ana limana. Ma sa Noa ka ngalia maꞋi saena na faka. ");
INSERT INTO kwf_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nia masia laꞋu fiu asoa ki ka sui, nia ka fiꞋi danga laꞋu kwau Ꞌania bola neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ma ka saꞋulafi naꞋa bola neꞋeri ka oli laꞋu maꞋi, ma nia ka ngalia maꞋi raꞋi olif faolu Ꞌani kwakwana Ꞌi neꞋeri. Sa Noa ka sai Ꞌuri ana na kafo neꞋe gwaꞋu karangi ka sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nia ka masia laꞋu ta fiu asoa ka sui, Ꞌi neꞋeri nia ka danga Ꞌania na bola neꞋeri ka leka laꞋu kwau, bore ma kaidaꞋi neꞋe, nia noaꞋa Ꞌiri oli naꞋa maꞋi siana. ");
INSERT INTO kwf_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Etana asoa ana madamo etaeta ana faꞋi ngali neꞋeri, kaidaꞋi neꞋeri sa Noa nia dao naꞋa ana ono talangaꞋi faꞋi ngali ma taꞋi faꞋi ngali, kafo neꞋe ka langa langa taꞋifau naꞋa fafona magalia neꞋe. Sui sa Noa nia Ꞌifingia sinamaa ana na faka neꞋeri, ma na ano ꞋekeꞋeke ka tataꞋe laꞋu maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ma ana ro akwala ma faina asoa ana ruana madamo ana faꞋi ngali neꞋeri, na ano nia langa langa taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Sui God nia ka fata Ꞌuri fuana sa Noa, ");
INSERT INTO kwf_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“KaidaꞋi neꞋe naꞋa, Ꞌafe Ꞌoe faꞋiniꞋo, faꞋinia uulu ngela Ꞌoe ki faꞋinia uulu Ꞌafe kira ki, kaumulu taꞋifau mulu saiana muke raꞋe naꞋa maꞋi faꞋasia na faka neꞋana. ");
INSERT INTO kwf_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ma muke logea ru ki taꞋifau nena tua faꞋiniꞋo saena na faka, kike raꞋe logo maꞋi, fasi Ꞌiri kike baꞋa alu ngela Ꞌiri kike Ꞌoro saena magalia neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ꞋUnaꞋeri sa Noa faꞋinia luꞋuluꞋua nia, kira ka raꞋe naꞋa maꞋi faꞋasia faka neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ma ru ki taꞋifau neꞋe kira tua faꞋinia, kira ka leka logo maꞋi Ꞌi maa, ma kira ka ruꞋu maꞋi Ꞌi maa sulia fuuꞋi tuaꞋa kira ki sulida talada. ");
INSERT INTO kwf_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Aia, sa Noa nia Ꞌuia taꞋi sulufaua fuana foꞋosilana Iawe, ma nia ka ngalia ti ru ꞋaeꞋaela faꞋinia ti faꞋi noꞋo neꞋe kira sikasika fuana Ꞌau abuꞋa, ma nia ka saungida kike mae, ma ka doꞋofida fafona sulufaua neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Iawe nia saeleꞋa liu ana moko leꞋangaꞋa ana foꞋosi neꞋeri ki, ma nia ka manata Ꞌana talana Ꞌuri, “Nau ku saiana falafala ngwae ki, Ꞌita ana kaidaꞋi neꞋe kira tiꞋitiꞋi nama Ꞌua, manatada nia teo sui naꞋa ana taꞋangaꞋa. Ka ꞋunaꞋeri bore Ꞌana, noaꞋa naisi baꞋa faꞋalia laꞋu na magalia neꞋe duꞋungana fuli ru lana ngwae ki. KaidaꞋi neꞋe nau ku faꞋafunua na ngwae ki faꞋinia ru toꞋo ana mangoꞋi ru ki, kira ka mae ka sui taꞋifau naꞋa. Bore ma naisi baꞋa sasi naꞋa Ꞌuri Ꞌi buri, diꞋia nini nau ku sasi ana kaidaꞋi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","KaidaꞋi neꞋe ka raꞋe ꞋalaꞋa, na magalia nia toꞋo ana kaidaꞋi fuana fasi lana oꞋola, ma nia ka toꞋo ana kaidaꞋi fuana loi lana fuaꞋi ru ki. Nia toꞋo ana kaidaꞋi fuana gwariꞋa, ma nia ka toꞋo logo ana kaidaꞋi fuana ꞋakoꞋako Ꞌanga. Nia toꞋo ana kaidaꞋi fuana rauna Ꞌai ke aragwata, ma nia ka toꞋo logo ana kaidaꞋi fuana rauna Ꞌai ke ngosa laꞋu. Nia toꞋo ana kaidaꞋi ana dangi, ma ka toꞋo logo ana maꞋerodo. Ma na ru ꞋunaꞋeri ki noaꞋa kira kasi sui, leleka ka dao ana Ꞌisilana magalia.” ");
INSERT INTO kwf_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Sui God faꞋaleꞋa sa Noa, faꞋinia uulu ngela nia ki, ma nia ka fata Ꞌuri fuada, “Kaumulu ke toꞋo ana ngela Ꞌoro, fasi Ꞌiri magalia neꞋe ke fungu Ꞌanida. ");
INSERT INTO kwf_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Na ru ꞋaeꞋaela ki taꞋifau ana magalia neꞋe, faꞋinia faꞋi noꞋo ki taꞋifau, ma iꞋa ki taꞋifau, kira ke maꞋungi kamu naꞋa. Ma na ru ꞋaeꞋaela neꞋe ki taꞋifau, nau ku aluda Ꞌi saena limamulu. ");
INSERT INTO kwf_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Etaeta nau ku kwatea goꞋo Ꞌaku ru saena oꞋola ki fuamuꞋa fuana ꞋanilaniꞋi, bore ma Ꞌita ana kaidaꞋi neꞋe, nau ku kwate na ru ꞋaeꞋaela ki ma na faꞋi noꞋo ki, ma na gwaꞋi iꞋa ki logo fuamuꞋa, fasi Ꞌiri kira naꞋa neꞋe diꞋia fanga fuamuꞋa fuana Ꞌanilani. ");
INSERT INTO kwf_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bore ma noaꞋa kamu kasi Ꞌania sibolo neꞋe na Ꞌabu teo Ꞌua Ꞌi saena. Nau ku luia ru neꞋeri duꞋungana na mauriꞋa nia teo saena Ꞌabu. ");
INSERT INTO kwf_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma nai baꞋa kwatea kwaꞋikwaꞋinga fuana ta ngwae neꞋe nia saungia ta ngwae ka mae. Ma si diꞋia ta ru ꞋaeꞋaela saungia ta ngwae ka mae, kike baꞋa saungia ka mae logo. ");
INSERT INTO kwf_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Na ngwae neꞋe saungia ta ngwae ka mae, kike baꞋa saungia nia ke mae logo, duꞋungana nau ku saungaꞋinia ngwae ka diꞋia nauꞋa talaku. ");
INSERT INTO kwf_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kamu ke toꞋo nama ana ngela Ꞌoro, ma ngela kaumulu ki kike toꞋo nama ana ngela Ꞌoro kira ki, fasi Ꞌiri kike faꞋafungua magalia neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Sui God ka fata Ꞌuri fuana sa Noa faꞋinia ngwaꞋi ngela ngwane nia, ");
INSERT INTO kwf_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“KaidaꞋi neꞋe nau ku saea taꞋi fau alangaꞋi Ꞌanga fuaumulu faꞋinia ngela neꞋe kike baꞋa futa olitamulu ki, ");
INSERT INTO kwf_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma faꞋi noꞋo ki, ma ru ꞋaeꞋaela ki, ma ti ru laꞋu neꞋe toꞋo ana mangoꞋi ru ki, neꞋe kira tua faꞋi kaumulu saena faka neꞋana. ");
INSERT INTO kwf_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nau kui saea na fau alaꞋangaꞋi Ꞌanga neꞋe fuaumulu, noaꞋa naisi baꞋa kwatea laꞋu ta kafo afe doe Ꞌuri ke oli laꞋu maꞋi fuana faꞋa funua ru ki taꞋifau neꞋe mauri, noaꞋa ta kafo doe Ꞌuri laꞋu fuana faꞋali lana magalia neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ma God ka fata laꞋu Ꞌuri, “Na fau alangaꞋi Ꞌanga nau niniꞋa nau ku fata Ꞌani faꞋi kaumulu ma na ru ki taꞋifau neꞋe kira mauri, noaꞋa nia kasi baꞋa sui, ma maꞋetoto nia neꞋe ka Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nai baꞋa alua tafisiꞋoro nau ke teo saena gwaꞋi salo, ma tafisiꞋoro neꞋe na maꞋetoto ana fau alangaꞋinga nau neꞋe nau ku alangani faꞋi kaumulu. ");
INSERT INTO kwf_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","KaidaꞋi nau ku kwatea maꞋi gwaꞋi salo ki saena mamanga, na tafisiꞋoro ke saka naꞋa maꞋi ana gwaꞋi salo, ");
INSERT INTO kwf_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ma nai baꞋa manata toꞋo ana na fau alangaꞋinga nau neꞋe nau ku alangaꞋi faꞋi kaumulu ma ru ki taꞋifau neꞋe mauri. NoaꞋa naisi baꞋa faꞋalia naꞋa mangomuꞋa Ꞌania ta faꞋi kafo doe laꞋu Ꞌuri. ");
INSERT INTO kwf_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","KaidaꞋi na tafisiꞋoro ke saka maꞋi ana gwaꞋi salo, nai baꞋa lisia, ma nau kui baꞋa manata toꞋona na fau alangaꞋi Ꞌanga neꞋe nau ku alangani faꞋi kaumulu ma ru ki taꞋifau neꞋe mauri. Na fau alangaꞋi Ꞌanga neꞋe nau tutua kasi baꞋa sui.” ");
INSERT INTO kwf_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma nia ka fata laꞋu Ꞌuri fuana sa Noa, “Na tafisiꞋoro neꞋe naꞋa neꞋe na maꞋetoto ana fau alangaꞋinga nau neꞋe nau ku alangani faꞋiniꞋo ma ru ki taꞋifau neꞋe mauri saena magalia.” ");
INSERT INTO kwf_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Na uulu ngela sa Noa ki neꞋe kira leka maꞋi faꞋinia ana faka doe neꞋeri neꞋe sa Siem, ma sa Ham, ma sa Jafet. (Sa Ham ka alua sa Kenan.) ");
INSERT INTO kwf_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ma ngwae ana magalia taꞋifau, kira futa maꞋi ana kwalafa uulu ngwae neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Sa Noa ngwae naꞋa fuana oꞋongaꞋa, ma niaꞋa na ngwae etaeta fuana oꞋoli lana oꞋola Ꞌani grep. Nia saungaꞋinia Ꞌani waen ana fuaꞋi grep ki. ");
INSERT INTO kwf_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","TaꞋi kaidaꞋi nia kwaꞋufia waen neꞋeri, ma nia ka burasia liu naꞋa, ma nia ka kanusua toro nia ki, ma nia ka maliu dadara Ꞌana Ꞌi saena na babala nia. ");
INSERT INTO kwf_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ꞋIu ana kaidaꞋi sa Ham nia lisia neꞋe maꞋa nia maliu dadara ꞋunaꞋeri, nia leka kwau ma ka faꞋarongoa ro ngwae futa nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ꞋIu sa Siem ma sa Jafet kera ka ngalia taꞋi toro keta Ꞌi gwauna ꞋabaꞋabada roꞋo, ma kera ka leka faꞋiburi Ꞌuana babala maꞋa kera, ma kera ka suu fafia laꞋu. Kera ka faꞋitaꞋi matamata ana maadaroꞋo, fasi Ꞌiri kera kasi lisia laꞋu neꞋe maꞋa kera maliu dadara. ");
INSERT INTO kwf_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Aia kaidaꞋi sa Noa nia ada laꞋu nia ka rongoa ru neꞋe susu buri nia sa Ham sasi ana, ");
INSERT INTO kwf_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sui nia ka fata Ꞌuri fuana olitana sa Ham ki, “Nia ke taꞋa ka lilisu fuamuꞋa sa Kenan faꞋinia kwalafaꞋa nia. Kira ke baꞋa rao laga ulafu fuana kwalafaꞋa ro ngwae futa nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","BaꞋatafea na Iawe niaꞋa na God ana sa Siem. Na kwalafaꞋa sa Kenan ki ke baꞋa rao laga ulafu fuana kwalafaꞋa sa Siem. ");
INSERT INTO kwf_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nau ku foꞋo Ꞌiri neꞋe God ke baꞋa faꞋa Ꞌoroa Ꞌato kaleꞋa sa Jafet, ma kira ke baꞋa tua Ꞌania leꞋangaꞋa faꞋinia kwalafaꞋa sa Siem, ma na kwalafaꞋa sa Kenan ke baꞋa rao laga ulafu logo fuada.” ");
INSERT INTO kwf_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Aia, buri Ꞌana kafo afe doe neꞋeri, sa Noa ka tua laꞋu sulia 350 faꞋi ngali laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ma kaidaꞋi nia mae, nia dao naꞋa ana 950 faꞋi ngali ki ana maurilana. ");
INSERT INTO kwf_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Na ꞋaꞋemae sulia kwalafa uula ngela sa Noa ki, sa Siem, sa Ham, ma sa Jafet, nia Ꞌuri: ꞋI buri Ꞌana kafo afe doe baera kira toꞋo laꞋu ana ngela Ꞌoro kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Na ngela ngwane sa Jafet ki, satada neꞋe sa Goma, ma sa Megog, sa Madae, ma sa Javan, ma sa Tubal, sa Mesek ma sa Tiras. Ma kwalafa kira ki neꞋe kira toꞋo ana sataꞋi ru neꞋe ki, kira futa maꞋi ana kwalafa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na ngela ngwane sa Goma ki, satada neꞋe sa Askenas, sa Rifat, sa Togama. Ma na fuuꞋi ngwae ngwaꞋi toꞋa neꞋe, kira futa maꞋi ana kwalafa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Na ngela ngwane sa Javan ki, satada neꞋe sa Elisa, sa Spen, sa Saepras, ma sa Rojes. ");
INSERT INTO kwf_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nia neꞋe na kwalafa leka maꞋi buri Ꞌana sa Javan kira tua kwailiu ana bubunga kira ki, ma ninimana na asi. Nia neꞋe na kwalafa leka maꞋi buri Ꞌana sa Jafet ngwae Ꞌua baera. Kira ka leka sulia kwalafa toꞋotoꞋo kira ki, ma kira ka toꞋo ana alaꞋanga toꞋotoꞋo kira ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Na ngela ngwane sa Ham ki, na satada neꞋe sa Kus, sa Ijip, sa Libia, ma sa Kenan. Ma na ngwae ana fanoa neꞋe ki, neꞋe kira toꞋo ana sataꞋi ru neꞋe ki, kira futa maꞋi ana kwalafa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na ngela ngwane sa Kus ki, na satada neꞋe sa Seba, sa Havila, sa Sakta, sa Raama, ma sa Sabteka. Ma ngela ngwane sa Raama ki, neꞋe sa Seba ma sa Dedan. Ma ngwae nini ana fanoa neꞋe ki nini satada kira futa ana kwalafa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ma sa Kus nia toꞋo ana taꞋi ngela ngwane neꞋe satana sa Nimrod, nia neꞋe ngwae etaeta saena magalia neꞋe nia ka Ꞌinotoa fafia kula Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","KaidaꞋi Ꞌoro na Iawe nia kwaiꞋafi ana, ma nia ta ngwae talingaꞋi logo fuana lululana ru ꞋaeꞋaela ki fuana Ꞌanilana, nia neꞋe leleka ka dao Ꞌi taꞋena, ngwae ki kira ka fata Ꞌuri, “Nau ku foꞋo Ꞌiri na Iawe ke baꞋa kwateꞋo ta ngwae talingaꞋi fuana lululana ru ꞋaeꞋaela kwasi ki, diꞋia sa Nimrod ba Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Etaeta nia gwaungaꞋi fafia fai fanoa doe ki neꞋe kira saeda Ꞌania Ꞌi Babilon, Ꞌi Erek, Ꞌi Akad ma Ꞌi Kadne. Kira tua ana kula kira saea Ꞌani Ꞌi Babilon. ");
INSERT INTO kwf_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ma Ꞌi buri Ꞌana nia ka leka Ꞌuana fanoa ꞋaꞋana kira saea Ꞌania Ꞌi Asiria, ma nia ka saungaꞋinia fanoa doe ki neꞋe kira saea Ꞌania Ꞌi Ninifa, ma Ꞌi Rehobotir, ma Ꞌi Kala, ");
INSERT INTO kwf_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Ꞌi Resen. Fanoa doe neꞋe kira saea Ꞌania Ꞌi Resen, nia tua Ꞌi tofongana Ꞌi Kala ma Ꞌi Ninifa. ");
INSERT INTO kwf_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ma ngwaꞋi toꞋa neꞋe kira futa maꞋi ana kwalafa sa Ijip, kira ana kwalafa sa Lud, ma kwalafa sa Anam, ma kwalafa sa Lehab, ma kwalafa sa Naftu, ");
INSERT INTO kwf_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ma kwalafa sa Patrus ki, ma kwalafa sa Kasluliu ki, ma kwalafa sa Krit. Ma Krit neꞋe, na ngwaꞋi toꞋa Ꞌi Filistia naꞋa neꞋe, kira futa maꞋi ana kwalafa nia. Ma ngwae ana kula ki neꞋe kira toꞋo ana sataꞋi ru ki, kira kwalafa kira naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ma na ro ngela ngwane sa Kenan ki, satadaroꞋo neꞋe sa Saedon na faꞋinaꞋonaꞋo nia, ma sa Het. Ma toꞋa neꞋe kira saka maꞋi ana kwalafa Ꞌi buri ana ro ngwae neꞋeri ki, kira toꞋo ana satadaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ma ti kwalafa neꞋe sa Kenan nia koꞋo naꞋa ada ki, neꞋe kwalafa sa Jebus, ma kwalafa sa Amoro ki, ma kwalafa sa Gigas ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ma olitana Hivi ki, ma olitana Aki ki, ma olitana Sini ki, ");
INSERT INTO kwf_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ma olitana Awad ki, ma olitana Semar ki, ma olitana Hamat ki. ꞋI buri kwalafa sa Kenan ki, kira Ꞌoro liu ma kira ka tuafia kula Ꞌoro ki laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ma ano kira ki ka doe liu naꞋa nia ka leka ka dao ana fanoa doe kira saea Ꞌania Ꞌi Saedon ana Ꞌaena fanoa, ma ka leka ka dao ana fanoa doe kira saea Ꞌania Ꞌi Gerara, karangia fanoa doe neꞋe kira saea ana Ꞌi Gasa ana Ꞌaena fanoa, ma ka leka ka dao ana fanoa doe ki neꞋe kira saea Ꞌania Ꞌi Sodom ma Ꞌi Gomora, ma Ꞌi Adma, Ꞌi Seboeim karangi ana Ꞌi Lasa, neꞋe kira tua Ꞌi bali ana fanelana sina. ");
INSERT INTO kwf_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nia neꞋe fufuꞋi ngwae kira futa maꞋi ana kwalafa sa Ham. NgwaꞋi toꞋa neꞋeri kira tua kwailiu ana kula toꞋotoꞋo kira ki, leka nama sulia kwalafa kira ki talada, ma kira ka toꞋo ana alaꞋanga toꞋotoꞋo kira ki talada logo. ");
INSERT INTO kwf_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ma sa Siem nia etaeta ngwaefuta nia sa Jafet. Sa Siem nia toꞋo ana ngela ki. Ma na fuuꞋi ngwae sa Eba futa maꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Na ngela ngwane sa Siem ki na satada neꞋe sa Elam, sa Asuru, sa Afaksad, sa Lud, ma sa Aram. Ma fuuꞋi ngwae neꞋe saka maꞋi burida ki, na satada neꞋeriꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ma na ngela ngwane sa Aram ki satada neꞋe sa Us, sa Hul, sa Geta, sa Mesek. ");
INSERT INTO kwf_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Sa Afaksad nia alua sa Sela, ma sa Sela ka alua sa Eba. ");
INSERT INTO kwf_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Sa Eba ka alua ro ngela ngwane ki, ma nia ka saea faꞋinaꞋonaꞋo nia Ꞌania sa Pileg, osiꞋana nia futa ana kaidaꞋi ngwae ana magalia kira ka daro ma ka talo. Ma nia ka saea ruana ngela nia Ꞌania sa Joktan. ");
INSERT INTO kwf_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ma ngela ngwane sa Joktan ki, satada neꞋe sa Almodad, sa Selef, sa Hasamaret, sa Jera, ");
INSERT INTO kwf_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","sa Hadoram, sa Usal, sa Dikla, ");
INSERT INTO kwf_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","sa Obal, sa Abimael, sa Seba, ");
INSERT INTO kwf_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","sa Ofir, sa Havila, ma sa Jobab. Na ngwaꞋi toꞋa neꞋeri kira koꞋo bora ana fuuꞋi ngwae kira futa maꞋi ana sa Joktan. ");
INSERT INTO kwf_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ma kula kira nia tua ana bali ana fanelana sina, Ꞌi safitana faꞋi ua ki, nia eta Ꞌi Mesa leleka ka dao Ꞌi Sefa. ");
INSERT INTO kwf_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nia naꞋa na fuuꞋi ngwae sa Siem. NgwaꞋi toꞋa neꞋeri ki kira tua ana kula ki taꞋifau ana kula kira ki, leka sulia kwalafa kira ki, ma kira ka alaꞋa Ꞌania alaꞋanga toꞋotoꞋo kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nia naꞋa neꞋe na kwalafa sa Noa neꞋe futa maꞋi ana, faꞋinia tuaꞋa kira ki neꞋe kira tua Ꞌani. Buri Ꞌana kafo afe doe baera, ngwae ki taꞋifau ana magalia, kira futa maꞋi ana uulu ngela niniꞋa sa Noa ki, ma kira ka talo saena magalia. ");
INSERT INTO kwf_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ꞋI naꞋo maꞋi, ngwae ana fanoa ki ana magalia kira toꞋo goꞋo ana taꞋi alaꞋanga goꞋo, ma kira ka alaꞋa goꞋo Ꞌani alaꞋanga neꞋeri goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ma kaidaꞋi kira Ꞌidu Ꞌuana bali ana fanelana sina, kira ka dao toꞋona taꞋi oleolea neꞋe kira saea Ꞌania Ꞌi Babilon. Ma kira ka saungaꞋinia fanoa doe kira Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ma kira ka fata Ꞌuri, “Reala kwa! Kulu ngalia ta afu ano, ma kulu ka saungaꞋinia Ꞌania ti afu brik, ma kulu ka doꞋofiꞋi ana mafula fasi Ꞌiri ke ngasi.” KaidaꞋi kira sasi ꞋunaꞋeri kira toꞋo ana brik Ꞌoro fuana saungaꞋi lumaꞋanga, ma kira ka toꞋo ana saia fuana Ꞌadolani. Kira kasi rao Ꞌani fau ki ma sement. ");
INSERT INTO kwf_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Sui kira ka fata Ꞌuri, “Nia leꞋa fuakulu kuke saungaꞋinia ta fanoa doe fuakulu neꞋe nia ke baꞋa toꞋo ana ta luma ana neꞋe raꞋe ka leka leka Ꞌana ka dao maꞋi ana mamanga. ꞋI neꞋeri kuke baꞋa toꞋo ana sataꞋi ngwae doe, ma noaꞋa kulu kasi tua taka fili kulu saena magalia neꞋe taꞋifau, bore ma kulu ke tua fiku goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ma kaidaꞋi kira saungaꞋi fanoa doe faꞋinia luma neꞋeri, Iawe ka koso maꞋi ka lisia raoꞋa kira, ");
INSERT INTO kwf_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ma nia ka fata Ꞌuri, “Lia basi, kira tua fiku goꞋo diꞋia taꞋi ngwae, ma kira ka alaꞋa goꞋo Ꞌania taꞋi alaꞋanga. Na luma nini kira fiꞋi saungaꞋinia goꞋo na ru etaeta kira ke sasi. ꞋI buri, kira ke baꞋa sasia ta ru bore Ꞌana neꞋe kira naia. ");
INSERT INTO kwf_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ru leꞋa fuana kuke koso toli ma kuka kwatea alaꞋalada ke kwaidolangaꞋi, fasi Ꞌiri kira kasi rongo saiana alaꞋalana ti ai.” ");
INSERT INTO kwf_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ꞋIu Iawe ka kwate kira ka tua kwailiu ana kula ki taꞋifau ana magalia, ma kira noaꞋa kasi saungaꞋinia naꞋa fanoa doe neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Na satana fanoa neꞋeri neꞋe Ꞌi Babilon, osiꞋana kula neꞋeri na Iawe nia kwatea alaꞋanga ngwae ki ka kwaidolangaꞋi saena magalia, ma ana kula neꞋeri, ma nia ka lalia ngwae ki fasi Ꞌiri kike leka tua kwailiu ana kula ki taꞋifau saena magalia. ");
INSERT INTO kwf_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Na ꞋaꞋemae sulia kwalafa sa Siem nia Ꞌuri: Ana kaidaꞋi kafo afe doe baera nia sui naꞋa, sa Siem nia dao naꞋa ana 98 fai ngali ki, ma ta ro fai ngali laꞋu Ꞌi buri, nia ka alua sa Afaksad. ");
INSERT INTO kwf_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sui sa Siem ka tua laꞋu sulia ta 500 faꞋi ngali ki, ma nia ka alua laꞋu ti ngela ngwane ma ti ngela kini logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","KaidaꞋi sa Afaksad nia dao ana 35 faꞋi ngali ki, nia ka alua sa Sela. ");
INSERT INTO kwf_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sui sa Afaksad nia tua laꞋu sulia 403 faꞋi ngali ki, nia ka alua laꞋu ti ngela ngwane ma ti ngela kini logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","KaidaꞋi sa Sela nia dao ana 30 faꞋi ngali ki, nia ka alua sa Eba. ");
INSERT INTO kwf_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sui sa Sela tua laꞋu sulia 403 faꞋi ngali ki, ma nia ka alu laꞋu ngela ngwane ki ma ai kini ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","KaidaꞋi sa Eba nia dao ana 34 faꞋi ngali ki, nia ka alua sa Pileg. ");
INSERT INTO kwf_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sui sa Eba ka tua laꞋu sulia 430 faꞋi ngali ki, ma nia ka alua laꞋu ngela ngwane ki ma ngela kini ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","KaidaꞋi sa Pileg nia dao ana 30 faꞋi ngali ki, nia ka alua sa Riu. ");
INSERT INTO kwf_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sui sa Pileg nia tua laꞋu sulia 209 faꞋi ngali ki, ma nia ka alua laꞋu ti ngela ngwane ma ti ngela kini logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","KaidaꞋi sa Riu nia dao ana 32 faꞋi ngali ki, nia ka alua sa Sirag. ");
INSERT INTO kwf_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sui sa Riu nia tua laꞋu sulia 207 faꞋi ngali ki, ma nia ka alua laꞋu ti ngela ngwane faꞋinia ti ngela kini logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","KaidaꞋi sa Sirag nia dao ana 30 faꞋi ngali ki, nia ka alua sa Neho. ");
INSERT INTO kwf_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sui sa Sirag nia tua laꞋu sulia 200 faꞋi ngali ki, ma nia ka alua laꞋu na ngela ngwane ki ma ngela kini ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","KaidaꞋi sa Neho nia dao ana 29 faꞋi ngali ki, nia ka alua sa Tera. ");
INSERT INTO kwf_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sui sa Neho ka tua laꞋu sulia 119 faꞋi ngali ki, nia ka alua laꞋu ti ngela ngwane ma ti ngela kini logo. ");
INSERT INTO kwf_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ma sa Tera ka dao naꞋa ana 70 faꞋi ngali ki, nia ka alua sa Abram, sa Neho, ma sa Haran. ");
INSERT INTO kwf_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","29","Na ꞋaꞋemae sulia kwalafa sa Tera nia Ꞌuri: Na ngela ngwane nia ki neꞋe sa Abram, sa Neho, sa Haran. Ma ngela sa Haran ki neꞋe sa Lot, Ꞌi Milka, Ꞌi Iska. Sa Haran ni ka mae naꞋa ana fanoa doe nia Ꞌi Ur ana Ꞌi Kaldia, bore ma maꞋa nia sa Tera mauria Ꞌua. Aia, sa Abram nia korea taꞋi ngela kini sariꞋi neꞋe satana Ꞌi Serae. Ma sa Neho ka korea Ꞌi Milka kini ngwaefuta nia. ");
INSERT INTO kwf_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ꞋI Serae nia noaꞋa kasi alua ta ngela, osiꞋana nia ꞋabaraꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Aia, sa Tera ka ngalia ngela nia sa Abram faꞋinia Ꞌi Serae Ꞌafe sa Abram, ma nia ka ngalia koꞋo tiꞋitiꞋi nia sa Lot neꞋe maꞋa nia sa Haran, ma kira ka leka faꞋasia fanoa doe Ꞌi Ur neꞋe tua Ꞌi Kaldia, ma kira ka leka Ꞌuana abaꞋi kula Ꞌi Kenan. Bore ma kaidaꞋi kira dao ana fanoa Ꞌi Haran, kira ka sasia naꞋa fanoa kira Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Sa Tera nia ka mae naꞋa ana fanoa neꞋeri kaidaꞋi nia dao naꞋa ana 205 faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Iawe nia fata Ꞌuri ana sa Abram, “ꞋAeꞋo, Ꞌoke leka naꞋa faꞋasia fanoa nini Ꞌoe, ma faꞋasia kwalafa Ꞌoe, ma faꞋasia luꞋuluꞋua maꞋa Ꞌoe, ma Ꞌoke leka naꞋa Ꞌuana na ano neꞋe nai baꞋa faꞋataꞋinia amu. ");
INSERT INTO kwf_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Nai baꞋa kwatea Ꞌoke toꞋo ana kwalafa Ꞌoro, ma kira ke baꞋa tatakolaꞋa ka alu taꞋi fuuꞋi ngwae doe liu. Nai baꞋa faꞋaleꞋa Ꞌoe. Nai baꞋa lafutaꞋinia satamu ke talo. Ma Ꞌoke baꞋa faꞋaleꞋa ngwae ki laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Na ngwae neꞋe kira sasia ru leꞋa ki fuamu, nai baꞋa sasia logo ru leꞋa ki fuada. Bore ma ngwae ki neꞋe kira faꞋali Ꞌoe, nai baꞋa kwaꞋikwaꞋi kira. Nai baꞋa faꞋaleꞋa kwalafa ki taꞋifau ana magalia suliꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ana kaidaꞋi neꞋe sa Abram nia dao naꞋa ana fai akwala ma lima faꞋi ngali, Iawe ka saea fuana nia ke faꞋasia naꞋa fanoa Ꞌania Ꞌi Haran. Ma sa Abram nia roꞋo sulia, ma nia ka ngalia Ꞌafe nia Ꞌi Serae, ma sa Lot na ngela ngwaefuta sa Abram, faꞋinia ngwae rao ꞋoꞋo kira ki, ma ru ki taꞋifau neꞋe kira toꞋo ani, kaidaꞋi kira tua Ꞌi Haran. Ma kira taꞋifau, kika faꞋasia naꞋa Ꞌi Haran, ma kira ka leka naꞋa Ꞌuana abaꞋi kula Ꞌi Kenan. Ma kaidaꞋi kira dao naꞋa Ꞌi Kenan, ");
INSERT INTO kwf_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","kira ka leka liliu naꞋa Ꞌi Sekem. Sui kira ka leka dao ana taꞋi Ꞌai doe Ꞌua neꞋe nia tua Ꞌi More karangi Sekem. Ana kaidaꞋi neꞋeri na fuuꞋi ngwae Ꞌi Kenan ki, kira tua Ꞌua goꞋo Ꞌada ana kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Sui Iawe ka faꞋataꞋinia talana fuana sa Abram, ma nia ka fata Ꞌuri fuana, “Nai baꞋa kwatea ano neꞋe fuana kwalafa Ꞌoe.” Sui sa Abram ka Ꞌuia taꞋi sulufaua ana kula neꞋeri fuana foꞋosilana Iawe neꞋe faꞋataꞋinia talana fuana. ");
INSERT INTO kwf_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ꞋI buri Ꞌana nia ka Ꞌidu Ꞌuana gwauna ua ki ana bali ana fanelana sina ana fanoa doe kira saea Ꞌani Ꞌi Betel. ꞋIu sa Abram ka saungaꞋinia fanoa nia Ꞌi safitana ro fanoa doe ki neꞋe kira saea Ꞌanida Ꞌi Betel ma Ꞌi Aiae. ꞋI Betel nia tua ana bali Ꞌi sulana sina. Ma Ꞌi Aiae ka tua ana bali Ꞌi fanelana sina. Ma ana kula neꞋeri logo nia Ꞌuia taꞋi sulufaua fuana Iawe ma nia foꞋosia Ꞌani satana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ma Ꞌi buri Ꞌana, nia ka faꞋasia kula neꞋeri, ma nia ka Ꞌidu laꞋu Ꞌuana abaꞋi kula Ꞌi gwauna fanoa Kenan neꞋe kira saea Ꞌani Negev. ");
INSERT INTO kwf_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Aia kaidaꞋi sa Abram nia tua Ꞌi Negev, taꞋi fioloꞋa doe liu ka dao fafia kula ki taꞋifau Ꞌi Kenan. GoꞋo sa Abram nia ka leka laꞋu nama Ꞌana Ꞌuana gwauna fanoa leleka ka dao ana Ꞌi Ejipt fasi Ꞌiri kira taꞋi tua tiꞋitiꞋi Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ana kaidaꞋi kira karangi dao ana Ꞌi Ejipt, sa Abram ka fata Ꞌuri fuana Ꞌafe nia Ꞌi Serae, “ꞋAeꞋo niniꞋa, ꞋaeꞋo taꞋi Ꞌafe ꞋoloꞋolo lisilana leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","KaidaꞋi ngwae ana Ꞌi Ejipt kira ke lisiꞋo, kike baꞋa fata Ꞌuri, ‘Na Ꞌafe neꞋe, Ꞌafe ngwae loꞋoko.’ ꞋUnaꞋeri kira ka saungi nau nau ku mae, ma kira ka kwate Ꞌoko mauri. ");
INSERT INTO kwf_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nia leꞋa fuana Ꞌoke saea fuada neꞋe ꞋaeꞋo na ngwaingwaena nau goꞋo niniꞋa. ꞋUnaꞋeri noaꞋa kira kasi saungi nau. Ma ru ki taꞋifau ke baꞋa leꞋa fuaka, osiꞋana fatalamu.” ");
INSERT INTO kwf_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ꞋIu kaidaꞋi kira dao Ꞌi Ejipt, ngwae Ꞌi Ejipt ki kira ka lisia neꞋe Ꞌafe neꞋe lisilana leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ma kaidaꞋi ngwae ꞋaꞋana tatalafaꞋa ki kira lisia, kira ka faꞋarongoa na tatalafaꞋa neꞋe Ꞌi Serae taꞋi kini lisilana leꞋa ma ka leꞋa liu. ꞋUnaꞋeri na tatalafaꞋa ka baꞋea nia ka tua Ꞌi luma nia. ");
INSERT INTO kwf_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sui, tatalafaꞋa ka kwatea naꞋa dauraꞋia ka folia naꞋa Ꞌania kini neꞋeri fuana sa Abram sulia nia fia fasi na ngwaingwaena nia neꞋe Ꞌi Serae. Na tatalafaꞋa neꞋeri ka kwatea na sipsip ki, ma nanigot ki, ma buluka ki, ma dongki ki, ma kamel ki, faꞋinia na ngwae rao ꞋoꞋo ki, ma kini rao ꞋoꞋo ki fuana sa Abram. ");
INSERT INTO kwf_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bore ma duꞋungana na tatalafaꞋa ngalia Ꞌi Serae Ꞌafe sa Abram ka tua faꞋinia, Iawe ka kwatea maꞋi mataꞋinga taꞋa ki fuana faꞋalilana tatalafaꞋa neꞋeri faꞋinia na ngwae nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ꞋUnaꞋeri nia ka saea sa Abram ka leka maꞋi siana, ma ka fata Ꞌuri ana, “FaꞋuta neꞋe Ꞌoko sasi Ꞌuri aku kwa? FaꞋuta neꞋe noaꞋa Ꞌoe kosi saea fuaku neꞋe na kini neꞋe Ꞌafe Ꞌoe? ");
INSERT INTO kwf_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ꞋOko saea lala Ꞌania na ngwaingwaena Ꞌoe goꞋo, nia ne nau fasi kui ngalia fuana Ꞌafe nau. Aia, ngalia naꞋa kwau na Ꞌafe Ꞌoe, moro ka leka naꞋa kwau.” ");
INSERT INTO kwf_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Sui na tatalafaꞋa ka fata silolo fuana ngwae nia ki, kira ka leka baꞋea sa Abram faꞋinia Ꞌafe nia, kera ka ngalia ru keraꞋa ki taꞋifau neꞋe kera toꞋo ani, ma kera ka leka naꞋa faꞋasia kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","GoꞋo sa Abram faꞋinia Ꞌafe nia ma sa Lot na ngela ngwaefuta nia, kira uulu ngwae ki, kira ka ngalia ru kira ki taꞋifau neꞋe kira toꞋo ani, ma kira ka faꞋasia naꞋa Ꞌi Ejipt. Ma kira ka leka liu naꞋa Ꞌuana Ꞌi Ꞌaena fanoa, leleka kira ka dao Ꞌi Negev ana gwauna fanoa Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Sa Abram nia taꞋi ngwae toꞋoru, neꞋe nia toꞋo ana sipsip ki, ma nanigot ki, ma buluka nia ki, faꞋinia silva ki, ma gol ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","NoaꞋa kasi tau Ꞌi buri Ꞌana, nia ka faꞋasia kula neꞋe, ma nia ka Ꞌidu laꞋu Ꞌuana ta kula laꞋu, leleka nia ka oli ka dao ana na fanoa Ꞌua ba nia safitana fanoa doe Ꞌi Betel ma Ꞌi Aiae. ");
INSERT INTO kwf_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ꞋI neꞋeri naꞋa neꞋe nia ka fiꞋi Ꞌuia na sulufaua ma Ꞌi neꞋeri nia ka fiꞋi foꞋosia laꞋu Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma kaidaꞋi sa Lot nia leka leka faꞋinia sa Abram, nia toꞋo logo ana sipsip Ꞌoro ma nanigot ki, ma buluka ki, faꞋinia na luꞋuluꞋua nia, ma ngwae Ꞌoro rao nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Sa Abram ma sa Lot kera toꞋo ana ru Ꞌoro liu ki neꞋe kera noaꞋa kasi bolo naꞋa faꞋinia neꞋe keraꞋa ke tua ana taꞋi kula, osiꞋana na ano nia noaꞋa kasi bolo naꞋa faꞋinia ru ꞋaeꞋaela kera ki. ");
INSERT INTO kwf_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ꞋUnaꞋeri na ngwae ni rao neꞋe lia sulia na ru ꞋaeꞋaela keraꞋa ki, kira ka kwaifatai. Ma kaidaꞋi neꞋeri laꞋu goꞋo, na fufuꞋi ngwae sa Kenan faꞋinia fufuꞋi ngwae sa Peris, kira tua goꞋo Ꞌada ana abaꞋi kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Sui sa Abram ka fata Ꞌuri fuana sa Lot, “KoroꞋa taꞋi luꞋuluꞋua goꞋo, bore ma ngwae ni rao nau ki ma ngwae ni rao Ꞌoe ki, kira inaꞋu goꞋo ada ana kwaifataiꞋanga. Ru neꞋeri nia noaꞋa kasi saga nai. ");
INSERT INTO kwf_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nia leꞋa fuakoro, koro ke daroꞋi koro. Ano neꞋe ki ne teo goꞋo Ꞌana, nia leꞋa fuana Ꞌoke filia ta taꞋi bali neꞋe Ꞌoko oga, sui nau ku ngali ta bali.” ");
INSERT INTO kwf_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ꞋIu sa Lot ka lia kalia, ma ka lisia na oteotea doe fafona kafo Ꞌi Jodan leleka ka dao fanoa Ꞌi Soa ana gwauna fanoa. Ano neꞋe, ano leꞋa liu mala. Nia lisia neꞋe ano neꞋe nia toꞋo ana kafo leꞋa ka diꞋia na kula leꞋa neꞋe Iawe nia saungaꞋinia etaeta ana Ꞌi Iden, ma nia ka diꞋia na ano Ꞌi Ejipt logo. (Ma ana kaidaꞋi neꞋeri, Iawe noaꞋa kasi faꞋalia Ꞌua ro fanoa doe Ꞌi Sodom ma Ꞌi Gomora ki.) ");
INSERT INTO kwf_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","12","Aia sa Lot nia filia fuana Ꞌidua Ꞌuana bali ana fanelana sina ana oteotea fafona kafo Ꞌi Jodan, ma nia ka tua ana, ma nia ka leka naꞋa Ꞌuana kula neꞋeri. Sa Abram goꞋo neꞋe tua buri Ꞌi Kenan, bore ma sa Lot nia leka ka tua Ꞌi safitana fanoa doe ki neꞋe kira tua kalikalia kafo Ꞌi Jodan, karangia fanoa doe Ꞌi Sodom. Kera neꞋe kera daroꞋidaroꞋo goꞋo ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na ngwaꞋi toꞋa Ꞌi Sodom ki, kira taꞋa liu naꞋa, sulia kira inaꞋu ana na sasilana abula taꞋangaꞋa Ꞌi maana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Buri Ꞌana neꞋe sa Lot faꞋasia ka sui naꞋa, Iawe ka fata Ꞌuri fuana sa Abram, “ꞋOke lia ana kula ki taꞋifau kalikaliꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Na ano ki taꞋifau nini Ꞌoko lisiꞋi, nai baꞋa kwateꞋe fuamu faꞋinia kwalafa Ꞌoe, na ano neꞋe ru kamu naꞋa sulia kaidaꞋi firi. ");
INSERT INTO kwf_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nai baꞋa kwatea kwalafa Ꞌoe, kira ke baꞋa Ꞌoro liu, ma noaꞋa ta ngwae kasi saiana toꞋolada. Nia ke baꞋa Ꞌato liu fuana toꞋolada, ka diꞋia logo neꞋe nia Ꞌato liu fuana toꞋolana gegeona ano. ");
INSERT INTO kwf_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ꞋOke tataꞋe, ma ko leka liu naꞋa ana kula ki taꞋifau fafona ano neꞋe, osiꞋana nau ku kwatea naꞋa ano neꞋe ki taꞋifau fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Sui sa Abram ka faꞋasia kula neꞋeri, ma nia ka leka ma ka sasia na fanoa nia laꞋu Ꞌi Hebron ana ano ba karangi ana ai doe ki Ꞌi Mamre. ꞋIu, ana kula neꞋeri, sa Abram ka Ꞌuia taꞋi sulufaua fuana foꞋosilana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Aia, ana kaidaꞋi neꞋeri, na fai tatalafaꞋa ana fai fanoa doe ki, kira fiku kwailiu fuana fuꞋanga. Na satada neꞋe sa Amrafel na tatalafaꞋa Ꞌi Babilon, sa Ariok na tatalafaꞋa Ꞌi Elasara, sa Kedolama na tatalafaꞋa Ꞌi Elam, ma sa Tidal na tatalafaꞋa Ꞌi Goem. ");
INSERT INTO kwf_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Na fai tatalafaꞋa neꞋe ki, kira leka maꞋi fuana fuꞋalilana lima tatalafaꞋa ki ana lima fanoa doe ki, neꞋe satada sa Bera na tatalafaꞋa Ꞌi Sodom, sa Birsa na tatalafaꞋa Ꞌi Gomora, sa Sinab na tatalafaꞋa Ꞌi Adma, sa Semeba na tatalafaꞋa Ꞌi Seboeim, ma tatalafaꞋa Ꞌi Bela neꞋe ta sata ana fanoa doe neꞋeri neꞋe Ꞌi Soa. ");
INSERT INTO kwf_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Na lima tatalafaꞋa neꞋeri ki, kira ngalia ngwae ni ofoꞋa kira ki, kira ka fiku maꞋi ana oteote Ꞌi Sidim. KaidaꞋi neꞋe na Asi Mae naꞋa neꞋe kurua kula neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Na lima tatalafaꞋa neꞋe ki, kira tua naꞋa sulia akwala ma ro faꞋi ngali Ꞌi olofana limana sa Kedolama na tatalafaꞋa. TaꞋi faꞋi ngali Ꞌi buri ana, na lima tatalafaꞋa ki kira taꞋe maꞋi ma kira ka fuꞋalia laꞋu na tatalafaꞋa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ma taꞋi faꞋi ngali Ꞌi buri ru neꞋeri, na tatalafaꞋa sa Kedolama faꞋinia ta uulu tatalafaꞋa neꞋe, kira kwaima, ma na ngwae ni ofoꞋa kira ki, kira leka maꞋi fuana fuꞋanga ana kula neꞋeri. Etaeta, na fai tatalafaꞋa kira leka maꞋi ana fanoa Ꞌi Astarot Kenaem, ma kika fuꞋa faꞋinia na ramo ki ana fuuꞋi ngwae sa Refaem, ma kira ka liufida. Ma Ꞌi buri, kira ka leka maꞋi ana fanoa Ꞌi Ham, ma kika fuꞋa faꞋinia fuuꞋi ngwae sa Susim, ma kira ka liufida logo. KaidaꞋi kira dao maꞋi saena oteotea Ꞌi Sabe Kiriataem, kira ka fuꞋa faꞋinia fuuꞋi ngwae sa Emin, ma kira ka liufida laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","KaidaꞋi kira leka maꞋi ana gwauna ua ki Ꞌi Idom, kira ka fuꞋa faꞋinia fuuꞋi ngwae sa Hori, ma kira ka liufida, ma kika lalida leleka ka dao ana fanoa Ꞌi Elparan karangia taꞋi kula ꞋeꞋeredeꞋa doe. ");
INSERT INTO kwf_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sui fai tatalafaꞋa neꞋeri ki kira ka oli Ꞌuana fanoa Ꞌi Kades neꞋe Ꞌi naꞋo maꞋi kira saea Ꞌania Ꞌi Enmispat. Ma kira ka dau fafia na ano neꞋe fuuꞋi ngwae Ꞌi Amalek. ꞋI buri Ꞌana kira ka leka laꞋu Ꞌuana fanoa Ꞌi Hasasontama, ma kira ka fuꞋa faꞋinia fuuꞋi ngwae sa Amoro neꞋe kira tua Ꞌi neꞋeri, ma kira ka liufida logo. Sui kira ka leka maꞋi ma kika fuꞋa faꞋinia na lima tatalafaꞋa neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sui na lima tatalafaꞋa neꞋeri ki, kira ka ngalia ngwae ni fuꞋanga kira ki, kika leka maꞋi ana ote Ꞌi Sidim, kira ka salisali masia fuꞋanga. Ma kira ka fuꞋa naꞋa ");
INSERT INTO kwf_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","faꞋinia fai tatalafaꞋa neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na ano ana oteotea neꞋeri nia ka matamata laꞋu ana sulia na kilu Ꞌoro ki neꞋe teo kwailiu ana neꞋe kira fungu Ꞌania moꞋa taꞋa. KaidaꞋi lima tatalafaꞋa neꞋeri ki kira talaꞋae fuana afirongwaꞋanga, kira ka tafi naꞋa faꞋasia fuꞋanga neꞋeri. ꞋIu na tatalafaꞋa Ꞌi Sodom ma tatalafaꞋa Ꞌi Gomora faꞋinia ngwae ni ofoꞋa kera ki kika tafi, bore ma kira Ꞌasida saena kilu neꞋeri ki. Bore ma ta uulu tatalafaꞋa faꞋinia ngwae ni ofoꞋa kira ki tafi, ma kika ago Ꞌi gwauna ua ki. ");
INSERT INTO kwf_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Aia na fai tatalafaꞋa neꞋeri ki kira leka saena ro fanoa doe Ꞌi Sodom ma Ꞌi Gomora, ma kira ka ngalia taꞋifau ru ki ana, faꞋinia fanga ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ana kaidaꞋi neꞋeri sa Lot neꞋe na ngela ngwaefuta sa Abram, nia tua Ꞌi Sodom, ma kira ka ngalia logo faꞋinia ru nia ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bore ma ta ngwae ana fanoa doe neꞋeri, nia tafi ma nia ka leka siana sa Abram, nia ngwae ana kwalafaꞋa sa Eba, ma nia ka faꞋarongoa Ꞌania ru ki taꞋifau fuana. KaidaꞋi neꞋeri sa Abram nia tua goꞋo Ꞌana ana fanoa nia karangia Ꞌai doe ki sa Mamre, na ngwae ana kwalafa sa Amoro. Sa Mamre neꞋe faꞋinia ro ngwaefuta nia ki sa Eskol ma sa Anere, kira uulu ngwae kwaima sa Abram ki, ma kira alangaꞋi faꞋinia fuana fikuꞋa faꞋinia kaidaꞋi ana ta fuꞋanga. ");
INSERT INTO kwf_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Sa Abram ka rongo faꞋarongoꞋa neꞋe fai tatalafaꞋa neꞋe ki kira daua naꞋa sa Lot ma kika ngalia ma kika leka faꞋinia, ꞋunaꞋeri nia ka saea maꞋi ngwae ni ofoꞋa ana kula neꞋeri kike fiku maꞋi, ma kira ka salisali masia fuꞋanga. NgwaꞋi toꞋa neꞋeri kira Ꞌoro ka dao ana 318 ngwae ana kiraꞋa taꞋifau. Ma kira ka leka Ꞌi buri ana fai tatalafaꞋa neꞋeri ki, leleka ka dao ana fanoa Ꞌi Dan, neꞋe nia tua tau liu Ꞌi Ꞌaena fanoa. ");
INSERT INTO kwf_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Saena rodo neꞋeri, sa Abram nia ka daroꞋia ngwae nia ki Ꞌania fiku taꞋi ngwae ki fuana fuꞋalilana na malimae neꞋeri ki, ma kira la liufida, ma kira ka lalia malimae kira ki leleka ka dao ana fanoa Ꞌi Hoba ana bali loꞋoko ana Ꞌi Damaskas. ");
INSERT INTO kwf_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ꞋIu sa Abram ka olitaꞋinia ru ki taꞋifau neꞋe kira ngaliꞋi ki. Nia ka olitaꞋinia logo sa Lot faꞋinia ru nia toꞋo ani ki, faꞋinia ngwaꞋi kini ma faꞋinia ti ngwae neꞋe kira ngalida ki. ");
INSERT INTO kwf_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","KaidaꞋi sa Abram nia oli maꞋi faꞋasia fuꞋanga neꞋe nia liufia fai tatalafaꞋa ki, na tatalafaꞋa Ꞌi Sodom ka leka kwau masia ka kwaloa maꞋi ana oteote kira saea Ꞌania Ꞌi Sabe, ta sata laꞋu ana ote neꞋeri neꞋe na oteotea tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sui sa Melkisadek nia na tatalafaꞋa ana fanoa doe Ꞌi Salem ma nia ta fata abuꞋa laꞋu ana God neꞋe tasa ka liu, nia leka maꞋi ana kula neꞋeri, nia ka kwatea fanga ma waen fuana sa Abram. ");
INSERT INTO kwf_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma nia ka faꞋaleꞋa sa Abram, ma ka fata Ꞌuri, “Abram, God neꞋe tasa ka liu neꞋe nia saungaꞋinia mamanga ma ano nia ke baꞋa faꞋaleꞋa Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kulu tafea God neꞋe tasa ka liu. NiaꞋa kwaiꞋafi amu Ꞌoko liufia na malimae Ꞌoe ki ana fuꞋanga.” Sui sa Abram ka ngalia taꞋifau ru neꞋe nia ngaliꞋi maꞋi faꞋasia fai tatalafaꞋa neꞋe kiri, ma nia ka daroꞋia Ꞌania akwala kabu ru, ma nia ka kwate ta taꞋi kabu fuana sa Melkisadek na tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sui tatalafaꞋa Ꞌi Sodom ka fata Ꞌuri ana sa Abram, “Ru neꞋe ki taꞋifau niniꞋa Ꞌoko ngalia ana fai tatalafaꞋa neꞋe ki, Ꞌoko saiana Ꞌoke goniꞋi naꞋa fuamu. Bore ma ngwae nau ki goꞋo neꞋe, Ꞌoke olitaꞋinida maꞋi fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bore ma sa Abram ka fata Ꞌuri ana, “ꞋI maana God Iawe neꞋe tasa ka liu neꞋe nia saungaꞋinia na mamanga, ma ano, nau ku sasia taꞋi alangaꞋi Ꞌato Ꞌania satana, ");
INSERT INTO kwf_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nau noaꞋa naisi dau fafia ta ru ana ru Ꞌoe ki. Ta Ꞌaba dadalo Ꞌua fuana firiꞋilana butu Ꞌoe ki, niꞋi ke baꞋa oli nama fuamu, Ꞌasu Ꞌubani Ꞌoe koto fata Ꞌuri aku ana ta kaidaꞋi, ‘NauꞋa goꞋo neꞋe nau ku faꞋatoꞋoru sa Abram.’ ");
INSERT INTO kwf_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","NoaꞋa naisi gonia ta ru ana ru nini nau ku ngaliꞋi maꞋi fuaku ki. Na fanga neꞋe na ngwae nau ki kira aniꞋi ka sui goꞋo ki neꞋe nau ku saeleꞋa aniꞋi. Bore ma uulu ngwae kwaima nini nau ki sa Anere, sa Eskol, ma sa Mamri, neꞋe kira fiku faꞋinau fuana fuꞋanga, kira goꞋo neꞋe nia leꞋa fuana Ꞌoke alaꞋania kira ke lafua kabu kira ki faꞋasia ru neꞋana ki.” ");
INSERT INTO kwf_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Buri Ꞌana kaidaꞋi neꞋeri Iawe ka fata faꞋinia sa Abram saena taꞋi maliu boleꞋa ka fata Ꞌuri ana, “Abram kwa! NoaꞋa Ꞌoe kosi maꞋu. Nai baꞋa liaꞋa leꞋa suliꞋo Ꞌasu Ꞌubani ta ru taꞋa ka fiꞋi faꞋali Ꞌoe. Ma nai baꞋa kwaiara Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bore ma sa Abram ka fata Ꞌuri, “God kwa! ꞋAeꞋo Iawe, faꞋuta neꞋe Ꞌoko oga kwaiaralaku? Nau ku Ꞌiri toꞋo ana ta ngela neꞋe ke baꞋa ngalia fuliku ma ka ngalia ru neꞋe nau ku toꞋo ani ki. Na ngwae rao ꞋoꞋo neꞋe sa Eliesa na ngwae Ꞌi Damaskas goꞋo neꞋe ke baꞋa ngalia fuliku kaidaꞋi nai mae ana. ");
INSERT INTO kwf_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","NoaꞋa Ꞌoko Ꞌiri kwatea ta ngela fuaku. Ma kaidaꞋi nau ku mae, na ngwae rao ꞋoꞋo neꞋe goꞋo neꞋe ke baꞋa ngalia na ano nini nau ki faꞋinia ru nau ku toꞋo ani ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Sui nia ka rongoa laꞋu neꞋe Iawe fata Ꞌuri ana, “Na ngwae rao ꞋoꞋo neꞋana noaꞋa kasi ngalia taꞋifau ru Ꞌoko toꞋo ani ki, taꞋi ngela mamana Ꞌoe naꞋa talamu neꞋe ke baꞋa futa amu, nia naꞋa neꞋe ke baꞋa ngalia fulimu.” ");
INSERT INTO kwf_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Buri Ꞌana, Iawe ka ngalia sa Abram ka leka Ꞌi maa, ma nia ka fata Ꞌuri ana, “ꞋOke lia alaꞋa saena mamanga kwa! Ma Ꞌoko ili Ꞌuana toꞋolana bulubulu loeri ki. ꞋOko fia Ꞌoko saiana toꞋolada leleka ka sui kwa? Sali nia noaꞋa ne! Nau ku saea fuamu, na ngela neꞋe ke baꞋa futa maꞋi ana kwalafa Ꞌoe, kike baꞋa Ꞌoro liu diꞋia na bulubuluna salo loeri.” ");
INSERT INTO kwf_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Sa Abram nia faꞋamamana Iawe, ma osiꞋana neꞋe nia faꞋamamana ꞋunaꞋeri, Iawe ka lisia nia na ngwae ꞋoloꞋolo. ");
INSERT INTO kwf_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Aia Iawe ka fata Ꞌuri ana, “NauꞋa naꞋa neꞋe Iawe, nau ku talaꞋiꞋo maꞋi faꞋasia fanoa doe Ꞌi Ur ana Ꞌi Kaldia, Ꞌiri Ꞌoke leka maꞋi ana kula neꞋe fasi Ꞌiri nai kwatea ano neꞋe ki na ru Ꞌoe ki.” ");
INSERT INTO kwf_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bore ma sa Abram ka lidi Ꞌuri ana, “God kwa! ꞋUri ma nai baꞋa sai faꞋuta ana neꞋe ano neꞋe ru nau?” ");
INSERT INTO kwf_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ma Iawe nia ka fata Ꞌuri ana, “Leka Ꞌoko ngalia maꞋi ta taꞋi buluka, ma ta taꞋi nanigot, ma ta taꞋi sipsip ngwane neꞋe kira tua naꞋa sulia uulu faꞋi ngali ki. Ma Ꞌoko ngalia maꞋi ta taꞋi bola ma ta taꞋi faꞋi fao fiꞋi doe, Ꞌoke ngalida maꞋi siaku.” ");
INSERT INTO kwf_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ꞋIu ma sa Abram nia ka leka ma ka ngali taꞋifau maꞋi ana ru neꞋeri ki fuana Iawe. Ma nia ka saungida ka mae, ma nia ka kakasia na uulu ru ꞋaeꞋaela neꞋeri ki Ꞌania ro balibali ruꞋa, ma nia ka aluda Ꞌania ro tatalaꞋi ru ki, neꞋe ta taꞋi balibali ru ana ru ꞋaeꞋaela neꞋeri ki nia tua taꞋi bali, ma ta balibali ru ai ka tua ana ta bali. Bore ma ro faꞋi noꞋo neꞋeri ki, nia Ꞌiri kakasi kera. ");
INSERT INTO kwf_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na faꞋi noꞋo doe neꞋe kira tua fuana Ꞌanilana noni ru mae ki, kira leka maꞋi, bore ma sa Abram ka lalida. ");
INSERT INTO kwf_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","KaidaꞋi sina nia talaꞋae ka kuru naꞋa, sa Abram ka maliu liu naꞋa diꞋia naꞋa ta ngwae mae, ma nia ka maliu bolea, nia lisia taꞋi maꞋerodo doe nia leka maꞋi ma ka suꞋu fafia, ma nia ka maꞋu liu. ");
INSERT INTO kwf_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Sui Iawe ka fata Ꞌuri fuana, “Na ngela Ꞌoe ki neꞋe kira ke baꞋa saka maꞋi burimu, kike baꞋa leka tua ana ta kula matamata neꞋe kira ke baꞋa diꞋia ngwae kwaita ki ana kula neꞋeri. ꞋIu kira ke baꞋa rao ꞋoꞋo goꞋo fuana ngwae ki ana kula neꞋeri, ma ngwae ana na kula neꞋeri kira ke baꞋa faꞋakaisida liu naꞋa leleka na fai talangaꞋi fai ngali ki ka sui, ");
INSERT INTO kwf_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","bore ma nai baꞋa nangasia ngwaꞋi toꞋa neꞋe kira ke faꞋakaisi kamu. Ma kaidaꞋi ngela Ꞌoe ki ke baꞋa faꞋasia fanoa neꞋeri kira ke baꞋa ngalia ru Ꞌoro leꞋa ana fanoa neꞋeri faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma ꞋaeꞋo sa Abram, Ꞌoke baꞋa mauri tau, leleka ka dao ana kaidaꞋi neꞋe Ꞌoko ngwaro ko kokoꞋo naꞋa, ma Ꞌoke fiꞋi mae Ꞌani aroaroꞋa ma kira ke baꞋa kwaiato leꞋa amu. ");
INSERT INTO kwf_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bore ma ngelamu neꞋe kira ke futa maꞋi ana kwalafa Ꞌoe, kike baꞋa tua ana ta fanoa matamata sulia kaidaꞋi tau, sui mala fuuꞋi ngwae Ꞌoe fiꞋi oli laꞋu maꞋi ana ano neꞋe. NoaꞋa naisi baꞋa lalia basi fuuꞋi ngwae sa Amoro neꞋe kira tua Ꞌi Kenan ana kaidaꞋi neꞋe, leleka ka dao ana kaidaꞋi neꞋe na falafala kira ki ke taꞋa liu mala. Ana kaidaꞋi neꞋeri mala neꞋe nai fiꞋi nangasida, ma nau ku fiꞋi lalida faꞋasia fanoa neꞋe, sui mala ngela neꞋe futa ana kwalafa Ꞌoe ki, kira ka fiꞋi oli laꞋu maꞋi ana kula neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Aia kaidaꞋi neꞋe sina nia kuru ka sui naꞋa ma kula neꞋeri ka maꞋerodoꞋa naꞋa, tona bore sa Abram nia lisia taꞋi fai tini nia fungu naꞋa ana mafula neꞋe sasuna nia sasu maꞋi faꞋasia, ma taꞋi bobo raꞋi Ꞌai neꞋe mafula dua ka doe ana. ꞋIu na ro ru neꞋeri ki kera leka Ꞌi safitana Ꞌania ro tatalaꞋi ru ꞋaeꞋaela ba kiri. ");
INSERT INTO kwf_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ma ana asoa neꞋeri nama Iawe ka sasia fau alangaꞋinga faꞋinia sa Abram, ma nia ka fata Ꞌuri, “Nai baꞋa kwatea na ano neꞋe ki fuana fuuꞋi ngwae Ꞌoe neꞋe kira futa olitamu. Na ano neꞋe nia Ꞌita ana kafo tiꞋitiꞋi neꞋe ana gwauna fanoa, neꞋe maꞋetoto ano ngwaꞋi toꞋa Ꞌi Ejipt, leleka ka dao ana kafo Ꞌi Iufretes ana Ꞌaena fanoa. ");
INSERT INTO kwf_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Na ngwaꞋi toꞋa neꞋe kira tua Ꞌua ana ano neꞋeri ki ana kaidaꞋi neꞋe, kira ana fuuꞋi ngwae sa Ken, olitana sa Kenis, olitana sa Kadmon, olitana sa Het, olitana sa Peris, olitana sa Refaem, olitana sa Amoro, olitana sa Kenan, olitana sa Gigas, ma olitana sa Jebus.” ");
INSERT INTO kwf_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Aia nia leleka maꞋi ka dao ana kaidaꞋi neꞋe Ꞌi Serae, na Ꞌafe sa Abram, nia noaꞋa kasi toꞋo ana ta ngela. Bore ma nia toꞋo ana taꞋi kini rao ꞋoꞋo, nia kini Ꞌi Ejipt, ma satana neꞋe Ꞌi Hega. ");
INSERT INTO kwf_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","GoꞋo Ꞌi Serae ka saea fuana sa Abram ka Ꞌuri, “Nia leleka maꞋi ka dao naꞋa Ꞌuri, Iawe nia lui nau noaꞋa naisi alu ngela. Nau ku fia ru neꞋe leꞋa, Ꞌoke leka teo goꞋo faꞋinia kini rao ꞋoꞋo nau, sali nia saiana ke alua ta ngela fuaku.” Ma sa Abram ka alafafia alaꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ma kira tua naꞋa sulia akwala faꞋi ngali ka sui naꞋa Ꞌi Kenan, kaidaꞋi Ꞌi Serae nia saea fuana araꞋi nia sa Abram ka ngali Ꞌi Hega. ");
INSERT INTO kwf_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aia ma sa Abram ka teo naꞋa faꞋinia Ꞌi Hega leleka ma nia ka ina naꞋa. Ma kaidaꞋi nia saiana neꞋe nia ina ka sui naꞋa, na manata ka lafua liua naꞋa, ma nia ka inaꞋu ana lia fafilana Ꞌi Serae. ");
INSERT INTO kwf_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ꞋUnaꞋeri Ꞌi Serae ka fata Ꞌuri fuana sa Abram, “Na kini neꞋe na gwauna taꞋa liu naꞋa aku, ma ꞋaeꞋo naꞋa niniꞋa Ꞌoko sasia ru neꞋe. Nau ku kwatea maꞋi ka Ꞌafe Ꞌoe, bore ma kaidaꞋi nia saiana neꞋe nia ina naꞋa, nia lafe liu naꞋa, ma kaidaꞋi Ꞌoro ki goꞋo neꞋe nia lia toli goꞋo Ꞌana ana nauꞋa. Ru neꞋe nia kasi leꞋa. Nau ku oga Iawe ka matalangaꞋi koro fasi Ꞌiri ke faꞋataꞋi koro sa taꞋi neꞋe saga akoro.” ");
INSERT INTO kwf_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma sa Abram ka fata Ꞌuri ana, “Aia, nia leꞋa goꞋo Ꞌana, kini rao ꞋoꞋo neꞋe nia ru Ꞌoe niniꞋa, ma nia ka tua goꞋo Ꞌi olofana limamu. ꞋOko saiana Ꞌoke sasia goꞋo Ꞌamu ta ru ana niaꞋa neꞋe Ꞌoko oga.” Aia ma Ꞌi Serae ka tua naꞋa fuana faꞋalagalana Ꞌi Hega, ma leleka Ꞌi Hega ka tafi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma nia ka leka tua naꞋa Ꞌana ana taꞋi kula ꞋeꞋeredeꞋa Ꞌi ninimana taꞋi mae kafo busu neꞋe teo Ꞌi ninimana tala neꞋe leka Ꞌuana Ꞌi Suru ana gwauna fanoa. Ma na Ꞌainsel Iawe nia leka maꞋi ma ka lisia ana kula neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ma nia ka saefilo Ꞌuri ana, “Hega kwa! ꞋOko talaꞋae ko leka maꞋi faꞋasia Ꞌi faꞋi niniꞋa? Ma Ꞌoke leka Ꞌi faꞋi niniꞋa? ꞋAeꞋo niniꞋa na kini rao ꞋoꞋo ba Ꞌi Serae niniꞋa!” Ma Ꞌi Hega ka fata Ꞌuri, “Nau ku tafi maꞋi faꞋasia kini ꞋaꞋana nau Ꞌi Serae niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma Ꞌainsel neꞋeri nia ka fata Ꞌuri ana, “ꞋOke oli nama fuana Ꞌi Serae, ma Ꞌoko roꞋo nama sulia fatalana laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ma na Ꞌainsel neꞋeri ka fata laꞋu Ꞌuri fuana, “Na ngela neꞋe ke baꞋa futa maꞋi amu ki, nai baꞋa kwateda kira ke Ꞌoro liu, ma noaꞋa ta ngwae kasi bolo faꞋinia toꞋolada. ");
INSERT INTO kwf_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ana kaidaꞋi neꞋe, Ꞌoko ina naꞋa, ma Ꞌoke baꞋa faꞋafuta taꞋi ngela ngwane. Ma Ꞌoke baꞋa faꞋasata nama Ꞌania sa Ishmael, duꞋungana Ꞌoko nonifii liu naꞋa, ma Ꞌoko angi maana Iawe, ma nia ka rongo Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bore ma ngela nari Ꞌoe nia ke baꞋa diꞋia ta dongki kwasi neꞋe nia donga manataꞋanga nia ki talana. Ma nia ke baꞋa fuꞋalia ngwae ki ma ngwae ki taꞋifau kike baꞋa fuꞋalia. Nia ke baꞋa tua tau taꞋifilia faꞋasia luꞋuluꞋua nia.” ");
INSERT INTO kwf_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Sui Ꞌi Hega ka manata Ꞌana Ꞌuri talana, “Reala kwa! Nau ku lisia naꞋa Iawe neꞋe nia lisi nau ma nia lia sulia nau.” ꞋUnaꞋeri Ꞌi Hega nia ka kwatea ta sata laꞋu fuana Iawe, sata neꞋeri Ꞌuri, “El Roe” fadalana neꞋe Ꞌuri, “God nia lisi nau ma nia lia sulia nau.” ");
INSERT INTO kwf_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ꞋUnaꞋeri neꞋe ka talaꞋae maꞋi ana kaidaꞋi neꞋeri leleka ka dao Ꞌi taꞋena, na ngwae ki kira ka saea na maꞋe kafo busu neꞋe nia Ꞌi safitana ro fanoa doe neꞋeri ki Ꞌi Kades ma Ꞌi Bered Ꞌania Ꞌi “Bere Lahai Roe” fadalana neꞋe “ꞋI maꞋe busu na God niniꞋa nia mauri, ma niniꞋa nia ka lisi nau maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Sui Ꞌi buri Ꞌana Ꞌi Hega nia ka faꞋafuta taꞋi ngela ngwane neꞋe maꞋa nia nama neꞋe sa Abram, ma sa Abram ka faꞋasata Ꞌania sa Ishmael. ");
INSERT INTO kwf_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ana kaidaꞋi neꞋeri sa Abram nia tua naꞋa sulia na kwalu akwala faꞋi ngali ma ono faꞋi ngali. ");
INSERT INTO kwf_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aia sa Abram nia dao naꞋa ana siko akwala ma siko faꞋi ngali, Iawe nia leka maꞋi ma ka fata Ꞌuri fuana, “NauꞋa naꞋa neꞋe God neꞋe nau ku toꞋo ana ngasingasiꞋanga ki taꞋifau. ꞋOke roꞋo nama suli nau, ma Ꞌoke sasia nama na ru ꞋoloꞋolo ki, fasi Ꞌiri ");
INSERT INTO kwf_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","nai baꞋa sasia na fau alangaꞋinga faꞋiniꞋo, ma nai baꞋa kwatea ngela ki neꞋe kira ke futa maꞋi ana kwalafa Ꞌoe kike baꞋa Ꞌoro liu.” ");
INSERT INTO kwf_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Sui sa Abram nia ka Ꞌoto gwau toli leleka na maana ka toꞋo toꞋona ano. Ma God ka fata Ꞌuri fuana, ");
INSERT INTO kwf_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Bali nau ana fau alangaꞋinga nini nai baꞋa sasia faꞋiniꞋo nia Ꞌuri: Nau ku alangaꞋi fuamu, Ꞌoke toꞋo ana kwalafa Ꞌoro, ma kira ke baꞋa tatakolaꞋa ka alu fuuꞋi ngwae Ꞌoro liu ki. ");
INSERT INTO kwf_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","NoaꞋa kira kasi baꞋa saeꞋo naꞋa Ꞌania sa Abram. Nia eta ana kaidaꞋi neꞋe ka oli alaꞋa, na satamu sa Abraham, osiꞋana nau ku sasia Ꞌoko koꞋo bora ana fuuꞋi ngwae Ꞌoro liu ki. ");
INSERT INTO kwf_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nai baꞋa kwatea Ꞌoke toꞋo ana ngela Ꞌoro, ma kira ke baꞋa tatakolaꞋa ka alu fuuꞋi ngwae Ꞌoro liu ki, ma ti ai ada kike baꞋa tatalafaꞋa ana kula kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Na fau alangaꞋinga nini nau ku sasia faꞋiniꞋo ana kaidaꞋi neꞋe, nia ke baꞋa teo tari faꞋiniꞋo ma faꞋinia ngela neꞋe kike baꞋa futa maꞋi ana kwalafa Ꞌoe. NauꞋa naꞋa neꞋe God Ꞌoke foꞋosia. Ma nauꞋa naꞋa neꞋe God na ngelamu neꞋe kike baꞋa futa maꞋi ana kwalafa Ꞌoe, kira ke foꞋosia logo. ");
INSERT INTO kwf_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","KaidaꞋi neꞋe kamu tua ana ano neꞋe, diꞋia goꞋo amuꞋa ta ngwae kwaita, bore ma nai kwate naꞋa ano neꞋe fuamu faꞋinia ngelamu neꞋe kira futa maꞋi ana kwalafa Ꞌoe. Na ano neꞋe ki ru kwalafa sa Kenan ki, niꞋi ke baꞋa ru kamu ki naꞋa. Ma kamu ke baꞋa toꞋo naꞋa ana ano neꞋe sulia kaidaꞋi firi, ma nauꞋa naꞋa neꞋe God kamu ke foꞋosia.” ");
INSERT INTO kwf_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","11","Sui God ka fata laꞋu Ꞌuri fuana, “Bali Ꞌoe ana fau alangaꞋinga nini nia Ꞌuri: ꞋAeꞋo faꞋinia ngwae neꞋe kira ke baꞋa futa maꞋi ana kwalafa Ꞌoe, kamu alangaꞋi ke roꞋo sulia nau. Na toto neꞋe faꞋataꞋinia kamu dauꞋa sulia alangaꞋinga kamu nia Ꞌuri: KamuꞋa ngwangwane ki taꞋifau kamu ke Ꞌolo faꞋataꞋinia nama. ");
INSERT INTO kwf_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","TalaꞋae naꞋa ana kaidaꞋi neꞋe kamu ke Ꞌolo faꞋataꞋinia ana ngela ngwane tiꞋitiꞋi neꞋe kira futa maꞋi ana kwalafa Ꞌoe, neꞋe nia futa ka tua sulia kwalu asoa ki. Ma kamu ke Ꞌolo faꞋataꞋinia logo na ngwae rao ꞋoꞋo kamu ki neꞋe kamu folida maꞋi ana ngwae kwaita ki. ");
INSERT INTO kwf_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ngwae ki taꞋifau neꞋe kira tua faꞋi kamu, kamu ke Ꞌolo faꞋataꞋinia nama. Na falafala neꞋeri na toto neꞋe nia faꞋataꞋi firi ana na alangaꞋinga nau ku sasia faꞋi kamu, nia kasi baꞋa sui. ");
INSERT INTO kwf_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ta ngwae neꞋe nia noaꞋa kasi Ꞌolo faꞋataꞋinia, noaꞋa naisi baꞋa lia saiana neꞋe nia ta ngwae ana ngwae nau ki, osiꞋana nia kasi dau sulia na bali nia ana alangaꞋinga nini nau ku sasia ka sui naꞋa maꞋi faꞋi kamu.” ");
INSERT INTO kwf_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God nia ka fata laꞋu Ꞌuri, “Eta Ꞌi taꞋena, Ꞌoe kosi saea naꞋa Ꞌafe Ꞌoe Ꞌania Ꞌi Serae. KaidaꞋi neꞋe satana Ꞌi Sera naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nai baꞋa faꞋaleꞋa nia ma nia ke baꞋa faꞋafuta taꞋi ngela ngwane fuamu. Ma osiꞋana neꞋe nau ku faꞋaleꞋa nia Ꞌi Sera, nai kwatea nia ke baꞋa teꞋa fuana ngwae ana fuuꞋi ngwae Ꞌoro ki. Ma na tatalafaꞋa ki ke saka maꞋi faꞋasida.” ");
INSERT INTO kwf_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Sui sa Abraham ka Ꞌoto gwau toli leleka maana ka toꞋo toꞋona ano, bore ma nia talaꞋae ka gaꞋa lala kaidaꞋi nia manata Ꞌuri, “Reala kwa! ꞋAfitaꞋi liu ta ngwaeꞋa neꞋe tua sulia 100 faꞋi ngali ka alua ta ngela. Ma Ꞌi Sera bore nia ka siko akwala faꞋi ngali naꞋa ana, nia bore noaꞋa kasi bolo naꞋa faꞋinia alu ngelaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Sui sa Abraham ka saefilo Ꞌuri ana God, “FaꞋuta, diꞋia nau ku mae, ꞋaeꞋo alaꞋania neꞋe sa Ishmael ke ngali ru ki taꞋifau neꞋe Ꞌoke kwateꞋe fuaku?” ");
INSERT INTO kwf_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bore ma God nia fata Ꞌuri, “NoaꞋa kasi Ꞌuira laꞋu! Na Ꞌafe Ꞌoe Ꞌi Sera ke baꞋa faꞋafuta taꞋi ngela ngwane, ma Ꞌoke baꞋa saea Ꞌania sa Aesak. Nai baꞋa dau sulia na fau alangaꞋinga nau faꞋinia, ma faꞋinia kwalafa nia. Na fau alangaꞋinga nari nau, nia noaꞋa kasi baꞋa sui. ");
INSERT INTO kwf_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nau ku rongoa naꞋa na tae neꞋe Ꞌoko saefiloa fuana sa Ishmael, nai baꞋa faꞋaleꞋa, fasi Ꞌiri nia ke toꞋo ana ngela Ꞌoro, ma ngela Ꞌoro laꞋu ke baꞋa futa ana kwalafa nia. Nia ke baꞋa maꞋa fuana na akwala ma ro ngwae ꞋaꞋana, ma nai baꞋa kwatea kwalafa nia ke alu ta fuuꞋi ngwae doe liu. ");
INSERT INTO kwf_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bore ma nai baꞋa dau sulia na fau alangaꞋinga nau faꞋinia ngela Ꞌoe sa Aesak neꞋe Ꞌi Sera ke baꞋa alua ana kaidaꞋi Ꞌuri nama ana faꞋi ngali loeri maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","KaidaꞋi God nia alaꞋa faꞋinia sa Abraham ka sui, nia ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","24","Ana faꞋi asoa neꞋeri, sa Abraham ka sasi naꞋa diꞋia neꞋe God nia saea fuana. Sa Abraham ma ngela nia sa Ishmael, faꞋinia ngwae ki taꞋifau neꞋe kira tua faꞋinia, kira ka Ꞌolo faꞋataꞋinia naꞋa. Na ngwae neꞋe futa saena luma nia, ma ngwae rao ꞋoꞋo nia ki taꞋifau neꞋe nia folida, kira bore kira Ꞌolo faꞋataꞋinia naꞋa taꞋifau logo. Ana kaidaꞋi neꞋeri nia dao naꞋa ana siko akwala ma siko faꞋi ngali ana. ");
INSERT INTO kwf_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ma na ngela nia sa Ishmael ka dao naꞋa ana akwala ma uulu faꞋi ngali. ");
INSERT INTO kwf_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sa Abraham faꞋinia sa Ishmael keroꞋa ka Ꞌolo faꞋataꞋinia ana taꞋi asoa neꞋeri nama, ");
INSERT INTO kwf_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","faꞋinia ngwae neꞋe futa saena luma nia ki ma na ngwae kwaita ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Iawe nia leka laꞋu maꞋi saena sa Abraham karangia ana ai doe ki Ꞌi Mamre. Ana taꞋi kaidaꞋi saena tofongana asoa, kaidaꞋi sina nia ꞋakoꞋako liu, sa Abraham nia tua Ꞌana maana sinamaa ana babala nia. ");
INSERT INTO kwf_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Nia lia kwau, nia ka lisia na uulu ngwae ki, kira uu goꞋo ada ana Ꞌi maana. KaidaꞋi nia lisia na uulu ngwae neꞋeri ki, nia tataꞋe ꞋaliꞋali, ma ka leka saka fuana na uulu ngwae neꞋeri ki. Ma kaidaꞋi nia dao karangida, nia ka Ꞌoto gwau toli leleka maana ka toꞋo toꞋona ano, ");
INSERT INTO kwf_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","sui nia ka fata Ꞌuri, “Uulu ngwae neꞋe ki, nia leꞋa liu mala neꞋe kaumulu leka maꞋi muka dao ana fanoa nau. Reala Ꞌae, noaꞋa kamu kasi liu daofaꞋi liu, mulu leka muka mango tiꞋitiꞋi basi faꞋi kaimili. Nau ku saeleꞋa liu mala fuana ꞋafilamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nai baꞋa leka ngalia maꞋi kala kafo fasi Ꞌiri muke taufia ꞋaemuꞋa. Kamu saiana muke mango tiꞋitiꞋi basi Ꞌi nununa Ꞌai neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","KaidaꞋi neꞋe nai leka ngalia basi maꞋi ta kala fanga fuaumulu Ꞌiri muke faꞋangasi basi Ꞌania fuana lekaꞋa. Nia leꞋa liu mala neꞋe kamu leka maꞋi muka dao Ꞌi fanoa kami Ꞌuri, ma nau ku saeleꞋa liu mala fuana Ꞌafilaumulu.” Sui uulu ngwae neꞋeri ki kira ka fata Ꞌuri, “BaꞋafakuꞋa liu, kaimili saeleꞋa liu mala fuana neꞋe Ꞌoko sasi Ꞌuira.” ");
INSERT INTO kwf_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Sui sa Abraham ka lima lakolako ka leka ruꞋu saena babala nia, ma ka Ꞌuri ana Ꞌi Sera, “ꞋAliꞋali! Leka ngalia maꞋi ta kala buta flaoa leꞋa mala ma Ꞌoko sasia maꞋi ta kala afu beret.” ");
INSERT INTO kwf_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma nia ka lalili ana kula neꞋe na buluka nia ki tua ana, ma nia ka efoa mala taꞋi bibi buluka kubu leꞋa. Sui nia ka saea fuana taꞋi ngwae ni rao nia ka ꞋaliꞋali ka saungia ka mae, ma ka salisali ana ti fasi buluka fuana uulu ngwae neꞋeri ki, kira ke ꞋaniꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ma kaidaꞋi fanga ki duꞋa naꞋa, nia ka ngalia ti meleke ma ti krim faꞋinia fanga neꞋeri ki, ma ka ngalia fuana uulu ngwae neꞋeri ki, Ꞌi Ꞌaena Ꞌai neꞋe kira tua ana, ma nia ka alua fanga ki Ꞌi naꞋoda. KaidaꞋi neꞋe kira fanga Ꞌada, nia ka lia sulida. ");
INSERT INTO kwf_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ma uulu ngwae neꞋeri ki kira ka lidi Ꞌuri ana sa Abraham, “FaꞋuta na Ꞌafe Ꞌoe Ꞌi Sera nia mo Ꞌi faꞋi?” Ma nia ka fata Ꞌuri, “Nia tua goꞋo Ꞌana saena babala loꞋoba.” ");
INSERT INTO kwf_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","TaꞋi ngwae adulu ana uulu ngwae neꞋeri ki ka fata Ꞌuri fuana sa Abraham, “Ana faꞋi ngali loeri maꞋi, ana madamo neꞋe logo, nai baꞋa oli maꞋi, kui lisi kamu laꞋu, ma ana kaidaꞋi neꞋeri Ꞌafe Ꞌoe ke baꞋa faꞋafuta taꞋi ngela ngwane.” ꞋIu Ꞌi Sera nia tua Ꞌi buri ana sa Abraham, Ꞌi saena na babala karangi na sinamaa, ma nia rongoa alaꞋanga neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ma ana kaidaꞋi neꞋeri, sa Abraham ma Ꞌi Sera kera ngwaro naꞋa, ma Ꞌi Sera noaꞋa kasi toꞋo naꞋa ana mataꞋinga kini ki. ");
INSERT INTO kwf_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ma nia ka tua ka manata ana Ꞌuri, “Nau ku ngwaro ka sui naꞋa. ꞋAfitaꞋi liu nai baꞋa saeleꞋanga sulia alua ta ngela. Ma araꞋi nau bore nia ka ngwaro ka sui naꞋa.” Sui na liana ka gaꞋagaꞋala Ꞌana talana. ");
INSERT INTO kwf_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","GoꞋo Iawe ka fata Ꞌuri ana sa Abraham, “FaꞋuta neꞋe Ꞌi Sera ka gaꞋa? FaꞋuta neꞋe nia ka saea neꞋe nia ngwaro ka sui naꞋa, ma nia noaꞋa kasi bolo neꞋe nia ke faꞋafuta ta ngela? ");
INSERT INTO kwf_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","NauꞋa naꞋa neꞋe Iawe. NoaꞋa goꞋo ta ru kasi ꞋafitaꞋi fuana Iawe ka sasia. FaꞋi ngali loeri, nai baꞋa oli laꞋu maꞋi kui lisi kamu laꞋu, ma ana kaidaꞋi neꞋeri Ꞌi Sera ke baꞋa toꞋo naꞋa ana taꞋi ngela ngwane.” ");
INSERT INTO kwf_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ꞋI neꞋeri Ꞌi Sera ka maꞋu liu, ma nia ka Ꞌoso ka Ꞌuri, “Nau noaꞋa kusi gaꞋa goꞋo ba.” Bore ma Iawe nia fata Ꞌuri, “NoaꞋa, Ꞌoko gaꞋa ba!” ");
INSERT INTO kwf_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","KaidaꞋi uulu ngwae baera kira fanga ka sui, kira ka leka Ꞌuana fanoa doe Ꞌi Sodom. Ma kaidaꞋi uulu ngwae neꞋeri ki kira leka, sa Abraham leka logo faꞋinida fuana faꞋasilana uulu ngwae neꞋeri ki saena taꞋi tala. ");
INSERT INTO kwf_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma kaidaꞋi kira leka goꞋo Ꞌada, Iawe nia manata Ꞌuri, “Ru niniꞋa nai baꞋa sasiꞋi ki, noaꞋa naisi sofongaꞋinida faꞋasia sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Na ngela neꞋe kike baꞋa futa maꞋi ana kwalafa nia ki, kike baꞋa Ꞌoro liu mala, ma kira ke alua fuuꞋi ngwae ngasingasiꞋa. Ma nai baꞋa rao Ꞌania ngwae neꞋe fuana faꞋaleꞋalana fuuꞋi ngwae ki taꞋifau ana magalia nege. ");
INSERT INTO kwf_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nai kwatea ma nia ke faꞋamanata ngela nia ki, ma ngwaꞋi toꞋa neꞋe kike baꞋa futa maꞋi ana kwalafa nia ki, fasi Ꞌiri kike roꞋosuli nau, ma kira ke sasi sulia falafala saga, ma ka leꞋa ki. Ma si diꞋia kira sasi ꞋunaꞋeri, nai baꞋa sasia ru ki taꞋifau neꞋe nau ku fata alangaꞋiniꞋi ka sui naꞋa fuana.” ");
INSERT INTO kwf_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Sui Iawe ka fata Ꞌuri fuana sa Abramham, “Nau ku sai naꞋa ana ru taꞋa ki neꞋe ngwaꞋi toꞋa Ꞌi Sodom ma Ꞌi Gomora kira fuliꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nia taꞋa ka tasa, ma nia kwate ma nau kui koso nama toli ana ro fanoa doe neꞋe ki fasi Ꞌiri nai dao toꞋoni niꞋi mamana nama ka noaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Sui, ro ngwae ka liu dao faꞋi liu Ꞌuana Ꞌi Sodom. Bore ma Iawe nia tua buri faꞋinia sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Sui sa Abraham ka leka karangi ana Iawe, ma ka saefilo Ꞌuri ana, “FaꞋuta kwa, Ꞌuri ma Ꞌoke baꞋa saungia logo ngwae leꞋa ki faꞋinia ngwae taꞋa ki? ");
INSERT INTO kwf_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Si diꞋia Ꞌoko dao toꞋona na lima akwala ngwae leꞋa ki kira tua goꞋo Ꞌada Ꞌi Sodom, Ꞌoke baꞋa alaꞋania ngwae ki taꞋifau ana fanoa doe fuiri kike mauri osiꞋana lima akwala ngwae leꞋa neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nau ku fia, noaꞋa Ꞌoe kosi malangisia kiraꞋa taꞋifau ꞋunaꞋeri. Si diꞋia Ꞌoko malangisia fanoa doe neꞋe na ngwaꞋi toꞋa taꞋa ma ngwaꞋi toꞋa leꞋa kike mae taꞋifau goꞋo, sasiꞋa ꞋunaꞋeri noaꞋa laꞋu falafala Ꞌoe neꞋeriꞋa. NoaꞋa Ꞌoe kosi sasi bolo fuana ngwae taꞋa ki faꞋinia ngwae leꞋa ki. ꞋAeꞋo naꞋa neꞋe ngwae fuana na matalangaꞋilana na magalia, ma kwai matalangaꞋilamu fuana ngwae nia ka saga.” ");
INSERT INTO kwf_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ꞋUnaꞋeri Iawe ka fata Ꞌuri, “Si diꞋia nau ku dao toꞋona na lima akwala ngwae leꞋa ki kira tua goꞋo Ꞌada Ꞌi Sodom, nai baꞋa alaꞋania ngwae ki taꞋifau ana fanoa doe fuiri kike mauri osiꞋana lima akwala ngwae leꞋa neꞋeri ki.” ");
INSERT INTO kwf_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Sui sa Abraham ka fata laꞋu Ꞌuri, “Iawe Ꞌae, Ꞌoe kosi manata suli nau neꞋe nauꞋa na ngwae goꞋo, nau ku uu Ꞌi naꞋomu fuana fataꞋa sulia ru neꞋe. Nau ku saiana neꞋe nau ku Ꞌiri toꞋo ana ta ngasingasiꞋanga fuana alaꞋanga Ꞌuri. ");
INSERT INTO kwf_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Bore ma, si diꞋia Ꞌoe noaꞋa kosi dao ana ta lima akwala ngwae leꞋa ki, bore ma Ꞌoko dao goꞋo ana ta fai akwala ma lima ngwae goꞋo neꞋe tua, ta tae neꞋe Ꞌoke baꞋa sasia kwa! ꞋUri ma Ꞌoko saiana Ꞌoke baꞋa malangisia goꞋo Ꞌamu ngwae ki taꞋifau ana fanoa doe fuiri, osiꞋana neꞋe lima ngwae leꞋa ki kira olidoko?” Ma Iawe ka fata Ꞌuri, “Si diꞋia nau ku dao toꞋona fai akwala ma lima ngwae leꞋa kira tua goꞋo Ꞌada, nau noaꞋa kusi malangisia fanoa doe neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ꞋUnaꞋeri sa Abraham ka fata laꞋu Ꞌuri, “Sali ta fai akwala ngwae leꞋa ki goꞋo neꞋe kira tua.” Sui Iawe ka fata Ꞌuri, “Si diꞋia nau ku dao toꞋona ta fai akwala ngwae leꞋa ki neꞋe kira tua ana, noaꞋa naisi malangisia fanoa doe neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma sa Abraham ka fata laꞋu Ꞌuri, “Aofia Ꞌae, Ꞌoe kosi oga taꞋa fuaku, bore ma nai alaꞋa laꞋu ne. FaꞋuta kwa, si diꞋia ta uula akwala ngwae leꞋa ki goꞋo neꞋe kira tua, Ꞌuri ma Ꞌoke malangisia goꞋo Ꞌamu fanoa doe fuiri?” Ma Iawe ka fata Ꞌuri, “Si diꞋia neꞋe nau ku dao toꞋona neꞋe ta uulu akwala ngwae leꞋa ki neꞋe kira tua, noaꞋa naisi malangisia.” ");
INSERT INTO kwf_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Sui sa Abraham ka fata laꞋu Ꞌuri, “Aofia Ꞌae, Ꞌoe kosi fia laꞋu neꞋe nau ku manata lafu nau, kaidaꞋi nau ku alaꞋa faꞋiniꞋo Ꞌuri, faꞋuta si diꞋia ta ro akwala ngwae leꞋa ki goꞋo neꞋe kira tua?” Ma nia ka fata Ꞌuri, “Si diꞋia neꞋe nau ku dao toꞋona ta ro akwala ana ngwae leꞋa ki neꞋe kira tua, nau noaꞋa naisi malangisia.” ");
INSERT INTO kwf_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Sa Abraham ka fata laꞋu Ꞌuri, “Iawe Ꞌae, noaꞋa Ꞌoe kosi oga taꞋa, nia naꞋa ne na alaꞋanga isi nau, ma noaꞋa naisi baꞋa alaꞋa laꞋu. FaꞋuta kwa, si diꞋia ta taꞋi akwala ngwae leꞋa ki goꞋo neꞋe kira tua.” Ma Iawe ka Ꞌuri fuana, “Si diꞋia neꞋe nau ku dao toꞋona ta taꞋi akwala ngwae leꞋa ki neꞋe kira tua, nau noaꞋa naisi malangisia fanoa doe neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ma kaidaꞋi keroꞋa alaꞋa ka sui naꞋa, Iawe ka faꞋasia naꞋa sa Abraham, ma sa Abraham ka oli naꞋa Ꞌi fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ꞋUnaꞋeri ro ngwae neꞋeri ki kera ka leka naꞋa Ꞌuana Ꞌi Sodom, keraꞋa neꞋeriꞋa na ro Ꞌainsel ki, ma saꞋulafi naꞋa neꞋe kera dao ana fanoa neꞋeri. Ma sa Lot nia tua goꞋo Ꞌana karangia na maana maꞋe taꞋelo ana faꞋi labu ana fanoa doe neꞋeri. Ma kaidaꞋi nia lisidaroꞋo, nia tataꞋe ka leka kwa ka alaꞋa faꞋinidaroꞋo. Nia ka Ꞌoto gwau toli Ꞌi naꞋodaroꞋo leleka maana ka toꞋo toꞋona ano, ");
INSERT INTO kwf_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ma nia ka fata Ꞌuri, “Ro ngwae ꞋaꞋana moro leka maꞋi, kulu ke leka Ꞌi luma nau fasi Ꞌiri nai Ꞌafi amoro. KoroꞋo saiana moro ke taufia ꞋaemuroꞋo, ma koroꞋo ka maliu naꞋa Ꞌi neꞋe. Ma rorodo, koroꞋo ke baꞋa ada ꞋaliꞋali goꞋo Ꞌofodangi taꞋa, ma moro ka leka ꞋamuroꞋo ana lekaꞋa koroꞋo.” Bore ma ro ngwae neꞋeri, kera ka fata Ꞌuri, “NoaꞋa, nia leꞋa goꞋo Ꞌana. KeroꞋo ke baꞋa leka maliu saena labata ana maꞋe taꞋelo ana faꞋi labu neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bore ma sa Lot ka gani ngangata laꞋu adaroꞋo leleka kera ka alafafia neꞋe kera ke leka Ꞌi luma nia. Sui, sa Lot ka saea fuana ngwae ni rao nia ki Ꞌiri kike daua ti afu beret neꞋe noaꞋa ta isi ana, ma kira ka salisali ana fanga leꞋa ki fuana ro ngwae neꞋeri ki. KaidaꞋi fanga neꞋeri ki dua naꞋa, kira ka kwatea kera ka fanga naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sui ma kera ka fiꞋi leka maliu, na ngwae ana fanoa neꞋeri eta ana ngwae fiꞋi doe ki leleka ka dao ana ngwae ngwaro ki, kira fiku kalikalia maꞋi luma neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ꞋUnaꞋeri kira ka ako maꞋi Ꞌuri fuana sa Lot, “Ro ngwae baera ki kera Ꞌi faꞋi kwa? Ba kera leka maꞋi siamu taꞋena saꞋulafi? Kwatea keraꞋa maꞋi fuaimili, kami oga mike Ꞌusu faꞋinidaroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Bore ma sa Lot leka kwau Ꞌi maa, ma ka fono usia sinamaa Ꞌi burina, ");
INSERT INTO kwf_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","sui nia ka fata fuada, “Kwaima kina Ꞌae, na falafala nini kamu ki taꞋa liu mala. Reala Ꞌae, noaꞋa kamu kasi sasia laꞋu ru taꞋa Ꞌira. ");
INSERT INTO kwf_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Na ro ngela kini sariꞋi nau ku tua goꞋo adaroꞋo, ma noaꞋa ta ngwae Ꞌiri teo Ꞌua faꞋinidaroꞋo, nai baꞋa ngalidaroꞋo maꞋi fuaumulu fuana ta tae neꞋe kamu oga muke sasia adaroꞋo. Bore ma ro ngwae dao neꞋe ki, kera naꞋa saena luma nau, ma nau ku lia leꞋa sulidaroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bore ma kira taꞋifau kira ka fata Ꞌuri, “NoaꞋa Ꞌoe kosi fone kaimili. ꞋAeꞋo noaꞋa laꞋu ngwae ana fanoa neꞋe. ꞋOko Ꞌiri toꞋo ana ta ngasingasiꞋanga neꞋe Ꞌoke fata ꞋunaꞋeri fuaimili. ꞋOko ꞋasiꞋo, ko leka, uu faꞋasia tala. DiꞋia noaꞋa, kaimili ke baꞋa faꞋaliꞋo ka liufia kera ne!” ꞋIu ma kira ka sulangaꞋinia sa Lot Ꞌi maa, ma kira ka leka naꞋa maꞋi fuana fogalana sinamaa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bore ma ro ngwae neꞋeri ki Ꞌi saena luma, kera ka Ꞌifingia sinamaa, ma kera ka dau ana sa Lot, ma kera ka lalafia maꞋi saena luma laꞋu, ma kera ka fono Ꞌusia sinamaa. ");
INSERT INTO kwf_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma kera ka kwatea ngwaꞋi toꞋa neꞋe kira Ꞌi maa, na maada ka rodo, ma kira ka sama gagalo naꞋa Ꞌuana sinamaa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","GoꞋo ma ro ngwae neꞋeri ki kera ka fata Ꞌuri fuana sa Lot, “Si diꞋia Ꞌoko toꞋo ana ti ngwaefuta amu neꞋe kira tua saena fanoa neꞋe, Ꞌoke leka ngalida naꞋa. ꞋOke leka ngalia ngela Ꞌalako Ꞌoe ki, faꞋinia kini sariꞋi Ꞌoe ki, ma funga Ꞌoe ki, faꞋinia ta ngwaefuta bore Ꞌana Ꞌoe neꞋe kira tua ana fanoa neꞋe, Ꞌoke leka ngalida naꞋa ma muka leka naꞋa faꞋasia fanoa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","DuꞋungana keroꞋo ke baꞋa malangisia naꞋa fanoa doe neꞋe. Iawe nia sai naꞋa ana sulia abula taꞋangaꞋa neꞋe ki, ma nia ka kwate keroꞋo maꞋi fuana malangisilana fanoa neꞋe taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Sui sa Lot ka leka lisia ro ngwae neꞋe kera ke baꞋa korea ro kini sariꞋi nia ki, ma nia ka fata Ꞌuri fuadaroꞋo, “Moro ꞋaliꞋali naꞋa. Kuke baꞋa leka naꞋa faꞋasia fanoa neꞋe. KaidaꞋi neꞋe goꞋo Iawe ke baꞋa malangisia naꞋa fanoa neꞋe taꞋifau!” Bore ma kera ka fia fasi nia Ꞌoidorole goꞋo adaroꞋo, ma kera kasi leka goꞋo maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ana Ꞌofodangi taꞋa Ꞌua, na ro Ꞌainsel neꞋeri ki kera ka fata fuana sa Lot fasi Ꞌiri nia ke ꞋaliꞋali. Kera fata Ꞌuri, “ꞋOke ꞋaliꞋali naꞋa, ngalia Ꞌafe Ꞌoe faꞋinia ro sariꞋi Ꞌoe ki, ma mulu ka leka naꞋa kwau. DiꞋia noaꞋa, kaidaꞋi keroꞋo ke malangisia fanoa doe neꞋe, kaumulu ke baꞋa mae naꞋa Ꞌi saena.” ");
INSERT INTO kwf_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","KaidaꞋi sa Lot nia tua ka dole ana Ꞌi neꞋeri, Iawe ka manataia. GoꞋo ro ngwae neꞋeri ki ka dau ana limana faꞋinia ro sariꞋi ki, ma kera ka talaꞋida kira ka leka faꞋasia fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sui ta taꞋi ai adaroꞋo ka fata Ꞌuri fuada, “Mulu tafi ni maelamuꞋa naꞋa, noaꞋa kamu kasi lia faꞋi buri Ꞌuana fanoa neꞋe, muke tafi naꞋa Ꞌuana gwauna ua toꞋoba ki. NoaꞋa kamu kasi mango leleka kamu ka faꞋasia kula ote neꞋe toli, ma kamu ka raꞋe gwauna ua toꞋoba ki. ꞋI neꞋeri naꞋa neꞋe kamu ke mauri ana. DiꞋia noaꞋa goꞋo, kamu ke mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Bore ma sa Lot nia ka fata Ꞌuri, “Ngwae ꞋaꞋana Ꞌae, noaꞋa goꞋo, noaꞋa Ꞌoe kosi sasi kami kasi leka tau laꞋu ꞋunaꞋeri. Nau ku saiana neꞋe Ꞌoko kwaima liu aku, ma Ꞌoko faꞋamauri nau naꞋa. Bore ma si diꞋia nau ku tafi laꞋu Ꞌuana gwauna faꞋi ua toꞋoba ki, ta ru doe ke baꞋa fuli fuaku tofongana taꞋi tala loeri, ma noaꞋa naisi dao goꞋo Ꞌi gwauna faꞋi ua ma nau kui baꞋa eta mae goꞋo Ꞌaku. ");
INSERT INTO kwf_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","FaꞋuta, Ꞌuri ma Ꞌoko lisia kwau kala fanoa tiꞋitiꞋi loko Ꞌi loꞋoba? Nia karangi goꞋo loko, ma nau ku saiana nai tafi tua ana. Kala fanoa tiꞋitiꞋi goꞋo lokonia, ma nau ku saiana nai baꞋa mauri goꞋo ana.” ");
INSERT INTO kwf_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ꞋUnaꞋeri nia ka fata Ꞌuri, “Nia leꞋa goꞋo Ꞌana. NoaꞋa naisi faꞋalia fanoa loꞋoba. ");
INSERT INTO kwf_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bore ma Ꞌoke tafi ꞋaliꞋali, noaꞋa naisi sasia ta ru leleka Ꞌoko dao ana fanoa loꞋoba.” ꞋIu osiꞋana neꞋe sa Lot nia saea fanoa neꞋeri tiꞋitiꞋi goꞋo, kira saea fanoa neꞋeri Ꞌania Ꞌi Soa. ");
INSERT INTO kwf_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","KaidaꞋi sa Lot nia dao Ꞌi Soa, na sina nia raꞋe naꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tona goꞋo ma Iawe ka kwatea naꞋa maꞋi toli salfa neꞋe kwasu ka Ꞌasia naꞋa maꞋi faꞋasia na mamanga fafona ro fanoa neꞋeri ki Ꞌi Sodom ma Ꞌi Gomora. ");
INSERT INTO kwf_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Na mafula neꞋeri ka faꞋali taꞋa naꞋa ana fanoa ki taꞋifau ana abaꞋi kula neꞋeri. Nia ka saungia ngwae ki taꞋifau ana fanoa neꞋeri ki, ma ru neꞋe bulao logo ki. ");
INSERT INTO kwf_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bore ma kaidaꞋi neꞋeri, na Ꞌafe sa Lot ka lia faꞋi buri goꞋo, nia ka faꞋitaꞋi ka iliꞋi fauꞋa ana fiki asi. ");
INSERT INTO kwf_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Sui Ꞌofodangi taꞋa goꞋo ana ruana asoa naꞋa, sa Abraham ka leka ꞋaliꞋali naꞋa ana kula ba nia alaalaꞋa faꞋinia Iawe ana Ꞌi naꞋo, ");
INSERT INTO kwf_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ma nia ka lia toli ana Ꞌi Sodom ma Ꞌi Gomora ma na abaꞋi kula kalikalia ro fanoa neꞋeri ki, ma nia ka lisia na sasu nia raꞋe maꞋi ana kula neꞋeri, diꞋia sasuna ta mafula doe neꞋe duꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","KaidaꞋi God nia malangisia fanoa ki taꞋifau ana oteote doe neꞋeri neꞋe sa Lot nia tua ana, bore ma nia ka manata toꞋona ganiꞋa sa Abraham. Ma God ka alafafia sa Lot ka tafi etaea nia malangisia fanoa neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ꞋI buri, sa Lot maꞋu Ꞌania tuaꞋa ana fanoa kira saea Ꞌania Ꞌi Soa, ma nia faꞋinia ro sariꞋi nia ki, kira ka faꞋasia fanoa neꞋeri, ma kira ka raꞋe alaꞋa gwauna faꞋi ua, ma kira ka leka tua saena taꞋi faoda. ");
INSERT INTO kwf_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ana taꞋi kaidaꞋi, na faꞋinaꞋonaꞋo ana ro ngela kini neꞋeri ki, nia fata Ꞌuri fuana ai burina, “Na maꞋa koro nia ngwaro naꞋa, ma kula neꞋe ta ngwae Ꞌiri tua naꞋa ana fasi Ꞌiri ke kore koro, ma koro ka toꞋo ana ti ngela. ");
INSERT INTO kwf_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nia leꞋa diꞋia koro ke faꞋakwaꞋufia maꞋa koro Ꞌania waen Ꞌoro ki, ma kaidaꞋi neꞋe gwauna ka lilinga, ta taꞋi ai akoro ka leka teo faꞋinia. Nia ꞋunaꞋeri neꞋe koro ke baꞋa alua ti ngela fuana kwalafa nia.” ");
INSERT INTO kwf_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ꞋIu ma saena rodo neꞋeri, kera ka faꞋakwaꞋufia leleka nia ka gwaulilinga naꞋa, sui goꞋo faꞋinaꞋonaꞋo ka leka teo naꞋa faꞋinia, bore ma sa Lot ka gwaulilinga ka Ꞌiri saiana na tae neꞋe nia fulia. ");
INSERT INTO kwf_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Sui ma asoa Ꞌi buri, na faꞋinaꞋonaꞋo neꞋeri ka fata Ꞌuri fuana ai burina, “Na rodo nini sui toli nau ku teo faꞋinia maꞋa koro, taꞋena koro ke baꞋa faꞋakwaꞋufia laꞋu saena rodo neꞋe, ma ꞋaeꞋo laꞋu neꞋe Ꞌoke teo faꞋinia. ꞋUnaꞋeri neꞋe koro ke alua ti ngela fuana ladolana kwalafa nia.” ");
INSERT INTO kwf_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ꞋIu saena rodo neꞋeri kera ka faꞋakwaꞋufia, nia ka kwaꞋu ka gwaulilinga ka taꞋa naꞋa, ma ruana ngela neꞋeri ka leka ka teo laꞋu faꞋinia. Bore ma sa Lot ka gwaulilinga ka Ꞌiri sai naꞋa ana tae neꞋe nia sasia. ");
INSERT INTO kwf_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ꞋI neꞋeri na ro sariꞋi neꞋeri ki kera ka ina ana maꞋa kera. ");
INSERT INTO kwf_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Na faꞋinaꞋonaꞋo ka faꞋafuta taꞋi ngela ngwane, ma nia ka saea Ꞌania sa Moab. Ma kira ka faꞋasata fuuꞋi ngwae nia Ꞌani Ꞌi Moab. ");
INSERT INTO kwf_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma ruana ngela kini ka faꞋafuta logo na ngela ngwane, ma nia ka saea Ꞌani sa Benami, ma kira ka faꞋasata fuuꞋi ngwae nia Ꞌania Amon naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ꞋIu sa Abraham nia faꞋasia Ꞌi Mamre, ma nia ka Ꞌidu ana abaꞋi kula Ꞌi Negev neꞋe tua Ꞌi gwauna fanoa Ꞌi Kenan, ma nia ka tua ana fanoa Gerara tofongana fanoa Ꞌi Kades ma fanoa Ꞌi Suru. KaidaꞋi nia Ꞌidu, ");
INSERT INTO kwf_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","nia saea naꞋa Ꞌafe nia Ꞌi Sera Ꞌania ngwaingwaena nia goꞋo. Ma kaidaꞋi tatalafaꞋa sa Abimelek neꞋe nia gwaungaꞋi Ꞌi Gerara, nia saiana ru neꞋeri, ma ka kwatea kwaꞋu na ngwae nia, kira ka baꞋea maꞋi Ꞌi Sara ka tua saena luma nia. ");
INSERT INTO kwf_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ana taꞋi rodo Iawe nia leka maꞋi siana tatalafaꞋa Ꞌania taꞋi maliu boleꞋa, nia ka fata Ꞌuri ana, “ꞋOke baꞋa mae ne, osiꞋana Ꞌafe nini Ꞌoko ngalia, na kwasitoꞋola niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ka dao ana kaidaꞋi neꞋeri, sa Abimelek Ꞌiri taꞋi karangi tiꞋitiꞋi nama ana Ꞌafe neꞋe, ma nia ka fata Ꞌuri, “Aofia kwa, nau noaꞋa kusi fulia ta roraꞋa. FaꞋuta Ꞌoke baꞋa faꞋali nau naꞋa faꞋinia ngwaꞋi toꞋa nau? ");
INSERT INTO kwf_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Sa Abraham ka saea neꞋe Ꞌafe neꞋe na ngwaingwaena nia, ma kini neꞋe ka saea neꞋe na ngwaefuta nia neꞋe sa Abraham. KaidaꞋi nau ku ngalia kini neꞋe, ana manataꞋanga nau, nau ku saiana nau noaꞋa kusi fulia ta roraꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God nia fata laꞋu saena maliu boleꞋa neꞋe ka Ꞌuri, “ꞋIu, nau ku saiana kaidaꞋi Ꞌoko sasia ru neꞋeri, ana manataꞋanga Ꞌoe, Ꞌoko sasia ru saga. ꞋUnaꞋeri goꞋo, nau ku foneꞋo faꞋasi fulia ta roraꞋa fafi nau, ma nau ku foneꞋo faꞋasi Ꞌoko sama toꞋona nonina Ꞌi Sera. ");
INSERT INTO kwf_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ma kaidaꞋi neꞋe naꞋa, Ꞌoke olitaꞋinia fuana araꞋi nia! Na araꞋi nia, niaꞋa ta taꞋi profet, ma nia ke baꞋa foꞋo fuamu fasi Ꞌiri Ꞌoe kosi mae. Bore ma nau ku faꞋabasu Ꞌoe, si diꞋia Ꞌoe kosi olitaꞋinia, ꞋaeꞋo faꞋinia ngwaꞋi toꞋa Ꞌoe, kaumulu taꞋifau muke baꞋa mae.” ");
INSERT INTO kwf_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ꞋUnaꞋeri ana laꞋa bilabila Ꞌua, sa Abimelek ka ri maꞋi Ꞌuana ngwae faꞋinaꞋonaꞋo nia ki, ma nia ka faꞋarongoda Ꞌania maliu boleꞋanga neꞋeri. Ma kira ka maꞋu liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Sui nia ka ri maꞋi Ꞌuana sa Abraham, ma ka fata Ꞌuri fuana, “FaꞋuta neꞋe Ꞌoko sasia ru neꞋe aimili kwa! Ta tae neꞋe nau ku sasia ka taꞋa amu? FaꞋuta neꞋe Ꞌoko sasia ꞋafitaꞋinga doe neꞋe ka dao amiꞋa kwa! Nia noaꞋa Ꞌiri bolo faꞋinia neꞋe Ꞌoke sasia ru neꞋe aku. ");
INSERT INTO kwf_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","FaꞋuta neꞋe Ꞌoko sasi Ꞌuri ana ru neꞋe?” ");
INSERT INTO kwf_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","GoꞋo sa Abraham ka fata Ꞌuri, “Nau ku fia fasi noaꞋa ta ngwae ana fanoa neꞋe kasi manata doe goꞋo ana God, ma kira kata fiꞋi saungi nau ka mae ma ka fiꞋi ngali Ꞌafe nau. ");
INSERT INTO kwf_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ꞋIu nia mamana, Ꞌi Sera na ngwaingwaena nau niniꞋa. Na maꞋa nau niniꞋa alua, bore ma keroꞋo kasi futa laꞋu ana taꞋi teꞋa, nia ne nau ku korea. ");
INSERT INTO kwf_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ꞋIu kaidaꞋi God nia ri Ꞌuaku, nai leka faꞋasia fanoa maꞋa nau, ma nau ku leka Ꞌuana ta fanoa matamata, nau ku fata Ꞌuri fuana Ꞌafe nau, ‘Si diꞋia koro leka tua faꞋinia ti ngwae matamata, nia leꞋa fuana Ꞌoke saea neꞋe ꞋaeꞋo ngwaingwaena nau. Ru ꞋunaꞋeri neꞋe faꞋataꞋinia neꞋe na liamu teo liu aku.’” ");
INSERT INTO kwf_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ꞋUnaꞋeri sa Abimelek ka olitaꞋinia Ꞌi Sera siana araꞋi nia, ma nia ka kwatea na sipsip ki, ma buluka ki, ma na ngwae rao ꞋoꞋo ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ma nia ka fata Ꞌuri fuana, “Na ano neꞋe ki ru nau ki ne. ꞋOko saiana Ꞌoke leka tua ana ta kula goꞋo Ꞌana neꞋe Ꞌoko lisia ka leꞋa fuana tuaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma sa Abimelek ka fata Ꞌuri ana kini neꞋe, “KaidaꞋi neꞋe nai baꞋa kwatea 1,000 selene fuana ngwaefuta Ꞌoe, fuana faꞋamadakolana manataꞋanga ti ngwae, Ꞌasu Ꞌubani ti ngwae kira ka fiꞋi manata taꞋa fuamu ana kaidaꞋi nini Ꞌoko tutua faꞋinau. ꞋIu ngwae ki taꞋifau kira ke baꞋa saiana neꞋe Ꞌoko Ꞌiri fulia ta ru rora.” ");
INSERT INTO kwf_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","KaidaꞋi na tatalafaꞋa sa Abimelek nia ngalia Ꞌi Sera saena luma nia, Iawe nia luia na ngwaꞋi Ꞌafe ana luma neꞋeri, noaꞋa kira kasi ina naꞋa. OsiꞋana ru ꞋunaꞋeri naꞋa neꞋe sa Abraham nia ka foꞋo fuana tatalafaꞋa neꞋe, ma God ka gura laꞋu, ma nia ka gura logo Ꞌafe nia, ma kini rao ꞋoꞋo nia ki, fasi Ꞌiri kira ke ina laꞋu ma kika alu ngela nama. ");
INSERT INTO kwf_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ꞋIu God nia dao na kwaiꞋafi Ꞌi Sera, diꞋia nama ba nia fata alangaꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ana kaidaꞋi neꞋe sa Abraham nia ngwaro ka kokoꞋo naꞋa, Ꞌi Sera ka ina naꞋa, ma nia ka faꞋafuta taꞋi ngela ngwane keraꞋa. ꞋI Sera nia faꞋafuta na ngela neꞋe ana kaidaꞋi saga neꞋe God nia Ꞌolea nia ka futa. ");
INSERT INTO kwf_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ma sa Abraham ka saea Ꞌania sa Aesak. ");
INSERT INTO kwf_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","KaidaꞋi sa Aesak nia dao ana kwaula bongi nia, sa Abraham ka sasia na Ꞌolo faꞋataꞋi Ꞌanga ana, diꞋia ba God nia saea nama. ");
INSERT INTO kwf_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ana kaidaꞋi sa Aesak nia futa ana, sa Abraham nia talangaꞋi faꞋi ngali sui naꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ꞋIu ma Ꞌi Sera ka fata Ꞌuri, “God kwate nau ku saeleꞋa liu, ma nau ku gaꞋa koko. Ma ngwae neꞋe kira rongo sulia ru neꞋe, kira ke baꞋa saeleꞋa faꞋinau, ma kira ka gaꞋa koko logo. ");
INSERT INTO kwf_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ꞋI naꞋo maꞋi, noaꞋa ta ngwae saiana ka fata Ꞌuri ana sa Abraham, ‘ꞋI Sera ke faꞋafuta ta ngela.’ Sui bore Ꞌana sa Abraham keroꞋo ka ngwaro ka kokoꞋo naꞋa, nau ku alua goꞋo aku na ngela ana.” ");
INSERT INTO kwf_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ꞋIu sa Aesak nia doe naꞋa, ma kaidaꞋi nia abu susu naꞋa, sa Abraham nia ka sasi taꞋi fangaꞋa doe liu ana asoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ana kaidaꞋi Ꞌi Sera lisia sa Ishmael ke Ꞌoidorole Ꞌania sa Aesak. Sa Ishmael ta ngela ana sa Abraham neꞋe Ꞌi Hega kini Ꞌi Ejipt nia alua. ");
INSERT INTO kwf_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ꞋUnaꞋeri Ꞌi Sera ka fata Ꞌuri ana sa Abraham, “ꞋOke baꞋea kwau na kini rao ꞋoꞋo neꞋe faꞋinia ngela nia, kera ke leka faꞋasia fanoa neꞋe. Nau noaꞋa kusi oga na ngela neꞋe nia ke ngalia ti ru. Na ngela nau sa Aesak lala neꞋe ke ngalia ru neꞋe Ꞌoko toꞋo ani ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","AlaꞋanga neꞋeri sasia sa Abraham ka manata Ꞌabera liu, sulia sa Ishmael neꞋe na ngela leꞋa nia logo. ");
INSERT INTO kwf_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bore ma God nia ka fata Ꞌuri ana, “ꞋOe kosi manata Ꞌabera goꞋo ana kini rao ꞋoꞋo neꞋana faꞋinia ngela nia. Sasia lala tae neꞋe Ꞌi Sera saea fuamu, osiꞋana nauꞋa ba nau ku fata alangaꞋinia fuamu neꞋe Ꞌoke baꞋa toꞋo ana ngela Ꞌoro neꞋe kira ke futa maꞋi ana kwalafa Ꞌoe ma kwalafa sa Aesak neꞋe kira ke baꞋa saka maꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bore ma nai baꞋa kwatea logo na ngela Ꞌoro ki ke futa logo ana kwalafa sa Ishmael neꞋe kira ke baꞋa Ꞌoro liu, ma kira ke baꞋa tataꞋe ta tai fuuꞋi ngwae ngasingasiꞋa, osiꞋana nia ta ngela logo amu.” ");
INSERT INTO kwf_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ana Ꞌofodangi taꞋa Ꞌua ana ruana asoa, sa Abraham nia ka ngalia na fanga ki faꞋinia faꞋi kafo doe, ka kwatea fuana kini rao ꞋoꞋo neꞋeri. Nia ka alaꞋania ngela neꞋeri fuana, ma nia ka baꞋedaroꞋo faꞋasia fanoa neꞋeri. ꞋUnaꞋeri kera ka leka dalafa goꞋo adaroꞋo saena abaꞋi kula ꞋeꞋeredeꞋa kira saea Ꞌania Ꞌi Bereseba. ");
INSERT INTO kwf_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kera ka liu dalafa goꞋo adaroꞋo saena ꞋeꞋerede neꞋeri leka leleka na kafo keraꞋa ka sui naꞋa. GoꞋo na kini neꞋeri ka faꞋasia naꞋa ngela nia Ꞌi olofana kala Ꞌai tiꞋitiꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Buri Ꞌana nia ka taꞋi leka tiꞋitiꞋi laꞋu kwau sulia taꞋi talangaꞋi mita goꞋo, ma nia ka tua Ꞌi ano. Sui nia ka manata Ꞌana Ꞌuri, “NoaꞋa nau kusi oga naꞋa lisilana ngela nau neꞋe ke mae.” Sui nia ka tua Ꞌana ana kula neꞋeri fuana angiꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ꞋIu God nia rongoa angilana ngela fiꞋi doe neꞋeri, goꞋo na Ꞌainsel nia Ꞌi langi ka fata maꞋi fuana Ꞌi Hega ka Ꞌuri, “Hega kwa! FaꞋuta neꞋe liamu ka Ꞌabera liu naꞋa Ꞌuri? ꞋOe kosi maꞋu goꞋo! God nia rongoa naꞋa angilana Ꞌalako Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","TataꞋe ko uu, leka siana Ꞌalako Ꞌoe, ma ka dau Ꞌi limana, ma ka taꞋea, osiꞋana nai baꞋa kwatea na ngela Ꞌoro ke futa maꞋi ana kwalafa nia, ma kira ta fuuꞋi ngwae ngasingasiꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Buri Ꞌana goꞋo God nia ka faꞋataꞋinia taꞋi maꞋe kafo fuana Ꞌi Hega neꞋe kira Ꞌilia naꞋa maꞋi naꞋo neꞋe na kafo nia Ꞌi saena, ma nia ka leka ufia maꞋi na faꞋi kafo nari nia, ma nia ka ngalia maꞋi siana ngela nia ka kwaꞋufia. ");
INSERT INTO kwf_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","ꞋIu kaidaꞋi ngela neꞋeri nia fiꞋi doe maꞋi, God nia dangiꞋi lia leꞋa sulia. Nia tua saena kula ꞋeꞋeredeꞋa neꞋeri Ꞌi Paran, ma kaidaꞋi nia doe ka alua naꞋa ngwae, nia ta ngwae logo fuana fanaꞋa Ꞌania na basi ma sima. Sui teꞋa nia ka baꞋea maꞋi taꞋi ngela kini Ꞌi Ejipt nia ka korea. ");
INSERT INTO kwf_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ꞋIu ana kaidaꞋi neꞋeri, sa Abimelek na tatalafaꞋa faꞋinia sa Fikol, na gwaungaꞋi ana na ngwae ni ofoꞋa nia ki, kera leka maꞋi fuana lisilana sa Abraham. Sui na tatalafaꞋa neꞋeri ka fata Ꞌuri ana, “Nau ku lisia naꞋa neꞋe God nia tua faꞋiniꞋo ana ru ki taꞋifau Ꞌoko sasi. ");
INSERT INTO kwf_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ꞋUnaꞋeri nau ku oga Ꞌoke fata alangaꞋi fuaku Ꞌi maana God ko Ꞌuri, ‘ꞋOe kosi soke nau faꞋinia ngelaku, ma ngela neꞋe ke baꞋa futa maꞋi ana kwalafa nau ki. Na manataꞋanga nau ki nia teo ngangata firi amu, nia ne Ꞌoke fata alangaꞋi nama fuaka neꞋe manataꞋanga Ꞌoe ke baꞋa teo tari ngangata aku, faꞋinia logo na ngwae ana fanoa nini Ꞌoko tua ana.’” ");
INSERT INTO kwf_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ꞋUnaꞋeri sa Abraham nia ka fata Ꞌuri, “Nau ku fata alangaꞋi Ꞌi maana God, nai baꞋa sasia.” ");
INSERT INTO kwf_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sui nia ka fata buri ana sa Abimelek ka Ꞌuri, “TatalafaꞋa neꞋe kwa! Na ngwae ni rao Ꞌoe ki kira leka maꞋi ma kira ka ngalia naꞋa taꞋi maꞋe kafo Ꞌilia kami, ma kira ka luia naꞋa ana ngwae nau ki faꞋasia ufi kafoꞋa ana.” ");
INSERT INTO kwf_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Bore ma sa Abimelek ka Ꞌuri, “ꞋIu kwaimanatai, nau noaꞋa kusi saiana sa tai neꞋe nia sasia ru neꞋana, ma noaꞋa Ꞌoko Ꞌiri tai faꞋarongo nau nama, etana neꞋe nau ku fiꞋi rongoa ru neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ꞋUnaꞋeri goꞋo sa Abraham nia ka ngalia ti sipsip faꞋinia ti buluka ana, ma nia ka kwatea fuana tatalafaꞋa neꞋeri, ma nia ka fata alangaꞋi faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Buri Ꞌana nia ka ngalia na fiu sipsip kini tiꞋitiꞋi ki ma ka alu fiku ani. ");
INSERT INTO kwf_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Sui na tatalafaꞋa ka lidi Ꞌuri ana, “FaꞋuta laꞋu neꞋe Ꞌoko alu matali ana fiu sipsip kini tiꞋitiꞋi neꞋana ki?” ");
INSERT INTO kwf_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ꞋUnaꞋeri sa Abraham nia ka fata Ꞌuri, “Nau ku oga Ꞌoke ngalida fuamu, falafala neꞋe nia faꞋataꞋinia neꞋe nauꞋa mamana neꞋe nau ku Ꞌilia na maꞋe kafo neꞋe, ma na maꞋe kafo neꞋe ru nau.” ");
INSERT INTO kwf_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ꞋUnaꞋeri neꞋe ngwaꞋi toꞋa Ꞌi naꞋo kira ka saea kula neꞋeri Ꞌania Ꞌi Bereseba nama na “MaꞋe kafo Ꞌilia ana fata alangaꞋinga,” osiꞋana kera ro ngwae neꞋe ki, kera fata alangaꞋi ana kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Na kaidaꞋi alaꞋanga neꞋeri ki niꞋi saga ka sui naꞋa, na tatalafaꞋa sa Abimelek faꞋinia sa Fikol, kera ka oli laꞋu Ꞌuana Ꞌi Filistia. ");
INSERT INTO kwf_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Sa Abraham nia ka fasia taꞋi Ꞌai Ꞌi Bereseba. Na Ꞌai neꞋeri kira saea Ꞌania Tamaris. Ma ana kula neꞋeri, nia ka foꞋosia God neꞋe mauria firi Ꞌani satana Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ꞋI buri Ꞌana kaidaꞋi neꞋeri, sa Abraham nia ka tua tau ano neꞋeri ana ngwaꞋi toꞋa Ꞌi Filistia. ");
INSERT INTO kwf_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ꞋIu, Ꞌi buri Ꞌana kaidaꞋi neꞋe, God nia ka ilitoꞋona na fitoꞋonga sa Abraham, nia ka fata Ꞌuri fuana, “Abraham kwa!” Sa Abraham ka olisia ka Ꞌuri, “ꞋIu, nauꞋa niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Sui God nia ka fata Ꞌuri, “Na ngela neꞋe Ꞌoe sa Aesak, nia taꞋi ngela mutaꞋi neꞋe Ꞌoko toꞋo goꞋo ana niniꞋa, ma Ꞌoko kwaima liu mala ana. Nau ku oga Ꞌoke ngalia, ma Ꞌoko leka Ꞌuana abaꞋi kula Ꞌi Moraea. Nai baꞋa faꞋataꞋinia taꞋi faꞋi ua ana kula neꞋeri neꞋe Ꞌoke baꞋa saungia ngela neꞋe ana, ma Ꞌoke duꞋafia Ꞌania na foꞋosi fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ana laꞋa bilabila Ꞌua ana asoa Ꞌi buri, sa Abraham ka kwaꞋia na soꞋi fuana duꞋafilana foꞋosi, ma nia ka alua naꞋa Ꞌi fafona na dongki nia. Ma nia ka ngalia ngela nia sa Aesak faꞋinia na ro ngwae rao nia ki, ma kira ka leka naꞋa Ꞌuana na kula neꞋe God saea fuana. ");
INSERT INTO kwf_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ma na uula asoa ana lekaꞋa kira, sa Abraham ka lisia naꞋa kwau na kula neꞋeri bore ma nia taꞋi tau Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ma nia ka fata Ꞌuri fuana na ro ngwae ni rao ni ki, “Moro kwaimaꞋakwali basi Ꞌi neꞋe faꞋinia na dongki neꞋe. KeroꞋo sa Aesak, keroꞋo ke baꞋa etaeta basi Ꞌi loꞋoba fuana foꞋosiꞋanga. Sui keroꞋo ka fiꞋi oli laꞋu maꞋi siamuroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Sui sa Abraham nia ka dau ana na sele ma na mafula, ma nia ka kwatea ifi soꞋi ki fuana sa Aesak ka ꞋakaꞋi, ma kera ka leka naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","KaidaꞋi kera leka Ꞌua goꞋo adaroꞋo, sa Aesak nia ka fata Ꞌuri, “MaꞋasi kwa!” Sa Abraham ka olisi Ꞌuri ana, “Ngela nau Ꞌae, nia faꞋuta?” Sui sa Aesak ka fata Ꞌuri, “Kulu toꞋo ana na mafula ma na ifi soꞋi ki, Ꞌuri ma na kala sipsip fuana foꞋosiꞋanga nia Ꞌi faꞋi?” ");
INSERT INTO kwf_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Sui sa Abraham ka fata Ꞌuri ana, “Ngela nau Ꞌae, God naꞋa neꞋe ke baꞋa kwatea maꞋi na kala sipsip fuana foꞋosi Ꞌanga.” ꞋUnaꞋeri kera ka leka adaroꞋo, ");
INSERT INTO kwf_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ma kaidaꞋi kera dao naꞋa ana kula neꞋe God nia saea, sa Abraham ka Ꞌuia taꞋi fulikooꞋa, ka salisali ana ifi soꞋi ki Ꞌi fafona, ma nia ka firiꞋia na ngela nia, ma nia ka alua Ꞌi fafona ifi soꞋi neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ma nia ka ngalia na sele fuana saungilana ke mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bore ma na Ꞌainsel Iawe nia ka fonea. Nia tua Ꞌi langi, ma ka ri maꞋi ka Ꞌuri, “Ai Abraham, Abraham kwa!” Sui sa Abraham ka olisia ka Ꞌuri, “ꞋIu, nauꞋa niniꞋa!” ");
INSERT INTO kwf_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","GoꞋo ma Ꞌainsel neꞋeri nia ka fata Ꞌuri, “NoaꞋa Ꞌoe kosi saungia ngela nena Ꞌoe, nama Ꞌoko sasia ta ru ka toꞋea! NiniꞋari nau ku sai naꞋa ana Ꞌoko manata doe ana God. Ma Ꞌoko maꞋudi fuana kwatelana ma noaꞋa Ꞌoe kosi dau fafia taꞋi ngela mutaꞋi Ꞌoe neꞋe Ꞌoko toꞋo ana, ma Ꞌoko alaꞋania goꞋo Ꞌamu fuana maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Sa Abraham nia ka lia kalikalia, ma nia ka lisia taꞋi sipsip ngwane neꞋe na konana nia firu ana rara Ꞌai ana ai tiꞋitiꞋi. ꞋUnaꞋeri goꞋo nia ka leka ngalia naꞋa maꞋi na sipsip neꞋeri, ma ka olisia naꞋa Ꞌania na ngela nari nia. Sui nia ka sasia naꞋa Ꞌania foꞋosi ana God. ");
INSERT INTO kwf_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ꞋUnaꞋeri nia ka saea naꞋa na kula neꞋeri Ꞌania, “Iawe nia ke kwatea.” Nia ne leleka maꞋi ka dao Ꞌi taꞋena, na ngwae ki kira ka alaꞋa Ꞌuri, “ꞋI gwauna faꞋi ua Iawe, nia ke kwatea.” ");
INSERT INTO kwf_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Sui na Ꞌainsel Iawe nia ka fata Ꞌuri maꞋi Ꞌi langi ");
INSERT INTO kwf_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","fuana sa Abraham ka Ꞌuri, “OsiꞋana neꞋe Ꞌoko maꞋudi ko kwatea taꞋi ngela mutaꞋi Ꞌoe neꞋe Ꞌoko toꞋo ana, ma Ꞌoko Ꞌiri daufafia faꞋasia nau, nau ku fata alangaꞋi Ꞌania sataku talaku, ");
INSERT INTO kwf_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mamana liu nai baꞋa faꞋaleꞋa Ꞌoe, ma ngwae neꞋe kike baꞋa futa maꞋi ana kwalafa Ꞌoe ki, kike baꞋa Ꞌoro liu mala. Kike baꞋa Ꞌoro ka diꞋia na bulubulu ana salo, ma ka diꞋia na one ninimana na asi. Ma kike baꞋa inaꞋu ana liufilana malimae kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nai baꞋa faꞋaleꞋa kwalafa ki taꞋifau ana magalia sulia kwalafa Ꞌoe, osiꞋana Ꞌoko roꞋo sulia fatalaku.” ");
INSERT INTO kwf_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sui sa Abraham faꞋinia sa Aesak kera ka oli naꞋa maꞋi siana ro ngwae ni rao nia ki, ma kira ka oli laꞋu maꞋi Ꞌuana Ꞌi Bereseba. Ma nia ka sasia fanoa nia Ꞌi neꞋeri, ma nia ka tua naꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Buri Ꞌana kaidaꞋi neꞋeri, sa Abraham nia ka rongoa faꞋarongoa neꞋe na ngwaefuta nia sa Neho faꞋinia na Ꞌafe nia Ꞌi Milka, kera toꞋo ana na kwalu ngela ngwane ki. ");
INSERT INTO kwf_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","Na satada neꞋe sa Us, na faꞋinaꞋonaꞋo, ma sa Bus, sa Kemuel (nia na maꞋa sa Aram), sa Kessed, sa Haso, sa Pildas, sa Jidlaf, sa Betuel ni na maꞋa Ꞌi Rebeka. Nia naꞋa na satana kwalu ngela sa Neho ki neꞋe Ꞌi Milka nia faꞋafutaꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma sa Neho neꞋe nia ka toꞋo laꞋu ana ta Ꞌafe neꞋe satana Ꞌi Reuma, ma nia ka alua na fai ngela ngwane ki laꞋu, na satada neꞋe sa Teba, sa Gaham, sa Tahas, ma sa Mahaka. ");
INSERT INTO kwf_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ꞋI Sera nia tua leleka ka dao ana taꞋi talangaꞋi faꞋi ngali ma ro akwala ma fiu faꞋi ngali sui nia ka mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","3","Nia mae ana abaꞋi kula Ꞌi Kenan ana fanoa Ꞌi Kiriataba, neꞋe niniꞋari kira saea Ꞌania Ꞌi Hebron. ꞋUnaꞋeri sa Abraham nia ka kwaimanatai liu naꞋa, ma ka angi liu naꞋa Ꞌuana Ꞌafe nia neꞋe nia mae naꞋa. ꞋI buri Ꞌana nia ka tataꞋe faꞋasia kula neꞋe kira faꞋateoꞋa Ꞌafe nia ana, nia ka leka lisia na ngwaꞋi toꞋa ꞋaꞋana ana fuuꞋi ngwae sa Het, ma nia ka fata Ꞌuri fuada, ");
INSERT INTO kwf_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nau ku tua ana fanoa kaumulu, bore ma nau na ngwae kwaita goꞋo. ꞋIu na Ꞌafe nau nia mae naꞋa, ma nau ku oga nai folia ta afu ano faꞋasi kamu, fasi Ꞌiri nai kwaiatoa ana.” ");
INSERT INTO kwf_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bore ma kira ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“AraꞋi ꞋaꞋana Ꞌae, Ꞌoke rongo maꞋi sulia alaꞋa laimili. ꞋAeꞋo naꞋa ta faꞋinaꞋonaꞋo ngasingasiꞋa fuaimili. ꞋOko saiana Ꞌoke leka goꞋo Ꞌamu ana ta kula ni alu ngwaeꞋa aimili ma Ꞌoko kwaiatoa Ꞌafe Ꞌoe ana kula leꞋa mala. DiꞋia Ꞌoko filia ta kula ni alu ngwaeꞋa aimili ma Ꞌoko kwaiatoa Ꞌafe Ꞌoe, noaꞋa ta ngwae aimili kasi foneꞋo goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Sa Abraham nia tataꞋe ma ka Ꞌoto gwau toli fuada, ");
INSERT INTO kwf_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ma ka fata Ꞌuri, “Si diꞋia neꞋe kamu saeleꞋa mamana, ma kamu ka alaꞋania neꞋe nai kwaiatoa na Ꞌafe nau ana kula neꞋe ngwaꞋi toꞋa kaumulu, kamu ke saefiloa maꞋi sa Efron na ngela sa Soha, ");
INSERT INTO kwf_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","fasi Ꞌiri nia ke faꞋafoli Ꞌania na kala afu ano tiꞋitiꞋi loꞋoko na faoda nia teo ana, loꞋoko kira saea Ꞌania Ꞌi Makpela, loꞋoko nia teo Ꞌi ninimana oꞋola nia. Ngwae futa kina Ꞌae, moro saefiloa maꞋi Ꞌiri nia ke alaꞋania nai folia Ꞌi maamulu Ꞌania folifoliꞋa aliꞋafu nia fasi Ꞌiri nai toꞋo naꞋa ana diꞋia na kula ni alu ngwaeꞋa kami.” ");
INSERT INTO kwf_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Sui ngwaꞋi toꞋa ana fuuꞋi ngwae sa Het, kira ka tua goꞋo Ꞌada ana sinamaa ana faꞋi labu ana fanoa doe neꞋeri. Ma kaidaꞋi neꞋeri sa Efron logo neꞋe nia tua faꞋi kira, ma nia ka fata Ꞌuri Ꞌi maada, ");
INSERT INTO kwf_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“AraꞋi ꞋaꞋana kwa! Na alaꞋalaku neꞋe Ꞌuri nau ku saeleꞋa liu fuana kwatelana ano neꞋe ki fuamu faꞋinia faoda loꞋoko. ꞋI maana ngwaꞋi toꞋa nini Ꞌi fanoa nau, nau ku kwatea goꞋo fuamu Ꞌi niniꞋari naꞋa, fasi Ꞌiri Ꞌoke kwaiatoa Ꞌafe Ꞌoe ana.” ");
INSERT INTO kwf_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ma Ꞌi maada, sa Abraham nia ka Ꞌoto gwau toli laꞋu, ");
INSERT INTO kwf_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ma nia ka fata Ꞌuri fuana sa Efron, “Ngwadela Ꞌae, Ꞌoke rongoa basi alaꞋalaku. Nau ku oga nai foli taꞋifau naꞋa ana folifoliꞋa ana afu ano neꞋe. Ngwadela Ꞌae, ngalia naꞋa mani neꞋe ki, fasi Ꞌiri nai leka kwaiatoa Ꞌafe nau ana ano neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Sui sa Efron nia ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“AraꞋi ꞋaꞋana kwa! Na folifoliꞋa ano neꞋe na 400 selene ki ana silva. Bore ma na ru ꞋoꞋo goꞋo Ꞌana Ꞌi safitakoro neꞋeriꞋa. Nia leꞋa, leka kwaiatoa Ꞌafe Ꞌoe naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Sa Abraham alafafia neꞋe nia ke kwatea na folifoliꞋa neꞋe sa Efron saea kwau Ꞌi maana na ngwaꞋi toꞋa ana fanoa neꞋeri. ꞋIu Ꞌi maana ngwaꞋi toꞋa neꞋeri nia ka ilia na kulu kulu fana na mani nia ki ma nia bolo naꞋa faꞋinia 400 selene ki ana silva. Ngwae ki taꞋifau alafafia na kulu kulu fana na mani neꞋeri nia saga. ");
INSERT INTO kwf_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ꞋUnaꞋeri neꞋe sa Abraham nia ka ngalia naꞋa na afu ano Ꞌi Makpela, neꞋe nia teo ana bali fanelana sina ana Ꞌi Mamre. ꞋI naꞋo na ano neꞋeri nia ana sa Efron, bore ma niniꞋari na ano sa Abraham naꞋa. Kera faꞋasaga ru neꞋeri. ꞋUnaꞋeri sa Abraham folia na afu ano faꞋinia faoda neꞋe, ma na Ꞌai neꞋe teo ana ki logo faꞋasia sa Efron. ");
INSERT INTO kwf_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ma fuuꞋi ngwae sa Het neꞋe kira tua logo ana fiku alaꞋanga neꞋeri, kira ka sai leꞋa naꞋa ana na ano neꞋeri neꞋe na ru sa Abraham naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ꞋI buri Ꞌana naꞋa sa Abraham nia ka leka ka kwaiatoa naꞋa Ꞌafe nia Ꞌi Sera saena faoda neꞋe Ꞌi Makpela karangia Ꞌi Mamre ana Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ma Ꞌi neꞋeri na ano neꞋe na ru na fuuꞋi ngwae sa Het Ꞌi naꞋo faꞋinia na faoda neꞋe teo ana, ma Ꞌi niniꞋari na ano sa Abraham naꞋa. ꞋI buira nia ka rao naꞋa Ꞌania faoda neꞋeri fuana kwaiatolana ngwae mae kira ki ana kwalafa nia. ");
INSERT INTO kwf_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ꞋIu sa Abraham nia ngwaro liu naꞋa, ma Iawe ka faꞋaleꞋa nia ana ru nia sasiꞋi ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","ꞋUnaꞋeri nia ka saea maꞋi na taꞋi ngwae ana ngwae ni rao ni ki, neꞋe nia ngwae ꞋaꞋana naꞋa ana ngwae rao nia ki. Ma sa Abraham ka fata Ꞌuri fuana, “Nau ku oga Ꞌoko leka ma ko ngalia maꞋi taꞋi kini sariꞋi fuana ngela nau sa Aesak. ꞋOko alua naꞋa limamu Ꞌi olofana Ꞌaeku ma ko sasia fata alangaꞋinga Ꞌi maana Iawe na God Ꞌi langi ma Ꞌi ano, Ꞌoko fata Ꞌuri, ‘NoaꞋa naisi filia ta sariꞋi Ꞌi neꞋe Ꞌi Kenan fuana Ꞌalako Ꞌoe ke korea. Nai baꞋa oli nama ana fuuꞋi ngwae Ꞌoe neꞋe maꞋa Ꞌoe futa ana. Ma nai baꞋa filia nama ta kini neꞋe futa ana ta taꞋi ngwae ada fasi Ꞌiri Ꞌalako Ꞌoe ke korea.’” ");
INSERT INTO kwf_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bore ma na ngwae rao neꞋeri ka saefilo Ꞌuri ana, “Ngwae ꞋaꞋana kwa! FaꞋuta diꞋia nau ku filia ta kini bore ma nia kasi oga lekaꞋa maꞋi faꞋinau, nai baꞋa sasi laꞋu ta taꞋe? Nai baꞋa kwatea laꞋu ngela ngwane Ꞌoe ke leka tau laꞋu saena maꞋe fanoa ba Ꞌoko leka maꞋi faꞋasia Ꞌi naꞋo?” ");
INSERT INTO kwf_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Bore ma sa Abraham ka fata Ꞌuri fuana, “NoaꞋa! NoaꞋa Ꞌoe kosi kwatea ngela ngwane nau ka oli Ꞌuana kula neꞋana! ");
INSERT INTO kwf_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Iawe nia na God Ꞌi langi, nia ngali nau ka sui naꞋa faꞋasia abaꞋi kula neꞋana maꞋa nau, ma nau ku faꞋasia ka sui naꞋa na fanoa neꞋana fuuꞋi ngwae nau kira tua ana. Iawe nia sasia taꞋi fata alangaꞋinga ngasingasiꞋa fuaku neꞋe na ano nini kulu tua ana kaidaꞋi neꞋe nia ke baꞋa kwatea maꞋi fuana ngela neꞋe kike baꞋa futa maꞋi ana kwalafa nau. Ma nia ke baꞋa asungaꞋinia Ꞌainsel nia ka eta eta amu kaidaꞋi neꞋe Ꞌoke baꞋa saiana Ꞌoke dao toꞋona taꞋi ngela kini sariꞋi ana kula neꞋeri fasi Ꞌiri ngela ngwane nau ke korea. ");
INSERT INTO kwf_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Bore ma si diꞋia ngela kini neꞋe Ꞌoko filia, nia kasi oga lekaꞋa maꞋi faꞋiniꞋo, ꞋunaꞋeri Ꞌoko aloge naꞋa faꞋasia fata alangaꞋinga neꞋe fuaku. Bore ma nau kusi oga neꞋe Ꞌoke ngalia ngela ngwane nau ku leka Ꞌuana fanoa neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nama goꞋo na ngwae ni rao neꞋeri ka alua naꞋa limana Ꞌi olofana Ꞌaena sa Abraham ma ka sasia fata alangaꞋinga neꞋeri, diꞋia ba sa Abraham eta saea fuana. ");
INSERT INTO kwf_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Sui, na ngwae ni rao baera ka ngalia akwala kamel ngwae ꞋaꞋana ma faꞋinia ru matamata Ꞌoro lisilana leꞋa ki neꞋe ngwae ꞋaꞋana kwateꞋe fuana kwatelana fuana ngwaꞋi toꞋa loꞋoba, ma nia ka leka naꞋa Ꞌuana abaꞋi kula neꞋeri. Nia leka ka liu ana fanoa doe Ꞌi Mesopotemia, ana bali Ꞌi Ꞌaena fanoa doe neꞋe sa Neho nia tua ana. Nia leka sulia asoa Ꞌoro ki, ");
INSERT INTO kwf_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ma kaidaꞋi nia dao ana maꞋe fanoa neꞋeri, nia ka leka mamalo karangia taꞋi maꞋe kafo Ꞌilia ana kula neꞋeri, ma nia ka kwatea kamel nia ki kira ka mamalo logo. Ana kaidaꞋi neꞋeri na madaꞋafi nia ka koso naꞋa, ma ngwaꞋi kini ana fanoa neꞋeri kira leka maꞋi Ꞌuana maꞋe kafo neꞋeri fuana ufi kafoꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ma nia ka foꞋo ka Ꞌuri, “Aofia, Ꞌoe Iawe na God ngwae ꞋaꞋana nau, sa Abraham. ꞋOke kwatea raoꞋa neꞋe nau ke ngwaluda taꞋena. Nau ku amasiꞋo Ꞌoke faꞋataꞋinia neꞋe Ꞌoko alafe fuana ngwae ꞋaꞋana nau, ma Ꞌoko dau sulia na fata alangaꞋinga ba Ꞌoe fuana. ");
INSERT INTO kwf_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","KaidaꞋi nini nau ku tua Ꞌi maana maꞋe kafo Ꞌilia neꞋe, ngwaꞋi kini fiꞋi doe ana fanoa neꞋe kike baꞋa leka maꞋi ana kula neꞋe fuana ufi kafoꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nai baꞋa lidi Ꞌuri ana ta taꞋi ai adulu, ‘ꞋUri ma Ꞌoko saiana Ꞌoke kwatea ta kala kafo fuaku, Ꞌiri nai kwaꞋu?’ Sui nia ke fata Ꞌuri, ‘Nia leꞋa goꞋo Ꞌana, Ꞌoke kwaꞋu, nai baꞋa leka ngali kafo logo fuana kamel Ꞌoe ki.’ Aia, nau ku amasiꞋo, Ꞌoke alaꞋania na alaꞋanga neꞋeri naꞋa neꞋe na maꞋetoꞋo neꞋe Ꞌoko filia ngela kini neꞋeri, fuana ngwae ni rao Ꞌoe sa Aesak ke baꞋa korea. ꞋUnaꞋeri neꞋe nau ku saiana Ꞌoko dau sulia fata alangaꞋilamu fuana ngwae ꞋaꞋana nau sa Abraham.” ");
INSERT INTO kwf_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ana kaidaꞋi ngwae neꞋe Ꞌiri faꞋasuia Ꞌua na foꞋongaꞋa nia, taꞋi ngela kini fiꞋi doe ka dao naꞋa ana kula neꞋeri, nia ngalia taꞋi faꞋi botel fuana kafo Ꞌi gwauna ꞋabaꞋabana. Kini sariꞋi neꞋeri satana neꞋe Ꞌi Rebeka. Nia na defo sa Betuel. Sa Betuel nia futa ana Ꞌi Milka ma sa Neho. Sa Neho neꞋeri ngwae futa sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ꞋI Rebeka taꞋi ngela kini sariꞋi neꞋe lisilana ꞋoloꞋolo liu, ma nia noaꞋa kasi teo Ꞌua faꞋinia ta ngwae. Nia ka koso saena kilu kafo neꞋeri ma ka faꞋafungua faꞋi botel kafo nia ma ka oli maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ma ngwae rao nini sa Abraham ka lalili siana, ma ka fata Ꞌuri fuana, “Nau ku kwaiamasi amu Ꞌoko saiana Ꞌoke kwatea fuaku ta kala kafo fuaku ana faꞋi botel kafo neꞋana Ꞌoe fasi Ꞌuri nai kwau?” ");
INSERT INTO kwf_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Tona bore ma, sariꞋi neꞋe faꞋakosoa naꞋa na faꞋi botel kafo faꞋasia gwauna ꞋabaꞋabana, ma ka daua kwau fuana ngwae neꞋeri ka kwau, ma nia ka fata Ꞌuri, “AraꞋi ꞋaꞋana kwa, kwaꞋu!” ");
INSERT INTO kwf_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ma kaidaꞋi ngwae neꞋeri kwau ka sui naꞋa, sariꞋi neꞋeri ka fata laꞋu Ꞌuri, “ꞋOke mango basi, nai baꞋa leka ngali kafo maꞋi fuana kamel Ꞌoe ki fasi Ꞌiri kike kwaꞋu logo.” ");
INSERT INTO kwf_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ma lima lakolako goꞋo nia ka Ꞌiria na kafo neꞋeri saena faꞋi botel kafo nia Ꞌuana kula ru ꞋaeꞋaela ki fuana kwaꞋunga, ma nia ka lalili ka oli Ꞌuana kilu kafo fuana faꞋafungulana kafo saena faꞋi botel kafo nia, ma nia ka inaꞋu ana ngali kafoꞋa maꞋi, leleka na kamel neꞋeri ki, kira ka kwaꞋu ka sui taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ma na ngwae neꞋeri nia tua aroaro ma ka bubungia goꞋo Ꞌana sariꞋi neꞋeri, ma nia ka manata Ꞌana sulia diꞋia neꞋe Iawe kwatea raoꞋa nia ka leka leꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ma kaidaꞋi kamel ki kwaꞋu ka sui naꞋa ngwae neꞋe ka ngalia taꞋi komeꞋe gol neꞋe kululana nia lima gram ki, ma nia ka dauraꞋinia Ꞌi maana ngongorana kini neꞋeri. Ma nia ka lafua ro gol sen neꞋe kululadaroꞋo taꞋi talangaꞋi gram, ma nia ka alua Ꞌi limana. ");
INSERT INTO kwf_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ma nia ka lidi Ꞌuri ana, “Nau ku oga Ꞌoke saea fuaku. Sa tai mo neꞋe satana maꞋa Ꞌoe? NauꞋa faꞋinia na ngwae nau ki, kaimili lulu Ꞌuana ta taꞋi kula fuana maliu Ꞌanga ana. ꞋUri ma Ꞌoko fia kaimili saiana mike leka maꞋi ka tua Ꞌi luma nia?” ");
INSERT INTO kwf_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Aia sariꞋi neꞋeri nia ka olisi Ꞌuri ana, “Na satana maꞋa nau neꞋe sa Betuel, na ngela sa Neho ma Ꞌi Milka. ");
INSERT INTO kwf_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma na luma kami toꞋo ana kula kaumulu saiana muke tua ana, ma nia ka toꞋo ana kula logo fuana camel ki, ma fanga Ꞌoro kira teo goꞋo Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ma na ngwae neꞋeri ka Ꞌoto gwau toli leleka maana ka toꞋo Ꞌi ano, ma nia ka foꞋosia Iawe, ");
INSERT INTO kwf_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ma nia ka fata Ꞌuri, “Iawe, Ꞌoe God ngwae ꞋaꞋana nau sa Abraham. Nau ku baꞋatafea satamu, Ꞌoko gonia nama Ꞌamu Ꞌua na fata alangaꞋinga ba Ꞌoko sasia faꞋinia. ꞋOko ngali nau saga maꞋi aku Ꞌuana luma ta taꞋi ngwae ana fuuꞋi ngwae nia.” ");
INSERT INTO kwf_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","GoꞋo Ꞌi Rebeka ka lalili Ꞌuana Ꞌi luma, ma nia ka faꞋarongo Ꞌani ru ki taꞋifau fuana fuuꞋi ngwae teꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ma sa Laban na sasina Ꞌi Rebeka nia tua. Ana kaidaꞋi sa Laban lisia na komeꞋe gol neꞋeri ana ngongorana Ꞌi Rebeka, ma faꞋinia ro gol sen ki tua Ꞌi limana, ma ka rongoa nia faꞋarongo Ꞌania alaꞋanga neꞋe ngwae neꞋeri nia saea ki, nia ka leka kwau faꞋasia luma ka lalili fuana lisilana na ngwae neꞋeri. Ngwae neꞋeri uu Ꞌana Ꞌua Ꞌi maana kilu kafo, karangia kula kamel nia ki tua ana. KaidaꞋi sa Laban dao maꞋi, ");
INSERT INTO kwf_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","nia ka fata Ꞌuri fuana, “Leka maꞋi kwa! Koro ke leka Ꞌi luma. ꞋAeꞋo taꞋi ngwae neꞋe Iawe nia faꞋaleꞋa. Nia Ꞌiri leꞋa neꞋe Ꞌoke uu goꞋo Ꞌamu Ꞌuri ana kula neꞋe. Nau ku toꞋo ana kula ka sui naꞋa maꞋakwaliꞋo Ꞌi luma kaimili, ma kula fuana kamel Ꞌoe ki tua logo naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Sui sa Laban ka baꞋea ngwae neꞋeri Ꞌi luma, ma ka lafua ru ki faꞋasia ngwaꞋi ana camel ki, ma ka kwatea na fanga fuana kamel neꞋeri ki, ma nia ka fiꞋi aluda ana kula kira ka maliu ana. Buri Ꞌana nia ka ngali maꞋi kafo fuana ngwae neꞋeri faꞋinia ngwae nia ki fuana kira ka taufia Ꞌaeda ana. ");
INSERT INTO kwf_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bore ma kaidaꞋi ngwae sa Laban ki ngalia maꞋi fanga ki, ngwae neꞋeri ka fata Ꞌuri, “Nau noaꞋa naisi fanga basi Ꞌua, nau ku toꞋo ana taꞋi alaꞋanga neꞋe nai eta saea nama fuaumulu.” Sa Laban ka fata Ꞌuri, “Nia leꞋa, faꞋarongo kaimili Ꞌamu Ꞌania.” ");
INSERT INTO kwf_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ma na ngwae neꞋeri ka fata Ꞌuri, “NauꞋa taꞋi ngwae rao goꞋo, ma na ngwae ꞋaꞋana nau neꞋe sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Iawe nia faꞋaleꞋa ngwae ꞋaꞋana nau Ꞌania ru Ꞌoro ki mala. Ma nia ka lafutaꞋinia niaꞋa taꞋi ngwae toꞋoru neꞋe nia toꞋo ana sipsip ki, ma nanigot ki, ma na buluka ki, ma nia ka toꞋo ana silva ki, ma na gol ki, ma na ngwae rao ꞋoꞋo ki, ma na kini rao ꞋoꞋo ki, ma na kamel ki faꞋinia dongki ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma na Ꞌafe nia Ꞌi Sera, nia faꞋafuta taꞋi ngela ngwane kaidaꞋi nia ngwaro ka kokoꞋo naꞋa, ma na ngwae ꞋaꞋana nau ka kwatea ru nia ki taꞋifau naꞋa fuana ngela nia. ");
INSERT INTO kwf_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma nia ka saea taꞋi ru fuaku, ma nia ka kwatea nau ku fata alangaꞋi ana taꞋi falafala neꞋe nai baꞋa sasi diꞋia nama neꞋe nia saea. Nia Ꞌuri, ‘NoaꞋa Ꞌoe kosi filia ta sariꞋi Ꞌi neꞋe Ꞌi Kenan fuana Ꞌalako nau ke korea. ");
INSERT INTO kwf_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ꞋOke oli nama ana fuuꞋi ngwae nau neꞋe maꞋa nau futa ana. Ma Ꞌoko filia nama ta kini neꞋe futa ana ta taꞋi ngwae ada fasi Ꞌiri Ꞌalako neꞋe nau ka korea.’ ");
INSERT INTO kwf_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ma nau ku saefiloa ngwae ꞋaꞋana nau ku Ꞌuri, ‘FaꞋuta, diꞋia nau ku filia ta taꞋi sariꞋi, bore ma noaꞋa nia kasi leka maꞋi faꞋinau, taꞋe neꞋe nai baꞋa sasia laꞋu?’ ");
INSERT INTO kwf_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bore ma nia ka fata Ꞌuri, ‘KaidaꞋi ki taꞋifau nau ku kwairoꞋoi ana Iawe, ma nia ke baꞋa kwatea na Ꞌainsel nia ka leka faꞋiniꞋo Ꞌi toꞋoba, ma na raoꞋa Ꞌoe ke baꞋa ngwaluda. Ma nia ke baꞋa talangwaraꞋu goꞋo fuamu neꞋe Ꞌoke dao toꞋona ta taꞋi sariꞋi fiꞋi doe ana fuuꞋi ngwae nau neꞋe kira futa maꞋi ana maꞋa nau, fasi Ꞌiri ngela nau ke korea. ");
INSERT INTO kwf_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","TaꞋi falafala goꞋo neꞋe teo fuamu fuana logelamu faꞋasia alangaꞋinga ba Ꞌoe, diꞋia Ꞌoko leka siada, ma kira kasi saiana Ꞌafilamu, nia neꞋe kwate ma Ꞌoke aloge faꞋasia na alangaꞋinga neꞋe.’ ");
INSERT INTO kwf_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ana kaidaꞋi kami dao Ꞌi maana kilu kafo neꞋe Ꞌi taꞋena, nau ku foꞋo ku fata Ꞌuri, ‘Iawe, Ꞌoe God ngwae ꞋaꞋana nau sa Abraham. Nau ku kwaimasi amu Ꞌoke kwatea raoꞋa nau ka ngwaluda. ");
INSERT INTO kwf_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","KaidaꞋi neꞋe nau ku tua naꞋa ana kilu kafo neꞋe, diꞋia ta sariꞋi fiꞋi doe nia leka maꞋi ka ngali kafo ana kilo kafo neꞋe, nai baꞋa saefilo Ꞌuri ana, “Nau ku amasiꞋo Ꞌuri ma Ꞌoko saiana Ꞌoke kwatea ta kala kafo saena faꞋi botel kafo Ꞌoe fasi Ꞌiri nai kwaꞋu kwa?” ");
INSERT INTO kwf_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ma nia ka fata Ꞌuri, “LeꞋa goꞋo Ꞌana, Ꞌoke kwaꞋu, ma nai baꞋa ngali kafo logo fuana kamel Ꞌoe ki.” ꞋIu nau ku amasiꞋo alaꞋania alaꞋanga neꞋeri na toto neꞋe Ꞌoko filia naꞋa sariꞋi neꞋe Ꞌiri ngela ngwane ngwae ꞋaꞋana nau nia ke baꞋa korea. ");
INSERT INTO kwf_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","KaidaꞋi nau ku foꞋo goꞋo Ꞌaku Ꞌua ꞋunaꞋeri saena manataꞋanga nau, Ꞌi Rebeka ka dao naꞋa maꞋi. Ma nia ka ngalia faꞋi kafo ki Ꞌi gwauna ꞋabaꞋabana, ma nia ka koso toli saena kilu kafo ka ongi kafo. Ma nau ku fata Ꞌuri fuana, “ꞋOko saiana Ꞌoke kwatea ta kala kafo fuaku, nau ku oga nai kwaꞋu” ");
INSERT INTO kwf_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tona bore ma nia faꞋakosoa naꞋa faꞋi kafo neꞋeri Ꞌi gwauna ꞋabaꞋabana, ma ka fata Ꞌuri, ‘LeꞋa goꞋo Ꞌana, Ꞌoke kwaꞋu. Ma nai baꞋa ngali kafo fuana kamel Ꞌoe ki logo.’ Ma nau ku kwaꞋu, ma nia ka kwate kafo fuana kamel nau ki, kira ka kwaꞋu logo. ");
INSERT INTO kwf_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ma nau ku lidi Ꞌuri ana, ‘Sa tai neꞋe satana maꞋa Ꞌoe?’ Ma nia ka fata Ꞌuri, ‘Satana maꞋa nau neꞋe sa Betuel. NiaꞋa ngela sa Neho ma Ꞌi Milka.’ Sui nau ku dauraꞋinia na kome ngongorana, ma nau ku alua ro saen ki Ꞌi limana. ");
INSERT INTO kwf_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Sui nau ku bobo uruuru ma ku baꞋatafea Iawe, duꞋungana nia na God ngwae ꞋaꞋana nau sa Abraham, ma nia ka ngali saga maꞋi aku Ꞌuana luma kwalafa ngwae ꞋaꞋana nau. Ma nau ku lisia taꞋi kini sariꞋi neꞋeri nia na koꞋo na ngwaefuta ngwae ꞋaꞋana nau. Ma neꞋe na ngela ngwae ꞋaꞋana nau ke baꞋa korea kini sariꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nia ke baꞋa faꞋuta niniꞋa? Si diꞋia kamu oga mike faꞋataꞋinia neꞋe kamu alafe fuana ngwae ꞋaꞋana nau, ma kamu dau sulia Ꞌoga amulu, nau ku gani kamu muke faꞋarongo nau nama. Bore ma diꞋia noaꞋa, kamu ka saea fasi Ꞌiri nai baꞋa sasia laꞋu ta lia Ꞌi ngwae.” ");
INSERT INTO kwf_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Sa Laban ma maꞋa nia sa Betuel ka fata Ꞌuri, “Ru neꞋana nia saka maꞋi ana Iawe! KeroꞋo noaꞋa kasi saea naꞋa ta ru ana. Nia leꞋa goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Na sariꞋi neꞋe niniꞋa tua goꞋo Ꞌana. Nia ke baꞋa leka faꞋi kaumulu, kaidaꞋi kamu ke oli ana Ꞌi fanoa kamu. Nia leꞋa fuana nia ka Ꞌafe fuana ngela ngwae ꞋaꞋana Ꞌoe, diꞋia nama neꞋe Iawe nia saea.” ");
INSERT INTO kwf_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ma kaidaꞋi na ngwae neꞋeri rongoa alaꞋanga neꞋeri, nia ka bobo uruuru ma ka baꞋatafea Iawe. ");
INSERT INTO kwf_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","GoꞋo nia ka lafua maꞋi na Ꞌaba ifi kwanga ki, ma kekefa neꞋe kira saungaꞋiniꞋi Ꞌani silva ma gol ki ba kira ngaliꞋi maꞋi, ma nia ka kwate taꞋifau ani fuana Ꞌi Rebeka. Ma nia ka ngalia ti ru matamata laꞋu neꞋe folilani doe liu, ma ka kwateꞋe fuana ngwaefuta sariꞋi neꞋe faꞋinia teꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ma na ngwae neꞋeri faꞋinia na ngwae nia ki kira fiꞋi nguta, ana rodo neꞋeri kira ka maliu ana luma neꞋeri. Ma Ꞌofodangi nia ka fata Ꞌuri fuana ngwaꞋi toꞋa ana luma neꞋeri, “Nia leꞋa fuaumulu muke alaꞋani nai oli naꞋa Ꞌuana ngwae ꞋaꞋana nau.” ");
INSERT INTO kwf_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bore ngwaingwaena Ꞌi Rebeka ma teꞋa nia kera ka fata Ꞌuri, “NoaꞋa, alaꞋania Ꞌi Rebeka ke tua sulia basi ta kaidaꞋi tiꞋitiꞋi faꞋi kaimili, ru diꞋia ta akwala asoa goꞋo Ꞌi buria nia ka fiꞋi leka Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bore ma na ngwae neꞋeri nia ka fata Ꞌuri, “NoaꞋa, nau ku amasi kaumulu noaꞋa kamu kasi lui nau laꞋu. Iawe nia kwatea na raoꞋa nau ku leka leꞋa liu. Nau ku gani kamu muke alaꞋani nau nai oli siana ngwae ꞋaꞋana nau.” ");
INSERT INTO kwf_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Sui kira ka fata Ꞌuri, “ꞋOke mango basi. Kulu saea sariꞋi neꞋe ke leka maꞋi fasi Ꞌiri kulu ke rongoa manataꞋanga nia.” ");
INSERT INTO kwf_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","GoꞋo kera ka ri maꞋi Ꞌuana, ma kera ka fata Ꞌuri fuana, “Na ngwae neꞋe oga ke oli Ꞌi taꞋena. ꞋOko saeleꞋa goꞋo Ꞌamu neꞋe Ꞌoke leka naꞋa faꞋinia niniꞋari?” Ma nia ka fata Ꞌuri, “ꞋIu, nia leꞋa goꞋo ana.” ");
INSERT INTO kwf_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ma kera ka alaꞋania Ꞌi Rebeka ka leka faꞋinia na ngwae neꞋeri faꞋinia ngwae nia ki. Ma kira ka kwatea taꞋi kini rao neꞋe lia maꞋi sulia eta ana kaidaꞋi nia tiꞋitiꞋi ka leka faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ana kaidaꞋi nia salisali fuana faꞋasilana kula neꞋeri, na fuuꞋi ngwae nia kira ka faꞋaleꞋa kika fata Ꞌuri, “Ngwaingwaena kamu, kaimili foꞋo fasi Ꞌiri Ꞌoke baꞋa raꞋe maꞋi ko teꞋa fuana ngwae Ꞌoro liu ki neꞋe liufia na mole ana ngwae. Ma kwalafa Ꞌoe kike baꞋa liufia fanoa doe malimae kira ki.” ");
INSERT INTO kwf_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ma Ꞌi Rebeka faꞋinia kini rao ꞋoꞋo nia ki, kira ka leka faꞋinia, kira ka raꞋe fafona kamel ki, ma kira ka donga ngwae rao sa Abraham, ma kira ka leka naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ma ana kaidaꞋi neꞋeri, sa Aesak nia ka faꞋasia na maꞋe busu ana kafo neꞋe satana, “MaꞋe busu God mauri neꞋe nia lia maꞋi fuaku.” Ma sa Aesak ka leka tua Ꞌi Negev ana abaꞋi kula Ꞌi gwauna fanoa Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ana taꞋi asoa, kaidaꞋi sina ka suꞋu naꞋa, nia ruꞋu Ꞌi maa ka leka liliu, ma nia ka lisia ti kamel kira leka maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ana kaidaꞋi Ꞌi Rebeka nia lisia, nia lofo Ꞌi ano faꞋasia kamel nia, ");
INSERT INTO kwf_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ma nia ka saefiloa ngwae ni rao sa Abraham ka Ꞌuri, “Sa tai neꞋe satana ngwae loꞋoko nia leka maꞋi?” Ma na ngwae ni rao neꞋeri ka fata Ꞌuri, “Na ngela ngwane ngwae ꞋaꞋana nau loꞋoko nia.” GoꞋo Ꞌi Rebeka ka ngali ifi ka sufafia maana faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","KaidaꞋi kira leka kika dao siana sa Aesak na ngwae ni rao neꞋeri ka alaꞋa sulia fuana ma ka faꞋarongo Ꞌani ru ki taꞋifau neꞋe fuli maꞋi loꞋoba. ");
INSERT INTO kwf_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ma sa Aesak ka baꞋea sariꞋi neꞋeri ka tua naꞋa saena gwaurau neꞋe teꞋa ni Ꞌi Sera neꞋe tua ana Ꞌi naꞋo. Ma sa Aesak ka korea naꞋa Ꞌi Rebeka, ma ka kwaima liu ana kini neꞋe, ma na kwaimanatai Ꞌanga sa Aesak Ꞌuana teꞋa nia ka sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Sa Abraham nia korea laꞋu ta Ꞌafe matamata neꞋe satana Ꞌi Ketura. ");
INSERT INTO kwf_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ꞋAfe neꞋe ka faꞋafuta ngwaꞋi ngela ngwane na satada neꞋe sa Simran, sa Joksan, sa Medan, sa Midian, sa Isbak, ma sa Suaha. ");
INSERT INTO kwf_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Sa Joksan neꞋe na maꞋa sa Seba ma sa Dedan, ma ngwae neꞋe futa maꞋi ana fufuꞋi ngwae sa Dedan neꞋe kira ana kwalafa sa Asuru, ma na kwalafa sa Letus faꞋinia kwalafa sa Leum. ");
INSERT INTO kwf_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Sa Midian neꞋe ngela nia ki neꞋe sa Efaha, sa Efa, sa Hanok, sa Abida, ma sa Eldaha, na kwalafa neꞋeri ki neꞋe futa ana Ꞌi Ketura. ");
INSERT INTO kwf_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ma sa Abraham ka alaꞋa totongaꞋi nia ke baꞋa alua ru ki taꞋifau neꞋe nia toꞋo ani saena limana ngela nia sa Aesak. ");
INSERT INTO kwf_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bore ma kaidaꞋi nia tua Ꞌua, nia kwatea na kwateꞋa ki fuana ta ngela ngwane ana ba nia alua ana ta ro Ꞌafe ana. Ma nia ka kwateda kwau kira ka leka tau naꞋa ana ta bali kula Ꞌi fanelana sina neꞋe tau faꞋasia kula sa Aesak tua ana. ");
INSERT INTO kwf_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Sa Abraham nia ngwaro liu naꞋa ana kaidaꞋi nia mae, na anona ka leka tua faꞋinia anona maꞋa nia faꞋida ba kira mae naꞋa Ꞌi naꞋo. Nia toꞋo ana maurilana leꞋa, ma kaidaꞋi nia mae, nia dao naꞋa ana taꞋi talangaꞋi faꞋi ngali ma fiu akwala ma lima faꞋi ngali. ");
INSERT INTO kwf_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Na ro ngela neꞋe nia ki, sa Aesak ma sa Ishmael kera ka kwaiatoa Ꞌi saena faoda neꞋe satana Ꞌi Makpela neꞋe tua ana taꞋi afu ano neꞋe nia Ꞌi fanelana sina ana Ꞌi Mamre. KaidaꞋi Ꞌi naꞋo, afu ano neꞋe ru sa Efron, taꞋi ngwae ana fuuꞋi ngwae sa Het, na satana maꞋa nia neꞋe sa Soha. ");
INSERT INTO kwf_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bore ma Ꞌi buri Ꞌana neꞋe sa Abraham folia ano neꞋeri ana ngwae neꞋe, na ano neꞋeri ru nia naꞋa. Ana kula neꞋeri naꞋa neꞋe kera kwaiatoa nonina sa Abraham, ma ana faoda neꞋeri logo neꞋe kira kwaiatoa logo Ꞌi Sera saena Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","KaidaꞋi Ꞌi buira neꞋe sa Abraham nia mae naꞋa, ngela nia sa Aesak ka leka ka saungaꞋinia naꞋa fanoa nia karangia maꞋe busu kafo Ꞌi Bere Lahai Roe. Ana kaidaꞋi neꞋeri God ka faꞋaleꞋa sa Aesak. ");
INSERT INTO kwf_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","13","Na ꞋaꞋemae sulia kwalafa sa Ishmael nia Ꞌuri: Sa Ishmael nia ngela sa Abraham, ma teꞋa nia neꞋe Ꞌi Hega kini Ꞌi Ejipt nia na kini rao Ꞌi Sera. Sa Ishmael toꞋo ana ngela ngwane ki, satada neꞋe sa Nebaeot, sa Kedar, sa Adbeel, sa Mibsam, ");
INSERT INTO kwf_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","sa Misma, sa Duma, sa Masa, ");
INSERT INTO kwf_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","sa Hadad, sa Tema, sa Jaturu, sa Nafis, ma sa Kedema. ");
INSERT INTO kwf_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Na fufuꞋi ngwae neꞋe futa ana akwala ma ro ngela sa Ishmael ki, kira saea satana mae fanoa ki ma fanoa neꞋe kira leka tua Ꞌani ki ka donga logo satana akwala ma ro ngela neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ꞋUnaꞋeri sa Ishmael ka mae naꞋa, ma anona ka leka tua faꞋinia anona maꞋa nia faida ba kira mae Ꞌi naꞋo. Ma kaidaꞋi nia mae ana nia dao ana taꞋi talangaꞋi fai ngali ma uulu akwala ma fiu fai ngali. ");
INSERT INTO kwf_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Na olitana sa Ishmael noaꞋa kira Ꞌiri tua faꞋinia kwalafa sa Abraham, kira tua ana ano Ꞌi safitana ro fanoa Ꞌi Havila ma Ꞌi Suru, bali ana fanelana sina ana Ꞌi Ejipt, ana tala neꞋe ki faꞋasia Ꞌi Ejipt ma ki leka Ꞌuana Ꞌi Asiria. ");
INSERT INTO kwf_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Na ꞋaꞋemae sulia kwalafa sa Aesak, na ngela sa Abraham, nia Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","KaidaꞋi sa Aesak nia korea Ꞌi Rebeka, nia tua naꞋa sulia fai akwala faꞋi ngali ki. ꞋI Rebeka neꞋe ngela kini sa Betuel, taꞋi ngwae Ꞌi Mesopotemia ana abaꞋi kula kira saea Ꞌani Ꞌi Aram. Ma sa Laban na sasina Ꞌi Rebeka. ");
INSERT INTO kwf_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Sa Aesak ka foꞋosia Iawe duꞋungana Ꞌafe nia ꞋabaraꞋa, ma Iawe ka rongoa foꞋongaꞋa nia. KaidaꞋi neꞋeri Ꞌafe neꞋe ka ina naꞋa ma nia ke baꞋa faꞋafuta ro ꞋiꞋiu ki. ");
INSERT INTO kwf_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bore ma kaidaꞋi kera noaꞋa kasi futa Ꞌua, kera diꞋia neꞋe kera ka fuꞋa Ꞌi saena sirana teꞋa keraꞋa, ꞋunaꞋeri Ꞌi Rebeka ka fata Ꞌuri, “FaꞋuta? Tae neꞋe sasi ma nau ku Ꞌuri reala.” Sui nia ka saefilo Iawe Ꞌuana ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Sui Iawe ka fata Ꞌuri fuana, “Ro ngela ki neꞋe tua saena siramu, na ai buri ke baꞋa ngasingasi liufia na ai etaeta. Kera ke baꞋa koꞋo bora fuana ro fufuꞋi ngwae matamata ki. Na fufuꞋi ngwae ana ai buri ke baꞋa ke baꞋa ngasingasi liufia na fufuꞋi ngwae ana ai etaeta.” ");
INSERT INTO kwf_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ꞋUnaꞋeri nia ka dao naꞋa ana madamo fuana kini neꞋeri fuana faꞋafutalana ngela, goꞋo nia ka faꞋafuta ro ngela ngwane nia ki neꞋe kera ro ꞋiꞋiu ki. ");
INSERT INTO kwf_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","26","Na faꞋinaꞋonaꞋo nonina meo ma ka rangoꞋa taꞋifau diꞋia ifi kira saungaꞋinia Ꞌani ꞋuꞋuila nanigot, ꞋunaꞋeri kira ka saea Ꞌania sa Esau. Ana kaidaꞋi kera futa, na ngela Ꞌi buri dau ngasi maꞋi ana Ꞌaena ngela Ꞌi naꞋo, ꞋunaꞋeri kera ka saea Ꞌani sa Jakob. Ana kaidaꞋi neꞋeri sa Aesak nia tua naꞋa sulia ono akwala faꞋi ngali ki. ");
INSERT INTO kwf_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","KaidaꞋi ro ngela ngwane neꞋe ki doe maꞋi, sa Esau sai liu ana luluꞋa Ꞌuana ru kwasi ꞋaeꞋaela ki, ma nia noaꞋa kasi oga tuaꞋa Ꞌi fanoa, nia oga lala tuaꞋa saena masuꞋua. Bore ma sa Jakob nia ngwae nene goꞋo Ꞌana, ma kaidaꞋi Ꞌoro nia oga liua lala tuaꞋa Ꞌi fanoa. ");
INSERT INTO kwf_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ana kaidaꞋi Ꞌoro sa Aesak nia kwaima ana sa Esau, osiꞋana nia oga liua Ꞌanilana fasina ru kwasi ꞋaeꞋaela ki, bore ma Ꞌi Rebeka kwaima lala ana sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ana taꞋi asoa, kaidaꞋi sa Esau leka lulua ru kwasi ꞋaeꞋaela ki, sa Jakob nia tua goꞋo Ꞌana Ꞌi luma, ka saungaꞋi fanga goꞋo ana Ꞌania faꞋi bin meo ki. KaidaꞋi sa Esau nia oli maꞋi nia ka fiolo liu naꞋa, ");
INSERT INTO kwf_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ma nia ka fata Ꞌuri ana sa Jakob, “Se, nau ku fiolo liu naꞋa kwa! ꞋOke ngalia maꞋi ꞋaliꞋali na sufusufu meo neꞋana.” Nia neꞋe ngwae ki kira ka saea Ꞌani sa Idom. ");
INSERT INTO kwf_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Bore ma sa Jakob ka fata Ꞌuri, “Si diꞋia Ꞌoko fata alangaꞋi ma Ꞌoko saea Ꞌoke kwate taꞋifau naꞋa ngwaluduꞋa Ꞌoe ki sulia ꞋaeꞋo na faꞋinaꞋonaꞋo fuaku, diꞋia ꞋunaꞋeri nia leꞋa nai baꞋa kwate ti fanga fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","GoꞋo sa Esau ka fata Ꞌuri, “LeꞋa, nia leꞋa goꞋo Ꞌana. Karangi nau ku maelia naꞋa fioloꞋanga neꞋe. DiꞋia nau ku mae, ru neꞋe ki kasi Ꞌafi nau goꞋo ne.” ");
INSERT INTO kwf_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Bore ma sa Jakob fata Ꞌuri, “LeꞋa goꞋo Ꞌana, bore ma etaeta Ꞌoke sasia ta taꞋi fata alangaꞋinga ngasingasiꞋa neꞋe gwaꞋi ngwaluda neꞋe Ꞌoko toꞋo naꞋa ana niniꞋari, nauꞋa naꞋa neꞋe nai ngalia laꞋu.” Sui sa Esau ka sasia taꞋi fata alangaꞋinga ngasingasiꞋa fuana sa Jakob ma nia ka fata Ꞌuri, “Sa Jakob naꞋa neꞋe ke baꞋa toꞋo ana ru ki taꞋifau neꞋe faꞋinaꞋonaꞋo goꞋo neꞋe ka toꞋo ani faꞋasia maꞋa nia.” ");
INSERT INTO kwf_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","GoꞋo sa Jakob ka ngalia naꞋa maꞋi fanga ki faꞋinia beret ma ka kwate fuana sa Esau. Ru neꞋeri faꞋataꞋi leꞋa naꞋa ana neꞋe sa Esau noaꞋa Ꞌiri manata kulukulufaꞋa goꞋo ana na gwaꞋi ngwaluda sulia nia na faꞋinaꞋonaꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ana kaidaꞋi sa Aesak tua Ꞌi Bere Lahai Roe, taꞋi fioloꞋa doe liu ka dao fafida, ka diꞋia logo kaidaꞋi ana ꞋafitaꞋi Ꞌanga ba dao fafida Ꞌi naꞋo ana kaidaꞋi sa Abraham tua ana. Sui sa Aesak ka leka Ꞌuana Ꞌi Gerara taꞋi kula ana kula ngwaꞋi toꞋa Ꞌi Filistia ki. Nia leka ka tua faꞋinia tatalafaꞋa sa Abimelek, nia neꞋe tatalafaꞋa kira. ");
INSERT INTO kwf_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","KaidaꞋi neꞋeri Iawe ka dao maꞋi siana sa Aesak ka fata Ꞌuri fuana, “ꞋOe kosi koso toli ko tua Ꞌi Ejipt. ꞋOke baꞋa leka tua ana kula neꞋe nai baꞋa saea fuamu. ");
INSERT INTO kwf_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ꞋOke tua basi Ꞌamu Ꞌuri ana kula neꞋe. Nai baꞋa tua faiꞋiniꞋo, ma nai baꞋa faꞋaleꞋa Ꞌoe. Ma nai baꞋa kwatea ano neꞋe ki fuamu, ma ngela neꞋe ke baꞋa futa maꞋi ana kwalafaꞋa Ꞌoe ki logo. Nai dau nama Ꞌaku ana alangaꞋinga ba nau ku sasia faꞋinia maꞋa Ꞌoe sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na ngwaꞋi ngela neꞋe kike baꞋa futa maꞋi ana kwalafaꞋa Ꞌoe kike baꞋa Ꞌoro liu, diꞋia na bulubulu na salo. Nai baꞋa kwate ano neꞋe fuada. Nai baꞋa faꞋaleꞋa kwalafa ki taꞋifau ana magalia sulia kwalafa Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nau ku dau ana alangaꞋinga nau, osiꞋana Ꞌi naꞋo sa Abraham kwairoꞋoi aku, ma ka leka sulia na taki nau ki, ma fatalaku.” ");
INSERT INTO kwf_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ꞋUnaꞋeri sa Aesak ka leka naꞋa nia ka tua naꞋa Ꞌi Gerara. ");
INSERT INTO kwf_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","KaidaꞋi ngwae ana fanoa neꞋeri ki kira lisia Ꞌi Rebeka kira ka saefilo Ꞌuri ana sa Aesak, “FaꞋuta? ꞋUri ma kini neꞋe Ꞌafe Ꞌoe niniꞋa?” Ma nia ka fata Ꞌuri fuada, “NoaꞋa, nia na ngwaingwaena nau.” Nia sofongaꞋi ꞋunaꞋeri ana sulia kini neꞋe lisilana leꞋa liu mala, ma nia ka maꞋu, Ꞌasu Ꞌubani ngwaꞋi toꞋa ana fanoa neꞋeri kira ka saungia, ma ka ngalia Ꞌafe nia. ");
INSERT INTO kwf_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sa Aesak faꞋinia Ꞌafe nia, kera taꞋi tua ka tau tiꞋitiꞋi ana fanoa neꞋeri. Ana taꞋi faꞋi asoa sa Abimelek na tatalafaꞋa nia tua Ꞌana Ꞌi luma nia, nia ka kelefai sulia Ꞌolofolo, nia ka lisia sa Aesak nia lolofafia Ꞌafe nia. ");
INSERT INTO kwf_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Sui nia ka ri Ꞌuana sa Aesak ka leka maꞋi siana, nia ka fata Ꞌuri fuana, “Se, faꞋuta neꞋe Ꞌoko saea fasi Ꞌafe neꞋe na ngwaingwaena Ꞌoe kwa? Na Ꞌafe Ꞌoe goꞋo niniꞋa.” Sui sa Aesak ka fata Ꞌuri, “Nau ku fiꞋa kira kata saungi nau ma kika ngalia Ꞌafe nau.” ");
INSERT INTO kwf_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Sui sa Abimelek ka fata Ꞌuri, “FaꞋuta neꞋe Ꞌoko sasia ru neꞋe aimili kwa? Lisia basi! Nia talangwaraꞋu goꞋo Ꞌana fuana ta taꞋi ngwae ana ngwae nau ki neꞋe ke leka teo faꞋinia Ꞌafe Ꞌoe. Ma diꞋia nia ꞋunaꞋeri nia ke baꞋa taꞋa fuaimili, bore ma roraꞋa Ꞌoe naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ma nia ka fata ngasingasiꞋa fuana ngwae ki ka Ꞌuri, “DiꞋia ta ngwae nia sasi ta ru ka taꞋa ana ngwae neꞋe nama ana Ꞌafe nia, nia ke baꞋa mae.” ");
INSERT INTO kwf_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ana faꞋi ngali neꞋeri nama neꞋe sa Aesak oꞋolia na oꞋola nia ana kula neꞋeri. Iawe nia faꞋaleꞋa sa Aesak. Fuana ta taꞋi magana witi neꞋe nia fasiꞋi ki, nia loia maꞋi 100 magana witi. ");
INSERT INTO kwf_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Na raoꞋa nia ki ka leka leꞋa liu, ma nia taꞋi ngwae toꞋoru liu. ");
INSERT INTO kwf_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ma duꞋungana neꞋe nia toꞋo ana sipsip Ꞌoro ki, ma buluka Ꞌoro ki, ma ngwae ni rao Ꞌoro ki, ꞋunaꞋeri ngwaꞋi toꞋa Ꞌi Filistia kira ka oga guꞋuguꞋu liu fuana. ");
INSERT INTO kwf_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ꞋI naꞋo kaidaꞋi maꞋa nia mauri Ꞌua na ngwae rao maꞋa nia ki kira Ꞌilia na kilu kafo ki kwailiu ana kula neꞋeri, bore ma ngwae Ꞌi Filistia ki kira oga guꞋuguꞋu liu, kira ka leka kika Ꞌili fafia kilu kafo neꞋeri ki laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ꞋUnaꞋeri sa Abimelek na tatalafaꞋ ka fata Ꞌuri ana sa Aesak, “ꞋAeꞋo niniꞋa na ngwae ngasingasiꞋa liu mala ma Ꞌoko liufi kaimili taꞋifau naꞋa. ꞋOke leka faꞋasia kula neꞋe naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Sui sa Aesak ka faꞋasia kula neꞋeri, nia ka leka sasia na fanoa nia ana oteotea Ꞌi Gerara. ");
INSERT INTO kwf_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aia, na kilu kafo neꞋe teo Ꞌi neꞋeri ki, maꞋa nia sa Abraham neꞋe ꞋiliꞋi, bore ma Ꞌi buri Ꞌana neꞋe nia mae naꞋa, na ngwaꞋi toꞋa Ꞌi Filistia ki kira ka Ꞌili fafiꞋi laꞋu. ꞋI neꞋeri sa Aesak ka oli ma ka Ꞌilida laꞋu, ma nia ka saea nama Ꞌani sata Ꞌi ru neꞋe maꞋa nia eta saeda ꞋaniꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","KaidaꞋi neꞋeri na ngwae rao sa Aesak ki kira ka Ꞌilia ta taꞋi kilu kafo saena ote neꞋeri ma kira dao toꞋona kafo leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bore ma ngwaꞋi toꞋa neꞋe kira folo Ꞌusia sipsip kira ki Ꞌi Gerara kira ka olisuꞋusuꞋu faꞋinia kilu kafo neꞋeri ki, ma kira ka fata Ꞌuri fuana ngwae rao sa Aesak ki, “Kafo neꞋe ru kami niniꞋa.” GoꞋo sa Aesak ka faꞋasata kilu kafo neꞋeri Ꞌani Ꞌi Esek neꞋe fada Ꞌani “OlisuꞋusuꞋu.” ");
INSERT INTO kwf_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","KaidaꞋi ngwae nia ki kira Ꞌilia laꞋu ta kilu kafo, kira ka olisuꞋusuꞋu logo faꞋinia. Nia ka saea logo kilu kafo neꞋeri Ꞌani Sitna nama FuꞋanga. ");
INSERT INTO kwf_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Sui laꞋu, nia ka Ꞌidua fanoa nia ka Ꞌidu tiꞋitiꞋi laꞋu faꞋasia kula neꞋeri, ma ngwae ni rao nia ki kira ka Ꞌilia laꞋu ti kilu kafo. Ma ana kaidaꞋi neꞋeri kira ka Ꞌiri olisuꞋusuꞋu naꞋa. Sui ma ka saea kilu kafo neꞋeri Ꞌani Rehobot neꞋe fada Ꞌani “Kula Abitako.” Ma nia ka fata Ꞌuri, “KaidaꞋi neꞋe Iawe kwatea naꞋa kula doe neꞋe fuakulu. TaꞋena raoꞋa kulu ki ke baꞋa leka leꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Buri Ꞌana neꞋe sa Aesak nia faꞋasia laꞋu kula neꞋeri, nia ka leka tua ana kula kira saea Ꞌani Bereseba. ");
INSERT INTO kwf_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ana kaidaꞋi nia dao Ꞌi neꞋeri, Iawe ka dao maꞋi siana saena rodo ka fata Ꞌuri fuana, “NauꞋa God ana maꞋa Ꞌoe sa Abraham. ꞋOe kosi maꞋu, osiꞋana nau ku tua faꞋiniꞋo. Nau ku sasia taꞋi fata alangaꞋinga faꞋinia sa Abraham neꞋe kwairoꞋoi aku. Ma osiꞋana fata alangaꞋi neꞋeri, nai baꞋa faꞋaleꞋa Ꞌoe, ma nau ku kwatea kwalafa Ꞌoe kike Ꞌoro liu.” ");
INSERT INTO kwf_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ma ana kula neꞋe nia Ꞌuia taꞋi sulufaua fuana Iawe ma nia foꞋosia Ꞌani satana Iawe. Ma nia ka sasia naꞋa fanoa nia ana kula neꞋeri, ma ngwae ni rao nia ki kira ka Ꞌilia laꞋu ta kilu kafo fuada. ");
INSERT INTO kwf_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aia na tatalafaꞋa sa Abimelek faꞋinia sa Ahusat, na ngwae faꞋamanata nia, ma sa Fikol, na faꞋinaꞋonaꞋo ana fuani Ꞌoro nia, kira faꞋasia Ꞌi Gerara kira leka fuana lisilana sa Aesak. ");
INSERT INTO kwf_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ꞋUnaꞋeri sa Aesak ka saefilo Ꞌuri ada, “FaꞋuta neꞋe kamu ka leka maꞋi fuana lisilaku re! KaidaꞋi ba sui, kaumulu ka Ꞌiri oga nau, ma kaumulu ka lali nau faꞋasia kula kamu.” ");
INSERT INTO kwf_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","GoꞋo kira ka fata Ꞌuri, “NiniꞋari kaimili saiana neꞋe Iawe nia tua faꞋiniꞋo. Ma kaimili ka manata Ꞌuri, nia leꞋa fuamili kaimili ka sasia ta fata alangaꞋinga ngasingasiꞋa faꞋiniꞋo neꞋe noaꞋa kulu kasi fuꞋalikulu. Kaimili oga Ꞌoke fata alangaꞋi Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","NoaꞋa Ꞌoe kosi faꞋali kaimili, diꞋia Ꞌi naꞋo ba kaimili Ꞌiri faꞋaliꞋo goꞋo. ꞋI naꞋo ba kaimili leꞋa fuamu. Ma kaidaꞋi Ꞌoko faꞋasi kaimili, noaꞋa kami kasi faꞋaliꞋo goꞋo. Ma ana kaidaꞋi neꞋe nia madako neꞋe Iawe nia faꞋaleꞋa Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Sui sa Aesak ka saungaꞋinia taꞋi fafangaꞋa fuana kira ka fanga fiku faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ꞋOfodangi laꞋa bilabila Ꞌua ana asoa Ꞌi buri, niaꞋa faꞋinia tatalafaꞋa neꞋeri, kera ka sasia naꞋa alangaꞋinga ngasingasiꞋa Ꞌi maana God neꞋe noaꞋa kera kasi sasia ta mae. Sui sa Aesak ka saea alaꞋanga Ꞌani olioliꞋa ana tatalafaꞋa neꞋeri faꞋinia ngwae nia ki, ma kira ka oli Ꞌi fanoa kira, ma kira taꞋifau kira ka maꞋe ngwane leꞋa laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ma ana asoa neꞋe nama na ngwae rao sa Aesak ki kira Ꞌilia taꞋi kilu kafo, ma kira ka leka maꞋi, kira ka faꞋarongoa Ꞌani kilu kafo neꞋeri, ma kira ka fata Ꞌuri, “Kaimili dao naꞋa toꞋona kafo ana kula neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ꞋUnaꞋeri nia ka saea kilu kafo neꞋeri Ꞌani Seba neꞋe fada Ꞌani “AlangaꞋinga NgasingasiꞋa.” Nia neꞋe buri Ꞌana kira ka saea fanoa neꞋe tua karangia kilu kafo neꞋe Ꞌani Ꞌi Bereseba, neꞋe fada Ꞌani “ꞋI kilu kafo ana alangaꞋinga ngasingasiꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","KaidaꞋi sa Esau dao naꞋa ana fai akwala faꞋi ngali, nia ka korea ro Ꞌafe kwaita ki neꞋe futa ana kwalafa sa Het. Nia ngalia Ꞌi Judit na kini sa Beeri ma Ꞌi Basemat na kini sa Elon. ");
INSERT INTO kwf_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ru neꞋe kwatea sa Aesak ma Ꞌi Rebeka kera ka taꞋi noni taꞋa ma kera ka liadila liu. ");
INSERT INTO kwf_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ana kaidaꞋi neꞋe sa Aesak nia ngwaro liu naꞋa, ma na maana bore ka rodo, nia kasi lia naꞋa. TaꞋi asoa nia ri maꞋi Ꞌuana na faꞋinaꞋonaꞋo nia sa Esau ka leka maꞋi siana, ma nia ka fata Ꞌuri fuana, “Ngela nau Ꞌae.” Ma sa Esau ka fata Ꞌuri, “ꞋIu maꞋasi.” ");
INSERT INTO kwf_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","GoꞋo maꞋa nia ka fata Ꞌuri, “ꞋOko lisia naꞋa niniꞋa nau ku ngwaro naꞋa, ma nau ku sai ana nia kasi tau goꞋo nau ku mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nia leꞋa fuamu Ꞌoke ngali na basi ma maꞋe sima Ꞌoe, Ꞌoko leka lulua maꞋi ta ru ꞋaeꞋaela fasi Ꞌuri Ꞌoke doꞋofia maꞋi fasina nai Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ꞋOke doꞋofia diꞋia neꞋe nau ku oga, neꞋe nia rakufa mala sui Ꞌoko ngalia maꞋi fuaku. ꞋI buri Ꞌana neꞋe nau ku Ꞌania ka sui, nai baꞋa faꞋaleꞋa Ꞌoe Ꞌi naꞋo mala nau ku fiꞋi mae.” ");
INSERT INTO kwf_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ꞋUnaꞋeri kaidaꞋi sa Aesak nia fata fuana sa Esau, na Ꞌafe nia Ꞌi Rebeka ka fafarongoa alaꞋanga neꞋeri. KaidaꞋi sa Esau leka kwau ka lulu sibolo, ");
INSERT INTO kwf_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ꞌi Rebeka ka fata Ꞌuri fuana sa Jakob na ruana ngela adaroꞋo, “Rongo basi! KaidaꞋi neꞋe goꞋo neꞋe nau ku rongoa maꞋa Ꞌoe saea fuana ngwae futa Ꞌoe ");
INSERT INTO kwf_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ka fata Ꞌuri, ‘ꞋOke leka lulua maꞋi ta sibolo ko doꞋofia maꞋi fuaku. ꞋI buri Ꞌana neꞋe nau ku Ꞌania ka sui nai baꞋa faꞋaleꞋa Ꞌoe Ꞌi maana Iawe mala nau ku fiꞋi mae. ");
INSERT INTO kwf_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ngela nau Ꞌae, Ꞌoke rongo leꞋa fuana alaꞋalaku, ma Ꞌoko sasi diꞋia neꞋe nau ku saea fuamu. ");
INSERT INTO kwf_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ꞋOke leka ana kula loꞋoko na nanigot kulu ki tua ana, ma Ꞌoko efoa ta ro nanigot tiꞋitiꞋi neꞋe figula leꞋa, ma Ꞌoko ngalia maꞋi fasi Ꞌiri nai doꞋofia fasina ka leꞋa mala diꞋia neꞋe maꞋa Ꞌoe oga liua. ");
INSERT INTO kwf_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sui Ꞌoko leka kwatea fuana maꞋa Ꞌoe fasi Ꞌiri nia ke faꞋaleꞋa Ꞌoe mala nia ka fiꞋi mae.’” ");
INSERT INTO kwf_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bore ma sa Jakob ka fata Ꞌuri, “TeꞋasi kwa! ꞋOko saiana sa Esau na nonina rangoꞋa taꞋifau, bore ma nau ku Ꞌiri toꞋo ana. ");
INSERT INTO kwf_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Si diꞋia maꞋa nau nia sama toꞋo aku, nia ke baꞋa sai goꞋo aku neꞋe nau ku soke. ꞋUnaꞋeri noaꞋa nia kasi faꞋaleꞋa nau, bore ma nia ke baꞋa kwatea ru taꞋa ki ke dao toꞋoku.” ");
INSERT INTO kwf_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","GoꞋo teꞋa nia ka fata Ꞌuri fuana, “Ngela nau Ꞌae, diꞋia nia sasia ru taꞋa ki ka dao toꞋomu, alaꞋania ru taꞋa neꞋeri ke leka maꞋi fuaku talaku. ꞋOke sasia lala ru nau ku saea fuamu. ꞋOke leka ngalia maꞋi ta ro nanigot.” ");
INSERT INTO kwf_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ꞋUnaꞋeri sa Jakob ka leka saungia ro nanigot neꞋeri ki naꞋa, nia ka ngalida maꞋi ka kwatea fuana teꞋa nia, goꞋo teꞋa nia ka doꞋofia ka diꞋia neꞋe maꞋa nia oga. ");
INSERT INTO kwf_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sui teꞋa nia ka ngalia toro leꞋa sa Esau ki neꞋe teo Ꞌi luma, ka ngaliꞋi maꞋi sa Jakob ka ruꞋufiꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Sui nia ka ngalia ꞋuꞋuila nanigot neꞋeri ka alua Ꞌi limana ma Ꞌi luana logo kula noaꞋa ta ifu ana. ");
INSERT INTO kwf_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sui, nia ka ngalia fasina nanigot ma na afu beret nia fiꞋi doꞋofiꞋi goꞋo, ka kwateꞋe kwau fuana sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sui sa Jakob ka ngaliꞋi kwau fuana maꞋa nia ma ka fata Ꞌuri, “MaꞋasi kwa!” GoꞋo maꞋa nia ka fata Ꞌuri, “ꞋIu, ꞋaeꞋo sa tai niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","GoꞋo sa Jakob ka fata Ꞌuri, “NauꞋa sa Esau, na ngela Ꞌi naꞋo Ꞌoe. Nau ku sasia ka sui naꞋa tae ba Ꞌoko saea fuaku. Nia naꞋa ne na sibolo ki nau ku ngalia maꞋi. Nau ku amasiꞋo Ꞌoke gwauru ko Ꞌania, fasi Ꞌiri Ꞌoke faꞋaleꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","KaidaꞋi neꞋeri maꞋa nia alaꞋa Ꞌuri, “Ngela nau Ꞌae, Ꞌoko ꞋaliꞋali liu! ꞋOko dao goꞋo faꞋuta toꞋona ru ꞋaeꞋaela neꞋe niniꞋa?” Ma nia ka fata Ꞌuri, “Iawe na God Ꞌoe, niniꞋa Ꞌafi nau fuana daoꞋa toꞋona.” ");
INSERT INTO kwf_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Sui maꞋa nia ka fata Ꞌuri, “Ngela nau Ꞌae, ꞋaeꞋo sa Esau mamana naꞋa niniꞋa? ꞋOke leka karangi maꞋi Ꞌiri nai sama toꞋomu.” ");
INSERT INTO kwf_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","GoꞋo sa Jakob ka leka karangia maꞋa nia, ma nia ka sama toꞋona ma ka fata Ꞌuri, “Nau ku rongoa lingamu diꞋia lingana sa Jakob, bore ma limamu neꞋe limana sa Esau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nia noaꞋa kasi sai goꞋo ana ngwae neꞋe sa Jakob, duꞋungana ifu neꞋe ki ana nanigot neꞋe teo kwailiu Ꞌi limana nia diꞋia nama limana sa Esau. KaidaꞋi nia salisali fuana faꞋaleꞋalana, ");
INSERT INTO kwf_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nia saefiloa taꞋi ru laꞋu ka Ꞌuri, “ꞋAeꞋo sa Esau mamana naꞋa niniꞋa?” Ma sa Jakob ka olisi Ꞌuri ana, “ꞋIu maꞋasi. NauꞋa naꞋa niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","KaidaꞋi neꞋeri maꞋa nia ka fata Ꞌuri, “Ngela nau Ꞌae, Ꞌoko ngalia maꞋi na sibolo neꞋana nai Ꞌania. Ma buri Ꞌana, kaidaꞋi nau ku fanga ka sui, nau kui baꞋa faꞋaleꞋaꞋo.” Sa Jakob ka ngalia maꞋi fanga fuana maꞋa nia. Ma Ꞌi buri nia ka ngalia logo maꞋi ta waen ma maꞋa nia Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sui, sa Aesak ka fata Ꞌuri fuana, “Ngela nau Ꞌae, leka maꞋi fuana nonoꞋilana nauꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ma kaidaꞋi nia leka maꞋi fuana nonoꞋilana maꞋa nia, maꞋa nia ka moko saiana toro nia, sui nia ka faꞋaleꞋa naꞋa. Nia fata Ꞌuri, “Ngela nau Ꞌae, na mokolana toro Ꞌoe nia leꞋa liu ka diꞋia mokolana ta oꞋola neꞋe Iawe nia faꞋaleꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","AlaꞋania God ka kwatea uta Ꞌoro fuana faꞋaisila lana ano, fasi Ꞌiri ano ka leꞋa ma ka kwatea fanga Ꞌoro leꞋa. AlaꞋania nia ka kwatea fuamu fuaꞋi ai leꞋa ki ana Ꞌai grep fuana waen Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","AlaꞋania fuuꞋi ngwae Ꞌoro ki kira ke rao fuamu ma kike roꞋosuliꞋo. ꞋOke gwaungaꞋi fafia ngwaefuta Ꞌoe ki ma kike roꞋosuliꞋo. God ke baꞋa sasia ru leꞋa ki fuana na ngwae neꞋe kira sasia ru leꞋa ki fuamu. Bore ma nia ke baꞋa kwaꞋikwaꞋi silolo na ngwae neꞋe kira faꞋali Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ana kaidaꞋi sa Aesak faꞋaleꞋa sa Jakob ka sui goꞋo, sa Jakob ka tataꞋe, ka leka naꞋa Ꞌana Ꞌi maa. Bore ma tona goꞋo faꞋinaꞋonaꞋo sa Esau ba leka kwaꞋi sibolo maꞋi, nia oli naꞋa maꞋi luma. ");
INSERT INTO kwf_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nia ka duꞋafia fanga neꞋeri ki diꞋia neꞋe Ꞌani toꞋonilana rakufa liu, sui nia ka ngalia maꞋi fuana maꞋa nia, goꞋo nia ka fata Ꞌuri, “MaꞋasi kwa, nia naꞋa ne na sibolo nau ku ngaliꞋi maꞋi ki. Nau ku amasiꞋo Ꞌoke gwauru ko fanga naꞋa, fasi Ꞌiri Ꞌoke faꞋaleꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Bore ma maꞋa nia ka lidi Ꞌuri ana, “Ai, ꞋaeꞋo sa tai niniꞋa?” Ma nia ka fata Ꞌuri, “NauꞋa sa Esau niniꞋa ngela Ꞌi naꞋo Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ꞋUnaꞋeri maꞋa nia ka tona ka lebelebe liu naꞋa, ma ka fata Ꞌuri, “Bore ma sa tai mo neꞋe saungia ru ꞋaeꞋaela ka duꞋafia ka sui niniꞋa ka ngalia naꞋa maꞋi fuaku? Nau ku fanga ka fiꞋi sui goꞋo ne, kaidaꞋi Ꞌoko Ꞌiri ruꞋu maꞋi Ꞌua. Ma nau ku faꞋaleꞋa niaꞋa, ma na faꞋaleꞋanga neꞋeri ru nia firi naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","KaidaꞋi sa Esau rongoa alaꞋanga neꞋeri, nia ka kwaimanatai liu naꞋa, ma nia ka angi ka oꞋomae liu naꞋa, ma nia ka fata Ꞌuri, “MaꞋasi Ꞌae, ꞋOke faꞋaleꞋa nau logo maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bore ma maꞋa nia ka fata Ꞌuri, “Na ngwaefuta Ꞌoe leka maꞋi ka Ꞌoso leꞋa goꞋo aku. Ma nia ka ngali na faꞋaleꞋanga ba Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Sui sa Esau ka fata Ꞌuri, “Nia ne ruana faꞋi kaidaꞋi naꞋa neꞋe nia aurafu nau, ma ka bili nau ana. ꞋUnaꞋeri neꞋe nia ka sata ana sa Jakob. Etaeta nia ngalia ka sui naꞋa gwaꞋi ngwaluda nau, sulia nau na faꞋinaꞋonaꞋo. Ma niniꞋari nia ka ngali taꞋifau laꞋu ana faꞋaleꞋanga nau. FaꞋuta? ꞋUri ma ta faꞋaleꞋanga noaꞋa Ꞌiri teo naꞋa Ꞌiri Ꞌoke kwatea fuaku?” ");
INSERT INTO kwf_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ꞋUnaꞋeri maꞋa nia ka fata Ꞌuri, “Nau ku kwatea sasimu ka ꞋaꞋana fuamu, ma fuuꞋi ngwae Ꞌoe faꞋinia ngelamu neꞋe ke baꞋa futa maꞋi buri, kira ke baꞋa rao fuana. Ma nau ku kwate fanga ma waen fuana. Ngela nau Ꞌae, noaꞋa ta ru Ꞌiri ore naꞋa neꞋe nai baꞋa kwatea fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Bore ma sa Esau ka Ꞌingoa laꞋu maꞋa nia ka saefilo Ꞌuri, “MaꞋasi, faꞋuta, Ꞌuri ma Ꞌoko toꞋo goꞋo ana taꞋi faꞋaleꞋanga baniꞋa? Nau ku amasiꞋo Ꞌoke faꞋaleꞋa nau logo?” Ma nia ka angi koko ka doe liu. ");
INSERT INTO kwf_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","MaꞋa nia ka fata Ꞌuri, “Ngela nau Ꞌae, fanoa Ꞌoe ke baꞋa tua tau faꞋasia na ano leꞋa, ma ka tau logo faꞋasia kula uta ka toꞋo ana. ");
INSERT INTO kwf_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ꞋOke baꞋa fuꞋa Ꞌani sele ni ofoꞋa Ꞌoe Ꞌiri Ꞌoke mauria. Ma Ꞌoke baꞋa rao naꞋa fuana sasimu. Bore ma kaidaꞋi Ꞌoko uu ngasingasiꞋa Ꞌusia, Ꞌoke baꞋa aloge goꞋo Ꞌamu faꞋasia, ma Ꞌoko faꞋasia goꞋo Ꞌamu.” ");
INSERT INTO kwf_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Buri Ꞌana sa Esau noaꞋa liu kasi oga naꞋa sa Jakob, osiꞋana maꞋa kera nia kwate taꞋifau naꞋa na faꞋaleꞋanga fuana sa Jakob. ꞋUnaꞋeri nia ka manata Ꞌuri, “Nia noaꞋa ka tau, maꞋa nau ke mae, ma kaimili ke baꞋa kwaimanatai ma mika angi Ꞌuana. Sui mala, nai baꞋa saungia ngwaefuta nau ka mae.” ");
INSERT INTO kwf_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","KaidaꞋi teꞋa kera rongoa neꞋe sa Esau naia ke saungia sa Jakob, nia ka ri maꞋi Ꞌuana sa Jakob ka leka maꞋi siana, ma nia ka fata Ꞌuri fuana, “Ngela nau Ꞌae, fafarongo basi. Na ngwaefuta Ꞌoe nia naia saungilamu. ");
INSERT INTO kwf_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","44","ꞋOke sasi sulia tae neꞋe nau ku saea fuamu. ꞋOke tafi Ꞌuana Ꞌi Haran. Ma Ꞌoke tua faꞋinia ngwaefuta nau sa Laban, leleka ka dao ana kaidaꞋi neꞋe manatana ngwaefuta Ꞌoe ka aroaro ma saetaꞋangaꞋa nia ka koso, ");
INSERT INTO kwf_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ma ka takadalafa na ru niniꞋa Ꞌoko sasia ana. Ana kaidaꞋi neꞋeri mala naꞋi baꞋa fiꞋi asungaꞋinia ta ngwae ni rao ka oli maꞋi faꞋiniꞋo Ꞌi neꞋe. Nia Ꞌiri leꞋa fuana neꞋe nai faꞋasia ro ngela nau ki ana taꞋi asoa neꞋeri nama.” ");
INSERT INTO kwf_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Buri Ꞌana Ꞌi Rebeka ka fata Ꞌuri fuana sa Aesak, “Nau ku Ꞌaila liu naꞋa Ꞌania ro kini niniꞋa ana fuuꞋi ngwae sa Het ki niniꞋa sa Esau koreda. Si diꞋia sa Jakob ke korea laꞋu ta kini ana fuuꞋi ngwae sa Het, sali nia leꞋa fuaku nai mae goꞋo aku.” ");
INSERT INTO kwf_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","3","Aia, sa Aesak ka ri Ꞌuana sa Jakob ka leka maꞋi ka lisia, ma nia ka alaꞋa totongaꞋi Ꞌuri fuana, “ꞋOe kosi korea ta kini Ꞌi neꞋe Ꞌi Kenan. ꞋOke oli nama Ꞌuana Ꞌi Mesopotemia, na fanoa koꞋo Ꞌoe sa Betuel. Sa Laban na ngwaefuta teꞋa Ꞌoe, nia tua ana fanoa neꞋeri. Nia leꞋa fuamu diꞋia Ꞌoke korea ta taꞋi ngela kini ana.” Nia ka faꞋaleꞋa, ma ka Ꞌuri fuana, “AlaꞋania God neꞋe toꞋo ana ngasingasiꞋanga ki taꞋifau ka faꞋaleꞋa Ꞌoe, ma ka kwatea fuamu ngela Ꞌoro ki, ma na kwalafa ana ngwaꞋi ngela neꞋe kike baꞋa futa maꞋi amu ki, kike baꞋa Ꞌoro liu. ");
INSERT INTO kwf_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","AlaꞋania God ka kwatea fuamu faꞋinia ngwae neꞋe kike baꞋa futa amu ki na leꞋangaꞋa nia kwatea fuana koꞋo Ꞌoe sa Abraham. ꞋI naꞋo maꞋi, God nia alangaꞋi ke kwatea na ano nini fuana sa Abraham. Ana kaidaꞋi neꞋe, kulu tua diꞋia ngwae kwaita ki ana ano neꞋe. Bore ma Ꞌoke baꞋa toꞋo ana na ano neꞋe diꞋia ba God alangaꞋi ka sui.” ");
INSERT INTO kwf_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Buri Ꞌana ka sui goꞋo, sa Aesak ka alaꞋania sa Jakob ka leka naꞋa ana. Sui sa Jakob ka leka naꞋa Ꞌuana Ꞌi Mesopotemia, fasi Ꞌiri nia ke leka tua faꞋinia ngwai nia sa Laban. Sa Laban, na ngwaefuta Ꞌi Rebeka nia na teꞋa sa Jakob ma sa Esau. MaꞋa nia sa Betuel, ma taꞋi ngwae Ꞌi Mesopotemia nia tua ana abaꞋi kula Ꞌi Aram. ");
INSERT INTO kwf_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Sa Esau rongo ka sui naꞋa neꞋe sa Aesak kwatea ka sui naꞋa ngwangwaneꞋanga fuana sa Jakob, ma kwatea ka leka naꞋa Ꞌi Mesopotemia ke lulua ta kini fuana korelana. Nia ka rongoa naꞋa logo, kaidaꞋi maꞋa keraꞋa nia faꞋaleꞋa sa Jakob, ma nia ka fata luia noaꞋa nia kasi korea ta kini Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ma nia ka rongoa logo neꞋe ngwaefuta nia roꞋo sulia tae neꞋe maꞋa nia faꞋinia teꞋa nia kera saea. ");
INSERT INTO kwf_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Aia sa Esau ka lia saiana naꞋa neꞋe maꞋa kera noaꞋa kasi oga neꞋe ro ngela nia ki kera ke korea ta kini Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Sa Esau toꞋo ana ro Ꞌafe ki ka sui naꞋa, bore ma nia ka leka laꞋu siana sa Ishmael ba maꞋa nia sa Abraham, ma ka korea ta taꞋi kini ana, ka alua laꞋu uula Ꞌafe. Kini neꞋeri satana Ꞌi Mahalat, ma nia na sasina Ꞌi Nebaeot na faꞋinaꞋonaꞋo sa Ishmael. ");
INSERT INTO kwf_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Sa Jakob nia faꞋasia Ꞌi Bereseba, nia ka leka nama Ꞌi Haran, ");
INSERT INTO kwf_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","kaidaꞋi nia dao ana taꞋi kula, na sina nia suu toli naꞋa, ma nia ka tua ana kula neꞋeri ka maliu. Nia ka teo ka maliu, ma ka bogwau ana taꞋi gwaꞋi fau. ");
INSERT INTO kwf_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ꞋUnaꞋeri sa Jakob ka maliu bole, nia lisia taꞋi faꞋi lalaefa nia uu, ma Ꞌaena neꞋe ka uu Ꞌi ano, bore ma na isilana alaꞋa ka teo Ꞌi langi. Ma nia ka lisia na Ꞌainsel ki kira koso maꞋi ma kika raꞋe alaꞋa sulia faꞋi lalaefa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Sui nia ka lisia Iawe nia uu maꞋi gwauna faꞋi lalaefa neꞋeri, ma ka Ꞌuri fuana, “NauꞋa naꞋa neꞋe Iawe, na God koꞋo Ꞌoe sa Abraham ma maꞋa Ꞌoe sa Aesak. Nai baꞋa kwatea na ano niniꞋa Ꞌoko maliu ana fuamu ma kwalafa Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kira ke baꞋa Ꞌoro liu, ka diꞋia gegeona ano. Ma na ano neꞋe kira toꞋo ana, nia ke baꞋa doe liu laꞋu ana bali ki taꞋifau diꞋia Ꞌi gwauna fanoa, Ꞌi fanelana sina, ma suulana sina. Ma na ngwae na fanoa matamata saena magalia kike ba saefilo nau fuana faꞋaleꞋalada, ka diꞋia logo niniꞋa nau ku faꞋaleꞋa Ꞌoe faꞋinia ngwae neꞋe kike baꞋa futa maꞋi ana kwalafa Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aia Ꞌoke manata nama toꞋona neꞋe nai baꞋa tua faꞋiniꞋo ku lia suliꞋo ana kula ki taꞋifau neꞋe Ꞌoko leka ana, ma nai baꞋa olitaꞋiniꞋo logo maꞋi ana kula neꞋe laꞋu. NoaꞋa naisi baꞋa danga ꞋaniꞋo, nai baꞋa sasia ru ki taꞋifau neꞋe nau ku fata alangaꞋi niꞋi fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Buri Ꞌana sa Jakob ka ada, ma ka Ꞌuri, “Mamana naꞋa, kula neꞋe Iawe tua ana, bore ma nau ku Ꞌiri sai nama ana.” ");
INSERT INTO kwf_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Sui nia ka maꞋu, ma ka fata Ꞌuri, “Nau ku maꞋu liu Ꞌania kula neꞋe! Kula neꞋe na luma God, ma na sinamaa Ꞌi langi mamana naꞋa niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ana Ꞌofodangi makalokaloꞋa goꞋo Ꞌua, sa Jakob ka tataꞋe naꞋa ka ngalia na gwaꞋi fau ba nia bogwau ana, ma ka faꞋa uua, ka sasia na ru fuana mamanata Ꞌanga toꞋona ana kula neꞋeri. Nia ka ngalia kala fiki ngwaingwai olif ma ka kisitaꞋinia Ꞌi fafona ka faꞋa abua fuana God. ");
INSERT INTO kwf_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Etaeta satana fanoa doe neꞋe nia tua ana Ꞌi Lus, bore ma kaidaꞋi neꞋe nia saea naꞋa Ꞌani Betel. ");
INSERT INTO kwf_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Sui Ꞌi buri Ꞌana sa Jakob ka sasia taꞋi fata alangaꞋinga fuana Iawe ka Ꞌuri, “Si diꞋia Ꞌoko tua faꞋinau ma Ꞌoko inaꞋu ana kwatelana fanga ma toro fuaku, ");
INSERT INTO kwf_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma Ꞌoko ngali nau ko baꞋa olitaꞋi leꞋa maꞋi aku ana kula niniꞋa maꞋa nau laꞋu, Ꞌirai ꞋaeꞋo na God nau. ");
INSERT INTO kwf_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Na fau neꞋe nau ka kataꞋinia fuana manata firi Ꞌanga toꞋona ru neꞋe, kula neꞋe kami ke baꞋa foꞋosi Ꞌoe ana. Ma ru ki taꞋifau neꞋe Ꞌoke baꞋa kwateꞋe fuaku, nai daroꞋia Ꞌani akwala balibali ru, ma nai baꞋa kwate ta taꞋi bali ana akwala balibali ru neꞋeri fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ꞋI buri Ꞌana sa Jakob ka leka tau ana lekaꞋa nia, ꞋunaꞋeri nia ka dao ana bali fanoa ꞋaꞋana Ꞌi fanelana sina. ");
INSERT INTO kwf_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","KaidaꞋi nia lia kwau, nia ka lisia taꞋi kilu kafo neꞋe tua ana kula abitako. Ma na uulu amuꞋi sipsip ki neꞋe kira teo Ꞌada karangia, duꞋungana ngwae folo Ꞌusia sipsip ki kira ke kwate firi ana kafo ana kilu kafo neꞋeri fuada. Na maana kilu kafo neꞋeri na taꞋi fau doe nia bokota Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","KaidaꞋi na amuꞋi sipsip neꞋeri ki kira ka fiku taꞋifau ana kula neꞋeri ngwae folo Ꞌusida ki. Kira ka gilosia kwau fau faꞋasia ma kira ka kwatea kafo fuada. Ma Ꞌi buri Ꞌana kika ka gilo olitaꞋinia fau ka bokota laꞋu kilu kafo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sa Jakob ka saefilo Ꞌuri ana ngwae neꞋe kira folo Ꞌusia sipsip ki neꞋe kira tua ana kula neꞋeri, “Kwaima kina, kaumulu faꞋasia Ꞌi faꞋi?” Ma kira ka fata Ꞌuri, “Kaimili faꞋasia Ꞌi Haran.” ");
INSERT INTO kwf_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Buri Ꞌana nia ka fata laꞋu Ꞌuri, “FaꞋuta, Ꞌuri ma kaumulu sai ana sa Laban, nia kala koꞋo tiꞋitiꞋi sa Neho?” Ma kira ka olisi Ꞌuri ana, “ꞋIu, kaimili saiana.” ");
INSERT INTO kwf_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Sui nia ka fata laꞋu Ꞌuri, “FaꞋuta, Ꞌuri ma nia tua ka leꞋa goꞋo ana?” Ma kira ka olisi Ꞌuri ana, “ꞋIu, nia tua ka leꞋa goꞋo ana. ꞋOke lia kwau na ngela kini loꞋoko leka maꞋi faꞋinia sipsip ki satana Ꞌi Rachel.” ");
INSERT INTO kwf_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","GoꞋo nia ka fata Ꞌuri, “Kwaima nau kina, na sina nia Ꞌua Ꞌi langi ne. KaidaꞋi neꞋe noaꞋa Ꞌua fuana ngalilana maꞋi sipsip ki ana ta kula. Nia leꞋa fuana muke kwatea na kafo fuada, sui kamu ka fiꞋi baꞋeda kira ka fiꞋi fanga laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bore ma kiraꞋa taꞋifau kika fata Ꞌuri, “NoaꞋa, kaimili Ꞌiri saiana sasia Ꞌira. Kaimili ke masia amuꞋi sipsip ki taꞋifau kike dao fiku maꞋi, sui kaimili taꞋifau fiꞋi fiku gilosia na fau neꞋe. Sui mala kami ka fiꞋi kwate kafo fuada.” ");
INSERT INTO kwf_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ana kaidaꞋi sa Jakob alaꞋa goꞋo Ꞌana Ꞌua faꞋinia ngwae neꞋeri ki, sariꞋi neꞋeri ka leka maꞋi faꞋinia sipsip maꞋa nia ki. Nia neꞋe lia sulia sipsip neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ma kaidaꞋi sa Jakob nia lisia na sariꞋi neꞋe ngwai nia, faꞋinia sipsip neꞋeri ki, nia tataꞋe ka leka kwau Ꞌuana kilu kafo, ma ka gilosia kwau na fau doe neꞋeri goꞋo taka filia, ma ka kwatea kafo fuana sipsip neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Buri Ꞌana nia ka leka nonoꞋia Ꞌi Rachel, ma ana kaidaꞋi neꞋeri nia ka angi naꞋa, osiꞋana nia saeleꞋa liu mala. ");
INSERT INTO kwf_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ma nia ka fata Ꞌuri fuana, “NauꞋa na ngela Ꞌi Rebeka ne. Na maꞋa Ꞌoe nia ngwai nau.” Sui ngela kini neꞋe ka lalili ka faꞋarongoa alaꞋanga neꞋe Ꞌania maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ma kaidaꞋi maꞋa nia rongoa alaꞋanga niniꞋa ana ngwai nia, nia ka lalili maꞋi ma ka lolofafia, ma ka nonoꞋia, ma ka leka faꞋinia Ꞌi luma nia. ꞋUnaꞋeri sa Jakob ka alaꞋa leꞋa fuana sulia ru ki taꞋifau neꞋe fuli. ");
INSERT INTO kwf_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Buri Ꞌana ngwai nia ka fata Ꞌuri fuana, “ꞋIu, nia mamana naꞋa! KoroꞋa taꞋi Ꞌabu goꞋo ne!” Sa Jakob ka tua ana fanoa neꞋe sulia taꞋi madamo. ");
INSERT INTO kwf_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Buri Ꞌana sa Laban ka fata Ꞌuri ana sa Jakob, “ꞋAeꞋo na ngwai nau, bore ma nia Ꞌiri leꞋa neꞋe Ꞌoke rao ꞋoꞋo goꞋo Ꞌamu fuaku. Ta tae neꞋe Ꞌoko oga nai baꞋa foliꞋo Ꞌania?” ");
INSERT INTO kwf_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma ngwae neꞋe nia toꞋo Ꞌana ro kini sariꞋi ki, Ai eta futa neꞋe satana Ꞌi Lia, ma ruana sariꞋi ana neꞋe Ꞌi Rachel. ");
INSERT INTO kwf_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ꞋI Lia maana leꞋa liu, bore ma Ꞌi Rachel neꞋe maana ꞋoloꞋolo liu mala diꞋia bola ki. ");
INSERT INTO kwf_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ꞋUnaꞋeri ma sa Jakob nia kwaima liu ana Ꞌi Rachel, ma nia ka fata Ꞌuri fuana ngwai nia, “Nau ku saeleꞋa neꞋe nai rao sulia fiu faꞋi ngali ki fuamu, si diꞋia Ꞌoko alaꞋania nai korea ruana sariꞋi amu.” ");
INSERT INTO kwf_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Sui sa Laban ka fata Ꞌuri, “Nia leꞋa fuana neꞋe nai kwatea fuamu ka liufia ta ngwae laꞋu, ꞋunaꞋeri Ꞌoke tua naꞋa Ꞌamu Ꞌuri faꞋi nau.” ");
INSERT INTO kwf_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","GoꞋo sa Jakob ka inaꞋu naꞋa ana raoꞋa fuana ngwai nia sulia fiu faꞋi ngali ki, fasi Ꞌiri nia ke korea Ꞌi Rachel. Bore ma fiu faꞋi ngali neꞋeri ki diꞋia goꞋo Ꞌana ta ro nama ta uulu asoa ana, osiꞋana nia kwaima liu ana sariꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","KaidaꞋi fiu faꞋi ngali neꞋeri ki sui, nia ka fata Ꞌuri ana funga nia, “Na kaidaꞋi nau nia sui naꞋa, ala maꞋi Ꞌani kini nau nai korea naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ꞋUnaꞋeri sa Jakob ka sasia taꞋi fafangaꞋa doe ana ara araꞋinga neꞋeri ka saea maꞋi ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Bore ma saena rodo neꞋeri, nia noaꞋa kasi ngalia Ꞌi Rachel ka leka fuana sa Jakob, nia ngalia lala Ꞌi Lia, na kini eta futa nia, ka leka kwatea fuana. Sui nia ka kwatea na kini rao ꞋoꞋo neꞋe kira saea Ꞌania Ꞌi Silpa ka leka faꞋinia fuana raoꞋa saena luma nia. ꞋUnaꞋeri sa Jakob ka teo naꞋa faꞋinia Ꞌi Lia ana rodo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Aia Ꞌofodangi nia lia, bore ma nia ka tona liu naꞋa, osiꞋana Ꞌi Lia lala neꞋe nia teo faꞋinia. Sui nia ka leka ka fata Ꞌuri fuana sa Laban, “FaꞋuta neꞋe Ꞌoko sasia ru neꞋe aku kwa! Nau ku laga liu naꞋa ana raoꞋa fuamu fasi Ꞌiri nai ngalia Ꞌi Rachel. FaꞋuta neꞋe Ꞌoko Ꞌoi aku Ꞌuri?” ");
INSERT INTO kwf_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Bore ma funga nia ka fata Ꞌuri, “Na falafala ana fanoa kami nia noaꞋa kasi ꞋunaꞋeri. NoaꞋa kami kasi alaꞋania neꞋe ngela kini Ꞌi buri ka eta Ꞌafe, ma ai Ꞌi naꞋo ka Ꞌafe Ꞌi buri. ");
INSERT INTO kwf_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","AlaꞋania ru fuana fafangaꞋa ana ara araꞋinga Ꞌoe ki ke masia ana kini eta futa ka leka basi Ꞌana sulia fiu asoa neꞋe ki, buri Ꞌana Ꞌoko fiꞋi alangaꞋi ko rao sulia ta fiu faꞋi ngali laꞋu. KaidaꞋi fiu asoa neꞋe ki ka sui, kami ke baꞋa kwatea laꞋu ruana ai fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ꞋI neꞋeri sa Jakob ka alafafia ke sasi ꞋunaꞋeri, ma kaidaꞋi fiu asoa ana fafangaꞋa neꞋeri nia sui naꞋa, na funga nia ka kwatea laꞋu Ꞌi Rachel fuana. ");
INSERT INTO kwf_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma nia ka kwatea ta sariꞋi rao ꞋoꞋo fuana, neꞋe kira saea Ꞌani Ꞌi Bilha nia ka leka faꞋinia, fasi ka rao saena luma nia. ");
INSERT INTO kwf_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ꞋUnaꞋeri sa Jakob ka teo naꞋa faꞋinia Ꞌi Rachel saena rodo neꞋeri, nia kwaima liu laꞋu ana ka liufia Ꞌi Lia. Sui nia ka rao laꞋu sulia ta fiu faꞋi ngali fuana funga nia. ");
INSERT INTO kwf_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","KaidaꞋi Iawe nia lisia neꞋe sa Jakob kwaima ana Ꞌi Rachel ka liufia Ꞌi Lia, nia ka kwatea Ꞌi Lia ka ina, bore ma Ꞌi Rachel noaꞋa kasi ina. ");
INSERT INTO kwf_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","NoaꞋa kasi tau goꞋo Ꞌi Lia ka ina naꞋa, ma ka faꞋafuta taꞋi ngela ngwane goꞋo nia ka fata Ꞌuri, “Iawe nia lisia naꞋa ꞋatoꞋanga nau ki. KaidaꞋi neꞋe naꞋa na araꞋi nau ka kwaima aku.” Ma nia ka saea ngela neꞋeri Ꞌania sa Ruben. ");
INSERT INTO kwf_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ꞋI buri Ꞌana nia ka ina laꞋu, ma nia ka faꞋafuta laꞋu ta ngela ngwane ana, sui nia ka fata Ꞌuri, “Iawe kwatea ngela neꞋe fuaku, sulia nia rongoa araꞋi nau kasi kwaima liu goꞋo aku.” Ma nia ka saea ngela neꞋeri Ꞌania sa Simion. ");
INSERT INTO kwf_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ꞋUnaꞋeri nia ka ina laꞋu, ma ka faꞋafuta laꞋu ta ngela ngwane ana, nia ka fata Ꞌuri, “Ngela nini nau ke baꞋa kwatea araꞋi nau ke manata ngasingasiꞋa aku, osiꞋana nau ku alua naꞋa uulu ngela ngwane ki fuana.” Ma nia ka saea ngela neꞋeri Ꞌania sa Lifae. ");
INSERT INTO kwf_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma ana taꞋi kaidaꞋi laꞋu, nia ka ina ma ka faꞋafuta laꞋu ta ngela ngwane nia ka fata Ꞌuri, “KaidaꞋi neꞋe nai baꞋatafea Ꞌaku Iawe, ma nia ka faꞋasata Ꞌania sa Juda. Buri Ꞌana ma noaꞋa nia kasi ina naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","KaidaꞋi Ꞌi Rachel nia saiana nia noaꞋa kasi ina naꞋa nia siana nia kasi leꞋa ana, ma nia talaꞋae liana ka guꞋuguꞋu fuana sasina, ma nia ka fata Ꞌuri fuana sa Jakob, “ꞋOke kwatea nama ta ngela fuaku si diꞋia noaꞋa, nia leꞋa fuaku nai mae goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ꞋUnaꞋeri sa Jakob ka talaꞋae fuana saetaꞋanga fuana, nia ka fata Ꞌuri fuana, “ꞋUri ma Ꞌoko fia fasi nai sasia ru neꞋe God saiana ka sasia? NiaꞋa neꞋe luiꞋo faꞋasia inaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","GoꞋo Ꞌi Rachel ka fata Ꞌuri, “ꞋIrai nia leꞋa, na kini rao nau Ꞌi Bilha niniꞋa tua goꞋo Ꞌana. Nia leꞋa fuana Ꞌoke leka maliu faꞋinia, fasi Ꞌiri nia ke faꞋafuta ta ngela fuaku. Falafala ꞋunaꞋeri naꞋa neꞋe nai baꞋa toꞋo ana ngela nau ki ana.” ");
INSERT INTO kwf_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Sui nia ka kwatea kwau kini rao neꞋeri ka leka tua faꞋinia sa Jakob, ma ka teo faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","GoꞋo kini neꞋeri ka ina naꞋa, ma ka faꞋafuta taꞋi ngela ngwane ana sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Sui Ꞌi Rachel ka fata Ꞌuri, “God nia lisia maꞋi na ꞋatoꞋanga niniꞋa teo fafi nau, ma nia faꞋataꞋinia neꞋe noaꞋa laꞋu roraꞋa nau. Nia rongoa foꞋolaku, ma nia ka kwatea ngela ngwane neꞋe fuaku.” Ma nia ka saea ngela neꞋeri Ꞌani sa Dan. ");
INSERT INTO kwf_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Sui Ꞌi buri Ꞌana Ꞌi Bilha ka ina laꞋu, ma ka faꞋafuta ta ngela ngwane laꞋu ana sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ꞋI neꞋeri Ꞌi Rachel ka fata Ꞌuri, “Nau ku fuꞋa ngasingasiꞋa Ꞌusia ai naꞋoku, ma nau ku liufia naꞋa.” Ma nia ka saea ngela neꞋeri Ꞌani sa Naftali. ");
INSERT INTO kwf_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ana kaidaꞋi Ꞌi Lia nia saiana neꞋe noaꞋa kasi ina naꞋa, nia ka fatamana kini rao ꞋoꞋo nia Ꞌi Silpa ka leka maliu faꞋinia sa Jakob logo. ");
INSERT INTO kwf_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","KaidaꞋi Ꞌi Silpa ka faꞋafuta taꞋi ngela ngwane ana sa Jakob, ");
INSERT INTO kwf_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","goꞋo Ꞌi Lia ka fata Ꞌuri, “Ngwae neꞋe nia ꞋoilakiꞋa fuaku!” Ma nia ka saea ngela neꞋe Ꞌania sa Gad. ");
INSERT INTO kwf_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sui kini rao neꞋe ka faꞋafuta laꞋu ta ngela ngwane ana sa Jakob, ");
INSERT INTO kwf_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ma Ꞌi Lia ka fata Ꞌuri, “Nau ku saeleꞋa liu naꞋa. ꞋAfe ki taꞋifau kike baꞋa sae nau Ꞌani Ꞌi SaeleꞋa.” Ma nia ka saea ngela neꞋe Ꞌania sa Asa. ");
INSERT INTO kwf_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","KaidaꞋi kira ka loia na witi ki saena oꞋola ngela tiꞋitiꞋi neꞋeri, sa Ruben ka leka Ꞌi oꞋola, ma ka dao toꞋona ti fuaꞋi ru ana Mandrek, nia ka gweea ti faꞋi ru ma ka ngalia maꞋi ka kwatea fuana teꞋa nia. ꞋUnaꞋeri Ꞌi Rachel ka saefilo Ꞌuri ana Ꞌi Lia, “Nau ku amasiꞋo Ꞌoke kwatea maꞋi ti fuaꞋi ru fuaku ana Mandrek neꞋe ngela Ꞌoe nena ngaliꞋi maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bore ma Ꞌi Lia ka fata lala Ꞌuri, “ꞋOko ngalia naꞋa Ꞌamu na araꞋi nau! FaꞋuta laꞋu neꞋe Ꞌoko iliili Ꞌuana ngalilana laꞋu na fufuna Mandrek neꞋe ngela nau nia ngaliꞋi maꞋi fuaku? TaꞋi noaꞋa goꞋo!” Bore ma Ꞌi Rachel ka fata Ꞌuri, “DiꞋia Ꞌoko kwateꞋa fuaꞋi ru neꞋana ki fuaku, nai baꞋa alaꞋani Ꞌoke teo faꞋinia sa Jakob saena rodo neꞋe maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ꞋUnaꞋeri ana agi saꞋulafi neꞋe sa Jakob oli maꞋi faꞋasia Ꞌi oꞋola Ꞌi Lia ka leka kwau ka saka fuana, ma ka fata Ꞌuri fuana, “Rodo taꞋena Ꞌoke leka maꞋi ko teo faꞋinau sulia nau ku foliꞋo naꞋa Ꞌania fuaꞋi Ꞌai ki ana Mandrek, neꞋe ngela nau nia kwateꞋe fuaku.” Ma ana rodo neꞋeri, sa Jakob ka leka maliu faꞋinia Ꞌi Lia. ");
INSERT INTO kwf_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Buri Ꞌana God ka rongoa foꞋongaꞋa Ꞌi Lia, sui nia ka ina laꞋu ma ka faꞋafuta limana ngela ngwane sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Sui nia ka fata Ꞌuri, “God nia kwate nau ana tae neꞋe nau ku folia, osiꞋana nau ku kwatea naꞋa kini rao nau ku leka tua faꞋinia araꞋi nau.” Ma nia ka saea ngela neꞋeri Ꞌania sa Isakar. ");
INSERT INTO kwf_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nia ka ina laꞋu ma ka alua onona ngela ngwane ana sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Sui nia ka fata Ꞌuri, “God nia kwatea taꞋi kwateꞋa ꞋoꞋo leꞋa fuaku. KaidaꞋi neꞋe araꞋi nau ke baꞋa manata lafu nau, duꞋungana nau ku faꞋafuta naꞋa ono ngela ngwane ki fuana.” Ma nia ka saea Ꞌani sa Sebulun. ");
INSERT INTO kwf_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ma Ꞌi buri Ꞌana nia ka faꞋafuta taꞋi ngela kini nia ma nia ka saea Ꞌania Ꞌi Daena. ");
INSERT INTO kwf_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Buri Ꞌana God ka manata toꞋona Ꞌi Rachel, ma ka rongoa foꞋongaꞋa nia, ma nia ka kwatea nia ka bolo faꞋinia ka alu ngela laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ma nia ka ina laꞋu, ma ka alua taꞋi ngela ngwane nia ma ka fata Ꞌuri, “God ngalia naꞋa ekeꞋa ba nau.” ");
INSERT INTO kwf_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma nia ka saea Ꞌania sa Josef ma nia ka Ꞌuri, “AlaꞋania Iawe ka kwatea laꞋu ta ngela ngwane fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sui buri Ꞌana neꞋe sa Josef nia futa, sa Jakob ka fata Ꞌuri fuana funga nia, “Nia leꞋa fuana neꞋe Ꞌoke alaꞋani kaimili ke oli naꞋa Ꞌi fanoa nau. ");
INSERT INTO kwf_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nau ku rao ngasi liu fuana folilana ro Ꞌafe nini nau ki faꞋinia ngwaꞋi ngela nini nau ki. Nau ku amasi Ꞌoe Ꞌoke ala naꞋa maꞋi anidaroꞋo saena limaku, faꞋinia ngela nau ki fasi Ꞌiri kaimili ke leka naꞋa. ꞋOko sai leꞋa naꞋa ana raoꞋa leꞋa Ꞌoro nini nau ku sasiꞋi fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bore ma funga nia ka fata ana, “Nau ku oga nai saea taꞋi ru. Na maꞋetoto nini nau ku lisiꞋi ki, niꞋi faꞋataꞋinia fuaku neꞋe Iawe nia faꞋaleꞋa nau osiꞋana Ꞌoko tua faꞋinau. ");
INSERT INTO kwf_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nia leꞋa fuana Ꞌoke saea fuaku ta tae neꞋe nai baꞋa foliꞋo Ꞌania, Ꞌiri neꞋe nai foliꞋo Ꞌani.” ");
INSERT INTO kwf_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Sui sa Jakob ka fata Ꞌuri, “ꞋOko sai ana ka sui naꞋa rao laga ulafuꞋa nau ku sasiꞋi fuamu ki, ma Ꞌoko logo ana neꞋe ru ꞋaeꞋaela Ꞌoe ki kira Ꞌoro kaidaꞋi nau ku lia sulida. ");
INSERT INTO kwf_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","KaidaꞋi nau ku eta dao ana fanoa neꞋe, ru Ꞌoe ki noaꞋa kasi Ꞌoro goꞋo, bore ma kaidaꞋi neꞋe kira Ꞌoro liu naꞋa. Na raoꞋa nau ku sasiꞋi fuamu ki, Iawe faꞋaleꞋa Ꞌoe. Bore kaidaꞋi neꞋe naꞋi sasia nama ti ru fuana Ꞌafilana ngela nau ki naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Bore ma funga nia ka saefilo laꞋu Ꞌuri ana, “DiꞋia nia Ꞌuira, ta tae neꞋe nai kwatea fuamu kwa?” GoꞋo nia ka fata Ꞌuri, “NoaꞋa nau kusi oga neꞋe Ꞌoke foli nau Ꞌania ta mani. Nai baꞋa saea kwau taꞋi ru, si diꞋia Ꞌoko alafafia ru neꞋeri nai lia laꞋu sulia ru ꞋaeꞋaela Ꞌoe ki. ");
INSERT INTO kwf_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ꞋOke baꞋa alaꞋania nau nai leka lia Ꞌaku talaku ana ru ꞋaeꞋaela Ꞌoe ki taꞋena. Na sipsip neꞋe goa taꞋifau ki faꞋinia nanigot tiꞋitiꞋi neꞋe kira Ꞌiri goa taꞋifau ki, neꞋe kira toꞋo ana kala kwakwaoꞋa tiꞋitiꞋi ki Ꞌi nonida, ai neꞋeri ki neꞋe nai baꞋa ngalida fuaku. Ma nia naꞋa neꞋe folifoliꞋa nau. ");
INSERT INTO kwf_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ma nia ka talangwaraꞋu goꞋo ana fuamu fuana sasilana diꞋia nau ku sasia ka saga nama ka noaꞋa. KaidaꞋi Ꞌoko lisia neꞋe nau ku toꞋo ana nanigot neꞋe goa taꞋifau ki, ma ku toꞋo ana sipsip neꞋe Ꞌiri goa taꞋifau ki, Ꞌirai kaumulu saiana muke saea neꞋe nau ku bili.” ");
INSERT INTO kwf_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Sui funga nia ka fata Ꞌuri, “Nia leꞋa goꞋo Ꞌana kuke baꞋa sasi diꞋia neꞋe Ꞌoko saea.” ");
INSERT INTO kwf_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bore ma asoa neꞋeri nama goꞋo, sa Laban leka ka ngalia na nanigot nia ki neꞋe noaꞋa kira kasi goa taꞋifau ki neꞋe kala kwaoꞋa tiꞋitiꞋi neꞋe teo Ꞌi nonida ki, faꞋinia sipsip ki neꞋe kira goa taꞋifau, ma nia ka aluda saena limana ngwaꞋi ngela ngwane nia kira ka lia sulida. ");
INSERT INTO kwf_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nia ka alaꞋania ti ai saena limana sa Jakob, ma niaꞋa faꞋinia ngwaꞋi ngela nia kira ka ngalia ru ꞋaeꞋaela nia ki kira ka leka faꞋasia kula neꞋe sa Jakob tua ana, ma kira ka ngasingasiꞋa sulia uulu asoa ki, ma kira faꞋinia ru ꞋaeꞋaela neꞋeri ki kira ka tua tau faꞋasia sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","38","ꞋUnaꞋeri sa Jakob ka tufua rarana Ꞌai neꞋe taꞋetaꞋeda marako ki. Ma nia ka ragia ti taꞋetaꞋe Ꞌai ana Ꞌai neꞋeri ki fasi Ꞌiri ke alua kula kwao ana. GoꞋo nia ka alua faꞋi aꞋo aꞋo neꞋeri ki ana kula nanigot ki leka maꞋi fuana kwaꞋu kafoꞋa ana, kaidaꞋi kira kwaꞋu, kira ka bubungia faꞋi aꞋo aꞋo neꞋeri ki. Nia ka ngalia rarana Ꞌai neꞋe kira saea Ꞌani Popla. Nia sasi ꞋunaꞋeri osiꞋana kaidaꞋi na nanigot kira leka maꞋi fuana kwaꞋunga ana kafo neꞋeri, na nanigot ngwane ki ka raꞋefida nanigot kini ki. ");
INSERT INTO kwf_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ana kaidaꞋi neꞋe taꞋi nanigot ngwane nia ka raꞋefia ta nanigot kini, kira ka bubungia fai Ꞌai neꞋeri ki, na bibi nanigot neꞋe ke baꞋa futa ana nanigot kini neꞋeri ka noaꞋa kasi goa taꞋifau, nia ka taꞋi toꞋo ana kwaoꞋa ki Ꞌi nonina. ");
INSERT INTO kwf_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ꞋUnaꞋeri sa Jakob ka daroꞋia ru ꞋaeꞋaela neꞋeri ki, nia ka ngalia sipsip ki faꞋasia nanigot ki, ma ka aluda sipsip ki kwau ana kula neꞋe kira saiana kike lisia na sipsip funga nia ki neꞋe kira goa ma kika goa bore ma kira taꞋi kwakwaoꞋa tiꞋitiꞋi Ꞌi nonida ki. Sui nia ka fikua ai nia ka tua fiku noaꞋa kasi dola laꞋu faꞋinia ai funga nia ki, ma ka ꞋunaꞋeri neꞋe nia ka sasi kika Ꞌoro laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ma kaidaꞋi nia lisia neꞋe nanigot kini ngasingasiꞋa ki kira oga nanigot ngwane ki, nia ka ngalia na faꞋi Ꞌai neꞋeri ki ka alua ana kula fuana kwaꞋu kafoꞋa. Sui kaidaꞋi na nanigot ngwane ki kira ka raꞋefida ma kira ka bubungia na faꞋi Ꞌai neꞋeri kira ka toꞋo ana toto kwao ki Ꞌi nonida. ");
INSERT INTO kwf_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bore ma kaidaꞋi nia lisia na nanigot neꞋe noaꞋa kasi ngasingasiꞋa kira leka maꞋi, nia ka lafua faꞋi Ꞌai neꞋeri ki laꞋu. Sui kasi tau goꞋo na nanigot neꞋe noaꞋa kasi ngasingasiꞋa ki, nia neꞋe ai funga nia ki. Bore ma ai neꞋe ngasingasiꞋa taꞋifau ki, ai nia ki. Ka ꞋunaꞋeri neꞋe nia taꞋi ngwae toꞋoru liu. ");
INSERT INTO kwf_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nia ka toꞋo ana sipsip Ꞌoro, faꞋinia nanigot Ꞌoro, ma ngwae rao ꞋoꞋo Ꞌoro, ma kini rao ꞋoꞋo Ꞌoro, ma kamel Ꞌoro, ma dongki Ꞌoro logo. ");
INSERT INTO kwf_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ana taꞋi asoa sa Jakob rongoa neꞋe lumaꞋa nia ki kira alaꞋa sulia. Kira Ꞌuri, “LumaꞋa kulu sa Jakob nia ngalia taꞋifau naꞋa ana ru maꞋa kulu ki. Ma nia ka toꞋo ru naꞋa, ana ru neꞋe maꞋa kulu nia toꞋo ani ki Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ꞋUnaꞋeri sa Jakob ka lisia logo neꞋe funga nia kasi kwaima leꞋa naꞋa ana diꞋia ba nia sasia maꞋi etaeta. ");
INSERT INTO kwf_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Buri Ꞌana Iawe ka fata Ꞌuri fuana, “ꞋOke oli naꞋa Ꞌuana tuaꞋa neꞋe koꞋo Ꞌoe ma maꞋa Ꞌoe ma fuuꞋi ngwae Ꞌoe neꞋe kira tua maꞋi ana. Ma nai baꞋa leka faꞋiniꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Sui sa Jakob ka kwatea alaꞋanga fuana ro Ꞌafe nia ki Ꞌi Rachel ma Ꞌi Lia, fasi Ꞌiri kera ke leka saka fuana ana kula abitakoꞋa neꞋe na ru ꞋaeꞋaela nia ki tua ana. ");
INSERT INTO kwf_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nia ka fata Ꞌuri fuadaroꞋo, “Nau ku lisia naꞋa neꞋe maꞋa koroꞋo noaꞋa kasi kwaima leꞋa naꞋa faꞋinau, diꞋia ba nia sasasia maꞋi etaeta. Bore ma God niniꞋa maꞋa nau, nia tua faꞋi nau leleka ka dao ana kaidaꞋi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","KoroꞋo saiana ka sui naꞋa neꞋe nau ku lagaꞋi rao naꞋa fuana sasilana raoꞋa maꞋa koroꞋo ki. ");
INSERT INTO kwf_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Bore ma nia ka ꞋidufaꞋi aurafu nau logo Ꞌana. KaidaꞋi Ꞌoro sui naꞋa nia rokisia na folifoliꞋa neꞋe nia foli nau Ꞌani. Bore ma God noaꞋa kasi alaꞋania neꞋe nia ka faꞋali nau. ");
INSERT INTO kwf_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","KaidaꞋi nia Ꞌuri, folifoliꞋa Ꞌoe Ꞌoke baꞋa ngalia na nanigot tiꞋitiꞋi neꞋe ki nini kira goa, bore ma kira toꞋo lala ana kala kwaoꞋa ki Ꞌi nonida, sui na nanigot kini nia ki ka kalea na ngela Ꞌi ru ꞋunaꞋeri ki logo. Bore ma kaidaꞋi nia ka Ꞌuri folifoliꞋa Ꞌoe naꞋa neꞋe Ꞌoke baꞋa ngalia kala nanigot neꞋe kira goa, bore ma kira toꞋo logo ana kala toto kwao ki Ꞌi nonida.” Ma na nanigot kini nia ki kira ka kalea logo ngela Ꞌi ru ꞋunaꞋeri ki diꞋia neꞋe nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ꞋUnaꞋeri neꞋe God ka ngalia ru ꞋaeꞋaela neꞋeri ki faꞋasia limana maꞋa koroꞋo, ma ka aluꞋi lala saena limaku. ");
INSERT INTO kwf_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ana kaidaꞋi nanigot kini ki oga nanigot ngwane ki ka raꞋefida, nau ku lisia taꞋi maliu boleꞋa. Ana maliu boleꞋa neꞋeri nau ku lisia na nanigot ngwane ki neꞋe kira raꞋefia ae kini neꞋeri ki, kira goa bore ma kira toꞋo logo ana toto kwao ki Ꞌi nonida. Ti ai kira kwao tatala asiꞋa ma ti ai ada ka toꞋo ana toto kwao doe ki ana nonida, ma ti ai ada kira ka toꞋo ana kala toto kwao ki Ꞌi nonida. ");
INSERT INTO kwf_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sui Ꞌainsel God ka sae nau saena maliu boleꞋa neꞋeri, ma nia ka fata Ꞌuri, “Jakob.” Ma nau ku olisi Ꞌuri ana, “ꞋIu.” ");
INSERT INTO kwf_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Sui nia ka fata Ꞌuri, “Lisia basi, na nanigot loꞋoko raꞋefia na nanigot kini goa loꞋoko bore ma kira toꞋo ana toto kwao ki Ꞌi nonida. Nau ku sasia ru neꞋe ka fuli Ꞌuri, sulia nau ku lisia falafala taꞋa niniꞋa sa Laban nia sasia amu. ");
INSERT INTO kwf_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","NauꞋa na God ba nau ku dao maꞋi siamu Ꞌi Betel, kula ba Ꞌoko kisitaꞋinia ngwaingwai olif ana taꞋifau ba Ꞌoko faꞋa abu ma na ru fuana mamanata Ꞌanga firi toꞋoku. Ma ana kula neꞋeri logo ba Ꞌoko sasia taꞋi fata alangaꞋinga ngasingasiꞋa fuaku. KaidaꞋi neꞋe nau ku ogaꞋo Ꞌoke faꞋasia kula neꞋe ma Ꞌoko oli Ꞌi fanoa ꞋaꞋana ba Ꞌoko futa maꞋi ana.” ");
INSERT INTO kwf_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ꞋUnaꞋeri Ꞌi Rachel ma Ꞌi Lia kera ka fata Ꞌuri fuana, “Na maꞋa keroꞋo noaꞋa kasi baꞋa toꞋo naꞋa ana ta ru neꞋe nia ke alua saena limamiroꞋo kaidaꞋi nia ka kwaimaꞋa kwali fuana maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nia lisi keroꞋo ka diꞋia neꞋe keroꞋo noaꞋa laꞋu ngela nia ki, keroꞋo ka diꞋia naꞋa ta ngwae kwaita goꞋo Ꞌana. Nia Ꞌoifoli Ꞌani keroꞋo fuamu, ma mani ki taꞋifau neꞋe nia ngalia ana folilamiroꞋo, kaidaꞋi neꞋe nia foli aniꞋi ka sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Aia, God nia ngalia naꞋa ru ki taꞋifau faꞋasia maꞋa keroꞋo, ma nia ka kwatea naꞋa fuamu. Ma ana kaidaꞋi neꞋe, ru ki taꞋifau ru keroꞋo ki naꞋa, faꞋinia ngela keroꞋo ki. ꞋOke sasi naꞋa diꞋia neꞋe God saea fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Sui sa Jakob ka salisali ana ru nia ki taꞋifau Ꞌiri ke oli Ꞌuana maꞋa nia Ꞌi Kenan. Kira ka kwatea ro Ꞌafe nia ki faꞋinia ngela nia ki, kira ka leka Ꞌi fafona kamel ki, ma ngwae nia ki kira ka leka Ꞌi naꞋo faꞋinia ru nia ki taꞋifau neꞋe nia toꞋo ani kaidaꞋi nia tua Ꞌi Mesopotemia. ");
INSERT INTO kwf_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bore ma kaidaꞋi sa Laban leka kwau fuana sufilana ifuna sipsip nia ki, Ꞌi Rachel ka leka bilia kala god kala ꞋosoꞋoso maꞋa nia ki neꞋe teo Ꞌi luma. ");
INSERT INTO kwf_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ꞋIu sa Jakob Ꞌiri saea fuana funga nia neꞋe nia ke baꞋa leka, nia sofongaꞋinia liua na nai Ꞌi ruuꞋa neꞋeri. Nia tafi goꞋo Ꞌana faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nia ngali taꞋifau ru nia ki ꞋaliꞋali goꞋo kira ka tafi naꞋa. Kira ka toꞋofolo ana kafo Ꞌi Iufretes, kira ka leka Ꞌuana faꞋi ua Ꞌi Gilead ki. ");
INSERT INTO kwf_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Buri Ꞌana uulu asoa ki, sa Laban ka rongoa faꞋarongoꞋa neꞋe funga nia sa Jakob nia tafi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","GoꞋo nia ka ngalia ngwae ana fuuꞋi ngwae nia, kira ka leka Ꞌi burida. Buri Ꞌana fiu asoa ki sa Laban ka dao fafia ana faꞋi ua Ꞌi Gilead ki. ");
INSERT INTO kwf_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Ana kaidaꞋi neꞋeri, sa Jakob faꞋinia ngwaꞋi toꞋa nia ka saungaꞋinia naꞋa na fanoa kira Ꞌi gwauna taꞋi faꞋi ua Ꞌi Gilead. Ma ana rodo neꞋeri, God ka leka maꞋi siana sa Laban ana taꞋi maliu boleꞋa ma ka fata Ꞌuri fuana, “ꞋOke madafiꞋo Ꞌokoto fiꞋi sasia ta alaꞋanga silolo fuana funga Ꞌoe sa Jakob.” ");
INSERT INTO kwf_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Sui sa Laban ka leka siana funga nia ma ka fata Ꞌuri, “FaꞋuta neꞋe Ꞌoke ngalia ro kini nau ki, ma Ꞌoko tafi ago Ꞌuri? ꞋOko sasi diꞋia neꞋe Ꞌoko liufidaroꞋo ana ta maꞋe. ꞋOko Ꞌiri taꞋi saea naꞋa ta alaꞋanga fuaku! ");
INSERT INTO kwf_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","FaꞋuta neꞋe kaumulu ka Ꞌoi Ꞌaku Ꞌuri, ma kamu ka tafi? Si diꞋia kamu faꞋarongo nau Ꞌania lekalamuꞋa etaeta Ꞌirai nai ngali ngwae ni kwaꞋi gita faꞋinia ngwae ni masaꞋa Ꞌania kete ki, Ꞌirai nai baꞋa ngulia faꞋi ngu ni oli oliꞋa Ꞌania falafala leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Lisia basi! ꞋOko Ꞌiri alaꞋania neꞋe nai nonoꞋia kala koꞋo nini nau ki faꞋinia ro kini nini futa aku ki, ma nau ku oli oli ada. ꞋOko boleboleꞋa liu naꞋa kwa! ");
INSERT INTO kwf_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nau ku bolo faꞋinia nai faꞋali kaumulu goꞋo Ꞌaku taꞋifau. Bore ma rodo neꞋe, God maꞋa kaumulu nia leka maꞋi siaku ana maliu boleꞋa, ma ka alaꞋa ngasingasiꞋa fuaku Ꞌiri noaꞋa naisi alaꞋa silolo fuamu. ");
INSERT INTO kwf_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nau ku saiana neꞋe Ꞌoko oga liua naꞋa olia Ꞌuana fanoa Ꞌoe, bore ma faꞋuta lala neꞋe Ꞌoko bilia kala god kalaꞋa nau ki neꞋe niꞋi teo saena luma nau?” ");
INSERT INTO kwf_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sui sa Jakob ka fata Ꞌuri, “NoaꞋa naisi saea leka laku fuamu sulia nau ku maꞋu, Ꞌasu Ꞌubani nau ku saea fuamu, ma Ꞌoko fiꞋi ngali ro Ꞌafe nau ki faꞋasi nau. ");
INSERT INTO kwf_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bore ma si diꞋia Ꞌoko dao toꞋona ta ai aimili nia bilia na god Ꞌoe ki, na ngwae neꞋeri ke baꞋa mae. Na ngwae nini ana fufuꞋi ngwae Ꞌoe ki neꞋe kike faꞋamamana aku. ꞋOke lia Ꞌamu Ꞌuana god Ꞌoe ki. Ma si diꞋia Ꞌoke dao toꞋona ta ru amu, Ꞌoke ngalia.” Bore ma nia noaꞋa kasi sai goꞋo ana neꞋe Ꞌi Rachel goꞋo neꞋe bilia god kalaꞋa neꞋeri ki, ma ka agotaꞋi niꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Sui sa Laban ka leka lulu kwailiu Ꞌuana god kalaꞋa neꞋe ki saena babala sa Jakob, ma nia ka leka sasi logo ꞋunaꞋeri saena babala Ꞌi Lia, ma saena babala ro kini rao ꞋoꞋo, ma ro kini nia ki logo, bore ma nia noaꞋa Ꞌiri dao toꞋoda. Sui ni ka ruꞋu Ꞌi saena babala Ꞌi Rachel. ");
INSERT INTO kwf_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Bore ma Ꞌafe neꞋe sofongaꞋinia saena taꞋi ngwaꞋi ana kula ni gwauru Ꞌanga fafona kamel nia, nia ka tua fafia na ngwaꞋi ni ru neꞋeri. Sui bore Ꞌana nia ka dao maꞋi ka lulu kwailiu ana kula ki taꞋifau saena babala neꞋeri, noaꞋa nia kasi dao toꞋona. ");
INSERT INTO kwf_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Sui Ꞌi Rasel ka fata Ꞌuri ana maꞋa nia, “Kwaimanatai liu naꞋa maꞋasi Ꞌae, nau ku mataꞋi ne, ma nau kusi bolo faꞋinia uuꞋa Ꞌi maamu, nau ku amasiꞋo Ꞌoe kosi saetaꞋa laꞋu fuaku.” Ma sa Laban ka lia ana kula ki taꞋifau Ꞌuana god kalaꞋa nia ki bore ma nia kasi dao naꞋa toꞋona. ");
INSERT INTO kwf_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ꞋUnaꞋeri sa Jakob ka balufia funga nia ka Ꞌuri, “ꞋUri ma tae neꞋe nau ku sasia ka taꞋa kwa! Nau ku Ꞌiri Ꞌoia na taki neꞋe kaumulu ka leka maꞋi muka lali nau Ꞌuri! Nia Ꞌiri saga neꞋe kamu ka sasi Ꞌuri. ");
INSERT INTO kwf_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mulu leka lia Ꞌi safitana ru loꞋoko nau ki, bore ma tae neꞋe kamu ke dao toꞋona? DiꞋia kamu lisia ta ru, muka ngalia maꞋi! Ngwae kulu ki ne tua goꞋo Ꞌada. Moro alua Ꞌi maada, fasi Ꞌiri kike lia saiana sa tai aumulu neꞋe saga. ");
INSERT INTO kwf_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ro akwala faꞋi ngali ki naꞋa neꞋe nau ku inaꞋu ana raoꞋa fuamu. Ma ana kaidaꞋi Ꞌoro goꞋo ana neꞋe sipsip Ꞌoe ki ma nanigot Ꞌoe ki kira toꞋo ana ngela Ꞌi ru Ꞌoro ki, bore ma ta taꞋi sipsip ngwane nama ta taꞋi nanigot ngwane noaꞋa nau kusi ngalia nama faꞋasiꞋo fuana Ꞌanilana Ꞌaku. ");
INSERT INTO kwf_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","KaidaꞋi ki taꞋifau na ru kwasi ki kira faꞋalia na ru ꞋaeꞋaela Ꞌoe ki, nauꞋa goꞋo neꞋe nai didifulia. Nau noaꞋa kusi ngalia naꞋa maꞋi siamu Ꞌiri Ꞌoke lisia. Falafala Ꞌoe naꞋa neꞋe diꞋia ta ru ꞋaeꞋaela amu nia noꞋana ana dangi nama ana rodo, nauꞋa nama neꞋe nai didifulia. ");
INSERT INTO kwf_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","KaidaꞋi Ꞌoro ki nau ku saiana noniku nia taꞋa. Ana dangi, na madaꞋafi nia sina fifi aku, ma nau ku maruku liu naꞋa, ma ana rodo nau ku gwari liu naꞋa, ma nau kusi maliu. ");
INSERT INTO kwf_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ana kaidaꞋi firi sulia ro akwala faꞋi ngali, nau ku tua faꞋi kaumulu ki, kamu sasi nama diꞋia neꞋe nauꞋa ta ngwae rao laga ulafu, ma ru neꞋe kamu kasi rokisia goꞋo. Nau ku rao sulia fai akwala faꞋi ngali ki fuana ngalilana ro kini Ꞌoe ki, ma nau ku inaꞋu ana raoꞋa sulia ono faꞋi ngali ki laꞋu fuana ru ꞋaeꞋaela nini Ꞌoe ki. Ma ana ono faꞋi ngela neꞋe ki, Ꞌoko rokisia folifoliꞋa nau ana kaidaꞋi Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Bore ma diꞋia God nini koꞋo nau ki nia kasi ꞋafiꞋafi nau, Ꞌirai Ꞌoko lali nau ka sui naꞋa. Ma noaꞋa naisi ngalia naꞋa ta ru. Bore Ꞌana ma God nia tua faꞋi nau, ma Ꞌoe kosi lali nau. KoꞋo nau sa Abraham nia foꞋosia Ꞌi naꞋo ma faꞋinia maꞋa nau sa Aesak logo neꞋe inaꞋu ana foꞋosilana ma ka fuꞋusi doe ana. Bore ma nia ka lisia goꞋo Ꞌana na ꞋatoꞋanga nini nau ku toꞋo ana, ma rao ngasiꞋa nini nau ku fulia, ma saena rodo neꞋe nia faꞋataꞋinia ana maliu boleꞋa neꞋe Ꞌoko faꞋataꞋinia sa tai akoro neꞋe saga.” ");
INSERT INTO kwf_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Sui sa Laban ka fata Ꞌuri fuana funga nia, “Na ro Ꞌafe neꞋe ki, ro kini nau ki niniꞋa. Na ngela keroꞋa ki faꞋinia ru ꞋaeꞋaela neꞋe ki ru nau ki taꞋifau. Ru neꞋe ki taꞋifau ru nau ki goꞋo. Bore ma duꞋungana nau noaꞋa kusi sasia ta ru fuana goniladaroꞋo ro kini nau ki faꞋinia ngela kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nau ku salisali naꞋa nai sasia fata alangaꞋinga faꞋinidaroꞋo. Nia leꞋa kuke sasia taꞋi sulufaua doe Ꞌi neꞋe, fasi Ꞌiri ke diꞋia toto kulu ana alangaꞋinga nini kulu.” ");
INSERT INTO kwf_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ꞋUnaꞋeri sa Jakob ka ngali taꞋi fau doe ka faꞋauua Ꞌi neꞋeri ka sasia taꞋi ru fuana mamanata Ꞌanga toꞋona. ");
INSERT INTO kwf_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma nia ka fata Ꞌuri fuana ngwae ana fufuꞋi ngwae nia ki, “Muke leka ngalia maꞋi gwaꞋi fau ki, kuke baꞋa saungaꞋinia taꞋi sulufaua ana kula neꞋe.” Buri Ꞌana kike baꞋa sasia kala fafangaꞋa, karangia sulufana neꞋe fuana toto ana ru neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Sui sa Laban ka saea sulufaua neꞋeri Ꞌania alaꞋanga nia, “Jegara Sahaduta,” neꞋe fadalana, “Sulufaua ana toto kulu.” Ma sa Jakob ka saea sulufaua neꞋe Ꞌania alaꞋanga nia, “Galeed,” neꞋe fadalana ꞋunaꞋeri logo. ");
INSERT INTO kwf_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","GoꞋo sa Laban ka fata Ꞌuri ana, “Na sulufau neꞋe nia ke baꞋa diꞋia toto fuakoro, ana fata alangaꞋinga niniꞋa koro.” Nia neꞋe sa Jakob ka saea kula neꞋe Ꞌani Galeed. ");
INSERT INTO kwf_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","GoꞋo sa Laban ka fata Ꞌuri fuana, “AlaꞋania Iawe ke filo koro kaidaꞋi koro leka faꞋasikoro.” Nia neꞋe sa Jakob ka saea kula neꞋeri Ꞌania Ꞌi Mispa nama kula fuana filolana. ");
INSERT INTO kwf_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ma nia ka fata laꞋu Ꞌuri, “DiꞋia Ꞌoko sasia ta ru ka taꞋa ana ro kini neꞋe nau ki nama Ꞌoko korea lala ta Ꞌafe laꞋu, nia leꞋa fuana Ꞌoke manata toꞋona God neꞋe lisi koro, sui bore Ꞌana ta ngwae kasi filo koro. ");
INSERT INTO kwf_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Na sulufaua neꞋe nau ku alua Ꞌi safitakoro, ma na fau nini Ꞌoko faꞋauua diꞋia ta ru ni manata firiꞋanga toꞋona kera ke baꞋa tua Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Na sulufaua neꞋe faꞋinia ru fuana mamanata Ꞌanga toꞋona neꞋe kera ro toto ana fata alangaꞋi lakoro. NoaꞋa naisi baꞋa leka liufia sulufaua neꞋe fuana faꞋalilamu. Ma ꞋaeꞋo logo Ꞌoe kosi liufia na sulufaua neꞋe faꞋinia na ru fuana mamanata Ꞌanga firi toꞋona neꞋe ana ta kaidaꞋi goꞋo Ꞌana fuana fuꞋalilaku. ");
INSERT INTO kwf_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","AlaꞋania God maꞋa koro ki sa Abraham ma sa Neho ke matalangaꞋinia ta ai akoro neꞋe nia ke Ꞌoio alangaꞋinga neꞋe!” ꞋUnaꞋeri sa Jakob ka alangaꞋi Ꞌania satana God neꞋe maꞋa nia sa Aesak foꞋo satana, diꞋia neꞋe nia ka dau sulia alangaꞋinga niniꞋa sa Laban sasia faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Buri Ꞌana nia ka saungia taꞋi ru ꞋaeꞋaela ma ka foꞋosi Ꞌania Ꞌi gwauna ua neꞋeri ma nia ka saea ngwae ana kwalafa nia ki kira ka leka maꞋi kika Ꞌado faꞋinia fuana Ꞌanilana foꞋosi neꞋeri. Ma kaidaꞋi fuana Ꞌanilana foꞋosi neꞋeri, ma kaidaꞋi kira fanga ka sui ana rodo neꞋeri, kira ka teo naꞋa maꞋi gwauna faꞋi ua neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ana Ꞌofodangi laꞋa bilabila, sa Laban ka nonoꞋia kala koꞋo nia ki, faꞋinia ro kini nia ki fuana olioliꞋa ada. Sui nia ka faꞋasia fanoa neꞋeri, ma ka oli Ꞌi fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ana kaidaꞋi sa Jakob nia leka kwau, na Ꞌainsel ki kira leka maꞋi ma kika saka fuana. ");
INSERT INTO kwf_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ma kaidaꞋi nia lisi kira, nia ka fata Ꞌuri, “Kula neꞋe nia kula na Ꞌainsel God ki kira sasia fuana fanoa kira. Sui nia ka saea kula neꞋeri Ꞌania Ꞌi Mahanaem nama ro fanoa.” ");
INSERT INTO kwf_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","5","Sa Jakob ka asungaꞋinia ti ngwae kira ka ngalia alaꞋanga nia ka leka fuana ngwaefuta nia sa Esau Ꞌuana fanoa ꞋaꞋana kira saea Ꞌani Ꞌi Seiri, neꞋe ta sata Ꞌi Idom. Nia saea fuada Ꞌiri kike fata Ꞌuri fuana sa Esau, “AraꞋi kwa, ngwae ni rao Ꞌoe sa Jakob, nia asungaꞋi kaimili mika leka maꞋi mike faꞋarongo Ꞌoe Ꞌania fatalana. Nia fata Ꞌuri: AraꞋi ꞋaꞋana nau Ꞌae. ꞋI naꞋo nau ku faꞋasia kula neꞋe ma nau ku leka tua faꞋinia sa Laban, ma nau ku tua faꞋinia leleka ka dao ana kaidaꞋi neꞋe, ma nau ku oli naꞋa maꞋi, nau ku toꞋo ana buluka ki ma dongki ki, ma sipsip ki, ma nanigot ki, ma na ngwae rao ꞋoꞋo ki ma kini rao ꞋoꞋo ki. Nia ne nau ku kwatea kwau alaꞋanga neꞋe fuamu, si diꞋia Ꞌoko saeleꞋa fuana lisilaku.” GoꞋo nia ka asungaꞋinia ngwae ki kira ka leka etaeta ana fuana lisilana sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","KaidaꞋi ngwae neꞋeri kira oli maꞋi, kika fata Ꞌuri fuana, “Kaimili leka lisia ngwae futa Ꞌoe ka sui naꞋa. KaidaꞋi neꞋe nia faꞋasia naꞋa fanoa nia ka leka naꞋa maꞋi fuana sakaꞋa fuamu. Ma nia toꞋo ana fai talangaꞋi ngwae ki kira ka leka maꞋi faꞋinia.” ");
INSERT INTO kwf_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ꞋUnaꞋeri sa Jakob ka maꞋu liu, sui nia ka daroꞋia ngwae neꞋe kira tua faꞋinia ki, faꞋinia logo ru ꞋaeꞋaela nia ki Ꞌania na ro fikutaꞋi lekaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ꞋUnaꞋeri nia ka manata Ꞌuri, “DiꞋia sa Esau nia leka maꞋi, ma ka saungia naꞋa ta taꞋi fikutaꞋi ngwae, sali ta fikutaꞋi ngwae kira saiana kike tafi.” ");
INSERT INTO kwf_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Sui nia ka foꞋosia God ka Ꞌuri, “Aofia Iawe, ꞋaeꞋo God koꞋo nau sa Abraham ma maꞋa nau sa Aesak. Nau ku amasiꞋo Ꞌoke rongo nau maꞋi. ꞋOko saea fuaku nai oli nama maꞋi Ꞌi fanoa nau ma luꞋuluꞋua nau, ma Ꞌoko fata alangaꞋi Ꞌuri Ꞌoke baꞋa kwatea maurilaku ka leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Falafala Ꞌoe ki fuaku nia Ꞌuri. KaidaꞋi ki sui Ꞌoko kwaima liu aku, ma kaidaꞋi ki sui Ꞌoko dau sulia fata alangaꞋinga Ꞌoe ki fuaku. Bore Ꞌana ma nauꞋa taꞋi ngwae taꞋa goꞋo Ꞌana niniꞋa, nau ngwae rao Ꞌoe goꞋo, ma nia ka Ꞌiri saga goꞋo fuamu neꞋe Ꞌoke sasia ti ru leꞋa fuaku Ꞌuri, ꞋI naꞋo maꞋi kaidaꞋi nau ku toꞋofolo ana kafo Ꞌi Jodan, nau ku Ꞌiri toꞋo nama ana ta ru, faꞋi kubu goꞋo neꞋe nau ku dau fafia. Bore ma niniꞋari nau ku oli maꞋi, nau ku toꞋo ana ro fikutaꞋi ngwae faꞋinia ma ti ru matamata laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aofia Iawe Ꞌae, nau ku amasi Ꞌoe Ꞌoke faꞋamauri nau faꞋasia na ngwae futa neꞋe nau. Nau ku maꞋu liu, Ꞌasu Ꞌubani nia ka dao maꞋi ma ka saumusi kaimili faꞋinia kini neꞋe ki ma ngela ki logo. ");
INSERT INTO kwf_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ꞋI naꞋo ba, Ꞌoko fata alangaꞋi Ꞌuri, ‘ꞋOke baꞋa sasia ru ki taꞋifau ke leꞋa ana maurilaku, ma Ꞌoke baꞋa sasia ngela neꞋe futa ana kwalafa nau ki, kira ke baꞋa Ꞌoro liu neꞋe noaꞋa ta ngwae saiana kasi toꞋoda, kira ke Ꞌoro diꞋia na one ninimana asi. Nau ku amasiꞋo Ꞌoe kosi manata bura ana alangaꞋinga nini Ꞌoe fuaku.’” ");
INSERT INTO kwf_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ana rodo nia ka maliu naꞋa ana kula neꞋeri, ma Ꞌofodangi, nia filia ti ru ꞋaeꞋaela fuana kwatela fuana ngwaefuta nia. ");
INSERT INTO kwf_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Na kwateꞋa neꞋeri nia toꞋo ana ro talangaꞋi nanigot kini ki, faꞋinia ro akwala nanigot ngwane ki ana etana fikutaꞋi ru, ma ro talangaꞋi sipsip kini ki faꞋinia ro akwala sipsip ngwane ki ana ruana fikutaꞋi ru, ");
INSERT INTO kwf_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ma na uulu akwala kamel kini ki faꞋinia kaela kamel kira ki ana uula fikutaꞋi ru ma na fai akwala buluka ki faꞋinia akwala buluka ngwane ki, ana faina fikutaꞋi ru ma na ro akwala dongki kini ki faꞋinia akwala dongki ngwane ana limana fikutaꞋi ru. ");
INSERT INTO kwf_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nia ka daroꞋida Ꞌania lima fikutaꞋi ru ki, ma nia ka alua lima ngwae rao ki kira ka lia sulida taꞋifau neꞋe taꞋi ngwae fuana taꞋi fikutaꞋi ru. Sui nia ka fata Ꞌuri fuada, “ꞋIu nia leꞋa, muke etaeta Ꞌi naꞋo bore ma kamu kasi leka fiku. Na fikutaꞋi nanigot kike baꞋa etaeta, ma na fikutaꞋi sipsip kike taꞋi kwaimaꞋakwali tiꞋitiꞋi sui kika fiꞋi leka Ꞌi buri, sui uulu fikutaꞋi ru neꞋeri ki kira ka fiꞋi dongada logo ꞋunaꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Sui nia ka fata Ꞌuri fuana ngwae neꞋe lia sulia nanigot ki, “Si diꞋia na ngwaefuta nau saka fuamu sulia tala, ma nia ka saefilo Ꞌuri amu, ‘ꞋOke leka Ꞌi faꞋi niniꞋa? Na nanigot neꞋe ki ru sa tai ki niniꞋa? Sa tai mo neꞋe araꞋi ꞋaꞋana Ꞌoe?’ ");
INSERT INTO kwf_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ꞋUnaꞋeri Ꞌoke baꞋa fata Ꞌuri fuana, ‘AraꞋi ꞋaꞋana kwa! Nanigot neꞋe ki, ru ngwae ni rao Ꞌoe sa Jakob. ꞋAeꞋo naꞋa neꞋe araꞋi ꞋaꞋana nia, ma nia naꞋa ne na kwateꞋa ꞋoꞋo neꞋe nia kwatea maꞋi fuamu. Nia ke lekaleka maꞋi Ꞌua Ꞌi burummili.’” ");
INSERT INTO kwf_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ma nia ka saea nama taꞋi alaꞋanga neꞋeri laꞋu fuana fai ngwae ni rao neꞋe kira lia sulia ti ru ꞋaeꞋaela laꞋu. Nia fata Ꞌuri, “Si diꞋia kaumulu saka fuana ngwaefuta nau, kaumulu taꞋifau muke saea goꞋo taꞋi alaꞋanga neꞋeri nama logo. ");
INSERT INTO kwf_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma kaumulu noaꞋa mu kasi manata bura ana alaꞋanga Ꞌuri, ‘Ngwae ni rao Ꞌoe sa Jakob nia ke leka leka Ꞌua maꞋi Ꞌi burimili. Ma nia kasi tau, nia ka dao Ꞌi neꞋe.’” ꞋUnaꞋeri sa Jakob ka manata Ꞌana Ꞌuri, “Si diꞋia nau ku eta kwatea na kwateꞋa neꞋe ki. Sali nia ke sasia manataꞋanga nia ke leꞋa tiꞋitiꞋi fuaku. Ma Ꞌi buri Ꞌana neꞋe nai baꞋa lisia. Sali nia ke saeleꞋa fuana lisilaku.” ");
INSERT INTO kwf_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Sui nia ka kwatea na kwateꞋa neꞋeri ki ka etaeta, bore ma nia ka tua goꞋo ana kula neꞋeri saena rodo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ma saena rodo neꞋeri sa Jakob nia tataꞋe ma ka ngalia ro Ꞌafe nia ki faꞋinia ro kini rao ꞋoꞋo kera ki faꞋinia akwala ma taꞋi ngela nia ki ma kira ka faꞋasia kula neꞋeri ma kira ka toꞋofolo ana kafo Ꞌi Jebok nia ka ngalida ka toꞋofolo faꞋinida Ꞌi bali loꞋoba. ");
INSERT INTO kwf_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ana kaidaꞋi kira Ꞌi bali loꞋoba ka sui nia ka oli maꞋi ma nia ka kwatea ru nia ki taꞋifau ka toꞋofolo ana kafo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sui nia ka tua buri talana ana ta bali kafo neꞋeri neꞋe kira tua ana. GoꞋo taꞋi ngwae ka leka maꞋi ma ka dau nia, kera ka kwainamutaꞋi leleka karangi sina ka raꞋe maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","KaidaꞋi ngwae neꞋeri saiana nia kasi liufia naꞋa sa Jakob, nia ka fele giroa faꞋi Ꞌagena ma faꞋi Ꞌagena sa Jakob ka adunga naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sui ngwae neꞋeri ka fata Ꞌuri, “ꞋOke danga naꞋa Ꞌani nau! Karangi ka dangi naꞋa ne!” Bore ma sa Jakob ka fata Ꞌuri, “NoaꞋa! Nai baꞋa danga ꞋaniꞋo si diꞋia Ꞌoko faꞋaleꞋa nau basi!” ");
INSERT INTO kwf_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Sui ngwae neꞋeri ka lidi Ꞌuri ana, “ꞋUri ma satamu sa tai kwa?” Ma nia ka olisi Ꞌuri ana, “Sataku sa Jakob ne.” ");
INSERT INTO kwf_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","GoꞋo ngwae neꞋeri ka fata Ꞌuri, “Satamu ke baꞋa noaꞋa laꞋu sa Jakob. Satamu sa Israel naꞋa, duꞋungana Ꞌoko fuꞋa saulia God, ma na ngwae logo, ma Ꞌoko liu.” ");
INSERT INTO kwf_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Buri Ꞌana sa Jakob ka lidi Ꞌuri ana ngwae neꞋeri, “ꞋUri ma satamu sa tai?” Bore ma ngwae neꞋeri ka olisi Ꞌuri ana, “FaꞋuta neꞋe Ꞌoko oga saiꞋa ana sataku?” GoꞋo nia ka faꞋaleꞋa nia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Sui sa Jakob ka fata Ꞌuri, “Reala kwa! Nau ku lia leꞋa naꞋa ana maana God Ꞌania maaku, bore ma nau ku mauri goꞋo Ꞌaku Ꞌua!” GoꞋo nia ka saea kula neꞋeri Ꞌania Ꞌi Peniel, nama “Maana God.” ");
INSERT INTO kwf_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ma kaidaꞋi nia faꞋasia Ꞌi Peniel, na sina nia fane ngasi naꞋa, ma nia ke leka labusula naꞋa, sulia Ꞌaena taꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ka eta ana kaidaꞋi neꞋeri leleka ka dao Ꞌi taꞋena, na ngwae ana fuuꞋi ngwae Ꞌi Israel kira kasi Ꞌania ta fasi ru ana kula neꞋe na suli nia lado ana nonina ru ꞋaeꞋaela ki, osiꞋana kaidaꞋi ngwae neꞋeri nia giroa faꞋi Ꞌagena sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Sa Jakob lia kwau ka lisia na ngwae futa nia sa Esau faꞋinia fai talangaꞋi ngwae nia ki neꞋe kira leka maꞋi. Sui nia ka daroꞋia ngela nia ki kira ka leka tua faꞋinia teꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ꞋUnaꞋeri nia ka kwate kira ka uu tatalaꞋa taꞋifau etaeta, ro kini rao ꞋoꞋo ki faꞋinia ngela keraꞋa ki, Ꞌi buri Ꞌi Lia faꞋinia ngela nia ki, Ꞌi burida laꞋu, Ꞌi Rachel faꞋinia ngela nia sa Josef. ");
INSERT INTO kwf_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Sui nia ka leka Ꞌi naꞋoda ka saka fuana sasina, ma kaidaꞋi nia dao karangia, nia ka bobo uruuru fiu faꞋi kaidaꞋi ki Ꞌi ano leleka na maana ka toꞋo toꞋona Ꞌi ano. ");
INSERT INTO kwf_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bore ma sa Esau ka lalili maꞋi ka saka fuana, nia ka lolea ngwaefuta nia ma nia ka lolo ngiringiri ana ma ka nonoꞋia. Ma kera ka angi taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","KaidaꞋi sa Esau lisia Ꞌafe neꞋeri ki faꞋinia ngela ki neꞋe kira tua faꞋinia, nia ka saefilo Ꞌuri ana, “ꞋAfe nini kira tua faꞋiniꞋo, ma ngela nini kira faꞋiniꞋo ki ngela sa tai ki niniꞋa?” Sui sa Jakob ka olisi Ꞌuri ana, “Ngwae ꞋaꞋana God nia sasi leꞋa fuaku. Nia niniꞋa kwatea ngela neꞋe ki fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ma ro kini rao neꞋe ki faꞋinia ngela keraꞋa ki, kira leka karangi, ma kira ka bobo uruuru naꞋona sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ꞋI Lia faꞋinia ngela nia ki logo kira leka ma kira ka bobo uruuru, buira Ꞌi Rachel ma sa Josef, kera leka maꞋi ma kera ka bobo uruuru logo Ꞌi naꞋona sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma sa Esau ka saefilo Ꞌuri ana, “ꞋUri ma na lima amuꞋi ru ꞋaeꞋaela neꞋe nau ku saka maꞋi fuana sulia tala, ru fuana tae ki baniꞋa?” Ma sa Jakob ka olisi Ꞌuri ana, “Ngwae ꞋaꞋana ru neꞋana ki ru Ꞌoe ki, fasi Ꞌiri Ꞌoke saeleꞋa fafi nau.” ");
INSERT INTO kwf_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","GoꞋo sa Esau ka fata Ꞌuri, “NoaꞋa ngwaefuta nau ku toꞋo naꞋa ana ru Ꞌoro ki. Gonia Ꞌamu ru neꞋana ki.” ");
INSERT INTO kwf_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Bore ma sa Jakob ka fata Ꞌuri, “NoaꞋa Ꞌoke ngalia Ꞌamu ru neꞋe ki. DiꞋia Ꞌoko saeleꞋa fafi nau, nau ku oga Ꞌoke ngalia naꞋa Ꞌamu kwateꞋa neꞋe nau. KaidaꞋi neꞋe nau ku saeleꞋa liu neꞋe nau ku lisia laꞋu maomu nia diꞋia neꞋe nau ku lisia maana God. ");
INSERT INTO kwf_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ꞋOke ngalia naꞋa Ꞌamu kwateꞋa nini nau ku ngalia maꞋi fuamu. God nia sasia ru leꞋa fuaku, ma nau ku toꞋo ana ru Ꞌoro ki naꞋa.” Sa Jakob ka Ꞌingoa ngwaefuta nia fuana ngalilana ru neꞋeri ki, leleka nia ka ngalia nama kwateꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Buri Ꞌana sa Esau ka Ꞌuri, “LeꞋa liu koro leka, nai baꞋa leka faꞋiniꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Bore ma sa Jakob ka fata Ꞌuri, “Ngwae ꞋaꞋana, nia leꞋa goꞋo Ꞌana, bore ma Ꞌoko sai ana, na ngela nau ki kira Ꞌiri ngasingasiꞋa. Ma nau ku manata toꞋona ru ꞋaeꞋaela neꞋe ki logo neꞋe kira ngelaꞋa. Si diꞋia nau ku kwatea kira ka leka ngasingasiꞋa fuana asoa laꞋulaꞋu, Ꞌirai kira ke baꞋa mae taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nia leꞋa fuana Ꞌoke etaeta Ꞌamu kaimili ke baꞋa leka maꞋi buri, Ꞌiri kaili ke leka sarafaꞋi. Kaimili ke baꞋa ara faꞋinia kwau lekaꞋa, diꞋia neꞋe ngela neꞋe ki ma ru ꞋaeꞋaela ki kamu leka naꞋa maꞋi, kaili ke baꞋa Ꞌado naꞋa faꞋi kamu Ꞌi Idom.” ");
INSERT INTO kwf_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Sui sa Esau ka fata Ꞌuri, “Nia leꞋa Ꞌirai nai faꞋasia ti ngwae aku kike tua faꞋiniꞋo.” Bore ma nia ka Ꞌuri, “NoaꞋa araꞋi ꞋaꞋana Ꞌoe kosi Ꞌabera liu goꞋo. Nia leꞋa goꞋo Ꞌana. DiꞋia Ꞌoko saeleꞋa fafi nau, nia leꞋa naꞋa fuaku neꞋeriꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ana asoa neꞋeri nama neꞋe sa Esau faꞋasia kula neꞋeri, nia ka oli Ꞌuana Ꞌi Idom. ");
INSERT INTO kwf_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Bore ma sa Jakob ka leka Ꞌuana kula kira saea Ꞌania Ꞌi Sukot, nia ka saungaꞋinia taꞋi luma nia, ma nia ka saungaꞋinia babala ki fuana ru ꞋaeꞋaela nia ki. Nia neꞋe kira ka saea kula neꞋeri Ꞌania Ꞌi Sukot nama “Babala ki.” ");
INSERT INTO kwf_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sa Jakob ka faꞋasia Ꞌi Mesopotemia ka raꞋe ꞋalaꞋa maꞋi ka mauri ana fanoa ꞋaꞋana neꞋe kira saea Ꞌania Ꞌi Kenan. Nia ka leka ka tua ana maꞋe fanoa doe neꞋe kira saea Ꞌani Ꞌi Sekem, ma nia ka saungaꞋinia fanoa nia ana kula abitako karangia fanoa doe neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nia ka foli dangalu naꞋa ana ano neꞋeri Ꞌani taꞋi talangaꞋi ngisingisi silva ana ngela sa Hamor ki, maꞋa sa Sekem. ");
INSERT INTO kwf_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nia ka Ꞌuia taꞋi fuli kooꞋa ana kula neꞋeri, nia ka saea Ꞌania Ꞌi El Elohe Israel neꞋe fadalana, “God nia God Israel.” ");
INSERT INTO kwf_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ana taꞋi asoa, ngela kini sa Jakob ma Ꞌi Lia, satana Ꞌi Daena nia leka ana taꞋi fanoa doe neꞋe kira saea Ꞌani Ꞌi Sekem, kira leka lisia ti kini ana kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ma sa Hamor ta taꞋi ngwae ana kwalafa sa Hivi, nia neꞋe gwaungaꞋi ana maꞋe fanoa neꞋeri, ma nia toꞋo ana taꞋi ngela ngwane nia neꞋe satana sa Sekem. Ana kaidaꞋi Ꞌalako neꞋeri lisia Ꞌi Daena nia ka lolea ma ka Ꞌingoa ka teo faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ma ana kaidaꞋi nia lisia sariꞋi neꞋeri ta taꞋi kini lisilana teꞋa liu, nia ka oga liua naꞋa, nia ka gaea naꞋa fasi nia ke oga. ");
INSERT INTO kwf_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ma nia ka fata Ꞌuri fuana maꞋa nia, “MaꞋasi Ꞌae, nau ku oga liua naꞋa nai korea kini neꞋe. ꞋOke leka ko ili toꞋona ganilana maꞋi ana maꞋa nia.” ");
INSERT INTO kwf_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sui sa Jakob ka rongoa alaꞋanga neꞋe ngwae neꞋeri nia faꞋalia ngela kini nia, osiꞋana neꞋe ngela ngwane nia ki kira lia sulia Ꞌua na ru ꞋaeꞋaela nia ki, nia noaꞋa kasi saea ta ru, nia ka maꞋakwalida kike dao basi. ");
INSERT INTO kwf_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Ana kaidaꞋi neꞋe ngela ngwane nia ki kira oli naꞋa maꞋi siana, sa Hamor faꞋinia Ꞌalako nia, kera raꞋe maꞋi, kera ka lidia sariꞋi neꞋeri. Bore ma kaidaꞋi neꞋe ngwaingwaena nia ki kira rongoa alaꞋanga neꞋe, Ꞌalako neꞋeri Ꞌingoa ngwaingwaena kira ka teo faꞋinia, kira ka saetaꞋa lilisu naꞋa. ꞋI maada na falafala neꞋeri nia taꞋa liu mala, ma noaꞋa ta ngwae kasi bolo naꞋa fuana sasilana. Ma kira ka lisia ru neꞋe Ꞌalako neꞋe sasia, nia kwatea luꞋuluꞋua kira ka Ꞌeke liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sui na maꞋa Ꞌalako neꞋeri ka fata Ꞌuri ada, “Ngela Ꞌalako neꞋe nau nia oga liua naꞋa sariꞋi nini Ꞌoe, nia leꞋa diꞋia Ꞌoke alaꞋania nia ke korea. ");
INSERT INTO kwf_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nia leꞋa fuana kuke alua ta taꞋi alaꞋanga neꞋe Ꞌalako kamu ki kike baꞋa kore kini amiꞋa, ma Ꞌalako kamu ki ka kore kini amuꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ma kamu saiana muke baꞋa tua faꞋi kami saena ano neꞋe kami. Kamu ke baꞋa tua ana ta kula goꞋo Ꞌana neꞋe kamu oga Ꞌi neꞋe. Ma kamu saiana muke fulia goꞋo amuꞋa ta ru ni toꞋomaniꞋa faꞋi kami, ma kamu saiana muke toꞋo ana ta ano ꞋamuꞋa ana kula neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Na Ꞌalako neꞋeri ka fata Ꞌuri fuada, “Reala kwa! DiꞋia kamu alafafia alaꞋanga neꞋeri, nai baꞋa kwatea goꞋo Ꞌaku ta ru goꞋo Ꞌana neꞋe kamu oga. ");
INSERT INTO kwf_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nia leꞋa diꞋia kamu saea maꞋi ta fita ru neꞋe kamu oga nai kwatea fuamuꞋa. Ma kamu saiana muke faꞋaraꞋea folifoliꞋa ana sariꞋi neꞋe ke dao ana ta fita ru mala neꞋe kamu oga. DiꞋia kamu alaꞋania nia ke Ꞌafe fuaku, ta folifoliꞋa mala Ꞌana faꞋuta neꞋe kamu alua, nai baꞋa folia.” ");
INSERT INTO kwf_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bore ma osiꞋana neꞋe nia sasia ꞋekeꞋa doe ana sariꞋi neꞋe, na ngwae futa nia ki kira tataꞋe maꞋi, ma kira ka sokea Ꞌalako neꞋe faꞋinia maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kira fata Ꞌuri, “Nia leꞋa goꞋo Ꞌana bore ma kaimili noaꞋa kami kasi alaꞋania ngwaingwaena kami kasi Ꞌafe fuana ta ngwae neꞋe noaꞋa kasi Ꞌolo faꞋataꞋinia, nia neꞋe kwate ma kami ke baꞋa Ꞌeke liu. ");
INSERT INTO kwf_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","TaꞋi falafala goꞋo neꞋe Ꞌuri, ‘DiꞋia kaumulu raꞋe maꞋi ka diꞋia kaimili neꞋe ngwae ki taꞋifau aumulu kamu ke Ꞌolo faꞋataꞋinia nama, nia neꞋe kaimili ke alafafia. ");
INSERT INTO kwf_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","DiꞋia kamu sasi ꞋunaꞋeri, Ꞌalako kamu ki kike kore kini amiꞋa, ma Ꞌalako kami ki kike baꞋa kore kini amuꞋa. Nia ꞋunaꞋeri neꞋe kuke baꞋa diꞋia ngwae ana taꞋi fufuꞋi ngwae goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bore ma diꞋia kamu kasi alafafia ru neꞋe, na ngwae kamu ki kira ka Ꞌolo faꞋataꞋinia, kami ka ngalia ngwaingwaena kami mika leka faꞋasia Ꞌi neꞋe.’” ");
INSERT INTO kwf_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nia leꞋa goꞋo ana, sa Hamor faꞋinia Ꞌalako nia kera rongoa alaꞋanga neꞋeri nia saga goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","GoꞋo Ꞌalako neꞋeri ka leka ka sasi diꞋia neꞋe kira saea nama fuana osiꞋana nia oga liuꞋa naꞋa kini neꞋeri. Sa Sekem ta taꞋi ngwae fiꞋi doe neꞋe kira manata lafua ka liufia ti Ꞌalako ana luꞋuluꞋua kira. ");
INSERT INTO kwf_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Sui kera ka leka tua Ꞌi maana sinamaa ana faꞋi labu ana fanoa doe neꞋeri, na kula neꞋeri ana falafala kira, kula naꞋa fuana alaꞋanga sulia fuli ruuꞋa kira ki ana. Na maꞋa Ꞌalako neꞋeri ka fata Ꞌuri ana ngwaꞋi toꞋa ana fanoa neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Reala, ngwaꞋi toꞋa neꞋe kira oga kike kwaima leꞋa faꞋi kulu ne. Nia leꞋa fuana kuke alaꞋanida kike tua saena ano kulu kike fuli ru Ꞌada. Ano neꞋe doe liu mala ne, ma nia ka bolo goꞋo ana fuakulu taꞋifau. Ma nia ka leꞋa fuakulu kuke alaꞋania Ꞌalako kulu ki kike korea kini kira ki, ma Ꞌalako kira ki ka korea kini kulu ki. ");
INSERT INTO kwf_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bore ma taꞋi ru goꞋo neꞋe fonea ru neꞋeri, na falafala kira, na ngwangwane ki kike Ꞌolo faꞋataꞋinia. Ma kira ka saea diꞋia kulu oga kike tua faꞋi kulu, Ꞌiri kuke alua goꞋo taꞋi fuuꞋi ngwae, kulu ngwangwane ki taꞋifau kuke Ꞌolo faꞋataꞋinia nama. ");
INSERT INTO kwf_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ma mulu lisia basi! Si diꞋia kulu alafafida ma kira ka tua faꞋi kulu na ru ꞋaeꞋaela kira ki taꞋifau ma ti ru laꞋu kike baꞋa ru kulu ki logo. Nia leꞋa kuke alafafia kulu ke sasi diꞋia neꞋe kira saea, ma kira ke baꞋa tua faꞋi kulu.” ");
INSERT INTO kwf_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ma na ngwae ana fanoa doe neꞋeri kira ka alafafia na fatalana ro ngwae neꞋeri ki. Ma ngwaꞋi toꞋa ana fanoa neꞋeri taꞋifau kira ka Ꞌolo faꞋataꞋinia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ma buri Ꞌana uulu asoa ki, ngwangwane ana fanoa doe neꞋeri, kira saiana Ꞌolo faꞋataꞋinia kira ki gagaꞋai Ꞌua. ꞋUnaꞋeri goꞋo ro ngela sa Jakob ki neꞋe satadaroꞋo sa Simion ma sa Lifae, na ro ngwae futa mamana sasiꞋi neꞋeri, kera ka ngalia ro sele ni ofoꞋa kera ki, ma kera ka saumusia ngwangwane ana fanoa doe neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","faꞋinia sa Hamor ma Ꞌalako nia. Ma kera ka ngalia ngwaingwaena kera faꞋasi luma Ꞌalako neꞋeri ma kira ka leka naꞋa faꞋasia luma neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","KaidaꞋi ngwangwane ki kira mae ka sui naꞋa, ti ngwaefuta adaroꞋo sa ro ngwane kira ka leka maꞋi saena fanoa neꞋeri, ma kira ka ngalia ru ngwae ana fanoa neꞋeri ki taꞋifau, ma kira ka faꞋalia naꞋa fanoa doe neꞋeri. Ma na falafala neꞋeri neꞋe kira ka duꞋua na ꞋekeꞋa doe neꞋe Ꞌalako neꞋeri nia sasia ana ngwaingwaena kira. ");
INSERT INTO kwf_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kira ka ngalia sipsip faꞋinia nanigot, faꞋinia buluka ma dongki kira ki, ma ti ru matamata laꞋu neꞋe teo saena fanoa doe neꞋeri ma ano kalikalia kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ma kira ka ngalia kini ki, ma ngela ana fanoa neꞋeri, ma ru ki taꞋifau ana luma kira ki. Ana kaidaꞋi neꞋeri, kira ka ngalia leꞋalana ru neꞋe teo ana fanoa neꞋeri, ma kira ka ngalida ma kira ka leka naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Sui sa Jakob ka fata Ꞌuri fuana ro ngela nia ki, “Ro ngwane! KoroꞋo sasia naꞋa taꞋi fuli bareꞋa doe fuaku. KaidaꞋi neꞋe fufuꞋi ngwae Ꞌi Kenan faꞋinia fufuꞋi ngwae Ꞌi Peris, ma ti ngwae matamata neꞋe kira tua kwailiu ana fanoa ꞋaꞋana neꞋe, kira kasi oga nau naꞋa, kike baꞋa abula sauli nau, bore ma kulu Ꞌiri Ꞌoro goꞋo. Si diꞋia kira fiku, ma kika fuꞋali kulu, kulu kasi baꞋa liu naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bore ma keraꞋa ka fata Ꞌuri ana, “FaꞋuta? ꞋOko oga kike sasia ngwaingwaena keroꞋo ke diꞋia ta kini sesele goꞋo ana?” ");
INSERT INTO kwf_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ꞋUnaꞋeri Iawe ka fata Ꞌuri ana sa Jakob, “ꞋOke oli Ꞌuana Ꞌi Betel ko tua Ꞌi neꞋeri, ꞋOke Ꞌuia nama ta fuli fuꞋa fuana foꞋosilaku. NauꞋa naꞋa neꞋe God ba nau ku dao toꞋomu ana kaidaꞋi ba Ꞌoko tafi faꞋasia ngwaefuta Ꞌoe sa Esau.” ");
INSERT INTO kwf_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Sui sa Jakob sa fata Ꞌuri fuana luꞋuluꞋua nia ma faꞋinia ngwae ki taꞋifau neꞋe kira tua faꞋinia, “Kaumulu muke toꞋosia na god ana ti fanoa matamata neꞋe kaumulu toꞋo ani saena luma kamu ki. Kamu ke faꞋasikasika kamu talamuꞋa Ꞌi maana God, ma kamu ka ofi Ꞌania ifi faolu ki. ");
INSERT INTO kwf_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kulu ke baꞋa faꞋasia kula neꞋe, ma kulu ka leka tua Ꞌi Betel. Ma ana kula neꞋeri nai baꞋa Ꞌuia ta sulufaua fuana foꞋosilana God. KaidaꞋi ki, kaidaꞋi nau ku toꞋo ana ꞋafitaꞋi Ꞌanga, nia ka Ꞌafi nau, ma ka tua tari faꞋi nau ana kula nau ku liu ani ki.” ");
INSERT INTO kwf_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ma kira ka ngalia god ana ti fanoa matamata ki, ma kome Ꞌi alingada ki logo neꞋe kira aluꞋi, ma kira ka ngalia maꞋi ru ki taꞋifau, ma kira ka kwatea fuana sa Jakob. Ma nia ka leka kwau faꞋasia fanoa doe neꞋeri, ma ka kwaiatoa ru neꞋeri ki Ꞌaena ai Ok karangia fanoa doe Ꞌi Sekem. ");
INSERT INTO kwf_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","KaidaꞋi sa Jakob ma ngwaꞋi ngela nia kira faꞋasia kula neꞋeriꞋa, kira leka bore ma noaꞋa ta ngwae kasi leka Ꞌi burida ka lalida, duꞋungana God nia kwatea ngwae ki ana na fanoa neꞋeri kira ka maꞋungida liu. ");
INSERT INTO kwf_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ꞋUnaꞋeri kira ka dao naꞋa ana fanoa doe Ꞌi Lus neꞋe sata Ꞌua ana Ꞌi Betel, neꞋe tua ana fanoa ꞋaꞋana neꞋe kira saea Ꞌani Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nia ka Ꞌuia taꞋi sulufaua ana kula neꞋeri, ma nia ka saea kula neꞋeri Ꞌania Ꞌi El Betel, neꞋe fadalana “God Ꞌi Betel,” osiꞋana Ꞌi naꞋo kaidaꞋi ba nia tafi faꞋasia sasina, God dao toꞋona ana kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Sui na kini ngwaro neꞋe kira saea Ꞌania Ꞌi Debora ka mae ana kula neꞋeri, ma kira ka kwaiatoa Ꞌi Ꞌaena taꞋi ai Ok bali Ꞌuana gwauna fanoa ana Ꞌi Betel. Ma osiꞋana ru neꞋeri, kira saea Ꞌai Ok neꞋeri Ꞌani Aloubakut, neꞋe fadalana “Ai Ok neꞋeri kula fuana angiꞋa.” Na kokoꞋo neꞋe nia lia sulia Ꞌi Rebeka, Ꞌafe sa Aesak, kaidaꞋi Ꞌi Rebeka tiꞋitiꞋi Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tala Ꞌae maꞋi ana kaidaꞋi neꞋe sa Jakob nia faꞋasia Ꞌi Mesopotemia, leleka maꞋi ka dao Ꞌi Betel, God nia dao laꞋu toꞋona, ma ka faꞋaleꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God eta fata maꞋi Ꞌuri fuana ba, “Satamu neꞋe sa Jakob, bore ma eta Ꞌi taꞋena satamu neꞋe sa Jakob naꞋa.” Sui God ka saea Ꞌania sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma nia ka fata Ꞌuri fuana, “NauꞋa naꞋa neꞋe God, nau ku toꞋo ana ngasingasiꞋanga ki taꞋifau. ꞋOke toꞋo ana ngela Ꞌoro neꞋe kike baꞋa futa maꞋi ana kwalafa Ꞌoe. ꞋAeꞋo Ꞌoke baꞋa koꞋo fuana ngwae ana kula Ꞌoro ki, ma na tatalafaꞋa ki kike baꞋa futa ana kwalafa Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ꞋI naꞋo nau ku kwatea na ano neꞋe fuana sa Abraham ma sa Aesak ma nai baꞋa kwatea laꞋu fuamu ma na kwalafa Ꞌoe neꞋe kira futa amu.” ");
INSERT INTO kwf_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sui God ka faꞋasia laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ꞋUnaꞋeri sa Jakob ka faꞋauua taꞋi gwaꞋi fau laꞋu ana kula neꞋeri, nia ka kisitaꞋinia waen ma olif ngwaingwai ka kwatea ka abu ma nia na ru fuana manata Ꞌanga toꞋona kaidaꞋi neꞋe God alaꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma nia ka saea laꞋu kula neꞋeri Ꞌania Ꞌi Betel. ");
INSERT INTO kwf_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sa Jakob faꞋinia ngwae nia ki, kira faꞋasia Ꞌi Betel ma kira ka leka Ꞌuana kula kira saea Ꞌania Ꞌi Efrat. Bore ma kaidaꞋi kira Ꞌua sulia tala, Ꞌi Rachel ka saiana neꞋe nia ke faꞋafuta laꞋu ta ngela ana. Bore ma nia ka toꞋo ana ꞋafitaꞋi Ꞌanga, sulia ngela neꞋeri kasi futa ꞋaliꞋali. ");
INSERT INTO kwf_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ma kaidaꞋi Ꞌi Rachel nia faꞋafuta na ngela neꞋeri nia ka nonifii liu naꞋa. Ma na kini neꞋe ka kwaiꞋafi ana nia ka lisia na ngela, nia fata Ꞌuri, “Rachel, ta ngela ngwane laꞋu niniꞋa. ꞋOe kosi maꞋu.” ");
INSERT INTO kwf_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Bore ma Ꞌi Rachel karangi ka mae naꞋa, ma nia ka saea ngela neꞋeri Ꞌania sa Benoni fadalana neꞋe “Ngela nau ku nonifii ana.” Ma kaidaꞋi nia faꞋasata ngela neꞋeri ka sui nia ka mae naꞋa. Bore ma buri Ꞌana, sa Jakob ka saea Ꞌani sa Benjamin neꞋe fadalana “Ngela neꞋe ke baꞋa toꞋo ana mauriꞋa leꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Maelana Ꞌi Rachel neꞋe ꞋunaꞋeri. Ma kira ka kwaiatoa Ꞌi ninimana tala neꞋe leka Ꞌuana kula kira saea Ꞌania Ꞌi Efrat neꞋe niniꞋari kira saea Ꞌani Ꞌi Betlehem. ");
INSERT INTO kwf_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Siu sa Jakob ka faꞋauua taꞋi gwaꞋi fau ana kula neꞋeri fuana mamanata Ꞌanga toꞋona kilu gwaꞋu neꞋeri leleka ka dao Ꞌi taꞋena. ");
INSERT INTO kwf_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Buri Ꞌana sa Israel ka faꞋasia kula neꞋeri ka leka Ꞌuana Ꞌi gwauna fanoa leleka ka liufia luma ni lialiaꞋa ana kula neꞋe kira saea Ꞌania Ꞌi Eda. Ma kira ka saungaꞋinia fanoa kira Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","KaidaꞋi kira tua ana kula neꞋeri sa Ruben ka leka teo faꞋinia kini rao neꞋe kira saea Ꞌani Ꞌi Bilha, neꞋe ta Ꞌafe ana maꞋa nia. Ma kaidaꞋi maꞋa nia rongoa alaꞋanga neꞋeri nia ka saetaꞋa liu. Sa Jakob nia toꞋo ana akwala ma ro ngela ngwane. ");
INSERT INTO kwf_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ngela Ꞌi Lia ki neꞋe sa Ruben faꞋinaꞋonaꞋo sa Jakob, ma sa Simion, sa Lifae, sa Juda, sa Isakar, ma sa Sebulun. ");
INSERT INTO kwf_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ma ngela Ꞌi Rachel ki neꞋe sa Josef, ma sa Benjamin. ");
INSERT INTO kwf_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ma na ngela Ꞌi Bilha na kini rao Ꞌi Rachel neꞋe sa Dan, sa Naftali. ");
INSERT INTO kwf_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ma ngela Ꞌi Silpa na kini rao Ꞌi Lia ki neꞋe sa Gad ma sa Asa. ");
INSERT INTO kwf_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ꞋUnaꞋeri sa Jakob ka leka Ꞌi Kiriataba neꞋe niniꞋari satana Ꞌi Hebron neꞋe karangia Ꞌi Mamre. ꞋI neꞋeri neꞋe kula koꞋo nia sa Abraham nia tua ana Ꞌi naꞋo, ma buri Ꞌana na maꞋa nia sa Aesak ka tua laꞋu ana. Ana kaidaꞋi neꞋeri, nia ka leka tua naꞋa faꞋinia maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Sa Aesak tua leleka nia ka ngwaro liu naꞋa, nia ka fiꞋi mae, ma nia ka leka sulia koꞋo bora nia ki Ꞌi naꞋo ba kira mae ka sui naꞋa. Ma kaidaꞋi nia mae, nia tua naꞋa sulia taꞋi talangaꞋi ma kwalu akwala faꞋi ngali. Ro ngela neꞋe nia ki, sa Esau ma sa Jakob naꞋa neꞋe kera kwaiatoa. ");
INSERT INTO kwf_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Sa Esau neꞋe ta sata laꞋu ana sa Idom. Na ꞋaꞋemae sulia kwalafa sa Esau nia Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nia korea ro kini ki Ꞌi Kenan, neꞋe satadaroꞋo Ꞌi Ada, ma Ꞌi Oholibama. ꞋI Ada neꞋe maꞋa nia sa Elon ngwae ana kwalafa sa Het, ma Ꞌi Oholibama neꞋe maꞋa nia sa Ana, ma nia na koꞋo tiꞋitiꞋi sa Sebeon nia ngwae ana kwalafa sa Hivi. ");
INSERT INTO kwf_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ma nia ka korea laꞋu ta kini neꞋe satana Ꞌi Basemat, ma maꞋa nia neꞋe sa Ishmael ma na ngwaingwaena leꞋa sa Nebaeot. ");
INSERT INTO kwf_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Ma ngela sa Esau ki neꞋe satada sa Elifas, neꞋe teꞋa nia Ꞌi Ada, ma sa Jehus, sa Jalam, sa Kora ma teꞋa kira Ꞌi Oholibama, ma sa Rehuel neꞋe teꞋa nia Ꞌi Basemat. Ngela sa Esau ki neꞋeriꞋa, neꞋe kira futa ana fanoa ꞋaꞋana neꞋe kira saea Ꞌani Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ꞋUnaꞋeri sa Esau ka ngalia uulu Ꞌafe neꞋe ki, faꞋinia ngela nia ki faꞋinia ngwae neꞋe kira tua faꞋinia ki, ma faꞋinia ru ꞋaeꞋaela nia ki, ma ru nia ki taꞋifau neꞋe nia toꞋo ani ki Ꞌi Kenan, nia ka faꞋasia ngwaefuta nia sa Jabok ma nia ka leka tua naꞋa Ꞌana ana ta fanoa matamata. ");
INSERT INTO kwf_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nia ka faꞋasia, osiꞋana ano neꞋe kera tua ana noaꞋa Ꞌiri bolo faꞋinidaroꞋo naꞋa, fuana kwatelana fanga fuana ru ꞋaeꞋaela keroꞋa ki sulia ru ꞋaeꞋaela keraꞋa ki Ꞌoro liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ꞋUnaꞋeri sa Esau leka ka tua naꞋa Ꞌi gwauna faꞋi ua ana fanoa kira saea Ꞌani Ꞌi Idom neꞋe sata Ꞌua nia Ꞌi Seir. ");
INSERT INTO kwf_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Na ꞋaꞋemae sulia kwalafa sa Esau neꞋe kira tua Ꞌi gwauna faꞋi ua ki Ꞌi Idom, nia Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Na fuuꞋi ngwae neꞋe kira futa maꞋi ana kwalafa sa Esau neꞋe Ꞌuri. Ngela nia sa Elifas neꞋe Ꞌi Ada nia alua, nia alua lima ngela ngwane ki. Satada neꞋe sa Teman, sa Omar, sa Sefo, sa Gatam, ma sa Kenas. Sa Elifas nia toꞋo ana taꞋi kini rao neꞋe satana Ꞌi Timna, ma nia ta Ꞌafe logo ana neꞋeriꞋa. ꞋAfe neꞋeri ka alua taꞋi ngela ngwane na satana neꞋe sa Amalek. Ngela sa Esau, sa Rehuel neꞋe Ꞌi Basemat nia alua, nia toꞋo ana faꞋi ngela ngwane ki neꞋe satada sa Nahat, sa Sera, sa Sama, ma sa Misa. ");
INSERT INTO kwf_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ma uulu ngela sa Esau ki, sa Jehus, sa Jalam, sa Kora neꞋe kira futa ana Ꞌi Oholibama uulu ngwae neꞋeri ki kira toꞋo laꞋu ana ti ngela ada. ");
INSERT INTO kwf_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Nia ne na kwalafa sa Esau neꞋe kira alua maꞋa kira ki. Na kwalafa sa Teman ki faꞋinia kwalafa sa Omar ki, ma kwalafa sa Sefo ki, ma kwalafa sa Kenas ki ma kwalafa sa Kora ki, ma kwalafa sa Gatam ki, ma kwalafa sa Amalek ki. Na fufuꞋi ngwae neꞋeri ki neꞋe koꞋo kira sa Elifas, kiraꞋa neꞋe kira futa maꞋi ana Ꞌi Ada Ꞌafe sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Na kwalafa sa Nahat, ma kwalafa sa Sera, ma kwalafa sa Sama, ma kwalafa sa Misa ma kwalafa koꞋo kira sa Rehuel, kiraꞋa neꞋe futa ana Ꞌi Basemat na Ꞌafe sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ma kwalafa sa Jehus, ma kwalafa sa Jalam ki ma kwalafa sa Kora ki, na kwalafa neꞋeri ki neꞋe koꞋo kira sa Esau, kiraꞋa neꞋe kira futa maꞋi ana Ꞌi Oholibama na Ꞌafe sa Esau na maꞋa kini neꞋeri neꞋe sa Ana. ");
INSERT INTO kwf_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","KiraꞋa taꞋifau neꞋe kwalafa sa Esau. ");
INSERT INTO kwf_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","ꞋI naꞋo maꞋi ti fuuꞋi ngwae matamata lala neꞋe kira tuafia kula neꞋeri neꞋe kira saea Ꞌania Ꞌi Idom. Kira futa ana ta taꞋi ngwae neꞋe satana sa Seiri na kwalafa sa Hori. Sa Seiri nia toꞋo ana fiu ngela ki neꞋe futa ana kwalafa nia neꞋe koꞋo kira ta ngwae ana ta kwalafa matamata. Na satada neꞋe sa Lotan, sa Sobal, sa Sibeon, sa Ana, sa Dison, sa Esa, ma sa Disan. ");
INSERT INTO kwf_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Sa Lotan nia koꞋo ana kwalafa sa Hori faꞋinia kwalafa sa Heman. Ma sasina neꞋe Ꞌi Timna. ");
INSERT INTO kwf_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sa Sobal nia koꞋo ana kwalafa sa Alvan ma kwalafa sa Manahat, ma kwalafa sa Ebal, ma kwalafa sa Sefo faꞋinia kwalafa sa Onam. ");
INSERT INTO kwf_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sa Sibeon nia alua ro ngela ngwane ki na satadaroꞋo neꞋe sa Aea, ma sa Ana. Na Ana neꞋe ba dao toꞋona maꞋe busu kafo ꞋakoꞋako ba nia tua ana kula langalanga. Na lisia maꞋe busu neꞋe kaidaꞋi nia tua ana abaꞋi kula ꞋeꞋerede neꞋe nia folo Ꞌusia na dongki maꞋa nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Sa Ana sa Dison ke maꞋa ana ma sa Dison na koꞋo kira kwalafa sa Hemdan ma kwalafa sa Esban, ma kwalafa sa Itran ma kwalafa sa Keran. Ana neꞋe nia alua taꞋi ngela kini neꞋe satana Ꞌi Oholibama. ");
INSERT INTO kwf_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Sa Esa na koꞋo kira kwalafa sa Bilhana, ma kwalafa sa Saavan ma kwalafa sa Akan. ");
INSERT INTO kwf_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Sa Disan na koꞋo kira kwalafa sa Us, ma kwalafa sa Aran. ");
INSERT INTO kwf_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","ꞋUnaꞋeri neꞋe kira ka toꞋo ana kwalafa sa Lotan ki ma kwalafa sa Sobal, ma kwalafa sa Sibeon ki ma kwalafa sa Ana ki, ma kwalafa sa Dison ki ma kwalafa sa Esa ki, ma kwalafa sa Disan ki. Nia neꞋe kwalafa sa Hori ki, neꞋe kira eta tuafia fanoa neꞋe kira saea Ꞌani Idom. ");
INSERT INTO kwf_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ꞋI naꞋo maꞋi kaidaꞋi fuuꞋi ngwae Ꞌi Israel noaꞋa kira Ꞌiri toꞋo Ꞌua ana ta tatalafaꞋa fuada talada, bore ma ngwaꞋi toꞋa Ꞌi Idom ki kira eta toꞋo naꞋa ana tatalafaꞋa kira satada neꞋe Ꞌuri. ");
INSERT INTO kwf_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Etaeta kira toꞋo ana tatalafaꞋa sa Bela neꞋe maꞋa nia sa Beo, ma nia ana maꞋe fanoa doe kira saea Ꞌania Ꞌi Dinaba. ");
INSERT INTO kwf_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Burina kira ka toꞋo ana tatalafaꞋa sa Jobab na maꞋa nia neꞋe sa Sera, ma nia ngwae Ꞌi Bosera. ");
INSERT INTO kwf_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ꞋI buri Ꞌana niaꞋa kira ka toꞋo ana sa Husam ka tatalafaꞋa, na ngwae Ꞌi Teman. ");
INSERT INTO kwf_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Buri Ꞌana niaꞋa, kira ka toꞋo ana tatalafaꞋa sa Hadad, na maꞋa nia sa Bedad, ma nia ana fanoa doe kira saea Ꞌania Ꞌi Aut. TatalafaꞋa Hadad nia leka ka fuꞋalia Midian ki ana fanoa ꞋaꞋana kira saea Ꞌani Moab ma ka liufida. ");
INSERT INTO kwf_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ꞋI buri Ꞌana niaꞋa kira ka toꞋo ana tatalafaꞋa sa Samlah na ngwae Ꞌi Masreka. ");
INSERT INTO kwf_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ꞋI buira kira ka toꞋo ana tatalafaꞋa sa Siaol, na ngwae Ꞌi Rehobot fanoa doe kira saungaꞋinia karangia kafo Ꞌi Iufretes. ");
INSERT INTO kwf_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ꞋI buira kira ka toꞋo ana tatalafaꞋa Balanan neꞋe maꞋa nia sa Akbor. ");
INSERT INTO kwf_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ꞋI buri Ꞌana niaꞋa kira ka toꞋo ana tatalafaꞋa sa Hadad na fanoa doe nia neꞋe kira saea Ꞌani Ꞌi Pao, na Ꞌafe nia neꞋe Ꞌi Mehetabel, neꞋe teꞋa nia Ꞌi Matred, ma koꞋo nia neꞋe sa Mesahab. ");
INSERT INTO kwf_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Na kwalafaꞋa sa Esau ki neꞋeriꞋa neꞋe kira tua Ꞌi Idom. KiraꞋa na kwalafa sa Timna, ma kwalafa sa Alvah, ma kwalafa sa Jetet, ma kwalafa Ꞌi Oholibama ma kwalafa sa Elaha, ma kwalafa sa Pinon, ma kwalafa sa Kenas, ma kwalafa sa Teman ma kwalafa sa Mibsar, ma kwalafa sa Magdiel, ma kwalafa sa Iram. KiraꞋa taꞋifau ana kwalafa sa Esau. Ma kaidaꞋi ki kula kira tua ani ki, kira faꞋasata Ꞌania koꞋo kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Sa Jakob tua Ꞌua Ꞌana ana fanoa ꞋaꞋana kira saea Ꞌani Ꞌi Kenan, kula neꞋe maꞋa nia tua ana Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Na ꞋaꞋemae sulia kwalafa sa Jakob nia Ꞌuri: Sa Josef taꞋi ngwae fiꞋi doe neꞋe nia doe naꞋa maꞋi sulia akwala ma fiu faꞋi ngali ki, ma ana kaidaꞋi Ꞌoro ki nia leka faꞋinia ngwaefuta nia ki fuana foloꞋa Ꞌusia sipsip ma nanigot maꞋa kira ki. Na ngwaefuta nia ki neꞋe ngela Ꞌi Bilha, ma Ꞌi Silpa ta ro Ꞌafe ana maꞋa kira. KaidaꞋi Ꞌoro nia ngali alaꞋanga fuana maꞋa kira, ru taꞋa neꞋe ngwaefuta nia ki kira sasiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","OsiꞋana maꞋa kira nia alua kaidaꞋi nia ngwaro naꞋa, nia ka kwaima ana sa Josef ka liufia naꞋa ti ngwaefuta ana. Nia ka taia taꞋi toꞋongi keta fuana neꞋe kedokedoꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ꞋUnaꞋeri ngwaefuta nia ki kira ka lisia neꞋe maꞋa kira kwaima ana ka liufida, goꞋo kira ka Ꞌaila liu naꞋa Ꞌania, ma kira ka ilangani liu naꞋa, ma noaꞋa kira kasi alaꞋa leꞋa naꞋa fuana. ");
INSERT INTO kwf_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Ma ana taꞋi rodo nia ka maliu bole, ma asoa Ꞌi buri, nia ka alaꞋa sulia maliu boleꞋa neꞋeri fuana ngwae futa nia ki. Nia fata Ꞌuri, “ꞋAi reala, mulu rongoa basi maꞋi maliu boleꞋa nau ana rodo sui toli, nau ku maliu bole, ma nau ku lisia kulu uu taꞋifau saena oꞋola witi, ma kulu ka foꞋota na fofo witi neꞋe toꞋo naꞋa ana fuaꞋi ru ki. Ma fofo ai neꞋe nau ku foꞋota nia uu saga, bore ma fofo ru neꞋe kaumulu foꞋotaꞋi ki, kira uu kalia ma kira ka bobo uruuru ma kira ka faꞋa ꞋaꞋana fofo ai nau.” Bore ma kaidaꞋi kira rongoa alaꞋanga neꞋeri, kira ka Ꞌaila laꞋu Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ma kira ka fata Ꞌuri ana, “FaꞋuta, Ꞌoko fia fasi Ꞌoke baꞋa tatalafaꞋa, ma Ꞌoko ꞋaꞋana fuaimili niniꞋa kwa?” Ma kira ka Ꞌaila liu naꞋa Ꞌania faꞋinia maliu boleꞋa nia ki, ma alaꞋanga neꞋe nia saeꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Sui Ꞌi buri nia ka lisia laꞋu ta maliu boleꞋa ma nia ka leka alaꞋa sulia fuada ka Ꞌuri, “Nau ku lisida laꞋu ta maliu boleꞋa neꞋe madaꞋafi ma na madamo ma akwala ma taꞋi faꞋi bulubulu kira bobo uruuru ma kira ka faꞋa ꞋaꞋana nau.” ");
INSERT INTO kwf_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ma nia ka faꞋarongoa logo maꞋa nia Ꞌania maliu boleꞋa neꞋeri, goꞋo maꞋa kira ka fata Ꞌuri ana, “Maliu boleꞋa faꞋuta naꞋa niniꞋa re! ꞋOko fia nauꞋa faꞋinia teꞋa Ꞌoe faꞋinia ngwae futa Ꞌoe ki mike baꞋa leka maꞋi mika bobo uruuru fuamu? Falafala faꞋuta neꞋe ꞋunaꞋeri?” ");
INSERT INTO kwf_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ꞋUnaꞋeri ngwae futa nia ki kira ka manata Ꞌugalia, bore ma maꞋa kira tua ka manata ana sulia fadalana ru neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ana taꞋi kaidaꞋi, ngwae futa sa Josef ki kira leka Ꞌuana Ꞌi Sekem fuana foloꞋa Ꞌusia sipsip faꞋinia nanigot maꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sui maꞋa kira sa Israel ka fata Ꞌuri fuana sa Josef, “Nau ku oga Ꞌoke leka Ꞌuana kula ngwaefuta Ꞌoe ki tua ana fuana liaꞋa sulia ru ꞋaeꞋaela nau ki.” Ma nia ka fata Ꞌuri, “Nia leꞋa goꞋo Ꞌana. Nai baꞋa leka.” ");
INSERT INTO kwf_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","GoꞋo maꞋa kira ka fata Ꞌuri fuana, “Nau ku oga Ꞌoke leka ngali maꞋi ti alaꞋanga faꞋasia na ngwaefuta Ꞌoe ki, fasi Ꞌiri nai saiana neꞋe kira tua leꞋa goꞋo ada, ma ru ꞋaeꞋaela kira ki leꞋa goꞋo Ꞌana nama faꞋuta. Buri Ꞌana Ꞌoko oli maꞋi, ko faꞋarongo nau.” ꞋUnaꞋeri maꞋa nia ka asungaꞋinia ka leka kwau. Ana kaidaꞋi neꞋeri sa Jakob nia tua goꞋo ana oteotea Ꞌi Hebron, ma sa Josef ka faꞋasia kula neꞋeri, ma ka liu ka leka naꞋa. Ana kaidaꞋi nia dao Ꞌi Sekem, ");
INSERT INTO kwf_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","nia ka leka liu ana kula abitako karangi fanoa doe neꞋeri, ma taꞋi ngwae ka saka fuana ma ka fata Ꞌuri ana, “Sa tai neꞋe Ꞌoko lulua?” ");
INSERT INTO kwf_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ma nia ka fata Ꞌuri, “Nau ku lulua ngwaefuta nau ki ne. Kira folo Ꞌusia sipsip ki ma nanigot maꞋa kami ki. ꞋUri ma Ꞌoko Ꞌiri lisida ana ta kula?” ");
INSERT INTO kwf_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Sui ngwae neꞋeri ka fata Ꞌuri, “ꞋIu, nau ku lisida, bore ma kira faꞋasia naꞋa kula neꞋeri. Nau ku rongoa kira saea kike leka Ꞌuana Ꞌi Dotan.” ꞋUnaꞋeri sa Josef ka leka Ꞌi burida, ma kaidaꞋi nia dao Ꞌi Dotan, nia ka lisida naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","KaidaꞋi sa Josef nia dao tau Ꞌua maꞋi, kira ka lisia naꞋa, ma kira ka naia naꞋa neꞋe kike saungia nia ka mae. ");
INSERT INTO kwf_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kira ka alaꞋa Ꞌuri talada, “Mulu saungia ngwae ba fuana maliu boleꞋa nena nia naꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kulu saungia ke mae, kulu ka Ꞌui Ꞌania nonina saena ta taꞋi kilu kafo ana kilu kafo neꞋe ki. Kuke baꞋa leka saea fuana maꞋa kulu neꞋe ta ru kwasi neꞋe saungia ka mae naꞋa, ma ka Ꞌania. Ru neꞋeri neꞋe ke baꞋa fonea maliu boleꞋa ba nia ki.” ");
INSERT INTO kwf_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bore ma kaidaꞋi sa Ruben nia rongoa alaꞋalada, nia ka ili Ꞌuana ke faꞋamauria sa Josef. ");
INSERT INTO kwf_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nia ka fata Ꞌuri, “NoaꞋa kulu kasi saungia. NoaꞋa kulu kasi faꞋalia. Nia leꞋa fuana kulu ke Ꞌui goꞋo Ꞌania saena ta kilu kafo ana kilu kafo saena kula ꞋeꞋerede neꞋe.” Nia fata ꞋunaꞋeri duꞋungana nia naia ke faꞋamauria faꞋasida, ma Ꞌi buri Ꞌana nia ke baꞋa ngalia ka oli faꞋinia siana maꞋa kira. ");
INSERT INTO kwf_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Ana kaidaꞋi sa Josef nia leka karangi goꞋo maꞋi, kira ka loba naꞋa, kira ka kanusua naꞋa ifi keta nia, ma kira ka Ꞌui Ꞌania toli saena taꞋi kilu kafo neꞋe langalanga naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ma kaidaꞋi kira fanga naꞋa Ꞌada, kika lisia taꞋi fikutaꞋi ngwae Ꞌoifoli ana kwalafa sa Ishmael neꞋe kira Ꞌita maꞋi faꞋasia Ꞌi Gilead neꞋe kira leka Ꞌuana Ꞌi Ejipt. Na kamel kira ki ngalia koko ru Ꞌoro ki, diꞋia ru fuana guraꞋa ki ma ti ru laꞋu neꞋe moko ufi ufi leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ꞋUnaꞋeri sa Juda ka fata Ꞌuri fuana ngwaefuta nia ki, “DiꞋia kulu saungia na ngwaefuta kulu, ma kulu ka sofongaꞋinia goꞋo akulu ru neꞋe, kulu kasi liufia goꞋo ta ru. ");
INSERT INTO kwf_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nia leꞋa kulu ke Ꞌoifoli goꞋo Ꞌania ana ngwae loꞋoko ki. ꞋUnaꞋeri neꞋe noaꞋa kulu kasi faꞋalia, duꞋungana ngwaefuta kulu goꞋo niniꞋa! Ma kuluꞋa taꞋifau kulu futa goꞋo ana taꞋi maꞋa.” Ma kiraꞋa taꞋifau kika alafafia, bore ma sa Ruben neꞋe noaꞋa Ꞌiri tua faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ꞋUnaꞋeri kaidaꞋi ngwae Ꞌoifoli ki Ꞌi Midian kira leka karangi maꞋi, kira ka leka lafua maꞋi sa Josef faꞋasia kilu kafo neꞋeri laꞋu, ma kira ka foli Ꞌania ana ngwae Ꞌoifoli neꞋeri ki fuana ro akwala selen silva ki, ma ngwaꞋi toꞋa neꞋeri kira ka ngalia naꞋa Ꞌuana Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bore ma kaidaꞋi sa Ruben oli laꞋu Ꞌuana kilu kafo neꞋeri, nia noaꞋa kasi lisia naꞋa sa Josef Ꞌi saena. Ma nia ka saiana nia taꞋa liu naꞋa ana, ma nia ka gasia na toro nia talana, osiꞋana nia kwaimanatai liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nia ka oli siana ngwaefuta nia ki, ma ka Ꞌuri, “Ai reala kwa! Sa Josef nia noaꞋa naꞋa saena kilu kafo loꞋoba. Tae naꞋa nini nai baꞋa sasia?” ");
INSERT INTO kwf_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ꞋUnaꞋeri kira ka ngalia taꞋi nanigot, kira ka saungia, kira ka alua toꞋongi sa Josef saena Ꞌabuna nanigot neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Burina kaidaꞋi kira ngalia toꞋongi kika oli faꞋinia fuana maꞋa kira, kika fata Ꞌuri ana, “MaꞋasi, kaimili dao toꞋona toꞋongi neꞋe. ꞋOke lia leꞋa ana. Sali toꞋongi ba sa Josef taka niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ma sa Jakob ka lia saiana toꞋongi neꞋeri ma nia ka fata Ꞌuri, “ꞋIu, toro nia naꞋa niniꞋa. Ngela nau niniꞋa ta ru ꞋaeꞋaela nini saungia ka mae naꞋa! Ta taꞋi ru Ꞌania ka sui naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ꞋUnaꞋeri sa Jakob ka gasia na toro nia ki osiꞋana nia kwaimanatai liu naꞋa. Sui nia ka ofi naꞋa Ꞌania muꞋimuꞋi na toro, ma nia ka angi tau liu naꞋa Ꞌuana ngela nia. ");
INSERT INTO kwf_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ma ngwaꞋi ngela ngwane nari nia faꞋinia ngela kini nia ki kika leka ili Ꞌuana gwalelana, bore ma noaꞋa nia kasi saeleꞋa naꞋa. Nia ka inaꞋu naꞋa ana alaꞋanga Ꞌuri, “Nai baꞋa kwaimanatai Ꞌuri Ꞌuana ngela nau, leleka ka dao ana kaidaꞋi nai mae.” Ma nia ka inaꞋu ana angia Ꞌuana ngela nia. ");
INSERT INTO kwf_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Bore ma ana kaidaꞋi neꞋeri, ngwaꞋi toꞋa Ꞌi Midian, kira ngalia sa Josef Ꞌuana Ꞌi Ejipt, kira ka Ꞌoifoli laꞋu Ꞌania ana ngwae ꞋaꞋana ana fanoa neꞋeri. Ngwae ꞋaꞋana neꞋeri, satana sa Potifa, nia neꞋe na ngwae gwaungaꞋi fuana ngwae ki neꞋe kira lia sulia luma tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ana kaidaꞋi neꞋeri, sa Juda ka faꞋasia na ngwaefuta nia ki, nia ka leka tua ana luma taꞋi ngwae na satana sa Hirah neꞋe tua ana fanoa doe Ꞌi Adulam. ");
INSERT INTO kwf_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ana kula neꞋeri sa Juda ka lisia kini sariꞋi sa Sua taꞋi ngwae Ꞌi Kenan, ma nia ka korea naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","KeroꞋa ka tua fiku naꞋa, ma Ꞌafe nia ka ina ma ka faꞋafuta taꞋi ngela ngwane, ma maꞋa nia ka saea Ꞌania sa Era. ");
INSERT INTO kwf_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sui Ꞌi buri Ꞌana Ꞌafe neꞋeri ka faꞋafuta ta ngela ngwane laꞋu, nia ka saea Ꞌani sa Onan. ");
INSERT INTO kwf_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma Ꞌi buri laꞋu nia ka faꞋafuta laꞋu ta ngela ngwane, ma nia ka saea Ꞌania sa Sela. KaidaꞋi ngela neꞋeri nia futa, kera tua naꞋa ana ta kula neꞋe kira saea Ꞌani Ꞌi Kesib. ");
INSERT INTO kwf_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Buri Ꞌana sa Juda ka leka lia Ꞌuana ta ngela kini sariꞋi fuana Ꞌalako nia sa Era, ꞋunaꞋeri nia ka baꞋea maꞋi taꞋi sariꞋi neꞋe satana Ꞌi Tamar, ma Ꞌalako neꞋeri ka korea. ");
INSERT INTO kwf_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bore ma falafala Ꞌalako neꞋeri taꞋa, ka Ꞌiri saga Ꞌi maana Iawe, goꞋo Iawe ka saungia nia ka mae. ");
INSERT INTO kwf_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sui sa Juda ka fata Ꞌuri ana ruana ngela neꞋe sa Onan, “Nia leꞋa fuana Ꞌoke ngalia Ꞌuruna ngwaefuta Ꞌoe. AraꞋi nia na ngwaefuta teꞋa Ꞌoe mala, ma nia leꞋa fuana Ꞌoke tua faꞋinia ꞋunaꞋeri neꞋe na ngwaefuta Ꞌoe ba mae naꞋa saiana ke baꞋa toꞋo ana ngela nia ki.” ");
INSERT INTO kwf_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bore ma ruana ngwaefuta neꞋeri sai leꞋa ana diꞋia Ꞌafe neꞋeri nia faꞋafuta ngela ki, na ngela neꞋeri ki noaꞋa laꞋu ngela nia ki bore ma kira ngela ngwaefuta nia ki lala ba mae ka sui naꞋa. Ma nia ka ngalia kini neꞋeri, bore ma kaidaꞋi nia ka teo faꞋinia, nia sasia ru neꞋe kini neꞋeri kasi toꞋo ana ngela neꞋe kike saea Ꞌania satana ngwaefuta nia. ");
INSERT INTO kwf_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Bore ma falafala neꞋeri noaꞋa kasi saga Ꞌi maana Iawe, ꞋunaꞋeri Iawe ka saungia nia ka mae logo. ");
INSERT INTO kwf_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Sui sa Juda ka fata Ꞌuri ana Ꞌuru neꞋeri, “ꞋOke oli naꞋa Ꞌi lima maꞋa Ꞌoe, ma Ꞌoko aroaro naꞋa Ꞌamu. Ma noaꞋa Ꞌoe kosi Ꞌafe laꞋu, leleka ngela ꞋisiꞋisi neꞋe nau sa Sela ka ꞋaꞋana.” Nia alaꞋa ꞋunaꞋeri sulia nia maꞋu, Ꞌasu Ꞌubani Iawe ka fiꞋi saungia ngela ꞋisiꞋisi neꞋeri ka mae logo, diꞋia logo ba nia saungia ro ngwaefuta nia ki. Ma gwaꞋi Ꞌuru neꞋeri ka oli naꞋa Ꞌi luma maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ꞋI buri Ꞌana neꞋe Ꞌafe sa Juda nia mae, ma sa Juda ka angi Ꞌuana leleka ka dao ana suilana kwaimanatai Ꞌanga, nia faꞋinia ngwae kwaima nia sa Hirah kera ka leka Ꞌi Timna. Ana kula neꞋeri ngwae nia ki kira sufia ifuna sipsip nia ki ana. ");
INSERT INTO kwf_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Na gwaꞋi Ꞌuru neꞋeri nia rongoa neꞋe maꞋa araꞋi nia mae ꞋunaꞋeri, nia ka leka Ꞌuana Ꞌi Timna ka lulua ngwae rao nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Sui nia ka lafua toro bulibuli nia ki neꞋe nia ruꞋufiꞋi sulia nia na Ꞌuru, ma nia ka ruꞋufia laꞋu ti toro, ma nia ka alua taꞋi Ꞌaba toro ka fonea maana, fasi Ꞌiri ngwae ki noaꞋa kasi lia saiana, nia ka leka Ꞌuana fanoa ꞋaꞋana kira saea Ꞌania Ꞌi Enaem, nia ka leka tua Ꞌi maana sinamaa ana faꞋi labu doe. Fanoa doe neꞋeri tua sulia tala leka Ꞌuana Ꞌi Timna. Nia sasi ꞋunaꞋeri sulia nia sai leꞋa ana sa Sela, susu buri ana araꞋi nia Ꞌi naꞋo, nia doe naꞋa, bore ma maꞋa Ꞌalako neꞋe noaꞋa Ꞌiri saea fuana neꞋe ke leka ma ka korea. ");
INSERT INTO kwf_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ma kaidaꞋi sa Juda nia lisia, nia ka manata Ꞌuri, “Sali ta kini sesele goꞋo Ꞌana niniꞋa, osiꞋana nia fonea maana Ꞌania Ꞌaba ifi ꞋunaꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nia ka leka karangia Ꞌi ninimana tala, nia ka fata Ꞌuri fuana, “Ai, nau ku oga nai teo faꞋiniꞋo.” Bore ma nia Ꞌiri saiana goꞋo neꞋe kini neꞋe na Ꞌuruna ro ngela ngwane naꞋo nia ki. ꞋUnaꞋeri kini neꞋeri ka saefilo Ꞌuri ana, “Ta fita ru neꞋe Ꞌoke baꞋa foli nau Ꞌania?” ");
INSERT INTO kwf_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma nia ka fata Ꞌuri, “Nai baꞋa ngalia taꞋi kala nanigot nau, nau ku kwatea kwau fuamu.” Sui kini neꞋeri ka fata Ꞌuri, “LeꞋa goꞋo Ꞌana, bore ma Ꞌoke kwatea maꞋi ti ru fuaku ke faꞋataꞋinia na alangaꞋilamu neꞋe nai eta dau ana Ꞌi naꞋo, leleka kala nanigot neꞋana ka dao maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","ꞋUnaꞋeri nia ka saefilo Ꞌuri ana, “Ru faꞋuta neꞋe Ꞌoko oga nai kwatea fuamu?” Sui kini neꞋeri ka fata Ꞌuri, “ꞋOke kwateꞋa maꞋi ru ba fuana totolana kerekereꞋa Ꞌoe ki, faꞋinia gwaꞋi dadalo Ꞌoe, ma faꞋi kuba Ꞌoe.” Nia ka kwatea ro ru neꞋeri ki fuana. Ma nia ka leka ka teo naꞋa faꞋinia. Buri Ꞌana, kini neꞋeri ka oli Ꞌi fanoa nia sui nia ka lafua na Ꞌaba ifi neꞋe nia fonea Ꞌania maana, ma nia ka ruꞋufia laꞋu toꞋongi bulibuli nia ki neꞋe nia ruꞋu ruꞋufiꞋi, osiꞋana nia na gwaꞋi Ꞌuru. NoaꞋa Ꞌiri tau goꞋo nia ka lisia neꞋe nia ina naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ꞋUnaꞋeri sa Juda ka kwatea taꞋi kala nanigot fuana kwaima nia sa Hirah, ma nia ka kwatea nia ke olitaꞋinia maꞋi ro ru ba nia faꞋasia maꞋi faꞋinia kini baera. Bore ma ngwae neꞋeri kasi dao toꞋona kini baera. ");
INSERT INTO kwf_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nia ka saefiloa ngwae Ꞌi Eneam ki ka Ꞌuri, “Na kini sesele ba tuatua Ꞌi ninimana tala nia tua Ꞌi faꞋi ba?” Bore kiraꞋa taꞋifau kika fata Ꞌuri, “Kaimili noaꞋa Ꞌiri toꞋo ana ta kini sesele ana fanoa neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Sui nia ka oli maꞋi siana sa Juda, ma ka fata Ꞌuri fuana, “Nau noaꞋa kusi dao toꞋona kini baera. Ma ngwaꞋi toꞋa Ꞌi Enean kika saea kira noaꞋa kasi toꞋo ana ta kini sesele Ꞌi fanoa kira.” ");
INSERT INTO kwf_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ꞋUnaꞋeri sa Juda ka fata Ꞌuri, “AlaꞋania nia ke gonia Ꞌana ro ru ba kiri. Nia leꞋa Ꞌasu Ꞌubani ngwae ki kira kata gaꞋasi nau. Na roraꞋa nia naꞋa. Nau ku kwate naꞋa kala nanigot fuana, bore Ꞌoe kosi dao toꞋona.” ");
INSERT INTO kwf_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ꞋIu, karangi uulu madamo ki ka sui naꞋa, na faꞋarongoꞋa Ꞌuri ka dao siana sa Juda, “Na Ꞌafe ba ngela Ꞌoe, nia kini seseleꞋa baera, ma kaidaꞋi neꞋe nia ina naꞋa.” Ma nia ka fata Ꞌuri, “Mulu ngalia Ꞌi maa faꞋasia fanoa doe, ma muka doꞋofia nia ka mae.” ");
INSERT INTO kwf_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ma kaidaꞋi kira abalangaꞋinia kini neꞋeri Ꞌi maa nia ka kwatea kwau ro ru ba nia kwatea fuana nia ka goniꞋi ki nia ka kwatea kwau alaꞋanga Ꞌuri, “ꞋOko lisia ru ba ngwae baera nia aluꞋi aku ki ne na toto ana kerekereꞋa, faꞋinia gwaꞋi dadalo nia ma faꞋi kuba nia ne. Nau ku ina naꞋa, bore ma ngwae neꞋe kwatea ngela fuaku, ro ru neꞋe ki, ru nia ki. ꞋOko lisia naꞋa? ꞋOke saea nia ke leka maꞋi siaku, ro ru neꞋe ki, ru sa tai ki niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Sui sa Juda ka lia saiana ro ru neꞋeri ki, ma nia ka fata Ꞌuri, “Kini neꞋana bali nia saga, nauꞋa neꞋe nau ku rora. Nau ku bolo fuana nai ngalia nia ka korea ngela ꞋisiꞋisi nau, bore ma nau ku Ꞌiri sasia.” ꞋI buri naꞋa noaꞋa nia kasi teo naꞋa faꞋinia kini neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","KaidaꞋi Ꞌi Tamara nia karangi faꞋafuta na ngela neꞋeri, kira lisia nia ke baꞋa faꞋafuta ro ꞋiꞋiu ki. ");
INSERT INTO kwf_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ma kaidaꞋi nia faꞋafuta, taꞋi ana ro ꞋiꞋiu neꞋeri ki, nia ruꞋungaꞋinia maꞋi limana Ꞌi maa ka sakatafa, sui kini neꞋe lia sulia ka ngalia Ꞌaba kwalo meo ka firiꞋia Ꞌi limana ngela neꞋeri, nia ka fata Ꞌuri, “Nia neꞋe ai eta futa adaroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bore ma ngela neꞋeri lalafia limana ma ka olitaꞋinia Ꞌi saena laꞋu. Ma ngwaefuta nia naꞋa neꞋe ka eta futa. GoꞋo kini neꞋeri ka fata Ꞌuri ana ngela neꞋeri, “Falafala Ꞌoe neꞋe ꞋunaꞋeri, ꞋaeꞋo ngwae fuana suꞋumaꞋilamu talamu.” Nia neꞋe kira ka saea Ꞌani sa Peres neꞋe fadalana, “Nia suꞋumaꞋinia talana ka eta ruꞋu maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ꞋI buri Ꞌana na ngwaefuta nia neꞋe na aba kwalo meo nia Ꞌi limana fiꞋi futa maꞋi, ma kira ka saea Ꞌani sa Sera neꞋe fadalana, “Meo.” ");
INSERT INTO kwf_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","KaidaꞋi ngwae ana kwalafa sa Ishmael ki kira ngalia sa Josef Ꞌuana Ꞌi Ejipt, kira ka Ꞌoifoli laꞋu Ꞌania. ꞋUnaꞋeri taꞋi ngwae ꞋaꞋana ana tatalafaꞋa ana fanoa neꞋeri satana sa Potifa ka folia niaꞋa. Ma niaꞋa naꞋa neꞋe gwaungaꞋi fuana ngwae lialia ana luma tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Iawe nia tua faꞋinia sa Josef, ma ru nia sasiꞋi ki ka leꞋa liu. Sa Josef tua saena luma sa Potifa, ngwae neꞋe ngwae Ꞌi Ejipt nia ꞋaꞋana fuana. ");
INSERT INTO kwf_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Sa Potifa lisia neꞋe Iawe tua faꞋinia sa Josef nia ka sasia raoꞋa nia ki ka leka leꞋa liu mala. ");
INSERT INTO kwf_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ꞋUnaꞋeri nia ka saeleꞋa liu fafia, ma nia ka tua faꞋinia ana kaidaꞋi Ꞌoro fuana Ꞌafilana. Ma nia ka filia sa Josef ka faꞋinaꞋonaꞋo ana ru ki saena luma nia, faꞋinia ru ki taꞋifau neꞋe nia toꞋo ani. ");
INSERT INTO kwf_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ma ka eta ana kaidaꞋi neꞋeri, osiꞋana raoꞋa leꞋa sa Josef ki, Iawe ka faꞋaleꞋa ngwae neꞋeri, ma ru ki taꞋifau saena luma nia, ma saena oꞋola nia ru ki ka leka leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ꞋUnaꞋeri sa Potifa ka alua ru ki taꞋifau neꞋe nia toꞋo ani saena limana sa Josef, ma nia noaꞋa kasi Ꞌabera laꞋu Ꞌania ta ru. Nia tua goꞋo Ꞌana fuana manataꞋanga sulia fanga nia ki. Sa Josef nia ta taꞋi ngwae fiꞋi doe neꞋe lisilana leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","NoaꞋa kasi tau goꞋo Ꞌafe sa Potifa ka kwaiogai naꞋa ana, ma nia ka lidia fuana teoꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Bore ma sa Josef noaꞋa kasi oga falafala ꞋunaꞋeri, nia ka fata Ꞌuri fuana Ꞌafe neꞋeri, “NoaꞋa liu, Ꞌoe kosi sasi ꞋunaꞋeri aku! Lisia basi kwa! KaidaꞋi neꞋe ngwae ꞋaꞋana nau nia noaꞋa kasi Ꞌabera naꞋa Ꞌania ta ru saena luma nia, osiꞋana nau ku tua faꞋinia. Nia alu nau ku ꞋaꞋana naꞋa ana ru nia toꞋo ani ki. Ma nau ku toꞋo ana ngasingasiꞋanga fuana raoꞋa Ꞌania ru nia toꞋo ani saena luma neꞋe. Bore ma ꞋaeꞋo neꞋe ru nia talana, osiꞋana ꞋaeꞋo neꞋe Ꞌafe nia, ma nau noaꞋa liu kusi sasia ta ru ana. Si diꞋia nau ku teo faꞋiniꞋo Ꞌirai ru taꞋa liu, noaꞋa liu nau kusi fuli ru taꞋa Ꞌuira. Ma nia ka kwatea taꞋangaꞋa Ꞌi maana God logo.” ");
INSERT INTO kwf_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Asoa ki taꞋifau goꞋo neꞋe Ꞌafe neꞋeri tuaraꞋi nia fuana leka teoꞋa faꞋinia, bore ma nia noaꞋa kasi oga goꞋo falafala ꞋunaꞋeri ki. Ma nia ka noaꞋa kasi oga logo tuaꞋa karangia. ");
INSERT INTO kwf_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Leleka, ana taꞋi asoa, kaidaꞋi nia leka Ꞌi saena luma fuana sasilana raoꞋa nia, ka noaꞋa ta ngwae neꞋe ka tua faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ꞋUnaꞋeri goꞋo Ꞌafe neꞋeri ka dau ngiringiri naꞋa ana toꞋongi nia ma ka fata Ꞌuri ana sa Josef, “Nau ku amasiꞋo Ꞌoke teo naꞋa maꞋi faꞋi nau!” Bore ma sa Josef ka fai danga Ꞌania toro keta nari nia, ma ka tafi naꞋa Ꞌi maa. ");
INSERT INTO kwf_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","KaidaꞋi Ꞌafe neꞋe lisia nia tafi naꞋa faꞋasia toꞋongi nia, ");
INSERT INTO kwf_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nia ka ri Ꞌuana ti ngwae rao neꞋe kira rao ana ta luma kira ka leka maꞋi. GoꞋo nia ka fata Ꞌuri fuada, “Ai reala. Mulu lisia! Ngwae nini ana kwalafa sa Eba ngwae taꞋa liu mala! Nia faꞋa Ꞌeke kulu ne! AraꞋi nau ngalia maꞋi Ꞌi neꞋe fuana tae niniꞋa? Nia ruꞋu maꞋi saena maꞋe luma nau ma nia ka tuaraꞋi nau fuana teoꞋa faꞋinia, bore ma nau ku ako doe. ");
INSERT INTO kwf_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ma ana kaidaꞋi nia rongoa neꞋe nau ku ako ꞋunaꞋeri, nia ka tafi Ꞌi maa faꞋasia toꞋongi neꞋe nia.” ");
INSERT INTO kwf_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nia ka gonia naꞋa Ꞌana toro sa Josef leleka araꞋi nia ka oli maꞋi luma. ");
INSERT INTO kwf_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ꞋUnaꞋeri nia ka saea nama ana taꞋi alaꞋanga neꞋeri fuana, nia ka fata Ꞌuri, “Na ngwae rao ꞋoꞋo nini ana kwalafa sa Eba nini Ꞌoko ngalia maꞋi, nia leka maꞋi saena mae luma nau taꞋena, nia sasia nau ku Ꞌeke. ");
INSERT INTO kwf_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bore ma kaidaꞋi nau ku ako doe, nia ka tafi Ꞌi maa faꞋasia toꞋongi nini nia.” ");
INSERT INTO kwf_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","KaidaꞋi ngwae neꞋeri rongoa alaꞋanga neꞋe Ꞌafe nia saea, nia ka saetaꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ꞋUnaꞋeri nia ka asungaꞋinia ngwae nia ki ka leka daua sa Josef, ma kira ka Ꞌui Ꞌania saena lokafo. Nia lokafo neꞋeri, kaidaꞋi Ꞌoro kira alua ngwae rao tatalafaꞋa ki Ꞌi saena. Sui bore Ꞌana sa Josef ka tua saena lokafo, ");
INSERT INTO kwf_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Iawe nia tua tari goꞋo Ꞌana faꞋinia, ma nia ka ꞋoilakitaꞋinia. Ma ngwae ꞋaꞋana ana lokafo neꞋeri ka saeleꞋa fafia sa Josef, ");
INSERT INTO kwf_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ꞋunaꞋeri nia ka alua ka lia sulia ti ngwae lokafo neꞋe kira tua saena lokafo neꞋeri, ma nia ka kwatea ka ꞋaꞋana ana raoꞋa saena lokafo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Sui ngwae ꞋaꞋana neꞋeri kasi Ꞌabera naꞋa Ꞌania raoꞋa neꞋeri ki, sulia Iawe nia tua faꞋinia sa Josef, ma nia ka sasia raoꞋa neꞋeri ki ka leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sui buri Ꞌana tiꞋitiꞋi goꞋo, ro ngwae rao tatalafaꞋa ki kera kwatea tatalafaꞋa ka saetaꞋa liu fuadaroꞋo ro ngwae neꞋeri ki, taꞋi ngwae ꞋaꞋana fuana ngwaꞋi toꞋa kira lia sulia na waen tatalafaꞋa, ma taꞋi ka ꞋaꞋana fuana ngwaꞋi toꞋa kira rao ana beret tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","TatalafaꞋa nia saetaꞋa liu fuadaroꞋo, ");
INSERT INTO kwf_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","goꞋo nia ka aludaroꞋo saena lokafo neꞋe sa Potifa ꞋaꞋana ana. Nia neꞋe taꞋi lokafo nini sa Josef nia tua logo ana. ");
INSERT INTO kwf_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ꞋUnaꞋeri sa Potifa ka alu keraꞋa saena limana sa Josef ka lia sulia kera, ma kera taꞋi tua tau tiꞋitiꞋi saena lokafo neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ana taꞋi rodo, kaidaꞋi kera tua Ꞌua saena lokafo, kera maliu bole, ma fadalana ro maliu boleꞋa neꞋeri ki ka matamata daofaꞋi liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sui Ꞌofodangi kaidaꞋi sa Josef leka maꞋi fuana lisi ladaroꞋo, nia lisia kera manata Ꞌabera liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nia ka saefilo Ꞌuri adaroꞋo, “Nau ku lisia koroꞋo manata Ꞌabera ana taꞋi ru. Ru faꞋuta niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma kera ka Ꞌuri, “ꞋOko saiana rodo sui, keroꞋo maliu bole, bore noaꞋa ta ngwae ana kula neꞋe saiana ke saea fadalana ro maliu boleꞋa neꞋe ki fuamiroꞋo.” Ma nia ka fata Ꞌuri fuadaroꞋo, “God talana goꞋo neꞋe toꞋo ana ngasingasiꞋanga fuana saelana fadalana maliu boleꞋa. Bore Ꞌana, moro ili sae toꞋona maꞋi ro maliu boleꞋa neꞋana ki fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ꞋUnaꞋeri na ngwae neꞋe Ꞌi naꞋo nia ꞋaꞋana ana ngwae nia kira lia sulia waen tatalafaꞋa, nia ka fata Ꞌuri, “Nau ku maliu boleꞋa fasi nau ku lisia taꞋi Ꞌai grep. ");
INSERT INTO kwf_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ꞋAi grep neꞋeri toꞋo ana uulu rara Ꞌai ki ana, ma kaidaꞋi rara Ꞌai neꞋeri ki toꞋo ana raꞋi ru ki, tona bore ma nia toꞋo logo ana taka ru ki, ma nia ka toꞋo naꞋa ana fuaꞋi ru ki ana ma kira ka kwasa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nau ku dau ana titiu ni kwaꞋu tatalafaꞋa, nau ku ngalia fuana Ꞌai grep neꞋeri, ma nau ku losia suluna saena titiu ni kwaꞋu neꞋeri, buri Ꞌana nau ku kwatea kwaꞋu titiu ni kwaꞋu neꞋeri fuana tatalafaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Sui sa Josef ka fata Ꞌuri, “Na fadalana maliu boleꞋa neꞋana Ꞌuri, uulu rara grep neꞋana ki, na uulu asoa ki neꞋana. ");
INSERT INTO kwf_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","KaidaꞋi noaꞋa kasi dao Ꞌua ana uulu asoa ki, tatalafaꞋa ke baꞋa ngaliꞋo faꞋasia luma lokafo, ma nia ke baꞋa alu Ꞌoke oli laꞋu ana raoꞋa ba Ꞌoko sasasia Ꞌi naꞋo. ꞋOko saiana Ꞌoke baꞋa kwatea nama Ꞌamu titiu ni kwaꞋu tatalafaꞋa fuana, diꞋia nama ba Ꞌoko sasasia Ꞌi naꞋo, kaidaꞋi ba Ꞌoko ꞋaꞋana fuana ngwae kira lia sulia waen nia. ");
INSERT INTO kwf_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma kaidaꞋi neꞋe Ꞌoke leka faꞋasia luma lokafo, Ꞌoe kosi takadalafa nau! ꞋIu, Ꞌoke manatai nau, ma Ꞌoko faꞋarongoa tatalafaꞋa Ꞌani nau fasi Ꞌiri nia ka lafu nau logo faꞋasia luma lokafo. ");
INSERT INTO kwf_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ꞋOko lisia! NauꞋa kwalafa sa Eba ne, bore ma etaeta kira bili nau faꞋasia fanoa kami, ma kira ka ngali nau maꞋi neꞋe. Ma kaidaꞋi nau ku tua Ꞌi neꞋe, nau ku Ꞌiri sasia ta ru neꞋe bolo faꞋinia kike Ꞌui Ꞌani nau saena luma ni lokafo neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ana kaidaꞋi ta ngwae rongoa neꞋe fadalana maliu boleꞋa neꞋeri neꞋe sa Josef saea ka mamana, nia ka fata Ꞌuri, “NauꞋa logo nau ku lisia ta taꞋi maliu boleꞋa. Nau ku maliu bole Ꞌuri, uulu kukudu Ꞌi beret ki uu fafona gwauku. ");
INSERT INTO kwf_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ꞋI saena kukudu isi Ꞌi fafo, na kwalu kaela afu keke goꞋo neꞋe teo Ꞌi saena ma nau ku ngaliꞋi fuana tatalafaꞋa. Bore ma noꞋo ki kira Ꞌania afu keke neꞋeri ki.” ");
INSERT INTO kwf_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Sui sa Josef ka fata Ꞌuri, “Fadalana maliu boleꞋa Ꞌoe nia Ꞌuri. Uulu kukudu neꞋana ki neꞋe uulu asoa ki neꞋe saena luma lokafo. ");
INSERT INTO kwf_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nia Ꞌiri dao Ꞌua ana uulu asoa ki, kike baꞋa sikilia gwaumu, ma kike baꞋa dauraꞋinia nonimu ana ta taꞋi faꞋi Ꞌai. Ma faꞋi noꞋo ki kike leka maꞋi ma kira ke Ꞌania fasi Ꞌi nonimu ki.” ");
INSERT INTO kwf_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ana uula asoa ana saena lokafo na tatalafaꞋa ka sasia taꞋi fafangaꞋa ana kaidaꞋi nia futa ana. Nia sasia taꞋi fafangaꞋa doe liu ma nia ka laefia ngwae ꞋaꞋana nia ki ka leka maꞋi. Ma Ꞌi maana ti ngwae ꞋaꞋana ana nia ka lafua maꞋi ro ngwae ba nia ki laꞋu neꞋe kera tua saena luma lokafo. ");
INSERT INTO kwf_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ngwae ba Ꞌi naꞋo nia ꞋaꞋana ana ngwae ki fuana liaꞋa sulia waen nia, nia ka alua laꞋu ana raoꞋa ba nia. ");
INSERT INTO kwf_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bore ma ngwae ba Ꞌi naꞋo nia ꞋaꞋana fuana ngwae saungaꞋilana beret nia, kira ka saungia nia ka mae, ma kira ka dauraꞋinia nonina ana taꞋi faꞋi Ꞌai. Ru ki taꞋifau fuli diꞋia nama neꞋe sa Josef eta saea. ");
INSERT INTO kwf_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bore ma ngwae neꞋe ꞋaꞋana fuana ngwae ki neꞋe lia sulia waen tatalafaꞋa nia noaꞋa Ꞌiri manata naꞋa toꞋona sa Josef, nia takadalafa liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Buri Ꞌana ro faꞋi ngali ki na tatalafaꞋa Ꞌi Ejipt nia ka toꞋo ana taꞋi maliu boleꞋa. Nia lisia fasi nia uu Ꞌi ninimana kafo Ꞌi Nael. ");
INSERT INTO kwf_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ꞋUnaꞋeri nia ka lisia fiu buluka ki raꞋe alaꞋa maꞋi faꞋasia kafo, ma kira ka Ꞌani karasi ninimana kafo neꞋeri. Ma fiu buluka neꞋeri ki doe liu, ma ꞋuliꞋulida ka ngwasinasina logo. ");
INSERT INTO kwf_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Buri Ꞌana ta fiu buluka ka raꞋe maꞋi faꞋasia kafo neꞋeri, ma kira ka tua karangia logo na buluka ba kira eta taꞋe maꞋi ki. Buluka neꞋeri ki, suli ꞋoꞋo ki naꞋa ma lisilada ka taꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ma ai neꞋe suli ꞋoꞋo oꞋa ki, kira ka Ꞌania ai neꞋe doe leꞋa ki leleka ka sui. GoꞋo tatalafaꞋa ka ada. ");
INSERT INTO kwf_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Buira nia ka maliu laꞋu, ma ka lisia laꞋu ta maliu boleꞋa. Nia lisia fasi taꞋi Ꞌai ꞋaiꞋi witi nia toꞋo ana fiu fingi ru doe ki ana, neꞋe kwaimaꞋa kwali naꞋa fuana ngalilani maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Sui nia ka lisia laꞋu ta ꞋaiꞋaiꞋi witi neꞋe nia toꞋo ana fingi ru tiꞋitiꞋi neꞋe saꞋosaꞋofiꞋa liu ma ka karangi mae naꞋa, sulia iru ꞋakoꞋako ana ꞋeꞋerede nia ꞋakoꞋako liu. ");
INSERT INTO kwf_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","GoꞋo fiu fingi ru tiꞋitiꞋi neꞋeri ki kira ka Ꞌania na fingi ru doe lia leꞋa ki. Ma tatalafaꞋa ka ada laꞋu, nia ka saiana neꞋe nia maliu bole goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bore ma Ꞌofodangi na tatalafaꞋa ka manata Ꞌabera liu naꞋa, sui nia ka riꞋi Ꞌuana maꞋi ngwae liatoꞋo ana fanoa neꞋeri kike leka maꞋi fuana lisilana. ꞋUnaꞋeri nia ka faꞋarongo kira ana ro maliu boleꞋa neꞋeri ki, bore ma ta ngwae Ꞌada noaꞋa Ꞌisi saea fadalana ro maliu boleꞋa nia ki fuana. ");
INSERT INTO kwf_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ꞋUnaꞋeri mala ngwae neꞋe nia ꞋaꞋana ana ngwaꞋi toꞋa fuana liaꞋa sulia waen nia, nia ka fiꞋi fata Ꞌuri fuana, “TatalafaꞋa kwa! nau ku fiꞋi manata toꞋona taꞋi ru nau ku fata alangaꞋi fuana sasilana bore ma nau ku manata bura ana. ");
INSERT INTO kwf_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ꞋI naꞋo ba Ꞌoko ogataꞋa fuaku faꞋinia ngwae ba ꞋaꞋana fuana ngwaꞋi toꞋa fuana saungaꞋilana beret Ꞌoe, ma Ꞌoko alu kamiroꞋo saena luma ni lokafo, saena luma ngwae faꞋinaꞋonaꞋo ana ngwae lialia ana luma Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","TaꞋi rodo keroꞋo maliu bole, ma fadalana ro maliu boleꞋa keroꞋo ki ka matamata daofaꞋi liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","TaꞋi ngwae fiꞋi doe ana kwalafa sa Eba neꞋe rao ꞋoꞋo fuana faꞋinaꞋonaꞋo Ꞌoe, nia tua faꞋi keroꞋo saena luma ni lokafo. KaidaꞋi keroꞋo faꞋarongoa Ꞌani ro maliu boleꞋa keroꞋo ki fuana, nia saea fadalana ro maliu boleꞋa neꞋeri ki fuamiroꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma buri Ꞌana ru ki taꞋifau ka diꞋia nama neꞋe nia saeꞋe. NauꞋa Ꞌoko alu nau laꞋu ana raoꞋa nau, bore ma ta ngwae Ꞌoko kwatea ngwae Ꞌoe ki fuana saungilana ka mae.” ");
INSERT INTO kwf_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ꞋUnaꞋeri na tatalafaꞋa ka kwatea kwau ngwae rao nia ki ka baꞋea maꞋi sa Josef. Ma ka Ꞌiri tau goꞋo kira ka leka baꞋea maꞋi faꞋasia luma ni lokafo. Nia ka sufi guguru ma ka rokisia toro nia, ma ka leka uu Ꞌi naꞋona tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Sui tatalafaꞋa ka fata Ꞌuri fuana, “Josef kwa! Nau ku lisia taꞋi maliu boleꞋa, bore ma noaꞋa ta ngwae ana kula neꞋe saiana saelana fadalana fuaku. Bore ma taꞋi ngwae nia saea fuaku ka Ꞌuri, ‘KaidaꞋi Ꞌoko rongoa maliu boleꞋanga Ꞌoko saiana Ꞌoke saea fadalana.’” ");
INSERT INTO kwf_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Bore ma sa Josef ka fata lala Ꞌuri, “Nau noaꞋa naisi saiana saelana fadalana maliu boleꞋa ki. Bore ma God naꞋa neꞋe ke baꞋa saea fadalana maliu boleꞋanga Ꞌoe, neꞋe Ꞌoke baꞋa saeleꞋa ana.” ");
INSERT INTO kwf_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","GoꞋo tatalafaꞋa ka fata Ꞌuri, “Ana maliu boleꞋanga nau, nau ku lisia fasi nau ku uu Ꞌi ninimana kafo Ꞌi Nael. ");
INSERT INTO kwf_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ꞋUnaꞋeri fiu buluka ki ka raꞋe maꞋi faꞋasia kafo neꞋeri, ma kira ka Ꞌani karasi ninimana kafo. Na fiu buluka neꞋeri ki doe ka leꞋa liu, ma nonida ka ngwasinasina logo. ");
INSERT INTO kwf_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ma Ꞌi buri Ꞌana ta fiu buluka laꞋu ka raꞋe maꞋi faꞋasia kafo ma kiraꞋa suli ꞋoꞋo ki naꞋa ma ka lia taꞋa logo. Kira lia taꞋa liu ka liufia ti buluka neꞋe nau ku lilisiꞋi ana ti kula Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","GoꞋo kira ka Ꞌania ai nonina leꞋa ki leleka ka sui. ");
INSERT INTO kwf_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bore ma ta ngwae noaꞋa kasi lia sai goꞋo ana neꞋe kira Ꞌania buluka doe neꞋeri ki sulia kira suli ꞋoꞋo Ꞌanga goꞋo, diꞋia logo Ꞌae etaeta ba kiri. Buri Ꞌana nau ku ada naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Sui buri Ꞌana nau ku lisia laꞋu ta maliu boleꞋa, nau ku lisia taꞋi Ꞌai ꞋaiꞋi witi neꞋe toꞋo ana fingi ru doe ki kwaimaꞋa kwali naꞋa fuana ngalilana maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sui nau ku lisia laꞋu ta Ꞌai ꞋaiꞋi witi neꞋe toꞋo ana fiu fingi ru tiꞋitiꞋi ki ana neꞋe saꞋosaꞋofia liu, karangi mae naꞋa, osiꞋana iru ꞋakoꞋako ana kula ꞋeꞋerede Ꞌakofia liu na witi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ꞋUnaꞋeri fiu fingi witi tiꞋitiꞋi saꞋosaꞋofia neꞋeri kika Ꞌania fingi ru doe lia leꞋa neꞋeri ki. Nau ku saea ro maliu boleꞋa nini nau ki fuana ngwae lia toꞋo neꞋe ki bore ma noaꞋa ta ngwae ada kasi saea fadalana ro maliu boleꞋanga neꞋe ki fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sui sa Josef ka fata Ꞌuri ana tatalafaꞋa, “Ro maliu boleꞋanga neꞋana ki fadalani taꞋi ru goꞋo. God saea naꞋa fuamu ru neꞋe nia ke baꞋa fulia. ");
INSERT INTO kwf_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Na fiu buluka leꞋa neꞋana ki, nia fada Ꞌani fiu faꞋi ngali ki. Ma fiu fingi witi leꞋa neꞋana ki, nia fada logo Ꞌani fiu faꞋi ngali ki logo. Ro maliu boleꞋanga neꞋana ki fadalani taꞋi ru goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na fiu buluka suli ꞋoꞋo aꞋa neꞋana ki, neꞋe kira saka maꞋi faꞋasia saena kafo Ꞌi buri, faꞋinia fingi witi tiꞋitiꞋi neꞋe saꞋosaꞋofiꞋa karangi ka mae naꞋa, kira fada Ꞌani fiu faꞋi ngali ana fioloꞋanga ma ꞋatoꞋanga ana fanga. ");
INSERT INTO kwf_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ru neꞋe ke baꞋa dao maꞋi diꞋia naꞋa ba nau ku saea fuamu. God nia faꞋataꞋinia fuamu tae neꞋe nia karangi ke fulia. ");
INSERT INTO kwf_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Fuana fiu faꞋi ngali etaeta ki na oꞋola Ꞌi Ejipt ki taꞋifau ke fungu ana fanga. ");
INSERT INTO kwf_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Bore ma buira fiu faꞋi ngali ana fioloꞋanga ma kaidaꞋi fanga ke Ꞌato ke baꞋa dao maꞋi. Ma ana kaidaꞋi neꞋeri, ngwae ki noaꞋa kira kasi manata naꞋa toꞋona kaidaꞋi kira toꞋo ana fanga Ꞌoro, osiꞋana kaidaꞋi Ꞌato neꞋe nia ke faꞋalia naꞋa fanoa taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ngwae ki taꞋifau kike baꞋa takadalafa kaidaꞋi leꞋa neꞋe kira eta toꞋo ana sulia fioloꞋa neꞋe ke dao maꞋi, buri Ꞌana ke baꞋa taꞋa lilisu mala. ");
INSERT INTO kwf_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ro maliu boleꞋa neꞋe ki fadalani taꞋi ru goꞋo niniꞋa. Ma ai neꞋe faꞋataꞋinia neꞋe God salisali naꞋa ana ru neꞋe, ma nia karangi ka dao naꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ꞋIu Ꞌoke filia nama ta taꞋi ngwae sai Ꞌi ru neꞋe ke lia saiana ru neꞋe ke baꞋa dao maꞋi ki, ma Ꞌoke alua nia ngwae ꞋaꞋana leꞋa Ꞌoe ana fanoa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma Ꞌoke alua ti ngwae ꞋaꞋana laꞋu kira ka rao Ꞌi olofana niaꞋa fasi Ꞌiri kike lia saiana fanga neꞋe ngwae ki ngaliꞋi maꞋi. Ana fiu faꞋi ngali etaeta neꞋe ki, na fanga ke baꞋa Ꞌoro liu mala, ma faꞋi ngali ki taꞋifau kaidaꞋi ngwae ki kira ngalia maꞋi fanga kira ke daroꞋia nama Ꞌania lima kabu ki na fai kabu ru ki ru kira, ma taꞋi kabu ru ngwae neꞋeri ka ngalia ka goni leꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ana kaidaꞋi leꞋa neꞋeri, faꞋi ngali ki taꞋifau kira ke alu leꞋa nama ana fanga ka teo leꞋa saena fanoa doe ki, ma kira ngwae ni ofoꞋa ki kira ke lia nama sulia. ");
INSERT INTO kwf_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ꞋUnaꞋeri fanga neꞋeri ki ke teo kwaimasi fuana fiu faꞋi ngali ana fioloꞋanga ki ma kaidaꞋi Ꞌato neꞋe ke dao maꞋi fafia fanoa neꞋe. Falafala ꞋunaꞋeri neꞋe, ngwae ki noaꞋa kira kasi baꞋa maelia fioloꞋanga ana fanoa neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ꞋUnaꞋeri tatalafaꞋa faꞋinia gwaungaꞋi nia kira ka saeleꞋa fafia nai Ꞌi ru Ꞌanga neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ma tatalafaꞋa ka fata Ꞌuri fuada, “Sa Josef, ngasingasiꞋanga God tua faꞋinia mamana naꞋa. NoaꞋa kulu kasi dao naꞋa laꞋu toꞋona ta ngwae neꞋe lia toꞋo ka liufia niaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ma nia ka fata Ꞌuri fuana sa Josef, “God Ꞌoe faꞋataꞋinia ru neꞋe ki fuamu. Nau ku lia sai naꞋa ana Ꞌoko sai Ꞌi ru liu, ma Ꞌoko lia saiana ru neꞋe ke fuli ki ka liufia ta ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ꞋUri, nai baꞋa alua ꞋaeꞋo ta ngwae ꞋaꞋana aku fuana liaꞋa sulia fanoa neꞋe nau, ma ngwae nau ki taꞋifau kike kwairoꞋoi ana fatalamu. Ka ꞋunaꞋeri ꞋaeꞋo neꞋe na ruana ngwae aku, ma ka noaꞋa laꞋu ta ngwae neꞋe ka toꞋo ana ngasingasi Ꞌanga ana fanoa neꞋe ka diꞋia ꞋaeꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","KaidaꞋi neꞋe nau ku aluꞋu Ꞌoko ꞋaꞋana ana maꞋe fanoa ana fanoa neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ꞋUnaꞋeri na tatalafaꞋa ka kanusua taꞋi kome efoa Ꞌi ꞋuꞋuna neꞋe nia alua ana kaidaꞋi ki nia ka toto nia Ꞌani kerekereꞋa, goꞋo nia ka alua ana ꞋuꞋuna sa Josef. Ma nia ka ngalia taꞋi toro kwao nia ka toro Ꞌania, ma nia ka dauraꞋinia kwala kekefa gol Ꞌi luana. ");
INSERT INTO kwf_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nia ka ngalia ruana kad nia neꞋe na hos nia tara, ma ka kwate fuana sa Josef fuana lekaꞋa Ꞌania. Ma kaidaꞋi sa Josef liu kwau kaidaꞋi Ꞌoro ki na ngwae lialia Ꞌafia tatalafaꞋa neꞋe kira leka Ꞌi naꞋona, kira ako doe kika Ꞌuri, “Bobo uruuru! Bobo uruuru!” Nia naꞋa neꞋe falafala tatalafaꞋa nia sasia fuana sa Josef neꞋe lia sulia maꞋe fanoa ana fanoa ꞋaꞋana neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma tatalafaꞋa ka fata Ꞌuri fuana, “NauꞋa naꞋa neꞋe na tatalafaꞋa, ma fatalaku neꞋe Ꞌuri, ngwae ki taꞋifau ana tuaꞋa neꞋe diꞋia kira oga sasilana ta raoꞋa, nama kira ka leka ana ta kula, kira ke eta lidi Ꞌoe basi.” ");
INSERT INTO kwf_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","47","Sui tatalafaꞋa nia ka kwatea ta sata laꞋu fuana sa Josef. Ma sata neꞋeri neꞋe sa Safenat Paneh, neꞋe sata faolu nia, ma nia ka ngalia taꞋi sariꞋi ana fanoa neꞋeri, ma ka kwatea fuana nia ka korea. SariꞋi neꞋeri neꞋe satana Ꞌi Asenat. Nia ana fanoa doe Ꞌi Heliopolis, ma maꞋa nia sa Potifera ma niaꞋa taꞋi fata abu ana falafala ana kula abu kira saea Ꞌani Ꞌi On. Na kaidaꞋi neꞋe sa Josef nia talaꞋae ka rao fuana tatalafaꞋa Ꞌi Ejipt, nia tua naꞋa sulia uulu akwala faꞋi ngali ki. Nia leka kwau ana kula tatalafaꞋa nia tua ana ma kaidaꞋi ki saena fiu faꞋi ngali neꞋeri ki, nia liu ana kula ki taꞋifau ana fanoa neꞋeri. Ma saena fiu faꞋi ngali neꞋeri ki nia toꞋo ana kaidaꞋi leꞋa fuana oꞋola witi ki ka toꞋo ana fanga Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ꞋIu ma fanoa doe ki taꞋifau neꞋe nia leka ani, nia ngalia witi ki, ma ka goniꞋi leꞋa saena luma ni goni ruꞋa saena fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Sa Josef ukua witi ki, leleka ka Ꞌoro liu diꞋia naꞋa one sulia asi neꞋe noaꞋa ta ngwae kasi saiana toꞋolana. ");
INSERT INTO kwf_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ma kaidaꞋi neꞋe fioloꞋa doe neꞋeri Ꞌiri raꞋe Ꞌua maꞋi sa Josef faꞋinia Ꞌafe nia kera toꞋo naꞋa ana ro ngela ngwane ki. ");
INSERT INTO kwf_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","KaidaꞋi ngela Ꞌi naꞋo nia futa, sa Josef fata Ꞌuri, “God kwatea nau ku takadalafa naꞋa raoꞋa ulafu ba nau ku sasiꞋi maꞋi Ejipt ki. Ma ru taꞋa ba kiri taꞋifau ba ngwaꞋi ngela maꞋa nau kira sasia aku.” Ma nia ka saea ngela neꞋeri Ꞌani sa Manase. ");
INSERT INTO kwf_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ma buri Ꞌana ruana ngela ana ka futa nia ka fata Ꞌuri, “God kwatea ngela neꞋe ki fuaku ana kula neꞋe ru ꞋafitaꞋi ki fuli fuaku.” Ma nia ka saea ruana ngela Ꞌani sa Ifrem. ");
INSERT INTO kwf_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ꞋUnaꞋeri fiu faꞋi ngali neꞋe oꞋola ki toꞋo ana fanga Ꞌoro, ma na ngwae Ꞌi Ejipt ki ka saeleꞋa, kaidaꞋi leꞋa neꞋeri sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ꞋUnaꞋeri fiu faꞋi ngali fuana fioloꞋanga ma kaidaꞋi Ꞌato fuana toꞋonga ana fanga ka dao naꞋa, ma ka diꞋia nama ba sa Josef nia saea Ꞌi naꞋo. Ma ti fanoa ꞋaꞋana ngwae ki noaꞋa kasi toꞋo naꞋa ana fanga, bore ma Ꞌi Ejipt fanga Ꞌoro nia teo. ");
INSERT INTO kwf_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sui kaidaꞋi ngwaꞋi toꞋa Ꞌi Ejipt kira talaꞋae ana olidokoꞋa ana fanga, kira fioloꞋa naꞋa. ꞋUnaꞋeri kira ka leka maꞋi kira ka saefiloa tatalafaꞋa fuana kwatelana fanga fuada. GoꞋo tatalafaꞋa ka saea fuada kira ka leka siana sa Josef, ma kira ke sasia tae neꞋe nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma kaidaꞋi Ꞌato ana fioloꞋanga nia dao ka taꞋa liu naꞋa, sa Josef ka Ꞌifingia luma ni goni fangaꞋa ki, ma ka alaꞋania ngwae ki kira ka leka maꞋi kika folia witi ana fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ꞋUnaꞋeri ngwae ana fanoa ꞋaꞋana ki taꞋifau logo neꞋe kira leka maꞋi Ejipt fuana folilana witi, osiꞋana fioloꞋanga neꞋeri dao ana fanoa ki taꞋifau saena magalia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ana kaidaꞋi neꞋeri sa Jakob tua tua maꞋi Ꞌana Ꞌi Kenan, ma kaidaꞋi nia rongoa kira Ꞌoifoli Ꞌani witi Ꞌi Ejipt, nia ka fata Ꞌuri fuana ngwaꞋi ngela nia, “FaꞋuta neꞋe kaumulu kasi sasia ta ru? ");
INSERT INTO kwf_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nau ku rongoa neꞋe kira Ꞌoifoli naꞋa Ꞌania witi Ꞌi Ejipt. ꞋUnaꞋeri kaumulu ke leka folia nama maꞋi ti fanga fuakulu, nia taꞋa neꞋe kuke mae ana fioloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sui goꞋo akwala ngwaefuta sa Josef kira ka faꞋasia Ꞌi Kenan ma kira ka leka Ꞌi Ejipt fuana foli fangaꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bore ma sa Jakob noaꞋa kasi saiana neꞋe ke alaꞋania sa Benjamin na sasina sa Josef fuana lekaꞋa faꞋinida, osiꞋana nia maꞋu Ꞌasu Ꞌubani ti ru kata fuli fuana sulia tala. ");
INSERT INTO kwf_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ꞋUnaꞋeri ngwaꞋi ngela sa Jakob kira ka leka faꞋinia ti ngwae Ꞌi Kenan neꞋe kira leka Ꞌuana Ꞌi Ejipt fuana foli fangaꞋa sulia kaidaꞋi Ꞌato ma fioloꞋa dao naꞋa fafia fanoa kira. ");
INSERT INTO kwf_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ana kaidaꞋi neꞋeri, sa Josef naꞋa neꞋe lia sulia fanoa ꞋaꞋana neꞋeri, ma nia ka Ꞌoifoli Ꞌania fanga ana ngwae ki ana fanoa matamata ki saena magalia. Sui ngwaefuta nia ki kira leka maꞋi, ma kira ka bobo uruuru Ꞌi naꞋona leleka maada ka foto ana ano. ");
INSERT INTO kwf_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ma kaidaꞋi nia lisida, nia lia saiada neꞋe kiraꞋa ngwaefuta nia ki goꞋo, bore ma nia fata Ꞌania alaꞋanga Ꞌi Ejipt, ma nia ka toꞋo ana taꞋi ngwae fuana rokisilana fatalana fasi Ꞌiri noaꞋa kira kasi lia saiana. Ma nia balufida ka Ꞌuri, “Kaumulu leka maꞋi faꞋasia Ꞌi fai?” Ma kira ka olisi Ꞌuri ana, “Kaimili faꞋasia Ꞌi Kenan ne, ma kaimili leka maꞋi fuana foli fangaꞋa ꞋamiꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Sa Josef lia sai goꞋo ana na ngwaefuta nia ki, bore ma kira Ꞌiri lia sai nama ana. ");
INSERT INTO kwf_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ꞋUnaꞋeri nia ka manata toꞋona ro maliu boleꞋa nia ki ba nia lisiꞋi Ꞌi naꞋo, neꞋe kira bobo uruuru fuana. Nia fata ngasingasiꞋa fuada ka Ꞌuri, “Sali kaumulu leka goꞋo maꞋi fuana saiꞋa ana fanoa neꞋe kami taka nini. Kaumulu oga muke dao toꞋona kamiꞋa, sali kami ngasingasiꞋa nama noaꞋa fasi Ꞌiri kamu ke leka maꞋi fuana fuꞋali lamiꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bore ma kira fata Ꞌuri, “NoaꞋa kwala ngwae ꞋaꞋana, nia Ꞌiri Ꞌuira laꞋu. Kaimili niniꞋa diꞋia goꞋo ngwae Ꞌoe ki. Kaimili leka goꞋo maꞋi fuana foli fangaꞋa ꞋamiꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaimili taꞋifau ngwaefuta ki ne, ma kami sa toꞋo goꞋo ana taꞋi maꞋa. Kaimili noaꞋa kasi leka laꞋu maꞋi fuana iro fanoa Ꞌanga. Kaimili leka saga goꞋo maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sui nia ka fata laꞋu Ꞌuri fuada, “NoaꞋa! Kaumulu leka maꞋi muka sai aimili ne!” ");
INSERT INTO kwf_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ꞋUnaꞋeri kira ka fata Ꞌuri, “Ngwae ꞋaꞋana kwa! Kaimili niniꞋa ngela ana taꞋi ngwae goꞋo niniꞋa, ma kami tua Ꞌi Kenan. Etaeta kaimili akwala ma ro ngela, bore ma ta taꞋi ngwaefuta aimili nia noꞋana, ma susu buri kaimili nia tua maꞋi faꞋinia maꞋa kami Ꞌi fanoa.” ");
INSERT INTO kwf_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bore ma nia ka fata Ꞌuri, “Nau ku saea ka sui naꞋa ba! Kaumulu leka goꞋo maꞋi fuana irolana fanoa neꞋe! ");
INSERT INTO kwf_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nai dao nama toꞋona neꞋe kaumulu alaꞋa mamana! Nia leꞋa, nia mamana Ꞌani satana tatalafaꞋa, nau ku saea ru mamana fuaumulu. Si diꞋia susu buri kamu noaꞋa kasi leka maꞋi ana kula neꞋe, Ꞌirai noaꞋa kamu kasi baꞋa leka naꞋa faꞋasia Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ta taꞋi ai aumulu ke leka ka ngalia nama maꞋi! Kaumulu ai neꞋe ki kaumulu ke tua saena luma lokafo, leleka kaimili ka dao toꞋona neꞋe fata laumulu nia mamana nama ka noaꞋa. Si diꞋia noaꞋa, nau ku saea naꞋa ru mamana fuaumulu, kaimili ke sai leꞋa naꞋa ana neꞋe kaumulu leka goꞋo maꞋi fuana irolana fanoa neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ma nia ka aluda saena lokafo sulia uulu asoa ki. ");
INSERT INTO kwf_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ma uula asoa, nia ka fata Ꞌuri ada, “NauꞋa ngwae fuana manata lafulana God, ma diꞋia kaumulu sasi diꞋia neꞋe nau ku saea, nai baꞋa alaꞋani kamu ke mauri. ");
INSERT INTO kwf_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","DiꞋia kaumulu oga neꞋe muke faꞋataꞋinia fatalamuꞋa mamana, nia leꞋa ta taꞋi ai aumulu ke tua saena luma lokafo neꞋe, ma ti ai muke saiana muke ngalia fanga niniꞋa kamu folia, ma muka oli muka kwatea fanga neꞋe ki fuana ngela kamu ki neꞋe kira fiolo goꞋo ada kaidaꞋi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bore ma kamu ke ngalia nama maꞋi susu buri ngwaefuta kamu ke leka maꞋi fuaku, fasi Ꞌiri nai lisia niaꞋa. DiꞋia nia ꞋunaꞋeri neꞋe, ke baꞋa faꞋataꞋinia neꞋe fatalaumulu nia mamana, ka ꞋunaꞋeri noaꞋa naisi saungi kaumulu ka mae.” Ma ngwaꞋi ngwaefuta neꞋeri kira ka alafafia fatalana, ");
INSERT INTO kwf_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ma kira ka alaꞋa Ꞌuri fuada talada, “Se reala! KaidaꞋi neꞋe kulu toꞋo naꞋa ana kwaꞋikwaꞋinga faꞋasia ru taꞋa ba kulu sasia ana ngwaefuta kulu Ꞌi naꞋo! Kulu lisia ka sui naꞋa ru taꞋa neꞋe kulu sasiꞋi ana ki, bore ma kaidaꞋi nia angi fuakulu fasi Ꞌiri kulu ka Ꞌafia, noaꞋa kulu kasi rongoa na fatalana. KaidaꞋi neꞋe ru doe neꞋe ka dao naꞋa fafi kulu!” ");
INSERT INTO kwf_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ꞋUnaꞋeri sa Ruben ka fata Ꞌuri fuada, “Ana kaidaꞋi baera, nau ku saea naꞋa fuaumulu ba nia ngwae fiꞋi doe goꞋo ne, noaꞋa kaumulu kasi faꞋalia laꞋu, bore ma noaꞋa kaumulu kasi saiana rongolana fatalaku. KaidaꞋi neꞋe kulu toꞋo naꞋa ana kwaꞋikwaꞋinga duꞋungana maelana.” ");
INSERT INTO kwf_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sa Josef nia rongo saiana alaꞋanga kira ki taꞋifau, bore ma kira Ꞌiri sai goꞋo ana neꞋe niaꞋa ngwaefuta kira, osiꞋana kiraꞋa taꞋifau alaꞋa fuana ta ngwae matamata lala neꞋe rokisia fatalada fuana. ");
INSERT INTO kwf_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ma nia ka leka faꞋasida ka angi, ma kaidaꞋi nia saiana nia leꞋa laꞋu, nia ka oli maꞋi. Nia ka ngalia sa Simion ma ka firiꞋia Ꞌi maada. ");
INSERT INTO kwf_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","GoꞋo sa Josef ka fata Ꞌuri fuana ngwae ni rao nia, “Mulu faꞋafungua fanga ki saena ngwaꞋi ngwaꞋi toꞋa neꞋana ki. Kira folia fanga neꞋana ki naꞋa, bore ma mani neꞋe ngwae neꞋana ki taꞋifau kira foli aniꞋi, niꞋi ke oli saena ngwaꞋi kira ki faꞋinia fanga kira. Ma kamu ka kwatea fanga fuada fuana Ꞌanilana sulia tala.” Ma ngwae ni rao nia ki ka sasi naꞋa ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ꞋUnaꞋeri ngwaefuta nia ki kira ka alua na ngwaꞋi ni fanga ki fafona dongki kira ki, ma kira ka leka naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ana rodo kaidaꞋi kira mamalo, ta taꞋi ada ka Ꞌifingia ngwaꞋi nia ka kwatea fanga fuana dongki nia, goꞋo nia ka tona Ꞌania mani nia neꞋe teo goꞋo Ꞌani saena ngwaꞋi faꞋinia fanga ki. ");
INSERT INTO kwf_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ma nia ka fata Ꞌuri fuada, “Ei reala kwa! Kira olitaꞋinia goꞋo mani nau ki! NiꞋi teo goꞋo Ꞌani faꞋinia fanga ki saena ngwaꞋi nau.” ManataꞋanga kira ki taꞋa liu naꞋa, sulia kira maꞋu liu. Sui kira ka saefilo Ꞌuri ada talada, “Tae naꞋa niniꞋa God sasia akulu re?” ");
INSERT INTO kwf_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ma kaidaꞋi kira oli laꞋu maꞋi siana maꞋa kira Ꞌi Kenan, kira ka faꞋarongoa Ꞌani ru ki taꞋifau neꞋe dao toꞋoda. ");
INSERT INTO kwf_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kira fata Ꞌuri, “Ngwae loꞋoko lia sulia tuaꞋa Ꞌi Ejipt, nia fata balubaluꞋa liu naꞋa fuaimili. Nia fia fasi kaimili leka lala fuana irolana fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma kaimili ka fata Ꞌuri fuana, ‘Kaimili noaꞋa Ꞌiri leka laꞋu maꞋi fuana irolana fanoa Ꞌoe. Kaimili leka lala maꞋi fuana foli fangaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kaimili niniꞋa ngela ana taꞋi maꞋa goꞋo. Etaeta kaimili akwala ma ro ngela, bore ma ta taꞋi ngwaefuta aimili nia noꞋana, ma susu buri kaimili nia tua goꞋo maꞋi faꞋinia maꞋa kami Ꞌi Kenan.’” ");
INSERT INTO kwf_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","GoꞋo ngwae neꞋeri nia ka Ꞌuri, “ꞋIrai taꞋi ru neꞋe nai faꞋamamana fatalaumulu faꞋinia nama ka noaꞋa. TaꞋi aumulu nia ke baꞋa tua faꞋinau Ꞌi neꞋe. Ma kaumulu ti ai kamu ka oli faꞋinia fanga fuana ngela kamu ki neꞋe kira fiolo maꞋi fanoa. ");
INSERT INTO kwf_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bore ma kamu ke ngalia nama maꞋi na ngwaefuta ꞋisiꞋisi ba kamu Ꞌi neꞋe fasi Ꞌiri nai lisia. Ru ꞋunaꞋeri neꞋe nau ku saiana kaumulu noaꞋa laꞋu ngwae iro fanoa ki, ma fatalaumulu ka mamana. ꞋUnaꞋeri mala, nau ku fiꞋi alaꞋania ngwaefuta kamu ka oli ka tua faꞋi kamu, ma kamu ke baꞋa leka goꞋo amuꞋa ana ta kula ana fanoa neꞋe, neꞋe kamu oga.” ");
INSERT INTO kwf_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ma kaidaꞋi kira kisitaꞋinia ngwaꞋi kira ki, kiraꞋa taꞋifau kira lisia ngwaꞋi mani kira ki teo goꞋo faꞋinia fanga ki. Ma kaidaꞋi kira lisia mani neꞋeri ki, kira maꞋu liu, ma maꞋa kira bore ka maꞋu liu logo. ");
INSERT INTO kwf_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma nia ka fata Ꞌuri ada, “FaꞋuta, Ꞌuri ma kaumulu oga nai koloa naꞋa Ꞌaku na ngela neꞋe nau ki niniꞋa? Sa Josef noꞋana naꞋa! Ma sa Simion ka noꞋana laꞋu, ma kaidaꞋi neꞋe kaumulu oga laꞋu ngalilana sa Benjamin? Ru neꞋe ki taꞋifau leka naꞋa maꞋi fuana faꞋalilaku goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ꞋUnaꞋeri sa Ruben ka fata Ꞌuri fuana maꞋa nia, “MaꞋasi kwa! Ru leꞋa goꞋo neꞋe Ꞌoke alua sa Benjamin saena limaku, ma nai baꞋa olitaꞋinia logo maꞋi fuamu. Si diꞋia nau noaꞋa kusi olitaꞋinia maꞋi, Ꞌirai Ꞌoke baꞋa saungia naꞋa amu ro ngela ngwane loꞋoko nau ki.” ");
INSERT INTO kwf_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Bore ma maꞋa kira ka fata Ꞌuri fuada, “NoaꞋa nia Ꞌato liu naꞋa fuaku neꞋe nai alaꞋania ngela nau ka leka faꞋi kamu. Na ngwaefuta leꞋa nia mae naꞋa ma nia taꞋifilia goꞋo neꞋe tua neꞋe nia futa ana Ꞌafe nau Ꞌi Rachel. Sali ta ru taꞋa kata fiꞋi dao laꞋu toꞋona sulia tala. Nau ku ngwaro liu naꞋa, ma si diꞋia Ꞌoko sasia ta ru taꞋa ka dao toꞋona, nai baꞋa mae goꞋo ana kwaimanatai Ꞌanga.” ");
INSERT INTO kwf_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ma kaidaꞋi Ꞌato fuana toꞋonga ana fanga nia lilisu naꞋa Ꞌi Kenan, ");
INSERT INTO kwf_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ma kaidaꞋi sa Jakob faꞋinia ngwaꞋi ngela nia kira faꞋasuia naꞋa fanga neꞋe ngela nia kira ki kira folia maꞋi Ejipt nia ka fata laꞋu Ꞌuri fuada, “Kamu ke oli laꞋu Ꞌi Ejipt muke folia laꞋu ti fanga fuakulu.” ");
INSERT INTO kwf_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bore ma sa Juda nia fata Ꞌuri ana, “MaꞋasi kwa! Ngwae ꞋaꞋana loꞋoko Ꞌi Ejipt nia alaꞋa ngasingasiꞋa fuaimili, nia saea diꞋia kaimili oli laꞋu Ꞌi buri ma ngwaefuta neꞋe kami noaꞋa kasi leka faꞋi kaimili, nia noaꞋa liu kasi oga naꞋa lisilana maꞋamili laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si diꞋia Ꞌoko alaꞋania ngwaefuta neꞋe kaimili ka leka faꞋi kaimili, Ꞌirai kaimili saiana mike baꞋa leka foli fanga. ");
INSERT INTO kwf_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bore ma si diꞋia noaꞋa Ꞌoe kosi alaꞋania, Ꞌirai noaꞋa kaimili saiana mi kasi leka, osiꞋana ngwae loꞋoko fata Ꞌuri, Ꞌi buri diꞋia kaumulu leka maꞋi ma diꞋia ngwaefuta kamu noaꞋa kasi leka maꞋi faꞋi kaumulu, nau noaꞋa kusi oga lisilana maa mulu Ꞌi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ꞋUnaꞋeri sa Jakob ka fata Ꞌuri, “FaꞋuta neꞋe kaumulu ka saea fuana ngwae neꞋana neꞋe kaumulu toꞋo ana ta ngwaefuta laꞋu? Kaumulu sasia naꞋa foli bareꞋa Ꞌoro fuaku.” ");
INSERT INTO kwf_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bore ma kira ka fata Ꞌuri, “NiaꞋa naꞋa neꞋe saefiloa lidiꞋa Ꞌoro aimili Ꞌuana kaimili faꞋinia luꞋuluꞋua neꞋe kaimili. Nia saefilo Ꞌuri, ‘MaꞋa kamu nia tua Ꞌua? Kaumulu toꞋo laꞋu ana ta ngwaefuta?’ Kaimili ka olisia goꞋo na lidiꞋa nari nia ki. Kaimili ke sai faꞋuta ana neꞋe nia ke baꞋa saefilo kaimili fuana ngalilana ngwaefuta neꞋe kami fuana lekaꞋa fuana?” ");
INSERT INTO kwf_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Sui sa Juda ka fata Ꞌuri ana, “ꞋOke alua Ꞌalako neꞋe saena limaku, fuana kaimili ke leka naꞋa kaidaꞋi neꞋe, fasi Ꞌiri ta ai akulu noaꞋa kasi baꞋa mae ana fioloꞋanga. ");
INSERT INTO kwf_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nau ku alangaꞋi nai baꞋa lia leꞋa sulia, ma ꞋoꞋogaꞋa nai naꞋa fuana olitaꞋilana maꞋi neꞋe. Ma si diꞋia nia noaꞋa kasi oli maꞋi fuamu, nauꞋa naꞋa neꞋe nai baꞋa ngalia kwaꞋikwaꞋinga firi ana ru neꞋe leleka nau ku mae. ");
INSERT INTO kwf_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","AlaꞋanga neꞋe ki nini dau kaimili liu naꞋa, sali diꞋia kaimili kasi manisuiꞋa ana kaidaꞋi Ꞌoro Ꞌuri ki, sali kaimili leka ro ru naꞋa Ꞌuana fanga ki.” ");
INSERT INTO kwf_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma maꞋa kira ka fata Ꞌuri, “Nia leꞋa. DiꞋia nia Ꞌirai, kamu ke toꞋongia ru leꞋa Ꞌi neꞋe ki saena ngwaꞋi kaumulu ki, fasi Ꞌiri kaumulu ke kwate na kwatea fuana ngwae ꞋaꞋana neꞋana. Kaumulu ke ngalia ta kala insens, faꞋinia ta kala ngingidua ma faꞋinia raꞋi ru fuana alulana ana fanga neꞋe kwatea fanga Ꞌanilana ka rukufa ma fuana pistasio faꞋinia ti fuaꞋi amon. ");
INSERT INTO kwf_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ma kaumulu ka olitaꞋinia mani ba ana eta lekaꞋa kaumulu, faꞋinia ta mani laꞋu ana lekaꞋa neꞋe. KaidaꞋi ba sui, kira olitaꞋinia mani kaumulu ki saena ngwaꞋi kaumulu ki, sali ta taꞋi roraꞋa kira goꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mulu ngalia ngwaefuta kamu muka leka naꞋa niniꞋari fuana ngwae loꞋoko. ");
INSERT INTO kwf_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","God toꞋo ana ngasingasi Ꞌanga ki taꞋifau, alaꞋania nia ke kwatea ngwae neꞋana ke kwaima aumulu, nia ke baꞋa alaꞋania fuaumulu muke ngalia ta ngwaefuta amuꞋa faꞋinia sa Benjamin, fasi Ꞌiri kera ke oli maꞋi faꞋi kaumulu. NoaꞋa naisi saea naꞋa ta ru. DiꞋia nau ku koloa naꞋa ro ngela neꞋe nau ki, leꞋa goꞋo Ꞌana, alu ke ꞋunaꞋeri naꞋa Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ꞋUnaꞋeri ngwaꞋi ngwaefuta neꞋeri kira ka ngalia ru neꞋeri ki, faꞋinia mani ana lekaꞋa ba sui, ma ti mani laꞋu, ma kira ka ngalia susu buri neꞋeri sa Benjamin faꞋi kira ma kira ka leka naꞋa. KaidaꞋi kira dao Ꞌi Ejipt, kira ka leka uu laꞋu Ꞌi naꞋona sa Josef. ");
INSERT INTO kwf_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ma kaidaꞋi nia lisia neꞋe susu buri neꞋeri leka maꞋi faꞋinida, nia ka fata Ꞌuri Ꞌana ngwae rao ꞋoꞋo neꞋe ꞋaꞋana ana ru saena luma nia, “ꞋOke baꞋea kwau ngwaꞋi toꞋa neꞋe saena luma nau, kike baꞋa fanga faꞋi nau ana tufungana asoa. Ma kaidaꞋi Ꞌoko leka Ꞌoke saungia taꞋi buluka, ma ko salisali ana fanga fuaimili.” ");
INSERT INTO kwf_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ma ngwae ꞋoꞋo neꞋeri ka sasi diꞋia naꞋa neꞋe sa Josef saea ma nia ka baꞋeda Ꞌuana luma sa Josef. ");
INSERT INTO kwf_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bore ma kaidaꞋi nia baꞋeda kwau kira maꞋu liu, ma kira ka fata Ꞌuri, “Kira baꞋe kulu Ꞌuana luma neꞋe fafia mani ba kira aluꞋi saena ngwaꞋi kulu, ki kaidaꞋi ba sui. Kike baꞋa dau kulu naꞋa ma kira ka ngalia na dongki kulu ki, ma kira ke sasia kulu ke rao ꞋoꞋo fuada.” ");
INSERT INTO kwf_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ma kaidaꞋi kira leka dao ana sinamaa ana luma sa Josef, kira ka fata Ꞌuri ana ngwae rao ꞋoꞋo neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ngwae ꞋaꞋana, kaimili toꞋo ana taꞋi ru fuana saelana fuamu. Kaimili leka maꞋi ana fanoa neꞋe Ꞌi naꞋo fuana foli fangaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Ma kaidaꞋi kami oli, kami ka mango sulia tala mika maliu ana rodo, ma kaimili ka Ꞌifingia ngwaꞋi kaimili ki, ma kaimili taꞋifau ka lisia mani kaimili ki teo faꞋinia fanga saena ngwaꞋi kaimili ki. Kaimili Ꞌiri saiana, sa tai neꞋe alua mani ki ka oli saena ngwaꞋi kami ki. NiꞋi teo goꞋo Ꞌani, nia ne kaimili olitaꞋiniꞋi maꞋi mika kwateꞋe fuamu. Ma kaimili ka ngalia laꞋu maꞋi ti mani fuana folilana fanga ana lekaꞋa neꞋe kami maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bore ma ngwae rao ꞋoꞋo neꞋeri ka fata Ꞌuri, “Kaumulu noaꞋa mu kasi manata Ꞌabera, ma noaꞋa mu kasi maꞋu. Na mani ba Ꞌi naꞋo ki, nau ku ngaliꞋi ka sui naꞋa ba. God kamu ana kwalafa sa Eba neꞋe God maꞋa kamu, nia nena alua mani saena ngwaꞋi kamu ki.” GoꞋo ngwae rao ꞋoꞋo neꞋeri ka baꞋea maꞋi sa Simion siada laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ma nia ka ngalida saena luma sa Josef, ma ka ngalia maꞋi kafo fuana taufilana Ꞌaeda, ma nia ka kwatea fanga fuana dongki kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kira rongoa naꞋa neꞋe kike baꞋa fanga faꞋinia sa Josef ana tufungana asoa, ma kira leka ma kika ngalia maꞋi na kwateꞋa neꞋe kira ngaliꞋi maꞋi ki, ma kira ka salisali ani fuana kwatelani fuana kaidaꞋi nia ke dao Ꞌi luma. ");
INSERT INTO kwf_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ma tufungana asoa, kaidaꞋi sa Josef leka maꞋi luma, kira leka ma kira ka ngalia maꞋi kwatea ki ma kira ka leka maꞋi saena luma. Ma kira ka bobo uruuru Ꞌi naꞋona fuana faꞋadoelana leleka maada ka toꞋo Ꞌi ana, ma kira ka kwatea na kwateꞋa neꞋeri fuana. ");
INSERT INTO kwf_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Sui nia ka saefilo Ꞌuri ada, “FaꞋuta kaumulu leꞋa goꞋo Ꞌaumulu? Ma kaidaꞋi ba sui kaumulu faꞋarongo nau Ꞌania maꞋa kamu, faꞋuta nia leꞋa goꞋo Ꞌana?” ");
INSERT INTO kwf_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ma kira ka fata Ꞌuri, “Ngwae ꞋaꞋana Ꞌae, maꞋa kaimili manata doe amu, nia tua leꞋa goꞋo Ꞌana, ma nia ngasingasiꞋa ua.” Ma kira ka bobo uruuru laꞋu fuana faꞋadoelana. ");
INSERT INTO kwf_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ma kaidaꞋi sa Josef lisia ngwaefuta leꞋa nia sa Benjamin neꞋe kera futa ana taꞋi teꞋa, nia ka saefilo Ꞌuri, “O sali na ngwaefuta ꞋisiꞋisi ba kamu taka nama neꞋe kamu saea fuaku kaidaꞋi ba sui?” Sui nia ka fata Ꞌuri ana sa Benjamin, “Ngela nau Ꞌae, alaꞋani God ka kwatea mauriꞋa leꞋa fuamu.” ");
INSERT INTO kwf_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ꞋAliꞋali goꞋo sa Josef ka tataꞋe ka ruꞋu saena maꞋe luma nia ka angi, sulia kaidaꞋi nia lisia ngwaefuta nia, nia saeleꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Buira neꞋe nia taufia maana, nia ka kwatea manatana ka aroaro, nia ka leka laꞋu maꞋi maa, nia ka ri Ꞌuana ngwae rao saena luma nia kira ka ngalia maꞋi fanga. ");
INSERT INTO kwf_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nia tua ana ta tatafe ni fanga, ma ngwaefuta nia ki kira ka tua ana ta tatafe ni fanga, ma ngwaꞋi toꞋa ꞋaꞋana ana fanoa neꞋeri neꞋe kira fanga faꞋinia kira tua logo ana ta tatafe ni fanga, sulia nia abu kira ka fanga faꞋinia kwalafa sa Eba. ");
INSERT INTO kwf_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ꞋUnaꞋeri ngwae rao neꞋeri ka kwatea ngwaefuta neꞋeri kira ka tua ana tatafe neꞋe kira taꞋifau kira faꞋi naꞋo kwau Ꞌuana sa Josef. Nia talaꞋae ana ai eta futa ana tatafe kira ka tua tatalaꞋa diꞋia neꞋe kira futa Ꞌani, leleka ai futa Ꞌisi ka tua naꞋa Ꞌi Ꞌisilana tatafe ni fanga neꞋeri. Ma kaidaꞋi kira lisia neꞋe ngwae neꞋeri sasia kira ka tua tatalaꞋa ꞋunaꞋeri, kira ka Ꞌarefo liu, ma kira ka lia fuada talada kwailiu. ");
INSERT INTO kwf_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma ngwae saena luma ki kira ka ngalia fanga faꞋasia tatafe ni fanga sa Josef ma ka kwateꞋe fuada. Ma fanga neꞋe kira ngaliꞋi fuana susu buri neꞋeri, nia bolo mala faꞋinia fanga fuana lima ngwae ki. Ma falafala neꞋeri neꞋe kwatea ma kira ka fanga faꞋinia sa Josef, ma kika kwaꞋu leleka kira ka abusu lui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sui sa Josef ka fata Ꞌuri ana ngwae rao ꞋoꞋo nia neꞋe ꞋaꞋana ana ru ki saena luma nia, “ꞋOke faꞋafungua fanga saena ngwaꞋi ngwae neꞋana ki, leleka ka fungu leꞋa mala. Ma Ꞌoko alua mani kira ki ka oli taꞋifau saena ngwaꞋi kira ki laꞋu faꞋinia fanga ki. ");
INSERT INTO kwf_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ma Ꞌoko ngalia titiu ni kwau ngwasinasina ba nau Ꞌoko alua Ꞌi saena ngwaꞋi susu buri kira faꞋinia mani nia ki neꞋe nia foli fanga aniꞋi.” GoꞋo ngwae neꞋeri ka sasi naꞋa diꞋia neꞋe sa Josef nia saea fuana. ");
INSERT INTO kwf_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sui ruana asoa Ꞌofodangi goꞋo Ꞌua, na ngwae rao ꞋoꞋo sa Josef ki kira ka Ꞌafia sa Juda faꞋinia ngwaefuta nia ki fuana alulana ngwaꞋi ki fafona dongki kira ki, ma kira ka leka naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ꞋIu kaidaꞋi noaꞋa kira Ꞌiri leka tau Ꞌua, sa Josef ka fata Ꞌuri ana ngwae rao ꞋoꞋo nia, “Aia, ꞋaliꞋali ko lalili Ꞌi buira toꞋa baera kaidaꞋi Ꞌoko dao toꞋoda, Ꞌoke fata Ꞌuri fuada, ‘Ngwae ꞋaꞋana nau nia sasia ru leꞋa liu fuaumulu! FaꞋuta kaumulu ka sasia ru taꞋa neꞋe ana? ");
INSERT INTO kwf_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","FaꞋuta neꞋe kaumulu ka bilia titiu ni kwau ngwasinasina nia? Titiu neꞋe naꞋa neꞋe nia ꞋidufaꞋi kwaꞋu ana ma nia ka rao logo Ꞌani fuana daoꞋa toꞋona fadalana maliu boleꞋa ki. Falafala nini kamu sasia nia taꞋa liu mala.’” ");
INSERT INTO kwf_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ma kaidaꞋi ngwae rao ꞋoꞋo neꞋe dao fafida, nia saea alaꞋanga fuada. ");
INSERT INTO kwf_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bore ma kiraꞋa taꞋifau kika fata Ꞌuri, “Ngwae ꞋaꞋana Ꞌae, kaimili noaꞋa Ꞌiri sai naꞋa ana sasilana ta ru Ꞌuira. Nia noaꞋa Ꞌiri leꞋa fuamu neꞋe Ꞌoke suꞋumani alaꞋanga neꞋana maꞋi aimili. ");
INSERT INTO kwf_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ꞋOko sai naꞋa ana na mani nini kaimili lisia saena ngwaꞋi kaimili ki, kaidaꞋi ba sui, kaidaꞋi kami faꞋasia Ꞌi Kenan, kaimili olitaꞋiniꞋi maꞋi fuamu ba. Kaimili ke bili faꞋuta laꞋu ana gol nama silva saena luma ngwae ꞋaꞋana Ꞌoe? ");
INSERT INTO kwf_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ꞋOke ili lulu Ꞌuana! Si diꞋia Ꞌoko dao toꞋona titiu neꞋana ana taꞋi aimili, nia leꞋa Ꞌirai nia ke mae nama. Ma kaimili ti ai, kaimili ke baꞋa rao ꞋoꞋo naꞋa fuana ngwae ꞋaꞋana Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","GoꞋo ngwae neꞋeri ka fata Ꞌuri, “LeꞋa goꞋo Ꞌana, nia ke baꞋa Ꞌuira naꞋa. Bore ma ngwae neꞋe bilia titiu ni kwau neꞋeri, nia ke baꞋa rao ꞋoꞋo fuana ngwae ꞋaꞋana nau, bore ma kaumulu ti ai, kamu saiana muke leka aloge.” ");
INSERT INTO kwf_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ma ꞋaliꞋali goꞋo kira ka ngalia kwau na ngwaꞋi fanga ana dongki kira ki, kira ka faꞋakosoꞋi ma kira ka ꞋifingiꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma ngwae rao ꞋoꞋo ka lia Ꞌi saena ngwaꞋi kira ki, nia eta ana ngwaꞋi ngwae eta futa leleka ka dao ana ngwaꞋi ngwae futa ꞋisiꞋisi. Ma na ngwaꞋi ngwae ꞋisiꞋisi nia ka dao toꞋona titiu ni kwaꞋu Ꞌi saena. ");
INSERT INTO kwf_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ma bara ngwaꞋi asina neꞋeri ka taꞋa liu mala ada ma kira ka gasia toꞋongi kira ki. Kira ka alua laꞋu ngwaꞋi neꞋeri ki fafona dongki ki, ma kira ka oli laꞋu Ꞌi fanoa doe. ");
INSERT INTO kwf_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ma kaidaꞋi kira dao laꞋu Ꞌi luma sa Josef, ma nia tua goꞋo Ꞌana Ꞌi neꞋeri, ma kira ka bobo uruuru Ꞌi naꞋona leleka maada ka toꞋo Ꞌi ano. ");
INSERT INTO kwf_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma nia ka fata Ꞌuri ada, “FaꞋuta neꞋe kaumulu ka fulia ru taꞋa Ꞌuri? Kaumulu noaꞋa mu kasi sai laꞋu ana nau ngwae ꞋaꞋana Ꞌuri saiana nai lia saiana maꞋe toto ki ma fadalana maliu boleꞋa ki logo? Nau ku sai goꞋo Ꞌaku ana tae neꞋe kaumulu sasia.” ");
INSERT INTO kwf_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ꞋUnaꞋeri sa Juda ka fata Ꞌuri, “Ngwae ꞋaꞋana ta tae laꞋu neꞋe kaimili ke baꞋa saea. Kaimili rora ka sui naꞋa. God faꞋataꞋinia naꞋa neꞋe kaimili rora. Nia leꞋa neꞋe ngwae kamu dao toꞋona titiu ni kwau saena ngwaꞋi nia, nia neꞋe ke rao ꞋoꞋo fuamu, bore Ꞌana ma kaimili taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Bore ma sa Josef nia ka fata Ꞌuri, “NoaꞋa, nauꞋa noaꞋa kusi sasia ru Ꞌuira. Ngwae neꞋe bili goꞋo titiu ni kwaꞋu neꞋe ke baꞋa rao ꞋoꞋo fuaku. KaumuluꞋa ti ai, muke oli goꞋo siana maꞋa kamu.” ");
INSERT INTO kwf_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Buri Ꞌana sa Juda ka Ꞌidu karangia sa Josef ma ka fata Ꞌuri, “Ngwae ꞋaꞋana, rongoa basi kala alaꞋanga nau. Nau ku saiana ꞋaeꞋo ngwae ꞋaꞋana mamana, ma Ꞌoko bolo faꞋinia tatalafaꞋa ana fanoa neꞋe, bore ma ngwadela Ꞌoe kosi oga taꞋa fuaku. ");
INSERT INTO kwf_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","KaidaꞋi sui, Ꞌoko saefilo Ꞌuri aimili, ‘FaꞋuta Ꞌuri ma maꞋa kamu tua Ꞌua? Kaumulu toꞋo ana ta ngwaefuta laꞋu tua Ꞌua?’ ");
INSERT INTO kwf_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma kaimili ka Ꞌuri, ‘ꞋIu, maꞋa kami tua goꞋo Ꞌana, bore ma nia ngwaro naꞋa. Ma susu buri kami tua goꞋo Ꞌana, nia futa kaidaꞋi maꞋa kami nia ngwaro naꞋa. Na teꞋa susu buri neꞋeri nia alua goꞋo ro ngela ki, bore ma ai eta futa nia noꞋana naꞋa, ma susu buri goꞋo neꞋe tua. Ma maꞋa kami nia kwaima liu Ꞌana.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ma ꞋaeꞋo ba Ꞌoko fata Ꞌuri fuaimili, ‘Nia leꞋa mulu leka ngalia maꞋi siaku Ꞌiri nai lisia.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Bore ma kaimili fata Ꞌuri, ‘Ngwae ꞋaꞋana Ꞌae, ngela neꞋeri noaꞋa kasi faꞋasia naꞋa maꞋa kami. DiꞋia nia faꞋasia maꞋa kami. MaꞋa ke baꞋa mae naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma ꞋaeꞋo ba Ꞌoko fata Ꞌuri, ‘LeꞋa goꞋo Ꞌana, si diꞋia ngwaefuta nena kamu noaꞋa kasi leka maꞋi faꞋi kamu, nau noaꞋa kusi oga lisilana maa mulu laꞋu Ꞌi neꞋe.’” ");
INSERT INTO kwf_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ma kaidaꞋi kami oli siana maꞋa kami, kaimili saea alaꞋa lamu fuana. ");
INSERT INTO kwf_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ma buri Ꞌana kaidaꞋi maꞋa kami fata Ꞌuri fuaimili, ‘LeꞋa, mulu koso laꞋu toli Ꞌi Ejipt, ma muka folia ta kala fanga laꞋu Ꞌakulu.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Bore ma kaimili ka fata Ꞌuri, ‘Kaimili noaꞋa kasi leka.’ Ngwae loꞋoko nia saea naꞋa fuaimili ka Ꞌuri, ‘Si diꞋia ngwaefuta ꞋisiꞋisi kamu noaꞋa kasi leka maꞋi faꞋi kamu. Nau noaꞋa kusi oga naꞋa lisilana maa mulu laꞋu. ꞋIu nia ke leka nama faꞋi kaimili. Tala neꞋe fuaimili neꞋe ꞋunaꞋeri naꞋa. DiꞋia noaꞋa, kaimili kasi leka naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","GoꞋo maꞋa kami ka fata Ꞌuri, ‘Kaumulu saiana neꞋe teꞋa nia alua goꞋo ro ngela ngwane ki. ");
INSERT INTO kwf_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ta taꞋi ai adaroꞋo nia noꞋana naꞋa faꞋasi nau. Sali ti ru ꞋaeꞋaela kwasi taka neꞋe Ꞌania, sulia kaidaꞋi nia leka faꞋasi nau, nau ku Ꞌiri lisia naꞋa, leleka ka dao Ꞌi taꞋena. ");
INSERT INTO kwf_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nau ku ngwaro liu naꞋa. DiꞋia kamu ngalia laꞋu kwau ai neꞋe, sali ta ru taꞋa ke baꞋa sasia laꞋu Ꞌi loꞋoba, Ꞌirai nai kwai kwaimanatai ka dao ana kaidaꞋi nai mae.’” ");
INSERT INTO kwf_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","ꞋUnaꞋeri sa Juda ka fata laꞋu Ꞌuri, “Ngwae ꞋaꞋana Ꞌae, diꞋia kaimili oli siana maꞋa kamu, ma susu buri neꞋe noaꞋa kasi leka faꞋi kaimili, ma maꞋa kami noaꞋa kasi lisia, nia ke baꞋa mae goꞋo. ꞋUri ma Ꞌoko manata faꞋuta ana tae neꞋe ke baꞋa fuli diꞋia kaimili dao Ꞌi fanoa, ma maꞋa kami noaꞋa kasi lisia faꞋi kami? Nia ne mangona maꞋa kami naꞋa ne, ma si diꞋia noaꞋa nia kasi lisia faꞋi kaimili, Ꞌirai kaimili naꞋa neꞋe kwatea nia ke mae. ");
INSERT INTO kwf_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ma nau ku fata alangaꞋi naꞋa fuana, ku Ꞌuri, ‘Nai lia sulia susu buri neꞋe.’ Nau ku fata Ꞌuri fuana, ‘MaꞋasi, diꞋia noaꞋa nia kasi oli maꞋi siana, nauꞋa naꞋa neꞋe nai baꞋa ngalia kwaꞋi kwaꞋinga ana ru neꞋe leleka nau ku mae.’ ");
INSERT INTO kwf_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ngwae ꞋaꞋana, nau ku kwaimaꞋa kwali goꞋo Ꞌaku fuana tuaꞋa Ꞌi neꞋe fuana ngalilana fuila, fasi Ꞌiri nai rao ꞋoꞋo fuamu. Bore ma ngwade Ꞌae, alaꞋania nia ke oli faꞋinia ngwaefuta nini nau ki. ");
INSERT INTO kwf_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Si diꞋia nau ku oli bore ma nia noaꞋa kasi oli faꞋinau, nau noaꞋa kusi oga naꞋa lisilana ꞋatoꞋanga doe neꞋe ke dao toꞋona maꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Sa Josef noaꞋa kasi sofongaꞋinia naꞋa abulaꞋanga nia, ma nia ka saiana neꞋe nia ke baꞋa angi Ꞌi maana ngwae rao ꞋoꞋo nia ki goꞋo nia ka saea kira ka leka Ꞌi maa. KaidaꞋi ngwaefuta nia ki goꞋo neꞋe tua faꞋinia, nia ka fiꞋi talingaꞋinia fuada sa tai neꞋe niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma nia ka angi doe liu, ma ngwaꞋi toꞋa Ꞌi Ejipt neꞋe kira tua maꞋi maa kira ka rongoa, ma kira ka leka ma kika faꞋarongoa Ꞌania ngwaꞋi toꞋa neꞋe kira tua ana luma tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Sui sa Josef ka fata Ꞌuri fuana ngwaefuta nia ki, “NauꞋa sa Josef goꞋo niniꞋa. ꞋUri ma nia mamana neꞋe maꞋa nau nia mauri Ꞌua?” Bore ma kaidaꞋi kira rongoa alaꞋanga neꞋeri, kira ka maꞋu liu, ma kira kasi saea naꞋa ta ru. ");
INSERT INTO kwf_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ꞋUnaꞋeri nia ka fata Ꞌuri fuada, “Ngwadela kina mulu Ꞌidu karangi maꞋi.” Ma kira ka Ꞌidu karangia maꞋi ana, ma nia ka fata laꞋu Ꞌuri, “NauꞋa sa Josef naꞋa niniꞋa. NauꞋa naꞋa niniꞋa ngwaefuta kamu ba kamu Ꞌoifoli Ꞌania Ꞌi naꞋo, diꞋia ta ngwae rao ꞋoꞋo ka leka maꞋi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bore ma noaꞋa kamu kasi manata Ꞌabera nama muka oga taꞋa fuamuꞋa talamuꞋa sulia kamu Ꞌoifoli Ꞌani nau maꞋi neꞋe. Ru neꞋe noaꞋa laꞋu naiꞋi ru Ꞌanga kamu, na naiꞋi ruꞋa God lala, neꞋe nia eta kwate nau maꞋi aumulu Ꞌi neꞋe, fasi Ꞌiri nai faꞋamauria mangoꞋi ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Na ruana faꞋi ngali goꞋo ana ꞋatoꞋanga neꞋe noaꞋa ta fanga kasi bulao Ꞌi neꞋe, na ngwae ki noaꞋa kasi baꞋa oꞋolia oꞋola ma kika kasi ngalia ta fanga ana oꞋola. ");
INSERT INTO kwf_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God neꞋe sasia ma nau ku eta leka maꞋi aumulu Ꞌi neꞋe fasi Ꞌiri nai faꞋamauri kaumulu Ꞌania falafala niniꞋa kulu taꞋifau Ꞌarefo liu ana, fasi Ꞌiri nai sasia tala fuana toꞋa neꞋe kira ke baꞋa futa maꞋi buri mulu noaꞋa kira kasi noꞋana bore ma kike tua leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nia noaꞋa laꞋu kaumulu neꞋe kwate nau maꞋi neꞋe. God lala neꞋe kwate nau maꞋi. Nia lafu nau ta ngwae ꞋaꞋana ana tatalafaꞋa, ma nau ku gwaungaꞋi ana ru ana luma nia ki logo, ma nau ku lia logo sulia fanoa ki taꞋifau ana tuaꞋa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Mulu ꞋaliꞋali muka oli fuana maꞋa kulu, ma kaumulu ka faꞋarongo Ꞌani fata laku fuana, muke Ꞌuri, ‘NauꞋa ngela Ꞌoe sa Josef. God kwate nau ku lia sulia fanoa ki taꞋifau ana tuaꞋa nini Ꞌi Ejipt. Nia leꞋa fuamu Ꞌoke faꞋasia fanoa Ꞌoe ma Ꞌoko leka maꞋi ko tua faꞋinau. ");
INSERT INTO kwf_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ꞋOke baꞋa tua Ꞌi Gosen, fasi Ꞌiri Ꞌoke tua karangi nau. Ma ꞋaeꞋo faꞋinia ngwaefuta nau ki, ma faꞋinia kala koꞋo Ꞌoe ke, faꞋinia ru ꞋaeꞋaela kamu ki, ma ti ru neꞋe Ꞌoko toꞋo ani ki, kaumulu saiana muke tua taꞋifau Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","DiꞋia kaumulu leka maꞋi muka tua Ꞌi Goshen, nau ku saiana nai lia leꞋa suliꞋo. Na ꞋatoꞋanga nini ana fioloꞋa nia ke leka laꞋu sulia lima faꞋi ngali ki, ma nau noaꞋa kusi oga ꞋaeꞋo faꞋinia ngwaefuta nau ki ma ru ꞋaeꞋaela kamu ki neꞋe kike baꞋa mae ana fioloꞋanga.’” ");
INSERT INTO kwf_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma nia ka fata Ꞌuri fuada, “ꞋIu, kaumulu niniꞋa faꞋinia ꞋaeꞋo sa Benjamin, kaumulu taꞋifau sai leꞋa ana neꞋe nauꞋa sa Josef mamana naꞋa niniꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kaumulu ke saea fuana maꞋa kia neꞋe tatalafaꞋa kwatea ngasingasiꞋanga ki taꞋifau ana fanoa neꞋe saena limaku ma kaumulu ka saea ru neꞋe ki taꞋifau fuana neꞋe kaumulu lisiꞋi Ꞌi neꞋe. Mulu ꞋaliꞋali naꞋa muka baꞋea maꞋi siaku.” ");
INSERT INTO kwf_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ma nia ka daua ngwaefuta nari nia ma ka talaꞋae ana angia. Ma ngwaefuta nia ka lolofafia. Ma nia ka angi logo. ");
INSERT INTO kwf_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma nia leka ma ka lolofafia logo ti ngwaefuta ana, ma ka nonoꞋida ma nia ka angi. Buri Ꞌana ngwaefuta nia ki kira fiꞋi alaꞋa naꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ꞋUnaꞋeri kaidaꞋi na tatalafaꞋa faꞋinia gwaungaꞋi nia ki Ꞌi luma nia, kira rongoa neꞋe ngwaefuta sa Josef ki kira dao, kira ka saeleꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ꞋUnaꞋeri tatalafaꞋa leka maꞋi ma ka fata Ꞌuri fuana sa Josef, “Nau ku saeleꞋa liu. ꞋOke saea fuana ngwaefuta Ꞌoe ki, ko Ꞌuri, ‘Kira ke ngalia ngwaꞋi kira ki fuana dongki kira ki, ma kira ka oli laꞋu Ꞌi Kenan, ");
INSERT INTO kwf_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ma kira ka baꞋea maꞋi maꞋa kamu faꞋinia ngela kira ki, ma kika oli laꞋu maꞋi siaku ana kula neꞋe. Nai baꞋa kwatea afu ano leꞋa Ꞌi Ejipt fuada, ma kira ke baꞋa Ꞌania fanga leꞋa neꞋe kulu toꞋo ani Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ma Ꞌoko saea nama logo fuada neꞋe kira ke ngalia nama ti kati Ꞌi neꞋe Ejipt, fuana ngalilana maꞋi Ꞌafe kira ki, faꞋinia ngela tiꞋitiꞋi ki. Ma kira ka ngali nama maꞋi maꞋa kamu logo. ");
INSERT INTO kwf_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ꞋOke saea fuada kira kasi Ꞌabera fuana ngalilana maꞋi ru kira ki taꞋifau, osiꞋana ru Ꞌoro leꞋa nini kulu toꞋo ani ki Ꞌi Ejipt kuke baꞋa kwateꞋe fuada.’” ");
INSERT INTO kwf_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ꞋUnaꞋeri ngwaefuta sa Josef ki kira ka sasi diꞋia neꞋe nia saea nama. Sa Josef ka kwatea kati doe liu ki fuada diꞋia nama neꞋe nia saea ma nia ka kwatea fanga fuada fuana Ꞌanilana sulia tala, ");
INSERT INTO kwf_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ma nia ka kwatea toro faolu ki logo fuada. Bore ma ngwaefuta leꞋa nari nia, nia kwatea mala lima toro faolu ki fuana, faꞋinia uulu talangaꞋi mani ana mani ngwasinasina ki. ");
INSERT INTO kwf_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma nia ka kwatea akwala dongki ka leka siana maꞋa nia neꞋe ngalia ru leꞋa liu ki faꞋasia Ꞌi Ejipt, ma ta akwala dongki laꞋu neꞋe kira ngalia witi ma beret ma ti fanga fuana Ꞌanilana sulia tala kaidaꞋi kira ke leka maꞋi, ");
INSERT INTO kwf_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ma nia ka kwatea kira ka leka, ma kaidaꞋi kira salisali fuana lekaꞋa, nia ka fata Ꞌuri fuadulu, “KaidaꞋi kaumulu leka, kaumulu kasi fuꞋali kamu talamuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ꞋUnaꞋeri ngwaꞋi ngwaefuta neꞋeri kira ka faꞋasia Ꞌi Ejipt, ma kira ka oli siana maꞋa kira Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","KaidaꞋi kira dao Ꞌi fanoa, kira ka fata Ꞌuri fuana, “MaꞋasi! Sa Josef noaꞋa Ꞌiri mae! Nia mauri goꞋo Ꞌana, ma kaidaꞋi neꞋe nia naꞋa neꞋe lia sulia fanoa ki taꞋifau Ꞌi Ejipt.” ꞋUnaꞋeri maꞋa kira ka lebe liu Ꞌani alaꞋanga neꞋeri, bore Ꞌana nia noaꞋa kasi faꞋamamanada. ");
INSERT INTO kwf_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bore ma kaidaꞋi kira saea ru ki taꞋifau neꞋe sa Josef saea fuada, ma nia ka lisia na kati ki neꞋe nia kwateꞋe maꞋi fuana ngalilana Ꞌuana Ꞌi Ejipt, na manatana ka fiꞋi leꞋa laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","GoꞋo nia ka fata Ꞌuri, “ꞋIu, nia mamana naꞋa ngela nau nia mauri Ꞌua! Nai leka lisia nama sui nau ku fiꞋi mae.” ");
INSERT INTO kwf_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ꞋUnaꞋeri sa Jakob ka salisali naꞋa ana ru nia ki taꞋifau, nia ka talaꞋae naꞋa ana lekaꞋa nia Ꞌuana Ꞌi Ejipt. KaidaꞋi nia leka maꞋi ka dao Ꞌi Bereseba, nia ka sasia kula ni foꞋosi fuana foꞋosilana Iawe neꞋe God maꞋa nia sa Aesak. ");
INSERT INTO kwf_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Saena rodo neꞋeri goꞋo, Iawe ka fata Ꞌuri fuana ana taꞋi maliu boleꞋa, “Jakob, Jakob kwa!” Ma nia ka olisi Ꞌuri ana, “ꞋIu, nauꞋa niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma God ka fata laꞋu Ꞌuri fuana, “NauꞋa naꞋa neꞋe Iawe, God maꞋa Ꞌoe. ꞋOe kosi maꞋungia lekaꞋa Ꞌuana Ꞌi Ejipt sulia fanoa neꞋeri neꞋe nai baꞋa kwatea ngela neꞋe kike baꞋa futa maꞋi burimu ki kike Ꞌoro liu. ");
INSERT INTO kwf_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nai baꞋa leka faꞋiniꞋo, ma buri Ꞌana nai baꞋa lafua ai neꞋe ke futa maꞋi burimu ki, kike oli laꞋu maꞋi Ꞌuana Ꞌi Kenan. Ma ana kaidaꞋi Ꞌoke baꞋa mae, sa Josef talana naꞋa neꞋe ke tua faꞋiniꞋo fuana bokotalana maamu.” ");
INSERT INTO kwf_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Buri Ꞌana sa Jakob ka faꞋasia Ꞌi Bereseba ka leka naꞋa Ꞌuana Ꞌi Ejipt. Na ngela nia ki kira ka alu nia faꞋinia ngela tiꞋitiꞋi kira ki ma Ꞌafe kira ki, kika tua saena na kati ki ba tatalafaꞋa Ꞌi Ejipt nia kwateꞋe maꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ma kira ka ngalia logo na ru ꞋaeꞋaela kira ki ma ti ru laꞋu neꞋe kira toꞋo ani kaidaꞋi kira tua Ꞌi Kenan, ma kira ka leka faꞋiniꞋi Ꞌi Ejipt. Ma nia ka ngalia kwalafa nia taꞋifau: ngela ngwane nia ki, faꞋinia ngwaꞋi ngela kini nia, ma ngela ngwane kira ki faꞋinia ngela kini kira ki, kira leka ma kika tua naꞋa Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nia ne ngwaꞋi ngela sa Jakob neꞋe kira leka Ꞌuana Ꞌi Ejipt. Ngela Ꞌi naꞋo nia neꞋe sa Ruben, ");
INSERT INTO kwf_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","faꞋinia ngela nia ki neꞋe satada sa Hanok, sa Palu, sa Hesron, sa Kami. ");
INSERT INTO kwf_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ma tai neꞋe sa Simion faꞋinia ngela nia ki neꞋe satada sa Jemuel, sa Jamin, sa Ohad, sa Jakin, sa Soha, ma sa Siaol neꞋe nia ngelana ta kini Ꞌi Kenan. ");
INSERT INTO kwf_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ma tai neꞋe sa Lifae faꞋinia ngela nia ki, neꞋe satada sa Gerson, sa Kohat, sa Merari. ");
INSERT INTO kwf_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ma tai neꞋe sa Juda faꞋinia ngela nia ki neꞋe satada sa Sela, sa Peres, sa Sera. Ta ro ngela ana neꞋe satadaroꞋo sa Era, ma sa Onan kera mae naꞋa Ꞌi Kenan. Ro ngela sa Peres ki, satadaroꞋo sa Hesron ma sa Hamul. ");
INSERT INTO kwf_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ma tai neꞋe sa Isakar faꞋinia ngela nia ki neꞋe satada sa Tola, sa Pua, sa Jasub, sa Simron. ");
INSERT INTO kwf_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ma tai neꞋe sa Sebulun faꞋinia ngela nia ki neꞋe satada sa Sered, sa Elon, sa Jaliel. ");
INSERT INTO kwf_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nia ne ngela ngwane futa ana sa Jakob ma Ꞌi Lia faꞋinia kala koꞋo keraꞋa ki, kaidaꞋi kira tua Ꞌua Ꞌi Mesopotemia. Ma kera ka toꞋo goꞋo ana tai ngela kini logo, ma satana neꞋe Ꞌi Daena. KiraꞋa neꞋeriꞋa Ꞌorolada dao ana uulu akwala ma uulu ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ma tai neꞋe sa Gad faꞋinia ngela nia ki, neꞋe satada sa Sefon, sa Hagi, sa Suni, sa Esbon, sa Eri, sa Arodi, sa Areli. ");
INSERT INTO kwf_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ma tai neꞋe sa Asa faꞋinia ngela nia ki neꞋe satada sa Imna, sa Isva, sa Isvi, sa Beria faꞋinia ngwaingwaena kira Ꞌi Sera. Ro ngela sa Beria ki satadaroꞋo neꞋe sa Heba ma sa Malkiel. ");
INSERT INTO kwf_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nia ne ngela futa ana sa Jakob ki ma Ꞌi Silpa faꞋinia koꞋo tiꞋitiꞋi keraꞋa ki. ꞋI Silpa nia kini rao ꞋoꞋo neꞋe sa Laban kwatea fuana kini nia Ꞌi Lia kira Ꞌorolada dao ana taꞋi akwala ma ono ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sui sa Jakob faꞋinia Ꞌafe nia Ꞌi Rachel kera alua ro ngela ngwane ki satadaroꞋo neꞋe sa Josef ma sa Benjamin. ");
INSERT INTO kwf_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ꞋI Ejipt sa Josef nia korea ngela kini taꞋi ngwae Ꞌi Heliopolis neꞋe satana sa Potifera, nia na fata abu Ꞌi Heliopolis. Kini neꞋeri satana Ꞌi Asenat, ma kera ka alua ro ngela ngwane ki, satadaroꞋo neꞋe sa Manase ma sa Ifrem. ");
INSERT INTO kwf_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ma ngela sa Benjamin ki, satada neꞋe sa Bela, sa Bekere, sa Asbel, sa Gera, sa Naman, sa Ehi, sa Ros, sa Mupim, sa Hupim, ma sa Ada. ");
INSERT INTO kwf_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Nia ne ngela neꞋe futa ana sa Jakob ma Ꞌi Rachel faꞋinia koꞋo tiꞋitiꞋi keraꞋa ki. KiraꞋa Ꞌorolada dao ana akwala, ma fai ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ta ngela ana neꞋe sa Dan faꞋinia ngela nia neꞋe satana sa Husim. ");
INSERT INTO kwf_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ma tai neꞋe sa Naftali faꞋinia ngela nia ki, neꞋe satada sa Jasiel, sa Guni, sa Jesa, sa Silem. ");
INSERT INTO kwf_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Nia ne ngela neꞋe futa ana sa Jakob ma Ꞌi Bilha faꞋinia koꞋo keraꞋa ki. ꞋI Bilha nia kini rao neꞋe sa Laban kwatea fuana ngela kini nia Ꞌi Rachel. Na Ꞌorolada dao ana fiu ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","NgwaꞋi ngela neꞋe kira futa Ꞌi buira sa Jakob ma gwaꞋi toꞋa neꞋe kira leka faꞋinia Ꞌi Ejipt kira Ꞌoro ka dao ana ono akwala ma ono ngwae, kira Ꞌiri toꞋoa goꞋo Ꞌafe kira ki na ngela nia ki. ");
INSERT INTO kwf_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sa Jakob faꞋinia afutana ngela nia ki neꞋe kira leka tua Ꞌi Ejipt, faꞋinia sa Josef ma ro ngela nia ki neꞋe futa ana fanoa neꞋeri, kiraꞋa taꞋifau fiu akwala ki. ");
INSERT INTO kwf_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ꞋUnaꞋeri sa Jakob kwatea sa Juda ka leka etaeta Ꞌi naꞋo fasi Ꞌiri ke leka lisia sa Josef ka saea fuana ke leka saka fuana Ꞌi Gosen. Ma kaidaꞋi sa Jakob faꞋi kira dao Ꞌi Gosen, ");
INSERT INTO kwf_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","sa Josef leka Ꞌania kati nia neꞋe hos nia tara, ka leka maꞋi ka saka fuana maꞋa nia. KaidaꞋi kera saka fuadaroꞋo, sa Josef alua limama ka lolo Ꞌi buira luana maꞋa nia, nia ka lolofafia, nia ka angi sulia kaidaꞋi tau. ");
INSERT INTO kwf_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ꞋUnaꞋeri maꞋa nia ka fata Ꞌuri fuana, “Ngela nau Ꞌae, kaidaꞋi neꞋe diꞋia nau ku mae, nia taꞋa goꞋo, sulia nau ku lisia naꞋa maamu, ma nau ku sai leꞋa ana neꞋe Ꞌoko mauri Ꞌua.” ");
INSERT INTO kwf_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ma sa Josef ka fata Ꞌuri fuana ngwaefuta nia ki faꞋinia ngela kira ki, “Nai leka saea fuana tatalafaꞋa neꞋe kaumulu naꞋa Ꞌi neꞋe. Nai baꞋa fata Ꞌuri fuana, na ngwaefuta nau ki faꞋinia ngela kira ki, neꞋe kira tua Ꞌi Kenan, kaidaꞋi neꞋe kiraꞋa taꞋifau kira dao naꞋa maꞋi fuana tuaꞋa faꞋi nau. ");
INSERT INTO kwf_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","KiraꞋa ngwaꞋi toꞋa fuana liaꞋa sulia sipsip ki, kira toꞋo ana sipsip ki, ma nanigot ki, ma buluka ki faꞋinia ti ru laꞋu ada neꞋe kira ngaliꞋi maꞋi. Ma kike baꞋa lia sulia goꞋo ru ꞋaeꞋaela kira ki Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ma diꞋia tatalafaꞋa ri Ꞌuamulu fuana lisilana, ma nia ka saefilo Ꞌuri aumulu, ‘RaoꞋa faꞋuta ki neꞋe kaumulu saiana sasilani?’ ");
INSERT INTO kwf_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Kamu ka alaꞋa leꞋa fuana neꞋe eta maꞋi naꞋo, kaumulu ngwaꞋi toꞋa fuana liaꞋa sulia ru ꞋaeꞋaela ki goꞋo diꞋia koꞋo kia ki Ꞌi naꞋo. Ka ꞋunaꞋeri neꞋe nia saiana ke baꞋa alaꞋani kaumulu ka saungaꞋi nia fanoa kamu Ꞌi neꞋe. Nia ka fata Ꞌuri sulia falafala kira ngwaꞋi toꞋa Ꞌi Ejipt ki, kira noaꞋa kasi oga tua fikuꞋa faꞋinia ngwae lia sulia sipsip ki.” ");
INSERT INTO kwf_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ꞋUnaꞋeri sa Josef ka ngalia lima ngwaefuta nia ki, kira ka leka lisia tatalafaꞋa. KaidaꞋi kira dao Ꞌi luma tatalafaꞋa, sa Josef ka fata Ꞌuri fuana, “MaꞋa nau faꞋinia ngwaefuta nau kira dao naꞋa. Kira ngalia sipsip ki, ma nanigot ki ma buluka kira ki faꞋinia ti ru laꞋu ada, ma kira ka faꞋasia Ꞌi Kenan, ma kira ka dao naꞋa ana fanoa neꞋe. Ma kaidaꞋi neꞋe kira tua naꞋa Ꞌi Gosen.” ");
INSERT INTO kwf_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ma nia ka saea satada ngwaefuta nia ki fuana tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","GoꞋo tatalafaꞋa ka saefilo Ꞌuri ada, “RaoꞋa faꞋuta ki neꞋe kaumulu saiana sasilana?” Ma kira ka fata Ꞌuri, “TatalafaꞋa kaimili niniꞋa ngwae goꞋo fuana liaꞋa sulia sipsip ki, diꞋia nama koꞋo kami ki maꞋi Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kaimili leka maꞋi neꞋe sulia Ꞌi Kenan, kaidaꞋi Ꞌato ana fioloꞋa nia ngasingasiꞋa liu, ma ru ꞋaeꞋaela kami ki noaꞋa kira kasi toꞋo naꞋa ana ta fanga. ꞋOke alaꞋani kaimili mike sasia fanoa kaimili ana fanoa ꞋaꞋana nini Ꞌoe, ana ano nini Ꞌi Gosen.” ");
INSERT INTO kwf_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma tatalafaꞋa ka fata Ꞌuri fuana sa Josef, “KaidaꞋi neꞋe maꞋa Ꞌoe faꞋinia ngwaefuta Ꞌoe ki kira leka naꞋa maꞋi siamu, ");
INSERT INTO kwf_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","na fanoa neꞋe Ꞌifi fuada. Nia leꞋa fuana Ꞌoke alaꞋanida kike saungaꞋinia fanoa kira Ꞌi Gosen, ana ano leꞋa Ꞌi neꞋe ki. Ma diꞋia ti ai ada kira leꞋa fuana liaꞋa sulia ru ꞋaeꞋaela ki, nia leꞋa fuamu Ꞌoke aluda fuana kike lia sulia ru ꞋaeꞋaela nau ki.” ");
INSERT INTO kwf_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Buri Ꞌana sa Josef ka ngalia maꞋa nia ka dao siana tatalafaꞋa. Ma sa Jakob ka faꞋaleꞋa tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Sui tatalafaꞋa ka saefilo Ꞌuri ana, “Kwala araꞋi kwa, ta fita faꞋi ngali naꞋa neꞋe Ꞌoko tua sulia?” ");
INSERT INTO kwf_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma nia ka fata Ꞌuri, “NauꞋa niniꞋa taꞋi talangaꞋi ma uulu akwala faꞋi ngali ki goꞋo niniꞋa, ma kaidaꞋi Ꞌoro ana maurilaku, nau ku tua ꞋiduꞋidu ana kula ki. Maurilaku noaꞋa Ꞌiri diꞋia koꞋo nau faꞋida Ꞌi naꞋo neꞋe kira tua tau ma kira ka leka ana kula ki taꞋifau. Maurilaku nia ngwaraꞋu goꞋo ma nau ku dao toꞋona kaidaꞋi Ꞌato ki.” ");
INSERT INTO kwf_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma nia ka faꞋaleꞋa tatalafaꞋa neꞋeri, ma nia ka fata ni olioliꞋa ana, ma nia ka ruꞋu naꞋa Ꞌi maa. ");
INSERT INTO kwf_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Sui sa Josef ka saungaꞋinia fanoa maꞋa nia faꞋinia ngwaefuta nia ki, ana fanoa ꞋaꞋana neꞋeri. Ma nia ka ngalida kira ka tua karangia Ꞌi Rameses fanoa doe, ma nia ka kwatea ano leꞋa ki ana kula neꞋeri fuada, diꞋia tatalafaꞋa ba saea nama. ");
INSERT INTO kwf_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma nia ka kwatea fanga fuada neꞋe bolo faꞋinia Ꞌorolada. ");
INSERT INTO kwf_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ꞋUnaꞋeri ꞋatoꞋanga ana daoꞋa toꞋona fanga nia ka lilisu laꞋu, ma noaꞋa naꞋa ta fanga saena oꞋola ki. Ma na fioloꞋa neꞋeri ka taꞋa liu mala ana ngwaꞋi toꞋa Ꞌi Ejipt ma ngwaꞋi toꞋa Ꞌi Kenan logo. ");
INSERT INTO kwf_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ma kaidaꞋi Ꞌoro, kaidaꞋi ngwae ki kira foli fanga ana sa Josef, nia ka dau fafia mani neꞋeri ki ma ka goniꞋi saena luma tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ana ta kaidaꞋi buri, ngwae Ꞌi Ejipt ki ma Ꞌi Kenan ki, noaꞋa kira kasi toꞋo naꞋa ana ta mani goꞋo ngwae Ꞌi Ejipt ki kira leka maꞋi fuana lisilana sa Josef, ma kira ka fata Ꞌuri fuana, “ꞋOke kwatea nama fanga fuaimili! Na mani kami ki sui dangalu naꞋa. Ma si diꞋia Ꞌoko Ꞌiri dao naꞋa toꞋona ta kula fuaimili, kami ke baꞋa mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ma nia ka fata Ꞌuri fuada, “Nia leꞋa diꞋia mani kamu ki sui, kaumulu ke ngalia maꞋi ru ꞋaeꞋaela kamu ki, ma nai baꞋa olisia kwau Ꞌania fanga fuamuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ma kira ka ngalia kwau na ru ꞋaeꞋaela kira ki siana, ma nia ka kwatea kira ka rao Ꞌania fuana foli fangaꞋa fuada. Ana faꞋi ngali neꞋeri kira ka ngalia maꞋi hos ki, ma sipsip ki, ma nanigot ki, ma buluka ki, ma dongki kira ki fuana, ma nia ka alaꞋani kira ka foli fanga ada Ꞌania ru ꞋaeꞋaela neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Bore ma faꞋi ngali Ꞌi buri laꞋu, kira leka maꞋi ma kira ka fata laꞋu Ꞌuri fuana, “AraꞋi ꞋaꞋana Ꞌae, mani kami ki sui naꞋa, ma ru ꞋaeꞋaela kaimili ki ka sui naꞋa maꞋi fuamu. Kaimili Ꞌiri toꞋo naꞋa ana ti ru laꞋu neꞋe kaimili ke kwate fuamu. Kaimili ngwae ki goꞋo neꞋe tua, faꞋinia ano kaimili ki. ");
INSERT INTO kwf_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ꞋIu kaimili amasi Ꞌoe, Ꞌoe kosi alaꞋani kami fuana maeꞋa! ꞋOke dao toꞋona ta kula fuamiꞋa. ꞋOe kosi alaꞋani ano kami ki ka gwaꞋu laꞋu. Si diꞋia Ꞌoko kwatea fanga fuamiꞋa, na fanga neꞋeri naꞋa neꞋe ke foli kami faꞋinia ano kaimili ki, ma ano neꞋeri ki ru tatalafaꞋa naꞋa, ma kaimili ke baꞋa rao ꞋoꞋo naꞋa fuana. Bore ma kaimili oga Ꞌoke kwatea fanga fuaimili, fasi Ꞌiri noaꞋa kami kasi mae, ma Ꞌoko kwatea maꞋi magana witi fuaimili, fasi Ꞌiri kami ke fasiꞋi Ꞌania oꞋola kaimili ki.” ");
INSERT INTO kwf_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ma ka ꞋunaꞋeri, nia ka folia ano ngwaꞋi toꞋa Ꞌi Ejipt ki ka alua naꞋa ano tatalafaꞋa. Na kaidaꞋi Ꞌato neꞋe raꞋe maꞋi ka lilisu liu fafida nia kwatea ma kira taꞋifau kika Ꞌoifoli Ꞌania ano kira ki Ꞌuana fanga, ma ano ana fanoa neꞋe taꞋifau ano tatalafaꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ka ꞋunaꞋeri, kwatea ngwaꞋi toꞋa Ꞌi Ejipt kira ka rao ꞋoꞋo naꞋa fuana tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nia foli musia naꞋa ano ngwae ki fuana tatalafaꞋa, bore ma ano na fata abu ki goꞋo neꞋe niaꞋa kasi foliꞋi, osiꞋana kaidaꞋi ki tatalafaꞋa nia kwatea kala mani ki fuana fata abu ki fasi Ꞌiri kike foli fanga Ꞌada aniꞋi. Ma kaidaꞋi Ꞌato neꞋeri noaꞋa kasi sasia neꞋe kira ka Ꞌoifoli Ꞌani ano kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Sui nia ka fata Ꞌuri fuana ngwae ki, “Kamu ke sai nama ana neꞋe nau ku foli kamu ka sui naꞋa ne, faꞋinia ano kamu ki logo. KaidaꞋi neꞋe ano ki taꞋifau ru tatalafaꞋa ki naꞋa, ma kaumulu niniꞋa ngwae rao ꞋoꞋo nia ki logo. Bore ma kaumulu saiana muke oꞋolia oꞋola ki ana ano neꞋe ki, na magana witi tua goꞋo Ꞌana fuana muke leka fasia. ");
INSERT INTO kwf_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bore ma kaidaꞋi neꞋe diꞋia kamu ngalia fanga neꞋana ki, kamu ke baꞋa daroꞋia Ꞌania lima kabu ru ki, ta taꞋi kabu ru tatalafaꞋa, ma fai kabu ki neꞋe fuamuꞋa faꞋinia ngela kamu ki fuana Ꞌanilana, ma fasilana laꞋu ana oꞋola kamu ki.” ");
INSERT INTO kwf_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ꞋUnaꞋeri kira ka fata Ꞌuri fuana, “Ngwae ꞋaꞋana Ꞌae, Ꞌoko faꞋamauria mango mia. ꞋOko leꞋa aimili. Kaimili saeleꞋa goꞋo Ꞌaimili neꞋe mike rao ꞋoꞋo fuana tatalafaꞋa!” ");
INSERT INTO kwf_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ꞋUnaꞋeri nia ka alua taꞋi taki Ꞌi Ejipt neꞋe nia Ꞌuri, ana faꞋi ngali ki taꞋifau na ngwae ki taꞋifau kike daroꞋia fanga neꞋe kira ngaliꞋi maꞋi ana oꞋola lima kabu ru ki, ma ta taꞋi kabu kike kwatea fuana tatalafaꞋa. Ma taki neꞋeri nia teo Ꞌua leleka ka dao Ꞌi taꞋena. Na ano fata abu ki goꞋo neꞋe noaꞋa laꞋu ano tatalafaꞋa ana kaidaꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ꞋUnaꞋeri sa Jakob faꞋinia kwalafaꞋa nia kira tua Ꞌi Ejipt ana kula kira saea Ꞌani Gosen, ma kira ka toꞋoru liu, ma kira ka toꞋo logo ana ngela Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sa Jakob tua ana kula neꞋeri fuana akwala ma fiu faꞋi ngali, leleka ka dao ana taꞋi talangaꞋi ma fai akwala ma fiu faꞋi ngali ki ana. ");
INSERT INTO kwf_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ma kaidaꞋi nia saiana nia karangia naꞋa kaidaꞋi nia fuana maeꞋa, nia ka saea ngela nia sa Josef ka leka maꞋi ka lisia. Ma nia ka fata Ꞌuri fuana, “Leka maꞋi, diꞋia Ꞌoko kwaima liu aku, Ꞌoke alua maꞋi limamu Ꞌi olofana sasafaku, ma Ꞌoko fata alangaꞋi fuaku neꞋe Ꞌoe kosi baꞋa kwaiato nau Ꞌi neꞋe Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ana kaidaꞋi nai mae, Ꞌoke ngali nau nama faꞋasia Ꞌi neꞋe, ma Ꞌoko aka nau ko leka kwaiato nau ana kula ba kira kwaiatoa koꞋo nau faꞋida ana.” Then Josef said, “I will do what you say to me.” ");
INSERT INTO kwf_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Bore ma nia ka fata laꞋu Ꞌuri, “ꞋOke alangaꞋi Ꞌania satana God neꞋe Ꞌoke baꞋa sasi ꞋunaꞋeri.” Ma sa Josef alangaꞋi nia ke baꞋa sasia ru neꞋeri. Ma ana kaidaꞋi neꞋeri, maꞋa nia ka bobo uruuru saena ꞋifitaꞋi nia, ma ka baꞋatangoa God. ");
INSERT INTO kwf_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ana ta kaidaꞋi buri, sa Josef nia rongoa neꞋe maꞋa nia mataꞋi liu. GoꞋo nia ka ngalia ro ngela nia ki sa Manase ma sa Ifrem kira ka leka lisia. ");
INSERT INTO kwf_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ana kaidaꞋi sa Jakob rongoa neꞋe ngela nia leka maꞋi fuana lisilana, sui bore Ꞌana nia ka teo ana ꞋifitaꞋi, nia suꞋute ka tataꞋe ka tua nama saena ꞋifitaꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ꞋUnaꞋeri nia ka fata Ꞌuri Ꞌana sa Josef, “God neꞋe toꞋo ana ngasingasiꞋanga ki, nia dao siaku Ꞌi Lus ana fanoa ꞋaꞋana Ꞌi Kenan ma nia ka faꞋaleꞋa nau. ");
INSERT INTO kwf_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Nia fata Ꞌuri fuaku, ‘Nai baꞋa kwatea ngela Ꞌoro fuamu, ma ana ngela neꞋe kike baꞋa futa maꞋi burimu ki, kike baꞋa Ꞌoro liu. Ano neꞋe nai baꞋa kwatea naꞋa fuada, ma ano kira fuana kaidaꞋi firi naꞋa.’” ");
INSERT INTO kwf_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma nia ka fata laꞋu Ꞌuri, “Josef, ro ngela nini Ꞌoe ki neꞋe kera eta futa Ꞌi neꞋe kaidaꞋi noaꞋa nau kusi leka Ꞌua maꞋi neꞋe, keraꞋa ro ngela nau ki naꞋa. Nau ku lisia sa Ifrem faꞋinia sa Manase, kera diꞋia naꞋa ro ngela nau ki naꞋa, diꞋia ro ngela nau ki sa Ruben ma sa Simion. ");
INSERT INTO kwf_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Si diꞋia Ꞌoko alua laꞋu ti ngela, kiraꞋa neꞋe na ngela Ꞌoe ki talamu, ma kike baꞋa toꞋo ana ano nini nau ku kwatea fuana sa Efrem ma sa Manase. ");
INSERT INTO kwf_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nau ku sasi ꞋunaꞋeri ana ro ngela ngwane neꞋe Ꞌoe ki sulia nau ku kwaimanatai liu ana teꞋa Ꞌoe Ꞌi Rachel neꞋe nia mae maꞋi Kenan ana kaidaꞋi nau ku oli maꞋi faꞋasia Ꞌi Mesopotemia ma nau ku kwaiatoa Ꞌi ninimana tala neꞋe leka Ꞌuana fanoa doe kira saea Ꞌani Efrat.” KaidaꞋi neꞋe kira saea Ꞌi Eprat Ꞌani Ꞌi Betlehem naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ma kaidaꞋi nia lisia ro ngela nini sa Josef ki, nia ka saefilo Ꞌuri ana, “Sa tai faꞋida niniꞋa ro ngela ngwane neꞋe ki?” ");
INSERT INTO kwf_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ma sa Josef ka fata Ꞌuri, “Na ro ngela ngwane nau ki niniꞋa, neꞋe God kwateda fuaku kaidaꞋi nau ku tua Ꞌi neꞋe.” Sui sa Jakob ka fata Ꞌuri, “ꞋOke baꞋedaroꞋo maꞋi karangi nau, fasi Ꞌiri nai faꞋaleꞋadaroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","KaidaꞋi neꞋe sa Israel nia ngwaro liu naꞋa, ma maana ka taꞋa naꞋa, ma nia noaꞋa kasi lia madako naꞋa. Sa Josef ka baꞋea maꞋi ro ngela neꞋe ki siana, ma nia ka ofi keraꞋa ma ka nonoꞋidaroꞋo, ");
INSERT INTO kwf_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ma nia ka fata Ꞌuri ana sa Josef, “ꞋI naꞋo nau ku fia fasi naisi baꞋa lisiꞋo laꞋu, bore ma niniꞋari God nia alaꞋani nau fuana lisilana ro ngela neꞋe Ꞌoe ki.” ");
INSERT INTO kwf_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ma kera ka tua Ꞌi fafona Ꞌaena fasi Ꞌiri nia ke faꞋataꞋinia neꞋe nia lisidaroꞋo ka diꞋia ro ngela mamana nia ki. Sui sa Josef ka lafudaroꞋo laꞋu, ma nia ka bobo uruuru Ꞌi naꞋona maꞋa nia, leleka maana ka toꞋo Ꞌi ano. ");
INSERT INTO kwf_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ꞋUnaꞋeri sa Josef ka alua sa Ifrem ana bali mauli ana maꞋa nia, ma ka alua sa Manase ana bali ꞋoloꞋolo nia. ");
INSERT INTO kwf_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bore ma maꞋa nia ka alu kwairokisi ana limana, ma sui bore Ꞌana sa Ifrem na ruana ngwae, nia alua lima ꞋoloꞋolo nia Ꞌi gwauna, ma nia ka alua lima mauli nia ana gwauna sa Manase na ai eta futa. ");
INSERT INTO kwf_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ꞋUnaꞋeri nia ka faꞋaleꞋa sa Josef ana satana God, na God sa Abraham ma sa Aesak. Nia fata Ꞌuri, “Na God koꞋo nau, nia God maꞋa nau, ma nia God nau, kaidaꞋi Ꞌoro nia talaꞋi nau leleka ka dao Ꞌi taꞋena, ");
INSERT INTO kwf_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ma Ꞌainsel nia ka faꞋamauri nau faꞋasia ru ke faꞋali nau ki. AlaꞋani nia ke faꞋaleꞋa ro ngela ngwane neꞋe ki. AlaꞋani sataku, ma satana maꞋa nau, ma satana koꞋo nau ke kwatea ngasingasiꞋanga talau fuana ro ngela neꞋe ki. Ma kera ke manata toꞋona sataꞋi ru neꞋe firi. AlaꞋani kera ke baꞋa toꞋo ana ngela Ꞌoro ki, ma ngela Ꞌoro ki laꞋu ke baꞋa futa Ꞌi buridaroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ma kaidaꞋi sa Josef lisia ma nia neꞋe alu lima ꞋoloꞋolo nia Ꞌi gwauna sa Ifrem, nia ka kwaimanatai Ꞌuana ngela nia. Ma nia ka dau ana limana maꞋa nia ka Ꞌidua faꞋasia gwauna sa Ifrem ma ka alua Ꞌi gwauna sa Manase. ");
INSERT INTO kwf_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ma nia ka fata Ꞌuri, “MaꞋasi Ꞌae, noaꞋa Ꞌoe kosi sasi laꞋu Ꞌuri, sa Manase naꞋa neꞋe eta futa, Ꞌoke alua nama lima ꞋoloꞋolo Ꞌoe Ꞌi gwauna.” ");
INSERT INTO kwf_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bore ma maꞋa nia ka fata Ꞌuri, “Ngela nau, nau ku saiana, bore ma nau kusi sasi Ꞌuira. Ngela neꞋe kike baꞋa futa maꞋi buira sa Manase kira na fuuꞋi ngwae ngasingasiꞋa. Bore ma ruana ai neꞋe ke baꞋa ngasingasiꞋa liufia niaꞋa, ma ngela neꞋe kike baꞋa futa maꞋi burina ki kike baꞋa Ꞌoro liu.” ");
INSERT INTO kwf_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nia faꞋaleꞋa kera ana asoa neꞋeri, ma nia ka fata Ꞌuri, “Ro ngwane, ngela neꞋe kike futa maꞋi buriku ki, kike baꞋa rao Ꞌani satamuroꞋo fuana faꞋaleꞋalana ti ngwae. Kike baꞋa fata Ꞌuri, ‘AlaꞋani God ke faꞋaleꞋa Ꞌoe diꞋia nia faꞋaleꞋa sa Ifrem ma sa Manase.’” Ka ꞋunaꞋeri neꞋe nia ka alua sa Ifrem ka etaeta, ma sa Manase Ꞌi buira. ");
INSERT INTO kwf_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ma nia ka fata Ꞌuri ana sa Josef, “Ngela nau Ꞌae. Karangi nau ku mae naꞋa. Bore ma God ke baꞋa tua faꞋi kaumulu, ma nia ke baꞋa ngali kaumulu ka oli Ꞌuana kula koꞋo kamu ki. ");
INSERT INTO kwf_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Na ano nini Ꞌi Sekem nia leꞋa liu mala, ma nau ku kwatea naꞋa fuamu. Nau ku ngalia kula neꞋe faꞋasia kwalafaꞋa sa Amoro ana fuꞋanga. Nau noaꞋa kusi kwatea ano neꞋe fuana ngwaefuta Ꞌoe, nau ku oga nai kwatea fuamu talamu, ma ru Ꞌoe naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ꞋUnaꞋeri sa Jakob ka saea ngwaꞋi ngela nia ka leka maꞋi siana, ma nia ka fata Ꞌuri fuada, “Mulu leka karangi nau maꞋi fasi Ꞌiri nai saea fuamuꞋa ru neꞋe ke baꞋa dao toꞋomulu ki. ");
INSERT INTO kwf_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kaumulu ngela nauꞋa sa Jakob ki, mulu leka karangi nau maꞋi, muka fafarongo leꞋa maꞋi aku sa Israel. NauꞋa naꞋa neꞋe maꞋa kamu. ");
INSERT INTO kwf_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, ꞋaeꞋo ngela eta futa nau, ꞋaeꞋo naꞋa neꞋe ngasingasiꞋanga nau. KaidaꞋi nau ku araꞋi ma ku ngasingasiꞋa Ꞌua, ꞋaeꞋo naꞋa neꞋe ngela eta futa nau. Satamu nia dufaꞋa liu, ma Ꞌoko ngasingasiꞋa liufia ti ngwaefuta amu. ");
INSERT INTO kwf_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ꞋOko diꞋia ta kafo afe doe ma noaꞋa ta ngwae kasi fonea. Bore ma eta Ꞌi taꞋena, satamu noaꞋa kasi lafua liufia ngwaefuta Ꞌoe ki, sulia Ꞌoko sai goꞋo Ꞌamu ana neꞋe nauꞋa na maꞋa Ꞌoe, bore ma Ꞌoko faꞋa Ꞌeke nau liu, kaidaꞋi Ꞌoko teo faꞋinia kini rao ꞋoꞋo nau neꞋe nia ta Ꞌafe logo aku. ");
INSERT INTO kwf_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Sa Simion ma sa Lifae, koroꞋo taꞋi ngwae ngwaefuta ki goꞋo. KoroꞋo rao Ꞌania ru ni fuꞋanga koroꞋo ki fuana faꞋalilana ti ngwae. ");
INSERT INTO kwf_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nau noaꞋa kusi Ꞌado faꞋinia alaꞋanga ago koroꞋo ki. KaidaꞋi koroꞋo oga taꞋa, koroꞋo ke saungia ti ngwae ka mae. Ma koroꞋo ka leka tufua lololi Ꞌi burina Ꞌaena buluka ki ma moro ka gaꞋa gaꞋa goꞋo amuroꞋo Ꞌanida. ");
INSERT INTO kwf_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","AlaꞋani God ke nangasi koroꞋo faꞋinia oga taꞋangaꞋa kamuroꞋo ki neꞋe ngasingasiꞋa ma falafala koroꞋo ki fuana faꞋalagalana laꞋu liu ngwae ki. Nai baꞋa daroꞋia ngwaꞋi ngela neꞋe kike futa maꞋi burimu roꞋo ma kike tua kwailiu safitana ti ngwae neꞋe kira ke baꞋa futa maꞋi buriku. ");
INSERT INTO kwf_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda ngwaefuta Ꞌoe ki kira ke baꞋa baꞋatafe Ꞌoe, Ꞌoke baꞋa faꞋakosoa malimae Ꞌoe ki, leleka kira ka tua goꞋo Ꞌi olofana ngasingasilamu. Ngwaefuta Ꞌoe ki kike bobo uruuru fuana faꞋa ꞋaꞋana lamu. ");
INSERT INTO kwf_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ꞋOko diꞋia ta lion ba leka fuana saungilana ta ru ꞋaeꞋaela fuana Ꞌanilana. KaidaꞋi nia oli maꞋi saena kilu nia, nia teo ka ꞋoꞋolosia na noina, ma ngwae ki taꞋifau kika maꞋungia, ma noaꞋa ta ngwae saiana neꞋe ke leka faꞋa ada. ");
INSERT INTO kwf_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ta taꞋi ai ada neꞋe ke baꞋa futa maꞋi burimu, nia ke baꞋa tatalafaꞋa, ma ai neꞋe kike baꞋa futa maꞋi buri ana, kike baꞋa dau firi fafia ngasingasiꞋanga ana tatalafaꞋa Ꞌanga. Ma kiraꞋa goꞋo neꞋe kike baꞋa tatalafaꞋa, leleka ngasingasiꞋanga ka leka ana ngwae neꞋe toꞋo ana sagaꞋa fuana daulana ngasingasiꞋanga neꞋeri, ma ngwae ki taꞋifau kike kwairoꞋoi ana. ");
INSERT INTO kwf_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ngwae neꞋeri ke baꞋa firiꞋia na dongki nia ana Ꞌai grep, ma ka firiꞋia dongki fiꞋi doe nia ana rara Ꞌai leꞋa mala ana Ꞌai grep, sulia Ꞌai grep ki Ꞌoro liu ma nia kasi Ꞌabera goꞋo si diꞋia dongki neꞋeri Ꞌania rauna Ꞌai grep neꞋeri. Ana kaidaꞋi neꞋeri, kula neꞋeri ke baꞋa fungu ana grep fuana sasilana Ꞌania waen leꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","TatalafaꞋa neꞋeri maana ke baꞋa meo liu osiꞋana nia kwaꞋufia waen Ꞌoro, ma lifana ke baꞋa kwao liu sulia nia kwau liua susu Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun, Ꞌoke baꞋa saungaꞋinia fanoa Ꞌoe karangia asi. Fanoa Ꞌoe ke baꞋa kula fuana agoꞋa neꞋe faka ki kike ago ana, ma ano Ꞌoe ke baꞋa leka daofaꞋi liu leleka ka dao Ꞌi Saedon. ");
INSERT INTO kwf_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar, Ꞌoko diꞋia dongki rao ki neꞋe nia saeleꞋa goꞋo fuana tagalana Ꞌaena ma nia ka maliu safitana ro ngwaꞋi nia ngaliꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","KaidaꞋi nia lisia kula neꞋe nia tua ana neꞋe leꞋa, ma ano nia tua ana leꞋa, nia fiꞋi saeleꞋa laꞋu fuana ngalilana ru kulu ki, ma nia ta ngwae rao ꞋoꞋo. ");
INSERT INTO kwf_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan, ꞋaeꞋo Ꞌoke baꞋa kwaitalaꞋi ngasingasiꞋa. Ma Ꞌoke baꞋa lia leꞋa sulia ngwae neꞋe kike futa maꞋi burimu ki, ka diꞋia logo ai neꞋe kike baꞋa futa maꞋi buri ana ngwaefuta Ꞌoe ki. ");
INSERT INTO kwf_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Bore ma ngwae ki taꞋifau neꞋe kike baꞋa futa maꞋi burimu, kike baꞋa lialia liu diꞋia faꞋi loi ki neꞋe boboro Ꞌi ninimana tala, kike baꞋa diꞋia fai baꞋeko tolo neꞋe toꞋo ana io saena kwakwana, ana kaidaꞋi nia Ꞌalea Ꞌaena hos, hos neꞋeri ka uu Ꞌani ro Ꞌae nia ki, ma ngwae neꞋe ka tua Ꞌi fafona ka Ꞌasia, ma ka fotongaꞋinia ngwaꞋi nia ana ano. ");
INSERT INTO kwf_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aofia Iawe, nau ku masiꞋo naꞋa fasi Ꞌiri Ꞌoke faꞋamauri nau. ");
INSERT INTO kwf_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad, na ngwae bili ki kike baꞋa leka maꞋi fuana fuꞋanga faꞋi Ꞌoe, bore ma Ꞌoke baꞋa liufida, ma Ꞌoke baꞋa lalida logo. ");
INSERT INTO kwf_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asa, ano Ꞌoe ke baꞋa toꞋo ana fanga leꞋa ki, ma fanga neꞋe Ꞌoko sasiꞋi ki, tatalafaꞋa bore saiana ke aniꞋi goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali, Ꞌoke baꞋa diꞋia taꞋi kirio neꞋe nia aloge fuana siu kwailiu Ꞌanga saena asi, ma ngela nia ki lisilada ka leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josef, Ꞌoko diꞋia taꞋi Ꞌai grep neꞋe nia bulao karangi ana, mae kafo busu, ma nia ka toꞋo ana fuaꞋi ru Ꞌoro ana, ma rarana ka doe ma ka tatara toli fafona sulufaua. ");
INSERT INTO kwf_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Na malimae Ꞌoe ki, kira ke leka maꞋi fuana fuꞋalilamu, ma kike fanasiꞋo Ꞌani basi ma sima kira ki. ");
INSERT INTO kwf_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bore ma God nauꞋa sa Jakob, nia ngasingasiꞋa liu. God nauꞋa sa Israel, nia ke baꞋa lia leꞋa sulia ai neꞋe kike baꞋa futa maꞋi burimu, diꞋia ba ta ngwae lia leꞋa sulia amuꞋi sipsip nia, ma ka tagi sulida. Ma nia ke baꞋa lia leꞋa suliꞋo, ma nia ke baꞋa faꞋangasingasiꞋo ma limamu neꞋe Ꞌoko dau fafia Ꞌania basi noaꞋa kasi baꞋa lebelebe. ");
INSERT INTO kwf_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ngela nau Ꞌae, God neꞋe toꞋo ana ngasingasiꞋanga ki taꞋifau, ma niaꞋa God nau, nia ke baꞋa Ꞌafi Ꞌoe, ma ka faꞋa leꞋa Ꞌoe. Ma nia ke baꞋa faꞋakosoa maꞋi uta ka Ꞌasia maꞋi fafiꞋo, ma ke baꞋa kwatea kafo fuamu neꞋe raꞋe alaꞋa maꞋi faꞋasia na kafo busu maꞋi ano. Ma nia ke baꞋa kwatea ngela Ꞌoro fuamu, ma ngela neꞋeri ki kike doe leꞋa, ma kika ngasingasiꞋa. Ma ru ꞋaeꞋaela Ꞌoe ki kike baꞋa toꞋo ana ngela Ꞌoro logo. ");
INSERT INTO kwf_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","FaꞋi ua doe neꞋe ki niniꞋa teo Ꞌua naꞋa maꞋi naꞋo, niꞋi ke baꞋa tua tari naꞋa ma noaꞋa kasi sui, ma ru leꞋa ki neꞋe saka maꞋi faꞋasida niꞋi Ꞌoro liu, bore ma nauꞋa maꞋa Ꞌoe, ma ru leꞋa niniꞋa nau ku saea fuana faꞋaleꞋa lamu, niꞋi leꞋa ka liufia laꞋu ru leꞋa neꞋeri ki. Ma ꞋaeꞋo sa Josef, Ꞌoko leꞋa ka tasa ana ngwaefuta nini Ꞌoe ki. Ma alaꞋania ru leꞋa ki niꞋi ke tua amu. ");
INSERT INTO kwf_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin, Ꞌoke diꞋia kui kwasi neꞋe ꞋafaꞋafa ma ka ꞋafaꞋafa, neꞋe Ꞌofodangi ma na rodo nia saumaelia ru ki, ma ka Ꞌanida.” ");
INSERT INTO kwf_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Kira naꞋa ne akwala ma ro ngwaefuta neꞋe kira koꞋo ana akwala ma ro kwalafa sa Israel, neꞋe sata etaeta nia sa Jakob. Ma nia ne na alaꞋanga araꞋi ngwaro neꞋe kwatea fuana ngwaꞋi ngela nia ma ka saea alaꞋanga Ꞌisi nia ma ka kwatea ngwangwane Ꞌanga nia fuada taꞋifau neꞋe bolo faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Ma sa Jakob ka alaꞋa totongaꞋi Ꞌuri fuada, “Nau ku karangi mae naꞋa. Bore ma kaumulu ke kwaiato nau nama ana faoda ba kira kwaiatoa maꞋa nau faꞋida Ꞌi naꞋo ana. Kamu ke baꞋa ngalia noniku ka oli Ꞌuana Ꞌi Kenan ana kula neꞋe kira saea Ꞌani Ꞌi Makpela, ninimana Ꞌi Mamre bali fanelana sina. Ano neꞋeri Ꞌi naꞋo nia ru taꞋi ngwae ana kwalafa sa Het, neꞋe satana sa Efron, ma nia toꞋo ana taꞋi faoda saena fau. Afu ano neꞋeri koꞋo nau neꞋe folia fuana kwaiatoꞋanga. ");
INSERT INTO kwf_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Faoda neꞋe naꞋa neꞋe kira kwaiatoa nonina ro koꞋo nau ki sa Abraham, ma Ꞌi Sera. Ma ana kula neꞋeri logo kira kwaiato nonina maꞋa nau ma teꞋa nau, ma nau ku kwaiatoa logo Ꞌi Lia ana. ");
INSERT INTO kwf_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","MaꞋa kulu nia foli musia naꞋa ano neꞋe ana kwalafa sa Het. Ma na afu ano neꞋe faꞋinia faoda nini ana fau ru kulu ki. Kaumulu muke kwaiato nau ana kula neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","KaidaꞋi nia faꞋasuia alaꞋanga neꞋeri ki fuana ngela nia ki goꞋo, nia ka teo kwau saena ꞋifitaꞋi ma ka maꞋe naꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ꞋUnaꞋeri sa Josef ka ego kwau ana maꞋa nia, ma ka daua maꞋa nia, ma ka angi doe liu Ꞌuana, ma nia ka nonoꞋia maana. ");
INSERT INTO kwf_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ma nia ka ri Ꞌuana ngwaꞋi toꞋa Ꞌi Ejipt neꞋe kira rao fuana kira ka leka maꞋi, ma nia ka saea fuada neꞋe kira sai leꞋa ana falafala fuana sasilana nonina ngwae mae neꞋe noaꞋa kasi ngwaꞋa, fasi Ꞌiri kira ke sasi logo ꞋunaꞋeri ana nonina maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","RaoꞋa neꞋeri kira ke rao ana sulia fai akwala asoa ki. Ma fai akwala asoa neꞋeri ki naꞋa neꞋe kaidaꞋi leꞋa fuana sasilana raoꞋa neꞋeri. Ma ngwaꞋi toꞋa Ꞌi Ejipt kira ka kwaimanatai Ꞌuana sulia fiu akwala asoa ki. ");
INSERT INTO kwf_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ma kaidaꞋi fuana kwaimanatai Ꞌanga nia sui, sa Josef ka fata Ꞌuri ana ngwae ꞋaꞋana tatalafaꞋa ki, “Ngwadela kina, mulu leka saea fatalaku fuana tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","KaidaꞋi maꞋa nau karangi mae, nia kwatea nau ku fata alangaꞋi Ꞌani satana God neꞋe nai baꞋa olitaꞋinia nama nonina fuana kwaiatolana Ꞌi Kenan, ana taꞋi faodaꞋi fau neꞋe nia salisalia naꞋa ana. ꞋOke alaꞋani nau nai leka fuana kwaiatolana maꞋa nau, ma buri Ꞌana nai baꞋa oli laꞋu maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Sui na tatalafaꞋa ka olitaꞋinia maꞋi alaꞋanga ka Ꞌuri, “Nia leꞋa goꞋo Ꞌana. ꞋOko saiana Ꞌoke leka kwaiatoa maꞋa Ꞌoe diꞋia nama neꞋe Ꞌoko fata alangaꞋi fuana ka sui naꞋa fuana sasilana.” ");
INSERT INTO kwf_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ꞋUnaꞋeri sa Josef leka ka kwaiatoa naꞋa maꞋa nia. Na ngwae ꞋaꞋana tatalafaꞋa ki, faꞋinia ti ngwae laꞋu fuana Ꞌafilana, ma gwaungaꞋi ki taꞋifau Ꞌi Ejipt kira leka faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ma ngela nia ki logo, faꞋinia ngwaefuta nia ki, ma ti ngwae laꞋu ana fuuꞋi ngwae kira, kira leka taꞋifau. Kira ngela tiꞋitiꞋi ki faꞋinia ru ꞋaeꞋaela kira ki goꞋo neꞋe tua Ꞌi Gosen. ");
INSERT INTO kwf_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","NgwaꞋi toꞋa neꞋe leka Ꞌi buri Ꞌana, ti ai ada leka saena kati neꞋe hos tara, ma ti ai ada ka tua fafona hos, ma kira ka leka ꞋoroꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ana kaidaꞋi kira dao Ꞌi Atad ta bali ana kafo Ꞌi Jodan bali fanelana sina, kira ka angi sulia kaidaꞋi tau. Kula neꞋeri kula fuana Ꞌefolana witi ana, bore ma kula neꞋeri sa Josef nia tua sulia fiu asoa, ma nia ka angi Ꞌuana maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","KaidaꞋi ngwaꞋi toꞋa Ꞌi Kenan kira lisia neꞋe ngwaꞋi toꞋa neꞋe kira angi liu naꞋa, kira ka fata Ꞌuri, “Reala, ngwaꞋi toꞋa Ꞌi Ejipt kira angi liu naꞋa Ꞌuana maꞋa kira.” Kula neꞋeri Ꞌi naꞋo kira saea Ꞌani Ꞌi Atad, kira ka saea laꞋu Ꞌania Ꞌi Abelmisraem neꞋe fadalana Ꞌuri, “Kwaimanatai Ꞌanga ngwae Ꞌi Ejipt ki.” ");
INSERT INTO kwf_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ka ꞋunaꞋeri neꞋe ngwaꞋi ngela sa Jakob kira ka sasi naꞋa diꞋia maꞋa kira nia saea. ");
INSERT INTO kwf_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kira ngalia nonina ka oli Ꞌuana Ꞌi Kenan Ꞌi Makpela ana bali loꞋoko ana Ꞌi Mamre bali fanelana sina, ma kira ka kwaiatoa saena faodaꞋi fau, ana afu ano neꞋeri etaeta kula sa Efron ngwae ana kwalafa sa Het, bore ma sa Abraham nia folia ana, ma nia ano naꞋa fuana kwaiato Ꞌanga kira. ");
INSERT INTO kwf_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ma kaidaꞋi sa Josef kwaiatoa ka sui naꞋa, nia faꞋinia ngwaefuta nia ki, ma ti ngwae laꞋu kira faꞋasia kula neꞋeri, ma kira ka oli laꞋu maꞋi Ꞌuana Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","KaidaꞋi ngwaefuta sa Josef ki lisia neꞋe maꞋa kira mae naꞋa, kira ka alaꞋa Ꞌuri fuada talada, “FaꞋuta, diꞋia sa Josef nia manata nama Ꞌana toꞋona ru taꞋa ba kulu sasiꞋi ana Ꞌi naꞋo, ma nia ka oga ke duꞋua laꞋu ru taꞋa ba kulu sasiꞋi ana Ꞌi naꞋo ki akulu, kuke baꞋa faꞋuta naꞋa niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ma kira ka kwatea alaꞋanga ka leka Ꞌuana ma kika fata Ꞌuri, “ꞋI naꞋo kaidaꞋi maꞋa kulu tua Ꞌua, ");
INSERT INTO kwf_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nia saea taꞋi alaꞋanga fuaimili fasi Ꞌiri kaimili ke saea fuamu. Nia fata Ꞌuri ba, ‘ꞋI naꞋo ba ngwaefuta Ꞌoe ki kira sasia ru rora liu ki amu, ma kira ka fulia taꞋangaꞋa. Nau ku amasiꞋo Ꞌoke rufuanata ada.’ ꞋIu, kaimiliꞋa ngwae rao God maꞋa kulu logo niniꞋa. ꞋOke rufuanata aimili faꞋinia taꞋangaꞋa nini kami ki.” Ma kaidaꞋi sasina ki kira fafarongoa Ꞌania alaꞋanga neꞋeri, nia ka angi. ");
INSERT INTO kwf_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","GoꞋo ngwaefuta nia ki kira ka leka ma kira ka bobo uruuru Ꞌi naꞋona kika faꞋadoea, ma kira ka fata Ꞌuri, “Kaimili ngwae rao ꞋoꞋo Ꞌoe ki naꞋa ne.” ");
INSERT INTO kwf_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bore ma nia ka fata lala Ꞌuri fuada, “NoaꞋa kamu kasi maꞋu laꞋu. Nau noaꞋa kusi sasia tae neꞋe God goꞋo neꞋe saiana sasilana. ");
INSERT INTO kwf_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kaumulu neꞋe naia sasilana ru taꞋa ki aku, bore ma God bulasia naiꞋi ru Ꞌanga kamu, ma ka sasia ka leꞋa. Nia rao Ꞌania naiꞋi ru Ꞌanga kaumulu fuana faꞋamaurilana ngwae Ꞌoro. Kira mauri ka dao Ꞌi taꞋena, osiꞋana ru taꞋa neꞋeri ki neꞋe kaumulu sasiꞋi. ");
INSERT INTO kwf_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nia ne noaꞋa mu kasi maꞋu. Nai baꞋa tagi suli kamu faꞋinia ngela kamu ki.” Ru ꞋunaꞋeri neꞋe nia ka alaꞋa leꞋa fuada, ma nia ka sasia kira ka manata leꞋa laꞋu. ");
INSERT INTO kwf_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Sui sa Josef faꞋinia luꞋuluꞋua maꞋa nia kira tua Ꞌi Ejipt. Sa Josef tua Ꞌua kaidaꞋi sa Ifrem toꞋo ana ngela nia ki ma kala koꞋo nia ki logo. Ma nia ka lisia kala koꞋo sa Manase ki logo ana ngela nia sa Makiri neꞋe faꞋafutaꞋi, ma nia ka saea ngela sa Makiri ki, neꞋe nia lisida ka diꞋia na ngela leꞋa nia ki. Ma kaidaꞋi nia mae, nia dao ana taꞋi talangaꞋi ma akwala faꞋi ngali ana. ");
INSERT INTO kwf_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ma na alaꞋanga Ꞌisi nia fata Ꞌuri ana ngwaefuta nia ki, “Nau ku karangi mae naꞋa, bore ma God ke baꞋa lia suli kamu, ma nia ke baꞋa lafu kamu faꞋasia Ꞌi neꞋe. Ma nia ke baꞋa ngali kamu ka olifaꞋi kamu laꞋu Ꞌuana fanoa ba nia alangaꞋinia ana maꞋa kulu ki sa Abraham, sa Aesak, sa Jakob ka Ꞌuri, nia ke baꞋa kwatea fuakulu.” ");
INSERT INTO kwf_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Sui nia ka kwatea kira ka sasia fata alangaꞋinga ngasi ngasiꞋa fuana. Nia fata Ꞌuri, “Kaumulu ke fata alangaꞋi Ꞌania satana God, kaidaꞋi nia ke baꞋa ngali kaumulu faꞋasia Ꞌi neꞋe, ma kamu ka oli laꞋu Ꞌuana Ꞌi Kenan, kaumulu ke baꞋa ngalia na suliku ki faꞋi kaumulu logo.” Ma kira ka fata alangaꞋi ꞋunaꞋeri neꞋe kira baꞋa sasi nama ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Buri Ꞌana goꞋo sa Josef ka mae, kaidaꞋi nia dao ana taꞋi talangaꞋi ma akwala faꞋi ngali. Ma kira ka sasia na nonina noaꞋa kasi ngwaꞋa, ma kira ka alu leꞋa ana saena faꞋi kisi kaidaꞋi kira tua Ꞌua Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","IsufutaꞋanga sulia sa Jesus na Christ. Nia futa maꞋi ana sa David na ngwae tatalafaꞋa neꞋe nia futa maꞋi ana kwalafa sa Abraham. ");
INSERT INTO kwf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ma na isufutaꞋanga neꞋe, nia talaꞋae maꞋi ana sa Abraham. Na ngela sa Abraham neꞋe sa Aesak, sa Aesak alua sa Jakob, ma sa Jakob ka alua sa Juda faꞋinia ngwaefuta nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma na ngela sa Juda ki neꞋe sa Peres faꞋinia sa Sera. (TeꞋa kera satana Ꞌi Tama.) Ma na ngela sa Peres neꞋe sa Hesron, sa Hesron neꞋe alua sa Ram. ");
INSERT INTO kwf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa Ram ka alua sa Aminadab, sa Aminadab ka alua sa Nason, sa Nason ka alua sa Salmon. ");
INSERT INTO kwf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sa Salmon ka alua sa Boas, ma teꞋa nia satana Ꞌi Rahab. Sa Boas ka alua sa Obed, ma teꞋa nia satana Ꞌi Rut. Sa Obed ka alua sa Jesi. ");
INSERT INTO kwf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sa Jesi neꞋe alua sa David na ngwae tatalafaꞋa Israel. Sa David ka alua sa Solomon, ma teꞋa nia neꞋe Ꞌuruna sa Iuraea. ");
INSERT INTO kwf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa Solomon ka alua sa Rihoboam, sa Rihoboam ka alua sa Abaeja, sa Abaeja ka alua sa Asa. ");
INSERT INTO kwf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sa Asa ka alua sa Jehosafat, sa Jehosafat ka alua sa Joram, sa Joram ka alua sa Iusaea. ");
INSERT INTO kwf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sa Iusaea ka alua sa Jotam, sa Jotam ka alua sa Ehas, sa Ehas ka alua sa Hesikaea. ");
INSERT INTO kwf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sa Hesikaea ka alua sa Manase, sa Manase ka alua sa Emon, sa Emon ka alua sa Josaea. ");
INSERT INTO kwf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sa Josaea ka alua sa Jekonaea faꞋinia na ai burina ki. Kira futa ka sui mala na malimae kira ki ka fiꞋi ngalia ngwae Ꞌi Israel ki Ꞌuana fanoa ꞋaꞋana Ꞌi Babilon. ");
INSERT INTO kwf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ꞋI buri ana na malimae kira ki ka ngalia ngwae Ꞌi Israel ki Ꞌuana Ꞌi Babilon, sa Jekonaea ka fiꞋi alua sa Sialtiel. Ma sa Sialtiel ka alua sa Serababel. ");
INSERT INTO kwf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sa Serababel ka alua sa Abaeud, sa Abaeud ka alua sa Elaeakim, sa Elaeakim ka alua sa Aso. ");
INSERT INTO kwf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sa Aso ka alua sa Sadok, sa Sadok ka alua sa Akim, sa Akim ka alua sa Eliud. ");
INSERT INTO kwf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sa Eliud ka alua sa Elaesa, sa Elaesa ka alua sa Matan, sa Matan ka alua sa Jakob. ");
INSERT INTO kwf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sa Jakob ka alua sa Josef araꞋi Ꞌi Mary teꞋa sa Jesus neꞋe kira saea logo Ꞌani na Christ, osiꞋana niaꞋa neꞋe na ngwae God nia filia fuana tatalafaꞋa Ꞌanga. ");
INSERT INTO kwf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma talaꞋae maꞋi ana sa Abraham leleka ka dao ana sa David na ngwae tatalafaꞋa, akwala ma fai unitaꞋi ngwae. Sui ka talaꞋae maꞋi ana sa David na ngwae tatalafaꞋa leleka maꞋi ka dao ana kaidaꞋi ba malimae kira ki ngalia ngwae Ꞌi Israel ki Ꞌuana Ꞌi Babilon, taꞋi akwala ma fai unitaꞋi ngwae. Ma ka talaꞋae ana kaidaꞋi ngwae Israel ki kira leka Ꞌuana Ꞌi Babilon leleka maꞋi ka dao ana kaidaꞋi sa Jesus na Christ nia futa, taꞋi akwala ma fai unitaꞋi ngwae laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na futalana maꞋi sa Jesus na Christ nia Ꞌuri: KaidaꞋi kira alu fafia Ꞌi Mary na teꞋa sa Jesus fuana sa Josef, ma noaꞋa kera kasi tua fiku Ꞌua, Ꞌi Mary ka saiana nia kulufaꞋa naꞋa sulia na AnoꞋi ru Abu. ");
INSERT INTO kwf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma sa Josef, na ngwae neꞋe kira alu fafia fuana, nia ka manata Ꞌuana ka ilangaꞋinia, osiꞋana niaꞋa na ngwae saga. Bore ma nia Ꞌaila Ꞌani faꞋaꞋekelana Ꞌi maana ngwae ki, ma ka manata Ꞌuana ka ilangaꞋi ago ana. ");
INSERT INTO kwf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bore ma kaidaꞋi nia ka manata goꞋo Ꞌana Ꞌua sulia na ru neꞋeri ki, na Ꞌainsel God ka faꞋataꞋi fuana Ꞌi saena maliu boleꞋa ka Ꞌuri, “Josef Ꞌae, ꞋaeꞋo ngwae ana kwalafa sa David, Ꞌoe kosi maꞋu Ꞌani korelana Ꞌi Mary fuana na Ꞌafe Ꞌoe. DuꞋungana nia kulufaꞋa lala sulia na AnoꞋi ru Abu. ");
INSERT INTO kwf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma nia ke baꞋa faꞋafuta taꞋi ngela ngwane, ma Ꞌoke saea Ꞌani sa Jesus (neꞋe fadalana ‘FaꞋamauri’), sulia nia ke baꞋa faꞋamauria na ngwae nia ki faꞋasia na abula taꞋangaꞋa kira ki.” ");
INSERT INTO kwf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma na ru neꞋe ki ka fuli fasi Ꞌiri ka faꞋamamana ru ba God nia faꞋarongo maꞋi Ꞌani, ana kaidaꞋi ba profet nia fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“TaꞋi sariꞋi abugani ke baꞋa ina ma ka faꞋafuta taꞋi ngela ngwane, ma kira ke saea Ꞌani sa Emanuel.” Ma fadalana sata neꞋeri: “God nia tua faꞋi kia.” ");
INSERT INTO kwf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma kaidaꞋi sa Josef ada naꞋa, nia ka sasi naꞋa sulia ru neꞋeri ki neꞋe Ꞌainsel God saeꞋe fuana. Ma nia ka korea naꞋa Ꞌi Mary. ");
INSERT INTO kwf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bore ma noaꞋa kera Ꞌiri tua fiku Ꞌua leleka ka dao ana kaidaꞋi Ꞌi Mary nia faꞋafuta na ngela ngwane. Ma sa Josef ka faꞋasata Ꞌani sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ana kaidaꞋi neꞋe sa Herod tatalafaꞋa naꞋa, sa Jesus nia futa Ꞌi Betlehem, na fanoa Ꞌi saena na abaꞋi kula Ꞌi Judea. Ma noaꞋa kasi tau goꞋo Ꞌi buri Ꞌana, ti ngwae faꞋasia Ꞌi fanelana sina neꞋe kira saiana na bulubulu ki, kira ka dao maꞋi Ꞌi saena na fanoa doe Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma kira ka saefiloa ngwae ki ma kika Ꞌuri, “ꞋUri ma na ngela ba ke baꞋa tatalafaꞋa fuana Jiu ki, nia futa Ꞌi faꞋi? Kami saiana nia futa Ꞌi neꞋe, osiꞋana kaidaꞋi kaimili tua Ꞌua maꞋi Ꞌi fanelana sina, kami lisia naꞋa faꞋi bulubulu neꞋe faꞋataꞋinia futalana maꞋi, ma kami ka leka maꞋi Ꞌiri mika bobo uruuru, ma mika faꞋa aofia.” ");
INSERT INTO kwf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma na manatana sa Herod na ngwae tatalafaꞋa nia manata Ꞌabera liu kaidaꞋi nia rongo sulia na ru neꞋeri, ma na ngwae Ꞌi Jerusalem ki logo. ");
INSERT INTO kwf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma nia ka ri Ꞌuana na fata abu doe ki, ma na ngwae faꞋamanata ana taki ki, fuana kira ka fiku maꞋi, ma nia ka saefilo Ꞌuri ada, “ꞋUri ma Ꞌi faꞋi neꞋe na Christ baera ke baꞋa futa maꞋi ana?” ");
INSERT INTO kwf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma kira olisia kira ka fata Ꞌuri, “ꞋI Betlehem ba, na fanoa saena abaꞋi kula Ꞌi Judea. OsiꞋana na kerekereꞋa profet ba fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem Ꞌae, na fanoa saena abaꞋi kula Ꞌi Judea, noaꞋa Ꞌoe kosi tiꞋitiꞋi Ꞌi safitana fanoa ꞋinotoꞋa ki Ꞌi Judea, osiꞋana taꞋi ngwae ꞋinotoꞋa ke baꞋa leka maꞋi faꞋasi Ꞌoe, fasi Ꞌiri ke talaꞋia na ngwae nau ki Ꞌi Israel.’” ");
INSERT INTO kwf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma sa Herod ka ri ago maꞋi Ꞌuana na ngwae neꞋe dao maꞋi ki faꞋasia fanelana sina fuana alaꞋanga agoꞋa, Ꞌiri nia ke dao toꞋona kaidaꞋi tae neꞋe kira eta lisia na faꞋi bulubulu baera. ");
INSERT INTO kwf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma nia ka baꞋe kira kwau Ꞌuana Ꞌi Betlehem, ka fata Ꞌuri, “Muke leka, muka lulu ngangata Ꞌuana na ngela neꞋeri. Ma diꞋia kamu ka dao toꞋona, muke faꞋarongo nau maꞋi, fasi Ꞌiri nauꞋa bore nau kui leka fuana faꞋa aofialana.” ");
INSERT INTO kwf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma Ꞌi buri Ꞌana sa Herod nia fata ꞋunaꞋeri ka sui, kira ka leka naꞋa Ꞌada. Ma ana kaidaꞋi kira dao naꞋa kwau sulia na tala, kira ka lisia laꞋu faꞋi bulubulu ba kira eta lilisia logo maꞋi Ꞌi fanelana sina. Kira ka saeleꞋa liu ana kaidaꞋi kira lisia laꞋu. Ma faꞋi bulubulu neꞋeri ka etaeta Ꞌi naꞋo ada leleka ka daudau bolo faꞋinia na kula ba sa Jesus nia teo ana. ");
INSERT INTO kwf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kira ruꞋu Ꞌi luma, ma kira ka lisia na ngela faꞋinia teꞋa nia Ꞌi Mary. Kira ka bobo uruuru kika faꞋa aofia na ngela neꞋeri, ma kira ka Ꞌifingia na ngwaꞋi kira ki, ma kira ka kwatea naꞋa kwateꞋa liulani doe ki fuana: gol, ma na ru neꞋe sasuna moko leꞋa, ma na ngwaingwai moko leꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui kira ka oli naꞋa Ꞌada sulia ta tala matamata Ꞌuana fanoa kira, osiꞋana God nia lui totongaꞋi ada saena maliu boleꞋa, ma ka saea noaꞋa kira kasi oli laꞋu siana sa Herod. ");
INSERT INTO kwf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma Ꞌi buri Ꞌana na ngwae neꞋeri ki kira oli naꞋa Ꞌada Ꞌuana fanoa kira, na Ꞌainsel God ka faꞋataꞋi fuana sa Josef Ꞌi saena na maliu boleꞋa, ma ka fata Ꞌuri, “Josef Ꞌae, Ꞌoke tataꞋe, ko ngalia na ngela neꞋe faꞋinia teꞋa nia, muka tafi Ꞌuana Ꞌi Ejipt, ma kamu ka tua maꞋi Ꞌi neꞋeri leleka ka dao ana kaidaꞋi nau kui saea muke oli laꞋu maꞋi. OsiꞋana sa Herod nia lulu Ꞌuana na ngela neꞋe fasi Ꞌiri ke saungia.” ");
INSERT INTO kwf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma sa Josef ka tataꞋe, ma ka ngalia na ngela faꞋinia teꞋa nia Ꞌi Mary, ma kira ka leka saena rodo neꞋeri Ꞌuana maꞋe fanoa Ꞌi Ejipt. ");
INSERT INTO kwf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma kira tua Ꞌi neꞋeri leleka sa Herod ka mae. Ma na ru neꞋeri ka faꞋamamana naꞋa tae ba God saea fuana na profet ba keresia ka Ꞌuri, “Nau ku ri maꞋi Ꞌuana na ngela nau faꞋasia Ꞌi Ejipt.” ");
INSERT INTO kwf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma kaidaꞋi sa Herod na ngwae tatalafaꞋa ka saiana neꞋe ngwae neꞋeri ki kira leka maꞋi faꞋasia fanelana sina kira Ꞌosoa niaꞋa, na liana ka saetaꞋa liu. Ma nia ka kwatea fatalana fuana ngwae fuani oro nia ki fasi Ꞌiri kike saungia taꞋifau kaela ngela ngwane ki Ꞌi Betlehem ma ana maꞋe fanoa kalikalia ki taꞋifau. Nia falamaada Ꞌiri kike saungia kaela ngela ngwane neꞋe noaꞋa kasi dao Ꞌua ana ro faꞋi ngaliꞋa, diꞋia na alaꞋanga ba na ngwae baera ki sulia kaidaꞋi ba faꞋi bulubulu baera nia eta faꞋataꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ꞋUnaꞋeri na ngwae neꞋe kira tua saena Ꞌi Betlehem, kira ka angi Ꞌuana ngela kira ki neꞋe mae naꞋa. Kira angi ꞋunaꞋeri, diꞋia ba sa Jeremaea na profet nia saea naꞋa maꞋi Ꞌi naꞋo, ");
INSERT INTO kwf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kira rongoa lingaꞋi angiꞋa neꞋeri leka maꞋi faꞋasia na fanoa Ꞌi Rama neꞋe lingaꞋi oꞋomaeꞋa doe. ꞋI Rachel ka angisia ngela tiꞋitiꞋi nia ki. KaidaꞋi nia angi, noaꞋa ta ngwae kasi gwaꞋoa niaꞋa, sulia neꞋe ngela nia ki kira mae taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma Ꞌi buri Ꞌana sa Herod ka mae naꞋa, na Ꞌainsel God ka faꞋataꞋi laꞋu Ꞌi saena maliu boleꞋa fuana sa Josef Ꞌi Ejipt, ");
INSERT INTO kwf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ka fata Ꞌuri, “Josef Ꞌae, tataꞋe, Ꞌoke ngalia naꞋa ngela faꞋinia teꞋa nia Ꞌi Mary, muka oli naꞋa Ꞌuana Ꞌi Israel, osiꞋana ngwae ba kira sasi Ꞌuana saungilana na ngela neꞋe, kira mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma sa Josef ka tataꞋe, ma ka ngalia naꞋa ngela faꞋinia teꞋa nia Ꞌi Mary, ma kira ka oli naꞋa Ꞌuana Ꞌi Israel. ");
INSERT INTO kwf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bore ma kaidaꞋi sa Josef nia rongoa sa Akilas nia tatalafaꞋa didifulia maꞋa nia sa Herod Ꞌi Judea, nia ka maꞋu Ꞌani tuaꞋa Ꞌi neꞋeri. Ma na Ꞌainsel ka saea laꞋu fuana Ꞌi saena na maliu boleꞋa, fasi Ꞌiri kike leka Ꞌuana na abaꞋi kula Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nia neꞋe kira ka tua ana fanoa Ꞌi Nasaret Ꞌi saena abaꞋi kula Ꞌi Galili. Ma ka faꞋamamana naꞋa tae ba na profet ki kira alaꞋa Ꞌuri ana, “Kira ke baꞋa saea Ꞌani na ngwae faꞋasia Ꞌi Nasaret.” ");
INSERT INTO kwf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma bara faꞋi ngali Ꞌi burina, kaidaꞋi sa Jesus nia ꞋaꞋana naꞋa, sa John ngwae ni Siuabu ka dao maꞋi, ma ka etangia naꞋa faꞋamanataꞋanga saena na abaꞋi kula kwasi Ꞌi Judea, ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Muke kakari alifaꞋi faꞋasia na abulaꞋanga taꞋa kamu ki, sulia kaidaꞋi neꞋe God ke gwaungaꞋi fafia na ngwae nia ki karangi dao naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sa John na ngwae ba na profet Aesea nia fata maꞋi sulia, ma ka Ꞌuri, “TaꞋi ngwae ka ri Ꞌi saena na abaꞋi kula kwasi neꞋe noaꞋa kasi bolo faꞋinia ta ngwae ka tua ana. Ma nia ka Ꞌuri, ‘Na Aofia nia ke dao maꞋi! Muke faꞋasaga na tala fuana!’” ");
INSERT INTO kwf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa John ruꞋufia na ifi Ꞌani ifuna kamel, ma ka nikia na foꞋosae nia Ꞌi liꞋitana ana na ꞋuꞋuila buluka. Ma na fanga nia neꞋe siko ki ma na ngingidua kwasi. ");
INSERT INTO kwf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma na ngwae Ꞌoro ki kira ka leka maꞋi siana faꞋasia na fanoa ba Ꞌi Jerusalem, ma na fanoa ki taꞋifau Ꞌi saena abaꞋi kula Ꞌi Judea, ma faꞋasia na fanoa ki taꞋifau karangia na kafo Ꞌi Jodan. ");
INSERT INTO kwf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma kira ka fulangaꞋinia taꞋangaꞋa kira ki, ma nia ka siuabu kira Ꞌi saena kafo Ꞌi Jodan. ");
INSERT INTO kwf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma kaidaꞋi sa John ka lisia na ngwae Ꞌoro ana Farasi ki ma na Sadusi ki kira leka logo maꞋi siana fasi Ꞌiri nia ka siuabu kira, nia ka fata Ꞌuri fuada, “Kamu diꞋia goꞋo ꞋamuꞋa kaela baꞋeko tolo ki! NoaꞋa nau ku Ꞌiri saea laꞋu fuamuꞋa neꞋe na siuabuꞋanga ke faꞋatafi kamu faꞋasia na kwaꞋikwaꞋinga God, sui bore Ꞌana noaꞋa kamu kasi kakari alifaꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Muke sasia lala ru neꞋe nia faꞋataꞋinia kamu kakari alifaꞋi naꞋa faꞋasia na abula taꞋangaꞋa kamu ki. ");
INSERT INTO kwf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma noaꞋa kamu kasi manata Ꞌuri Ꞌi saena liamuꞋa, ‘KamiꞋa na ngwae neꞋe kami futa naꞋa maꞋi ana kwalafa sa Abraham. ꞋAfitaꞋi ta kwaꞋikwaꞋinga faꞋasia God ka dao amiꞋa.’ Ma nau ku sae saga ana fuamuꞋa, nia talangwaraꞋu goꞋo Ꞌana fuana God ka ngalia ti gwaꞋi fau ana fau neꞋe ki, ma ka saungaꞋinia Ꞌani kwalafa sa Abraham ki! ");
INSERT INTO kwf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ana kaidaꞋi neꞋe, God sasi akaꞋu naꞋa ana kwaꞋikwaꞋinga, diꞋia ta ngwae ba nia dau ana kwaꞋikwaꞋi, ma ka sasi akaꞋu fuana na tufulana Ꞌai ki. Ma na Ꞌai ki taꞋifau neꞋe noaꞋa kasi fungu Ꞌani ta fuaꞋi ai leꞋa ki, nia ke tufuda ma ka toꞋosida Ꞌi saena mafula. ");
INSERT INTO kwf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nau ku siuabu kamu Ꞌani kafo fasi Ꞌiri ka faꞋataꞋinia neꞋe kamu kakari alifaꞋi naꞋa faꞋasia na abulaꞋanga taꞋa kamu ki. Bore ma taꞋi ngwae neꞋe ke leka maꞋi buriku, nia ke baꞋa siuabu kamu Ꞌani na AnoꞋi ru Abu ma na mafula. Ma nia talingaꞋi ka liufi nau, ma nau noaꞋa naisi leꞋa ka bolo faꞋinia naꞋa ngalilana na taꞋe butu nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma nia sasi akaꞋu naꞋa fuana matalangaꞋilana ngwae ki taꞋifau, ka diꞋia ta ngwae ba nia efoa na maga ru leꞋa ki faꞋasia na taꞋetaꞋeru ki. Ma nia ka fikua na maga ru leꞋa ki Ꞌi saena luma ni goniruꞋa. Ma nia ka doꞋofia naꞋa taꞋetaꞋeru ki Ꞌi saena na mafula neꞋe duꞋaduꞋa kasi mae.” ");
INSERT INTO kwf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ana kaidaꞋi neꞋeri, sa Jesus ka leka maꞋi faꞋasia abaꞋi kula Ꞌi Galili Ꞌuana kafo Ꞌi Jodan siana sa John fasi Ꞌiri sa John ke siuabu nia. ");
INSERT INTO kwf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bore ma sa John ka ili Ꞌuana na rokisilana na manatana sa Jesus, ka Ꞌuri, “Nia bolo faꞋinia ꞋaeꞋo neꞋe Ꞌoke siuabu nau, ma Ꞌoko leka lala maꞋi siaku fuana nau kui siuabu Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma sa Jesus ka olisia ka fata Ꞌuri, “Sui bore Ꞌana ka ꞋunaꞋeri, Ꞌoke sasi naꞋa maꞋi Ꞌamu ta ru fuaku, osiꞋana sasilana na ru neꞋe, koro sasi naꞋa ru ki taꞋifau neꞋe God nia oga.” Ma sa John ka ala naꞋa fafia. ");
INSERT INTO kwf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma ana kaidaꞋi sa Jesus siuabu ka sui naꞋa, nia ka tataꞋe maꞋi faꞋasia kafo. Ma Ꞌi langi ka Ꞌifi fuana, ma nia ka lisia na AnoꞋi ru Abu God ka koso maꞋi diꞋia ta bola, ma ka toꞋo Ꞌi fafona. ");
INSERT INTO kwf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma taꞋi lingalinga Ꞌi ru nia talo maꞋi faꞋasia Ꞌi langi ma ka Ꞌuri, “Nia naꞋa neꞋe ngela mutaꞋi nau neꞋe nau ku alafe liu ana, ma nau ku saeleꞋa liu faꞋinia.” ");
INSERT INTO kwf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma Ꞌi buri Ꞌana na ru neꞋe, na AnoꞋi ru Abu ka talaꞋia sa Jesus Ꞌuana abaꞋi kula kwasi fasi Ꞌiri sa Saetan ke ilitoꞋona. ");
INSERT INTO kwf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma sa Jesus ka abu fanga sulia fai akwala faꞋi asoa ki, ma fai akwala faꞋi rodo ki, ma nia ka fiolo liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ꞋUnaꞋeri, sa Saetan ka leka maꞋi siana, ka fata Ꞌuri, “OsiꞋana neꞋe ꞋaeꞋo na Ngela God, Ꞌoke fata fuana gwaꞋi fau neꞋe ki Ꞌiri ke alua ta beret.” ");
INSERT INTO kwf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma sa Jesus ka olisia ka Ꞌuri, “Na KerekereꞋa Abu ba saea, ‘Na ngwae noaꞋa kasi mauri goꞋo ana fanga taꞋifilia. Bore ma, nia mauri naꞋa Ꞌani alaꞋanga ki taꞋifau neꞋe saka maꞋi faꞋasia God.’” ");
INSERT INTO kwf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui sa Saetan ka talaꞋi laꞋu sa Jesus Ꞌuana na fanoa abu Ꞌi Jerusalem, ma nia ka faꞋauua ana taꞋi kula neꞋe nia raꞋe liu Ꞌi langi, fafona na Luma Abu God. ");
INSERT INTO kwf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ka fata Ꞌuri fuana, “OsiꞋana ꞋaeꞋo na Ngela God, Ꞌoke lofo toli Ꞌi ano faꞋasia Ꞌi neꞋe, sulia na KerekereꞋa Abu ba fata Ꞌuri, ‘God ke kwatea maꞋi na Ꞌainsel nia ki fuamu, ma kike sakuꞋu, fasi Ꞌiri na Ꞌaemu bore kasi foto ana ta gwaꞋi fau.’” ");
INSERT INTO kwf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma sa Jesus ka olisia ka Ꞌuri, “Ma na KerekereꞋa Abu ba fata logo Ꞌuri, ‘NoaꞋa Ꞌoe kosi ilitoꞋona God Ꞌoe.’” ");
INSERT INTO kwf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui sa Saetan ka talaꞋia laꞋu sa Jesus Ꞌuana gwauna totoloa fane liu neꞋeri, ma ka faꞋataꞋinia na ꞋinotoꞋanga ki taꞋifau ana magalia ma na kwangaꞋa kira ki fuana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma sa Saetan ka fata Ꞌuri, “Na ru neꞋe ki taꞋifau goꞋo nau ku kwateda fuamu, diꞋia Ꞌoko bobo uruuru Ꞌi maana Ꞌaeku, ma Ꞌoko faꞋa aofia nau.” ");
INSERT INTO kwf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma sa Jesus ka olisia ka Ꞌuri, “Saetan Ꞌae, Ꞌoke leka tau kwau faꞋasi nau! Sulia na KerekereꞋa Abu ba saea, ‘TaꞋifilia God Ꞌoe goꞋo neꞋe Ꞌoke faꞋa aofia, ma Ꞌoko rao fuana.’” ");
INSERT INTO kwf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sui ana kaidaꞋi neꞋeri, sa Saetan ka leka naꞋa faꞋasia sa Jesus. Ma na Ꞌainsel ki kira ka leka maꞋi, ma kika kwaiꞋafi naꞋa ana niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","KaidaꞋi sa Jesus rongoa neꞋe kira alua naꞋa sa John saena na luma ni lokafo, nia ka oli Ꞌuana abaꞋi kula Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma nia kasi tua saena fanoa nia Ꞌi Nasaret. Nia ka leka, ka tua lala Ꞌana Ꞌi Kapaneam, na fanoa Ꞌi ninimana na Ꞌosi Ꞌi Galili, ana na abaꞋi kula Ꞌi Sebulun ma Ꞌi Naftali. ");
INSERT INTO kwf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nia sasi ꞋunaꞋeri fasi Ꞌiri ka faꞋamamana na fatalana profet Aesea ba Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na fanoa Ꞌi Sebulun ma na fanoa Ꞌi Naftali, kira tua saena abaꞋi kula Ꞌi Galili, ma kira tua sulia tala Ꞌuana Ꞌosi doe, ma ka tua taꞋi bali ana kafo Ꞌi Jodan, kula neꞋe ngwae noaꞋa laꞋu Jiu ki kira tua ana. ");
INSERT INTO kwf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na ngwae neꞋeri ki, kira tua saena na maꞋerodo, kike baꞋa lisia madakoꞋanga doe. Ma sa tai faꞋida neꞋe kira tua saena fanoa rorodoꞋa ana maeꞋa neꞋe, madakoꞋanga ka tala Ꞌafi kira.” ");
INSERT INTO kwf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ꞋIta ana kaidaꞋi neꞋeri, sa Jesus ka faꞋarongo Ꞌani faꞋarongoꞋa nia ka Ꞌuri, “Muke kakari alifaꞋi faꞋasia na abulaꞋanga taꞋa kamu ki, sulia kaidaꞋi God ke gwaungaꞋi fafia ngwae nia ki nia dao karangi kamu naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ana kaidaꞋi sa Jesus liu sulia na Ꞌosi Ꞌi Galili, nia ka lisia sa Simon (neꞋe nia saea logo Ꞌani sa Peter) faꞋinia sa Andrew na ngwaefuta nia. KeroꞋa ro ngwae dee ki. KeroꞋa dee adaroꞋo Ꞌani furai kera saena Ꞌosi Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “Moro leka maꞋi faꞋinau, koroꞋo ro ngwae dee iꞋa ki, bore ma nai baꞋa faꞋamanata koroꞋo Ꞌani ngali ngwaeꞋa maꞋi fuaku.” ");
INSERT INTO kwf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma kaidaꞋi neꞋeri nama goꞋo, kera ka faꞋasia naꞋa na furai keroꞋa ki, ma kera ka leka naꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui sa Jesus ka leka laꞋu kwau, ma ka lisia laꞋu ta ro ngwae, sa James ma sa John na ro ngela sa Sebedi ki. Kera tua adaroꞋo Ꞌi saena na gwaꞋi baru faꞋinia maꞋa kera sa Sebedi, ma kira subungia furai kira ki. Sa Jesus ka saedaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma ana kaidaꞋi neꞋeri goꞋo, kera ka faꞋasia naꞋa adaroꞋo na gwaꞋi baru faꞋinia na maꞋa kera, ma kera ka leka naꞋa faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sa Jesus ka liufia naꞋa fanoa ki Ꞌi saena abaꞋi kula Ꞌi Galili, ma ka faꞋamanata na ngwae ki saena na luma fuana foꞋongaꞋa Jiu ki. Ma nia ka faꞋarongo Ꞌani na FaꞋarongoꞋa LeꞋa sulia na GwaungaꞋi Ꞌanga God, ma ka gura na ngwae neꞋe kira mataꞋi Ꞌani mataꞋinga matamata ki taꞋifau neꞋe saungida. ");
INSERT INTO kwf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma na alaꞋanga ki sulia sa Jesus ka talofia fanoa ki taꞋifau Ꞌi saena abaꞋi kula Ꞌi Siria. Ma ngwae Ꞌoro ki neꞋe kira mataꞋi Ꞌani mataꞋinga matamata Ꞌoro ki, kira ka ngalida maꞋi siana. Na ngwae neꞋe nonida fii liu, ma ngwae neꞋe anoꞋi ru taꞋa ki ka kwaiꞋida, ma na ngwae neꞋe baꞋasi saungida ki, ma ngwae neꞋe Ꞌaeda ka mae, kira leka maꞋi siana. Ma sa Jesus ka gurada taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma na ngwae Ꞌoro liu ki logo, kira ka leka sulia sa Jesus ana kaidaꞋi neꞋeri. Ngwae faꞋasia abaꞋi kula Ꞌi Galili, ma fanoa Ꞌi Jerusalem, ma ti fanoa laꞋu saena abaꞋi kula Ꞌi Judea, ma ana abaꞋi kula Ꞌi Dekapolis, ma faꞋasia na bali kafo Ꞌi Jodan raꞋe lana sina. ");
INSERT INTO kwf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ma ana kaidaꞋi neꞋe sa Jesus nia lisia naꞋa fikuꞋa doe neꞋeri, nia ka raꞋe Ꞌi gwauna na kula neꞋe taꞋi fane, ma ka tua Ꞌi ano. Ma na fafarongo nia ki kira ka fiku kalia, ");
INSERT INTO kwf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma nia ka talaꞋae naꞋa ana faꞋamanatalada, ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“SaesaeleꞋanga fuada ngwae neꞋe kira saiana kira dalaꞋa Ꞌi maana God, osiꞋana neꞋe kira ka toꞋo naꞋa ana ru leꞋa ki, kaidaꞋi God ka gwaungaꞋi fafi kira. ");
INSERT INTO kwf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","SaesaeleꞋanga fuada ngwae neꞋe kira kwaimanatai ki, osiꞋana God ke baꞋa gwaleda. ");
INSERT INTO kwf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","SaesaeleꞋanga fuada ngwae neꞋe kira faꞋatiꞋitiꞋi kira talada ki, osiꞋana God ke baꞋa kwatea na magalia neꞋe fuada. ");
INSERT INTO kwf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","SaesaeleꞋanga fuada ngwae neꞋe kira oga liua sasilana ru ꞋoloꞋolo ki, osiꞋana God ke baꞋa faꞋatolia maurilada. ");
INSERT INTO kwf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","SaesaeleꞋanga fuada ngwae neꞋe manatada ofia ngwae matamata ki, osiꞋana God ke baꞋa ofida logo. ");
INSERT INTO kwf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","SaesaeleꞋanga fuada ngwae neꞋe liada sakadola fuana God, osiꞋana kira ke baꞋa lisia God. ");
INSERT INTO kwf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","SaesaeleꞋanga fuada ngwae neꞋe kira rao fuana na aroaroꞋa Ꞌi safitana ngwae ki, osiꞋana God ke baꞋa sae kira Ꞌani na ngela nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","SaesaeleꞋanga fuada ngwae neꞋe kira faꞋakaisida duꞋungana sasilana ru saga ki, osiꞋana neꞋe kira toꞋo naꞋa ana ru leꞋa ki, kaidaꞋi God ka gwaungaꞋi fafi kira. ");
INSERT INTO kwf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“SaesaeleꞋanga fuamuꞋa kaidaꞋi neꞋe ngwae ki kira ka fata buri amuꞋa, ma kira ka faꞋakaisi kamu, ma kira ka saea ru taꞋa Ꞌoro ki amuꞋa osiꞋana kamuꞋa naꞋa neꞋe fafarongo nau ki. ");
INSERT INTO kwf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nau ku saea ru neꞋeri osiꞋana kike baꞋa sasia logo ru taꞋa ki fuamuꞋa neꞋe ngwae ki kira sasi ana profet ki maꞋi Ꞌi naꞋo. Muke saeleꞋa amuꞋa, osiꞋana God ke baꞋa kwatea kwaiaraꞋanga doe neꞋe nia gonia fuamuꞋa Ꞌi langi.” ");
INSERT INTO kwf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sa Jesus inaꞋu ana fatalana ka Ꞌuri, “Na fiki asi neꞋe faꞋaleꞋa na fanga fuamuꞋa. Ma kamu logo muke diꞋia na fiki asi fuana faꞋaleꞋalana na ngwae ki taꞋifau. Bore ma diꞋia neꞋe asilalana nia leka faꞋasia, nia ꞋafitaꞋi liu Ꞌoko faꞋa asila laꞋu. Ma noaꞋa kasi leꞋa naꞋa fuana sasilana laꞋu Ꞌani ta ru, ma nia leꞋa fuana muke Ꞌui naꞋa amuꞋa Ꞌani Ꞌi maa, fasi Ꞌiri na ngwae ki kike uria naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kaumulu diꞋia logo na faꞋi unu fuana na ngwae ki taꞋifau saena magalia. Na luma neꞋe kira saungaꞋinia Ꞌi gwauna faꞋi ua nia ꞋafitaꞋi ka ago. ");
INSERT INTO kwf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma noaꞋa ta ngwae kasi faꞋaduꞋa na faꞋi unu, sui ka alua Ꞌana Ꞌi olofana na dako. KaidaꞋi nia faꞋaduꞋa faꞋi unu ka sui mala, nia ka ngalia, ka dauraꞋinia ana kula Ꞌi langi, fasi Ꞌiri ka rara fuana na ngwae ki taꞋifau Ꞌi saena na luma. ");
INSERT INTO kwf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ka ꞋunaꞋeri logo, na faꞋi unu kamu ka sina kwau Ꞌi naꞋo ana ngwae ki taꞋifau, fasi Ꞌiri ana kaidaꞋi kira lisia na ru leꞋa neꞋe kamu sasiꞋi ki, kika fiꞋi baꞋatafea na MaꞋa kamu neꞋe nia tua maꞋi Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“NoaꞋa kamu kasi fia fasi nau ku leka maꞋi fuana na faꞋasuilana na taki sa Moses ki ma na faꞋamanataꞋanga na profet ki. Nau kusi leka laꞋu maꞋi fuana na faꞋasuilada, bore ma nau ku leka lala maꞋi fuana na faꞋa aliꞋafulana na faꞋamanataꞋanga kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nau ku saea ru mamana fuamuꞋa, ana kaidaꞋi neꞋe Ꞌi langi ma na magalia kira teo Ꞌua, noaꞋa ta ru tiꞋitiꞋi ana na taki ki kasi sui leleka ka dao ana ta kaidaꞋi neꞋe ru ki taꞋifau ana na taki ki ke dao mamana. ");
INSERT INTO kwf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nia neꞋe, sa tai bore Ꞌana neꞋe noaꞋa kasi roꞋosulia ta taki tiꞋitiꞋi, ma ka faꞋamanata ti ngwae fuana Ꞌaila Ꞌanga ana ta taki tiꞋitiꞋi logo, God ke baꞋa alu nia ka ꞋisiꞋisi ana na ꞋInotoꞋanga nia. Bore ma sa tai neꞋe ka roꞋosulia na taki ki ma ka faꞋamanata ti ngwae fuana roꞋosulilana diꞋia niaꞋa, God ke baꞋa alu nia ke ꞋaꞋana Ꞌi saena na ꞋInotoꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nau ku saea fuamuꞋa, diꞋia noaꞋa kamu kasi sasi leꞋa ka liufia na ngwae faꞋamanata ana taki ki, ma na Farasi ki ana sasiꞋa sulia ru neꞋe God nia oga, nia ꞋafitaꞋi liu muke tua faꞋinia ngwae neꞋe God ke gwaungaꞋi fafida ki. ");
INSERT INTO kwf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kaumulu rongoa taꞋifau naꞋa na fataꞋa totongaꞋi neꞋe kira saea fuana koꞋo bora kia ki Ꞌi naꞋo ba Ꞌuri, ‘NoaꞋa Ꞌoe kosi sau ngwae. DiꞋia sa tai bore Ꞌana neꞋe ka sau ngwae, kike baꞋa ngali nia Ꞌi naꞋona na ngwae kwaigiosi ki.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bore ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, sa tai neꞋe ka saetaꞋa fuana na ngwaefuta nia, kike baꞋa ngali nia Ꞌi naꞋona na ngwae ni kwaigiosi ki. Ma sa tai neꞋe ka saea fuana na ngwaefuta nia, ‘ꞋAeꞋo na ru ꞋoꞋo goꞋo Ꞌana,’ kike baꞋa ngalia Ꞌi naꞋona na ngwae ni kwaigiosi ki. Ma sa tai neꞋe ka saea na ngwaefuta nia Ꞌani, ‘Na ru boleboleꞋa,’ nia ke baꞋa leka saena tala Ꞌuana na mafula neꞋe duꞋaduꞋa noaꞋa kasi mae. ");
INSERT INTO kwf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ta neꞋe, diꞋia Ꞌoko sasi akaꞋu naꞋa ana kwai suꞋusiꞋanga Ꞌoe fuana God fafona na fuli fuꞋa, ma Ꞌoko manata toꞋona noaꞋa kasi madako Ꞌua Ꞌi safitamuroꞋo toꞋolamu sulia na roraꞋa Ꞌoe, ");
INSERT INTO kwf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ꞌoke faꞋasia basi kwai suꞋusiꞋa Ꞌoe Ꞌi maana fuli fuꞋa, sui Ꞌoko oli, ma Ꞌoko fata kwaima basi faꞋinia. Sui Ꞌi buri, Ꞌoko oli maꞋi, ma ko fiꞋi kwate na kwai suꞋusiꞋanga Ꞌoe fuana God. ");
INSERT INTO kwf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma diꞋia ta ngwae ka ngali Ꞌoe fuana kwai matalangaꞋinga, Ꞌoko fata kwaima basi faꞋinia, kaidaꞋi noaꞋa koroꞋo kasi dao Ꞌua. Si diꞋia koroꞋo dao naꞋa, nia ke baꞋa kwate Ꞌoe naꞋa fuana na ngwae kwaigiosi, ma Ꞌi buri Ꞌana nia ka matalangaꞋi Ꞌoe, nia ka fiꞋi kwate Ꞌoe laꞋu fuana ngwae firi ngwae ki, ma na ngwae firi ngwae ki ka fiꞋi alu Ꞌoe laꞋu saena lokafo. ");
INSERT INTO kwf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nau ku saea fuamu, diꞋia nia ꞋunaꞋeri, nia ꞋafitaꞋi Ꞌoko ruꞋu faꞋasia na lokafo leleka Ꞌoko kwatea nama na mani Ꞌisi Ꞌoe neꞋe nia bolo faꞋinia kwaꞋikwaꞋinga Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kamu rongoa taꞋifau naꞋa na fataꞋa totongaꞋi ki kira saea, ‘NoaꞋa Ꞌoe kosi kakabara.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, sa tai bore Ꞌana neꞋe bubungia ta kini Ꞌani lia Ꞌi ngwae ni kakabaraꞋanga, nia kakabara ka sui naꞋa Ꞌani liana. ");
INSERT INTO kwf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nia neꞋe, diꞋia Ꞌoko oga Ꞌoke fulia ta ru taꞋa Ꞌani bali maa ꞋoloꞋolo Ꞌoe, Ꞌoko lafua, ma Ꞌoko Ꞌui Ꞌania faꞋasi Ꞌoe. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko Ꞌui Ꞌania ta bali ana na nonimu, Ꞌasu Ꞌubani God ka fiꞋi Ꞌui Ꞌania na nonimu taꞋifau Ꞌi saena na mafula ana kula ni maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma diꞋia Ꞌoko oga Ꞌoke fulia ta ru taꞋa Ꞌani bali lima ꞋoloꞋolo Ꞌoe, Ꞌoke siki muusia ma Ꞌoko Ꞌui Ꞌania faꞋasi Ꞌoe. Nia taꞋi leꞋa goꞋo Ꞌana diꞋia Ꞌoko Ꞌui Ꞌania ta bali ana nonimu, Ꞌasu Ꞌubani God ka fiꞋi Ꞌui Ꞌania na nonimu taꞋifau Ꞌi saena na mafula ana kula ni maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kamu rongoa taꞋifau naꞋa na fataꞋa totongaꞋi ki kira saea, ‘Sa tai bore Ꞌana neꞋe ilangani na Ꞌafe nia, nia ka kwatea kerekereꞋa ana kwai ilangaꞋinga fuana.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bore ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, noaꞋa ta ngwae kasi ilangani na Ꞌafe nia. DiꞋia ngwae ilangani Ꞌafe nia, niaꞋa neꞋe kwatea Ꞌafe nia ka kakabara. Ma diꞋia ta ngwae ka korea laꞋu na kini neꞋeri, na ngwae neꞋeri nia kakabara logo Ꞌi naꞋona God. TaꞋi ru goꞋo neꞋe ngwae saiana ka ilangaꞋinia na Ꞌafe nia duꞋungana, diꞋia nia kakabara ana ta ngwae matamata. ");
INSERT INTO kwf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kamu rongoa logo na fataꞋa totongaꞋi ki kira saea fuana na ngwae ki Ꞌi naꞋo Ꞌua naꞋa maꞋi, ‘DiꞋia Ꞌoko faꞋangasingasia alangaꞋinga Ꞌoe Ꞌani satana God, tama noaꞋa Ꞌoe kosi Ꞌoia naꞋa alangaꞋinga Ꞌoe.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, noaꞋa Ꞌoe kosi faꞋangasia alangaꞋinga Ꞌoe Ꞌani ta ru. Ma noaꞋa Ꞌoe kosi faꞋangasia alangaꞋinga Ꞌoe Ꞌani Ꞌi langi, osiꞋana God nia gwaungaꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma Ꞌoe kosi faꞋangasia alangaꞋinga Ꞌoe Ꞌani magalia, osiꞋana God nia gwaungaꞋi logo Ꞌi neꞋeri. Ma Ꞌoe kosi faꞋangasia alangaꞋinga Ꞌoe Ꞌani Ꞌi Jerusalem, sulia nia neꞋe fanoa na ngwae tatalafaꞋa doe ka tasa. ");
INSERT INTO kwf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma noaꞋa Ꞌoe kosi faꞋangasia alangaꞋinga Ꞌoe Ꞌani gwaumu, sulia nia ꞋafitaꞋi Ꞌoko saungaꞋinia taꞋi ifu Ꞌi gwaumu ka kwao nama ka goa. ");
INSERT INTO kwf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","DiꞋia Ꞌoko alangaꞋi, saea goꞋo, ‘ꞋIu.’ Nama diꞋia Ꞌoe kosi alangaꞋi, saea goꞋo ‘NoaꞋa.’ Ma diꞋia Ꞌoko saea laꞋu ta ru, na ru neꞋeri nia leka naꞋa maꞋi faꞋasia sa Saetan na ngwae taꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sa Jesus alaꞋa laꞋu ka fata Ꞌuri, “Kamu rongoa taꞋifau naꞋa na fataꞋa totongaꞋi ki fata Ꞌuri, ‘DiꞋia ta ngwae ka faꞋalia na maana ta ngwae, kike faꞋalia logo maana ngwae neꞋeri. Ma gwaꞋi lifa logo fuana duꞋulana ta gwaꞋi lifa.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bore ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, noaꞋa Ꞌoe kosi duꞋua ta ru neꞋe ta ngwae sasia ka taꞋa fuamu. DiꞋia ta ngwae ka fidalia na bali sate ꞋoloꞋolo Ꞌoe, Ꞌoko alaꞋania nia ka fidalia laꞋu ta bali sate mauli amu. ");
INSERT INTO kwf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma diꞋia ta ngwae ka ngali Ꞌoe Ꞌuana na matalangaꞋinga fuana ngalilana na toꞋongi fafo doe Ꞌoe, Ꞌoke alaꞋania nia ke ngalia logo na toꞋongi sae Ꞌoe fuana. ");
INSERT INTO kwf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma diꞋia ta ngwae ka suꞋumaꞋinia Ꞌoko ngalia na Ꞌoko ru nia sulia taꞋi kadi tala, Ꞌoko ngalia laꞋu sulia ruana kadi tala. ");
INSERT INTO kwf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma Ꞌoke kwatea fuana ta ngwae neꞋe nia ke gania ta ru amu. Ma kaidaꞋi ta ngwae ka oga na ngali langalana ta ru amu, Ꞌoko kwatelanga ana fuana. ");
INSERT INTO kwf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kamu rongoa taꞋifau naꞋa na fataꞋa totongaꞋi ki fata Ꞌuri, ‘Muke alafe ꞋamuꞋa fuana na ngwae kwaima kamu ki, ma muke suulangaꞋinia na malimae kamu ki.’ ");
INSERT INTO kwf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bore ma kaidaꞋi neꞋe, nau ku saea fuamuꞋa, muke alafe fuada na malimae kamu ki, ma muke foꞋo fuada sa tai neꞋe kira faꞋakaisi kamu. ");
INSERT INTO kwf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","DiꞋia kamu sasi ꞋunaꞋeri, muke alu naꞋa na ngela na MaꞋa kamu maꞋi Ꞌi langi. Sulia nia saungaꞋinia na sina, ma ka rara Ꞌafia na ngwae taꞋa ki, ma na ngwae leꞋa ki taꞋifau goꞋo, ma ka kwatea na uta fuada sa tai faꞋida neꞋe kira fulia ru leꞋa ki, ma fuana sa tai faꞋida neꞋe kira fulia ru taꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","DiꞋia muke alafe goꞋo amuꞋa fuana na ngwae neꞋe kira alafe fuamuꞋa, God noaꞋa kasi kwaiara kamu goꞋo. OsiꞋana na ngwae Ꞌaurafu ni goni maniꞋa ana takisi bore, kira sasia logo ru neꞋeri! ");
INSERT INTO kwf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma diꞋia kamu fata leꞋa goꞋo ꞋamuꞋa faꞋinia na kwaima kamu ki, noaꞋa kamu kasi matamata goꞋo faꞋasia na ngwae ki taꞋifau. Sulia na ngwae kira kina God ki bore, kira sasia logo ru neꞋeri! ");
INSERT INTO kwf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Muke saga taꞋifau naꞋa, diꞋia na MaꞋa kamu Ꞌi langi ba saga taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma sa Jesus ka fata laꞋu Ꞌuri, “Muke madafi kamu, Ꞌasu Ꞌubani muke sasia goꞋo amuꞋa na ru leꞋa kamu ki, fasi Ꞌiri ngwae ki kike lisia, ma kika auraꞋe kamu faꞋiniꞋi. DiꞋia kamu sasi ꞋunaꞋeri, noaꞋa kamu kasi ngalia ta kwaiaraꞋa faꞋasia na MaꞋa kamu maꞋi langi. ");
INSERT INTO kwf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","DiꞋia Ꞌoko kwatea na kwateꞋa fuana Ꞌafilana ngwae dalaꞋa ki, noaꞋa Ꞌoe kosi faꞋafulangaꞋinia fuana ngwae ki fasi Ꞌiri kike baꞋatafe Ꞌoe fafiꞋi. Sulia na falafala neꞋeri, ngwae kwalabasa ki kira sasi. Kira kwaiꞋafi ana ngwae dalaꞋa ki saena luma fuana foꞋongaꞋa ki ma sulia na tala doe ki logo, fasi Ꞌiri ngwae ki taꞋifau kira ka baꞋatafeda. Ma nau ku saea fuamuꞋa, God noaꞋa kasi kwatea ta kwaiaraꞋa fuada, sulia kira ngalia naꞋa na kwaiaraꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma kaidaꞋi Ꞌoko kwatea ta ru fuana kwaiꞋafiꞋanga, noaꞋa Ꞌoe kosi faꞋataꞋinia fuana ta ngwae, fasi Ꞌiri ta kwaima amu bore noaꞋa kasi saiana. ");
INSERT INTO kwf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","KaidaꞋi Ꞌoko kwatea ta ru fuana ta ngwae, Ꞌoke sofongaꞋinia faꞋasia ta ngwae bore Ꞌana noaꞋa kasi lisia nama ka saiana. Sui bore Ꞌana Ꞌoko kwate ago ana, na MaꞋa Ꞌoe neꞋe nia tua maꞋi langi, nia ka lisia tae ki neꞋe Ꞌoko sasia, ma nia ka kwatea kwaiaraꞋa fuamu.” ");
INSERT INTO kwf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sa Jesus ka fata laꞋu Ꞌuri, “KaidaꞋi kamu foꞋo, noaꞋa kamu kasi diꞋia ngwae kwalabasa neꞋe kira foꞋo goꞋo Ꞌada fasi Ꞌiri neꞋe ngwae ki ka lisida. Sulia ana kaidaꞋi kira foꞋo, kira oga liu uuꞋa saena luma fuana foꞋongaꞋa ki, nama sulia tala doe ki, fasi Ꞌiri neꞋe ngwae ki kira ka lisida, ma kika auraꞋeda. Ma nau ku saea fuamuꞋa, kira ngalia naꞋa na kwaiaraꞋa kira ki faꞋasia na ngwae neꞋe kira auraꞋeda ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma ana kaidaꞋi Ꞌoko foꞋo, Ꞌoke leka ana ta kula neꞋe tua banitaꞋi, ma Ꞌoko tua Ꞌi neꞋeri, ma Ꞌoko foꞋosia God, ma noaꞋa ta ngwae kasi lisia. Sui bore Ꞌana noaꞋa ta ngwae kasi lisi Ꞌoe ana kaidaꞋi Ꞌoko foꞋo, MaꞋa Ꞌoe neꞋe tua maꞋi Ꞌi langi neꞋe ke baꞋa lisiꞋo. Ma nia logo neꞋe ke baꞋa kwaiara Ꞌoe fuana tae ki neꞋe Ꞌoko sasiꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ana kaidaꞋi kamu foꞋo, noaꞋa kamu kasi diꞋia laꞋu ngwae neꞋe kina God ki. Sulia ana kaidaꞋi kira foꞋo, kira fata keta liu, ma noaꞋa kira kasi sai madako ana na tae ki neꞋe kira saeꞋe. Manatada fia diꞋia kira foꞋo keta ꞋunaꞋeri, God ke baꞋa rongoda. ");
INSERT INTO kwf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma noaꞋa kamu kasi sasi laꞋu diꞋida, sulia MaꞋa kamu maꞋi Ꞌi langi nia saiana taꞋifau naꞋa tae ki neꞋe kamu boꞋoboꞋo Ꞌuana, sui mala kamu fiꞋi gania. ");
INSERT INTO kwf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“ꞋIu, ana kaidaꞋi kamu foꞋo, muke fata Ꞌuri, ‘MaꞋa kami Ꞌi langi Ꞌae, Kami oga ngwae ki taꞋifau kike faꞋadoea satamu, osiꞋana nia abu liu. ");
INSERT INTO kwf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dao maꞋi Ꞌani gwaungaꞋi Ꞌanga Ꞌoe fafia maurilana ngwae ki taꞋifau. Ma na kwaiogaiꞋanga Ꞌoe kike sasia naꞋa Ꞌi ano diꞋia logo Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞋOke kwatea maꞋi fuamiꞋa na fanga neꞋe bolo fuana asoa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞋOke rufuanata ana taꞋangaꞋa kami ki, diꞋia logo neꞋe kami rufuanata ana taꞋangaꞋa ngwae ki taꞋifau neꞋe kira fulia ru taꞋa ki amiꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ꞋOe kosi danga Ꞌani kami fuana ilitoꞋonga ka liufi kami. Ma Ꞌoko olitaꞋi kami faꞋasia sa Saetan.’ ");
INSERT INTO kwf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aia, ma diꞋia kamu rufuanata ana sa tai neꞋe fulia ru taꞋa amuꞋa, MaꞋa kamu maꞋi Ꞌi langi nia ka rufuanata logo ana taꞋangaꞋa kamu ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma diꞋia kamu kasi rufuanata ana sa tai neꞋe nia fulia ru taꞋa amuꞋa, MaꞋa kamu maꞋi Ꞌi langi bore noaꞋa kasi rufuanata logo amuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sa Jesus ka fata laꞋu Ꞌuri, “Ana kaidaꞋi kamu abu fanga fuana foꞋongaꞋa ngasingasiꞋa, noaꞋa kamu kasi diꞋia ngwae kwalabasa ki. Sulia ana kaidaꞋi kira abu fanga, kira lia diꞋia ngwae kira kwaimanatai fasi Ꞌiri neꞋe ngwae ki ka lisi neꞋe kira abu fanga, ma kika fataleꞋa ada. Aia, ma nau ku saea fuamuꞋa, na ngwae neꞋe ki ꞋafitaꞋi kira ka ngalia ta kwaiaraꞋa laꞋu, sulia ngwae ki kira kwatea naꞋa na kwaiaraꞋa kira Ꞌani tafelada. Ma God noaꞋa kasi kwatea naꞋa ta kwaiaraꞋa fuada. ");
INSERT INTO kwf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bore ma ana kaidaꞋi Ꞌoke abu fanga, Ꞌoke siu Ꞌamu, ma Ꞌoko salaifu Ꞌamu diꞋia Ꞌoko sasia sulia asoa ki, ");
INSERT INTO kwf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","fasi Ꞌiri ta ngwae kasi lia saiamu neꞋe Ꞌoko abu fanga. Ma sui bore Ꞌana ta ngwae kasi lia saiamu, MaꞋa Ꞌoe Ꞌi langi ka lisi Ꞌoe, ma nia ka kwatea na kwaiaraꞋa fuamu osiꞋana na tae ki neꞋe Ꞌoko sasiꞋi. Nia saiana ka lisiꞋo sulia asoa ki, sui bore Ꞌana noaꞋa Ꞌoe kosi lisia.” ");
INSERT INTO kwf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sui, sa Jesus ka fata laꞋu Ꞌuri, “Kamu kasi gonia na toꞋoruꞋa kamu ki Ꞌi neꞋe saena magalia ana na kula neꞋe sufusufu ma na furaꞋa ke faꞋalia, ma na ngwae bili ki ka bilia. ");
INSERT INTO kwf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Muke gonia na toꞋoruꞋa kamu ki Ꞌi langi, kula sufusufu ma na furaꞋa kasi faꞋalia, ma na ngwae bili noaꞋa kasi bilia. ");
INSERT INTO kwf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","OsiꞋana kaidaꞋi na toꞋoruꞋa kamu nia teo Ꞌi langi, na maurilamuꞋa ka agwaꞋi taꞋifau naꞋa Ꞌuana Ꞌi langi. Ma kaidaꞋi na toꞋoruꞋa kamu nia teo saena magalia, na maurilamuꞋa ka agwaꞋi taꞋifau naꞋa Ꞌuana ru saena na magalia ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Si diꞋia maamu leꞋa, Ꞌoko tua saena na madakolaꞋa ana faꞋamanata Ꞌanga God, osiꞋana na maamu neꞋe dau talaꞋia maꞋi madakolaꞋa saena nonimu. ");
INSERT INTO kwf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","DiꞋia noaꞋa Ꞌoe kosi lisia na madakolaꞋa neꞋe, maamu neꞋe taꞋa, ma Ꞌoko tua goꞋo Ꞌamu saena maꞋerodo. Muke madafi kamu, si diꞋia kamu ilangani na madakolaꞋa God, saena maurilamuꞋa nia rodoꞋa liu mala.” ");
INSERT INTO kwf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sa Jesus ka fata laꞋu Ꞌuri, “ꞋAfitaꞋi ta ngwae ka rao fuana ta ro ngwae ꞋaꞋana matamata. DiꞋia nia ꞋunaꞋeri, nia ke baꞋa malimaeꞋa ana ta ngwae ꞋaꞋana, ma ka kwaima ana ta ngwae ꞋaꞋana. Ma nia ka rao leꞋa fuana ta ngwae, ma ka danga faꞋiburi Ꞌani ta ngwae. Nia neꞋe, ka ꞋafitaꞋi liu diꞋia neꞋe muke rao fuana God ma na mani laꞋu ana taꞋi kaidaꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ta neꞋe nau ku saea fuamuꞋa, noaꞋa kamu kasi manata Ꞌabera sulia tae neꞋe kamu ke Ꞌania, ma muka kwaꞋufia, ma tae neꞋe kamu ke toro Ꞌani fafia nonimuꞋa. OsiꞋana na mauriꞋa neꞋe, nia leꞋa ka tasa liufia na fanga, ma na noni neꞋe, nia leꞋa ka tasa liufia na toro. ");
INSERT INTO kwf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lisia na faꞋi noꞋo ki saena mamanga, noaꞋa kira kasi Ꞌabera goꞋo sulia raoꞋa ana ta oꞋola. Ma noaꞋa kira kasi loia goꞋo ta fanga, ma kira kasi saungaꞋinia goꞋo ta babala fuana alu fangaꞋa. Bore ma MaꞋa kamu Ꞌi langi sareda goꞋo Ꞌana. Aia, God nia lia doe liu amuꞋa ka liufia mala faꞋi noꞋo ki. Nia neꞋe, God ka sare kamu goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sui bore Ꞌana kamu ka manata Ꞌabera sulia mauriꞋa kamu ki, nia ꞋafitaꞋi liu kamu ka sasi maurilamuꞋa ka taꞋi tau tiꞋitiꞋi laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma faꞋuta mo neꞋe muka manata Ꞌabera sulia na toro ki? Muke lisia basi na takana Ꞌai neꞋe kira afola ki. NoaꞋa kira kasi rao goꞋo, ma noaꞋa kira kasi saungaꞋinia goꞋo ta toro fuada. ");
INSERT INTO kwf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma nau ku saea fuamuꞋa, kira lia kwanga ka tasa liufia toro neꞋe sa Solomon na tatalafaꞋa nia ruꞋufiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma na takana Ꞌai ki, kira teo goꞋo Ꞌada sulia kala kaidaꞋi dokodoko, ma kira ka Ꞌui logo Ꞌanida saena mafula. Sui ka ꞋunaꞋeri bore Ꞌana, God nia faꞋaruꞋufida Ꞌani ru leꞋa ki. ꞋUri ma kamu fitala fasi God noaꞋa kasi faꞋatoro kamu logo? Na fitoꞋonga kamu ki nia tiꞋitiꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ta neꞋe, noaꞋa kamu kasi manata Ꞌabera Ꞌuri, ‘Na fanga, ma na ru ni kwaꞋufilana, nama na toro nau ki ke baꞋa leka maꞋi faꞋasia Ꞌi faꞋi?’ ");
INSERT INTO kwf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ꞋIu, na ngwae tua kwaikinai ana God ki, kira saiana manata ꞋaberaꞋa sulia ru neꞋeri ki. Ma kamuꞋa, MaꞋa kamu Ꞌi langi nia saiana ka sui naꞋa neꞋe kamu boꞋoboꞋo Ꞌuana ru neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Muke oga liu lala ꞋamuꞋa na mauriꞋa neꞋe God nia gwaungaꞋi fafia ka tasa faꞋinia sasilana na ru saga ki. Muke oga liu ꞋamuꞋa ru neꞋe ki ka liufia na ru matamata ki taꞋifau, ma nia ke baꞋa kwatea fuamuꞋa na ru ki taꞋifau neꞋe kamu boꞋoboꞋo Ꞌuana ki. ");
INSERT INTO kwf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nia neꞋe, noaꞋa kamu kasi manata Ꞌabera sulia boꞋoboꞋo Ꞌanga fuana rorodo. Teo naꞋa Ꞌana fuana rorodo. NoaꞋa kasi bolo fuana muke fikua na Ꞌabera Ꞌanga rorodo ki faꞋinia na Ꞌabera Ꞌanga ki ana asoa taꞋena logo. OsiꞋana asoa taꞋena toꞋo ana ꞋaberaꞋanga bolo faꞋinia taꞋena.” ");
INSERT INTO kwf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa kamu kasi matalangani ta ngwae matamata, Ꞌasu Ꞌubani God ka matalangaꞋi kamu logo. ");
INSERT INTO kwf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","DiꞋia kamu matalangani ta ngwae, God ke matalangaꞋi ꞋunaꞋeri logo amuꞋa. Ma taki tae neꞋe kamu matalangaꞋinia Ꞌani ta ngwae, na taki neꞋeri logo neꞋe God ke baꞋa matalangaꞋi kamu Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ꞋOko toꞋo ana taꞋangaꞋa doe ki, bore ma Ꞌoko balufia goꞋo Ꞌamu ta ngwae neꞋe nia toꞋo ana taꞋangaꞋa tiꞋitiꞋi. ꞋOko diꞋia taꞋi ngwae neꞋe nia lisia na gegeo Ꞌi saena na maana sa toꞋolana, bore ma nia kasi lisia goꞋo ta buli ano doe neꞋe nia saena maana talana. ");
INSERT INTO kwf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma Ꞌoko fata Ꞌuri fuana na ngwae matamata, ‘ꞋOko fulia ta ru neꞋe nia taꞋa, alaꞋania nai faꞋasaga maurilamu.’ Bore ma Ꞌoe kosi manata Ꞌabera goꞋo sulia taꞋangaꞋa doe neꞋe Ꞌoko sasiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ꞋAeꞋo ngwae kwalabasa. ꞋOke faꞋasia basi na taꞋangaꞋa Ꞌoe ki. Sui, Ꞌoko fiꞋi bolo fuana kwaiꞋafiꞋanga kwau ana ta ngwae matamata fuana na taꞋangaꞋa nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma noaꞋa kamu kasi kwatea ru abu ki fuana kui ki, sulia kira ke abula, ma kike baꞋa Ꞌale kamu. Ma noaꞋa kamu kasi kwatea na laungi kamu ki fuana gwata ki, Ꞌasu Ꞌubani kira kata uria goꞋo Ꞌada.” ");
INSERT INTO kwf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sa Jesus ka fata laꞋu Ꞌuri, “Kamu ke gani ana God Ꞌiri muke ngalia ru neꞋe kamu gani Ꞌuana. Kamu ke lulua ru kamu boꞋoboꞋo Ꞌuani ki ana God, ma nia ka Ꞌafi kamu, Ꞌiri muke lisia. Kamu ke faꞋafo ana sinamaa, ma God ke Ꞌifi fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","OsiꞋana na ngwae ki taꞋifau neꞋe kira gani ana God, kira ngalia naꞋa ru neꞋe kira gania. Ma na ngwae ki taꞋifau neꞋe kira lulua ru kira boꞋoboꞋo Ꞌuani ki ana God, kira ka lisia. Ma na ngwae ki taꞋifau neꞋe kira faꞋafo ana sinamaa, ma God ke Ꞌifi fuada. ");
INSERT INTO kwf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“ꞋUri ma, sa tai aumulu ana maꞋa ki, neꞋe diꞋia na ngela Ꞌoe nia ganiꞋo Ꞌuana fanga, Ꞌoke kwatea lala na fau fuana? ");
INSERT INTO kwf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma diꞋia na ngela Ꞌoe nia gani Ꞌuana ta iꞋa, Ꞌoke kwatea lala faꞋi loi fuana? NoaꞋa liu! ");
INSERT INTO kwf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sui bore Ꞌana kamuꞋa taꞋifau ngwae taꞋa ki, kaumulu saiana kwatelana na ru leꞋa ki fuana ngela kaumulu ki. Bore ma na MaꞋa kamu neꞋe nia Ꞌi langi, nia leꞋa ka tasa liufi kamu. ꞋUnaꞋeri neꞋe nia ka kwatea na ru leꞋa ki fuana ngwae ki neꞋe kira gani nia Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ta tae neꞋe kamu oga ana ngwae matamata ki kike sasia fuamuꞋa, muke sasia logo fuada. Sulia nia neꞋe na fadalana na faꞋamanataꞋanga ana taki sa Moses ki, ma na profet ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sa Jesus ka fata laꞋu Ꞌuri, “Muke ruꞋu kwau ana sinamaa neꞋe susukuru, sulia na tala ma na sinamaa neꞋe doe ma ka reba, nia leka Ꞌuana na maeꞋa firi. Ma na lekaꞋa sulia ka talangwaraꞋu goꞋo Ꞌana, ma na ngwae Ꞌoro liu ki neꞋe kira leka sulia na tala neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aia, na tala ma na sinamaa neꞋe susukuru nia leka Ꞌuana na mauriꞋa firi, ma na lekaꞋa sulia ka ꞋafitaꞋi, ma bara ngwae goꞋo neꞋe kira leka sulia.” ");
INSERT INTO kwf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sa Jesus ka alaꞋa laꞋu ka fata Ꞌuri, “Muke madafi kamu faꞋasia na profet ꞋosoꞋoso ki. Muke madafi kamu sulia kira lia diꞋia ngwae leꞋa ki, bore ma na manatalada neꞋe diꞋia kui kwasi ki neꞋe kira oga faꞋali lamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma muke baꞋa lia sai goꞋo ꞋamuꞋa ana na profet ꞋosoꞋoso neꞋeri ki Ꞌani ru taꞋa neꞋe kira sasiꞋi ki. Kulu saiana Ꞌai ki taꞋifau nia leꞋa nama ka taꞋa, osiꞋana fufuaꞋi ru kira ki neꞋe kira fungu Ꞌani. Ma nia ꞋafitaꞋi ta ngwae ka fisua na fufuana Ꞌai leꞋa faꞋasia na kwalongarangaraꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma na Ꞌai leꞋa nia fungu nama Ꞌani fuaꞋi ru leꞋa ki, ma na Ꞌai taꞋa ki ka fungu logo Ꞌani fuaꞋi ru taꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ꞋAi leꞋa ꞋafitaꞋi ka fungu Ꞌani fuaꞋi ru taꞋa, ma na Ꞌai taꞋa ꞋafitaꞋi ka fungu Ꞌani fuaꞋi ru leꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na Ꞌai ki taꞋifau goꞋo neꞋe noaꞋa kasi fungu Ꞌania ta fuaꞋi ru leꞋa, kira ka tufuda, ma kika Ꞌui Ꞌanida Ꞌi saena mafula. ");
INSERT INTO kwf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nia neꞋe, nau ku saea fuamuꞋa, muke baꞋa lia saiana na profet ꞋosoꞋoso ki Ꞌani ru neꞋe kira sasiꞋi ki.” ");
INSERT INTO kwf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa laꞋu na ngwae ki taꞋifau neꞋe kira fata Ꞌuri aku, ‘Aofia Ꞌae! Aofia Ꞌae!’ kira ke tua faꞋinia ngwae neꞋe God ke gwaungaꞋi fafida ki. Ma sa tai faꞋida neꞋe kira sasi sulia na kwaiogaiꞋanga MaꞋa nau Ꞌi langi goꞋo neꞋe, kike tua faꞋinia ngwae neꞋe God ke baꞋa gwaungaꞋi fafida ki. ");
INSERT INTO kwf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ma na ngwae Ꞌoro ki kike baꞋa fata Ꞌuri fuaku ana faꞋi asoa ana matalangaꞋinga neꞋeri, ‘Aofia Ꞌae, kaimili faꞋatalo naꞋa sulia fatalana God Ꞌani na satamu, ma kami ka ifulani na anoꞋi ru taꞋa ki Ꞌani na satamu, ma kami ka sasia ru Ꞌoro ni ꞋarefoꞋanga ki Ꞌani satamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bore ma nai baꞋa fata madako Ꞌuri fuada, ‘Nau noaꞋa kusi sai aumulu. Kaumulu na ngwae taꞋa ki. Muke leka tau kwau faꞋasi nau!’ ");
INSERT INTO kwf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nia neꞋe, na ngwae ki taꞋifau neꞋe kira rongoa alaꞋanga nau ki, ma kira ka sasi sulia, kira diꞋia na ngwae liatoꞋo neꞋe nia saungaꞋinia na luma nia Ꞌi fafona na diro Ꞌai ki neꞋe nia Ꞌilia ka koso lalo. ");
INSERT INTO kwf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na uta doe ka toꞋo, ma na kafo ki ka igo, ma na iru doe ka kwaiꞋia na luma neꞋeri, bore ma na luma neꞋeri kasi Ꞌasia goꞋo, sulia nia uu ngasi Ꞌi fafona na diro Ꞌai ngasi ki. ");
INSERT INTO kwf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ma na ngwae ki taꞋifau neꞋe kira rongoa na alaꞋanga nau ki, ma noaꞋa kasi sasi sulia, kira diꞋia na ngwae boleboleꞋa neꞋe saungaꞋinia na luma nia Ꞌi fafona one, ma noaꞋa nia kasi Ꞌilia diro Ꞌai ki kasi koso lalo goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na uta doe ka toꞋo, ma na kafo ki ka igo, ma na iru doe ka kwaiꞋia na luma neꞋeri, ma na luma neꞋeri ka Ꞌasia, ma ka mangisi taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ana kaidaꞋi sa Jesus faꞋamanata na ngwae ki Ꞌani na ru ki taꞋifau ka sui, kira ka Ꞌarefo liu, ");
INSERT INTO kwf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sulia kira sai leꞋa ana neꞋe sa Jesus nia faꞋamanata Ꞌani ngasingasiꞋanga ma na mamanaꞋanga maꞋi ana God. NoaꞋa nia kasi donga laꞋu sai Ꞌi ruꞋanga ngwae faꞋamanata ana taki sa Moses ki, osiꞋana kira faꞋamanata lala Ꞌani ngasingasiꞋanga kira ki talada. ");
INSERT INTO kwf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","KaidaꞋi sa Jesus nia koso naꞋa maꞋi Ꞌana faꞋasia Ꞌi gwauna faꞋi ua neꞋeri, na fikuꞋa doe liu kira ka leka maꞋi sulia. ");
INSERT INTO kwf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma taꞋi ngwae neꞋe kuu saungia nonina ka leka maꞋi, ma ka bobo uruuru naꞋona sa Jesus, ma ka fata Ꞌuri, “AraꞋi kwa, diꞋia Ꞌoko maꞋudi, Ꞌoko saiana Ꞌoke gura nau goꞋo Ꞌamu kwa.” ");
INSERT INTO kwf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sui sa Jesus ka taga kwau na limana, ma ka sama toꞋona nonina, ma ka fata Ꞌuri, “ꞋIu, nau ku maꞋudi. ꞋOko mafo naꞋa.” Ma ꞋaliꞋali Ꞌi buri Ꞌana alaꞋanga neꞋeri ki sa Jesus saea goꞋo, na kuu neꞋeri ka siki naꞋa faꞋasia ngwae neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa Jesus ka fata Ꞌuri fuana, “NoaꞋa Ꞌoe kosi faꞋarongoa laꞋu ta ngwae Ꞌani ru neꞋe nau ku sasia fuamu. Bore ma Ꞌoke leka basi, ma Ꞌoko faꞋataꞋinia naꞋa nonimu fuana na fata abu God, Ꞌoko alaꞋania fata abu God ka iroꞋo. Sui ma Ꞌoko kwatea na kwaisuꞋusiꞋanga Ꞌoe diꞋia ba sa Moses nia saea fuana kwatelana, fasi Ꞌiri ke kwatea faꞋamamanaꞋanga fuana na ngwae ki taꞋifau neꞋe nonimu nia mafo naꞋa.” Ma sa Jesus ka kwatea ngwae neꞋeri ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma ana kaidaꞋi sa Jesus nia dao naꞋa ana fanoa Ꞌi Kapaneam, taꞋi ngwae faꞋinaꞋonaꞋo ana ngwae ni fuꞋa ki faꞋasia Ꞌi Rom, nia ka leka maꞋi siana sa Jesus, ma ka gania fuana ke Ꞌafia ");
INSERT INTO kwf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ma ka Ꞌuri, “Aofia Ꞌae, na ngwae ni rao nau, nia mataꞋi liu, ma ka teo goꞋo Ꞌana, ma ka kina faꞋitaꞋilana nonina, ma na nonina ka fii liu.” ");
INSERT INTO kwf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sa Jesus ka fata Ꞌuri fuana, “LeꞋa goꞋo Ꞌana, nau kui baꞋa leka maꞋi Ꞌuana Ꞌi luma Ꞌoe fuana guralana.” ");
INSERT INTO kwf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma ngwae faꞋinaꞋonaꞋo neꞋe ka fata laꞋu Ꞌuri fuana sa Jesus, “Kwala Aofia kwa, noaꞋa nau kusi totolia fasi Ꞌiri nau ku kwalo Ꞌoe Ꞌi saena luma nau. ꞋOke saea goꞋo maꞋi ta alaꞋanga, si diꞋia Ꞌoko saea bore Ꞌamu maꞋi ta alaꞋanga, na ngwae rao nau nia ke baꞋa Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau ku saiana Ꞌoko bolo goꞋo Ꞌamu fuana sasilana ru neꞋeri, duꞋungana nauꞋa talaku na ngwae nau ku rao Ꞌi olofana na ngwae doe ki, ma nau ku toꞋo ana ngwae ni fuꞋa ki neꞋe kira rao Ꞌi olofana na gwaungaꞋinga nau. Ma diꞋia nau ku fata Ꞌuri fuana ta ngwae, ‘ꞋOke leka,’ ma nia ka leka naꞋa. Ma diꞋia nau ku fata Ꞌuri fuana ta ngwae, ‘ꞋOke leka maꞋi,’ nia ka leka logo maꞋi. Ma diꞋia nau ku saea ta ngwae rao nau ma nau ku Ꞌuri, ‘ꞋOke sasia nama ru neꞋe,’ nia ka sasia naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma kaidaꞋi sa Jesus rongo na ru neꞋe, nia ka Ꞌarefo liu. Ma nia ka abula fuana ngwae neꞋe kira leka sulia ki, ma ka fata Ꞌuri fuada, “Nau ku saea fuamuꞋa, naisi lisia Ꞌua ta ngwae neꞋe nia faꞋamamana ka Ꞌuri, sui bore Ꞌana saena Ꞌi Israel. ");
INSERT INTO kwf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma nau ku saea fuamuꞋa, ngwae Ꞌoro neꞋe noaꞋa laꞋu Jiu ki kike leka maꞋi faꞋasia fanoa Ꞌoro ki saena magalia fuana ꞋadoꞋa faꞋinia na koꞋo bora kia ki sa Abraham, sa Aesak, ma sa Jakob ana maoma ana saeleꞋanga Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma Ꞌorolada Jiu ki neꞋe fuila kira ka Ꞌado ana ru leꞋa ki ana Ꞌi langi, God ke baꞋa lalida Ꞌuana kula rorodoꞋa. Ma kaidaꞋi kira tua ana kula neꞋeri, kike baꞋa angi, ma kike Ꞌala girigiri Ꞌani lifada, osiꞋana kira nonifii.” ");
INSERT INTO kwf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma sa Jesus ka kakari abula laꞋu fuana ngwae doe neꞋeri, ka fata Ꞌuri fuana, “ꞋOko oli kwau. Nau ku sasia naꞋa ru neꞋe Ꞌoko gania, osiꞋana Ꞌoko faꞋamamana ana nauꞋa.” Ma ana kaidaꞋi neꞋeri nama goꞋo, na ngwae rao ba nia ka Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma ana taꞋi asoa, sa Jesus ka leka maꞋi Ꞌi luma sa Peter. KaidaꞋi sa Jesus ruꞋu Ꞌi luma, nia ka lisia funga kini sa Peter nia teo goꞋo Ꞌana, neꞋe nia mataꞋi ana ꞋakoꞋakoꞋa doe. ");
INSERT INTO kwf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma sa Jesus ka sama toꞋona limana na kini neꞋe. Ma ana kaidaꞋi neꞋeri goꞋo, na ꞋakoꞋakoꞋanga neꞋe ka sui naꞋa faꞋasia. Nia ka Ꞌakwa naꞋa, ma ka tataꞋe ka sasi fanga naꞋa Ꞌana fuana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma kaidaꞋi nia saꞋulafi naꞋa, ngwae ana fanoa neꞋeri kira ka ngalia maꞋi ngwae Ꞌoro ki siana neꞋe anoꞋi ru taꞋa ki kira ruꞋufida. Ma sa Jesus ka ifulani anoꞋi ru taꞋa neꞋeri ki faꞋasida Ꞌani fatalana goꞋo. Ma nia ka gura logo ngwae mataꞋi ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","KaidaꞋi nia sasia na ru neꞋeri ki, nia faꞋamamana na fatalana na profet Aesea ba keresia ka fata Ꞌuri, “NiaꞋa neꞋe faꞋamauri kia faꞋasia na mataꞋinga kia ki.” ");
INSERT INTO kwf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ma kaidaꞋi sa Jesus nia lisia ngwae Ꞌoro kira fiku maꞋi kalikalia, nia ka fata Ꞌuri fuana fafarongo nia ki, “Kulu toꞋofolo Ꞌuana bali Ꞌosi loꞋoko.” ");
INSERT INTO kwf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ana kaidaꞋi neꞋeri logo, taꞋi ngwae faꞋamanata ana taki ki ka leka maꞋi siana sa Jesus ka fata Ꞌuri, “Ngwae FaꞋamanata Ꞌae, nau ku oga nai leka faꞋi Ꞌoe Ꞌi faꞋi bore Ꞌana neꞋe Ꞌoke leka Ꞌuana.” ");
INSERT INTO kwf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","KaidaꞋi sa Jesus rongoa na ru neꞋe, nia ka fata Ꞌuri, “NoaꞋa nia kasi talangwaraꞋu. Na kui kwasi ki kira toꞋo ana na kula kira ki fuana teoꞋa, ma na noꞋo ki logo kira ka toꞋo ana na nuꞋi kira ki. Bore ma nauꞋa, na Ngela Ngwae, noaꞋa nau kusi toꞋo ana ta luma Ꞌaku talaku fuana maliuꞋa ana.” ");
INSERT INTO kwf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma taꞋi ngwae ana fafarongo nia ki, ka fata fuana sa Jesus ka Ꞌuri, “AraꞋi kwa, Ꞌoke alaꞋani nau Ꞌiri nau kui leka, ku tua basi faꞋinia maꞋa nau, leleka nia ka mae mala, nau ku kwaiatoa ka sui, nau ku fiꞋi dongaꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sa Jesus olisia ka fata Ꞌuri, “NoaꞋa. ꞋOke leka naꞋa maꞋi faꞋinau ana kaidaꞋi neꞋe. AlaꞋania na ngwae neꞋe noaꞋa kira kasi toꞋo ana mauriꞋa ana God ki, kike kwaiatoa naꞋa Ꞌada na ngwae mae kira ki.” ");
INSERT INTO kwf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma sa Jesus ka taꞋe saena gwaꞋi baru faꞋinia fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma ana kaidaꞋi kira Ꞌidu tau naꞋa kwau, maꞋe kauburu ka dao ꞋaliꞋali maꞋi, ma na asi ka lualuaꞋa, ma ka magara naꞋa maꞋi fafia na gwaꞋi baru neꞋeri. Ma na gwaꞋi baru neꞋeri ka karangi kuru naꞋa. Bore ma sa Jesus nia ka maliu goꞋo Ꞌana saena gwaꞋi baru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na fafarongo nia ki kira ka faꞋa ada, kira ka fata Ꞌuri, “Aofia kwa! ꞋOke faꞋamauri kulu! Kulu karangi mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ana kaidaꞋi neꞋeri sa Jesus ka fata Ꞌuri fuada, “FaꞋuta neꞋe kamu ka maꞋu? Nau ku lisia na faꞋamamana Ꞌanga kamu aku noaꞋa Ꞌiri doe.” Sa Jesus ka fata ꞋunaꞋeri fuada taꞋifau ka sui, nia ka tataꞋe, ma ka fata ngasingasiꞋa fuana iru ma na nafo, fasi Ꞌiri kira ka tua aroaro. Ma ana kaidaꞋi neꞋeri goꞋo, na iru ma na nafo ki kera ka tua aroaro naꞋa, ma ka folaꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma na fafarongo nia ki kira ka Ꞌarefo liu, ma kika fata Ꞌuri, “Ngwae faꞋuta naꞋa niniꞋa re? Na iru ma na nafo ki bore kira roꞋo naꞋa sulia!” ");
INSERT INTO kwf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ma kaidaꞋi kira dao naꞋa ana ta bali Ꞌosi ana maꞋe fanoa Ꞌi Gadara, sa Jesus ka dao toꞋona ro ngwae neꞋe anoꞋi ru taꞋa ki tua adaroꞋo. Ro ngwae neꞋe ki kera tua maꞋi saena maꞋe faoda ana alu ngwae maeꞋa saena. Ma osiꞋana keroꞋa balubaluꞋa liu, neꞋe kwate ma noaꞋa ta ngwae kasi dao karangia goꞋo kula neꞋe kera tua ana. ");
INSERT INTO kwf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ana kaidaꞋi anoꞋi ru ki neꞋe tua ana ro ngwae neꞋeri ki, kira lisia sa Jesus, kira ka ri Ꞌuri, “Ngela God Ꞌae, tae neꞋe Ꞌoko oga Ꞌoke sasia aimili? FaꞋuta Ꞌoko leka maꞋi fuana faꞋakaisi laimili Ꞌi naꞋona mala na kaidaꞋi neꞋe faꞋakaisi Ꞌanga ke dao?” ");
INSERT INTO kwf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana kaidaꞋi neꞋeri, na gwata Ꞌoro ki kira fanga karangia Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na anoꞋi ru neꞋeri ki kira Ꞌengo ana sa Jesus kika Ꞌuri, “DiꞋia Ꞌoko ifulani kaimili, Ꞌoke lali kaimili Ꞌuana saena gwata loꞋoko ki.” ");
INSERT INTO kwf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma sa Jesus ka fata Ꞌuri fuana anoꞋi ru neꞋeri ki, “Mulu leka naꞋa!” Ma kira ka faꞋusaka, ma kira ka leka naꞋa Ꞌuana saena gwata neꞋeri ki. Ma gwata neꞋeri ki taꞋifau kira leka toli naꞋa sulia ninimana faulifu neꞋeri Ꞌuana saena Ꞌosi baera. Ma kira ka mae taꞋifau Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma na ngwae neꞋe kira lia sulia gwata neꞋeri ki, kira ka lalili Ꞌuana fanoa kira. Ma kira ka alaꞋa sulia ru neꞋe sa Jesus sasia, ma na tae neꞋe nia fuli fuana na ro ngwae baera ki faꞋinia na anoꞋi ru ba kiri. ");
INSERT INTO kwf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma na ngwae ki taꞋifau ana maꞋe fanoa neꞋeri kira ka leka taꞋifau maꞋi fuana lisilana sa Jesus. Ana kaidaꞋi kira dao siana, kira ka Ꞌengoa niaꞋa fasi Ꞌiri nia leka faꞋasia fanoa kira. ");
INSERT INTO kwf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aia, sa Jesus faꞋinia na fafarongo nia ki, kira raꞋe Ꞌi saena gwaꞋi baru, ma kira ka toꞋofolo laꞋu ana gwaꞋi Ꞌosi doe neꞋeri Ꞌi Galili. Ma kaidaꞋi kira dao naꞋa ana fanoa nia Ꞌi Kapaneam, ");
INSERT INTO kwf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ti ngwae kira ka ngalia maꞋi taꞋi ngwae neꞋe nonina mae Ꞌi fafona ꞋifitaꞋi siana sa Jesus, Ꞌiri nia ka gura. Ma kaidaꞋi sa Jesus ka lisia naꞋa faꞋamamanaꞋanga kira, nia ka fata Ꞌuri fuana ngwae nonina mae neꞋeri, “NoaꞋa Ꞌoe kosi maꞋu laꞋu ngwade, nau ku rufuanata naꞋa ana taꞋangaꞋa Ꞌoe ki taꞋifau neꞋe Ꞌoko sasiꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ana kaidaꞋi neꞋeri, ti ngwae faꞋamanata ana taki ki kira ka manata Ꞌuri, “TalitoꞋona goꞋo God neꞋe saiana rufuanatalana taꞋangaꞋa ki. Nia ka faꞋabolotaꞋinia naꞋa faꞋinia God.” ");
INSERT INTO kwf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma sa Jesus nia sai logo ana manataꞋanga kira ki saena liada, ma nia ka fata Ꞌuri fuada, “Kamu kasi manata taꞋa laꞋu ꞋunaꞋeri.” Ma sa Jesus saiana logo neꞋe kira faꞋamamana talitoꞋona goꞋo God neꞋe ke gura ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","GoꞋo ꞋunaꞋeri nia ka fata Ꞌuri, “DiꞋia nau ku fata Ꞌuri fuana ngwae nonina taꞋu neꞋe ku Ꞌuri, ‘TaꞋangaꞋa Ꞌoe ki, nau ku rufuanata naꞋa ani,’ kaumulu kasi lisia goꞋo neꞋe nia fuli. Bore ma diꞋia nau ku fata Ꞌuri, ‘TataꞋe ma Ꞌoko fali,’ Ꞌi neꞋeri kamu ka fiꞋi lisia neꞋe ngasingasiꞋanga nia aku fuana guraꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","KaidaꞋi nai baꞋa gura ngwae neꞋe, nai faꞋataꞋinia fuamuꞋa neꞋe nauꞋa, Ngela Ngwae, nau ku toꞋo ana ngasingasiꞋanga fuana rufuanatalana ana taꞋangaꞋa ki.” Sui sa Jesus ka fata Ꞌuri fuana ngwae nonina taꞋu neꞋeri, “ꞋOke tataꞋe naꞋa, ngalia ꞋifitaꞋi Ꞌoe, ma Ꞌoko leka naꞋa Ꞌi fanoa Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana kaidaꞋi neꞋeri goꞋo, ngwae neꞋeri ka tataꞋe, ma ka oli naꞋa Ꞌuana fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ana kaidaꞋi neꞋe ngwae ki kira lisia tae neꞋe sa Jesus nia fulia, kira Ꞌarefo, ma kika maꞋu. Ma kira ka baꞋatafea God sulia nia kwatea na ngasingasiꞋanga ꞋunaꞋeri fuana na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma ana kaidaꞋi sa Jesus nia leka naꞋa faꞋasia kula neꞋeri, nia ka lisia sa Matthew. Nia tua goꞋo Ꞌana ana kula fuana gonilana mani ana takisi, si neꞋe nia rao Ꞌi neꞋeri. Ma sa Jesus ka fata Ꞌuri fuana, “ꞋOke leka maꞋi faꞋinau.” Ma sa Matthew ka tataꞋe, ma ka leka naꞋa Ꞌana faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma Ꞌi buri Ꞌana neꞋe sa Jesus nia baꞋea sa Matthew fuana fafarongo nia, nia ka leka fanga naꞋa Ꞌi luma nia. Ma na ngwaꞋi toꞋa goni mani ana na takisi ki tua logo Ꞌi neꞋeri. Ma ti ‘ngwae aburongo’ logo, kira fanga logo faꞋinia sa Jesus ma na fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma kaidaꞋi neꞋe Farasi ki kira lisia ru neꞋe, kira ka fata fuana na fafarongo nia ki kika Ꞌuri, “Nia bolo faꞋinia nia kasi fanga laꞋu faꞋinia ‘ngwae aburongo ki’.” ");
INSERT INTO kwf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sa Jesus ka rongoa ru neꞋeri, ma ka fata Ꞌuri, “Ngwae neꞋe noaꞋa kira kasi mataꞋi ki, kira kasi oga goꞋo ta ngwae kwaigurai, bore ma ngwae neꞋe kira mataꞋi ki tari, kira ka boꞋoboꞋo Ꞌuana ngwae kwaigurai. ");
INSERT INTO kwf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Muke manata basi sulia fadalana KerekereꞋa Abu ba Ꞌuri, ‘Nau ku oga kamu ke kwaimanatai fuana ngwae ki, ma noaꞋa laꞋu na kwaisuꞋusiꞋanga kamu ki.’ Nau ku Ꞌiri leka laꞋu maꞋi fuana laefilana ngwae ꞋoloꞋolo ki Ꞌiri kike kakari alifaꞋi, bore ma na ngwae neꞋe abulalada taꞋa ki lala tari neꞋe nau ku leka maꞋi fuana laefilada Ꞌuana rokisi manataꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Buri Ꞌana ru neꞋeri ki, na fafarongo sa John ngwae ni Siuabu ki, kira ka leka maꞋi siana sa Jesus, kika fata Ꞌuri, “Kaimili faꞋinia na Farasi ki, kami saiana mika abu fanga. Ma faꞋuta mo neꞋe fafarongo Ꞌoe ki noaꞋa kasi sasi ꞋunaꞋeri?” ");
INSERT INTO kwf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma sa Jesus ka olisida ka Ꞌuri, “Nia kasi bolo faꞋinia toꞋa neꞋe kira tua ana fafangaꞋa ana ara araꞋinga neꞋe kika kwaimanatai. DuꞋungana neꞋe, kaidaꞋi araꞋi faolu nia goꞋo Ꞌana Ꞌua faꞋinida ngwae ki, kira saeleꞋa. Bore ma kaidaꞋi ke dao maꞋi aigaꞋi neꞋe kike baꞋea na araꞋi faolu faꞋasida. ꞋUnaꞋeri mala, kira fiꞋi abu fanga laꞋu, osiꞋana neꞋe kira kwaimanatai. Nia neꞋe noaꞋa kasi bolo faꞋinia na fafarongo nau ki neꞋe kike abu fanga kaidaꞋi nau ku tua Ꞌua goꞋo Ꞌaku faꞋinida.” ");
INSERT INTO kwf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sui sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa ta ngwae kasi subungia ta toro neꞋe nia muu naꞋa Ꞌani ta ngisingisi toro faolu. Si diꞋia nia sasia ꞋunaꞋeri, na ngisingisi toro faolu neꞋeri ka gasia na toro Ꞌua neꞋeri duꞋungana toro faolu nia lukuluku Ꞌi buri Ꞌana saꞋulana, ma nia ka sasi na maꞋekwakwa neꞋe ka doe liu. ");
INSERT INTO kwf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ma muke sai logo ana, neꞋe noaꞋa kasi bolo fuana ta ngwae ka alua naꞋa waen faolu Ꞌi saena ngwaꞋi Ꞌua ana ꞋuꞋuila nanigot, duꞋungana ngwaꞋi ru Ꞌua neꞋeri kasi baꞋu. Si diꞋia nia sasia ꞋunaꞋeri, kaidaꞋi na waen neꞋeri ke totoro goꞋo maꞋi, nia ka foga naꞋa ngwaꞋi ru Ꞌua neꞋeri, ma na waen neꞋeri ka kisitaꞋi, ma na ngwaꞋi ru neꞋeri ka taꞋa naꞋa. Nia neꞋe ngwae ke alua nama waen faolu Ꞌi saena na ngwaꞋi ru faolu neꞋe nia saiana ke baꞋu fasi Ꞌiri ro ru neꞋeri ki noaꞋa kasi taꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","KaidaꞋi sa Jesus nia alaꞋa Ꞌua, taꞋi ngwae faꞋinaꞋonaꞋo ana ngwae Jiu ki ka leka maꞋi. Ma nia ka bobo uruuru Ꞌi naꞋona sa Jesus, ma ka fata Ꞌuri, “Na sariꞋi nau fiꞋi maemae goꞋo. Nau ku oga Ꞌoko leka maꞋi Ꞌiri Ꞌoke alua limamu fafia Ꞌiri nia ka mauri laꞋu Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma sa Jesus faꞋinia na fafarongo nia ki kira ka leka faꞋinia ngwae neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma ana kaidaꞋi kira leka Ꞌua goꞋo Ꞌada, taꞋi Ꞌafe neꞋe gwaꞋi Ꞌabu tafangia, ma nia ka mataꞋi Ꞌani sulia akwala ma ro faꞋi ngali ki, nia ka leka maꞋi burina sa Jesus, ma ka sama toꞋona mumuduꞋana ifi keta nia. ");
INSERT INTO kwf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","OsiꞋana na kini neꞋe nia manata ka Ꞌuri, “Sui bore Ꞌana diꞋia nau ku sama toꞋona na mumuduꞋana ifi sa Jesus, nau ku Ꞌakwa naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","KaidaꞋi nia sama toꞋona na mumuduꞋana ifi nia, sa Jesus ka alifaꞋi, ma ka lisia naꞋa kini neꞋeri, ma ka fata Ꞌuri fuana, “ꞋOe kosi manata Ꞌabera laꞋu. ꞋOko Ꞌakwa naꞋa, sulia Ꞌoko faꞋamamana ana nauꞋa.” Ma ana kaidaꞋi neꞋeri nama goꞋo, na mataꞋinga neꞋeri ka sui naꞋa faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma kaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira dao, kika ruꞋu Ꞌi luma ngwae faꞋinaꞋonaꞋo neꞋeri, kira ka lisia na ngwae ki kira ufia naꞋa Ꞌau ana maeꞋa, ma na ngwae Ꞌoro ki laꞋu goꞋo kira fiku Ꞌi neꞋeri, ma kira ka angi. ");
INSERT INTO kwf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma sa Jesus ka fata Ꞌuri fuana ngwae neꞋeri ki, “Kaumulu taꞋifau goꞋo muke ruꞋu Ꞌi maa. Ngela kini neꞋe noaꞋa kasi mae goꞋo, bore ma nia maliu goꞋo Ꞌana.” KaidaꞋi kira rongoa sa Jesus nia fata ꞋunaꞋeri, kira ka gaꞋasia lala niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma Ꞌi buri Ꞌana na ngwae ki kira ka leka faꞋasia, sa Jesus ka ruꞋu kwau saena mae luma neꞋeri, ma ka sama Ꞌi maana na limana sariꞋi neꞋeri, ma nia ka tataꞋe. ");
INSERT INTO kwf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Buri Ꞌana ru neꞋe sa Jesus nia sasia, na alaꞋanga sulia fiꞋi talofia na abaꞋi kula neꞋeri taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Buri Ꞌana sa Jesus nia leka kwau faꞋasia kula neꞋeri, na ro ngwae maada rodo ki kira donga sa Jesus, kera ka ri, ma keka fata Ꞌuri, “Ngwae neꞋe futa ana kwalafa sa David na ngwae tatalafaꞋa Ꞌae, Ꞌoke manatai keroꞋo!” ");
INSERT INTO kwf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma ana kaidaꞋi sa Jesus nia ruꞋu Ꞌi saena taꞋi luma, ro ngwae maada rodo neꞋeri ki kera ka ruꞋu logo Ꞌi burina. Ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “ꞋUri ma koroꞋo faꞋamamana ana nauꞋa fasi nau ku bolo fuana guralana na maamuroꞋo?” Ma kera ka olisia keka fata Ꞌuri, “ꞋIu, Aofia.” ");
INSERT INTO kwf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma sa Jesus ka sama toꞋona na maadaroꞋo, ka fata Ꞌuri, “OsiꞋana neꞋe koroꞋo faꞋamamana, ru neꞋeri ka fuli mamana naꞋa fuamuroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma na maada ka lia naꞋa, ma sa Jesus ka fata ngasingasiꞋa fuadaroꞋo noaꞋa kera kasi faꞋarongo Ꞌani ta ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma sui ana kaidaꞋi kera ruꞋu naꞋa kwau, kera fiꞋi alaꞋa naꞋa adaroꞋo sulia sa Jesus siana sa tai faꞋida neꞋe kera dao toꞋona saena bali abaꞋi kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aia, ma kaidaꞋi ro ngwae ba kiri kera ruꞋu kwau, ti ngwae kira ngalia laꞋu maꞋi taꞋi ngwae siana sa Jesus. Na kwakwana ngwae neꞋeri nonoto, sulia taꞋi anoꞋi ru taꞋa neꞋe ruꞋufia. ");
INSERT INTO kwf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma sa Jesus ka ifulani anoꞋi ru taꞋa neꞋeri faꞋasia ngwae neꞋeri. Sui, na ngwae neꞋe ka fata logo Ꞌana. Ma na ngwae neꞋe kira fiku ana kaidaꞋi neꞋeri, kira ka Ꞌarefo liu ana, ma kira ka fata Ꞌuri, “NoaꞋa kulu kasi lilisia Ꞌua maꞋi ta ru Ꞌuri Ꞌi fanoa kia Ꞌi Israel!” ");
INSERT INTO kwf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bore ma na Farasi ki, kira ka fata ꞋeꞋe ana sa Jesus kika Ꞌuri Ꞌada, “Ngwae gwaungaꞋi ana anoꞋi ru taꞋa ki neꞋe kwatea ngasingasiꞋanga fuana ngwae neꞋe ka ifulani Ꞌana anoꞋi ru taꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma kaidaꞋi sa Jesus nia liliu Ꞌana ana fanoa doe ki ma na maꞋe fanoa ki, nia ka faꞋamanata saena luma fuana foꞋongaꞋa kira ki, ma ka fulangaꞋinia na FaꞋarongoꞋa LeꞋa sulia ꞋInotoꞋanga God, ma ka gura ngwae neꞋe kira mataꞋi Ꞌani mataꞋinga matamata toꞋotoꞋo ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma sa Jesus nia lisia na ngwae neꞋe ki, ma ka kwaimanatai liu fuada sulia kira ngwataꞋutaꞋu, ma kira kasi totolia Ꞌafilada talada. Kira diꞋia sipsip ki neꞋe noaꞋa ta ngwae fuana liaꞋa sulida. ");
INSERT INTO kwf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma nia neꞋe sa Jesus ka fata Ꞌuri fuana fafarongo nia ki, “Na ngwae neꞋe ki diꞋia na unitaꞋi Ꞌai nia maua naꞋa saena oꞋola ma niꞋi ka Ꞌoro liu. Bore ma na ngwae rao ki neꞋe noaꞋa kasi Ꞌoro Ꞌiri kike talaꞋida Ꞌuana God. ");
INSERT INTO kwf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aia, ꞋunaꞋeri kamu ke foꞋo, ma muke gania God neꞋe ꞋaꞋana ana raoꞋa fasi Ꞌiri ke kwatea maꞋi ngwae ni rao ki kike talaꞋida Ꞌuana God.” ");
INSERT INTO kwf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sa Jesus ka saea naꞋa maꞋi akwala ma ro ngwae ni fafarongo nia ki siana, ma ka kwatea naꞋa ngasingasiꞋanga fuada fuana ifulangaꞋilana na anoꞋi ru taꞋa ki, ma fuana na guralana na mataꞋinga matamata Ꞌoro toꞋotoꞋo ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma na satana na akwala ma ro ngwae lifurongo nia ki neꞋe Ꞌuri: etana, sa Simon (neꞋe nia saea logo Ꞌani sa Peter), ma na ngwaefuta nia sa Andrew, ma sa James ma sa John, ro ngela sa Sebedi ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ma sa Filip, ma sa Batolomiu, ma sa Tomas, ma sa Matthew, na ngwae ba fuana gonilana mani ana takisi, ma sa James na ngela sa Alfeas, ma sa Tadeas, ");
INSERT INTO kwf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma sa Simon, ta ngwae ana ngwaꞋi toꞋa Jiu neꞋe kira oga lalilana na ngwaꞋi toꞋa Ꞌi Rom faꞋasia Ꞌi Israel, ma sa Judas Iskariot na ngwae ba nia ke baꞋa Ꞌolosaea sa Jesus fuana malimae nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma sa Jesus ka asungaꞋinia na akwala ma ro ngwae neꞋeri ki, ka Ꞌuri, “NoaꞋa kamu kasi leka Ꞌi safitada ngwae noaꞋa laꞋu Jiu ki, ma kamu kasi ruꞋu Ꞌi saena ti fanoa ana ngwae Ꞌi Samaria ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Muke leka lala Ꞌaumulu fuada na ngwae Ꞌi Israel ki, neꞋe kira diꞋia na sipsip ki neꞋe kira oꞋosi naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma ana kaidaꞋi kamu leka, kamu ka fulangaꞋinia Ꞌuri, ‘KaidaꞋi God ke gwaungaꞋi fafia ngwae nia ki, nia dao karangi kamu naꞋa!’ ");
INSERT INTO kwf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma kamu ke gura ngwae mataꞋi ki, ma kamu ke taꞋea ngwae mae ki, ma kamu ke gura na ngwae neꞋe kuu nia faꞋalida ki, ma kamu ke ifulani na anoꞋi ru taꞋa ki. Kaumulu ngali sakongaꞋi ana, ꞋunaꞋeri neꞋe muke kwate ꞋoꞋo logo. ");
INSERT INTO kwf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Na ngwae ni rao, nia bolo faꞋinia na ngwae ki ka lia sulia. Nia neꞋe ana kaidaꞋi kaumulu leka, noaꞋa kamu kasi manata Ꞌabera Ꞌuana dauꞋa fafia ta mani. NoaꞋa kamu kasi ngalia ta ngwaꞋi. Ma noaꞋa kamu kasi ngalia ta ro toꞋongi nama ta taꞋe butu, nama ta faꞋi kuba bore. ");
INSERT INTO kwf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma diꞋia kamu dao ana ta fanoa, muke lia Ꞌuana ta ngwae neꞋe oga ke kwalo kamu Ꞌuana Ꞌi saena luma nia. Ma muke tua faꞋinia ngwae neꞋeri leleka ka dao ana kaidaꞋi muke leka faꞋasia maꞋe fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ana kaidaꞋi kamu ruꞋu Ꞌi saena ta luma, muke fata Ꞌuri fuana ngwae neꞋe kira tua neꞋeri ki, ‘God ke faꞋaleꞋa kamu, ma na aroaroꞋanga nia ka tua faꞋi kamu Ꞌi saena na luma neꞋe.’ ");
INSERT INTO kwf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","DiꞋia neꞋe ngwae saena luma neꞋeri kira ka kwaima faꞋi kamu, na faꞋaleꞋanga kamu ke baꞋa tua logo faꞋi kira. Ma diꞋia noaꞋa, na faꞋaleꞋanga neꞋeri ka oli logo maꞋi fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aia, ma diꞋia kamu dao ana ta fanoa, ma noaꞋa ta luma nama noaꞋa ta ngwae kasi maꞋudi goꞋo fuana kwalo lamuꞋa, nama kira ka Ꞌaila Ꞌania rongolana fatalamuꞋa, muke leka faꞋasia na kula neꞋeri. Ma ana kaidaꞋi kamu leka faꞋasia, muke kwaꞋi tafula ano faꞋasia ꞋaemuꞋa diꞋia na faꞋabasuꞋanga naꞋa fuada neꞋe God ke baꞋa matalangaꞋi kira, duꞋungana kira Ꞌaila Ꞌania rongolana fatalana God. ");
INSERT INTO kwf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma nau ku saea ru mamana fuaumulu, ana faꞋi asoa neꞋe God ke baꞋa matalangani na magalia, na kwaꞋikwaꞋinga neꞋe nia ke baꞋa kwatea fuana ngwae neꞋeri ki ka doe ka tasa liufia matalangaꞋinga neꞋe God ke baꞋa kwatea fuana ngwae taꞋa ba kiri saena ro maꞋe fanoa ba Ꞌi Sodom ma Ꞌi Gomora ki.” ");
INSERT INTO kwf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma sa Jesus ka fata laꞋu Ꞌuri, “Muke fafarongo leꞋa, nau ku baꞋe kamu kwau Ꞌuana na ꞋafitaꞋiꞋanga, osiꞋana kamu leka naꞋa diꞋia sipsip ki siana ngwae taꞋa ki neꞋe kira diꞋia naꞋa kui kwasi ki neꞋe kira oga faꞋalilamuꞋa. Nia neꞋe, muke lialia leꞋa, ma noaꞋa kamu kasi sasi ta ru rora neꞋe kika fafi kamu Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muke lia suli kamu, osiꞋana ti ngwae kira ke baꞋa dau kamu, ma kira ka talaꞋi kamu siana ngwae kwaigiosi ki, ma kika ulasi kamu saena luma ni foꞋongaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","DuꞋungana neꞋe kamu leka suli nau, kike baꞋa tara kamu siana ngwae faꞋinaꞋonaꞋo ma na tatalafaꞋa kira ki fuana matalangaꞋilamuꞋa. Ma ana kaidaꞋi kira sasi naꞋa ꞋunaꞋeri, muke faꞋarongo Ꞌani na FaꞋarongoꞋa LeꞋa fuada ma fuana ngwae noaꞋa laꞋu Jiu ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","KaidaꞋi kira ngali kamu Ꞌi naꞋona ngwae ni kwaigiosi ki, noaꞋa kamu kasi manata Ꞌabera Ꞌuana ta tae neꞋe muke saea ma muke baꞋa fata faꞋuta Ꞌani, osiꞋana God naꞋa neꞋe ke baꞋa kwatea alaꞋanga ki fuamuꞋa fuana saelani ana kaidaꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","NoaꞋa kamu kasi baꞋa alaꞋa taꞋifili kamu naꞋa. Na AnoꞋi ru God na MaꞋa kamu maꞋi langi neꞋe ke baꞋa faꞋafata kamu. ");
INSERT INTO kwf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ngwae Ꞌoro ki, kike baꞋa ngalia ngwae asina kira ki neꞋe kira faꞋamamana aku fuana ngwae ki Ꞌiri kika saungida. Ma ngwae Ꞌoro ki logo, kike baꞋa sasi logo ꞋunaꞋeri ana ngela kira ki neꞋe kira faꞋamamana aku. Ma ngela Ꞌoro ki logo, kike baꞋa malimae naꞋa ana maꞋa ma teꞋa kira ki, ma kika ngalida siana ngwae ki fuana saungilada. ");
INSERT INTO kwf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na ngwae Ꞌoro ki, kika ila Ꞌani kamu sulia kamu na fafarongo nau ki. Ma diꞋia sa tai bore Ꞌana neꞋe ka faꞋamamana ngasi, leleka ka dao ana na Ꞌisilana kaidaꞋi ana ꞋafitaꞋi Ꞌanga, God ke baꞋa faꞋamauri nia. ");
INSERT INTO kwf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","DiꞋia ngwae ana taꞋi fanoa kira faꞋakaisi kamu, muke tafi, muke leka faꞋasia maꞋe fanoa neꞋeri ꞋaliꞋali, ma kamu ka leka laꞋu Ꞌaumulu Ꞌuana ta fanoa matamata. Nau ku saea fuamuꞋa, ꞋafitaꞋi kamu ka faꞋasuia goꞋo na raoꞋa kamu ana maꞋe fanoa Israel ki, Ꞌi naꞋo ana nauꞋa, na Ngela Ngwae, nai baꞋa dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aia, na ngwae neꞋe nia saesaeꞋi ru goꞋo Ꞌana, nia ꞋafitaꞋi ka doe liufia na ngwae neꞋe faꞋamanata nia. Ma na ngwae ni rao noaꞋa kasi doe liufia na araꞋi gwaungaꞋi nia. ");
INSERT INTO kwf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nia ka leꞋa fuana ngwae saesaeꞋi ru ke baꞋa usulia na ngwae faꞋamanata nia. Ma na ru neꞋe kira sasia ana ngwae gwaungaꞋi, ke baꞋa sasia logo ana ngwae rao nia ki. Ma diꞋia nauꞋa, na ngwae gwaungaꞋi kamu, kira sae nau Ꞌania sa Saetan neꞋe ngwae gwaungaꞋi ana anoꞋi ru taꞋa ki, Ꞌirai ma kamuꞋa bore, kike baꞋa sae kamu Ꞌania ta sata neꞋe taꞋa ka tasa.” ");
INSERT INTO kwf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sa Jesus ka fata laꞋu fuana na fafarongo nia ki ka Ꞌuri, “NoaꞋa kamu kasi maꞋu Ꞌani na ngwae ki. Ru ki taꞋifau neꞋe ngwae ki kira sofongaꞋinia, God ke baꞋa faꞋataꞋinia. Ma na ru ago ki taꞋifau, God ke baꞋa fata sulia. ");
INSERT INTO kwf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma na ru neꞋe nau ku saea fuamuꞋa Ꞌi saena na rodo, muke saea laꞋu goꞋo ana ꞋataꞋata asoa. Ma ru neꞋe nau ku kwaroro ana fuamuꞋa, muke fata abitako fuada na ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma noaꞋa kamu kasi maꞋungia na ngwae ki neꞋe kira saungia na nonimuꞋa ka mae, bore ma nia ꞋafitaꞋi fuana na saungilana na mangoꞋi ru. Muke maꞋungia lala God, osiꞋana niaꞋa neꞋe bolo faꞋinia naꞋa malangisilana na mango Ꞌi ru ma na noni ru saena na kula neꞋe mafula duꞋaduꞋa kasi mae. ");
INSERT INTO kwf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma na noꞋo tiꞋitiꞋi ki bore neꞋe miga, nia ꞋafitaꞋi fuana kala taꞋi noꞋo ada ka Ꞌasia Ꞌi ano diꞋia na MaꞋa kamu Ꞌi langi noaꞋa kasi alaꞋania. ");
INSERT INTO kwf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aia, ma kamuꞋa bore, na ifu ana gwaumuꞋa ki, God nia saiani taꞋifau goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nia neꞋe noaꞋa kamu kasi maꞋu, osiꞋana God nia manata doe ana ngwae ki ka liufia na faꞋi suba miga Ꞌoro neꞋe ki! ");
INSERT INTO kwf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ma sa tai neꞋe ka fulangaꞋinia fuana na ngwae ki fasi nia ka faꞋamamana nau, nau ku fulangaꞋinia ꞋunaꞋeri logo fuana na MaꞋa nau Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma sa tai bore Ꞌana neꞋe ka tofe nau Ꞌi maana ngwae ki, nai baꞋa tofe logo fafia fuana na MaꞋa nau Ꞌi langi.” ");
INSERT INTO kwf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa kamu kasi fia laꞋu fasi nau ku leka maꞋi faꞋinia na aroaroꞋa fuana magalia. NoaꞋa nau kusi ngalia goꞋo maꞋi aroaroꞋa. Nau ku leka maꞋi fasi Ꞌiri sa tai neꞋe noaꞋa kasi faꞋamamana aku, kira ke baꞋa fuꞋa faꞋinia na ngwae nau ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Na malimae ngwae, niaꞋa neꞋe ta ngwae goꞋo ana kwalafa nia. Sulia ngwae Ꞌalako ki, kike baꞋa fuꞋa faꞋinia maꞋa kira ki. Ma na kini sariꞋi ki, kike baꞋa fuꞋa faꞋinia teꞋa kira ki. Aia, na kini neꞋe Ꞌafe maꞋi ki bore, kike baꞋa fuꞋa faꞋinia funga kini kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma sa tai bore Ꞌana neꞋe ka alafe ana na maꞋa nia nama na teꞋa nia ka liufi nau, nia noaꞋa kasi totolia ka donga nau. Ma sa tai bore Ꞌana neꞋe ka alafe fuana na ngela nia ki ka liufi nau, nia noaꞋa kasi totolia ka donga nau. ");
INSERT INTO kwf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma nia ꞋafitaꞋi fuana ta ngwae ka diꞋia ta fafarongo aku, si diꞋia nia noaꞋa kasi maꞋudi fuana donga laku, sui bore Ꞌana kaidaꞋi nia ke nonifii, ma ke mae ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma sa tai bore Ꞌana neꞋe Ꞌaila kasi donga nau duꞋungana ni oga ka sasi Ꞌana sulia kwaiogaiꞋanga nia ki talana, nia ke baꞋa talafia na mauriꞋa firi. Bore ma diꞋia sa tai bore Ꞌana neꞋe noaꞋa nia kasi sasi sulia kwaiogaiꞋanga nia ki talana, ma nia maꞋudi ke mae osiꞋana nia donga nau, nia ka toꞋo ana mauriꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma sa tai bore Ꞌana neꞋe nia kwalo kamu, nia kwalo nau logo. Ma sa tai bore Ꞌana neꞋe ka kwalo nau, nia kwaloa logo God neꞋe nia asungaꞋi nau maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma sa tai bore Ꞌana neꞋe ka kwaloa na profet, osiꞋana neꞋe ngwae neꞋeri nia rao fuana God, nia ke baꞋa ngalia naꞋa kwaiaraꞋa diꞋia logo na kwaiaraꞋa neꞋe God kwatea fuana na profet. Ma sa tai bore Ꞌana neꞋe ka kwaloa na ngwae saga, sulia na ngwae neꞋeri nia saga, nia ke baꞋa ngalia naꞋa kwaiaraꞋa diꞋia naꞋa ngwae saga. ");
INSERT INTO kwf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma nau ku saea ru mamana fuamuꞋa, diꞋia ta ngwae ka kwatea ta maꞋe kafo gwari fuana ta taꞋi ngwae ana na fafarongo neꞋe nau ki, sulia neꞋe niaꞋa na fafarongo nau, nia ke baꞋa ngalia logo ta kwaiaraꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","KaidaꞋi sa Jesus nia alaꞋa fuana na akwala ma ro fafarongo nia ki ka sui, nia ka leka laꞋu fuana faꞋatalongaꞋilana FaꞋarongoꞋa LeꞋa faꞋinia faꞋamanatalana ngwae ana maꞋe fanoa ki kalikalia Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ana kaidaꞋi neꞋeri sa John ngwae ni Siuabu nia tua Ꞌi saena na luma ni lokafo, nia ka rongoa na raoꞋa neꞋe sa Jesus Christ nia sasiꞋi ki, ma nia ka kwatea ti ngwae ana fafarongo nia ki kira ka leka siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma kira saefiloa, kira ka fata Ꞌuri, “ꞋOke faꞋarongo kami maꞋi. ꞋUri ma ꞋaeꞋo naꞋa neꞋe na Christ neꞋe sa John saea ke baꞋa dao maꞋi, nama kami ke masia laꞋu Ꞌaimili ta ngwae matamata?” ");
INSERT INTO kwf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma sa Jesus ka olisida ka Ꞌuri, “Kamu ke oli, ma muka faꞋarongoa sa John Ꞌani na ru neꞋe kamu rongoꞋi ma kamu ka lisiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na ngwae neꞋe maada rodo ki, kira ka lia laꞋu. Ma na ngwae neꞋe Ꞌaeda mae ki, kira ka fali laꞋu. Ma na ngwae neꞋe kuu faꞋalida ki, na nonida ka mafo naꞋa. Ma na ngwae neꞋe alingada bani ki, kira ka rongo laꞋu. Ma na ngwae neꞋe kira mae naꞋa ki, kira ka mauri laꞋu. Ma na FaꞋarongoꞋanga LeꞋa baera, ba nau ku fata naꞋa sulia fuana ngwae dalaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma ꞋoilakiꞋa fuana sa tai neꞋe noaꞋa kasi manata ruarua ana nauꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","KaidaꞋi neꞋe na fafarongo sa John ki kira oli naꞋa, sa Jesus ka fata sulia sa John fuana na fikuꞋa neꞋeri, ka Ꞌuri, “Ana kaidaꞋi kamu leka siana sa John saena abaꞋi kula kwasi, sa tai nini kamu leka fuana lisilana Ꞌi neꞋeri? Ta ngwae neꞋe manata ruarua ka diꞋia goꞋo Ꞌana ta gwango rade neꞋe nia saola ana iru? NoaꞋa! Sa John nia noaꞋa laꞋu ngwae ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ꞋUri ma, tae neꞋe kamu leka fuana lisilana? Ta ngwae neꞋe nia toro Ꞌania ifi neꞋe folilana doe? NoaꞋa! OsiꞋana ngwae neꞋe kira toro ꞋunaꞋeri ki, kira tua Ꞌi saena luma ngwae tatalafaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kamu ke faꞋarongo nau maꞋi. Tae neꞋe kamu leka kwau fuana lisilana? Ta profet? ꞋIu! Nia ta profet mamana logo! Ma nia liufia mala na profet Ꞌi naꞋo ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa John naꞋa ba kira kerekere sulia saena KerekereꞋa Abu ana kaidaꞋi God nia fata fuana na Christ ka Ꞌuri, ‘Lia basi, nai baꞋa kwatea kwau na ngwae ni ngali alaꞋanga nau Ꞌi naꞋo amu, fasi Ꞌiri nia ke sasi akaꞋu ana ngwae ki fuamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nau ku saea ru mamana fuamuꞋa, sa John nia talingaꞋi ka liufia na ngwae ki taꞋifau neꞋe kira futa maꞋi Ꞌi saena magalia neꞋe. Sui ka ꞋunaꞋeri bore ana, na ngwae neꞋe kira tiꞋitiꞋi ki saena na GwaungaꞋi Ꞌanga God, kira talingaꞋi ka tasa ka liu ana sa John. ");
INSERT INTO kwf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aia, talaꞋae maꞋi ana kaidaꞋi sa John nia etangia faꞋarongoꞋa Ꞌani FaꞋarongoꞋa LeꞋa leka ka dao taꞋena, na ngwae taꞋa ki kira ka fuꞋalia GwaungaꞋi Ꞌanga God, ma kira sasi Ꞌuana laulana GwaungaꞋi Ꞌanga God. ");
INSERT INTO kwf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na taki sa Moses ki, ma na profet ki taꞋifau leleka ka dao ana kaidaꞋi sa John, kira fata faꞋatalo maꞋi sulia daolana maꞋi na Christ. ");
INSERT INTO kwf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kira saea sa Elaeja na profet ke baꞋa oli laꞋu maꞋi Ꞌi naꞋona na Christ. Ma nia leꞋa fuana kamu ka faꞋamamana neꞋe sa John naꞋa neꞋe sa Elaeja baera. ");
INSERT INTO kwf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muke fafarongo leꞋa ana alaꞋanga neꞋe nau ki.” ");
INSERT INTO kwf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma sa Jesus ka fata laꞋu Ꞌuri fuada, “Nau kui faꞋabolotaꞋinia fuamuꞋa na tua lamuꞋa ngwae ana taꞋena, kamuꞋa diꞋia na kaela ngela neꞋe kira fiku Ꞌi maana usiꞋa Ꞌani ro fikuꞋa ki. Ma kira ka ri kwailiu fuada, ");
INSERT INTO kwf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kaimili ufi Ꞌau, ma kamu kasi ngwaꞋe goꞋo sulia. Ma kaimili ka ngulia na faꞋi ngu sulia maeꞋa fuaumulu, ma kamu kasi kwaimanatai goꞋo.’ ");
INSERT INTO kwf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","KaidaꞋi sa John ngwae ni Siuabu nia dao maꞋi, nia abu fanga, ma noaꞋa kasi kwaꞋufia ta waen, ma kira ka saea fasi nia toꞋo ana anoꞋi ru taꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sui, kaidaꞋi nauꞋa, na Ngela Ngwae, nau ku dao maꞋi, nau ku fanga fiku, ma nau ku kwaꞋu faꞋinia ngwae ki, ma kamu ka fata logo Ꞌuri, ‘Kamu lisia! Nia fanga doe, ma ka kwaꞋu doe ana waen, ma nia ka kwaima faꞋinia ngwae neꞋe kira goni mani ana takisi ki ma ngwae abulalada taꞋa ki logo.’ Bore ma, ngwae neꞋe kira roꞋosulia na liatoꞋo God ki, kira faꞋataꞋinia neꞋe God nia mamana.” ");
INSERT INTO kwf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Buri Ꞌana sa Jesus fata ꞋunaꞋeri ka sui, nia ka talaꞋae ka fata dalea naꞋa maꞋe fanoa ba nia sasia maꞋi na faꞋanadaꞋa Ꞌoro ki ana, sulia ngwae ana maꞋe fanoa neꞋeri ki kira kina kakari alifaꞋi Ꞌanga faꞋasia taꞋangaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sa Jesus nia fata Ꞌuri, “Nia taꞋa lilisu naꞋa fuamuꞋa neꞋe kamu tua Ꞌi Koresin. Ma kamuꞋa neꞋe kamu tua Ꞌi Betsaeda ka ꞋunaꞋeri logo. OsiꞋana kamu Ꞌiri faꞋamamana na faꞋanadaꞋa Ꞌoro ba nau ku sasia fuamuꞋa ki. DiꞋia kira sasi faꞋanadaꞋa neꞋeri ki Ꞌi Taea ma Ꞌi Saedon Ꞌi naꞋo, na ngwae Ꞌi neꞋeri ki kira ka tua Ꞌi ano, ma kira ka ruꞋufia toro biliꞋa ki, ma kira ka rafua nonida ana fuꞋa, fasi Ꞌiri ka faꞋataꞋinia neꞋe kira kakari alifaꞋi taꞋifau naꞋa faꞋasia abula taꞋangaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ru mamana neꞋe nau ku saea fuamuꞋa, ana faꞋi asoa God ke baꞋa matalangaꞋinia ngwae ana magalia neꞋe, na kwaꞋikwaꞋinga kamu ke baꞋa tasa ka liufia na ngwae Ꞌi Taea faꞋinia Saedon ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aia, kamuꞋa na tuaꞋa Ꞌi Kapaneam, kamu fia God ke baꞋa lafu kamu Ꞌuana Ꞌi langi. Bore ma, nia ke baꞋa Ꞌui lala Ꞌani kamu Ꞌi saena kilu ana nonifiiꞋa. Sulia na faꞋanadaꞋa ba nau ku sasiꞋi Ꞌi maꞋe fanoa kamu ki, si diꞋia nau ku sasia maꞋi ꞋunaꞋeri Ꞌi Sodom, Ꞌirai ngwae Ꞌi Sodom ki kira ka kakari alifaꞋi naꞋa, ma God noaꞋa kasi malangisia fanoa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nia neꞋe, nau ku saea fuamuꞋa, ana faꞋi asoa neꞋe God ke baꞋa matalangani na ngwae ana magalia, na kwaꞋikwaꞋinga kamu ke baꞋa tasa ka liufia na ngwae Ꞌi Sodom ki.” ");
INSERT INTO kwf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ana kaidaꞋi neꞋeri, sa Jesus ka foꞋo ka fata Ꞌuri, “MaꞋasi, ꞋaeꞋo neꞋe Ꞌoko gwaungaꞋi fafia ru ki taꞋifau Ꞌi langi ma Ꞌi ano logo. Nau ku baꞋatafe Ꞌoe, duꞋungana neꞋe Ꞌoko faꞋataꞋinia GwaungaꞋi Ꞌanga Ꞌoe fuana ngwae neꞋe kira diꞋia ngela tiꞋitiꞋi ki, ma Ꞌoko sofongaꞋinia ru neꞋe ki faꞋasia ngwae neꞋe kira auraꞋeda duꞋungana kira liatoꞋo, ma kika lia saiana ru Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ꞋIu MaꞋasi, na ru neꞋeri ki nia ꞋunaꞋeri naꞋa sulia na kwaiogaiꞋanga Ꞌoe Ꞌua naꞋa maꞋi Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma sa Jesus ka fata Ꞌuri fuana na fikuꞋa neꞋeri, “MaꞋa nau nia kwatea ru ki taꞋifau naꞋa fuaku. Ma taꞋifilia na MaꞋa goꞋo neꞋe nia saiaku na Ngela nia. Ma taꞋifilia logo na Ngela talana neꞋe nia saiana MaꞋa nia, ma taꞋifili goꞋo ngwae neꞋe na Ngela nia filida fuana faꞋataꞋilana fuada ki, neꞋe kira saiana na MaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na fataꞋa totongaꞋi neꞋe na ngwae faꞋamanata ana taki sa Moses ki kira alua fuamuꞋa ki, niꞋi kwate ma kamu ka laeorooro naꞋa olofaniꞋi. Mulu leka maꞋi siaka, ma nai baꞋa lafutaꞋinia faꞋasi kamu. ");
INSERT INTO kwf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma muke kwairoꞋoi aku, ma nai baꞋa faꞋamanata kamu, sulia na falafala nau ki enoeno ma ka aroaro, ma muke dao toꞋona na mamaloꞋanga fuana na mangomuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","OsiꞋana na kwai talaꞋi Ꞌanga nau fuamu, nia talangwaraꞋu fuana dongalana.” ");
INSERT INTO kwf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma ana kaidaꞋi neꞋeri, ana taꞋi Sabat asoa ana mamaloꞋanga, sa Jesus faꞋinia na fafarongo nia ki kira leka, ma kira ka liu toꞋo folo ana taꞋi oꞋola ana witi, na ru kira saungani fuana beret. Ma ana kaidaꞋi neꞋeri, na fafarongo nia ki kira fiolo, ma kira ka fisua fingi ru ki, ma kira ka Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma ti ngwae ana Farasi ki kira lisida. Ma kira ka balufia sa Jesus kira ka Ꞌuri, “ꞋOko lisia! Na ru neꞋe fafarongo Ꞌoe ki kira sasia, nia Ꞌoia na taki sa Moses ki, duꞋungana kamu loia witi neꞋe ana Sabat, asoa ana mamaloꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma sa Jesus ka olisida ka Ꞌuri, “Nau ku saiana kaumulu toꞋomaꞋi sulia saena Buka Abu na ru ba sa David na tatalafaꞋa nia sasi Ꞌi naꞋo. Ana kaidaꞋi neꞋeri, sa David faꞋinia ngwae nia ki kira fiolo liu, ");
INSERT INTO kwf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nia ka leka Ꞌi saena na luma God, ma na ꞋingataꞋi fata abu ka kwatea fuana sa David na beret neꞋe kira Ꞌau abua fuana God. Ma sa David ka Ꞌania naꞋa beret neꞋeri, ma ka kwatea logo fuana ngwae nia ki, ma kira ka Ꞌania. Bore ma na taki kulu alaꞋani fuana talitoꞋona goꞋo na fata abu God ki neꞋe kira saiana Ꞌanilana. Ma noaꞋa kulu kasi lisia saena Buka Abu neꞋe God nia saetaꞋa fuana sa David.” ");
INSERT INTO kwf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma sa Jesus ka fata laꞋu Ꞌuri, “Nau ku saiana kaumulu toꞋomaꞋi sulia saena Buka Abu, na taki ki sulia fata abu ki ba kira rao saena Luma Abu God ana Sabat, asoa ana mamaloꞋanga. Kira ka rao bore Ꞌada ꞋunaꞋeri noaꞋa God kasi matalangaꞋinida goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aia, nau ku saea fuamuꞋa, na raoꞋa nau ku sasi neꞋe doe ka tasa liufia na Luma Abu God, ma nauꞋa niniꞋa naꞋa faꞋi kamu. ");
INSERT INTO kwf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ꞋIu, God nia fata Ꞌuri, ‘Nau ku oga kamu ke kwaimanatai fuana ngwae ki, ma noaꞋa laꞋu na kwaisuꞋusiꞋanga kamu ki.’ Ma diꞋia kamu ka saiana fadalana na ru neꞋe, nia ꞋafitaꞋi fuana muka matalangani na ngwae nau ki, osiꞋana neꞋe noaꞋa kira kasi rora goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","DuꞋungana neꞋe nauꞋa, na Ngela Ngwae, nau ku toꞋo ana na ngasingasiꞋanga fuana saelana ru ki fuana ngwae ki kira saiana kike sasia goꞋo Ꞌada ana asoa ana mamaloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma kaidaꞋi sa Jesus nia leka faꞋasia na kula neꞋe, nia ka leka saena taꞋi luma fuana foꞋongaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma taꞋi ngwae limana mae tua logo saena luma fuana foꞋongaꞋa neꞋeri. Ma ti ngwae kira saefiloa sa Jesus kika Ꞌuri, “ꞋUri ma nia bolo goꞋo Ꞌana fuana guralana ngwae mataꞋi ki ana Sabat, na asoa ana mamaloꞋanga kwa?” Kira saefiloa ꞋunaꞋeri fasi Ꞌiri kira ka dao toꞋona ta ru fuana fata maanalana sa Jesus ana Ꞌoilana taki God ana guraꞋa, ru neꞋeri kira manata sulia nia diꞋia raoꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ana kaidaꞋi neꞋeri, sa Jesus ka saefilo kira laꞋu ka Ꞌuri, “Muke faꞋarongo nau basi, diꞋia ta ngwae amuꞋa, na sipsip nia Ꞌasia saena ta kilu ana Sabat, Ꞌuri ma nia kasi leka ma ka lafua laꞋu faꞋasia na kilu ana faꞋi asoa neꞋeri? ");
INSERT INTO kwf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kaumulu saiana, God lisia ngwae neꞋe talingaꞋi ka liufia na sipsip. Aia, sulia ngwae neꞋe nia talingaꞋi ꞋunaꞋeri, noaꞋa nia kasi rora goꞋo fuana sasilana ta ru leꞋa fuana ma Ꞌafilana ta ngwae ana Sabat asoa ana mamaloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ana kaidaꞋi neꞋeri nama goꞋo, sa Jesus ka fata Ꞌuri fuana ngwae neꞋe limana mae, “ꞋOke taga maꞋi limamu.” Ma ngwae neꞋeri ka taga na limana. Ma ana kaidaꞋi neꞋeri nama goꞋo, na limana ba mae ka leꞋa logo Ꞌana diꞋia ruana ta bali lima. ");
INSERT INTO kwf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma ana kaidaꞋi na Farasi ki kira lisia na ru neꞋe, kira ka ruꞋu taꞋifau Ꞌi maa. Ma kira ka fiku lokoꞋi ru naꞋa fuana saungilana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","KaidaꞋi sa Jesus nia rongoa goꞋo Ꞌana neꞋe kira fiku lokoꞋi ru fasi Ꞌiri kika saungia, nia ka leka naꞋa faꞋasia fanoa neꞋeri. Ma na ngwae Ꞌoro ki, kira ka leka sulia sa Jesus, ma nia ka gura ngwae Ꞌoro neꞋe kira mataꞋi ki, ma kira ka Ꞌakwa taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma sa Jesus ka fata luida noaꞋa kira kasi alaꞋa suli nia siana ta ngwae laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nia sasi ꞋunaꞋeri fasi Ꞌiri ka faꞋamamana na fatalana God ba profet Aesea nia saea ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Na ngwae rao nau niniꞋa, nau ku filia fasi Ꞌiri ka sasia raoꞋa nau. Nau ku alafe liu fuana, ma nau ku saeleꞋa liu sulia. Nai baꞋa kwatea kwau na AnoꞋi ru nau fasi Ꞌiri ka tua faꞋinia. Aia, na ngwae neꞋe nia ka kwatea logo kwai matalangaꞋinga ꞋoloꞋolo fuada ngwae neꞋe noaꞋa laꞋu Jiu ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","NoaꞋa nia kasi tua Ꞌani kwaingilongiloi Ꞌanga, ma noaꞋa kasi ri kwaa, ma noaꞋa nia kasi fata auraꞋea maana fanoa ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","NoaꞋa nia kasi baꞋa danga faꞋiburi Ꞌani na ngwae dalaꞋa ma ngwae ngwataꞋutaꞋu ki. Ma nia ke baꞋa kwatea kwai matalangaꞋinga ꞋoloꞋolo fuana na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ꞋAni na ngwae neꞋe, ngwae Ꞌoro faꞋasia na fanoa ki taꞋifau, kira ke baꞋa fitoꞋo ana.” ");
INSERT INTO kwf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sui buri Ꞌana, ti ngwae kira ngalia maꞋi taꞋi ngwae siana sa Jesus fuana guralana. Ngwae neꞋe, anoꞋi ru taꞋa nia sura ana, ma na maana ka rodo, ma kwakwana ka noto. Ma sa Jesus ka gura na ngwae neꞋeri, ma nia ka lia ma ka fata naꞋa laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na fikuꞋa neꞋeri ka Ꞌarefo liu, ma kira ka saefilo kira kwailiu kika Ꞌuri, “ꞋUri ma na ngwae neꞋe nia neꞋe ngwae ba God nia filia, ma ke baꞋa futa maꞋi ana kwalafa sa David na ngwae tatalafaꞋa taka niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma kaidaꞋi ti Farasi kira rongoa na ru neꞋeri ki, kira ka fata Ꞌuri, “NoaꞋa laꞋu niaꞋa niniꞋa. Sa Jesus nia ifulani naꞋa anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga sa Saetan na ꞋingataꞋi anoꞋi ru taꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma osiꞋana neꞋe sa Jesus nia sai goꞋo ana na manatalada, nia ka fata Ꞌuri fuada, “DiꞋia ngwaꞋi toꞋa saena ta fanoa doe kira fuꞋali kira talada, Ꞌirai na fanoa doe neꞋeri ke takalo naꞋa. Ma diꞋia ta fanoa, nama na ngwae ma na Ꞌafe ma na ngela nia ki, kira fuꞋa faꞋi kira talada, nia ꞋafitaꞋi fuana kira ka tua fiku. ");
INSERT INTO kwf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma na ꞋinotoꞋanga sa Saetan neꞋe ꞋunaꞋeri logo. DiꞋia sa Saetan ke fuꞋa faꞋinia toꞋa neꞋe kira leka sulia, Ꞌirai kira ke takalo kwailiu goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“ꞋIu, ma kaumulu saea nau ku ifulani anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga sa Saetan. ꞋIrai ma ngasingasiꞋanga sa tai mo niniꞋa ti fafarongo aumulu ifulani anoꞋi ru taꞋa ki Ꞌani? Sa Saetan? NoaꞋa liu! DuꞋungana ru neꞋeri ki, nia faꞋataꞋinia neꞋe kaumulu rora. ");
INSERT INTO kwf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Nau ku ifulani anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga God. Ma nia ka faꞋataꞋinia naꞋa fuamuꞋa neꞋe na ꞋInotoꞋanga God fafia ngwae ki dao karangi naꞋa maꞋi siamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aia, diꞋia ta ngwae goꞋo Ꞌana oga ka ifulani ta anoꞋi ru taꞋa, ngwae neꞋeri ke ngasingasiꞋa ka liufia sa Saetan. Ka diꞋia logo ta ngwae neꞋe oga ke ruꞋu saena luma na ngwae ngasingasiꞋa fuana ngalilana ru nia ki. Nia ke ngasingasiꞋa ka liufia mala ngwae neꞋeri, fasi Ꞌiri ke talangwaraꞋu fuana firiꞋilana ngwae ngasingasiꞋa neꞋeri, sui mala nia ka fiꞋi ngali ru nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Aia, sa tai neꞋe noaꞋa nia kasi leka maꞋi buriku, nia na malimae nau. Ma sa tai neꞋe noaꞋa kasi kwaiꞋafi aku fuana fikulana maꞋi ngwae ki siana God, nia ka takalongaꞋi kira naꞋa faꞋasia God. ");
INSERT INTO kwf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Sulia nia ꞋunaꞋeri, nau ku saea fuamuꞋa, God saiana ke baꞋa rufuanata ana ru taꞋa ki taꞋifau goꞋo neꞋe ngwae nia sasia ma na ru taꞋa nia ka saea. Ma diꞋia ta ngwae ka fata taꞋa aku na Ngela Ngwae, God saiana ka rufuanata ana. Bore ma diꞋia ta ngwae ka fata faꞋalia na raoꞋa AnoꞋi ru Abu, noaꞋa liu God ka rufuanata ngwae neꞋeri, sui bore Ꞌana kaidaꞋi neꞋe, nama ta kaidaꞋi neꞋe nia maꞋi Ꞌua.” ");
INSERT INTO kwf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sa Jesus ka fata laꞋu Ꞌuri, “Kaumulu saiana diꞋia kamu toꞋo ana Ꞌai leꞋa, na fuaꞋi ru bore ka leꞋa logo. Ma diꞋia kamu toꞋo ana Ꞌai taꞋa, na fuaꞋi ru bore ka taꞋa naꞋa logo. ꞋUnaꞋeri logo ana ngwae. Sulia ru leꞋa ki leka maꞋi faꞋasia na ngwae leꞋa, ma ru taꞋa ki ka leka maꞋi faꞋasia na ngwae taꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma kamu diꞋia goꞋo amuꞋa kaela na baꞋeko tolo ki! Ma ꞋafitaꞋi liu kamu ka saea ta ru ka leꞋa, sulia na manataꞋanga kamu ki niꞋi taꞋa. Tae neꞋe nia tua saena manataꞋanga ngwae, nia neꞋe ka sakatafa maꞋi neꞋe ngwae ka alaꞋa Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na ngwae neꞋe leꞋa, na fatalana bore ke baꞋa leꞋa logo. Ma na ngwae neꞋe taꞋa, na fatalana bore ke taꞋa logo. ");
INSERT INTO kwf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nau ku saea fuamuꞋa, kaidaꞋi ana kwaꞋikwaꞋinga, God ke baꞋa matalangaꞋinia ngwae ki taꞋifau saena magalia fuana alaꞋanga taꞋa kira saeꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma God ke baꞋa matalangaꞋi ngwae Ꞌani fatalada talada. DiꞋia alaꞋanga ta ngwae ka leꞋa, God ke baꞋa fulangani ngwae neꞋe ni ꞋoloꞋolo. Ma diꞋia alaꞋanga ta ngwae ka taꞋa, God ke baꞋa fulangani na ngwae neꞋe ni rora.” ");
INSERT INTO kwf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui ti ngwae faꞋamanata ana taki ki ma ti Farasi, kira leka maꞋi siana sa Jesus, kira ka fata Ꞌuri fuana, “FaꞋamanata Ꞌae, kaimili oga liu Ꞌoko sasia ta faꞋanadaꞋa, fasi Ꞌiri ke faꞋataꞋinia mamanaꞋanga God neꞋe kwateꞋo maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sa Jesus ka fata Ꞌuri fuada, “Kamu ngwae ana taꞋena, kamu ngwae taꞋa ki. DuꞋungana kamu oga lisilana ta faꞋanadaꞋa neꞋe ke faꞋataꞋinia ngasingasiꞋanga God, bore ma nia ꞋafitaꞋi fuamuꞋa fuana lisilana. Kamu ke baꞋa lisia goꞋo amuꞋa na faꞋanadaꞋa diꞋia na ru ba nia fuli fuana sa Jona na profet Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa Jona ba tua saena ogana gwaꞋa sasu sulia uulu faꞋi asoa ma uulu faꞋi rodo ki. Aia, ma nauꞋa, na Ngela Ngwae, nai baꞋa ꞋunaꞋeri logo. Nai baꞋa tua saena ano sulia uulu faꞋi asoa ma uulu faꞋi rodo ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma ana kaidaꞋi God ka matalangaꞋinia ngwae ki, na ngwae neꞋe kira tua Ꞌi Ninifa, kira tataꞋe fasi Ꞌiri kira ka alaꞋa sulia na roraꞋa kamu ki. Kira sasi ꞋunaꞋeri, sulia kira kakari alifaꞋi naꞋa faꞋasia na taꞋangaꞋa kira ki, ana kaidaꞋi sa Jona fulangaꞋinia fuada. Ma taꞋi ngwae nia talingaꞋi ka liufia sa Jona nia tua naꞋa faꞋi kamu. Sui ka ꞋunaꞋeri bore, noaꞋa kamu kasi kakari alifaꞋi goꞋo faꞋasia na taꞋangaꞋa kamu ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma ana kaidaꞋi God ke matalangaꞋinia na ngwae ki, na gwaungaꞋi kini Ꞌi Siba, nia ka tataꞋe logo fuana alaꞋanga sulia na roraꞋa kamu. Na kini neꞋe nia sasi ꞋunaꞋeri, sulia nia leka maꞋi faꞋasia fanoa nia neꞋe tau liu mala fuana na rongolana liatoꞋonga sa Solomon na ngwae tatalafaꞋa. Ma taꞋi ngwae talingaꞋi ka liufia sa Solomon nia tua goꞋo Ꞌana faꞋi kamu. Sui ka ꞋunaꞋeri bore Ꞌana, noaꞋa kamu kasi oga goꞋo na rongolana.” ");
INSERT INTO kwf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sa Jesus ka fata Ꞌuri laꞋu, “KaidaꞋi kira ifulaꞋinia anoꞋi ru taꞋa nia leka faꞋasia ta ngwae, nia ka liliu saena kula kwasilaꞋa, ma ka lulu Ꞌuana ta kula fasi Ꞌiri nia ke tua laꞋu ana. Ma diꞋia nia lulu ma ka noaꞋa naꞋa, ");
INSERT INTO kwf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nia ke manata Ꞌuri, ‘Nai oli Ꞌuana na ngwae ba nau ku tuatua maꞋi ana Ꞌi naꞋo, ma nau ku leka maꞋi faꞋasia.’ Ana kaidaꞋi nia oli maꞋi ka dao, nia ka lisia ngwae baera nia faꞋasikasika ma ka faꞋasaga naꞋa maurilana taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","KaidaꞋi nia lisia neꞋe nia ꞋunaꞋeri, nia ka oli ma ka talaꞋia laꞋu maꞋi ta fiu anoꞋi ru neꞋe taꞋa ka tasa liufia niaꞋa, kira ka leka maꞋi, ma kira ka tua naꞋa Ꞌi saena ngwae baera. Ana kaidaꞋi neꞋeri, na tualana ngwae neꞋeri ka fiꞋi taꞋa ka liufia naꞋa Ꞌi naꞋo. Ma nia ka ꞋunaꞋeri logo fuamuꞋa ngwae ana taꞋena, kamu ngwae taꞋa ki, ma tualamuꞋa ka fiꞋi taꞋa ka liufia naꞋa Ꞌi naꞋo, osiꞋana kamu Ꞌaila Ꞌani nau.” ");
INSERT INTO kwf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ana kaidaꞋi sa Jesus nia alaꞋa Ꞌua fuana ngwae ki, teꞋa nia faꞋinia ngwaefuta nia ki kira ka dao maꞋi. Ma kira ka uu goꞋo Ꞌada Ꞌi maa, ma kira ka fata maꞋi Ꞌuana fasi Ꞌiri kira ka alaꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma taꞋi ngwae ana ngwae neꞋeri ki ka fata Ꞌuri fuana sa Jesus, “TeꞋa Ꞌoe faꞋinia ngwaefuta Ꞌoe ki, kira uu goꞋo maꞋi Ꞌada Ꞌi maa, ma kira ka oga kike alaꞋa faꞋi Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sa Jesus olisia ka Ꞌuri, “Nau ku saea sa tai faꞋida neꞋe teꞋa nau ma na ngwaefuta nau ki.” ");
INSERT INTO kwf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana kaidaꞋi neꞋeri, sa Jesus ka faꞋataꞋinia na fafarongo nia ki, ma ka fata Ꞌuri, “Muke lisia basi. Kira neꞋe kira diꞋia naꞋa teꞋa nau ki ma na ngwaefuta ki. ");
INSERT INTO kwf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sulia sa tai neꞋe sasi sulia na kwaiogaiꞋanga MaꞋa nau maꞋi langi, nia neꞋe ngwaefuta nau, ma na ngwaingwaena nau, ma na teꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana faꞋi asoa neꞋeri logo, sa Jesus ka ruꞋu kwau faꞋasia luma neꞋeri, ma ka leka Ꞌi ninimana na Ꞌosi, ma ka tua Ꞌi ano fuana faꞋamanataꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma sulia na fikuꞋa doe liu kira fiku kalia, nia ka raꞋe saena taꞋi gwaꞋi baru, ma ka tua Ꞌi saena, ma na ngwae ki kira ka uu kwau Ꞌi ꞋaꞋe one. ");
INSERT INTO kwf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sui nia ka faꞋarongo kira Ꞌani ru Ꞌoro ki Ꞌani alaꞋanga tarifulaꞋa ki, ka Ꞌuri, “TaꞋi ngwae nia leka ka tasalia maga witi ki Ꞌi saena oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma kaidaꞋi nia tasalia maga witi neꞋeri ki, ti maga witi kira Ꞌasia sulia na talalinga, ma na noꞋo ki kira ka lofo maꞋi, ma kira ka Ꞌanida taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma ti maga witi kira ka Ꞌasida ana kula faula ki, kula neꞋe ano kasi doe. Ma kira ka bulao ꞋaliꞋali sulia neꞋe ano nia kasi Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma ana kaidaꞋi neꞋe sina nia taꞋe maꞋi, nia ka sinafia na witi neꞋe masubu ki, ma kira ka kuku logo, sulia neꞋe lali ru ki kasi koso lalo. ");
INSERT INTO kwf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma ti maga witi kira Ꞌasida Ꞌi safitana na kwalo Ꞌabui ki, ma kwalo neꞋeri ka nuku fafia na witi ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma ti maga witi laꞋu niꞋi Ꞌasida Ꞌi saena na ano leꞋa, ma kaidaꞋi kira taꞋe maꞋi, kira ka fungu ana fuaꞋi ru Ꞌoro ki. Ma ti witi kira ka fungu Ꞌania taꞋi talangaꞋi faꞋiruꞋa, ma ti witi kira ka fungu Ꞌania ono akwala faꞋiruꞋa, ma ti witi laꞋu kira ka fungu Ꞌania uulu akwala faꞋiruꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma sa Jesus ka faꞋasuia fatalana ka Ꞌuri, “DiꞋia ta ngwae oga ka sai leꞋa ana ru neꞋe ki, ni ka sailinga leꞋa mala.” ");
INSERT INTO kwf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na fafarongo nia ki leka maꞋi siana, ma kira ka saefilo Ꞌuri ana, “FaꞋuta neꞋe Ꞌoko fata fuana na ngwae ki Ꞌani alaꞋanga ana tarifulaꞋanga ki kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sa Jesus ka olisida ka Ꞌuri, “KaidaꞋi sui ki, God noaꞋa kasi faꞋamadakola Ꞌua faꞋuta neꞋe nia ke baꞋa gwaungaꞋi fafia ngwae nia ki. Bore ma taꞋena, na madakolaꞋa niniꞋa dao naꞋa fuamuꞋa. Ma na ngwae neꞋe noaꞋa laꞋu fafarongo nau ki, noaꞋa naisi faꞋamadakola fuada. ");
INSERT INTO kwf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa tai bore Ꞌana neꞋe ka toꞋo ana ta madakolaꞋa tiꞋitiꞋi sulia ꞋInotoꞋanga God, God ke baꞋa luda gwauna fuana, fasi Ꞌiri nia ka toꞋo ana madakolaꞋa Ꞌoro ka aliꞋafu goꞋo. Bore ma sa tai neꞋe noaꞋa kasi roꞋosulia faꞋamanata Ꞌanga neꞋe ki, ta madakolaꞋanga tiꞋitiꞋi bore Ꞌana neꞋe nia toꞋo ana sulia ꞋinotoꞋanga God, God ke ngali olitaꞋinia faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aia, nau ku fata fuada Ꞌani alaꞋanga tarifulaꞋa ki, osiꞋana ngwae neꞋe ki lisia naꞋa ru nau ku sasiꞋi ki, bore ma noaꞋa kira kasi lia saiana. Kira rongoa alaꞋanga laku, bore ma noaꞋa kira kasi malinganiꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nia Ꞌuri Ꞌiri ka faꞋamamana na alaꞋanga ba sa Aesea na profet nia saea Ꞌi naꞋo ba Ꞌuri, ‘Kira ke fafarongo ma kike fafarongo, bore ma noaꞋa kira kasi saiana faꞋarongoꞋa God. Ma kira ke lia ma kira ke lia, bore ma noaꞋa kira kasi lisia tae neꞋe God ka sasi fuada. ");
INSERT INTO kwf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","OsiꞋana neꞋe manatada ka oꞋeoꞋela, ma kike bania na alingada, ma kike bokota logo na maada. ꞋAsu Ꞌubani maada kata lisia, nama alingada kata rongoa, ma na manatada ka malingaꞋinia fatalana God, ma kika faꞋitaꞋi maꞋi Ꞌuaku ma nau ku gurada.’” ");
INSERT INTO kwf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma sa Jesus ka fata laꞋu Ꞌuri, “ꞋOilakiꞋa liu fuaumulu, sulia neꞋe maamulu lisia naꞋa raoꞋa nau ku sasiꞋi ki, ma na alingamuꞋa ka rongoa faꞋamanataꞋanga nau ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ru mamana nau ku saea fuamuꞋa, na profet Ꞌoro ki, ma na ngwae saga ki Ꞌi naꞋo, kira oga lisilana ru neꞋe kamu lisiꞋi ki, bore ma noaꞋa kira kasi lisia. Ma kira oga naꞋa rongolana na ru neꞋe kamu rongoꞋi ki, ma noaꞋa kira kasi rongoa. ");
INSERT INTO kwf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Muke fafarongo naꞋa Ꞌuana na fadalana alaꞋanga tarifulaꞋanga neꞋe sulia na ngwae neꞋe tasali maga witi. ");
INSERT INTO kwf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ti ngwae neꞋe kira rongoa na faꞋarongoꞋanga sulia na ꞋInotoꞋanga God, ma noaꞋa kira kasi malingani, ꞋunaꞋeri sa Saetan ka leka maꞋi, ma ka laua naꞋa fatalana God faꞋasida neꞋe kira rongoa. Kira diꞋia na maga witi neꞋe kira Ꞌasida sulia na talalinga, ma na noꞋo ki kira ka Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma na maga witi neꞋe kira ꞋasiꞋi Ꞌi fafona ano neꞋe nia faula, nia diꞋia na ngwae neꞋe kira rongoa fatalana God, ma kira ka ngalia faꞋinia na saeleꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bore ma fatalana God noaꞋa kasi lalisusu goꞋo saena maurilada. Kira ka faꞋamamana goꞋo sulia kaidaꞋi tiꞋitiꞋi. Bore ma kaidaꞋi ilitoꞋonga ma faꞋakaisiꞋanga nia dao goꞋo maꞋi duꞋungana kira faꞋamamana ana fatalana God, ma kira kasi faꞋamamana naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma ti ngwae neꞋe kira diꞋia maga witi neꞋe kira Ꞌasida Ꞌi safitana na kwalo Ꞌabui ki. Kira rongoa na fatalana God, bore ma kira manata Ꞌabera Ꞌada sulia ru ki ana mauriꞋa kira, ma kira ka manata doe ana na mani. Ma ru neꞋeri ki, nia diꞋia na kwalo Ꞌabui ki nia nuku fafia na fatalana God saena maurilada. NoaꞋa kira kasi rokisi goꞋo saena maurilada ka diꞋia na witi neꞋe noaꞋa kasi fungu goꞋo Ꞌani ta fuaꞋi ru. ");
INSERT INTO kwf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma ti ngwae laꞋu neꞋe kira diꞋia na maga witi neꞋe kira Ꞌasida Ꞌi saena ta ano leꞋa. Kira rongoa fatalana God, ma kira ka malingani, ma kika faꞋataꞋinia tuaꞋa ꞋoloꞋolo ka diꞋia witi neꞋe nia fungu Ꞌani fuaꞋi ru ki. Ti witi neꞋe taꞋi talangaꞋi fuaꞋi ruꞋanga, ma ti witi neꞋe ono akwala fuaꞋi ruꞋanga, ma ti witi uulu akwala fuaꞋi ruꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa Jesus ka saea laꞋu taꞋi tarifulaꞋanga fuada, ka Ꞌuri, “Na ꞋInotoꞋanga God diꞋia na ngwae neꞋe ka fasia na maga ru ki saena na oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma ana taꞋi rodo, kaidaꞋi neꞋe ngwae ki kira maliu Ꞌada, na malimae ka leka maꞋi ma ka fasia ti maga laua taꞋa Ꞌi safitana na maga ru leꞋa ki. Sui nia ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma kaidaꞋi neꞋe maga ru leꞋa ki kira bulao maꞋi, ma kira ka talaꞋae fungu, na maga laua taꞋa ba kiri kira ka bulao logo. ");
INSERT INTO kwf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na ngwae ni rao nia ki, kira ka leka maꞋi siana, ma kika saefiloa Ꞌuri, ‘AraꞋi kwa, Ꞌoko fasia na maga ru leꞋa ki ba. Ma na laua loꞋoko ki niꞋi leka maꞋi faꞋasia Ꞌi fai?’ ");
INSERT INTO kwf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma nia ka olisida ka Ꞌuri, ‘Ta malimae naꞋa neꞋana nia sasia na ru neꞋeri.’ Ma na ngwae ni rao nia ki, kira ka saefiloa Ꞌuri, ‘ꞋOko oga mike leka ma kami ka failia na laua taꞋa neꞋe ki?’ ");
INSERT INTO kwf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nia ka olisida ka Ꞌuri, ‘NoaꞋa, Ꞌasu Ꞌubani ana kaidaꞋi kamu failia na laua loꞋoko ki, kamu kata faꞋalia logo ti Ꞌai leꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muke alu kera ke taꞋe fiku naꞋa adaroꞋo leleka ka dao ana kaidaꞋi ni goniruꞋa. Ma ana kaidaꞋi neꞋeri, nai baꞋa saea fuana na ngwae neꞋe kira gonia na ru nau ki, ku Ꞌuri: Muke lafua na laua ki Ꞌi naꞋo, ma kamu ka firi fikuda, ma kamu ka duꞋafia. Sui kamu ka fiꞋi lafua na ru leꞋa ki, ma kamu ka ngalia maꞋi Ꞌuana saena babala ni taingaꞋiꞋanga nau.’” ");
INSERT INTO kwf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui sa Jesus ka saea laꞋu taꞋi tarifulaꞋanga ka Ꞌuri, “Na ꞋInotoꞋanga God nia Ꞌuri: TaꞋi ngwae nia ngalia maga Ꞌai tiꞋitiꞋi liu neꞋe kira saea Ꞌani mastad, ma ka fasia Ꞌi saena na oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma sui bore Ꞌana na maga ru neꞋeri ka tiꞋitiꞋi liu ana na maga ru ki taꞋifau, kaidaꞋi nia taꞋe maꞋi, nia ka alua naꞋa na Ꞌai neꞋe doe ka liufia naꞋa na Ꞌai ki taꞋifau Ꞌi saena na oꞋola neꞋeri. Ma kaidaꞋi na Ꞌai neꞋe doe ka ulubono, na noꞋo ki kira ka saungaꞋinia na nuꞋi kira ki ana na rarana Ꞌai neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui sa Jesus ka fata laꞋu Ꞌani ta tarifulaꞋanga ka Ꞌuri, “Na ꞋInotoꞋanga God nia diꞋia na isi tiꞋitiꞋi fuana faꞋa ubulana na beret, neꞋe ta kini nia ngalia, ma ka dola faꞋinia flaoa Ꞌoro, leleka ka nongalia na kaꞋakaꞋa neꞋeri ka ubu, ma ka fane.” ");
INSERT INTO kwf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa Jesus ꞋidufaꞋi alaꞋa sulia na ru neꞋe ki taꞋifau goꞋo Ꞌani na tarifulaꞋanga ki fuana na fikuꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nia sasi ꞋunaꞋeri fasi Ꞌiri ka faꞋamamana na alaꞋanga God neꞋe profet nia keresia ka Ꞌuri, “Nau kui baꞋa fata Ꞌani tarifulaꞋanga ki fuana ngwae ki. Ma nai baꞋa fada na ru neꞋe ago ki Ꞌita naꞋa maꞋi ana kaidaꞋi nau ku saungaꞋinia naꞋa na magalia.” ");
INSERT INTO kwf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui sa Jesus ka faꞋasia naꞋa fikuꞋa neꞋeri ma ka ruꞋu saena luma. Ma na fafarongo nia ki kira ka dao maꞋi siana, ma kira ka fata Ꞌuri, “ꞋOke fada basi fuamiꞋa na tarifulaꞋanga ba sulia na laua neꞋeri ki saena na oꞋola.” ");
INSERT INTO kwf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nia ka olisida ka Ꞌuri, “Na ngwae neꞋe nia fasia na maga ru leꞋa ki, naꞋa neꞋe nauꞋa, na Ngela Ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma na oꞋola naꞋa neꞋe magalia, ma na maga ru leꞋa ki naꞋa neꞋe na ngwae God ki olofana ꞋInotoꞋanga nia. Ma na laua neꞋeri ki neꞋe na ngwae roꞋosulia sa Saetan ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma na malimae neꞋe nia fasia na laua ki, naꞋa neꞋe sa Saetan. Ma kaidaꞋi ana goniruꞋa naꞋa neꞋe Ꞌisilana na magalia, ma na ngwae neꞋe kira goniru naꞋa neꞋe na Ꞌainsel ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","KaidaꞋi neꞋe ngwae ni rao ki kira gonia na laua ki, ma kira ka duꞋafia Ꞌi saena na mafula, nia ka diꞋia logo ana Ꞌisilana na magalia. ");
INSERT INTO kwf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nai baꞋa kwatea Ꞌainsel ki, ma kira ka gonia ngwae ki taꞋifau neꞋe kira sasia ru taꞋa ki, ma na ngwae neꞋe kira faꞋarora naꞋa ngwae ki, ma na Ꞌainsel ki kira ka lafuda faꞋasia na ꞋinotoꞋanga nau. ");
INSERT INTO kwf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma kira ka Ꞌui Ꞌani kira Ꞌi saena mafula, kula neꞋe kira ke baꞋa angi, ma kira ka Ꞌala girigiria na lifada. ");
INSERT INTO kwf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aia, na ngwae saga ki, kira ka sina diꞋia na madaꞋafi saena na ꞋinotoꞋanga na MaꞋa kira. Muke manata leꞋa sulia na ru neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sa Jesus ka fata logo Ꞌuri fuana na fafarongo nia ki, “Na ꞋInotoꞋanga God nia diꞋia na mani doe neꞋe kira sofongani saena na oꞋola. Ma kaidaꞋi taꞋi ngwae lisia, nia ka sofongaꞋinia logo Ꞌana. Ma nia ka saeleꞋa liu, ma nia leka ma ka Ꞌoifoli Ꞌani na ru nia ki taꞋifau, ma ka folia naꞋa oꞋola neꞋeri, fasi Ꞌiri ka ngali Ꞌana mani doe neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma na ꞋInotoꞋanga God nia diꞋia logo na ngwae Ꞌoifoli neꞋe nia lulu Ꞌuana na fau ngwairoiro leꞋa ki neꞋe folilani doe liu. ");
INSERT INTO kwf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","KaidaꞋi nia dao toꞋona kala taꞋi fau ngwairoiro neꞋe liulana doe liu, nia ka leka, ka Ꞌoifoli Ꞌani na ru nia ki taꞋifau, ma ka fiꞋi folia. ");
INSERT INTO kwf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Na ꞋInotoꞋanga God nia diꞋia logo na furai neꞋe kira dee Ꞌani Ꞌi saena na asi, ma kira ka deea Ꞌani kwalukaela iꞋa matamata ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma kaidaꞋi nia fungu, na ngwae neꞋe kira dee ki kira olongaꞋinia Ꞌi sara, ma kira ka tua Ꞌi ano. Sui kira ka gonia naꞋa iꞋa leꞋa ki saena kukudu ki, ma kira ka Ꞌui Ꞌania na iꞋa taꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nia ka ꞋunaꞋeri logo ana Ꞌisilana na magalia. Na Ꞌainsel ki kike leka maꞋi, ma kira ka daroꞋia na ngwae taꞋa ki faꞋasia na ngwae leꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma na ngwae taꞋa ki, kira ka Ꞌui Ꞌanida Ꞌi saena na mafula, ma Ꞌi neꞋeri kira ka angi, ma kira ka Ꞌala girigiri Ꞌani lifada.” ");
INSERT INTO kwf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui sa Jesus ka saefiloda ka fata Ꞌuri, “Kaumulu saiana ru neꞋeri ki?” Ma kika olisia kira ka Ꞌuri, “ꞋIu.” ");
INSERT INTO kwf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma sa Jesus ka fata Ꞌuri fuada, “KamuꞋa na ngwae neꞋe nau ku faꞋamanata kamu naꞋa. ꞋUnaꞋeri kamu ka faꞋamanata Ꞌania alaꞋanga sulia ꞋInotoꞋanga God. Kamu sai leꞋa ana na KerekereꞋa Abu saena Fau AlangaꞋinga ꞋUa ma na fataꞋa faolu neꞋe nau ki.” ");
INSERT INTO kwf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ana kaidaꞋi sa Jesus nia alaꞋa Ꞌani tarifulaꞋanga neꞋeri ki ka sui, nia ka leka naꞋa faꞋasia maꞋe fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma nia ka oli laꞋu maꞋi ana maꞋe fanoa nia Ꞌi Nasaret. Ma nia ka leka Ꞌi saena luma fuana foꞋongaꞋa fuana faꞋamanatalana ngwae ki. Ma ana kaidaꞋi ngwae ki kira rongoa, kira ka Ꞌarefo liu, ma kira ka fata Ꞌuri, “Na ngasingasiꞋanga ana sa tai niniꞋa kwate nia ka faꞋamanata Ꞌania fatalana God Ꞌuri, ma faꞋinia sasilana na faꞋanadaꞋa ki? ");
INSERT INTO kwf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kulu sai goꞋo akulu ana neꞋe ngwae neꞋe, niaꞋa na ngela sa Josef goꞋo niniꞋa, na ngwae ni saiana saungaꞋilana ru ki Ꞌani Ꞌai ki, ma teꞋa nia Ꞌi Mary. Na ngwaefuta nia ki neꞋe sa James, sa Josef, sa Simon, ma sa Judas goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma na ngwaingwaena nia ki, kira tua goꞋo Ꞌada faꞋi kulu Ꞌi neꞋe. FaꞋuta neꞋe nia ka liatoꞋo liu Ꞌuri?” ");
INSERT INTO kwf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma ana kaidaꞋi neꞋeri, kira ka Ꞌaila Ꞌani sa Jesus. Sui sa Jesus ka fata Ꞌuri fuada, “Na profet nia ꞋafitaꞋi fuana ngwae futa nia ki faꞋinia na ngwae ana maꞋe fanoa nia ki, kira ka fuꞋusi doe ana niaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma sa Jesus noaꞋa kasi sasia na ru faꞋanadaꞋa Ꞌoro ki ana maꞋe fanoa nia, sulia na ngwae neꞋeri ki, kira Ꞌaila kasi faꞋamamana ana. ");
INSERT INTO kwf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma ana kaidaꞋi neꞋeri, sa Herod Antipas neꞋe ngwae tatalafaꞋa Ꞌi Galili, nia ka rongoa faꞋarongoꞋa sulia sa Jesus, ");
INSERT INTO kwf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma nia ka fata Ꞌuri fuana ngwae neꞋe kira rao faꞋinia ki, “Ngwae neꞋe, niaꞋa sa John ngwae ni siuabu nia mauri laꞋu! Nia niniꞋa ke sasia laꞋu na ru ni ꞋarefoꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ana kaidaꞋi sa John nia mauri Ꞌua, sa Herod neꞋe korea Ꞌi Herodias na Ꞌafe ngwaefuta nia sa Filip. Ma sa John ka balufia sa Herod ka Ꞌuri, “Na taki God noaꞋa kasi alafafia neꞋe Ꞌoke korea Ꞌafe ngwaefuta Ꞌoe.” Nia neꞋe sa Herod ka kwatea ti ngwae fasi Ꞌiri kika daua sa John, ma kira ka firiꞋia, ma kira ka alua saena luma ni lokafo. Sa Herod nia sasia ru neꞋe sulia na Ꞌafe nia Ꞌi Herodias neꞋe oga. ");
INSERT INTO kwf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ana kaidaꞋi sa John tua saena luma ni lokafo, sa Herod ka oga liu saungilana, bore ma nia maꞋu Ꞌani ngwae ki, sulia kira saea sa John niaꞋa ta ngwae ana profet ki. ");
INSERT INTO kwf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sui ana taꞋi asoa, sa Herod ka saungaꞋinia taꞋi fangaꞋa doe fuana manataꞋanga toꞋona faꞋi asoa nia futa ana. Ana fangaꞋa neꞋeri, na sariꞋi Ꞌi Herodias nia leka maꞋi ka ngwaꞋe fuana sa Herod faꞋinia kwaima nia ki fasi Ꞌiri kira ka ada ana. KaidaꞋi sa Herod ka lisia sariꞋi neꞋe nia ngwaꞋe, nia ka saeleꞋa liu faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma nia ka eta fataꞋa naꞋa fuana sariꞋi neꞋeri ka Ꞌuri, “Nai baꞋa kwatea ta tae goꞋo Ꞌana neꞋe Ꞌoko gani nau Ꞌuana.” ");
INSERT INTO kwf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aia, teꞋa na sariꞋi neꞋe ka alaꞋa fuana sariꞋi, nia ka fata Ꞌuri, “ꞋOke gani, Ꞌoko fata Ꞌuri, ‘Nau ku oga Ꞌoke kwatea maꞋi gwauna sa John ngwae ni Siuabu fuaku ana kaidaꞋi neꞋe naꞋa. ꞋOko alua maꞋi fafona ta taꞋe ru.’” Ma na sariꞋi neꞋe ka sasi ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma kaidaꞋi sa Herod ka rongoa ru neꞋe, nia ka kwaimanatai liu. Sui bore Ꞌana, nia ka sasia naꞋa Ꞌana, sulia nia eta fataꞋa naꞋa, ma na kwaima nia ki kira ka rongoa taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma nia ka kwatea ngwae rao nia ki ka leka kika siki musia maꞋi gwauna sa John ngwae ni Siuabu saena luma ni lokafo. ");
INSERT INTO kwf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma kira ka ngalia maꞋi gwauna sa John fafona taꞋe ru, ma kira ka kwatea naꞋa fuana sariꞋi Ꞌi Herodias. Ma na sariꞋi neꞋe ka ngalia ka kwatea naꞋa fuana teꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","KaidaꞋi na fafarongo sa John ki kira rongoa na ru neꞋe, kira leka maꞋi, kira ka ngalia nonina, kika kwaiatoa naꞋa saena na kilu gwaꞋu. Sui, kika leka kika faꞋarongoa sa Jesus Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ana kaidaꞋi sa Jesus nia rongo sulia na ru neꞋeri nia fuli fuana sa John, nia ka faꞋasia naꞋa kula neꞋeri, ma ka leka taꞋifili nia saena gwaꞋi baru Ꞌuana kula neꞋe noaꞋa ta ngwae kasi tua ana. Na ngwae ki kira rongoa ru neꞋe sa Jesus sasia, ma kira ka faꞋasia na fanoa kira ki, ma kika donga buri Ꞌana sulia tala. ");
INSERT INTO kwf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma kaidaꞋi sa Jesus koso ma ka lisia na fikuꞋa doe, nia ka kwaimanatai fuada, ma ka gura na ngwae neꞋe kira mataꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma ana saꞋulafi neꞋeri, na fafarongo nia ki kira leka maꞋi siana, ma kira ka fata Ꞌuri, “Kula neꞋe noaꞋa kasi tua karangia ta fanoa, ma nia karangi ka rodo naꞋa. ꞋOke kwatea na fikuꞋa neꞋe kika leka naꞋa Ꞌada, fasi Ꞌiri kira ka leka Ꞌuana na maꞋe fanoa ki Ꞌiri neꞋe kike foli fanga Ꞌada.” ");
INSERT INTO kwf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sa Jesus ka olisida ka Ꞌuri, “NoaꞋa kira kasi leka. Kaumulu neꞋe muke kwatea ta fanga fuada fuana Ꞌanilana.” ");
INSERT INTO kwf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma kira olisia kika Ꞌuri, “Kaimili toꞋo goꞋo ana lima afu beret ki ma ro gwaꞋi iꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma sa Jesus ka fata Ꞌuri fuada, “Muke ngaliꞋi maꞋi Ꞌi neꞋe siaku.” ");
INSERT INTO kwf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma nia ka kwatea na ngwae ki kira ka tua Ꞌi ano Ꞌi saena na karasi. Sui nia ka ngalia na lima afu beret ba kiri ma ro gwaꞋi iꞋa neꞋeri ki. Ma ka lia ꞋalaꞋa Ꞌuana Ꞌi langi, ma ka baꞋatafea God. Sui nia ka ngiia afu beret neꞋeri ki, ma ka kwatea fuada na fafarongo nia ki, ma kira ka daroꞋia fuada na ngwae neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na ngwae neꞋeri ki taꞋifau, kira ka fanga leleka kira ka abusu naꞋa. Sui na fafarongo nia ki kira ka gonia na fanga neꞋe ore ki Ꞌi saena taꞋi akwala ma ro kukudu, leleka niꞋi ka fungu taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma na ngwae ba kira fanga ki bolo faꞋinia lima toꞋoni ngwane, ma noaꞋa kira kasi toꞋomani goꞋo na kini ki ma na ngela ki. ");
INSERT INTO kwf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma Ꞌi buri Ꞌana ru neꞋeri, sa Jesus nia asungaꞋinia na fafarongo nia ki kira ka etaeta Ꞌuana ta bali ana Ꞌosi neꞋeri saena na baru. Ma nia ka tua buri fasi Ꞌiri ke saea fuana na fikuꞋa neꞋeri kira ka leka naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma buri Ꞌana neꞋe ngwae ki kira oli naꞋa, nia ka raꞋe taꞋifili nia gwauna taꞋi kula fane Ꞌiri nia ka foꞋo. Ma ana faꞋi rodo neꞋeri, nia ka tua Ꞌana taꞋifili nia Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma kaidaꞋi neꞋeri, neꞋe gwaꞋi baru baera ka tau naꞋa faꞋasia Ꞌi sara, ma na nafo ki ka kwaiꞋia sulia nia naꞋofia na iru. ");
INSERT INTO kwf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma ana kadi rodo Ꞌi Ꞌofodangi, sa Jesus ka fali naꞋa maꞋi Ꞌi fafona na kafo, ma ka leka naꞋa maꞋi fuada. ");
INSERT INTO kwf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma ana kaidaꞋi kira lisi nia ka fali maꞋi Ꞌi fafona na kafo, kira ka maꞋu liu. Ma kira ka ri Ꞌuri, “Na anoano ru!” Ma kira ka fai araarai. ");
INSERT INTO kwf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma ꞋaliꞋali goꞋo sa Jesus ka fata fuada ka Ꞌuri, “NoaꞋa kamu kasi maꞋu laꞋu! NauꞋa goꞋo niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma sa Peter ka olisia ka Ꞌuri, “Aofia Ꞌae, diꞋia ꞋaeꞋo mamana naꞋa neꞋana, Ꞌoke fata maꞋi Ꞌuaku Ꞌiri nau kui leka kwau Ꞌuamu Ꞌi fafona na kafo neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sa Jesus ka fata Ꞌuri, “ꞋIu, leka maꞋi.” Sui sa Peter ka koso faꞋasia na gwaꞋi baru, ma ka talaꞋae fali Ꞌi fafona na kafo Ꞌuana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sui ana kaidaꞋi nia ka lisia na iru doe, nia ka maꞋu ma ka talaꞋae ka kuru naꞋa Ꞌi saena na kafo. Ma nia ka ri ka Ꞌuri, “Aofia Ꞌae, Ꞌoke faꞋamauri nau!” ");
INSERT INTO kwf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma ka ꞋaliꞋali goꞋo sa Jesus ka kwate lima kwau Ꞌuana, ka dau ana niaꞋa, ma ka fata Ꞌuri, “Na fitoꞋonga Ꞌoe nia tiꞋitiꞋi liu. FaꞋuta neꞋe Ꞌoko manata ruarua ana nauꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma ana kaidaꞋi kera raꞋe naꞋa Ꞌi saena na gwaꞋi baru, na iru ka aroaro naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ꞋUnaꞋeri goꞋo na ngwae neꞋe kira tua Ꞌi saena na gwaꞋi baru ki, kira ka faꞋa aofia kika Ꞌuri, “ꞋAeꞋo naꞋa neꞋe Ngela God mamana naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma kaidaꞋi kira toꞋofolo saena Ꞌosi, kira ka koso naꞋa ana taꞋi maꞋe fanoa kira saea Ꞌani Genesaret. ");
INSERT INTO kwf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma na ngwae ana maꞋe fanoa neꞋeri ki, kira ka lia saiana sa Jesus. Ma kira ka kwate alaꞋanga fuana ti maꞋe fanoa laꞋu sulia sa Jesus, fasi Ꞌiri ngwae neꞋeri ki, kira ka baꞋea maꞋi ngwae mataꞋi kira ki ka leka maꞋi siana. Ma kira ka ngalia maꞋi ngwae mataꞋi Ꞌoro ki siana. ");
INSERT INTO kwf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma na ngwae ki ka gania sa Jesus fasi Ꞌiri ka alaꞋania na ngwae mataꞋi neꞋeri ki kira ka sama Ꞌada toꞋona Ꞌaena na ifi nia. Ma sa tai faꞋida neꞋe kira sama toꞋona ifi nia, kira ka Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui ti Farasi ma na faꞋamanata ana taki ki, kira ka leka maꞋi faꞋasia Ꞌi Jerusalem siana sa Jesus fuana saefilolana. ");
INSERT INTO kwf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kira ka fata Ꞌuri, “FaꞋuta neꞋe fafarongo Ꞌoe ki kasi roꞋosulia na faꞋamanataꞋanga neꞋe koꞋo bora kia ki alua naꞋa maꞋi fuaka, osiꞋana noaꞋa kira kasi taufia goꞋo na limada Ꞌi naꞋo, ma kira fiꞋi fanga?” ");
INSERT INTO kwf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sa Jesus ka olisida ka Ꞌuri, “KamuꞋa logo, faꞋuta neꞋe kamu ka sasi amuꞋa sulia faꞋamanataꞋanga kamu ki talamuꞋa, ma noaꞋa kamu kasi sasi sulia taki God ki? ");
INSERT INTO kwf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God fata Ꞌuri, ‘ꞋOke faꞋadoea na maꞋa Ꞌoe ma na teꞋa Ꞌoe.’ Ma ‘DiꞋia sa tai neꞋe nia taofia maꞋa nia nama teꞋa nia, kira ke saungia ka mae.’ ");
INSERT INTO kwf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bore ma, kamu faꞋamanata rora lala Ꞌuri, diꞋia ta ngwae nia toꞋo ana ti ru neꞋe nia saiana ke Ꞌafia Ꞌani maꞋa nia nama teꞋa nia, ma ka fata lala Ꞌuri, ‘Nai baꞋa kwatea naꞋa ru baera ki fuana God.’ ");
INSERT INTO kwf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kamu saea, nia leꞋa goꞋo Ꞌana fuana neꞋe nia kasi Ꞌafia naꞋa maꞋa nia ma na teꞋa nia Ꞌani ru baera ki ba nia eta fataꞋa Ꞌani fuana God. Ma diꞋia nia ꞋunaꞋeri, na faꞋamanataꞋanga neꞋe kamu alua, nia ka kware teꞋeteꞋe naꞋa ana fatalana God. ");
INSERT INTO kwf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma kaumulu ka saea kamu roꞋosulia God, ma noaꞋa nia kasi mamana goꞋo. Sa Aesea nia fata mamana kaidaꞋi ba nia alaꞋa suli kamu, diꞋia ba nia keresia neꞋe God fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na ngwaꞋi toꞋa neꞋe ki kira faꞋadoe nau goꞋo Ꞌada Ꞌani alaꞋanga kira ki, bore ma na manatada nia tau liu faꞋasi nau. ");
INSERT INTO kwf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kira foꞋosi nau ꞋoꞋo goꞋo Ꞌada, duꞋungana kira faꞋamanata goꞋo Ꞌada sulia taki kira ki talada, ma kira ka saea fasi taki God ki naꞋa neꞋeriꞋa!’” ");
INSERT INTO kwf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma sa Jesus ka saea maꞋi na ngwae Ꞌoro ki siana, ma ka fata Ꞌuri fuada, “Mulu fafarongo maꞋi fuaku, ma muke saiana. ");
INSERT INTO kwf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","NoaꞋa laꞋu ta ru neꞋe ta ngwae nia ke Ꞌania, neꞋe nia kwatea na suaꞋa fuana. NoaꞋa! Na alaꞋanga neꞋe ruꞋu maꞋi faꞋasia kwakwana ngwae lala neꞋe nia faꞋasua na maurilana ngwae.” ");
INSERT INTO kwf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui na fafarongo sa Jesus ki, kira ka leka maꞋi siana, kira ka fata Ꞌuri fuana, “Na ru ba Ꞌoko saeꞋe ki, na Farasi ki rongoa, ma na manatada noaꞋa kasi leꞋa sulia.” ");
INSERT INTO kwf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma sa Jesus ka olisida ka Ꞌuri, “God ke baꞋa faꞋalia na faꞋamanataꞋanga rora ki, osiꞋana neꞋe noaꞋa kasi leka maꞋi faꞋasi nia, diꞋia ta ngwae neꞋe nia failia na ru taꞋa neꞋe kira bulao maꞋi karangia ru neꞋe nia fasiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","NoaꞋa kamu kasi manata Ꞌabera Ꞌani Farasi neꞋeri ki. Sulia kira diꞋia goꞋo Ꞌada na ngwae maa rodo neꞋe nia talaꞋia logo ta ngwae maa rodo. Ma kamu ka sai logo ana, diꞋia ta ngwae neꞋe maana rodo ma ka talaꞋia logo ta ngwae neꞋe maana rodo, keraꞋa ka ꞋasidaroꞋo taꞋifau goꞋo Ꞌi saena mae kilu.” ");
INSERT INTO kwf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma sa Peter ka fata Ꞌuri fuana sa Jesus, “ꞋOke fada basi maꞋi na fadalana alaꞋanga ba Ꞌoko fiꞋi saeꞋe goꞋo maꞋi fuaimili ki.” ");
INSERT INTO kwf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sa Jesus ka olisia ka fata Ꞌuri, “Kaumulu fafarongo nau ki naꞋa, bore ma noaꞋa kamu kasi kwaꞋatafa Ꞌua logo diꞋia kiraꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","FaꞋuta neꞋe noaꞋa kamu kasi saiana ru neꞋe ki? ꞋIu, na ru neꞋe ta ngwae Ꞌania ke baꞋa leka daofaꞋi liu naꞋa Ꞌana Ꞌi saena ogana, ma Ꞌi buri nia ke baꞋa ruꞋu laꞋu goꞋo maꞋi Ꞌana faꞋasia saena nonina. ");
INSERT INTO kwf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bore ma ta alaꞋanga taꞋa neꞋe nia ruꞋu maꞋi faꞋasia kwakwana ngwae, nia Ꞌita maꞋi faꞋasia saena manatana ngwae. Na ru neꞋeri lala neꞋe ke faꞋasua na maurilana ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma ru taꞋa neꞋe ka ruꞋu maꞋi faꞋasia saena manatalana ngwae ki neꞋe Ꞌuri: saungwaeꞋa, kakabaraꞋanga, sasi taꞋangaꞋa faꞋinia ta ngwae, sokeꞋa fafia ta ngwae, bililana na ru ta ngwae, faꞋinia na alaꞋanga taꞋa sulia ta ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aia, ru neꞋeri ki saiana ka faꞋasua maurilana ngwae Ꞌi naꞋona God. Bore ma na tau limaꞋanga Ꞌi naꞋona fanga, diꞋia na falafala neꞋe koꞋo bora kia ki kira faꞋamanata kia maꞋi Ꞌani, sui bore Ꞌana ta ngwae noaꞋa kasi sasia sulia, na maurilana kasi taꞋa goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sa Jesus ka leka naꞋa faꞋasia na kula neꞋeri, ma ka leka naꞋa Ꞌuana na abaꞋi kula Ꞌi Taea ma Ꞌi Saedon. ");
INSERT INTO kwf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma taꞋi kini neꞋe noaꞋa laꞋu Jiu saena tuaꞋa Ꞌi Kenan ka leka maꞋi siana, ma ka ri Ꞌuri, “Aofia Ꞌae, Ꞌoe na Ꞌalako ana kwalafa sa David, Ꞌoke manatai nau maꞋi! Na anoꞋi ru taꞋa neꞋe nia ruꞋufia na defo nau, ma ka nonifii liu.” ");
INSERT INTO kwf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sa Jesus noaꞋa kasi olisia goꞋo Ꞌani ta alaꞋanga. Ma na fafarongo nia ki kira ka leka maꞋi siana sa Jesus, ma kira ka Ꞌuri, “ꞋOke baꞋea nia ka leka kwau Ꞌana, sulia nia donga kulu goꞋo Ꞌana, ma nia ka isi liu naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sa Jesus ka fata fuana kini neꞋeri ka Ꞌuri, “God kwate nau goꞋo maꞋi fuana na ngwae Jiu ki neꞋe kira diꞋia na sipsip neꞋe kira oꞋosi naꞋa Ꞌada ki.” ");
INSERT INTO kwf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui na kini neꞋeri ka leka maꞋi, ma ka bobo uruuru naꞋa Ꞌana Ꞌi naꞋona Ꞌaena ka Ꞌuri, “Aofia kwa, Ꞌoke kwaiꞋafi maꞋi aku!” ");
INSERT INTO kwf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sa Jesus ka olisia ka Ꞌuri, “NoaꞋa kasi saga fuana ngalilana na fanga ngela ki, ma ka Ꞌui Ꞌania fuana na kui ki.” ");
INSERT INTO kwf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na kini neꞋeri ka Ꞌuri, “ꞋIu. Bore ma na kui ki saiana kika Ꞌania goꞋo Ꞌada na ngisingisi fanga neꞋe Ꞌasia faꞋasia na tatafe na ngwae neꞋe kira sareda ki.” ");
INSERT INTO kwf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui sa Jesus ka olisia ka Ꞌuri, “Kini neꞋe Ꞌae, na faꞋamamanaꞋanga Ꞌoe nia doe liu! Ma na ru neꞋe Ꞌoko gania, nai kwatea fuamu.” Ma na defo nia ka Ꞌakwa naꞋa ana kaidaꞋi neꞋeri nama goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","KaidaꞋi sa Jesus nia leka maꞋi faꞋasia maꞋe fanoa neꞋeri, nia ka oli maꞋi sulia tala neꞋe liu ninimani Ꞌosi doe Ꞌi Galili. Ma nia ka raꞋe gwauna taꞋi ua, ma ka tua Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma ana kaidaꞋi neꞋeri, ngwae Ꞌoro liu ki kira ka leka maꞋi siana. Ma kira ka ngalia logo maꞋi ngwae Ꞌoro mataꞋi ki, ti ngwae Ꞌaeda ka mae ma na limada ka mae, ti ngwae maada ka rodo, ma ti ngwae kwakwada ka nonoto. Kira aluda Ꞌi naꞋona Ꞌaena sa Jesus, ma nia ka gurada, ma kira ka Ꞌakwa taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma na ngwae neꞋeri ki neꞋe kira fiku fuana bubuꞋa, kira ka Ꞌarefo liu ana kaidaꞋi kira lisia ngwae neꞋe kwakwada nonoto ki, ma kira ka alaꞋa laꞋu. Ma ngwae neꞋe Ꞌaeda mae ma na limada mae ki kira ka leꞋa laꞋu. Ma sa tai neꞋe noaꞋa kira kasi fali leꞋa, kira ka fali leꞋa naꞋa. Ma na ngwae neꞋe maada ka rodo, kira ka lia laꞋu. Ma sulia neꞋe kira lisia ru neꞋeri ki, kira fiꞋi auraꞋea God Ꞌi Israel. ");
INSERT INTO kwf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui sa Jesus ka saea maꞋi na fafarongo nia ki siana, ka Ꞌuri fuada, “Nau ku kwaimanatai liu fuana ngwae neꞋe ki, osiꞋana kira tua faꞋi kulu sulia uulu asoa ki ka sui naꞋa, ma na fanga kira ki ka sui naꞋa. Ma noaꞋa nau kusi oga olitaꞋilada Ꞌuana fanoa kira ki ana kaidaꞋi kira fiolo Ꞌuri, Ꞌasu Ꞌubani ta ngwae Ꞌada kata ngwataꞋutaꞋu, ma ka maefelo sulia tala.” ");
INSERT INTO kwf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na fafarongoa nia ki olisia kira ka fata Ꞌuri fuana, “Saena fanoa gwaꞋu Ꞌuri kulu ke baꞋa dao toꞋona na fanga Ꞌi faꞋi Ꞌiri ka bolo faꞋinia ngwae Ꞌoro Ꞌuri kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma sa Jesus ka saefilo kira ka Ꞌuri, “Fita afu beret ki neꞋe kamu toꞋo ana?” Fafarongo nia ki olisia kira ka fata Ꞌuri fuana, “Fiu afu ru ki goꞋo, faꞋinia bara gwaꞋi iꞋa goꞋo neꞋe kami toꞋo ana.” ");
INSERT INTO kwf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ana kaidaꞋi neꞋeri, sa Jesus ka saea ngwae ki kira ka tua Ꞌi ano. ");
INSERT INTO kwf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui, nia ka ngalia fiu afu beret ki faꞋinia gwaꞋi iꞋa neꞋeri ki, ka baꞋatafea God. Sui nia ka ngiia, ma ka kwatea fuana fafarongo nia ki, Ꞌiri kira ka daroꞋia fuana ngwae neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ngwae neꞋeri ki, kira fanga taꞋifau, ma kira ka abusu. Buri Ꞌana kira fanga ka sui, na fafarongo ki kira ka faꞋafungua fiu kukudu ki Ꞌani orengana fanga neꞋe ore. ");
INSERT INTO kwf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ngwae neꞋe kira Ꞌania fanga neꞋeri, kira fai toꞋoni ngwane ki. NoaꞋa kira kasi toꞋomani goꞋo na kini ma na ngela ki. ");
INSERT INTO kwf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aia, ma buri Ꞌana kira fanga ka sui naꞋa, sa Jesus ka fiꞋi olitaꞋinida Ꞌuana Ꞌi fanoa kira ki. Ma nia faꞋinia na fafarongo nia ki, kira ka koso, ma kika raꞋe saena taꞋi gwaꞋi baru, kira ka leka Ꞌuana maꞋe fanoa kira saea Ꞌani Magadan. ");
INSERT INTO kwf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aia, ti Farasi faꞋinia ti Sadusi, kira ka leka maꞋi siana sa Jesus Ꞌiri kika ilitoꞋona goꞋo Ꞌada, ma kira ka saefiloa fasi Ꞌiri nia ka fulia ta faꞋanadaꞋa Ꞌiri ka faꞋataꞋinia God neꞋe asungaꞋi nia ka leka maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sa Jesus ka olisida ka fata Ꞌuri fuada, “Ana kaidaꞋi neꞋe sina ka suu, diꞋia kamu lisia neꞋe gwaꞋi salo ki niꞋi meo, kamu saiana uta noaꞋa kasi toꞋo rorodo. ");
INSERT INTO kwf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ꞋIu, ma Ꞌi Ꞌofodangi, diꞋia kamu lisia neꞋe gwaꞋi salo ki niꞋi meo ma ka goa, kamu ke saiana logo neꞋe uta ke baꞋa toꞋo. Kamu saiana lisilana mamanga, bore ma noaꞋa kamu kasi lia saiana ru neꞋe God fulia ana kaidaꞋi neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kamu ngwae taꞋena neꞋe kamu sasia ru taꞋa Ꞌoro ki, ma noaꞋa kamu kasi faꞋamamana goꞋo ana God. Kamu ka oga lisilana faꞋataꞋinga ki. Bore ma nau noaꞋa kusi baꞋa sasi goꞋo ta faꞋanadaꞋa fuamuꞋa. Na faꞋanadaꞋa neꞋe nau ku sasia fuana kamu ka lisia goꞋo neꞋe na faꞋanadaꞋa neꞋe nia fuli fuana na profet sa Jona Ꞌi naꞋo.” Buri Ꞌana sa Jesus nia fata ꞋunaꞋeri ka sui, nia ka leka naꞋa Ꞌana faꞋasi kira. ");
INSERT INTO kwf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ana kaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira toꞋofolo Ꞌuana na bali Ꞌosi loꞋoko, na fafarongo nia ki noaꞋa kasi toꞋo ana ta beret, osiꞋana neꞋe kira manata bura Ꞌani ngalilana faꞋi kira. ");
INSERT INTO kwf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma sa Jesus ka fata Ꞌuri fuada, “Kamu ke lia leꞋa suli kamu faꞋasia na isi fuana beret ana Farasi ki ma na Sadusi ki logo.” ");
INSERT INTO kwf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma ana kaidaꞋi neꞋe fafarongo nia ki kira rongoa na alaꞋanga neꞋeri ki, kira ka fata naꞋa Ꞌada sulia Ꞌi safitana kira taꞋifilida, ma sulia kira fia fasi sa Jesus nia ka fata sulia beret mamana, ma kira ka Ꞌuri, “Sali sa Jesus nia fata ꞋunaꞋeri, osiꞋana neꞋe noaꞋa kulu Ꞌiri ngalia maꞋi ta beret taka niniꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma osiꞋana sa Jesus nia sai goꞋo ana manatalana na fafarongo nia ki, nia ka fata Ꞌuri, “FaꞋuta neꞋe kamu ka manata Ꞌabera liu sulia neꞋe kamu kasi ngalia maꞋi ta beret? Na faꞋamamanaꞋanga kaumulu ki tiꞋitiꞋi liu! ");
INSERT INTO kwf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","NoaꞋa kamu kasi malingaꞋinia Ꞌua na manatai ngwae saena na ru nini nau ku saea fuamuꞋa? Ma kamu manata bura naꞋa Ꞌani lima afu beret ba nau ku sarea Ꞌani lima toꞋoni ngwae ki, ma kamu ka faꞋafungua kukudu Ꞌoro Ꞌani fanga ba ore ki. ");
INSERT INTO kwf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sali bore kamu manata bura naꞋa logo Ꞌani fiu afu beret ki goꞋo ba nau ku sarea Ꞌani fai toꞋoni ngwae ki, ma kamu ka faꞋafungua kukudu Ꞌoro ba kiri Ꞌani fanga neꞋe ore ki. ");
INSERT INTO kwf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","FaꞋuta neꞋe noaꞋa kamu kasi saiana tae neꞋe nau ku fata sulia? NoaꞋa laꞋu na beret neꞋe nau ku fata sulia. Tae neꞋe nau ku saea naꞋa neꞋe kamu ke madafi kamu faꞋasia na isi neꞋe ke faꞋa ubua na beret na Farasi ki ma na Sadusi ki.” ");
INSERT INTO kwf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Buri Ꞌana nia fata ꞋunaꞋeri ka sui, na fafarongo ki kira fiꞋi saiana tae neꞋe sa Jesus nia fata sulia. Nia fata lala sulia na faꞋamanataꞋanga Farasi ki ma na Sadusi ki. ");
INSERT INTO kwf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","KaidaꞋi sa Jesus nia dao ana na abaꞋi kula Ꞌi Sesarea Filipae, nia ka saefiloa na fafarongo nia ki ka Ꞌuri, “ꞋUri ma ngwae ki kira sae nau, Ngela Ngwae, Ꞌani sa tai?” ");
INSERT INTO kwf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kira olisia kika Ꞌuri, “Ti ngwae kira saeꞋo Ꞌani sa John ngwae ni Siuabu neꞋe nia mauri laꞋu, ma ti ngwae kira saeꞋo Ꞌani sa Elaeja neꞋe nia mauri laꞋu. Ma ti ngwae laꞋu kira ka saeꞋo Ꞌania sa Jeremaea nama ta ngwae ana profet ki neꞋe nia mauri laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui sa Jesus ka saefiloda ka Ꞌuri, “ꞋIrai ma kaumulu mo, kamu sae nau mo Ꞌani sa tai?” ");
INSERT INTO kwf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma sa Simon Peter ka olisia ka Ꞌuri, “ꞋAeꞋo naꞋa neꞋe na Christ, na ngwae God nia filia fuana faꞋamaurilana ngwae nia ki, na Ngela God neꞋe mauri firi.” ");
INSERT INTO kwf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma sa Jesus ka fata Ꞌuri, “Simon na ngela sa John Ꞌae, nia ꞋoilakiꞋa fuamu. Sulia ta ngwae kasi faꞋataꞋinia ru neꞋe fuamu. Bore ma na maꞋa nau Ꞌi langi neꞋe nia faꞋataꞋinia fuamu. ");
INSERT INTO kwf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma nau ku saea fuamu, Ꞌoe sa Peter, neꞋe fadalana ba na fau, ka diꞋia na fau neꞋe kira saungaꞋinia na luma fafona. Nai alu ꞋaeꞋo ta ngwae lalifu neꞋe Ꞌoke faꞋangasingasia ngwae neꞋe kira ke baꞋa faꞋamamana aku ki. Ma na ngasingasilana maeꞋa noaꞋa kasi bolo faꞋinia liufilada. ");
INSERT INTO kwf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma nau ku kwatea ngasingasiꞋanga fuamu neꞋe nia diꞋia na kii ana sina maa ana GwaungaꞋi Ꞌanga God. Fuana ta tae neꞋe Ꞌoko luia ngwae ki noaꞋa kasi sasia saena magalia, God ka alafafia logo fatalamu Ꞌi langi. Ma ta tae neꞋe Ꞌoko alaꞋania ngwae ki ka sasi Ꞌi saena magalia, God ka alaꞋania logo maꞋi Ꞌi langi.” ");
INSERT INTO kwf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui sa Jesus ka fata totongaꞋi fuana na fafarongo nia ki, Ꞌiri noaꞋa kira kasi faꞋarongoa ta ngwae fasi niaꞋa neꞋe na Christ. ");
INSERT INTO kwf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ꞋIta ana kaidaꞋi neꞋeri ka leka, sa Jesus ka talaꞋae ana fata faꞋamadakolana fuana na fafarongo nia ki ka Ꞌuri, “Nai leka nama Ꞌuana Ꞌi Jerusalem. Ma na ngwae faꞋinaꞋonaꞋo ki, ma na fata abu doe ki, ma na ngwae faꞋamanata ana taki ki, kike baꞋa faꞋafii nau, ma kike saungi nau. Ma ana uulu faꞋi asoa, God ke baꞋa taꞋe nau laꞋu Ꞌuana na mauriꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma sa Peter ka talaꞋia kwau, ma ka balufia ka Ꞌuri, “Aofia Ꞌae, God luia! Na ru neꞋe ki, noaꞋa kasi fuli fuamu!” ");
INSERT INTO kwf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma sa Jesus ka kakari abula, ma ka fata Ꞌuri fuana sa Peter, “Saetan Ꞌae, leka tau kwau Ꞌamu faꞋasi nau! ꞋOko uu sauli nau. Sulia neꞋe manatalamu Ꞌita maꞋi faꞋasia na ngwae ki goꞋo Ꞌana, ma noaꞋa laꞋu faꞋasia God.” ");
INSERT INTO kwf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui sa Jesus ka fata Ꞌuri fuana na fafarongo nia ki, “Sa tai bore Ꞌana neꞋe oga ke donga nau, noaꞋa nia kasi manata Ꞌabera sulia ru nia ogaꞋi ki goꞋo Ꞌana talana. Nia ke donga nau lala Ꞌana, ana kaidaꞋi nia ke nonifii, ma ke mae ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa tai bore Ꞌana neꞋe Ꞌaila kasi donga nau duꞋungana nia oga ke sasi Ꞌana sulia kwaiogaiꞋanga nia ki talana, nia ke baꞋa talafia na mauriꞋa firi. Bore ma diꞋia sa tai bore Ꞌana neꞋe ke mae fuaku, nia ke toꞋo ana mauriꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","DiꞋia neꞋe ta ngwae ka toꞋo ana ru Ꞌoro saena magalia neꞋe, ma nia ka mae, ma nia ka tua tau faꞋasia God, ru neꞋeri kasi fulia goꞋo ta leꞋangaꞋa fuana. NoaꞋa ta ngwae kasi totolia folilana na mauriꞋa firi Ꞌani ta mani. ");
INSERT INTO kwf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nau ku saea ru neꞋe osiꞋana nauꞋa, na Ngela Ngwae, nai baꞋa leka maꞋi faꞋinia na Ꞌainsel nau ki, ana ꞋInotoꞋanga na MaꞋa nau, ma nai baꞋa kwatea na kwaiaraꞋa nama na kwaꞋikwaꞋinga fuana na ngwae ki taꞋifau, osiꞋana na ru neꞋe kira sasia. ");
INSERT INTO kwf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ru mamana nau ku saea fuamuꞋa, ti ngwae aumulu noaꞋa kira kasi mae leleka kira ka lisia nau ku dao maꞋi, ma nau ku gwaungaꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na ono faꞋi asoa ki Ꞌi buri, sa Jesus ka talaꞋia sa Peter, ma na ro ngwae asina ki sa James ma sa John taꞋifilida Ꞌuana Ꞌi gwauna taꞋi faꞋi ua neꞋe fane. ");
INSERT INTO kwf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma kaidaꞋi kira lia kwau, kira ka lisia naꞋa maana sa Jesus nia rokisi. Na maana ka ngwasinasina diꞋia na sina, ma na ifi nia ki ka kwao liu. ");
INSERT INTO kwf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma na uulu ngwae fafarongo neꞋe ki, kira ka lisia sa Moses faꞋinia sa Elaeja kera alaꞋa adaroꞋo faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma sa Peter ka fata Ꞌuri kwau fuana sa Jesus, “Aofia Ꞌae, nia leꞋa liu neꞋe kulu ka tua naꞋa akulu Ꞌi neꞋe. DiꞋia Ꞌoko oga, nai saungaꞋinia ta uulu babala, ta ai fuamu, ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” ");
INSERT INTO kwf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma ana kaidaꞋi sa Peter nia fata goꞋo Ꞌana Ꞌua ꞋunaꞋeri, taꞋi gwaꞋi salo neꞋe ngwasinasina liu uku maꞋi, ma nunufilana ka buta fafida, ma kira ka rongoa naꞋa lingalinga Ꞌi ru nia fata maꞋi Ꞌuri faꞋasia saena na gwaꞋi salo neꞋeri, “Na ngela mutaꞋi nau niniꞋa neꞋe nau ku alafe liu naꞋa ana. Nau ku saeleꞋa faꞋinia. Kamu ke rongo sulia niaꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma kaidaꞋi neꞋe fafarongo nia ki kira rongoa naꞋa lingalinga Ꞌi ru neꞋe, kira ka maꞋu liu, ma kira ka teo naꞋa Ꞌada fafia na maada Ꞌi ano. ");
INSERT INTO kwf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma sa Jesus ka dao maꞋi siada, ma ka sama toꞋoda, ka fata Ꞌuri, “Muke tataꞋe. NoaꞋa kamu kasi maꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma ana kaidaꞋi kira lia kwau, noaꞋa kira kasi lisia naꞋa ta ngwae, bore ma taꞋifilia sa Jesus goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma ana kaidaꞋi kira koso maꞋi faꞋasia Ꞌi gwauna faꞋi ua neꞋeri, sa Jesus ka fata totongaꞋi fuada ka Ꞌuri, “NoaꞋa kamu kasi faꞋarongoa ta ngwae ana ru niniꞋa kamu lisiꞋi ki, leleka ka dao ana kaidaꞋi God ke taꞋe nau, na Ngela Ngwae, faꞋasia na maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Uulu fafarongo nia ki saefiloa kira ka Ꞌuri, “FaꞋuta neꞋe faꞋamanata ana taki ki kira saea sa Elaeja ke baꞋa oli laꞋu maꞋi, sui mala na ngwae ba God filia ka fiꞋi leka maꞋi?” ");
INSERT INTO kwf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sa Jesus ka olisida ka Ꞌuri, “Nia mamana. Sa Elaeja neꞋe ke eta oli naꞋa maꞋi, Ꞌiri ka Ꞌafia ngwae ki fuana na sasi akaꞋu Ꞌanga. ");
INSERT INTO kwf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma nau ku saea laꞋu fuamuꞋa, sa Elaeja nia dao maꞋi ka sui naꞋa. Bore ma na ngwae ki noaꞋa kasi lia sai goꞋo ana. Nia neꞋe, kira ka sasia goꞋo Ꞌada ru taꞋa ki ana niaꞋa sulia na kwaiogaiꞋanga kira ki. Ma kike baꞋa sasi ꞋunaꞋeri logo ana nauꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ana kaidaꞋi uulu fafarongo neꞋeri ki kira rongoa, kira fiꞋi saiana neꞋe sa Jesus alaꞋa fuada sulia sa John ngwae ni Siuabu. ");
INSERT INTO kwf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","KaidaꞋi sa Jesus faꞋinia uulu fafarongo nia ki kira koso maꞋi Ꞌuana Ꞌaena ua neꞋeri, na ngwae Ꞌoro ki kira fiku naꞋa, ma taꞋi ngwae ka leka maꞋi, ka bobo uruuru Ꞌi naꞋona Ꞌaena sa Jesus, ma ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Aofia Ꞌae, Ꞌoke manataia maꞋi na ngela ngwane nau, osiꞋana neꞋe na noꞋomae nia saungia. Na mataꞋinga neꞋe sasi ma nia ka boleboleꞋa, ma ana kaidaꞋi Ꞌoro nia Ꞌui Ꞌani niaꞋa naꞋa saena mafula, ma Ꞌi saena kafo logo. ");
INSERT INTO kwf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau ku ngalia maꞋi fuana fafarongo Ꞌoe ki. Bore ma nia ꞋafitaꞋi liu fuada fuana guralana.” ");
INSERT INTO kwf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sa Jesus ka fata Ꞌuri fuada, “KamuꞋa manatamuꞋa ngasi liu, ma ngwae taꞋa ki! NoaꞋa kamu kasi faꞋamamana nau Ꞌua! Nau ku noni maruku naꞋa Ꞌani abu fitoꞋonga nini kamu. Nau ku tua faꞋi kamu ka dao naꞋa Ꞌuri, fuila kaumulu ka faꞋamamana nau naꞋa.” Sui nia ka fata Ꞌuri fuana ngwae neꞋeri, “ꞋOke ngalia maꞋi na ngela Ꞌoe Ꞌi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma sa Jesus ka fata totongaꞋi fuana na anoꞋi ru taꞋa neꞋeri, ma nia ka leka faꞋasia ngela neꞋeri. Ma na ngela neꞋeri ka Ꞌakwa naꞋa ana kaidaꞋi neꞋeri nama goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sui, kaidaꞋi kira tua taꞋifilida, na fafarongo ki leka maꞋi siana sa Jesus, ma kira ka saefiloa kika Ꞌuri, “FaꞋuta neꞋe nia ꞋafitaꞋi fuaimili fuana ifulangaꞋilana na anoꞋi ru taꞋa baera kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma sa Jesus olisida ka fata Ꞌuri, “Nia ꞋunaꞋeri, osiꞋana neꞋe faꞋamamanaꞋanga kaumulu nia olidoko liu. Ma nau ku saea fuamuꞋa, diꞋia na faꞋamamanaꞋanga kaumulu ana God doe ka diꞋia bore Ꞌana na maga Ꞌai tiꞋitiꞋi neꞋe kira saea Ꞌani mastad, kaumulu saiana muke sasia goꞋo Ꞌaumulu na tae neꞋe nia ka ꞋafitaꞋi. DiꞋia nia ꞋunaꞋeri, faꞋi ua loꞋoko bore, kamu ka Ꞌidua faꞋasia fuila Ꞌani fatalaumulu. Ma diꞋia kamu faꞋamamana ana ngasingasiꞋanga ana God, noaꞋa ta ru kasi ꞋafitaꞋi fuana muke sasia.” ");
INSERT INTO kwf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma ana kaidaꞋi fafarongo nia ki kira fiku maꞋi Ꞌi Galili, sa Jesus ka fata Ꞌuri fuada, “NauꞋa, na Ngela Ngwae, kike baꞋa kwate nau fuana malimae nau ki, ");
INSERT INTO kwf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ꞌiri kira ka saungi nau. Bore ma ana uulu faꞋi asoa, God ke baꞋa taꞋe nau laꞋu Ꞌuana mauriꞋa.” Ma kaidaꞋi fafarongo ki kira rongoa sa Jesus nia fata ꞋunaꞋeri, kira ka kwaimanatai liu. ");
INSERT INTO kwf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ana kaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira leka maꞋi Ꞌuana fanoa Ꞌi Kapaneam, na ngwae kira goni mani ana takisi fuana Luma Abu God ki, kira leka maꞋi siana sa Peter, ma kira ka saefiloa, “ꞋUri ma ngwae faꞋamanata kaumulu saiana ka kwatea logo mani neꞋe kami liu fuana gonilana fuana Luma Abu God?” ");
INSERT INTO kwf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma sa Peter olisida ka Ꞌuri, “ꞋIu, nia saiana ka kwatea.” Ma kaidaꞋi sa Peter ka ruꞋu saena luma, sa Jesus eta saefiloa basi ka Ꞌuri, “Simon Ꞌae, Ꞌoko manata faꞋuta? Tai naꞋa neꞋe tatalafaꞋa ana magalia saiana ka ngalia mani faꞋasida? Na ngela kira ki talada, nama faꞋasia ngwae kwaita ki?” ");
INSERT INTO kwf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sa Peter olisia ka Ꞌuri, “FaꞋasia ngwae kwaita ki.” Ma sa Jesus ka Ꞌuri, “Nia ꞋunaꞋeri, na ngela kira ki noaꞋa kasi kwatea goꞋo na takisi neꞋe. Nia neꞋe, diꞋia nau noaꞋa kusi kwatea bore na takisi fuana Luma Abu na MaꞋa nau, nia leꞋa goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma sui bore Ꞌana ka ꞋunaꞋeri, noaꞋa kasi leꞋa kulu ka faꞋalia na manataꞋanga kira ki fuakulu. ꞋOke leka Ꞌi saena Ꞌosi, Ꞌoko aꞋoa maꞋi. Na gwaꞋi iꞋa neꞋe Ꞌoko eta lafua, Ꞌoko Ꞌifingia kwakwana, Ꞌoke baꞋa lisia mani neꞋe bolo faꞋi koro fuana folilana takisi fuana taꞋi faꞋi ngali. Ngalia mani neꞋeri, ma Ꞌoko kwatea fuada.” ");
INSERT INTO kwf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana kaidaꞋi neꞋeri, na fafarongo sa Jesus ki kira leka maꞋi siana, ma kira ka saefiloa kira ka Ꞌuri, “ꞋUri ma? KaidaꞋi God ke baꞋa gwaungaꞋi, sa tai ana kaimili neꞋe ke ꞋinotoꞋa ka tasa kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ana kaidaꞋi neꞋeri, sa Jesus ka saea maꞋi taꞋi kala ngela siana, ma ka faꞋauua Ꞌi safitada. ");
INSERT INTO kwf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma nia ka fata Ꞌuri, “Ru mamana nau ku saea fuaumulu, diꞋia kamu ka olisia na abulaꞋanga kamu, ma kamu ka faꞋatiꞋitiꞋi kaumulu talamuꞋa diꞋia kala ngela ki, kamu totolia fuana God ka gwaungaꞋi fafi kamu. ");
INSERT INTO kwf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma sa tai neꞋe ka faꞋatiꞋitiꞋi nia Ꞌi talana diꞋia kala ngela neꞋe, nia ke ꞋinotoꞋa kaidaꞋi God ke gwaungaꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","DiꞋia sa tai neꞋe Ꞌoko kwaloa ta ngela Ꞌuri duꞋungana neꞋe nia faꞋamamana nau, Ꞌoko kwalo nau laꞋu goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“DiꞋia ta ngwae ka kwatea ngwae niniꞋa kira enoeno ki ka Ꞌasi faꞋasia fitoꞋonga kira aku, nia leꞋa fuana kike firiꞋia ta fau doe Ꞌi luana, ma kika Ꞌui Ꞌania Ꞌi saena na Ꞌatako. ");
INSERT INTO kwf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwaimanatai fuana ngwae Ꞌi saena magalia sulia ru Ꞌoro fuana faꞋaroralada niꞋi ke baꞋa leka talau. Ma kwaimanatai liu fuana ngwae neꞋe ke baꞋa sasia ru neꞋeri ki fasi Ꞌiri ka kwatea ngwae ki ka Ꞌasi faꞋasia fitoꞋonga kira aku. ");
INSERT INTO kwf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ma diꞋia limamu nama Ꞌaemu kwate Ꞌoko Ꞌasi faꞋasia fitoꞋonga Ꞌoe aku, Ꞌoke siki muusia faꞋasiꞋo. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko tua tau Ꞌamu saena mauriꞋa Ꞌi langi faꞋinia na ngurunguru lima nama ngurunguru Ꞌae, Ꞌasu Ꞌubani Ꞌoko fiꞋi koso Ꞌi saena kula ana kwaꞋikwaꞋinga faꞋinia ro lima ki nama ro Ꞌae ki, kula neꞋe mafula nia duꞋaduꞋa kasi mae. ");
INSERT INTO kwf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma diꞋia maamu kwate Ꞌoko Ꞌasi faꞋasia fitoꞋonga Ꞌoe aku, Ꞌoke lafua Ꞌamu faꞋasiꞋo, ma Ꞌoke toꞋosia. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko ruꞋu Ꞌi saena mauri Ꞌi langi faꞋinia taꞋi bali maa, Ꞌasu Ꞌubani Ꞌoko fiꞋi koso Ꞌi saena kula ana mafula neꞋe noaꞋa kasi mae faꞋinia ro bali maa ki.” ");
INSERT INTO kwf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa kamu kasi silolongaꞋinia na kala ngela neꞋe ki. Sulia neꞋe Ꞌainsel kira ki faꞋarongoa Ꞌani God na MaꞋa nau Ꞌi langi, sulia tae neꞋe kamu sasi ada. ");
INSERT INTO kwf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma diꞋia ta ngwae ka toꞋo ana taꞋi talangaꞋi sipsip, ma taꞋi ai ada ka oꞋosi naꞋa, ma tae neꞋe ngwae neꞋe ke baꞋa sasia? Ngwae neꞋe ke baꞋa faꞋasia siko akwala ma siko sipsip ki ana kula kira fanga ana, ma ka leka ka lulu Ꞌuana taꞋi sipsip neꞋe nia oꞋosi ma ka noꞋana. ");
INSERT INTO kwf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","KaidaꞋi nia dao naꞋa toꞋona, nia saeleꞋa ka tasa liufia naꞋa saeleꞋanga nia faꞋinia na sipsip neꞋe kira tua goꞋo Ꞌada faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na MaꞋa kamu maꞋi langi, nia ka manata logo ꞋunaꞋeri, sulia noaꞋa nia kasi oga fuana ta kala ngela ana neꞋe ka funu sulia na abula taꞋangaꞋa nia ki.” ");
INSERT INTO kwf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sa Jesus ka fata Ꞌuri fuana na fafarongo nia ki, “DiꞋia neꞋe toꞋolamu sasia ta ru ka rora fuamu, Ꞌoke leka siana, Ꞌoko faꞋarongoa Ꞌani na roraꞋa nia Ꞌi safitamuroꞋo taꞋifili koroꞋo. Ma diꞋia nia ka fafarongo fuamu, moro ka kwaima laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma diꞋia nia kasi fafarongo fuamu, Ꞌoko talaꞋia ta taꞋi ngwae nama ta ro ngwae laꞋu faꞋi Ꞌoe, Ꞌiri kera ka faꞋamamana ru ki taꞋifau neꞋe Ꞌoko saea, fasi Ꞌiri Ꞌoko sasi sulia na KerekereꞋa Abu ba saea, ‘Na ro ngwae nama ta uulu ngwae fasi Ꞌiri kira ka faꞋamamana na alaꞋanga neꞋe nia saea.’ ");
INSERT INTO kwf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma diꞋia noaꞋa nia kasi ala goꞋo fafia fata faꞋamamana Ꞌanga kira, Ꞌoko faꞋarongoa Ꞌani na fikutaꞋi ngwae God ki. Ma diꞋia neꞋe fikutaꞋi ngwae God ki bore, nia kasi fafarongo goꞋo fuada, Ꞌoko alua Ꞌi maa faꞋasia fiku taꞋi ngwae kamu ka diꞋia na ngwae kira kina God, nama ta ngwae taꞋa neꞋe nia gonia na mani ana takisi. ");
INSERT INTO kwf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ru mamana nau ku saea fuamuꞋa, ta tae neꞋe kamu luia ngwae ki noaꞋa kasi sasi saena magalia, God alafafia logo Ꞌi langi. Ma ta tae neꞋe kamu alaꞋania ngwae ki ka sasi Ꞌi saena magalia, God alaꞋania logo maꞋi Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nau ku saea laꞋu fuaumulu, diꞋia ta ro ngwae ana kaumulu kera ka alafafia ta ru Ꞌi saena magalia, ma kera ka foꞋo Ꞌuana, na MaꞋa nau Ꞌi langi nia ke baꞋa kwatea fuadaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sulia diꞋia ta ro ngwae nama ta uulu ngwae kira fiku ana ta kula, osiꞋana kira faꞋamamana nau, nau ku tua logo Ꞌi neꞋeri faꞋi kira.” ");
INSERT INTO kwf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sa Peter dao siana sa Jesus, ma ka saefiloa ka Ꞌuri, “Aofia Ꞌae, ta fita kaidaꞋi neꞋe nau ku saiana nai rufuanata ana toꞋolaku, kaidaꞋi nia ka sasia ta ru ka taꞋa fuaku? Nia leleka ka dao ana fiu kaidaꞋi ki?” ");
INSERT INTO kwf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma sa Jesus ka olisia ka Ꞌuri, “Nau ku saea fuamu, noaꞋa laꞋu fiu kaidaꞋi ki, bore ma ana kaidaꞋi ki taꞋifau goꞋo neꞋe Ꞌoke rufuanata ana. ");
INSERT INTO kwf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nau ku saea ꞋunaꞋeri osiꞋana gwaungaꞋi Ꞌanga God diꞋia ta ngwae tatalafaꞋa neꞋe nia oga na faꞋasagalana na ngali langaꞋanga ki faꞋinia na ngwae rao nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aia, na etana ngwae ni rao ka dao maꞋi neꞋe nia ngali langa ana moleꞋe mani. ");
INSERT INTO kwf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma na ngwae ni rao neꞋeri noaꞋa kasi bolo naꞋa faꞋinia na duꞋulana na ngali langaꞋanga nia, ma na ngwae tatalafaꞋa neꞋe asungaꞋinia fasi Ꞌiri kira ka Ꞌoifoli Ꞌani niaꞋa, faꞋinia na Ꞌafe nia, ma na ngela nia ki, ma na ru nia ki taꞋifau fuana na duꞋulana na ngali langaꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma na ngwae rao neꞋeri leka maꞋi ka bobo uruuru Ꞌi naꞋo ana na ngwae tatalafaꞋa neꞋe, ma ka amasia ka Ꞌuri, ‘ꞋOke mabetau basi faꞋi nau, Ꞌiri nai baꞋa duꞋua na ru Ꞌoe ki taꞋifau.’ ");
INSERT INTO kwf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma na ngwae tatalafaꞋa neꞋeri ka kwaimanatai fuana, ma nia ka rufuanata naꞋa ana ngali langaꞋa nia Ꞌiri nia kasi duꞋua naꞋa, ma nia ka alaꞋania ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aia, ma kaidaꞋi neꞋe ngwae neꞋeri ka ruꞋu kwau Ꞌi maa, nia ka saka fuana taꞋi ngwae ana na ngwae rao ki neꞋe nia ngali langa ana kala bara mani siana. Nia ka daua, ma ka talaꞋae naꞋa Ꞌinilana kukuna, ma ka fata Ꞌuri, ‘ꞋOke duꞋua naꞋa ru ba Ꞌoko ngali langa ani siaku ki!’ ");
INSERT INTO kwf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma ngwae rao neꞋeri ka bobo uruuru, ma ka amasia ka Ꞌuri, ‘ꞋOke mabetau basi faꞋi nau, ma nai baꞋa duꞋu fuamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Bore ma nia ka Ꞌaila, ma ka ngali nia, ma ka alu nia saena na luma ni lokafo, leleka nia ka duꞋua nama na ngali langaꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma kaidaꞋi ti ngwae rao kira lisia na ru neꞋeri, manatalada ka kwaimanatai liu. Ma kira ka leka siana na ngwae tatalafaꞋa neꞋeri, ma kira ka faꞋarongoa Ꞌani na ru ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma na ngwae tatalafaꞋa neꞋeri ka saea maꞋi na ngwae rao etaeta neꞋeri, ma ka fata Ꞌuri fuana, ‘ꞋAeꞋo na ngwae taꞋa liu! Nau ku rufuanata naꞋa ana ngali langaꞋa ba Ꞌoe ki taꞋifau, sulia Ꞌoko amasi nau Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fuila Ꞌoke kwaimanatai goꞋo fuana na ngwae rao neꞋeri, diꞋia ba nau ku sasia logo fuamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma na ngwae tatalafaꞋa neꞋeri ka saetaꞋa liu, ma ka kwatea fuana na kwaꞋilana saena na luma ni lokafo, leleka nia ka duꞋua nama na ru ki taꞋifau neꞋe nia ngali langa ani.” ");
INSERT INTO kwf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma sa Jesus ka faꞋasuia na tarifulaꞋa neꞋeri ka Ꞌuri, “Ma na ru neꞋeri logo neꞋe na MaꞋa nau Ꞌi langi ke baꞋa sasia fuamuꞋa, diꞋia noaꞋa kamu kasi rufuanata mamana goꞋo ana toꞋolamuꞋa faꞋida.” ");
INSERT INTO kwf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","KaidaꞋi sa Jesus alaꞋa ka sui naꞋa, nia ka leka faꞋasia abaꞋi kula neꞋeri Ꞌi Galili. Ma nia ka leka toꞋofolo ana kafo Ꞌi Jodan, ma ka dao ana ta bali ana abaꞋi kula Ꞌi Judea. ");
INSERT INTO kwf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma na ngwae Ꞌoro liu kira leka sulia. Ma na ngwae neꞋe kira mataꞋi ki, sa Jesus ka gurada ma kira ka Ꞌakwa. ");
INSERT INTO kwf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma ti Farasi kira leka logo maꞋi fuana na ilitoꞋolana goꞋo Ꞌada sa Jesus. Ma kira saefiloa, kika Ꞌuri, “ꞋUri ma ana na taki sa Moses, nia leꞋa goꞋo Ꞌana fuana ngwae ka ilangaꞋinia na Ꞌafe nia Ꞌuana ta ru bore Ꞌana neꞋe nia oga?” ");
INSERT INTO kwf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sa Jesus olisida ka Ꞌuri, “ꞋUri ma noaꞋa kamu kasi manata leꞋa sulia ru neꞋe kaumulu toꞋomaꞋiniꞋi saena KerekereꞋa Abu? Na KerekereꞋa Abu fata Ꞌuri, ‘Ana etangilana maꞋi, God nia saungaꞋinia ngwae ki Ꞌania ngwangwane ma na kini.’ ");
INSERT INTO kwf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma na KerekereꞋa Abu ka fata logo Ꞌuri, ‘DuꞋungana ru neꞋeri, ngwae ka faꞋasia na maꞋa nia faꞋinia teꞋa nia, ma ka tua ratai faꞋinia na Ꞌafe nia, ma kera ke alua naꞋa taꞋi manataꞋanga diꞋia taꞋi ngwae goꞋo.’ ");
INSERT INTO kwf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","NoaꞋa laꞋu ta ro ngwae toꞋotoꞋo, bore ma diꞋia taꞋi ngwae naꞋa. ꞋUnaꞋeri ru neꞋe God firi fikua ka sui naꞋa, noaꞋa kasi leꞋa fuana ta ngwae ke logea laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma na Farasi ki kira saefiloa laꞋu kira ka fata Ꞌuri, “Ma taꞋi taki sa Moses fata Ꞌuri, ‘Sa Moses nia alaꞋania neꞋe ngwae ke keresia ta Ꞌaba ru ana kwai ilangaꞋinga, ma ka kwatea fuana na Ꞌafe nia Ꞌiri nia ka ilangaꞋinia naꞋa.’ Ma faꞋuta neꞋe sa Moses ka alaꞋania fuana ngwae ki kika sasi ꞋunaꞋeri?” ");
INSERT INTO kwf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sa Jesus ka fata Ꞌuri fuada, “Sa Moses nia alaꞋania fuamuꞋa Jiu ki fuana ilangaꞋilana Ꞌafe kamu ki, osiꞋana nia ꞋafitaꞋi fuana faꞋamanata lamuꞋa, osiꞋana neꞋe manatamuꞋa ngasi liu. Sui bore Ꞌana ka ꞋunaꞋeri, Ꞌi naꞋo maꞋi ana kaidaꞋi God nia saungaꞋinia na ngwae ma na kini, noaꞋa nia kasi ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma nau ku saea fuamuꞋa, diꞋia Ꞌafe ta ngwae noaꞋa kasi kakabara goꞋo Ꞌana, ma na araꞋi nia ka Ꞌaila Ꞌania ma ka korea lala ta kini laꞋu, na ngwae neꞋe nia rora naꞋa Ꞌania kakabaraꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Buri Ꞌana sa Jesus ka fata ꞋunaꞋeri fuada taꞋifau, fafarongo nia ki kira ka fata Ꞌuri fuana, “Ma diꞋia nia ꞋafitaꞋi liu fuana ngwae ka ilangani na Ꞌafe nia ꞋunaꞋeri, ni leꞋa fuana ngwae noaꞋa kasi araꞋi goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma sa Jesus ka Ꞌuri fuada, “Ngwae Ꞌoro ki noaꞋa Ꞌiri sai leꞋa ana ru mamana sulia araꞋinga. Bore ma bara ngwae goꞋo neꞋe God kwatea liatoꞋo fuada Ꞌiri kike malingaꞋinia faꞋamanataꞋanga neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nau ku saea ru neꞋe osiꞋana ti ngwae noaꞋa kasi araꞋi, sulia talaꞋae ana kaidaꞋi kira futa maꞋi ana noaꞋa ta ru Ꞌiri ꞋoloꞋolo saena na nonida, nia neꞋe sasia noaꞋa kira kasi bolo fuana araꞋinga. Ma ti ngwae noaꞋa kasi araꞋi sulia na ngwae ki kira saungaꞋinia na nonida neꞋe sasia ma noaꞋa kira kasi bolo naꞋa fuana araꞋinga. Ma ti ngwae noaꞋa kira kasi araꞋi Ꞌiri kika rao tatai naꞋa fuana God. Ma na ngwae neꞋe kira totolia kika araꞋi, alaꞋani kika leka sulia na faꞋamanataꞋanga niniꞋa sulia araꞋinga neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma Ꞌi buri Ꞌana ru neꞋe, ti ngwae kira ngalia maꞋi na kaela ngela ki siana sa Jesus, fasi Ꞌiri nia alua limana fafida, ma ka foꞋo fafida. Ma na fafarongo nia ki ka balufida. ");
INSERT INTO kwf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma sa Jesus ka fata Ꞌuri fuada, “Muke alaꞋania na kala ngela ki ka leka maꞋi siaku, noaꞋa kamu kasi luida laꞋu. Sulia God nia gwaungaꞋi fafia ngwae neꞋe enoeno ka diꞋia kala ngela neꞋe ki.” ");
INSERT INTO kwf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui sa Jesus ka alua naꞋa limana Ꞌi fafona kala ngela neꞋeri ki, ma ka faꞋaleꞋa kira. Sui, nia ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana taꞋi kaidaꞋi, taꞋi ngwae Ꞌalako nia leka maꞋi siana sa Jesus, ma ka saefilo Ꞌuri, “FaꞋamanata Ꞌae, na ru leꞋa tae ki neꞋe nau ku sasi Ꞌiri nau ku toꞋo ana na mauriꞋa firi?” ");
INSERT INTO kwf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sa Jesus ka fata Ꞌuri fuana, “FaꞋuta neꞋe Ꞌoko saefilo nau sulia na ru leꞋa ki kwa? TaꞋi God goꞋo neꞋe nia leꞋa. DiꞋia Ꞌoko oga Ꞌoke toꞋo ana mauriꞋa firi faꞋinia God, Ꞌoke roꞋo sulia na taki nia ki neꞋe nia saeꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma na ngwae neꞋeri ka saefiloa laꞋu sa Jesus ka Ꞌuri, “Taki tae ki kwa?” Sa Jesus ka olisi Ꞌuri ana, “ꞋOe kosi sau ngwae, Ꞌoe kosi kakabara, Ꞌoe kosi bilia ta ru, Ꞌoe kosi soke fafia ta ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma Ꞌoko fuꞋusi doe ana maꞋa Ꞌoe ma teꞋa Ꞌoe. Ma Ꞌoke alafe fuana ngwae ki taꞋifau ka diꞋia logo neꞋe Ꞌoko alafe fuamu talamu.” ");
INSERT INTO kwf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui ngwae Ꞌalako neꞋe ka fata Ꞌuri fuana sa Jesus, “Ru neꞋeri ki, nau ku sasi naꞋa maꞋi suliꞋi. ꞋUri ma tae laꞋu neꞋe nai sasia laꞋu kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma sa Jesus olisia ka Ꞌuri fuana, “DiꞋia Ꞌoko oga Ꞌoe tua leꞋa taꞋifau, leka Ꞌoko Ꞌoifoli Ꞌani ru Ꞌoe ki taꞋifau, ngalia mani neꞋeri, Ꞌoko kwatea fuana ngwae dalaꞋa ki, ma Ꞌoke baꞋa toꞋo ana toꞋoruꞋa Ꞌi langi. Sui Ꞌoko fiꞋi leka maꞋi suli nau.” ");
INSERT INTO kwf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma ana kaidaꞋi ngwae Ꞌalako neꞋeri ka rongoa na ru neꞋeri ki, na liana ka kwaimanatai liu naꞋa, ma nia ka leka naꞋa Ꞌana, sulia nia na ngwae toꞋoru liu. ");
INSERT INTO kwf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma sa Jesus ka fata Ꞌuri fuana na fafarongo nia ki, “Nau ku saea fuamuꞋa, nia ꞋafitaꞋi liu naꞋa fuana na ngwae toꞋoru ki kike ruꞋu saena mauriꞋa neꞋe God ke gwaungaꞋi fafia. ");
INSERT INTO kwf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma nau ku saea logo fuamuꞋa, nia ꞋafitaꞋi liu fuana ta kamel ke ruꞋu sulia na maꞋe kwakwa tiꞋitiꞋi Ꞌi Ꞌaena sugila. Nia ꞋafitaꞋi ka liu laꞋu fuana ta ngwae toꞋoru neꞋe God ke gwaungaꞋi fafia maurilana.” ");
INSERT INTO kwf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aia, ma ana kaidaꞋi fafarongo nia ki kira rongoa naꞋa ru neꞋeri ki, kira ka Ꞌarefo liu, ma kika fata Ꞌuri, “Ma diꞋia nia ꞋafitaꞋi fuana ngwae toꞋoru ki ꞋunaꞋeri, sa tai mo neꞋe ka bolo fuana mauriꞋa firi?” ");
INSERT INTO kwf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma ana kaidaꞋi sa Jesus alaꞋa, nia ka lia saga kwau fuana fafarongo nia ki, ma ka fata Ꞌuri, “Nia ꞋafitaꞋi liu fuana na ngwae ki ke toda mauriꞋa firi, bore ma fuana God noaꞋa nia kasi ꞋafitaꞋi goꞋo. Na ru ki taꞋifau nia talangwaraꞋu goꞋo Ꞌana fuana God.” ");
INSERT INTO kwf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ana kaidaꞋi neꞋeri, sa Peter ka saefiloa sa Jesus ka Ꞌuri, “Ma kaimili faꞋuta mo? OsiꞋana kami faꞋasia naꞋa toꞋoruꞋa kaimili ki taꞋifau, ma kami ka leka naꞋa suliꞋo. Ma tae neꞋe God ke kwatea fuaimili?” ");
INSERT INTO kwf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma sa Jesus ka olisia fuada ka Ꞌuri, “Nau ku saea fuamuꞋa, ana kaidaꞋi God ke baꞋa alua na magalia faolu, nauꞋa, na Ngela Ngwae, nai baꞋa tua ana fuli tuaꞋa nau fuana na matalangaꞋilana ngwae ki taꞋifau. Ana kaidaꞋi neꞋeri, kaumulu akwala ma ro ngwae fafarongo nau ki, kamu ke baꞋa tua faꞋi nau ana kula ana ꞋinotoꞋanga fuana matalangaꞋilana ngwae ki ana akwala ma ro kwalafa ana Israel ki. ");
INSERT INTO kwf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma sa tai neꞋe ka faꞋasia luma nia, ma na ngwaefuta nia ki, ma na ngwaingwaena nia ki, ma na maꞋa faꞋinia teꞋa nia, ma ngela nia ki, nama ta ano bore Ꞌana, sulia nia leka suli nau, na ngwae neꞋeri nia ke baꞋa ngalia ru leꞋa Ꞌoro ki liufia ru ba nia toꞋo ana Ꞌi naꞋo ki. Ma God ke baꞋa kwatea logo mauriꞋa firi fuana. ");
INSERT INTO kwf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma ngwae Ꞌoro neꞋe kira ꞋaꞋana ana kaidaꞋi neꞋeri, kike baꞋa tiꞋitiꞋi. Ma ngwae Ꞌoro neꞋe kira faꞋatiꞋitiꞋi kira ana kaidaꞋi neꞋe, kike baꞋa ꞋaꞋana.” ");
INSERT INTO kwf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sa Jesus ka fata laꞋu Ꞌuri fuana na fafarongo nia ki, “Na ꞋInotoꞋanga God nia Ꞌuri: Nia diꞋia na ngwae neꞋe toꞋo ana ano, ma ka leka Ꞌi Ꞌofodangi fuana na laefilana ngwae ki fuana raoꞋa Ꞌi saena oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma nia ka alafafia na folilada Ꞌani mani neꞋe bolo fuana taꞋi asoa, ma ka baꞋeda naꞋa fuana raoꞋa saena na oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma ana sikona kadi sina Ꞌi Ꞌofodangi, nia ka leka laꞋu, ma ka lisia ti ngwae neꞋe kira uu ꞋoꞋo goꞋo Ꞌada Ꞌi saena usiꞋa, ma noaꞋa kira kasi sasia goꞋo ta ru. ");
INSERT INTO kwf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma nia ka Ꞌuri fuada, ‘Kaumulu ke leka logo maꞋi, Ꞌiri kuke rao Ꞌi saena na oꞋola nau, ma nau kui baꞋa foli kaumulu Ꞌani ru neꞋe totolia.’ ");
INSERT INTO kwf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma kira ka leka naꞋa. “Ma tofongana asoa, ma ana uula kadi sina asoa, nia ka leka laꞋu, ma ka sasi logo ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma saꞋulafi naꞋa, nia ka leka ma ka dao toꞋona ti ngwae neꞋe kira uu ꞋoꞋo goꞋo Ꞌada maana fuli usiꞋa. Ma nia ka saefiloda ka Ꞌuri, ‘FaꞋuta neꞋe kamu ka uu ꞋoꞋo goꞋo aumulu Ꞌi neꞋe sulia asoa laꞋulaꞋu neꞋe, ma noaꞋa kamu kasi sasia goꞋo ta ru?’ ");
INSERT INTO kwf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma kira olisia kika Ꞌuri, ‘NoaꞋa ta ngwae kasi sae kaimili goꞋo.’ “Ma nia ka fata Ꞌuri fuada, ‘Kaumulu ke leka logo maꞋi, Ꞌiri kuke rao Ꞌi saena na oꞋola nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ma kaidaꞋi neꞋe sina ka suu naꞋa, ngwae neꞋe toꞋo ana oꞋola, ka fata Ꞌuri fuana na ngwae ꞋaꞋana ana na raoꞋa nia, ‘ꞋOke saea maꞋi na ngwae rao ki, ma Ꞌoko foli kira Ꞌani na mani kira ki. ꞋOke talaꞋae ana na ngwae ba nau ku saeda Ꞌisi, leleka ka dao ana na ngwae ba nau ku eta saeda ki.’ ");
INSERT INTO kwf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na ngwae rao ba nia saeda Ꞌi buri Ꞌi saꞋulafi ki, kira dao maꞋi, ma nia ka folida Ꞌani mani neꞋe totolia taꞋi asoa fuana taꞋi ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma kaidaꞋi neꞋe ngwae ba nia saeda maꞋi Ꞌi naꞋo kira dao maꞋi, kira fia fasi nia ke baꞋa foli kira ka taꞋi doe. Bore ma kira taꞋifau kira ngalia goꞋo mani neꞋe totolia taꞋi asoa fuana taꞋi ngwaeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma kaidaꞋi kira ngalia naꞋa, kira ka ngunungunu buri fuana na ngwae neꞋe toꞋo ana na oꞋola, kira ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Na ngwae nini Ꞌoko saeda maꞋi buri, kira rao goꞋo sulia kaidaꞋi tiꞋitiꞋi, ma Ꞌoko folida ka bolo logo faꞋi kaimili neꞋe kami ngali kuluꞋa naꞋa ana na raoꞋa sulia faꞋi asoa laꞋulaꞋu neꞋe, ma na sina ka sina fifi liu naꞋa aimili.’ ");
INSERT INTO kwf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma nia ka olisia taꞋi ngwae ada ka Ꞌuri, ‘Kwala ngwade Ꞌae, nau kusi Ꞌaurafu Ꞌoe goꞋo. ꞋOko alafafia na raoꞋa fuana taꞋi mani goꞋo ba. ");
INSERT INTO kwf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngalia naꞋa fofoliꞋa Ꞌoe, ma Ꞌoko leka naꞋa kwau Ꞌamu. Nau ku oga nai kwatea fuana ngwae neꞋe nau ku laefia ꞋisiꞋisi ka diꞋia logo neꞋe nau ku kwate fuamu. ");
INSERT INTO kwf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma nau ku toꞋo ana ngasingasiꞋanga fuana sasilana tae neꞋe nau ku oga kui sasia Ꞌania na mani nau talaku. FaꞋuta Ꞌoko Ꞌuga, osiꞋana nau ku kwate ru doe fuana ngwae matamata loꞋoko ki?’” ");
INSERT INTO kwf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma Ꞌisilana sa Jesus ka fata Ꞌuri, “Nia neꞋe, na ngwae neꞋe ꞋisiꞋisi niniꞋari, ke baꞋa etaeta laꞋu. Ma na ngwae neꞋe kira etaeta niniꞋari, kike baꞋa ꞋisiꞋisi laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","KaidaꞋi sa Jesus nia leka Ꞌuana Ꞌi Jerusalem, nia ka talaꞋia na fafarongo nia ki kira ka leka karangi nia taꞋifilida, ma nia ka alaꞋa fuada taꞋifilida ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kamu ke fafarongo leꞋa maꞋi fuaku. Kulu leka kwau Ꞌuana Ꞌi Jerusalem. Ma taꞋi ngwae ke baꞋa kwate nau, na Ngela Ngwae, fuana fata abu doe ki, ma na faꞋamanata ana taki ki, fasi Ꞌiri kira ka matalangaꞋi taꞋa aku fuana na saungilaku. ");
INSERT INTO kwf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma kike baꞋa kwate nau fuana ngwae neꞋe noaꞋa laꞋu Jiu ki, ma kike baꞋa Ꞌoidorole Ꞌani nau, ma kika ulasi nau. Sui kike baꞋa fotoꞋi nau ana Ꞌai rara folo fuana saungilaku. Aia, ma ana uula asoa, God ke baꞋa taꞋe nau laꞋu fuana mauri.” ");
INSERT INTO kwf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Buri Ꞌana ru neꞋeri, Ꞌafe sa Sebedi faꞋinia na ro ngela nia ki, sa James ma sa John, kira ka dao maꞋi fuana lisilana sa Jesus. Na kini neꞋeri ka leka maꞋi, ka bobo uruuru Ꞌi naꞋona sa Jesus, ma ka gania Ꞌuana sasilana ta ru fuana ro ngela nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma sa Jesus ka saefiloa kini neꞋe ka Ꞌuri, “Tae neꞋe Ꞌoko oga?” Nia ka fata Ꞌuri, “Nau ku oga Ꞌoke eta fataꞋa fuaku Ꞌoko alaꞋania ro ngela neꞋe nau ki, kera ka tua karangi Ꞌoe, ta ngwae ka tua Ꞌi bali ꞋoloꞋolo amu, ma ta ngwae Ꞌi bali mauli Ꞌamu, kaidaꞋi Ꞌoke tatalafaꞋa Ꞌi saena ꞋInotoꞋanga Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ana kaidaꞋi neꞋeri, sa Jesus ka fata Ꞌuri fuana ngela neꞋeri ki, “Ru neꞋe koroꞋo gania, koroꞋo noaꞋa Ꞌiri sai goꞋo ana na fadalana. KoroꞋo totolia goꞋo ꞋamuroꞋo nonifiiꞋanga diꞋia neꞋe nai baꞋa nonifii Ꞌania?” Ma kera ka fata Ꞌuri, “ꞋIu, keroꞋo totolia goꞋo ꞋamiroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sa Jesus ka fata Ꞌuri laꞋu fuadaroꞋo, “Nia mamana na nonifiiꞋanga neꞋe ke baꞋa dao ana koroꞋo. Bore ma fuana ta ngwae neꞋe ka tua bali ꞋoloꞋolo aku, ma ta ngwae bali mauli aku diꞋia neꞋe koroꞋo oga, noaꞋa laꞋu nauꞋa neꞋe nai filia. TaꞋifilia MaꞋa nau maꞋi langi goꞋo Ꞌana neꞋe saiana kwatelana fuana sa tai faꞋida neꞋe nia filida fuana ka sui naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","KaidaꞋi neꞋe akwala fafarongo neꞋeri ki kira rongoa ru neꞋe, kira ka saetaꞋa fuana ro ngwae asina neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nia neꞋe, sa Jesus ka sae kira taꞋifau goꞋo maꞋi siana, ka fata Ꞌuri, “Kaumulu saiana na ngwae gwaungaꞋi ki neꞋe kira gwaungaꞋi fuana ngwae neꞋe noaꞋa laꞋu Jiu ki, kira toꞋo ana ngasingasiꞋanga, ma kira sai liu ana usungaꞋilana ngwae ki fuana sasilana ru kira ogaꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sui bore Ꞌana, noaꞋa nia kasi ꞋunaꞋeri laꞋu Ꞌi safitamuꞋa. DiꞋia ta ngwae aumulu nia oga ka faꞋinaꞋonaꞋo, nia ke saiana nia ngwae rao kaumulu. ");
INSERT INTO kwf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma diꞋia sa tai aumulu neꞋe nia oga ka ꞋinotoꞋa, nia ke rao ꞋoꞋo fuana ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nia ka sasi diꞋia nauꞋa, na Ngela Ngwae. DuꞋungana nau noaꞋa kusi leka maꞋi Ꞌiri neꞋe ngwae ki kira ka rao fuaku. Ma nau ku leka lala maꞋi Ꞌiri nai rao fuana ngwae ki taꞋifau, ma nau ku kwatea naꞋa maurilaku fuana faꞋamaurilana na ngwae Ꞌoro ki faꞋasi taꞋangaꞋa kira ki.” ");
INSERT INTO kwf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ma ana kaidaꞋi sa Jesus faꞋinia fafarongo nia ki kira leka kwau Ꞌuana Ꞌi Jerusalem, kira ka liufia naꞋa kwau maꞋe fanoa Ꞌi Jeriko. Ma kaidaꞋi kira ka leka faꞋasia na fanoa neꞋeri, na ngwae Ꞌoro liu kira leka maꞋi sulida. ");
INSERT INTO kwf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma na ro ngwae maada rodo ki kera tua ninimana tala. Ma kaidaꞋi kera rongoa sa Jesus leka maꞋi sulia tala, kera ka ri naꞋa, kera ka Ꞌuri, “ꞋAeꞋo na Ꞌalako ana kwalafa sa David, Ꞌoke manatai keroꞋo maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma kaidaꞋi neꞋe ngwae ki kira rongo kera, kira ka balufi kera, ma kika Ꞌuri, “Moke tua aroaro!” Bore ma kaidaꞋi kira fata ꞋunaꞋeri, kera fiꞋi ri doe ka tasa laꞋu Ꞌuri, “ꞋAeꞋo na Ꞌalako ana kwalafa sa David, Ꞌoke manatai keroꞋo maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma kaidaꞋi sa Jesus rongo kera ri maꞋi ꞋunaꞋeri, nia ka uutoꞋo, ma ka saeda maꞋi, ma ka saefiloda ka Ꞌuri, “Tae neꞋe koroꞋo oga nai sasia fuamuroꞋo?” ");
INSERT INTO kwf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kera olisia, keka Ꞌuri fuana, “KeroꞋo oga Ꞌoke Ꞌifingia maamiroꞋo fasi Ꞌiri keroꞋo ke lia laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ꞋUnaꞋeri, sa Jesus ka kwaimanatai liu fuadaroꞋo, ma nia ka sama toꞋona maadaroꞋo. Ma ana kaidaꞋi neꞋeri nama goꞋo, na maadaroꞋo ka lia naꞋa, ma kera ka leka naꞋa faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma sa Jesus faꞋinia na fafarongo nia ki kira dao karangia naꞋa Ꞌi Jerusalem, ana fanoa Ꞌi Betfeis, Ꞌi gwauna faꞋi ua Ꞌi Olif. ꞋI neꞋeri, sa Jesus ka kwatea ta ro ngwae ana na fafarongo nia ki, kera ka etaeta Ꞌi naꞋo, ");
INSERT INTO kwf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma nia ka fata Ꞌuri fuadaroꞋo, “Moke leka Ꞌuana fanoa loꞋoko neꞋana koroꞋo leka kwau Ꞌuana, ma koroꞋo ke baꞋa dao toꞋona taꞋi dongki, kira firiꞋia Ꞌi neꞋeri faꞋinia na bibina. KoroꞋo ka logedaroꞋo, ma moro ka ngalida maꞋi siaku. ");
INSERT INTO kwf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma diꞋia ta ngwae ka saefilo koroꞋo, koroꞋo ka saea fuana moka Ꞌuri, ‘Na Aofia neꞋe ogaꞋi.’ Ma ꞋunaꞋeri nia ke baꞋa alaꞋanida fuamuroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ru neꞋe nia fuli fasi Ꞌiri ka faꞋamamana tae ba na profet nia saea ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Muke saea fuana ngwae ki Ꞌi Jerusalem muka Ꞌuri, ‘Lisia basi. Na ngwae tatalafaꞋa kamu, nia leka naꞋa maꞋi siaumulu. Nia ka faꞋatiꞋitiꞋi nia, ma ka leka maꞋi Ꞌi fafona na dongki. Nia ka leka maꞋi Ꞌi fafona na kala dongki.’” ");
INSERT INTO kwf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma na ro ngwae ana na fafarongo nia ki, kera ka etaeta naꞋa Ꞌi naꞋo, ma kera ka sasia naꞋa ru neꞋe sa Jesus saea fuadaroꞋo ki. ");
INSERT INTO kwf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kera talaꞋia maꞋi na dongki neꞋeri faꞋinia na bibina, ma kira ka safataꞋinia na ifi kira ki Ꞌi fafona ilina bibina, ma sa Jesus ka tua Ꞌi fafona. ");
INSERT INTO kwf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma na ngwae Ꞌoro liu ki kira safataꞋinia na ifi kira ki sulia na tala, ma ti ngwae kira ka tufua na uila niniu ki, ma kira ka safataꞋinia sulia na tala fuana faꞋaꞋinotoꞋalana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na fikuꞋa doe neꞋe kira etaeta Ꞌi naꞋo ana sa Jesus, ma kira ka Ꞌisi kwau Ꞌi burina, kira ako ma kika Ꞌuri, “AuraꞋe Ꞌanga fuana ngela ana kwalafa sa David na tatalafaꞋa! Ma God Ꞌoko ꞋoilakitaꞋinia na ngwae neꞋe nia leka maꞋi Ꞌani na ngasingasiꞋanga Ꞌoe! Kulu baꞋatafea God!” ");
INSERT INTO kwf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma kaidaꞋi sa Jesus nia dao Ꞌi Jerusalem, na fanoa ka ngalu liu naꞋa, ma ti ngwae kira saefiloda kira ka Ꞌuri, “Sa tai niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma na fikuꞋa neꞋeri kira ka Ꞌuri, “NiaꞋa sa Jesus na profet, na ngwae faꞋasia na fanoa Ꞌi Nasaret Ꞌi saena na abaꞋi kula Ꞌi Galili.” ");
INSERT INTO kwf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","KaidaꞋi sa Jesus leka maꞋi ka dao saena Luma Abu God, nia ka lalia na ngwae neꞋe kira usi Ꞌada Ꞌi neꞋeri ki. Ma nia ka giosia na tatafe ana ngwae neꞋe kira rokisi mani neꞋeri ki, ma ka gilosia na ru fuana tuaꞋa na ngwae neꞋe kira Ꞌoifoli Ꞌani na faꞋi fao ki. ");
INSERT INTO kwf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma sa Jesus ka fata Ꞌuri fuana ngwae neꞋeri ki, “Na Fatalana God saena KerekereꞋa Abu nia fata Ꞌuri, ‘Na Luma nau, na luma ni foꞋo.’ Bore ma kamu faꞋitaꞋinia ka alua lala kula fuana bililana ru ngwae ki.” ");
INSERT INTO kwf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ana kaidaꞋi neꞋeri, ti ngwae maada rodo, ma ti ngwae Ꞌaeda mae, kira leka logo maꞋi siana sa Jesus saena Luma Abu God, ma nia ka gurada taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aia, ma na fata abu doe ki, ma na faꞋamanata ana taki ki, kira ka saetaꞋa liu kaidaꞋi kira lisia ru leꞋa ki neꞋe sa Jesus nia sasiꞋi, ma kira ka rongoa kala ngela ki kira ri kika Ꞌuri, “AuraꞋe Ꞌanga fuana ngela ana kwalafa sa David na tatalafaꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma na fata abu doe ki faꞋinia na faꞋamanata ki, kira ka fata Ꞌuri fuana sa Jesus, “ꞋOko rongoa tae neꞋe kira saea! FaꞋuta neꞋe noaꞋa Ꞌoe kosi luida kwa?” Ma sa Jesus ka olisida ka Ꞌuri, “ꞋIu, nau ku rongoa. NoaꞋa kamu Ꞌiri toꞋomani goꞋo alaꞋanga ba saena KerekereꞋa Abu? Nia fata Ꞌuri, ‘ꞋOko faꞋamanata na kaela ngela ki fasi Ꞌiri kira ka baꞋatafe Ꞌoe talamu.’” ");
INSERT INTO kwf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sui Ꞌi buri Ꞌana, sa Jesus faꞋinia na fafarongo nia ki, kira ka leka naꞋa faꞋasia Ꞌi Jerusalem, ma kira ka leka Ꞌuana Ꞌi Betani. Ma kaidaꞋi nia rodo naꞋa, kira ka teo Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ꞋOfodangi ana ruana asoa, kaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira oli maꞋi Ꞌuana Ꞌi Jerusalem, ma sa Jesus ka fiolo. ");
INSERT INTO kwf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma nia ka lisia taꞋi Ꞌai figi neꞋe uu Ꞌi ninimana tala, ma ka leka Ꞌi Ꞌaena, bore ma noaꞋa nia kasi lisia goꞋo ta fuaꞋi ru ana, ma na rauna goꞋo neꞋe ulubono. Ma nia ka fata Ꞌuri fuana Ꞌai figi neꞋeri, “OsiꞋana noaꞋa Ꞌoe kosi alua goꞋo ta fuaꞋi ru, Ꞌira Ꞌita ana kaidaꞋi neꞋe noaꞋa Ꞌoe kosi fungu laꞋu!” Ma ana kaidaꞋi neꞋeri nama goꞋo, na Ꞌai neꞋeri ka kuku naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","KaidaꞋi fafarongo ki kira lisia ru neꞋeri, kira ka Ꞌarefo liu. Ma kira ka saefiloa Ꞌuri, “Tae neꞋe sasi ma na Ꞌai neꞋe ka mae ꞋaliꞋali goꞋo Ꞌana Ꞌuri kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma sa Jesus olisida ka Ꞌuri, “Nau ku saea fuamuꞋa, diꞋia kamu faꞋamamana ma noaꞋa kamu kasi manata ruarua, kaumulu saiana muke sasia goꞋo Ꞌaumulu ru doe ki liufia ru neꞋe nau ku sasia ana Ꞌai figi neꞋe. DiꞋia kamu saea fuana faꞋi ua neꞋe, ‘ꞋOke leka, Ꞌoko tua saena asi,’ Ꞌira nia ke baꞋa leka goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","DiꞋia kamu foꞋosia God, ma kamu ka faꞋamamana neꞋe God ke sasi ru neꞋe kamu gania, nia ke sasi goꞋo Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aia, ana kaidaꞋi sa Jesus nia oli laꞋu saena Luma Abu God fuana faꞋamanatalana ngwae ki, na fata abu doe ki, ma ti ngwae faꞋinaꞋonaꞋo ana Jiu ki, kira ka leka maꞋi siana. Ma kira ka saefiloa Ꞌuri, “Na ngasingasiꞋanga tae neꞋe Ꞌoko toꞋo ana fuana na sasilana ru neꞋe ki kwa? Ma sa tai mo neꞋe nia kwatea na mamanaꞋanga neꞋe fuamu?” ");
INSERT INTO kwf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma sa Jesus ka olisida ka Ꞌuri, “ꞋIu, nau ku saefilo kaumulu basi Ꞌuana taꞋi ru. DiꞋia kamu olisia, nau ku fiꞋi faꞋarongo kaumulu ana na mamanaꞋanga neꞋe nau ku toꞋo ana fuana sasilana ru neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ꞋIu, kamu ke saea basi fuaku, na mamanaꞋanga neꞋe sa John nia toꞋo ana fuana na siuabuꞋanga, nia Ꞌita maꞋi faꞋasia Ꞌi fai? Nia Ꞌita maꞋi ana God, nama nia Ꞌita maꞋi ana na ngwae ki goꞋo?” Ma kira ka talaꞋae ana olisuꞋusuꞋunga Ꞌi safitada kwailiu kira ka Ꞌuri, “Tae neꞋe kulu ke saea? DiꞋia kulu olisia ma kulu ka Ꞌuri, ‘FaꞋasia maꞋi God,’ nia ke baꞋa fata Ꞌuri, ‘ꞋIrai ma faꞋuta mo neꞋe kamu kasi faꞋamamana sa John?’ ");
INSERT INTO kwf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma diꞋia kulu fata Ꞌuri, ‘Ngwae goꞋo Ꞌana neꞋe kwatea ngasingasiꞋanga fuana sa John ka siuabu ana ngwae ki, noaꞋa laꞋu God,’ ngwae ki kira ke baꞋa saetaꞋa fuakulu.” Kira maꞋu, sulia na ngwae ki kira saea sa John niaꞋa neꞋe na profet. ");
INSERT INTO kwf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nia neꞋe kira ka olisia Ꞌuri goꞋo Ꞌada ana fuana sa Jesus, “Kaimili kina goꞋo sa tai neꞋe saea fuana sa John ka siuabua ngwae ki.” Ma sa Jesus ka fata Ꞌuri fuada, “ꞋIu, diꞋia nia ꞋunaꞋeri, noaꞋa nau kusi saea logo fuamuꞋa sa tai neꞋe kwatea na ngasingasiꞋanga neꞋe fuaku.” ");
INSERT INTO kwf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma sa Jesus ka fata laꞋu Ꞌuri fuada, “Kamu manata faꞋuta sulia ru neꞋe? TaꞋi ngwae nia toꞋo ana ro ngela ngwane ki. Ma nia ka leka siana na ngela Ꞌi naꞋo, ma ka fata Ꞌuri fuana, ‘ꞋAlako nau Ꞌae, taꞋena Ꞌoke leka, ma Ꞌoke rao Ꞌi saena na oꞋola ba kulu.’ ");
INSERT INTO kwf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ma nia ka olisia ka Ꞌuri, ‘Nau ku Ꞌaila goꞋo kwa.’ Ma sui Ꞌi buri, nia ka rokisia na manataꞋanga neꞋeri, ma ka leka naꞋa Ꞌi saena na oꞋola. ");
INSERT INTO kwf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma Ꞌi buri, na maꞋa ka leka laꞋu siana na ruana ngela ana, ma ka saea logo taꞋi alaꞋanga neꞋeri. Ma na ngela neꞋe ka olisia ka Ꞌuri, ‘Nia leꞋa goꞋo Ꞌana nai baꞋa leka.’ Bore ma noaꞋa nia kasi leka goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“ꞋUri ma sa tai adaroꞋo naꞋa neꞋe sasia ru ba na maꞋa kera nia oga?” Ma kira olisia kika Ꞌuri, “Na ngela ba Ꞌi naꞋo.” Ma sa Jesus ka fata Ꞌuri fuada, “Ru mamana nau ku saea fuamuꞋa, na ngwae taꞋa ki neꞋe kira gonia na mani ana na takisi, ma na kini sesele ki, kike baꞋa eta ruꞋu Ꞌi saena na mauriꞋa neꞋe God nia gwaungaꞋi fafia Ꞌi naꞋo ana kamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa John ngwae ni Siuabu ba dao naꞋa maꞋi siaumulu fuana na faꞋataꞋilana na tuaꞋa neꞋe God nia oga fuamuꞋa muke tua sulia, ma noaꞋa kamu kasi faꞋamamana goꞋo ana niaꞋa. Bore ma, na ngwae Ꞌaurafu ki neꞋe kira gonia mani ana na takisi, ma na kini sesele ki, kira ka faꞋamamana ana niaꞋa. Ma sui bore Ꞌana muka lisia na ru neꞋeri ki, noaꞋa kamu kasi faꞋamamana goꞋo ana sa John, ma noaꞋa kamu kasi rokisia goꞋo manatamuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sa Jesus ka fata laꞋu fuada ka Ꞌuri, “Muke rongoa basi taꞋi tarifulaꞋanga neꞋe laꞋu. TaꞋi ngwae nia fasia na oꞋola. Ma nia ka saungaꞋinia sakali kalikalia, ma ka Ꞌilia taꞋi kilu fuana na ngisilana na fuaꞋi Ꞌai ki fuana saungaꞋilana waen, ma ka saungaꞋinia taꞋi luma fuana na foloꞋa. Ma nia ka alua na oꞋola nia saena limana ngwae ki neꞋe kira rao Ꞌi saena. ꞋUnaꞋeri, nia ka leka naꞋa Ꞌana Ꞌuana ta maꞋe fanoa. ");
INSERT INTO kwf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma kaidaꞋi neꞋe oꞋola neꞋeri nia maua, nia ka kwatea na ngwae ni rao nia ki fuana na ngwae neꞋe kira lia sulia na oꞋola nia, fasi Ꞌiri kira ke kwatea maꞋi ta bali ana fuaꞋi ru neꞋe kira loiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ma na ngwae neꞋe lia sulia na oꞋola ki, kira daua na ngwae rao nia ki, ma kira ka ulasia taꞋi ngwae, ma ruana ngwae kira ka saungia ka mae naꞋa, ma uula ngwae kira ka Ꞌuia naꞋa Ꞌani fau fuana saungilana. ");
INSERT INTO kwf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui nia ka kwatea laꞋu ti ngwae rao Ꞌoro laꞋu fuada ka liufia Ꞌi naꞋo. Ma na ngwae neꞋe kira lia sulia na oꞋola neꞋeri, kira ka sasi ꞋunaꞋeri logo ada. ");
INSERT INTO kwf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma Ꞌisilana, nia ka kwatea naꞋa ngela mutaꞋi nia fuada. Ma nia ka manata Ꞌuri, ‘Kike baꞋa fuꞋusi doe goꞋo Ꞌada ana na ngela nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Sui ma ana kaidaꞋi neꞋe ngwae neꞋeri ki kira lisia naꞋa ngela nia, kira ka saea kwailiu naꞋa fuada kira ka Ꞌuri, ‘Nia naꞋa neꞋe ngela na ngwae neꞋe toꞋo ana na oꞋola neꞋe. Kulu saungia ka mae, fasi Ꞌiri kuke ngalia Ꞌakulu na ru neꞋe nia ki taꞋifau.’ ");
INSERT INTO kwf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma kira daua, ma kika Ꞌui Ꞌania Ꞌi maa faꞋasia na oꞋola neꞋeri, ma kira ka saungia ka mae. ");
INSERT INTO kwf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“ꞋUnaꞋeri ma kaidaꞋi neꞋe ngwae neꞋe toꞋo ana na oꞋola ka dao maꞋi, tae neꞋe nia ke baꞋa sasia fuana na ngwae neꞋe kira lia sulia na oꞋola ki?” ");
INSERT INTO kwf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma kira olisia kika Ꞌuri, “Nia ke baꞋa saungia na ngwae taꞋa neꞋeri ki ka mae, ma nia ka kwatea laꞋu na oꞋola nia fuana ti ngwae matamata neꞋe kike baꞋa kwatea ta bali fuana ana kaidaꞋi Ꞌana goniruꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma sa Jesus ka fata Ꞌuri fuada, “Nia mamana kamu toꞋomani na KerekereꞋa Abu ba nia fata Ꞌuri, ‘Na fau neꞋe na ngwae saungaꞋi luma ki kira Ꞌaila Ꞌania, nia neꞋe na fau neꞋe talingaꞋi ka liufia na fau ki taꞋifau ana Ꞌodoa. God neꞋe fulingani ru neꞋeri, ma na lisilana ka leꞋa liu.’ ");
INSERT INTO kwf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma nia neꞋe nau ku saea fuamuꞋa, na ngwanganeꞋanga ana gwaungaꞋinga God ke baꞋa lafua faꞋasi kamu, ma ka kwatea Ꞌana fuada na ngwae neꞋe kira roꞋosulia ki. ");
INSERT INTO kwf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma diꞋia sa tai neꞋe nia Ꞌasia fafona fau neꞋeri, nia ke mangisia naꞋa. Ma diꞋia sa tai neꞋe fau neꞋeri ka Ꞌasia fafia, na nonina ka meme taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma kaidaꞋi neꞋe fata abu doe ki ma na Farasi ki, kira rongoa tarifulaꞋa neꞋeri, kira lia saiana sa Jesus nia fata sulida. ");
INSERT INTO kwf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ta neꞋe kira oga kira ka daua. Bore ma kira maꞋu, osiꞋana neꞋe ngwae Ꞌoro ki kira fiku ana kaidaꞋi neꞋeri, kira faꞋamamana ana sa Jesus neꞋe niaꞋa na profet. ");
INSERT INTO kwf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sa Jesus ka fata laꞋu Ꞌani tarifulaꞋanga fuada na ngwae ki ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na ꞋInotoꞋanga God nia Ꞌuri: TaꞋi ngwae tatalafaꞋa nia saungaꞋinia na fafangaꞋa ana araꞋinga fuana na Ꞌalako nia neꞋe ke araꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma nia ka kwatea na ngwae rao nia ki fuada na ngwae ki neꞋe nia laefida maꞋi ki fuana na fafangaꞋa neꞋeri, fasi Ꞌiri kira ka leka maꞋi. Bore ma kira ka Ꞌaila lala Ꞌani lekaꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sui nia ka kwatea laꞋu ti ngwae rao, ka fata Ꞌuri fuada, ‘Kamu ke faꞋarongoa na ngwae neꞋe nau ku laefida ki, na fangaꞋa nau kwaibobori naꞋa. Nau ku saungia taꞋifau naꞋa na buluka doe nau ki ma na kala buluka leꞋa nau ki, ma na ru ki taꞋifau ka kwaibobori naꞋa. Muke leka naꞋa maꞋi ana na fafangaꞋa nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Bore ma noaꞋa kira kasi oga goꞋo roꞋongaꞋa sulia, ma kira ka leka matamata lala Ꞌada. Ta ngwae ka leka naꞋa Ꞌana saena oꞋola nia, ma ta ngwae ka leka naꞋa Ꞌana saena na sitoa nia. ");
INSERT INTO kwf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma ti ngwae kira daua naꞋa ngwae rao neꞋeri ki, kira ka kwaiꞋida, ma kira ka saungida. ");
INSERT INTO kwf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma na ngwae tatalafaꞋa neꞋe ka saetaꞋa liu, ma nia ka kwatea naꞋa ngwae fuani oro nia ki, ma kira ka saungia naꞋa ngwae neꞋeri ki neꞋe kira saungia naꞋa ngwae rao nia ki. Ma kira ka duꞋafia naꞋa fanoa doe kira. ");
INSERT INTO kwf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Sui nia ka fata Ꞌuri fuana na ngwae rao nia ki, ‘Na fangaꞋa kwaibobori naꞋa, bore ma na ngwae ba nau ku laefida ki, kira kasi totolia lekaꞋa maꞋi ana na fafanga faꞋi kaimili. ");
INSERT INTO kwf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kamu ke leka sulia na tala ki, ma kamu ka saea maꞋi na ngwae ki taꞋifau neꞋe kamu dao toꞋoda, kira ka leka maꞋi ana fangaꞋa neꞋe.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma na ngwae rao ki kira ka leka sulia na tala ki, ma kika fikua maꞋi na ngwae ki taꞋifau neꞋe kira dao toꞋoda. Ma na fangaꞋa ana na araꞋinga neꞋeri ka fungu Ꞌani ngwae leꞋa ki ma na ngwae taꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sui kaidaꞋi neꞋe ngwae tatalafaꞋa ka dao maꞋi fuana lisilana na ngwae neꞋe kira dao ki, nia ka lisia taꞋi ngwae neꞋe noaꞋa kasi toro goꞋo Ꞌani na toro ana na araꞋinga. ");
INSERT INTO kwf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma na ngwae tatalafaꞋa ka fata ka Ꞌuri, ‘NoaꞋa Ꞌoko Ꞌiri toro goꞋo Ꞌani na toro fuana fangaꞋa ana araꞋinga, ꞋunaꞋeri noaꞋa Ꞌiri leꞋa fuana Ꞌoe tua Ꞌi neꞋe.’ Ma na ngwae neꞋeri noaꞋa kasi saea naꞋa ta ru. ");
INSERT INTO kwf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Sui na ngwae tatalafaꞋa ka saea fuana na ngwae rao nia ki ka Ꞌuri, ‘Kamu ke firi fafia na limana ma na Ꞌaena ngwae neꞋe, ma kamu ka Ꞌui Ꞌani niaꞋa saena na kula rorodoꞋa neꞋe Ꞌi maa, ana kula neꞋe ngwae ke angi ma ka Ꞌala girigiri ana lifada, osiꞋana kira nonifii.’” ");
INSERT INTO kwf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sui sa Jesus ka fata naꞋa Ꞌuri, “Na ngwae Ꞌoro ki mala neꞋe God laefida, bore ma bara ngwae goꞋo neꞋe nia filida.” ");
INSERT INTO kwf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na ngwae Farasi ki kira leka, ma kira ka lokoꞋi ru fuana na faꞋaroralana sa Jesus Ꞌani ru neꞋe nia saeꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma kira ka kwatea fafarongo kira ki faꞋinia ti ngwae neꞋe oga kwalafa sa Herod ka tatalafaꞋa siana sa Jesus. Ma kira ka fata Ꞌuri, “Ngwae FaꞋamanata Ꞌae, kaimili saiana ru Ꞌoko saeꞋe ki, ru mamana ki taꞋifau goꞋo. ꞋOko faꞋamanata goꞋo Ꞌamu sulia mamanaꞋanga ma kwaiogaiꞋanga God fuana na ngwae ki. Ma Ꞌoe kosi Ꞌado goꞋo faꞋinia ta ngwae Ꞌani ta tae neꞋe kira manata sulia. Ma noaꞋa Ꞌoe kosi manata goꞋo Ꞌuana na ꞋinotoꞋalana na ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ꞋIu, Ꞌoke saea basi fuaimili! ꞋUri ma na taki kia, nia luia na kwatelana na mani ana takisi fuana na ngwae gwaungaꞋi ana Ꞌafutana Ꞌi Rom? ꞋUri ma nia bolo faꞋinia kaimili ke kwatea takisi baera, nama noaꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma sa Jesus ka sai naꞋa ana na manataꞋanga taꞋa kira, ma ka fata Ꞌuri, “Kaumulu na ngwae kwalabasa ki, faꞋuta neꞋe kamu ka sasi Ꞌuana na faꞋaroralaku? ");
INSERT INTO kwf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Muke faꞋataꞋinia basi na mani neꞋe kamu folia Ꞌani na takisi.” Ma kira ka ngalia maꞋi taꞋi selene, kira ka faꞋataꞋinia fuana. ");
INSERT INTO kwf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma nia ka saefilo kira ka Ꞌuri, “Na nununa sa tai niniꞋa? Ma na satana sa tai mo niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma kira olisia, kira ka Ꞌuri, “Na nununa ma na satana na tatalafaꞋa Ꞌi Rom.” Ma sa Jesus ka fata Ꞌuri, “Kamu ke kwatea fuana na tatalafaꞋa Ꞌi Rom na ru nia ki, ma kamu ka kwatea logo ru God ki fuana God.” ");
INSERT INTO kwf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma kaidaꞋi kira rongoa naꞋa na olisiꞋanga neꞋeri ka leꞋa ꞋunaꞋeri, kira ka Ꞌarefo liu, ma kira ka leka naꞋa Ꞌada faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ana faꞋi asoa neꞋeri logo, ti Sadusi kira leka maꞋi siana sa Jesus. Na Sadusi ki kira saea fasi na ngwae ki noaꞋa kira kasi tataꞋe laꞋu faꞋasia na maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma kira ka saefiloa sa Jesus, kira ka fata Ꞌuri, “Ngwae FaꞋamanata kwa, sa Moses nia keresia na taki fuaka ka alangaꞋi Ꞌuri, ‘DiꞋia ta ngwae nia mae, ma na Ꞌafe nia ka mauri Ꞌua, bore ma noaꞋa nia kasi toꞋo ana ta ngela, na ngwaefuta nia ka korea laꞋu na gwaꞋi Ꞌuru neꞋeri, fasi Ꞌiri kera ka toꞋo ana ta ngela fuana ka talafuila na ngwae neꞋe nia mae naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma taꞋi kwalafa ana kuluꞋa Jiu ki, kira toꞋo ana fiu ngwae asina ki. Ma na ngwae etaeta ka korea taꞋi sariꞋi. Aia, ma ana kaidaꞋi kera kasi toꞋo Ꞌua ana ta ngela, ngwae neꞋeri ka mae naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ruana ngwae ka korea laꞋu na kini neꞋeri. Aia, ma noaꞋa kera kasi toꞋo Ꞌua ana ta ngela logo, ma nia ka mae logo Ꞌana. Uula ngwae ka korea laꞋu, ma ka mae logo. Nia ꞋunaꞋeri leleka fiu ngwae asina neꞋeri ki, kira maemae ka sui. ");
INSERT INTO kwf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Buri Ꞌana bara ngwae asina neꞋe kira mae, kini neꞋe bore ka mae naꞋa logo. ");
INSERT INTO kwf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aia, ma na kini neꞋe nia Ꞌafe Ꞌafe maꞋi fuana fiu ngwae asina neꞋe ki. DiꞋia ꞋunaꞋeri, kaidaꞋi ngwae ki kira tataꞋe faꞋasia maeꞋa, sa tai ana fiu ngwae asina neꞋeri ki neꞋe araꞋi mamana nia?” ");
INSERT INTO kwf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sa Jesus ka olisi kira ka Ꞌuri, “Kaumulu rora naꞋa, sulia kamu kasi sai goꞋo ana na KerekereꞋa Abu ki ma na ngasingasiꞋanga God. ");
INSERT INTO kwf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sulia, kaidaꞋi neꞋe ngwae mae ki kike tataꞋe laꞋu fuana na mauriꞋa, kira diꞋia naꞋa Ꞌada na Ꞌainsel ki Ꞌi langi neꞋe noaꞋa kira kasi kore kini naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“ꞋIu, nau ku faꞋamanata kamu sulia na tataꞋenga faꞋasia na maeꞋa. Nau ku saiana kamu toꞋomani sulia ba God saea Ꞌua naꞋa maꞋi ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘NauꞋa na God sa Abraham, ma na God sa Aesak, ma na God sa Jakob.’ Na fadalana neꞋe Ꞌuri, ngwae neꞋeri ki neꞋe kira mae naꞋa, God nia saea neꞋe nia God kira Ꞌua, osiꞋana kira mauri naꞋa faꞋinia.” ");
INSERT INTO kwf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma ana kaidaꞋi neꞋe ngwae Ꞌoro ki kira fiku kalia sa Jesus, kira rongoa na ru neꞋeri ki, kira ka Ꞌarefo liu ana faꞋamanataꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ana kaidaꞋi neꞋe Farasi ki kira rongoa sa Jesus neꞋe faꞋanotoa naꞋa Sadusi ki Ꞌani na olisiꞋanga nia, kika fiku maꞋi siana. ");
INSERT INTO kwf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma taꞋi ngwae ada neꞋe faꞋamanata Ꞌani taki ki, nia ka iliili Ꞌuana ka faꞋarora sa Jesus Ꞌani na saefiloꞋa ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ngwae faꞋamanata Ꞌae, na taki tae neꞋe talingaꞋi ka liufia taki kia ki taꞋifau kwa?” ");
INSERT INTO kwf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma sa Jesus ka olisia ka Ꞌuri, “‘ꞋOke alafe ana God Ꞌoe, Ꞌania manatamu taꞋifau, ma Ꞌani mangomu taꞋifau, ma Ꞌani liamu taꞋifau.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","NiaꞋa naꞋa neꞋe taki etaeta ma ka talingaꞋi ka tasa. ");
INSERT INTO kwf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruana taki ka diꞋia logo ka Ꞌuri, ‘ꞋOke alafe fuana toꞋolamu ka diꞋia logo neꞋe Ꞌoko alafe fuamu talamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma na taki faꞋasia sa Moses ki taꞋifau, ma na faꞋamanataꞋanga na profet ki kira fiku taꞋifau goꞋo ana ro taki neꞋe ki.” ");
INSERT INTO kwf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ana kaidaꞋi ti Farasi kira fiku kalia sa Jesus, nia saefiloda ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Na Christ, ngwae neꞋe God nia filia fuana faꞋamaurilana ngwae ki, kaumulu saea nia futa maꞋi ana sa tai niniꞋa?” Kira ka olisi Ꞌuri ana, “Na Christ ke baꞋa futa maꞋi ana kwalafa sa David na tatalafaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui sa Jesus ka saefilo kira laꞋu, “DiꞋia nia ka futa goꞋo Ꞌana ana kwalafa sa David na ngwae tatalafaꞋa, faꞋuta mo neꞋe na AnoꞋi ru Abu ba nia faꞋafata sa David ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God nia fata Ꞌuri fuana Aofia nau: ꞋOko tua bali ꞋoloꞋolo aku, ma Ꞌoko gwaungaꞋi faꞋinau, masia kaidaꞋi nau kui alua malimae Ꞌoe ki ke roꞋosuliꞋo.’ ");
INSERT INTO kwf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Sa David Ꞌana talana neꞋe nia saea na Christ Ꞌani na ‘Aofia.’ Nia neꞋe, na Christ nia noaꞋa laꞋu Ꞌalako ana kwalafa sa David goꞋo Ꞌana. NiaꞋa Aofia nia logo.” ");
INSERT INTO kwf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma ana kaidaꞋi neꞋeri, noaꞋa ta ngwae ada kasi bolo naꞋa fuana olisilana Ꞌani ta ru. Ma kira ka Ꞌeke naꞋa Ꞌada fuana saefilolana laꞋu sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ꞋI buri Ꞌana ru neꞋeri, sa Jesus ka fata fuana na ngwae neꞋe kira fiku maꞋi ki, ma na fafarongo nia ki ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na ngwae faꞋamanata ana taki ki, ma na Farasi ki, kira toꞋo ana ngasingasiꞋanga fuana na faꞋamanataꞋanga Ꞌani taki sa Moses ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nia neꞋe, kamu ka roꞋosulida, ma kamu ka sasia na ru ki taꞋifau neꞋe kira saea fuamuꞋa. Bore ma noaꞋa kamu kasi sasi laꞋu sulia na ru neꞋe kira sasiꞋi ki, osiꞋana noaꞋa kira kasi sasi goꞋo sulia na ru neꞋe kira fata sulia. ");
INSERT INTO kwf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kira alua laꞋu ti taki Ꞌoro neꞋe ꞋafitaꞋi fuana na ngwae ki ka roꞋo sulia, bore ma noaꞋa kira kasi maꞋudi goꞋo fuana kwaiꞋafiꞋanga ana ngwae ki fuana sasiꞋa sulia na taki neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ma kira sasi naꞋa ru ki taꞋifau fasi Ꞌiri na ngwae ki ka lisida ma ka fia fasi kira ngwae leꞋa ki. Ma na ru Ꞌuri ki neꞋe kira sasiꞋi. Kira ka firiꞋia Ꞌi maana darada ma Ꞌi limada na reba ru doe ki neꞋe kira keresia na KerekereꞋa Abu ki ana. Ma kira taia na namunamuna ifi kira ki ka keta. ");
INSERT INTO kwf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma kira ka oga liu na tuaꞋa ana kula ꞋinotoꞋa ana na fangaꞋa ki, ma kula ꞋinotoꞋa ki fuana tuaꞋa saena luma fuana foꞋongaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma kira ka oga liu na faꞋadoelada Ꞌi maana usiꞋa ki, ma kira oga ngwae ki ka fata Ꞌuri ada, ‘Ngwae FaꞋamanata nau, neꞋe nau ku roꞋo sulia fatalamu.’ ");
INSERT INTO kwf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Bore ma noaꞋa kasi leꞋa fuana ta ngwae goꞋo Ꞌana neꞋe ka fata Ꞌuri amuꞋa, ‘Ngwae FaꞋamanata nau, neꞋe nau ku roꞋo sulia fatalamu,’ osiꞋana nauꞋa goꞋo neꞋe taꞋi ngwae faꞋamanata kamu, ma kaumulu na barangwai asina saena fikuꞋa faꞋamamanaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma noaꞋa kamu kasi faꞋaꞋinotoꞋa ta ngwae faꞋamanata saena magalia neꞋe Ꞌani alaꞋanga Ꞌuri, ‘MaꞋa kami,’ osiꞋana kaumulu ke faꞋaꞋinotoꞋa goꞋo taꞋi MaꞋa kamu neꞋe nia tua maꞋi langi. ");
INSERT INTO kwf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma noaꞋa kasi leꞋa fuana ta ngwae goꞋo Ꞌana neꞋe ka fata Ꞌuri amuꞋa, ‘Ngwae ꞋaꞋana,’ osiꞋana kaumulu toꞋo goꞋo ana taꞋi ngwae ꞋaꞋana, ma niaꞋa naꞋa neꞋe nauꞋa, na Christ, na ngwae neꞋe God nia filia fuana faꞋamaurilana ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","DiꞋia ta ngwae neꞋe oga ka ꞋaꞋana Ꞌi safitamuꞋa, nia ka diꞋia naꞋa ngwae rao. ");
INSERT INTO kwf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ta ngwae neꞋe ka faꞋadoea nia Ꞌana talana, God ke baꞋa faꞋatiꞋitiꞋia niaꞋa. Ma ta ngwae bore Ꞌana neꞋe ka faꞋatiꞋitiꞋi nia Ꞌana talana, God ke baꞋa fuꞋusi doe ana.” ");
INSERT INTO kwf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ma sa Jesus ka fata laꞋu Ꞌuri, “Nia taꞋa liu fuamuꞋa na faꞋamanata ana taki ki ma kamuꞋa na Farasi ki, kamu ngwae kwalabasa ki! God ke baꞋa kwaꞋi kamu, osiꞋana neꞋe kamu fono Ꞌusia na sinamaa ana ꞋInotoꞋanga God faꞋasia na ngwae ki. KamuꞋa logo noaꞋa kamu kasi oga goꞋo neꞋe muka ruꞋu saena ꞋInotoꞋanga God, ma kamu ka fonea ngwae neꞋe kira faꞋisuꞋusuꞋu Ꞌuana ruꞋungaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nia taꞋa fuamuꞋa na faꞋamanata ana taki ki ma kamu na Farasi ki na ngwae kwalabasa neꞋe kamu Ꞌoi Ꞌana ngwae ki, fasi Ꞌiri kira ka saea kamu Ꞌani na ngwae leꞋa ki. Aia, God ke baꞋa kwaꞋi kamu, sulia kamu laga ulafu liu Ꞌani galilana kula ki taꞋifau, saena asi ma saena tolo, Ꞌuana daoꞋa toꞋona ta ngwae, fasi Ꞌiri ka leka sulia na taki sa Moses ki. Aia, ma ana kaidaꞋi ngwae neꞋe ka leka goꞋo suli kaumulu, kamu fiꞋi sasi akaꞋu goꞋo ana niaꞋa fuana lekaꞋa Ꞌuana kula ana maeꞋa. Ma na kwaꞋikwaꞋinga nia ke baꞋa tasa ka liufia kaumulu sulia na abulalana taꞋa ka liufi kaumulu taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nia taꞋa fuamuꞋa, ma kaumulu diꞋia naꞋa ngwae maa rodo ki neꞋe kira talaꞋia na ngwae ki. Nia neꞋe, God ke kwaꞋi kamu liu, sulia kamu faꞋamanata Ꞌuri ana ngwae ki, ‘Sui bore Ꞌana sa tai neꞋe ka faꞋangasia alangaꞋinga nia Ꞌani na Luma Abu God, nia leꞋa goꞋo Ꞌana diꞋia noaꞋa nia kasi sasi tae neꞋe nia alangaꞋi fuana. Bore ma diꞋia nia ka faꞋangasia alangaꞋinga nia Ꞌani na gol ba saena Luma Abu God, nia neꞋe ka abu liu fuana Ꞌoilana alangaꞋi Ꞌanga nia.’ ");
INSERT INTO kwf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kamu maa rodo, ma muka boleboleꞋa liu. Tae neꞋe doe, na gol nama na Luma Abu God neꞋe sasia gol neꞋe ka abu? Na Luma Abu God neꞋe doe ka liufia na gol! ");
INSERT INTO kwf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma muke faꞋamanata logo na ngwae ki Ꞌuri, ‘Sui bore Ꞌana sa tai neꞋe ka faꞋangasia alangaꞋinga nia Ꞌani na fuli fuꞋa, nia leꞋa goꞋo Ꞌana diꞋia noaꞋa nia kasi sasia tae neꞋe nia alangaꞋi Ꞌani. Ma diꞋia nia ka faꞋangasia alangaꞋinga nia Ꞌani na kwaisuꞋusiꞋanga neꞋe tua fafona fuli fuꞋa, nia neꞋe abu ka tasa fuana Ꞌoilana alangaꞋi Ꞌanga ba nia.’ ");
INSERT INTO kwf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kamu maa rodo. Tae neꞋe doe, kwaisuꞋusiꞋanga nama na fuli fuꞋa neꞋe nia kwatea kwaisuꞋusiꞋanga neꞋe ka abu? Na fuli fuꞋa neꞋe ꞋinotoꞋa ka liufia na kwaisuꞋusiꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","DuꞋungana na fuli fuꞋa neꞋe ꞋinotoꞋa ka liufia na kwaisuꞋusiꞋanga, ma sa tai neꞋe nia faꞋangasia alangaꞋinga nia Ꞌani na fuli fuꞋa, tama nia alangaꞋi Ꞌani na fuli fuꞋa loꞋoko faꞋinia kwaisuꞋusiꞋa ki taꞋifau neꞋe kira tua Ꞌi fafona fuli fuꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma sa tai bore Ꞌana neꞋe ka faꞋangasia alangaꞋinga nia Ꞌani Luma Abu God, ꞋunaꞋeri tama nia alangaꞋi naꞋa Ꞌani God neꞋe nia tua saena Luma Abu neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma diꞋia ta ngwae ka faꞋangasia alangaꞋinga nia Ꞌani Ꞌi langi, tama nia alangaꞋi Ꞌani fuli tuaꞋa God neꞋeriꞋa, ma God neꞋe tua logo Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nia taꞋa fuamuꞋa na ngwae faꞋamanata ana taki ki ma kamuꞋa na Farasi ki, kamu ngwae kwalabasa ki. God ke baꞋa kwaꞋi kamu. Kamu kwatea tangafula ana ru ki fuana God Ꞌani kala ru neꞋe kamu fasiꞋi saena oꞋola kamu ki fuana faꞋa rakufa lana fanga kamu ki, ma noaꞋa kamu kasi manata Ꞌabera goꞋo fuana roꞋongaꞋa sulia faꞋamanataꞋanga doe ana taki ki. Na faꞋamanataꞋanga doe ana taki ki fata Ꞌuri, ‘Ngwae ka sasia naꞋa ru ki taꞋifau neꞋe ꞋoloꞋolo fuana ngwae ki. Nia ka kwaimanatai fuana ngwae ma ka saea ru mamana ki.’ Muke sasia naꞋa ru neꞋeri ki, faꞋinia na ru tiꞋitiꞋi ki saena taki ki logo. ");
INSERT INTO kwf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kamu diꞋia na ngwae maa rodo neꞋe talaꞋia na ngwae ki. Kamu saiana goꞋo amuꞋa manata Ꞌabera Ꞌuana lekaꞋa sulia kala ru saena taki ki. Ma noaꞋa kamu kasi manata Ꞌabera goꞋo Ꞌani ru doe ki saena taki ki. KaidaꞋi kamu sasi ꞋunaꞋeri, ru neꞋe nia lia diꞋia kamu lafua goꞋo Ꞌaumulu na lango faꞋasia tae neꞋe kamu kwaꞋufia, bore ma muke onomia goꞋo Ꞌaumulu na kamel doe. ");
INSERT INTO kwf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nia taꞋa fuamuꞋa na faꞋamanata ana taki ki ma kamu na Farasi ki neꞋe kamu saiana sasilana ru ki fasi Ꞌiri ngwae ki kira ka saeleꞋa Ꞌani kamu. Aia, God ke baꞋa kwaꞋi kamu, osiꞋana kamu madafia liu saꞋulana nonina na titiu fuana fanga ki, bore ma kamu faꞋafunguꞋi Ꞌani na fanga neꞋe kamu ngali Ꞌani suulangaꞋi lana ngwae ki sulia guguta Ꞌanga. ");
INSERT INTO kwf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamu na Farasi ki neꞋe diꞋia maamuꞋa nia rodo! Mulu rokisia naꞋa manataꞋanga kamu ki ka sikasika. DiꞋia neꞋe manataꞋanga kamu ki sikasika, na abulaꞋanga kamu ki bore ka sikasika logo. ꞋUnaꞋeri, na maurilamuꞋa diꞋia na titiu ki neꞋe sikasika Ꞌi nonina ma saena logo. ");
INSERT INTO kwf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nia taꞋa fuamuꞋa na faꞋamanata ana taki ki ma kamu na Farasi ki, kamu kwatea ngwae ki kira ka saea kamu na ngwae leꞋa ki. Bore ma God ke baꞋa kwaꞋi kamu, sulia kaumulu diꞋia kilu gwaꞋu ki neꞋe kira rafua lisilana ka leꞋa Ꞌi maa, bore ma Ꞌi saena nia fungu Ꞌani suli faꞋinia na nonina ngwae neꞋe kira mae, ma kira ka ngwaꞋa naꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ru neꞋe nia mamana Ꞌani kamu, sulia tae ki neꞋe kamu sasia nia lia leꞋa liu maana ngwae ki. Bore ma na manataꞋanga kamu ki taꞋa liu, ma kamu ka saiana na sokelana ngwae. ");
INSERT INTO kwf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Nia taꞋa fuamuꞋa na faꞋamanata ana taki ki, ma kamuꞋa logo na Farasi ki, kamu saiana sasilana na ru ki fuana ngwae ki kira ka saea kamu ngwae leꞋa liu. Bore ma God ke baꞋa kwaꞋi kamu, sulia kamu saea diꞋia kamu tuatua ana kaidaꞋi Ꞌi naꞋo, noaꞋa kamu kasi Ꞌafia goꞋo na koꞋo bora kamu ki fuana saungilana na profet ki. Ma Ꞌi taꞋena muka alua naꞋa fau leꞋa fafona kilu gwaꞋu na profet neꞋeri ki ma na ngwae leꞋa ki Ꞌi naꞋo fuana faꞋakwangalana. ");
INSERT INTO kwf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","KaidaꞋi kamu saea kira na koꞋo kamu ki, nia faꞋataꞋinia kamu futa olitana naꞋa na kwalafa koꞋo taꞋa kamu ki neꞋe kira saungia na profet ki Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aia, ma diꞋia ꞋunaꞋeri, faꞋasuia naꞋa amuꞋa na raoꞋa neꞋe koꞋo kamu ki etangia maꞋi Ꞌi naꞋo! ");
INSERT INTO kwf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","KamuꞋa naꞋa neꞋe abulaꞋanga kamu ki diꞋia na faꞋi loi ki. Ka ꞋafitaꞋi liu fasi kamu ka tafi faꞋasia kwaꞋikwaꞋinga Ꞌani mafula ana kula ni maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","DuꞋungana ru neꞋeri ki, nau ku saea ru neꞋe fuamuꞋa, nai baꞋa kwatea ti profet ma ti ngwae sae Ꞌi ru ma ti faꞋamanata siaumulu. Ma ti ai ada muke baꞋa saungida ma muke fotoꞋida ana Ꞌai rara folo. Ma ti ai ada muke baꞋa dauda ma muke ulasida saena luma fuana foꞋongaꞋa kamu ki, ma muke lali kwailiu ada faꞋasia saena fanoa kamu ki. ");
INSERT INTO kwf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nia neꞋe kwatea God ke baꞋa kwaꞋi kamu fafia na saungilana na ngwae leꞋa taꞋifau, talaꞋae maꞋi ana maelana sa Abel, na ngwae saga, leleka maꞋi ka dao ana maelana sa Sekaraea, na ngela sa Barakaea neꞋe kamu saungia ka mae karangia na fuli foꞋosi saena Luma Abu God. ");
INSERT INTO kwf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nau ku saea fuamuꞋa neꞋe matalangaꞋinga fuana maelana ngwae neꞋeri ki taꞋifau ke baꞋa tua fafomuꞋa ngwae ana kaidaꞋi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma sa Jesus ka lia kwau fuana fanoa Ꞌi Jerusalem, ma ka fata Ꞌuri, “Ngwae ana Jerusalem Ꞌae! Kamu ba ꞋuilaꞋi fau ana na profet ba God nia asungaꞋinida maꞋi fuamuꞋa ki, ma muka saungida. Ana kaidaꞋi Ꞌoro nau ku oga muke leka maꞋi siaku Ꞌiri nau ku lia suli kamu diꞋia ta karai nia ofia na bibina Ꞌi olofana ꞋabaꞋabana. Bore ma noaꞋa kamu kasi oga goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma ana kaidaꞋi neꞋe naꞋa, God ke baꞋa leka faꞋasi kamu, ma ka danga faꞋiburi naꞋa Ꞌani fanoa kamu. ");
INSERT INTO kwf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma nau ku saea fuamuꞋa, noaꞋa kamu kasi lisi nau laꞋu, leleka ka dao ana na kaidaꞋi neꞋe muke fata Ꞌuri, ‘God, Ꞌoko ꞋoilakitaꞋinia na ngwae neꞋe nia leka maꞋi Ꞌani na ngasingasiꞋanga Ꞌoe!’” ");
INSERT INTO kwf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma Ꞌi buri Ꞌana neꞋe sa Jesus fata ꞋunaꞋeri ka sui, nia ka leka faꞋasia Luma Abu God. Ma ana kaidaꞋi sa Jesus ka leka kwau, na fafarongo nia ki kira ka leka maꞋi siana, ma kira ka fata Ꞌuri, “ꞋOko lisia basi Ꞌamu na Luma Abu leꞋa neꞋe ki.” ");
INSERT INTO kwf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sa Jesus ka fata Ꞌuri fuada, “ꞋIu, Ꞌoko lisia na luma doe neꞋe ki. NoaꞋa ta taꞋi gwaꞋi fau Ꞌi neꞋe ana Luma Abu God ke baꞋa teo laꞋu Ꞌi fuila. Kira taꞋifau kike baꞋa takalo Ꞌi ano.” ");
INSERT INTO kwf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Buri Ꞌana, sa Jesus ka raꞋe gwauna faꞋi ua Ꞌi Olif, ma ana kaidaꞋi nia tua Ꞌana, na fafarongo nia ki kira leka maꞋi siana, ma kira ka tua taꞋifili kira. Ma kira ka saefiloa sa Jesus kika Ꞌuri, “KaidaꞋi tae neꞋe na ru nini Ꞌoko saea fuaimili ki ke baꞋa dao maꞋi? Aia, ma tae neꞋe ke baꞋa dao maꞋi fasi Ꞌiri ke faꞋataꞋinia kaidaꞋi Ꞌoe fuana oliꞋa maꞋi faꞋinia kaidaꞋi neꞋe magalia ke baꞋa sui ana?” ");
INSERT INTO kwf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Sa Jesus ka olisi kira ka Ꞌuri fuada, “Muke lia suli kamu, sulia ngwae Ꞌoro ki neꞋe kike baꞋa leka maꞋi Ꞌi nunufana sataku, ma kike soke kamu, kike fata Ꞌuri, ‘NauꞋa na Christ, na ngwae ba God filia.’ Ma ana kaidaꞋi kira sasia naꞋa ru neꞋeri ki, na ngwae Ꞌoro ki kike baꞋa faꞋamamana ana sokeꞋa nari kira ki. Aia, ma kamu ke lia suli kamu, Ꞌasu Ꞌubani ta ngwae ada kata soke kamu, ma muke faꞋamamana ana sokeꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma taꞋi ru laꞋu, muke baꞋa rongoa lingana fuꞋanga ana fanoa karangi ki, ma na alaꞋanga ki sulia fuꞋanga ki ana ti fanoa tau logo maꞋi. Ka ꞋunaꞋeri bore Ꞌana, noaꞋa kamu kasi manata Ꞌabera sulida. Ru ꞋunaꞋeri ki ke baꞋa dao nama maꞋi, bore ma noaꞋa kasi faꞋataꞋinia laꞋu Ꞌisilana magalia neꞋeriꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na maꞋe fanoa ki kike baꞋa fuꞋalida kwailiu, ma na ꞋinotoꞋanga ki kike fuꞋalida kwailiu. Ma na unifioloꞋa ma tikitiki ki ke liu ana kula ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ru neꞋeri ki niꞋi neꞋe etangilana nonifiiꞋa, diꞋia goꞋo Ꞌana na kini faꞋafuta ba nia talaꞋae ka ngela fii. ");
INSERT INTO kwf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ana kaidaꞋi neꞋeri logo, na ngwae ana maꞋe fanoa matamata kwailiu saena magalia neꞋe ki, noaꞋa kira kasi oga kamu, sulia kamuꞋa na ngwae nau ki. Ma ti ngwae ada kike baꞋa dau kamu, ma kike kwate kamu fuana malimae kamu ki fuana kwaꞋilamuꞋa ma fuana saungilamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma ngwae Ꞌoro ki neꞋe kira faꞋamamana ana nauꞋa, noaꞋa kira kasi ngangata ana faꞋamamanaꞋanga. Ma ngwae ki kike baꞋa malimaeꞋa ana kiraꞋa kwailiu. Ma kira ke kwatea na ngwae God ki fuana malimae kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma ana kaidaꞋi neꞋeri, profet ꞋosoꞋoso Ꞌoro kira ke dao maꞋi, ma kira ke talaꞋia, ma kike sokea ngwae Ꞌoro ki, ma kike leka sulia na faꞋamanataꞋanga rora kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma kike baꞋa sasia ru rora Ꞌoro liu ki. Ma sulia ru neꞋe, na alafeꞋanga ngwae Ꞌoro ki ke baꞋa ngwataꞋutaꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sui bore Ꞌana ka ꞋunaꞋeri, diꞋia sa tai neꞋe nia ngangata fuana lekaꞋa sulia God leleka ka dao Ꞌisilana kaidaꞋi neꞋeri, nia neꞋe God ke baꞋa faꞋamauria. ");
INSERT INTO kwf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma FaꞋarongoꞋanga LeꞋa neꞋe sulia ꞋInotoꞋanga God, kike baꞋa faꞋarongo Ꞌani saena magalia fuana ngwae ki taꞋifau. Buri Ꞌana naꞋa, Ꞌisilana magalia fiꞋi dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma kaumulu ke baꞋa lisia na Ru Sua ke tataꞋe maꞋi ana kula abu. Na ru taꞋa neꞋeri ke faꞋasua na Luma Abu God, ma ke sasi Ꞌiri God ke malangisia. Aia, ru neꞋe profet Daniel eta fata naꞋa maꞋi sulia Ꞌi naꞋo.” (Na alaꞋanga fuana na ngwae neꞋe nia toꞋomaꞋi nia Ꞌuri: ꞋOko malingaꞋi leꞋa ana na fadalana ru neꞋe.) ");
INSERT INTO kwf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“KaidaꞋi muke lisia na ru neꞋe ki ka dao maꞋi, na ngwae ki neꞋe kira tua ana na abaꞋi kula Ꞌi Judea, kike tafi Ꞌuana gwauna faꞋi ua ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ana kaidaꞋi neꞋeri, diꞋia ta ngwae ka tua maꞋi Ꞌi maa ana luma nia, nia ka tafi ꞋaliꞋali, ma noaꞋa nia kasi manata laꞋu Ꞌuana ruꞋungaꞋa saena luma nia Ꞌuana ngalilana ta ru Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma sa tai neꞋe ka tua maꞋi Ꞌana saena oꞋola, noaꞋa nia kasi oli laꞋu maꞋi luma Ꞌuana ta toro Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","KwaimanataiꞋanga doe liu fuada bara kini neꞋe kira ina ki, ma kira ka faꞋasusufia kala ngela tiꞋitiꞋi ki ana kaidaꞋi neꞋeri, sulia nia ꞋafitaꞋi liu kira ka tafi ꞋaliꞋali. ");
INSERT INTO kwf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞋIu, muke foꞋo ma muka gania God, fasi Ꞌiri ru neꞋe noaꞋa kasi fuli laꞋu ana ma kamu ka tafi ana kaidaꞋi ana gwariꞋa, nama na Sabat, asoa ana mamaloꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","DuꞋungana na nonifiiꞋanga ana faꞋi asoa neꞋeri ki, nia ke baꞋa taꞋa ka liufia na nonifiiꞋanga neꞋe ngwae saena magalia ki kira saiana, Ꞌita Ꞌua maꞋi ana safalilana kaidaꞋi God nia saungaꞋinia na magalia ka dao ana kaidaꞋi neꞋe. Ma noaꞋa naꞋa ta ru ꞋunaꞋeri neꞋe ke fuli maꞋi Ꞌi buri. ");
INSERT INTO kwf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma diꞋia God kasi faꞋadokodokoa kaidaꞋi ana nonifiiꞋanga, nia ꞋafitaꞋi neꞋe ta ngwae ke mauri. Ma nia faꞋadokodokoa kaidaꞋi neꞋeri fuana leꞋalana ngwae neꞋe nia filida ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ꞋIu, diꞋia ta ngwae ka fata Ꞌuri fuaumulu, ‘Lisia basi, nia naꞋa ne na Christ,’ nama ka fata Ꞌuri, ‘Lisia basi, nia naꞋa Ꞌi loꞋoko,’ noaꞋa kamu kasi faꞋamamana nia. ");
INSERT INTO kwf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sulia na ngwae ꞋosoꞋoso ki ke baꞋa dao maꞋi, ma kike fata Ꞌuri, ‘NauꞋa na Christ,’ faꞋinia na ngwae ꞋosoꞋoso ki kike fata Ꞌuri, ‘NauꞋa ta profet.’ Ma kike fulia faꞋanadaꞋa doe ki fasi Ꞌiri ke talaꞋi rora ana na ngwae neꞋe God nia filida ki bore ma nia ꞋafitaꞋi liu fuada. ");
INSERT INTO kwf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nia neꞋe, sui bore Ꞌana ru neꞋe ki noaꞋa kira kasi dao Ꞌua maꞋi, nau ku saea naꞋa fuamuꞋa Ꞌi naꞋo, fasi Ꞌiri muke saiana. ");
INSERT INTO kwf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“Ana kaidaꞋi nau, na Ngela Ngwae, nau ku oli maꞋi, ngwae ki taꞋifau kike baꞋa lisi nau. DiꞋia logo neꞋe kamu saiana lisilana meamea kaidaꞋi nia mea maꞋi ana bali tataꞋelana sina leka ka dao maꞋi bali sulana sina saena mamanga. Aia, diꞋia ti ngwae kira fata Ꞌuri fuamuꞋa, ‘Na Christ tua saena abaꞋi kula kwasi,’ noaꞋa kamu kasi leka Ꞌuana kula neꞋeri. DiꞋia ti ngwae kira fata Ꞌuri fuamuꞋa, ‘Christ ba ago Ꞌi neꞋe,’ noaꞋa kamu kasi faꞋamamana ana alaꞋanga ꞋunaꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Na olilaku maꞋi noaꞋa ta ngwae kasi talafia, ka diꞋia logo neꞋe na afa noaꞋa kasi talafia ta ru mae. ");
INSERT INTO kwf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ꞋI buri Ꞌana kaidaꞋi neꞋe nonifiiꞋanga neꞋeri ki ka sui mala, ‘God ke fonea na madaꞋafi, ma na madamo, ma noaꞋa keroꞋa kasi sina. Ma God ke kwate na bulubulu ki kike baꞋa Ꞌasida faꞋasia mamanga. Ma God ke sasi na ru Ꞌi langi ki, kike leka rora faꞋasia fulida.’ ");
INSERT INTO kwf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Buri Ꞌana ru neꞋe ki, na maꞋetoto ana olilaku maꞋi fiꞋi faꞋataꞋi maꞋi saena mamanga. Ma ana kaidaꞋi neꞋeri goꞋo, na ngwae ki taꞋifau saena magalia, kike angi sulia kira ka lisi nau ku oli maꞋi fafona gwaꞋi salo saena mamanga, ma nai baꞋa leka maꞋi faꞋinia ngasingasiꞋanga nau faꞋinia na madakoꞋanga doe nau. ");
INSERT INTO kwf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma na Ꞌainsel ke ufia na bungu ke baꞋa angi doe fuana fikulana na ngwae nau ki neꞋe nau ku filida taꞋifau naꞋa. Ana kaidaꞋi neꞋeri, nau ku kwatea maꞋi Ꞌainsel nau ki, Ꞌiri kike baꞋa ukua maꞋi ngwae nau ki taꞋifau faꞋasia na fanoa ki taꞋifau saena magalia.” ");
INSERT INTO kwf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","GoꞋo, sa Jesus ka fata sulia tarifulaꞋa ka Ꞌuri, “Kamu ke manata basi sulia na Ꞌai figi ki. KaidaꞋi kamu lisia na rauna nia ngosa, muke saiana na kaidaꞋi fuana unitaꞋi ꞋakoꞋakoꞋa nia dao karangi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka ꞋunaꞋeri logo, kaidaꞋi kamu lisia na nonifiiꞋanga neꞋeri ki taꞋifau ke baꞋa dao maꞋi, muke saiana na olilaku maꞋi nia karangi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ru mamana neꞋe nau ku saea fuamuꞋa, ngwae ki taꞋifau neꞋe kira mauri ana kaidaꞋi neꞋe, kira kasi mae Ꞌi naꞋona ru neꞋeri ki taꞋifau ke baꞋa dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na ru ki taꞋifau maꞋi langi ma saena magalia kike baꞋa sui. Bore ma na fatalaku goꞋo neꞋe tuatua noaꞋa kasi sui. ");
INSERT INTO kwf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“NoaꞋa ta ngwae kasi saiana kaidaꞋi nai baꞋa oli maꞋi ana. Na Ꞌainsel ki bore noaꞋa kasi sai logo ana, ma nauꞋa, na Ngela bore, nau kusi sai logo ana. God na MaꞋa taꞋifilia goꞋo neꞋe nia saiana. ");
INSERT INTO kwf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na olilaku maꞋi ke baꞋa diꞋia ru ba fuli ana kaidaꞋi ba sa Noa. ");
INSERT INTO kwf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ana faꞋi asoa ba Ꞌi naꞋo ki, ana na igo doe baera, na ngwae ki kira fanga ma kira ka kwaꞋu Ꞌada, ma na ngwae ki ma na kini ki kira ka araꞋi Ꞌada ma kira ka kwate kini Ꞌada kwailiu, leleka ka dao goꞋo ana faꞋi asoa ba sa Noa nia raꞋe saena na faka doe ba nia. ");
INSERT INTO kwf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bore Ꞌana, kira kina Ꞌua na tae neꞋe ka dao maꞋi, leleka ka dao ana kaidaꞋi neꞋe igo doe baera dao maꞋi, ma ka lauda naꞋa Ꞌana. Ma nia ke baꞋa dao logo maꞋi Ꞌuri ana kaidaꞋi nai baꞋa dao maꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ana kaidaꞋi neꞋeri, ro ngwae ki kera rao saena na oꞋola. Ma nau ku ngalia ta taꞋi ngwae faꞋi nau, ma ta taꞋi ngwae nau ku faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma ro kini ki logo kera ka rao adaroꞋo ana fanga ki, ma ta taꞋi ai nau ku ngalia, ma ruana nau ku faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Muke lialia leꞋa, sulia kamu kina faꞋi asoa tae neꞋe nau, na Aofia kamu, nai dao maꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Muke manata toꞋona ru neꞋe, diꞋia na ngwae ana luma ka sai goꞋo Ꞌana ana kaidaꞋi neꞋe ngwae bili ke baꞋa dao maꞋi ana, nia ka lialia leꞋa ma noaꞋa kasi alaꞋania na ngwae bili neꞋeri ka ruꞋu maꞋi saena luma nia. ");
INSERT INTO kwf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nia neꞋe, muke kwaimasi logo, sulia nai baꞋa dao maꞋi ana kaidaꞋi neꞋe noaꞋa kamu kasi saiana.” ");
INSERT INTO kwf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma sa Jesus ka fata laꞋu Ꞌuri fuana na fafarongo ki, “Kamu diꞋia na ngwae rao neꞋe nia liatoꞋo ma nia ka rao saga. Ma na araꞋi ꞋaꞋana ke alua nia ka lia sulia na ngwae rao ki, ma ka kwatea na fanga fuada ana kaidaꞋi fuana kwate fangaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma ꞋoilakiꞋa fuana na ngwae rao neꞋeri neꞋe ngwae ꞋaꞋana nia dao toꞋona ma nia sasi ru neꞋeri ki, ana kaidaꞋi neꞋe nia dao maꞋi ana Ꞌi luma nia! ");
INSERT INTO kwf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nau ku saea na ru mamana fuamuꞋa, na ngwae ꞋaꞋana alu nia ka lia sulia ru nia ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Bore ma, diꞋia nia na ngwae rao taꞋa, nia ka manata Ꞌuri, ‘Na ngwae ꞋaꞋana nau, daolana maꞋi nia tau Ꞌua.’ ");
INSERT INTO kwf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma nia ka talaꞋae fuana kwaꞋilana na ngwae rao ki, ma nia ka tua ni fanga naꞋa Ꞌana ma ka kwaꞋu lilinga naꞋa Ꞌana faꞋinia ngwae kwaꞋu lilinga ki. ");
INSERT INTO kwf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sui ma na ngwae ꞋaꞋana ka dao maꞋi ana ta asoa neꞋe nia noaꞋa kasi kwaimaꞋakwali ana, ma ana kaidaꞋi neꞋe nia kina goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na ngwae ꞋaꞋana ke kwatea na kwaꞋikwaꞋinga Ꞌafae fuana niaꞋa, ma ka alua niaꞋa faꞋinia ngwae kwalabasa ki neꞋe sokeꞋe roꞋo sulia God. Ma kaidaꞋi nia ka tua ana kula neꞋeri, nia ka angi angi goꞋo Ꞌana faꞋinia na Ꞌala girigiri Ꞌanga, osiꞋana nia ka nonifii liu.” ");
INSERT INTO kwf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma sa Jesus ka fata laꞋu Ꞌuri, “Ana kaidaꞋi neꞋe nau ku oli laꞋu maꞋi, na ꞋInotoꞋanga God ke baꞋa diꞋia na akwala kini sariꞋi neꞋe kira ngalia naꞋa faꞋi unu kira ki, ma kira ka kwaimaꞋakwali ana na araꞋi faolu neꞋe ke leka maꞋi ka ngalida Ꞌuana saena na fafangaꞋa ana ara araꞋinga. ");
INSERT INTO kwf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma ta lima kini sariꞋi ada kira taꞋi boleboleꞋa, ma ta lima ai ada kira ka manataꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na kini sariꞋi boleboleꞋa neꞋeri ki kira ngalia naꞋa faꞋi unu kira ki, bore ma noaꞋa kira kasi ngalia goꞋo ta suliꞋi ru neꞋe ka bolo fuana faꞋaduꞋalana unu kira ki faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma na ai neꞋe manataꞋa ki kira ngalia na biꞋi suliꞋi ru doe fuana faꞋaduꞋalana unu faꞋinia na faꞋi unu kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma na araꞋi faolu neꞋeri noaꞋa kasi dao ꞋaliꞋali, ma na kini sariꞋi neꞋeri ki maada ka mamaliuꞋa taꞋifau, ma kira ka maliu naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma saena tofongana rodo, na ngwae ki kira ri kika Ꞌuri, ‘Na araꞋi faolu nia dao naꞋa maꞋi! Muke leka, ma muke saka fuana.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na akwala kini sariꞋi neꞋeri kira ka tataꞋe, ma kira ka faꞋaduꞋa na faꞋi unu kira ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma na kini sariꞋi boleboleꞋa neꞋeri ki kira ka fata Ꞌuri fuana na kini sariꞋi manataꞋa neꞋeri ki, ‘Muke kwatea ta suliꞋi ru fuana duꞋangaꞋa Ꞌaimili, sulia neꞋe suliꞋi ru kaimili ki fuana duꞋangaꞋa karangi ka sui naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Sui kira olisida kika Ꞌuri, ‘NoaꞋa goꞋo, osiꞋana noaꞋa nia kasi bolo naꞋa faꞋi kulu taꞋifau. Muke leka Ꞌaumulu ana ta luma, Ꞌiri muke folia ta suliꞋi ru fuana duꞋangaꞋa Ꞌaumulu.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma kaidaꞋi kira leka fuana foliꞋa, na araꞋi faolu neꞋeri ka dao maꞋi. Ma na sariꞋi neꞋeri ki neꞋe kira sasi akaꞋu, kira ka leka naꞋa Ꞌada faꞋinia Ꞌuana na fangaꞋa ana araꞋinga. Ma kira ka fono naꞋa Ꞌusia na sinamaa. ");
INSERT INTO kwf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ma Ꞌi buri Ꞌana na kini sariꞋi ba kiri, kira ka dao logo maꞋi, kira ka Ꞌuri, ‘AraꞋi Ꞌae! ꞋOke Ꞌifingia kwau na sinamaa fuamiꞋa!’ ");
INSERT INTO kwf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma na araꞋi faolu neꞋeri ka olisida ka Ꞌuri, ‘Ru mamana nau ku saea fuamuꞋa, nau ku kina kaumulu.’” ");
INSERT INTO kwf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma sa Jesus ka faꞋasuia naꞋa tarifulaꞋanga neꞋe ka Ꞌuri, “Ta neꞋe, kamu ke lialia leꞋa, sulia kamu kina faꞋi asoa nama kaidaꞋi neꞋe nai baꞋa dao laꞋu maꞋi ana.” ");
INSERT INTO kwf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui sa Jesus ka saea laꞋu na tarifulaꞋanga neꞋe fuana na fafarongo nia ki ka Ꞌuri, “Ana kaidaꞋi nai baꞋa oli maꞋi, na ꞋInotoꞋanga God nia diꞋia taꞋi ngwae ba nia leka ana ta kula tau, ma ka saea naꞋa ngwae rao nia ki, ma ka kwate kira ka lia sulia na toꞋoruꞋa nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma nia ka kwatea lima toꞋoni selene ki fuana taꞋi ngwae. Ma fuana ta ngwae laꞋu, nia ka kwatea ro toꞋoni selene ki. Ma fuana ta ngwae laꞋu, nia ka kwatea taꞋi toꞋoni selene. Nia ka kwatea ka bolo naꞋa faꞋinia na sai Ꞌi ruꞋanga kira ki. Sui nia ka leka naꞋa Ꞌana ana lekaꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma na ngwae neꞋe ngalia naꞋa lima toꞋoni selene ki, nia ka rao Ꞌani, ma ka toꞋo laꞋu ana ta lima toꞋoni selene. ");
INSERT INTO kwf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma na ngwae ba ngalia naꞋa ro toꞋoni selene ki, nia ka rao logo Ꞌani, ma ka toda ta ro toꞋoni selene laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bore ma na ngwae ba ngalia taꞋi toꞋoni selene, nia ka leka, ma ka Ꞌilia taꞋi kilu saena na ano, ma ka sofongaꞋinia Ꞌana selene ba na araꞋi ꞋaꞋana nia kwatea fuana. ");
INSERT INTO kwf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma buri Ꞌana kala kaidaꞋi tau, na araꞋi ꞋaꞋana ba kira ka oli maꞋi, ma nia oga ka saiana selene ba nia ki faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma na ngwae ba ngalia lima toꞋoni selene ki, ka ngalia laꞋu maꞋi ta lima toꞋoni selene, ma ka fata Ꞌuri, ‘AraꞋi ꞋaꞋana Ꞌae, Ꞌoko kwatea lima toꞋoni selene ki fuaku ba. ꞋOke lisia basi, nau ku toda laꞋu ta lima toꞋoni selene fafia.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma na araꞋi ꞋaꞋana nia ka olisia ka Ꞌuri, ‘ꞋOe ngwae ni rao leꞋa nau. Nau ku saiana, nau ku manata fitoꞋamu! ꞋOko rao leꞋa Ꞌani ru tiꞋitiꞋi ki, nia neꞋe nau ku alu Ꞌoe, Ꞌoko doe fafia naꞋa ru Ꞌoro ki. ꞋOke leka maꞋi, ma Ꞌoko saeleꞋa Ꞌamu faꞋi nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma na ngwae neꞋe ngalia ro toꞋoni selene ki ka dao logo maꞋi. Ma ka fata Ꞌuri, ‘AraꞋi ꞋaꞋana Ꞌae, Ꞌoko kwatea goꞋo ro toꞋoni selene ki fuaku ba. ꞋOke lisia basi, nau ku toda laꞋu ta ro toꞋoni selene fafia.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma na araꞋi ꞋaꞋana nia ka olisia ka Ꞌuri, ‘ꞋOe ngwae ni rao leꞋa nau, nau ku saiana nau ku fitoꞋamu! ꞋOko rao leꞋa Ꞌani ru tiꞋitiꞋi ki. Nia neꞋe nai baꞋa alu Ꞌoe, Ꞌoke doe fafia na ru Ꞌoro ki. ꞋOke leka maꞋi, ma Ꞌoko saeleꞋa Ꞌamu faꞋi nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sui na ngwae ba ngalia taꞋi toꞋoni selene, ka dao maꞋi. Ma nia ka fofoni ru goꞋo Ꞌana ka fata Ꞌuri, ‘AraꞋi ꞋaꞋana Ꞌae, nau ku saiana ꞋaeꞋo na ngwae neꞋe fatalamu Ꞌinikere. ꞋOko loia naꞋa ru ki goꞋo Ꞌamu ana kula neꞋe noaꞋa Ꞌoe kosi fasia, ma Ꞌoko ngalia goꞋo Ꞌamu ru ngwae matamata ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nia neꞋe nau ku maꞋu, ma nau ku leka sofongaꞋinia naꞋa selene ba Ꞌoe saena na ano. ꞋOko lisia mani ba Ꞌoe nama goꞋo niniꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma na araꞋi ꞋaꞋana nia ka olisia ka Ꞌuri, ‘ꞋAeꞋo na ngwae rao taꞋa, ma Ꞌoko Ꞌaila busu. ꞋOko sai goꞋo Ꞌamu ana neꞋe nau ku loia ru ana kula neꞋe noaꞋa kusi fasia, ma ku ngalia goꞋo Ꞌaku ru ngwae matamata ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","DiꞋia Ꞌoko manata ꞋunaꞋeri, faꞋuta neꞋe noaꞋa Ꞌoe kosi alua Ꞌamu na selene nau ki saena kula ni alu maniꞋa fasi Ꞌiri ka Ꞌoro, ma ka dao ana kaidaꞋi nau ku oli maꞋi ana, nau ku ngalia naꞋa selene neꞋeri ma na selene tarenga ki faꞋinia.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sui na araꞋi ꞋaꞋana neꞋeri ka fata Ꞌuri fuana na ngwae ni rao nia ki laꞋu, ‘Muke ngalia naꞋa selene neꞋe ki faꞋasia, ma kamu ka kwatea fuana na ngwae neꞋe toꞋo ana taꞋi akwala toꞋoni selene. ");
INSERT INTO kwf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sulia na ngwae ki taꞋifau neꞋe kira toꞋo ana ru Ꞌoro ki, nai baꞋa kwatea laꞋu ti ru fuada, fasi Ꞌiri kira ka toꞋo ana ru ki ka tatakolaꞋa. Ma sa tai bore Ꞌana neꞋe noaꞋa kasi toꞋo ana ta ru, ma nia ka toꞋo ana ta ru tiꞋitiꞋi bore Ꞌana, nai baꞋa lafua faꞋasi nia. ");
INSERT INTO kwf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma na ngwae ni rao neꞋe, muke Ꞌui Ꞌania Ꞌi maa saena na maꞋe rodo, kula neꞋe ngwae ki ka angi angi goꞋo Ꞌada faꞋinia na Ꞌala girigiri Ꞌanga, osiꞋana nia nonifii liu.’” ");
INSERT INTO kwf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sa Jesus ka fata laꞋu Ꞌuri fuana na fafarongo nia ki, “KaidaꞋi nauꞋa, na Ngela Ngwae, nai baꞋa oli laꞋu maꞋi Ꞌuana na tatalafaꞋanga faꞋinia na Ꞌainsel ki, nai baꞋa tua ana fuli gwauruꞋa na ngwae tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma na ngwae ki taꞋifau faꞋasia fanoa ki taꞋifau kike baꞋa fiku maꞋi Ꞌi naꞋoku. Ma nai baꞋa daroꞋia na ngwae ki taꞋifau, diꞋia ta ngwae ba nia lia sulia na sipsip ki ka daroꞋia na sipsip ki faꞋasia na nanigot ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma nau ku alua naꞋa ngwae saga ki Ꞌi bali ꞋoloꞋolo aku, ma na ngwae taꞋa ki Ꞌi bali mauli aku. ");
INSERT INTO kwf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Sui nau ku fata Ꞌuri fuana ngwae neꞋe kira tua Ꞌi bali ꞋoloꞋolo aku, ‘Kaumulu naꞋa ngwae neꞋe MaꞋa nau faꞋasaeleꞋa kamu ki. Muke ruꞋu maꞋi Ꞌi saena ꞋInotoꞋanga neꞋe nia sasi akaꞋu ana fuamuꞋa Ꞌita naꞋa maꞋi ana etangilana naꞋa maꞋi na magalia. ");
INSERT INTO kwf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sulia kaidaꞋi nau ku fiolo ana, kamu kwatea fanga fuaku. Ma kaidaꞋi nau ku silikwaꞋu ana, kamu kwatea kafo fuaku. Ma bore Ꞌana nau na ngwae dao faꞋasia ta fanoa matamata, kamu kwalo nau Ꞌuana saena luma kamu ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma kaidaꞋi ka noaꞋa Ꞌaku ta toro, kamu kwate toro fuaku. Ma kaidaꞋi nau ku mataꞋi, kamu lia sulia nau. Ma kaidaꞋi nau ku tua Ꞌi saena luma ni lokafo, kamu maa toꞋoku.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sui naꞋa ngwae saga ki kira ka olisia kika Ꞌuri, ‘Aofia kwa, kaidaꞋi tae neꞋe kami lisia Ꞌoko fiolo, ma kami ka sareꞋo? KaidaꞋi tae neꞋe Ꞌoko silikwaꞋu, ma kami ka kwatea kafo fuamu? ");
INSERT INTO kwf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma kaidaꞋi tae neꞋe Ꞌoe na ngwae dao faꞋasia na fanoa matamata, ma kami ka kwalo Ꞌoe Ꞌi luma, nama kaidaꞋi tae neꞋe noaꞋa Ꞌamu ta toro, ma kami ka kwate toro fuamu? ");
INSERT INTO kwf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma kaidaꞋi tae neꞋe kami lisia neꞋe Ꞌoko mataꞋi ana, nama Ꞌoko tua saena na luma ni lokafo, ma kami ka leka maa toꞋomu?’ ");
INSERT INTO kwf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma nau ku olisida nau ku Ꞌuri, ‘Ru mamana nau ku saea fuamuꞋa, kaidaꞋi kamu sasia ta ru ꞋunaꞋeri fuana ta ngwae bore Ꞌana neꞋe noaꞋa kira kasi lia doe ana, kamu sasia naꞋa fuaku.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sui nai baꞋa fata Ꞌuri fuada na ngwae neꞋe kira tua Ꞌi bali mauli aku, ‘Kamu ke leka tau kwau faꞋasi nau. God ke baꞋa kwaꞋi kamu. Ma kamu ke leka saena na mafula neꞋe tuatua firi, neꞋe God nia sasi akaꞋu ana fuana sa Saetan ma na Ꞌainsel taꞋa nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sulia nau ku fiolo, ma kamu kasi kwatea goꞋo ta fanga fuaku. Ma kaidaꞋi nau ku silikwaꞋu, noaꞋa kamu kasi kwatea goꞋo ta kafo fuaku. ");
INSERT INTO kwf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma kaidaꞋi nau ku dao maꞋi, kamu kasi kwalo nau goꞋo fuana luma kamu ki. Ma kaidaꞋi ka noaꞋa Ꞌaku ta toro, noaꞋa kamu kasi kwate toro goꞋo fuaku. Ma kaidaꞋi nau ku mataꞋi ma ku tua Ꞌi saena na luma ni lokafo, noaꞋa kamu kasi lia goꞋo suli nau.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma kira ka olisia kira ka Ꞌuri, ‘Aofia kwa, kaidaꞋi tae neꞋe kami lisiꞋo, Ꞌoko fiolo, nama Ꞌoko silikwaꞋu, nama Ꞌoe na ngwae dao, nama ka noaꞋa Ꞌamu ta toro, nama Ꞌoko mataꞋi nama Ꞌoko tua Ꞌi saena na luma ni lokafo, ma noaꞋa kami kasi ꞋafiꞋo goꞋo?’ ");
INSERT INTO kwf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma nau ku olisida ku Ꞌuri, ‘Ru mamana nau ku saea fuamuꞋa, kaidaꞋi kamu kasi kwaiꞋafi ana ta ngwae bore ana neꞋe noaꞋa kira kasi lia doe ana, kamu sasia naꞋa fuaku.’ ");
INSERT INTO kwf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Sui kira ka leka naꞋa Ꞌada Ꞌuana na kwaꞋikwaꞋinga neꞋe tuatua firi, ma na ngwae saga ki kira ka leka naꞋa Ꞌuana na mauriꞋa firi.” ");
INSERT INTO kwf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","KaidaꞋi sa Jesus nia faꞋamanata Ꞌani ru neꞋe ki ka sui, nia ka fata Ꞌuri fuana na fafarongo nia ki, ");
INSERT INTO kwf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kaumulu saiana ka sui naꞋa, FangaꞋa ana DaofaꞋi LiuꞋa ke baꞋa fuli fafonai. Ma ana kaidaꞋi neꞋeri, kike baꞋa kwate nau, na Ngela Ngwae, fuana malimae nau ki, Ꞌiri kike foto fafi nau ana Ꞌai rara folo.” ");
INSERT INTO kwf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma ana taꞋi kaidaꞋi neꞋeri logo, na fata abu doe ki, ma na ngwae faꞋinaꞋonaꞋo Jiu ki, kira ka fiku saena luma doe na ꞋingataꞋi fata abu neꞋe satana sa Kaeafas. ");
INSERT INTO kwf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma kira ka lokoa, fasi Ꞌiri kike dao toꞋona ta kaidaꞋi fuana kike dau ago ana sa Jesus, ma kira ka saungia. ");
INSERT INTO kwf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma kira ka fata kwailiu Ꞌuri, “NoaꞋa kulu kasi daua ana faꞋi asoa ana fangaꞋa, Ꞌasu Ꞌubani ngwae ki kira kata fuꞋali kulu.” ");
INSERT INTO kwf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma sa Jesus faꞋinia na fafarongo nia ki, kira leka kwau Ꞌuana Ꞌi Betani, kira ka tua saena luma sa Simon, na ngwae ba na kuu saungia Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ana kaidaꞋi sa Jesus nia fanga, taꞋi kini leka maꞋi siana faꞋinia na biꞋi nura neꞋe kwanga liu, ma nia fungu Ꞌani na ngwaingwai neꞋe moko ufiufi leꞋa, ma na folilana ka doe liu. Nia leka maꞋi, ma ka kisitani Ꞌi fafona gwauna sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma ana kaidaꞋi neꞋe fafarongo nia ki kira lisia, kira ka saetaꞋa, ma kika fata Ꞌada talada Ꞌuri, “FaꞋuta neꞋe kini neꞋe ka faꞋalia ngwaingwai leꞋa neꞋe? ");
INSERT INTO kwf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngwaingwai neꞋe, diꞋia kulu foli Ꞌani, mani doe neꞋe kulu ke baꞋa ngalia Ꞌuana. Ma kulu ka ngalia na mani neꞋeri fuana Ꞌafilana ngwae dalaꞋa ki!” ");
INSERT INTO kwf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma sulia sa Jesus nia sai goꞋo Ꞌana ana tae neꞋe kira fata sulia, nia ka fata Ꞌuri fuada, “FaꞋuta neꞋe kamu ka fata ꞋunaꞋeri, ma kamu ka faꞋaꞋekea kini neꞋe? Ru leꞋa liu neꞋe nia sasia naꞋa fuaku. ");
INSERT INTO kwf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na ngwae dalaꞋa ki kira tua goꞋo Ꞌada faꞋi kamu sulia asoa ki. Bore ma nauꞋa, kaidaꞋi dokodoko goꞋo Ꞌana neꞋe nai baꞋa tua faꞋi kamu. ");
INSERT INTO kwf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma ana kaidaꞋi na kini neꞋe nia kisitani na ngwaingwai neꞋe ana na noniku, nia sasi akaꞋu ana nauꞋa masia kwaiatolaku saena kilu gwaꞋu ana faꞋi asoa ana maelaku. ");
INSERT INTO kwf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma nau ku saea fuamuꞋa, ana fanoa ki taꞋifau saena magalia neꞋe na FaꞋarongoꞋanga LeꞋa kira ke fatataloꞋania sulia, tae neꞋe kini neꞋe nia sasia fuaku, kike baꞋa rongoa naꞋa logo fuana na manataꞋanga toꞋona.” ");
INSERT INTO kwf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Buri Ꞌana ru neꞋe ki sui, taꞋi ngwae ana akwala ma ro fafarongo sa Jesus ki, satana sa Judas Iskariot ka leka siana na fata abu doe ki. ");
INSERT INTO kwf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ka saefilo kira ka Ꞌuri, “DiꞋia nau ku kwatea sa Jesus fuaumulu, tae neꞋe kamu ke baꞋa kwatea fuaku?” Ma kira ka toꞋomani uulu akwala selene ki, ma kira ka kwatea fuana. ");
INSERT INTO kwf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","TalaꞋae ana kaidaꞋi neꞋeri, sa Judas ka lialia naꞋa Ꞌuana ta kaidaꞋi neꞋe bolo fuana kwatelana sa Jesus fuada. ");
INSERT INTO kwf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma ana etana asoa ana fangaꞋa neꞋe kira saea Ꞌani, “Beret neꞋe noaꞋa ta Isi ana,” na fafarongo ki kira leka maꞋi siana sa Jesus, ma kira ka saefilo Ꞌuri ana, “ꞋI fai neꞋe Ꞌoko oga kami ka sasi akaꞋu ana FangaꞋa ana DaofaꞋi LiuꞋa fuamu?” ");
INSERT INTO kwf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma sa Jesus ka fata Ꞌuri fuada, “Kamu ke leka kwau Ꞌuana Ꞌi Jerusalem. Ana kaidaꞋi kamu dao siana taꞋi ngwae neꞋe nau ku filia, kamu ka fata Ꞌuri fuana, ‘Ngwae faꞋamanata kaimili, nia saea kaidaꞋi nia dao karangi naꞋa. Nia faꞋinia na fafarongo nia ki kike Ꞌania na FangaꞋa ana DaofaꞋi LiuꞋa Ꞌi luma Ꞌoe.’” ");
INSERT INTO kwf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana kaidaꞋi neꞋe, fafarongo ki kira leka, ma kika alaꞋa faꞋinia na ngwae neꞋeri diꞋia ba sa Jesus saea naꞋa fuada, ma kira ka sasi akaꞋu naꞋa ana fangaꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma Ꞌi saꞋulafi, sa Jesus ka tua Ꞌi neꞋeri Ꞌiri ka fanga faꞋinia na akwala ma ro fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma kaidaꞋi kira fanga naꞋa, sa Jesus ka fata Ꞌuri fuada, “Ru mamana nau ku saea fuamuꞋa, taꞋi ngwae ana kaumulu ke kwate nau fuana malimae nau ki.” ");
INSERT INTO kwf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","KaidaꞋi na fafarongo ki kira rongoa ru neꞋe, kira ka kwaimanatai liu. Ma taꞋi taꞋi ngwaeꞋa ada kira fiꞋi talaꞋae ana saefilolana sa Jesus kika Ꞌuri, “Aofia kwa, Ꞌuri ma Ꞌoko fata Ꞌani nauꞋa neꞋeriꞋa?” Ma kiraꞋa taꞋifau goꞋo neꞋe kira fata ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sui sa Jesus ka Ꞌuri, “TaꞋi ngwae aumulu, neꞋe nia ke tongani afu beret nia Ꞌi saena na dako faꞋi nau, nia neꞋe ke baꞋa kwate nau fuana malimae nau ki. ");
INSERT INTO kwf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","NauꞋa, na Ngela Ngwae, nai baꞋa mae diꞋia na KerekereꞋa Abu ba saea ka sui naꞋa maꞋi naꞋo. Ma kwaimanatai liu fuana na ngwae neꞋe ke baꞋa kwate nau fuana malimae nau ki. Nia leꞋa fuana na ngwae neꞋeri diꞋia nia kasi futafuta goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ana kaidaꞋi neꞋeri, sa Judas ba, na ngwae neꞋe ke baꞋa kwatea sa Jesus fuana malimae nia ki, nia ka fata Ꞌuri, “Ngwae faꞋamanata kwa. ꞋUri ma Ꞌoko saea Ꞌani nauꞋa neꞋeriꞋa kwa?” Ma sa Jesus ka fata Ꞌuri fuana, “ꞋAeꞋo talamu neꞋe Ꞌoko saea naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma ana kaidaꞋi kira fanga, sa Jesus ka ngalia afu beret, ma nia ka baꞋatafea God, sui ka ngiia, ma ka kwatea fuana na fafarongo nia ki, ma ka fata Ꞌuri, “Muke ngalia, ma muka Ꞌania, nia naꞋa neꞋe noniku.” ");
INSERT INTO kwf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui nia ka ngalia na titiu ni kwaꞋunga, ma ka baꞋatafea God, sui ka kwatea fuada, ma ka fata Ꞌuri, “Kaumulu taꞋifau, muke kwaꞋufia. ");
INSERT INTO kwf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nia naꞋa neꞋe Ꞌabuku neꞋe God faꞋangasia Ꞌani na fau alangaꞋinga faolu, sulia neꞋe Ꞌabuku ke baꞋa igo fuana ngwae Ꞌoro ki, fasi Ꞌiri God ka rufuanata naꞋa ana taꞋangaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ru mamana nau ku saea fuaumulu, nau kusi kwaꞋufia laꞋu na waen neꞋe leleka ka dao ana faꞋi asoa nau ku kwaꞋufia naꞋa waen faolu faꞋi kaumulu Ꞌi saena na ꞋInotoꞋanga MaꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sui kira ka ngulia faꞋi ngu, ma kira ka leka Ꞌuana faꞋi ua neꞋe kira saea Ꞌani Olif. ");
INSERT INTO kwf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma sa Jesus ka fata Ꞌuri fuada, “Ana faꞋi rodo neꞋe, kaumulu taꞋifau goꞋo muke tafi faꞋasi nau. Sulia na KerekereꞋa Abu ba fata Ꞌuri, ‘God ke saungia ngwae neꞋe nia lia sulia na sipsip ki, ma na sipsip ki taꞋifau kika takalo.’ ");
INSERT INTO kwf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka ꞋunaꞋeri bore ana, Ꞌi buri Ꞌana nau kui tataꞋe laꞋu Ꞌuana mauriꞋa, nau kui etaeta Ꞌi naꞋo aumulu Ꞌuana Ꞌi Galili.” ");
INSERT INTO kwf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma sa Peter ka olisia ka Ꞌuri, “NauꞋa ꞋafitaꞋi nau ku leka faꞋasi Ꞌoe, sui bore Ꞌana ngwae neꞋe ki kira ka leka faꞋasiꞋo!” ");
INSERT INTO kwf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma sa Jesus ka fata Ꞌuri fuana sa Peter, “Nau ku saea fuamu, Ꞌi naꞋona neꞋe karai ke angi Ꞌi saena faꞋi rodo taꞋena, Ꞌoke baꞋa sae uulufau ana neꞋe Ꞌoko kina nau.” ");
INSERT INTO kwf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma sa Peter ka olisia ka Ꞌuri, “Sui bore Ꞌana nau ku mae faꞋi Ꞌoe, nia ꞋafitaꞋi nau ku saea fasi nau ku kinaꞋo!” Ma na fafarongo ki taꞋifau goꞋo, kira ka fata logo ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui sa Jesus ka leka faꞋinia na fafarongo nia ki ana taꞋi kula kira saea Ꞌani Ꞌi Getsemani, ma nia ka fata Ꞌuri fuada, “Kamu ke tua Ꞌaumulu Ꞌi neꞋe ana kaidaꞋi nau ku leka kwau Ꞌi loꞋoko Ꞌiri nai foꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma nia ka talaꞋia sa Peter, ma na ro ngela sa Sebedi ki faꞋinia. Ma nia ka fiꞋi eta Ꞌaena kwaimanatai Ꞌanga doe liu faꞋinia liadilaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma nia ka fata Ꞌuri fuada, “Na liaku nia figwanu ka doe liu, ma nia bolo faꞋinia naꞋa saungilaku. Muke tua Ꞌi neꞋe, kamu ke ada, ma muke lialia faꞋi nau.” ");
INSERT INTO kwf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sui nia ka Ꞌidu tiꞋitiꞋi laꞋu faꞋasi kira, ma ka bobo uruuru leleka na maana darana ka toꞋo naꞋa Ꞌi ano, ma ka foꞋo ka Ꞌuri, “MaꞋasi Ꞌae, diꞋia nia talangwaraꞋu goꞋo Ꞌana, Ꞌoko lafua Ꞌamu na nonifiiꞋanga neꞋe faꞋasi nau. Sui bore Ꞌana, noaꞋa laꞋu na kwaiogaiꞋanga nau, bore ma sulia na kwaiogai Ꞌanga Ꞌoe lala niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui sa Jesus ka oli siana na uulu fafarongo nia ki, ma ka lisia kira maliu naꞋa, ma nia ka fata Ꞌuri fuana sa Peter, “Kwala Peter kwa, faꞋuta neꞋe kamu kasi ada faꞋi nau sulia ta taꞋi kaidaꞋi? ");
INSERT INTO kwf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kamu ke ada, muke lialia Ꞌani foꞋongaꞋa sasi na ilitoꞋonga kata liufi kamu. Sulia kaumulu oga sasilana ru leꞋa ki, bore ma nonimuꞋa nia ngwataꞋutaꞋu liu.” ");
INSERT INTO kwf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa Jesus ka leka laꞋu, ma ka foꞋo ana ruana kaidaꞋi ka Ꞌuri, “MaꞋasi Ꞌae, diꞋia noaꞋa kasi bolo fuana Ꞌoke fonea na nonifiiꞋanga neꞋe faꞋasi nau, leꞋa goꞋo Ꞌana, nau ku roꞋo naꞋa Ꞌaku sulia na kwaiogai Ꞌanga Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma kaidaꞋi nia oli maꞋi siada na fafarongo nia ki, nia ka lisia kira maliu laꞋu, sulia na maada mamaliuꞋa liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma sa Jesus ka leka laꞋu faꞋasida, ma ka foꞋo laꞋu ana uula kaidaꞋi, ka saea logo na alaꞋanga ba kiri. ");
INSERT INTO kwf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui nia ka leka laꞋu siada na uulu fafarongo nia ki, ma ka fata Ꞌuri fuada, “Kaumulu maliu Ꞌua niniꞋa? Ma kamu ka mamalo Ꞌua niniꞋa? Lia basi, kira ke kwate nauꞋa naꞋa, na Ngela Ngwae, saena limana na ngwae taꞋa ki. Na kaidaꞋi baera nia dao naꞋa maꞋi! ");
INSERT INTO kwf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mulu tataꞋe, kulu ka leka naꞋa. Kamu lisia na ngwae ba ke kwate nau fuana na malimae nau ki, nia dao naꞋa maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma ana kaidaꞋi sa Jesus ka alaꞋa Ꞌua, sa Judas, taꞋi ngwae ana akwala ma ro fafarongo ba nia ki, ka dao naꞋa maꞋi. TaꞋi fikuꞋa doe leka maꞋi faꞋinia faꞋasia na fata abu doe ki, ma na faꞋinaꞋonaꞋo ki. Ma kira ka ngalia maꞋi na sele ni ofoꞋa ki, ma na subi ki. ");
INSERT INTO kwf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aia, sa Judas kwatea ka sui naꞋa maꞋetoto fuada ka Ꞌuri, “Na ngwae neꞋe nau ku nonoꞋia, niaꞋa naꞋa neꞋe na ngwae neꞋe kamu oga.” ");
INSERT INTO kwf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma ꞋaliꞋali nia ka leka saga naꞋa siana sa Jesus ma ka fata Ꞌuri, “Ngwae faꞋamanata kwa, aroaroꞋa tua faꞋi Ꞌoe.” Sui nia ka nonoꞋia. ");
INSERT INTO kwf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma sa Jesus ka fata Ꞌuri fuana, “Kwala ngwade, sasia naꞋa ru neꞋe ꞋaliꞋali.” Sui kira ka Ꞌidu karangi maꞋi ana, ma kira ka daua sa Jesus, ma kira ka dau ngasi naꞋa fafia. ");
INSERT INTO kwf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma taꞋi ngwae ana fafarongo sa Jesus ki ka lafua naꞋa nini ni ofoꞋa nia, ma ka kwaiꞋia naꞋa ngwae rao na ꞋingataꞋi fata abu, ma ka kwaꞋi tafia naꞋa na bali alinga ꞋoloꞋolo nia. ");
INSERT INTO kwf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma sa Jesus ka fata Ꞌuri fuana, “ꞋOke alua Ꞌamu na sele ni ofoꞋa Ꞌoe fuila, sulia sa tai faꞋida neꞋe kira fuꞋa Ꞌani sele ni ofoꞋa, kira ke baꞋa mae logo Ꞌani sele ni ofoꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nau ku oga Ꞌoke saiana, diꞋia nau ku gania MaꞋa nau, nia fiꞋi kwatea maꞋi na Ꞌainsel Ꞌoro ki liufia akwala ma ro fuani oro ki! ");
INSERT INTO kwf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma diꞋia nau ku saea na Ꞌainsel ki ka Ꞌafi nau ꞋunaꞋeri, noaꞋa naisi faꞋamamana na ru neꞋe na KerekereꞋa Abu saea sulia na Christ ka nonifii Ꞌani ki.” ");
INSERT INTO kwf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sui sa Jesus ka fata Ꞌuri fuana ngwae ki, “ꞋUri ma, kaumulu fia nauꞋa ta ngwae bili niniꞋa? Nia nini muka dao naꞋa maꞋi faꞋinia na sele ki, ma na subi ki fuana daulaku? Tau naꞋa maꞋi, nau ku faꞋamanata kamu Ꞌi saena na Luma Abu God, bore ma kamu kasi dau nau goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na ru neꞋe ki taꞋifau ka fuli ꞋunaꞋeri fasi Ꞌiri ka faꞋamamana na kerekereꞋa na profet ki ana KerekereꞋa Abu.” Sui na fafarongo nia ki taꞋifau goꞋo kira ka danga faꞋiburi naꞋa Ꞌani, ma kira ka tafi naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma na ngwae neꞋe kira daua sa Jesus ki, kira ka talaꞋi nia Ꞌuana saena luma sa Kaeafas, na ꞋingataꞋi fata abu. Ma na ngwae faꞋamanata ana taki ki, faꞋinia na ngwae faꞋinaꞋonaꞋo ki logo, kira fiku Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma sa Peter nia Ꞌisi buri tau naꞋa kwau, ma ka dao logo Ꞌi saena na labata ana na luma ꞋingataꞋi fata abu, ma ka ruꞋu kwau saena labata, ma ka tua siana ngwae folo ki, fasi Ꞌiri nia ka lisia tae neꞋe kira ke sasia ana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma na fata abu doe ki, faꞋinia na fikutaꞋi ngwae lokoꞋi ru taꞋifau, kira sasi Ꞌuana dao toꞋona ti alaꞋanga ꞋosoꞋoso sulia sa Jesus, neꞋe bolo faꞋinia kika saungia duꞋungana. ");
INSERT INTO kwf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sui bore Ꞌana ngwae Ꞌoro fata ꞋosoꞋoso ki kira leka logo maꞋi, noaꞋa kira kasi dao goꞋo toꞋona ta ru. Sui Ꞌi buri, ta ro ngwae ꞋosoꞋoso kera taꞋe maꞋi, kera ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Na ngwae neꞋe nia fata Ꞌuri, ‘Nau ku saiana nai osia na Luma Abu God, ma nau ku saungaꞋi faolu logo Ꞌaku ana saena uulu faꞋi asoa ki.’” ");
INSERT INTO kwf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sui na ꞋingataꞋi fata abu ka tataꞋe, ka fata Ꞌuri fuana sa Jesus, “ꞋUri ma, noaꞋa Ꞌoe kosi olisia goꞋo ta ru, ana ru taꞋa neꞋe kera saea amu ki?” ");
INSERT INTO kwf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bore ma, sa Jesus ka noto goꞋo Ꞌana. Ma na ꞋingataꞋi fata abu ka fata laꞋu Ꞌuri, “Nau ku saefilo Ꞌoe Ꞌiri Ꞌoke talitali Ꞌani satana God neꞋe mauri, ma Ꞌoko saea fuamiꞋa fasi ꞋaeꞋo neꞋe na Christ, na Ngela God, nama noaꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sa Jesus ka fata Ꞌuri fuana, “Nia neꞋana Ꞌoko saea naꞋa. Ru mamana nau ku saea fuamuꞋa, Ꞌita ana kaidaꞋi neꞋe ka oli ꞋalaꞋa, muke lisi nau, na Ngela Ngwae, nau ku tua Ꞌi bali ꞋoloꞋolo ana God neꞋe ngasingasiꞋa ka tasa, ma nau ku leka maꞋi Ꞌi fafona gwaꞋi salo ki Ꞌi langi.” ");
INSERT INTO kwf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","GoꞋo na ꞋingataꞋi fata abu neꞋeri, nia ka gasia na toro keta nia talana ka faꞋataꞋinia na saetaꞋanga nia, ma ka fata Ꞌuri, “Kulu kasi oga laꞋu ta ngwae ni fata faꞋamamana! Kulu rongoa taꞋifau naꞋa nia faꞋabolotaꞋinia naꞋa faꞋinia God. ");
INSERT INTO kwf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kamu manata faꞋuta?” Ma kira olisia kika Ꞌuri, “Nia totolia nia ke mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sui kira ka ngisulia maana, ma kira ka kwaiꞋia. Ma ti ngwae kika fidalia, kira ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Christ Ꞌae, diꞋia ꞋaeꞋo naꞋa ta profet, Ꞌoko saea maꞋi, sa tai neꞋe fidali Ꞌoe Ꞌuri?” ");
INSERT INTO kwf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma sa Peter ka tua saena labata, ma taꞋi kini sariꞋi rao ka leka maꞋi siana ka fata Ꞌuri, “ꞋOko tua logo faꞋinia sa Jesus, na ngwae niniꞋa faꞋasia Ꞌi Galili.” ");
INSERT INTO kwf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sui sa Peter ka tofe Ꞌi naꞋoda ka Ꞌuri, “Nau ku Ꞌiri saiana ru neꞋe Ꞌoko saea.” ");
INSERT INTO kwf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui, sa Peter leka ka tua karangia ana maꞋe tafaa, ma taꞋi kini sariꞋi rao laꞋu ka lisia, ma ka fata Ꞌuri fuana ngwae neꞋe kira tua neꞋeri ki, “Na ngwae neꞋe tuatua logo faꞋinia sa Jesus, na ngwae neꞋe faꞋasia Ꞌi Nasaret.” ");
INSERT INTO kwf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma sa Peter ka tofe laꞋu, ma nia talitali ka Ꞌuri, “Nau ku Ꞌiri saiana na ngwae neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma noaꞋa kasi tau goꞋo Ꞌi buri Ꞌana, na ngwae neꞋe kira uu Ꞌi neꞋeri ki, kira leka siana sa Peter, ma kira ka fata Ꞌuri fuana, “ꞋAeꞋo logo ta ngwae ada mamana naꞋa, sulia na lingana fatalamu neꞋe faꞋataꞋi Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","KaidaꞋi neꞋeri nia ka talitali laꞋu ka Ꞌuri, “DiꞋia nau ku soke, God ke baꞋa kwaꞋi nau. NoaꞋa nau ku Ꞌiri saiana na ngwae neꞋana.” Ma ꞋunaꞋeri goꞋo, karai ka angi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma sa Peter nia manata toꞋona alaꞋanga ba sa Jesus saea, “ꞋI naꞋo ana na karai ka angi saena faꞋi rodo neꞋe taꞋena, Ꞌoko saea uulufau ana neꞋe Ꞌoko kina nau.” KaidaꞋi sa Peter ka manata toꞋona ru neꞋeri, nia ka ruꞋu kwau Ꞌi maa, ma ka angi ikaika naꞋa Ꞌania liadilaꞋanga doe liu. ");
INSERT INTO kwf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana Ꞌofodangi laꞋa bilabila, na fata abu doe ki taꞋifau faꞋinia na ngwae faꞋinaꞋonaꞋo ki, kira ka lokoꞋi ru naꞋa fuana saungilana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sui kika firiꞋia, ma kira ka talaꞋia naꞋa siana sa Paelat, na ngwae gwaungaꞋi faꞋasia Ꞌi Rom. ");
INSERT INTO kwf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma sa Judas, na ngwae ba kwatea sa Jesus fuana malimae nia ki, ana kaidaꞋi nia saiana kira matalangani naꞋa sa Jesus fuana na maelana, nia ka manata oli, ma ka oli faꞋinia na uulu akwala selene baera ki fuada na fata abu doe ki ma na ngwae faꞋinaꞋonaꞋo ki, ma ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nau ku abula taꞋa naꞋa, sulia nau ku kwatea naꞋa ngwae saga fuana saungilana.” Sui kira olisia kika Ꞌuri, “Ma noaꞋa laꞋu ꞋaberaꞋanga kaimili neꞋana. Sulia bali neꞋeri na bali Ꞌoe lala Ꞌamu neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma sa Judas ka Ꞌui Ꞌania na selene neꞋeri ki Ꞌi saena na Luma Abu God, ma ka leka naꞋa Ꞌana. Nia ka leka kwau Ꞌi maa, ma ka liꞋo naꞋa Ꞌana talana. ");
INSERT INTO kwf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma na fata abu doe ki, kira ka ngalia na selene neꞋeri ki, ma kira ka fata Ꞌuri, “NoaꞋa kasi bolo ana taki kulu fuana kulu ka alua naꞋa selene neꞋe ki faꞋinia na mani ana na Luma Abu God, osiꞋana selene neꞋe na mani ana sau ngwaeꞋa naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma kira ka alaꞋa ka sui naꞋa, kira ka alafafia ma kika folia Ꞌani taꞋi afu ano, na ano taꞋi ngwae neꞋe saungaꞋi titiu. Ma kira ka rokisia ano neꞋe Ꞌani kula fuana alulana ngwae mae ki ana, na ngwae neꞋe noaꞋa laꞋu Jiu ki saena. ");
INSERT INTO kwf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","DuꞋungana neꞋe nia folia na ano neꞋeri Ꞌani na mani neꞋe nia ngalia fuana saungilana na ngwae, kira ka saea ano neꞋe Ꞌani, “Ano ana ꞋAbu” leleka ka dao Ꞌi taꞋena. ");
INSERT INTO kwf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ꞋUnaꞋeri, kira ka faꞋamamana alaꞋanga na profet Jeremaea ba fata Ꞌuri, “Kira ngalia naꞋa uulu akwala selene baera ki, na mani ba na ngwae Ꞌi Israel ki kira folia Ꞌani na ngwae, ");
INSERT INTO kwf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma kira ka kwatea Ꞌuana folilana na ano na ngwae neꞋe saungaꞋinia titiu ki, diꞋia ba God nia saea fuaku.” ");
INSERT INTO kwf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma sa Jesus ka uu Ꞌi naꞋona sa Paelat, na ngwae gwaungaꞋi faꞋasia Ꞌi Rom. Ma sa Paelat ka saefiloa ka Ꞌuri, “ꞋOe na ngwae tatalafaꞋa Jiu ki niniꞋa?” Sa Jesus ka olisia ka Ꞌuri, “Nia neꞋana Ꞌoko saea naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","KaidaꞋi neꞋe fata abu doe ki, ma na faꞋinaꞋonaꞋo ki, kira fai fafia sa Jesus, noaꞋa nia kasi olisida Ꞌani ta alaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sui sa Paelat ka fata Ꞌuri fuana, “ꞋOe kosi rongo goꞋo na ru taꞋa Ꞌoro niniꞋa kira fai fafiꞋo Ꞌani ki?” ");
INSERT INTO kwf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma sa Jesus noaꞋa kasi olisida goꞋo Ꞌani ta alaꞋanga. Nia neꞋe sa Paelat ka Ꞌarefo liu ana. ");
INSERT INTO kwf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ꞋIu, ana na FangaꞋa ana DaofaꞋi LiuꞋa, ngwae gwaungaꞋi faꞋasia Ꞌi Rom, nia ꞋidufaꞋi logea taꞋi ngwae neꞋe Jiu ki kira oga faꞋasia na lokafo. ");
INSERT INTO kwf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ana kaidaꞋi neꞋeri, taꞋi ngwae ka tua logo saena luma ni lokafo neꞋe satana sa Barabas, na ngwae ki taꞋifau kira saiana. ");
INSERT INTO kwf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nia neꞋe, kaidaꞋi neꞋe ngwae ki kira fiku maꞋi, sa Paelat ka saefiloda ka Ꞌuri, “Sa tai neꞋe kaumulu oga nai logea fuamuꞋa, sa Barabas, nama sa Jesus neꞋe kira saea Ꞌani na Christ?” ");
INSERT INTO kwf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nia ka fata ꞋunaꞋeri, sulia nia saiana neꞋe ngwae faꞋinaꞋonaꞋo ana Jiu ki, kira kwatea sa Jesus fuana sulia kira ogalaꞋa goꞋo niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma kaidaꞋi sa Paelat nia tua ana kula ni matalangaꞋinga, na Ꞌafe nia ka kwatea ta alaꞋanga fuana ka Ꞌuri, “NoaꞋa Ꞌoe kosi sasi ta ru ana na ngwae ꞋoloꞋolo neꞋana. Sulia nau ku maliu bole, ma ku figwanu liu sulia niaꞋa saena faꞋi rodo ba sui.” ");
INSERT INTO kwf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma na fata abu doe ki, ma na ngwae faꞋinaꞋonaꞋo ki, kira fata liana na ngwae ki, fasi Ꞌiri kira ka gania sa Paelat fuana logelana sa Barabas, ma ka alua sa Jesus fuana maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma sa Paelat ka saefiloda na fikuꞋa neꞋeri laꞋu ka Ꞌuri, “Sa tai ana keroꞋa neꞋe kamu oga Ꞌiri nai logea?” Ma kira olisia kira ka Ꞌuri, “Sa Barabas.” ");
INSERT INTO kwf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sa Paelat ka fata Ꞌuri, “Ma tae neꞋe nai baꞋa sasia ana sa Jesus, neꞋe kira saea Ꞌani na Christ?” Kira taꞋifau kira ka fata Ꞌuri, “ꞋOke foto fafia ana Ꞌai rara folo.” ");
INSERT INTO kwf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma sa Paelat ka fata Ꞌuri laꞋu, “OsiꞋana ta tae taꞋa neꞋe nia sasia?” Sui kira ka ako doe kika Ꞌuri, “FotoꞋia ana Ꞌai rara folo.” ");
INSERT INTO kwf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma kaidaꞋi sa Paelat lisia nia ꞋafitaꞋi ka sasia naꞋa ta ru, ma na fuꞋanga ka karangi talaꞋae, nia ka ngalia kafo, ma ka taufia naꞋa limana Ꞌi naꞋo Ꞌada taꞋifau, ka fata Ꞌuri, “NoaꞋa nau kusi oga na maelana na ngwae neꞋe. Bali kaumulu naꞋa neꞋeriꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na fikuꞋa taꞋifau kira olisia, kika Ꞌuri, “Na maelana ke teo fafi kaimili, ma fafia na ngela kami ki.” ");
INSERT INTO kwf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aia, sa Paelat ka logea kwau sa Barabas fuada, ma ka kwatea na ngwae fuani oro nia ki kira ka ulasia sa Jesus. Sui nia ka kwatea fuada Ꞌiri kika fotoꞋia ana na Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma na ngwae fuani oro sa Paelat ki, kira talaꞋia sa Jesus saena na luma sa Paelat, ma na fuani oro neꞋeri ki taꞋifau, kira ka fiku maꞋi kalia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma kira ka kanusua naꞋa ifi nia, ma kira ka faꞋaruꞋufia Ꞌani ifi meo boraboraꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui kira ka ngalia na Ꞌeregwau ana kwalo ngarangaraꞋa, ma kira ka alua fafona gwauna, ma kira ka kwatea taꞋi rara Ꞌai fasi Ꞌiri ka dau ana Ꞌani bali lima ꞋoloꞋolo nia, diꞋia niaꞋa ta ngwae tatalafaꞋa. Ma kira ka bobo uruuru fuana, ma kira ka Ꞌoidorole Ꞌani, kira ka Ꞌuri, “ꞋOke mauri tau Ꞌamu, na ngwae tatalafaꞋa Jiu ki.” ");
INSERT INTO kwf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma kira ka ngisulia, ma kira ka ngalia na rara Ꞌai baera, ma kira ka kwaiꞋia na gwauna. ");
INSERT INTO kwf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","KaidaꞋi kira Ꞌoidorole ana ka sui, kira ka kanusua laꞋu na ifi baera, ma kira ka faꞋaruꞋufia laꞋu Ꞌani ifi nia ki, sui kira ka talaꞋia kwau fuana na fotoꞋilana ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma kaidaꞋi kira leka naꞋa kwau, kira ka lisia taꞋi ngwae faꞋasia Ꞌi Saeren, neꞋe satana sa Simon. Ma na ngwae fuani oro ki, kira ka kwatea fasi Ꞌiri nia ngalia na Ꞌai rara folo sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sui kira dao ana kula kira saea Ꞌani Ꞌi Golgota. (Na fadalana alaꞋanga Golgota, “Na kula ana lasi ngwae”.) ");
INSERT INTO kwf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ꞋI neꞋeri, kira kwatea na waen neꞋe kira dola Ꞌani Ꞌai Ꞌafae fuana sa Jesus. Ma sa Jesus ka kwaꞋu toꞋona, ma noaꞋa nia kasi kwaꞋufia goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sui kira ka foto fafia ana na Ꞌai rara folo, ma kira ka masa Ꞌani na ru diꞋia daisi fuana kika daroꞋia na ifi nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sui kira ka tua Ꞌi ano, ma kika lialia Ꞌafia goꞋo Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma Ꞌi gwauna na Ꞌai rara folo kira alua na kerekereꞋa Ꞌuri, “Na ngwae neꞋe sa Jesus, na Ngwae TatalafaꞋa na Jiu ki.” ");
INSERT INTO kwf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sui, kira ka fotoꞋia logo ro ngwae bili ki ana na Ꞌai rara folo ki faꞋinia, ta ngwae bali ꞋoloꞋolo ana, ma ta ngwae ana bali mauli. ");
INSERT INTO kwf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma na ngwae neꞋe kira liu ki, kira ka nanga nangataꞋinia gwauda, ma kira ka fata buri tolingaꞋi kwau fuana sa Jesus, ma kira ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ꞋOko saea Ꞌoko osia naꞋa Luma Abu God, ma Ꞌoko saungaꞋi faolu laꞋu ana sulia uulu faꞋi asoa ki goꞋo. Aia, diꞋia ꞋaeꞋo na Ngela God, Ꞌoko faꞋamauri Ꞌoe basi talamu, ma Ꞌoko koso maꞋi faꞋasia na Ꞌai rara folo neꞋana.” ");
INSERT INTO kwf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma na fata abu doe ki kira ka Ꞌoidorole logo Ꞌani ꞋunaꞋeri, faꞋinia na ngwae faꞋamanata ana taki ki, ma na ngwae faꞋinaꞋonaꞋo ki, kira ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nia ba faꞋamauria na ngwae matamata ki, ma noaꞋa nia kasi faꞋamauria goꞋo niaꞋa talana. DiꞋia nia na ngwae tatalafaꞋa kia ngwae Jiu ki, nia ka koso maꞋi faꞋasia na Ꞌai rara folo, fasi Ꞌiri kulu ka faꞋamamana ana niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nia fitoꞋo ana God, ma ka fata Ꞌuri, ‘NauꞋa neꞋe na Ngela God.’ Kulu lialia basi Ꞌiri kuke lisia neꞋe God ke baꞋa faꞋamauria nama noaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma na ro ngwae taꞋa neꞋe kira fotoꞋida faꞋinia ki, kera fata buri tolingaꞋi logo ꞋunaꞋeri ana niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ka Ꞌita ana tofongana asoa, leleka ka dao ana uula kadi sina, na maꞋe rodo ka buta fafia na fanoa ki taꞋifau Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma saꞋulafi, sa Jesus ka ako doe ka Ꞌuri, “ꞋIlae, ꞋIlae, lema sabaktani.” Na fadalana neꞋe Ꞌuri, “God nau Ꞌae, God nau Ꞌae, faꞋuta neꞋe Ꞌoko danga faꞋi buri Ꞌani nau?” ");
INSERT INTO kwf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma ti ngwae neꞋe tua karangi ana, kira rongoa, ma kira ka fata Ꞌuri, “Nia ri Ꞌuana sa Elaeja.” ");
INSERT INTO kwf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma taꞋi ngwae ada ka lalili ka ngalia maꞋi taꞋi lumulumu asi, ma ka faꞋafungua Ꞌani na waen Ꞌafae, ma ka usuiꞋa ana maꞋe Ꞌai, ma ka kwatea fuana fasi Ꞌiri nia ka kwaꞋufia. ");
INSERT INTO kwf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma ti ngwae laꞋu kira ka Ꞌuri, “Mango basi, kulu ka lisia diꞋia sa Elaeja nia dao maꞋi fuana faꞋamaurilana nama noaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sui, sa Jesus ka ako doe laꞋu, ma ka mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma ifi doe neꞋe bokota naꞋa kula abu saena Luma Abu God ka gaa Ꞌania ro baliꞋi ru, ka Ꞌita maꞋi Ꞌi gwauna leleka ka dao Ꞌi ano. Ma na tikitiki ka liu, ma na fau ki ka foga, ");
INSERT INTO kwf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma ti faoda gwaꞋu kira ka Ꞌifi, ma na ngwae Ꞌoro ana ngwae God ki neꞋe kira mae naꞋa, kira ka mauri laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma kira ka ruꞋu faꞋasia faoda kira ki. Ma buri Ꞌana sa Jesus ka tataꞋe oli logo, kira ka ruꞋu saena fanoa abu Ꞌi Jerusalem. Ma na ngwae Ꞌoro ki kira ka lisida. ");
INSERT INTO kwf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma na ngwae faꞋinaꞋonaꞋo ana fuani oro neꞋe kira saungia sa Jesus, faꞋinia na fuani oro nia ki, ana kaidaꞋi kira lisia na tikitiki, ma na ru matamata ki taꞋifau logo neꞋe fuli, kira ka maꞋu liu ma kira ka fata Ꞌuri, “Nia mamana liu naꞋa, niaꞋa na Ngela God.” ");
INSERT INTO kwf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma ti kini Ꞌoro logo neꞋe kira leka Ꞌi buri Ꞌana sa Jesus Ꞌita maꞋi Ꞌi Galili ma kira Ꞌafia, kira tua logo Ꞌi neꞋeri, ma kira ka lialia tau logo maꞋi Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta ai ada neꞋe Ꞌi Mary faꞋasia Ꞌi Magdala, ma Ꞌi Mary na teꞋa sa James ma sa Josef, ma Ꞌafe sa Sebedi, ma ti kini laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ana kaidaꞋi nia saꞋulafi naꞋa ma ka karangia rodo, taꞋi ngwae toꞋoru nia leka maꞋi. NiaꞋa taꞋi ngwae faꞋasia fanoa Ꞌi Arimetea, ma na satana sa Josef. Ma nia taꞋi ngwae fafarongo sa Jesus logo. ");
INSERT INTO kwf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma nia ka leka siana sa Paelat, ma ka gania na nonina sa Jesus. Ma sa Paelat ka saea kira ka kwatea fuana. ");
INSERT INTO kwf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma sa Josef ka ngalia naꞋa nonina sa Jesus, ma ka buta Ꞌani Ꞌaba ifi kwao faolu. ");
INSERT INTO kwf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sui nia ka alua saena na faoda gwaꞋu faolu nia, neꞋe kira saruꞋia Ꞌi saena na fau doe. Sui nia ka bokota naꞋa maana na faoda neꞋeri Ꞌani na babaꞋi fau doe, sui ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ꞋI Mary faꞋasia Magdala, ma ta Mary laꞋu, kera tua tua Ꞌi maa ana na faoda neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma ana faꞋi asoa Ꞌi buri Ꞌana, na Sabat asoa ana mamaloꞋanga, na fata abu doe ki, ma na Farasi ki, kira fiku fuana lokoꞋi ru Ꞌanga faꞋinia sa Paelat. ");
INSERT INTO kwf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma kira ka fata Ꞌuri fuana, “Ngwae ꞋaꞋana Ꞌae, kaimili manata toꞋona kaidaꞋi ngwae ꞋosoꞋoso neꞋe nia mauri Ꞌua, nia fata Ꞌuri, ‘Nai baꞋa mauri laꞋu ana uula asoa!’ ");
INSERT INTO kwf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ma Ꞌoko faꞋarongoa ngwae Ꞌoe ki kika leka, ma kika folo Ꞌafia na faodaꞋi ngwae mae leleka ka dao ana uula asoa. NoaꞋa kasi leꞋa neꞋe na fafarongo nia ki kira ka ngalia Ꞌada na nonina, ma kira ka sofongaꞋinia, ma kira ka sokea ngwae ki, kira ka saea fasi sa Jesus nia mauri laꞋu. Ma Ꞌoko saiana fasi diꞋia kira soke ꞋunaꞋeri, nia ke baꞋa taꞋa ka liufia naꞋa sokeꞋa ba nia eta sokea maꞋi Ꞌani ngwae ki.” ");
INSERT INTO kwf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma sa Paelat ka Ꞌuri fuada, “Aia, diꞋia ꞋunaꞋeri, kaumulu neꞋe kamu ka filia ti ngwae ana fuani oro nau ki, fasi Ꞌiri kira ka leka folo, ma kira ka folo leꞋa Ꞌafia na faoda neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma ana kaidaꞋi fata abu doe ki, ma na Farasi ki kira rongoa ru neꞋeri, kira ka sasi akaꞋu naꞋa, ma kira ka leka naꞋa Ꞌuana na faoda neꞋeri. Ma kaidaꞋi kira dao ana faoda neꞋeri, kira ka alua naꞋa maꞋetoto ana faoda neꞋeri, Ꞌiri diꞋia ta ngwae ka Ꞌidua bore na sinamaa ana faoda, kira ka saiana. Ana kaidaꞋi neꞋeri logo, kira ka alua naꞋa ngwae folo ki. ");
INSERT INTO kwf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ꞋI buri Ꞌana na Sabat, faꞋi asoa ana mamaloꞋanga, kaidaꞋi nia laꞋa bilabila Ꞌua ana na Sande Ꞌi Ꞌofodangi, Ꞌi Mary faꞋasia Ꞌi Magdala, ma ta Mary laꞋu, kera ka leka Ꞌuana na faoda baera Ꞌiri kera ka lisia. ");
INSERT INTO kwf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma ngwano ma na tikitiki doe nia Ꞌiginia, ma taꞋi Ꞌainsel God ka koso maꞋi faꞋasia Ꞌi langi, ma ka gilosia naꞋa babaꞋi fau baera faꞋasia maana na faoda, ma ka tua Ꞌi fafona. ");
INSERT INTO kwf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na lisilana diꞋia naꞋa meamea ma na ifi nia ki ka kwao liu. ");
INSERT INTO kwf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma ana kaidaꞋi neꞋe ngwae folo ki kira lisia, kira ka maꞋu liu, ma kira ka Ꞌasida, ma kira ka lebelebe, ma kika diꞋia naꞋa Ꞌada na ngwae mae ki. ");
INSERT INTO kwf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma na Ꞌainsel neꞋeri ka fata Ꞌuri fuadaroꞋo, “NoaꞋa moro kasi maꞋu. Nau ku saiana koroꞋo lulu Ꞌuana sa Jesus ba kira saungia ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","NoaꞋa nia kasi tua naꞋa Ꞌi neꞋe. Nia mauri naꞋa diꞋia ba nia saea fuamuꞋa. Moro leka maꞋi Ꞌi neꞋe, ma moro ka lisia amuroꞋo kula ba nia teo teo ana. ");
INSERT INTO kwf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aia, moro ka leka ꞋaliꞋali naꞋa, ma moro ka faꞋarongo Ꞌuri ana fafarongo nia ki, ‘Sa Jesus nia mauri naꞋa, ma nia ka leka Ꞌi naꞋo mulu Ꞌuana Ꞌi Galili, ma kamu ke baꞋa lisia naꞋa Ꞌi neꞋeri.’ Ma moro ka manata toꞋona ru neꞋeri nau ku saea fuamuroꞋo ki.” ");
INSERT INTO kwf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ꞋUnaꞋeri goꞋo, kera ka leka ꞋaliꞋali naꞋa faꞋasia faoda Ꞌani maꞋungaꞋa. Ma sui bore Ꞌana, kera ka saeleꞋa liu. Ma kera ka lalili Ꞌiri kike faꞋarongoa na fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ana kaidaꞋi neꞋeri, sa Jesus ka saka fuadaroꞋo, ka fata Ꞌuri, “Na aroaroꞋa ka tua faꞋi koroꞋo.” Ma kera ka leka maꞋi siana, ma kera ka bobo uruuru fuana, ma kera ka dau kwau Ꞌi Ꞌaena, ma kera ka faꞋa aofia. ");
INSERT INTO kwf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “NoaꞋa moro kasi maꞋu. Moro leka, ma moro ka faꞋarongoa na ngwaefuta nau ki, fasi Ꞌiri kike leka Ꞌuana Ꞌi Galili. Ma kike baꞋa lisi nau naꞋa Ꞌi neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ana kaidaꞋi ro kini neꞋe ki kira oli kwau sulia na tala, ti ngwae ana ngwae folo neꞋeri ki, kira leka naꞋa faꞋasia faoda gwaꞋu sa Jesus, ma kira ka oli naꞋa Ꞌuana Ꞌi Jerusalem. KaidaꞋi kira dao ana maꞋe fanoa doe neꞋeri, kira ka alaꞋa naꞋa sulia ru ki taꞋifau neꞋe kira lisia siana fata abu doe ki. ");
INSERT INTO kwf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma kaidaꞋi neꞋe fata abu doe ki, ma ti ngwae faꞋinaꞋonaꞋo laꞋu ana Jiu ki, kira ka alaꞋa fiku ka sui naꞋa, kira ka kwatea mani doe fuana ngwae ni folo ki. ");
INSERT INTO kwf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","KaidaꞋi kira kwatea mani neꞋe fuada ngwae folo ki, kira ka fata Ꞌuri, “Kamu ke soke Ꞌuri fuana ngwae ki taꞋifau, ‘KaidaꞋi kami maliu saena rodo, na fafarongo sa Jesus ki kira leka maꞋi, ma kira ka bilia na nonina.’” ");
INSERT INTO kwf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma na ngwae faꞋinaꞋonaꞋo neꞋe ki, kira fata logo Ꞌuri, “DiꞋia sa Paelat nia rongoa na ru neꞋe, noaꞋa kamu kasi manata Ꞌabera laꞋu, sulia kaimili neꞋe kami ke baꞋa faꞋasaga fuana, Ꞌiri noaꞋa nia kasi saetaꞋa fuaumulu.” ");
INSERT INTO kwf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma kaidaꞋi ngwae folo neꞋe ki kira ngalia mani neꞋeri ka sui naꞋa, kira ka leka, ma kira ka sasi naꞋa Ꞌada ru neꞋe fata abu doe ki ma na ngwae faꞋinaꞋonaꞋo Jiu ki, kira saea fuada. Ma na alaꞋanga neꞋeri ana sokeꞋa ka talofia taꞋifau naꞋa Jiu ki, leleka dao Ꞌi taꞋena. ");
INSERT INTO kwf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na akwala ma taꞋi ngwae fafarongo nia ki kira leka naꞋa Ꞌuana Ꞌi Galili, Ꞌuana taꞋi faꞋi ua neꞋe sa Jesus saea fuada fasi Ꞌiri kira ka leka Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma kaidaꞋi kira lisia naꞋa sa Jesus, kira ka faꞋa aofia, ꞋunaꞋeri bore Ꞌana ti ngwae ada kira ka manata ruarua Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma sa Jesus ka dao maꞋi siada, ka fata Ꞌuri, “God nia kwate dangalu naꞋa ana ngasingasi Ꞌanga ki taꞋifau Ꞌi langi ma saena magalia fuaku. ");
INSERT INTO kwf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nia neꞋe, kamu ke leka, ma kamu ke faꞋamanata na ngwae ki taꞋifau ana fanoa ki taꞋifau, Ꞌiri kira na ngwae fafarongo nau ki logo. Ma kamu ke siuabuda Ꞌani satana na MaꞋa, ma na Ngela, ma na AnoꞋi ru Abu. ");
INSERT INTO kwf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma kamu ke faꞋamanatada fasi Ꞌiri kira ka roꞋosulia na ru ki taꞋifau neꞋe nau ku faꞋamanata kamu naꞋa Ꞌani. Ma nai tua faꞋi kamu leleka ka dao ana na suilana na magalia.” ");
INSERT INTO kwf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na etangilana maꞋi na FaꞋarongoꞋa LeꞋa neꞋe sulia sa Jesus Christ na Ngela God neꞋe Ꞌuri: ");
INSERT INTO kwf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nia talaꞋae diꞋia maꞋi sa Aesea na profet ba nia keresia ru neꞋe God nia saea fuana na Christ neꞋe Ꞌuri, “Nai baꞋa kwatea kwau na ngwae ni ngali alaꞋanga nau Ꞌi naꞋomu, fasi Ꞌiri nia ke sasi akaꞋu ana ngwae ki fuamu. ");
INSERT INTO kwf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","TaꞋi ngwae nia ri fuana ngwae ki saena na abaꞋi kula kwasi. Ma nia ka Ꞌuri, ‘Na Aofia nia ke dao maꞋi! Kamu ke faꞋasaga na tala fuana!’” ");
INSERT INTO kwf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","ꞋUnaꞋeri sa John nia ka dao naꞋa maꞋi saena abaꞋi kula kwasi neꞋe noaꞋa kasi bolo faꞋinia ta ngwae ka tua ana. Nia ruꞋufia na ifi Ꞌania ifuna kamel, ma nia ka nikia na foꞋosae nia ana na ꞋuꞋuila buluka. Ma nia ka Ꞌania na siko ki ma na ngingidua kwasi. Ma nia siuabua ngwae ki, ma ka alaꞋa fuana ngwae ki, ka fata Ꞌuri, “Muke kakari alifaꞋi faꞋasia taꞋangaꞋa kamu ki, ma muke siuabu Ꞌiri God ke rufuanata ana taꞋangaꞋa kamu ki.” Ma na ngwae Ꞌoro ki faꞋasia na abaꞋi kula Ꞌi Judea, ma na fanoa Ꞌi Jerusalem, kira ka leka maꞋi fuana rongolana na fatalana sa John. Kira ka fulangaꞋinia taꞋangaꞋa kira ki, ma nia ka siuabuda saena kafo Ꞌi Jodan. ");
INSERT INTO kwf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma sa John ka fata Ꞌuri fuana ngwae ki, “TaꞋi ngwae ke baꞋa leka maꞋi Ꞌi buriku, nia talingaꞋi ka liufi nau, ma nau kusi bolo faꞋinia neꞋe nai orooro, ma ku logea na taꞋe butu nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma nau ku siufi kamu goꞋo Ꞌaku Ꞌani kafo, bore ma nia neꞋe ke baꞋa siuabu kamu Ꞌani na AnoꞋi ru Abu.” ");
INSERT INTO kwf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","NoaꞋa nia kasi tau goꞋo Ꞌi buri Ꞌana ru neꞋeri ki, sa Jesus ka dao naꞋa maꞋi faꞋasia na fanoa Ꞌi Nasaret saena na abaꞋi kula Ꞌi Galili. Nia ka dao naꞋa maꞋi siana sa John Ꞌiri ke siuabu. Ma sa John ka ngalia ka lolomani nia saena na kafo Ꞌi Jodan. ");
INSERT INTO kwf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma kaidaꞋi sa Jesus nia tataꞋe maꞋi faꞋasia saena kafo, nia ka lisia na lofana salo nia Ꞌifi, ma na AnoꞋi ru Abu ka koso maꞋi fafia diꞋia ta bola. ");
INSERT INTO kwf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma taꞋi lingalingaꞋi ru nia talo maꞋi faꞋasia Ꞌi langi ma ka Ꞌuri, “ꞋAeꞋo naꞋa neꞋe ngela mutaꞋi nau neꞋe nau ku alafe liu amu, ma nau ku saeleꞋa liu faꞋiniꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma ana kaidaꞋi neꞋeri goꞋo, na AnoꞋi ru Abu ka talaꞋia sa Jesus Ꞌuana saena abaꞋi kula kwasi. ");
INSERT INTO kwf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma nia ka tua Ꞌi neꞋeri sulia fai akwala asoa ki, ma sa Saetan ka ilitoꞋona. Na ru ꞋaeꞋaela kwasi ki, kira tua logo Ꞌi neꞋeri, bore ma na Ꞌainsel ki kira ka leka maꞋi, ma kika kwaiꞋafi ana. ");
INSERT INTO kwf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ꞋI buri Ꞌana neꞋe kira alua naꞋa sa John saena na lokafo, sa Jesus ka leka Ꞌi Galili ma ka faꞋarongo Ꞌani na FaꞋarongoꞋa LeꞋa neꞋe leka maꞋi faꞋasia God. ");
INSERT INTO kwf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nia ka fata Ꞌuri, “KaidaꞋi nia karangi naꞋa maꞋi fuana neꞋe God ke ꞋinotoꞋa fafia na ngwae nia ki. Muke kakari alifaꞋi faꞋasia na taꞋangaꞋa kamu ki, ma muke faꞋamamana na FaꞋarongoꞋa LeꞋa neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma ana kaidaꞋi sa Jesus nia leka sulia na Ꞌosi Ꞌi Galili, nia ka lisia sa Simon faꞋinia ngwaefuta nia sa Andrew. KeroꞋa ro ngwae dee ki. KeroꞋa dee adaroꞋo ana furai kera saena na Ꞌosi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “Moro leka maꞋi faꞋinau, koroꞋo ro ngwae dee iꞋa ki, bore ma nai baꞋa faꞋamanata koroꞋo Ꞌani ngali ngwaeꞋa maꞋi fuaku.” ");
INSERT INTO kwf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma kaidaꞋi neꞋeri nama goꞋo, kera ka faꞋasia naꞋa na furai keroꞋa ki, ma kera ka leka naꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma sa Jesus ka leka tiꞋitiꞋi laꞋu kwau, nia ka lisia sa James faꞋinia sa John, na ro ngela sa Sebedi ki. Kera tua adaroꞋo Ꞌi saena na gwaꞋi baru, ma kera ke subungia furai keroꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma kaidaꞋi sa Jesus nia lisidaroꞋo goꞋo, nia ka sae keroꞋa naꞋa, ma kera ka faꞋasia naꞋa maꞋa kera sa Sebedi Ꞌi saena na gwaꞋi baru faꞋinia na ngwae ni rao ki, ma kera ka leka naꞋa faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa Jesus faꞋinia fafarongo nia ki, kira dao ana fanoa Ꞌi Kapaneam. Ma ana na Sabat, asoa ana mamaloꞋanga, sa Jesus ka ruꞋu Ꞌi saena na luma fuana foꞋongaꞋa, ma ka faꞋamanata ngwae Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","KaidaꞋi kira rongoa, kira ka Ꞌarefo liu ana na faꞋamanataꞋanga nia, sulia kira sai leꞋa ana neꞋe sa Jesus nia faꞋamanata Ꞌani ngasingasiꞋanga ma na mamanaꞋanga maꞋi ana God. NoaꞋa nia kasi donga laꞋu sai Ꞌi ruꞋanga ngwae faꞋamanata ana taki sa Moses ki, osiꞋana neꞋe kira faꞋamanata lala Ꞌani ngasingasiꞋanga kira talada. ");
INSERT INTO kwf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma ana kaidaꞋi neꞋeri logo, taꞋi ngwae neꞋe ano Ꞌi ru taꞋa nia ruꞋufia, nia ka ako ma ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus Ꞌae! ꞋAeꞋo na ngwae Ꞌi Nasaret! Tae niniꞋa Ꞌoke sasia aimili? Sali Ꞌoke leka maꞋi fuana malangisi laimili taka niniꞋa! Nau ku sai goꞋo Ꞌaku amu, ꞋaeꞋo neꞋana Ngwae Abu God!” ");
INSERT INTO kwf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma sa Jesus ka balufia na ano Ꞌi ru taꞋa neꞋeri ka Ꞌuri, “ꞋOke noto amu kwa, ma Ꞌoko ruꞋu maꞋi Ꞌi maa faꞋasia na ngwae neꞋana!” ");
INSERT INTO kwf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma na ano Ꞌi ru taꞋa neꞋeri, nia ka ako doe, ma ka lebesia na ngwae neꞋeri, ma ka ruꞋu tafa naꞋa maꞋi faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma na toꞋa neꞋe kira fiku Ꞌi neꞋeri ki, kira ka Ꞌarefo liu, ma kira ka lidi kwailiu ada ma kika Ꞌuri, “Na tae naꞋa neꞋe Ꞌuri re? Ta faꞋamanataꞋanga faolu taka niniꞋa? Ngwae neꞋe nia fata Ꞌani na ngasingasiꞋanga. Nia baꞋea ano Ꞌi ru taꞋa ki, ma kira ka roꞋosulia na fatalana.” ");
INSERT INTO kwf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ꞋI neꞋeri goꞋo, ꞋaliꞋali goꞋo alaꞋanga sulia sa Jesus ka talo naꞋa saena abaꞋi kula kalikali ana Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","KaidaꞋi sa Jesus faꞋinia sa James, ma sa John, kira leka naꞋa kwau faꞋasia na luma fuana foꞋongaꞋa neꞋeri, kira ka leka Ꞌuana luma sa Simon ma sa Andrew. ");
INSERT INTO kwf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","KaidaꞋi sa Jesus nia dao saena luma neꞋeri, kira faꞋarongoa neꞋe na funga kini sa Simon nia mataꞋi Ꞌani ꞋakoꞋakoꞋanga, ma nia ka maliu goꞋo Ꞌana saena na ꞋifitaꞋi nia. ");
INSERT INTO kwf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma sa Jesus nia ka leka siana kini neꞋeri, ma ka dau Ꞌi limana, ma ka taꞋea. Ma na ꞋakoꞋakoꞋanga neꞋeri ka sui naꞋa faꞋasia, ma kini neꞋeri ka kwatea fanga fuada. ");
INSERT INTO kwf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma ana faꞋi saꞋulafi neꞋeri, kaidaꞋi sina nia suu, ma ana asoa Jiu ki fuana mamaloꞋanga nia sui naꞋa, na ngwae ki ka ngalia maꞋi ngwae mataꞋi ki, ma toꞋa ano Ꞌi ru taꞋa ruꞋufida ki logo siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma toꞋa ana fanoa neꞋeri kira ka fiku taꞋifau maꞋi Ꞌi maana luma neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma sa Jesus ka gura naꞋa ngwae Ꞌoro ki neꞋe kira mataꞋi ana na mataꞋinga Ꞌoro toꞋotoꞋo ki. Ma nia ka ifulangaꞋinia logo na ano Ꞌi ru taꞋa Ꞌoro ki. Ma nia kasi alaꞋania neꞋe ano Ꞌi ru taꞋa neꞋeri ki kike fata, sulia kira sai sui goꞋo ana neꞋe niaꞋa Ngela God. ");
INSERT INTO kwf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma Ꞌofodangi goꞋo, kaidaꞋi nia rorodoꞋa Ꞌua, sa Jesus nia ada ka tataꞋe, ma ka ruꞋu kwau Ꞌi maa faꞋasia na luma neꞋeri. Ma nia ka leka foꞋo Ꞌana ana kula neꞋe nia aroaro. ");
INSERT INTO kwf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma sa Simon faꞋinia na ngwae kwaima nia ki kika lulu Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma kaidaꞋi kira dao toꞋona, kira ka fata Ꞌuri fuana, “Ngwae ki taꞋifau kira lulu Ꞌuamu.” ");
INSERT INTO kwf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma sa Jesus ka olisida ma ka Ꞌuri, “Nau ku saiana, bore ma kulu leka kwau ana ti maꞋe fanoa karangi logo, fasi Ꞌiri nau kui faꞋamanatada logo, duꞋungana ru neꞋeri na raoꞋa nau ku leka naꞋa maꞋi fuana.” ");
INSERT INTO kwf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ꞋUnaꞋeri goꞋo, sa Jesus nia ka leka saena maꞋe fanoa ki taꞋifau saena abaꞋi kula Ꞌi Galili, ma ka fulangaꞋinia fatalana God Ꞌi saena Luma fuana foꞋongaꞋa kira ki, ma ka ifulangaꞋinia ano Ꞌi ru taꞋa ki faꞋasia na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ꞋUnaꞋeri laꞋu, taꞋi ngwae kuuꞋa nia leka maꞋi siana sa Jesus, ma ka bobo uruuru Ꞌi Ꞌaena, ma ka amasia ka Ꞌuri, “DiꞋia Ꞌoko maꞋudi, Ꞌoke gura nau kwa.” ");
INSERT INTO kwf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma sa Jesus ka kwaimanatai liu ana, ma ka taga naꞋa limana kwau, ma ka sama toꞋona na ngwae neꞋeri, ka fata Ꞌuri, “Nau ku maꞋudi kwa. Na nonimu neꞋe ke mafo naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma ꞋaliꞋali goꞋo na kuu neꞋeri ka siki naꞋa faꞋasia, ma na nonina ka mafo taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sa Jesus ka fata totongaꞋi fuana ngwae neꞋeri ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“NoaꞋa Ꞌoe kosi faꞋarongoa laꞋu ta ngwae ana ru neꞋe nau ku sasia fuamu. Bore ma Ꞌoke leka basi, ma Ꞌoko faꞋataꞋinia naꞋa nonimu fuana na fata abu God, Ꞌoko alaꞋania fata abu God ka iroꞋo. Sui ma Ꞌoko kwatea na kwaisuꞋusiꞋanga Ꞌoe diꞋia ba sa Moses nia saea fuana kwatelana, fasi Ꞌiri ke kwatea faꞋamamanaꞋanga fuana na ngwae ki taꞋifau neꞋe nonimu nia mafo naꞋa.” Ma sa Jesus ka kwatea ngwae neꞋeri ka leka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bore ma, na ngwae neꞋeri nia leka, ma ka alaꞋa kwailiu ana saena fanoa ki taꞋifau sulia tae neꞋe sa Jesus nia sasia ana nonina ka leꞋa naꞋa. OsiꞋana faꞋarongoꞋanga neꞋeri talofida naꞋa neꞋe, ngwae Ꞌoro ki kira ka fiku fafia sa Jesus fuana rongolana. ꞋUnaꞋeri ma nia ka ꞋafitaꞋi naꞋa fuana sa Jesus neꞋe ke leka tafangaꞋi maꞋi saena fanoa kira ki, ma nia ka tua nene goꞋo Ꞌana ana kula aroaro ki. Ka ꞋunaꞋeri bore Ꞌana, na ngwae saena fanoa ki taꞋifau kira leka goꞋo maꞋi Ꞌada siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma Ꞌi buri Ꞌana bara faꞋi asoa sui, sa Jesus ka oli laꞋu maꞋi Ꞌuana Ꞌi Kapaneam. Ma kira ka faꞋarongo kwailiu Ꞌani neꞋe nia tua goꞋo Ꞌana saena luma ba nia ꞋidufaꞋi dao dao ana saena fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ꞋUnaꞋeri na ngwae Ꞌoro ki kira ka fiku naꞋa maꞋi siana sa Jesus, leleka na luma neꞋeri kira ka tuafia ka fungu liu naꞋa, ma ka noaꞋa naꞋa ta kula ni tuaꞋa Ꞌi saena luma neꞋeri. Ma Ꞌi maa bore, ngwae Ꞌoro ki kira fiku logo ana. Ma sa Jesus ka fulangaꞋinia fatalana God fuada. ");
INSERT INTO kwf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma ana kaidaꞋi neꞋeri logo, na fai ngwae ki kira leka maꞋi, kira ka ngalia maꞋi taꞋi ngwae neꞋe nonina mae. ");
INSERT INTO kwf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma osiꞋana neꞋe fikuꞋa doe neꞋeri, nia ka ꞋafitaꞋi naꞋa fuada ngalilana kwau siana sa Jesus. ꞋUnaꞋeri goꞋo, kira ka raꞋe Ꞌi fafona luma faꞋinia na ngwae neꞋeri. Ma kira ka tafangia taꞋi maꞋekwakwa doe Ꞌi fafona luma bolo faꞋinia kula neꞋe sa Jesus nia tua ana, ma kira ka faꞋakosoa na ngwae neꞋeri Ꞌi fafona ꞋifitaꞋi nia siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma kaidaꞋi sa Jesus nia lia saiana faꞋamamanaꞋanga kira, nia ka fata Ꞌuri fuana na ngwae nonina mae neꞋeri, “ꞋAlako Ꞌae, nau ku rufuanata naꞋa ana na taꞋangaꞋa Ꞌoe ki faꞋasiꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma kaidaꞋi neꞋeri, ti ngwae faꞋamanata ana taki ki kira tua logo Ꞌi neꞋeri, ma kira ka manata Ꞌada Ꞌuri talada, ");
INSERT INTO kwf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Reala kwa! NoaꞋa nia kasi bolo faꞋinia neꞋe nia ka fata ꞋunaꞋeri. Ngwae ki noaꞋa kasi saiana rufuanatalana taꞋangaꞋa ki. TalitoꞋona goꞋo God neꞋe saiana rufuanatalana taꞋangaꞋa ki. Nia faꞋabolotaꞋinia naꞋa faꞋinia God.” ");
INSERT INTO kwf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bore ma sa Jesus ka saiana manatalada, ma ka fata Ꞌuri fuada, “Kamu kasi manata laꞋu ꞋunaꞋeri.” Ma sa Jesus saiana logo neꞋe kira faꞋamamana talitoꞋona goꞋo God neꞋe ke gura ngwae ki. GoꞋo ꞋunaꞋeri nia ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“DiꞋia nau ku fata Ꞌuri fuana ngwae nonina mae neꞋe, ‘TaꞋangaꞋa Ꞌoe ki rufuanata naꞋa,’ kaumulu kasi lisia goꞋo neꞋe nia fuli. Bore ma diꞋia nau ku fata Ꞌuri, ‘TataꞋe, ngalia ꞋifitaꞋi Ꞌoe, ma Ꞌoko fali,’ Ꞌi neꞋeri kamu ka fiꞋi lisia neꞋe ngasingasiꞋanga nia aku fuana guraꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","KaidaꞋi nai gura ngwae neꞋe, nai faꞋataꞋinia fuamuꞋa neꞋe nauꞋa, Ngela Ngwae, nau ku toꞋo ana ngasingasiꞋanga fuana rufuanatalana na taꞋangaꞋa ki.” ꞋUnaꞋeri nia ka fata Ꞌuri fuana na ngwae neꞋeri neꞋe nonina mae, ");
INSERT INTO kwf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau ku saea fuamu, Ꞌoke tataꞋe, ngalia naꞋa ꞋifitaꞋi Ꞌoe, ma Ꞌoko leka naꞋa Ꞌi luma Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma ngwae neꞋeri tataꞋe, ka ngalia naꞋa ꞋifitaꞋi nia, ma ka leka naꞋa. ꞋUnaꞋeri, kira taꞋifau kira lisia, ma kika Ꞌarefo liu. KaidaꞋi neꞋeri, kira ka tafea God, ma kira ka fata Ꞌuri, “NoaꞋa kulu kasi lilisia Ꞌua ta ru Ꞌuri!” ");
INSERT INTO kwf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ta kaidaꞋi logo, sa Jesus nia oli laꞋu ninimana Ꞌosi Ꞌi Galili. Ma fikuꞋa doe kira ka leka maꞋi siana, ma nia ka talaꞋae ka faꞋamanata kira. ");
INSERT INTO kwf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma ana kaidaꞋi nia liu kwau sulia Ꞌosi neꞋeri, nia ka lisia sa Lifae, na ngela sa Alfeas. Nia tua goꞋo Ꞌana ana kula fuana ngalilana mani ana takisi, osiꞋana neꞋe nia rao Ꞌi neꞋeri. Ma sa Jesus ka fata Ꞌuri fuana, “ꞋOke leka maꞋi faꞋinau.” Ma sa Lifae ka tataꞋe, ma ka leka naꞋa Ꞌana faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma Ꞌi buri Ꞌana neꞋe sa Jesus nia baꞋea sa Lifae fuana fafarongo nia, nia ka leka fanga naꞋa Ꞌi luma nia. Ma na ngwaꞋi toꞋa ngali mani ana na takisi ki tua logo Ꞌi neꞋeri, ma ti “ngwae aburongo” logo, kira fanga faꞋinia sa Jesus ma na fafarongo nia ki. Na ngwae Ꞌoro ꞋunaꞋeri ki, kira leka faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti Farasi neꞋe kira faꞋamanata Ꞌani taki sa Moses ki, kira lisia neꞋe sa Jesus nia fanga faꞋinia “ngwaꞋi toꞋa aburongo ki” ma na ngwaꞋi toꞋa kira ngali mani ana takisi ki. GoꞋo Farasi ki kira ka fata Ꞌuri fuana fafarongo sa Jesus ki, “Nia bolo faꞋinia nia kasi fanga laꞋu faꞋinia ngwae Ꞌufuni ki.” ");
INSERT INTO kwf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma kaidaꞋi sa Jesus nia rongoa ru neꞋeri, nia ka fata Ꞌuri fuada, “Kamu saiana, noaꞋa laꞋu na ngwae Ꞌakwa ki neꞋe kira oga na ngwae kwaigurai. Ngwae mataꞋi ki tari, kira ka oga na ngwae kwaigurai fasi Ꞌiri ke gurada. Nau ku Ꞌiri leka laꞋu maꞋi fuana na ngwae tualada ꞋoloꞋolo naꞋa ki Ꞌi naꞋona God, bore ma nau ku leka lala maꞋi fuana ngwae abula taꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ana taꞋi kaidaꞋi, ti fafarongo ana sa John ngwae ni siuabu, ma na fafarongo Farasi ki, kira abu fanga fuana foꞋongaꞋa. Ma ti ngwae kira ka leka maꞋi, ma kira ka fata fuana sa Jesus kika Ꞌuri, “Fafarongo sa John ki, ma na fafarongo na Farasi ki, kira abu fanga. Nia Ꞌiri leꞋa fuana na fafarongo Ꞌoe ki neꞋe noaꞋa kira kasi abu fanga.” ");
INSERT INTO kwf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma sa Jesus ka olisida ka Ꞌuri, “Nia kasi bolo faꞋinia toꞋa neꞋe kira tua ana fafangaꞋa ana ara araꞋinga, kika abu fanga. DuꞋungana neꞋe, kaidaꞋi araꞋi faolu nia goꞋo Ꞌana Ꞌua faꞋinida ngwae ki, kira saeleꞋa. NoaꞋa daofaꞋi liu kira ka abu fanga, osiꞋana kira tua ana fafangaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bore ma kaidaꞋi ke dao maꞋi aigaꞋi neꞋe kira ke baꞋea na araꞋi faolu faꞋasida. ꞋUnaꞋeri mala, kira fiꞋi abu fanga laꞋu, osiꞋana neꞋe kira kwaimanatai. Nia neꞋe noaꞋa kasi bolo faꞋinia na fafarongo nau ki neꞋe kira ke abu fanga kaidaꞋi nau ku tua Ꞌua goꞋo aku faꞋi kira.” ");
INSERT INTO kwf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa ta ngwae kasi subungia ta toro neꞋe nia muu naꞋa ana ta ngisingisi toro neꞋe nia faolu. Si diꞋia nia sasia na ru neꞋeri, na ngisingisi toro faolu neꞋeri ka gasia na toro Ꞌua neꞋeri, duꞋungana toro faolu nia lukuluku Ꞌi buri Ꞌana saꞋulana, ma nia ka sasi na maꞋekwakwa neꞋe doe. ");
INSERT INTO kwf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma muke saiana logo, noaꞋa nia kasi bolo fuana ta ngwae ka alua naꞋa waen faolu Ꞌi saena ngwaꞋi Ꞌua ana ꞋuꞋuila nanigot, duꞋungana ngwaꞋi ru Ꞌua neꞋeri kasi baꞋu. Si diꞋia nia sasia ru ꞋunaꞋeri, kaidaꞋi na waen neꞋeri ke totoro goꞋo maꞋi, nia ka foga naꞋa ngwaꞋi ru Ꞌua neꞋeri, ma na waen neꞋeri ka kisitaꞋi, ma na ngwaꞋi ru neꞋeri ka taꞋa naꞋa. Nia neꞋe ngwae ke alua nama waen faolu Ꞌi saena na ngwaꞋi ru faolu neꞋe nia saiana ke baꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana taꞋi Sabat, asoa ana mamaloꞋanga, sa Jesus ma na fafarongo nia ki, kira leka sulia na tala neꞋe nia liu Ꞌi saena oꞋola witi, na ru kira saungani fuana beret. Ma kaidaꞋi kira liu ana, na fafarongo nia ki kira ka loia fingi witi ki, ma kira ka Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma na Farasi ki kira lisia, ma kira ka fata Ꞌuri fuana sa Jesus, “Lisia basi kwa! Ru neꞋe kaumulu sasia nia Ꞌoia na taki sa Moses, osiꞋana kamu loia witi neꞋe ana Sabat, asoa ana mamaloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma sa Jesus ka olisida ma ka Ꞌuri, “Nau ku saiana kaumulu toꞋomaꞋi saena Buka Abu sulia ru ba sa David nia sasia, kaidaꞋi ba sa Abiata nia ꞋingataꞋi fata abuꞋa. KaidaꞋi baera, sa David faꞋinia ngwae nia ki kira fiolo liu, sulia noaꞋa naꞋa ta fanga fuada. Ma nia ka leka Ꞌi saena na luma God, ma na ꞋingataꞋi fata abu kwatea fuana sa David na beret neꞋe kira Ꞌau abua fuana God. Ma sa David ka Ꞌania naꞋa beret neꞋeri, ma ka kwatea logo fuana ngwae nia ki, ma kira ka Ꞌania. Bore ma na taki kulu alaꞋani fuana taꞋifilia goꞋo na fata abu God ki neꞋe kira saiana Ꞌanilana. Ma noaꞋa kulu kasi lisia saena Buka Abu neꞋe God ni saetaꞋa fuana sa David.” ");
INSERT INTO kwf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui goꞋo sa Jesus ka fata Ꞌuri fuana na Farasi ki, “God nia saungaꞋinia asoa ana mamaloꞋanga fuana Ꞌafilana ngwae ki. Ma noaꞋa nia kasi saungaꞋinia laꞋu asoa ana mamalo Ꞌanga fuana ngwae neꞋe ke lae roroto olofana. ");
INSERT INTO kwf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","DuꞋungana neꞋe nauꞋa, na Ngela Ngwae, nau ku toꞋo ana na ngasingasiꞋanga fuana saelana ru ki fuana ngwae ki kira saiana kike sasia goꞋo Ꞌada ana asoa ana mamaloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ta kaidaꞋi logo, sa Jesus nia ka leka laꞋu saena na luma fuana foꞋongaꞋa, ma taꞋi ngwae neꞋe limana mae, nia tua Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma ti Farasi Ꞌi neꞋeri, kira ka lialia diꞋia sa Jesus ke gura ngwae neꞋeri ana asoa ana mamaloꞋanga ana Sabat. DiꞋia ꞋunaꞋeri, kira ka fata maana sa Jesus ana Ꞌoilana taki God ana guraꞋa, ru neꞋeri kira manata sulia neꞋe diꞋia raoꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma sa Jesus ka fata Ꞌuri fuana na ngwae neꞋe limana mae, “TataꞋe maꞋi Ꞌi neꞋe, ko uu Ꞌi naꞋo ana ngwae ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","GoꞋo, sa Jesus ka lidia na Farasi ki ka Ꞌuri, “Tae neꞋe taki kulu nia alaꞋania fasi Ꞌiri kulu ka sasia ana asoa ana mamaloꞋanga? Nia alaꞋania sasilana ru leꞋa ki, nama sasilana ru taꞋa ki? Nia alaꞋania na faꞋamaurilana ta ngwae, nama saungilana ta ngwae?” Bore ma kira kasi saea goꞋo ta ru. ");
INSERT INTO kwf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sa Jesus nia lia kalikalida, ma nia ka lia saetaꞋa, osiꞋana neꞋe kira noaꞋa kasi kwaimanatai naꞋa ana ngwae mataꞋi neꞋeri, ma nia ka kwaimanatai logo fuada sulia manatada ngasi liu naꞋa. Sui goꞋo, ma nia ka fata Ꞌuri fuana na ngwae neꞋeri, “Taga maꞋi na limamu.” Ma nia ka taga naꞋa limana, goꞋo ma na limana ka leꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ꞋUnaꞋeri goꞋo Farasi ki kira ka ruꞋu kwau Ꞌi maa, ma kira ka alaꞋa fiku faꞋinia ti ngwae ana ngwaꞋi toꞋa sa Herod ki, ma kira ka manata Ꞌuana saungilana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Sa Jesus faꞋinia fafarongo nia ki, kira ka faꞋasia ngwaꞋi toꞋa neꞋeri, ma kira ka leka Ꞌuana na Ꞌosi Ꞌi Galili. Na ngwae Ꞌoro kira ka leka logo Ꞌi buri Ꞌada. Kira leka maꞋi faꞋasia na abaꞋi kula Ꞌi Galili, Ꞌi Judea ma Ꞌi Idumea ki. Ma ti ngwae logo faꞋasia ꞋingataꞋi fanoa Ꞌi Jerusalem, ma faꞋasia na bali fanoa ana raꞋelana sina ana kafo Ꞌi Jodan. Ma ti ngwae kira ka leka maꞋi faꞋasia na fanoa ki kalikalia Ꞌi Taea ma Ꞌi Saedon. Na fikuꞋa doe neꞋeri, kira leka maꞋi siana sa Jesus, sulia kira rongoa ru doe ki neꞋe nia sasiꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sulia na fikuꞋa neꞋeri doe liu, sa Jesus ka saea fuana fafarongo nia ki fasi Ꞌiri kike sasi akaꞋu ana na gwaꞋi baru, Ꞌasu Ꞌubani na ngwaꞋi toꞋa kira kata kwaibekesi. ");
INSERT INTO kwf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nia gura ngwae Ꞌoro ki ka sui naꞋa, nia neꞋe ngwae Ꞌoro mataꞋi ki ka suꞋumaꞋi kira kwau, fasi Ꞌiri kike sama toꞋona nama sa Jesus Ꞌiri kike Ꞌakwa. ");
INSERT INTO kwf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma kaidaꞋi na ngwaꞋi toꞋa ano Ꞌi ru taꞋa ki nia ruꞋufida kira lisia, kira ka bobo uruuru Ꞌi naꞋona, ma kira ka ri ma kika Ꞌuri, “ꞋAeꞋo naꞋa neꞋe, na Ngela mamana God!” ");
INSERT INTO kwf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bore ma sa Jesus fata ka luia liu na ano Ꞌi ru taꞋa neꞋeri ki, fasi Ꞌiri kira kasi faꞋarongoa laꞋu ta ngwae Ꞌani niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ꞋUnaꞋeri goꞋo sa Jesus ka raꞋe ꞋalaꞋa Ꞌi gwauna taꞋi faꞋi ua, ma ka baꞋea maꞋi ngwae ki fuana raoꞋa faꞋinia. GoꞋo kira ka leka maꞋi siana, ");
INSERT INTO kwf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ma nia ka filia na akwala ma ro ngwae, ma ka faꞋasata kira Ꞌani lifurongo ki. Ma nia ka fata Ꞌuri fuada, “Nau ku fili kamu fasi Ꞌiri muke tua tari faꞋinau, ma nau ku baꞋe kamu logo fuana faꞋamanataꞋanga sulia fatalana God fuana ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma kamu ka toꞋo ana na ngasingasiꞋanga fuana na ifulangaꞋilana na ano Ꞌi ru taꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ꞋIu, na satana na akwala ma ro ngwae neꞋe nia filida ki: sa Simon, neꞋe sa Jesus nia faꞋasata logo Ꞌani sa Peter, ");
INSERT INTO kwf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma sa James faꞋinia sa John na ro ngela sa Sebedi ki, neꞋe sa Jesus nia faꞋasata kera Ꞌani “Boneges,” na fadalana neꞋe ngwae neꞋe saetaꞋa ladaroꞋo ꞋaliꞋali diꞋia na kwangakwanga. ");
INSERT INTO kwf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma sa Andrew, ma sa Filip, ma sa Batolomiu, ma sa Matthew, ma sa Tomas, ma sa James, ngela sa Alfeas, ma sa Tadeas, ma sa Simon, ta ngwae ana ngwaꞋi toꞋa Jiu neꞋe kira oga lalilana na ngwaꞋi toꞋa Ꞌi Rom faꞋasia Israel. ");
INSERT INTO kwf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma sa Judas Iskariot na ngwae nia ke baꞋa Ꞌolosaea sa Jesus fuana malimae nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ꞋUnaꞋeri, sa Jesus ka oli logo saena luma ba nia ꞋidufaꞋi dao dao ana. Ma na ngwae Ꞌoro ki, kira ka inaꞋu naꞋa maꞋi ana fikuꞋa. ꞋUnaꞋeri noaꞋa naꞋa ta kaidaꞋi fuana sa Jesus ma na fafarongo nia ki fuana sasilana ta ru ma na fangaꞋa bore. ");
INSERT INTO kwf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma kaidaꞋi neꞋe ngwaefuta nia ki kira rongoa ru neꞋeri, kira ka leka siana fuana olitaꞋilana Ꞌuana Ꞌi fanoa, sulia kira fata Ꞌuri, “Nia boleboleꞋa liu naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma ti ngwae faꞋamanata ana taki sa Moses neꞋe kira leka maꞋi faꞋasia Ꞌi Jerusalem, kira ka fata Ꞌuri, “Sa Jesus nia ifulani naꞋa ano Ꞌi ru taꞋa ki Ꞌani ngasingasiꞋanga sa Saetan, na ꞋingataꞋi ano Ꞌi ru taꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nia neꞋe, sa Jesus ka saea maꞋi ngwae ki ka fata Ꞌuri fuada Ꞌania tarifulaꞋa ki ka Ꞌuri, “Sa Saetan nia ꞋafitaꞋi ka ifulani ano Ꞌi ru taꞋa ki faꞋasia ngwae nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","DiꞋia ngwaꞋi toꞋa saena ta fanoa doe kira fuꞋali kira talada, Ꞌirai na fanoa doe neꞋeri ke angosi, ma ka takalo naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma diꞋia neꞋe ngwae, ma na Ꞌafe, ma na ngela nia ki, kira fuꞋa faꞋi kira talada, nia ꞋafitaꞋi fuana kira ka tua fiku. ");
INSERT INTO kwf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma na ꞋinotoꞋanga sa Saetan neꞋe ꞋunaꞋeri logo. DiꞋia sa Saetan ke fuꞋa faꞋinia toꞋa neꞋe kira leka sulia, Ꞌirai kira ke takalo kwailiu goꞋo, ma ngasingasiꞋanga nia fafida ka dao ana Ꞌisilana.” ");
INSERT INTO kwf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ꞋI buri Ꞌana, sa Jesus ka saea laꞋu taꞋi tarifulaꞋa, ka fata Ꞌuri, “DiꞋia ta ngwae goꞋo Ꞌana oga ka ifulani ta ano Ꞌi ru taꞋa, ngwae neꞋeri ke ngasingasiꞋa ka liufia sa Saetan. Ka diꞋia logo ta ngwae neꞋe oga ke ruꞋu saena luma na ngwae ngasingasiꞋa fuana ngalilana ru nia ki. Nia ke ngasingasiꞋa ka liufia mala ngwae neꞋeri, fasi Ꞌiri ke talangwaraꞋu fuana firiꞋilana ngwae ngasingasiꞋa neꞋeri sui mala nia ka fiꞋi ngali ru nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ru mamana nau ku saea fuamuꞋa, na abula taꞋangaꞋa ki, ma na fata faꞋalilana God neꞋe ngwae ki kira sasi, God nia rufuanata goꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bore ma, diꞋia ta ngwae ke inaꞋo ana fata faꞋalilana na AnoꞋi ru Abu, God noaꞋa kasi rufuanata, sulia taꞋangaꞋa neꞋeri nia teoteo firi.” ");
INSERT INTO kwf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sa Jesus nia fata ꞋunaꞋeri sulia na ngwae faꞋamanata ana taki ki, kira saea nia toꞋo ana na ano Ꞌi ru taꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma Ꞌi buri Ꞌana ru neꞋeri ki, teꞋa sa Jesus ma na ngwaefuta nia ki, kira ka dao naꞋa. Ma kira ka uu goꞋo Ꞌada Ꞌi maana luma, ma kira ka kwate alaꞋanga kwau fuana sa Jesus, ma kira ka lidi Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na ngwaꞋi toꞋa Ꞌoro liu ki neꞋe kira tua kalikalia sa Jesus, ma kira ka faꞋarongoa kika Ꞌuri, “TeꞋa Ꞌoe, ma na ngwaefuta Ꞌoe ki, kira uu maꞋi Ꞌi maa, kira oga lisilamu.” ");
INSERT INTO kwf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma sa Jesus ka olisida ka Ꞌuri, “Nai saea fuamuꞋa Ꞌi tai neꞋe teꞋa mamana nau, ma ngwaefuta nau ki!” ");
INSERT INTO kwf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","GoꞋo kaidaꞋi nia ka lia kwau fuana na ngwaꞋi toꞋa Ꞌoro neꞋe kira tua kalikalia, nia ka fata Ꞌuri, “Nia naꞋa neꞋe ngwaꞋi toꞋa kira diꞋia naꞋa teꞋa nau ki, ma na ngwaefuta nau ki! ");
INSERT INTO kwf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sulia sa tai goꞋo Ꞌana neꞋe nia sasia ru neꞋe God nia ogaꞋi ki, nia naꞋa neꞋe ngwaefuta nau, ma na ngwaingwaena nau, ma teꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana taꞋi kaidaꞋi laꞋu, sa Jesus nia faꞋamanata Ꞌi ninimana Ꞌosi Ꞌi Galili. Ma na fikuꞋa doe liu kira ka fiku kalikalia, ma nia ka raꞋe saena taꞋi gwaꞋi baru, ma ka tua Ꞌi saena, ma nia ka Ꞌidu tiꞋitiꞋi laꞋu folo saena Ꞌosi. Ma na fikuꞋa neꞋeri, kira ka uu kwau Ꞌi ninimana Ꞌosi. ");
INSERT INTO kwf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma sa Jesus ka faꞋamanata Ꞌani ru Ꞌoro ki fuada ana tarifulaꞋa ki ma ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mulu fafarongo basi! TaꞋi ngwae nia leka ka tasalia na maga witi ki Ꞌi saena oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma kaidaꞋi nia tasalia na maga witi neꞋeri ki, ti maga witi kira Ꞌasia sulia na talalinga, ma na noꞋo ki kira ka lofo maꞋi, ma kira ka Ꞌanida taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma ti maga witi kira ka Ꞌasida ana kula faula ki, kula neꞋe ano kasi doe. Ma kira ka bulao ꞋaliꞋali, sulia neꞋe ano nia kasi Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma ana ta kaidaꞋi neꞋe sina nia taꞋe maꞋi, nia ka sinafia na witi neꞋe masubu ki, ma kira ka kuku logo, sulia neꞋe lali ru ki noaꞋa kasi koso lalo. ");
INSERT INTO kwf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma ti maga witi kira Ꞌasida Ꞌi safitana na kwalo Ꞌabui ki, ma kwalo neꞋeri ka nuku fafia na witi ki, ma witi neꞋeri ki noaꞋa kasi fungu goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma ti maga witi laꞋu, kira Ꞌasida Ꞌi saena na ano neꞋe nia leꞋa, ma kaidaꞋi kira taꞋe maꞋi, kira ka fungu ana fuaꞋi ru Ꞌoro ki. Ma ti witi kira ka fungu ana uulu akwala faꞋiruꞋa, ma ti witi kira ka fungu ana ono akwala faꞋiruꞋa, ma ti witi laꞋu kira ka fungu ana taꞋi talangaꞋi faꞋiruꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma sa Jesus ka faꞋasuia fatalana ka Ꞌuri, “DiꞋia ta ngwae oga ka sai leꞋa ana ru neꞋe ki, nia ka sailinga leꞋa mala.” ");
INSERT INTO kwf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","KaidaꞋi sa Jesus nia tua Ꞌana taꞋifilia, na akwala ma ro fafarongo ba nia ki, faꞋinia ta bali ana ngwae neꞋe kira rongoa na fatalana, kira ka leka maꞋi siana. Ma kira ka lidia fasi Ꞌiri nia ke fada madakola ana fadalana tarifulaꞋa neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma nia ka olisida ka Ꞌuri, “KaidaꞋi sui ki, God noaꞋa kasi faꞋamadakola Ꞌua faꞋuta neꞋe nia ke baꞋa gwaungaꞋi fafia ngwae nia ki. Bore ma taꞋena, na madakolaꞋa niniꞋa dao naꞋa fuamuꞋa. Ngwae neꞋe noaꞋa kira kasi oga fafarongo aku, nau ku fata Ꞌani tarifulaꞋa ki, ma noaꞋa naisi faꞋamadakola ");
INSERT INTO kwf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","fasi Ꞌiri, ‘Kira ke lia, ma kira ke lia, bore ma noaꞋa kira kasi lisia tae neꞋe God nia sasi fuada. Ma kira ke fafarongo, ma kike fafarongo, bore ma noaꞋa kira kasi saiana faꞋarongoꞋa God. Sulia diꞋia kira lia saiana, ma kira ka rongo saiana, Ꞌirai kira ke abula maꞋi fuana God, ma nia ke rufuanata ana taꞋangaꞋa kira ki.’” ");
INSERT INTO kwf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ꞋUnaꞋeri sa Jesus ka saefilo Ꞌuri ada, “ꞋUri ma noaꞋa kamu kasi sai goꞋo ana tarifulaꞋa neꞋe? DiꞋia noaꞋa kamu kasi saiana tarifulaꞋa neꞋe, kamu ke fiꞋi sai mo faꞋuta ana tarifulaꞋa ki? ");
INSERT INTO kwf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na ngwae ba nia tasali maga witi, nia tasalia na fatalana God ba. ");
INSERT INTO kwf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma ngwae neꞋe kira rongoa na fatalana God, kira diꞋia na maga witi neꞋe nia Ꞌasia sulia na talalinga. Ma kaidaꞋi kira rongoa, sa Saetan nia leka maꞋi, ma ka lafua logo Ꞌana fatalana God faꞋasida. ");
INSERT INTO kwf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma ti ngwae laꞋu kira diꞋia na maga witi neꞋe kira Ꞌasida ana kula faula. KaidaꞋi kira rongoa na fatalana God, kira ngalia, ma kira ka saesaeleꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bore ma fatalana God noaꞋa kasi lalisusu goꞋo saena maurilada. Nia neꞋe fitoꞋonga kira ki ka mauri goꞋo sulia kala kaidaꞋi tiꞋitiꞋi. Ma kaidaꞋi neꞋe kira dao toꞋona ꞋafitaꞋiꞋanga, ma na nonifiiꞋanga ki duꞋungana faꞋarongoꞋa leꞋa neꞋe, kira ka danga Ꞌania goꞋo na fatalana God. ");
INSERT INTO kwf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma ti ngwae neꞋe kira diꞋia maga witi neꞋe kira Ꞌasida Ꞌi safitana na kwalo Ꞌabui ki. Kira rongoa na fatalana God, ");
INSERT INTO kwf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bore ma kira manata Ꞌabera Ꞌada sulia ru ki ana mauriꞋa kira, ma kira ka manata doe ana na mani. Ma ru neꞋeri ki, nia diꞋia na kwalo Ꞌabui ki nia nuku fafia na fatalana God saena maurilada. NoaꞋa kira kasi rokisi goꞋo saena maurilada, ka diꞋia na witi neꞋe noaꞋa kasi fungu goꞋo Ꞌani ta fuaꞋi ru. ");
INSERT INTO kwf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma ti ngwae laꞋu neꞋe kira diꞋia na maga witi neꞋe kira Ꞌasida Ꞌi saena ta ano leꞋa. Kira rongoa fatalana God, ma kira ka roꞋosulia, ma kira faꞋataꞋinia tuaꞋa ꞋoloꞋolo, ka diꞋia witi neꞋe nia fungu ana fuaꞋi ru ki. Ti witi neꞋe uulu akwala fuaꞋi ruꞋanga, ma ti witi neꞋe ono akwala fuaꞋi ruꞋanga, ma ti ai neꞋe taꞋi talangaꞋi fuaꞋi ruꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ꞋUnaꞋeri goꞋo sa Jesus ka saefilo laꞋu Ꞌuri ada, “Nia faꞋuta? ꞋUri ma diꞋia ta ngwae ngalia maꞋi na unu, nia ke alua goꞋo Ꞌana Ꞌi olofana ta dako nama ta ꞋifitaꞋi? NoaꞋa goꞋo! Nia ke alua nama Ꞌi fuila Ꞌi lifua! ");
INSERT INTO kwf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ru ngwae ki noaꞋa Ꞌiri sai sai ana Ꞌi naꞋo, kike baꞋa saiana. ");
INSERT INTO kwf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","DiꞋia ta ngwae neꞋe oga ka sai leꞋa ana ru neꞋe ki, nia ka sailinga leꞋa mala.” ");
INSERT INTO kwf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma sa Jesus ka fata laꞋu Ꞌuri fuada, “Muke manata leꞋa sulia ru neꞋe kamu rongoꞋi ki. God ke baꞋa kwate tatakolaꞋa ana liatoꞋo Ꞌanga fuamuꞋa, si diꞋia kamu roꞋosulia na faꞋamanataꞋanga nau ki. ");
INSERT INTO kwf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa tai bore Ꞌana neꞋe toꞋo ana ta madakolaꞋa Ꞌanga tiꞋitiꞋi sulia ꞋinotoꞋanga God, God ke baꞋa luda gwauna fuana. Bore ma sa tai neꞋe noaꞋa kasi roꞋosulia faꞋamanata Ꞌanga neꞋe ki, ta madakolaꞋanga tiꞋitiꞋi bore Ꞌana neꞋe nia toꞋo ana sulia ꞋinotoꞋanga God, God ke ngali olitaꞋinia faꞋasia.” ");
INSERT INTO kwf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sa Jesus ka fata laꞋu Ꞌuri fuada, “Na ꞋInotoꞋanga God nia diꞋia na ngwae neꞋe nia fasia ta maga ru Ꞌi saena na oꞋola nia. ");
INSERT INTO kwf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nia ada, ka liliu Ꞌana asoa ki, ma ka maliu Ꞌana saena rodo ki. ꞋUnaꞋeri bore Ꞌana, kaidaꞋi neꞋe maga ru ki nia bulao, ma ka tataꞋe naꞋa, noaꞋa laꞋu ꞋaberaꞋanga nia. OsiꞋana ngwae neꞋe noaꞋa kasi sai logo Ꞌana ana ru neꞋe nia sasia maga ru ka bulao. ");
INSERT INTO kwf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na ano talana naꞋa neꞋe nia faꞋamauria maga ru neꞋeri ki niꞋi ka doe, ma ka fungu Ꞌani fuaꞋi ru ki. Na ꞋingataꞋi Ꞌai nia raꞋe maꞋi Ꞌi naꞋo, sui na fingi ru ki, Ꞌi buri na maga ru ki fiꞋi raꞋe maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma kaidaꞋi neꞋe maga ru neꞋeri ki nia maua, na ngwae neꞋeri ka talaꞋae fuana sikililana naꞋa fingi ru ki, sulia nia dao naꞋa ana kaidaꞋi fuana loi ruꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sa Jesus nia fata laꞋu ka Ꞌuri, “Nai fata laꞋu kwau sulia ta ꞋaꞋemae neꞋe ke faꞋataꞋinia na ru neꞋe bolo faꞋinia ꞋinotoꞋanga God fafia ngwae nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nia ka Ꞌuri: TaꞋi ngwae nia ngalia na magana Ꞌai neꞋe kira saea Ꞌani mastad, nia tiꞋitiꞋi ka liufia magana Ꞌai ki taꞋifau, ma nia ka fasia saena ano. ");
INSERT INTO kwf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma Ꞌi buri Ꞌana neꞋe nia fasia ka sui, na maga ru baera ka taꞋe, ma ka alua naꞋa Ꞌai. ꞋAi neꞋeri doe ka liufia naꞋa Ꞌai Ꞌoro ki. Ma nia ka toꞋo ana na rara Ꞌai doe ki, ma na noꞋo ki kira ka lofo maꞋi, ma kira ka saungaꞋinia na nuꞋi kira ki ana.” ");
INSERT INTO kwf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ꞋUnaꞋeri neꞋe, sa Jesus ka fata fuana na ngwae ki ana tarifulaꞋa neꞋeri ki, ma nia ka saea ru neꞋe nia bolo faꞋinia kike saiana ki. ");
INSERT INTO kwf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma nia ka fata fuada Ꞌania tarifulaꞋa ki. Bore ma, kaidaꞋi neꞋe nia tua Ꞌana taꞋifilia faꞋinia na fafarongo nia ki, nia ka fiꞋi faꞋamadakola ru ki taꞋifau fuada. ");
INSERT INTO kwf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nia saꞋulafi naꞋa ana asoa neꞋeri, sa Jesus nia ka fata Ꞌuri fuana fafarongo nia ki, “Kulu toꞋofolo basi Ꞌuana bali Ꞌosi loꞋoba.” ");
INSERT INTO kwf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma kika faꞋasia naꞋa fikuꞋa neꞋeri, ma kira ka leka faꞋinia sa Jesus Ꞌi saena baru neꞋeri neꞋe nia ka tua Ꞌi saena. Ma ti baru logo teo Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma na iru doe nia taꞋe maꞋi, ma na nafo ka magara naꞋa maꞋi saena na baru neꞋeri, ma ka karangi kuru naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma sa Jesus nia maliu Ꞌana Ꞌi burina na baru, ma ka alu gwau ana bogwau nia. Ma na fafarongo nia ki kira ka faꞋaada, ma kira ka fata Ꞌuri, “Aofia kwa, kulu karangi kuke mae naꞋa! ꞋOe kosi manata Ꞌabera goꞋo niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma sa Jesus ka tataꞋe, ma ka balufia na iru neꞋeri ka Ꞌuri, “ꞋOke aroaro naꞋa!” Ma nia ka fata logo fuana na nafo neꞋeri ka Ꞌuri, “Kamu ke tua nene naꞋa!” ꞋUnaꞋeri goꞋo, na iru baera ka aroaro naꞋa, ma Ꞌosi ka folaꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma nia ka fata Ꞌuri fuana fafarongo nia ki, “FaꞋuta neꞋe kamu ka maꞋu? Nau ku lisia na faꞋamamana Ꞌanga kamu aku noaꞋa Ꞌiri doe.” ");
INSERT INTO kwf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma kira ka maꞋu kika felo naꞋa, ma kira ka lidi kwailiu ada kira ka Ꞌuri, “Ngwae faꞋuta naꞋa niniꞋa re? Na iru ma na nafo bore kika roꞋo naꞋa sulia!” ");
INSERT INTO kwf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sa Jesus faꞋinia na fafarongo nia ki, kira toꞋofolo Ꞌuana bali Ꞌosi Ꞌi Galili, ma kira ka dao ana bali Ꞌosi neꞋe ana abaꞋi kula Ꞌi Gerasa. ");
INSERT INTO kwf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma kaidaꞋi sa Jesus nia koso faꞋasia na baru, taꞋi ngwae neꞋe ano Ꞌi ru taꞋa nia ruꞋufia ka leka maꞋi faꞋasia na faoda fuana kwaiatoꞋa ki, ma nia ka leka maꞋi siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na ngwae neꞋeri tualana saena faoda ꞋunaꞋeri ki, ma noaꞋa ta ngwae kasi bolo faꞋinia firiꞋilana Ꞌani ta sene. ");
INSERT INTO kwf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sulia kaidaꞋi Ꞌoro ki, kira firi fafia na limana ma na Ꞌaena Ꞌani sene ki, sui nia ka muusia goꞋo na sene neꞋeri ki, ma ka Ꞌoia goꞋo Ꞌana na sene neꞋeri ki Ꞌi Ꞌaena. Ma noaꞋa ta ngwae kasi ngasingasiꞋa kasi bolo faꞋinia na daulana. ");
INSERT INTO kwf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma na rodo ki ma na asoa ki, nia tua Ꞌi safitana na faoda ana kwaiatoꞋa ki, ma nia ka raꞋe saena faꞋi ua ki, ma nia ka ako, ma ka afasia talana Ꞌani naki ki. ");
INSERT INTO kwf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","KaidaꞋi nia tua tau maꞋi, nia ka lisia sa Jesus, ma ka lalili maꞋi, ma ka bobo uruuru Ꞌi naꞋona. ");
INSERT INTO kwf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Sa Jesus ka fata Ꞌuri fuana, “Ano Ꞌi ru taꞋa neꞋe, Ꞌoke ruꞋu maꞋi Ꞌi maa faꞋasia na ngwae neꞋe.” Ma nia ka ako doe ka Ꞌuri, “Jesus! ꞋAeꞋo, na Ngela God neꞋe nia ngasingasiꞋa liu. Na tae neꞋe Ꞌoko oga Ꞌoke sasia aku? Nau ku amasiꞋo Ꞌania satana God, Ꞌoe kosi kwatea ta kwaꞋikwaꞋinga fuaku!” ");
INSERT INTO kwf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui sa Jesus ka saefiloa ka Ꞌuri, “Satamu sa tai kwa?” Ma nia ka olisia ka Ꞌuri, “Na sataku sa Fuani Oro, sulia kaimili Ꞌoro liu.” ");
INSERT INTO kwf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma nia ka amasia sa Jesus fasi Ꞌiri noaꞋa nia kasi baꞋeda laꞋu faꞋasia na bali fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma na ngwaꞋi gwata Ꞌoro liu kira fanga goꞋo ada logo Ꞌi babaraꞋo ana ua neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma na ano Ꞌi ru taꞋa neꞋeri ki, kira amasia sa Jesus kira ka Ꞌuri, “ꞋOke kwate kaimili fuana na gwata loꞋoko ki, fasi Ꞌiri kaimili ke ruꞋu Ꞌaimili Ꞌi saeda.” ");
INSERT INTO kwf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma sa Jesus ka alaꞋanida, ma na ano Ꞌi ru taꞋa neꞋeri ki kira ka ruꞋu maꞋi faꞋasia ngwae neꞋe, ma kira ka leka, kika ruꞋu Ꞌi saena na gwata neꞋeri ki. Ma na ngwaꞋi gwata neꞋeri nia bolo faꞋinia na ro toꞋoni gwata ki, ma kira ka lalili saena kwata Ꞌato neꞋeri, ma kira ka Ꞌasia Ꞌi saena na Ꞌosi neꞋeri, ma kira ka kwaꞋu kika mae taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma ngwae neꞋe kira lia sulia na gwata neꞋeri ki, kira ka tafi, ma kira ka faꞋarongo Ꞌani ru neꞋe nia fuli ana gwata ki Ꞌi saena fanoa neꞋeri, ma na fanoa tiꞋitiꞋi kalikalida ki. Ma na ngwae Ꞌoro ki kira ka leka fuana lisilana ru neꞋe nia fuli. ");
INSERT INTO kwf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma ana kaidaꞋi kira dao siana sa Jesus, kira ka lisia naꞋa ngwae baera neꞋe ano Ꞌi ru taꞋa Ꞌoro ki kira ruꞋufia, nia tua naꞋa Ꞌana Ꞌi neꞋeri, ma nia ka toro naꞋa, ma nia ka manata saga naꞋa. Ma na ngwae ki kira ka maꞋu, kira ka Ꞌarefo liu. ");
INSERT INTO kwf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma na ngwae neꞋe kira lisia ru neꞋeri nia fuli, kira ka alaꞋa fuana ngwae ki sulia na ngwae ano Ꞌi ru taꞋa ki tuatua ana, ma kira ka alaꞋa logo sulia na gwata neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma buri Ꞌana, ngwaꞋi toꞋa neꞋeri kika Ꞌengoa sa Jesus ka leka faꞋasia na bali fanoa kira. ");
INSERT INTO kwf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma kaidaꞋi sa Jesus nia raꞋe naꞋa saena na baru, na ngwae ba na ano Ꞌi ru taꞋa ki kira ruꞋufia Ꞌi naꞋo, nia ka Ꞌengoa sa Jesus Ꞌiri ke leka faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bore ma sa Jesus kasi alaꞋania, ma ka fata Ꞌuri fuana, “ꞋOke oli Ꞌi fanoa siana na ngwae Ꞌoe ki, ma Ꞌoko faꞋarongoda Ꞌani ru leꞋa ki taꞋifau neꞋe God nia sasia fuamu, ma na kwaimanataiꞋanga nia fuamu.” ");
INSERT INTO kwf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma na ngwae neꞋeri nia leka, ma ka faꞋarongoa naꞋa ngwae ki ana abaꞋi kula Ꞌi Dekapolis ana ru ki taꞋifau neꞋe sa Jesus nia sasia fuana. Ma na ngwae ki taꞋifau kira ka Ꞌarefo liu. ");
INSERT INTO kwf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa Jesus nia toꞋofolo laꞋu kwau Ꞌuana ta bali Ꞌosi. Ma ana kaidaꞋi nia ka dao naꞋa ana ta bali, ngwae Ꞌoro ki kira ka fiku kalikalia. ");
INSERT INTO kwf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma taꞋi ngwae ada neꞋe ngwae fai naꞋonaꞋo saena na Luma fuana foꞋongaꞋa ana fanoa neꞋeri, satana sa Jaeras, ka leka maꞋi. Ma kaidaꞋi nia lisia sa Jesus, nia ka bobo uruuru Ꞌi maana Ꞌaena, ");
INSERT INTO kwf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma nia ka amasia ma ka Ꞌuri, “Kala defo nau nia teo naꞋa fuana maelana. ꞋOke leka maꞋi, Ꞌiri Ꞌoke alua na limamu Ꞌi fafona, fasi Ꞌiri nia ke Ꞌakwa ma ka mauri.” ");
INSERT INTO kwf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma sa Jesus ka leka naꞋa faꞋinia. Ma na fikuꞋa doe kika leka Ꞌi burina, ma kira ka kwaibekesi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma taꞋi Ꞌafe neꞋe na gwaꞋi Ꞌabu tafangia sulia taꞋi akwala ma ro faꞋi ngali sui naꞋa, nia tua logo Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma nia ka nonifii liu naꞋa. Ma nia ka faꞋalia naꞋa mani Ꞌoro nia ki fuana na ngwae kwaigurai Ꞌoro ki, bore ma tualana kasi leꞋa goꞋo. Nia fiꞋi taꞋa ka tasa liu mo. ");
INSERT INTO kwf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma kaidaꞋi neꞋe nia rongoa alaꞋanga sulia sa Jesus, nia ka kwako maꞋi Ꞌi burina Ꞌi safitana na fikuꞋa neꞋeri, nia ka sama toꞋona na ifi keta sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sulia nia manata Ꞌuri, “DiꞋia nau ku sama toꞋona bore aku na mumuduꞋana ifi nia, nai leꞋa naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma kaidaꞋi neꞋe nia sama toꞋona goꞋo ifi sa Jesus, ꞋaliꞋali naꞋa Ꞌabu neꞋe tafangia nia ka langa naꞋa, ma nia ka saiana na nonina nia Ꞌakwa naꞋa faꞋasia na mataꞋinga nia. ");
INSERT INTO kwf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma ana kaidaꞋi neꞋeri goꞋo, sa Jesus nia saiana neꞋe ngasingasiꞋanga nia gura ta ngwae. Ma nia ka abula Ꞌi safitana na fikuꞋa neꞋeri, ma ka lidida ka Ꞌuri, “Sa tai naꞋa niniꞋa sama toꞋona kwau na ifi nau?” ");
INSERT INTO kwf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma na fafarongo nia ki, kira ka olisia kika Ꞌuri, “ꞋOko lisia goꞋo Ꞌamu na ngwaꞋi toꞋa Ꞌoro neꞋe nini kira bekesiꞋo naꞋa. FaꞋuta neꞋe Ꞌoko lidi Ꞌuana fasi ta ngwae nia sama toꞋomu?” ");
INSERT INTO kwf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bore ma sa Jesus ka lia kwailiu fasi Ꞌiri ke lisia sa tai neꞋe nia sasia ru neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma na Ꞌafe neꞋe nia saiana ru neꞋe fuli fuana, ma nia ka leka lebelebe maꞋi Ꞌani maꞋungaꞋa, ma ka bobo uruuru Ꞌi maana Ꞌaena sa Jesus. Ma nia ka faꞋarongoa mamana ana ru neꞋe nia sasiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma sa Jesus ka fata Ꞌuri fuana, “ꞋAfe neꞋe Ꞌae, God nia guraꞋo naꞋa sulia neꞋe Ꞌoko faꞋamamana nau. ꞋOke leka naꞋa Ꞌamu, ma Ꞌoe kosi manata Ꞌabera, ma Ꞌoko Ꞌakwa naꞋa faꞋasia na mataꞋinga Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma kaidaꞋi sa Jesus nia alaꞋa goꞋo Ꞌana Ꞌua, ti ngwae kira ka dao maꞋi faꞋasia na luma sa Jaeras, ma kira ka fata Ꞌuri fuana sa Jaeras, “Kala defo ba Ꞌoe nia mae naꞋa. ꞋOe kosi faꞋa Ꞌabera laꞋu na ngwae faꞋamanata.” ");
INSERT INTO kwf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma sa Jesus kasi Ꞌabera goꞋo sulia ru neꞋe kira saea, ma ka fata naꞋa Ꞌuri fuana sa Jaeras, “NoaꞋa Ꞌoe kosi fitala laꞋu. ꞋOke faꞋamamana nau lala Ꞌamu.” ");
INSERT INTO kwf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma nia kasi alaꞋania ta ngwae ke leka faꞋinia, taꞋifilia goꞋo sa Peter, ma sa James, ma sa John na ngwaefuta nia sa James. ");
INSERT INTO kwf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma kaidaꞋi kira dao Ꞌi luma sa Jaeras, sa Jesus ka rongoa na isiꞋa faꞋinia na angiꞋa ma na oꞋomaeꞋanga nia doe liu. ");
INSERT INTO kwf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma nia ka ruꞋu kwau, ma ka fata Ꞌuri fuada, “FaꞋuta neꞋe kamu angi, ma muka oꞋomae ka Ꞌuri naꞋa? Ngela neꞋe noaꞋa kasi mae, nia maliu goꞋo Ꞌana ne.” ");
INSERT INTO kwf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bore ma, kira ka fiꞋi gaꞋasia lala sa Jesus. Ma nia ka baꞋeda kwau Ꞌi maa, ma ka talaꞋia na maꞋa nia, ma teꞋa ngela neꞋeri, ma na fafarongo nia ki neꞋe kira tua faꞋinia, ma kira ka ruꞋu saena maꞋe luma neꞋe ngela neꞋeri nia teo ana. ");
INSERT INTO kwf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma nia ka dau ana na limana na ngela neꞋeri, ma ka fata Ꞌuri fuana, “Talita kom!” Na fadalana nia Ꞌuri, “Kala defo Ꞌae, nau ku saea fuamu Ꞌoke tataꞋe!” ");
INSERT INTO kwf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma nia ka tataꞋe, ma ka uu, ma ka fali. Na ngela neꞋeri taꞋi akwala ma ro faꞋi ngali goꞋo neꞋe sui fafia futalana. Ma kira ka Ꞌarefo liu ana ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bore ma sa Jesus fata ka luida, fasi Ꞌiri noaꞋa kira kasi faꞋarongoa laꞋu ta ngwae Ꞌani ru neꞋeri. Ma nia ka saea kira ka kwatea fanga fuana na ngela neꞋeri Ꞌiri nia ke Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sa Jesus faꞋinia na fafarongo nia ki, kira faꞋasia na kula neꞋeri, ma kira ka oli Ꞌuana fanoa neꞋe nia doe maꞋi saena Ꞌi Nasaret. ");
INSERT INTO kwf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma ana Sabat, na asoa ana mamaloꞋanga, nia ka faꞋamanata Ꞌi saena na luma fuana foꞋongaꞋa. Ma toꞋa Ꞌoro ki kira rongoa, ma kira ka Ꞌarefo liu. Ma kira ka saefiloda kwailiu ma kika Ꞌuri, “Na ngasingasiꞋanga ana sa tai niniꞋa kwate nia ka faꞋamanata Ꞌania fatalana God Ꞌuri, ma faꞋinia sasilana na faꞋanadaꞋa ki? ");
INSERT INTO kwf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na ngwae neꞋe kulu sai leꞋa goꞋo ana. Nia ngwae saungaꞋi luma niniꞋa. TeꞋa nia ba Ꞌi Mary goꞋo. Ti ngwaefuta ana ba sa James, ma sa Josef, ma sa Judas, ma sa Simon. Ma na ngwaingwaena nia ki kira tua goꞋo Ꞌada Ꞌi neꞋe.” ꞋUnaꞋeri, kira ka Ꞌaila Ꞌani niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma sa Jesus ka fata Ꞌuri fuada, “Na ngwae ana fanoa ki kira saiana kira ke faꞋadoea na profet. Bore ma ngwae ana fanoa nia Ꞌi talana, ma na ngwaefuta nia ki, ꞋafitaꞋi kira ka faꞋadoea.” ");
INSERT INTO kwf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma nia kasi bolo naꞋa faꞋinia sasilana laꞋu faꞋanadaꞋa Ꞌoro ki Ꞌi neꞋeri. Ma nia ka alua na limana fafia bara ngwae mataꞋi ma ka gurada. ");
INSERT INTO kwf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma nia ka Ꞌarefo liu, osiꞋana na ngwae ki noaꞋa kasi faꞋamamana. ꞋUnaꞋeri sa Jesus nia leka ana maꞋe fanoa ki kalikalia Ꞌi neꞋeri, ma ka faꞋamanata na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nia ka ri Ꞌuana na akwala ma ro ngwae ana fafarongo nia ki siana, ma nia ka kwatea naꞋa ngasingasiꞋanga fuada fuana ifulangaꞋilana na ano Ꞌi ru taꞋa ki, ma ka baꞋeda maꞋi taꞋifau, ma ka alu na ro ngwaeꞋa kera ka leka fiku. ");
INSERT INTO kwf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma sa Jesus ka fata totongaꞋi fuada ka Ꞌuri, “NoaꞋa kamu kasi ngalia ta ru fuana lekaꞋa neꞋe, taꞋifilia faꞋi kuba goꞋo neꞋe kamu ke ngalia. Ma noaꞋa kamu kasi ngalia fanga, ma ta ngwaꞋi, ma ta mani. ");
INSERT INTO kwf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kamu ke ruꞋufia na taꞋe butu ki, bore ma kamu kasi ngalia laꞋu ruana Ꞌaba toro rengorengo. ");
INSERT INTO kwf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma kaidaꞋi ta ngwae nia kwalo kamu, kamu ke tua faꞋinia, leleka ka dao ana kaidaꞋi kamu ke leka faꞋasia na fanoa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma diꞋia kamu dao ana na fanoa, ma na ngwae ki Ꞌi neꞋeri noaꞋa kasi kwalo kamu, ma kira kasi oga goꞋo rongolamuꞋa, kamu ka leka amuꞋa faꞋasida. Ma kamu ke tafula fulafulana ano faꞋasia na ꞋaemuꞋa Ꞌuana na faꞋabasuꞋanga naꞋa fuada neꞋe God ke baꞋa matalangaꞋi kira, duꞋungana kira Ꞌaila Ꞌania rongolana fatalana God.” ");
INSERT INTO kwf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma kira ka leka, ma kira ka fulangaꞋinia fuana ngwae ki Ꞌiri kike rokisi faꞋasia na abula taꞋangaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma kira ka ifulani naꞋa ano Ꞌi ru taꞋa Ꞌoro ki, ma kira ka ngwaia naꞋa ngwae mataꞋi Ꞌoro ki, ma kira ka gurada laꞋu goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ꞋIu, sa Herod na tatalafaꞋa nia rongoa ru neꞋe ki sulia sa Jesus neꞋe nia faꞋamanata ma ka gura ngwae ki. Ma satana sa Jesus ka talofia naꞋa fanoa ki taꞋifau. Ma ti ngwae kira ka Ꞌuri, “Sa John ngwae ni siuabu nia mauri laꞋu! Nia niniꞋa ke sasia laꞋu na ru ni ꞋarefoꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma ti ngwae laꞋu kira ka fata Ꞌuri, “NiaꞋa sa Elaeja.” Ma ti ngwae kira ka fata Ꞌuri, “NiaꞋa ta profet, diꞋia na profet ba Ꞌi naꞋo ki maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ana kaidaꞋi sa Herod nia rongoa ru neꞋeri ki neꞋe na ngwae ki fata ꞋunaꞋeri sulia sa Jesus, nia ka fata Ꞌuri, “Sa John na ngwae ba nau ku kwatea fuana siki musilana gwauna, nia tataꞋe laꞋu faꞋasia na maeꞋa niniꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Sa Herod nia korea logo Ꞌi Herodias, na Ꞌafe ngwaefuta nia sa Filip. Ma sa John ka fata fata Ꞌuri fuana sa Herod, “Na taki God nia luia Ꞌoe kosi korea Ꞌafe ngwaefuta Ꞌoe.” ꞋUnaꞋeri, liana Ꞌi Herodias ka taꞋa liu naꞋa fuana sa John, ma nia ka oga saungilana, bore ma ka ꞋafitaꞋi liu fuana, duꞋungana sa Herod nia saiana sa John nia na ngwae saga, ma na ngwae nia abu. Sa Herod nia maꞋungia sa John, ma nia ka gonia sa John. Sa Herod talana neꞋe nia udua ngwae ki fuana daulana sa John, ma kira ka alua Ꞌi saena lokafo faꞋasia Ꞌi Herodias. ꞋIu, sa Herod nia oga liua naꞋa rongolana sa John, bore Ꞌana nia ka manata Ꞌabera kaidaꞋi neꞋe nia rongoa. ");
INSERT INTO kwf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","GoꞋo ma Ꞌi Herodias ka dao toꞋona taꞋi kaidaꞋi leꞋa nia fuana saungilana sa John. Ana faꞋi asoa neꞋe sa Herod nia faꞋadoea asoa neꞋe nia futa ana, nia ka saungaꞋinia taꞋi fangaꞋa fuana na ngwae doe nia ki, ma na ngwae doe nia ki fuana fuꞋanga, ma na faꞋinaꞋonaꞋo ki neꞋe kira tua Ꞌi saena abaꞋi kula Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma kaidaꞋi neꞋe, sariꞋi Ꞌi Herodias nia ruꞋu maꞋi ma ka ngwaꞋe, sa Herod faꞋinia na ngwae nia ki neꞋe kira fanga faꞋinia, kika saeleꞋa liu faꞋinia. Ma sa Herod ka fata Ꞌuri fuana na sariꞋi neꞋeri, “ꞋOke gani nau maꞋi Ꞌuana ta ru neꞋe Ꞌoko oga, nau kui kwatea fuamu.” ");
INSERT INTO kwf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma nia ka fata alangaꞋi ana alafuꞋa fuana ka Ꞌuri, “Ta tae neꞋe Ꞌoko gania aku, nau kui kwatea fuamu, sui bore Ꞌana ta bali ana na ꞋinotoꞋanga nau.” ");
INSERT INTO kwf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma na sariꞋi neꞋeri ka ruꞋu kwau Ꞌi maa ka leka naꞋa siana teꞋa nia, ma ka saefilo Ꞌuri, “Ta tae neꞋe nai baꞋa gania?” Ma teꞋa nia ka olisia ka Ꞌuri, “Na gwauna sa John ngwae ni siuabu.” ");
INSERT INTO kwf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma na sariꞋi neꞋeri ka oli ꞋaliꞋali siana sa Herod, ma ka gani ka Ꞌuri, “Nau ku oga Ꞌoke kwatea maꞋi na gwauna sa John Siuabu fuaku Ꞌi fafona ta taꞋe ru ana kaidaꞋi neꞋe naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma sa Herod ka kwaimanatai liu duꞋungana ru neꞋeri. Sui bore Ꞌana, sulia na fata alangaꞋinga neꞋe nia sasia Ꞌi naꞋona na ngwae ki neꞋe kira fanga faꞋinia, nia kasi luia naꞋa faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma nia ka kwatea taꞋi ngwae ni ofo fuana ngalilana maꞋi na gwauna sa John. Ma na ngwae neꞋeri ka leka Ꞌi saena na lokafo, ma ka siki muusia na luana sa John, ");
INSERT INTO kwf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka ngalia maꞋi na gwauna Ꞌi fafona na taꞋe ru dakodakoꞋa, ma ka kwatea fuana sariꞋi neꞋeri, ma nia ka kwatea fuana teꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma kaidaꞋi neꞋe fafarongo sa John ki kira rongoa ru neꞋeri, kira leka maꞋi, ma kira ka ngalia naꞋa nonina, ma kira ka kwaiatoa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na ngwae lifurongo ki kira oli naꞋa maꞋi, ma kira ka fiku taꞋifau maꞋi siana sa Jesus, ma kira ka faꞋarongoa Ꞌani ru neꞋe kira sasiꞋi, ma kira faꞋamanata suliꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sa Jesus faꞋinia na fafarongo nia ki, kira Ꞌabera liu, sulia neꞋe ngwae Ꞌoro ki kira dao faꞋi oli ana kula neꞋe kira tua ana. Ma sa Jesus faꞋinia na fafarongo nia ki, kira noaꞋa kasi toꞋo naꞋa ana ta kaidaꞋi fuana fangaꞋa bore. Ma sa Jesus ka fata Ꞌuri fuada, “Mulu leka maꞋi faꞋinau Ꞌuana ta kula buringaꞋi, fasi Ꞌiri kuke mamalo basi Ꞌakulu.” ");
INSERT INTO kwf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma kira ka leka taꞋifilida Ꞌania baru Ꞌuana kula neꞋe aroaro. ");
INSERT INTO kwf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka ꞋunaꞋeri bore Ꞌana, na ngwae Ꞌoro ki faꞋasia na fanoa ki taꞋifau kira lia saiada, ma kira ka lalili Ꞌi naꞋoda, ma kira ka eta dao ada Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma kaidaꞋi sa Jesus nia koso faꞋasia na baru, nia ka lisia na fikuꞋa doe neꞋeri, ma nia ka kwaimanatai liu ada, sulia kira diꞋia naꞋa sipsip ki neꞋe noaꞋa ta ngwae fuana liaꞋa sulida. Ma nia ka faꞋamanata kira Ꞌani ru Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma kaidaꞋi neꞋe na sina nia ego folo naꞋa, fafarongo nia ki kira ka leka maꞋi siana, ma kira ka fata Ꞌuri, “Kula neꞋe noaꞋa ta ngwae Ꞌiri tua ana, ma na sina ka ego folo naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ꞋOke baꞋea na ngwaꞋi toꞋa neꞋe ki kira ka leka naꞋa Ꞌada, Ꞌiri kira ka leka ana maꞋe fanoa neꞋe kalikalida ki, Ꞌiri kike foli fanga.” ");
INSERT INTO kwf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bore ma nia olisida ka Ꞌuri, “Kaumulu, muke kwatea fanga fuada.” Ma kira ka saefilo Ꞌuri ana, “ꞋUri ma Ꞌoko oga kaimili ke kwatea maꞋi mani Ꞌoro ki fuana folilana beret Ꞌiri ke bolo faꞋinia sarelana fikuꞋa neꞋe?” ");
INSERT INTO kwf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma sa Jesus ka lidi kira ka fata Ꞌuri, “Ta fita afu beret neꞋe kamu toꞋo ana? Leka muke lia maꞋi Ꞌuani.” Ma kaidaꞋi kira dao toꞋona, kira ka fata Ꞌuri, “Lima afu beret ki goꞋo faꞋinia na ro gwaꞋi iꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ꞋUnaꞋeri sa Jesus ka saea fuana fafarongo nia ki Ꞌiri kika saea fuana ngwae ki kira ke tua Ꞌi ano Ꞌani gwaꞋi tuaꞋa ki Ꞌi fafona na karasi faka marako. ");
INSERT INTO kwf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma kira ka tua Ꞌi ano Ꞌani talangaꞋi ngwae Ꞌanga, ma ti gwaꞋi tuaꞋa na lima akwala ngwaeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma sa Jesus ka ngalia na lima afu beret neꞋeri ki ma na ro gwaꞋi iꞋa neꞋeri ki, ma ka lia ꞋalaꞋa Ꞌuana Ꞌi langi, ma ka baꞋatafea God. Ma nia ka ngiia afu beret neꞋe ki, ma ka kwatea fuana fafarongo nia ki, fasi Ꞌiri kira ka daroꞋia fuana ngwaꞋi toꞋa neꞋeri. Ma nia ka daroꞋia logo na ro gwaꞋi iꞋa neꞋeri ki fuada. ");
INSERT INTO kwf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma na ngwae Ꞌoro neꞋeri ki kira ka fanga, ma kira ka abusu taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","GoꞋo, na fafarongo nia ki kira ka gonia naꞋa orengana na beret ma na iꞋa neꞋeri ki, ma kira ka faꞋafungua taꞋi akwala ma ro kokofi ki. ");
INSERT INTO kwf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na lima toꞋoni ngwae ki neꞋe kira fanga. ");
INSERT INTO kwf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma Ꞌi buri Ꞌana ru neꞋeri, sa Jesus nia asungaꞋinia na fafarongo nia ki kira ka etaeta Ꞌuana ta bali ana Ꞌosi neꞋeri saena na baru Ꞌuana fanoa Ꞌi Betsaeda. Ma nia ka tua buri fasi Ꞌiri ke saea fuana na fikuꞋa neꞋeri kira ka leka naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma Ꞌi buri Ꞌana neꞋe nia olioli ana ngwae Ꞌoro neꞋeri ki, nia ka leka Ꞌi gwauna taꞋi faꞋi ua fasi ke foꞋo Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma kaidaꞋi nia talaꞋae ka rodo naꞋa maꞋi, na baru baera nia naꞋa saena tofongana Ꞌosi, ma sa Jesus tua goꞋo Ꞌana Ꞌua taꞋifilia Ꞌi sara. ");
INSERT INTO kwf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma nia ka lisia na fafarongo nia ki, kira laga ulafu liu naꞋa ana falutaꞋanga, duꞋungana kira naꞋofia naꞋa iru. Ma ana agi rodo Ꞌofodangi, sa Jesus ka leka Ꞌi fafona na kafo, ma ka leka maꞋi fuada. Ma nia ka karangi liufida naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma ana kaidaꞋi kira lisia neꞋe nia leka Ꞌi fafona na kafo, kira ka fia fasi nia na anoano ru. Ma kira ka fai araarai, ");
INSERT INTO kwf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","duꞋungana kira maꞋu liu naꞋa, ana kaidaꞋi kira lisia nia leka fafona kafo. Ma sa Jesus nia ka ꞋaliꞋali ma ka fata kwau fuada ka Ꞌuri, “NauꞋa goꞋo niniꞋa! NoaꞋa kamu kasi maꞋu laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ꞋUnaꞋeri goꞋo, nia ka taꞋe Ꞌi saena na baru faꞋinida, ma na iru ka aroaro naꞋa. Ma kira ka Ꞌarefo liu, ");
INSERT INTO kwf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","duꞋungana noaꞋa kira kasi saiana na malingaꞋilana ngasingasiꞋanga sa Jesus toꞋo ana fuana sarelana lima toꞋoni ngwae baera ki Ꞌani lima afu beret ki goꞋo. Sulia manata Ꞌanga kira ki dole liu fuana malingaꞋilana na ru neꞋe kira lisia. ");
INSERT INTO kwf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kira toꞋofolo ana Ꞌosi neꞋeri, ma kira ka koso ana bali fanoa Ꞌi Genesaret, ma kira ka gwalua na baru Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma kaidaꞋi kira faꞋasia na baru, na ngwae Ꞌi neꞋeri ki, kira ꞋaliꞋali kira ka lia saiana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma na ngwae ki kira ka lalili saena Ꞌafutana bali fanoa neꞋeri, ma kira ka ngalia maꞋi na ngwae mataꞋi ki Ꞌi fafona na tatafe ki Ꞌuana kula ki neꞋe kira rongoa sa Jesus nia tua ana. ");
INSERT INTO kwf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma kula ki taꞋifau neꞋe sa Jesus nia leka ana, na ngwae ki kira ngalia maꞋi na ngwae mataꞋi ki Ꞌuana foli usiꞋa ki, ma kira ka gania sa Jesus fuana na ngwae mataꞋi ki Ꞌiri kira ka sama toꞋona namunamuna ifi keta nia. Ma na ngwae ki taꞋifau neꞋe kira sama toꞋona, ma kira ka Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Farasi ki ma ti ngwae faꞋamanata ana na taki ki, kira leka maꞋi faꞋasia Ꞌi Jerusalem, ma kira ka fiku kalia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma kira ka lisia ti ngwae ana fafarongo nia ki noaꞋa kasi taufia goꞋo limada Ꞌi naꞋo, ma kira fiꞋi fanga. NoaꞋa kira kasi taufia limada diꞋia na falafala neꞋe Farasi ki kira saea fuana na ngwaꞋi toꞋa Jiu ki kira ke sasi sulia. ");
INSERT INTO kwf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aia, na Jiu ki ma tasa naꞋa na Farasi ki logo, kira sasi sulia falafala neꞋe koꞋo bora kira ki kira faꞋamanata nama maꞋi Ꞌania. Nia ꞋafitaꞋi kira ka fanga diꞋia noaꞋa kira kasi taufia limada diꞋia na falafala ana tau limaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma kaidaꞋi kira oli maꞋi faꞋasia na usiꞋa, nia ꞋafitaꞋi kira kasi fanga, diꞋia noaꞋa kira kasi tau lima basi sulia na falafala kira naꞋa. ꞋUnaꞋeri kira ka roꞋo sulia na falafala Ꞌoro kira ki, diꞋia na taufilana titiu ki, ma na faꞋi tini ki, ma na dako ki. ");
INSERT INTO kwf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ꞋUnaꞋeri na Farasi ki, ma na ngwae faꞋamanata ana taki ki, kira ka lidia sa Jesus ma kira ka Ꞌuri, “FaꞋuta neꞋe fafarongo Ꞌoe ki noaꞋa kasi roꞋosulia na faꞋamanataꞋanga neꞋe koꞋo bora kia ki kira alua naꞋa maꞋi fuaka, osiꞋana noaꞋa kira kasi taufia goꞋo na limada Ꞌi naꞋo basi, ma kira fiꞋi fanga?” ");
INSERT INTO kwf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma nia ka olisida ma ka Ꞌuri, “Sa Aesea nia fata mamana kaidaꞋi ba nia alaꞋa suli kamu. KamuꞋa na ngwae ꞋosoꞋoso ki, diꞋia ba nia keresia ka Ꞌuri, ‘God nia saea, na ngwaꞋi toꞋa neꞋe ki, kira faꞋadoe nau goꞋo Ꞌada Ꞌani alaꞋanga kira ki, bore ma na manatada nia tau liu faꞋasi nau. ");
INSERT INTO kwf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kira foꞋosi nau ꞋoꞋo goꞋo Ꞌada, duꞋungana kira faꞋamanata goꞋo Ꞌada sulia taki kira ki talada, ma kira ka saea fasi taki God ki naꞋa neꞋeriꞋa!’ ");
INSERT INTO kwf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Kamu aburongo ana taki God ki, ma muka roꞋosulia amuꞋa lala na faꞋamanataꞋanga na ngwae ki.” ");
INSERT INTO kwf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma sa Jesus ka fata laꞋu Ꞌuri fuada, “Kamu sai liu naꞋa ana ilangaꞋilana ma rokisilana taki God ki, ma muka roꞋosulia lala amuꞋa sulia na falafala kamu ki talamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sulia sa Moses ba nia fata ka Ꞌuri, ‘ꞋOke faꞋadoea na maꞋa Ꞌoe, ma na teꞋa Ꞌoe.’ Ma ‘DiꞋia sa tai neꞋe nia taofia maꞋa nia nama teꞋa nia, kira ke saungia ka mae.’ ");
INSERT INTO kwf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bore ma, kamu faꞋamanata rora Ꞌuri, diꞋia ta ngwae nia toꞋo ana ti ru neꞋe nia saiana ke Ꞌafia Ꞌani maꞋa nia nama teꞋa nia, ma ka fata lala Ꞌuri, ‘Nai baꞋa kwatea naꞋa ru baera ki fuana God.’ ");
INSERT INTO kwf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kamu saea, nia leꞋa goꞋo Ꞌana fuana neꞋe nia noaꞋa kasi Ꞌafia naꞋa maꞋa nia ma na teꞋa nia Ꞌani ru baera ki ba nia eta fataꞋa Ꞌani fuana God. ");
INSERT INTO kwf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma diꞋia nia ꞋunaꞋeri, na faꞋamanataꞋanga neꞋe kamu alua, nia ka kware teꞋeteꞋe naꞋa ana fatalana God. Ma ru Ꞌoro taꞋa ꞋunaꞋeri ki neꞋe kamu sasiꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ꞋUnaꞋeri sa Jesus nia ka ri laꞋu maꞋi Ꞌuana na fikuꞋa doe neꞋeri siana, ma ka fata Ꞌuri fuada, “Mulu fafarongo maꞋi fuaku, ma muke saiana. ");
INSERT INTO kwf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","NoaꞋa ta ru neꞋe ta ngwae nia ke Ꞌania neꞋe nia kwatea na suaꞋa fuana. Na ru neꞋe sasia taꞋangaꞋa ki, nia Ꞌita maꞋi faꞋasia na lia na ngwae lala, nia neꞋe ka kwatea ngwae ka sua.” ");
INSERT INTO kwf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma kaidaꞋi sa Jesus nia faꞋasia naꞋa fikuꞋa neꞋeri, nia ka ruꞋu saena luma, ma na fafarongo nia ki kira ka lidia fasi Ꞌiri nia ka fada na alaꞋanga neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma sa Jesus ka fata Ꞌuri fuada, “ꞋUri ma noaꞋa kaumulu kasi sai goꞋo ana ru neꞋe ki niniꞋa? Na ru neꞋe ngwae nia Ꞌania noaꞋa kasi faꞋasua na ngwae Ꞌi naꞋona God, ");
INSERT INTO kwf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","duꞋungana fanga noaꞋa nia kasi leka Ꞌi saena na lia na ngwae. Nia leka goꞋo Ꞌana saena na ogana, ma ka sakatafa logo Ꞌana Ꞌi maa faꞋasia na nonina.” Ana alaꞋanga sa Jesus naꞋa neꞋe, nia saea na fanga ki taꞋifau, nia leꞋa goꞋo Ꞌana fuana ꞋanilaniꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma sa Jesus ka fata laꞋu Ꞌuri, “Ta ru neꞋe ta ngwae nia fulia ka taꞋa ma ka saea ka rora, nia neꞋe faꞋasua Ꞌi naꞋona God. ");
INSERT INTO kwf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","OsiꞋana na manataꞋanga taꞋa ki nia saka maꞋi faꞋasia saena na liana ngwae, nia ka sasia ru taꞋa ki, ma nia ka bili, ma nia ka sau ngwae, ");
INSERT INTO kwf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma nia ka kakabara, ma nia ka guguta, ma nia ka sasia ru taꞋa Ꞌoro ki, ma ka sokea na ngwae ki, ma ka kwaimamagolai, ma ka alaꞋa ꞋosoꞋoso Ꞌana sulia ta ngwae, ma nia ka manata lafua talana, ma nia ka boleboleꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ma duꞋungana ru Ꞌoro taꞋa neꞋeri ki taꞋifau nia ruꞋu maꞋi faꞋasia na manatalana, nia ka faꞋasua na ngwae Ꞌi naꞋona God.” ");
INSERT INTO kwf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui goꞋo, sa Jesus ka leka naꞋa faꞋasia na kula neꞋeri, ma ka leka Ꞌuana na bali fanoa Ꞌi Taea. Ma nia ka ruꞋu Ꞌi saena taꞋi luma, sulia noaꞋa nia kasi oga ta ngwae ke saiana neꞋe nia tua Ꞌi neꞋeri, sui bore Ꞌana nia ꞋafitaꞋi fuana nia ka ago. ");
INSERT INTO kwf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma taꞋi kini ka rongo sulia neꞋe sa Jesus nia dao, ma nia ka leka ꞋaliꞋali maꞋi, ma ka bobo uruuru Ꞌi maana Ꞌaena sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma na kini neꞋeri, nia neꞋe kini kwaita faꞋasia Ꞌi Fonisia saena tuaꞋa Ꞌi Siria, ma nia noaꞋa laꞋu kini Jiu, ma na sariꞋi nia na ano Ꞌi ru taꞋa nia ruꞋufia. ꞋUnaꞋeri, nia ka amasia sa Jesus fasi Ꞌiri ke ifulani na ano Ꞌi ru taꞋa neꞋeri faꞋasia na sariꞋi nia. ");
INSERT INTO kwf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma sa Jesus ka fata sulia na Jiu ki neꞋe diꞋia na ngela ki ka Ꞌuri, “Mike sarea basi amiꞋa na ngela ki Ꞌi naꞋo. NoaꞋa nia kasi leꞋa fuamiꞋa ka eta Ꞌui Ꞌania basi na fanga ngela ki fuana na kui ki.” ");
INSERT INTO kwf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma na kini neꞋeri nia olisia ma ka Ꞌuri, “Aofia Ꞌae, na kui ki bore, kira saiana kira ka Ꞌania logo orengana fanga neꞋe nia Ꞌasia Ꞌi olofana tatafe ni fangaꞋa na ngela ki.” ");
INSERT INTO kwf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sui sa Jesus ka fata Ꞌuri fuana, “ꞋOke oli Ꞌamu Ꞌi fanoa Ꞌoe. Na ano Ꞌi ru taꞋa baera, nia leka naꞋa faꞋasia na sariꞋi Ꞌoe. OsiꞋana olisiꞋanga neꞋeri nia faꞋataꞋinia Ꞌoko faꞋamamana.” ");
INSERT INTO kwf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma nia ka oli Ꞌi fanoa, ma ka lisia na sariꞋi ba nia maliu goꞋo Ꞌana Ꞌi saena na ꞋifitaꞋi. Ma na ano Ꞌi ru taꞋa baera ka leka mamana naꞋa faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui sa Jesus nia faꞋasia naꞋa bali fanoa Ꞌi Taea, ma ka daofaꞋi liu faꞋasia Ꞌi Saedon, ma bali fanoa Ꞌi Dekapolis, ma ka koso naꞋa kwau fafona na Ꞌosi Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ngwae ki Ꞌi neꞋeri, kira ka ngalia maꞋi taꞋi ngwae neꞋe alingana bani ma na kwakwana ka kulu siana sa Jesus, ma kira ka amasia sa Jesus fasi Ꞌiri nia ke alua na limana Ꞌi fafona na ngwae neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma sa Jesus ka talaꞋia Ꞌuana taꞋi kula taꞋifilidaroꞋo faꞋasia na fikuꞋa neꞋeri, ma nia ka ruꞋungaꞋinia na ꞋuꞋuna Ꞌi saena na alingana ngwae neꞋeri. Ma nia ka ngisu ana na ꞋuꞋuna, ma ka sama toꞋona na meana na ngwae neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","GoꞋo, nia ka lia ꞋalaꞋa Ꞌuana Ꞌi langi, ma ka mango doe, ma ka fata Ꞌuri fuana Ꞌani fatalana, “Efata!” na fadalana neꞋe Ꞌuri, “ꞋIfi naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma ana kaidaꞋi neꞋeri, na alingana na ngwae neꞋeri ka Ꞌifi, ma nia ka rongo naꞋa, ma na kwakwana ka sasala naꞋa, ma nia ka talaꞋae ka fata madakola naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ꞋUnaꞋeri, sa Jesus ka luia na ngwae ki noaꞋa kasi faꞋarongoa laꞋu ti ngwae. Sui bore Ꞌana nia ka lui totongaꞋi ana, na ngwae ki kira ka donga alaꞋa sulia sa Jesus neꞋe nia gura na ngwae neꞋeri ka leleka naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma na ngwae ki neꞋe kira rongoa, kira ka Ꞌarefo liu naꞋa, ma kira ka fata Ꞌuri, “Reala! Nia sasia ru ki taꞋifau ka leꞋa liu! Nia saungaꞋinia na ngwae neꞋe alingana bani ma ka rongo naꞋa, ma na ngwae neꞋe kwakwana nia nonoto bore, ka fata naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","NoaꞋa kasi tau goꞋo Ꞌi buri Ꞌana ru neꞋeri ki, taꞋi fikuꞋa doe ka fiku maꞋi. Ma kaidaꞋi neꞋeri noaꞋa naꞋa ta fanga ada, sa Jesus ka saea maꞋi fafarongo nia ki, ma ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nau ku kwaimanatai naꞋa ana ngwaꞋi toꞋa neꞋe, sulia kira tua faꞋinau sulia uulu asoa ki, ma ka noaꞋa naꞋa ta fanga ada taꞋena. ");
INSERT INTO kwf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma diꞋia niniꞋa kira fiolo, ma nau ku olitaꞋinida Ꞌi fanoa, kira ke baꞋa Ꞌasida sulia tala, sulia ta bali ada neꞋe fanoa kira ki tua tau.” ");
INSERT INTO kwf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma na fafarongo nia ki kira ka saefilo Ꞌuri, “ꞋI faꞋi neꞋe kuke dao toꞋona ta fanga neꞋe ke bolo faꞋinia na sarelana ngwaꞋi toꞋa Ꞌoro Ꞌuri ki saena na abaꞋi kula kwasi neꞋe kasi bolo faꞋinia ta ngwae ka tua ana Ꞌuri?” ");
INSERT INTO kwf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma sa Jesus ka lidida ma ka Ꞌuri, “Ta fita afu beret neꞋe kamu toꞋo ana?” Ma kira ka olisia kika Ꞌuri, “Fiu afu beret ki.” ");
INSERT INTO kwf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma sa Jesus ka saea fuana na fikuꞋa neꞋeri kira ka tua Ꞌi ano. GoꞋo, nia ka ngalia na fiu afu beret neꞋeri ki, ma ka baꞋatafea God, sui ka ngiia ma ka kwatea fuana fafarongo nia ki, ma kira ka daroꞋia ana na fikuꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma kira toꞋo logo ana bara gwaꞋi iꞋa tiꞋitiꞋi. Ma sa Jesus nia ka kwatea logo baꞋatafea fuana God, ma ka saea fuana fafarongo nia ki kira ka daroꞋia logo ana na ngwaꞋi toꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma kira ka fanga leleka kira ka abusu taꞋifau. Ma Ꞌi buri, na fafarongo nia ki kira ka gonia naꞋa ngisingisi fanga neꞋe nia ore Ꞌi saena fiu kokofi ki leleka ka fungu. ");
INSERT INTO kwf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma na fikuꞋa neꞋeri, nia bolo faꞋinia na fai toꞋoni ngwae ki. Sui sa Jesus ka olitaꞋinida naꞋa Ꞌuana fanoa kira, ");
INSERT INTO kwf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma niaꞋa faꞋinia na fafarongo nia ki, kira ꞋaliꞋali kira ka raꞋe Ꞌi saena gwaꞋi baru, ma kira ka leka Ꞌuana na bali fanoa Ꞌi Dalmanuta. ");
INSERT INTO kwf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma ti Farasi kira leka maꞋi, ma kira ka olisuꞋusuꞋu faꞋinia sa Jesus, ma kira oga fasi Ꞌiri kike ilitoꞋona. Nia neꞋe kira ka gania fasi Ꞌiri nia ke fulia ta faꞋanadaꞋa, fasi Ꞌiri ke faꞋataꞋinia mamanaꞋanga God neꞋe kwate maꞋi niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ꞋUnaꞋeri sa Jesus nia ka mango doe, ma ka fata Ꞌuri, “FaꞋuta neꞋe ngwae ki ana talaꞋi ngwae neꞋe kira ka gania faꞋanadaꞋa ki re? Nau ku saea na ru mamana fuamuꞋa, nau noaꞋa kusi faꞋataꞋinia goꞋo ta faꞋanadaꞋa fuana na talaꞋi ngwae neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma nia ka faꞋasida, ma ka raꞋe logo Ꞌana Ꞌi saena gwaꞋi baru, ma ka toꞋofolo Ꞌuana ta bali Ꞌosi. ");
INSERT INTO kwf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","KaidaꞋi kira saena Ꞌosi naꞋa, na fafarongo nia ki kira manata bura ana ngalilana maꞋi ti afu beret, bore ma taꞋi afu beret goꞋo neꞋe kira toꞋo ana saena na gwaꞋi baru. ");
INSERT INTO kwf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma sa Jesus ka faꞋabasuda ma ka Ꞌuri, “Kamu ke lia leꞋa suli kamu faꞋasia na isi fuana beret ana Farasi ki ma sa Herod logo.” ");
INSERT INTO kwf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma kira ka alaꞋa Ꞌi safitada kwailiu, ma kira ka Ꞌuri, “Nia fata ꞋunaꞋeri sulia neꞋe noaꞋa kulu Ꞌisi ngalia maꞋi ta afu beret.” ");
INSERT INTO kwf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma kaidaꞋi sa Jesus nia saiana neꞋe kira kina neꞋe nia fata sulia na faꞋamanataꞋanga taꞋa Farasi ki ma sa Herod, nia ka fata Ꞌuri fuada, “FaꞋuta neꞋe kamu ka alaꞋa sulia neꞋe noaꞋa kamu Ꞌisi ngalia maꞋi ti afu beret? NoaꞋa kamu Ꞌisi malingaꞋi ru Ꞌua ana manatai ngwae saena na ru nini nau ku saea fuamuꞋa? Nau ku lisia manatamuꞋa dole liu fuana kamu ka faꞋamamana. ");
INSERT INTO kwf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kamu lisia ma muka rongoa na ru Ꞌoro nau ku sasiꞋi ki, bore ma noaꞋa kaumulu kasi malingaꞋiniꞋi goꞋo. NoaꞋa kamu Ꞌisi manata goꞋo toꞋona, ");
INSERT INTO kwf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kaidaꞋi ba nau ku ngiia na lima afu beret baera ki fuana na lima toꞋoni ngwane baera ki? Ma ta fita kokofi ba kamu gonia naꞋa ngisingisi fanga baera Ꞌi saena leleka ka fungu?” Ma kira ka olisia kira ka Ꞌuri, “Na taꞋi akwala ma ro kokofi.” ");
INSERT INTO kwf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma sa Jesus nia lidi laꞋu ka Ꞌuri, “Ma kaidaꞋi ba nau ku ngiia fiu afu beret ki fuana fai toꞋoni ngwae ki, na fita kokofi ki ba kamu gonia ngisingisina fanga Ꞌi saena leka ka fungu?” Ma kira ka olisia ma kira ka Ꞌuri, “Na fiu kokofi ki.” ");
INSERT INTO kwf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma nia ka saefilo Ꞌuri ada, “FaꞋuta neꞋe noaꞋa kamu kasi saiana tae neꞋe nau ku fata sulia?” ");
INSERT INTO kwf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kira dao ana na fanoa Ꞌi Betsaeda, ma ngwae ki kira ka ngali maꞋi taꞋi ngwae neꞋe maana nia rodo, ma kira ka gania sa Jesus fasi Ꞌiri nia ke sama toꞋona. ");
INSERT INTO kwf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma sa Jesus ka dau Ꞌi limana na ngwae neꞋeri, ma ka talaꞋia Ꞌuana Ꞌi maa faꞋasia na fanoa neꞋeri. Ma sa Jesus ka ngisu Ꞌi saena na maana na ngwae neꞋeri, ma nia ka alua na limana fafia. Sui, nia lidia ka Ꞌuri, “ꞋOko lisia ta ru?” ");
INSERT INTO kwf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","GoꞋo, na ngwae baera nia ka lia ꞋalaꞋa, ma ka fata Ꞌuri, “Nau ku lisia na ngwae ki, kira diꞋia Ꞌai ki, ma kira fali.” ");
INSERT INTO kwf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ꞋUnaꞋeri sa Jesus ka alua laꞋu na limana fafia na maana na ngwae neꞋeri. Ma na ngwae neꞋeri ka lia mamana naꞋa, ma ka lia madako naꞋa ana ru ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma sa Jesus ka baꞋea naꞋa Ꞌuana na luma nia, ma ka fata Ꞌuri fuana, “NoaꞋa Ꞌoe kosi leka Ꞌua Ꞌuana fanoa neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sui sa Jesus ma na fafarongo nia ki, kira ka leka Ꞌuana fanoa ki kalikalia na fanoa Ꞌi Sesarea Filipae. Ma ana kaidaꞋi kira leka Ꞌada, nia ka lidia fafarongo nia ki ka Ꞌuri, “ꞋUri ma ngwae ki kira sae nau Ꞌani sa tai niniꞋa re?” ");
INSERT INTO kwf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma kira ka olisia kira ka Ꞌuri, “Ti ngwae ki kira saea ꞋaeꞋo Ꞌania sa John ngwae ni siuabu neꞋe nia mauri laꞋu, ma ti ngwae kira ka saea ꞋaeꞋo Ꞌania sa Elaeja neꞋe nia mauri laꞋu, ma ti ngwae laꞋu kira ka saea ꞋaeꞋo Ꞌania ta ngwae ana profet baera ki neꞋe nia mauri laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma sa Jesus lidida laꞋu ka Ꞌuri, “Ma kamuꞋa, kamu sae nau mo Ꞌani sa tai?” Ma sa Peter ka olisia ma ka Ꞌuri, “ꞋAeꞋo na Christ, ngwae God nia filia fuana Ꞌafilana ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma sa Jesus ka fata totongaꞋi fuada ka Ꞌuri, “NoaꞋa kamu kasi faꞋarongo laꞋu Ꞌani nau fuana ta ngwae.” ");
INSERT INTO kwf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma sa Jesus ka talaꞋae fuana faꞋamanatalana fafarongo nia ki ka Ꞌuri, “NauꞋa, na Ngela Ngwae, nai baꞋa nonifii ana ru Ꞌoro ki. Ma na faꞋinaꞋonaꞋo ki, ma na fata abu doe ki, ma na ngwae faꞋamanata ana na taki ki, kike baꞋa ilangaꞋi nau. Ma kike baꞋa saungi nau, ma ana uula faꞋi asoa, nau kui tataꞋe faꞋasia maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma nia ka fata madako sulia ru neꞋeri. Ma sa Peter ka talaꞋia tiꞋitiꞋi kwau, ma ka balufia. ");
INSERT INTO kwf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bore ma sa Jesus nia abula, ma ka lia fuana fafarongo nia ki, ma ka balufia sa Peter ka Ꞌuri, “Saetan leka tau kwau fasi nau kwa. Na manataꞋanga Ꞌoe ki neꞋe manataꞋanga ngwae ki goꞋo, nia noaꞋa laꞋu na manataꞋanga God.” ");
INSERT INTO kwf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","GoꞋo ꞋunaꞋeri, sa Jesus ka saea maꞋi na fikuꞋa neꞋeri ma na fafarongo nia ki siana, ma ka fata Ꞌuri, “Sa tai bore Ꞌana neꞋe oga ke donga nau, noaꞋa nia kasi manata Ꞌabera sulia ru nia ogaꞋi ki goꞋo Ꞌana talana. Nia ke maꞋudi fuana dongalaku, sui bore Ꞌana kaidaꞋi nia ke nonifii, ma ke mae ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa tai bore Ꞌana neꞋe Ꞌaila kasi donga nau, duꞋungana nia oga ke sasi Ꞌana sulia kwaiogaiꞋanga nia ki talana, nia ke baꞋa talafia na mauriꞋa firi. Bore ma diꞋia sa tai bore Ꞌana neꞋe ke mae fuaku ma fuana na FaꞋarongoꞋa LeꞋa neꞋe, nia ka toꞋo ana mauriꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","DiꞋia neꞋe na ngwae ka toꞋo ana ru ki taꞋifau saena magalia, ma nia mae, ma nia tua tau faꞋasia God, ru neꞋeri kasi fulia goꞋo ta leꞋangaꞋa fuana. ");
INSERT INTO kwf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","NoaꞋa ta ngwae kasi totolia folilana na mauri firi Ꞌani ta mani. ");
INSERT INTO kwf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma diꞋia ta ngwae nia Ꞌeke Ꞌani nau faꞋinia fatalaku Ꞌi saena asoa taꞋa ki, neꞋe ngwae ki noaꞋa kasi foꞋosia God, Ꞌirai ana kaidaꞋi nau kui dao maꞋi faꞋinia na ngwasinasinaꞋanga MaꞋa nau ma na Ꞌainsel abu ki, NauꞋa, na Ngela Ngwae, nai baꞋa Ꞌeke logo Ꞌania.” ");
INSERT INTO kwf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","GoꞋo sa Jesus ka fata laꞋu ka Ꞌuri, “Nau ku saea naꞋa fuamuꞋa, ti ngwae aumulu Ꞌi neꞋe logo, kira noaꞋa kasi mae leleka kike lisia God ke gwaungaꞋi fafia ngwae nia ki Ꞌania ngasingasiꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ꞋI buri Ꞌana ono asoa ki, sa Jesus ka talaꞋia sa Peter, ma sa James, ma sa John, ma kira raꞋe Ꞌuana gwauna taꞋi faꞋi ua neꞋe fane, ma kira ka tua taꞋifili Ꞌada Ꞌi neꞋeri. Ma ana kaidaꞋi kira lia, kira ka lisia sa Jesus nia rokisi Ꞌi naꞋoda, ");
INSERT INTO kwf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma na ifi nia ka ngwasinasina, ma ka kwao liu. Ma nia kwao ka liufia mala ta ifi kwao neꞋe ta ngwae saena fanoa neꞋe Ꞌi ano neꞋe ke taufia. ");
INSERT INTO kwf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma na uulu fafarongo neꞋeri ki kira ka lisia sa Elaeja ma sa Moses, kera dao tafangaꞋi maꞋi siada, ma kera ka alaꞋa faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma sa Peter ka fata Ꞌuri fuana sa Jesus, “Aofia kwa, nia leꞋa liu fuakulu kuke tua Ꞌakulu Ꞌi neꞋe. Alu kaimili ke saungaꞋinia uulu babala ki, ta ai fuamu, ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” ");
INSERT INTO kwf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sa Peter nia fata ꞋunaꞋeri, sulia noaꞋa nia kasi saiana naꞋa ta ru neꞋe nia ke saea, duꞋungana kira maꞋu liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma taꞋi gwaꞋi salo ka dao maꞋi ma na nunufilana ka buta fafida. Ma taꞋi lingaꞋi ru nia talo maꞋi faꞋasia na gwaꞋi salo neꞋeri ma ka Ꞌuri, “Na ngela mutaꞋi nau neꞋe nau ku alafe liu naꞋa ana. Muke rongo sulia niaꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma kira ka lia ꞋaliꞋali kalikalida, ma kira kasi lisia naꞋa ta ngwae faꞋinida, taꞋifilia goꞋo sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","KaidaꞋi kira koso naꞋa maꞋi faꞋasia faꞋi ua neꞋeri, sa Jesus ka fata luida ka Ꞌuri, “NoaꞋa kamu kasi faꞋarongoa ta ngwae ana ru niniꞋa kamu lisia, leleka ka dao ana kaidaꞋi neꞋe nauꞋa, na Ngela Ngwae, nai tataꞋe faꞋasia na maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma kira ka roꞋosulia na fatalana, ma kira ka fata Ꞌi safitada kwailiu, ma kira ka Ꞌuri, “Na manataꞋi ngwae faꞋuta niniꞋa nia saea, ‘Nai tataꞋe faꞋasia na maeꞋa re?’” ");
INSERT INTO kwf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma kira ka lidia, kira ka Ꞌuri, “FaꞋuta neꞋe ngwae faꞋamanata ana taki kira ka saea sa Elaeja neꞋe ke baꞋa eta dao maꞋi?” ");
INSERT INTO kwf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma sa Jesus ka olisida ma ka Ꞌuri, “Sa Elaeja eta dao mamana maꞋi Ꞌi naꞋo, fasi Ꞌiri nia ke sasi akaꞋu ana ru ki taꞋifau. Bore ma kamu Ꞌisi rorongoa ba na KerekereꞋa Abu ba saea neꞋe, Ngela Ngwae ke baꞋa nonifii liu nama ma na ngwae ki kira ke ilangaꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nau ku saea fuamuꞋa, sa Elaeja nia eta dao naꞋa, ma na ngwae ki kika sasia naꞋa ru taꞋa neꞋe kira oga kike sasi ana, diꞋia KerekereꞋa Abu ba nia fata naꞋa maꞋi sulia.” ");
INSERT INTO kwf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma kaidaꞋi kira dao maꞋi fuana Ꞌafutana fafarongo ki, kira ka lisia taꞋi fikuꞋa doe kira fiku kalida. Ma ti ngwae faꞋamanata ana taki ki kira olisuꞋusuꞋu faꞋinida. ");
INSERT INTO kwf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma kaidaꞋi neꞋe ngwae ki kira lisia sa Jesus, kira ka Ꞌarefo liu, ma kira lalili kwau, ma kira ka kwalo saesaeleꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma sa Jesus ka lidia fafarongo nia ki ka Ꞌuri, “Ru faꞋuta niniꞋa kamu olisuꞋusuꞋu faꞋinida fani?” ");
INSERT INTO kwf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma taꞋi ngwae Ꞌi saena na fikuꞋa neꞋeri, nia olisia ka Ꞌuri, “FaꞋamanata Ꞌae, nau ku ngalia maꞋi kala Ꞌalako nai fuamu. Na ano Ꞌi ru taꞋa nia ruꞋufia, ma noaꞋa nia kasi fata naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma kaidaꞋi na ano Ꞌi ru taꞋa neꞋeri nia dao ana, nia ke Ꞌui Ꞌania Ꞌi ano. Ma na kwakwana ka ngisungisuꞋa, nia ke Ꞌala girigiri, ma na nonina ka gagaꞋai taꞋifau. Ma nau ku amasia na fafarongo Ꞌoe ki fasi Ꞌiri kira ka lalia na ano Ꞌi ru taꞋa neꞋe, bore ma nia ꞋafitaꞋi liu fuada.” ");
INSERT INTO kwf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma sa Jesus ka saea fuada ka Ꞌuri, “Kamu noaꞋa mu kasi faꞋamamana nauꞋa Ꞌua! Nau ku noni maruku naꞋa Ꞌani abu fitoꞋonga nini kamu. Nau ku tua faꞋi kamu ka dao naꞋa Ꞌuri, fuila kaumulu ka faꞋamamana nau naꞋa. Ngalia maꞋi na ngela neꞋeri fuaku.” ");
INSERT INTO kwf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma kira ka ngalia maꞋi na ngela neꞋeri fuana sa Jesus. Ma kaidaꞋi neꞋe ano Ꞌi ru taꞋa neꞋeri nia lisia sa Jesus, nia ka Ꞌui Ꞌania na ngela neꞋeri Ꞌi ano, ma ka failadusu, ma na kwakwana ka ngisungisuꞋa taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma sa Jesus ka lidia na maꞋa ngela neꞋeri ka Ꞌuri, “ꞋI angita mala neꞋe nia talaꞋae Ꞌuri kwa?” Ma nia ka olisia ka Ꞌuri, “Nia Ꞌita naꞋa maꞋi Ꞌua ana kaidaꞋi nia tiꞋitiꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma kaidaꞋi Ꞌoro neꞋe nia Ꞌui Ꞌania saena na mafula ma Ꞌi saena na kafo, fasi Ꞌiri ke saungia ke mae. Ma diꞋia nia bolo goꞋo Ꞌana fuamu, Ꞌoke manatai keroꞋo maꞋi, ma Ꞌoko kwaiꞋafi amiroꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma sa Jesus ka fata Ꞌuri, “ꞋIu, Ꞌoke faꞋamamana nau! Na ru ki taꞋifau nia talangwaraꞋu goꞋo Ꞌana fuana sa tai neꞋe nia faꞋamamana nau.” ");
INSERT INTO kwf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma ꞋaliꞋali goꞋo maꞋa ngela neꞋeri ka ako ka Ꞌuri, “Nau ku faꞋamamana! Bore Ꞌana Ꞌafi nau maꞋi, fasi Ꞌiri neꞋe faꞋamamanaꞋanga nau ke ngasingasiꞋa ma ka lalifu!” ");
INSERT INTO kwf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma kaidaꞋi sa Jesus lisia na fikuꞋa neꞋeri kira lalili maꞋi Ꞌuana kula neꞋeri, nia ka fata Ꞌuri fuana na ano Ꞌi ru taꞋa neꞋeri, “ꞋAeꞋo na ano Ꞌi ru nini Ꞌoko faꞋabania alingana ngela neꞋe, ma Ꞌoko faꞋanotoa na kwakwana ngela neꞋe, nau ku baeꞋo Ꞌoke ruꞋu maꞋi Ꞌi maa, ma Ꞌoe kosi oli kosi ruꞋufia laꞋu na ngela neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma na ano Ꞌi ru taꞋa neꞋe ka ri, ma ka lebesia na ngela neꞋeri, ma ka ruꞋu naꞋa maꞋi Ꞌi maa faꞋasia. Ma na ngela neꞋeri na lisilana ka diꞋia naꞋa neꞋe nia mae. Ma na ngwae Ꞌoro kira ka fata Ꞌuri, “Nia mae naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bore ma, sa Jesus ka dau ana limana na ngela neꞋeri, ma ka taꞋea, ma nia ka tataꞋe. ");
INSERT INTO kwf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma kaidaꞋi sa Jesus nia ruꞋu saena luma, na fafarongo nia ki kira ka lidia kaidaꞋi kira tua taꞋifilida ma kira ka Ꞌuri, “FaꞋuta neꞋe nia ꞋafitaꞋi fuaimili fuana ifulangaꞋilana na ano Ꞌi ru taꞋa baera kwa?” ");
INSERT INTO kwf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma sa Jesus ka olisida ka Ꞌuri, “TaꞋifilia foꞋongaꞋa goꞋo neꞋe nia bolo faꞋinia ifulangaꞋilana na ano Ꞌi ru taꞋa Ꞌuri ki, ma noaꞋa laꞋu ta ru.” ");
INSERT INTO kwf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","KaidaꞋi neꞋeri, sa Jesus ma na fafarongo nia ki kira faꞋasia kula neꞋeri, ma kira ka leka liu naꞋa Ꞌuana bali fanoa Ꞌi Galili. Ma sa Jesus ka Ꞌiri oga neꞋe ta ngwae ke saiana kula neꞋe kira tua ana, ");
INSERT INTO kwf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","duꞋungana nia faꞋamanata fafarongo nia ki ka Ꞌuri, “Nau, na Ngela Ngwae, kike baꞋa kwate nau fuana malimae nau ki, ma kike saungi nau. Ma uulu asoa ki Ꞌi buri, nai baꞋa tataꞋe oli laꞋu faꞋasia maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bore ma fafarongo sa Jesus ki noaꞋa kasi saiana na tae neꞋe nia saea, ma kira ka maꞋu Ꞌania lidilana. ");
INSERT INTO kwf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma kaidaꞋi kira dao ana fanoa Ꞌi Kapaneam, ma kira ka ruꞋu Ꞌi saena luma, sa Jesus ka lidia na fafarongo nia ki ka Ꞌuri, “Na tae ba kamu olisuꞋusuꞋu maꞋi faꞋinia sulia na tala?” ");
INSERT INTO kwf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bore ma kira kasi saea ta ru, duꞋungana kira olisuꞋusuꞋu maꞋi faꞋinia sa tai adulu neꞋe ka doe ka gwaungaꞋi fafida taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma sa Jesus ka tua Ꞌi ano, ma ka saea maꞋi na akwala ma ro fafarongo ba nia ki siana, ma ka fata Ꞌuri, “DiꞋia sa tai neꞋe nia oga ke faꞋinaꞋonaꞋo, nia ke alu niaꞋa ka Ꞌisi, ma nia na ngwae ni rao fuana ngwae ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui sa Jesus ka talaꞋia maꞋi taꞋi ngela, ma ka faꞋauua Ꞌi safitada. Nia ka ofia na ngela neꞋeri, ma ka fata Ꞌuri fuada, ");
INSERT INTO kwf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“DiꞋia sa tai neꞋe ke kwaloa ta ngela tiꞋitiꞋi Ꞌuri ana sataku, nia kwalo nau logo. Ma diꞋia sa tai neꞋe nia kwalo nau, noaꞋa nia kasi kwalo nau laꞋu taꞋifili nau, bore ma nia kwaloa logo God neꞋe nia asungaꞋi nau maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa John nia fata Ꞌuri fuana sa Jesus, “Ngwae FaꞋamanata kwa, kaimili lisia taꞋi ngwae nia ifulani na ano Ꞌi ru taꞋa ki ana satamu. Ma kaimili ka luia nia noaꞋa kasi sasia ru neꞋeri, sulia nia noaꞋa laꞋu ta ngwae ana fikuꞋa kulu.” ");
INSERT INTO kwf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma sa Jesus ka fata Ꞌuri, “NoaꞋa kamu kasi luia laꞋu, sulia sa tai neꞋe nia sasia ta faꞋanadaꞋa ana sataku, nia ꞋafitaꞋi neꞋe nia ke saea laꞋu ta ru taꞋa aku. ");
INSERT INTO kwf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","DiꞋia ta ngwae neꞋe noaꞋa nia kasi malimae akulu, nia ngwae kulu neꞋana. ");
INSERT INTO kwf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nau ku saea ru mamana fuaumulu, diꞋia ta ngwae neꞋe nia kwatea ta maꞋe kafo fuaumulu, sulia kaumulu na ngwae nau ki, nia ke baꞋa ngali mamana naꞋa ana kwaiaraꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“DiꞋia ta ngwae ka kwatea ngwae niniꞋa kira enoeno ki ka Ꞌasi faꞋasia fitoꞋonga kira aku, nia leꞋa fuana kira ke firiꞋia ta fau doe Ꞌi luana, ma kira ka Ꞌui Ꞌania Ꞌi saena na Ꞌatako. ");
INSERT INTO kwf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma diꞋia Ꞌoko oga Ꞌoe sasi ta ru taꞋa Ꞌani limamu, Ꞌoke siki muusia faꞋasiꞋo. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko tua tau Ꞌamu saena mauriꞋa Ꞌi langi faꞋinia na ngurunguru lima, Ꞌasu Ꞌubani Ꞌoko fiꞋi koso Ꞌi saena kula ana kwaꞋikwaꞋinga faꞋinia ro lima ki, kula neꞋe mafula nia duꞋaduꞋa kasi mae. ");
INSERT INTO kwf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma diꞋia Ꞌoko oga Ꞌoe sasi ta ru taꞋa Ꞌani Ꞌaemu, Ꞌoke siki muusia faꞋasiꞋo. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko tua tau Ꞌamu saena mauriꞋa Ꞌi langi faꞋinia na ngurunguru Ꞌae, Ꞌasu Ꞌubani Ꞌoko fiꞋi koso Ꞌi saena kula ana kwaꞋikwaꞋinga faꞋinia na ro Ꞌae ki. ");
INSERT INTO kwf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma diꞋia Ꞌoko oga Ꞌoe sasia ta ru taꞋa Ꞌani maamu, Ꞌoke lafua Ꞌamu faꞋasiꞋo. Nia taꞋi leꞋa goꞋo Ꞌana fuamu diꞋia Ꞌoko ruꞋu Ꞌi saena na ꞋInotoꞋanga God faꞋinia taꞋi bali maa, Ꞌasu Ꞌubani Ꞌoko fiꞋi koso Ꞌi saena kula ana kwaꞋikwaꞋinga faꞋinia ro bali maa ki. ");
INSERT INTO kwf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na kula neꞋeri, na ngwangwa ki neꞋe kira Ꞌania na ngwae ki, ma noaꞋa kira kasi mae, ma na mafula neꞋe nia duꞋafia ngwae ki nia duꞋaduꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sulia kira alua na mafula Ꞌi fafona ngwae ki taꞋifau, diꞋia neꞋe meme asi kira takalongaꞋinia saena ta fanga. ");
INSERT INTO kwf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ma na fiki asi nia leꞋa mo, bore ma si diꞋia neꞋe asilalana nia noaꞋa naꞋa faꞋasia, nia ꞋafitaꞋi liu kira ka sasia Ꞌani ta ru Ꞌiri ka asila laꞋu. “ꞋUnaꞋeri logo, muke faꞋasaeleꞋa ngwae ki diꞋia logo na meme asi neꞋe faꞋaleꞋa na fanga. Ma muke tua Ꞌani aroaroꞋanga Ꞌi safitamuꞋa kwailiu.” ");
INSERT INTO kwf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui ma sa Jesus ka faꞋasia Ꞌi Kapaneam, ma ka leka Ꞌuana na bali fanoa Ꞌi Judea, ma ka toꞋofolo ana kafo Ꞌi Jodan. Ma ngwae Ꞌoro ki kira ka fiku maꞋi siana, ma nia ka faꞋamanata kira, diꞋia ba nia Ꞌita ka faꞋamanata naꞋa maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma ti Farasi kira ke leka siana sa Jesus, ma kira ka iliili Ꞌuana faꞋaroralana faꞋasia na taki sa Moses, ma kira ka Ꞌuri, “ꞋUri ma, na taki sa Moses nia alaꞋania goꞋo Ꞌana neꞋe ngwae ke ilangaꞋinia na Ꞌafe nia kwa?” ");
INSERT INTO kwf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma sa Jesus ka olisida ma ka Ꞌuri, “Na tae ba sa Moses nia fata totongaꞋi fuamuꞋa Ꞌania sulia ru neꞋe?” ");
INSERT INTO kwf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma kira ka fata Ꞌuri, “Sa Moses nia alaꞋania neꞋe ngwae ke keresia ta Ꞌaba ru ana kwai ilangaꞋinga, ma ka kwatea fuana na Ꞌafe nia, fasi Ꞌiri nia ka logea naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma sa Jesus ka fata Ꞌuri, “Sa Moses nia keresia na taki neꞋe fuamuꞋa sulia nia ꞋafitaꞋi fuana faꞋamanata lamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bore ma, Ꞌita nama maꞋi ana kaidaꞋi God nia saungaꞋinia na ru ki taꞋifau, na KerekereꞋa Abu nia saea, ‘Nia saungaꞋinia ngwae ki Ꞌani ngwangwane ma kini. ");
INSERT INTO kwf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","DuꞋungana ru neꞋeri, ngwae ka faꞋasia na maꞋa nia faꞋinia teꞋa nia, ma ka tua ratai faꞋinia na Ꞌafe nia, ");
INSERT INTO kwf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma kera ke alua taꞋi manataꞋanga diꞋia taꞋi ngwae goꞋo.’ Nia noaꞋa laꞋu ta ro ngwae toꞋotoꞋo, bore ma diꞋia taꞋi ngwae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nia neꞋe, ru God nia firi fikua ka sui naꞋa ꞋunaꞋeri, noaꞋa nia kasi leꞋa fuana ta ngwae ke logea laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma kaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira oli Ꞌi luma, kira ka lidia Ꞌuana malutana ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma nia ka olisida ka Ꞌuri, “Ta ngwae bore Ꞌana neꞋe nia ilangaꞋinia na Ꞌafe nia, ma ka korea lala ta Ꞌafe matamata, nia kakabara naꞋa fafia na Ꞌafe nia. ");
INSERT INTO kwf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nia ꞋunaꞋeri logo, diꞋia ta Ꞌafe nia ilangaꞋinia na araꞋi nia, ma ka Ꞌafe laꞋu fuana ta ngwae matamata, nia kakabara naꞋa fafia na araꞋi nia.” ");
INSERT INTO kwf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ti ngwae kira ngalia maꞋi na kaela ngela tiꞋitiꞋi siana sa Jesus, fasi Ꞌiri nia ka sama toꞋoda ma ka faꞋaleꞋada, bore ma fafarongo nia ki kira ka balufida. ");
INSERT INTO kwf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma kaidaꞋi sa Jesus nia lisia ru neꞋeri, nia ka saetaꞋa, ma ka fata Ꞌuri fuada, “Muke alaꞋania na kaela ngela tiꞋitiꞋi kira ke leka maꞋi siaku, ma noaꞋa kamu kasi foneda laꞋu. DuꞋungana sa tai neꞋe nia manata mamana ka diꞋia ngela tiꞋitiꞋi ki, nia bolo fuana tuaꞋa olofana ꞋInotoꞋanga God. ");
INSERT INTO kwf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nau ku saea ru mamana fuamuꞋa, diꞋia ta ngwae neꞋe noaꞋa nia kasi faꞋamamana diꞋia ta ngela tiꞋitiꞋi, nia ꞋafitaꞋi liu nia ka ruꞋu Ꞌi saena na ꞋInotoꞋanga God.” ");
INSERT INTO kwf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma nia ka ofia na ngela tiꞋitiꞋi neꞋeri ki, ma ka alua na limana ada, ma ka faꞋaleꞋada. ");
INSERT INTO kwf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","KaidaꞋi sa Jesus nia talaꞋae ka leka laꞋu kwau sulia taꞋi tala, taꞋi ngwae nia lalili maꞋi, ma ka bobo uruuru Ꞌi naꞋona. Ma nia ka lidia ka Ꞌuri, “Ngwae faꞋamanata leꞋa Ꞌae, ta tae leꞋa neꞋe nau kui sasia Ꞌiri nai toꞋo ana na mauriꞋa firi?” ");
INSERT INTO kwf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma sa Jesus olisia ka Ꞌuri, “FaꞋuta neꞋe Ꞌoko sae nau Ꞌani ngwae leꞋa? NoaꞋa ta ngwae Ꞌiri leꞋa goꞋo, taꞋifilia God goꞋo neꞋe nia leꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nia leꞋa Ꞌoko saiana alaꞋanga totongaꞋi God ki ba Ꞌuri, ‘ꞋOe kosi sau ngwae, ma Ꞌoe kosi Ꞌusu, ma Ꞌoe kosi bili, ma Ꞌoe kosi soke fafia ta ngwae, ma Ꞌoe kosi Ꞌosoa ta ngwae, ma Ꞌoko fuꞋusi doe ana maꞋa Ꞌoe ma teꞋa Ꞌoe.’” ");
INSERT INTO kwf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma nia ka fata Ꞌuri, “Ngwae FaꞋamanata kwa, nia Ꞌita nama maꞋi ana kaidaꞋi nau ku tiꞋitiꞋi, nau ku roꞋosulia na taki neꞋeri ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","GoꞋo, sa Jesus ka lia kwau fuana Ꞌania alafeꞋanga, ma ka fata Ꞌuri fuana, “TaꞋi ru goꞋo neꞋe nia noaꞋa Ꞌua. ꞋOke leka kwau, ma Ꞌoko Ꞌoifoli Ꞌania na ru ba Ꞌoe ki taꞋifau, ma Ꞌoko ngalia mani neꞋeri ki, ma Ꞌoko kwatea fuana na ngwae dalaꞋa ki, ma Ꞌoko fiꞋi toꞋo ana na toꞋoruꞋa Ꞌi langi. ꞋUnaꞋeri goꞋo, Ꞌoko leka maꞋi suli nau.” ");
INSERT INTO kwf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma kaidaꞋi neꞋe ngwae neꞋeri nia rongoa goꞋo ru neꞋeri ki, na maana ka ꞋaruꞋaru naꞋa. Ma nia ka leka naꞋa Ꞌana faꞋinia na kwaimanataiꞋanga, duꞋungana neꞋe niaꞋa ngwae toꞋoru liu. ");
INSERT INTO kwf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui ma sa Jesus ka lia fuana na fafarongo nia ki, ma ka fata Ꞌuri, “Nia ꞋafitaꞋi liu naꞋa fuana na ngwae toꞋoru ki kike ruꞋu saena ꞋInotoꞋanga God.” ");
INSERT INTO kwf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma na fafarongo nia ki kira ka Ꞌarefo liu naꞋa ana alaꞋanga neꞋeri ki. Sui sa Jesus ka fata laꞋu Ꞌuri fuada, “Ngela nau kina, nia ꞋafitaꞋi liu naꞋa fuana na ruꞋungaꞋa saena ꞋInotoꞋanga God. ");
INSERT INTO kwf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nia ꞋafitaꞋi liu neꞋe ta kamel ke ruꞋu sulia na maꞋe kwakwa tiꞋitiꞋi Ꞌi Ꞌaena sugila. Nia ꞋafitaꞋi ka liufia laꞋu fuana ta ngwae toꞋoru ke ruꞋu Ꞌi saena na ꞋInotoꞋanga God.” ");
INSERT INTO kwf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma na fafarongo nia ki kira ka Ꞌarefo liu, osiꞋana kira fia fasi na toꞋoruꞋanga neꞋe na faꞋaleꞋanga maꞋi faꞋasia God. Ma kira saefilo kwailiu ada, kira ka Ꞌuri, “ꞋIrai ma noaꞋa ta ngwae goꞋo neꞋe ke toda mauriꞋa firi reala?” ");
INSERT INTO kwf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma sa Jesus ka lia funufunu fuada ma ka fata Ꞌuri, “Nia ꞋafitaꞋi fuana na ngwae ki ke toda mauriꞋa firi, bore ma fuana God noaꞋa nia kasi ꞋafitaꞋi goꞋo. Na ru ki taꞋifau nia talangwaraꞋu goꞋo Ꞌana fuana God.” ");
INSERT INTO kwf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma sa Peter ka fata Ꞌuri fuana, “Kaimili faꞋasia naꞋa ru ki taꞋifau Ꞌiri mika donga Ꞌoe naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma sa Jesus ka olisia ka Ꞌuri, “ꞋIu, nau ku saea fuamuꞋa, diꞋia ta ngwae neꞋe ke faꞋasia na luma nia, nama na ngwaefuta nia ki, nama na ngwaingwaena nia ki, nama na maꞋa nia, nama teꞋa nia, nama na ngela nia ki, nama na ano nia, duꞋungaku faꞋinia na FaꞋarongoꞋa LeꞋa neꞋe, ");
INSERT INTO kwf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nia ke baꞋa ngalia laꞋu ru neꞋeri ki ka Ꞌoro ka liufia kaidaꞋi neꞋe. Nia ke baꞋa ngalia ru Ꞌoro ana na luma ki, ma na ngwaefuta ki, ma na ngwaingwaena ki, ma teꞋa ki, ma na ngela ki, ma na ano. Ma nia ke baꞋa toda logo nonifiiꞋa ki. Ma ana kaidaꞋi neꞋe ke baꞋa dao maꞋi, nia ke baꞋa toꞋo ana mauriꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bore Ꞌana na ngwae Ꞌoro neꞋe kira etaeta Ꞌi naꞋo ki, kike baꞋa Ꞌisiburi, ma na ngwae Ꞌoro neꞋe kira Ꞌisiburi ki, kike baꞋa etaeta Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa Jesus faꞋinia na fafarongo nia ki, kira leka sulia na tala Ꞌuana Ꞌi Jerusalem, ma sa Jesus ka etaeta ada. Ma fafarongo nia ki kira ka Ꞌarefo liu, ma ti ngwae logo neꞋe kira leka kwau Ꞌi burida, kira ka maꞋu liu. Ma sa Jesus ka talaꞋia na akwala ma ro fafarongo nia ki ka taꞋi Ꞌidu tau laꞋu kwau faꞋasia ngwae ki. Ma nia ka fiꞋi faꞋarongoda Ꞌani na ru ki neꞋe ke baꞋa fuli fuana. ");
INSERT INTO kwf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma nia ka fata Ꞌuri, “Mulu fafarongo! Kulu raꞋe ꞋalaꞋa Ꞌuana Ꞌi Jerusalem, ma kira ke baꞋa Ꞌolosae nau, na Ngela Ngwae, fuana na fata abu doe ki faꞋinia na ngwae faꞋamanata ki ana taki. Ma kike baꞋa matalangaꞋi nau fuana maelaku, ma kike kwate nau fuana na ngwae kwaita ki. ");
INSERT INTO kwf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma na ngwae neꞋeri ki kike baꞋa Ꞌoidorole Ꞌani nau, ma kike ngisuli nau, ma kike kwaiꞋi nau, ma kike saungi nau. Ma ana uula asoa, nai baꞋa tataꞋe laꞋu faꞋasia na maeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ꞋUnaꞋeri goꞋo, sa James ma sa John, ro ngela sa Sebedi ki, kera ka leka maꞋi siana sa Jesus, ma kera ka fata Ꞌuri, “Ngwae FaꞋamanata kwa, keroꞋo oga Ꞌoke kwatea taꞋi ru neꞋe keroꞋo gania amu.” ");
INSERT INTO kwf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma sa Jesus ka lidi Ꞌuri adaroꞋo, “Tae neꞋe koroꞋo oga nai sasia fuamuroꞋo?” ");
INSERT INTO kwf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma kera ka olisia kera ka Ꞌuri, “KaidaꞋi neꞋe Ꞌoke baꞋa ꞋinotoꞋa fafia magalia faꞋinia ru ki taꞋifau, Ꞌoke alaꞋania ta ngwae amiroꞋo ke tua Ꞌi bali ꞋoloꞋolo amu, ma ta ngwae ana bali mauli amu fuana gwaungaꞋinga fafia ngwae ki.” ");
INSERT INTO kwf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bore ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “KoroꞋo kina goꞋo ru neꞋe koroꞋo gania. KoroꞋo bolo goꞋo amuroꞋo faꞋinia nonifiiꞋanga nini nai baꞋa nonifii Ꞌania?” ");
INSERT INTO kwf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma kera ka olisia kera ka Ꞌuri, “KeroꞋo bolo goꞋo amiroꞋo fuana sasilana.” Ma sa Jesus ka fata Ꞌuri fuadaroꞋo, “ꞋIu, nia leꞋa koroꞋo ke baꞋa nonifii logo diꞋia nauꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bore ma noaꞋa nau kusi filia sa tai neꞋe ke tua Ꞌi bali ꞋoloꞋolo aku ma neꞋe Ꞌi bali mauli aku. TalitoꞋona God goꞋo neꞋe ke kwatea kula ꞋunaꞋeri ki fuana sa tai faꞋida neꞋe nia ka sasi akaꞋu ada masida.” ");
INSERT INTO kwf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma kaidaꞋi na akwala fafarongo neꞋeri ki kira rongoa ru neꞋeri, kira ka saetaꞋa fuana sa James ma sa John. ");
INSERT INTO kwf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma sa Jesus nia fikuda ma ka fata Ꞌuri fuada, “Kaumulu saiana na ngwae gwaungaꞋi ki neꞋe kira gwaungaꞋi fuana ngwae neꞋe noaꞋa laꞋu Jiu ki, kira toꞋo ana ngasingasiꞋanga, ma kira sai liu ana usungaꞋilana ngwae fuana sasilana ru kira ogaꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sui bore Ꞌana, noaꞋa nia kasi ꞋunaꞋeri laꞋu Ꞌi safitamuꞋa. DiꞋia ta ngwae aumulu nia oga ka faꞋinaꞋonaꞋo, nia ke saiana nia ngwae rao kaumulu. ");
INSERT INTO kwf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma diꞋia sa tai aumulu neꞋe nia oga ka ꞋinotoꞋa, nia ke rao ꞋoꞋo fuana ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","OsiꞋana nauꞋa, na Ngela Ngwae, nau noaꞋa kusi leka maꞋi fasi Ꞌiri na ngwae ki kike rao fuaku. Bore ma nau ku leka lala maꞋi fasi Ꞌiri nau kui rao fuana na ngwae ki taꞋifau, ma nau ku kwatea na maurilaku fuana faꞋamaurilana na ngwae Ꞌoro ki.” ");
INSERT INTO kwf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ana kaidaꞋi neꞋeri, sa Jesus faꞋinia na fafarongo nia ki kira dao naꞋa maꞋi ana fanoa Ꞌi Jeriko. Ma kaidaꞋi kira faꞋasia naꞋa fanoa neꞋeri faꞋinia na fikuꞋa doe neꞋeri, taꞋi ngwae neꞋe maana rodo nia tua goꞋo Ꞌana Ꞌi ninimana na tala fuana na ganiꞋa. Na satana sa Batimeas, na ngela sa Timeas. ");
INSERT INTO kwf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma kaidaꞋi nia rongoa sa Jesus, na ngwae Ꞌi Nasaret, nia ka leka maꞋi, nia ka ako ka Ꞌuri, “Jesus ꞋaeꞋo na Ꞌalako ana kwalafa sa David, Ꞌoke manatai nau maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma na ngwae ki kira ka kwaifone ana, ma kira ka saea fuana fasi Ꞌiri nia tua aroaro. Bore ma nia fiꞋi ako ka tasa liu mala ka Ꞌuri, “ꞋAlako ana kwalafa sa David Ꞌae, Ꞌoke manatai nau maꞋi!” ");
INSERT INTO kwf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma sa Jesus ka uutoꞋo ma ka fata Ꞌuri, “Mulu saea maꞋi.” Ma kika ri Ꞌuana sa Batimeas, kira ka Ꞌuri, “ꞋOke saeleꞋa naꞋa amu! TataꞋe naꞋa, sa Jesus nia saeꞋo naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","GoꞋo nia ka toꞋosia ifi fafo doe nia, ma ka tataꞋe ꞋaliꞋali, ma ka leka siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma sa Jesus ka lidia ka Ꞌuri, “Tae neꞋe Ꞌoko oga nai sasia fuamu kwa?” Ma na ngwae maana rodo neꞋeri olisia sa Jesus ka Ꞌuri, “FaꞋamanata Ꞌae, nau ku oga nai lia logo kwa.” ");
INSERT INTO kwf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma sa Jesus ka fata Ꞌuri fuana, “Leka naꞋa kwau amu. Lia naꞋa duꞋungana neꞋe Ꞌoko faꞋamamana nau.” Ma ꞋaliꞋali na maana ka lia naꞋa, ma nia ka donga naꞋa sa Jesus sulia na tala. ");
INSERT INTO kwf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","KaidaꞋi sa Jesus faꞋinia na fafarongo nia ki kira dao karangia na fanoa Ꞌi Jerusalem, kira dao ana fanoa Ꞌi Betfeis ma Ꞌi Betani, gwauna faꞋi ua kira saea Ꞌani Ꞌi Olif. GoꞋo, nia ka kwatea ta ro ngwae ana fafarongo nia ki, kera ka etaeta Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma nia ka fata Ꞌuri fuadaroꞋo, “Moro leka ana fanoa loꞋoko koroꞋo naꞋofia kwau. Ma kaidaꞋi koroꞋo dao Ꞌi neꞋeri, koroꞋo ke lisia taꞋi dongki. Kira firiꞋia goꞋo Ꞌada dongki neꞋeri, ma noaꞋa ta ngwae kasi raꞋeraꞋe Ꞌua fafona. KoroꞋo ke logea, ma moro ka talaꞋia maꞋi Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma diꞋia ta ngwae nia lidi koroꞋo, ‘FaꞋuta neꞋe koroꞋo ka logea na dongki neꞋe re?’ Moro ke saea fuana, ‘Na Aofia nia boꞋoboꞋo Ꞌuana, ma nia ke baꞋa olitaꞋi ꞋaliꞋali logo maꞋi ana Ꞌi neꞋe.’” ");
INSERT INTO kwf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma kera ka leka, ma kera ka lisia taꞋi kala dongki kira firiꞋia goꞋo Ꞌada Ꞌi ninimana na tala Ꞌi maana taꞋi luma. Ma kaidaꞋi kera logea naꞋa, ");
INSERT INTO kwf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ti ngwae neꞋe kira uu Ꞌi neꞋeri, kira ka lidia keroꞋa ka Ꞌuri, “Tae neꞋe koroꞋo logea na kala dongki neꞋe fuana?” ");
INSERT INTO kwf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma kera ka olisida diꞋia ba sa Jesus nia saea fuadaroꞋo, ma na ngwae neꞋeri ki kira ka alaꞋania fuadaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma kera ka talaꞋia maꞋi na kala dongki neꞋeri siana sa Jesus, ma kera ka safataꞋinia na Ꞌaba ifi kera ki Ꞌi fafona, ma sa Jesus ka raꞋe fafona. ");
INSERT INTO kwf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na ngwae Ꞌoro ki kira ka safataꞋinia na Ꞌaba ifi keta kira ki Ꞌi sulia na tala, ma ti ngwae kira ka tufua na uila niniu ki, ma kira ka safataꞋinia sulia na tala. Kira sasia ru neꞋeri fuana faꞋadoelana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma ngwae ki taꞋifau neꞋe leka faꞋinia, ti ngwae kira ka etaeta Ꞌi naꞋo, faꞋinia ti ngwae neꞋe kira Ꞌisi, kira ako ma kira ka Ꞌuri, “AuraꞋea God! Ma God Ꞌoke ꞋoilakitaꞋinia na ngwae neꞋe nia leka maꞋi Ꞌani na ngasingasiꞋanga Ꞌoe! ");
INSERT INTO kwf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma God Ꞌoke ꞋoilakitaꞋinia maꞋi daolana na ꞋinotoꞋanga neꞋe nia diꞋia na ꞋinotoꞋanga sa David koꞋo bora kia! AuraꞋea God nia tua Ꞌi langi!” ");
INSERT INTO kwf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sa Jesus nia ruꞋu Ꞌi saena na fanoa Ꞌi Jerusalem, ma ka leka Ꞌi saena na Luma Abu God. ꞋUnaꞋeri, nia ka lia kwailiu, ma ka lisia ru ki taꞋifau. Bore ma sulia nia karangi rodo naꞋa, nia ka leka naꞋa Ꞌuana Ꞌi Betani faꞋinia na akwala ma ro fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma ana faꞋi asoa Ꞌi buri, kaidaꞋi sa Jesus ma na fafarongo nia ki kira oli naꞋa maꞋi faꞋasia Ꞌi Betani, sa Jesus ka fiolo. ");
INSERT INTO kwf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma nia ka lia kwau, ma ka lisia taꞋi Ꞌai uluuluꞋa neꞋe kira saea Ꞌani na figi. Ma nia ka leka karangia fasi Ꞌiri ke lisia ta fuaꞋi ru ana. Bore ma kaidaꞋi nia dao Ꞌi Ꞌaena, nia ka lisia goꞋo ana na raꞋi ru ki, sulia kaidaꞋi neꞋeri na Ꞌai figi ki kira lua Ꞌao. ");
INSERT INTO kwf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma sa Jesus ka fata Ꞌuri fuana na Ꞌai figi neꞋeri, “Ta ngwae kata Ꞌani Ꞌania laꞋu ta fuaꞋi ru amu!” Ma na fafarongo nia ki kira ka rongoa ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma kaidaꞋi kira dao naꞋa Ꞌi Jerusalem, sa Jesus ka leka Ꞌi saena na Luma Abu God. ꞋUnaꞋeri, nia ka lalia na ngwae ki taꞋifau neꞋe kira foli ma kira ka Ꞌoifoli ana ru fuana kwaisuꞋusiꞋanga ki, ma kira ka obosia ngwae ki Ꞌi neꞋeri. Ma nia ka giosia na tatafe ana ngwae neꞋeri ki neꞋe kira rokisi mani ki, ma ka giosia na ru fuana tuaꞋa ana ngwae ki neꞋe kira Ꞌoifoli ana na faꞋi fao ki. ");
INSERT INTO kwf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma noaꞋa nia kasi alaꞋania ta ngwae ke ngalia ta ru Ꞌi saena na ana Luma Abu God. ");
INSERT INTO kwf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma nia ka faꞋamanata na ngwae ki, ka fata Ꞌuri, “God nia saea Ꞌi saena na KerekereꞋa Abu ka Ꞌuri, ‘Na luma nau, kira saea Ꞌani na luma fuana foꞋongaꞋa fuana na ngwae ana magalia ki taꞋifau.’ Bore ma kamu faꞋitaꞋinia ka alua lala kula fuana bililana ngwae ki.” ");
INSERT INTO kwf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana kaidaꞋi, na fata abu doe ki faꞋinia na ngwae faꞋamanata ana na taki ki, kira rongoa ru neꞋeri, ma kira ka talaꞋae kika lulu Ꞌuana ta ru kike sasia fuana saungilana sa Jesus. Ma kira ka maꞋungia, sulia neꞋe fikuꞋa neꞋeri taꞋifau, kira Ꞌarefo liu ana na faꞋamanataꞋanga nia. ");
INSERT INTO kwf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nia saꞋulafi naꞋa, sa Jesus ma na fafarongo nia ki, kira ka leka naꞋa faꞋasia Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana Ꞌofodangi ana faꞋi asoa Ꞌi buri, sa Jesus faꞋinia na fafarongo nia ki kira ka leka kwau sulia na tala. Kira lisia na Ꞌai figi baera nia kuku taꞋifau naꞋa leka ka koso naꞋa sulia na lalina. ");
INSERT INTO kwf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma sa Peter ka manata toꞋona ru ba sa Jesus nia sasia ana Ꞌai neꞋeri, ma ka fata Ꞌuri fuana, “Ngwae faꞋamanata Ꞌae, lisia basi na Ꞌai figi ba Ꞌoko agia, nia mae naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma sa Jesus nia olisia ka Ꞌuri, “Kamu ka manata mamana naꞋa ana God. ");
INSERT INTO kwf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nau ku saea fuamuꞋa, diꞋia kamu ke fata Ꞌuri fuana faꞋi ua neꞋe, ‘ꞋOke tataꞋe, ma Ꞌoko Ꞌui ꞋaniꞋo talamu saena na asi,’ ma noaꞋa kamu kasi manata ruarua Ꞌi saena na liamuꞋa, ma kamu ka manata mamana ana ru neꞋe kamu saea nia ke fuli, ru neꞋeri ke fuli goꞋo ana fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ta neꞋe, nau ku saea fuamuꞋa Ꞌuri, kaidaꞋi kamu foꞋo, ma muke gani Ꞌuana ta ru, kamu ke manata mamana diꞋia neꞋe kamu ngalia naꞋa, ma God ke baꞋa kwatea goꞋo Ꞌana ru neꞋe kamu gani Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","ꞋIu, kaidaꞋi kamu foꞋo, muke rufuanata ana taꞋangaꞋa neꞋe ta ngwae nia sasia amuꞋa, Ꞌiri neꞋe MaꞋa kamu neꞋe nia tua maꞋi Ꞌi langi ke rufuanata logo ana taꞋangaꞋa kamu ki.” ");
INSERT INTO kwf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa Jesus faꞋinia fafarongo nia ki, kira oli laꞋu maꞋi Ꞌuana Ꞌi Jerusalem. Ma kaidaꞋi sa Jesus leka kwau Ꞌi saena Luma Abu God, na fata abu doe ki, ma na ngwae faꞋamanata ana na taki ki, ma na ngwae faꞋinaꞋonaꞋo ki, kira ka leka maꞋi siana. ");
INSERT INTO kwf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma kira ka lidi Ꞌuri ana, “Na mamanaꞋanga tae neꞋe Ꞌoko toꞋo ana fuana na sasilana ru neꞋe ki kwa? Ma sa tai mo neꞋe nia kwatea na mamanaꞋanga neꞋe fuamu?” ");
INSERT INTO kwf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma sa Jesus ka olisida ka Ꞌuri, “ꞋIu, nau ku lidi kaumulu basi Ꞌuana taꞋi ru. DiꞋia kamu olisia, nau ku fiꞋi faꞋarongo kaumulu ana na mamanaꞋanga neꞋe nau ku toꞋo ana fuana sasilana ru neꞋe ki. ");
INSERT INTO kwf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ꞋIu, kamu ke saea basi fuaku, na mamanaꞋanga neꞋe sa John nia toꞋo ana fuana na siuabuꞋanga nia Ꞌita maꞋi faꞋasia Ꞌi fai? Nia Ꞌita maꞋi ana God, nama nia Ꞌita maꞋi ana na ngwae ki goꞋo?” ");
INSERT INTO kwf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma kira ka talaꞋae ana olisuꞋusuꞋunga Ꞌi safitada kwailiu kira ka Ꞌuri, “Tae neꞋe kulu ke saea? DiꞋia kulu olisia ma kulu ka Ꞌuri, ‘FaꞋasia maꞋi God,’ nia ke baꞋa fata Ꞌuri, ‘ꞋIrai ma faꞋuta mo neꞋe noaꞋa kamu kasi faꞋamamana sa John?’ ");
INSERT INTO kwf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma noaꞋa nia kasi leꞋa logo fuana neꞋe kulu ka fata Ꞌuri, ‘Nia Ꞌita goꞋo maꞋi ana na ngwae ki.’” Kira sasi Ꞌuri osiꞋana kira maꞋungia na ngwae ki, duꞋungana na ngwae ki taꞋifau kira saiana sa John nia na profet mamana. ");
INSERT INTO kwf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nia neꞋe, kira olisia sa Jesus ma kira ka Ꞌuri, “Kaimili kina goꞋo.” Ma sa Jesus ka fata Ꞌuri fuada, “NauꞋa bore naisi faꞋarongo kamu logo ana na mamanaꞋanga faꞋuta neꞋe nau ku sasia Ꞌani ru neꞋe ki.” ");
INSERT INTO kwf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui, sa Jesus nia alaꞋa fuana gwaungaꞋi ngwae Jiu baera ki Ꞌani tarifulaꞋa ka Ꞌuri, “TaꞋi ngwae nia fasia na oꞋola. Ma nia ka saungaꞋinia sakali kalia, ma ka Ꞌilia taꞋi kilu fuana na ngisilana na fuaꞋi Ꞌai ki fuana saungaꞋilana waen, ma ka saungaꞋinia taꞋi luma fuana na foloꞋa. Ma nia ka alua na oꞋola nia saena limana ngwae ki neꞋe kira rao Ꞌi saena. ꞋUnaꞋeri, nia ka leka naꞋa Ꞌana Ꞌuana ta maꞋe fanoa. ");
INSERT INTO kwf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma kaidaꞋi neꞋe oꞋola neꞋeri nia maua, nia ka kwatea na ngwae ni rao nia fuana na ngwae neꞋe kira rao Ꞌi saena oꞋola nia, fasi Ꞌiri kike kwatea maꞋi ta bali ana fuaꞋi ru neꞋe kira loiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bore ma ngwae ni rao neꞋeri ki kira firi ngasi ana, ma kira ka ulasia, ma kira ka olitaꞋi ꞋoꞋo goꞋo Ꞌada ana. ");
INSERT INTO kwf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","GoꞋo, na ngwae ba nia toꞋo ana na oꞋola neꞋeri ka kwatea laꞋu ta ngwae ni rao. Ma na ngwae ni rao Ꞌi saena oꞋola, kira ka kwaiꞋia gwauna, ma kira ka mala taꞋa liu naꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ꞋUnaꞋeri na ngwae ba toꞋo ana na oꞋola, nia ka kwatea laꞋu ta ngwae ni rao, ma kira ka saungia ka mae naꞋa. Ma kira ka sasi logo ꞋunaꞋeri ana na ngwae Ꞌoro neꞋe nia baꞋeda Ꞌi buri ki. Kira ulasia ti ngwae, ma kira ka saungia ti ngwae ka mae. ");
INSERT INTO kwf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ꞋIu, ma taꞋi ngwae naꞋa neꞋe nia toꞋo ana fuana baꞋelana, taꞋi ngela mutaꞋi nia naꞋa neꞋe ngwae neꞋeri. Ma nia ka baꞋea kwau, ma ka manata Ꞌuri, ‘Kira ke baꞋa fuꞋusi doe ana ngela nau.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bore ma, ngwae neꞋe kira rao Ꞌi saena oꞋola, kira fata fuada kwailiu ma kira ka Ꞌuri, ‘Nia naꞋa neꞋe na ngela na ngwae ba nia toꞋo ana na oꞋola. Leka maꞋi kuke saungia, fasi Ꞌiri kulu ka toꞋo Ꞌakulu ana ru nia ki taꞋifau.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma kira ka ngalia na ngela neꞋeri, kira ka saungia ka mae, goꞋo kira ka Ꞌui Ꞌania naꞋa nonina Ꞌi maa faꞋasia saena na oꞋola neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma sa Jesus ka saefiloda ka Ꞌuri, “Tae neꞋe na ngwae neꞋe nia toꞋo ana na oꞋola neꞋeri ke baꞋa sasia? Nia ke baꞋa dao maꞋi, ka saumusia na ngwae neꞋeri ki. Sui nia ka kwatea naꞋa oꞋola nia fuana ngwae matamata ki. ");
INSERT INTO kwf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nia mamana kamu toꞋomani na KerekereꞋa Abu ba nia fata Ꞌuri, ‘Na fau neꞋe na ngwae saungaꞋi luma ki kira Ꞌaila Ꞌania, nia neꞋe na fau neꞋe talingaꞋi ka liufia na fau ki taꞋifau ana Ꞌodoa. ");
INSERT INTO kwf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God neꞋe faꞋafulingani ru neꞋeri, ma na lisilana ka leꞋa liu.’” ");
INSERT INTO kwf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na faꞋinaꞋonaꞋo Jiu ki, kira oga kike daua sa Jesus, osiꞋana kira saiana neꞋe sa Jesus nia fata sulia tarifulaꞋa neꞋeri fuana giosilada. Bore ma, kira maꞋu Ꞌani fikuꞋa neꞋe, ma kira ka faꞋasia, ma kira ka leka naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ti faꞋinaꞋonaꞋo, kira kwatea ti Farasi ma ti ngwae ana ngwae sa Herod ki fuana saefilolana sa Jesus fasi Ꞌiri kike faꞋarora niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ꞋIu, kira dao naꞋa siana, ma kika fata Ꞌuri, “Ngwae FaꞋamanata Ꞌae, kaimili saiana ru Ꞌoko saeꞋe ki, ru mamana ki taꞋifau goꞋo. ꞋOko faꞋamanata goꞋo Ꞌamu sulia mamanaꞋanga ma kwaiogaiꞋanga God fuana na ngwae ki. Ma Ꞌoe kosi Ꞌado goꞋo faꞋinia ta ngwae Ꞌani ta tae neꞋe kira manata sulia. Ma noaꞋa Ꞌoe kosi manata goꞋo Ꞌuana na ꞋinotoꞋalana na ngwae. ꞋIu, Ꞌoke saea basi fuaimili! Nia faꞋuta? Na taki kia, nia luia na kwatelana na mani ana takisi fuana na ngwae gwaungaꞋi ana Ꞌafutana Ꞌi Rom? Nia faꞋuta? Nia bolo faꞋinia kaimili ke kwatea takisi baera, nama noaꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bore ma, sa Jesus nia sai goꞋo ana sokeꞋa kira, ma nia ka olisia ka Ꞌuri, “FaꞋuta neꞋe kamu ka sasi Ꞌuana na faꞋaroralaku? Mulu ngalia maꞋi ta selene. Nai lisia basi.” ");
INSERT INTO kwf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma kira ka ngalia maꞋi taꞋi selene, ma nia ka saefiloda ka Ꞌuri, “Na nununa sa tai niniꞋa? Ma na satana sa tai mo niniꞋa?” Ma kira olisia, kira ka Ꞌuri, “Na nununa ma na satana na tatalafaꞋa Ꞌi Rom.” ");
INSERT INTO kwf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma sa Jesus ka fata Ꞌuri, “Kamu ka kwatea fuana na tatalafaꞋa Ꞌi Rom na ru nia ki, ma kamu ka kwatea logo ru God ki fuana God.” Ma kira ka Ꞌarefo liu Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sui, ti Sadusi kira leka maꞋi siana sa Jesus. Na Sadusi ki kira saea fasi na ngwae ki noaꞋa kira kasi tataꞋe laꞋu faꞋasia na maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma kira ka saefiloa sa Jesus kira ka fata Ꞌuri, “Ngwae FaꞋamanata kwa, sa Moses nia keresia na taki fuaka ka alangaꞋi Ꞌuri, ‘DiꞋia ta ngwae nia mae, ma na Ꞌafe nia ka mauri Ꞌua, bore ma noaꞋa nia kasi toꞋo ana ta ngela, na ngwaefuta nia ka korea laꞋu na gwaꞋi Ꞌuru neꞋeri, fasi Ꞌiri kera ka toꞋo ana ta ngela fuana ka talafuila na ngwae neꞋe nia mae naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ꞋIu, ma ana taꞋi kaidaꞋi, fiu ngwae asina ki kira tua. Ma na ngwae Ꞌi naꞋo ka korea ta kini, ma ka noaꞋa kasi alua goꞋo ta ngela, ma ngwae neꞋeri ka mae naꞋa ana. ");
INSERT INTO kwf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui ma, ruana ngwae ka korea laꞋu na kini baera, ma noaꞋa nia kasi alua logo ta ngela, ma ka mae logo Ꞌana. Sui ma uula ngwae ka ꞋunaꞋeri logo. ");
INSERT INTO kwf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka ꞋunaꞋeri logo fuana ai burina ki taꞋifau. Na fiu ngwae asina neꞋeri ki taꞋifau goꞋo neꞋe kira korea kini neꞋeri, ma ka noaꞋa kira kasi toꞋo goꞋo ana ta ngela, ma kira ka mae taꞋifau naꞋa. Ma Ꞌisilana, kini neꞋeri ka mae logo. ");
INSERT INTO kwf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ꞋUri ma, ana asoa neꞋe God ke taꞋea ngwae mae ki taꞋifau faꞋasia maeꞋa, sa tai ada neꞋe na Ꞌafe nia? Sulia na fiu ngwae asina neꞋeri ki ba kira korekorea na kini neꞋeri taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma sa Jesus ka olisida ka Ꞌuri, “Kaumulu rora liu naꞋa, sulia kamu kasi sai goꞋo ana na KerekereꞋa Abu ki, ma na ngasingasiꞋanga God. ");
INSERT INTO kwf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sulia, kaidaꞋi neꞋe ngwae mae ki kira ke tataꞋe laꞋu fuana na mauriꞋa, kira diꞋia naꞋa Ꞌada na Ꞌainsel ki Ꞌi langi neꞋe noaꞋa kira kasi kore kini naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ꞋIu, nau ku faꞋamanata kamu sulia na tataꞋenga faꞋasia na maeꞋa. Nau ku saiana kamu toꞋomani naꞋa Ꞌi saena na kerekereꞋa sa Moses ana kula ba sulia na mafula nia duꞋafia na busuꞋi Ꞌai baera. God ka fata fuana sa Moses ka Ꞌuri, ‘NauꞋa na God sa Abraham, ma na God sa Aesak, ma na God sa Jakob.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na fadalana neꞋe Ꞌuri, ngwae neꞋeri ki neꞋe kira mae naꞋa, God nia saea neꞋe nia God kira Ꞌua, osiꞋana kira mauri Ꞌua faꞋinia. Kaumulu rora liu naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma taꞋi ngwae faꞋamanata ana taki sa Moses, nia ka rongoa alaꞋanga neꞋeri ki. Ma nia ka saiana na olisiꞋanga leꞋa neꞋe sa Jesus sasia fuana ngwae Sadusi ki. Ma nia ka leka maꞋi, ka saefiloa sa Jesus ka Ꞌuri, “Na taki faꞋuta neꞋe nia doe ka liufia na taki sa Moses ki taꞋifau kwa?” ");
INSERT INTO kwf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma sa Jesus nia olisia ka Ꞌuri, “Na taki doe ka liufia taki ki taꞋifau neꞋe nia Ꞌuri, ‘Ngwae Jiu ki, muke fafarongo basi! Na God kia, nia taꞋi God goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ꞋOke kwaima ana God Ꞌoe Ꞌani manatamu taꞋifau, ma Ꞌani mangomu taꞋifau, ma Ꞌani liamu taꞋifau, ma Ꞌani ngasingasi lamuꞋa taꞋifau.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma na ruana taki ka Ꞌuri, ‘ꞋOke alafe fuana ngwae ki taꞋifau ka diꞋia logo neꞋe Ꞌoko alafe fuamu talamu.’ NoaꞋa naꞋa ta taki laꞋu neꞋe nia doe ka liufia na ro taki neꞋeri ki.” ");
INSERT INTO kwf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma na ngwae faꞋamanata ana taki sa Moses ka fata Ꞌuri fuana sa Jesus, “Ngwae faꞋamanata Ꞌae, na olisiꞋanga Ꞌoe nia leꞋa liu. Nia ka mamana, taꞋifilia na Aofia goꞋo Ꞌana neꞋe God, ma noaꞋa naꞋa ta god matamata laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma ngwae ki kira ke alafe nama ana God Ꞌania mangoda taꞋifau, ma Ꞌania na liada taꞋifau, ma Ꞌania na ngasingasilada taꞋifau. Ma kira ka alafe fuana ngwae ki taꞋifau ka diꞋia logo neꞋe kira ke alafe fuada talada. Ngwae neꞋe roꞋosulia ro taki neꞋeri ki, kira sasi ru talingaꞋi ka liufia kwatelana na kwaisuꞋusiꞋanga fuana God.” ");
INSERT INTO kwf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma sa Jesus ka lia saiana na liatoꞋongaꞋa nia, ma ka fata Ꞌuri fuana, “ꞋOko karangi naꞋa fuana God ke gwaungaꞋi fafia maurilamu.” Ma buri Ꞌana naꞋa, noaꞋa ta ngwae kasi noniraꞋa naꞋa fuana saefilolana sa Jesus laꞋu. ");
INSERT INTO kwf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ꞋUnaꞋeri sa Jesus ka faꞋamanata saena na Luma Abu God, nia ka saefilo Ꞌuri, “Nia faꞋuta neꞋe ngwae faꞋamanata ana na taki sa Moses ki, kira saea na Christ neꞋe ngwae ana na kwalafa sa David? ");
INSERT INTO kwf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na AnoꞋi ru Abu ba nia faꞋafata sa David ka Ꞌuri, ‘God nia fata Ꞌuri fuana Aofia nau: ꞋOko tua bali ꞋoloꞋolo aku, ma Ꞌoko gwaungaꞋi faꞋinau, masia kaidaꞋi nau kui alua malimae Ꞌoe ki ka roꞋosuliꞋo.’ ");
INSERT INTO kwf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Sa David ana talana neꞋe nia saea na Christ Ꞌani na ‘Aofia.’ Nia neꞋe, na Christ nia noaꞋa laꞋu Ꞌalako ana kwalafa sa David goꞋo Ꞌana. NiaꞋa Aofia nia logo.” Na fikuꞋa doe neꞋeri, kira saeleꞋa liu kaidaꞋi kira fafarongoa sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma sa Jesus ka faꞋamanatada ka Ꞌuri, “Muke madafi kamu faꞋasia na faꞋamanata ana taki sa Moses ki, sulia kira oga liuꞋa faꞋinia toro rengorengo keta ki. Ma kira ka oga liu logo fasi na ngwae ki kike faꞋaꞋinotoꞋada, ma ke fata leꞋaleꞋa fuada Ꞌi maana usiꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma kira ka oga tuaꞋa Ꞌi naꞋo ana kula ꞋinotoꞋa ni tuaꞋa ki saena luma fuana foꞋongaꞋa ki, ma ana kula leꞋa ki kaidaꞋi ana fangaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sui bore Ꞌana, ngwae neꞋe ki kira bilia na luma ma na ru gwaꞋi Ꞌuru ki toꞋo ani. Ma kira ka foꞋo keta fasi Ꞌiri na ngwae ki ke tangoda. ꞋIu, na ngwae faꞋamanata ana taki sa Moses ki neꞋe kwaꞋikwaꞋinga kira ke baꞋa taꞋa liu fuada!” ");
INSERT INTO kwf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa Jesus nia tua saena na Luma Abu God karangia na kufikufi ru fuana alu maniꞋa Ꞌi saena. Nia ka lisia ngwae neꞋe kira kwatea mani kira ki. Ma na ngwae Ꞌoro neꞋe kira toꞋoru ki kira ka kwatea mani Ꞌoro. ");
INSERT INTO kwf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui, nia ka lisia taꞋi gwaꞋi Ꞌuru dalaꞋa liu. Nia leka maꞋi, ma ka kwatea logo ro maga mani tiꞋitiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma sa Jesus ka saea maꞋi na fafarongo nia ki, ma ka fata Ꞌuri fuada, “Ru mamana nau ku saea fuaumulu, tae neꞋe na gwaꞋi Ꞌuru dalaꞋa neꞋe nia kwateꞋa, nia doe ka liufia ngwae ki taꞋifau neꞋe kira kwate mani doe. ");
INSERT INTO kwf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","OsiꞋana ngwae neꞋe kira toꞋoru ki, kira kwatea goꞋo Ꞌada kala bali tiꞋitiꞋi ana toꞋoruꞋa kira ki. Bore ma, gwaꞋi Ꞌuru dalaꞋa neꞋe, nia kwate taꞋifau naꞋa ana ru ki neꞋe nia toꞋo ani fuana tualana.” ");
INSERT INTO kwf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","KaidaꞋi sa Jesus nia faꞋasia na Luma Abu God, taꞋi ngwae ana fafarongo nia ki ka fata Ꞌuri fuana, “Ngwae faꞋamanata kwa, lisia basi na fau doe neꞋe ki, ma na luma leꞋa neꞋe ki ana Luma Abu God!” ");
INSERT INTO kwf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma sa Jesus ka olisia ka Ꞌuri, “ꞋIu, Ꞌoko oga na luma doe neꞋe ki ana Luma Abu God taka, ne baꞋa! NoaꞋa ta taꞋi gwaꞋi fau Ꞌi neꞋe ana Luma Abu God ke baꞋa teo laꞋu Ꞌi fuila. Kira taꞋifau kike baꞋa takalo Ꞌi ano.” ");
INSERT INTO kwf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma kaidaꞋi sa Jesus nia tua gwauna faꞋi ua Ꞌi Olif neꞋe nia tua bolo faꞋinia na Luma Abu God, sa Peter, ma sa James, ma sa John, ma sa Andrew taꞋifilida, kira leka maꞋi siana, ma kira ka saefilo Ꞌuri ana, ");
INSERT INTO kwf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ꞋOke saea basi fuaimili, Ꞌi angita neꞋe ru neꞋe ki ke baꞋa dao maꞋi? Ma ta tae neꞋe ke baꞋa fuli, fasi Ꞌiri ke faꞋataꞋinia kaidaꞋi fuana ru neꞋe ki taꞋifau ke fuli, ma ka dao Ꞌani?” ");
INSERT INTO kwf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma sa Jesus ka fata Ꞌuri fuada, “Kamu ke lialia leꞋa, ma noaꞋa kamu kasi alaꞋania ta ngwae ka talaꞋi rora amuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sulia neꞋe ngwae Ꞌoro ki kira ke baꞋa dao maꞋi Ꞌani sataku, ma kike fata Ꞌuri, ‘NauꞋa naꞋa neꞋe na Christ!’ Ma kike talaꞋi rora ana ngwae Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma kaidaꞋi kamu rongoa fuꞋanga ki, ma na alaꞋanga sulia na fuꞋanga ki, noaꞋa kamu kasi figwanu. Ru ꞋunaꞋeri ki ke baꞋa dao maꞋi, bore Ꞌana na Ꞌisilana ru ki taꞋifau noaꞋa Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na maꞋe fanoa ki kira ke fuꞋalida kwailiu, ma na ꞋinotoꞋanga ki kira ke fuꞋalida kwailiu. Ma na tikitiki ki ke liu ana kula ki taꞋifau, ma na unifioloꞋa ki ke liu. Ma ru neꞋeri ki kira neꞋe etangilana nonifiiꞋa, diꞋia goꞋo Ꞌana na kini faꞋafuta ba nia talaꞋae ka ngelafii. ");
INSERT INTO kwf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ma kaumulu ke lialia leꞋa. Ti ngwae ki ke baꞋa dau kaumulu, ma kira ke ngali kaumulu fuana na matalangaꞋi lamuꞋa. Kike baꞋa nangasi kamu Ꞌi saena na luma fuana foꞋongaꞋa ki. Sulia kamu faꞋamamana nau, kike kwate kamu ke uu Ꞌi naꞋofana na gwaungaꞋi ki ma na ngwae ꞋinotoꞋa ki. KaidaꞋi neꞋeri kamu ke faꞋarongoda Ꞌani nauꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma kamu ke fata sulia na FaꞋarongoꞋa LeꞋa fuana ngwae ki taꞋifau saena magalia. ");
INSERT INTO kwf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma kaidaꞋi kira ke dau kaumulu, ma kira ka ngali kamu Ꞌuana na matalangaꞋilamuꞋa, noaꞋa kamu kasi manata Ꞌabera Ꞌuana ta alaꞋanga faꞋuta neꞋe kamu ke saea. Kamu ke saea goꞋo amuꞋa ta alaꞋanga neꞋe AnoꞋi ru Abu nia kwatea fuaumulu ana kaidaꞋi neꞋeri. Sulia alaꞋanga ki neꞋe kamu ke baꞋa saea, nia noaꞋa laꞋu na fatalaumulu talamuꞋa. Na alaꞋanga neꞋeri ki, nia ka leka maꞋi faꞋasia na AnoꞋi ru Abu. ");
INSERT INTO kwf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma na ngwae ki, kike kwatea na ngwaefuta kira ki talada fuana saungilada. Ma na maꞋa ki, kira ke sasi ꞋunaꞋeri logo ana ngela kira ki. Ma na ngela ki, kira ke olisuꞋusuꞋu ma kike baꞋa kwatea na maꞋa ma teꞋa kira ki fuana saungilada. ");
INSERT INTO kwf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma na ngwae ki taꞋifau, kira ke baꞋa suulangaꞋi kaumulu, osiꞋana kaumulu na ngwae nau ki. ꞋIu, ma diꞋia sa tai neꞋe nia manata mamana aku ka dao ana faꞋi asoa isi, God ke baꞋa faꞋamauria. ");
INSERT INTO kwf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ma kaumulu ke baꞋa lisia na Ru Sua ke tataꞋe maꞋi ana kula abu neꞋe fuila noaꞋa nia kasi uu ana. Na ru taꞋa neꞋeri ke faꞋasua na Luma Abu God, ma ke sasi Ꞌiri God ke malangisia.” (Na alaꞋanga fuana na ngwae neꞋe nia toꞋomaꞋi nia Ꞌuri: ꞋOko malingaꞋi leꞋa ana na fadalana ru neꞋe.) “KaidaꞋi muke lisia na ru neꞋe ki ke dao maꞋi, na ngwae ki neꞋe kira tua ana na abaꞋi kula Ꞌi Judea, kira ke tafi Ꞌuana gwauna faꞋi ua ki. ");
INSERT INTO kwf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma ta ngwae neꞋe Ꞌoko tua Ꞌi gwaofana luma, tafi naꞋa, noaꞋa Ꞌoe kosi koso laꞋu maꞋi Ꞌuana saena na luma Ꞌoe fuana ngalilana ta ru. ");
INSERT INTO kwf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma na ngwae neꞋe Ꞌoko tua Ꞌi saena na oꞋola Ꞌoe, tafi naꞋa, noaꞋa Ꞌoe kosi oli laꞋu Ꞌi fanoa Ꞌuana na toro keta Ꞌoe. ");
INSERT INTO kwf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma ana faꞋi asoa neꞋeri ki, nia ke baꞋa taꞋa fuana na Ꞌafe ina ki, osiꞋana neꞋe nia ꞋafitaꞋi fuada neꞋe kike tafi, ma ka taꞋa logo fuana na Ꞌafe ki neꞋe kira toꞋo ana na ngela tiꞋitiꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kamu ke foꞋo fuana God fasi Ꞌiri ru neꞋeri ki noaꞋa kasi dao laꞋu maꞋi ana kaidaꞋi ana unuꞋi gwariꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","DuꞋungana na nonifiiꞋanga ana faꞋi asoa neꞋeri ki, nia ke baꞋa taꞋa ka liufia na nonifiiꞋanga neꞋe ngwae saena magalia ki kira saiana, Ꞌita Ꞌua maꞋi ana safalilana kaidaꞋi God nia saungaꞋinia na magalia ka dao ana kaidaꞋi neꞋe. Ma nia noaꞋa naꞋa ta ru ꞋunaꞋeri neꞋe ke fuli maꞋi Ꞌi buri. ");
INSERT INTO kwf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma diꞋia God kasi faꞋadokodokoa kaidaꞋi ana nonifiiꞋanga, nia ꞋafitaꞋi neꞋe ta ngwae ke mauri. Ma nia faꞋadokodokoa kaidaꞋi neꞋeri fuana leꞋalana ngwae neꞋe nia filida ki. ");
INSERT INTO kwf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ꞋIu, diꞋia ta ngwae fata Ꞌuri fuaumulu, ‘Lisia basi, nia naꞋa neꞋe na Christ,’ nama ka fata Ꞌuri, ‘Lisia basi, nia naꞋa Ꞌi loꞋoko,’ noaꞋa kamu kasi faꞋamamana nia. ");
INSERT INTO kwf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sulia na ngwae ꞋosoꞋoso ki ke baꞋa dao maꞋi, kira ke fata Ꞌuri, ‘NauꞋa na Christ,’ faꞋinia na ngwae ꞋosoꞋoso ki kira ke fata Ꞌuri, ‘NauꞋa na profet.’ Ma kira ke sasia faꞋanadaꞋa ki fasi Ꞌiri ke talaꞋi rora ana na ngwae neꞋe God nia filida ki, bore ma nia ꞋafitaꞋi liu fuada. ");
INSERT INTO kwf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kamu ke lialia leꞋa! Nau ku faꞋarongo kaumulu naꞋa Ꞌi naꞋo, sui mala ru neꞋe ki ka fiꞋi dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma kaidaꞋi neꞋe nonifiiꞋanga neꞋeri ke sui, ‘God ke fonea na madaꞋafi, ma na madamo, ma noaꞋa keroꞋa kasi sina. ");
INSERT INTO kwf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma God ke sasi na bulubulu ki, kira ke baꞋa Ꞌasida faꞋasia mamanga. Ma God ke sasi na ru Ꞌi langi ki, kira ke leka rora faꞋasia fulida.’ ");
INSERT INTO kwf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“ꞋUnaꞋeri mala, nauꞋa na Ngela Ngwae, nau ku fiꞋi dao tafa maꞋi. Nau kui dao maꞋi faꞋinia na ngasingasiꞋanga doe, ma na ngwasinasinaꞋanga doe Ꞌi fafona na gwaꞋi salo ki. ");
INSERT INTO kwf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma nau kui baꞋa kwatea na Ꞌainsel nau ki saena magalia taꞋifau, fasi Ꞌiri kira ke ukua maꞋi na ngwae neꞋe God filida ki.” ");
INSERT INTO kwf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","GoꞋo, sa Jesus ka fata sulia tarifulaꞋa ka Ꞌuri, “Kamu ke manata basi sulia na Ꞌai figi ki. KaidaꞋi kamu lisia na rauna nia ngosa, muke saiana na kaidaꞋi fuana unitaꞋi ꞋakoꞋakoꞋa nia dao karangi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka ꞋunaꞋeri logo, kaidaꞋi kamu lisia na nonifiiꞋanga neꞋeri ki ke baꞋa dao maꞋi, muke saiana na olilaku maꞋi nia karangi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ru mamana neꞋe nau ku saea fuamuꞋa, ngwae ki taꞋifau neꞋe kira mauri ana kaidaꞋi neꞋe, noaꞋa kira kasi mae Ꞌi naꞋona ru neꞋeri ki taꞋifau ke baꞋa dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ꞋI langi ma na magalia neꞋe ke baꞋa sui, bore ma fatalaku noaꞋa kasi sui. ");
INSERT INTO kwf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“NoaꞋa ta ngwae kasi saiana kaidaꞋi mamana neꞋe nau kui oli maꞋi ana. Na Ꞌainsel ki Ꞌi langi bore noaꞋa kasi saiana, ma nauꞋa na Ngela bore, noaꞋa naisi sai logo ana. God na MaꞋa taꞋifilia goꞋo neꞋe nia saiana. ");
INSERT INTO kwf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kamu ke lialia leꞋa, ma muke kwaimasi, sulia kamu kina Ꞌi angita neꞋe kaidaꞋi neꞋeri ke dao maꞋi ana. ");
INSERT INTO kwf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na olilaku maꞋi neꞋe ke diꞋia ta ngwae neꞋe nia leka ana fanoa tau, ma ka alua na luma nia saena limana na ngwae ni rao nia ki. Nia kwatea raoꞋa ki fuada toꞋotoꞋo. Ma nia ka saea fuana na ngwae neꞋe nia lia sulia sinamaa fasi Ꞌiri ke lialia leꞋa masia daolana. ");
INSERT INTO kwf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nia neꞋe, kamu ke lialia leꞋa, sulia nia noaꞋa kamu kasi saiana na kaidaꞋi neꞋe nai baꞋa dao maꞋi, diꞋia ngwae ꞋaꞋana ana luma. Nia ke dao maꞋi saꞋulafi taka, nama saena tofongana na rodo, nama kalokaloꞋa, nama Ꞌofodangi kaidaꞋi sina fiꞋi raꞋe maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma diꞋia nia dao ꞋaliꞋali goꞋo maꞋi, nia ka taꞋa liu fuamuꞋa, diꞋia nia dao toꞋomulu kaidaꞋi neꞋe kamu maliu. ");
INSERT INTO kwf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma ta ru neꞋe nau ku saea fuaumulu, na ru ba nau ku saea logo fuana na ngwae ki taꞋifau nia Ꞌuri: Kamu ke lialia leꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ro faꞋi asoa ki Ꞌi naꞋona na FangaꞋa DaofaꞋi LiuꞋa, ma na fangaꞋa neꞋe Jiu ki kira saiana Ꞌanilana na beret neꞋe nia noaꞋa ta isi Ꞌi saena. Na fata abu doe ki, ma na ngwae faꞋamanata ana taki ki, kira ka fiku lokoꞋi ru fuana dau agolana ma saungilana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kira fata Ꞌuri, “NoaꞋa kulu kasi sasia ana kaidaꞋi ana FangaꞋa, Ꞌasu Ꞌubani na ngwae ki kira ka fiꞋi fuꞋalikulu.” ");
INSERT INTO kwf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ana kaidaꞋi sa Jesus nia tua Ꞌi saena maꞋe fanoa Ꞌi Betani, nia ka fanga Ꞌi saena luma sa Simon na ngwae neꞋe kuu nia saungia Ꞌi naꞋo. Ma taꞋi kini ka leka maꞋi siana faꞋinia na biꞋi nura neꞋe kwanga liu, ma nia fungu Ꞌani na ngwaingwai neꞋe moko ufiufi leꞋa, ma na folilana ka doe liu. Nia Ꞌifingia na maana biꞋi nura neꞋeri, ma ka kisitani naꞋa ngwaingwai moko leꞋa neꞋeri fafona gwauna sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma ti ngwae neꞋe kira tua Ꞌi neꞋeri, kira ka saetaꞋa, ma kira ka fata fuada kwailiu kira ka Ꞌuri, “Fuila noaꞋa nia kasi faꞋalia na ngwaingwai moko leꞋa neꞋe re! ");
INSERT INTO kwf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Fuila nia ka Ꞌoifoli Ꞌani Ꞌuana ti mani Ꞌoro, fasi Ꞌiri nia ke ngalia mani neꞋeri, ma ka kwatea fuana na ngwae dalaꞋa ki.” Ma kira ka balufia kini neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ꞋUnaꞋeri sa Jesus nia ka rongoa, ma ka fata Ꞌuri, “Mulu alua nia tua Ꞌana! NoaꞋa kamu kasi fata faꞋalia laꞋu. Nia sasia raoꞋa leꞋa liu fuaku. ");
INSERT INTO kwf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na ngwae dalaꞋa ki kira tua tari goꞋo Ꞌada faꞋi kamu. Ma diꞋia kamu oga, kamu ke Ꞌafida goꞋo amuꞋa ana ta kaidaꞋi. Bore ma nau noaꞋa kusi tua tau goꞋo faꞋi kamu. ");
INSERT INTO kwf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nia sasia ru neꞋe nia bolo faꞋinia sasilana. Nia kisitaꞋinia na ngwaingwai moko leꞋa neꞋe Ꞌi noniku Ꞌi naꞋo ana maelaku fuana sasi akaꞋu Ꞌanga fuana kwaiatolaku. ");
INSERT INTO kwf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ru mamana nau ku saea fuamuꞋa, ana kula ki taꞋifau saena magalia neꞋe kira ke alaꞋa sulia na FaꞋarongoꞋa LeꞋa neꞋe, kira ke baꞋa alaꞋa logo sulia ru neꞋe nia sasia aku fuana manataꞋanga toꞋona.” ");
INSERT INTO kwf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui sa Judas Iskariot, taꞋi ngwae ana na akwala ma ro fafarongo nia ki, nia leka fuana na fata abu doe ki, ka faꞋarongoda Ꞌuri, “Nai baꞋa kwatea sa Jesus fuaumulu.” ");
INSERT INTO kwf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma kira ka saeleꞋa liu sulia ru neꞋe nia saea, ma kira ka alangaꞋi fuana kwatelana selene fuana. Ma sa Judas ka talaꞋae naꞋa fuana liaꞋa Ꞌuana ta kaidaꞋi leꞋa fuana kwatelana sa Jesus fuada. ");
INSERT INTO kwf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ana etana faꞋi asoa ana FangaꞋa ana beret neꞋe nia noaꞋa ta isi Ꞌi saena, faꞋi asoa neꞋeri neꞋe kira saungia kala sipsip fuana na FangaꞋa ana DaofaꞋi LiuꞋa. KaidaꞋi neꞋeri, fafarongo sa Jesus ki kira ka saefilo Ꞌuri ana, “ꞋI fai neꞋe Ꞌoko oga kaimili ke leka ma mika sasi akaꞋu ana na FangaꞋa ana DaofaꞋi LiuꞋa fuamu?” ");
INSERT INTO kwf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma sa Jesus ka fata fuana ta ro ngwae ada ka Ꞌuri, “Moro ruꞋu saena Ꞌi Jerusalem, ma taꞋi ngwae neꞋe nia ngalia na faꞋi kafo, nia ke baꞋa saka fuamuroꞋo. Moke leka Ꞌi burina ");
INSERT INTO kwf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ꞌuana ta luma Ꞌi neꞋeri neꞋe nia ruꞋu Ꞌi saena. Moro ke saefilo Ꞌuri ana na ngwae neꞋe nia toꞋo ana na luma neꞋana, ‘Na ngwae FaꞋamanata nia saea neꞋe maꞋe luma Ꞌi faꞋi neꞋe nia ke Ꞌania na FangaꞋa ana DaofaꞋi LiuꞋa faꞋinia na fafarongo nia ki?’ ");
INSERT INTO kwf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma nia ke baꞋa faꞋataꞋinia taꞋi maꞋe luma doe neꞋe nia tua Ꞌi lifua. ꞋI neꞋeri na ru ki taꞋifau nia kwaimaꞋakwali naꞋa. Ma moro ka sasi akaꞋu ana na ru ki taꞋifau fuakulu Ꞌi neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ꞋUnaꞋeri ma, na ro fafarongo neꞋeri ki kera leka, ma kera ka ruꞋu naꞋa Ꞌi Jerusalem, ma kera ka lisia na ru ki taꞋifau nia diꞋia nama neꞋe sa Jesus nia saea fuadaroꞋo. Ma kera ka sasi akaꞋu ana ru ki taꞋifau fuana FangaꞋa ana DaofaꞋi LiuꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma nia saꞋulafi naꞋa, sa Jesus ka dao maꞋi faꞋinia na akwala ma ro fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma kaidaꞋi kira fanga, sa Jesus ka fata Ꞌuri, “Na ru mamana nau ku saea fuaumulu, taꞋi ngwae aumulu ke baꞋa kwate nau fuana na malimae nau ki. TaꞋi ngwae aumulu neꞋe nia fanga goꞋo Ꞌana faꞋinau ana kaidaꞋi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma na fafarongo nia ki, kira ka talaꞋae naꞋa ana liadilaꞋanga, ma kira ka saefiloa sa Jesus, taꞋi taꞋi ngwaeꞋa, ma kira ka Ꞌuri, “NoaꞋa naisi kwateꞋo fuana malimae Ꞌoe ki kwa!” ");
INSERT INTO kwf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma sa Jesus nia olisida ka Ꞌuri, “Nia neꞋe taꞋi naꞋa aumulu na akwala ma ro fafarongo nau ki, ma nia ta ngwae neꞋe ke alua afu beret nia Ꞌi saena na dako faꞋinau. ");
INSERT INTO kwf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma nau, na Ngela Ngwae, nai baꞋa mae diꞋia na KerekereꞋa Abu ki ba fata suli nau. ꞋUnaꞋeri bore ana, kwaimanatai liu fuana na ngwae neꞋe ke baꞋa kwate nau fuana na malimae nau ki! Nia leꞋa fuana na ngwae neꞋeri diꞋia nia noaꞋa kasi futafuta goꞋo.” ");
INSERT INTO kwf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma kaidaꞋi kira fanga naꞋa, sa Jesus nia ngalia taꞋi afu beret, ma ka baꞋatafea God, sui ka ngiia. Nia ka kwatea fuana na fafarongo nia ki, ka fata Ꞌuri, “Ngalia muke Ꞌania. Nia naꞋa neꞋe noniku.” ");
INSERT INTO kwf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui nia ka ngalia na titiu Ꞌi waen, ma ka baꞋatafea God, sui ka kwatea fuada. Ma kira taꞋifau kika kwaꞋu ana. ");
INSERT INTO kwf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma nia ka fata Ꞌuri, “Nia naꞋa neꞋe Ꞌabuku neꞋe nia igo fuana ngwae Ꞌoro ki fuana faꞋangasilana na fau alangaꞋinga faolu God. ");
INSERT INTO kwf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ru mamana nau ku saea fuaumulu, nau noaꞋa kusi kwaꞋufia naꞋa na waen neꞋe leleka ka dao ana faꞋi asoa nau kui kwaꞋufia laꞋu na waen neꞋe, kaidaꞋi God ke gwaungaꞋi fafia ngwae ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Buri Ꞌana kira ka ngulia faꞋi ngu, sui kira ka leka Ꞌuana na ua Ꞌi Olif. ");
INSERT INTO kwf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sa Jesus ka fata Ꞌuri fuada, “Kaumulu taꞋifau goꞋo neꞋe kamu ke baꞋa tafi faꞋasi nau. Sulia na KerekereꞋa Abu nia fata Ꞌuri, ‘God ke saungia ngwae neꞋe nia lia sulia na sipsip ki, ma na sipsip ki taꞋifau kira ka takalo.’ ");
INSERT INTO kwf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ka ꞋunaꞋeri bore Ꞌana, Ꞌi buri Ꞌana nau kui tataꞋe laꞋu Ꞌuana mauriꞋa, nau kui etaeta Ꞌi naꞋo aumulu Ꞌuana Ꞌi Galili.” ");
INSERT INTO kwf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma sa Peter nia olisia ka Ꞌuri, “Nia ꞋafitaꞋi liu neꞋe nau kui leka faꞋasiꞋo, sui bore Ꞌana ngwae ki taꞋifau kira ke leka faꞋasiꞋo!” ");
INSERT INTO kwf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma sa Jesus ka fata Ꞌuri fuana sa Peter, “Nau ku saea fuamu. NaꞋona na karai ke angi ro ru saena rodo neꞋe Ꞌi taꞋena, Ꞌoke tofe uulufau Ꞌoko kina nau.” ");
INSERT INTO kwf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma sa Peter nia olisi ngasingasiꞋa ana ka Ꞌuri, “Sui bore Ꞌana nau ku mae faꞋi Ꞌoe, nia ꞋafitaꞋi nau ku saea fasi nau ku kina Ꞌoe!” Ma na fafarongo ki taꞋifau goꞋo neꞋe, kira saea logo taꞋi ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sui sa Jesus faꞋinia na fafarongo nia ki, kira ka leka Ꞌuana taꞋi kula kira saea Ꞌani Ꞌi Getsemani. KaidaꞋi kira dao naꞋa, sa Jesus ka fata Ꞌuri fuada, “Kamu ke tua Ꞌaumulu Ꞌi neꞋe kaidaꞋi nau kui foꞋo Ꞌaku.” ");
INSERT INTO kwf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui nia ka talaꞋia sa Peter, ma sa James, ma sa John faꞋinia. Ma nia ka kwaimanatai liu ma ka liadila. ");
INSERT INTO kwf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma nia ka fata Ꞌuri fuada, “Na liaku nia figwanu ka doe liu, ma nia bolo faꞋinia naꞋa saungilaku. Muke tua Ꞌi neꞋe, kamu ka ada, ma muke lialia faꞋinau.” ");
INSERT INTO kwf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma nia ka Ꞌidu tiꞋitiꞋi kwau, ma ka bobo uruuru Ꞌi ano. Ma nia ka foꞋo fasi Ꞌiri diꞋia nia talangwaraꞋu goꞋo Ꞌana, kwate noaꞋa nia kasi liu saena kaidaꞋi ana nonifiiꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma nia ka foꞋo ka Ꞌuri, “MaꞋa Ꞌae, na ru ki taꞋifau nia talangwaraꞋu goꞋo Ꞌana fuamu. ꞋOke lafua Ꞌamu na nonifiiꞋanga neꞋe faꞋasi nau. Sui bore Ꞌana, nia noaꞋa laꞋu na kwaiogaiꞋanga nau, bore ma sulia kwaiogaiꞋanga Ꞌoe lala.” ");
INSERT INTO kwf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui sa Jesus ka oli maꞋi, ma ka dao toꞋona na uulu fafarongo nia ki, kira maliu goꞋo Ꞌada. Ma nia ka fata Ꞌuri fuana sa Peter, “Simon Ꞌae, faꞋuta neꞋe Ꞌoko maliu kwa? Fuila Ꞌoke ada faꞋinau sulia ta taꞋi agi rodo tiꞋitiꞋi bore Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma nia ka fata Ꞌuri fuada, “Kamu ke ada, muke lialia Ꞌani foꞋongaꞋa sasi na ilitoꞋonga kata liufi kamu. Sulia kaumulu oga sasilana ru leꞋa ki, bore ma nonimuꞋa nia ngwataꞋutaꞋu liu.” ");
INSERT INTO kwf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma sa Jesus ka leka laꞋu faꞋasida, ma ka foꞋo, ma ka saea logo taꞋi alaꞋanga ba kiri. ");
INSERT INTO kwf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui nia ka oli laꞋu maꞋi fuada, ma ka dao toꞋoda kira maliu laꞋu, sulia neꞋe maada mamaliuꞋa liu. Ma noaꞋa kira kasi sai naꞋa ana na ru neꞋe kira ke saea fuana. ");
INSERT INTO kwf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma kaidaꞋi nia oli laꞋu maꞋi ana uula kaidaꞋi, nia ka fata Ꞌuri fuada, “Kaumulu maliu Ꞌua niniꞋa? Nia leꞋa naꞋa! Lia basi, kira ke kwate nau naꞋa, na Ngela Ngwae, saena limana na ngwae taꞋa ki. Na kaidaꞋi baera nia dao naꞋa maꞋi! ");
INSERT INTO kwf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","TataꞋe, kulu leka naꞋa. Lia basi, na ngwae ba nia kwate nau fuana na malimae nau ki, nia dao naꞋa maꞋi!” ");
INSERT INTO kwf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ana kaidaꞋi sa Jesus nia alaꞋa goꞋo Ꞌana, sa Judas, taꞋi ngwae ana na akwala ma ro fafarongo nia ki, ka dao naꞋa maꞋi. TaꞋi fikuꞋa doe leka maꞋi faꞋinia faꞋasia na fata abu doe ki, ma na faꞋinaꞋonaꞋo ki, ma na ngwae faꞋamanata ana taki ki. Ma kira ka ngalia maꞋi na sele ni ofoꞋa ki ma na subi ki. ");
INSERT INTO kwf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma sa Judas, na ngwae neꞋe ke kwate sa Jesus fuada, nia ka kwatea na maꞋetoto fuana fikuꞋa neꞋeri ka Ꞌuri, “Na ngwae neꞋe nau kui nonoꞋia, na ngwae neꞋe kamu oga. Kamu ke daua, ma kamu ke talaꞋia kwau.” ");
INSERT INTO kwf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ꞋUnaꞋeri, sa Judas nia dao, nia ka leka naꞋa kwau siana sa Jesus, ma ka fata Ꞌuri, “Ngwae FaꞋamanata Ꞌae!” GoꞋo, nia ka nonoꞋia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma kira ka daua naꞋa sa Jesus, ma kira ka loba. ");
INSERT INTO kwf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ꞋIu, ma ana kaidaꞋi neꞋeri, taꞋi ngwae neꞋe nia tataꞋe karangi goꞋo ana, nia lafua naꞋa sele nia, ma ka kwaꞋi muusia na alingana na ngwae rao ꞋingataꞋi fata abu. ");
INSERT INTO kwf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma sa Jesus ka saefilo Ꞌuri ada, “ꞋUri ma kaumulu fia nauꞋa ta ngwae bili niniꞋa? Nia niniꞋa muka dao naꞋa maꞋi faꞋinia na sele ki, ma na subi ki fuana daulaku? ");
INSERT INTO kwf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tau naꞋa maꞋi, nau ku faꞋamanata kamu Ꞌi saena na Luma Abu God, bore ma noaꞋa kamu kasi dau nau goꞋo. Ma na ru niniꞋa kamu sasia, nia faꞋamamana na KerekereꞋa Abu.” ");
INSERT INTO kwf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ꞋUnaꞋeri goꞋo, fafarongo nia ki taꞋifau kira ka faꞋasia, ma kira ka tafi naꞋa Ꞌada. ");
INSERT INTO kwf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma taꞋi ngwae fiꞋi doe neꞋe nia toro goꞋo ana na toro folo, nia leka maꞋi buri Ꞌana sa Jesus. Ana kaidaꞋi kira daua naꞋa ngwae fiꞋi doe neꞋe, ");
INSERT INTO kwf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na toro nia ka angosi naꞋa faꞋasia, ma nia ka tafi dadara naꞋa Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ꞋUnaꞋeri, kira ka talaꞋia sa Jesus Ꞌuana luma ꞋingataꞋi fata abu. Ma na fata abu doe ki, ma na faꞋinaꞋonaꞋo ki, ma na ngwae faꞋamanata ana na taki ki, kira fiku Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma sa Peter nia Ꞌisi buri tau naꞋa kwau, ma ka ruꞋu logo saena na faꞋi labu ana luma na ꞋingataꞋi fata abu. Nia ka tua Ꞌana Ꞌi neꞋeri faꞋinia na ngwae folo ki, ma nia ka rara Ꞌana Ꞌi ninimana na mafula. ");
INSERT INTO kwf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","GoꞋo, na fata abu doe ki, ma na fikutaꞋi ngwae lokoꞋi ru taꞋifau, kira ka sasi Ꞌuana daoꞋa toꞋona ta ru taꞋa fuana fafilana ana sa Jesus fasi Ꞌiri kira ke saungia, bore ma kira kasi dao toꞋona goꞋo ta ru ana niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma na ngwae Ꞌoro ki, kira ka soke fafia sa Jesus, bore ma alaꞋanga kira ki noaꞋa kasi alu taꞋi ru. ");
INSERT INTO kwf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma ti ngwae kira tataꞋe logo, ma kira ka soke fuana sa Jesus kira ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kaimili rongoa nia fata Ꞌuri, ‘Nau kui baꞋa osia na Luma Abu God neꞋe ngwae ki kira saungaꞋinia, ma Ꞌi saena uulu faꞋi asoa ki, nau kui saungaꞋinia laꞋu ta Luma Abu neꞋe noaꞋa laꞋu na ngwae ki neꞋe kira saungaꞋinia.’” ");
INSERT INTO kwf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma kiraꞋa bore, na alaꞋanga kira ki noaꞋa kasi alu taꞋi ru. ");
INSERT INTO kwf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma na ꞋingataꞋi fata abu nia uu Ꞌi naꞋoda, ma nia ka lidia sa Jesus ka Ꞌuri, “ꞋUri ma, noaꞋa Ꞌoe kosi toꞋo goꞋo ana ta alaꞋanga fuana olisilana alaꞋanga neꞋe ki, neꞋe ngwae neꞋe ki kira fai fafiꞋo Ꞌania?” ");
INSERT INTO kwf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bore ma sa Jesus noto goꞋo Ꞌana, ma ka noaꞋa kasi olisia goꞋo. Ma na ꞋingataꞋi fata abu nia saefiloa laꞋu ka Ꞌuri, “ꞋUri ma, ꞋaeꞋo neꞋe na Christ baera, na Ngela God?” ");
INSERT INTO kwf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma sa Jesus ka olisia ka Ꞌuri, “ꞋIu, nauꞋa neꞋe niaꞋa. Ma Ꞌoke baꞋa lisia nauꞋa, na Ngela Ngwae, ke tua Ꞌi bali lima ꞋoloꞋolo ana na God ngasingasiꞋa. Nai baꞋa gwaungaꞋi faꞋinia, ma nau kui oli maꞋi faꞋasia Ꞌi langi fafona na gwaꞋi salo ki.” ");
INSERT INTO kwf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","GoꞋo na ꞋingataꞋi fata abu neꞋeri nia ka gasia na toro keta nia talana ka faꞋataꞋinia na saetaꞋanga nia, ma ka fata Ꞌuri, “Kulu kasi oga laꞋu ta ngwae ni fata faꞋamamana! ");
INSERT INTO kwf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kaumulu tala rongoa naꞋa nia faꞋabolotaꞋinia faꞋinia God! Kamu manata faꞋuta ana?” Ma kira taꞋifau goꞋo, kira ka saea fasi nia rora naꞋa, ma nia bolo faꞋinia kira ke saungia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma ti ngwae ada kira ka talaꞋae fuana ngisulilana sa Jesus, ma kira ka firi bokota na maana, ma kira ka kumua. Ma kira ka fata Ꞌuri, “Saea basi sa tai neꞋe nia kumuꞋu?” Ma na ngwae folo ki kira ka talaꞋia, ma kira ka suulangani kwai liu ana. ");
INSERT INTO kwf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa Peter nia tua Ꞌua goꞋo Ꞌana Ꞌi saena faꞋi labu, kaidaꞋi kira matalangani sa Jesus. TaꞋi kini sariꞋi rao fuana ꞋingataꞋi fata abu nia dao maꞋi. ");
INSERT INTO kwf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma kaidaꞋi nia lisia sa Peter neꞋe nia rara Ꞌana, nia ka lia saga kwau fuana, ma ka fata Ꞌuri, “ꞋOko tua logo faꞋinia sa Jesus, na ngwae ba faꞋasia na maꞋe fanoa Ꞌi Nasaret.” ");
INSERT INTO kwf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma sa Peter nia tofe ka Ꞌuri, “Nau ku kina, nau kusi saiana ru neꞋe Ꞌoke fata sulia.” Ma nia ka ruꞋu kwau ana maꞋe taꞋelo. Ma ana kaidaꞋi neꞋe goꞋo, na karai ka angi naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma na kini sariꞋi rao baera nia lisia laꞋu Ꞌi neꞋeri, ma ka fata Ꞌuri fuana ngwae ki neꞋe kira uu kalikalia Ꞌi neꞋeri, “Nia ta ngwae logo ada ne!” ");
INSERT INTO kwf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma sa Peter ka tofea logo. Ma kaidaꞋi tiꞋitiꞋi Ꞌi buri Ꞌana, na ngwae ki neꞋe kira uu karangi, kira ka fata Ꞌuri laꞋu fuana sa Peter, “Nia ꞋafitaꞋi liu Ꞌoko tofea fasi ꞋaeꞋo noaꞋa laꞋu ta ngwae ada, sulia ꞋaeꞋo logo neꞋe Ꞌoko leka maꞋi faꞋasia na abaꞋi kulu Ꞌi Galili.” ");
INSERT INTO kwf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui sa Peter ka talitali ka Ꞌuri, “Alu God ke kwatea na kwaꞋikwaꞋinga fuaku, diꞋia nau kusi fata mamana! Nau noaꞋa kusi saiana na ngwae neꞋe kamu fata sulia!” ");
INSERT INTO kwf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma ana kaidaꞋi neꞋeri goꞋo, na karai ka ruana fai angiꞋa naꞋa. Ma sa Peter ka manata toꞋona na alaꞋanga ba sa Jesus nia saea fuana ba nia Ꞌuri, “ꞋI naꞋona na karai ka angi ro fau, Ꞌoko sae uulu fau ana, Ꞌoko kina nau.” Ma kaidaꞋi sa Peter nia manata toꞋona ru neꞋeri, nia ka angi ikaika naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana Ꞌofodangi laꞋa bilabila, na fikutaꞋi ngwae lokoꞋi ru kira fiku ꞋaliꞋali maꞋi. GoꞋo na fata abu doe ki, ma na faꞋinaꞋonaꞋo ki, ma na ngwae faꞋamanata ana taki sa Moses ki, kira Ꞌi saena fikutaꞋi ngwae neꞋe. Kira fiku lokoꞋi ru fuana tae neꞋe kira ke sasi ana sa Jesus. Sui kira ka firiꞋia sa Jesus Ꞌani sene, ma kira ka talaꞋia kwau fuana kwatelana fuana sa Paelat, na ngwae doe faꞋasia Ꞌi Rom. ");
INSERT INTO kwf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma sa Paelat ka saefiloa ka Ꞌuri, “ꞋUri ma ꞋaeꞋo neꞋe tatalafaꞋa ngwae Ꞌi Jiu ki kwa?” Ma sa Jesus ka olisia ka Ꞌuri, “Nia neꞋana Ꞌoko saea naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na fata abu doe ki kira ka fai fafia ana ru rora Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma sa Paelat ka saefiloa laꞋu ka Ꞌuri, “ꞋOke rongoa basi na ru Ꞌoro ki neꞋe kira fai fafiꞋo naꞋa Ꞌani! ꞋUri ma Ꞌoe kosi olisida laꞋu kwa?” ");
INSERT INTO kwf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bore ma sa Jesus noaꞋa kasi saea goꞋo ta alaꞋanga, ma sa Paelat ka Ꞌarefo liu. ");
INSERT INTO kwf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ꞋIu, ana na FangaꞋa ana DaofaꞋi LiuꞋa, sa Paelat nia ꞋidufaꞋi logea taꞋi ngwae faꞋasia na lokafo neꞋe ngwae ki kira gani Ꞌuana. ");
INSERT INTO kwf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma ana kaidaꞋi neꞋeri, taꞋi ngwae neꞋe satana sa Barabas nia tua logo Ꞌi saena lokafo, osiꞋana nia logo neꞋe taꞋi ana ngwae taꞋa neꞋe kira sau ngwae ana fuꞋanga faꞋinia ngwae Rom ki. ");
INSERT INTO kwf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ꞋUnaꞋeri na fikuꞋa ki kira fiku maꞋi, kira ka gania sa Paelat fuana ke logea taꞋi ngwae faꞋasia na lokafo sulia falafala neꞋe nia ꞋidufaꞋi sasia maꞋi ana kaidaꞋi ꞋunaꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma nia ka saefilo kira ma ka Ꞌuri, “ꞋUri ma kaumulu oga nau kui logea na tatalafaꞋa Jiu ki fuamuꞋa?” ");
INSERT INTO kwf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sulia sa Paelat saiana naꞋa neꞋe fata abu doe ki kira kwatea maꞋi sa Jesus siana, duꞋungana manataꞋi ngwae ogalaꞋa kira goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bore ma, na fata abu doe ki kira fataliana na fikuꞋa neꞋeri, fasi Ꞌiri kike gania sa Paelat fuana logelana maꞋi sa Barabas fuada. ");
INSERT INTO kwf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma sa Paelat ka saefilo laꞋu Ꞌuri ana na fikuꞋa neꞋeri, “ꞋIrai ma ta tae neꞋe nau kui sasia ana na ngwae neꞋe kamu saea Ꞌani tatalafaꞋa Jiu ki?” ");
INSERT INTO kwf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma kira ka ako kira ka Ꞌuri, “ꞋOke fotofafia ana Ꞌai rara folo!” ");
INSERT INTO kwf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma sa Paelat nia saefiloda ka Ꞌuri, “Ta roraꞋa tae neꞋe nia sasia?” Ma kira ka ako doe liu laꞋu, kira ka Ꞌuri, “Fotofafia ana Ꞌai rara folo!” ");
INSERT INTO kwf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma sa Paelat ka logea kwau sa Barabas fuada, sulia nia oga ke faꞋasaeleꞋa na manatalana na fikuꞋa neꞋeri. Sui, nia ka kwatea sa Jesus fuana na nangasilana, ma ka kwatea fuana fotoꞋilana Ꞌi tufungana na Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na ngwae ana ofoꞋa ki, kira ka talaꞋia naꞋa kwau sa Jesus Ꞌi saena na faꞋi labu ana luma doe sa Paelat, ma kira ka karumia maꞋi na ngwae ana ofoꞋa ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma kira ka faꞋaruꞋufia Ꞌani taꞋi ifi boraboraꞋa keta, ma kira ka Ꞌerea na taꞋi Ꞌeregwau ana kwalo ngarangaraꞋa, ma kira ka duꞋua Ꞌani gwauna diꞋia ta tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui kira ka ilifaꞋinia na faꞋadoelana ma kira ka fata Ꞌuri, “Na tatalafaꞋa Jiu ki, Ꞌoke mauri tau amu!” ");
INSERT INTO kwf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui kira ka kwaiꞋia gwauna Ꞌani afu Ꞌai, ma kira ka ngisulia, ma kira ka bobo uruuru Ꞌi naꞋona, diꞋia neꞋe kira faꞋadoea. ");
INSERT INTO kwf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma kaidaꞋi neꞋe kira ngongoa ka sui naꞋa, kira ka kanusua na ifi boraboraꞋa keta nia faꞋasia. Sui kira ka faꞋaruꞋufia laꞋu Ꞌani ifi nia talana. ꞋUnaꞋeri kira ka talaꞋia naꞋa fuana na fotoꞋilana ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma ana kaidaꞋi kira leka kwau sulia na tala, kira dao toꞋona taꞋi ngwae satana sa Simon, maꞋa sa Aleksanda, faꞋinia sa Rufus. NiaꞋa na ngwae faꞋasia na fanoa Ꞌi Saeren. Nia leka maꞋi ma ka ruꞋu saena Ꞌi Jerusalem faꞋasia taꞋi kula maꞋi Ꞌi maa. Ma na ngwae ana ofoꞋa ki, kira ka suꞋumaꞋinia fasi Ꞌiri nia ngalia na Ꞌai rara folo sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma kira ka talaꞋia kwau sa Jesus Ꞌuana taꞋi kula neꞋe kira saea Ꞌani Ꞌi Golgota. Ma fadalana neꞋe Ꞌuri, “Na Lasi Ngwae.” ");
INSERT INTO kwf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma kira ka kwatea na waen neꞋe kira dola faꞋinia ru neꞋe kira saea Ꞌani Mira, taꞋi suluꞋi ru fuana faꞋamabelana fiiꞋa, bore ma sa Jesus noaꞋa kasi kwaꞋufia goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma kira ka fotofafia Ꞌi tufungana Ꞌai rara folo. Ma kira ka daroꞋia na ifi nia ki Ꞌi safitada kwailiu. Kira ka masa diꞋia daisiꞋanga fasi Ꞌiri kira ke dao toꞋona sa tai ada neꞋe ke ngalia ta ifi. ");
INSERT INTO kwf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ana na sikona kadi sina Ꞌofodangi, kira fotofafia ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma kira ka alua Ꞌi gwauna Ꞌai rara folo taꞋi kerekereꞋa ana kwaigiosi Ꞌanga. Kira keresia ka Ꞌuri, “Na ngwae tatalafaꞋa Jiu ki.” ");
INSERT INTO kwf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma kira ka fotofafia logo ro ngwae bili ki Ꞌi tufungana na ro Ꞌai rara folo ki faꞋinia sa Jesus. Ta ngwae Ꞌi bali ꞋoloꞋolo ana, ma ta ngwae Ꞌi bali mauli ana. ");
INSERT INTO kwf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma na ngwae ki kira liu, kira ka nanga nangataꞋinia gwauda, ma kira ka fata buri tolingaꞋi kwau ana sa Jesus, ma kira ka fata Ꞌuri, “KwaraꞋae! ꞋOko saea Ꞌoke osia na Luma Abu God, ma Ꞌoko saungaꞋinia goꞋo sulia uulu asoa ki bani kwa! ");
INSERT INTO kwf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ꞋOke faꞋamauriꞋo talamu! Koso maꞋi faꞋasia na Ꞌai rara folo neꞋana!” ");
INSERT INTO kwf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma na fata abu doe ki, ma na ngwae faꞋamanata ana taki ki, kira ka fata logo ꞋunaꞋeri. Ma kira ka fata Ꞌoidorole ana sa Jesus, ma kira ka fata Ꞌuri fuada kwailiu, “Nia faꞋamauria ngwae matamata ki, bore ma noaꞋa nia kasi faꞋamauria niaꞋa talana! ");
INSERT INTO kwf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kulu lia basi diꞋia niaꞋa na Christ, na tatalafaꞋa Jiu ki. Nia ke baꞋa koso goꞋo maꞋi faꞋasia na Ꞌai rara folo loeri, Ꞌiri kulu ke faꞋamamana niaꞋa!” Ma na ro ngwae neꞋe kira fotoꞋida ana Ꞌai rara folo ki faꞋinia sa Jesus, kera bore, kera fata buri tolingaꞋi logo ana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ꞋIta ana tofongana asoa, na Ꞌafutana abaꞋi kula neꞋe nia rodoꞋa, leleka ka dao ana sina nia egofolo. ");
INSERT INTO kwf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma ana uula kadi sina saꞋulafi, sa Jesus nia ako doe ma ka Ꞌuri, “Eloi, Eloi, lama sabaktani?” Na fadalana alaꞋanga neꞋeri ki nia Ꞌuri kwau, “God nau Ꞌae, God nau Ꞌae, faꞋuta naꞋa neꞋe Ꞌoko faꞋasi dangalu naꞋa aku?” ");
INSERT INTO kwf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma ti ngwae neꞋe kira tua Ꞌi neꞋeri, kira ka rongoa, ma kira ka fia fasi nia ri Ꞌuana sa Elaeja. ");
INSERT INTO kwf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma taꞋi ngwae Ꞌada lalili kwau, ma ka tongani taꞋi lumulumu Ꞌasi saena waen Ꞌafae, ma ka alua Ꞌi maana taꞋi maꞋe Ꞌai, ma ka kwatea kwau Ꞌi maana ngiduna sa Jesus, fasi Ꞌiri nia ka kwaꞋufia, ma nia ka fata Ꞌuri, “Kulu lia basi, sali sa Elaeja ka leka maꞋi ma ka lafua maꞋi Ꞌi ano faꞋasia na Ꞌai rara folo!” ");
INSERT INTO kwf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma sa Jesus ka ako doe, sui nia ka mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma na ifi doe neꞋe nia bokota na kula abu Ꞌi saena na Luma Abu God nia ka gaa Ꞌita maꞋi Ꞌi gwauna leleka ka dao Ꞌi Ꞌaena. ");
INSERT INTO kwf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma na ngwae ꞋaꞋana ana ngwae ni ofoꞋa ki, neꞋe nia uu Ꞌi neꞋeri Ꞌi Ꞌaena na Ꞌai rara folo, nia rongoa na rilana, ma ka lisia na maelana, nia ka fata Ꞌuri, “Nia mamana liu, na ngwae neꞋe na Ngela God naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma ti kini kira tua logo Ꞌi neꞋeri, ma kira ka lialia tau naꞋa kwau. ꞋI Mary kini Ꞌi Magdala, ma Ꞌi Mary neꞋe teꞋa sa James na ngela Ꞌi buri sa Joses, ma Ꞌi Salome. ");
INSERT INTO kwf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kira leka logo Ꞌi burina sa Jesus ana kaidaꞋi nia tua Ꞌua Ꞌi Galili, ma kira ka kwaiꞋafi ana. Ma na kini Ꞌoro ki logo neꞋe kira leka maꞋi faꞋinia Ꞌuana Ꞌi Jerusalem, kira tua logo Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma nia ka saꞋulafi naꞋa, sa Josef na ngwae faꞋasia fanoa Ꞌi Arimetea, nia ka leka maꞋi. Nia taꞋi ngwae talingaꞋi ana na fikutaꞋi ngwae lokoꞋi ru neꞋe nia lia kwaimasi logo Ꞌuana lisilana kaidaꞋi God ke gwaungaꞋi fafia ngwae nia ki. Nia noniraꞋa, ma ka leka maꞋi siana sa Paelat. Ma nia ka gani Ꞌuana na nonina sa Jesus, sulia faꞋi asoa neꞋeri na asoa ana na sasi akaꞋu Ꞌanga masia na Sabat, na asoa ana mamaloꞋanga. ");
INSERT INTO kwf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma sa Paelat ka Ꞌarefo neꞋe nia rongoa sa Jesus nia mae naꞋa. Ma nia ka ri Ꞌuana ngwae ꞋaꞋana ana ngwae ni ofoꞋa ki, ma ka saefiloa diꞋia sa Jesus mae naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma Ꞌi buri Ꞌana neꞋe sa Paelat nia rongoa ngwae ꞋaꞋana neꞋeri nia saea neꞋe nia mae naꞋa, sa Paelat fiꞋi alaꞋania sa Josef ka ngalia nonina sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ꞋUnaꞋeri, sa Josef ka folia taꞋi Ꞌaba ifi kwao, ma ka kanusua nonina sa Jesus Ꞌi ano, ma ka buta ana ifi neꞋeri, ma ka alua Ꞌi saena na faoda gwaꞋu neꞋe kira Ꞌilia Ꞌi saena na fau. Sui ka gilosia taꞋi babaꞋi fau doe, ma ka bokota naꞋa maana na faoda gwaꞋu neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Ꞌi Mary na kini Ꞌi Magdala, ma Ꞌi Mary neꞋe teꞋa sa Joses, kera lisia naꞋa kula neꞋe kira kwaiatoa sa Jesus ana. ");
INSERT INTO kwf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma Ꞌi buri Ꞌana na Sabat, na asoa ana mamaloꞋanga nia sui naꞋa, Ꞌi Mary kini Ꞌi Magdala, ma Ꞌi Mary na teꞋa sa James, ma Ꞌi Salome, kira folia maꞋi na ru moko leꞋa ki fuana na ngwailana ana nonina sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ana Ꞌofodangi makalokaloꞋa Ꞌua ana Sande, kaidaꞋi sina ni raꞋe naꞋa, kira ka leka maꞋi Ꞌuana na faodaꞋi ngwae mae. ");
INSERT INTO kwf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","KaidaꞋi kira leka, kira ka saefiloda kwailiu, kira ka Ꞌuri, “Sa tai neꞋe ke baꞋa gilosia na babaꞋi fau baera faꞋasia maana faoda baera?” Sulia fau neꞋeri nia doe liu. ");
INSERT INTO kwf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sui, kaidaꞋi kira dao ana, kira ka lisia na babaꞋi fau baera abuli naꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma kaidaꞋi kira ruꞋu kwau Ꞌi saena na faoda, kira ka lisia taꞋi ngwae fiꞋi doe nia ruꞋufia ifi kwao, ma ka tua ana bali ꞋoloꞋolo saena faoda neꞋeri. Ma kira ka maꞋu liu. ");
INSERT INTO kwf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma nia ka fata Ꞌuri, “NoaꞋa kamu kasi maꞋu. Nau ku saiana kamu lulu Ꞌuana sa Jesus, na ngwae Ꞌi Nasaret neꞋe kira saungia Ꞌi tufungana na Ꞌai rara folo. NoaꞋa nia kasi tua naꞋa Ꞌi neꞋe. Sulia nia tataꞋe naꞋa faꞋasia maeꞋa! Mulu lisia na kula ba kira kwaiatoa ana! ");
INSERT INTO kwf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Muke leka kwau siana fafarongo nia ki faꞋinia sa Peter, ma kamu ka faꞋarongo Ꞌuri ada naꞋa, ‘Sa Jesus leka naꞋa Ꞌi naꞋo maꞋakwali kaumulu Ꞌi Galili, kamu ke baꞋa lisia Ꞌi neꞋeri, diꞋia ba nia saea naꞋa fuamuꞋa.’” ");
INSERT INTO kwf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma na kini neꞋeri ki kira ka ruꞋu naꞋa kwau Ꞌi maa, ma kira ka lalili naꞋa faꞋasia na faoda neꞋeri, sulia kira maꞋu, ma kira ka lebelebe liu. NoaꞋa kira kasi saea naꞋa ta ru fuana ta ngwae, sulia kira maꞋu liu. ");
INSERT INTO kwf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ana Ꞌofodangi laꞋa bilabila ana Sande, sa Jesus nia mauri laꞋu, ma ka daotafa fuana Ꞌi Mary kini Ꞌi Magdala, na kini ba sa Jesus nia ifulangaꞋinia na fiu ano Ꞌi ru taꞋa baera ki faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma Ꞌi Mary ka leka siana na fafarongo nia ki. Kira kwaimanatai, ma kira ka angi liu naꞋa. Ma Ꞌi Mary ka faꞋarongoda. ");
INSERT INTO kwf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma ana kaidaꞋi neꞋe kira rongoa neꞋe sa Jesus nia mauri, ma Ꞌi Mary ka lisia naꞋa, kira noaꞋa kasi faꞋamamana goꞋo Ꞌi Mary. ");
INSERT INTO kwf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma Ꞌi buri laꞋu, sa Jesus ka dao tafa logo fuana ta ro fafarongo ana, kaidaꞋi kera leka naꞋa sulia na tala faꞋasia Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma kera ka oli maꞋi, ma kera ka faꞋarongoa laꞋu ti fafarongo ada, bore ma kira kasi faꞋamamana goꞋo. ");
INSERT INTO kwf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma Ꞌi buri Ꞌana naꞋa, sa Jesus ka daotafa fuana na akwala ma taꞋi ngwae ana fafarongo nia ki, kaidaꞋi kira fanga Ꞌada. Ma nia ka balufi kira sulia kira kasi faꞋamamana, ma sulia manatada ngasi liu fuana na faꞋamamanalana ngwae ki neꞋe kira lisia naꞋa Ꞌi buri Ꞌana neꞋe nia tataꞋe faꞋasia maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma nia ka fata Ꞌuri fuada, “Muke leka Ꞌi saena Ꞌafutana na magalia, ma muke faꞋarongo Ꞌani FaꞋarongoꞋa LeꞋa fuana na ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma sa tai neꞋe nia faꞋamamana na FaꞋarongoꞋa LeꞋa, ma ka siuabu, nia ke baꞋa mauri firi faꞋinia God. Ma sa tai neꞋe noaꞋa nia kasi faꞋamamana, God ke baꞋa matalangaꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma na ngwae ki neꞋe kira faꞋamamana, kira ke toꞋo ana ngasingasiꞋanga fuana sasilana faꞋanadaꞋa Ꞌuri ki: Kike ifulani ano Ꞌi ru taꞋa ki Ꞌani na sataku, ma kira ka fata Ꞌani na alaꞋanga matamata ki neꞋe kira Ꞌiri saisaiana. ");
INSERT INTO kwf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma diꞋia kira daua ta baꞋeko tolo nama kira ka kwaꞋufia bore ti kafo ni maelilani noaꞋa nia kasi faꞋalida goꞋo. Ma diꞋia kira alu lima Ꞌi fafona na ngwae mataꞋi ki, kira ka Ꞌakwa naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ꞋI buri Ꞌana neꞋe na Aofia sa Jesus nia alaꞋa faꞋi kira, nia ka fane naꞋa Ꞌuana Ꞌi langi, ma ka tua Ꞌi bali ꞋoloꞋolo ana God ka gwaungaꞋi faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma na fafarongo nia ki kira ka leka, ma kira ka lifurongo Ꞌani fatalana God ana kula ki taꞋifau. Ma na Aofia ka rao faꞋinida, ma ka kwatea na ngasingasiꞋanga fuada fuana sasilana faꞋanadaꞋa ki, fasi Ꞌiri ke faꞋataꞋinia na faꞋamanataꞋanga kira nia mamana. ");
INSERT INTO kwf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kwala Tiofilas kwa, na ngwae Ꞌoro ki kira kerekere sulia ru ki taꞋifau neꞋe sa Jesus nia fuliꞋi safitamiꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kira keresia ru neꞋe kami rongoa faꞋasia na ngwae neꞋe kira lia talitali ana ru neꞋeri ki. Ma ngwae neꞋe kira lisia ru neꞋeri ki neꞋe fuli, kira ka fata logo sulia na FaꞋarongoꞋa LeꞋa neꞋeri fuamiꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nia neꞋe ngwae ꞋinotoꞋa sa Tiofilas, nau ku manata sulia nia leꞋa nau kui kerekere sulia ru neꞋe ki fuamu, osiꞋana nau ku sai leꞋa ana ru ki taꞋifau, nia Ꞌita nama maꞋi ana etangilana alaꞋanga neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma nau ku kere sulia ru neꞋe ki fasi Ꞌiri Ꞌoke saiana na mamanalana taꞋifau ru neꞋe kira faꞋamanata Ꞌani fuamu. ");
INSERT INTO kwf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ana na kaidaꞋi sa Herod nia gwaungaꞋi fafia abaꞋi kula Ꞌi Judea, taꞋi fata abu neꞋe satana sa Sekaraea nia tua logo ana kaidaꞋi neꞋeri, ma niaꞋa ana fiku taꞋi fata abu fuana foꞋongaꞋa sulia sa Abaeja. Na Ꞌafe nia Ꞌi Elisabet nia saka logo maꞋi ana na kwalafa fata abu ki neꞋe kira Ꞌita maꞋi ana sa Aaron, ngwaefuta sa Moses. ");
INSERT INTO kwf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na abula ladaroꞋo taꞋifau nia saga, ma ka ꞋoloꞋolo Ꞌi naꞋona God, sulia kera roꞋo leꞋa liu sulia na taki God ki faꞋinia na alaꞋanga totongaꞋi nia ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bore ma taꞋi ru goꞋo, neꞋe noaꞋa kera kasi toꞋo ana ta ngela, osiꞋana Ꞌi Elisabet nia ꞋabaraꞋa. Ma niaꞋa faꞋinia araꞋi nia sa Sekaraea bore, keroꞋa ngwaro logo naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","TaꞋi asoa sa Sekaraea nia leka saena Luma Abu God, osiꞋana kaidaꞋi neꞋeri na kaidaꞋi na fiku taꞋi fata abu sa Sekaraea Ꞌiri ke sasia na raoꞋa fata abu ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na falafala ana fata abu ki fuana fililana taꞋi fata abu laꞋu fuana doꞋofilana Ꞌai moko leꞋa, neꞋe nia Ꞌuri: Kira ka Ꞌui Ꞌania ru diꞋia daisi fuana fililana sa tai laꞋu neꞋe ka sasia raoꞋa fata abu fuana doꞋofilana Ꞌai moko leꞋa Ꞌi fafona fulifuꞋa saena Luma Abu God. Ana kaidaꞋi neꞋeri, kira ka filia sa Sekaraea, ma nia ka ruꞋu Ꞌi saena Luma Abu, ");
INSERT INTO kwf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ma na ngwae Ꞌoro neꞋe kira ka tua Ꞌi maa ki, kira ka foꞋo ana kaidaꞋi neꞋe nia doꞋofia na Ꞌai moko leꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma taꞋi Ꞌainsel God ka faꞋataꞋi fuana, nia uu Ꞌi bali ꞋoloꞋolo ana fulifuꞋa neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","KaidaꞋi sa Sekaraea nia lisia na Ꞌainsel neꞋeri, nia ka lebe ma ka maꞋu liu. ");
INSERT INTO kwf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bore ma, na Ꞌainsel neꞋeri ka fata Ꞌuri fuana, “Sekaraea, noaꞋa Ꞌoe kosi maꞋu laꞋu! God nia rongoa na lingana foꞋongaꞋa Ꞌoe, ma na Ꞌafe Ꞌoe Ꞌi Elisabet ke baꞋa faꞋafuta taꞋi ngela ngwane. Ma Ꞌoke saea Ꞌani sa John. ");
INSERT INTO kwf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ꞋOke baꞋa saeleꞋa liu, ma na ngwae Ꞌoro ki logo, kira ka saeleꞋa ana kaidaꞋi neꞋe nia ke futa maꞋi ana! ");
INSERT INTO kwf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","OsiꞋana niaꞋa na ngwae talingaꞋi Ꞌi naꞋona God. NoaꞋa nia kasi kwaꞋufia ta waen nama ta ru ni kwaꞋufilana ngasingasiꞋa neꞋe lilinga. Ma ana kaidaꞋi nia fiꞋi futa maꞋi, na AnoꞋi ru Abu ka tua naꞋa faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nia ke baꞋa olitaꞋinia maꞋi na ngwae Ꞌoro ki Ꞌi Israel fuana God kira. ");
INSERT INTO kwf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma nia ke baꞋa etaeta naꞋa maꞋi Ꞌi naꞋo ana na Aofia, ma ke baꞋa ngasingasiꞋa diꞋia sa Elaeja na profet. Sa tai faꞋida neꞋe kira olisuꞋusuꞋu, nia ke fikuda laꞋu, fasi Ꞌiri na maꞋa ki, ma na ngela kira ki, kira ke alafe fuada kwailiu. Ma nia ke baꞋa rokisia manatana na ngwae aburongo ki, Ꞌiri kira ka manata saga. Ma nia ke baꞋa sasi akaꞋu ana na ngwae ki fuana na Aofia, Ꞌiri kira ke masia na daolana maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sui, sa Sekaraea ka fata Ꞌuri fuana Ꞌainsel neꞋeri, “Nau kui baꞋa sai faꞋuta ana mamanalana ru neꞋeri? Sulia nauꞋa faꞋinia Ꞌafe nau, keroꞋo ngwaro taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma na Ꞌainsel nia olisia ka fata Ꞌuri: “NauꞋa sa Gebriel neꞋe nau ku tua faꞋinia God sulia asoa ki taꞋifau. Ma God naꞋa niniꞋa asungaꞋi nau maꞋi, Ꞌiri nai alaꞋa faꞋiniꞋo, ma nau ku faꞋarongo Ꞌoe Ꞌani na faꞋarongoꞋa leꞋa neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma diꞋia Ꞌoe kosi faꞋamamana goꞋo ana faꞋarongoꞋanga neꞋe nau, Ꞌoke lisia na mamanalana ana kaidaꞋi neꞋe God nia Ꞌolea fuana ru neꞋe ka fuli ana. Ma osiꞋana Ꞌoe kosi faꞋamamana ana fatalaku, na kwakwamu ke kulu, ma noaꞋa Ꞌoe kosi alaꞋa tafa leleka ka dao ana kaidaꞋi neꞋe ru neꞋe nau ku eta fata Ꞌani Ꞌi naꞋo fuamu ka mamana.” ");
INSERT INTO kwf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ana kaidaꞋi neꞋeri na ngwae neꞋe kira tua masia sa Sekaraea ki, kira ka Ꞌarefo liu, sulia nia tua tau maꞋi Ꞌi saena Luma Abu. ");
INSERT INTO kwf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma kaidaꞋi sa Sekaraea nia leka maꞋi Ꞌi maa siana ngwae neꞋeri ki, na kwakwana ka kulu naꞋa, ma noaꞋa nia kasi alaꞋa naꞋa faꞋinia na ngwae neꞋeri ki. ꞋUnaꞋeri goꞋo na ngwae ki taꞋifau, kira ka manata naꞋa Ꞌuri: “Mamana liu, sali nia lisia ta faꞋataꞋinga Ꞌi saena Luma Abu.” Si neꞋe kwakwana nia kulu naꞋa, ma nia ka alaꞋa goꞋo Ꞌani limana fuana ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma na kaidaꞋi nia ki fuana raoꞋa saena Luma Abu God nia sui naꞋa, sa Sekaraea fiꞋi oli laꞋu Ꞌuana luma nia. ");
INSERT INTO kwf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma noaꞋa nia kasi tau goꞋo Ꞌi buri Ꞌana, na Ꞌafe nia Ꞌi Elisabet ka ina naꞋa, ma sulia lima madamo ki, nia kasi liliu naꞋa Ꞌi maa faꞋasia luma kera, ");
INSERT INTO kwf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ma nia ka fata Ꞌuri, “KaidaꞋi neꞋe, God nia Ꞌafi nau naꞋa, ma ka lafu nau naꞋa faꞋasia ꞋekeꞋa ba nau ku tua maꞋi saena Ꞌani ꞋabaraꞋanga Ꞌi maana ngwae Ꞌoro ki.” ");
INSERT INTO kwf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","KaidaꞋi Ꞌi Elisabet nia ina ka tua naꞋa sulia ono madamo ki, God ka kwatea maꞋi Ꞌainsel Gebriel Ꞌuana taꞋi fanoa saena abaꞋi kula Ꞌi Galili neꞋe kira saea Ꞌani Ꞌi Nasaret. ");
INSERT INTO kwf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nia ngalia maꞋi taꞋi faꞋarongoa fuana taꞋi sariꞋi neꞋe kira alu fafia fuana ngwae neꞋe satana sa Josef fasi Ꞌiri ka korea. Sa Josef nia futa maꞋi olitana na kwalafa sa David na tatalafaꞋa. Na satana sariꞋi neꞋeri Ꞌi Mary. ");
INSERT INTO kwf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na Ꞌainsel nia leka maꞋi, ka fata Ꞌuri fuana, “Asoa leꞋa kwau! God nia tua faꞋi Ꞌoe, ma ka faꞋaleꞋa Ꞌoe, ma na kwaiꞋofeꞋa nia fuamu ka lilisu!” ");
INSERT INTO kwf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","KaidaꞋi Ꞌi Mary nia rongoa na fatalana Ꞌainsel neꞋeri, nia ka manata Ꞌabera, ma ka lulu Ꞌuana na fadalana na alaꞋanga neꞋeri neꞋe Ꞌainsel nia saea fuana. ");
INSERT INTO kwf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sui na Ꞌainsel ka fata laꞋu Ꞌuri fuana, “Mary kwa, noaꞋa Ꞌoe kosi maꞋu laꞋu, duꞋungana God nia ꞋofeꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","DuꞋungana nia fili Ꞌoe, Ꞌoke baꞋa ina, ma Ꞌoke faꞋafuta taꞋi ngela ngwane, ma Ꞌoko faꞋasata Ꞌani sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma nia ke baꞋa ꞋinotoꞋa liu, ma kira ka saea Ꞌani Ngela God. God kwatea nia ke gwaungaꞋi, diꞋia koꞋo bora nia sa David. ");
INSERT INTO kwf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma nia ka gwaungaꞋi fuana Jiu ki neꞋe fuuꞋi ngwae ana sa Jakob tuatua firi, ma na ꞋInotoꞋanga noaꞋa nia kasi sui!” ");
INSERT INTO kwf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Ꞌi Mary ka fata Ꞌuri fuana Ꞌainsel neꞋeri, “Nau ku abungaꞋi nau Ꞌua goꞋo Ꞌaku kwa. ꞋUri ma alaꞋanga Ꞌoko saea fuaku ke baꞋa mamana faꞋuta?” ");
INSERT INTO kwf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma na Ꞌainsel neꞋeri nia olisia ka Ꞌuri, “Na AnoꞋi ru Abu ke baꞋa koso maꞋi fafiꞋo, ma na ngasingasiꞋanga God ka tua faꞋiniꞋo. OsiꞋana niniꞋa na Ngela Abu neꞋeri, kira ke saea Ꞌani na Ngela God. ");
INSERT INTO kwf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ꞋOko saiana toꞋolamu Ꞌi Elisabet. Na ngwae ki taꞋifau kira saea nia ꞋafitaꞋi naꞋa fuana nia ka toꞋo ana ta ngela. Sui bore Ꞌana nia ka ngwaro, ma taꞋena nia ina ka tua naꞋa sulia ono madamo ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","OsiꞋana noaꞋa ta ru kasi ꞋafitaꞋi goꞋo fuana God.” ");
INSERT INTO kwf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Ꞌi Mary ka fata Ꞌuri, “Nau ku oga ru niniꞋa Ꞌoko saea fuaku ki ke fuli mamana naꞋa maꞋi fuaku, osiꞋana nau na kini rao God.” KaidaꞋi Ꞌi Mary nia fata goꞋo ꞋunaꞋeri, na Ꞌainsel ka leka naꞋa Ꞌana faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana kaidaꞋi neꞋeri nama goꞋo, Ꞌi Mary ka sasi akaꞋu, ma ka leka ꞋaliꞋali naꞋa Ꞌuana kala fanoa Ꞌi tolo ana bali abaꞋi kula Ꞌi Judea. ");
INSERT INTO kwf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","KaidaꞋi nia dao, nia ka ruꞋu Ꞌi luma sa Sekaraea, ma ka fata leꞋa leꞋa fuana Ꞌi Elisabet. ");
INSERT INTO kwf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma kaidaꞋi Ꞌi Elisabet nia rongoa na fatalana Ꞌi Mary, na ngela neꞋe nia ina Ꞌani lebe ka saola saena sirana. Ma na AnoꞋi ru Abu ka sura ana Ꞌi Elisabet, ");
INSERT INTO kwf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma nia ka fata doe ma ka Ꞌuri, “Na ꞋoilakiꞋa fuamu liufia na kini ki taꞋifau, ma na ꞋoilakiꞋa logo fuana na ngela neꞋe Ꞌoko ina Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","NoaꞋa nau ku Ꞌiri totolia neꞋe ru doe neꞋe ka fuli fuaku, sulia na teꞋa Aofia nau ka leka maꞋi fuana na lisilaku! ");
INSERT INTO kwf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","DuꞋungana kaidaꞋi nau ku rongoa goꞋo na alaꞋanga Ꞌoe ki, na ngela niniꞋa nau ku ina Ꞌani ka leotaꞋi naꞋa saena siraku, osiꞋana nia saeleꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na ꞋoilakiꞋanga fuamu osiꞋana Ꞌoko faꞋamamana ana fatalana God fuamu ke fuli.” ");
INSERT INTO kwf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma Ꞌi Mary ka fata Ꞌuri, “Na manatalaku tafea God, ");
INSERT INTO kwf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma na mangoku nia saeleꞋa sulia God neꞋe nia faꞋamauri nau. ");
INSERT INTO kwf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nau ku ngu tafea aku, sulia nia manata toꞋo aku, nau na kini ku enoeno goꞋo aku, ma ku tua goꞋo aku fuana na raoꞋa fuana. Nia Ꞌita Ꞌi taꞋena ka oli alaꞋa, na ngwae ki taꞋifau kira ka saea nau ku tua Ꞌani ꞋoilakiꞋa doe, ");
INSERT INTO kwf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sulia na ru doe ki neꞋe God nia sasiꞋi fuaku Ꞌani ngasingasilana taꞋifau. Ma na satana God abu. ");
INSERT INTO kwf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nia Ꞌita ka leka naꞋa maꞋi sulia na unitaꞋi ngwae ki taꞋifau, nia faꞋataꞋinia kwaimanataiꞋanga nia fuana ngwae ki taꞋifau neꞋe kira fuꞋusi doe ana. ");
INSERT INTO kwf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nia taga na limana neꞋe nia ngasingasiꞋa liu, ma ka takalongaꞋinia na ngwae neꞋe kira fataleꞋa ada Ꞌi talada ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nia faꞋakosoa na tatalafaꞋa ngasingasiꞋa ki faꞋasia na ꞋinotoꞋanga kira ki, ma ka faꞋaꞋinotoꞋa ngwae kira enoeno ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na ngwae kira fiolo ki, nia sare kira Ꞌani ru leꞋa ki, ma nia ka sasi ngwae toꞋoruꞋa ki ka dalaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nia manata toꞋona na fata alangaꞋinga nia sasia fuana koꞋo bora kia ki, ma ka kwaiꞋafi aka na ngwae rao nia ki Ꞌi Israel. NoaꞋa nia kasi manata bura ana faꞋataꞋilana kwaimanataiꞋanga nia eta fataꞋa Ꞌani fuana sa Abraham, ma fuaka logo na kwalafa nia ki tuatua firi!” ");
INSERT INTO kwf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ꞋI Mary nia tua faꞋinia Ꞌi Elisabet sulia uulu madamo ki, sui nia ka fiꞋi oli Ꞌuana fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","KaidaꞋi fuana Ꞌi Elisabet ka faꞋafuta nia dao naꞋa, nia ka faꞋafuta taꞋi ngela ngwane. ");
INSERT INTO kwf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na ngwae kwaima nia ki, ma na ngwae goꞋo ana kwalafa nia ki, kira rongoa na ru leꞋa neꞋe God nia sasia fuana, ma kira ka saeleꞋa liu fafia. ");
INSERT INTO kwf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fiu asoa ki sui buri Ꞌana futalana ngela neꞋeri, kira ka roꞋosulia na falafala Jiu ki fuana Ꞌolo faꞋataꞋinia. Ma kira ka oga kike faꞋasata nia Ꞌani maꞋa nia sa Sekaraea. ");
INSERT INTO kwf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bore ma teꞋa nia olisida ka Ꞌuri, “NoaꞋa kamu kasi saea Ꞌani sata neꞋana! Na satana sa John lala.” ");
INSERT INTO kwf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma na ngwae ki taꞋifau kira olisia kira ka Ꞌuri, “NoaꞋa ta ngwae ana kwalafa koroꞋo Ꞌiri toꞋo ana sata neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sui kira ka alaꞋa Ꞌani limada, kira ka kwatea maꞋetoto fuana maꞋa nia sa Sekaraea, ma kira ka saefilo Ꞌuana sata tae neꞋe nia oga kira ke faꞋasata Ꞌani ngela neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma sa Sekaraea ka kwaikarui, ma ka gania Ꞌuana taꞋi Ꞌaba ru fuana kerekereꞋa, ma nia ka kerekere ka Ꞌuri, “Na satana ngela neꞋe sa John.” Ma ngwae ki taꞋifau kira ka Ꞌarefo liu. ");
INSERT INTO kwf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma ana kaidaꞋi neꞋeri logo, na ngiduna sa Sekaraea ka fata tafa, ma nia ka tafea God. ");
INSERT INTO kwf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma na ngwae ki taꞋifau goꞋo neꞋe kira fiku maꞋi Ꞌi neꞋeri, kira ka Ꞌarefo liu, ma na faꞋarongoꞋanga sulia na ru neꞋeri ki ka talofia naꞋa ngwae kira tua Ꞌi tolo ki, saena Ꞌafutana abaꞋi kula Ꞌi Judea. ");
INSERT INTO kwf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma na ngwae ki taꞋifau goꞋo neꞋe kira rongoa ru neꞋeri ki, kira ka manata kalida, ma kira ka fata Ꞌuri, “Na ngela neꞋe ke baꞋa alua ta ngwae faꞋuta niniꞋa?” Kira fata ꞋunaꞋeri, sulia kira saiana na ngasingasiꞋanga God nia tua faꞋinia ngela neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma na AnoꞋi ru Abu ka tua naꞋa faꞋinia sa Sekaraea maꞋa sa John, ma sa Sekaraea ka fatataloꞋania na faꞋarongoꞋanga God ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kuke tafea God neꞋe niaꞋa God ana ngwae Jiu ki. Nia leka maꞋi fuana Ꞌafilaka na ngwae nia ki, ma fuana na faꞋamaurilaka. ");
INSERT INTO kwf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nia ke kwatea maꞋi fuaka taꞋi ngwae KwaifaꞋamauri neꞋe nia toꞋo ana ngasingasiꞋanga doe, neꞋe nia leka maꞋi faꞋasia kwalafa sa David na tatalafaꞋa, na ngwae rao na Aofia. ");
INSERT INTO kwf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nia fata alangaꞋinia maꞋi fuaka ru neꞋe ki, ana fatalana profet abu ki Ꞌi naꞋo, ");
INSERT INTO kwf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","fasi Ꞌiri nia ke faꞋamauri kia faꞋasia na malimae kia ki ma faꞋasia na ngasingasiꞋanga ana ngwae neꞋe kira ogalaꞋa fuaka ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nia ka alangaꞋi maꞋi nia ke faꞋataꞋinia na kwaimanataiꞋanga nia fuana koꞋo bora kia ki, ma nia ka manata toꞋona na fau alangaꞋinga abu nia ");
INSERT INTO kwf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","neꞋe nia sasia fuana koꞋo bora kia sa Abraham, ma nia ke baꞋa lafu kia faꞋasia na malimae kia ki, ");
INSERT INTO kwf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","fasi Ꞌiri kuke rao fuana ma noaꞋa kulu kasi maꞋu, ");
INSERT INTO kwf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma fasi Ꞌiri kuke tua saga Ꞌi maana sulia asoa ki taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma sa Sekaraea ka fata Ꞌuri fuana ngela nia sa John, “Ngela nau Ꞌae, kira ke saeꞋo Ꞌani profet God neꞋe ꞋinotoꞋa fafia ru ki taꞋifau. Ma Ꞌoke etaeta Ꞌi naꞋo ana na Aofia, fasi Ꞌiri Ꞌoko saea ngwae ki kira ka sasi akaꞋu ana maurilada maꞋakwalia niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma Ꞌoke faꞋarongoa na ngwae nia ki, neꞋe kira ke toꞋo ana mauriꞋa kaidaꞋi God ke rufuanata ana taꞋangaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sulia God kia, nia kwaimanatai liu fuaka. DiꞋia na sina neꞋe raꞋe maꞋi faꞋinia madakolaꞋa, ");
INSERT INTO kwf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na ngwae FaꞋamauri kia nia dao maꞋi faꞋasia God faꞋinia madakolaꞋanga fuana ai neꞋe kira tua saena maꞋe rodo ana maeꞋa. Ma nia kwaiꞋafi aka Ꞌiri ke talaꞋi kia Ꞌuana na aroaroꞋanga faꞋinia God.” ");
INSERT INTO kwf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma ngela neꞋeri sa John ka doe ana noni, ma na manatana taꞋifau ka ngasingasiꞋa. Ma kaidaꞋi nia doe, nia ka tua saena abaꞋi kula kwasi, leleka ka dao ana asoa nia sakatafangaꞋi fuana ngwae Ꞌi Israel ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana kaidaꞋi neꞋeri ana teꞋeteꞋelana sa John, na ngwae gwaungaꞋi ana fanoa doe Ꞌi Rom neꞋe satana sa Ogastas, nia alua taꞋi taki fuana ngwae ana fanoa ki taꞋifau olofana ꞋinotoꞋanga nia, fasi Ꞌiri kike leka Ꞌi fanoa koꞋo bora kira ki fuana na keresilana satada. ");
INSERT INTO kwf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma nia na etana kerekereꞋa neꞋe kira sasia kaidaꞋi sa Kwirinias nia ꞋinotoꞋa fafia profins Ꞌi Siria. ");
INSERT INTO kwf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma na ngwae ki taꞋifau, kira ka leka fuana na keresilana satada, taꞋi taꞋi ngwaeꞋa ke oli Ꞌuana fanoa nia. ");
INSERT INTO kwf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma sa Josef ka leka logo maꞋi faꞋasia na fanoa nia Ꞌi Nasaret ana abaꞋi kula Ꞌi Galili, ma ka leka Ꞌuana abaꞋi kula Ꞌi Judea Ꞌuana na maꞋe fanoa sa David na tatalafaꞋa neꞋe kira saea Ꞌani Ꞌi Betlehem, osiꞋana sa Josef nia na ngwae ana kwalafa sa David. ");
INSERT INTO kwf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sa Josef nia leka fuana ka keresia na satana faꞋinia Ꞌi Mary, na kini ba kira alu fafia fuana. Ma ana kaidaꞋi neꞋeri, Ꞌi Mary nia ina naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma ana kaidaꞋi kera tua Ꞌi Betlehem, nia ngela fii naꞋa fuana faꞋafutaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma nia ka faꞋafuta na ngela etaeta nia, ma ka Ꞌafua Ꞌani ifi ki, ma ka faꞋateoa Ꞌi saena kula ni sare bulukaꞋanga, osiꞋana noaꞋa naꞋa ta luma fuana kera ka folia kera ka tua ana. ");
INSERT INTO kwf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma na ngwaꞋi toꞋa kira lia sulia sipsip ki, kira tua karangia logo na fanoa neꞋeri, ma kira ka lia sulia na sipsip kira ki Ꞌi saena rodo. ");
INSERT INTO kwf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma na Ꞌainsel God ka faꞋataꞋi fuada, ma na madakolana God ka rara Ꞌafida, ma kira ka maꞋu liu. ");
INSERT INTO kwf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma na Ꞌainsel neꞋeri ka fata Ꞌuri fuada, “NoaꞋa kamu kasi maꞋu laꞋu, osiꞋana nau ku ngalia maꞋi faꞋarongoꞋanga leꞋa neꞋe nia faꞋasaeleꞋa ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ꞋI taꞋena na FaꞋamauri kamu nia futa Ꞌi saena maꞋe fanoa sa David Ꞌi Betlehem, ma nia neꞋe na Christ na Aofia. ");
INSERT INTO kwf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma na maꞋetoto fuamuꞋa nia Ꞌuri: Muke baꞋa lisia taꞋi ngela tiꞋitiꞋi neꞋe kira Ꞌafua Ꞌani ifi ki, ma nia teo ana kula fuana sarelana buluka ki.” ");
INSERT INTO kwf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ꞋAsu bore ma moleꞋe Ꞌainsel faꞋasia Ꞌi langi kira ka fiku faꞋataꞋi laꞋu faꞋinia Ꞌainsel baera, ma kira ka tafea God kira ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“FuꞋusi ꞋinotoꞋa ana God Ꞌi langi. Ma na aroaroꞋa fuana ngwae ki Ꞌi ano neꞋe God nia saeleꞋa faꞋinida.” ");
INSERT INTO kwf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ꞋI buri Ꞌana neꞋe Ꞌainsel ki kira oli naꞋa Ꞌuana Ꞌi langi, na ngwae lia sulia sipsip neꞋeri ki kira ka alaꞋa kwailiu fuada kira ka Ꞌuri, “Kulu leka basi Ꞌuana Ꞌi Betlehem fasi Ꞌiri kulu ke lisia na ru niniꞋa God nia fata sulia fuakulu.” ");
INSERT INTO kwf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma kira ka leka ꞋaliꞋali, ma kira ka dao toꞋona Ꞌi Mary faꞋinia sa Josef, ma kira ka lisia na ngela tiꞋitiꞋi neꞋe nia teo ana kula fuana sare bulukaꞋanga. ");
INSERT INTO kwf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma kaidaꞋi kira lisia, kira ka fata sulia na ru neꞋe na Ꞌainsel ki kira saea fuada sulia na ngela neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma na ngwae ki kira ka rongoa, ma kira ka Ꞌarefo liu ana alaꞋanga neꞋe kira faꞋarongo Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Ꞌi Mary nia manata toꞋona ru neꞋeri ki, ma ka goniꞋi saena maurilana ka tau. ");
INSERT INTO kwf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma na ngwae folo Ꞌusia sipsip ki kira ka oli, ma kira ka baꞋatafea God fafia ru ki taꞋifau neꞋe kira rongoa, ma kira ka lisia logo neꞋe nia mamana ka diꞋia nama neꞋe Ꞌainsel saea fuada. ");
INSERT INTO kwf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma ana wiki Ꞌi buri, kaidaꞋi neꞋe kira Ꞌolo faꞋataꞋinia ana ngela neꞋeri, kera ka faꞋasata Ꞌani sa Jesus, na sata ba na Ꞌainsel nia saea fuana Ꞌi Mary, kaidaꞋi nia kasi ina ua. ");
INSERT INTO kwf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma na kaidaꞋi nia dao naꞋa fuana sa Josef faꞋinia Ꞌi Mary kera ka faꞋasikasika naꞋa diꞋia na taki ba sa Moses nia saea Ꞌi burina faꞋafutaꞋanga. ꞋUnaꞋeri goꞋo, kera ka ngalia na ngela neꞋeri Ꞌuana saena Luma Abu God Ꞌi Jerusalem Ꞌiri kera ka kwatea fuana God, ");
INSERT INTO kwf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","diꞋia ba kira keresia ka sui naꞋa Ꞌi saena taki God ki kira Ꞌuri, “Na ngela ngwane etaeta, kira ke kwatea nama fuana God.” ");
INSERT INTO kwf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kera ke kwatea logo na kwaisuꞋusiꞋanga Ꞌani ro faꞋi fao ki, nama ta ro faꞋi bola, diꞋia na taki God nia oga fuana faꞋasikasika lana Ꞌi Mary. ");
INSERT INTO kwf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma ana kaidaꞋi neꞋeri, taꞋi ngwae satana sa Simion nia tua Ꞌi Jerusalem. NiaꞋa na ngwae leꞋa, ma ka dangiꞋi foꞋosia God, ma ka tua ni kwaimasi Ꞌuana kaidaꞋi God ke faꞋamauria na ngwae Israel ki. Ma na AnoꞋi ru Abu nia ka tua ana, ");
INSERT INTO kwf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ka saea nia ke mauri leleka ka dao ana kaidaꞋi nia ke lisia na Christ neꞋe God nia fata alangaꞋi Ꞌani fuana lafulana ngwae nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na AnoꞋi ru Abu nia talaꞋia sa Simion ka leka Ꞌuana Luma Abu God, ma nia ka dao toꞋona sa Josef faꞋinia Ꞌi Mary, kaidaꞋi kera ngalia maꞋi na ngela tiꞋitiꞋi neꞋeri sa Jesus, Ꞌiri kera ka sasia na ru ki neꞋe taki nia saea fuana sasilana. ");
INSERT INTO kwf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ꞋUnaꞋeri goꞋo, sa Simion ka toꞋia naꞋa ngela neꞋeri Ꞌani limana, ma ka baꞋatafea God ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God Ꞌae, kaidaꞋi neꞋe fata alangaꞋinga ba Ꞌoe nia mamana naꞋa. Nia neꞋe, nauꞋa na ngwae raꞋo Ꞌoe, nau ku fiꞋi bolo naꞋa fuana maeꞋa, ma nau ku saeleꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","DuꞋungana kaidaꞋi neꞋeri, nau ku lisia naꞋa Ꞌania maaku talaku na ngwae neꞋe Ꞌoko kwatea maꞋi Ꞌiri ke faꞋamauria na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nia na ngwae neꞋe Ꞌoko sasi akaꞋu ana, fasi Ꞌiri ngwae ki taꞋifau kira ke lisia. ");
INSERT INTO kwf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ngwae ni FaꞋamauri neꞋe, nia diꞋia na unu, osiꞋana nia ke faꞋataꞋinia na kwaiogaiꞋanga Ꞌoe fuana ngwae neꞋe noaꞋa laꞋu Jiu ki. Ma nia ka faꞋa ꞋinotoꞋa kami ngwae Jiu ki neꞋe ngwae Ꞌoe ki.” ");
INSERT INTO kwf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma na maꞋa nia ma na teꞋa nia, kera ka Ꞌarefo liu kaidaꞋi kera rongoa ru neꞋeri ki sa Simion nia alaꞋa sulia na ngela neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma sa Simion ka faꞋaleꞋa kera. Sui, nia ka fata Ꞌuri fuana Ꞌi Mary, na teꞋa nia, “Na ngela neꞋe na ngela God nia filia Ꞌua naꞋa maꞋi, na ngwae Ꞌoro ki Ꞌi Israel kira ke toꞋo ana mauriꞋa ana niaꞋa, ma na Ꞌorolana logo ngwae ki Ꞌi Israel maurilada mae osiꞋana kira Ꞌiri saiana niaꞋa. NiaꞋa neꞋe na maꞋetoto ke faꞋataꞋinia God fuana ngwae ki, ma Ꞌorolana ngwae ki kira Ꞌaila Ꞌania, ");
INSERT INTO kwf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ꞋunaꞋeri nia ke faꞋataꞋinia na manata ago Ꞌanga kira ki. Ma na kwaimanataiꞋanga doe ke baꞋa dao amu, ka diꞋia ta naifi neꞋe ke toꞋo mala ana nonimu ka fii liu.” ");
INSERT INTO kwf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma na taꞋi gwaꞋi Ꞌuru kini nia tua logo ana kaidaꞋi neꞋeri, na satana Ꞌi Ana, ma nia taꞋi profet logo, ma nia ka ngwaro naꞋa. Nia na ngela kini sa Faniuel ana kwalafa sa Asa. Ana kaidaꞋi nia sariꞋi, nia Ꞌafe ma ka tua faꞋinia araꞋi nia sulia fiu faꞋi ngali ki goꞋo, ");
INSERT INTO kwf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma Ꞌi burina araꞋi nia mae, nia Ꞌuru ka tua naꞋa sulia kwalu akwala ma fai faꞋi ngali. Nia tua goꞋo Ꞌana, ma ka ꞋidufaꞋi leka saena Luma Abu God fuana abu fangaꞋa ma na foꞋosilana God sulia asoa ma rodo. ");
INSERT INTO kwf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana kaidaꞋi neꞋeri logo, nia dao toꞋona sa Josef faꞋinia Ꞌi Mary, ma ka baꞋatafea God, ma ka alaꞋa sulia na ngela neꞋeri fuana ngwae ki taꞋifau neꞋe kira tua goꞋo Ꞌada masia kaidaꞋi God ke faꞋamauria ngwae Jerusalem ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","KaidaꞋi sa Josef faꞋinia Ꞌi Mary kera faꞋasuia na ru ki taꞋifau neꞋe taki God nia saea, kera ka oli naꞋa Ꞌuana fanoa kera Ꞌi Nasaret, fanoa neꞋe saena abaꞋi kula Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na ngela neꞋeri nia doe maꞋi, ma ka ngasingasiꞋa, ma ka toꞋo ana liatoꞋo. Ma kwaiꞋofeꞋanga God ka tua faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana faꞋi ngali ki taꞋifau, na maꞋa sa Jesus ma teꞋa nia kera leka Ꞌuana fanoa doe Ꞌi Jerusalem fuana faꞋi asoa doe ana FangaꞋa DaofaꞋi LiuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma kaidaꞋi sa Jesus nia dao ana akwala ma ro faꞋi ngali, kira ka leka ana fangaꞋa neꞋeri sulia na falafala kira. ");
INSERT INTO kwf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ꞋI buri Ꞌana fangaꞋa neꞋeri nia sui, na maꞋa nia ma teꞋa nia kera ka oli naꞋa adaroꞋo, ma sa Jesus ka tua goꞋo Ꞌana Ꞌi Jerusalem, ma kera kasi saiana. ");
INSERT INTO kwf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kera fia fasi nia leka naꞋa faꞋinia na fikuꞋa neꞋeri, ma kera ka leka naꞋa adaroꞋo sulia faꞋi asoa laꞋulaꞋu neꞋeri. Sui, kera ka fiꞋi talaꞋae Ꞌuana lululana Ꞌi safitana na ngwaefuta kera ki, ma na ngwae kwaima kera ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma kaidaꞋi kera lulu, ma kera kasi lisia, kera ka oli, kera ka lulu laꞋu maꞋi Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma na uula faꞋi asoa, kera fiꞋi dao toꞋona saena Luma Abu God. Nia tua Ꞌana faꞋinia ngwae faꞋamanata ana Jiu ki, ma nia ka fafarongoda, ma ka saefiloda sulia ru kira faꞋamanata Ꞌani. ");
INSERT INTO kwf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma na ngwae ki taꞋifau neꞋe kira rongo nia, kira ka Ꞌarefo liu ana sai Ꞌi ruꞋanga nia ma ana olisiꞋanga nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma kaidaꞋi sa Josef ma Ꞌi Mary kera lisia, kera ka Ꞌarefo liu. Ma teꞋa nia ka fata Ꞌuri fuana, “Ngela nau Ꞌae, Ꞌoko sasi faꞋuta amiroꞋo niniꞋa? Na maꞋa Ꞌoe ma nauꞋa, keroꞋo lulu maꞋi Ꞌuamu, ma keroꞋo ka manata Ꞌabera liu.” ");
INSERT INTO kwf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma sa Jesus ka olisi kera ka Ꞌuri, “FaꞋuta neꞋe koroꞋo ka lulu maꞋi Ꞌuaku ana kula ki dalafa? Fuila koroꞋo ka sai goꞋo ana neꞋe nau ku tua goꞋo aku Ꞌi neꞋe saena luma MaꞋa nau.” ");
INSERT INTO kwf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ꞋUnaꞋeri ma kera kasi sai goꞋo ana na fadalana na alaꞋanga neꞋe nia saea fuadaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sui, sa Jesus ka oli faꞋi kera Ꞌuana Ꞌi Nasaret, ma ka roꞋo naꞋa Ꞌana sulidaroꞋo. Ma teꞋa nia ka manata naꞋa sulia ru neꞋeri ki taꞋifau sulia kaidaꞋi tau. ");
INSERT INTO kwf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma sa Jesus ka doe maꞋi ana noni, ma na liatoꞋo Ꞌanga nia ka doe logo, ma God faꞋinia ngwae ki kika saeleꞋa logo faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ana kaidaꞋi neꞋeri, nia dao naꞋa ana akwala ma lima faꞋi ngali neꞋe sa Taebirias nia ꞋinotoꞋa ana fanoa doe Ꞌi Rom, ma sa Pontias Paelat ka ꞋinotoꞋa fafia Ꞌi Judea, ma sa Herod nia ngwae ꞋinotoꞋa fafia Ꞌi Galili, ma sa Filip na ngwaefuta nia ka lia sulia Ꞌi Iturea ma Ꞌi Trakonaetis, ma sa Lisanias ka lia sulia abaꞋi kula Ꞌi Abilin. ");
INSERT INTO kwf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","KaidaꞋi neꞋeri logo, sa Anas ma sa Kaeafas keroꞋa ro ꞋingataꞋi fata abu ki ana fanoa Ꞌi Jerusalem. Ma ana kaidaꞋi neꞋeri, na fatalana God ka dao maꞋi siana sa John na ngela sa Sekaraea, kaidaꞋi nia tua naꞋa Ꞌi saena abaꞋi kula kwasi. ");
INSERT INTO kwf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma sa John ka leka ana abaꞋi kula kalikalia kafo Ꞌi Jodan. Ma nia ka fata Ꞌuri fuana ngwae ki, “Muke kakari alifaꞋi faꞋasia taꞋangaꞋa kamu ki, ma muke siuabu, Ꞌiri God ke rufuanata ana taꞋangaꞋa kamu ki.” ");
INSERT INTO kwf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nia diꞋia nama ba sa Aesea na profet nia keresia ka Ꞌuri, “TaꞋi ngwae nia ke baꞋa ri Ꞌi saena abaꞋi kula kwasi ka Ꞌuri, ‘Na Aofia nia ke dao maꞋi! Kamu ke faꞋasaga na tala fuana! ");
INSERT INTO kwf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma muke faꞋafungua na oteotea ki, ma muke faꞋaotea na laꞋebusua ki ma faꞋi ua ki. Ma muke faꞋasaga na tala eꞋeoꞋa ki, ma muke faꞋadada na tala kilukiluꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma ngwae ki taꞋifau kike baꞋa lisia neꞋe God ke faꞋamaurida.’” ");
INSERT INTO kwf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma ngwae Ꞌoro ki kira leka maꞋi siana sa John fasi Ꞌiri nia ke siuabuda. Ma sa John ka fata Ꞌuri fuada, “Kamu diꞋia goꞋo amuꞋa kaela na baꞋeko tolo ki! NoaꞋa nau ku Ꞌiri saea laꞋu fuamuꞋa neꞋe na siuabuꞋanga ke faꞋatafi kamu faꞋasia na kwaꞋikwaꞋinga God sui bore Ꞌana noaꞋa kamu kasi kakari alifaꞋi. ");
INSERT INTO kwf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Muke sasia lala ru ki neꞋe nia faꞋataꞋinia kamu kakari alifaꞋi naꞋa faꞋasia na abula taꞋangaꞋa kamu ki! Ma noaꞋa kamu kasi manata Ꞌuri Ꞌi saena liamuꞋa, ‘Kami na ngwae kami futa maꞋi ana kwalafa sa Abraham naꞋa. ꞋAfitaꞋi ta kwaꞋikwaꞋinga faꞋasia God ka dao amiꞋa.’ Ma nau ku sae saga ana fuamuꞋa, nia talangwaraꞋu goꞋo ana fuana God ka ngalia ta gwaꞋi fau ana fau ki, ma ka saungaꞋinia Ꞌani kwalafa sa Abraham ki! ");
INSERT INTO kwf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ana kaidaꞋi neꞋe, God nia sasi akaꞋu naꞋa ana kwaꞋikwaꞋinga, diꞋia ta ngwae ba nia dau ana ta kwaꞋikwaꞋi, ma ka sasi akaꞋu fuana tufulana Ꞌai ki. Ma na Ꞌai ki taꞋifau neꞋe noaꞋa kasi fungu Ꞌani ta fuaꞋi ai leꞋa ki, nia ke tufuda, ma ka toꞋosida Ꞌi saena mafula.” ");
INSERT INTO kwf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sui, na ngwae ki kira ka saefiloa sa John kira ka Ꞌuri, “Ta tae neꞋe kami ke sasia ka faꞋataꞋinia neꞋe kami kakari alifaꞋi kwa?” ");
INSERT INTO kwf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma nia ka olisida ka Ꞌuri, “DiꞋia sa tai neꞋe nia toꞋo ana ro ifi ki, nia ka kwatea na ruana ifi fuana ta ngwae neꞋe noaꞋa nia kasi toꞋo ana ta ifi. Ma diꞋia ta ngwae neꞋe nia toꞋo ana fanga ki, nia ka daroꞋia.” ");
INSERT INTO kwf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma ti ngwae kwalabasa ana gonilana mani fuana takisi, kira dao logo maꞋi fuana siuabuꞋanga, ma kira saefilo kira ka Ꞌuri, “Ngwae faꞋamanata kwa, ta tae mo neꞋe kami ke sasi ka faꞋataꞋinia neꞋe kami kakari alifaꞋi kwa?” ");
INSERT INTO kwf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma sa John nia olisida ka Ꞌuri, “Muke fikua goꞋo mani neꞋe nia bolo faꞋinia mani neꞋe taki nia saea. NoaꞋa kamu kasi gani liufia na mani neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma ti ngwae ni ofoꞋa kira ka saefiloa logo kira ka Ꞌuri, “Ma kaimili niniꞋa, ta tae neꞋe kami ke sasi ka faꞋataꞋinia neꞋe kami kakari alifaꞋi kwa?” Ma nia ka fata Ꞌuri fuada, “Kamu kasi tuaraꞋinia ta ngwae fuana kwatelana mani fuaumulu. Ma noaꞋa kamu kasi gaurafua ta ngwae. Ma muke saeleꞋa goꞋo amuꞋa fafia na mani neꞋe kira foli kaumulu Ꞌania.” ");
INSERT INTO kwf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ngwae ki kira kwaimamani ana daolana maꞋi na Christ, na ngwae neꞋe God filia ka lafua ngwae nia ki, ꞋunaꞋeri ma kira fia Ꞌuri, “Sali sa John naꞋa neꞋe na Christ.” ");
INSERT INTO kwf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bore ma sa John ka fata lala Ꞌuri fuada, “Nau ku siufi kamu goꞋo Ꞌaku Ꞌani kafo, bore ma ngwae neꞋe ke baꞋa dao maꞋi nia talingaꞋi ka liufi nau. Ma nau noaꞋa kusi bolo faꞋinia neꞋe nai logea na taꞋe butu nia ki Ꞌi Ꞌaena. Ma nia ke baꞋa siuabu kamu Ꞌani AnoꞋi ru Abu ma Ꞌani mafula. ");
INSERT INTO kwf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma nia sasi akaꞋu naꞋa fuana matalangaꞋilana ngwae ki taꞋifau, ka diꞋia ta ngwae ba nia efoa na maga ru leꞋa ki faꞋasia na taꞋetaꞋeru ki. Ma nia ka fikua na maga ru leꞋa ki Ꞌi saena na luma ni goniruꞋa, ma ka duꞋafia naꞋa taꞋetaꞋeru ki saena na mafula neꞋe noaꞋa nia kasi mae.” ");
INSERT INTO kwf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma sa John ka fata sulia na FaꞋarongoꞋa LeꞋa fuada Ꞌani alaꞋanga Ꞌoro Ꞌuri ki, ma nia ka iribobo ada fasi Ꞌiri kira ke rokisia falafala kira ki. ");
INSERT INTO kwf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma ana kaidaꞋi neꞋeri logo, sa John ka fata ngasingasiꞋa liu fuana sa Herod, na ngwae neꞋe nia gwaungaꞋi fafia abaꞋi kula neꞋeri, duꞋungana sa Herod nia korea Ꞌi Herodias, na Ꞌafe ngwaefuta nia sa Filip, ma nia ka sasia naꞋa ru taꞋa Ꞌoro ki logo. ");
INSERT INTO kwf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma ta ru laꞋu neꞋe taꞋa ka tasa naꞋa neꞋe sa Herod nia sasia neꞋe, nia ngalia sa John, ma ka alua saena lokafo. ");
INSERT INTO kwf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma Ꞌi naꞋona kaidaꞋi sa John nia tua saena lokafo, nia siuabua naꞋa ngwae Ꞌoro ki. Sa Jesus nia leka maꞋi, ma sa John ka siuabua logo. Ma ana kaidaꞋi nia foꞋo, na lofana salo ka Ꞌifi, ");
INSERT INTO kwf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma na AnoꞋi ru Abu nia koso maꞋi fafia diꞋia ta bola. Ma taꞋi lingaꞋi fataꞋa nia talo maꞋi faꞋasia Ꞌi langi ka Ꞌuri, “ꞋAeꞋo naꞋa neꞋe ngela nau neꞋe nau ku alafe liu amu. Nau ku saeleꞋa liu faꞋiniꞋo.” ");
INSERT INTO kwf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ana kaidaꞋi sa Jesus nia bolo faꞋinia uulu akwala faꞋi ngali burina futa lana, nia ka talaꞋae ka leka liliu naꞋa fuana faꞋamanataꞋanga. Ma na ngwae ki taꞋifau, kira manata fasi sa Jesus nia na ngela sa Josef goꞋo. Bore ma Sa Josef neꞋeri neꞋe nia futa maꞋi ana sa Hilae. ");
INSERT INTO kwf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sa Hilae nia futa ana sa Matat, sa Matat ka futa ana sa Lifae, sa Lifae ka futa ana sa Melkae, sa Melkae ka futa ana sa Janae, sa Janae ka futa ana sa Josef. ");
INSERT INTO kwf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sa Josef na ngela sa Matataeas, sa Matataeas ka futa ana sa Emos, sa Emos ka futa ana sa Neham, sa Neham ka futa ana sa Eslae, sa Eslae ka futa ana sa Nagae. ");
INSERT INTO kwf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sa Nagae neꞋe ngela sa Meata, sa Meata ka futa ana sa Matataeas, sa Matataeas ka futa ana sa Semein, sa Semein ka futa ana sa Josek, sa Josek ka futa ana sa Joda. ");
INSERT INTO kwf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sa Joda na ngela sa Joanan, sa Joanan ka futa ana sa Risa, sa Risa ka futa ana sa Serababel, sa Serababel ka futa ana sa Sialtiel, sa Sialtiel ka futa ana sa Nirae. ");
INSERT INTO kwf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sa Nirae na ngela sa Melkae, sa Melkae ka futa ana sa Adae, sa Adae ka futa ana sa Kosam, sa Kosam ka futa ana sa Elmadam, sa Elmadam ka futa ana sa Ere. ");
INSERT INTO kwf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sa Ere na ngela sa Josua, sa Josua ka futa ana sa Eliesa, sa Eliesa ka futa ana sa Jorim, sa Jorim ka futa ana sa Matat, sa Matat ka futa ana sa Lifae. ");
INSERT INTO kwf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sa Lifae na ngela sa Simion, sa Simion ka futa ana sa Juda, sa Juda ka futa ana sa Josef, sa Josef ka futa ana sa Jonam, sa Jonam ka futa ana sa Elaeakim. ");
INSERT INTO kwf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sa Elaeakim na ngela sa Milia, sa Milia ka futa ana sa Mena, sa Mena ka futa ana sa Matata, sa Matata ka futa ana sa Netan, sa Netan ka futa ana sa David na tatalafaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sa David na ngela sa Jesi, sa Jesi ka futa ana sa Obed, sa Obed ka futa ana sa Boas, sa Boas ka futa ana sa Salmon, sa Salmon ka futa ana sa Nason. ");
INSERT INTO kwf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sa Nason na ngela sa Aminadab, sa Aminadab ka futa ana sa Admin, sa Admin ka futa ana sa Anae, sa Anae ka futa ana sa Hesron, sa Hesron ka futa ana sa Peres, sa Peres ka futa ana sa Juda. ");
INSERT INTO kwf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sa Juda na ngela sa Jakob, sa Jakob ka futa ana sa Aesak, sa Aesak ka futa ana sa Abraham, sa Abraham ka futa ana sa Tera, sa Tera ka futa ana sa Neho. ");
INSERT INTO kwf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sa Neho na ngela sa Sirag, sa Sirag ka futa ana sa Riu, sa Riu ka futa ana sa Pileg, sa Pileg ka futa ana sa Eba, sa Eba ka futa ana sa Sela. ");
INSERT INTO kwf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa Sela na ngela sa Keinan, sa Keinan ka futa ana sa Afaksad, sa Afaksad ka futa ana sa Siem, sa Siem ka futa ana sa Noa, sa Noa ka futa ana sa Lamek. ");
INSERT INTO kwf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sa Lamek na ngela sa Metusala, sa Metusala ka futa ana sa Enok, sa Enok ka futa ana sa Jered, sa Jered ka futa ana sa Mahelalel, sa Mahelalel ka futa ana sa Kenan. ");
INSERT INTO kwf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sa Kenan na ngela sa Enos, sa Enos ka futa ana sa Set, sa Set ka futa ana sa Adam na ngela God. ");
INSERT INTO kwf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na AnoꞋi ru Abu nia sura ana sa Jesus, ma sa Jesus ka oli maꞋi faꞋasia na kafo Ꞌi Jodan, ma na AnoꞋi ru Abu ka talaꞋia Ꞌuana saena abaꞋi kula kwasi. ");
INSERT INTO kwf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma sa Saetan ka ilitoꞋona Ꞌi neꞋeri sulia fai akwala faꞋi asoa ki. Ma sulia asoa neꞋeri ki, sa Jesus kasi Ꞌania goꞋo ta fanga, ma nia ka fiolo liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma sa Saetan ka fata Ꞌuri fuana, “OsiꞋana neꞋe ꞋaeꞋo na Ngela God, Ꞌoke fata fuana gwaꞋi fau neꞋe Ꞌiri ke alua ta afu beret.” ");
INSERT INTO kwf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma sa Jesus ka olisia ka Ꞌuri, “Na KerekereꞋa Abu nia saea, ‘Na ngwae noaꞋa kasi mauri goꞋo Ꞌani fanga taꞋifilia.’” ");
INSERT INTO kwf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui sa Saetan ka talaꞋia Ꞌuana gwauna totoloa neꞋe fane liu, ma ana kaidaꞋi tiꞋitiꞋi goꞋo, nia ka faꞋataꞋinia naꞋa fuana na ꞋinotoꞋanga ki taꞋifau ana magalia. ");
INSERT INTO kwf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma nia ka fata Ꞌuri fuana sa Jesus, “Nai baꞋa kwatea na ꞋinotoꞋanga neꞋe ki taꞋifau, ma na ru leꞋa ki taꞋifau fuamu. OsiꞋana na ru neꞋe ki, na ru nau ki goꞋo taꞋifau, ma nau ku saiana nai kwateꞋe taꞋifau goꞋo fuana ta ngwae goꞋo Ꞌana neꞋe nau ku filia. ");
INSERT INTO kwf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma diꞋia Ꞌoko bobo uruuru, ma Ꞌoko foꞋosi nau, nau kui kwatea na ꞋinotoꞋanga neꞋe taꞋifau goꞋo fuamu.” ");
INSERT INTO kwf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma sa Jesus nia olisia ka Ꞌuri, “Na KerekereꞋa Abu nia saea, ‘TaꞋifilia God Ꞌoe goꞋo neꞋe Ꞌoke foꞋosia, ma Ꞌoke rao fuana.’” ");
INSERT INTO kwf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui, sa Saetan ka talaꞋi laꞋu Ꞌuana na fanoa doe ba Ꞌi Jerusalem, ma nia ka faꞋauua ana taꞋi kula neꞋe nia raꞋe liu Ꞌi langi fafona na Luma Abu God. Ma nia ka fata Ꞌuri fuana sa Jesus, “DiꞋia ꞋaeꞋo na Ngela God, Ꞌoke lofo toli Ꞌi ano faꞋasia Ꞌi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sulia na KerekereꞋa Abu nia saea, ‘God ke baꞋa kwatea maꞋi na Ꞌainsel nia ki, Ꞌiri kira ka tagi suliꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma kira ka sakua ꞋaeꞋo, fasi Ꞌiri na Ꞌaemu bore kasi foto ana ta gwaꞋi fau.’” ");
INSERT INTO kwf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma sa Jesus nia olisia ka Ꞌuri, “Na KerekereꞋa Abu nia fata logo Ꞌuri, ‘NoaꞋa Ꞌoe kosi ilitoꞋona God Ꞌoe.’” ");
INSERT INTO kwf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ꞋI buri Ꞌana sa Saetan nia ilitoꞋona sa Jesus Ꞌani ru neꞋeri ki taꞋifau, nia ka leka naꞋa faꞋasia sa Jesus, ma ka maꞋasia ta kaidaꞋi leꞋa ka oli. ");
INSERT INTO kwf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma na ngasingasiꞋanga ana na AnoꞋi ru Abu nia tua faꞋinia sa Jesus, ma nia ka oli naꞋa Ꞌuana na abaꞋi kula Ꞌi Galili. Ma na alaꞋanga sulia ka talofia saena na bali abaꞋi kula neꞋeri taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma nia ka faꞋamanata saena na luma fuana foꞋongaꞋa kira ki, ma na ngwae ki taꞋifau kira ka auraꞋea niaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sui sa Jesus ka leka Ꞌuana Ꞌi Nasaret, fanoa ba nia doe maꞋi saena. Ma ana Sabat, na asoa ana mamaloꞋanga, nia ka leka Ꞌi saena na luma fuana foꞋongaꞋa sulia na falafala nia. Ma nia ka tataꞋe fuana na toꞋomaꞋilana na KerekereꞋa Abu, ");
INSERT INTO kwf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma kira ka kwatea fuana na kerekereꞋa na profet Aesea nia keresia. Ma nia ka Ꞌifingia, ma ka dao toꞋona kula neꞋe sa Aesea nia keresia ka fata Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na AnoꞋi ru God nia sura naꞋa aku, osiꞋana nia fili nau Ꞌiri nai fata sulia na FaꞋarongoꞋa LeꞋa fuana ngwae dalaꞋa ki. Ma nia ka kwate nau maꞋi Ꞌiri nai faꞋatalo Ꞌania fuana ngwae ki neꞋe kira tua Ꞌi saena lokafo, kira ke baꞋa aloge. Ma nai baꞋa gura na ngwae neꞋe maada rodo ki. Ma nai baꞋa logea na ngwae ki neꞋe kira mala taꞋa ada ki. ");
INSERT INTO kwf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma nai faꞋarongo Ꞌania kaidaꞋi nia dao naꞋa maꞋi fuana na Aofia ka faꞋamauria na ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","KaidaꞋi sa Jesus nia toꞋomani ka sui, nia ka laꞋu naꞋa fafia na kerekereꞋa neꞋeri, ma ka olitaꞋinia fuana ngwae neꞋe nia lia sulia luma fuana foꞋongaꞋa, ma ka tua Ꞌi ano ka faꞋamanata. Ma na ngwae ki taꞋifau neꞋe kira tua Ꞌi saena na luma fuana foꞋongaꞋa neꞋeri, kira ka bubu totongaꞋi naꞋa fuana. ");
INSERT INTO kwf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma nia talaꞋae ka alaꞋa fuada ka Ꞌuri, “KerekereꞋa Abu neꞋe, nia fuli mamana naꞋa Ꞌi taꞋena, ana kaidaꞋi neꞋe kamu rongoa nau ku toꞋomani kwau fuamuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma na ngwae ki taꞋifau kira ka fataleꞋa leꞋa ana, ma kira ka Ꞌarefo liu duꞋungana alaꞋalana leꞋa. Ma kira ka fata Ꞌuri, “ꞋUri ma noaꞋa laꞋu na ngela ba sa Josef goꞋo niniꞋa re? Ma nia saea neꞋe nia faꞋamamana na KerekereꞋa Abu neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma sa Jesus ka fata Ꞌuri fuada, “Nau ku saiana kamu ke fata Ꞌuri fuaku, ‘Ngwae kwaigurai Ꞌae, Ꞌoke gura Ꞌoe basi talamu.’ Ma kamu ke fata logo Ꞌuri fuaku, ‘ꞋOke sasia basi saena fanoa Ꞌoe na ru ba kami rongoa Ꞌoko sasiꞋi ki maꞋi ana fanoa Ꞌi Kapaneam.’” ");
INSERT INTO kwf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui sa Jesus ka fata laꞋu Ꞌuri, “Nau ku saea na ru mamana fuamuꞋa, nia ꞋafitaꞋi fuana kira ka kwaloa na profet Ꞌi saena fanoa nia talana. ");
INSERT INTO kwf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nau ku saea laꞋu fuamuꞋa, na kini Ꞌoro Jiu ki neꞋe kira Ꞌuru, kira tua Ꞌi Israel ana kaidaꞋi sa Elaeja nia tua ana. Ma kaidaꞋi baera na uta noaꞋa kasi toꞋo sulia uulu faꞋi ngali ma ono madamo ki, ma na fioloꞋa doe ka liu logo ana fanoa kia ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma God noaꞋa kasi kwatea laꞋu sa Elaeja siana gwaꞋi Ꞌuru neꞋe kira Ꞌi Israel ki. Bore ma nia kwatea lala sa Elaeja siana taꞋi gwaꞋi Ꞌuru neꞋe noaꞋa laꞋu kini Jiu neꞋe nia tua Ꞌi Serefat, fanoa saena abaꞋi kula Ꞌi Saedon. ");
INSERT INTO kwf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma na ngwae Ꞌoro Jiu ki Ꞌi Israel na kuu nia saungida, ana kaidaꞋi sa Elaesa nia profet. Ma nia noaꞋa kasi gura goꞋo ta ngwae ada. TaꞋifilia goꞋo sa Neman na ngwae neꞋe noaꞋa laꞋu Jiu neꞋe leka maꞋi faꞋasia fanoa Ꞌi Siria goꞋo neꞋe sa Elaesa nia gura.” ");
INSERT INTO kwf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma kaidaꞋi kira rongoa ru neꞋeri, na ngwae ki taꞋifau saena na luma fuana foꞋongaꞋa, kira ka saetaꞋa. Kira saetaꞋa duꞋungana neꞋe sa Jesus saea God ke baꞋa Ꞌafia lala na ngwae neꞋe noaꞋa laꞋu Jiu ki, ma kira ka noaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma kira ka tataꞋe, ma kira ka lalia sa Jesus faꞋasia na fanoa neꞋeri. Ma kira ka tori kwailiu ana sa Jesus Ꞌuana gwauna faꞋi ua neꞋe kira saungaꞋinia na fanoa kira Ꞌi fafona, fasi Ꞌiri kira ka Ꞌui Ꞌania sa Jesus Ꞌi ano, Ꞌiri nia ke mae. ");
INSERT INTO kwf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bore ma, nia dola goꞋo Ꞌana Ꞌi safitana na fikuꞋa neꞋeri, ma ka leka naꞋa Ꞌana faꞋasida. ");
INSERT INTO kwf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sui, sa Jesus ka leka Ꞌuana Ꞌi Kapaneam, taꞋi fanoa ana abaꞋi kula Ꞌi Galili. Ma ana taꞋi Sabat, na asoa ana mamaloꞋanga, nia ka faꞋamanata ngwae ki Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma na ngwae neꞋe kira fiku maꞋi siana Ꞌi saena luma fuana foꞋongaꞋa, kira Ꞌarefo liu ana faꞋamanataꞋanga nia ki, osiꞋana sa Jesus nia alaꞋa Ꞌani ngasingasiꞋanga ma na mamanaꞋanga maꞋi ana God. ");
INSERT INTO kwf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma taꞋi ngwae neꞋe anoꞋi ru taꞋa ruꞋufia, nia tua logo Ꞌi neꞋeri. GoꞋo nia ka ako ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Sa Jesus ngwae Ꞌi Nasaret Ꞌae, nau ku saiamu ꞋaeꞋo na Ngwae Abu God. Tae nini Ꞌoko oga Ꞌoke sasi aimili? Sali Ꞌoko leka maꞋi fuana malangisi laimili taka niniꞋa?” ");
INSERT INTO kwf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sa Jesus ka balufia na anoꞋi ru taꞋa neꞋeri, ka Ꞌuri, “ꞋOke noto Ꞌamu, ma Ꞌoko ruꞋu maꞋi Ꞌi maa faꞋasia ngwae neꞋana!” Ma na anoꞋi ru taꞋa neꞋeri ka Ꞌui Ꞌania ngwae neꞋeri Ꞌi ano Ꞌi naꞋona fikuꞋa neꞋeri, ma ka fiꞋi ruꞋu tafa naꞋa maꞋi faꞋasia. Ma na ngwae neꞋeri noaꞋa kasi maala goꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na ngwae neꞋe kira fiku Ꞌi neꞋeri ki, kira Ꞌarefo liu, ma kira ka saefilo kwailiu ada, ma kira ka Ꞌuri, “Na faꞋamanataꞋanga tae naꞋa neꞋe Ꞌuri re? Ngwae neꞋe nia ifulangani na anoꞋi ru taꞋa ki Ꞌani mamanaꞋanga faꞋinia ngasingasiꞋanga, ma kira ka sakatafa taꞋifau maꞋi Ꞌi maa!” ");
INSERT INTO kwf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma na alaꞋanga sulia sa Jesus ka talo ana fanoa ki taꞋifau kalikalia abaꞋi kula neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sui sa Jesus nia ka leka faꞋasia na luma fuana foꞋongaꞋa, ma ka leka Ꞌi luma sa Simon. ꞋUnaꞋeri ma na funga kini sa Simon, nia mataꞋi Ꞌania ꞋakoꞋakoꞋanga doe ana kaidaꞋi neꞋeri. Ma kira ka gania sa Jesus fasi Ꞌiri ke gura. ");
INSERT INTO kwf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ꞋUnaꞋeri goꞋo sa Jesus leka ka uu Ꞌi ninimana ꞋifitaꞋi kini neꞋeri, ma nia ka fiꞋi balufia na ꞋakoꞋakoꞋanga neꞋeri faꞋasia. Ma na Ꞌafe neꞋeri ka Ꞌakwa naꞋa, ma nia tataꞋe ka duꞋuru, ma ka kwatea naꞋa fanga fuada. ");
INSERT INTO kwf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ana kaidaꞋi neꞋe sina nia suu naꞋa, ma ana asoa Jiu ki fuana mamaloꞋanga ni sui naꞋa, ngwae Ꞌoro ki kira ngalia maꞋi na ngwae kwaima kira ki neꞋe mataꞋinga toꞋotoꞋo ki saungida siana sa Jesus. Ma sa Jesus ka alua limana Ꞌi fafida, ma ka gurada taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka ꞋunaꞋeri laꞋu, anoꞋi ru taꞋa Ꞌoro ki kira tafi faꞋasia ngwae ki, ma kira ka ako Ꞌuri, “ꞋAeꞋo na Ngela God!” Ma sa Jesus ka lui totongaꞋi ana anoꞋi ru taꞋa neꞋeri ki noaꞋa kira kasi alaꞋa, osiꞋana kira saiana ka sui naꞋa neꞋe niaꞋa na Christ, na ngwae God nia filia fuana lafulana ngwae nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ꞋOfodangi kaidaꞋi nia laꞋa naꞋa, sa Jesus nia leka faꞋasia fanoa Ꞌi Kapaneam, ka leka Ꞌuana taꞋi kula neꞋe aroaro. Ma na ngwae ki kira ka talaꞋae kika lulu Ꞌuana, ma kaidaꞋi kira dao toꞋona, kira ka fata Ꞌuri fuana, “ꞋOe kasi leka faꞋasia na fanoa neꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bore ma sa Jesus ka fata Ꞌuri fuada, “God nia kwate nau maꞋi fuana faꞋataloꞋanga Ꞌania na FaꞋarongoꞋa LeꞋa, ꞋunaꞋeri neꞋe nai leka nama kwau saena ti fanoa matamata logo, Ꞌiri nai talongaꞋinia neꞋe God ke gwaungaꞋi fafia ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma sa Jesus ka faꞋarongo Ꞌani FaꞋarongoꞋa LeꞋa saena luma fuana foꞋongaꞋa ki ana abaꞋi kula ki Ꞌi Israel. ");
INSERT INTO kwf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ana taꞋi asoa, sa Jesus nia uu ka faꞋamanata Ꞌi ninimana Ꞌosi doe Ꞌi Galili, ma na ngwae Ꞌoro ki kira faisuꞋusuꞋu maꞋi siana fuana rongolana na fatalana God. ");
INSERT INTO kwf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma nia ka lisia na ro gwaꞋi baru na ngwae dee ki kira faꞋasiꞋi ka teo goꞋo Ꞌani Ꞌi malitako, ma kira ka taufia na furai kira ki. ");
INSERT INTO kwf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma sa Jesus nia ka raꞋe Ꞌi saena gwaꞋi baru sa Simon, ma ka saea fuana nia ke usungaꞋi tiꞋitiꞋi kwau ana faꞋasia Ꞌi sara. Ma sa Jesus ka tua Ꞌi saena na gwaꞋi baru neꞋeri, ma ka inaꞋu ana faꞋamanatalana na ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma kaidaꞋi nia faꞋamanata na ngwae ki ka sui naꞋa, nia ka fata Ꞌuri fuana sa Simon, “Mulu usungaꞋinia laꞋu kwau na gwaꞋi baru neꞋe Ꞌuana kula Ꞌato, sui kamu ka ala Ꞌania na furai kamu ki fuana deelana maꞋi na iꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma sa Simon ka olisia ma ka Ꞌuri, “FaꞋamanata Ꞌae, kaimili rao laga ulafu naꞋa maꞋi sulia rodo laꞋulaꞋu neꞋe, bore ma noaꞋa kami kasi deea goꞋo ta iꞋa. Bore ma sulia fatalamu, nau kui ala naꞋa aku Ꞌani furai neꞋe ki.” ");
INSERT INTO kwf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma kaidaꞋi kira ala Ꞌani na furai neꞋeri ki, kira ka deea naꞋa iꞋa Ꞌoro liu ki, ma na furai ki karangi ka muu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sui kira ka karumia maꞋi na ngwae kwaima kira ki Ꞌi saena ta gwaꞋi baru laꞋu, fasi Ꞌiri kira ke leka maꞋi, kira ke kwaiꞋafi ada. ꞋUnaꞋeri kira ka dao maꞋi, ma kira ka faꞋafungua ro gwaꞋi baru neꞋeri ki Ꞌani iꞋa leleka karangi kira ka kuru goꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma kaidaꞋi sa Simon Peter nia lisia na ru neꞋeri, nia leka maꞋi ka bobo uruuru Ꞌi naꞋona sa Jesus, ma ka fata Ꞌuri, “Aofia Ꞌae, leka kwau Ꞌamu faꞋasi nau! NauꞋa na ngwae taꞋa liu!” ");
INSERT INTO kwf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sa Simon faꞋinia na ngwae neꞋe kira tua Ꞌi neꞋeri ki, kira ka Ꞌarefo liu ana iꞋa Ꞌoro neꞋe kira deea. ");
INSERT INTO kwf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma na ro ngwae neꞋe kera rao faꞋinia sa Simon, neꞋe satada sa James ma sa John, na ro ngela sa Sebedi ki, kera ka Ꞌarefo liu logo. Ma sa Jesus ka fata Ꞌuri fuana sa Simon, “NoaꞋa Ꞌoe kosi maꞋu laꞋu. ꞋI naꞋo ba Ꞌoko deea iꞋa ki, bore ma Ꞌita Ꞌi taꞋena ka oli ꞋalaꞋa, Ꞌoke deea lala na ngwae ki Ꞌiri kira ke faꞋamamana ana God.” ");
INSERT INTO kwf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma kaidaꞋi kira dao naꞋa Ꞌi sara, kira ka faꞋasia naꞋa gwaꞋi baru ki sulia one, ma kira ka faꞋasia ru ki taꞋifau, ma kira ka leka naꞋa faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana taꞋi asoa, sa Jesus nia tua Ꞌi saena taꞋi fanoa, ma taꞋi ngwae neꞋe kuu nia saungia, nia tua logo Ꞌi neꞋeri. KaidaꞋi nia lisia sa Jesus, nia leka maꞋi siana, ka bobo uruuru Ꞌi naꞋona, ma ka gania ka fata Ꞌuri, “AraꞋi kwa, diꞋia Ꞌoko maꞋudi, Ꞌoko saiana Ꞌoke gura nau goꞋo Ꞌamu kwa.” ");
INSERT INTO kwf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sui sa Jesus ka taga kwau na limana, ma ka sama toꞋona nonina, ma ka fata Ꞌuri, “ꞋIu, nau ku maꞋudi. ꞋOke mafo naꞋa.” Ma ꞋaliꞋali Ꞌi buri Ꞌana alaꞋanga neꞋeri ki sa Jesus saea goꞋo, na kuu neꞋeri ka siki naꞋa faꞋasia ngwae neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sui sa Jesus ka olitani kwau na ngwae neꞋeri ka fata Ꞌuri fuana, “NoaꞋa Ꞌoe kosi faꞋarongoa laꞋu Ꞌani ta ngwae ana ru neꞋe ki. Bore ma Ꞌoke leka basi Ꞌamu siana na fata abu, ma Ꞌoke faꞋataꞋinia na nonimu fuana, Ꞌiri nia ke saiana neꞋe Ꞌoko Ꞌakwa naꞋa. Sui Ꞌoko kwatea na kwaisuꞋusiꞋanga sa Moses nia saea Ꞌiri ngwae ki taꞋifau kira ka faꞋamamana neꞋe na kuu neꞋe teoteo Ꞌi nonimu nia siki naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nia ka ꞋunaꞋeri bore Ꞌana, na faꞋarongoꞋanga sulia ru neꞋe sa Jesus fuliꞋi ki, nia talofia naꞋa kula Ꞌoro ki, ma na ngwae Ꞌoro ki kira ka leka maꞋi siana fuana rongolana faꞋamanataꞋanga nia ki, ma fasi Ꞌiri sa Jesus ka gurada logo faꞋasia na mataꞋinga kira ki. ");
INSERT INTO kwf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma kaidaꞋi Ꞌoro, sa Jesus nia leka nama faꞋasia ngwae ki Ꞌuana kula aroaro ki fuana foꞋongaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","TaꞋi asoa, kaidaꞋi sa Jesus nia faꞋamanata saena taꞋi luma, ti Farasi faꞋinia ngwae faꞋamanata ana taki ki, kira tua logo Ꞌi neꞋeri. Kira leka maꞋi faꞋasia fanoa Ꞌoro ki ana abaꞋi kula Ꞌi Galili faꞋinia Ꞌi Judea, ma Ꞌi Jerusalem. Ma na ngasingasiꞋanga God ka tua faꞋinia sa Jesus, Ꞌiri nia ka gura ngwae neꞋe kira mataꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma ti ngwae ngalia maꞋi taꞋi ngwae neꞋe nonina taꞋu, kira ngalia maꞋi Ꞌi fafona ꞋifitaꞋi. Kira ka sasi ngangata Ꞌuana ruꞋungaꞋa Ꞌi luma faꞋinia, fasi Ꞌiri kira ka alua Ꞌi naꞋona sa Jesus, fuana nia ka gura. ");
INSERT INTO kwf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bore ma osiꞋana na fikuꞋa neꞋeri doe liu, ngwae kwaima ana ngwae neꞋe kasi bolo naꞋa fuana ruꞋungaꞋa kwau Ꞌi luma siana sa Jesus. ꞋUnaꞋeri kira ka ngalia ngwae neꞋeri, kira ka raꞋe faꞋinia Ꞌi fafona luma, ma kira ka tafangia taꞋi maꞋe kwakwa doe, kira ka faꞋakosoa maꞋi na ngwae neꞋeri Ꞌi fafona ꞋifitaꞋi siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma kaidaꞋi sa Jesus nia lisia na faꞋamamanaꞋanga kira, nia ka fata Ꞌuri fuana ngwae neꞋe nonina taꞋu, “Ngwade Ꞌae, nau ku rufuanata naꞋa ana taꞋangaꞋa Ꞌoe ki.” ");
INSERT INTO kwf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma na ngwae faꞋamanata ana taki ki faꞋinia Farasi ki, kira ka ngunungunu buri fuada kwailiu ma kira ka fata Ꞌuri, “Reala kwa! Nia saea niaꞋa ta ngwae faꞋuta mala niniꞋa? Nia faꞋabolotaꞋinia naꞋa faꞋinia God. Ngwae ki noaꞋa kasi rufuanata ana taꞋangaꞋa ki. TalitoꞋona goꞋo God neꞋe saiana rufuanatalana taꞋangaꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sa Jesus nia sai logo ana manataꞋanga kira ki saena liada, ma nia ka fata Ꞌuri fuada, “Kamu kasi manata laꞋu ꞋunaꞋeri.” Ma sa Jesus sai logo ana neꞋe kira faꞋamamana talitoꞋona goꞋo God neꞋe ke gura ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","GoꞋo ꞋunaꞋeri nia ka fata Ꞌuri, “DiꞋia nau ku fata Ꞌuri fuana ngwae nonina taꞋu neꞋe ku Ꞌuri, ‘TaꞋangaꞋa Ꞌoe ki, nau ku rufuanata naꞋa ani,’ kaumulu kasi lisia goꞋo neꞋe nia fuli. Bore ma diꞋia nau ku fata Ꞌuri, ‘TataꞋe, ma Ꞌoko fali,’ Ꞌi neꞋeri kamu ka fiꞋi lisia neꞋe ngasingasiꞋanga nia aku fuana guraꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","KaidaꞋi nai gura ngwae neꞋe, nai faꞋataꞋinia fuamuꞋa neꞋe nauꞋa, Ngela Ngwae, nau ku toꞋo ana ngasingasiꞋanga fuana nai rufuanata ana taꞋangaꞋa ki.” Sui sa Jesus ka fata Ꞌuri fuana ngwae nonina taꞋu neꞋeri, “Nau ku saea fuamu, Ꞌoke tataꞋe naꞋa, ngalia ꞋifitaꞋi Ꞌoe, ma Ꞌoko leka naꞋa Ꞌi fanoa Ꞌoe.” ");
INSERT INTO kwf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma na ngwae neꞋeri, ꞋaliꞋali nia ka tataꞋe naꞋa Ꞌi naꞋoda, goꞋo nia ka ngalia ꞋifitaꞋi neꞋe nia teo Ꞌi fafona, ma ka oli Ꞌi fanoa faꞋinia baꞋatafeꞋanga doe fuana God. ");
INSERT INTO kwf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma kira taꞋifau kira ka Ꞌarefo liu naꞋa, ma kira ka baꞋatafea God. Ru neꞋe kira lisia kira Ꞌarefo liu, kika Ꞌuri, “ꞋIu, ru ni ꞋarefoꞋa doe liu niniꞋa kulu lisia Ꞌi taꞋena.” ");
INSERT INTO kwf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Buri Ꞌana ru neꞋeri, sa Jesus nia leka kwau Ꞌi maa, ma ka lisia sa Lifae, na ngwae ni gonilana mani ana takisi, nia tua ana kula neꞋe nia rao ana. Sa Jesus ka fata Ꞌuri fuana, “ꞋOke leka maꞋi faꞋinau.” ");
INSERT INTO kwf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sa Lifae ka tataꞋe, ma ka faꞋasi buri ana ru nia ki taꞋifau, ma ka leka faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sui sa Lifae ka sasia taꞋi fangaꞋa doe fuana sa Jesus Ꞌi luma nia. Ma ana kaidaꞋi neꞋeri logo, na ngwae Ꞌoro neꞋe kira gonia mani Ꞌani takisi ki faꞋinia ti ngwae laꞋu, kira fanga faꞋinia sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ti Farasi ma ngwae faꞋamanata ana taki ki kira ka saetaꞋa, ma kira ka fata Ꞌuri fuana fafarongo sa Jesus ki, “Nia bolo faꞋinia nia kasi fanga ma ka kwaꞋu laꞋu faꞋinia ngwae goni mani ana takisi ma ngwae taꞋa Ꞌufuni ki.” ");
INSERT INTO kwf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sa Jesus nia olisida ka fata Ꞌuri, “Ngwae neꞋe noaꞋa kira kasi mataꞋi ki, kira kasi oga goꞋo ta ngwae kwaigurai, bore ma ngwae neꞋe kira mataꞋi ki tari, kira ka boꞋoboꞋo Ꞌuana ngwae kwaigurai. ");
INSERT INTO kwf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau Ꞌiri leka laꞋu maꞋi fuana laefilana ngwae ꞋoloꞋolo ki Ꞌiri kira ke kakari alifaꞋi, bore ma na ngwae neꞋe abulalada taꞋa ki lala tari, nau ku leka maꞋi fuana laefilada Ꞌuana rokisi manataꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ti ngwae kira fata Ꞌuri fuana sa Jesus, “Ana kaidaꞋi Ꞌoro ki, na fafarongo sa John ki kira abu fanga fuana foꞋongaꞋa, ma na fafarongo Farasi ki kira ka ꞋunaꞋeri logo. Bore ma na fafarongo Ꞌoe ki, kira fanga ma kira ka kwaꞋu goꞋo Ꞌada.” ");
INSERT INTO kwf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sa Jesus olisida ka fata Ꞌuri, “Nia kasi bolo faꞋinia toꞋa neꞋe kira tua ana fafangaꞋa ana ara araꞋinga neꞋe kira ka abu fanga. DuꞋungana neꞋe, kaidaꞋi araꞋi faolu nia goꞋo Ꞌana Ꞌua faꞋinida ngwae ki, kira saeleꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bore ma kaidaꞋi ke dao maꞋi aigaꞋi neꞋe kira ke baꞋea na araꞋi faolu faꞋasida. ꞋUnaꞋeri mala, kira fiꞋi abu fanga laꞋu, osiꞋana neꞋe kira kwaimanatai. Ta neꞋe noaꞋa Ꞌiri bolo fuana na fafarongo nau ki kira ka abu fanga goꞋo Ꞌada kaidaꞋi nau ku tua faꞋinida.” ");
INSERT INTO kwf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sui sa Jesus ka fata Ꞌani tarifulaꞋa fuada logo Ꞌuri, “Nia kasi bolo fuana muke ngali ta ngisingisi toro faolu fuana subungilana ta toro neꞋe nia Ꞌua. Si diꞋia ta ngwae sasia na ru neꞋeri, na ngisingisi toro faolu neꞋeri ka gasia na toro Ꞌua neꞋeri, duꞋungana toro faolu nia lukuluku Ꞌi buri Ꞌana ngwasilana, ma na toro faolu kasi lia leꞋa goꞋo faꞋinia na toro Ꞌua. ");
INSERT INTO kwf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma muke sai logo ana, noaꞋa nia kasi bolo fuana ta ngwae ka alua naꞋa waen faolu Ꞌi saena ngwaꞋi Ꞌua ana ꞋuꞋuila nanigot, duꞋungana ngwaꞋi ru Ꞌua neꞋeri noaꞋa kasi baꞋu. Si diꞋia nia sasia ru ꞋunaꞋeri, kaidaꞋi na waen neꞋeri ke totoro goꞋo maꞋi, nia ka foga naꞋa ngwaꞋi ru Ꞌua neꞋeri, ma na waen neꞋeri ka kisitaꞋi, ma na ngwaꞋi ru neꞋeri ka taꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nia neꞋe ngwae ke alua nama waen faolu Ꞌi saena na ngwaꞋi ru faolu neꞋe nia saiana ke baꞋu. ");
INSERT INTO kwf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ta ngwae neꞋe ꞋidufaꞋi kwaꞋufia goꞋo ana waen Ꞌua, noaꞋa nia kasi oga na waen faolu. OsiꞋana nia fata Ꞌuri, ‘Na waen Ꞌua neꞋe kwaꞋufilana mamasiꞋa ka leꞋa kwa.’” ");
INSERT INTO kwf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","TaꞋi Sabat, asoa ana mamaloꞋanga, sa Jesus faꞋinia fafarongo nia ki kira leleka, ma kira ka liu toꞋo folo ana taꞋi oꞋolaꞋi witi, na ru kira saungani fuana beret. Ma kaidaꞋi kira liu ana, na fafarongo nia ki kira ka loia ti fingi ru, ma kira ka ꞋasaꞋasanga saena limada, ma kira ka Ꞌania. ");
INSERT INTO kwf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma kaidaꞋi ngwae ana Farasi ki kira lisia, kira ka fata Ꞌuri, “Ru neꞋe kaumulu sasia nia Ꞌoia na taki sa Moses, osiꞋana kamu loia witi neꞋe ana Sabat, asoa ana mamaloꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sa Jesus ka olisida ka Ꞌuri, “Nau ku saiana kaumulu toꞋomaꞋi sulia saena Buka Abu na ru ba sa David na tatalafaꞋa nia sasia Ꞌi naꞋo. Ana kaidaꞋi neꞋeri, sa David faꞋinia ngwae nia ki kira fiolo liu, ");
INSERT INTO kwf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","nia ka leka Ꞌi saena na luma God, ma na ꞋingataꞋi fata abu ka kwatea fuana sa David na beret neꞋe kira Ꞌau abua fuana God. Ma sa David ka Ꞌania naꞋa beret neꞋeri, ma ka kwatea logo fuana ngwae nia ki, ma kira ka Ꞌania. Bore ma na taki kulu alaꞋani fuana talitoꞋona goꞋo na fata abu God ki neꞋe kira saiana Ꞌanilana. Ma noaꞋa kulu kasi lisia saena Buka Abu neꞋe God nia saetaꞋa fuana sa David.” ");
INSERT INTO kwf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sui sa Jesus ka fata naꞋa Ꞌuri, “Nau, na Ngela Ngwae, nau ku toꞋo ana na ngasingasiꞋanga fuana saelana ru ki fuana ngwae ki kira saiana kike sasia goꞋo Ꞌada ana asoa ana mamaloꞋanga.” ");
INSERT INTO kwf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma ana ta asoa ana Sabat logo, sa Jesus ka leka saena luma fuana foꞋongaꞋa ma ka faꞋamanata. Ma taꞋi ngwae nia tua logo Ꞌi neꞋeri neꞋe lima ꞋoloꞋolo ana nia mae. ");
INSERT INTO kwf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma ti ngwae faꞋamanata ana taki ki, ma na Farasi ki, kira ka tua logo Ꞌi neꞋeri, ma kira ka lialia Ꞌuana diꞋia sa Jesus ke gura ngwae neꞋeri ana Sabat, asoa ana mamaloꞋa. DiꞋia ꞋunaꞋeri, kira ka fata maana sa Jesus ana Ꞌoilana taki God ana guraꞋa, ru neꞋeri kira manata sulia ma nia diꞋia raoꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma sa Jesus nia saiana goꞋo Ꞌana manatada, ma nia ka fata Ꞌuri fuana ngwae neꞋe limana mae, “TataꞋe maꞋi, Ꞌoko uu maꞋi Ꞌi naꞋona ngwae ki taꞋifau.” Ma ngwae neꞋeri ka tataꞋe, ma ka leka maꞋi siana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma sa Jesus ka fata Ꞌuri fuana Farasi ki, ma na ngwae faꞋamanata ana taki ki, “Nau ku saefilo kamu basi. Tae neꞋe taki kulu nia alaꞋania fasi Ꞌiri kulu ka sasia ana asoa ana mamaloꞋanga? Nia alaꞋania sasilana ru leꞋa ki, nama sasilana ru taꞋa ki? Nia alaꞋania na faꞋamaurilana ta ngwae, nama saungilana ta ngwae?” ");
INSERT INTO kwf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa Jesus nia fata ꞋunaꞋeri ka sui, nia ka lia kwailiu fuada, goꞋo nia ka fata Ꞌuri fuana ngwae neꞋe limana nia mae, “Taga maꞋi limamu.” Ma nia ka taga, ma na limana ka leꞋa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ana kaidaꞋi kira lisia, kira ka saetaꞋa liu, ma kira ka alaꞋa fiku ma kira ka manata Ꞌoi ru Ꞌuana tae neꞋe kike sasia ana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ana ta kaidaꞋi logo, sa Jesus ka raꞋe Ꞌuana gwauna faꞋi ua Ꞌiri nia ka foꞋo. Ma saena rodo laꞋulaꞋu neꞋeri, nia ka foꞋosia God. ");
INSERT INTO kwf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","KaidaꞋi nia Ꞌofodangi naꞋa, nia ka saea maꞋi fafarongo nia ki siana, ma ka filia akwala ma ro ngwae, ma ka saeda Ꞌani lifurongo ki. ");
INSERT INTO kwf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na satada: sa Simon neꞋe sa Jesus faꞋasata Ꞌani sa Peter, ma sa Andrew na ngwaefuta nia, ma sa James, ma sa John, ma sa Filip, ma sa Batolomiu, ");
INSERT INTO kwf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma sa Matthew, ma sa Tomas, ma sa James na ngela sa Alfeas, ma sa Simon ta ngwae ana ngwae Jiu ki ba kira oga lalilana ngwae Ꞌi Rom ki faꞋasia Ꞌi Israel, ");
INSERT INTO kwf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma sa Judas na ngela sa James, ma sa Judas Iskariot na ngwae neꞋe nia ke baꞋa Ꞌolosaea sa Jesus fuana malimae nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa Jesus nia koso maꞋi faꞋasia Ꞌi gwauna ua neꞋeri faꞋinia na akwala ma ro lifurongo nia ki, ma ka uu ana kula ote faꞋinia na fikuꞋa doe neꞋeri neꞋe ti ngwae laꞋu ana fafarongo nia ki. Ma ti ngwae Ꞌoro laꞋu neꞋe kira leka maꞋi faꞋasia abaꞋi kula Ꞌi Judea, ma faꞋinia fanoa doe Ꞌi Jerusalem, ma na fanoa ki Ꞌi Taea ma Ꞌi Saedon neꞋe kira tua Ꞌi sulia asi, kira tua logo Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kira leka maꞋi fuana rongolana sa Jesus, ma Ꞌiri sa Jesus ke gurada faꞋasia na mataꞋinga kira ki. Ma na ngwae neꞋe kira toꞋo ana anoꞋi ru taꞋa ki, kira leka logo maꞋi, ma sa Jesus ka gurada. ");
INSERT INTO kwf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na ngwae ki taꞋifau kira iliili Ꞌuana samaꞋa toꞋona sa Jesus, osiꞋana na ngasingasiꞋanga nia leka kwau faꞋasia fuana guralana na ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sa Jesus ka lia kwau fuana fafarongo nia ki ma ka fata Ꞌuri, “SaesaeleꞋanga fuamuꞋa ngwae neꞋe kamu dalaꞋa ki, osiꞋana neꞋe God ka gwaungaꞋi fafi kamu. ");
INSERT INTO kwf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","SaesaeleꞋanga fuamuꞋa ngwae neꞋe kamu fiolo ana kaidaꞋi neꞋe ki, osiꞋana kamu ke baꞋa abusu. SaesaeleꞋanga fuamuꞋa ngwae neꞋe kamu angi ana kaidaꞋi neꞋe ki, osiꞋana kamu ke baꞋa gaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","SaesaeleꞋanga fuamuꞋa kaidaꞋi na ngwae ki kira ke silolongaꞋi kamu, ma kike ifulangaꞋi kamu, ma kira ka fata faꞋali kamu, ma fuꞋusi taꞋa amuꞋa, osiꞋana kamu roꞋosuli nau na Ngela Ngwae. ");
INSERT INTO kwf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kamu ke saesaeleꞋa, ma muke ngwaꞋe sakasaka Ꞌani saeleꞋanga doe kaidaꞋi neꞋe ngwae ki kike sasi ꞋunaꞋeri amuꞋa, osiꞋana na kwaiaraꞋa doe nia maꞋakwali kamu Ꞌi langi. Nau ku saea ru neꞋeri osiꞋana kira ke baꞋa sasia logo ru taꞋa fuamuꞋa neꞋe koꞋo bora kira ki sasia ana profet ki maꞋi Ꞌi naꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bore ma, nia ke taꞋa ka lilisu fuamuꞋa na ngwae neꞋe kamu toꞋo ana toꞋoruꞋa ki ana kaidaꞋi neꞋe, osiꞋana ngwangwaneꞋanga ki kamu toꞋo ani ka sui naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nia ke taꞋa ka lilisu fuamuꞋa na ngwae neꞋe kamu fanga abusu ki ana kaidaꞋi neꞋe, osiꞋana kamu ke baꞋa fiolo. Nia ke taꞋa ka lilisu fuamuꞋa na ngwae neꞋe kamu gaꞋa ki ana kaidaꞋi neꞋe, osiꞋana kamu ke baꞋa oꞋomae, ma muke angi. ");
INSERT INTO kwf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nia taꞋa ka lilisu fuamuꞋa kaidaꞋi neꞋe ngwae ki kira fataleꞋa amuꞋa, osiꞋana na koꞋo bora kira ki, kira sasia logo ru neꞋeri ki fuana na profet ꞋosoꞋoso ki.” ");
INSERT INTO kwf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa Jesus nia faꞋamanata logo ka Ꞌuri, “Nau ku saea fuamuꞋa na ngwae neꞋe kamu rongo sulia fatalaku, muke kwaima ana na malimae kamu ki, ma muke sasi leꞋa fuana ngwae neꞋe kira silolongaꞋi kamu ki. ");
INSERT INTO kwf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma muke foꞋosia God, Ꞌiri nia ke faꞋaleꞋa ngwae neꞋe kira agia kamuꞋa, ma muke foꞋo fuana na ngwae neꞋe kira sasia ru taꞋa ki amuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma diꞋia ta ngwae ka fidalia na satemu, Ꞌoke alaꞋania nia ka fidalia laꞋu ta bali sate. Ma diꞋia ta ngwae ka ngalia na toꞋongi fafo doe Ꞌoe, Ꞌoke alaꞋania nia ke ngalia logo na toꞋongi sae Ꞌoe fuana. ");
INSERT INTO kwf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma Ꞌoke kwatea fuana ta ngwae bore Ꞌana neꞋe nia ke gania ta ru amuꞋa. Ma diꞋia ta ngwae nia ngalia ta ru ana ru Ꞌoe ki, noaꞋa Ꞌoe kosi gania laꞋu fuana olitaꞋilana fuamu. ");
INSERT INTO kwf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta tae neꞋe kamu oga na ngwae matamata ki kira ke sasia fuamuꞋa, kamu ke sasia logo fuada. ");
INSERT INTO kwf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ma diꞋia kamu kwaima goꞋo amuꞋa ana ngwae neꞋe kira kwaima amuꞋa ki, noaꞋa kamu kasi ngalia goꞋo ta kwaiaraꞋanga. OsiꞋana na ngwae taꞋa ki bore, kira kwaima logo ana ngwae neꞋe kira kwaima ada ki. ");
INSERT INTO kwf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma diꞋia kamu sasi leꞋa goꞋo ꞋamuꞋa fuana ngwae neꞋe kira sasi leꞋa fuamuꞋa ki, noaꞋa kamu kasi ngalia goꞋo ta kwaiaraꞋanga. OsiꞋana neꞋe ngwae abula taꞋa ki bore, kira sasi logo ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma diꞋia kamu kwate ru goꞋo ꞋamuꞋa fuana ngwae neꞋe kira saiana kike duꞋua fuamuꞋa, noaꞋa kamu kasi ngalia goꞋo ta kwaiaraꞋanga. OsiꞋana neꞋe ngwae abula taꞋa ki bore, kira sasi logo ꞋunaꞋeri fuana ngwae abula taꞋa ki, fasi Ꞌiri kira ka duꞋua nama fuada. ");
INSERT INTO kwf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bore ma kamu ke kwaima nama ana malimae kamu ki, ma muke sasi leꞋa fuada, ma kamu ke kwate ru ma noaꞋa kamu kasi masia laꞋu na duꞋulana. DiꞋia kamu sasi ꞋunaꞋeri, kamu ke baꞋa ngalia na kwaiaraꞋanga doe, ma na abulalamuꞋa neꞋe ke diꞋia God na maꞋa kamu neꞋe nia ꞋinotoꞋa ka tasa. OsiꞋana God nia sasi leꞋa fuana ngwae taꞋa ki ma ngwae neꞋe noaꞋa kira kasi saeleꞋa faꞋinia tae neꞋe God sasia fuada. ");
INSERT INTO kwf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muke kwaimanatai ana ngwae ki, ka diꞋia logo na MaꞋa kamu neꞋe nia kwaimanatai amuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“NoaꞋa kamu kasi matalangaꞋinia ta ngwae matamata, Ꞌasu Ꞌubani God kata matalangaꞋi kamu logo. Ma noaꞋa kamu kasi saea na kwaꞋikwaꞋinga fuana ti ngwae matamata, ma God noaꞋa kasi kwatea logo na kwaꞋikwaꞋinga fuamuꞋa. Muke rufuanata nama ana ngwae ki, ma God ke rufuanata kamu logo. ");
INSERT INTO kwf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muke kwate nama ru ki fuana ngwae ki, ma God ke kwate ru logo fuamuꞋa. Ma God ke baꞋa kwatea na kwateꞋa neꞋe nia diꞋia ta ngwae ba nia faꞋafungua ta ngwaꞋi ru neꞋe nia nekea, leleka nia ka fungufungu ma ka Ꞌalasaka naꞋa. Ma God ke baꞋa kwate fuamuꞋa, diꞋia logo neꞋe kamu kwatea fuana na ngwae matamata ki.” ");
INSERT INTO kwf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sa Jesus nia fata logo sulia tarifulaꞋa fuada ka Ꞌuri, “Ta ngwae neꞋe maana nia rodo, nia ꞋafitaꞋi ka talaꞋia laꞋu ta ngwae neꞋe maana rodo. DiꞋia nia sasi ꞋunaꞋeri, keroꞋa taꞋifau goꞋo neꞋe kera ke Ꞌasia saena kilu. ");
INSERT INTO kwf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aia, na ngwae neꞋe nia saesaeꞋi ru goꞋo Ꞌana, nia ꞋafitaꞋi ka liufia na ngwae neꞋe faꞋamanata nia. Ma diꞋia na ngwae saesaeꞋi ru nia ngali taꞋifau ru neꞋe ngwae faꞋamanata nia kwate fuana ki, nia diꞋia naꞋa na ngwae faꞋamanata nia. ");
INSERT INTO kwf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ꞋOko toꞋo ana taꞋangaꞋa doe ki, bore ma Ꞌoko balufia naꞋa Ꞌamu ta ngwae neꞋe nia toꞋo ana taꞋangaꞋa tiꞋitiꞋi. ꞋOko diꞋia taꞋi ngwae neꞋe nia lisia na gegeo Ꞌi saena na maana toꞋolana, bore ma nia kasi lisia goꞋo ta buli ano doe neꞋe nia saena maana talana. ");
INSERT INTO kwf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma Ꞌoko fata Ꞌuri fuana na ngwae matamata, ‘ꞋOe kosi sasia ta ru neꞋe nia taꞋa.’ Bore ma Ꞌoe kosi manata Ꞌabera goꞋo ana taꞋangaꞋa doe neꞋe Ꞌoko sasiꞋi ki. ꞋAeꞋo ngwae kwalabasa. ꞋOke faꞋasia basi na taꞋangaꞋa Ꞌoe ki. Sui, Ꞌoko fiꞋi bolo fuana kwaiꞋafiꞋanga kwau ana ta ngwae matamata fuana na taꞋangaꞋa nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sa Jesus ka fata logo Ꞌania taꞋi tarifulaꞋa fuada ka Ꞌuri, “Na Ꞌai neꞋe nia bulao ka leꞋa, nia ꞋafitaꞋi ka fungu Ꞌani fuaꞋi ru taꞋa ki. Ka diꞋia logo, na Ꞌai neꞋe nia bulao ka taꞋa, nia ꞋafitaꞋi ka fungu Ꞌani na fuaꞋi ru leꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kulu saiana Ꞌai ki taꞋifau, osiꞋana fufuaꞋi ru kira ki neꞋe kira fungu Ꞌani. Ma nia ꞋafitaꞋi ta ngwae ka fisua na fufuana Ꞌai leꞋa faꞋasia na kwalongarangaraꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma na ngwae leꞋa nia sasia logo na ru leꞋa ki sulia na manataꞋi ngwae raola nia. Ma na ngwae taꞋa nia sasia logo na ru taꞋa ki sulia na manataꞋi ngwae bulibuli nia. Na ru neꞋe nia tua Ꞌi saena na manatalana ngwae, nia neꞋe ka ruꞋu maꞋi Ꞌi maa Ꞌani fatalana.” ");
INSERT INTO kwf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma sa Jesus ka alaꞋa laꞋu Ꞌuri, “FaꞋuta neꞋe, ana kaidaꞋi kamu alaꞋa faꞋinau, kamu ka saea nau Ꞌani Aofia, bore ma noaꞋa kamu kasi sasi goꞋo sulia na ru neꞋe nau ku saeꞋe fuamuꞋa ki? ");
INSERT INTO kwf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sa tai bore ana neꞋe nia leka maꞋi siaku, ma ka rongo sulia na fatalaku, ma ka sasi sulia, nai faꞋataꞋinia fuamuꞋa na fitoꞋonga nia, ma na tualana. ");
INSERT INTO kwf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nia diꞋia na ngwae neꞋe nia saungaꞋinia luma nia, ma nia ka Ꞌilia na diro Ꞌai ki ka koso lalo. Aia, ma ana kaidaꞋi na uta ka toꞋo, ma na kafo nia afetafa maꞋi, nia ꞋafitaꞋi ka malangisia, osiꞋana nia saungaꞋinia luma nia Ꞌi fafona na diro Ꞌai ki neꞋe nia Ꞌilia ka koso lalo. ");
INSERT INTO kwf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma na ngwae neꞋe nia rongoa na fatalaku, ma noaꞋa kasi sasi sulia, nia diꞋia ngwae neꞋe nia saungaꞋinia luma nia fafona one, noaꞋa nia kasi Ꞌilia diro Ꞌai kasi koso lalo goꞋo. KaidaꞋi kafo nia afetafa maꞋi, ma ka foto ana luma neꞋeri, luma neꞋeri ka Ꞌasia, ma ka takalo taꞋifau naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","KaidaꞋi sa Jesus nia faꞋasuia naꞋa fatalana fuana ngwae ki, nia ka leka naꞋa Ꞌuana fanoa Ꞌi Kapaneam. ");
INSERT INTO kwf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma taꞋi ngwae Ꞌi neꞋeri, nia mataꞋi ka doe ma ka karangi mae naꞋa. Na ngwae neꞋeri, niaꞋa na ngwae rao ana taꞋi gwaungaꞋi ngwae ramo ana fuꞋanga ki faꞋasia na fanoa doe Ꞌi Rom. Ma gwaungaꞋi ngwae ramo neꞋeri, nia lia doe liu ana na ngwae rao nia. ");
INSERT INTO kwf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma kaidaꞋi neꞋe gwaungaꞋi ngwae ramo neꞋeri nia rongoa neꞋe sa Jesus nia dao maꞋi, nia ka kwatea ti ngwae faꞋinaꞋonaꞋo ana Jiu ki, fasi Ꞌiri kira ka saea sa Jesus ke leka maꞋi, Ꞌiri ke gura na ngwae rao nia. ");
INSERT INTO kwf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","KaidaꞋi kira dao siana sa Jesus, kira ka amasia, kira ka Ꞌuri, “Na gwaungaꞋi ngwae ramo neꞋe nia bolo faꞋinia Ꞌoke kwaiꞋafi ana na ngwae rao nia, ");
INSERT INTO kwf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","osiꞋana gwaungaꞋi ngwae ramo neꞋeri nia kwaima liu fuamiꞋa Jiu ki, ma nia ka saungaꞋinia taꞋi luma fuana foꞋongaꞋa fuamiꞋa Ꞌi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ꞋUnaꞋeri sa Jesus ka leka naꞋa faꞋinida. Ma kaidaꞋi nia dao karangia naꞋa kwau na luma, na ngwae gwaungaꞋi neꞋeri Ꞌi Rom ka kwatea laꞋu kwau na ngwae kwaima nia ki, Ꞌiri kira ke fata Ꞌuri fuana, “AraꞋi ꞋaꞋana neꞋe kwa, Ꞌoe kosi Ꞌabera laꞋu. Nau noaꞋa kusi totolia neꞋe Ꞌoke leka maꞋi Ꞌi saena luma nau. ");
INSERT INTO kwf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma nau bore kusi bolo logo fuana lekaꞋa kwau fuamu talaku. ꞋOke fata goꞋo maꞋi Ꞌamu, ma na ngwae ni rao nau ka Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau ku saiana Ꞌoko bolo goꞋo Ꞌamu fuana sasilana ru neꞋeri, duꞋungana nauꞋa talaku na ngwae nau ku rao Ꞌi olofana na ngwae doe ki, ma nau ku toꞋo ana ngwae ni fuꞋa ki neꞋe kira rao Ꞌi olofana na gwaungaꞋinga nau. Ma diꞋia nau ku saea ta ngwae ku Ꞌuri, ‘ꞋOke leka,’ ma nia ka leka. Ma diꞋia nau ku saea ta ngwae ku Ꞌuri, ‘ꞋOke leka maꞋi,’ nia ka leka maꞋi. Ma diꞋia nau ku saea ta ngwae rao ulafu ma nau ku Ꞌuri, ‘ꞋOke sasia nama ru neꞋe,’ nia ka sasia naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ana kaidaꞋi sa Jesus nia rongoa ru neꞋeri, nia ka Ꞌarefo liu. Ma nia ka abula, ma ka fata Ꞌuri fuana na ngwae neꞋe kira leka Ꞌi burina ki, “Nau ku saea fuamuꞋa, nau noaꞋa kusi lisia Ꞌua ta ngwae neꞋe nia faꞋamamana ka Ꞌuri, sui bore Ꞌana saena Ꞌi Israel.” ");
INSERT INTO kwf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma na ngwae ngali alaꞋanga neꞋeri ki, kira ka oli Ꞌuana Ꞌi luma na gwaungaꞋi ngwae ramo baera, ma kira ka lisia na ngwae mataꞋi baera nia Ꞌakwa naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma noaꞋa nia kasi tau goꞋo Ꞌi buri Ꞌana ru neꞋeri ki, sa Jesus faꞋinia na fafarongo nia ki, ma ngwae Ꞌoro ki logo, kira leka Ꞌuana taꞋi fanoa neꞋe kira saea Ꞌani Ꞌi Nen. ");
INSERT INTO kwf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma kaidaꞋi nia dao karangia maana na sakasakaꞋa ana na fanoa neꞋeri, taꞋi fikuꞋa kira ngalia maꞋi taꞋi ngwae mae, ma kira ka leka naꞋa maꞋi Ꞌi maa. Na ngwae mae neꞋeri, niaꞋa na Ꞌalako mutaꞋi taꞋi gwaꞋi Ꞌuru. Ma na fikuꞋa doe kira ka leka maꞋi faꞋinia fuana kwaiatolana. ");
INSERT INTO kwf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma kaidaꞋi sa Jesus, na Aofia, nia lisia na gwaꞋi Ꞌuru neꞋeri, nia ka kwaimanatai liu ana, ma ka fata Ꞌuri fuana, “ꞋOe kosi angi laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sui nia ka leka kwau, ma ka sama toꞋona na tatafe neꞋe ngwae mae neꞋeri nia teo saena, ma na ngwae neꞋe kira ngalia ngwae mae neꞋeri ki, kira ka uu toꞋo. GoꞋo sa Jesus ka fata Ꞌuri, “Ngwae Ꞌalako neꞋe kwa, nau ku saea fuamu, Ꞌoke tataꞋe!” ");
INSERT INTO kwf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma na ngwae Ꞌalako baera ka tataꞋe naꞋa, ma ka talaꞋae ka alaꞋa. Ma sa Jesus ka kwatea naꞋa kwau fuana teꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma na ngwae neꞋe kira lisia ru neꞋeri ki, kira ka Ꞌarefo liu, ma kira ka baꞋatafea God, kika Ꞌuri, “TaꞋi profet ꞋinotoꞋa nia sakatafa naꞋa maꞋi Ꞌi safitakulu. God nia dao naꞋa maꞋi fuana Ꞌafilakulu na ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma na alaꞋanga sulia sa Jesus, ka talo naꞋa Ꞌi saena Ꞌafutana abaꞋi kula Ꞌi Israel, ma na bali ana fanoa ki kalikalia logo. ");
INSERT INTO kwf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana kaidaꞋi neꞋe fafarongo sa John ki kira faꞋarongo nia Ꞌania na raolana sa Jesus, sa John ka saea maꞋi ro fafarongo nia ki siana, ");
INSERT INTO kwf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka baꞋe keroꞋa ka leka kwau siana sa Jesus, na Aofia, Ꞌuana saefilolana kika Ꞌuri, “ꞋUri ma ꞋaeꞋo naꞋa neꞋe na Christ, ngwae neꞋe ke baꞋa dao maꞋi niniꞋa, nama mike masia laꞋu ta ngwae matamata?” ");
INSERT INTO kwf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma ana kaidaꞋi kera dao siana sa Jesus, kera ka saefiloa Ꞌuri ana, “Sa John ngwae ni Siuabu nia baꞋe keroꞋo maꞋi fuana saefilolamu, ꞋUri ma ꞋaeꞋo naꞋa neꞋe na Christ, ngwae neꞋe ke baꞋa dao maꞋi, nama mike masia laꞋu ta ngwae matamata?” ");
INSERT INTO kwf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma ana kaidaꞋi neꞋeri logo, sa Jesus nia gura ngwae mataꞋi Ꞌoro ki, ma nia ka ifulangaꞋinia na anoꞋi ru taꞋa ki faꞋasia na ngwae ki, ma ka gura na ngwae neꞋe maada rodo ki. ");
INSERT INTO kwf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nia neꞋe sa Jesus ka fata Ꞌuri fuadaroꞋo, “Moro oli kwau, moro ka faꞋarongoa sa John Ꞌania ru ki neꞋe koroꞋo lisiꞋi ki, ma moro ka rongoꞋi ki Ꞌi taꞋena. Ngwae maada rodo ki, kira lia naꞋa. Ma ngwae Ꞌaeda mae ki, kira ka fali naꞋa. Ma na ngwae neꞋe kuu nia saungida ki, kira ka mafo naꞋa. Ma ngwae neꞋe alingada bani ki, kira ka rongo naꞋa. Ma ngwae neꞋe kira mae ki, kira ka mauri laꞋu. Aia, ma na FaꞋarongoꞋa LeꞋa, nau ku faꞋatalo naꞋa Ꞌani fuana ngwae dalaꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","God ke ꞋoilakitaꞋinia na ngwae ki taꞋifau neꞋe noaꞋa kira kasi ilangaꞋi nau, osiꞋana na ru nau ku sasiꞋi ki.” ");
INSERT INTO kwf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ꞋI buri Ꞌana na ro fafarongo sa John ki kera oli naꞋa, sa Jesus nia talaꞋae ka alaꞋa sulia sa John fuana ngwae neꞋe kira fiku Ꞌi neꞋeri ki ka Ꞌuri, “Ana kaidaꞋi kamu leka siana sa John saena abaꞋi kula kwasi, ta tae niniꞋa kamu leka fuana lisilana Ꞌi neꞋeri? Ta ngwae neꞋe noaꞋa kasi faꞋamamana ka diꞋia goꞋo Ꞌana ta gwango rade neꞋe nia saola ana iru? NoaꞋa! Sa John nia noaꞋa laꞋu ngwae ꞋunaꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ꞋUri ma, tae neꞋe kamu leka fuana lisilana? Ta ngwae neꞋe nia toro Ꞌania ifi neꞋe folilana doe? NoaꞋa! OsiꞋana ngwae neꞋe kira toro ꞋunaꞋeri ki, kira toꞋoru, ma kira ka tua Ꞌi saena luma leꞋa liu ki. ");
INSERT INTO kwf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kamu ke faꞋarongo nau maꞋi. Tae neꞋe kamu leka kwau fuana lisilana? Na profet? ꞋIu! Nia na profet mamana! Ma nia liufia mala na profet Ꞌi naꞋo ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sa John naꞋa ba kira kerekere sulia saena KerekereꞋa Abu ana kaidaꞋi God nia fata Ꞌuri, ‘Lia basi, nai baꞋa kwatea kwau na ngwae ni ngali alaꞋanga nau Ꞌi naꞋo amu, fasi Ꞌiri nia ke sasi akaꞋu ana ngwae ki fuamu.’” ");
INSERT INTO kwf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sa Jesus ka fata laꞋu Ꞌuri, “Nau ku saea fuamuꞋa, sa John nia talingaꞋi ka liufia na ngwae ki taꞋifau neꞋe kira futa maꞋi Ꞌi saena magalia neꞋe. Sui ka ꞋunaꞋeri bore Ꞌana, na ngwae neꞋe kira faꞋatiꞋitiꞋi ada ki saena na ꞋInotoꞋanga God, kira doe ka tasa ka liu ana sa John.” ");
INSERT INTO kwf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ngwae ki taꞋifau neꞋe kira rongoa fatalana, ma na ngwae goni mani ana takisi ki bore, kaidaꞋi kira rongo sulia fatalana sa Jesus, kira ka saiana taꞋi tala God nia saga ma ka mamana, osiꞋana kira kakari alifaꞋi, ma sa John ka siuabu kira taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma na Farasi ki faꞋinia ngwae faꞋamanata ana taki ki, osiꞋana neꞋe kira Ꞌaila Ꞌania kakari alifaꞋi Ꞌanga ma na siuabuꞋanga ana sa John, kira noaꞋa kasi oga goꞋo na roꞋongaꞋa sulia na kwaiogaiꞋanga God neꞋe nia sasi akaꞋu ana fuada. ");
INSERT INTO kwf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma sa Jesus ka fata laꞋu Ꞌuri fuada, “Nau kui faꞋabolotaꞋinia fuamuꞋa na tua lamuꞋa ngwae ana Ꞌi taꞋena, kamuꞋa diꞋia na kaela ngela ");
INSERT INTO kwf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","neꞋe kira fiku Ꞌi maana usiꞋa Ꞌani ro fikuꞋa ki. Ma kira ka ri kwailiu fuada, ‘Kaimili ufi Ꞌau, ma kamu kasi ngwaꞋe goꞋo sulia. Ma kaimili ka ngulia na faꞋi ngu sulia maeꞋa fuaumulu, ma kamu kasi kwaimanatai goꞋo.’ ");
INSERT INTO kwf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","KaidaꞋi sa John Siuabu nia dao maꞋi, nia abu fanga, ma noaꞋa kasi kwaꞋufia ta waen, ma kamu ka saea fasi nia toꞋo ana anoꞋi ru taꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sui, kaidaꞋi nauꞋa, na Ngela Ngwae, nau ku dao maꞋi, nau ku fanga fiku, ma nau ku kwaꞋu faꞋinia ngwae ki, ma kamu ka fata logo Ꞌuri, ‘Kamu lisia! Nia fanga doe, ma ka kwaꞋu doe ana waen, ma nia ka kwaima faꞋinia ngwae neꞋe kira goni mani ana takisi ki ma ngwae abulalada taꞋa ki logo.’ ");
INSERT INTO kwf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bore ma, ngwae neꞋe kira roꞋosulia na liatoꞋo God ki, kira faꞋataꞋinia neꞋe God nia mamana.” ");
INSERT INTO kwf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","TaꞋi ngwae ana Farasi ki neꞋe satana sa Simon, nia laefia sa Jesus fasi Ꞌiri ke fanga faꞋinia. Ma sa Jesus ka leka Ꞌi luma nia, ma ka tua egoego, ma ka fanga faꞋinia. ");
INSERT INTO kwf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma taꞋi kini neꞋe abulalana taꞋa nia tua logo Ꞌi saena na fanoa neꞋeri. Ana kaidaꞋi neꞋe kini neꞋeri nia saiana sa Jesus nia fanga Ꞌi saena luma na Farasi neꞋeri, nia ka ngalia maꞋi taꞋi biꞋi nura leꞋa neꞋe nia fungu Ꞌania ngwaingwai neꞋe nia moko leꞋa liu. ");
INSERT INTO kwf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma nia ka ruꞋu saena luma, ka uu maꞋi Ꞌi buri Ꞌana sa Jesus talaꞋana Ꞌaena, ma nia ka angi, ma ka faꞋaisila na Ꞌaena sa Jesus Ꞌani na kafo ana maana. Sui, nia ka ongoa Ꞌaena sa Jesus Ꞌani ifuna, ma ka nonoꞋia. Sui nia ka kisitaꞋinia na ngwaingwai moko leꞋa neꞋeri Ꞌi fafona Ꞌaena sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma kaidaꞋi neꞋe Farasi ba nia laefia sa Jesus, nia lisia na ru neꞋeri, nia ka manata Ꞌana Ꞌuri, “DiꞋia na ngwae neꞋe niaꞋa na profet, nia ke saiana abulalana kini neꞋe nia taꞋa liu.” ");
INSERT INTO kwf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma sa Jesus ka saiana na manataꞋanga na Farasi neꞋeri, ma nia ka fata Ꞌuri fuana, “Simon kwa! TaꞋi ru neꞋe nau ku oga nai saea fuamu.” Ma sa Simon ka Ꞌuri, “FaꞋamanata Ꞌae, Ꞌoke saea maꞋi fuaku kwa.” ");
INSERT INTO kwf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sa Jesus ka fata Ꞌuri fuana, “Ro ngwae ki kera ngali langa ana mani faꞋasia taꞋi ngwae neꞋe nia alaꞋania ngwae ki kira ka ngali langa ana mani nia ki. TaꞋi ngwae nia ngali langa ana lima talangaꞋi mani ki, ma taꞋi ngwae ka ngali langa ana lima akwala mani ki. ");
INSERT INTO kwf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma kera taꞋifau goꞋo noaꞋa kera kasi bolo faꞋinia duꞋulana mani neꞋeri ki, ma na ngwae neꞋe nia alaꞋania ngali langaꞋa fuadaroꞋo ka rufuanata na ngali langaꞋa kera ki taꞋifau. ꞋUri ma sa taꞋi adaroꞋo neꞋe nia saeleꞋa ka tasa fuana, ana ro ngwae neꞋe nia kwatea mani neꞋeri ki fuadaroꞋo?” ");
INSERT INTO kwf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma sa Simon nia olisia ka Ꞌuri, “Nau ku fia fasi na ngwae neꞋe nia ngalia mani Ꞌoro.” Ma sa Jesus ka fata Ꞌuri, “ꞋOko olisi saga ana.” ");
INSERT INTO kwf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui sa Jesus ka abula fuana na kini neꞋeri, ma ka fata Ꞌuri fuana sa Simon, “ꞋOke lisia basi na kini neꞋe. KaidaꞋi nau ku ruꞋu maꞋi saena luma Ꞌoe, Ꞌoko Ꞌiri kwatea goꞋo kafo fuaku fuana taufilana Ꞌaeku. Bore ma, nia taufia Ꞌaeku Ꞌani na kafo ana maana, ma ka ongoa Ꞌani na ifuna gwauna. ");
INSERT INTO kwf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma Ꞌoko Ꞌiri kwalo nau goꞋo Ꞌani na nonoꞋilaku. Bore ma kini neꞋe, nia Ꞌita ana kaidaꞋi ba nau ku ruꞋu maꞋi luma, nia ka inaꞋu naꞋa ana nonoꞋilana Ꞌaeku. ");
INSERT INTO kwf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma Ꞌoko Ꞌiri ngwaia goꞋo na gwauku Ꞌani ta ngwaingwai. Ma kini neꞋe, nia kisitaꞋinia na ngwaingwai moko leꞋa neꞋe ana Ꞌaeku. ");
INSERT INTO kwf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nia neꞋe, nau ku saea fuamu, na alafeꞋanga doe nia, nia faꞋataꞋinia neꞋe na roraꞋa Ꞌoro nia ki kira aloge taꞋifau naꞋa. Bore ma, sa tai neꞋe roraꞋa nia neꞋe kira rufuanata ka tiꞋitiꞋi, na alafeꞋanga nia tiꞋitiꞋi logo.” ");
INSERT INTO kwf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui sa Jesus ka fata Ꞌuri fuana na kini neꞋeri, “Nau ku rufuanata naꞋa ana na taꞋangaꞋa Ꞌoe ki.” ");
INSERT INTO kwf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma ti ngwae neꞋe kira tua Ꞌi neꞋeri, kira ka saetaꞋa fuana sa Jesus, ma kira ka fata Ꞌuri Ꞌi safitada kwailiu, “Na ngwae faꞋuta niniꞋa neꞋe ka rufuanata mala na taꞋangaꞋa ki Ꞌuri re?” ");
INSERT INTO kwf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sui sa Jesus ka fata Ꞌuri laꞋu fuana na kini neꞋeri, “ꞋOke leka naꞋa, ma noaꞋa Ꞌoe kosi manata Ꞌabera naꞋa. God nia faꞋamauriꞋo, osiꞋana Ꞌoko faꞋamamana.” ");
INSERT INTO kwf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma Ꞌi buri Ꞌana ru neꞋeri ki, sa Jesus ka leka daraninia naꞋa na fanoa tiꞋitiꞋi ki, ma na fanoa doe ki, ma nia ka faꞋarongo Ꞌani na FaꞋarongoꞋa LeꞋa sulia neꞋe God ke baꞋa gwaungaꞋi fafia ngwae nia ki. Ma na akwala ma ro fafarongo nia ki, kira leka logo faꞋinia, ");
INSERT INTO kwf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma ti kini logo neꞋe sa Jesus ifulangaꞋinia na anoꞋi ru taꞋa ki ma na mataꞋinga ki logo faꞋasida. Ma kiraꞋa neꞋe: Ꞌi Mary, kini Ꞌi Magdala ba sa Jesus nia ifulangaꞋinia na fiu anoꞋi ru taꞋa ki faꞋasia, ");
INSERT INTO kwf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma Ꞌi Joana, na Ꞌafe sa Kusa na ngwae ꞋaꞋana ana ngwae neꞋe kira rao Ꞌi saena na luma sa Herod na tatalafaꞋa ki, ma Ꞌi Susana, ma ti kini Ꞌoro laꞋu. Na kini neꞋeri ki neꞋe kira foli ru Ꞌani mani kira ki fuana Ꞌafilana sa Jesus faꞋinia fafarongo nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na ngwae Ꞌoro ki kira fiku maꞋi siana sa Jesus. Kira leka maꞋi faꞋasia fanoa matamata kwailiu ki taꞋifau. Sa Jesus fata Ꞌani tarifulaꞋa fuada ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“TaꞋi ngwae nia leka ka takaloa maga Ꞌai ki saena oꞋola witi nia. Ma ana kaidaꞋi nia takaloa maga Ꞌai ki, ti maga ru niꞋi ꞋasiꞋi sulia na talalinga. Ma na ngwae ki kira liu, ma kira ka urida, ma na noꞋo ki kira ka ꞋaniꞋi logo. ");
INSERT INTO kwf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aia, ti maga ru ka ꞋasiꞋi fafona ano faula. Ma ana kaidaꞋi kira bulao maꞋi, nia ꞋaliꞋali goꞋo kira ka kuku naꞋa, sulia na ano neꞋeri noaꞋa nia kasi ngwangakwaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma ti maga ru ka Ꞌasi logo Ꞌi safitana na kwalo Ꞌabui ki. Ma na kwalo Ꞌabui ki kira ka bulao maꞋi faꞋinia na maga ru leꞋa ki, ma ka nuku fafia na witi neꞋeri ki. ");
INSERT INTO kwf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma ti maga ru ka ꞋasiꞋi logo Ꞌi fafona ano leꞋa, ma kira ka bulao, ma kira ka fungu Ꞌani fuaꞋi ru Ꞌoro liu ki.” Ma sa Jesus ka faꞋasuia fatalana ka Ꞌuri, “DiꞋia ta ngwae oga ka sai leꞋa ana ru neꞋe ki, nia ka sailinga leꞋa mala.” ");
INSERT INTO kwf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sui na fafarongo sa Jesus ki kira ka saefiloa Ꞌuana na fadalana tarifulaꞋa neꞋeri, ");
INSERT INTO kwf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ma nia ka olisida ka Ꞌuri, “KaidaꞋi sui ki, God noaꞋa kasi faꞋamadakola Ꞌua faꞋuta neꞋe nia ke baꞋa gwaungaꞋi fafia ngwae nia ki. Bore ma taꞋena, na madakolaꞋa niniꞋa dao naꞋa fuamuꞋa. Fuana ta ngwae laꞋu, nau ku fata Ꞌani tarifulaꞋa ki, ma noaꞋa naisi faꞋamadakola, fasi Ꞌiri, ‘Kira ke fafarongo, ma kike fafarongo, bore ma noaꞋa kira kasi saiana faꞋarongoꞋa God. Ma kira ke lia, ma kira ke lia, bore ma noaꞋa kira kasi lisia tae neꞋe God sasia fuada.’” ");
INSERT INTO kwf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ꞋUnaꞋeri, sa Jesus ka fata laꞋu Ꞌuri, “Na fadalana na tarifulaꞋa neꞋeri: Na maga ru, nia diꞋia na fatalana God. ");
INSERT INTO kwf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na maga ru neꞋe kira Ꞌasida sulia na talalinga ki, kira diꞋia ngwae neꞋe kira rongoa fatalana God, ma sa Saetan ka leka maꞋi ka lafua alaꞋanga neꞋeri faꞋasi kira. Nia neꞋe nia kwate noaꞋa kira kasi faꞋamamana fuana maurilada. ");
INSERT INTO kwf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma na maga Ꞌai neꞋe kira ꞋasiꞋi Ꞌi fafona ano neꞋe nia faula, nia diꞋia na ngwae neꞋe kira rongoa fatalana God, ma kira ka ngalia faꞋinia na saeleꞋanga. Bore ma, fatalana God noaꞋa kasi lalisusu goꞋo saena maurilada. Kira ka faꞋamamana goꞋo sulia kaidaꞋi tiꞋitiꞋi. Bore ma kaidaꞋi ilitoꞋonga nia dao goꞋo maꞋi, noaꞋa kira kasi faꞋamamana naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Maga Ꞌai neꞋe kira Ꞌasida Ꞌi safitana na kwalo Ꞌabui ki, nia diꞋia ngwae neꞋe kira rongo, bore ma kira ka manata Ꞌabera Ꞌada sulia ru matamata ki, diꞋia na toꞋoruꞋa ki, ma na saeleꞋanga ꞋoꞋo saena magalia neꞋe nia suꞋusida. Nia neꞋe nia sasia kira ka doe ꞋidiꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na maga ru neꞋe kira Ꞌasida Ꞌi fafona na ano neꞋe nia leꞋa, nia diꞋia ngwae neꞋe kira rongoa fatalana God ma kira ka gonia saena manataꞋi ngwae ꞋoloꞋolo ma ka leꞋa. Ma kira ka suꞋute Ꞌani fitoꞋonga fuana sasilana raoꞋa Ꞌoro leꞋa ki.” ");
INSERT INTO kwf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sa Jesus ka fata laꞋu Ꞌuri, “NoaꞋa ta ngwae kasi faꞋaduꞋa na faꞋi unu, ma ka alua goꞋo Ꞌana Ꞌi olofana ta dako nama ta ꞋifitaꞋi. Bore ma nia ke alua nama Ꞌi fuila, fasi Ꞌiri na ngwae neꞋe nia ruꞋu maꞋi Ꞌi luma nia ke lisia. ");
INSERT INTO kwf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Nia ka ꞋunaꞋeri logo ana na ta ru neꞋe nia tua ago ana kaidaꞋi neꞋe, ta asoa niꞋi ke baꞋa sakatafa taꞋifau maꞋi. Ma ti alaꞋanga neꞋe kira suu fafia, nia ke baꞋa raꞋe tafa taꞋifau maꞋi Ꞌi maa. ");
INSERT INTO kwf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nia neꞋe muke sailinga leꞋa, osiꞋana God ke baꞋa kwate tatakolaꞋa ana liatoꞋo Ꞌanga fuamuꞋa, si diꞋia kamu roꞋosulia na faꞋamanataꞋanga nau ki. Sa tai bore Ꞌana neꞋe nia toꞋo ana ta madakolaꞋanga tiꞋitiꞋi sulia ꞋinotoꞋanga God, God ke baꞋa luda gwauna fuana. Bore ma sa tai neꞋe noaꞋa kasi roꞋosulia faꞋamanataꞋanga neꞋe ki, ta madakolaꞋanga tiꞋitiꞋi bore Ꞌana neꞋe nia fia fasi nia toꞋo ana sulia ꞋinotoꞋanga God, God ke olitaꞋinia faꞋasia.” ");
INSERT INTO kwf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ꞋI buri Ꞌana, teꞋa sa Jesus faꞋinia na ngwaefuta nia ki, kira dao maꞋi, ma kira ka oga lisilana, bore ma nia ꞋafitaꞋi fuada fuana Ꞌidu karangilana, sulia na ngwae Ꞌoro ki kira fiku kalia sa Jesus ana kaidaꞋi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma taꞋi ngwae Ꞌi saena fikuꞋa neꞋeri ka fata Ꞌuri fuana sa Jesus, “TeꞋa Ꞌoe faꞋinia na ngwaefuta Ꞌoe ki, kira uu goꞋo maꞋi Ꞌada Ꞌi maa, ma kira oga lisilamu.” ");
INSERT INTO kwf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sa Jesus ka fata Ꞌuri fuada taꞋifau, “Sa tai faꞋida neꞋe kira rongo, ma kira ka roꞋosulia fatalana God, kira naꞋa neꞋe teꞋa nau ki, ma na ngwaefuta nau ki.” ");
INSERT INTO kwf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","TaꞋi kaidaꞋi, sa Jesus faꞋinia na fafarongo nia ki, kira taꞋe Ꞌi saena taꞋi gwaꞋi baru, ma nia ka fata Ꞌuri fuada, “Kulu toꞋofolo basi Ꞌuana bali Ꞌosi loꞋoba.” Ma kira ka talaꞋae, kira ka toꞋofolo naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma ana kaidaꞋi kira leka naꞋa kwau, sa Jesus ka maliu Ꞌana. Ana kaidaꞋi neꞋeri goꞋo, na iru doe nia taꞋe maꞋi, ma na nafo ki ka magara naꞋa maꞋi saena na baru neꞋeri, ma na baru neꞋeri karangi ka kuru naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fafarongo nia ki kira ka faꞋaada sa Jesus kira ka Ꞌuri, “AraꞋi kwa! Kulu karangi kuru naꞋa!” Sui sa Jesus ka tataꞋe ka balufia na iru ma na nafo neꞋe magara naꞋa, ma kira ka roꞋosulia, ma na Ꞌosi ka fola naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui sa Jesus ka balufia fafarongo nia ki ka Ꞌuri, “FaꞋuta neꞋe kamu kasi faꞋamamana nau?” Ma kira ka Ꞌarefo, ma kira ka maꞋu, ma kira ka saefilo kira kwailiu kika Ꞌuri, “Ngwae faꞋuta naꞋa niniꞋa re? Nia fata totongaꞋi goꞋo, ma na iru faꞋinia nafo doe ki bore, kera ka roꞋo naꞋa sulia.” ");
INSERT INTO kwf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui sa Jesus faꞋinia fafarongo nia ki, kira ka toꞋofolo saena Ꞌosi neꞋe leleka ka dao ana abaꞋi kula Ꞌi Gerasa, ana bali Ꞌosi neꞋe teo kwai toꞋoi faꞋasia abaꞋi kula Ꞌi Galili. ");
INSERT INTO kwf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ana kaidaꞋi sa Jesus nia koso kwau Ꞌi sara faꞋasia gwaꞋi baru, nia ka dao toꞋona taꞋi ngwae faꞋasia kula neꞋeri. Na ngwae neꞋeri, na anoꞋi ru taꞋa ki kira tua faꞋinia, ma nia ka dadara goꞋo Ꞌana sulia kaidaꞋi tau naꞋa maꞋi, ma noaꞋa nia kasi tua logo Ꞌi saena ta luma. Bore ma nia tua goꞋo Ꞌana Ꞌi saena na faoda fuana kwaiatolana ngwae mae ki. ");
INSERT INTO kwf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ana kaidaꞋi Ꞌoro sui naꞋa maꞋi ki, kira firi fafia ro Ꞌae nia ki ma limana logo, ma kira ka alua ngwae fuana foloꞋa Ꞌusia. Bore ma, nia ka muusia goꞋo Ꞌana na sene neꞋeri ki, ma na anoꞋi ru taꞋa neꞋeri ki kira ka lalia naꞋa kwau Ꞌuana saena abaꞋi kula kwasi. Ma kaidaꞋi nia lisia goꞋo sa Jesus, nia ka ako doe, ma ka bobo uruuru naꞋa Ꞌi maana Ꞌaena sa Jesus. Sa Jesus nia fata Ꞌuri fuana, “AnoꞋi ru taꞋa neꞋe, Ꞌoke ruꞋu maꞋi Ꞌi maa faꞋasia na ngwae neꞋe.” Ma ngwae neꞋeri ka ri Ꞌuri, “Jesus kwa, ꞋAeꞋo Ngela God neꞋe ngasingasiꞋa liu! Tae neꞋe Ꞌoko oga Ꞌoke sasi aku? Nau ku ganiꞋo Ꞌoe kosi kwatea ta kwaꞋikwaꞋinga fuaku.” ");
INSERT INTO kwf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa Jesus ka saefiloa, “Satamu sa tai kwa?” Ma nia ka olisia ka Ꞌuri, “Sataku sa Fuani oro.” Nia fata ꞋunaꞋeri sulia na anoꞋi ru taꞋa Ꞌoro liu ki neꞋe kira ruꞋufia. ");
INSERT INTO kwf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na anoꞋi ru taꞋa neꞋeri ki kira ka Ꞌengoa sa Jesus fasi Ꞌiri nia kasi baꞋeda fuana saena kula gwagwa lingalinga fuana kwaꞋikwaꞋinga. ");
INSERT INTO kwf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma na gwata Ꞌoro ki, kira fanga Ꞌada Ꞌi babaraꞋoa ana faꞋi ua neꞋe karangi logo ana kula neꞋeri. Ma na anoꞋi ru taꞋa neꞋeri ki, kira ka gania sa Jesus fasi Ꞌiri kira ke ruꞋufia Ꞌada na gwata neꞋeri ki. Ma sa Jesus ka alaꞋanida. ");
INSERT INTO kwf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kira sakatafa naꞋa maꞋi faꞋasia na ngwae baera, ma kira ka ruꞋufia naꞋa na ngwaꞋi gwata baera ki taꞋifau. Na ngwaꞋi gwata baera ki taꞋifau, kira ka lalili saena kwata Ꞌato neꞋeri Ꞌuana saena Ꞌosi, ma kira ka kwaꞋu, ma kira ka mae taꞋifau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ana kaidaꞋi ngwae neꞋe kira lia sulia ngwaꞋi gwata neꞋeri kira lisia ru neꞋeri, kira ka tafi, ma kira ka faꞋarongo Ꞌani saena fanoa neꞋeri ma na fanoa tiꞋitiꞋi kalikalia ki logo. ");
INSERT INTO kwf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na ngwae ki neꞋe kira rongoa, kira ka leka maꞋi fuana lisilana ru neꞋe nia fuli. Ma ana kaidaꞋi kira dao maꞋi siana sa Jesus, kira ka lisia na ngwae neꞋeri neꞋe anoꞋi ru taꞋa nia leka naꞋa faꞋasia, ma nia ka tua naꞋa Ꞌana Ꞌi maana Ꞌaena sa Jesus, ma nia ka toro naꞋa, ma nia ka manata saga naꞋa. Ma kira taꞋifau kira ka maꞋu. ");
INSERT INTO kwf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma ngwae neꞋe kira lisia kaidaꞋi neꞋe sa Jesus nia ifulangaꞋinia naꞋa anoꞋi ru taꞋa neꞋeri ki faꞋasia na ngwae neꞋeri, kira ka alaꞋa naꞋa sulia fuana ngwae neꞋe fiku maꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui ngwae ki taꞋifau neꞋe kira tua ana abaꞋi kula neꞋeri, kira saea fuana sa Jesus Ꞌiri ke leka faꞋasida, osiꞋana kira maꞋu liu. Sui sa Jesus ka raꞋe naꞋa Ꞌi saena gwaꞋi baru ka salisali fuana lekaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na ngwae ba na anoꞋi ru taꞋa nia leka faꞋasia, nia Ꞌengo ana sa Jesus ka Ꞌuri, “ꞋOke alaꞋani nau Ꞌiri nai leka faꞋiniꞋo.” Bore ma sa Jesus ka baꞋea kwau, ka fata Ꞌuri fuana, ");
INSERT INTO kwf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ꞋOke oli Ꞌamu Ꞌi fanoa Ꞌoe, ma Ꞌoko faꞋarongo Ꞌani ru neꞋe God nia fulia fuamu ki.” Sui, na ngwae neꞋeri ka oli naꞋa Ꞌuana fanoa nia, ma ka alaꞋa naꞋa sulia ru neꞋe sa Jesus nia fulia fuana ki. ");
INSERT INTO kwf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sui, ana kaidaꞋi sa Jesus nia oli laꞋu maꞋi faꞋasia bali Ꞌosi loꞋoba, ngwae ki kira maꞋakwalia, ma kira ka saeleꞋa liu fuana lisilana. ");
INSERT INTO kwf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma taꞋi ngwae neꞋe satana sa Jaeras ka dao maꞋi. Na ngwae neꞋeri nia ta ngwae faꞋinaꞋonaꞋo Ꞌi saena luma fuana foꞋongaꞋa. Nia leka maꞋi ka bobo uruuru Ꞌi Ꞌaena sa Jesus, ma ka Ꞌengoa naꞋa sa Jesus Ꞌiri nia ke leka faꞋinia Ꞌuana luma nia. ");
INSERT INTO kwf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","OsiꞋana taꞋi kala defo mutaꞋi nia neꞋe nia mataꞋi, ma ka karangi mae naꞋa. TaꞋi akwala ma ro faꞋi ngali goꞋo neꞋe nia doe maꞋi sulia. Ma ana kaidaꞋi sa Jesus nia leka faꞋinia, na ngwae Ꞌoro kira fiku kalia logo. ");
INSERT INTO kwf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma taꞋi kini neꞋe gwaꞋi Ꞌabu nia tafangia tua logo Ꞌi neꞋeri. Na mataꞋinga taꞋa neꞋeri nia saungia naꞋa sulia akwala ma ro faꞋi ngali ki. Ma nia ka faꞋalia naꞋa toꞋoruꞋa nia taꞋifau fuana ngwae kwaigura ki, bore ma noaꞋa ta ngwae kasi gura goꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ma na kini neꞋeri ka kwako maꞋi Ꞌi burina sa Jesus, ma ka sama toꞋona Ꞌaena ifi sa Jesus, ma na gwaꞋi Ꞌabu neꞋeri ka langa naꞋa faꞋasia ana kaidaꞋi neꞋeri nama. ");
INSERT INTO kwf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa Jesus ka saefilo ka Ꞌuri, “Sa tai niniꞋa sama toꞋoku?” Ana kaidaꞋi neꞋeri, na fikuꞋa neꞋeri taꞋifau kira ka tofe goꞋo Ꞌada. Ma sa Peter ka fata Ꞌuri, “AraꞋi kwa, ngwaꞋi toꞋa Ꞌoro niniꞋa kira bekesiꞋo naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bore ma sa Jesus ka fata Ꞌuri, “TaꞋi ngwae nia sama toꞋoku, osiꞋana nau ku saiana kaidaꞋi neꞋe na ngasingasiꞋanga nau nia gura ta ngwae.” ");
INSERT INTO kwf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ꞋIu, na kini neꞋeri nia saiana sa Jesus nia sai filoa naꞋa, ma nia ka fali maꞋi, ma ka lebelebe, ma ka maꞋu, ma nia ka bobo uruuru Ꞌi naꞋona Ꞌaena sa Jesus. Ma kaidaꞋi ngwaꞋi toꞋa Ꞌoro neꞋeri kira liafunufunu fuana, nia ka faꞋarongo kira taꞋifau duꞋungana tae neꞋe nia sama toꞋona sa Jesus, ma ka kwatea neꞋe nia ka Ꞌakwa ꞋaliꞋali naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma sa Jesus ka fata Ꞌuri fuana, “Kini neꞋe Ꞌae, God nia gura Ꞌoe naꞋa, osiꞋana neꞋe Ꞌoko faꞋamamana nau. Leka naꞋa kwau amu, ma noaꞋa Ꞌoe kosi manata Ꞌabera naꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","KaidaꞋi sa Jesus nia alaꞋa goꞋo ana Ꞌua, taꞋi ngwae nia dao naꞋa maꞋi faꞋasia luma sa Jaeras, ka faꞋarongoa sa Jaeras ka Ꞌuri, “Na kala defo ba Ꞌoe, nia mae naꞋa. NoaꞋa Ꞌoe kosi faꞋa Ꞌabera laꞋu na ngwae faꞋamanata.” ");
INSERT INTO kwf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma sa Jesus ka rongoa, ma ka fata Ꞌuri fuana sa Jaeras, “NoaꞋa Ꞌoe kosi maꞋu. DiꞋia Ꞌoko faꞋamamana nau, na kala defo Ꞌoe ke leꞋa logo.” ");
INSERT INTO kwf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana kaidaꞋi kira dao kwau Ꞌi luma, sa Jesus ka talaꞋia sa Peter, faꞋinia sa John, ma sa James faꞋinia maꞋa ma teꞋa ngela neꞋeri goꞋo, kira ka ruꞋu Ꞌi luma. Sa Jesus ka luia ta ngwae laꞋu noaꞋa kasi leka faꞋinida Ꞌi luma. ");
INSERT INTO kwf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma na fikuꞋa neꞋeri ki taꞋifau, kira oꞋomae, ma kira ka angisia na ngela neꞋeri. Sui sa Jesus ka fata Ꞌuri, “Kamu kasi angi laꞋu. Na ngela neꞋe noaꞋa nia kasi mae, bore ma nia maliu goꞋo Ꞌana.” ");
INSERT INTO kwf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma kira ka gaꞋasia lala sa Jesus, osiꞋana kira saiana neꞋe ngela neꞋe nia mae mamana naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sui sa Jesus ka dau Ꞌi limana na ngela neꞋeri, ma ka ri ka Ꞌuri, “Ngela neꞋe Ꞌae, tataꞋe naꞋa!” ");
INSERT INTO kwf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma na mangona ka oli laꞋu maꞋi, ma nia ka tataꞋe. Ma sa Jesus ka saea fuada Ꞌiri kira ke kwatea ta fanga fuana. ");
INSERT INTO kwf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na teꞋa nia faꞋinia na maꞋa ngela neꞋeri, kira ka Ꞌarefo liu ana ru neꞋeri. Sui sa Jesus ka luida noaꞋa kira kasi alaꞋa laꞋu sulia ru neꞋeri ki fuana ta ngwae. ");
INSERT INTO kwf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sa Jesus nia saea maꞋi na akwala ma ro fafarongo nia ki siana. Ma nia ka kwatea na ngasingasiꞋanga ma na gwaungaꞋi Ꞌanga fuana guralana mataꞋinga ki, ma na ifulangaꞋilana anoꞋi ru taꞋa ki. ");
INSERT INTO kwf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nia ka asungaꞋinida kwau fuana faꞋafulangaꞋilana na ꞋInotoꞋanga God, ma guralana ngwae mataꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma nia ka fata fuada ka Ꞌuri, “NoaꞋa kamu kasi dau fafia ta ru fuana lekaꞋa kamu. Kamu kasi ngalia ta faꞋi kuba, ma ta ngwaꞋi, ma ta fanga, ma ta mani, ma ta ro toro fuana rokisiꞋanga. ");
INSERT INTO kwf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma ti ngwae ana ta luma neꞋe kira kwalo kamu, muke tua babatoꞋo Ꞌi saena luma neꞋeri, leleka ka dao ana kaidaꞋi neꞋe kamu ke leka ana. ");
INSERT INTO kwf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","DiꞋia ta ngwae ana ta fanoa neꞋe noaꞋa kira kasi kwalo kamu, muke leka ꞋamuꞋa faꞋasida, ma kamu ke tafula fulafulana ano faꞋasia na ꞋaemuꞋa diꞋia na faꞋabasuꞋanga naꞋa fuada neꞋe God ke baꞋa matalangaꞋi kira, duꞋungana kira Ꞌaila Ꞌania rongolana fatalana God.” ");
INSERT INTO kwf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma na fafarongo ki kira ka leka, ma kira ka liu naꞋa ana fanoa ki taꞋifau fuana alaꞋanga sulia FaꞋarongoꞋa LeꞋa sulia God, ma faꞋinia guralana ngwae ki ana kula ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma ana kaidaꞋi neꞋeri logo, sa Herod Antipas na tatalafaꞋa Ꞌi Galili, nia rongoa na alaꞋanga ki sulia ru neꞋe sa Jesus nia sasiꞋi ki. Ma na manatana ka bulia musia kula naꞋa sulia ti ngwae kira saea sa John Siuabu neꞋe nia mauri laꞋu, ");
INSERT INTO kwf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma ti ngwae laꞋu kira ka saea niaꞋa Ꞌani sa Elaeja na profet, ma ti ngwae laꞋu kira ka saea niaꞋa ta profet Ꞌua maꞋi Ꞌi naꞋo neꞋe nia tataꞋe laꞋu faꞋasia na maeꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","GoꞋo ma sa Herod ka fata Ꞌuri, “Sa John ba nau ku kwatea na ngwae ni ofoꞋa ki ka siki muusia naꞋa gwauna! Ma na ngwae faꞋuta niniꞋa kira alaꞋa sulia Ꞌuri?” ꞋUnaꞋeri, ka talaꞋae ana kaidaꞋi neꞋeri, sa Herod oga liua lisilana sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma ana kaidaꞋi neꞋe akwala ma ro lifurongo sa Jesus ki kira oli naꞋa maꞋi faꞋasia faꞋafulangaꞋilana na ꞋInotoꞋanga God ma na guralana ngwae mataꞋi ki, kira ka alaꞋa sulia ru neꞋe kira sasiꞋi ki. Sui, sa Jesus faꞋinia fafarongo nia ki, kira ka leka taꞋifilida Ꞌuana fanoa Ꞌi Betsaeda. ");
INSERT INTO kwf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bore ma ana kaidaꞋi neꞋe, ngwae ki kira rongoa naꞋa sa Jesus nia liu, kira ka leka logo sulia. Ma sa Jesus ka kwaloda, ma ka fata sulia na ꞋInotoꞋanga God fuada, ma ka faꞋamauria naꞋa ngwae neꞋe kira mataꞋi ki. ");
INSERT INTO kwf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma Ꞌi saꞋulafi naꞋa, kaidaꞋi sina karangi suu, na akwala ma ro fafarongo nia ki kira ka leka maꞋi siana, ma kira ka fata Ꞌuri, “ꞋOke olitaꞋinia na fikuꞋa neꞋe, Ꞌiri kira ke leka Ꞌada ana fanoa ki, ma kira ke dao toꞋona ta fanga faꞋinia ta kula fuana teoꞋa, osiꞋana neꞋe kula neꞋe noaꞋa ta ngwae kasi tua goꞋo ana.” ");
INSERT INTO kwf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sui sa Jesus ka fata Ꞌuri fuada, “Kamu ke kwatea lala fanga fuada fuana Ꞌanilana.” Ma kira ka olisia kika Ꞌuri, “Kaimili toꞋo goꞋo ana lima afu beret ki, ma na ro gwaꞋi iꞋa ki. ꞋUri ma Ꞌoko oga kaimili ke leka folia maꞋi fanga fuana fikuꞋa doe neꞋe?” ");
INSERT INTO kwf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na fikuꞋa neꞋe nia bolo faꞋinia na lima toꞋoni ngwae ki neꞋe kira tua Ꞌi neꞋe. Sa Jesus ka fata Ꞌuri fuana na fafarongo nia ki, “Muke saea fuada kira ke tua Ꞌi ano Ꞌani ti gwaꞋi tuaꞋa ana lima akwala ngwaeꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Buri Ꞌana neꞋe fafarongo ki kira sasi ꞋunaꞋeri ka sui, na ngwae ki taꞋifau kira ka tua Ꞌi ano naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui sa Jesus ka ngalia na lima afu beret neꞋeri ki, ma na ro gwaꞋi iꞋa neꞋeri ki, ma nia ka lia ꞋalaꞋa Ꞌuana Ꞌi langi, ma ka baꞋatafea God. Sui nia ka ngiia na afu beret ki, ma na iꞋa ki, ma ka kwatea fuana na fafarongo nia ki, Ꞌiri kira ka daroꞋia ana ngwae ki. ");
INSERT INTO kwf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma kira taꞋifau kira ka fanga, ma kira ka abusu liu. Ma na fafarongo nia ki, kira ka gonia na orengana fanga neꞋe nia ore Ꞌi saena akwala ma ro kokofi ki leleka ka fungu. ");
INSERT INTO kwf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","TaꞋi kaidaꞋi sa Jesus nia foꞋo ana taꞋifilia, ma na fafarongo nia ki kira ka leka maꞋi siana, ma nia ka saefiloda ka Ꞌuri, “Ngwae ki kira saea nau Ꞌania sa tai?” ");
INSERT INTO kwf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma kira olisia kika Ꞌuri, “Ti ngwae kira saea fasi ꞋaeꞋo sa John Siuabu neꞋe nia mauri laꞋu. Ma ti ngwae laꞋu kira saea fasi ꞋaeꞋo sa Elaeja neꞋe nia mauri laꞋu. Ma ti ngwae laꞋu kira saea fasi ꞋaeꞋo ta ngwae ana na profet ba Ꞌi naꞋo ki maꞋi neꞋe nia mauri laꞋu.” ");
INSERT INTO kwf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma sa Jesus ka lidi kira ka Ꞌuri, “Ma kaumulu sae nau mo Ꞌania sa tai?” Sa Peter nia olisia ka Ꞌuri, “ꞋAeꞋo neꞋe na Christ, na ngwae neꞋe God nia filia fuana Ꞌafilana ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sui sa Jesus ka fata totongaꞋi fuada fasi Ꞌiri noaꞋa kira kasi faꞋarongoa laꞋu ta ngwae ana ru neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma nia ka fata logo Ꞌuri, “NauꞋa, na Ngela Ngwae, nai baꞋa nonifii ka doe liu Ꞌani ru Ꞌoro ki. Ma na ngwae faꞋinaꞋonaꞋo ki, ma na fata abu doe ki, ma na ngwae faꞋamanata Ꞌani na taki ki, kira ke ilangaꞋi nau. Ma kira ke saungi nau, sui ana uula asoa, God ke baꞋa taꞋe nau fuana mauriꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma sa Jesus ka fata laꞋu Ꞌuri fuada taꞋifau, “Sa tai bore Ꞌana neꞋe oga ke donga nau, noaꞋa nia kasi manata Ꞌabera sulia ru nia oga ki goꞋo Ꞌana talana. Asoa ki taꞋifau nia ke maꞋudi fuana dongalaku, sui bore Ꞌana kaidaꞋi nia ke nonifii, ma ke mae ana Ꞌai rara folo. ");
INSERT INTO kwf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa tai bore Ꞌana neꞋe Ꞌaila kasi donga nau duꞋungana nia oga ke sasi Ꞌana sulia kwaiogaiꞋanga nia ki talana, nia ke baꞋa talafia na mauriꞋa firi. Bore ma diꞋia sa tai bore Ꞌana neꞋe noaꞋa nia kasi manata Ꞌabera sulia ru nia oga ki goꞋo Ꞌana talana, ma nia maꞋudi ke mae fuaku, nia ka toꞋo ana mauriꞋa firi. ");
INSERT INTO kwf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","DiꞋia neꞋe na ngwae toꞋo ana ru ki taꞋifau saena magalia, kaidaꞋi nia mae, ma nia ke tua tau faꞋasia God, ru neꞋeri kasi fulia goꞋo ta leꞋangaꞋa fuana. ");
INSERT INTO kwf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma diꞋia ta ngwae nia Ꞌeke Ꞌani nau faꞋinia fatalaku, Ꞌirai NauꞋa, na Ngela Ngwae, nai baꞋa Ꞌeke logo Ꞌania, ana kaidaꞋi nai dao maꞋi faꞋinia na ngwasinasinaꞋanga nau, ma na ngwasinasinaꞋanga MaꞋa nau, ma na ngwasinasinaꞋanga Ꞌainsel abu ki laꞋu. ");
INSERT INTO kwf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nau ku saea naꞋa fuamuꞋa, ti ngwae aumulu Ꞌi neꞋe logo, noaꞋa kira kasi mae leleka kira ka lisia God ke gwaungaꞋi fafia ngwae nia ki.” ");
INSERT INTO kwf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bolo faꞋinia kwalu asoa ki Ꞌi buri Ꞌana neꞋe sa Jesus saea ru neꞋeri ki, nia ka talaꞋia sa Peter, ma sa John, ma sa James, ma kira ka raꞋe Ꞌi gwauna taꞋi faꞋi ua fuana foꞋongaꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma kaidaꞋi sa Jesus nia foꞋo ana, na maana ka rokisi ka ngwasinasina, ma na ifi nia ki ka kwao ma ka ngwasinasina liu. ");
INSERT INTO kwf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma ꞋaliꞋali goꞋo ro ngwae ki kera tua logo Ꞌi neꞋeri, ma kera ka alaꞋa faꞋinia sa Jesus. KeraꞋa neꞋe sa Moses ma sa Elaeja. ");
INSERT INTO kwf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma kera ka sakatafa maꞋi Ꞌi saena na ngwasinasinaꞋanga Ꞌi langi, ma kera ka alaꞋa faꞋinia sa Jesus sulia na maelana ma lekalana faꞋasia na magalia Ꞌuana Ꞌi langi neꞋe nia ke faꞋa aliꞋafua Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bore ma sa Peter ma na ro kwaima nia ki, kira ka maliu naꞋa Ꞌada. Sui ana kaidaꞋi kira ada naꞋa, kira ka lisia na ngwasinasinalana sa Jesus ma na ro ngwae neꞋe kera uu faꞋinia ki. ");
INSERT INTO kwf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma ana kaidaꞋi neꞋe ro ngwae neꞋeri ki kera sasi fuana lekaꞋa faꞋasia sa Jesus, sa Peter ka fata Ꞌuri fuana, “AraꞋi kwa, nia leꞋa liu neꞋe kulu ka tua naꞋa akulu Ꞌi neꞋe. Alu kaimili ke saungaꞋinia uulu babala ki, ta ai fuamu, ma ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” (Nia kina logo Ꞌana ru neꞋe nia saea.) ");
INSERT INTO kwf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma kaidaꞋi sa Peter nia alaꞋa goꞋo ana Ꞌua, taꞋi gwaꞋi salo nia dao ma nunufilana ka buta fafida. Ma na uulu fafarongo ki, kira ka maꞋu ana kaidaꞋi neꞋe gwaꞋi salo neꞋeri nia leka maꞋi ka dau fafida. ");
INSERT INTO kwf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma taꞋi lingaꞋi fataꞋa saka maꞋi faꞋasia Ꞌi saena na gwaꞋi salo neꞋeri ma ka Ꞌuri, “NiaꞋa neꞋe na ngela nau. Nau nau ku filia naꞋa. Muke rongo sulia!” ");
INSERT INTO kwf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma kaidaꞋi lingaꞋi fataꞋa neꞋeri nia sui naꞋa, taꞋi sa Jesus naꞋa Ꞌana neꞋe nia tua faꞋinia na uulu fafarongo nia ki Ꞌi neꞋeri. Ma kira ka noto fafia na ru neꞋeri, ma ana kaidaꞋi neꞋeri noaꞋa kira kasi faꞋarongoa naꞋa ta ngwae ana ru neꞋe kira lisia. ");
INSERT INTO kwf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sui faꞋi asoa Ꞌi buri Ꞌana ru neꞋeri ki, sa Jesus faꞋinia uulu fafarongo nia ki, kira ka koso maꞋi faꞋasia gwauna faꞋi ua neꞋe sa Jesus nia rokisi ana, ma na ngwae Ꞌoro ki kira ka saka toꞋona sa Jesus. ");
INSERT INTO kwf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma taꞋi ngwae faꞋasia na fikuꞋa neꞋe nia ri ka fata Ꞌuri, “FaꞋamanata kwa, nau ku gani Ꞌoe, Ꞌoke ifulani kwau anoꞋi ru taꞋa neꞋe faꞋasia na ngela nau, sulia nia neꞋe taꞋi ngela mutaꞋi nau naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na anoꞋi ru taꞋa nia olofia ꞋaliꞋali goꞋo, ma nia ka ako doe, ma ka Ꞌui Ꞌania Ꞌi ano ma ka lebesia, ma na kwakwana ka ngisungisuꞋa. KaidaꞋi nia saungia, nia ka ꞋafitaꞋi liu fuana suiꞋa faꞋasia, ma ka faꞋakaisia liu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau ku gania fafarongo Ꞌoe ki fuana ifulangaꞋilana faꞋasia, ma ka ꞋafitaꞋi liu fuada fuana sasilana.” ");
INSERT INTO kwf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sa Jesus ka fata Ꞌuri, “KamuꞋa manatamuꞋa ngasi liu, ma ngwae taꞋa ki! Kamu noaꞋa kasi faꞋamamana nau Ꞌua! Nau ku noni maruku naꞋa Ꞌani abu fitoꞋonga nini kamu. Nau ku tua faꞋi kamu ka dao naꞋa Ꞌuri, fuila kaumulu ka faꞋamamana nau naꞋa.” Sui nia ka fata Ꞌuri fuana ngwae neꞋeri, “ꞋOke ngalia maꞋi na ngela Ꞌoe Ꞌi neꞋe.” ");
INSERT INTO kwf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ana kaidaꞋi neꞋe ngela neꞋeri nia dao maꞋi ana kula neꞋe sa Jesus nia uu ana, na anoꞋi ru taꞋa neꞋeri nia ka fiꞋi Ꞌui Ꞌania ngela neꞋeri Ꞌi ano, ma ka lebesia. Ma sa Jesus ka balufia na anoꞋi ru taꞋa neꞋeri, ma nia ka fiꞋi saka faꞋasia ngela neꞋeri, ma na tualana ngela neꞋeri fiꞋi leꞋa, ma sa Jesus ka kwatea ngela neꞋeri fuana maꞋa nia. ");
INSERT INTO kwf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma na ngwae neꞋe kira fiku ki, kira ka Ꞌarefo liu ana ngasingasiꞋanga God. Ana kaidaꞋi neꞋe ngwae ki kira Ꞌarefo goꞋo Ꞌada Ꞌua ana ru neꞋe sa Jesus nia fulia ki, nia ka fata Ꞌuri fuana fafarongo nia ki, ");
INSERT INTO kwf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“NoaꞋa kamu kasi manata bura Ꞌani na ru neꞋe nau ku saea fuamuꞋa ki. NauꞋa, na Ngela Ngwae, kira ke kwate nau saena limana malimae nau ki.” ");
INSERT INTO kwf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bore ma fafarongo nia ki kira kasi saiana ta tae neꞋe nia fada Ꞌani alaꞋanga neꞋe nia saea. God nia sofongaꞋinia na fadalana alaꞋanga neꞋe faꞋasida. Ma kira maꞋu logo fuana saefilo lana fadalana alaꞋanga neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma na olisuꞋusuꞋunga ka leka Ꞌi safitana na fafarongo sa Jesus ki, sulia sa tai ada neꞋe ke doe ka gwaungaꞋi fafida taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma sulia neꞋe sa Jesus nia saiana manatalada, nia ka ngalia taꞋi ngela, ma ka faꞋauua Ꞌi safitada, ");
INSERT INTO kwf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ka fata Ꞌuri fuada, “DiꞋia sa tai neꞋe Ꞌoko kwaloa ta ngela Ꞌuri duꞋungana neꞋe Ꞌoko faꞋamamana nau, Ꞌoko kwalo nau laꞋu goꞋo. Ma diꞋia sa tai neꞋe Ꞌoko kwalo nau, Ꞌoko kwaloa logo God neꞋe nia asungaꞋi nau maꞋi. DuꞋungana sa tai neꞋe Ꞌoko faꞋatiꞋitiꞋi Ꞌoe talamu Ꞌi safitamuꞋa, ꞋaeꞋo neꞋe ngwae doe ka gwaungaꞋi fafi kamu taꞋifau.” ");
INSERT INTO kwf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sui sa John ka fata Ꞌuri, “AraꞋi kwa, kaimili lisia taꞋi ngwae nia ifulani na anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga Ꞌoe, ma kaimili ka fonea faꞋasia sasilana, osiꞋana noaꞋa nia kasi Ꞌado faꞋi kulu.” ");
INSERT INTO kwf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sa Jesus ka fata Ꞌuri fuada, “NoaꞋa kamu kasi fonea laꞋu, osiꞋana sa tai neꞋe noaꞋa kasi uu bokota kulu, nia na ngwae faꞋi kulu.” ");
INSERT INTO kwf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","KaidaꞋi nia dao karangi naꞋa fuana sa Jesus ke fane naꞋa Ꞌi langi, nia ka manata doe ana lekaꞋa Ꞌuana Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma nia ka kwatea ngwae ki kira ka etaeta Ꞌi naꞋo ana. Kira leka, ma kira ka dao ana taꞋi fanoa ana na abaꞋi kula Ꞌi Samaria Ꞌiri kira ke sasi akaꞋu ana ru ki taꞋifau maꞋakwalia. ");
INSERT INTO kwf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bore ana na ngwae ki Ꞌi neꞋeri noaꞋa kira kasi oga goꞋo kwalolana, sulia nia na ngwae Jiu lala neꞋe nia leka Ꞌuana Ꞌi Jerusalem. ");
INSERT INTO kwf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma kaidaꞋi na ro ngwae ana fafarongo nia ki sa James ma sa John, kera lisia ru neꞋeri, kera ka fata Ꞌuri fuana, “Aofia kwa, nia faꞋuta? ꞋUri ma Ꞌoko oga keroꞋo ke gani Ꞌuana ta mafula faꞋasia maꞋi Ꞌi langi Ꞌiri ke doꞋofida taꞋifau kwa?” ");
INSERT INTO kwf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sui sa Jesus ka abula ma ka balufidaroꞋo. ");
INSERT INTO kwf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma kira ka leka naꞋa Ꞌada Ꞌuana ta fanoa matamata. ");
INSERT INTO kwf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma ana kaidaꞋi kira leka naꞋa sulia na taꞋi tala, taꞋi ngwae ka fata Ꞌuri fuana sa Jesus, “Nau ku oga nai leka faꞋi Ꞌoe Ꞌi faꞋi bore Ꞌana neꞋe Ꞌoke leka Ꞌuana.” ");
INSERT INTO kwf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sa Jesus ka fata Ꞌuri fuana, “NoaꞋa nia kasi talangwaraꞋu. Na kui kwasi ki kira toꞋo ana na kula kira ki fuana teoꞋa, ma na noꞋo ki logo kira ka toꞋo ana na nuꞋi kira ki. Bore ma nauꞋa, na Ngela Ngwae, nau noaꞋa kusi toꞋo ana ta luma fuana maliuꞋa ana.” ");
INSERT INTO kwf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma sa Jesus ka fata Ꞌuri fuana ta ngwae laꞋu, “ꞋOke leka maꞋi faꞋi nau.” Bore ma na ngwae neꞋeri ka fata lala Ꞌuri, “AraꞋi kwa, Ꞌoke alaꞋani nau Ꞌiri nau kui leka, ku tua basi faꞋinia maꞋa nau, leleka nia ka mae mala, nau ku kwaiatoa ka sui, nau ku fiꞋi dongaꞋo.” ");
INSERT INTO kwf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma sa Jesus ka olisia ma ka Ꞌuri fuana, “AlaꞋania na ngwae neꞋe noaꞋa kira kasi toꞋo ana mauriꞋa ana God ki, kira ka kwaiatoa naꞋa Ꞌada na ngwae mae kira ki. ꞋAeꞋo niniꞋa, Ꞌoke leka, ma Ꞌoko fata sulia na ꞋInotoꞋanga God.” ");
INSERT INTO kwf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma ta ngwae laꞋu ka fata Ꞌuri, “AraꞋi kwa, nau kui leka mo Ꞌi burimu. Bore ma, Ꞌoke alaꞋani nau Ꞌiri nai leka ma ku olioli basi ana ngwae nau ki Ꞌi fanoa.” ");
INSERT INTO kwf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sa Jesus ka fata Ꞌuri fuana, “Ta ngwae neꞋe nia oga ke leka faꞋi nau, ma nia ka manata doe sulia na ru neꞋe nia faꞋasiꞋi ki, noaꞋa nia kasi bolo faꞋinia God ka ꞋinotoꞋa fafia maurilana.” ");
INSERT INTO kwf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ꞋI buri Ꞌana na ru neꞋeri ki, na Aofia sa Jesus ka filia fiu akwala ma ro ngwae ki, ma ka kwatea kira ka leka ro ngwaeꞋa fasi Ꞌiri kira ke leka Ꞌi naꞋona Ꞌuana fanoa ki taꞋifau goꞋo neꞋe nia manata fuana lekaꞋa Ꞌuani. ");
INSERT INTO kwf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma nia ka fata Ꞌuri fuada, “Na ngwae neꞋe kira sasi akaꞋu naꞋa fuana faꞋamamanaꞋanga ana God ki, kira diꞋia na ru Ꞌoro ki Ꞌi saena oꞋola fuana fikulani. Bore ma, ngwae fuana fikulana na ru neꞋeri ki, kira kasi Ꞌoro. Nia neꞋe, muke foꞋosia God Ꞌiri nia ke kwatea maꞋi ngwae ni rao ki faꞋi kamu. ");
INSERT INTO kwf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muke leka naꞋa. Nau ku asungaꞋi kamu diꞋia na kala sipsip ki Ꞌi safitana na kui kwasi ki, sulia ngwae Ꞌoro ki kira oga kike faꞋali kamu. ");
INSERT INTO kwf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","NoaꞋa kamu kasi ngalia ta mani, ma noaꞋa ta ngwaꞋi ni ru fuana alu maniꞋa Ꞌi saena, ma noaꞋa ta taꞋe butu. Ma noaꞋa kamu kasi Ꞌabera Ꞌani alaꞋanga faꞋinia ta ngwae sulia tala. ");
INSERT INTO kwf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma kaidaꞋi kamu ruꞋu ana ta luma, muke fata Ꞌuri, ‘God ke faꞋaleꞋa kamu, ma na aroaroꞋanga nia ka tua faꞋi kamu Ꞌi saena na luma neꞋe.’ ");
INSERT INTO kwf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma diꞋia na ngwae neꞋe nia tua Ꞌi neꞋeri nia kwalo kamu Ꞌania aroaroꞋa, na faꞋaleꞋanga kamu ke tua logo faꞋinia na ngwae neꞋeri. Ma diꞋia ka noaꞋa, na faꞋaleꞋanga neꞋeri ka oli logo maꞋi fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Muke tua Ꞌi saena na luma neꞋeri, ma muke Ꞌania, ma muke kwaꞋufia ta ru neꞋe kira kwatea fuamuꞋa. OsiꞋana na ngwae neꞋe nia rao, nia ke ngalia nama Ꞌana na folifoliꞋa nia. Kamu ke tua toꞋo, ma noaꞋa kamu kasi lae luma kwailiu. ");
INSERT INTO kwf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma kaidaꞋi kamu dao ana ta fanoa, ma kira ka kwalo kamu, muke Ꞌania fanga tae neꞋe kira kwatea fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma muke gura na ngwae mataꞋi ki Ꞌi saena na fanoa neꞋeri, ma muke fata Ꞌuri fuana na ngwae Ꞌi neꞋeri ki, ‘KaidaꞋi God ke gwaungaꞋi fafia ngwae nia ki, nia dao karangi kamu naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma diꞋia kamu dao ana ta fanoa, ma noaꞋa kira kasi kwalo kamu, muke leka sulia na tala Ꞌi saena fanoa neꞋeri, ma kamu fata ka Ꞌuri, ");
INSERT INTO kwf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Na fulafulana ano ana fanoa neꞋe kamu niniꞋa ratai olofana Ꞌaemili, kami tafula naꞋa kwau Ꞌusi kamu. NiniꞋa na faꞋabasuꞋanga naꞋa fuamuꞋa neꞋe God ke baꞋa matalangaꞋi kamu duꞋungana kamu Ꞌaila Ꞌania rongolana fatalana God. Kamu ke manata toꞋona ru neꞋe: ꞋInotoꞋanga God nia dao karangi kamu naꞋa.’ ");
INSERT INTO kwf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nau ku saea fuamuꞋa, na asoa ana kwaꞋikwaꞋinga neꞋe ke dao maꞋi, God ke kwatea na matalangaꞋinga fuana na ngwae ana fanoa taꞋa ba Ꞌi Sodom. Bore ma nia ke baꞋa kwatea na matalangaꞋinga doe ka tasa fuana ngwae ana fanoa neꞋe ka liufia ngwae ana fanoa ba Ꞌi Sodom!” ");
INSERT INTO kwf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sa Jesus nia fata Ꞌuri, “Nia taꞋa lilisu naꞋa fuamuꞋa neꞋe kamu tua Ꞌi Koresin. Ma kamuꞋa neꞋe kamu tua Ꞌi Betsaeda ka ꞋunaꞋeri logo. OsiꞋana kamu Ꞌiri faꞋamamana na faꞋanadaꞋa Ꞌoro ba nau ku sasia fuamuꞋa ki. DiꞋia kira sasi faꞋanadaꞋa neꞋeri ki Ꞌi Taea ma Ꞌi Saedon Ꞌi naꞋo, na ngwae Ꞌi neꞋeri ki kira ka tua Ꞌi ano, ma kira ka ruꞋufia toro biliꞋa ki, ma kira ka rafua nonida ana fuꞋa, fasi Ꞌiri ka faꞋataꞋinia neꞋe kira kakari alifaꞋi taꞋifau naꞋa faꞋasia abula taꞋangaꞋa kira ki. ");
INSERT INTO kwf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aia, ana faꞋi asoa God ke baꞋa matalangaꞋinia ngwae ana magalia neꞋe, na kwaꞋikwaꞋinga kamu ke baꞋa tasa ka liufia na ngwae Ꞌi Taea faꞋinia Saedon ki. ");
INSERT INTO kwf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ꞋIu, kamuꞋa na tuaꞋa Ꞌi Kapaneam, kamu fia God ke baꞋa lafu kamu Ꞌuana Ꞌi langi. Bore ma, nia ke baꞋa Ꞌui Ꞌani kamu Ꞌi saena kilu ana nonifiiꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui sa Jesus ka fata Ꞌuri fuana fafarongo nia ki, “DiꞋia sa tai neꞋe nia rongo suli kamu, nia rongo logo suli nau. Ma diꞋia sa tai neꞋe nia Ꞌaila Ꞌani kamu, nia Ꞌaila logo Ꞌani nau. Ma diꞋia sa tai neꞋe nia Ꞌaila Ꞌani nau, nia Ꞌaila logo Ꞌania God neꞋe nia asungaꞋi nau maꞋi.” ");
INSERT INTO kwf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma na fiu akwala ma ro ngwae baera kira ka leka naꞋa. Ma ana kaidaꞋi kira oli maꞋi, kira ka saeleꞋa liu, ma kira ka fata Ꞌuri, “Aofia kwa, na anoꞋi ru taꞋa ki bore kira roꞋosuli kaimili kaidaꞋi kami ifulangaꞋinida Ꞌani ngasingasiꞋanga Ꞌoe!” ");
INSERT INTO kwf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sa Jesus ka olisida ka Ꞌuri, “Nau ku lisia na ngasingasiꞋanga sa Saetan karasu faꞋasia ma ka Ꞌasi ka inasisi maꞋi ka diꞋia na meamea faꞋasia Ꞌi langi. ");
INSERT INTO kwf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mulu rongo basi! Nau ku kwatea naꞋa na ngasingasiꞋanga fuamuꞋa fasi Ꞌiri muke liu bore ana baꞋeko tolo ki ma na farifari ki, ma noaꞋa kira kasi Ꞌala fifi amuꞋa. Nau ku kwatea naꞋa fuamuꞋa na ngasingasiꞋanga neꞋe doe ka liufia sa Saetan na malimae kia. NoaꞋa ta ru ana sa Saetan kasi faꞋafii kamu naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kamu ka saeleꞋa ꞋamuꞋa duꞋungana na anoꞋi ru taꞋa ki kira roꞋosuli kamu. Bore ma muke saeleꞋa liu mala ꞋamuꞋa duꞋungana God nia keresia naꞋa na satamuꞋa Ꞌi langi.” ");
INSERT INTO kwf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma ana kaidaꞋi neꞋeri, AnoꞋi ru Abu ka faꞋasaeleꞋa sa Jesus, ma nia ka fata Ꞌuri, “MaꞋasi, ꞋaeꞋo neꞋe Ꞌoko gwaungaꞋi fafia ru ki taꞋifau Ꞌi langi ma Ꞌi ano logo. Nau ku baꞋatafe Ꞌoe, duꞋungana neꞋe Ꞌoko faꞋataꞋinia na ru neꞋe ki fuana ngwae neꞋe kira diꞋia ngela tiꞋitiꞋi ki, ma Ꞌoko sofongaꞋinia ru neꞋe ki faꞋasia ngwae neꞋe kira auraꞋeda duꞋungana kira liatoꞋo, ma kira lia saiana ru Ꞌoro ki. ꞋIu MaꞋasi, na ru neꞋeri ki nia ꞋunaꞋeri naꞋa sulia na kwaiogaiꞋanga Ꞌoe Ꞌua naꞋa maꞋi Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui sa Jesus ka fata Ꞌuri, “MaꞋa nau nia kwatea ru ki taꞋifau naꞋa fuaku. Ma taꞋifilia na MaꞋa goꞋo neꞋe nia saiaku na ngela nia. Ma taꞋifilia logo na Ngela talana neꞋe nia saiana MaꞋa nia, ma taꞋifili goꞋo ngwae neꞋe na Ngela nia filida fuana faꞋataꞋilana fuada ki, neꞋe kira saiana na MaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui sa Jesus ka abula fuana fafarongo nia ki taꞋifilida, ka fata Ꞌuri fuada, “ꞋOilakiꞋa fuamuꞋa, osiꞋana kamu lisia na ru ni ꞋarefoꞋa neꞋe ki Ꞌi taꞋena. ");
INSERT INTO kwf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nau ku saea fuamuꞋa, na profet Ꞌoro ki ma na tatalafaꞋa Ꞌoro Ꞌi naꞋo ki, kira oga logo lisilana na ru neꞋe kamu lisia Ꞌi taꞋena ki, bore ma nia ꞋafitaꞋi liu fuada. Ma kira ka oga liua logo rongolana na ru neꞋe kamu rongoa Ꞌi taꞋena ki, bore ma nia ꞋafitaꞋi logo fuada.” ");
INSERT INTO kwf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","TaꞋi ngwae faꞋamanata ana na taki ki, nia leka maꞋi siana sa Jesus. Nia oga ke ilitoꞋona, ma ka fata Ꞌuri, “Ngwae faꞋamanata kwa, ta tae neꞋe nai baꞋa sasia Ꞌiri nai toꞋo ana na mauriꞋa firi?” ");
INSERT INTO kwf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma sa Jesus ka olisia ka Ꞌuri fuana, “Tae neꞋe na KerekereꞋa Abu ki saea? ꞋUri ma Ꞌoko malingaꞋi faꞋuta Ꞌani?” ");
INSERT INTO kwf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma na ngwae neꞋeri nia olisia ka alaꞋa Ꞌuri, “ꞋOke alafe ana God Ꞌoe, Ꞌania manatamu taꞋifau, ma Ꞌani mangomu taꞋifau, ma Ꞌani ngasingasilamu taꞋifau, ma Ꞌani liamu taꞋifau. Ma Ꞌoke alafe fuana toꞋolamu ka diꞋia logo neꞋe Ꞌoko alafe fuamu talamu.” ");
INSERT INTO kwf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma sa Jesus ka fata laꞋu Ꞌuri, “Na olisiꞋanga Ꞌoe nia saga. ꞋOke sasi ꞋunaꞋeri, ma Ꞌoke mauri.” ");
INSERT INTO kwf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bore ma na ngwae faꞋamanata neꞋeri, nia oga ke faꞋataꞋinia neꞋe na tualana saga goꞋo Ꞌana, ma nia ka saefiloa laꞋu sa Jesus ka Ꞌuri, “Sa tai mo neꞋe na toꞋolaku neꞋe nai alafe fuada?” ");
INSERT INTO kwf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma sa Jesus saiana ngwae Jiu ki Ꞌaila Ꞌania ngwae Ꞌi Samaria ma nia ka olisia ka Ꞌuri, “TaꞋi ngwae Jiu nia tuatua maꞋi Ꞌi Jerusalem ma ka leka Ꞌuana Ꞌi Jeriko. Ma kaidaꞋi nia leka goꞋo Ꞌana sulia na tala, na ngwae fofolo bili ki kira ka saungia, ma kira ka ngalia na ru nia ki taꞋifau faꞋinia na toro nia ki. Ma kira ka kwaiꞋia leleka nia ka maefelo naꞋa, ma kira ka faidanga Ꞌania, ma kira ka leka naꞋa Ꞌada faꞋasia. ");
INSERT INTO kwf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma ana kaidaꞋi neꞋeri, taꞋi fata abu ana na Luma Abu God nia leka logo sulia na tala neꞋeri, ma kaidaꞋi nia lisia na ngwae baera, nia ka rafi logo Ꞌana sulia ta bali tala, ma ka leka Ꞌana. ");
INSERT INTO kwf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sui, taꞋi ngwae rao kwaiꞋafi saena na Luma Abu God nia ka leka logo maꞋi sulia na tala neꞋeri. Ma kaidaꞋi nia dao Ꞌi neꞋeri, nia ka lisia na ngwae baera. Bore ma nia rafi logo Ꞌana faꞋasia ana ta bali tala, ma ka leka logo Ꞌana faꞋasia naꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sui taꞋi ngwae faꞋasia na abaꞋi kula kwaita Ꞌi Samaria nia leka logo maꞋi sulia na tala neꞋeri. KaidaꞋi nia lisia na ngwae baera, nia ka kwaimanatai liu fuana. ");
INSERT INTO kwf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma nia ka leka maꞋi siana, ma ka taufia na maala nia ki Ꞌani na ngwaingwai ma na waen, ma ka Ꞌafua. Sui nia ka lafua Ꞌi fafona na dongki nia, ma ka ngalia naꞋa Ꞌuana taꞋi luma fuana folilana fuana tuaꞋa Ꞌi saena, ma nia ka lia sulia Ꞌi neꞋeri. ");
INSERT INTO kwf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma ana ruana faꞋi asoa, nia ka lafua ro ngisingisi mani ki neꞋe bolo faꞋinia folifoliꞋa fuana ro asoa ki, ma ka kwatea fuana na ngwae neꞋe nia lia sulia na luma neꞋeri, ma ka fata Ꞌuri fuana, ‘ꞋOke lia sulia na ngwae neꞋe, ma ana kaidaꞋi neꞋe nai oli laꞋu maꞋi, nai duꞋua taꞋifau na mani neꞋe Ꞌoko Ꞌafia Ꞌania ki.’” ");
INSERT INTO kwf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sui sa Jesus ka fata Ꞌuri fuana, “ꞋOko manata faꞋuta? Sa tai ana uulu ngwae neꞋeri ki kira saea Ꞌani toꞋolana fuana na ngwae ba na ngwae fofolo bili ki kira kwaiꞋia?” ");
INSERT INTO kwf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma na ngwae faꞋamanata ana taki ki ka fata Ꞌuri, “Na ngwae neꞋe nia kwaimanatai fuana.” Ma sa Jesus ka olisia ka Ꞌuri, “ꞋOke leka, ma Ꞌoko sasi logo ꞋunaꞋeri.” ");
INSERT INTO kwf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","KaidaꞋi sa Jesus ma na fafarongo nia ki kira leka, kira ka dao ana taꞋi fanoa, ma taꞋi kini neꞋe satana Ꞌi Mata ka kwaloa sa Jesus Ꞌuana Ꞌi luma nia. ");
INSERT INTO kwf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma na kini futa nia Ꞌi Mary ka tua karangia na Ꞌaena na Aofia sa Jesus, ma ka fafarongo Ꞌana fuana na faꞋamanataꞋanga sa Jesus ki. ");
INSERT INTO kwf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma na manatalana Ꞌi Mata ka Ꞌabera sulia nia goꞋo neꞋe nia sasia na raoꞋa ki taꞋifau Ꞌi luma. Ma nia ka leka maꞋi siana sa Jesus, ka fata Ꞌuri fuana, “Aofia kwa, ꞋUri ma, Ꞌoko Ꞌiri manata Ꞌabera goꞋo sulia na sasiku neꞋe nia faꞋasi nau goꞋo Ꞌana, ma nau ku sasia goꞋo Ꞌaku na raoꞋa neꞋe ki taꞋifau taꞋifili nau kwa? ꞋOke saea fuana Ꞌiri nia ke leka maꞋi ke kwaiꞋafi logo aku!” ");
INSERT INTO kwf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma na Aofia olisia ka Ꞌuri, “Mata kwa, Ꞌoko matafiru ma na manatalamu ka Ꞌabera naꞋa sulia ru Ꞌoro ki. ");
INSERT INTO kwf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bore ma taꞋi ru goꞋo neꞋe nia talingaꞋi. ꞋI Mary nia filia na ru talingaꞋi, ma nia ꞋafitaꞋi ta ngwae ka lafua naꞋa faꞋasia.” ");
INSERT INTO kwf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ana taꞋi asoa, sa Jesus nia foꞋo Ꞌana, ana taꞋi kula. Ma kaidaꞋi nia foꞋo ka sui goꞋo, taꞋi ngwae ana fafarongo nia ki ka fata Ꞌuri fuana, “Aofia kwa, Ꞌoke faꞋamanata kami Ꞌani foꞋongaꞋa, diꞋia ba sa John nia faꞋamanata logo na fafarongo nia ki Ꞌani foꞋongaꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sa Jesus ka fata Ꞌuri fuada, “KaidaꞋi kamu foꞋo, kamu ke fata Ꞌuri, ‘MaꞋasi, Kami oga ngwae ki taꞋifau kike faꞋadoea na satamu, osiꞋana nia abu liu. Dao maꞋi Ꞌani gwaungaꞋi Ꞌanga Ꞌoe fafia maurilana ngwae ki taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma Ꞌoke kwatea maꞋi fuamiꞋa na fanga neꞋe nia bolo fuamiꞋa sulia asoa ki. ");
INSERT INTO kwf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma Ꞌoke rufuanata na taꞋangaꞋa kami ki, diꞋia logo neꞋe kami rufuanata ana taꞋangaꞋa ngwae ki taꞋifau neꞋe kira sasia ru taꞋa ki fuamiꞋa. Ma Ꞌoe kosi danga Ꞌani kami fuana ilitoꞋonga ka liufi kami.’” ");
INSERT INTO kwf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma sa Jesus ka fata Ꞌani taꞋi tarifulaꞋa Ꞌuri fuana na fafarongo nia ki, “DiꞋia ta ngwae ana kaumulu leka siana na ngwae kwaima nia Ꞌi luma nia saena tofongana rodo, ma ka fata Ꞌuri fuana, ‘Ngwade kwa, Ꞌoe kwatea basi maꞋi ta uulu afu beret fuaku, ");
INSERT INTO kwf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","osiꞋana taꞋi ngwae kwaima nau logo, nia tua tua maꞋi ana fanoa tau, ma nia ka dao maꞋi siaku. Bore ma noaꞋa nau kusi toꞋo ana ta fanga neꞋe nai kwatea fuana.’ ");
INSERT INTO kwf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma na ngwae kwaima neꞋeri nia saena luma ka fata Ꞌuri, ‘NoaꞋa Ꞌoe kosi faꞋa Ꞌabera nau laꞋu! Na sinamaa nia fono naꞋa, ma na ngela nau ki kaimili ka maliu taꞋifau naꞋa. Nia ꞋafitaꞋi nau ku tataꞋe laꞋu fuana kwatelana ta ru fuamu.’ ");
INSERT INTO kwf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aia, nau ku saea fuaumulu, bore Ꞌana diꞋia noaꞋa nia kasi oga sasilana ta ru, diꞋia na ngwae neꞋeri nia gani, ma ka inaꞋu ana ganiꞋa, na ngwae neꞋe Ꞌi saena luma, nia ke tataꞋe ma ka kwatea goꞋo na ru ki taꞋifau neꞋe nia ogaꞋi. Ma nia noaꞋa kasi sasia laꞋu duꞋungana na ngwae neꞋeri neꞋe na ngwae kwaima nia, bore ma osiꞋana sulia neꞋe nia inaꞋu naꞋa ana ganiꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nia neꞋe nau ku saea fuaumulu. Kamu ke gani ana God Ꞌiri muke ngalia ru neꞋe kamu gani Ꞌuana. Kamu ke lulua ru kamu boꞋoboꞋo Ꞌuani ki ana God, ma nia ka Ꞌafi kamu Ꞌiri muke lisia. Kamu ke faꞋafo ana sinamaa, ma God ke Ꞌifi fuamuꞋa. ");
INSERT INTO kwf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","OsiꞋana na ngwae ki taꞋifau neꞋe kira gani ana God, kira ka ngalia naꞋa ru neꞋe kira gania. Ma na ngwae ki taꞋifau neꞋe kira lulua ru kira boꞋoboꞋo Ꞌuani ki ana God, kira ka lisia. Ma na ngwae ki taꞋifau neꞋe kira faꞋafo ana sinamaa, ma God ke Ꞌifi fuada. ");
INSERT INTO kwf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ꞋUri ma, sa tai aumulu na maꞋa ki, neꞋe diꞋia na ngela Ꞌoe nia gania iꞋa, Ꞌoke kwatea lala na faꞋi loi fuana? ");
INSERT INTO kwf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma diꞋia na ngela Ꞌoe nia gani Ꞌuana ta fakaleꞋe karai, Ꞌoke kwatea lala ta farifari fuana? NoaꞋa liu! ");
INSERT INTO kwf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sui bore Ꞌana kamuꞋa taꞋifau ngwae taꞋa ki, kaumulu saiana kwatelana na ru leꞋa ki fuana ngela kaumulu ki. Bore ma na MaꞋa kamu neꞋe nia Ꞌi langi, nia leꞋa ka tasa liufi kamu. ꞋUnaꞋeri neꞋe nia ka kwatea na AnoꞋi ru Abu fuana ngwae ki neꞋe kira gani nia Ꞌuana!” ");
INSERT INTO kwf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana taꞋi kaidaꞋi, sa Jesus nia ifulani taꞋi anoꞋi ru taꞋa faꞋasia taꞋi ngwae neꞋe kwakwana nia Ꞌato Ꞌani fataꞋa. Ma kaidaꞋi anoꞋi ru taꞋa neꞋe nia tafi faꞋasia, nia ka fata laꞋu. Ma na ngwaꞋi toꞋa Ꞌoro neꞋe kira fiku Ꞌi neꞋeri, kira ka Ꞌarefo. ");
INSERT INTO kwf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma ti ngwae ada kira ka fata Ꞌuri, “Sa Jesus ifulani naꞋa anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga sa Saetan, na ꞋingataꞋi anoꞋi ru taꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma ti ngwae ada, kira oga kike ilitoꞋona sa Jesus. Ma kira ka gania fasi Ꞌiri nia ke fulia ta faꞋanadaꞋa, fasi Ꞌiri ke faꞋataꞋinia neꞋe nia toꞋo ana na ngasingasiꞋanga faꞋasia God. ");
INSERT INTO kwf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma osiꞋana neꞋe sa Jesus nia sai goꞋo ana na manatalada, nia ka fata Ꞌuri fuada, “DiꞋia ngwaꞋi toꞋa saena ta fanoa doe kira fuꞋali kira talada, Ꞌirai na fanoa doe neꞋeri ke takalo naꞋa. Ma diꞋia neꞋe ngwae, ma na Ꞌafe, ma na ngela nia ki, kira fuꞋa faꞋi kira talada, nia ꞋafitaꞋi fuana kira ka tua fiku. ");
INSERT INTO kwf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma na ꞋinotoꞋanga sa Saetan neꞋe ꞋunaꞋeri logo. DiꞋia sa Saetan ke fuꞋa faꞋinia toꞋa neꞋe kira leka sulia, Ꞌirai kira ke takalo kwailiu goꞋo. Nau ku saea ru neꞋeri ki, duꞋungana kamu saea nau ku ifulani anoꞋi ru taꞋa ki Ꞌania ngasingasiꞋanga sa Saetan. ");
INSERT INTO kwf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aia, ma kaumulu saea nau ku ifulani anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga sa Saetan. ꞋIrai ma ngasingasiꞋanga sa tai mo niniꞋa ti fafarongo aumulu ifulani anoꞋi ru taꞋa ki Ꞌani? Sa Saetan? NoaꞋa liu! DuꞋungana ru neꞋeri ki, nia faꞋataꞋinia neꞋe kaumulu rora. ");
INSERT INTO kwf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nau ku ifulani anoꞋi ru taꞋa ki Ꞌani ngasingasiꞋanga God. Ma nia ka faꞋataꞋinia naꞋa fuamuꞋa neꞋe na gwaungaꞋinga God fafia ngwae ki dao karangi naꞋa maꞋi siamuꞋa.” ");
INSERT INTO kwf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sa Jesus ka fata laꞋu sulia taꞋi tarifulaꞋa ka Ꞌuri, “DiꞋia ta ngwae ramo nia sasi akaꞋu ana raꞋunga nia ki fuana fuꞋanga, ma ka folo leꞋa Ꞌusia luma nia, nia ꞋafitaꞋi ta ngwae ka bilia na ru nia ki Ꞌi saena luma nia. ");
INSERT INTO kwf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma diꞋia ta ngwae neꞋe nia ngasingasiꞋa ka tasa mala ana niaꞋa, nia leka maꞋi, ma ka fuꞋa faꞋinia, ma ka liufia nia, na ngwae neꞋeri ka ngali taꞋifau naꞋa Ꞌana na ru ni fuꞋanga nia ki neꞋe nia fitoꞋo Ꞌani, ma ka daroꞋia taꞋifau naꞋa ru nia ki taꞋifau fuana ngwae kwaima nia ki. ");
INSERT INTO kwf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ma sa tai neꞋe noaꞋa nia kasi leka maꞋi buriku, nia na malimae nau. Ma sa tai neꞋe noaꞋa kasi kwaiꞋafi aku fuana fikulana maꞋi ngwae ki siana God, nia takalongaꞋi kira naꞋa faꞋasia God.” ");
INSERT INTO kwf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sa Jesus ka fata laꞋu Ꞌuri, “KaidaꞋi kira ifulaꞋinia anoꞋi ru taꞋa nia leka faꞋasia ta ngwae, nia ka liliu saena kula kwasilaꞋa, ma ka lulu Ꞌuana ta kula fasi Ꞌiri nia ke tua laꞋu ana. Ma diꞋia nia lulu ma ka noaꞋa naꞋa, nia ke manata Ꞌuri, ‘Nai oli Ꞌuana na ngwae ba nau ku tuatua maꞋi ana Ꞌi naꞋo, ma nau ku leka maꞋi faꞋasia.’ ");
INSERT INTO kwf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ana kaidaꞋi nia oli maꞋi ka dao, nia ka lisia ngwae baera nia faꞋasikasika ma ka faꞋasaga naꞋa maurilana taꞋifau. ");
INSERT INTO kwf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","KaidaꞋi nia lisia neꞋe nia ꞋunaꞋeri, nia ka oli, ma ka talaꞋia laꞋu maꞋi ta fiu anoꞋi ru neꞋe taꞋa ka tasa liufia niaꞋa, kira ka leka maꞋi, ma kira ka tua naꞋa Ꞌi saena ngwae baera. Ana kaidaꞋi neꞋeri, na tualana ngwae neꞋeri ka fiꞋi taꞋa ka liufia naꞋa Ꞌi naꞋo.” ");
INSERT INTO kwf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","KaidaꞋi sa Jesus nia saea ru neꞋeri ki fuada taꞋifau, taꞋi Ꞌafe Ꞌi saena fikuꞋa neꞋeri ka ako Ꞌuri, “Na kini neꞋe nia faꞋafutaꞋo ma ka faꞋasusufiꞋo mo neꞋe nia saeleꞋa ka tasa.” ");
INSERT INTO kwf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bore ma sa Jesus nia olisia ka fata Ꞌuri, “Mamana liu. Bore ma ngwae neꞋe kira rongoa fatalana God, ma kira ka roꞋo sulia, kira lala neꞋe kira saesaeleꞋa ka tasa.” ");
INSERT INTO kwf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma kaidaꞋi neꞋe ngwaꞋi toꞋa Ꞌoro kira fiku kalikalia maꞋi sa Jesus, nia ka fata Ꞌuri fuada, “Kamu na unitaꞋi ngwae neꞋe, kamu na unitaꞋi ngwae taꞋa. DuꞋungana kamu oga lisilana ta faꞋanadaꞋa neꞋe ke faꞋataꞋinia ngasingasiꞋanga God, bore ma nia ka ꞋafitaꞋi fuamuꞋa fuana lisilana. Kamu ke baꞋa lisia goꞋo ꞋamuꞋa na faꞋanadaꞋa diꞋia na ru ba nia fuli fuana sa Jona na profet. ");
INSERT INTO kwf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na ru neꞋe fuli fuana sa Jona, nia diꞋia ta maꞋetoto neꞋe faꞋataꞋinia fuana ngwaꞋi toꞋa Ꞌi Ninifa ki neꞋe nia leka maꞋi faꞋasia God. Na ru neꞋe fuli fuaku nia diꞋia ta maꞋetoto neꞋe faꞋataꞋinia logo neꞋe God kwate nau maꞋi, na Ngela Ngwae, fuana ngwae ki ana kaidaꞋi neꞋe. ");
INSERT INTO kwf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma ana asoa neꞋe God ke matalangaꞋinia ngwae ki, na Ꞌafe ba nia gwaungaꞋi ana fanoa Ꞌi Siba, nia ke baꞋa tataꞋe, ma ka faꞋataꞋinia na taꞋangaꞋa kamu ki ngwaꞋi toꞋa ana unitaꞋi ngwae neꞋe ki, osiꞋana neꞋe abulaꞋanga kamu ki nia rora liu naꞋa. Nia leka tau maꞋi faꞋasia Ꞌisilana fanoa neꞋe Ꞌi ano fuana rongolana liatoꞋonga sa Solomon. Bore ma, nauꞋa, taꞋi ngwae neꞋe nau ku talingaꞋi ka tasa liufia sa Solomon, nau ku tua Ꞌi neꞋe Ꞌi taꞋena, ma kamu kasi rongo goꞋo suli nau. ");
INSERT INTO kwf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka diꞋia logo ana asoa God ke baꞋa matalangaꞋinia ngwae ki, na ngwae Ꞌi Ninifa ki kira ke baꞋa faꞋataꞋinia na taꞋangaꞋ