﻿USE sofia;
DROP TABLE IF EXISTS sofia.kwd_vpl;
CREATE TABLE kwd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kwd_vpl WRITE;
INSERT INTO kwd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Idu futalanga suria la Jisas Kraes. Ngaia 'e futa mai ala Defete nga kiingi orioritana fufutanga ala Ebraham. ");
INSERT INTO kwd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","La Ebraham 'e lafia la Aesak, la Aesak 'e lafia la Jekob, ma la Jekob 'e lafia la Juda fe'enia ni wane ni futanga aana. ");
INSERT INTO kwd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma la Juda 'e lafia la Peres fe'enia la Sera. (Ga'ia gaa'a latana ni Tama.) Ma la Peres 'e lafia la Hesron, la Hesron ne'e lafia la Ram. ");
INSERT INTO kwd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","La Ram 'e lafia la Aminadab, la Aminadab 'e lafia la Nason, la Nason 'e lafia la Salmon. ");
INSERT INTO kwd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","La Salmon 'e lafia la Boas, ma tete'e aana latana ni Rahab. La Boas 'e lafia la Obed, ma tete'e aana latana ni Rut. La Obed 'e lafia la Jesi. ");
INSERT INTO kwd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","La Jesi ne'e lafia la Defete nga kiingi 'i Israel. La Defete 'e lafia la Solomon, ma tete'e aana na'a me'e nao ala Iuraea. ");
INSERT INTO kwd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","La Solomon 'e lafia la Rihoboam, la Rihoboam 'e lafia la Abaeja, la Abaeja 'e lafia la Asa. ");
INSERT INTO kwd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","La Asa 'e lafia la Jehosafat, la Jehosafat 'e lafia la Joram, la Joram 'e lafia la Iusaea. ");
INSERT INTO kwd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","La Iusaea 'e lafia la Jotam, la Jotam 'e lafia la Ehas, la Ehas 'e lafia la Hesikaea. ");
INSERT INTO kwd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","La Hesikaea 'e lafia la Manase, la Manase 'e lafia la Emos, la Emos 'e lafia la Josaea. ");
INSERT INTO kwd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","La Josaea 'e lafia la Jekonaea fe'enia gila asina. Gila futa 'e sui mola ma marimae aaga 'i Jiu bi'i ngaria ta'a 'i Israel fana fanua ba'ita 'i Babilon. ");
INSERT INTO kwd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","'I buri na nga marimae aaga gila ngaria ta'a 'i Israel fani Babilon, la Jekonaea bi'i lafia la Sialtiel. Ma la Sialtiel 'e lafia la Serababel. ");
INSERT INTO kwd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","La Serababel 'e lafia la Abiud, la Abiud 'e lafia la Elaeakim, la Elaeakim 'e lafia la Aso. ");
INSERT INTO kwd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","La Aso 'e lafia la Sadok, la Sadok 'e lafia la Akim, la Akim 'e lafia la Eliud. ");
INSERT INTO kwd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","La Eliud 'e lafia la Elaesa, la Elaesa 'e lafia la Matan, la Matan 'e lafia la Jekob. ");
INSERT INTO kwd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","La Jekob 'e lafia la Josef kwaiina ni Meri tete'e ala Jisas na'a gila fa'alataa la'u mola 'ania nga Kraes, tofuna ngaia na nga wane God ngaia 'e firia fana 'ani alafa. ");
INSERT INTO kwd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma tala'ae mai ala Ebraham leleka maka nigi ala Defete nga kiingi, akwala ma fai fufuta'e wane. Sui maka eta mai ala Defete nga kiingi leleka mai maka nigi na alata laka'u marimae gila ngaria ta'a 'i Israel fani Babilon, akwala ma fai fufuta'e wane. Ma 'e eta na alata ta'a 'i Israel gila leka fani Babilon leleka mai maka nigi na alata ala Jisas nga Kraes ngaia 'e futa, nga akwala ma fai fufuta'e wane ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nga futalana mai la Jisas nga Kraes ngaia 'e 'ilo'oo: Alata gila arufafi ani Meri nga tete'e ala Jisas fala Josef, ma gala 'ame lado 'ua, ni Meri 'e su'asuria ngaia 'e guru'a no'o suria nga Anoe 'ola Abu. ");
INSERT INTO kwd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma la Josef, nga wane na'a gila aru fafi ai fana, ngaia nga wane 'e odo. Alata ngaia bi'i su'aai na'a ni Meri 'e guru'a, ngaia 'e ma'asiri 'ani fa'anoniriaa ni Meri 'i maana ta'a lo'oo. Ngaia lo'oo, ngaia 'e manata fana 'ani rugate'eni nagwa nagwa aana. ");
INSERT INTO kwd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tafe'ua alata ngaia 'e mamanata 'ua suria ni 'ola lo'oo, nga enselo na God 'e faata'i fana 'i 'ubulana malebolenga maka 'ilo'oo, “Josef, 'i'oo wane na fufutanga ala Defete, 'i'oo sia ma'u fana feelana ni Meri fana nga noni amu. Tofuna ngaia 'e guru'a no'o suria nga Anoe 'ola Abu. ");
INSERT INTO kwd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma ngaia te'e fa'afutaa te'e wela wane, ma 'i'oo to'o fa'alataa 'ania la Jisas, suria ngaia te'e fa'amooria nga ta'a aana fa'asia nga rianga aaga.” ");
INSERT INTO kwd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma ni 'ola lo'oo 'e lau fana 'ani fa'ato'oa nga 'ola laka'u God ngaia 'e kwairii mai 'ania, na alata laka'u profet ngaia 'e fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Te'e wela geni lari'i te'e guru'a maka fa'afuta te'e wela wane, ma tagila fa'alataa 'ania Emanuel. Ma fa'awatagalana lata'e 'ola lo'oori, ‘God ngaia 'e nana'i fe'eni 'adauru.” ");
INSERT INTO kwd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma alata la Josef 'e tata'e, ngaia 'e agea no'o suria ni 'ola lo'oo na'a enselo na God 'e iiria fana. Ma ngaia ka feea no'o ni Meri. ");
INSERT INTO kwd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tafe'ua gaa'a gala 'ame lado 'ua leleka maka nigi na alata ni Meri ngaia 'e fa'afuta nga wela wane lo'oo. Ma la Josef ka fa'alataa no'o 'ania la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na alata la Herod 'e kiingi, la Jisas ngaia 'e futa 'i Betlehem, nga fanua 'i 'ubulana nga gule'e lefu 'i Judea. Ma 'ame aburu mola 'i burina, tani wane fa'asia tata'elana sina na'a gila su'asuria nga buruburu no'ona, gila nigi mai 'i 'ubulana nga fanua ba'ita 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma gila ka daiorisia ta'a no'ona ma gila ka 'ilo'oo, “Nga wela laka'u te'e Kiingi fana Jiu, ngaia 'e futa 'i fai? Meeru su'aai ngaia 'e futa, tofuna alata meru nana'i 'ua mai 'i tata'elana sina, ma meeru agasia no'o nga buruburu ne'e faate'enia futalana, ma 'imeeru meru leka mai fana 'ameru bobouruuru ana, ma meru ka fa'aba'ita.” ");
INSERT INTO kwd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma nga mangona la Herod nga kiingi ngaia 'e manata 'abelo ba'ita alata ngaia 'e longo suria nga 'ola lo'oori, ma nga ta'a 'i Jerusalem la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma ngaia 'e soea nga fataabu ba'ita, ma nga ta'a ni kwaifa'ananaunga na tagi, fana 'agila ogu mai, ma ngaia ka daiorisi 'ilo'oo aga, “'Ino'ona ma 'i fai na'a nga Kraes laka'u te'e futa mai ai?” ");
INSERT INTO kwd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma gila du'aa ma gila ka fata 'ilo'oo, “Betlehem laka'u, nga fanua 'ubulana gule'e lefu 'i Judea. Tofuna nga girigiringa na profet laka'u 'e fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, nga fanua 'ubulana gule'e lefu 'i Judea, 'i'oo 'ame sisika 'i laloana fanua ba'ita 'i Judea, tofuna te'e wane ba'ita te'e leka mai fa'asi'o, fana 'ani talaia nga ta'a agu 'i Israel.’” ");
INSERT INTO kwd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma la Herod 'e soe nagwa nagwa mai na nga ta'a na'a gila nigi mai fa'asia tata'elana sina fana alafuunga fe'eniga, ma ngaia ka orisia nga alata 'uta'i na gila agasia nga fe'e buruburu laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma ngaia ka alega fani Betlehem, maka fata 'ilo'oo, “Moru leka, moru kwailo le'ale'a fana nga wela no'ona. Ma alata mooru daria, tamoru kwairii te'agu, fana nau 'akui leka la'u fana fa'aba'italana.” ");
INSERT INTO kwd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma 'i burina la Herod ngaia 'e fata 'ilo'oo 'e sui, ma gila ka leka no'o. Ma alata gila leka no'o kau suria nga tala, gila ka agasia la'u mola fe'e buruburu laka'u gila agasia mai tata'elana sina. Gila aile'a ba'ita na alata gila agasia la'u. Ma fe'e buruburu no'ona 'e leka 'i na'oga leleka maka mamalo no'o fofona lefu laka'u la Jisas ngaia 'e eeno ai. ");
INSERT INTO kwd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gila ru'u 'i 'ifi, ma gila agasia nga wela bibiu fe'enia tete'e ana ni Meri. Gila bobouruuru ma gila ka fa'aba'ita nga wela bibiu lo'oori, ma gila ka 'ulasia nga wa'i aga, ma gila ka kwatea nga kwakwatenga forilani 'e ba'ita fana: goulo, ma nga 'ola na'a si'inilana 'e le'a, ma nga waiwai si'ini le'a. ");
INSERT INTO kwd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui ma gila ka ori no'o suria nga tala matari fana fanua aaga, tofuna God ngaia 'e fa'abasuga 'ubulana malebolenga, maka iiria gila sia ori la'u te'ana la Herod. ");
INSERT INTO kwd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma 'i burina ni wane lo'oori gila ori mola fana fanua aaga, nga enselo na God 'e faata'i fala Josef 'i 'ubulana nga malebolenga, maka fata 'ilo'oo, “Josef, 'oi tata'e, moko ngaria nga wela lo'oo fe'enia tete'e aana, ma moru 'akwa no'o fani Ijip, ma moru nana'i no'ona leleka maka nigi na alata nau 'akui iiria fana 'amoru ori la'u mai. Tofuna la Herod te'e kwailo 'ofia nga wela lo'oo fana 'ani kwa'ia.” ");
INSERT INTO kwd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma la Josef 'e tata'e, maka ngaria nga wela lo'oo fe'enia tete'e aana ni Meri, ma gila ka leka no'o 'ubulana logo no'ona fana fanua 'i Ijip. ");
INSERT INTO kwd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma gila nana'i no'ona leleka mala Herod ka mae. Ma nga 'ola lo'oori 'e fa'ato'o no'o 'olataa laka'u God 'e iiria fana nga profet laka'u 'e giria maka 'ilo'oo, “Nau ku soea mai nga wela agu fa'asia 'i Ijip.” ");
INSERT INTO kwd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma alata la Herod nga kiingi 'e su'asuria ni wane lo'oori gila leka mai fa'asia tata'elana sina gila kotofia, ngaia 'e baoria ba'ita. Ma ngaia ka kwatea fatalana fana ta'a ni fununga aana fana 'agila kwa'ia nga ru'uru'ua wane sisita 'i Betlehem ma ni fanua te'efou na gila nana'i 'afuia. Ngaia 'e fadaa fana 'agila kwa'ia ru'uru'ua wane sisita te'efou na gila 'ame nigi 'ua na rua farisi, 'ilaka'u nga alafuunga na ni wane laka'u, suria alata laka'u fe'e buruburu ngaia 'e faata'i ai eteeta. ");
INSERT INTO kwd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nga ta'a na'a gila nana'i 'ubulana fanua 'i Betlehem, gila ka aani fana ru'uru'ua aaga ne'e mae. Gila aani, 'ilaka'u la Jeremaea nga profet ngaia 'e iiria no'o mai na'o, ");
INSERT INTO kwd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gila longoa kwala'e aaninga lo'oori 'e leka mai fa'asia nga fanua 'i Rama nga kwala'e nagunga 'e ba'ita. Ni Rasel 'e nagufia ru'uru'ua sisika aana. Alata ngaia 'e aani, te'efuta wane 'ame to'omia 'ani gwa'oa no'o, suria ni wela aana gila mae te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma 'i burina la Herod 'e mae mola, nga enselo na God 'e faata'i la'u 'i 'ubulana malebolenga fala Josef 'i Ijip, ");
INSERT INTO kwd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","maka fata 'ilo'oo, “Josef, tata'e, moko ngaria no'o wela lo'oo fe'enia tete'e aana ni Meri, ma moru ka ori no'o fani Israel, tofuna ta'a laka'u gila irito'ona fana kwa'ilana nga wela lo'oo, gila mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma la Josef 'e tata'e, maka ngaria no'o wela fe'enia tete'e aana ni Meri, ma gila ka ori no'o fani Israel. ");
INSERT INTO kwd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tafe'ua alata la Josef ngaia 'e longoa la Akilas ngaia 'e kiingi lamadu'aa mama'a aana la Herod 'i Judea, ngaia 'e ma'u fana to'orunga 'i no'ona. Ma nga enselo ka iiria la'u fana 'ubulana nga malebolenga, fana 'ani leka fana nga gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngai lo'oo gila nana'i na fanua 'i Nasaret 'i 'ubulana gule'e lefu 'i Galili. Ngaia 'e fa'ato'oa no'o 'olataa laka'u ni profet gila iiria, “Tagila fa'alata 'ania nga wane fa'asia 'i Nasaret.” ");
INSERT INTO kwd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma tani farisi ngaa'i burina, alata la Jisas ngaia 'e ba'ita no'o, la Jon wane ni naruabunga 'e nigi mai, maka etaa no'o nga kwaifa'ananaunga 'ubulana nga gule'e lefu kwasi 'i Judea, maka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Moru bulota'i 'aferu fa'asia nga rianga amooru, suria alata na God te'e ba'ita fafia nga ta'a aana 'e galangi nigi no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","La Jon nga wane laka'u nga profet Aesea ngaia 'e fata mai suria, maka 'ilo'oo, “Te'e wane 'e o'omae 'i 'ubulana nga gule'e lefu langalanga. Ma ngaia 'e 'ilo'oo, ‘Nga Alafa ngaia te'e nigi mai! Moru sasaria nga tala fana nga Alafa! Moru fa'aodoa nga tala fana.’” ");
INSERT INTO kwd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","La Jon 'e ru'ufia nga ruu na ifuna kamel, maka fo'asia nga wa'ewa'etana 'ania susungana buruka. Ma nga fangalaa aana na nga nabo ma nga ngingidua. ");
INSERT INTO kwd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma nga ta'a 'e aula gila leka mai te'ana fa'asia nga fanua laka'u 'i Jerusalem, ma nga fanua te'efou 'i 'ubulana gule'e lefu 'i Judea, ma fa'asia nga fanua te'efou galangia nga ka'o 'i Jodan. ");
INSERT INTO kwd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma gila ka foulange'enia rianga aaga, ma ngaia ka naruabu aga 'i 'ubulana ka'o 'i Jodan. ");
INSERT INTO kwd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma alata la Jon 'e agasia nga ta'a 'e aula na Farasii ma nga Sadusi gila leka la'u mola mai te'ana fana ngaia 'ani naruabu aaga, ngaia ka fata 'ilo'oo faga, “Mooru 'ilaka'u no'o nga waa! Nau ku 'ame iiria famooru na nga naruabunga te'e fa'amoori 'amooru fa'asia nga kwa'ikwa'inga na God, lauta moru 'ame bulota'i mai 'aferu. ");
INSERT INTO kwd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Moru agea no'o ni 'ola lo'oo 'ani faate'enia moru bulota'i mai 'aferu no'o fa'asia nga rianga amooru. ");
INSERT INTO kwd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma moru sia manata 'ilo'oo mola 'i 'ubulana manata lamooru, ‘Meeru nga ta'a na meru futa no'o mai na fufutanga ala Ebraham. 'Ato no'o fana te'efuta kwa'ikwa'inga fa'asia God 'ani nigi la'u ameeru.’ Ma nau ku kwairii kwala'imori famooru, ngaia 'e talawada'u mola fana God 'ani ngaria ni me'e fou na fou lo'oo, maka launge'enia 'ania fufutanga ala Ebraham! ");
INSERT INTO kwd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nga alata lo'oo, God 'e sasari agau no'o na kwa'ikwa'inga, 'ilaka'u nga wane na ngaia 'e dau na naifi, maka sasari no'o fana tofulana 'ai. Ma nga 'ai te'efou ne'e 'ame fungu 'ania ta lode 'ai 'e le'a, ngaia te'e tofuga maka to'osiga no'o 'i 'ubulana eele.” ");
INSERT INTO kwd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nau ku naruabu 'amooru 'ania ka'o fana 'ani faate'enia na'a moru bulota'i mai no'o fa'asia nga rianga 'amooru. Tafe'ua te'e wane na'a te'e leka mai burigu, ngaia te'e naruabu 'amooru 'ania nga Anoe 'ola Abu ma nga eele. Ma ngaia 'e taringa'i 'e riufi nau, ma 'inau ku 'ame to'omia 'aku ngaria nga me'e butu ana. ");
INSERT INTO kwd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma ngaia 'e sasari agau no'o fana sufalana ta'a lo'oo te'efou, 'ilaka'u nga wane laka'u ngaia 'e 'efoa nga 'u'ui 'ola 'e le'a fa'asia nga 'e'efona. Ma ngaia 'e ogua nga 'u'ui 'ola le'a lo'oo 'i 'ubulana 'ifi fana goni 'olanga. Ma ngaia ka do'ofia nga 'e'efona lo'oo 'i 'ubulana nga eele ne'e nunula ma 'e sia mae la'u. ");
INSERT INTO kwd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nga alata no'ona, la Jisas 'e leka mai fa'asia gule'e lefu 'i Galili fana ka'o 'i Jodan te'ana la Jon fana la Jon 'ani naruabu ana. ");
INSERT INTO kwd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tafe'ua la Jon 'e irito'ona fana nga bulosilana mangona la Jisas, maka 'ilo'oo, “Ngaia 'e to'omia 'i'oo no'o to'o naruabu agu, ma 'i'oo leka mai te'agu fana nau 'akui naruabu amu.” ");
INSERT INTO kwd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma la Jisas 'e lamadu'aa maka fata 'ilo'oo, “Gwa'a 'ani 'ilo'oo, 'oi agea no'o mai fagu, tofuna agelana nga 'ola lo'oo, daa'a golo agea no'o nga 'ola na'a God ngaia 'e siria.” Ma la Jon ka ala no'o fafia. ");
INSERT INTO kwd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma nga alata la Jisas 'e naruabu 'e sui mola, ngaia 'e tata'e mai fa'asia ka'o. Ma 'i langi ka 'ulasi fana, ma ngaia ka agasia nga Anoe 'ola Abu na God 'e sifo mai 'ilaka'u nga bola, maka to'oru 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma te'e kwala 'e 'ola ngaia 'e talo mai fa'asia 'i langi maka 'ilo'oo, “Ngaia no'o na wela agu na nau ku kwaimaa ba'ita fana, mai nau ku aile'a ba'ita fe'enia.” ");
INSERT INTO kwd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma 'i burina nga 'ola lo'oo, nga Anoe 'ola Abu 'e talaia la Jisas fana gule'e lefu kwasi fana Saetan 'ani irito'ona. ");
INSERT INTO kwd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma la Jisas ka abu keto suria fai akwale'e gagani, ma fai akwale'e logo, ma ngaia ka molo'u no'o. ");
INSERT INTO kwd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sike'ena, la Saetan 'e leka mai te'ana, maka fata 'ilo'oo, “Tofuna 'i'oo nga Wela na God, 'oi alafuu fana ni me'e fou lo'oo 'ani bu'ota'i fana beret.” ");
INSERT INTO kwd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Nga Girigiringa Abu 'e iiria, ‘Nga wane 'ame momoori 'ania fangalaa 'i talana. Tafe'ua, ngaia 'e momoori 'ania alafuunga te'efou ne'e leka mai fa'asia God.’” ");
INSERT INTO kwd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui mala Saetan ka talaia la'u la Jisas fana nga fanua abu 'i Jerusalem, ma ngaia 'e fa'aulaa na lefu ne'e lau 'i langi, fofona nga 'Ifi Abu na God. ");
INSERT INTO kwd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ka fata 'ilo'oo fana, “Tofuna 'i'oo nga Wela na God, 'oi olo kau 'i wado fa'asia lefu lo'oo, suria nga Girigiringa Abu laka'u 'e fata 'ilo'oo, ‘La God te'e kwatea mai nga enselo aana te'amu, ma tagila aga suri'o, ma gwa'a nga 'a'aemu 'e sia to'o mola na te'efuta me'e fou.’” ");
INSERT INTO kwd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Ma nga Girigiringa Abu laka'u 'e fata la'u mola 'ilo'oo, ‘'I'oo sia irito'ona mola Alafa na ngaia God amu.’” ");
INSERT INTO kwd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui mala Saetan ka talaia la'u la Jisas fana gouna busu ne'e lau langi 'e iiki no'ona, maka faate'enia nga 'inato'onga te'efou na fanua lo'oo 'i wado ma nga kwangakwanga'a ngaa'i fala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma la Saetan ka fata 'ilo'oo, “Ni 'ola lo'oo te'efou nau taku kwatea famu, lauta 'i'oo bobouruuru 'i maana 'a'aegu, moko fa'aba'ita nau.” ");
INSERT INTO kwd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Saetan, 'oi leka lalau kau fa'asi nau! Suria nga Girigiringa Abu 'e iiria, ‘Te'e God amu no'o na 'i'oo to'o fo'osia, ma 'i'oo to'o taunga'i fana.’” ");
INSERT INTO kwd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Alata no'ona, la Saetan 'e leka fa'asia la Jisas. Ma nga enselo gila leka mai, ma gila ka kwaibooni no'o ana. ");
INSERT INTO kwd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Alata la Jisas 'e longoa na gila arua no'o la Jon 'ubulana nga 'ifi na lokafu, ngaia 'e ori fana gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sui ma ngaia ka leka no'o fa'asia fanua aana 'i Nasaret. Ngaia 'e leka, maka nana'i no'o 'i Kapaneam, nga fanua 'i gegena nga asi 'i Galili, nga gule'e lefu na fufu'ita'a ala Sebulun mala Naftali. ");
INSERT INTO kwd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngaia 'e agea 'ilo'oo fana 'ani fa'ato'oa nga fatalana profet Aesea laka'u 'e 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nga gule'e lefu 'i Sebulun ma 'i Naftali, gila nana'i 'ubulana gule'e lefu 'i Galili, ma gila nana'i suria tala fana asi ba'ita, maka nana'i gegeni ka'o 'i Jodan, lefu na ta'a gila 'ame Jiu gila nana'i ai. ");
INSERT INTO kwd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nga ta'a lo'oori, gila nana'i 'ubulana nga ma'elogo, tagila agasia lalanga ba'ita. Ma ni dai na gila nana'i 'ubulana fanua logologo'a na maenga lo'oo, lalanga te'e lala 'afuiga ma te'e kwaibooni aga.” ");
INSERT INTO kwd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","'Ita na alata no'ona, la Jisas 'e eta fana 'ani kwaifa'ananaua maka 'ilo'oo, “Moru bulota'i mai fa'asia nga rianga 'amooru, suria alata God 'ani ba'ita fafia ta'a aana ngaia 'e galangia mooru no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na alata la Jisas 'e leka suria nga asi 'i Galili, ngaia 'e agasia la Saemon (na'a ngaia 'e fa'alataa la'u mola 'ania la Pita) fe'enia la Andru nga wanefuta fe'enia. Gaa'a rua wane ni deenga. Gala dee 'ania fulai agaa'a 'ubulana asi 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma la Jisas ka fata 'ilo'oo fagaa'a, “Molo leka mai fe'eni nau, moo'o rua wane ni deenga, mai nau taku fa'ananau 'amoo'o fana deelana ta'a mai te'agu.” ");
INSERT INTO kwd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma alata no'ona mola, gala 'akwasia nga fulai agaa'a, ma gala ka leka no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui ma la Jisas 'e leka la'u kau, maka agasia la'u nga rua wane ngaa'i la'u, la Jemes ma la Jon nga rua wela ala Sebedi. Gaa'a gala nana'i 'i 'ubulana nga baru fe'enia mama'a agaa'a la Sebedi, ma gala laumea nga fulai 'agaa'a. La Jisas 'e soe 'agaa'a. ");
INSERT INTO kwd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma nga alata no'ona mola, gala ka 'akwasia no'o nga baru fe'enia la ma'a agaa'a, ma gala ka leka no'o fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","La Jisas 'e riufia ni fanua lo'oo 'i 'ubulana gule'e lefu 'i Galili, maka fa'ananaua nga ta'a no'ona 'ubulana ni 'ifi ni fo'anga na Jiu. Ma ngaia ka kwairii 'ania nga Kwairiinga Le'a lo'oo suria nga ba'itangaa na God, maka gulaa nga ta'a na'a gila fii 'ania fiifinga kwaitatari. ");
INSERT INTO kwd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma nga alafuunga suria la Jisas 'e talofia fanua no'ona te'efou 'i 'ubulana gule'e lefu 'i Siria. Ma ta'a 'e aula na'a gila fii 'ania fifiinga kwaitatari, gila ka ngariga mai te'ana. Nga ta'a na noniga 'e fii, ma ta'a na adalo 'e bo'ega, ma nga ta'a na'a nga langasi 'e kwa'ikwa'iga, ma ta'a na'a 'a'aega 'e mae, gila leka mai te'ana. Ma la Jisas ka gulaga te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma nga ta'a 'e auaula la'u mola, gila ka leka suria la Jisas na alata no'ona. Ta'a gila leka fa'asia gule'e lefu 'i Galili, ma fanua 'i Jerusalem, ma tani fanua ngaa'i la'u 'ubulana gule'e lefu 'i Judea, ma nga gule'e lefu 'i Dekapolis, ma fa'asia nga gula na tata'elana sina na ka'o 'i Jodan. ");
INSERT INTO kwd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ma nga alata lo'oo la Jisas ngaia 'e agasia nga oguogunga ba'ita lo'oo, ngaia 'e fane na busu, maka to'oru 'i wado. Ma nga fufu'iwane aana gila ka ogu 'afuia, ");
INSERT INTO kwd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ngaia ka tala'ae no'o fana fa'ananaulaga, maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aile'anga fana ta'a na'a gila su'aai gila galafa'a 'i maana God, tofuna God 'e ba'ita fafiga. ");
INSERT INTO kwd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aile'anga fana ta'a na gila kwaimanadai, tofuna God te'e gwa'oga. ");
INSERT INTO kwd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aile'anga fana ta'a na gila malasika'a aaga 'i talaga, tofuna God te'e kwatea nga fanua lo'oo 'i wado faga. ");
INSERT INTO kwd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aile'anga fana ta'a na gila siria 'e iiki fana agelana ni 'ola 'e odo, tofuna God te'e fa'atoria manatalaga. ");
INSERT INTO kwd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aile'anga fana ta'a na gila laeta'afiia ta'a matari, tofuna God te'e laeta'afiiga la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aile'anga fana ta'a na mangoga 'e kwari 'i maana God, tofuna gila tagila agasia God. ");
INSERT INTO kwd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aile'anga fana ta'a na gila taunga'i fana nga aloalonga 'i laloana ta'a, tofuna God te'e fa'alataga 'ania nga ru'uru'ua aana. ");
INSERT INTO kwd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aile'anga fana ta'a na gila malate'ote'o aga du'ana gila agea ni 'ola 'e odo, tofuna God te'e ba'ita fafiga. ");
INSERT INTO kwd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Aile'anga famooru alata nga ta'a gila fata ngadaa amooru, ma gila malate'ote'o amooru, ma gila iiria ni 'ola 'e ria 'e aula amooru ne'e 'ame to'o tofuna mooru no'o na nga fufu'iwane agu. ");
INSERT INTO kwd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nau ku iiria 'ola lo'oori tofuna ni 'ola 'e ria lo'oo na gila agea famooru, gila agea la'u mola na profet mai na'o. Moru aile'a, tofuna God te'e kwatea foforinga ba'ita famooru 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","La Jisas 'e fata la'u 'ilo'oo, “Nga solti ngaia 'e fa'ale'aa nga fangalaa amooru. Mai 'amooru la'u mola moru 'ilaka'u nga solti fana nga ta'a te'efou. Lauta na asilai ngaia 'e 'amoe no'o, ngaia 'e 'ato 'e iiki 'ani asila la'u. Ma ngaia 'ame le'a no'o fana agelai la'u 'ania te'efuta 'ola, ngaia 'e le'a mola fana 'amoru 'ui no'o 'ania 'i maa, fana nga ta'a 'agila talaufia mola. ");
INSERT INTO kwd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mooru moru 'ilaka'u la'u mola nga uunu fana nga ta'a te'efou fofona fanua lo'oo 'i wado. Nga fanua na ngaia 'e nana'i 'i gouna nga busu ngaia 'e 'ato 'ani nagwa. ");
INSERT INTO kwd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma te'efuta wane 'e sia lalaua mola nga uunu, sui maka arua mola 'i olofana nga daoko. Alata ngaia 'e lalaua uunu 'e sui, ngaia te'e ngaria, maka arua na lefu 'i langi, fana 'ani lala fana nga ta'a te'efou 'i 'ubulana nga 'ifi no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ka 'ilo'oo la'u mola, alamia nga uunu amooru 'ani lala 'i na'ona ta'a te'efou, fana 'agila agasia ni 'ola le'a na moru agea, ma gila ka baatafea Mama'a amooru ne'e nana'i mai Langi.” ");
INSERT INTO kwd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mooru sia madafia iiria nau ku leka mai fana nga to'osilana nga Tagi ala Moses ma nga kwaifa'ananaunga na profet. Nau ku 'ame leka mai fana nga to'osilai, tafe'ua mai nau ku leka mai fana nga fa'ato'olana nga kwaifa'ananaunga aaga. ");
INSERT INTO kwd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nau ku iiria nga 'ola kwala'imori famooru, nga alata na lalo ma nga fanua lo'oo 'i wado gila nana'i 'ua, te'efuta 'ola sisika na nga Tagi 'e sia nagwa mola leleka maka nigi na alata na ni 'ola te'efou na nga tagi 'ani lau 'ilaka'u God 'e fadaa mai. ");
INSERT INTO kwd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ngaia lo'oo, ni dai ne'e 'ame lo'o suria te'efuta me'e tagi sisika, maka fa'ananaua nga ta'a fana ma'asiringa na te'efuta 'ola sisika na tagi lo'oo, God te'e arua 'e 'ita'i na nga foufounga aana. Tafe'ua ni dai ne'e lo'o suria nga tagi maka fa'ananaua nga ta'a fana lo'onga suria, God te'e arua 'ani ba'ita 'i 'ubulana nga foufounga aana. ");
INSERT INTO kwd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nau ku iiria famooru, lauta moru 'ame abulo le'a riufia nga ta'a ni kwaifa'ananaunga na Tagi, ma ni Farasii fana lekanga suria 'ola na God ngaia 'e siria, ngaia 'e 'ato 'e iiki fana 'amoru nana'i fe'enia ta'a na God 'e ba'ita fafiga.” ");
INSERT INTO kwd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mooru moru longoa no'o nga tagi te'efou na gila iiria fana wawarifu dauru mai na'o laka'u 'e 'ilo'oo, ‘'I'oo sia kwa'ia wane. Lauta ni dai ne'e kwa'ia wane, tagila ngaria 'i na'ona nga ta'a ni kwaisufaingaa.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tafe'ua alata lo'oo, nau ku iiria famooru, ni dai ne'e ogaria tago fana nga wane ni futanga aana, tagila ngaria te'ana ta'a ni kwaisufaingaa. Ma ni dai ne'e iiria fana nga wane ni futanga ana, ‘'I'oo nga 'ola 'uri'uri lo'oo mola,’ tagila ngaria te'ana ta'a ni fadafadanga. Ma ni dai ne'e fata ngadaa nga wane ni futanga ana, ngaia 'e leka na tala fana nga eele ne'e nunula ma 'e sia mae la'u. ");
INSERT INTO kwd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lauta 'i'oo sasari agau no'o na tabonga amu fana God fofona nga uumu, moko madafia te'e 'ola 'ame wataga 'ua 'i laloamoo'o wane molo futa suria nga kutanga amu, ");
INSERT INTO kwd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'Oi 'akwasia madi tabonga amu 'i maana uumu no'ona, sui moko ori, moko fata ni kwaimaanga madi fe'enia. Burina, ma to'o bi'i ori mai moko bi'i kwatea nga tabonga amu fana God. ");
INSERT INTO kwd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma lauta te'efuta wane 'e ngari'o fana kwaisufaingaa, 'oi fata kwaimaanga madi fe'enia, alata moo'o molo 'ame nigi 'ua na lefu fana kwaisufaingaa. Tofuna lauta molo nigi no'ona no'o, ngaia te'e kwate'o no'o fana nga wane ni kwaisufaingaa, ma 'i burina ngaia 'e sufa'o 'e sui, ngaia te'e kwate'o la'u fana ta'a ni 'abelongaa, ma nga ta'a ni 'abelongaa tagila aru'o la'u 'ubulana lokafu. ");
INSERT INTO kwd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nau ku iiria famu, lauta ngaia 'e 'ilo'oo, ngaia 'e 'ato no'o 'i'oo 'ani ru'u fa'asia nga lokafu leleka moko kwatea nga seleni 'i'isi amu ne'e to'omia kwa'ikwa'inga amu.” ");
INSERT INTO kwd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Moru longoa no'o nga tagi ne'e iiria, ‘'I'oo sia agemani mola.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma alata lo'oo, nau ku iiria famooru, ni dai ne'e bubunia te'efuta nonigeni 'ania manate'e wane ni kwaisiriinga, ngaia 'e agemani 'e sui no'o 'ania mangona. ");
INSERT INTO kwd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngaia lo'oo, lauta 'i'oo siria 'i'oo 'ani agea ta 'ola 'e ria 'ania gule'e maa le'a amu, 'oi lafua, moko to'osia fa'asi'o. Ngaia te'e le'a mola lauta 'i'oo to'osia te'e gule'e 'ola na nonimu, fa'asia God ta to'osia nga nonimu te'efou 'i 'ubulana nga eele na lefu na kwa'ikwa'inga. ");
INSERT INTO kwd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma lauta 'i'oo siria 'i'oo 'ani agea te'efuta 'ola 'e ria 'ania gule'e nima le'a amu, 'oi furi mousia moko to'osia fa'asi'o. Ngaia te'e le'a mola lauta 'i'oo to'osia te'e gule'e lefu 'i nonimu, fa'asia God ta to'osia nga nonimu te'efou 'i 'ubulana nga eele na lefu na kwa'ikwa'inga.” ");
INSERT INTO kwd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mooru longoa no'o nga Tagi ne'e iiria, ‘Ni dai ne'e rugasia nga noni aana, ngaia te'e kwatea girigiringa na kwairugasinga fana.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tafe'ua alata lo'oo, nau ku iiria famooru, te'efuta wane 'e sia ma'asini te'enia mola nga noni aana. Lauta wane 'e ma'asini te'enia noni aana, ngaia ne'e kwatea noni aana fana agemaninga. Ma lauta te'efuta wane 'e feea la'u nga noni lo'oori, nga wane no'ona ngaia 'e fuageni kwaifafi la'u mola 'i na'ona God. Te'e 'ola na nga wane su'asuria te'e 'akwasia nga noni aana tofuna, lauta ngaia 'e agemani fe'enia te'efuta wane matari. ");
INSERT INTO kwd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mooru longoa la'u mola nga tagi gila iiria fana nga ta'a 'ua no'o mai na'o. ‘'I'oo sia mousia mola fataarunga'inga amu; lauta 'i'oo fa'ategelaa fataarunga'inga amu 'ania latana God, 'i'oo sia mousia mola fataarunga'inga amu.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma alata lo'oo, nau ku iiria famooru, 'i'oo sia fa'ategelaa mola fataarunga'inga amu 'ania te'efuta 'ola. 'I'oo sia fa'ategelaa mola fataarunga'inga amu 'ania fanua 'i Langi, tofuna God ngaia 'e ba'ita no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma 'i'oo sia fa'ategelaa mola fataarunga'inga amu 'ania fanua lo'oo 'i wado, tofuna God ngaia 'e ba'ita la'u mola 'i lo'oori. Ma 'i'oo sia fa'ategelaa mola fataarunga'inga amu 'ania 'i Jerusalem, suria ngaia nga fanua na God, nga kiingi ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma 'i'oo sia fa'ategelaa mola fataarunga'inga amu 'ania goumu, suria ngaia 'e 'ato fana 'i'oo 'ani launge'enia te'e me'e ifiifu 'i goumu 'ani kwakwao'a 'amoe maka bobola'a. ");
INSERT INTO kwd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lauta 'i'oo kwaialami, iiria mola, ‘Kiu,’ ma lauta 'i'oo 'ame kwaialami, iiria mola, ‘'Amoe.’ Ma lauta 'i'oo iiria la'u te'efuta 'ola, nga 'ola no'ona ngaia 'e leka no'o mai fa'asia Saetan.” ");
INSERT INTO kwd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","La Jisas 'e alafuu la'u maka fata 'ilo'oo, “Mooru longoa te'efou no'o nga tagi laka'u 'e fata 'ilo'oo, ‘Lauta te'efuta wane 'e ngadaa nga maana te'efuta wane ngaa'i, tagila ngadaa la'u mola maana wane no'ona. Ma nga nifo la'u mola fana du'ulana gwe'e nifo.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tafe'ua alata lo'oo, nau ku iiria famooru, 'i'oo sia du'aa mola te'efuta 'ola 'e ria na'a nga ta'a gila agea amu. Lauta te'efuta wane 'e fidaria nga gula le'a na babarimu, alamia 'ani fidaria la'u mola nga gula moori na babarimu. ");
INSERT INTO kwd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma lauta te'efuta wane 'e ngari'o fana nga kwaisufaingaa fana ngarilana nga sote amu, 'oi alamia 'ani ngaria la'u mola nga ruu amu na gwaringa fana. ");
INSERT INTO kwd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma lauta te'efuta wane 'e su'unge'eni'o 'ano ngaria ni 'ola aana suria nga tofi'i tala, 'oi ngaria suria rua tofi'i tala. ");
INSERT INTO kwd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moko kwate fana te'efuta wane na ngaia 'e soea te'efuta 'ola amu. Ma alata te'efuta wane 'e siria 'ani gania te'efuta 'ola amu, kwatea fana.” ");
INSERT INTO kwd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mooru longoa te'efou no'o nga alafuunga tegela'a laka'u 'e fata 'ilo'oo, ‘Moru kwaimaa fana nga ta'a kwaimaanga amooru, ma moru ka aga mani na marimae amooru.’ ");
INSERT INTO kwd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tafe'ua alata lo'oo, nau ku iiria famooru, moru kwaimaa fana nga marimae amooru, ma moru ka fo'a fani dai na gila malate'ote'o amooru. ");
INSERT INTO kwd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Lauta moru agea 'ilo'oo, ngaia 'e faate'enia moru wela na Mama'a amooru 'i Langi. Suria ngaia 'e launge'enia nga sina 'ani lala 'afuia nga ta'a na gila ria ma nga ta'a gila le'a la'u mola, maka kwatea nga uuta fana ni dai na gila agea ni 'ola 'e le'a, ma fana ta'a na gila agea ni 'ola lo'oo 'e ria. ");
INSERT INTO kwd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lauta moru kwaimaa mola fana nga ta'a na gila kwaimaa famooru, God 'e sia kwatea mola foforinga famooru. Tofuna gwa'a nga ta'a ni gonilana seleni na takisi, ma gila agea la'u mola 'ola lo'oori! ");
INSERT INTO kwd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma lauta moru alafuu le'a mola fe'enia nga wane ni kwaimaanga amooru, moru 'ame matari mola fa'asia nga ta'a lo'oo te'efou. Suria nga ta'a gila bobolosia God, gila agea la'u mola 'ola lo'oori! ");
INSERT INTO kwd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Moru 'amoru odo, 'ilaka'u nga Mama'a amooru 'i Langi ne'e odo 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma la Jisas ka fata la'u 'ilo'oo, “Moru 'abelo 'ania mooru, fa'asia moru ta agea mola 'ola 'e le'a fana ta'a 'agila agasia, ma gila ka tafe 'amooru tofuna. Lauta mooru agea 'ino'ona, ma moru sia ngaria mola te'efuta foforinga fa'asia nga Mama'a mooru mai langi. ");
INSERT INTO kwd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lauta 'i'oo kwatea nga kwakwatenga fana boonilana ta'a galafa'a, 'i'oo sia foule'enia mola fana ta'a 'agila tafe'o fafia. Suria nga falafala lo'oori, na nga ta'a kotokoto gila agea. Gila kwaibooni na ta'a galafa'a 'ubulana 'ifi ni fo'anga ma suria nga tala ba'ita, fana ta'a te'efou 'agila baatafega. Ma nau ku iiria famooru, God 'ame kwatea nga foforinga faga, suria gila ngaria no'o nga foforinga aaga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma alata 'i'oo kwatea te'efuta 'ola fana kwaibooninga, 'i'oo sia faate'enia mola fana te'efuta wane, fana gwa'a wane ni kwaimaanga amu ma 'e sia su'a mola ai. ");
INSERT INTO kwd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Alata 'i'oo kwatea te'efuta 'ola fana te'efuta wane, 'i'oo to'o na'agonia fa'asia nga ta'a, fana gila sia agasia mola ma gila sia su'a mola ai. Gwa'a 'i'oo kwate nagwa nagwa ai, nga Mama'a amu na'a ngaia 'e nana'i mai 'i Langi, ngaia 'e agasia no'o 'olataa no'ona 'i'oo agea, ma ngaia te'e kwatea foforinga famu.” ");
INSERT INTO kwd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","La Jisas 'e fata 'ilo'oo la'u, “Alata moru fo'a, moru sia 'ilaka'u mola ta'a ni kotonga na'a gila fo'a mola fana nga ta'a no'ona 'agila agasiga. Suria nga alata gila fo'a, gila siria ulanga 'ubulana 'ifi ni fo'anga ma suria tala ba'ita, fana nga ta'a 'agila agasiga, ma gila ka tafega. Ma nau ku iiria famooru, gila ngaria no'o nga foforinga aaga fa'asia nga ta'a na gila tafega. ");
INSERT INTO kwd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma nga alata 'i'oo fo'a, 'oi leka na lefu ne'e nana'i talana, moko nana'i 'i no'ona, moko fo'asia God, ma te'efuta wane 'e sia agasia mola. Ma gwa'a te'efuta wane ma 'e sia agasi'o mola na alata 'i'oo fo'a, Mama'a amu ne'e nana'i mai 'i Langi ngaia ne'e agasi'o. Ma ngaia te'e kwatea foforinga famu fana 'olataa na'a 'i'oo agea. ");
INSERT INTO kwd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Alata moru fo'a, moru sia 'ilaka'u la'u ta'a na gila bobolosia God. Suria alata gila fo'a, gila alafuu 'e tekwa 'e iiki, ma gila 'ame su'a mola na 'olataa na gila iiria. Gila madafia lauta gila fo'a tekwa 'ilo'oo, ni god aga tagila longoga. ");
INSERT INTO kwd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma moru sia agea la'u 'ilaka'u 'i gila, suria Mama'a amooru 'i Langi ngaia 'e su'asuria te'efou no'o 'olataa na'a moru bo'obo'o fai, 'ina'o moru bi'i soea. ");
INSERT INTO kwd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Alata moru fo'a, tamoru fata 'ilo'oo, Mama'a ameeru 'i Langi, Meeru meru siria ta'a lo'oo te'efou 'agila fa'aba'itaa latamu, tofuna ngaia 'e abu 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Meeru miru siria 'i'oo 'ani ba'ita fafia mangona ta'a lo'oo te'efou. Ma nga kwaisiriinga amu 'ani lau no'o 'i wado 'ilaka'u la'u mola 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'Oi kwatea mai fangalaa ne'e to'omia meeru fana gani lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Moko 'olafanataa na rianga ameeru, 'ilaka'u la'u mola na'a 'imeeru meru 'olafanataa na rianga na ta'a lo'oo te'efou na gila agea ni 'ola 'e ria ameeru. ");
INSERT INTO kwd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'I'oo sia alami 'ameeru mola fana lekanga 'ubulana irito'onga ne'e riufi 'ameeru. Ma 'i'oo 'ani fa'amoori 'ameeru fa'asia la Saetan. ");
INSERT INTO kwd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aia, ma lauta moru 'olafanataa ani dai ne'e agea ni 'ola 'e ria amooru, Mama'a amooru 'i Langi ngaia te'e 'olafanataa la'u mola na rianga amooru. ");
INSERT INTO kwd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma lauta moru 'ame 'olafanataa ani dai ne'e agea 'ola 'e ria amooru, Mama'a amooru 'i Langi 'e sia 'olafanataa mola na rianga amooru.” ");
INSERT INTO kwd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","La Jisas 'e fata 'ilo'oo la'u, “Alata moru abu keto fana fo'anga tegela'a, moru sia 'ilaka'u mola ta'a ni kotonga. Suria nga alata gila abu keto, gila aga 'ilaka'u ta'a gila kwaimanadai fana nga ta'a 'agila agasia na gila abu keto, ma gila ka tafega. Ma nau ku iiria famooru, nga ta'a lo'oo 'e 'ato no'o 'agila ngaria te'efuta foforinga la'u, suria gila ngaria no'o nga foforinga aaga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nga alata 'i'oo 'ani abu keto, 'i'oo narufia maamu, moko 'usua waiwai na goumu 'ilaka'u 'i'oo agea gani mai gani, ");
INSERT INTO kwd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","fana te'efuta wane 'e sia aga su'a mola na'a 'i'oo abu fanga. Ma gwa'a te'efuta wane 'ame aga su'a amu, Mama'a amu 'i Langi ngaia 'e agasi'o, ma ngaia te'e kwatea nga susuga famu tofuna nga 'olataa lo'oo 'i'oo agea. Ngaia 'e agasi'o gani mai gani, gwa'a 'i'oo 'ame agasia.” ");
INSERT INTO kwd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sui la Jisas 'e fata la'u 'ilo'oo, “Moru sia gonia mola nga dari'olanga amooru fofona fanua lo'oo 'i wado, nga lefu nga rimerime ma nga fulanga te'e ngadaa ma nga ta'a beriberi tagila beria lau mola. ");
INSERT INTO kwd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Moru gonia nga dari'olanga amooru 'i Langi, lefu nga rimerime ma nga fulanga 'e sia ngadaa mola, ma nga ta'a beriberi gila sia beria mola. ");
INSERT INTO kwd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tofuna alata nga dari'olanga 'amooru ngaia 'e nana'i 'i Langi, nga manata lamooru 'e fongu te'efou no'o fana ni 'ola 'i Langi. Ma alata nga dari'olanga 'amooru ngaia 'e nana'i fofona fanua lo'oo 'i wado, nga manata lamooru 'e fongu te'efou no'o fana ni 'ola fofona nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lauta maamu 'e le'a, 'i'oo to'o nana'i 'ubulana nga lalanga na kwaifa'ananaunga na God, tofuna nga maamu ne'e talaia mai lalanga fana 'ubulana nonimu. ");
INSERT INTO kwd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lauta 'i'oo 'ame agasia nga lalanga lo'oo, maamu 'e ria, moko nana'i no'o 'ubulana ma'e logo. 'I'oo to'o 'abelo le'a 'ani'o, lauta 'i'oo ma'asini te'enia nga lalanga na God, ma manatalamu ngaia 'e logologo'a 'e iiki no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","La Jisas 'e fata 'ilo'oo la'u, “'Ato fana te'efuta wane 'ani taunga'i fana nga rua wane ba'ita kwaitatari. Lauta ngaia 'e 'ilo'oo, ngaia te'e marimae na wane ba'ita ngaa'i, ma te'e kwaimaa fana nga wane ba'ita ngaa'i. Ma ngaia te'e taunga'i le'a fana nga wane ngaa'i, ma te'e aga mani na wane ngaa'i. Ngaia lo'oo, 'e 'ato 'e iiki fana 'amoru taunga'i fana God ma nga bata na te'e alata momola. ");
INSERT INTO kwd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ngaia lo'oo nau ku iiria famooru, moru sia manata 'abelo mola suria 'olataa na tamooru 'ania, ma tamoru go'ufia, ma 'olataa na tamooru ruu 'ania fafia noni mooru. Tofuna nga mooringa, ngaia 'e le'a 'e iiki riufia nga fangalaa, ma nga labe'ola ngaia 'e le'a 'e iiki riufia nga ruu. ");
INSERT INTO kwd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Agasia nga langasi 'ubulana lalo. Gila 'ame 'abelo mola suria taunga'inga na te'efuta langa'a. Ma gila 'ame gonia mola te'efuta fangalaa, ma gila 'ame launge'enia mola te'efuta 'ifi fana arulana fafangalaa ai. Tafe'ua ma Mama'a amooru 'i Langi 'e langoniga mola te'efou. Aia, God ngaia 'e iiri ba'ita amooru 'e talariufia nga langasi lo'oo. Ngaia lo'oo, God te'e langoni 'amooru la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tafe'ua moru manata 'abelo suria mango mooru, ngaia 'e 'ato 'e iiki 'amooru agea mango mooru 'ani lalau sisika la'u. ");
INSERT INTO kwd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma 'ola 'e fe'ua na moru manata 'abelo suria nga ruu? Moru agasia madi nga lamalama na 'ai. Gila 'ame taunga'i la'u mola, ma gila 'ame launge'enia la'u mola te'efuta ruu faga. ");
INSERT INTO kwd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma nau ku iiria famooru, gila aga kwanga'a maka iiki riufia ruu na'a la kiingi Solomon ngaia 'e ru'ufia. ");
INSERT INTO kwd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma nga tatakana 'ai lo'oo, gila nana'i mola suria te'e alata ko'uko'uta, ma gila ka 'ui la'u mola 'aniga 'ubulana eele. Ma ngaia 'e 'ilo'oo la'u mola, God ngaia 'e fa'aruufiga 'ania ni 'ola 'e le'a. 'Ilo'oo ma mooru fitala iiria God 'e sia fa'arufia mooru mola? Nga tagoto'onga amooru ngaia 'e sisika. ");
INSERT INTO kwd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ngai lo'oo, moru sia manata 'abelo mola 'ilo'oo, ‘Nga fangalaa, ma nga 'ola fana go'ufilai, ma nga ruu agu te'e leka mai fa'asia 'i fai? ");
INSERT INTO kwd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nga ta'a na'a gila bobolosia God, gila manata 'abelo suria ni 'ola lo'oo. Mai 'amooru, Mama'a amooru 'i Langi ngaia 'e su'asuria sui no'o na 'i 'amooru moru bo'obo'o fana ni 'ola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tafe'ua, moru kwaisirii ba'ita fana nga mooringa lo'oo God ngaia 'e ba'ita fafia fe'enia agelana nga 'ola 'e odo. Moru kwaisirii fani 'ola lo'oo 'ania riufia ni 'ola kwaitatari te'efou, ma ngaia te'e kwatea ni 'ola te'efou na mooru bo'obo'o fai famooru. ");
INSERT INTO kwd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngaia lo'oo, moru sia manata 'abelo mola suria 'abelongaa fana 'igani. Arua 'ani nana'i no'o fana 'igani. Ngaia 'ame to'omia fana 'amoru ogua nga 'abelongaa 'i gani fe'enia nga 'abelongaa fana gani tala'ina. Tofuna gani ngaia 'e to'o no'o na 'abelongaa ne'e to'omia 'i tala'ina.” ");
INSERT INTO kwd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma la Jisas ka fata 'ilo'oo la'u, “Mooru sia sufaa mola te'efuta wane ngaa'i, fa'asia God ka sufa 'amooru la'u. ");
INSERT INTO kwd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lauta moru sufaa nga ta'a ngaa'i, God te'e sufa 'amooru 'ino'ona la'u mola. Ma nga falafala ngai taa na tamoru kwaisufai 'ania na wane ngaa'i, nga falafala no'ona la'u mola na God te'e sufaa mooru 'ania. ");
INSERT INTO kwd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'I'oo to'o na rianga ba'ita, tafe'ua moko iila mola fana te'efuta wane na ngaia 'e to'o na rianga sisika. 'Ola 'e fe'ua 'i'oo agasia nga ngaru ngai 'ubulana maana wane ni futanga amu, mai 'i'oo 'ame agasia mola memede 'ai ba'ita na'a ngaia 'ubulana maamu 'i talamu? ");
INSERT INTO kwd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma 'i'oo fata 'ilo'oo fana nga wane matari, ‘'I'oo agea nga 'ola na ngaia 'e ria, alamia 'aku fa'aodoa manatalamu.’ Tafe'ua 'i'oo 'ame manata 'abelo mola suria rianga ba'ita na 'i'oo agea. ");
INSERT INTO kwd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'I'oo wane ni kotonga. 'Oi 'akwasia madi nga rianga amu. Sui ma, 'i'oo to'o bi'i to'omia kwaibooninga na te'efuta wane ngaa'i na nga rianga aana. ");
INSERT INTO kwd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma moru sia kwatea mola nga 'ola 'e abu fana ku'ito, suria tagila bu'ota'i, ma gila ke'e 'amooru mola. Ma moru sia kwatea mola kwasila amooru fana boo, fa'asia gila ta talaufia mola.” ");
INSERT INTO kwd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","La Jisas 'e fata 'ilo'oo la'u, “Mooru kwaisoe na God fana 'amoru ngaria 'ola na moru kwaisoe fai. Mooru kwailo'ofia 'ola moru bo'obo'o fai na God, ma ngaia te'e booni 'amooru, fana 'amoru daria. Mooru igiigi na sinamaa, ma God te'e 'ulasi famooru. ");
INSERT INTO kwd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tofuna nga ta'a te'efou na gila kwaisoe na God, God te'e kwate faga. Ma nga ta'a te'efou na gila kwailo'ofia 'ola gila bo'obo'o fai na God, tagila daria. Ma nga ta'a te'efou na gila igiigi na sinamaa, God te'e 'ulasi faga. ");
INSERT INTO kwd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“'Ino'ona ma, ni dai amooru mama'a, na lauta nga wela amu ngaia 'e orisi'o fana ma'alo, mai 'i'oo to'o kwatea mola nga fou fana? ");
INSERT INTO kwd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma lauta nga wela amu ngaia 'e kwaisoe fana te'efuta ii'a, ma 'i'oo to'o kwatea mola nga waa fana? Ngaia 'e 'ato no'o! ");
INSERT INTO kwd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Gwa'a 'amooru te'efou ta'a moru ria, mooru su'asuria 'amoru kwatea mola nga 'ola le'a fana wela amooru. Tafe'ua ma Mama'a amooru na ngaia 'i Langi, ngaia 'e le'a 'e iiki riufi 'amooru. Ngaia 'e su'asuria te'e kwatea 'ola le'a fana ta'a na gila kwaisoe aana. ");
INSERT INTO kwd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“'Olataa na moru siria fa'asia ta'a matari 'agila agea famooru, tamoru agea la'u mola faga. Suria ni 'ola lo'oo ngaia na nga fa'awatagalana nga kwaifa'ananaunga na Tagi ala Moses, ma ni profet te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","La Jisas 'e fata 'ilo'oo la'u, “Moru ru'u na sinamaa ne'e sisitai, suria nga tala ma nga sinamaa ne'e ba'ita maka afola, ngaia 'e leka fana nga maenga firi. Ma nga lekanga suria 'e talawada'u ma nga ta'a 'e aula 'e iiki gila leka 'i suria nga tala no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aia, nga tala ma sinamaa ne'e sisitai ngaia 'e leka fana nga mooringa firi, ma nga lekanga suria 'e 'ato, ma te'e ni ta'a tarito'o na gila leka suria.” ");
INSERT INTO kwd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","La Jisas 'e alafuu la'u maka fata 'ilo'oo, “Moru 'abelo 'ania mooru fa'asia ni profet 'e 'ame to'o. Moru 'abelo 'ania mooru tofuna gila aga 'ilaka'u ta'a le'ale'a, tafe'ua ma nga manatalaga ngaia 'e 'ilaka'u nga ku'ito kwasi na'a gila siria ngada lamooru. ");
INSERT INTO kwd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma tamoru aga su'a mola na ni profet 'ame to'o no'ona 'ania ni 'ola ria na gila agea. Goru su'asuria 'ai te'efou ngaia 'e le'a 'amoe ma ngaia 'e ria, tofuna lode 'ola na gila fungu 'ania. Ma ngaia 'e 'ato fana te'efuta wane 'ani fisua nga lode 'ola le'a fa'asia nga kwalo ngangala'a. ");
INSERT INTO kwd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma nga 'ai le'a ngaia 'e fungu mola 'ania lode 'ola 'e le'a, ma nga 'ai 'e ria ngaia 'e fungu la'u mola 'ania lode 'ola 'e ria. ");
INSERT INTO kwd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nga 'ai ne'e le'a, 'ato 'ani fungu 'ania lode 'ola 'e ria, ma nga 'ai 'e ria, 'e 'ato 'ani fonu 'ania lode 'ola 'e le'a. ");
INSERT INTO kwd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nga 'ai te'efou la'u mola na gila 'ame fungu 'ania lode 'ola 'e le'a, tagila tofuga, ma gila 'ui 'aniga 'i 'ubulana eele. ");
INSERT INTO kwd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngaia lo'oo, nau ku iiria famooru, tamoru aga su'ana ni profet kotokoto 'ania ni 'ola na'a gila agea.” ");
INSERT INTO kwd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","La Jisas 'e alafuu 'ilo'oo la'u, “Nga ta'a te'efou na gila fata 'ilo'oo agu, ‘Alafa! Alafa!’ gila sia nana'i mola fe'enia ta'a na God 'e ba'ita fafiga. Tafe'ua ni dai na gila leka suria nga kwaisiriinga na Mama'a agu 'i langi, na tagila nana'i fe'enia ta'a na God te'e ba'ita fafiga. ");
INSERT INTO kwd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ma nga ta'a 'e auaula tagila fata 'ilo'oo fagu na fe'e gani na kwaisufaingaa no'ona, ‘Alafa, 'imeeru meru foulange'enia nga fatalana God 'ania nga latamu, ma meeru ka belote'enia nga adalo 'ania nga latamu, ma meeru ka agea 'ola auaula ni 'alefongaa 'ania latamu.’ ");
INSERT INTO kwd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tafe'ua ma 'inau taku fata wataga 'ilo'oo faga, Nau ku 'ame su'a amooru. Mooru nga ta'a moru ria. Moru leka lalau kau fa'asi nau! ");
INSERT INTO kwd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ngaia lo'oo nga ta'a te'efou na gila longoa alafuunga agu, ma gila ka lo'o suria, tagila 'ilaka'u nga wane funi'oo na ngaia 'e launge'enia nga 'ifi ana 'i fofona ngata na ngaia 'e 'eri le'a fana bou ai 'ani sifo to'o. ");
INSERT INTO kwd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gwa'a uuta ba'ita 'e to'o, ma nga ka'o ka afe, ma nga iru ba'ita 'e kwa'ia nga 'ifi no'ona, ma nga 'ifi no'ona 'ame 'e sia mola, tofuna ngaia 'e ula 'e ngasi 'i fofona ngata. ");
INSERT INTO kwd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ma nga ta'a te'efou na gila longoa nga alafuunga agu, ma gila 'ame lo'o suria, gila 'ilaka'u nga wane kwekweto na ngaia 'e launge'enia nga 'ifi aana na oone, ma ngaia 'ame 'eri fana bou ai 'ani sifo to'o. ");
INSERT INTO kwd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nga uuta ba'ita 'e to'o, ma nga ka'o ka afe, ma nga iru ba'ita 'e kwa'ia nga 'ifi no'ona, ma nga 'ifi no'ona 'e 'esia, maka tagala'i te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Alata la Jisas ngaia 'e fa'ananaua ta'a lo'oo 'ania ni 'ola lo'oo te'efou 'e sui, ma gila ka 'alefo ba'ita, ");
INSERT INTO kwd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","suria gila su'a le'a ai la Jisas ngaia 'e kwaifa'ananau 'ania tegelangaa fa'asia God. Ma kwaifa'ananaunga aana 'ame 'ilaka'u ta'a kwaifa'ananaunga na Tagi ala Moses, tofuna gila kwaifa'ananau mola 'ania tegelangaa aaga 'i talaga. ");
INSERT INTO kwd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Alata la Jisas ngaia 'e sifo mai fa'asia gouna nga busu no'ona, nga oguogunga ba'ita gila ka leka mai suria. ");
INSERT INTO kwd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma te'e wane na kuu 'e daua nonina 'e leka mai, maka bobouruuru 'i na'ona la Jisas, maka fata 'ilo'oo, “Welakau, lauta 'i'oo 'uri, 'i'oo su'asuria 'ani gula nau no'o mai.” ");
INSERT INTO kwd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sui mala Jisas 'e tagwala kau nga nimana, maka gema to'ona nonina, maka fata 'ilo'oo, “Kiu, nau ku 'uri. 'I'oo gula no'o.” Ma 'ame gole mola 'i burina alafuunga lo'oori la Jisas 'e iiria mola, nga kuu no'ona ka sigi no'o fa'asia wane no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","La Jisas 'e alafuu 'ilo'oo fana, “'I'oo sia kwairii mola te'ana te'efuta wane na 'ola lo'oo nau ku agea famu. Tafe'ua 'i'oo leka madi, moko faate'enia nga nonimu te'ana nga fataabu na God, moko alamia fataabu 'ani agasi'o. Sui moko kwatea nga tabonga amu 'ilaka'u la Moses ngaia 'e iiria fana kwatelai, fana 'ani fa'ato'oa fana nga ta'a te'efou na'a nonimu ngaia 'e gulaa no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma nga alata la Jisas ngaia 'e nigi na fanua 'i Kapaneam, te'e wane na'ona'o na ta'a ni fununga fa'asia 'i Rom, ngaia 'e leka mai te'ana la Jisas, maka soea fana 'ani kwaibooni ana ");
INSERT INTO kwd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","maka 'ilo'oo, “Alafa, nga wane ni taunga'inga agu, ngaia 'e fii 'e iiki, ma ngaia mola fofona furi, maka 'ato no'o fana bulote'enilana nonina suria nga nonina 'e fii 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","La Jisas ka fata 'ilo'oo fana, “Le'a mola, nau taku leka kau fana 'i 'ifi amu fana 'aku gulaa.” ");
INSERT INTO kwd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma wane na'ona'o no'ona ka fata 'ilo'oo fala Jisas, “Alafa, nau ku 'ame to'omia fana 'i'oo 'ani leka 'ubulana 'ifi agu. 'Oi iiria mola mai te'efuta alafuunga, ma nga wane taunga'inga agu ngaia te'e gwari'a mola. ");
INSERT INTO kwd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau ku su'aai 'i'oo to'omia 'ani agea mola nga 'ola 'ilo'oo, tofuna 'inau talagu nga wane nau ku taunga'i 'i olofana nga ta'a ba'ita, mai nau ku to'o la'u na ta'a ni fununga na gila taunga'i 'i olofana nga tegelangaa agu. Ma lauta nau ku fata 'ilo'oo fana te'efuta wane, ‘'Oi leka,’ ma ngaia 'e leka no'o. Ma lauta nau ku fata 'ilo'oo fana te'efuta wane, ‘'Oi leka mai,’ ma ngaia 'e leka la'u mola mai. Ma lauta nau ku fata 'ilo'oo fana te'efuta wane ni taunga'inga agu mai nau ku 'ilo'oo, ‘'Oi agea 'ola lo'oo,’ ma ngaia 'e agea no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma alata la Jisas ngaia 'e longoa nga 'ola lo'oo, ngaia ka 'alefo ba'ita. Ma ngaia 'e bu'ota'i fana ta'a na gila leka suria, maka fata 'ilo'oo te'aga, “Nau ku kwairii te'amooru, nau ku 'ame agasia 'ua te'efuta wane na tagoto'onga ana 'ilo'oo 'ubulana fanua 'i Israel. ");
INSERT INTO kwd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma nau ku iiria famooru, ta'a 'e aula na gila 'ame Jiu, tagila leka mai fa'asia fanua 'e auaula fofona fanua lo'oo 'i wado fana ladonga fe'enia nga wawarifu dauru la Ebraham, la Aesak, ma la Jekob na fafangalaa 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma ta'a 'e aula 'i Jiu na God 'e firiga fana 'agila to'oru fe'enia 'i Langi, ngaia te'e to'osiga fana lefu logologo'a. Ma alata gila nana'i na lefu no'ona, tagila aani, ma tagila girigiri nifo tofuna gila nonifii.” ");
INSERT INTO kwd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma la Jisas 'e bu'ota'i te'ana wane na'ona'o lo'oori, maka fata 'ilo'oo fana, “'Oi ori kau. Nau taku agea no'o nga 'ola na 'i'oo soea, 'ilaka'u 'i'oo tagoto'o agu.” Ma nga alata no'ona la'u mola, nga wane ni taunga'inga laka'u ngaia ka gwari'a no'o. ");
INSERT INTO kwd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma te'e gani ngaa'i, la Jisas 'e leka mai 'i 'ifi ala Pita. Alata la Jisas 'e ru'u 'i 'ifi, ngaia 'e agasia fungona geni la Pita ngaia 'e eeno mola fofona furi, tofuna ngaia 'e fii 'ania 'ago'agonga ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma la Jisas 'e gema na nimana nga noni lo'oo. Ma te'e alata no'ona la'u mola, nga 'ago'agonga laka'u ka sui no'o fa'asia. Ngaia 'e gwari'a no'o, maka tata'e maka launge'enia fangalaa no'o fala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma alata ngaia 'e laulafi no'o, ta'a na fanua no'ona gila ka ngaria mai ta'a 'e aula te'ana na'a adalo gila bo'ega. Ma la Jisas 'e belote'enia adalo lo'oori fa'asiga 'ania fatalana mola. Ma ngaia ka gulaa la'u mola ta'a na gila fii te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alata ngaia 'e agea ni 'ola lo'oo, ngaia 'e fa'ato'oa nga fatalana la profet Aesea laka'u 'e giria maka fata 'ilo'oo, “Ngaia ne'e lafua wata'uta'unga adauru maka fa'amoori 'adauru fa'asia nga fifiinga adauru.” ");
INSERT INTO kwd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ma alata la Jisas ngaia 'e agasia ta'a 'e aula gila ogu mai 'afuia, ngaia ka fata 'ilo'oo fana fufu'iwane aana, “Goru olofolo fana gule'e asi loko'u.” ");
INSERT INTO kwd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nga alata no'ona la'u mola, te'e wane ni kwaifa'ananaunga na tagi 'e leka mai te'ala Jisas maka fata 'ilo'oo, “Wane kwaifa'ananaunga, nau ku siria 'aku leka fe'eni'o te'efuta lefu na 'i'oo 'ani leka ai.” ");
INSERT INTO kwd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Alata la Jisas 'e longoa nga 'ola lo'oo, ngaia ka fata 'ilo'oo, Ngaia 'ame wada'u. Nga ku'ito kwasi gila to'o na nga lefu aaga fana enonga, ma nga langasi gila to'o la'u na nga nuu'i aaga. Tafe'ua ma 'inau, nga Wela na Wane, nau ku 'ame to'o na te'efuta 'ifi fana enonga ai.” ");
INSERT INTO kwd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma te'e wane na ta'a na gila lado aana ka alafuu fala Jisas maka 'ilo'oo, “Welakau, 'oi alami nau fana 'aku leka, 'aku nana'i madi fe'enia mama'a agu, leleka ngaia 'e mae, mai nau ku kwaiatoa 'e sui, ma 'inau taku bi'i lado amu.” ");
INSERT INTO kwd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","La Jisas 'e lamadu'aa maka fata 'ilo'oo, “'Oi leka mola mai fe'eninau na alata lo'oo. Alamia nga ta'a na gila mae 'agila kwaiatoa nga ta'a na gila mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma la Jisas ka leka no'o 'ubulana nga baru fe'enia fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma alata gila 'idu lalau mola kau, nga koburu 'e nigi 'afe'aferu mai, ma nga bio ka uubu mai, maka mo'oi no'o mai fafia nga baru no'ona. Ma nga baru no'ona ka galangi kuruu no'o. Tafe'ua mala Jisas ngaia 'e eeno mola 'ubulana nga baru no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nga fufu'iwane aana gila fa'aagaa, ma gila ka fata 'ilo'oo, “Alafa! 'Oi fa'amoori adauru! Goru galangi mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","La Jisas 'e fata 'ilo'oo faga, “'Ola 'e fe'ua na moru ma'u? Nau ku agasia nga tagoto'onga amooru agu 'ame ba'ita.” La Jisas 'e alafuu 'ilo'oo sui, ma ngaia 'e tata'e, maka fata tegela'a fana iru ma nga bio, fana 'agila nana'i aloalo. Ma nga alata no'ona mola, nga iru ma nga bio gila ka nana'i aloalo no'o, maka folaa no'o. ");
INSERT INTO kwd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma nga fufu'iwane aana gila ka 'alefo ba'ita, ma gila ka fata 'ilo'oo, “Wane 'utaa lo'oo no'o fu'uwane? Gwa'a nga iru ma nga bio ma gila lo'o mola suria.” ");
INSERT INTO kwd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ma alata gila nigi na gule'e asi na maa'e fanua 'i Gadara, la Jisas ka to'odaria rua wane na adalo 'e bo'e 'agaa'a. Rua wane lo'oo gala nana'i mai 'ubulana nga giru gwa'u fana kwaiatolana ta'a gila mae. Ma tofuna gala ngenge'a 'e iiki, te'efuta wane 'ame nigi galangia no'o lefu na gala nana'i ai. ");
INSERT INTO kwd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Alata adalo ne'e nana'i na rua wane lo'oori, gala agasia la Jisas, gala ka o'omae 'ilo'oo, “Wela na God, 'olataa na 'i'oo siria 'ani agea ameeru? Fe'ua, 'i'oo leka mai fana malate'ote'onga ameeru 'i na'ona nga alata God 'e arua 'ani kwa'i 'ameeru?” ");
INSERT INTO kwd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nga alata no'ona, nga uumi'i boo 'e aula gila keto galangia lefu no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nga adalo lo'oo gila orisia la Jisas ma gila ka 'ilo'oo, “Lauta 'i'oo belote'eni 'ameeru, 'oi ale 'ameeru fana 'ubulana boo loko'u.” ");
INSERT INTO kwd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma la Jisas ka fata 'ilo'oo fana adalo lo'oo, “Moru leka no'o.” Ma gila ka ru'u mai ma gila ka leka no'o fana 'ubulana uumi'i boo laka'u. Ma uumi'i boo no'ona te'efou gila ka 'akwa 'ai tori no'o suria gegena 'abita no'ona fana 'ubulana asi laka'u. Ma gila ka mae te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma nga ta'a na gila aga suria boo lo'oo, gila ka totola no'o fana fanua aaga. Ma gila ka alafuu suria nga 'ola lo'oo la Jisas 'e agea, ma nga 'olataa ne'e lau fana nga rua wane laka'u na adalo gila bo'ea gaa'a. ");
INSERT INTO kwd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma nga ta'a na fanua no'ona gila ka leka te'efou mai fana agasilana la Jisas. Nga alata gila nigi te'ana, gila ka beloa fana ngaia 'ani leka fa'asia fanua aaga. ");
INSERT INTO kwd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sui ma la Jisas fe'enia nga fufu'iwane aana, gila fane 'i 'ubulana nga baru, ma gila ka olofolo la'u na nga asi ba'ita no'ona 'i Galili. Ma alata gila nigi na fanua 'i Kapaneam, ");
INSERT INTO kwd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tani wane ngaa'i gila ngaria mai te'e wane nga nonina 'e mae 'i fofona futa'i te'ala Jisas, fana ngaia 'ani gulaa. Ma alata la Jisas 'e agasia nga tagoto'onga aaga, ngaia ka fata 'ilo'oo fana wane lo'oo nonina 'e mae, “'I'oo sia ma'u mola, nau ku 'olafanataa no'o na rianga amu te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na nga alata no'ona, tani wane ni kwaifa'ananaunga na Tagi ala Moses gila ka manata 'ilo'oo, “Te'e God momola ne'e su'asuria 'ani 'olafanataa na rianga. Ngaia 'e fa'atooto'ome'enia 'i talana fe'enia God.” ");
INSERT INTO kwd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma la Jisas ngaia 'e su'a la'u mola na manatalaga, ma ngaia ka fata 'ilo'oo faga, “Mooru sia manata ria mola 'ilo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma ngaia ka fata 'ilo'oo, “Lauta nau ku alafuu 'ilo'oo fana wane lo'oo nonina 'e mae, ‘Rianga amu, nau ku 'olafanataa no'o ai,’ me'e 'ato 'amoru agasia. Tafe'ua lauta nau ku fata 'ilo'oo, ‘Tata'e moko leka,’ ma tamooru bi'i agasia 'ola ne'e lau. ");
INSERT INTO kwd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Alata nau ku gulaa wane lo'oo, nau taku faate'enia famooru na 'inau, Wela na Wane, nau ku to'o na tegelangaa fana 'olafanataanga na rianga.” Sui mala Jisas ka fata 'ilo'oo fana wane nonina 'e mae lo'oori, “'Oi tata'e no'o, ngaria futa'i amu, moko leka no'o 'i fanua amu.” ");
INSERT INTO kwd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na nga alata no'ona mola, wane lo'oo 'e tata'e, maka ori no'o fana fanua aana. ");
INSERT INTO kwd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Alata nga ta'a lo'oo gila agasia 'ola lo'oo la Jisas ngaia 'e agea, gila 'alefo, ma gila ka ma'u. Ma gila ka baatafea God tofuna ngaia 'e kwatea nga tegelangaa 'ilo'oo fana nga ta'a. ");
INSERT INTO kwd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma alata la Jisas ngaia 'e leka no'o fa'asia lefu no'ona, ngaia 'e agasia la Matiu. Ngaia nana'i mola na lefu fana gonilana seleni na takisi, tofuna ngaia 'e taunga'i ai. Ma la Jisas ka fata 'ilo'oo fana, “'Oi leka mai fe'eni nau.” Ma la Matiu 'e tata'e, maka leka no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma 'i burina na la Jisas ngaia 'e soea la Matiu fana wane na fufu'iwane aana, ngaia ka leka maka keto no'o 'i 'ifi aana. Ma tani ta'a ngaa'i na gila goni bata na takisi gila nana'i la'u mola 'i no'ona. Ma tani ta'a na gila ria la'u mola, gila keto la'u mola fe'enia la Jisas ma nga fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma alata nga ta'a Farasii gila agasia 'ola lo'oo, gila ka fata fana nga fufu'iwane aana ma gila ka 'ilo'oo, “Ngaia 'ame to'omia 'ani keto fe'enia ta'a na gila gonia bata na takisi ma ta'a gila ria.” ");
INSERT INTO kwd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","La Jisas 'e longoa 'ola lo'oori, maka fata 'ilo'oo, “Ta'a na gila 'ame fii, gila 'ame siria mola nga wane ni gulanga, ma nga ta'a na gila fii, na gila bo'obo'o fana wane ni gulanga. ");
INSERT INTO kwd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Moru manata madi suria fa'awatagalana Girigiringa Abu laka'u na God 'e iiria maka 'ilo'oo, ‘Nau ku siria 'amooru kwaimanadai fana ta'a, ma nga kwakwatenga 'amooru 'amoe.’ Nau ku 'ame leka mai fana soelana ta'a 'e odo fana 'agila bulota'i mai, tafe'ua ma nga ta'a na gila ria, nau ku leka mai fana soelaga fana 'agila bulosia manatalaga.” ");
INSERT INTO kwd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Burina ni 'ola lo'oo, nga fufu'iwane ala Jon wane ni Naruabunga, gila ka leka mai te'ala Jisas, ma gila ka fata 'ilo'oo, “Meeru ma ni Farasii, meeru su'asuria 'ameru abu fanga. Ma 'uta'i na nga fufu'iwane amu gila 'ame agea 'ilo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma la Jisas 'e lamadu'aga maka 'ilo'oo, “Ngaia 'ame to'omia ta'a na gila nana'i na fafangalaa na afolonga 'agila kwaimanadai. Tofuna nga alata alakwa fooru ngaia 'e nana'i mola 'ua fe'enia ta'a no'ona, tagila aile'a. Tafe'ua alata te'e nigi mai na tagila feea nga alakwa fooru fa'asiga. Sui ma, tagila bi'i abu keto la'u, tofuna gila kwaimanadai. Ngaia lo'oo nga fufu'iwane agu gila 'ame abu keto alata nau ku nana'i 'ua mola fe'eniga.” ");
INSERT INTO kwd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sui ma la Jisas ka fata 'ilo'oo la'u, “Te'efuta wane 'e sia taia mola ruu na ngaia 'e mou 'ania nga sisii'i ruu fooru. Lauta ngaia 'e agea, nga sisii'i ruu fooru lo'oori te'e gaasia mola ruu 'ua lo'oori du'ana ruu fooru ngaia 'e rugurugula 'i burina nga tailai, ma ngaia te'e agea nga ma'e kwakwa ne'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ma 'amoru su'a la'u mola ai, ngaia 'ame odo fana te'efuta wane 'ani arua no'o waeni fooru 'i 'ubulana wa'i 'ua na susungana nanigot, tofuna wa'i 'ua lo'oori 'ame ngasi. Lauta ngaia agea, alata nga waeni lo'oori 'e fane no'o mai, ngaia te'e gaasia no'o wa'i 'ua lo'oori, ma nga waeni lo'oori te'e akiri, ma nga wa'i lo'oori te'e ria no'o. Ngaia lo'oo wane te'e arua nga waeni fooru 'i 'ubulana nga wa'i fooru na ngaia 'e su'asuria ngaia 'e ngasi fana arulana 'ola lo'oo ai na ngaia 'e sia ria mola.” ");
INSERT INTO kwd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Alata la Jisas ngaia 'e alafuu 'ua, te'e wane na'ona'o na ta'a 'i Jiu 'e leka mai. Ma ngaia ka bobouruuru 'i na'ona la Jisas, maka fata 'ilo'oo, “Nga lari'i agu bi'i mae mola. Nau ku siria 'i'oo 'ani leka mai moko arua nimamu fafia fana ngaia 'ani moori la'u.” ");
INSERT INTO kwd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma la Jisas fe'enia nga fufu'iwane aana gila ka leka no'o fe'enia wane no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma nga alata gila leleka mola 'ua, te'e noni na gwe'e 'abu 'e 'ulasi ana, ma ngaia ka fii 'ania suria akwale'e farisi ma rua ai, ngaia 'e leka mai burina la Jisas, maka gema to'ona nigifana ruu tekwa aana. ");
INSERT INTO kwd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tofuna nga noni lo'oo ngaia 'e manata 'ilo'oo, “Lauta nau ku gema to'ona mola nga nigifana ruu ala Jisas, nau taku gwari'a no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Alata ngaia gema na nga nigifana ruu aana, la Jisas 'e abulo mai, maka agasia nga noni no'ona, maka fata 'ilo'oo fana, “'I'oo sia manata 'abelo la'u. 'I'oo gwari'a no'o, suria 'i'oo tagoto'o agu.” Ma nga alata no'ona la'u mola, nga fifiinga lo'oori ka sui no'o fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma alata la Jisas fe'enia nga fufu'iwane aana gila nigi na 'ifi na wane ba'ita laka'u, gila ka ru'u kau, ma gila ka agasia nga ta'a gila nguria nguu na kwaimanadainga, ma nga ta'a 'e aula la'u mola na'a gila ogu 'i no'ona, ma gila ka nagufia. ");
INSERT INTO kwd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma la Jisas ka fata 'ilo'oo fana ta'a no'ona, “Mooru te'efou lo'oo tamoru ru'u 'i maa. Wela geni lo'oo ngaia 'ame mae lo'oo, ngaia 'e eeno mola.” Alata gila longoa la Jisas ngaia 'e fata 'ilo'oo, gila ka 'osa mola 'ania. ");
INSERT INTO kwd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma 'i burina nga ta'a lo'oo gila leka fa'asia 'i maa, la Jisas 'e ru'u kau 'ubulana tofi 'ifi lo'oori, maka gema 'i nimana lari'i lo'oori, ma lari'i ka tata'e. ");
INSERT INTO kwd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Burina 'ola lo'oo la Jisas ngaia 'e agea, nga kwairiinga suria ka talofia no'o nga gule'e lefu no'ona te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Burina la Jisas ngaia 'e leka kau fa'asia lefu no'ona, nga rua wane maa gaa'a 'e logo gala leka suria la Jisas, ma gala ka o'omae, ma gala ka fata 'ilo'oo, “Wane na fufutanga ala Defete nga kiingi, 'oi manadai 'amee'e mai.” ");
INSERT INTO kwd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma nga alata la Jisas ngaia 'e ru'u 'i 'ubulana nga 'ifi, nga rua wane laka'u maa gaa'a 'e logo gala ka ru'u la'u mola 'i burina. Ma la Jisas ka fata 'ilo'oo fagaa'a, “'Ino'ona ma moo'o molo tagoto'o na 'inau ku to'omia fana 'aku gulaa nga maa moo'o?” Ma gala lamadu'aa ma gala ka fata 'ilo'oo, “Kiu, Alafa.” ");
INSERT INTO kwd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma la Jisas 'e gema na nga maa gaa'a, maka fata 'ilo'oo, “Tofuna na moo'o molo tagoto'o, nga 'ola lo'oori te'e lau kwala'imori no'o famoo'o.” ");
INSERT INTO kwd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma nga maa gaa'a ka aga no'o, ma la Jisas 'e fata tegela'a fagaa'a gala sia kwairii mola ai te'ana te'efuta wane. ");
INSERT INTO kwd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tafe'ua, alata gala ru'u kau 'i maa, gala ka alafuu no'o suria la Jisas te'ana ta'a na gala to'odariga 'ubulana gule'e lefu no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma alata rua wane laka'u gala ru'u kau, tani wane ngaa'i gila ngaria la'u mai te'e wane te'ana la Jisas, nga wane foka'ato, suria nga adalo ne'e bo'ea. ");
INSERT INTO kwd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma la Jisas 'e belote'enia adalo lo'oori fa'asia wane no'ona. Ma nga wane lo'oo ka alafuu no'o. Ma nga ta'a na gila ogu na alata no'ona, gila ka 'alefo ba'ita, ma gila ka fata 'ilo'oo, “Mai na'o, te'efuta wane 'ame agasia 'ua te'efuta 'ola 'ilo'oo na fanua 'i Israel!” ");
INSERT INTO kwd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tafe'ua ma ni Farasii, gila fata 'e'eo mola ala Jisas ma gila ka 'ilo'oo, “Wane ba'ita na adalo lo'oo ngaia 'e kwatea tegelangaa fana wane lo'oo 'ani belote'enia nga adalo lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma la Jisas ngaia 'e leka 'ubulana ni fanua ba'ita ma ni maa'e fanua sisika ngaa'i ma ngaia ka kwaifa'ananau 'ubulana 'ifi ni fo'anga aaga, maka foulange'enia nga Kwairiinga Le'a lo'oo suria ba'itangaa na God, maka gulaa ta'a na gila fii 'ania fiifinga kwaitatari te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Alata la Jisas ngaia 'e agasia nga ta'a lo'oo, ngaia 'e kwaimanadai ba'ita faga suria gila waata'uta'u, ma gila 'ame to'omia 'agila kwaibooni aga 'i talaga. Gila 'ilaka'u nga sifisifi na te'efuta wane 'amoe fana aganga suriga. ");
INSERT INTO kwd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma la Jisas ka fata 'ilo'oo fana fufu'iwane aana, “Nga ta'a lo'oo gila 'ilaka'u nga fufungu na 'ai ngaia 'e suka no'o 'ubulana langa'a ma gila ka aula 'e iiki. Tafe'ua ma ta'a ni taunga'inga fana talaiga te'ana God, gila 'ame aula. ");
INSERT INTO kwd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngai lo'oo, tamooru fo'a, ma moru ka soea God, wane ba'ita na taunga'inga lo'oo, fana 'ani kwatea mai ta'a ni taunga'inga 'agila talaiga te'ana.” ");
INSERT INTO kwd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","La Jisas 'e soea mai akwale'e wane ma ruaai aana te'ana, maka kwatea no'o tegelangaa faga fana belote'enilana nga adalo, ma fana nga gulalana nga fiifinga kwaitatari te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma nga latana nga akwale'e wane ma ruaai ni Kwairiinga aana ne'e 'ilo'oo: la Saemon (na gila fa'alataa la'u mola 'ania la Pita), ma nga wanefuta aana la Andru, ma la Jemes ma la Jon, rua wela ala Sebedi. ");
INSERT INTO kwd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ma la Filip, ma la Batolomiu, ma la Tomas, ma la Matiu, nga wane laka'u fana gonilana bata na takisi, ma la Jemes nga wela ala Alfeas, ma la Tadeas, ");
INSERT INTO kwd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma la Saemon, nga wane na fufu'i ta'a 'i Jiu na gila siria tarilana nga ta'a 'i Rom fa'asia 'i Israel, ma la Judas Iskariot nga wane laka'u 'e 'olonge'enia la Jisas fana marimae aana. ");
INSERT INTO kwd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma la Jisas ka alea no'o nga akwale'e wane ma ruaai ni Kwairiinga lo'oori, maka 'ilo'oo, “Mooru sia leka mola 'i laloana ta'a na 'ame Jiu, ma moru sia ru'u mola 'i 'ubulana fanua na ta'a 'i Samaria. ");
INSERT INTO kwd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Moru leka mola te'ana nga ta'a 'i Israel, na gila 'ilaka'u nga sifisifi na gila foo no'o. ");
INSERT INTO kwd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma alata mooru leka, tamooru kwairii 'ilo'oo, ‘Alata fana God 'ani ba'ita fafia ta'a aana, ngaia 'e galangia mooru no'o.’ ");
INSERT INTO kwd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma tamooru gulaa ta'a gila fii, ma tamooru tata'ea ta'a 'e mae, ma tamooru gulaa nga ta'a na kuu ngaia 'e ngadaga, ma tamoru belote'enia nga adalo. Tofuna mooru moru ngari tago mola ai, ngai lo'oo tamoru kwate tago la'u mola ai. ");
INSERT INTO kwd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Nga ta'a ni taunga'inga, ngaia to'omia nga ta'a 'agila aga suriga. Ngaia lo'oo, alata mooru leka, moru sia manata 'abelo mola fana daunga fafia nga bata. Ma moru sia ngaria mola nga wa'i. Ma moru sia ngaria mola rua me'e sote, 'amoe ma rua me'e butu, 'amoe ma ta fe'e kuba'u. ");
INSERT INTO kwd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma lauta moru nigi na te'efuta fanua, moru aga 'ofia te'efuta wane na ngaia te'e kwalo 'amooru fana 'i 'ubulana 'ifi aana. Ma moru nana'i fe'enia wane no'ona leleka maka nigi na alata 'amoru leka fa'asia maa'e fanua no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma alata 'amooru ru'u 'i 'ubulana te'efuta 'ifi, tamoru fata 'ilo'oo fana ta'a na gila nana'i no'ona, ‘God 'e nanamate'eni 'amooru, ma nga aloalonga aana 'e nana'i fe'enia mooru 'i 'ubulana nga 'ifi lo'oori.’ ");
INSERT INTO kwd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lauta nga ta'a 'ubulana 'ifi no'ona gila kwalo 'amooru, nga nanamanga amooru te'e nana'i la'u mola fe'eniga. Ma lauta 'amoe, ma nga nanamanga lo'oori te'e ori mola mai famooru. ");
INSERT INTO kwd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma lauta moru nigi na te'efuta fanua, ma te'efuta wane 'ame 'uri no'o fana kwalo lamooru, 'amoe ma gila ka ma'asiri fana longolana fata lamooru, moru leka fa'asia nga lefu no'ona. Ma alata moru leka fa'asia, tamoru tafula wado fa'asia 'a'ae mooru 'ilaka'u nga fa'abasuanga no'o faga na God te'e sufaga. ");
INSERT INTO kwd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma nau ku iiria nga 'ola kwala'imori famooru, na nga gani na God te'e sufaa nga fanua lo'oo 'i wado, nga kwa'ikwa'inga na ngaia te'e kwatea fana ta'a no'ona te'e ba'ita maka riufia kwa'ikwa'inga na God 'e kwatea fana ta'a 'e ria laka'u gila nana'i na rua maa'e fanua laka'u 'i Sodom ma 'i Gomora.” ");
INSERT INTO kwd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma la Jisas ka alafuu 'ilo'oo, “Moru gwalongo le'a, nau ku ale 'amooru fana 'amoru leka no'o 'ilaka'u nga sifisifi te'ana ta'a 'e ria na gila 'ilaka'u nga ku'ito kwasi na gila siria ngada lamooru. Ngaia lo'oo, moru aga aga le'a, ma moru sia agea mola te'efuta 'ola 'e ria na tagila fata fafi 'amooru tofuna. ");
INSERT INTO kwd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Moru aga suri 'amooru, tofuna tani ta'a ngaa'i tagila gemasi 'amooru tofuna moru tagoto'o agu, ma tagila talai 'amooru te'ana ta'a ni kwaisufaingaa, ma tagila labusi 'amooru 'ubulana 'ifi ni fo'anga aaga. ");
INSERT INTO kwd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tofuna moru leka suri nau, tagila tala 'amooru te'ana ta'a na'ona'o ma nga wane ba'ita aaga fana 'agila malate'ote'o amooru. Ma alata gila agea 'ilo'oo, tamoru kwairii 'ania nga Kwairiinga Le'a lo'oo te'aga ma fana ta'a na gila 'ame Jiu. ");
INSERT INTO kwd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Alata gila ngari 'amooru 'i na'ona wane ni kwaisufaingaa, moru sia manata 'abelo mola fana te'efuta alafuunga na tamoru iiria ma tamoru alafuu 'uta'i 'ania, tofuna God no'o te'e kwatea alafuunga famooru fana iirilai na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma moru sia alafuu mola 'i talamooru. Nga Anoe 'ola na God nga Mama'a amooru 'i Langi na te'e fa'afata 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ta'a 'e aula tagila ngaria wane ni futanga aga na gila tagoto'o agu fana ta'a fana 'agila kwa'iga. Ma ta'a 'e aula la'u mola, tagila agea 'ilo'oo na ni wela aaga na gila tagoto'o agu. Ma ni wela 'e aula la'u mola, tagila marimae no'o na mama'a ma tete'e aaga, ma tagila ngariga te'ana ta'a fana kwa'ilaga. ");
INSERT INTO kwd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nga ta'a 'e aula, tagila aga mani amooru tofuna mooru nga fufu'iwane agu. Ma ni dai ne'e tagoto'o 'e ngasi, leleka maka nigi na 'isilana alata na 'ato'atolanga, God te'e fa'amooria. ");
INSERT INTO kwd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lauta ta'a na nga fanua gila malate'ote'o amooru, moru 'akwa fa'asia maa'e fanua no'ona 'aferu, ma tamooru leka la'u fana nga fanua matari ngaa'i. Nau ku iiria famooru, 'ato 'amoru fa'asuia no'o nga taunga'inga amooru na maa'e fanua 'i Israel, 'i na'ogu nga Wela na Wane, nau 'aku ori la'u mai. ");
INSERT INTO kwd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nga wane na ngaia 'e nanau 'ola mola, ngaia 'e 'ato 'ani riufia nga wane ne'e fa'ananaua. Ma nga wane ni taunga'inga ngaia 'ame ba'ita riufia nga wane ba'ita aana. ");
INSERT INTO kwd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ngaia 'e le'a fana wane ni nanau 'olanga 'ani 'ilaka'u nga wane ni kwaifa'ananaunga aana. Ma nga 'ola lo'oo gila agea ana wane ba'ita, tagila agea la'u mola na wane ni taunga'inga aana. Ma lauta 'inau, nga wane ba'ita amooru, gila iiri nau 'ania la Saetan nga wane ba'ita na adalo, tagila fa'alata 'amooru 'ania nga lata'e 'ola ne'e ria 'e iiki la'u.” ");
INSERT INTO kwd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","La Jisas 'e fata la'u fana nga fufu'iwane aana maka 'ilo'oo, “Mooru sia ma'unge'enia mola nga wane. 'Ola te'efou ne'e nagwa, God te'e faate'enia. Ma nga 'ola nagwa nagwa te'efou, ta'a tagila su'aai. ");
INSERT INTO kwd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma nga 'ola na nau ku iiria famooru 'i 'ubulana nga logo, tamoru iiria la'u mola na dalotooto'o na gani. Ma 'ola na nau ku kwalanguru 'ania famooru, tamoru fata wataga 'ania fana nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma moru sia ma'unge'enia mola nga ta'a na gila su'asuria 'agila kwa'ia mola nga noni mooru 'ani mae, ma ngaia 'ato fana 'agila kwa'ia nga mango'e 'ola. Moru ma'unge'enia no'o God, tofuna ngaia 'e to'o na nga tegelangaa fana ngadalana nga mango'e 'ola ma nga noni 'ola 'ubulana nga lefu na eele 'e nunula ai ma 'e sia mae la'u. ");
INSERT INTO kwd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ni me'e suba sisika lo'oo, gwa'a ngaia 'ame taringa'i, ngaia 'ato no'o fana me'e suba 'ani 'esia 'i wado lauta nga Mama'a amooru 'i Langi ngaia 'ame alamia. ");
INSERT INTO kwd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma 'i 'amooru, God ngaia 'e su'a te'efou no'o na ifu mooru. ");
INSERT INTO kwd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ngaia lo'oo moru sia ma'u mola, tofuna God ngaia 'e manata ba'ita na wane 'e riufia nga me'e suba sisika lo'oo! ");
INSERT INTO kwd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ma ni dai ne'e foule'eni nau 'i na'ona ta'a na ngaia nga wane ni lekanga 'i burigu, 'inau taku foule'enia la'u mola te'ana nga Mama'a agu 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ni dai ne'e gwala nau 'i maana ta'a, nau taku gwalaa la'u mola te'ana nga Mama'a agu 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma la Jisas ka fata 'ilo'oo la'u, “Moru sia madafia mola iiria nau ku leka mai fe'enia nga aloalonga fana fanua lo'oo 'i wado. Nau ku 'ame ngaria no'o mai aloalonga. Nau ku leka mai fana ngarilana mai kwaitatari'anga. ");
INSERT INTO kwd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nga ta'a alakwa, tagila funu fe'enia mama'a aaga. Ma ni geni lari'i, tagila funu fe'enia tete'e aaga. Ma nga geni ne'e baiwane mai, tagila funu fe'enia fungoga geni. ");
INSERT INTO kwd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nga marimae na wane, na nga ta'a na fufutalaa aana 'i talana. ");
INSERT INTO kwd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma ni dai ne'e kwaimaa fana ma'a aana ma nga tete'e aana 'e riufi nau, ngaia 'ame to'omia 'ani leka suri nau. Ma ni dai ne'e kwaimaa fana nga wela aana 'e riufi nau, ngaia 'ame to'omia 'ani leka suri nau. ");
INSERT INTO kwd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma ngaia 'e 'ato fana te'efuta wane 'ani lau na wane na fufu'iwane agu, lauta ngaia 'ame 'uri fana 'ani leka suri nau, gwa'a ngaia 'ani nonifii, ma ka mae na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma ni dai ne'e ma'asiri 'ani leka suri nau tofuna ngaia 'e siria 'ani agea mola 'ola suria kwaisiriinga aana 'i talana, ngaia te'e talafia nga mooringa firi lo'oo. Tafe'ua ni dai na ngaia 'ame agea 'ola suria kwaisiriinga aana 'i talana, ma ngaia ka 'uri fana 'ani mae tofuna ngaia 'e leka suri nau, ngaia te'e to'o na mooringa firi.” ");
INSERT INTO kwd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma ni dai na ngaia 'e kwalo 'amooru, ngaia 'e kwalo nau la'u mola. Ma ni dai ne'e kwalo nau, ngaia 'e kwaloa la'u mola God na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ni dai ne'e kwaloa nga profet, tofuna nga wane no'ona ngaia 'e taunga'i fana God, ngaia te'e ngaria nga foforinga 'ilaka'u la'u mola nga foforinga na'a God te'e kwatea fana nga profet. Ma ni dai ne'e kwaloa nga wane 'e odo, suria nga wane no'ona ngaia 'e odo, ngaia te'e ngaria no'o foforinga 'ilaka'u nga wane 'e odo. ");
INSERT INTO kwd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mai nau ku iiria 'ola 'e kwala'imori famooru, lauta te'efuta wane 'e kwatea maa'e ka'o gwari fana te'efuta wane agu tofuna ngaia nga wane na fufu'iwane agu, ngaia te'e ngaria la'u mola nga susuganga.” ");
INSERT INTO kwd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Alata la Jisas ngaia 'e alafuu fana nga akwale'e wane ma ruaai na fufu'iwane aana 'e sui, ngaia 'e leka la'u fana 'ani kwairii 'ania Kwairiinga Le'a lo'oo ma ka fa'ananaua ta'a na maa'e fanua 'afuia 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nga alata no'ona la Jon wane ni naruabunga ngaia 'e nana'i 'ubulana nga 'ifi na lokafu, ma ngaia 'e longo suria nga taunga'inga lo'oo la Jisas Kraes ngaia 'e agea, ma ngaia ka alea tani wane na fufu'iwane aana 'agila leka te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma gila orisia, ma gila ka fata 'ilo'oo, “'Oi kwairii mai te'ameeru. 'Ilo'oo ma 'i'oo no'o nga Kraes na profet 'e iiria te'e nigi mai, 'amoe ma 'ameeru mamania la'u nga wane matari?” ");
INSERT INTO kwd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma la Jisas 'e lamadu'aga maka 'ilo'oo, “Moru ori, ma moru ka kwairii te'ala Jon 'ania ni 'ola na moru longoa ma moru ka agasia. ");
INSERT INTO kwd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nga ta'a na maaga 'e logo, gila aga no'o. Ma nga ta'a na 'a'aega 'e mae, gila ka leka la'u mola. Ma nga ta'a na kuu 'e ngadaga, gila ka gwari'a no'o. Ma nga ta'a na aringaga 'e boko, gila ka longo la'u mola. Ma nga ta'a na gila mae no'o, gila ka moori la'u mola. Ma nga Kwairiinga Le'a lo'oo laka'u, nau ku alafuu no'o suria fana ta'a 'e galafa'a. ");
INSERT INTO kwd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nga aile'anga fana ni dai ne'e 'ame manata ruarua 'ani nau.” ");
INSERT INTO kwd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Alata na nga fufu'iwane ala Jon gila ori no'o, la Jisas ka fata suria la Jon fana nga oguogunga no'ona, maka 'ilo'oo, “Na nga alata moru leka te'ala Jon 'ubulana gule'e lefu kwasi, ni dai lo'oo moru leka fana agasilana no'ona? Nga wane na manatanga ana 'ame ngasi 'e 'ilaka'u mola nga lage na ngaia 'e 'asu'asu kwairiu na iru? 'Amoe! La Jon ngaia wane 'ino'ona mola 'amoe. ");
INSERT INTO kwd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Ilo'oo ma, ni dai na moru leka fana agasilana? Nga wane na ngaia 'e ru'ufia ruu na forilana 'e ba'ita? 'Amoe! Tofuna ta'a na gila rufi 'ilo'oo, gila nana'i mola 'i 'ubulana 'ifi na wane ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Moru kwairii mai te'agu. Ni dai na moru leka kau fana agasilana? Nga profet? Kiu! Ngaia nga profet kwala'imori la'u mola! Ma ngaia 'e riufia la'u ni profet te'efou mai na'o. ");
INSERT INTO kwd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","La Jon lo'oo laka'u gila giri suria 'ubulana Girigiringa Abu na alata God ngaia 'e alafuu fana nga Kraes maka 'ilo'oo, ‘Aga madi, nau taku kwatea nga wane ni ngari alafuunga agu 'i na'omu, fana ngaia 'ani sasari agau na tala famu.’ ");
INSERT INTO kwd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nau ku iiria 'ola kwala'imori famooru, la Jon ngaia 'e taringa'i maka riufia nga ta'a lo'oo te'efou na gila futa mai 'i fofona fanua lo'oo 'i wado. Ma gwa'a ngaia 'ino'ona, nga ta'a na gila sisika olofana ba'itangaa na God, gila ba'ita 'e iiki maka riufia la'u la Jon. ");
INSERT INTO kwd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aia, eta mai na alata la Jon ngaia 'e tala'ae fana kwairiinga 'ania Kwairiinga Le'a lo'oo leleka maka nigi tala'ina, nga ta'a 'e ria gila funuria foufounga na God, ma gila 'ame siria God 'ani ba'ita fafiga. ");
INSERT INTO kwd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nga Tagi ala Moses, ma nga profet lo'oo te'efou leleka maka nigi na alata ala Jon, gila fata foulange'enia mai suria nigilana mai nga Kraes. ");
INSERT INTO kwd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gila iiria la Elaeja nga profet te'e ori la'u mai 'i na'ona nga Kraes. Ma ngaia 'e le'a fana 'amooru tagoto'o na la Jon lo'oo ngaia la Elaeja laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngaia le'a fana 'amoru gwalongo le'a fana alafuunga lo'oo agu.” ");
INSERT INTO kwd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma la Jisas ka fata 'ilo'oo faga, “Nau 'akui fa'atooto'ome'enia famooru nga nana'i lamooru ta'a lo'oo tala'ina, mooru 'ilaka'u nga ru'uru'ua sisita na gila ogu 'i maana uusi'a na rua oguogunga. Ma gila ka o'omae kwairiu fafiga, ");
INSERT INTO kwd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Meru furu'ia 'au, ma moru 'ame wa'e mola suria. Ma meru ka nguria nga me'e nguu na kwaimanadainga famooru, ma moru 'ame kwaimanadai mola.’ ");
INSERT INTO kwd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nau ku iiria ni 'ola lo'oo tofuna alata la Jon wane ni Naruabunga ngaia 'e nigi mai, ngaia 'e abu keto, ma ngaia 'ame go'ufia te'efuta waen, ma moru ka iiria ngaia 'e to'o na adalo. ");
INSERT INTO kwd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tafe'ua, na alata 'inau, nga Wela na Wane, nau ku nigi mai, nau ku keto, mai nau ku go'u fe'enia ta'a, ma moru ka fata la'u mola 'ilo'oo, ‘Moru agasia! Ngaia 'e keto 'e ba'ita, maka go'u ba'ita na waen, ma ngaia ka kwaimaa fe'enia ta'a na gila gonia bata na takisi ma ta'a abulolaga 'e ria la'u mola.’ Tafe'ua, ta'a lo'oo gila lo'o suria nga su'a'ola na God, ma gila faate'enia na God ngaia 'e kwala'imori.” ");
INSERT INTO kwd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Burina la Jisas 'e fata 'ilo'oo 'e sui, ngaia 'e tala'ae maka iila fana ta'a na maa'e fanua laka'u ngaia 'e agea mai ni 'ola ni 'alefosilai aula ai, suria ta'a na maa'e fanua no'ona gila 'ame siria bulota'inga mai fa'asia rianga aaga. ");
INSERT INTO kwd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","La Jisas ngaia 'e fata 'ilo'oo, “Ngaia te'e ria 'e iiki famooru lo'oo moru nana'i 'i Koresin. Ma 'amooru na moru nana'i 'i Betsaeda la'u mola. To'omia 'amoru tagoto'o na ni 'ola ni 'alefosilai aula laka'u nau ku agea famooru. Lauta gila agea 'ola ni 'alefosilai lo'oori 'i Taea ma 'i Saedon 'i na'o, nga ta'a no'ona tagila to'oru 'i wado, ma tagila ru'ufia ruu biribiri'a aaga, ma tagila bunia noniga 'ania makola, fana 'ani faate'enia na gila bulota'i mai te'efou no'o fa'asia rianga aaga. ");
INSERT INTO kwd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Ola kwala'imori lo'oo nau ku iiria famooru, na nga gani na God 'ani kwaisufai na ta'a na fanua lo'oo 'i wado, nga kwa'ikwa'inga amooru te'e ria maka riufia nga kwa'ikwa'inga na ta'a 'i Taea fe'enia 'i Saedon. ");
INSERT INTO kwd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Mai 'amooru nga ta'a lo'oo 'i Kapaneam, moru madafia God te'e lafua amooru fani Langi. Tafe'ua ma, ngaia te'e 'ui la'u mola 'ania mooru 'i 'ubulana kiru na kwa'ikwa'inga. Suria ni 'ola ni 'alefosilai laka'u nau ku agea na maa'e fanua amooru, lauta nau 'aku agea mai 'ilo'oo 'i Sodom, nga ta'a lo'oo 'i Sodom bala tagila bulota'i mola mai, ma God 'e sia ngadaa mola fanua aaga. ");
INSERT INTO kwd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngaia lo'oo, nau ku iiria famooru, na fe'e gani lo'oo God te'e sufaa nga ta'a na fanua lo'oo 'i wado, nga kwa'ikwa'inga amooru te'e iiki maka riufia nga kwa'ikwa'inga na ta'a 'i Sodom. ");
INSERT INTO kwd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nga alata no'ona la'u mola, la Jisas 'e fo'a maka fata 'ilo'oo, “Ma'ana, 'i'oo na 'i'oo ba'ita fafia ni 'ola lo'oo te'efou 'i Langi ma 'i wado la'u mola. Nau ku tafe'o, tofuna na 'i'oo faate'enia ni 'ola lo'oo fana ta'a na gila 'ilaka'u ru'uru'ua sisika, moko na'agonia 'ola lo'oo fa'asia ta'a na gila tafega 'i talaga tofuna gila su'a'ola, ma gila ka su'ana ni 'ola 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kiu Mama'a, ni 'ola lo'oo ngaia 'e 'ilo'oo no'o suria nga kwaisiriinga amu 'ua no'o mai 'i na'o.” ");
INSERT INTO kwd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma la Jisas 'e fata 'ilo'oo fana nga oguogunga lo'oori, “Mama'a agu ngaia 'e kwatea no'o ni 'ola te'efou fagu. Ma te'e 'i ngaia na nga Mama'a na ngaia 'e su'a agu nga Wela aana. Ma te'e 'i ngaia no'o na Wela momola na ngaia 'e su'ana Mama'a aana, ma te'e ta'a na nga Wela aana 'e firiga fana faate'enilai faga, na gila su'ana nga Mama'a. ");
INSERT INTO kwd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Leka mai te'agu, ta'a moru kweo ma moru to'o na a'arigelonga. Ma 'inau taku kwatea mamalongaa famooru. ");
INSERT INTO kwd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma tamoru lo'o suria nau, mai nau taku fa'ananau 'amooru, suria nga falafala agu lo'oo 'e malofi'a maka aloalo, ma tamoru to'odaria nga mamalongaa fana nga mango mooru. ");
INSERT INTO kwd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tofuna nga kwaitalainga agu famooru, ngaia 'e wada'u fana lekanga 'i suria, mai nau ku 'ame kwatea a'arigelo famooru.” ");
INSERT INTO kwd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma na alata no'ona, na te'e Sabat, la Jisas fe'enia nga fufu'iwane aana gila leka, ma gila ka olofolo na nga langa'a na witi, nga 'ola gila launge'enia fana beret. Ma nga alata no'ona, nga fufu'iwane aana gila molo'u, ma gila ka fisua fufungui 'ola ai, ma gila ka 'ania. ");
INSERT INTO kwd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma tani ta'a na Farasii gila agasiga. Ma gila ka iila fala Jisas ma gila fata 'ilo'oo, “'I'oo agasia! Nga 'ola lo'oo fufu'iwane amu gila agea, ngaia 'e mousia nga tagi ala Moses, tofuna gila agea taunga'inga na gonilana witi na Sabat, gani na mamalonga.” ");
INSERT INTO kwd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Nau ku su'aai mooru moru idumia 'ubulana Girigiringa Abu nga 'ola laka'u la Defete nga kiingi ngaia 'e agea 'i na'o. Nga alata no'ona, la Defete fe'enia ni wane aana gila molo'u 'e iiki, ");
INSERT INTO kwd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ma ngaia ka leka 'i 'ubulana nga 'Ifi Abu na God, ma nga fataabu ba'ita ka kwatea nga beret na gila fa'aabua fana God fana la Defete. Ma la Defete 'e 'ania nga beret no'ona, maka kwatea la'u mola gula ngaa'i fana ni wane aana, ma gila ka 'ania no'o. Tafe'ua ma tagi adauru ngaia 'e alamia mola te'e fataabu na God na tagila 'ania. Mai dauru goru 'ame agasia mola 'ubulana Girigiringa Abu na God ngaia 'e ogaria fala Defete.” ");
INSERT INTO kwd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma la Jisas ka alafuu 'ilo'oo la'u, “Nau ku su'aai mooru moru idumia 'ubulana Girigiringa Abu, nga tagi suria fataabu laka'u gila taunga'i 'ubulana 'Ifi Abu na God na Sabat. Gwa'a gila taunga'i, ma God 'ame sufaga mola. ");
INSERT INTO kwd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aia, 'inau ku iiria famooru, te'e wane lo'oo ngai no'o fe'enia 'amooru na'a ngaia 'e ba'ita maka iiki riufia nga 'Ifi Abu na God, ma 'inau lo'oo no'o fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kiu, God ngaia 'e alafuu 'ilo'oo, ‘Nau ku siria amooru kwaimanadai fana ta'a, ma nga tabonga amooru 'amoe.’ Ma lauta 'amoru su'asuria fa'awatagalana nga 'ola lo'oo, ngaia 'ato no'o fana 'amoru sufaa ni wane lo'oo agu, tofuna gila 'ame kuta lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tofuna 'inau, nga Wela na Wane, nau ku to'o na nga tegelangaa fana iirilana nga 'ola fana ta'a 'agila agea na gani na mamalonga.” ");
INSERT INTO kwd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma alata la Jisas ngaia 'e leka fa'asia nga lefu no'ona, ngaia 'e leka 'ubulana te'e 'ifi ni fo'anga. ");
INSERT INTO kwd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma te'e wane nimana 'e mae 'e nana'i la'u mola 'ubulana 'ifi ni fo'anga no'ona. Ma tani wane aaga gila orisia la Jisas ma gila ka 'ilo'oo, “'Ino'ona ma ngaia 'e to'omia mola fana gulalana wane na Sabat, nga gani na mamalongaa?” Gila kwaiorisi 'ilo'oo fana 'agila to'odaria te'efuta 'ola fana fatanga fafia la Jisas na mousilana tagi na God na gulanga, nga 'ola lo'oori gila manata suria ngaia 'e 'ilaka'u taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","La Jisas 'e orisiga la'u maka 'ilo'oo, “Moru kwairii madi mai te'agu, lauta te'efuta wane amooru, nga sifisifi aana 'e 'esia 'ubulana nga kiru na Sabat, 'ilo'oo ma ngaia 'e sia leka mola 'ani lafua fa'asia nga kiru? ");
INSERT INTO kwd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mooru moru su'aai, God 'e agasia ta'a na gila taringa'i 'e riufia nga sifisifi. Ngaia lo'oo, ngaia 'ame kuta no'o fana agelana nga 'ola le'a fana boonilana te'efuta wane na Sabat.” ");
INSERT INTO kwd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na nga alata no'ona mola, la Jisas ka fata 'ilo'oo fana wane na nimana 'e mae, “'Oi tagwala mai nimamu.” Ma wane no'ona 'e tagwala nga nimana. Ma nga alata no'ona mola, nga nimana laka'u 'e mae ka le'a no'o 'ilaka'u ruana nima le'a ana. ");
INSERT INTO kwd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma alata ni Farasii gila agasia nga 'ola lo'oo, gila ka ru'u te'efou 'i maa. Ma gila ka fadaa no'o fana kwa'ilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Alata la Jisas ngaia 'e longoa mola na gila fadaa fana kwa'ialana, ngaia ka leka no'o fa'asia fanua no'ona. Ma nga ta'a 'e auaula, gila ka leka suria la Jisas, ma ngaia ka gulaa ta'a 'e aula gila fii laloaga. ");
INSERT INTO kwd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma la Jisas ka fata ruiga gila sia alafuu mola suria te'ana te'efuta wane ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngaia 'e agea 'ilo'oo fana 'ani fa'ato'oa nga fatalana God laka'u la profet Aesea ngaia 'e iiria maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God 'e iiria, ‘Nga wane ni taunga'inga agu lo'oo, nau ku eefasia fana 'ani agea taunga'inga agu. Nau ku kwaimaa ba'ita fana, mai nau ku aile'a ba'ita fe'enia. Nau taku kwatea kau nga Anoe 'ola agu fana 'ani nana'i fe'enia. Aia, nga wane lo'oo ngaia te'e faate'enia la'u mola falafala 'e odo fana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngaia 'e sia nana'i mola 'ania orisu'usu'unga, ma 'e sia o'omae ba'ita mola, ma ngaia 'e sia fata ba'ita mola laloana fanua. ");
INSERT INTO kwd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma ngaia 'e sia rugasia mola nga ta'a galafa ma ta'a na gila waata'uta'u. Ma ngaia te'e kwaimanadai fana ta'a na gila 'ame to'omia 'agila kwaibooni aga 'i talaga. Ma ngaia te'e 'ino'ona leleka ma ta'a te'efou gila ka agea 'ola 'e odo. ");
INSERT INTO kwd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nga wane lo'oo, ta'a 'e aula fa'asia nga fanua te'efou, tagila fito'o ana.’ ");
INSERT INTO kwd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Burina, tani wane ngaa'i gila ngaria mai te'e wane te'ala Jisas fana gulalana. Wane lo'oo, adalo ngaia 'e bo'ea, ma nga maana ka logo, ma fokana ka boko no'o. Ma la Jisas ka gulaa nga wane no'ona, ma ngaia ka aga maka fata no'o la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nga oguogunga no'ona gila ka 'alefo ba'ita, ma gila ka orisiga kwairiu ma gila ka 'ilo'oo, “'Ino'ona ma nga wane lo'oo ngaia na wane laka'u God ngaia 'e firia na te'e futa mai na fufutanga ala kiingi Defete?” ");
INSERT INTO kwd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma alata tani Farasii ngaa'i gila longoa nga 'ola lo'oo, gila ka fata 'ilo'oo, “Ngaia 'amoe lo'oo. La Jisas ngaia 'e belote'enia nga adalo 'ania tegelangaa ala Saetan nga 'inatana adalo.” ");
INSERT INTO kwd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma tofuna la Jisas ngaia 'e su'a mola na manatalaga, ngaia ka fata 'ilo'oo faga, “Lauta ta'a 'ubulana nga fanua ba'ita gila funuriga 'i talaga, nga fanua ba'ita no'ona te'e tagala'i no'o. Ma lauta te'efuta fanua, 'amoe ma wane ma nga noni ma nga ru'uru'ua agaa'a, gila funuriga 'i talaga, ngaia 'e 'ato no'o fana 'agila nana'i oguogu. ");
INSERT INTO kwd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma nga tegelangaa ala Saetan ne'e 'ilo'oo la'u mola. Lauta la Saetan 'ani funu fe'enia ta'a na gila leka suria, tagila tagala'i kwairiu no'o, ma tegelangaa aana te'e sui. ");
INSERT INTO kwd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Aia, mai moru iiria nau ku belote'enia adalo 'ania tegelangaa ala Saetan. Kwefu'uwane, ma tegelangaa ani dai lo'oo ni wane na fufu'iwane amooru gila belote'enia adalo 'ania? La Saetan? 'Amoe no'o! Fufu'iwane amooru talamooru tagila faate'enia na amooru moru kuta. ");
INSERT INTO kwd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Nau ku belote'enia adalo 'ania tegelangaa na God. Ma ngaia 'e faate'enia no'o famooru na nga ba'itangaa na God fafia ta'a, ngaia 'e galangi no'o mai te'amooru. ");
INSERT INTO kwd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aia, lauta te'efuta wane ngaia siria 'ani belote'enia nga adalo, wane no'ona furina 'ani tegela'a 'ani riufia la Saetan. 'E 'ilaka'u la'u mola lauta te'efuta wane lo'oo 'e siria 'ani ru'u 'ubulana 'ifi na wane tegela'a fana ngarilana 'ola aana. Ngaia furina 'ani tegela'a 'ani talariufia wane no'ona, fana 'ani wada'u fana gaulana wane tegela'a no'ona, sui ma ngaia te'e bi'i ngaria ni 'ola aana. ");
INSERT INTO kwd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Aia, ni dai na ngaia 'ame leka mai burigu, ngaia nga marimae agu. Ma ni dai na ngaia 'ame kwaibooni agu fana ogulana mai ta'a te'ana God, ngaia 'e tagale'eniga no'o fa'asia God. ");
INSERT INTO kwd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Suria ngaia 'e 'ilo'oo, nau ku iiria famooru, God 'e su'asuria 'ani 'olafanataa na 'ola 'e ria lo'oo te'efou na ta'a gila agea ma ni 'ola 'e ria gila iiria. Ma lauta te'efuta wane 'e fata ngada nau, nga Wela na Wane, God su'asuria 'ani 'olafanataa mola ana. Ma lauta te'efuta wane 'e fata ngadaa nga taunga'inga na Anoe 'ola Abu, 'ato no'o fana God 'ani 'olafanataa na wane no'ona, na nga alata lo'oo, 'amoe ma alata na ngaia mai na'o adauru.” ");
INSERT INTO kwd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","La Jisas 'e fata 'ilo'oo la'u, “Mooru moru su'aai lauta moru to'o na 'ai 'e le'a, nga lodona 'ola ai te'e le'a la'u mola. Ma lauta moru to'o na 'ai 'e ria, nga lodona 'ola ai te'e ria la'u mola. 'Ino'ona la'u mola nga wane. Suria ni 'ola 'e le'a leka mai fa'asia nga ta'a 'e le'a, ma 'ola 'e ria 'e leka mai fa'asia nga ta'a 'e ria. ");
INSERT INTO kwd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mooru 'ilaka'u no'o ru'uru'ua na nga waa! Ma 'e 'ato no'o 'amoru iiria te'efuta 'ola 'e le'a, suria nga manatangaa amooru ngaia 'e ria. 'Olataa na'a ngaia 'e nana'i 'ubulana manatangaa na wane, ngaia 'e faata'i mai na nga alafuunga aana. ");
INSERT INTO kwd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nga wane ne'e le'a, nga fatalana te'e le'a la'u mola. Ma nga wane ne'e ria, nga fatalana 'e ria la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nau ku iiria famooru, na nga alata na kwa'ikwa'inga, God te'e sufaa ta'a te'efou fofona fanua lo'oo 'i wado tofuna fata atanga na'a gila agea. ");
INSERT INTO kwd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma God te'e sufaa ta'a 'ania fatalaga 'i talaga. Lauta alafuunga na wane 'e le'a, God te'e foule'enia wane no'ona ngaia 'e odo. Ma lauta alafuunga na wane 'e ria, God te'e foule'enia nga wane no'ona ngaia 'e kuta.” ");
INSERT INTO kwd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui ma tani wane ni kwaifa'ananaunga na tagi ma tani Farasii ngaa'i, gila leka mai te'ala Jisas, ma gila ka fata 'ilo'oo fana, “Wane ni kwaifa'ananaunga, 'imeeru meru siria 'i'oo 'ani agea nga 'ola ni 'alefosilai, fana 'ani faate'enia kwala'imoringa na God lo'oo 'e kwate'o mai.” ");
INSERT INTO kwd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","La Jisas ka fata 'ilo'oo faga, “Mooru ta'a na alata lo'oo, mooru ta'a moru ria. Tofuna moru siria agasilana nga 'ola ni 'alefosilai, tafe'ua ma ngaia 'e 'ato famooru fana 'amoru agasia. Moru agasia mola nga 'ola ni 'alefosilai laka'u ngaia 'e lau fala Jona nga profet 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","La Jona laka'u 'e nana'i 'ubulana gwagwaalasu suria oru ma'e gani ma oru ma'e logo. Aia, ma 'inau, nga Wela na Wane, nau taku 'ino'ona la'u mola. Nau taku nana'i 'ubulana wado suria oru ma'e gani ma oru ma'e logo. ");
INSERT INTO kwd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma nga alata God 'ani sufaa ta'a, nga ta'a na gila nana'i 'i Ninifa, tagila tata'e fana 'agila fata suria nga kutanga amooru. Tagila agea 'ilo'oo, suria gila bulota'i no'o fa'asia nga rianga aaga, na alata la Jona 'e foulange'enia te'aga. Ma nga wane ngaia 'e ba'ita 'e riufia la Jona ngaia 'e nana'i no'o fe'eni 'amooru. Tafe'ua, moru 'ame bulota'i mola fa'asia nga rianga amooru. ");
INSERT INTO kwd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma nga alata God 'ani sufaa nga ta'a, nga noni ba'ita laka'u 'i Siba, ngaia te'e tata'e la'u mola fana alafuunga suria nga kutanga amooru. Nga noni lo'oo te'e agea 'ilo'oo, suria ngaia leka mai fa'asia fanua aana ne'e lalau 'e iiki la'u fana nga longolana funi'oonga ala Solomon nga kiingi. Ma nga wane ba'ita ne'e riufia la Solomon lo'oo ngaia 'e nana'i no'o fe'eni 'amooru. Tafe'ua, mai moru 'ame siria mola nga longonga fana.” ");
INSERT INTO kwd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","La Jisas ka fata 'ilo'oo la'u mola, “Alata gila belote'enia adalo 'ani leka fa'asia nga wane, ngaia te'e riu kwairiu 'ubulana lefu 'e kwasila, maka kwailo'ofia te'efuta lefu fana ngaia 'ani nana'i la'u ai. Ma lauta ngaia 'e kwailo maka 'ame daria, ");
INSERT INTO kwd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ngaia te'e manata 'ilo'oo, ‘Nau taku ori te'ana nga wane laka'u nau ku nana'i mai ana 'i na'o, ma kua leka mai fa'asia.’ Alata ngaia 'e ori, ngaia 'e agasia wane laka'u ngaia 'e 'ilaka'u 'ifi na gila fa'akwaria ma gila ka fa'aodoa no'o, ma ngaia 'e gwete mola. ");
INSERT INTO kwd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Alata ngaia 'e agasia ne'e 'ino'ona, ngaia te'e ori maka talaia la'u mai nga fiu adalo ne'e ria maka riufia 'i ngaia, 'agila leka mai, ma gila ka nana'i no'o 'i 'ubulana wane laka'u. Nga to'orunga ana wane lo'oori bi'i ria maka riufia no'o 'i na'o. Ma ngaia te'e 'ino'ona la'u mola famooru ta'a 'e ria na alata lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nga alata la Jisas ngaia 'e alafuu 'ua fana ta'a no'ona, tete'e aana fe'enia wane ni futa aana gila ka nigi mai. Ma gila ka ula mola 'i maa suria gila siria 'agila alafuu fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma te'e wane na ta'a no'ona ka fata 'ilo'oo fala Jisas, “Ni tete'e amu fe'enia wane ni futanga amu, gila ula mola mai 'i maa, ma gila siria 'agila alafuu fe'eni'o.” ");
INSERT INTO kwd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","La Jisas 'e lamadu'aa maka 'ilo'oo, “Ni dai na tete'e agu ma nga wane ni futanga agu?” ");
INSERT INTO kwd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nga alata no'ona, la Jisas 'e kwalange'enia nga fufu'iwane aana, maka fata 'ilo'oo, “Moru agasia madi. Gila lo'oo na gila 'ilaka'u nga tete'e agu ma nga wane ni futanga agu. ");
INSERT INTO kwd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Suria ni dai ne'e leka suria nga kwaisiriinga na Mama'a agu 'i Langi, ngaia na wane ni futanga agu, ma nga aasigu geni, ma nga tete'e agu.” ");
INSERT INTO kwd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na fe'e gani no'ona la'u mola, la Jisas 'e ru'u kau fa'asia 'ifi no'ona, maka leka 'i gegena nga asi, maka to'oru 'i wado fana kwaifa'ananaunga. ");
INSERT INTO kwd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma tofuna nga oguogunga no'ona 'e ba'ita 'e iiki na gila ogu 'afuia, ngaia 'e fane 'ubulana nga baru, maka nana'i 'i 'ubulai, ma nga ta'a no'ona gila ka ula kau 'i suria nga oone. ");
INSERT INTO kwd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sui ma ngaia ka kwairii te'aga na ni 'ola 'e aula 'ania alafuunga na tarifulaa maka 'ilo'oo, “Te'e wane ngaia 'e leka maka tagale'enia 'u'ui 'ola 'i 'ubulana langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma alata ngaia 'e tagale'enia 'u'ui 'ola no'ona, tani 'u'ui 'ola ngaa'i gila 'esia mola suria nga tala, ma nga langasi gila lofo mai, ma gila ka 'ania mola te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma tani 'u'ui 'ola ngaa'i gila ka 'esia mola na lefu 'e foula, lefu na wado 'ame ba'ita ai. Gila bila'o 'afe'aferu tofuna nga wado 'ame aula. ");
INSERT INTO kwd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma nga alata nga sina ngaia 'e tata'e mai, ngaia ka sinafia nga 'u'ui 'ola ne'e maamudu mola, ma gila ka mae la'u mola, suria nga 'umi'umina 'ola ai 'ame sifo to'o. ");
INSERT INTO kwd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma tani 'u'ui 'ola ngaa'i gila 'esiga 'i laloana nga kwalo 'abui, ma kwalo no'ona 'e gaua nga 'ai no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma tani 'u'ui 'ola ngaa'i la'u ngaia 'e 'esiga 'i 'ubulana nga wado to'o, ma alata gila bila'o mai, gila ka fungu 'ania lodona 'ola 'e aula. Ma tani 'ai ngaa'i gila ka fungu 'ania tangale'e lodo, ma tani 'ai ngaa'i gila fungu 'ania ono akwale'e lodo, ma tani 'ai ngaa'i la'u gila ka fungu 'ania oru akwale'e lodo.” ");
INSERT INTO kwd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma la Jisas ka fa'asuia fatalana maka 'ilo'oo, “Lauta te'efuta wane 'e siria 'ani su'a le'a na 'ola lo'oo, ngaia 'ani gwaalongo le'a mai.” ");
INSERT INTO kwd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nga fufu'iwane aana gila leka mai te'ana, ma gila ka orisia 'ilo'oo, “'Ola 'e fe'ua na 'i'oo alafuu fana nga ta'a 'ania tarifulaa?” ");
INSERT INTO kwd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","La Jisas 'e lamadu'aga maka 'ilo'oo, “Alata ne'e sui, God ngaia 'ame fa'awatagaa 'ua 'uta'i na ngaia te'e ba'ita fafia ta'a aana. Tafe'ua alata lo'oo, nga lalanga ngaia 'e nigi no'o famooru. Ma nga ta'a na gila nga fufu'iwane agu 'amoe, nau ku 'ame fa'awatagaa la'u mola faga.” ");
INSERT INTO kwd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ni dai ne'e leka suria nga su'a'olanga sisika na ngaia 'e to'o suria ba'itangaa na God, God te'e ruda gou ai fana, fana ngaia 'ani to'o na su'a'olanga 'e aula. Tafe'ua ni dai na ngaia 'ame leka suria nga su'a'olanga, nga su'a'olanga sisika ngaia 'e to'o ai suria ba'itangaa na God, God te'e orite'enia fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aia, 'inau ku alafuu faga 'ania alafuunga na tarifulaa, tofuna ta'a lo'oo gila agasia no'o ni 'ola nau ku agea, ma gila 'ame aga su'aai. Gila longoa no'o alafuulagu, ma gila 'ame su'a mola ai. ");
INSERT INTO kwd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ngaia 'ilo'oo fana 'ani fa'ato'oa nga alafuunga laka'u la Aesea nga profet ngaia 'e iiria 'i na'o laka'u 'e 'ilo'oo, ‘Tagila gwalongo, ma tagila gwalongo, ma gila 'ame longo su'aai mola ai. Ma tagila aga, ma gila ka aga, ma gila 'ame aga su'aai mola ai.’ ");
INSERT INTO kwd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tofuna nga manatalaga 'e ngasi 'e iiki, ma aringaga 'e boko, ma gila bokota la'u mola nga maaga. Lauta maaga 'e aga su'aai, ma aringaga 'e 'ulasi, ma nga manatalaga 'e su'ana fatalana God, bala gila bolota'i mai te'agu mai nau taku gulaga mola. ");
INSERT INTO kwd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma la Jisas ka fata 'ilo'oo, “Aile'anga famooru, tofuna moru agasia no'o taunga'inga nau ku agea, ma nga aringa mooru ka longoa no'o kwaifa'ananaunga agu. ");
INSERT INTO kwd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Ola kwala'imori nau ku iiria famooru, ni profet 'e aula, ma nga ta'a 'e odo mai na'o, gila siria agasilana ni 'ola lo'oo moru agasia, tafe'ua ma gila 'ame agasia. Ma gila siria la'u mola longolana ni 'ola lo'oo moru longoa, ma gila 'ame longoa no'o. ");
INSERT INTO kwd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Moru gwalongo fana nga fa'awatagalana tarifulaa lo'oo suria nga wane lo'oo 'e tagale'enia 'u'ui 'ola. ");
INSERT INTO kwd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nga ta'a na gila longoa nga alafuunga suria nga ba'itangaa na God, ma gila 'ame su'asuria, la Saetan 'e leka mai, maka lafua mola fatalana God fa'asia manatalaga. Gila 'ilaka'u nga 'u'ui 'ola ne'e 'esiga suria nga tala, ma nga langasi gila ka 'ania mola. ");
INSERT INTO kwd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma nga 'u'ui 'ola na gila 'esiga 'i fofona wado na ngaia 'e foula, ngaia 'e 'ilaka'u nga ta'a na gila longoa fatalana God, ma gila ka ngaria fe'enia nga aile'anga. ");
INSERT INTO kwd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tafe'ua fatalana God ngaia 'ame susuto'o mola 'ubulana manatalaga. Gila tagoto'o mola suria te'e alata sisika. Ma alata irito'onga ma nonifiinga 'e nigi mai tofuna gila tagoto'o, 'afe'aferu gila ka rugasia la'u mola nga tagoto'onga aga. ");
INSERT INTO kwd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma nga 'u'ui 'ola ngaa'i na gila 'esiga 'i laloana nga kwalo 'abui, ngaia 'e 'ilaka'u ta'a na gila longoa la'u mola nga fatalana God. Tafe'ua ma gila manata 'abelo suria ni 'ola fana mooringa aaga, ma gila ka manata ba'ita na nga bata. Ma ni 'ola lo'oo, ngaia 'e 'ilaka'u nga kwalo 'abui ngaia 'e nunufia nga fatalana God 'ubulana manataga. Gila 'ame bulosia no'o 'ubulana manatalaga 'ilaka'u nga 'ai na ngaia 'ame fungu no'o 'ania te'efuta lode 'ola. ");
INSERT INTO kwd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma tani ta'a ngaa'i la'u na gila 'ilaka'u nga 'u'ui 'ola na gila 'esiga 'i 'ubulana nga wado le'a. Gila longoa fatalana God, ma gila ka su'asuria ni 'ola 'e le'a 'e aula ne'e leka mai fa'asia fatalana God ne'e nana'i 'ubulana manatalaga. Gila 'ilaka'u 'ai na ngaia 'e fungu 'ania lode 'ola. Tani 'ai ngaa'i ngaia 'e fungu 'ania tangale'e lode 'ola, ma tani 'ai ngaa'i nga ono akwale'e lode 'ola, ma tani 'ai ngaa'i oru akwale'e lode 'ola.” ");
INSERT INTO kwd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","La Jisas ka iiria la'u te'e tarifulaa faga, maka 'ilo'oo, “Nga ba'itangaa na God 'e 'ilaka'u nga wane ngaia 'e kirua nga 'u'ui 'ola 'e le'a 'ubulana nga langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na logo, alata nga ta'a gila eeno, nga marimae 'e leka mai maka kirua tani 'u'ui 'ola na 'ai 'e ria 'i laloana nga 'u'ui 'ola le'a lo'oo. Sui ma ngaia ka leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma alata nga 'u'ui 'ola le'a lo'oo gila bila'o mai, ma gila ka fungu 'ania lode 'ai le'a, nga 'u'ui 'ola na 'ai 'e ria laka'u gila ka bila'o la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ni wane ni taunga'inga aana, gila ka leka mai te'ana, ma gila ka orisia 'ilo'oo, ‘Welakau, 'i'oo kirua nga 'u'ui 'ola le'a laka'u. Ma nga 'u'ui 'ola na 'ai 'e ria loko'u, ngaia 'e leka la'u mai fa'asia 'i fai?’ ");
INSERT INTO kwd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma ngaia ka lamadu'aga maka 'ilo'oo, ‘Nga marimae no'ona 'e agea nga 'ola lo'oo.’ Ma ni wane ni taunga'inga aana, gila ka orisia 'ilo'oo, ‘'I'oo siria 'ameru leka 'ameeru lafua nga 'ai le'e ria lo'oo?’ ");
INSERT INTO kwd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngaia 'e lamadu'aga maka 'ilo'oo, ‘'Amoe, fa'asia nga alata moru lafua nga 'ai ne'e ria no'ona, ma moru ta ngadaa la'u mola nga 'ai ne'e le'a lo'oo fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Moru arua 'agala tata'e oguogu no'o kau leleka maka nigi na alata na goni 'olanga. Ma nga alata no'ona, nau taku iiria fana nga ta'a na 'agila gonia ni 'ola agu, ma taku 'ilo'oo: Moru lafua nga 'ai ne'e ria 'i na'o, ma tamooru gau sakusaku ai, ma tamoru do'ofia. Sui ma tamooru bi'i lafua nga 'ai 'e le'a lo'oo, ma tamooru ngaria mai fana 'ubulana 'ifi ni goni'olanga agu.’” ");
INSERT INTO kwd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui ma la Jisas ka iiria te'e tarifulaa la'u maka 'ilo'oo, “Nga ba'itangaa na God ngaia 'ilo'oo: Te'e wane ngaia 'e ngaria 'u'ui 'ola sisika le'a lo'oo na gila fa'alataa 'ania mastad, maka kirua 'i 'ubulana nga langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma gwa'a nga 'u'ui 'ola lo'oori 'e sisika riufia no'o na afiringa 'u'ui 'ola, alata ngaia 'e tata'e mai, ngaia te'e ba'ita maka talariufia no'o nga 'ai te'efou 'i 'ubulana nga langa'a lo'oo. Ma alata nga 'ai no'ona 'e ba'ita maka abalolonga'a, nga langasi tagila launge'enia nga nuu'i aaga na laloana 'ai no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui ma la Jisas ka fata la'u mola 'ania nga tarifulaa maka 'ilo'oo, “Nga ba'itangaa na God ngaia 'e 'ilaka'u nga iist sisika fana fa'afanelana beret, na noni 'e ngaria, ma ka dolaa fe'enia nga flaoa 'e aula, leleka maka fane te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","La Jisas furifuri ngaia 'e alafuu suria nga 'ola lo'oo te'efou 'ania nga tarifulaa fana nga oguogunga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngaia 'e agea 'ilo'oo fana 'ani fa'ato'oa nga fatalana God na nga profet laka'u 'e giria ne'e 'ilo'oo, “Nau taku alafuu 'ania tarifulaa fana ta'a. Ma nau taku fa'awatagaa nga 'ola na 'e nagwa 'ita no'o mai na alata nau ku launge'enia nga fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui ma la Jisas ka 'akwasia no'o oguogunga no'ona maka ru'u 'ubulana 'ifi. Ma nga fufu'iwane aana gila ka leka te'ana, ma gila ka fata 'ilo'oo, “'Oi fa'awatagaa madi fameeru nga tarifulaa laka'u suria nga 'ai ne'e ria laka'u 'ubulana nga langa'a.” ");
INSERT INTO kwd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ngaia 'e lamadu'aga maka 'ilo'oo, “Nga wane lo'oo ngaia 'e kirua nga 'u'ui 'ola le'a lo'oo, na 'inau, nga Wela na Wane. ");
INSERT INTO kwd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma nga langa'a lo'oo na fanua lo'oo 'i wado, ma nga 'u'ui 'ola le'a lo'oo na nga ta'a na God na gila nana'i olofana ba'itangaa ana. Ma nga 'ai ne'e ria lo'oori na nga ta'a gila lo'o suria la Saetan. ");
INSERT INTO kwd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma nga marimae na ngaia 'e kirua nga 'ai ne'e ria lo'oo na la Saetan. Ma alata na goni 'olanga na 'ita'ilana nga fanua lo'oo 'i wado, ma nga ta'a na gila goni'ola na nga enselo. ");
INSERT INTO kwd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Alata nga ta'a ni taunga'inga gila gonia nga 'ai ne'e ria, ma gila ka do'ofia 'i 'ubulana nga eele, ngaia 'e 'ilaka'u no'o nga 'ita'ilana nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nau taku kwatea enselo, ma tagila gonia ta'a te'efou na gila agea ni 'ola 'e ria, ma nga ta'a na gila fa'akutaa nga ta'a, ma nga enselo tagila lafuga fa'asia nga foufounga agu. ");
INSERT INTO kwd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma tagila 'ui 'aniga 'i 'ubulana eele, lefu na tagila aani, ma gila girigiri nifo ai. ");
INSERT INTO kwd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aia, ma nga ta'a na gila odo, tagila lala 'ilaka'u nga sisina 'ubulana nga foufounga na Mama'a aaga. Lauta te'efuta wane 'e siria 'ani su'a le'a na 'ola lo'oo, ngaia 'ani gwaalongo le'a mai.” ");
INSERT INTO kwd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","La Jisas 'e fata la'u mola 'ilo'oo fana nga fufu'iwane aana, “Nga ba'itangaa na God ngaia 'e 'ilaka'u nga bata ba'ita na gila na'agonia 'ubulana nga langa'a. Ma alata te'e wane 'e to'odaria, ngaia ka na'agonia la'u mola. Ma ngaia ka aile'a ba'ita, ma ngaia 'e leka maka fa'afori 'ania ni 'ola aana te'efou, maka foria nga langa'a lo'oori, fana 'ani ngari nga bata ba'ita lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma nga ba'itangaa na God ngaia 'e 'ilaka'u la'u mola nga wane ni foringa na ngaia 'e kwailo'ofia nga fou iloilo'a le'a na forilai 'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Alata ngaia 'e to'odaria nga fou iloilo'a na forilai 'e iiki, ngaia 'e leka, maka fa'afori 'ania ni 'ola aana te'efou, maka foria no'o nga fou lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nga foufounga na God ngaia 'e 'ilaka'u la'u mola nga fulai na gila dee 'ania 'i 'ubulana nga asi, ma gila ka deea 'ania ta'ita'ina ii'a kwaitatari te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma alata ngaia 'e fonu, nga ta'a na gila dee gila lakwa'enia 'i su'e, ma gila ka to'oru 'i wado fana 'agila to'ole'enia ii'a. Gila ka gonia no'o ii'a le'a fana 'ubulana kukudu, ma gila ka to'osia nga ii'a 'e ria. ");
INSERT INTO kwd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngaia te'e 'ino'ona la'u mola na 'ita'ilana nga fanua lo'oo 'i wado. Nga enselo tagila leka mai, ma gila tagila to'ole'enia nga ta'a 'e ria fa'asia nga ta'a gila le'a. ");
INSERT INTO kwd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma nga ta'a 'e ria lo'oo, tagila 'ui 'aniga 'i 'ubulana nga eele, 'i no'ona tagila aani, ma gila girigiri nifo.” ");
INSERT INTO kwd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui ma la Jisas ka orisiga maka fata 'ilo'oo, “Mooru moru su'asuria ni 'ola lo'oo?” Ma gila ka lamadu'aa ma gila ka 'ilo'oo, “Kiu.” ");
INSERT INTO kwd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma la Jisas ka fata 'ilo'oo faga, “Mooru te'efou moru su'a na Girigiringa Abu, sui ma mooru nanaua la'u mola kwaifa'ananaunga suria ba'itangaa na God, moru 'ilaka'u wane na ngaia 'e to'o na 'ifi ba'ita. Ngaia 'e ngaria mai ni 'ola le'a 'e aula fa'asia 'ifi aana, tani 'ola ngaa'i 'e fooru ma tani 'ola ngaa'i 'e nana'i aburu no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Alata la Jisas ngaia 'e alafuu 'ania tarifulaa lo'oori 'e sui, ngaia ka leka no'o fa'asia maa'e fanua no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma ngaia ka ori la'u mai na nga fanua aana 'i Nasaret. Ma ngaia ka leka 'i 'ubulana 'ifi ni fo'anga fana fa'ananaulana ta'a. Ma nga alata ta'a gila longoa, gila ka 'alefo ba'ita, ma gila ka fata 'ilo'oo, “Ni dai ne'e kwatea tegelangaa fana 'ani kwaifa'ananau 'ania fatalana God 'ilo'oo, ma fe'enia agelana ni 'ola ni 'alefosilai lo'oo? ");
INSERT INTO kwd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Goru su'a mola na nga wane lo'oo, ngaia nga wela ala Josef lo'oo mola, nga wane ngaia 'e su'asuria launge'enilana 'ola 'ania 'ai, ma tete'e aana ni Meri. Nga wanefuta aana na la Jemes, la Josef, la Saemon, ma la Judas. ");
INSERT INTO kwd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma nga wanena geni lo'oo, gila nana'i lau mola fe'eni 'adauru 'i lo'oo. 'Uta'i na ngaia 'e su'a'ola 'e iiki 'ilo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma nga alata no'ona, gila ka ogaria fana ma gila ma'asini te'enia la Jisas. Sui ma la Jisas ka fata 'ilo'oo faga, “Nga profet ngaia 'ato fana ta'a ni futanga aana fe'enia nga ta'a na maa'e fanua aana, 'agila iiri ba'ita ana.” ");
INSERT INTO kwd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma la Jisas ngaia ka 'ame agea no'o 'ola ni 'alefosilai aula na maa'e fanua lo'oo aana, suria nga ta'a no'ona gila 'ame siria fito'onga aana. ");
INSERT INTO kwd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma nga alata no'ona, la Herod Antipas ngaia wane ba'ita 'i Galili, ngaia 'e longoa kwairiinga suria la Jisas, ");
INSERT INTO kwd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma ngaia ka fata 'ilo'oo fana ta'a ni taunga'inga aana, “Wane lo'oo, ngaia la Jon wane ni naruabunga ngaia 'e moori la'u mola! Ngaia lo'oo 'e agea la'u ni 'ola ni 'alefosilai lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'I na'o, alata la Jon ngaia 'e momoori 'ua, la Herod ne'e feea ni Herodias nga noni na wane futa fe'enia la Filip. Ma la Jon ka iila fana la Herod maka 'ilo'oo, “Nga tagi na God ngaia 'ame alamia 'i'oo 'ani feea noni na wane ni futanga amu.” Ngaia lo'oo la Herod 'e kwatea ni wane fana 'agila gemasia la Jon, ma gila ka gaua, ma gila ka arua 'ubulana 'ifi na lokafu. La Herod ngaia agea 'ola lo'oo suria nga noni aana ni Herodias ne'e siria. ");
INSERT INTO kwd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nga alata la Jon 'e nana'i 'ubulana 'ifi na lokafu, la Herod 'e siria 'e iiki fana kwa'ilana, tafe'ua ma ngaia 'e ma'unge'enia mola ta'a, suria gila iiria la Jon ngaia nga profet. ");
INSERT INTO kwd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tafe'ua na te'e gani ngaa'i, la Herod 'e launge'enia nga fafangalaa ba'ita fana manatangaa to'ona nga gani ngaia 'e futa ai. Na nga fafangalaa no'ona, nga lari'i ani Herodias ngaia 'e leka mai maka wa'e fala Herod fe'enia ni wane ni kwaimaanga aana fana 'agila aga suria. Alata la Herod 'e agasia lari'i lo'oo ngaia 'e wa'e, ngaia 'e aile'a ba'ita fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma ngaia ka fataarunga'i fana lari'i lo'oori maka 'ilo'oo, “Nau taku kwatea famu te'efuta 'olataa na 'i'oo soea agu.” ");
INSERT INTO kwd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aia, tete'e na lari'i lo'oo 'e alafuu te'ana lari'i lo'oo aana maka fata 'ilo'oo, “'Oi soea, moko fata 'ilo'oo, ‘Nau ku siria 'i'oo 'ani kwatea mai gouna la Jon wane ni naruabunga fagu na alata lo'oo no'o. 'Oi arua mai fofona nga lafa ni fanganga.’” Ma nga lari'i lo'oo ka agea 'ilaka'u ngaia 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma alata la Herod 'e longoa 'ola lo'oo, ngaia 'e kwaimanadai ba'ita. Tafe'ua, ma ngaia 'e agea no'o, suria ngaia 'e fataarunga'i, ma ni wane ni kwaimaanga aana gila ka longoa no'o te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma ngaia ka alea ni wane ni fununga aana 'agila leka ma gila ka furi musia mai gouna la Jon wane ni Naruabunga 'ubulana 'ifi na lokafu. ");
INSERT INTO kwd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma gila ka ngaria mai gouna la Jon fofona lafa ni fanganga, ma gila ka kwatea no'o fana lari'i ani Herodias. Ma nga lari'i lo'oo ka ngaria ka kwatea no'o fana tete'e aana. ");
INSERT INTO kwd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Alata nga fufu'iwane ala Jon gila longoa nga 'ola lo'oo, gila leka mai, ma gila ka ngaria nonina, ma gila ka kwaiatoa no'o 'ubulana nga giru gwa'u. Sui ma, gila ka leka ma gila ka kwairii suria te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nga alata la Jisas ngaia 'e longoa nga 'ola lo'oo ngaia 'e lau ana la Jon, ngaia ka 'akwasia no'o lefu lo'oori, maka leka no'o 'i talana 'ubulana nga baru fana lefu na te'efuta wane 'ame nana'i ai. Nga ta'a gila longoa na la Jisas 'e leka no'o, ma gila ka 'akwasia nga fanua aga, ma gila ka leka no'o 'i burina suria tala. ");
INSERT INTO kwd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma alata la Jisas 'e sifo maka agasia nga oguogunga ba'ita lo'oo, ngaia ka kwaimanadai faga, maka gulaa nga ta'a na gila fii. ");
INSERT INTO kwd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na laulafi no'ona, nga fufu'iwane aana gila leka mai te'ana, ma gila ka fata 'ilo'oo, “Lefu lo'oo ngaia 'ame nana'i galangia te'efuta fanua, ma ngaia 'e galangi ka logo no'o. 'Oi alea nga ta'a lo'oo 'agila leka no'o, fana 'agila leka fana ni fanua ri'itana lefu lo'oo 'agila foria fangalaa faga 'i talaga.” ");
INSERT INTO kwd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","La Jisas ka lamadu'aga maka 'ilo'oo, “Ngaia le'a mola fana 'agila nana'i mola. Tamoru kwatea nga fangalaa faga fana 'agila 'ania.” ");
INSERT INTO kwd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma gila lamadu'aa ma gila ka 'ilo'oo, “Meeru meru to'o mola na te'e nima me'e beret ma rua gweii'a lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma la Jisas ka fata 'ilo'oo faga, “Moru ngaria mai lo'oo te'agu.” ");
INSERT INTO kwd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma ngaia ka iiria fana ta'a lo'oo 'agila to'oru 'i wado 'i fofona nga farisi. Sui ma ngaia ka ngaria nga nima me'e beret laka'u ma rua gweii'a lo'oori. Ma ka aga 'ala'a fana 'i langi, maka baole'a na God. Sui ma ngaia ka niia me'e beret no'ona, maka kwatea fana nga fufu'iwane aana, ma gila ka dalo'ia no'o 'i laloana nga ta'a lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nga ta'a lo'oori te'efou, gila keto leleka ma gila ka bote no'o. Sui ma nga fufu'iwane aana gila ka gonia nga fangalaa ne'e ole 'i 'ubulana nga akwale'e kukudu ma rua ai, leleka ma gila ka fonu te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma nga ta'a laka'u gila keto to'omia nima to'oni (5,000) wane, ma gila 'ame idumia mola nga ta'ageni ma nga ru'uru'ua. ");
INSERT INTO kwd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma 'i burina ni 'ola lo'oori, la Jisas ngaia 'e alea nga fufu'iwane aana 'agila leka no'o 'i na'o fana nga gule'e asi 'ubulana nga baru. Ma ngaia ka nana'i buri fana 'ani iiria fana nga ta'a lo'oori 'agila leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma burina nga ta'a gila ori no'o, ngaia ka fane no'o 'i talana na me'e busu fana ngaia 'ani fo'a. Alata ngaia 'e logo no'o, ngaia ka nana'i mola 'i talana 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma alata no'ona, nga baru laka'u 'e lalau no'o fa'asia 'i su'e, ma nga bio ka kwa'ia suria ngaia 'e na'ofia nga iru. ");
INSERT INTO kwd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma na alata 'usu'usugani mola, alata ngaia logologo'a 'ua, la Jisas 'e talau no'o mai 'i fofona nga asi, maka leka no'o mai te'aga. ");
INSERT INTO kwd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma nga alata gila agasia ngaia 'e leka mai 'i fofona nga asi, gila ka ma'u ba'ita. Ma gila ka o'omae 'ilo'oo, “Nga nunu'i 'ola!” Ma gila ka lebelebe no'o. ");
INSERT INTO kwd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma 'ame gole mola la Jisas ka fata 'ilo'oo faga, “Mooru sia ma'u mola! 'Inau lo'oo mola.” ");
INSERT INTO kwd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma la Pita ka lamadu'aa maka 'ilo'oo, “Alafa, lauta 'i'oo kwala'imori no'o, 'oi fata mai fagu fana 'aku leka kau te'amu 'i fofona nga asi lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","La Jisas ka fata 'ilo'oo, “Kiu, leka mai.” Sui ma la Pita ka sifo fa'asia nga baru laka'u, maka eta ka talau no'o 'i fofona nga asi te'ana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tafe'ua nga alata ngaia 'e agasia nga iru ba'ita, ngaia 'e ma'u maka eta ka kuru no'o 'i 'ubulana nga asi. Ma ngaia ka o'omae maka 'ilo'oo, “Alafa, 'oi fa'amoori nau.” ");
INSERT INTO kwd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma 'ame gole mola, la Jisas ka kwatea nimana kau te'ana, maka dau ana, maka fata 'ilo'oo, “Nga fito'onga amu ngaia 'e sisika. 'Uta'i na 'i'oo manata ruarua agu?” ");
INSERT INTO kwd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma nga alata gala fane no'o 'i 'ubulana nga baru, nga iru ka aloalo no'o. ");
INSERT INTO kwd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sui ma nga ta'a na gila nana'i 'i 'ubulana nga baru lo'oo, gila ka fa'aba'ita ma gila ka 'ilo'oo, “'I'oo no'o nga Wela na God kwala'imori.” ");
INSERT INTO kwd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma alata gila olofolo 'ubulana asi, gila ka sifo no'o na nga fanua gila fa'alataa 'ania 'i Genesaret. ");
INSERT INTO kwd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma nga ta'a na fanua no'ona, gila ka aga su'ana la Jisas. Ma gila ka kwate alafuunga fana tani maa'e fanua ngaa'i la'u suria la Jisas, fana ta'a no'ona, 'agila feea mai ta'a aaga na gila fii te'ana. Ma gila ka ngaria mai ta'a gila fii 'e aula te'ana. ");
INSERT INTO kwd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma nga ta'a no'ona gila ka soea la Jisas fana 'ani alamia nga ta'a fii lo'oori 'agila gema na nga 'a'aena nga ruu aana. Ma ta'a na gila gema to'ona ruu aana, gila ka gwari'a no'o. ");
INSERT INTO kwd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui ma tani Farasii ngaa'i ma nga ta'a ni kwaifa'ananaunga na tagi ala Moses, gila ka leka mai fa'asia 'i Jerusalem te'ala Jisas fana orisilana. ");
INSERT INTO kwd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Gila ka fata 'ilo'oo, “'Ola 'e fe'ua na fufu'iwane amu gila 'ame lo'o suria nga kwaifa'ananaunga na nga wawarifu dauru gila arua no'o mai na'o, tofuna gila 'ame narufia mola nga nimaga 'i na'o, sui ma tagila bi'i keto?” ");
INSERT INTO kwd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","La Jisas 'e lamadu'aga maka 'ilo'oo, “'Uta'i na moru leka suria kwaifa'ananaunga amooru talamooru, ma moru 'ame leka suria tagi na God? ");
INSERT INTO kwd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God 'e fata 'ilo'oo, ‘'Oi fa'aba'ita nga mama'a amu ma nga tete'e amu,’ ma ‘Ni dai na ngaia 'e fata ngadaa nga mama'a aana 'amoe tete'e aana, tagila kwa'ia 'ani mae.’ ");
INSERT INTO kwd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tafe'ua, mooru moru fa'ananau kuta mola ai lo'oo, Lauta te'efuta wane ngaia 'e to'o na ta 'ola na ngaia 'e su'asuria 'ani kwaibooni 'ania na mama'a aana ma tete'e aana, maka fata la'u mola 'ilo'oo, ‘Nau taku kwatea no'o 'ola laka'u fana God,’ ");
INSERT INTO kwd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ma moru iiria, ngaia 'e le'a mola fana ngaia 'e sia kwaibooni mola na mama'a aana ma nga tete'e aana 'ania ni 'ola laka'u ngaia 'e fataarunga'i 'ania fana God. Alata 'i'oo agea 'ilo'oo, 'i'oo 'ame fa'aba'ita nga mama'a amu ma nga tete'e amu, ma 'i'oo 'ame lo'oo suria fatalana God. ");
INSERT INTO kwd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma moru ka iiria mooru moru lo'o suria God, ma moru kotokoto mola. La Aesea ngaia 'e fata 'e to'o alata laka'u ngaia 'e giria nga 'ola na God 'e iiria suria amooru ma ka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nga ta'a lo'oo gila fa'aba'ita nau mola 'ania alafuunga aaga, tafe'ua ma manatalaga ngaia 'e lalau 'e iiki fa'asi nau. ");
INSERT INTO kwd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ngaia lo'oo 'agila fo'asi nau mola, tofuna gila kwaifa'ananau mola suria tagi aaga 'i talaga, ma gila ka iiria nga tagi na God lo'oo no'o.’ ");
INSERT INTO kwd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma la Jisas ka soea mai nga oguogunga laka'u te'ana, maka fata 'ilo'oo faga, “Moru gwalongo mai fagu, ma 'amoru su'aai. ");
INSERT INTO kwd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Te'efuta 'ola na nga wane ngaia 'e 'ania, ngaia 'ame fa'abiria wane 'i maana God. 'Amoe no'o! Nga alafuunga ne'e ru'u mai fa'asia ngiduna wane no'o ngaia 'e fa'asuaa nga manatalana wane. ");
INSERT INTO kwd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui ma nga fufu'iwane ala Jisas, gila leka mai te'ana, ma gila ka fata 'ilo'oo fana, “Nga 'ola laka'u 'i'oo iiria, nga Farasii gila longoa, ma nga manatalaga ngaia 'ame le'a suria.” ");
INSERT INTO kwd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Gila 'ilaka'u no'o nga 'ai na God 'ame kirua. God te'e kwatea kwa'ikwa'inga faga 'ilaka'u wane na ngaia 'e lafua nga 'ai lo'oo ne'e bila'o mai galangia 'ola lo'oo ngaia 'e kirua. ");
INSERT INTO kwd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma moru sia manata 'abelo mola suria Farasii lo'oori. Tofuna gila 'ilaka'u la'u mola nga wane maana 'e logo na ngaia 'e talaia nga wane ngaa'i maana 'e logo. Mai mooru moru su'a la'u mola ai, lauta te'efuta wane lo'oo maana 'e logo maka talaia la'u mola nga wane ngaa'i maana 'e logo, tagala 'esi 'agaa'a te'efou no'o 'i 'ubulana nga kiru.” ");
INSERT INTO kwd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma la Pita ka fata 'ilo'oo fala Jisas, “'Oi fa'awatagaa madi mai nga alafuunga laka'u 'i'oo bi'i iiria mola mai fameeru lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","La Jisas 'e lamadu'aa maka fata 'ilo'oo, “Mooru no'o na fufu'iwane agu, tafe'ua ma moru 'ame su'a la'u mola 'ua ai. ");
INSERT INTO kwd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Uta'i na moru 'ame su'a mola na nga 'ola lo'oo? Nga 'ola na te'efuta wane 'ania ngaia 'e nigi 'i 'ubulana, ma 'i buri ngaia ka ru'u la'u mola mai fa'asia 'ubulana nonina. ");
INSERT INTO kwd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tafe'ua nga alafuunga 'e ria na ngaia 'e ru'u mai fa'asia ngiduna wane, ngaia leka mai fa'asia 'ubulana mangona. Nga 'ola no'ona na ngaia 'e fa'abiria nga mangona wane. ");
INSERT INTO kwd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma 'ola 'e ria na 'e ru'u mai fa'asia 'ubulana manatalana wane ne'e 'ilo'oo: kwa'ilana wane, fuageni kwaifafingaa, agemaninga, kotonga fana te'efuta ai ngaa'i, berilana 'ola na te'efuta wane ngaa'i, fe'enia nga alafuunga 'e ria suria nga wane ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aia, ni 'ola lo'oo na ngaia 'e su'asuria 'ani fa'abiria mangona wane 'i maana God. Ma lauta wane ngaia 'ame leka suria falafala na wawarifu dauru, ma ngaia 'ame narufia nimana 'i na'ona fangalaa, nga mangona 'e sia ria mola.” ");
INSERT INTO kwd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","La Jisas ka leka no'o fa'asia nga lefu no'ona, maka leka no'o fana nga gule'e lefu 'i Taea ma 'i Saedon. ");
INSERT INTO kwd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma te'e noni fa'asia 'i Kenan na ngaia 'ame Jiu 'e leka mai te'ana, maka o'omae 'ilo'oo, “Alafa, 'i'oo nga alakwa na fufutanga ala Defete, 'oi madai nau mai! Nga adalo ngaia 'e bo'ea nga lari'i agu, maka nonifii 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","La Jisas ngaia 'ame lamadu'aa mola 'ania te'efuta alafuunga. Ma nga fufu'iwane aana gila ka leka mai te'ala Jisas, ma gila ka 'ilo'oo, “'Oi iiria ana 'ani leka no'o kau, suria ngaia 'e lado adauru, ma ngaia 'e lakote 'e iiki no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","La Jisas 'e fata fana noni no'ona maka 'ilo'oo, “God 'e alenau mola mai fana nga ta'a 'i Jiu na gila 'ilaka'u nga sifisifi na gila foo no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui ma nga noni no'ona ka leka mai, maka bobouruuru 'i na'ona 'a'aena maka 'ilo'oo, “Alafa, 'Oi kwaibooni mai agu.” ");
INSERT INTO kwd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","La Jisas ka lamadu'aa maka 'ilo'oo, “Ngaia 'ame odo fana ngarilana nga fangalaa na wela, maka to'osia mola fana nga ku'ito.” ");
INSERT INTO kwd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nga noni no'ona ka 'ilo'oo, “Kiu. Tafe'ua nga ku'ito 'e su'asuria 'agila 'ania lau mola nga furufuruna fangalaa ne'e 'esia fa'asia nga fo'ufo'u ni fangalaa na wane lo'oo ngaia 'e langoniga.” ");
INSERT INTO kwd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui mala Jisas 'e lamadu'aa maka 'ilo'oo, “Noni lo'oo, nga tagoto'onga amu ngaia 'e ba'ita 'e iiki! Ma nga 'ola lo'oo 'i'oo soea, nau taku kwatea no'o famu.” Ma nga lari'i aana ka gwari'a no'o na te'e alata no'ona mola.” ");
INSERT INTO kwd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Alata la Jisas ngaia 'e leka mai fa'asia maa'e fanua no'ona, ngaia ka ori mai suria tala ne'e riu suria asi 'i Galili. Ma ngaia ka fane gouna nga iile, maka to'oru 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma nga alata no'ona, ta'a 'e aula 'e iiki gila ka leka mai te'ana. Ma gila ka ngaria la'u mola mai tani ta'a 'a'aega 'e mae ma nga nimaga 'e mae, tani ta'a maaga 'e logo, ma tani ta'a gila foka'ato ma nga ta'a ngaa'i na gila fii. Gila aruga 'i na'ona 'a'aena la Jisas, ma ngaia ka gulaga, ma gila ka gwari'a te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma nga ta'a lo'oori na gila ogu, gila ka 'alefo ba'ita. Ta'a na gila foka'ato, gila fata la'u mola. Ma ta'a na 'a'aega 'e mae ma nga nimaga 'e mae gila ka le'a la'u mola. Ma ta'a na gila 'ame leka le'a, gila ka leka le'a no'o. Ma nga ta'a na maaga 'e logo, gila ka aga la'u mola. Ma suria na gila agasia ni 'ola lo'oo, gila bi'i iiri ba'ita na God 'i Israel. ");
INSERT INTO kwd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui ma la Jisas ka soea mai nga fufu'iwane aana te'ana, maka fata 'ilo'oo te'aga, “Nau ku kwaimanadai ba'ita fana ta'a lo'oo, tofuna gila nana'i fe'eni 'adauru suria oru gani 'e sui no'o, ma nga fangalaa aaga ka sui no'o. Ma nau ku 'ame siria orite'enilaga fana fanua aaga na alata gila molo'u 'ilo'oo, fa'asia te'efuta wane laloaga eta waata'uta'u, maka labufunu suria tala.” ");
INSERT INTO kwd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nga fufu'iwane aana gila orisia ma gila ka 'ilo'oo fana, “Nga lefu lo'oo 'e kwasila. Meeru tameru to'odaria nga fangalaa 'i fai fana 'ani to'omia ta'a 'e aula 'ilo'oo welakau?” ");
INSERT INTO kwd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma la Jisas ka orisiga maka 'ilo'oo, “Fita me'e beret na moru to'o ai?” Fufu'iwane aana gila lamadu'aa ma gila ka fata 'ilo'oo fana, “Fiu me'e beret lo'oo, fe'enia tani gweii'a lo'oo meru to'o ai.” ");
INSERT INTO kwd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nga alata no'ona, la Jisas ka iiria na ta'a no'ona 'agila to'oru 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui ma ngaia ka ngaria fiu me'e beret fe'enia gweii'a no'ona, maka baole'a fana God. Sui ma ngaia ka niia, maka kwatea fana fufu'iwane aana, fana 'agila dalo'ia fana ta'a no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ta'a no'ona, gila keto te'efou, ma gila ka bote no'o. Burina gila keto 'e sui, nga fufu'iwane aana gila ka fa'afongua fiu kukudu na fangalaa ne'e ole. ");
INSERT INTO kwd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ta'a na gila 'ania fangalaa lo'oori, gila to'omia fai to'oni (4,000) wane. Gila 'ame idumia mola nga ta'ageni ma nga ru'uru'ua sisita. ");
INSERT INTO kwd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aia, ma burina gila keto 'e sui mola, la Jisas bi'i orite'eniga fana fanua aaga. Ma ngaia fe'enia nga fufu'iwane aana, gila ka fane 'ubulana nga baru, ma gila ka leka no'o fana fanua gila fa'alataa 'ania 'i Magadan. ");
INSERT INTO kwd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aia, tani Farasii ngaa'i fe'enia tani Sadusi, gila ka leka mai te'ala Jisas fana 'agila irito'ona la'u mola, ma gila ka orisia fana ngaia 'ani agea late'e 'ola fana 'ani faate'enia na God 'e alea mai. ");
INSERT INTO kwd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","La Jisas ka lamadu'aga maka fata 'ilo'oo faga, “Na nga alata nga sina 'ani suu, lauta moru agasia nga lalo lo'oo ngaia 'e meku, moru su'aai, uuta 'e sia to'o mola 'igani. ");
INSERT INTO kwd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kiu, ma 'usu'usu gani, lauta moru agasia nga lalo ngaia 'e meku maka bobola'a, ma moru su'a no'o ai la'u mola nga uuta te'e to'o no'o. Mooru moru su'asuria agasilana lalo, tafe'ua ma moru 'ame aga su'a mola na nga 'ola na God 'e agea na alata lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Moru nga ta'a na alata lo'oo moru agea ni 'ola 'e ria 'e aula, ma moru 'ame tagoto'o la'u mola na God. Moru siria agasilana 'ola ni faata'inga. Tafe'ua nau ku sia agea mola te'efuta 'ola ni 'alefosilai famooru. Nga 'ola ni faata'inga lo'oo nau taku agea te'amooru 'amoru agasia no'o nga 'ola ni faata'inga na ngaia 'e lau fana nga profet la Jona 'i na'o.” Burina la Jisas ngaia 'e fata 'ilo'oo 'e sui, ma ngaia ka leka no'o fa'asiga. ");
INSERT INTO kwd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nga alata la Jisas fe'enia nga fufu'iwane aana gila olofolo fana nga gule'e asi, nga fufu'iwane aana gila mabolosia mola fana ngarilana beret fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma la Jisas ka fata 'ilo'oo faga, “Mooru aga le'a suri amooru fa'asia nga iist fana beret na Farasii ma ni Sadusi lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma nga alata nga fufu'iwane aana gila longoa nga alafuunga lo'oori, gila ka fata suria 'i laloaga 'i talaga, tofuna gila madafia iiria la Jisas ngaia 'e alafuu suria beret kwala'imori, ma gila ka 'ilo'oo, “Bala la Jisas ngaia 'e fata 'ilo'oo, tofuna goru 'ame ngaria mai te'efuta beret ta'ua lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma tofuna la Jisas ngaia 'e su'a mola na manatalana nga fufu'iwane aana, ngaia ka fata 'ilo'oo, “'Ola 'e fe'ua na moru manata 'abelo 'e iiki suria na moru 'ame ngaria mai te'efuta beret? Nga tagoto'onga lo'oo amooru 'e sisika 'e iiki!” ");
INSERT INTO kwd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Fe'ua? Mooru moru 'ame su'a 'ua na fa'aladanga 'ubulana nga 'ola lo'oo nau ku iiria famooru? Mooru moru 'ame madafia no'o nga nima me'e beret laka'u nau ku langonia 'ania nima to'oni (5,000) wane, ma moru ka fa'afongua kukudu 'e aula 'ania keto laka'u 'e ole? ");
INSERT INTO kwd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bala moru mabolosia la'u mola nga fiu me'e beret laka'u nau ku langonia 'ania fai to'oni (4,000) wane, ma moru ka fa'afongua kukudu 'e aula laka'u 'ania keto ne'e ole. ");
INSERT INTO kwd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Uta'i na moru 'ame su'a mola ai 'olataa na nau ku fata suria? Nau ku 'ame alafuu suria nga beret lo'oo. 'Olataa na nau ku iiria lo'oo na tamoru 'abelo 'ania mooru fa'asia nga iist fana beret na Farasii ma ni Sadusi lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Burina ngaia 'e fata 'ilo'oo 'e sui, nga fufu'iwane lo'oo gila bi'i su'aai 'olataa na la Jisas ngaia 'e alafuu 'i suria. Ngaia 'e alafuu mola suria nga kwaifa'ananaunga na Farasii ma nga Sadusi. ");
INSERT INTO kwd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Alata la Jisas ngaia 'e nigi na gule'e lefu 'i Sesarea Filipae, ngaia ka orisia nga fufu'iwane aana maka 'ilo'oo, “'Ino'ona ma ta'a lo'oo gila iiria nau nga Wela na Wane, 'ania ni dai?” ");
INSERT INTO kwd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gila lamadu'aa ma gila ka 'ilo'oo, “Tani ta'a ngaa'i gila iiria 'i'oo la Jon wane ni naruabunga na ngaia 'e moori la'u, ma tani ta'a ngaa'i gila iiria 'i'oo la Elaeja na ngaia 'e moori la'u. Ma tani ta'a ngaa'i la'u gila ka iiria 'i'oo la Jeremaea 'amoe ma profet ngaa'i lo'oo ngaia 'e moori la'u.” ");
INSERT INTO kwd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui ma la Jisas ka orisiga maka 'ilo'oo, “Ma 'i mooru lo'oo, moru iiria 'inau ni dai?” ");
INSERT INTO kwd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma la Saemon Pita ka lamadu'aa maka 'ilo'oo, “'I'oo no'o na nga Kraes, nga Wela na God ngaia 'e momoori firi.” ");
INSERT INTO kwd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma la Jisas ka fata 'ilo'oo, Saemon wela ala Jona, nga nanamangaa famu. Suria te'efuta wane 'ame faate'enia nga 'ola lo'oo famu. Tafe'ua nga ma'aa agu 'i langi na ngaia 'e faate'enia famu. ");
INSERT INTO kwd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma nau ku iiria famu, 'i'oo la Pita, ne'e fa'aladamia 'ilaka'u nga fou, maka 'ilaka'u nga fou na gila launge'enia nga 'ifi fofona. Ma fofona fou lo'oo, nau taku launge'enia siosi agu. Ma nga tegelalana maenga 'e sia talariufia mola. ");
INSERT INTO kwd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma nau ku kwatea tegelangaa famu na ngaia 'e 'ilaka'u nga kii na sinamaa na foufounga na God. Fana te'efuta 'ola na 'i'oo ruia wane 'e sia agea fofona fanua lo'oo 'i wado, God 'e ala fafia la'u mola fatalamu 'i Langi. Ma te'efuta 'ola na 'i'oo alamia wane 'ani agea 'i fofona fanua lo'oo 'i wado, God 'e alamia la'u mola 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui ma la Jisas ka fata tegela'a fana nga fufu'iwane aana, fana 'agila sia kwairii 'ua ai te'ana te'efuta wane suria ngaia na nga Kraes. ");
INSERT INTO kwd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","'Ita na alata no'ona maka leka, la Jisas 'e tala'ae no'o na alafuunga wataga fana nga fufu'iwane aana maka 'ilo'oo, “Nau taku leka no'o fani Jerusalem. Ma nga ta'a na'ona'o, ma nga fataabu ba'ita, ma nga ta'a ni kwaifa'ananaunga na tagi, tagila malate'ote'o agu, ma tagila kwa'i nau. Na oru maa'e gani, God te'e tata'e nau la'u fana nga mooringa.” ");
INSERT INTO kwd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma la Pita ka talaia kau, maka iila fana maka 'ilo'oo, “Alafa, God 'e ruia! Nga 'ola lo'oo, 'e sia lau mola famu.” ");
INSERT INTO kwd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma la Jisas ka bulota'i, maka fata 'ilo'oo fala Pita, “Saetan, leka lalau kau fa'asi nau! 'I'oo tata'e suari nau suria mantalamu 'i talamu ma 'amoe la'u fa'asia God.” ");
INSERT INTO kwd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui ma la Jisas ka fata 'ilo'oo fana nga fufu'iwane aana, “Ni dai ne'e siria 'ani lado agu, ngaia 'e sia manata 'abelo mola suria ni 'ola ngaia 'e siria mola fana 'i talana. Ngaia 'ani 'uri fana 'ani leka suri nau gwa'a ngaia 'ani nonifii, ma ka mae na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ni dai ne'e ma'asiri fana lekanga suri nau tofuna ngaia 'e siria 'ani agea mola ni 'ola suria kwaisiriinga aana 'i talana, ngaia te'e talafia nga mooringa firi lo'oo. Tafe'ua ni dai ne'e 'uri 'ani mae fagu, ngaia te'e to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lauta te'efuta wane 'e to'o na ni 'ola 'e aula fofona fanua lo'oo 'i wado, ma ngaia ka mae, ma ngaia 'e nana'i lalau fa'asia God, ni 'ola lo'oori 'e sia agea mola te'efuta le'anga fana. Te'efuta wane 'ame to'omia forilana nga mooringa firi 'ania nga bata. ");
INSERT INTO kwd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nau ku iiria 'ola lo'oo tofuna 'inau, nga Wela na Wane, nau taku leka mai fe'enia nga enselo agu, fe'enia kwangakwanganga na Mama'a agu, mai nau taku kwatea nga foforinga ma nga kwa'ikwa'inga fana nga ta'a te'efou, tofuna nga 'ola na gila agea. ");
INSERT INTO kwd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Ola 'e to'o nau ku iiria famooru, tani wane amooru gila sia mae mola leleka ma gila ka agasi nau ku nigi mai fe'enia foufounga agu.” ");
INSERT INTO kwd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na onona maa'e gani 'i buri, la Jisas 'e talaia la Pita, ma nga rua wane ni futanga aana, la Jemes ma la Jon 'i talaga fana 'i gouna me'e busu ne'e lau 'i langi. ");
INSERT INTO kwd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma alata gila aga kau, gila ka agasia nga maana la Jisas ngaia 'e bulota'i. Nga maana ka sinasinalo'a 'ilaka'u nga sina, ma nga ruu aana ka kwakwao'a te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma nga oru wane na fufu'iwane lo'oo aana, gila ka agasia la Moses fe'enia la Elaeja gala alafuu mola fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma la Pita ka fata 'ilo'oo kau fala Jisas, “Alafa, ngaia 'e le'a 'e iiki fana 'aguru nana'i lo'oo no'o. Lauta 'i'oo siria, nau 'aku launge'enia nga oru 'o'oba, te'e ai famu, te'e ai fana la Moses, ma nga ai ngaa'i fana la Elaeja.” ");
INSERT INTO kwd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma nga alata la Pita ngaia 'e alafuu mola 'ua 'ilo'oo, nga kofa ne'e sinasinalo'a 'e iiki 'e daa mai, ma nunufilana ka 'afu fafiga, ma gila ka longoa nga kwala 'e 'ola ngaia 'e fata mai 'ilo'oo fa'asia 'ubulana nga kofa no'ona, “Nga wela mouta'ia agu ngai lo'oo na nau ku kwaimaa ba'ita no'o fana. Nau ku aile'a fe'enia. Moru gwalongo fana.” ");
INSERT INTO kwd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma alata nga fufu'iwane aana gila longoa no'o kwala 'e 'ola lo'oo, gila ka ma'u ba'ita, ma gila ka eeno no'o fafia nga maaga 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma la Jisas ka nigi mai te'aga, maka gema to'oga, maka fata 'ilo'oo, “Moru tata'e. Ma moru sia ma'u mola.” ");
INSERT INTO kwd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma nga alata gila aga kau, gila 'ame agasia no'o te'efuta wane, ma te'e la Jisas momola. ");
INSERT INTO kwd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma nga alata gila sifo mai fa'asia 'i gouna nga busu lo'oori, la Jisas ka fata tegela'a faga maka 'ilo'oo, “Mooru sia kwairii mola te'ana te'efuta wane na 'ola lo'oo moru agasia, leleka maka nigi na alata God 'ani tata'e nau, nga Wela na Wane, fa'asia nga maenga.” ");
INSERT INTO kwd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oru wane na fufu'iwane aana gila orisia ma gila ka 'ilo'oo, “'Ola 'e fe'ua na ta'a ni kwaifa'ananaunga na tagi gila iiria la Elaeja te'e ori la'u mai, sui ma nga wane laka'u God 'e firia te'e bi'i leka mai?” ");
INSERT INTO kwd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","La Jisas 'e lamadu'aga maka 'ilo'oo, “Ngaia 'e to'o. La Elaeja te'e ori mai, fana 'ani kwaibooni na ta'a fana nga sasari agaungaa. ");
INSERT INTO kwd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mai nau ku iiria la'u famooru, la Elaeja ngaia 'e nigi mai 'e sui no'o. Tafe'ua nga ta'a gila 'ame aga su'a mola ana. Ngaia lo'oo, gila agea lau mola ni 'ola 'e ria ana suria nga kwaisiriinga aaga. Ma tagila agea 'ilo'oo la'u mola agu. ");
INSERT INTO kwd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Alata oru wane na fufu'iwane lo'oori gila longoa, gila bi'i su'aai na la Jisas 'e fata te'aga suria la Jon wane ni naruabunga. ");
INSERT INTO kwd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Alata la Jisas fe'enia oru wane na fufu'iwane aana gila sifo mai fana 'a'aena busu lo'oori, nga ta'a 'e aula gila ogu no'o, ma te'e wane ngaa'i 'e leka mai, maka bobouruuru 'i na'ona 'a'aena la Jisas, maka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Alafa, 'oi manadaia mai nga wela wane agu, tofuna nga langasi kwa'ikwa'i ngaia 'e agea. Nga fiifinga lo'oo 'e agea ma ngaia ka nonifii furifuri, ma nga alata 'e aula ngaia ka 'esia 'ubulana eele, ma 'i 'ubulana ka'o la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau ku ngaria mai te'ana fufu'iwane amu. Tafe'ua ma ngaia 'e 'ato 'e iiki faga fana 'agila gulaa.” ");
INSERT INTO kwd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","La Jisas 'e fata 'ilo'oo faga, “Manata lamooru 'e ngasi 'e iiki, ma mooru ta'a moru ria! Ma moru 'ame fito'o agu 'ua! Nau ku nana'i fe'eni amooru 'e nigi lo'oo no'o, to'omia amooru fito'o mola agu.” Sui ma ngaia ka fata 'ilo'oo fana wane no'ona, 'oi ngaria mai nga wela no'ona amu lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma la Jisas ka fata tegela'a fana nga adalo no'ona, ma ngaia ka leka no'o fa'asia nga wela lo'oori. Ma nga wela lo'oori ka gwari'a no'o na te'e alata no'ona la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma alata gila nana'i 'i talaga, nga fufu'iwane lo'oo gila leka mai te'ala Jisas, ma gila ka orisia ma gila ka 'ilo'oo, 'Ola 'e fe'ua na ngaia 'e 'ato fameeru fana belote'enilana nga adalo laka'u welakau?” ");
INSERT INTO kwd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma la Jisas 'e lamadu'aga maka fata 'ilo'oo, “Ngaia 'e 'ilo'oo, tofuna moru 'ame tagoto'o mola. Mai nau ku iiria famooru, lauta nga tagoto'onga amooru na God ngaia 'e ba'ita 'ilaka'u nga 'u'ui 'ola sisika na gila fa'alataa 'ania mastad, mooru su'asuria 'amoru agea mola nga 'olataa na ngaia 'e 'ato. Lauta ngaia 'e 'ilo'oo, gwa'a nga busu loko'u, tamoru 'idua mola fa'asia talafurina 'ania fata lamooru. Ma lauta moru tagoto'o na tegelangaa na God, te'efuta 'ola 'e sia 'ato mola fana 'amoru agea.” ");
INSERT INTO kwd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma nga alata fufu'iwane aana gila ogu mai 'i Galili, la Jisas ka fata 'ilo'oo faga, “Nau, nga Wela na Wane, tagila kwate nau fana marimae agu, ");
INSERT INTO kwd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","fana 'agila kwa'i nau. Tafe'ua na oru maa'e gani, God te'e tata'e nau la'u mola fana mooringa.” Ma alata fufu'iwane gila longoa la Jisas ngaia 'e fata 'ilo'oo, gila ka kwaimanadai ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na alata la Jisas fe'enia nga fufu'iwane aana gila leka mai fana fanua 'i Kapaneam, nga ta'a na gila goni bata na takisi fana 'Ifi Abu na God, gila leka mai te'ala Pita, ma gila ka orisia 'ilo'oo, “'Ino'ona ma wane ni kwaifa'ananaunga amooru su'asuria 'ani sugaa la'u mola bata na meeru gonia fana 'Ifi Abu na God?” ");
INSERT INTO kwd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma la Pita 'e lamadu'aga maka 'ilo'oo, “Kiu, ngaia 'e su'asuria 'ani sugaa.” Ma alata la Pita 'e ru'u 'ubulana 'ifi, la Jisas ka etaa kwaiorisinga maka 'ilo'oo, “Saemon, 'i'oo manata 'uta'i? Dai no'o nga alafa na fanua lo'oo 'i wado su'asuria 'ani ngaria bata fa'asiga? Nga ru'uru'ua aaga 'i talaga, 'amoe ma fa'asia ta'a kwaitaa?” ");
INSERT INTO kwd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","La Pita 'e lamadu'aa maka 'ilo'oo, “Fa'asia ta'a kwaitaa.” Ma la Jisas ka 'ilo'oo, “Lauta ngaia 'e 'ilo'oo, nga ru'uru'ua aaga gila 'ame kwatea mola nga takisi lo'oo. Ngaia lo'oo, lauta nau ku 'ame kwatea nga takisi fana 'Ifi Abu na Mama'a agu, ngaia 'e le'a mola. ");
INSERT INTO kwd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma gwa'a ngaia 'e 'ilo'oo, ngaia 'ame le'a 'aguru ngadaa nga manatanga aaga fadauru. 'Oi leka 'i asi, moko dee mai. Nga gweii'a na 'i'oo daua eteeta, 'oi 'ulasia fokana, moko agasia, nga bata ne'e to'omia dauru fana forilana takisi fana nga farisi, ngai 'ubulai. Ngaria bata no'ona, moko kwatea faga.” ");
INSERT INTO kwd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nga alata no'ona, nga fufu'iwane ala Jisas gila leka mai te'ana, ma gila ka orisia ma gila ka 'ilo'oo, “Alata ba'itangaa na God 'ani nigi, ni dai ameeru na te'e ba'ita 'e iiki welakau?” ");
INSERT INTO kwd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na nga alata no'ona, la Jisas 'e soea mai te'e wela sisita te'ana, maka fa'aula 'i laloaga. ");
INSERT INTO kwd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ngaia ka fata 'ilo'oo, “'Ola 'e to'o lo'oo nau ku iiria famooru, lauta moru lamadu'aa nga abulongaa amooru, ma moru ka malasika'a amooru talamooru 'ilaka'u wela sisita lo'oo, ma tamoru to'omia fana God 'ani ba'ita fafi amooru. ");
INSERT INTO kwd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma ni dai ne'e malasika'a aana 'ilaka'u wela sisita lo'oo, God te'e lafua 'ubulana ba'itangaa aana. ");
INSERT INTO kwd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Lauta ni dai na 'i'oo kwaloa te'efuta wela 'ilo'oo tofuna na ngaia 'e tagoto'o agu, 'i'oo kwalo nau la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Lauta te'efuta wane 'e agea wane ne'e malofi'a 'ilaka'u wela maka 'esia fa'asia fito'onga aana agu, ngaia 'e le'a fana 'agila gaua nga fou ba'ita 'i onomana, ma gila ka to'osia 'i 'ubulana nga matakwa tofuna kwa'ikwa'inga na God te'e kwatea fana ngaia 'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngaia te'e ria no'o fana ta'a 'i fofona fanua lo'oo 'i wado suria ni 'ola 'e aula fana kutalana ngai ai. Ma ngaia te'e ria 'e iiki no'o fana ta'a na tagila agea ni 'ola lo'oo fana 'ani agea ta'a lo'oo 'agila 'esiga fa'asia tagoto'onga aaga agu. ");
INSERT INTO kwd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ma lauta nimamu 'amoe ma 'a'aemu 'e age'o 'e 'esi'o fa'asia fito'onga amu agu, 'oi furi mousia fa'asi'o. Ngaia 'e le'a mola famu lauta 'i'oo ru'u 'ubulana mooringa firi 'i Langi fe'enia te'e gule'e ninima 'amoe te'e gule'e 'a'ae, fa'asia 'i'oo bi'i sifo 'i 'ubulana lefu na eele ngaia 'e nunula ma 'e sia mae la'u fe'enia rua ninima ma rua 'a'ae. ");
INSERT INTO kwd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma lauta maamu 'e age'o 'e 'esi'o fa'asia fito'onga amu agu, 'oi lafua fa'asi'o, moko to'osia. Ngaia 'e le'a mola famu lauta 'i'oo 'ani ru'u 'i 'ubulana mooringa firi 'i Langi fe'enia te'e gule'e maa, fa'asia 'i'oo bi'i sifo 'i 'ubulana lefu na eele ngaia 'e nunula ma 'e sia mae mola fe'enia rua gule'e maa.” ");
INSERT INTO kwd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ma la Jisas ka fata 'ilo'oo la'u, “Mooru sia aga sifo mola na ni wela sisita lo'oo. Suria nga enselo aaga gila nana'i furifuri fe'enia God Mama'a agu 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma lauta te'efuta wane 'e to'o na nga tangale'e sifisifi, ma te'e ai aga ka foo, ma 'olataa na wane lo'oo te'e agea? Wane lo'oo te'e 'akwasia mule akwala ma mule sifisifi lo'oo na lefu gila keketo ai, ma te'e leka maka kwailo'ofia te'e sifisifi lo'oo ngaia 'e foo. ");
INSERT INTO kwd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Alata ngaia 'e daria, ngaia 'e aile'a 'e iiki riufia no'o aile'anga aana fe'enia nga sifisifi na gila nana'i mola fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nga Mama'a amooru mai langi, ngaia 'e manata 'ilo'oo la'u mola, suria ngaia 'ame siria fana te'efuta wela sisita lo'oo 'ani talafia mooringa firi.” ");
INSERT INTO kwd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","La Jisas 'e fata 'ilo'oo fana nga fufu'iwane aana, “Lauta nga wane ni futanga amu 'e agea te'efuta 'ola 'e ria amu, 'oi leka te'ana, moko kwairii te'ana na nga kutanga aana 'i laloamoo'o talamoo'o. Ma lauta ngaia 'e gwalongo famu, ma 'i'oo orite'enia no'o te'ana God. ");
INSERT INTO kwd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma lauta ngaia 'e 'ame gwalongo famu, talaia te'efuta wane 'amoe nga rua wane la'u fe'eni'o, fana 'agala fa'ato'oa, fana 'i'oo agea suria nga Girigiringa Abu laka'u 'e iiria, ‘Nga rua wane 'amoe ma nga oru wane fana 'agila fa'ato'oa nga alafuunga lo'oo ngaia 'e agea.’ ");
INSERT INTO kwd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma lauta ngaia 'ame 'uri 'ani gwalongo, kwairii te'ana nga oguogunga na ta'a na God. Ma lauta gwa'a nga oguogunga na ta'a lo'oo na God ma ngaia 'ame gwalongo no'o faga, arua 'i maa fa'asia oguogunga na ta'a amooru 'ilaka'u nga ta'a gila bobolosia God, 'amoe ta'a 'e ria na ngaia gonia nga bata na takisi. ");
INSERT INTO kwd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“'Ola 'e to'o lo'oo nau ku iiria famooru, te'efuta 'ola na moru ruia wane 'e sia agea mola fofona fanua lo'oo 'i wado, God 'e ala fafia la'u mola 'i Langi. Ma te'efuta 'ola na moru alamia wane 'ani agea 'i fofona fanua lo'oo 'i wado, God 'e alamia la'u mola mai 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nau ku iiria la'u mola famooru, lauta nga rua wane laloamooru gala ala fafia te'efuta 'ola 'i fofona fanua lo'oo 'i wado, ma gala ka fo'a fai, Mama'a agu 'i Langi ngaia te'e kwatea fagaa'a. ");
INSERT INTO kwd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Suria lauta nga rua wane 'amoe ma nga oru wane gila ogu na te'efuta lefu tofuna gila tagoto'o agu, nau ku nana'i la'u mola fe'eniga no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","La Pita 'e nigi te'ala Jisas, maka orisia maka 'ilo'oo, “Alafa, fita alata na nau taku 'olafanataa na wane ni futanga agu, alata ngaia 'e agea nga 'ola 'e ria agu? Ngaia 'e leleka maka nigi na fiu alata?” ");
INSERT INTO kwd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma la Jisas ka lamadu'aa maka 'ilo'oo, Nau ku iiria famu, 'amoe mola fana te'e fiu alata, tafe'ua ma nga fiu akwala ma fiu alata na 'i'oo to'o 'olafanataa aana. ");
INSERT INTO kwd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nau ku iiria 'ilo'oo tofuna ba'itangaa na God 'e 'ilaka'u nga wane ba'ita na ngaia 'e siria 'ani fa'aodoa nga fangalanga'a ana fe'enia nga ta'a ni taunga'inga aana. ");
INSERT INTO kwd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aia, nga wane ni taunga'inga eteeta 'e gania nga 10,000 na bata aana. ");
INSERT INTO kwd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma nga wane ni taunga'inga lo'oo ngaia 'ame to'omia no'o fana nga du'ulana nga fangalanga'a lo'oo ana, ma nga wane ba'ita lo'oo 'e iiria fana 'agila fa'afori 'ania wane ni taunga'inga lo'oo, fe'enia nga noni aana, ma nga ru'uru'ua aana, ma ni 'ola te'efou na ngaia 'e to'o ai, fana du'ulana nga fangalanga'a lo'oo aana. ");
INSERT INTO kwd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma nga wane ni taunga'inga lo'oori 'e leka mai maka bobouruuru 'i na'o na nga wane ba'ita lo'oo, maka laeta'a maka 'ilo'oo, ‘'Oi nonimaabe madi fe'eni nau, fana 'aku du'ua ni 'ola lo'oo amu te'efou.’ ");
INSERT INTO kwd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma nga wane ba'ita lo'oori ka kwaimanadai fana, ma ngaia ka 'olafanataa no'o na fangalanga'a aana fana ngaia 'e sia du'ua la'u, ma ngaia ka alamia maka leka no'o kau. ");
INSERT INTO kwd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aia, ma alata nga wane lo'oori 'e ru'u kau 'i maa, ngaia 'e leka te'ana te'e wane ni taunga'inga ngaa'i na ngaia 'e gania nga te'e bata sisita te'ana. Ngaia 'e gemasia, maka eta no'o fana 'inilana kuukuuna, maka fata 'ilo'oo, ‘'Oi du'aa no'o nga 'ola laka'u 'i'oo gani agu.’ ");
INSERT INTO kwd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma wane ni taunga'inga no'ona ka bobouruuru, maka laeta'a maka 'ilo'oo, ‘'Oi nonimaabe madi fe'eni nau, mai nau taku du'u famu.’ ");
INSERT INTO kwd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tafe'ua ma ngaia 'e ma'asiri, maka ngaria, maka arua 'ubulana nga 'ifi na lokafu, leleka ma ngaia ka du'ua no'o nga fangalanga'a lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma alata nga ta'a ni taunga'inga gila agasia nga 'ola lo'oori, manatalaga 'e kwaimanadai ba'ita. Ma gila ka leka te'ana nga wane ba'ita lo'oori, ma gila ka kwairii na nga 'ola lo'oo te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma nga wane ba'ita no'ona ka soea mai nga wane ni taunga'inga eteeta lo'oori, maka fata 'ilo'oo fana, ‘'I'oo nga wane 'i'oo ria 'e iiki! Nau ku 'olafanataa mola na fangalanga'a laka'u amu te'efou, suria 'i'oo laeta'a fai te'agu. ");
INSERT INTO kwd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngaia 'e to'omia 'i'oo 'ani 'olafanataa la'u mola na nga wane ni taunga'inga no'ona, 'ilaka'u laka'u nau ku agea famu.’ ");
INSERT INTO kwd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma nga wane ba'ita lo'oori ka ogaria ba'ita, maka kwatea fana 'agila labusia 'ubulana nga 'ifi na lokafu, leleka ma ngaia ka du'aa no'o nga 'ola te'efou na ngaia 'e gania.” ");
INSERT INTO kwd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma la Jisas ka fa'asuia nga tarifulaa lo'oori maka 'ilo'oo, “Nga 'ola no'ona la'u mola na nga Mama'a agu 'i Langi te'e agea famooru, lauta moru 'ame 'olafanataa kwala'imori na wane moru futa. ");
INSERT INTO kwd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Alata la Jisas 'e alafuu 'e sui mola, ma ngaia ka leka no'o fa'asia gule'e lefu 'i Galili. Ma ngaia ka olofolosia no'o nga ka'o 'i Jodan, maka nigi na gule'e lefu 'i Judea. ");
INSERT INTO kwd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma nga ta'a 'e aula 'e iiki na gila leka 'i suria. Ma nga ta'a na gila fii, la Jisas ka gulaga ma gila ka gwari'a no'o. ");
INSERT INTO kwd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma tani Farasii ngaa'i gila leka la'u mola mai fana nga irito'olana la Jisas. Gila orisia, ma gila ka 'ilo'oo, “'Ino'ona ma nga tagi ala Moses, ngaia 'e le'a mola fana wane 'ani rugasia mola noni ana tofuna te'efuta 'ola?” ");
INSERT INTO kwd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","La Jisas 'e lamadu'aga maka 'ilo'oo, “Nau ku su'aai mooru moru idumia Girigiringa Abu ne'e fata 'ilo'oo, ‘Mai na eteetanga, God ngaia 'e launge'enia wanewa'u ma nga nonigeni.’ ");
INSERT INTO kwd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma nga Girigiringa Abu 'e fata la'u mola 'ilo'oo, ‘Tofuna 'ola lo'oori, wane te'e 'akwasia nga ma'a aana fe'enia tete'e aana, maka lado fe'enia nga noni aana, ma gala tagala lau no'o fana te'e wane momola.’ ");
INSERT INTO kwd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gaa'a nga rua 'ola kwaitatari 'amoe no'o, tafe'ua ma gaa'a gala lau no'o fana te'e labe'ewane momola. Ngai lo'oo 'olataa God ngaia 'e firi ogua 'e sui no'o, ngaia 'ame le'a fana te'efuta wane 'ani rubea la'u.” ");
INSERT INTO kwd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma ni Farasii lo'oo gila orisia la'u ma gila ka 'ilo'oo, “La Moses ngaia 'e alamia nga wane 'ani giria nga kabe 'ola na kwairugasingaa, maka kwatea fana nga noni aana fana ngaia 'ani 'akwasia mola. Ma 'uta'i na la Moses 'e alamia fana wane 'agila agea 'ilo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","La Jisas ka fata 'ilo'oo faga, “La Moses ngaia 'e alamia famooru Jiu fana 'akwasilana noni amooru, tofuna manata lamooru 'e ngasi 'e iiki. Gwa'a 'ilo'oo, mai na'o nga alata God ngaia 'e launge'enia nga wane ma nga noni, ngaia 'ame 'ilo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mai nau ku iiria famooru, lauta noni na te'efuta wane 'ame agemani mola fafia, ma nga kwaiina ngaia ka 'akwasia maka feea la'u mola te'efuta noni ngaa'i la'u, nga wane lo'oo ngaia 'e kuta no'o na agemaninga kwaifafi.” ");
INSERT INTO kwd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Burina la Jisas 'e fata 'ilo'oo te'aga te'efou, fufu'iwane aana gila ka fata 'ilo'oo fana, “Ma lauta ngaia 'ato 'e iiki fana wane 'ani 'akwasia nga noni aana 'ilo'oo, ngaia 'e le'a fana wane 'e sia fuageni mola.” ");
INSERT INTO kwd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma la Jisas ka fata 'ilo'oo faga, “Nga kwaifa'ananaunga lo'oo ngaia 'amoe fana ta'a te'efou 'agila leka suria, ma ngaia fana ta'a na God 'e firiga fana 'agila leka suria mola. ");
INSERT INTO kwd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tani wane ngaa'i gila 'ame fuageni, suria gila 'aiwane alata gila futa mai ai. Ma tani wane ngaa'i gila 'ame fuageni suria gila kwari 'usia wela. Ma tani wane ngaa'i gila 'ame fuageni tofuna gila taunga'i tegela'a no'o fana God. Ma nga ta'a na gila to'omia, alamia 'agila leka suria nga kwaifa'ananaunga lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma 'i burina ni 'ola lo'oo, tani ta'a ngaa'i gila ngaria mai nga ru'uru'ua sisita te'ala Jisas, fana ngaia 'ani arua nimana fafiga, maka fo'a faga. Ma nga fufu'iwane aana gila ka iila faga. ");
INSERT INTO kwd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma la Jisas ka fata 'ilo'oo faga, “Moru alamia ni wela sisita 'agila leka mai te'agu, moru sia ruiga mola. Suria God te'e ba'ita fafia ta'a na gila malofi'a 'ilaka'u ni wela sisita lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui mala Jisas ka arua nga nimana 'i fofona ni wela sisita lo'oori, maka nanamate'eniga. Sui ma, ngaia ka leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na te'e alata ngaa'i, te'e wane sika'u ngaia 'e leka mai te'ala Jisas, maka orisia 'ilo'oo, “Wane ni kwaifa'ananaunga, nga 'ola le'a 'uta'i lo'oo na nau taku agea fana 'aku to'o na nga mooringa firi lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","La Jisas 'e lamadu'aa ma ka fata 'ilo'oo fana, “'Ola 'e fe'ua na 'i'oo orisi nau suria nga 'ola le'a welakau? Te'e God no'o na ngaia 'e le'a. Lauta 'i'oo siria 'i'oo 'ani to'o na mooringa firi, 'oi lo'o suria nga tagi aana.” ");
INSERT INTO kwd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma nga wane lo'oo ka orisia la'u la Jisas maka 'ilo'oo, “Tagi 'uta'i welakau?” La Jisas ka du'aa 'ilo'oo aana, “'I'oo sia kwa'ia mola ta wane, 'i'oo sia agemani kwaifafi mola, 'i'oo sia beria mola te'efuta 'ola, 'i'oo sia koto mola fana te'efuta wane. ");
INSERT INTO kwd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Moko iiri ba'ita na mama'a amu ma tete'e amu. Moko kwaimaa fana ta'a te'efou 'ani 'ilaka'u la'u mola na 'i'oo kwaimaa famu 'i talamu.” ");
INSERT INTO kwd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui ma wane sika'u lo'oo ka fata 'ilo'oo fala Jisas, “'Ola lo'oori te'efou, nau ku lo'oo no'o 'i suria. 'Ilo'oo ma 'olataa na 'aku agea la'u welakau?” ");
INSERT INTO kwd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma la Jisas 'e lamadu'aa maka 'ilo'oo fana, “Lauta 'i'oo siria 'i'oo 'ani le'a moko ari'afu, leka moko fa'afori 'ania ni 'ola na 'i'oo to'o ai te'efou, sui moko ngaria bata no'ona, moko kwatea fana ta'a na gila galafa'a, ma 'i'oo to'o to'o na dari'olanga 'i Langi. Sui ma 'i'oo to'o bi'i leka mai suri nau.” ");
INSERT INTO kwd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma nga alata nga wane sika'u lo'oori 'e longoa nga 'ola lo'oo, nga mangona 'e kwaimanadai ba'ita, ma ngaia ka leka no'o, tofuna ngaia nga wane 'e dari'ola'a 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma la Jisas ka fata 'ilo'oo fana nga fufu'iwane aana, “Nau ku iiria famooru, ngaia 'e 'ato 'e iiki fana nga ta'a na gila dari'ola'a 'agila ru'u 'ubulana mooringa lo'oo God 'e ba'ita fafia. ");
INSERT INTO kwd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma nau ku iiria la'u mola famooru, ngaia 'e 'ato 'e iiki fana te'efuta kamel 'ani ru'u suria nga maa'e kwakwa sisika 'i 'a'aena nila. Ma ngaia 'e 'ato 'e riufia la'u mola fana te'efuta wane dari'ola'a fana God 'ani ba'ita fafia moorilana.” ");
INSERT INTO kwd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aia, ma nga alata fufu'iwane aana gila longoa nga 'ola lo'oo, gila ka 'alefo ba'ita, ma gila ka fata 'ilo'oo, “Lauta ngaia 'e 'ato fana wane dari'ola 'ilo'oo, ni dai na te'e to'omia fana mooringa firi lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma nga alata la Jisas 'e alafuu mola, ngaia 'e aga odo kau fana fufu'iwane aana, maka fata 'ilo'oo, “Ngaia 'e 'ato 'e iiki fana nga wane 'ani daria mooringa firi, tafe'ua ma fana God ngaia 'ame 'ato mola. Nga 'ola lo'oo te'efou ngaia 'e wada'u mola fana God.” ");
INSERT INTO kwd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nga alata no'ona, la Pita ka orisia la Jisas maka 'ilo'oo, “Ma 'imeeru meru 'uta'i lo'oo? Tofuna 'imeeru meru 'akwasia no'o ni 'ola ameeru te'efou, ma meru ka leka no'o 'i suri'o. Ma 'olataa na God te'e kwatea fameeru?” ");
INSERT INTO kwd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma la Jisas ka lamadu'aa fana maka 'ilo'oo, “Nau ku iiria famooru, na alata God 'ani arua nga fanua fooru lo'oo, 'inau, nga Wela na Wane, nau taku nana'i na furi'i to'orunga agu fana nga sufalana ta'a te'efou. Nga alata no'ona, amooru akwale'e wane ma ruaai agu, tamoru nana'i fe'eni nau fana sufalana ta'a na akwala ma rua fufutalaa 'i Israel. ");
INSERT INTO kwd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma ni dai ne'e 'akwasia 'ifi aana, ma nga wanefutanga aana, ma nga wanena geni, ma nga mama'a ana fe'enia tete'e aana, ma ru'uru'ua aana, ma nga wado aana, tofuna ngaia 'e leka suri nau, nga wane no'ona ngaia te'e ngaria ni 'ola 'e le'a 'e aula riufia ni 'ola laka'u ngaia 'e to'o ai 'i na'o. Ma God te'e kwatea la'u mola mooringa firi fana. ");
INSERT INTO kwd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma ta'a 'e aula lo'oo na gila mala ba'ita aaga na alata lo'oo, tagila sika'a mola. Ma ta'a 'e aula na gila malasika'a aaga na alata lo'oo, tagila ba'ita.” ");
INSERT INTO kwd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","La Jisas 'e fata 'ilo'oo fana nga fufu'iwane aana, “Nga ba'itangaa na God ngaia 'e 'ilo'oo: Ngaia 'e 'ilaka'u nga wane ne'e to'o na wado, maka leka 'usu'usugani fana nga soelana ta'a fana taunga'inga 'ubulana langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma ngaia ka ala fafia nga forilaga 'ania bata ne'e to'omia fana te'e gani momola, maka alega no'o fana taunga'inga 'ubulana nga langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma na mulena mae'ola na sina 'usugani, ngaia 'e leka la'u, maka agasia tani wane ngaa'i na gila ula tago mola 'i 'ubulana usi'a. ");
INSERT INTO kwd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma ngaia ka fata 'ilo'oo faga, ‘Moru leka la'u mola mai, fana amoru taunga'i 'ubulana nga langa'a agu, mai nau taku fori amooru 'ania 'ola ne'e toto'o fe'enia taunga'inga lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma gila ka leka no'o. “Ma dalototo'o na gani, ma nga oruna mae'ola na sina gagani, ngaia 'e leka la'u mola, maka agea 'ino'ona la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma laulafi no'o, ngaia ka leka maka to'odaria tani wane na gila ula tago la'u mola maana usi'a. Ma ngaia ka orisiga maka 'ilo'oo, ‘Fe'ua na moru ula tago mola 'i lo'oo suria gani la'ula'u lo'oo?’ ");
INSERT INTO kwd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma gila lamadu'aa ma gila ka 'ilo'oo, ‘Te'efuta wane 'ame soe 'ameeru mola fana taunga'inga.’ “Ma ngaia ka fata 'ilo'oo faga, ‘Moru leka la'u mola mai, fana amoru taunga'i 'ubulana nga langa'a agu.’ ");
INSERT INTO kwd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ma alata nga sina 'e suu no'o, wane ne'e to'o na langa'a lo'oo ka fata 'ilo'oo fana nga wane ba'ita na taunga'inga lo'oo aana, ‘'Oi soea mai ni wane ni taunga'inga lo'oo, moko foriga 'ania nga bata aaga. To'o eta na nga ta'a laka'u nau ku soega 'i'isi, leleka maka nigi na nga ta'a laka'u nau ku eta soega mai na'o.’ ");
INSERT INTO kwd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Nga ta'a ni taunga'inga laka'u ngaia soega 'i buri laulafi, gila nigi mai, ma ngaia ka foriga 'ania bata ne'e to'omia te'e gani fana te'e wane. ");
INSERT INTO kwd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma alata nga ni wane laka'u ngaia 'e soega mai 'i na'o gila nigi mai, gila madafia iiria ngaia te'e foriga 'e ba'ita 'e riufiga. Tafe'ua ma gila te'efou gila ngaria mola bata ne'e to'omia te'e gani fana te'e wane. ");
INSERT INTO kwd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma alata gila ngaria mola, gila ka ngu'ungu'u no'o 'i buri fana nga wane ne'e to'o na nga langa'a lo'oo, ma gila ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nga ta'a lo'oo 'i'oo soega mai buri, gila taunga'i mola suria alata sisika, mai 'i'oo foriga 'e toto'o la'u mola fe'eni 'ameeru na meeru ngari gelo na nga taunga'inga suria nga gani la'ula'u lo'oo, ma nga sina ka sinafii 'ameeru.’ ");
INSERT INTO kwd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma ngaia ka lamadu'aa te'e wane aga maka 'ilo'oo, ‘Welakau, nau ku 'ame beri'o lo'oo. 'I'oo ala fafia nga taunga'inga fana nga bata laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngaria no'o foforinga amu, moko leka no'o kau. Nau ku siria 'aku kwatea fana wane na nau ku soea 'i'isi 'e 'ilaka'u la'u mola na nau ku kwatea famu. ");
INSERT INTO kwd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma nau ku to'o na tegelangaa fana agelana 'olataa na nau ku siria taku agea 'ania nga bata agu 'i talagu. “Fe'ua 'i'oo 'uga, tofuna nau ku kwatea ni 'ola ba'ita fana ta'a matari lo'oo?’” ");
INSERT INTO kwd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sui ma la Jisas ka fata 'ilo'oo, “Ngaia no'ona, nga wane na ngaia 'e leka mai buri na alata lo'oo, te'e leka no'o 'i na'o la'u mola. Ma nga wane na ngaia 'e leka no'o 'i na'o, te'e ori la'u 'i buri.” ");
INSERT INTO kwd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Alata la Jisas ngaia 'e leka fani Jerusalem, ngaia ka soea mai nga fufu'iwane aana galangia, ma ngaia ka alafuu te'aga 'i talaga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mooru gwalongo le'a mai fagu. Goru leka no'o fana 'i Jerusalem. Ma tagila kwate nau, nga Wela na Wane, fana fataabu ba'ita ma nga ta'a ni kwaifa'ananaunga na tagi, fana 'agila sufa nau fana nga kwa'ilagu. ");
INSERT INTO kwd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma tagila kwate nau fana ta'a na gila 'ame Jiu, ma tagila doodoo 'ani nau, ma tagila labusi nau. Sui ma tagila mudi'i nau na 'ai folo fana kwa'ilagu. Aia, ma nga oruna gani, God te'e tata'e nau la'u fana mooringa.” ");
INSERT INTO kwd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Burina 'ola lo'oori, noni ala Sebedi fe'enia nga rua wela aana, la Jemes ma la Jon, gala nigi mai fana agasilana la Jisas. Nga noni lo'oori 'e leka mai, maka bobouruuru 'i na'ona la Jisas, maka soea fana agelana nga 'ola fana rua wela lo'oo aana. ");
INSERT INTO kwd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma la Jisas ka orisia noni lo'oo maka 'ilo'oo, “'Olataa na 'i'oo siria?” Ngaia ka fata 'ilo'oo, “Nau ku siria 'i'oo 'ani alamia rua wela lo'oo agu, 'agala nana'i galangi'o, nga wane ngaa'i 'ani nana'i 'i gula le'a amu, ma nga wane ngaa'i 'i gula moori amu, alata 'i'oo 'ani ba'ita 'ubulana foufounga amu.” ");
INSERT INTO kwd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na alata no'ona, la Jisas ka fata 'ilo'oo fana rua wane lo'oori, “'Ola lo'oo molo soea, moo'o molo 'ame su'a mola na fa'awatagalai. Moo'o molo to'omia 'amolo nonifii 'ilaka'u na nau taku nonifii?” Ma gala ka fata 'ilo'oo, “Kiu, amee'e mele to'omia mola.” ");
INSERT INTO kwd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","La Jisas ka fata 'ilo'oo la'u fagaa'a, “Ngaia 'e to'o, nga nonifiinga lo'oo te'e nigi amoo'o. Tafe'ua fana nga wane ngaia 'ani nana'i gula le'a agu, ma nga wane ngaa'i gula moori agu 'ilaka'u na molo siria, nau ku 'ame firia. Te'i Mama'a agu 'i Langi no'o 'e su'asuria kwatelai fana ni dai na ngaia 'e firiga fai 'e sui no'o. ");
INSERT INTO kwd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Alata nga akwale'e wane na fufu'iwane ana lo'oori gila longoa 'ola lo'oo, gila ka ogaria fana rua wasina lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngaia lo'oo, la Jisas ka soega te'efou no'o mai te'ana, maka fata 'ilo'oo, ‘Mooru moru su'aai nga ta'a ba'ita na gila ba'ita fana ta'a na gila 'ame Jiu, gila to'o na tegelangaa, ma gila su'a le'a na usunge'enilana wane fana agelana ni 'ola gila siria. ");
INSERT INTO kwd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tafe'ua, ngaia 'e sia 'ilo'oo la'u 'i laloamooru. Lauta te'efuta wane amooru ngaia 'e siria 'ani ula na'ona'o, ngaia 'ani su'aai ngaia wane ni taunga'inga amooru 'ani lau. ");
INSERT INTO kwd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma lauta ni dai amooru na ngaia 'e siria 'ani ba'ita, ngaia 'ani taunga'i tago fana ta'a. ");
INSERT INTO kwd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngaia te'e agea 'ilaka'u 'inau, nga Wela na Wane. Tofuna nau ku 'ame leka mai fana nga ta'a lo'oo 'agila taunga'i fagu. Mai nau ku leka mai fana 'aku taunga'i fana ta'a te'efou, ma 'aku kwatea no'o moorilagu fana fa'amoorilana nga ta'a te'efou fa'asi rianga aaga.” ");
INSERT INTO kwd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ma nga alata la Jisas fe'enia fufu'iwane aana gila 'akwasia no'o fanua 'i Jeriko. Nga ta'a 'e aula 'e iiki gila leka no'o suriga. ");
INSERT INTO kwd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma nga rua wane maa gaa'a 'e logo gala nana'i gegena tala. Ma alata gala longoa la Jisas 'e leka mai suria tala lo'oo, gala ka o'omae, ma gala ka 'ilo'oo, “Alafa, 'i'oo nga alakwa na fufutanga ala Defete, 'oi manadaia amee'e mai.” ");
INSERT INTO kwd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma alata nga ta'a lo'oo gila longo 'agaa'a, gila ka iila fagaa'a, ma gila ka fata 'ilo'oo, “Molo nana'i aloalo.” Tafe'ua na alata gila fata 'ilo'oo fagaa'a, gala bi'i o'omae ba'ita maka iiki la'u, “Alafa, 'i'oo nga alakwa na fufutanga ala Defete, 'oi madai'a amee'e mai.” ");
INSERT INTO kwd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma alata la Jisas 'e longoa gala o'omae mai 'ilo'oo, ngaia ka mamalo, maka orisiga maka 'ilo'oo, “'Olataa na molo siria 'aku agea famoo'o?” ");
INSERT INTO kwd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gala lamadu'aa, ma gala ka 'ilo'oo, “Mee'e mele siria 'i'oo 'ani 'ulasia maa mee'e fana amele aga la'u.” ");
INSERT INTO kwd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","No'ona, la Jisas ka kwaimanadai ba'ita fagaa'a, ma ngaia ka gema na nga maa gaa'a. Ma nga alata no'ona mola, nga maa gaa'a ka aga no'o, ma gala ka leka no'o fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma la Jisas fe'enia nga fufu'iwane aana gila nigi galangia no'o 'i Jerusalem, na fanua 'i Betefeis, 'i gouna nga busu 'i Olif. 'I no'ona, la Jisas ka kwatea nga rua wane na nga fufu'iwane aana, 'agala leka 'i na'o, ");
INSERT INTO kwd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma ngaia ka fata 'ilo'oo fagaa'a, “Molo leka fana fanua loko'u molo agasia kau ma tamolo to'odaria te'e dongki, gila gaua 'i no'ona fe'enia nga dadalena. Tamolo rube 'agaa'a, ma molo ka ngari 'agaa'a mai te'agu. ");
INSERT INTO kwd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma lauta te'efuta wane 'e orisi 'amoo'o, molo iiria te'ana 'ilo'oo, ‘Nga Alafa 'e bo'obo'o fai. Ma ngaia te'e orite'eni 'agaa'a 'afe'aferu mola mai.’” ");
INSERT INTO kwd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Ola lo'oo ngaia 'e lau fana 'ani fa'ato'oa 'olataa laka'u nga profet ngaia 'e iiria maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Moru iiria fana ta'a 'i Jerusalem ma moru ka fata 'ilo'oo, ‘Agasia madi. Nga kiingi amooru, ngaia 'e leka no'o mai te'amooru. Ngaia 'e malofi'a, maka leka mai 'i fofona nga dongki. Ngaia 'e leka mai 'i fofona nga dale'e dongki.” ");
INSERT INTO kwd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma nga rua wane na nga fufu'iwane aana, gala ka leka no'o 'i na'o, ma gala ka agea no'o 'ola na la Jisas 'e iiria fagaa'a. ");
INSERT INTO kwd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gala talaia mai nga dongki no'ona fe'enia nga dadalena, ma gila ka lafate'enia nga ruu aga 'i fofona bobouna na rua dongki lo'oo, ma la Jisas ka nana'i 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma nga ta'a 'e aula 'e iiki gila ka lafate'enia nga ruu aaga suria nga tala, ma tani ta'a ngaa'i gila ka tofua nga lalana baibai, ma gila ka lafate'enia suria nga tala fana fa'aba'italana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nga oguogunga ba'ita na gila leka 'i na'o la Jisas, ma gila na gila leka 'i'isi kau 'i burina, gila o'omae ma gila ka 'ilo'oo, “Baatafengaa fana wela na fufutanga ala Defete nga kiingi! God 'oi nanamate'enia nga wane na ngaia 'e leka mai 'ania nga tegelangaa amu!” Goru baatafea God!” ");
INSERT INTO kwd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma alata la Jisas ngaia 'e nigi 'i Jerusalem, nga ta'a 'ubulana fanua gila tata'iiri te'efou no'o, ma tani ta'a ngaa'i gila orisiga ma gila ka 'ilo'oo, “Ni dai lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma nga oguogunga no'ona gila ka 'ilo'oo, “Ngaia la Jisas nga profet, nga wane fa'asia nga fanua 'i Nasaret 'i 'ubulana nga gule'e lefu 'i Galili.” ");
INSERT INTO kwd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Alata la Jisas 'e leka mai maka nigi 'ubulana 'Ifi Abu na God, ngaia 'e taria nga ta'a na gila fori ma gila fa'afori no'ona. Ma ngaia ka geua nga fofo'u na ta'a na gila lamadu'aa nga bata 'i Rom fana bata 'i Jiu, maka geua nga 'ola fana to'orunga na ta'a na gila fa'afori 'ania nga langasi. ");
INSERT INTO kwd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma la Jisas ka fata 'ilo'oo fana ta'a no'ona, “Nga Fatalana God 'ubulana Girigiringa Abu ngaia 'e fata 'ilo'oo, ‘Nga 'Ifi agu, nga 'ifi ni fo'anga.’ Tafe'ua mai 'amooru bulote'enia mola fana lefu fana beringa.’” ");
INSERT INTO kwd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na nga alata no'ona, tani wane maaga 'e logo, ma tani ta'a 'a'aega 'e mae, gila leka la'u mola mai te'ala Jisas 'ubulana 'Ifi Abu na God, ma ngaia ka gulaga te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tafe'ua, ma alata nga fataabu ba'ita ma nga ta'a ni kwaifa'ananaunga na Tagi gila agasia ni 'ola le'a lo'oo la Jisas ngaia 'e agea, ma gila ka longoa ni wela sisita gila o'omae ma gila ka 'ilo'oo, “Baatafengaa fana wela na fufutanga ala Defete nga kiingi,” gila ka ogaria ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma ni fataabu ba'ita fe'enia nga ta'a ni kwaifa'ananaunga na tagi, gila ka fata 'ilo'oo fala Jisas, “'I'oo longoa 'olataa na gila iiria! Fe'ua na 'i'oo 'ame ruiga welakau?” Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Kiu, nau ku longoa no'o. Ma moru 'ame idumia mola alafuunga laka'u 'ubulana Girigiringa Abu? Ngaia 'e fata 'ilo'oo, ‘'I'oo fa'ananaua nga ru'uru'ua sisita fana 'agila tafe'o 'i talamu.’” ");
INSERT INTO kwd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sui ma 'i burina, la Jisas fe'enia fufu'iwane aana gila ka leka no'o fa'asia 'i Jerusalem, ma gila ka leka no'o fani Betani. Ma alata ngaia 'e logo no'o, gila ka eeno mola 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Usugani na ruana gani, alata la Jisas fe'enia nga fufu'iwane aana gila ori mai fana 'i Jerusalem, la Jisas ka molo'u. ");
INSERT INTO kwd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma ngaia ka agasia te'e 'ai na gila fa'alataa 'ania figi ngaia 'e ula 'i gegena tala, maka leka 'i 'a'aena, tafe'ua ma ngaia 'ame agasia mola te'efuta lode 'ola ai, ma te'e kakena ne'e urubono mola. Ma ngaia ka fata 'ilo'oo fana 'ai figi lo'oori, “'I'oo sia fungu la'u!” Ma nga alata no'ona mola, nga 'ai lo'oori ka malonga no'o. ");
INSERT INTO kwd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Alata fufu'iwane aana gila agasia 'ola lo'oori, gila ka 'alefo ba'ita. Ma gila ka orisia 'ilo'oo, “'Olataa ne'e agea nga 'ai lo'oo 'e malonga 'afe'aferu mola 'ilo'oo welakau?” ");
INSERT INTO kwd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma la Jisas 'e lamadu'aga maka 'ilo'oo, “Nau ku iiria famooru, lauta moru fito'o ma moru 'ame manata ruarua, tamooru su'asuria 'amoru agea mola 'ola ba'ita riufia nga 'ola lo'oo nau ku agea na 'ai lo'oo. Lauta moru iiria fana nga busu lolo'o, ‘'Oi leka, moko nana'i 'ubulana asi,’ ma ngaia te'e leka mola.’ ");
INSERT INTO kwd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lauta moru fo'asia God, ma moru ka tagoto'o na God fana 'ola lo'oo moru soea, ngaia te'e agea mola.” ");
INSERT INTO kwd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aia, alata la Jisas ngaia 'e ori la'u 'ubulana 'Ifi Abu na God fana fa'ananaulana ta'a, ni fataabu ba'ita, ma tani ta'a na'ona'o 'i Jiu, gila ka leka mai te'ana. Ma gila ka orisia 'ilo'oo, “Nga tegelangaa 'uta'i lo'oo 'i'oo to'o ai fana nga agelana ni 'ola lo'oo te'efou welakau? Ma ni dai lo'oo ngaia 'e kwatea nga tegelangaa lo'oo famu?” ");
INSERT INTO kwd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Nau ku orisi 'amooru madi fana te'e 'ola. Lauta moru du'aa, mai nau taku bi'i kwairii te'amooru na nga tegelangaa lo'oo nau ku to'o ai fana agelana ni 'ola lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Moru kwairii madi te'agu, nga tegelangaa lo'oo la Jon ngaia 'e to'o ai fana nga naruabunga, ngaia 'e 'ita mai fa'asia 'i fai? Ngaia 'e 'ita mai fa'asia God, 'amoe ma ngaia 'e leka mola mai fa'asia nga ta'a?” Ma gila ka eta no'o fana orisu'usu'unga 'i laloaga kwairiu ma gila ka 'ilo'oo, “'Olataa na tagoru iiria? Lauta goru du'aa ma goru iiria, ‘Fa'asia God,’ ma ngaia te'e fata 'ilo'oo, ‘Ma 'uta'i na moru 'ame tagoto'o ala Jon?’ ");
INSERT INTO kwd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma lauta goru fata 'ilo'oo, “Wane ne'e kwatea mola tegelangaa fala Jon 'ani naruabu ai na ta'a, nga God 'amoe,” ma ta'a tagila ogaria fadauru. Gila ma'u, suria nga ta'a lo'oo gila iiria la Jon ngaia nga profet.” ");
INSERT INTO kwd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngaia lo'oo gila ka lamadu'aa 'ilo'oo mola fala Jisas, “Meeru meru bobolosia mola ni dai ne'e kwatea tegelangaa fala Jon 'ani naruabu na ta'a.” Ma la Jisas ka fata 'ilo'oo faga, “Lauta ngaia 'e 'ilo'oo, nau ku sia kwairii la'u mola te'amooru ni dai ne'e kwatea nga tegelangaa lo'oo fagu.” ");
INSERT INTO kwd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma la Jisas ka fata 'ilo'oo la'u faga, “Mooru manata 'uta'i suria nga 'ola lo'oo? Te'e wane ngaia 'e to'o na rua wela wane. Ma ngaia ka leka te'ana nga wela ana 'i na'o, maka fata 'ilo'oo fana, ‘Alakwa agu, 'oi leka, moko taunga'i 'i 'ubulana nga langa'a laka'u adauru tala'ina lo'oo!’ ");
INSERT INTO kwd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma ngaia ka lamadu'aa maka 'ilo'oo, “Nau ku ma'asiri” Ma 'e sui mola 'i burina, ngaia ka bulote'enia nga manatanga ana, maka leka no'o 'i 'ubulana nga langa'a laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma 'i buri, mama'a agaa'a ka leka la'u te'ana nga ruana wela ana, maka iiria la'u mola te'e alafuunga lo'oori. Ma nga wela lo'oo 'e lamadu'aa maka 'ilo'oo, ‘Ngaia 'e le'a mola. Nau taku leka.’ Tafe'ua ma ngaia 'ame leka mola. ");
INSERT INTO kwd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“'Ino'ona ma ni dai agaa'a ne'e agea 'ola laka'u nga mama'a agaa'a ngaia 'e siria?” Ma gila lamadu'aa ma gila ka 'ilo'oo, “Nga wela laka'u 'i na'o.” Ma la Jisas ka fata 'ilo'oo faga, “'Ola kwala'imori lo'oo nau ku iiria famooru, nga ta'a 'e ria na gila gonia nga bata na nga takisi, ma ni noni na gila 'ame le'a, tagila ru'u eteeta 'i 'ubulana nga mooringa lo'oo God ngaia te'e ba'ita fafia 'i na'o mooru. ");
INSERT INTO kwd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nau ku fata 'ilo'oo suria la Jon wane ni naruabunga laka'u ngaia 'e nigi no'o mai te'amooru fana nga faate'enilana nga to'orunga na God ngaia 'e siria famooru 'amoru leka suria, mai moru 'ame tagoto'o mola ana. Tafe'ua, nga ta'a lo'oo gila gonia bata na nga takisi, ma nga noni na gila agemani'a, gila tagoto'o ana. Ma gwa'a moru agasia nga 'ola lo'oo, moru 'ame tagoto'o mola ala Jon, ma moru 'ame bulote'enia mola manata lamooru.” ");
INSERT INTO kwd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","La Jisas ka fata la'u mola faga maka 'ilo'oo, “Moru longoa madi te'e tarifulaa lo'oo la'u. Te'e wane ba'ita ngaia 'e to'o na nga langa'a na grep. Ma ngaia ka launge'enia feo 'afuia, maka 'eria te'e kiru fana nga memelana lode 'ai fana launge'enilana waen, maka launge'enia nga 'ifi fana nga folonga. Ma ngaia ka arua nga langa'a lo'oo aana nimana nga ta'a na gila taunga'i 'i 'ubulai. Sui ma ngaia ka leka no'o fana nga maa'e fanua ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma alata nga langa'a lo'oori ngaia 'e suka, ngaia ka alea nga ta'a ni taunga'inga aana 'agila ngaria mai gule'e 'ola na lodona 'ola na gila fisua. ");
INSERT INTO kwd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ma nga ta'a na gila aga suria nga langa'a lo'oo, gila gemasia nga ta'a ni taunga'inga aana, ma gila labusia nga wane ngaa'i, ma ruana wane gila ka kwa'ia 'ani mae no'o, ma oruna wane gila ka 'uia no'o 'ania fou fana kwa'ilana. ");
INSERT INTO kwd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui ma ngaia ka kwatea la'u mola tani wane ni taunga'inga 'e aula la'u te'aga 'e riufia 'i na'o. Ma nga ta'a na gila aga suria nga langa'a lo'oo, gila ka agea 'ino'ona la'u mola aaga. ");
INSERT INTO kwd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma 'ita'ilai, ngaia 'e kwatea nga wela mouta'ia aana te'aga. Tofuna ngaia 'e madafia 'ilo'oo, ‘Tagila iiri ba'ita na nga wela lo'oo agu.’ ");
INSERT INTO kwd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tafe'ua ma nga alata nga ta'a lo'oori gila agasia nga wela aana, gila ka alafuu kwairiu no'o te'aga ma gila ka 'ilo'oo, ‘Ngaia no'o na wela na wane ne'e to'o na nga langa'a lo'oo. Goru kwa'ia 'ani mae, fana 'agoru ngaria ni 'ola lo'oo aana te'efou.’ ");
INSERT INTO kwd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma gila gemasia, ma gila ka tatale'enia 'i maa fa'asia nga langa'a lo'oo, ma gila ka kwa'ia maka mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sui ma la Jisas 'e orisiga maka 'ilo'oo, “'Ilo'oo ma alata nga wane lo'oo 'e to'o na nga langa'a lo'oo 'ani nigi mai, 'olataa na ngaia te'e agea na nga ta'a na gila aga suria nga langa'a lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma gila lamadu'aa ma gila ka 'ilo'oo, “Ngaia te'e kwa'ia nga ta'a 'e ria lo'oori 'agila mae, ma ngaia te'e kwatea la'u nga langa'a aana fana nga ta'a matari na tagila kwatea nga gule 'ola na lode 'ai lo'oo fana na alata na goni'olanga.” ");
INSERT INTO kwd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma la Jisas ka fata 'ilo'oo faga, “Nau ku su'aai na'a mooru moru idumia nga Girigiringa Abu laka'u ngaia 'e fata 'ilo'oo, ‘Nga fou na nga ta'a ni launga'inga na 'ifi gila ma'asini te'enia, ngaia na nga fou 'e taringa'i maka riufia nga fou lo'oo te'efou na bani. God ne'e launge'enia nga 'ola lo'oori, ma gila ka aga ka le'a 'e iiki.’ ");
INSERT INTO kwd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma ngaia na'a nau ku iiria famooru, nga nanamangaa na foufounga na God tagila lafua fa'asi 'amooru, ma tagila kwatea no'o fana nga ta'a na gila lo'o suria. ");
INSERT INTO kwd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma lauta ni dai ne'e 'esia fofona fou lo'oo, ngaia te'e taringingisi no'o. Ma lauta ni dai na fou lo'oori 'e 'esia fafia, nga nonina te'e meme te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma alata fataabu ba'ita ma nga Farasii, gila longoa ni tarifulaa lo'oori, gila aga su'aai la Jisas ngaia 'e alafuu suriga. ");
INSERT INTO kwd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngai na'a gila siria 'agila gemasia. Tafe'ua ma gila ma'u, tofuna nga ta'a 'e aula gila tagoto'o, la Jisas ngaia nga profet. ");
INSERT INTO kwd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","La Jisas ka fata la'u 'ania tarifulaa fana nga ta'a maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nga ba'itangaa na God ngaia 'e 'ilo'oo: Te'e kiingi ngaia 'e launge'enia nga fafangalaa na fuageninga fana nga alakwa aana na 'e fuageni. ");
INSERT INTO kwd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma ngaia ka alea nga ta'a ni taunga'inga aana na nga ta'a na'a ngaia 'e laefiiga mai fana nga fafangalaa no'ona, fana 'agila leka mai. Tafe'ua ma gila ka ma'asiri mola fana lekanga mai. ");
INSERT INTO kwd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sui ma ngaia ka alea la'u nga ta'a ni taunga'inga aana maka fata 'ilo'oo faga, ‘Moru kwairii te'ana nga ta'a na nau ku laefiiga, nga fafangalaa agu 'e sasari no'o. Nau ku daua te'efou no'o nga buruka ba'ita agu ma nga dale'e buruka le'ale'a agu, ma ni 'ola te'efou ka sasari no'o. Moru leka no'o mai na nga fafangalaa lo'oo agu.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tafe'ua ma gila 'ame siria mola longonga suria, ma gila ka leka matari la'u mola. Nga wane ngaa'i 'e leka no'o 'ubulana langa'a aana, ma nga wane ngaa'i ka leka no'o suria dari'olanga aana. ");
INSERT INTO kwd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma tani wane ngaa'i gila gemasia nga ta'a ni taunga'inga lo'oori, ma gila ka labusiga, ma gila ka kwa'iga. ");
INSERT INTO kwd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma nga kiingi lo'oo ka ogaria ba'ita, ma ngaia ka alea no'o ta'a ni fununga aana, ma gila ka kwa'ia no'o ta'a lo'oori na gila kwa'ia ni wane ni taunga'inga aana. Ma gila ka do'ofia no'o fanua ba'ita aaga. ");
INSERT INTO kwd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sui ma ngaia ka fata 'ilo'oo fana ni wane ni taunga'inga aana, ‘Nga fafangalaa 'e sasari no'o, tafe'ua ma nga ta'a laka'u nau ku laefiiga, gila 'ame to'omia mola fana lekanga mai na nga fafangalaa lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Moru leka suria nga tala, ma moru ka soea mai nga ta'a te'efou na moru to'o dariga, 'agila leka mai na fafangalaa lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma ni wane ni taunga'inga gila ka leka suria nga tala, ma gila ka ogua mai nga ta'a te'efou na gila to'o dariga. Ma nga fafangalaa na nga fuageninga lo'oori ka fonu no'o na ta'a 'e le'a ma nga ta'a 'e ria. ");
INSERT INTO kwd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ma alata kiingi 'e nigi mai fana agasilana nga ta'a na gila nigi, ngaia ka agasia te'e wane na ngaia 'ame rufi mola 'ania nga ruu na nga fuageninga. ");
INSERT INTO kwd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma nga kiingi ka fata 'ilo'oo, ‘Fe'ua 'i'oo 'ame rufi mola 'ania nga ruu na fafangalaa na fuageninga?’ Ma nga wane no'ona ngaia 'ame iiria no'o te'efuta 'ola. ");
INSERT INTO kwd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sui ma nga kiingi ka iiria fana nga ta'a ni taunga'inga aana maka 'ilo'oo, ‘Moru gaua nga nimana ma nga 'a'aena wane lo'oo, ma moru ka to'osia 'ubulana nga lefu logologo'a no'ona 'i maa, nga lefu na wane 'ani aani maka girigiri nifo ai.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sui ma la Jisas ka fa'asuia alafuunga aana 'ilo'oo, “Nga ta'a 'e aula la God 'e soega, tafe'ua ma te'e ni wane tarito'o na ngaia 'e firiga.” ");
INSERT INTO kwd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nga ta'a na Farasii gila leka, ma gila ka fadaa fana daiorisilana la Jisas fana fa'akuta lana. ");
INSERT INTO kwd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma gila ka kwatea fufu'iwane aaga fe'enia tani wane na fufu'iwane ala Herod te'ala Jisas. Ma gila ka fata 'ilo'oo, Wane ni kwaifa'ananaunga, 'imeeru meru su'aai ni 'ola 'i'oo iiria, ngaia 'e to'o te'efou no'o. 'I'oo kwaifa'ananau mola 'ania nga to'onga suria kwaisiriinga na God fana nga ta'a. Ma 'i'oo 'ame manata gelo mola suria te'efuta 'olataa na ta'a gila manata suria. Ma 'i'oo 'ame manata mola fana nga 'inato'onga na wane. ");
INSERT INTO kwd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kiu, 'oi kwairii madi te'ameeru! Nga tagi adauru, ngaia 'e ruia nga kwatelana nga bata na takisi fana nga wane ba'ita 'i Rom? 'Ilo'oo ma ngaia 'e to'omia ameeru kwatea takisi laka'u la'u mola, 'amoe 'utaa?” ");
INSERT INTO kwd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma la Jisas 'e su'a mola na nga manatangaa lo'oo aaga 'e ria, maka fata 'ilo'oo, “Mooru nga ta'a ni kotonga. 'Uta'i na moru irito'ona fana nga fa'akutalagu? ");
INSERT INTO kwd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moru faate'enia madi nga bata na moru foria 'ania nga takisi.” Ma gila ka ngaria mai fe'e seleni, ma gila ka faate'enia fana. ");
INSERT INTO kwd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma ngaia ka orisiga maka 'ilo'oo, “Nga nununa ni dai lo'oo? Ma nga latana ni dai lo'oo ngaia ai?” ");
INSERT INTO kwd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma gila lamadu'aa, ma gila ka 'ilo'oo, “Nga nunu'i 'ola ma nga latana nga wane ba'ita 'i Rom.” Ma la Jisas ka fata 'ilo'oo, “Mooru kwatea fana nga wane ba'ita 'i Rom nga 'ola aana, ma moru ka kwatea la'u mola 'ola na God fana God.” ");
INSERT INTO kwd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma alata gila longoa nga lamadu'aanga lo'oori 'e le'a 'ilo'oo, gila ka 'alefo ba'ita, ma gila ka leka no'o fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na fe'e gani no'ona la'u mola, tani Sadusi gila leka mai te'ala Jisas. Nga Sadusi gila iiria nga wane gila sia tata'e mola fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma gila ka orisia la Jisas, ma gila ka fata 'ilo'oo, “Wane ni kwaifa'ananaunga, la Moses ngaia 'e giria nga tagi fadauru 'ilo'oo, ‘Lauta te'efuta wane ngaia 'e mae, ma nga noni aana 'e momoori mola 'ua, ma ngaia 'ame to'o na wela, nga wane ni futanga na wane laka'u te'e feea la'u nga me'e nao lo'oori, fana 'agala to'o na wela fana 'ani orite'enia fufutanga na wane no'ona ngaia 'e mae.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma te'e alata ngaa'i, nga fiu wasina gila nana'i. Ma nga wane eteeta 'e feea te'e lari'i. Aia, ma nga alata gala 'ame to'o 'ua na te'efuta wela, wane lo'oori ka mae mola. ");
INSERT INTO kwd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nga ruana wane ka feea la'u nga noni lo'oori. Aia, ma gala 'ame to'o 'ua na te'efuta wela la'u mola, ma ngaia ka mae la'u mola. Oruna wane ka feea la'u, maka mae la'u mola. Ngaia 'ilo'oo leleka ma fiu wasina no'ona, gila ka mae te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Burina nga fu'uwasina lo'oo gila mae, noni lo'oo bi'i mae la'u. ");
INSERT INTO kwd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aia, ma nga noni lo'oo ngaia 'e baiwane mai fana fiu wasina lo'oo. Lauta 'ino'ona, alata ni wane lo'oo gila tata'e fa'asia maenga, ni dai na fiu wasina lo'oori na ngaia nga kwaiina noni lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","La Jisas 'e lamadu'aga maka 'ilo'oo, “Mooru moru kuta no'o, suria moru 'ame su'a mola na Girigiringa Abu ma nga tegelangaa na God. ");
INSERT INTO kwd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Suria, alata nga wane mae 'ani tata'e la'u fana nga mooringa, gila 'ilaka'u no'o nga enselo 'i Langi na gila sia fuageni la'u. ");
INSERT INTO kwd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Mai nau ku fa'ananau 'amooru suria nga tata'enga fa'asia nga maenga. Nau ku su'aai moru idu la'u mola suria 'ola laka'u God 'e iiria 'ua no'o mai maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nau nga God ala Ebraham, ma nga God ala Aesak, ma nga God ala Jekob gila fo'asia 'ua.’ Ngaia nga God na nga ta'a gila mae 'amoe, tafe'ua ngaia God na ta'a gila momoori.” ");
INSERT INTO kwd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma nga alata nga oguogunga gila longoa nga 'ola lo'oo, gila ka 'alefo ba'ita na kwaifa'ananaunga aana. ");
INSERT INTO kwd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nga alata ni Farasii gila longoa la Jisas ngaia 'e fa'anotoa no'o Sadusi lo'oo 'ania nga lamadu'aanga aana, gila ka ogu mai te'ana. ");
INSERT INTO kwd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma te'e wane aga na'a ngaia 'e kwaifa'ananau na tagi, ngaia ka irito'ona fana 'ani fa'abobolosia la Jisas 'ania nga kwaiorisinga 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wane ni kwaifa'ananaunga, nga tagi 'uta'i ala Moses ne'e taringa'i maka talariufia tagi adauru te'efou?” ");
INSERT INTO kwd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma la Jisas ka lamadu'aa maka 'ilo'oo, ‘'Oi kwaimaa fana God amu, 'ania manatalamu te'efou, ma 'ania mangomu te'efou, ma 'ania funi'oonga amu te'efou.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ngaia no'o na tagi eteeta maka ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruana tagi 'e 'ilo'oo la'u mola, ‘'Oi kwaimaa fana ta'a te'efou 'ilaka'u la'u mola na 'i'oo kwaimaa famu 'i talamu.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nga tagi ala Moses, ma nga kwaifa'ananaunga na profet te'efou gila leka mai fa'asia rua tagi lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na alata ni Farasii gila ogu 'afuia la Jisas, ngaia 'e orisiga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nga Kraes, wane na God ngaia 'e eefasia fana fa'amoorilana ta'a, moru iiria ngaia te'e futa mai na fufutanga ani dai lo'oo?” Gila ka du'aa 'ilo'oo ana, “Nga Kraes te'e futa mai na fufutanga ala kiingi Defete.” ");
INSERT INTO kwd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui ma la Jisas ka orisiga la'u ma ka 'ilo'oo, “Lauta ngaia 'e futa mola na fufutanga ala Defete nga kiingi, 'uta'i no'o na nga Anoe 'ola Abu laka'u ngaia 'e talaia la Defete 'ani fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God ngaia 'e alafuu 'ilo'oo fana Alafa agu: 'Oi nana'i na gula le'a agu, moko ba'ita fe'eninau, mamania alata nau 'akui arua marimae amu 'ani lo'o 'i suri'o.’ ");
INSERT INTO kwd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","La Defete 'i talana na ngaia 'e iiria nga Kraes 'ania nga Alafa. Ngai lo'oo, nga Kraes ngaia 'amoe mola nga alakwa na fufutanga ala Defete. Ma Ngaia nga Alafa aana la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma nga alata no'ona, te'efuta wane aga 'ame to'omia no'o fana lamadu'aalana la'u 'ania te'efuta 'ola. Ma gila ka maila no'o fana orisilana la Jisas la'u. ");
INSERT INTO kwd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'I burina ni 'ola lo'oori, la Jisas 'e alafuu fana nga ta'a na gila ogu mai, ma nga fufu'iwane aana maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nga ta'a ni kwaifa'ananaunga na tagi, ma nga Farasii, gila to'o na tegelangaa fana nga kwaifa'ananaunga na tagi ala Moses. ");
INSERT INTO kwd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ngaia lo'oo, moru lo'o mola suriga, ma moru ka leka suria ni 'ola na gila iiria famooru. Tafe'ua ma moru sia agea mola nga 'ola na gila agea, tofuna gila 'ame agea mola 'ola na gila fata suria. ");
INSERT INTO kwd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gila ta'ua gila arua nga 'okoa ba'ita 'i onomana ta'a fana ngarilai. Ma gwa'a gila ma gila 'ame 'uri fana 'agila kwaibooni fana ngarilai fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ma gila agea ni 'ola te'efou fana nga ta'a 'ani agasiga maka madafia suria 'i gila ta'a gila le'a. Ma tani 'ola lo'oo na gila agea. Gila ka gaua 'i maana dalaga ma 'i nimaga ni 'ola na gila giria na Girigiringa Abu ai. Ma gila taia nga nigifana ruu aaga 'ani tekwa fana ta'a 'agila madafia gila ta'a gila odo 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma gila ka siria fana 'agila to'oru na lefu le'a na nga fafangalaa, ma lefu 'e le'a fana to'orunga 'ubulana 'ifi ni fo'anga. ");
INSERT INTO kwd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma gila ka siria 'e iiki nga ta'a 'agila fa'aba'itaga 'i maana usi'a, ma gila siria ta'a 'agila fata 'ilo'oo aga, ‘Wane kwaifa'ananaunga le'a.’ ");
INSERT INTO kwd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tafe'ua ma ngaia 'ame le'a fana nga wane 'ani fata 'ilo'oo amooru, ‘Wane kwaifa'ananaunga le'a,’ tofuna 'inau no'o nga wane ni kwaifa'ananaunga amooru, mai mooru nga fu'uwaiasina 'ubulana oguogunga na tagoto'onga. ");
INSERT INTO kwd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma moru sia iiria mola te'efuta wane ni kwaifa'ananaunga na fanua lo'oo 'i wado nga mama'a amooru. Te'e wane momola na Mama'a amooru na ngaia 'e nana'i mai 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma ngaia 'ame le'a fana te'efuta wane ngaia 'ani fata 'ilo'oo amu, ‘Alafa,’ tofuna mooru moru to'o mola na te'e alafa momola, ma ngaia no'o 'inau, nga Kraes, nga wane na God ngaia 'e firia fana fa'amoorilana ta'a. ");
INSERT INTO kwd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lauta te'efuta wane ngaia 'e siria 'ani ba'ita 'i laloamooru, ngaia 'ani 'ilaka'u nga wane ni taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma te'efuta wane ne'e fa'aba'itaa 'i talana, God te'e fa'asifoa. Ma te'efuta wane ne'e fa'asifoa 'i talana, God te'e lafua 'i langi.” ");
INSERT INTO kwd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ma la Jisas ka fata 'ilo'oo la'u, “Ngaia te'e ria 'e iiki famooru nga ta'a ni kwaifa'ananaunga na tagi ma mooru Farasii, mooru ta'a fana kotonga! Moru fono 'usia nga sinamaa na ba'itangaa na God fa'asia nga ta'a. Mooru la'u mola moru 'ame siria 'amoru ru'u 'ubulana ba'itangaa na God, ma moru to'o'usia ta'a na gila su'usu'u fana ru'unga. ");
INSERT INTO kwd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ngaia te'e ria famooru nga ta'a ni kwaifa'ananaunga na tagi ma mooru Farasii, moru ta'a ni kotonga! Mooru taunga'i tegela fana ngarilana lefu lo'oo te'efou, 'ubulana asi ma 'i su'e, fana darilana nga ta'a fana 'agila leka suria nga tagi ala Moses. Aia, ma nga alata ta'a lo'oo gila leka suri 'amooru, mooru moru sasari agau la'u mola aga fana lekanga fana lefu na kwa'ikwa'inga. Ma nga kwa'ikwa'inga aga te'e iiki maka riufia amooru suria nga falafala aga 'e ria maka riufi 'amooru te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ngaia te'e ria famooru, ma mooru moru 'ilaka'u no'o ta'a maaga 'e logo na gila talaia nga ta'a. Moru fa'ananau 'ilo'oo na ta'a, ‘Lauta wane 'e fa'ategelaa fataarunga'inga aana 'ania nga 'Ifi Abu na God, ngaia le'a no'o lauta ngaia 'ame agea 'olataa na ngaia 'e fataarunga'i fai. Tafe'ua lauta ngaia 'e fa'ategelaa fataarunga'inga aana 'ania nga goulo laka'u 'ubulana 'Ifi Abu na God, ngaia 'e ria 'e iiki fana mousilana fataarunga'inga aana.’ ");
INSERT INTO kwd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mooru ta'a maa mooru 'e logo, ma moru ka kwekweto 'e iiki. 'Olataa ne'e ba'ita, nga goulo 'amoe ma nga 'Ifi Abu na God ne'e agea goulo lo'oo 'e abu? Nga 'Ifi Abu na God ne'e ba'ita 'e riufia nga goulo! ");
INSERT INTO kwd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma moru ka fa'ananaua la'u mola nga ta'a 'ilo'oo, ‘Lauta nga wane ngaia 'e fa'ategelaa fataarunga'inga aana 'ania nga uumu, ngaia le'a mola lauta ngaia 'ame agea 'olataa na ngaia 'e fataarunga'i fai. Ma lauta ngaia 'e fa'ategelaa fataarunga'inga aana 'ania nga tabonga ne'e nana'i fofona uumu, ngaia 'e ria 'e iiki fana mousilana fataarunga'inga laka'u aana.’ ");
INSERT INTO kwd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Moru ta'a maa mooru 'e logo. 'Olataa ne'e ba'ita, tabonga 'amoe ma nga uumu na ngaia ne'e kwatea tabonga ne'e abu? Nga uumu ne'e ba'ita 'e riufia nga tabonga. ");
INSERT INTO kwd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngaia lo'oo, wane ni dai na ngaia 'e fa'ategelaa fataarunga'inga aana na uumu ni tabonga, ngaia 'e 'ilaka'u 'e fataarunga'i 'ania nga uumu ni tabonga ma nga tabonga na ngaia 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma ni dai na ngaia 'e fa'ategelaa fataarunga'inga aana 'ania 'Ifi Abu na God, 'ilo'oo ma ngaia 'e fataarunga'i 'ania 'Ifi Abu na God ma God la'u mola ne'e ngaia 'e nana'i 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma lauta te'efuta wane 'e fa'ategelaa fataarunga'inga aana 'ania 'i Langi, ngaia 'e fataarunga'i la'u mola 'ania furi'i to'orunga na God, ma ka fataarunga'i la'u mola 'ania God ne'e nana'i la'u mola 'i langi. ");
INSERT INTO kwd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ngaia te'e ria famooru nga ta'a ni kwaifa'ananaunga na tagi ma mooru nga Farasii, mooru nga ta'a fana kotonga. Moru kwatea tangafuru na 'ola fana God gwa'a nga 'ola sisika na'a moru kirua 'ubulana langa'a amooru fana fa'a masi'alana fangalaa amooru, ma moru 'ame manata 'abelo mola fana lo'onga suria kwaifa'ananaunga ba'ita na tagi ne'e 'ilo'oo: agelana ni 'ola te'efou ne'e odo fana ta'a, ma kwaimanadainga fana ta'a, ma tagoto'onga. Ngaia 'e le'a 'amooru agea ni 'ola lo'oo, fe'enia ni 'ola sisika 'ubulana tagi la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Moru 'ilaka'u nga ta'a maa mooru 'e logo na gila talaia nga ta'a. Mooru manata 'abelo fana daunga suria ni 'ola sisika 'ubulana tagi. Ma moru 'ame manata 'abelo mola fana ni 'ola ba'ita 'ubulana tagi. Alata moru agea 'ino'ona, ngaia 'e aga 'ilaka'u moru lafua mola nga simi fa'asia 'olataa na moru go'ufia, ma moru onomia mola nga kamel ba'iba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ngaia te'e ria famooru nga ta'a ni kwaifa'ananaunga na tagi ma mooru nga Farasii, mooru ta'a ni kotonga! Mooru moru 'abelo mola fana fa'akwarilana labena kakao ma lafa ni fangafanga. Gwe 'ino'ona ma 'ubulai 'e fongu no'o na takalafu. 'Ilaka'u nga falafala amooru fana kotelana ta'a ma fana sirilana 'ola famooru 'i talamooru. ");
INSERT INTO kwd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Moru Farasii lo'oo 'ilaka'u ta'a maa mooru ngaia 'e logo! Moru fa'akwaria 'ubulana nga kakao, 'ino'ona ma labena te'e kwari la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ngaia te'e ria famooru nga ta'a ni kwaifa'ananaunga na tagi ma mooru Farasii, mooru ta'a ni kotonga. Moru 'ilaka'u nga giru gwa'u na gila eelea gula 'i maa 'e aga 'e le'a, tafe'ua ma 'ubulai ngaia fongu no'o 'ania suri fe'enia nga nonina ta'a na gila mae, ma gila ka si'ini no'o. ");
INSERT INTO kwd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Ola lo'oo ngaia 'e kwala'imori no'o famooru, suria 'olataa na moru agea ngaia 'e aga le'a 'e iiki maana ta'a. Tafe'ua ma nga manatangaa amooru 'e ria 'e iiki, ma moru ka su'a na kotofilana ta'a. ");
INSERT INTO kwd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Ngaia te'e ria famooru nga ta'a ni kwaifa'ananaunga na tagi, ma mooru nga Farasii la'u mola, mooru ta'a fana kotonga! Moru iiria lauta moru nana'i na alata 'i na'o, moru sia kwaibooni mola na koko'o laka'u amooru fana kwa'ilana nga profet. Ma tala'ina lo'oo mooru moru arua mola fou 'e le'a fofona giru gwa'u na profet ma nga ta'a le'a no'ona 'i na'o fana 'ani aga 'ani le'a. ");
INSERT INTO kwd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Alata moru iiria gila nga koko'o amooru, ngaia faate'enia mooru moru futa 'i orioritana nga koko'o amooru na gila ria, na gila kwa'ia profet mai na'o. ");
INSERT INTO kwd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aia, ma lauta 'ino'ona, mooru moru fa'afua nga 'ola 'ame le'a na wawarifu mooru gila agea mai na'o! ");
INSERT INTO kwd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mooru 'ilaka'u nga waa. 'E 'ato 'e iiki fana 'amoru 'akwa fa'asia kwa'ikwa'inga lo'oo na God ne'e arua no'o famooru 'ubulana lefu na eele. ");
INSERT INTO kwd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tofuna ni 'ola lo'oo, nau ku iiria famooru, nau taku kwatea tani profet ma tani wane su'a 'ola ma tani ta'a ni kwaifa'ananaunga te'amooru. Ma tani ai aga tamoru kwa'iga, ma tani ai aga tamoru mudufafiga na 'ai folo. Ma tani ai aga tamoru gemasiga, ma tamoru kwa'iga 'ubulana 'ifi ni fo'anga amooru, ma tamoru tari kwairiu aga fa'asia 'ubulana fanua amooru. ");
INSERT INTO kwd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngaia lo'oo God te'e kwatea kwa'ikwa'inga famooru suria nga kwa'ilana nga ta'a lo'oo te'efou, eta mai na maenga ala Ebol, nga wane 'e odo, leleka mai maka nigi na maenga ala Sekaraea, nga wela ala Barakaea na moru kwa'ia maka mae galangia nga uumu 'ubulana 'Ifi Abu na God. ");
INSERT INTO kwd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nau ku iiria famooru, nga kwa'ikwa'inga fana maenga na ni wane lo'oori te'efou te'e nana'i fafia ta'a na alata lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma la Jisas ka aga kau fana fanua 'i Jerusalem, maka fata 'ilo'oo, ‘Ta'a 'i Jerusalem! Mooru laka'u moru kwa'ia nga profet, ma moru 'ui fou na nga ta'a ngaa'i laka'u God ngaia 'e alega mai famooru. Na alata 'e aula nau ku siria 'amoru leka mai te'agu fana 'aku aga suri 'amooru 'ilaka'u nga susuki ngaia 'e gwaesia nga dadalena 'i olofana 'aba'abana. Tafe'ua ma moru 'ame siria no'o. ");
INSERT INTO kwd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngaia lo'oo God te'e leka fa'asi amooru, maka rugasia no'o nga 'Ifi Abu amooru. ");
INSERT INTO kwd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma nau ku iiria famooru, moru sia agasi nau la'u mola, leleka maka nigi na alata na tamoru fata 'ilo'oo, ‘God, 'oi nanamate'enia nga wane na ngaia 'e leka mai 'ania nga tegelangaa amu.’” ");
INSERT INTO kwd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma 'i burina na la Jisas 'e fata 'ilo'oo 'e sui, ngaia ka leka no'o fa'asia 'Ifi Abu na God. Ma alata la Jisas 'e leka no'o, nga fufu'iwane aana gila leka mai te'ana, ma gila ka fata 'ilo'oo, “'Oi agasia madi nga 'Ifi Abu le'a lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","La Jisas ka fata 'ilo'oo faga, “'I'oo agasia ni 'ifi ba'ita lo'oo. Gwa'a me'e fou na 'Ifi Abu na God ma 'e sia nana'i mola 'i talafurina. Gila te'efou tagila tagala'i 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Burina, ma la Jisas ka fane gouna nga busu 'i Olif, ma nga alata ngaia 'e to'oru no'ona, nga fufu'iwane aana gila leka mai te'ana, ma gila ka nana'i fe'enia 'i talaga. Ma gila ka orisia la Jisas ma gila ka 'ilo'oo, “Alata 'uta'i na nga 'ola lo'oo 'i'oo iiria fameeru te'e lau mai, ma 'olataa na te'e lau fana 'ani faate'enia alata fana oringa amu mai fe'enia alata na fanua lo'oo 'i wado te'e sui ai?” ");
INSERT INTO kwd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","La Jisas ka lamadu'aga maka 'ilo'oo te'aga, “Moru aga suri 'amooru, suria ta'a 'e aula tagila leka mai 'ania latagu, ma tagila irito'ona fana kotofi lamooru, ma tagila fata 'ilo'oo, ‘Nau nga Kraes, nga wane laka'u God 'e firia.’ Ma nga alata gila agea nga 'ola lo'oo, nga ta'a 'e aula tagila tagoto'o na kotonga lo'oo aaga. Ma tamoru aga suri 'amooru, fa'asia te'efuta wane aga eta kotofi 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma tani 'ola ngaa'i la'u, tamoru longoa ringena fununga na fanua galangi, ma nga alafuunga suria fununga na tani fanua ngaa'i lalau la'u mai. Gwa'a 'ani 'ino'ona, ma moru sia manata 'abelo mola suria. 'Ola no'ona te'e nigi mai, tafe'ua ma ngaia 'ame faate'enia 'ua 'ita'ilana fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ni maa'e fanua ngaa'i tagila funuriga kwairiu, ma ni fanua ba'ita tagila funuriga kwairiu. Ma nga molo'ungaa ma nununu te'e to'o na ni fanua te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ni 'ola lo'oo ngai na etalana nonifiinga, 'ilaka'u nga noni ne'e nana'i ana wela ngaia 'e tala'ae 'ani wela fii.” ");
INSERT INTO kwd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na nga alata no'ona la'u mola, nga ta'a na maa'e fanua kwaitatari fofona fanua lo'oo 'i wado, tagila ma'asini te'enia mooru suria 'i mooru nga ta'a agu. Ma tani ta'a aga tagila gemasi 'amooru, ma tagila kwate 'amooru fana marimae amooru fana 'agila labusi 'amooru ma fana kwa'i lamooru. ");
INSERT INTO kwd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma ta'a 'e aula na gila tagoto'o agu, tagila rugasia mola nga tagoto'onga aga. Ma ta'a tagila aga mani aaga kwairiu. Ma tagila kwatea nga ta'a na God fana marimae aaga. ");
INSERT INTO kwd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma nga alata no'ona, ni profet kotokoto 'e aula tagila nigi mai, ma tagila talaia ta'a 'ani kuta, ma tagila kotofia ta'a 'e aula, ma tagila leka suria nga kwaifa'ananaunga aaga ne'e 'ame to'o. ");
INSERT INTO kwd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma tofuna gila agea ni 'ola 'e kuta 'e aula 'e iiki, nga kwaimaanga na ta'a 'e aula te'e waata'uta'u. ");
INSERT INTO kwd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gwa'a 'ani 'ino'ona, lauta ni dai na ngaia 'e tegela'a fana lekanga suria God leleka maka nigi 'i'isilana alata no'ona, God te'e fa'amooria. ");
INSERT INTO kwd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma Kwairiinga Le'a lo'oo suria ba'itangaa na God, tagila kwairii 'ania fofona fanua lo'oo 'i wado fana ta'a te'efou. Burina ma, 'ita'ilana fanua lo'oo 'i wado te'e bi'i nigi mai. ");
INSERT INTO kwd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma tamooru agasia nga 'Ola 'e ria na ngaia 'e fa'abiria nga 'Ifi Abu na God, ma ngaia te'e ula na lefu 'e abu 'ubulana 'Ifi Abu na God. Nga 'ola na la profet Daniel 'e fataarunga'i no'o mai suria 'i na'o (Nga alafuunga fana nga ta'a na ngaia 'e idumia ngaia 'e 'ilo'oo: 'Oi irito'ona fana su'a le'anga na nga fa'awatagalana 'ola lo'oo.) ");
INSERT INTO kwd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Alata moru agasia nga 'ola lo'oo 'ani nigi mai, nga ta'a na gila nana'i na nga gule'e lefu 'i Judea, gila 'agila 'akwa fana gouna nga busu. ");
INSERT INTO kwd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na nga alata no'ona, lauta te'efuta wane 'e nana'i mai gula 'i maa na 'ifi aana, ngaia te'e 'akwa 'afe'aferu, ma ngaia 'e sia madafia la'u fana ru'unga 'ubulana 'ifi aana fana ngarilana te'efuta 'ola aana. ");
INSERT INTO kwd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ni dai ne'e nana'i mai 'i 'ubulana langa'a, ngaia 'e sia ori la'u mai 'ifi fana te'efuta me'e ruu aana. ");
INSERT INTO kwd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kwaimanadainga ba'ita 'e iiki fana nga ta'ageni na gila guru'a, ma gila ka fa'asusua wela sisita na alata no'ona, suria ngaia te'e 'ato 'e iiki 'agila 'akwa 'afe'aferu. ");
INSERT INTO kwd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mooru moru fo'a ma moru ka soea God, fana ni 'ola lo'oo 'esia lau mola fana 'amooru 'akwa na alata na gwaringa, 'amoe ma nga Sabat. ");
INSERT INTO kwd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tofuna nga nonifiinga na fe'e gani no'ona, ngaia te'e ria maka riufia nga nonifiinga fofona fanua lo'oo 'i wado, 'ita 'ua mai na alata God ngaia 'e launge'enia nga fanua lo'oo 'i wado maka nigi na alata lo'oo. Ma te'efuta 'ola 'ilo'oo 'e sia lau la'u mai 'i buri. ");
INSERT INTO kwd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma lauta God 'ame 'oikouta na alata fana nonifiinga, ngaia 'ato fana te'efuta wane 'ani moori. Tafe'ua ma ngaia te'e 'oikouta na alata no'ona fana le'anga na ta'a na ngaia 'e firiga. ");
INSERT INTO kwd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kiu, lauta te'efuta wane 'e fata 'ilo'oo famooru, ‘Aga lo'oo. Nga Kraes talo'oo,’ 'amoe maka fata 'ilo'oo, ‘Agasia madi, ngaia taa loko'u.’ Moru sia lo'o mola ana. ");
INSERT INTO kwd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Suria nga ta'a ni kotonga te'e nigi mai, ma tagila fata 'ilo'oo, ‘Nau nga Kraes,’ ma nga ta'a ni kotonga ngaa'i tagila fata 'ilo'oo, ‘Nau nga profet.’ Ma tagila agea ni 'ola ni 'alefosilai ne'e ba'ita fana 'agila talai kuta na nga ta'a na God ngaia 'e firiga, tafe'ua ma ngaia 'e 'ato 'e iiki no'o faga. ");
INSERT INTO kwd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngaia lo'oo, gwa'a ni 'ola lo'oo gila 'ame nigi 'ua mai, nau ku kwairii no'o 'ania famooru 'i na'o, fana 'amoru su'aai. ");
INSERT INTO kwd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“Na nga alata nau, nga Wela na Wane, nau 'aku ori mai, ta'a te'efou tagila agasi nau. Ngaia 'e 'ilaka'u la'u mola na moru agasia kwangakwanga alata ngaia 'e kwanga mai tata'elana sina ne'e leka maka nigi na sulana sina 'ubulana lalo. Ngaia lo'oo, lauta tani ta'a ngaa'i gila fata 'ilo'oo famooru, ‘Kraes ngaia 'e nana'i 'ubulana gule'e lefu 'e langalanga,’ moru sia leka mola na lefu no'ona. Lauta tani ta'a ngaa'i gila fata 'ilo'oo famooru, ‘Kraes 'e nagwa 'i lo'oo,’ moru sia tagoto'o mola na alafuunga 'ino'ona. ");
INSERT INTO kwd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Nga orilagu mai te'efuta wane 'esia talafia mola, ma te'e 'ilaka'u la'u mola na nga langasi ba'ita ngaia 'esia talafia mola te'efuta 'ola 'e mae.” ");
INSERT INTO kwd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sui ma la Jisas 'e fata la'u maka 'ilo'oo, “Burina alata nga nonifiinga lo'oori 'e sui mola, God te'e to'ofonosia nga sisina ma nga singari, gala sia lala mola. Ma God te'e agea nga buruburu 'agila 'esiga fa'asia lalo. Ma God te'e agea ni 'ola 'i langi, 'agila leka kuta fa'asia talafuriga. ");
INSERT INTO kwd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Burina ni 'ola lo'oo, nga ma'etooto na orilagu mai te'e bi'i faata'i mai 'ubulana lalo. Ma nga alata no'ona la'u mola, nga ta'a te'efou fofona fanua lo'oo 'i wado, tagila aani ma gila ka agasia nau ku ori mai fofona kofa 'ubulana lalo, mai nau taku leka mai fe'enia tegelangaa ma nga kwangakwanganga ba'ita agu. ");
INSERT INTO kwd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na alata no'ona, nau taku kwatea mai nga enselo agu 'ania ufilana nga bungu ne'e aani 'e ba'ita fana ogulana nga ta'a agu te'efou na 'inau ku firiga. Tagila ogua mai ta'a agu te'efou fa'asia nga fanua te'efou fofona fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sui ma la Jisas ka fata 'ania tarifulaa 'ilo'oo, “Mooru manata madi suria nga figi. Alata moru agasia nga kabena ngaia 'e ula fooru, moru su'aai nga alata fana nga 'ago'agonga ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Maka 'ilo'oo la'u mola, alata moru agasia nga nonifiinga lo'oori te'efou te'e nigi mai, moru su'aai nga orilagu mai ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nau ku iiria nga 'ola 'e to'o famooru, ta'a te'efou na gila momoori na alata lo'oo, gila sia mae mola 'i na'ona ni 'ola lo'oo te'efou 'ani nigi mai. ");
INSERT INTO kwd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ni 'ola te'efou 'i lalo ma fofona fanua lo'oo 'i wado tagila sui. Tafe'ua ma nga fatalagu lo'oo ngaia 'esia sui mola.” ");
INSERT INTO kwd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Te'efuta wane 'ame su'a na alata nau 'aku ori mai ai. Gwa'a enselo ma gila 'ame su'a la'u mola ai, ma 'inau, nga Wela na Wane, mai nau ku 'ame su'a la'u mola ai. Te'e God na Mama'a na 'i ngaia 'e su'a no'o ai. ");
INSERT INTO kwd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nga orilagu mai te'e 'ilaka'u nga 'ola laka'u 'e lau na alata ala Noa. ");
INSERT INTO kwd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na nga alata laka'u, 'i na'ona nga afe ba'ita laka'u, nga ta'a gila keto ma gila ka go'u, ma nga ta'a gila ka fuageni ma gila ka kwatea geni kwairiu, leleka maka nigi mola na alata laka'u la Noa ngaia 'e fane 'ubulana nga faka ba'ita laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma gila bobolosia mola 'olataa na te'e nigi mai, leleka maka nigi na alata nga afe ba'ita laka'u 'e nigi, maka feega no'o. Ma ngaia te'e lau la'u mola 'ilo'oo na alata nau 'aku ori mai ai. ");
INSERT INTO kwd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na alata no'ona, rua wane tagala taunga'i 'ubulana nga langa'a. Nau taku ngaria te'e wane ngaa'i fe'eni nau, ma nga wane ngaa'i te'e ole. ");
INSERT INTO kwd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma rua noni la'u mola tagala taunga'i oguogu na fangalaa, ma te'e noni ngaa'i nau taku ngaria, ma ruana te'e ole. ");
INSERT INTO kwd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Moru aga aga le'a, suria moru bobolosia nga gani 'uta'i na nau, nga Alafa amooru, nau taku nigi mai ai. ");
INSERT INTO kwd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Moru manata to'ona nga 'ola lo'oo, lauta nga wane ba'ita na 'ifi 'e su'a mola na alata nga wane beriberi 'ani nigi mai ai, ngaia te'e aga aga le'a ma ngaia 'esia alamia mola wane beriberi lo'oori 'ani ru'u mai 'ubulana 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ngaia lo'oo, mooru moru kwaimamani la'u mola, suria nau taku nigi mai na alata na moru 'ame su'aai.” ");
INSERT INTO kwd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma la Jisas ka fata 'ilo'oo la'u fana nga fufu'iwane lo'oo aana, “Mooru 'amoru 'ilaka'u nga wane ni taunga'inga na ngaia 'e su'a'ola ma ngaia ka taunga'i 'e odo. Ma nga wane ba'ita ka arua ngaia 'ani aga suria nga ta'a ni taunga'inga aana, maka kwatea nga fangalaa faga na alata fana kwatelana fangalaa. ");
INSERT INTO kwd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aile'anga fana nga wane ni taunga'inga lo'oori na wane ba'ita ngaia 'e to'odaria 'e agea ni 'ola lo'oo, alata na ngaia 'e nigi mai 'ifi aana! ");
INSERT INTO kwd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nau ku iiria nga 'ola 'e to'o famooru, nga wane ba'ita ngaia te'e arua ngaia 'ani aga suria ni 'ola lo'oo aana te'efou. ");
INSERT INTO kwd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Tafe'ua ma, lauta ngaia nga wane ni taunga'i 'e ria, ngaia te'e manata 'ilo'oo, ‘Nga wane ba'ita agu, nigilana mai ngaia 'e lalau 'ua.’ ");
INSERT INTO kwd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma ngaia ka tala'ae mola fana kwa'ilana nga ta'a ni taunga'inga, ma ngaia ka nana'i ni fanganga mola maka go'u ngenge'a mola fe'enia ta'a ni go'unga. ");
INSERT INTO kwd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sui ma nga wane ba'ita te'e nigi mai na gani na ngaia 'ame kwaimamani ai, ma nga alata na ngaia 'e bobolosia mola. ");
INSERT INTO kwd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nga wane ba'ita lo'oo ana te'e kwatea nga kwa'ikwa'inga ba'ita fana, maka arua fe'enia ta'a ni kotonga. Ma alata ngaia 'e nana'i na lefu no'ona, ngaia te'e aani maka giri nifo, tofuna ngaia 'e nonifii 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma la Jisas ka fata 'ilo'oo la'u, Na nga alata na 'inau 'aku ori la'u mai, nga ba'itangaa na God te'e 'ilaka'u nga akwale'e geni lari'i na gila ngaria no'o nga uunu aga, ma gila ka kwaimamani fana nga alakwa fooru na te'e leka mai 'ani talaiga fana 'ubulana nga fafangalaa na fuageninga. ");
INSERT INTO kwd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma nga nima geni lari'i ngaa'i gila kakakula, ma nga nima ai ngaa'i gila ka manata'a. ");
INSERT INTO kwd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ni geni lari'i lo'oo gila kakakula gila ngaria nga uunu aaga, tafe'ua ma gila 'ame ngaria mola nga oel na ngaia 'e to'omia fana fa'anulalana uunu aaga fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma ni geni lari'i na gila manata'a gila ngaria nga botele oel ba'ita fe'enia nga uunu aaga. ");
INSERT INTO kwd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma nga alakwa fooru lo'oo ngaia 'ame nigi 'aferu, ma ni geni lari'i lo'oori, nga maaga 'e oloolo te'efou, ma gila ka eeno mola. ");
INSERT INTO kwd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma 'ubulana dalototo'o na logo, te'e wane 'e o'omae maka 'ilo'oo, ‘Nga alakwa fooru ngaia 'e nigi no'o mai! Moru leka, ma mooru ka daria.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nga akwale'e geni lari'i no'ona gila tata'e, ma gila ka sasari agau na nga uunu aaga. ");
INSERT INTO kwd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma ni geni lari'i lo'oo gila kakakula lo'oori gila ka fata 'ilo'oo fana ni geni lari'i lo'oo gila manata'a, ‘Moru kwatea nga oel fana uunu ameeru, suria nga oel ameeru 'e galangi ka sui no'o.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Tafe'ua ma gila lamadu'aga ma gila ka 'ilo'oo, ‘'Ato no'o, tofuna ngaia 'ame to'omia 'adauru te'efou. Moru leka na te'efuta 'ifi, fana 'amoru foria nga oel fana uunu amooru.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma alata gila leka fana 'agila foria la'u nga oel, nga alakwa fooru no'ona ngaia 'e nigi mai. Ma ni lari'i no'ona na gila sasari agau, gila ka leka no'o fe'enia fana nga fafangalaa na fuageninga. Ma gila ka fono no'o 'usia nga sinamaa. ");
INSERT INTO kwd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ma 'i burina, ni geni lari'i laka'u gila kakula, gila nigi la'u mola mai, ma gila ka 'ilo'oo, ‘Wane ba'ita! 'Oi 'ulasia kau nga sinamaa fameeru.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma nga alakwa fooru no'ona ka lamadu'aga maka 'ilo'oo, ‘'Ola 'e to'o lo'oo nau ku iiria famooru, nau ku bobolosi 'amooru.’” ");
INSERT INTO kwd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma la Jisas ka fa'asuia nga tarifulaa lo'oo maka 'ilo'oo, “Ngai lo'oo, mooru aga aga le'a, tofuna moru bobolosia nga gani ma alata na 'inau taku nigi la'u mai ai.” ");
INSERT INTO kwd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui ma la Jisas ka iiria la'u nga tarifulaa lo'oo fana nga fufu'iwane aana maka 'ilo'oo, “Na nga alata nau 'aku ori mai, nga ba'itangaa na God te'e 'ilaka'u te'e wane laka'u 'e sasari 'ani leka na lefu lalau, maka soea mai ni wane ni taunga'inga aana, maka iiria faga 'agila aga suria nga dari'olanga aana. ");
INSERT INTO kwd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma ngaia ka kwatea nima to'oni (5,000) seleni fana nga wane ngaa'i. Ma fana nga wane ngaa'i la'u, ngaia 'e kwatea rua to'oni (2,000) seleni. Ma fana nga wane ngaa'i la'u, ngaia 'e kwatea te'e to'oni (1,000) seleni fana. Ngaia 'e kwatea tooto'o fe'enia nga su'a'olanga aaga. Sui ma ngaia ka leka no'o na lelekanga aana. ");
INSERT INTO kwd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma nga wane ne'e ngaria nga nima to'oni seleni, ngaia 'e taunga'i 'ania, maka daria nga nima to'oni seleni ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma nga wane laka'u 'e ngaria rua to'oni seleni, ngaia 'e taunga'i la'u mola 'ania, maka daria nga rua to'oni seleni ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma nga wane laka'u 'e ngaria te'e to'oni seleni, ngaia 'e leka, maka 'eria nga kiru 'ubulana nga wado, maka na'agonia mola bata laka'u na wane ba'ita aana 'e kwatea fana. ");
INSERT INTO kwd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma burina nga alata 'ame lalau mola, nga wane ba'ita laka'u aaga 'e ori mai, ma ngaia 'e siria 'ani su'asuria ni wane ni taunga'inga aana gila taunga'i 'utaa 'ania bata laka'u aana. ");
INSERT INTO kwd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma nga wane laka'u 'e ngaria nima to'oni seleni, ngaia 'e ngaria mai nga nima to'oni seleni ngaa'i, maka fata 'ilo'oo, ‘Welakau, 'i'oo kwatea nima to'oni seleni fagu laka'u. 'Oi agasia madi, nau ku daria la'u nga nima to'oni seleni fe'enia.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma nga wane ba'ita aana 'e lamadu'aa maka 'ilo'oo, ‘'I'oo wane ni taunga'inga le'a agu. Nau ku su'asuria nau ku tagoto'o amu! 'I'oo taunga'i le'a 'ania nga 'ola sisika, ngaia lo'oo nau taku aru'o 'ani ba'ita fafia ni 'ola 'e aula. 'Oi leka mai, moko aile'a fe'eni nau.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma nga wane ne'e ngaria rua to'oni 'e nigi la'u mai ma ka fata 'ilo'oo, ‘Welakau, 'i'oo kwatea rua to'oni seleni fagu laka'u. 'Oi agasia madi, nau ku daria la'u nga rua to'oni seleni fe'enia.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma nga wane ba'ita aana ka lamadu'aa maka 'ilo'oo, ‘'I'oo wane ni taunga'inga le'a agu, nau ku su'asuria nau ku tagoto'o amu! 'I'oo taunga'i le'a 'ania ni 'ola sisika. Ngaia lo'oo nau taku aru'o 'ani ba'ita fafia ni 'ola 'e aula. 'Oi leka mai, moko aile'a fe'eni nau.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sui ma nga wane laka'u 'e ngaria te'e to'oni seleni, 'e nigi mai. Ma ngaia ka to'ofono mola maka fata 'ilo'oo, ‘Welakau, nau ku su'aai 'i'oo nga wane 'i'oo 'inifou'u'u no'o. 'I'oo ngaria bata mola na taunga'inga na ta'a matari famu, ma 'i'oo goni'i mola ni 'ola famu na lefu na 'i'oo 'ame kirua. ");
INSERT INTO kwd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngaia lo'oo nau ku ma'u, ma kua leka ma kua na'agonia mola bata laka'u amu 'ubulana wado. 'Oi agasia, bata laka'u amu ngaia lo'oo mola.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma nga wane ba'ita aana ka lamadu'aa maka 'ilo'oo, ‘'I'oo nga wane 'i'oo taunga'i 'e ria, moko lalakwa'a. 'I'oo su'a no'o ai na nau ku gonia ni 'ola na lefu na nau ku 'ame kirua, ma kua ngaria mola ni 'ola na ta'a matari. ");
INSERT INTO kwd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Lauta 'i'oo manata 'ilo'oo, 'uta'i na 'i'oo 'ame arua nga bata agu 'ubulana lefu ni aru batanga fana 'ani aula, maka nigi na alata nau ku ori mai ai, fana 'inau ku ngaria nga bata no'ona ma nga bata ni talenga la'u fe'enia?’ ");
INSERT INTO kwd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sui ma nga wane ba'ita lo'oori ka fata 'ilo'oo fana ni wane ni taunga'inga lo'oo aana, ‘Moru ngaria nga bata lo'oo fa'asia, ma moru ka kwatea fana nga wane ne'e to'o na nga 10,000 seleni. ");
INSERT INTO kwd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tofuna, te'efuta wane na ngaia 'e taunga'i le'a na 'olataa na ngaia 'e to'o ai, nau taku kwatea la'u ni 'ola ngaa'i la'u mola fana. Ma ni dai na ngaia 'ame taunga'i le'a 'ania 'ola, tafe'ua ngaia to'o na te'e 'ola sisika mola, nau taku lafua fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma nga wane ni taunga'inga lo'oo, moru to'osia 'i maa 'ubulana nga maa'e logo, lefu fana ta'a 'agila aaniaani ai ma fana nga giri nifonga ma nonifiinga ai.” ");
INSERT INTO kwd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","La Jisas ka fata 'ilo'oo la'u fana nga fufu'iwane aana, “Alata 'inau, nga Wela na Wane, 'aku ori la'u mai 'ania kwangakwanganga fe'enia nga enselo, nau taku nana'i na furi'i to'oto'orunga na Kiingi. ");
INSERT INTO kwd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma nga ta'a te'efou fa'asia fanua te'efou tagila ogu mai 'i na'ogu. Ma nau taku dalo'ia nga ta'a te'efou, 'ilaka'u nga wane laka'u ngaia 'e aga suria nga sifisifi 'e dalo'ia nga sifisifi fa'asia nga nanigot. ");
INSERT INTO kwd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma nau taku arua no'o ta'a 'e odo 'i gula le'a agu, ma nga ta'a 'e ria 'i gula moori agu. ");
INSERT INTO kwd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Sui mai nau taku fata 'ilo'oo fana ta'a na gila nana'i gula le'a agu, ‘Moru no'o na ta'a na Mama'a agu 'e nanamate'eni 'amooru. Moru ru'u mai 'i 'ubulana foufounga lo'oo ngaia 'e sasari agau ai famooru 'ita no'o mai na eetalana nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Suria alata nau ku molo'u, moru kwatea fangalaa fagu. Ma alata nau ku maarigo'u moru kwatea ka'o fagu. Ma alata nau ku leka mai fa'asia nga fanua matari, moru kwalo nau fana 'ubulana 'ifi amooru. ");
INSERT INTO kwd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma alata nga ruu 'e 'amoe agu, moru kwate ruu fagu. Ma alata nau ku fii, moru aga suri nau. Ma alata nau ku nana'i 'i 'ubulana 'ifi na lokafu, moru ma'ala to'ogu. ");
INSERT INTO kwd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sui ma ta'a 'e odo lo'oo tagila orisia ma gila ka 'ilo'oo, ‘Alafa, alata 'uta'i na meru agasia 'i'oo molo'u, ma meeru ka langoni'o? Alata 'uta'i na 'i'oo maarigo'u, ma meeru ka kwatea ka'o famu? ");
INSERT INTO kwd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma alata 'uta'i na 'i'oo nga wane ngaia 'e nigi fa'asia nga fanua matari, ma meeru ka soe'o 'i 'ifi ameru, ma alata 'uta'i na nga ruu 'e 'amoe amu ma meru ka kwatea ruu famu? ");
INSERT INTO kwd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma alata 'uta'i na meru agasia na 'i'oo fii 'amoe ma 'i'oo nana'i 'ubulana nga 'ifi na lokafu, ma meru ka nigi to'omu?’ ");
INSERT INTO kwd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mai nau taku lamadu'aga mai nau taku fata 'ilo'oo, ‘'Ola kwala'imori nau ku iiria famooru, alata moru agea te'efuta 'ola 'ilo'oo fana te'efuta wane, gwa'a ngaia 'ame to'o na lata, moru agea no'o fagu.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma nau taku fata 'ilo'oo fana nga ta'a na gila nana'i 'i gula moori agu, ‘Moru leka lalau kau fa'asi nau. God te'e kwa'i amooru. Ma tamoru leka 'ubulana nga eele ne'e nana'i firi, na God ngaia 'e sasari agau ai fana nga Saetan ma nga enselo aana. ");
INSERT INTO kwd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Suria nau ku molo'u, ma moru 'ame kwatea mola te'efuta fangalaa fagu. Ma alata nau ku maarigo'u, moru 'ame kwatea mola te'efuta ka'o fagu. ");
INSERT INTO kwd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma alata nau ku nigi mai, moru 'ame kwalo nau mola 'ubulana 'ifi amooru ma alata nga ruu 'e 'amoe agu, moru 'ame kwatea mola ruu fagu. Ma alata nau ku fii ma ku nana'i 'i 'ubulana nga 'ifi na lokafu, moru 'ame aga mola suri nau.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma tagila orisia ma gila ka 'ilo'oo, ‘Alafa, alata 'uta'i na meeru agasi'o, ma 'i'oo molo'u, ma 'i'oo maarigo'u, ma 'i'oo nga wane ninigi mola, ma nga ruu 'e 'amoe amu, ma 'i'oo fii la'u, ma 'i'oo nana'i 'i 'ubulana nga 'ifi na lokafu, mai meru 'ame kwaibooni mola amu?’ ");
INSERT INTO kwd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mai nau taku lamadu'aga ma ku 'ilo'oo, ‘'Ola kwala'imori nau ku iiria famooru, alata moru 'ame kwaibooni na ta'a na gila 'ame to'o na lata, mooru 'ame kwaibooni no'o agu.’ ");
INSERT INTO kwd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Sui ma gila ka leka no'o fana nga kwa'ikwa'inga ne'e nana'i firi, ma nga ta'a 'e odo gila ka leka no'o fana nga mooringa firi.” ");
INSERT INTO kwd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Alata la Jisas ngaia 'e kwaifa'ananau 'ania ni 'ola lo'oo 'e sui, ngaia ka fata 'ilo'oo fana nga fufu'iwane aana, ");
INSERT INTO kwd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mooru moru su'aai 'e sui no'o, Fafangalaa na Tala Riunga te'e eta no'o 'i fule'e. Ma na alata no'ona, tagila kwate nau, nga Wela na Wane, fana marimae agu, fana 'agila mudu'i nau na 'ai folo.” ");
INSERT INTO kwd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma na alata no'ona la'u mola, ni fataabu ba'ita, ma nga ta'a na'ona'o 'i Jiu, gila ka ogu 'ubulana 'ifi ba'ita na alafa ni suuabunga na latana la Kaeafas. ");
INSERT INTO kwd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma gila ka fadaa fana 'agila to'odaria te'efuta alata fana 'agila gema nagwa nagwa ala Jisas, ma 'agila ka kwa'ia. ");
INSERT INTO kwd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma gila ka fata kwairiu 'ilo'oo, “Dauru goru sia gemasia mola na alata na fafangalaa lo'oo fa'asia ta'a gila ta funuri 'adauru.” ");
INSERT INTO kwd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma la Jisas fe'enia nga fufu'iwane aana, gila leka kau fani Betani, ma gila ka nana'i 'ubulana 'ifi ala Saemon, nga wane laka'u nga kuu 'e lau ana 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na alata la Jisas ngaia 'e keto, te'e noni 'e leka mai te'ana fe'enia nga kokole 'ola ne'e kwanga'a le'a, ma ngaia fonu 'ania nga waiwai ne'e si'ini le'a, ma nga forilai 'e ba'ita 'e iiki. Ngaia 'e leka mai, maka 'irisia 'i gouna la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma nga alata nga fufu'iwane aana gila agasia, gila ka ogaria, ma gila ka fata 'ilo'oo laloaga 'i talaga, “'Ola 'e fe'ua na noni lo'oo 'e ngadaa waiwai le'a lo'oo? ");
INSERT INTO kwd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waiwai lo'oo, lauta 'aguru fa'afori 'ania, tagoru ngaria bata 'e ba'ita ai. Ma tagoru ngaria nga bata no'ona fana boonilana ta'a na gila galafa'a.” ");
INSERT INTO kwd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma tofuna la Jisas ngaia 'e su'a mola na 'olataa na gila fata suria, ngaia ka fata 'ilo'oo faga, “'Ola 'e fe'ua na moru fata 'ino'ona, ma moru ka fa'a'ekea noni lo'oo? 'Ola 'e le'a 'e ba'ita lo'oo 'ingaia 'e agea no'o fagu. ");
INSERT INTO kwd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nga ta'a galafa'a no'ona gila nana'i mola fe'enia mooru gani mai gani. Tafe'ua ma 'inau, te'e alata ko'uko'uta lo'oo nau taku nana'i fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma nga alata nga noni lo'oo ngaia 'e 'irisia nga waiwai lo'oo 'i nonigu, ngaia 'e sasari agau agu fana kwaiatolagu na nga gani na maenga agu. ");
INSERT INTO kwd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma nau ku kwairii te'amooru, nga to'oto'oni lefu na fanua lo'oo 'i wado na gila kwairii 'ania Kwairiinga Le'a lo'oo, tagila kwairii suria nga 'ola na'a noni lo'oo 'e agea fagu.” ");
INSERT INTO kwd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Burina ni 'ola lo'oo 'e sui mola, te'e wane na akwale'e wane ma ruaai na fufu'iwane ala Jisas, latana la Judas Iskariot 'e leka te'ana ni fataabu ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ka orisiga 'ilo'oo, “Lauta nau ku kwatea la Jisas famooru, 'olataa na tamoru kwatea fagu?” Ma gila ka idumia oru akwale'e fe'e seleni, ma gila ka kwatea fana. ");
INSERT INTO kwd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eta na alata no'ona, la Judas ka aga aga no'o fana nga me'e alata ne'e to'omia fana kwatelana la Jisas faga. ");
INSERT INTO kwd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na gani eteeta na fafangalaa fana 'anilana beret na'a nga iist 'e 'amoe ai, nga fufu'iwane ala Jisas gila leka mai te'ana, ma gila ka orisia 'ilo'oo, “'I fai na 'i'oo siria 'ameeru sasaria nga Fafangalaa na Tala Riunga famu ai?” ");
INSERT INTO kwd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma la Jisas ka fata 'ilo'oo faga, “Mooru leka kau fani Jerusalem. Alata moru nigi te'ana te'e wane na 'inau ku firia 'e sui no'o, tamooru fata 'ilo'oo te'ana, ‘Wane kwaifa'ananaunga ameeru, ngaia 'e iiria alata aana ngaia 'e galangi no'o. Ngaia fe'enia nga fufu'iwane aana tagila 'ania nga Fafangalaa na Tala Riunga 'i 'ifi amu.’” ");
INSERT INTO kwd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nga alata ni wane lo'oo gila leka, ma gila ka alafuu fe'enia nga wane no'ona 'ilaka'u la Jisas 'e iiria no'o faga, ma gila ka sasaria no'o nga fafangalaa no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma laulafi, la Jisas 'e to'oru 'i no'ona fana 'ani keto fe'enia nga akwale'e wane ma ruaai na fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma alata gila keto no'o, la Jisas ka fata 'ilo'oo faga, “'Ola kwala'imori nau ku iiria te'amoru, te'e wane 'i laloamooru te'e kwate nau fana marimae agu.” ");
INSERT INTO kwd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Alata nga fufu'iwane lo'oo ana gila longoa 'ola lo'oo, gila ka kwaimanadai ba'ita. Ma talate'e wane aga gila ka tala'ae na orisilana la Jisas ma gila ka 'ilo'oo, “Alafa, bala 'inau ta'ua lo'oo?” 'Igila te'efou na gila fata 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sui mala Jisas ka fata 'ilo'oo, “Te'e wane amooru, na ngaia te'e nonome'enia me'e beret aana 'i 'ubulana nga daoko fe'eni nau, ngaia na te'e kwate nau fana marimae agu. ");
INSERT INTO kwd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'I nau, nga Wela na Wane, nau taku mae 'ilaka'u nga Girigiringa Abu laka'u 'e iiria 'e sui no'o mai na'o. Ma kwaimanadainga ba'ita fana nga wane na ngaia 'e kwate nau fana marimae agu. Ngaia 'e le'a lauta nga wane no'ona ngaia 'ame futa.” ");
INSERT INTO kwd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nga alata no'ona, la Judas laka'u, nga wane na ngaia te'e kwatea la Jisas fana marimae aana, ngaia ka fata 'ilo'oo, “Wane kwaifa'ananaunga, bala 'inau ta'ua lo'oo welakau?” Ma la Jisas ka fata 'ilo'oo fana, “'I'oo 'i talamu na 'i'oo iiria no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma nga alata gila keto, la Jisas ka ngaria me'e beret, ma ngaia ka baole'a fana God, sui maka madanga, maka kwatea fana nga fufu'iwane aana, maka fata 'ilo'oo, “Moru ngaria, ma moru ka 'ania, ngaia no'o na labegu.” ");
INSERT INTO kwd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui ma ngaia ka ngaria nga kakao na waen, maka baole'a na God, sui maka kwatea faga, maka fata 'ilo'oo, Mooru te'efou, moru go'ufia. ");
INSERT INTO kwd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngaia no'o na 'abugu na God 'e fa'ategelaa 'ania nga fataarunga'inga fooru lo'oo, suria nga 'abugu te'e afe fana ta'a 'e aula, fana God 'ani 'olafanataa no'o na rianga aga. ");
INSERT INTO kwd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Ola 'e to'o lo'oo nau ku iiria famooru, nau ku sia go'ufia la'u nga waeni lo'oo leleka maka nigi na fe'e gani nau ku go'ufia nga waeni fooru fe'enia mooru 'i 'ubulana nga foufounga na Mama'a agu.” ");
INSERT INTO kwd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sui ma gila ka nguria fe'e nguu ni baatafengaa, ma gila ka leka no'o fana busu na gila fa'alataa 'ania 'i Olif. ");
INSERT INTO kwd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma la Jisas ka fata 'ilo'oo faga, Fe'e logo lo'oo, mooru te'efou no'o tamoru 'akwa fa'asi nau. Suria ngaia 'e iiria 'ubulana nga Girigiringa Abu laka'u 'e 'ilo'oo, ‘Nau taku kwa'ia wane na ngaia 'e aga suria nga sifisifi, ma nga sifisifi no'ona te'efou tagila tagala'i. ");
INSERT INTO kwd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gwa'a 'ani 'ino'ona, 'i burina nau taku tata'e la'u fana mooringa, mai nau taku leka no'o 'i na'o mooru fana 'i Galili.” ");
INSERT INTO kwd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma la Pita ka lamadu'aa maka 'ilo'oo, “Nau 'e 'ato no'o 'aku leka fa'asi'o, gwa'a ni wane ngaa'i gila leka fa'asi'o!” ");
INSERT INTO kwd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma la Jisas ka fata 'ilo'oo fala Pita, “Nau ku iiria famu, 'i na'ona nga susuki 'ani aani 'ubulana nga logo tala'ina, 'i'oo to'o iiria fana oru alata na 'i'oo bobolosi nau.” ");
INSERT INTO kwd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma la Pita ka lamadu'aa maka 'ilo'oo, “Gwa'a nau ku mae fe'eni'o, ngaia 'ato no'o 'aku iiria nau ku bobolosi'o.” Ma nga fufu'iwane lo'oo te'efou, gila ka fata la'u mola 'ilo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui ma la Jisas ka leka fe'enia nga fufu'iwane aana na nga lefu gila fa'alataa 'ania 'i Getsamani, ma ngaia ka fata 'ilo'oo faga, “Mooru nana'i 'i lo'oo na alata nau ku leka kau 'i loko'u fana 'aku fo'a.” ");
INSERT INTO kwd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma ngaia ka talaia la Pita, ma nga rua wela ala Sebedi fe'enia. Ma nga alata no'ona la Jisas ka kwaimanadai ba'ita ma nga manatalana ka logo no'o. ");
INSERT INTO kwd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma ngaia ka fata 'ilo'oo faga, “Nga mangogu ngaia 'e nonifii 'e ba'ita 'e iiki, ma ngaia 'e to'omia no'o kwa'ilagu. Moru nana'i lo'oo, ma moru ka aga aga na fo'anga fe'eni nau.” ");
INSERT INTO kwd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sui ma ngaia ka 'idu sisika la'u fa'asiga, maka bobouruuru leleka ma nga maadalana ka to'o no'o 'i wado, maka fo'a maka 'ilo'oo, “Ma'ana, lauta ngaia 'e wada'u mola, moko lafua nga nonifiinga lo'oo fa'asi nau. Tafe'ua, nga kwaisiriinga agu 'amoe, nga kwaisiriinga amu lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui ma la Jisas ka ori te'ana nga oru wane na fufu'iwane aana, maka agasia gila eeno mola, ma ngaia ka fata 'ilo'oo fala Pita, “Pita 'ae, fe'ua na moru 'ame aga fe'eni nau suria te'e alata sisita ngaa'i? ");
INSERT INTO kwd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Moru aga, ma moru ka fo'a fa'asia nga irito'onga eta riufi 'amooru. Tofuna mooru moru siria mola agelana ni 'ola 'e le'a, tafe'ua ma noni mooru ngaia 'e waata'uta'u 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","La Jisas 'e leka la'u, maka fo'a na ruana alata maka 'ilo'oo, “Ma'ana, lauta ngaia 'ame to'omia fana 'i'oo 'ani lafua nga nonifiinga lo'oo fa'asi nau, le'a mola, nau ku lo'o no'o suria nga kwaisiriinga amu.” ");
INSERT INTO kwd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma alata ngaia 'e ori te'ana nga fufu'iwane aana, ngaia 'e agasia gila eeno la'u mola, suria nga maaga 'e oloolo 'e iiki no'o. ");
INSERT INTO kwd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma la Jisas 'e leka la'u fa'asiga, maka fo'a la'u na oruna alata, maka iiria la'u mola te'e alafuunga laka'u. ");
INSERT INTO kwd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui ma ngaia ka ori la'u te'ana nga oru wane na fufu'iwane aana, maka fata 'ilo'oo faga, “Mooru moru eneeno 'ua lo'oo? Ma moru ka mamalo 'ua lo'oo? Aga madi, tagila kwatea nau no'o, nga Wela na Wane, 'ubulana nimana nga ta'a 'e ria. Nga alata no'ona lo'oo 'e nigi no'o! ");
INSERT INTO kwd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Moru tata'e, 'aguru leka no'o. Moru agasia nga wane laka'u ne'e kwate nau fana nga marimae agu, ngaia 'e nigi no'o mai.” ");
INSERT INTO kwd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma nga alata la Jisas 'e alafuu mola 'ua, la Judas, nga wane na akwale'e wane ma ruaai na fufu'iwane laka'u aana, 'e nigi no'o mai. Nga oguogunga ba'ita gila leka mai fe'enia fa'asia ni fataabu ba'ita, ma nga ta'a na'ona'o. Ma gila ka ngaria mai nga naifi ni fununga, ma nga 'aila'a. ");
INSERT INTO kwd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aia, la Judas 'e kwatea no'o maa'e tooto faga 'ina'o maka 'ilo'oo, “Nga wane na nau ku nono'ia, ngaia no'o na nga wane na moru siria 'amoru gemasia.” ");
INSERT INTO kwd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma 'afe'aferu mola ngaia ka leka odoodo no'o te'ala Jisas maka fata 'ilo'oo, “Wane ni kwaifa'ananaunga, aloalonga 'e nana'i fe'eni'o.” Sui ma ngaia ka nono'ia. ");
INSERT INTO kwd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma la Jisas ka fata 'ilo'oo fana, “Wane ni kwaimaanga, 'oi agea 'ola na 'i'oo leka mai fai 'aferu.” Sui ma ni wane lo'oo ka 'idu galangi mai, ma gila ka gemasia la Jisas, ma gila ka gema ngasingasi no'o ana. ");
INSERT INTO kwd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma te'e wane na fufu'iwane ala Jisas 'e lafua nga naifi ma ka kwa'ia no'o wane ni taunga'inga na alafa ni suuabunga, maka kwa'i tafia no'o nga gule'e aringa aana. ");
INSERT INTO kwd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma la Jisas ka fata 'ilo'oo fana, “'Oi arua nga naifi no'ona amu 'i furina, tofuna ni dai na gila funu 'ania nga naifi, tagila mae la'u mola na nga naifi na mae. ");
INSERT INTO kwd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nau ku siria 'i'oo 'ani su'aai, lauta nau ku soea Mama'a agu, ngaia 'e su'asuria 'ani kwatea mola mai nga tangale'e to'onga enselo 'afe'aferu fana 'agila fa'amoori nau! ");
INSERT INTO kwd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tafe'ua ma lauta nau ku soea nga enselo 'ani booni nau 'ilo'oo, ngaia 'e 'ato fana 'aku fa'ato'oa nga 'ola na nga Girigiringa Abu 'e iiria suria nga Kraes fana 'ani nonifii 'ania.” ");
INSERT INTO kwd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sui ma la Jisas ka fata 'ilo'oo fana ta'a lo'oo, “'Ino'ona ma, amooru madafia 'inau nga wane fana ngada 'olanga? Ngaia lo'oo moru nigi mai fe'enia nga naifi, ma nga 'aila'a fana daulagu? Aburu no'o mai, nau ku fa'ananaua mooru 'i 'ubulana nga 'Ifi Abu na God, ma moru 'ame gemasi nau mola. ");
INSERT INTO kwd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tafe'ua ni 'ola lo'oo te'efou 'e lau 'ilo'oo fana 'ani fa'ato'oa nga girigiringa na profet 'ubulana Girigiringa Abu.” Sui ma nga fufu'iwane aana te'efou gila 'akwasia, ma gila ka 'akwa no'o. ");
INSERT INTO kwd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma nga ta'a na gila gemasia la Jisas, gila ka talaia fana 'ubulana 'ifi ala Kaeafas, nga alafa ni suuabunga. Ma nga wane ni kwaifa'ananaunga na tagi, fe'enia nga ta'a na'ona'o, gila ogu 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma la Pita ngaia 'e 'isi buri no'o mai, maka nigi la'u mola 'i 'ubulana nga lalabata na nga 'ifi na alafa ni siuabu no'ona, maka ru'u kau 'ubulana lalabata, maka nana'i fe'enia ta'a ni folonga, fana ngaia 'ani agasia 'olataa na tagila agea ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma nga fataabu ba'ita, fe'enia nga ta'a ni fada'olanga te'efou, gila siria fana 'agila to'odaria tani alafuunga 'ame to'o suria la Jisas, ne'e to'omia 'agila kwa'ia du'ai. ");
INSERT INTO kwd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tafe'ua ta'a 'e aula na kotokotonga gila leka la'u mola mai fana 'agila fata fafia la Jisas, gila 'ame daria mola te'efuta 'ola. Ma 'i buri, rua wane ni kotonga gala tata'e mai, ma gala ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Nga wane lo'oo ngaia 'e alafuu 'ilo'oo, ‘Nau ku su'asuria 'aku osia nga 'Ifi Abu lo'oo na God, mai nau taku launga'i fooru la'u mola ai 'ubulana oru maa'e gani.’” ");
INSERT INTO kwd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sui ma nga alafa ni siuabu 'e tata'e, maka fata 'ilo'oo fala Jisas, ‘'Ino'ona ma, 'i'oo sia du'aa mola te'efuta 'ola, na ni 'ola 'e ria lo'oo gala iiria amu?” ");
INSERT INTO kwd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tafe'ua, mala Jisas ka noto mola. Ma nga alafa ni suuabunga ka fata 'ilo'oo la'u, “Nau ku orisi'o fana 'i'oo 'ani gwala 'ania latana God ne'e momoori, moko iiria fameeru lauta 'i'oo lo'oo nga Kraes, nga Wela na God.” ");
INSERT INTO kwd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","La Jisas 'e fata 'ilo'oo fana, “Ngaia no'ona 'i'oo iiria no'o. 'Ola kwala'imori nau ku iiria famooru, 'ita na alata lo'oo maka ori 'ala'a, tamoru agasi nau, nga Wela na Wane, nau ku to'oru 'i gula le'a na God ne'e tegela'a maka ba'ita, mai nau taku sifo mai fofona kofa 'i langi.” ");
INSERT INTO kwd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma nga alafa ni suuabunga no'ona, ngaia ka gaasia nga ruu tekwa aana 'ani faate'enia nga ogarianga aana, maka fata 'ilo'oo, “Goru 'ame siria la'u te'efuta wane 'ani alafuu fa'ato'oa la'u! Goru longoa te'efou no'o ngaia 'e fa'atooto'ome'enia no'o fe'enia God. ");
INSERT INTO kwd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Moru manata 'uta'i?” Ma gila lamadu'aa ma gila ka 'ilo'oo, “Ngaia to'omia ngaia 'ani mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sui ma gila ka ngisu 'usia maana, ma gila ka labusia. Ma tani wane ngaa'i gila ka fidaria, ma gila ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kraes, lauta 'i'oo no'o nga profet, 'oi iiria mai, ni dai lo'oo ngaia 'e fidari'o 'ilo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma la Pita ka nana'i 'ubulana lalabata, ma te'e wela geni lari'i ni taunga'inga 'e leka mai te'ana maka fata 'ilo'oo, “'I'oo wane la'u mola fe'enia la Jisas, nga wane lo'oo fa'asia 'i Galili.” ");
INSERT INTO kwd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma la Pita ka gwala 'i na'oga maka 'ilo'oo, “Nau ku 'ame su'asuria 'ola lo'oo 'i'oo iiria.” ");
INSERT INTO kwd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui ma, la Pita 'e leka maka nana'i galangia nga maa'e tatafa, ma te'e wela geni lari'i ni taunga'inga ngaa'i la'u 'e agasia, maka fata 'ilo'oo fana ta'a na gila nana'i no'ona, “Nga wane lo'oo ngaia 'e nana'i la'u mola fe'enia la Jisas, nga wane lo'oo fa'asia 'i Nasaret.” ");
INSERT INTO kwd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma la Pita ka gwalaa la'u mola, ma ngaia 'e gwala maka 'ilo'oo, “Nau ku tofe nau ku 'ame su'asuria nga wane no'ona!” ");
INSERT INTO kwd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma ngaia 'ame aburu mola 'i burina, nga ta'a na gila ula 'i no'ona, gila leka te'ala Pita, ma gila ka fata 'ilo'oo fana, “'I'oo la'u mola nga wane aga kwala'imori lo'oo no'o, suria nga ringena alafuulamu 'e fa'ato'oa no'o 'i'oo nga wane 'i Galili.” ");
INSERT INTO kwd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Alata no'ona ngaia ka gwala la'u maka 'ilo'oo, “Lauta nau ku koto, God te'e kwa'i nau. Nau ku 'ame su'asuria nga wane no'ona.” Na te'e alata no'ona mola, ma susuki 'e aani no'o. ");
INSERT INTO kwd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma la Pita ngaia ka manata to'ona alafuunga laka'u la Jisas 'e iiria, “'I na'o na nga susuki 'ani aani 'ubulana nga logo lo'oo tala'ina, 'i'oo to'o iiria oru alata na 'i'oo bobolosi nau. Alata la Pita 'e manata to'ona 'ola lo'oori, ngaia 'e ru'u kau 'i maa, maka aani ba'iba'ita no'o fe'enia kwaimanadainga. ");
INSERT INTO kwd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na 'usu'usugani kwa'aria mola, ni fataabu ba'ita te'efou fe'enia nga ta'a na'ona'o, gila ka fadaa no'o fana kwa'ilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sui ma gila gaua, ma gila ka talaia no'o te'ala Paelat, nga wane ba'ita fa'asia 'i Rom. ");
INSERT INTO kwd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma la Judas, nga wane laka'u 'e kwatea la Jisas fana marimae aana, alata ngaia 'e su'asuria gila 'efasia no'o la Jisas fana nga maenga, ngaia ka manata fa'aburi, maka ori fe'enia nga oru akwale'e fe'e seleni laka'u te'ana ni fataabu ba'ita ma nga ta'a na'ona'o lo'oo, maka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nau ku bu'ota'i mani no'o, suria nau ku kwatea no'o wane 'e odo fana kwa'ilana.” Ma gila lamadu'aa ma gila ka 'ilo'oo, “Nga 'abelongaa ameeru 'amoe no'o no'ona. Nga gula no'ona nga gula amu no'ona no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma la Judas 'e to'osia nga bata no'ona 'i 'ubulana nga 'Ifi Abu na God, maka leka no'o. Ngaia 'e leka kau 'i maa, maka ri'o no'o 'i talana. ");
INSERT INTO kwd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma ni fataabu ba'ita laka'u, gila ka ngaria nga bata no'ona, ma gila ka fata 'ilo'oo, “Ngaia 'ame odo na tagi adauru fana 'aguru arua no'o bata lo'oo fe'enia nga bata na nga 'Ifi Abu na God, tofuna bata lo'oo nga bata na kwa'ilana wane lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma gila alafuu 'e sui mola, ma gila ka ala fafia 'agila foria 'ania nga me'e wado, nga me'e wado na te'e wane ne'e launge'enia kakao. Ma gila ka bulote'enia wado lo'oo fana lefu fana arulana ta'a 'e mae na gila 'ame Jiu ai. ");
INSERT INTO kwd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tofuna gila foria wado lo'oori 'ania nga bata na gila ngaria fana kwa'ilana nga ta'a, gila ka fa'alataa wado lo'oo 'ania, ‘Wado na 'Abu’ leleka maka nigi tala'ina. ");
INSERT INTO kwd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lo'oo, gila fa'ato'oa alafuunga na profet la Jeremaea laka'u 'e fata 'ilo'oo, ‘Gila ngaria no'o oru akwale'e fe'e seleni laka'u, nga bata laka'u na ta'a 'i Israel gila foria 'ania nga wane, ");
INSERT INTO kwd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma gila ka kwatea fana forilana nga wado na wane 'e launge'enia kakao, 'ilaka'u God ngaia 'e iiria fagu.’ ");
INSERT INTO kwd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma la Jisas ka ula 'i na'ona la Paelat, nga wane ba'ita fa'asia 'i Rom. Ma la Paelat ka orisia maka 'ilo'oo, “'I'oo nga Kiingi 'i Jiu lo'oo?” La Jisas 'e lamadu'aa maka 'ilo'oo, “Ngaia no'ona 'i'oo iiria no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Alata ni fataabu ba'ita lo'oo, ma nga ta'a na'ona'o, gila aole'ekwala fafia la Jisas, ngaia 'ame lamadu'aga 'ania te'efuta alafuunga. ");
INSERT INTO kwd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sui ma la Paelat ka fata 'ilo'oo fana, “'I'oo 'ame longoa mola ni 'ola 'e ria aula lo'oo gila aole'ekwala 'ania fafi'o?” ");
INSERT INTO kwd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma la Jisas ngaia 'ame lamadu'aga mola 'ania te'efuta alafuunga. Ngaia na'a la Paelat 'e 'alefo ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aia, na nga Fafangalaa na Tala Riunga, wane ba'ita fa'asia 'i Rom, ngaia furifuri 'e rubea te'e wane 'i Jiu na gila siria fa'asia nga lokafu. ");
INSERT INTO kwd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma nga alata no'ona, te'e wane 'e ria 'e nana'i la'u mola 'ubulana 'ifi na lokafu na latana la Barabas, nga ta'a te'efou gila su'ana. ");
INSERT INTO kwd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngaia lo'oo, alata na ta'a lo'oo gila ogu mai, la Paelat 'e orisiga maka 'ilo'oo, “Ni dai na'a moru siria 'aku rubea famooru, la Barabas, 'amoe mala Jisas na gila fa'alataa 'ania nga Kraes?” ");
INSERT INTO kwd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngaia 'e fata 'ilo'oo, suria ngaia 'e su'aai nga ta'a na'ona'o 'i Jiu, gila kwatea la Jisas te'ana tofuna gila kwaifii'i mola ana. ");
INSERT INTO kwd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma alata la Paelat ngaia 'e nana'i na lefu fana kwaisufaingaa, nga noni aana 'e kwatea nga alafuunga te'ana maka 'ilo'oo, “'I'oo sia agea mola te'efuta 'ola na nga wane 'e odo no'ona. Suria nau ku eeno bole suria, ma kua nonifii ba'ita suria 'ubulana fe'e logo laka'u 'e sui.” ");
INSERT INTO kwd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma ni fataabu ba'ita, ma nga ta'a na'ona'o, gila alafuu 'i mangona nga ta'a lo'oo, fana 'agila soea la Paelat fana rubelana la Barabas, maka arua la Jisas fana maenga. ");
INSERT INTO kwd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma la Paelat 'e orisia nga oguogunga lo'oori la'u mola maka 'ilo'oo, “Ni dai na rua wane lo'oo na moru siria fana 'aku rubea?” Ma gila o'omae ma gila ka 'ilo'oo, “La Barabas!” ");
INSERT INTO kwd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","La Paelat ka orisia 'ilo'oo, “Ma 'olataa na nau taku agea ala Jisas, na gila fa'alataa 'ania nga Kraes?” Gila te'efou gila ka lamadu'aa 'ilo'oo, “'Oi mudu'ia na 'ai folo!” ");
INSERT INTO kwd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma la Paelat ka fata 'ilo'oo la'u, “'Olataa 'e ria na ngaia 'e agea?” Sui ma gila ka o'omae ba'ita ma gila ka 'ilo'oo, “Mudu'ia na 'ai folo!” ");
INSERT INTO kwd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma alata la Paelat 'e agasia ngaia 'e 'ato no'o fana 'ani agea no'o te'efuta 'ola, ma nga fununga 'e galangi ka eta no'o, ngaia 'e ngaria ka'o, maka narufia nga nimana 'i na'oga te'efou, maka fata 'ilo'oo, “Nau ku 'ame siria nga maenga na wane lo'oo. Gula amooru no'ona no'o.” ");
INSERT INTO kwd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nga ta'a te'efou gila lamadu'aa, ma gila ka 'ilo'oo, “Nga maenga aana te'e nana'i fafi 'ameeru, ma fafia nga ru'uru'ua ameeru.” ");
INSERT INTO kwd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aia, mala Paelat ka rubea kau la Barabas faga, maka alea nga ta'a ni fununga aana 'agila labusia la Jisas. Ma ngaia ka kwatea fana 'agila mudu'ia na nga 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma nga ta'a na fununga ala Paelat, gila talaia la Jisas 'ubulana nga 'ifi ala Paelat, ma nga ta'a ni mae auaula no'ona gila te'efou, gila ka ogu mai 'afuia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma gila ka ka'aia nga ruu aana, ma gila ka fa'aruufia 'ania ruu mekumeku'a. ");
INSERT INTO kwd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui ma gila ka ngaria nga 'elegou na kwalo ngangala'a, ma gila ka arua 'i gouna, ma gila ka kwatea nga lalana 'ai fana 'ani gema ai 'ania gule'e nima le'a aana, 'ilaka'u ngaia nga kiingi. Ma gila ka bobouruuru ana, ma gila ka doodoo ana, ma gila ka 'ilo'oo, “'I'oo momoori firi nga Kiingi 'i Jiu.” ");
INSERT INTO kwd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma gila ka ngisufia, ma gila ka ngaria nga lalana 'ai laka'u, ma gila ka kwa'ia na gouna. ");
INSERT INTO kwd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Alata gila doodoo ana 'e sui, gila ka ka'aia la'u mola nga ruu mekumeku'a laka'u, ma gila ka fa'aruufia la'u 'ania ruu aana, sui ma gila ka talaia kau fana nga mudu'ilana na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma alata gila leka no'o kau fa'asia 'i Jerusalem, gila ka agasia te'e wane fa'asia 'i Saerin, na latana la Saemon. Ma nga ta'a ni fununga lo'oo, gila ka su'unge'enia 'ani ngaria nga 'ai folo lo'oo ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sui ma gila nigi na lefu gila fa'alataa 'ania 'i Golgota. (Nga fa'aladamilana alafuunga lo'oo 'e 'ilo'oo, ‘Nga lefu na gouna wane 'e mae.’) ");
INSERT INTO kwd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'I no'ona, gila kwatea nga waeni na gila dolaa 'ania 'ai ukwala fana la Jisas. Ma la Jisas ka go'u to'ona, ma ngaia 'ame onomia no'o. ");
INSERT INTO kwd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sui ma gila ka mudu'ia na 'ai folo, ma gila ka masa 'ania nga 'ola 'ilaka'u daisi fana 'agila to'ole'enia nga ruu aana. ");
INSERT INTO kwd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sui ma gila ka to'oru 'i wado, ma gila ka aga aga mola 'afuia. ");
INSERT INTO kwd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma 'i gouna nga 'ai folo gila arua nga girigiringa 'ilo'oo, “Nga wane na la Jisas, nga Kiingi 'i Jiu.” ");
INSERT INTO kwd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sui ma gila ka mudu'ia la'u mola rua wane beriberi na rua 'ai folo ngaa'i, nga wane ngaa'i na gula le'a, ma nga wane ngaa'i na gula moori aana. ");
INSERT INTO kwd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma nga ta'a lo'oo gila riu, ma gila ka 'asua gouga, ma gila ka fata sifo no'o ala Jisas, ma gila ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“'I'oo iiria 'i'oo to'o osia nga 'Ifi Abu na God, moko launga'i fooru la'u mola ai 'ubulana oru maa'e gani. Aia, lauta 'i'oo nga Wela na God, 'oi fa'amoori'o madi 'i talamu, moko sifo mai fa'asia nga 'ai folo no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma ni fataabu ba'ita gila ka doodoo la'u mola ana 'ilo'oo, fe'enia nga ta'a ni kwaifa'ananaunga na tagi, ma nga ta'a na'ona'o, ");
INSERT INTO kwd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ngaia laka'u 'e fa'amooria nga ta'a matari, ma ngaia 'ame to'omia 'ani fa'amooria mola ngaia 'i talana. Lauta ngaia nga kiingi adauru ta'a 'i Jiu, ngaia 'ani sifo mai fa'asia nga 'ai folo, fana 'aguru tagoto'o ana. ");
INSERT INTO kwd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ngaia 'e tagoto'o na God, maka fata 'ilo'oo, ‘Nau na nga Wela na God.’ Goru aga aga madi fana 'agoru agasia lauta God te'e fa'amooria ta'ua.” ");
INSERT INTO kwd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma nga rua wane ria na gila mudu'i 'agaa'a fe'enia, gala ka fata sifo la'u mola ana. ");
INSERT INTO kwd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'E 'ita na dalototo'o na gani, leleka maka nigi oruna mae'ola na sina laulafi, nga logo 'e logo fafia nga fanua te'efou 'i Israel. ");
INSERT INTO kwd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma laulafi, la Jisas 'e o'omae ba'ita maka 'ilo'oo, “'Ilae, 'Ilae, lema sabakatani.” Nga manatangaa fai ngaia 'e 'ilo'oo, “God agu, God agu, 'uta'i na 'i'oo rugasi nau?” ");
INSERT INTO kwd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma tani ta'a na gila nana'i galangia, gila longoa, ma gila ka fata 'ilo'oo, “Ngaia 'e soea la Elaeja.” ");
INSERT INTO kwd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma tani wane aga gila totola no'o ma gila ka ngaria mai nga 'ola 'ilaka'u nga ruu ne'e ogute'enia nga ka'o, maka fa'afongua 'ania nga waeni ukwala, maka arua na 'ai, maka kwatea fana, 'ani go'ufia. ");
INSERT INTO kwd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma tani ta'a ngaa'i la'u gila ka 'ilo'oo, “Dauru goru mamanoto madi, 'aguru agasia lauta la Elaeja ngaia te'e nigi mai fana fa'amoorilana ta'ua.” ");
INSERT INTO kwd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sui ma, la Jisas ka o'omae ba'ita la'u, maka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma ruu ba'ita ne'e bokota nga tofi 'ifi abu 'ubulana 'Ifi Abu na God 'e gaa na rua gule'e 'ola, 'ita mai 'i gouna leleka ka nigi 'i wado. Ma nga nununu ka 'asu, ma nga fou ka foga, ");
INSERT INTO kwd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma tani giru gwa'u ngaa'i gila ka 'ulasi, ma nga ta'a 'e aula na ta'a na God na gila mae, gila ka moori la'u. ");
INSERT INTO kwd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma gila ka ru'u fa'asia giru gwa'u aaga. Ma burina la Jisas 'e tata'e la'u, ma gila ka ru'u 'ubulana fanua 'i Jerusalem. Ma nga ta'a 'e aula gila ka agasiga. ");
INSERT INTO kwd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma nga wane na'ona'o na ta'a ni fununga, fe'enia nga ta'a ni fununga aana na gila aga 'afuia la Jisas, na alata gila agasia nga nununu, ma ni 'ola kwaitatari te'efou lo'oo 'e lau, gila ka ma'u ba'ita ma gila ka fata 'ilo'oo, “Ngaia to'o no'o, ngaia nga Wela na God.” ");
INSERT INTO kwd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma ni noni 'e aula la'u mola na gila leka 'i burina la Jisas 'ita mai 'i Galili ma gila kwaibooni ana, gila nana'i la'u mola 'i no'ona, ma gila ka aga aga lalau la'u mola mai. ");
INSERT INTO kwd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te'e noni aga ni Meri fa'asia 'i Magdala, ma ni Meri nga tete'e ala Jemes ma la Josef, ma noni ala Sebedi, ma tani noni ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nga alata ngaia 'e laulafi no'o maka galangi 'ani logo no'o, te'e wane dari'ola'a ngaia 'e leka mai. Ngaia nga wane fa'asia fanua 'i Arimetea, ma nga latana la Josef. Ma ngaia nga wane na fufu'iwane ala Jisas la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma ngaia 'e leka te'ala Paelat, maka soea nga nonina la Jisas. Ma la Paelat ka iiria 'agila kwatea fana. ");
INSERT INTO kwd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma la Josef ka ngaria no'o nonina la Jisas, maka 'afua 'ania nga ruu kwakwao'a fooru. ");
INSERT INTO kwd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sui ma ngaia ka arua 'ubulana nga giru gwa'u fooru aana na gila takwea 'i 'ubulana nga fou ba'ita. Sui ma ngaia ka bokota no'o maana nga giru gwa'u no'ona 'ania nga baba'e fou ba'ita, sui maka leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ni Meri fa'asia 'i Magdala, ma ni Meri ngaa'i la'u, gala nana'i 'i maa na nga giru gwa'u no'ona. ");
INSERT INTO kwd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma na fe'e gani 'i burina, nga Sabat, ni fataabu ba'ita, ma ni Farasii, gila ogu fana fatanga fe'enia la Paelat. ");
INSERT INTO kwd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma gila ka fata 'ilo'oo fana, “Welakau, 'imeeru meru manata to'ona alata wane ni kotonga lo'oo ngaia 'e momoori 'ua, ngaia 'e fata 'ilo'oo, ‘Nau taku moori la'u na oruna gani.’ ");
INSERT INTO kwd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aia, 'Oi kwairii te'ana ni wane amu 'agila leka, ma gila ka folo 'afuia nga giru gwa'u na wane mae lo'oo leleka maka nigi na oruna gani. Ngaia 'ame le'a fana nga fufu'iwane aana 'agila ngaria nga nonina, ma gila ka na'agonia, ma gila ka kotofia ta'a, ma gila ka iiria la Jisas ngaia 'e moori la'u mola. Lauta gila koto 'ilo'oo, ngaia te'e ria 'e riufia nga kotonga laka'u ngaia 'e iiria mai na'o.” ");
INSERT INTO kwd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma la Paelat ka 'ilo'oo te'aga, “Lauta 'ino'ona, tamooru eefasia tani wane ni fununga lo'oo agu, fana 'agila leka ma gila ka folo 'afuia, ma gila ka folo le'a 'afuia nga giru gwa'u no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma nga alata fataabu ba'ita, ma ni Farasii gila longoa ni 'ola lo'oori, gila ka sasari agau no'o, ma gila ka leka no'o fana nga giru gwa'u no'ona. Ma alata gila nigi te'ana giru gwa'u no'ona, gila ka arua no'o maa'e tooto na giru gwa'u no'ona, fana lauta te'efuta wane 'idua nga baba'e fou na giru gwa'u no'ona, ma gila ka su'aai. Na nga alata no'ona la'u mola, gila ka arua no'o ta'a ni folonga ai. ");
INSERT INTO kwd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","'I burina nga Sabat, nga gani na mamalongaa, alata ngaia 'e kwa'aria mola 'ua na nga Sande 'usu'usugani, ni Meri fa'asia 'i Magdala, ma ni Meri ngaa'i la'u, gala ka leka te'ana nga giru gwa'u laka'u fana 'agala agasia. ");
INSERT INTO kwd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma gala lebe ma nga nununu ba'ita ngaia 'e 'asu, ma nga enselo na God 'e sifo mai fa'asia 'i langi, maka geua nga baba'e fou laka'u fa'asia maana nga giru gwa'u laka'u, maka to'oru no'o 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ngaia 'e sinasinalo'a maka 'ilaka'u kwangakwanga ma nga ruu aana 'e kwakwao'a te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma nga alata ni wane ni folonga gila agasia, gila ka ma'u ba'ita, ma gila ka lebelebe no'o, ma gila 'esiga, ma gila ka 'ilaka'u no'o nga wane 'e mae. ");
INSERT INTO kwd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma nga enselo no'ona ka fata 'ilo'oo fagaa'a, “Molo sia ma'u mola. Nau ku su'aai moo'o molo aga 'ofia la Jisas laka'u gila kwa'ia na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngaia 'ame nana'i no'o 'i lo'oo. Ngaia 'e moori no'o 'ilaka'u laka'u ngaia 'e iiria famooru. Molo leka mai 'i lo'oo, ma molo ka agasia lefu laka'u ngaia 'e eeno ai. ");
INSERT INTO kwd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aia, molo leka 'aferu no'o, ma molo ka kwairii 'ilo'oo te'ana fufu'iwane aana, ‘La Jisas ngaia 'e moori no'o, ma ngaia 'e leka no'o 'i na'o moru fana 'i Galili, ma tamoru agasia no'ona no'o.’ Ma molo ka manata to'ona 'ola lo'oo nau ku iiria te'amoo'o.” ");
INSERT INTO kwd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sui ma, gala ka leka 'afe'aferu no'o fa'asia giru gwa'u no'ona fe'enia ma'unga. Tafe'ua, gaa'a gala aile'a ba'ita. Ma gala ka totola no'o fana 'agala kwairii te'ana nga fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma nga alata no'ona, la Jisas 'e faata'i te'agaa'a, maka fata 'ilo'oo, “Nga aloalonga 'e nana'i fe'eni 'amoo'o.” Ma gala ka leka mai te'ana, ma gala ka bobouruuru ana, ma gala gema 'i 'a'aena, ma gala ka fa'aba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma la Jisas ka fata 'ilo'oo fagaa'a, “Molo sia ma'u mola. Molo leka, ma molo ka kwairii te'ana ni wane ni futanga agu, fana 'agila leka fana 'i Galili. Mai no'ona tagila agasi nau no'o ai.” ");
INSERT INTO kwd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nga alata rua geni lo'oo gala ori no'o suria nga tala, tani wane na ta'a ni folonga no'ona, gila leka no'o fa'asia giru gwa'u ala Jisas, ma gila ka ori no'o fani Jerusalem. Alata gila nigi na fanua ba'ita no'ona, gila ka alafuu no'o suria ni 'ola te'efou na gila agasia te'ana fataabu ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma alata ni fataabu ba'ita, ma tani ta'a na'ona'o ngaa'i la'u 'i Jiu, gila alafuu oguogu 'e sui mola, gila ka kwatea bata ba'ita fana ta'a ni folonga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Alata gila kwatea bata lo'oo fana ta'a ni folonga lo'oo, gila ka fata 'ilo'oo, “Moru koto 'ilo'oo fana ta'a lo'oo te'efou, ‘Alata meru eeno 'ubulana logo, nga fufu'iwane ala Jisas gila leka mai, ma gila ka beria mola nga nonina.’” ");
INSERT INTO kwd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma nga ta'a na'ona'o lo'oo, gila fata la'u mola 'ilo'oo, Lauta la Paelat ngaia 'e longoa nga 'ola lo'oo, moru sia manata 'abelo mola, suria tameru fa'aodoa te'ana, fana ngaia 'e sia ogaria mola famooru.” ");
INSERT INTO kwd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma alata wane ni folonga lo'oo gila ngaria bata lo'oori 'e sui mola, gila ka leka no'o, ma gila ka agea no'o ni 'ola lo'oo fataabu ba'ita ma nga ta'a na'ona'o 'i Jiu, gila iiria faga. Ma nga alafuunga lo'oo na kotonga 'e talofia te'efou no'o nga ta'a 'i Jiu, leleka maka nigi tala'ina. ");
INSERT INTO kwd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nga akwala ma te'e wane na fufu'iwane aana gila leka no'o fana gule'e lefu 'i Galili, fana nga busu na la Jisas 'e iiria faga fana 'agila leka fai. ");
INSERT INTO kwd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma alata gila agasia la Jisas, gila ka fa'aba'ita, tafe'ua ma tani wane aga gila manata ruarua mola 'ua. ");
INSERT INTO kwd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma la Jisas 'e leka mai te'aga, maka fata 'ilo'oo, “God ngaia 'e kwatea no'o nga tegelangaa te'efou 'i langi ma fofona fanua lo'oo 'i wado fagu. ");
INSERT INTO kwd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngaia lo'oo, moru leka, ma moru ka fa'ananaua nga ta'a te'efou na fanua lo'oo te'efou, fana 'i gila nga ta'a ngaa'i na fufu'iwane agu la'u mola. Ma moru naruabu aga 'ania latana nga Mama'a, ma nga Wela, ma nga Anoe 'ola Abu. ");
INSERT INTO kwd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma mooru fa'ananauga fana 'agila lo'o suria ni 'ola lo'oo te'efou na 'inau ku fa'ananaua mooru 'ania. Ma nau taku nana'i fe'eni amooru leleka maka nigi na nga fa'asuilana nga fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nga etalana mai nga Kwairiinga Le'a lo'oo suria la Jisas Kraes, nga Wela na God, ne'e 'ilo'oo: ");
INSERT INTO kwd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngaia 'e etaa 'ilaka'u la Aesea nga profet na God laka'u ngaia 'e giria ni farisi 'e aula sui no'o mai 'ola lo'oo God ngaia 'e iiria fala Kraes. “Aga madi. Nau taku kwatea kau nga wane ni ngari alafuunga agu 'i na'omu, 'ani sasari agau na ta'a famu. ");
INSERT INTO kwd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te'e wane ngaia 'e o'omae te'ana ta'a 'ubulana nga gule'e lefu langalanga ne'e 'ame to'omia ta wane 'ani to'oru ai. Ma ngaia ka 'ilo'oo, ‘Nga Alafa ngaia te'e nigi mai! Ta'a mooru fa'aodoa nga tala fana!’” ");
INSERT INTO kwd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","'Ilaka'u la profet Aesea 'e iiria mai na'o, la Jon ngaia 'e nigi no'o mai 'ubulana gule'e lefu langalanga na 'ame to'omia ta wane 'ani to'oru ai. Ngaia 'e ru'ufia nga ru'u 'ame le'a ngaia 'e launge'enia fa'asia ifuna kamel, ma ngaia ka fo'asia na fo'osae na susungana buruka. Ma ngaia ka 'ania nga nabo ma nga ngingidua kwasi. Ma ngaia ka naruabu na ta'a ma ka alafuu fana ta'a ma ka fata 'ilo'oo, “Moru abulo mai fa'asia rianga amooru ma mooru naruabu fana God 'ani 'olafanataa na rianga amooru.” Ma ni ta'a 'e aula fa'asia nga gule'e lefu 'i Judea, ma fanua 'i Jerusalem, gila ka leka mai fana longolana nga fatalana la Jon. Gila ka foulange'enia rianga aaga ma ngaia ka naruabu aaga 'ubulana ka'o 'i Jodan. ");
INSERT INTO kwd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma la Jon ka fata 'ilo'oo fana ta'a te'efou “Te'e wane te'e leka mai 'i burigu, ngaia 'e taringa'i ma ka riufi nau, nau ku 'ame to'omia fana 'aku gogonu ma ku rubea nga butu aana. ");
INSERT INTO kwd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mai nau ku naruabu 'amooru mola 'ania ka'o, tafe'ua ma ngaia te'e naruabu amooru 'ania nga Anoe 'ola Abu.” ");
INSERT INTO kwd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'Ame aburu mola 'i burina ni 'ola lo'oori, la Jisas 'e nigi mai fa'asia nga fanua 'i Nasaret 'ubulana nga gule'e lefu 'i Galili. Ngaia 'e nigi mai te'ala Jon fana 'ani naruabu ana. Ma la Jon ka naruabu ana 'ubulana nga ka'o 'i Jodan. ");
INSERT INTO kwd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma alata la Jisas ngaia 'e tata'e mai fa'asia 'ubulana ka'o, ngaia 'e agasia nga lalo 'e 'ulasi, ma nga Anoe 'ola Abu ka sifo mai fafia 'ilaka'u nga me'e bola. ");
INSERT INTO kwd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma te'e kwala'e 'ola ngaia 'e talo mai fa'asia 'i Langi ma ka 'ilo'oo, “'I'oo no'o na te'e wela mouta'ia agu, mai nau kua malale'a ba'ita fe'eni'o.” ");
INSERT INTO kwd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma nga alata lo'oori mola, nga Anoe 'ola Abu ka talaia la Jisas fana 'ubulana gule'e lefu langalanga. ");
INSERT INTO kwd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma ngaia ka to'oru 'ilo'oori suria fai akwale'e gani, ma la Saetan ka irito'ona. Ni 'ola 'e kwasila gila to'oru la'u 'i lo'oori, tafe'ua ma nga enselo gila ka leka mai, ma gila ka kwaibooni ana. ");
INSERT INTO kwd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'I burina gila arua no'o la Jon 'ubulana nga lokafu, la Jisas 'e leka 'i Galili ma ka kwairii 'ania nga Kwairiinga Le'a ne'e leka mai fa'asia God. ");
INSERT INTO kwd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ngaia ka fata 'ilo'oo, “Alata 'e galangi no'o mai fana God 'ani ba'ita fafia nga ta'a aana. Moru abulo mai fa'asia nga rianga amooru, ma moru ka fito'o na nga Kwairiinga Le'a lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma nga alata la Jisas 'e leka suria nga asi 'i Galili, ngaia 'e agasia la Saemon fe'enia wane ni futanga aana la Andru. Gaa'a rua wane na deenga. Gala dee te'efou na fulai agaa'a 'ubulana nga asi no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma la Jisas ka fata 'ilo'oo fagaa'a, “Molo leka mai fe'eninau, moo'o rua wane na deenga na ii'a, tafe'ua mai nau taku fa'ananaua moo'o 'ania wane ni deenga fana ta'a fagu.” ");
INSERT INTO kwd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma alata lo'oori la'u mola, gaa'a gala ka 'akwasia no'o nga fulai agaa'a, ma gala ka leka no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma la Jisas ka leka sika'u la'u kau, ma ngaia ka agasia la Jemes fe'enia la Jon, nga rua wela ala Sebedi. Gaa'a gala to'oru te'efou 'i 'ubulana nga baru, ma gala ka laumea fulai agaa'a. ");
INSERT INTO kwd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma alata la Jisas 'e agasi 'agaa'a, ngaia ka soe 'agaa'a no'o, ma gala ka 'akwasia no'o mama'a agaa'a la Sebedi 'i 'ubulana nga baru fe'enia nga ta'a ni taunga'inga, ma gala ka leka no'o fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","La Jisas fe'enia ni wane na fufu'iwane aana gila nigi na fanua 'i Kapaneam. Ma no'ona nga Sabat na ta'a 'i Jiu, ma la Jisas ka ru'u 'i 'ubulana nga 'ifi ni fo'anga na Jiu, ma ka fa'ananaua ta'a. ");
INSERT INTO kwd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Alata gila longoa, gila ka 'alefo ba'ita na nga kwaifa'ananaunga aana, suria gila su'a le'a ai na'a la Jisas ngaia 'e kwaifa'ananau 'ania tegelangaa ma nga 'inato'onga mai fa'asia God. Ngaia 'ame lado la'u na nga ta'a ni kwaifa'ananaunga na Tagi ala Moses na gila 'ame kwaifa'ananau 'ania 'inato'onga. ");
INSERT INTO kwd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma te'e alata lo'oori la'u mola, te'e wane na adalo 'e bo'ea, ngaia ka o'omae ma ka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas 'ae! 'I'oo na wane 'i Nasaret! 'Ola taa lo'oo 'i'oo agea ameeru? Bala 'i'oo leka mai fana malangada lameeru ta'ua lo'oo! Nau ku su'a mola amu, 'I'oo no'o na Wane Abu ala God!” ");
INSERT INTO kwd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma la Jisas ka belote'enia nga adalo laka'u, ma ka 'ilo'oo, “'Oi noto moko ru'u mai 'i maa fa'asia nga wane no'ona!” ");
INSERT INTO kwd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma nga adalo lo'oori, 'e asua la'u ma ngaia ka o'omae ba'ita, ma ka ru'u no'o mai fa'asia, ma ka rugasia no'o nga wane lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma nga ta'a na gila ogu no'ona gila ka 'alefo ba'ita, ma gila ka kwaiorisi kwairiu laloaga ma gila ka 'ilo'oo, “Nga 'olataa ne'e 'ilo'oo? Bala kwaifa'ananaunga fooru ta'ua lo'oo? Wane lo'oo 'e fata 'ania nga tegelangaa. Ngaia 'e beloa adalo, ma gila ka lo'o no'o suria nga fatalana.” ");
INSERT INTO kwd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'Ame gole mola ma alafuunga suria la Jisas ka talo no'o 'ubulana gule'e lefu garigaria 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Alata la Jisas fe'enia la Jemes ma la Jon, gila leka no'o kau fa'asia nga 'ifi ni fo'anga na Jiu lo'oori, gila ka leka fana 'ifi ala Saemon ma la Andru. ");
INSERT INTO kwd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Alata la Jisas ngaia 'e nigi 'ubulana 'ifi no'ona, gila ka kwairii te'ana, nga fungona geni la Saemon ngaia 'e fii 'ania noni'ago'agonga, ma ngaia mola fofona futa'i aana. ");
INSERT INTO kwd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma la Jisas ngaia ka leka te'ana noni lo'oori, ma ka dau 'i nimana, ma ka tata'ea. Ma nga 'ago'agonga lo'oori ka sui no'o fa'asia, ma 'i burina ngaia ka sasaria no'o fangalaa faga. ");
INSERT INTO kwd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma fe'e laulafi no'ona, alata sina 'e suu, ma nga gani na Jiu fana mamalongaa 'e sui no'o, nga ta'a gila ka ngaria mai ta'a 'e fii ma ta'a adalo 'e bo'ega te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma ta'a na fanua no'ona gila ka saku te'efou mai 'i maana 'ifi lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma la Jisas ka gulaa no'o ta'a 'e aula na gila fii 'ania fifiinga 'e aula kwaitatari. Ma ngaia ka belote'enia la'u nga adalo 'e aula. Ma ngaia 'ame alamia nga adalo lo'oori 'agila fata, suria gila su'a no'o ana ngaia Wela ala God. ");
INSERT INTO kwd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma 'usugani mola, alata 'e logologo'a 'ua, la Jisas ngaia ka tata'e, ma ka ru'u kau 'i maa fa'asia nga 'ifi lo'oori. Ma ngaia ka leka 'ani fo'a na lefu 'e aloalo. ");
INSERT INTO kwd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","'Iburina la Jisas 'e leka, la Saemon fe'enia ni wane ni kwaimaanga aana gila kwailo 'ofia. ");
INSERT INTO kwd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma alata gila to'o daria, gila ka fata 'ilo'oo fana, “Ta'a te'efou gila kwailo ofi'o.” ");
INSERT INTO kwd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma la Jisas ka lamadu'aga ma ka 'ilo'oo, “Nau ku su'aai, tafe'ua ma goru leka kau na tani maa'e fanua galangi la'u, madi fana 'akui fa'ananauga la'u, tofuna 'ola lo'oori nga taunga'inga agu ku leka no'o mai fai.” ");
INSERT INTO kwd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sui ma la Jisas ka leka 'ubulana ni maa'e fanua te'efou 'ubulana gule'e lefu 'i Galili, ma ka foulange'enia fatalana God 'i 'ubulana 'ifi ni fo'anga na Jiu, ma ka belote'enia adalo fa'asia nga ta'a. ");
INSERT INTO kwd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na te'e alata ngaa'i la'u, te'e wane 'e kuu 'e leka mai te'ala Jisas, ma ka bobouruuru 'i 'a'aena, ma ka laeta'a ma ka 'ilo'oo, “Lauta 'i'oo 'uri, moko gulaa nau.” ");
INSERT INTO kwd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma la Jisas ka kwaimanadai ba'ita fana, ma ka tagwala no'o nimana, ma ka dau 'i labena wane lo'oori, ma ka fata 'ilo'oo, “Nau ku 'uri mola. Nga nonimu lo'oo 'e mafo no'o!” ");
INSERT INTO kwd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma 'afe'aferu mola nga kuu lo'oori ka sigi no'o fa'asia, ma nga nonina ka nafo te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","La Jisas ka fata tegela fana wane lo'oori ma ka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“'I'oo sia kwairii la'u daria te'efuta wane na 'ola lo'oo nau ku agea famu. Tafe'ua, mai 'i'oo leka madi, moko faate'enia nonimu fana nga fataabu na God, alamia fataabu na God 'ani agasi'o. Sui moko kwatea nga tabonga amu 'ilaka'u la Moses ngaia 'e iiria fana kwatelai, madi fana 'ani kwatea fito'onga fana nga ta'a te'efou na nonimu ngaia 'e nafo no'o.” Ma la Jisas ka kwatea wane lo'oori ka leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tafe'ua, ma nga wane lo'oori ngaia 'e leka, ma ka alafuu 'ubulana fanua te'efou suria 'olataa na la Jisas ngaia 'e agea na nonina, ma ka le'a no'o. Tofuna kwairiinga lo'oori 'e talofiga no'o, na ta'a 'e aula gila ka ogu fafia la Jisas fana longolana ma agasilana ni 'ola na'a ngaia 'e launge'enia. Ma ngaia ka 'ato no'o fala Jisas 'ani leka faata'i mai 'ubulana fanua aaga. Ma ngaia ka to'oru no'o na lefu aloalo, ma tafe'ua, nga ta'a 'ubulana fanua te'efou gila leka no'o mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma 'i burina tani gani ngai 'e sui, la Jisas ka ori la'u mai fani Kapaneam. Ma gila ka kwairii kwairiu 'ania na ngaia 'e to'oru mola 'i 'ubulana 'ifi laka'u ngaia 'e fini nigi ai 'ubulana fanua lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nga ta'a 'e aula gila ka ogu no'o mai te'ala Jisas, leleka ma 'ifi lo'oori gila to'oru ai 'e fongu no'o, ma ta lefu ka 'amoe no'o fana to'orunga ai 'ubulana 'ifi lo'oori. Ma gwa'a gula 'i maa, ma ta'a 'e aula gila ogu la'u mola ai. Ma la Jisas ka foulange'enia fatalana God faga. ");
INSERT INTO kwd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma te'e alata lo'oori la'u mola, fai wane gila leka mai, gila ka ngaria mai te'e wane na labena 'e mae. ");
INSERT INTO kwd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma tofuna nga ogunga ba'ita lo'oori, ngaia ka 'ato no'o faga fana ngarilana kau te'ala Jisas. Sui ma, gila ka fane 'i fofona 'ifi fe'enia nga wane lo'oori. Ma gila ka 'ulasia te'e me'e kwakwa ba'ita 'i fofona 'ifi otofana lefu na'a la Jisas ngaia 'e to'oru ai, ma gila ka fa'asifoa nga wane lo'oori 'i fofona futa'i aana te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma alata la Jisas ngaia 'e aga su'ana fito'onga aaga, ngaia ka fata 'ilo'oo fana nga wane na labena 'e mae, “Alakwa agu, nau ku 'olafanataa no'o na rianga amu.” ");
INSERT INTO kwd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma alata no'ona, tani ta'a ni kwaifa'ananaunga na Tagi ala Moses gila to'oru la'u mola 'i no'ona, ma gila ka manata 'ilo'oo 'i talaga, ");
INSERT INTO kwd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Fu'u wane! 'Ame to'omia fana ngaia 'ani fata 'ilo'oo. Te'efuta wane 'ame su'ana 'olafanataanga na rianga. Te'e God no'o ne'e su'a na 'olafanataanga na rianga. Ngaia 'e fa'atooto'ome'enia 'ania God.” ");
INSERT INTO kwd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tafe'ua, ma la Jisas 'e su'a 'i manatalaga, ma ka fata 'ilo'oo faga, “Mooru sia manata la'u 'i no'ona.” Ma la Jisas su'a mola ai na'a gila tagoto'o te'e God no'o ne'e te'e 'olafanataa maka gulaa wane. Sui, ma ngaia ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Lauta nau ku fata 'ilo'oo fana wane lo'oo nonina 'e mae, ‘Rianga amu ku 'olafanataa no'o ai,’ amooru 'ato amoru agasia mola 'ola lo'oo 'e lau. Tafe'ua, ma lauta nau ku fata 'ilo'oo, ‘Tata'e, ngaria futa'i amu, moko leka,’ 'ilo'oori mai mooru tamooru bi'i agasia 'inau ku to'o na tegelangaa. ");
INSERT INTO kwd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Alata nau 'aku gulaa wane lo'oo, nau taku faate'enia famooru na 'inau, nga Wela na Wane, nau ku to'o na tegelangaa fana 'olafanataanga na rianga.” Mai ngaia ka fata 'ilo'oo fana nga wane lo'oori na labena 'e mae, ");
INSERT INTO kwd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau ku iiria famu, 'i'oo tata'e, ngaria no'o futa'i amu, moko leka no'o 'i 'ifi amu.” ");
INSERT INTO kwd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma wane lo'oori 'e tata'e, maka ngaria no'o futa'i aana, ma ka leka no'o. Ngai lo'oo, ta'a te'efou gila agasia, ma gila ka 'alefo ba'ita. Alata lo'oori, gila ka tafea God, ma gila ka fata 'ilo'oo, “'Amoe no'o. Goru 'ame agasia 'ua ta 'ola 'ilo'oo!” ");
INSERT INTO kwd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Te'e alata ngaa'i la'u, la Jisas ngaia 'e ori la'u gegena asi 'i Galili. Ma ogunga ba'ita gila ka leka mai te'ana, ma ngaia ka etaa ka fa'ananauga. ");
INSERT INTO kwd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma nga alata ngaia 'e leka kau suria asi lo'oori, ngaia ka agasia la Lifae, nga wela ala Alfeas. Ngaia 'e to'oru mola na lefu fana ngarilana bata na nga takisi, tofuna ngaia na taunga'inga aana no'ona. Ma la Jisas ka fata 'ilo'oo fana, “'Oi leka mai fe'eninau.” Ma la Lifae ka tata'e, ma ka leka no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma 'i burina la Jisas ngaia 'e soea la Lifae, ngaia 'e leka maka keto no'o 'i 'ifi aana. Ni ta'a 'e aula 'e ria 'ilo'oo, gila leka fe'enia la Jisas. Ma nga ta'a gila ngaria bata na nga takisi ma tani ta'a gila abulo 'ame le'a la'u mola, gila keto fe'enia la Jisas ma ni wane na fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tani Farasii ngaa'i na gila kwaifa'ananau 'ania Tagi ala Moses gila agasia na la Jisas ngaia 'e keto fe'enia ta'a 'e ria, ma nga ta'a gila ngaria bata na takisi. Ma Farasii gila ka fata 'ilo'oo fana fufu'iwane ala Jisas, “Ngaia 'e to'omia 'e sia keto mola fe'enia ta'a 'ino'ona.” ");
INSERT INTO kwd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma alata la Jisas ngaia 'e longoa 'ola lo'oori, ngaia ka fata 'ilo'oo faga, “Nga ta'a gila gwari'a, gila 'ame siria nga wane ni gulanga. Ta'a 'e fii na gila siria nga wane ni gulanga fana 'ani gulaga. 'Ino'ona la'u mola, nau ku 'ame leka la'u mai fana nga ta'a na gila madafia gila odo no'o 'ina'ona God, tafe'ua mai nau ku leka mai fana ta'a 'e ria.” ");
INSERT INTO kwd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na te'e alata ngaa'i, tani wane na fufu'iwane ala Jon, wane ni naruabunga, ma ni wane na fufu'iwane na Farasii, gila abu keto fana fo'anga. Ma tani wane ngaa'i gila ka leka mai, ma gila ka fata 'ilo'oo fala Jisas, “Fufu'iwane ala Jon ma ni wane na fufu'iwane na Farasii, gila abu keto. Ngaia no'ona 'e le'a fana nga fufu'iwane amu 'agila abu keto la'u mola?” ");
INSERT INTO kwd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma la Jisas ka lamadu'aga ma ka 'ilo'oo, “Ngaia 'ame toto'o fe'enia ta'a na gila to'oru na fafangalaa na ruma'a, 'agila abu na ketonga. Tofuna, alata alakwa fooru ngaia mola 'ua fe'eniga, ta'a gila malale'a. 'Ame le'a fana oguogunga ba'ita 'agila abu keto, tofuna gila to'oru na fafangalaa. ");
INSERT INTO kwd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Ino'ona la'u mola, ngaia 'ame to'omia ni wane na fufu'iwane agu na 'agila abu keto alata nau ku to'oru 'ua mola fe'eniga. Tafe'ua, ma alata 'ani nigi mai tagila ngaria nga alakwa fooru fa'asiga. 'Ilo'oo ma, tagila bi'i abu keto, tofuna na gila kwaimanadai.” ");
INSERT INTO kwd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","La Jisas ka fata la'u 'ilo'oo, “Ta wane 'esia bobolo'ua mola me'e ruu ne'e mou no'o 'ania nga kakasi'i ruu ne'e fooru. Lauta ngaia 'e agea nga 'ola lo'oori, ma kakasi'i ruu fooru lo'oori te'e gaasia nga ruu 'ua lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma 'ola ngaa'i la'u ngaia 'ame to'omia fana te'efuta wane 'ani arua no'o waeni fooru 'i 'ubulana wa'i 'ua na susungana nanigot, tofuna wa'i 'ua lo'oori 'ame ngasi. Lauta ngaia 'e agea 'ola 'ilo'oo, alata 'e bonosia maana, nga waeni lo'oori te'e fane mai, ma ngaia te'e gaasia no'o wa'i 'ua lo'oori, ma nga waeni lo'oori te'e akiri, ma nga wa'i lo'oori te'e ria no'o. Ngaia na wane 'ani arua nga waeni fooru 'i 'ubulana nga wa'i fooru lo'oo ngaia 'e su'aai 'e bono.” ");
INSERT INTO kwd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na te'e Sabat, la Jisas ma nga fufu'iwane aana gila leka suria nga tala ne'e leka 'i 'ubulana langa'a na 'ola 'ilaka'u nga witi. Ma alata gila leka ai, ni wane na fufu'iwane aana gila ka 'oia fufunga 'ola 'ilaka'u witi ma gila ka 'ania no'o. ");
INSERT INTO kwd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma nga Farasii gila agasia, ma gila ka fata 'ilo'oo fala Jisas, “Agasia madi lo'oo! 'Ola na'a mooru agea 'e mousia nga Tagi ala Moses, tofuna moru 'oia fufungu na 'ola ta'ua taunga'inga na Sabat.” ");
INSERT INTO kwd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma la Jisas ka fata tegela 'ilo'oo, “'Ino'ona mai amooru moru 'ame idumia 'ubulana Buka Abu suria 'ola laka'u la Defete ngaia 'e agea, alata laka'u la Abiata ngaia nga alafa ni tabonga? Alata laka'u, la Defete fe'enia ni wane aana gila molo'u ba'ita, suria te'efuta me'e fangalaa me'e 'amoe no'o faga fana 'anilai. Ma ngaia ka leka 'i 'ubulana nga 'ifi na God, ma la Abiata ka kwatea fala Defete nga beret na gila fa'abua fana God. Ma la Defete ka 'ania no'o beret lo'oori, ma ka kwatea la'u fana ta'a aana, ma gila ka 'ania la'u mola. Tafe'ua, ma nga tagi adauru ngaia 'e alamia mola fana te'e fataabu na God na gila mola fana 'anilai.” ");
INSERT INTO kwd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui mala Jisas ka fata 'ilo'oo fana nga Farasii, “La God ne'e launge'enia gani na mamalonga fana boonilana ta'a. Ma ngaia 'ame launge'enia la'u gani na mamalonga fana wane 'ani bobouruuru ai. ");
INSERT INTO kwd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tofuna 'inau, nga Wela na Wane, nau ku to'o na tegelangaa fafia nga Sabat.” ");
INSERT INTO kwd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Te'e alata ngaa'i la'u, la Jisas ngaia 'e leka la'u 'ubulana nga 'ifi ni fo'anga na Jiu, ma te'e wane lo'oo nimana 'e mae, ngaia 'e to'oru 'ino'ona. ");
INSERT INTO kwd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma tani Farasii ngaa'i, gila ka agaaga lauta la Jisas te'e gulaa wane lo'oori na sabat gani na mamalongaa. Lauta ngaia 'e agea, tagila fata maana la Jisas tofuna ngaia 'e mousia tagi na God na gulanga, 'ola lo'oori gila manata suria 'e 'ilaka'u taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma la Jisas ka fata 'ilo'oo fana nga wane na nimana 'e mae, “Tata'e mai lo'oo, moko ula 'ina'o na ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma la Jisas ka orisia nga Farasii ma ka 'ilo'oo, “'Ola taa na tagi adauru ngaia 'e alamia 'aguru agea na gani na mamalongaa? Ngaia 'e alamia agelana 'ola 'e le'a, 'amoe agelana 'ola 'e ria? Ngaia 'e alamia nga fa'amoorilana nga wane, 'amoe kwa'ilana nga wane?” Tafe'ua, mai gila 'ame iiria mola ta 'ola. ");
INSERT INTO kwd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","La Jisas 'e aga kwairiu, ma ngaia 'e ogaria, ma ngaia ka kwaimanadai la'u fana nga ta'a suria manatalaga 'e ngasi 'e iiki no'o. Sui ma ngaia ka fata 'ilo'oo fana nga wane lo'oori, “Tagwala mai nga nimamu.” Mai ngaia ka tagwala no'o nimana, ma nga nimana ka le'a no'o. ");
INSERT INTO kwd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sui ma ni Farasii gila ka ru'u kau 'i maa, ma gila ka alafuu oguogu fe'enia tani ta'a na fufu'iwane ala Herod 'agila fadaa fana kwa'ilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","La Jisas fe'enia fufu'iwane aana, gila ka 'akwasia ta'a lo'oori, ma gila ka leka fana suria asi 'i Galili. Nga ta'a 'e aula gila ka leka la'u 'i buriga. Gila leka no'o fa'asia nga gule'e lefu 'i Galili, ma 'i Judea ma fa'asia nga fanua taringa'i 'i Jerusalem. Ma tani ta'a ngaa'i gila leka fa'asia nga fanua 'i Idumea ma gule'e lefu ngaa'i na tata'elana sina na ka'o 'i Jodan. Ma tani ta'a ngaa'i gila ka leka mai fa'asia nga fanua ri'itana 'i Taea ma 'i Saedon. Nga ogunga ba'ita lo'oori, gila leka mai te'ala Jisas alata ngai suria asi, suria gila longoa 'ola ba'ita lo'oo ngaia 'e agea. ");
INSERT INTO kwd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ngaia 'e gulaa ta'a 'e aula 'e sui no'o, ma ni ta'a gila fii 'e aula gila ka su'unge'eniga la'u mola mai, fana 'agila gema to'ona la'u la Jisas 'agila gwari'a. Suria nga ogunga lo'oori 'e ba'ita 'e iiki, ma la Jisas ka iiria fana fufu'iwane aana fana 'agila sasari agau na nga baru, fa'asia laloana nga ta'a lo'oo gila ta kwaibebesi. ");
INSERT INTO kwd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma alata nga ta'a adalo 'e bo'ega gila agasia, ma gila ka bobouruuru 'i na'ona, ma gila ka o'omae ma gila ka 'ilo'oo, “'I'oo no'o na nga Wela kwala'imori na God!” ");
INSERT INTO kwd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tafe'ua, ma la Jisas 'e fata 'usia nga adalo lo'oori 'e iiki, fana gila sia kwairii mola te'ana te'efuta wane suria 'i ngaia. ");
INSERT INTO kwd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sui mala Jisas ka fane 'ala'a fana 'i gouna me'e busu, ma ka soea mai ta'a fana taunga'inga fe'enia. Ma gila ka leka mai te'ana, ");
INSERT INTO kwd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ma ngaia ka firia nga akwale'e wane ma ruaai, ma ka fa'alataga 'ania ni Wane ni Kwairiinga. Ma ngaia ka fata 'ilo'oo faga, “Nau ku firia mooru 'amooru to'oru firi fe'eni nau, mai nau kua soe 'amooru la'u fana kwaifa'ananaunga suria fatalana God fana ta'a. ");
INSERT INTO kwd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mai mooru 'amoru to'o na nga tegelangaa fana nga belolana nga adalo.” ");
INSERT INTO kwd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lo'oo, nga latana akwale'e wane ma ruaai lo'oo 'e firiga: la Saemon, na'a la Jisas ngaia 'e fa'alata la'u 'ania la Pita, ");
INSERT INTO kwd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma la Jemes fe'enia la Jon nga rua wela ala Sebedi, na'a la Jisas ngaia 'e fa'alata gaa'a 'ania “Boneges,” ne'e fida'ana nga wane ne'e ogaria'a 'afe'aferu 'ilaka'u nga kwakwa'afita. ");
INSERT INTO kwd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma la Andru, ma la Filip, ma la Batolomiu, ma la Matiu, ma la Tomas, ma la Jemes, wela ala Alfeas, ma la Tadeas, ma la Saemon, te'e wane na ta'a 'i Jiu na gila siria tarilana nga ta'a 'i Rom fa'asia Israel. ");
INSERT INTO kwd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma la Judas Iskariot nga wane ana ne'e tagoni 'olonge'enilana la Jisas fana marimae aana. ");
INSERT INTO kwd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sui, ma la Jisas ka ori la'u fani Kapaneam fana 'ifi laka'u ngaia 'e fini nana'i ai. Ma nga ta'a 'e aula, gila ka ogu no'o mai te'ana. Ma alata ka 'amoe no'o fala Jisas ma ni wane na fufu'iwane aana fana agelana ta 'ola ma nga ketonga. ");
INSERT INTO kwd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sui ma ta'a gila ka fata 'ilo'oo, “Ngaia 'e kakakula 'e iiki no'o.” Ma alata ni wane ni futanga aana gila longoa 'ola lo'oori, gila ka leka te'ana fana orite'enilana fani fanua aaga. ");
INSERT INTO kwd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma tani wane ni kwaifa'ananaunga na Tagi ala Moses na gila leka mai fa'asia 'i Jerusalem, gila ka fata 'ilo'oo, “La Jisas ngaia 'e belote'enia mola adalo 'ania tegelangaa ala Saetan, nga 'inatana adalo.” ");
INSERT INTO kwd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sui ma la Jisas ka soea mai ta'a laka'u te'ana maka fata 'ilo'oo faga 'ania tarifulaa 'ilo'oo, “La Saetan 'e 'ato no'o 'ani belote'enia adalo fa'asia ta'a aana. ");
INSERT INTO kwd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lauta ta'a 'ubulana nga fanua ba'ita gila funuriga 'i talaga, ta'a na fanua ba'ita lo'oori te'e fusi, ma tagila tagala'i no'o. ");
INSERT INTO kwd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma lauta nga wane, ma noni, ma ni wela agaa'a, gila funuriga 'i talaga, gila tagila fusi, ma tagila tagala'i no'o. ");
INSERT INTO kwd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngaia 'e 'ino'ona la'u mola, lauta la Saetan 'e funu fe'enia ta'a na gila leka 'i suria, tagila tagala'i kwaitatari mola, ma tegelangaa aana fafiga 'e nigi no'ona me'e sui no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'Iburina, la Jisas ka iiria la'u tani tarifulaa ngaa'i maka fata 'ilo'oo, “Lauta ta wane no'o siria 'ani belote'enia adalo, wane lo'oori 'ani tegela'a riufia la Saetan. Maka 'ilo'oo la'u lauta wane ne'e siria 'ani ru'u 'ubulana 'ifi na wane tegela'a fana ngarilana 'ola aana, ngaia 'ani tegela 'ani riufia nga wane lo'oori madi, fana 'ani talawada'u fana gaulana wane tegela'a lo'oori sui ma ngaia te'e bi'i ngaria ni 'ola aana. ");
INSERT INTO kwd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“'Ola kwala'imori lo'oo nau ku iiria famooru, nga abulongaa 'ame le'a, ma fata ngadalana God na ta'a gila agea, God te'e 'olafanataa mola ai. ");
INSERT INTO kwd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tafe'ua, ma lauta ta wane 'ani agea nga fata ngadalana nga Anoe 'ola Abu, God 'e sia 'olafanataa mola aana. Ma rianga lo'oori aana 'e nana'i firi no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","La Jisas ngaia 'e fata 'ilo'oo, suria nga ta'a, gila iiria adalo 'e bo'ea la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma 'i burina alata lo'oori, ga'ia la Jisas ma ni wane ni futanga aana, gila nigi no'o. Ma gila ka ula 'i maana 'ifi tofuna ogunga lo'oo 'e ba'ita, ma gila ka kwatea kau alafuunga fala Jisas, ma gila ka kwaiorisi fana. ");
INSERT INTO kwd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nga ta'a 'e aula iiki na gila to'oru ri'itana la Jisas, ma gila ka kwairii ma gila 'ilo'oo, “Ni gai'o, ma ni wane mooru futa, gila ula mai 'i maa, gila siria agasilamu.” ");
INSERT INTO kwd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma la Jisas ka orisiga ma ka 'ilo'oo, “Ni dai na ga'i kwala'imori agu, ma ni wane ni futanga agu?” ");
INSERT INTO kwd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma alata 'e aga kau fana nga ta'a 'e aula lo'oo gila to'oru ri'itana, ma ka fata 'ilo'oo, “Mooru no'o na ta'a 'ilaka'u no'o ga'i nau, ma ni wane ni futanga agu! ");
INSERT INTO kwd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Suria ni dai ne'e lo'oo suria God, ngaia no'o na wane ni futanga agu, ma fu'igeni futanga agu, ma ga'i nau.” ");
INSERT INTO kwd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na tani alata ngaa'i la'u, la Jisas ngaia ka kwaifa'ananau 'i gegena asi 'i Galili. Ma nga ogunga ba'ita iiki gila ka ogu ri'itana, ma ngaia ka fane 'ubulana te'e baru, ma ka to'oru 'i 'ubulai, ma ngaia ka 'idu sisika la'u fani 'ubulana asi. Ma nga ogunga lo'oori, gila ka ula kau 'i gegena asi. ");
INSERT INTO kwd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma la Jisas ka kwaifa'ananau 'ania 'ola 'e aula faga na tarifulaa, ma ka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mooru gwalongo madi! Te'e wane ngaia 'e leka ma ka fufusia nga uu'uuna witi 'i 'ubulana langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma alata ngaia 'e fufusia nga uu'uuna witi lo'oori, tani uu'uuna witi ngai 'esia suria nga tala, ma nga langasi gila ka lofo mai, ma gila ka 'ani'i mola te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma tani uu'uuna witi ngai ka 'esia na lefu 'e foula, lefu na wado 'ame ba'ita ai. Ma gila ka bila'o 'afe'aferu, suria nga wado ngaia 'ame 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma alata nga sina 'e tata'e mai, 'e sinafia ma witi ka malonga, ma gila ka gu'a mola, suria nga 'umi'umina 'ame sifo to'o. ");
INSERT INTO kwd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma tani uu'uuna witi ngaa'i gila 'esia 'i laloana nga kwalo 'abui, ma kwalo lo'oori ka a'a fafia nga witi lo'oo, ma witi lo'oori 'ame fungu no'o. ");
INSERT INTO kwd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma tani uu'uuna witi ngaa'i, 'e 'esia 'i 'ubulana nga wado to'o 'e le'a, ma alata gila tata'e mai, gila ka fungu 'ania ni lode 'ola 'e aula. Gila ka fungu 'ania oru akwale'e lodo, ma tani witi ngaa'i gila ka fungu 'ania ono akwale lodo, ma tani witi ngaa'i gila ka fungu 'ania tangale'e lodo.” ");
INSERT INTO kwd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma la Jisas ka ite'enia fatalana ma ka 'ilo'oo, “Lauta ta wane siria 'ani su'a le'a na 'ola lo'oo, ngaia te'e gwalongo le'a mai.” ");
INSERT INTO kwd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Alata la Jisas 'e to'oru 'i talana, nga akwala ma ruaai laka'u aana, fe'enia nga ta'a na gila lado 'i burina, gila ka leka mai te'ana. Ma gila ka orisia 'ani fa'afolaasia nga tarifulaa lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma ngaia ka fata 'ilo'oo, “Alata mai na'o, God 'ame fa'afolaasia 'ua famooru na ngaia te'e ula na'ona'o fana ta'a aana. Tafe'ua, ma tala'ina, nga fa'afolaasilai lo'oo 'e nigi no'o famooru. Ta'a na gila 'ame siria su'anga na God, nau ku alafuu 'ania tarifulaa, mai nau ku 'ame fa'afolaasia ");
INSERT INTO kwd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'ani 'ilo'oo, 'ilaka'u ni profet 'e giria, Gila aga, ma gila ka aga, tafe'ua ma gila 'ame agasia 'olataa na God ngaia 'e agea faga. Ma gila gwalongo, ma gila ka gwalongo, tafe'ua ma gila 'ame su'a na kwairiinga na God. Suria lauta gila aga su'aai, ma gila ka longo su'ana, ma ta'a gila abulo mai te'ana God, ma ngaia te'e 'olafanataa mola na rianga aaga.’” ");
INSERT INTO kwd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sui mala Jisas bi'i fata 'ilo'oo te'aga, “'ino'ona ma mooru moru 'ame su'a mola na tarifulaa lo'oo? Lauta moru 'ame su'a na tarifulaa lo'oo, ta mooru su'a 'utaa na tarifulaa ngaa'i la'u? ");
INSERT INTO kwd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nga wane laka'u 'e tagale'enia uu'uuna witi, ngaia 'e kwairii 'ania nga fatalana God laka'u. ");
INSERT INTO kwd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nga uu'uuna witi ne'e 'esia suria nga tala gila 'ilaka'u ni wane na gila longoa nga fatalana God. Ma alata gila longoa, la Saetan ngaia 'e leka mai, ma ka lafua la'u mola fatalana God fa'asiga. ");
INSERT INTO kwd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nga uu'uuna witi ne'e 'esia na lefu 'e foula gila 'ilaka'u tani wane ngaa'i. Alata gila longoa nga fatalana God, gila ngaria, ma gila ka aile'a ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tafe'ua, ma fatalana God 'ame susuto'o mola 'ubulana manatalaga. Ngaia na fito'onga aaga 'e moori mola suria te'e alata sisika. Ma alata gila daria 'ato'atolanga, ma nonifiinga tofuna Kwairiinga Le'a lo'oo, gila ka rugasia mola fatalana God. ");
INSERT INTO kwd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nga uu'uuna witi na gila 'esia 'i laloana nga kwalo 'abui, gila 'ilaka'u tani wane ngaa'i na gila longoa nga fatalana God, ");
INSERT INTO kwd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tafe'ua ma gila manata 'abelo suria 'ola na moorilaga. Ma furifuri gila siria nga 'ola'angaa la'u mola. Ma ni 'ola lo'oori, 'e 'ilaka'u nga kwalo 'abui ne'e a'a fafia nga fatalana God 'ubulana manatalaga. Ngaia 'e 'ilaka'u nga witi na 'ame fungu no'o 'ania ta lode 'ola. ");
INSERT INTO kwd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma tani wane ngaa'i la'u na gila 'ilaka'u nga uu'uuna witi na 'e 'esia 'i 'ubulana me'e wado 'e to'o. Gila longoa fatalana God, ma gila ka lo'o suria, ma gila faate'enia to'orunga 'e odo, ne'e 'ilaka'u witi ne'e fungu 'ania lode 'ola. Tani ai ngaa'i 'e oru akwale lodo, ma tani ai ngaa'i 'ania ono akwale lodo, ma tani ai ngaa'i 'ania tangale'e lodo.” ");
INSERT INTO kwd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sui mala Jisas ka fata la'u 'ilo'oo 'i laloaga, “'ino'ona ma te'efuta wane 'ani ngaria mai nga uunu, ma ngaia 'ani arua mola 'i olofana nga daoko 'amoe ta futa'i? 'Ato no'o! Ngaia te'e arua na lefu ne'e kwatea nga lalanga! ");
INSERT INTO kwd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","'Olataa na gila gonia mai na'o, ta'a tagila su'aai. 'Olataa na gila nagwa mai na'o, ta'a tagila su'aai. ");
INSERT INTO kwd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lauta ta wane 'e siria 'ani su'a le'a na 'ola lo'oo, ngaia 'ani gwalongo 'e le'a mola.” ");
INSERT INTO kwd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma la Jisas ka fata la'u 'ilo'oo faga, “Moru manata le'a suria 'ola na moru longo'i. God te'e kwatea mamanatangaa na su'a'olanga aana famooru, lauta mooru lo'o suria nga kwaifa'ananaunga agu. ");
INSERT INTO kwd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ni dai ne'e to'o na te'e su'a'olanga sisika'u suria to'onga na God, God te'e rudagou ai fana. Ma ni dai ne'e 'ame lo'o suria kwaifa'ananaunga lo'oo, tafe'ua te'e su'a'olanga sisika na 'i ngaia 'e to'o ai suria 'inato'onga na God, God te'e orite'enia fa'asia.” ");
INSERT INTO kwd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","La Jisas ka fata la'u 'ilo'oo faga, “Nga foufoula na God ngaia 'e 'ilaka'u nga wane na'a ngaia 'e kirua uu'uuna 'ola 'i 'ubulana nga langa'a aana. ");
INSERT INTO kwd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngaia 'e aga, ma ka leka kwairiu na asua, ma ka eeno 'ubulana logo. Tafe'ua, alata na uu'uuna 'ola ngaia 'e bila'o, ma ka tata'e no'o, nga wane 'ame su'a no'o na bila'olai. ");
INSERT INTO kwd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nga wado 'i talana na'a ngaia 'e fa'amooria uu'uuna 'ola lo'oori 'e ba'ita, ma ka fungu 'ania lode 'ola. Nga to'ofungana 'ai ngaia 'e fane mai 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma alata na uu'uuna 'ola lo'oori ngaia 'e mena, nga wane lo'oori ka eta fana fufusilana fufungui 'ola lo'oo, suria ngaia 'e nigi no'o na alata fana gonilai.” ");
INSERT INTO kwd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","La Jisas ngaia ka fata la'u ka 'ilo'oo, “Nau ku alafuu la'u suria te'e tarifulaa suria to'onga na God fafia wane aana. ");
INSERT INTO kwd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ngaia ka 'ilo'oo: Te'e wane 'e ngaria nga u'uuna ai na gila fa'alata 'ania mastad, ngaia 'e sisika riufia 'u'una ai te'efou, ma ngaia ka kirua 'ubulana wado. ");
INSERT INTO kwd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma 'i burina na ngaia 'e kirua 'e sui, nga u'uuna 'ola laka'u ka bila'o, ma ka arua no'o 'ai. 'Ai lo'oori 'e ba'ita ma ka riufia no'o 'ai 'e aula. Ma ngaia ka to'o na nga lalana 'ola ba'ita, ma nga langasi gila ka lofo mai, ma gila ka launge'enia nga nuu'i aga ai.” ");
INSERT INTO kwd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sui ma la Jisas ka fata fana nga ta'a na tarifulaa 'e aula 'ilo'oo, ma ngaia ka iiria 'ola la'u na ngaia 'e toto'o fe'enia 'agila fito'o ai. ");
INSERT INTO kwd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma ngaia ka fata faga 'ania ni tarifulaa ngaa'i la'u. Ma, alata ngaia 'e to'oru 'i talana fe'enia nga fufu'iwane aana, ngaia bi'i fa'awatagaa ni 'ola lo'oo te'efou faga. ");
INSERT INTO kwd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ngaia 'e laulafi no'o na gani no'ona, mala Jisas ngaia ka fata 'ilo'oo fana fufu'iwane aana, “Goru olofolo madi fana gule'e asi loko'u.” ");
INSERT INTO kwd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma gila ka 'akwasia no'o ogunga lo'oori, ma gila ka leka fe'enia la Jisas 'i 'ubulana baru lo'oori. Ma tani baru ngaa'i la'u gila lado aaga. ");
INSERT INTO kwd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma nga iiru ba'ita 'e tata'e mai, ma bio ka mo'oi no'o mai 'ubulana nga baru lo'oori, ma ka galangi kuruu no'o. ");
INSERT INTO kwd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma la Jisas 'e eeno mola 'i burina nga baru, ma ka goorunga mola na nga bilo aana. Ma nga fufu'iwane ana gila ka fa'aagaa, ma gila ka fata 'ilo'oo, “Alafa, goru galangi goru kuruu no'o! 'I'oo 'ame manata 'abelo mola?” ");
INSERT INTO kwd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma la Jisas ka tata'e, ma ka fata tegela fana iiru lo'oori ma ka 'ilo'oo, “'Oi aloalo no'o!” Ma ngaia ka alafuu la'u fana nga bio lo'oori ma ka 'ilo'oo, “Mooru moru to'oru aloalo no'o!” Na te'e alata no'ona mola, ma iiru laka'u ka aloalo no'o, ma asi ka folaa no'o. ");
INSERT INTO kwd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma ngaia ka fata 'ilo'oo fana fufu'iwane aana, “Fe'ua na moru ma'u? Nau ku agasia nga fito'onga amooru agu 'e 'ame ba'ita.” ");
INSERT INTO kwd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma gila ka ma'u ma gila lebelebe no'o, ma gila ka kwaiorisi kwairiu laloaga ma gila ka 'ilo'oo, “Wane 'utaa lo'oo no'o! Tafe'ua gwa'a nga iiru ma nga bio ma gila lo'oo mola 'i suria!” ");
INSERT INTO kwd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","La Jisas fe'enia nga fufu'iwane aana, gila olofolo fana gule'e asi 'i Galili, ma gila ka nigi na gule'e asi na nga gule'e lefu 'i Gerasa. ");
INSERT INTO kwd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma alata la Jisas ngaia 'e sifo fa'asia nga baru, te'e wane na adalo ngaia 'e bo'ea ka ru'u mai fa'asia nga giru gwa'u, nga lefu ni kwaiatonga, ma ngaia ka leka mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nga wane lo'oori to'orunga aana lo'oo no'o 'ubulana giru gwa'u lo'oo, ma ta wane 'ame to'omia gaulana 'ania ta'ina kwalo. ");
INSERT INTO kwd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Suria alata 'e aula, gila gaua nga nimana ma nga 'a'aena 'ania seni, ma ngaia 'e mousia mola nga seni lo'oori fa'asia nga nimana ma 'a'aena. Ma te'efuta wane 'ame tegela 'ani to'omia no'o daulana. ");
INSERT INTO kwd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma nga logo ma gagani, ngaia 'e to'oru 'i laloana nga giru gwa'u, nga lefu na kwaiatonga, ma ngaia ka fane 'ubulana nga iile, ma ka o'omae, ma ka kwaria labena 'i talana 'ania naifi. ");
INSERT INTO kwd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Alata ngaia 'e to'oru lalau mai, ngaia 'e agasia la Jisas, ma ka totola mai, ma ka bobouruuru 'i na'ona. ");
INSERT INTO kwd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma la Jisas ka fata 'ilo'oo fana, “Adalo lo'oo, 'oi ru'u mai maa fa'asia nga wane lo'oo!” Ma ngaia ka o'omae ba'ita ma ka 'ilo'oo, “Jisas! 'I'oo, nga Wela na God ne'e tegela'a 'e ba'ita! Nga 'olataa na 'i'oo siria 'ani agea agu? Nau ku soe'o na latana God, 'osia kwatea mola ta kwa'ikwa'inga fagu!” ");
INSERT INTO kwd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui mala Jisas ka orisia ma ka 'ilo'oo, “Latamu ni dai?” Ma ngaia ka lamadu'aa ma ka 'ilo'oo, “Nga latagu 'E Aula, suria meeru adalo meru aula 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ngaia ka soea la Jisas fana ngaia 'e sia beloga la'u fa'asia nga gule'e lefu lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma nga uumi'i boo 'e aula iiki na gila keto 'ino'ona 'i gegena nga iile no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma nga adalo lo'oori, gila soea la Jisas ma gila ka 'ilo'oo, “'Oi kwate 'ameeru fana nga uumi'i boo loko'u, ameeru ru'u 'i 'ubulaga.” ");
INSERT INTO kwd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma la Jisas ka alamiga, ma nga adalo lo'oori gila ka ru'u mai fa'asia wane lo'oo, ma gila ka leka, ma gila ru'u 'i 'ubulana nga uumi'i boo no'ona. Ma nga uumi'i boo no'ona 'e to'omia nga rua to'oni (2,000) boo, gila ka 'akwa fana nga 'abita lo'oori, ma gila ka 'esiga 'i 'ubulana nga asi, ma gila ka go'u ma gila mae te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma ta'a na gila aga suria nga uumi'i boo lo'oori, gila ka 'akwa, ma gila ka kwairii na 'ola ne'e lau na uumi'i boo 'i 'ubulana fanua lo'oori, ma nga fanua sisika ri'itai. Ma nga ta'a 'e aula gila ka leka fana agasilana 'ola na ngaia 'e lau. ");
INSERT INTO kwd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma nga alata gila nigi te'ala Jisas, gila ka agasia no'o wane laka'u nga adalo 'e aula gila bo'ea, ngaia 'e to'oru no'o 'i no'ona, ma ngaia ka 'afesi no'o, ma ngaia ka manata'a no'o. Ma nga ta'a gila ka ma'u, ma gila ka 'alefo ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma nga ta'a na gila agasia 'ola lo'oori ngaia 'e lau, gila ka kwairii te'ana ta'a suria nga wane adalo 'e bo'ea, ma gila ka alafuu la'u suria nga uumi'i boo lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mai burina, ta'a lo'oori gila orisia la Jisas 'ani leka no'o fa'asia nga gule'e lefu lo'oo aga. ");
INSERT INTO kwd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma alata la Jisas ngaia 'e tata'e 'ani leka no'o 'ubulana nga baru, nga wane laka'u nga adalo gila bo'ea 'i na'o, ngaia ka orisia la Jisas fana 'ani leka fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tafe'ua, ma la Jisas 'ame alamia, ma ka fata 'ilo'oo fana, “'Oi ori 'i fanua te'ana nga ta'a amu, moko kwairii 'ania 'ola le'a te'efou na God ngaia 'e agea famu, ma nga kwailaeta'afiinga aana famu.” ");
INSERT INTO kwd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma nga wane lo'oori ngaia 'e leka, ma ka kwairii no'o te'ana ta'a na gule'e lefu 'i Dekapolis na 'ola te'efou na la Jisas ngaia 'e agea fana. Ma nga ta'a te'efou gila ka 'alefo ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","La Jisas ngaia 'e olofolo la'u kau fana gule'e asi. Ma nga alata ngaia 'e nigi no'ona, ta'a 'e aula gila ka ogu 'afuia. ");
INSERT INTO kwd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma te'e wane na'ona'o 'ubulana nga 'ifi ni fo'anga na Jiu, latana la Jaeras, ka leka mai. Ma alata ngaia 'e agasia la Jisas, ngaia ka bobouruuru 'i maana 'a'aena, ");
INSERT INTO kwd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ngaia ka laeta'a ma ka 'ilo'oo, “Laari'i agu ngaia 'e fii no'o fana maenga. 'Oi leka mai, 'ani 'oi arua nga nimamu 'i fofona, fana 'ani gwari'a ma ka moori.” ");
INSERT INTO kwd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma la Jisas ka leka no'o fe'enia. Ma nga ogunga ba'ita gila leka 'i burina, ma gila ka kwaibebesi no'o. ");
INSERT INTO kwd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma te'e noni na gwe'e abu 'e 'ulasiana suria nga akwale'e farisi ma ruaai, ngaia 'e to'oru la'u mola no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma ngaia ka nonifii ba'ita no'o. Ma ngaia ka ngadaa no'o bata auaula aana fana nga ta'a ni gulanga 'e aula, tafe'ua ma to'orunga aana 'ame le'a mola. Ngaia bi'i ria ba'ita no'o. ");
INSERT INTO kwd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma alata ngaia 'e longoa alafuunga suria la Jisas, ngaia ka ango mai burina 'i laloana nga ogunga lo'oori, ma ka gema na nga ruu tekwa ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Suria ngaia 'e manata 'ilo'oo, “Lauta nau ku gema to'ona mola nga nigifana ruu aana, mai naku gula no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma alata na ngaia 'e galo mola na ruu ala Jisas, 'afe'aferu nga abu ne'e 'ulasia aana ka langa no'o, ma ngaia 'e su'aai nga nonina 'e gwari'a no'o fa'asia nga fifiinga aana. ");
INSERT INTO kwd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma te'e alata no'ona mola, la Jisas ngaia 'e su'a suria nga tegelangaa aana 'e gulaa no'o ta wane ngaa'i. Ma ngaia ka abulo 'i laloana nga ogunga lo'oori, ma ka orisiga 'ilo'oo, “Ni dai lo'oo 'e gema kau na ruu agu?” ");
INSERT INTO kwd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma nga fufu'iwane aana, gila ka lamadu'aa 'ilo'oo, “'I'oo agasia mola nga ta'a 'e aula na gila bebesi'o no'o. Fe'ua na 'i'oo kwaiorisi fana wane na ngaia 'e gema to'omu?” ");
INSERT INTO kwd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tafe'ua ma la Jisas 'e aga kwairiu 'ani agasia ni dai na'a ngaia 'e agea 'ola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma nga noni na'a ngaia 'e su'aai 'ola ne'e lau fana, ngaia ka leka lebelebe no'o mai 'ania ma'unga, ma ka bobouruuru 'i maana 'a'aena la Jisas. Ma ngaia ka kwairii kwala'imori na 'ola na ngaia 'e agea. ");
INSERT INTO kwd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma la Jisas ka fata 'ilo'oo fana, “Noni lo'oo 'i'oo, God ne'e gula'o no'o suria 'i'oo fito'o agu. 'Oi leka no'o kau, ma 'i'oo sia manata gelo la'u, 'i'oo gwari'a no'o fa'asia nga fifiinga amu.” ");
INSERT INTO kwd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma alata la Jisas ngaia 'e alafuu mola 'ua, tani wane gila nigi mai fa'asia nga 'ifi ala Jaeras, ma gila ka fata 'ilo'oo fala Jaeras, “Wela geni laka'u amu ngaia 'e mae no'o. 'I'oo sia fa'a'abelosia la'u nga wane kwaifa'ananaunga.” ");
INSERT INTO kwd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma la Jisas 'ame 'abelo mola suria 'ola na'a gila iiria, ma ka fata 'ilo'oo fala Jaeras, “'I'oo sia ma'u mola. 'Oi fito'o mola.” ");
INSERT INTO kwd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma ngaia 'ame alamia ta wane 'ani leka fe'enia, te'e ngaia ma la Pita, ma la Jemes, ma la Jon, nga wane ni futanga ala Jemes. ");
INSERT INTO kwd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma alata gila nigi 'i 'ifi ala Jaeras, la Jisas 'e longoa nga kutanga fe'enia nga aaninga ma nga o'omaenga ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma ngaia ka ru'u kau, ma ka fata 'ilo'oo faga, “Fe'ua na moru aani, ma moru ka o'omae 'ilo'oo no'o? Wela geni lo'oo ngaia 'ame mae, ngaia 'e eeno mola.” ");
INSERT INTO kwd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tafe'ua, ma gila ka 'osa mola 'ania la Jisas. Ma ngaia ka beloga kau 'i maa, ma ka talaia nga ma'a aana, ma ni ga'ia wela lo'oori, ma ni wane na fufu'iwane aana na'a gila to'oru fe'enia, ma gila ka ru'u 'ubulana tofi 'ifi lo'oo nga wela lo'oori 'e eeno ai. ");
INSERT INTO kwd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mai ngaia ka dau na nga nimana nga wela lo'oori, ma ka fata 'ilo'oo fana, “Talita kom!” na alafuunga na Aramaik. Ngaia fa'aladamia 'e 'ilo'oo, “Wela geni, nau ku iiria famu 'ani tata'e!” ");
INSERT INTO kwd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma ngaia ka tata'e, ma ka ula, ma ka leka no'o. Nga wela lo'oori te'e akwale'e farisi ma ruaai 'e bi'i sui fafia futalana. Ma gila ka 'alefo ba'ita na 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tafe'ua, ma la Jisas 'e ruiga, fa'asia gila sia kwairii mola te'ana ta wane na nga 'ola lo'oori. Ma ngaia ka iiria 'agila kwatea fangalaa fana nga wela geni lo'oori fana 'ani 'ania. ");
INSERT INTO kwd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","La Jisas fe'enia ni wane na fufu'iwane aana, gila 'akwasia nga lefu lo'oori, ma gila ka ori no'o fana fanua na 'e ba'ita mai ai 'i Nasaret. ");
INSERT INTO kwd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na nga Sabat, nga gani na mamalongaa, ngaia ka kwaifa'ananau 'i 'ubulana nga 'ifi ni fo'anga na Jiu. Ma ta'a 'e aula gila longoa, ma gila ka 'alefo ba'ita. Mai gila ka kwaiorisi kwairiu ma gila ka 'ilo'oo, “Nga tegelangaa ani dai lo'oo 'e kwatea 'e kwaifa'ananau 'ania fatalana God 'ilo'oo, fana agelana ni 'ola 'e faringa'a lo'oo? ");
INSERT INTO kwd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nga wane lo'oo goru su'a le'a mola ana. Ngaia wane mola fana tofu 'ifi nga. Ga'ia laka'u mola ni Meri. Ni wane gila futa ana laka'u la Jemes, ma la Josef, ma la Judas, ma la Saemon. Ma fu'igeni gila futa aana gila to'oru la'u mola lo'oo fe'enia 'adauru.” Sui, ma gila ka ma'asini te'enia la'u mola ana. ");
INSERT INTO kwd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma la Jisas ka fata 'ilo'oo faga, “Nga profet tafe'ua gila fa'aba'ita 'ubulana fanua matari, ma te'e fanua aana 'e 'ato 'agila iiri ba'ita ana ai.” ");
INSERT INTO kwd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mai ngaia 'ato no'o fana 'ani agea la'u 'ola ni 'alefosilai 'e aula no'ona. Ma ngaia ka arua nga nimana fafia tani ta'a na gila fii ma gila ka gula no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma ngaia ka 'alefo ba'ita, tofuna nga ta'a gila 'ame fito'o mola ana. Sui mala Jisas ka leka no'o fana maa'e fanua ri'itana lo'oori, ma ka kwaifa'ananau fana ta'a. ");
INSERT INTO kwd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngaia ka kwaisoe fana nga akwale'e wane ma ruaai ni Kwairiinga aana, ma ngaia ka kwatea no'o tegelangaa faga fana belolana nga adalo, ma ka alega no'o te'efou, ma ka arua nga rua wane gala leka oguogu. ");
INSERT INTO kwd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma la Jisas ka fata tegela faga ma ka 'ilo'oo, “Moru sia ngaria mola ta 'ola fana lekanga lo'oo, te'e fe'e kuba'u na'a tamooru ngaria. Ma moru sia ngaria mola ketonga, ma nga wa'i, ma nga bata. ");
INSERT INTO kwd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ta'a mooru ru'ufia nga tata'e butu, tafe'ua ma moru sia ngaria la'u rua me'e ruu. ");
INSERT INTO kwd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma alata te'efuta wane ngaia 'e kwalo 'amoru, moru to'oru fe'enia, leleka ma ka nigi na alata amooru leka fa'asia nga fanua no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma lauta moru nigi na nga fanua, ma nga ta'a no'ona gila 'ame kwaloa mooru, ma gila 'ame siria mola longonga famooru, moru leka fa'asiga. Ma moru ka tafula furufuruna wado fa'asia nga a'aemooru fana nga fa'abasunga faga na God te'e sufaga 'ania tofuna gila ma'asini te'enia longolana fatalana God.” ");
INSERT INTO kwd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma gila ka leka, ma gila ka foulange'enia fana ta'a 'agila bulota'i fa'asia nga abulongaa aga na 'ame le'a. ");
INSERT INTO kwd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma gila ka belote'enia nga adalo 'e aula, ma gila ka gwa'oa nga ta'a gila fii 'e aula, ma gila ka gulaga la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lo'oo, la Herod 'e nana'i ma ka longoa 'ola lo'oo suria la Jisas na ngaia 'e kwaifa'ananau ma ka gulaa ta'a. Ma latana la Jisas ka talofia no'o fanua te'efou. Ma tani ta'a ngaa'i gila ka 'ilo'oo, “La Jon wane ni naruabunga ngaia 'e moori la'u mola! Ngaia lo'oo 'e agea la'u nga 'ola ni 'alefosilai.” ");
INSERT INTO kwd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tani ta'a ngaa'i gila ka fata 'ilo'oo, “Ngaia la Elaeja, nga profet.” Ma tani ta'a ngaa'i gila ka fata 'ilo'oo, “Ngaia nga profet ngaa'i, 'ilaka'u ni profet laka'u mai na'o.” ");
INSERT INTO kwd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na alata la Herod ngaia 'e longoa 'ola lo'oori na'a ta'a gila fata 'ilo'oo suria la Jisas, ngaia ka fata 'ilo'oo, “La Jon nga wane laka'u ku kwatea fana folo mousilana gouna, ngaia 'e tata'e la'u fa'asia nga maenga lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","'Ina'o la Jon bi'i mae, la Herod ngaia 'e feea no'o ni Herodias, nga noni na wane gala futa la Filip. Ngai no'ona la Jon 'e fata 'ilo'oo fala Herod, “Nga tagi na God 'e ruia 'i'oo sia feea mola noni na wane molo futa.” Ngaia na'a, manatalana ni Herodias ka ria ba'ita no'o fala Jon, ma la Herod talana no'o ne'e firia ta'a fana gemasilana la Jon, ma gila ka arua 'i 'ubulana lokafu fa'asia ni Herodias. Herodias ka siria no'o 'agila kwa'ia, tafe'ua ma ngaia 'e 'ato fana 'ani kwa'ia tofuna la Herod ngaia 'e su'aai, la Jon ngaia nga wane 'e odo, ma nga wane 'e abu. La Herod ngaia ka ma'unge'enia la Jon, ma ngaia ka 'abelo 'ania la Jon. Lo'oo, la Herod ngaia 'e siria iiki fana longolana la Jon, tafe'ua ma ngaia 'e manata gelo alata na ngaia 'e longoa. ");
INSERT INTO kwd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma ni Herodias ka daria te'e alata le'a fana kwa'ilana la Jon. Na fe'e gani na'a la Herod ngaia 'e fa'aba'ita gani 'e futa ai, ngaia ka launge'enia te'e fafangalaa fana nga ta'a ba'ita aana, ma ni ta'a ba'ita aana fana fununga, ma nga ta'a na'ona'o na'a gila to'oru 'i 'ubulana gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma alata na laari'i ani Herodias ngaia 'e ru'u mai ma ka wa'e, ma la Herod fe'enia nga ta'a aana na gila keto fe'enia, gila malale'a ba'ita fe'enia. Ma la Herod ka fata 'ilo'oo fana nga laari'i lo'oori, “'Oi orisi nau mai fana te'efuta 'ola no'o 'i'oo siria, nau taku kwatea famu.” ");
INSERT INTO kwd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma ngaia ka fataarunga'inga fana ma ka alafuu 'ilo'oo, “'Olataa na 'i'oo siria agu, 'akui kwatea famu, tafe'ua ta gula 'ola na nga 'inato'onga lo'oo agu.” ");
INSERT INTO kwd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma nga laari'i lo'oori ka ru'u kau 'i maa ma ka leka no'o te'ana ni ga'ia, ma ka orisia 'ilo'oo, “Nga 'olataa na taku soea?” Ma ni ga'ia ka lamadu'aa ma ka 'ilo'oo, “Nga gouna la Jon wane ni naruabunga.” ");
INSERT INTO kwd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma nga laari'i lo'oori ka ori 'afe'aferu te'ala Herod, ma ka fata 'ilo'oo, “Nau ku siria 'oi kwatea mai nga gouna la Jon wane ni naruabunga fagu 'i fofona nga lafa na alata lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma la Herod ka kwaimanadai ba'ita tofuna 'ola lo'oori. Ma tafe'ua 'ani 'ino'ona, suria nga fataarunga'inga ne'e agea 'i na'ona nga ta'a na gila keto fe'enia, ngaia 'e sia ruia mola fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma ngaia ka alea te'e wane na fununga fana ngarilana mai nga gouna la Jon. Ma nga wane lo'oori ka ru'u 'i 'ubulana nga lokafu, ma ka folo mousia nga onomana la Jon, ");
INSERT INTO kwd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka ngaria mai nga gouna 'i fofona nga lafa, ma ka kwatea fana lari'i lo'oori, ma ngaia ka kwatea fana ni ga'ia. ");
INSERT INTO kwd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma alata nga fufu'iwane ala Jon gila longoa 'ola lo'oori, gila leka mai, ma gila ka ngaria no'o nonina, ma gila ka kwaiatoa no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ni Wane ni Kwairiinga ala Jisas gila ori no'o mai, ma gila ka ogu te'efou mai te'ala Jisas, ma gila ka kwairii 'ania 'ola na gila agea ma gila kwaifa'ananau suri'i. ");
INSERT INTO kwd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta'a 'e aula gila nigi mai fana lefu na la Jisas fe'enia ni wane na fufu'iwane ana gila to'oru ai. Ma gila 'ame to'o no'o na ta alata fana ketonga. Ma la Jisas ka fata 'ilo'oo faga, “Moru leka mai fe'eni nau fana nga lefu 'e aloalo, 'agoru mamalo madi ai.” ");
INSERT INTO kwd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma gila ka leka ni talaga na baru fana lefu ne'e aloalo. ");
INSERT INTO kwd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma gwa'a 'ani 'ilo'oo, ma nga ta'a 'e aula fa'asia nga fanua te'efou gila aga su'aga, ma gila ka totola 'i na'oga, ma gila ka nigi no'o 'i na'oga. ");
INSERT INTO kwd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma alata la Jisas ngaia 'e sifo fa'asia nga baru, ngaia ka agasia nga ogunga ba'ita no'o na, ma ngaia ka kwaimanadai ba'ita faga, suria gila ta'ua nga sifisifi na nga wane 'amoe fana aganga suriga. Ma ngaia ka fa'ananauga 'ania ni 'ola 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma alata na nga sina 'e la'u folo no'o, fufu'iwane aana gila ka leka mai te'ana, ma gila ka fata 'ilo'oo, “Gula lo'oo nga ta'a 'ame to'oru ai, ma nga sina ka la'u folo no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Oi iiria na nga ta'a lo'oo 'agila ori no'o fana 'agila leka fana maa'e fanua na ngai ri'itaga, 'agila foria nga ketonga faga.” ");
INSERT INTO kwd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tafe'ua, ma ngaia 'e iiria ma ka 'ilo'oo, “Mooru moru kwatea ketonga faga.” Ma gila ka fata 'ilo'oo fana, “'Ino'ona ma 'i'oo siria ameeru kwatea no'o bata 'e aula, nga aulalana 'e to'omia foforinga na wane fana kwaru singari, fana 'ameru foria na beret 'ani to'omia fana fangarilana ogunga lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma la Jisas ka orisiga maka fata 'ilo'oo, “Fita me'e beret na moru to'o ai? Leka ma mooru aga mai 'ofia.” Ma alata gila daria, gila ka fata 'ilo'oo, “Nima me'e beret fe'enia nga rua gweii'a.” ");
INSERT INTO kwd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sui ma la Jisas bi'i iiria fana fufu'iwane aana fana 'agila iiria fana ta'a 'agila to'oru 'i wado oguogu fofona farisi. ");
INSERT INTO kwd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma gila ka to'oru 'i wado 'ania tangale'e wane ma tani wane ngaa'i gila ogu 'ania nima akwale'e wane. ");
INSERT INTO kwd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma la Jisas ka ngaria nga nima me'e beret lo'oori ma nga rua gweii'a lo'oori, ma ka aga 'ala'a fani langi, ma ka baatafea God. Ma ngaia ka ngaria me'e beret lo'oo, maka kwatea fana fufu'iwane aana, madi fana 'agila dalo'ia fana ta'a lo'oori. Ma ngaia ka dalo'ia la'u nga rua gweii'a lo'oori faga. ");
INSERT INTO kwd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma nga ta'a 'e aula lo'oori gila ka keto, ma gila ka bote te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma, nga fufu'iwane aana gila ka so'ofia nga furufuruna nga beret ma nga ii'a lo'oori, ma gila ka fa'afonua nga akwale'e kukudu ma rua ai. ");
INSERT INTO kwd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nga nima to'oni (5,000) wane na'a gila fanga. Nonigeni ma ni wela sika'a gila keto la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma 'i burina 'ola lo'oori, la Jisas ka alea nga fufu'iwane aana ma gila ka leka no'o fani gule'e asi 'ubulana nga baru fana fanua 'i Betsaeda. Ma ngaia ka to'oru 'i buri madi fana 'ani iiria fana nga oguogunga lo'oori 'agila ori no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma 'i burina nga ta'a lo'o gila ori, ngaia ka leka 'i gouna me'e busu 'ani fo'a ai. ");
INSERT INTO kwd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma alata ngaia 'e eta 'ani boniboni no'o mai, nga baru laka'u ngaia no'o 'ubulana dalototo'o ana asi, ma la Jisas 'e to'oru mola 'ua te'i ngaia 'i su'e. ");
INSERT INTO kwd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma ngaia ka agasia ni wane na fufu'iwane aana, gila kweo no'o na farutangaa, tofuna gila na'ofia nga iiru. Ma alata 'e dalototo'o na logo, la Jisas ka leka 'i fofona nga asi, ma ka leka mai te'aga. Ma ngaia 'e galangi riufiga no'o. ");
INSERT INTO kwd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma nga alata gila agasia na ngaia 'e leka 'i fofona nga asi, gila ka madafia iiria ngaia nga nunu'i 'ola. Ma gila ka o'omae ba'ita, ");
INSERT INTO kwd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tofuna gila ma'u 'e iiki, na alata gila te'efou gila agasia ngaia 'e leka fofona asi. Ma la Jisas ngaia ka 'afe'aferu ma ka fata kau te'aga ma ka 'ilo'oo, “Nau lo'o mola! Mooru sia ma'u mola.” ");
INSERT INTO kwd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sui ma ngaia ka ta'e 'i 'ubulana nga baru fe'eniga, ma nga iiru ka aloalo no'o. Ma gila ka 'alefo ba'ita, ");
INSERT INTO kwd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tofuna gila 'ame su'a mola na tegelangaa la Jisas 'e to'o ai fana fangarilana nima to'oni (5,000) wane laka'u 'ania te'e nima me'e beret. Suria manatanga aaga 'e boko 'e iiki fana madailana nga 'ola na'a gila agasia. ");
INSERT INTO kwd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gila olofolosia asi lo'oori, ma gila ka sifo na gule'e lefu 'i Genesaret, ma gila ka gwarua nga baru 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma alata gila 'akwasia mola nga baru, nga ta'a no'ona, gila 'afe'aferu gila aga su'a no'o ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma nga ta'a gila ka totola 'ubulana afirina fanua no'ona, ma gila ka ngaria mai nga wane fii 'i fofona nga fufu fana lefu na gila longoa la Jisas ngaia 'e to'oru ai. ");
INSERT INTO kwd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma ni lefu te'efou na la Jisas ngaia 'e leka ai, nga ta'a gila ngaria mai nga ta'a gila fii fana lefu na uusi'a, ma gila ka siria nga ta'a na gila fii 'agila gema to'ona madudu'ana ruu tekwa aana. Ma nga ta'a te'efou lo'oo gila gema to'ona, ma gila ka gwari'a no'o. ");
INSERT INTO kwd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nga Farasii ma tani ta'a ni kwaifa'ananaunga na nga tagi, gila leka no'o fa'asia 'i Jerusalem, ma gila ka ogu 'afuia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma gila ka agasia tani ta'a na fufu'iwane aana gila 'ame narufia mola nimaga 'i na'o, ma gila ka keto mola. Gila 'ame narufia nimaga 'ilaka'u nga falafala na Farasii gila iiria fana nga ta'a 'i Jiu 'agila agea suria. ");
INSERT INTO kwd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Lo'oo, nga Jiu ma ta'a na Farasii, gila agea suria falafala na wawarifuga na gila kwaifa'ananau mai 'ania. Ngaia 'e 'ato no'o 'agila keto lauta gila 'ame narufia mola nimaga 'ilaka'u nga falafala na naru nimanga. ");
INSERT INTO kwd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma alata gila ori mai fa'asia nga uusi'a, ngaia 'e 'ato 'agila keto, lauta gila 'ame narufia nimaga madi suria nga falafala aaga. Gila lo'o suria nga falafala aaga 'e aula, 'ilaka'u nga narufilana nga kakao, ma nga kuki, ma nga daoko. ");
INSERT INTO kwd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngai lo'oo, nga Farasii ma nga ta'a kwaifa'ananaunga na Tagi ala Moses, gila orisia la Jisas ma gila ka 'ilo'oo, “Fe'ua na fufu'iwane amu gila 'ame lo'o mola suria nga kwaifa'ananaunga na wawarifu dauru gila arua no'o mai, tofuna gila 'ame narufia mola nga nimaga 'i na'o madi, ma gila bi'i fanga?” ");
INSERT INTO kwd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma ngaia ka fata ma ka 'ilo'oo, “La Aesea, nga profet, ngaia 'e fata kwala'imori alata laka'u ngaia 'e giria nga 'ola na God 'e iiria suria mooru. Mooru nga ta'a na kotonga, 'ilaka'u ngaia 'e giria 'ilo'oo, ‘Nga ta'a lo'oo, gila fa'aba'ita nau mola 'ania alafuunga aaga, tafe'ua ma nga manatalaga ngaia 'e lalau fa'asi nau 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gila fo'asi nau tago mola, tofuna gila kwaifa'ananau mola suria tagi aaga 'i talaga, ma gila ka iiria, nga tagi na God lo'oo no'o!’ ");
INSERT INTO kwd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mooru moru rugasia nga tagi na God, ma mooru ka lo'o suria nga kwaifa'ananaunga na ta'a.” ");
INSERT INTO kwd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma la Jisas ka fata la'u 'ilo'oo faga, “Mooru moru su'a le'a suria bulosilana ma ririlana tagi na God, fana 'ani 'ilaka'u mooru lo'o suria nga falafala amooru. ");
INSERT INTO kwd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Suria la Moses laka'u 'e fata 'ilo'oo, ‘'Oi fa'aba'ita nga mama'a amu, ma ni tete'e amu.’ Ma ‘Ni dai na ngaia 'e fata ngadaa nga mama'a aana 'amoe tete'e aana, tagila kwa'ia 'ani mae.’ ");
INSERT INTO kwd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tafe'ua, ma mooru kwaifa'ananau kuta 'ilo'oo, 'ilaka'u ta wane ngaia 'e to'o na tani 'ola na ngaia 'e su'aai 'ani boonia 'ania ma'a aana 'amoe ni ga'ia, ma ka fata madi 'ilo'oo, ‘Nau taku kwatea no'o 'ola laka'u fana God.’ ");
INSERT INTO kwd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mooru moru iiria, ngaia 'e le'a mola fana ngaia 'e sia boonia mola ma'a aana ma ni ga'ia 'ania 'ola laka'u ngaia 'e fataarunga'i 'ania fana God eteeta. ");
INSERT INTO kwd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma 'ilaka'u nga kwaifa'ananaunga na moru arua, ngaia 'e kwaitatari no'o na fatalana God. Ma 'ola 'e aula 'e ria lo'oo na moru agea.” ");
INSERT INTO kwd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","La Jisas ngaia ka o'omae la'u mai fana nga ogunga ba'ita lo'oori gila nana'i te'ana ma ka fata 'ilo'oo faga, “Moru gwalongo mai fagu, ma moru su'aai. ");
INSERT INTO kwd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nga 'olataa na wane ngaia 'e 'ania, 'e 'ame kwatea nga rianga fana. Nga 'ola ne'e kwatea rianga, ne'e 'ita mai fa'asia nga manatalana wane na 'e agea wane 'e biribiri'a.” ");
INSERT INTO kwd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma alata la Jisas ngaia 'e 'akwasia nga ogunga no'o na, ngaia ka ru'u 'ubulana 'ifi, ma nga fufu'iwane aana gila ka orisia 'ani fa'awataga nga alafuunga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma la Jisas ka fata 'ilo'oo faga, “'ino'ona mai amooru moru 'ame su'a mola na 'ola lo'oo? Nga 'ola na wane ngaia 'e 'ania 'ame fa'agenia nga wane 'i na'ona God, ");
INSERT INTO kwd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tofuna fangalaa ngaia 'ame ru'u 'i 'ubulana nga manatalana wane. Ngaia 'e leka mola 'i 'ubulana nga ogana, ma ka leka te'enia mola 'i maa fa'asia nga nonina.” Nga alafuunga na la Jisas 'e iiria na, fangalaa te'efou, ngaia 'e le'a mola fana 'anilai. ");
INSERT INTO kwd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma la Jisas ka fata la'u 'ilo'oo, “Nga 'ola ne'e 'ita mai fa'asia nga manatalana wane, ngaia ne'e fa'agenia 'i na'ona God. ");
INSERT INTO kwd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tofuna nga rianga ne'e ru'u mai fa'asia 'ubulana nga manatalana wane, ngaia 'e kwatea 'ola 'e ria, ma ngaia ka beri, ma ngaia ka kwa'ia wane, ");
INSERT INTO kwd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma ngaia ka agemani kwaifafi, ma ngaia ka 'etela, ma ngaia ka agea 'ola 'e ria 'e aula, ma ka kotofia nga ta'a, ma ka abulo mala nga ku'ito, ma ka kwaisirii fana 'ola na wane ngaa'i, ma ka alasifo suria nga ta'a, ma ngaia ka lafua 'i talana 'i langi, ma ngaia ka kakakula. ");
INSERT INTO kwd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ma tofuna ni 'ola 'e aula 'e ria lo'oori te'efou ngaia 'e ru'u mai fa'asia nga manatalana, ngaia ne'e fa'agenia nga wane 'i na'ona God.” ");
INSERT INTO kwd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui mala Jisas ka leka no'o fa'asia nga lefu lo'oori, ma ka leka fana nga gule'e lefu 'i Taea. Ma ngaia ka ru'u 'i 'ubulana te'e 'ifi, suria ngaia 'ame siria ta wane 'ani su'ana na ngaia 'e to'oru 'ilo'oori, ma tafe'ua ngaia 'e 'ato no'o fana 'ani nagwa. ");
INSERT INTO kwd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma te'e noni 'e longo suria na la Jisas ngaia 'e nigi, ma ngaia ka leka 'afe'aferu mai, ma ka bobouruuru 'i maana 'a'aena la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma nga noni lo'oori, ngaia nga noni fa'asia 'i Fonisia 'ubulana ririfua 'i Siria, ma ngaia nga noni na 'ame Jiu, ma nga laari'i aana nga adalo 'e bo'ea. Ngai lo'oo, ngaia 'e soea la Jisas 'ani belote'enia nga adalo lo'oori fa'asia nga laari'i aana. ");
INSERT INTO kwd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma la Jisas ka fata 'ilo'oo fana noni lo'oo, “Nga wela laka'u 'agila keto 'i na'o. Ngaia 'ame le'a fana 'aku 'ui mola 'ania fangalaa na wela fana nga ku'ito.” ");
INSERT INTO kwd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma nga noni lo'oori ka lamadu'aa ma ka 'ilo'oo, “Alafa, gwa'a ku'ito ma, su'asuria 'agila 'ania mola furufuruna fangalaa ne'e 'esia 'i olofana lafa ni ketonga na wela.” ");
INSERT INTO kwd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma la Jisas ka fata 'ilo'oo fana, “'Oi ori kau 'i fanua amu. Nga adalo laka'u, ngaia 'e 'akwasia no'o nga laari'i amu tofuna lamadu'aanga lo'oori ngaia 'e faate'enia 'i'oo fito'o.” ");
INSERT INTO kwd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma ngaia ka ori 'i fanua, ma ka agasia nga laari'i laka'u aana eeno mola 'i fofona futa'i. Ma nga adalo laka'u 'e leka no'o fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui ma la Jisas ka 'akwasia no'o gule'e lefu 'i Taea, ma ka leka fa'asia 'i Saedon, na gule'e lefu na akwale'e fanua na gila fa'alata 'i Dekapolis, ma ka sifo no'o kau suria nga asi 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ta'a 'ilo'oori, gila ka ngaria mai te'e wane na aringana 'e boko ma nga fokana ka gelo te'ala Jisas, ma gila ka soea la Jisas fana 'ani arua nga nimana 'i fofona nga wane lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma la Jisas ka talaia fana nga lefu 'i talaga fa'asia nga oguogunga lo'oori, ma ngaia ka ru'u fe'enia 'u'una 'i 'ubulana rua aringana wane lo'oori. Ma ngaia ka ngisu maana 'u'una, ma ka galo 'i maana meana nga wane lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma, ngaia ka aga 'ala'a fani langi, ma ka mango tekwa tekwa, ma ka fata 'ilo'oo fana, “Efata!” na fatanga na Aramaik. Ngaia fa'aladamia, “'Ulasi no'o!” ");
INSERT INTO kwd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma nga alata no'ona mola, nga aringana nga wane lo'oori ka 'ulasi, ma ngaia ka longo no'o, ma nga fokana ka 'ulasi no'o, ma ngaia ka eta ka alafuu wataga no'o. ");
INSERT INTO kwd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tafe'ua ma la Jisas ngaia 'e ruia na ta'a no'ona gila sia kwairii mola te'ana te'efuta wane. Ma tafe'ua ngaia 'e rui tegela na nga ta'a lo'oo ma gila su'usu'u ma gila kwairii mola suria la Jisas na 'e gulaa nga wane lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma nga ta'a lo'oo gila longoa, gila ka 'alefo, ma gila ka fata 'ilo'oo, “Kwe fu'uwane! Ngaia 'e agea 'ola te'efou 'e le'a ba'ita! Ngaia gema na nga wane aringana 'e boko ma ka longo no'o, ma nga wane na fokana ngaia 'e tai, ma ka fata no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'Ame aburu mola 'i burina 'ola lo'oori, nga oguogunga ba'ita ngaa'i la'u gila ka ogu la'u mola mai. Ma alata no'ona me'e ketonga ka 'amoe no'o aga, ma la Jisas ka soea mai fufu'iwane aana, ma ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nau ku kwaimanadai no'o fana ta'a lo'oo, suria gila to'oru fe'eninau suria oru ma'e gani, ma nga fangalaa ka 'amoe no'o faga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma lauta gila molo'u, mai nau kua orite'eniga mola 'i fanua, gila ta 'esiga suria tala, suria nga fanua aaga gila to'oru ai 'e lalau.” ");
INSERT INTO kwd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma nga fufu'iwane aana gila ka fata 'ilo'oo, “'I fai na tagoru daria nga fangalaa ne'e te'e to'omia nga fangarilana ta'a 'e aula 'ilo'oo 'ubulana nga gule'e lefu langalanga na 'ame to'omia nga wane 'ani to'oru ai?” ");
INSERT INTO kwd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma la Jisas ka orisiga ma ka 'ilo'oo, “Te'e fita me'e beret na mooru to'o ai?” Ma gila ka lamadu'aa ma gila ka 'ilo'oo, “Fiu me'e beret.” ");
INSERT INTO kwd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma la Jisas ka iiria fana nga oguogunga lo'oori 'agila to'oru 'i wado. Ma, ngaia ka ngaria nga fiu me'e beret lo'oori, ma ka baole'a fana God, sui ma ka ngaria ma ka kwatea fana fufu'iwane aana, ma gila ka dalo'ia na nga oguogunga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma gila to'o la'u na tani gweii'a tarito'o. Ma la Jisas ngaia ka kwatea la'u baole'anga fana God, ma ka iiria fana fufu'iwane aana 'agila dalo'ia la'u na nga ta'a lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma gila ka keto leleka ma gila ka bote te'efou no'o. Ma 'i buri, nga fufu'iwane aana gila ka gonia no'o fufuruna fangalaa na ngaia 'e ole 'i 'ubulana fiu kukudu leleka maka fongu. ");
INSERT INTO kwd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma nga oguogunga lo'oori, ngaia 'e to'omia nga fai to'oni (4,000) wane. Ma la Jisas ka orite'eniga no'o fani fanua kwaitatari aaga, ");
INSERT INTO kwd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma ngaia fe'enia nga fufu'iwane aana, gila 'afe'aferu gila ka fane 'i 'ubulana baru, ma gila ka leka no'o fana nga gule'e lefu 'i Dalmanuta. ");
INSERT INTO kwd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma ta'a na Farasii gila leka mai, ma gila ka orisu'usu'u fe'enia la Jisas, ma gila siria 'agila irito'ona. Ma gila ka siria fana 'ani agea la'u ta 'ola ni 'alefosilai, 'ani faate'enia 'inato'onga na God 'e kwatea mai fana. ");
INSERT INTO kwd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma la Jisas ngaia ka mango tekwa tekwa, ma ka fata 'ilo'oo, “Nga ta'a ni dai na gila siria 'ola ni 'alefosilai lo'oo? Nau ku iiria nga 'ola kwala'imori famooru, nau ku sia faate'enia mola ta 'ola ni 'alefosilai fana te'efuta wane lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma ngaia ka 'akwasiga, ma ka fane no'o 'i 'ubulana baru, ma ka olofolo no'o fani gule'e asi. ");
INSERT INTO kwd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Alata gila 'ubulana asi, ni wane na fufu'iwane aana gila mabolosia fana ngarilana mai tani me'e beret. Te'e me'e beret momola na'a gila to'o ai 'ubulana nga baru. ");
INSERT INTO kwd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma la Jisas ka fa'abasuga ma ka 'ilo'oo, “Tamoru manata le'a suria mooru fa'asia nga iist na Farasii ma la Herod.” ");
INSERT INTO kwd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma gila ka alafuu 'i laloaga kwairiu suria iist lo'oo fana beret, ma gila ka 'ilo'oo, “Ngaia 'e fata 'ilo'oo suria goru 'ame ngaria mai ta me'e beret.” ");
INSERT INTO kwd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","La Jisas ngaia 'e su'aai na gila bobolosia, na ngaia 'e fata suria nga kwaifa'ananaunga ria na Farasii ma la Herod, ma ngaia ka fata 'ilo'oo faga, “Fe'ua na moru bi'i alafuu suria moru 'ame ngaria mai tani me'e beret? Moru 'ame su'a mola na 'ola lo'oo nau ku iiria famooru? Nau ku agasia manata lamooru 'e boko 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Moru agasia ma moru ka longoa nga 'ola 'e aula nau ku agea, tafe'ua ma moru 'ame su'a mola ai. Moru 'ame manata to'ona, ");
INSERT INTO kwd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","alata laka'u nau ku ngaria nga nima me'e beret laka'u fana nga nima to'oni (5,000) wane? Ma nga fita kukudu laka'u moru so'ofia na nga fufuruna fangalaa laka'u 'i 'ubulai leleka ma ka fongu?” Ma gila ka lamadu'aa fana gila ka 'ilo'oo, “Nga akwale'e kukudu ma ruaai.” ");
INSERT INTO kwd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma la Jisas ka kwaiorisi la'u ma ka 'ilo'oo, “Ma alata laka'u nau ku ngaria fiu me'e beret fana fai to'oni (4,000) wane, nga fita kukudu laka'u moru so'ofia fufuruna fangalaa fani 'ubulai leleka ma ka fongu?” Ma gila ka lamadu'aa ma gila ka 'ilo'oo, “Nga fiu kukudu.” ");
INSERT INTO kwd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma ngaia ka fata 'ilo'oo faga, “Fe'ua na mooru 'ame su'a mola na 'olataa na 'inau ku fata suria?” ");
INSERT INTO kwd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gila nigi na nga fanua 'i Betsaeda, ma ta'a gila ka ngaria mai te'e wane nga maana 'e logo, ma gila ka soea la Jisas fana 'ani galo ana. ");
INSERT INTO kwd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma la Jisas ka dau 'i nimana nga wane lo'oori, ma ka talaia fana 'i maa fa'asia nga fanua lo'oori. Ma la Jisas ka ngisu 'i maana nga wane lo'oori, ma ngaia ka arua nga nimana fafia. Sui, mai ngaia ka orisia ka 'ilo'oo, “'I'oo agasia ta 'ola?” ");
INSERT INTO kwd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma, nga wane laka'u ngaia ka aga 'ala'a, ma ka fata 'ilo'oo, “Nau ku agasia nga ta'a, gila 'ilaka'u nga ai, na gila riu kwairiu.” ");
INSERT INTO kwd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sui ma la Jisas ka arua la'u nga nimana fafia nga maana nga wane lo'oori na ruana alata. Ma nga wane lo'oori ka aga kwala'imori no'o, ma ka aga folaa no'o na 'ola te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma la Jisas ka iiria 'ani ori fani 'ifi aana, ma ka fata 'ilo'oo fana, “'I'oo sia leka 'ua fana fanua no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma la Jisas ma ni wane na fufu'iwane aana, gila ka leka fana fanua ri'itana nga fanua 'i Sesarea Filipae. Ma alata gila leka fai, ngaia ka orisia fufu'iwane aana ma ka 'ilo'oo, “'ino'ona ma ta'a gila madafia nau ni dai lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gila lamadu'aa ma gila ka 'ilo'oo, “Tani ta'a ngai gila iiria 'i'oo la Jon wane ni naruabunga na ngaia 'e moori la'u, ma tani ta'a ngaa'i gila iiria 'i'oo la Elaeja, nga profet, na ngaia 'e moori la'u, ma tani ta'a ngaa'i gila iiria 'i'oo ta wane na profet laka'u na 'e moori la'u.” ");
INSERT INTO kwd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma la Jisas 'e orisiga la'u ma ka 'ilo'oo, “Ma 'i amooru moru madafia nau ni dai?” Ma la Pita ka lamadu'aa ma ka 'ilo'oo, “'I'oo nga Kraes, nga wane na God 'e firia 'ani leka mai fana Alafa ni fa'amoorilana ta'a na God.” ");
INSERT INTO kwd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma la Jisas ka fata tegela faga ma ka 'ilo'oo, “Mooru moru sia kwairii mola agu nau nga Kraes fana 'ua ta wane.” ");
INSERT INTO kwd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma la Jisas ka eta fana fa'ananaulana fufu'iwane aana ma ka 'ilo'oo, “Nau, na Wela na Wane, na'a taku nonifii na ni 'ola 'e aula. Nga ta'a na'ona'o, ma nga fataabu ba'ita, ma ni wane kwaifa'ananaunga na Tagi ala Moses, tagila ma'asiri agu. Ma tagila kwa'i nau, ma oruna maa'e gani, nau taku tata'e fa'asia maenga.” ");
INSERT INTO kwd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma ngaia ka fata folaa suria 'ola lo'oori. Ma la Pita ka talaia sisika kau, ma ka fata tegela fala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tafe'ua, ma la Jisas ngaia 'e abulo, ma ka aga fana fufu'iwane aana, ma ka fata tegela fala Pita maka 'ilo'oo, “Saetan leka lalau kau fa'asia nau. Nga funi'oonga lo'oo amu, 'ola nga funi'oonga na wane no'ona mola, funi'oonga na God 'amoe.” ");
INSERT INTO kwd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sui, ma la Jisas ka soea mai nga oguogunga lo'oori ma nga fufu'iwane aana te'ana, ma ka fata 'ilo'oo, “Ni dai ne'e siria 'ani lado agu, ngaia 'e sia manata ba'ita mola suria ni 'ola fana 'i talana. Ngaia te'e 'uri fana 'ani mabolosia ngaia 'i talana, maka ngaria 'ai folo aana maka lado agu. ");
INSERT INTO kwd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ni dai ne'e ma'asiri na ladonga agu, tofuna ngaia 'e siria 'ani agea ni 'ola suria kwaisirii nga aana 'i talana, ngaia te'e talafia nga mooringa firi. Tafe'ua ma, ni dai ne'e 'uri fana ladonga agu fe'enia Kwairiinga Le'a lo'oo, maka mabolosia ngaia 'i talana, ngaia te'e to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lauta nga wane 'e to'o na 'ola te'efou 'ubulana moorilana, ma ka mae, ma ngaia te'e to'oru lalau fa'asia God, 'ola lo'oori sia agea mola ta le'anga fana. ");
INSERT INTO kwd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te'efuta wane 'e sia foria mola nga mooringa firi lo'oo 'ania nga bata ma 'ua ta 'ola ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma lauta te'efuta wane ngaia 'e noniria 'ani nau fe'enia fatalagu 'i 'ubulana gani lo'oo 'e ria, na alata nau 'aku nigi mai fe'enia nga enselo agu ma fe'enia nga tegelangaa ala Mama'a agu, nau Wela na Wane, taku noniria la'u mola 'ania.” ");
INSERT INTO kwd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma la Jisas ka alafuu la'u ma ka 'ilo'oo, “Nau ku iiria no'o famooru, tani wane amooru lo'oo, gila sia mae mola ma gila ka agasia God 'e ba'ita fafia ta'a aana 'ania tegelangaa.” ");
INSERT INTO kwd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'Iburina ono maa'e gani, la Jisas 'e talaia la Pita, ma la Jemes, ma la Jon, ma gila fane fana gouna me'e busu ne'e la'u 'i langi, ma gila ka to'oru ni talaga no'o ai. Ma alata gila aga, ma gila ka agasia la Jisas 'e bulota 'i na'oga, ");
INSERT INTO kwd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma nga ruu aana ka iloilo'a ma ka kwakwao'a no'o. 'E kwakwao'a ma ka riufia no'o nga ruu kwakwao'a na nga wane fofona fanua lo'oo 'i wado 'e narufia. ");
INSERT INTO kwd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma nga oru wane aana lo'oori gila ka agasia la Elaeja ma la Moses, gala ka faata'i tafanga'i mai te'aga, ma gala ka alafuu fala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma la Pita ka fata 'ilo'oo fala Jisas, “Alafa, ngaia 'e le'a ba'ita fana 'agoru to'oru 'ilo'oo. Alamia ameeru launge'enia oru 'o'oba, te'e ai famu, ta ai fala Moses, ma ta ai fala Elaeja.” ");
INSERT INTO kwd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma la Pita ngaia 'e fata 'ilo'oo suria ngaia 'ame su'a mola na 'ola na ngaia 'e iiria, tofuna gila ma'u 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma me'e kofa ka nigi mai ma nga nunufi ka talo fafiga. Ma te'e kwale'e 'ola ngaia 'e talo mai fa'asia nga me'e kofa lo'oo ma ka 'ilo'oo, “Ngaia no'o te'e wela mouta'ia agu na'a nau ku aile'a ba'ita fe'enia. Moru longo fana!” ");
INSERT INTO kwd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma gila ka aga 'afe'aferu ri'itaga, ma gila 'ame agasia no'o ta wane fe'enia, te'i ngaia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Alata gila sifo no'o mai fa'asia me'e busu lo'oori, la Jisas ka ruiga ma ka 'ilo'oo, “Mooru sia kwairii mola te'ana ta wane na 'ola lo'oo moru agasia, leleka ma ka nigi na alata 'inau, nga Wela na Wane, naku tata'e fa'asia nga maenga.” ");
INSERT INTO kwd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma gila ka lo'o suria nga fatalana, ma gila ka alafuu 'i laloaga kwairiu, ma gila ka 'ilo'oo, “Nga manate wane 'utaa lo'oo ngaia 'e iiria, ‘Nau taku tata'e fa'asia nga maenga?’” ");
INSERT INTO kwd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma gila ka orisia, gila ka 'ilo'oo, “Fe'ua nga wane kwaifa'ananaunga na Tagi ala Moses gila iiria la Elaeja na te'e nigi na'o nga Kraes?” ");
INSERT INTO kwd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma la Jisas ka iiria faga 'ilo'oo, “La Elaeja te'e nigi mai etaeta, fana 'ani sasaria ni 'ola te'efou. Tafe'ua, ma nga profet 'e giria la'u na Girigiringa Abu laka'u 'e 'ilo'oo, Wela na Wane te'e nonifii ba'ita ma nga ta'a tagila ma'asiri ana. ");
INSERT INTO kwd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nau ku iiria famooru, la Elaeja 'e nigi 'e sui no'o, ma nga ta'a gila ka agea mola 'ola ria na gila siria 'agila agea ta'ua Girigiringa Abu laka'u 'e alafuu no'o mai suria.” ");
INSERT INTO kwd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma alata gila nigi mai te'ana ni wane na fufu'iwane aga, gila ka agasia tani ogunga ba'ita gila ogu fafiga. Ma tani ta'a kwaifa'ananaunga na Tagi ala Moses gila orisu'usu'u fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma alata lo'oo ta'a gila agasia la Jisas, ma gila ka 'alefo ba'ita, ma gila totola kau, ma gila ka alafuu ni baole'a nga fana. ");
INSERT INTO kwd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma la Jisas ka orisia fufu'iwane aana ma ka 'ilo'oo, “'Ola taa lo'oo moru orisu'usu'u fe'eniga suria?” ");
INSERT INTO kwd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma te'e wane 'i 'ubulana nga ogunga lo'oori, 'e fata ma ka 'ilo'oo, “Wane ni fa'ananaunga 'ae, nau ku ngaria mai te'e alakwa lo'oo agu. Nga adalo 'e bo'ea, ma ngaia 'ame fata no'o. ");
INSERT INTO kwd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma alata nga adalo ngaia 'e nigi ana, ngaia te'e 'ui 'ania 'i wado. Ma nga fokana ka ngingisu bou no'o, maka ke'e ngiringiri no'o, ma nga nonina ka 'ai te'efou no'o. Mai nau ku soea nga fufu'iwane amu 'agila beloa nga adalo no'ona, tafe'ua ma ngaia 'e 'ato no'o faga.” ");
INSERT INTO kwd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma la Jisas ka iiria faga ma ka 'ilo'oo, “Mooru moru 'ame fito'o mola agu. Nau ku kweo no'o na abu fito'onga lo'oo amooru. Nau ku to'oru fe'enia mooru 'e nigi lo'oo no'o, to'omia amooru fito'o no'o agu. Ngaria mai nga wela no'ona te'agu.” ");
INSERT INTO kwd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma gila ka ngaria mai nga wela lo'oori te'ala Jisas. Ma alata nga adalo lo'oori ngaia 'e agasia la Jisas, ngaia ka 'ui 'ania nga wela kau 'i wado, ma ka ladagwa'usu, ma fokana ka ngingisu bou te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma la Jisas ka orisia nga ma'a ana wela lo'oori ma ka 'ilo'oo, “Nanitaa na ngaia 'e eta 'ilo'oo?” Ma ngaia ka lamadu'aa ma ka 'ilo'oo, “Ngaia 'ita no'o mai 'ua na alata ngaia 'e sisika. ");
INSERT INTO kwd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma alata 'e aula na ngaia 'e 'ui 'ania 'ubulana nga eele ma 'i 'ubulana nga ka'o, 'ani kwa'ia 'ani mae. Ma bala ngaia 'e to'omia mola 'i'oo 'ani manadaia mee'e mai, moko kwaibooni amee'e?” ");
INSERT INTO kwd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma la Jisas ka fata 'ilo'oo, “Lo'oo, 'i'oo fito'o agu! Nga 'ola te'efou ngaia 'e talawada'u mola fana ni dai na ngaia 'e fito'o agu.” ");
INSERT INTO kwd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma 'afe'aferu mola ma'a ana wela lo'oori ka o'omae ma ka 'ilo'oo, “Nau ku fito'o! 'Oi booni nau mai, fana nga fito'onga agu 'ani tegela'a ma ka faringa'a.” ");
INSERT INTO kwd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma alata la Jisas 'e agasia nga oguogunga lo'oori gila totola mai fana lefu lo'oori, ngaia ka fata 'ilo'oo fana nga adalo laka'u, “'I'oo nga adalo lo'oo 'i'oo fa'abokoa aringana wela lo'oo, moko bokosia fokana wela lo'oo, nau ku belote'enio 'ani 'oi ru'u mai 'i maa, ma 'osia ori la'u 'ani bo'ea la'u nga wela lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma nga adalo laka'u ka rii, ma ka ladagwa'usu, ma ka rugasia nga wela laka'u, ma ka ru'u no'o mai 'i maa fa'asia. Ma nga wela laka'u nga agasilana ka 'ilaka'u no'o na ngaia 'e mae. Ma nga ta'a 'e aula gila ka fata 'ilo'oo, “Ngaia 'e mae no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tafe'ua, ma la Jisas ka dau na nimana nga wela laka'u, ma ka tata'ea, ma ngaia ka tata'e no'o. ");
INSERT INTO kwd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma alata la Jisas ngaia 'e ru'u 'ubulana 'ifi, nga fufu'iwane aana gila ka orisia alata gila to'oru te'i gila ma gila ka 'ilo'oo, “Fe'ua ne'e 'ato no'o fameeru fana belolana nga adalo laka'u?” ");
INSERT INTO kwd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma la Jisas ka orisiga ma ka 'ilo'oo, “Te'e fo'anga mola na ngaia to'o belote'enia 'ania nga adalo 'ilo'oo, ma 'amoe no'o ta 'ola la'u.” ");
INSERT INTO kwd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Alata lo'oori, la Jisas ma nga fufu'iwane aana gila 'akwasia lefu lo'oori, ma gila ka leka fana gule'e lefu 'i Galili. Ma la Jisas ka 'ame siria fana te'efuta wane 'ani su'a na lefu na'a gila to'oru ai, ");
INSERT INTO kwd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tofuna ngaia 'e fa'ananaua fufu'iwane aana 'ilo'oo, “Nau, nga Wela na Wane, tagila kwate nau fana marimae agu, ma tagila kwa'i nau. Ma oruna maa'e gani 'i buri, taku tata'e la'u fa'asia maenga.” ");
INSERT INTO kwd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tafe'ua, ma fufu'iwane ala Jisas 'ame su'a na 'olataa na ngaia 'e iiria, ma gila ka ma'unge'enia mola orisilana. ");
INSERT INTO kwd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma alata gila nigi na fanua 'i Kapaneam, ma gila ka ru'u 'i 'ubulana 'ifi, la Jisas ka orisia nga fufu'iwane aana 'ilo'oo, “Nga 'olataa laka'u moru orisu'usu'u mai fafia suria tala?” ");
INSERT INTO kwd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tafe'ua, ma gila 'ame iiria ta 'ola, tofuna gila orisu'usu'u mai fafia ni dai aga na te'e ba'ita ma ka ula na'ona'o faga te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma la Jisas ka to'oru 'i wado, ma ka soea mai nga akwale'e wane ma ruaai laka'u aana te'ana, ma ka fata 'ilo'oo, “Lauta ni dai ne'e siria 'ani ula na'ona'o, ngaia 'ani arua ngaia 'ani 'ita'i, ma ngaia nga wane ni taunga'inga fana ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui ma la Jisas ka talaia mai te'e wela sisika, ma ka fa'aula 'i laloaga. Ngaia ka gwaea nga wela lo'oori, ma ka fata 'ilo'oo faga, ");
INSERT INTO kwd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Lauta ni dai ne'e kwaloa wela sisika 'ilo'oori na latagu, ngaia 'e kwalo nau no'ona. Ma lauta ni dai ne'e kwalo nau, ngaia 'ame kwalo nau mola te'i nau, tafe'ua ma ngaia 'e kwaloa la'u mola God ne'e kwate nau mai.” ");
INSERT INTO kwd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","La Jon ngaia 'e fata 'ilo'oo fala Jisas, “Wane kwaifa'ananaunga, 'imeeru meru agasia te'e wane 'e belote'enia nga adalo na latamu. Ma 'imeeru meru ruia ngaia 'e sia agea mola, suria ngaia wane 'amoe na oguogunga adauru.” ");
INSERT INTO kwd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma la Jisas ka fata 'ilo'oo, “Mooru sia ruia mola, suria ni dai ne'e agea nga 'ola ni 'alefosilai na latagu, ngaia 'e 'ato 'ani iiria 'ola 'e ria agu. ");
INSERT INTO kwd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lauta ta wane na ngaia 'ame marimae adauru, ngaia wane adauru no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nau ku iiria 'ola kwala'imori famooru, lauta te'efuta wane ne'e kwatea 'ola sisika malaa ta maa'e ka'o famooru, suria 'i mooru nga wane agu, maka ngari kwala'imori ai, foforinga aana no'ona no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Lauta nga wane 'e agea ta'a lo'oo gila malofi'a ma ka 'esiga fa'asia fito'onga aaga agu, 'e le'a fana 'agila gaua nga fou ba'ita 'i onomana, ma gila ka 'ui 'ania 'i 'ubulana nga matakwa. ");
INSERT INTO kwd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma lauta nimamu 'e talai'o fana rianga, 'oi folo mousia fa'asi'o. Ngaia te'e le'a mola famu fana 'i'oo 'ani to'oru aburu 'ubulana mooringa 'i langi fe'enia nga komikomi'i ninima, fa'asia 'i'oo bi'i sifo 'i 'ubulana lefu na kwa'ikwa'inga fe'enia rua ninima, na lefu na eele ngaia 'e nunula furifuri ma 'e sia mae la'u. ");
INSERT INTO kwd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma lauta 'a'aemu 'e talai'o fana rianga, 'oi folo mousia fa'asi'o. Ngaia te'e le'a mola famu fana 'i'oo 'ani to'oru aburu 'ubulana mooringa 'i langi fe'enia nga komikomi'i 'a'ae, fa'asia 'i'oo bi'i sifo 'i 'ubulana lefu na kwa'ikwa'inga fe'enia nga rua 'a'ae. ");
INSERT INTO kwd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma lauta mamu 'e talai'o fana rianga, 'oi lafua fa'asi'o. Ngaia te'e le'a mola famu lauta 'i'oo ru'u 'i 'ubulana mooringa 'i langi fe'enia te'e gule'e maa, fa'asia 'i'oo bi'i sifo 'i 'ubulana lefu na kwa'ikwa'inga fe'enia rua gule'e maa. ");
INSERT INTO kwd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nga lefu lo'oori, ‘Nga wawaa na gila 'ania nga ta'a, gila 'ame mae, ma nga eele ne'e nulafia ta'a 'e nunula furifuri.’” ");
INSERT INTO kwd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Suria gila arua nga eele 'i fofona ta'a te'efou, 'ilaka'u nga solti gila 'ui 'ania 'ubulana nga fanga. ");
INSERT INTO kwd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ma nga solti ngaia 'e le'a mola, tafe'ua, ma lauta na asilalai ngaia 'e 'amoe no'o fa'asia, ngaia 'e 'ato no'o 'agila agea 'ania ta 'ola 'ani asila la'u. “Ngaia lo'oo, moru fa'amalale'aa ta'a 'ilaka'u la'u nga solti ne'e fa'ale'aa nga fangalaa. Ma moru to'oru la'u mola na aloalonga 'i laloamooru kwairiu.” ");
INSERT INTO kwd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui ma la Jisas ka 'akwasia 'i Kapaneam, ma ka leka fana nga gule'e lefu 'i Judea, ma ka olofolo na ka'o 'i Jodan. Ma ta'a 'e aula gila ka ogu mai te'ana, ma ngaia ka fa'ananauga, 'ilaka'u ngaia 'e eta kwaifa'ananaunga no'o mai ai. ");
INSERT INTO kwd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma tani Farasii ngaa'i gila ka leka te'ala Jisas, ma gila siria 'agila irito'ona, ma gila orisia 'ilo'oo, “'Ino'ona ma ngaia 'e le'a mola fana wane 'ani rugasia nga noni aana?” ");
INSERT INTO kwd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma la Jisas ka orisiga la'u ma ka 'ilo'oo, “Nga 'olataa laka'u la Moses ngaia 'e fata tegela famooru 'ania suria 'ola lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma gila ka fata 'ilo'oo, “La Moses ngaia 'e alamia nga wane 'ani giria nga kabee 'ola fana rugate'enilana noni, ma ka kwatea fana nga noni aana, 'ani rubea no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma la Jisas ka fata 'ilo'oo, “La Moses ngaia 'e giria nga tagi lo'oo suria 'e 'ato no'o fana fa'ananau lamooru, suria nga manatanga mooru 'e ngasi 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tafe'ua, ma eta no'o mai na alata God 'e launge'enia nga 'ola te'efou, na Girigiringa Abu 'e iiria, ‘Ngaia 'e launge'enia wanewa'u ma nonigeni. ");
INSERT INTO kwd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tofuna 'ola lo'oori, wane te'e 'akwasia nga ma'a aana fe'enia ni ga'ia ma ka lado fe'enia nga noni aana, ");
INSERT INTO kwd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma gala tagala lau no'o fana te'e wane momola.’ Gaa'a nga rua 'ola mamatari'a 'amoe no'o, tafe'ua ma gala 'ilaka'u no'o te'e 'ola momola. ");
INSERT INTO kwd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ngaia na, 'ola God 'e gau sakua 'e sui no'o 'ilo'oo, ngaia 'e 'ato no'o fana te'efuta wane 'ani rubea la'u.” ");
INSERT INTO kwd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma alata la Jisas fe'enia nga fufu'iwane aana gila ori 'i 'ifi, gila ka orisia fana marutana 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma ngaia ka fata 'ilo'oo, “Lauta nga wane ngaia 'e ma'asiri na nga noni aana, ma ka feea la'u nga noni matari, ngaia 'e agemani no'o fafia nga noni aana. ");
INSERT INTO kwd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ngaia 'e 'ilo'oo la'u mola, lauta te'efuta noni 'e rugasia nga kwaiina, ma ka baia la'u nga wane matari ngaia 'e agemani no'o fafia nga kwaiina.” ");
INSERT INTO kwd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni ta'a ngaa'i gila ngaria mai ni wela sisika te'ala Jisas, 'ani dau 'i labega ma ka nanamate'eniga, tafe'ua ma fufu'iwane aana gila ka iila faga. ");
INSERT INTO kwd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma alata la Jisas ngaia 'e agasia 'ola lo'oori, ngaia ka baoria, ma ka fata 'ilo'oo faga, “Moru alamia ni wela sisika no'ona 'agila leka mai te'agu, ma moru sia ruiga la'u. Tofuna ni dai ne'e manata kwala'imori ma ka 'ilaka'u wela sisika, ngaia 'e to'omia fana nana'inga olofana foufoula na God. ");
INSERT INTO kwd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nau ku iiria 'ola kwala'imori famooru, lauta ta wane ne'e ngaia 'ame fito'o ba'ita 'ilaka'u nga wela sisika, ngaia 'e 'ato iiki 'ani ru'u 'i 'ubulana nga foufoula na God.” ");
INSERT INTO kwd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma ngaia ka gwaea ni wela sisika lo'oori, ma ka arua nga nimana fafiga, ma ka nanamate'eniga no'o. ");
INSERT INTO kwd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Alata la Jisas ngaia 'e etaa 'ani leka la'u kau suria nga tala, te'e wane ngaia ka totola mai, ma ka bobouruuru 'i na'ona. Ma ngaia ka orisia 'ilo'oo, “Wane kwaifa'ananaunga le'a, nga 'olataa le'a na'a nau taku agea fana 'aku to'o na nga mooringa firi?” ");
INSERT INTO kwd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma la Jisas ka lamadu'aa 'ilo'oo, “Fe'ua na 'i'oo soea nau 'ania wane le'a? Te'e futa wane 'ame le'a no'o, te'e God momola ne'e le'a. ");
INSERT INTO kwd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Ino'ona mai 'i'oo su'ana tagi na God laka'u 'e 'ilo'oo, ‘'I'oo sia kwa'ia mola ta wane, ma 'i'oo sia agemani kwaifafi mola, ma 'i'oo sia beria mola te'efuta 'ola, ma 'i'oo sia koto mola fana te'efuta wane, moko iiri ba'ita na mama'a amu ma ni tete'e amu.’” ");
INSERT INTO kwd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma ngaia ka fata 'ilo'oo, “Wane kwaifa'ananaunga, 'e 'ita no'o mai na alata nau ku sisika, nau ku lo'o suria nga tagi lo'oori te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma, la Jisas ka aga kau fana 'ania kwaimaanga, ma ka fata 'ilo'oo fana, “Te'e 'ola momola ne'e 'amoe 'ua. 'Oi ori kau moko fa'afori 'ania ni 'ola laka'u 'i'oo to'o ai te'efou, moko ngaria bata no'ona, moko kwatea fana nga ta'a gila galafa'a, ma to'o bi'i to'o na nga 'ola'angaa 'i langi. Sui, ma to'o bi'i leka mai suri nau.” ");
INSERT INTO kwd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma alata nga wane lo'oo 'e longoa mola 'ola lo'oori, nga maana ka aga tori no'o. Ma ngaia ka leka no'o fe'enia nga kwaimanadainga, tofuna na ngaia wane 'e dari'ola'a. ");
INSERT INTO kwd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui ma la Jisas ka aga fana ni wane na fufu'iwane aana, ma ka fata 'ilo'oo, “Ngaia 'ato 'e iiki fana nga ta'a 'ola'a 'agila ru'u 'ubulana foufoula ala God.” ");
INSERT INTO kwd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma nga fufu'iwane aana gila ka 'alefo na alafuunga lo'oori. Sui mala Jisas ka fata la'u 'ilo'oo faga, “Fu'uwela agu, ngaia 'e 'ato no'o fana nga ru'unga 'ubulana foufoula ala God. ");
INSERT INTO kwd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngaia 'ato 'e iiki fana nga kamel 'ani ru'u suria nga maa'e kwakwa sisika 'i 'a'aena nila. Tafe'ua ma ngaia 'e 'ato 'e riufia la'u fana nga wane 'ola'a 'ani ru'u 'i 'ubulana nga foufoula na God.” ");
INSERT INTO kwd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma nga fufu'iwane aana gila ka 'alefo ba'ita, tofuna gila madafia nga to'orunga na 'ola'angaa 'e 'ita mai fa'asia God. Ma gila kwaiorisi kwairiu aaga, ma gila ka 'ilo'oo, “'Ino'ona ma te'efuta wane 'ame to'omia no'o 'ani to'o na mooringa firi lo'o?” ");
INSERT INTO kwd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma la Jisas ka aga totonga'i faga ma ka fata 'ilo'oo, “Ngaia 'e 'ato no'o fana nga wane 'ani daria mooringa firi, tafe'ua ma fana God ngaia 'ame 'ato mola. Nga 'ola te'efou ngaia 'e talawada'u mola fana God.” ");
INSERT INTO kwd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma la Pita ka fata 'ilo'oo fana, “Meeru meru 'akwasia no'o 'ola te'efou ma meru ka lado no'o amu.” ");
INSERT INTO kwd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma la Jisas 'e lamadu'aa ma ka 'ilo'oo, “Lo'oo, nau ku iiria famooru, lauta nga wane 'e 'akwasia nga 'ifi aana, ma wane gila futa ma noni gila futa, ma la ma'a aana, 'amoe ni ga'ia, ma ni wela aana, ma wado aana, fagu fana nga Kwairiinga Le'a lo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ngaia te'e ngaria 'ola lo'oori 'e aula ma ka riufia alata lo'oo. Ma 'ifi 'e aula, ma wane gila futa, ma ni noni gila futa, ma ga'ia, ma ni wela aana, ma ni wado aana. Tafe'ua, ma ngaia te'e daria la'u nonifiinga. Ma nga alata no'ona te'e nigi mai, te'e to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tafe'ua, ni ta'a 'e aula na gila leka no'o 'i na'o, tagila ole 'i buri, ma nga ta'a 'e aula na gila leka kau 'i buri, tagila leka no'o 'i na'o.” ");
INSERT INTO kwd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","La Jisas fe'enia nga fufu'iwane aana, gila leka suria nga tala fani Jerusalem, ma la Jisas ka eta no'o 'i na'oga. Ma fufu'iwane aana gila ka 'alefo no'o, ma ni ta'a na gila leka kau 'i burina, gila ka ma'u no'o suria ta'a na'ona'o 'i Jiu na gila 'ubulana fanua 'i Jerusalem gila siria 'agila kwa'ia la Jisas. Ma la Jisas ka talaia nga akwale'e wane ma ruaai aana maka te'e 'idu kau fa'asia ta'a lo'oo. Ma ngaia ka bi'i kwairii faga suria nga 'ola na te'e lau aana. ");
INSERT INTO kwd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma ngaia ka fata 'ilo'oo, “Longoa! Goru fane fani Jerusalem, 'agila kwate nau, nga Wela na Wane, fana ni fataabu ba'ita fe'enia nga ta'a kwaifa'ananaunga na Tagi ala Moses. Ma tagila malate'ote'o agu fana maenga agu, ma tagila kwate nau fana nga ta'a na'a gila 'ame Jiu. ");
INSERT INTO kwd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma nga ta'a lo'oori tagila doo 'ani nau, ma tagila ngisufi nau, ma tagila kwa'i nau, ma tagila dau nau. Ma nga oruna gani, nau taku tata'e la'u fa'asia nga maenga.” ");
INSERT INTO kwd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sui ma, la Jemes ma la Jon, rua wela ala Sebedi, gala ka leka mai te'ala Jisas, ma gala ka fata 'ilo'oo, “Wane ni kwaifa'ananaunga, me'e mele siria 'i'oo 'ani agea te'e 'ola na mele siria amu.” ");
INSERT INTO kwd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma la Jisas ka kwaiorisi 'ilo'oo oguogu agaa'a, “'Ola taa na moo'o molo siria 'aku agea famoo'o?” ");
INSERT INTO kwd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma gaa'a gala ka lamadu'aa 'ilo'oo, “Alata na 'i'oo 'ani ba'ita fafia foufoula fe'enia ni 'ola te'efou, 'oi alamia ta wane amee'e 'ani to'oru 'i gula le'a amu, ma wane ngaa'i na gula moori amu fana ba'ita nga fafia ta'a lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tafe'ua, ma la Jisas ka fata 'ilo'oo agaa'a, “Moo'o molo bobolosia mola 'ola na molo soea. Moo'o molo to'omia mola 'amolo ngari fe'eninau na nonifiinga lo'oo 'aku nonifii 'ania? 'Ino'ona mai amoo'o molo to'omia 'amolo mae na maenga lo'oo nau taku mae kau ai?” ");
INSERT INTO kwd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma gala ka lamadu'aa ma gala ka 'ilo'oo, “Mee'e mele to'omia mola fana amele agea.” Ma la Jisas ka fata 'ilo'oo fagaa'a, “Lo'oo, ngaia 'e to'o fana amolo nonifii la'u 'ilaka'u 'inau. ");
INSERT INTO kwd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tafe'ua, mai nau ku sia firia mola ni dai na te'e to'oru 'i gula le'a agu ma 'i gula moori agu. Te'e God no'o na te'e kwatea nga lefu 'ilo'oo fana ni dai na gila sasari agau aaga 'e sui no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma alata nga akwale'e wane lo'oori gila longoa 'ola lo'oori, gila ka baoria fala Jemes ma la Jon. ");
INSERT INTO kwd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma la Jisas ngaia 'e oguga ma ka fata 'ilo'oo faga, “Mooru moru su'a na alafa na ta'a na'a gila 'ame Jiu, gila to'o na tegelangaa fafia ta'a, ma wane ba'ita aaga gila su'a le'a na usunge'enilana wane fana agelana 'ola gila siria. ");
INSERT INTO kwd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tafe'ua, ngaia 'ame 'ilo'oo la'u 'i laloamooru. Lauta ta wane amooru ngaia 'e siria 'ani ba'ita, ngaia 'ani 'uri fana 'ani lau fana wane ni taunga'inga famooru. ");
INSERT INTO kwd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma lauta ni dai amooru ne'e siria 'ani ula na'ona'o, ngaia 'ani taunga'i tago fana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tofuna 'inau, nga Wela na Wane, nau ku 'ame leka mai fana nga ta'a 'agila taunga'i fagu. Tafe'ua, ma 'inau ku leka mai fana 'aku taunga'i fana nga ta'a te'efou, mai nau ku kwatea nga mangogu fana fa'amoorilana nga ta'a 'e aula.” ");
INSERT INTO kwd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na alata lo'oori, la Jisas fe'enia nga fufu'iwane aana gila nigi no'o mai na fanua 'i Jeriko. Ma alata gila 'akwasia no'o fanua lo'oori fe'enia nga ogunga ba'ita lo'oori, te'e wane na maana 'e logo ngaia 'e to'oru mola 'i gegena nga tala fana nga kwaisoenga. Ngaia latana la Batimeas, nga wela ala Timeas. ");
INSERT INTO kwd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma alata ngaia 'e longoa la Jisas, nga wane 'i Nasaret, ngaia 'e leka mai, Batimaes ka o'omae 'ilo'oo, “Jisas 'I'oo nga alakwa na fufutanga ala Defete, 'oi laetafii nau mai.” ");
INSERT INTO kwd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma nga ta'a gila ka baoria, ma gila ka iiria fana 'ani to'oru aloalo. Tafe'ua, ma ngaia bi'i o'omae ka ba'ita la'u maka 'ilo'oo, “Alakwa na fufutanga ala Defete, 'oi laetafii nau mai!” ");
INSERT INTO kwd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma la Jisas ka ula maka fata 'ilo'oo, “Moru soea mai.” Ma gila o'omae fala Batimeas, ma gila fata 'ilo'oo, “'Oi malale'a! Tata'e, la Jisas ngaia 'e soe'o no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma ngaia ka to'osia ruu tekwa laka'u ana fana 'ani leka 'aferu, ma ka tata'e 'afe'aferu, ma ka leka no'o te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma la Jisas 'e orisia ma ka 'ilo'oo, “'Ola taa na 'i'oo siria 'aku agea famu?” Ma nga wane lo'oori maana 'e boko ka du'aa la Jisas ma ka 'ilo'oo, “Wane ni Kwaifa'ananaunga, nau ku siria 'aku aga la'u.” ");
INSERT INTO kwd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma la Jisas ka fata 'ilo'oo fana, “Leka no'o kau, moko aga no'o tofuna na 'i'oo fito'o agu.” Ma 'afe'aferu mola nga maana ka aga no'o, ma ngaia ka lado no'o ala Jisas suria nga tala. ");
INSERT INTO kwd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Alata la Jisas fe'enia ni fufu'iwane ana gila nigi galangia nga fanua 'i Jerusalem, gila nigi na fanua 'i Betefeis ma fanua 'i Betani, gouna nga busu na gila iiria 'ania 'i Olif. Ma ngaia ka kwatea rua wane aana, gaa'a gala ka leka no'o 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma ngaia ka fata 'ilo'oo fagaa'a, “Molo leka kau fana fanua loko'u molo na'ofia kau. Ma alata molo nigi 'i no'ona, tamolo agasia te'e dongki. Gila gaua mola dongki no'o na, ma ta wane 'ame ta'e 'ua fofona. Moo'o molo rubea, ma molo ka talaia mai 'i lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma lauta te'efuta wane 'e orisi 'amoo'o, ‘Fe'ua na molo rubea nga dongki lo'oo?’ Molo iiria fana, ‘Nga Alafa ngaia 'e siria no'o, ma ngaia te'e orite'eni 'aferu mola mai ai 'i lo'oo.’” ");
INSERT INTO kwd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma gala ka leka, ma gala ka agasia nga te'e dongki gila gaua mola 'i gegena nga tala 'i maana te'e 'ifi. Ma alata gala rubea, ");
INSERT INTO kwd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tani wane na gila ula 'i no'o na, gila ka orisia agaa'a 'ilo'oo, “'Ola taa na'a molo rubea nga dongki no'ona fai?” ");
INSERT INTO kwd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma gala ka lamadu'aa faga 'ilaka'u la Jisas 'e iiria agaa'a, ma nga ta'a lo'oori gila ka alamia no'o fagaa'a. ");
INSERT INTO kwd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma gala ka talaia no'o nga dongki lo'oori te'ala Jisas, ma gala ka lafaate'enia ni ruu tekwa aaga 'i fofona, ma la Jisas ka fane fofona. ");
INSERT INTO kwd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nga ta'a 'e aula gila ka lafaate'enia ni ruu tekwa aaga 'i suria nga tala, ma tani ta'a ngaa'i gila ka tofua nga lalana baibai, ma gila ka lafaate'enia suria nga tala. Gila agea 'ola lo'oori fana fa'aba'italana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma ta'a te'efou na gila leka fe'enia, tani ta'a ngaa'i gila ka leka no'o 'i na'o, fe'enia tani ta'a ngaa'i na gila leka mai 'i buri, gila o'omae ma gila 'ilo'oo, “Iiri ba'ita na God! God 'oi nanamate'enia mai nga wane ne'e leka mai 'ania nga tegelangaa amu! ");
INSERT INTO kwd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God 'oi nanamate'enia mai nigilana nga foufounga ne'e 'ilaka'u nga foufounga ala Defete wawarifu meeru! Iiri ba'ita na God ngaia 'e to'oru 'i Langi!” ");
INSERT INTO kwd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","La Jisas ngaia 'e ru'u 'i 'ubulana nga fanua 'i Jerusalem, ma ka leka 'i 'ubulana nga 'Ifi Abu na God. Ngaia 'e aga kwairiu, ma ka agasia 'ola te'efou. Tafe'ua, ma suria ngaia 'e galangi boniboni no'o, ngaia ka leka no'o fani Betani fe'enia nga akwale'e wane ma ruaai aana. ");
INSERT INTO kwd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma fe'e gani 'i burina, alata la Jisas ma fufu'iwane aana gila ori no'o mai fa'asia 'i Betani, la Jisas ka molo'u. ");
INSERT INTO kwd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma ngaia 'e aga kau, ma ka agasia te'e 'ai 'e bunguta na gila fa'alata nga figi. Ma ngaia ka leka galangia 'ani agasia ta lode 'ola ai. Tafe'ua, ma alata ngaia 'e nigi 'i 'a'aena, ngaia ka 'ame agasia ta lode 'ola, suria alata lo'oori nga 'ai 'agila ula fooru la'u. ");
INSERT INTO kwd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma la Jisas ka fata 'ilo'oo fana nga figi lo'oori, “Te'efuta wane 'esia 'ania la'u nga lode 'ola amu!” Ma fufu'iwane aana gila ka longoa 'ola lo'oori ngaia 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma alata gila nigi 'i Jerusalem, la Jisas 'e leka 'i 'ubulana nga 'Ifi Abu na God. No'ona, ngaia ka beloa nga ta'a te'efou na gila fori ma gila ka fa'afori 'ania nga 'ola fana tabonga. Ma ngaia ka geua nga fofoda na ta'a lo'oori na gila lamadu'aa nga bata 'i Rom fana bata 'i Jiu, ma ka geua nga 'ola fana nana'inga na ta'a lo'oo na gila fa'afori 'ania nga toruodu. ");
INSERT INTO kwd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mai ngaia 'ame alamia no'o ta wane 'ani ngaria te'efuta 'ola fana fa'aforinga ai 'i 'ubulana nga 'Ifi Abu ala God. ");
INSERT INTO kwd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na alata lo'oori, ngaia ka fa'ananaua nga ta'a, ma ka fata 'ilo'oo, “la God 'e iiria 'i 'ubulana nga Girigiringa Abu 'ilo'oo, ‘Nga 'ifi agu, nga 'ifi ni fo'anga fana nga ta'a na fanua lo'oo 'i wado te'efou.’ Tafe'ua, mai 'amooru, moru bulote'enia mola fana nga lefu fana beringa.” ");
INSERT INTO kwd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na alata, ni fataabu ba'ita fe'enia nga wane ni kwaifa'ananaunga na Tagi ala Moses, gila longoa 'ola lo'oori, ma gila ka etaa gila ka kwailo no'o fana ta 'ola 'agila agea fana kwa'ilana la Jisas. Tafe'ua, ma gila ma'unge'enia, tofuna na ogunga lo'oori te'efou, gila 'alefo ba'ita na nga kwaifa'ananaunga aana. ");
INSERT INTO kwd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ngaia 'e laulafi no'o, la Jisas ma nga fufu'iwane aana, gila ka leka no'o fa'asia 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nga 'usugani 'i burina, la Jisas fe'enia nga fufu'iwane aana gila ka leka kau suria nga tala. Gila agasia nga figi laka'u ngaia 'e gu'a te'efou no'o leleka maka sifo no'o suria nga 'umi'umina. ");
INSERT INTO kwd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma la Pita ka manata to'ona 'ola laka'u la Jisas ngaia 'e iiria na 'ai no'ona, ma ka fata 'ilo'oo fana, “Wane ni kwaifa'ananaunga, agasia madi nga 'ai laka'u 'i'oo abuia, 'e gu'a no'o!” ");
INSERT INTO kwd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma la Jisas ngaia ka lamadu'aa maka 'ilo'oo, “Mooru tagoto'o kwala'imori na God. ");
INSERT INTO kwd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nau ku iiria famooru, lauta moru alafuu 'ilo'oo fana nga busu lo'o, ‘'Oi tata'e, moko 'ui 'ani'o 'i talamu 'ubulana nga asi,’ ma mooru 'ame fitala 'i 'ubulana nga mango mooru, ma moru ka fito'o kwala'imori na 'ola na moru iiria 'ani lau, 'ola no'ona te'e lau mola famooru. ");
INSERT INTO kwd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngai lo'oo nau ku iiria famooru 'ilo'oo, alata moru fo'a, ma moru kwaisoe fana te'efuta 'ola, moru fito'o kwala'imori 'ilaka'u na moru ngaria no'o, ma God te'e kwatea mola nga 'ola na moru soe aana. ");
INSERT INTO kwd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Lo'oo, alata moru fo'a, moru 'olafanataa na rianga na wane na ngaia 'e agea amooru, ta'ua na Mama'a amooru ne'e to'oru mai 'i Langi maka 'olafanataa la'u na rianga amooru.” ");
INSERT INTO kwd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","La Jisas fe'enia fufu'iwane aana, gila ori la'u mai fani Jerusalem. Ma alata la Jisas 'e leka kau 'i 'ubulana 'Ifi Abu na God, ni fataabu ba'ita, ma nga ta'a ni kwaifa'ananaunga na nga Tagi ala Moses, ma nga ta'a na'ona'o 'i Jiu te'efou, gila ka leka mai te'ana. ");
INSERT INTO kwd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma gila ka kwaiorisi 'ilo'oo ana, “Nga tegelangaa taa na 'i'oo to'o ai fana nga agelana 'ola lo'oo, ma ni dai ne'e kwatea nga tegelangaa lo'oo famu?” ");
INSERT INTO kwd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma la Jisas ka lamadu'aga 'ilo'oo, “Lo'oo, nau ku orisia mooru madi 'ania te'e 'ola. Lauta moru lamadu'aa, mai nau taku bi'i kwairii te'amooru na nga 'inato'onga na 'inau ku to'o ai fana agelana 'ola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lo'oo, moru mani longo madi fagu, nga 'inato'onga na la Jon ngaia 'e to'o ai fana nga naruabunga ngaia 'e eta mai fa'asia ni dai? Ngaia 'e eta mai fa'asia la God, 'amoe ma ngaia 'e eta mola mai fa'asia nga wane?” ");
INSERT INTO kwd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma gila ka etaa fana orisu'usu'unga 'i laloaga kwairiu ma gila 'ilo'oo, “'Ola taa na tagoru iiria? Lauta goru lamadu'aa ma goru 'ilo'oo, ‘Fa'asia God,’ ngaia te'e fata 'ilo'oo, ‘'Ino'ona ma 'utaa na moru 'ame fito'o ala Jon?’ ");
INSERT INTO kwd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma ngaia 'ame le'a la'u mola fana 'agoru fata 'ilo'oo, ‘Ngaia eta mai fa'asia wane.’” Gila fata 'ilo'oo tofuna gila ma'unge'enia nga ta'a, tofuna nga ta'a te'efou gila su'ana la Jon ngaia nga profet kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngaia na, gila lamadu'aa fala Jisas ma gila ka fata 'ilo'oo, “Meeru meru bobolosia mola.” Ma la Jisas ka fata 'ilo'oo faga, “'Ino'ona mai nau ku sia kwairii mola na nga 'inato'onga agu na 'inau ku agea 'ania ni 'ola lo'oo famooru.” ");
INSERT INTO kwd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui, ma la Jisas ngaia ka alafuu fana ta'a ba'ita 'i Jiu laka'u 'ania tarifulaa 'ilo'oo, “Te'e wane ngaia 'e kirua nga langa'a 'e le'a. Mai ngaia ka launge'enia feo 'afuia, ma ka 'eria nga kiru fana nga memelana lode 'ai fana launge'enilana waen, ma ka launge'enia te'e 'ifi fana wane ni folonga. Mai ngaia ka arua nga langa'a aana 'i nimana ta'a na gila taunga'i ai. Sui, mai ngaia ka leka no'o fana fanua ngai. ");
INSERT INTO kwd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma alata nga langa'a lo'oori 'e mena, ngaia ka alea nga wane ni taunga'inga aana te'ana ni wane na'a gila taunga'i 'i 'ubulana langa'a lo'oo aana, 'agila kwatea mai ta gula na lodo na 'ola na gila goni'i. ");
INSERT INTO kwd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tafe'ua ma ni wane ni taunga'i lo'oori gila gau ngasingasi ana, ma gila kwa'ia, ma gila ka orite'eni tago mola ana. ");
INSERT INTO kwd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma, nga wane laka'u 'e to'o na nga langa'a lo'oori ngaia ka kwatea la'u mai nga wane ngaa'i fana taunga'inga. Ma nga ta'a na gila taunga'i 'i 'ubulana langa'a, gila ka kwa'ia gouna, ma gila ka mala mani ana. ");
INSERT INTO kwd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sui, ma wane laka'u 'e to'o na nga langa'a, ngaia ka kwatea la'u nga wane ni taunga'inga aana, ma gila ka kwa'ia ma ka mae no'o. Ma gila ka agea la'u 'ilo'oo na ni wane 'e aula ne'e alega 'i buri. Gila kwa'ia tani wane ngaa'i, ma gila ka kwa'ia tani wane ngaa'i ma gila ka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lo'oo, nga te'e wane momola ne'e ole no'o na te'e wela mouta'i aana na ngaia 'e kwaimaange'enia. Ma ngaia ka kwatea wela aana 'i langa'a, ma ngaia ka manata 'ilo'oo, ‘Tagila iiri ba'ita na wela lo'oo agu.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tafe'ua, ma ni wane na gila taunga'i 'i 'ubulana langa'a no'ona, gila fata faga kwairiu ma gila 'ilo'oo, ‘Ngaia no'o na wela na wane laka'u ngaia 'e to'o na nga langa'a. Leka mai 'agoru kwa'ia, fana 'agoru to'o na ni 'ola lo'oo ana te'efou.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma gila ka ngaria nga wela lo'oori, ma gila ka kwa'ia maka mae no'o, ma gila ka 'ui 'ania nga nonina 'i maa fa'asia 'ubulana nga langa'a lo'oori.” ");
INSERT INTO kwd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma la Jisas ka kwaiorisi 'ilo'oo, “'Ola taa na wane ne'e to'o na nga langa'a lo'oori te'e agea? Ngaia te'e nigi mai, ma te'e kwa'i mousia ni wane lo'oori. Sui ma ngaia ka kwatea no'o langa'a aana fana ni wane matari. ");
INSERT INTO kwd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ngaia 'e kwala'imori fana 'amoru idumia nga Girigiringa Abu laka'u ngaia 'e fata 'ilo'oo, ‘Nga fou na wane 'e tofua 'ifi aana ai gila ma'asiri ai, ngaia na fou 'e taringa'i maka riufia nga fou te'efou na bani. ");
INSERT INTO kwd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God 'e alamia 'ola lo'oo, ma nga agasilai ka lau.’” ");
INSERT INTO kwd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nga ta'a na'ona'o 'i Jiu, gila siria 'agila kwa'ia la Jisas, tofuna gila su'aai la Jisas 'e alafuu suria tarifulaa lo'oori 'i suriga. Tafe'ua, mai, gila ma'u la'u mola na ogunga lo'oo, ma gila ka 'akwasia, ma gila ka leka no'o. ");
INSERT INTO kwd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ni ta'a na'ona'o, gila alea tani Farasii ma tani wane na ta'a ala Herod fana fa'abobolosilana la Jisas 'agila irito'ona. ");
INSERT INTO kwd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lo'oo, gila nigi no'o te'ana, ma gila ka fata 'ilo'oo, “Wane kwaifa'ananaunga, 'imeeru meru su'ana 'ola 'i'oo iiria, 'ola kwala'imori te'efou lo'oo no'o. 'I'oo kwaifa'ananau suria 'inato'onga ma kwaisiriinga na God fana nga ta'a. Ma 'i'oo 'ame ma'unge'enia ta wane alata 'i'oo alafuu suria to'onga. Ma 'i'oo 'ame manata fana nga fa'aba'italana wane. Lo'oo, 'i'oo iiria mola fameeru! Fe'ua, ngaia 'e le'a mola fana kwatelana nga bata na takisi fana nga ta'a na'ona'o 'i Rom? Ngaia 'utaa? Ngaia 'ame to'omia ameeru kwatea takisi laka'u?” ");
INSERT INTO kwd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tafe'ua, ma la Jisas ngaia 'e su'a mola na kotonga aaga, ma ngaia ka orisiga 'ilo'oo, “Fe'ua moru bi'i agea nga 'ola fana irito'o lagu? Mooru ngaria mai fe'e seleni fana 'aku agasia madi.” ");
INSERT INTO kwd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma gila ka ngaria mai fe'e seleni, ma ngaia ka kwaiorisi 'ilo'oo, “Nga nunu ni dai lo'oo? Ma nga latana ni dai na ngai ai?” Ma gila ka lamadu'aa, ma gila 'ilo'oo, “Nga nununa ma nga latana nga wane ba'ita 'i Rom.” ");
INSERT INTO kwd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma la Jisas ka fata 'ilo'oo, “Moru kwatea fana nga wane ba'ita 'i Rom nga 'ola aana, ma moru ka kwatea la'u mola 'ola na God fana God.” Ma gila ka 'alefo ba'ita no'o ana. ");
INSERT INTO kwd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma, tani Sadusi gila leka mai te'ala Jisas. Nga Sadusi gila iiria nga wane gila sia tata'e la'u fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma gila ka orisia la Jisas ma gila ka fata 'ilo'oo, “Wane kwaifa'ananaunga, la Moses ngaia 'e giria nga tagi fadauru maka kwaialami 'ilo'oo, ‘Lauta ta wane 'e mae, ma nga noni aana 'e moori 'ua, ma ngaia 'ame to'o na wela, nga wane ni futanga aana te'e feea la'u nga nao lo'oori, 'agala to'o na wela fana 'ani lamadu'aa nga wane lo'oo 'e mae fana orioritana 'ani ori.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lo'oo, nga te'e alata ngai, fiu waiasina gila to'oru. Ma nga wane ngaa'i na'o 'e feea te'e noni, ma ka 'ame arua mola ta wela, ma wane lo'oori ka mae mola. ");
INSERT INTO kwd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui ma, ruana wane ka feea la'u nga noni laka'u, ma ngaia 'ame arua mola ta wela, ma ka mae la'u mola. Sui ma oruna wane ka 'ino'ona la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka 'ilo'oo la'u mola fana ni wane ngai burina te'efou. Nga fiu waiasina lo'oori te'efou na gila feea noni lo'oori, ma gila 'ame to'o mola na wela, ma gila ka mae mola te'efou. Ma 'ita'i lana, noni lo'oori ngaia ka mae la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'Ino'ona ma, nga alata na God 'ani tata'ea fu'uwaiasina na gila mae te'efou ni dai aaga na noni aana te'e lau? Suria nga fiu waiasina lo'oori gila feea nga noni lo'oori te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma la Jisas ka lamadu'aga ma ka 'ilo'oo, “Mooru moru kuta 'e iiki, suria moru 'ame su'a mola na nga Girigiringa Abu ma nga tegelangaa na God. ");
INSERT INTO kwd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Suria, alata nga fu'uwaiasina gila mae 'agila tata'e la'u fana nga mooringa, gila aaga 'ilaka'u no'o nga enselo 'i Langi na gila sia feea mola noni lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lo'oo, nau ku fa'ananaua mooru suria nga tata'enga fa'asia nga maenga. Nau ku su'aai mooru moru idumia 'ubulana nga girigiringa ala Moses na lefu laka'u suria nga eele ngaia 'e nulafia nga busu na ai laka'u. La God ka fata fala Moses 'ilo'oo, ‘Nau, nga God ala Ebraham, ma la Aesak, ma la Jekob gila fo'asia 'ua.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ngaia 'e iiria 'ilo'oo, wane lo'oori na gila mae no'o, God ngaia 'e iiria na'a God aaga 'ua, tofuna gila moori 'ua fe'enia. Mooru moru kuta 'e iiki!” ");
INSERT INTO kwd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma te'e wane kwaifa'ananaunga na Tagi ala Moses, ngaia 'e longoa alafuunga lo'oori. Mai ngaia ka su'ana nga lamadu'aanga le'a la Jisas 'e kwatea fana ta'a Sadusi. Mai ngaia ka leka mai, ma ka orisia la Jisas 'ilo'oo, “Nga tagi 'utaa ne'e ba'ita 'e riufia ni Tagi ala Moses te'efou?” ");
INSERT INTO kwd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma la Jisas ngaia ka fata 'ilo'oo, “Nga tagi ba'ita ne'e riufia tagi te'efou ne'e 'ilo'oo, ‘Ta'a 'i Jiu, mooru fafulongo! Nga God adauru, ngaia no'o te'e God momola. ");
INSERT INTO kwd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“'Oi kwaimaa fana God amu 'ania manatalamu te'efou, ma 'ania mangomu te'efou, ma 'ania moorilamu te'efou, ma 'ania tegelangaa amu te'efou.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma nga rua me'e tagi ne'e 'ilo'oo, ‘Moko kwaimaa fana ta'a te'efou 'ani 'ilaka'u la'u na 'i'oo kwaimaa famu 'i talamu.’ Te'efuta tagi 'ani riufia la'u nga tagi lo'oo me 'amoe no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma nga wane kwaifa'ananaunga na nga Tagi ala Moses ka fata 'ilo'oo fala Jisas, “Wane ni kwaifa'ananaunga, lamadu'aanga amu ngaia 'e le'a ba'ita. Ngaia 'e kwala'imori, te'e Alafa no'o na God, ma te'efuta God nga matari la'u me 'amoe no'o. ");
INSERT INTO kwd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma goru kwaimaange'enia God 'ania mango adauru te'efou, ma 'ania nga manata dauru te'efou, ma 'ania nga tegelangaa dauru te'efou. Ma goru kwaimaa fana ta'a te'efou 'ilaka'u la'u fadauru taladauru. Wane dau suria rua tagi lo'oori, gila na gila agea 'ola taringa'i ne'e riufia kwatelana nga tabonga fana God.” ");
INSERT INTO kwd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma la Jisas ka aga su'ana nga su'a'olanga aana, ma ka fata 'ilo'oo fana, “'I'oo galangi no'o fana God 'ani ba'ita fafia mangomu.” Ma 'i burina, te'efuta wane 'ame 'uri no'o fana orisilana la Jisas la'u. ");
INSERT INTO kwd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","La Jisas ka kwaifa'ananau 'ubulana nga 'Ifi Abu na God, ma ngaia ka kwaiorisi 'ilo'oo, “Ngaia 'e 'utaa na ta'a kwaifa'ananau na nga Tagi ala Moses, gila iiria nga Kraes na wane na nga fufutanga ala Defete? ");
INSERT INTO kwd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nga Anoe 'ola Abu laka'u ka fa'afataa la Defete 'ilo'oo, ‘La God ngaia 'e fata 'ilo'oo fana Alafa agu: 'Oi to'oru gula le'a agu, mamamania alata nau 'aku aru'o 'ani tegela fafia marimae amu.’ ");
INSERT INTO kwd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“La Defete no'o 'i talana ne'e iiria nga Kraes nga ‘Alafa agu.’ Ngaia 'e 'uta'i na nga Kraes ngaia mola fa'asia fufutanga ala Defete?” Nga ogunga ba'ita lo'oori, gila malale'a ba'ita alata gila fafulongo suria la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma la Jisas ka fa'ananauga 'ilo'oo, “Moru abelo 'ania mooru fa'asia nga kwaifa'ananaunga na Tagi ala Moses, suria gila siria iiki fana ru'ufilana ruu girigiri'a tekwa. Ma gila ka siria la'u ba'itangaa fana nga ta'a 'agila iiriba'ita aga, ma ta'a 'agila fata le'ale'a faga 'i maana uusi'a. ");
INSERT INTO kwd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma gila ka siria 'agila ogu 'i na'o na lefu ba'ita na nana'inga 'ubulana 'ifi ni fo'anga na Jiu, ma nga lefu 'e le'a na alata na fafangalaa. ");
INSERT INTO kwd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sui ma, ta'a lo'oo gila beriberia nga 'ifi ma nga 'ola na ni me'e nao gila to'o ai. Ma gila ka iiria fo'anga ne'e tekwa fana nga ta'a 'ani tafega mola. Lo'oo, ni wane ni kwaifa'ananau suria Tagi ala Moses na kwa'ikwa'inga aaga 'e ria 'e ba'ita!” ");
INSERT INTO kwd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","La Jisas ngaia 'e to'oru 'ubulana nga 'Ifi Abu na God galangia nga kokole 'ola fana arulana bata 'i 'ubulai. Ngaia ka agasia ni wane na gila kwatea bata aaga. Ma nga ta'a 'e aula na gila 'ola'a gila ka kwatea bata 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui, ma ngaia ka agasia te'e me'e nao galafa'a. Ngaia 'e leka mai, ma ka kwatea la'u rua fe'e seleni sisika. ");
INSERT INTO kwd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma la Jisas ka soea mai nga fufu'iwane aana, ma ka fata 'ilo'oo faga, “'Ola kwala'imori nau ku iiria te'amooru, 'olataa na me'e nao lo'oo 'e galafa ne'e kwatea, ngaia 'e ba'ita 'e riufia ta'a te'efou na gila kwatea bata ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tofuna ta'a na gila 'ola'a, gila kwatea mola te'e gule 'ola sisika na 'ola'angaa aaga. Tafe'ua, ma me'e nao galafa'a lo'oo, ngaia 'e kwate te'efou no'o na 'ola ne'e to'o ai fana to'orunga aana.” ");
INSERT INTO kwd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Alata la Jisas 'e 'akwasia nga 'Ifi Abu na God, te'e wane na fufu'iwane aana 'e fata 'ilo'oo fana, “Wane ni kwaifa'ananaunga, agasia madi nga fou ba'ita lo'oo, ma nga 'Ifi Abu le'a lo'oo na God ma ni 'ifi ngaa'i fe'enia!” ");
INSERT INTO kwd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma la Jisas ka lamadu'aa ma ka 'ilo'oo, “Lo'oo, 'i'oo agasia ni 'ifi ba'ita lo'oo na nga 'Ifi Abu na God. Tafe'ua, te'e alata te'e nigi na, gwa'a te'e me'e fou na 'Ifi Abu lo'oo na God ma 'e sia nana'i la'u 'i tala furina, gila te'efou tagila tagala 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma alata la Jisas ngaia 'e to'oru gouna nga busu 'i Olif na 'e to'oru otofana nga 'Ifi Abu na God, la Pita, ma la Jemes, ma la Jon, ma la Andru te'i gila, gila leka mai te'ana, ma gila ka kwaiorisi 'ilo'oo ana, ");
INSERT INTO kwd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“'Oi kwairii madi fameeru, nanitaa na ni 'ola lo'oo te'e nigi mai? Ma nga taa na te'e lau, 'ani faate'enia alata fana 'ola lo'oo te'efou te'e lau, ma ka nigi mai?” ");
INSERT INTO kwd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma la Jisas ka fata 'ilo'oo faga, “Ta'a mooru agaaga le'a, ma moru sia alamia mola te'efuta wane 'ani kuta 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Suria nga ta'a 'e aula tagila nigi mai 'ania latagu, ma tagila fata 'ilo'oo, ‘Nau no'o na Kraes!’ Ma tagila talai kuta na ta'a 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma alata moru longoa fununga, ma nga alafuunga suria nga fununga, moru sia manata gelo mola 'i suria. 'Ola lo'oo te'e nigi mai, tafe'ua ma nga 'isilana 'ola te'efou 'amoe 'ua. ");
INSERT INTO kwd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nga ta'a tagila funuria ta'a ngaa'i, ma ni fanua ba'ita tagila funuriga kwairiu. Ma nga nununu te'e to'o na fanua te'efou, ma nga molo'u nga te'e riu. Ma ni 'ola lo'oori gila no'o na etalana nonifiinga, ta'ua nga alata nga noni 'ani fa'afuta laka'u 'e eta 'ani wela fii. ");
INSERT INTO kwd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mai 'amooru moru agaaga le'a. Ni ta'a te'e fata ngada 'amooru, ma tagila ngaria amooru fana nga sufa lamooru. Tagila kwa'i amooru 'i 'ubulana nga 'ifi ni ogunga na Jiu. Suria moru fito'o agu, tagila fa'aula 'amooru 'ina'ona nga ta'a na'ona'o ma nga ta'a ba'ita. Alata no'ona tamooru kwairii 'ani nau. ");
INSERT INTO kwd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma tamooru alafuu suria nga Kwairiinga Le'a lo'oo fana ta'a te'efou fofona fanua lo'oo 'i wado madi ma nga fanua lo'oo 'i wado bi'i sui. ");
INSERT INTO kwd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma alata na gila gemasi 'amooru, ma gila ka ngaria mooru fana nga sufa lamooru, moru sia nonifii mola fana nga alafuunga 'utaa na tamoru iiria. Ta'a moru iiria mola nga alafuunga na Anoe 'ola Abu 'e kwatea famooru na alata no'ona. Suria alafuunga na moru iiria, ngaia 'e 'amoe la'u nga fata lamooru te'i 'amooru. Nga alafuunga lo'oori, ngaia 'e leka mai fa'asia nga Anoe 'ola Abu. ");
INSERT INTO kwd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma nga ta'a, tagila 'olonge'enia nga wane ni futanga aaga talaga fana kwa'ilaga. Ma nga mama'a tagila agea 'ilo'oo la'u na wela aaga. Ma nga wela, tagila orisu'usu'u ma tagila 'olonge'enia la ma'aaga ma ni ga'iga fana kwa'ilaga. ");
INSERT INTO kwd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma nga ta'a te'efou, tagila gulete'enia amooru, tofuna 'i 'amooru nga wane agu. Ma ni dai ne'e tagoto'o kwala'imori agu maka nigi na fe'e gani 'i'isi, ngaia te'e moori.” ");
INSERT INTO kwd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Nga alafuunga fana nga wane ne'e idumia ngaia 'e 'ilo'oo: 'I'oo le'a mola na nga fadalana 'ola lo'oo.) “Mai mooru tamooru agasia nga 'Ola 'e Ria na nga profet Daniel 'e giri suria te'e tata'e mai na lefu 'e abu na ngaia 'ame to'omia 'ani ula ai. Nga 'Ola 'e Ria lo'oori te'e fa'agenia nga 'Ifi Abu na God. Alata mooru agasia nga 'ola lo'oo 'ani nigi mai, nga ta'a na gila to'oru na gule'e lefu 'i Judea, tagila 'akwa fana gouna nga busu. ");
INSERT INTO kwd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma lauta ta wane na 'i'oo to'oru 'i gouna 'ifi, 'akwa no'o, 'i'oo sia sifo la'u mai fana 'ubulana nga 'ifi amu fana ngarilana te'efuta 'ola. ");
INSERT INTO kwd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma nga wane na 'i'oo to'oru 'i 'ubulana nga langa'a amu, 'akwa no'o, 'i'oo sia ori la'u 'i fanua fana nga ruu amu. ");
INSERT INTO kwd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma fe'e gani lo'oori, te'e ria fana ni noni gila guru'a, tofuna ngaia 'e 'ato no'o faga 'agila 'akwa, ma ka ria la'u fana nga noni na gila to'o na nga wela sisika. ");
INSERT INTO kwd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ta'a moru fo'a fana God fana ni 'ola lo'oori gila sia nigi mola mai na alata na gwaringa. ");
INSERT INTO kwd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tofuna nga nonifiinga na fe'e gani lo'oori, te'e ria riufia nga nonifiinga na wane fofona fanua lo'oo 'i wado gila su'aai, eta 'ua mai na etalana alata God 'e launge'enia nga fanua lo'oo 'i wado ma ka nigi na alata lo'oo. Ma ngaia 'e 'amoe no'o ta 'ola 'ilo'oo na te'e la'u mai 'i buri. ");
INSERT INTO kwd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma lauta God 'ame folo ko'uko'uta na alata na nonifiinga lo'oo, ngaia 'e 'ato no'o fana nga wane 'ani moori. Ma ngaia 'e folo ko'uta na alata lo'oori fana le'anga na ni ta'a ne'e firiga. ");
INSERT INTO kwd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Lo'oo, lauta ta wane 'e fata 'ilo'oo famooru, ‘Agasia madi, ngaia no'o na Kraes,’ ma ka fata 'ilo'oo, ‘Agasia madi, ngaia no'o 'i loko'u,’ moru sia fito'oa mola ana. ");
INSERT INTO kwd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Suria nga ta'a ni kotanga te'e nigi mai, tagila fata 'ilo'oo, ‘Nau nga Kraes,’ ma nga ta'a ni kotonga tagila fata 'ilo'oo, ‘Nau nga profet.’ Ma tagila agea 'ola faringa'a 'ani talai kuta na nga ta'a na God ngaia 'e firiga, tafe'ua ma ngaia 'e 'ato iiki faga. ");
INSERT INTO kwd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ta'a mooru agaaga le'a! Nau ku kwairii te'amooru no'o 'i na'o, sui ma 'ola lo'oo te'e bi'i nigi mai.” ");
INSERT INTO kwd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma alata na nonifiinga lo'oori 'ani sui, ‘Nga sisina te'e logo, ma nga singari, sia lala la'u. ");
INSERT INTO kwd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma God te'e agea nga buruburu, tagila 'esiga fa'asia 'ubulana lalo. Ma God te'e agea ni 'ola 'i langi, tagila leka kuta fa'asia talafuriga.’ ");
INSERT INTO kwd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sui ma 'inau, nga Wela na Wane, nau taku bi'i ori mai. Nau taku ori mai fe'enia nga tegelangaa ba'ita, mai 'ubulana nga lalo. ");
INSERT INTO kwd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma 'inau taku kwatea nga enselo agu fofona fanua lo'oo 'i wado te'efou, 'agila gonia mai nga ta'a na God 'e firiga.” ");
INSERT INTO kwd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ma, la Jisas ka fata suria tarifulaa 'ilo'oo, “Ta'a moru manata madi suria nga 'ai nga figi. Alata moru agasia nga lalana 'e ula no'o, mooru moru su'aai nga alata fana nga 'ago'agonga 'e gagalangi no'o. ");
INSERT INTO kwd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Maka 'ilo'oo la'u mola, alata moru agasia nga nonifiinga lo'oori te'e nigi mai, mooru moru su'a ai nga ori lagu mai ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Ola kwala'imori na 'inau ku iiria famooru, tani ta'a na gila moori na alata lo'oo, gila sia mae mola 'i na'ona 'ola lo'oori te'e nigi mai. ");
INSERT INTO kwd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","To'oto'oni 'ola 'ubulana lalo ma nga fanua lo'oo 'i wado te'e sui, tafe'ua ma fatalagu te'e nana'i firi.” ");
INSERT INTO kwd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ta wane 'esia su'a mola na alata kwala'imori na 'inau 'aku ori mai ai. Gwa'a nga enselo 'i langi ma gila 'ame su'aai, ma gwa'a 'inau nga Wela na Wane, mai nau ku 'ame su'a la'u mola ai. God nga Mama'a, te'i ngaia no'o ne'e su'a no'o ai. ");
INSERT INTO kwd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ta'a mooru agaaga le'a, ma moru ka mamania, suria moru bobolosia nanitaa nau taku nigi mai ai. ");
INSERT INTO kwd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nga orilagu mai 'e 'ilaka'u te'e wane ne'e leka na fanua lalau, ma ka arua nga to'olanga ana 'i nimana ta'a ni taunga'i aana. Ngaia ka kwatea taunga'inga kwaitatari faga. Ma ngaia ka iiria fana ni wane ni folonga 'agila aga aga le'a mamania nigilana. ");
INSERT INTO kwd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ngaia na, moru agaaga le'a, suria mooru 'ame su'ana alata na te'e nigi mai, 'ilaka'u wane na nga 'ifi. Ngaia te'e nigi mai laulafi ta'ua, 'amoe 'ubulana dalototo'o ana nga logo, 'amoe ma tagetage'e gani, 'amoe 'usugani alata sina bi'i fane mai. ");
INSERT INTO kwd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma lauta ngaia te'e nigi 'afe'aferu mola, ngaia 'ame le'a fana 'ani nigi te'amooru na alata moru eeno. ");
INSERT INTO kwd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma te'e 'ola na nau ku iiria famooru, na nga 'ola laka'u nau ku iiria la'u mola fana nga ta'a te'efou ne'e 'ilo'oo: Ta'a moru agaaga le'a!” ");
INSERT INTO kwd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rua fe'e gani 'i na'ona nga Fafangalaa na Tala Riunga 'e nigi, ma nga Fafangalaa na 'anilana nga beret na iist 'amoe 'i 'ubulai. Ni fataabu ba'ita, ma nga ta'a kwaifa'ananaunga na Tagi ala Moses, gila ka ogu 'agila launga'i fana nagwafilana ma kwa'ilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gila fata 'ilo'oo, “Goru sia agea mola na alata fafangalaa, fa'asia laloana nga ta'a gila ta bi'i ngada 'ola.” ");
INSERT INTO kwd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na alata la Jisas ngaia 'e to'oru 'i 'ubulana maa'e fanua 'i Betani, ngaia ka keto 'i 'ubulana 'ifi ala Saemon, nga wane nga kuu 'e lau ana 'i na'o. Ma te'e noni ngai ka leka mai te'ana fe'enia nga fe'e waiwai na sugalana 'e ba'ita iiki, ma ngaia 'e fongu 'ania nga waiwai lo'oo si'inilana 'e le'a, nga kokole'e 'ola na waiwai lo'oo forilai 'e ba'ita na gila fa'alata 'ania alabasta. Ma nga forilana 'e ba'ita iiki. Ngaia 'e 'oia nga maana fe'e waiwai lo'oori, ma ka 'irisia no'o waiwai lo'oori si'inilana 'e le'a 'i gouna la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma tani wane na gila to'oru 'i no'ona, gila ka ogaria, ma gila ka fata 'ilo'oo faga kwairiu, “To'omia 'i ngaia 'e sia ngadaa mola nga waiwai lo'oo 'e si'ini 'e le'a! ");
INSERT INTO kwd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","To'omia ngaia 'ani fa'afori 'ania fana bata 'e aula, to'omia foforinga na te'e wane fana farisi, fana 'ani ngaria bata lo'oori, ma ka kwatea fana nga ta'a galafa.” Ma gila ka fata tegela fana noni lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","La Jisas ngaia 'e longoa, ma ka fata 'ilo'oo, “Moru rugasia kau moru sia fata ngadaa la'u. Ngaia 'e agea taunga'inga le'a ba'ita fagu. ");
INSERT INTO kwd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nga ta'a no'ona gila galafa'a gila to'oru furifuri mola fe'eni amooru. Ma lauta moru siria, ma tamoru booniga kau na ta alata ngaa'i. Tafe'ua, mai nau ku 'ame to'oru aburu fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngaia 'e agea 'ola ne'e to'omia fana agelai. Ngaia 'e 'irisia nga waiwai 'e si'ini 'e le'a lo'oo 'i nonigu 'i na'o na maenga agu, fana 'ani sasari nau fana kwaiatolagu. ");
INSERT INTO kwd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Ola kwala'imori nau ku iiria famooru, nga lefu te'efou fofona fanua lo'oo 'i wado na tagila alafuu suria nga Kwairiinga Le'a lo'oo, tagila alafuu la'u mola suria 'ola ne'e agea fana manatanga to'ona.” ");
INSERT INTO kwd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui ma la Judas Iskariot, te'e wane na nga akwale'e wane ma ruaai na fufu'iwane ala Jisas, ngaia 'e leka te'ana ni fataabu ba'ita, ma ka kwairii faga 'ilo'oo, “Nau taku kwatea la Jisas famooru.” ");
INSERT INTO kwd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma gila ka malale'a ba'ita suria 'ola ne'e iiria, ma gila ka fataarunga'i fana kwatelana bata fana. Ma la Judas ka etaa no'o fana aganga fana me'e alata le'a fana 'olonge'enilana la Jisas faga. ");
INSERT INTO kwd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na gani eteeta na Fafangalaa na 'anilana beret na iist 'amoe ai, fe'e gani lo'oori na 'agila kwa'ia te'e sifisifi fana nga Fafangalaa na Tala Riunga. Alata lo'oori, fufu'iwane ala Jisas tagila orisia 'ilo'oo, “'I fai na 'i'oo siria ameeru leka ma meru ka sasaria na nga Fafangalaa na Tala Riunga famu?” ");
INSERT INTO kwd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma la Jisas ka fata fana nga rua wane laloaga 'ilo'oo, “Molo ru'u 'ubulana 'i Jerusalem, ma te'e wane ne'e ngaria nga fe'e ka'o, ngaia te'e daria moo'o. Ma molo leka 'i burina ");
INSERT INTO kwd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","fana 'ifi lo'oori ne'e ru'u 'i 'ubulai. Molo orisia nga wane ne'e to'o na nga 'ifi no'ona 'ilo'oo, ‘Nga wane ni kwaifa'ananaunga 'e iiria, nga tofi 'ifi fai na ngaia te'e 'ania nga Fafangalaa na Tala Riunga fe'enia nga fufu'iwane aana ai?’ ");
INSERT INTO kwd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma ngaia te'e faate'enia tofi 'ifi 'i langi 'e ba'ita ne'e to'oru ai. 'I no'ona ni 'ola fana to'orunga ai ma fangalaa ngai fofona gila sasaria no'o. Ma molo ka sasaria nga ketonga fadauru te'efou no'ona.” ");
INSERT INTO kwd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sui ma, nga rua wane laka'u gala leka, ma gala ka ru'u no'o 'i Jerusalem, ma gala ka agasia nga 'ola te'efou 'e 'ilaka'u na la Jisas 'e iiria fagaa'a. Ma gala ka sasaria 'ola te'efou fana Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma ngaia 'e laulafi no'o, la Jisas 'e nigi no'o mai fe'enia nga akwale'e wane ma ruaai laka'u ana. ");
INSERT INTO kwd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma alata gila keto, la Jisas ka fata 'ilo'oo, “Nga 'ola kwala'imori nau ku iiria famooru, te'e wane amooru te'e 'olonge'eni nau fana nga marimae agu. Te'e wane amooru ne'e keto fe'eninau na alata lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma nga fufu'iwane aana, gila ka etaa gila kwaimanadai no'o, ma gila ka fata tala te'e wane, ma gila ka 'ilo'oo, “Nau ku sia kwate'o mola fana marimae amu welakau!” ");
INSERT INTO kwd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma la Jisas ka lamadu'aga 'ilo'oo, “Te'e wane amooru nga akwala ma ruaai lo'o agu, nga wane ne'e arua me'e beret 'i 'ubulana nga daoko fe'eni nau. ");
INSERT INTO kwd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mai nau, nga Wela na Wane, taku mae 'ilaka'u nga Girigiringa Abu laka'u 'e fata suri nau. Tafe'ua, kwaimanadainga ba'ita fana wane na te'e tagoni 'olonge'eni lagu fana nga marimae agu! Ngaia le'a fana wane 'ilo'oo lauta ngaia 'ame futa mola.” ");
INSERT INTO kwd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma alata gila keto no'o, la Jisas 'e ngaria nga me'e beret, ma ka baatafea God, sui ma ka mandanga maka kwatea fana nga fufu'iwane aana, ma ka fata 'ilo'oo, “Ngaria ma moru 'ania. Ngaia no'o na nonigu ne'e mandanga famooru.” ");
INSERT INTO kwd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui ma ngaia ka ngaria nga teteu na waen, ma ka baatafea God, sui ma ka kwatea faga. Ma gila te'efou gila ka go'ufia no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma ngaia ka fata 'ilo'oo, “Ngaia no'o na 'abugu ne'e afe fana ta'a 'e aula fana fa'ategelalana nga fataarunga'inga fooru ala God. ");
INSERT INTO kwd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Ola kwala'imori nau ku iiria famooru, nau ku sia go'ufia mola nga waeni lo'oo la'u leleka maka nigi na fe'e gani 'inau taku go'ufia la'u nga waeni fooru, alata God te'e ba'ita fafia ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Burina gila ka nguria fe'e nguu, sui ma gila ka leka no'o fana nga busu 'i Olif. ");
INSERT INTO kwd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","La Jisas ka fata 'ilo'oo faga, “Mooru te'efou na tamooru 'akwa fa'asi nau. Suria nga Girigiringa Abu 'e fata 'ilo'oo, ‘La God te'e kwa'ia wane na 'e aga suria nga sifisifi, ma nga sifisifi te'efou tagila tagala'i.’ ");
INSERT INTO kwd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ma gwa'a 'ani 'ino'ona, 'i burina nau taku tata'e la'u fana mooringa, nau taku leka no'o 'i na'o mooru fani Galili.” ");
INSERT INTO kwd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma la Pita ka fata 'ilo'oo, “Ngaia 'e 'ato no'o fana 'aku 'akwa fa'asi'o, tafe'ua ni wane ngaa'i gila ka 'akwa fa'asi'o!” ");
INSERT INTO kwd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma la Jisas ka fata 'ilo'oo fala Pita, “Nau ku iiria famu. Na'ona nga susuki te'e aani rua alata 'ubulana logo lo'oo tala'ina, 'i'oo to'o tofe nau moko iiria 'i'oo bobolosi nau.” ");
INSERT INTO kwd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma la Pita ka lamadu'aa tegela aana 'ilo'oo, tafe'ua nau taku mae fe'eni'o, 'e 'ato no'o nau 'aku iiria nau ku bobolosi'o.” Ma nga fufu'iwane aana te'efou lo'oo, gila iiria la'u mola te'e 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sui mala Jisas fe'enia nga fufu'iwane aana, gila ka leka fana te'e lefu gila fa'alataa 'ania 'i Getsemani. Alata gila nigi no'ona, la Jisas ka fata 'ilo'oo faga, “Ta'a mooru to'oru 'i lo'oo alata nau ku fo'a 'i talagu.” ");
INSERT INTO kwd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui ngaia ka talaia la Pita, ma la Jemes, ma la Jon fe'enia. Ma ngaia ka kwaimanadai maka manata gelo ba'ita ma ka aotala no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mai ngaia ka fata 'ilo'oo faga, “Nga mangogu 'e fiitala 'e ba'ita no'o, ma ngaia 'e to'omia no'o kwa'ilagu. Moru to'oru 'i lo'oo, ma moru ka agaaga fe'eninau.” ");
INSERT INTO kwd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma ngaia ka 'idu sisika kau, ma ka bobouruuru 'i wado. Ma ngaia ka fo'a 'ilo'oo lauta ngaia 'e wada'u mola, kwatea nau ku sia ru'u mola 'ubulana nonifiinga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma ngaia ka fo'a 'ilo'oo, “Mama'a, ni 'ola te'efou ngaia 'e talawada'u mola famu. 'Oi lafua kau nga nonifiinga lo'oo fa'asi nau. Ma tafe'ua, nga kwaisiriinga agu 'amoe lo'oo, tafe'ua ma suria kwaisiriinga amu no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui mala Jisas ka ori la'u, mai maka daria nga oru wane laka'u aana, gila eeno mola. Ma ngaia ka fata 'ilo'oo fala Pita, “Saemon, 'utaa na 'i'oo eeno mola? To'omia 'i'oo 'ani aga fe'eninau suria gwa'a te'e tofi'i logo sisika.” ");
INSERT INTO kwd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma ngaia ka alafuu 'ilo'oo faga, “Ta'a mooru agaaga 'ania fo'anga fa'asia nga irito'onga eta riufia mooru. Suria manata lamooru 'e siria agelana 'ola 'e le'a, tafe'ua ma noni mooru 'e waata'uta'u 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma la Jisas ka leka la'u fa'asiga, ma ka fo'a, ma ka iiria la'u mola te'e alafuunga laka'u. ");
INSERT INTO kwd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui ma ngaia ka ori la'u mai te'aga, ma ka nigi to'oga gila eeno mola, suria nga maaga 'e oloolo moo no'o. Ma gila 'ame su'a no'o na nga te'efuta 'ola na 'agila iiria fana. ");
INSERT INTO kwd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma alata 'e ori la'u mai na oruna alata, ngaia ka fata 'ilo'oo faga, “Mooru moru eneeno 'ua? 'E le'a no'o! Moru aga no'o, tagila kwate nau no'o, nga Wela na Wane, 'ubulana nimana nga ta'a 'e ria. Nga alata laka'u lo'oo 'e nigi no'o! ");
INSERT INTO kwd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tata'e, goru leka no'o. Moru aga nga wane laka'u ngaia 'e 'olonge'eni nau fana nga marimae agu, ngaia 'e nigi no'o mai!” ");
INSERT INTO kwd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na alata la Jisas ngaia 'e alafuu mola 'ua, la Judas, nga wane na nga akwala ma ruaai laka'u aana, 'e nigi no'o mai. Te'e oguogunga ba'ita gila leka mai, ma gila ka ngaria mai nga naifi ma sua ma nga 'ola ni fununga. Ni fataabu ba'ita, ma nga ta'a na'ona'o na ta'a 'i Jiu, ma nga ta'a kwaifa'ananaunga na Tagi ala Moses gila alea nga oguogunga fana lekanga te'ala Jisas. Ma gila ka ngaria mai nga naifi ma sua ma nga 'ola ni fununga. ");
INSERT INTO kwd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma la Judas, nga wane ne'e 'ani kwatea la Jisas faga, ngaia ka kwatea nga faata'inga fana oguogunga no'o na 'ilo'oo, “Nga wane na 'inau taku nono fe'enia, ngaia na wane na moru siria. Ta'a mooru gemasia, ma moru ka talaia kau.” ");
INSERT INTO kwd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sui ma la Judas 'e nigi, ma ngaia ka leka no'o kau te'ala Jisas, ma ka fata 'ilo'oo, “Wane kwaifa'ananaunga!” Ma ngaia ka nono'ia no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma gila ka gemasia no'o la Jisas, ma gila ka gaua no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma alata lo'oori, te'e wane ne'e tata'e galangi mai, 'e lafua nga naifi aana, ma ka tofu mousia nga aringana nga wane ni taunga'i fana alafa ni suuabunga. ");
INSERT INTO kwd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma la Jisas ka orisi 'ilo'oo aaga, “'Ino'ona ma amooru moru madafia nau nga wane beriberi lo'oo? Ngaia lo'oo moru nigi mai fe'enia nga naifi ma nga 'ola ni fununga fana daulagu? ");
INSERT INTO kwd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aburu no'o mai, nau ku kwaifa'ananau amooru 'i 'ubulana nga 'Ifi Abu na God, tafe'ua ma moru 'ame gemasi nau mola. Ma nga 'ola lo'oo moru agea, ngaia 'e fa'ato'oa nga Girigiringa Abu.” ");
INSERT INTO kwd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sui ma nga fufu'iwane aana te'efou gila ka 'akwasia, ma gila ka 'akwa no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma te'e wane bi'i ba'ita mai ne'e 'afesia mola me'e ruu, 'e leka mai burina la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Na alata gila gemasia nga wane bi'i ba'ita lo'oo ngaia ka rugasia ruu lo'oo ana maka 'akwa daadala no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sui ma gila ka talaia la Jisas fana 'ifi na alafa ni suuabunga. Ma ni fataabu ba'ita, ma ni ta'a na'ona'o 'i Jiu, ma nga ta'a ni kwaifa'ananaunga na Tagi ala Moses, gila ogu 'i lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma la Pita ngaia 'e ole no'o kau 'i burina, ma ka ru'u la'u 'ubulana nga lala bata na 'ifi na alafa ni suuabunga. Ngaia ka to'oru 'i no'ona fe'enia nga ta'a ni folonga, ma ngaia ka lalangia 'i gegena nga eele. ");
INSERT INTO kwd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma, ni fataabu ba'ita, ma ni wane ni fadafadanga, gila ka agea fana 'agila dari te'efuta 'ola 'e ria fana felete'enilai ala Jisas 'agila kwa'ia, tafe'ua ma gila 'ame daria mola ta 'ola aana. ");
INSERT INTO kwd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma nga ta'a 'e aula, gila ka koto fe'enia 'ola fana la Jisas, tafe'ua ma alafuunga aaga 'ame nana'i na te'e lefu. ");
INSERT INTO kwd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma tani wane ngaa'i gila tata'e la'u mai, ma gila ka koto fala Jisas ma gila 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Meeru meru longoa ngaia 'e fata 'ilo'oo, ‘Nau taku osia nga 'Ifi Abu na God na ta'a gila launge'enia, ma 'i 'ubulana oru ma'e gani, nau taku launge'enia la'u nga 'Ifi Abu lo'oo ne'e 'ato fana wane 'ani launge'enia.’” ");
INSERT INTO kwd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma nga alafuunga aaga 'ame nana'i na te'e lefu. ");
INSERT INTO kwd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma nga alafa ni suuabunga ngaia 'e ula 'i na'oga, ma ngaia ka orisia la Jisas 'ilo'oo, “'Ino'ona ma, 'i'oo 'ame to'o mola na ta alafuunga fana orisilai tofuna alafuunga na ta'a lo'oo gila faia fafi'o?” ");
INSERT INTO kwd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tafe'ua, la Jisas 'e nana'i aloalo mola, ngaia 'ame lamadu'aa ni kotonga gila iiria fafia. Ma nga alafa ni suuabunga ngaia 'e orisia 'ilo'oo la'u, “'Ino'ona ma, 'I'oo na Kraes laka'u, nga Wela na God?” ");
INSERT INTO kwd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma la Jisas ka lamadu'aa 'ilo'oo, “'I nau na 'i ngaia. Ma tamoru agasia nau, nga Wela na Wane, 'aku to'oru 'i gule'e nimana le'a na God. Nau taku ba'ita fafia ni 'ola te'efou, ma taku ori mai fa'asia 'i langi fofona nga kofa.” ");
INSERT INTO kwd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma nga alafa ni suuabunga no'o na ngaia ka gaasia nga ruu tekwa aana 'i talana ma ka faate'enia nga ogarianga aana, ma ka fata 'ilo'oo, “Goru 'ame siria la'u ta wane ngai 'ani alafuu la'u suria! ");
INSERT INTO kwd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Moru longoa no'o ngaia 'e fa'atooto'ome'enia fe'enia God! Moru manata 'utaa ana?” Ma gila te'efou no'o, gila ka iiria ngaia 'e kuta no'o, ma ngaia 'e to'omia 'agila kwa'ia no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma tani wane laloaga gila ka etaa fana ngisufilana la Jisas, ma gila ka gau 'usia maana, ma gila ka gumuria. Ma gila ka fata 'ilo'oo, “Su'a ana ni dai ne'e gumuri'o!” Ma nga ta'a ni folonga gila ka talaia, ma gila ka gule kwairiu ana. ");
INSERT INTO kwd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","La Pita ngaia 'e to'oru 'ua 'i 'ubulana lala bata na 'ifi na alafa ni suuabunga, alata gila malate'ote'o ala Jisas. Te'e wela geni laari'i ne'e taunga'i fana alafa ni suuabunga ngaia 'e nigi mai. ");
INSERT INTO kwd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma alata ngaia 'e agasia la Pita ne'e lalangia 'i talana, ngaia ka aga tegela kau fana, ma ka fata 'ilo'oo, “'I'oo to'oru la'u mola fe'enia la Jisas, nga wane laka'u fa'asia nga maa'e fanua 'i Nasaret.” ");
INSERT INTO kwd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma la Pita ngaia ka tofea 'ilo'oo, “Nau ku bobolosia, nau ku 'ame su'ana 'ola na 'i'oo fata suria.” Ma ngaia ka ru'u kau maana sinama na lala bata. Ma alata no'ona, nga susuki ka ani no'o. ");
INSERT INTO kwd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma nga wela geni laari'i ni taunga'i laka'u ngaia 'e agasia la'u 'i no'ona, ma ka fata 'ilo'oo fana ta'a na gila ula 'afuia 'i no'ona, “Ngaia te'e wane aaga la'u mola lo'oo!” ");
INSERT INTO kwd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma la Pita ka gwalaa la'u mola. Ma alata sisika 'i burina, nga ta'a na gila ula galangi, gila ka fata 'ilo'oo la'u fala Pita, “Ngaia 'e 'ato no'o 'i'oo gwalaa iiria 'i'oo wane aga, ma 'i'oo la'u mola 'i'oo leka mai fa'asia nga gule'e lefu 'i Galili.” ");
INSERT INTO kwd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui ma la Pita ka fata tegela'a 'ilo'oo, “Alamia God te'e kwatea nga kwa'ikwa'inga fagu, lauta nau ku 'ame fata kwala'imori! Nau ku 'ame su'aai na wane na moru fata suria!” ");
INSERT INTO kwd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma te'e alata no'ona mola, nga susuki ruana fe'e aaninga ka aani no'o. Ma la Pita ka manata to'ona nga alafuunga laka'u la Jisas 'e iiria laka'u 'e 'ilo'oo, “'I na'ona nga susuki 'ani aani rua na alata, 'i'oo to'o gwala nau oru alata na, 'i'oo bobolosi nau.” Ma alata la Pita ngaia 'e manata to'o na 'ola lo'oori, ngaia ka aani ba'iba'ita no'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na 'usugani logologo'a mola, ni wane ni fadafadanga te'efou gila ogu 'afe'aferu la'u. Ma nga fataabu ba'ita, ma nga ta'a na'ona'o, ma nga ta'a kwaifa'ananaunga na Tagi ala Moses, gila lado. Gila ogu 'agila fadaa fana 'olataa na 'agila agea ala Jisas. Ma gila ka gaua la Jisas 'ania kwalo, ma gila ka talaia kau fana kwatelana fala Paelat, nga wane ba'ita fa'asia 'i Rom. ");
INSERT INTO kwd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma la Paelat ka orisia 'ilo'oo, “'Ino'ona ma 'i'oo na alafa na ta'a 'i Jiu?” Ma la Jisas ka lamadu'aa 'ilo'oo, “Ngaia no'ona 'i'oo iiria no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ni fataabu ba'ita gila ka fai fafia no'o na ni 'ola 'e kuta 'e aula. ");
INSERT INTO kwd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma la Paelat ka orisia la'u 'ilo'oo, “Mai'o longoa na nga 'ola ne'e aula na gila faia fafi'o lo'oo! 'Ino'ona ma 'osia orisiga mola?” ");
INSERT INTO kwd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tafe'ua, ma la Jisas 'ame iiria mola ta alafuunga, ma la Paelat ka 'alefo no'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lo'oo, na nga Fafangalaa na Tala Riunga, la Paelat ngaia 'e fini rubea nga wane fa'asia nga lokafu na ta'a gila kwaisoe fai. ");
INSERT INTO kwd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma nga alata lo'oori, te'e wane na latana la Barabas ngaia 'e to'oru la'u 'i 'ubulana lokafu, tofuna ngaia nga wane 'e ria na gila kwa'ia ta'a na fununga fe'enia ta'a 'i Rom. ");
INSERT INTO kwd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sui ma ta'a na gila ogu mai, gila ka siria la Paelat fana 'ani rubea nga wane fa'asia nga lokafu suria falafala ne'e fini agea mai na alata 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma ngaia ka orisiga ma ka 'ilo'oo, “'Ino'ona mai 'amooru moru siria 'inau 'aku rubea nga alafa 'i Jiu famooru?” ");
INSERT INTO kwd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Suria la Paelat 'e su'a no'o na fataabu ba'ita gila kwatea mai la Jisas te'ana, tofuna manate'e wane ni kwaifiingaa ngai aga suria ta'a 'e aula gila leka 'i burina la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tafe'ua, ma nga fataabu ba'ita gila alafuu 'i manatalana nga ogunga no'ona, fana 'agila soea la Paelat fana 'ani rubea mai la Barabas faga. ");
INSERT INTO kwd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma la Paelat ka fata la'u 'ilo'oo na nga ogunga no'o na, “'Ino'ona ma nga 'olataa na nau taku agea na nga wane na moru fa'alata alafa amooru 'i Jiu?” ");
INSERT INTO kwd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma gila ka o'omae ma gila 'ilo'oo, “Kwa'ia 'ani mae!” ");
INSERT INTO kwd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma la Paelat ngaia 'e kwaiorisi 'ilo'oo, “'Olataa 'e ria na ngaia 'e agea?” Ma gila ka o'omae ba'ita la'u, ma gila 'ilo'oo, “Kwa'ia 'ani mae!” ");
INSERT INTO kwd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma la Paelat ka rubea kau la Barabas faga, suria ngaia 'e siria 'ani fa'amalale'aa nga manatalana nga ta'a lo'oori. Sui, mai ngaia ka kwatea no'o la Jisas fana nga labusilana, ma ka kwatea no'o fana mudu'ilana 'i bata'ana nga 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ni wane na fununga, gila ka talaia no'o kau la Jisas 'i 'ubulana nga lala bata na 'ifi ba'ita ala Paelat, ma gila ka lalofia mai nga ta'a na fununga te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gila ka fa'aruufia 'ania nga ruu meku tekwatekwa, ma gila ka eelea 'ania nga 'elegou na 'alagau ngangala'a, ma gila ka eelea 'ania gouna 'ilaka'u nga kiingi. ");
INSERT INTO kwd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui ma gila ka doo ana, ma gila ka fata 'ilo'oo, “Nga alafa 'i Jiu, 'i'oo to'o moori 'e aburu!” ");
INSERT INTO kwd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui ma gila ka kwa'ia gouna 'ania fe'e 'ai, ma gila ka ngisufia, ma gila ka bobouruuru 'i na'ona, 'ilaka'u na gila fa'aba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma alata na gila fa'atelea 'e sui mola, gila ka lafua nga ruu tekwa laka'u fa'asia. Sui ma gila ka fa'aruufia la'u 'ania ruu aana 'i talana. Sui ma gila ka talaia no'o fana nga mudu'ilana na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma nga alata gila leka kau suria nga tala, ma gila daria te'e wane latana la Saemon, ma'a ala Aleksanda, fe'enia la Rufus. Ngaia nga wane fa'asia nga fanua 'i Saerin. Ngaia 'e leka mai ma ka ru'u 'ubulana fanua 'i Jerusalem fa'asia langa'a. Ma nga ta'a na fununga, gila ka su'unge'enia aana 'ani ngaria nga 'ai folo ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma gila ka talaia kau la Jisas fana nga lefu na gila fa'alata 'i Golgota. Na alafuunga na Aramaik fa'aladamia 'ania, “Nga lefu fana gouna wane 'e mae.” ");
INSERT INTO kwd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma gila ka kwatea nga waeni na gila dolaa fe'enia 'ola na gila fa'alata “Mira,” nga kwaikwai na 'ola fana fa'aloalolana wane 'e fii, tafe'ua ma la Jisas 'ame go'ufia mola. ");
INSERT INTO kwd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma gila ka mudu'ia na 'ai folo. Ma gila ka dalo'ia nga ruu aana 'i laloaga kwairiu. Gila ka masa fai 'ilaka'u nga masanga na daisi 'agila daria ni dai aaga na 'ani ngaria nga ruu lo'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na nga mulena mae'ola 'usugani, gila foto fafia na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma gila ka arua 'i gouna 'ai folo no'ona me'e girigiringa na kwai gulenga. Gila giria 'ilo'oo, “Nga wane Alafa 'i Jiu.” ");
INSERT INTO kwd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma gila ka foto fafia la'u rua wane beriberi 'i bata'ana nga rua 'ai folo fe'enia la Jisas. Nga wane ngaa'i gula le'a aana, ma nga wane ngaa'i gula moori aana. ");
INSERT INTO kwd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma nga ta'a gila riu, ma gila ka 'asu kwairiu 'i gouga, ma gila ka fata sifo ala Jisas, ma gila ka alafuu 'ilo'oo, “'I'oo iiria to'o 'osia nga 'Ifi Abu ala God, ma to'o launge'enia mola 'ubulana oru maa'e gani. ");
INSERT INTO kwd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'Oi fa'amoori'o talamu! Sifo mai fa'asia nga 'ai folo no'ona!” ");
INSERT INTO kwd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma nga fataabu ba'ita, ma nga ta'a kwaifa'ananaunga na tagi ala Moses, gila ka fata la'u mola 'ilo'oo. Ma gila ka alafuu ni doonga ala Jisas, ma gila ka alafuu 'ilo'oo faga kwairiu, “Ngaia 'e fa'amooria ta'a matari, ma ngaia 'ame fa'amooria mola 'i ngaia 'i talana! ");
INSERT INTO kwd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Lo'oo goru aga fana lauta ngaia nga Kraes, nga alafa 'i Jiu. Ngaia te'e sifo mola mai fa'asia nga 'ai folo lo'oo, fana 'agoru fito'o ana!” Ma nga rua wane na gila mudu'i 'agaa'a na 'ai folo fe'enia la Jisas, gaa'a gala fata sifo la'u mola ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Ita na dalototo'o na gani, nga gule'e lefu lo'oo 'e logosusu no'o, leleka ma ka nigi na sina 'e laufolo. ");
INSERT INTO kwd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma alata 'e oru mae'ola alata sina 'e laulafi, la Jisas 'e o'omae ba'ita ma ka 'ilo'oo, “Eloi, Eloi, lama sabakatani” na fatalana Aramaik. Ngaia 'e fa'aladamia alafuunga lo'oori 'e 'ilo'oo, “God agu, God agu, 'utaa na 'i'oo ma'asini te'eni nau?” ");
INSERT INTO kwd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma tani wane na gila to'oru 'i no'ona, gila ka longoa, ma gila ka madafia ngaia 'e o'omae fala Elaeja, nga profet. ");
INSERT INTO kwd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma te'e wane aaga 'e totola kau, ma ka toonge'enia nga me'e ruu 'ubulana waeni ukwala, ma ka arua 'i maana maa'e 'ai, ma ka lafua 'i langi 'i maana ngiduna la Jisas fana 'ani go'ufia, ma ngaia ka fata 'ilo'oo, “Goru aga madi, lauta la Elaeja te'e leka mai ma ka lafua mai 'i wado fa'asia nga 'ai folo!” ");
INSERT INTO kwd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma la Jisas ka o'omae ba'ita, sui mai ngaia ka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma nga ruu ba'ita ne'e to'ofonosia nga gule'e Lefu Abu 'i 'ubulana nga 'Ifi Abu na God 'e akasi 'ita mai 'i gouna leleka ma ka nigi 'i 'a'aena. ");
INSERT INTO kwd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma nga wane na'ona'o na ta'a na fununga, ne'e ula 'i 'a'aena nga 'ai folo, ngaia 'e longoa nga o'omae lana, ma ka agasia nga maenga aana, ngaia 'e bi'i alafuu 'ilo'oo, “Ngaia kwala'imori no'o, nga wane lo'oo Wela ala God no'o!” ");
INSERT INTO kwd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma tani fu'igeni ngaa'i gila to'oru la'u mola 'ino'ona, gila te'e agaaga lalau la'a kau. Ni Meri nga noni 'i Magdala, ma ni Meri nga ga'ia la Jemes sika'a ma la Joses. Ma ni Salome 'e to'oru la'u mola no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gila leka la'u 'i burina la Jisas na alata ngaia 'e to'oru 'ua 'i Galili, ma gila ka kwaibooni ana. Ma ni noni 'e aula la'u mola na gila leka mai fe'enia fani Jerusalem, gila to'oru la'u mola no'ona. ");
INSERT INTO kwd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma ngaia 'e laulafi no'o, la Josef nga wane fa'asia fanua 'i Arimetea, ngaia 'e leka mai. Ngaia nga wane taringa'i na ni wane ni fadafadanga ne'e kwaimamani la'u mola fana agasilana alata God 'ani ba'ita fafia ta'a aana. Ngaia 'e 'uri, ma ka leka mai te'ala Paelat. Ma ngaia ka kwaisoe fana nga labena la Jisas, suria nga gani lo'oori nga gani na nga sasaringa mamania nga Sabat, nga gani fana mamalongaa. ");
INSERT INTO kwd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma la Paelat ka 'alefo ne'e longoa la Jisas ngaia 'e mae no'o. Ma ngaia ka o'omae fana wane na'ona'o na ta'a na fununga, ma ka orisia lauta la Jisas 'e mae no'o. ");
INSERT INTO kwd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma 'i burina la Paelat 'e longoa wane na'ona'o lo'oo ngaia 'e iiria ne'e mae no'o, la Paelat bi'i alamia la Josef 'ani ngaria labena la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sui, ma la Josef ka foria nga ruu tekwa sugalai 'e ba'ita ma ka lafua labena la Jisas 'i wado, ma ka 'afua 'ania ruu lo'oo, ma ka arua 'i 'ubulana nga giru gwa'u lo'oo gila takwea 'i 'ubulana nga fou. Sui ma ka geua te'e me'e baba na fou ba'ita, ma ka bokota no'o maana nga giru gwa'u lo'oori. ");
INSERT INTO kwd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma ni Meri nga noni 'i Magdala, ma ni Meri na ga'ia la Joses, gala ka agasia no'o lefu na gila kwaiatoa la Jisas ai. ");
INSERT INTO kwd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma 'i burina nga sina 'e suu na nga gani na mamalongaa, ni Meri nga noni 'i Magdala, ma ni Meri nga ga'ia la Jemes, ma ni Salome, gala ka foria mai nga 'ola si'inilana 'e le'a fana nga 'usulai na labena la Jisas. ");
INSERT INTO kwd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na 'usugani logologo'a 'ua na Sande, alata sina bi'i tata'e mola, gila ka leka mai fana lefu ni arulana wane mae. ");
INSERT INTO kwd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Alata gila leka, gila ka kwaiorisi kwairiu, ma gila ka 'ilo'oo, “Ni dai na te'e geua nga baba'e fou laka'u fa'asia maana giru gwa'u laka'u?” Suria fou no'o na 'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma, alata gila nigi no'ona, gila ka agasia nga baba'e fou laka'u 'e ageu no'o. ");
INSERT INTO kwd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma alata gila ru'u kau 'i 'ubulana nga giru gwa'u, gila agasia te'e wane bi'i ba'ita 'e ru'ufia ruu tekwa kwakwao'a, ma ka to'oru gula le'a 'ubulana giru gwa'u lo'oo. Ma gila ka ma'u no'o. ");
INSERT INTO kwd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma ngaia ka fata 'ilo'oo, “Moru sia ma'u mola. Nau ku su'aai mooru moru kwailo 'ofia la Jisas, nga wane 'i Nasaret na gila kwa'ia 'i bata'ana nga 'ai folo. Ngaia 'amoe no'o 'ilo'oo. Suria ngaia 'e tata'e no'o fa'asia maenga! Moru agasia nga lefu laka'u gila kwaiatoa ai! ");
INSERT INTO kwd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Moru leka te'ana fufu'iwane aana fe'enia la Pita, ma moru ka kwairii 'ilo'oo faga, ‘La Jisas 'e leka no'o 'i na'o mamania mooru 'i Galili, tamooru agasia 'ino'ona, 'ilaka'u ngaia 'e iiria no'o famooru.’” ");
INSERT INTO kwd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma nga fu'igeni lo'oori gila ka ru'u no'o kau 'i maa, ma gila ka totola no'o fa'asia nga giru gwa'u lo'oori, suria gila ma'u, ma gila ka lebelebe no'o. Gila 'ame iiria no'o ta 'ola fana ta wane, suria gila ma'u ba'ita. ");
INSERT INTO kwd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na 'usugani na Sande, la Jisas ngaia 'e moori la'u, ma ka faata'i ani Meri nga noni 'i Magdala, nga noni laka'u la Jisas ngaia 'e belote'enia nga fiu adalo laka'u fa'asia. ");
INSERT INTO kwd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma ni Meri ka leka te'ana ni wane na fufu'iwane aana. Gila kwaimanadai, ma gila ka aani ba'ita. Ma ni Meri ka kwairii te'aga. ");
INSERT INTO kwd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma alata na gila longoa na la Jisas ngaia 'e moori, ma ni Meri ka agasia no'o, gila 'ame fito'o mola ani Meri. ");
INSERT INTO kwd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma 'i buri la'u mola, la Jisas ka faata'i la'u fana nga rua wane ni fafulongonga aana, na fe'e faata'inga oriori matari alata gala leka suria nga tala fa'asia 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma gala ka ori mai, ma gala ka kwairii la'u te'ana ni wane na fufu'iwane aana, tafe'ua ma gila 'ame fito'o la'u mola. ");
INSERT INTO kwd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma 'i burina la Jisas 'e faata'i fana nga akwala ma te'e wane na fufu'iwane aana, alata gila fanga. Ma ngaia ka fata ngenge'a faga suria gila 'ame lo'oo ana, suria manatalaga 'e ngasi 'e iiki fana nga lo'onga na ta'a na gila agasia 'i burina ne'e tata'e fa'asia maenga. ");
INSERT INTO kwd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma ngaia ka fata 'ilo'oo faga, “Moru leka 'i 'ubulana afirina nga fanua lo'oo 'i wado, ma moru kwairii 'ania Kwairiinga Le'a lo'oo fana nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma ni dai ne'e fito'o na nga Kwairiinga Le'a lo'oo, ma ka naruabu, ngaia te'e momoori firi fe'enia God. Ma ni dai na ngaia 'ame lo'o ala God, God te'e ma'asini te'enia. ");
INSERT INTO kwd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma ni wane na gila fito'o, tagila to'o na tegelangaa fana agelana 'ola ni 'alefosilai 'ilo'oo: Tagila belote'enia adalo 'ania nga latagu, ma tagila fata 'ania nga alafuunga matari na gila 'ame su'aai. ");
INSERT INTO kwd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma lauta gila gemasia ta waa ke'eke'e, 'amoe gila ka go'ufia ta ka'o ni maerilai, ngaia 'esia malangadaga mola. Ma lauta gila arua nimaga 'i fofona ta wane 'e fii, ma ngaia 'e gwari'a no'o.” ");
INSERT INTO kwd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'Iburina Alafa la Jisas ngaia 'e alafuu fe'eniga 'e sui, ngaia ka fane no'o fani langi, ma ka to'oru 'i gula le'a ala God ma ka ba'ita no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma nga fufu'iwane aana gila ka leka, ma gila ka kwairii 'ania fatalana God na fanua te'efou. Ma nga Alafa ka taunga'i fe'eniga, ma ka kwatea nga tegelangaa faga fana agelana 'ola ni 'alefosilai lo'oo 'ani faate'enia nga kwaifa'ananaunga aaga ngaia 'e kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kwe Teofilas, nga ta'a 'e aula gila di'aia giringa suria ni 'ola lo'oo te'efou na'a la Jisas ngaia 'e agea 'i laloadauru. ");
INSERT INTO kwd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gila giri suria ni 'ola na'a 'imeeru meru longoa fa'asia nga ta'a na'a gila agasia ni 'ola lo'oori ne'e lau, ma gila ka kwairii la'u suria nga Kwairiinga Le'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngaia na'a, kwe Teofilas, nau ku manata suria ngaia 'e le'a fana 'aku giri suria ni 'ola lo'oori famu, tofuna 'inau ku aruto'o le'a ai 'ola te'efou, 'ita no'o mai na etalana alafuunga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma 'inau ku giri suria ni 'ola lo'oo fana 'i'oo 'ani su'aai nga to'onga na ni 'ola te'efou na'a gila kwaifa'ananau 'ania famu. ");
INSERT INTO kwd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na nga alata la Herod ngaia 'e ba'ita fafia gule'e lefu 'i Judea, te'e fataabu na'a latana la Sekaraea ngaia 'e to'oru na alata no'ona, ma ngaia na wane na fufu'iwane na fataabu gila fa'alata 'ania la Abaeja. Nga noni aana ni Elisabet ngaia 'e futa mai na nga fufutanga na fataabu na gila leka mai fa'asia la Eron, wane futa fe'enia la Moses, nga profet. ");
INSERT INTO kwd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nga abulongaa aga te'efou ngaia 'e odo maka le'a 'i na'ona God, suria gala lo'o 'e iiki suria nga tagi ala God. ");
INSERT INTO kwd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tafe'ua, ma te'e 'ola momola, ne'e 'amoe agaa'a, gala 'ame to'o na ta wela, tofuna ni Elisabet ngaia 'e 'aiwane. Ma ngaia fe'enia kwaiina la Sekaraea, gaa'a gala koko'o no'o. ");
INSERT INTO kwd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te'e gani ngaa'i la Sekaraea ngaia 'e ru'u 'ubulana 'Ifi Abu na God, tofuna alata lo'oori nga alata na oguogunga na nga fataabu la Sekaraea ngaia 'ani agea nga taunga'inga na fataabu. ");
INSERT INTO kwd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ta'ua nga falafala na fataabu fana eefasilana tani fataabu la'u fana do'ofilana ai 'e si'ini 'e le'a, ne'e 'ilo'oo: Gila ka 'ui 'ania 'ola 'ilaka'u nga daisi fana eefasilana ni dai na te'e agea la'u nga taunga'inga na fataabu fana do'ofilana ai si'inilana 'e le'a 'i fofona uumu ni do'ofinga 'ubulana 'Ifi Abu na God. Alata lo'oori, gila ka firia la Sekaraea, ma ngaia ka ru'u 'i 'ubulana 'Ifi Abu na God lo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ma ni ta'a 'e aula na gila to'oru 'i maa, gila ka fo'a na alata ne'e do'ofia nga 'ola 'e le'a lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma te'e enselo na God ka faata'i fala Sekaraea, ma ngaia 'e ula 'i gula le'a na uumu ni do'ofinga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Alata la Sekaraea ngaia 'e agasia nga enselo lo'oo, ngaia ka lebe maka ma'u ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tafe'ua, ma nga enselo lo'oori ka fata 'ilo'oo fana, “Sekaraea, 'i'oo sia ma'u mola! God ngaia 'e longoa nga fo'anga amu, ma nga noni amu ni Elisabet te'e fa'afuta te'e wela wane, ma 'i'oo to'o fa'alata 'ania la Jon. ");
INSERT INTO kwd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma 'i'oo to'o malale'a ba'ita, ma nga ta'a 'e aula la'u mola, tagila malale'a na alata lo'oo ngaia te'e futa mai ai! ");
INSERT INTO kwd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tofuna ngaia nga wane taringa'i 'i maana God. Ngaia 'e sia go'ufia mola waeni ma nga bia. Ma nga alata ngaia 'e futa mai, nga Anoe 'ola Abu te'e nana'i no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ngaia te'e orite'enia mai nga ta'a 'e aula 'i Israel te'ana Alafa nga God aaga. ");
INSERT INTO kwd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma ngaia te'e leka mai 'i na'o na Kraes, ma te'e tegela'a 'ilaka'u la Elaeja nga profet. Ni dai na gila orisu'usu'u 'i laloaga, ngaia te'e oguga la'u, nga mama'a ma ni wela aana, tagila aile'a faga kwairiu. Ma ngaia te'e lamadu'aa manatana nga ta'a ne'e abulo'o, fana 'agila funi'oo le'a. Ma ngaia te'e sasari agau na nga ta'a fana nga Kraes, fana 'agila mamamania nga nigilana mai.” ");
INSERT INTO kwd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma tofuna la Sekaraea 'e fitala mola, ngaia ka fata 'ilo'oo fana enselo lo'oori, “Nau taku su'a 'utaa na 'ola lo'oo na te'e lau? Suria nau fe'enia noni agu, mele koko'o te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma nga enselo ngaia 'e lamadu'aa ma ka fata 'ilo'oo: “Nau la Gebriel na'a nau ku to'oru firi fe'enia God. Ma God lo'oo 'e usunge'eni nau mai, fana 'aku alafuu fe'eni'o, ma 'inau 'aku kwairii te'amu na nga kwairiinga le'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma tofuna 'i'oo 'ame fito'o na fatalagu, nga ngiduna te'e gelo, mai 'i'oo sia alafuu tafa mola leleka ma ka nigi na alata na 'ola 'inau ku kwairii 'ania famu 'ani lau kwala'imori. Ma ni 'ola lo'oo tagila lau ai.” ");
INSERT INTO kwd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na alata no'ona nga ta'a na gila to'oru mamamania la Sekaraea lo'oo, gila ka 'alefo ba'ita, suria ngaia 'e to'oru aburu mai 'i 'ubulana 'Ifi Abu na God. ");
INSERT INTO kwd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma alata la Sekaraea ngaia 'e leka mai 'i maa te'ana ta'a lo'oori, nga ngiduna 'e gelo no'o, ma ngaia 'ame alafuu no'o fe'enia nga ta'a lo'oori. Sui ma ta'a lo'oo te'efou, gila ka manata 'ilo'oo no'o: “Kwala'imori ba'ita, ngaia 'e agasia nga faata'inga 'i 'ubulana 'Ifi Abu na God.” Tofuna na ngiduna 'e gelo no'o, ngaia ka alafuu mola 'ania nimana fana ta'a. ");
INSERT INTO kwd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma nga alata aana fana taunga'inga 'ubulana 'Ifi Abu na God ngaia 'e sui no'o, la Sekaraea bi'i ori la'u fani 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma ngaia 'ame aburu mola 'i burina, ma noni aana ni Elisabet 'e guru'a no'o, mai suria nima singari na'a, ngaia 'ame riu kwairiu no'o 'i maa fa'asia 'ifi agaa'a, ");
INSERT INTO kwd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ma ngaia ka fata 'ilo'oo, “Alata lo'oo, God ngaia 'e kwaibooni no'o agu, maka lafu nau no'o fa'asia maila nga laka'u 'inau ku to'oru mai ai maana ta'a 'e aula.” ");
INSERT INTO kwd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Alata ni Elisabet ngaia 'e guru'a maka nana'i no'o suria ono singari, God 'e kwatea mai enselo Gebriel fana te'e fanua 'ubulana gule'e lefu 'i Galili na'a gila iiria 'i Nasaret. ");
INSERT INTO kwd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngaia 'e ngaria mai te'e alafuunga fana te'e wela geni laari'i na gila arufafia fana wane na latana la Josef, fana 'ani feea. La Josef ngaia 'e futa mai orioritana nga fufutanga ala Defete nga kiingi. Nga latana laari'i lo'oori ni Meri. ");
INSERT INTO kwd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nga enselo ngaia 'e leka mai, ma ka fata 'ilo'oo fana, “Asua le'a kau! God ngaia 'e to'oru fe'eni'o maka nanamate'eni'o!” ");
INSERT INTO kwd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Alata ni Meri 'e longoa nga fatalana enselo lo'oori, nga manatangaa 'e nonifii, ma ngaia ka kwailo'ofia nga fa'afolaasilana nga alafuunga lo'oori na enselo ngaia 'e iiria fana. ");
INSERT INTO kwd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sui ma enselo ka fata 'ilo'oo la'u fana, “Meri 'ae, 'i'oo sia ma'u mola, tofuna God ngaia 'e kwatea kwai'ofeinga famu. ");
INSERT INTO kwd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tofuna ngaia 'e firi'o, to'o guru'a, ma 'i'oo to'o fa'afuta te'e wela wane, ma to'o fa'alata 'ania la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma ngaia te'e ba'ita, ma tagila fa'alataa 'ania Wela na God ne'e 'inato'o maka ba'ita 'e iiki. God te'e kwatea ngaia 'ani ba'ita fafia ta'a, 'ilaka'u wawarifuna la Defete. ");
INSERT INTO kwd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma ngaia te'e Kiingi fafia nga ta'a 'i Jiu furifuri, ma nga tegelangaa aana 'ato 'ani sui!” ");
INSERT INTO kwd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma ni Meri ka fata 'ilo'oo fana enselo lo'oori, “Nau ku lari'i mola, nau ku 'ame su'asuria 'ua ta wane. 'Utaa ma alafuunga lo'oo 'i'oo iiria fagu te'e lau?” ");
INSERT INTO kwd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma nga enselo lo'oori ngaia 'e lamadu'aa 'ilo'oo, “Nga Anoe 'ola Abu te'e sifo mai fafi'o, ma nga tegelangaa na God ne'e 'inato'o maka ba'ita 'e iiki te'e nana'i fe'eni'o. Tofuna 'i ngaia nga wela 'e abu lo'oori, tagila fa'alata 'ania nga Wela ala God. ");
INSERT INTO kwd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'I'oo su'a na noni futangamu ni Elisabet. Nga ta'a te'efou gila iiria ngaia 'e 'ato no'o fana 'ani to'o na ta wela. Tafe'ua ngaia 'e koko'o no'o, tala'ina lo'oo ngaia 'e guru'a ma ka nana'i no'o suria ono singari. ");
INSERT INTO kwd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tofuna te'efuta 'ola 'ame 'ato mola fana God.” ");
INSERT INTO kwd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma ni Meri ka fata 'ilo'oo, “Nau ku siria 'ola lo'oo 'i'oo iiria fagu 'ani lau kwala'imori no'o mai fagu, tofuna nau nga geni ni taunga'inga na God.” Alata ni Meri ngaia 'e fata 'ilo'oo mola, nga enselo ka leka no'o fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nga alata no'ona, ni Meri 'e sasari ma ka leka 'afe'aferu no'o fana te'e fanua 'e lalau 'i fataia na gule'e lefu 'i Judea. ");
INSERT INTO kwd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Alata ngaia 'e nigi, ngaia 'e ru'u 'i 'ifi ala Sekaraea, maka fata le'ale'a fana ni Elisabet. ");
INSERT INTO kwd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma alata ni Elisabet 'e longoa nga fatalana ni Meri, nga wela ne'e guru'a 'ania 'e lebe ma ka 'asu no'o 'i 'ubulana. Ma nga Anoe 'ola Abu ka sifo fafia ni Elisabet, ");
INSERT INTO kwd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma ngaia ka fata ba'ita 'ilo'oo, “Nga kwai'ofeinga famu 'e riufia ni noni te'efou, ma nga kwai'ofeinga la'u fana nga wela lo'oo 'i'oo guru'a 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'Ola 'e 'utaa na nga 'ola ba'ita lo'oo 'ani lau fagu, nga ga'ia Alafa agu 'e leka mai fana nga agasilagu! ");
INSERT INTO kwd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tofuna alata 'inau ku longoa mola nga alafuunga amu, nga wela lo'oo 'inau ku guru'a 'ania 'e 'idu kwairiu no'o 'ubulagu, tofuna ngaia 'e malale'a ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nga kwai'ofeinga famu tofuna 'i'oo fito'o ana nga fatalana God famu te'e lau!” ");
INSERT INTO kwd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma ni Meri ka fata 'ilo'oo, “Nga mangogu 'e tafea God, ");
INSERT INTO kwd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma nga mangogu 'e malale'a suria God 'e fa'amoori nau. ");
INSERT INTO kwd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nau ku nguu tafea God, suria ngaia 'e madai nau, nau nga geni ku malofi'a mola, ma ku to'oru mola fana nga taunga'inga fana. Ngaia 'e eta tala'ina ma ka ori 'ala'a, nga ta'a te'efou gila ka iiri nau ku to'oru 'ania kwai'ofeinga ba'ita, ");
INSERT INTO kwd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","suria ni 'ola ba'ita na God 'e agea fagu 'ania tegelangaa ana te'efou. Nga latana God 'e abu. ");
INSERT INTO kwd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngaia 'e faate'enia kwaimanadainga aana fana ta'a te'efou fe'enia nga ru'uru'ua aaga na gila fa'aba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ngaia 'e tagwala nga nimana ne'e tegela'a ba'ita, maka tagale'enia nga ta'a na gila tafega 'i talaga. ");
INSERT INTO kwd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ngaia ka fa'asifoa nga ta'a ba'ita fa'asia nga tegelangaa aaga, ma ka lafua wane gila malofi'a. ");
INSERT INTO kwd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ni wane na'a gila molo'u, ngaia 'e langoniga 'ania ni 'ola le'a, ma ngaia ka agea wane 'ola'a, ka galafa. ");
INSERT INTO kwd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ngaia 'e manata to'ona nga fataarunga'inga aana ngaia 'e agea fana wawarifu dauru maka kwaibooni adauru, nga ta'a ni taunga'inga aana 'i Israel. Ngaia 'ame manata mabolosia 'ani faate'enia kwailaeta'afiinga aana ne'e fataarunga'i 'ania fala Ebraham, ma fadauru la'u mola nga fufutanga aana 'ani nana'i firi!” ");
INSERT INTO kwd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ni Meri ngaia 'e to'oru fe'enia ni Elisabet suria oru singari, sui ma ngaia bi'i ori na fanua aana. ");
INSERT INTO kwd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nga alata fana ni Elisabet 'ani fa'afuta ngaia 'e nigi no'o, maka fa'afuta te'e wela wane. ");
INSERT INTO kwd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ni ta'a ni kwaimaanga aana ma nga ta'a na nga fufutanga aana, gila longoa nga 'ola le'a na'a God ngaia 'e agea fana, ma gila ka malale'a ba'ita fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fiu maa'e gani 'e sui burina futalana wela lo'oori, ma gila ka agea ta'ua nga falafala 'i Jiu fana kwaringa na lofona wela. Ma gila ka siria 'agila fa'alata 'ania ma'a aana la Sekaraea. ");
INSERT INTO kwd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tafe'ua, ma ni ga'ia ka fata 'ilo'oo, “Mooru sia fa'alataa mola 'ania lata no'ona! Nga latana la Jon.” ");
INSERT INTO kwd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma nga ta'a te'efou gila fata ma gila ka 'ilo'oo, “Te'efuta wane na fufutanga amoo'o 'ame to'o na lata lo'oori.” ");
INSERT INTO kwd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma gila ka alafuu 'ania nimaga, ma gila ka kwatea faata'inga fana ma'a aana la Sekaraea, ma gila ka orisia fana lata lo'oo 'e siria 'agila fa'alata 'ania wela lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma la Sekaraea ka lalofiga, maka kwaisoe te'e kabe'ola fana giringa, ma ngaia ka giri 'ilo'oo, “Nga latana wela lo'oo la Jon.” Ma ta'a te'efou gila ka 'alefo ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma te'e alata lo'oori la'u mola, nga ngiduna la Sekaraea ka 'ulasi no'o, ma ngaia ka tafea no'o God. ");
INSERT INTO kwd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma nga ta'a lo'oo te'efou na gila ogu mai 'i no'ona, gila ka 'alefo ba'ita, ma nga kwairiinga suria ni 'ola lo'oori ka talo no'o 'i laloana ta'a na'a gila to'oru 'i fataia 'ubulana gule'e lefu 'i Judea. ");
INSERT INTO kwd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma nga ta'a te'efou na gila longoa 'ola lo'oori, gila ka manata suria, ma gila ka fata 'ilo'oo, “Nga wela lo'oo te'e lau fana wane 'utaa lo'oo?” Gila fata 'ilo'oo, suria gila su'aai nga tegelangaa ana God 'e to'oru fe'enia wela lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma nga Anoe 'ola Abu ka fa'afongua no'o la Sekaraea mama'a ala Jon, ma la Sekaraea ka foule'enia nga fatalana God ma ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“'Agoru tafea God lo'oo, ngaia God adauru ta'a 'i Jiu. Ngaia 'e leka mai fana booni ladauru, nga ta'a aana, ma fana nga fa'amoori ladauru. ");
INSERT INTO kwd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ngaia 'e kwatea mai fadauru te'e wane kwaifa'amooringa ne'e to'o na tegelangaa ba'ita, ne'e leka mai fa'asia fufutanga ala Defete, nga wane ni taunga'inga na Alafa. ");
INSERT INTO kwd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngaia 'e fataarunga'i mai fadauru na ni 'ola lo'oo, na fatalana ni profet abu mai na'o, ");
INSERT INTO kwd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","fana 'ani fa'amoori dauru fa'asia nga marimae adauru ma fa'asia nga tegelangaa na ta'a na'a gila aga mani adauru. ");
INSERT INTO kwd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ngaia ka fataarunga'i mai 'ani faate'enia nga kwailaeta'afiinga aana fana wawarifu dauru, ma ngaia ka manata to'ona nga fataarunga'inga abu aana. ");
INSERT INTO kwd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ngaia ka fataarunga'i fana wawarifu dauru la Ebraham ");
INSERT INTO kwd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na'a ngaia te'e lafu 'adauru fa'asia nga marimae adauru, fana 'aguru taunga'i fana ma goru sia ma'u mola, ");
INSERT INTO kwd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma fana 'aguru to'oru 'ani abu maka odo fana gani mai gani.” ");
INSERT INTO kwd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma la Sekaraea ka fata 'ilo'oo fana wela aana la Jon, “Wela agu, tagila fa'alata'o 'ania profet na God ne'e 'inato'o maka ba'ita 'e iiki. Ma to'o leka no'o 'i na'o na nga Kraes, fana 'i'oo 'ani iiria fana ta'a lo'oo 'agila fa'aodoa nga tala mamania nga Kraes. ");
INSERT INTO kwd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma to'o kwairii fana ta'a aana na tagila to'o na mooringa alata God 'e 'olafanataa na rianga aaga. ");
INSERT INTO kwd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Suria God adauru, ngaia wane fana kwailaeta'afiinga adauru. 'Ilaka'u nga sina 'e tata'e mai fe'enia foola'angaa, ");
INSERT INTO kwd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nga wane ni kwaifa'amooringa adauru 'e nigi mai fa'asia God fe'enia lalanga fana ta'a na'a gila to'oru 'ubulana maa'e logo na maenga. Ma ngaia 'e kwaibooni adauru ma te'e talai 'adauru fana nga aloalonga fe'enia God.” ");
INSERT INTO kwd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma wela lo'oo la Jon 'e ba'ita no'o, ma ka tegela'a na Anoe 'ola Abu. Ma alata ngaia 'e ba'ita no'o, ngaia 'e leka maka nana'i 'ubulana gule'e lefu langalanga, leleka maka nigi na gani ngaia 'e faata'i fana ta'a 'i Israel. ");
INSERT INTO kwd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Burina alata la Jon wane ni naruabunga 'e futa, nga wane ba'ita na fanua ba'ita 'i Rom nga latana la Ogastas, ngaia 'e arua te'e tagi fana ta'a na fanua te'efou olofana foufounga aana, fana 'agila leka 'i fanua na wawarifuga fana nga girilana lataga fana takisi. ");
INSERT INTO kwd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma ngaia na girigiringa eteeta gila agea alata la Kwirinias ngaia 'e ba'ita fafia profins 'i Siria. ");
INSERT INTO kwd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma nga ta'a te'efou, gila ka leka 'i fanua aaga fana girilana lataga. ");
INSERT INTO kwd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma la Josef 'e leka la'u mola fa'asia nga fanua ngaia 'e to'oru ai 'i Nasaret na gule'e lefu 'i Galili, maka leka fana gule'e lefu 'i Judea fana nga maa'e fanua ala Defete na'a gila fa'alata 'ania 'i Betlehem, tofuna la Josef ngaia nga wane na fufutanga ala Defete. ");
INSERT INTO kwd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","La Josef ngaia 'e leka no'o fana 'ani giria nga latana fe'enia ni Meri, nga geni laka'u gila arufafi ai fana. Ma nga alata no'ona, ni Meri ngaia 'e guru'a no'o. ");
INSERT INTO kwd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma alata gala nana'i 'i Betlehem, ngaia ka wela fii no'o fana fa'afutanga. ");
INSERT INTO kwd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma ngaia ka fa'afuta nga wela wane eteeta aana, maka 'afua 'ania ruu, maka fa'aenoa 'i 'ubulana lefu na langonilana buruka, suria 'ifi fana 'agala foria fana 'agila to'oru ai, gila fongu te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma nga ta'a na gila aga suria sifisifi, gila nana'i 'ubulana keufa galangia la'u mola nga fanua no'ona, 'ubulana fe'e logo no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nga enselo na God ka faata'i faga, ma nga lalanga ala God 'e lala 'afuiga, ma gila ka ma'u ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma nga enselo lo'oori ka fata 'ilo'oo faga, “Mooru sia ma'u mola, suria 'inau ku ngaria mai kwairiinga le'a lo'oo fana fa'amalale'alana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tala'ina lo'oo nga wane ni kwaifa'amooringa amooru 'e futa 'i 'ubulana fanua ala Defete 'i Betlehem, ma ngaia na nga Kraes, nga Alafa. ");
INSERT INTO kwd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma nga faata'inga famooru ne'e 'ilo'oo: Mooru tamooru agasia te'e wela sisika na'a gila 'afua 'ania ruu, ngaia 'e eeno na lefu fana fangarilana buruka.” ");
INSERT INTO kwd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gila lebe mola ma mole'e enselo fa'asia 'i langi gila ka faata'i la'u mola fe'enia enselo laka'u, ma gila ka tafea God ma gila ka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tafea God 'i Langi, nga aloalonga fana ta'a na fanua lo'oo 'i wado na'a God 'e malale'a fe'eniga.” ");
INSERT INTO kwd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'I burina nga enselo gila ori fani 'i Langi, nga ta'a gila aga suria sifisifi lo'oori gila ka alafuu kwairiu faga ma gila ka 'ilo'oo, “Goru leka madi fani Betlehem 'aguru agasia nga 'ola lo'oo God 'e fata 'i suria fadauru.” ");
INSERT INTO kwd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma gila ka leka 'afe'aferu, ma gila ka daria ni Meri fe'enia la Josef, ma gila ka agasia nga wela sisika lo'oo 'e eeno na lefu fana langonilana buruka. ");
INSERT INTO kwd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Alata gila agasia, gila ka fata suria nga 'ola lo'oo enselo gila iiria faga suria nga wela lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nga ta'a gila longoa, ma gila ka 'alefo ba'ita na alafuunga lo'oo gila kwairii 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ni Meri ngaia 'e manata to'ona 'ola lo'oori, maka gonia mola 'ubulana mangona. ");
INSERT INTO kwd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nga ta'a gila aga suria sifisifi gila ka ori, ma gila ka baatafea God fafia ta'ina 'ola te'efou na gila longoa, ma gila ka agasia ne'e kwala'imori 'ilaka'u no'o nga enselo 'e iiria faga. ");
INSERT INTO kwd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fiu maa'e gani 'e sui burina futalana la Jisas, ma gila ka ngaria fana 'agila kwaria lofona wela lo'oori, ma gala ka fa'alata 'ania la Jisas, nga lata laka'u nga enselo 'e iiria fana ni Meri, alata ngaia 'ame guru'a 'ua. ");
INSERT INTO kwd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma nga alata ngaia 'e nigi no'o fala Josef fe'enia ni Meri 'agala fa'akwari 'agaa'a no'o 'ilaka'u nga Tagi ala Moses ngaia 'e iiria 'i burina fa'afutanga. Sui ma, gala bi'i ngaria nga wela lo'oori fana 'Ifi Abu na God 'i Jerusalem fana 'agala kwatea fana God, ");
INSERT INTO kwd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","'ilaka'u gila giria 'e sui no'o 'i 'ubulana Tagi ala Moses gila 'ilo'oo, “Nga wela wane na'ona'o, tagila kwatea no'o fana God.” ");
INSERT INTO kwd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Gaa'a gala kwatea la'u nga tabonga 'ania rua me'e toruodu, 'ilaka'u nga Tagi ala Moses 'e iiria. Nga tabonga lo'oo 'ani fa'akwaria ni Meri. ");
INSERT INTO kwd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma nga alata lo'oori, te'e wane latana la Simion ngaia 'e to'oru 'i Jerusalem. Ngaia nga wane 'e odo, maka fini fo'asia God, maka to'oru ni kwaimamaningaa fana nga alata God 'ani fa'amooria nga ta'a 'i Israel. Nga Anoe 'ola Abu ngaia 'e to'oru ana, ");
INSERT INTO kwd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","maka iiria ngaia te'e moori leleka maka nigi na alata ngaia 'e agasia nga Kraes na God 'e fataarunga'i 'ania fana fa'amoorilana ta'a aana. ");
INSERT INTO kwd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nga Anoe 'ola Abu ngaia 'e talaia la Simion, maka leka fana 'Ifi Abu na God, ma ngaia ka agasia la Josef fe'enia ni Meri, alata gala ngaria mai nga wela sisika lo'oori la Jisas, ta'ua gala agea ni 'ola na Tagi ala Moses ne'e iiria fana agelai. ");
INSERT INTO kwd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sui ma la Simion ka lafua nga wela lo'oori 'ania nimana, maka baatafea God 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God, fataarunga'inga laka'u amu fagu, wane ni taunga'inga amu, ngaia 'e kwala'imori no'o. Ngaia na, 'inau ku to'omia no'o fana 'aku mae, tofuna manatalgu 'e tori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tofuna alata lo'oori, nau ku agasia no'o 'ania maagu nga wane na 'i'oo kwatea mai fana 'ani fa'amooria nga ta'a. ");
INSERT INTO kwd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ngaia nga wane na'a 'i'oo sasari agau aana, fana ta'a te'efou tagila agasia. ");
INSERT INTO kwd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wane ni fa'amooringa lo'oo, ngaia 'e 'ilaka'u nga uunu, tofuna ngaia 'e faate'enia nga kwaisiriinga amu fana ta'a na gila 'ame Jiu. Ma ngaia ka fa'aba'ita 'ameeru ta'a 'i Jiu meeru ta'a amu.” ");
INSERT INTO kwd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nga ma'a aana ma ni ga'ia la Jisas, gala ka 'alefo ba'ita alata gala longoa ni 'ola lo'oori la Simion ngaia 'e alafuu 'ania suria nga wela lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma la Simion ka nanamate'eniga. Sui, ma ngaia ka fata 'ilo'oo fana ni Meri, nga ga'ia, “Nga wela lo'oo wela na God ngaia 'e firia 'ua no'o mai. Ni ta'a 'e aula 'i Israel tagila to'o na mooringa tofuna, ma nga aulalana ta'a 'i Israel tagila abasi fa'asia God tofuna gila 'ame fito'o na fatalana. Ngaia lo'oo te'e faate'enia God fana ta'a, ma ta'a 'e aula tagila ma'asiri ana, ");
INSERT INTO kwd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","fana 'ani faate'enia nga manatalaga ne'e nagwa. Ma nga kwaimanadainga ba'ita te'e nigi amu ni Meri, ma te'e 'ilaka'u nga naifi ne'e to'o 'i nonimu 'e fii 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te'e me'e noni 'e nao ngaia 'e nana'i la'u mola na alata no'ona, nga latana ni Ana, ma ngaia nga noni ni rioriota la'u mola, ma ngaia 'e koko'o no'o. Ngaia nga wela geni ala Faniuel nga fufutalaa ala Asa. Ni Ana alata ngaia 'e laari'i, ngaia 'e 'afe maka nana'i fe'enia la kwaiina fana fiu farisi, ");
INSERT INTO kwd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mala kwaiina ka mae mola, ma ngaia 'e nigi no'o na kwaru akwala ma fai farisi aana. Ngaia 'e to'oru mola fana lekanga mola 'ubulana 'Ifi Abu na God fana abu fangafanga ma fo'asilana God suria gani ma logo. ");
INSERT INTO kwd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ni Ana alata lo'oori la'u mola, ngaia 'e daria la Josef fe'enia ni Meri, maka baatafea God, maka alafuu suria nga wela lo'oori fana ta'a te'efou na gila to'oru la'u mola mamania alata na God 'ani fa'amooria ta'a 'i Jiu ma ta'a 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Alata la Josef fe'enia ni Meri gala fa'asuia ni 'ola te'efou na'a Tagi ala Moses 'e iiria, gala ka ori no'o fani fanua agaa'a 'i Nasaret na nga gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nga wela lo'oori 'e ba'ita maka tegela'a, maka ka to'o na su'a'olanga. Ma kwaimaanga ana God 'e nana'i fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Furifuri na'a ma'aana ala Jisas ma ni ga'ia gala leka fani 'i Jerusalem fana fe'e gani ba'ita na Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma alata la Jisas ngaia 'e nigi na akwale'e farisi ma ruaai, gila ka leka na fafangalaa lo'oori suria nga falafala aaga. ");
INSERT INTO kwd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'I burina fafangalaa lo'oori 'e sui, mala ma'a ana ma ni ga'ia gala ka ori no'o, mala Jisas ka ole mola 'i Jerusalem, ma gala 'ame su'a mola ana. ");
INSERT INTO kwd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gala madafia iiria ngaia 'e leka no'o fe'enia nga oguogunga lo'oori, ma gala ka leka mola suria maa'e gani la'ula'u. Sui ma, gala bi'i eta fana kwailofilana laloana ta'a ni futanga aaga, ma nga ta'a ni kwaimaanga agaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma alata gala kwailo, ma gala 'ame daria no'o, ma gala ka ori no'o fani Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma 'i burina oruna maa'e gani gala bi'i daria 'i 'ubulana 'Ifi Abu na God. Jisas 'e to'oru fe'enia nga ta'a ni kwaifa'ananaunga 'i Jiu, ma ngaia ka longo faga, maka kwaiorisi suria ni 'ola gila fa'ananaua 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma nga ta'a te'efou no'ona gila longo suria alafuulana, gila 'alefo ba'ita na su'a'olanga aana ma ni lamadu'aanga aana. ");
INSERT INTO kwd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma alata la Josef ma ni Meri gala agasia, gala ka 'alefo ba'ita. Ma ni ga'ia ka iila 'ilo'oo fana, “Wela agu, 'i'oo manata 'utaa famee'e lo'oo? Mama'a amu mai nau, mele kwailo mai ofi'o, ma mele ka manadai'o 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma la Jisas ka orisi 'agaa'a 'ilo'oo, “Fe'ua lo'oo molo kwailo'ofi nau? To'omia amolo su'a mola ai 'inau ku nana'i mola lo'oo 'ubulana 'ifi na Ma'aagu.” ");
INSERT INTO kwd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tafe'ua gaa'a gala 'ame su'a mola na nga fa'aladamilana alafuunga lo'oo 'e iiria fagaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sui ma, la Jisas bi'i ori fe'eni 'agaa'a fana fanua 'i Nasaret, maka lo'o no'o suria gaa'a. Ma ni ga'ia 'e manata 'i suria ni 'ola lo'oori te'efou fana alata 'e aburu. ");
INSERT INTO kwd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma la Jisas 'e ba'ita, ma funi'oonga aana ka ba'ita la'u mola, ma God ngaia fe'enia ta'a lo'oo gila malale'a la'u fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ma alata lo'oo, 'e nigi no'o ana akwale'e farisi ma nima ai na'a la Taebirias 'e ba'ita fafia nga fanua ba'ita 'i Rom, ma la Pontus Paelat ka ba'ita fafia gule'e lefu 'i Judea, ma la Herod wane ba'ita fafia gule'e lefu 'i Galili, ma la Filip nga wane ni futanga aana 'e aga suria gule'e lefu 'i Iturea ma 'i Trakonaetis, ma la Lisanias ka aga suria gule'e lefu 'i Abilin. ");
INSERT INTO kwd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Alata lo'oo la'u mola, la Anas ma la Kaeafas gaa'a rua alafa ni suuabunga na ta'a 'i Jiu na fanua 'i Jerusalem. Ma alata lo'oo, God 'e alafuu te'ala Jon nga wela ala Sekaraea, alata ngaia 'e to'oru no'o 'i 'ubulana gule'e lefu langalanga. ");
INSERT INTO kwd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma la Jon ka leka na gule'e lefu ri'itana ka'o 'i Jodan. Ma ngaia ka fata 'ilo'oo fana ta'a, “Moru abulo mai fa'asia nga rianga amooru, ma moru ka naruabu, fana God 'ani 'olafanataa na rianga amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngaia 'e 'ilaka'u la Aesea nga profet 'e giria mai na'o maka 'ilo'oo, “Te'e wane ngaia 'e o'omae 'i 'ubulana gule'e lefu langalanga maka 'ilo'oo, ‘Nga Alafa ngaia te'e nigi mai! Ta'a mooru fa'aodoa nga tala fana! ");
INSERT INTO kwd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma mooru ka fa'afonua nga lefu ne'e wanawana'a ma moru ka ofotaa nga tale'e busu ma tale'e iile. Ma moru ka fa'aodoa nga tala ne'e 'e'eola ma mooru ka fa'adada nga tala ne'e ngangala'a. ");
INSERT INTO kwd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma ta'a te'efou tagila agasia na'a God 'ani fa'amooriga.’” ");
INSERT INTO kwd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma ta'a 'e aula gila leka mai te'ala Jon fana 'ani naruabu aga. Ma la Jon ka fata 'ilo'oo fana tani ta'a ngaa'i, “Mooru 'ilaka'u no'o ru'uru'ua na nga waa. Mooru moru madafia iiria naruabunga te'e fa'amoori 'amooru fa'asia kwa'ikwa'inga na God, tafe'ua ma moru 'ame abulo mola fa'asia rianga amooru? Suria manatanga mooru 'e kuta, ma moru sia talafia la'u kwa'ikwa'inga na God. ");
INSERT INTO kwd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Moru agea mola ni 'ola ne'e faate'enia moru abulo mai fa'asia nga abulongaa 'ame le'a amooru. Ma moru sia manata 'ilo'oo mola 'i 'ubulana manata lamooru, ‘'Ameeru nga ta'a meru futa na nga fufutanga ala Ebraham lo'oo. 'Ato fana kwa'ikwa'inga na God 'ani nigi ameeru.’ Mai nau ku kwairii odo no'o ai famooru, ngaia 'e wada'u mola fana God 'ani ngaria ta me'e fou na ni me'e fou lo'oo, maka launge'enia 'ania fufutanga ala Ebraham. ");
INSERT INTO kwd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ma alata lo'oo, God ngaia 'e sasari agau no'o na kwa'ikwa'inga, 'ilaka'u nga wane 'e dau na naifi, maka sasari agau fana tofulana 'ai lo'oo. Ma ni 'ai ne'e 'ame fungu 'ania ta lode ai ne'e le'a, te'e tofuga, maka to'osiga 'i 'ubulana eele.” ");
INSERT INTO kwd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sui ma nga ta'a no'ona gila orisia la Jon ma gila fata 'ilo'oo, “'Olataa na'a tameru agea 'ani faate'enia na'a 'imeeru meru abulo mai fa'aisa rianga ameru?” ");
INSERT INTO kwd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mai ngaia ka lamadu'aga maka 'ilo'oo, “Lauta te'efuta wane ngaia to'o na rua me'e ruu, ngaia 'ani kwatea nga ruana me'e ruu no'ona aana fana nga wane ne'e 'ame to'o na ta me'e ruu. Ma lauta te'efuta wane ngaia 'e to'o na fangalaa, ngaia 'ani dalo'ia.” ");
INSERT INTO kwd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma tani wane na gila ngaria bata fana takisi, gila nigi la'u mai fana naruabunga, ma gila ka orisia ma gila ka 'ilo'oo, “Wane kwaifa'ananaunga, 'olataa na'a tameru agea 'ani faate'enia na'a 'imeeru meru abulo mai fa'aisa rianga 'ameeru?” ");
INSERT INTO kwd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma la Jon ka fata 'ilo'oo la'u, “Moru ogua mola bata ne'e to'omia bata na'a tagi 'e iiria. Mooru sia soea mola bata ne'e riufia bata lo'oori.” ");
INSERT INTO kwd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma tani wane ni fununga gila ka orisia la'u 'ilo'oo, “Ma 'ameeru lo'oo, 'olataa na'a tameru agea 'ani faate'enia na'a 'imeeru meru abulo mai fa'asia rianga ameeru?” Ma ngaia ka fata 'ilo'oo faga, “Mooru sia ulange'enia ta wane fana kwatelana bata famooru. Ma mooru sia fa'ama'ua mola ta'a fana ngarilana bata aaga. Ma mooru ka aile'a mola fe'enia nga bata na gila foria mooru 'ania.” ");
INSERT INTO kwd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta'a gila kwaimamani fana nigilana mai nga Kraes, nga wane na God 'e firia 'ani fa'amooria nga ta'a aana, sui ma gila ka madafia 'ilo'oo, “Bala la Jon no'o na Kraes.” ");
INSERT INTO kwd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tafe'ua, ma la Jon 'e alafuu 'ilo'oo faga, “Nau ku naruabu amooru mola 'ania ka'o, tafe'ua ma wane na te'e nigi mai ngaia 'e ba'ita riufi nau. Mai nau ku 'ame to'omia 'aku rubea nga me'e butu 'i 'a'aena. Mai ngaia te'e naruabu amooru 'ania Anoe 'ola Abu ma 'ania eele. ");
INSERT INTO kwd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mai ngaia 'e sasari agau no'o fana to'ole'enilana ta'a te'efou, 'ilaka'u nga wane 'e 'efoa nga 'u'ui 'ola 'e le'a fa'asia nga 'e'efona. Ma ka ogua ni 'u'ui 'ola le'a 'i 'ubulana nga 'ifi ni goni'olanga, maka do'ofia no'o nga 'e'efona 'ubulana nga eele ne'e sia mae la'u.” ");
INSERT INTO kwd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma la Jon ka kwairii suria nga Kwairiinga Le'a lo'oo faga 'ania fatanga 'e aula, ma ngaia ka fata faga fana 'agila lo'o suria nga fatalana God. ");
INSERT INTO kwd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma alata lo'oori la'u mola, la Jon 'e fata tegela iiki fala Herod, nga wane ne'e Kiingi fafia gule'e lefu lo'oo, tofuna la Herod ngaia 'e feea ni Herodias, nga 'afe na 'asina la Filip, ma ngaia 'e agea ni 'ola 'e ria 'e aula la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma nga 'ola ne'e 'e ria 'e iiki no'o na la Herod 'e agea na'a, ngaia 'e gemasia la Jon, maka arua 'ubulana lokafu. ");
INSERT INTO kwd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mai na'ona alata la Jon ngaia 'e to'oru 'ubulana lokafu, ngaia 'e naruabu no'o na ta'a 'e aula. La Jisas 'e leka mai, ma la Jon ka naruabu ana. Alata Jisas 'e fo'a, ma nga lalo ka 'ulasi, ");
INSERT INTO kwd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma nga Anoe 'ola Abu ngaia ka sifo mai fafia 'ilaka'u te'e me'e bola. Ma te'e kwala 'e 'ola 'e leka mai fa'asia 'i Langi maka 'ilo'oo, “'I'oo no'o na'a wela agu na'a nau ku kwaimaa famu, mai nau ku aile'a ba'ita fe'eni'o.” ");
INSERT INTO kwd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma alata lo'oo la Jisas ngaia 'e to'omia no'o oru akwale'e farisi fafia futalana, ngaia 'e eta no'o fana lekanga kwairiu fana kwaifa'ananaunga. Ma ta'a te'efou, gila manata 'ilo'oo la Jisas ngaia nga wela ala Josef lo'oo mola. La Josef lo'oo ne'e futa mai ana la Hilae. ");
INSERT INTO kwd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","La Hilae ngaia 'e futa ana la Matat, la Matat 'e futa ana la Lifae, la Lifae 'e futa ana la Melkae, la Melkae 'e futa ana la Danae, la Danae 'e futa ala Josef lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","La Josef lo'oo nga wela ala Matataeas, la Matataeas 'e futa ala Emos, la Emos 'e futa ala Neham, la Neham 'e futa ala Eslae, la Eslae 'e futa ala Nagae. ");
INSERT INTO kwd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","La Nagae nga wela ala Meata, la Meata 'e futa ala Matataeas, la Matataeas 'e futa ala Semein, la Semein 'e futa ala Josek, la Josek 'e futa ala Joda. ");
INSERT INTO kwd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","La Joda nga wela ala Joanan, la Joanan 'e futa ala Risa, la Risa 'e futa ala Serababel, la Serababel 'e futa ala Sialtiel, la Sialtiel 'e futa ala Nirae. ");
INSERT INTO kwd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","La Nirae nga wela ala Melkae, la Melkae 'e futa ala Adae, la Adae 'e futa ana la Kosam, la Kosam 'e futa ana la Elmadam, la Elmadam 'e futa ana la Er. ");
INSERT INTO kwd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","La Er nga wela ala Josua, la Josua 'e futa ana la Elaesa, la Elaesa 'e futa ana la Jorim, la Jorim 'e futa ala Matat, la Matat 'e futa ala Lifae. ");
INSERT INTO kwd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","La Lifae nga wela ala Simion, la Simion 'e futa ala Juda, la Juda 'e futa ala Josef, la Josef 'e futa ala Jonam, la Jonam 'e futa ala Elaeakim. ");
INSERT INTO kwd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","La Elaeakim nga wela ala Milia, la Milia 'e futa ala Mena, la Mena 'e futa ala Matata, la Matata 'e futa ala Netan, la Netan 'e futa ana ala Defete. ");
INSERT INTO kwd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","La Defete nga wela ala Jesi, la Jesi 'e futa ana la Obed, la Obed 'e futa ala Boas, la Boas 'e futa ana la Salmon, la Salmon ne'e futa ala Nason. ");
INSERT INTO kwd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","La Nason nga wela ala Aminadab, la Aminadab 'e futa ala Admin, la Admin ne'e futa ala Anae, la Anae 'e futa ala Hesron, la Hesron 'e futa ala Peres, la Peres 'e futa ala Juda. ");
INSERT INTO kwd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","La Juda nga wela ala Jekob, la Jekob 'e futa ala Aesak, la Aesak ne'e futa ala Ebraham, la Ebraham 'e futa ala Tera, la Tera ne'e futa mola ala Neho. ");
INSERT INTO kwd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","La Neho nga wela ala Sirag, la Sirag 'e futa ala Riu, la Riu 'e futa ala Pileg, la Pileg 'e futa ala Eba, la Eba 'e futa ala Sela. ");
INSERT INTO kwd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","La Sela nga wela ala Keinan, la Keinan ne'e futa ala Afaksad, la Afaksad 'e futa ala Siem, la Siem 'e futa ala Noa, la Noa 'e futa mola la Lamek. ");
INSERT INTO kwd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","La Lamek nga wela ala Metusala, la Metusala 'e futa ala Enok, la Enok 'e futa ala Jered, la Jered ne'e futa ala Mahelalel, la Mahelalel 'e futa ala Kenan. ");
INSERT INTO kwd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","La Kenan nga wela ala Enos, la Enos 'e futa mola ala Set, la Set ne'e futa ala Adam nga wela ala God. ");
INSERT INTO kwd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nga Anoe 'ola Abu ngaia ka sifo fafia la Jisas, ma la Jisas ka ori mai fa'asia nga ka'o 'i Jodan, ma nga Anoe 'ola Abu ka talaia fana 'ubulana gule'e lefu langalanga. ");
INSERT INTO kwd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma la Saetan ka irito'ona la Jisas suria fai akwale'e gani. Ma ni gani lo'oori, la Jisas 'ame 'ania no'o ta fangalaa, ma ngaia ka molo'u no'o. ");
INSERT INTO kwd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma la Saetan ka fata 'ilo'oo fana, “Tofuna 'i'oo nga Wela na God, 'oi fata fana fou lo'oo 'ani lau na beret.” ");
INSERT INTO kwd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma la Jisas ka lamadu'aa maka 'ilo'oo, “Nga Girigiringa Abu 'e iiria, ‘Nga wane 'ame momoori 'ania fangalaa 'i talana.’” ");
INSERT INTO kwd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui mala Saetan ka talaia fana gouna me'e busu, ma 'afe'aferu ngaia ka faate'enia fana nga foufoula te'efou na fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma ngaia ka fata 'ilo'oo fala Jisas, “Nau taku kwatea nga foufoula lo'oo te'efou ma ta'ina 'ola le'a lo'oo te'efou famu. 'I'oo su'aai ni 'ola lo'oo te'efou God 'e kwatea fagu, mai nau ku su'asuria 'aku kwatea te'efou fana wane ni dai na 'inau ku firia. ");
INSERT INTO kwd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma lauta 'i'oo bobouruuru, moko fo'osi nau, nau taku kwatea 'ola lo'oo te'efou famu.” ");
INSERT INTO kwd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma la Jisas ngaia 'e lamadu'aa maka 'ilo'oo, “Nga girigiringa Abu 'e iiria, ‘Te'e God amu no'o na 'i'oo to'o fo'osia, ma 'i'oo to'o taunga'i fana.’” ");
INSERT INTO kwd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui mala Saetan ka talaia la'u mola fana fanua ba'ita 'i Jerusalem, maka fa'aulaa na te'e lefu ne'e lau 'i langi fofona 'Ifi Abu na God. Ma ngaia ka fata 'ilo'oo fala Jisas, “Tofuna 'i'oo nga Wela na God, 'oi olo fani wado, ");
INSERT INTO kwd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","suria nga Girigiringa Abu 'e iiria, ‘La God te'e kwatea mai nga enselo aana te'amu ma tagila aga suri'o, ");
INSERT INTO kwd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma gwa'a nga 'a'aemu 'e sia to'o mola na te'efuta me'e fou.’” ");
INSERT INTO kwd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma la Jisas ngaia ka lamadu'aa ma ka 'ilo'oo, “Nga Girigiringa Abu 'e iiria la'u mola 'ilo'oo, ‘'I'oo sia irito'ona mola Alafa na ngaia God amu.’” ");
INSERT INTO kwd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'I burina la Saetan 'e irito'ona la Jisas 'ania ni 'ola lo'oori te'efou, ngaia ka leka no'o fa'asia la Jisas na alata no'ona ma ka mamania alata ngaa'i 'ani irito'ona la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma nga tegelangaa na Anoe 'ola Abu ngaia 'e to'oru fe'enia la Jisas, ma ngaia ka ori no'o fana gule'e lefu 'i Galili. Ma nga kwairiinga suria 'e talofia 'ubulana nga fanua lo'oo te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma ngaia ka kwaifa'ananau 'ubulana 'ifi ni fo'anga aaga ma nga ta'a te'efou gila ka tafea no'o. ");
INSERT INTO kwd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sui ma la Jisas bi'i leka fani Nasaret, fanua 'e ba'ita mai ai. Na nga Sabat, gani na mamalonga, ngaia 'e ru'u 'i 'ubulana 'ifi ni fo'anga na Jiu suria nga falafala aana. Ma ngaia ka ula fana nga idumilana nga Girigiringa Abu, ");
INSERT INTO kwd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma gila ka kwatea nga ebeeba na profet la Aesea 'e giria mai na'o. Ma ngaia 'e fu'ea, maka daria lefu la Aesea 'e giria maka fata suria nga Kraes, ");
INSERT INTO kwd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nga Anoe 'ola ana God 'e sifo fafi nau, tofuna ngaia 'e firi nau fana 'aku kwairii suria nga Kwairiinga Le'a lo'oo fana ta'a gila galafa. Mai ngaia ka kwate nau mai fana 'aku foulange'enia fana ta'a gila gauga, 'agila arube. Ma 'aku gulaa nga ta'a na maaga 'e boko. Ma 'aku rubea nga ta'a na wane gila 'ame aga le'a aaga. ");
INSERT INTO kwd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma nau 'aku kwairii 'ania, alata ngaia 'e nigi no'o mai fana nga Alafa 'ani fa'amooria nga ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Alata la Jisas ngaia 'e idumia 'e sui, ngaia ka fu'e fafia nga ebeeba lo'oo, maka orite'enia fana wane ne'e aga suria 'ifi ni fo'anga na Jiu, maka to'oru 'i wado 'ani kwaifa'ananau. Ma nga ta'a te'efou na gila to'oru 'i 'ubulana nga 'ifi ni fo'anga na Jiu lo'oo, gila ka bubu totonga'i ana. ");
INSERT INTO kwd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma la Jisas ka etaa nga alafuunga no'o faga 'ilo'oo, “Nga Gigiringa Abu lo'oo, 'e lau kwala'imori no'o tala'ina lo'oo, moru longoa 'inau ku idumia kau famooru.” ");
INSERT INTO kwd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma nga ta'a te'efou gila ka 'alefo ba'ita tofuna alafuulana 'e le'a. Sui ma gila ka fata 'ilo'oo, “'Ilo'oo ma wela ala Josef 'amoe lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma la Jisas ka fata 'ilo'oo faga, “Nau ku su'asuria amooru tamoru fata 'ilo'oo fagu, ‘Wane ni gulanga 'oi gulaa'o madi talamu.’ Ma tamooru fata 'ilo'oo la'u fagu, ‘'Oi agea madi 'ubulana fanua amu ni 'ola laka'u meru lolongoa 'i'oo agea mai 'ubulana fanua 'i Kapaneam.’” ");
INSERT INTO kwd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui ma la Jisas ka fata 'ilo'oo la'u, “Nau ku iiria nga 'ola kwala'imori famooru, ngaia 'e 'ato fana 'agila iiri ba'ita na profet 'i 'ubulana fanua aana 'i talana. ");
INSERT INTO kwd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nau ku iiria la'u mola famooru, ni geni 'e aula 'i Israel na'a gila nao, gila to'oru na alata no'ona la Elaeja nga profet 'e to'oru ai. Ma alata laka'u nga ne'u 'ame to'o suria oru farisi ma ono singari, ma nga molo'unga ba'ita ka riu la'u na fanua adauru te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma God 'e 'ato 'ani kwatea la'u mola la Elaeja te'ana ni me'e nao na'a gila 'i Israel. Tafe'ua, ma ngaia 'e kwatea mola la Elaeja te'ana te'e me'e nao na'a ngaia me'e noni 'i Israel 'amoe na'a ngaia 'e to'oru na fanua 'ubulana gule'e lefu 'i Saedon. ");
INSERT INTO kwd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma nga ta'a 'e aula 'i Jiu 'i Israel na gila kuu, na alata la Elaesa ngaia 'e profet. Mai ngaia 'ame gulaa mola ta wane aga. Te'e la Neman nga wane na ngaia nga wane 'i Israel 'amoe ne'e leka mai fa'asia fanua 'i Siria na'a la Elaesa 'e gulaa.” ");
INSERT INTO kwd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma alata gila longoa ni 'ola lo'oori, nga ta'a te'efou 'ubulana nga 'ifi ni fo'anga na Jiu, gila ka ogaria. Gila ogaria tofuna la Jisas 'e iiria God te'e boonia mola nga te'e ta'a na gila 'ame Jiu, mai gila ka 'amoe. ");
INSERT INTO kwd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lo'oo gila tata'e, ma gila ka taria la Jisas fa'asia nga fanua lo'oo. Ma gila ka taria la Jisas fana gouna 'ato na'a nga fanua aaga ngai ai, fana 'agila geua la Jisas 'i wado, 'ani mae. ");
INSERT INTO kwd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tafe'ua, ma ngaia 'e leka mola 'i laloana nga ogunga no'ona, maka leka mola fa'asiga. ");
INSERT INTO kwd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sui ma la Jisas bi'i leka fani Kapaneam, te'e fanua na gule'e lefu 'i Galili. Ma alata na Sabat, gani na mamalonga fana ta'a 'i Jiu, ngaia ka kwaifa'ananau fana ta'a no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma nga ta'a na gila ogu mai te'ana 'i 'ubulana 'ifi ni fo'anga na Jiu, gila 'alefo ba'ita na kwaifa'ananaunga aana, tofuna la Jisas 'e alafuu 'ania tegelangaa fa'asia God. ");
INSERT INTO kwd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma te'e wane na'a adalo 'e bo'ea, ngaia 'e to'oru la'u 'i no'ona. Adalo laka'u 'e o'omae ba'ita 'ilo'oo mai fana, ");
INSERT INTO kwd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“La Jisas wane 'i Nasaret, nau ku su'amu 'i'oo nga Wane Abu ana God. 'Olataa na 'i'oo siria 'ani agea ameeru? Bala 'i'oo leka mai fana ngada lameeru ta'ua lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","La Jisas ka beloa nga adalo lo'oo, maka 'ilo'oo, “'Oi noto, moko ru'u mai maa fa'asia wane lo'oo.” Ma nga adalo lo'oo ka to'osia wane lo'oori 'i wado 'i maana ogunga lo'oori, maka ru'u no'o mai fa'asia. Ma nga wane lo'oori 'ame mala mola. ");
INSERT INTO kwd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nga ta'a na'a gila ogu 'i no'ona, gila 'alefo ba'ita, ma gila ka orisiga kwaiiriu, ma gila ka 'ilo'oo, “Nga kwaifa'ananaunga 'utaa ne'e 'ilo'oo? Wane lo'oo 'e belote'enia nga adalo 'ania tegelangaa, ma gila ka 'akwa te'efou no'o 'i maa!” ");
INSERT INTO kwd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nga kwairiinga suria la Jisas ka tagafia 'ubulana fanua te'efou ri'itana gule'e lefu lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sui ma la Jisas ka leka no'o fa'asia nga 'ifi ni fo'anga na Jiu, maka leka no'o 'i 'ifi ala Saemon. Nga fungona geni la Saemon, 'e fii 'ania noni'ago'agonga na alata no'ona. Ma gila ka soea la Jisas fana 'ani gulaa. ");
INSERT INTO kwd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","La Jisas 'e ru'u maka ula 'i gegena furi na noni lo'oo, maka taria noni'ago'agonga lo'oo fa'asia. Ma nga noni lo'oo ka gwari'a no'o, maka tata'e, maka kwatea no'o fangalaa faga. ");
INSERT INTO kwd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma alata sina 'e suu no'o, ma gani na mamalonga fana ta'a 'i Jiu 'e sui no'o, ta'a 'e aula gila ngaria mai nga ta'a nga fiinga kwaitatari 'e tagisiga te'ala Jisas. Ma la Jisas 'e arua nimana fafiga, maka gulaga te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No'ona la'u mola, adalo 'e aula gila ka 'akwa fa'asia ta'a no'ona, ma gila ka o'omae 'ilo'oo, “'I'oo nga Wela ana God.” Ma la Jisas 'e rui totonga'i na nga adalo no'ona gila sia fata mola, tofuna gila su'asuria 'e sui no'o na'a ngaia nga Kraes, nga wane na God 'e firia fana fa'amoorilana ta'a aana. ");
INSERT INTO kwd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'Usugani alata 'e kwa'aria no'o, la Jisas 'e leka no'o fa'asia fanua lo'oo 'i Kapaneam fana te'e lefu 'e aloalo. Ma ta'a gila ka eta no'o fana kwailonga 'ofia. Alata gila daria, gila ka fata 'ilo'oo fana, “'I'oo sia leka mola fa'asia fanua lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tafe'ua, mala Jisas 'e fata 'ilo'oo faga, “God 'e kwate nau mai fana foule'enilana nga Kwairiinga Le'a lo'oo. Ngaia 'e le'a 'aku leka la'u mola 'ubulana tani fanua ngaa'i la'u, fana 'aku foule'enia na'a God 'e ba'ita fafia ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma la Jisas ka kwairii 'ania nga Kwairiinga Le'a lo'oo 'ubulana ni 'ifi na fo'anga na Jiu na gule'e lefu 'i Judea. ");
INSERT INTO kwd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Te'e fe'e gani ngaa'i, la Jisas 'e ula maka kwaifa'ananau 'i gegena asi 'i Genesaret, ma ta'a 'e aula gila su'usu'u mai te'ana fana longolana fatalana God. ");
INSERT INTO kwd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma ngaia ka agasia rua baru na ni wane ni deenga gila 'akwasia mola 'i maritakwa alata gila ta'umia nga fulai aaga. ");
INSERT INTO kwd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma la Jisas ka fane 'i 'ubulana baru ala Saemon, maka iiria ana fana 'ani 'idu sisika fa'asia 'i su'e. Ma la Jisas ka to'oru 'i 'ubulana baru no'ona, ma 'e bi'i fa'ananaua nga ta'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma alata 'e kwaifa'ananau 'e sui mola, ngaia ka fata 'ilo'oo fala Saemon, “Mooru 'idu la'u kau fana lefu 'e loboa, sui ma moru ala 'ania nga fulai amooru fana 'amoru daua ii'a. ");
INSERT INTO kwd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma la Saemon ka lamadu'aa 'ilo'oo, “Wane ni kwaifa'ananaunga, 'imeeru meru kweo no'o suria logo la'ula'u lo'oo, ma meru 'ame daua no'o ta ii'a. Tafe'ua, suria fatalamu, nau taku ala no'o 'ania fulai lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma alata gila ala 'ania fulai laka'u, nga fulai laka'u ka fongu no'o na ii'a, ma nga fulai galangi ka mou no'o. ");
INSERT INTO kwd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sui ma gila ka lalofia ni wane ni kwaimaanga aaga 'ubulana nga baru ngaa'i la'u, fana 'agila leka mai, ma gila kwaibooni aga. Sike'ena gila nigi mai, ma gila fa'afonua rua baru lo'oo 'ania ii'a leleka ma 'e galangi ka kuruu no'o. ");
INSERT INTO kwd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Alata la Saemon Pita 'e agasia ni 'ola lo'oori, ngaia 'e bobouruuru 'i 'a'aena la Jisas, maka fata 'ilo'oo, “Alafa leka kau fa'asi nau! Nau nga wane ku ria.” ");
INSERT INTO kwd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","La Saemon fe'enia ni ta'a na gila to'oru la'u 'i lo'oo gila ka 'alefo ba'ita na ii'a 'e aula na'a gila daua. ");
INSERT INTO kwd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma nga rua wane na gala taunga'i fe'enia la Saemon, na latagaa'a la Jemes ma la Jon, nga rua wela ala Sebedi gala ka 'alefo ba'ita la'u mola. Ma la Jisas ka fata 'ilo'oo fala Saemon, “'Osia ma'u mola. Mai na'o 'i'oo dee na ii'a, tafe'ua ma 'e 'ita tala'ina maka ori 'ala'a, 'i'oo to'o deea la'u nga ta'a fana 'agila fito'o ala God.” ");
INSERT INTO kwd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma alata gila nigi no'o 'i su'e, gila ka 'akwasia no'o nga baru aaga suria oone, ma gila ka 'akwasia ni 'ola aaga te'efou, ma gila ka leka no'o fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te'e fe'e gani ngaa'i, la Jisas 'e to'oru 'i 'ubulana te'e fanua no'ona, ma te'e wane 'e kuu, 'e to'oru la'u mola no'ona. Alata ngaia 'e agasia la Jisas, ngaia 'e leka mai te'ana, maka bobouruuru 'i na'ona, maka laeta'a maka fata 'ilo'oo, “Alafa, lauta 'i'oo 'uri, moko gulaa nau mai.” ");
INSERT INTO kwd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Ilo'oo la Jisas 'e tagwala kau nga nimana, maka galo 'i nonina wane lo'oo, maka fata 'ilo'oo, “Kiu, nau ku 'uri. Labemu 'e gwari'a no'o.” Ma 'afe'aferu mola 'i burina me'e fatanga lo'oo la Jisas 'e iiria, nga kuu lo'oo ka sigi no'o fa'asia wane lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sui ma la Jisas ka bu'ota'i kau te'ana nga wane lo'oo maka fata 'ilo'oo fana, “'Osia kwairii la'u te'ana te'efuta wane na 'ola lo'oo. Tafe'ua, ma to'o leka madi te'ana nga fataabu, moko faate'enia nga labemu fana, 'ani su'asuria na'a 'i'oo gwari'a no'o. Sui moko kwatea nga tabonga na la Moses 'e iiria fana ta'a te'efou 'agila fa'ato'oa na'a nga kuu lo'oo 'i labemu 'e sigi no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tafe'ua, ma nga kwairiinga suria ni 'ola lo'oo la Jisas 'e agea 'e tagafia no'o lefu 'e aula, ma ta'a 'e aula gila ka leka mai te'ana fana longolana kwaifa'ananaunga aana ma fala Jisas 'ani gulaga la'u fa'asia nga fiinga aaga. ");
INSERT INTO kwd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma alata 'e aula, la Jisas 'e leka mola fa'asia ta'a fana lefu aloalo fana fo'anga. ");
INSERT INTO kwd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te'e gani ngaa'i, alata la Jisas 'e kwaifa'ananau 'ubulana te'e 'ifi, tani Farasii fe'enia ta'a ni kwaifa'ananau na Tagi ala Moses, gila to'oru la'u mola 'i no'ona. Gila leka mai fa'asia fanua 'e aula na gule'e lefu 'i Galili fe'enia 'i Judea, ma 'i Jerusalem. Ma nga tegelangaa ana God 'e to'oru fe'enia la Jisas, fana gulalana ta'a na'a gila fii. ");
INSERT INTO kwd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma tani wane ngaa'i gila ngaria mai te'e wane nga nonina 'e mae, gila ngaria mai 'i fofona nga futa'i. Gila ka di'ai tegela'a fana ru'unga 'i 'ifi fe'enia, fana 'agila arua 'i 'a'aena la Jisas fana 'ani gulaa. ");
INSERT INTO kwd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tafe'ua, ma tofuna nga ogunga lo'oo 'e ba'ita 'e iiki, ngaia 'e 'ato no'o faga fana ngarilana kau te'ala Jisas. Sike'ena gila ka ngaria wane lo'oori, ma gila fane fe'enia 'i fofona 'ifi, ma gila 'ulasia me'e kwakwa ba'ita. Sui ma gila fa'asifoa wane lo'oo 'i fofona nga fufu te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Alata la Jisas 'e agasia nga fito'onga aaga ngaia ka fata 'ilo'oo fana wane lo'oo nonina 'e mae, “Alakwa agu nau ku 'olafanataa no'o na rianga amu.” ");
INSERT INTO kwd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma Farasii fe'enia ta'a kwaifa'ananaunga na Tagi ala Moses gila ngu'u ngu'u moo no'o laloaga, ma gila ka fata 'ilo'oo, “Fu'u wane! Wane 'utaa lo'oo 'e fata 'ilo'oo? Ngaia 'e fa'atooto'ome'enia fe'enia God. Ngaia 'ato fana wane 'ani 'olafanataa na rianga. Te'e God ne'e su'asuria 'ani 'olafanataa na rianga.” ");
INSERT INTO kwd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","La Jisas 'e su'a mola na manatanga 'ubulana mangoga, maka fata 'ilo'oo faga, “Moru sia manata 'ino'ona la'u.” La Jisas 'e su'aai na'a gila tagoto'o te'e God na'a te'e gulaa no'o wane. ");
INSERT INTO kwd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngaia ne'e fata 'ilo'oo, “Lauta 'inau ku fata 'ilo'oo, ‘Rianga amu, nau ku 'olafanataa no'o ai,’ me'e 'ato 'ani agasia te'efuta 'ola. Lauta 'inau ku iiria 'ilo'oo, ‘Tata'e, moko leka,’ ");
INSERT INTO kwd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","nau ku bi'i faate'enia famooru na 'inau, Wela na Wane, nau ku to'o na tegelangaa lo'oo 'i wado fana 'aku 'olafanataa na rianga.” Sui ma la Jisas ka fata 'ilo'oo fana wane laka'u labena 'e mae, “Nau ku iiria famu, tata'e no'o, ngaria nga futa'i amu, moko leka no'o 'i fanua.” ");
INSERT INTO kwd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te'e alata no'ona mola, wane no'ona 'e tata'e 'i na'oga, 'e ngaria nga futa'i aana, maka ori no'o 'i fanua aana fe'enia baatafengaa ba'ita fana God. ");
INSERT INTO kwd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma ta'a te'efou gila 'alefo ba'ita no'o, ma gila ka baatafea God suria gila agasia 'ola ba'ita God 'e agea. ");
INSERT INTO kwd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Buri ni 'ola lo'oo, la Jisas 'e leka la'u kau 'i maa, maka agasia la Lifae, nga wane ni ngarilana bata na takisi, 'e to'oru na lefu ne'e taunga'i ai. La Jisas ka fata 'ilo'oo fana, “'Oi leka mai fe'eni nau.” ");
INSERT INTO kwd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","La Lifae 'e tata'e, maka 'akwasia ni 'ola aana te'efou, maka leka no'o fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sui ma la Lifae ka agea te'e fafangalaa ba'ita fala Jisas 'i 'ifi aana. Ma alata lo'oo la'u mola, ta'a 'e aula fana ngarilana bata na takisi fe'enia tani ta'a ngaa'i la'u, gila keto fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tani Farasii ma ta'a ngaa'i ni kwaifa'ananaunga na Tagi ala Moses gila ka ogaria, ma gila ka fata 'ilo'oo fana fufu'iwane ala Jisas, “Ngaia 'ame to'omia 'ani keto maka go'u fe'enia ta'a fana ngarilana bata na takisi ma ta'a ngaa'i 'e ria 'ino'ona.” ");
INSERT INTO kwd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","La Jisas 'e fata faga 'ilo'oo, “Ta'a na'a gila 'ame fii, gila 'ame siria wane ni gulanga, tafe'ua ta'a na'a gila fii, na gila bo'obo'o fana wane ni gulanga. ");
INSERT INTO kwd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau ku 'ame leka mai fana ta'a na gila odo no'o 'agila abulo mai, tafe'ua ma nga ta'a na abulongaa aga 'e ria ngai lo'oo naku leka mai fana laefiilaga fana orite'enilaga te'ana God.” ");
INSERT INTO kwd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tani ta'a ngaa'i gila fata 'ilo'oo fala Jisas, “Alata 'e aula nga fufu'iwane ala Jon gila abu keto fana fo'anga, ma nga fufu'iwane na Farasii gila 'ino'ona la'u mola. 'Utaa na fufu'iwane amu gila keto ma gila go'u mola?” ");
INSERT INTO kwd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","La Jisas 'e lamadu'aa maka fata 'ilo'oo, “'Ame to'omia ta'a na'a gila to'oru na fafangalaa na afolonga 'agila abu keto mola. Suria na alata alakwa fooru ngaia mola 'ua fe'eniga, ta'a tagila aile'a. ");
INSERT INTO kwd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tafe'ua, ma alata te'e nigi mai tagila ngaria nga alakwa fooru fa'asiga. Sike'ena ma tagila bi'i abu keto bu'i, tofuna na gila kwaimanadai.” ");
INSERT INTO kwd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sui ma la Jisas ka fata 'ania tarifulaa faga maka 'ilo'oo, “Ngaia 'ame to'omia fana 'amoru ngaria ta sisii'i ruu fooru fana bobolo'ulana nga ruu ne'e biri no'o. Lauta moru agea ni 'ola lo'oo, nga sisii'i ruu fooru lo'oo te'e kasia no'o ruu 'ua lo'oo, tofuna ruu fooru ngaia 'e rugurugula 'i burina nga ta'umilai, ma ruu fooru 'ame aga le'a fe'enia nga ruu 'ua lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma moru su'a la'u mola ai, ngaia 'e 'ato fana te'efuta wane 'ani arua nga waeni fooru 'i 'ubulana wa'i 'ua na susungana nanigot, tofuna wa'i 'ua lo'oo 'ame ngasi. Lauta ngaia 'e agea 'ola 'ilo'oo, alata nga waeni lo'oo 'e fane mai, ngaia te'e kasia no'o wa'i 'ua lo'oo, ma waeni lo'oori te'e akiri, ma wa'i lo'oo 'e ria no'o. ");
INSERT INTO kwd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngaia na ta'a 'ani arua mola waeni fooru 'ubulana nga wa'i fooru. ");
INSERT INTO kwd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Alata wane 'e go'ufia nga waeni 'ua, ngaia 'e 'ato 'ani siria nga waeni fooru. Suria ngaia te'e fata 'ilo'oo, ‘Nga waeni 'ua lo'oo go'ufilai 'e le'ale'a moo'o no'o.’” ");
INSERT INTO kwd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te'e fe'e Sabat ngaa'i, gani na mamalonga, la Jisas fe'enia wane na fufu'iwane aana gila leleka, ma gila ka leka 'ubulana te'e langa'a na witi. Ma alata na gila leka no'ona, fufu'iwane aana gila ka 'oia nga fufungui 'ola ai ma gila ka 'alagaa 'i nimaga, ma gila bi'i 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma alata ta'a na Farasii gila agasia, gila ka fata 'ilo'oo, “'Ola lo'oo moru agea 'e mousia no'o Tagi ala Moses, tofuna moru 'oia nga witi ma moru ka alagaa 'i nima moru, nga 'ola ta'ua taunga'inga na Sabat.” ");
INSERT INTO kwd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","La Jisas ka orisiga 'ilo'oo, “Nau ku su'aai mooru moru idumia Girigiringa Abu na 'ola laka'u la Defete ma nga fufu'iwane aana gila agea mai na'o. Ma alata no'ona, la Defete fe'enia ni wane aana gila molo'u, ");
INSERT INTO kwd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ma ngaia ka leka 'ubulana 'Ifi na God, ma alafa ni suuabunga ka kwatea beret gila fa'aabua fana God fana la Defete. Ma la Defete 'e 'ania nga beret lo'oori, maka kwatea gula ngaa'i fana ni wane laka'u aana, ma gila ka 'ania no'o. Tafe'ua, ma nga tagi 'e alamia mola fana te'e fataabu na God na gila mola fana 'anilai.” ");
INSERT INTO kwd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sui mala Jisas ka fata 'ilo'oo, “Nau, nga Wela na Wane, nau ku to'o na tegelangaa fana 'aku iiria 'ola fana ta'a 'agila agea mola te'efuta 'ola na gani lo'oo na mamalonga.” ");
INSERT INTO kwd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma te'e Sabat ngaa'i, la Jisas 'e leka 'ubulana 'ifi ni fo'anga na Jiu maka kwaifa'ananau. Ma te'e wane ngaa'i la'u 'i no'ona nima gula le'a aana 'e mae. ");
INSERT INTO kwd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma tani wane ni kwaifa'ananaunga na Tagi ala Moses ma ni Farasii gila to'oru la'u mola 'i no'ona, ma gila ka aga aga lauta la Jisas 'ani gulaa wane lo'oo na Sabat suria gila siria fatanga fafia la Jisas. Lauta ngaia 'e gulaa wane lo'oo, ma gila siria 'agila fata maana la Jisas tofuna ngaia 'e mousia Tagi ala Moses na gulanga, 'ola lo'oo gila manata suria 'ilaka'u nga taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma la Jisas 'e su'a mola na manataga, maka fata 'ilo'oo fana wane lo'oo nimana 'e mae, “Tata'e mai, moko ula 'i na'ona ta'a lo'oo te'efou.” Ma wane lo'oo 'e tata'e maka ula no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma la Jisas ka fata 'ilo'oo fana ni Farasii ma ni wane kwaifa'ananaunga na Tagi ala Moses, “Nau ku orisi 'amooru madi, 'olataa na'a tagi adauru 'e alamia fana 'aguru agea na gani na mamalonga? Ngaia 'e alamia agelana 'ola 'e le'a, 'amoe ma agelana 'ola 'e ria? Ngaia 'e alamia nga fa'amoorilana wane, 'amoe ma kwa'ilana wane?” ");
INSERT INTO kwd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","La Jisas 'e fata 'ilo'oo 'e sui, ma ngaia ka aga kwaiiriu faga, maka fata 'ilo'oo fana wane lo'oo nimana 'e mae, “Tagwala nimamu.” Te'e alata no'ona mola, ngaia 'e tagwala kau nimana, ma nimana 'e le'a no'o. ");
INSERT INTO kwd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma alata lo'oo gila agasia, gila ka ogaria ba'ita, ma gila ka alafuu oguogu fana 'olataa 'agila agea ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te'e fe'e alata ngai la'u, la Jisas 'e fane fana gouna me'e busu fana 'ani fo'a. Fe'e logo la'ula'u no'ona, ngaia 'e fo'a te'ana God. ");
INSERT INTO kwd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'Usugani no'ona, ngaia 'e soea mai fufu'iwane aana te'ana, maka firia akwale'e wane ma ruaai, maka fa'alataga 'ania Wane ni Kwairiinga. ");
INSERT INTO kwd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nga lataga: la Saemon na'a la Jisas 'e fa'alataa 'ania la Pita, mala Andru nga wane gala futa aana, mala Jemes, mala Jon, mala Filip, mala Batolomiu, ");
INSERT INTO kwd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mala Matiu, mala Tomas, mala Jemes wela ala Alfeas, mala Saemon nga wane na ta'a 'i Jiu laka'u gila siria 'agila taria ta'a 'i Rom fa'asia 'i Israel, ");
INSERT INTO kwd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mala Judas nga wela ala Jemes, mala Judas Iskariot nga wane na'a ngaia te'e 'olonge'enia la Jisas fana marimae aana. ");
INSERT INTO kwd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","La Jisas 'e sifo mai fa'asia gouna me'e busu no'ona fe'enia nga akwala ma rua Wane ni Kwairiinga laka'u aana, maka ula na lefu 'e ote fe'enia nga ogunga ba'ita lo'oori na ta'a ni lelekanga aana. Ma ta'a 'e aula la'u mola na'a gila leka mai fa'asia gule'e lefu 'i Judea, fe'enia fanua ba'ita 'i Jerusalem, ma nga fanua 'i Taea ma 'i Saedon na'a gila to'oru suria asi, gila leka la'u mola no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gila leka mai fana longolana la Jisas, ma fala Jisas 'ani gulaga fa'asia nga fiinga aaga. Ma ta'a na'a gila to'o na adalo gila leka la'u mai te'ala Jisas 'ani gulaga. ");
INSERT INTO kwd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma ta'a te'efou gila ka 'aferu kau fana 'agila gema to'ona la Jisas, tofuna nga tegelangaa 'e leka mai fa'asia fana gulalana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","La Jisas 'e aga kau fana ta'a ni leleka aana maka fata 'ilo'oo, “Aile'anga famooru ta'a na'a mooru galafa, tofuna God 'e ba'ita fafi 'amooru. ");
INSERT INTO kwd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aile'anga famooru ta'a na'a mooru molo'u na alata lo'oo, tofuna tamooru bote la'u. Aile'anga famooru ta'a na'a mooru aani na alata lo'oo tofuna tamooru 'osa la'u. ");
INSERT INTO kwd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aile'anga famooru alata nga ta'a gila aga mani amooru, ma gila gulete'eni 'amooru, ma gila ka fata ngada 'amooru, ma gila iiri ngadaa lata mooru tofuna moru lo'o suri nau, nga Wela na Wane. ");
INSERT INTO kwd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Moru malale'a, ma moru ka olo 'ania aile'anga ba'ita alata na'a ta'a gila age 'ino'ona amooru, suria nga foforinga ba'ita 'e sasari famooru 'i Langi. Nau ku iiria 'ola lo'oo suria ta'a ni wawarifuga gila agea no'o ni 'ola 'ame le'a na profet mai na'o. ");
INSERT INTO kwd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Tafe'ua, te'e ria tala'esia no'o famooru nga ta'a na'a mooru dari'ola'a na alata lo'oo tofuna kwakwaeinga amooru moru to'o ai 'e sui no'o. ");
INSERT INTO kwd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ngaia te'e ria tala'esia no'o famooru nga ta'a na'a moru bote na alata lo'oo tofuna tamooru molo'u. Ngaia te'e ria tala'esia no'o famooru ta'a na'a moru 'osa na alata lo'oo, tamoru kwaimanadai, ma tamoru aani. ");
INSERT INTO kwd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngaia te'e ria tala'esia no'o famooru alata na'a ta'a gila iiri ba'ita amooru, tafe'ua nga wawarifuga gila agea la'u mola 'ola lo'oo fana ni profet na kotonga.” ");
INSERT INTO kwd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","La Jisas 'e fa'ananauga la'u 'ilo'oo, “Nau ku iiria famooru ta'a na moru lo'oo suria fatalagu, mooru kwaimaange'enia fana nga marimae amooru, ma moru ka age le'a fana ta'a na'a gila aga mani amooru. ");
INSERT INTO kwd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma moru ka fo'asia God, fana 'ani nanamate'enia ta'a na'a gila fata ngada 'amooru, ma moru ka fo'a fana ta'a na'a gila agea ni 'ola 'e ria amooru. ");
INSERT INTO kwd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma lauta ta wane 'e fida 'i babarimu, 'oi alamia 'ani fidaria la'u mola gule'e babari ngaa'i. Ma lauta ta wane 'e ngaria nga ruu amu fana alata na gwari, 'oi alamia 'ani ngaria la'u nga sote amu fana. ");
INSERT INTO kwd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ni dai ne'e kwaisoe amu, kwatea 'olataa ne'e soea amu. Ma lauta ta wane 'e ngaria 'ola na ni 'ola amu, 'i'oo sia soea la'u fana orite'enilai famu. ");
INSERT INTO kwd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Olataa na'a moru siria nga ta'a matari 'agila agea famooru, tamoru agea la'u mola faga. ");
INSERT INTO kwd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ma lauta moru kwaimaa mola fana ta'a na gila kwaimaa famooru, moru sia ngaria mola ta foforinga. 'I'oo su'aai gwa'a ta'a 'e ria gila kwaimaa la'u mola fana ta'a na'a gila kwaimaa faga. ");
INSERT INTO kwd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma lauta moru age le'a mola fana ta'a na'a gila age le'a famooru, 'ato amoru ngaria la'u ta foforinga. Suria ta'a 'e ria gila age 'ino'ona la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma lauta moru kwate mola fana ta'a na tagila lamadu'aa famooru, 'ato no'o amooru ngaria la'u ta foforinga. 'I'oo su'aai na'a ta'a 'e ria gila age 'ino'ona la'u mola fana ta'a abulongaa aaga 'e ria, fana 'agila lamadu'aa la'u mola faga. ");
INSERT INTO kwd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tafe'ua ma tamoru kwaimaa fana marimae amooru, ma tamooru age le'a la'u faga, ma lauta moru kwatea te'efuta 'ola, mooru sia mamania la'u fana du'alai. Lauta moru age 'ilo'oo, tamooru ngaria nga foforinga ba'ita, ma nga abulongaa 'amooru te'e faate'enia na 'i mooru fu'i ru'uru'u ana God ne'e 'inato'o maka ba'ita 'e iiki. Suria God 'e kwaimaa le'a fana ta'a ne'e ria ma ta'a na'a gila 'ame aile'a fafia 'olataa na'a God 'e agea faga. ");
INSERT INTO kwd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Moru kwaimaa ma mooru laeta'afiia ta'a 'ilaka'u nga Ma'aa moru 'i Langi 'e laeta'afii 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mooru sia sufaa mola te'efuta wane ngaa'i, fa'asia God ta sufaa 'amooru la'u. Ma moru sia kwatea mola nga kwa'ikwa'inga fana ta wane ngaa'i, fa'asia God ta kwatea nga kwa'ikwa'inga famooru. Moru 'olafanataa la'u mola na rianga na wane ngaa'i ne'e agea amooru, ma God te'e 'olafanataa na rianga amooru. ");
INSERT INTO kwd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Moru kwatea ni 'ola fana ta'a, ma God te'e kwate la'u famooru. Ma God te'e kwatea nga kwakwatenga ne'e 'ilaka'u wane laka'u 'e fa'afonua nga wa'i ni 'ola ne'e dedea, leleka ma ka fongu maka akiakiri no'o. Ma God te'e kwatea famooru, 'ilaka'u la'u na'a mooru kwate fana nga ta'a matari.” ");
INSERT INTO kwd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","La Jisas 'e fata la'u suria tarifulaa faga maka 'ilo'oo, “Nga wane na maana 'e logo, ngaia 'e 'ato 'ani talaia la'u wane ngaa'i na maana 'e logo. Lauta ngaia 'e agea 'ilo'oo, gaa'a te'efou tagala 'esi 'agaa'a 'ubulana kiru. ");
INSERT INTO kwd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'Ilo'oo la'u mola, nga wane ni nanau'olanga mola 'e 'ato 'ani riufia nga wane ne'e kwaifa'ananau ana. Ma lauta nga wane ni nanau'olanga 'e ngaria te'efou na 'ola na'a wane ni kwaifa'ananaunga 'e kwatea fana, ngaia 'e 'ilaka'u no'o nga wane ni kwaifa'ananaunga. ");
INSERT INTO kwd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“'Ola fe'ua 'i'oo to'o na rianga ba'ita, ma 'i'oo to'oru mola fana iirilana wane ngaa'i na'a me'e rianga sisika ngai ana? 'Ola 'e fe'ua 'i'oo agasia nga ngaru ngai 'ubulana maana wane ni futanga amu, mai 'i'oo 'ame agasia mola memede 'ai ba'ita na'a ngaia 'ubulana maamu 'i talamu? ");
INSERT INTO kwd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma 'ola 'e fe'ua 'i'oo fata 'ilo'oo fana wane matari ngaa'i, ‘'I'oo sia agea mola ta 'ola 'e ria.’ Tafe'ua, mai 'i'oo 'ame manata 'abelo mola na rianga ba'ita na'a 'i'oo agea. 'I'oo wane 'i'oo iiria 'ola 'ame to'o. 'Oi 'akwasia madi nga rianga amu. Sui ma to'o bi'i to'omia fana boonilana te'efuta wane ngaa'i fe'enia nga rianga aana.” ");
INSERT INTO kwd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","La Jisas ka fata la'u 'ania te'e tarifulaa faga maka 'ilo'oo, “Nga 'ai ne'e le'a, ngaia 'e 'ato 'ani fungu 'ania lode ai 'e ria. Maka 'ilaka'u la'u mola, nga 'ai ne'e ria, 'e 'ato 'ani fongu 'ania lode 'ai ne'e le'a. ");
INSERT INTO kwd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dauru goru su'aai te'efou, lode 'ai te'e faate'enia ngaia fa'asia 'ai ngai taa. Ngaia 'e 'ato fana wane 'ani 'ania lodona 'ai ni 'anilai fa'asia 'ai 'e ngangala'a. ");
INSERT INTO kwd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma nga wane 'e le'a 'e agea 'ola 'e le'a suria nga manatale'e wane 'e wataga. Ma wane ngaia 'e ria 'e agea ni 'ola 'e ria suria manatale'e wane 'e biribiri'a. Nga 'ola na ngaia 'e to'oru 'i 'ubulana nga manatalana wane, ngaia ne'e ru'u mai 'ania fatalana.” ");
INSERT INTO kwd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“'Utaa na'a, alata moru alafuu fe'eni nau, mooru fa'alataa nau 'ania ‘Alafa’, tafe'ua moru 'ame agea mola 'ola 'inau ku iiria famooru? ");
INSERT INTO kwd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nga wane ni dai ne'e leka mai te'agu, maka longoa nga fatalagu, maka lo'oo suria, nau taku faate'enia famooru nga fito'onga aana, ma to'orunga aana. ");
INSERT INTO kwd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ngaia 'e 'ilaka'u nga wane laka'u 'e launge'enia 'ifi aana, ngaia 'e takwea fana bou ai laloana fou. Nga alata nga ne'u 'e to'o, ma ka'o 'e afe mai, ngaia 'e 'ato 'ani ngadaa, suria ngaia 'e launge'enia 'ifi aana laloana fou. ");
INSERT INTO kwd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma wane ne'e longoa fatalagu, maka 'ame lo'oo suria, 'e 'ilaka'u wane ne'e launge'enia 'ifi aana fofona oone, 'ame takwea bou ai 'ani sifo maka ngasi. Alata ka'o 'e afe mai, maka to'o na 'ifi lo'oori aana, 'ifi aana 'e 'esia, maka tagala'i te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Alata la Jisas 'e fa'asuia no'o alafuunga fana ta'a lo'oo, ngaia ka leka no'o fana fanua 'i Kapaneam. ");
INSERT INTO kwd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma te'e wane ngai no'ona, 'e fii ba'ita maka galangi mae no'o. Nga wane lo'oo, ngaia nga wane ni taunga'inga na te'e wane na'ona'o na fununga fa'asia fanua ba'ita 'i Rom. Ma wane na'ona'o lo'oo 'e manata ba'ita na wane ni taunga'inga lo'oo aana. ");
INSERT INTO kwd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Alata wane ba'ita na fununga lo'oo 'e longoa na la Jisas 'e nigi mai, ngaia 'e kwatea ni wane na'ona'o 'i Jiu fana 'agila soea la Jisas 'ani leka mai, fana 'ani gulaa nga wane ni taunga'inga aana. ");
INSERT INTO kwd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Alata gila nigi te'ala Jisas, gila ka fata laeta'a te'ana, ma gila ka 'ilo'oo, “Nga wane ba'ita na fununga lo'oo 'e to'omia no'o fana 'i'oo 'ani kwaibooni na wane ni taunga'inga lo'oo aana, ");
INSERT INTO kwd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tofuna wane ba'ita na fununga lo'oo ngaia 'e kwaimaa 'e iiki fameeru nga Jiu, maka launge'enia te'e 'ifi ni fo'anga fameeru 'i lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mala Jisas ka leka no'o fe'eniga. Ma alata 'e nigi galangia no'o kau nga 'ifi, nga wane na'ona'o na fununga lo'oo 'i Rom ka alea la'u ni wane ni kwaimaanga aana fana 'agila fata 'ilo'oo fana, “Alafa 'i'oo sia 'abelo la'u. Nau ku 'ame to'omia fana 'i'oo 'ani leka mai 'ubulana 'ifi agu. ");
INSERT INTO kwd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma 'inau ku 'ame to'omia fana lekanga kau te'amu. 'Oi iiria mola mai me'e alafuunga, ma nga wane ni taunga'inga agu te'e gwari'a mola. ");
INSERT INTO kwd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau ku su'asuria 'i'oo to'omia mola fana agelana ni 'ola lo'oori, tofuna 'inau la'u mola nga wane ku taunga'i 'i olofana nga ta'a ba'ita, ma kua to'o na ta'a ni fununga na'a gila taunga'i olofana nga ba'itangaa agu. Lauta 'inau ku iiria fana ta wane 'ilo'oo, ‘'Oi leka, ma ngaia 'e leka no'o. Lauta 'inau ku iiria fana ta wane 'ilo'oo, ‘'Oi leka mai, ma ngaia 'e leka no'o mai. Lauta 'inau ku iiria fana ta wane ni taunga'inga agu 'ilo'oo, ‘'Oi agea la'u mola 'ola lo'oo, ngaia 'e agea no'o.’” ");
INSERT INTO kwd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ma alata la Jisas 'e longoa 'ola lo'oori, ngaia 'e 'alefo ba'ita. Ma ngaia 'e abulo, maka fata 'ilo'oo fana wane lo'oo gila leka 'i burina, “Nau ku iiria famooru, nau ku 'ame agasia 'ua ta wane na 'e fito'o agu 'ilo'oo, gwa'a 'ubulana fanua 'i Israel.” ");
INSERT INTO kwd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma ni wane gila ngaria alafuunga no'ona, gila ka ori fana 'ifi na wane ba'ita ni fununga laka'u, ma gila agasia nga wane ni taunga'inga laka'u 'e fii, ngaia 'e gwari'a no'o. ");
INSERT INTO kwd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma 'ame aburu mola 'i burina ni 'ola lo'oori, la Jisas fe'enia nga fufu'iwane aana ma ta'a 'e aula la'u mola, gila leka fana te'e fanua gila fa'alataa 'ania 'i Nen. ");
INSERT INTO kwd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma alata 'e nigi galangia maana nga tatafa na fanua lo'oo, te'e ogunga ba'ita lo'oo gila ngaria mai te'e wane 'e mae, ma gila ka ru'u no'o mai 'i maa. Ma wane lo'oo 'e mae, ngaia te'e alakwa momola ana me'e nao lo'oo. Ma nga ogunga ba'ita lo'oo gila ka leka no'o fe'enia fana kwaiatolana. ");
INSERT INTO kwd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma alata lo'oo nga Alafa la Jisas 'e agasia me'e nao lo'oo, ngaia ka kwaimanadai ba'ita fana, maka fata 'ilo'oo fana, “'I'oo sia aani mola.” ");
INSERT INTO kwd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sui ma ngaia ka leka maka gema na nga fufu na wane laka'u 'e mae 'e eeno fofona, ma ta'a lo'oo gila ngaria wane lo'oo 'e mae, gila ka ula aloalo no'o. Sui mala Jisas ka fata 'ilo'oo, “Wela wane lo'oo, nau ku iiria famu, 'oi tata'e!” ");
INSERT INTO kwd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma nga wela wane laka'u ka tata'e no'o, maka eta ka fata no'o. Ma la Jisas ka kwatea no'o fani ga'ia. ");
INSERT INTO kwd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma nga ta'a lo'oo gila agasia 'ola lo'oo, ma gila ka 'alefo, ma gila ka ma'u ba'ita, ma gila ka baatafea God 'ilo'oo, “Te'e profet ba'ita 'e nigi no'o 'i laloadauru. God 'e nigi no'o mai fana kwaibooningaa na ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma nga kwairiinga suria la Jisas ka talo no'o 'i 'ubulana afutana fanua 'ubulana 'i Judea fe'enia nga gule'e lefu ri'itai la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Te'e alata lo'oo fufu'iwane ala Jon gila kwairii te'ana suria nga taunga'ilana la Jisas. La Jon ka soea mai rua wane aana te'ana, ");
INSERT INTO kwd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","maka ale 'agaa'a te'ala Jisas, nga Alafa, 'agala orisia 'ilo'oo, “'Ino'ona ma, 'i'oo no'o na nga Kraes, wane na'a te'e nigi mai lo'oo, 'amoe ma meeru mamania la'u nga wane matari?” ");
INSERT INTO kwd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma alata gala nigi te'ala Jisas, gala ka orisia 'ino'ona, “La Jon wane ni naruabunga 'e ale 'amee'e mai fana orisilamu, ‘'Ino'ona ma, 'i'oo no'o na'a nga Kraes, wane na'a te'e nigi mai, 'amoe ma 'ameeru mamania la'u ta wane ngaa'i matari?’” ");
INSERT INTO kwd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma alata no'ona la'u mola, la Jisas 'e gulaa ta'a 'e fii 'e aula, ma ngaia ka belote'enia nga adalo fa'asia nga ta'a lo'oo, maka gulaa nga ta'a maaga 'e boko, ");
INSERT INTO kwd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ngaia na la Jisas ka fata 'ilo'oo fagaa'a, “Ori kau, ma molo kwairii te'ala Jon suria ni 'ola na'a molo agasia ma molo ka longoa tala'ina lo'oo. Ta'a maaga 'e boko gila aga no'o. Ma ta'a 'a'aega 'e mae gila ka leka no'o. Ma nga ta'a na'a kuu 'e tagisiga, gila ka gwari'a no'o. Ma ta'a na'a aringaga 'e boko gila ka longo no'o. Ma ta'a na'a gila mae, gila ka moori la'u mola. Aia, ma nga Kwairiinga Le'a lo'oo, nau ku kwairii no'o 'ania fana ta'a galafa. ");
INSERT INTO kwd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","La God te'e nanamate'enia nga ta'a te'efou na'a gila 'ame rugasia fito'onga aaga agu tofuna ni 'ola lo'oo nau ku agea.” ");
INSERT INTO kwd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'I burina rua wane na fufu'iwane ala Jon gala ori mola, la Jisas ka eta no'o fana alafuunga suria la Jon fana ta'a na gila ogu 'i no'ona maka 'ilo'oo, “Na alata moru leka te'ala Jon 'ubulana gule'e lefu langalanga, 'olataa na moru leka fana agasilai no'ona? Te'efuta wane na'a manatanga aana 'ame ngasi 'e 'ilaka'u mola nga tatakana lage na iru 'e 'asu kwairiu ai? 'Amoe! La Jon ngaia wane 'ino'ona 'amoe. ");
INSERT INTO kwd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Ino'ona ma 'olataa na'a moru leka fana agasilai? Nga wane ne'e ru'ufia me'e ruu ba'ita forilai 'e iiki? 'Amoe! Suria ta'a lo'oo gila ru'ufia ruu 'ino'ona, gila to'oru mola 'ubulana 'ifi 'e le'a na Kiingi. ");
INSERT INTO kwd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mooru kwairii mai fagu 'olataa na'a moru leka fana agasilai? Nga profet? Kiu! Ngaia na profet kwala'imori! Mai ngaia 'e riufia no'o ni profet mai na'o te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","La Jon laka'u gila giri suria 'ubulana Girigiringa Abu na alata God 'e fata maka 'ilo'oo, ‘Aga madi, nau taku kwatea kau nga wane ni ngari alafuunga agu 'i na'omu, fana 'ani sasari agau na ta'a famu.’” ");
INSERT INTO kwd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","La Jisas ka fata la'u 'ilo'oo, “Nau ku iiria famooru, la Jon 'e ba'ita 'e riufia nga ta'a te'efou na gila futa mai 'ubulana mola gari te'efou lo'oo. Tafe'ua, nga ta'a na'a gila sisika 'ubulana nga foufoula la God, gila ba'ita 'e iiki maka riufia la Jon.” ");
INSERT INTO kwd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ta'a lo'oo te'efou na'a gila longoa fatalana, ma nga ta'a na gila ngaria bata na takisi, alata gila longoa ni 'ola lo'oo, gila bi'i su'asuria te'e falafala na God ne'e odo maka kwala'imori, tofuna gila abulo mai fa'asia rianga aaga 'i na'o alata la Jon 'e naruabu aga. ");
INSERT INTO kwd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma ni Farasii fe'enia ta'a ni kwaifa'ananaunga na Tagi ala Moses, tofuna na'a gila ma'asiri fana abulongaa fa'asia rianga ma nga naruabunga ala Jon, gila 'ame siria la'u mola nga lo'onga suria nga kwaisiriinga na God faga. ");
INSERT INTO kwd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma la Jisas ka fata la'u 'ilo'oo faga, “Nau taku fa'atooto fe'enia nga to'oru lamooru ta'a tala'ina lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'Amooru moru 'ilaka'u nga ru'uru'ua sisika laka'u gila ogu 'i maana uusia'a 'ania nga rua fufu'ita'a. Ma gila ka o'omae kwaiiriu fafiga, ‘'Ameeru meru ufia 'au, ma moru 'ame wa'e mola suria. Ma 'imeeru meru nguria ni me'e nguu suria maenga famooru, ma moru 'ame kwaimanadai mola.’ ");
INSERT INTO kwd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'Ilaka'u la'u, alata la Jon wane ni naruabunga ngaia 'e nigi mai, ngaia 'e abu keto, ma 'ame go'ufia no'o ta waeni, mai moru bi'i iiria mola fana ngaia 'e to'o na adalo. ");
INSERT INTO kwd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma alata 'inau, nga Wela na Wane, nau ku nigi mai, nau ku keto, ma kua go'u fe'enia ta'a lo'oo, mai mooru moru fata la'u mola 'ilo'oo, ‘Moru agasia! Ngaia keto 'e ba'ita, maka go'u 'e ba'ita na waeni, ma ngaia ka kwaimaa la'u mola fe'enia ta'a fana ngarilana bata na takisi ma ta'a abulongaa aga 'e ria la'u mola.’ ");
INSERT INTO kwd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tafe'ua, ma ta'a na'a gila lo'o suria fatalana God, gila faate'enia na'a God 'e kwala'imori.” ");
INSERT INTO kwd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te'e wane na Farasii na latana la Saemon, ngaia 'e soea la Jisas fana 'ani keto fe'enia. Ma la Jisas ka leka no'o 'i 'ifi aana, maka to'oru, maka keto no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma te'e noni na'a abulolana 'ame le'a ngaia 'e to'oru la'u mola 'i 'ubulana nga fanua no'ona. Ma alata lo'oo nga noni lo'oori ngaia 'e longoa la Jisas ngaia 'e keto 'i 'ubulana 'ifi na Farasii no'ona, ngaia ka ngaria mai te'e fe'e waiwai lo'oo si'inilai 'e le'a 'e iiki ma nga forilai 'e ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma ngaia ka ru'u 'ubulana 'ifi lo'oo, maka ula mai 'i burina la Jisas suria 'a'aena, maka aani, maka fuloa kafukafuna maana ne'e afe 'i 'a'aena la Jisas. Sui maka 'usua 'a'aena la Jisas 'ania ifuna, maka nono'ia 'a'aena. Sui maka 'irisia no'o fe'e waiwai si'inilai 'e le'a lo'oori 'i fofona 'a'aena la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma alata na'a Farasii laka'u 'e soea la Jisas, ngaia 'e agasia nga 'ola lo'oo, maka manata 'ilo'oo, “Lauta nga wane lo'oo ngaia nga profet, ngaia te'e su'asuria abulolana geni lo'oo, suria geni lo'oo ngaia 'e ria 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma la Jisas 'e su'a mola na manatanga na nga Farasii lo'oo, ma ngaia ka fata 'ilo'oo fana, “Saemon! Te'e 'ola lo'oo nau ku siria 'aku iiria famu.” Ma la Saemon ka 'ilo'oo, “Wane kwaifa'ananaunga, 'oi iiria mai fagu 'ola 'utaa lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","La Jisas ka fata 'ilo'oo fana, “Rua wane gala gania nga bata fa'asia te'e wane. Te'e wane agaa'a 'e gania nga nima tangale'e bata ma wane ngaa'i ka gania nga nima akwale'e bata. ");
INSERT INTO kwd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma ngaia 'e 'ato fagaa'a te'efou 'agala du'ua bata lo'oo, ma nga wane ne'e alamia bata aana fagaa'a ka 'olafanataa te'efou no'o agaa'a. 'Ilo'oo ma, ni dai agaa'a ne'e baole'a 'e iiki, na rua wane lo'oo ngaia 'e kwatea bata lo'oo fagaa'a?” ");
INSERT INTO kwd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma la Saemon ngaia 'e lamadu'aa fana maka 'ilo'oo, “Nau ku madafia nga wane lo'oo 'e ngaria bata 'e aula.” Ma la Jisas ka fata 'ilo'oo, “'Ola fe'ua na lamadu'aanga amu 'e odo no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui mala Jisas 'e bu'ota'i fana nga noni lo'oori, maka fata 'ilo'oo fala Saemon, “'Oi agasia madi nga noni lo'oo. Alata 'inau ku ru'u mai 'ubulana 'ifi amu, 'i'oo 'ame kwatea mola ka'o fagu fana fa'akwarilana 'a'aegu. Tafe'ua, ma ngaia ka narufia 'a'aegu 'ania nga kafukafu na maana, maka 'usua 'ania nga ifuna. ");
INSERT INTO kwd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma 'i'oo 'ame kwalo nau mola 'ania nga nono'i fagu. Tafe'ua, ma noni lo'oo, ngaia 'e 'ita na alata laka'u nau ku ru'u mai 'ifi, ngaia ka 'ame mamalo fana nono'ilana 'a'aegu. ");
INSERT INTO kwd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma 'i'oo 'ame 'irisia mola nga waiwai 'i gougu. Ma noni lo'oo, ne'e 'irisia nga waiwai si'inilai 'e le'a ma forilai 'e ba'ita 'i 'a'aegu. ");
INSERT INTO kwd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngaia na'a, 'inau ku iiria famu, nga kwaimaanga ba'ita lo'oo aana, ngaia 'e faate'enia nga rianga aana ne'e aula ngaia 'e arube te'efou no'o fa'asia. Tafe'ua, ma ni dai na'a rianga aana gila 'olafanataa 'e sisika, nga kwaimaanga aana 'e sisika la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui mala Jisas ka fata 'ilo'oo fana nga noni lo'oo, “Nau ku 'olafanataa no'o na nga rianga amu.” ");
INSERT INTO kwd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma ni wane na'a gila to'oru 'i lo'oori, gila ka ogaria fala Jisas, ma gila ka fata 'ilo'oo 'i laloaga kwaiiriu, “Nga wane 'utaa lo'oo 'e 'olafanataa mola na rianga lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sui mala Jisas ka fata 'ilo'oo la'u fana nga noni lo'oo, “'Oi leka no'o kau. La God 'e kwatea aloalonga famu. La God 'e fa'amoori'o, suria 'i'oo fito'o agu.” ");
INSERT INTO kwd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mai burina ni 'ola lo'oori, la Jisas 'e leka no'o na fanua sisika ma ni fanua ba'ita, ma ngaia ka kwairii 'ania nga Kwairiinga Le'a lo'oo suria na God te'e ba'ita fafia ta'a aana. Ma nga akwale'e wane ma ruaai ni Kwairiinga aana, gila ka leka la'u fe'enia, ");
INSERT INTO kwd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma tani geni ngaa'i na la Jisas 'e belote'enia nga adalo ma nga fiinga fa'asiga gila leka la'u mola. Ma gila na: ni Meri, noni 'i Magdala laka'u la Jisas 'e belote'enia nga fiu adalo fa'asia, ");
INSERT INTO kwd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma ni Joana, nga noni ala Kusa nga wane ba'ita na ta'a na gila taunga'i 'i 'ubulana nga 'ifi ala Herod nga kiingi, ma ni Susana, ma ni geni 'e aula ngaa'i la'u. Ni geni lo'oori na'a gila foria ni 'ola 'ania bata aaga fana kwaibooninga ala Jisas fe'enia fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nga ta'a 'e aula gila ogu mai te'ala Jisas. Gila leka mai fa'asia fanua kwaitatari te'efou. La Jisas ka fata 'ania tarifulaa faga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Te'e wane 'e leka maka tagale'enia 'u'ui 'ola 'ubulana langa'a aana. Ma nga alata 'e tagale'enia 'u'ui 'ola, tani 'u'ui 'ola ngaa'i 'e 'esia suria nga tala ni riunga. Ma nga ta'a gila riufia, ma gila ka uuri'i, ma nga langasi gila ka 'ania la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aia, tani 'u'ui 'ola ngaa'i ne'e 'esia fofona wado 'e foula. Ma nga alata gila bila'o mai, 'e 'afe'aferu mola ma gila ka malonga mola, suria nga wado lo'oo 'ame warisu'a. ");
INSERT INTO kwd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma tani 'u'ui 'ola ngaa'i gila 'esia la'u mola 'i laloana nga kwalo 'abui. Nga kwalo 'abui lo'oo gila ka bila'o mai fe'enia, ma gila a'a no'o fafia 'u'ui 'ola ne'e bila'o lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma tani 'u'ui 'ola ngaa'i ne'e 'esia la'u 'i fofona wado to'o, ma gila ka bila'o, ma gila ka fungu 'ania lode 'ola 'e aula iiki.” Ma la Jisas ka fa'asuia fatalana maka 'ilo'oo, “Lauta ta wane siria 'ani su'a le'a na 'ola lo'oo, ngaia 'ani gwaalongo le'a mai.” ");
INSERT INTO kwd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sui ma nga fufu'iwane laka'u ala Jisas gila ka orisia fana fa'awatagalana tarifulaa lo'oori, ");
INSERT INTO kwd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ma la Jisas ka fata 'ilo'oo, “Alata 'e sui kau, God 'ame fa'awatagaa 'ua 'uta'i na 'i ngaia te'e ba'ita fafia ta'a aana. Tafe'ua, ma tala'ina lo'oo, nga fa'awatagalai lo'oo 'e nigi no'o famooru. Fana ni ta'a ngaa'i la'u, nau ku fata 'ania tarifulaa lo'oo, nau ku sia fa'awatagaa mola ‘Gwa'a gila ka aga, tafe'ua ma gila sia agasia mola 'olataa na'a God 'e agea faga. Ma gwa'a gila fafafulongo, tafe'ua ma gila sia su'a la'u suria alafuunga ala God.’” ");
INSERT INTO kwd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sui la Jisas ka fata la'u mola 'ilo'oo, “Nga fa'afolaasilana nga tarifulaa lo'oo: Nga 'u'ui 'ola lo'oo 'e 'ilaka'u nga fatalana God. ");
INSERT INTO kwd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nga tala ni riunga na'a 'u'ui 'ola gila 'esiga suria, ngaia 'e 'ilaka'u nga ta'a na'a gila longoa fatalana God, ma la Saetan 'e leka mai maka lafua mola alafuunga lo'oo fa'asi mangoga. Ngaia ne'e 'ato 'agila daria mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma wado ne'e foula na'a 'u'ui 'ola gila 'esiga fofona, ngaia 'e 'ilaka'u nga ta'a na'a gila longoa fatalana God, ma gila ka ngaria fe'enia nga aile'anga. Tafe'ua, ma fatalana God 'ame ru'u le'a mola 'ubulana moorilaga. Gila fito'o mola suria te'e alata sisika. Tafe'ua, ma alata nga irito'onga 'e nigi mai, gila 'ame tegela'a mola fana 'agila fito'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nga 'u'ui 'ola ne'e 'e sia na lefu na kwalo 'abui ngai ai, gila 'ilaka'u ta'a na'a gila fafulongo, ma gila ka manata 'abelo 'i suria ni 'ola matari, 'ilaka'u nga dari'olanga aga, ma nga aile'anga tago 'ubulana mola gari te'efou. Ngaia ne'e agea gila 'ame bila'o le'a. ");
INSERT INTO kwd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nga wado to'o, ngaia 'e 'ilaka'u nga ta'a na'a gila longoa fatalana God ma gila ka gonia 'ubulana manatalaga ne'e odo maka le'a. Ngaia na gila dau fafia fito'onga ma gila agea taunga'inga 'e aula ne'e le'a.” ");
INSERT INTO kwd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","La Jisas 'e fata la'u 'ilo'oo, “Te'efuta wane sia lalaua mola nga uunu, maka arua mola 'i olofana nga daoko 'amoe ma olofana furi. Tafe'ua, ma ngaia te'e arua na furi'i lefu ai fana nga wane na'a ngaia 'e ru'u mai 'i 'ifi aana 'ani agasia. ");
INSERT INTO kwd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ngaia ka 'ilo'oo la'u mola. Nga 'olataa na gila na'agonia mai na'o, ta'a tagila su'aai. 'Olataa na gila fa'anagwa mai na'o, ta'a tagila daria.” ");
INSERT INTO kwd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ngaia na'a moru gwaalongo le'a, tofuna God te'e kwatea funi'oonga ma manatanga aana famooru, lauta mooru lo'o suria nga kwaifa'ananaunga agu. Te'efuta wane ni dai na ngaia 'e to'o na nga su'a'olanga sisika suria God, God te'e rudagou ai fana. Tafe'ua, ma ni dai ne'e 'ato 'ani lo'o suria ni kwaifa'ananaunga lo'oo, nga su'a'olanga sisika aana na ngaia 'e to'o ai suria God, God te'e orite'enia fa'asia.” ");
INSERT INTO kwd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Ame aburu mola, ma ga'ia la Jisas fe'enia wane gila futa aana te'efou, gila nigi mai, ma gila ka siria 'agila agasia, tafe'ua ma ngaia 'e 'ato no'o faga fana 'idunga galangia, suria nga ta'a 'e aula gila ogu 'afuia la Jisas na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma te'e wane 'i 'ubulana ogunga lo'oo ka fata 'ilo'oo fala Jisas, “Ni gai'o fe'enia ni wane moru futa, gila ula mola mai 'i maa, ma gila siria agasilamu.” ");
INSERT INTO kwd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mala Jisas ka alafuu faga te'efou 'ilo'oo, “Ni dai na gila longo, ma gila ka lo'o suria fatalana God, gila ne'e 'ilaka'u ga'i nau, ma ni wane meeru futa.” ");
INSERT INTO kwd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te'e alata ngaa'i, la Jisas fe'enia nga fufu'iwane aana, gila ta'e 'i 'ubulana te'e baru, ma ngaia ka fata 'ilo'oo faga, “Dauru goru olofolo madi fana gule'e asi loko'u.” Ma gila ka eta no'o fana 'agila olofolo no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma nga alata gila leka no'o kau, la Jisas 'e eeno mola. Nga alata no'ona mola, nga iiru ba'ita 'e tata'e mai, ma nga bio ka uubu no'o mai maka mo'oi 'ubulana nga baru lo'oo, ma nga baru ba'ita lo'oo 'e galangi ka kuruu no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ma nga fufu'iwane aana gila ka fa'aagaa la Jisas ma gila ka 'ilo'oo, “Alafa! Dauru goru galangi kuruu no'o!” La Jisas 'e tata'e maka fata tegela fana nga iiru ma nga bio lo'oo, ma gila ka lo'o suria, ma nga asi ka aloalo no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui mala Jisas ka fata fana fufu'iwane laka'u aana maka 'ilo'oo, “'Utaa na'a moru 'ame fito'o agu?” Gila ka 'alefo, ma gila ma'u, ma gila ka orisiga kwaiiriu 'ilo'oo, “Wane 'utaa lo'oo no'o? Ngaia 'e fata mola, ma nga iiru fe'enia bio ba'ita, gila ka lo'o mola 'i suria.” ");
INSERT INTO kwd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui mala Jisas fe'enia fufu'iwane aana, gila ka olofolo no'o 'ubulana asi lo'oo leleka ma gila ka nigi na fanua 'i Gerasa, na gule'e asi ne'e nana'i otofana na gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","No'ona la Jisas 'e sifo kau 'i su'e fa'asia nga baru laka'u, ma ngaia ka daria te'e wane fa'asia fanua no'ona. Nga wane lo'oori, nga adalo gila bo'ea, ma ngaia ka 'ame 'afesia no'o ta me'e ruu suria alata 'e aburu no'o mai, ma ngaia 'ame to'oru 'i 'ubulana ta 'ifi. Tafe'ua, ma ngaia to'oru mola 'i 'ubulana nga faaruma, lefu fana kwaiatolana ta'a gila mae. ");
INSERT INTO kwd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ma alata 'e aula 'e sui no'o mai, gila gaua rua 'a'aena ma rua nimana, ma gila ka arua wane fana folonga 'usia. Tafe'ua, ma ngaia 'e mousia mola nga seni lo'oo ma nga adalo lo'oo gila ka talaia no'o kau fana 'ubulana gule'e lefu 'e kwasila. Ma alata ngaia 'e agasia mola la Jisas, ngaia 'e o'omae ba'ita, maka bobouruuru no'o 'i 'a'aena la Jisas. Mala Jisas ka fata 'ilo'oo fana, “Adalo, 'oi ru'u mai maa fa'asia nga wane lo'oo.” Ma wane lo'oo ka o'omae 'ilo'oo, “Jisas, 'i'oo nga wela na God ne'e 'inato'o maka ba'ita 'e iiki! 'Olataa na'a 'i'oo siria ani agea agu? Nau ku soe'o 'i'oo sia kwatea mola ta kwa'ikwa'inga fagu.” ");
INSERT INTO kwd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","La Jisas ka orisia, “Latamu ni dai?” Ma ngaia ka lamadu'aa ma ka 'ilo'oo, “Latagu 'E Aula.” Ngaia 'e fata 'ilo'oo suria nga adalo 'e aula ba'ita na'a gila bo'ea. ");
INSERT INTO kwd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ni adalo lo'oo gila 'unea la Jisas fana 'i ngaia sia beloga mola fana 'ubulana kiru na kwa'ikwa'inga. ");
INSERT INTO kwd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma nga uumi'i boo 'e aula, gila keto 'i bobona nga me'e busu no'ona galangia lefu no'ona. Ma nga adalo lo'oori gila ka 'unea la Jisas fana 'agila bo'ea nga uumi'i boo lo'oo. Ma la Jisas ka alamiga no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nga adalo laka'u, gila 'akwa mai fa'asia nga wane laka'u, ma gila ka bo'ea no'o nga uumi'i boo laka'u te'efou. Nga uumi'i boo laka'u, gila ka 'akwa no'o na 'ato lo'oori ma gila ka 'esiga no'o 'ubulana asi, ma gila ka go'u, ma gila ka mae te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma alata ta'a na gila aga suria uumi'i boo lo'oo gila agasia 'ola lo'oori, gila ka 'akwa, ma gila ka kwairii 'ania 'ola ne'e lau 'ubulana fanua no'ona ma ni fanua sisika ri'itana la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nga ta'a na'a gila longoa, gila ka leka mai fana agasilana ni 'ola lo'oo 'e lau. Ma alata gila nigi mai te'ala Jisas, gila ka agasia nga wane lo'oo na'a adalo 'e leka no'o fa'asia, ma ngaia ka to'oru no'o 'i maana 'a'aena la Jisas, ma ngaia ka ru'ufia no'o me'e ruu aana, ma ngaia ka manata'a no'o. Ma ta'a te'efou gila ka ma'u. ");
INSERT INTO kwd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma ni wane na gila agasia alata na la Jisas 'e belote'enia nga adalo lo'oo fa'asia nga wane lo'oori, gila ka kwairii no'o 'i suria fana ta'a na gila ogu mai. ");
INSERT INTO kwd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui ma ta'a te'efou lo'oo gila to'oru na gule'e lefu 'i Gerasa, gila iiria fala Jisas 'ani leka fa'asiga, tofuna gila ma'u 'e iiki. Sui mala Jisas ka fane no'o 'i 'ubulana nga baru laka'u maka sasari no'o fana lekanga. ");
INSERT INTO kwd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma wane laka'u nga adalo 'e leka fa'asia, ngaia 'e 'unasia no'o la Jisas maka 'ilo'oo, “'Oi alami nau fana 'aku leka fe'eni'o.” Tafe'ua, ma la Jisas ka ruia, maka fata 'ilo'oo fana, ");
INSERT INTO kwd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“'Oi ori fana fanua amu, moko kwairii 'ania 'olataa na'a God 'e agea famu.” Sui ma wane lo'oo 'e ori no'o fana fanua aana, ma ka alafuu no'o 'i suria 'olataa na la Jisas 'e agea fana. ");
INSERT INTO kwd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sui ma, alata la Jisas 'e ori mai fa'asia gule'e asi laka'u, ta'a 'e aula lo'oo gila maasia, ma gila ka aile'a ba'ita fana agasilana. ");
INSERT INTO kwd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma te'e wane na'a latana la Jaeras ngaia ka nigi mai. Nga wane lo'oori ngaia na wane na'ona'o 'i 'ubulana 'ifi ni fo'anga na Jiu. Ngaia 'e leka mai maka bobouruuru 'i 'a'aena la Jisas, ma ka orisia fana 'ani leka fe'enia fani 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Suria te'e wela geni mouta'ia aana lo'oo 'e fii, ma ngaia ka galangi mae no'o. Te'e akwale'e farisi ma ruaai lo'oo 'e bi'i sui fafia futalana. Ma nga alata la Jisas 'e leka fe'enia, nga ta'a 'e aula gila ka kwaibebesi la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma te'e noni na'a gwe'e 'abu 'e 'ulasi aana 'e to'oru la'u mola 'i no'ona. Nga fiinga lo'oori 'e agea no'o suria akwale'e farisi ma ruaai. Ma ngaia ka ngadaa no'o nga bata aana te'efou fana ta'a ni gulaanga, tafe'ua ma ta wane 'ame gulaa no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ma nga noni lo'oori ka leka mai 'i burina la Jisas, ma ka gema to'ona nigifana ruu ala Jisas, ma nga fifiinga aana ka langa no'o fa'asia na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mala Jisas ka kwaiorisia 'ilo'oo, “Ni dai lo'oo 'e gema to'ogu?” Na alata no'ona, nga ogunga lo'oo te'efou gila ka gwala mola. Ma la Pita ka fata 'ilo'oo, “Alafa, ta'a 'e aula lo'oo gila bebesi'o no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tafe'ua, ma la Jisas ka fata 'ilo'oo, “Te'e wane 'e gema to'ogu, tofuna 'inau ku su'asuria nga tegelangaa agu 'e gulaa no'o ta wane ngaa'i.” ");
INSERT INTO kwd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nga noni lo'oori 'e su'a no'o ai na la Jisas 'e kwaiorisi no'o suria, ma ngaia ka leka mai, ma ngaia 'e ma'u maka lebelebe no'o, ma ngaia ka bobouruuru 'i maana 'a'aena la Jisas. Ma ngaia ka kwairii te'aga te'efou tofuna 'olataa na'a 'i ngaia 'e agea ma ka gema to'ona la Jisas, ma ngaia 'e gwari'a 'afe'aferu mola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma la Jisas ka fata 'ilo'oo fana, “Noni lo'oo, God ne'e gula'o no'o, tofuna 'i'oo fito'o agu. Leka no'o kau, God 'e kwatea aloalonga famu.” ");
INSERT INTO kwd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Alata la Jisas 'e alafuu mola 'ua, te'e wane 'e nigi mai fa'asia 'ifi ala Jaeras, ngaia 'e kwairii te'ala Jaeras maka 'ilo'oo, “Nga te'e wela geni laka'u amu, 'e mae no'o. 'I'oo sia faa'abelosia la'u nga wane ni kwaifa'ananaunga.” ");
INSERT INTO kwd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma la Jisas 'e longoa, maka fata 'ilo'oo fala Jaeras, “'I'oo sia ma'u mola. Lauta 'i'oo fito'o agu, nga wela geni lo'oo amu te'e moori mola.” ");
INSERT INTO kwd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Alata gila nigi kau 'i 'ifi, la Jisas 'e talaia la Pita, fe'enia la Jon, mala Jemes fe'enia la mama'a ma ga'ia wela geni lo'oo, ma gila ka ru'u 'i 'ifi. La Jisas 'e ruia te'efuta wane ngaa'i la'u 'esia ru'u mola fe'eniga 'i 'ifi. ");
INSERT INTO kwd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma nga ogunga lo'oo te'efou, gila kwaimanadai, ma gila ka nagufia nga wela geni lo'oo. Sui mala Jisas ka fata 'ilo'oo, “Moru sia aani mola. Nga wela geni lo'oo 'ame mae lo'oo, ngaia 'e eeno mola.” ");
INSERT INTO kwd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma gila ka 'osa 'ania la Jisas, tofuna gila su'asuria nga wela geni lo'oo 'e mae kwala'imori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sui mala Jisas ka dau 'i nimana nga wela geni lo'oo, ma ka fata 'ilo'oo, “Wela geni lo'oo, 'i'oo tata'e no'o!” ");
INSERT INTO kwd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma nga mangona ka ori no'o mai, ma ngaia ka tata'e no'o. Ma la Jisas ka iiria faga fana 'agila kwatea fangalaa fana. ");
INSERT INTO kwd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma ni ga'ia fe'enia la ma'aa ana wela geni lo'oo, gala ka 'alefo ba'ita no'o na 'ola lo'oo 'e lau. Tafe'ua, mala Jisas ka ruiga gila sia alafuu mola 'i suria 'ola lo'oo te'ana te'efuta wane ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","La Jisas 'e soea mai nga akwale'e wane ma ruaai ni Kwairiinga aana te'ana. Ma ngaia ka kwatea nga tegelangaa fana belolana adalo ma gulalana fifiinga faga. ");
INSERT INTO kwd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngaia ka alega kau fana 'agila foulange'enia na God te'e ba'ita fafia ta'a aana, ma fana gulalana ta'a na gila fii. ");
INSERT INTO kwd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma ngaia ka fata faga maka 'ilo'oo, “Mooru moru sia dau mola fafia ta 'ola fana lekanga amooru. Moru sia ngaria mola nga kuba'u, ma ta wa'i, ma ta fangalaa, ma ta bata, ma ta rua me'e ru'u. ");
INSERT INTO kwd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma lauta wane na ta 'ifi ne'e kwalo 'amooru, tamoru to'oru lalato'o 'i 'ubulana 'ifi no'ona, leleka ma ka nigi na alata na'a amoru leka fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lauta ta wane na ta fanua na'a 'ame kwalo 'amooru, tamoru leka fa'asiga, ma tamooru tafula furufuruna wado fa'asia nga 'a'ae mooru 'ilaka'u nga fa'abasunga no'o faga na God 'ani sufaga, tofuna gila ma'asiri fana longolana fatalana God.” ");
INSERT INTO kwd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma ni Wane ni Kwairiinga aana gila ka leka no'o na fanua te'efou fana alafuunga suria na God te'e ba'ita fafia ta'a aana ma gulalana ta'a na afirina lefu te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma nga alata no'ona la Herod Antipas nga alafa 'i Galili, 'e longoa nga alafuunga lo'oo suria ni 'ola lo'oo la Jisas 'e agea. Ma ngaia ka manata gelo suria tani ta'a ngaa'i gila iiria la Jon wane ni naruabunga na'a ngaia 'e moori la'u mola, ");
INSERT INTO kwd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma tani wane ngaa'i la'u gila ka iiria ngaia la Elaeja nga profet, ma tani wane ngaa'i la'u gila ka iiria ngaia nga profet 'ua mai na'o na ngaia 'e tata'e la'u mola fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sui ma la Herod ka fata 'ilo'oo, “La Jon nau ku kwatea no'o nga wane ni fununga 'agila tofumousia no'o gouna! Ma wane ni dai lo'oo gila alafuu la'u 'i suria 'ilo'oo?” Eta na alata no'ona, la Herod 'e siria 'e iiki fana 'ani agasia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma nga alata akwale'e wane ma ruaai ni Kwairiinga ala Jisas gila ori mai fa'asia lekanga laka'u aaga, gila ka alafuu suria ni 'ola na'a gila agea. Sui mala Jisas fe'enia fufu'iwane aana, gila ka leka no'o 'i talaga fana fanua 'i Betsaeda. ");
INSERT INTO kwd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tafe'ua, ma nga alata no'ona, ta'a no'ona gila longoa na la Jisas 'e riu, gila ka leka la'u mola suria. Ma la Jisas ka kwaloga, maka fata suria ba'itangaa na God fafiga, ma ka gulaa no'o ta'a na'a gila fii. ");
INSERT INTO kwd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma ngaia 'e laulafi no'o, alata sina galangi suu no'o, nga akwale'e wane ma ruaai ni Kwairiinga aana gila ka leka mai te'ana, ma gila ka fata 'ilo'oo, “'Oi iiria fana nga ogunga lo'oo, fana 'agila leka fani fanua galangi lo'oo, fana 'agila daria fangalaa fe'enia ta lefu fana enonga ai, tofuna nga lefu lo'oo 'ame to'omia ta wane 'ani nana'i ai.” ");
INSERT INTO kwd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sui mala Jisas ka fata 'ilo'oo faga, “Moru kwatea nga fangalaa faga fana 'agila 'ania.” Ma gila ka lamadu'aa gila ka 'ilo'oo, “'Ameeru meru to'o mola na te'e nima me'e beret lo'oo, ma nga rua gweii'a. 'Ilo'oo ma 'i'oo siria 'ameeru leka fana forilana mai nga keto fana ogunga ba'ita lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nga ogunga lo'oo 'e toto'o fe'enia nga nima to'oni (5,000) wane na'a gila to'oru 'i lo'oo. La Jisas ka fata 'ilo'oo fana nga fufu'iwane aana, “Moru iiria faga 'agila to'oru oguogu 'i wado na nga nima akwale'e wane.” ");
INSERT INTO kwd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nga fufu'iwane laka'u gila ka agea 'ino'ona sui, ma nga ta'a te'efou gila to'oru no'o 'i wado. ");
INSERT INTO kwd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui mala Jisas bi'i ngaria nga nima me'e beret lo'oo, ma nga rua gweii'a lo'oo, ma ngaia ka aga 'ala'a fani langi, maka baatafea God. Sui ma ngaia ka ngaria nga me'e beret lo'oo, ma nga ii'a laka'u, ma ka madangaa, maka kwatea fana nga fufu'iwane laka'u aana, fana 'agila dalo'ia na ta'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma gila te'efou gila ka keto, ma gila ka bote te'efou no'o. Ma nga fufu'iwane laka'u ana gila ka gonia nga olengana fangalaa ne'e ole 'i 'ubulana akwale'e kukudu ma ruaai leleka maka fongu no'o. ");
INSERT INTO kwd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te'e alata ngaa'i la Jisas ngaia 'e fo'a 'i talana, ma nga fufu'iwane aana gila ka leka mai te'ana, ma ngaia ka orisiga 'ilo'oo, “Ta'a lo'oo gila iiria 'inau ni dai?” ");
INSERT INTO kwd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma gila lamadu'aa ma gila 'ilo'oo, “Tani ta'a ngaa'i gila iiria 'i'oo la Jon wane ni naruabunga lo'oo 'e moori la'u mola. Ma tani ta'a ngaa'i la'u gila ka iiria 'i'oo la Elaeja. Ma tani wane ngaa'i la'u gila iiria 'i'oo nga profet ngaa'i laka'u mai 'i na'o na 'e moori la'u.” ");
INSERT INTO kwd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma la Jisas ka orisiga maka 'ilo'oo, “Ma mooru iiria nau ni dai?” La Pita 'e lamadu'aa maka 'ilo'oo, “'I'oo na'a nga Kraes, nga wane na'a God 'e firia fana fa'amoorilana ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sui mala Jisas ka fata tegela faga, gila sia kwairii la'u te'ana te'efuta wane na ni 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma ngaia ka fata la'u 'ilo'oo, “Nau, nga Wela na Wane, taku nonifii ba'ita na ni 'ola 'e aula. Ma ni wane na'ona'o, ma nga fataabu ba'ita, ma nga ta'a kwaifa'ananaunga na nga Tagi ala Moses, tagila rugasi nau. Ma tagila kwa'i nau, ma oruna ma'e gani, God te'e tata'e nau fana mooringa.” ");
INSERT INTO kwd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma la Jisas ka fata 'ilo'oo la'u faga te'efou, “Ni dai ne'e siria 'ani lado agu, ngaia 'e sia manata 'abelo mola suria ni 'ola 'e siria fana 'i talana. Furifuri ngaia te'e 'uri fana 'ani mabolosia 'i ngaia talana, maka ngaria 'ai folo aana maka lado agu. ");
INSERT INTO kwd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ni dai ne'e ma'asiri 'ani lado agu tofuna 'e siria 'ani agea mola 'ola suria kwaisiriinga aana 'i talana, ngaia te'e talafia nga mooringa firi. Tafe'ua, ma lauta ni dai na'a 'ame manata 'abelo suria ni 'ola 'e siria mola fana 'i talana, ma ka 'uri fana 'ani mae tofuna 'inau, ngaia te'e to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lauta nga wane 'e to'o na ni 'ola te'efou 'ubulana mola gari lo'oo, ma ngaia 'ame to'o na mooringa firi, ni 'ola lo'oori 'e sia agea mola ta le'anga fana. ");
INSERT INTO kwd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma lauta te'efuta wane 'e noniria 'ani nau fe'enia fatalagu, nau, nga Wela na Wane, taku noniria la'u mola 'ania, na alata 'aku nigi mai fe'enia nga kwangakwanganga agu, ma nga kwangakwanganga na Ma'aa agu ma nga enselo abu la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nau ku iiria famooru, tani wane amooru 'i lo'oo, gila sia mae mola leleka ma mooru ka agasia God 'ani ba'ita fafia ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kwaru maa'e gani 'i burina na'a la Jisas 'e iiria 'ola lo'oori, ngaia 'e talaia la Pita, ma la Jon, ma la Jemes, ma gila ka fane 'i gouna me'e busu fana fo'anga. ");
INSERT INTO kwd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma alata la Jisas 'e fo'a ai, nga maana 'e lamadu'aa maka sinasinalo'a no'o, ma nga ruu aana 'e kwakwao'a maka sinasinalo'a no'o. ");
INSERT INTO kwd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma 'ame gole mola ma nga rua wane ngaa'i gala ka faata'i la'u mola fe'enia, ma gala ka alafuu fe'enia la Jisas. Gaa'a na'a la Moses mala Elaeja. ");
INSERT INTO kwd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma gala ka faata'i 'ubulana nga sinasinalo'anga 'i Langi, ma gaa'a gala alafuu fe'enia la Jisas suria nga maenga aana ma nga lekanga aana fa'asia fanua lo'oo 'i wado fana 'i Langi na'a te'e lau 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","La Pita ma nga rua wane ni kwaimaanga aana, gila eeno no'ona mola. Ma alata gila kwa'adu mai, gila ka agasia nga kwangakwanganga ala Jisas ma nga rua wane na'a gala ula fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma nga alata na rua wane lo'oori gala sasari fana lekanga fa'asia la Jisas, la Pita ka fata 'ilo'oo fana, “Alafa, ngaia 'e le'a fana ameeru to'oru mola 'ilo'oo. Alamia 'ameru launge'enia oru 'o'oba, te'e ai famu, ma te'e ai fala Moses, ma te'e ai ngaa'i fala Elaeja.” (Pita 'e bobolosia mola nga 'ola ne'e iiria.) ");
INSERT INTO kwd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma alata la Pita 'e alafuu mola 'ua, te'e me'e gwafo 'e nigi ma nunufi ka 'esia no'o fafiga. Ma nga oru wane lo'oo, gila ka ma'u na alata na'a me'e gwafo lo'oo 'e leka mai maka dau fafiga. ");
INSERT INTO kwd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma te'e kwala 'e 'ola 'e fata tafa mai fa'asia 'i 'ubulana nga me'e kofa lo'oo maka fata 'ilo'oo, “Ngaia na'a nga wela agu. Nau ku firia no'o. Moru gwalongo fana!” ");
INSERT INTO kwd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma alata kwala 'e 'ola lo'oo 'e fata 'e sui mola, te'e la Jisas ne'e nana'i no'o fe'enia nga oru wane aana. Ma gila ka noto fafia nga 'ola lo'oori, ma alata no'ona gila 'ame kwairii no'o suria te'ana te'efuta wane na 'ola lo'oo na'a gila agasia. ");
INSERT INTO kwd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nga maa'e gani ngai 'i burina ni 'ola lo'oo, la Jisas fe'enia oru wane lo'oo aana, gila bi'i sifo mai fa'asia gouna me'e busu lo'oo la Jisas 'e lamadu'aa ai, ma nga ta'a 'e aula gila ka nigi mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma te'e wane fa'asia nga ogunga lo'oo 'e o'omae maka fata 'ilo'oo, “Wane kwaifa'ananaunga, nau ku orisi'o, 'oi beloa kau adalo lo'oo fa'asia nga wela lo'oo agu, suria ngaia na'a te'e wela momola agu no'o. ");
INSERT INTO kwd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Alata 'e aula nga adalo 'e olofia wela lo'oo agu, ma ngaia ka o'omae ba'ita, ma ka 'ui 'ania 'i wado ma ka lebelebe no'o, ma nga fokana ka fongu no'o na ngingisubou. Alata 'e lau, ngaia 'e malate'ote'o aana maka 'ato no'o 'ani sui fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau ku soea fufu'iwane amu fana 'agila beloa adalo lo'oo fa'asia, ma ngaia 'e 'ato no'o faga fana agelai.” ");
INSERT INTO kwd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","La Jisas 'e fata 'ilo'oo, “Nga manata lamooru 'e ngasi iiki. Moru 'ame fito'o mola 'ua aga lo'oo! Nau ku kweo no'o 'ania abu fito'onga lo'oo amooru. Nau ku to'oru fe'enia mooru maka nigi lo'oo no'o, to'omia 'amoru fito'o no'o agu.” Sui maka fata 'ilo'oo fana wane lo'oo, “'Oi ngaria mai nga wela no'ona amu te'agu.” ");
INSERT INTO kwd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma alata na wela lo'oo 'e nigi mai na lefu lo'oo la Jisas ngaia 'e ula ai, nga adalo lo'oo 'e geua wela lo'oo 'i wado, maka lebelebe no'o. Ma la Jisas 'e beloa nga adalo lo'oori, ma ngaia ka ru'u no'o mai fa'asia wela lo'oo, ma nga to'orunga na wela lo'oori bi'i le'a, ma la Jisas ka kwatea wela lo'oori fana ma'aa aana. ");
INSERT INTO kwd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma nga ta'a lo'oo gila ogu, gila ka 'alefo ba'ita na tegelangaa ana God. Ma alata na'a ta'a gila 'alefo no'o na ni 'ola lo'oo na'a la Jisas 'e agea, ngaia ka fata 'ilo'oo fana fufu'iwane laka'u aana, ");
INSERT INTO kwd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Moru gwalongo le'a mai ma mooru sia nabolosia mola ni 'ola lo'oo nau ku iiria famooru. Nau, nga Wela na Wane, tagila kwate nau fana marimae agu.” ");
INSERT INTO kwd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tafe'ua, ma fufu'iwane laka'u aana gila 'ame su'a mola na 'olataa na'a ngaia 'e iiria 'ubulana alafuunga lo'oo aana. La God 'e na'agonia nga fa'awatagalana alafuunga lo'oo fa'asiga. Ma gila ka ma'u mola fana orisilana nga fa'awatagalana alafuunga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma nga orisu'usu'unga 'e lau 'i laloana nga fufu'iwane ala Jisas, suria ni dai aga na te'e ba'ita riufiga te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma tofuna la Jisas 'e su'a mola suria manatalaga, ngaia 'e ngaria mai te'e wela sisika, ma ka fa'aula 'i suria, ");
INSERT INTO kwd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ka fata 'ilo'oo faga, “Ni dai na'a 'i'oo kwaloa te'e wela sisika 'ilo'oo tofuna 'i'oo fito'o agu, 'i'oo kwalo nau la'u mola. Ma lauta ni dai 'i'oo kwalo nau, 'i'oo kwaloa la'u mola God ne'e kwate nau mai. Suria ni dai na'a 'i'oo malasika'a amu talamu 'i laloamooru, 'i'oo na wane ba'ita riufia 'amooru te'efou.” ");
INSERT INTO kwd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sui mala Jon ka fata 'ilo'oo, “Alafa, 'imeeru meru agasia te'e wane 'e beloa nga adalo 'ania tegelangaa amu, mai 'imeeru meru ka ruia fa'asia agelai, tofuna 'i ngaia 'ame lado fe'eni 'adauru.” ");
INSERT INTO kwd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","La Jisas 'e fata 'ilo'oo faga, “'Amoe! Moru sia ruia la'u, ni dai na'a 'ame ula 'usia adauru, ngaia nga wane fe'eni 'adauru no'ona.” ");
INSERT INTO kwd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Alata 'e galangi nigi no'o fala Jisas 'ani ori no'o fani Langi, ngaia ka manata ba'ita na lekanga fani Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma ngaia ka alea ta'a lo'oo 'agila leka no'o 'i na'ona. Gila leka no'o, ma gila ka nigi na te'e fanua na nga gule'e lefu 'i Samaria fana 'agila sasari agau na ni 'ola te'efou mamania. ");
INSERT INTO kwd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tafe'ua, ma nga ta'a lo'oo gila 'ame siria mola kwalolana, suria ngaia nga wane mola 'i Jiu ne'e leka fani Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma alata nga rua wane na fufu'iwane aana, la Jemes mala Jon, gala agasia ni 'ola lo'oori, gaa'a gala fata 'ilo'oo fana, “Alafa, ngaia 'e 'utaa? 'Ilo'oo ma 'i'oo siria me'e 'amele kwaisoe fana eele fa'asia 'i Langi 'ani do'ofia ta'a lo'oo te'efou?” ");
INSERT INTO kwd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sui mala Jisas ka bu'ota'i ma ka barufi 'agaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mai gila ka leka no'o fana nga maa'e fanua ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma nga alata na gila leka no'o suria nga me'e tala, te'e wane ngaa'i ka fata 'ilo'oo fala Jisas, “Nau ku siria 'aku leka fe'eni'o 'ua ta lefu fai na 'i'oo 'ani leka ai.” ");
INSERT INTO kwd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","La Jisas ka fata 'ilo'oo fana, “'Amoe, 'e 'ame wada'u. Nga ku'ito kwasi gila to'o na nga lefu aga fana enonga, ma nga langasi gila ka to'o na nga nuu'i aaga. Tafe'ua, ma 'inau, nga Wela na Wane, nau ku 'ame to'o na ta 'ifi fana enonga ai.” ");
INSERT INTO kwd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma la Jisas ka fata 'ilo'oo fana te'e wane ngaa'i la'u, “'Oi leka mai fe'eni nau.” Tafe'ua, ma nga wane lo'oo ka fata 'ilo'oo, “Alafa, 'oi alami nau fana 'aku to'oru madi fe'enia ma'aa agu, leleka maka mae, 'aku kwaiatoa sui, mai nau taku bi'i leka 'i suri'o.” ");
INSERT INTO kwd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma la Jisas ka lamadu'aa ma ka 'ilo'oo fana, “'Oi alame'enia nga wane na mangoga 'e mae, 'agila kwaiatoa no'o kau nga wane ne'e mae. Ma 'i'oo to'o leka mola, moko fata suria nga kwairiinga le'a na'a God te'e ba'ita fafia ta'a aana.” ");
INSERT INTO kwd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma te'e wane ngaa'i la'u mola 'e fata 'ilo'oo, “Alafa, nau ku siria 'aku leka fe'eni'o. Tafe'ua, ma 'oi alami nau madi 'aku leka ma ku gwalo madi na ni ta'a agu 'i fanua.” ");
INSERT INTO kwd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mala Jisas ka fata 'ilo'oo fana, “Te'efuta wane ne'e tala'ae fana 'ani leka fe'eni nau, ma ngaia ka manata ba'ita suria ni 'ola ne'e 'akwasia, ngaia 'e 'ame to'omia no'o fana taunga'inga fana God.” ");
INSERT INTO kwd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'I burina na'a ni 'ola lo'oo nga Alafa la Jisas 'e firia fiu akwale'e wane ma ruaai lo'oo, maka kwatea 'agila leka tala rua wane 'i na'ona fana fanua te'efou na ngaia 'e manata fana lekanga ai. ");
INSERT INTO kwd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ngaia ka fata 'ilo'oo faga, “Ni wane na'a gila sasari agau no'o fana tagoto'onga na God, gila 'ilaka'u nga lode 'ai 'e aula 'i 'ubulana langa'a fana gonilani. Tafe'ua, ma wane fana gonilana ni 'ola lo'oori, gila 'ame aula. Ngaia na, tamooru fo'asia God fana ngaia 'ani kwatea mai ta'a ni taunga'inga fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Moru leka no'o kau ma mooru ka madafia. Nau ku kwate amooru 'ilaka'u nga dadale'e sifisifi 'i laloana nga ku'ito kwasi, tofuna ta'a 'e aula na gila siria 'agila ngada 'amooru. ");
INSERT INTO kwd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mooru sia ngaria mola te'efuta bata, ma mooru sia ngaria mola nga wa'i fana ketonga, ma nga wa'i na bata, ma nga rua me'e butu. Ma moru sia alafuu aburu mola fe'enia te'efuta wane suria tala. ");
INSERT INTO kwd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma alata mooru ru'u na 'ifi, tamoru fata 'ilo'oo, ‘La God te'e nanamate'enia mooru, ma nga aloalonga aana te'e nana'i fe'enia mooru 'i 'ubulana nga 'ifi lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma lauta nga wane ne'e to'oru no'ona 'e kwalo 'amooru 'ania aloalonga, God te'e kwatea nga nanamanga fana fu'i ru'uru'ua no'ona. Mai lauta 'e 'amoe, ma God sia nanamate'eniga mola, ma le'anga lo'oori te'e ori mola mai famooru. ");
INSERT INTO kwd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Moru to'oru 'i 'ubulana nga 'ifi no'ona, ma te'efuta fangalaa ma ka'o gila kwatea famooru, moru 'ania, ma moru ka go'ufia. Nga wane ne'e taunga'i, ngaia te'e ngaria nga foforinga aana. Mooru tamoru nana'i to'o, ma moru sia leka kwaiiriu mola. ");
INSERT INTO kwd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma alata mooru nigi na te'efuta fanua, ma gila ka kwaloa 'amooru, moru 'ania fangalaa 'utaa na'a gila kwatea famooru. ");
INSERT INTO kwd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma moru ka gulaa nga ta'a 'e fii 'i 'ubulana nga 'ifi no'ona, ma moru ka fata 'ilo'oo fana nga ta'a no'ona, ‘Nga alata God 'ani ba'ita fafia ta'a aana, 'e galangi 'amooru no'o.’ ");
INSERT INTO kwd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma lauta moru nigi ana te'efuta fanua, ma gila 'ame kwalo 'amooru, moru leka suria nga tala no'ona 'i 'ubulana fanua no'ona, ma ta'a moru fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nga furufuruna wado na fanua lo'oo amooru, lo'oo 'i olofana 'a'ae meeru, meru tafula no'o kau 'usi 'amooru. Ngai lo'oo nga fa'abasunga no'o famooru na'a God te'e kwatea kwa'ikwa'inga famooru tofuna moru ma'asiri fana longolana fatalana God. Moru manata to'ona ni 'ola lo'oo: Nga alata fana God 'ani ba'ita fafia ta'a aana 'e galangi no'o.’ ");
INSERT INTO kwd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nau ku iiria famooru, nga gani na kwa'ikwa'inga na'a 'ani nigi mai, God te'e kwatea nga nonifiinga fana nga ta'a na fanua ne'e ria 'ilaka'u 'i Sodom. Tafe'ua, ma ngaia te'e kwatea nga nonifiinga ba'ita iiki fana ta'a na fanua na'a gila ma'asini agu ne'e riufia ta'a na fanua lo'o 'i Sodom!” ");
INSERT INTO kwd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","La Jisas 'e fata 'ilo'oo, “Ngaia 'e ria tala'esia no'o famooru ta'a na moru to'oru na fanua 'i Koresin. Mai 'amooru na moru to'oru na fanua 'i Betsaeda la'u mola. Mooru moru 'ame fito'o na 'ola ni 'alefosilai 'e aula laka'u 'inau ku agea famooru lo'oo. Lauta nau ku agea 'ola ni 'alefosilai lo'oo na fanua 'i Taea ma 'i Saedon 'i na'o, nga ta'a no'ona bala tagila to'oru 'i wado, ma gila ka ru'ufia ruu biribiri'a, ma gila ka bunia noniga 'ania makola, fana 'ani faate'enia na gila bu'ota'i mai fa'asia rianga aaga te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na ta fe'e gani God 'ani sufaa ta'a te'efou fofona fanua lo'oo 'i wado, nga kwa'ikwa'inga amooru te'e ria iiki maka riufia nga ta'a 'i Taea mai Saedon. ");
INSERT INTO kwd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Ino'ona ma 'i amooru nga ta'a lo'o 'i Kapaneam, moru madafia God te'e lafu 'amooru fani Langi? 'Ato no'o! Ngaia te'e to'osi 'amooru 'i 'ubulana kiru na nonifiinga.” ");
INSERT INTO kwd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui ma la Jisas ka fata 'ilo'oo fana fufu'iwane aana, “Lauta ni dai ne'e gwalongo famooru, ngaia 'e gwalongo la'u mola fagu. Ma lauta ngaia 'e ma'asini te'enia mooru, ngaia 'e ma'asiri la'u mola agu. Ma lauta ni dai ne'e ma'asiri te'eni nau, ngaia 'e ma'asini te'enia la'u mola God ne'e kwate nau mai.” ");
INSERT INTO kwd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Alata nga fiu akwale'e wane ma ruaai laka'u gila ori mai, gila ka aile'a ba'ita, ma gila ka fata 'ilo'oo, “Alafa, gwa'a adalo ma gila lo'o la'u mola suria 'ameeru alata meru belote'eniga 'ania latamu!” ");
INSERT INTO kwd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mala Jisas ka fata maka 'ilo'oo, “Nau ku agasia la Saetan 'e 'esia mai 'ilaka'u nga kwangakwanga fa'asia 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Moru fafulongo madi! Nau ku kwatea nga tegelangaa famooru fana 'amooru tala riufia nga waa ke'eke'e ma nga lafilafi ma ngaia 'e 'ato fana 'agila ngada 'amooru. Nau ku kwatea nga tegelangaa ne'e ba'ita maka riufia la Saetan nga marimae adauru no'o famooru. Te'efuta 'ola ala Saetan 'ato 'ani fa'afii 'amooru no'o. ");
INSERT INTO kwd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tafe'ua, mooru sia aile'a mola tofuna nga adalo lo'oo gila lo'o suri 'amooru. Tafe'ua, ma moru aile'a ba'ita tofuna God 'e giria no'o nga lata mooru 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma nga alata no'ona, Anoe 'ola Abu 'e fa'amalale'aa la Jisas, ma ngaia ka fata 'ilo'oo, “Mama'a agu, 'i'oo ba'ita fafia 'ola lo'oo te'efou 'i langi ma lo'oo 'i wado la'u mola. Nau ku baatafe'o, tofuna na'a 'i'oo faate'enia ni 'ola lo'oo fana ta'a gila tagoto'o agu 'ilaka'u nga wela sisika, ma 'i'oo ko na'agonia ni 'ola lo'oo fa'asia ta'a na'a gila lafuga 'i talaga tofuna gila su'a'ola, ma gila ka aga su'aai ni 'ola 'e aula lo'oo. Kiu Ma'ana, ni 'ola lo'oo ngaia 'e 'ilo'oo no'o suria nga kwaisiriinga amu 'ua no'o mai na'o.” ");
INSERT INTO kwd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui mala Jisas ka fata 'ilo'oo faga, “Ma'aa agu 'e kwatea 'ola lo'oo te'efou no'o fagu. Ma te'e 'i ngaia no'o nga Mama'a ne'e su'agu nga Wela aana. Ma te'e 'inau nga Wela aana na'a ku su'a ana Mama'a agu, ma te'e ni wane na Wela ngaia 'e firiga fana faate'enilai faga, na'a gila su'asuria.” ");
INSERT INTO kwd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui mala Jisas 'e bu'ota'i fana Wane ni Kwairiinga aana talaga, maka fata 'ilo'oo faga, “God 'e nanamate'eni 'amooru, tofuna moru agasia nga 'ola ni 'alefosilai lo'oo tala'ina. ");
INSERT INTO kwd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nau ku iiria famooru, nga profet 'e aula ma ni alafa 'e aula mai na'o, gila siria la'u mola agasilana ni 'ola na mooru agasia tala'ina lo'oo, tafe'ua ma ngaia 'e 'ato faga 'e iiki. Ma gila ka siria la'u mola longolana ni 'ola lo'oo na amooru longoa tala'ina lo'oo, tafe'ua ma ngaia 'e 'ato la'u mola faga.” ");
INSERT INTO kwd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te'e wane ni kwaifa'ananaunga na nga Tagi ala Moses, ngaia 'e leka mai te'ala Jisas. Ngaia siria 'ani irito'ona, maka fata 'ilo'oo, “Wane kwaifa'ananaunga, 'olataa na taku agea fana 'aku to'o na nga mooringa firi?” ");
INSERT INTO kwd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma la Jisas ka lamadu'aa maka 'ilo'oo fana, “'Olataa na'a nga Girigiringa Abu 'e iiria? 'Ilo'oo ma 'i'oo idumia moko su'a ai?” ");
INSERT INTO kwd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma nga wane lo'oo 'e lamadu'aa maka fata 'ilo'oo, “'Oi kwaimaa fana God amu, 'ania manatalamu te'efou, ma 'ania mangomu te'efou, ma 'ania tegelangaa amu te'efou, ma 'ania funi'oonga amu te'efou. Ma 'i'oo to'o kwaimaa fana ta'a te'efou 'ilaka'u la'u mola na'a 'i'oo kwaimaa famu 'i talamu.” ");
INSERT INTO kwd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma la Jisas 'e fata la'u 'ilo'oo, “Nga lamadu'aanga amu 'e odo. 'Oi age 'i no'ona, ma 'i'oo to'o momoori firi.” ");
INSERT INTO kwd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tafe'ua, ma nga wane lo'oo, 'e siria 'ani faate'enia no'o nga to'orunga aana ne'e odo mola, ngaia ka orisia la'u mola la Jisas maka 'ilo'oo, “Ni dai na'a nga wane ni futanga agu na'a 'aku kwaimaa faga?” ");
INSERT INTO kwd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma la Jisas 'e su'asuria ta'a lo'oo 'i Jiu gila ma'asini te'enia ta'a 'i Samaria ma ngaia ka kwairii te'ana maka 'ilo'oo, “Te'e wane 'i Jiu ngaia 'e eta mai 'i Jerusalem maka sifo fani Jeriko. Ma alata ngaia 'e leka kau suria nga tala, ni wane gila ria gila ka kwa'ia, ma gila ka ngaria no'o ni 'ola aana fe'enia nga ruu aana te'efou. Ma gila ka kwa'ia leleka ma ngaia ka mangosu no'o, sui ma gila ka rugasia ma gila ka leka no'o fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma nga alata no'ona, te'e fataabu na 'Ifi Abu na God ngaia 'e leka la'u mola suria nga tala no'ona, ma alata 'e agasia nga wane laka'u, ngaia ka taba la'u mola suria nga gule'e tala ngaa'i, maka leka mola fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Burina, te'e wane ne'e kwaibooni 'ubulana nga 'Ifi Abu na God ngaia 'e leka la'u mai suria nga tala no'ona. Ma alata ngaia 'e nigi no'ona, ngaia 'e agasia nga wane laka'u. Tafe'ua, ma ngaia 'e taba la'u mola fa'asia na nga gule'e tala ngaa'i, maka leka la'u mola fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Burina la'u te'e wane fa'asia nga gule'e lefu 'i Samaria ngaia 'e leka la'u mai suria nga tala no'ona. Alata ngaia 'e agasia nga wane laka'u, ngaia 'e kwaimanadai ba'ita fana. ");
INSERT INTO kwd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma ngaia 'e leka mai te'ana, ma ka 'usua nga maalafa laka'u aana 'ania nga waiwai ma nga waeni, ma ka gau no'o fafia. Sui ma ngaia ka lafua no'o 'i fofona nga dongki aana, ma ka ngaria no'o fana te'e 'ifi fana forilai fana 'ani to'oru 'i 'ubulai, ma ngaia ka aga suria ai. ");
INSERT INTO kwd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma nga ruana maa'e gani, ngaia 'e ngaria bata ne'e tooto'o fe'enia foforinga fana rua ma'e gani maka kwatea fana nga wane ne'e aga suria nga 'ifi no'ona, maka fata 'ilo'oo fana, ‘'Oi aga suria nga wane lo'oo, ma alata nau ku ori la'u mai, nau taku du'ua te'efou nga bata na'a 'i'oo boonia 'ania.’” ");
INSERT INTO kwd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sui mala Jisas ka fata 'ilo'oo fana wane ni kwaifa'ananaunga na Tagi ala Moses, “'Ino'ona ma 'i'oo manata 'utaa? Ni dai laloana oru wane lo'oo na gila fa'alata wane ni futanga na nga wane laka'u gila kwa'ia?” ");
INSERT INTO kwd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma nga wane ni kwaifa'ananau na Tagi ala Moses ka fata 'ilo'oo, “Nga wane na'a ngaia 'e kwaimanadai fana.” Ma la Jisas ka fata 'ilo'oo fana, “'Oi leka, moko agea la'u 'ino'ona.” ");
INSERT INTO kwd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","La Jisas ma nga fufu'iwane aana gila leka, ma gila ka nigi na te'e fanua, ma te'e noni na latana ni Mata ka kwaloa la Jisas fana 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma nga noni 'e futa fe'enia ni Meri 'e to'oru galangia nga 'a'aena nga Alafa la Jisas, maka fafafulongo mola fana nga kwaifa'ananaunga ala Jisas ");
INSERT INTO kwd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma nga manatalana ni Mata 'e 'abelo suria te'e 'i ngaia ne'e agea nga taunga'inga te'efou 'i 'ifi. Ma ngaia ka leka mai te'ala Jisas, maka fata 'ilo'oo fana, “Alafa, 'ilo'oo ma 'i'oo 'ame manata 'abelo mola suria ni aasigu geni na ngaia 'e 'akwasi nau mola ma te'e 'inau kua agea mola nga taunga'inga lo'oo 'i talagu? 'Oi iiria fana 'ani leka mai maka kwaibooni la'u agu!” ");
INSERT INTO kwd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma nga Alafa 'e lamadu'aa fana maka 'ilo'oo, “Mata, 'i'oo manata gelo ma nga manatalamu 'e 'abelo no'o suria ni 'ola 'e aula. ");
INSERT INTO kwd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tafe'ua, te'e 'ola momola na'a ngaia 'e le'a. Ni Meri ngaia 'e firia nga 'ola 'e le'a, ma te'efuta wane sia lafua la'u fa'asia.” ");
INSERT INTO kwd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na te'e gani ngaa'i, la Jisas 'e fo'a na te'e lefu ngaa'i. Ma alata ngaia 'e fo'a bi'i sui mola, te'e wane na fufu'iwane aana 'e fata 'ilo'oo fana, “Alafa, 'oi fa'ananau 'ameru na fo'anga, 'ilaka'u la Jon 'e fa'ananaua la'u nga fufu'iwane aana na fo'anga.” ");
INSERT INTO kwd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","La Jisas 'e fata 'ilo'oo faga, “Alata mooru fo'a, tamooru fata 'ilo'oo, ‘Mama'a agu, Meeru meru siria ta'a te'efou 'agila fa'aba'ita nga latamu, tofuna 'e abu 'e iiki. Meeru meru siria 'i'oo 'ani ba'ita fafia ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Moko kwatea mai fameeru nga fangalaa ne'e to'omia meeru fana gani lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Moko 'olafanataa na rianga ameeru, 'ilaka'u na'a 'imeeru meru 'olafanataa lau mola na rianga na ta'a te'efou na'a gila agea ni 'ola 'e ria ameeru. Ma 'i'oo sia alamia meeru mola fana lekanga 'ubulana irito'onga ne'e riufi 'ameeru.’” ");
INSERT INTO kwd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma la Jisas ka fata 'ania te'e tarifulaa 'ilo'oo fana nga fufu'iwane aana, “Lauta ta wane amooru 'e leka te'ana nga wane ni kwaimaanga aana 'i 'ifi aana 'ubulana logo, maka fata 'ilo'oo fana, ‘Wela kau, 'oi kwatea madi mai ta oru me'e ma'alo fagu, ");
INSERT INTO kwd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tofuna te'e wane ni kwaimaanga agu lo'oo, ngaia 'e nigi mai te'agu fa'asia fanua lalau. Tafe'ua, mai nau ku 'ame to'o no'o na ta fangalaa na'a 'aku kwatea fana.’ ");
INSERT INTO kwd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma nga wane ni kwaimaanga lo'oori amu 'ubulana 'ifi lo'oo ka fata 'ilo'oo, ‘'Amoe. 'I'oo sia fa'a'abelosi nau la'u! Nga sinamaa 'e fono no'o, ma ni wela agu gila eeno te'efou no'o. Ngaia 'e 'ato no'o fana 'aku tata'e la'u fana kwatelana te'efuta 'ola famu.’ ");
INSERT INTO kwd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aia, nau ku iiria famooru, gwae ngaia 'ame siria agelana te'efuta 'ola, ma lauta 'i'oo kwaisoe, mai 'i'oo 'ame mamalo na kwaisoenga, nga wane lo'oo 'i 'ubulana 'ifi, ngaia te'e tata'e ma te'e kwatea mola ni 'ola te'efou na'a 'i'oo siria. Mai ngaia 'ame agea mola tofuna 'i'oo nga wane ni kwaimaanga aana, tafe'ua ma tofuna 'i'oo 'ame mamalo no'o na kwaisoenga. ");
INSERT INTO kwd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ngaia na, 'inau ku iiria famooru, moru kwaisoe na God fana 'amooru ngaria 'olataa na mooru soea. Ta'a mooru kwailo'ofia 'olataa mooru bo'obo'o fai te'ana God, ma ngaia te'e booni amooru fana 'amooru agasia. Ta'a mooru igiigi na sinamaa, ma God te'e 'ulasi famooru. ");
INSERT INTO kwd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'I'oo su'aai nga ta'a te'efou na'a gila kwaisoe na God, tagila ngaria no'o 'olataa na'a gila soea. Ma nga ta'a te'efou na'a gila kwailo'ofia 'ola gila bo'obo'o fai na God, tagila agasia. Ma ta'a te'efou na'a gila igiigi na sinamaa, God te'e 'ulasi faga. ");
INSERT INTO kwd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“'Ilo'oo ma, ni dai amooru nga mama'a, lauta nga wela amu 'e kwaisoe fana gweii'a, ma 'i'oo to'o kwatea mola me'e waa fana? 'Amoe no'o! ");
INSERT INTO kwd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma lauta nga wela amu 'e soea nga fakale'e susuki, ma to'o kwatea mola nga lafilafi fana? 'Amoe no'o! ");
INSERT INTO kwd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tafe'ua mooru te'efou ta'a moru ria, mooru su'asuria 'amooru kwatea mola ni 'ola 'e le'a fana ni wela amooru. Ma nga Ma'aa mooru na'a ngaia 'i Langi, ngaia 'e le'a iiki riufi amooru, ma ngaia 'e kwatea nga Anoe 'ola Abu fana ta'a na'a gila kwaisoe aana!” ");
INSERT INTO kwd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma te'e alata, la Jisas 'e beloa te'e adalo fa'asia te'e wane 'e 'ato 'ani fata. Ma alata adalo ngaia 'e 'akwa fa'asia, ngaia bi'i fata la'u. Ma nga ogunga ba'ita lo'oo gila ka 'alefo. ");
INSERT INTO kwd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma tani wane ngaa'i laloaga gila ka fata 'ilo'oo, “La Jisas 'e beloa nga adalo 'ania tegelangaa ala Saetan, nga 'inatana adalo.” ");
INSERT INTO kwd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma tani wane ngaa'i, gila siria 'agila irito'ona la Jisas. Ma gila ka soea fana 'ani agea nga 'ola ni 'alefosilai, fana 'ani faate'enia na'a ngaia 'e to'o na nga tegelangaa fa'asia God. ");
INSERT INTO kwd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma tofuna la Jisas 'e su'a mola na nga manatalaga, ngaia ka fata 'ilo'oo faga, “Lauta fufu'ita'a 'ubulana nga fanua ba'ita gila funu fe'eniga 'i talaga, ta'a na fanua ba'ita lo'oo tagila tagala'i no'o. Ma lauta nga wane, ma nga noni, gala funuria gaa'a 'i talagaa'a, ngaia 'e 'ato fana 'agala to'oru oguogu. ");
INSERT INTO kwd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngaia 'ino'ona la'u mola, lauta la Saetan 'e funu fe'enia fufu'i adalo aana, tagila tagala'i kwaitatari no'o. Nau ku iiria 'ola lo'oo tofuna moru iiria nau ku beloa adalo 'ania tegelangaa ala Saetan. ");
INSERT INTO kwd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aia, ma moru iiria nau ku beloa adalo 'ania tegelangaa ala Saetan. Tafe'ua ma tegelangaa ani dai lo'oo tani wane na fufu'iwane amooru gila beloa 'ania adalo? La Saetan? 'Amoe no'o! Suria ni 'ola lo'oo 'e faate'enia na'a mooru moru kuta. ");
INSERT INTO kwd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nau ku beloa adalo 'ania tegelangaa na God. Ma ngaia ka faate'enia no'o famooru na'a nga alata fana God 'ani ba'ita fafia ta'a aana ngaia 'e nigi te'amooru 'e sui no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","La Jisas 'e fata la'u mola suria te'e tarifulaa maka 'ilo'oo, “Lauta ta wane 'e lamo'ala 'e sasari agau na la'unga aana, ma ka folo le'a no'o 'usia 'ifi aana, te'e 'ato fana ta wane 'ani beria ni 'ola 'ubulana 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tafe'ua, lauta ta wane 'e tegela 'e riufia ngaia 'e leka mai ma ka funu fe'enia, ma ka talariufia no'o, nga wane lo'oori te'e ngaria no'o nga la'unga aana te'efou na ngaia 'e fito'o ai, ma te'e dalo'ia no'o ni 'ola lo'oo te'efou fana ta'a kwaimaanga aana. ");
INSERT INTO kwd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ni dai na'a 'ame lado agu, ngaia nga marimae agu. Ni dai na'a 'ame kwaibooni agu fana gonilana mai nga ta'a te'ana God, ngaia 'e tagalange'eniga no'o fa'asia God.” ");
INSERT INTO kwd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","La Jisas 'e fata la'u 'ilo'oo, “Alata gila belote'enia adalo fa'asia nga wane, ngaia 'e riu kwairiu 'ubulana lefu kwasila, ma 'e kwailo fana ta lefu fana 'ani to'oru la'u ai. Ma lauta ngaia 'e kwailo ma ka 'ato no'o, ngaia te'e manata 'ilo'oo, ‘Nau taku ori fana nga wane laka'u agu ku leka mai fa'asia.’ ");
INSERT INTO kwd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma alata 'e ori mai, ngaia 'e agasia wane laka'u 'e kwari, maka fa'aodoa no'o moorilana te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Alata ngaia 'e agasia ne'e 'ilo'oo, ngaia 'e ori, maka talaia la'u mai nga fiu adalo 'e ria 'e iiki riufia, ma gila ka leka mai, ma gila ka to'oru no'o 'i 'ubulana wane laka'u. Na alata lo'oo, nga to'orulana wane lo'oo bi'i ria maka riufia no'o 'i na'o.” ");
INSERT INTO kwd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Alata la Jisas 'e iiria 'ola lo'oo faga, te'e noni 'i 'ubulana ogunga lo'oo 'e o'omae 'ilo'oo, “Nga noni ne'e fa'afuta'o maka fa'asusufi'o ne'e aile'a 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","La Jisas 'e lamadu'aa maka fata 'ilo'oo, “Tafe'ua ma ta'a na'a gila longoa fatalana God, ma gila ka lo'o suria, gila no'o na tagila malale'a 'e ba'ita.” ");
INSERT INTO kwd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma alata na'a ogunga ba'ita gila ogu mai 'afuia la Jisas, ngaia ka fata 'ilo'oo faga, “Ta'a na'a moru momoori na alata lo'oo, mooru moru ria. Suria mooru moru siria mola agasilana nga 'ola ni 'alefosilai 'ani faate'enia tegelangaa na God, tafe'ua, ma ngaia 'e 'ato famooru fana amoru agasia. Ta'a mooru agasia mola nga 'ola ni 'alefosilai 'ilaka'u nga 'ola laka'u 'e lau fala Jona nga profet. ");
INSERT INTO kwd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nga 'ola ne'e lau fala Jona, 'e 'ilaka'u nga ma'etooto ne'e faate'enia fana ta'a 'i Ninifa na'a ngaia 'e leka mai fa'asia God. Nga 'ola na te'e lau agu 'e 'ilaka'u nga ma'etooto ne'e faate'enia na God 'e kwate nau mai, nga Wela na Wane, fana ta'a na alata lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma na gani na'a God te'e sufaa ta'a, nga noni laka'u 'e ba'ita fafia fanua 'i Siba, ngaia te'e tata'e, maka faate'enia nga rianga amooru, tofuna na'a abulongaa amooru na moru kuta ba'ita ai. Ngaia 'e leka lalau mai fa'asia fanua aana fana longolana su'a'olanga ala Solomon. Gwa'a 'ino'ona ma, 'inau, nga wane na ku ba'ita 'e iiki riufia la Solomon, nau ku to'oru 'i lo'oo tala'ina, ma moru 'ame longo mola suri nau. ");
INSERT INTO kwd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lauta 'ilaka'u na gani na God te'e sufaa ta'a te'efou, nga ta'a 'i Ninifa gila tagila faate'enia nga rianga amooru, suria gila abulo no'o mai te'efou fa'asia rianga aaga, alata gila longoa nga kwaifa'ananaunga la Jona 'e iiria faga. Tafe'ua, ma 'inau te'e wane ba'ita 'e iiki riufia la Jona, ma 'inau ku to'oru no'o 'i lo'oo tala'ina, tafe'ua ma moru 'ame abulo mola fa'asia rianga amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","La Jisas 'e fata 'ilo'oo, “Te'efuta wane sia lalaua mola nga uunu, ma ngaia ka na'agonia mola olofana nga daoko. Alata 'e lalaua nga uunu 'e sui mola, ngaia te'e arua no'o na lefu fana arulana uunu ai, fana ni dai ne'e ru'u mai 'ubulana 'ifi, ngaia 'e su'asuria 'ani agasia lalanga. ");
INSERT INTO kwd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lauta nga funi'oonga amu 'e 'ulasi fana to'onga, nga mangomu te'efou te'e to'o na lalanga. Ma lauta nga funi'oonga amu 'e 'ame 'ulasi no'o fana to'onga, nga mangomu te'efou ngaia te'e fongu 'ania logologo'angaa. ");
INSERT INTO kwd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'I'oo sia ma'asini te'enia mola to'onga lo'oo agu. Lauta 'i'oo ma'asini te'enia ma nga mangomu te'e nana'i 'ubulana logologo'angaa. ");
INSERT INTO kwd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lauta mooru moru fongu 'ania lalanga, nga noni mooru te'efou te'e wataga 'ilaka'u na nga uunu, ma te'efuta lefu 'i labemooru 'e sia nana'i la'u 'ubulana logologo'angaa.” ");
INSERT INTO kwd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Alata la Jisas 'e alafuu 'e sui no'o, te'e wane na Farasii 'e soea la Jisas fana 'ani keto 'i 'ifi aana. Mala Jisas ka leka no'o fe'enia, ma ka keto no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma nga Farasii lo'oo 'e 'alefo ba'ita, suria ngaia 'e agasia la Jisas ngaia 'ame narufia mola nga nimana 'i na'o, sui ma ngaia bi'i keto. ");
INSERT INTO kwd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma nga Alafa la Jisas ka fata 'ilo'oo fana, “Mooru Farasii, moru manata 'abelo iiki fana fulolana gula 'i maa na kakao ni go'unga ma ni 'ola ni fanganga amooru. Tafe'ua ma, 'i 'ubulana nga moori lamooru gila fongu 'ania ni 'ola 'e ria te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mooru moru kakakula 'e iiki! La God ne'e launge'enia 'ola te'efou, ma ngaia ka su'asuria 'olataa na'a ngai gula 'i maa ma ni 'olataa ngai 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aia, lauta moru kwatea ni 'ola amoru fana ta'a gila galafa, ni 'ola te'efou mooru agea te'e sinasinalo'a no'o 'i maana God. ");
INSERT INTO kwd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“'Ola 'e ria famooru ni Farasii, tofuna mooru moru kwatea mola fana God nga gule'e 'ola na tangafuru na 'ola sisika fana fa'a masi'alana ketonga amooru na'a mooru kirua 'i 'ubulana langa'a amooru. Tafe'ua ma, moru 'ame manata 'abelo mola fana fa'aodolana to'orunga amooru fe'enia ta'a ni futanga amooru, ma nga kwaimaanga amooru fana God. Ngaia 'e le'a na'a moru agea ni 'ola sisika fana kwatelana tangafuru na fangalaa amooru fana God, ma moru ka manata to'ona la'u nga 'ola ba'ita fana kwaimaange'enilana God, ma ta'a na fanua lo'oo amooru te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“'Ola 'e ria famooru Farasii na, tofuna alata moru leka 'ubulana 'ifi ni fo'anga, mooru moru siria to'orunga na furi'i to'orunga fana ta'a ba'ita. Ma alata moru leka 'i maana uusia'a, moru siria ta'a lo'oo 'agila fa'aba'ita mooru. ");
INSERT INTO kwd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Ola 'e ria famooru Farasii, tofuna mooru moru 'ilaka'u nga giru gwa'u na'a gila 'ame taboa 'i fofona, ma alata ta'a 'agila riu 'i fofona, gila 'ame aga su'aai nga 'ola ne'e si'ini 'e ria na'a ngai 'ubulai.” ");
INSERT INTO kwd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sui ma nga te'e Wane ni Kwaifa'ananau na Tagi ala Moses 'e fata 'ilo'oo, “Wane kwaifa'ananaunga, alata 'i'oo fata 'ilo'oo, 'i'oo fata ngada 'ameeru mola.” ");
INSERT INTO kwd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma la Jisas ka fata 'ilo'oo, “'Ola 'e ria famooru Wane ni Kwaifa'ananaunga na Tagi ala Moses, tofuna moru launge'enia tagi 'e 'ato 'e aula fana ta'a, ma ka 'ato iiki faga fana daunga suria, ma moru 'ame kwaibooni mola aaga. ");
INSERT INTO kwd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Ola lo'oo 'e ria la'u famooru, tofuna moru fa'akwasingaa mola fofona giru gwa'u na profet fana 'agila aga 'ani le'a. Ni profet laka'u wawarifu mooru gila kwa'iga. ");
INSERT INTO kwd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Suria ni 'ola lo'oo, gila faate'enia na'a mooru moru alafafia agelana 'ola na wawarifu mooru gila agea aga. Suria gila kwa'iaga, ma mooru moru launge'enia giru gwa'u aaga. ");
INSERT INTO kwd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma tofuna ni 'ola lo'oori, God na su'a'olanga aana, 'e fata 'ilo'oo, ‘Nau taku kwatea kau ni profet, ma nga Ta'a ni Kwairiinga kau faga, gwe 'ino'ona ma tagila kwa'ia tani wane aaga, ma tagila malate'ote'o la'u na tani wane aga.’ ");
INSERT INTO kwd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Suria ngaia 'e 'ilo'oo, nga ta'a na gila momoori na alata lo'oo, God te'e kwatea kwa'ikwa'inga faga fana kwa'ilana ni profet te'efou, 'e 'ita no'o mai na etalana fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eta no'o mai na maenga ana la Ebol leleka maka nigi na maenga ana la Sekaraea nga wane laka'u gila kwa'ia 'ubulana 'Ifi Abu na God, 'i laloana uumu ma nga lefu 'e abu. 'Ola kwala'imori na'a 'inau ku iiria famooru, nga ta'a gila momoori na alata lo'oori, God te'e kwatea kwa'ikwa'inga faga tofuna nga maenga ana ta'a laka'u. ");
INSERT INTO kwd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“'Ola 'e ria famooru Wane ni kwaifa'ananaunga na Tagi, tofuna mooru moru na'agonia nga kwala'imoringa na God, fana nga ta'a lo'oo 'e 'ato 'agila su'a la'u mola ai. Ma moru 'ame fito'o la'u mola ai, ma mooru moru ruia nga ta'a fa'asia su'anga na 'ola lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma nga alata lo'oo la Jisas 'e leka no'o fa'asia fanua lo'oo, ni Wane ni Kwaifa'ananaunga na Tagi ala Moses, ma nga Farasii, gila ka eta no'o fana ngengelana, ma gila ka orisia na 'ola 'e aula. ");
INSERT INTO kwd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma gila ka irito'ona fana fa'abobolosilana la Jisas fana 'agila daria tani 'ola ngaia 'e iiria 'e kuta. ");
INSERT INTO kwd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na nga alata no'ona la'u mola, ta'a auaula gila ogu mai te'ala Jisas. Ta'a lo'oo gila aula ma gila kwaibebesi kwairiu no'o aga. La Jisas ngaia ka alafuu 'ilo'oo fana fufu'iwane aana, “Mooru 'abelo 'ania mooru fa'asia longonga suria funi'oonga 'e ria na nga Farasii, suria 'i gila ta'a na kotonga. ");
INSERT INTO kwd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta 'olataa na ta'a na kotonga gila na'agonia, God te'e faate'enia 'i maa. Ma nga 'olataa ne'e nagwa, ta'a tagila su'a la'u mola ai. ");
INSERT INTO kwd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma te'efuta 'ola na'a moru alafuu suria 'i 'ubulana logo, tagila longoa la'u mola 'ubulana gagani. Ma nga 'olataa na'a moru kwalanguru 'ania 'i aringana wane na lefu tala moo'o, God te'e kwairii ai te'ana ta'a te'efou fana 'agila longoa.” ");
INSERT INTO kwd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","La Jisas ka fata la'u 'ilo'oo, “Nau ku iiria famooru ta'a kwaimaanga agu, moru sia ma'unge'enia mola ni dai na'a te'e kwa'ia noni mooru, ma ngaia 'e 'ato fana 'agila agea te'efuta 'ola 'e ria na mango mooru. ");
INSERT INTO kwd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tafe'ua, 'inau 'aku faate'enia famooru wane na'a 'amooru ma'unia na God. Moru su'aai ngaia no'o 'e su'asuria 'ani kwa'ia noni mooru, ma ngaia ne'e to'o na tegelangaa fana to'osilana mango mooru 'ubulana lefu ni kwa'ikwa'inga. Kiu, nau ku iiria famooru, God 'i talana no'o na tamooru ma'unge'enia. ");
INSERT INTO kwd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nga nima me'e suba gila foriga mola 'ania te'e rua fe'e seleni sisika. Nga suba gila ka sisika, tafe'ua ma God 'e 'ato 'ani nabolosia te'efuta me'e suba momola 'i laloaga. ");
INSERT INTO kwd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gwa'a nga ifuifu na gou mooru, God 'e su'a la'u mola aga te'efou. Ngaia na mooru sia ma'u, suria God ngaia manata ba'ita na ta'a te'efou 'e riufia ni suba 'e aula lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sui ma la Jisas ka fata la'u 'ilo'oo, “Nau ku iiria famooru, lauta nga wane 'e foule'eni nau 'i na'ona ta'a na'a ngaia nga wane ni lekanga 'i burigu, 'inau, nga Wela na Wane taku foule'enia la'u mola 'i na'ona enselo na God. ");
INSERT INTO kwd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma lauta ta wane ngaa'i 'e gwalaa nau 'i maana ta'a, nau taku gwalaa la'u mola 'i na'ona nga enselo na God. ");
INSERT INTO kwd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ma lauta te'efuta wane 'e fata ngada nau, God 'e su'asuria 'ani 'olafanataa na rianga ana. Tafe'ua, ma lauta te'efuta wane 'e fata ngadaa nga taunga'inga na Anoe 'ola Abu, ngaia 'e 'ato 'e iiki fana God 'ani 'olafanataa na wane 'ino'ona. ");
INSERT INTO kwd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma tagila ngaria mooru fana malate'ote'onga amooru 'i 'ubulana 'ifi ni fo'anga ma 'i na'ona ta'a ba'ita. Na nga alata no'ona, moru sia ma'u, ma moru sia manata 'abelo fana te'efuta alafuunga na 'amoru iiria, ma moru ka lamadu'aga 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Suria alata no'ona, nga Anoe 'ola Abu te'e fa'ananaua 'amooru 'ania 'olataa na'a tamooru iiria.” ");
INSERT INTO kwd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te'e wane 'i 'ubulana ogunga no'ona, ngaia 'e fata 'ilo'oo fala Jisas, “Wane kwaifa'ananaunga, 'oi iiria fala o'agu 'ani to'ole'enia nga 'ola'angaa amee'e na'a ma'a amee'e 'e 'akwasia 'i lalo 'amee'e.” ");
INSERT INTO kwd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma la Jisas ka fata 'ilo'oo, “Welakau, ni dai ne'e kwatea nga tegelangaa fagu fana kwaisufaingaa ma fana dalo'ilana nga 'ola 'ilo'oo 'i laloamoo'o?” ");
INSERT INTO kwd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma ngaia ka fata 'ilo'oo fagaa'a te'efou, “Moru manata le'a, fa'asia moru ta to'o na mango 'e wane fana 'etelanga. Tofuna nga mooringa kwala'imori na wane ngaia 'e 'amoe na bata ma 'ola'angaa aana.” ");
INSERT INTO kwd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","No'ona la Jisas ka fata 'ania tarifulaa faga maka 'ilo'oo, “Te'e wane dari'ola ngaia 'e to'o na te'e me'e wado le'a ne'e kirua 'ola 'i 'ubulai, ma ka gonia ni 'ola le'a 'e aula ne'e kirua 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma ngaia 'e to'oru maka manata suria 'i ngaia talana ma ka 'ilo'oo, ‘'Olataa na'a 'aku agea la'u? Tofuna 'inau ku 'ame to'o no'o na ta lefu fana tainge'enilana ni 'ola lo'oo agu. ");
INSERT INTO kwd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nau taku age 'ilo'oo, nau taku osia nga babala lo'oo agu fana gonilana ni 'ola 'i 'ubulai, sui ma 'inau taku launge'enia la'u me'e babala fooru ne'e ba'ita iiki. Ma 'inau taku bi'i gonia mai nga lodona 'ai lo'oo agu ma ni 'ola ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sui ma 'inau taku bi'i fata 'ilo'oo fagu talagu, ‘Aile'anga ba'ita famu! 'I'oo to'o no'o na 'ola le'a 'e aula na'a 'i'oo siria suria nga farisi 'e aula. 'Oi nana'i moko mamalo no'o! 'Oi keto le'a mola, moko go'u le'a mola, ma 'oi agea mola ni 'ola lo'oo fana mangomu 'ani aile'a fe'enia.’” ");
INSERT INTO kwd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tafe'ua, ma God 'e fata 'ilo'oo fana, ‘'I'oo wane 'i'oo kakakula 'e iiki! 'Ubulana fe'e logo lo'oo tala'ina la'u mola na'a 'i'oo to'o mae, ma to'o bi'i 'ame su'aai ni dai na'a te'e to'o na ni 'ola lo'oo 'i'oo gonia famu 'i talamu.’” ");
INSERT INTO kwd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma la Jisas ka fa'asuia no'o nga kwaifa'ananaunga lo'oo maka 'ilo'oo, “Ngaia te'e lau 'ilo'oo la'u fana nga ta'a na'a gila gonia 'ola te'efou no'o faga 'i talaga, ngaia 'ame to'o na dari'olanga 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sui mala Jisas ka fata 'ilo'oo fana fufu'iwane aana, “Nau ku iiria famooru, mooru sia manata 'abelo mola suria 'olataa na'a tamooru 'ania, ma 'olataa na'a tamooru ru'ufia fafia noni mooru. ");
INSERT INTO kwd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tofuna nga mooringa lo'oo, 'e le'a iiki talariufia nga fangalaa, ma nga labe'e wane ne'e le'a 'e iiki riufia nga ruu. ");
INSERT INTO kwd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Agasia nga langasi gila 'ame 'abelo mola suria taunga'inga na nga langa'a. Ma gila 'ame goni'i mola te'efuta fangalaa, ma gila 'ame launge'enia mola ta babala fana arulana fangalaa. Tafe'ua, ma God 'e langoniga mola. Ma God 'e manata famooru 'e ba'ita 'e riufia nga langasi. Ngaia lo'oo, God te'e langonia 'amooru la'u mola 'ino'ona. ");
INSERT INTO kwd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Tafe'ua, mooru moru manata 'abelo 'ania mango mooru, ngaia 'e 'ato 'e iiki 'amooru agea moori lamooru 'ani lalau sisika la'u. ");
INSERT INTO kwd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma lauta 'e 'ato fana 'amooru to'omia agelana ta 'ola sisika 'ilaka'u fa'atekwalana moori lamooru, 'uta'i na'a moru manata 'abelo mola na 'ola matari? ");
INSERT INTO kwd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Moru agasia madi nga 'ai lo'oo gila lama. Gila 'ame taunga'i, ma gila 'ame launge'enia mola te'efuta ruu faga 'i talaga. Ma 'inau ku iiria famooru, gila aga kwanga'a maka iiki riufia ruu na la kiingi Solomon ngaia 'e ru'ufia. ");
INSERT INTO kwd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma ni lamalama na 'ola lo'oo gila to'oru mola suria te'e alata sisita, ma gila ka 'ui mola 'ania 'ubulana eele. Tafe'ua, ma God 'e fa'aruufiga 'ania ni 'ola 'e le'a te'efou. 'Ilo'oo ma ngaia 'ato fana God 'ani fa'aruufia mooru? Nga fito'onga 'amooru 'e sisika. ");
INSERT INTO kwd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Moru sia manata 'abelo mola suria 'olataa na tamooru 'ania, ma 'olataa na'a tamooru go'ufia. ");
INSERT INTO kwd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tofuna nga wane ne'e bobolosia God na gila su'asuria 'agila manata 'abelo suria ni 'ola lo'oo. Ma 'amooru, Mama'a 'amooru ngaia su'aai 'e sui no'o na 'i mooru moru bo'obo'o fana ni 'ola lo'oori te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mooru manata madi suria nga mooringa na'a God 'e ba'ita fafia, ngaia te'e kwatea ni 'ola na'a moru bo'obo'o fai famooru.” ");
INSERT INTO kwd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sui mala Jisas ka fata la'u 'ilo'oo, “'Amooru fu'uwane agu, tafe'ua moru 'ilaka'u no'o nga dale'e sifisifi sisika, moru sia ma'u mola, tofuna God nga Mama'a amooru, ngaia 'e aile'a ba'ita fana 'ani ba'ita fafia 'amooru furifuri. ");
INSERT INTO kwd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mooru fa'afori 'ania ni 'ola amooru, ma moru ka kwatea bata fana ta'a na gila galafa. Lauta moru agea 'ilo'oo, tamooru to'o na wa'i fana gonilana bata 'i Langi ne'e 'e 'ato 'ani fula. Ta'a mooru gonia nga 'ola'angaa 'amooru 'i Langi, na lefu ne'e 'ato 'agila fa'asuia, ma nga lefu na'a ta'a beriberi sia nigi la'u ai, ma rimerime sia ngadaa mola. ");
INSERT INTO kwd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tofuna alata nga 'ola'angaa 'amooru 'e nana'i 'i Langi, nga moori lamooru ngaia 'e rugata'i te'efou no'o fani Langi. Ma alata nga 'ola'angaa 'amooru 'e nana'i fofona fanua lo'oo 'i wado, nga moori lamooru te'e rugata'i te'efou no'o fana ni 'ola fofona nga fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ta'a mooru agaaga fana 'olataa na te'e nigi mai. Ma moru ka ru'ufia nga ruu 'amooru, ma moru ka lalaua nga uunu 'amooru, ");
INSERT INTO kwd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'ilaka'u la'u wane ni taunga'inga na'a gila mamania nga wane ba'ita aaga na'a te'e ori mai fa'asia nga fafangalaa na fuageninga. Alata 'e nigi mai ma ka igiigi, gila 'afe'aferu ma gila ka 'ulasia no'o nga sinamaa fana. ");
INSERT INTO kwd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aile'anga fana nga wane ni taunga'inga lo'oo na'a wane ba'ita aaga 'e nigi to'oga, ma gila ka aga aga mola 'ua, ma gila mamania na alata 'e ori mai ai. Nau ku iiria nga 'ola kwala'imori famooru, ngaia 'e sasari agau, ma ka fa'ato'orufiga te'efou, ma bi'i langoniga. ");
INSERT INTO kwd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aile'anga faga lauta ngaia 'e nigi to'oga gila mamania, lauta ngaia 'e nigi mai 'ubulana to'ofungana logo, 'amoe ma 'usu'usugani! ");
INSERT INTO kwd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Moru manata to'ona ni 'ola lo'oo, lauta nga wane na 'ifi ngaia 'e su'a na alata na'a wane beriberi 'ani nigi mai ai, te'e 'ato fana wane beriberi 'ani ru'u 'ubulana 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Amooru la'u mola, tamooru nana'i ni mamanilagu, nga Wela na Wane. Nau taku nigi mai na nga alata na'a moru 'ame madafia 'akui nigi mai ai.” ");
INSERT INTO kwd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","La Pita 'e fata 'ilo'oo, “Alafa, 'ilo'oo ma 'i'oo iiria nga tarifulaa lo'oo fana te'i meeru, 'amoe ma fana nga ta'a te'efou?” ");
INSERT INTO kwd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nga Alafa 'e lamadu'aa maka 'ilo'oo, “Nau ku iiria fana wane ne'e 'ilaka'u wane ni taunga'inga na'a ngaia 'e su'a'ola ma taunga'ilana 'e odo. Ma nga wane ba'ita ka arua ngaia 'ani aga suria nga ta'a ni taunga'inga lo'oo, ma ka kwatea nga fangalaa faga na alata fana fanganga. ");
INSERT INTO kwd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma le'anga fana nga ta'a ni taunga'inga lo'oo na'a wane ba'ita ngaia 'e daria, ma gila agea ni 'ola lo'oo na alata no'ona 'e nigi mai 'i 'ifi aana! ");
INSERT INTO kwd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nau ku iiria nga 'ola 'e kwala'imori famooru, nga wane ba'ita te'e arua ngaia 'ani aga suria ni 'ola aana te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tafe'ua, ma ngaia te'e ria 'e iiki lauta nga wane ni taunga'inga lo'oo 'e manata 'ilo'oo, ‘Nga wane ba'ita agu, nigilana mai 'e lalau 'ua,’ ma ngaia ka eta fana kwa'ilana ni wane ma ni geni ni taunga'inga no'ona, ma ngaia ka to'oru ni fanganga mola ma ka go'u mola na waeni ma gouna ka kuta no'o. ");
INSERT INTO kwd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sui ma nga wane ba'ita te'e nigi mai na gani na'a ngaia 'ame kwaimamani ai, ma nga alata na'a ngaia 'e bobolosia mola. Nga wane ba'ita te'e kwatea nga kwa'ikwa'inga ba'ita fana, ma ka arua na lefu fana wane na'a 'ame tagoto'o. ");
INSERT INTO kwd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma nga wane ni taunga'inga na ngaia 'e su'ana 'olataa na'a nga wane ba'ita 'e siria ngaia 'ani agea, tafe'ua ma ngaia 'ame sasari agau ma 'ame agea mola nga 'ola na'a wane ba'ita 'e siria, tagila kwatea kwa'ikwa'inga ba'ita fana. ");
INSERT INTO kwd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tafe'ua, ma nga wane ni taunga'inga na 'ame su'ana nga 'olataa na'a wane ba'ita 'e siria, ma ngaia ka agea 'ola ne'e to'omia 'agila kwa'ia fe'enia, tagila kwatea kwa'ikwa'inga sisika mola fana. “Lauta God 'e kwatea 'ola 'e ari'afu fana ta wane, God 'e siria wane no'ona 'ani orite'enia la'u mola 'ola 'e ari'afu fana. Ma lauta God 'e kwatea ni 'ola 'e aula iiki la'u fana ta wane ngaa'i, ngaia 'e siria la'u ni 'ola 'e aula 'e iiki la'u fa'asia wane no'ona.” ");
INSERT INTO kwd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","La Jisas ka fata la'u 'ilo'oo, “Nau ku leka mai fana do'ofilana nga fanua lo'o 'i wado, ma 'inau ku siria nga eele lo'oo 'ani eta 'ani nula no'o! ");
INSERT INTO kwd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nau taku leka 'ubulana nonifiinga ba'ita. Ma 'inau taku manata gelo no'o na nonifiinga ba'ita lo'oo leleka maka talariu! ");
INSERT INTO kwd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Ino'ona ma mooru moru madafia, 'inau ku nigi mai fe'enia aloalonga fofona fanua lo'oo 'i wado? 'Amoe! 'I nau ku nigi no'o mai fe'enia kwaitatari'anga. ");
INSERT INTO kwd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngaia eta na alata lo'oo maka ori 'ala'a, nga 'ifi na'a nima 'ola gila to'oru 'i 'ubulai, tagila tagala'i tofuna 'inau. Oru 'ola ngaa'i na ta gule'ola, ma rua 'ola na ta gula ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nga mama'a te'e orisu'usu'u fe'enia alakwa aana, ma ni wane alakwa tagila orisu'usu'u fe'enia mama'a aga. Ma nga tete'e tagila orisu'usu'u fe'enia nga lari'i aaga, ma nga geni lari'i tagila orisu'usu'u fe'enia tete'e aaga. Ma ni nonigeni tagila orisu'usu'u fe'enia fungonga, ma ni geni na gila foriga tagila orisu'usu'u fe'enia fungoga geni.” ");
INSERT INTO kwd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","La Jisas ka fata la'u fana ogunga lo'oo maka 'ilo'oo, “Lauta 'amooru agasia me'e kofa gila tata'e mai fa'asia sulana sina, tamooru su'asuria nga ne'u te'e to'o. Ma ngaia te'e ne'u kwala'imori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma lauta nga iru 'e tata'e 'ala'a mai, tamooru su'aai la'u mola ngaia te'e 'ago'ago. Ma ngaia te'e 'ago'ago kwala'imori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amooru nga ta'a na kotonga, tofuna 'amooru moru su'a suria agasilana kofa fe'enia nga fanua lo'oo 'i wado, ma moru 'ame aga su'a mola na 'ola lo'oo God 'e agea na alata lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","La Jisas 'e fata la'u maka 'ilo'oo, “'Uta'i na'a mooru 'ame 'efasia famooru fana 'olataa ne'e odo fana agelai? ");
INSERT INTO kwd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lauta ta wane 'e fee'o fana kwaisufaingaa, 'i'oo to'o irito'ona fana fa'aodolana 'ola 'i laloamoo'o 'i na'ona na kwaisufaingaa. Tofuna lauta 'i'oo 'ame age 'ilo'oo, ma ngaia ka fee'o te'ana wane ni kwaisufaingaa, ma 'i burina ngaia te'e sufa'o, ma ngaia te'e kwate'o la'u fana ni wane ni fununga, ma ni wane ni fununga te'e aru'o la'u 'ubulana lokafu. ");
INSERT INTO kwd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma 'inau ku iiria famooru, lauta ngaia 'ilo'oo, ngaia 'e 'ato 'e iiki fana 'i'oo 'ani ru'u fa'asia nga lokafu, leleka ma to'o kwatea nga bata 'i'isi amu ne'e to'omia kwa'ikwa'inga amu.” ");
INSERT INTO kwd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma alata no'ona la'u mola, tani wane na gila nana'i no'ona, gila kwairii te'ala Jisas suria ta'a fa'asia 'i Galili na la Paelat 'e kwa'iga ma gila ka mae no'o, alata gila tabo fana God. ");
INSERT INTO kwd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma la Jisas ka fata 'ilo'oori, “'Uta'i? Tofuna na gila kwa'ia ta'a no'ona, mooru moru madafia gila na ta'a na'a rianga aaga 'e ba'ita riufia ta'a 'i Galili te'efou? ");
INSERT INTO kwd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Amoe! Nau ku iiria famooru, lauta moru 'ame bulota'i 'aferu fa'asia nga rianga 'amooru, mooru te'efou na tamooru mae la'u mola 'ilaka'u 'i gila. ");
INSERT INTO kwd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ta'a mooru manata 'uta'i suria nga akwale'e wane ma kwaruai laka'u gila ngai 'ubulana fanua 'i Saelom laka'u nga 'ifi ba'ita 'e 'esia fafiga, ma gila ka mae te'efou? 'Ilo'oo ma, mooru madafia ni 'ola lo'oo ngaia 'e faate'enia gila na ta'a gila ria, 'e riufia ta'a gila to'oru lo'oo 'i Jerusalem? ");
INSERT INTO kwd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Amoe! Nau ku iiria famooru, lauta moru 'ame bulota'i 'aferu fa'asia nga rianga 'amooru, mooru te'efou tamooru mae la'u mola 'ilaka'u 'i gila.” ");
INSERT INTO kwd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sui ma la Jisas ka alafuu 'ilo'oo faga 'ania tarifulaa lo'oo maka 'ilo'oo, “Te'e wane ngaia 'e kirua nga 'ai na gila fa'alataa 'ania nga figi 'i 'ubulana nga langa'a aana. Na te'e alata ngaa'i, ngaia 'e leka ma ka kwailo 'ofia nga lode 'ola 'i gouna 'ai no'ona, ma ngaia 'ame agasia no'o ta lode 'ai ai. ");
INSERT INTO kwd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma ngaia ka fata 'ilo'oo fana nga wane ni taunga'inga 'i 'ubulana nga langa'a aana, ‘Agasia madi, oru farisi nau ku aga aga fana nga lode 'ai, ma 'inau ku 'ame agasia no'o ta lode 'ai. 'Oi tofua no'o! 'Uta'i na ngaia 'e nana'i mola fana to'ofonosilana nga wado fana taunga'inga?’ ");
INSERT INTO kwd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tafe'ua, ma wane ni taunga'inga no'ona 'e lamadu'aa maka fata 'ilo'oo, ‘Welakau, 'oi alamia nga 'ai lo'oo 'ani nana'i madi suria te'e fe'e farisi ngaa'i. Nau taku 'eri wadona, ma 'akui 'ui 'ania tafu 'i 'a'aena, madi fana 'ani agea wado lo'oo 'ani le'a. ");
INSERT INTO kwd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma lauta nga 'ai lo'oo 'e fungu 'ania ta lode ai na farisi lolo'o mai, ma ngaia 'e le'a. Ma lauta 'e 'amoe no'o, ma to'o bi'i tofua bu'i.’” ");
INSERT INTO kwd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na nga te'e Sabat, la Jisas 'e kwaifa'ananau 'i 'ubulana nga 'ifi ni fo'anga na Jiu. ");
INSERT INTO kwd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma me'e noni 'e to'oru no'ona na adalo 'e fa'abo'ua surina, maka fii suria akwale'e farisi ma kwaruai ma 'ato no'o 'ani ula odoodo. ");
INSERT INTO kwd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma alata la Jisas 'e agasia, ngaia 'e soea mai te'ana maka fata 'ilo'oo fana, “'I'oo gwari'a no'o fa'asia nga fiinga lo'oo 'e lau amu.” ");
INSERT INTO kwd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma ngaia ka arua nimana 'i fofona, ma te'e alata no'ona mola, nga noni lo'oo ka tata'e odoodo no'o, maka baole'a no'o fana God. ");
INSERT INTO kwd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Alata wane na'ona'o na 'ifi na fo'anga lo'oori ngaia 'e agasia la Jisas 'e agea nga 'ola lo'oo fana noni lo'oo na Sabat, nga gani na mamalongaa, ngaia ka ogaria ba'ita, ma ka fata 'ilo'oo fana wane no'ona, “Ono ma'e gani na'a fana agelana taunga'inga 'amooru ai. Ma ni gani no'ona na'a, tamooru leka mai fana gulanga. Mooru sia leka mola mai fana gulanga na Sabat.” ");
INSERT INTO kwd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma nga Alafa la Jisas 'e lamadu'aa maka fata 'ilo'oo, “Mooru nga ta'a na kotonga! Tofuna mooru fini agea mola taunga'inga alata moru rubea nga buruka ma dongki 'amooru, ma moru ka talaiga mola fana nga ka'o fana fa'ago'ufilaga na Sabat gani na mamalonga. ");
INSERT INTO kwd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma nga noni lo'oo, ngaia nga noni na fufutanga adauru ala Ebraham la'u mola, ma la Saetan ka gau mai fafia 'ania fiinga suria akwale'e farisi ma kwaruai. Ma 'e le'a fana 'aku gulaa nga fiinga lo'oo fa'asia na gani lo'oo na Sabat.” ");
INSERT INTO kwd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Alata la Jisas 'e fata 'ilo'oo, nga marimae aana gila ka maila no'o, ma nga ta'a lo'oo gila ka baole'a mola, suria ni 'ola ni 'alefosilai lo'oo na'a la Jisas 'e agea. ");
INSERT INTO kwd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","La Jisas 'e alafuu la'u maka fata 'ilo'oo, “Nau taku alafuu la'u kau 'ania me'e tarifulaa ne'e faate'enia nga 'ola ne'e toto'o fe'enia God 'ani ba'ita fafia nga ta'a ngai aana. ");
INSERT INTO kwd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngaia 'e 'ilo'oo: Te'e wane 'e ngaria nga 'uu'uui'ola sisika lo'oo gila fa'alataa 'ania mastad, ma ngaia ka kirua 'ubulana langa'a aana. Sui ma ngaia ka bila'o mai, maka lau na nga 'ai ba'ita, ma nga langasi 'e aula gila leka mai, ma gila ka nana'i, ma gila ka launge'enia nga nuu'i aaga na lalana 'ai lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma la Jisas ka fata la'u 'ilo'oo, “Nau taku alafuu la'u kau suria me'e tarifulaa ne'e faate'enia nga 'ola ne'e toto'o fe'enia God 'e ba'ita fafia nga ta'a aana. ");
INSERT INTO kwd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngaia 'e 'ilaka'u nga iist sisika fana fa'afanelana nga beret na nga noni 'e ngaria, maka dolaa fe'enia nga flaoa 'e aula, leleka maka fane no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Alata la Jisas 'e leka fani Jerusalem, ngaia 'e leka 'afu'afutana no'o maa'e fanua ba'ita ma ni maa'e fanua sisika lo'oo, maka fa'ananaua ta'a 'e aula no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma te'e wane ka orisia 'ilo'oo, “Alafa, 'ilo'oo ma ni ta'a tarito'o mola na'a God te'e fa'amooriga?” La Jisas 'e lamadu'aa maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nau ku iiria famooru, moru su'usu'u fana ru'unga na sinamaa ne'e sisika 'i Langi. Tofuna nga ta'a 'e aula tagila su'usu'u fana nga ru'unga, ma te'e 'ato 'e iiki faga tofuna nga sinamaa te'e fono 'usiga. ");
INSERT INTO kwd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Alata nga wane ba'ita na 'ifi 'i Langi ngaia te'e tata'e, maka fono 'usia nga sinamaa, tamooru ula 'i maa, ma tamooru igiigi 'i maa, ma tamoru fata 'ilo'oo, ‘Welakau, 'oi 'ulasi kau fameeru.’ Tafe'ua, ma ngaia te'e lamadu'aa 'ilo'oo, ‘'Ato no'o. Nau ku 'ame su'a 'amooru, ma ku 'ame su'asuria lefu na moru leka mai fa'asia.’ ");
INSERT INTO kwd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sui ma tamooru lamadu'aa 'ilo'oo ana, ‘Meeru meru keto fe'eni'o, ma meru ka go'u la'u mola fe'eni'o, ma 'i'oo ko kwaifa'ananau 'i 'ubulana nga fanua ameeru lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tafe'ua, ma ngaia te'e fata 'ilo'oo, ‘Mooru nga ta'a moru ria, moru leka lalau kau fa'asi nau. Nau ku 'ame su'a amooru, ma 'inau ku 'ame su'ana lefu lo'oo moru leka mai fa'asia.’ ");
INSERT INTO kwd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma tamooru agasia la Ebraham ma la Aesak, ma la Jekob, ma profet te'efou 'i 'ubulana foufoula na God. Tafe'ua, ma God te'e to'osi 'amooru 'i maa, tamooru kwaimanadai, ma tamooru aani, ma tamoru ka girinifo! ");
INSERT INTO kwd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma nga ta'a tagila nigi mai fa'asia afirina lefu te'efou fofona fanua lo'oo 'i wado, tagila ogu na fafangalaa lo'oo 'i 'ubulana foufoula na God. ");
INSERT INTO kwd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Suria nga ta'a na'a gila 'i buri na alata lo'oo, tagila eta 'i na'o. Ma nga ta'a na'a gila eta 'i na'o na alata lo'oo, tagila ole lau 'i buri.” ");
INSERT INTO kwd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na nga alata no'ona, tani Farasii ngai gila leka mai te'ala Jisas, ma gila ka fata 'ilo'oo fana, “'Oi leka fa'asia lo'oo fana ta fanua ngaa'i matari, tofuna la Herod nga kiingi 'e siria kwa'ilamu 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma la Jisas ka fata 'ilo'oo, “La Herod ngaia 'ilaka'u nga ku'ito kwasi, tofuna kotolana 'e ba'ita. Moru leka moru iiria te'ana, ‘Tala'ina fe'enia 'igani, 'inau taku agea la'u mola nga taunga'inga agu na belote'enilana adalo 'e ria, ma gulalana fifiinga. Ma nga oruna gani, nau taku bi'i fa'asuia nga taunga'inga agu.’ ");
INSERT INTO kwd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tafe'ua, ma 'inau taku leka kwairiu mola 'i Jerusalem tala'ina lo'oo, mai gani, ma 'ubulana ni gani lolo'o kau. Tofuna ngaia 'e 'ato fana 'agila kwa'ia nga profet na te'efuta fanua matari, 'ola furia te'e Jerusalem no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ma la Jisas ka fata la'u 'ilo'oo, “Ta'a 'i Jerusalem! Mooru moru 'ilaka'u moru 'ui fou na profet laka'u na God ngaia 'e aleaga mai te'amooru, ma moru ka kwa'inga mola. Na nga alata 'e aula 'inau ku siria 'amoru leka mai te'agu, madi fana 'aku aga suri 'amooru 'ilaka'u nga susuki 'e gwaesia nga dadalena 'i olofana 'aba'abana. Tafe'ua, mai 'amooru moru 'ame siria mola. ");
INSERT INTO kwd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma nga alata lo'oo, God te'e leka fa'asi 'amooru, ma ka rugasia fanua mooru. Mai nau ku iiria famooru, moru sia agasi nau la'u, leleka maka nigi na alata na tamooru fata 'ilo'oo, ‘God 'oi nanamate'enia nga wane ne'e leka mai 'ania nga latamu!’” ");
INSERT INTO kwd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na nga Sabat, la Jisas 'e leka fana 'ani keto na 'ifi na te'e wane na'ona'o na Farasii. Nga alata no'ona, nga ta'a te'efou gila ka aga aga fana 'agila agasia 'olataa lo'oo ngaia te'e agea. ");
INSERT INTO kwd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma te'e wane na rua nimana ma rua 'a'aena 'e uubu 'e iiki, ngaia 'e leka mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma la Jisas ka orisia tale'e Farasii lo'oo ma nga ta'a ni kwaifa'ananaunga na Tagi ala Moses maka 'ilo'oo, “Nga tagi adauru 'e alamia mola 'agoru gulaa nga wane fii na Sabat, 'amoe ma 'amoe no'o?” ");
INSERT INTO kwd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tafe'ua, ma gila 'ame lamadu'aa no'o. Sui mala Jisas ka gema to'ona wane lo'oo 'e fii, ma ngaia ka gwari'a no'o, ma la Jisas ka alamia 'ani leka no'o. ");
INSERT INTO kwd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sui mala Jisas ka orisiga 'ilo'oo, “Lauta te'efuta wela amu 'amoe ma buruka amu, 'e 'esia 'i 'ubulana nga kiru na Sabat, 'i'oo su'asuria to'o leka 'ani lafua mola?” ");
INSERT INTO kwd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma nga alata la Jisas 'e orisia 'ilo'oo, ta wane 'ame lamadu'aa no'o. ");
INSERT INTO kwd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma alata la Jisas 'e agasia nga ta'a na'a gila nigi mai fana fafangalaa, ma gila ka eefaa no'o lefu ne'e le'a fana to'orunga, ngaia ka fata 'ania tarifulaa lo'oo faga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Alata te'efuta wane 'e laefi'o fana ta fafangalaa na fuageninga, 'i'oo sia to'oru mola na lefu ni to'orunga na wane na'ona'o fa'asia gila ta laefiia ta wane ngaa'i ne'e taringa'i 'e riufi'o. ");
INSERT INTO kwd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma nga wane ne'e laefi'o mai 'e nigi mai, maka fata 'ilo'oo famu, ‘'Oi tata'e madi, fana wane lo'oo 'ani to'oru no'ona.’ Lo'oo 'i'oo to'o bi'i maila ba'ita, tofuna gila 'idu'o 'ani to'oru na lefu fana nga wane ngai 'ame to'o na lata. ");
INSERT INTO kwd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Alata nga wane 'e laefi'o, to'oru mola na nga lefu 'ame taringa'i, ma alata nga wane ne'e laefi'o mai 'e nigi, ngaia te'e fata 'ilo'oo famu, ‘Welakau, 'idu mai fana lefu 'e le'a lo'oo.’ Lo'oo, ngaia 'e fa'aba'ita'o 'i maana nga ta'a ne'e ogu no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","'I'oo su'aai nga wane ne'e fa'aba'ita 'i talana, God te'e fa'asifoa. Ma nga wane ne'e fa'asifoa 'i talana, God te'e fa'aba'ita.” ");
INSERT INTO kwd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sui mala Jisas ka fata 'ilo'oo fana nga wane lo'oo 'e launge'enia nga fafangalaa lo'oo, “Alata 'i'oo launge'enia ta fafangalaa, 'i'oo sia laefiia mola mai ta'a ni kwaimaanga amu, ma ta'a ni futangamu, 'amoe ma te'e ta'a na'a gila dari'ola'a na'a gila to'oru galangi'o. Tofuna gila su'aai tagila launge'enia ta fafangalaa ngaa'i, ma tagila laefi'o la'u mola fana du'ulana la'u ni 'ola na 'i'oo agea faga. ");
INSERT INTO kwd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tafe'ua, alata 'i'oo launge'enia nga fafangalaa, to'o laefiia mai nga ta'a galafa'a, ma nga ta'a na 'a'aega 'e mae ma nimaga 'e mae no'o, ma nga ta'a na'a maaga 'e logo. ");
INSERT INTO kwd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lauta 'i'oo agea 'ilo'oo, nga aile'anga famu. Tafe'ua, 'e 'ato no'o 'agila du'u famu, God te'e du'u no'o famu, na alata na'a ta'a 'e odo 'agila tata'e la'u fa'asia nga maenga.” ");
INSERT INTO kwd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma nga alata lo'oo, te'e wane na ta'a lo'oo gila to'oru fana fanganga, ngaia 'e longoa 'olataa na'a la Jisas 'e iiria, ma ngaia ka fata 'ilo'oo, “Nga aile'anga fana ta'a na'a gila keto na fafangalaa 'i 'ubulana foufoula ana God.” ");
INSERT INTO kwd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma la Jisas ka fata 'ilo'oo, “Na te'e alata ngaa'i, te'e wane ngaia 'e launge'enia te'e fafangalaa ba'ita, maka laefiia mai ta'a 'e aula fana fafangalaa lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma alata ni 'ola te'efou 'e sasari no'o, ngaia ka alea nga ta'a ni taunga'inga aana 'agila leka fana soelana mai nga ta'a na ngaia 'e soega fana 'agila leka mai. Ngaia ka fata 'ilo'oo, ‘Ta'a mooru leka no'o mai, suria ni 'ola te'efou 'e sasari 'e sui no'o.’ ");
INSERT INTO kwd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tafe'ua, ma gila ka eta 'agila fofo no'o 'usiga, gila iiria ni 'ola ngaa'i ngaia 'e kotega na'a ngaia 'e 'ato 'agila leka mai. Te'e wane ngai 'e fata 'ilo'oo, ‘Nau ku bi'i foria mola me'e wado, mai nau ku siria 'aku leka fana 'aku agasia madi. To'o kwairii te'ana, nau ku kwaimanadai ba'ita.’ ");
INSERT INTO kwd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ruana wane ka fata 'ilo'oo, ‘Nau ku bi'i foria mola akwale'e buruka, mai nau ku siria 'aku leka fana 'aku su'ato'oga madi, bala gila taunga'i 'e le'a mola 'amoe me'e 'amoe. To'o kwairii te'ana nau ku kwaimanadai ba'ita nau ku sia leka mola kau.’ ");
INSERT INTO kwd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma oruna wane ka fata 'ilo'oo, ‘Nau ku bi'i fuageni fooru mola, ma ngaia 'e 'ato 'e iiki fagu fana lekanga kau.’ ");
INSERT INTO kwd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Alata no'ona wane ni taunga'inga aana 'e ori mai, maka kwairii te'ana wane ba'ita aana 'ania ni 'ola lo'oo, wane ba'ita lo'oo ngaia 'e ogaria ba'ita, maka fata 'ilo'oo fana wane ni taunga'inga aana, ‘'Oi leka 'afe'aferu suria tala ba'ita lo'oo, ma suria tala sisika, moko soea mai nga ta'a gila galafa'a ma nga ta'a na 'a'aega 'e mae ma nimaga ka mae, ma nga ta'a maaga 'e logo, fe'enia ta'a te'efou na'a noniga 'e mae.’ ");
INSERT INTO kwd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Alata wane ni taunga'inga lo'oori 'e ori mai, ngaia 'e fata 'ilo'oo fana wane ba'ita aana, ‘Welakau, 'ola laka'u 'i'oo iiria fagu, nau ku age te'efou no'o ai, ma lefu ni to'orunga fana fangalaa lo'oo amu 'ame fongu mola 'ua na ta'a. ");
INSERT INTO kwd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wane ba'ita lo'oo ka fata la'u 'ilo'oo, ‘To'o leka la'u suria ni tala sisika na'a gila nana'i lalau, 'oi laefiiga, moko 'unea la'u mai tani ta'a ngaa'i fana lekanga mai na 'ifi lo'oo agu 'ani fongu. ");
INSERT INTO kwd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma 'inau ku iiria famu, ngaia 'e 'ato 'e iiki fana ta wane na ta'a laka'u ku laefiiga mai 'i na'o, 'agila keto na fafangalaa lo'oo agu.’” ");
INSERT INTO kwd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na te'e alata ngaa'i, nga ogunga ba'ita gila leka fe'enia la Jisas. Ma ngaia 'e abulo maka fata 'ilo'oo faga, ");
INSERT INTO kwd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Te'efuta wane ne'e siria 'ani leka 'i burigu, ngaia 'ani kwaimaa fagu 'ani riufia nga mama'a aana, ma nga tete'e aana, ma nga noni aana, ma nga wela aana ma nga wanefutanga aana, ma nga wanena geni, ma ngaia 'i talana la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngaia 'e 'ato fana te'efuta wane 'ani lau fana wane ni lelekanga agu, lauta ngaia 'ame maabe fana ladonga agu, tafe'ua ngaia te'e nonifii, maka mae na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Lauta ta wane amooru ngaia 'e siria 'ani launge'enia nga 'ifi ba'ita, ngaia 'ani nana'i, maka manata madi suria nga bata ne'e to'o ai fana 'ani to'omia fana 'ani fa'asuia nga 'ifi lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lauta ngaia 'ame agea 'ilo'oo, ma ngaia 'ani arua no'o nga bou eteeta na 'ifi lo'oo te'efou, ma ta'a gila agasia ngaia 'ame to'o na bata ne'e to'omia fana nga fa'asuilai, tagila doo ana, ma tagila fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Nga wane lo'oo 'e eta fana launge'enilana nga 'ifi lo'oo, tafe'ua ma ngaia 'ame to'omia 'ani fa'asuia.’” ");
INSERT INTO kwd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma lauta ta kiingi ne'e leka fe'enia tani akwale'e to'oni (10,000) wane aana fana nga fununga fe'enia ta kiingi na ngaia 'e leka mai fe'enia nga rua akwale'e (20,000) to'oni wane aana fana fununga, ngaia 'ani to'oru madi 'i wado maka manata le'a suria fa'asia ngaia ta 'ame tegela'a 'ani to'omia funurilana nga kiingi ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma lauta 'amoe, ngaia 'ani kwatea ta wane aana, fana 'ani leka, maka alafuu fana nga aloalonga 'i laloagaa'a, na alata gila lalau 'ua mai. ");
INSERT INTO kwd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ka 'ilo'oo la'u mola, tamooru manata le'a madi suria nga nonifiinga na'a tamooru daria alata na 'amooru leka 'i burigu, lauta ta wane amooru ne'e 'ame rugasia ni 'ola ana te'efou 'i burina, ngaia 'e 'ato 'ani leka 'i burigu.” ");
INSERT INTO kwd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","La Jisas ka fata la'u 'ilo'oo, “Nga solti ngaia nga 'ola 'e le'a. Tafe'ua, lauta na'a asilalana 'e 'amoe no'o fa'asia, ngaia 'e 'ato no'o 'ani asila la'u. ");
INSERT INTO kwd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma ngaia 'ame le'a no'o fana agelai 'ania te'efuta 'ola la'u. Ngaia 'ame le'a no'o fana wado ma fana boonilana ta 'ola. Ma ngaia 'e to'omia fana 'agila to'osia mola. Moru gwaalongo le'a suria nga alafuunga lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na te'e alata ngaa'i, nga ta'a 'e aula na gila ngaria bata na takisi, ma ni ta'a ria la'u mola, gila leka fana gwalongosilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma nga Farasii lo'oo ma ta'a ni kwaifa'ananaunga na tagi ala Moses gila eta no'o fana kwaingu'ungu'uinga ma gila ka 'ilo'oo, “Nga wane lo'oo 'e kwaloa nga ta'a 'e ria lo'oo maka keto mola fe'eniga!” ");
INSERT INTO kwd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ngaia lo'oo la Jisas 'e fata 'ania ni tarifulaa lo'oo faga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Lauta ta wane amooru 'e to'o na nga tangale'e sifisifi, ma te'e 'ola momola ai ka foo, 'olataa na'a wane lo'oo te'e agea? Ngaia te'e 'akwasia nga mule akwala ma mule ai lo'oo ma ngaia te'e leka 'ani kwailo'ofia te'e ai ne'e foo, leleka ma ngaia ka daria. ");
INSERT INTO kwd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma alata lo'oo ngaia 'e daria, ngaia 'e aile'a ba'ita, maka ngaria 'i goulolona, ");
INSERT INTO kwd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","maka ngaria mai 'i fanua. Sui ma ngaia ka soea mai nga wane ni kwaimaanga aana, ma nga ta'a lo'oo 'i fanua aana fana 'agila ogu mai, ma ngaia ka fata 'ilo'oo faga, ‘Nau ku aile'a ba'ita, tofuna 'inau ku daria no'o nga sifisifi laka'u agu ne'e foo. Ngaia na'a tamooru aile'a fe'eninau!’” ");
INSERT INTO kwd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngaia na la Jisas 'e fata la'u 'ilo'oo, “Nau ku iiria famooru, nga aile'anga ba'ita ngaa'i la'u mola 'i Langi fafia te'e wane ne'e ria maka abulo fa'asia rianga aana. Nga aile'anga fe'enia, 'e riufia nga aile'anga fafia nga mule akwala ma mule wane na'a gila odo mola.” ");
INSERT INTO kwd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma la Jisas ka alafuu la'u 'ania tarifulaa maka 'ilo'oo, “Lauta me'e noni na'a ngaia 'e to'o na akwale'e fe'e seleni, ma te'e fe'e seleni ngaa'i 'e nagwa, 'olataa na'a ngaia te'e agea? Ngaia te'e lalaua uunu, maka salafia nga 'ifi lo'oo aana, maka kwailo na afirina lefu te'efou leleka ma ngaia ka daria. ");
INSERT INTO kwd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma alata ngaia 'e daria, ngaia 'e soea ni noni kwaimaanga aana te'efou, ma nga ta'a na fanua aana te'efou 'agila ogu mai te'ana, ma ngaia ka fata 'ilo'oo faga, ‘Nau ku aile'a ba'ita, tofuna 'inau ku daria no'o fe'e seleni laka'u agu ne'e nagwa. Ngaia na'a tamooru aile'a fe'eninau!’” ");
INSERT INTO kwd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma la Jisas ka fata la'u 'ilo'oo, “Nau ku iiria famooru, nga 'ola lo'oo 'e 'ino'ona la'u mola 'i Langi. God fe'enia nga enselo aana te'efou, gila aile'a ba'ita fafia te'e wane momola ne'e abulo fa'asia rianga aana.” ");
INSERT INTO kwd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma la Jisas ka fata la'u 'ania nga tarifulaa 'ilo'oo, “Te'e wane ngaia 'e to'o ana rua wela wane. ");
INSERT INTO kwd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nga wela 'i buri ngaia 'e fata 'ilo'oo fala ma'aa aana, ‘Mama'a, 'oi kwatea no'o mai nga gula ngai agu na 'ola'angaa amu.’ 'Ino'ona mola, nga wane lo'oo ka dalo'ia no'o nga 'ola'angaa laka'u aana 'i laloagaa'a rua alakwa lo'oo aana. ");
INSERT INTO kwd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma 'i burina tani gani ngaa'i 'e sui mola, nga alakwa laka'u 'i buri ka fa'afori no'o 'ania nga gule'ola na nga 'ola'angaa aaga, ma ka leka no'o fe'enia bata ngai ana. Ma ngaia ka leka no'o fana nga fanua lalau, maka ngadaa te'efou no'o nga bata laka'u aana na to'orunga 'e ria. ");
INSERT INTO kwd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mai burina ne'e fa'asuia nga bata laka'u aana, nga molo'unga ba'ita ka riu na gule'e lefu lo'oo ma ngaia ka 'ame to'o no'o na te'efuta 'ola. ");
INSERT INTO kwd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma ngaia ka leka te'ana te'e wane na fanua lo'oo 'ani daiorisia fana te'efuta taunga'inga fana, ma wane no'ona ka kwatea nga taunga'inga fana ngaia 'ani aga suria nga uumi'i boo aana. ");
INSERT INTO kwd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma ngaia ka 'ania no'o nga furufuruna fangalaa na nga fangalaa lo'oo na boo, ma te'efuta wane no'ona 'ame kwatea no'o nga fangalaa fana. ");
INSERT INTO kwd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tafe'ua, ma alata ngaia 'e manata folaa, ngaia bi'i fata 'ilo'oo fana 'i talana, ‘Nga ta'a ni taunga'inga na ma'aa agu, gila fangafanga le'a mola furifuri, ma gila ka botebote mola, ma 'inau lo'oo nau ku bi'i momolo'u mola fana nga maenga agu! ");
INSERT INTO kwd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngaia le'a fana 'inau 'akui ori te'ana ma'aa agu, ma taku fata 'ilo'oo fana, Mama'a, nau ku agea rianga ba'ita no'o 'i maana God, ma 'i mamu la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau ku 'ame to'omia no'o fana 'i'oo 'ani fa'alata nau la'u 'ania nga wela amu. To'o arua no'o 'inau 'akui taunga'i no'o famu 'ilaka'u nga wane ni taunga'inga amu.’ ");
INSERT INTO kwd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma ngaia ka tata'e, maka ori no'o te'ana mama'a aana. “Nga alata ngaia 'e lalau 'ua mai fa'asia 'i fanua, nga ma'aa aana 'e aga kau, maka agasia. Ma ngaia ka kwaimanadai ba'ita fana nga wela aana. Ma ngaia ka totola no'o kau, maka lolo'ia nga wela lo'oo aana, maka nono'ia. ");
INSERT INTO kwd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma nga wela lo'oori ka fata 'ilo'oo fana, ‘Ma'ana, nau ku agea rianga ba'ita no'o 'i maana God ma 'i mamu la'u mola. Nau ku 'ame to'omia no'o fana 'i'oo 'ani fa'alata nau 'ania wela amu.’ ");
INSERT INTO kwd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tafe'ua, ma la ma'aa aana 'e o'omaesia nga ta'a ni taunga'inga aana maka 'ilo'oo, ‘Moru 'aferu mai! Ma moru ka ngaria mai nga ruu tekwa ne'e kwanga'a le'a, ma moru ka fa'aruufia 'ania. Ma moru ka arua nga kome na nimana, ma moru ka arua butu 'i 'a'aena. ");
INSERT INTO kwd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sui ma, moru ka leka, ma moru kwa'ia nga buruka sisika kobukobu laka'u fana 'agoru launge'enia nga fafangalaa 'aguru aile'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tofuna nga wela agu, ngaia 'e 'ilaka'u nga wane 'e mae no'o, tafe'ua ma ngaia 'e moori la'u. Ma ngaia 'ilaka'u 'e foo no'o, tafe'ua ma 'inau ku daria no'o.’ Ma fafangalaa lo'oori ka eta no'o. ");
INSERT INTO kwd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma alata no'ona, nga wela ngai na'o laka'u ngaia 'e nana'i 'ua mai 'i 'ubulana nga langa'a. Nga alata na'a ngaia 'e ori mai ma ngaia ka nigi galangia mai 'ifi, ngaia 'e longoa nga ringena nga 'au ma nga wa'ewa'enga. ");
INSERT INTO kwd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma ngaia ka lalofia mai te'e wane ni taunga'inga maka orisia fana nga 'olataa lofo'u gila wa'e fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma nga wane ni taunga'inga lo'oo ngaia 'e lamadu'aa ma ka 'ilo'oori, ‘La asimu laka'u 'e ori no'o mai 'i fanua, ma la ma'aa amu 'e daua nga dalena buruka kobukobu laka'u, suria la asimu 'e moori, maka ori mai maka nigi no'o. ");
INSERT INTO kwd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma wela lo'oo 'i na'o 'e ogaria ma ka 'ame siria no'o ru'u nga kau 'ubulana 'ifi. Mala ma'aa aana ka ru'u mai maa, maka 'unea fana 'ani ru'u kau 'ubulana 'ifi. ");
INSERT INTO kwd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma ngaia ka lamadu'aa la ma'aa aana maka fata 'ilo'oo, ‘Agasia madi, nau ku taunga'i famu 'ilaka'u no'o nga wane ni taunga'inga tago amu suria ni farisi 'e aula lo'oo, ma 'inau ku lo'o suria nga fatalamu. Tafe'ua, 'i'oo 'ame kwatea mola ta nanigot fagu, fani nau 'aku agea ta fafangalaa fe'enia ni wane meru kwaikwaimaa ");
INSERT INTO kwd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tafe'ua, ma nga wela lo'oo amu, 'e ngadaa no'o nga 'ola'angaa amu na nga agemaninga ma alata 'e ori mai 'e nigi 'i fanua, 'i'oo kwa'ia mola nga dalena buruka 'e kobu le'a laka'u fana!’ ");
INSERT INTO kwd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mala ma'aa aana ka lamadu'aa maka 'ilo'oo, ‘Wela agu, 'i'oo nana'i furifuri mola fe'eni nau, ma ni 'ola agu te'efou, ni 'ola amu no'o. ");
INSERT INTO kwd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tafe'ua, dauru goru agea fafangalaa lo'oo, ma goru ka aile'a, suria la asimu laka'u 'e mae no'o, ngaia 'e moori la'u mola. Ma ngaia 'e foo no'o, tafe'ua ma alata lo'oo goru agasia la'u.’” ");
INSERT INTO kwd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","La Jisas 'e alafuu la'u 'ania te'e tarifulaa fana fufu'iwane laka'u aana maka 'ilo'oo, “Te'e wane dari'ola ngaia to'o na te'e wane ni taunga'inga na'a ngaia 'e arua 'e ba'ita fafia ni 'ola aana te'efou. Ma ta'a gila ka kwairii te'ana nga wane dari'ola'a lo'oo na'a wane ni taunga'inga aana, ngaia 'e ngadaa no'o nga 'ola'angaa aana. ");
INSERT INTO kwd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma nga wane dari'ola lo'oo ka soea mai wane ni taunga'inga aana maka orisia maka 'ilo'oo, ‘Nga 'olataa na'a ku longoa amu? To'o giria nga fita bata agu te'efou 'i'oo taunga'i 'ania, tofuna na'a 'i'oo sia aga la'u suria te'efuta 'ola agu.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ma nga wane ni taunga'inga lo'oo ka manata 'ilo'oo, ‘Nga wane ba'ita lo'oo agu te'e fa'asui nau no'o fa'asia nga taunga'inga lo'oo agu. Lo'oo ma 'olataa na'a taku agea no'o fana 'aku to'o na taunga'inga fooru? Nau ku 'ame tegela'a no'o fana agelana taunga'inga ba'ita 'ilaka'u 'erilana nga kiru ma ku maila ba'ita la'u mola fana kwaisoenga. ");
INSERT INTO kwd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nau ku su'asuria 'olataa na 'inau taku agea tofuna alata nau ku sui fa'asia nga taunga'inga agu, nga ta'a ngai tagila kwalo nau fana 'ubulana 'ifi aaga.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ma ngaia ka soea ni wane 'e aula na gila gania ni 'ola fa'asia nga wane ba'ita aana, ma ngaia ka fata 'ilo'oo fana nga wane eteeta. ‘Fita 'ola na'a 'i'oo gania fa'asia nga wane ba'ita agu?’ ");
INSERT INTO kwd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngaia ka lamadu'aa maka 'ilo'oo, ‘Rua tangale'e (200) balolo na waiwai na olif.’ Ma nga wane ni taunga'inga lo'oo ka fata 'ilo'oo fana, ‘Nga kake 'ola ana na 'i'oo ngaria lo'oo, 'i'oo to'oru, ma to'o giria te'e tangale'e (100) balolo lo'oo mola.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mai ngaia ka fata 'ilo'oo fana ruana wane ngaa'i, ‘Fita 'ola na'a 'i'oo gania?’ Mai ngaia ka lamadu'aa 'ilo'oo, ‘Nga te'e to'oni (1,000) wa'i na witi fana beret.’ Ma nga wane ni taunga'inga lo'oo ka fata 'ilo'oo fana, ‘Nga kake 'ola na 'i'oo kwaigani ai lo'oo, to'o giria kwaru tangale'e (800) 'ola.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nga wane ba'ita laka'u aana 'e baatafea nga wane ni taunga'inga lo'oo aana 'e lalakwa fana manata folaa nga lo'oo ngaia 'e agea. Tofuna nga ta'a lo'oo fofona fanua lo'oo 'i wado gila su'a'ola 'e iiki na ni 'ola fofona nga fanua lo'oo 'i wado lo'oo 'e riufia nga ta'a na nga lalanga. ");
INSERT INTO kwd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nau ku iiria famooru, tamooru kwatea nga dari'olanga amooru na nga fanua lo'oo 'i wado fana ta'a 'agila kwaimaa fe'eni 'amooru. Ma alata nga bata amooru 'e sui, God te'e kwaloa 'amooru 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ni dai na ngaia 'e taunga'i le'a ana 'ola sisika, ngaia te'e taunga'i le'a la'u mola na 'ola ba'ita. Ma ni dai ne'e 'ame taunga'i le'a na 'ola sisika, ngaia te'e 'ame taunga'i le'a la'u mola na 'ola ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka 'ilo'oo la'u mola, lauta moru 'ame taunga'i le'a na 'ola'angaa fofona fanua lo'oo 'i wado, God 'e 'ato 'ani tagoto'o 'amooru la'u mola fe'enia nga 'ola'angaa kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma lauta mooru 'ame taunga'i le'a 'ania 'ola na ta wane ngaa'i matari, God 'e 'ato 'ani kwatea la'u mola ta 'ola famooru 'i Langi. ");
INSERT INTO kwd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ngaia 'e 'ato fana ta wane ni taunga'inga 'ani taunga'i fana nga rua wane ba'ita kwaitatari. Lauta ngaia 'e 'ilo'oo no'o, ngaia te'e marimae na wane ba'ita ngai, ma te'e kwaimaange'enia nga wane ngaa'i. Ma ngaia te'e taunga'i 'e le'a fana ta wane ngaa'i, ma te'e 'ufaria nga wane ngaa'i. Ngaia ne'e, 'ato 'e iiki fana 'amooru taunga'i la'u fana God, ma nga bata na te'e alata momola.” ");
INSERT INTO kwd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ma alata Farasii gila longoa ni 'ola lo'oo, gila ka doodoo 'ania la Jisas, tofuna gila ta'a gila siria gonibatanga 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","La Jisas ka fata 'ilo'oo faga, “Moru agea 'ola 'e le'a mola 'i maana nga ta'a, fana 'agila iiri ba'ita 'amooru. Tafe'ua, ma God ngaia 'e su'a mola na mango mooru. Tofuna 'olataa na nga wane 'e manata ba'ita ai, God 'e manadaia ngaia 'e ria 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","La Jisas 'e alafuu la'u 'ilo'oo, “Nga tagi ala Moses te'efou, ma nga girigiringa na ni profet te'efou, ngaia 'e taunga'i 'ani talaia mooru mai leleka maka nigi na alata ala Jon wane ni naruabunga ngaia 'e nigi. Ma eta mai ala Jon, ne'e foulange'enia nga Kwairiinga Le'a lo'oo suria God lo'oo 'ani ba'ita fafia ta'a ngai aana te'efou, nga ta'a 'e aula gila irito'ona fana ru'unga 'i 'ubulana nga mooringa lo'oo na God 'ani ba'ita fafia. ");
INSERT INTO kwd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tafe'ua, ma ngaia 'e 'ato fana mo'ola sisika na tegelangaa na Tagi 'ani sui, tafe'ua ngaia 'ani sisika. Nga lalo, ma nga fanua lo'oo 'i wado te'e 'e sui mola, tafe'ua ma nga tegelalana nga Tagi 'e 'ato 'ani sui. ");
INSERT INTO kwd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Lauta ta wane 'ani 'akwasia nga noni aana ma ka feea la'u ta noni ngaa'i matari, ngaia 'e agemani no'o. Ma lauta nga wane ngaa'i 'ani feea nga noni no'ona gila 'akwasia, ngaia 'e agemani la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","La Jisas 'e alafuu la'u maka 'ilo'oo, “Te'e wane ngaa'i ne'e dari'ola, ngaia 'e ru'ufia nga ruu 'e le'a na'a forilai 'e ba'ita, ma ngaia ka nana'i 'ania to'orunga ne'e le'a gani mai gani. ");
INSERT INTO kwd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma te'e wane ngaa'i ne'e galafa'a na 'afu'afutana nonina, na'a latana la Lasaros, ngaia 'e nana'i 'i wado 'a'aena nga maana 'ifi na wane dari'ola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma la Lasaros 'e siria 'ani 'ania ole'enge'e fangalaa ne'e 'esia fa'asia nga fofo'u ni fangalaa na wane dari'ola lo'oo. Ma alata la Lasaros 'e to'oru 'i wado, nga ku'i gila leka mai, ma gila gamia nga du'adu'a lo'oo 'i labena. ");
INSERT INTO kwd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","La Lasaros 'e mae, ma nga enselo gila ka ngaria no'o fani langi te'ala Ebraham fana nga fafangalaa ba'ita 'i Langi. Ma nga wane dari'ola lo'oori 'e mae la'u mola, ma gila ka kwaiatoa no'o. ");
INSERT INTO kwd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma ngaia ka to'oru 'ubulana lefu fana kwa'ikwa'inga ma ka to'o na nonifiinga ba'ita. Ma ngaia ka aga kau 'ala'a, ma ka agasia kau la Ebraham, ma la Lasaros 'e to'oru la'u mola no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma ngaia ka o'omae kau fala Ebraham ma ka 'ilo'oo, ‘Koko'o Ebraham, 'oi madai nau mai. Alea madi mai la Lasaros, 'ani te'e kurume'enia mai nga 'u'una 'ubulana ka'o, 'ani te'e fa'agwaria nga meagu, suria 'inau ku to'oru no'o 'ania nga nonifiinga ba'ita 'i 'ubulana nga eele lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tafe'ua, ma la Ebraham ka fata 'ilo'oo fana, ‘Wela agu, to'o manata to'ona madi alata laka'u 'i'oo momoori, 'i'oo to'o na ni 'ola 'e le'a 'e aula, ma la Lasaros ka to'o mola na ni 'ola 'e ria. Tafe'ua, ma nga alata lo'oo, ngaia 'e to'oru no'o 'ubulana aile'anga lo'oo, na alata nga lo'oo 'i'oo to'oru la'u 'ubulana nga nonifiinga. ");
INSERT INTO kwd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma 'ola ngaa'i la'u, God 'e arua nga afoaa ba'ita ngaia 'i laloadauru, ma 'ato no'o fana te'efuta wane 'ani olofolosia kau fana gula ngai no'ona. Ma ka 'ato no'o la'u mola fana te'efuta wane 'ani olofolo mai te'ameeru.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma ngaia ka lamadu'aa ma ka fata 'ilo'oo, ‘Koko'o, nau ku laeamasi'o kau fana 'i'oo 'ani alea la Lasaros fana 'ifi na ma'aagu, ");
INSERT INTO kwd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","fana 'ani fa'abasua nga nima wane meeru futa te'efou, fa'asia gila ta leka la'u mai na gula ni nonifiinga lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma la Ebraham ngaia 'e lamadu'aa maka fata 'ilo'oo, ‘Nga girigiringa ala Moses ma ta'a profet gila nana'i no'o fe'eniga. Ngaia 'e to'omia fana 'agila lo'oo mola 'i suria.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma ngaia ka fata 'ilo'oo, ‘Koko'o Ebraham, 'amoe no'o. Lauta ta wane na'a ngaia 'e mae ma ka moori la'u, ngaia 'e leka te'aga, tagila bulota'i fa'asia nga rianga aaga.’ ");
INSERT INTO kwd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma la Ebraham ka fata 'ilo'oo fana, ‘Lauta 'e 'ato no'o 'agila lo'o suria nga girigiringa ala Moses ma ni profet te'efou, ngaia 'e 'ato la'u mola fana 'agila fito'o, gwa'a ta wane ngaa'i 'ani tata'e la'u fa'asia nga maenga.’” ");
INSERT INTO kwd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","La Jisas 'e fata 'ilo'oo fana fufu'iwane laka'u aana, “Nga 'ola ne'e agea nga ta'a fana 'agila abulo 'ame le'a, te'e lau no'o. Tafe'ua, ma te'e ria 'e iiki fana wane na'a ngaia 'e agea 'ola 'e ria lo'oo 'ani lau! ");
INSERT INTO kwd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Lauta te'efuta wane 'e agea nga wela sisika lo'oo 'ani 'esiga fa'asia tagoto'onga agu, ngaia 'e le'a fana 'ani firia nga fou ba'ita 'i onomagaa'a, ma ka 'ui 'ania gaa'a 'ubulana nga matakwa. ");
INSERT INTO kwd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mooru 'abelo le'a 'ania mooru! “Lauta ta wane ni futanga amu 'e abulo 'ame le'a, to'o iila fana. Lauta ngaia 'e bulota'i fa'asia, to'o 'olafanataa na rianga aana. ");
INSERT INTO kwd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma lauta 'e agea ni 'ola 'e ria famu na fiu alata 'ubulana te'e maa'e gani, ma ngaia ka leka la'u mai te'amu burina fiu alata lo'oo maka fata 'ilo'oo, ‘Nau ku bulota'i no'o fa'asia rianga agu,’ 'oi 'olafanataa na rianga aana.” ");
INSERT INTO kwd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ni Wane ni Kwairiinga aana gila ka fata 'ilo'oo fana nga Alafa la Jisas, “'Oi fa'ategelaa nga fito'onga ameeru.” ");
INSERT INTO kwd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mala Jisas 'e lamadu'aga maka 'ilo'oo, “Lauta mooru moru to'o na fito'onga sisika tafe'ua 'ani 'ilaka'u nga fufunguna mastad ne'e sisika le'a no'o, mooru su'asuria 'amoru iiria mola fana ta 'ai ba'ita, ‘Lafua nga 'umi'umimu, moko kiru'o 'ubulana nga asi.’ Mai ngaia te'e lo'o mola 'i suria nga fatalamu.” ");
INSERT INTO kwd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Lauta te'efuta wane amooru ngaia 'e to'o na nga wane ni taunga'inga ne'e taunga'i na langa'a, 'amoe ma ka aga suria nga sifisifi, alata ngaia 'e ori mai fa'asia nga langa'a, nga 'olataa na'a 'i'oo to'o iiria fana? To'o iiria fana ngaia 'ani leka 'aferu no'o mai, maka keto madi? ");
INSERT INTO kwd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Amoe! To'o fata 'ilo'oo mola fana, ‘'Oi do'ofia madi mai nga fangalaa agu, sui moko ru'ufia ruu fooru amu madi, ma to'o bi'i ngaria mai fangalaa fagu, 'aku keto ma 'aku go'u 'e sui. 'I buri, mai to'o bi'i keto, ma to'o bi'i go'u.’ ");
INSERT INTO kwd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma nga wane ba'ita lo'oo 'ame baole'a mola fana nga wane ni taunga'inga aana alata ngaia 'e dau suria 'olataa na ngaia 'e iiria fana. ");
INSERT INTO kwd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ngaia 'e 'ilo'oo la'u mola fe'eni amooru. Alata moru fa'asuia ni 'ola God 'e iiria famooru fana agelai, mooru fata 'ilo'oo, ‘Meeru nga wane ni taunga'inga lo'oo, meru agea mola nga taunga'inga 'i'oo siria meeru fana agelai.’” ");
INSERT INTO kwd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","La Jisas 'e leka fani Jerusalem, maka leka laloana gule'e lefu 'i Samaria ma 'i Galili te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma alata ngaia 'e nigi na te'e maa'e fanua lo'oo, ngaia 'e daria nga akwale'e wane lo'oo nga kuu 'e dauga. Gila ula lalau mai, ");
INSERT INTO kwd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma gila bi'i o'omae ba'ita mai ma gila ka 'ilo'oo, “Jisas, alafa, 'oi madai'a meeru mai!” ");
INSERT INTO kwd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma alata la Jisas 'e agasiga, ngaia ka fata 'ilo'oo faga, “Ta'a mooru leka, 'amoru faate'enia noni mooru fana nga fataabu na God, fana 'agila fa'ato'oa na'a nga noni mooru 'e gula no'o.” Ma alata gila leka no'o, nga noniga 'e gulaa te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Alata te'e wane ngaa'i 'e agasia nga nonina 'e gulaa no'o, ngaia 'e ori mai, ma ka o'omae ba'ita, ma ka baole'a fana God. ");
INSERT INTO kwd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma ngaia ka bobouruuru 'i maana 'a'aena la Jisas maka baole'a fana. Ngaia wane na'a 'ame Jiu. Ngaia wane fa'asia 'i Samaria. ");
INSERT INTO kwd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma la Jisas ka fata 'ilo'oo, “Nga akwale'e wane laka'u 'inau ku gulaga ma noniga ka gwari'a no'o. Ma nga mule wane ngaa'i la'u, gila ngai 'i fai? ");
INSERT INTO kwd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Uta'i lo'oo fu'uwane laka'u te'efou 'ame ori mai fana nga baatafelana God, ma te'ioo wane na'a 'i'oo 'ame Jiu, 'i'oo ori mai?” ");
INSERT INTO kwd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma la Jisas ka fata 'ilo'oo fana, “Tata'e, moko leka no'o. God ngaia 'e gula'o no'o tofuna 'i'oo fito'o agu.” ");
INSERT INTO kwd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tani Farasii ngaa'i gila orisia la Jisas ma gila ka 'ilo'oo, “Alata 'uta'i na'a God te'e ba'ita fafia fanua lo'oi wado?” Ma la Jisas ngaia 'e lamadu'aa alafuulaga maka 'ilo'oo, “Nga alata lo'oo God 'ani ba'ita fafia ta'a aana, 'ato 'amoru agasia te'efuta maa'e tooto ba'ita ai. ");
INSERT INTO kwd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma te'efuta wane 'e sia fata 'ilo'oo mola, ‘Agasia madi, alata fana God 'ani ba'ita fafia ta'a aana ngai lo'oo no'o!’ 'Ino'ona ma ngaia 'ani 'ilo'oo, ‘Ngaia no'ona no'o!’ tofuna nga gula na God 'e ba'ita fafia ngaia mola 'i 'ubulana mangona wane.” ");
INSERT INTO kwd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sui mala Jisas ka fata 'ilo'oo fana ta'a ni lelekanga aana te'efou, “Nga alata 'ani nigi mai, tamooru siria agasilana nga gani agu, nga Wela na Wane. Tafe'ua, gwa'a fana te'e gani momola ma mooru sia agasia mola. ");
INSERT INTO kwd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma tani wane ngaa'i tagila fata 'ilo'oo famooru, ‘Aga madi, nga Kraes ngaia no'o 'i no'ona!’ 'Ino'ona tagila 'ilo'oo, ‘Aga madi, ngaia no'o 'i lo'oo!’ Tafe'ua, mooru moru sia leka mola fana aganga fai. ");
INSERT INTO kwd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tofuna nga orilagu mai, nga Wela na Wane, ngaia 'e 'ilaka'u no'o nga kwangakwanga na watagalana 'e lala 'ubulana lalo te'efou na nga ta'a te'efou gila agasia. ");
INSERT INTO kwd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tafe'ua, ma 'i na'ona orilagu mai, nau taku nonifii, ma nga ta'a tagila ma'asini agu. ");
INSERT INTO kwd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Alata 'inau 'akui ori mai ai, te'e 'ilaka'u la'u mola alata ala Noa. ");
INSERT INTO kwd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Alata laka'u ala Noa, nga ta'a gila keto, ma gila ka go'u, ma ta'a alakwa fe'enia ta'ageni lari'i gila ka baiwane. Ma gila lebe no'o suria fe'e gani la Noa 'e ta'e 'ubulana faka ba'ita, ma nga afe ba'ita 'e nigi mai, ma ta'a te'efou gila go'u ma gila ka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma alata 'inau taku ori mai ai, ngaia te'e 'ilaka'u la'u mola nga gani laka'u ala Lot tofuna nga ta'a te'efou gila keto, ma gila ka go'u, ma gila fori, ma gila ka fa'afori, gila kirua fangalaa, ma gila ka launge'enia 'ifi. ");
INSERT INTO kwd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na nga maa'e gani lo'oo la Lot 'e leka fa'asia fanua 'i Sodom, nga ta'a gila lebe, ma eele ma nga fou 'ago'ago 'e 'esia no'o mai fa'asia 'i langi ma ka do'ofiga no'o te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngaia te'e 'ino'ona la'u mola na fe'e gani 'inau 'akui ori mai ai. ");
INSERT INTO kwd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na fe'e gani no'ona, nga wane na'a ngaia 'e to'oru 'i maa na 'ifi aana, 'ato 'ani ori la'u fana 'ubulana 'ifi fana ngarilana ni 'ola aana. Ma ka 'ino'ona la'u mola fana wane na'a ngai 'ubulana langa'a, 'ato 'ani ori la'u mai 'i 'ifi. ");
INSERT INTO kwd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mooru manata to'ona ni 'ola lo'oo 'e lau na noni ala Lot. ");
INSERT INTO kwd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Lauta ni dai ne'e siria 'ani dau fafia nga mangona 'i talana, ngaia te'e mae. Ma lauta ni dai ne'e rugasia nga mangona tofuna ngaia 'e leka suri nau, ngaia te'e moori kwala'imori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nau ku iiria famooru, na fe'e logo no'ona, rua wane na'a gala eeno fofona te'e furi, wane ngaa'i God te'e ngaria, ma wane ngaa'i te'e ole. ");
INSERT INTO kwd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Rua geni lo'oo gala ogu fana launge'enilana fangalaa, noni ngaa'i God te'e ngaria, ma noni ngaa'i te'e ole.” ");
INSERT INTO kwd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma nga Wane ni Kwairiinga aana gila ka orisia ma gila ka 'ilo'oo, “Alafa, 'i fai na ni 'ola lo'oo te'efou te'e lau ai?” Ma la Jisas 'e du'aga maka 'ilo'oo, “Nga langasi ba'ita 'ato 'ani talafia ni 'ola ne'e mae.” ");
INSERT INTO kwd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","La Jisas ngaia 'e alafuu te'ana ni wane ni lelekanga aana 'ania tarifulaa lo'oo, fana 'ani faate'enia faga 'agila fo'a 'i gani mai gani, ma gila sia fitala mola. ");
INSERT INTO kwd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ngaia ka fata 'ilo'oo, “Te'e wane ni kwaisufaingaa, ngaia 'e to'oru na te'e fanua lo'oo, ma ngaia 'ame fa'aba'ita God, ma ngaia 'ame iiri ba'ita la'u mola na te'efuta wane. ");
INSERT INTO kwd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma te'e me'e nao ngaia 'ubulana fanua lo'oo, ngaia 'e leka mai suria ni gani 'e aula te'ana fana darulana ma ka fata 'ilo'oo, ‘Nau ku siria 'i'oo 'ani kwatea kwaisufaingaa 'e odo fagu 'aku to'ofonosia nga marimae agu.’ ");
INSERT INTO kwd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma ni alata 'e aula sui no'o kau, nga wane ni kwaisufaingaa lo'oori 'ame kwaialami mola fafia. Sui ma 'i buri ngaia ka manata 'ilo'oo fana 'i talana, ‘Tafe'ua 'inau ku 'ame fa'aba'ita God, ma ku 'ame iiri ba'ita na te'efuta wane, ");
INSERT INTO kwd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nau taku kwatea no'o nga kwaisufaingaa 'e odo fana nga me'e nao lo'oo, suria ngaia 'e faa'abelosi nau 'e iiki na lekanga furifuri mai te'agu!’” ");
INSERT INTO kwd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma nga Alafa la Jisas ka fata 'ilo'oo, “Moru longoa madi nga 'olataa lo'oo wane kwaisufaingaa 'e ria ngaia 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Ino'ona ngaia ka kwatea nga kwaisufaingaa 'e odo fana, ngaia na mooru sia fitala na God na te'e kwatea 'ola 'e odo fana ta'a aana na'a gila aanisia suria logo ma gagani. God 'ame gole fana boonilaga. ");
INSERT INTO kwd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nau ku iiria famooru, God te'e kwatea 'afe'aferu na odonga faga. Tafe'ua, ma alata 'inau, nga Wela na Wane, 'akui ori mai fofona fanua lo'oo 'i wado, 'ilo'oo ma 'inau taku daria ta'a 'e aula na'a gila tagoto'o agu, 'amoe ma ta'a tarito'o mola?” ");
INSERT INTO kwd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","La Jisas ngaia 'e alafuu 'ania tarifulaa fana tani wane na'a gila fito'o aaga 'i talaga gila odo ma gila ka madafia gila le'a riufia ta'a ngaa'i la'u. Ngaia 'e fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Rua wane lo'oo gala leka 'i 'ubulana nga 'Ifi Abu na God fana 'agala fo'a. Te'e wane ngaa'i nga Farasii, ma wane ngaa'i ngaia 'e taunga'i na gonilana bata na takisi. ");
INSERT INTO kwd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nga Farasii lo'oo ngaia 'e ula 'i talana, ma ka fo'a 'ilo'oo, ‘God, nau ku baatafe'o tofuna 'inau ku 'ame 'ilaka'u nga ta'a ngaa'i te'efou. Suria gila beriberi, ma gila ka agea ni 'ola 'e ria, ma gila ka agemani kwaifafi. Nau ku baatafe'o tofuna 'inau ku 'ame 'ilaka'u nga wane ria loko'u ne'e gonia nga bata na takisi. ");
INSERT INTO kwd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nau ku abu keto na rua gani 'i 'ubulana te'e wiki, ma 'inau ku kwatea nga tangafuruna nga 'ola'angaa agu famu.’ ");
INSERT INTO kwd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tafe'ua, nga wane ngaa lo'oo 'e gonia nga bata na takisi, 'e ula lalau mola. Ma ngaia 'ame ta'ea no'o maana fani langi, tofuna ngaia 'e maila 'e iiki. Ma ngaia ka faate'enia nga kwaimanadainga aana 'ania fidarilana fu'ufu'una, maka fata 'ilo'oo, ‘God, madai nau mai moko 'olafanataa mai agu, 'inau nga wane ku 'ame le'a!’” ");
INSERT INTO kwd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma la Jisas ka fata la'u 'ilo'oo, “Nau ku iiria famooru, nga wane lo'oo 'e gonia nga bata na takisi, ngaia 'e odo no'o 'i maana God alata ngaia 'e ru'u 'i maa, ma nga Farasii 'amoe no'o. Tofuna nga ta'a lo'oo gila fa'aba'itaga 'i talaga, God te'e fa'asifoga. Ma nga ta'a na gila fa'asifoga 'i talaga, God te'e fa'aba'itaga.” ");
INSERT INTO kwd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tani ta'a gila ngaria mai ru'uru'ua sisika te'ala Jisas, fana ngaia 'ani gemaga ma ka nanamate'eniga. Ma alata fufu'iwane aana gila agasia, gila ka fatamaaga. ");
INSERT INTO kwd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tafe'ua, ma la Jisas ka soea mai ru'uru'ua lo'oori te'ana, maka fata 'ilo'oo faga, “Mooru alamia nga ru'uru'ua sisika 'agila leka mai te'agu, mooru sia ruiga mola. Tofuna ni dai na'a ngaia 'e tagoto'o 'ilaka'u wela sisika lo'oo, ngaia ne'e to'omia fana to'orunga olofana ba'itangaa na God. ");
INSERT INTO kwd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nau ku iiria 'ola kwala'imori famooru, lauta ta wane ne'e 'ame tagoto'o 'ilaka'u nga wela sisika, ngaia 'e 'ato 'e iiki fana God 'ani ba'ita fafia mangona.” ");
INSERT INTO kwd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te'e wane na'ona'o 'i Jiu, ngaia 'e orisia la Jisas maka fata 'ilo'oo, “Wane kwaifa'ananaunga le'a, 'olataa le'a lo'oo taku agea fana 'aku to'o na mooringa firi?” ");
INSERT INTO kwd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Fe'ua na'a 'i'oo fa'alata nau 'ania wane 'e le'a? Ta wane 'ame le'a no'o, te'e God ne'e le'a no'o. ");
INSERT INTO kwd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngaia 'e le'a 'i'oo su'ana tagi na God laka'u 'ilo'oo, ‘'I'oo sia kwa'ia mola ta wane, ma 'i'oo sia agemani, ma 'i'oo sia beria mola te'efuta 'ola, ma 'i'oo sia koto fana ta wane ngaa'i, moko iiri ba'ita na mama'a amu ma ni tete'e amu.’” ");
INSERT INTO kwd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wane lo'oo ngaia 'e lamadu'aa maka fata 'ilo'oo, “Ngaia 'ita no'o mai na alata nau ku sisika, nau ku lo'o suria nga tagi lo'oo te'efou.” ");
INSERT INTO kwd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma alata la Jisas 'e longoa ni 'ola lo'oo, ngaia ka fata 'ilo'oo fana, “Te'e 'ola la'u na'a ngaia 'amoe 'ua. 'Oi fa'afori 'ania nga 'ola laka'u amu te'efou, moko ngaria bata no'ona, ma to'o kwatea fana nga ta'a na gila galafa'a, ma 'i'oo to'o bi'i to'o na nga 'ola'angaa 'i Langi. Sui ma, to'o bi'i leka mai suri nau.” ");
INSERT INTO kwd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma alata wane lo'oo ngaia 'e longoa 'ola lo'oo, nga mangona 'e kwaimanadai ba'ita, suria ngaia nga wane dari'ola 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma alata la Jisas ngaia 'e agasia na'a wane lo'oo nga mangona 'e kwaimanadai, ngaia ka fata 'ilo'oo, “Ngaia 'e 'ato 'e iiki no'o fana nga ta'a na gila dari'ola 'agila ru'u 'ubulana mooringa lo'oo God 'e ba'ita fafia. ");
INSERT INTO kwd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngaia 'e 'ato fana nga kamel 'ani ru'u suria nga me'e kwakwa sisika 'i 'a'aena nila. Ma ngaia 'e 'ato riufia la'u fana ni wane na gila dari'ola 'agila ru'u 'ubulana mooringa lo'oo God 'e ba'ita fafia.” ");
INSERT INTO kwd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aia, alata ta'a te'efou gila longoa nga alafuunga lo'oo, ma gila ka orisia 'ilo'oo, “Kwe fu'uwane, ngaia te'e 'utaa ma ta wane 'e daria no'o mooringa firi lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma la Jisas ka lamadu'aa maka 'ilo'oo, “Ni 'ola lo'oo ngaia 'e 'ato 'e iiki fana wane, tafe'ua ma fana God 'e 'ame 'ato mola.” ");
INSERT INTO kwd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma la Pita ka fata 'ilo'oo fala Jisas, “Meeru meru 'akwasia no'o ni 'ola 'ameeru te'efou, fana 'ameru lado no'o amu.” ");
INSERT INTO kwd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","La Jisas ka fata 'ilo'oo, “Kiu. Nau ku iiria famooru, lauta ta wane ne'e 'akwasia nga 'ifi aana, ma nga noni aana, ma ni wane ni futanga aana, ma ma'aa aana ma ni tete'e aana, ma nga ru'uru'ua aana tofuna foufoula na God, ");
INSERT INTO kwd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ngaia te'e daria ni 'ola 'e aula fofona fanua lo'oo 'i wado ne'e riufia la'u ni 'ola te'efou ne'e 'akwasia. Ma nga mooringa fooru na te'e nigi, wane lo'oo te'e to'o no'o na nga mooringa firi lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma la Jisas 'e feea fufu'iwane aana 'i talaga ma ka fata 'ilo'oo te'aga, “Dauru goru leka fani Jerusalem suria nga to'oto'oni 'ola na ni profet te'efou gila giria suri nau, nga Wela na Wane. ");
INSERT INTO kwd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gila tagila kwate nau 'ubulana nimana ta'a na'a gila 'ame Jiu fana 'agila doo 'ani nau, ma tagila fata ni taafilagu, ma tagila ngisufi nau. Tagila labusi nau, ma tagila kwa'i nau. ");
INSERT INTO kwd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nga oruna maa'e gani, nau taku moori la'u.” ");
INSERT INTO kwd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tafe'ua, ma nga fufu'iwane laka'u aana gila 'ame su'a mola na alafuunga lo'oo na la Jisas ngaia 'e iiria faga, tofuna manatalaga 'e ngasi 'e iiki. Ngaia lo'oo gila 'ame su'ana 'olataa lo'oo la Jisas ngaia 'e fata suria. ");
INSERT INTO kwd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Alata la Jisas fe'enia ta'a ni lelekanga aana gila nigi galangia maa'e fanua lo'oo 'i Jeriko, te'e wane maana 'e logo ngaia 'e to'oru 'i gegena tala. Furifuri, ngaia 'e soea bata fa'asia ta'a. ");
INSERT INTO kwd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma alata ngaia 'e longoa ta'a 'e aula gila riu, ngaia ka orisiga maka fata 'ilo'oo, “'Olataa lo'oo 'e lau?” ");
INSERT INTO kwd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma gila lamadu'aa ma gila ka fata 'ilo'oo, “La Jisas nga wane laka'u 'i Nasaret lo'oo ngaia 'e leka mai.” ");
INSERT INTO kwd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma wane lo'oo maana 'e logo ngaia ka o'omae ma ka fata 'ilo'oo, “Jisas 'i'oo nga alakwa na fufutanga ala Defete, 'oi madai'a nau mai!” ");
INSERT INTO kwd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma ta'a lo'oo gila eteeta 'i na'ona gila ka iila fana, ma gila ka iiria ngaia 'ani to'oru aloalo. Tafe'ua, ma ngaia bi'i o'omae ba'ita bu'i, maka fata 'ilo'oo, “'I'oo nga wela na fufutanga ala Defete, 'oi madai nau mai!” ");
INSERT INTO kwd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma la Jisas ka mamanoto maka fata 'ilo'oo faga, “Talaia mai wane no'ona mai te'agu.” Ma alata 'e nigi galangi mai, la Jisas ka orisia, ");
INSERT INTO kwd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“'Olataa lo'oo 'i'oo siria nau 'aku agea famu?” Ma wane laka'u maana 'e logo ka fata 'ilo'oo, “Alafa, nau ku siria fana maagu 'ani aga.” ");
INSERT INTO kwd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","La Jisas ka fata 'ilo'oo fana, “'I'oo aga no'o. God 'e gula'o no'o, tofuna 'i'oo fito'o agu.” ");
INSERT INTO kwd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma no'ona mola ngaia ka aga no'o, ma ngaia ka leka no'o fe'enia la Jisas, ma ngaia ka baole'a fana God. Ma alata ta'a gila agasia, gila ka baatafea God. ");
INSERT INTO kwd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","La Jisas ngaia 'e nigi maka riu 'ubulana fanua 'i Jeriko. ");
INSERT INTO kwd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma te'e wane na'ona'o na ta'a ni gonilana bata na takisi 'ino'ona, latana la Sakeasi, ngaia wane dari'ola'a 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma ngaia ka su'usu'u 'e iiki fana agasilana la Jisas. Tafe'ua, ma ngaia 'e 'ato, tofuna 'i ngaia wane 'e ko'uko'uta mola, ma 'e 'ato fana 'ani agasia la Jisas suria nga ogunga lo'oo gila to'o'usia. ");
INSERT INTO kwd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma ngaia ka totola no'o kau 'i na'o na ogunga lo'oo, ma ka fane 'i gouna te'e 'ai na'a gila fa'alata 'ania Sikomo, fana 'ani agasia la Jisas alata ngaia leka mai suria nga tala lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Alata la Jisas 'e nigi na lefu lo'oo, ngaia 'e aga kau 'ala'a 'i gouna 'ai no'ona, maka agasia la Sakeasi, ma ka fata 'ilo'oo fana, “Sakeasi, sifo 'aferu mai, nau taku to'oru 'i 'ifi amu tala'ina lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","La Sakeasi ka aile'a ba'ita, ma ka sifo 'afe'aferu mai, maka kwaloa no'o la Jisas 'ubulana 'ifi aana. ");
INSERT INTO kwd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nga ta'a te'efou gila agasia 'ola lo'oo, ma gila ka ngu'ungu'u no'o burina, ma gila ka 'ilo'oo, “La Jisas 'e leka no'o fana 'ani nana'i fe'enia nga wane 'e ria lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma la Sakeasi 'e ula, maka fata 'ilo'oo fana nga Alafa la Jisas, “Alafa, nau taku kwatea nga gule'e 'ola na 'ola'angaa agu fana nga ta'a na gila galafa'a. Ma 'inau taku du'u fai alata fana ta'a na 'inau ku ngaria ni 'ola fa'asiga.” ");
INSERT INTO kwd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma la Jisas ka fata 'ilo'oo fana, “Tala'ina lo'oo, God 'e fa'amooria no'o nga to'orunga amu, tofuna 'i'oo tagoto'o na God 'ilaka'u nga wawarifu dauru la Ebraham. ");
INSERT INTO kwd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Inau, nga Wela na Wane, nau ku leka mai fana kwailonga 'ofia nga ta'a gila foo fana 'aku fa'amooriga la'u.” ");
INSERT INTO kwd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nga ogunga ba'ita lo'oo gila gwaalongo 'i suria 'olataa te'efou na la Jisas 'e alafuu 'i suria. Tofuna ngaia 'e nigi no'o galangia 'i Jerusalem, ngaia 'e iiria nga tarifulaa fana 'ani fa'aodoa manatalaga tofuna gila madafia fana foufoula ala God te'e lau mai 'afe'aferu. ");
INSERT INTO kwd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sui ma la Jisas ka fata 'ilo'oo faga, “Te'e wane ba'ita, ngaia 'e sasari fana 'ani leka te'ana nga Kiingi ba'ita na ngaia 'e to'oru lalau mai, fani ngaia 'ani orisia suria nga fofounga ma nga 'inato'onga fana alata ngaia 'ani ori kau fana gule'e lefu aana, ma ngaia ka Kiingi fana fanua lo'oo aana. ");
INSERT INTO kwd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'Ina'o na ngaia bi'i leka, ngaia 'e soea mai akwale'e wane ni taunga'inga aana te'efou te'ana, 'ani kwatea nga bata ba'ita faga, maka fata 'ilo'oo, ‘Mooru taunga'inga 'ania bata lo'oo te'efou, fana 'aku to'o na tani bata la'u alata nau ku ori mai.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tafe'ua, ni ta'a na wane ba'ita lo'oo, gila aga mani ana, ma gila ka alea tani wane fana 'agila alafuu fe'enia Kiingi ba'ita no'ona, suria gila 'ame siria no'o nga wane lo'oo 'ani Kiingi faga. ");
INSERT INTO kwd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tafe'ua, ma Kiingi ba'ita 'e arua wane lo'oo ngaia 'ani Kiingi no'o faga. Alata ngaia ori mai, ngaia ka iiria fana wane ni taunga'inga aana, laka'u 'e kwatea bata faga, fana 'ani daria nga fita bata na gila daria la'u fe'enia nga bata laka'u aana 'e kwatea faga. ");
INSERT INTO kwd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nga wane eteeta ni taunga'inga aana 'e leka mai, maka fata 'ilo'oo, ‘Welakau, 'inau ku daria nga akwale'e bata la'u fe'enia bata laka'u 'i'oo kwatea fagu.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma wane ba'ita lo'oo ka fata 'ilo'oo fana, ‘'I'oo wane ni taunga'inga 'e le'a. Tofuna 'inau ku su'aai 'inau ku tagoto'o amu na 'ola sisika te'efou, 'ilo'oo nau taku arua 'i'oo to'o aga suria akwale'e maa'e fanua.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nga ruana wane ni taunga'inga ka leka mai ma ka fata 'ilo'oo, ‘Welakau, nau ku daria nima bata la'u fe'enia nga bata laka'u 'i'oo kwatea fagu.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma wane ba'ita lo'oo ka fata 'ilo'oo fana, ‘To'o aga suria nima maa'e fanua ngaa'i.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ma nga oruna wane ni taunga'inga 'e leka la'u mai, maka fata 'ilo'oo, ‘Welakau, bata laka'u amu te'efou laka'u nau ku ngaria, nau ku buta ngiringiri no'o fafia 'ania sisi'i ruu. ");
INSERT INTO kwd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Inau ku ma'unge'eni'o suria 'i'oo wane 'i'oo 'inifou'u'u no'o. 'I'oo ngaria bata mola famu tofuna taunga'inga na ta'a matari, ma 'i'oo goni'i mola ni 'ola famu na lefu na 'i'oo 'ame kirua.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sui ma, wane ba'ita lo'oo bi'i fata 'ilo'oo fana, ‘'I'oo wane 'e taunga'i 'e ria. Nau taku sufa'o no'o 'ania alafuunga amu 'i talamu. 'I'oo iiria 'inau wane 'inifou'u'u no'o, ma 'inau nga wane ku ngaria mola 'ola na 'inau ku 'ame taunga'i ai, ma 'inau ku ngaria la'u mola nga foforinga na fangalaa fa'asia langa'a na ni ta'a ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lauta 'i'oo manata 'ilo'oo, 'uta'i na'a 'i'oo 'ame ngaria nga bata agu, 'ani 'oi arua 'ubulana lefu ni arulana bata, fana alata 'inau ku ori mai, 'aku ngaria la'u nga bata ngaa'i fe'enia?’ ");
INSERT INTO kwd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","No'ona mola wane ba'ita ngaia ka fata 'ilo'oo fana ni wane lo'oo gila ula 'i no'ona, ‘Mooru ngaria bata lo'oo fa'asia, ma mooru ka kwatea fana wane lo'oo 'e to'o na akwale'e bata.’ ");
INSERT INTO kwd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Gila ka fata 'ilo'oo, ‘Alafa, ngaia 'e to'o no'o na bata ba'ita!’ ");
INSERT INTO kwd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma wane ba'ita lo'oo 'e lamadu'aa maka 'ilo'oo, ‘Nau ku iiria famooru lauta ni dai ne'e taunga'i 'e le'a 'ania 'ola sisika, nau taku kwatea la'u ni 'ola 'e aula fana. Tafe'ua, ma ni dai ne'e 'ame taunga'i le'a 'ania nga 'ola sisika, nau taku ngaria mola ni 'ola sisika no'ona fa'asia. ");
INSERT INTO kwd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tafe'ua, ma fana marimae agu laka'u gila ma'asiri agu 'aku Kiingi faga, talaiga mai, ma moru ka kwa'iga 'i lo'oo 'i na'ogu.’” ");
INSERT INTO kwd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","'Iburina la Jisas 'e fata 'ilo'oo 'e sui mola, ngaia ka leka no'o kau 'i na'oga fani Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma alata ngaia 'e nigi no'o galangia fanua no'ona 'i Betefeis ma 'i Betani te'ana nga iile gila fa'alata 'i Olif, ngaia ka kwatea rua wane aana no'o 'i na'o, ma ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Molo leka na fanua loko'u. Ma alata molo nigi 'i no'ona, tamolo agasia te'e dongki. Gila gaua nga dongki no'ona, ma te'efuta wane 'ame fane 'ua 'i fofona. Tamolo rubea, ma molo talaia mai lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma lauta ta wane 'ani orisi 'amoo'o, ‘Fe'ua na'a molo rubea nga dongki no'ona?’ Molo kwairii te'ana, ‘Nga Alafa 'e bo'obo'o fai.’” ");
INSERT INTO kwd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aia, rua wane lo'oo gala ka leka, ma gala ka daria, 'ilaka'u no'o la Jisas ngaia 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Alata gala rubea nga dongki lo'oo, nga wane ne'e to'o na dongki lo'oo ka fata 'ilo'oo, “'Olataa lo'oo molo rubea nga dongki lo'oo fai?” ");
INSERT INTO kwd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Gala fata 'ilo'oo, “Nga Alafa ngaia 'e bo'obo'o fai.” ");
INSERT INTO kwd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma gala ka talaia no'o mai te'ala Jisas, ma gala ka arua nga ruu agaa'a 'i fofona bobouna nga dongki no'ona, ma gala ka boonia la Jisas, 'ani to'oru 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma alata la Jisas 'e leka kau suria tala lo'oo, ta'a te'efou gila ka lafaate'enia nga ruu aaga suria tala no'ona, fani ngaia 'ani talau 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma nga alata ngaia 'e nigi galangia 'i Jerusalem, nga lefu na'a tala lo'oo 'e sifo tori fana nga iile 'i Olif, nga ogunga ba'ita na fufu'ita'a aana gila ka eta fana baatafelana God 'ania nga o'omaenga ba'ita fafia ni 'ola ni 'alefosilai na gila agasia. ");
INSERT INTO kwd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma gila ka fata 'ilo'oo, “God 'oi nanamate'enia nga Kiingi lo'oo ngaia 'e leka mai 'ania nga tegelangaa amu! Ma aloalonga 'ubulana fanua 'i Langi. 'Aguru baole'a fana God lo'oo ba'itangaa aana 'e iiki.” ");
INSERT INTO kwd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma tani Farasii gila ngai no'ona la'u mola, gila ka fata 'ilo'oo fala Jisas, “Wane kwaifa'ananaunga, 'oi fata fana fufu'iwane laka'u amu te'efou, 'agila to'oru aloalo.” ");
INSERT INTO kwd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma la Jisas ka du'aga maka 'ilo'oo, “Nau ku iiria famooru, lauta gila to'oru aloalo, nga fou lo'oo te'efou tagila baatafea God.” ");
INSERT INTO kwd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ma nga alata la Jisas 'e nigi galangia 'i Jerusalem, ngaia ka aga kau, maka agasia nga fanua no'ona, ma ngaia ka ani, tofuna nga mangona 'e kwaimanadai fana ta'a lo'oo gila nana'i 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ka fata 'ilo'oo, “Ngaia 'e le'a lauta moru su'asuria tala'ina lo'oo ni 'ola ne'e ngaia 'e talaia ta'a fana aloalonga. Tafe'ua, ma tala'ina lo'oo God ngaia 'e na'agonia fa'asia mooru tofuna mooru moru ma'asini ana. ");
INSERT INTO kwd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nga alata te'e nigi mai fana nga marimae 'amooru 'agila leka mai, ma gila sasari fana fununga fe'eni 'amooru, ma gila ka to'ofonosi 'amooru, ma te'e 'ato no'o 'amooru ru'u 'i maa. ");
INSERT INTO kwd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma gila tagila tagale'enia fanua 'amooru ma tagila kwa'ia nga ta'a te'efou 'i 'ubulai. Ma ta me'e fou sia nana'i mola na lefu ne'e gila nana'i ai 'i na'o na fanua lo'oo amooru. Gila tagila ngadaa fanua lo'oo amooru, tofuna 'amooru moru 'ame su'asuria nga alata God 'ani leka mai fana fa'amoori lamooru.” ");
INSERT INTO kwd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Alata la Jisas ngaia 'e nigi 'i Jerusalem, ngaia 'e ru'u kau 'ubulana nga 'Ifi Abu na God, ma ngaia ka taria nga ta'a ni fa'aforinga. ");
INSERT INTO kwd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma ngaia ka fata 'ilo'oo faga, “Na nga Girigiringa Abu, God ngaia 'e fata 'ilo'oo, ‘Nga 'ifi agu, nga 'ifi ni fo'anga.’ Tafe'ua, mai 'amooru moru bulote'enia mola fana lefu fana beringa.” ");
INSERT INTO kwd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma gani mai gani, la Jisas ngaia kwaifa'ananau 'i 'ubulana 'Ifi Abu na God. Ma ni fataabu ba'ita lo'oo, ma ta'a ni kwaifa'ananaunga na Tagi ala Moses, ma tani ta'a na'ona'o 'i Jiu gila di'ai fana 'agila daria alata fana 'agila kwa'ia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tafe'ua, ma ngaia 'e 'ato fana 'agila daria te'efuta 'ola, suria ta'a te'efou gila nana'i fe'enia furifuri fana longolana kwaifa'ananaunga aana. ");
INSERT INTO kwd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na te'e gani ngaa'i, la Jisas 'e fa'ananaua ta'a 'i 'ubulana 'Ifi Abu na God. Ma ngaia ka kwairii 'ania Kwairiinga Le'a lo'oo. Ma nga alata lo'oo, ni fataabu ba'ita ma ni ta'a ni kwaifa'ananaunga na Tagi ala Moses, ma tani ta'a na'ona'o ngaa'i la'u, gila leka mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma gila ka orisia 'ilo'oo, “Nga tegelangaa ngai taa lo'oo 'i'oo to'o ai fana nga agelana ni 'ola lo'oo te'efou? Ma ni dai lo'oo 'e kwatea nga tegelangaa lo'oo famu?” ");
INSERT INTO kwd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","La Jisas ka fata 'ilo'oo faga, “Nau taku orisia mooru madi suria te'e 'ola. ");
INSERT INTO kwd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kiu, 'amooru moru kwairii madi te'agu, nga tegelangaa lo'oo la Jon 'e to'o ai fana nga naruabunga, ngaia 'e 'ita mai fa'asia 'i fai? Ngaia 'ita mai fa'asia God, 'amoe ma ngaia 'e 'ita mola mai na ta wane ngaa'i?” ");
INSERT INTO kwd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma gila ka kwaiorisia 'i laloaga kwairiu ma gila ka 'ilo'oo, “'Olataa lo'oo tagoru iiria? Lauta 'agoru lamadu'aa 'ilo'oo, ‘Fa'asia God,’ ma ngaia te'e fata 'ilo'oo, ‘Kwe fu'uwane ma fe'ua lo'oo 'e 'ato 'amooru fito'o ala Jon?’ ");
INSERT INTO kwd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma 'ame le'a fana 'agoru fata 'ilo'oo la'u mola, ‘Ngaia 'e 'ita mai fa'asia nga ta'a ngaa'i’, nga ta'a lo'oo tagila 'uia dauru 'ania fou, ma tagila kwa'i adauru, tofuna gila fito'o ala Jon ngaia nga profet la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sui, ma gila ka lamadu'aa la Jisas ma gila ka fata 'ilo'oo, “Meeru meru 'ame su'a mola ai.” ");
INSERT INTO kwd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma la Jisas ka fata 'ilo'oo la'u faga, “Ngaia 'e 'ato 'aku kwairii te'amooru na nga tegelangaa 'uta'i lo'oo 'inau ku agea 'ania ni 'ola lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Iburina, la Jisas ka kwairii la'u faga 'ania te'e tarifulaa maka 'ilo'oo, “Te'e alata ngaa'i, te'e wane ngaia 'e kirua te'e langa'a, ma ngaia ka arua tani wane ni taunga'inga 'agila aga suria langa'a lo'oo. Ma wane ba'ita na langa'a lo'oo ka leka no'o na fanua lalau, maka 'ato 'ani ori 'aferu mai. ");
INSERT INTO kwd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Alata nga langa'a no'ona 'e suka, wane ba'ita lo'oo ngaia ka alea te'e wane ni taunga'inga aana, madi fana 'ani ngaria mai tani lode'e 'ola 'ai na'a ngaia 'e kirua 'ubulana langa'a no'ona. Tafe'ua, ma alata wane ni taunga'inga lo'oori 'e nigi 'ubulana langa'a lo'oo, ni wane ni taunga'inga lo'oo gila aga suria langa'a lo'oo aana, gila kwa'ia, sui ma gila ka orite'eni tago ana te'ana wane ba'ita aana. ");
INSERT INTO kwd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma nga wane ba'ita lo'oo ka kwatea la'u ruana wane ni taunga'inga. Tafe'ua, ma ni wane ni taunga'inga na'a gila aga suria langa'a lo'oo aana, gila me'e kwa'ia la'u mola, ma gila ka fata ngadaa mola ma gila ka orite'eni tago la'u mola ana. ");
INSERT INTO kwd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lo'oo, wane ba'ita lo'oo ka kwatea la'u oruna wane ni taunga'inga aana, ma gila ka kwa'ia la'u mola, ma gila ka 'ui 'ania fa'asia lefu lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Iburina, nga wane ba'ita lo'oo ka manata 'ilo'oo, ‘Nga 'olataa lo'oo taku agea? Nau taku kwatea no'o nga wela wane lo'oo agu na 'inau ku kwaimaange'enia 'e iiki. Ma ngaia na'a, ni wane ni taunga'inga na gila aga suria langa'a no'ona, tagila iiri ba'ita ana.’ ");
INSERT INTO kwd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma alata ni wane ni taunga'inga, gila agasia nga wane lo'oori, gila ka fata 'ilo'oo 'i laloaga kwairiu, ‘Ngaia na wela kwala'imori na wane ba'ita laka'u lo'oo, ma ngaia te'e to'o na langa'a lo'oo. Goru kwa'ia 'ani mae fana 'agoru ngaria nga langa'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gila 'ui 'ania nga wane lo'oo fa'asia langa'a laka'u, ma gila ka kwa'ia maka mae no'o.” Ma la Jisas ka orisiga maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“'Olataa na'a nga wane ba'ita na nga langa'a lo'oori te'e agea? Ngaia te'e nigi mai, ma te'e kwa'ia ta'a lo'oo 'agila mae te'efou. Sui ma ngaia te'e arua ta'a ngai matari fana 'agila aga suria nga langa'a lo'oo.” Alata ta'a lo'oo gila longoa nga alafuunga ala Jisas, gila ka fata 'ilo'oo no'o, “'Amoe! Ngaia 'e 'ato 'ani lau!” ");
INSERT INTO kwd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sui ma la Jisas ka aga tegela'a faga, maka fata 'ilo'oo, “Lauta 'amoe ma, 'olataa ne'e fa'aladamia alafuunga laka'u 'ubulana Girigiringa Abu laka'u 'e fata 'ilo'oo, ‘Nga fou na nga wane ni launga'ilana 'ifi gila ma'asiri ai, ngaia na'a nga fou ne'e taringa'i 'e riufia nga fou lo'oo te'efou na bani.’ ");
INSERT INTO kwd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ma ni dai ne'e 'esia fofona fou lo'oo, ngaia te'e taringingisi no'o. Ma lauta ni dai na fou lo'oo 'ani 'esia fafia, nga nonina te'e meme te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na alata lo'oo, ni fataabu ba'ita fe'enia nga ta'a ni kwaifa'ananaunga na Tagi ala Moses, gila bi'i aga su'aai na la Jisas ngaia 'e alafuu 'ania tarifulaa lo'oo fana 'ani faate'enia na gila 'ame odo. Ma gila ka siria 'agila gemasia na alata no'ona, tafe'ua, ma gila ma'u mola suria nga ta'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma ni wane na'ona'o te'efou gila ka irito'ona fana darilana ta me'e tafaa fana gemasilana la Jisas. Ma gila ka foria tani wane fana 'agila koto fana orisilana la Jisas tofuna gila siria 'agila koto fana ta 'ola ne'e 'ame odo, fana 'ani to'omia fana 'agila kwatea kau fana wane ba'ita 'i Rom ne'e aga suria gule'e lefu 'i Judea. ");
INSERT INTO kwd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gila nigi te'ana, ma gila ka fata 'ilo'oo, “Wane kwaifa'ananaunga, 'imeeru meru su'aai nga kwaifa'ananau amu ngaia 'e kwala'imori. Ma 'i'oo sia lado mola fe'enia te'efuta wane na 'olataa na'a gila manata suria. 'I'oo kwaifa'ananau mola suria kwala'imoringa suria kwaisiriinga na God fana nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Iiria mai fameeru, 'ilo'oo ma ngaia 'e odo mola fana 'ameeru kwatea bata na takisi fana wane ba'ita 'i Rom 'amoe 'uta'i?” ");
INSERT INTO kwd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma la Jisas ka aga su'a mola na nga kotonga aaga, ma ngaia ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Faate'enia madi mai te'e fe'e seleni fagu.” Ma alata gila ngaria mai te'e fe'e seleni te'ana, ngaia 'e orisiga maka 'ilo'oo, “'Ilo'oo ma nununa ni dai lo'oo ngai na seleni lo'oo? Ma nga latana ni dai lo'oo ngai ai?” Ma gila lamadu'aa ma gila ka 'ilo'oo, “Nga wane ba'ita 'i Rom.” ");
INSERT INTO kwd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma la Jisas ka fata 'ilo'oo faga, “Lauta 'ino'ona, tamooru kwatea fana nga wane ba'ita 'i Rom nga 'ola aana, ma tamooru ka kwatea la'u mola nga 'ola na God fana God.” ");
INSERT INTO kwd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma gila ka nana'i aloalo, tofuna gila 'alefo ba'ita na lamadu'aanga ala Jisas. Ma gila 'ame to'omia no'o fana 'agila daria ta 'ola 'e kuta na la Jisas 'e iiria te'ana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sui ma tani Sadusi gila leka mai te'ala Jisas. Ni Sadusi lo'oo na'a gila iiria nga ta'a gila sia tata'e la'u fa'asia nga maenga. Ma gila ka orisia la Jisas ma gila ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wane ni kwaifa'ananaunga, la Moses ngaia 'e giria nga tagi fadauru maka fata 'ilo'oo, ‘Lauta ta wane ngaia 'e mae, ma nga noni aana 'e momoori mola 'ua, ma ngaia 'ame to'o na te'efuta wela, nga wane gala futa te'e feea la'u mola nga me'e nao lo'oori, fana 'agala to'o na wela fana 'ani orite'enia orioritana.’ ");
INSERT INTO kwd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Te'e alata ngaa'i, fiu waiasina gila nana'i. Ma nga wane nga 'i na'o 'e feea geni, ma gala 'ame arua mola 'ua ta wela, ma wane lo'oo ka mae mola. ");
INSERT INTO kwd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Ma nga ruana wane ka feea la'u nga me'e nao lo'oo, ma ngaia ka mae la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sui ma oruna wane ka 'ino'ona la'u mola. Ma ka 'ino'ona la'u mola fana ni wane ngai burina te'efou. Nga fiu waiasina lo'oo te'efou, gila feea noni lo'oo, ma gila 'ame to'o no'o na te'efuta wela, ma gila mae te'efou no'o. ");
INSERT INTO kwd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma 'ita'ilai, noni lo'oo 'e mae la'u mola. ");
INSERT INTO kwd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Ilo'oo ma, nga gani na'a God te'e tata'ea ta'a na'a gila mae no'o fa'asia maenga, ni dai aaga na'a nga noni aana te'e lau? 'I'oo su'aai nga fiu waiasina lo'oo te'efou laka'u gila feea noni lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma la Jisas ngaia 'e lamadu'aga maka 'ilo'oo, “Alata lo'oo, nga ta'a wane ma nga ta'a geni, gila fuageni ma gila baiwane. ");
INSERT INTO kwd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tafe'ua, ma nga alata ngai mai na'oda, nga wane ma nga noni na gila to'omia tata'enga fa'asia nga maenga, ma gila ka to'o no'o na nga mooringa firi 'i Langi, gila sia fuageni la'u ma gila sia baiwane la'u ");
INSERT INTO kwd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tofuna gila tagila 'ilaka'u nga enselo ma gila sia mae la'u. Gila ni wela na God no'o, tofuna gila tata'e no'o fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Lo'oo, ma nga girigiringa ala Moses 'e fa'awatagaa no'o fadauru na'a nga ta'a 'e mae tagila moori la'u mola. Tofuna alata God ngaia 'e faate'enia fala Moses nga eele ne'e nulafia 'ai sisika laka'u, la Moses ngaia 'e fa'alata 'ania God, ‘God na'a la Ebraham, ma la Aesak, ma la Jekob gila fo'asia 'ua.’ ");
INSERT INTO kwd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ngaia 'e fa'aladamia 'ilo'oo: Tani ta'a na'a gila mae no'o, gila fo'asia 'ua mola nga God, tofuna gila moori 'ua fe'enia.” ");
INSERT INTO kwd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma tani wane laloana nga ta'a ni kwaifa'ananaunga na Tagi ala Moses gila fata 'ilo'oo, “Wane kwaifa'ananaunga, nga lamadu'aanga amu 'e le'a 'e iiki!” ");
INSERT INTO kwd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma gila ma'u no'o fana kwaiorisinga la'u. ");
INSERT INTO kwd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sui ma la Jisas ka daiorisiga 'ilo'oo, “Fe'ua, na'a gila iiria nga Kraes na'a alakwa na nga fufutanga ala Defete? ");
INSERT INTO kwd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","La Defete laka'u 'e fata 'ilo'oo 'ubulana Girigiringa Abu na Sam, ‘God ngaia 'e fata 'ilo'oo fana Alafa agu: ‘To'o nana'i gula le'a agu, ma to'o ba'ita fe'eninau, ");
INSERT INTO kwd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mamania alata 'inau 'akui arua marimae amu te'efou 'ani lo'o suri'o.’ ");
INSERT INTO kwd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“La Defete no'o 'i talana lo'oo ngaia 'e iiria nga Kraes 'ania nga ‘Alafa.’ Ngaia no'o, nga Kraes, ngaia 'amoe mola nga alakwa na fufutanga ala Defete. Ngaia nga Alafa aana la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Alata ta'a 'e aula gila gwaalongo, la Jisas ka fata 'ilo'oo fana ni wane ni lelekanga aana, ");
INSERT INTO kwd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moru 'abelo 'ania mooru fa'asia ni Wane ni Kwaifa'ananaunga na Tagi ala Moses suria gila siria lekanga fe'enia ruu girigiri'a tekwa. Ma gila ka siria 'e iiki fana nga ta'a te'efou 'agila fa'aba'itaga, ma 'agila baatafega 'i maana uusi'a. Ma gila siria to'orunga 'i na'ona gula ne'e taringa'i na to'orunga 'ubulana 'ifi ni fo'anga na Jiu te'efou, ma nga gula 'e le'a alata na fafangalaa. ");
INSERT INTO kwd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tafe'ua, ta'a lo'oo gila beria nga 'ifi ma ni 'ola na ni me'e nao gila to'o ai. Ma gila ka fo'a 'e tekwa, fana nga ta'a 'agila baatafega. Kiu, nga ta'a ni kwaifa'ananaunga na Tagi ala Moses, kwa'ikwa'inga aaga te'e ria maka ba'ita!” ");
INSERT INTO kwd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Alata la Jisas ngaia 'e nana'i 'ua 'ubulana 'Ifi Abu na God, ngaia 'e aga aga, maka agasia ta'a gila dari'ola lo'oo gila leka mai fana kwatelana bata 'ubulana nga kokole'ola fana arulana bata 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma ngaia ka agasia la'u mola te'e me'e nao lo'oo 'e galafa 'e iiki. Ngaia 'e leka mai, maka kwatea rua fe'e seleni sisika. ");
INSERT INTO kwd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma la Jisas ka fata 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru, nga kwakwatenga lo'oo me'e nao galafa lo'oo 'e kwatea, ngaia 'e ba'ita 'e riufia ta'a lo'oo gila kwatea bata ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tofuna ta'a lo'oo gila dari'ola, gila kwatea mola nga gule'e 'ola sisika na dari'olanga aaga no'ona. Tafe'ua, ma me'e nao galafa'a lo'oo, ngaia 'e kwatea te'efou no'o ni 'ola lo'oo ngaia 'e to'o ai fana to'orunga ana.” ");
INSERT INTO kwd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma tani wane na fufu'iwane ala Jisas, gila tafea nga 'Ifi Abu na God, suria gila agasia 'e kwasinga'a 'e iiki 'ania ni me'e fou 'e le'a na'a gila fa'akwasinga 'ania ma nga kwakwatenga lo'oo la'u mola na gila kwatea fana God. Sui ma la Jisas bi'i fata 'ilo'oo faga, ");
INSERT INTO kwd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“'Ola te'efou lo'oo moru agasia, nga maa'e gani ngaia te'e nigi mai ta me'e fou sia nana'i mola 'i talafurina, tagila tagala'i te'efou 'i wado!” ");
INSERT INTO kwd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma gila ka orisia ma gila 'ilo'oori, “Wane ni kwaifa'ananaunga, nanitaa na ni 'ola lo'oo te'efou te'e nigi mai ai? Ma nga 'olataa lo'oo te'e lau, fana 'ani faate'enia alata fana ni 'ola lo'oo te'efou 'ani lau ai ma 'ani nigi ai?” ");
INSERT INTO kwd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma la Jisas ngaia 'e lamadu'aga maka 'ilo'oo, “Tamooru aga aga le'a, ma mooru sia alamia mola te'efuta wane 'ani kotofia amooru. 'I'oo su'aai nga ta'a 'e aula tagila nigi mai 'ania latagu, ma tagila fata 'ilo'oo, ‘'Inau no'o nga Kraes!’ Ma tagila fata la'u 'ilo'oo, ‘Nga alata 'e nigi no'o!’ 'Amoe! Moru sia leka mola suriga. ");
INSERT INTO kwd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma moru sia ma'u mola alata mooru longoa nga fununga ma nga alafuunga suria fununga, tofuna ni 'ola lo'oo te'e lau madi 'i na'o. Tafe'ua, 'ina'ona ni 'ola lo'oo te'efou 'ani lau, nga 'ita'ilana alata 'ame galangi 'ua mai.” ");
INSERT INTO kwd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sui ma la Jisas ka fata la'u fana fufu'iwane aana maka 'ilo'oo, “Nga maa'e fanua ba'ita tagila funuriga kwairiu 'i talaga, ma nga fufu'i ta'a tagila funuriga kwairiu 'i talaga. ");
INSERT INTO kwd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma nga nununu ba'ita te'e 'asu, ma nga molo'unga ma nga fifiinga ba'ita 'e iiki te'e riu na fanua lo'oo te'efou, ma ni 'ola matari 'e ba'ita fana ma'unge'enilai ma nga ma'etooto te'e faata'i mai fa'asia 'ubulana lalo. ");
INSERT INTO kwd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma 'i na'o na 'ola lo'oori te'efou 'ani lau, tagila agea ni 'ola 'e ria amooru, tofuna moru lo'o suri nau. Tagila gemasi 'amooru, ma tagila fa'anonifii 'amooru, ma tagila malate'ote'o moru 'ubulana nga 'ifi ni fo'anga, ma tagila arua mooru 'i 'ubulana nga lokafu, ma tagila ngaria mooru 'i na'o na ta'a na'ona'o fana kwaisufainga amooru. ");
INSERT INTO kwd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na nga alata no'ona, ngaia 'e le'a no'o famooru fana alafuunga suria nga Kwairiinga Le'a lo'oo na God. ");
INSERT INTO kwd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mai 'amooru moru sia manata 'abelo la'u 'ofia nga 'olataa na'a tamooru lamadu'aga 'ania. ");
INSERT INTO kwd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tofuna nau taku kwatea nga alafuunga na nga su'a'olanga famooru, ma ngaia 'e 'ato fana marimae amooru 'ani fata suari 'amooru, 'amoe maka fata sifo na ni 'olataa na'a moru iiria no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma nga ma'aa amooru ma tete'e amooru ma nga asi mooru ma nga wane ni futanga amooru ma nga ta'a kwaimaanga amooru tagila kwatea mooru fana nga ta'a na'ona'o te'efou. Ma tani ta'a amooru tagila kwa'ia mooru. ");
INSERT INTO kwd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ma nga ta'a te'efou tagila 'ufaria mooru tofuna 'inau. ");
INSERT INTO kwd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tafe'ua 'ani 'ino'ona, ngaia 'e 'ato fana te'efuta me'e ifuifu sisika 'i gou mooru 'ani 'amoe. ");
INSERT INTO kwd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Moru ula ngasi 'ania tagoto'onga 'amooru, ma tamoru momoori firi.” ");
INSERT INTO kwd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma la Jisas ka fata la'u 'ilo'oo faga, “Alata moru agasia nga ta'a na fununga gila ala 'afuia 'i Jerusalem, tamooru su'asuria tagila tagale'enia nga fanua ba'ita lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma nga alata no'ona, ta'a na gila to'oru na gule'e lefu 'i Judea, tagila 'akwa te'efou fana gouna me'e busu no'ona. Ma ta'a na gila nana'i 'ubulana maa'e fanua ba'ita lo'oo, tagila 'akwa fa'asia. Ma nga ta'a na gila 'ubulana maa'e fanua sisika 'afuia fanua lo'oo gila sia ori la'u mai fana fanua ba'ita lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tofuna alata no'ona ngaia alata fana God 'ani sufaa ta'a lo'oo fana 'ani fa'ato'oa afirina 'ola laka'u gila giri suria 'ubulana Girigiringa Abu. ");
INSERT INTO kwd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na nga alata lo'oo, kwaimanadainga ba'ita fana ta'ageni na gila guru'a, ma nga ta'ageni na'a gila fa'asusua mola wela sisika, tofuna te'e 'ato faga 'agila 'akwa. Ma nga kwaimanadainga ba'ita te'e lau na ta'a na fanua lo'oo, tofuna God te'e kwatea kwa'ikwa'inga fana ta'a 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tani ta'a aaga tagila kwa'iga 'ania naifi. Ma tani ta'a ngaa'i tagila gauga, ma tagila ngariga fana fanua matari te'efou. Ma nga ta'a ngai gila 'ame Jiu, tagila ngadaa fanua ba'ita 'i Jerusalem leleka maka nigi na 'ita'ilana alata aaga.” ");
INSERT INTO kwd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“'Ola kwaitatari te'efou te'e lau fana nga sina, ma nga singari, ma nga buruburu. Ma nga ta'a na nga maa'e fanua ba'ita te'efou 'i 'ubulana nga fanua lo'o 'i wado, gila manata 'abelo, ma tagila ma'unge'enia nga rurulana bio ma nga fanelana asi. ");
INSERT INTO kwd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma nga ta'a no'ona tagila labufunu suria gila ma'u 'e iiki, tofuna nga nigilana mai ni 'ola lo'oo fafia nga fanua lo'o 'i wado lo'oo te'efou. Ma ni 'ola 'i lofana lalo tagila kuta. ");
INSERT INTO kwd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sui ma 'inau, nga Wela na Wane, taku bi'i faata'i mai. Nau taku nigi mai fe'enia nga tegelangaa ba'ita, ma nga lalanga ba'ita 'i fofona nga me'e kofa. ");
INSERT INTO kwd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma alata ni 'ola lo'oo ngaia eta 'ani lau, tamooru ula, ma tamooru aile'a tofuna alata God 'ani fa'amoori 'amooru, ngaia 'e galangi no'o mai.” ");
INSERT INTO kwd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sui ma la Jisas ka fata 'ania nga tarifulaa lo'oo faga maka fata 'ilo'oo, “Mooru manata madi suria 'ai lo'oo gila fa'alata 'ania figi fe'enia ni 'ai ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Alata mooru moru agasia nga 'ai 'e ula fooru, mooru su'a no'o ai nga alata fana nga 'ago'agonga ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka 'ilo'oo la'u, nga alata moru agasia ni 'ola lo'oo te'efou 'e lau no'o, moru su'a no'o ai alata fana God 'ani ba'ita fafia ta'a aana, ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Ola kwala'imori nau 'aku iiria famooru, tani ta'a na'a gila moori na alata lo'oo, tagila momoori mola alata ni 'ola lo'oo tagila nigi mai. ");
INSERT INTO kwd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nga lalo ma nga fanua lo'oo 'i wado tagila sui, tafe'ua ma fatalagu te'e nana'i firi. ");
INSERT INTO kwd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Moru aga aga le'a. Moru sia gole mola na fafangalaa ba'ita ma nga go'unga, ma nga manata 'abelongaa na nga mooringa fofona fanua lo'oo 'i wado. Lauta moru age 'ino'ona, fe'e gani lo'oo te'e nigi fa'alebe 'amooru 'ilaka'u moru tari na ito. ");
INSERT INTO kwd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Suria ni 'ola lo'oo te'e nigi mai fafia nga ta'a te'efou, na afirina lefu te'efou 'i fofona fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Moru aga aga le'a, ma moru ka fo'a furifuri, fana 'amoru to'o na nga tegelangaa fana nga ulanga 'i 'ubulana ni 'ola lo'oo na 'ani lau mai fana mooru sia maila la'u alata moru ula 'i na'ogu, nga Wela na Wane.” ");
INSERT INTO kwd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Furfuri la Jisas 'e fa'ananaua ta'a te'efou 'ubulana 'Ifi Abu na God. Ma laulafi ngaia 'e leka fana me'e busu gila fa'alata 'i Olif. ");
INSERT INTO kwd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma furifuri alata ngaia bi'i kwa'aria mai, ta'a 'e aula gila leka mai 'ubulana 'Ifi Abu na God fana longolana fatalana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nga alata fana Fafangalaa na Tala Riunga 'e galangi no'o. Na nga fafangalaa lo'oo, gila fa'alata 'ania Fafangalaa fana 'anilana beret na nga iist 'e 'amoe ai. ");
INSERT INTO kwd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ni fataabu ba'ita no'ona, ma ni ta'a ni kwaifa'ananaunga na Tagi ala Moses gila fadaa nagwa nagwa fana kwa'ilana la Jisas, tofuna gila ma'unge'enia nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma la Saetan 'e ru'u 'i 'ubulana mangona la Judas Iskariot, te'e wane na akwale'e wane ma ruaai laka'u ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngaia na la Judas 'e leka kau te'ana fataabu ba'ita no'ona ma nga ta'a na'ona'o na ta'a lo'oo gila aga suria 'Ifi Abu na God, ma ka iiria, ngaia 'e su'asuria 'ani kwaiboonia fana gemasilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma gila aile'a ba'ita, ma gila ka ala no'o fafia 'agila kwatea no'o bata laka'u fana. ");
INSERT INTO kwd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","La Judas 'e ala fafia, maka tala'ae no'o fana aganga fana nga alata fana 'ani 'olonge'enia la Jisas faga alata ta'a 'e aula gila 'ame nana'i fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","'Ino'ona, nga Fafangalaa na ta'a 'i Jiu no'o fana 'anilana beret na'a nga iist 'e 'amoe ai, 'e nigi no'o mai. Gani lo'oo, gila kwa'ia la'u mola dalena nga sifisifi, ma gila ka sasaria fangalaa fana nga Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma la Jisas 'e alafuu fala Pita ma la Jon maka fata 'ilo'oo fagaa'a, “Molo leka ma mola sasaria nga fangalaa fadauru fana 'anilai na Fafangalaa na Tala Riunga.” ");
INSERT INTO kwd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gaa'a gala ka orisia la Jisas 'ilo'oo, “'I fai na'a 'i'oo siria amele sasaria nga lefu fana fangalaa ai?” ");
INSERT INTO kwd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","La Jisas 'e lamadu'aa agaa'a maka fata 'ilo'oo, “Alata molo nigi kau 'i fanua, tamolo daria te'e wane ngaia 'e ngaria nga fe'e ka'o. Molo leka suria fana 'ifi no'ona ngaia 'e leka fai. ");
INSERT INTO kwd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Molo fata 'ilo'oo fana wane na'a 'ifi aana, ‘Nga wane ni kwaifa'ananaunga 'e orisia 'ilo'oo mai amu, “'I fai na'a tofi 'ifi fana 'inau 'akui 'ania nga Fafangalaa na Tala Riunga fe'enia fufu'iwane agu?’” ");
INSERT INTO kwd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma nga wane lo'oo te'e faate'enia tofi 'ifi ba'ita na 'ifi lo'oo ngaia 'e to'oru 'i langi, lefu lo'oo ni 'ola te'efou gila sasaria no'o ai, ma 'i no'ona molo sasaria no'o nga fangalaa ai.” ");
INSERT INTO kwd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sui, gala ka leka no'o, ma gala ka daria ni 'ola te'efou ta'ua no'o la Jisas laka'u 'e iiria fagaa'a. Ma gala ka sasari no'o na fangalaa no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngaia 'e nigi no'o na alata fana 'anilana nga Fafangalaa na Tala Riunga, ma la Jisas fe'enia ni Wane ni Kwairiinga aana, gila ka to'oru no'o na lefu fana fangalaa. ");
INSERT INTO kwd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma ngaia ka fata 'ilo'oo faga, “Nau ku siria 'e iiki fana 'aku 'ania nga Fafangalaa na Tala Riunga fe'enia mooru 'ina'o sui ma taku ku bi'i nonifii. ");
INSERT INTO kwd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma 'inau ku iiria no'o famooru, ngaia 'e 'ato fana 'aku 'ania la'u nga Fangalaa na Tala Riunga fe'enia mooru, leleka maka nigi na alata fana God 'ani fa'amooria ta'a aana te'efou na alata ngaia 'ani ba'ita fafiga.” ");
INSERT INTO kwd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sui ma la Jisas ka ngaria nga teteu na waen, ma ka baole'a fana God. Sui ma ngaia ka fata 'ilo'oo faga, “Moru ngaria, ma moru ka go'u ai te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nau ku iiria famooru, 'ita tala'ina maka ori 'ala'a, nau ku sia go'ufia la'u nga waeni lo'oo, leleka maka nigi na alata na'a God te'e ba'ita fafia ni 'ola te'efou.” ");
INSERT INTO kwd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sui ma la Jisas ka ngaria no'o nga beret lo'oo, maka baole'a fana God, sui ma ngaia ka madanga, ma ka kwatea faga. Ma ka fata 'ilo'oo, “Nga nonigu laka'u nau ku kwatea 'usi 'amooru lo'oo. Mooru 'ania furifuri nga 'ola lo'oo fana madailagu.” ");
INSERT INTO kwd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'I burina nga fafangalaa, ngaia 'e ngaria la'u nga teteu na waen, maka fata 'ilo'oo, “Ngaia no'o na'a 'abugu ne'e afe 'ani tabo 'amooru. 'Ania nga 'abugu, God te'e fa'ategelaa nga fataarunga'inga fooru.” ");
INSERT INTO kwd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sui ma la Jisas ka fata 'ilo'oo, “Nga wane na'a ngaia te'e kwate nau fana marimae agu ngaia 'e to'oru la'u mola fe'eni nau 'i lo'oo na lefu ni ketonga. ");
INSERT INTO kwd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Inau, nga Wela na Wane, nau taku mae no'o tofuna God ngaia 'e kwate nau no'o fai. Tafe'ua, ma ngaia te'e ria 'e iiki fana nga wane lo'oo 'e kwate nau fana marimae agu.” ");
INSERT INTO kwd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma gila ka eta no'o fana orisilaga kwairiu 'i suria ni dai na te'e agea nga 'ola lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sui ma nga fufu'iwane aana gila orisu'usu'u 'i laloaga 'i talaga fana ni dai na te'e 'inato'o maka ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma la Jisas ka fata 'ilo'oo faga, “Mooru su'aai nga wane ba'ita lo'oo gila ba'ita fana fanua matari gila to'o na tegelangaa, ma gila su'a le'a suria ulanga burina ta'a fana agelana 'olataa na gila siria te'efou. Ma gila ka siria nga ta'a 'agila fa'alataga 'ania nga “Ta'a ni Kwaibooninga.” ");
INSERT INTO kwd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tafe'ua, mooru moru sia agea la'u 'ola lo'oo 'i laloamooru. Ni dai amooru na'a ngaia 'e kwaitalai, ngaia 'ani 'ilaka'u no'o nga wane na'a ngaia 'e malofi'a. Nga wane ba'ita, ngaia 'ani 'ilaka'u nga wane ni taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma ni dai na'a gila iiria na'a ngaia wane ba'ita, nga wane no'ona 'e to'oru mola fana nga ketonga, 'amoe ma nga wane ne'e taunga'i fana? Nga wane na'a ngaia 'e to'oru fana ketonga lo'oo 'e ba'ita. Tafe'ua, ma 'inau ku nana'i 'i laloamooru 'ilaka'u nga wane ni taunga'inga. ");
INSERT INTO kwd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Moru to'oru no'o fe'eni nau 'i 'ubulana nga irito'onga agu te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lauta nga Mama'a agu 'e kwatea no'o foufoula te'efou fagu, 'inau taku kwatea la'u mola nga foufoulaa famooru, ");
INSERT INTO kwd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","fana 'amooru keto fe'eni nau, ma moru ka go'u fe'eni nau 'i 'ubulana foufoula agu. Ma tamooru to'oru na lefu ni to'orunga na nga ba'itangaa lo'oo, ma tamooru ba'ita fafia nga akwale'e fufutalaa ma ruaai laka'u 'i Israel.” ");
INSERT INTO kwd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sui ma la Jisas ka fata 'ilo'oo fala Pita, “Saemon Pita! 'Oi gwalongo madi. God 'e alamia no'o la Saetan, fana 'ani irito'omooru fana 'efo lamooru te'efou fa'asi nau, 'ilaka'u nga wane ne'e taunga'i 'i 'ubulana langa'a 'e 'efoa fufunguna 'ola 'e le'a lo'oo fa'asia nga lalasina. ");
INSERT INTO kwd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tafe'ua 'ani 'ilo'oo no'o la Saemon, nau ku fo'a famu, fana 'i'oo sia abulo mola fa'asia nga fito'onga amu. Ma alata 'i'oo manata fa'aburi la'u mai te'agu, 'i'oo to'o fa'ategelaa ni wane ngaa'i na moru futa.” ");
INSERT INTO kwd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma la Pita ngaia 'e lamadu'aa maka 'ilo'oo, “Alafa, nau ku 'uri mola fana lekanga fe'eni'o 'i 'ubulana lokafu, ma gwa'a fana maenga ma taku mae fe'eni'o!” ");
INSERT INTO kwd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma la Jisas 'e lamadu'aa maka fata 'ilo'oo, “Pita, nau ku iiria famu, 'ubulana fe'e logo lo'oo, 'i na'ona nga susuki 'ani aani, 'i'oo to'o gwala nau oru alata 'i'oo bobolosi nau.” ");
INSERT INTO kwd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sui ma la Jisas bi'i orisia nga fufu'iwane aana maka 'ilo'oo, “Alata laka'u 'i na'o nau ku ale 'amooru, nau ku rui 'amoru moru sia ngaria mola te'efuta wa'i ma bata ma me'e butu. 'Ilo'oo mai 'amooru moru ori ko'uko'uta na te'efuta 'ola?” Ma gila lamadu'aa ma gila ka fata 'ilo'oo, “'Amoe no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma la Jisas ka fata 'ilo'oo, “Tafe'ua, ma nga alata lo'oo, lauta ni dai ne'e to'o na nga bata ma nga wa'i, ngaia 'ani ngaria no'o fe'enia. Ma ni dai no'ona 'ame to'o na nga naifi, ngaia 'ani fa'afori 'ania nga ruu aana, maka foria me'e naifi fana fununga. ");
INSERT INTO kwd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nau ku iiria ni 'ola lo'oo famooru tofuna nga Girigiringa Abu laka'u 'e fata 'i suri nau 'ilo'oo, ‘Gila iiria ngaia wane 'e mousia tagi lo'oo.’ 'Ola lo'oo te'e lau no'o agu, tofuna nga girigiringa te'efou suri nau te'e lau kwala'imori no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma nga fufu'iwane aana lo'oo gila ka fata 'ilo'oo, “Alafa, agasia madi, goru to'o no'o na rua naifi ni fununga lo'oo!” Ma ngaia ka du'aga maka fata 'ilo'oo, “Ngaia 'e le'a no'o. Moru mamanoto no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","La Jisas fe'enia nga fufu'iwane laka'u aana, gila 'akwasia no'o nga fanua ba'ita lo'oo, ma gila ka leka no'o fana me'e busu gila fa'alata 'i Olif, laka'u gila lelekai furifuri. ");
INSERT INTO kwd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma alata gila nigi na lefu no'ona, ngaia 'e fata 'ilo'oo faga, “Moru nana'i 'ania fo'anga, fa'asia nga irito'onga ta talariufi 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sui ma la Jisas ngaia te'e leka sisika la'u kau fa'asiga, ma ka bobouruuru 'i wado, ma ka fo'a. ");
INSERT INTO kwd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ngaia 'e fata 'ilo'oo, “Ma'ana, lauta 'i'oo 'uri, moko 'idua nga nonifiinga lo'oo fa'asi nau. Tafe'ua, nga kwaisiriinga agu 'amoe, nga kwaisiriinga amu lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma te'e enselo fa'asia 'i Langi 'e nigi mai, maka fa'ategelaa. ");
INSERT INTO kwd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sui mala Jisas ka fo'a tegela'a la'u tofuna mangona 'e fii 'e iiki. Ma nga 'idala'anga fa'asia nonina 'e afe 'i wado maka 'ilaka'u no'o nga uguugu na 'abu. ");
INSERT INTO kwd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma alata ngaia 'e tata'e fa'asia nga fo'anga, ngaia 'e ori mai te'ana nga fufu'iwane laka'u aana. Ma gila eeno mola, tofuna gila kweo 'e iiki ma gila kwaimanadai. ");
INSERT INTO kwd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma la Jisas ka fata 'ilo'oo faga, “Fe'ua lo'oo moru eneeno mola? Moru tata'e, ma moru ka fo'a, fa'asia nga irito'onga lo'oo ta riufi 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Alata la Jisas 'e alafuu 'ua mola fe'eniga, nga ogunga ba'ita gila nigi no'o mai. Ma te'e wane na nga fufu'iwane laka'u aana, lo'oo latana la Judas, ngaia 'e talaiga no'o mai. Ma ngaia ka nigi mai te'ala Jisas, maka nono'ia. ");
INSERT INTO kwd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tafe'ua, ma la Jisas ka fata 'ilo'oo fana, “Judas, 'ola 'e fe'ua 'i'oo 'olonge'eni nau, nga Wela na Wane, fana nga marimae agu 'ania nono'ilagu?” ");
INSERT INTO kwd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma alata nga fufu'iwane laka'u aana gila nana'i fe'enia la Jisas, gila agasia ni 'ola lo'oo, ma gila ka fata 'ilo'oo, “Alafa! 'Ilo'oo mai 'ameru kwa'i dau fe'eniga 'ania naifi lo'oo ameeru?” ");
INSERT INTO kwd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma te'e wane aga, 'e kwa'ia te'e wane ni taunga'inga na alafa ni suuabunga, ma ka ladua tafia no'o nga gule'e aringa le'a ana. ");
INSERT INTO kwd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma la Jisas ka fata 'ilo'oo, “'Oi Mamanoto no'ona no'o!” Ma ngaia ka gema na aringana nga wane no'ona, maka gulaa no'o. ");
INSERT INTO kwd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sui ma la Jisas ka fata fana nga tale'e fataabu ba'ita lo'oo, ma nga ta'a na'a gila folo 'afuia nga 'Ifi Abu na God, ma nga ta'a na'ona'o lo'oo na'a gila leka mai lo'oo fana nga gemasilana, ma ngaia ka fata 'ilo'oo, “'lno'ona ma 'inau nga wane fana agelana mae, ngaia lo'oo moru nigi mai 'oofi nau fe'enia nga naifi ma nga 'aila'a? ");
INSERT INTO kwd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nau ku nana'i mola lo'oo fe'enia mooru 'i 'ubulana nga 'Ifi Abu na God suria ni alata 'e aula, tafe'ua ma moru 'ame irito'ona mola fana gemasilagu. Tafe'ua, alata amooru lo'oo no'o, fana 'amoru taunga'i no'o 'ania nga tegelangaa ala Saetan, nga wane ne'e ba'ita na maa'e logo.” ");
INSERT INTO kwd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sui ma gila ka gemasia no'o la Jisas, ma gila ka talaia no'o 'i 'ubulana nga 'ifi na nga alafa ni suuabunga. Ma la Pita 'e leka lalau no'o mai buriga. ");
INSERT INTO kwd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma te'e eele gila fogua 'i dalototo'o 'ubulana fe'e labu na 'ifi lo'oo, ma la Pita ka nana'i la'u mola fe'enia nga ta'a lo'oo gila to'oru 'afuia nga eele lo'oori. ");
INSERT INTO kwd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma alata te'e wela geni lari'i ni taunga'inga 'e agasia la Pita 'e to'oru galangia nga eele, ngaia 'e aga faringe'enia maka fata 'ilo'oo, “Nga wane lo'oo ngaia 'e to'oru la'u mola fe'enia la Jisas.” ");
INSERT INTO kwd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tafe'ua, ma la Pita ka gwalaa maka fata 'ilo'oo, “Welakau, nau ku 'ame su'a na nga wane no'ona!” ");
INSERT INTO kwd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma 'ame aburu mola 'i burina, te'e wane ngaa'i 'e agasia la Pita maka fata 'ilo'oo, “'I'oo nga wane aaga la'u mola!” Tafe'ua, ma la Pita 'e lamadu'aa maka fata 'ilo'oo, “Dai ne'e su'ana, nau 'amoe!” ");
INSERT INTO kwd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma to'omia mola te'e alata sisika la'u 'i burina, te'e wane ngaa'i la'u 'e fata tegela'a maka 'ilo'oo, “Ngaia 'e kwala'imori no'o. Nga wane lo'oo ngaia 'e nana'i la'u mola fe'enia la Jisas, tofuna ngaia la'u mola nga wane fa'asia 'i Galili!” ");
INSERT INTO kwd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tafe'ua, ma la Pita ngaia 'e lamadu'aa maka 'ilo'oo, “Nau ku bobolosia nga 'olataa lo'oo 'i'oo fata suria wela kau!” Ma alata ngaia 'e fata 'ino'ona bi'i sui mola, nga susuki 'e aani no'o. ");
INSERT INTO kwd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma nga Alafa 'e abulo, maka aga odo no'o kau fala Pita. Ma la Pita ka manata to'ona alafuunga laka'u nga Alafa 'e iiria fana 'ilo'oo, “'I na'ona susuki 'e aani, 'i'oo to'o gwala nau oru alata na'a 'i'oo bobolosi nau.” ");
INSERT INTO kwd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sui ma la Pita ka ru'u kau 'i maa, maka aani ba'iba'ita no'o 'ania kwaimanadainga. ");
INSERT INTO kwd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma ni wane na'a gila folo 'afuia la Jisas, gila doo 'ania, ma gila ka kwa'ia. ");
INSERT INTO kwd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma gila ka gau boko'a nga maana, ma gila ka orisia ma gila ka 'ilo'oo, “Profet, 'Oi iiria madi ni dai ne'e kwa'i'o?” ");
INSERT INTO kwd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma gila ka iiria la'u mola alafuunga 'e ria aana. ");
INSERT INTO kwd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma 'usu'usu gani alata 'e kwa'aria mola, nga ta'a na'ona'o 'i Jiu, ma ni fataabu ba'ita no'ona, ma nga ta'a ni kwaifa'ananaunga na Tagi ala Moses, gila alafuu oguogu, ma gila ka talaia mai la Jisas te'ana ta'a ni fadafadanga. ");
INSERT INTO kwd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma gila ka fata 'ilo'oo fana, “'Oi iiria fameeru. 'Ilo'oo ma 'i'oo no'o nga Kraes, nga wane lo'oo God ngaia 'e eefasia fana fa'amoori lameeru?” Ma ngaia 'e lamadu'aga maka 'ilo'oo, “Lauta nau ku iiria famooru, ngaia 'e 'ato 'amoru lo'o agu. ");
INSERT INTO kwd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma lauta nau 'aku orisi 'amooru suria tani 'ola, ngaia 'e 'ato 'amoru lamadu'aa nau. ");
INSERT INTO kwd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tafe'ua ma 'ita na nga alata lo'oo maka ori 'ala'a, 'inau, nga Wela na Wane, nau taku to'oru 'i gula le'a na God lo'oo ngaia 'e tegela'a te'efou, mai nau taku ba'ita fe'enia.” ");
INSERT INTO kwd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma gila te'efou gila orisia ma gila ka 'ilo'oo, “'I no'ona ma 'i'oo no'o lo'oo nga Wela na God?” Ma ngaia 'e lamadu'aga maka 'ilo'oo, “Ngaia no'ona moru iiria no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma gila ka fata 'ilo'oo, “Goru 'ame siria no'o ta alafuunga ni fa'ato'olana 'ola la'u. Tofuna goru longo te'efou no'o na nga fatalana, lo'oo ngaia 'e fa'atooto'oa 'i talana fe'enia God!” ");
INSERT INTO kwd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nga ta'a na'ona'o lo'oori te'efou, gila tata'e, ma gila ka talaia la Jisas te'ala Paelat fana nga sufalana. ");
INSERT INTO kwd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma gila ka eta no'o fana aokwalanga fafia 'ania ni 'ola lo'oo 'ame to'o ma gila ka 'ilo'oo, “Meeru meru to'odaria nga wane lo'oo ngaia 'e fata 'i aringana nga ta'a ameeru te'efou. Ma ka iiria faga fana gila sia kwatea la'u nga bata na nga takisi fana nga wane ba'ita 'i Rom, ma ngaia ka iiria ngaia no'o nga Kraes, nga wane lo'oo God ngaia 'e alea mai fana 'ani Kiingi.” ");
INSERT INTO kwd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma la Paelat ka orisia maka 'ilo'oo, “'Ino'ona ma 'i'oo nga Kiingi 'i Jiu lo'oo?” Ma la Jisas ka lamadu'aa maka 'ilo'oo, “Ngaia no'ona 'i'oo iiria no'o.” ");
INSERT INTO kwd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sui ma la Paelat ka fata 'ilo'oo fana ni fataabu ba'ita lo'oo, ma nga ogunga lo'oo, “Nau ku 'ame daria mola ta rianga na nga wane lo'oo fana kwa'ilana.” ");
INSERT INTO kwd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma gila ka fata tegela'a ma gila ka 'ilo'oo, “Tafe'ua, ma 'ubulana ni gule'e lefu te'efou 'i Judea, ngaia 'e talai kuta no'o na ta'a lo'oo 'ania kwaifa'ananaunga aana. Ngaia 'e 'ita mai 'i Galili leleka maka nigi no'o 'i lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Alata la Paelat 'e longoa ni 'ola lo'oori, ngaia ka orisiga maka 'ilo'oo, “'Ilo'oo ma nga wane lo'oo 'e leka mai fa'asia 'i Galili?” ");
INSERT INTO kwd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma alata ngaia 'e su'aai na'a la Jisas 'e leka mai fa'asia nga gule'e lefu lo'oo la Herod 'e ba'ita fafia, ngaia ka kwatea kau la Jisas te'ala Herod. Tofuna la Herod ngaia 'e to'oru la'u mola 'i Jerusalem na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma alata la Herod 'e agasia la Jisas, ngaia ka aile'a ba'ita, tofuna ngaia 'e longoa nga alafuunga suria, ma ka mamania maka aburu no'o mai fana 'ani agasia. Ma ngaia 'e siria agasilana la Jisas fana ngaia 'ani agea nga 'ola ni 'alefosilai. ");
INSERT INTO kwd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","La Herod ngaia 'e orisia ni 'ola 'e aula aana. Tafe'ua, mala Jisas 'ame lamadu'aa mola ni kwaiorisinga aana. ");
INSERT INTO kwd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma ni fataabu ba'ita lo'oo ma nga ta'a ni kwaifa'ananaunga na Tagi ala Moses gila ula la'u 'i no'ona, ma gila ka aole'ekwala fafia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma la Herod fe'enia nga ta'a ni fununga aana, gila doo ana la Jisas, ma gila ka fata ngadaa la'u mola. Ma gila ka fa'aruufia 'ania nga ruu 'e tekwa 'e le'a 'ilaka'u nga Kiingi, ma gila ka orite'enia la'u te'ala Paelat. ");
INSERT INTO kwd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mai ngaia 'ita na maa'e gani lo'oo, la Herod mala Paelat gaa'a gala bi'i lado fana kwaimaanga la'u. 'I na'o, gaa'a nga rua wane gala marimae lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","La Paelat ka ogua ni fataabu ba'ita, ma nga ta'a na'ona'o lo'oo, ma nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ka fata 'ilo'oo faga, “Mooru moru kwatea mai nga wane lo'oo te'agu, ma moru iiria ngaia 'e talai ta'a te'efou 'e kuta fa'asia nga lo'onga suria wane ba'ita lo'oo 'i Rom. Moru aga madi, nau ku orisia 'i na'o mooru, mai nau ku 'ame daria mola te'efuta rianga ana fe'enia ni 'ola lo'oo moru geusia fafia. ");
INSERT INTO kwd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma la Herod 'ame daria la'u mola ta rianga ana, ngaia na'a ngaia 'e orite'enia la'u mola mai te'adauru. Nga wane lo'oo 'ame agea no'o ta 'ola 'e ria fani ngaia 'ani mae. ");
INSERT INTO kwd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngaia lo'oo, 'inau taku kwatea kau fana 'agila labusia sui ma 'inau taku bi'i rubea.” ");
INSERT INTO kwd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na nga Fafangalaa na Tala Riunga aaga, la Paelat 'e rubea te'e wane ne'e nana'i 'i 'ubulana lokafu fana nga Jiu, tofuna nga falafala aaga 'e 'ilo'oo no'o. ");
INSERT INTO kwd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tafe'ua, ma gila te'efou gila o'omae ma gila ka 'ilo'oo, “Kwa'ia wane no'ona 'ani mae! Ma 'i'oo ko rubea mai la Barabas fameeru!” ");
INSERT INTO kwd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","La Barabas gila arua 'ubulana nga lokafu tofuna ngaia 'e etaa nga fununga ba'ita fe'enia 'i Rom, ma ngaia ka kwa'ia ta'a. ");
INSERT INTO kwd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","La Paelat ngaia 'e siria 'ani rubea la Jisas, ma ngaia ka orisia la'u kau nga ogunga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tafe'ua, ma gila leka 'ania o'omaenga ma gila ka fata 'ilo'oo, “Moru kwa'ia 'ani mae! Moru mudu'ia na nga 'ai folo!” ");
INSERT INTO kwd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma la Paelat ka fata 'ilo'oo la'u faga na oruna alata, “Nga rianga ngai taa lo'oo ngaia 'e agea? Nau ku 'ame daria mola nga 'ola ne'e agea fana 'ani maeria. Ngaia na'a, nau taku kwatea mola kau fana 'agila labusia mola, sui ma 'inau kua rubea, ma ngaia ka leka mola kau.” ");
INSERT INTO kwd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gwae 'ino'ona ma, gila o'omae ma gila ka su'usu'u fana 'agila mudu'ia la Jisas na 'ai folo. Ma nga o'omaenga aaga 'e riufia no'o. ");
INSERT INTO kwd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ngaia na'a, la Paelat ka kwatea no'o nga 'ola na'a gila su'usu'u fai. ");
INSERT INTO kwd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sui ma ngaia ka rubea la Barabas, nga wane laka'u gila arua 'i 'ubulana lokafu suria ngaia 'e etaa nga fununga ba'ita ma nga kwa'ilana ta'a, tofuna ngaia nga wane laka'u gila siria. Sui ma la Paelat ka kwatea no'o la Jisas faga, tofuna ngaia na'a kwaisiriinga aaga. ");
INSERT INTO kwd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma nga ta'a ni fununga lo'oo, gila ka talaia no'o la Jisas fana nga maenga. Ma alata gila leka mola kau, gila ka daria te'e wane lo'oo latana la Saemon, fa'asia nga fanua 'i Saerin. Ngaia 'e leka mai ma ka ru'u 'ubulana fanua 'i Jerusalem fa'asia nga lefu mai gula 'i maa. Ma gila ka arua no'o nga 'ai folo 'i goulolona ma gila ka su'unge'enia fana 'ani ngaria 'i burina la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma nga oguogunga ba'ita gila ka leka no'o 'i burina. Ma tani fu'igeni 'i 'ubulana nga ogunga lo'oo gila o'omae, ma gila ka aanisia. ");
INSERT INTO kwd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","La Jisas 'e bu'ota'i te'aga ma ka fata 'ilo'oo, “Fu'igeni 'i Jerusalem! Mooru sia aanisi nau mola. Moru aanisi 'amooru 'i talamooru, ma nga ru'uru'ua 'amooru. ");
INSERT INTO kwd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tofuna fe'e gani te'e nigi mai na ta'a tagila fata 'ilo'oo, ‘Aile'anga fana nga fu'igeni na'a gila 'aiwane, ma nga fu'igeni na'a gila 'ame fa'afuta ma gila 'ame fa'asusuana wela!’ ");
INSERT INTO kwd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma alata no'ona nga ta'a te'efou tagila fata 'ilo'oo fana nga tale'e iile, ‘Moru 'esia mooru mai fafi 'ameeru.’ Ma tagila fata 'ilo'oo fana nga busu, ‘Moru aofo mai fafi 'ameeru.’ ");
INSERT INTO kwd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Lauta gila agea ni 'ola 'ilo'oo agu, nga wane na'a ku odo mola, tagila agea ni 'ola ne'e ria 'e iiki famooru ta'a na'a moru to'o na rianga.” ");
INSERT INTO kwd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma gila ka ngaria la'u mola rua fofolo beri lo'oo, fana nga kwa'ilaga fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma alata gila nigi na lefu lo'oo gila fa'alata 'ania “Nga Gouna Wane 'e Mae,” gila ka mudu'ia la Jisas na nga 'ai folo. Ma nga rua fofoloberi laka'u, gila ka mudu'ia gaa'a la'u mola na rua 'ai folo ngaa'i, wane ngaa'i na gula le'a ala Jisas, ma wane ngaa'i na gula moori ana. ");
INSERT INTO kwd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma la Jisas ka fata 'ilo'oo, “Ma'ana, 'oi 'olafanataa aaga, tofuna gila bobolosia 'olataa na gila agea.” Ma ni wane ni fununga no'ona gila ka masa na nga daisi, fana 'agila daria ni dai aga na te'e ngaria nga ruu ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Alata nga ta'a na'a gila ula 'i no'ona gila aga mola suria ma ni wane na'ona'o 'i Jiu no'ona, gila ka doodoo mola 'ania ma gila ka 'ilo'oo, “Ngaia 'e fa'amooria nga ta'a matari. Lauta ngaia na'a nga Kraes, nga wane na'a God ngaia 'e firia no'o, ngaia 'e to'omia 'ani fa'amooria ngaia 'i talana.” ");
INSERT INTO kwd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma ni wane ni fununga no'ona, gila ka doo la'u mola ana, ma gila ka leka kau te'ana, ma gila ka kwatea nga waeni sisika 'e ukwala fana. ");
INSERT INTO kwd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma gila ka fata 'ilo'oo, “Lauta 'i'oo nga kiingi na ta'a 'i Jiu, 'oi fa'amoori'o 'i talamu!” ");
INSERT INTO kwd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma gila ka giria nga alafuunga 'ilo'oo 'i gouna nga 'ai folo, “Ngaia no'o na'a nga kiingi 'i Jiu.” ");
INSERT INTO kwd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma te'e wane na rua wane laka'u gila mudu'ia gaa'a fe'enia la Jisas, ngaia ka fata sifo ana maka 'ilo'oo, “'Ilo'oo ma 'i'oo no'o na Kraes? 'Oi fa'amoori'o 'i talamu mai amee'e la'u mola!” ");
INSERT INTO kwd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tafe'ua, nga ruana wane ngaia 'e iila fana maka fata 'ilo'oo, “'lno'ona ma 'i'oo 'ame ma'unia mola kwa'ikwa'inga na God welakau? Goru toto'o te'efou no'o, tofuna gila kwatea mola te'e kwa'ikwa'inga fadauru. ");
INSERT INTO kwd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mai 'adaa'a lo'oo, nga kwa'ikwa'inga lo'oo 'e odo no'o lo'oo, tofuna goru ngaria no'o 'i maana ni 'ola 'e ria lo'oo golo agea. Tafe'ua, ma ngaia 'ame agea no'o ta 'ola 'e ria.” ");
INSERT INTO kwd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mai ngaia ka fata 'ilo'oo fala Jisas, “Jisas, 'oi madafi nau alata 'i'oo Kiingi.” ");
INSERT INTO kwd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma la Jisas ka fata 'ilo'oo fana, “Nau 'aku iiria nga 'ola kwala'imori famu, tala'ina 'i'oo to'o nana'i fe'eni nau 'i Langi.” ");
INSERT INTO kwd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ngaia 'e nigi 'i 'ubulana dalototo'o na gani, nga sina 'e mae, ma garigaria afirina lefu lo'oo te'efou ka logo no'o, leleka maka nigi na oruna mae 'ola na sisina 'e laulafi. ");
INSERT INTO kwd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma nga ruu ba'ita lo'oo 'e to'ofonosia nga gula 'ola ne'e abu 'e iiki 'i 'ubulana nga 'Ifi Abu na God ka gaa 'ania rua gule'e 'ola te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma la Jisas ngaia ka o'omae ba'iba'ita maka fata 'ilo'oo, “Ma'ana, nau ku kwatea no'o kau nga mangogu famu.” Ngaia 'e fata 'ilo'oo 'e sui mola, ma ngaia ka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma te'e wane na'ona'o na wane ni fununga lo'oo ngaia 'e agasia ni 'ola lo'oori, ma ngaia ka baatafea God maka fata 'ilo'oo, “Ngaia 'e kwala'imori, ngaia nga wane 'e odo!” ");
INSERT INTO kwd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma alata nga ta'a lo'oo te'efou gila ogu, ma gila ka bubunia, gila agasia maenga ala Jisas 'e sui, gila te'efou gila ori no'o fani fanua aaga. Ma gila ka fida 'i fu'ufu'uga fana faate'enilana nga kwaimanadainga aaga. ");
INSERT INTO kwd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma nga ta'a lo'oo te'efou na'a gila su'ana la Jisas, fe'enia nga fu'igeni no'ona gila leleka 'i burina fa'asia 'i Galili, gila ula lalau no'o mai, ma gila ka agasia ni 'ola lo'oo 'e lau te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma te'e wane fa'asia nga fanua lo'oo 'i Arimetea 'ubulana nga gule'e lefu 'i Judea, na'a latana la Josef, ngaia 'e to'oru la'u mola no'ona. Ma ngaia nga wane 'e odo, maka le'a, ma ngaia ka mamania la'u mola fana agasilana alata fana God 'ani ba'ita fafia ta'a aana te'efou. Ma tafe'ua ngaia nga wane na ni wane ni fadafadanga 'i Jiu, 'i ngaia 'ame ala mola fafia ni 'ola lo'oo gila iiria, ma gila ka agea ana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ngaia ka leka no'o te'ala Paelat, maka soea nga nonina la Jisas, ma la Paelat ka alamia no'o fana. ");
INSERT INTO kwd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma ngaia ka lafua no'o nonina la Jisas, maka 'afua no'o 'ania nga 'abale'e ruu kwakwao'a. Ma ngaia ka arua no'o 'i 'ubulana nga giru gwa'u fooru fana kwaiatolana ta'a 'e mae na'a gila takwea 'i 'ubulana nga fou ba'ita na te'efuta wane mae gila 'ame kwaitoa 'ua ai. ");
INSERT INTO kwd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma fe'e gani lo'oo nga Fraede, nga gani fana sasaringa fana Sabat. Nga gani na mamalonga, 'e galangi nigi no'o mai. ");
INSERT INTO kwd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nga fu'igeni na'a gila leleka mai burina la Jisas fa'asia 'i Galili gila leka la'u mola fe'enia la Josef. Ma gila ka agasia no'o nga giru gwa'u na gila arua la Jisas 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sui ma gila bi'i ori 'i 'ifi, ma gila ka sasaria no'o nga waiwai ma ni 'ola ne'e si'ini 'e le'a fana nga 'usulai 'ania nonina la Jisas. Ma nga gani na Sabat gila ka mamalo no'o, 'ilaka'u nga Tagi ala Moses 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma nga Sande 'usu'usugani, nga fu'igeni laka'u gila ngaria nga waiwai ne'e si'ini 'e le'a ma gila sasaria, ma gila ka leka no'o fani maana faaruma laka'u. ");
INSERT INTO kwd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma gila ka agasia giru gwa'u no'ona ngaia 'e 'ulasi no'o, tofuna nga baba ni fononga laka'u ngaia 'ame nana'i no'o 'i maana nga giru gwa'u no'ona. ");
INSERT INTO kwd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma gila ka ru'u kau, ma gila 'ame agasia no'o nga nonina la Jisas. ");
INSERT INTO kwd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma alata gila mamanata mola 'ua suria ni 'ola lo'oori, rua enselo na'a gala ru'ufia nga ruu 'e kwangakwanganga mono'o gala faata'i mai, ma gala ka ula 'i suriga. ");
INSERT INTO kwd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ma nga fu'igeni lo'oo gila ka ma'u ba'ita, ma gila ka bobouruuru 'i wado. Ma nga rua wane lo'oo gala ka fata 'ilo'oo faga, “Fe'ua lo'oo mooru kwailo'ofia nga wane momoori 'ubulana lefu fana arulana ta'a 'e mae ai? ");
INSERT INTO kwd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ngaia 'e 'amoe lo'oo no'o, ngaia 'e moori no'o. Moru manata to'ona madi, suria ngaia 'e kwairii te'amooru mai na'o, alata laka'u ngaia 'e to'oru 'ua mai fe'eni 'amooru 'i Galili. Ngaia 'e fata 'ilo'oo laka'u, ");
INSERT INTO kwd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tagila kwate nau, nga Wela na Wane, fana nga ta'a gila ria, ma tagila kwa'i nau na nga 'ai folo. Tafe'ua, na oruna gani, nau taku moori la'u.’” ");
INSERT INTO kwd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sui ma ni fu'igeni lo'oori gila bi'i manata to'ona nga fatalana. ");
INSERT INTO kwd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Ni fu'igeni lo'oo gila leka na giru gwa'u na, ni Meri fa'asia 'i Magdala, ma ni Joana, ma ni Meri tete'e ala Jemes ma tani noni ngaa'i la'u. Alata gila ori no'o fa'asia nga giru gwa'u, ma gila ka kwairii na ni 'ola lo'oo te'ana nga akwala ma te'e Wane ni Kwairiinga aana, ma tani wane ngaa'i la'u na'a gila nigi to'oga. ");
INSERT INTO kwd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tafe'ua, ma nga fufu'iwane lo'oo gila madafia fu'igeni lo'oo gila ta alafuu kuta mola, ma gila 'ame fito'o mola na fatalaga. ");
INSERT INTO kwd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma la Pita 'e tata'e, maka totola no'o te'ana maana giru gwa'u laka'u. Ma ngaia 'e gogonu kau, maka agasia mola nga ruu kwakwao'a ne'e ole no'o. Sike'ena ngaia 'e ori, maka 'alefo ba'ita na ni 'ola lo'oo 'e lau. ");
INSERT INTO kwd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na gani no'ona la'u mola, rua wane na ni wane ni lelekanga ala Jisas gala leka fana nga fanua 'i Emeas. Ngaia 'e to'omia akwale'e kilometers ma te'e ai fa'asia 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Alata gala alafuu ma gala ka manata suria 'olataa lo'oo 'e lau, ");
INSERT INTO kwd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","la Jisas 'e leka galangia gaa'a maka leka fe'eni 'agaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tafe'ua, mai gaa'a gala 'ame su'a mola aana 'i ngaia ni dai. ");
INSERT INTO kwd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sui mala Jisas bi'i orisia gaa'a, “'Olataa na molo alafuu suria alata lo'oo molo leka mai?” Ma gala ka ula aloalo, ma maa gaa'a 'e kwaimanadai ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma te'e wane agaa'a na'a latana la Kleopas, ngaia 'e fata 'ilo'oo, “Nau ku madafia bala 'i'oo na te'e wane na 'i'oo to'oru lo'oo 'i Jerusalem, na 'i'oo bobolosia mola nga 'ola lo'oo 'e lau 'ubulana ni gani lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma la Jisas ngaia 'e orisia gaa'a maka 'ilo'oo, “'Ola 'uta'i ne'e lau?” Ma gala lamadu'aa, ma gala ka 'ilo'oo, “'Ola lo'oo gila agea ala Jisas, nga wane laka'u 'i Nasaret. Nga wane lo'oo, ngaia nga profet, ngaia 'e fata 'ania tegelangaa ma ngaia ka agea ni 'ola ni 'alefosilai. God ma ta'a te'efou gila aile'a fe'enia. ");
INSERT INTO kwd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ni fataabu ba'ita ameeru ma nga ta'a na'ona'o lo'oo, gila kwatea fana kwa'ilana, ma gila ka mudu'ia na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma meru manata 'i suria ngaia no'o na'a te'e fa'amooria ta'a 'i Israel fa'asia marimae 'adauru. Ma tala'ina, nga oruna maa'e gani no'o 'i burina nga 'ola lo'oo ngaia 'e lau. ");
INSERT INTO kwd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mai 'imeeru meru 'alefo, tofuna fu'igeni na oguogunga ameeru, gila leka na nga giru gwa'u laka'u. ");
INSERT INTO kwd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tafe'ua, ma gila 'ame agasia nga nonina. Ma gila ka ori mai, ma gila ka kwairii na'a gila agasia nga enselo no'ona, ma gala ka kwairii te'aga na'a ngaia 'e moori no'o. ");
INSERT INTO kwd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma tani wane ngaa'i la'u na oguogunga ameeru, gila ka leka la'u mola na nga giru gwa'u lo'oo, ma gila ka daria ngaia 'e to'o no'o, 'ilaka'u la'u mola nga fu'igeni lo'oo gila kwairii ai. Tafe'ua mai gila 'ame agasia mola la Jisas.” ");
INSERT INTO kwd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma la Jisas ka fata 'ilo'oo fagaa'a, “Molo kwekweto 'e iiki! Ma nga manata lamoo'o 'ame 'aferu no'o fana nga fito'onga na ni 'ola laka'u ni profet te'efou gila iiria no'o mai 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gila iiria laka'u nga Kraes te'e nonifii madi, sui ma ngaia te'e bi'i ba'ita 'ania 'inato'onga ana.” ");
INSERT INTO kwd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma la Jisas ka fa'ananaua agaa'a 'ania ni 'ola laka'u gila alafuu 'ania suria nga Kraes 'i 'ubulana nga Girigiringa Abu lo'oo. Ngaia eta na nga girigiringa ala Moses ma nga girigiringa na ni profet te'efou. ");
INSERT INTO kwd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma alata gila nigi galangia no'o fanua lo'oo gila leka fai, la Jisas 'e abulo 'ilaka'u 'ani tala riufia agaa'a mola. ");
INSERT INTO kwd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma gala ka ruia, ma gala ka fata 'ilo'oo, “'Oi nana'i madi mai fe'enia amee'e, tofuna nga gani 'e galangi logo no'o.” Ma ngaia ka leka no'o fe'enia agaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Alata ngaia 'e nana'i no'o fana ketonga fe'enia agaa'a, ngaia ka ngaria me'e beret, ma ka baole'a fana God, sui maka niia nga beret lo'oo, ma ka kwatea fagaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Alata gala agasia ni 'ola lo'oo, God 'e alamia 'agala bi'i aga su'aai, ma ngaia 'e 'amoe no'o fa'asi 'agaa'a. ");
INSERT INTO kwd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma gala bi'i alafuu kwairiu fagaa'a, ma gala ka 'ilo'oo, “Sei! Alata laka'u 'e alafuu fe'enia daa'a mai suria tala, ma ka fa'ananaua adaa'a mai 'ania nga Girigiringa Abu lo'oo, daa'a golo aile'a ba'ita.” ");
INSERT INTO kwd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma nga alata no'ona la'u mola, gala tata'e, ma gala ka ori la'u mola fani Jerusalem. Ma gala ka daria nga akwale'e wane ma te'e ai ala Jisas fe'enia tani wane ngaa'i la'u. ");
INSERT INTO kwd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma ta'a no'ona 'ubulana oguogunga no'ona gila ka kwairii te'aga 'ilo'oo, “Nga Alafa ngaia 'e moori kwala'imori no'o! Ngaia 'e faata'i mai fala Saemon!” ");
INSERT INTO kwd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma gala ka alafuu suria nga 'ola laka'u 'e lau suria nga tala, ma nga alata gala aga su'a na alata ngaia 'e niia nga me'e beret laka'u. ");
INSERT INTO kwd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Alata rua wane lo'oo gala alafuu mola 'ua te'aga, la Jisas ngaia 'e faata'i, ma ka ula 'i laloaga, ma ka fata 'ilo'oo faga, “Aloalonga 'e nana'i fe'eni 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma gila ka lebe, ma gila ka ma'u 'e iiki, tofuna gila madafia gila agasia nga nunu'i 'ola. ");
INSERT INTO kwd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma la Jisas ka fata 'ilo'oo, “'Olataa ne'e agea 'amooru moru ma'u? Moru sia to'o mola na rua fe'e manatanga! ");
INSERT INTO kwd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'Inau lo'oo no'o. Moru agasia rua nimagu te'efou fe'enia nga rua 'a'aegu lo'oo. Moru gema to'ona madi mai nga nonigu, fana 'amooru su'aai, tofuna nunu'i 'ola 'ame to'o na ta suri fe'enia nga mariko, 'ilaka'u lo'oo moru agasia 'inau ku to'o ai.” ");
INSERT INTO kwd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Burina ngaia 'e iiria ni 'ola lo'oo 'e sui, ngaia ka faate'enia no'o talafurina malafa na nila laka'u na rua nimana ma nga rua 'a'aena faga. ");
INSERT INTO kwd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma gila ka aile'a ba'ita ma gila ka 'alefo. Tafe'ua gwae 'ino'ona gila fitala mola 'ua, tofuna gila 'ame su'a le'a 'ua ana. Ma la Jisas ka fata la'u 'ilo'oo faga, “Moru kwatea ketonga fagu.” ");
INSERT INTO kwd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma gila ka kwatea nga gweii'a fana. ");
INSERT INTO kwd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ngaia ka ngaria, maka 'ania no'o te'aga. ");
INSERT INTO kwd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sike'ena ngaia ka alafuu la'u 'ilo'oo faga, “'Ola lo'oo 'inau ku iiria no'o mai famooru, alata nau ku to'oru 'ua mai fe'eni 'amooru. 'Ola lo'oo te'efou laka'u gila giria suri nau 'ubulana Tagi ala Moses, ma 'i 'ubulana girigiringa na ni profet ma 'i 'ubulana Sam 'agila lau kwala'imori no'o mai.” ");
INSERT INTO kwd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sui ma la Jisas bi'i 'ulasia manatalaga fana 'agila su'asuria nga Girigiringa Abu. ");
INSERT INTO kwd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngaia ka fata 'ilo'oo faga, “Gila giria suri nau, nga Kraes, nau taku nonifii, ma nga oruna gani, nau taku tata'e la'u fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma ngaia 'e 'ita mai 'i Jerusalem leleka maka nigi 'ubulana fanua lo'oo te'efou, tamooru fata suria nga bulota'inga fa'asia nga rianga fana God 'ani 'olafanataa na rianga aaga 'ania latagu. ");
INSERT INTO kwd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mai 'amooru no'o tamooru kwairii 'ania ni 'ola lo'oo te'efou na moru agasia. ");
INSERT INTO kwd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mai 'inau talagu, taku kwatea nga Anoe 'ola Abu lo'oo Mama'a agu ngaia 'e fataarunga'i 'ania famooru. Ma tamooru mamania 'i Jerusalem, leleka ma nga tegelangaa fa'asia 'i Langi ka sifo mai fafia mooru.” ");
INSERT INTO kwd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sui ma ngaia ka talaiga no'o fa'asia 'ubulana fanua ba'ita lo'oo, leleka ma gila ka nigi na fanua 'i Betani, ma ngaia ka tata'ea nimana 'i langi, maka nanamate'eniga no'o. ");
INSERT INTO kwd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma alata 'e nanamate'eniga mola 'ua, ngaia 'e 'akwasiga, maka fane no'o fani Langi. ");
INSERT INTO kwd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma gila ka fo'asia 'e sui ma gila ka ori no'o fani Jerusalem fe'enia nga aile'anga ba'ita. ");
INSERT INTO kwd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma gila ka nana'i mola 'i 'ubulana nga 'Ifi Abu na God fana baatafelana God. ");
INSERT INTO kwd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'Ua no'o mai 'i na'o sui ma God ngaia bi'i launge'enia nga fanua lo'o 'i wado, nga wane na gila fa'alata 'ania nga Alafuunga, ngaia 'e nana'i no'o. Ma ngaia ka nana'i no'o mai fe'enia God. Ma ngaia na'a God. ");
INSERT INTO kwd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na lafaringaa, nga Alafuunga lo'oo ngaia 'e nana'i no'o mai fe'enia God. ");
INSERT INTO kwd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma God ka launge'enia ni 'ola te'efou 'ania 'i ngaia. Ngaia 'e kwala'imori, nga 'ola te'efou lo'oo God ngaia 'e launge'enia, ngaia 'e launge'enia 'ania nga Alafuunga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma nga mooringa kwala'imori 'e 'ita mai fa'asia nga Alafuunga lo'oo. Ma ngaia na nga lalanga kwala'imori ne'e lala mai fana nga ta'a. ");
INSERT INTO kwd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nga lalanga lo'oori 'e lala 'ubulana nga logologo'angaa, ma nga logologo'angaa 'e 'ame to'ofonosia no'o. ");
INSERT INTO kwd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God 'e kwatea mai te'e wane na'a latana la Jon wane ni naruabunga, ");
INSERT INTO kwd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","maka leka mai fana nga kwairiinga te'ana nga ta'a suria nga lalanga lo'oo. Ngaia 'e leka mai maka kwairii te'aga, fana nga ta'a te'efou 'agila longoa ma gila ka tagoto'o ana. ");
INSERT INTO kwd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma la 'i Jon talana ngaia nga lalanga 'amoe, ngaia 'e leka mola mai fana 'ani kwairii suria nga lalanga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nga lalanga kwala'imori lo'oori 'e leka mai 'ubulana fanua lo'oo 'i wado, ma ka lala no'o 'afuia nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma Alafuunga lo'oo ngaia 'e nana'i no'o 'i 'ubulana fanua lo'oo 'i wado. Gwa'a God 'e launge'enia no'o nga ta'a ma fanua lo'o 'i wado 'ania Alafuunga lo'oo, nga ta'a gila 'ame aga su'a mola ai. ");
INSERT INTO kwd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ngaia 'e nigi mai 'ubulana fanua aana, ma nga ta'a aana na gila Jiu gila 'ame kwaloa mola. ");
INSERT INTO kwd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tafe'ua ma ta'a na gila kwaloa, ma gila tagoto'o ana, ngaia 'e kwatea no'o tegelangaa faga fana gila nga ru'uru'ua na God. ");
INSERT INTO kwd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gila futa fooru fana ru'uru'ua na God. Gila ru'uru'ua na God suria ngaia 'e kwatea no'o mooringa fooru faga. Ngaia 'ame lau suria mango'e wane na fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nga Alafuunga lo'oo 'e lau no'o fana wane, ma ka to'oru no'o fe'enia dauru. Meru agasia no'o nga kwangakwanganga aana lo'oo ngaia 'e to'o ai, tofuna ngaia nga wela mouta'i na God nga Mama'a. Meru agasia na ngaia 'e fongu 'ania kwailaeta'afiinga ma nga kwala'imoringa na God. ");
INSERT INTO kwd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","La Jon wane ni naruabunga 'e kwairii suria ma ngaia ka o'omae 'ilo'oo, “Ngaia na nga wane laka'u nau ku alafuu suria na alata laka'u nau ku alafuu 'ilo'oo, ‘Nga wane na ngaia te'e leka mai 'i burigu, ngaia 'e taringa'i maka iiki riufi nau, tofuna ngaia 'e to'oru 'ua no'o mai 'i na'o sui mai nau ku bi'i futa.’” ");
INSERT INTO kwd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma tofuna nga kwailaeta'afiinga ba'ita aana, Kraes 'e kwatea ni 'ola 'e le'a lo'oo te'efou fadauru suria gani mai gani. ");
INSERT INTO kwd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God 'e kwatea tagi aana fadauru te'ala Moses. Tafe'ua ma ngaia 'e kwatea mai nga kwailaeta'afiinga aana ma nga kwala'imoringa suria ngaia 'i talana 'ania la Jisas Kraes. ");
INSERT INTO kwd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma te'efuta wane 'ame agasia God. Tafe'ua nga Wela mouta'i na God, na'a ngaia 'e toto'o fe'enia God nga Mama'a ma ka nana'i fe'enia, 'i ngaia ne'e faate'enia God fadauru. ");
INSERT INTO kwd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nga ta'a na'ona'o na ta'a 'i Jiu 'i Jerusalem, gila ka alea no'o fataabu, ma nga wane ni kwaibooninga na fataabu, fana 'agila orisia la Jon 'ilo'oo, “'Ilo'oo ma 'i'oo ni dai lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma la Jon ka lamadu'aga wataga maka 'ilo'oo, “Nau nga Kraes 'amoe.” ");
INSERT INTO kwd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma gila ka orisia la'u ma gila ka 'ilo'oo, “Welakau ma 'i'oo ni dai lo'oo? 'Ino'ona ma 'i'oo la Elaeja?” Ma ngaia 'e lamadu'aga la'u maka 'ilo'oo, “'Amoe.” Ma gila orisia la'u ma gila 'ilo'oo, “'Ilo'oo ma 'i'oo Nga Profet?” Ma la Jon ka lamadu'aga maka 'ilo'oo, “'Amoe.” ");
INSERT INTO kwd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma gila ka kwaiorisi 'ita'i la'u, ma gila ka 'ilo'oo, “'Ilo'oo ma 'i'oo ni dai lo'oo mola? 'Oi iiria mai te'efuta 'ola fameeru, fana 'ameeru kwairii 'ania fana ta'a na'a gila ale 'ameeru mai. 'Olataa na 'i'oo iiria mai suri'o 'i talamu?” ");
INSERT INTO kwd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma la Jon ka lamadu'aga 'ania me'e alafuunga laka'u la profet Aesea ngaia 'e giria maka 'ilo'oo, “Nau no'o nga wane laka'u 'e o'omae 'i 'ubulana nga gule'e lefu langalanga maka 'ilo'oo, ‘Nga Alafa te'e nigi mai! Moru fa'aodoa nga tala fana.’” ");
INSERT INTO kwd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ma nga ta'a na gila leka mai fa'asia ta'a na Farasii, gila orisia la'u ma gila 'ilo'oo, “Ma 'uta'i na'a 'i'oo naruabu na nga ta'a, lauta na 'i'oo nga Kraes 'amoe, 'amoe ma la Elaeja, 'amoe ma Nga Profet laka'u?” ");
INSERT INTO kwd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma la Jon ka lamadu'aga maka 'ilo'oo, “Nau ku naruabu mola 'ania nga ka'o. Tafe'ua ma te'e wane na moru bobolosia, ngaia 'e ula mola 'ilo'oo 'i laloamooru. ");
INSERT INTO kwd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ma ngaia no'o na nga wane na te'e leka mai 'i burigu, mai nau ku 'ame to'omia no'o 'aku rubea nga butu aana.” ");
INSERT INTO kwd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma ni 'ola lo'oo te'efou 'e lau 'i Betani, nga fanua gula tata'elana sina na ka'o 'i Jodan, lefu laka'u la Jon ngaia 'e naruabu na ta'a ai. ");
INSERT INTO kwd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na fe'e gani 'i burina, la Jon 'e agasia la Jisas 'e leka mai te'ana, ma ka iiria fana nga ta'a, “Moru agasia, ngaia na nga wane na ngaia nga Dale'e Sifisifi na God na'a te'e lafua nga rianga na ta'a 'i fofona nga fanua lo'o 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngaia lo'oo na wane laka'u nau ku alafuu suria na alata laka'u nau ku alafuu 'ilo'oo, ‘Te'e wane te'e leka mai 'i burigu. Ngaia 'e taringa'i maka iiki riufi nau, tofuna ngaia 'e nana'i 'ua no'o mai 'i na'o sui mai nau ku bi'i futa.’ ");
INSERT INTO kwd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mai na'o, nau ku 'ame aga su'a 'ua na wane lo'oo, tafe'ua nau ku leka mai, mai nau ku naruabu 'ania nga ka'o fana nga ta'a 'i Israel 'agila aga su'ana.” ");
INSERT INTO kwd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma la Jon ka alafuu la'u 'ilo'oo, “Nau ku agasia nga Anoe 'ola Abu 'e sifo mai fa'asia 'i langi 'ilaka'u nga me'e bola, ma ka fuu 'i fofona. ");
INSERT INTO kwd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nau ku 'ame aga su'ana 'i na'o. Tafe'ua ma God ne'e kwate nau mai fana 'aku naruabu 'ania nga ka'o, ngaia 'e fata 'ilo'oo fagu, ‘'I'oo to'o agasia nga Anoe 'ola Abu 'e sifo mai, maka fuu 'i fofona te'e wane. Ngaia no'o na nga wane na'a te'e naruabu 'ania nga Anoe 'ola Abu.’” ");
INSERT INTO kwd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma la Jon ka fata la'u 'ilo'oo, “Nau ku agasia no'o, mai nau ku iiria famooru, ngaia no'o na Wela na God.” ");
INSERT INTO kwd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma te'e gani ngai la'u 'i buri, la Jon 'e ula la'u mola 'i no'ona fe'enia nga rua wane na wane ni lekanga aana. ");
INSERT INTO kwd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na alata la Jisas 'e riu, la Jon 'e agasia, ma ngaia ka fata 'ilo'oo, “Ngaia no'o na nga Dale'e Sifisifi na God.” ");
INSERT INTO kwd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma nga rua wane ni lekanga aana, gala longoa 'ola lo'oori, ma gala ka leka no'o 'i suria la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ma la Jisas ka bulota'i, ma ka agasi 'agaa'a gala leka no'o suria, ma ngaia ka orisi 'agaa'a maka 'ilo'oo, “Nga 'olataa lo'oo molo siria?” Ma gala ka lamadu'aa 'ilo'oo, “Rabae, 'i'oo nana'i 'i fai?” (Rabae fa'aladamia wane ni kwaifa'ananaunga.) ");
INSERT INTO kwd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma ngaia 'e lamadu'aa gaa'a maka 'ilo'oo, “Molo leka mai, fana 'amolo agasia.” Ma gala ka leka fe'enia, ma gala ka agasia nga lefu na ngaia 'e nana'i ai. Ma alata no'ona 'e to'omia no'o faina mae 'ola laulafi. Ma gala ka nana'i fe'enia na fe'e gani no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma te'e wane agaa'a na ngaia 'e longoa la Jon maka leka fe'enia la Jisas na la Andru, nga wane ni futanga ala Saemon Pita. ");
INSERT INTO kwd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma la Andru bi'i leka ma ka nigi te'ala Saemon nga wanefuta aana, ma ka kwairii te'ana maka 'ilo'oo, “Mee'e mele daria no'o nga Mesaea.” (Nga fa'aladamilana alafuunga lo'oori 'e to'oto'o fe'enia ‘Kraes.’) ");
INSERT INTO kwd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sui ma ngaia ka talaia la Saemon te'ala Jisas. Ma la Jisas ka bubu tegela fana, ma ka alafuu 'ilo'oo, “'I'oo la Saemon, nga wela ala Jon, nau ku fa'alata'o no'o 'ania la Kefas.” Nga lata lo'oori na gila iiria la'u mola 'ania la Pita, ma ngaia fa'aladamilana nga, ‘Fou.’ ");
INSERT INTO kwd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ma ruana ma'e gani, la Jisas ka manata fana lekanga fana gule'e lefu 'i Galili, ma ngaia ka daria la Filip, ma ka alafuu 'ilo'oo fana, “'Oi leka mai fe'eni nau.” ");
INSERT INTO kwd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ma la Filip ngaia nga wane fa'asia 'i Betsaeda, nga fanua ala Andru ma la Pita. ");
INSERT INTO kwd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","La Filip 'e daria la Nataniel, ma ka kwairii te'ana maka 'ilo'oo, “Meeru meru daria nga wane laka'u la Moses 'e giri suria 'ubulana tagi, ma nga profet laka'u gila giri la'u mola suria. Ngaia la Jisas nga wela ala Josef fa'asia 'i Nasaret.” ");
INSERT INTO kwd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma la Nataniel ka fata 'ilo'oo, “Ngaia 'ato fana te'efuta 'ola 'e le'a 'ani leka mai fa'asia 'i Nasaret, welakau?” Ma la Filip ka fata 'ilo'oo fana, “Leka mai moko agasia 'i talamu.” ");
INSERT INTO kwd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Alata la Jisas ngaia 'e agasia la Nataniel ngaia leka mai te'ana, ma 'ingaia ka alafuu suria maka 'ilo'oo, “Nga wane lo'oo na ngaia 'e to'omia no'o fana 'agila iiria ngaia nga wane 'i Jiu kwala'imori, tofuna te'efuta kotonga 'e 'amoe ana.” ");
INSERT INTO kwd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","La Nataniel 'e orisia maka 'ilo'oo, “'Ino'ona mai 'i'oo su'a 'uta'i agu?” Ma la Jisas 'e lamadu'aa maka fata 'ilo'oo fana, “Nau ku agasi'o 'i 'a'aena figi sui mala Filip ngaia bi'i soe'o mai.” ");
INSERT INTO kwd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma alata la Nataniel 'e longoa nga 'ola lo'oo, ngaia ka fata 'ilo'oo, “Wane kwaifa'ananaunga, 'i'oo no'o na nga Wela na God! 'I'oo lo'oo na nga Kiingi na ta'a 'i Jiu!” ");
INSERT INTO kwd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","La Jisas 'e fata 'ilo'oo fana, “'Ino'ona mai 'i'oo bi'i tagoto'o lo'oo, tofuna laka'u nau ku iiria nau ku agasi'o 'i 'a'aena figi? Ma nau ku iiria famu, to'o agasia ni 'ola ba'ita 'e riufia ni 'ola lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma la Jisas ka fata la'u 'ilo'oo faga, “'Ola kwala'imori nau ku iiria famooru, tamoru agasia, 'i Langi te'e 'ulasi, ma tamoru agasia la'u mola nga enselo na God tagila fane 'ala'a fani langi, ma tagila sifo mai fofogu, nga Wela na Wane.” ");
INSERT INTO kwd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Burina rua gani ngaa'i 'e sui, te'e afolonga 'e lau na fanua 'i Kena 'i 'ubulana gule'e lefu 'i Galili. Ma tete'e ala Jisas 'e nana'i la'u mola 'i no'ona na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma gila ka soea la'u mola mai la Jisas fe'enia nga fufu'iwane aana fana nga afolonga no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma alata nga ta'a gila go'u, ma nga waeni aga ka sui, tete'e ala Jisas ka fata 'ilo'oo fana, “Gila 'ame to'o no'o na te'efuta waen.” ");
INSERT INTO kwd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma la Jisas ka lamadu'aa maka 'ilo'oo, “Tete'e 'ae, 'i'oo sia orisi nau la'u fana agelana te'efuta 'ola, tofuna nga alata agu 'e 'amoe 'ua. ");
INSERT INTO kwd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma tete'e ala Jisas ka fata 'ilo'oo fana nga ta'a ni taunga'inga lo'oo, “Moru agea mola te'efuta 'ola na'a ngaia 'e iiria famooru.” ");
INSERT INTO kwd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma nga ono kokole 'ola ba'ita fana ka'o na'a gila launge'enia 'ania fou ngaia to'oru 'i no'ona, fana nga narufilana ninima suria nga falafala 'i Jiu. Te'e kokole 'ola ngaia toto'o fe'enia rua akwale'e galon na ka'o. ");
INSERT INTO kwd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma la Jisas ka fata 'ilo'oo fana nga ta'a ni taunga'inga no'ona, “Moru ufia ni kokole 'ola lo'oo 'ania nga ka'o.” Ma gila ka ufia leleka maka fongu no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma ngaia ka fata 'ilo'oo faga, “Moru ngaria nga ka'o sisika, ma moru ka kwatea fana nga wane ba'ita na nga afolonga lo'oo.” Ma gila ka kwatea fana, ");
INSERT INTO kwd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma ngaia 'e go'u to'ona nga ka'o lo'oori, ma nga ka'o laka'u 'e lamadu'aa no'o fana waen. Ma ngaia 'ame su'asuria nga waeni lo'oo ngaia 'e eta mai fa'asia 'i fai. Tafe'ua ma ni wane ni taunga'inga lo'oo gila ngaria mai nga ka'o lo'oori na gila su'asuria te'efou. Sui ma wane ba'ita lo'oo ka soea mai nga alakwa fooru lo'oori, ");
INSERT INTO kwd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ka fata 'ilo'oo fana, “Furifuri na falafala adauru, ta'a gila kwatea nga waeni nga 'e le'a 'i na'o fana ta'a, ma 'i burina nga ta'a gila go'u 'e sui, ngaia bi'i kwatea nga waeni nga 'e 'ame masi'a. Tafe'ua ma 'i'oo gonia mola nga waeni le'ale'a lo'oo leleka maka nigi lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ngaia no'o nga 'ola ni 'alefosilai eteeta na la Jisas ngaia 'e agea 'i Galili, 'i 'ubulana nga fanua 'i Kena. Lo'oo ngaia 'e faate'enia nga tegelangaa ba'ita aana, ma nga fufu'iwane aana gila ka tagoto'o no'o ana. ");
INSERT INTO kwd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma 'i buri, la Jisas fe'enia tete'e aana, ma ni wane gila futa, ma nga fufu'iwane aana, gila ka leka no'o fana nga fanua 'i Kapaneam. Ma gila ka to'oru 'i no'ona suria tani gani ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aia, ma galangia no'o nga Fangalaa na Tala Riunga na nga ta'a 'i Jiu, la Jisas 'e leka fana nga fanua ba'ita 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma 'i no'ona 'ubulana 'Ifi Abu na God, ngaia 'e agasia nga ta'a lo'oo gila fa'afori 'ania nga buruka, ma nga sifisifi, ma nga bola fana tabonga. Ma ngaia ka agasia la'u mola nga ta'a na'a gila lamadu'aa nga bata gila nana'i na fofoda aaga. ");
INSERT INTO kwd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma ngaia ka launge'enia 'ola fana kwa'inga 'ania kwalo, ma ka beloa no'o buruka, ma nga sifisifi, ma nga 'ola te'efou fa'asia 'ubulana 'Ifi Abu na God. Ma ngaia ka fo'itori no'o na fofoda na nga ta'a lo'oo gila lamadu'aa 'ania nga bata, ma ka tagale'enia no'o bata aaga. ");
INSERT INTO kwd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma ngaia ka kwa'i tatala suria nga ta'a lo'oo gila fa'afori 'ania nga bola maka 'ilo'oo, “Moru ngaria no'o 'ola lo'oo 'i maa! Moru sia launge'enia mola nga 'Ifi na Mama'a agu fana lefu na 'uusinga.” ");
INSERT INTO kwd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma nga fufu'iwane aana gila ka manata to'ona nga Girigiringa Abu laka'u ngaia 'e fata 'ilo'oo, “God, nga kwaimaanga agu fana nga 'ifi amu, 'e 'ilaka'u nga eele ne'e nunula 'i 'ubulana mangogu.” ");
INSERT INTO kwd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma nga ta'a na'ona'o 'i Jiu gila ka orisia la Jisas ma gila ka 'ilo'oo, “Lauta God ne'e kwatea tegelangaa famu fana agelana ni 'ola lo'oori, faate'enia nga 'ola ni 'alefosilai fameeru!” ");
INSERT INTO kwd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Lauta moru osia nga 'Ifi Abu lo'oo, nau taku fa'aulaa la'u mola 'ubulana oru ma'e gani. ");
INSERT INTO kwd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma gila orisia la'u ma gila ka 'ilo'oo, “'Uta'i na to'o fa'aulaa mola 'ubulana oru ma'e gani lo'oo, welakau? Nga 'Ifi Abu na God lo'oo, gila launge'enia suria fai akwale'e farisi ma ono ai.” ");
INSERT INTO kwd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tafe'ua ma nga 'Ifi Abu lo'oo la Jisas ngaia 'e fata suria na nga nonina 'i talana. ");
INSERT INTO kwd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma nga alata God 'e tata'ea fa'asia nga maenga lo'oo nga fufu'iwane aana bi'i manata to'ona na ngaia 'e iiria nga 'ola lo'oo, ma gila ka bi'i tagoto'oa na nga Girigiringa Abu ma nga 'ola lo'oo la Jisas 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma nga alata la Jisas ngaia 'e nana'i 'i Jerusalem na nga Fangalaa na Tala Riunga, nga ta'a 'e aula gila tagoto'o no'o ana, tofuna gila agasia no'o ni 'ola ni 'alefosilai lo'oo ngaia 'e agea. ");
INSERT INTO kwd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma tafe'ua 'ani 'ino'ona, la Jisas ngaia 'ame faate'eni mousia ni 'ola te'efou 'ubulana manatalana, tofuna ngaia 'e su'a mola na manatalana ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Gwa'a te'efuta wane 'ame kwairii te'ana 'ania te'efuta 'ola suria nga ta'a, ngaia 'e su'a mola na nga 'ola te'efou 'ubulana manatalaga. ");
INSERT INTO kwd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Na te'e alata ngaa'i, te'e wane ba'ita 'i Jiu, ngaia 'e leka mai te'ala Jisas. Nga wane lo'oori latana la Nikodimas, ngaia nga wane na Farasii. Ngaia 'e leka mai te'ala Jisas 'ubulana logo, ma ka alafuu 'ilo'oo fana, “Wane kwaifa'ananaunga, 'imeeru meru su'aai 'i'oo na nga wane ni kwaifa'ananaunga na God 'e kwatea mai, tofuna ni 'ola ni 'alefosilai lo'oo 'i'oo agea, 'ato fana te'efuta wane 'ani agea lauta God 'ame nana'i fe'enia.” ");
INSERT INTO kwd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","La Jisas 'e lamadu'aa maka fata 'ilo'oo fana, “'Ola kwala'imori nau ku iiria famu, 'e 'ato fana te'efuta wane 'ani ru'u 'ubulana nga mooringa na God 'e ba'ita fafia, lauta ngaia 'ame futa la'u la'u.” ");
INSERT INTO kwd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma la Nikodimas 'e orisia la Jisas maka 'ilo'oo, “Nga wane ne'e ba'ita no'o, ngaia te'e futa la'u la'u la'a 'uta'i, welakau? 'Ato 'e iiki fana nga wane lo'oo 'ani ori la'u 'ubulana ni tete'e aana, ma ka futa la'u la'u la'a mai!” ");
INSERT INTO kwd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","La Jisas 'e fata 'ilo'oo fana, “'Ola kwala'imori nau ku iiria famu. 'Ato 'e iiki fana te'efuta wane 'ani ru'u 'ubulana mooringa lo'oo God 'e ba'ita fafia, lauta ngaia 'ame futa na ka'o ma nga Anoe 'ola Abu.” ");
INSERT INTO kwd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nga wane 'e to'o na mooringa na fanua lo'oo 'i wado tofuna ngaia futa na nga mama'a aana fe'enia nga tete'e aana. Ma wane te'e to'o na mooringa fooru tofuna ngaia 'e futa na Anoe 'ola Abu na God. ");
INSERT INTO kwd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'I'oo sia 'alefo mola, tofuna nau ku iiria famu 'i'oo 'ani futa fooru la'u. ");
INSERT INTO kwd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nga Anoe 'ola Abu ngaia 'e 'ilaka'u nga iru. Gwa'a 'i'oo longoa nga iru, 'i'oo sia agasia mola ngaia 'e leka mai fa'asia 'i fai, 'amoe ma ngaia 'e leka fani fai. Ma nga Anoe 'ola Abu 'e 'ino'ona la'u mola, 'i'oo sia agasia mola ngaia te'e lamadu'aa 'utaa na wane fana 'ani arua nga wane fooru.” ");
INSERT INTO kwd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","La Nikodimas 'e kwaiorisi la'u maka 'ilo'oo, “'Ilo'oo ma nga 'ola lo'oo te'e lau 'utaa welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","La Jisas 'e lamadu'aa maka 'ilo'oo fana, “'I'oo lo'oo nga wane ni kwaifa'ananaunga ba'ita 'i Jiu lo'oo no'o. Ma 'uta'i na'a 'i'oo 'ame su'a mola na nga fa'aladanga lo'oo? ");
INSERT INTO kwd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Ola kwala'imori nau ku iiria famu, 'imeeru meru alafuu suria nga 'ola na'a meru su'a ai, ma meru ka alafuu suria nga 'ola na'a meru agasia. Ma te'efuta wane amooru 'ame tagoto'o mola. ");
INSERT INTO kwd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aia, ma lauta moru 'ame tagoto'o na nga 'ola lo'oo nau ku kwairii ai te'amooru suria nga 'ola na fanua lo'o 'i wado, 'i no'ona ma tamoru tagoto'o 'uta'i agu lauta nau ku kwairii te'amooru suria nga 'ola mai 'i langi? ");
INSERT INTO kwd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma te'i nau, na nga Wela na Wane, lo'oo nau ku su'asuria nga 'ola ne'e lau mai 'i langi, tofuna nau ku sifo mai fa'asia 'i langi. Ma te'efuta wane 'amoe la'u lo'oo ne'e leka mai fa'asia 'i langi.” ");
INSERT INTO kwd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na alata laka'u 'i na'o, la Moses ngaia 'e launge'enia nga me'e waa 'ania nga aeon laka'u 'i 'ubulana nga gule'e lefu langalanga, ma ka arua 'i langi 'i gouna nga 'ai laka'u. Ma ngaia 'e 'ino'ona la'u mola, tagila arua nga Wela na Wane 'i langi 'i gouna nga 'ai, ");
INSERT INTO kwd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fana ni dai na gila tagoto'o agu, tagila momoori firi. ");
INSERT INTO kwd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God 'e faate'enia nga kwaimaanga ba'ita aana fana nga ta'a te'efou fofona fanua lo'o 'i wado, ngai lo'oo ngaia 'e kwatea mai nga Wela mouta'i aana, fana ni dai na'a gila tagoto'o ana, 'ato 'agila mae, tafe'ua ma tagila momoori firi. ");
INSERT INTO kwd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God 'ame kwatea mai nga Wela aana 'ubulana fanua lo'o 'i wado fana nga sufalana nga ta'a, ma ngaia 'e kwatea mai fana fa'amoorilaga. ");
INSERT INTO kwd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ma ni dai ne'e tagoto'o na nga Wela aana, God 'e sia sufaa mola. Ma ni dai ne'e 'ame tagoto'o ana, God 'e sufaa 'e sui no'o, tofuna ngaia 'ame tagoto'o na nga wela mouta'ia aana. ");
INSERT INTO kwd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God 'e sufaga tofuna 'ola lo'oo: Nga lalanga, ngaia 'e nigi mai 'ubulana nga fanua lo'o 'i wado. Tafe'ua ma nga ta'a, gila aile'a mola fe'enia nga logologo'angaa riufia nga lalanga, tofuna nga abulolaga 'e ria. ");
INSERT INTO kwd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Du'ana ni dai na'a falafala aana 'e ria, ngaia 'e ma'asini te'enia lalanga, ma ngaia 'ame siria lekanga mai fana lalanga, tofuna ngaia 'ame siria abulongaa 'ame le'a aana 'ani faata'i. ");
INSERT INTO kwd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tafe'ua ma ni dai ne'e agea 'ola 'e odo, ngaia 'e leka mai fana lalanga, fana nga lalanga lo'oo 'ani faate'enia nga 'ola na'a ngaia 'e agea 'e leka suria kwaisiriinga na God.” ");
INSERT INTO kwd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma burina, la Jisas fe'enia nga fufu'iwane aana gila leka fani Judea, ma gila ka nana'i 'i no'ona. Ma ngaia ka naruabu na ta'a 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma nga alata no'ona la'u mola, la Jon 'e naruabu na nga ta'a na fanua 'i Aenon galangia fanua 'i Salim. La Jon 'e naruabu aga 'i no'ona, tofuna lefu no'ona ka'o ngaia 'e aula ai. Aia, ma ta'a 'e aula la'u mola gila ka leka te'ana fana naruabunga. ");
INSERT INTO kwd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Na alata no'ona, gila 'ame arua 'ua la Jon 'ubulana 'ifi na lokafu.) ");
INSERT INTO kwd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nga alata no'ona, tani wane na fufu'iwane ala Jon, gila orikwaisu'usu'ui fe'enia te'e wane 'i Jiu suria nga falafala fana nga narufilana noniga, fana 'agila kwari 'i maana God. ");
INSERT INTO kwd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma fufu'iwane ala Jon gila leka te'ala Jon, ma gila ka fata 'ilo'oori, “Wane kwaifa'ananaunga, 'i'oo su'asuria nga wane laka'u ngai fe'eni'o gula loko'u na ka'o 'i Jodan, na'a 'i'oo alafuu suria? Na alata lo'oo, ngaia 'e naruabu no'o na ta'a, ma nga ta'a 'e aula, gila ka leka te'efou no'o te'ana.” ");
INSERT INTO kwd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma la Jon ka lamadu'aga maka 'ilo'oo, “Nga wane ngaia 'e agea mola nga taunga'inga na'a God 'e kwatea fana. ");
INSERT INTO kwd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amooru moru longoa te'efou no'o laka'u nau ku iiria famooru, 'inau nga Kraes 'amoe. Nau wane nau ku leka mai 'i na'o fana 'aku sasaria ta'a fana. ");
INSERT INTO kwd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mooru su'aai, alata wane 'e fuageni, nga noni laka'u ngaia noni na nga alakwa fooru no'o. Ma nga wane ni kwaimaanga na alakwa fooru lo'oori, ngaia 'e aile'a ba'ita alata ngaia 'e longoa nga kwala 'e 'ola na wane alakwa fooru. Ma ka 'ilo'oo la'u mola fana 'inau. Nau ku aile'a ba'ita na alata lo'oori, tofuna la Jisas ngaia 'e nigi no'o. ");
INSERT INTO kwd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngaia 'e le'a fana 'agila fa'aba'ita nga Kraes ma gila ka arusika'a no'o agu. ");
INSERT INTO kwd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Kiu, ma nga wane ne'e leka mai fa'asia 'i langi, ngaia 'e taringa'i maka ba'ita riufia nga ta'a te'efou. Te'efuta wane na fanua lo'o 'i wado 'e leka mai fa'asia fanua lo'o 'i wado. Ma ngaia 'e su'ana alafuunga suria nga 'ola ne'e lau 'ubulana fanua lo'o 'i wado la'u mola. Ma nga wane ne'e leka mai fa'asia 'i langi, ngaia 'e taringa'i maka ba'ita riufia nga ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ngaia 'e alafuu wataga suria 'olataa na'a ngaia 'e agasia maka longoa. Ma gwa'a 'ani 'ino'ona, te'efuta wane 'ame siria mola tagoto'onga na 'olataa na'a ngaia 'e fata 'i suria. ");
INSERT INTO kwd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma nga wane na'a ngaia 'e tagoto'o ana 'olataa na'a ngaia 'e iiria, nga wane lo'oori ngaia 'e faate'enia 'ola na'a God 'e iiria ngaia 'e kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma nga wane na'a God 'e kwatea mai fa'asia 'i langi, ngaia 'e foulange'enia fatalana God, tofuna God 'e kwatea no'o mai nga Anoe 'ola Abu aana fana 'ani fa'afongua maka boonia. ");
INSERT INTO kwd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma God nga Mama'a 'e kwaimaa ba'ita no'o fana Wela aana, ma ka arua ngaia 'ani ba'ita fafia nga 'ola te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma ni dai ne'e tagoto'o na nga Wela lo'oo, ngaia te'e momoori firi. Ma ni dai ne'e 'ame tagoto'o na Wela lo'oo, ngaia te'e mae, ma kwaisufaingaa na God fana te'e nana'i firi.” ");
INSERT INTO kwd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nga ta'a Farasii gila longoa na nga ta'a 'e aula gila ka leka suria la Jisas maka riufia la Jon wane ni naruabunga, ma ngaia ka naruabu na ta'a riufia la Jon la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tafe'ua ma la Jisas ngaia 'ame naruabu mola na ta wane. Nga fufu'iwane aana na gila agea 'ola lo'oo.) ");
INSERT INTO kwd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tofuna 'ola lo'oo la Jisas fe'enia nga fufu'iwane aana, gila ka leka no'o fa'asia gule'e lefu 'i Judea, ma gila ka leka no'o fana gule'e lefu 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma nga alata gila leka kau fani Galili, gila ka riu no'o na gule'e lefu 'i Samaria. ");
INSERT INTO kwd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma gila ka nigi na fanua 'i Saeka 'i 'ubulana nga gule'e lefu 'i Samaria, na ngaia 'e to'oru galangia nga wado na la Jekob ngaia 'e kwatea fana wela aana la Josef 'ua mai na'o. ");
INSERT INTO kwd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma me'e ka'o na la Jekob 'e 'eria 'e to'oru la'u mola 'i no'ona. Ma la Jisas ngaia ka to'oru nigifana nga ka'o lo'oori tofuna ngaia 'e kweo no'o na nga lekanga. Ma nga alata no'ona, ngaia 'e to'omia no'o nga dalototo'o na gani. ");
INSERT INTO kwd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Burina nga fufu'iwane aana gila leka na fanua no'ona fana 'agila foria fangalaa, te'e noni fa'asia 'i Samaria 'e leka mai fana 'ani ufia ka'o ana. Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi kwatea mai nga ka'o, 'aku go'u madi welakau.” ");
INSERT INTO kwd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma nga noni no'ona ka lamadu'aa maka 'ilo'oo, “'I'oo nga wane 'i Jiu, mai nau nga noni 'i Samaria. 'Utaa na 'i'oo kwaisoe agu fana ka'o fana go'unga?” Ngaia 'e alafuu 'ilo'oo, tofuna nga ta'a 'i Jiu gila 'ame oguogu fe'enia nga ta'a 'i Samaria. ");
INSERT INTO kwd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma la Jisas ka lamadu'aa maka 'ilo'oo, “'I'oo 'ame su'asuria nga 'olataa na God 'e siria 'ani kwatea famu, ma 'i'oo 'ame su'asuria ni dai ne'e kwaisoe amu fana ka'o. Lauta 'i'oo su'aai, 'i'oo to'o kwaisoe agu, mai nau taku kwatea nga ka'o na mooringa firi famu.” ");
INSERT INTO kwd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma nga noni no'ona ka alafuu 'ilo'oo fana, “Welakau, 'i'oo 'ame to'o na te'efuta 'ola fana ufilana ka'o, ma nga ka'o lo'oo 'e sifo 'e iiki la'u mola. 'I'oo to'o daria nga ka'o na mooringa no'ona 'i fai welakau? ");
INSERT INTO kwd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nga wawarifu meeru la Jekob na ngaia 'e kwatea nga me'e ka'o lo'oo fameeru. Ma ngaia, fe'enia nga ru'uru'ua aana, ma ni 'ola na gila to'o ai, gila go'u la'u mola na me'e ka'o lo'oo. Fe'ua? 'I'oo madafia iiria 'i'oo ba'ita 'e riufia la Jekob welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma la Jisas ka fata 'ilo'oo, “Ni dai ne'e go'ufia nga ka'o lo'oo, ngaia 'e su'asuria 'ani maarigo'u la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tafe'ua ma ni dai ne'e go'ufia nga ka'o lo'oo nau taku kwatea, ngaia 'e sia maarigo'u la'u. Ma nga ka'o lo'oo nau taku kwatea fana te'e 'ilaka'u nga me'e ufu moori ne'e kwatea nga mooringa firi fana.” ");
INSERT INTO kwd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma nga noni no'ona ka alafuu 'ilo'oo, “Welakau, to'o kwatea no'o ka'o no'ona fagu, fana nau ku sia maarigo'u la'u, mai nau ku sia leka la'u mai 'i lo'oo fana ngarilana ka'o la'u.” ");
INSERT INTO kwd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi leka, moko soea mai nga kwaiimu, ma molo ka ori mai 'i lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma nga noni lo'oo ka lamadu'aa maka 'ilo'oo, “Nau ku 'ame to'o na wane.” La Jisas ka fata 'ilo'oo, “'I'oo alafuu kwala'imori alata 'i'oo iiria 'i'oo 'ame to'o na ta wane. ");
INSERT INTO kwd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tafe'ua, 'i'oo to'o no'o na nga nima wane, ma nga wane no'ona 'i'oo nana'i fe'enia na alata lo'oo, ngaia nga kwaiimu kwala'imori 'amoe la'u mola. Nga 'ola na 'i'oo iiria fagu 'e kwala'imori no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma nga noni no'ona ka lamadu'aa maka 'ilo'oo, “Welakau, nau ku su'aai 'i'oo nga profet. ");
INSERT INTO kwd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nga wawarifu meeru, gila fo'asia God 'i gouna busu lo'oori. Ma mooru nga ta'a 'i Jiu, moru iiria lefu fana fo'osilana God na'a 'i Jerusalem. 'Ilo'oo ma 'i fai na rua lefu lo'oo ne'e kwala'imori welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma la Jisas ka alafuu fana noni laka'u maka 'ilo'oo, “'Oi tagoto'o agu, nga alata te'e nigi mai fana nga ta'a gila sia fo'asia mola nga Mama'a 'i gouna busu lo'oo 'amoe ma 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mooru nga ta'a 'i Samaria, moru bobolosia mola ni dai na'a moru fo'asia. Tafe'ua ma meeru nga ta'a 'i Jiu, 'imeeru meru su'asuria ni dai na'a meru fo'asia, tofuna falafala na God fana fa'amoorilana ta'a 'e 'ita mai fa'asi 'ameeru ta'a 'i Jiu. ");
INSERT INTO kwd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tafe'ua ma nga alata te'e nigi mai, ma ngaia lo'oo 'e eta no'o, fana nga ta'a na gila fo'asia kwala'imori 'agila fo'asia God 'ania tegelangaa na nga Anoe 'ola Abu ma suria to'onga na God. Nga Mama'a 'e kwailo'ofia ta'a 'ilo'oo fana 'agila fo'asia. ");
INSERT INTO kwd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God na'a Anoe 'ola, ma ta'a na gila fo'asia, gila fo'asia 'ania tegelangaa na Anoe 'ola Abu ma suria to'onga na God.” ");
INSERT INTO kwd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma nga noni lo'oori ka alafuu 'ilo'oo fana, “Nau ku su'aai nga Kraes te'e nigi mai. Ma na alata na'a ngaia 'ani nigi mai, ngaia te'e kwairii te'adauru 'ania nga 'ola te'efou.” ");
INSERT INTO kwd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","La Jisas 'e lamadu'aa maka 'ilo'oo, “Nau lo'oo nau ku alafuu fe'eni'o, nau na nga wane no'ona.” ");
INSERT INTO kwd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma nga alata no'ona, nga fufu'iwane aana gila ka nigi no'o mai, ma gila ka 'alefo ba'ita, tofuna gila agasia la Jisas ngaia 'e alafuu mola fe'enia nga noni no'ona. Tafe'ua ma te'efuta wane aga 'ame orisia mola nga noni lo'oo 'ilo'oo, “'Olataa na'a 'i'oo siria,” ma gila 'ame orisia la'u mola la Jisas 'ilo'oo, “Fe'ua na'a 'i'oo alafuu fe'enia nga noni lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma nga noni laka'u ka rugasia no'o ni 'ola ana fana ngarilana ka'o, ma ka ori no'o 'i fanua, ma ka kwairii fana nga ta'a no'ona, ");
INSERT INTO kwd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Moru leka mai, fana 'amoru agasia nga te'e wane na'a ngaia 'e kwairii te'agu na ni 'ola te'efou nau ku agea. Bala nga Kraes laka'u ta'ua lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma gila ka 'akwasia nga fanua laka'u, ma gila ka leka mai te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma nga alata no'ona, nga fufu'iwane aana gila ka fata 'ilo'oo fana, “Wane kwaifa'ananaunga, 'ania madi nga fangalaa, welakau.” ");
INSERT INTO kwd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Nau ku to'o na nga fangalaa na'a mooru 'ame su'aai.” ");
INSERT INTO kwd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma nga fufu'iwane aana, gila ka daiorisiga kwairiu ma gila ka 'ilo'oo, “Bala te'efuta wane 'e ngaria fangalaa mai fana, ta'ua lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma la Jisas ka alafuu 'ilo'oo faga, “Nga fangalaa agu no'o fana lo'onga suria nga fatalana God ne'e kwate nau mai fai, ma nga fa'asuilana nga taunga'inga aana lo'oo ngaia 'e kwatea fagu fana agelai. ");
INSERT INTO kwd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aia, ma moru su'a na te'e fa'aladanga laka'u ngaia 'e 'ilo'oo, ‘Fai singari, sui ma nga goni 'olanga te'e bi'i lau.’ Ma nau ku iiria famooru, moru agasia madi nga ta'a na'a gila leka mai. Gila 'ilaka'u nga langa'a ne'e suka no'o, ma ka sasari no'o fana gonilai. ");
INSERT INTO kwd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta'a na gila gonia lodona 'ola 'ubulana langa'a, gila ngaria nga foforinga aga. Ma lodona 'ola na'a ta'a na gila ngaria na mooringa firi. Nga ta'a na gila kirua 'ola, ma nga ta'a na gila gonia 'ola, tagila aile'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma nga alafuunga 'e kwala'imori ne'e fata 'ilo'oo, ‘Te'e wane ngaa'i ngaia 'e kirua 'ola, ma nga wane ngaa'i 'e gonia 'ola.’ ");
INSERT INTO kwd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nau ku ale 'amooru fana nga gonilana 'ola 'ubulana langa'a na'a moru 'ame taunga'i ai. Du'ana tani wane ngaa'i gila taunga'i no'o ai, ma mooru ka ngaria tago no'o na le'anga na taunga'ilaga.” ");
INSERT INTO kwd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma nga ta'a 'e aula na nga gule'e lefu lo'oo 'i Samaria, gila tagoto'o no'o ala Jisas tofuna nga noni no'ona ngaia 'e kwairii 'ilo'oo faga, “Ngaia 'e kwairii te'agu 'ania 'ola te'efou na'a nau ku agea.” ");
INSERT INTO kwd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma nga alata gila leka mai te'ala Jisas, gila ka 'unea fana ngaia 'ani nana'i la'u mola fe'eniga. Ma la Jisas ka nana'i no'ona suria rua gani. ");
INSERT INTO kwd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma nga ta'a 'e aula la'u gila ka tagoto'o tofuna nga alafuunga lo'oo ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma gila ka fata 'ilo'oo fana nga noni lo'oo ma gila ka 'ilo'oo, “Meeru meru tagoto'o no'o lo'oo, 'amoe la'u tofuna nga 'ola laka'u 'i'oo fata suria fameeru, tafe'ua ma tofuna na'a meeru talameeru meru longoa nga fatalana la'u mola. Ma meru ka su'aai na'a ngaia no'o nga Wane ni Kwaifa'amooringa kwala'imori fana ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Buri na la Jisas fe'enia fufu'iwane aana gila nana'i na fanua no'ona suria rua gani 'e sui, gila bi'i leka fana 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","La Jisas 'i talana na'a ngaia 'e alafuu 'ilo'oo, “Nga ta'a gila 'ame iiri ba'ita no'o na nga profet 'ubulana fanua aana 'i talana.” ");
INSERT INTO kwd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma alata la Jisas 'e ori mai fana 'i Galili, nga ta'a lo'oori gila kwaloa, suria gila leka la'u mola 'i Jerusalem fana Fafangalaa na Tala Riunga, ma gila ka agasia nga 'ola na'a la Jisas ngaia 'e agea 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ma la Jisas ka ori la'u fani Kena 'ubulana nga gule'e lefu 'i Galili, nga lefu laka'u ngaia 'e bulosia nga ka'o fana nga waen. Ma nga alata ngaia 'e nana'i 'i no'ona, nga alakwa na te'e wane ba'ita fa'asia 'i Kapaneam, ngaia 'e fii 'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma nga alata nga wane lo'oo 'e longoa la Jisas ngaia 'e leka no'o fa'asia 'i Judea ma ka ori la'u mai fani Galili, ngaia 'e leka mai te'ala Jisas, fana 'ani soea fana 'ani leka fe'enia fani Kapaneam, fana 'ani gulaa nga alakwa aana, tofuna ngaia 'e fii maka gagalani mae no'o. ");
INSERT INTO kwd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","La Jisas ka alafuu 'ilo'oo fana, “Moru siria mola 'amoru agasia 'ola ni 'alefosilai sui ma tamoru bi'i tagoto'o agu.” ");
INSERT INTO kwd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gwa'a la Jisas 'e fata 'ilo'oo, nga wane lo'oo ngaia 'e 'unea no'o la Jisas, “Alafa, to'o leka madi mai fe'eni nau, fa'asia nga wela agu ta mae mola.” ");
INSERT INTO kwd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi ori no'o kau, nga alakwa amu ngaia 'e gwari'a no'o.” Ma nga wane no'ona ka leka no'o, tofuna ngaia 'e tagoto'o na nga fatalana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma alata ngai 'ua mola kau suria tala, nga ta'a ni taunga'inga aana, gila ka totola mai fana kwairiinga te'ana, ma gila ka 'ilo'oo, “Wane ba'ita nga wela laka'u amu, ngaia 'e gwari'a no'o!” ");
INSERT INTO kwd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma nga wane ba'ita lo'oori ka orisiga alata taa na'a nga alakwa ana ngaia 'e gwari'a ai. Ma gila lamadu'aa 'ilo'oo, “Nga 'ago'agonga 'e sui fa'asia naboni na alata sisina 'e asua.” ");
INSERT INTO kwd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma nga mama'a na wela lo'oo 'e su'a no'o na alata laka'u la Jisas 'e iiria fana, “Nga alakwa amu ngaia 'e gwari'a no'o.” Ma 'i burina 'ola lo'oo, nga wane ba'ita lo'oo fe'enia nga ta'a te'efou 'ubulana 'ifi aana, gila ka tagoto'o no'o ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma 'ola lo'oori nga ruana 'ola ni 'alefosilai na'a la Jisas 'e agea na alata ngaia 'e ori mai fa'asia 'i Judea fani Galili. ");
INSERT INTO kwd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'I burina 'ola lo'oori, la Jisas ka leka fani Jerusalem fana te'e fafangalaa 'i Jiu. ");
INSERT INTO kwd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","'I Jerusalem, te'e ka'o ngaia 'e nana'i mola galangia nga lefu na'a gila fa'alataa 'ania tatafa na sifisifi. Aia, ma nga alafuunga na ta'a 'i Jiu, gila iiria nga ka'o lo'oori 'ania 'i Betsaeda. Ma nga nima fofoda 'e tekwa na'a gila nana'i 'i nigifana nga me'e 'ekwa lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ta'a 'e aula iiki na'a gila eeno fofona fofoda no'ona. Ta'a no'ona gila fii 'ania ni late'e fiinga kwaitatari: ta'a maaga 'e logo, ta'a noniga 'e mae, ma ta'a nimaga 'e mae ma nga 'a'aega 'e mae la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma te'e wane 'e to'oru fe'eniga 'i no'ona, ngaia 'e fii no'o suria oru akwale'e farisi ma kwaru ai. ");
INSERT INTO kwd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma la Jisas ka agasia ngaia eeno mola na lefu no'ona, ma ngaia 'e su'aai na'a ngaia 'e fii 'e aburu no'o mai, ma ngaia ka orisia nga wane no'ona maka 'ilo'oo, “'Ilo'oo ma 'i'oo siria 'ano gwari'a?” ");
INSERT INTO kwd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma nga wane no'ona ka lamadu'aa la Jisas maka 'ilo'oo, “Wane ba'ita, te'efuta wane 'amoe agu fana 'ani ngari nau fana 'ubulana ka'o lo'oo na alata na'a ka'o 'e 'asu. Na alata 'e aula, alata nau ku sasari fana 'aku leka 'ubulana ka'o lo'oo, tani wane ngaa'i gila leka no'o ai 'i na'o fa'asi nau.” ");
INSERT INTO kwd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma la Jisas ka alafuu 'ilo'oo, “Tata'e, moko ngaria no'o futa'i amu moko leka no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma te'e alata no'ona mola, nga wane lo'oori ka le'a no'o, ma ngaia ka tata'e, ma ka ngaria no'o futa'i aana, ma ka leka no'o. Ma nga gani no'ona nga Sabat. ");
INSERT INTO kwd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ngaia lo'oo nga ta'a na'ona'o 'i Jiu, gila ka alafuu 'ilo'oo fana wane na'a ngaia 'e gwari'a, “Tala'ina nga Sabat, ma ngaia 'e abu 'e iiki na tagi adauru fana 'i'oo 'ani ngaria nga futa'i amu.” ");
INSERT INTO kwd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wane lo'oori ka alafuu 'ilo'oo faga, “Nga wane na ngaia 'e gulaa nau, ngaia 'e iiria 'aku ngaria futa'i agu, ma kua leka.” ");
INSERT INTO kwd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma gila ka orisia la'u ma gila ka 'ilo'oo, “Wane ngai taa ne'e iiria 'i'oo 'ani agea nga 'ola no'ona, welakau.” ");
INSERT INTO kwd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tafe'ua ma nga wane lo'oo 'e bobolosia mola la Jisas, tofuna nga ta'a 'e aula iiki na'a gila nana'i na lefu no'ona ma la Jisas ka leka no'o kau. ");
INSERT INTO kwd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma 'i burina, la Jisas bi'i daria 'ubulana 'Ifi Abu na God, ma ka alafuu 'ilo'oo fana, “'Oi longo madi mai, na alata lo'oo, 'i'oo le'a no'o. 'Oi abulo no'o fa'asia abulongaa laka'u amu 'ame le'a fa'asia te'efuta 'ola 'e ria iiki ta bi'i lau amu la'u 'i buri.” ");
INSERT INTO kwd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na alata wane laka'u ngaia 'e ru'u 'i maa fa'asia nga 'Ifi Abu na God, ngaia 'e leka te'ana ta'a na'ona'o 'i Jiu, maka alafuu 'ilo'oo faga, “La Jisas laka'u ngaia 'e gula nau.” ");
INSERT INTO kwd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma nga alata no'ona, gila ka eta no'o fana marimaenga ala Jisas, tofuna ngaia 'e gulaa nga wane lo'oo na Sabat. ");
INSERT INTO kwd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma la Jisas ka alafuu 'ilo'oo faga, “Lauta na Mama'a agu ngaia 'e taunga'i gani mai gani, nau la'u mola nau taku taunga'i la'u mola 'ino'ona.” ");
INSERT INTO kwd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aia, ma tofuna nga alafuunga lo'oori, ngaia agea manatalana ta'a na'ona'o 'i Jiu lo'oo ka tegela no'o fana 'agila kwa'ia la Jisas 'ani mae. Gila siria kwa'ilana, suria ngaia 'ame manata ba'ita na falafala suria nga Sabat, ma gila siria 'e iiki 'agila kwa'ia suria ngaia 'e iiria God nga Mama'a aana. Alata ngaia 'e iiria 'ola lo'oo, ngaia 'e fa'atooto'ome'enia 'i talana fe'enia God. ");
INSERT INTO kwd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru. Nau, na nga Wela na God, 'e 'ato 'aku agea te'efuta 'ola 'i talagu. Nau ku agea mola 'ola na'a nau ku agasia nga Mama'a agu ngaia 'e agea. Ma 'olataa na'a Mama'a agu 'e agea, ngaia la'u mola na'a nau ku agea. ");
INSERT INTO kwd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Du'ana Mama'a agu ngaia 'e kwaimaa fagu, ma ngaia ka faate'enia fagu nga 'ola te'efou na ngaia 'e agea. Ma ngaia te'e faate'enia la'u mola fagu ni taunga'inga ba'ita la'u ne'e riufia gulalana nga ta'a lo'oo, ma tamoru 'alefo ba'ita na 'ola lo'oo nau ku agea. ");
INSERT INTO kwd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mama'a agu ngaia 'e su'aai 'ani tata'ea wane 'e mae 'ua ma ka kwatea mooringa fana. Ma 'ino'ona la'u mola, nau nga Wela aana, nau taku kwatea mooringa la'u mola fana ni dai na 'aku firiga. ");
INSERT INTO kwd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mama'a agu ngaia 'e sia sufaa mola te'efuta wane tofuna ngaia 'e kwatea tegelangaa fana kwaisufaingaa no'o fana nga Wela aana. ");
INSERT INTO kwd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ngaia 'e agea 'ola lo'oo fagu fana nga ta'a 'agila iiri ba'ita agu, 'ilaka'u la'u mola na gila iiri ba'ita na nga Mama'a agu. Ma ni dai ne'e 'ame iiri ba'ita agu, ngaia 'ame iiri ba'ita la'u mola na Mama'a agu na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“'Ola kwala'imori nau ku iiria famooru. Ni dai ne'e longoa nga fatalagu, ma ka tagoto'o na God ne'e alenau mai, ngaia te'e to'o na mooringa firi. Nau ku sia sufaa la'u. Ma ngaia 'e leka no'o fa'asia maenga, ma ka ru'u no'o 'ubulana mooringa kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'Ola kwala'imori nau ku iiria te'amooru, alata te'e nigi mai, ma ngaia lo'oo 'e nigi no'o mai, fana ni dai na gila leka no'o suria tala fana maenga, 'agila longo nau, nga Wela na God. Ma ni dai na gila lo'o suri nau, tagila moori. ");
INSERT INTO kwd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","27","'Ilaka'u nga Mama'a na nga 'aefungana mooringa kwala'imori, ngaia 'e kwate nau, nga Wela aana, 'aku 'ilaka'u la'u mola 'aefungana mooringa kwala'imori fana ta'a. Ma ngaia ka kwatea no'o tegelangaa fagu, nga Wela aana, fana 'aku sufaa nga ta'a tofuna 'inau nga Wela na Wane. ");
INSERT INTO kwd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Moru sia 'alefo mola na 'ola lo'oo. Nga alata te'e nigi mai fana ta'a na gila mae 'ua no'o, 'agila longo nau, ");
INSERT INTO kwd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma gila ka ru'u mai fa'asia nga giru gwa'u aaga, fana ni dai na gila agea 'ola 'e le'a lo'oo, 'agila tata'e mai, fana mooringa firi. Ma ni dai na gila agea 'ola 'e ria, gila ka tata'e mai, ma gila to'oru 'ubulana nga kwa'ikwa'inga 'e nana'i firi. ");
INSERT INTO kwd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nau ku 'ame agea te'efuta 'ola suria manatalagu 'i talagu. Nau ku su'aai nau ku sufaa ta'a suria 'olataa na nau ku longoa God ngaia 'e iiria fagu. Nga kwaisufaingaa agu ngaia 'e odo, tofuna nau ku agea suria nga 'olataa na ngaia 'e siria, mai nau ku 'ame agea suria nga kwaisiriinga agu 'i talagu. ");
INSERT INTO kwd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Lauta 'i nau 'aku kwairii suri nau 'i talagu, te'efuta wane 'e sia tagoto'o mola na kwairiinga lo'oo agu. ");
INSERT INTO kwd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tafe'ua ma Mama'a agu 'e kwairii la'u mola suri nau. Mai nau ku su'ana 'olataa na ngaia 'e kwairii 'ania suri nau ngaia 'e kwala'imori te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aia, ma mooru laka'u moru kwatea kau nga wane 'amooru te'ala Jon, ma ngaia 'e kwairii te'amooru 'ania to'onga suri nau. ");
INSERT INTO kwd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nau ku sia mangoto'o mola na nga 'olataa na wane te'e alafuu 'ania suri nau, tafe'ua nau ku alafuu suria me'e alafuunga ala Jon fana 'ani booni 'amooru fana 'amoru to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma la Jon 'e 'ilaka'u nga me'e uunu ne'e lala 'e le'a. Ma suria te'e alata sisika, mooru moru aile'a mola suria 'olataa na ngaia 'e fata suria. ");
INSERT INTO kwd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tafe'ua mai nau ku to'o na 'ola ne'e taringa'i 'e riufia alafuunga ala Jon. Ma nga 'ola lo'oori no'o na nga taunga'inga na nau ku agea suria nga Mama'a agu na ngaia 'e kwatea fagu fana 'aku agea. Nga taunga'inga lo'oo agu 'e faate'enia na Mama'a agu ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma nga Mama'a agu 'i talana ne'e alenau mai, ngaia 'e alafuu no'o suri nau. Ma moru 'ame longoa kwalana, ma moru 'ame agasia la'u mola ");
INSERT INTO kwd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma moru 'ame kwaloa la'u mola fatalana 'ubulana moori lamooru, suria moru 'ame tagoto'o agu na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mooru moru idumia nga Girigiringa Abu lo'oo furifuri, suria moru madafia iiria moru to'o na nga mooringa firi 'i tofuna. Ma nga Girigiringa Abu lo'oori ngaia 'e alafuu suri nau. ");
INSERT INTO kwd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gwa'a 'ani 'ilo'oo, moru 'ame siria mola lekanga mai te'agu fana 'aku fa'amoori 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mai nau ku 'ame kwailo'ofia te'efuta wane fana 'ani iiri ba'ita agu. ");
INSERT INTO kwd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tafe'ua mai nau ku su'aai na moru 'ame to'o mola na te'efuta kwaimaanga fana God. ");
INSERT INTO kwd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nau ku leka mai na nga tegelangaa na Mama'a agu, tafe'ua ma moru 'ame kwalo nau mola. Ma lauta te'efuta wane ngaia 'e leka mai na nga tegelangaa aana 'i talana, tamoru kwalo le'a ana. ");
INSERT INTO kwd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Moru siria nga ta'a 'agila tafe 'amooru. Tafe'ua ma moru 'ame siria mola nga agelana 'ola 'e le'a lo'oo fana God 'ani tafe 'amooru. Ma tofuna ngaia 'e 'ino'ona, ngaia 'e 'ato 'e iiki no'o fana 'amooru tagoto'o agu. ");
INSERT INTO kwd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nau ku sia fata mola fafi 'amooru 'i na'ona Mama'a agu. La Moses laka'u na moru madafia ngaia te'e kwaibooni amooru, ngaia no'o na te'e fata fafi 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Lauta moru tagoto'o no'o ala Moses, to'omia 'amooru tagoto'o agu la'u mola, tofuna ngaia laka'u 'e giria mai suria nau. ");
INSERT INTO kwd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aia, ma tofuna 'amooru 'ame tagoto'o na 'olataa na la Moses ngaia 'e giria suri nau, ngaia 'e 'ato 'e iiki famooru 'amooru tagoto'o na 'olataa na nau ku iiria te'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma 'i buri, la Jisas ka olofolo no'o na asi 'i Galili na gila fa'alataa 'ania asi 'i Taebirias. ");
INSERT INTO kwd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma nga ogunga ba'ita gila leka la'u mola 'i burina, tofuna gila agasia ni 'ola ni 'alefosilai lo'oo ngaia 'e agea fana nga gulalana nga ta'a lo'oo gila fii. ");
INSERT INTO kwd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ma la Jisas ka fane 'i gouna me'e busu, ma ka to'oru 'i wado fe'enia nga fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na alata no'ona, nga Fafangalaa na Tala Riunga na Jiu ngaia 'e galangi no'o. ");
INSERT INTO kwd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","La Jisas ka aga garigaria, ma ka agasia nga oguogunga ba'ita gila nigi mai te'ana, ma ka alafuu 'ilo'oo fala Filip, “'I fai na tagoru foria nga fangalaa na te'e to'omia fana 'agoru langonia 'ania nga ta'a lo'oo te'efou?” ");
INSERT INTO kwd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ngaia 'e fata 'ilo'oo tofuna ngaia 'e siria 'ani irito'ona la Filip, tofuna ngaia 'e su'a no'o na 'ola lo'oo ngaia te'e agea. ");
INSERT INTO kwd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma la Filip 'e lamadu'aa maka 'ilo'oo, “Gwa'a nga foforinga ne'e to'omia kwaru singari ma 'e sia to'omia mola fana nga forilana gwa'a me'e fangalaa sisika faga.” ");
INSERT INTO kwd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma te'e wane na fufu'iwane aana la Andru, nga wanefuta ala Saemon Pita, ngaia ka fata 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te'e wela wane ngai 'i lo'oo, ma ngaia 'e to'o mola na nima mani'i beret fe'enia rua gweii'a. Tafe'ua ma ngaia 'ato 'ani to'omia nga ta'a auaula lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma la Jisas ka iiria faga maka 'ilo'oo, “Moru iiria fana nga ta'a 'agila to'oru 'i wado.” Nga farisi ngaia 'e aula no'ona. Ma nga ta'a te'efou gila ka to'oru 'i wado, ma ngaia toto'o fe'enia ni nima to'oni (5,000) wane. ");
INSERT INTO kwd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma la Jisas ka ngaria mani'i beret lo'oori, ma ka baatafea God, ma ka dalo'ia fana nga ta'a lo'oo gila nana'i 'i no'ona. Ma ngaia ka agea 'ino'ona la'u mola na gweii'a no'ona. Ma gila te'efou, gila ngaria maka to'omia no'o 'olataa na gila siria te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma alata gila bote no'o, ngaia ka alafuu 'ilo'oo fana nga fufu'iwane aana, “Moru gonia no'o furufuruna fangalaa lo'oo 'e ole, suria goru sia ngadaa mola nga ketonga.” ");
INSERT INTO kwd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma gila ka goni te'efou no'o ai, ma gila ka fa'afongua nga akwale'e kukudu ma ruaai na nga furufuruna fangalaa ne'e ole na nga nima mani'i beret laka'u gila 'ania. ");
INSERT INTO kwd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma nga alata nga ta'a gila agasia 'ola ni 'alefosilai lo'oo la Jisas ngaia 'e agea, ma gila ka fata 'ilo'oo, “Wane lo'oo, ngaia nga profet na ngaia te'e nigi mai 'ubulana nga fanua lo'o 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma la Jisas ka leka no'o kau fa'asiga fana nga busu te'ingaia, tofuna ngaia 'e su'aai gila galangi gila ka leka no'o mai fana 'agila ula 'i burina fana ngaia 'ani kiingi faga. ");
INSERT INTO kwd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma laulafi, nga fufu'iwane aana gila ka sifo no'o fana nigifana asi no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma gila ka ta'e 'ubulana nga baru, ma gila ka eta fana 'agila olofolo no'o na asi no'ona fana nga fanua 'i Kapaneam. Ma nga logo ka logo no'o mai, ma la Jisas ngaia 'ame nigi 'ua te'aga. ");
INSERT INTO kwd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Alata no'ona nga iru ma bio ba'ita ka to'o no'o mai. ");
INSERT INTO kwd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma nga alata gila faruta to'omia nima kilomita 'amoe ma ono kilomita, gila aga kau, ma gila ka agasia la Jisas ngaia 'e leka mai fofona asi, ma ka leka galangi no'o mai te'ana baru. Ma nga fufu'iwane aana gila ma'u ma gila ka lebelebe no'o. ");
INSERT INTO kwd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma la Jisas ka alafuu 'ilo'oo kau faga, “Moru sia ma'u mola! Nau lo'oo mola.” ");
INSERT INTO kwd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma 'i burina nga 'ola lo'oo, ngaia ka fane 'ubulana baru, ma gila ka aile'a ba'ita. Ma alata no'ona mola ma gila ka nigi no'o na fanua na gila leka fai. ");
INSERT INTO kwd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ma alata ngaia 'e gani wataga no'o mai, nga oguogunga na gila nana'i 'ua na gule'e asi laka'u, gila madafia la Jisas 'e nana'i 'ua. Tofuna gila su'aai te'e baru momola ngai ai, ma gila su'a la'u mola na la Jisas 'ame leka 'ubulana baru fe'enia fufu'iwane aana. ");
INSERT INTO kwd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma tani baru ngaa'i fa'asia 'i Taebirias gila bi'i nigi galangia nga lefu laka'u la Jisas 'e baatafea God fana nga fangalaa laka'u ai, ma bi'i kwatea fana ta'a auaula laka'u. ");
INSERT INTO kwd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma nga alata na oguogunga lo'oori gila 'ame agasia no'o la Jisas ma nga fufu'iwane aana, gila ta'e na baru, ma gila ka leka 'agila kwailo 'ofia la Jisas 'i Kapaneam. ");
INSERT INTO kwd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma alata gila daria la Jisas na gule'e asi no'ona, gila ka kwaiorisi 'ilo'oo ana, “Wane ni kwaifa'ananaunga, alata taa no'ona 'i'oo leka mai 'i lo'oo welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru, mooru kwailo'ofi nau, tofuna na moru 'ania mani'i beret laka'u ma moru bote, ma 'amoe la'u tofuna na moru su'aai nga fa'awatagalana nga 'ola ni 'alefosilai laka'u nau ku agea. ");
INSERT INTO kwd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moru sia taunga'i mola fana nga fangalaa na te'e sui mola. Mooru taunga'i fana nga fangalaa ne'e kwatea mooringa firi famooru. Nau, nga Wela na Wane na, nau taku kwatea famooru nga fangalaa na mooringa firi lo'oori, tofuna God nga Mama'a ngaia 'e faate'enia no'o na ngaia 'e aile'a fe'eni nau.” ");
INSERT INTO kwd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngai lo'oo ta'a gila orisia 'ilo'oo, “Nga 'olataa na tameru agea fana 'ameru launge'enia nga taunga'inga na God ngaia 'e siria fameeru?” ");
INSERT INTO kwd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Nga kwaisiriinga ala God ngaia 'e 'ilo'oo: Moru tagoto'o na wane na ngaia 'e kwatea mai.” ");
INSERT INTO kwd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma gila ka orisia la'u 'ilo'oo, “Nga 'ola ni 'alefosilai 'utaa na to'o agea, fana 'ameru agasia ma meru ka tagoto'o amu? 'Olataa na 'i'oo to'o agea? ");
INSERT INTO kwd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","La Moses 'e kwatea nga beret laka'u gila fa'alataa 'ania ‘mana’ fana nga wawarifu meeru 'i 'ubulana nga gule'e lefu langalanga, 'ilaka'u gila giria na nga Girigiringa Abu 'ilo'oo, ‘Ngaia 'e kwatea nga beret fa'asia 'i langi faga fana 'anilai.’” ");
INSERT INTO kwd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma la Jisas ka fata 'ilo'oo faga, “'Ola kwala'imori nau ku iiria famooru, la Moses ngaia 'ame kwatea nga beret fa'asia 'i langi faga. Tafe'ua Mama'a agu ne'e kwatea faga. Ma Mama'a agu ne'e kwatea la'u mola nga beret kwala'imori fa'asia 'i langi famooru. ");
INSERT INTO kwd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nga beret kwala'imori na God ngaia 'e kwatea, ngaia na nga wane ne'e sifo mai fa'asia 'i langi, ma ka kwatea nga mooringa fana nga ta'a te'efou fofona nga fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma gila ka alafuu 'ilo'oo fana, “Welakau, 'ita tala'ina maka ori 'ala'a, to'o kwatea no'o beret lo'oo fameeru.” ");
INSERT INTO kwd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma la Jisas ka alafuu 'ilo'oo, “Nau no'o na beret na mooringa. Ni dai ne'e leka mai te'agu, ngaia 'ato 'ani molo'u la'u. Ma ni dai ne'e tagoto'o agu, ngaia 'ato 'ani maarigo'u la'u. ");
INSERT INTO kwd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nau ku iiria famooru 'e sui no'o, gwa'a moru agasi nau, moru 'ame tagoto'o mola agu. ");
INSERT INTO kwd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta'a te'efou na Mama'a agu ngaia 'e kwatega fagu, tagila leka te'efou no'o mai te'agu. Ma ni dai na ngaia 'e siria lekanga mai te'agu, nau ku sia ma'asini te'enia mola. ");
INSERT INTO kwd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tofuna nau ku sifo mai fa'asia 'i langi, 'amoe la'u fana agelana 'ola suria kwaisiriinga agu 'i talagu. Nau ku leka mai fana agelana 'ola na God 'e siria. ");
INSERT INTO kwd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Ola na God ngaia 'e siria, na nau 'aku aga le'a na ta'a te'efou na ngaia 'e kwatega fagu gila sia foo mola. Ma gani 'i'isi nau taku bi'i tata'ega fana nga mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","God na Mama'a agu ngaia 'e siria ni dai na gila aga fagu, ma gila ka tagoto'o agu, 'agila momoori firi. Ma nau taku tata'ega fana mooringa na gani 'i'isi.” ");
INSERT INTO kwd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma nga ta'a gila ka eta 'agila ngu'ungu'u no'o burina, tofuna ngaia 'e alafuu 'ilo'oo, “Nau no'o na beret ne'e sifo mai fa'asia 'i langi.” ");
INSERT INTO kwd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma gila ka alafuu 'ilo'oo faga kwairiu, “Nga wane lo'oo la Jisas nga wela ala Josef lo'oo mola, ma goru su'a mola na mama'a aana ma nga tete'e aana. Ma 'e 'utaa na ngaia 'e iiria ngaia 'e sifo mai fa'asia 'i langi?” ");
INSERT INTO kwd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Moru noto fa'asia nga ngu'ungu'unga 'i laloamooru. ");
INSERT INTO kwd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Te'efuta wane 'e sia leka mola mai te'agu lauta Mama'a agu ne'e alenau mai 'ame talaia mai te'agu. Ma ta'a na gila leka mai te'agu, nau taku fa'amooriga na gani 'i'isi. ");
INSERT INTO kwd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nga profet gila giri ma gila ka 'ilo'oo, ‘God ngaia 'e kwaifa'ananau na nga ta'a te'efou.’ Ma ni dai ne'e longoa Mama'a ma ka ngaria no'o su'a 'olanga fa'asia, tagila leka mai te'agu. ");
INSERT INTO kwd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma te'efuta wane 'ame agasia nga Mama'a. Te'ingaia nga wane ne'e leka mai fa'asia God no'o na ngaia 'e agasia nga Mama'a. ");
INSERT INTO kwd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nga 'ola kwala'imori nau ku iiria famooru, ni dai na ngaia 'e tagoto'o agu, ngaia te'e momoori firi. ");
INSERT INTO kwd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma nau no'o na beret na nga mooringa. ");
INSERT INTO kwd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nga wawarifu mooru gila 'ania nga beret laka'u gila fa'alata 'ania ‘mana’ 'ubulana gule'e lefu langalanga, ma gila ka mae mola. ");
INSERT INTO kwd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tafe'ua ma nga beret ne'e sifo mai fa'asia 'i langi, te'efuta wane 'e 'ania, 'ato ngaia 'ani mae. ");
INSERT INTO kwd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mai nau na beret na nga mooringa fa'asia 'i langi. Lauta te'efuta wane 'e 'ania nga beret lo'oo, ngaia te'e momoori firi. Ma nga beret no'ona na labegu, na nau ku kwatea fana nga ta'a fofona fanua lo'o 'i wado 'agila momoori ai.” ");
INSERT INTO kwd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma nga ta'a no'ona gila ka eta no'o fana orikwaisu'usu'uinga 'i laloaga kwairiu, ma gila ka fata 'ilo'oo, “Nga wane lo'oo 'e kwate 'uta'i na nga labena fadauru fana 'anilai lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma la Jisas ka fata 'ilo'oo faga, “'Ola kwala'imori nau ku iiria famooru, lauta moru 'ame 'ania nga labegu, ma moru 'ame go'ufia nga 'abugu, ngaia 'e 'ato iiki 'amooru momoori firi. ");
INSERT INTO kwd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma ni dai ne'e 'ania nga labegu, ma ka go'ufia nga 'abugu, ngaia te'e to'o na nga mooringa firi, mai nau taku tata'ea na fe'e gani 'i'isi. ");
INSERT INTO kwd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Du'ana nga labegu no'o na ketonga kwala'imori, ma nga 'abugu no'o na 'ola ni go'ufilai kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma ni dai ne'e 'ania nga labegu, ma ka go'ufia nga 'abugu, ngaia 'e nana'i fe'eni nau, mai nau ku nana'i fe'enia. ");
INSERT INTO kwd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mooringa 'e 'ita mai fa'asia God, ma ngaia ne'e kwate nau mai. Mai nau ku momoori la'u mola tofuna 'i ngaia. Maka 'ino'ona la'u mola ni dai ne'e 'ania labegu, ngaia te'e momoori la'u mola tofuna 'inau. ");
INSERT INTO kwd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma 'inau ku 'ame 'ilaka'u nga beret laka'u nga wawarifu mooru gila 'ania. Gila 'ania ma gila ka mae mola. 'Inau nga beret ne'e sifo mai fa'asia 'i langi, ma ni dai ne'e 'ania nga beret lo'oo, ngaia te'e momoori firi.” ");
INSERT INTO kwd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","La Jisas 'e iiria nga 'ola lo'oo alata ngaia 'e kwaifa'ananau 'ubulana nga 'ifi ni fo'anga 'i Kapaneam. ");
INSERT INTO kwd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma nga ta'a 'e aula na gila leka suria la Jisas, gila longoa nga 'ola lo'oo ngaia 'e fata suria, ma gila ka fata 'ilo'oo, “Nga kwaifa'ananaunga lo'oo ngaia 'e 'ato 'e iiki. Ni dai na te'e leka suria?” ");
INSERT INTO kwd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma la Jisas 'e su'aai gila ngu'ungu'u no'o buri na suria 'ola lo'oo, ma ngaia ka fata 'ilo'oo faga, “'Ilo'oo ma nga alafuunga lo'oori ngaia agea amooru 'ame siria lekanga suri nau? ");
INSERT INTO kwd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngaia 'e 'uta'i lauta na moru agasi nau, nga Wela na Wane, nau 'aku ori mai fana nga lefu laka'u nau ku nana'i mai ai 'i na'o? ");
INSERT INTO kwd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Te'ingaia nga Anoe 'ola Abu ne'e kwatea nga mooringa. Ma nga tegelangaa na wane 'e sia agea mola 'ola lo'oo. Ma nga alafuunga lo'oo nau ku iiria famooru ne'e leka mai fa'asia nga Anoe 'ola Abu ne'e kwatea nga mooringa. ");
INSERT INTO kwd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ma gwa'a 'ani 'ilo'oo, tani wane amooru gila 'ame tagoto'o mola.” Du'ana 'ita 'ua no'o mai 'i na'o, la Jisas 'e su'a te'efou no'o ani dai na gila 'ame tagoto'o, ma ni dai na te'e kwatea fana nga maarimae aana. ");
INSERT INTO kwd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma ngaia ka alafuu la'u 'ilo'oo, “Ngaia na'a nau ku iiria no'o famooru, te'efuta wane 'e sia leka mola mai te'agu, lauta Mama'a agu 'ame talaia mai te'agu.” ");
INSERT INTO kwd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma ka 'ita na alata no'ona, nga ta'a 'e aula na gila leka suria, gila ka abulo matari no'o, ma gila 'ame leka no'o fe'enia. ");
INSERT INTO kwd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma la Jisas ka kwaiorisi na nga akwale'e wane ma ruaai aana maka 'ilo'oo, “'Ilo'oo ma moru siria 'amooru ori la'u mola fa'asi nau?” ");
INSERT INTO kwd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma la Saemon Pita ka lamadu'aa maka 'ilo'oo, “Alafa, 'ino'ona ma ni dai ngaa'i la'u na tameeru leka te'ana? 'I'oo no'o na 'i'oo to'o na nga alafuunga na nga mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Meeru meru tagoto'o, ma meru ka su'aai 'i'oo no'o na Wane Abu na 'i'oo leka mai fa'asia God.” ");
INSERT INTO kwd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma la Jisas ka fata 'ilo'oo, “Nau na nau ku firia moru no'o akwale'e wane ma ruaai. Ma gwa'a 'ani 'ilo'oo, te'e wane amooru ngaia nga adalo.” ");
INSERT INTO kwd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na alata la Jisas ngaia 'e alafuu 'ilo'oo, ngaia 'e fata suria la Judas lo'oo, nga wela ala Saemon Iskariot. Gwa'a la Judas ngaia nga wane na akwala ma ruaai, ngaia te'e kwatea la Jisas mola fana nga maarimae aana. ");
INSERT INTO kwd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma 'i burina nga 'ola lo'oo, la Jisas ka riu kwairiu no'o na gule'e lefu 'i Galili, tofuna ngaia 'ame siria 'ani leka fana gule'e lefu 'i Judea, suria nga ta'a na'ona'o 'i Jiu gila siria kwa'ilana no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma nga fafangalaa na Jiu na gila fa'alataa 'ania nga Fafangalaa na Babala ngaia galangi 'ani lau no'o. ");
INSERT INTO kwd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ma ni wane ni futanga ala Jisas, gila ka leka mai te'ana, ma gila ka fata 'ilo'oo fana, “'Oi leka fani Judea, fana 'i'oo 'ani agea tani 'ola ni 'alefosilai, fana nga ta'a na gila leka suri'o 'agila agasia. ");
INSERT INTO kwd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Suria lauta te'efuta wane ngaia 'e siria ta'a 'agila aga su'ana, ngaia 'e sia fa'anagwaa mola te'efuta 'ola. Lauta 'i'oo agea 'ola ba'ita 'e aula, ngaia le'a lo'oo fana 'i'oo 'ani leka moko age faata'i ai, fana nga ta'a te'efou na fanua lo'o 'i wado 'agila su'aai.” ");
INSERT INTO kwd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ni wane ni futanga aana gila fata 'ilo'oo fana, tofuna gila 'ame tagoto'o ana. ");
INSERT INTO kwd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma la Jisas ka fata 'ilo'oo faga, “Ngaia 'ame nigi 'ua na alata fana 'aku leka. Tafe'ua ma mooru su'asuria 'amoru leka mola na te'efuta alata. Suria alata te'efou ngaia 'e toto'o mola famooru. ");
INSERT INTO kwd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ta'a fofona fanua lo'oo gila 'ame to'o na te'efuta 'ola fana 'agila ma'asiri amooru ai. Tafe'ua mai nau lo'oo, gila ma'asiri agu, tofuna nau ku kwairii na 'olataa na gila agea 'e ria. ");
INSERT INTO kwd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mooru moru leka kau na fafangalaa no'ona. Nau ku sia leka mola, tofuna ngaia 'ame nigi 'ua na alata agu.” ");
INSERT INTO kwd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ngaia 'e fata 'ilo'oo 'e sui, ma ngaia ka nana'i mola 'i Galili. ");
INSERT INTO kwd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","'I burina ni wane ni futanga ala Jisas gila leka no'o na fafangalaa ba'ita 'i Jerusalem, la Jisas ka leka 'i buriga. Ma ngaia ka leka nagwa nagwa la'u mola, fa'asia te'efuta ta'a gila ta su'ana. ");
INSERT INTO kwd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma nga ta'a na'ona'o 'i Jiu, gila ka kwailo'ofia la Jisas na nga fafangalaa lo'oori, ma gila ka orisiga ma gila ka 'ilo'oo, “Nga wane laka'u ngaia no'o 'i fai?” ");
INSERT INTO kwd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma ta'a 'e aula, gila ka kwalanguru no'o suria ma gila 'ilo'oo, “Nga wane laka'u ngaia nga wane le'ale'a.” Ma tani ta'a ngaa'i gila ka iiria, “Ngaia talaia ta'a 'e aula fana lekanga suria nga kotonga aana.” ");
INSERT INTO kwd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gwa'a gila fata 'ilo'oo, te'efuta wane aaga 'ame alafuu faata'i mola na manatangaa aaga suria la Jisas, tofuna gila ma'unge'enia ta'a na'ona'o 'i Jiu. ");
INSERT INTO kwd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Burina ni gani tarito'o mola, alata gila bu'i dalototo'o na Fafangalaa, la Jisas 'e ru'u kau 'ubulana 'Ifi Abu na God, ma ka eta no'o fana fa'ananaulana nga ta'a. ");
INSERT INTO kwd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma nga ta'a na'ona'o gila longoa, gila ka 'alefo ba'ita na kwaifa'ananaunga aana. Ma gila ka 'ilo'oo, “Wane lo'oo ngaia 'ame nanau 'ola mola mai na te'efuta lefu. Ma 'e fe'ua lo'oo ngaia 'e su'a na to'oni 'ola lo'oo te'efou?” ");
INSERT INTO kwd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na alata la Jisas 'e longoa, ngaia ka lamadu'aga maka fata 'ilo'oo, “Kwaifa'ananaunga agu ngaia 'ola agu 'amoe, ma ngaia 'e leka fa'asia God ne'e alenau mai.” ");
INSERT INTO kwd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ni dai ne'e siria 'ani leka suria nga kwaisiriinga na God, ngaia te'e su'asuria lauta nga 'ola na nau ku kwaifa'ananau 'ania, ngaia 'e leka mai fa'asia God, 'amoe ma fa'asia nga manatangaa agu mola 'i talagu. ");
INSERT INTO kwd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lauta wane 'e kwairii mola 'ania 'ola suria nga manatangaa 'i talana, ngaia 'e siria mola fana ta'a lo'oo 'agila tafea. Tafe'ua ma nga wane na ngaia 'e siria ta'a 'agila tafea nga wane ne'e alea mai, ngaia na nga wane na ngaia 'e alafuu 'ania kwala'imoringa, ma kotonga 'e 'amoe ana.” ");
INSERT INTO kwd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma la Jisas ka alafuu la'u 'ilo'oo, “La Moses laka'u 'e kwatea nga tagi famooru. Ma te'efuta wane amooru 'ame lo'o mola suria tagi no'ona. Ma 'utaa na moru siria 'amooru kwa'i nau 'aku mae?” ");
INSERT INTO kwd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma nga ta'a na gila ogu na lefu no'ona, gila ka fata 'ilo'oo, “'I'oo no'ona nga anoe 'ola 'e ria ngaia 'e ru'ufi'o! Ni dai ne'e siria 'ani kwa'i'o welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","La Jisas 'e lamadu'aga maka 'ilo'oo, “Nau ku gulaa te'e wane na Sabat, ma moru ka 'alefo ba'ita ai. ");
INSERT INTO kwd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ma moru su'aai la Moses 'e kwatea te'e tagi famooru, fana 'amoru kwaria lofona wela wane sisita 'amooru. (Ma la Moses 'ame eta 'ola lo'oo, tafe'ua ma nga wawarifu mooru mai 'i na'o.) Ma lauta alata fana 'amooru kwaria nga wela 'amooru ngaia lau na nga Sabat, mooru moru agea mola, gwa'a ngaia nga Sabat. ");
INSERT INTO kwd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lauta ngaia le'a mola fana 'amooru kwaria na Sabat, ma 'uta'i lo'oo na moru baoria fagu alata laka'u nau ku gulaa nga wane laka'u na Sabat? ");
INSERT INTO kwd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Moru sia kwaisufai mola agu suria nga 'olataa moru agasia mola 'i maa. Tafe'ua ma moru kwaisufaai 'ania kwala'imoringa. ");
INSERT INTO kwd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma tani ta'a 'i Jerusalem gila ka fata 'ilo'oo, “Nga wane lo'oo no'o laka'u nga ta'a na'ona'o gila siria kwa'ilana!” ");
INSERT INTO kwd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aga madi! Wane lo'oo ngaia 'e alafuu folaa no'o mai, ma gila 'ame iiria mola ta 'ola 'ani lamadu'aa. Bala gila madafia ngaia nga Kraes ta'ua! ");
INSERT INTO kwd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tafe'ua ma alata nga Kraes 'ani leka mai, te'efuta wane 'ame su'a na lefu na ngaia 'e leka mai fa'asia. Ma nga wane nga lo'oo, goru su'a mola na lefu na ngaia 'e leka mai fa'asia.” ");
INSERT INTO kwd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ma nga alata no'ona, la Jisas 'e fa'ananaua nga ta'a 'ubulana 'Ifi Abu na God. Ma ngaia ka fata ba'ita maka 'ilo'oo, “Moru madafia mooru moru su'a le'a agu, ma moru su'a na lefu lo'oo nau ku leka mai fa'asia. Nau ku 'ame leka mai 'ania nga kwala'imoringa agu 'i talagu! Ma nga wane na ngaia 'e alenau mai, ngaia 'e iiria 'ola kwala'imori te'efou, ma moru 'ame su'a mola ana. ");
INSERT INTO kwd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tafe'ua mai nau ku su'a ana, tofuna ngaia na ngaia 'e alenau mai, mai nau ku leka mai fa'asia.” ");
INSERT INTO kwd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na alata no'ona, nga ta'a na'ona'o gila ka siria 'agila gemasia, tafe'ua ma ngaia 'e 'ato, tofuna alata ngaia 'ame nigi 'ua fana 'agila agea 'ola lo'oo ana. ");
INSERT INTO kwd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tafe'ua, aulalana ta'a 'i 'ubulana oguogunga lo'oori gila tagoto'o ana. Ma gila ka alafuu 'ilo'oo, “Bala ngaia nga Kraes. Suria te'efuta wane 'e sia agea mola ni 'ola ni 'alefosilai 'e riufia ni 'ola na wane lo'oo ngaia 'e agea.” ");
INSERT INTO kwd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma na alata nga Farasii gila longoa na ta'a gila kwalanguru suria la Jisas 'ilo'oo, gila fe'enia nga fataabu ba'ita, gila ka kwatea kau ta'a ni folonga na gila folo 'afuia 'Ifi Abu na God, fana 'agila gemasia na alata no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma la Jisas ka fata 'ilo'oo, “Nau taku nana'i fe'enia mooru mola suria te'e alata ko'oko'osu, mai nau taku ori la'u mola te'ana nga wane na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma mooru tamoru kwailo 'oofi nau, ma te'e 'ato 'amooru nigi to'ogu. Du'ana ngaia 'e 'ato no'o 'amoru nigi na lefu na nau taku nana'i ai.” ");
INSERT INTO kwd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma nga ta'a na'ona'o 'i Jiu lo'oo gila ka orisia 'i laloaga kwairiu ma gila ka 'ilo'oo, “Wane lo'oo te'e leka fani fai na dauru goru sia agasia mola? 'Ilo'oo ma ngaia te'e leka fana fanua 'i Grik, nga lefu na tani wane adauru gila nana'i mai ai, fana 'ani fa'ananauga te'efou? ");
INSERT INTO kwd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma ngaia ka iiria la'u mola tagoru kwailo 'ofia, ma dauru goru sia agasia mola, tofuna dauru goru 'ame su'a na lefu na ngaia te'e nana'i ai. Aia, ma 'olataa ne'e nana'i 'ubulana manatalana na alata ngaia 'e fata 'ilo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nga gani 'ita'i na fafangalaa lo'oo, ngaia fe'e gani ba'ita 'e iiki. Na fe'e gani no'ona, la Jisas ka tata'e maka ula, ma ka fata ba'ita maka 'ilo'oo, “Ni dai na ngaia 'e maarigo'u, ngaia 'ani leka mai te'agu maka go'u. ");
INSERT INTO kwd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ma ni dai ne'e tagoto'o agu, ngaia te'e 'ilaka'u 'olataa laka'u nga Girigiringa Abu ngaia 'e iiria, ‘Nga ufu moori te'e buasa mai fa'asia nga moorilana.’” ");
INSERT INTO kwd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Alata la Jisas 'e iiria 'ola lo'oo, ngaia 'e fata suria nga Anoe 'ola Abu na ngaia te'e leka mai fani dai na gila tagoto'o ana. Na alata no'ona, God ngaia 'ame kwatea 'ua mai nga Anoe 'ola Abu fana ta'a, tofuna la Jisas 'ame ori 'ua fana ngarilana foufounga aana. ");
INSERT INTO kwd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tani ta'a na ogunga lo'oo, gila longoa fatalana la Jisas, ma gila 'ilo'oo, “Wane lo'oo ngaia nga Profet na goru mamania!” ");
INSERT INTO kwd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma tani ta'a gila ka iiria 'ilo'oo, “Ngaia nga Kraes!” Ma tani ta'a ngaa'i la'u, gila ka iiria, “Nga Kraes ngaia 'e sia leka mola mai fa'asia 'i Galili! ");
INSERT INTO kwd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Du'ana nga Girigiringa Abu ngaia iiria nga Kraes te'e futa mai orioritana la Defete nga kiingi, ma te'e futa 'i Betlehem, ma'e fanua na la Defete ngaia 'e ba'ita la'u mola mai ai.” ");
INSERT INTO kwd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma nga ta'a lo'oo, gila 'ame arua no'o te'e manatangaa suria la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma tani ta'a ngaa'i gila siria 'agila gemasia la Jisas, tafe'ua ma te'efuta wane 'ame agea mola te'efuta 'ola ana. ");
INSERT INTO kwd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nga ta'a ni folonga laka'u gila 'ame daua mola la Jisas, ma gila ori kau te'ana ni fataabu ba'ita ma ni Farasii. Ma alata gila nigi te'aga, nga fataabu ba'ita, ma ni Farasii, gila ka alafuu 'ilo'oo, “Fe'ua na moru 'ame ngaria mai?” ");
INSERT INTO kwd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma gila ka lamadu'aga 'ilo'oo, “Te'efuta wane 'ame alafuu 'ilaka'u no'o 'i ngaia!” ");
INSERT INTO kwd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ni Farasii lo'oo gila ka alafuu 'ilo'oo faga, “Bala moru tagoto'o la'u mola na kotonga aana ta'ua? ");
INSERT INTO kwd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Te'efuta wane na Farasii ma ta'a na'ona'o adauru, gila 'ame tagoto'o ana! ");
INSERT INTO kwd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nga oguogunga lo'oori na gila tagoto'o ana, gila 'ame su'a mola na nga tagi ala Moses. Ngaia lo'oo God te'e kwatea kwa'ikwa'inga faga.” ");
INSERT INTO kwd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aia, ma te'e wane na nga Farasii latana la Nikodimas na ngaia 'e leka mai te'ala Jisas 'i na'o, ngaia 'e alafuu 'ilo'oo fana ni Farasii lo'oo, ");
INSERT INTO kwd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nga tagi adauru laka'u 'e iiria dauru goru sia sufaa mola te'efuta wane lauta dauru goru 'ame longo le'a na alafuulana fana su'anga na 'olataa na ngaia 'e agea.” ");
INSERT INTO kwd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma gila ka fata 'ilo'oo fala Nikodimas, “Welakau ma 'i'oo la'u mola nga wane fa'asia 'i Galili lo'oo? Lauta 'i'oo aga le'a na Girigiringa Abu, 'i'oo to'o su'aai. Nga Profet na goru mamania ngaia 'e sia leka mola mai fa'asia 'i Galili!” ");
INSERT INTO kwd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aia, nga ta'a te'efou gila ori no'o fana nga 'ifi aaga. ");
INSERT INTO kwd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma la Jisas ka fane fana gouna me'e busu na gila fa'alataa 'ania Olif. ");
INSERT INTO kwd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma 'usu'usugani mola na ma'e gani 'i buri, ngaia 'e ori la'u fana 'ubulana 'Ifi Abu na God. Ma nga oguogunga ba'ita iiki, gila ka ogu 'afuia, ma ngaia ka to'oru 'i wado, ma ka fa'ananauga. ");
INSERT INTO kwd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma nga ta'a ni kwaifa'ananaunga na tagi ma ni Farasii, gila ka ngaria mai te'e noni na gila daria na nga agemaninga. Ma gila ka fa'aula 'i laloaga. ");
INSERT INTO kwd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma gila ka alafuu 'ilo'oo fala Jisas, “Wane kwaifa'ananaunga 'ae, nga noni lo'oo, meeru gemasia du'ana agemaninga. ");
INSERT INTO kwd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma 'i 'ubulana nga Tagi ala Moses, ngaia 'e iiria fana nga noni 'ilo'oo, 'agila 'uia 'ania nga fou fana ngaia 'ani mae no'o. Ma nga 'olataa na 'i'oo iiria ana welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gila iiria 'ola lo'oo fana 'agila irito'ona fana to'odarilana te'efuta 'ola fana 'agila arua fafia la Jisas. Ma la Jisas ka to'oru 'i wado, ma ka giri 'ania 'u'una fofona wado. ");
INSERT INTO kwd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma alata gila kwaikwaiorisi mola, ngaia 'e tata'e, ma ka alafuu 'ilo'oo faga, “Ni dai amooru na ngaia 'ame agea te'efuta 'ola 'e ria, ngaia 'ani 'uia 'ania te'efuta me'e fou eteeta.” ");
INSERT INTO kwd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sui ma ngaia ka to'oru, ma ka giri la'u 'i fofona wado. ");
INSERT INTO kwd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma alata gila longoa 'ola lo'oo, gila ka leka no'o fa'asia, tala te'e wane, eta na nga wane koko'o. Sui ma te'e la Jisas fe'enia nga noni laka'u na ngaia 'e ula no'ona, na gaa'a gala nana'i no'o. ");
INSERT INTO kwd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma ngaia ka tata'e la'u, ma ka fata 'ilo'oo, “Noni lo'oo, nga ta'a laka'u, gila no'o 'i fai? Ngaia 'e 'uta'i? Te'efuta wane aaga 'ame ole fana 'ani sufa'o welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma ngaia ka lamadu'aa maka 'ilo'oo, “Wane ba'ita, te'efuta wane 'amoe no'o.” Ma la Jisas ka alafuu 'ilo'oo fana, “Mai nau ku 'ame sufa'o la'u mola. 'Oi leka no'o kau, ma eta tala'ina lo'oo 'i'oo sia agea la'u te'efuta 'ola 'e ria.” ");
INSERT INTO kwd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","La Jisas ka fata la'u 'ilo'oo fana ta'a no'ona, “Nau na'a nga lalanga lo'oo fana ta'a fofona fanua lo'oo 'i wado. Wane na ngaia 'e leka mai suri nau, ngaia 'e sia riu mola 'ubulana logologo'angaa tofuna ngaia te'e to'o na nga lalanga ne'e kwatea mooringa 'ubulana mangona.” ");
INSERT INTO kwd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Farasii gila ka fata 'ilo'oo fana, “'I'oo talamu no'o 'i'oo kwairii 'ani'o. Ngaia 'e 'ato fana 'ameru tagoto'o na fatalamu suria te'efuta wane ngaa'i 'ame alafuu suri'o.” ");
INSERT INTO kwd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","La Jisas ka fata 'ilo'oo, “Gwa'a nau ku kwairii 'ania 'inau 'i talagu, 'olataa na nau ku fata suria 'e kwala'imori, tofuna nau ku su'asuria lefu na nau ku leka mai fa'asia, ma 'i fai na 'aku leka fai. Ma moru 'ame su'a mola na lefu na nau ku leka mai fa'asia, ma lefu na 'aku leka fai. ");
INSERT INTO kwd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Amooru moru kwaisufai na 'ola suria manatangaa na wane fofona fanua lo'oo 'i wado no'ona. Aia, mai nau ku sia kwaisufai mola na te'efuta wane. ");
INSERT INTO kwd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tafe'ua ma lauta nau ku kwaisufai na te'efuta wane, nau ku sufaa suria manatangaa 'e odo. Nau ku 'ame sufaa te'efuta wane te'i nau, ma mee'e te'efou Mama'a na ngaia 'e alenau mai ne'e nana'i fe'eni nau. ");
INSERT INTO kwd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nga tagi amooru 'e iiria 'e sui no'o, lauta rua wane gala alanga'i suria te'efuta alafuunga, 'ola na gala iiria ngaia 'e kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nau ku kwairii 'ani nau 'i talagu, ma nga Mama'a na ngaia 'e alenau mai, ngaia la'u mola 'e kwairii 'ani nau.” ");
INSERT INTO kwd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma, gila ka orisia la Jisas ma gila 'ilo'oo, “'Ilo'oo ma mama'a amu ngai fai welakau?” Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Mooru moru 'ame su'a mola agu ma gwa'a Mama'a agu. Lauta moru su'a agu, mooru tamoru su'a la'u na Mama'a agu.” ");
INSERT INTO kwd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","La Jisas 'e iiria nga 'ola lo'oo na alata ngaia 'e fa'ananaua ta'a 'i 'ubulana 'Ifi Abu na God, galangia lefu na gila arua kokole 'ola na gila arua fana kwatelana kwakwatenga aaga 'i 'ubulai. Aia, ma na alata no'ona, te'efuta wane 'ame gemasia mola, tofuna alata ana 'ame nigi 'ua. ");
INSERT INTO kwd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","La Jisas 'e fata 'ilo'oo la'u faga, “Nau taku leka, ma tamoru kwailo'ofi nau. Ma tamoru mae, ma God ngaia 'e sia 'olafanataa mola na rianga 'amooru. Ma ngaia 'e 'ato fana 'amoru leka na lefu nau taku leka ai.” ");
INSERT INTO kwd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma nga ta'a na'ona'o 'i Jiu gila ka alafuu 'ilo'oo, “Ngaia 'e iiria 'e 'ato no'o 'agoru leka fana lefu na ngaia te'e leka fai. 'Ilo'oo ma ngaia bala te'e daua mola 'i talana?” ");
INSERT INTO kwd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","La Jisas ka lamadu'aga maka alafuu 'ilo'oo, “Mooru moru leka mai fa'asia nga fanua lo'oo 'i wado. Tafe'ua mai nau ku leka mai fa'asia 'i langi. Mooru lo'oo fa'asia mola nga fanua lo'oo 'i wado. Ma 'inau 'amoe fa'asia nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngaia lo'oo, nau ku iiria 'e sui no'o tamoru mae, ma God ngaia 'e sia 'olafanataa mola na rianga amooru. Ngaia 'e kwala'imori no'o, lauta moru 'ame tagoto'o na ‘'Inau Lo'oo nga mesaea’ nga wela na God, ngaia 'e sia 'olafanataa mola na rianga amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma gila kwaiorisi ma gila ka 'ilo'oo, “'Ilo'oo ma 'i'oo ni dai lo'oo?” Ma la Jisas ka lamadu'aga maka alafuu 'ilo'oo, “Nau lo'oo laka'u nau ku iiria no'o famooru eta na alata nau ku bi'i eta na taunga'inga agu. ");
INSERT INTO kwd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nau ku to'o na ni 'ola 'e aula iiki na nau ku su'asuria 'aku alafuu suri 'amooru fana kwaisufaingaa amooru. Ma nau ku iiria mola 'olataa na nau ku longoa fa'asia wane ne'e alenau mai. Ma wane lo'oo 'e iiria mola ni 'ola 'e to'o.” ");
INSERT INTO kwd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma gila 'ame su'a mola na la Jisas ngaia 'e alafuu suria Mama'a aana mai langi. ");
INSERT INTO kwd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ngaia 'e alafuu 'ilo'oo faga, “Alata 'amooru aru nau, nga Wela na Wane, na 'ai folo, tamoru su'a agu na 'I Nau Lo'oo. Ma nga alata no'ona, tamoru bi'i su'aai na nau ku 'ame agea te'efuta 'ola suria nga manatalagu 'i talagu. Tafe'ua mai nau ku iiria 'ola na Mama'a ngaia 'e fa'ananau nau 'ania. ");
INSERT INTO kwd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aia, ma Mama'a na ngaia 'e alenau mai, ngaia 'e nana'i fe'eni nau gani mai gani. Ngaia 'ame rugasi nau, tofuna nau ku agea 'ola na ngaia 'e siria gani mai gani.” ");
INSERT INTO kwd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma ta'a 'e aula gila ka tagoto'o no'o ala Jisas, alata gila longoa ngaia 'e iiria nga 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma la Jisas ka alafuu 'ilo'oo fana ta'a na gila tagoto'o ana, “Lauta moru dau suria nga kwaifa'ananaunga agu, mooru no'o na fufu'iwane kwala'imori agu. ");
INSERT INTO kwd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma tamoru su'a na 'ola kwala'imori suria God, ma nga kwala'imoringa na God te'e kwatea arubengaa famu.” ");
INSERT INTO kwd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gila orisia la Jisas, ma gila ka 'ilo'oo, “Meeru nga ta'a na orioritana la Ebraham lo'oo no'o. Meeru ta'a ni taunga'inga tago fana te'efuta wane 'amoe. 'Utaa na 'i'oo iiria tameru arube?” ");
INSERT INTO kwd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","La Jisas ka alafuu 'ilo'oo la'u faga, “'Ola kwala'imori nau ku iiria famooru. Ta'a na gila lo'o suria nga falafala 'e ria lo'oo, gila ta'a ni taunga'inga tago no'o 'i olofana falafala ria lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nga wane na ngaia wane ni taunga'inga tago, ngaia 'ame nana'i furifuri na 'ifi na nga wane ba'ita. Tafe'ua ma nga wela na wane ba'ita no'ona, ngaia ne'e nana'i furifuri na 'ifi na mama'a aana. ");
INSERT INTO kwd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Lauta 'inau, nga Wela na God, nau ku rubea mooru, tamooru bi'i arube kwala'imori ma mooru na ru'uru'ua na God kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nau ku su'aai moru nga ta'a na orioritana la Ebraham. Tafe'ua, mooru moru siria mola kwa'ilagu, tofuna moru 'ame siria lekanga suria nga kwaifa'ananaunga agu. ");
INSERT INTO kwd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nau ku alafuu suria 'olataa na Mama'a agu ngaia 'e faate'enia fagu, ma moru ka agea 'olataa na mama'a amooru ngaia 'e fata suria te'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gila lamadu'aa la Jisas ma gila ka 'ilo'oo, “Mama'a ameeru na la Ebraham!” La Jisas ka fata 'ilo'oo faga, “Lauta moru nga orioritana la Ebraham lo'oo 'e kwala'imori, tamoru agea la'u mola nga 'ola na ngaia 'e agea. ");
INSERT INTO kwd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma nau ku iiria mola nga 'ola kwala'imori famooru na nau ku longoa mai fa'asia God gani mai gani. Tafe'ua ma moru siria mola kwa'ilagu. La Ebraham ngaia 'ame agea mola te'efuta 'ola 'ino'ona. ");
INSERT INTO kwd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ma mooru moru agea no'o nga 'ola na mama'a amooru ngaia 'e agea.” Gila ka alafuu 'ilo'oo fana, “Te'i ngaia God no'o na Mama'a ameeru, ma meeru na nga ru'uru'ua kwala'imori aana.” ");
INSERT INTO kwd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","La Jisas 'e lamadu'aga maka alafuu 'ilo'oo, “Lauta God na mama'a amooru kwala'imori, moru kwaimaa fagu, tofuna nau ku leka mai fa'asia God, mai nau ku to'oru fe'enia mooru 'ilo'oo. Nau ku 'ame leka mai suria nga tegelangaa agu 'i talagu. God ne'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","'Utaa na moru 'ame longo su'a na nga fatalagu? Ngaia 'e 'ilo'oo tofuna moru 'ame siria no'o longolana. ");
INSERT INTO kwd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mai mooru, nga mama'a amooru na la Saetan. Ngaia na'a, moru siria agelana nga 'ola na ngaia 'e agea. La Saetan na'a nga wane fana kwa'ilana wane tofuna ngaia 'e agea 'ua no'o mai. Ma ngaia ka ma'asini te'enia na nga kwala'imoringa, tofuna ngaia 'ame to'o na ta 'ola ne'e kwala'imori. Alata ngaia 'e kotofia nga te'efuta wane, nga falafala aana lo'oo no'o, suria ngaia na wane fana kotonga, ma ngaia na mama'a na ta'a ni kotonga te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma nau ku iiria 'ola kwala'imori famooru, ma nga 'ola lo'oori na 'e agea moru 'ame siria mola tagoto'onga agu. ");
INSERT INTO kwd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Fe'ua? Te'efuta wane amooru su'asuria 'ani faate'enia nga 'ola na nau ku agea 'e ria? 'Ato no'o! Aia, ma 'uta'i na 'amooru moru 'ame tagoto'o agu, alata nau ku iiria 'ola kwala'imori lo'oo famooru? ");
INSERT INTO kwd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aia, ni dai na gila 'ita mai fa'asia God, gila longo suria nga fatalana. Ma amooru lo'oo, moru 'ame 'ita mai fa'asia God. Ngaia lo'oo moru 'ame fafulongo no'o fana.” ");
INSERT INTO kwd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma gila ka alafuu 'ilo'oo fala Jisas, “Nga 'ola laka'u meeru iiria suri'o ngaia 'e kwala'imori alata meru iiria 'i'oo wane fa'asia 'i Samaria, ma anoe 'ola ria 'e ru'ufi'o.” ");
INSERT INTO kwd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","La Jisas 'e lamadu'aga maka alafuu 'ilo'oo, “'Amoe no'o, anoe 'ola 'e ria 'e 'ame ru'ufi nau. Nau ku iiri ba'ita na nga Mama'a agu, tafe'ua ma moru 'ame iiri ba'ita mola agu. ");
INSERT INTO kwd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma 'inau ku 'ame siria no'o nga ta'a 'agila iiri ba'ita agu. Mama'a agu na ngaia 'e siria fana ta'a 'agila iiri ba'ita agu. Ma ngaia la'u mola na te'e sufaa ta'a te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nga 'ola kwala'imori nau ku iiria famooru, ni dai ne'e dau suria kwaifa'ananaunga agu, ngaia 'e sia mae mola.” ");
INSERT INTO kwd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma gila lamadu'aa la Jisas ma gila ka fata 'ilo'oo, “Meeru meru su'a kwala'imori na anoe 'ola 'e ria 'e ru'ufi'o! Tofuna wawarifu meeru la Ebraham ngaia 'e mae no'o, ma nga profet te'efou gila ka mae no'o. 'Utaa na 'i'oo iiria lauta wane 'e lo'o suria kwaifa'ananaunga amu, ngaia 'e sia mae mola? ");
INSERT INTO kwd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wawarifu meeru la Ebraham ngaia nga wane ba'ita, tafe'ua ma ngaia 'e mae no'o fe'enia ni profet la'u mola. Ma 'i'oo madafia iiria 'i'oo ba'ita 'e riufia la Ebraham welakau? Ma 'i'oo iiria 'i'oo ni dai?” ");
INSERT INTO kwd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","La Jisas ka lamadu'aga maka 'ilo'oo, “Lauta nau ku iiri ba'ita agu 'i talagu, ngaia 'ola 'uri'uri mola. Ma nga wane ne'e iiri ba'ita agu na Mama'a agu, ma mooru iiria ngaia na God amooru. ");
INSERT INTO kwd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tafe'ua, moru 'ame su'a mola na God, mai nau ku su'a ana. Lauta nau ku iiria nau ku 'ame su'ana, nau ku 'ilaka'u la'u mola amooru na moru su'a le'a na kotonga. Tafe'ua mai nau ku su'a le'a no'o ana, mai nau ku agea suria fatalana. ");
INSERT INTO kwd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma nga wawarifu mooru la Ebraham ngaia 'e aile'a ba'ita, tofuna ngaia 'e agasia no'o nigilagu mai.” ");
INSERT INTO kwd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma gila ka alafuu la'u 'ilo'oo fana, “Ei Fu'uwane! Nima akwale farisi 'ame sui 'ua fafia futalamu, ma 'i'oo iiria 'i'oo agasia no'o la Ebraham.” ");
INSERT INTO kwd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","La Jisas ka lamadu'aga maka alafuu 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru: Alata la Ebraham ngaia 'ame futa 'ua, Nau Lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Na alata no'ona, gila ka ngaria nga fou fana 'agila 'ui maeria, suria ngaia 'e fata 'ilo'oo. Ma ngaia ka nagwa no'o fa'asiga maka leka no'o fa'asia nga 'Ifi Abu na God. ");
INSERT INTO kwd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Alata la Jisas ngaia 'e leka suria nga tala, ngaia 'e agasia te'e wane na maana 'e logo 'ita no'o mai na alata ngaia 'e futa ai. ");
INSERT INTO kwd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma nga fufu'iwane aana gila orisia, ma gila ka 'ilo'oo, “Wane kwaifa'ananaunga, nga rianga ani dai ne'e agea nga maana wane lo'oo 'e logo 'ita no'o mai na alata 'e futa welakau? Nga rianga aana 'i talana 'amoe ma nga rianga na nga mama'a aana ma ni tete'e aana?” ");
INSERT INTO kwd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma la Jisas 'e lamadu'aga maka 'ilo'oo, “Maana 'e logo lo'oo, 'amoe la'u tofuna nga rianga aana talana, ma 'amoe la'u mola nga rianga na mama'a aana ma ni tete'e aana. Nga maana 'e logo fana 'amoru agasia nga tegelangaa na God 'ani faata'i ai. ");
INSERT INTO kwd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na alata ngaia gagani 'ua, tagoru agea no'o nga taunga'inga na God na ngaia 'e kwate nau mai fai. Tofuna nga logo ngaia 'e gagalangi no'o, alata laka'u te'efuta wane 'e sia taunga'i mola. ");
INSERT INTO kwd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Alata nau ku nana'i 'ua fofona fanua lo'oo 'i wado, nau na nga lalanga lo'oo fana nga ta'a na fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma 'i burina la Jisas ngaia 'e iiria 'ola lo'oo, ngaia ka ngisu 'ubulana wado, ma ka bunia kunu no'ona 'ania ngingisuna, ma ka 'usua 'ania nga maana nga wane lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma la Jisas ka fata 'ilo'oo fana, “'Oi leka moko narufia nga maamu 'i 'ubulana nga 'ekwa 'i Saelom. (Lata lo'oo, fa'awatagalai na ‘Wane na gila Alea.’) Ma nga wane no'ona ka leka maka narufia no'o maana, ma ngaia ka aga no'o. ");
INSERT INTO kwd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma nga ta'a na fanua aana, ma nga ta'a na gila agasia laka'u ngaia 'e kwaikwaisoe na bata no'ona 'i na'o, gila ka orisiga kwairiu 'ilo'oo, “Ngaia nga wane laka'u ngaia 'e kwaikwaisoe lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma tani ta'a ngaa'i gila ka 'ilo'oo, “Ngaia lo'oo no'o.” Ma tani ta'a ngaa'i la'u gila ka fata 'ilo'oo, “Ngaia nga wane no'ona 'amoe, tafe'ua ma agasilana 'ilaka'u no'o nga wane no'ona.” Ma nga wane no'ona 'i talana ka fata 'ilo'oo, “Nau lo'oo no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma gila ka kwaiorisi 'ilo'oo, “Fe'ua na nga maamu 'e 'ulasi no'o, welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma ngaia ka lamadu'aga maka 'ilo'oo, “Nga wane na latana la Jisas na ngaia 'e launge'enia kunu, ma ka 'usua 'ania nga maagu. Ma ngaia ka iiria fagu 'aku leka, 'aku narufia maagu 'i 'ubulana nga 'ekwa 'i Saelom. Ma nau ku leka, ma alata nau ku narufia mola, nga maagu ka aga no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma gila ka orisia la'u 'ilo'oo, “Ma ngaia no'o 'i fai welakau?” Ma ngaia ka lamadu'aga maka 'ilo'oo, “Nau ku 'ame su'aai.” ");
INSERT INTO kwd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ma 'i buri, gila ka talaia no'o nga wane laka'u te'ana ni Farasii. ");
INSERT INTO kwd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma fe'e gani no'ona la Jisas 'e launge'enia nga kunu no'ona ma ka gulaa nga maana nga wane lo'oori, ngaia na nga Sabat. ");
INSERT INTO kwd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma ni Farasii gila ka orisia la'u nga wane lo'oori, “Fe'ua na ngaia 'e agea 'i'oo aga no'o?” Ma ngaia ka kwairii maka 'ilo'oo faga, “La Jisas ngaia 'e arua kunu no'ona fafia nga maagu. Ma 'inau kua narufia no'o maagu, ma maagu ka aga no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma tani ta'a na Farasii gila ka fata 'ilo'oo, “Nga wane na ngaia agea 'ola lo'oo, ngaia 'ame leka mai fa'asia God, tofuna ngaia 'e taunga'i na nga Sabat.” Ma tani ta'a ngaa'i la'u gila ka 'ilo'oo, “Ma 'utaa lo'oo nga wane ne'e abulo ria 'ilo'oo 'e agea nga 'ola ni 'alefosilai ba'ita 'ilo'oo?” Ma gila 'ame lado no'o na te'efuta manatangaa tofuna nga 'ola lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma Farasii lo'oo gila ka orisia 'ilo'oo la'u na nga wane lo'oori, “'Ino'ona mai 'i'oo iiria la Jisas ne'e gulaa nga maamu, nga 'olataa na 'i'oo madafia suria?” Ma ngaia ka 'ilo'oo, “Ngaia nga profet.” ");
INSERT INTO kwd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma nga ta'a na'ona'o 'i Jiu, gila ka 'ame siria no'o tagoto'o na maana 'e logo mai na'o. Ma gila ka soea mai mama'a aana fe'enia tete'e aana. ");
INSERT INTO kwd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma gila ka orisi 'agaa'a 'ilo'oo, “Nga wela amoo'o lo'oo? Nga maana ngaia logo no'o, na alata ngaia 'e futa mai ai? Ma 'olataa ne'e agea ngaia 'e aga no'o na alata lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma nga mama'a aana fe'enia tete'e aana gala lamadu'aga ma gala ka 'ilo'oo, “Mee'e mele su'aai ngaia nga wela amee'e, ma mele ka su'aai nga maana ngaia 'e logo 'ua no'o mai na alata ngaia 'e futa ai. ");
INSERT INTO kwd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tafe'ua ma me'e mele bobolosia la'u mola 'olataa ne'e agea maana 'e aga. Mooru moru orisia kau, suria ngaia 'e ba'ita no'o, ma ngaia te'e alafuu no'o 'i talana!” ");
INSERT INTO kwd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nga mama'a aana fe'enia tete'e aana gala iiria 'ola lo'oo tofuna gala ma'unge'enia nga ta'a na'ona'o lo'oo 'i Jiu. Tofuna gila alafafia 'e sui no'o, lauta te'efuta wane 'e iiria la Jisas na nga Kraes, gila sia alamia mola 'ani ru'u 'ubulana 'ifi ni fo'anga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngaia na mama'a aana fe'enia tete'e aana gala iiria, “Ngaia 'e ba'ita no'o. Moru orisia kau!” ");
INSERT INTO kwd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ma gila ka soea la'u mai nga wane laka'u nga maana ngaia 'e logo 'i na'o, ma gila ka fata 'ilo'oo fana, “'Oi alafuu wataga 'i na'ona God na 'i'oo iiria no'o 'ola kwala'imori lo'oo! Meru su'aai nga wane lo'oo ngaia nga wane 'e ria.” ");
INSERT INTO kwd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma nga wane no'ona 'e lamadu'aga maka 'ilo'oo, “Nau ku bobolosia ngaia nga wane ria 'amoe ma wane 'e le'a. Te'e 'ola nau ku su'aai ne'e 'ilo'oo, nga maagu ngaia 'e logo 'i na'o, tafe'ua ma alata lo'oo nau ku aga no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma gila ka orisia la'u 'ilo'oo, “'Olataa na ngaia agea amu welakau? Ma ngaia ka gulaa 'utaa na maamu?” ");
INSERT INTO kwd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma nga wane no'ona 'e lamadu'aga maka 'ilo'oo, Nau ku iiria 'e sui no'o famooru laka'u, tafe'ua ma moru 'ame longoa mola. 'Utaa na mooru siria la'u mola longolai? Bala 'amooru moru siria 'amoru leka la'u mola suria?” ");
INSERT INTO kwd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gila fata ngadaa ma gila ka 'ilo'oo, “'I'oo lo'oo wane na fufu'iwane aana welakau. Tafe'ua ma meeru nga fufu'iwane ala Moses lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tofuna meru su'aai God ngaia 'e fata fala Moses. Ma nga wane lo'oo, gwa'a nga lefu na ngaia 'e futa ai, 'imeeru meru bobolosia.” ");
INSERT INTO kwd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma nga wane no'ona ka lamadu'aga maka 'ilo'oo, “Nau ku 'alefo ba'ita no'o amooru. Du'ana ngaia 'e 'ulasia no'o maagu, tafe'ua ma mooru moru iiria moru 'ame su'a mola 'i fai na ngaia 'e leka mai fa'asia. ");
INSERT INTO kwd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dauru te'efou goru su'a na God ngaia 'e sia longoa mola nga wane 'e ria. Ngaia 'e longoa mola nga wane na ngaia 'e iiri ba'ita ana, ma ngaia ka lo'o suria. ");
INSERT INTO kwd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Maka 'ita 'ua no'o mai na etalana fanua lo'oo 'i wado, dauru goru 'ame longoa 'ua na te'efuta wane 'ani 'ulasia maana te'efuta wane ne'e logo 'ita na alata ngaia 'e futa mai ai. ");
INSERT INTO kwd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma lauta nga wane lo'oo ngaia 'ame leka mai fa'asia God, ngaia 'e 'ato 'ani agea te'efuta 'ola 'ilo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma gila ka baoria ba'ita, ma gila ka alafuu 'ilo'oo fana, “'Ino'ona mai 'i'oo ba'ita mai 'ubulana rianga 'ita no'o mai na futalamu! 'Utaa na 'i'oo siria 'ani fa'ananau 'ameeru?” Ma gila ka ruia ngaia 'e sia ru'u mola 'ubulana nga 'ifi ni fo'anga lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ma la Jisas 'e longoa na gila agea 'ilo'oo na wane lo'oori. Ma ngaia 'e nigi te'ana ma ka fata 'ilo'oo, “'Ilo'oo ma 'i'oo tagoto'o na nga Wela na Wane?” ");
INSERT INTO kwd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma nga wane lo'oo 'e lamadu'aa maka 'ilo'oo, “Wane ba'ita, to'o kwairii te'agu ni dai lo'oo, fana 'aku tagoto'o ana.” ");
INSERT INTO kwd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma la Jisas ka fata 'ilo'oo fana, “'I'oo agasia 'e sui no'o, ma ngaia no'o na 'i'oo alafuu fe'enia na alata lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma nga wane lo'oo ka iiria, “Alafa 'ae, nau ku tagoto'o no'o amu.” Ma ngaia ka bobouruuru 'i wado 'i na'ona 'a'aena la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","La Jisas ka fata 'ilo'oo, “Nau ku leka mai fana 'aku sufaa ta'a na fanua lo'oo 'i wado, fana ta'a maaga 'e logo 'agila aga su'a na 'ola kwala'imori suria God ma fana ta'a na gila madafia iiria gila aga le'a 'agila su'aai na maaga 'e logo kwala'imori.” ");
INSERT INTO kwd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma tani wane na Farasii gila to'oru no'ona fe'enia, ma gila longoa ngaia 'e iiria 'ola lo'oo, ma gila ka orisia, “'Ilo'oo ma 'i'oo iiria nga maa meeru 'e logo la'u mola?” ");
INSERT INTO kwd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Lauta maa mooru ngaia 'e logo 'ilo'oo, God 'e sia sufa 'amooru mola. Tafe'ua mooru moru iiria moru su'a ana. Ngaia na'a God te'e sufa 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","La Jisas 'e alafuu fana nga fufu'iwane aana maka 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru, nga wane na ngaia 'ame ru'u na nga sinamaa na nga feo na nga sifisifi, ma ka ru'u mola mai 'i burina nga feo na sifisifi, ngaia nga wane beriberi. ");
INSERT INTO kwd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma nga wane na ngaia 'e ru'u mai na sinamaa, ngaia no'o na nga wane kwala'imori ne'e aga suria nga sifisifi. ");
INSERT INTO kwd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nga wane ni folonga na sinamaa 'e 'ulasia nga sinamaa na feo lo'o fana, ma nga sifisifi gila ka longo su'a na nga kwalana, ma gila ka leka mai te'ana. Ngaia 'e su'a na latana nga sifisifi aana, ma ka talaiga 'i maa. ");
INSERT INTO kwd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ma alata ngaia 'e talaia nga sifisifi aana te'efou 'i maa, ngaia 'e leka 'i na'oga, ma gila ka leka 'i burina, suria gila longo su'a na kwalana. ");
INSERT INTO kwd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma ngaia 'e 'ato 'agila leka 'i burina te'efuta wane matari. Gila tagila 'akwa fa'asia, tofuna gila 'ame longo su'a na nga kwalana.” ");
INSERT INTO kwd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na alata la Jisas 'e alafuu 'ania nga fa'aladanga lo'oo faga, ma gila 'ame su'a mola na nga fa'awatagalai. ");
INSERT INTO kwd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ngaia lo'oo, la Jisas 'e alafuu la'u 'ilo'oo, “'Ola kwala'imori nau ku iiria famooru, 'inau na nga sinamaa fana nga sifisifi 'ani ru'u ai. ");
INSERT INTO kwd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nga wane laka'u gila nigi mai na'ogu, gila nga ta'a beriberi, ma nga sifisifi lo'oo gila 'ame lo'o mola suriga. ");
INSERT INTO kwd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nau na nga sinamaa fana ru'unga. Ni dai na gila ru'u mai talagu, nau taku fa'amooria. Ngaia 'e 'ilaka'u sifisifi na gila 'ame ma'u fana ru'unga mai ma ru'unga kau ma gila ka daria nga ketonga aaga. ");
INSERT INTO kwd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nga wane beriberi ngaia 'e nigi mola mai fana beringa ma kwa'inga ma ngada 'olanga. Tafe'ua mai nau ku nigi mai fana 'amoru to'o na nga mooringa na ngaia 'e le'a maka ba'ita. ");
INSERT INTO kwd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nau nga wane na ngaia 'e aga le'a suria sifisifi. Ma 'inau ku 'uri fana maenga 'usia nga sifisifi agu. ");
INSERT INTO kwd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma nga wane na ngaia 'e taunga'i mola fana nga foforinga, nga sifisifi lo'oo ngaia nga 'ola aana 'amoe. Alata ngaia 'e agasia nga ku'ito kwasi 'e leka mai, ngaia te'e 'akwasia mola sifisifi no'ona, ma ka 'akwa mola fa'asiga. Ma nga ku'ito kwasi te'e leka mai maka kwa'ia nga sifisifi lo'oo 'ani mae, ma ka tagale'eniga mola. ");
INSERT INTO kwd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nga wane no'ona 'e 'akwa no'o suria ngaia 'e taunga'i mola fana foforinga, ma ngaia 'ame kwaimaange'enia mola nga sifisifi lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nau ku aga le'a suria nga sifisifi lo'oo, mai nau ku 'uri fana maenga 'usia nga sifisifi agu. Ma gila ka su'a agu, mai nau ku su'a la'u mola aga, 'ilaka'u la'u mola na Mama'a ngaia 'e su'a agu, mai nau ku su'a la'u mola ana. ");
INSERT INTO kwd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma tani sifisifi agu la'u mola na gila 'ame nana'i 'ua 'ubulana feo. Ma nau taku ngariga la'u mola mai. Ma tagila longo su'a na kwalagu, ma tagila to'oru oguogu fe'enia nga sifisifi lo'oo gila nana'i no'o 'i lo'oo. Ma nau taku aga suriga te'efou. ");
INSERT INTO kwd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nga Mama'a ngaia 'e kwaimaa fagu, tofuna nau ku 'uri fana 'aku mae, ma nau 'aku moori la'u. ");
INSERT INTO kwd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Te'efuta wane 'e sia kwa'i nau mola, lauta nau ku 'ame rugasi nau fana. Ma nau ku 'uri mola. Nau ku to'o na tegelangaa fana kwatelagu 'i talagu fana maenga ma fana mooringa la'u mola 'ilaka'u na nga Mama'a agu 'e iiria fagu.” ");
INSERT INTO kwd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma nga alata no'ona, ta'a 'i Jiu lo'oo gila 'ame arua no'o te'e manatangaa suria la Jisas tofuna nga 'ola na ngaia 'e fata suria. ");
INSERT INTO kwd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aulalaga gila iiria, “Wane lo'oo ngaia 'e kwekweto, ma ka to'o na anoe 'ola 'e ria. Moru sia longo mola fana.” ");
INSERT INTO kwd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tafe'ua ma tani ta'a aaga gila ka fata 'ilo'oo, “Nga wane na ngaia 'e to'o na anoe 'ola 'e ria, ngaia 'e 'ato 'ani fata 'ilo'oo! Ma nga wane to'o na anoe 'ola 'e ria, ngaia 'ato 'ani gulaa wane maaga 'e logo, ma gila ka aga la'u!” ");
INSERT INTO kwd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na alata na gwaringa, nga ta'a 'i Jiu lo'oo gila ogu 'i Jerusalem fana fafangalaa na Fa'a Abulana 'Ifi Abu na God. ");
INSERT INTO kwd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma la Jisas 'e nana'i la'u mola 'ubulana 'Ifi Abu no'ona, ma ka leka mola 'ubulana fofoda ala Solomon. ");
INSERT INTO kwd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aia, ma na alata ta'a gila agasia, gila ka ogu mai te'ana, ma gila ka orisia ma gila 'ilo'oo, “Meeru meru mamani'o 'e aburu no'o. 'Oi kwairii wataga no'o fameeru! 'Ilo'oo ma 'i'oo na nga Kraes, 'ino'ona ma 'i'oo 'amoe?” ");
INSERT INTO kwd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","La Jisas 'e lamadu'aga maka 'ilo'oo, “Nau ku iiria famooru 'e sui no'o, tafe'ua ma moru 'ame siria mola tagoto'onga agu. Nga taunga'inga lo'oo nau ku agea na nga tegelangaa na nga Mama'a agu, ma gila ka faate'enia no'o nau wane 'utaa. ");
INSERT INTO kwd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tafe'ua ma moru 'ame siria mola tagoto'onga agu, tofuna mooru nga sifisifi agu 'amoe. ");
INSERT INTO kwd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nga sifisifi agu gila longo su'a na nga kwalagu, mai nau ku su'aga, ma gila ka leka 'i burigu. ");
INSERT INTO kwd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma nau ku kwatea nga mooringa firi faga, ma gila sia mae la'u. Ma 'e 'ato fana te'efuta wane 'ani lafuga fa'asi nau. ");
INSERT INTO kwd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nga Mama'a agu ne'e kwatea nga sifisifi lo'oo fagu, ngaia 'e tegela maka riufia no'o 'ola te'efou. Ma ka 'ato no'o fana te'efuta wane 'ani lafua nga sifisifi lo'oo fa'asia. ");
INSERT INTO kwd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nau fe'enia nga Mama'a, mee'e te'e 'ola momola.” ");
INSERT INTO kwd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma nga alata no'ona, nga ta'a gila ka so'ofia fou la'u mola, fana 'agila 'uia la Jisas 'ani mae. ");
INSERT INTO kwd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma la Jisas ka orisiga maka 'ilo'oo, “Mooru moru agasia 'e sui no'o nga taunga'inga le'a lo'oo te'efou na nau ku agea fa'asia nga Mama'a agu. 'Ilo'oo ma nga taunga'inga 'utaa na ni taunga'inga lo'oo na moru siria daulagu fafia?” ");
INSERT INTO kwd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma gila lamadu'aa ma gila ka 'ilo'oo, “Meeru meru 'ame 'ui'o la'u fafia nga taunga'inga le'a lo'oo na 'i'oo agea. Meeru meru siria 'ameru 'ui'o mola fafia na 'i'oo fata ngadaa God. Du'ana 'i'oo nga wane lo'oo mola, ma 'i'oo iiria 'i'oo God!” ");
INSERT INTO kwd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","La Jisas 'e lamadu'aga la'u maka 'ilo'oo, “'Ubulana Girigiringa Abu 'amooru, gila giria nga 'ola na God ngaia 'e iiria 'e 'ilo'oo, ‘Mooru nga god lo'oo.’ ");
INSERT INTO kwd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma goru su'a na nga 'ola te'efou 'ubulana Girigiringa Abu, ngaia 'e kwala'imori no'o, ma God ka iiria aga no'o 'ania god. ");
INSERT INTO kwd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma 'inau nga wane na God ngaia 'e firi nau ma ka alenau no'o mai fofona nga fanua lo'oo 'i wado. Ma 'e 'uta'i na moru iiria nau ku fata ngadaa God, alata nau ku iiria nau nga Wela aana? ");
INSERT INTO kwd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lauta nau ku 'ame agea nga taunga'inga lo'oo 'ilaka'u na Mama'a agu 'e agea, moru sia tagoto'o mola agu. ");
INSERT INTO kwd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tafe'ua ma tofuna nau ku agea nga taunga'inga 'ilaka'u na nga Mama'a agu 'e agea, moru tagoto'o mola na taunga'inga lo'oori, gwa'a moru 'ame tagoto'o na 'ola na nau ku fata suria famooru. Lauta moru agea nga 'ola lo'oo, tamoru su'a le'a ai, na nga Mama'a ngaia 'e nana'i fe'eni nau, mai nau ku nana'i la'u mola fe'enia nga Mama'a.” ");
INSERT INTO kwd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ma nga alata no'ona la'u mola, gila siria 'agila gemasia la Jisas, tafe'ua ma ngaia ka nagwa mola fa'asiga. ");
INSERT INTO kwd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma la Jisas ka ori fa'aburi la'u mola fana gule'e ka'o 'i Jodan, ma ngaia ka nana'i 'i no'ona na lefu laka'u la Jon ngaia 'e naruabu na ta'a ai 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma nga ta'a 'e aula iiki gila leka mai te'ala Jisas, ma gila ka alafuu faga kwairiu ma gila ka 'ilo'oo, “La Jon ngaia 'ame agea mola 'ola ni 'alefosilai, tafe'ua ma nga 'ola lo'oo ngaia 'e fata suria la Jisas, ngaia 'e kwala'imori te'efou no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma nga ta'a 'e aula na lefu no'ona gila ka tagoto'o no'o ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Te'e wane latana la Lasaros ngaia 'e fii. Ma ngaia 'e to'oru na fanua 'i Betani fe'enia nga rua noni futa fe'enia, ni Meri ma ni Mata. ");
INSERT INTO kwd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ni Meri lo'oori laka'u ngaia 'e 'irisia nga waiwai si'inilai 'e le'a 'i 'a'aena la Jisas ma ka 'usua 'ania nga ifiifuna gouna. ");
INSERT INTO kwd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma nga rua noni lo'oo gala kwatea alafuunga fala Jisas ma gala ka 'ilo'oo, “Alafa, nga wane ni kwaimaanga amu ngaia 'e fii.” ");
INSERT INTO kwd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma alata la Jisas 'e longoa nga 'ola lo'oori, ngaia 'e alafuu 'ilo'oo fana nga fufu'iwane aana, “La Lasaros ngaia 'e sia mae mola na fiinga lo'oo. Nga fiinga lo'oo 'e lau fana 'ani faate'enia nga tegelangaa na God, ma fana ta'a 'agila fa'aba'ita God mai nau, nga Wela aana.” ");
INSERT INTO kwd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ma la Jisas 'e kwaimaa ba'ita fala Lasaros ma rua noni futa fe'enia lo'oo ni Mata ma ni Meri la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gwa'a 'ino'ona, alata la Jisas ngaia 'e longoa la Lasaros ngaia 'e fii no'o, ngaia 'e nana'i mola na lefu no'ona ngaia 'e nana'i ai suria rua gani ngaa'i. ");
INSERT INTO kwd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sui ma la Jisas ka fata 'ilo'oo fana nga fufu'iwane aana, “Goru ori no'o fani Judea.” ");
INSERT INTO kwd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma nga fufu'iwane aana gila ka fata 'ilo'oo, “Wane kwaifa'ananaunga, ngaia 'ame aburu mola laka'u, nga ta'a 'i Jiu gila siria kwa'ilamu ma 'uilamu 'ania fou. Ma 'i'oo siria 'i'oo 'ani ori la'u no'ona?” ");
INSERT INTO kwd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma la Jisas ka fata 'ilo'oo, “Na te'e ma'e gani nga sina 'e sina 'ita 'usugani leleka maka nigi laulafi. Lauta te'efuta wane 'e leka na alata gagani, 'ato ngaia 'ani telefe'enia, suria ngaia 'e agasia nga lalanga na fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tafe'ua ma lauta te'efuta wane 'e leka 'ubulana logo, ngaia te'e telefe'enia, tofuna nga lalanga 'e 'amoe fana.” ");
INSERT INTO kwd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ma la Jisas ka fata la'u 'ilo'oo, “Nga wane kwaimaanga laka'u adauru la Lasaros, ngaia 'e eeno no'o, mai nau taku leka, 'aku fa'aagaa.” ");
INSERT INTO kwd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma nga fufu'iwane aana gila lamadu'aa ma gila ka 'ilo'oo, “Alafa, lauta ngaia 'e eeno mola, ngaia te'e le'a mola.” ");
INSERT INTO kwd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nga fa'awatagalana nga alafuunga ala Jisas na la Lasaros ngaia 'e mae no'o. Tafe'ua ma gila madafia iiria ngaia 'e eeno kwala'imori mola. ");
INSERT INTO kwd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sui ma la Jisas 'e kwairii wataga ai faga maka 'ilo'oo, “La Lasaros ngaia 'e mae no'o. ");
INSERT INTO kwd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tafe'ua mai nau ku aile'a na nau ku 'ame nana'i fe'enia, fana 'amooru tagoto'o agu. Dauru goru leka te'ana.” ");
INSERT INTO kwd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","La Tomas na gila fa'alataa 'ania ‘'I'iu’ ka fata 'ilo'oo fana nga fufu'iwane no'ona, “Goru leka fe'enia nga Alafa, fana 'agoru mae la'u mola fe'enia!” ");
INSERT INTO kwd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma alata la Jisas 'e nigi no'ona, fai gani 'e sui no'o 'i burina na gila kwaiatoa la Lasaros. ");
INSERT INTO kwd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nga fanua 'i Betani 'e nana'i galangia 'i Jerusalem, 'e to'omia fana oru kilomita. ");
INSERT INTO kwd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma ta'a 'e aula 'i Judea gila nigi fana 'agila nagufia ni Mata ma ni Meri, fana nga gwa'olagaa'a, tofuna wane gila futa ngaia 'e mae. ");
INSERT INTO kwd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma alata ni Mata 'e longoa la Jisas ngaia 'e nigi mai, ngaia 'e leka fana agasilana. Ma ni Meri 'e nana'i mola 'i 'ifi. ");
INSERT INTO kwd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni Mata 'e fata 'ilo'oo fala Jisas, “Alafa 'ae, lauta 'i'oo nana'i mola lo'oo, nga wane mele futa 'e sia mae mola. ");
INSERT INTO kwd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tafe'ua mai nau ku su'aai gwa'a alata lo'oo, God te'e kwatea mola te'efuta 'ola na 'i'oo kwaisoe fai.” ");
INSERT INTO kwd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma la Jisas ka alafuu 'ilo'oo fana, “Nga wane molo futa te'e moori mola.” ");
INSERT INTO kwd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma ngaia ka fata fala Jisas maka 'ilo'oo, “Nau ku su'aai ngaia te'e moori la'u mola na fe'e gani 'i'isi.” ");
INSERT INTO kwd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma la Jisas ka alafuu 'ilo'oo fana, “Nau no'o na tata'enga na wane 'e mae, ma nau ku kwatea nga mooringa fana. Ni dai na ngaia 'e tagoto'o agu, ngaia te'e moori la'u mola, gwa'a ngaia 'ani mae no'o. ");
INSERT INTO kwd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma ni dai na gila tagoto'o agu, tagila to'o na mooringa firi, ma gila sia mae mola. 'Ilo'oo ma 'i'oo tagoto'o na 'ola lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma ngaia ka lamadu'aa maka 'ilo'oo, “Kiu Alafa. Nau ku tagoto'o na 'i'oo no'o na nga Kraes, nga Wela na God na ngaia 'e fataarunga'i fana kwatelana mai fana fanua lo'oo wado.” ");
INSERT INTO kwd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma burina ni Mata 'e iiria 'ola lo'oori, ngaia ka ori, ma ka kwalanguru fana nga noni futa aana ni Meri, ma ka fata 'ilo'oo te'ana, “Nga wane kwaifa'ananaunga 'e nigi no'o, ma ngaia siria 'ani agasi'o.” ");
INSERT INTO kwd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma alata ni Meri ngaia 'e longoa alafuunga lo'oo, ngaia 'e tata'e, maka leka no'o te'ana. ");
INSERT INTO kwd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma la Jisas 'ame nigi 'ua mai fanua, ma ngaia nana'i 'ua mola mai na lefu laka'u ni Mata ngaia 'e daria ai. ");
INSERT INTO kwd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma nga ta'a na gila nana'i 'i 'ifi fe'enia ni Meri fana nga gwa'olana, gila leka la'u mola 'i burina alata gila agasia ngaia 'e tata'e ma ka leka 'aferu kau 'i maa. Gila madafia iiria ngaia 'e leka 'i maana nga giru gwa'u fana 'ani aani ai. ");
INSERT INTO kwd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma alata ni Meri 'e nigi na lefu na la Jisas ngaia 'e nana'i ai, ngaia 'e agasia, ma ka bobouruuru 'i na'ona 'a'aena, ma ka alafuu 'ilo'oo, “Alafa, lauta 'i'oo nana'i mola 'i lo'oo, nga wane mele futa ngaia 'e sia mae mola.” ");
INSERT INTO kwd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma la Jisas ka agasia ni Meri ngaia 'e aani, ma nga ta'a na gila leka mai fe'enia gila aani la'u mola, ma ngaia ka kwaimanadai ba'ita. ");
INSERT INTO kwd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma la Jisas ka orisiga maka 'ilo'oo, “'I fai na moru arua ai?” Gila ka lamadu'aa 'ilo'oo ana, “Alafa, leka mai, moko agasia 'i talamu.” ");
INSERT INTO kwd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma la Jisas 'e aani. ");
INSERT INTO kwd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma ta'a 'i Jiu no'ona gila ka alafuu faga kwairiu ma gila ka 'ilo'oo, “Moru agasia, nga kwaimaanga 'e ba'ita fala Lasaros!” ");
INSERT INTO kwd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma tani wane ngaa'i gila ka alafuu 'ilo'oo, “Ngaia 'e gulaa nga ta'a maaga 'e logo. 'Uta'i na ngaia 'e sia ruia mola la Lasaros fa'asia nga maenga?” ");
INSERT INTO kwd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","La Jisas 'e kwaimanadai ba'ita la'u mola, ma ka leka 'i maana nga giru gwa'u. Nga giru gwa'u lo'oori, ngaia nga giru gwa'u na te'e me'e fou ba'ita gila arua 'i maana. ");
INSERT INTO kwd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma la Jisas ka iiria faga maka 'ilo'oo, “Moru 'idua nga fou no'ona.” Ma ni Mata nga noni futa fe'enia nga wane lo'oo 'e mae, 'e lamadu'aa maka 'ilo'oo, “Alafa 'ae, nga fai gani lo'oo 'e sui no'o 'i burina na gila kwaiatoa. Lo'oo, ngaia te'e si'ini 'e ria no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma la Jisas ka fata 'ilo'oo fana, “Nau ku iiria 'e sui no'o famu laka'u lauta 'i'oo tagoto'o agu, to'o agasia nga tegelangaa na God.” ");
INSERT INTO kwd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma gila ka lafua nga fou no'ona. Ma la Jisas 'e aga 'i langi ma ka fo'a 'ilo'oo, “Mama'a, nau ku fa'aba'ita'o tofuna 'i'oo longo no'o mai fagu. ");
INSERT INTO kwd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nau ku su'aai na 'i'oo longo nau furifuri. Nau ku iiria 'ola lo'oo, fana nga ta'a lo'oo 'agila tagoto'o na 'i'oo alenau mai.” ");
INSERT INTO kwd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma 'i burina na ngaia 'e iiria alafuunga lo'oori, ngaia 'e o'omae ba'ita maka 'ilo'oo, “Lasaros, ru'u mai 'i maa!” ");
INSERT INTO kwd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma nga wane lo'oo 'e mae no'o ka moori la'u mola, ma ka ru'u no'o mai 'i maa. Ma nga rua 'a'aena, ma nga rua ninimana, gila gaua 'ania nga ruu fana 'afulana nga wane mae, nga maana gila gaua la'u mola. Ma la Jisas ka fata 'ilo'oo faga, “Moru rubea no'o ruu lo'oo fa'asia, ma moru ka alamia 'ani leka no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma nga ta'a 'e aula 'i Jiu na gila nigi mai te'ana ni Meri, gila agasia 'ola lo'oo la Jisas 'e agea, ma gila ka tagoto'o no'o ana. ");
INSERT INTO kwd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tafe'ua ma tani ta'a aaga, gila ori te'ana ni Farasii, ma gila ka alafuu suri 'ola na la Jisas ngaia 'e agea. ");
INSERT INTO kwd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma Farasii, ma fataabu ba'ita, gila ka alafuu fe'enia ta'a ni fadafadanga, ma gila ka alafuu 'ilo'oo, “'Ola taa na tagoru agea na wane lo'oo? Nga wane lo'oo 'e agea 'ola ni 'alefosilai 'e aula no'o. ");
INSERT INTO kwd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma lauta goru alamia wane lo'oo 'ani agea mola 'ilo'oo, nga ta'a 'e aula tagila tagoto'o ana. Ma nga ta'a ba'ita fa'asia 'i Rom, tagila baoria no'o fadauru. Ma lauta 'e 'ino'ona, ta'a 'i Rom tagila tagale'enia nga 'Ifi Abu na God, ma tagila ngadaa no'o fanua adauru.” ");
INSERT INTO kwd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma te'e wane aaga latana la Kaeafas nga alafa ni suuabunga na alata no'ona ngaia ka fata 'ilo'oo, “Mooru moru 'ame su'a mola na te'efuta 'ola! ");
INSERT INTO kwd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","To'omia 'amooru su'aai, ngaia 'e le'a fana te'e wane fana 'ani mae, fana gila sia kwa'ia mola nga ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aia, ma nga alafuunga lo'oo na la Kaeafas ngaia 'e iiria, ngaia nga 'ola 'i manatalana te'ingaia 'amoe. Tofuna ngaia na alafa ni suuabunga, ma God 'e arua nga manatangaa lo'oori 'i manatana fana 'ani kwairii na la Jisas te'e mae fana boonilana nga ta'a 'i Jiu. ");
INSERT INTO kwd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma ngaia 'ame mae mola fana ta'a 'i Jiu lo'oo 'i talaga. Ngaia 'e mae fana nga ru'uru'ua na God te'efou na gila nana'i na fanua lo'oo te'efou 'agila lado ma gila arua te'e oguogunga. ");
INSERT INTO kwd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma eta na fe'e gani na la Kaeafas 'e iiria alafuunga no'ona, gila ka eta no'o fana fadanga fana 'agila kwa'ia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Du'ana 'ola lo'oori, la Jisas ngaia 'ame leka faata'i no'o na gule'e lefu 'i Judea. Na alata no'ona, ngaia ka leka fa'asia lefu no'ona fe'enia nga fufu'iwane aana, ma gila to'oru na fanua 'i Ifrem ne'e galangia nga lefu langalanga. ");
INSERT INTO kwd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na alata no'ona, ngaia galangia no'o gani na Fafangalaa na Tala Riunga 'i Jiu. Ma nga ta'a 'e aula gila ka leka kau fani Jerusalem 'i na'ona nga fafangalaa lo'oo, fana fa'akwarilaga 'i talaga 'ilaka'u nga Tagi ala Moses 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma nga ta'a gila ka kwailo'ofia la Jisas. Ma nga alata no'ona, gila ogu mai 'i 'ubulana nga 'Ifi Abu na God, ma gila ka orisiga kwairiu ma gila 'ilo'oo, “'Ilo'oo ma mooru madafia ngaia te'e nigi mai na nga fafangalaa lo'oo? Bala 'e 'amoe mola ta'ua.” ");
INSERT INTO kwd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gila alafuu 'ilo'oo suria ni fataabu ba'ita ma ni Farasii, gila iiria fana ta'a 'agila kwairii te'aga lauta te'efuta wane 'e su'ana lefu na la Jisas ngaia 'e nana'i ai, fana 'agila gemasia. ");
INSERT INTO kwd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma ono gani 'i na'ona Fafangalaa na Tala Riunga, la Jisas fe'enia nga fufu'iwane aana gila ori la'u mola fana 'i Betani, nga maa'e fanua ala Lasaros na la Jisas ngaia 'e tata'ea fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gila sasaria nga fangalaa fala Jisas. La Lasaros te'e wane na nga ta'a na gila soea mai fana ketonga fe'enia la Jisas. Ma ni Mata ka ngaria fangalaa mai faga. ");
INSERT INTO kwd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma ni Meri ka ngaria mai te'e fe'e waiwai na gila fa'alataa 'ania nad na forilana 'e ba'ita 'e iiki. Ni Meri 'e ngaria mai maka 'irisia 'i fofona 'a'aena la Jisas fana fa'aba'italana. Ma ni Meri ka 'usua 'a'aena la Jisas 'ania ifiifuna gouna. Ma nga 'ifi lo'oo ka fofofo no'o 'ania si'inilana nga waiwai no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tafe'ua ma la Judas Iskariot, nga wane laka'u ne'e kwatea la Jisas fana maarimae aana, ngaia ka fata kau maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Fe'ua ngaia 'ame fa'afori 'ania nga waiwai lo'oo? Nga waiwai lo'oo lauta ngaia 'e fa'afori 'ania, ngaia te'e ngaria oru tangale'e dola. Ma bata lo'oori 'e to'omia 'i'oo 'ani ngaria moko kwatea fana nga ta'a gila galafa'a.” ");
INSERT INTO kwd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","La Judas ngaia 'e iiria nga 'ola lo'oo, 'amoe la'u tofuna na ngaia 'e madafia fana boonilana ta'a na gila galafa, ma tofuna mola na ngaia nga wane beriberi. Ma ngaia la'u mola na nga wane fana aganga suria nga wa'i ni bata aaga. Ma tani alata ngaa'i, ngaia 'e ngaria mola bata no'ona fana 'i talana. ");
INSERT INTO kwd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Na alata no'ona, la Jisas 'e fata 'ilo'oo, “'I'oo sia to'ofonosia la'u nga noni lo'oo! Ngaia 'e gonia nga waiwai lo'oo fana 'usulai 'ania nonigu na alata fana kwaiatolagu. ");
INSERT INTO kwd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma ta'a na gila galafa, gila nana'i mola fe'eni 'amoru gani mai gani. Ma nau ku sia nana'i aburu mola fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ta'a 'e aula gila longoa la Jisas ngaia 'e nana'i 'i Betani, ma gila ka leka mai te'ana. Gila 'ame leka mai tofuna gila siria 'agila agasia la Jisas, ma gila leka la'u mola mai fana agasilana la Lasaros laka'u la Jisas ngaia 'e tata'ea fa'asia maenga. ");
INSERT INTO kwd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ma nga aulalana ta'a 'i Jiu gila ka tagoto'o no'o ala Jisas tofuna ngaia 'e tata'ea la Lasaros fa'asia nga maenga. Ngaia lo'oo, ni fataabu ba'ita lo'oo gila ka fadaa fana kwa'ilana la Lasaros 'ilaka'u la'u mola na gila sasari fana kwa'ilana la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na nga ruana gani, ta'a 'e aula na gila leka mai fani Jerusalem fana nga Fafangalaa na Tala Riunga, gila longoa la Jisas ne'e leka mai ");
INSERT INTO kwd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gila leka, ma gila ngaria mai lalana baibai, ma gila ka leka mai fana 'agila daria la Jisas. Ma gila ka o'omae ma gila ka 'ilo'oo, “Tafea God! God 'oi nanamate'enia mai nga wane na ngaia 'e leka mai 'ania latamu! God 'oi nanamate'enia nga Kiingi ameeru 'i Israel.” ");
INSERT INTO kwd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na alata no'ona, la Jisas 'e ngaria te'e dale'e dongki maka fane 'i fofona. Nga 'ola lo'oo ngaia 'e fa'ato'oa mola nga 'ola na Girigiringa Abu laka'u 'e iiria maka 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Moru ta'a 'i Jerusalem, moru sia ma'u! Moru agasia nga kiingi amooru na ngaia 'e ta'e mai 'i fofona dale'e dongki.” ");
INSERT INTO kwd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma nga alata no'ona, nga fufu'iwane aana gila 'ame su'a 'ua na fa'aladamilana 'ola lo'oo. Ma 'i burina na la Jisas ngaia 'e tata'e la'u ma ka ori fana 'i langi, gila bi'i manata to'ona na ni 'ola lo'oo 'e lau 'ilaka'u nga Girigiringa Abu 'e iiria. ");
INSERT INTO kwd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nga ta'a lo'oo na gila nana'i fe'enia la Jisas na alata ngaia 'e soea mai la Lasaros fa'asia 'ubulana giru gwa'u, gila kwairii 'ania 'ola lo'oori fana ta'a 'e aula. ");
INSERT INTO kwd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ngaia lo'oo nga ta'a 'e aula gila ka leka mai, fana 'agila daria la Jisas. Gila leka suria gila longoa te'efou na la Jisas 'e agea nga 'ola ni 'alefosilai lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma nga alata no'ona, ni Farasii gila ka fata 'ilo'oo faga kwairiu, “Moru agasia! Gwa'a goru agea fadafadanga 'e aula, ngaia 'e 'ato no'o tofuna ta'a 'e aula gila leka no'o suria nga wane lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tani ta'a 'i Grik, gila nana'i la'u mola laloaga nga ta'a na gila leka mai fana 'i Jerusalem fana nga fo'anga na Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gila leka te'ana la Filip, nga wane fa'asia 'i Betsaeda 'ubulana nga me'e lefu 'i Galili, ma gila ka alafuu 'ilo'oo fana, “Wane ba'ita, 'imeeru meru siria 'ameru agasia la Jisas.” ");
INSERT INTO kwd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ma la Filip ka leka maka kwairii te'ala Andru, ma gala ka leka ma gala ka kwairii te'ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma la Jisas ka lamadu'aga maka 'ilo'oo, “Nga alata 'e nigi no'o fana God 'ani faate'enia no'o na 'inau, nga Wela na Wane, nau ku to'o na foufounga. ");
INSERT INTO kwd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nga 'ola kwala'imori nau ku iiria famooru. Lauta te'efuta lodona witi ngaia 'ame 'esia 'ubulana nga wado ma ngaia 'ame mae mola, nga lodona witi lo'oori te'e to'oru tago mola. Ma lauta ngaia 'e mae, ma ngaia te'e bi'i bila'o la'u 'ania lodona witi auaula. ");
INSERT INTO kwd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma lauta nga wane 'e kwaimaa 'e iiki fana nga mangona 'i talana, ngaia te'e mae mola. Ma lauta nga wane ngaia 'e kwaimaa fagu maka riufia kwaimaanga aana fana mangona fofona nga fanua lo'oo 'i wado, ngaia te'e to'o na mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ma te'efuta wane na ngaia 'e siria 'ani taunga'i fagu, ngaia 'ani leka suri nau, ma ka nana'i na lefu na nau ku nana'i ai. Ma nga Mama'a agu te'e iiri ba'ita na wane na ngaia 'e taunga'i fagu.” ");
INSERT INTO kwd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ma nga alata lo'oo, nga manatalagu ngaia 'e madanga no'o, ma 'olataa nau taku iiria la'u? Nau ku sia alafuu 'ilo'oo, ‘Mama'a 'ae, 'i'oo sia alamia mola alata lo'oo 'ani nigi mai fafi nau.’ 'Amoe no'o. Tofuna ngaia no'o na nga 'ola na nau ku leka mai fai, fana 'aku riu to'ona nga alata na nga nonifiinga. ");
INSERT INTO kwd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mama'a 'ae, 'oi faate'enia tegelangaa amu fana ta'a.” Ma nga alata no'ona, te'e kwala'e 'ola ka fata mai fa'asia 'i langi maka 'ilo'oo, “Nau ku faate'enia no'o nga kwangakwanganga agu, mai nau taku agea la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma nga oguogunga lo'oo gila ula 'i no'ona, ma gila longoa nga kwala'e 'ola lo'oori, ma tani wane aaga gila ka iiria nga loulou. Ma tani wane ngaa'i gila ka iiria nga enselo no'ona 'e alafuu mai fana. ");
INSERT INTO kwd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma la Jisas ka fata 'ilo'oo faga, “Nga kwala'e 'ola na ngaia 'e fata mai, ngaia 'amoe la'u fana nga boonilagu, ma ngaia 'e fata mola mai fana booni lamooru. ");
INSERT INTO kwd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma nga alata 'e nigi no'o fana God 'ani kwaisufai na ta'a fofona fanua lo'oo 'i wado. Na alata lo'oo, God te'e lafua no'o la Saetan ne'e ba'ita fafia nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma nga alata gila lafu nau na 'ai folo, nau taku talaia mai nga ta'a te'efou te'agu.” ");
INSERT INTO kwd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ma suria nga alafuunga lo'oo, ngaia 'e faate'enia mola nga maenga 'utaa na ngaia te'e mae ai. ");
INSERT INTO kwd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma nga ta'a gila ka fata 'ilo'oo, “Nga Girigiringa Abu 'adauru ngaia 'e iiria nga Kraes te'e momoori firi. Welakau 'utaa 'i'oo iiria tagila lafua nga Wela na Wane na 'ai folo? Ma ni dai no'o na nga Wela na Wane lo'oo welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","La Jisas ka lamadu'aga maka 'ilo'oo, “Fana alata sisika mola, nga lalanga te'e nana'i fe'eni 'amooru. To'omia 'amooru riu kwairiu alata lalanga 'e nana'i 'ua fe'enia mooru fa'asia logologo'angaa ka nigi fafi 'amooru. Tofuna ni dai na ngaia 'e leka 'ubulana ma'e logo, ngaia 'e bobolosia 'i fai na ngaia 'e leka fai. ");
INSERT INTO kwd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Alata na nga lalanga ngaia 'e nana'i 'ua fe'eni 'amooru, moru tagoto'o ana, fana 'amoru lau fana nga ru'uru'ua na lalanga lo'oo.” La Jisas 'e iiria nga 'ola lo'oo, sui ma 'i ngaia ka leka, ma ka nagwa no'o fa'asiga. ");
INSERT INTO kwd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gwa'a la Jisas 'ani agea 'ola ni 'alefosilai 'e aula ma gila ka agasia, gila 'ame tagoto'o mola. ");
INSERT INTO kwd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nga 'ola lo'oo ngaia 'e 'ilo'oo, fana 'ani fa'ato'oa nga alafuunga ala Aesea nga profet na ngaia 'e iiria no'o mai 'i na'o, “Alafa, gila 'ame tagoto'o mola na alafuunga lo'oo meru kwairii 'ania. Ma gila 'ame aga su'a la'u mola na nga tegelangaa amu na 'i'oo faate'enia faga.” ");
INSERT INTO kwd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gila 'ame tagoto'o suria la Aesea nga profet 'e kwairii 'ua no'o mai 'ilo'oo, ");
INSERT INTO kwd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tofuna nga manatalaga 'e ngasi 'e iiki, ma aringaga 'e boko, ma gila bokota la'u mola nga maaga. Lauta maaga 'e aga su'aai, ma aringaga 'e 'ulasi, ma nga manatalaga 'e su'ana fatalana God, bala gila bolota'i mai te'agu mai nau taku gulaga mola.” ");
INSERT INTO kwd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Alata la Aesea 'e iiria 'ola lo'oo, ngaia 'e alafuu suria la Jisas tofuna God ngaia 'e faate'enia no'o nga kwangakwanganga ala Jisas fana. ");
INSERT INTO kwd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gwa'a 'ani 'ino'ona, ta'a na'ona'o aula 'i Jiu na gila tagoto'o ala Jisas. Tafe'ua ma gila 'ame alafuu mola suria fana ta'a matari lo'oo, tofuna gila ma'unge'enia nga Farasii lo'oo, fa'asia gila ta ruiga fa'asia ru'unga 'ubulana nga 'ifi ni fo'anga aaga. ");
INSERT INTO kwd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gila manata abelo iiki suria agelana 'ola fana ta'a 'agila iiri ba'ita aaga. Ma gila 'ame manata abelo mola suria agelana 'ola fana God fana ngaia 'ani iiri ba'ita aaga. ");
INSERT INTO kwd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma la Jisas ka fata ba'ita ma ka 'ilo'oo, “Lauta te'efuta wane ngaia 'e tagoto'o agu, ngaia 'e tagoto'o la'u mola na God ne'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma lauta te'efuta wane ngaia 'e agasi nau, ngaia 'e agasia la'u mola God ne'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nau ku leka mai fofona fanua lo'oo 'i wado 'ilaka'u lalanga fana ta'a, fana ni dai ne'e tagoto'o agu, gila sia nana'i mola 'ubulana logologo'angaa. ");
INSERT INTO kwd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma ni dai ne'e longoa fatalagu, ma ngaia 'ame dau suria, nau ku sia sufaa mola, tofuna nau ku 'ame leka mai fofona fanua lo'oo 'i wado fana sufalana ta'a. Ma nau ku leka mai fana fa'amoorilana ta'a. ");
INSERT INTO kwd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wane na ngaia 'e ma'asiri agu, ma ngaia 'ame siria la'u mola agelana 'ola nau ku fata suria lo'oo, nga alafuunga lo'oo agu na nga 'ola te'e sufaa na gani 'i'isi. ");
INSERT INTO kwd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nga 'ola lo'oo 'e kwala'imori, suria alata nau ku alafuu 'ania, nau ku 'ame alafuu suria nga manatalagu 'i talagu. Tafe'ua ma Mama'a agu na ngaia 'e alenau mai, ngaia 'e iiria alafuunga lo'oo fagu fana 'aku iiria, mai nau ku alafuu suria. ");
INSERT INTO kwd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma nau ku su'aai nga alafuunga tegela'a lo'oo, nga Mama'a agu ne'e kwatea mooringa firi fana ta'a. Ngaia na'a, nga 'ola na nau ku iiria, ngaia nga 'ola na Mama'a agu ngaia 'e iiria fagu, fana 'aku kwairii 'ania.” ");
INSERT INTO kwd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te'e fe'e gani momola ne'e ole no'o fana Fafangalaa na Tala Riunga, ma la Jisas 'e su'a no'o na alata ngaia 'e gagalangi nigi no'o fana ngaia 'ani leka no'o fa'asia nga fanua lo'oo 'i wado, ma ka ori no'o te'ana nga Mama'a aana. Ma ngaia 'e kwaimaa le'a fana nga fufu'iwane aana na gila nana'i fofona nga fanua lo'oo 'i wado, ma ngaia ka kwaimaa faga leleka maka nigi na alata ngaia 'e mae. ");
INSERT INTO kwd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma la Jisas fe'enia nga fufu'iwane aana, gila keto te'efou na laulafi no'ona. Ma Saetan ka arua no'o manatangaa 'ame le'a 'ubulana nga manatana la Judas, nga wela ala Saemon Iskariot, fana 'ani kwatea la Jisas fana maarimae aana. ");
INSERT INTO kwd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma la Jisas 'e su'aai na Mama'a aana ngaia 'e kwatea no'o nga tegelangaa lo'oo te'efou fana. Ma ngaia 'e su'a la'u mola ai na ngaia 'e leka mai fa'asia God, ma ngaia te'e ori la'u mola te'ana God. ");
INSERT INTO kwd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ngaia na'a la Jisas 'e tata'e fa'asia nga fofoda na fangalaa, ma ka rubea nga sote aana, ma ka gaua no'o nga ruu fana fulolana labena 'i wa'ewa'etana. ");
INSERT INTO kwd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma ngaia ka 'irisia nga ka'o 'i 'ubulana nga teteu, ma ka narufia no'o 'a'aena nga fufu'iwane aana, ma ka fuloa 'ania nga ruu na ngaia 'e gaua 'i wa'ewa'etana. ");
INSERT INTO kwd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma alata ngaia 'e nigi te'ala Saemon Pita, ngaia 'e fata 'ilo'oo fala Jisas, “Alafa, 'ilo'oo ma 'i'oo 'ani narufia la'u mola 'a'aegu?” ");
INSERT INTO kwd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma la Jisas ka lamadu'aa maka 'ilo'oo, “Na alata lo'oo, 'i'oo bobolosia 'ua nga 'ola lo'oo nau ku agea amu, tafe'ua ma to'o su'aai 'i buri.” ");
INSERT INTO kwd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma la Pita ka alafuu 'ilo'oo, “'I'oo sia narufia mola 'a'aegu.” Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Lauta nau ku 'ame narufia no'o 'a'aemu, 'i'oo nga wane na fufu'iwane agu 'amoe no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma la Pita 'e lamadu'aa maka 'ilo'oo, “Alafa, 'ino'ona ma 'i'oo sia narufia mola te'e 'a'aegu. To'o narufia la'u mola nga nimagu, ma nga gougu.” ");
INSERT INTO kwd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","La Jisas 'e alafuu 'ilo'oo, “Ni dai na ngaia 'e naru 'e sui no'o, nga nonina ngaia 'e kwari te'efou no'o, ma ngaia 'e sia narufia la'u nga nonina te'efou. Ngaia te'e narufia mola nga 'a'aena. Amooru moru kwari te'efou no'o, ma te'e wane momola amooru na ngaia 'ame kwari.” ");
INSERT INTO kwd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","La Jisas ngaia 'e su'aai 'e sui no'o, ni dai na te'e 'olonge'enia fana nga maarimae lo'oo, ngaia lo'oo ngaia 'e alafuu 'ilo'oo, “Mooru moru kwari te'efou no'o, ma te'e wane momola amooru na ngaia 'ame kwari.” ");
INSERT INTO kwd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na alata la Jisas ngaia 'e narufia 'a'aega 'e sui, ngaia 'e ru'ufia la'u nga sote aana sui, mai ngaia ka to'oru la'u mola fe'eniga. Ma ngaia 'e orisiga maka 'ilo'oo, “'Ilo'oo ma moru su'a na 'ola na nau ku agea famooru? ");
INSERT INTO kwd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nga fa'awatagalai ngaia 'e 'ilo'oo: Amooru moru fa'alata nau 'ania Wane Kwaifa'ananaunga fe'enia nga Alafa amooru, ma to'omia no'o fana 'amooru fa'alata nau 'ino'ona, tofuna 'inau na nga Wane ni Kwaifa'ananaunga ma nga Alafa amooru. ");
INSERT INTO kwd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma gwa'a 'inau nga Wane ni Kwaifa'ananau ma nga Alafa amooru, nau ku narufia mola nga 'a'ae mooru. Ngai lo'oo, 'e le'a fana 'amoru narufia 'a'ae mooru kwairiu la'u mola 'ilo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nau ku agea 'ola lo'oori fana 'amooru agea famooru kwairiu 'ilaka'u lo'oo nau ku agea famooru. ");
INSERT INTO kwd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nga 'ola kwala'imori nau ku iiria famooru, nga wane ni taunga'inga ngaia 'ame ba'ita 'ani riufia wane ba'ita aana. Ma nga wane ni ngari kwairiinga, ngaia 'ame ba'ita riufia nga wane ne'e alea. ");
INSERT INTO kwd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Moru su'a le'a na nga 'ola lo'oo nau ku iiria famooru. Ma lauta moru agea la'u mola 'ilo'oo, God te'e nanamate'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nau ku iiria nga 'ola lo'oo 'amoe la'u famooru te'efou. Nau ku su'a mola ani dai amooru na nau ku firiga. Ma nga 'ola na gila giria 'ubulana Girigiringa Abu laka'u te'e lau kwala'imori 'ilo'oo, ‘Nga wane na mele keto oguogu na fangalaa agu, ngaia la'u mola na nga maarimae agu.’ ");
INSERT INTO kwd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nga 'ola lo'oo ngaia 'ame nigi 'ua mai, ma ngaia 'e le'a fana 'aku iiria famooru na alata lo'oo, fana nga alata ngaia 'e nigi mai, ma mooru tamoru tagoto'o na 'Inau Lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nga 'ola kwala'imori nau ku iiria famooru, nga wane na ngaia 'e kwaloa ni dai na nau ku alega kau, ngaia 'e kwalo nau la'u mola. Ma ni dai ne'e kwalo nau, ngaia 'e kwaloa la'u mola God na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Burina la Jisas ngaia 'e fata 'ilo'oo 'e sui, ngaia 'e kwaimanadai ba'ita. Ma ngaia ka kwairii wataga no'o 'ania fana nga fufu'iwane aana maka 'ilo'oo, “'Ola kwala'imori nau ku iiria no'o famooru. Te'e wane amooru ngaia te'e 'olonge'eni nau fana maarimae agu.” ");
INSERT INTO kwd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na alata no'ona, nga fufu'iwane lo'oo gila ka bubu kwairiu no'o faga, suria gila 'ame su'a ani dai na la Jisas ngaia 'e fata suria. ");
INSERT INTO kwd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma te'e wane na fufu'iwane aana laka'u la Jisas ngaia 'e kwaimaa fana, ngaia 'e to'oru galangia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma la Saemon Pita 'e lalo kau 'ania nga nimana fana wane lo'oo, fana 'ani orisia la Jisas, ni dai na ngaia 'e alafuu suria. ");
INSERT INTO kwd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nga wane laka'u 'e 'idu galangia kau la Jisas, ma ka kwalanguru fana maka 'ilo'oo, “Alafa, ni dai na nga wane no'ona 'i'oo alafuu suria?” ");
INSERT INTO kwd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","La Jisas 'e lamadu'aa maka 'ilo'oo, “Nga wane na nau ku kurume'enia nga beret 'ubulana nga teu, mai nau ku kwatea fana, ngaia no'o na nga wane lo'oori.” Sui ma la Jisas ngaia 'e kurume'enia nga beret 'ubulana teu maka kwatea fala Judas wela ala Saemon Iskariot. ");
INSERT INTO kwd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na alata no'ona mola la Judas 'e ngaria no'o nga beret lo'oori, ma Saetan ka ru'ufia no'o. Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi 'aferu fe'enia nga 'ola na 'i'oo agea.” ");
INSERT INTO kwd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma nga fufu'iwane na gila nana'i suria nga lafa ni fangalaa lo'oori, gila ka bobolosia 'uta'i na la Jisas ngaia 'e alafuu 'ilo'oo fala Judas. ");
INSERT INTO kwd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma tofuna la Judas ngaia nga wane ne'e aga suria nga wa'i ni bata aaga, tani wane na nga fufu'iwane lo'oo gila madafia iiria la Jisas ngaia 'e iiria fana la Judas 'ani leka maka foria mai tani fangalaa na gila bo'obo'o fai fana fafangalaa lo'oori, 'amoe ma ngaia 'e leka maka ngaria mai tani 'ola fana 'agila kwatea fana ta'a galafa lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Burina la Judas 'e ngaria nga fangalaa laka'u, ngaia 'e ru'u no'o 'i maa. Ma nga alata no'ona ngaia 'e logo no'o. ");
INSERT INTO kwd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Alata la Judas ngaia 'e leka no'o, la Jisas 'e alafuu 'ilo'oo, “Alata fana 'agila fa'aba'ita nau, nga Wela na Wane, ngaia 'e nigi no'o. Ma tagila fa'aba'ita God la'u mola tofuna 'ola lo'oo 'e lau agu. ");
INSERT INTO kwd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma lauta nga ta'a gila fa'aba'ita God tofuna 'inau, God no'o na te'e fa'aba'ita nau. Ma ngaia te'e fa'aba'ita nau na alata lo'oo mola. ");
INSERT INTO kwd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Fu'uwela agu, nau ku sia to'oru aburu la'u fe'eni 'amooru. Mooru tamoru kwailo 'ofi nau, mai nau ku iiria famooru nga 'ola laka'u nau ku iiria no'o fana ta'a na'ona'o 'i Jiu laka'u 'ilo'oo, ‘'Ato 'amooru leka na lefu lo'oo nau ku leka ai.’ ");
INSERT INTO kwd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma nga tagi fooru nau ku kwatea famooru ne'e 'ilo'oo: Moru kwaimaa famooru kwairiu, 'ilaka'u la'u mola na nau ku kwaimaa famooru. ");
INSERT INTO kwd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma lauta moru to'o na nga kwaimaanga famooru kwairiu, nga ta'a te'efou tagila su'aai na mooru nga fufu'iwane agu lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ma la Saemon Pita 'e orisia la Jisas maka 'ilo'oo, “Alafa, 'i'oo to'o leka fani fai?” La Jisas 'e lamadu'aa maka 'ilo'oo, “Lefu na nau taku leka fai, moru sia leka mola ai fe'eni nau. Tafe'ua ma tani gani ngaa'i tamoru bi'i leka mai burigu.” ");
INSERT INTO kwd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma la Pita ka orisia la'u maka 'ilo'oo, “Alafa, 'olataa na te'e kwatea ma ka 'ato fameeru fana lekanga fe'eni'o na alata lo'oo? Du'ana nau ku sasari no'o fana maenga fe'eni'o!” ");
INSERT INTO kwd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","La Jisas ka lamadu'aa maka fata 'ilo'oo fana, “'Ilo'oo ma 'i'oo sasari kwala'imori fana maenga fe'eni nau, welakau? 'Ola kwala'imori nau ku iiria famu. 'I na'ona na nga susuki 'ani aani, to'o iiria oru alata na 'i'oo bobolosi nau.” ");
INSERT INTO kwd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","La Jisas 'e alafuu 'ilo'oo fana nga fufu'iwane aana, “Moru sia manata abelo mola. Moru tagoto'o na God, ma moru tagoto'o la'u mola agu. ");
INSERT INTO kwd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Du'ana 'ifi na Mama'a agu ngaia 'e to'o na ni lefu auaula fana to'orunga ai. Ma nau ku leka fana 'aku sasari agau na lefu famooru. 'Ato fana 'aku iiria nga 'ola lo'oo famooru, lauta ngaia 'ame kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma alata nau ku leka, mai nau ku sasari agau na lefu famooru 'e sui, nau taku ori mai ma taku talai 'amooru fana nga lefu na nau ku nana'i ai, ma tamoru nana'i la'u mola ai. ");
INSERT INTO kwd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma mooru moru su'a mola na nga tala ne'e leka fana nga lefu na nau ku leka fai.” ");
INSERT INTO kwd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma la Tomas ka alafuu 'ilo'oo, “Alafa, 'imeeru meru bobolosia nga lefu na to'o leka fai. 'Ilo'oo ma tameeru su'a 'utaa na nga tala lo'oori welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Nau no'o na nga tala, mai nau nga to'onga, ma kua kwatea nga mooringa fana nga ta'a. Te'efuta wane 'e sia leka mola te'ana Mama'a agu lauta ngaia 'ame leka mai te'agu. ");
INSERT INTO kwd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ma lauta moru su'a kwala'imori no'o agu, mooru moru su'a la'u mola na Mama'a agu. 'Ita na alata lo'oo maka ori 'ala'a, mooru moru su'a no'o na Mama'a agu, ma moru ka agasia no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma la Filip ka alafuu 'ilo'oo, “Alafa, 'imeeru meru siria 'i'oo 'ani faate'enia madi nga Mama'a amu fameeru welakau.” ");
INSERT INTO kwd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma la Jisas ka lamadu'aa maka fata 'ilo'oo, “Filip, nau ku to'oru fe'enia mooru 'e aburu no'o, ma 'i'oo 'ame su'a 'ua agu lo'oo? Ma ni dai na ngaia 'e agasi nau, ngaia 'e agasia no'o nga Mama'a agu la'u mola. Ma fe'ua na 'i'oo orisia 'aku faate'enia la'u nga Mama'a agu, welakau? ");
INSERT INTO kwd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Ilo'oo ma 'i'oo 'ame tagoto'o mola na nau ku lado fe'enia nga Mama'a, ma nga Mama'a 'e lado la'u mola fe'eni nau? Alafuunga lo'oo nau ku iiria famooru, nga alafuunga agu 'i talagu 'amoe. Nga Mama'a na ngaia 'e nana'i fe'eni nau, ngaia ne'e agea nga taunga'inga aana 'ani nau. ");
INSERT INTO kwd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Moru tagoto'o na 'ola lo'oo, nau ku lado fe'enia nga Mama'a, ma nga Mama'a ka lado fe'eni nau. Lauta mooru 'ame tagoto'o na nga alafuunga agu, moru tagoto'o na 'ola lo'oo suria nga taunga'inga na nau ku agea. ");
INSERT INTO kwd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nga 'ola kwala'imori nau ku iiria te'amooru, ni dai ne'e tagoto'o agu, ngaia te'e agea la'u mola nga taunga'inga lo'oo nau ku agea. Ma ngaia te'e agea la'u mola nga taunga'inga ba'ita riufi nau, suria nau ku ori no'o te'ana nga Mama'a agu. ");
INSERT INTO kwd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma te'efuta 'olataa na moru soea na latagu, nau taku agea, fana nga alata na nga ta'a 'agila agasia, ma gila ka aga su'ana Mama'a ne'e ba'ita 'e iiki. ");
INSERT INTO kwd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ngaia 'e to'o, te'efuta 'olataa na moru soea na nga latagu, nau taku agea famooru.” ");
INSERT INTO kwd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","La Jisas ka alafuu la'u maka 'ilo'oo, “Lauta moru kwaimaa fagu, tamoru lo'o suria nga tagi agu. ");
INSERT INTO kwd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nau taku soea nga Mama'a, ma ngaia te'e kwatea mai nga Wane ni Kwaibooninga famooru, ma ngaia te'e nana'i fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngaia nga Anoe 'ola Abu ne'e faate'enia nga kwala'imoringa te'efou. Ma nga ta'a na fanua lo'oo 'i wado, gila 'ame kwaloa suria gila 'ame agasia, ma gila 'ame su'a mola ana. Tafe'ua mai mooru moru su'a no'o ana, tofuna ngaia 'e nana'i fe'eni 'amooru, ma ngaia te'e nana'i furifuri 'ubulana manata lamooru. ");
INSERT INTO kwd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Alata nau 'aku leka, 'ato no'o 'aku 'akwasi 'amooru 'ilaka'u nga wela si'ofa. Nau taku ori la'u mola mai te'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Te'e alata sisika mola, nga ta'a na fanua lo'oo 'i wado, gila sia agasi nau mola. Tafe'ua mai mooru lo'oo, tamoru agasi nau la'u mola. Ma tofuna nau ku momoori, tamoru moori la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sui ma tamoru su'aai na nau ku lado no'o fe'enia Mama'a agu, ma mooru tamoru lado fe'eni nau, mai nau kua lado fe'enia mooru. ");
INSERT INTO kwd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ma ni dai ne'e lo'o suria nga tagi agu, ngaia no'o nga wane na ngaia 'e kwaimaa fagu. Ma ni dai ne'e kwaimaa fagu, Mama'a agu te'e kwaimaa la'u mola fana, ma 'inau taku kwaimaa la'u mola fana, mai nau taku faate'eni nau 'i talagu fana.” ");
INSERT INTO kwd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","La Judas ('amoe la Judas Iskariot) 'e orisia maka 'ilo'oo, “Alafa, 'utaa na te'i meeru tamiri agasi'o, ma nga ta'a na fanua lo'oo 'i wado gila sia agasi'o mola?” ");
INSERT INTO kwd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","La Jisas 'e lamadu'aa maka 'ilo'oo, “Lauta te'efuta wane ne'e kwaimaa fagu, ngaia 'ani lo'o suria nga kwaifa'ananaunga agu. Ma nga Mama'a agu te'e kwaimaa fana, ma mee'e tamele leka mai te'ana, ma tamele nana'i fe'enia. ");
INSERT INTO kwd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma ni dai na ngaia 'ame kwaimaa fagu, ngaia 'e sia lo'o mola suria nga kwaifa'ananaunga agu. Ma nga kwaifa'ananaunga agu lo'oo moru longoa, ngaia nga 'ola agu 'i talagu 'amoe. Tofuna ngaia 'e 'ita mai fa'asia nga Mama'a na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nau ku iiria nga 'ola lo'oo famooru na alata nau ku to'oru 'ua fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nga Mama'a agu te'e kwatea mai nga Anoe 'ola Abu 'ania latagu fana ngaia 'ani booni 'amooru. Ngaia te'e fa'ananaua mooru 'ania nga 'ola te'efou, ma ngaia te'e booni 'amooru 'amoru manata to'ona ni 'ola te'efou na nau ku kwairii ai te'amooru 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nau ku 'akwasia no'o aloalonga agu famooru. Nga aloalonga agu na nau ku kwatea famooru, ngaia 'ame 'ilaka'u nga aloalonga fofona nga fanua lo'oo 'i wado. Ngai lo'oo, moru sia manata gelo, ma moru sia ma'u. ");
INSERT INTO kwd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mooru moru longoa te'efou no'o nga fatalagu laka'u 'e 'ilo'oo, ‘Nau taku leka, mai nau taku ori la'u mola mai te'amooru.’ Lauta moru kwaimaa fagu, moru aile'a suria nau ku leka te'ana Mama'a, suria ngaia 'e ba'ita maka iiki riufi nau. ");
INSERT INTO kwd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nau ku iiria no'o 'ola lo'oo 'ina'o nau ku leka fana 'amoru bi'i tagoto'o alata ni 'ola lo'oo 'ani lau ai. ");
INSERT INTO kwd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nau ku sia alafuu aburu la'u fe'eni 'amooru, suria la Saetan nga wane ba'ita na fanua lo'oo 'i wado, ngaia 'e gagalangi ka nigi no'o mai. Tafe'ua ma ngaia 'e sia ba'ita mola fafi nau. ");
INSERT INTO kwd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma 'inau 'i talagu, nau taku agea suria 'olataa na Mama'a agu ngaia 'e iiria fagu fana agelai, fana nga ta'a na fanua lo'oo 'i wado, 'agila su'aai nau ku kwaimaa fana Mama'a agu. Aia, goru leka no'o fa'asia lefu lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","La Jisas 'e alafuu 'ilo'oo la'u fana nga fufu'iwane aana, ‘Nau no'o na to'ofungana 'ai kwala'imori na latana grep, ma nga Mama'a agu na wane ne'e aga suria nga langa'a. ");
INSERT INTO kwd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma ngaia 'e su'asuria 'ani tofua nga lalana 'ai lo'oo gila 'ame to'o na lodona 'ola, ma ka tarifasua nga lalana 'ai na gila to'o na lodona 'ola, fana 'agila fungu le'a. ");
INSERT INTO kwd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma God 'e iiria mooru moru kwari te'efou no'o tofuna mooru tagoto'o na nga kwaifa'ananaunga agu famooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Moru lado agu 'aku lado fe'eni 'amooru. Nga lalana 'ai ngaia 'e 'ato 'ani to'o na lodona 'ola 'i talana, lauta ngaia 'ame fasu na nga to'ofungana 'ai. Ma ka 'ilo'oo la'u mola famooru, ngaia 'e 'ato amoru to'o na lodona 'ola lo'oo, lauta moru 'ame fasu agu. ");
INSERT INTO kwd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nau no'o na to'ofungana 'ai, ma 'amooru no'o na lalana 'ai. Ma lauta ni dai ne'e fasu agu, mai nau ku fasu ana, ngaia 'e su'asuria 'ani fungu 'ania lodona 'ola 'e aula. Ma lauta moru 'ame fasu agu, ngaia 'e 'ato 'amooru agea te'efuta 'ola 'e le'a. ");
INSERT INTO kwd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma ni dai na ngaia 'ame lado agu, ngaia 'e 'ilaka'u nga lalana 'ai na gila tofua ma gila to'osia. Ma nga lalana 'ai 'ilo'oo, tagila ngaria, ma gila ka to'osia 'ubulana nga eele 'ani nulafia no'o. ");
INSERT INTO kwd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma lauta moru fasu agu, ma nga fatalagu ka nana'i fe'eni amooru, moru soea te'efuta 'ola na moru siria, ma God te'e kwatea famooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta'a na gila fufu'iwane agu kwala'imori, gila fungu 'ania lodona 'ola 'e aula. Ma 'ino'ona, gila faate'enia nga kwangakwanganga na Mama'a agu. ");
INSERT INTO kwd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nau ku kwaimaa famooru 'ilaka'u la'u mola Mama'a agu 'e kwaimaa fagu. Ngaia na'a, moru fasu agu fana 'amoru nana'i 'ubulana kwaimaanga agu. ");
INSERT INTO kwd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma lauta moru lo'o suria nga tagi agu, tamoru nana'i 'ubulana nga kwaimaanga agu, 'ilaka'u la'u mola na 'inau ku lo'o suria nga tagi na Mama'a agu, ma 'inau ku nana'i la'u mola 'ubulana nga kwaimaanga aana. ");
INSERT INTO kwd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nau ku iiria 'ola lo'oo famooru fana 'amooru to'o na aile'anga, 'ilaka'u na 'inau ku aile'a. Kiu, ma aile'anga 'amooru te'e kwala'imori maka ba'ita. ");
INSERT INTO kwd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma nga tagi agu famooru, ngaia 'e 'ilo'oo: Moru kwaimaa famooru kwairiu, 'ilaka'u na 'inau ku kwaimaa famooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Te'efuta kwaimaanga 'ame riufia nga kwaimaanga na wane ne'e kwatea nga mooringa aana fana wane ni kwaimaanga aana, fana 'ani fa'amooria. ");
INSERT INTO kwd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma mooru lo'oo na ta'a ni kwaimaa agu, lauta moru lo'o suri nau. ");
INSERT INTO kwd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mai nau ku 'ame fa'alata mooru 'ania nga wane ni taunga'inga, suria nga wane ni taunga'inga ngaia 'ame su'a na 'ola na nga wane ba'ita aana 'e agea. Nau ku fa'alata mooru 'ania nga wane ni kwaimaanga agu, suria nau ku kwairii te'amooru no'o na ni 'ola te'efou na nau ku longoa mai fa'asia nga Mama'a agu. ");
INSERT INTO kwd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Moru 'ame firi nau, 'inau lo'oo na nau ku firi 'amooru, fana 'amooru fungu 'ania lodona 'ola 'e nana'i firi. Sui ma nga Mama'a te'e kwatea nga 'olataa na moru kwaisoe fai 'ania latagu. ");
INSERT INTO kwd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma nga tagi agu famooru 'e 'ilo'oo: Moru kwaimaa famooru kwairiu. ");
INSERT INTO kwd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Lauta nga ta'a fofona fanua lo'oo 'i wado gila aga mani 'amooru, moru manata to'ona na gila aga mani no'o agu la'u mola 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lauta mooru ta'a 'e ria 'ilaka'u ta'a fofona nga fanua lo'oo 'i wado, tagila kwaimaa famooru, tofuna moru 'ilaka'u la'u mola 'i gila. Tafe'ua mai nau ku firi 'amooru te'efou no'o, fana 'amoru matari fa'asia ta'a 'e ria lo'oo fofona fanua lo'oo 'i wado. Moru 'ame nana'i mola 'ilaka'u 'i gila, ma ngaia ne'e agea gila 'ame siria mooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Moru manata to'ona 'olataa laka'u nau ku fata suria 'e sui no'o famooru, ‘Nga wane ni taunga'inga ngaia 'ame ba'ita riufia wane ba'ita ana.’ Ma tofuna na gila malamani agu, tagila malamani la'u mola amooru. Ma lauta tani wane aaga gila lo'o suria nga fatalagu, tagila lo'o la'u mola suria fata lamooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ma tagila malamani 'amooru, tofuna na amooru nga ta'a agu. Gila age 'ilo'oo tofuna gila 'ame su'asuria God na ngaia 'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma lauta nau ku 'ame leka mai fofona fanua lo'oo 'i wado, mai nau ku 'ame kwairii mola te'aga, ma gila sia aga su'a mola na rianga aga. Tafe'ua ma alata lo'oo, ngaia 'e 'ato no'o fana te'efuta wane 'ani iiria ngaia 'ame kuta, suria nau ku leka mai, mai nau ku iiria 'e sui no'o faga. ");
INSERT INTO kwd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma ni dai ne'e aga mani agu, ngaia 'e aga mani la'u mola na Mama'a agu. ");
INSERT INTO kwd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nau ku agea ni 'ola na te'efuta wane 'ame agea 'i na'o. Lauta gila 'ame agasia nau ku agea ni 'ola lo'oo, gila sia aga su'a mola na rianga aga. Tafe'ua ma gila agasia ni 'ola ni 'alefosilai agu, ma gwa'a 'ani 'ino'ona, gila ka aga mani mola agu fe'enia Mama'a agu la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ni 'ola lo'oo ngaia 'e nigi mai, fana nga Girigiringa Abu 'ani kwala'imori 'ilo'oo, ‘Gila 'ame aga mani agu la'u tofuna te'efuta 'ola.’ ");
INSERT INTO kwd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nau taku kwatea mai nga Anoe 'ola Abu fa'asia Mama'a agu. Ma ngaia te'e faate'enia nga 'ola kwala'imori famooru. Ngaia te'e booni 'amooru, ma te'e alafuu suri nau te'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma moru la'u mola tamoru alafuu suri nau, suria dauru goru nana'i oguogu 'ita no'o mai na alata nau ku etaa nga taunga'inga agu. ");
INSERT INTO kwd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","La Jisas ngaia 'e alafuu la'u maka 'ilo'oo, “Nau ku iiria nga 'ola lo'oo famooru, fana nga tagoto'onga amooru 'e sia fusi mola. ");
INSERT INTO kwd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gila tagila belo 'amooru fa'asia 'ubulana nga 'ifi ni fo'anga aaga. Ma ngaia te'e nigi na alata, lauta te'efuta wane 'e kwa'i 'amooru 'ani mae, ngaia te'e madafia iiria ngaia 'e agea nga 'ola God ngaia 'e siria. ");
INSERT INTO kwd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nga ta'a tagila agea ni 'ola lo'oori amooru tofuna gila 'ame su'a na Mama'a agu, ma gila 'ame su'a la'u mola agu. ");
INSERT INTO kwd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tafe'ua mai nau ku iiria no'o nga 'ola lo'oo famooru, fana nga alata gila eta fana agelana 'ola lo'oo amooru, mai mooru tamoru madafia no'o nga alafuunga laka'u nau ku fata suria te'amooru.” La Jisas 'e alafuu la'u 'ilo'oo, “Nau ku 'ame iiria mai ni 'ola lo'oo famooru 'i na'o, tofuna nau ku nana'i 'ua fe'eni 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tafe'ua na alata lo'oo, nau ku galangi 'aku ori no'o te'ana God ne'e alenau mai. Ma te'efuta wane amooru 'ame orisi nau 'ua suria 'i fai nau taku leka fai. ");
INSERT INTO kwd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na alata lo'oo, nga manata lamooru 'e kwaimanadai 'e iiki, suria nau ku iiria no'o 'ola lo'oo famooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tafe'ua mai nau ku iiria nga 'ola kwala'imori famooru, ngaia 'e le'a iiki famooru na nau ku leka fa'asi 'amooru 'ilo'oo. Suria lauta nau ku 'ame leka, nga Anoe 'ola Abu lo'oo 'e 'ato 'ani sifo mai fana nga kwaibooninga amooru. Tafe'ua ma alata nau ku leka, nau taku alea mai te'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma alata ngaia 'ani nigi mai, ngaia te'e faate'enia fana ta'a fofona fanua lo'oo 'i wado nga to'onga suria abulongaa 'ame le'a, ma suria nga odonga, ma suria nga kwa'ikwa'inga na God. ");
INSERT INTO kwd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gila manata kuta suria nga abulongaa 'ame le'a, tofuna gila 'ame tagoto'o agu. ");
INSERT INTO kwd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma gila manata kuta suria nga odonga, tofuna nau taku ori no'o te'ana nga Mama'a ma moru sia agasi nau mola. ");
INSERT INTO kwd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma manatalaga 'e kuta suria nga kwa'ikwa'inga na God, tofuna God ngaia 'e sufaa no'o la Saetan na ngaia 'e ba'ita fafia nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nau ku to'o na nga 'ola 'e aula 'e iiki fana iirilai famooru, tafe'ua ma moru 'ame to'omia no'o fana 'amoru gwalongo fai te'efou na alata lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tafe'ua ma nga alata nga Anoe 'ola Abu te'e nigi mai, ngaia te'e faate'enia nga kwala'imoringa, ma ngaia te'e fa'ananau 'amooru 'ania ni 'ola lo'oo te'efou. Ma ngaia 'e sia alafuu mola 'i talana, ngaia te'e alafuu suria nga 'ola na ngaia 'e longoa fa'asi nau. Ma ngaia te'e alafuu suria nga 'ola na te'e nigi mai. ");
INSERT INTO kwd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ngaia te'e fa'aba'ita nau, suria ngaia te'e ngaria nga alafuunga agu, ma te'e kwairii ai te'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma ni 'ola te'efou lo'oo na Mama'a agu, ngaia ni 'ola agu la'u mola. Ngaia na'a nau ku iiria na nga Anoe 'ola Abu te'e ngaria mai nga alafuunga agu ma ka kwairii ai te'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","La Jisas 'e alafuu la'u 'ilo'oo, “Na alata sisika, moru sia agasi nau mola. Ma nga alata sisika la'u mola, tamoru agasi nau la'u.” ");
INSERT INTO kwd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma tani wane na nga fufu'iwane aana gila ka orisiga kwairiu ma gila ka 'ilo'oo, “'Olataa lo'oo nga fa'aladamilana alafuunga lo'oo ngaia 'e iiria, ‘Na alata sisika moru sia agasi nau mola, ma nga alata sisika la'u mola, tamoru agasi nau la'u?’ Ma ngaia ka iiria la'u mola, ‘Moru sia agasi nau mola suria 'inau ku leka no'o te'ana nga Mama'a agu.’” ");
INSERT INTO kwd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma nga fufu'iwane aana gila ka orisiga kwairiu la'u mola 'ilo'oo, “'Ola taa na fa'aladamilana alafuunga lo'oo, ‘na alata sisika?’ Dauru goru bobolosia 'olataa lo'oo ngaia 'e alafuu suria.” ");
INSERT INTO kwd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ma la Jisas 'e su'aai na gila siria 'agila orisia, ma ngaia ka fata 'ilo'oo faga, “'Ilo'oo ma moru orisia mooru talamooru suria 'ola laka'u nau ku iiria, ‘Na alata sisika, moru sia agasi nau mola. Ma na alata sisika la'u mola, tamoru agasi nau la'u?’ ");
INSERT INTO kwd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Ola kwala'imori nau ku iiria famooru. Na alata lo'oori, tamoru kwaimanadai ma tamoru aani, ma ta'a 'e ria na fanua lo'oo 'i wado, tagila aile'a. Mooru tamoru kwaimanadai, ma burina tamoru aile'a la'u. ");
INSERT INTO kwd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mooru moru su'aai alata na noni ngaia 'e gagalani 'ani fa'afuta, ngaia 'e nonifii. Tafe'ua ma alata ngaia 'e fa'afuta nga wela 'e sui, ngaia te'e manata nabolosia no'o nga nonifiinga laka'u, tofuna ngaia 'e aile'a no'o suria nga wela ngaia 'e futa no'o. ");
INSERT INTO kwd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mooru moru 'ilo'oo la'u mola. Na alata lo'oo mola na mooru tamoru kwaimanadai. Tafe'ua mai nau taku agasi 'amooru la'u, ma tamoru aile'a ba'ita. Ma nga aile'anga lo'oo, te'efuta wane 'ame to'omia 'ani lafua no'o fa'asi 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na alata no'ona, moru sia orisi nau la'u suria te'efuta 'ola. Nga 'ola kwala'imori nau ku iiria famooru, lauta moru soea te'efuta 'ola te'ana nga Mama'a 'ania latagu, ngaia te'e kwatea famooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","'Ita 'ua mai leleka maka nigi tala'ina, moru 'ame soea 'ua te'efuta 'ola na Mama'a agu 'ania latagu. Ma alata lo'oo, mooru soea Mama'a agu, ma ngaia te'e kwatea famooru, fana 'amooru aile'a ba'ita.” ");
INSERT INTO kwd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","La Jisas 'e alafuu la'u 'ilo'oo, “Nau ku alafuu suria ni 'ola lo'oo famooru 'ania nga tarifulaa. Tafe'ua ma alata te'e nigi mai na nau ku sia alafuu la'u 'ania nga tarifulaa, tafe'ua mai nau taku alafuu folaa no'o suria Mama'a famooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na alata no'ona, moru tala mooru tamoru kwaisoe na God no'o 'ania latagu. Ma nau ku sia kwaisoe la'u fana te'efuta 'ola 'usi 'amooru. ");
INSERT INTO kwd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ngaia te'e 'ilo'oo no'o suria nga Mama'a 'i talana na ngaia 'e kwaimaa famooru, tofuna moru kwaimaa fagu, ma tofuna moru tagoto'o na ngaia no'o ne'e alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nau ku leka mai fa'asia nga Mama'a agu fana fanua lo'oo 'i wado. Ma alata lo'oo, nau ku leka no'o fa'asia nga fanua lo'oo 'i wado, mai nau ku ori no'o te'ana nga Mama'a agu.” ");
INSERT INTO kwd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sui ma fufu'iwane aana gila ka alafuu 'ilo'oo fana, “Nga alata lo'oo 'i'oo bi'i alafuu wataga no'o fameeru, suria 'i'oo 'ame alafuu no'o 'ania nga tarifulaa. ");
INSERT INTO kwd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Alata lo'oo, meeru bi'i su'aai na 'i'oo su'a na 'ola te'efou. Gwa'a te'efuta wane ngaia 'ame kwaiorisi amu, 'i'oo su'a mola na 'olataa na ngai 'ubulana manatalana. Ma ngaia lo'oo 'e kwatea ameeru ma meru bi'i tagoto'o na God ngaia 'e ale'o mai.” ");
INSERT INTO kwd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma la Jisas ka alafuu 'ilo'oo faga, “'Ilo'oo ma mooru moru tagoto'o kwala'imori no'o agu? ");
INSERT INTO kwd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nga alata te'e nigi mai ma tamoru tagala'i te'efou fa'asi nau. Ma tamoru 'akwa fana fanua 'amooru, suria 'ola lo'oo tagila agea agu. Tafe'ua ma 'inau ku sia nana'i mola 'i talagu, tofuna nga Mama'a ngaia te'e nana'i fe'eni nau. ");
INSERT INTO kwd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nau ku iiria nga 'ola lo'oo famooru, fana 'amoru to'oru na aloalonga 'ubulana moori lamooru, suria moru nana'i oguogu fe'eni nau. Alata mooru moru nana'i fofona fanua lo'oo 'i wado, tagila fa'anonifii 'amooru la'u mola. Ma moru sia ma'u mola, suria nau ku talariufia nga tegelangaa na nga fanua lo'oo 'i wado 'e sui no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Alata la Jisas ngaia 'e alafuu 'ilo'oo 'e sui, ngaia ka aga 'ala'a fani langi, ma ka alafuu 'ilo'oo, “Mama'a 'ae, ngaia 'e nigi no'o na alata fana 'i'oo 'ani faate'enia kwangakwanganga agu, nga Wela amu, fana 'aku faate'enia nga kwangakwanganga amu. ");
INSERT INTO kwd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tofuna 'i'oo kwatea no'o nga tegelangaa fagu fafia nga ta'a te'efou, fana 'inau 'aku boonia nga ta'a na 'i'oo kwatea fagu fana 'agila momoori firi. ");
INSERT INTO kwd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aia, ma nga mooringa firi lo'oo ngaia 'e 'ilo'oo: Ta'a gila su'a amu na 'i'oo nga God kwala'imori, ma gila ka su'a agu, la Jisas nga Kraes na 'i'oo alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nau ku faate'enia no'o kwangakwanganga amu fofona fanua lo'oo 'i wado suria nau ku fa'asuia no'o taunga'inga laka'u 'i'oo alenau mai fana agelai. ");
INSERT INTO kwd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mama'a, alata lo'oo, nau ku siria 'i'oo 'ani kwatea la'u tegelangaa ba'ita laka'u nau ku to'o ai na alata nau ku to'oru fe'eni'o mai na'o, 'i na'ona launge'enilana nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nau ku kwaifa'ananau suri'o fana nga ta'a lo'oo 'i'oo kwatea no'o mai fagu fofona fanua lo'oo 'i wado. Gila lo'oo na gila ta'a amu, ma 'i'oo kwatea no'o mai fagu, ma gila ka lo'o no'o suria nga fatalamu. ");
INSERT INTO kwd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma alata lo'oo, gila su'a no'o na ni 'ola lo'oo te'efou na nau ku to'o ai, 'i'oo kwatea fagu. ");
INSERT INTO kwd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nau ku iiria no'o faga nga alafuunga na 'i'oo kwatea fagu, ma gila ka tagoto'o no'o ai. Ma gila ka su'a kwala'imori no'o ai na nau ku leka mai fa'asi'o, ma gila ka tagoto'o no'o na 'i'oo alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ma 'inau ku fo'a faga. Nau ku 'ame fo'a la'u fana nga ta'a na fanua lo'oo 'i wado, mai nau ku fo'a mola fana nga ta'a lo'oo 'i'oo kwatea mai fagu, suria gila nga ta'a amu. ");
INSERT INTO kwd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nga ta'a agu te'efou, gila nga ta'a amu la'u mola. Ma ta'a amu lo'oo te'efou, gila nga ta'a agu la'u mola. Ma gila ka faate'enia no'o nga kwangakwanganga agu 'ania to'orunga aaga. ");
INSERT INTO kwd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nau ku sia nana'i aburu mola fofona fanua lo'oo 'i wado, mai nau taku ori mola kau te'amu. Tafe'ua ma gila tagila nana'i 'ua fofona fanua lo'oo 'i wado. Mama'a na 'i'oo Abu, abelo 'aniga 'ania nga tegelangaa laka'u 'i'oo kwatea fagu, fana 'agila arua no'o te'e manate'e 'ola momola, 'ilaka'u na daa'a te'e 'ola momola. ");
INSERT INTO kwd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Alata nau ku nana'i fe'eniga, nau ku abelo 'aniga 'ania nga tegelangaa laka'u 'i'oo kwatea fagu. Nau ku aga suriga, ma te'efuta wane aaga 'ame fusi no'o, te'e wane 'e ria laka'u nga Girigiringa Abu 'e iiria ngaia te'e fusi. ");
INSERT INTO kwd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nau taku leka kau te'amu, mai nau ku iiria nga 'ola lo'oo na alata nau ku nana'i 'ua fofona fanua lo'oo 'i wado, fana ta'a agu 'agila aile'a ba'ita 'ilaka'u na nau ku aile'a. ");
INSERT INTO kwd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma nau ku kwatea no'o nga fatalamu faga. Tafe'ua ma nga ta'a fofona fanua lo'oo 'i wado na gila nga ta'a amu 'amoe, gila aga mani aga, tofuna gila ta'a na fanua lo'oo 'i wado 'amoe, 'ilaka'u la'u 'inau 'amoe. ");
INSERT INTO kwd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nau ku 'ame kwaisoe amu fana 'i'oo 'ani ngariga fa'asia fanua lo'oo 'i wado, mai nau ku kwaisoe amu fana 'i'oo 'ani abelo 'aniga fa'asia la Saetan, nga wane 'e ria. ");
INSERT INTO kwd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gila ta'a fofona fanua lo'oo 'i wado 'amoe, 'ilaka'u la'u mola na 'inau nga wane fofona fanua lo'oo 'i wado 'amoe. ");
INSERT INTO kwd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nga fatalamu no'o 'e kwala'imori. To'o fa'aabuga famu 'ania nga kwala'imoringa. ");
INSERT INTO kwd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nau ku alega fana lekanga na fanua lo'oo 'i wado, 'ilaka'u la'u mola na 'i'oo alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma fana nga le'anga aaga, nau ku kwate nau 'i talagu famu, fana 'agila kwatega 'i talaga famu. ");
INSERT INTO kwd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nau ku 'ame fo'a faga te'i gila. Tafe'ua mai nau ku fo'a la'u mola fana nga ta'a na tagila tagoto'o agu tofuna nga alafuunga aaga. ");
INSERT INTO kwd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma nau ku fo'a fana 'agila arua te'e 'ola momola, 'ilaka'u la'u mola na nau ku lado amu ma 'i'oo lado agu. Mama'a, nau ku fo'a 'agila lado fe'eni 'adaa'a, fana nga ta'a fofona fanua lo'oo 'i wado 'agila tagoto'o ai na 'i'oo alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nau ku fa'aba'itaga 'ilaka'u la'u mola 'i'oo fa'aba'ita nau, fana 'agila arua te'e 'ola, 'ilaka'u la'u mola daa'a te'e 'ola momola. ");
INSERT INTO kwd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Fa'awatagalana 'ola lo'oo ngaia 'e 'ilo'oo: Nau ku lado no'o aaga, ma 'i'oo lado agu, fana gila te'e 'ola momola. Sui ma nga ta'a fofona fanua lo'oo 'i wado 'agila su'aai na 'i'oo alenau mai, ma 'i'oo kwaimaa faga, 'ilaka'u la'u mola na 'i'oo kwaimaa fagu. ");
INSERT INTO kwd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama'a, nau ku siria nga ta'a na 'i'oo kwatega fagu, 'agila nana'i fe'eni nau na lefu na nau ku nana'i ai, fana 'agila agasia no'o tegelangaa ba'ita agu na 'i'oo kwatea fagu. 'I'oo kwatea tegelangaa ba'ita lo'oo fagu, tofuna 'i'oo kwaimaa fagu 'i na'ona nga launge'enilana nga fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mama'a, 'i'oo wane 'i'oo odo. Nga ta'a 'e ria lo'oo fofona nga fanua lo'oo 'i wado gila 'ame su'a amu. Tafe'ua mai nau ku su'a mola amu, ma nga fufu'iwane agu, gila su'aai na 'i'oo alenau mai. ");
INSERT INTO kwd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nau ku kwairii te'aga no'o suri'o. Ma nau taku leleka fana kwairiinga, fana nga kwaimaanga amu fagu 'ani nana'i la'u mola 'ubulana moorilaga, mai nau ku lado fe'eniga.” ");
INSERT INTO kwd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Burina la Jisas ngaia 'e fo'a 'e sui mola, ngaia fe'enia nga fufu'iwane aana, gila leka kau, ma gila ka olofolo na wanawanaa gila fa'alataa 'ania 'i Kidron. Ma gila leka kau fana nga langa'a na 'ai 'i olif. ");
INSERT INTO kwd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma la Judas, nga wane na ngaia 'e 'olonge'enia la Jisas fana maarimae aana, ngaia 'e su'a no'o na nga lefu no'ona. Tofuna alata 'e aula la Jisas fe'enia nga fufu'iwane aana, gila leka na lefu no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ngaia na'a la Judas 'e talaia kau ta'a ni fununga fa'asia 'i Rom fe'enia nga ta'a na gila folo 'afuia nga 'Ifi Abu na God. Nga fataabu ba'ita, ma ni Farasii na gila alega kau. Aia, nga ta'a na gila leka mai, gila dau na nga uunu, ma nga 'aila'a fana fununga. ");
INSERT INTO kwd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma suria la Jisas ngaia 'e su'aai 'e sui no'o na 'ola lo'oo te'e lau ana, ngaia ka leka kau te'aga, ma ka orisiga maka 'ilo'oo, “Ni dai na moru kwailo 'ofia?” ");
INSERT INTO kwd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gila lamadu'aa ma gila 'ilo'oo, “Meeru meru kwailo 'ofia la Jisas, nga wane laka'u fa'asia 'i Nasaret.” Ma la Jisas ka fata 'ilo'oo, “Nau lo'oo no'o.” Aia, ma la Judas nga wane laka'u ngaia 'e talaiga kau te'ala Jisas, ngaia 'e ula la'u mola no'ona fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na alata la Jisas ngaia 'e alafuu 'ilo'oo, “Nau lo'oo no'o,” nga ta'a lo'oori gila 'idu fa'aburi, ma gila ka 'esiga no'o 'i wado. ");
INSERT INTO kwd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ma la Jisas ka orisiga la'u maka 'ilo'oo, “Ni dai na moru kwailo 'ofia?” Ma gila ka 'ilo'oo, “Meeru meru kwailo 'ofia la Jisas, nga wane laka'u fa'asia 'i Nasaret.” ");
INSERT INTO kwd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","La Jisas 'e fata 'ilo'oo faga, “Nau ku iiria 'e sui no'o famooru, ‘Nau lo'oo no'o.’ Lauta 'inau lo'oo na moru kwailo 'ofi nau mai lo'oo, moru alamia nga ta'a lo'oo 'agila leka mola.” ");
INSERT INTO kwd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","La Jisas 'e iiria 'ola lo'oori fana 'ani fa'ato'oa 'olataa na ngaia 'e iiria 'e sui no'o mai suriga 'ilo'oo, “Mama'a, te'efuta wane aaga 'ame funu no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma la Saemon Pita 'e to'o na te'e naifi fana fununga, ma ngaia 'e lafua ma ka tofu mousia aringa gula le'a na nga wane ni taunga'inga na alafa ni suuabunga. Nga wane ni taunga'inga lo'oori latana la Malakas. ");
INSERT INTO kwd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma la Jisas ka fata 'ilo'oo fala Pita, “'Oi orite'enia nga naifi ni fununga no'ona 'i furina! 'Ilo'oo ma 'i'oo madafia iiria nau ku sia ru'u mola 'ubulana alata na nonifiinga lo'oo Mama'a agu 'e kwatea fagu?” ");
INSERT INTO kwd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ma nga ta'a na fununga, ma nga wane ba'ita aaga, ma nga ta'a na gila folo 'afuia nga 'Ifi Abu na God, gila gemasia la Jisas, ma gila ka gaua rua nimana. ");
INSERT INTO kwd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma gila ka talaia no'o la Jisas te'ala Anas, suria ngaia na fungona la Kaeafas, nga alafa ni suuabunga na farisi no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ma la Kaeafas na ngaia 'e iiria mai na'o fana ta'a na'ona'o 'i Jiu, “Ma ngaia 'e le'a fana te'e wane 'ani mae, fana gila sia kwa'ia mola nga ta'a te'efou.” ");
INSERT INTO kwd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","La Saemon Pita fe'enia te'e wane ngaa'i na fufu'iwane ala Jisas, gala leka suria la Jisas. Ma nga ruana wane na alafa ni suuabunga lo'oori ngaia 'e su'a le'a ana. Ma nga ruana wane 'e leka burina la Jisas, leleka maka nana'i mai 'ubulana lalabata na 'ifi na alafa ni suuabunga. ");
INSERT INTO kwd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","La Pita ngaia 'e ula mola mai 'i maa. Ma nga ruana wane na fufu'iwane ana ngaia 'e ru'u kau 'i maa, ma ka alafuu fana geni na ngaia 'e folo 'afuia nga sinamaa, fana 'ani talaia mai la Pita 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na alata la Pita 'e ru'u mai, nga geni no'ona ka alafuu 'ilo'oo fana, “Nau ku madafia 'i'oo nga wane la'u mola na fufu'iwane na wane lo'oo gila ngaria mai ta'ua lo'oo.” La Pita 'e lamadu'aa maka fata 'ilo'oo, “Nau 'amoe!” ");
INSERT INTO kwd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tofuna alata no'ona alata na gwaringa, ta'a ni taunga'inga fe'enia nga ta'a ni folonga, gila ka ogua nga eele 'i lalo, ma gila ka ula 'afuia, ma la Pita ka ula la'u mola fe'eniga 'i no'ona, ma ka lalangia la'u mola. ");
INSERT INTO kwd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nga alafa ni suuabunga 'e orisia la Jisas suria fufu'iwane aana ma nga kwaifa'ananaunga aana. ");
INSERT INTO kwd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Nau ku alafuu folaa fana ta'a te'efou fana 'agila longoa. Nau ku 'ame na'agonia no'o te'efuta 'ola, alata nau ku fa'ananaua nga ta'a. Nau ku agea 'ola lo'oori gani mai gani 'ubulana 'ifi ni fo'anga ma 'i 'ubulana nga 'Ifi Abu na God lo'oo, fana alata ta'a gila ogu mai, ma gila longoa. Ma nau ku 'ame alafuu nagwa nagwa mola 'ania te'efuta 'ola. ");
INSERT INTO kwd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'Utaa na 'i'oo orisi nau 'ilo'oo? 'Oi orisia mola nga ta'a na gila longoa nga 'ola lo'oo nau ku iiria faga. Gila na gila su'a na nga 'ola na nau ku iiria faga.” ");
INSERT INTO kwd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Alata la Jisas 'e alafuu mola 'ilo'oo, te'e wane na ta'a ni folonga 'e leka mai, ma ka fidaria, ma ka alafuu 'ilo'oo, “Fe'ua na 'i'oo alafuu 'ilo'oo fana alafa ni suuabunga welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","La Jisas 'e lamadu'aa maka 'ilo'oo, “Lauta nau ku iiria te'efuta 'ola na ngaia 'e kuta, to'o kwairii na 'ola na 'inau ku kuta ai. Ma lauta nau ku 'ame iiria mola te'efuta 'ola 'e kuta, 'utaa na 'i'oo fidari nau, welakau?” ");
INSERT INTO kwd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Burina 'ola lo'oo, la Anas 'e kwatea no'o kau la Jisas te'ala Kaeafas, nga alafa ni suuabunga. Ma nga nimana gila gau 'ua fafia. ");
INSERT INTO kwd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma alata la Pita ngaia 'e ula, ma ka lalangia 'ua nga nonina, nga ta'a na gila ula 'i no'ona fe'enia, gila ka alafuu 'ilo'oo fana, “'I'oo wane na fufu'iwane na wane lo'oo.” Ma la Pita ngaia 'e gwalaa, ma ka fata 'ilo'oo, “'Amoe no'o, 'inau 'amoe.” ");
INSERT INTO kwd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma te'e wane ni taunga'inga na alafa ni suuabunga 'e nana'i la'u mola 'i no'ona. Ngaia nga wanefuta fe'enia nga wane ni taunga'inga laka'u la Pita ngaia 'e tofu mousia nga aringana, ma ngaia ka fata 'ilo'oo, “Nau ku madafia nau ku agasi'o fe'enia la Jisas alata laka'u gila gemasia 'ubulana langa'a laka'u.” ");
INSERT INTO kwd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma la Pita ka alafuu 'ilo'oo, “'Amoe! Nau 'amoe!” Na alata no'ona mola nga susuki ka aani no'o. ");
INSERT INTO kwd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma 'usu'usugani logologo'a mola, gila ka talaia kau la Jisas fa'asia 'ifi ala Kaeafas, ma gila talaia fana 'ubulana 'ifi ala Paelat, te'e wane ba'ita 'i Rom. Alata no'ona, ta'a na'ona'o 'i Jiu gila ula la'u mola kau 'i maa, suria lauta gila ru'u 'ubulana 'ifi na wane na ngaia 'ame Jiu, nga tagi aaga 'e iiria tagila sua no'o 'i na'ona God. Na alata no'ona, gila siria 'agila nana'i kwari fana 'agila 'ania nga Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma la Paelat 'e ru'u kau te'aga 'i maa, ma ka orisia 'ilo'oo, “'Utaa na moru talaia wane lo'oo fana sufalana?” ");
INSERT INTO kwd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gila lamadu'aa ma gila alafuu 'ilo'oo, “Lauta wane lo'oo ngaia 'ame agea 'ola 'e ria, 'ato 'ameru talaia mai te'amu.” ");
INSERT INTO kwd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","La Paelat ka fata 'ilo'oo faga, “Lauta ngaia 'e 'ino'ona, moru talaia kau, ma moru ka sufaa suria nga 'olataa na tagi 'amooru 'e iiria.” Gila ka alafuu 'ilo'oo, “Nga tagi 'amooru 'i Rom na meru to'oru olofai, ngaia 'e ruia meru sia kwa'ia mola te'efuta wane.” ");
INSERT INTO kwd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ngaia 'e lau 'ilo'oo, fana 'ani fa'ato'oa 'olataa laka'u la Jisas ngaia 'e iiria suria nga maenga aana. Tofuna nga ta'a fa'asia 'i Rom, gila kwa'ia ta'a na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","La Paelat ka ori la'u fana 'ubulana nga 'ifi aana, ma ka soea mai la Jisas te'ana, ma ka orisia la'u maka 'ilo'oo, “'Ilo'oo ma 'i'oo na nga kiingi na ta'a 'i Jiu?” ");
INSERT INTO kwd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma la Jisas 'e orisia kau maka 'ilo'oo, “'Ilo'oo ma nga kwaiorisinga lo'oo ngaia 'e leka mai fa'asi'o talamu, 'amoe ma tani wane ngaa'i gila na gila kwairii te'amu suri nau?” ");
INSERT INTO kwd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma la Paelat 'e alafuu la'u maka 'ilo'oo, “Nau nga wane 'i Jiu 'amoe lo'oo! Nga ta'a amu ma nga fataabu ba'ita na gila talai'o mai lo'oo te'agu. Nga 'olataa 'e ria lo'oo 'i'oo agea?” ");
INSERT INTO kwd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “Nau ku 'ame 'ilaka'u nga kiingi fofona fanua lo'oo 'i wado. Ma lauta nau ku 'ilaka'u 'i gila, nga ta'a agu tagila funu mola 'usi nau fa'asia nga kwatelagu fana nga ta'a na'ona'o 'i Jiu lo'oo. 'Amoe. Nga fanua nau ku kiingi fai, ngaia 'e matari.” ");
INSERT INTO kwd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma la Paelat 'e orisia maka 'ilo'oo, “'Ilo'oo ma 'i'oo nga kiingi lo'oo?” Ma la Jisas 'e lamadu'aa maka 'ilo'oo, “'I'oo na 'i'oo iiria nau nga kiingi. Nau ku futa, mai nau ku nigi mai fofona fanua lo'oo 'i wado fana 'aku alafuu mola suria nga 'ola kwala'imori. Ma ni dai ne'e siria nga 'ola kwala'imori, ngaia 'ani lo'o suri nau.” ");
INSERT INTO kwd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma la Paelat 'e orisia la'u maka 'ilo'oo, “'Ilo'oo ma nga 'olataa lo'oo kwala'imoringa welakau?” Ma la Paelat ka ori la'u 'i maa te'ana ta'a, ma ka fata 'ilo'oo faga, “Nau ku 'ame to'odaria mola te'efuta rianga na nga wane lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tafe'ua ma suria nga falafala amooru, nau taku rubea te'e wane famooru na alata na Fafangalaa na Tala Riunga. 'Ilo'oo ma mooru moru siria 'aku rubea nga kiingi 'i Jiu lo'oo famooru?” ");
INSERT INTO kwd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma gila ka o'omae ma gila fata 'ilo'oo, “'Amoe! Nga wane lo'oo 'i'oo sia rubea la'u! Meeru meru siria 'i'oo 'ani rubea mai la Barabas!” Aia, ma la Barabas ngaia nga wane laka'u 'e eta nga ngada'olanga. ");
INSERT INTO kwd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ngai lo'oo la Paelat 'e kwatea no'o la Jisas fana nga ta'a ni fununga lo'oo, ma ka iiria 'agila labusia. ");
INSERT INTO kwd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma gila ka 'elea nga 'elegou 'ania nga kwalo ngangala'a, ma gila ka arua 'i gouna la Jisas. Sui ma gila ka fa'aruufia 'ania nga ruu mekumeku, 'ilaka'u nga kiingi. ");
INSERT INTO kwd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sui ma gila ka leka mai te'ana, ma gila ka 'ilo'oo, “'I'oo na nga kiingi na ta'a lo'oo 'i Jiu!” Ma gila ka fidaria. ");
INSERT INTO kwd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma la Paelat ka ru'u la'u kau te'ana ta'a lo'oo na gila ogu no'ona, maka fata 'ilo'oo, “Nau taku ngaria mai nga wane lo'oo te'amooru, fana 'amoru su'asuria na nau ku 'ame agasia mola te'efuta rianga ana.” ");
INSERT INTO kwd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sui ma la Jisas ka ru'u mai 'i maa, ma ka ru'ufia nga 'elegou na kwalo ngangala'a, ma nga ruu mekumeku. Ma la Paelat ka fata 'ilo'oo faga, “Moru agasia madi nga wane lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma na alata fataabu ba'ita, ma nga ta'a na gila folo 'afuia nga 'Ifi Abu na God gila agasia, gila bi'i o'omae ba'ita la'u, ma gila ka 'ilo'oo, “Mudu'ia na 'ai folo! Mudu'ia na 'ai folo!” La Paelat 'e alafuu 'ilo'oo, “Lauta 'ino'ona, moru ngaria ma moru ka mudu'ia na 'ai folo. Suria nau ku 'ame to'odaria mola te'efuta rianga ana.” ");
INSERT INTO kwd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nga ta'a gila ka fata 'ilo'oo fala Paelat, “Meeru meru to'o na nga tagi fana wane 'ilo'oo ngaia 'ani mae, tofuna ngaia 'e iiria ngaia nga Wela na God.” ");
INSERT INTO kwd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Alata la Paelat ngaia 'e longoa 'ola lo'oo, ngaia 'e ma'u ba'ita ma ka riufia no'o 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma ngaia ka ori la'u 'i 'ifi maka orisia la Jisas maka 'ilo'oo, “'I'oo wane fa'asia 'i fai lo'oo, welakau?” Ma la Jisas ngaia 'ame iiria mola te'efuta 'ola. ");
INSERT INTO kwd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","La Paelat ka alafuu la'u 'ilo'oo fana, “'Ilo'oo ma 'i'oo 'ame siria no'o alafuunga fe'eni nau? 'I'oo 'ame su'a mola ai na nau ku to'o na nga tegelangaa fana iirilana 'ola fana 'agila rube'o, 'amoe ma 'agila mudu'i'o na 'ai folo?” ");
INSERT INTO kwd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","La Jisas 'e lamadu'aa maka fata 'ilo'oo, “Ngaia 'e kwala'imori 'i'oo to'o na tegelangaa fana 'i'oo 'ani agea 'olo'oo agu. Tafe'ua ma te'e God momola na ngaia 'e kwatea nga tegelangaa lo'oori famu. Ngaia lo'oo nga wane na ngaia 'e kwate nau famu, ngaia 'e agea nga 'ola lo'oo 'e ria 'e iiki maka riufia nga 'ola 'i'oo agea.” ");
INSERT INTO kwd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na alata la Paelat ngaia 'e longoa fatalana la Jisas, ngaia 'e kwailo mola fana te'efuta tafa na ngaia 'ani agea fana 'ani rubea. Tafe'ua ma nga Jiu, gila o'omae ba'ita ma gila ka 'ilo'oo, “Lauta 'i'oo rubea wane no'ona, 'i'oo wane ni kwaimaanga na nga kiingi 'i Rom 'amoe. Du'ana lauta te'efuta wane 'e iiria ngaia nga kiingi, ngaia 'e ula no'o 'usia nga kiingi 'i Rom.” ");
INSERT INTO kwd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Alata la Paelat ngaia 'e longoa nga alafuunga lo'oori sui, ngaia 'e talaia kau la Jisas 'i maa, maka to'oru mola na lefu fana kwaisufaingaa 'i 'ubulana nga tofi 'ifi na gila fa'alataa 'ania ‘Fulou na Fou’ ma nga alafuunga 'i Jiu gila iiria ‘Gabata.’ ");
INSERT INTO kwd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma alata no'ona, nga gani fana sasaringa fana Fafangalaa na Tala Riunga, ma ngaia 'e galangi dalototo'o no'o na gani no'ona. Ma la Paelat ka alafuu 'ilo'oo fana nga ta'a no'ona, “Moru agasia madi nga kiingi amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma nga ta'a no'ona gila o'omae ma gila ka 'ilo'oo, “Kwa'ia! Kwa'ia! Mudu'ia na 'ai folo!” La Paelat 'e orisiga la'u maka 'ilo'oo, “'Ilo'oo mai moru siria 'aku mudu'ia nga kiingi amooru na 'ai folo?” Na alata no'ona, nga fataabu ba'ita 'e lamadu'aa ma ka 'ilo'oo, “Ngaia nga kiingi ameeru 'amoe! Te'e kiingi na ngaia 'i Rom ne'e ba'ita fameeru!” ");
INSERT INTO kwd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma la Paelat ka kwatea la Jisas fana nga ta'a ni fununga no'ona fana 'agila mudu'ia na 'ai folo. Ma gila ka talaia no'o kau la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma ngaia ka ngaria nga 'ai folo aana 'i talana fana nga lefu na gila fa'alataa 'ania 'i ‘Golgota’ na alafuunga na ta'a 'i Jiu. (Nga fa'awatagalana lata lo'oori na ‘Nga gouna ta'a.’) ");
INSERT INTO kwd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sui ma gila ka mudu'ia no'o la Jisas na 'ai folo. Ma nga rua wane ngaa'i la'u mola na gila mudu'ia 'agaa'a no'ona, te'e wane ngaa'i gula moori ma te'e wane ngaa'i gula le'a, ma gila ka mudu'ia la Jisas na 'ai folo ne'e ula 'i laloagaa'a. ");
INSERT INTO kwd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma la Paelat ka giria nga alafuunga, ma gila ka arua 'i gouna 'ai folo ala Jisas. Nga alafuunga no'ona ngaia 'e giria 'e 'ilo'oo, “La Jisas fa'asia 'i Nasaret, nga kiingi 'i Jiu.” ");
INSERT INTO kwd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lefu lo'oo gila arua nga 'ai folo lo'oo gila mudu'ia la Jisas ai, ngaia 'ame to'oru lalau mola fa'asia 'i Jerusalem. Ma nga ta'a 'e aula lo'oo gila idumia alafuunga lo'oo. Ma nga alafuunga lo'oo gila ka giria la'u mola 'ania oru alafuunga kwaitatari. Alafuunga ngaa'i na ta'a 'i Jiu, alafuunga ngaa'i na ta'a 'i Rom ma nga alafuunga ngaa'i na ta'a na Grik. ");
INSERT INTO kwd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma nga fataabu ba'ita lo'oo, gila ka alafuu 'ilo'oo fala Paelat, “'I'oo sia giria la'u nga ‘Kiingi 'i Jiu.’ Tafe'ua ma to'o giria mola 'ilo'oo, Ngaia 'i talana na ngaia 'e alafuu 'ilo'oo, ‘'inau nga kiingi 'i Jiu.’” ");
INSERT INTO kwd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sui ma la Paelat ka lamadu'aga maka fata 'ilo'oo, “'Ola taa lo'oo nau ku giria 'e sui no'o, ngaia 'e to'oru no'o 'i 'ilo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma 'i burina nga ta'a ni fununga lo'oo gila mudu'ia la Jisas na 'ai folo 'e sui, gila ka ngaria nga ruu aana, ma gila ka dalo'ia 'ania nga fai gule 'ola fana nga fai wane no'ona. Ma nga sote ba'ita lo'oo aana, te'efuta ladonga 'amoe na tailai. ");
INSERT INTO kwd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma nga ta'a ni fununga no'ona gila ka alafuu 'ilo'oo faga kwairiu, “Goru sia gaasi ngadaa mola nga ruu lo'oo. Goru masa 'ania daisi fai, dai ne'e riufia, ngaia na te'e ngaria.” Ngaia 'e 'ilo'oo fana 'ani fa'ato'oa nga Girigiringa Abu laka'u 'e fata 'ilo'oo, “Gila dalo'ia nga ruu agu faga, ma gila ka masa 'ania daisi fana sote ba'ita agu.” Nga 'ola lo'oo nga ta'a ni fununga lo'oo na gila agea. ");
INSERT INTO kwd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nga tete'e ala Jisas, ma ni noni futa fe'enia tete'e ala Jisas, ma ni Meri noni ala Klopas, ma ni Meri noni fa'asia 'i Magdala lo'oo gila ula 'i 'a'aena nga 'ai folo ala Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma nga wane na fufu'iwane na la Jisas ngaia 'e kwaimaa fana, ngaia 'e ula la'u mola 'i no'ona fe'enia tete'e ala Jisas. Alata la Jisas ngaia 'e agasia tete'e aana fe'enia nga wane lo'oo ngaia 'e kwaimaa fana gila ula galangia, ma ngaia ka fata 'ilo'oo fana tete'e aana, “Tete'e, nga wela amu no'ona no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sui ma, ngaia ka fata 'ilo'oo la'u fana nga wane na fufu'iwane no'ona, “Nga tete'e amu no'ona no'o.” Ma eta na alata no'ona, nga wane lo'oori ka kwaloa no'o tete'e ala Jisas fani 'ifi aana fana 'ani abelo 'ania. ");
INSERT INTO kwd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'I burina nga 'ola lo'oo 'e sui, la Jisas 'e su'aai na nga taunga'inga aana ngaia 'e sui no'o. Ma ngaia ka fata 'ilo'oo, “Nau ku maarigo'u.” Ngaia 'e fata 'ilo'oo 'ani fa'ato'oa nga alafuunga 'ubulana Girigiringa Abu. ");
INSERT INTO kwd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma nga lefu no'ona, gila arua te'e teu ne'e fongu no'o na nga waeni 'e ukwala. Ma gila ngaria nga ruu fana ogulana ka'o, ma gila ka fa'awasiua 'ubulana teu na waeni no'ona, sui ma gila ka arua 'i maana nga ma'e 'ai na gila fa'alataa 'ania hisap sui ma gila ka kwatea fani maana ngiduna la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na alata la Jisas ngaia 'e go'ufia 'e sui, ma ngaia 'e alafuu 'ilo'oo, “Ngaia 'e sui no'o.” Burina ngaia 'e iiria alafuunga lo'oori 'e sui mola, nga gouna ka kwa'itori no'o, ma ngaia ka mae no'o. ");
INSERT INTO kwd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma 'i burina 'ola lo'oo 'e sui, ta'a na'ona'o 'i Jiu gila leka mai, ma gila ka orisia la Paelat fana 'ani alamia fana ta'a ni fununga 'agila leka, ma gila 'oia nga 'a'aena nga oru wane na gila mudu'iga na 'ai folo, fana 'agila mae 'aferu. Tofuna gila siria 'agila lafua no'o noniga fa'asia nga 'ai folo na fe'e gani lo'oori. Suria ma'e gani lo'oo ngaia gani fana sasaringa na Jiu maamania Sabat. Ma gila 'ame siria nga wane mae 'agila nana'i na 'ai folo na Sabat. Tofuna Sabat lo'oori ngaia nga gani ba'ita 'i Jiu suria ngaia Fafangalaa na Tala Riunga. ");
INSERT INTO kwd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma nga ta'a ni fununga lo'oo gila leka mai, ma gila ka 'oia 'a'aena rua wane laka'u gila mudu'iga na 'ai folo. ");
INSERT INTO kwd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tafe'ua ma alata gila nigi te'ala Jisas, gila agasia ngaia 'e mae 'e sui no'o. Ngaia lo'oo, gila 'ame 'oia no'o nga 'a'aena. ");
INSERT INTO kwd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tafe'ua ma te'e wane aaga na ngaia 'e siria 'ani fa'ato'o le'a ai, ngaia 'e ngaria nga ma'e 'aila'a, ma ka lada'ia 'ania kalaona la Jisas. Ma gila ka agasia no'o 'abu ma nga ka'o 'e afe mai ai. ");
INSERT INTO kwd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nau ku agasia 'ola lo'oori, mai nau ku alafuu suria, famooru te'efou 'amooru tagoto'o la'u mola. Nga 'ola lo'oo nau ku iiria ngaia 'e kwala'imori. ");
INSERT INTO kwd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma 'ola lo'oori 'e 'ilo'oo, fana 'ani fa'ato'oa Girigiringa Abu laka'u ngaia 'e alafuu 'ilo'oo, “Te'efuta suri na labena ngaia 'ame mo'oi mola” ");
INSERT INTO kwd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma te'e gule'e Girigiringa Abu ngaa'i ngaia 'e 'ilo'oo, “Nga ta'a tagila bubunia nga wane na gila lada'ia nga kalaona.” ");
INSERT INTO kwd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma 'i burina ni 'ola lo'oori, la Josef nga wane fa'asia 'i Arimetea, ngaia 'e leka mai maka soea la Paelat fana nonina la Jisas, fana 'agila ngaria. La Josef laka'u, ngaia nga wane na fufu'iwane ala Jisas la'u mola, tafe'ua ma ngaia 'e nagwa mola, tofuna ngaia 'e ma'unge'enia nga ta'a na'ona'o 'i Jiu lo'oo. Ma la Paelat 'e alamia, ma ngaia ka leka mai maka ngaria no'o. ");
INSERT INTO kwd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma la Nikodimas na ngaia 'e leka mai te'ala Jisas 'ubulana logo 'i na'o laka'u, ngaia 'e leka fe'enia la Josef, ma ka ngaria oru akwale'e kilo na 'ola 'e si'ini le'a lo'oo fana arulai fe'enia nonina wane 'e mae. Gila fa'alata nga 'ola lo'oo 'ania mira ma alos. ");
INSERT INTO kwd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Rua wane lo'oo, gaa'a gala ngaria nonina la Jisas, ma gala ka gaua 'ania nga ruu kwakwao'a le'a lo'oo fe'enia nga 'ola si'inilai 'e le'a lo'oori. Gila agea 'ola lo'oo suria falafala 'i Jiu fana agelai na wane 'e mae 'i na'o sui ma gila bi'i arua 'ubulana giru gwa'u. ");
INSERT INTO kwd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma te'e langa'a ngaia 'e nana'i mola galangia lefu na gila kwa'ia la Jisas ai. Ma te'e giru gwa'u fana arulana nonina ta'a 'e mae ngai la'u mola na nga lefu no'ona. Ma nga giru gwa'u no'ona nga 'ola fooru mola, gila 'ame arua 'ua te'efuta wane 'e mae 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma nga alata no'ona fe'e gani aaga 'i Jiu fana sasaringa fana nga Sabat. Ma nga Sabat ngaia gagalangi no'o. Ngaia na'a nga rua wane lo'oori gala leka ma gala ka arua no'o labena la Jisas 'i 'ubulana giru gwa'u no'ona, suria ngaia 'e to'oru galangia lefu no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Usugani na nga Sande alata 'e logologo'a mola 'ua, ni Meri fa'asia 'i Magdala 'e leka 'i maa na giru gwa'u laka'u, ma ka agasia nga fou laka'u gila bokota 'ania nga maana giru gwa'u, ngaia 'e 'idu no'o. ");
INSERT INTO kwd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma ngaia ka totola 'aferu te'ala Saemon Pita ma nga wane na fufu'iwane na la Jisas ngaia 'e kwaimaa fana, ma ka alafuu 'ilo'oo fagaa'a, “Tani ta'a ngaa'i gila ngaria no'o nga nonina nga Alafa fa'asia nga giru gwa'u laka'u, ma meru bobolosia no'o 'i fai na gila arua ai.” ");
INSERT INTO kwd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ma la Pita ma nga wane ngaa'i gala ka leka no'o fana nga giru gwa'u no'ona. ");
INSERT INTO kwd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma gala ka totola te'efou, ma nga wane ngaa'i ngaia 'e totola 'aferu maka riufia la Pita, maka nigi 'i maana giru gwa'u laka'u 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ma ngaia 'e gogonu kau, ma ka agasia nga ruu kwakwao'a, ma ngaia 'ame ru'u mola 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma la Saemon Pita 'e nigi mai 'i buri, ma ka ru'u no'o 'ubulana nga giru gwa'u no'ona. Ngaia 'e agasia nga ruu kwakwao'a ngaia 'e to'oru mola 'i no'ona ");
INSERT INTO kwd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fe'enia nga ruu laka'u gila gaua 'ania gouna la Jisas. Nga ruu no'ona ngaia 'ame nana'i mola fe'enia nga ruu kwakwao'a lo'oori, tafe'ua ma gila gosua, ma ngaia ka nana'i no'o 'i talana. ");
INSERT INTO kwd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sui ma nga wane laka'u ngaia 'e nigi maana giru gwa'u no'ona 'i na'o bi'i ru'u la'u kau 'i 'ubulana giru gwa'u no'ona. Ngaia 'e agasia maka tagoto'o no'o ai. ");
INSERT INTO kwd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma gila 'ame su'a 'ua na nga Girigiringa Abu laka'u ne'e iiria ngaia te'e tata'e la'u fa'asia nga maenga. ");
INSERT INTO kwd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma 'i burina 'ola lo'oo, nga rua wane na fufu'iwane lo'oori, gala ka ori no'o. ");
INSERT INTO kwd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma ni Meri 'e ula 'ua 'i maa na giru gwa'u no'ona ma ka aani. Ma nga alata ngaia 'e ani, ngaia 'e gogonu maka aga kau 'ubulana giru gwa'u laka'u. ");
INSERT INTO kwd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma ngaia ka agasia nga rua enselo, gala ru'ufia ruu kwakwao'a. Ma rua enselo lo'oori, gala to'oru na lefu na nonina la Jisas 'e nana'i ai 'i na'o, te'e ai ngaa'i na lefu na gouna 'e nana'i ai, ma te'e ai ngaa'i na lefu na 'a'aena 'e nana'i ai. ");
INSERT INTO kwd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nga rua enselo lo'oori, gala ka orisia ni Meri 'ilo'oo, “'Olataa lo'oo 'i'oo aanisia welakau?” Ma ngaia 'e lamadu'aa gaa'a maka 'ilo'oo, “Nga nonina nga Alafa agu na gila ngaria no'o fa'asia 'i lo'oo, mai nau ku bobolosia 'i fai na gila arua la'u ai.” ");
INSERT INTO kwd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ma 'i burina ngaia 'e alafuu 'ilo'oo 'e sui, ngaia 'e abulo kau, ma ka agasia la Jisas ngaia 'e ula mola, ma ngaia 'ame aga su'a na nga wane no'ona na ngaia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma la Jisas ka orisia maka 'ilo'oo, “Noni lo'oo, 'utaa na 'i'oo aani welakau? Ma ni dai na 'i'oo kwailo 'ofia?” Ma ni Meri 'e madafia iiria ngaia nga wane ne'e aga suria nga langa'a no'ona. Ma ngaia ka 'ilo'oo fana, “Lauta 'i'oo ngaria kau nga nonina Alafa agu, nau ku siria 'i'oo 'ani kwairii te'agu 'i fai na 'i'oo arua ai, fana 'aku leka 'aku ngaria.” ");
INSERT INTO kwd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sui ma la Jisas ka fata 'ilo'oo fana, “Meri 'ae!” Ma ni Meri 'e abulo mai, ma ka aga kau, ma ka aga su'ana, ma ka alafuu 'ilo'oo fana, “Raboni!” Ma nga alafuunga lo'oo nga alafuunga na ta'a 'i Jiu fa'awatagalai na nga ‘Wane ni Kwaifa'ananaunga.’ ");
INSERT INTO kwd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma la Jisas ka alafuu 'ilo'oo fana, “'I'oo sia gema mola agu, tofuna nau ku 'ame ori 'ua te'ana nga Mama'a agu 'i langi. 'Oi ori te'ana nga fufu'iwane agu, moko kwairii te'aga, nau ku leka no'o te'ana Mama'a agu, na ngaia nga Mama'a amooru la'u mola. Ma ngaia na nga God agu, ma nga God amooru la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sui ma ni Meri fa'asia 'i Magdala ka ori, ma ka kwairii te'ana nga fufu'iwane na ngaia 'e agasia nga Alafa. Ma ngaia ka alafuu la'u mola faga suria nga 'ola na la Jisas 'e iiria te'ana. ");
INSERT INTO kwd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Laulafi na nga Sande, nga fufu'iwane aana gila ogu 'i 'ubulana te'e 'ifi, ma gila ka fono 'usia nga sinamaa. Ma gila ka 'ailafita la'u mola na nga sinamaa no'ona, suria gila ma'unge'enia nga ta'a na'ona'o 'i Jiu. Gila lebe ma la Jisas ka faata'i mai 'i laloaga, ma ngaia ka alafuu 'ilo'oo, “Nga aloalonga 'e nana'i fe'eni 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma 'i burina na ngaia 'e iiria nga alafuunga lo'oo, ngaia ka faate'enia nga rua ninimana ma nga kalaona faga. Ma nga fufu'iwane ana gila ka aile'a ba'ita na alata no'ona gila agasia nga Alafa. ");
INSERT INTO kwd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma la Jisas ka fata 'ilo'oo la'u faga, “Nga aloalongaa 'e nana'i fe'eni 'amooru. 'Ilaka'u nga Mama'a ne'e 'e alenau mai, ngai lo'oo nau ku ale 'amooru la'u mola.” ");
INSERT INTO kwd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","La Jisas 'e iiria alafuunga lo'oo, sui maka mangofiga, ma ka fata 'ilo'oo, “Moru ngaria nga Anoe 'ola Abu.” ");
INSERT INTO kwd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lauta mooru 'olafanataa na rianga na ta'a, God te'e 'olafanataa la'u mola aaga. Ma lauta moru 'ame 'olafanataa aaga, God ngaia 'e sia 'olafanataa mola aaga. ");
INSERT INTO kwd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma te'e wane na nga akwale'e wane ma ruaai no'ona na latana la Tomas na gila fa'alataa la'u mola 'ania 'I'iu, ngaia 'ame nana'i fe'eniga na alata na la Jisas ngaia 'e nigi te'aga. ");
INSERT INTO kwd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma nga fufu'iwane na gila nana'i, gila ka alafuu 'ilo'oo te'ala Tomas, “Meeru meru agasia no'o nga Alafa.” Ma la Tomas ka fata 'ilo'oo faga, “Lauta nau ku agasia nga filafila laka'u na talafurina nga nila 'i nimana, ma 'inau ku gema to'ona nga filafila no'ona 'ania nimagu, mai nau ku arua nga nimagu 'i talafurina nga maalafa laka'u 'i kalaona, ma nau taku bi'i tagoto'o. Ma lauta nau ku 'ame agea mola ni 'ola lo'oo, nau ku sia tagoto'o mola.” ");
INSERT INTO kwd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma nga fiuna ma'e gani 'i burina, nga fufu'iwane laka'u gila ogu la'u mola 'i 'ubulana nga 'ifi laka'u, ma la Tomas 'e to'oru no'o fe'eniga. Ma gila ka 'ailafita la'u mola 'usia nga sinamaa no'ona. Sui mala Jisas 'e faata'i mai, ma ka ula 'i laloaga, ma ka alafuu 'ilo'oo, “Aloalonga 'e nana'i fe'eni 'amooru.” ");
INSERT INTO kwd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sui ma la Jisas ka alafuu 'ilo'oo fala Tomas, “Tomas 'ae, 'oi arua nga 'u'umu 'i lo'oo 'ubulana nimagu, moko agasia nga rua nimagu. Moko arua nimamu 'i talafurina maalafa lo'oo 'i kalaogu. 'I'oo sia manata ruarua mola, 'oi tagoto'o no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma la Tomas 'e lamadu'aa maka 'ilo'oo, “'I'oo nga Alafa agu, ma nga God agu.” ");
INSERT INTO kwd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma la Jisas ka fata 'ilo'oo fana, “'I'oo tagoto'o, tofuna 'i'oo agasi nau. Nga nanamanga fana ni dai na gila 'ame agasi nau, ma gila tagoto'o mola agu.” ");
INSERT INTO kwd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","La Jisas 'e agea ni 'ola ni 'alefosilai 'e aula la'u na nga fufu'iwane aana gila agasia, tafe'ua mai nau ku sia giria la'u 'ubulana buka lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nau ku giria mola ni 'ola lo'oo, fana 'amoru tagoto'oa na la Jisas ngaia na nga Kraes, ma ngaia no'o na nga Wela na God. Ma lauta mooru tagoto'o na 'ola lo'oo, tamoru to'o na nga mooringa firi. ");
INSERT INTO kwd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","'I burina ni 'ola lo'oo, la Jisas 'e faata'i la'u fana nga fufu'iwane aana 'i suria nga asi 'i Galili. Ma 'ola lo'oori 'e lau 'ilo'oo: ");
INSERT INTO kwd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","La Saemon Pita, ma la Tomas na gila fa'alataa 'ania 'I'iu, ma la Nataniel nga wane fa'asia 'i Kena 'ubulana nga gule'e lefu 'i Galili, ma nga rua wela ala Sebedi, ma rua wane na fufu'iwane ngaa'i la'u, gila ogu. ");
INSERT INTO kwd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma la Saemon Pita ka alafuu 'ilo'oo fana ni wane no'ona, “Nau ku leka 'aku dee no'o fana ii'a fagu.” Ma gila ka fata 'ilo'oo, “Meeru meru siria la'u mola 'ameru leka fe'eni'o.” Ma gila leka, ma gila ka ta'e no'o 'ubulana nga baru. Tafe'ua na fe'e logo no'ona, gila 'ame deea no'o te'efuta gweii'a. ");
INSERT INTO kwd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma alata ngaia 'usu'usugani mola, la Jisas 'e ula 'i suria asi. Ma nga fufu'iwane aana, gila 'ame aga su'a mola ana. ");
INSERT INTO kwd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sui ma la Jisas ka fata kau faga maka 'ilo'oo, “Fu'uwane ni kwaimaanga agu, 'ilo'oo ma moru deea te'efuta gweii'a?” Ma gila lamadu'aa ma gila ka 'ilo'oo, “'Amoe no'o.” ");
INSERT INTO kwd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma ngaia ka alafuu 'ilo'oo, “Moru 'ui 'ania nga fulai amooru 'i gula le'a na baru no'ona, ma tamoru daua nga ii'a.” Ma alata gila 'ui 'ania nga fulai laka'u, ma gila ka daua no'o nga ii'a 'e aula maka 'ato no'o fana lafulana fulai laka'u mai langi, tofuna ii'a 'e aula. ");
INSERT INTO kwd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sui ma nga wane na fufu'iwane laka'u la Jisas ngaia 'e kwaimaa fana ka fata 'ilo'oo fala Pita, “Nga Alafa loko'u!” Ma alata la Saemon Pita ngaia 'e longoa nga 'ola lo'oo, ngaia 'e ruufia 'ania nga ruu 'e tekwa aana, tofuna ngaia 'e rubea fana 'ani taunga'i, ma ka olo 'ubulana asi, ma ka 'alanga no'o fana 'i su'e. ");
INSERT INTO kwd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma nga fufu'iwane aana gila ka leka no'o mai 'i su'e na baru. Ma gila ka lafua no'o mai nga fulai ne'e fongu no'o 'ania ii'a, suria gila 'ame nana'i lalau mola fa'asia 'i su'e, to'omia mola te'e tangale'e tafanga. ");
INSERT INTO kwd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma alata gila sifo 'i su'e, gila ka agasia nga mani'i beret fe'enia nga eele ngaia 'e nunula mola fe'enia nga ii'a 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma la Jisas ka alafuu 'ilo'oo faga, “Moru ngaria mai tani gweii'a na nga ii'a na moru deea lo'oo.” ");
INSERT INTO kwd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","La Saemon Pita 'e leka kau 'ubulana nga baru, ma ka lafua mai nga fulai no'ona 'i su'e. Nga fulai lo'oori 'e fongu no'o 'ania nga ii'a ba'ita, tangale'e ii'a ma nima urii'a ma oru gweii'a (153) na gila daua. Gwa'a nga ii'a 'e aula 'ilo'oo 'i 'ubulana nga fulai, nga fulai lo'oori ngaia 'ame foga mola. ");
INSERT INTO kwd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma la Jisas ka fata 'ilo'oo faga, “Leka mai, 'amoru keto madi.” Tafe'ua ma te'efuta wane aaga 'ame orisia mola 'ilo'oo, “'I'oo ni dai lo'oo?” Du'ana gila su'ana mola na ngaia nga Alafa. ");
INSERT INTO kwd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma la Jisas 'e leka kau maka ngaria nga beret, ma ka kwatea fana nga fufu'iwane aana, ma ka kwatea la'u mola na gweii'a lo'oo. ");
INSERT INTO kwd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nga oruna alata no'o na la Jisas ngaia 'e faate'enia fana nga fufu'iwane aana 'i burina na ngaia 'e tata'e fa'asia nga maenga lo'oori. ");
INSERT INTO kwd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma alata gila keto te'efou 'e sui no'o, la Jisas 'e orisia la Saemon Pita maka fata 'ilo'oo, “Saemon nga wela ala Jon, 'ilo'oo ma 'i'oo kwaimaange'eni nau 'e riufia nga fufu'iwane lo'oo na gila kwaimaa fagu?” Ma ngaia ka lamadu'aa maka 'ilo'oo, “Kiu, Alafa. 'I'oo su'a mola ai na 'i nau ku kwaimaa famu.” Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi aga suria ni dale'e sifisifi lo'oo agu.” ");
INSERT INTO kwd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma la Jisas ka orisia la'u fana ruana alata, “Saemon nga wela ala Jon, 'ilo'oo ma 'i'oo kwaimaa fagu?” Ma ngaia ka lamadu'aa maka 'ilo'oo, “Kiu, Alafa. 'I'oo su'a mola ai nau ku kwaimaa famu.” Sui ma la Jisas ka alafuu 'ilo'oo fana, “'Oi aga suria nga sifisifi lo'oo agu.” ");
INSERT INTO kwd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma la Jisas ka orisia la'u 'ilo'oo na oruna alata, “Saemon nga wela ala Jon, 'ilo'oo ma 'i'oo kwaimaa fagu?” Ma la Pita ka kwaimanadai no'o, suria la Jisas ngaia 'e orisia na oru alata 'ilo'oo, “'Ilo'oo ma 'i'oo kwaimaa fagu?” Ma la Pita ka alafuu 'ilo'oo fana, “Alafa, 'i'oo su'a no'o na 'ola te'efou, ma 'i'oo su'a la'u mola ai na 'inau ku kwaimaa famu.” Ma la Jisas ka alafuu 'ilo'oo fana, “'Oi aga suria nga sifisifi lo'oo agu. ");
INSERT INTO kwd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Ola kwala'imori nau ku iiria famu, alata 'i'oo alakwa mola 'ua, 'i'oo 'afesia nga ruu amu 'i talamu sui moko leka mola suria manatalamu fana te'efuta lefu na 'i'oo siria 'ani leka ai. Tafe'ua ma nga alata 'i'oo koko'o, 'i'oo to'o tagwala no'o nimamu, ma nga wane matari na te'e fo'osi'o 'ania nga fo'osae amu, ma ka talai'o fana lefu na 'i'oo 'ame siria lekanga ai.” ");
INSERT INTO kwd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","La Jisas 'e iiria nga 'ola lo'oo, fana 'ani faate'enia na nga maenga la Pita te'e mae ai, na ngaia te'e faate'enia tegelangaa ala God. Sui ma la Jisas ka alafuu 'ilo'oo fana, “'Oi leka mai 'i burigu.” ");
INSERT INTO kwd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma la Pita ka abulo mai, ma ka agasia nga wane na fufu'iwane na la Jisas ngaia 'e kwaimaa fana. Ngaia wane na ngaia 'e nana'i galangia la Jisas na alata gila keto, ma ka orisia 'ilo'oo, “Alafa, ni dai na te'e olonge'eni'o?” ");
INSERT INTO kwd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Alata la Pita 'e agasia, ngaia 'e orisia la Jisas maka 'ilo'oo, “Alafa, 'olataa na te'e lau fana nga wane lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","La Jisas 'e lamadu'aa maka 'ilo'oo, “Lauta nau ku siria nga wane lo'oo 'ani momoori, leleka maka nigi na alata nau 'aku ori mai, 'i'oo sia manata gelo mola suria. Ma 'i'oo, 'oi leka mola mai suri nau.” ");
INSERT INTO kwd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aia, nga alafuunga 'e talo laloana nga fufu'iwane ala Jisas. Gila iiria nga wane lo'oori ngaia 'e sia mae mola. Tafe'ua ma la Jisas ngaia 'ame iiria no'o na nga wane lo'oo ngaia 'e sia mae mola. Ngaia 'e alafuu mola 'ilo'oo, “Lauta nau ku siria nga wane 'ani momoori, leleka maka nigi na alata nau 'aku ori mai, ngaia nga manata gelongaa amu 'amoe no'ona.” ");
INSERT INTO kwd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ma nga wane na la Pita 'e kwaiorisi suria, ngaia ne'e giri suria ni 'ola lo'oo te'efou. Ma 'imeeru meru su'aai nga 'ola lo'oo ngaia 'e alafuu suria, ngaia 'e kwala'imori no'o. ");
INSERT INTO kwd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","La Jisas 'e agea 'ola 'e aula iiki la'u. Ma lauta 'agila girigiri suria te'efou, nau ku madafia bala nga fanua lo'oo 'i wado, ngaia 'e sia to'omia la'u fana daunga fafia nga buka na 'agila giria ni 'ola no'ona 'i 'ubulai. ");
INSERT INTO kwd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwe Teofilas, 'ubulana girigiringa eteeta laka'u agu, nau ku giri suria 'ola te'efou na'a la Jisas 'e launge'enia, ma ka kwaifa'ananau 'ania, ");
INSERT INTO kwd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","leleka maka nigi na gani God 'e ngaria fani langi. Sui ma ngaia bi'i fane fani langi, ngaia 'e kwaifa'ananau 'ilo'oo 'ania Anoe 'ola Abu fana nga ta'a na'a ngaia 'e firiga sui no'o fana 'i gila Wane ni Kwairiinga aana. ");
INSERT INTO kwd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ma 'i suria fai akwale'e gani burina nga maenga ana, nga alata 'e aula ngaia 'e faata'i fana ni Wane ni Kwairiinga ana, ma ngaia ka agea ni 'ola 'e aula 'ani fa'ato'oa na ngaia 'e moori no'o. Ma ngaia 'e alafuu faga suria nga alata God te'e ba'ita fafia ta'a ana. ");
INSERT INTO kwd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma nga alata ngaa'i la Jisas ngaia 'e nana'i 'ua fe'enia fufu'iwane ana, ma ngaia ka fata tegela faga maka 'i lo'oo, “Moru sia leka mola fa'asia 'i Jerusalem. Moru mamania nga kwakwatenga laka'u Mama'a agu 'e fataarunga'i 'ania, na moru longoa nau ku fata no'o mai suria 'i na'o. ");
INSERT INTO kwd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘La Jon ngaia 'e naruabu amooru 'ania ka'o, ma 'ame aburu mola, God te'e naruabu 'amooru 'ania nga Anoe 'ola Abu.’” ");
INSERT INTO kwd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nga alata na'a ta'a ni lelekanga gila ogu la'u fe'enia la Jisas, gila kwaiorisi ma gila ka fata 'i lo'oo, “Alafa, 'ilo'oo ma, 'i'oo to'o orite'enia nga foufoula laka'u fameeru ta'a 'i Israel na alata lo'oo?” ");
INSERT INTO kwd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma la Jisas 'e lamadu'aga maka 'i lo'oo, “Ngaia nga 'ola 'amoe fana 'amoru su'aai na gani ma nga alata lo'oo, suria Mama'a agu ne'e arua alata fana ni 'ola lo'oo 'ani nigi mai. ");
INSERT INTO kwd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tafe'ua mai mooru lo'oo, alata na'a Anoe 'ola Abu 'ani nigi mai fafi 'amooru, tamoru to'o na tegelangaa. Ma tamoru alafuu suri nau lo'oo 'i Jerusalem, ma nga fanua lo'oo te'efou na gule'e lefu 'i Judea ma 'i Samaria, ma ka nigi na fanua te'efou fofona nga fanua lo'oo 'i wado.” ");
INSERT INTO kwd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma 'i burina ngaia 'e iiria 'ola lo'oo te'efou, God ka ngaria no'o fani langi. Ma alata gila agaaga mola 'ua 'i suria, ma te'e me'e kofa ka riu fafia, ma gila ka 'ame agasia no'o. ");
INSERT INTO kwd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma alata gila bubu totonga'i 'ala'a fani langi fana agasilana, na alata ngaia 'e fane no'o, nga rua wane gala ru'ufia ruu kwakwao'a gala faata'i 'afe'aferu mai, ma gala ka ula no'o fe'eniga. ");
INSERT INTO kwd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma 'i gaa'a gala ka orisiga ma gala ka 'i lo'oo, “Fu'uwane 'i Galili, 'e fe'ua na'a moru ula mola 'i lo'oo, ma moru ka aga aga 'ala'a mola fana 'ubulana lalo? La Jisas laka'u God 'e ngaria fa'asia mooru fani langi, ngaia te'e ori la'u mai, 'ilaka'u moru agasia ngaia 'e fane fani langi.” ");
INSERT INTO kwd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sui ma ni Wane ni Kwairiinga lo'oo, gila ka ori no'o fani Jerusalem fa'asia gouna me'e busu na'a gila fa'alataa 'ania 'i Olif. Gouna busu lo'oo 'ame lalau; ngaia 'e to'omia te'e kilomita fa'asia 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma alata gila nigi no'o 'i Jerusalem, gila ka fane fana nga tofi'i 'ifi na'a gila to'oru ai 'i langi. Latana ni wane na gila ogu: la Pita, ma la Jon, ma la Jemes, ma la Andru, ma la Filip, ma la Tomas, ma la Batolomiu, ma la Matiu, ma la Jemes nga wela ala Alfeas, ma la Saemon te'e wane fe'enia fufu'iwane na gila siria tarilana ta'a ni fununga 'i Rom fa'asia 'i Israel, ma la Judas nga wela ala Jemes. ");
INSERT INTO kwd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma gila ka ogu no'o fana fo'anga, ma ni fu'igeni ngaa'i la'u, fe'enia ni Meri nga ga'ia la Jisas, fe'enia ni wane gila futa fe'enia la Jisas. ");
INSERT INTO kwd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma te'e alata ngaa'i gila ogu la'u, to'omia tangalau ma rua akwale'e wane na gila tagoto'o na'a gila ogu te'efou. Ma la Pita ka tata'e maka fata 'i lo'oo faga, ");
INSERT INTO kwd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Wane goru futa, nga Girigiringa Abu suria la Judas 'e lau 'e to'o no'o, suria nga Anoe 'ola Abu laka'u 'e iiria ala Defete 'ani fata 'ania la Judas. La Judas laka'u la Jisas 'e eefasia fana ngaia 'ani lau fana te'e wane 'ubulana fufu'iwane adauru fana taunga'inga lo'oo, tafe'ua la Judas 'e eta na'ona ta'a fana daulana la Jisas.” ");
INSERT INTO kwd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ngaia la Judas 'e ngaria bata laka'u gila foria 'ania fana 'olonge'enilana la Jisas, ma ka sugaa me'e wado. Ma 'ubulana wado lo'oori, ngaia ka 'esia, ma batana ka fola no'o ma ka tafa no'o fani maa. ");
INSERT INTO kwd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma ni wane na'a gila nana'i 'i Jerusalem, gila ka longoa nga 'ola ne'e lau ala Judas, ma gila ka fa'alataa nga me'e wado lo'oori 'ania “Akeldama” fana su'asurilai nga alafuunga lo'oori nga “Wado Na nga 'Abu.” ");
INSERT INTO kwd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma la Pita ka alafuu la'u maka 'i lo'oo, “'Ola lo'oo 'e lau suria gila giria no'o 'ubulana buka na Sam ne'e alafuu 'ilo'oo, ‘Nga 'ifi ana te'e gwa'u, ma te'efuta wane sia to'orufia la'u ai.’ Ma girigiringa ngaa'i ka iiria la'u, ‘Ngaia 'e le'a fana te'e wane ngaa'i 'ani lamadu'aa, fana 'ani ngaria taunga'inga ana.’ ");
INSERT INTO kwd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ngai lo'oo ngaia 'e le'a fana 'agoru eefasia la'u wane 'ani lado fe'eni 'ameeru fana 'ani kwairii suria tata'enga na Alafa la Jisas fa'asia nga maenga. Nga wane na'a 'agoru eefasia, ngaia furina ta wane la'u mola na fufu'i wane laka'u gila leleka oguogu fe'eni 'adauru na alata laka'u la Jisas ngaia 'e nana'i 'ua fe'eni adauru, tala'ae mai na alata laka'u la Jon 'e naruabu ala Jisas, leleka mai maka nigi na gani laka'u God 'e ngaria no'o la Jisas fa'asia dauru fani langi.” ");
INSERT INTO kwd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma gila ka firia rua wane: latana nga wane ngaa'i la Josef, na'a gila fa'alataa 'ania la Barsabas, ma gila fa'alataa la'u 'ania la Justus. Ma latana nga ruana wane na'a la Mataeas. ");
INSERT INTO kwd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sui ma gila fo'a ma gila ka 'i lo'oo, “Alafa, 'i'oo no'o su'asuria manatalana ta'a te'efou. Ngai lo'oo, 'i'oo to'o faate'enia mai fameeru na alata lo'oo dai na rua wane lo'oo na'a 'i'oo to'o firia, ");
INSERT INTO kwd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'ani ngaria nga taunga'inga lo'oo na'a la Judas 'e 'akwasia ma ka leka no'o fana nga gula na'a 'i ngaia 'e tarifunga'i ai.” ");
INSERT INTO kwd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma 'i burina gila fo'a te'efou, gila ka masa fana kwaifiringaa, fana 'agila su'a 'i suria ni dai na rua wane lo'oo na'a God te'e firia, ma gila ka eefasia no'o la Mataeas, fana taunga'i fe'enia akwala ma te'e ai. ");
INSERT INTO kwd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na nga gani ba'ita 'i Jiu na'a gila fa'alataa 'ania Pentakos, nga ta'a na gila tagoto'o lo'oo, gila ogu na te'e lefu 'ubulana fanua ba'ita 'i Jerusalem. ");
INSERT INTO kwd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma gila ka longoa nga kutanga 'ilaka'u nga iru ba'ita, ngaia 'e sifo mai fa'asia 'i Langi, ma ka fonu fafia na 'ifi lo'oo gila ogu ai. ");
INSERT INTO kwd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma gila ka agasia nga 'ola 'ilaka'u nga uunu sisika, ma ni 'ola lo'oori gila tagala'i ma ka to'oru 'i gouna ta'a lo'oo te'efou na'a gila ogu 'i no'ona. ");
INSERT INTO kwd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma nga Anoe 'ola Abu ka fa'afonguga te'efou, ma gila ka eta no'o fana alafuunga 'ania nga alafuunga na ta'a matari, 'ilaka'u Anoe 'ola Abu 'e fa'afataga 'ania. ");
INSERT INTO kwd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na alata no'ona, nga ta'a 'i Jiu na'a gila fo'asia God, gila nana'i la'u mola 'i Jerusalem. Gila leka mai fa'asia ni maa'e fanua kwaitatari'a fofona fanua lo'oo 'i wado. ");
INSERT INTO kwd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma alata gila longoa nga lakotenga lo'oori, ta'a 'e aula gila ka ogufiga. Ma gila ka 'alefo ba'ita, suria ta'a lo'oo na gila tagoto'o, gila alafuu 'ania ni maa'e alafuunga na ta'a kwaitatari te'efou. ");
INSERT INTO kwd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma suria gila 'alefo ba'ita, gila bi'i fata 'i lo'oo faga 'i talaga, “Ni wane lo'oo gila fafata 'i lo'oo, gila ta'a 'i Galili te'efou lo'oo mola. ");
INSERT INTO kwd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Fe'ua na'a meru longoa gila fata 'ania alafuunga ameeru? ");
INSERT INTO kwd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Du'ana 'i 'imeeru meru leka mai fa'asia fanua 'i Partia, ma 'i Media, ma 'i Elam, ma 'i Mesopotemia, ma 'i Judea, ma 'i Kapadosia, ma 'i Pontus, ma 'i Eisia, ");
INSERT INTO kwd_vpl VALUES ("AC2_10","074_