﻿USE sofia;
DROP TABLE IF EXISTS sofia.kvnNT_vpl;
CREATE TABLE kvnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kvnNT_vpl WRITE;
INSERT INTO kvnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imi Jesucristo David-akar tani, tegin David Abraham-akar tanimo. Tenal antin Mateo, Jesucristo-e-tadgan-ampagusmalad akpene-akar nermakal-maidgin chunmanejun. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Imi Abraham-machidin nug Isaac. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tegin Judá-machidin nug Fares, ");
INSERT INTO kvnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tegin Aram-machidin nug Aminadab. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tegin Salmón-machidin nug Booz, tenal Booz-e-nandin Rahab. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tegin Isaí-machidin nug David tenal Daviddin erreyga megwis. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tegin Salomón-machidin nug Roboam. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tegin Asa-machidin nug Josafat. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tegin Uzías-machidin nug Jotam. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tegin Ezequías-machidin nug Manasés. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tegin Josías-machidin nug Jeconías. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tegin Babilonia-tolgan ");
INSERT INTO kvnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tegin Zorobabel-machidin nug Abiud. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tegin Azor-machidin nug Sadoc. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tegin Eliud-machidin nug Eleazar. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tegin Jacob-machidin nug José. Tenal Josédin María-e-machered. Tenal Maríadin Jesús-e-nan. Tenal we Jesús imis pimal Cristo, Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imi Abraham-akar Davidzhe tadgan-walambe-kakabake kumal. Tenal David-akar, Israel-tulemal Babilonia-tulemalzhe-kalejadzhe tadgan-walambe-kakabake kumalmo. Tenal Babilonia-tulemal Israel-tulemal-kajad-akar, Cristo-nonikidzhe tadgan-walambe-kakabake kumalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Imi Jesucristo-mimmilejad weob kusdo. Imi teun takalgu, Jesús-e-nan-María tule-José-nugadbak aga kaka-ukchamal aga nikumalgal. Tenal José ampayo María-nikueddu, María taklegal Pab Purpa Nuedga pato ponigwal-kwichi. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tenal José-María-macheredga-kuoed tule-nued-choggu, al José tulemal-wagin yapa María-opinkechegus. Al José otukal nabiridgin María-ebebi-kual. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tenal José ampa María-ponigwal-kwichidgin-pinzhediidgin, Pab-angel Joséga kabdakedgin chunmanoni, Joséga chogal: “José-David-e-wagwa, imi pe akalzhul María-nikuo pe-omega kugal. Imi María-we-nuchu-nikuneed Pab Purpa Nuedga nikudanikid. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tenal María nuchu-nikunonikil, machi-nikuo. Tenal pe we machi-nugzhao Jesús, ade iskued-akar e-tulemal-abonogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Imi Maríaga tegin Joséga pel-kwapa weob immal kujaddin, Pab Tummad akpene e-kaka-palchogedbal iktualeba chogzhagujad-yopí kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tenal Pab-kartagin chogzhado: Imi puna-yae-walgwen-machered-kwen-wichulid ponigwal-kwisgunoniko, tenal we puna machi-toto-nikunoniko. Tenal we machi nugzhalenoniko Emanuel. (Wedin choglege: “Pab anmalbak kudii.”) ");
INSERT INTO kvnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tegin José kabmaid-akar atasgu, angel-ega-chogzhad-yopí imas. Al José Maríabak aga nikunonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tenal José María-nikusgu, apka omega María-kwen-imaszhul. Tenal José María-machi-nikujad-cholbal kep omega María-imas. Tenal José we machi-nugzhaszhun, Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Imi Jesús Belén-Provincia-Judeagin mimmilesgu, teun takalgu Errey-Herode pel-kwapa Provincia-Judeagin neg-takmai. Imi Jesús-mimmilejad-cholbal, Magomal tad-nakwed-akar Jerusalénzhe nonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tegin Magomal Jerusalénzhe nonimalgu, ekisnonimal: —¿Judio-errey-imichal-mimmilejaddé pia maidé? Imi anmal tad-nakwedbal e-iskwa-kanonikid takchamal. Tenal anmal tanimalbal Pab Tummadyob we errey-otummogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tegin Errey-Herode Magomal-chogzhad itosgu, Herode chuli-pinzhe-pes. Tegin tulemal-Jerusaléngin-pukmalad-pel-kwapa ampa chuli-pinzhe-pesmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tenal Herode pel-kwapa tule-irwal-Pabzhe-kolmalad-tummaganzhe tegin tule-Moisés-igalgin-tulemal-oturdamaladzhe kochamalgu, Herode Judio-tummaganzhe ekichialzhun: —¿Imi Cristo-Pab-akpene-chogzhad-palmidagoed-tuledé, pia mimmilego-ade? ");
INSERT INTO kvnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tegin Judio-tummagan Errey-Herodega chogalzhun: —Imi Cristo Belén-Provincia-Judeagin mimmilego. Tenal akpene Pab-kaka-palchoged Pab-kartagin nermasdo: ");
INSERT INTO kvnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Imi we neg-kwebur-Belén, Judea-napkin chii. Tenal we neg-kwebur pollé-taklegen, tenal neg-kwebur-pul-chunchogmaladga pul neg-chunchogedmo. Imi we neg-kwebur-Belén-akar tule-tummad nononiko neg-takegal, Tenal we tule-tummad an-Israel-tulemal-iktuedga kunoniko, tule-oveja-takedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tegin Errey-Herode pidzhi Magomalzhe kochagu, Magomalzhe nuekwa ekichialzhun, iskwade inkwa naigunoni. Tegin Magomal Herodega palchogalmalzhun, emalde untargus takchamal iskwa kanoni. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tegin Herode kep Belénzhe Magomal-palmijogalidgin Magomalga chogal: —Imisgin pe nadmaldo. Tenal pe Belénzhe omojal, pe nuekwa machi-amimalo. Tegin pe machi-onojal, anka pe kannan choge-tagmalbalo, an Pab Tummadyob ne-otummo-negalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tegin Magomal Herode-chogzhad itosmalgu, ukin nadmalzhun. Tenal Magomal irmanatapmaladgin, akpene iskwa-tad-nakwedzhik-kajad kannan Magomal-iktumai-kus kanonibal. Tenal we iskwa Magomal-iktu-natap machi-maidzhe omogal. Tegin Magomal-natapidgin arpak iskwa machi-maid-inniki naigunoni. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tenal Magomal takchagu iskwa emalga naigus, peyedzhe weligwal-itosmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tegin Magomal machi-maid-negzhe togzhamalgu, taknonimal machi aga e-nan-María-waglik mai. Tegin Magomal machi-abir chimtinonimalgu, kep Pab Tummadyob machi-otummoalmal. Tegin Magomal kep ulu-egasmal Jesúsga immal-nuegan ukegal. Tegin Magomal Jesucristoga immal-nuegan ukchamal: olo, immal-wawadikid tegin ina-wawad-mirra. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tenal Pab Tummad kabdakedgin Magomalga chunmanoni ka chogal: “Pe melle kannan Herodeje pal nemalo.” Tegin Magomal kabdakedgin-ka-choglejadbal Herodeje pal nadzhul-kusmalzhun. Tegin Magomal igal-pidbal kannan aga negzhe nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tegin Magomal-naded-cholbal, Pab-angel kabdakedgin Joséga chunmanoni ka chogal: “Kwisgu. Imi pedin machiga-tegin-e-nanga Egiptoje pe wakinenab. Tegin pe Egiptogin pe peio an-pega-chogoedzhe. Imi Herode María-machi-amine tar-mesgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tegin José atagalgu, ilgwen machi-tegin-e-nan-ches. Tenal José apka te mutikkin yok naal nadmal Egiptoje. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tenal José Herode-purkwijadzhe Egiptogin pesmal. Imi Jesúsgin weob immal-kujad Pab akpene e-kaka-palchogedbal chogzhagujadyob pél kus. Tenal Pab Tummad chogzhado: Imi antin naga machije kocha Egiptogin nogal itije megdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tegin Errey-Herode mag-itosgu Magomal e-yardas, Magomal-inik peyedzhe ulual. Tenal Magomal-machigin-chognonikidbal Herode wilub kas. Al Herode aga e-chapinganga chogal: “Imi pemal Beléngin tegin tule-abir-mamimalad pel-kwapa machimal-pirkabo-nikad imis-mimmilejadzhe-pakal pél pe mesmalo.” Tegidgin Herode-e-chapingan pel-kwapa machi-purwigana-mechamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Imi Herode weob machi-purwigana-mechaddin, akpene Pab-kaka-palchoged-Jeremías Pab-kartagin chogzhad-yopí kunoni. Tenal teun Jeremías chogzhado: ");
INSERT INTO kvnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Imi Ramágin tulemal pela-pela pukib-itogedbal okormananimal. Tenal we omegan-Raquel-e-wagwagan e-nuskan-purkwijadbal pela-pela okormananimal. Tenal tule kwen unnijul we omegan-pukib-itoged ochulogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tegin Herode-purkwijad-cholbal, Pab-angel Egiptogin kabdakedgin Joséga chunmanoni ka chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Imi pedin Israel-napche aga e-nanbak kannan machi-toto-chedenabbal. Tenal tule-machi-toto-mesbi-kunaid pato purkwis-choggu, al pe akalzhul kannan nebalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tegin José Israel-napche machi-toto-cheszhun aga e-nanbak. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tenal José wisgusgu Provincia-Judeagin Arquelao e-pab-Herode-anal neg-takmai-pes, José kwakial Provincia-Judeagin meggal. Tegin Pab-angel kabdakedgin Joséga chognoni-choggu Joséde akalzhul Galileagin mego, al José Provincia-Galileaje nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tegin José tegin María machi-totobak neg-kwebur-Nazaretche megnonimalzhun. Imi Jesús-Nazaretkin-megwijad akpene Pab-kaka-palchogmalad chogzhad-yopí kusdo. Tenal teun Pab-kaka-palchoged chogzhado: “Imi tulemal we tule-pinonimalo, tule-Nazaretkined.” ");
INSERT INTO kvnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Imi Jesús ampa Nazaretkin-maidgin Juan Bautista Provincia-Judeagin neg-nikchulidbal Pab-igalgin chunmanoni. Tenal teun Juan Bautista chognonido: ");
INSERT INTO kvnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Imi Pab-neg-takmaid pato omodani-choggu, al pemal aga tukin ulubgin iskuedgin pukib-itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Imi akpene Pab-kaka-palchoged-Isaías Juan Bautistagin chogzhado: Imi neg-nikchulidbal tule-walgwen kolmakal-kolmakal chunmanoniko: “Imi pemal Tule-Tummadga neg nudakenabmal, tegin pe inniki-inniki Tummadga igal-imakenabmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tenal teun takalgu, Juan Bautista moli-camello-e-abzhal-makaled-mol yowi, tegin moli-tub muzhilgin naibal. Tenal Juan-e-mas-kunneddin kusgu ches-chakar-chakar tegin acha-nis. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tegin tulemal-Jerusalénginmalad tegin Provincia-Judeaginmalad tegin Jordán-tiwalbalmalad pel-kwapa Juanzhe nonimal Juan-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tegin tulemal Pabga aga iskued palchogzhamalgu, Juan Jordán-tiwalgin we tulemal-okchamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tenal Juan Bautista takchagu Pariseomal tegin Saduceomal-ichejul eje tigin obdanimalmo, Juan we tulemalga chogal: “¡Pemal nia-wagwagan! ¿Toa pemalga chogzha-ade, pemal tigin-oboedbal Pab-peyedzhe-tule-oturdakoed-akar abonolego? We tigin-oboedbal tule-kwen-abonogojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tenal pemal nued-naneedbal tulemalga aga oyogenabgwel pemal chunchunnad aga ulubgin iskuedgin pukib-itononimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Tenal pemal melle chogdamalo: ‘Abraham an-tad-sagla-choggu, al an akalzhul yozhagu nanao.’ Tenal an chunchunnad pemalga chogdo: imi Pab Tummad chunna nabir we akwamal opinno Abraham-wagwaganga kugal. Al Pab Tummad pemal-kwen-napijul Abraham-wagwaganga kugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Imi Pab Tummad pato kuakwa mai sapejul tule-nuekwá-nanejulmalad-oturdagal, tule chapi-keg-chanmaked-chalgin kuakwa akan-kani-kwichidyob, kuakwa chapi-olegal. Tenal Pab peyedzhe pel-kwapa tule-iskana-oturdako, tule keg-chulgu chapi-keg-chanmaked olaoedyob tegin chogin chapi-okummakoedyobbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tegin Juan chogalbal: “Imi antin tigin pemal-ogmal, oyogal pemal aga ulubgin chunchunnad iskuedgin pukib-itononimal. Tenal tule-walgwen-an-cholbal-tanikoeddin, anka pul kannaleged nika. Tenal we tule anka pul tule-tummadiidbal, an kwen unnijul we tulega kutar chedagal. Tenal we tule-an-cholbal-tanikoed Pab Purpa Nuedgin tegin chogin pe-ognonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Tenal tule-an-cholbal-tanikoed kuakwa kwichi pis-pis tulemal-urpegal, tule pala-azhaled-kanikidgin trigo-omigal kuakwa kwichidyob pis-pis migal. Tegin tule-an-cholbal-tanikoed Pab-neggin tule-nuegan-odogo, tule aga kwapí trigo-kwa chaboedyob. Tenal tule-an-cholbal-tanikoed cho-keg-akinnedgin tule-iskana-urpo, tule chogin trigo-e-uka urpoedyob okummagal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tegin Juan-tulemalga-chogzhad-cholbal, Jesús kep Provincia-Galilea-akar nonimo, Juan Jordán-tiwalgin tulemal-ognaidzhe. Tenal Jesús noni, Juan tigin e-oggalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tegin Jesús Juanga chognoni: “Tigin pe an-ogmogo.” Tenal Juan Jesúsga chogal: —Imi pe anka pul tule-tummad-ulgin, antin tigin pe-kwen-ognejul. Peed pul tigin an-oggalan. ¿Imi pedin pei an tigin pe-og? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tegin Jesús Juanga chogal: —Imi we kaka pe wis igegwelo. Tenal pe tigin an-ogma. Wedin pul ib-nued, anmal Pab-chogzhad-pallí pél immal imagal. Tegin Juan tigin Jesús-okchajun. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tegin Jesús tigin-oglejad-cholbal ilgwen ukubzhe nakwis. Tegidgin nikpa-neg-arkat, tegin Jesús takcha Pab Purpa Nued nuyob egin aktedani, tegin egin chignoni. ");
INSERT INTO kvnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tegin Pab Tummad nikpa-neg-akar kolnoni, chogal: “Wedin an-Machi-Pilaled. Al an naga machigin weligwal-itomo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tegin Juan tigin Jesús-okchagu, apka-te-cholbal Pab Purpa Nued neg-nikchulidbal Jesús-ches, nia-sagla Jesús-wilub-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tenal teun takalgu, Jesús iba-tulabo mas-kwen-kunchul nanajadgin Jesús kep ukul-itononi. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tegin nia-sagla kep Jesúszhe nonimo Jesús-wilub-takegal. Tegin nia-sagla Jesúsga chogal: —Imi pe Pab-Machile, pe we akwamalga chogo: ‘Maduga pinno.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tegin Jesús niaga chogal: —¡Chulá! Imi Pab-kartagin nermakal maido: Tule mas-kunnedginbi kwen tuladijul. Tenal tulemal Pab-kakapurwa-itogedbal tula-timal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tegin nia-sagla Jerusalén-neg-kwebur-chwilidikidzhe Jesús-ches. Tegin nia-sagla Pabzhe-koled-neg-uwas-pirzhe Jesús-onakwisbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tegin nia-sagla Jesúsga chogalbal: —Imi pe Pab-Machile, pe we-akar napche ichomado. Tenal pedin kwen akalguojul. Tenal Pab-kartagin nermakal maido: Imi Pab Tummad aga e-angelmalga chogo pe-takegal. Al pe arkwatel, angelmal chugnukwa pe-kanonimalo, pe melle akwagin nag kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tegin Jesús nia-saglaga chogalbal: —Nabir pe chogendo, tenal Pab-kartagin chogbaldo: Pe melle Pab-Tummad-wilub-tako. Dt. 6:16 Al an uwas-pir-akar kwen ichomakojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Teginbal, nia-sagla yal-tummad-pirzhe Jesús-chesbal. Tegin nia-sagla Jesúsbak yal-pir omosgu, nia-sagla ilgwen-oyoal pel-kwapa-nap-naid-ugakche Jesúsga neg-nugu-takleged oyogwis-kual. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tegin nia-sagla Jesúsga chogalbal: —Imi pe an-abir chimtijal, tegin pe Pab Tummadyob an-otummoel, an imis neg-kwebur-an-pega-oyojad, an pel-kwapa pega ukodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tegin Jesús nia-saglaga chogal: —Nia-Satanás, pe we-akar pe nema. Pe melle ankin pal yolego. Imi Pab-kartagin nermakal maido: Pab Tummadbi pe Pab Tummadyob otummogenab, tegin pe Pab Tummadgabi pe pél immal imakenabbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tegidgin nia-sagla Jesús-akar tikajul nadzhun. Tenal angelmal Jesúszhe nonimalgu, Jesús-pentanonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tegin Jesús wisgusgu, Juan Bautista oturdaleged-neggin mellejii, Jesús Provincia-Galileaje kannan nadbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tegin Jesús Nazaret-neg-kweburgin ichejal wis megwisgu, kep Capernaum-neg-kweburzhe nadzhun. Tenal Capernaum-neg-kweburdin mata-kakpal chii, Zabulón tegin Neftalí pukmaladzhik. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Imi Jesús-Capernaumgin-megnonikid akpene Pab-kaka-palchoged-Isaías akpene chogzhadyob kunoni. Tenal Isaías Pab-kartagin chogzhado: ");
INSERT INTO kvnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Imi Zabulón-nap tegin Neftalí-nap matazhik chii, Jordán-tiwal-opakal. Wedin, Provincia-Galilea. We negdin Judiojulmalad-e-neg. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Imi we neggin tule-Pab-wichulmalad pukwamal, tule neg-chichidgin aku immal takedyob. Tenal tule-walgwen Pab-wisgugal we tulemal-imanoni, kallen-chegagiid neg-otalononikidyob. Tegin tule-purpal-purkwedanimaladga noed noni, neg-chichid-yabal neg-talgunonikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Imi teun-akar Jesús tulemalga chunmadi-kual chogal: “Imi Pab-neg-takmaid-wilub omodani-choggu, al pemal aga ulubgin iskuedgin pukib-itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tegin te ibagwengin Jesús Galilea-mata-kakpal pipirmadiidgin, walbo tule-takal aga kwenadbak kunai. Imi we tule-walgwen nug Simón, tegin pimalbal Pedro, tegin Simón-e-urpadin nug Andrés. Tenal we tule-walbogid kusgu e-arpagedbal chakigin ua-kananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tegin Jesús tule-walbogwadga chogal: —An-ai, pe anpak nemalma, ankin turdagal. Imi pe chakigin ua-kadiidyob pe anka tulemal-amigal, ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tegidgin Simón tegin Andrés chaki ebesmalzhun, ilgwen Jesúsbak nadmalzhun Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tegin Jesús ukin-nadedgin walbo tule-taknatappal aga kalgwenadbak kunaibal. We tule-walbogid Zebedeo-machimal, Jacobo tegin e-urpa-Juan. Tenal we machimal-walbogid aga e-pabbak ulgin chaki nudananimal. Tegin Jesús we machimal-walbogidzhe kochamalmo egin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tegin we machimal-walbogid ilgwen ul-ebesmal tegin e-pab-ebesmalbal. Tegin machimal-walbogid ilgwen Jesúsbak nadmalmo, Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tegin Jesús pel-kwapa Provincia-Galileabal pipirmadi-kual. Tenal Jesús Judio-ormaked-negmalgin kakapurwa-nuegangin tulemal-oturdadi-kus. Tegin Jesús Pab-neg-takmaidgin chunmadi-kusbal. Tegin Jesús tule-akal-akal-poni-nikmalad-nudadi-kus tegin tule-yemalad-nudadi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tenal Jesús-immal-imajadbal tulemal pel-kwapa-Siria-nap-naid-ugakche Jesús-wisgunonimal. Al tulemal Jesúszhe pel-kwapa tule-akal-akal-poni-nikmalad-cheinonimal, tule-abgan-peyedzhe-nunmamalad, tule-nia-nikmalad, tule-purkwed-nikmalad, tule-abgan-purkwalmalad. Tenal Jesús pel-kwapa we tulemal-poni-nikmalad-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tegin tulemal Provincia-Galileaginmalad, tegin Provincia-Decápolisginmalad, tegin Jerusalénginmalad, tegin Provincia-Judeaginmalad, tegin Jordán-tiwal-opakal-pukmalad Jesúsbak pél irmadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tegin Jesús takchagu tulemal-íchejul eje irmanonimal, yal-abaladzhe nakwis. Tegin Jesús chigwiszhun Pab-igalgin tulemal-oturdagal. Tegin tule-Jesúsbal-turdamalad Jesúszhe nonimalgu, ");
INSERT INTO kvnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús we tulemal-oturdakalzhun ka chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Imi tule aga ulubgin itogel, ede Pab-wagin purpal tule-wileged, ib-nued we tulega kus. Imi Pab-neg-takmaid tule-purpal-wiledimaladga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Imi tule aga ulubgin pukib-itodiil, ib-nued we tulega kus. Pabdin tule-pukib-itodimalad-pentako melle pukib-pal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Imi tule pinnallégwadgin tule-pidga immal imakel, tegin chabzhulidgin immal imajulbalil, ib-nued we tulega kus. Pabdin we tulemalga iti-nap uko neg-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Imi tule mas-kunpi-itogedyob tegin ukul-ukul-itogedyob Pab-choged-pallí pela-pela inniki nanebiel, ib-nued we tulega kus. Pabdin e-choged-pallí inniki-nanegal we tulemal-imako. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Imi tule aga ulubgin wilejakwa tule-pid-takel, ib-nued we tulega kus. Pabdin wilejakwa we tule-taknonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Imi tule aga ulubgin chwilidik pinzheel, ib-nued we tulega kus. Tenal we tule Pab-taknonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Imi meke-ibi-tule, tulemal-abalgin igal-nudadiil, ib-nued we tulega kus. Tenal we tule nug-kunonimalo, Pab-nuskan. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Imi tule nuekwa-immal-imadiidbal, tulemal chabzhul we tule-imanonimalal, ib-nued we tulega kus. Imi Pab-neg-takmaid we tulega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Imi pemal-anpal-nanimaladbal tulemal pe-izhoel, tegin tulemal sapejul pe-imadiil, tegin pegin akal-akal kakanzhemalal, ib-nued pega kus. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tenal tule chabzhul pe-imajal, pe welguenab, tegin pe ulubgin yer itogenabbal. Imi Pab-neggin pega ichejul immal-nuegan uklenoniko. Imi tulemal-pemal-imajad-yopí we tulemal-e-tadgan akpene chabzhul Pab-kaka-palchogmalad-imadi-kusmalmo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tegin Jesús chogalbal: “Imi pemal palu-nuedyob tule-iti-napkin-pukmaladga kudimal, melle neg iskugal. Tenal palu iskunonikil, keg kannan pal nudale, ibga pal kwen kunonikojul, pinche igalbal migal-nabir. Tenal anmal-tule Pabbak nuekwa nanejulil, ampa ibga kwen kunonikojulmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imi pemal iti-napkin-pukmaladga Pab-igal owisgunonimal kallen-neg-otalonaidyob. Imi neg-kwebur yal-pirgin chiil, aku pe takojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Teginbal, tule kallen ogajal, cajon-yabal chigal-chul, tenal tule keg-chulgu kallen-kalugin kallen-chimal, pel-kwapa neg otalogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tenal pemal ampa kallen-kaed-yopí pel-kwapa tulemal-wagin yer naneenabmal. Tenal pe immal-nued imadiil, tulemal pe-takchadbal pe-Pab-nikpa-neggin-maid-otummodamalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tegin Jesús chogalbal: “Tenal pe melle pinzhemalo antin, an noni Moisés-igal-mamikid ochulogal, tegin Pab-kaka-palchogmalad-chogzhad ochulogalbal. Tenal an noni Moisés-igal-mamikid nuekwa pal imagal tegin Pab-kaka-palchogmalad-chogzhadyob nuekwa pal imagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Imi an chunchunnad pemalga chogdo: nikpa-neg tegin iti-nap pelgujulil, Moisés-igal meke toto-pitchu keg pel ogwale, pél kuenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Imi meke-ibi-tule Moisés-igal-mamikid-pul-totogwad opelojal tegin tule-pimalad-oturdasbalil Moisés-igalgin-atajulgal, we tule Pab-neg-takmaidgin pul-tule-polega kunoniko. Tenal meke-ibi-tule Moisés-igal-mamikid-pallí naneel, tegin tule-pimalad-oturdakel Moisés-igalgin atagal, we tule Pab-neg-takmaidgin tule-tummadga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Tenal an chunchunnad pemalga chogbaldo: imi pemal Pariseomalga tegin Moisés-igalgin-tulemal-oturdamaladga pul tule-chwilidikid-chulil, pemal meke-igi Pab-neg-takmaidgin kwen togojul-kuo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tegin Jesús kannan chogalbal: “Imi pemal akpene itosmal anmal-tadganga choglesgus: Pe melle tule-mejo. Ex. 20:13 Tegin anmal-tadganga choglesgusbal: Tenal meke-ibi-tule, tule-mechal, we tulega-igal-itolenonikoedbal sapejul oturdalenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tenal antin-Jesús chunchunnad pemalga chogdo: imi meke-ibi-tule aga kwenadbak ulujal, we tulega-igal-itolenonikoedbal sapejul oturdalenoniko. Teginbal, tule istar-pinzheedgin aga kwenadga chogel: ‘Pedin tule-koe,’ Judio-tummagan-we-tulega-igal-itononikoedbal we tule sapejul oturdalenonimogo. Tenal meke-ibi-tule, tule-pidgin chogel: ‘Pedin kege, pe-immal-kwen-wichulid,’ we tule e-wilubganbal cho-chaglaje melledodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Al pe Pabga immal uk-nadedgin, pe Pabga-immal-kuged-kwichid-nabal pe aga ulubgin itogel pe kwenadgin nos, ");
INSERT INTO kvnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pedin ilgwen aka pe immal ebegwelo, kwenadbak aga igal-nudanegal. Tegin pe kwenadbak igal-nudajad-akar nonikil, kep pe Pabga we immal uknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Imi tule-walgwen ebi-immal-akalojadbal igal-itogedzhe pe-chedbi-kualil, pe ampa igal-itogedzhe-natapidgin pe we tulebak igal-nudakenab. Tenal pe we tulebak igal-nudaszhulil, we tule igal-itogedzhe pe-odogo. Tegin tule-igal-itoged pega igal-itojal, ilgwen chulubga pe-ukmogo oturdaleged-neggin pe-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tenal oturdaleged-neggin pe-odosmalal, an chunchunnad pemalga chogdo: imi pe pél penukchulil, pedin oturdaleged-neg-akar pal kwen noojul-kuo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tegin Jesús chogalbal: “Imi pemal akpene itosmal anmal-tadganga choglesgus: Pe melle ome-pidgin yolego, tegin omegandemo melle machered-pidgin yolemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tenal antin-Jesús chunchunnad pemalga chogdo: imi meke-ibi-tule omega-imajadyob ulubgin ome-pidgin pinzhajal, we tule pato omega we ome-imajadyobdo. Al we tule pato iskuedgin arkwas. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Imi pe-imia-nuedzhikid iskuedgin pe-egwachal, pul pe imia unko. Tegin pe-akar we imia pe tikajul meto. Imi pega pul iwen-akalzhul pebi chan-toto periengugal, pul cho-chaglaje pel-kwapa pe-chan melledgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tenal pe-chakwa-nuedzhikid iskuedgin pe-egwachal, pul pe chakwa chiko. Tegin pe-akar we chakwa pe tikajul meto. Imi pega pul iwen-akalzhul pebi chan-toto periengugal, pul cho-chaglaje pel-kwapa pe-chan melledgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tegin Jesús chogalbal: “Imi pemalga akpene choglesbaldo: Imi meke-ibi-tule aga ome-metel, we tule omega karta ukenab choggal ede ome-mete. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tenal antin-Jesús chunchunnad pemalga chogdo: imi ome-machered-pidgin-yoleszhulidbal tule aga ome-metel, wedin ib-nuedzhul. Tenal ome-melleded machered-pid-nikujal, e-machered-akpenegwad-tar-metedbal we ome pato iskunoni. Tegin we ome machered-pidgin-yolejadyob kunonijun. Tenal tule ome-melleded-nikujal, we ome-melleded-nikujadbal pato iskunonimo. Tegin we tule ome-pidgin-yolejadyob kunonimojun.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tegin Jesús chogalbal: “Imi pemal akpene itosmalbal, anmal-tadganga choglesgus: Imi pe immal-nuggin napírra-immal-chogzhal, pe melle naga chogzhad ochulogo. Tenal pe Pabga napírra-immal-chogzhal, pél pe keg-chulgu imakenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tenal antin-Jesús chunchunnad pemalga chogdo: pe melle immal-nuggin napírra-immal-chogo. Imi nikpa-negdin Pab-neg-takmaid-kanga nai-choggu, al pe melle nikpa-neg-nuggin napírra-immal-chogbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Tenal iti-naptin Pab-nag-ulukuedga nai-choggu, al pe melle iti-nap-nuggin napírra-immal-chogbalo. Tenal Jerusalén-neg-kweburdin Errey-Tummad-megwed-negga chii-choggu, al pe melle Jerusalén-nuggin napírra-immal-chogbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Imi pe keg ku-choggu, chipú-o-chichid chaglakia-kigwen imagal, al pe melle nono-nuggin napírra-immal-chogbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Tenal pemal napírra-immal-chogbiel, pe ilgwen chogenab: ‘Nabir’ o ‘Chul.’ Tenal pemal chogzhad-pallí pe imakenabbal. Tenal pemal meke-ibi-immal-nuggin napírra-immal-chogzhal, wedin ib-nuedzhul, we igal pato nia-iskana-akar tani.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tegin Jesús chogalbal: “Imi pemal akpene itosmalbal anmal-tadganga choglesgus: Imi tule pe-imia-ochuchal, pedin igal-nikamo we tulebi imia ochunnegalmo. Tenal tule pe-nugal pichijal, pedin igal-nikamo we tulebi nugal piskegalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tenal antin-Jesús chunchunnad pemalga chogdo: imi tule istar pemal-imajal, pedin melle abin-imamogo. Tenal tule pe-wagal ebiojal, ka pe wagal-konali oyobalo pe-ebiogalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tenal tule igal-itogedgin pegin yogal chubi-kualil, pe we tulega yogal uko, tegin pe we tulega chuba ukpalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tenal tule kantikidgin pe-kajal kilómetrogwen ega immal chedgal, pedin kilometrogwen-ukin pinche we tulega pe immal-chedbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tenal tule peje immal ekisdanikil, pe we tulega immal uko. Tenal tule peje immal ololchebi-kualil, pedin, pe melle we tulega chogo: ‘An pega immal kwen ukojul.’ Tenal pedin we tulega immal ukenab.” ");
INSERT INTO kvnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tegin Jesús chogalbal: “Imi pemal akpene itosmalbal anmal-tadganga choglesgus: Imi pedin aga ai-pilalguenab. Tenal tule-pebak-aichulid, pe istar takenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tenal antin-Jesús chunchunnad pemalga chogdo: imi pedin tule-pebak-aichulmalad pe pilalguenab. Tegin tule-chabzhul-pe-imadimaladga pe Pabzhe kolenabbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tenal an-pemalga-chogzhadyob pe imajal, pe-Pab-nikpa-maid-naneedyob pemal kunonimalmogo. Imi Pabdin tule-nueganga tegin tule-iskanaga tad-oge. Tegin Pab tule-immal-akalojulmaladga tegin tule-immal-akalomaladga ti owibal. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“¿Imi pemal aga aimalbi-pilalmalal, ibi-nued pega kunoniko? Keg kue. Tenal tule-Romano-tummadga-mani-egwanmalad ampa aga e-aimal-pilalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Imi pemal aga kwenamaladzhebi kolmalal, ibi-nued imas tule-pimaladga? Chulá. ¿Tenal tule-Pab-wichulmalad ampa e-kwenamaladzhebi kolmalmojulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Al pemal nuekwá naneenabmal, pe-Pab-nikpa-maid nued naneedyob. Tenal pe-Pab-nikpa-maiddin tule-nueganga tegin tule-iskanaga immal-nuegan ima.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tegin Jesús chogalbal: “Imi pe immal-nuegan imabiel, pe melle tulemal-wagin immal imako, tulemal pe-takchadbal pe-nug-otummogal. Tenal pe tulemal-wagin immal-nuegan imanail, Pabdin e-neggin pega immal-nuegan kwen ukojulmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Al an pemalga chogzhundo: imi pe tule-wiledimaladga mani uknail, pe melle tule-pinche-askinbi-nued-nanemaladyob nanemalo. Tenal tule-pinche-askinbi-nued-nanemalad tule-wiledimaladga mani ukchogalil, Judio-ormaked-neggin tegin neg-impabal kal-trompeta ogolmal tulemal wisgumalgal, emal mani uknanimal. Tenal an chunchunnad pemalga chogdo: imi tule-mani-uklenaid-takpukmalad we tule-mani-uknanimalad-otummojadbal tule-mani-uknanimaladga pato immal-nuegan uklesmal. Pabdin we tulemalga immal-nuegan pal kwen ukojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Tenal pedin, pe tule-wiledimaladga pe mani ukneel, pe melle aga aimalga choge-choge immal chogdi-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tenal pe tule-wiledimaladga otukal mani ukel, wedin ib-nued. Tenal Pab pel-kwapa tule-otukal-immal-imaked-tak-choggu, al pe otukal mani ukel, Pab pega immal-nuegan uknonimogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tegin Jesús chogalbal: “Imi pemal Pabzhe kolalmalal, pe melle tule-pinche-askinbi-nued-nanemaladyob Pabzhe kolmalo. Tenal we tulemal yer itomal Judio-ormaked-neggin-kwichi Pabzhe kolgal, tegin magadbal igalgangin Pabzhe kolgalbal, tulemal e-takchadbal e-otummogal. Tenal an chunchunnad pemalga chogdo: imi tulemal-takpukmalad we tule-Pabzhe-kolmalad-otummojadbal we tulemalga pato immal-nuegan uklesmal. Pabdin we tulemalga immal-nuegan pal kwen ukojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Al an pemalga chogzhundo, pemal Pabzhe kolzhogalil, pedin, pe-neg-kabed-yabal pe togo, tegin pe wanagak chaktio, tegin pe Pab-otukal-maidbak pe apinni chunmako. Tenal an-chogzhadyob pe Pabzhe kolel, wedin ib-nued. Imi Pab Tummad pel-kwapa tule-otukal-immal-imaked-tak-choggu, al pe otukal Pabzhe kolel, Pab pega immal-nuegan uknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Tenal pe Pabzhe kolalil, pe melle kannan-kannan immal pio, tule-Pab-wichulmaladyob. Tenal tule-Pab-wichulmaladdin ebinzhemal kannan-kannan-kolnaidgin Pab kep e-itogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tenal pemal melle tule-Pab-wichulmaladyob kumalo. Tenal pe ampayo Pabzhe koleddu, pe-Pab pato pe-wiis ibi pe napi kujii. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Al pemal Pabzhe kolbiel, pe weob Pabzhe kolmalo: Anmal-Pab-nikpa-neggin-maidye, imi tulemal pegin chogmalalen, nabirin: Pe-nugdin chwilimakalye. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tenal pe-neg-takmaid nonikilen, nabirbalinye. Tenal nikpa-neggin pe-itolegedbal pél immal-kunaidyob, iti-napkin pél immal-kunaimogalen, nabirbalinye. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Imi pe anka imisga mas-kunned ukoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pabye, imi tulemal-ankin-walmajadbal an nega iskued pelgus chogzhadyob, an-pegin-walmajad pe anka pelgus chogmogoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Imi pedin wilub-takleged-naidzhik, pe melle an-palmioye. Tenal an-iskuedgin-yoledanikid-akar pe an-onobaloye. (Imi pedin ilagwen-nadgu pél neg-takmaiye. Tegin pe pel-kwapa-kannaleged nikabalye, tegin pe nug pela-pela okannolenonibaloye. Pitogua.)” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tegin Jesús chogalbal: “Imi tule pegin walmajal, tenal pe we tule-pegin-walmajadga pelgus chogzhal, Pab-nikpa-maid pega iskued-pelgus chogmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tenal tule pegin walmajal, tenal pe we tule-pegin-walmajadga pelgus kwen chogzhajulil, Pab-nikpa-maiddin pega iskued-pelgus kwen chogojulmo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tegin Jesús chogalbal: “Imi pemal mas-kunchulidgin Pabzhe kolalmalal, pe melle tule-pinche-askinbi-nued-nanemaladyob, wagal-pukib taklego. Tenal we tulemal yami pukib-itogedyob aga wagal imamal tulemalga oyogal, emalde mas-kunchulidgin nanedimal. Tenal an chunchunnad pemalga chogdo: imi tulemal-takpukmalad tule-mas-kunchulidgin-nanemalad-otummojadbal we tulemalga pato immal-nuegan uklesmal. Pabdin we tulemalga immal-nuegan pal kwen ukojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Al an pemalga chogzhundo, pemal mas-kunchulidgin Pabzhe kolalil, pedin kusgu igal-mamikidyob aga nonogin kwallu imamalo. Tegin pe tigin aga wagal enuko, pe melle pukib-taklegal, ");
INSERT INTO kvnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tulemal melle mag pe-takmalgal pe mas-kunchulidgin nanedimal. Tenal Pab-otukal-maiddin pe-wisguo, pe mas-kunchulidgin kudii. Imi Pab Tummad pel-kwapa tule-otukal-immal-imaked-tak-choggu, al pe otukal mas-kunchulidgin Pabzhe kolel, Pab pega immal-nuegan uknoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tegin Jesús chogalbal: “Imi pemal iti-napkin melle twagdar aga tukinga immalmal-nuegan chabogo. Tenal iti-napkin immal chama, tegin chumal immal-mabal. Chulil, tule-immal-aturzhemalad tognonimalo pebi immalmal aturzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tenal pemal alamamalo Pab-neggin immalmal-nuegan chabogal. Tenal Pab-neggindin immalmal keg pel chama, tegin chumal keg pel immal-mabal. Tegin Pab-neggin tule-immal-aturzhemalad keg pel togmal immal aturzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Imi pe-immalmal Pab-neggin pega chabolejiil, pe Pab-neggin pinzhedago. Tenal pe-immalmal iti-napkin pega chabolejiil, pe iti-napkinbi pinzhedago.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tegin Jesús chogalbal: “Imi pe-imia pe-changa kallen-neg-otalonaidyob. Tenal pe-imia nuedil, pe-chan pel-kwapa mag immal tak. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tenal pe-imia iskunonikil, pe-chan aku-ata peimogo, neg-chichidgin kudiidyob. Tenal pe-imia pe-chan kwen otalojulil, wedin immal-peyedzhe, pe-chan ilgwen chichidbi peimogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tegin Jesús chogalbal: “Imi tule walbo keg tummagan-nikuel. Tenal pe keg-chulgu tummad-walgwen-yer-taknoniko, tenal pe tummad-pid-istar-taknoniko. Chulil, pe tummad-walgwen-choged-pallí immal imanoniko, tenal pe tummad-pid-choged-pallí immal kwen imanonikojul. Al pemal keg Pab-walbo nanemalal. Tenal pemal walkwénna chuenabmal pe-tummadga kugal, Pab Tummad o mani.” ");
INSERT INTO kvnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tegin Jesús chogalbal: “Al an pemalga chogzhundo: pe melle pukib-itomalo, pe igi mego-dewa, pia pe mas-kunned amio-dewa, pia pe kobed amibalo-dewa. Tenal pemal melle pukib-itodamalbalo pia pe mol amio-dewa wis yogal. ¿Imi tule-tula-kudiil, pul chunchogedzhulzhí pul mas-kunnedga? ¿Tegin tule-chan pul chunchogedbalzhulzhí pul mol-yomaladga? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Imi pe takto chikwi-chapurbalid immal pel tigzhulmal. Tenal chikwimal immal pel weichulmal chabogal, tegin neg kwen nikchulmalbal immalmal chabogal. Tenal pe-Pab-nikpa-maiddin yabli chikwimalga mas-kunned uk. Tenal pemal pulzhun. ¿Imi pemal chikwimalga pul tule-nuedzhulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Tenal toa peyedzhe-pukib-itogedbal unniguo wachilgwen e-purkwed okpingal? Chulá. Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Tede pemalde ibiga molmalbal pukib-itomalzhun? Imi pe takto, chapur-tudmal a-ito chunnemal. Tenal we tudmal kwen arpajulmal, tegin kwen purrejulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tenal an pemalga chogzhundo: Errey-Salomón-e-mol pul yer taklegendo, tenal tud pul-pule yer takle. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tenal tud-chapurbalid imis tula, tenal tud nue-naojul achurmanoniko tegin apato. Tegin tulemal ilgwen chogin tud okummanonimalo. Tenal Pab molyob yer tud-oturpama. ¿Imi pemal-nue-Pabgin-ibzhejulmalad, Pab pul-pule pemalga mol ukojulzhí yogal? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Al Pab yer pe-takedbal pe melle pukib-itogedgin chogdago: ‘¿Imis ibi an kunno, imis ibi an kobo?’ O chulil, ‘¿Pia an mol amio an yogal?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Imi tule-Pab-wichulmalad unnila pane-pane alamananimal we immalmal nikugal. Tenal pe-Pab-nikpa-maiddin pemal-nued-wismal ibi-immal pe napi kujimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Tenal pemal kepegin alamakenabmal Pab-neg-takmaid-immalmalgin pinzhegal. Tegin Pab-inniki-immal-imakedyob pemal alamakenabmalbal immal imagal. Tenal pemal Pab-chogzhadyob alamasmalal, pél pe-immal-napi-kujiid: mas-kunned, kobed, mol pega uklego. ");
INSERT INTO kvnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Al an pemalga chogzhundo: pan-pega-immal-kuoedgin pe melle pukib-itogo. Panga ampa ibe-nika pe wegin pinzhegal. Tenal pemalga keg-chulgu ibe-ilbal poni nononidaed.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tegin Jesús chogalbal: “Imi pemal melle yogasal tule-pidgin chogdago: ‘We tule immal-akalos,’ Pab pegin melle chognonigalmo: ‘Pedin iskusmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tenal pe tule-pidgin chogzhad-unni, pegin choglenonimogo, pedin iskus o chul. Tegin pe tule-pidga igal-mezhijad-unni pega choglenonimogo pedin iskus o chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Imi pe takchal, pe-kwenad aku-atagedbal iche immal wis akalos, tule imiagin turwa-totó megwijadyob nuekwa immal takchul. ¿Tede pe ibiga istar we kwenadgin chunmanonidadé? Tenal pedin aga aku-itomo pe peyedzhe immal-akalodiid, tule imiagin chowal-kia-maidyob aku aga pe tak. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Tede pe igi kwenadga chogo: ‘An pe-imiagin turwa-maid an pega wis chuo?’ Keg kue. Tenal pe imiagin chowal-uka-tummad maimo. Tenal pemal peyedzhe immal-akalojadbal keg aga pe-kwenad-penta iche-e-immal-akalojad nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“¡Imi pemal, pinche-askinbi-nued-naneed-tulemal! Tenal pemal-inzhel aga pe-taed nudakenabmal. Tenal pe aga taed nudajal, kep pe unniguo aga pe-kwenad-pentagal e-taed nudagalmo, tule aga e-imiagin chowal-kia-maid chujal, kep unniguo aga e-kwenad imiagin turwa-maid chugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Imi tule-istar-Pab-igal-takmaladga, pe melle Pab-igal-pul-nuegan chogo, we tulemal melle pegin urwenonimalgal, pe achu-urwechilganaga-immal-uknaidgin, achu pe-kunnonikoedyob. Tegin tule-iskuedginbi-nanebimaladga, pe melle Pab-igal-pul-nuegan-chogbalo, we tulemal melle atajulidgin Pab-igal izhononimalgal, pe chinga perlas ukchadgin, chinmal pél perlasgin annemaloedyob.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tegin Jesús chogalbal: “Imi pemal Pabzhe immal ekismalal, Pab pega uko. Tenal pemal Pabzhe immal aminanimalal, pedin we immal onomalo. Tenal pemal Pabzhe pali-pali kolmalal tule-wanagakkin-kolnanikidyob, Pab pe-itogo, tule pega wanagak egenonikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Imi meke-ibi-tule Pabzhe immal ekisnail, we tule keg-chulgu immal-ekisnaid nikunoniko. Tenal meke-ibi-tule Pabzhe immal aminail, we tule keg-chulgu we immal onogo. Tenal meke-ibi-tule Pabzhe pali-pali kolnail tule-wanagakkin-kolnaidyob, Pab keg-chulgu we tule-itogo, tule pega wanagak egajadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Imi pe-machi peje madu ekisdanikil, pe machiga akwa uko? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Teginbal, ¿pe-machi peje ua-ekisdanikil, pe machiga nakpe-uko? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Imi pemal tule-iskanagwando, tenal pemal yabli wiis aga nuskanga immal-nuegan ukegal. Tenal pe anmal-Pab-nikpa-maidzhe immal ekisnail, Pabdin pul-pule pemalga immal-nuegan uko. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Imi pe igi-peigujídin tule pega immal ima, pemal ampa teopí tule-pimaladga pel-kwapa immal imamogo. Tenal an-pega-chogzhadyob pe naneel, pedin pel-kwapa Moisés-igal-pallí pato imas, tegin Pab-kaka-palchogmalad-pel-kwapa-chogzhad-pallí pato pe imasbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tegin Jesús chogalbal: “Imi tulemalga igal-chogbo mai, wanagak-alikwagwad, tegin wanagak-tummad. Tenal pemal wanagak-alikwagwadbal pe togenabmal, tenal pe melle wanagak-tummadbal pe togmalo. Tenal pemal wanagak-tummadbal pe togzhamalal, pe pulejul igal-tummadbal irmadmalo. Tenal we igal cho-chaglaje-naoed-igal, ilgwen pelgugal. Tenal tulemal-ichejul we igalbal pul naddamal. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Tenal pe wanagak-alikwagwadbal pe togzhamalal, pega tutujul igal-alikwagwadbal negal. Tenal igal-alikwagwaddin Pab-neggin-ilgwen-tulleged-igal. Tenal tulemal-walpókwajal we igalbal pul naddamal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tegin Jesús chogalbal: “Imi pe wijirmal, nue aga pe takermal, tule-Pab-kaka-palchoged-chunchunnadzhulmaladzhe. Tenal we tulemal tule-nueganyob pemalzhe nonimalo, oveja-nuedyob. Tenal we tulemal ulubgin neg-izhoedgin pinzhemal, achu-kwegwed oveja-kuntanikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Tenal pemal e-taedbal mag we tulemal-taknonimalo, tule mag chapi-chan takedyob. ¿Imi pe nabir chapi-iko-nikadgin pe uva-chan onogo? Chulá. ¿Tenal pe nabir takegin pe wag-islub-chan onobalo? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Imi chapi-nuegan ampa e-chan-nuegan chanmamo. Tenal chapi-iskanadin e-chan-iskana chanmamo. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tenal chapi-nuegan keg chan-iskana chanma. Tenal chapi-iskanadin keg chan-nuegan chanmamo. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Imi pe takalil chapi keg nuekwa chanma, ilgwen pe olao, tegin pe chogin okummako. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tenal chapi-chanmakedyob pemal mag e-istar-taedbal Pab-kaka-palchoged-chunchunnadzhulmalad-taknonimalmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tegin Jesús chogalbal: “Imi tulemal ‘Tummad’ anche kolmal, tenal we tulemal-wal-walgwen an-chogzhad-pallí-kwen-nanedijulidbal Pab-neg-takmaidgin kwen togojulmal. Tenal tulemal-Pab-nikpa-maid-choged-pallí-nanemaladbi unnila Pab-neg-takmaidgin togmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Imi te ibe-nonikoedgin tule-Pab-chogzhad-pallí-immal-imaszhulmalad-ichejul anka chognonimalo: ‘Tummadye, ¿anmal pe-nuggin Pab-kaka-palchogdi-kuszhulzhí? ¿Tegin anmal pe-nuggin tulegin niamal-onidi-kuszhulzhí? ¿Tegin anmal pe-nuggin ichejul immal-taktijulmalad imadi-kusbalzhulzhí?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tenal antin-Jesús tule-an-chogzhad-pallí-imaszhulmaladga chogdago: ‘An wichí pe ibi-tule. Pemal-immal-akalomalad, pe ankin ilgwen nemalo.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tegin Jesús chogalbal: “Imi tule-an-kaka-itosmalad tegin an-chogzhad-pallí immal-imasmalad, neg-wismalad-tule. Tenal we tulemal akwapir-askin akwa-neg chobzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tegin ti pela-pela winonigu, ti nos. Tegin purwa te neggin pela-pela kolnonibal. Tenal we neg akwapir-tar-kanikidbal kwen aglaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Tenal tule-an-kaka-itosmalad tenal an-chogzhad-pallí kwen immal-imaszhulmaladdin, immal-kwen-wichulmalad-tule. Tenal we tulemal ukubgin akwa-neg chobzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tegin ti pela-pela winonigu, ti nos. Tegin purwa neggin pela-pela kolnonikidbal, we neg ilgwen ayarid. Al pemal an-kaka-itosmalal, ampa an-chogzhad-pallí pe imakenabmal. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tegin Jesús pél chunmasgu, tulemal Jesús-chunmajadbal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ade Jesúsde chunchunnad igal-nikadgin tulemal-oturdadi-kus, tule-Moisés-igalgin-tulemal-oturdamaladyob chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tegin Jesús yal-akar aktenonigu, tulemal-íchejul Jesúsbal irmadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tegidgin tule-lepra-poni-nikad Jesúsgin-atagedbal Jesús-abir chimtinoni ka chogal: —Tummadye, imi antin kwen penzhuldo pedin unni an-nudagal. Al pe an-nudabiel, akalzhul pe an-nudakoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tegin Jesús tule-lepra-poni-nikadgin chunkal mezhisgu, tule-yeedga chogal: —Tegil nueddo. Imisgin pe nugudo. Tegidgin tule-lepra-poni-nikad ilgwen nuguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tegin Jesús tule-lepra-poni-nika-nadga chogal: —Imi pedin akalzhul nao. Tenal pe melle tule-pimaladga pe palchogo antin pe-nudas. Tenal pe ilgwen tule-irwal-Pabzhe-koledzhe aga pe-chan oyonao. Tegin pe tule-irwal-Pabzhe-koledga pe chogo: ‘Antin nugus.’ Tenal Moisés-igal-mamikidbal pe immal chedbalo Pab Tummadga ukegal, tulemal wisgumalgal pedin chunchunnad nugus. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tegin Jesús neg-kwebur-Capernaumzhe nonigu, Romano-chulub-tummad-e-chapingan-wala-tulaatal-nikad, Jesúszhe wilenoni e-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tegin chulub-tummad Jesúsga chogal: —Tummad, an-mos-walgwen yee-pakal mai. Imi we mos abgan-purkwaled nai tegin abgan pela-pela nunumamaibal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tegin Jesús chulub-tummadga chogal: —An imis peje natapo pe-mos-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tegin chulub-tummad Jesúsga chogal: —Tummad, imi an kwen unnijul an-neggin pe-abingegal. Al an peichul pe an-negzhe ne. Imi wegin pe chii pe chogzhal an-mos nuguo, an-mos keg-chulgu nuguenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Imi antin, an tummad-nikamodo, tenal an tummad-ulpallí nanemo. Tenal an chapingan-nikmodo. Tegin an chapin-walgwenga chogzhal: ‘Pe nao,’ we chapin keg-chulgu neenab. Tegin an chapin-pidga chogzhabalil: ‘Pe tago,’ we chapin keg-chulgu anche tagenab. Tegin an naga mosga chogzhal: ‘Weob pe immal imako,’ we mos keg-chulgu an-chogzhadyob immal imakenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tegin Jesús chulub-tummad-chogzhad itosgu, weob pakal pes. Tegin Jesús tule-ebal-irmadimaladga chogalzhun: —Imi an chunchunnad pemalga chogdo: imi meke-pia we tule-ankin-penzhulidyob an tule-kwen-taktijul, Israel-napche-pakal pel chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Imi an chunchunnad pemalga chogzhundo: Judiojulmalad-ichejul tad-nakwedbal tegin tad-arkwanedbal nonimalo. Tenal we Judiojulmalad Pab-neg-takmaidgin tadgan-Abrahambak, Isaacbak tegin Jacobbak mes mas kunmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tenal Judiomal-Pab-neg-takmaidgin-toged-wilubmalanaddin neg-magadbal onoledo, neg-chichidzhe. Tenal we Judiomal neg-magadbal peyedzhe pononimalo tegin peyedzhe-wilejiidbal nugal kotamalbalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tegin Jesús chulub-tummadga chogal: —Imisgin pe negzhe naddo. Imi pe ankin penzhul-kujadyob, an pega mos-nudanemo. Tenal Jesús-chogzhad-wachigin chulub-tummad-e-mos ilgwen nugunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tegin Jesús Pedro-negzhe nonigu, Pedro-e-chak-ome-taknoni, pela-pela uged tarmamai. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tegin Jesús Pedro-chak-ome-e-chunkal ebusgu, uged-tarmanaid ilgwen akis. Tegin Pedro-chak-ome ilgwen kwisgudgu, Jesúsga immal chaalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tegin neg-chedogusgu, tulemal Jesúszhe ichejul tule-nia-nikmalad-cheinonimal. Tenal Jesús e-chunmakedbalbi tulegin niamal-onis. Tegin Jesús pel-kwapa tule-yemalad-nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Imi Jesús tule-yemalad-nudajad, akpene Pab-kaka-palchoged-Isaías-chogzhad-yopí kunoni. Tenal Isaías chogzhado: Imi we tule aga tukin anmal-anal poni chus. Tegin we tule anmal-anal immal-nunmaked itosbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tegin Jesús takchagu tulemal-ichejul e-ebiris pukwa, Jesús aga e-chapinganga chogal: “Nemal, mata-opakal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tegidgin Moisés-igalgin-tulemal-oturdaked-walgwen Jesúszhe noni. Tegin we tule Jesúsga chogal: —Tule-oturdaked, pia pe naódin, an pebak nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tegin Jesús we tulega chogal: —Tenal pe nuekwa pinzhegenabgwel. Imi chug-achu nap-ya nika meggal, tegin chikwimal u nika-nemalmo, meggal. Tenal an-Te-Tule-Chunnadin neg pel nikchul wis ulukugal. ¿Imi pe anyob unnigumogo neg-nikchul nanegal? Imi pe unnimogal, pe akalzhul anpak nemogodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tegin tule-Jesúsgin-turdaked-pid Jesúsga chogalmo: —Tummad, an pilal naga pab-taknegwelo. Tegin an-pab-purkwijad-cholbal, kep an pebak nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tenal Jesús we tulega chogalzhun: —Tenal pedin anpak neenab ankin turdagal. Tenal tule-purkwemaloed meke tule-purkwaled-e-mui tigmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tegin Jesús ulgin nakwisgu, e-chapingan ulgin nakwismalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tegin Jesús-nadmalad-cholbal apka-pakal neg-atigalgu, purwa sapejul kolnoni. Tegin mata-arwemaidbal ulzhe ti milegal. Al ul togdani-pes. Imi teun Jesús ul-yagin purkwal-kabmai. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tegin e-chapingan Jesúszhe abarmanonimal Jesús-otagal. Tegin e-chapingan Jesús-otasgu, Jesúsga chogalmal: —¡Tummad, atama, atama! Anmal-ul togdani. Anmal-abonoma. Anmal ogangudanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tegin Jesús atagalgu, aga e-chapinganga chogal: —¿Ibiga pe twagdar tobermal-wede? ¿Ibiga pe Pab-penmal-wede? Pemal weob kued-wilubzhulmal. Tegin Jesús kwisgusgu, kep purwaga tegin mata-arwedga chogal: —Pe wis pogiguma. Tegin purwa ilgwen poki nad, tegin mata ilgwen chiale-pesmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tegin Jesús-e-chapingan takchagu Jesús purwa tegin mata opogichas, weob pakal pesmal. Tegin Jesús-e-chapingan aga emal-emal chogalmal: —¿Ibi-tule-wede? Imi purwa tegin mataje-pakal we tule-choged-pallí ibzhe. ¿Tegil we Jesús purwa-ibeddé? ");
INSERT INTO kvnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tegin Jesús mata-opasgu, neg-kwebur-Gadara-omopen omosmal. Tegin Jesús ulgin-akar napche aktesmalgu, tule-nia-nikmalad-walbo uan-akar Jesúszhe nonimal. Tenal tule-nia-nikmalad pela-pela urwebukmal, al tule keg kin pel neel. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tegin tule-nia-nikmalad kolomakal Jesúsga chogalmal: —Pab-Machiye, ¿ibiga pe anmalgin yoledani-wede? ¿Imi pe yo wilub omoeddu, pato pe sapejul anmal-imadaniyé? ");
INSERT INTO kvnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Imi teun takalgu, te-akar nue pannajul chinmal-íchejul mas mabukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tenal niamal Jesúszhe wilegalmal, chogalmal: —Imi pe tulegin anmal-onineel, antin, an pei pe chinmalgin anmal-odogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tegin Jesús niamalga chogalzhun: —Tegil pe akalzhul chingin togmalodo. Tegidgin niamal tule-walbogidgin nosmalgu, chingin ukpotapmalzhun. Tegidgin chinmal-pel-kwapa koelegalmalgu, ilgwen pulal turmadmal. Tegin chinmal yal-urchikal-kwichidgin mataje apatismal. Tegin chinmal tigin pél ogangusmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tegidgin tule-chin-takpukmalad neg-kweburzhe abarmadmal. Tegin tule-chin-takpukmalad neg-kwebur omosgu, tulemalga pél palchogzhajun, chin igi ogangujad. Tegin tule-chin-takpukmalad palchogzhamalbal Jesús igi tule-nia-nikmalad-nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tegin tulemal-neg-kweburginmalad itosmalgu tule-nia-nika-nad nugus tegin chinmal ogangusmal, pel-kwapa Jesús-abin-almal. Tegin tulemal Jesús-abingusmalgu, Jesúszhe wilegalmal ka chogalmal: —Jesús, pe anmal-neg-akar pe kannan neenab. Tegin Jesús ulgin nakwisbalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tegin Jesús ulzhe nakwisbalgu, kannan mata opakalbal aga e-neg-kweburzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tegin Jesús aga e-neg-kweburzhe nonigu, tulemal kachigin Jesúszhe tule-abgan-purkwaled-cheinonimal. Tegin Jesús takchagu tule-cheinonimalad egin kwen penzhulmal, Jesús tule-abgan-purkwaledga chogal: —Machi, pe welguma. Pe-iskued pato pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tegin Jesús chogzhagu we tule-e-iskued pelgus, Moisés-igalgin-tulemal-oturdamalad-wal-walgwen aga ulubgin pinzhealmal: “Imi Jesús tulega iskued-pelgus-chogzhadgin Pab Tummadgin walmas.” ");
INSERT INTO kvnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tenal Jesús ulubzhe mag tule-tak-choggu, al Jesús pato wiis tummagan igi ulubgin pinzhebukmal. Tegin Jesús tummaganga chogalzhun: —¿Ibiga pe ulubgin istar pinzhebukmal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Pemal ebinzhemal antin keg tule-iskued eli? Tenal an we tulega chogzhal: ‘Pe-iskued pelgus,’ we tulega yabli iskued pelguenab. ¿Imi ibi pul-pulejul? ¿Tule-yeed nudaked o tule-iskued-elied? Wedin pog-pel ibi-puled. Al an unnigujal tule-yeed nudagal, an unnigumogo tule-iskued eligalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Al pemal mag takegal an-Te-Tule-Chunna iti-napkinga igal-nika tule-iskued eligal, an imisgin tule-yeed-nudanejun. Tegin Jesús tule-yeedga chogalzhun: —Machi, imisgin pe kwisgudo, aga pe kachi olma. Imisgin pe naddo negzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tegidgin tule-abgan-purkwale-nad ilgwen kwisgusgu, aga negzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tegin tule-takpukmalad tule-nugujad-takchagu, tobgualmal. Tenal tule-takpukmalad mag takchamalbal Pab Tummad tulega igal-ukcha tule-iskued eligal. Al tulemal-takpukmalad Pab-Tummad-nug otummoalmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tegin Jesús tule-nudajad-akar ukin nadgu, tule-Mateo-nugad-takal, Romano-tummadga-mani-egwaned-neggin-chii tulemalgin-mani-egwannai. Tegin Jesús Mateoga chogal: —Anpak nemalma ankin turdagal. Tegin Mateo Jesúsga chogal: —Tegil nabirde. Tegin Mateo kwisgudgu, ilgwen Jesúsbak nadzhun Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tegin Jesús Mateo-neggin mas-kunpukwadgin Romano-tummadga-mani-egwanmalad tegin tule-iskued-nikmalad-pimalad íchejul nonimalmo. Tegin tule-iskana Jesúsbak tegin Jesús-e-chapinganbak mes mas kunnonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tegin Pariseomal takchagu Jesús tule-iskanabak mes mas kunchii, Pariseomal Jesús-e-chapinganzhe ekichialmal: —¿Ibiga pe-oturdaked Romanoga-mani-egwanmaladbak tegin tule-iskued-nikmalad-pimaladbak mes mas kunpukmal-wede? Wedin ib-nuedzhul. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tegin Jesús Pariseo-chunmanani itosgu, Pariseomalga chogal: —Imi tule-yemaladdin ina-tuled-napimal, tenal tule-poni-nikchulmalad ina-tuled-kwen-napijulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tenal pemal turdakenabmal Pab-kartagin ibi chog-wede. Tenal Pab-kartagin chogdo: Imi antin, an pei, pe wilejakwa tule-tak, pe pul kugedgin anka immal ukedga. Os. 6:6 Tegin Jesús chogalbal: —Imi antin, an noni, tule-iskued-nikmalad-amigal, tule-nuegan-amigal chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tegin Juan-Bautista-e-chapingan Jesúszhe nonimalgu, Jesúszhe ekichialmal: —¿Ibiga anmal tegin Pariseomal mas-kunchulidgin nanemal, tenal pe-chapingandin mas-kunchulidgin kwen nanejulmal? ");
INSERT INTO kvnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tegin Jesús Juan-e-chapinganga chogal: —Nabir. Imi an purpal pemalga chogdo: ¿imi tule-ome-nikunail, machi-ome-nikuneed ampa chiidbal, tule-irmanonimalad pukib-itogo pe ebinzhe? Chulá. Tenal machi-ome-nikuneed tulemal tarbi chesmalal, we tulemal mas-kunchulidgin kep nanedamalo. Imi tulemal an-chesmalal, an-chapingan kep mas-kunchulidgin nanemalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tegin Jesús purpal tulemalga chogal: “Imi tule mol-mukwagin mol-koa-pin kwen matamajulmal. Tenal tule an-chogzhadyob mol-mukwagin mol-pin-matamakelen, mol kaledel, mol pul-pule isloen.” ");
INSERT INTO kvnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tegin Jesús purpal immal-pid chogalbal: “Imi pemal wismal, puglu-moli-ukagad ilkwénna wis ebule inna-kabil chigal. Al tule keg ku puglu-ebugaledgin inna-kabil-pin chigal. Imi tule puglu-ebugaledgin inna-kabil-pin chielen, inna-pin kakpi-kudel, puglu-ebugaled arpídel, ilgwen marroen. Tegin inna-kabil pél perienguoen, tegin puglu-moli-ukagad iskubaloen. Al tulemal puglu-moli-ukagad-pingin inna-kabil-pin chimal. Tenal puglu-moli-uka-pinil, tegin inna-kabil-pinmogal pog-pel kwen iskuojulmal. Al tule-igal-pin igal-cheredbak keg kumo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tegin Jesús ampa chunma-kwichidgin Judio-ormaked-neg-e-tummad-walgwen Jesús-abir chimtinoni. Tegin we tummad Jesúsga chogal: —Imi an-chiskwa imis-imis purkwis. Tenal pe an-negzhe nadel tegin pe chunkalgin an-chiskwa-ebujal, an-chiskwadin kannan tullego. Tegin Jesús Jairoga chogal: —Tegil an pebak naodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tegin Jesús kwisgudgu, aga e-chapinganbak mes tule-tummadbak nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tegin Jesús-natapidgin ome-walgwen pirkaambe-kakabogus aga e-purpa-takedbak-imadiid natapmo. Tenal we omedin yankalbal-akar Jesús-e-mol-tuku ebus. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tenal ome aga ulubgin pinzhas: “An Jesús-mol-tuku ebujal, antin ilgwen nuguo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tegidgin Jesús omezhik akpiridgu, ome-takal kwichi. Tegin Jesús omega chogal: —Puna, pe welguma, pe ankin penzhul-kujadbal, pe ilgwen nugus. Tegidgin omega poni ilgwen akunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tegin Jesús Judio-ormaked-neg-e-tummad-negzhe omosmal. Tegin Jesús neg-yabal tognatapku, pato taknatap tulemal-kal-ogolmalad pukwamal, tegin tule puna-purkwijadga okormananimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tegin Jesús tule-pukmaladga chogal: —Pemal pe we-akar aknimalo. Imi we puna kwen purkwiszhul, pinche kabmai. Tegin tulemal-aka-tégin-pukmalad Jesúsga allialmal chogalmal: —Pinche pe chunmama. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tegin tulemal magarbal aknismalgu, Jesús kep puna-purkwal-maidzhe togzha. Tegin Jesús chunkalgin puna-kasgu, puna Jesúsga kwisgual. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Imi Jesús puna-otulojadbal neg-kweburgan pel-kwapa wisgunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tegin Jesús puna-nudajad-neg-akar nosgu, walbo tule-aku-ataged Jesús-cholbal kolmanatapmal chogalmal: —David-wagwaye, pe wilejakwa anmal-takelen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tegin Jesús negzhe togzhagu, we tule-walbogid-aku-ataged Jesúszhe nonimal. Tegin Jesús tule-walbogidzhe ekichialzhun: —¿Imi pemal penzhulmal antin unni mag-atagal pe-imagal? Tegin tule-walbogid Jesúsga chogalmal: —Tummad, pedin unnido, mag atagal anmal-imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tegin Jesús tule-walbogid-imia ebusgu, ka chogalbal: —Nabir. Imi pe ankin-penzhul-kujadbal pemal mag atanonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tegidgin tule-walbogid mag atanonimalzhun. Tegin Jesús kantikidgin tule-walbogidga chogal: —Pe melle tule-pimaladga an-palchogo, an pe-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tenal tule-walbogid nadmalgu, neg-kwebur-ilbal pel-kwapa palchogzha Jesús e-nudajad. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tenal tule-mag-atanonimalad nadmalgu, tulemal Jesúszhe tule-nia-nikadbal-keg-chunmaked-cheinonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tegin Jesús tulegin nia-onosgu, we tule nabir chunmanoni-pes. Tegin Jesús-tulegin-nia-onojadbal, tulemal weob pakal pesmal. Tegin tulemal chogalmal: —Imi an Israel-napkin weob immal kwen taktijul. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tenal Pariseomal kakanzheedgin Jesúsgin chogalmal: —Imi nia-tummad-Jesúsga-igal-ukchadbal, Jesús tulegin nia-oni. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tegin Jesús neg-kwebur-tummaganzhe tegin neg-kwebur-purwiganaje nad. Tegin Jesús kep neg-kweburgangin Judio-ormaked-negmalgin Pab-igalgin tulemal-oturdadi-kus, tegin Pab-neg-takmaid-kaka-nuegangin chunmadi-kusbal. Tegin Jesús tule-akal-akal-poni-nikmalad-nudas, tegin tule-akal-akal-yemalad-nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tenal Jesús takchagu tulemal-ichejul eje irmanonimal, Jesús takchado, we tulemal pukib-itomal tule-kin-immal-akalojadyob. Tenal we tulemal tule-kwen-nikchulmal e-pentagal, ovejamal tule-e-taked-nikchulmaladyob. Al Jesús ulubgin wilejakwa we tulemal-taknonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tegin Jesús aga e-chapinganga chogalzhun: —Imi immal-kwa ichejul-nai weigal, tenal tule-walpókwa nika we immal-kwa weigal. Wedin purpal pemalga choglejundo: imi tule-ichejul nika Pabbak naigugal, tenal tule-walpókwa nika Pabga wis arpagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imi Pab-immal-kwa-weied-e-Tummadga maidbal, pe Pab Tummadzhe ekismalo tulemal-palmidagal, Pabbal-naigugal tule-imagal, tule immal-kwa weiedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tegin Jesús aga e-chapingan-walambe-kakabogwadzhe kochagu, e-chapinganga igal-ukcha tulegin niamal-onigal, tegin tulemalgin pel-kwapa poni-nikmalad-nudagal, tegin e-chapingan tule-yemalad-nudagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Imi Jesús-nuggin-palmilegalid-walambe-kakabogwad nug-nemal: kepegin Simón, (we Simón pimalbal Pedro), tegin Pedro-e-urpa-Andrés; tegin Jacobo tegin Jacobo-e-urpa-Juan. Tenal we tule-walbogiddin Zebedeo-e-machimal; ");
INSERT INTO kvnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tegin Felipe, Bartolomé, Tomás tegin akpene-Romano-tummadga-mani-weied-Mateo; tegin Alfeo-machi-Jacobo, tegin Tadeo, ");
INSERT INTO kvnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tegin Romano-tule-onobied-Simón, tegin Judas-Iscariote. Tenal we Judas-Iscariotedin manibal Jesúsgin-akpinnoed. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tegin Jesús ampayo aga e-chapingan-walambe-kakabogwad-palmieddu, ka chogal: “Imi pemal nadmalal, pe melle Judiojulmaladzhe pe nemalo, tegin pe melle Samaritano-tule-e-neg-kweburganzhe pe togmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tenal pemal Israel-tule-oveja-owelejadyob-kudimaladzhebi pe unnila nemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Tenal pemal nadmalal, pe tulemalga chogmalo: ‘Imi Pab-neg-takmaid pato pemal-omodani.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tenal pemal tule-yemalad-nudamalo, tegin pe kannan tule-purkwismalad-otulogo. Tegin pe tule-lepra-poni-nikmalad-nudamalo, tegin pe tulegin niamal-onimalbalo. Imi pemal manigin we kannaleged abingaszhulmal-choggu, al pe tulemalga pinche immal imamalmogo, melle manigin. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Tenal pe nadel, pemal melle ol chedo, tegin pe melle mani chedo, tegin pe melle mani-kollogana chedbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tegin pe melle muchila chedo, tegin pe melle mol-ogwaged chedo, tegin pe melle kutar-ogwaged chedbalo. Tegin pe melle kabaston chedbalo, pe chunkal-kwabi pe nemalo. Tenal pemal arpagedbal igal-nika akwelegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Imi pemal neg-kwebur-tummad o neg-kwebur-totogwad omojal, pe tule-nued amimalo e-neggin meggal pe-naoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tenal pe tule-maid-negzhe pe tognatapil, pe chognatapo: ‘Anná, tegidde. Imi Pab pe-pentakelen, nabirin.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tenal pe-neg-togzhadgin tule nuedil, pe we tulega chogzhad-yopí kwen kunoniko. Tenal pe-neg-togzhadgin tule nuedzhulil, pe-we-tulega-chogzhad-yopí kwen kunonikojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Tenal tule yapa pe-abingeel, o chulil, yapa pe-itogel, pedin we neg-akar pe nao. Tenal neg-kwebur yapa pe-abingebalil, o chulil, yapa pe-itobalil, pedin we neg-kwebur-akar pe nao. Tenal pe we neg-akar nadel, pe kutargin nap-pur-naniid pe opat-opat imako, oyogal, we tulemal pato iskusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tenal an chunchunnad pemalga chogdo: imi Pab tulemalga igal-itogalil, tule-pe-kwen-abingaszhulmalad Sodoma-tolganga tegin Gomorra-tolganga pul-pule sapejul oturdalenonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tegin Jesús aga e-chapinganga chogalbal: “Imi antin purkwed-abalgin tulemalzhe pemal-palmine, oveja achu-kwegwed-abalgin kudimaladyob. Al pemal tad-usyob nono-nikadgin naneenabmal, tenal pemal nuyob tulemalgin immal-kwen-akalojul nanemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tenal pemal nue aga pe takermal tulemalzhe. Imi tulemaldin tule-tummaganzhe pe-chedmalo, tenal tulemal e-ormaked-negmalgin sapejul pe-sagyemalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tenal pe anpal-nanimaladbal, tulemal gobernadormalzhe tegin erreymalzhe pe-chedmalo tule-tummagan pemalga igal-itogal. Tenal tulemal pe-kasmalal, pe tule-tummaganga ankin chunmanoniko. Tenal tule-Judiojulmalad pe-itomalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Tenal tulemal pe-kasmalal, pe melle pukib-itomalo, pe igi chunmako-dewa, pe igi chogo-dewa. Tegin pemalga igal-uklejal chunmagal, kep pe wisgunoniko, pe igi chunmakenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tenal pedin aga tukin kwen chunmakojul, Pab Purpa Nued pebal chunmako.” ");
INSERT INTO kvnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tegin Jesús aga e-chapinganga chogalbal: “Imi pemalga kunonimalbalodo: tule aga kalgwenad-tuktinoniko tar-mesgal: tenal pab aga e-machi-tuktinoniko, tenal nuskan aga e-pabgan-tuktimalmogo tar-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tenal pemal-anpal-naidbal tulemal-pel-kwapa istar pe-taknonimalo. Tenal pemal poni-naid-pelguedzhe abin-purtismalal, pemal abonolego Pabbak meggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Imi pe-maidgin tulemal chabzhul pe-imajogalil, pedin wakinmalo, neg-kwebur-pidzhe. Tenal an chunchunnad pemalga chogdo: pemal ampayo pel-kwapa Israel-neg-kweburgangin pél pipirmakeddu an-igalgin-chunmagal, an-Te-Tule-Chunna pato noniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“¿Ibiga pe weob wilego pe ebinzhe? Nabir. Imi pemal nued wismaldo tule-turdamalad tule-e-oturdakedga pul tule-tummad chul. Tegin tule-arpamalad e-ibedga pul tule-tummad chulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tenal tule-turdamalad tule-e-oturdakedyob kued-wilub tegin tule-arpamalad e-ibedyob kued-wilubmo. Imi antin wilego. Al pemal wileged-wilubmalmo. Imi tulemal anche kolmal: ‘Nia-Beelzebú,’ al tulemal pul-pule pemalzhe kolmalo: ‘Niamal.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tegin Jesús chogalbal: “Tenal pe melle tule-istar-pe-takmalad-tobgumalo. Imi immal-otukal-naid kujal pel-kwapa mag taklenoniko. Tegin immal-pel-kwapa-otukal-kujad, kujal pél wisgulego. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Imi an-pegabi-immal-chogzhad, pe tulemalga palchogmogo. Tenal an apinni arpa-arpa pega immal chogzhad, pel-kwapa pulaled-wagin pe palchogmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Tenal tule-pe-mesbi-kudimalad, pe melle tobgumalo. Tenal we tulemal pinche chanbi pe-mesmalo, tenal pe-purpadin kwen mejojulmal. Tenal pemal Pab-Tummad-tobguenabmal. Tenal Pab Tummaddin nabir cho-chaglagin pe-purpa tegin pe-chan meto, pe ilagwen-nadgu sapejul oturdalegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Imi pemal ebinzhemal Pabde pemal-kwen-taknaichul? Chulá. ¿Imi chikwi-purwigana-manigwen-kwaboginel, ibiga nabir? Keg kue. Tenal Pab igal-kwen-ukchulil chikwi-purkwegal, chikwidin kwen purkojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Imi Pabdin pe-chagla-ki-kigwenzhe-pakal episal pe-cheitii. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Al pe melle tule-tobgumalo, Pab Tummad chikwi-purwigana-ichejulidga pul-pule pemal-takmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tegin Jesús chogalbal: “Imi meke-ibi-tule, tulemal-wagin chogzhal: ‘Antin Jesúsbal nai,’ antin nikpa-neggin an-Pab-wagin ampa we tulegin chogmogo: ‘We tule anpal nai.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tenal meke-ibi-tule, tulemal-wagin chogzhal: ‘Antin Jesúsbal naichul,’ antin nikpa-neggin an-Pab-wagin ampa we tulegin chogmogo: ‘We tule anpal kwen naichul.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tegin Jesús chogalbal: “Tenal pemal melle pinzhemalo an noni iti-napkin-pukmaladga neg-nudagal melle aga imamalgal. Tenal antin, an noni pul-kigma tulemal ourwegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Imi Pab-kartagin chogdo: Imi antin noni, machi aga istar pab-takegal, tegin chiskwa aga istar nan-takegal, tegin pala aga istar chak-ome-takegalbal, ");
INSERT INTO kvnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tenal tule-pebak-aichulmalad, aka-neg-yagin pebak mes pukwamalmo. Mi. 7:6 Tenal pemal-anpal-naigujadbal Pab-karta-chogzhadyob, tulemal pemalbak iskunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Imi meke-ibi-tule aga pabga, aga nanga pul an-pilalzhulil, we tule an-chapinga kwen kued-wilubzhul. Tenal meke-ibi-tule aga machiga, aga chiskwaga pul an-pilalzhulil, we tule an-chapinga kwen kued-wilubzhulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tenal meke-ibi-tule anpal-naigujadbal kuakwa purkwegal natapchulil, tule-nakrus-cheinatapidyob, we tule an-chapinga kwen kued-wilubzhulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Imi meke-ibi-tule anpal-naigujadbal yapa purkwejogel we tule yabli pelgunoniko. Tenal meke-ibi-tule anpal-naigujadbal akalzhul purkwejogel, we tule chunchunnad tullenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Imi meke-ibi-tule pe-abingajal, we tule pato an-abingasmo. Tenal meke-ibi-tule an-abingajal, we tule pato Pab-an-palmialid-abingasmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tenal tule-Pab-kaka-palchogdiidbal, meke-ibi-tule Pab-kaka-palchoged-abingeel, we tulega immal-nuegan uklenonimogo tule-Pab-kaka-palchogedyobmo. Tenal tule-chwilimakal-kudiidbal, meke-ibi-tule tule-chwilimakaled-abingeel, we tulega immal-nuegan uklenonimogo, tule-chwilimakaledyobmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Tenal meke-ibi-tule an-chapinga-maidbal an-chapin-polega immal wis ukel o tibi-dewa, an chunchunnad pega chogdo: we tulega keg-chulgu immal-nuegan uklenonimogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tegin Jesús e-chapingan-walambe-kakabogwadga pél chunmasgu, e-chapingan-walambe-kakabogwad-palmiszhun Pab-neg-takmaid-igalgin chunmagal. Tenal Jesúsdin te-akar ukin nadzhun Provincia-Galilea-neg-kweburgangin tulemal-oturdagal tegin tulemalga Pab-igalgin chunmagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Imi teun Juan Bautista oturdaleged-neggin-mellejiidgin itosdo, Cristo pél immal-imadi-kus. Al Juan Jesúszhe walbo aga e-chapingan-palmis Jesúszhe ekisgal: ");
INSERT INTO kvnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Pede chunchunnad Pab-akpene-chogzhad-palmidagoed-tule, o anmal tule-pid-abintakenabmal-dewa? Anka nuekwa kaka palmidabalo.” Tegin Juan-e-chapingan nadmalzhun Jesúszhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tegin Juan-Bautista-e-chapingan Jesúszhe nonimalgu, pél Jesúszhe immal ekichismal. Tenal Jesús Juan-e-chapinganga chogalzhun: “Tenal pe Juanzhe nadmalal, pe Juanga pél palchogmalo, pél pe imial takchad tegin pél pe itojad. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tenal pe Juanga chogo, tule-aku-atamalad nabir atanonimal, tegin tule-mego-mego-nanemalad nabir nane-pesmalbal. Tegin pe Juanga chogbalo: tule-lepra-poni-nikmalad ilgwen nugusmal, tegin tule-chuchu-yallilmalad mag itos-pesmal, tegin tule-purkwismalad kannan tullesmal, tegin tule-wiledimaladga Pab-kaka-nuegan choglenaibal. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tenal pe Juanga chogbalo: ‘Imi meke-ibi-tule an-immal-imanaidbal Pab-Tummad-kwen-ebeszhulil, ib-nued we tulega kunoniko.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tegin Juan-e-chapingan-naded-cholbal, Jesús tule-pukmaladga Juan Bautistagin chunmakal chogal: “¿Imi pe neg-nikchulidbal arpigusgu, ibi pe takti-kusmal? ¿Tule-keg-ilgwen-chunmaked ti-kaiki-purwabal-akpanedyobid? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tegil ibi pe takapchun? ¿Tule mol-nued-yowed? Chulá. Tenal tule-mol-nuegan-yomalad errey-negmalgin pukwamal, neg-nikchulidbal chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tegil ibi pe takapchun? ¿Pab-kaka-palchoged? Teobdo. Tenal an chunchunnad pemalga chogdo: we Juan Bautista Pab-kaka-palchogmaladga pul tule-tummad. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tenal Pab-kartagin Juan Bautistagin chogzhado: Imi Pab Tummad chog: Imi antin pe-iktual tule-igal-nudaked-palmine, pega igal nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Tenal an chunchunnad pemalga chogdo: imi tule-iti-napkin-mimmilesmalad-abalgin Juan Bautistaga pul tule-tummad kwen nikchul. Tenal Pab-neg-takmaidgin meke-ibi-tule-pul-totogwadzhe-pakal Juan Bautistaga pul tule-tummad. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Imi Juan-Bautista-chunmanonikid-akar imisgwadzhe, tulemal kantikidgin Pab-neg-takmaidgin togbi-kualmal. Tenal tule-kantikidgin-immal-imamalad Pab-neg-takmaid chunanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Imi Pab-kaka-palchogmalad-pel-kwapa tegin Moisés-igal iktual Pab-neg-takmaidgin chogles, Juan-Bautista-nonikidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tenal Pab-kaka-palchogmalad-akpene-chogzhad pe abingebiel, we Elías-kannan-tanikoed-tule, wedin Juan Bautista. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tenal pe nuekwa an-chogzhad itomalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tegin Jesús chogalbal: “¿Imi an ibimalayob tule-imis-pukmaladgin pemalga chogo-wichul? Nabir. Imi tule-imis-pukmaladdin, nuskan-purwigana tule-ampagumaladgin aga e-aimalzhe kolbuktamaladyob tamalmo. Tenal we purwigana chogdamalo: ");
INSERT INTO kvnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Imi anmal pemalga kammu-okochamal, tenal pemal kwen kwichajulmal. Tenal anmal pemalga pukib-itoged-namaked namasmal, tenal pemal pukib-kwen-itoszhulmalbal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Imi Juan Bautista nue mas-kunchulidgin, nue kobzhulidgin noni. Tenal tulemal Juan Bautistagin chogalmal: ‘Juan Bautista nia-nika.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tenal an-Te-Tule-Chunna nonigu, mas-kunnedgin, kobedgin noni. Tenal tulemal ankin chogmal: ‘We tule aku-aku-mas-kunned tegin mumurgued-tule.’ Tegin tulemal ankin chogmalbal: ‘We tule Romano-tummadga-mani-egwanmaladbak ai-nued, tegin tule-iskued-nikmalad-pimalad-e-aibal.’ Imi tule-imis-pukmalad Juan-tegin-an-kwen-abingaszhulmal. ¿Tede pemal igi wisguo an-igal ib-chunchunnad o chul? Nabir. Imi Pab-immal-wijiid immal-nuegan-imakedbal mag taklenoniko an-igal ib-chunchunnaddo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Imi Jesús neg-kwebur-kwénna-kwénnagin íchejul immal-taktijulmalad imas, tenal tule-we-neg-kweburginmalad yabli e-iskuedgin kwen pukib-itononijulmal. Al Jesús we neg-kwebur-tolganga sapejul immal chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Corazín-tolgan anpi pe wilesmalma, pemal peyedzhe oturdalenoniko! ¡Betsaida-tolgan anpi pe wilesmalmoma, pemal peyedzhe oturdalenonimalmogo! Tenal Tiro-tolgan tegin Sidón-tolgan pemalyob immal-taktijulmalad takchamalalen, we tulemal pato tikajulgus cho-purgin obzhamalan tegin chagu-mol yosmalbalin, oyogal emalde aga ulubgin iskuedgin pukib-itononimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Al an chunchunnad pemalga chogdo: imi Pab-tulemalga-igal-itoged-ibegin, pe-iskuedgin pukib-kwen-itoszhulidbal pemal Tiro-tolganga tegin Sidón-tolganga pul-pule sapejul oturdalenonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tegin Jesús chogalbal: “Capernaum-tolgan, ¿pemal ebinzhebukmal pemal peyedzhe otummoledi-kuo? Chulá. Tenal pemaldin ankin-ibzhejulidbal pul-pule nug iskunonimalo. Imi tulemal neg-kwebur-Sodomaginmalad pemalyob immal-taktijulmalad takchamalalen, imisgwadzhe neg-kwebur-Sodoma ampa chiin. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tenal an chunchunnad pemalga chogdo: imi Pab-tulemalga-igal-itoged-ibegin, pemal Sodoma-tolganga pul-pule sapejul oturdalenonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Imi teun Jesús chogalbal: “Pabye, an pe-otummoye. Imi pe nikpa-neggin tegin iti-napkin e-Tummadga maiye. Imi pe tule-immal-wismalad tegin tule-nono-nikmalad an-immal-imajad aku-itogal pe imasbalye. Tenal an-immal-imajad mag-itogal pe tule-polgana-imasbalye. Al an pe-nug-otummoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pabye, an wisdo, pe yer itos pe-immal-imajadyob immal imagalye. Weobdin ib-nuedye.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tegin Jesús chogalbal: “Imi an-Pabdin pel-kwapa anka immal ukcha an immal imagal. Tenal tule-kwen-nikchul nuekwa Machi-wisgugal, tenal e-Pabbi unnila nuekwa e-Machi-wiis. Tenal tule-kwen-nikchulbal nuekwa Pab-wisgugal, tenal e-Machibi unnila nuekwa e-Pab-wiis. Tenal e-Machi aga e-itolegedbal tule-ima e-Pab-wisgugal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tegin Jesús chogalbal: “Imi pemal igal-kusgu-mamikidgin pe peyedzhe alamanaidbal pe pudar-itononikil, pe anche tagmalo. Tegin pemal iskued-nikadbal pe pukib-itodimalbalil, pemal-pel-kwapa anche tagmalo. Tenal pe anche nonimalal, antin purpal ulukugal pe-imako. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tenal pe anpak mecha kudio, tegin pe ankin turdabalo, moli-peb-nikad tukalgin chowal-piir-maidgin aga mecha-arpanaidyob. Imi antin tummarba-itogedgin kwen nanejul, tenal antin pinnallégwadgin pemalbak nanao. Tenal pe-purpa-ulukujadbal pe yer-itononiko. ");
INSERT INTO kvnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tenal antin kusgu pinnallégwadgin pemal-oturda, kantikidgin chul. Tenal pe-anka-immal-imaked twagdar peyedzhejulmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Imi teun takalgu, ulukued-ibegin Jesús aga e-chapinganbak trigo-naidbal natapidgin, e-chapingan ukul-chaalidbal iche trigo-kwa wis kwachamal kunkal. Tenal teun Pariseomal-wal-walgwen Jesúsbak natapmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tenal Pariseomal Jesús-e-chapingan-takchamalgu trigo-kwa kwananimal, Jesúsga chogal: —Jesús pe tak pe-chapingan ibi-imananimal. ¿Ibiga pe-chapingan ulukued-ibegin trigo-kwa kwane-natapmal-wede? Wedin arpaged. Al izhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tegin Jesús Pariseomalga chogal: —An-chapingan noal immal kwen imananijulmal. ¿Imi pe Pab-kartagin apchodijulzhí, akpene Errey-David aga e-chapinganbak ukul-mesdanikidgin, igi kus? ");
INSERT INTO kvnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Imi teun David Pabzhe-koled-neg-yabal togzhagu, aga e-chapinganbak Pabga-madu-uklejad kuchamal. Tenal madu-Pabga-uklejad tule-irwal-Pabzhe-kolmaladbi igal-nika kunkal. Tenal David-we-madu-kuchad izheendo, tenal David yabli aga e-chapinganbak kwen iskuszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Tegin pe Moisés-kartagin apchosbalzhulzhí, Pabzhe-koled-neggin tule-irwal-Pabzhe-kolmalad ulukued-ibegin e-arpanaidbal, igi nanebukmal? We tule-irwal-Pabzhe-kolmalad igal-mamikidgin yolenanikidyob-takle, tenal tule-irwal-Pabzhe-kolmalad yabli kwen noszhulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tenal an chunchunnad pemalga chogdo: imi antin Pabzhe-koled-negga pul tule-tummad noni. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Imi Pab e-kartagin chogzhado: Imi antin an pei, pemal wilejakwa tule-tak, pul pe kugedgin anka immal ukegal. Os. 6:6 Tenal pemal we kaka mag itosmalalen ibi chogle, pemal tule-immal-kwen-akaloszhulmaladgin, kwen chogzhajulmalan: ‘We tulemal nosmal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Imi an-Te-Tule-Chunna ulukued-ibe-e-ibedga mai. Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tegin Jesús Pariseomalbak imasmalad-akar nadgu, Judio-ormaked-neggin togzha. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Imi teun takalgu, tule-chunkal-tinkualed-walgwen chimo. Tenal teun tulemal igal-aminanimal Jesúsgin istar chunmagal, Jesús noal-kudii. Al tulemal yami Jesúszhe ekichialmal, chogalmal: —¿Imi tule ulukued-ibegin nabir tule-yeed-nudako o izhe tule-nudagal? ");
INSERT INTO kvnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tegin Jesús we tulemalga chogal: —Nabir. Imi pe oveja-nikal, tegin oveja ulukued-ibegin pebi olli-yagin arkwatchal, ¿pe oveja-onaknaojulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Tenal tule pul ovejaga tule-nuedzhulzhí? Teobdo. Al tule ulukued-ibegin nabir immal-nuegan imako. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tegin Jesús pél chunmasgu, tule-chunkal-tinkualedga chogalzhun: —Chunkal aktodo. Tegidgin tule-chunkal-tinkualed chunkal aktodgu, chunkal ilgwen nugus, kwen-yopí pesmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tenal Pariseomal Judio-ormaked-neg-akar aknidmalgu, nadmal igal-amigal, emalde igi nabir Jesús-mesmalo-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tegin Jesús wisgusgu Pariseomal e-mesbimal, Jesús akne nadzhun. Tenal tulemal-ichejul Jesúsbak mes nadmalmo. Tenal Jesús natapidgin pel-kwapa tule-yemalad-nudake-nad. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tenal Jesús tulemalga chogal: “Pe melle tule-pimaladga pe palchogo antin tule-yeed-nudas.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Imi Jesús-weob-immal-imajad Pab-kaka-palchoged-Isaías chogzhad-yopí kunoni. Tenal Isaías chogzhado: “Imi Pab Tummad chog: ");
INSERT INTO kvnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","We tule anka-arpaged. Tenal antin we tule-chus. Tenal an we tule-pilal, tegin an we tulegin yer-itobal. Tenal antin An-Purpa-Nuedbal-immal-imagal we tule-imako. Tenal we tuledin Pab-igal-innikigwadgin Judiojulmaladga chunmako. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tenal we tule, tulemalbak abin-abin kwen imakojul, tegin tulemalbak sapejul kwen urwojulbal. Tegin we tule igalganbal kwen koldi-kuojulbal, ebal naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tenal we tule, tule-iskuedgin-iskusmalad-kwen-opelogojul, tule ti-kaiki-wal-obugaled kwen pichiszhulidyob. Tegin we tule-tanikid tule-iskuedgin-iskusmalad-kwen-opelogojul-kubalo, kallen-pinche-wa-onakchiil, tule kallen okinchulidyob. Al we tule an-chogzhadyob keg-chulgu igal-napírragwad-megwedzhe kudiguo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tenal Judiojulmalad-chog-ilbal we tule-abintabukmalo e-pentagal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tegin tulemal Jesúszhe tule-nia-nikad-cheinonimal. Tenal we tule nia-nikadbal aku-ata kudii tegin keg-pel-chunma kudibal. Tenal Jesús tule-nudanonigu, mag atanoni, tegin nabir chunmanonibal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tegin tulemal takchamalgu Jesús tule-nia-nikad-nudas, weob pakal pesmal. Tegin tulemal aga emal-emal chogalmal: “¿We tulede, David-wagwa-tanikoed-choglejad pe-ebinzhe?” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tenal Pariseomal tulemal-chogzhad itosgu, chogalmal: “Chulá. We tule pinche unnila niamal-e-tummad-Beelzebú-nuggin tulegin niamal-oni.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tenal Jesús pato wiis Pariseomal igi pinzhebukmal. Al Jesús Pariseomalga chogalzhun: “Imi meke-ibi-nap abal marral-chiil, neg pél iskunoniko. Tenal meke-ibi-neg-kwebur o meke-ibi-neg-yaginmalad aga abal istarmalal, kwen unniguojulmal mes pulakwa ampagugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Imi nia-Satanás aga e-chapingan-onidel, aga abal istar kunonimalo. ¿Tenal an-chogzhadyob kuelen, Satanás-neg-takmaid igi unniguoen neg-takegal? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Imi pemal chogmal antin nia-Beelzebú-kannalegedgin niamal-onimai. ¿Tenal an nia-Beelzebú-kannalegedgin tulegin nia-onielen, tede pe-chapingandin toa-kannalegedgin tulegin niamal-onimalmojun? ¿Tegil pe chapingan nia-nuggin nia-onimalmodé? Tenal pemal nued wismaldo pe-chapingan nia-nuggin niamal-kwen-onijulmal. Al pe-chapingan nia-oninaidgin pemalga oyos pe-ankin-chogzhad, ib-chunchunnad chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Tenal an Pab Purpa Nuedbal tulegin niamal-oni-choggu, al wedin choglejundo Pab-neg-takmaid pato pemalzhe noni. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Teginbal, imi tule-kal-ibed aga e-neggin mail, ¿pe yogasal e-neggin togo pe ebinzhe immal-aturzhegal? ¡Chulá, keg kue! Tenal pe we tule-kal-ibed-edineenabgwel, kep pe nabir we tulebi immalmal aturzhao. Imi an tule-kal-ibed-etijadyob an igal-nikamo an nia-saglagin-nakwijadbal, tulegin niamal-onigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Imi tule anpak naichulil, we tule anchikid-chul, we tule pato anpak istargad. Tenal tule pulakwa anka tulemal-urpenaichulbalil, we tule pul-kigma anka tulemal-izhonai melle anpak naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Al an pemalga chogzhundo: imi Pab Tummad tulega pel-kwapa nabir iskued eli. Tegin tule Pab Tummadgin atajulidgin chunmakel, we iskued ampa nabir elilebal. Tenal tule Pab-Purpa-Nued-immal-imajadgin atajulidgin chunmakel, Pab Tummad tulega we iskued kwen eliojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Imi tule istar an-Te-Tule-Chunnagin chunmajal, Pab Tummad we tulega nabir iskued elio. Tenal tule Pab Purpa Nuedgin istar-chunmajal, Pab Tummad tulega we iskued kwen eliojul, iti-napkin pel chul, tegin Pab-neggin pel chulbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tegin Jesús chogalbal: “Imi tule chogel: ‘Wedin chapi-nued,’ e-chan ampa nuedmo. Tenal tule chogel: ‘Wedin chapi-iskana,’ e-chan ampa istarmo. Tenal chapimal e-chanbal mag taklenoniko, chapi-nued o chapi-iskana. Tenal tulemal ampa e-taedbal mag taklenonimogo, tule-nued o tule-iskana. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“¡Imi pemal nakpeyob tule-iskana! Tenal pemal tule-iskana-choggu, ¿al pe igi kaka-nuegangin chunmako? Keg kue. Tenal tule aga ulubgin pela-pela pinzhediidbal chunmanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Imi tule-nued chunmanonikil, aga ulubgin igal-nuegangin pinzhediidbal, yer chunmanoniko. Tenal tule-iskana chunmanonikil, aga ulubgin igal-iskanagin pinzhediidbal, istar chunmanoniko. Al pemal istar chunmananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tenal an pemalga chogzhundo: Pab-tulemalga-igal-itoged-ibegin, Pab tule-ilbal tulemalzhe immal ekisnoniko: ‘¿Ibiga pe yogasal chunmas?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tenal pe aga tukin chunmakedbal, pegin choglenoniko, pe tule-nued o pe tule-iskana.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tegidgin Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad-wal-walgwen Jesúsga chogalmal: —Tule-oturdaked, pe anmalga immal-taktijulid imagweldo, oyogal pedin Pab-akar-tanikid-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tegin Jesús we tulemalga chogal: —Imi tule-iskana tegin tule-Pabgin-nosmalad peigujimaldo, ante ega immal-taktijulid ima, oyogal an Pab-akar tani. Tenal we tulemalga immal-taktijulid-pid pal kwen oyolegojul-kuo. Tenal Pab-kaka-palchoged-Jonásga-immal-kujadbal we tulemal unnila wisgumalo an toa-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Imi akpene Jonás ibapá ua-tummad-sabal-yabal megwijadyob an-Te-Tule-Chunna ampa ibapá napil-ulpal megmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tenal Nínive-tolgan Jonás-chunmajadbal aga ulubgin iskuedgin pukib-itononimal. Al Nínive-tolgan Pab-tulemalga-igal-itoged-ibegin tule-imis-pukmalad-tuktinonimalo. Imisgin pe takto, antin Jonásga pul tule-tummadga kudii, tenal pemal yabli yapa ankin ibzhemal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Teginbal, Reina-tad-chabiridzhik-neg-takmai-kujad nap-kaka-akar noni Salomón-pirkin-immal-wijiid-wisgugal. Al we Reina Pab-tulemalga-igal-itoged-ibegin tule-imis-pukmalad-tuktinonimogo. Imisgin pe takto, antin Salomónga pul tule-tummadga kudii, tenal pemal yabli yapa ankin ibzhemal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tegin Jesús chogalbal: “Imi nia tule-akar nojal, neg-ti-nikchulidbal pipirmadi-peio, neg-ulukued amigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tenal nia neg-ulukued-onoszhulidbal kannan pinzhedago: ‘An pul kannan nao neg-akpenegwad-nojadzhe.’ “Tegin nia tule-akar-nojadzhe kannan nonibalil, taknoniko neg olobi-chii, tegin neg turwial-chibal kuakwa meggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Al nia kannan nao aga walakugle e-pakamalad-ega-pul-nia-iskana-amigal. Tegin nia aga e-pakamalad-amijal, we niamal-pel-kwapa tulegin megnoniko. Tenal tule-nia-nikad akpenegwadga pul-pule iskunoniko. Imi tulemal-imis-pukmalad an-abingaszhulidbal, tule-nia-nikadyob pul-pule iskunonimalmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tegin Jesús-ampa-tule-pukmaladbak-chunmanaidgin, Jesús-e-nan tegin Jesús-e-urpamal irmanonimal Jesúsbak chunmagal. Tenal Jesús-e-kwenamalad yabli magarbal pukwa-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tegin tule-walgwen Jesúsga chognoni: —Pe-nan tegin pe-urpamal magarbal pukwamal, choge, emalde pebak chunmabimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tenal Jesús tule-e-nan-kaka-cheinonikidga chogal: —¿Toa an-nan-ade? ¿Toa an-urpamal-chunchunnad-ade? ");
INSERT INTO kvnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tegidgin Jesús aga e-chapinganga chunkal oyosgu, chogal: —We tulemal-pukmalad an-nan tegin an-urpamaldo. ");
INSERT INTO kvnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Imi meke-ibi-tule an-Pab-nikpa-maid-choged-pallí immal imakel, we tulemal an-nan, an-urpamal tegin an-punmal-chunchunnaddo. Pitogua. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Imi Jesús ampa te ibegin neg-akar nad mata-kakaje. Tegin Jesús mata-kakpal chigwiszhun Pab-igalgin tulemal-oturdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tenal tulemal-ichejul irmanonigu, Jesús ulgin nakwis. Tegin Jesús ulgin-akar chii Pab-igalgin tulemal-oturdakalzhun. Tenal tulemaldin ukubgin pukwa-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tegin Jesús ulgin-akar kep choggwen-chul purpal tulemal-oturdakalzhun. Tenal Jesús purpal tulemalga chogal: “Imi te ibagwengin tule-walgwen nad mie-mie immal-kwa imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tegin tule immal-kwa minatapidgin, immal-kwa kwen igalbal-nanemaladgin apatis. Tenal chikwimal we immal-kwa masmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Tegin immal-kwa kwen akwapir-ulak-naidgin apatis. Tenal nap-nue-nikchulidbal we immal-kwa pulzhuli nis. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tenal tad kanonigu, immal-kwa mali-nue-napkin-akachulidbal ilgwen tinkus. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Tegin immal-kwa-piddin iko-kwa-naidgin apatis. Tegin we immal-kwa nisgu, iko-kwabak mes nis. Tenal we immal-kwa tunkusgu, ikodin immal-kwa-nued-nijad izhos, al keg chanmagus. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Tenal immal-kwa-piddin napa-nuedgin apatis. Tenal we immal-kwa tunkusgu, yer chanmanoni. Tenal immal-kwa kalgwengin tulaatal chanmas, kwéntin kalgwengin tulapá chanmas, kwéntin kalgwengin tulagwen-kakaambe chanmasmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Imi pemal nuekwa an-chogzhad itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tegin Jesús-tulemalga-chunmajad-cholbal, e-chapingan Jesúszhe nonimal. Tegin e-chapingan Jesúszhe ekichialmal chogalmal: “¿Ibiga pe tulemalga purpal chunmas-wede? ¿Ibiga pe pakal-pud-pud tulemalga kwen chunmaszhuldé?” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tegin Jesús aga e-chapinganga chogal: “Imi Pabdin pemalga igal-ukcha, Pab-neg-takmaidgin igal-otukal-maid mag itononigal. Tenal tule-pimaladga igal-kwen-ukleszhul mag we igal itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Imi tule-mag-itosmalad kujal pul-pule mag itononimalo, tegin we tulemal pela-pela immal wisgunoniko. Tenal tule-nuekwa-itoszhulmaladdin kujal pul-pule aku-itononimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Al an we tulemalga purpal chunmakalda: Imi we tulemal immal taknanimal, tenal we tulemal yabli aku-takmal. Tegin we tulemal immal itomal, tenal we tulemal yabli aku-itomal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Imi we tulemalga immal-kujad, akpene Pab-kaka-palchoged-Isaías chogzhad-yopí kus. Tenal Isaías chogzhado: Imi Pab Tummad chogdo: ‘Imi pemal nue ua chemal, tenal pemal yabli aku-itomal. Tegin pemal nue immal takmal, tenal pemal yabli aku-takmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tenal we tulemal aga niga okannosmal melle an-itomalgal, tegin we tulemal aga ua-ya chaktismalbal, melle itomalgal. Tegin we tulemal aga imia chaktismalbal, melle takegal. Imi we tulemal weob imaszhulilen, mag itononimaloen, mag taknonimaloen, tegin we tulemal aga ulubgin wisgunonimalbaloen. Tenal we tulemal kannan anchik akpirnonimalalen, antin tar-nudakoen.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tenal pemaldin, pe-imia mag atagedbal tegin pe mag itogedbal, pemalga ib-nuedga kus. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tenal an chunchunnad pemalga chogdo: imi Pab-kaka-palchogmalad-ichejul tegin tule-nuegan-ichejul pe-immal-takchiidyob pirkin takpi-kusmalmogan, tenal we tulemal yabli kwen takchajul-kusmal. Tegin we tulemal pe-immal-itosmaladyob pirkin itobi-kusmalmogan, tenal we tulemal yabli kwen itoszhul-kusmalbaldo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tegin Jesús chogalbal: “Imi pemal nuekwa itogenabmal an pemalga purpal immal-kwa-tigedgin chunmajad, igi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Imi tule Pab-neg-takmaidgin-chunmajad itosmalal, tenal we tule yabli aku-itononimalal, nia-sagla we tulegin Pab-kaka-chunmalejad chunoniko. Wedin, immal-kwa igalgin apatijadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Tenal immal-kwa nap-ulak-akwapir-naidgin apatijaddin choglege: tule Pab-kaka itojal, weligwaledgin Pab-kaka abingao. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tenal we tule pinche askinbi Pab-kaka abingajadbal nue-naojul Pab-igal ebenoniko, immal-tiglejad nue mali nikchulidyob. Tenal Pab-kakapurwa-ulgin we tulega poni nononikil, o tulemal chabzhul tar-imanonimalal, we tule ilgwen Pab-igenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Tenal immal-kwa iko-kwa-naidgin apatijaddin choglege: tule Pab-kaka-itojal, Pab-kaka abingenoniko. Tenal we tule kujal iti-napkined-immal-imakedgin pul-pule pinzhedago, pul Pab-igalgin-naneedga. Tegin we tule peyedzhe immal-nikuedgin yardalenoniko, immal-kwa-nued iko-tar-izhojadbal keg chanmanonikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Tenal immal-kwa-nap-nuedgin-apatijaddin choglege: tule Pab-kaka-nuegan-itojal, we tule mag-itogedbal, Pab-kaka abingas. Tenal we tulemal Pab-chogzhadbal ichejul immal-nuegan imanoniko, immal-kwa kalgwengin tulaatal chanmajadyob, kwéntin abal immal-nuegan imako, immal-kwa kalgwengin tulapá chanmajadyob, tegin kwéntin iche immal-nuegan imamogo immal-kwa kalgwengin tulagwen-kakaambe chanmajadyob. Tenal an immal-kwagin chunmajad, weob chogledo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tegin Jesús tulemalga immal-purpaled-pidgin chunmakalbal: “Imi Pab-neg-takmaid tule aga nagnugin trigo-kwa-nued-tigzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tenal tulemal pél kabidmaladgin tule-ebak-aichulid nonimo, trigo-kwa-tiglejadgin kagan-iskana tignonimo. Tegin tule-kagan-iskana-tignonikid pél kagan-iskana tigzhagu, kannan nadbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Tegin trigo-kwa aknisgu, kagan-iskana mes nismo. Tenal trigo-kwa kagan-iskanabak mes tunkuszhun. Tenal trigo tuglumaknonigu, kep mag taklenonijun kagan-iskana kwichimo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Tegin tule-nagnu-ibed-e-mosmal takchamalgu kagan-iskana tunkusmalmo, tule-nagnu-ibedzhe nadmalzhun, chognegal. Tegin mosmal e-tummadzhe nonimalgu, e-tummadga chogalmal: ‘¿Tummad, imi pede nagnugin trigo-kwa-nuegan tigzhajulzhí?’ Tegin tule-nagnu-ibed chogal: ‘Teobdo.’ Tegin e-mosmal nagnu-ibedga chogalbal: ‘¿Tede, we kagan-iskanade pia tanijun?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tenal tule-nagnu-ibed aga e-mosmalga chogal: ‘Imi an wisdo, tule-anpak-aichulid an-nagnugin kagan-iskana tigzhamo. ¿Al nabir kagan-iskana nismóye?’ “Tegin mosmal tule-nagnu-ibedga chogal: ‘¿Tegil pe pei anmal pega kagan-iskana ounnu?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tenal tule-nagnu-ibed aga e-mosmalga chogal: ‘Chulá. Melle pe kagan-iskana unkemalgwelo. Tegil pe mes kagan-iskanabak trigo unkemalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Al pemal aka mes kagan-iskana ebemalgwelo, trigo kwallegedzhe. Tegin an trigo kwangal tule-ogbochogalil, kep an nega chogo: Kepegin pe kagan-iskana etimigwelo. Tegin pe kagan-iskana kugmako, chogin okummagal. Tegin pemal kep trigo kwanmalo. Tegin pe trigo kwachamalal, kep pe ukur-ukagin trigo-kwa chabomalo.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tegin Jesús tulemalga immal-purpaled-pidgin chunmakalbal: “Imi Pab-neg-takmaid, tule nagnugin chapi-mostaza-kwa tigzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imi chapi-mostaza-kwadin egmal-immal-kwaga pul purwí. Tenal mostaza-kwa nijal, tegin tunkujal, immal-kwa-pirka-il-ilbal-tiglemalad-egmalga pul tummad nao. Tenal mostaza chapiyob kunoniko. Al chikwimal mostaza-e-aanganbal ampagunonidamal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tegin Jesús tulemalga immal-purpaled-pidgin chunmakalbal: “Imi Pab-neg-takmaid, ome-walgwen arina-libir-tulapágwadgin madu-ina eyojadyob. Imi madu-ina pinna-pinna arina-kado, pel-kwapa omuedzhe.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Imi Jesús tulemalga pel-kwapa immal-purpaledgin chunmadi-kus, tenal Jesús pakal-pud tulemalga kwen chunmaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tenal Jesús tulemalga purpal chunmadi-kus akpene Pab-kaka-palchoged-chogzhad-yopí kunonigal. Tenal Pab-kaka-palchoged Jesúsgin chogzhado: Imi antin purpal immalmalgin chunmadi-kuo, tegin an nap-kepe-naigujad-akar-otukal-igal-maidgin chunmadi-kubalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tegin Jesús pél chunmasgu, tulemal-pukmalad-akar negzhe nadzhun. Tegin Jesús negzhe nonigu, e-chapingan Jesúszhe nonimal chogalmal: “Tummad, imi anmal peiendo, pe anmalga palchog, pe kagan-iskanagin-chunmajadde ibi chogle-wede.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tegin Jesús aga e-chapinganga chogalzhun: “Nabir. Imi tule-immal-kwa-nuegan-tigzhaddin, choglege, an-Te-Tule-Chunna. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tenal nagnudin choglege, iti-nap. Tenal immal-kwa-nuegandin choglege, Pab-neg-takmaidgined-tulemal. Tenal kagan-iskanadin choglege, niazhikid-tulemal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tenal tule-kagan-iskana-tigzhaddin choglege, nia-sagla. Tenal tule-immal-kwaneed-nidin choglege, neg-tuku. Tenal tule-trigo-kwanmaladdin choglege, Pab-angelmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Imi tule-kagan-iskana-etimismalad tegin chogin-kukchamaladdin choglege, tule neg-tuku omojal, ampa kagan-kummajad-yopí tulemalgin kunonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tenal te ibegin an-Te-Tule-Chunna naga angelmal-palminoniko, angelmal Pab-neg-takmaidgin pel-kwapa immalmal-iskuedgin-tule-egwachamalad weinonimalo. Tegin angelmal pel-kwapa tule-iskana-weinonimalbalo, cho-chaglagin metkal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tenal we tulemal cho-chaglagin melledel, peyedzhe pononimalo, tegin peyedzhe-wilejiidbal nugal kotamalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tenal tule-chwilidikmaladdin Pab-neg-takmaidgin tadgwa-kaedyob, mag taklenoniko, tule-nuegan. Imi pe nuekwa an-chogzhad itomalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tegin Jesús chogalbal: “Imi Pab-neg-takmaiddin ol nagnugin otukal tigal-maidyob. Tenal tule-walgwen ol onosgu, kannan ol-otusbal. Tegin we tule weligwal nadgu, pél e-immalmal-nikad ukcha. Tenal tule-ol-onojad manigin we nagnu pakcha aga ol-otukal-chiid onogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Teginbal, Pab-neg-takmaid tule-perla-paked perla-nued-aminaidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tegin tule perla-peyedzhe-karked onosgu, kannan pél e-immalmal-nikad ukchabal. Tenal tule-perla-onojad kep manigin perla-karked pakchajun egadga kugal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tegin Jesús chogalbal: “Imi Pab-neg-takmaid tule matagin, chakigin akal-akal ua-kaedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tenal tule chakigin akal-akal ua-kajal, kep ukubzhe chaki ebinonimalo. Tegin tulemal kep ukubzhe chakigin ua-kalejad-weinonimalo. Tenal tulemal ua-nabir-kullemaladdin karpagin chabomalo, tenal ua-keg-kullemaladdin tar-middamal. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Imi neg-tuku omojal, uagin kujad-yopí tulemalgin kunonimalmogo. Tenal te ibegin Pab-angelmal tule-chwilidikmalad-akar tule-iskana-weinonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tenal angelmal cho-chaglagin tule-iskana-midmalo. Tegin tule-iskana peyedzhe pononimalo, tegin peyedzhe-wilejiidbal nugal kotamalbalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tegin Jesús aga e-chapinganzhe ekichialzhun: —¿Imi an-pemalga-purpal-Pab-neg-takmaidgin-chunmajad, pe mag itosmal? Tegin e-chapingan Jesúsga chogalmal: —Anmal pél mag itosmaldo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tegin Jesús aga e-chapinganga chogalbal: —Tenal tule-Pab-igalgin-yer-tulemal-oturdamalad Pab-neg-takmaid wisgunonikil, pato kuakwa pukwamal igal-cheredgin tegin igal-pingangin tulemal-oturdagal. Imi we tulemal-oturdamalad tule-neg-ibedyob, e-immal-chaboged-neg-akar immal-mugana tegin immal-pingan oninaidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tegin Jesús aga e-chapinganga purpal pél chunmasgu, Capernaum-akar nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tegin Jesús aga e-tunkujad-neg-kweburzhe nonigu, Judio-ormaked-neggin tognoni Pab-igalgin tulemal-oturdagal. Tenal tulemal-itobukmalad Jesús-chunmakedbal weob pakal pesmal. Tegin tulemal aga emal-emal chunmakalmal chogalmal: —¿We tulede pia turdas-wede, weob chunmakedé? ¿Ibiga nabir pinzheed-nika chunma-wede? ¿Tegin pia kannaleged onosbal-wede, immal-taktijulid imagal? ");
INSERT INTO kvnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿We tulede, José-ulu-chobed-e-machijulzhí? ¿Tenal e-nan Maríajulzhí? ¿Tenal e-urpamalde: Santiago, José, Simón tegin Judaszhulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Tenal e-punmal anmalbak wegin pel-kwapa pukwamalmojulzhí? ¿Tede we tulede pia turdaszhun, weob immal imagal? ");
INSERT INTO kvnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tenal tule-pukmalad istar Jesús-taknonimalzhun. Tegin Jesús tule-pukmaladga chogalzhun: —Imi tulemal chogmal: ‘neg-kwebur-pimaladgin tulemal tule-tummadyob Pab-kaka-palchogmalad-takmal. Tenal tulemal-e-neg-kweburginmalad tegin tule-e-neg-yaginmalad tule-tummadyob Pab-kaka-palchogmalad-kwen-takchulmal.’ Al pemal tule-tummadyob an-kwen-takchulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tenal tulemal-Jesúsgin-pengusmaladbal, Jesús Nazaret-neg-kweburgin iche-iche immal-taktijulmalad wis imas. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Imi teun takalgu, Herode Provincia-Galileagin tummadga mai. Tenal Herode itos tulemal Jesús-immal-taktijulid-imadiidgin chunmadimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Al Herode aga e-chapinganga chogal: “Imi tulemal-kin-chunmadimalad, an wiis, wedin Juan Bautista kannan tulles. Al we tule kannaleged nika immal-taktijulid imagal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Imi Juan Bautista ampa tula-tiun, Herode e-urpa-Felipegin ome-Herodías-egwas. Al Juan Herodega pakal-pud chogzhagus: “Imi pe noal-kudii. ¿Ibiga pe aga urpa-Felipegin ome-Herodías-egwas-wede? Imi anmalga igal weob kwen maichul.” Al Herode Juan-kas. Tegin Herode oturdaleged-neggin Juan-odosgu, ezha-tubgin Juan-etis. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tenal teun Herode Juan-mesbi-kualin. Tenal tulemal Pab-kaka-palchogedga Juan-takchamal-choggu, al Herode tulemal-tobgualidbal Juan-kwen-mechajul. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tenal te ibagwengin, Herodega mimmilejad-e-ibe-itoged noni. Tegidgin Herodías-e-chiskwa tulemal-pukmaladga kwilal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tegin Herode e-chiskwagiid yer-kwicha takchagu, Pab-wagin e-chiskwagiidga kaka-ukcha: “Imi meke-ibi pe anche ekisbídin, antin pega uko.” ");
INSERT INTO kvnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tenal we puna e-nan-ka-chogzhadbal Herodega chognoni: —Imi antin pateagin Juan-Bautista-e-nono-pei. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tegin puna Herodega chognonigu ede Juan-Bautista-e-nono-pei, Herode pukib-pinzhenoni-pes. Tenal Herode Pab-wagin tegin tulemal-wagin punaga pato kaka-ukcha-choggu, al Herode keg kwénna pal choggus: “An pega Juan-nono kwen ukojul.” ");
INSERT INTO kvnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tegin Herode aga e-chapingan-palmis, oturdaleged-neggin Juan-nono idirgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tegin Herode-e-chapingan Juan-nono idirisgu, pateagin Juan-nono cheinoni. Tegin Herode-e-chapingan punaga Juan-nono ukcha, tegin punademo ukin aga e-nanga Juan-nono ukchamo. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tenal Juan-Bautista-e-chapingan Juan-e-mui aminonimal. Tegin e-chapingan Juan-mui-tigzhamalzhun. Tenal Juan-purkwijad-cholbal Juan-e-chapingan Jesúsga chogapmal, Juan igi purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tegin Jesús wisgusgu Juan purkwis, Jesús yakiri ulgin nad neg-tule-nikchulidbal. Tenal tulemal wisgusgu Jesús nad, tulemal neg-kwebur-ilbal Jesús-cholbal nagab nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tegin Jesús neg-natapidzhe omosgu, pato taknatap tulemal-ichejul edu pukwamal. Tenal Jesús wilejakwa tulemal-taknonijun. Tegin Jesús ilgwen tule-yenonimalad nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tegin tad-arkwandanigusgu, e-chapingan Jesúsga chognonimal: —Tummad, ¿Anmal igi we tulemal-imakenabmal-wede? Tenal neg pato chedodanibal. Imi itigin immal kwen nikchul-choggu, al pe we tulemalga chogenab: ‘Pe nemalo,’ we tulemal nabir akalzhul neg-kweburgan-purwiganaje mas-kunned paknemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tegin Jesús aga e-chapinganga chogal: —Imi antin an takto, we tulemal need-wilubzhulmal. Tenal pemal masgin we tulemal-okunneenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tegin e-chapingan Jesúsga chogal: —Chulá. Imi anmal unnila madu-walatal nika, tegin ua-ukabo wis nikpal. ¿Tede anmal igi we tulemal-okunmalo? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tegin Jesús aga e-chapinganga chogal: —Tegil madu-walataled tegin ua-ukabogid anka pe chedado. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tegin Jesús kagangin ampagugal tulemal-imas. Tegin Jesús madu-walataled tegin ua-ukabogwad-chusgu, nikpa atad tegin Pab Tummadga tog-nuedi chogzha. Tegin Jesús purwi-purwi madu pipichisgu, madu Jesúsga melgud. Tegin Jesús ua-pipichisbalgu, ua Jesúsga melgudmo. Tegin Jesús aga e-chapinganga madu tegin ua-ukcha tulemalga mimigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tenal tulemal-pel-kwapa immedzhe mas kuchamalgu, Jesús-e-chapingan ampa karpa-kwaambe-kakabog mas-okpitchad wesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Imi teun macherganbi-miliatal mas-kuchamal, tenal omegan tegin nuskanmal pel kwen choglejul. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tegidgin Jesús ulgin-nakwegal aga e-chapingan-imas edu mata-opakal negal. Tegin Jesús tulemalga chogalmo: “Imi pemal akalzhul aga negzhe nemalmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tegin Jesús kep walgwen yalzhe nadzhun, pidzhi Pabzhe kolgal. Tegin tad-arkwatku, Jesúsdin ampa yalaganbal walkwénna kudii. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tenal Jesús-e-chapingan mata-kaka-akar ulgin pato tikajul natapmal. Tenal purwa pela-pela Jesús-e-chapingan-abin kolmai-choggu, al mata-arwed sapejul ulgin chignonida. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tegin Jesús te pangin wakurudzhik-kallin-namakedbal ti-askin kannamakal e-chapinganzhe nad. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tenal Jesús-e-chapingan takchagu tule ti-askin kannamakal kannamadani, peyedzhe-kwakijadbal kolmasmal chogalmal: —Wedin tulejul, wedin purpa. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tegidgin Jesús aga e-chapinganzhe kote chogal: —¡Melle pe tobgumalma. Antin, an Jesúsde! ");
INSERT INTO kvnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tegin Pedro Jesúsga chogal: —Tummad, ¿pe Jesús-julyé? Pe anka igal-ukdo, ti-askin kannamakal peje negal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tegin Jesús Pedroga chogal: —Anche tagdo. Tegin Pedro ul-akar tije-aktesgu, ilgwen ti-askin kannamakal Jesúszhe nad. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tenal Pedro purwa-peyedzhe-kolnonikidbal kwakid. Al Pedro tigin toktegu, Jesúszhe sapejul kote chogal: —¡Tummad, an-kama! ");
INSERT INTO kvnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tegidgin Jesús ilgwen chakwabal Pedro-kas. Tegin Jesús Pedroga chogal: —Pedin ankin-pengued-tule. ¿Ibiga pe ankin pengunoni-wede? Tenal Pedro ilgwen yakír pes. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tegin Jesús Pedrobak ulgin nakwisgu, purwa ilgwen pogigusmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tegin tulemal-Jesúsbak-ulgin-pukwamalad Pab Tummadyob Jesús-otummoalmalzhun, chogalmal: —Imi pedin chunchunnad Pab-Machiye. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tegin Jesús aga e-chapinganbak mata opasmalgu, Genesaret-neg-nugadzhe nonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tenal tule-aka-pukmalad mag takmal-choggu wedin Jesús, al tulemal neg-kweburgan-ilbal kaka palmismal, Jesúsde noni. Tenal tulemal Jesúszhe pel-kwapa tule-yemalad-cheinonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tegin tulemal Jesúszhe wilegalmal, Jesúsde tule-yemaladga igal-ukegal e-mol-tuku wis ebugal. Tenal Jesús tulemalga igal-ukchajun e-mol-tuku wis ebugal. Tenal tule-Jesús-e-mol-tuku-ebusmalad pel-kwapa nugus-pesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tegin te ibagwengin Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad Jerusalén-akar Jesúszhe nonimal. Tegin we Judio-tummagan Jesúszhe ekichialmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ibiga pe-chapingan tadgan-igal-mamikid-pallí keg immalmal ima-wede? Imi pe-chapingan, ampayo mas kunneddu, keg chunkal enukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tenal Jesús Pariseomalzhe ekichialmo: “¿Ibiga pemal Pab-igal-mezhijadgin yolemalmodé, tadgan-igalgin nanegal? ");
INSERT INTO kvnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Imi Pab Tummad chogzhado: Imi pedin aga pabgin aga nangin atagenabmal. Ex. 20:12; Dt. 5:16 Tegin Pab chogzhabaldo: Imi meke-ibi-tule aga e-pabga o chulil, aga e-nanga kaka-iskana kochal, pe we tule-mejenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Tenal pemal-Pariseomal chogmal: ‘Imi tule aga pabga, aga nanga chogzhal: We immalmal-an-pe-pentakoenad, an pel-kwapa pato Pab Tummadga ukcha. Al an keg pe-pal-penta.’ Imi pemal-Pariseomal tulemal-oturdananimaldo tule keg we immalmalgin e-pabgan-pal-pentakel. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tenal pemal-Pariseomal weob chogzhadbal, pemal pato Pab-igal-mezhijad ochulos tadgan-igalgin nanegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imi pemal pinche-askinbi-tule-nuedyob-nanemalad. Al Pab Tummad akpene e-kaka-palchoged-Isaíasbal nabir pemalgin chogzhado: ");
INSERT INTO kvnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Imi we tulemal pinche askin chunmakedginbi an-otummodamal. Tenal we tulemal aga ulubgin ankin kwen pinzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tenal we tulemal Pab Tummadyob anche kolalmalal, wedin ibga keg pel ku. Tenal we tulemal tadgan-pinche-aga-igal-onosmaladgin tulemal-oturdananimal. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tegin Jesús tulemal-yogsalmaladzhe kochagu, chogalbal: —Imi pemal nuekwa an-chogneed itomalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imi tule mas kuchal, keg purpal tule-izho. Tenal tule istar chunmakel, wedin purpal tule-izhodo. Pitogua. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tegin e-chapingan Jesúsga chognonimalzhun: —¿Imi pe wiis, Pariseomal imis-pe-chunmajad istar itosmal? ");
INSERT INTO kvnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tegin Jesús aga e-chapinganga chogal: —Ankadin iwen-kwen-akalzhul, Pariseomal istar an-chunmajad itomalal. Tenal meke-ibi-igal an-Pab mezhiszhulil, Pabdin we igal opelononiko, tule kagan-iskana unkedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tenal pemal melle Pariseomalgin chunmamalo, meke kudimal. Tenal we Pariseomal tule-iktumalad, tenal yabli aku-atamal. Tegin tule-aku-ataged tule-pid-aku-ataged-anke-natapilen, we walbogid aga mes ya-yabal arkwanmaloen. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tenal Pedro Jesúsga chogal: —Imi an peido, pedin anmalga pe palchog, imis-pe-immal-tule-izhoedgin-chunmajaddin ibi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tegin Jesús aga e-chapinganga chogal: —¿Imi an-imis-chogzhaddin pemal ampa aku-itomalmodé? ");
INSERT INTO kvnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nabir. ¿Imi pe wismalzhulzhí meke-ibi-pe-kunned unnila pe-sabalzhebi tog, tegin te-cholbal pél pe kannan mibalo? ");
INSERT INTO kvnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tenal tule aga ulubgin-akar istar chunmakel, wedin purpal tule-izho. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Imi tule-aga-ulubgin-akar-istar-pinzheedbal iskued tani: tule-mejedi, ome-pidbak yosgu taed, machered-pidbak yosgu taed, puna-yaebak yosgu taed, machibak yosgu taed, immal-aturzhedi, kakanzhedi, istar tulegin chunmaked. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","We igal purpal tule-izho. Tenal tule ampayo mas kunneddu, chunkal-keg-enukeddin, keg purpal tule-izho. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tegin Jesús tulemal-oturdajad-cholbal nadzhun, neg-kwebur-Tirozhik tegin Sidónzhik. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tenal Jesús-natapidgin, Cananea-ome-walgwen aka-tégin-maid kolmakal-kolmakal Jesúszhe noni, chogal: —Tummadye, pe David-wagwaye, imi pe wilejakwa an-takelen, nabirinye. Imi an-chiskwadin nia-nikadbal peyedzhe wilemaiye. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tenal Jesús ilgwen yakir pes, omega immal kwen chogzhajul-kus. Tegin e-chapingan Jesúszhe nonimalgu, Jesúsgin wilegalmal chogalmal: —Imi we ome inkwagus anmal-cholbal kolmadani. Imi pe we ome-wis-pentagwelma. Tenal pe ome-pentajal, pe omega chogo: ‘Pe akalzhul negzhe nejunno.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tegin Jesús aga e-chapinganga chogal: —Imi Pab Tummaddin Israel-tulemal-oweles-kudimaladzhe unnila an-palmial, Israel-tulemal-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tegin ome-Jesús-cholbal-kolmadanikid yabli Jesús-abir chimtinoni, Jesúsga chogal: —Tummadye, pe an-wis-pentakoye, anka puna-nudagalye. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tegin Jesús omega chogal: —Imi an takto, ib-nued-chul nuskangin mas-kunned chugal achumalga ukegal. Imi an Israel-tulemal-pentakenab, al an keg ku pe-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tegin ome Jesúsga chogal: —Tummad, nabir pe chogendo, tenal tule-mesagin-mas-kunpukwadgin chan egwachal, ¿achu nabir kunnojulzhí? Al pe akalzhul an-wis-pentamogoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tegin Jesús omega chogal: —Ome, imi pe ankin peyedzhe penzhul-choggu, al pe-anche-immal-ekichijadyob, an pega chiskwa-nudako. Tegidgin apka-pakal ome-e-chiskwa ilgwen nuguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tegin Jesús neg-kwebur-Tiro tegin Sidón-akar nadgu, Galilea-mata-kakche noni. Tegin Jesús yal-abaladzhe nakwisgu, kep chigwiszhun Pab-igalgin tulemal-oturdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tegin tulemal-íchejul Jesúszhe ampagunonimal. Tenal tulemal Jesúszhe tule-poni-nikmalad-cheinonimal: tule-mego-mego-nanemalad, tule-aku-atamalad, tule-orolmalad, tule-keg-chunmamalad tegin tule-yemalad-pimalad-íchejul Jesús-abir ampagunonimalmo. Tenal Jesús pél we tulemal-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tenal tulemal takchamal, tule-keg-chunmaked nabir chunma-pesmal, tegin tule-orolmalad nugus-pesmal, tegin tule-aku-atamalad nabir ata-pesmal, tegin tule-mego-mego-nanemalad nabir nane-pesmal. Tenal tulemal takchamalgu Jesús pel-kwapa tulemal-nudas, weob pakal pesmal. Tegin tule-aka-pukmalad Israel-tulemal-e-Pab-Tummad-e-nug otummoalmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tegin Jesús aga e-chapinganzhe kochagu, chogal: —Imi we tulemal ibapágus anmalbak pukwamal, tegin mas-kunned pel nikchul-choggu kunkal, al antin wilejakwa we tulemal-takalzhun. Tenal an peichul tulemal mas-kunchul negzhe nemal melle igalbal ukul tar-mesmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tegin e-chapingan Jesúsga chogal: —Imi anmal neg-nikchulidbal pukwamal-choggu, ¿anmal pia mas-kunned onogo, we tulemal-íchejul-pukwad-okunkal? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tegin Jesús aga e-chapinganga chogal: —¿Pemal melu madu wis nika-ade? Tegin e-chapingan Jesúsga chogal: —Anmal madu-walakugle wis nika, tegin ua-purwigana wis pukwabal. Tegin Jesús aga e-chapinganga chogal: —Tegil nueddo. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tegin Jesús tule-pukmaladga chogal: —Pemal napkin wis ampagumalgwelo mas kunmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tegin Jesús walakugle madu chus, tegin ua-purwigana-chusbalgu, tog-nuedi Pab Tummadga chogzha. Tegin Jesús purwi-purwi madu, ua-pipichisgu, madu tegin ua Jesúsga melgud. Tegin Jesús aga e-chapinganga madu, tegin ua-ukcha, ukin tule-pukmaladga mimigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tegin tulemal-pel-kwapa immedzhe mas kuchamal. Tenal tulemal-mas-kuchad-cholbal Jesús-e-chapingan ampa karpa-kwakugle mas-okpitchad wesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Imi tulemal-mas-kuchamalad, macherganbi milibake, tenal omegan, nuskan pel choglejul. ");
INSERT INTO kvnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tenal tulemal-mas-kuchad-cholbal, Jesús tulemalga chogal: —Imisgin pe akalzhul negzhe nemalzhunno. Tegin tulemal-naded-cholbal, Jesús kep ulgin nakwisgu, nadzhun, neg-kwebur-Magadán-omopen. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tegin Pariseomal tegin Saduceomal Jesúszhe nonimal Jesús-wilub-takegal. Tegin we tulemal Jesúsga chogalmal: —Imi pedin Pab Tummadzhe wis ekiso anmal-wagin immal-taktijulid imagal, anmal wisgal, Pab Tummad chunchunnad pe-palmialid o chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tenal Jesús we tulemalga chogal: —Chulá. Imi itigin neg-kinnid naigunonikil, pemal chogaldamal: ‘Imi neg chedo pél kinnidbi nail, al anmal wismaldo, pan neg-yola-pakal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tegin pemal chogaldamalbal: ‘Imi neg wakur-wakur pél kinnidbi naibalil, al anmal wismaldo, imis ti-widani.’ Imi pemal nued wismal neg-taklegedbal, neg igi kuo. Tenal pemal immal-kunaidbal yabli wichulmal, igi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Imi tule-iskana tegin tule-Pabgin-nosmalad peigujimaldo antin ega immal-taktijulid ima oyogal an Pab-akar tani. Tenal we tulemalga immal-taktijulid kwen oyogojul-kuo. Tenal we tulemal Jonásga-immal-kujadbal unnila wisguo, antin ibi-tule.” Tegin Jesús aka-pukwa we tulemal-ebesmal. Tegin Jesús nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tegin Jesús aga e-chapinganbak mata opaknatapidgin, teun Jesús-e-chapingan aga madu igesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tegin Jesús aga e-chapinganga chogalzhun: —Aga pe nue takermal, Pariseomal tegin Saduceomal e-madu-inaje. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tenal Jesús-e-chapingan aga emal-emal Jesús-emalga-chogzhadgin chunmakalmal, chogalmal: —¿Imi anmal madu cheinonijulidbal, al Jesús weob anmalga chogalyé? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tenal Jesús itosgu e-chapingan madu-cheinonijulidgin chunmananimal, Jesús aga e-chapinganga chogal: —¿Ibiga pe madu-cheinonijulidgin, pe chunmananimal-wede? ¿Pemal ampa ankin penmaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pemal ampa aku-itomalbaldé, an pega chunmajad? ¿Pe pato igesmaldé, an madu-walatalgin miliatal tulemal-okuchad? ¿Pe pato igesmalbaldé, teun karpa-kwabigwa mas-okpitcha-jogna? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tegin pe pato igesmalbaldé an madu-walakuglegin milibake tulemal-okuchad? ¿Pe pato igesmalbaldé, teun karpa-kwabigwa mas-okpitcha-jogna? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tede pe igi aku-itone, antin sanal madugin kwen chunmajul? Tenal an pemalga chogdo: pemal nue aga pe takermal Pariseomal tegin Saduceomal e-madu-inagin. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tegin Jesús-e-chapingan kep mag itononimal Jesús ibi madu-inagin ega chunmanai. Imi Jesús madu-inagin ega kwen chunmajul, tenal Jesús e-chapinganga chogzhado emaldin nue aga takermal Pariseomal tegin Saduceomal tulemal-oturdaked-igalgin. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tegin Jesús neg-kwebur-Cesarea-de-Filipo-tikalzhe nonigu, Jesús aga e-chapinganzhe ekichial: —¿Tulemal igi ankin chogmal, an-Te-Tule-Chunnade toa-tule? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tegin e-chapingan Jesúsga chogalmal: —Tulemal-kwénna-kwénna chogmaldo, pede Juan-Bautista-purkwijad. Kwéntin chogmo pedin Elías-patoun-purkwijad. Kwéntin choge pede Jeremías-patoun-purkwijad. Chulil, pede Pab-kaka-palchoged-pimalad-walgwen. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tegin Jesús aga e-chapinganzhe ekichialmo: —¿Anná, pemalde igi ankin chogmalmode ante toa-tule? ");
INSERT INTO kvnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tegin Simón-Pedro Jesúsga chogalzhun: —Imi pedin Cristo-Pab-akpene-chogzhad-palmidagoed-tule. Pe Pab-Tummad-Tulad-E-Machi. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tegin Jesús Pedroga chogal: —Jonás-machi-Simón, Pab pega ib-nued imas. Imi pe-ankin-chogzhad, tule pega kwen chogzhajul, an-Pab-nikpa-maid pega chogzha, antin Pab-Machi. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Imi an pega chogdo: imi pedin Pedro, tenal an we akwa-askin iglesia chobnaidyob, an pebal tulemal-urpo, anpal naigugal. Tenal purkwed-tule-mejed meke-igi we tulemalgin kwen nakwejul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tenal an pega Pab-neg-takmaid-e-llavemal uko. Imi meke-ibi-igal pe-chogzhadbal iti-napkin kalenonikil, we igal Pab-neggin kalenonimogo. Tenal pe-chogzhadbal meke-ibi-igal pe iti-napkin ukel, Pab-neggin we igal tulega uklemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tegin Jesús aga e-chapinganga chogal: —Imi pe melle tule-pimaladga pe palchogo, an Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Imi teun-akar Jesús aga e-chapinganga chogdi-kual, ede Jerusalénzhe neenab, tegin Judio-chelegan-tummagan tegin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad peyedzhe e-owiomalo. Tegin Jesús chogalbal tulemal e-mesmalo, tegin Pab Tummad ibapágin kannan e-otullenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tegin Pedro itosgu immal Jesúsga kune, pidzhi Jesús-ches. Tegin Pedro Jesúsga chogal: —Tummad, imi pe-chogzhadyob Pab pega melle immal imakelen, nabirin. Tenal pe-imi-chogzhadyob pe kwen wilegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tegin Jesús Pedrozhik akpiridgu, Pedroga chogal: —Nia-Satanás, pe we-akar nema. Pedin igal-puledgin an-egwanbi-kual. Tenal pedin Pab-igalgin kwen pinzhejul, pe tule-igalgin pinzhenai. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tegin Jesús aga e-chapinganga chogalzhun: —Imi meke-ibi-tule anpal naigubiel, we tule aga tukingabi pal kwen pinzhejulinab. Tenal tule kuakwa kudiinabbal anka purkwegal, tule nakrusgin aga purkwe-natapidyob. Tenal tule an-chogzhadyob naneel, kep ankin-turdaked-tulega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Imi meke-ibi-tule anpal-naidbal yapa purkwejogel we tule yabli pelgunoniko. Tenal meke-ibi-tule anpal-naidbal akalzhul purkwejogel, we tule chunchunnad tullenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Imi tule pel-kwapa iti-napkin immalmal nikunonikilen, tenal purpa-abonoged kwen nikchulil, ¿ibi-nued we tulega kunoniko pe ebinzhe? Chulá. ¿Tenal tule ibi-immalmal-ukedgin unnio aga purpa abonogal melle Pabzhe sapejul oturdalegal? Chulá. Keg kue. Tenal immal kwen nikchul tule aga purpa abonogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Imi an-Te-Tule-Chunna an-Pab-nugu-taklegedgin tegin an-angelmalbak noniko. Tenal an-nonikoedgin, tule-anka-immal-imajadbal an tulemal-ilbal immal uknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tenal an chunchunnad pemalga chogdo: imi tulemal-pukwad-wal-walgwen ampayo purkweddu, an-Te-Tule-Chunna neg-takegal-tanikid takmalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tegin te ibanerkwagin Jesús yal-tummad-pirzhe pidzhi walapá aga e-chapingan-ches, Pedro, Jacobo tegin Jacobo-e-urpa-Juan, Jesúsgin pelugles walabake. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tegidgin Jesús e-chapingan-walapá-kwichid-wagin akalgus. Tenal Jesús-e-wagal tadgwayob kanoni-pes. Tegin Jesús-e-molmal chipú kanoni-pesbal, kallen-chegagiidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tegin Jesús-e-chapingan pato takalmal, Moisés tegin Elías Jesúsbak chunmananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tegin Pedro Jesúsga chogal: —Tummad, anmal wegin núed pukwamal. Imi pe yer itogel, anmal pemalga kwapá obuneg chobnemal: pega kwagwen, Moisésga kwagwen, tegin Elíasga kwagwenmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tegin Pedro ampa chunmanaidgin po-chipú-takleged pel-kwapa Pedromal-edunoni. Tenal Pedromal po-yabal togzhagu, tule-kakapurwa kolnoni chogal: “Wedin an-Machi-Pilaled. Tenal an we machigin weligwal-itomo. Imi pemal nue an-Machi-itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tenal Jesús-e-chapingan itosgu Pab Tummad arpak eje kolnoni, peyedzhe kwakijadbal napche askun agladmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tenal Jesús aga e-chapingan-abir-kwisgunonigu, chunkalgin aga e-chapingan-ebus. Tegin Jesús aga e-chapinganga chogal: —Pe kwisgumalma. Melle pe tobgumal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tegin Jesús-e-chapingan atadgu, pato takalmal Jesúsbi walkwénna kwichi. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tegin Jesús aga e-chapingan-walapágwadbak yal-pir-akar aktealmalgu, Jesús aga e-chapinganga chogal: —Pe imis imial immal takchaddin pe melle tule-pimaladga pe pal an-chogo. Tenal an-Te-Tule-Chunna purkwijad-akar kannan tullejal, kep pe tulemalga chogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tegin e-chapingan Jesúszhe ekichialmal: —Imi Moisés-igalgin-tulemal-oturdamalad chogmal: ‘Yo Pab-akpene-chogzhad-palmidagoed-tule tageddu, Elías inzhel noniko.’ ¿Ibiga teob chogmaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tegin Jesús aga e-chapinganga chogalzhun: —Imi Moisés-igalgin-tulemal-oturdamalad nabir chogmaldo, Elías inzhel noniko, tulemal-pel-kwapa Pabgin pinzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tenal an pemalga chogzhundo: Elíasdin pato noni, tenal tulemal yabli aku tar-takchamal. Tegin tulemal iwenchuli Elías-imasmalbal. Tegin an-Te-Tule-Chunna ampa Elías-yopí tulemalzhe peyedzhe wilemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tenal Jesús-e-chapingan kep mag itononimal, Jesús Juan Bautistagin chunmajii, Elíasgin chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tegin Jesús aga e-chapinganbak tulemal-pukwadzhe nonimalgu, tule-walgwen Jesús-abir chimtinoni, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tummadye, imi pedin wilejakwa an-machi-takelen, nabirinye. Imi an-machi purkwed-nikadbal peyedzhe wiledii. Tenal we machi impa-impagin purkwialil, chogin agladda, o chulil, tigin arkwattabal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tenal antin pe-chapinganga an-machi-cheinoni anka nudagal. Tenal pe-chapingan kwen unniguszhulmal an-machi-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tegin Jesús chogal: —¿Imi pemal-ankin-penmalad tegin pe-yapa-an-itomalad, an inkwáje pemalbak kudiguenabmal-wede pe ankin penzhulmalgal? ¿Tegin an inkwáje pemal-abin-purtidio-wede, pemal kep ankin ibzhemalgal? Nabir. Imisgin pe anka machi-chedado, an pega nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tegin machi-e-pab aga Jesúszhe e-machi-cheinonijun. Tegin Jesús sapejul niaga chogal: —Imisgin pe we machi-akar noo. Tegidgin machi ilgwen nuguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tenal Jesús-e-chapingan pidzhi Jesúszhe ekichial chogalmal: —¿Ibiga anmal kwen unniguszhulmaldé nia-onigal? ");
INSERT INTO kvnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tegin Jesús aga e-chapinganga chogal: —Imi pemal ampa ankin penmal-choggu, al pemal keg kugusmal. Tenal an chunchunnad an pemalga chogdo: imi pemal mostaza-kwaun ankin kwen penzhulil, pe we yal-tummad-kwichidga pe chogzhal: ‘We-akar webal pe akniro,’ we yal keg-chulgu pe-chogzhadbal aknirenab. Imi pemalga keg chogel, ‘Immal keg ku.’ ( ");
INSERT INTO kvnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tenal an-imis-nia-onijad tutujul onigal. Tenal pemal mas-kunchulidginbi tegin Pabzhe-koledginbi pemal kep unnigumalo wegiid-niamal-onigal.) ");
INSERT INTO kvnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tegin Jesús aga e-chapinganbak Provincia-Galileagin pipirmadiidgin, aga e-chapinganga chogal: —Imi an-Te-Tule-Chunna manigin tulemalzhe uklenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tenal we tulemal an-mesmalo. Tegin an ibapágin kannan tullenoniko. Tenal e-chapingan Jesús-chogzhad itosgu, peyedzhe pukib-pinzhe-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tegin Jesús aga e-chapinganbak Capernaumzhe nonigu, tule-Pabzhe-koled-negga-mani-weimalad Pedroje ekisnonimal chogalmal: —¿Imi pe-oturdaked, Pabzhe-koled-negga-mani-egwanmalad penukyé? ");
INSERT INTO kvnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tegin Pedro we tulemalga chogal: —An-oturdaked we mani penukdo. Tegin Pedro neg-yabal togzhagu, ampayo Jesúszhe immal ekiseddu Jesús-inzhel Pedroje ekichial chogal: —¿Simón, tule-iti-napkin-erreyga-mamimalad, toagin impuesto-mani egwannanimal? ¿E-tulemalgin o tule-pimaladgin? ¿Igi pe chogmo? ");
INSERT INTO kvnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tegin Pedro Jesúsga chogal: —Erreymal tule-pimaladgin mani egwannanimal. Tegin Jesús Pedroga chogalmo: —Teobdo. Imi erreymal tule-pimaladgin mani egwannanimal-choggu, al errey-e-tulemal mani pal penuked-wilub-chuldo. ");
INSERT INTO kvnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tenal tulemal melle istar anmal-takegal, anmal yabli we mani penukmalo. Imisgin pe naddo mataje, ua-chwagal. Tenal pe kepe-ua-chwaoed-kaka pe egao. Tenal we ua-kaka-yabal pe mani onogo. Tenal we mani unnio anka tegin pega mani-egwannanimalad-penukegal. Tenal pe we mani cheinonikil, pe tule-mani-egwanmaladga pe uko. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Imi teun takalgu, e-chapingan Jesúszhe ekisnonimal: —¿Imi Pab-neg-takmaidgin toa pul tule-tummadga kuo? ");
INSERT INTO kvnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tegin Jesús aga e-chapinganga chogal: —Nabir. Kepegin an pemalga oyonegwel, pemal mag takmalgal. Tegin Jesús machi-totoje kocha, e-waglik kwisgunonigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tegin machi-toto Jesús-waglik kwisgunonigu, Jesús chogalbal: —Imi an chunchunnad pemalga chogdo: imi pemal aga pinzheed-ogwajulil, tegin pe nuskan-purwiganayob pinzhenonijulil, pemal meke-igi Pab-neg-takmaidgin kwen togojulmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Al meke-ibi-tule we machi-totoyob aga toto imajal, we tule Pab-neg-takmaidgin pul tule-tummadga kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tenal meke-ibi-tule an-nuggin ampokaal wegiid-machi-toto-abingeel, we tule pato ampokaal an-abingenonimo. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tegin Jesús chogalbal: “Imi meke-ibi-tule iskuedgin ankin-ibzheed-mimmi-egwachal, we tule peyedzhe oturdalego. Tenal we tulega pul iwen-akalzhul termal-wiladgin tukalgin akwa-mu-edinal-nai metel. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Imi tule-iti-napkin-pukmalad anpi pe wilesmalma. Pemal iskuedgin tule-egwanmaladbal, pe peyedzhe oturdalego. Imi we immalmal keg-chulgu kued-wilub. Tenal pemal-iskuedgin-tule-egwachad anpi pe wilesmalma, pe peyedzhe oturdalego. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Imi pe-chunkal o pe-nag-dewa iskuedgin pe-egwachal, pul pe chiko, tegin tikajul pe-akar pe meto. Tenal pega pul iwen-akalzhul chunkal-orol o nag-orol-dewa nanegal, pul chunkal-pog-pel tegin nag-pog-pel, cho-chagla-keg-akinnedzhe melledgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tenal pe-imia iskuedgin pe-egwachal, pul pe imia-unko, tegin tikajul pe-akar pe meto. Tenal pega pul iwen-akalzhul imia-kwagwen nanegal, pul imia-kwabo-pel cho-chagla-keg-akinnedzhe melledgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Tegin Jesús chogalbal: “Imi pemal nuekwa pinzheenabmal melle iwenchuli purwigana-takegal. Imi purwigana-e-angelmal Pab-neggin Pab-maid-waglik pukwadamal, Pabga pél immal choggal. ( ");
INSERT INTO kvnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tenal an-Te-Tule-Chunna noni, tule-Pabgin-nojadbal-oweles-kudimalad-abonogal.) ");
INSERT INTO kvnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Imi tule oveja-wala-tulaatal-nikal, tegin tulebi oveja-walgwen owelejal, we tule igi chao pe ebinzhe? ¿Imi we tule yal-nabal oveja-pukmalad-ebegwelojulzhí, kep oveja-owelejad-aminegal? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Tenal an chunchunnad pemalga chogdo: tenal we tule oveja-owelejad-onojal, oveja-onojadbal pela-pela weligwal itononiko, pul oveja-oweleszhulmaladga. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Imi pe-Pab-nikpa-maid ampa oveja-yopí kwen peichulmo, purwigana-walgwen egin periengumo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tegin Jesús chogalbal: “Imi kwenad-walgwen pegin walmajal, pe kwenadzhe neenab. Tegin pe pidzhi kwenadga chogo: ‘Pedin weob-weob ankin nos.’ Imi we kwenad pe-chunmajad yer itojal, pedin pato aiga kwenad-imasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Tenal we kwenad pe-chunmajad kwen abingaszhulil, pe walgwen o walbo-dewa kwenamalad-chedo pe-apinni-chunmajad itogalbal. Tenal kwenad-pegin-walmajad pemal-chunmajad yer itojal, pedin pato aiga we kwenad-imasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Tenal kwenad-pegin-walmajad pe-tule-chesmalad-chunmajad abingaszhulmogal, pedin pe iglesiaginmaladga chogo. Tegin we kwenad iglesia-ega-chogzhad yapa abingebalil, pedin tule-Pab-wichulidyob pe we kwenad-imakenabmal, tegin tule-Romano-tummadga-mani-egwanedyob pe we kwenad-imakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Imi an chunchunnad pemalga chogdo: imi pemal iti-napkin chogzhal: ‘We tule nos,’ Pab-neggin-pukmalad ampa pe-chogzhad-yopí we tulegin chognonimalmogo: ‘We tule nos.’ Tenal pemal iti-napkin chogzhal: ‘We tule pato kannan nugus,’ Pab-neggin-pukmalad ampa pe-chogzhad-yopí we tulegin chognonimalmogo: ‘We tule pato kannan nugus.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Imisgin an chunchunnad pemalga chogbaldo: imi pemal-walbogin iti-napkin aga igal-nudasmalal Pabzhe immal ekisgal, an-Pab-nikpa-maid pe igal-nudasmaladbal pemalga immal imanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tenal tule-walbo o walapá-dewa an-nuggin ormabukmalal, antin we tule-ormabukmalad-abalgin kujimo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tegin Pedro Jesúszhe ekisnoni chogal: —Tummad, ¿an-kwenad ankin walmajal, ilabigwa an kwenadga chogenab: ‘Pe-iskued pelgus?’ ¿Ilakugle o chul? ");
INSERT INTO kvnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tegin Jesús Pedroga chogal: —Tenal an pega chogdo: pe ilakugle choged-wilubzhul. Wedin twagdar ichegwa. Tenal pedin ilakugled tulapá-kakaambe-eg-kaka, pe kwenadga chogenab: ‘Pe-iskued pelgus.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tegin Jesús chogalbal: “Al Pab-neg-takmaid erreyyob. Imi we errey aga e-mosmalzhe pél e-mani ekichis, e-mosmal igi e-mani imas. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tenal errey mosmalzhe ekichialgu, tulemal erreyzhe mos-walgwen-cheinonimal. Imi we mos ol-mani-miliambe e-tummadgin mani kalenai. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tenal we mos mani nikchul-choggu e-tummadga pél penukkal, al e-tummad chogalzhun, ede mos, tegin mos-e-ome, tegin mos-e-nuskan tegin mos-e-immalmal-nikad pél manigin ukne, we mos-egin-mani-kalenaid pél ega penukedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Tegin we mos e-tummad-abir chimtinonigu, e-tummadga chogal: ‘Pe an-wis-abintagweloye, tenal antin yabli pega pinna-pinna pel-kwapa pegin-mani-kalenaid penukoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tenal tule-tummad wilejakwa we mos-taknonigu, chogal: ‘Pe melle pukib-itoma. Pe-ankin-mani-kalenaid pato pelgus.’ Tegin tule-tummad we mos-ololchaszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tenal mos-ololgujad nadgu, e-pakad-egin-iche-mani-kalenaid-abingus. Tegin we mos-ololgujad tukalgin tule-egin-mani-kalenaid-kas, tegin tule-egin-mani-kalenaidga chogal: ‘Imi pe-ankin-mani-kalenaid pe imis-imis pe anka penukenab.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Tegin tule-iche-mani-kalenaid ilgwen we mos-ololgujadga chimtis chogal: ‘Pe an-wis-abintagweloye, tenal antin yabli pega pinna-pinna pegin-mani-kalenaid penukoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Tenal mos-ololgujad tule-iche-mani-kalenaidga chogal: ‘Chulá.’ Tenal mos-kepe-ololgujad ilgwen nadzhun e-pakad-tuktigal. Tegin mos-ololgujad oturdaleged-neggin e-pakad-odoszhun pél egin-mani-kalenaid penukedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tenal mos-pimalad takchamalgu tule-iche-mani-kalenaid oturdaleged-neggin odoles, peyedzhe pukib-itononimal. Tegin we mosmal e-tummadzhe nadmal, pél palchoggal, mos-ololgujad istar e-pakad-imas. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Tegin tule-tummad kepe-mos-ololchajadzhe kochagu, we mosga chogal: ‘¿Ibiga pe oturdaleged-neggin pe-pakad-odos-wede? Pe we mos-oturdaked-wilub chul. Pedin mos-iskana. Imi pe-anka-wilejadbal an pega chogzhado: Pe-ankin-mani-kalenaid pato pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tenal an pega-chogzhadyob, pe-pakadga pe choged-wilubmogan. Tenal pedin anyob kwen imaszhul.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tegin tule-tummad kepe-mos-ololchajadgin peyedzhe ulualzhun. Tegin tule-tummad peyedzhe-tule-owiomaladga we mos-ukcha, pél e-tummadgin-mani-kalenaid penukedzhe.” ");
INSERT INTO kvnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tegin Jesús chogalbal: “Imi pemal aga ulubgin yapa kwenad e-iskuedbal pelgus chogel, an-Pab-nikpa-maid ampa teopí sapejul pe-oturdanonimogo. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tegin Jesús pél chunmasgu, Provincia-Galilea-akar nadzhun Provincia-Judeazhik, Jordán-tiwal-opakal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tenal teun tulemal-íchejul Jesúsbak kudimalmo. Tenal Jesús aka-tebal tule-yemalad-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tegidgin Pariseomal-wal-walgwen Jesúszhe nonimal Jesús-wilub takegal. Tegin Pariseomal Jesúszhe ekichialmal: —¿Imi tule nabir yogasal ome-meto? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tegin Jesús Pariseomalga chogal: —¿Imi pe Pab-karta-nermakal-maid pe apchodimalzhulzhí? Imi Pab-kartagin chogdo: Imi Pab kepe-saglagin abirginagwal tule-opinnis. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Tegin Pab chogzhabaldo: Imi an abirginagwal tule-imas-choggu, al machi ome-nikuedbal aga-pab-aga-nan-ebegenab, aga e-omebak mecha kudigugal. Tenal we tule-walbogid aga nikusmalal, aga chan-walkwénna kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Al we abirgin pato walbojul, pato chan-walkwénna kunonimal. Tenal Pab Tummad abirginagwal tule-imas-choggu, al tule igal-kwen-nikchul, we abirginmalad-idirgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tegin Pariseomal Jesúszhe ekichialmalbal: —¿Tede Moisésde ibiga igal-mezhiszhun, tule ome-metpiel, omega karta ukenab, kep ome-metkal? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tegin Jesús Pariseomalga chogal: —Imi pemal-yapa-igal-mamikidbal-naneedbal, al Moisés igal-mezhis tule akalzhul aga ome-metkal. Tenal kepe-saglagin igal-weob-kwen-maichul. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Imi an pemalga chogdo: meke-ibi-tule ome-machered-pidgin-yoleszhulidbal aga ome-metel, tegin ome-pid-nikujal, we tule pato ome-pidgin-yolejadyob iskunoni. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tenal Jesús-e-chapingan Jesús-Pariseomalga-chogzhad itosmalgu, Jesúsga chogalmal: —Imi pe-chogzhadyob anmalga igal-mai-choggu, tegil anmal pul-melle ome-nikumalodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tegin Jesús chogalbal: —Chulá. Tenal tule-pel-kwapa unnijulmal pe-chogzhadyob ome-nikchulidgin nanegal. Tenal Pab-tulega-igal-ukchamaladbi unnimalo, ome-nikchul nanemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Imi tule-wal-walgwen kusgu mimmilejadbal keg ome-nikumal, tenal tule-wal-walgwen tule tarbi kwa-chujadbal keg ome-nikumal, tenal tule-wal-walgwen Pab-neg-takmaidga-arpabiedbal keg ome-nikumalbal. Tenal tule an-chogzhadyob unnil ome-nikchulidgin nanegal, akalzhul an-chogzhadyob nanaodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tegin tulemal Jesúszhe purwigana-cheinonimal, Jesús purwigana-ebunaidgin purwiganaga Pabzhe kolgal. Tenal Jesús-e-chapingan tulemal-Jesúszhe-nuskan-cheidanimaladzhe ulualmal-chogalmal: “Melle Jesúszhe nuskan-chedamalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tegin Jesús aga e-chapinganga chogal: —¿Ibiga pe tulemalga weob chogde melle anche nuskan-chedamalo? Nuskan meke anche tagmalodo. Imi Pab-neg-takmaid we nuskanyob-kudimaladga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tegin Jesús chunkalgin nuskan-ebusgu, nuskanga Pabzhe kocha. Tegin Jesús kep ukin nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Imi teun takalgu, tule-walgwen Jesúszhe noni, tegin Jesúszhe ekichial: —Tule-oturdaked, ¿ibi immal-nuegan an imakenabdé, an ilagwen-nadgu tullegal? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tegin Jesús we tulega chogal: —¿Ibiga pe anche ekisnaide, piti-igal pul-nued? Imi Pab Tummadbi unnila tule-nued. Tenal pe ilagwen-nadgu tullebiel, pe Pab-chogzhad-pallí naneenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tegin we tule Jesúszhe ekichialbal: —¿Piti igalzhun? Tegin Jesús we tulega chogal: —Melle pe tule-mejo. Melle pe ome-pidgin yolego. Melle pe immal aturzhao, pe melle tulegin pinche-pinche kakanzhao. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tegin pedin aga pabgin aga nangin pe atagenab. Tegin pe aga tukin chan pilaledyob, pe tule-pimalad-pilalguenabmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tenal machi-Jesúszhe-immal-ekisnonikid Jesúsga chogal: —Imi pe-anka-chogzhadyob antin pel-kwapa weob nanedii. ¿Tegil an ibi napíjun? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tegin Jesús we machiga chogal: —Imi pe inniki nued nanebiel, pedin negzhe nao. Tenal pe neg omojal, pél pe-immalmal-nikad pe manigin uko. Tegin pe tule-wiledimaladga pe we mani ukpalo. Tenal an-pega-chogzhadyob tule-wiledimaladga pe mani ukchal, pedin Pab-neggin íchejul immalmal-nuegan nikunoniko. Tenal pe tule-wiledimaladga pél-mani-ukchad-cholbal kep pe anche tago, ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tenal machi peyedzhe-immalmal-nikad-yapa-ukedbal Jesús-ega-chogzhad itosgu, pukib-ito-pes. Tegin we machi ilgwen nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tegin Jesús aga e-chapinganga chogalzhun: —Imi an chunchunnad pemalga chogdo: ¿Peyedzhe pe takchulzhí tule-mani-ibed pirkin-mani-pilaledbal Pab-neg-takmaidzhe toggal? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tenal an kannan pemalga chogbaldo: imi moli-camello pul-pulejul wag-iko-imia-yabal toggal, pul tule-mani-ibed Pab-neg-takmaidgin toggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tenal Jesús-e-chapingan Jesús-chogzhad itosgu, pul-pule weob pakal pesmal. Tegin e-chapingan Jesúsga chogalmal: —¿Imi tule-mani-ibed Pab-negzhe-toggal ib-peyedzhe-choggu, tegil toa abonolegojun? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tegin Jesús nuu aga e-chapingan-taktegu, chogal: —Imi tulega immal-keg-kued, Pabgadin pél immal nabir kunonida. Al Pab Tummad unni e-neg-takmaidgin tule-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tegin Pedro Jesúsga chogalzhun: —Imi anmal pel-kwapa immalmal ebesmal pebal-naigugal. ¿Tegil ibi anmalga uklenonimalmogojun? ");
INSERT INTO kvnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tegin Jesús aga e-chapinganga chogal: —Imi an chunchunnad pemalga chogdo: imi Pab Tummad kannan pel-kwapa neg-opinnijal, an-Te-Tule-Chunna Pab-nugu-takleged-kangin tule-tummadga chigwitapo. Tenal pemal-anpal-naigusmalad-walambe-kakabogwad ampa te ibegin anpak mes tummagan-kan-kwaambe-kakabogwadgin chigwitapmalmogo, Israel-tulemal-chogambe-kakabogwadga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Tenal meke-ibi-tule anpal-naigujadbal aga immalmal ebejal: nega, iamal, urpamal, punmal, paba, nana, nuskana tegin nagnugan, we tule ila-tulaataled-ilgwen-eg-kwena immalmal nikunoniko. Tegin we tule ilagwen-nadgu tullenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Tenal tulemal-ichejul-iti-napkin-tummaganga-irmamalad, Pab-neggin tule-pinchegadga kunoniko. Tegin tulemal-ichejul-iti-napkin-pinchemaladga-irmamaladdin, Pab-neggin tule-tummaganga kunonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tegin Jesús purpal chogalbal: “Imi Pab-neg-takmaid tule-nagnu-ibedyob. Imi tule-nagnu-ibed polego nad tule-amigal, ega nagnugin arpamalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tenal tule-nagnu-ibed tule-amisgu, tulemalbak igal-nudas ibagwen-arpaged-wilub penukkal. Tegin tule-nagnu-ibed nagnuje tulemal-palmiszhun ega arpagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tegin tule-nagnu-ibed wachilbakebakegin tule-immal-ukmalad-negzhe kannan nadbalgu, tule-pimalad-takalbal pinche pukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tenal tule-nagnu-ibed we tulemalga chogal: ‘Pe nemalmoma an-nagnuje arpanegal. Tenal pe-arpagoedbal an pemal-penuko.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tegin we tulemal nagnuje nadmalzhun arpagal. “Tegin tule-nagnu-ibed yoroku tule-immal-ukmalad-negzhe kannan nadbalgu, tule-pid-amisbal nagnugin ega arpagal. Tegin tule-nagnu-ibed wachilapágin kannan nadbalgu, tule-pid-amisbal nagnugin ega arpagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tegin tule-nagnu-ibed wachilatalgin kannan nadbalgu, tule-pimalad-takalbal pinche pukmal. Tenal tule-nagnu-ibed we tulemalga chogal: ‘¿Ibiga pe wakur-akar itigin pinche pukmal-wede?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tegin tulemal-pinche-pukmalad nagnu-ibedga chogal: ‘¿Imi tule arpagal an-amijulil, an igi arpago? Al anmal pinche pukmaldo.’ “Tegin tule-nagnu-ibed tule-pinche-pukmaladga chogal: ‘Tegil pe nemalmodo, an-nagnugin arpagal.’ Tegin tule-pinche-pukmalad nadmalzhun nagnugin arpagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Tegin neg-chedogusgu, nagnu-ibed tule-e-nagnu-takchiidga chogal: ‘Imi pe tulemal-anka-arpasmaladzhe pel-kwapa kolo, pe we tulemalga mani penukegal. Tenal pe tule-chol-napi-arpagedgin-togzhamalad inzhel pe penuko. Tegin pe ukin-ukin tulemalga manigin penukchunno, kepe-arpagedgin-togzhamaladzhe.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tegin tule-wachilatal-arpagedgin-togzhamalad nonimalgu, ibagwen-arpaged-wilub we tulemalga penukles. Tegin tule-arpasmaladga ukin-ukin manigin penuklesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tegin tule-kepegin-arpagedgin-togzhamalad wilub omosgu penuklegal, we tulemal ebinzhasmal, emalga pul-ichejul mani penuklego. Tenal we tulemal-pinzhebukwadyob yabli mani kwen penukleszhul. Tenal we tulemalga ibagwen-arpaged-wilub penuklesmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Tegin tulemal-kepe-arpagedgin-togzhamalad, mani ega penuklesgu, tule-nagnu-ibedgin ulualmal, chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Imi tule-napi-arpagedgin-togzhamalad unnila pinche wachilgwen wis arpasmal. Tenal anmalga-penuklejad-yopí pe we tulemalga mani pennusmalmo. Tenal anmaldin peyedzhe wilesmal tegin tad peyedzhe anmal-kukchamalbal. Tenal pe anmalga weob penuked-wilubzhulin, tenal pe anmalga pul-melu mani penuked-wiluban.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tegin tule-nagnu-ibed tule-kepe-arpagedgin-togzhamalad-walgwenga chogal: ‘An-ai, antin pe-kwen-yardanaichul. ¿Imi an pebak igal-mezhiszhulzhí, ibagwen-arpaged-wilub-manigin pe-penukegal? ");
INSERT INTO kvnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wegin pe-arpaged-mani pe chudo. Imisgin pe nad. Imi an peido, tule-napi-arpagedgin-togzhamalad pe-yopí mani abingemo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tenal an igal-nikado, an-itolegedbal naga mani imagal. ¿Imi antin tulega-wilub-okpinal mani naboedbal, al pe ankin istar pinzhemalyé?’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tegin Jesús chogalbal: “Imi an purpal pemalga immal chogzhadyob ampa kujal tulemalga kunonimogo. Imi tule-tummagan tule-pinchegadga kunoniko, tenal tule-pinchegaddin tule-tummadga kunonimogo. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tegin Jesús Jerusalén-neg-kweburzhe natapidgin, pidzhi aga e-chapingan-walambe-kakabogwadzhe kocha. Tegin Jesús aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Imi anmal Jerusalénzhe natapmal. Tenal Jerusaléngin tule manibal an-Te-Tule-Chunna-uknoniko tule-irwal-Pabzhe-koled-tummaganzhe tegin Moisés-igalgin-tulemal-oturdamaladzhe. Tenal we Judio-tummagan anka-igal-itogoedgin ankin chognonimalo, antin keg-chulgu purkweenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tenal we Judio-tummagan Judiojulmaladga an-ukmalo. Tenal tule-Judiojulmalad ankin istar todomalo, tegin peyedzhe an-ebiomalo, tegin nakrusgin an-piokmalbalo an-mesgal. Tenal Pab Tummad ibapágin kannan an-otulononibalo. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tegin Jesús-chunmajad-cholbal, Zebedeo-ome aga e-machimalbak Jesús-abir chimtinonimal Jesúszhe immal ekisgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tegin Jesús we omeje ekichial: —¿Ibi pe pei-ade? Tegin we ome Jesúsga chogal: —Imi antin, an peido pe anka nuekwa chogo, pe neg-takmaidgin pe tule-tummadga togzhal, an-machi-walbogwad pe-cholbalmaladga kugal, kwéntin pe-nuedzhik chiggal, kwéntin pe-chapilezhik chiggalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tenal Jesús we omega tegin e-machimalga chogal: —Imi pe immal-kwen-wichulidgin pe chunmanaima. ¿Imi pemal unnimalmogoyé, an-wilegoedgin wilegalmo, an kobed kobneedyob? Tegin we tule-walbogid Jesúsga chogalmal: —Anmal unnimalmodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tegin Jesús tule-walbogidga chogalbal: —Imi pemal anyob unnimalmo-choggu, al pe akalzhul anyob wilemalmogodo. Tenal tule an-nuedzhik tegin an-chapilezhik-chigmaloeddin, ankin chijul choggal: ‘We tulemal an-cholbalmaladga kugal.’ Tenal an-Pabdin pato tule-chus an-cholbalmaladga kugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tenal Jesús-e-chapingan-walambegwad wisgusgu Jacob tegin Juan tule-tummadga togbi-kualmal, we tule-walbogwadzhe ulualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tenal Jesús aga e-chapinganzhe kochagu, ka chogal: —Imi pemal wismaldo, iti-napkined-saglagandin tummarba-itogedgin nanemal. Tegin tummagan-e-cholbalmalad chabzhul tulemal-imakaldamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Tenal pemal-abalgin iti-napkined-tummagan-tamaladyob pemal naneed-wilubzhulmal. Imi meke-ibi-tule pemalga tummadga kubiel, we tule melle tummarba itogenab, tenal we tule pul mosyob tule-pentakenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tenal meke-ibi-tule pemal-abalgin-pul-tule-tummadga kubiel, we tule pul-pule tule-pinche-arpagedyob naneed-wilubmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","“Imi an-Te-Tule-Chunna ampa an-chogzhad-yopí mosyob kudimo. Tenal an kwen nonijul tule mosyob anka immal imagal. Tenal antin nonido tulemalga immal imagal. Tegin an nonibal, an-purkoedbal íchejul tule-abonogalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tegin Jesús aga e-chapinganbak Jericó-neg-kwebur-akar nadgu, tulemal-íchejul Jesúsbak nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Imi teun tule-walbo-aku-atamalad igal-nabal pukwamal. Tenal we tule-walbogwad itosgu Jesús egin tani, Jesúszhe kotemal chogalmal: —¡Tummad, pe David-wagwaye, imi pe wilejakwa anmal-takelen, nabirinye! ");
INSERT INTO kvnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tegin tulemal we tule-walbogid-aku-atamaladga chogalmal: —¡Melle pe kolmama! ¡Pe yakir-kuma! Tenal we tule-walbogid pul-kigma kolmakal chogalmal: —¡Tummad, pe David-wagwaye. Imi pe wilejakwa anmal-takelen, nabirinye! ");
INSERT INTO kvnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tegin Jesús tule-aku-ataged-itosgu, kannamamaid kwisgunoni. Tegin Jesús tule-walbogid-aku-atamaladzhe kocha. Tegin tule-aku-atamalad Jesúszhe nonigu, Jesús tule-walbogidzhe ekichial: —¿Igi pe peimal an pe-penta? ");
INSERT INTO kvnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tegin tule-walbogid Jesúsga chogalzhun: —Tummadye, anmal mag atabimalye. ");
INSERT INTO kvnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tegin Jesús wilejakwa tule-walbogid-taknonigu, chunkalgin imia ebus. Tegidgin tule-walbogidga ilgwen imia mag atanonimalzhun. Tegin tule-walbogid Jesúsbak nadmalmojun. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tegin Jesús aga e-chapinganbak Jerusalén-neg-kwebur omodanigu, Olivo-yal-naje nonimal, Betfagé-neg-kwebur-omopen. Tegin Jesús aga e-chapingan-walbogwadga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Imi pemal we neg-kwebur-toto-pe-takchiidzhe pe nemalo. Imi pemal we neg-kweburzhe omojal, pedin, pe taknatapo, burro-nan etinal-un aga e-mimmibak. Tegin pe moli-burromal-echikchal, pe anka chedamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tenal tule peje ekichialil: ‘¿Ibiga pe moli-burromal-echiknai-wede?’ Pe we tulemalga chogo: ‘Tummaddin chog ede we molimal-pei.’ Tegin pe chogbalo: ‘Tummadde chog ede kujal pega kannan molimal-cheinonibalo.’ Tegin tule pemalga chogdamalbalo: ‘Tegil akalzhul pe moli-burromal-chedodo.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Imi we immalmal-kujad akpene-Pab-kaka-palchoged chogzhad-yopí kus. Tenal Pab-kaka-palchoged chogzhado: ");
INSERT INTO kvnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Imi Pab Tummad chog: Pe punamal-Sióngin-pukmaladga chogo: “Pe tak, pe-errey peje moli-burro-chapini-askin-chii-tani, tenal lologwadgin tani, urwedgin chul.” ");
INSERT INTO kvnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tegin Jesús-e-chapingan-walbogid Jesús-chogzhad-yopí imasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tegin Jesús-e-chapingan-walbogid Jesúsga moli-burro-nan tegin moli-chapini-cheinonimal. Tegin Jesús-e-chapingan moli-burro-chapini-yankalgin aga e-molmal okismal. Tegin Jesús kep moli-chapinigin nakwiszhun. Tegin Jesús aga e-chapinganbak ukin nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tenal tulemal-íchejul errey-tummadyob Jesús-takedbal Jesús-iktual igalgin okin-okin aga e-molmal imasmal. Tegin tule-kwénna-kwénna uga-ka kwachamalgu, igalgin uga-ka okismalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tegin tulemal-Jesús-iktual-irmamamimalad tegin tulemal-Jesús-cholbal-tanimalad sapejul kolmanatapmal chogalmal: —¡Imi we David-wagwa otummoledi-kuelen, nabirinye! ¡Tenal we tule-Pab-nuggin-tanikidga ib-nued kuelen, nabirbalinye! ¡Tenal we tule nikpa-neggin nug okannoledi-kuelen, nabirbalinye! ");
INSERT INTO kvnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tenal Jesús Jerusalénzhe tognonigu, Jerusaléngin-pukmalad-pel-kwapa chogalmal: —¿Ibi chogle-wede weob tanikidde? ¿E-iktueddé, toa-tule-ade? ");
INSERT INTO kvnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tenal tulemal-irmadanimalad tule-Jerusaléngin-pukmaladga chogalmal: —Imi we tule, Jesúsde. Tenal we tule Pab-kaka-palchoged-Nazaret-Galileagined. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tegin Jesús Pabzhe-koled-neg-impabal togzhagu, pel-kwapa tule-immalmal-ukpukmalad tegin tule-immalmal-pakpukmalad-onis. Tegin Jesús tule-mani-ogwabukmalad-e-mesamal okpis, tegin tule-nu-ukpukmalad-e-kanmal okpisbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tegin Jesús tule-immal-ukpukmaladga chogal: —Imi Pab Tummad e-kartagin chogdo: An-negdin unnila anche-kolgalbi. Tenal pemaldin immalmal-aturzheed-negga anche-koled-neg imananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tegin tule-aku-atamalad tegin tule-mego-mego-nanemalad Pabzhe-koled-negzhe Jesús-chiidzhe nonimal. Tenal Jesús pel-kwapa we tulemal-nudasmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad Jesús-immal-taktijulmalad takchamal. Tegin Judio-tummagan itosmalbal purwigana Pabzhe-koled-neg-impabal Jesúsga kolmakalmal chogalmal: “Imi pedin-David-e-wagwa otummoledi-kuelen, nabirinye.” Tenal Judio-tummagandin purwigana-chogzhad istar itononimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tegin Judio-tummagan Jesúsga chogalmal: —¿Imi pe-itos purwigana pegin igi chog? Tegin Jesús tummaganga chogal: —An itosdo, purwigana igi chogmal. Tenal anka wedin iwen-akalzhul. ¿Imi pe Pab-kartagin apchodijulzhí we immal kunaid? Tenal Pab kartagin chogdo: Imi pedin pato kuakwa purwigana-tegin-mimmigan-nu-nunanimalad-urpis pe-nug otummogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tegidgin Jesús aka-pukwa Judio-tummagan-ebes. Tenal Jesús kannan Betania-neg-kweburzhe nadbal, Betaniagin kabgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tegin te pangin wakur, Jesús kannan Jerusalénzhe albalgu, igalbal ukulzhaal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tegin Jesús takal, igal-pial wag-islub-chapi kwichi. Tegin Jesús we chapi-chalzhe nad e-chan kwangal. Tenal Jesús wag-islub-chalzhe nonigu, takal chan kwen nikchul, e-kabi unnila nika. Tegin Jesús we chapiga choktejun: —Imi pedin wegii pe pesgu-peine, keg pal chanma. Tenal wag-islub-chapidin ilgwen tinkuszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tenal Jesús-e-chapingan takchamalgu wag-islub-chapi tinkus, weob pakal pesmal. Tegin e-chapingan Jesúszhe ekichialmal: —¿Wag-islub pulejul tinkujaddé, igi kus-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tegin Jesús aga e-chapinganga chogal: —Imi an chunchunnad pemalga chogdo: imi pe immal imanail, pe aga ulubgin pela-pela penzhulil, pe we chapigabi pe chogojul: ‘Pedin tinkuo.’ Tenal pe nabir ampa we yal-kwichidga pe chogmogo: ‘Pe we-akar akniro, termalzhe arkwano.’ Tegin pe yalga kaka-kochadbal, pega kunonikodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Imi pe Pabgin penzhulil, meke-ibi pe Pab Tummadzhe ekichial, Pab Tummad pega imanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tegin Jesús Pabzhe-koled-neg-impabal togzhagu, Pab-igalgin tulemal-oturdakalzhun. Tenal Jesús tulemal-oturdanaidgin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin tule-chelegan-tummagan Jesúszhe ekisnonimal: —¿Imi pe toa-nuggin pe weob immal ima-wede? ¿Tegin toa pega igal-ukchabal-wede, weob immal imagal? Imi an peido, pe anka chog. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tegin Jesús Judio-tummaganga chogal: —Tegil an pemalzhe inzhel immal ekisnegwel. Imi pe anka chogzhal, kep an pemalga chogmogo toa anka igal-ukcha weob immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Imi Juan-Bautista-tigin-tulemal-ogdi-kujad pia-akar tani-jogna? ¿Pab-akar o tule-akar? Anka chogdo. Tegin Judio-tummagan aga emal-emal chunmakalmal: —Imi anmal chogzhal: ‘Juan-Bautista-tigin-tulemal-oged Pab-akar tani,’ we Jesús anmalga chogdago: ‘¿Tede ibiga pemalde Juangin keg ibzhemalzhun?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tenal anmal chogzhabalil: ‘Juan-Bautista-tigin-tulemal-oged tule-akar tani,’ tulemal-anmalzhe-uludagoedbal anmal kwakidamalo. Imi tulemal-pel-kwapa chogmal: ‘Juan-Bautistadega Pab-kaka-palchoged.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Al Judio-tummagan Jesúsga chogalmalzhun: —Anmal kwen wichulmal Juan-Bautista-tigin-tule-oged, pia-tani. Tegin Jesús Judio-tummaganga chogal: —Tegil an pemalga kwen chogojulmodo, toa anka igal-ukcha weob immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tegin Jesús Judio-tummaganga chogalbal: “¿Imi an-chogoed, igi pe itomalmogo-dewa? Imi tule-walgwen machi-walbo nika. Tegin e-pab machi-walgwenga chogal: ‘Machi, imis pe nagnuje uva eminao.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tenal we machi e-pabga chogal: ‘An kwen nejul.’ Tenal we machi te-cholbal pinzheal ede pul nao. Tenal machi yabli nadzhun nagnuje uva emigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tegin e-pab machi-pidga chogalmo: ‘Machi, imis pe nagnuje uva eminemogo.’ Tenal we machi e-pabga chogal: ‘Tegil nabirde.’ Tenal we machi yabli kwen nadzhul-kus nagnuje uva emigal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tegin Jesús chogalbal: —¿Imi piti machi-walbogid pul e-pab-chogzhad-pallí immal imas? ¿Kepegined o chol-napi-ka-chogzhad? Tegin Judio-tummagan Jesúsga chogalmal: —Kepegin-e-pab-ka-chogzhad. Tegin Jesús Judio-tummaganga chogalbal: “Teobdo. Imi an chunchunnad pemalga chogdo: imi tule-Romano-tummadga-mani-egwanmalad tegin ome-macherganbi-wismalad pemalga pul-pulejul Pab-neg-takmaidgin togmamimal. Imi we tule-iskana akpene-Pab-itojulidgin aga ulubgin pukib itononimal, we machi-kepeginedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","¿Ibiga an teob chog? Imi Juan Bautista pemalzhe noni pemalga igal-napírragwad oyogal. Tenal pemal Juan-chogzhadgin kwen ibzhaszhulmal. Tenal tule-Romano-tummadga-mani-egwanmalad tegin ome-macherganbi-wismalad Juan-chognonikidgin ibzhenonimal. “Tenal pemal takchamal tule-Romano-tummadga-mani-egwanmalad tegin ome-macherganbi-wismalad Juan-ega-chogzhad abingasmal. Tenal pemal aga ulubgin iskuedbal kwen pukib-itononijulmal. Tegin pemal Juangin ampa kwen ibzhaszhulmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tegin Jesús Judio-tummaganga chogalbal: “Imi antin pemalga purpal immal chognebal: imi tule-nagnu-ibed-walgwen nagnugin uva tigzha. Tegin tule-nagnu-ibed pel-kwapa ebiris aga nagnu chaktis. Tegin tule-nagnu-ibed kuakwa uva-nis-abingeed chobzhabal. Tegin tule-nagnu-ibed nikpa kalu chobzhabal pel-kwapa nagnu algegal. Tegin tule-nagnu-ibed nejogalgu tulemalga uva-naid ololchas kujal uva-weied-omojal aga abal kamalgal. Tegin tule-nagnu-ibed napa-pidzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Tenal uva-nabgued-ibe omosgu, tule-nagnu-ibed tule-nagnu-takchimaladzhe aga e-mosmal-palmis uva-chan-abal-ega-uklegoed amigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Tenal mosmal tule-nagnu-takchimaladzhe nonimalgu, tule-nagnu-takchimalad we mosmal-kasmal. Tegin tule-nagnu-takchimalad mos-ebiosmal, kwen mos-mechamal, kwen akwagin sagyeal mos-mechamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tegin tule-nagnu-ibed pul-melu e-mosmal-pimalad-palmialbal. Tenal mosmal nonimalgu, tule-nagnu-takchimalad ampa akpenegwadyob mosmal-pimalad-imasmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tegin tule-nagnu-ibed napigin aga e-machi-chunnad-palmialzhun. Tenal tule-nagnu-ibed pinzhasdo: ‘We tulemal an-machi-ulgin, an-machigin atagenabmal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tenal tule-nagnu-takchimalad takchamalgu nagnu-ibed-e-machi tani, aga emal-emal chunmakalmal chogalmal: ‘We machi-tanikid, e-pab purkwijal, we nagnu e-machigadga kunoniko. Al anmal we machi-mejenabmal, nagnu pél anmalgadga kunonigal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tegin tulemal-nagnu-takchimalad machi-kasmalgu, nagnu-tikalzhe machi-chesmal. Tegin tule-nagnu-takchimalad nagnu-tikalbal kep machi-mechamalzhun.” ");
INSERT INTO kvnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tegin Jesús Judio-tummaganga chogalbal: —Imi tule-nagnu-ibed nagnuje nonikil, tule-ebi-machi-mechadbal ¿igi tule-nagnu-takchimalad-imako pe ebinzhe? ");
INSERT INTO kvnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tegin Judio-tummagan Jesúsga chogalmal: —Imi tule-nagnu-ibed ilgwen we tule-iskana-opelononiko. Tegin tule-nagnu-ibed tule-pimaladga nagnu uko ega takegal. Tenal tule-pimalad uva-nabgued-ibegin keg-chulgu nagnu-ibedga uva-chan-ega-uklegoed ukmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tegin Jesús Judio-tummaganga chogalzhun: —Teobdo. ¿Tenal pemal Pab-kartagin apchodimalzhulzhí, Pabdin igi chog? Tenal Pab-kartagin chogdo: Imi tule-neg-chobmalad akwa-mete, Tenal akwa-meted akwa-pul-chunchogedga kunoni. Imi Pab Tummad weob akwa-imas, al Pab-weob-immal-imajadbal anmal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tegin Jesús Judio-tummaganga chogalbal: —Al an pemalga chogdo: imi Pab-neg-takmaid pemalgin idirilenoniko, tegin tule-pimaladga uklenoniko. Tenal we tulemal Pab-neg-takmaid-igalgin kep nuekwa nanedamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Imi antin we akwa-metedyob. (Tenal meke-ibi-tule we akwa-askin arkwajal, ilgwen e-kalmal pisli-pisli peio. Tenal we akwa tule-askin arkwannonikil, we tule ilgwen akpudo.) ");
INSERT INTO kvnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Pariseomal, Jesús-purpal-ega-chogzhad itosmalgu, mag itosmal Jesús emalgin chunmas. ");
INSERT INTO kvnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Al we Judio-tummagan igal-amialmal Jesús-kagal. Tenal tulemal Pab-kaka-palchogedyob Jesús-takedbal, Judio-tummagan tulemalgin kwakialmalbal. Al Judio-tummagan Jesús-kwen-kaszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tegin Jesús kannan purpal tulemalga chogalbal: ");
INSERT INTO kvnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Imi Pab-neg-takmaid tule-erreyyob. Tenal errey e-machi-ome-nikuneedbal ichejul mas-kunned onos tulemal-okunkal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tegin errey kep aga e-mosmal-palmis akpene-tulemalga-chogzhamaladzhe kolnegal. Tenal we tulemal yapa taggusmal, errey-negzhe mas kuntagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Tegin errey kannan e-mosmal-pimalad-palmijogalbal tulemalzhe kolgal. Tegin errey aga e-mosmalga chogal: ‘Imi pe tulemalga chogo: Imi antin pemalga molimal-mecha tegin moli-chapini-kwallu-ibed-mechabal. Tenal moli-mas pato kuakwa tuwal chii. Al pemal keg-chulgu tagmalo an-machi-ome-nikuedgin anpak mes mas-kunkal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Tegin e-mosmal e-tummad-ega-chogzhadyob tulemalga chogzhagu, tulemal yabli kwen ibzhaszhulmal. Tenal kwéntin pul-kigma nagnuje nadmal, tegin kwéntin immalmal uknadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tenal kwéntin errey-mosmal-kasmal, tegin chabzhul we mosmal-imasmal. Tegin we tulemal errey-e-mosmal-mechamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Tenal errey wisgusgu tulemal chabzhul-ebi-mosmal-imasmal, peyedzhe ulual. Tegin errey ichejul aga chulubmal-palmis ebi-e-mos-mechamalad-mesgalmo. Tegin chulubmal tule-errey-mosmal-mechamalad-mechamalmo, tegin tulemalbi-e-neg-kwebur okummasmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tegin errey aga e-mosmalga chogal: ‘Imi an-machi-ome-nikuneedgin-mas-kunnoed pato kuakwa pukwa. Tenal tulemal-an-tarzhe-kochamalad immal-akalojadbal igal-pal-kwen-nikchul we mas kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imisgin pe nemalzhunno tulemal-magadbal-yogasal-irmamamimaladzhe pe kolzhunno anpak mes mas kunkal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tenal errey-mosmal nadmalzhun neg-impabal tulemal-amigal. Tenal we mosmal yogasal tule-amismal, tule-nuegan, tule-iskana, erreybak mes mas kunkal. Tegin tule irmanonimalgu, errey-negdin pel-kwapa engunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tenal errey tognonigu, pel-kwapa tulemal-algas. Tegin errey takal, tule-walgwen yogasaled-mol-yowi chimo, ome-nikuedgin-mol-yowed kwen yowijul. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tegin errey we tulega chogal: ‘An-ai, ¿igi pe togzha-wede, ome-nikuedgin-mol-yowed kwen yowijul?’ Tenal we tule ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Tegin errey aga e-mosmalga chogal: ‘Tenal tule-ome-nikuedgin-mol-yowijulid pe kugmamalo. Tegin pe magadbal neg-chichidgin pe we tule-onogo. Tenal we tule magadbal wilenaidbal, meke okormajio tegin meke nugal kotabalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Imi Pab tulemalzhe ichejul kocha, tenal Pab walpókwajal tulemal-chus, nuekwa ebak naigugal. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tegin Jesús-pél-chunmajad-cholbal, Pariseomal nadmal igal-amigal, Jesús istar chunmakalil, Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tegin Pariseomal tule-Errey-Herodezhikmaladbak, aga e-chapingan-palmialmal Jesúszhe. Tegin Pariseo-e-chapingan Jesúsga chogalmal: —Tule-oturdaked, anmal wismaldo, pedin tule-napírra-chunmaked tegin Pab-igalgin napírra tule-oturdabal. Tenal anmal wismalbaldo tule-tummad o tule-pinchegad pega iwen-akalzhul, pedin ib-chunchunnadgin tobe-tobejul chunma. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Imi pe inniki-immal-choged-tule-choggu, al an peido, pe anka chog. ¿Imi anmal nabir Romano-Tummad-Césarga mani-egwannanikid penuko o chul? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tegin Jesús mag takchagu we tulemal istar egin pinzhebukmal, Pariseomal-e-chapinganga chogal: —Pemal-pinche-askinbi-nued-nanemalad, ¿ibiga pe an-wilub-taknanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Imisgin anka pe mani-kwagwen udado, an takegal ibi-manigin pe Romano-Tummad-Césarga penuknanimal. Tegin tulemal Jesúsga mani-kwagwen ukcha. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tegin Jesús we tulemalga chogalzhun: —¿Imi we manigin, toa-wagal-purpa chii-jogna? ¿Tegin toa-nug nermakal naibal-zhogna? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tegin tulemal Jesúsga chogalmal: —Romano-Tummad-Césargaddé. Tegin Jesús tulemalga chogal: —Nabir. Imi immal Romano-Tummad-Césargadil, Césarga pe ukodo. Tenal immal Pab Tummadgadil, Pabga pe ukodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tegin Pariseo-e-chapingan Jesús-chogzhad itosmalgu, weob pakal pesmal. Tegin we tulemal aka-chii Jesús-ebesmal, ilgwen Pariseomalzhe nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Imi teun ampa te ibegin Saduceomal Jesúszhe nonimalmo. Tenal Saduceomal chogmaldo: “Tule purkwijal, Pab-neggin pal kwen tullegojul.” Tegin Saduceomal Jesúszhe ekichialmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tule-oturdaked, imi Moisés anmalga igal-mezhisdo, tule-ome-nikad nuchu-nikchul purkwijal, e-urpadin keg-chulgu e-ia-omega-kujad-nikuenabmo we omebak aga e-ia-purkwijadga nuchu-nikunonigal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nabir. Imi anmal-abalgin tule-walgwen machimal-walakugle-nikus. Tegin machi-tummad ome-nikunoni. Tenal we machi nuchu-kwen-nikchul purkwenoni. Tegin e-urpa-e-palid e-ia-omega-kujad-nikunonimo. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tegin we machi, ampa nuchu-kwen-nikchul purkwenonimo. Tenal we machimal-walakugled ukin-ukin pél we ome-walkwénnagwad-nikusmal. Tenal we machimal yabli nuchu-kwen-nikuszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tegin we ome kep napigin purkwenonimojun. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Imi we ome machimal-walakugled-pél-nikujadbal, ome Pab-neggin kannan tullejal, ¿piti-machi-walakugled e-machered-chunchunnadga kunoniko?” ");
INSERT INTO kvnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tegin Jesús Saduceomalga chogal: —Pemal noal anka chunmananimalma. Imi pemal Pab-kartagin-nermakal-maid pe kwen wichulmal, tegin pe Pab-kannaleged kwen wichulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tenal tule purkwijad-akar Pab-neggin kannan tullejal, ome-pal-kwen-nikuojul. Tegin omegandemo machered-pal-kwen-nikuojulmalmo. Tenal machergan tegin omegan pog-pel angelmal-Pab-neggin-pukwadyob kunonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tenal antin tule-purkwaled-akar-kannan-tullegoedgin pemalga chunmanejun. ¿Imi pe apchodimalzhulzhí Pab Tummad igi pemalga chogzhagus? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tenal Pab Tummad chogzhado: Imi antin Abraham-e-Pab-Tummadga mai. Tegin an Isaac-e-Pab-Tummadga mai. Tegin an Jacob-e-Pab-Tummadga maibal. Ex. 3:6 Imi Pab Tummad tule-purkwismalad-e-Pab-Tummadga maichul, tenal tule-tulamalad-e-Pab-Tummadga mai. Al Abraham, Isaac tegin Jacob ampa Pab-neggin tula-pukwamalmo. Al tule-purkwismalad kannan tullenonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tegin tulemal Jesús-chogzhad itosmalgu, Jesús-e-oturdajadgin weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tegin Pariseomal wisgusmalgu Jesús Saduceomalgin nakwis, pulal Jesúszhe nonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tegin Pariseo-walgwen-Pab-karta-nued-wijiid Jesús-wilub-takchogal. Tegin Pariseo Jesúszhe ekichial: ");
INSERT INTO kvnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tule-oturdaked, ¿imi Moisés-igal-mamikid, piti pul-chunchoged? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tegin Jesús tule-Pab-karta-nued-wijiidga chogal: “Imi pemal pela-pela Pab-Tummad-pilalguenabmal, pél aga pe-ulubgin-itogedzhe, pél pe-purpaje tegin pél pe-pinzheedzhe, pel-kwapa. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Imi tule-Pab-pilalgued-igal egmalga pul-chunchoged. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tenal igal-chogbogwad ampa yopíjalmo. We igal chogdo: Imi aga pe-chan pilaledyob, pe tule-pid-pilalguenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tenal Moisés-igal-pel-kwapa-mamikid tegin Pab-kaka-palchogmalad-pel-kwapa-chogzhad, we igal-chogbogwad-akar tanimal. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tegin Pariseomal ampa pulakwa pukwadgin, Jesús Pariseomalzhe immal ekichial chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Igi pe chogmalmo, Pab-akpene-chogzhad-palmidagoed-tulegin? ¿We Cristode, toa-wagwa-wede? Tegin Pariseomal Jesúsga chogalmal: —Errey-David-e-wagwade. ");
INSERT INTO kvnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tegin Jesús Pariseomalga chogalbal: —¿Tede ibiga David Pab-Purpa-Nuedbal-chunmakedgin, Cristogin chogzhajun: ‘Pedin an-Tummad?’ Tenal akpene David chogzhado: ");
INSERT INTO kvnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Imi Pab Tummad an-Tummadga chogzhado: ‘Pedin an-nuedzhik tule-tummadga chigwitapo, tule-pebak-aichulmaladgin nakwegal an pe-imakedzhe, pe kangin nag-onakwedyob.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Imi Errey-David Cristoje kocha ‘Tummad’, ¿tede Cristode igi David-e-wagwaga kuo? ");
INSERT INTO kvnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tenal tulemal Jesús-kwen-abin-imaszhulmal, ilgwen yakir pesmal. Tenal teun-akar tulemal Jesús-tobedbal Jesúszhe immal pal kwen ekichiszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tegin Jesús aga e-chapinganga tegin tule-pukmaladga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Imi Moisés-igalgin-tulemal-oturdamalad tegin Pariseomal immal-wijiidbal, igal-nikmal Moisés-igalgin tulemal-oturdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Al tule-tummagan-Moisés-igalgin-chogzhad-pallí pél pe immal imakenabmal. Tenal tule-tummagan Moisés-igalgin aga tukin kwen nanejulmal-choggu, al pe melle we tule-tummagan-tamaladyob pe tamalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Imi we tule-tummagan peyedzhe-tutujul tulemalga igal-mesmal, tenal Judio-tummagan pel-iche tulemal-kwen-pentajulmal igal-mezhijadgin nanegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Imi tule-tummagan tulemal-wagin pel-kwapa immal imananimal, tulemal yer e-takegal. Tenal Judio-tummagan pebegin tegin chakwagin totojul Pab-karta-chaboed-chagu nazhimalbal. Tegin Judio-tummagan mol-tukugin orojul turpa-turpa mol-nazhimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Tenal Judio-tummagan pulal mas kunnalmalal, yer itomal tule-tummagan-ampagumalad-kangin ampagugal. Tegin Judio-tummagan yer itomalbal Judio-ormaked-negmalgin tule-tummagan-ampaguedgin ampagugalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tenal Judio-tummagan peimalbal, tulemal immalmal-ukmaladgin tule-tummadyob eje kolmal. Tegin Judio-tummagan yer itomalbal tulemal eje kolmal: ‘Pe Pab-igalgin-tulemal-oturdaked-tule.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tenal pemaldin melle pinzhedamalmogo tulemal peje kolo: ‘Pab-igalgin-tulemal-oturdaked-tule.’ Tenal pemal tule-oturdaked-walkwénna-nika, wedin Cristo. Tenal egmaldin pel-kwapa kwenamaladbi. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tenal pemal melle iti-napkin pe-pabyob tule-tako; tenal pemal pab-walkwénna-nika, tenal pe-Pab nikpa mai. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tenal pe melle igal-uko tulemal peje kolgal: ‘Tule-oturdaked.’ Imi tule-walkwénna pemalga Tule-oturdakedga mai. Wedin, Cristo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Imi pemal-abalgin tule-pul-tummadga kudiil, we tule pemal-mosyob naneenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tenal meke-ibi-tule aga tukin otummoel, we tule, tule-pinchegadga kunoniko. Tenal meke-ibi-tule aga tukin tule-pinchegadga imakel, we tule, tule-tummadga kunoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tegin Jesús Judio-tummaganga chogalbal: “¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal, anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal tulemalgin Pab-neg-takmaid-otuknanimal. Tenal pemal aga tukin Pab-neg-takmaidgin kwen togzhulmal. Tenal pemal tule-Pab-neg-takmaidgin-togbi-kunanimaladgin igal-kananimal melle Pab-neg-takmaidgin toggal. ( ");
INSERT INTO kvnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal yardagedgin ome-tarbi-machered-purkwismaladgin immalmal egwannanimal. Tenal tulemal yer pe-takegal, pemal ib-chunchunnadyob orojul Pabzhe kolmal. Al pemal pul-pule peyedzhe oturdalenoniko.) ");
INSERT INTO kvnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal termalbal tegin igalbal tikajul naddamal, walkwénna tule-amigal pebal naigugal. Tenal pe walkwénna yabli tule-amijal, we tule pul-pule istar nanenoniko. Tenal we tule pemalga pul ilabo cho-chaglagin kummaked-wilubbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Tenal anpi pe wilesmalma! Imi pemal immal-kwen-wichulidgin tulemal-oturdananimal, tule-aku-ataged tulemal-iktu-natapidyob. Imi pemal chogmaldo: ‘Tule Pabzhe-koled-neg-nuggin kaka-ukchal, tenal we tule kaka-ukchadyob immal kwen imaszhulil, wedin iwen-akalzhul. Tenal tule Pabzhe-koled-neg-olginbi kaka-ukchal, we tule keg-chulgu e-kaka-ukchadbal immal imakenab.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“¡Pemal immal-kwen-wichulmalad! ¿Ibi pul-chunchoged, Pabzhe-koled-neggin-ol-naid o Pabzhe-koled-neg-chunchunnad? Imi Pabzhe-koled-neg-yabal ol naichulilen, oldin ib-chunchogedzhulin. Al Pabzhe-koled-negdin, olga pul ib-chunchoged. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Tenal pe chogmalbal: ‘Imi tule kugedgin-Pabga-immal-ukedga-kwichid-nuggin kaka-ukchal, tenal tule kaka-ukchadyob immal kwen imaszhulil, wedin iwen-akalzhul. Tenal tule Pabga-immal-ukchad-nuggin kaka-ukchal, we tule keg-chulgu e-kaka-ukchadbal immal imakenab.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“¡Pemal immal-kwen-wichulmalad! ¿Ibi pul-chunchoged? ¿Pabga-immal-ukchad o Pabga-immal-kuged-kwichid? Imi Pabga-immal-kuged-kwichidgin we immal-tul-Pabga-ukchad maichulilen, wedin ib-chunchogedzhulin. Al Pabga-immal-kuged-kwichid Pabga-immal-ukchadga pul ib-chunchoged. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Al tule Pabga-immal-kuged-kwichid-nuggin kaka-ukchal, we tule pato immal-kwichid-nuggin tegin meke-ibi-immala-askin-maid-nuggin kaka-ukchabal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Teginbal, tule Pabzhe-koled-neg-nuggin kaka-ukchal, we tule pato Pabzhe-koled-neg-nuggin tegin Pab-Tummad-wegin-maid-nuggin kaka-ukchabal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Teginbal, tule nikpa-neg-nuggin kaka-ukchal, we tule pato Pab-kan-nuggin kaka-ukcha, tegin Pab-Tummad-we-kangin-chiid-nuggin kaka-ukchabal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal immal-polléje-pakal, menta, anis, tegin comino, kwaambegin-kwagwen Pabga ukmal. Tenal pemal Moisés-igalbal igal-pul-chunchoged takchulmal, tulega-igal-nudaked, wilejakwa-tule-taked, tegin keg-chulgu-inniki-naneed. Tenal pemal we igal-chogpágwad pe imajad-wilubmal, tenal pemal kwaambegwad-kwagwen-Pabga-immal-uked pe imajad-wilubmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“¡Imi pemal immal-kwen-wichulidgin Moisés-igalbal tulemal-oturdananimal, tule-aku-atamalad tulemal-iktu-natapidyob! Imi pemal Moisés-igalbal immal-totogin alamananimal, tule kobedgin-nai-kwi-chumaladyob melle kobgal. Tenal pemal Moisés-igalbal immal-pul-chunchoged pe igesmal, moli-camello kobedgin nail, keg-pe-chumaladyob, tenal pemal yabli kobmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal pinche aga askinbi tule-nued-imamal, tenal pemal aga ulubgin pinzhedimal yardagedgin immal aturzhegal, tule pinche-askinbi muruk tegin pate enukedyob, tenal muruk-yagindin ampa kachamajii. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Pariseomal, pemal-immal-kwen-wichulmalad! Imi pemal aga ulubgin nudakenabmal, kep pe askin nued nanenonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal uan-yayob. Imi tule uangin akwa-yabal tule-purkwaled-tigzhal, tegin akwa magzhal, magadbal yer takle-peio. Tenal uan-ulaktin kalmal omurmajii, tegin tule-purkwismalad nungumamimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Imi pemal ampa teopí kudimalmo. Imi tulemal askinbi tule-nuedyob pe-takmal, tenal pemal-ulubgindin pe-askin-nued-nanediidyob kwen nanejulmal. Tenal pemal pela-pela istar pinzhemalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Imi pemal-Moisés-igalgin-tulemal-oturdamalad tegin pemal-Pariseomal anpi pe wilesmalma! ¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal uangin Pab-kaka-palchogmalad-akpene-purkwismaladga neg-nued chobmal, tegin tule-nuegan-akpene-purkwismalad-tiglejadgin neg-nudamal yer taklegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tenal pemal chogmalbal: ‘Imi anmal-tadgan-pukwaun, anmal kudimalalen, anmal tadganbak we Pab-kaka-palchogmalad-kwen-mechajulmalan.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tenal pemal aga tukin chogmaldo: ‘Anmal we tule-Pab-kaka-palchogmalad-mechamalad-e-wagwagan.’ Wedin chogledo, pemal pe-tadganyobmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tegil pe-tadgan immal-akalosmalad, pe napi pelogenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Pemaldin, tule-iskana nakpeyob! ¿Igi pe wakinmalo, pe melle cho-chaglagin pe peyedzhe oturdalegal? Keg-kue. Tenal pemal keg-chulgu sapejul oturdalegenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Al an pemalga Pab-kaka-palchogmalad, tegin tule-Pab-igal-wismalad, tegin tulemal-oturdamalad an pemalga palminoniko. Tenal pemal we tulemal-palmilegalmalad-wal-walgwen-mesmalo, kwéntin pe nakrusgin piokmalo, kwéntin pe ormaked-negmalgin peyedzhe sagyemalo. Tegin pe neg-kwebur-neg-kweburzhe we tule-palmilegalmalad-ekindimalo sapejul we tulemal-oturdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Tenal pe istar tule-palmilegalmalad-imakoedbal, tulemal iti-napkin pel-kwapa tule-nuegan-mechamalad, tule-nued-Abel-akar Berequías-machi-Zacaríaszhe-pakal pemalgin kunoniko, pemal sapejul oturdalemalgal. (Imi pe-tadgan Pabzhe-koled-neg-akar Pabga-immal-uked-kwichid-abalgin Zacarías-mechamal.) ");
INSERT INTO kvnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tenal an chunchunnad pemalga chogdo: imi tule-akpene-tule-nuegan-mechamalad-pel-kwapa, tulemal-imis-pukmaladgin kunoniko, sapejul oturdalegal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tegin Jesús chogalbal: “Jerusalén-tolgan, pemal Pab-kaka-palchogmalad-mechamal tegin pe akwagin tule-peje-palmilegalmalad-mechamalbal. Tenal antin melugus peigujiin pemal-pel-kwapa anche taggal nuekwa pe-akwegal, kallin-nan aga chakan-tarbal mimmigan-chabojiidyob. Tenal pemal yabli yapa taggusmal. Al an peyedzhe pukib-itoye. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Imi pe-negdin mellegal-peio. ");
INSERT INTO kvnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tenal an pemalga chogdo: imi pemal meke-igi an-pal-kwen-takojulmal, pemal chognonimaloedzhe: Imi pe-Pab-nuggin-tanikid-tule otummoledi-kuelen, nabirinye. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tegin Jesús Pabzhe-koled-neg-akar nodgu, pato nadedgin e-chapingan Jesúsga chogalmal: —Tummad, pe tak, Pabzhe-koled-neg yer-takle-á. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tenal Jesús aga e-chapinganga chogal: —We neg pinche pe tak yer-takle. Tenal an chunchunnad pemalga chogdo: imi Pabzhe-koled-neg-chiid kujal pel-kwapa eyarilego, akwa-askin-chii pel peiojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tegin Jesús kep nadzhun Olivo-yalzhe. Tegin Jesús Olivo-yalgin ampagutapmalzhun. Tegin e-chapingan Jesúszhe nonimalgu, pidzhi Jesúszhe immal ekichialmal: —Imi an pei pe anmalga chog, imis pe-Pabzhe-koled-neggin-chunmajad, inkwa kunoniko. ¿Tenal anmalga igi wilub-oyolenoniko pe-kannan-tanikoed pato omodani? ¿Tegin anmal igi wisgumalbalo neg-tuku pato omodanibal? ");
INSERT INTO kvnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tegin Jesús aga e-chapinganga chogal: “Nabir. Tenal pe nue aga takermal tule pe-yardadamal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Imi tulemal-ichejul an-nuggin yami chunmanonimalo. Tenal we tulemal chognonimalodo: ‘Antin Cristo.’ Tenal we tule-kakanzhenonimalad íchejul tulemal-yardanonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Tegin pe itodamalbalo pila-nonai. Tegin pe iche-iche itodamalbalo choglenai pila-nobi-kunai. Tenal pe melle tobgudamalo. Imi an-pemalga-chogzhiidyob kued-wilub, tenal neg-pelgued ampa omojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tegin pe itodabalo tulemal, kaka-akal-akal-chunmamaladbak pila-ononanimal, tegin napa, napa-pidbak pila-ononanimalbal. Tegin napa-pid-pidgin mas-kunned nikchul-kunoniko, tegin neg-tutumaked akne-akne nonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tenal we ponimal kep pinche iche-iche kudanimal. Tenal ponimal kujal pul-pule kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Imi neg weob kunonikil, tulemal kep pe-kanonimalo tule-tummaganga pe-ukegal sapejul pe-oturdagal. Tenal tule-tummagan sapejul pe-imamalo tegin pe-mesmalbalo. Tenal pe-anpal-naigujadbal, tulemal-pel-kwapa istar pe-taknonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tegin te ibegin tule-anpal-naigusmalad-íchejul an-akar nomalo. Tegin tulemal-an-akar-nosmalad tule-tummaganga aga emal-emal tuktinonimalo. Tegin we tulemal aga emal-emal istar taknonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Tenal Pab-kaka-palchogmalad-chunchunnadzhulmalad-ichejul nonimalo. Tegin Pab-kaka-palchogmalad-chunchunnadzhulmalad íchejul tulemal-yardanonimalo ebak naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tenal iskued pul-íchejul naigunonikidbal, tulemal-akpene-Pab-pilalgusmalad-ichejul Pab-igenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tenal pemal neg-puled-naid-pelguedzhe abin-purtismalal, pemal abonolego Pabbak meggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Tenal Pab-neg-takmaid-kaka-nuegan pel-kwapa-nap-naid-ugakche choglego, tule-kaka-akal-akal-chunmamalad wisgunonimalgal Jesús tule-abono. Tenal Pab-kaka-nuegan-pel-kwapa-choglejadgin kep neg-pelgunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tenal pe takalil, Pabzhe-koled-neg-impabal Pab-kaka-palchoged-Daniel chogzhadyob, immal-iskan-kwichi, ");
INSERT INTO kvnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tulemal-Provincia-Judeagin-pukmalad ilgwen wakinenabmal yal-tummaganzhe. (Imi tule we kaka apchogalil, mag itogelen, nabirin.) ");
INSERT INTO kvnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Tenal tule-neg-uwas-askin pukmalal, melle neg-yabal pal togo immalmal weigal, ilgwen neenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tenal tule nagnugangin kudimalal, melle negzhe pal togmalo molmal amigal, ilgwen aka neenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Tenal te ibegin omegan-ponigwal-kwichimalad tegin omegan-kin-nuskan-nunanimalad ib-kuoedbal peyedzhe wilemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tenal pemal peyedzhe Pabzhe kolenabmal we immal melle peyedzhe neg-tampedgin, o chulil, ulukued-ibegin kugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Imi te ibegin kepe-nap-naigujad-akar imisgwadzhe teob peyedzhe tule-wileged kwen kudijul. Tenal te-cholbal neg-peyedzhe-wileged weob pal kwen nonikojulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Imi Pab Tummad we ibe-puled chikojulilen, tulemal kwen unniguojulmaloen, pél purkwemaloen. Tenal Pabdin tule-chulesmalad-pilaledbal ibe-puled chiko tule-Pabbal-chulesmalad melle twagdar peyedzhe wilegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tenal te ibegin tule pega chogalil: ‘Pe tak, wegin Cristo-Pab-akpene-chogzhad-palmidagoed,’ o chulil, pega chogdabalo: ‘Wépal Cristo kudii,’ melle pe we tulebal ibzhao. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tenal Cristo-chunchunnadzhulmalad tegin Pab-kaka-palchogmalad-chunchunnadzhulmalad akninonimalo. Tenal we tulemal peyedzhe immal-taktijulmalad imanonimalo, yami oyogal e-chunmakeddin ib-chunchunnad. Tenal we tulemal tule-Pab-itolegedbal-chulesmalad yardabi-kunonimogoen, tenal tule-Pabbal-chulesmalad yardalegojul-kuo, tenal pinche tulemal-yogasalmalad yardalenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tenal pe nuekwa an-chunmajad itomalo, antin pemalga pato iktualeba pel-kwapa chogzhado, neg igi kuoed. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Al tule pega chogalil: ‘Wépal neg-nikchulidbal, Cristo kudii,’ tenal pe melle webal pe nao. Tegin tule pega chogdamalbalo: ‘Wegin Cristo neg-yabal otukal chii,’ tenal pe melle we tulebal ibzhemalo, wedin pinche kakanzhemal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Tenal an-Te-Tule-Chunna kannan tanikil, mariped tad-nakwedzhik tad-arkwanedzhik ipedyob an mag taklenonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Imi immal-purkwaled pia nungumaídin, tebal mulamal keg-chulgu ampagunonimalo. Tenal an pega chogzhiidyob pe neg takalil, an-kannan-tanikoed pato omodani.” ");
INSERT INTO kvnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tegin Jesús chogalbal: “Imi tule-peyedzhe-wilesmalad-cholbal, ampa te ibegin tadgwadin akinnoniko, tegin nidin neg pal kwen otalogojul, tegin iskwadin nikpa-akar apatnoniko, tegin nikpa-neg-kanalejiid pela-pela tutumanonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Imi te ibegin tulemal nikpa an-Te-Tule-Chunna-e-wilub taknonimalo. Tenal tule-kaka-akal-akal-chunmamalad nap-naid-ugakche pel-kwapa peyedzhe pukib-itononimalbalo. Tenal tulemal-kaka-akal-akal-chunmamalad taknonimalo, an-Te-Tule-Chunna mogil-impabal pela-pela nugu-taklegedgin tegin kannalegedgin noniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tenal Pab-angelmal kal-trompeta okotel, an-Te-Tule-Chunna naga angelmal-palmido pel-kwapa napa-naid-ugakche tule-an-tar-chusmalad-weinegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Imi pemal wag-islub-chapigin pe turdakenabmal. Imi pe wag-islub-chapi takalil, e-aan-purwiganabal mullu-mullu ampagunoni, tegin pe takalbalil, e-kamal aknidanimalbal, wedin chogle, neg pato yol omodani. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tenal pe wag-islubgin turdajad-yopí an-pega-chogzhadyob pe neg takalil, pemal pato wisgunonimalmogo, an-Te-Tule-Chunna-kannan-tanikoed pato iti-pakal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Tenal an chunchunnad pemalga chogdo: imi tule-te-ibegin-pukmalad, yo purkwemaladdu, an-pega-chogzhadyob keg-chulgu kued-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Imi nikpa-neg tegin iti-nap pelgunoniko, tenal an-immal-chogzhad keg-chulgu kued-wilub, an-kakapurwa kwen perienguojul-kuo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tegin Jesús chogalbal: “Imi Pab-Machi-iti-napche-tanikoed tule pel kwen wichulmal, angelmal pel wichul, Pab-Machi aga tukin pel wichulmo ede ibi-ibegin noniko. Tenal Pab Tummadbi wiis ibi-ibegin, ibi-wachigin Pab-Machi iti-napche kannan taniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Imi akpene Noé-maigu igi kúsdin, an-Te-Tule-Chunna iti-napche kannan tanikil, ampa Noégin-kujadyob kunonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tenal Noé-maigu, ampayo mu-tummad tageddu, tulemal mas-kunnedginbi pul pinzhenanimal, kobedgin pul pinzhenanimal, ome-nikuedgin pul pinzhenanimal, tegin pabgan machiga-ome-ukedgin pul pinzhenanimal, tegin pabgan punaga machered-ukedgin pul pinzhenanimal. Tenal Noé ul-tummadzhe-togzhadzhe tulemal ampa kwen ogwaledzhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tenal we tulemal immal-kwen-wichul pukwamal mu-tummad neg-odononikidzhe. Tenal mu-tummad pél tulemal-ocheles. Imi an-Te-Tule-Chunna kannan tanikoedgin, tulemal ampa immalgin-kwen-pinzhejul-pukmaladgin kunonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Tenal an-tanikoedgin machergan-walbo nagnugin arpananikil, walgwen chulenoniko, tegin walgwen peio. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tenal ome-walbo ob nagnanikil, walgwen chulenoniko, tegin walgwen peio. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Al an pemalga chogzhundo: pemal kuakwa kudiguenabmalmo, pe wichul ibi-ibegin pe-Tummad noniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Al an wisgal pega chogdo: imi neg-ibed wisgujalen mutik ibi-wachigin tule-immal-aturzheed noniko, we neg-ibed pali-pali neg algenain melle ebi-immal aturzhalegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tenal pemal-an-abintajulidgin an-Te-Tule-Chunna pemalzhe kannan noniko-choggu, al pemal kuakwa kudiguenabmalmo an-abingegal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tegin Jesús chogalbal: “¿Imi toa-tule-jogna inniki nanemogo mos-immal-wijiidbal e-tummad-chogzhadyob inniki nanajadyob? Nabir. Imi teun takalgu neg-ibed mos-walgwen-ebes ega mos-pimalad-takegal, tegin e-tummad-chogzhadyob masgin mos-pimalad-okunkalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Tenal neg-ibed kannan nonikil we tummad taknoniko we mos e-chogzhad-pallí inniki immal imanai, we mos ib-nued imas, tegin we mosga ib-nuedga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tenal an chunchunnad pemalga chogdo: imi mos-yer-nanajadbal e-tummad pél we mosga e-immalmal ebeo ega takegal. Imi an-Te-Tule-Chunna we tummad-aga-e-mos-imajadyob pemal-imamogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Tenal mos-iskana aga pinzhedago: ‘An-tummad imiszhul noniko.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tegin mos-iskana sapejul mos-pimalad-sakidago. Tegin we mos tule-mumurgumaladbak mes mas-kuntago, tegin inna-kobdabalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tenal mos-iskana-e-tummad ampa abintajulidgin moszhe noniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","“Tenal mos-e-tummad nonikil, koa-koa mos-iskana-imanoniko. Tegin e-tummad igal-uko mos-iskana tule-pinche-askinbi-nued-nanemaladbak mes sapejul oturdalegal. Tenal tule-oturdalegedgin, we tulemal peyedzhe podamalo, tegin peyedzhe wilejiidbal nugal kotamalbalo. Imi an-Te-Tule-Chunna kannan tanikil, tummad e-mos-iskana-imajadyob antin pemal-istar-an-chapingan-imasmalad-imanonimogo. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tegin Jesús purpal chogalbal: “Imi te ibegin Pab-neg-takmaid punamal-yaegana-walambegwadyob kunonimalo. Tenal we punamal aga kallen chesmal machi-ome-nikudanikid-abintagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tenal punamal-walataled pirkin immal wismal, tenal punamal-walataled-piddin immal kwen wichulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Imi we punamal-walatal-immal-kwen-wichulmalad olobi kallen chesmal, tegin chapi-kwallu pel cheszhulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tenal punamal-walataled-immal-wismaladdin kallen chesmal, tegin pudegin pis-palal chapi-kwallu chesmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tenal machi-ome-nikudanikid apka kwen nonijul-choggu, al punamal kabidmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tegin neg-kabgwen punamal itogalmal, tule arpak koral-chogalmal: ‘¡Machi-ome-nikudanikid tani-takkenye! ¡Nue abintamaloye!’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Tegin punamal-yaegana-walambegid kep kwisgualmal, tegin kallengin chapi-kwallu palialmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tenal punamal-immal-wichulmalad punamal-immal-wismaladga chogalmal: ‘¿Anka pe chapi-kwallu wis udamogojí? An-kallendin nis-pelgudanikidbal pato akindani.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Tenal punamal-immal-wismalad puna-immal-kwen-wichulmaladga chogalmal: ‘An pemalga chapi-kwallu kwen uknejul. Imi an pemalga chapi-kwallu ukchal, anmalga tegin pemalga pel kwen unniguojulmal. Al pemal tule-chapi-kwallu-ukmaladzhe pe pakneenabmal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Tegin punamal-walataled-immal-kwen-wichulmalad chapi-kwallu paknaded-cholbal, machi-ome-nikudanikid noni. Tenal punamal-walataled-kuakwa-aga-chapi-kwallu-cheinonimalad machi-ome-nikudanikidbak mes togzhamal mas kunkalmo. Tegin punamal ukposmalgu, wanagak ilgwen chaktilenonijun, tule igal-pal-nikchul pal toggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Tegin wanagak-chaktilejad-cholbal punamal-immal-kwen-wichulmalad abarmanonimalmo toggalmo. Tenal we punamalga igal-kwen-ukleszhul toggal. Tegin punamal-immal-kwen-wichulmalad chogalmal; ‘Tummadye, pe anmalga wanagak wis egaoye, anmal toggalmoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tegin machi-ome-nikunonikid punamal-magadbal-pesmaladga chogal: ‘Antin napírra pemalga chogdo: an pemal-kwen-wichul, pemal toa-tulemal.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tegin Jesús chogalbal: “Imi pemal punamal-immal-wismaladyob pe kuakwa kudimalo. Tenal pemal kwen wichulmal ibi-ibegin, ibi-wachigin an-Te-Tule-Chunna kannan noniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tegin Jesús purpal chogalbal: “Imi Pab-neg-takmaid tule-mani-ibed tikajul akne-nadedyob kunoniko. Tenal tule-mani-ibed nejogalgu, aga e-mosmalzhe kocha. Tegin tule-mani-ibed aga e-mosmalga pél e-immalmal-nikad ebejogal ega takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tegin tule-mani-ibed e-mos-kurkin-nikadbal manigin-arpagal, e-mos-walgwenga miliatal-mani ebes. Tegin tule-mani-ibed mos-pidga milibo-mani ebesbal. Tegin tule-mani-ibed mos-pidga miligwen-mani ebesbal. Tegin tule-mani-ibed mosmalga-mani-ukchad-cholbal tikajul akne-nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Tegin mos-miliatal-mani-abingajad ilgwen nad immal pakegal. Tegin we manigin immal-pakchagu, ukin ukchabal pul melu mani onogal. Tenal we mos pelugles mili-ambe-mani nikunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tenal mos-milibo-mani-abingajad ampa e-pakadyob immalmal pakchamo. Tenal we mos pél immalmal ukchagu, pelugles milibake-mani nikunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tenal mos-miligwen-mani-abingajad nadgu, nap-yabal e-ibedbi-mani chabos, melle tule aturzhemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tegin untar te-cholbalidgin tule-mani-ibed kannan nonibalgu, aga e-mosmalzhe kocha. Tegin tule-mani-ibed e-mosmalzhe ekichial: ‘¿Igi pe an-mani imasmaldé?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tegin mos-miliatal-mani-abingajad-inzhel e-tummadga kannan miliatal-mani-uklejad ukcha. Tegin we mos e-tummad-cholbal-miliatal-mani-kajad e-tummadga ukchamojun. Tegin we mos e-tummadga chogal: ‘Tummad, wegin miliatal pe anka mani ebejad, tegin an pe-cholbal miliatal-mani kajad.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Tegin tule-mani-ibed e-mosga chogal: ‘Pedin nued imas. Pedin tule-nued tegin pe napírra anka immal imas. Imi pe immal-íchegwadgin pe yer immal imas-choggu, al pe anka íchejul-immalmal-takegal an pe-imako. Imisgin nemaldo anpak nued meggal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tenal mos-milibo-mani-abingajad e-tummadzhe nonimo. Tegin we mos e-tummadga chogal: ‘Tummad, wegin milibo pe anka mani ebejad, tegin an pe-cholbal milibo-mani kajad.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Tenal tule-mani-ibed e-mosga chogal: ‘Pedin nued imas. Pedin tule-nued, tegin pe napírra anka immal imas. Imi pe immal-íchegwadgin pe yer immal-imas-choggu, al pe anka ichejul immalmal-takegal an pe-imako. Imisgin nemaldo, anpak nued meggal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tenal mos-miligwen-mani-abingajad e-tummadzhe nonimo. Tegin we mos e-tummadga chogal: ‘Tummad, imi antin wisdo, pedin tule-puled. Pedin immal kwen tigzhul, yabli pe ichejul immal weinai. Tegin pe immal kwen omukchul, yabli pe íchejul immal abingemaibal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imi pe-tule-pulediidbal an kwakial. Al antin nap-yabal pe-mani chabos. Imisgin, wegin pe-mani.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Tenal tule-mani-ibed e-mosga chogal: ‘Imi pedin tule-iskana, tule-wiekala. ¿Imi pe wijiinzhulzhí antin immal kwen tigzhul, tenal an yabli íchejul immal weinai. Tegin an immal kwen omukchul, tenal an yabli íchejul immal abingemaibal? ");
INSERT INTO kvnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tenal pe keg mani-otummo pe itosgu, pedin bancoje an-mani chesgalan, an nonikoedgin, bancogin anka mani chanmajan.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Tenal tule-mani-ibed mos-pimaladga chogal: ‘Imi pe we tulegin mani-miligwenad pe chuo, tegin mos-miliambe-mani-nikadga pe uko. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Imi meke-ibi-tule ichejul immal nikal, pul-melu we tulega immal uklego. Tenal we tule pela-pela immal nikunoniko. Tenal meke-ibi-tule iché immalmal nikal, we tulegin immal egwalenoniko, chunkal-kwabi kwichi-peio.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tegin tule-mani-ibed e-mos-pimaladga chogalbal: ‘Imi we mos-ibga-keg-pel-kued pe magadbal neg-chichidgin onomalo. Meke we tule magadbal peyedzhe podago tegin peyedzhe wilejii-itogedbal nugal kotabalo.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tegin Jesús chogalbal: “Imi an-Te-Tule-Chunna pel-kwapa naga angelmalbak nugu-taklegedgin iti-napche kannan tanikil, an tummad-kan-nugu-taklegedgin chignoniko tulemalga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tenal tulemal-pel-kwapa-kaka-akal-akal-chunmamalad an-kan-chiid-nabal pulakwa ampagunonimalo. Tenal an-Te-Tule-Chunna pis-pis tulemal-urpo, tule-oveja-taked pis-pis ovejamal-tegin-cabramal-urpedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tenal an-Te-Tule-Chunna ovejamalyob an-nuedzhik tule-nuegan-urpo, tenal cabramalyob an-chapilezhik tule-iskana-urpemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Tenal te ibegin an erreyga-maidbal, an tule-an-nuedzhik-pukmaladga an chogdajunno: ‘Imi an-Pab yer pemal-tak-choggu, al pe tagmalzhunno an pemal-odogal neg-takegal. Tenal we neg-takoed iti-nap-kepe-naigujad-akar pemalga pato kuakwa chabolejii. ¿Ibiga pe anpak mes neg-takmalo pe ebinzhe? Nabir. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“‘Imi an ukul nikusgu, pe masgin an-okucha. Tegin an ukul-ukul-itononigu, pe an-okobzhabal. Tenal an tule-kwapidga kudigusgu, pe neggin an-okabis. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tenal an mol-nikchul-kunonigu, pe anka mol ukcha. Tenal an yegusgu, pe an-takap an-pentagal. Tenal an oturdaleged-neggin mellejiidgin pe an-takappal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tegin tule-nuegan an-erreyga-maidgin anka chogdago: ‘Tummad, nabir pe chogendo, tenal anmal pe-kwen-pentaszhul. ¿Tenal an inkwa pe-takcha-adé pe ukul-mad kudii? ¿Tegin an inkwa masgin pe-okuchabaldé? ¿Tegin an inkwa pe-takchadé pe ukul-ukul itodii? ¿Tegin an inkwa pe-okobzhabaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tegin an inkwa pe-takchadé pe tule-kwapidga kudii? ¿Tegin an inkwa neggin pe-okabisbaldé? ¿Tegin an inkwa pe-takchadé pe mol-nikchul-kudii? ¿Tegin an inkwa pega mol ukchabaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tegin an inkwa yee pe-takchadé? ¿Tegin an inkwa pe-takapté pe-pentagal? ¿Tegin an inkwa oturdaleged-neggin mellejii pe-takchabaldé? ¿Tegin an inkwa oturdaleged-negzhe pe-takapté?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Tenal an-erreyga-maidbal an tule-nueganga chogdago: ‘Tenal an chunchunnad pemalga chogdo: imi pe an-kwenadgan-polgana-ugakche pe tar-pentajadbal, pedin pato an-pentasmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tenal an-erreyga-maidbal an tule-iskana-an-chapilezhik-pukmaladga an chogdago: ‘Imi pemal-ukapchalesmalad, pe ilgwen an-akar nemalo, cho-chagla-keg-akinnedzhe. Tenal we cho-chagla pato kuakwa chii, nia-saglaga tegin e-angelmalgamo. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","“‘Imi an ukul-nikusgu, pedin masgin an-kwen-okuchajul. Tegin an ukul-ukul itononigu, pe an-kwen-okobzhajulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tenal an tule-kwapidga kudigusgu, pe neggin an-kwen-okabiszhul. Tenal an mol-nikchul-kunonigu, pe anka mol kwen ukchajul. Tenal an yegusgu, pe an-kwen-takapchul an-pentagal. Tenal an oturdaleged-neggin mellejiidgin pe an-kwen-takapchulbal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tenal tule-iskana an-erreyga-maidgin anka chogdamalo: ‘¿Tummad, tenal an inkwa pe-takchadé, ukul mesdií? ¿Tenal an inkwa pe-takchabaldé pe ukul-ukul itodií? ¿Tenal an inkwa pe-takchabaldé pe tule-kwapidga kudií? ¿Tenal an inkwa pe-takchabaldé pe mol-nikchul kudií? ¿Tenal an inkwa pe-takchabaldé pe yegudií? ¿Tenal an inkwa pe-takchabaldé pe oturdaleged-neggin mellejií? ¿Tenal an inkwa pe-kwen-pentaszhulbaldé?’ ");
INSERT INTO kvnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Tenal an-erreyga-maidbal an tule-iskanaga chogdago: ‘Tenal an chunchunnad pemalga chogdo: imi pe an-kwenadgan-polgana-ugakche pe tar-kwen pentaszhulidbal, pedin ampa an-kwen-pentaszhulmo.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tegin Jesús chogalbal: “Imi an tule-iskanaga pél chunmajal, we tule-iskana nemalzhunno ilagwen-nadgu sapejul oturdalegal. Tenal tule-nuegandin nemalmogo ilagwen-nadgu Pab-neggin meggal. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tegin Jesús tulemalga pél chunmasgu, aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Imi pemal pato wismaldo, Pab-Najad-Itoged ibboje naigunoniko. Tenal te ibegin an-Te-Tule-Chunna uklenoniko nakrusgin pioklegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tenal teun tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-chelegan-tummagan, tule-irwal-Pabzhe-koled-pul-tummad-Caifás-e-neg-tummadgin ormasmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tenal we Judio-tummagan igal-aminanimal otukal Jesús-kagal, tegin Jesús-mesgalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tenal Judio-tummagan chogalmalbal: —Tenal anmal Pab-Najad-Itoged-naidgin melle Jesús-kamalo. Tegil tulemal ulualmalal, neg-impabal aknidmalo anmalbak urwegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Imi Jesús Betania-neg-kweburgin-maidgin, teun Jesús Simón-lepra-poni-nika-nad-neggin mas kuntii. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tegin Jesús ampa mas kunchiidgin, ome-walgwen Jesúszhe noni. Tegin we ome alabastro-pudegin ti-wawad-peyedzhe-karked cheinoni. Tegin ome Jesús-nonogin ti-wawad imas. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tenal Jesús-e-chapingan ome-takchamalgu Jesúsgin-ti-wawad-imas, istar ome-takalmal. Tegin Jesús-e-chapingan chogalmal: —¿Imi we omede, ibiga pinche ti-wawadgin mani owes-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Imi we ti-wawad yer karkegu-choggu, al mani-tummadgin ukchalen, pul nabirin, we manigin tule-wilemalad-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tenal Jesús e-chapingan-chunmajad itosgu, aga e-chapinganga chogal: —¿Ibiga pe we omegin urwenanimal-wede? We ome anka ib-nued imas. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","12","Tenal ome an-purkwed-iktual ankin ti-wawad imas tule-tigzhogalidyob. Imi tule anka immal-ukpiel, imis anka ukenab. Tenal antin pemalbak ilgwen-kwen-nadguojul, tenal tule-wilemalad kwen chulguojul-kuo, pemalbak keg-chulgu kudigumalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Tenal an chunchunnad pemalga chogdo: imi iti-napkin meke-pia an-kaka-nuegan choglegoedgin, we ome imis ankin ti-wawad-imajad ampa choglemogo, tulemal we omegin wis pinzhemalgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tegin Jesús-e-chapingan-walambe-kakabogwad-walgwen Judas-Iscariote-nugad tule-irwal-Pabzhe-kolmalad-e-tummaganzhe nad, manigin Jesús-ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tegin Judas Judio-tummaganga chogal: —¿Igi-mani anka pe uko, an pega Jesús-ukegal? Tegin Judio-tummagan ilgwen Judasga mani-chibu-tulabogiid-kwa-tulagwen-kakaambe ukchamal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Al Judas teun-akar igal-aminaigual Judio-tummaganga Jesús-ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tegin Madu-Ina-Nikchulid-Kunned-Ibe kep-naigudedgin, e-chapingan Jesúszhe nonimal chogalmal: —¿Tummad, pia pe pei, anmal pega neg nudamalgal Pab-Najad-Itogedgin mas kunmalgal? ");
INSERT INTO kvnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tegin Jesús aga e-chapinganga chogal: —Imi pe neg-kweburzhe nemalo, tule-an-pega-chogoedzhe. Tenal pe we tulega chogo: ‘Tule-oturdaked chog, e-wilub pato omodani-choggu, al ede aga e-chapinganbak pe-neggin Pab-Najad-Itoged-mas wis kunpimal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tegin Jesús-e-chapingan Jesús-ega-chogzhadyob pél immal imasmal. Tenal Jesús-e-chapingan Pab-Najad-Itogedgin mas imasmalzhun. Tenal Jesús kep te-cholbal nonimojun aga e-chapinganbak mes mas kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tegin neg-chedosgu, Jesús aga e-chapingan-walambe-kakabogwadbak mes mas kunchimo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tenal Jesús mas-kunpukwadgin aga e-chapinganga chogal: —Imi an chunchunnad pemalga chogdo: pemal-walgwen manibal ankin akpinnoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Al Jesús-e-chapingan peyedzhe pukib-itononimal. Tenal e-chapingan-ilbal Jesúsga chogalmal: —¿Tummad, an pegin akpinnonikodé? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tegin Jesús aga e-chapinganga chogalbal: —Tenal pemal-walgwen anpak mes madu wartichajal, we tule ankin-akpinnonikoed. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tenal Pab-kartagin nermakal-maidyob an-Te-Tule-Chunnagin kunoniko. Tenal tule-ankin-akpinnonikoed sapejul oturdalegoedbal peyedzhe wilesma. Al we tule pul mimmileszhulilen, pul nabirin. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tenal Judas-Jesúsgin-akpinnonikoed Jesúszhe ekichial: —¿Tule-oturdaked, áni? Tegin Jesús Judasga chogal: —Pedo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tegin Jesús aga e-chapinganbak ampa mas-kunpukwadgin Jesús madu chus. Tegin Jesús tog-nuedi Pab Tummadga chogzha. Tegin Jesús purwi-purwi madu pipichisgu, aga e-chapinganga madu ukcha. Tegin Jesús aga e-chapinganga chogalbal: —Chu. Kunmal. Wedin an-chan. Tegin Jesús-e-chapingan we madu kuchamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tegin Jesús kobed chusbalgu, tog-nuedi Pab Tummadga chogzhabal. Tegin Jesús aga e-chapinganga kobed ukchabal. Tegin Jesús aga e-chapinganga chogalbal: —Pemal-pel-kwapa we kobed pe kobmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Imi we kobed an-abe. Tenal an-abedin oyonai, Pab-Tummad-kaka-pin-ukchad ib-chunchunnad. Al an-abe milenoniko, tulemalga-ichejul iskued eligal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tenal an pega chogdo: imi antin imis-akar uva-nis pal kwen kobojul, an-Pab-neg-takmaidgin pemalbak kannan uva-nis kobbaloedzhe. Pitogua. Tegin Jesús-e-chapingan we kobed kobzhamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tegin Jesús aga e-chapinganbak namakedgin Pab-otummosmalgu, ilgwen nadmal, Olivo-yalzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tegin Jesús aga e-chapinganga chogal: —Pemal imis-mutik pel-kwapa an-midmalo, Pab-kartagin chogzhadyob. Tenal Pab Tummad purpal chogzhado: Antin oveja-taked-mejo, tegin ovejamal akne-akne abarmadmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tegin Jesús chogalbal: —Imi an purkwaled-akar an kannan tullejal, an pe-iktual Provincia-Galileaje nao. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tenal Pedro Jesúsga chogal: —Imi tule-pimalad pél pe-midmalal, tenal antin meke-igi pe-kwen-metojul. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tegin Jesús Pedroga chogal: —Imi an chunchunnad pega chogdo: imis-neg-kabgwen ampayo kallin-mastad namakeddu, pedin ilapá ankin chognoniko: ‘Antin Jesús-kwen-wichul.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tegin Pedro Jesúsga chogalbal: —Chulá. Imi an pebak purkwejogel, an akalzhul pebak purkwemogo. Tenal antin pegin kwen chogojul, an pe-kwen-wichul. Tenal Jesús-e-chapingan-pimalad ampa Pedro-chogzhad-yopí chogalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tegin Jesús aga e-chapinganbak nadmalzhun Getsemaní-neg-nugadzhe. Tegin Jesús Getsemaní omosmalgu, aga e-chapinganga chogal: —Imi pemal wegin peimalgwelo. Tenal antin webal Pab Tummadzhe wis kolnegwelo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tegin Jesús walapá aga e-chapingan-ches, Pedro tegin Zebedeo-machimal-walbo. Tenal Jesús ega ib-kuoedgin peyedzhe-pukib-itononikidbal chuli-pinzhe-kual. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tegin Jesús aga e-chapingan-walapágwadga chogal: —Imi an ulubgin peyedzhe-pukib-itogedbal ankin purkwed ode. Imi pemal wegin an-abintagwelo. Tenal pemal anpak mes alamakenabmalmo Pabzhe kolgal, tenal pe melle kabmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tegin Jesús iche-ukin wis nadgu, ilgwen tullu-chigwis nono-napche. Tegin Jesús Pabzhe kolal chogal: “An-Pabye, imi an ina-kakpid-kobneedyob wilegoedgin nabir noo pe an-takel, pe an-onogoye. Tenal an-itolegedbal-chul, tenal pe-itolegedbalye.” ");
INSERT INTO kvnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tegin Jesús Pabzhe kochagu, kannan e-chapingan-pukwadzhe nonibal. Tegin Jesús e-chapingan-taknoni pato kabmamimal. Tegin Jesús aga e-chapingan-otasgu, Pedroga chogal: —¿Imi pemal anpak mes wachilgwen pel atabijulmaldé Pabzhe kolgal? ");
INSERT INTO kvnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tenal pemal atagenabmal. Tegin pe Pabzhe kolenabmalbal imis-immal-kuoedgin pe melle wilub-taklegal, tegin pe melle an-midmalgal. Tenal pe-purpadin peien Pabzhe kolgal, tenal pe-chandin lolló. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tegin Jesús kannan nadbal Pabzhe kolgal. Wegin Jesús ilabogus Pabzhe-kolgus. Tenal Jesús Pabzhe kolalbalgu, chogalbal: “An-Pabye, imi an inna-kakpid-kobneedyob an peyedzhe wilegoed-akar keg noo pe an-takel, pe akalzhul pe-itolegedbal an-imajunnoye.” ");
INSERT INTO kvnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tegin Jesús kannan e-chapinganzhe nonibalgu, e-chapingan-taknoni pato kabmamimalbal. Tenal Jesús-e-chapingan-e-imiadin pela-pela kabbiedbal a-ito chaktilebimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tenal Jesús aka-pukwa e-chapingan-ebesgu, kannan nadbal Pabzhe kolgal. Wegin Jesús ilapá-kuo Pabzhe-kolgus. Tenal Jesús ampa akpenegwadyob kannan Pabzhe kolalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tegin Jesús kannan e-chapinganzhe nonibalgu, aga e-chapinganga chogal: —¿Imi pemal ampa kabmamimal ulukumamimalyé? Imi an-wilub pato noni. Al an-Te-Tule-Chunna tule-iskanaje uklenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Imisgin pe kwisgumaldo. Nemal. Imi tule-manigin-ankin-akpitchad pato wegin tani. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tegin Jesús ampa aga e-chapinganga chunma-kwichidgin Judas-Jesús-e-chapingan-walambe-kakabogwad-walgwen noni. Tenal tulemal-ichejul Judasbak irmanonimalmo. Tenal tule-nonimalad es-pilacheed-annik nonimal. Tegin we tulemal chowal-oro-annik nonimalbal. Tenal tule-nonimalad, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-chelegan-tummagan-tar-palmialmalad Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Imi teun takalgu, Judas-Jesúsgin-akpitchad iktual tule-nonimaladbak igal-mezhis ka chogzhado: “Imi anmal we tule-abingujal, an we tule-wagal us pe an-takel, pe we tule-kao.” ");
INSERT INTO kvnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Al Judas ilgwen Jesús-abir kwisgunonigu, chogal: —Anná. ¿Tule-oturdaked, pede? Tegidgin Judas Jesús-wagal us. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tegin Jesús Judasga chogal: —An-ai, imi pe aga noni-choggu, imisgin pe imado. Tegin tulemal-Judasbak-nonimalad Jesús-abir kwisgunonimalgu, ilgwen Jesús-kasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tegin tulemal Jesús-kadmalgu, Jesús-e-pakad-walgwen es-pilacheed unnus. Tegin Jesús-pakad tule-irwal-Pabzhe-koled-pul-tummad-e-mos-chiktegu, chuchubi kaledap-idirrí. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tenal Jesús e-pakadga chogal: —Wejego. Es pe kannan uka-yabal yoo. Imi tule-pel-kwapa esgin urwemalal, esgin etimial purkwemogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Imi an Pabzhe kolelen, pemal ebinzhe Pabde imis-imis anka mili-tulapá-kakaambe-angelmal-palmidagojul an-pentagal? Pab anka palmidagodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tenal an-chogzhadyob kuelen, ¿tede igi kuo Pab-kartagin-nermakal-maidyob kunonigal? Keg kue. Tenal antin yabli kaleged-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tegin Jesús apka-tégin tulemal-e-kanonimaladzhe ekichial chogal: —¿Ibiga pemal es-pilacheed-annik tegin chowal-oro-annik an-kadanimal-wede, an-kantikidgin-immal-aturzheed-tuleyob? Imi antin pane-pane Pabzhe-koled-neggin tulemal-oturdadi-kus. Tenal pemal an-kwen-kabijulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tenal pél weob immal kunaid, Pab-kaka-palchogmalad akpene Pab-kartagin-nermajad-yopí kunonigal. Tegidgin Jesús-e-chapingan pél Jesús-midmal, walagwen Jesús-ebesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tegin tule-Jesús-kasmalad tule-irwal-Pabzhe-koled-pul-tummad-Caifászhe Jesús-chesmal. Tenal teun takalgu, Caifás-neggin Moisés-igalgin-tulemal-oturdamalad tegin Judio-chelegan-tummagan ormanonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tenal Pedrodin Jesús-cholbal untar-panku pinna-pinna nad, Caifás-negzhe. Tegin Pedro neg-impaje togzhagu, Pabzhe-koled-neg-takmaladbak mes chigwismo takegal, Judio-tummagan igi Jesús-imamalo-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-tummagan-wala-tulapá-kakaambegwad walbo tule-aminaigualmal kakanzheedgin yopí chogmalgal Jesús Pab-Tummadgin-ataszhulidbal purkweenab. Tenal Judio-tummagan tule-kwen-onoszhulmal Jesúsgin yopí choggal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tenal tulemal-íchejul Jesúsgin pinche kakanzhasmalan, tenal we tulemal yopí kwen chogzhajulmal. Al Judio-tummagan kwen unnijul-kusmal Jesúsgin choggal, Jesúsde purkweenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tenal napigin tule-walbo chognonimal: —Imi we tule chogzhado ede nabir we Pabzhe-koled-neg eyaro. Tegin ede ibapágin kannan pel-kwapa Pabzhe-koled-neg chobbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tegin tule-irwal-Pabzhe-koled-pul-tummad okwichial, Jesúsga chogal: —¿Imi we tule pegin chogzhadgin pe chogojulmoyé? ");
INSERT INTO kvnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tenal Jesús ilgwen yakír pes. Tegin tule-irwal-Pabzhe-koled-pul-tummad Jesúsga chogalbal: —Imi Pab-Tummad-Tulad-nuggin an pega chog: pedin keg-chulgu anka chogenab, pedin Cristo, Pab-Machi-chunchunnad o chul. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tegin Jesús Judio-tummadga chogal: —Antin, Pab-Machido. Tenal an pemalga chogmodo: pemal imis-akar pe an-takmalo, an-Te-Tule-Chunna Pab-pela-pela-kannaleged-nikad-nuedzhik tule-tummadga chii. Tegin pemal an-takmalbalo nikpa mogil-impabal aktedani. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tegidgin tule-irwal-Pabzhe-koled-pul-tummad istar-Jesús-chunmajad-itojadbal aga chiir mol imas. Tenal tule-irwal-Pabzhe-koled-pul-tummad Judio-tummagan-pimaladga chogal: —Imi we tule-chunmajad istar Pab Tummadgin chunmas. ¿Ibiga anmal tule-pid-pal-amio, we tulegin choggal wedin tule-iskana? Imi pemal-pel-kwapa-pukwad ual itosmal, ede istar Pab Tummadgin chunmas. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tenal igi pe chogmalmódin? Tegin Judio-tummagan chogalmal: —Imi we Jesúsdin keg-chulgu purkweenab. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tegin Judio-tummagan kep Jesús-wagalgin kwi-mialmal, tegin chunkalgin Jesús-sakismalbal. Tenal tule-wal-walgwen Jesús-e-takchulidgin twas Jesús-imasmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tenal tule-Jesús-sakijad Jesúsga chogalmal: —Imi pe Cristo-Pab-akpene-chogzhad-palmidagoed-tule-choggu, imisgin pe chogdo, toa pe-ebios. Tenal Jesús we tulemalga immal kwen chogzhajul-kus, ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tegin Pedro neg-impabal ampa chiidgin, puna-mos-walgwen Pedroga chognoni: —¿Imi pe we Jesús-Galileaginedbak pe kudimoganzhulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tegin Pedro pel-kwapa-tulemal-wagin chogal: —Chulá. An wichí toagin pe chunmanai. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tegin Pedro kwisgudgu, nad. Tegin Pedro wanagak omosgu, puna-pid tar-takalbal. Tenal puna tule-aka-pukmaladga chogal: —We tule, Jesús-Nazaretkinedbak kudimogan. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tegin Pedro chogalbal: —Chulá. Imi an napírra chunchunnad an pega chogdo: antin we tule-kwen-wichul. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tegin apka te-cholbal, tule-aka-pukmalad Pedroje nonimal chogalmal: —Tenal an penzhul pedin we tule-e-pakadmo. Imi pe-chunmaked ampa tule-kalejad-yopí chunmamo. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tegin Pedro chogalbal: —Imi an kakanzheelen, Pab akalzhul sapejul an-oturdakoen. Tenal antin we tule-kwen-wichul. Tegidgin kallin-mastad apka-pakal namakal. ");
INSERT INTO kvnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tegin Pedro kep wisgud-nad, akpene igi Jesús ega chogzhagujad. Tenal Jesús akpene Pedroga chogzhado: “Yo kallin-mastad namakeddu, pe ilapá ankin chogo: ‘An Jesús-kwen-wichul.’ ” Tegin Pedro ilgwen magadbal nodgu, pela-pela-pukib-itogedbal pononijun. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tegin neg-oiposgu, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-chelegan-tummagan pel-kwapa igal-mezhismal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tegin tummagan Jesús-etismalgu, Romano-gobernador-Pilatoje Jesús-chesmal. Tegin Judio-tummagan Pilatoga Jesús-ukchamalzhun Jesúsga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tegin Judas-manibal-Jesúsgin-akpitchad takchagu Judio-tummagan Jesús-mesnemal, Judas Jesús-ukchadbal peyedzhe pukib-itononi. Tegin Judas tule-irwal-Pabzhe-kolmalad-e-tummaganga tegin Judio-chelegan-tummaganga mani-chibu-tulabogiid-kwa-tulagwen-kakaambegwad kannan ukchabal. Tegin Judas Judio-tummaganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Imi antin tule-immal-akaloszhulid-ukchadbal, iskuedgin arkwas. Tegin Judio-tummagan Judasga chogalmal: —¡Ankadin iwen-akaldoleged! Wedin pato pegin chii igi aga pe imabídin. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tegidgin Judas Pabzhe-koled-neg-yabal mani midgu, ilgwen nad. Tegin Judas nadgu, aga tukin kammu-kaal aga mechajun. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan, Judas-mani-mided, pél wesmal. Tegin Judio-tummagan chogalmal: —Imi we manigin abe-ariojadbal igal-pal-nikchul Pabga-mani-chabomaladgin chabogal. Wedin izhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Al Judio-tummagan aga igal-mezhismal we manigin nap-neg-napcha-nikad pakegal, tule-aknemalad purkwijal, we uangin tigmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Al we uan imisgwadzhe nug Abe-uan. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tenal Judasgin immal kujadbal, Pab-kaka-palchoged-Jeremías akpene chogzhagujadyob kunoni. Tenal Jeremías chogzhado: Tulemal mani-chibu-tulabogiid-kwa-tulagwen-kakaambe chusmal. Tenal Israel-tulemal weob-melgu we tulegin mani-wilub nazhismal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tenal we manigin nap-neg-napcha-nikad paknonimal, Pab Tummad anka chogzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tegin tulemal Gobernador-Pilatoje Jesús-cheinonimal Jesúsga igal-itogal. Tegin Pilato Jesúszhe ekichial: —¿Ade pede Judiomal-erreyzhí? Tegin Jesús Pilatoga chogal: —Imi pe nabir chogzhado. Antin erreydo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-chelegan-tummagan Jesús-tuktinonimal. Tenal Jesús yabli Judio-tummagan-kwen-abin-imaszhul, ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tegin Pilato Jesúsga chogal: —¿Imi pe itoszhulzhí, tulemal igi pegin chogmal? ");
INSERT INTO kvnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tenal Jesús ilgwen yakír pes, kaka kwen kochajul-kus. Tegin Pilato takchagu Jesús ilgwen yakir pes, Pilatodin peyedzhe weob pakal pes. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tenal gobernador kusgu Pab-Najad-Itoged-ilbal Judio-tulemal-chogedbal tule-walgwen-oturdalemaid-ono. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Imi teun takalgu, tule-nug-tummad-nikad-walgwen oturdalemai. We tuledin nug Barrabás. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tegin tulemal-pel-kwapa irmanonimalgu, Gobernador-Pilato tulemalzhe ekichial chogal: —¿Toa pe peimal an pega onogal, Barrabás o Jesús? Imi we Jesúsdin nugbal Cristo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tenal Pilato wisdo, Judio-tummagan nobedbal eje Jesús-cheinonimal, Jesúsga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tegin Pilato ampa Jesúsga igal-itonaidgin, Pilato-e-ome aga e-macheredzhe kaka palmial chogal: “Imi we tule-immal-kwen-akaloszhulidgin pe melle yoledamogo. Tenal antin imis-oipos kabdas anmal we tulebal peyedzhe wiledii.” Tenal Pilato e-omebal kwen ibzhaszhul. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Judio-chelegan-tummagan tulemal-pinzheed-kasmal Pilatoga choggal: “Pe Barrabás-onogo, tenal Jesúsdin pe mejo.” ");
INSERT INTO kvnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tegin Pilato tulemalzhe kannan ekichialbal chogal: —¿Imi we tule-walbogid, piti pe peimal an pega ono? Tegin tulemal Pilatoga chogalmal: —Barrabás pe anmalga onogo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tegin Pilato tulemalzhe ekichialbal; —¿Imi we Jesús, tegin pemal-pimalbalid-Cristo, an igi chaojun? Tegin tulemal-pel-kwapa pulal Pilatoje kotemal chogalmal: —¡Nakrusgin pe Jesús-pioko! ");
INSERT INTO kvnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tegin Pilato tulemalzhe ekichial: —¿Ibigadé? ¿We tulede, ibi akalos-ade, an tar-piokkal? Tenal tulemal pul-pule pulal kigma kotemal chogalmal: —¡Nakrusgin pe Jesús-pioko! ");
INSERT INTO kvnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tegin Pilato taknoni igal-keg-pel-nudale. Tenal Pilato takchabalgu tulemal pul-pule urwedanimal, ti amis, tulemal-wagin tigin-chunkal-enukkal oyogal, ede we immalgin pal kwen yolenejul. Tegin Pilato tigin chunkal enusgu, tulemalga chogal: —Imi pe we tule-mechamalal, pato ankin chijul, wedin pato pemalgin chii. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tegin tulemal-pel-kwapa Pilatoga chogalmal: —Imi anmal we Jesús-mechamalal, anmalgin pato chii, tegin anmal-wagwagangin pato chimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tegin Pilato tulemalga Barrabás-onoszhun. Tegin Pilato e-chulubmalga chogzhajun peyedzhe Jesús-ebiomalgal. Tenal Pilato Judiomalga igal-ukchabal nakrusgin Jesús-piokmalgalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tegin gobernador-chulubmal e-neg-tummad-yabal Jesús-odosmal. Tegin we chulubmal pel-kwapa e-pakamalad-aka-pukmaladzhe kochamal. Tegin chulubmal-pel-kwapa nonimalgu, pulal Jesús-ebiris ampagunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tegin chulubmal Jesúsgin mol echusmalgu, erreyyob Jesúsgin mol-kinnid yosmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tegin chulubmal tub-iko-nikad kwilomasmalgu, Jesús-nonogin iko-kurkin chismalzhun. Tegin chulubmal Jesús-chunkal-nuedzhik Jesúsga kabaston ukchamalbal. Tegin chulubmal yami Jesúsgin todoedgin Jesús-abir chimtinonimal chogalmal: —Judio-erreyye, imi pe ilagwen-nadgu tummadga mailen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tegin chulubmal Jesúsgin kwi mialmal. Tegin chulubmal Jesús-e-kabaston-kanikidgin kannan-kannan Jesús-nono-okosmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tegin chulubmal pél Jesúsgin todosmalgu, Jesúsgin mol-kinnid echusmal. Tegin chulubmal kannan Jesúsgin e-mol yosmalbal. Tegin chulubmal Jesús-chesmalzhun, nakrusgin Jesús-piokkal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tegin chulubmal nakrusgin Jesús-piokkal Jerusalén-neg-kwebur-akar aknidmalgu, Cirene-tol-walgwen-abingusmal e-abin tani. Tenal we tuledin nug Simón. Tenal chulubmal kantikidgin Jesúsga-nakrus-chedgal Simón-imasmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tegin chulubmal Gólgota-neg-nugadzhe nonimal. Tenal Gólgota choglege: Tule-Nono-Kal-Yal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tenal chulubmal Gólgota-yalzhe nonimalgu, Jesúsga immal-kakpid-vinobak-obural ukchamal kobgal, Jesús melle twagdar nakpi-itogal. Tenal Jesús íche itosgu, yapa pal kobgus. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tegin chulubmal nakrusgin Jesús-piokchamalgu, Jesús-e-molgin todoalmal toa pul-melu aga Jesús-mol chumalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tegin chulubmal aka ampagusmal Jesús-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tenal chulubmal nakrus-tukugin nermakal karta nazhismal tulemal wisgal ibiga Jesús-purkweenab. Imi we kartagin nermakal naigusdo: ");
INSERT INTO kvnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Imi teun chulubmal nakrus-pidgin egek walbo tule-immal-aturzhemalad-piokchamalmo, kwén Jesús-nuedzhik, kwéntin Jesús-chapilezhik. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tenal tulemal-igalbal-irmamamimalad istar Jesúsgin chunmakaldamal, tegin Jesúsga chagla pin-pin kualdamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tegin tule-irmamamimalad Jesúsga chogaldamalbal: —Imi pedin chogzhado: ‘An ilgwen Pabzhe-koled-neg eyarne, tegin an ibapágin kannan pél chobbalo.’ Imis pe weob chogzha-choggu, imisgin aga tukin pe abonodo. Imi pe Pab-Machi-chogel, pe nakrusgin-naid-akar pe aktedo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad tegin Judio-chelegan-tummagan ampa istar Jesúsgin chunmakalmal chogalmalmo: ");
INSERT INTO kvnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Imi Jesús tule-pimalad-abonos. Tenal Jesús aga tukindin keg abonogus. Imi we tule anmal-Israel-tulemal-e-erreyelen, nakrusgin-naid-akar akteoen. Agin, anmal kep we tulegin ibzhenonimaloen. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tenal we Jesús Pab Tummadgin kwen penzhul-kus, tegin chogzhabaldo, ede Pab-Machi. Al Pab Tummad yer Jesús-takel, nakrusgin-naid-akar Jesús-odeodo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tenal tule-walbo-immal-aturzhemalad-Jesúsbak-pioklesmalmogad, ampa Judio-tummagan-yopí istar Jesúsgin chunmananimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tegin yoroku-akar wachilapáje neg-pel-kwapa chichidbi naigus. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tegin wachilapágin Jesús sapejul kolmas, e-kakagin chogal: “Elí, Elí, ¿lema sabactani?” (Wedin choglege: An-Pab-Tummadye, an-Pab-Tummadye, ¿ibiga pe an-meteye?) ");
INSERT INTO kvnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tegin tulemal-aka-kwen-pukmalad Jesús-chogzhad itosmalgu, chogalmal: —Pe pito, we tule Pab-kaka-palchoged-Elías-akpenegwadzhe kolnai. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tegidgin tule-walgwen abarmad upchanyob-immal-tutu amigal. Tegin tule immal-tutu onosgu, vino-choledgin wartichas. Tegin we tule chowal-tukugin immal-tutu yosgu, Jesúsga ukcha nugal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tenal tule-pimalad tule-Jesús-pentanaidga chogal: —Meke nai; anmal takegal Elías noniko-dewa o chul-dewa Jesús-abonogal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tegin Jesús kannan sapejul kotegu, ilgwen purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tegidgin Pabzhe-koled-neggin mol-naid apallala islis, nikpa-akar ulpalidzhe. Tegin neg pela-pela tutumas, tegin akwa-tummagan mamarisbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tegin uangin akwa-yamal arkas-nadmal. Tegin tule-Pab-nued-wismalad-akpene-pato-purkwismalad-ichejul kannan tullesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tegin tulemal-kannan-tullesmalad uan-akar aknismal. Tenal Jesús kannan-tullejad-cholbal, tule-kannan-tullesmalad kep neg-kwebur-chwilidikid-Jerusalénzhe togzhamal. Tenal tule-kannan-tullesmalad ichejul tulemal-pukmaladga nononimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tegin chulub-tummad-Jesús-takkwichid e-pakamaladbak neg-tutumaked itosmalgu, tegin pél immal-kunaid takchamalbalgu, peyedzhe kwakialmal. Tegin chulubmal chogalmal: —¡Imi we tule chunchunnad Pab-Machi-taklebalí! ");
INSERT INTO kvnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tenal teun takalgu, omegan-ichejul panna Jesús-takpukmal. Tenal we omegan Jesúsbak Galilea-akar nonimal Jesús-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tenal we omegan-nonimalad-abalgin, María Magdalena, Santiago-tegin-José-e-nan-María, tegin Zebedeo-machimal-e-nan pukwamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tegin tad-arkwandanigu, Arimatea-tol-mani-ibed-walgwen noni. We tuledin nug José. Tenal we Josédin Jesúsbal-turdaked-tulemo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tenal José nad, Pilatoje Jesús-mui ekisgal. Tegin José Pilatoje Jesús-mui ekichisgu, Pilato chulubmalga kaka-palmialzhun Joséga Jesús-mui uko. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tegin José nakrusgin-naid Jesús-mui odesgu, mol-chibugin Jesús-mui ebirmas. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tegin José Jesús-mui ches uanzhe. Tenal José akpene aga akwa-ya akis, ede purkwijal, aka-tégin e-tigmalgal. Tenal José we akwa-ya-pingin Jesús-mui tigzha. Tegin José akwa-tummadgin ya chaktisgu, nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tenal José Jesús-mui-tignaigu, María Magdalena tegin María-pid uan-abin-opakal takpuk-kusmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tegin te pangin, Immalmal-Nudaked-Ibe-cholbal, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Pariseomal Pilatoje nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tegin Judio-tummagan Pilatoga chogalmal: —Tummad, imi anmal ampa wismaldo, we tule-kakanchili-imis-purkwijad ampa tuladgin chogzhagusdo, ede ibapágin kannan tullebalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Al anmal pei, pedin ibapá uangin chulubmal-urpo Jesús-mui-takegal. Chulil, Jesús-e-chapingan mutik e-mui-aturzhenoniko-dewa. Tenal Jesús-e-chapingan Jesús-mui-aturzhajal, tulemalga chognonimalo: ‘Jesúsde kannan tulles.’ Imi an-chogzhadyob kunonikil, akpene-immal-kujadga pul-pule tulemal yardalenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tegin Pilato Judio-tummaganga chogal: —Nabir. Tegil pe chulubmal-chedmaldo uanzhe. Tenal pemal nue takenabmal tulemal melle Jesús-mui-aturzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tegin Judio-tummagan chulubmal-chesmal uan takegal. Tegin Judio-tummagan akwa-tummadgin sello nazhis melle akwa onirmalgal. Tegin Judio-tummagan pukwa chulubmal-ebesmalzhun uan takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tegin ulukued-ibe-pelgujad-pangin, Tumigin, wakur-neg-tale-tale María Magdalena tegin María-pid uanzhe nadmal Jesús-tiglejad-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tegidgin Pab-angel nikpa-neg-akar aktenonikidbal, neg pela-pela tutumakal. Tegin angel uan-ya-chiidzhe kwisgutapku, akwa-uan-ya-chaktijiid onirnoni. Tegin angel akwa-tummad-askin nakwis. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tenal Pab-angel maripedyob pi-pi-pip ka. Tenal Pab-angel-e-moldin ukurwalyob ilgwen chipú-takle. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tegidgin chulubmal-uan-takpukmalad angelgin-kwakijadbal tutumakalmal tegin neg-igeedmal, ilgwen purkwijadyob pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tegin angel omeganga chogal: —Pe melle tobgumalma. Imi an wisdo, pemal Jesús-nakrusgin-purkwijad-amidanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tenal Jesús wegin pal maichul. Tenal Jesús akpene-pemalga-chogzhadyob kannan tulles. Imisgin pe taktamaldo, wegin Jesús-mui-mezhismalan. Tenal Jesús wegin pato kwen maichul. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Imis pe kueye-kueye nemalo e-chapinganga choggal: ‘Jesús purkwaled-akar kannan tulles. Tenal Jesús pe-iktual Galileaje ne. Tenal pemal Galileagin Jesús-takmalo.’ An webi unnila pega chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tegin omegan uan-akar kueye-kueye nadmalzhun. Tenal omegan tobed-abalgin, tenal ulubgin yer weligwal-ito-nadmalbal. Tegin omegan Jesús-e-chapinganzhe abarmadmalzhun e-chapinganga choggal Jesús kannan tulles. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tenal Jesúsdin apka-pakal omeganga nononigu, omeganga chogal: —Anná, tegidde, ¿pemalde? Tegin omegan Jesús-abir chimtinonimal. Tegin omegan palge-palge malibal Jesús-imasmal. Tegin omegan Pab Tummadyob Jesús-otummosmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tegin Jesús omeganga chogal: —Melle pe ankin tobgumalo. Imi pemal an-kwenadganga chognemalo, emalde Galileaje neenabmal. Tenal emal Galileagin an-takmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tegin omegan ampa Jesús-e-chapinganzhe natapidgin, chulubmal-uan-takpukmalad-abal neg-kweburzhe nadmal. Tenal chulubmal neg-kweburzhe omosmalgu, tule-irwal-Pabzhe-kolmalad-e-tummaganga palchogzha, pél immal kujad. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan Judio-chelegan-tummaganbak ormanonimalgu, igal-amismal chulubmalga choggal: “Pe melle tule-pimaladga pe palchogo uangin pél immal kujad.” Tegin Judio-tummagan chulubmal-uangin-ampagusmaladga íchejul mani ukchamal melle tulemalga palchoggal uangin igi kujad. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tenal Judio-tummagan chulubmalga chogzhamalbal: —Imi tule peje ekisalmalal, uangin igi immal kus, pedin tulemalga chogmalo: ‘Jesús-e-chapingan mutik-anmal-kabmamikidgin Jesús-mui-aturzhasmal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tenal we kaka gobernadorzhe omojal, anmal gobernadorbak igal-nudamalo, melle pemalga poni nononigal. Tegin chulubmal Judio-tummaganga chogal: —Tegil nabirdé. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tegin chulubmal mani abingasmalgu, Judio-tummagan-ega-chogzhadyob chogdi-kualmalzhun. Imi ampa imisgwadzhe meke-pia-pe-nadel, ampa Judiomal-abalgin chunmadimal, Jesús-e-chapingan Jesús-mui-aturzhasmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tegin Jesús-e-chapingan-walambe-kakagwenchakkad Provincia-Galileaje nadmalzhun, yal-Jesús-ega-chogzhagujadzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tegin e-chapingan Jesús-takchamalgu, Pab Tummadyob peyedzhe Jesús-otummoalmal, tenal e-chapingan kwénna-kwénna ampa Jesúsgin pengusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tegin Jesús aga e-chapingan-abir kwisgunonigu, chogal: —Imi Pab Tummad pel-kwapa anka igal-ukcha nikpa-neg takegal, tegin iti-nap-naid-ugakche pel-kwapa neg-takegalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Al pe nemalzhunno tule-akal-akal-chunmaked-ilbal, tegin pemal nuekwa tulemal-oturdakenabmalbal anpal-naigugal. Tegin pemal Pab-Tummad-nuggin, tegin Pab-Machi-nuggin tegin Pab-Purpa-Nued-nuggin, tigin pe tulemal-ogmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tenal pemal tulemal-oturdamalbalo pel-kwapa an-pega-chogzhad-pallí immal imagal. Tenal antin keg-chulgu pemalbak pane-pane kudiguo, neg-tukuje. Pitomalgu.");
INSERT INTO kvnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Imi Jesucristo, Pab-Tummad-Machi, kepe-sagla-akar egin-kaka-nuegan chunmalejad weob chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Imi akpene Pab-Tummad-kaka-palchoged-Isaías nermasdo: Pab Tummad chog: Imi antin pe-iktual tule-igal-nudaked-palmine, pega igal-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Imi tule-walgwen neg-nikchulidbal kolmakal-kolmakal chunmanoniko: “Imi pemal Tule-Tummadga neg nudakenabmal, tegin pe inniki-inniki Tummadga igal imakenabmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Imi Pab-Tummad-kaka-palchoged-Isaíasga chogzhad-yopí, Juan noni. Tegin Juan tigin-tule-ognoni, tegin neg-nikchulidbal chunmanonibal: “Imi pemal aga ulubgin iskuedgin pukib-itogenabmal, tegin pe-taed ogwaenabmal. Tegin pe tigin oglegenabmalbal, Pab Tummad pega iskued-nikad eligal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tegin tulemal-Judeaginmalad-pel-kwapa, tegin Jerusalén-neg-kweburginmalad-pel-kwapa Juan Bautistaje nonimalzhun Juan-itomalgal. Tenal tulemal Pabga aga iskued palchogzhadgin, Juan Jordán-tiwalgin tar-okchamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tenal teun Juan Bautista moli-camello-e-abzhal-makaled-mol yowi, tegin moli-tub muzhilgin naibal. Tenal Juan-e-mas-kunneddin, ches-chakar-chakar, tegin acha-nis. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tenal Juan tulemalga chognonijun: —Imi tule-walgwen-an-cholbal-tanikiddin, anka pul kannaleged nika. Tenal we tule anka pul tule-tummadiidbal, an kwen unnijul tullu we tulega e-sapat-tub echikkal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tenal antin unnila tiginbi tule-og, oyogal tule ulubgin chunchunnad iskuedgin pukib-itononimal. Tenal tule-an-cholbal-tanikiddin, Pab-Tummad-Purpa-Nuedgin pe-ogmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Imi Jesús Nazaret-Galileagin maidgin, Jordán-tiwalzhe al. Tegin Jesús Jordán-tiwalzhe nonigu, Juan Bautista tigin Jesús-okchamo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tegin Jesús ti-akar nakwisgu, Jesús takcha Pab-neg arkat, tegin Pab Purpa Nued nuyob egin aktedani. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tegin Pab Tummad nikpa-akar Jesúszhe kolnoni, chogal: —Imi pedin, an-Machi-Pilaled; al an pegin weligwal-itomo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tegin Juan tigin Jesús-okchad-cholbal, Pab Purpa Nued ilgwen Jesús-ches, neg-nikchulidbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tenal Jesús iba-tulabo neg-nikchulidbal kudigus, immal-tulgan-chapurbalid-abalgin. Imi teun nia-Satanás Jesúszhe noni. Tenal Satanás Jesús-wilub-taknaigual iskuedgin Jesús-egwangal. Tenal te-cholbal angelmal Jesús-pentanonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Imi Herode oturdaleged-neggin Juan-Bautista-odosmalad-cholbal, Jesús kep Galileaje nonimo, Pab-Tummad-kaka-nuegangin chunmanoni. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tegin Jesús chogal: “Imi ibe noni, tenal Pab-neg-takmaid e-wilubgan omodani. Al pemal aga ulubgin iskuedgin pukib-itogenabmal. Tegin pe melle ulubgin Pab-Tummad-kaka-nuegan pengumalbalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tegin Jesús Galilea-mata-kakpal pipirmadiidgin, Simón-takal e-urpa-Andrésbak chakigin ua-kananimal. Tenal we tule-walbogid kusgu ua-kaedgin-arpamalad. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tegin Jesús we tule-walbogidga chogal: —Anpak nemalma, ankin turdagal. Imi pe ua-kadiidyob, pe anka tulemal-amigal ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tegin Simón tegin Andrés chaki ebesmalgu, ilgwen Jesúsbak nadmalzhun, Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tegin Jesús iche ukin nadgu, walbo tule-takalbal, ulgin chaki nudananimal. Tenal we tule-walbogid Zebedeo-machimal, Jacobo tegin e-urpa-Juan. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tegin Jesús ilgwen we tule-walbogidzhe kochamalmo egin turdagal. Tegin Jacobo tegin Juan Jesúsbak mes nadmalmojun, Jesúsgin turdagal. Tenal Jacobo-tegin-Juan-e-pab-Zebedeodin e-mosmalbak ulgin pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tegin Jesús aga e-chapinganbak Capernaum-neg-kweburzhe nonimalgu, ulukued-ibe-kepe-naigujadgin Judio-ormaked-neggin togzhamal. Tegin Jesús Pab-igalgin tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tegin Jesús tulemal-oturdasgu, tulemal weob pakal pesmal. Imi teun Jesús igal-nikadgin tulemal-oturdadi-kus, tenal tule-Moisés-igalgin-tulemal-oturdamaladyob Jesús tulemal-kwen-oturdajul. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Imi teun takalgu, Judio-ormaked-neggin tule-walgwen-nia-iskana-nikad chimo. Tegin nia sapejul tule-okormasgu, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús-Nazaretkinedye, ¿ibiga pe anmalgin yoledanimo-wede? ¿Pe anmal-opelodaniyé? Imi antin pe-wisdo, pedin toa-tule: pedin tule-chwilidikid; pe Pab-Tummad-nuggin-tanikid-tuleye. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tegin Jesús niaga sapejul chogal: —¡Pe ilgwen yakir-kuo! Pe we tule-akar ilgwen nobalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tegin nia pintomamai tule-imas. Tegin nia pinnajul kolmamaigualgu, ilgwen tule-akar noszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tegin tule-takpukmalad-pel-kwapa weob pakal pesmal. Tegin tulemal aga emal-emal chogalmal: —¿Ibi-tule wede weob chunmakedde? We tule akal-pakal Pab-igalgin tule-oturda, tegin igal-nikadgin nia-iskanaga chogbal: ‘¡Pedin noo!’ Tenal nia pal ibzhebal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tegin tulemal-Galileaginmalad-pel-kwapa wisgusmal, Jesús pirkin tule-nuda, tegin Pab-igalgin yer tule-oturdabal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tegin Jesús aga e-chapinganbak Judio-ormaked-neg-akar aknismalgu, Simón, Andrés, Jacobo, Juan; amal-walatal Simón-negzhe nadmal. Tenal we negdin ampa Simón-e-urpa-Andrésgadmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tegin Jesús Simón-negzhe nonimalgu, Jesúsga chogalmal, Simón-chak-e-ome pela-pela uged tarmamai. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tegin Jesús Simón-chak-omeje nad. Tegin Jesús Simón-chak-ome-maidzhe nonigu, chunkalbal Simón-chak-ome-kas. Tegin Jesús Simón-e-chak-okwichisgu ugeddin ilgwen Simón-e-chakka akis. Tegin Simón-chak-ome Jesúsmalga immal chaalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tegin tad-arkwatku, neg-chichilegalgu, tulemal Jesúszhe pel-kwapa tule-yemalad-cheinonimal tegin tule-nia-nikmalad-cheinonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tegin tulemal-neg-kweburginmalad-pel-kwapa Jesús-neg-maid-wanagakche ampagunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tegin Jesús ichejul tule-yemalad-nudas, tegin ichejul tulemalgin nia-onisbal. Tenal niamal wismal, Jesúsde toa-tule. Al Jesús niamalgin igal-kas melle egin chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tegin te pangin polego, Jesús neg-maid-akar nod. Tegin Jesús neg-tule-nikchulidbal nad Pab Tummadzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tegin Simón aga e-pakamaladbak takchamalgu Jesús taklejul, Jesús-aminadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tegin Simónmal Jesús-onosmalgu, Jesúsga chogalmal: —Tulemal-pel-kwapa pe-aminanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tegin Jesús Simónmalga chogal: —An we tulemalgabi nonijul. Tenal antin iti-napche noni pel-kwapa tulemalga Pab-kaka-nuegangin chunmagal. Al imisgin anmal nemalzhundo, neg-kwebur-pimaladzhe; tule-pukmaladga Pab-kaka-nuegan chognegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tegin Jesús Provincia-Galileabal, neg-kwebur-ilbal Judio-ormaked-negmalgin, tulemalga Pab-Tummad-kaka-nuegangin chunmadi-kus. Tegin Jesús tulemalgin niamal-onidi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tegin te ibagwengin tule-lepra-poni-nikad, Jesúsgin-atagedbal Jesús-abir chimtinoni tegin Jesúszhe wilenaigual chogal: —Imi an kwen penzhuldo pedin unni an-nudagal. Al pe an-nudabiel, akalzhul pe an-nudakoye. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tegin Jesús tule-lepra-poni-nikad-takchagu, wilejakwa we tule-takal. Tegin Jesús tule-lepra-poni-nikadgin chunkal-mezhisgu, tule-yeedga chogal: —Imi antin, an yer-ito pe-nudagal. Imisgin pe nugudo. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tegidgin tule-lepra-poni-nika-nad ilgwen nuguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tegin Jesús sapejul tule-lepra-poni-nika-nadga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Imidin pe akalzhul nao, tenal pe melle tule-pimaladga pe pal chogo, antin pe-nudas. Tenal pe ilgwen tule-irwal-Pabzhe-koledzhe, aga pe-chan oyonao, tegin pe chogo: ‘Antin nugus.’ Tegin pe chwilidik peigal, pe Moisés-igal-mamikidbal pe immal chedbalo, Pab Tummadga ukegal, tulemal wisgumalgal pedin chunchunnad nugus. ");
INSERT INTO kvnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tegin tule-nugujad nadzhun. Tenal tule-nugujad yabli pel-kwapa tulemalga chogdi-kualzhun, Jesús igi e-nudas. Al Jesús keg neg-kweburgangin toggus, unnila neg-tule-nikchulidbal nanedi-kus. Tenal tulemal-akne-aknemalad ichejul Jesúszhe nonidamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tegin te-cholbal untaradgin, Jesús kannan Capernaumzhe nonibal. Tegin tulemal wisgusmal Jesús e-neggin mai. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tegin tulemal-ichejul Jesúszhe nonimaladbal neg-yabal takaá pukwamal magadbalidzhe-pakal. Imi teun Jesús Pab-kakapurwagin tulemal-oturdanai. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tegin tule-walabake Jesúszhe kachigin aga ai-cheinonimal, tenal e-aidin abgan-purkwaled-poni nika. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tenal tulemal-ichejul wanagakkin pukwa-choggu, al tule-walbakegwad keg toggusmal Jesús-chiidzhe. Tegin tule-walbakegwad neg-pirgin nakwismalgu, Jesús-chiid-inniki kep neg-uwas utusmal. Tegin tule-walbakegwad Jesús-chiid-inniki kachigin tule-yeed-odesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tegin Jesús takchagu tule-walbakegwad egin kwen penzhulmal, Jesús tule-abgan-purkwaledga chogal: —An-ai, pe-iskueddin pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Imi teun takalgu, tule-Moisés-igalgin-tulemal-oturdamalad-wal-walgwen Jesús-itobukmalmo. Tenal we tulemal Jesús-itosmalgu ede nabir tule-iskued eli, pinzhealmal: ");
INSERT INTO kvnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ibiga we tule Pab-Tummadgin-atajulidgin chunmakal-wede? Imi Pab Tummadbi unnila igal-nikado tule-iskued eligal. Al we tule Pab Tummadgin walmas.” ");
INSERT INTO kvnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tenal Jesús ulubzhe mag tule-tak-choggu, al Jesús ilgwen wiis Judio-tummagan igi ulubgin pinzhebukmal. Al Jesús we Judio-tummaganga chogal: —¿Ibiga pe ulubgin an-pengusmal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Pemal ebinzhemal antin keg tule-iskued eli? Tenal an we tulega chogzhal: ‘Pe-iskued pelgus.’ we tulega yabli iskued pelguenab. ¿Ibi pul-pulejul? ¿Tule-yeed nudaked o tule-iskued-elied? Pog-pel ibi-puled. Al an unnigujal tule-yeed nudagal, an unnigumogo tule-iskued eligal. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Imi pe wisgal, an-Te-Tule-Chunna igal-nika iti-napkinga tule-iskued eligal, an imisgin tule-yeed-nudanejun. Al Jesús tule-yeedga chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Imi an pega chogdo: imisgin pe kwisgu, aga pe kachi olma. Imisgin pe negzhe naddo. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tegin tule-takpukmalad-wagin tule-yee-nad nugusgu, ilgwen kwisgus. Tegin tule aga kachi olmasgu, ilgwen nadzhun. Tegin tulemal-pel-kwapa-takpukmalad weob pakal pesmal. Tegin tule-takpukmalad Pab-otummoalmal chogalmal: —Anmal weob immal kwen taktijulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tegin Jesús kannan Galilea-mata-kakabal nadbal. Tenal teun tulemal-ichejul Jesúszhe nonimalmo. Tegin Jesús Pab-Tummad-igalgin tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tegin Jesús natapidgin Alfeo-machi-takal, Leví. Tenal Levídin Romano-tummadga-mani-egwaned-neggin chii, tulemalgin-mani-egwannai. Tegin Jesús Levíga chogal: —Anpak nemalma ankin turdagal. Tegin Leví Jesúsga chogal: —Tegil nabirdé. Tegin Leví kwisgudgu, ilgwen Jesúsbak nadzhun Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tegin Jesús Leví-neggin mas kunnalmalzhun. Tegin Jesús aga e-chapinganbak Levíbak mas kunpukwadgin, tule-Romano-tummadga-tulemalgin-mani-egwanmalad tegin tule-iskued-nikmalad-pimalad-ichejul Jesúsbak mes mas kunpukmalmo. Tenal we tulemal-ichejul kusgu yer Jesús-itodimalad. Al we tulemal Jesúsbak mes mas kunpukmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tegin Moisés-igalgin-tulemal-oturdamalad Pariseomalzhik-naigusmalad Jesús-takchagu tule-Romano-tummadga-tulemalgin-mani-egwanmaladbak tegin tule-iskana-pimaladbak mes mas kunchii, we Judio-tummagan Jesús-e-chapinganzhe ekichialmal: —¿Ibiga pe-tummadde tule-Romano-tummadga-tulemalgin-mani-egwanmaladbak tegin tule-iskued-nikmalad-pimaladbak mes mas kunpukmal-wede? Wedin ib-nuedzhul. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tegin Jesús Pariseomal-chunmanani itosgu, Pariseomalga chogal: —Imi tule-yemalad ina-tuled-napimal, tenal tule-poni-nikchulmalad ina-tuled-kwen-napijulmal. Tenal antin ina-tuledyob tule-iskued-nikmalad-aminoni, an tule-nuegan-aminoni-chul. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Imi te ibagwengin, Juan-chapingan tegin Pariseo-chapingan mas-kunchul-kudimal. Tegin tulemal Jesúszhe nonimalgu, Jesúszhe ekichialmal: —¿Ibiga Juan-chapingan mas-kunchulidgin nanemal, tegin Pariseo-chapingan ampa mas-kunchulidgin nanemalmo, tenal pe-chapingandin mas-kunchulidgin kwen nanejulmal? ");
INSERT INTO kvnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tegin Jesús tulemalga chogal: —Nabir. Imi an purpal pemalga chogdo: ¿imi tule-ome-nikunail, machi-ome-nikuneed-chiidbal tule-irmanonimalad mas kunchul-kuo, pe ebinzhe? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tenal machi-ome-nikuneed tulemal tarbi-chesmalal, kep we tulemal mas-kunchulidgin nanedamalo. Imi tulemal an-chesmalal, kep an-chapingan mas-kunchulidgin nanedamalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tegin Jesús purpal chogalbal: “Imi tule mol-mukwagin mol-koa-pin kwen matamajulmal. Imi an-chogzhadyob tule mol-matamakelen, mol kaledel, pul-pule isloen.” ");
INSERT INTO kvnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tegin Jesús purpal immal-pid chogalbal: “Imi pemal wismal, puglu-moli-ukagad ilkwénna wis ebule inna chigal. Al tule keg ku tule puglu-ebugaledgin inna-kabil-pin chigal. Imi tule puglu-ebugaledgin inna-kabil-pin chielen, inna-pin kakpi-kudel, puglu-ebugaled chellellegedbal ilgwen marroen, tegin inna-kabil pél perienguoen, tegin puglu-moli-ukagad iskubaloen. Al tulemal puglu-moli-ukagad-pingin inna-kabil-pin chimal. Al tule-igal-pin igal-cheredbak keg kumo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tegin te ibagwengin, ulukued-ibegin, Jesús aga e-chapinganbak trigo-naidbal natapidgin, Jesús-e-chapingan trigo-kwa kwane-natapmal. Imi teun takalgu, Pariseomal-wal-walgwen Jesúsbak natapmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tegin Pariseomal Jesúsga chogalmal: —Jesús, pe tak. ¿Ibiga pe-chapingan ulukued-ibegin trigo-kwa kwane-natapmal-wede? Wedin arpaged. Al ulukued-ibegin weob immal-imakeddin izhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tegin Jesús Pariseomalga chogal: —An-chapingan noal immal imananijulmal. ¿Imi pe Pab-kartagin apchodimalzhulzhí akpene Errey-David aga e-chapinganbak ukul-mesdanikidgin igi kus? ");
INSERT INTO kvnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Imi teun Abiatar tule-irwal-Pabzhe-kolmalad-pul-tummadga mai. Tegin David Pab-Tummadzhe-koled-neg-yabal togzhamal. Tegin David aga e-chapinganbak Pabga-madu-uklejad kuchamal. Tenal madu-Pabga-uklejad unnila tule-irwal-Pabzhe-kolmaladbi igal-nika we madu kunkal. Tenal David we madu-kuchad izheendo, tenal David tegin e-chapingan yabli kwen iskuszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tegin Jesús Pariseomalga chogalbal: —Tenal Pab Tummad unnila tulemal-pentagal ulukued-ibe-igal mezhis. Imi Pab Tummad igal-maidga pul tule-tak. Al an-chapingan kwen iskuszhulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tenal an-Te-Tule-Chunna, ulukued-ibe-e-ibedga maimo. Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tegin te ibagwengin, Jesús Judio-ormaked-negzhe tognoni. Tenal teun tule-walgwen-chunkal-tinkualed chimo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tegin tule-istar-Jesús-takmalad pukwamalmo. Tenal tulemal-istar-Jesús-takmalad igal-aminanimalan Jesúsgin chogmalgal Jesús noal-kudii. Al we tulemal Jesús-takpukmal, pule Jesúsde ulukued-ibegin tule-nudako-dewa o chul-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tenal Jesús tule-chunkal-tinkualedzhe kote chogal: —Kwisgu, tag neg-abaladzhe. Tegin tule-chunkal-tinkualed neg-abaladzhe kwisgunonigu, ");
INSERT INTO kvnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús tulemalzhe ekichial: —Imi antin peido, pemal anka chog. ¿Imi ulukued-ibegin, ib-nued immal-nued imagal o immal-iskana imagal? ¿Tule-nudakoed o meke tule-purkoed? Anka chogdo. Tenal tule-itobukmalad Jesús kwen abinchuszhulmal, ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tegin Jesús ulubgin sae-itogedgin tule-amigwisgual. Tegin Jesús ulubgin pukib-itononibal tulemal tule-yeed-kwen-pilalzhulmal. Tenal Jesús tule-yeedga chogal: —¡Chunkal akto! Tegin tule chunkal aktodgu, ilgwen nugus. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tenal Pariseomal ormaked-neg-akar aknismalgu, ilgwen Herode-e-chapinganzhe nadmal, tegin Herode-e-chapinganbak aga igal-amialmal, emalde igi nabir Jesús-mesmalo-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tegin Jesús aga e-chapinganbak mata-kakpal wakidmal. Tenal tulemal-Galileaginmalad-ichejul Jesús-cholbal nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tenal tulemal itosmalgu Jesús Galilea-mata-kakpal immal-taktijulid-imadii, Judea-tolgan, Jerusalénginmalad, Idumea-tolgan, Jordán-tiwalbalmalad, Tirozhikmalad, tegin Sidónzhikmalad, pél Jesúszhe nonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Imi teun takalgu, Jesús ichejul tulemal-nudadii-choggu, al tule-yemalad-ichejul Jesúszhe nonimal. Tenal teun tule-yemalad aga palmananimal Jesúszhe achemalgal, Jesús e-nudagal. Al Jesús iktual aga e-chapinganga chogzha: —Anka pe iktual kuakwa ul nazhiko, tulemal pela-pela arpak ankin yolegalmalal, an ulgin nakwegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tenal niamal-tulegin-mamimalad Jesús-takalil, pinnajul kolmakaldamal, tegin Jesúsga chimtialdamal, tegin Jesúsga chogaldamalbal: —Imi pedin, pe Pab-Tummad-Machi-chunnad. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tenal Jesús niamal-tulegin-mamimaladga chogalda: —Pe melle tulemal-wagin an-nug chogo, antin toa-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tegin te ibagwengin Jesús yalzhe nad. Tegin Jesús yal omosgu, tule-chulesmaladzhebi kocha eje taggal. Tegin tulemal Jesúszhe nonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tenal Jesús walambe-kakabog tule-chus ebak nanegal, tegin tar-palmigal Pab-Tummad-kakapurwa palchoggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tenal Jesús we tulemalga igal-ukchabal tulegin-niamal-mamimalad-onigal. (Tenal tule-walambe-kakabogwad Jesús tar-nugzhasmal, Jesús-nuggin-palmilegalmalad.) ");
INSERT INTO kvnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tenal tule-walambe-kakabogwad nug-nemal: Simón, (tenal Jesús tar-nugzhabal Pedro;) ");
INSERT INTO kvnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tegin Zebedeo-machi-Jacobo, tegin e-urpa-Juan. Tenal we machimal-walbogiddin Jesús tar-nugzhasbal, Boanerges. Boanergesdin chogle, iche-unni-urwed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tegin Andrés, Felipe, Bartolomé, Mateo, Tomás, tegin Alfeo-machi-Jacobo, tegin Tadeo, tegin Romano-tule-onobied-Simón, ");
INSERT INTO kvnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tegin Judas-Iscariote. Tenal we Judas-Iscariotedin manibal-Jesúsgin-akpitchad. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tegin Jesús aga e-chapinganbak negzhe tognonimalgu, tulemal-ichejul ampagunonimalmo. Al Jesús aga e-chapinganbak tule-pentanaidbal mas-kunkal igal pel kwen nikchul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tenal Jesús-e-kwenamalad wisgusmalgu, Jesús mas-kunkal igal-pel-nikchul, aga emal-emal chogalmal: —Imi antin, an itodo, Jesús wis koeles. Al anmal Jesús-chuneenabmal melle tulemalgin yolegal. Tegin Jesús-e-kwenamalad almalzhun, Jesús-amigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tenal Moisés-igalgin-tulemal-oturdamalad Jerusalén-akar Jesús-maidzhe nonimalgu, chogalmal: —Imi we Jesús nia-Beelzebú-nika. Al Jesús nia-sagla-nuggin tule-akar nia-oni. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tegin Jesús itosgu tulemal egin chunmananimal, Jesús tulemal-egin-chunmananimaladzhe kocha. Tegin Jesús tulemalga chogal: —Imi pemal noal chunmananimalma. ¿Nia-saglade igi aga e-chapingan-onineé? Chulá. Tegin Jesús purpal Judio-tummagan-nonimaladga chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“¿Imi meke-ibi-napa abal marral-chiil, we napa igi kunoniko pe ebinzhe? Neg pél iskunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Teginbal, ¿imi tule neg-yagin aga emal-emal imakalmalal, neg igi kunoniko pe ebinzhe? Tulemal aga pél onidmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“Imi nia-sagla-Satanás aga e-chapingan-onidel aga abal istar kunonimalo. Tenal nia-sagla aga e-chapingan-onielen, Satanás-neg-takmaid kwen unniguojulin ukin neg-takegal, e-neg-takmaid iskudoen.” ");
INSERT INTO kvnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tegin Jesús purpal chogalbal: “Imi tule-kal-ibed neggin mail, ¿pe yogasal e-neggin togo, pe ebinzhe immal aturzhegal? Chulá, keg kue. Tenal pe tule-kal-ibed-edineenabgwel, kep pe nabir we tulebi immal aturzhao. Al an-niagin-nakwijadbal an unni tulegin nia-onigal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tegin Jesús chogalbal: “Imi an chunchunnad pemalga chogdo: imi Pab Tummad tulega pel-kwapa-iskued nabir eli, tegin tule-atajulidgin Pab-Tummadgin-chunmaked ampa nabir elilebal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Tenal tule atajulidgin Pab Purpa Nuedgin chunmakel, Pab Tummad tulega we iskued kwen pal eliojul-kuo, ilgwen-nadgu peio.” ");
INSERT INTO kvnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","¿Ibiga Jesús Pab-Purpa-Nuedgin-walmakedgin weob chogzha pe ebinzhe? Nabir. Imi tulemal-Jerusalén-akar-nonimalad Jesúsgin chogzhamal: “Jesúsde nia-nika.” Al Jesús weob chogzhagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Imi teun Jesús Pab-igalgin tulemal-oturdanaidgin, tulemal-íchejul Jesús-nabal pukwamalmo. Tenal teun Jesús-e-nan, tegin e-urpamal Jesús-taknonimal. Tenal Jesús-e-kwenamalad magarbal pukwa-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tegin Jesús-e-kwenamalad tulemalbal Jesúszhe kaka palmis emalde magarbal Jesús-abintabukmal. Tegin tulemal Jesúsga chognatapmal: —Pe-nan tegin pe-urpamal magarbal pe-abintabukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tegin Jesús tulemalga chogal: —¿Teobí? ¿Toa-ade an-nan, an-urpamal-chunchunnad? ");
INSERT INTO kvnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tegin Jesús tulemal-e-waglik-tunnul-pukmaladga chogalbal: —Imi we tulemal-pukmaladdin an-nan tegin an-urpamaldo. ");
INSERT INTO kvnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tenal meke-ibi-tule an-Pab-nikpa-maid-choged-pallí immal imakel, we tulemal chunchunnad an-nan, an-urpamal, tegin an-punmal. Pitomalgu. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Imi te ibagwenginbal, Jesús mata-kakpal Pab-igalgin tulemal-oturda-nadbal. Tenal teun tulemal-íchejul Jesúszhe irmanonigu, Jesús ulgin nakwis Pab-igalgin tulemal-oturdagal. Tenal tulemal mata-kakagin Jesús-itojii-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tenal Jesús ulgin-akar choggwenzhul purpal tulemal-oturdanaigualzhun. Tenal Jesús tulemal-oturdanaidgin, tule-e-itobukmaladga purpal chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Imi pe nue an-itomalo. Imi te ibagwengin tule-walgwen nad mie-mie immal-kwa imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tenal tule immal-kwa minaidgin, immal-kwa kwen igal-nanemaladgin apatis. Tenal chikwimal we immal-kwa manonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Tenal immal-kwa kwen akwapir-ulak-naidgin apatis. Tenal immal-kwa akwapir nap-ulpal-naidbal, pulzhul nis. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tenal tad pirkin kanonigu immal-kwa mali-nue-napkin-akachulidbal ilgwen tinkus. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Tenal immal-kwa kwen iko-kwa-naidgin apatis. Tenal immal-kwa nisgu, iko-kwabak mes nis. Tenal immal-kwa tunkusgu, ikodin immal-kwa-nued-nijad izhos, al keg chanmagus. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Tenal immal-kwa kwen nap-nuedgin apatis. Tenal immal-kwa nued nis, tegin yer chanmasbal: kal-kwengin tulagwen-kakaambe chanmas, tegin piddin tulapá chanmas, tegin pidbal tulaatal chanmasmo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tegin Jesús tule-itobukmaladga chogalbal: —Imi an-chogzhad pe nuekwá itomalo. Tegin tulemal Jesús-akar nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tegin tulemal-naded-cholbal Jesús walgwen pesgu, e-chapingan-walambe-kakabogwad tegin e-chapingan-pimalad-pukmalad Jesúszhe ekichialmal: —¿Imis pe purpal chunmajadde, ibi chogle-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tegin Jesús aga e-chapinganga chogal: —Nabirdo. Tenal Pab Tummad mag itogal pemal-imas, e-neg-takmaid igi nai. Tenal tule-anmalzhik-chulmaladdin wichulmal Pab-neg-takmaid igi nai. Tenal we tulemalga pinche purpalbi choglegal-ta. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","¿Ibiga an purpalbi tulemal-oturda? Nabir. Imi akpene Pab-kaka-palchoged we tulemalgin chogzhado: Tenal we tulemal immal takoen, tenal we tulemal yabli aku takmalo; tegin we tulemal itogoen, tenal we tulemal yabli aku itomalo. Imi we tulemal mag itomalalen, kannan Pab Tummadzhe tagoen, tegin Pabdin we tulemalga iskued elioen. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tegin Jesús aga e-chapinganga chogalbal: “¿Imis an pemalga purpal chunmajadde, pemal ampa aku-itomalmodé? ¿Imi an pemalga purpal chunmakalbalil, tede pemalde igi pél mag an-itonejun? ");
INSERT INTO kvnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nabir. Tegil an pemalga chognejun: imi tule-mie-mie-immal-kwa-imaked, tule Pab-Tummad-kaka-nuegangin chunmakedyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Tenal immal-kwa igalbal apatijaddin chogle: tulemal Pab-kaka-nuegan itojal, nia-sagla-Satanás we tulegin Pab-kaka chunoniko; tegin we tule ilgwen Pab-kakapurwa igeo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Tenal immal-kwa akwapir nap-ulpal naidgin apatijaddin chogle: tulemal Pab-kaka-nuegan itojal, weligwal abingao. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tenal we tule Pabgin nuekwa akenaichulidbal chapi-nue-mali-nikchulidyob kunoniko-choggu, al tule-Pab-kaka-nuegan-abingejadga poni noalil, o tulemal Pabbal-naidbal istar we tule-takalmalal, ilgwen Pab-igeodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Tenal immal-kwa iko-nioedgin apatijaddin chogle: tulemal Pab-kaka-nuegan itojal, ");
INSERT INTO kvnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","weligwal Pab-kaka abingao. Tenal tule peyedzhe-immal-peigujiid, we tulegin nakwidago, tenal we tule ichejul mani-nikadbal, aga tukin yardanoniko Pab-igegal. Tenal iti-napkined-pinzheed we tulegin nakwis-choggu pul Pabbak nanegal, al we tule immal-keg-chanmakedyob kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Tenal immal-kwa-nap-nuedgin-apatijaddin chogle: tulemal Pab-kaka-nuegan itosmalal, yer Pab-kaka abingas. Tenal we tulemal Pab-chogzhadbal immal-nuegan imanoniko, tule-kwen iche immal-nuegan imanoniko, immal-kwa-kalgwengin tulagwen-kakaambe chanmajadyob, tegin tule-kwen abal immal-nuegan imanoniko immal-kwa-kalgwengin tulapá chanmajadyob, tegin tule-kwen ichejul immal-nuegan imanoniko immal-kwa-kalgwengin tulaatal chanmajadyobmo. “Imi an immal-kwagin chunmajad, weob chogledo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tegin Jesús aga e-chapinganga chogalbal: —¿Imi kallende, ibiga nabir-wede? ¿Mete-yabal chigal o ulu-yabal chigal? Chulá. Tenal kallen, kallen-chimaladgin chienab neg-otalogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tenal immal-otukal-maid keg-chulgu wisgulenoniko, tegin immal-otukal-kujad keg-chulgu mag taklenoniko. Imi an-pe-oturdajiid, ampa teopímo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Imi an-chogzhad pe nuekwá itomalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tegin Jesús chogalbal: “Imi pe nuekwa pinzheenab, pe igi Pab-Tummad-ito-dewa. Imi ibi-wilub pe ebúdin, teuni pega immal uklenonimogo, tenal wilub okpinalebaa. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Imi pe yer Pab-itogel, Pabdin pul yer e-wisgugal, pe-imako. Tenal pe iché Pab-itogel, Pabdin, iché e-wisgugal pe-imamogo, tenal pe kujal yabli Pab-wijiid igeodo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tegin Jesús chogalbal: “Imi Pab-neg-takmaiddin tule-walgwen napkin immal-kwa mijadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tenal tule immal-kwa misgu, mutik-ibgin meke atajii, meke kabmai, tenal we immal-kwa yabli nimai, tegin tunkumai. Tenal tule-immal-kwa-tigzhad wichul, igi nis. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“Tenal naptin a-ito immal-kwa-oni, kepegin ninoniko, tegin ka akninoniko, tegin turpamanoniko, tegin chanmanonijunno. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tenal e-chan kolegalil, tegin e-weied-wilub omojal, we tule immal-kwa-weimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tegin Jesús chogalbal: “Imi Pab-neg-takmaid, igi an pul pemalga chogel nabir wichul. Tenal an wichul ibi-yobzhal, an pega chogo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Nabir. Imi kepegin, Pab-neg-takmaid, mostaza-kwaun. Tenal mostaza-kwa iti-napkined egmal-immal-kwaga pul purwí. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tenal mostaza-kwa tiglejal, immal-kwa-pirka-il-ilbal-tiglemalad-egmalga pul tummad nao, chapiyob kunoniko. Tegin mostaza-e-aangan purwijul nao-choggu, al chikwimal e-aanganbal ampagunonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tenal Jesús kusgu purpal chunmakedgin tulemal-oturda, tulemal mag itogedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tenal Jesús tulemal-oturdakalil, kusgu purpal chunmakalda, pakal-pud kwen chunmajul. Tenal Jesús aga e-chapinganbak pis nadel, e-chapinganga pakal-pud-pud pél immal chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tegin tad-arkwatku, ampa te chedogin, Jesús Pab-igalgin pél tulemal-oturdasgu, aga e-chapinganga chogal: —Nemal mata-opakal. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tegin e-chapingan aka ulgin nai, Jesús-chesmal. Tenal tulemal-Jesús-itobukmaladdin pesmal. Tenal tule-pimalad ul-pimaladgin Jesúsbak mes nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tegin purwa arpak sapejul kolnonigu, mata arwial. Al ti ul-azhubal pela-pela milegalgu, ul togdanigus. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tenal Jesús ul-cholbal, immal-tutugin chagla-aktocha kabmai. Tegin e-chapingan Jesús-otanonimal chogalmal: —Tule-oturdaked, anmal-ul togdani. ¿Pegadin iwen-akalzhul anmal ogangumalo? ");
INSERT INTO kvnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tegin Jesús atasgu, purwaga tegin mata-arwedga chogal: —¡Pe wis pogiguma! Tegidgin purwa ilgwen poki nad, tegin mata ilgwen chiale-pesmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tegin Jesús aga e-chapinganga chogal: —¿Ibiga pe twagdar tobermal-wede? ¿Ibiga pe Pab-penmal-wede? Pemal weob kwen kued-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tenal Jesús-e-chapingan peyedzhe kwakialmal. Tegin Jesús-e-chapingan aga emal-emal chunmakalmal: —¿Ibi-tule-wede? Imi purwa tegin mataje-pakal we tule-choged-pallí ibzhe. ¿Tegil we Jesús purwa-ibeddé? ");
INSERT INTO kvnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tenal Jesús aga e-chapinganbak yabli mata-opakal opasmal, neg-kwebur-Gerasa-tikalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tegin Jesús ul-akar aktesgu, tule-nia-nikad panna uan-akar Jesús-takcha. Tegin tule-nia-nikad Jesúszhe al. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tenal we tuledin kusgu uanbal megda tegin tulemal kwen unniguszhulmal we tule-edingal ezha-tubgin-pakal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tenal tulemal melugus ezha-tubgin e-mali, e-chakwa edinmalan, tenal tule-nia-nikad yabli ezha-tub idiris. Tenal tule-pid pal nikchul, we tulegin nakwegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tenal tule-nia-nikad mutik-ibgin uanbal tegin yalaganbal kolmakalda. Tegin we tule aga tukin akwagin aga sakialdabal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tegin tule-nia-nikad Jesúszhe abarmanoni tegin Jesús-abir chimtinoni. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tegin tule-nia-nikad pinnajul Jesúsga chogal: —¿Ibiga pe ankin yoledani-wede? Jesús, pedin Pab-Pul-Tummad-e-Machi. Imi an pei pe Pab-wagin napírra anka chogo: pedin, pe chabzhul an-imakojulye. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Imi teun Jesús pato niaga chogzhado: “Pedin we tule-akar noenab.” ");
INSERT INTO kvnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tenal Jesús niaje ekichial: —¿Igi pe nugdé? Tegin nia Jesúsga chogal: —Antin nug: “Ichejulid.” Tenal anmal-niamal íchejul tulegin pukwadbal weob nugdo. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tegin nia kannan-kannan Jesúszhe wilenaigual, melle we neg-akar emal-palmigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Imi teun-takalgu chinmal-íchejul yal-abal mas mabukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tegin niamal Jesúszhe wilegalmal chogalmal: —Pe chinzhe anmal-wis-palmioma, anmal chingin ukpogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tegin Jesús niaga igal-ukchajun chingin ukpogal. Tegin niamal tulegin-maid-akar nodgu, ilgwen chingin ukpotapmalzhun. Tenal chin-milibo-pukwad arpak koelegalmalgu, ilgwen pulal turmadmal. Tegin chinmal yal-urchikal-kwichidgin mataje ilgwen pél apatismal. Tegin chinmal pél tigin ogangusmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Al tulemal-chin-takpukmalad abarmadmal, igalbal-tule-mamimaladga tegin tule-neg-kweburginmaladga choge-nad. Tenal tulemal wisgusmalgu tule-nia-nika-nad nugus tegin chinmal ogangusmal, Jesús-chiidzhe almal takegal igi kus. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tegin tulemal Jesúszhe nonimalgu, taknoni, tule-nia-nika-nad Jesús-nabal mol-yowi nued chii, we tule pato koelegal-chul. Al tulemal Jesúsgin-kwakialmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tegin tulemal-takchamalad, tule-nonimaladga pél palchogzhajun, immal igi kujad; tule-nia-nika-nad igi nugus, tegin chinmalgin igi kusbalid. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tegin tulemal Jesúszhe wilegalmal Jesús kannan emal-neg-akar negal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tegin Jesús ulgin nakwisgu kannan negal, tule-nia-nika-nad Jesúszhe wilenaigualmo Jesúsbak mes negal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tenal Jesús tule-nugujadga chogal: —Imi pedin keg anpak neel, tenal pe kannan aga negzhe neenab, pe-kwenamaladga pél pe palchoggal, Pab igi pe-nudas, tegin Pab igi wilejakwa pe-taknonibal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tegin tule-nugujad Decápoliszhe ilgwen nadzhun. Tegin tule-nugujad Decápoliszhe omosgu, tulemalga pél palchogdi-kual, Jesús e-nudas. Al tulemal-neg-kweburginmalad weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tegin Jesús mata-opakal-akar ulgin nonigu, mata-kakagin pes, tenal tulemal-íchejul Jesúszhe nonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tegin tule-walgwen Jesús-chiidzhe nonigu, Jesús-abir chimtinoni. Tenal we tuledin nug Jairo. Tenal we Jairodin Judio-ormaked-neg-e-tummad-walgwen. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tenal Jairo Jesúszhe wilegal chogal: —An-chiskwa iche-napi purkwedani-mai. Al an pei, pe anpak nao, chunkalgin an-chiskwa-ebugoedgin an-chiskwa-nudagal, melle purkwegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tegin Jesús tarbak ilgwen nadzhun. Tenal tulemal-íchejul Jesúsbak pulal-pulal nadmalmo, Jesúsgin pél yolenanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Imi teun tulemal-irmamamimalad-abalgin, ome-walgwen natapmo. Tenal we omedin pirkaambe-kakabogus, e-purpa-takedbak a-imadii. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tenal we ome pinche ina-tulganzhe nunmaked abingedi-kus, tenal we ome pinche pél aga mani misbal, tenal yabli kwen nuguszhul-kus. Tenal we omega pul-kigma poni pulgu-natap. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tegin ome-yeed itosgu tulemal-Jesúsgin-chunma, tulemal-impabal Jesúszhe noni. Tenal ome aga tukin pinzhas: “Imi an Jesús-mol-tuku wis ebujal, antin nuguo.” Tegin ome yankalbal-akar Jesús-mol-tuku ebuszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tegidgin omega e-poni ilgwen akus-nad. Tegin ome aga mag itos ede nugus. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tegidgin Jesús mag itosmo, ede e-kannalegedbal tule-walgwen-nudas. Tegin Jesús kannan chorzhik akpiridgu, tulemalzhe ekichial: —¿Toa an-mol-tuku ebusdé? ");
INSERT INTO kvnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tegin e-chapingan Jesúsga chogalmal: —¿Igi pe wisguo, toa-tule pe-mol-tuku ebus? ¿Pe takchulzhí, tulemal-íchejul pegin walmananimal? ");
INSERT INTO kvnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tenal Jesús yabli amigwisgual toa-tule e-mol-tuku ebus. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tenal ome mag itos, ede nugus. Al ome kwakijadbal, tutumakal Jesús-abir chimtinoni. Tegin ome Jesúsga pél palchogalzhun ede igi kudiid. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tegin Jesús omega chogalzhun: —Puna, pe ulubgin ankin penzhul-kunonikidbal pe nugus. Imidin pe akalzhul negzhe nao; pe poni ilgwen pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tegin Jesús ampa ome-nugujadbak chunma-kwichidgin, tulemal Jairo-neg-akar nonimal. Tegin tule-nonimalad Jairoga chogalmal: —Jairo, pe-chiskwa pato purkwis. Pe melle Tule-oturdakedzhe pal wilego, pebak negzhe negal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tenal Jesús tule-Jairoga-chognonikid itosgu, Jairoga chogal: —Pe melle akal-itogo, unnila ankinbi pe ibzhao. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tegin Jesús chogalbal: —An peichul tule-pimalad anmalbak nemo. An pei, tule-anpak-nemaloed unnila Pedro, Jacobo, tegin e-urpa-Juan, amal-naoed-walapá. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tegin Jesús Jairo-negzhe nonimalgu, oimabuk tulemal-taknonimal, tenal tulemal kolmakal-kolmakal ponanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tegin Jesús neg-yabal tognonigu, tule-ponanimaladga chogal: —¿Ibiga pe ponanimal, pe oimananimal-wede? We puna kwen purkwiszhul, pinche kabmai. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tenal tulemal Jesúsga allialmal chogalmal: —Pinche pe chunmama. Tegin Jesús magarbal pel-kwapa tulemal-onisgu, e-pakamalad-walapágwadbak, tegin puna-e-pab, e-nan, puna-maidzhe togzhamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tegin Jesús chunkalbal puna-kasgu, e-kakabal punaga chogal: —“Talita, cum.” Wedin chogledo: “Puna, an pega chog; kwisgu.” ");
INSERT INTO kvnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tegidgin puna kwisgudgu, ilgwen nanal. Tenal puna pirkaambe-kakabog nika. Tenal tule-takpukmalad weob pakal pesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tegin Jesús aga e-chapingan-walapágwadga tegin puna-nanganga chogal: —Pe melle tule-pimaladga pe palchogo imis pél immal kujad. Tegin pe masgin puna-okunno. Tegin Jesús nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tegin Jesús Capernaum-akar nad, aga e-tunkujad-neg-kweburzhe, Nazaretche. Tenal e-chapingan Jesúsbak mes nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tegin Jesús Nazaretche omosmalgu ulukued-ibegin Judio-ormaked-neggin Pab-igalbal tulemal-oturdakal. Tenal Jesús-e-chunmakedbal tule-íchejul-Jesús-itobukmalad weob pakal pesmal. Al tulemal-Jesús-itobukmalad aga emal-emal chunmakalmal chogalmal: —¿Pia we tulede turdas-wede, weob chunmakeddé? ¿Ibiga nabir pinzheed-nika chunma-wede? ¿Tegin pia kannaleged onosbal-wede, immal-taktijulid imagal? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿We tulede, ulu-chobedzhulzhí? ¿E-nande Maríajulzhí? ¿Tegin e-urpamalde Santiago, José, Judas, Simónzhulzhí? ¿Tegin e-punmal anmalbak wegin pukwamalmojulzhí? ¿Tede toa Jesús-itogo, a chunmanaiddé? Anmal itoged saté. Tegin tule-Nazaretkinmalad istar Jesús-takalmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tegin Jesús tulemal-istar-e-takchamaladga chogal: —Imi tulemal chogmal: ‘tulemal-neg-kwebur-pimaladgin tule-tummadyob Pab-kaka-palchogmalad-takmal. Tenal tulemal-e-neg-kweburginmalad tegin tule-e-neg-yaginmalad tegin e-kwenamaladdin tule-tummadyob Pab-kaka-palchogmalad-kwen-takchulmal.’ Al pemal tule-tummadyob an-kwen-takchulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tenal tulemal-Jesúsgin-kwen-ibzhejulidbal Jesús Nazaretkin immal-taktijulid kwen imaszhul-kus, pinche unnila chunkalgin-ebujadbal iche-iche tule-yemalad-wis-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tenal tulemal-Nazaretkinmalad-pel-kwablejal Jesúsgin pengusmal. Al Jesús weob pakal pes. Tegin Jesús neg-kwebur-purwiganagin pipirmadi-kual, tegin Pab-igalbal tulemal-oturdadi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Imi teun Jesús aga e-chapingan-walambe-kakabogwadzhe kocha. Tegin Jesús wal-walbogin, e-chapingan-palmijogal. Tenal Jesús aga e-chapinganga igal-ukcha tulegin-nia-mamikid-onigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tegin Jesús aga e-chapinganga chogal: —Imi pe nadmalal, pe melle immalmal chedo, kabubi unnila pe chedmalo. Pe melle mas-kunned chedo, pe melle muchila chedo, pe melle mani chedo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tenal pe kutar-yowigwadbi pe nemalo, tegin pe melle mol-ogwaged chedbalo, chunkal-kwabi pe nemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tegin Jesús aga e-chapinganga chogalbal: —Pe neg-kwebur omojal, tule-pe-odojad-neggin pe togzhal, we neggin ilgwen pe peio pe naoedzhe; melle neg ogwa-ogwa nanemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tenal meke ibi-neg-kweburgin, pe-Pab-Tummad-kakapurwa-chogdanikidbal tulemal yapa pe-abingeel, yapa pe-itogel, ilgwen pe we neg-akar pe nao. Tenal pe kutargin-pur-naniid opat-opat imako oyogal, Pab-kakapurwa pato we tulemalzhe arpi, tenal we tulemal Pab-kakapurwa kwen abingaszhulmal. Tenal tegi-kuo, Pab-kakapurwa pal kwen nonikojul. (Imi an chunchunnad pemalga chogdo: imi tule-pe-kwen-abingaszhulmaladga, Pab tulemalga igal-itogalil, we tulemal Sodoma tegin Gomorra-tolganga, pul-pule sapejul oturdalenonimalo.) ");
INSERT INTO kvnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tegin Jesús-e-chapingan nadmalgu, tulemalga Pab-kaka-nuegan palchogdi-kualmalzhun: “Imi pedin aga ulubgin iskuedgin pukib-itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tegin Jesús-e-chapingan ichejul tulegin-nia-mamikid-onis, tegin tule-nonogin-kwallu-eyojadgin ichejul tule-yemalad-nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tegin tulemal-pel-kwapa Jesúsgin chunmaked-kibi-kualmalgu, Errey-Herode kep Jesús-wisgualmo. Imi teun tulemal chogalmal: —Imi we Jesús, Juan-Bautista-kannan-tullejad, ¿al nabir immal-taktijulid imayé? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tegin tule-pimalad-wal-walgwen chogmalmo: —Imi we Jesús, akpenegwad-Pab-kaka-palchoged-Elías. Tegin tule-pimalad chogmalmo: —Jesúsde Pab-kaka-palchoged-akpene-megwijadyobid. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tegin Herode Jesús-wisgusgu, chogal: —Imi we Jesús, ¿Juan Bautista tukal-idiral an tar-mechadzhulzhí? ¿Imi we tule kannan tullesbaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","¿Ibiga Herode teob chogal pe ebinzhe? Nabir. Imi teun Herode e-urpa-Felipegin ome-Herodías-idiris. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Al Juan Herodega pakal-pud chogzhagusdo: —Imi pedin noal kudii. ¿Ibiga pe aga urpa-Felipegin ome-Herodías-idiris-wede? Imi anmalga igal weob kwen maichul. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Al Herodías istar Juan-taknoni, tegin Juan-mesbi-kualzhun. Tenal Herode Juan-kas, tegin oturdaleged-neggin Juan-odos, tegin ezha-tubgin Juan-etisbal. Al Herodías keg kugus Juan-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tenal Herode Juan-tob. Tenal Herode wiis Juandega, tule-napírragwad, tule-ilgwenad. Al Herode Juan-pentas melle Herodías Juan-mesgal. Tenal Herode Juan-itosgu ede istar-tii, Herode ulubgin pokidikid kwen nikchul-pes. Tenal Herode yabli yer Juan-itos. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Imi teun Herodías ampa igal-aminai, igi nabir Juan-mesgal. Tegin Herodíasga ibe noni. Imi teun Herode pel-kwapa-e-tummaganzhe kocha, e-mimmilejad-ibegin mas kunmalgal. Tegin tule-tummagan-Herode-pentamalad, chulub-tummagan tegin Galilea-napkin-mamimalad-e-tummagan mas kunnonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tegin tule-tummagan mas-kunpukwadgin, Herodías-e-chiskwa tognonigu, Herodega kwilal. Tenal Herode tegin e-tummagan yer puna-kwiled takchamal. Al Herode punaga chogzha: —Imi meke-ibi-immalmal pe peiel, pe anche ekiso, an pega uko. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tegin Herode kannan punaga chogzhabal: —Imi an Pab-wagin napírra pega chogdo: meke-ibi-immalmal pe anche ekichial, antin pega uko; imi immalmal-an-nikad, an chunna abalzhal pega uko. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tegin puna nodgu, aga e-nanzhe nad. Tegin puna aga e-nanga chogal: —¿An ibi nabir Herodeje ekiso-diá? Tegin e-nan aga punaga chogal: —Pe Juan-Bautista-e-nono pe ekisodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tegin puna kannan ilgwen Herode-chiidzhe nonigu, Herodega chognoni: —Antin imis-imis Juan-Bautista-nono pei, pateagin. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tenal Herode puna-ega-chognonikid itosgu, peyedzhe pukib pakal pes. Tenal Herode Pab-wagin, tegin tule-tummagan-wagin punaga pato kaka-ukchadbal, al Herode punaga keg pal chogel, “Chul”. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tegin Herode ilgwen Juan-oturdalemaidzhe chulub-tule-mejed-palmijogalgu, chulubga chogal: —Pe Juan-tukal idirijal, pateagin e-nono chedago. Tegin chulub nadgu, aka oturdalemaid-neg-yabal Juan-tukal chikcha. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tegin chulub pateagin Juan-nono cheal, tegin punaga Juan-nono ukcha, tegin punade ukin aga nanga ukchamo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tegin Juan-e-chapingan Juan-purkwis itosgu, e-mui aminonimal. Tegin e-chapingan uanzhe Juan-mui tigapmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tegin Juan Bautista purkwijad-cholbal, Jesús-e-chapingan-walambe-kakabogwad nonimalgu, Jesúsbak ormasmal. Tegin e-chapingan pel-kwapa Jesúsga chogzhamalzhun, pél emalga ib kujad, tegin emalde pél tulemal-oturdasbalid. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Imi teun tulemal ichejul nugumai, tegin tulemal-anal ukpomaibal. Al Jesús aga e-chapinganbak ulukued-igal kwen nikchulmal, tegin Jesúsmal nuekwa mas-kunned-igal pel nikchulmalbal. Tegin Jesús aga e-chapinganga chogal: —Anmalpí akne wis nemal ulukugal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tegin Jesús aga e-chapinganbak ulgin amalpí mata-kakpal nadmal, neg-tule-nikchulidbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tenal tulemal Jesús-takchamal, Jesúsde pia nad. Tegin tulemal igalbal abarmadmal. Tegin tulemal neg-kweburgangin abarma-nasmalgu, tulemal-neg-kweburginmalad mes nadmalmo. Tenal tulemal yabli Jesús-iktual-omosmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tegin Jesús omosgu, pato taknatapmal tulemal-ichejul edu pukwamal. Tenal Jesús tulemal-takchagu, pinzheal: “We tulemal, oveja-ibed-nikchulmaladyob kudimal.” Al Jesús wilejakwa tulemal-takalzhun. Tegin Jesús Pab-igalbal ichejul tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tegin tad-arkwandanigusgu, e-chapingan Jesúsga chognonimal: —Imi pe tak neg pato chedodani. Tegin pe wisbal, anmal neg-kweburgin pukchulmal; anmal neg-nikchulidbal pukwamal. ¿Imi tulemalde pia aga mas-kunned paknemal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tenal pedin tulemalga chogenab: ‘Pe neg-kweburzhe nemalo. Chulil, tule-nagnugin-mamimaladzhe, pe nao mas-kunned pakegal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tenal Jesús aga e-chapinganga chogal: —Tagoed. Tenal pemal we tulemalga mas-kunned wis ukenab. Tegin e-chapingan Jesúsga chogal: —¿Igiwá? ¿Anmalá? Imi anmal masgin we tulemal-okunkal, wedin mani-tummad. ¿Ibabigwa-arpaged-wilub pe ebinzhe? Wedin ni-walapábak-arpaged-wilub. ¿Imi weob karkegu anmal masgin tulemal-okunnodé? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tegin Jesús aga e-chapinganga chogal: —¿Pemal walbigwa madu wis nikamal-ade? Pe wis taknegweldo. Tegin Jesús-e-chapingan madu-nika takchagu, Jesúsga chognonimal: —Anmal madu-walatal, ua-ukabo wis nika. Tegin Jesús aga e-chapinganga chogal: —Tegil nueddo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tegin Jesús aga e-chapinganga chogal: —Imi pe tulemalga chogo: emalde kagan-arraragwadgin tunnul-tunnul ampaguenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tegin tulemal wala-tulaatalgin, tegin wala-tulabo-kakaambegin tunnul-tunnul ampagusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tegin Jesús walatal madu chus, tegin ukabo ua-chusbal. Tegin Jesús nikpa atadgu, Pab Tummadga tog-nuedi chogal. Tegidgin Jesús madu pipichis, tegin madu Jesúsga melgud. Tegin Jesús aga e-chapinganga ukcha, tulemalga mimigal. Tegin Jesús ua-ukabogid ampa madu-imajadyob imasbal, tegin ua Jesúsga melgudmo. Tegin Jesús-e-chapingan tulemalga ua-mimismalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tegin tulemal-pel-kwapa immeché mas kuchamalgu, ");
INSERT INTO kvnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jesús-e-chapingan mas-okpismalad wesmal. Tegin mas-kunned ampa karpa-kwaambe-kakabog okpis. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Imi teun tulemal-mas-kuchamalad, macherganbi miliatal. Tenal omegan, tegin purwigana kwen choglejul. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tegin tulemal-mas-kuchamalad-cholbal, Jesús aga e-chapinganga chogal: —Imi pemal akalzhul antu ulgin opakal nemalo, Betsaidaje. Tenal antin tulemal-wis-takkwelo. Tegin tulemal-naded-cholbal an pe-cholbal natapmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tegin Jesús tulemal-akar nadgu, yalzhe nad Pab Tummadzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tegin tad-arkwatku, Jesús-e-chapingan ulgin ampa mata-magadbal natapmal. Tenal Jesús ampa walkwénna yalgin pes. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tegin Jesús panna-akar aga e-chapingan-takcha, ulgin peyedzhe kamme minanimal. Tegin purwa peyedzhe abin kolmaidbal e-chapingan peyedzhe wilenanimal. Tegin wakurudzhik-kallin-namakedbal, Jesús aga e-chapingan-natapid-inik, ti-askin kannamanatapmo. Tenal Jesús aga e-chapingangin pakal-nao chognatapin. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tegin Jesús-e-chapingan ti-askin kannamadani Jesús-takalmalgu, pinzhealmal: “Wedin tule-purpa.” ");
INSERT INTO kvnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tenal Jesús-e-chapingan nued takchamalan wedin Jesús. Tenal Jesús-e-chapingan yabli Jesúsgin kwakismal. Al e-chapingan sapejul kolmasmal. Tegin Jesús yok e-chapinganzhe kote chogal: —Melle pe kwakiemalma, aga pe niga okannoma. ¿Pe takchulzhí an? ");
INSERT INTO kvnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tegin Jesús aga e-chapinganbak ulgin mes nakwiszhun. Tegidgin purwa kep pokigusmojun. Tenal Jesús-madu-omelojadbal Jesús-e-chapingan weob pakal peied-wilubzhulmalan. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tenal Jesús-e-chapingan nono-akpurrujadbal, ampa aku itomal Jesús ega madu melojad. Al Jesús-e-chapingan purwa-pokichajadbal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tegin Jesús mata opasgu, Genesaretche nonimal. Tegin Jesús-e-chapingan ul-esnas egwasmalgu, ");
INSERT INTO kvnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesús ul-akar aktes. Tegin tulemal mag takmal wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tegin tulemal Jesús-noni wisgusgu, negganbal abarmadmal, tule-yeed-amigal. Tegin tulemal Jesús-chiidzhe, kachigin tule-yemalad-cheinonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Al Jesús meke pia nadel, neg-kwebur-tummagangin, neg-kwebur-purwiganagin, tegin neg-kwa-kwagwen-chijiidgin-tulemal-ampagumaladgin, tulemal Jesúszhe tule-yeed-cheinonidamal. Tegin tulemal Jesúsgin wilenaigualdamal, Jesús-mol-tuku wis ebumalgal. Tegin Jesús tule-yemaladga chogalda: —Tegil pe akalzhul an-mol-tuku ebugode. Tegin tule-yemalad-Jesús-ebusmalad pél nugusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Imi te ibagwengin Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad-wal-walgwen Jerusalén-akar nonimal, Jesús-chiidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tegin Pariseomal Jesús-e-chapingan-algalmal. Tegin Pariseomal takalmal Jesús-e-chapingan mas kunchogalgu, chunkal-enukedgin inniki-inniki igal-maidbal kwen imaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Imi Pariseomal kusgu e-tadgan-igal-mezhijadyob chunkal-enukedgin nanedimal, tenal Judio-pimalad ampamo. Tenal Pariseomal nuekwa chunkal-enukchulmalal, mas kwen kunnojulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tenal Pariseomal neg-immal-ukleged-akar nonikil, obzhulil, mas kwen kunnojulmalbal. Tenal Pariseomal íchejul e-tadgan-igal-mamikidyob nanemal: muruk enukedgin, ti-chied enukedgin, mete enukedgin, (kan enukedgin,) Pab Tummad yer emal-takegal.) ");
INSERT INTO kvnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Al Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad Jesúszhe ekichialmal: —¿Ibiga pe-chapingan anmal-tadgan-igal-mezhijadyob chunkal-enukedgin inniki-inniki nanejulmaldé? Tenal pe-chapingan yabli chunkal-enukchulidgin mas kunmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tegin Jesús Pariseomalga chogal: —¡Aaaaaa! ¡Pemal pinche-askinbi-nued-nanemalad! Al Pab-kaka-palchoged-Isaías akpene pemalgin nabir chogzhado, tegin pemalgin nermasbal: Pabdin chog: We tulemal pinche askin chunmakedginbi an-otummodamal, tenal ulubgin ankin kwen pinzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Imi we tulemal Pabyob anche kolmalal, wedin ibga keg pel ku. Tenal tadgan-pinche-aga-igal-onosmaladgin tule-oturdananimal. Pitogua. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imi pemal Pab-kaka-chogzhad obanmamimal, tenal pemal tadgan-igal-mezhijadbal nanedimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tegin Jesús kannan chogalbal: “Pemal Pab-igal akalomamimal tadgan-igalgin toggal. ¿Ibiga teob an chog? ");
INSERT INTO kvnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Imi Moisés chogzhado: Imi pe aga pabgin, pe aga nangin, pe atagenabmal. Ex. 20:12; Dt. 5:16 “Tegin Moisés chogzhabal: Imi meke-ibi-tule aga e-pabga, o aga e-nanga kaka-iskana kochal, pe we tule-mejenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Tenal pemal-Pariseomal chogmal: ‘Imi tule aga e-pabga, aga e-nanga chogzhal: We immalmal-an-pe-pentakoenad, an Pab Tummadga pel-kwapa ukcha. Wedin anmal-kakagin chogle: Korban. Al an keg pe-pal-penta.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Tenal pemal-Pariseomal tulemal-oturdananimaldo tule keg we immalmalgin e-pabgan-pal-pentakel. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Al pemal-Pariseomal tadgan-igalgin-togzhadgin Pab-igal-mezhijad ochulosmal. Tenal Pab-Tummad-igal-pimalad-mezhijad, pemal ampa akalosmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tegin Jesús tule-yogsalmaladzhe kochagu, chogalbal: “Imi pemal nuekwa an-itomalo an igi chogneed. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Imi tule mas-kuchal, keg purpal tule-izho. Tenal tule istar chunmakel, wedin purpal tule-izho. ( ");
INSERT INTO kvnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Imi an-chogzhad pe nuekwá itomalo.)” ");
INSERT INTO kvnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tegin Jesús tulemal-ebesgu, neg-yabal ukposmal. Tegin e-chapingan Jesúszhe ekichialmal: —¿Imis pe tulemal-oturdajadde, ibi chogle-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tegin Jesús aga e-chapinganga chogal: —¡Paaa! ¿Ampa pe aku itomalmodé? ¿Pe wichulzhí, immal-kunned Pab Tummadbak tule-kwen-izhojul? ");
INSERT INTO kvnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Imi tule immal-kunned unnila sabalzhebi tog, tegin te-cholbal kannan pél milebalo, tenal tulega pinzheed-iskana kwen amijul. (Imi Jesús chogzhad chogle; meke-ibimala tulemal akalzhul kunno. Wedin Pab Tummadbak tule-kwen-izhojul.) ");
INSERT INTO kvnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tegin Jesús kannan chogalbal: —Tenal tule-istar-pinzheeddin, tule-ulub-akar tani; wedin tule-izho. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Imi immal-tule-izhogeddin machergan ome-pidbak yosgu-taed, tegin omegan machered-pidbak yosgu-taed, tegin machimal punamalbak yosgu-taed, tegin punamal machimalbak yosgu-taed. Tegin tule-pidbi immal aturzheed, tule-mejed, ");
INSERT INTO kvnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ome-impagin ome-pimaladgin yoleged, machered-impagin machered-pimaladgin yoleged, aku-aku immalmal peied, istar tulemalgin pinzheed, tule-yardaged, kalagwenzhul e-changin pinkejul nised, nobed, tulemalgin istar chunmaked, tummarba aga imaked, pinzheed-nikchul taed. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Imi we iskued-pel-kwapa, tule-ulub-akar tani. Wedin Pabbak tule-izho. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tegin Jesús tulemal-oturdajad-cholbal te-akar nad, neg-kwebur-Tirozhik tegin Sidónzhik. Tegin Jesús neggin togzhagu, aga e-chapinganga chogal: —Pe melle tule-pimaladga pe pal an-chogo, an wegin mai. Tenal tulemal yabli Jesús-wisgusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tegin ome-walgwen Jesús-wisgusgu, Jesús wegin mai, Jesús-abir chimtinoni. Imi teun takalgu, e-chiskwa nia-nika. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tenal we omedin Judio-tulejul; tule-pid, Sirofenicia-tol. Tenal we ome Jesúsgin wilenaigual, ega chiskwagin-nia-maid-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tenal Jesús omega chogal: —Imi pedin Judio-tulejul. Al an purpal pega chogdo: imi nuskan yo immelegeddu, pe nuskangin mas-kunned chujal, tegin pe tarbi achuga metel, wedin ib-nuedzhul. Tenal meke nuskan inzhel immedzhe mas kunmalgwelo. Tenal nuskan mas-kuchad-cholbal kep pe achuga mas-okpitchad metodo. Al an keg pe-penta. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tegin ome Jesúsga chogal: —Tummad, pe nabir chogendo, ¿tenal nuskan mesagin-mas-kunpukwadgin chan egwachal, achumal nabir kunnojulzhí? Al pe unnimodo, an-chiskwa-wis-pentagalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tegin Jesús omega chogal: —¿Teobí? Pedin napírra chogzhado. Tegil pe akalzhul naodo. Imi nia pato pe-chiskwa-akar nos. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tegin ome aga neg omosgu, pato taknatap e-chiskwadin kachigin akalzhul mai, nia pato punagin nos. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tegin Jesús Tiro-akar nadgu, Sidón-neg-kweburgin nas. Tegin Galilea-mata-kakpal omosgu, Provincia-Decápoliszhe notap. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tegin tulemal Jesúsga tule-ua-yalli-cheinonimal. Tenal we tule keg pel chunmabal. Tenal tulemal Jesúsgin wilenaigualmal ega machi-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tegin Jesús pidzhi tule-ua-yalli-ches; tegin chuchu-yabal ko yos. Tegin Jesús we tulegin kwi mis, tegin tule-kwabin-ebusbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tegin Jesús nikpa atadgu, chowi-pannos imas. Tegin Jesús e-kakabal tule-chuchu-yalliga chogal: —“Efata”. Wedin chogle: “Chuchu arkao.” ");
INSERT INTO kvnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tegidgin tule-ua-yalli ilgwen chuchu mag tule-ito-pes, tegin e-kwabin ilgwen nabir chunma-pesbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tegin Jesús tulemalga chogal: —Pe melle tule-pimaladga pe pal an-chogo, an tule-yeed-nudas. Tenal tulemal pul-kigma Jesús-chogdi-kualmal. Tenal Jesús tulemalga choged-ilbal melle e-chogo, tulemal pul-kigma Jesús-chogmamimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tegin tulemal Jesúsgin weob pakal pesmal, tegin Jesúsgin chogalmal: —Imi Jesús pél ib-nued imas; mag itogal tule-ua-yalli-imas, tegin tule-keg-chunmaked-ochunmasbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Imi teun takalgu, tulemal íchejul kannan Jesúszhe ampagunonimalbal. Imi teun tulemal mas-kunned pel nikchul kudimal. Tenal Jesús takchagu tulemal mas-kunchul kudimal, e-chapinganzhe kocha ka chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Imi antin wilejakwa we tulemal-tak. Tenal we tulemal ibapágus anmalbak pukwamo, mas-kunned kwen nikchulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tenal we tulemal-wal-walgwen tikajul-akar tanimal. Al anmal masgin-okuchajul e-negzhe palmismalal, we tulemal igalbal ukul metamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tegin e-chapingan Jesúsga chogal: —¿Anmal pia mas-kunned amio, unnigualedzhe tulemal-okunkal? Imi anmal neg-kweburgin pukchulmal, itigin tule-immal-uked kwen nikchul. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tegin Jesús aga e-chapinganzhe ekichial: —¿Pemal, walbigwa madu wis nikmal-ade? Tegin e-chapingan Jesúsga chogal: —Anmal walakugle madu wis nikmal. Tegin Jesús aga e-chapinganga chogal: —Tegil nabirdo. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tegin Jesús tulemalga chogal: —Pemal napkin ampagumalo mas kunmalgal. Tegin Jesús walakugle madu chusgu, Jesús Pab Tummadga tog-nuedi chogzha. Tegin Jesús purwi-purwi madu pipichisgu madu Jesúsga melgud. Tegin Jesús aga e-chapinganga madu ukcha tulemalga mimigal. Tegin e-chapingan pel-kwapa tulemalga madu mimiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tegin Jesús-e-chapingan ua-purwigana wis nikmalbal. Tegin e-chapingan Jesúsga ua-ukchamalgu, Jesús Pab Tummadga tog-nuedi chogzhabal, tegin ua Jesúsga melgudbal. Tegin Jesús aga e-chapinganga ua-ukchabal tulemalga mimigalbal. Tegin e-chapingan pél ua-mimismalbalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tegin tulemal-pel-kwapa immedzhe mas kuchamal. Tegin tulemal mas-kuchamalad-cholbal Jesús-e-chapingan karpa-kwakugle mas-okpitchad wesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Imi teun macherganbi milibake-kuchale mas kuchamal, tenal omegan, nuskan pel choglejul. Tegin tulemal-mas-kuchad-cholbal, Jesús tulemalga chogal: —Imidin pemal akalzhul negzhe nemalzhunno. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tegin tulemal nadgu, Jesús aga e-chapinganbak ulgin nadmalmo, Dalmanuta-neg-kwebur-tikalzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tegin Jesús Dalmanuta-neg-kwebur omosgu, Pariseomal Jesúsbak chunmanonimal, Jesús-wilub-takegal. Tegin Pariseomal Jesúsga chogalmal: —Imi pedin Pab Tummadzhe wis ekiso, anmal-wagin immal-taktijulid imagal, anmal wismalgal, Pab Tummad chunchunnad pe-palmialid o chul. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tegin Jesús Pariseomal-chogzhad itosgu, chowi-pannos. Tegin Jesús tule-pukmaladga chogal: —Imi antin pudar-itogus tule weob an-imaked. ¿Tenal pemal-imisgwamalad, igi itomal-wede, anche immal ekiseddé? Imi pemal anche immal-taktijulid ekisnaid pemalga kwen oyolegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tegin Jesús aga e-chapinganbak ilgwen ulgin nakwis, tegin mata-opakal nadmalzhun. Tenal Pariseomaldin aka pukwa-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tegin Jesús-e-chapingan ulgin-natapidgin madu amialmal. Tenal Jesús-e-chapingan aga madu igesmal chedagal, unnila walkwénna madu wis cheinatapmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tegin Jesús aga e-chapinganga chogal: —¡Wijira! Pariseomal-madu-inagin, tegin wijirbal Herode-madu-inaginmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tegin Jesús-e-chapingan aga emal-emal chunmakalmal: —¿Imi anmal-madu-cheinonijulidbal, al Jesús anmalga weob chogalyé? ");
INSERT INTO kvnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tegin Jesús chunmanani e-chapingan-itosgu, chogal: —¿Ibiga pemal madu-cheinonijulidgin pal chunmananimal-wede? ¿Pemal ampa aku itomaldé, pemal ampa mag takchulmaldé, akpene an igi immal imajad, tegin an igi madu omelos? ¿Pemal nono-akpurrusmalmodé? ");
INSERT INTO kvnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tenal pemal takmalan, tenal pemal yabli aku takmal, tenal pemal itomalan, tenal pemal yabli aku itomal. ¿Pemal pato igesmaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Akpene an madu-walatalgin miliatal-tule-okuchadgin, karpa-kwabigwa pemalga okpis-chogna? Tegin e-chapingan Jesúsga chogal: —Karpa-kwaambe-kakabogde. Tegin Jesús chogalbal: ");
INSERT INTO kvnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Tegin an madu-walakuglegin, milibake-tulemal-okuchagu, karpa-kwabigwa pemalga okpis-chogna? Tegin e-chapingan Jesúsga chogalbal: —Karpa-kwakuglede. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tegin Jesús aga e-chapinganga chogalzhun: —¿Pemal yabli aku itomaldé? Tenal e-chapingan Jesús-pal-kwen-abin-imaszhulmal. Tegin Jesús Betsaidaje omosmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tegin Jesús aga e-chapinganbak Betsaidaje omosgu, tulemal Jesúszhe tule-aku-ataged-cheinonimal. Tegin tulemal Jesúsgin wilenaigualmal tule-ebugedgin ega we tule-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tegin Jesús chunkalgin tule-aku-ataged-kasgu, neg-kwebur-tikalzhe tar-ches. Tegin Jesús tule-aku-ataged imiagin kwi imas, tegin chunkalgin tule-aku-ataged-ebusbal. Tegin Jesús tule-aku-atagedzhe ekichial: —¿Pe nabir immal wis tak? ");
INSERT INTO kvnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tegin tule-aku-ataged nuu Jesús-taktegu, Jesúsga chogal: —Tenal antin tule-wis-takendo, tenal chapimal pirpirmanaidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tegin Jesús kannan kogin tule-imia-ebusbalgu, tule-aku-ataged ilgwen nuguszhun, tule-imia-nueganyob pes. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tegin Jesús aga negzhe tule-nugujad-palmijogalgu, chogal: —Pe ilgwen negzhe nao. Pe melle neg-kweburgin pal togo tulemal melle pe-wisgumalgal pedin nugus. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tegin Jesús aga e-chapinganbak Cesarea-Filipobal nadmal, neg-kwebur-purwiganaje. Tegin Jesús igalbal-natapidgin, aga e-chapinganzhe ekichial: —¿Tulemal, igi ankin chogmal, ante toa-tule? ");
INSERT INTO kvnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tegin e-chapingan Jesúsga chogalmal: —Tule kwen chogmal, pede Juan Bautista; kwen chogmalbal, pede Elías; kwen choge, pede Pab-kaka-palchoged-pid. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tegin Jesús aga e-chapinganzhe ekichialmo: —¿Anná, pemalde igi ankin chogmalmode, ante toa-tule? Tegin Pedro Jesúsga chogalzhun: —Pedin Cristo-Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tegin Jesús aga e-chapinganga chogal: —Teobdo. Tenal pe melle tule-pimaladga pe palchogo, antin Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tegin Jesús aga e-chapinganga chogal: —An-Te-Tule-Chunna peyedzhe wilegenab. Tegin Judio-chelegan-tummagan tegin tule-irwal-Pabzhe-kolmalad-e-tummagan, tegin Moisés-igalgin-tulemal-oturdamalad an-kwen-abingaojulmalbal. Tegin tulemal an-mesmalo tenal Pab ibapágin kannan an-otulononibalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Imi teun Jesús aga pakal-pud chogzha ede purkweenab. Al Pedro pidzhi Jesúszhe kocha chogal: —¿Ibiga pe weob chogzha-wede? Pe melle weob chogzhagalan. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tegin Jesús akpiridgu, e-chapingan-pimalad-wagin Pedroga chogal: —Nia-Satanás, pe we-akar pe nema. Pedin igal-puledgin an-egwanbi-kual. Tenal pedin Pab-igalgin kwen pinzhejul, pe tule-igalgin pinzhenai. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tegin Jesús tule-pimaladzhe kochamo. Tegin Jesús aga e-chapinganga tegin tule-pimaladga chogal: —Meke-ibi-tule anpal naigubiel, aga tukingabi pal kwen pinzhejulinab. Tenal we tule kuakwa kudiinabbal anka purkwegal, tule-nakrusgin-aga-purkwe-natapidyob. Imi tule an-chogzhadyob naneel, kep an-chapinga kunoniko ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“¿Ibiga an teob chog? Imi meke-ibi-tule anpal-naidbal yapa purkwejogel, we tule yabli pelgunoniko. Tenal meke-ibi-tule anpal-naidbal, tegin Pab-kaka-nuegangin chunmakedbal, akalzhul purkwejogel, we tule kannan tullenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Imi tule iti-napkin pel-kwapa immalmal nikunonikilen, tenal Pab purpa-abonoged kwen nikchulil, ¿ibi-nued we tulega kunoniko pe ebinzhe? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Tenal tule ibi-immalmal-ukedgin unnio aga purpa abonogal melle sapejul oturdalegal? Chulá. Keg kue. Tenal immal kwen nikchul tule aga purpa abonogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Imi meke-ibi-tule, tule-iskued-nikmalad-wagin, tegin tule-Pab-ebesmalad-wagin, ankin chogzhal: ‘Ante wichí, we Jesúsde toa-tule,’ tegin an-chogzhadgin chogzhabalil: ‘An we kaka wichul,’ an-Te-Tule-Chunna nugu-taklegedgin, tegin an naga-kannalegedgin tegin Pab-Tummad-kannalegedgin tegin angelmal-kannalegedgin iti-napche an kannan tanikil, an we tulegin chogmogo: ‘An wichí wedin toa-tule.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tegin Jesús tulemalga chogalbal: —Imi an chunchunnad pemalga chogdo: imi pemal-itigin-pukmalad-wal-walgwen, yo pe purkweddu, pemal Pab-neg-takmaid-kannalegedgin-nonikoed takmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tegin te ibanerkwagin, Jesús yal-tummad-pirzhe, pidzhi walapá aga e-chapingan-ches; Pedro, Jacobo, Juan; tenal Jesúsgin pelugles walabake. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tegin Jesús aga e-chapingan-wagin, arpak akalgus. Tenal Jesús-e-moldin pi-pi-pip kanoni, ukur-walga pul chipú takle-pes. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tegidgin Jesús-e-chapingan pato takalmal, Elías tegin Moisés. Jesúsbak chunmananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tegin Pedro Jesúsga chogal: —Tule-oturdaked, anmal wegin nued pukwamal. Al anmal pemalga wegin kwapá obuneg chobnemal, pega kwagwen, Moisésga kwagwen, tegin Elíasga kwagwenmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Imi teun takalgu, Pedro peyedzhe-kwakijadbal aga mag itojul, ede ibigin chunmanai. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tegin po aktenonigu, Jesúsmal po-yabal pél ukposmal. Tegin po-yabal-akar tule-kakapurwa kolnoni chogal: —Imi wedin an-Machi-Pilaled. Al pemal nue an-Machi-itogenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tegidgin po miledgu, Jesús-e-chapingan Elías-Moisés-amialmal, pato taklejulmal, Jesúsbi walkwénna pato kwichi-takalmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tegin Jesús aga e-chapinganbak yal-pir-akar kannan aktealmalgu, Jesús aga e-chapingan-walapágwadga chogal: —Pe melle tule-pimaladga pe pal an-chogo, pe imis imial immal takchad. Tenal an-Te-Tule-Chunna purkwijad-akar kannan tullejal, kep pe tulemalga chogo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tegin Jesús-e-chapingan-walpágwad ulubgin immal-takchad chabosmal. Tenal tule-walpágwad aga emal-emal ekisaldamal: —¿Ibi chog-wede, ‘An kannan tullejal, kep pe an-chogo?’ ");
INSERT INTO kvnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tegin e-chapingan Jesúsga chogalmal: —Imi Moisés-igalgin-tulemal-oturdamalad chogmal: ‘Imi Pab-akpene-chogzhad-palmidagoed-tule ampayo tageddu, Elías inzhel noniko.’ ¿Ibiga teob chogmaldé? ");
INSERT INTO kvnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tegin Jesús aga e-chapinganga chogal: —Teobdo. Imi Elías inzhel nonikodo, tulemal-pel-kwapa kuakwa Pabgin pinzhegal. Tegin Jesús chogalbal: —¿Tede ibiga Pab-kartagin nermakal maichun, an-Te-Tule-Chunna peyedzhe wilegenab, tegin tulemal istar an-takenabmal? Imi pemal nuekwa wegin pinzheenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tenal an pemalga chogzhundo: tule-Elíasyobid pato arpigus, tenal tulemal a-itoleged sapejul we tule-imasmal, akpene Pab-kartagin choglejadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tegin Jesús aga e-chapingan-walapágwadbak nonigu, taknoni, e-chapingan-pimalad pukwamal. Tenal Moisés-igalgin-tulemal-oturdamalad Jesús-e-chapingan-pukmaladbak a-imananimal, tegin tule-pimalad íchejul tar-takpukmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tegin tule-takpukmalad Jesús-takchagu, weob pakal pesmal. Tegin tulemal Jesús-abin abarmadmal, Jesúsga choggalmal, pe tani-jogeye. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tegin Jesús tulemalzhe ekichial: —¿Ibiga pemalde Moisés-igalgin-tulemal-oturdamaladbak aga imananimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tegin tule-takpukmalad-walgwen Jesúsga chogal: —Tule-oturdaked, antin pega machi-cheinoni. Tenal an-machigin nia-maidbal an-machi keg chunma. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tenal an-machi meke-pia nadel, nia an-machi-okoele. Al nia machigin tognonikil, machi-olenonida, tegin machi kaka-maku-makaldabal. Tegin machi nugal kolaldabal, tegin abgan-kannalegaldabal. Tenal an pe-chapinganga chogzhan an-machigin nia-onogal. Tenal pe-chapingan keg kugusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tegin Jesús tulemalga chogal: —Imi pemal-ankin-penmalad, ¿an inkwáje pemalbak kudiguenabmal-wede ankin penzhulmalgal? ¿Tegin an inkwáje pemal-abin-purtigo-wede, pemal kep ankin ibzhemalgal? Nabir. Imisgin pe anka machi-chedagodo, an pega nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tegin tulemal Jesúszhe machi-cheinonimalgu, nia Jesús-takchadbal, neg-owededgin pela-pela kalzhemai machi-imas. Tegin nia napkin machi-olasgu, paparmamai machi-ebes. Tegin machi kakabal maku-mimai-pesbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tegin Jesús machi-e-pabzhe ekichial: —¿Inkwagus niade pe-machigin mai-wede? Tegin machi-e-pab Jesúsga chogal: —Toto-akar. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tenal nia melugus chogin, tegin tigin machi-olegus machi-mesgal. Tenal pe wilejakwa anmal-takel, tegin pe aga unni itogel, pe anmal-wis-pentakodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tegin Jesús machi-e-pabga chogal: —¿Ibiga pe weob anka chogde, an unni-dewa pe-machi-nudagal? Tenal tule-Pabgin-penzhulil, meke-ibi immal nabir we tulega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tegin machi-nia-nikad-e-pab pukib-itogedgin sapejul Jesúsga chogal: —Antin pegin ibzhedo. Tenal pe an-wis-pentako, an melle pegin pengugalma. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tegin Jesús takchagu tulemal-ichejul-ampagunoni, Jesús niaga chogal: —Nia-keg-chunmaked, ua-yalli-machi-imajad, imisgin an pega chogdo: ilgwen pe we machi-akar pe nao; tegin pe we machigin melle pal tognoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tegidgin nia sapejul kolmasgu, peyedzhe neg-owededgin pela-pela kalzhemai machi-ebes. Tegin nia machigin kep noszhun. Tenal machi ilgwen purkwijadyob mellemai-pes. Tegin tule-takpukmalad chogalmal: —We machidin purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tenal Jesús chunkalbal machi-kasgu, machi-okwichis. Tegin machi Jesúsga neg wisgual. Tegin machi ilgwen Jesúsga nugunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tegin Jesús machi-nudajad-cholbal aga e-chapinganbak neg-yabal ukposmal. Tegin e-chapingan pidzhi Jesúszhe ekichialmal: —¿Ibiga anmal keg we machigin nia-onogus-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tegin Jesús aga e-chapinganga chogal: —Tenal wegiid-niamal, tutujul onogal. Tenal (pemal-mas-kunchulidginbi,) tegin Pab-Tummadzhe-koledginbi, pemal kep unnigumalo wegiid-niamal-onogal. Tegin Jesús aga e-chapinganbak machi-nudajad-akar nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tegin Jesús aga e-chapinganbak nadgu, ampa Galileabal kudii-pesmal. Imi teun Jesús Pab-igalgin aga e-chapingan-oturdanai. Al Jesús peichul tule-pimalad e-wisgu, ede pia kudii. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tenal teun Jesús aga e-chapinganga chogal: —An-Te-Tule-Chunna tule-anpak-aichulmaladzhe uklego, tegin we tulemal an-mejo, tegin an ibapágin kannan tullebalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tenal Jesús-e-chapingan ampa aku-itomal, Jesús ega igi chogzhad. Tenal Jesús-e-chapingan tob Jesúszhe ekismalgus ibi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tegin Jesús aga e-chapinganbak Capernaum-neg-kweburzhe nonigu, neggin togzhamal. Tegin Jesús aga e-chapinganzhe ekichial: —¿Pemalde, igalbal ibigin aga imadanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tenal Jesús-e-chapingan ilgwen yakír pesmal. Imi teun e-chapingan igalbal-imakalmaladdin aga chogalmal: “¿Toa anmal-abalgin, pul tule-tummadga kuo?” Al Jesús-e-chapingan ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tegin Jesús chigwisgu, e-chapingan-walambe-kakabogwadga chogal: —Pemal wis ampagumalgwelo an-itogal. Imi meke-ibi-tule pul-tule-tummadga togbi-kujiil, pul tule-totogwadyob naneenab; tule-pimaladga pél immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tegin Jesús e-chapingan-wagin nuchu-chusgu, nukalgin nuchu-chis. Tegin Jesús aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Imi meke-ibi-tule an-nuggin nuchu-walgwen-abingajal, we tule an-abingasmo, tenal anpi an-abingaszhul, tenal tule-an-palmialid-abingasmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tegin Juan Jesúsga chogal: —Tule-oturdaked, anmal tule-walgwen-takcha, pe-nuggin tulemalgin niamal-onodii. Tenal we tule anmal-pakamaladzhulidbal anmal we tulegin igal-kasmal melle pe-nuggin nia-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tegin Jesús Juanga chogal: “Pe melle tulegin igal-pal-kao an-nuggin nia-onogal. Imi tule an-nuggin nabir immal-taktijulid imakel, untarzhal-nao, ankin istar kwen chunmakojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Imi tule anmalbak istar chulil, we tule anmalzhikidmogad. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Imi an chunchunnad pega chogdo: imi meke-ibi-tule pe-anpal-naidbal, pega an-nuggin ibimala-imakel, o pega ti-wis-uk-dewa, Pab Tummad keg-chulgu we tulega immal-nuegan ukmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tegin Jesús chogalbal: “Imi meke-ibi-tule iskuedgin ankin-ibzheed-mimmi-egwachal, we tule peyedzhe oturdalego. Tenal we tulega pul iwen-akalzhul termal-wiladgin tukalgin-akwa-mu-edinal-nai metel. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Imi pe-chunkal iskuedgin pe-egwachal, we chunkal pul pe chiko. Imi pega pul iwen-akalzhul, chunkal-orol Pab-negzhe toggal, pe pul chunkal-pog-pel cho-chagla-keg-akinnedzhe melledgal. ( ");
INSERT INTO kvnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Imi cho-chagla-neggin nusmal keg pel purkwe, tegin cho-chagla keg pel akinbal.) ");
INSERT INTO kvnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Tenal pe-nag iskuedgin pe-egwachal, we nag pul pe chiko. Imi pega pul iwen-akalzhul, nag-orol Pab-negzhe toggal, pe pul nag-pog-pel cho-chagla-keg-akinnedzhe melledgal. ( ");
INSERT INTO kvnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Imi cho-chagla-neggin nusmal keg pel purkwe, tegin cho-chagla keg pel akinbal.) ");
INSERT INTO kvnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Tenal pe-imia iskuedgin pe-egwachal, we imia pul pe unko. Imi pega pul iwen-akalzhul, imia-kwagwen Pab-negzhe toggal, pe pul imia-pog-pel cho-chagla-keg-akinnedzhe melledgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Imi cho-chagla-neggin nusmal keg pel purkwe, tegin cho-chagla keg pel akinbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tenal anmalgin pel-kwapa palu imalego, chogin wilub-taklegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Tenal palu, ib-nueddo yer-kulle mas imagal. Tenal palu iskunonikil, keg kannan pal nudale. Tenal pemal palu-nuedyob pe nanemalo, tenal aga muchub-muchub akalzhul ampagumalo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tegin Jesús Capernaum-akar nadgu, Judea-napche noni. Tegin Jesús ukin Jordán-tiwal-okpinal nadbal. Imi teun tulemal-pel-kwapa kannan Jesúszhe nonimalbal. Tenal Jesús kusgu e-igal-ulgin tulemal-oturda-choggu, al Jesús kannan Pab-igalgin tulemal-oturdajogalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tegin Pariseomal-wal-walgwen Jesúszhe nonimal, Jesús-wilub-takegal. Al Pariseomal Jesúszhe ekichialmal: —¿Tule nabir ome-meto o chul? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tegin Jesús Pariseomalga chogal: —¿Tenal Moisés-igal, igi pemalga chógdin? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tegin Pariseomal Jesúsga chogal: —Imi Moisés-igal chogdo: ‘Tule ome-metpiel, omega kep karta ukenab choggal, ede ome-mete.’ Tenal tule omega karta-ukchal, tule iwen-akalzhul nabir ome-meto. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tegin Jesús Pariseomalga chogal: —Nabir pe chogendo. Tenal pemal yapa-Pab-Tummad-igal-mechijadgin-naneedbal Moisés pemalga we igal-ebes. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tenal Pab Tummad kepe-saglagin tule-opinnisgu, weob igal-kwen-mezhiszhul. Imi Pab Tummad kepe-saglagin abirginagwal tule-opinnis. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Tegin Pab chogzhabaldo: Imi machi ome-nikuedbal aga-pab-aga-nan-ebeo, omebak mecha kudigugal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Imi we abirgin aga nikusmalal, pato aga chan-walkwénna kunonimalo. Gen. 2:24 Al we abirgin pato walbojul, pato chan-walkwénna kunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Imi Pab Tummad abirginagwal tule-imas-choggu, al tule igal-kwen-nikchul, we abirgin-idirgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tegin Jesús negzhe tognonikidgin, e-chapingan Jesúszhe kannan ekichialmalbal: —¿Imi ome-miedgin, pe chunmajadde, ibi chogle-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tegin Jesús aga e-chapinganga chogal: —Imi tule-walgwen aga ome-metel, tegin ome-pid-nikunonikil, we tule ome-pidgin-yolejadyob kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tenal ome-melleded machered-pid-nikusmogal, we ome machered-pidgin-yolejadyob kunonimo. Teob Jesús chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tegin tulemal Jesúszhe nuskan-cheinonimal, Jesús chunkalgin nuskan-ebujadgin choggal: “Pab Tummad pega immal-nuegan imakelen, nabirinye.” Tegin Jesús-e-chapingan tulemal-Jesúszhe-nuskan-cheidanimaladzhe ulualmal-chogalmal: —Melle Jesúszhe nuskan-chedamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tegin Jesús e-chapingan-chogzhad itosgu melle eje nuskan-chedamalo, istar itos. Tegin Jesús aga e-chapinganga chogal: —¿Ibiga pe nuskanga chogde, melle anche tagmalo? Meke nuskan anche tagmalodo. Imi Pab-neg-takmaid we nuskanyob-kudimaladga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Imi an chunchunnad pemalga chogdo: meke-ibi-tule nuskanyob Pab-neg-takmaid kwen abingejulil, we tule Pab-neg-takmaidzhe kwen togojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tenal nuskan yabli Jesúszhe nonimal. Tegin Jesús nuskan-irmamaid-ilbal, chugnukwa nuskan-aktomai. Tegin Jesús chunkalgin nuskan-ebusgu, Pab Tummadzhe kolalzhun: “Pe we nuskanga immal-nuegan imakelen, nabirinye.” ");
INSERT INTO kvnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tegin Jesús nejogalidgin, tule-walgwen Jesúszhe abarmanoni, tegin Jesús-abir chimtinoni, tegin Jesúszhe ekichial: —Tule-oturdaked, pedin tule-nued. ¿Imi an igi imakenab ilagwen-nadgu tullegal? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tegin Jesús tule-nonikidga chogal: —Nabir. ¿Ibiga pe anka chogde, antin tule-nued? Pab Tummadbi unnila tule-nued. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Imi pe nued wiszhulzhí, Pab Tummad Moisésbal igi igal-mezhis? Imi Pab chogzhado: Melle tule-mejo; melle ome-pidgin yolego; melle immal aturzhao; melle pinche-pinche kakanchao; melle tule-yardako; tegin pe aga pabgangin atago. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tegin tule-Jesús-abir-chimtinonikid Jesúsga chogal: —Tule-oturdaked, imi antin toto-akar pe-chogzhadyob nanedii. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tegin Jesús we tule-chogzhad itosgu, weligwaledgin, pilaledgin we tulega chogal: —Nabir pe chogendo: ‘An toto-akar pel-kwapa weob nanedii,’ tenal pe immal-choggwen napido. Imi pe negzhe nadel, pél pe immal-nikad pe manigin uko. Tegin pe tule-wilemaladga mani ukpalo. Imi an-pega-chogzhadyob, pe tule-wiledimaladga mani ukchal, pedin Pab-neggin íchejul immalmal-nuegan nikunoniko. Tenal pe tule-wilemaladga pél mani-ukchad-cholbal, kep pe anche tago ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tenal we tule peyedzhe-immalmal-nikad-yapa-ukedbal Jesús-ega-chogzhad-itosgu, e-ulubgin nunma-pes. Tegin we tule pukib-pakal nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tegin Jesús tule-naded takchagu, e-chapinganzhik akpiris. Tegin Jesús aga e-chapinganga chogalzhun: —¿Peyedzhe, pe takchulzhí, tule-mani-ibed pirkin-mani-pilaledbal Pab-neg-takmaidzhe toggal? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tegin Jesús e-chapinganga chogzhadbal, e-chapingan weob pakal pesmal. Tegin Jesús kannan aga e-chapinganga chogalbal: —Masmal, peyedzheá, tule (pirkin manigin pinzheedbal) Pab-neg-takmaidzhe toggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Imi moli-camello pul-pulejul wag-iko-imia-yabal toggal, tule-mani-ibed pul Pab-neg-takmaidgin toggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tenal Jesús e-chapingan pul-pule weob pakal pesmal. Tegin e-chapingan Jesúsga chogalmal: —¿Imi tule-mani-ibed Pab-negzhe-toggal ib-peyedzhe-choggu, tegil toamala abonolegojun? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tegin Jesús nuu e-chapingan-takalgu, e-chapinganga chogal: —Imi tulega, immal keg kued; Pabgadin, pél nabir immal kunonida. Al Pab-Tummad-unni e-neg-takmaidgin tule-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tegin Pedro Jesúsga chogal: —Tenal anmal pél immalmal ebesmal pebal naigugal. ¿Tegil anmalga ibi uklenonimalmogojun? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tegin Jesús Pedroga chogal: —An chunchunnad pega chogdo: meke-ibi-tule anpal-naigujadbal, tegin an-kaka-nuegangin-chunmakoedbal aga immalmal ebejal, nega, nagnu, paba, nana, nuskan, kwenamalad, ");
INSERT INTO kvnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","we tule-immal-ebejadbal tulaataled-ilgwen-kaka pul melu, iti-napkin we tulega immalmal uklenoniko: nega, nagnu, nana, nuskana, kwenamalad. Tenal tulemal sapejul pe-imaked-abalgin pe immal nikunoniko. Tenal tule anpal-naigujadbal immalmal-ebejadbal, Pab-neggin ilagwen-nadgu tullego. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Tenal tulemal-ichejul-iti-napkin-tummaganga-irmamalad Pab-neggin tule-pinchegadga kunoniko. Tenal tulemal-ichejul-iti-napkin-pinchemaladga-irmamaladdin, Pab-neggin tule-tummaganga kunonimalo.” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tegin Jesús aga e-chapinganbak Jerusalén-igalbal natapidgin, teun Jesús aga e-chapingan-iktumai. Tenal Jesús e-chapingan-iktumaidbal, e-chapingan weob pakal pesmal. Tegin tule-Jesús-cholbal-tanimalad Jesúsgin kwakialmalbal. Tegin Jesús pidzhi aga e-chapingan-walambe-kakabogwadzhe kochagu, aga igal wis itosmal. Tegin Jesús aga e-chapinganga chunmakalzhun, kujal ega immal-kuoedgin. Al Jesús aga e-chapinganzhe chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Imi pe takto, anmal Jerusalénzhe natapmal. Tenal tule an-Te-Tule-Chunnagin akpinnoniko, tule-irwal-Pabzhe-kolmalad-e-tummaganzhe tegin Moisés-igalgin-tulemal-oturdamaladzhe. Tenal Judio-tummagan ankin chognonimalo antin keg-chulgu purkweenab. Al Judio-tummagan tule-Judiojulmaladga an-ukmalo an-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tegin tule-Judiojulmalad ankin istar todomalo, tegin ankin kwi mimalo, tegin peyedzhe an-ebiomalo, tegin an-mesmalo. Tenal an ibapágin purkwaled-akar kannan tullenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tegin Zebedeo-machimal-walbo Jesúszhe nonimal, Jacobo tegin Juan. Tegin we machimal-walbogwad Jesúsga chogalmal: —Tule-oturdaked, anmal peido, pe anmalga immal wis imako. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tegin Jesús machimal-walbogwadga chogal: —¿Igi pe pei, an pemalga immal ima? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tegin machimal Jesúsga chogalmal: —Imi pe tummadga nugu-taklegedgin togzhal, anmal peigujiindo anmal pe-yalbalmaladga kugal; kwen pe-nuedzhik chiggal, kwen pe-chapilezhik chiggalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tenal Jesús machimal-walbogwadga chogal: —Pemal immal-kwen-wichulidgin anka chunmananimalma. ¿Imi pe unnimalmogoyé an-wilegoedgin wilegalmo, an-kobed-kakpid-pakal-kobneedyob? ¿Tegin pe unnimalmogojí an purkoedgin, an tigin-oglegoedyob pe purkwegalmo? ");
INSERT INTO kvnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tegin Jacobo tegin Juan Jesúsga chogalmal: —Anmal unnimalmodo. Tegin Jesús we machimalga chogal: —Tegil nabirdé. Imi pemal anyob unnio-choggu, al an kobed-kakpid-pakal-kobneedyob tegin an tigin-oglegoedyobbal pe anyob wilemalmogodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tenal an-nuedzhik tegin an-chapilezhik-chigmaloeddin, ankin chijul choggal: ‘We tule an-cholbalmaladga toggal.’ Tenal Pab Tummad pato tulemal-chus an-cholbalmaladga toggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tegin Jesús-e-chapingan-walambegwad wisgusgu Jacobo tegin Juan tule-tummadga-togbi-kualmal, Jacoboje tegin Juanzhe ulualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tegin Jesús e-chapingan-walambe-kakabogwadzhe kocha ka chogal: —Tenal pemal nued wismal, Judio-tulejulmalad-e-tummagandin e-chapinganga pul tummarba itomal, tegin we tummagan kantikidgin tulemalga ib chog. Tegin we tule-tummagan kantikidgin tule-palmibal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Tenal pemal-abalgin, iti-napkined-tummagan-tamaladyob pemal naneed-wilubzhulmal. Tenal meke-ibi-tule, pemalga tule-tummadga kubiel, we tule tummarba itoged-wilub chul. Tenal we tule pul mosyob tule-pentakenab. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tenal meke-ibi-tule pemal-abalgin tule-pul-tummadga kubiel, we tule pul-pule pel-kwapa tulemalga tule-pinche-arpagedyob naneenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Tenal an-Te-Tule-Chunna ampa an-chogzhad-yopí kudimo. Imi an kwen nonijul tule-mosyob-anka-immal-imagal. Tenal antin nonido, tulemalga immal imagal, tegin an-purkoedbal ichejul tulemal-abonogalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tegin Jesús aga e-chapinganbak Jericóje nonimal. Tegin Jesús Jericó-akar nadmalgu, Jesús-e-chapingan tegin tule-pimalad-íchejul Jesúsbak mes nadmalmo. Imi teun tule-aku-ataged-walgwen igalgin chii, mani-ekichi. Tenal we tule-aku-ataged Timeo-e-machi-Bartimeo. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tegin Bartimeo Jesús-Nazaretkined-tani itosgu, sapejul kolmakal chogal: —Jesúsye, pe David-wagwaye, imi pe wilejakwa an-takelen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tegin tulemal-Jesúsbak-natapmalad tule-aku-atagedga chogalmal: —¡Pe melle kolmama! ¡Pe yakir-kuma! Tenal tule-aku-ataged pul-kigma Jesúsga kolmakal chogal: —David-wagwaye, pe wilejakwa an-takelen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tegin Jesús tule-aku-ataged-itosgu, kannamamaid kwisgunoni. Tegin Jesús tulemalga chogal: —Pe we tulega chogo: ‘Tago.’ Tegin tulemal-Jesúsbak-natapmalad, tule-aku-atagedga chogalmal: —¡Pe welguma, pe kwisguma! Imi Jesús chogdo pede eje tago. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tegin tule-aku-ataged Jesús-ega-chogzhad itosgu eje tago, weligwal-itogedgin ilgwen chuba mid. Tegin tule-aku-ataged kwisgudgu, ilgwen Jesúszhe al. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tegin Jesús tule-aku-atagedzhe ekichial: —¿Igi pe pei, an pe-pentakegal? Tegin tule-aku-ataged Jesúsga chogal: —Tule-oturdakedye, antin pei, pe anka imia nudagalye. ");
INSERT INTO kvnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tegin Jesús we tulega chogal: —Tegil nabirdé. Imi pe ankin penguszhul-choggu, al pe nugus. Imidin pe akalzhul negzhe nao. Tegin tule-aku-ataged ilgwen imia nuguszhun. Tenal tule-imia-nugujad ilgwen Jesúsbak mes igalbal nadmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tegin Jesús aga e-chapinganbak Jerusalén omodanigu, Betfagé tegin Betania-neg-kwebur-omodanikidgin Olivo-yal-inik peinoni. Tegin Jesús walabo aga e-chapingan-palmijogalgu, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Imi pe we neg-kwebur-toto-pe-takchiidzhe, pe nemalo. Tenal pe we neg-kweburzhe tognatapil, pe taknatapmalo moli-burro-chapini edinal-un. Imi we moli-chapini, tule ampa kin kwen nakwedijul. Tenal pe we moli-burro-echikchal, pe anka chedamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tegin tule peje ekichialil: ‘¿Ibiga pe moli-burro-echiknai-wede?’ Pe we tulemalga chogo: ‘Tummadde chog ede we moli-pei. Tenal tummad kujal pega kannan cheinonibalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tegin Jesús-e-chapingan nadmalgu, taknatapmal moli-burro igal-yagin-wanagakkin edinal-un. Tegin Jesús-e-chapingan moli-echikchamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tegin tulemal-aka-pukmalad Jesús-e-chapinganzhe ekichialmal: —¿Ibiga pemalde moli-echiknanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tegin Jesús-e-chapingan moli-ibganga chogal: —Tummadde chog ede pei. Tenal tummad kujal pega kannan cheinonibalo. Tegin tulemal Jesús-e-chapinganga chogalmal: —Tegil pe akalzhul chedodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tegin e-chapingan Jesúsga moli-cheinonimalzhun. Tegin Jesús-e-chapingan moli-cheinonimalgu, moli-yankalgin aga e-molmal okismal. Tegin Jesús moligin nakwiszhun. Tegin Jesús aga e-chapinganbak ukin nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tenal tulemal-ichejul errey-tummadyob Jesús-takedbal Jesús-iktual igalgin okin-okin aga e-molmal imasmal. Tegin tulemal nagnugin uga-ka kwachamalgu, igalgin uga-ka okismalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tegin tulemal-Jesús-iktual-irmamamimalad, tegin tulemal-Jesús-cholbal-tanimalad sapejul kolmanatapmal chogalmal: “¡Jesúsye, pe otummoledi-kuelen, nabirinye! Imi tule-Pab-Tummad-nuggin-tanikid, ib-nuedga kuelen, nabirbalinye. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tegin Pab Tummad anmal-tadgan-Davidyob Jesús-neg-takmaid nued takelen, nabirbalinye. Tegin we Jesús Pab-neggin pul otummoledi-kuelen, nabirbalinye.” ");
INSERT INTO kvnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tegin Jesús Jerusalénzhe tognonigu, ilgwen Pabzhe-koled-negzhe nad. Tegin Jesús Pabzhe-koled-negzhe togzhagu, pel-kwapa neg algas. Imi teun neg pato chedodani-choggu, al Jesús aga e-chapingan-walambe-kakabogwadbak ilgwen Betaniaje kannan almalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tegin Jesús te pangin Betania-akar kannan Jerusalénzhe nadbalgu, igalbal ukulzhaal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tegin Jesús panna-akar takcha wag-islub-chapi kamagwis. Tegin Jesús ilgwen e-chalzhe nad takegal wag-islubde chan nik-dewa. Tegin Jesús wag-islub-chal omosgu, e-chan kwen onoszhul, pinche unnila kamagwis. Imi teun wag-islub e-chanmaked-wilub ampa omojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tegin Jesús aga e-chapingan-wagin wag-islub-chapiga chogal: —Pedin ilgwen-pesgu peine, chan kwen nikchul. Tenal e-chapingan Jesús-chogzhad-itosmalgu, ukin nadmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tegin Jesús kannan Jerusalénzhe nonigu, Pabzhe-koled-neg-impabal tognoni. Tegin Jesús Pabzhe-koled-neg-impabal togzhagu, pel-kwapa tule-immalmal-ukpukmalad tegin tule-immalmal-pakpukmalad-onis. Tegin Jesús tule-mani-ogwabukmalad-e-mesamal okpis, tegin tule-nu-ukpukmalad-e-kanmal okpisbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tegin Jesús tulemal-immal-cheimamimaladgin igal-kas, Pabzhe-koled-neg-impabal immalmal chedagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tegin Jesús tulemal-oturdakalgu, chogal: —¿Imi Pab Tummad e-kartagin chogzhulzhí? An negdin tule-pel-kwapa-akal-akal-anche-kolgalbi, tenal pemal immalmal-aturzheed-negga anche-koled-neg imananimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tenal tule-irwal-Pabzhe-kolmalad-tummagan tegin Moisés-igalgin-tulemal-oturdamalad Jesús-chogzhad itosgu, igal-amialmal igi nabir Jesús-mesgal. Tenal Jesús-tulemal-oturdajadbal tulemal-pel-kwapa weob pakal pesmal-choggu, al tummagan Jesús-tobgualmal Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tegin neg-chedogalgu, Jesús aga e-chapinganbak kannan Betaniaje almalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tegin Jesús te pangin kannan Jerusalénzhe natapidgin, pato taknonimal, wag-islub-chapidin pato tinna kwichi. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tegin Pedro wisgud-nadgu Jesúsga chogal: —Tule-oturdaked, pe tak; sae-pe-wag-islub-chapi-ukapchajaddin pato tinna kwichi. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tegin Jesús aga e-chapinganga chogal: —¿Teobí? Tenal pemal ulubgin Pab Tummadgin penzhulinabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tenal an chunchunnad pemalga chogdo: meke-ibi-tule Pab Tummadgin nued penzhulidgin yal-tummadga chogzhal: ‘Imisgin pe we-akar ilgwen termalzhe arkwano,’ we yaldin keg-chulgu ilgwen termalzhe arkwanenab. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Al an pemalga chogdo: meke-ibi pe Pab Tummadzhe koledgin ekichial, tenal pedin penzhulil Pab Tummad pato pega ukcha, wedin pega kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Tenal pe Pabzhe kolzhogalil, tule-pebak-walmadiidga pe chogenab: ‘Pe-iskued pato pelgus.’ Imi pe chogzhal: ‘Iskued-pelgus,’ Pab-nikpa-maid iskued-pelgus pega chogmogo. ( ");
INSERT INTO kvnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tenal tule-pegin-immal-akalojadga, pe iskued-pelgus chogzhajulil, Pab-nikpa-maid pega kwen chogojulmo: ‘Pe iskued pelgus.’)” Teob Jesús chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tegin Jesús aga e-chapinganbak Jerusalénzhe nonimalbalzhun. Tenal Jesús Pabzhe-koled-neg-impabal pipirmadiidgin, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad tegin Judio-chelegan-tummagan Jesúszhe ekisnonimal: ");
INSERT INTO kvnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Imi pe toa-nuggin weob pe immal ima-wede? ¿Tegin toa pega igal-ukpal-wede, weob immal imagal? Imi an pe-peido, pe anka choggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tegin Jesús Judio-tummaganga chogal: —Tegil an pemalzhe inzhel immal ekisnegwel. Imi pe anka chogzhal, kep an pega chogmogo toa anka igal-ukcha an weob immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Imi Juan-Bautista-tigin-tulemal-ogdi-kujad pia-akar tani-jogna? ¿Pab-akar o tule-akar? Anka chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tegin Judio-tummagan aga emal-emal chunmakalmal: —Imi anmal chogzhal: ‘Juan-Bautista-tigin-tulemal-oged Pab-akar tani,’ we Jesús anmalga chogdago: ‘¿Tede, ibiga pemalde Juangin keg ibzhemalzhun?’ ");
INSERT INTO kvnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tenal anmal chogzhabalil: ‘Juan-Bautista-tigin-tulemal-oged tule-akar tani,’ anmal tulemalgin kwakidamalo. Imi tulemal-pel-kwapa chogmal, Juan Bautista chunchunnad Pab-kaka-palchoged. ");
INSERT INTO kvnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Al Judio-tummagan Jesúsga chogalmalzhun: —Anmal kwen wichulmal, Juan-Bautista-tigin-tule-oged, pia tani. Tegin Jesús tummaganga chogal: —Tegil an pemalga kwen chogojulmodo, toa anka igal-ukcha weob immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tegin Jesús purpal tulemal-oturdakalzhun: “Imi te ibagwengin, tule-walgwen nagnugin uva tigzha. Tegin tule-nagnu-ibed pel-kwapa ebiris aga nagnu chaktis. Tegin tule-nagnu-ibed kuakwa uva-nis-abingeed chobzhabal. Tegin tule-nagnu-ibed nikpa kalu chobzhabal pel-kwapa nagnu-algegal. Tegin tule-nagnu-ibed nejogalgu, tulemalga e-nagnu wis ololchas kujal-uva-weied-omojal aga abal kamalgal. Tegin uva-e-ibed napa-pidzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Tegin uva-nabgued-ibe omosgu, tule-nagnu-ibed tule-nagnu-takchimaladzhe, aga e-mos-palmial, uva-chan-abal-ega-uklegoed amigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tenal mos tule-nagnu-takchimaladzhe nonigu, tule-nagnu-takchimalad we mos-kasmal. Tegin tule-nagnu-takchimalad mos-nonikid-sakismal, tegin chunkal-kwabi kannan e-tummadzhe e-mos-palmismalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Tenal tule-nagnu-ibed, tule-nagnu-takchimaladzhe e-mos-pid-palmialbal. Tegin mos nonigu, tule-nagnu-takchimalad nonogin mos-sakismal, tegin istar mosgin todosmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tegin tule-nagnu-ibed e-mos-pid-palmisbal tule-nagnu-takchimaladzhebal. Tenal tule-nagnu-takchimalad mos-nonikid-mechamal. Tegin tule-nagnu-ibed íchejul-e-mosmal-palmialbal tule-nagnu-takchimaladzhe uva amigal. Tenal tule-nagnu-takchimalad mosmal-nonimalad-sakismal, kwen-mechamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tegin tule-nagnu-ibed pél aga e-mosmal-palmisgu, e-machi-pilaledbi, walkwénna wis petap. Tegin tule-nagnu-ibed kep chogalzhun: ‘Imi antin naga machi-palmine, tule-nagnu-takchimaladzhe. Tenal tule-nagnu-takchimalad an-machigin atagenabmal.’ Tegin tule-nagnu-ibed aga machi-palmialzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Tegin tule-nagnu-ibed-e-machi, tule-nagnu-takchimaladzhe nonigu, tule-nagnu-takchimalad aga emal-emal chunmakalmal chogalmal: ‘Imi we machi-tanikid e-pab-purkwijal, we nagnu machigadga kunoniko. Al anmal we machi-mejenabmalbal, nagnu pél anmalgadga kunonigal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tegin tule-nagnu-takchimalad machi-kasmalgu, nagnu-tikalzhe machi-chesmal. Tegin tule-nagnu-takchimalad nagnu-tikalbal kep machi-mechamalzhun.” Tegin Jesús tulemal-e-itobukmaladzhe ekichialbal: ");
INSERT INTO kvnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—¿Imi tule-nagnu-ibed, tule-ebi-machi-mechadbal, igi tule-nagnu-takchimalad-imako pe ebinzhe? Nabir. Imi tule-nagnu-ibed tule-nagnu-takchimaladzhe nonikil, tule-nagnu-takchimalad-mesmogo, tegin tule-pimaladga nagnu uko ega takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Imi pemal Pab-kartagin apchodimalzhulzhí Pab-kartagin igi chog? Imi Pab-kartagin chogdo: Imi tule-neg-chobmalad akwa-mete. Tenal we akwa-meted akwa pul-chunchogedga kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Imi Pab Tummad weob akwa-imas. Al Pab-Tummad-immal-imajadbal anmal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tenal Judio-tummagan Jesús uva-tigzhadgin, tegin akwa-metedgin purpal chunmas itosgu, mag itosmal Jesús emalgin chunmas. Al Judio-tummagan igal-amialmal Jesús-kagal. Tenal Judio-tummagan tulemal-tobgualmal-choggu, al Jesús-ebesmalzhun. Tegin Judio-tummagan ilgwen Jesús-akar nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tegin Judio-tummagan Jesúszhe Pariseo-tegin-Herode-chapingan-palmialmal yami Jesús-wilub-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tegin we tulemal Jesúszhe nonimalgu, Jesúsga chogalmal: —Tule-oturdaked, anmal nued wismaldo, pedin napírra chunma. Tegin anmal wismalbaldo tule-tummad o tule-pinchegad pega iwen-akalzhul, pe tule-kwen-tobzhul. Tenal pe ilgwen pakal-pud-pud Pab-igalgin tulemal-oturdabal. Imi pe inniki-immal-choged-tule-choggu, al anmal peido, pe anka chog. ¿Imi anmal nabir Romano-Tummad-Césarga mani-egwannanimalad penuko o chul? ");
INSERT INTO kvnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tegin Jesús takchagu tulemal ib-chunnadyob chunmananimal, we tulemalga chogal: —¿Ibiga pemal an-wilub-taknanimal-wede? Anka pe mani-kwagwen chedagweldo an takegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tegin Pariseo-e-chapingan Jesúsga mani cheinonimalgu, Jesús tulemalzhe ekichial: —¿We manigin toa-wagal-purpa chii-jogna? ¿Tegin toa-nug nermakal naibal-chogna? Tegin Pariseo-e-chapingan Jesúsga chogalmal: —Romano-Tummad-Césargadde. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tegin Jesús Pariseo-e-chapinganga chogal: —Nabir. Imi immal Romano-Tummad-Césargadil, Césarga pe ukodo. Tenal immal Pab Tummadgadil, pe Pab Tummadga pe ukodo. Tenal Pariseomal-e-chapingan Jesús-chogzhad itosgu, weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Imi teun Saduceomal Jesúszhe nonimal. Tenal Saduceomal chogmaldo: “Imi tule purkwijal, Pab-neggin pal kwen tullegojul.” Tegin Saduceomal Jesúszhe ekichialmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tule-oturdaked, imi Moisés anmalga igal-mezhisdo: ‘Tule-ome-nikad nuchu-nikuszhul purkwijal, e-urpadin keg-chulgu e-ia-omega-kujad-nikuenabmo, aga e-ia-purkwijadga nuchu-nikunonigal.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Nabir. Imi te ibagwengin tule-walgwen machimal-walakugle-nikus. Tegin machi-tummad ome-nikunoni. Tenal machi-tummad nuchu-kwen-nikchul purkwenoni. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tegin e-urpa-e-palid e-ia-omega-kujad-nikunonimo. Tenal we machi ampa nuchu-nikuszhul purkwenonimo. Tegin e-urpa-pid, ampa e-ia-omega-kujad-nikunonimo. Tenal we machi ampa nuchu-kwen-nikchul purkwenonimo. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tenal machimal-walakugled pél we ome-nikusmal. Tenal machimal yabli tegigus nuchu-kwen-nikuszhulmal. Tenal we ome kep napigin purkwenonimojun. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Imi we ome Pab-neggin kannan tullejal, ome machi-walakugle-pél-nikujadbal ¿piti-machi-walakugled e-machered-chunchunnadga kunoniko?” ");
INSERT INTO kvnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tenal Jesús Saduceomalga chogal: “¿Ibiga pemal anka noal chunmananimal-wede? Imi pemal ampa nuekwa Pab-karta-nermakal-maid kwen wichulmalma. Tegin pemal Pab-kannaleged-nikad kwen wichulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tenal tule-purkwijad-akar Pab-neggin kannan tullejal, ome-pal-kwen-nikuojul. Tegin omegandemo, machered-pal-kwen-nikuojulmalmo. Tenal tulemal angelmalyob kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Imi anmal tule-kannan-tullegoedgin chunmamalo. ¿Tenal pemal Pab-karta apchodimalzhulzhí, akpene igi Moisésga ib kujad? Imi teun Moisés kagwis chapi takchagu, abir nad. Tenal Pab Tummad Moisésga chogal: Imi antin, Abraham, Isaac, tegin Jacob e-Pab-Tummadga mai. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Imi anmal-tadgan Pab-neggin tulleszhulilen, Pab Tummad tadgangin kwen chogzhajulin ede tadganga Pab Tummadga mai. Imi Pab Tummad, tule-purkwismalad-e-Pab-Tummad chul, tenal Pab Tummad, tule-kannan-tullesmalad-e-Pab-Tummadga mai. Tenal pemal immal-kwen-wichulidbal, tule-kannan-tullegoed-igalgin pe peyedzhe nosmaldo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tegin Moisés-igalgin-tulemal-oturdaked-walgwen, Jesús yer Saduceomal-abin-imas itosgu, Jesúszhe ekisnoni: —¿Imi Pab Tummad piti-igal-pul-chunchoged anmalga ebes-chogna? ");
INSERT INTO kvnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tegin Jesús tulega chogal: —Nabir. Imi igal-pul-chunchoged chogdo: Israel-tulemal pe nue itomalo: Anmal-Pab-Tummadbi, unnila Pab Tummadga mai. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tenal pemal Pab-Tummad-pilalguenab, pél aga pe-ulubgin itogedzhe, pél pe-purpaje, pél pe-pinzheedzhe, pél pe-kalzhe, pel-kwapa. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tegin kaka-chogbogwad chogbal: Imi aga pe-chan pilaledyob, pe tule-pid-pilalguenabmalmo. Lv. 19:18 Tenal anmalga igal-pul-chunchoged ukin pal nikchul, imi an-chogzhadbi unnila maido. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tegin Moisés-igalgin-tulemal-oturdaked Jesúsga chogal: —Tule-oturdaked, pedin nued imasdo; pe chunchunnad chogzhado: ‘Pab Tummadbi walkwénna mai, Pab Tummad-pid ukin pal kwen nikchul.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Imi pe chogzhado, anmal Pab-Tummad-pilalguenab, pél anmal-ulubzhe, pél anmal-purpaje, pél anmal-pinzheedzhe, pél anmal-kalzhe, pel-kwapa. Tegin tule aga chan pilalguedyob, anmal tule-pid-pilalguenabmal. We igaldin pul ib-nued; tule pul kugedgin Pabga-immal-ukedga, tegin tule pél Pabga-immalmal-ukchadgabal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tegin Jesús itosgu we tule yer chunmas, Jesús we tulega chogalzhun: —Pedin pe iche-napi Pab-neg-takmaidgin toggal, Pabgadga kugal. Imi te ibe-akar tulemal Jesús-tobedbal keg Jesúszhe immal pal ekisgusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tegin Jesús Pab-Tummadzhe-koled-neggin tulemal-oturdanaidgin, Pariseomalzhe immal ekichial: —¿Ibiga tule-Moisés-igalgin-tulemal-oturdamalad chogmal: ‘Imi Cristo-Pab-akpene-chogzhad-palmidagoed Errey-David-e-wagwa?’ ");
INSERT INTO kvnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tenal Errey-David Pab Purpa Nuedbal aga tukin Pab-akpene-chogzhad-palmidagoed-tulegin chogzhado: Imi Pab Tummad an-Tummadga chogzhado: ‘Pedin an-nuedzhik tummadga chigwitapo, tule-pebak-aichulmaladgin nakwegal an pe-imakedzhe, pe kangin nag-onakwedyob.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tegin Jesús chogalbal: —Imi Errey-David-pel Cristoje kocha ‘Tummad,’ ¿tede Cristode, igi David-e-wagwaga kuo? Tenal tulemal Jesús-kwen-abin-imaszhulmal, ilgwen yakir pesmal. Tenal tulemal-Jesús-itobukmalad-íchejul, yer Jesús-itosmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tegin Jesús tulemal-oturdanaidgin, tulemalga chogal: —¡Wijira! tule-Moisés-igalgin-tulemal-oturdamaladzhe. We tulemalzhe pe-pinzheed kaleda. “Imi tule-Moisés-igalgin-tulemal-oturdamalad tule-tummadyob nanebimal, mol-nued yomal, tegin neg-kwebur-abalgin tulemal-eje-atagedgin kolmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tegin we tulemal ormaked-neggin tule-tummagan-kangin chigmal, tegin tulemal pulakwa mas-kunpukwadgin, tule-tummagan-abalgin chigdamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Tenal tule-Moisés-igalgin-tulemal-oturdamalad pinche yardagedgin ome-tarbi-machered-purkwismaladgin immalmal egwannanimal. Tegin Moisés-igalgin-tulemal-oturdamalad ib-chunchunnadyob, orojul Pabzhe kolmal, tulemal yami yer e-takegal. Tenal tulemal-weob-nanemalad pul-púle Pabzhe oturdalenoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tegin Jesús Pabga-mani-ukmalad-nabal tulemal-mani-uknanimalad-takchii. Imi teun takalgu, tule-mani-ibgan-ichejul Pabga ichejul mani uknanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tegin Jesús takchabal ome-wileged-machered-tarbi-purkwijad-walgwen nonimo. Tenal we ome unnila mani-kollogana-kwabo Pabga mani wis ukcha. ¿Tenal we mani, ibiga wis nabir? Ibga keg pel ku. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tenal Jesús ome-mani-ukchad takchagu, e-chapinganzhe kocha. Tegin Jesús aga e-chapinganga chogal: —Imi an chunchunnad pemalga chogdo: pe takcha, we ome-wileged-mani-ukchad. Imi we ome iche mani wis ukchando, tenal tulemal-ichejul-Pabga-mani-ukchamaladga, pul-pule mani ukcha. ");
INSERT INTO kvnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","¿Ibiga an teob pemalga chog? Nabir. Tenal tule-mani-ibgan ichejul mani ukchando, tenal we tule-mani-ukchamalad manigwen-ukchadyob aga itosmal. Tenal we ome iché mani ukchando, tenal Pabga yabli aga pellallé-napi mani ukcha, aga mas kunkal pel peszhul. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tegin Jesús Pab-Tummadzhe-koled-neg-akar nodgu, e-chapingan-walgwen Jesúsga chogal: —Tule-oturdaked pe tak, ¿Pabzhe-koled-neg akwa-purwijul ne-á? ¿Tegin neg-nugu-taklebal-á? ");
INSERT INTO kvnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tegin Jesús we chapinga chogal: —Agzhal pe tak, we neg totojul. Tenal we neg kujal akwa askin aga chiji pel peiojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tegin Jesús aga e-chapinganga chunmajad-cholbal, Jesús aga e-chapinganbak Olivo-yalzhe nadmalzhun. Tegin Jesús Olivo-yal omosmalgu, Pabzhe-koled-neg-abin-opakal ampagusmalzhun. Tegin Pedro, Jacobo, Juan, Andrés, amal-walbakegwad pidzhi Jesúszhe ekichialmal: ");
INSERT INTO kvnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Imis pe chunmajad, inkwa kuo-wede? ¿Igidgin anmalga oyolego-wede? Anmal pei, pedin anmalga chog. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tegin Jesús aga e-chapinganga chogalzhun: “Tenal pe nue aga takermal, tulemal pe-yardadamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tenal tulemal kujal ichejul pemalga chunmanonimalo: ‘Antin a-tule, Pab-akpene-chogzhad-palmidagoed.’ Tenal we tulemal íchejul tulemal-yardamalo ebak naigumalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Tegin pe itodamalbalo, pila-nonai. Tegin pe iche-iche itodamalbalo choglenai pila-nobi-kunai. Tenal pe melle tobgudamalo, tenal neg-pelgued ampa omojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Imi tulemal kaka-akal-chunmamaladbak pila-onononimalo, tegin napa napa-pidbak pila-onononimalbalo. Tegin neg-tutumaked akne-akne noniko, tegin mas-kunned nikchul-kunonibalo. Tenal we ponimal kep pinche iche kudanimal. Tenal poni kujal pul-pule kunoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tegin Jesús chogalbal: “Tenal pedin nue aga takermal, melle an-igegal. Tenal tulemal kujal pe-kanonikil, tule-tummaganga pe-ukmalo. Tegin tulemal Judio-ormaked-neggin peyedzhe pe-ebiomalo. Tenal pe-ankin-penzhulidbal pe gobernadormalga tegin erreymalga pe ankin chunmako, tule-tummagan an-wisgumalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tenal neg ampayo pelgueddu Pab-kaka-nuegan pel-kwapa-nap-naid-ugakche choglegenab. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Imi tulemal pe-kanonikoedgin, tegin pega igal-itodagoedgin, pe melle pukib-itomalo pe igi chunmako-dewa. Imi tule-tummagan pemalga igal-itonaidgin Pabdin kep pega chunmanoniko, pe igi chogo-dewa. Tenal pe aga tukin chunmakojul, Pab Purpa Nued pebal chunmako.” ");
INSERT INTO kvnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tegin Jesús chogalbal: “Imi pe-kalgwenmalad pe-tuktigo pe-mesgal. Tegin pabgan aga machi-tuktigo. Tegin nuskan aga e-pabgan-tuktimogo tar-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tegin pemal anpal-naidbal tulemal-pel-kwapa istar pe-taknonimalo. Tenal pemal poni-naid-pelguedzhe abin-purtismalal, pemal abonolego Pabbak meggal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tegin pe takalil, Pabzhe-koled-neg-impabal, Pab-kaka-palchoged-Daniel chogzhadyob immal-iskan-chigojulinadgin-chii, tulemal-Provincia-Judeaginmalad ilgwen wakinenabmal yal-tummaganzhe. (Imi tule we kaka apchogalil, mag itogelen, nabirin.) ");
INSERT INTO kvnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tenal tule-neg-uwas-askin-pukmalal, melle neg-yabal pal togo immalmal weigal, ilgwen neenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tenal tule nagnugangin kudimalal, melle negzhe pal tagmalo molmal amigal; ilgwen aka neenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Tegin te ibegin omegan-ponigwal-kwichimalad, tegin omegan-nuskan-nunanimalad poni-peyedzhe-nooedbal peyedzhe wilemalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tenal pemal peyedzhe Pabzhe kolenabmal, we immal melle neg-peyedzhe-tampedgin kunonigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","¿Ibiga an teob pemalga chog? Imi te ibegin Pab-neg-opinnijad-akar imisgwadzhe teob peyedzhe tule-wileged kwen kudijul, tegin we poni-kunaid-cholbal weob peyedzhe neg-wileged pal kwen nonikojulbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Imi Pab Tummad we ibe-puled chikojulilen, tulemal kwen unniguojulmaloen, pél purkwemaloen. Tenal Pab Tummad tule-chusmalad-pilaledbal ibe-puled chiko melle tule-chulesmalad twagdar wilegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tegin Pab-tule-oturdaked-wilub-omodanikil, tule-wal-walgwen pega chunmanoniko: ‘Imi pe tak, Pab-akpene-chogzhad-palmidagoed-tule itije noni.’ Chulil, tule pega chogdabalo: ‘Pab-akpene-chogzhad-palmidagoed-tule wépal pato noni.’ Tenal pedin melle we tulebal ibzhao. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Tenal te ibegin tule-Pab-akpene-chogzhad-palmidagoed-chunchunnadzhulmalad noniko, tegin tule-Pab-kaka-palchoged-chunchunnadzhulmalad nonimalmogo. Tenal we tulemal immalmal-taktijulid imanonimalo yami oyogal e-chunmaked ib-chunchunnad. Tenal we tulemal Pab-itoleged-tule-chusmalad-yardabi-kunonimogoen, tenal tule-Pabbal-chulesmalad yardalegojul-kuo, pinche tulemal-yogasalmalad yardalenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Wijir, nue aga pe takermal. Imi antin iktualeba pemalga pato pél chogzhado kujal igi neg-kuoed.” ");
INSERT INTO kvnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tegin Jesús chogalbal: “Imi tule-peyedzhe-wilesmalad-cholbal, ampa te ibegin tadgwadin akinnoniko, tegin nidin neg pal kwen otalogojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tegin iskwadin nikpa-akar apatnoniko; tegin nikpa-neg-kannalejiid pela-pela tutumanoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tegin Jesús chogalbal: “Imi te ibegin tulemal taknonimalo an-Te-Tule-Chunna mogil-impabal-tani pela-pela kannalegedgin tegin pela-pela nugu-taklegedgin aktedani. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tenal antin, pel-kwapa-nap-naid-ugakche, naga angelmal-palmido, tule-an-tar-chusmalad-weinegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Imi pemal wag-islub-chapigin turdakenabmal. Imi pe wag-islub-chapi takalil, e-aan-purwiganabal mullu-mullu ampagunoni, tegin pe takalbalil e-kamal aknidanimalbal, wedin choglejun neg pato yol omodani. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tenal pemal wag-islubgin turdajad-yopí, an-imis-pega-chogzhadyob pe neg takalmalal, pemal pato wisgunonimalmogo an-Te-Tule-Chunna-kannan-tanikid pato iti-pakal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Imi an chunchunnad pemalga chogdo: imi tule-te-ibegin-pukmalad yo purkwemaladdu, an-pega-chogzhadyob keg-chulgu kued-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Imi nikpa-neg tegin iti-nap pelgunoniko, tenal an-immal-chogzhad keg-chulgu kued-wilub, an-kakapurwa kwen perienguojul-kuo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tegin Jesús chogalbal: “Imi Pab-Machi-iti-napche-tanikoed tule-pel-kwen-wichulmal, angelmal-pel-wichul, Pab-Machi aga tukin pel wichulmo. Tenal Pab Tummadbi wiis, ibi-ibegin ibi-wachigin Pab-Machi kannan taniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tenal pemal kuakwa timalo, melle an-tanikoedgin pe pinzhejul-kuo. Tenal pemal wichul antin inkwa pemalzhe natapo. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Imi an-chunmajad, tule-mani-ibed neg-kwebur-pidzhe nejogalidgin, aga e-mosmalga pél e-immalmal ebejadyob. Imi we tule mosmal-ilbal, e-immalmal ebes ega takegal. Tegin tule-mani-ibed mos-walgwen ebesbal mutik ega neg-algegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Tenal tule-mutik-neg-alge-tiidyob, pemal kuakwá tiinabmalmo. Imi pe wichulmal inkwa pe-tummad noniko, chedo-dewa, neg-kabgwen-dewa, kallin-namakedbal-dewa, neg-tal-tal-dewa, wichulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Al pe kuakwa tiinabmal pe-tummad arpak nonikoedgin melle kabzhii pe-taknonigal. ");
INSERT INTO kvnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Imis an-pega-chogzhad pemalgabijul, tenal tule-pel-kwapa-ankin-ibzhemaladga, an chogmo: ‘Tenal an-tanikoedgin, pe kuakwa tiinabmal.’ ” Teob Jesús chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Imi teun Pab-Najad-Itoged ibabo-napidgin, tegin Madu-Ina-Nikchulid-Itoged ampa ibabo-napimogadgin, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad-e-tummagan igal-aminanimal otukal Jesús-kagal tar-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tenal we tule-tummagan-pel-kwapa chogalmal: “Imi anmal Pab-Najad-Itoged-naidgin melle Jesús-kamalo. Tegil tulemal ulualmalal, neg-impabal aknidmalo anmalbak urwegal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tegin Jesús Betania-neg-kweburgin-maidgin, Simón-lepra-poni-nika-nad-e-negzhe nad. Tegin Jesús mas-kunpukwadgin, ome-walgwen pudegin ti-wawad-nardo-karked cheinoni. Tegin we ome pude-tukal pichis, tegin Jesús-chaglagin ti-wawad imas. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tenal tulemal-Jesúsbak-mes-pukmalad-wal-walgwen istar ome-takalmalgu, aga emal-emal chunmakalmal: —¿Imi we ome ibiga pinche ti-wawadgin mani owes-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tenal tule-pirkagwen-arpaged-wilub-manigin ti-wawad ukchalen, pul nabirin, tule-wilemalad-pentagal. Al tulemal peyedzhe omeje ulualmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tenal Jesús tulemalga chogal: —¿Ibiga pe we omegin urwenanimal-wede? Meke chii. Imi we ome anka ib-nued imas. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","8","Tenal we ome an-purkwed-iktual, ankin ti-wawad imas, tule-tigzhogalidyob. Imi tule anka immal ukpiel, imis anka ukenab. Tenal antin pemalbak ilgwen-nadgu peinejul, tenal tule-wilemalad kwen chulguojul-kuo. Al pe inkwa tule-wilemaladga immal ukpídin, akalzhul pe ukodo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Tenal an chunchunnad pemalga chogdo: imi iti-napkin meke-pia an-kaka-nuegan choglegoedgin, we ome imis ankin-ti-wawad-imajad ampa choglemogo, tulemal omegin wis pinzhemalgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tegin Jesús-e-chapingan-walgwen-Judas-Iscariote tule-irwal-Pabzhe-kolmalad-e-tummaganzhe nad, Jesús-ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tegin tule-tummagan itosgu Judas emalga Jesús-uknoni, tummagan welgusmal. Tegin Judio-tummagan Judasga kaka-ukchamal Judasga mani ukegal. Tegin Judas igal-aminaigual, tulemal-pukchulidgin tule-tummagan Jesús-kamalgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tegin Madu-Ina-Nikchulid-Itoged kepe naigusgu. Imi te ibegin kusgu igal-maidbal Pab-Najad-Itoged wisgugal oveja-chapini-mesmalbal. Tegin Jesús-e-chapingan Jesúszhe ekichialmal: —¿Tummad, pia pe pei, anmal pega neg nudamalgal, Pab-Najad-Itogedgin mas kunmalgal? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tegin Jesús walbo aga e-chapingan-palmijogalgu, chogal: —Imi pe neg-kweburzhe nemalo. Tenal pemal neg-kwebur omojal, pe tule-machered-walgwen-taknatapo, metegin ti cheinatap. Tenal pe we tule-cholbal nemalo, e-negzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tegin pe neg-yabal togzhal, pe tule-neg-ibedga chogo: ‘Imi tule-oturdaked chog: ¿Pia negde chii, an naga chapinganbak Pab-Najad-Itogedgin, mas kunkal?’ ");
INSERT INTO kvnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tegin tule-neg-ibed pega nikpa neg-tummad oyogo. Imi we neggin pél immalmal nika. Tenal pemal we neggin anmalga mas-kunned tumalo itoged itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tegin Jesús-e-chapingan-walbogid nadmalzhun. Tenal we tule-walbogid neg-kwebur omosgu, Jesús-chogzhad-yopí we tulega kunoni. Tegin we tule-walbogid Pab-Najad-Itogedgin-mas-kunnoed tusmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tenal Jesús chedokí aga e-chapinganbak noni. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tegin Jesús aga e-chapingan-walambe-kakabogwadbak mes mas-kunpukwadgin, e-chapinganga chogal: —Imi an chunchunnad pemalga chogdo: imi pemal-walambe-kakabogwad-walgwen-anpak-mes-mas-kunpukwad ankin akpinnoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tenal Jesús-e-chapingan pukib-itononimalgu, e-chapingan-ilbal Jesúsga chogalmal: —¿An pegin akpinnonikodé? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tegin Jesús aga e-chapinganga chogal: —Tenal pemal-walambe-kakabogwad-walgwen, anpak mes madu wartichajal, we tule ankin-akpinnonikoed. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Imi Pab-kartagin nermakal-maidyob, an-Te-Tule-Chunnagin kunoniko. Tenal tule-ankin-akpinnonikoed oturdalegoedbal peyedzhe wilesma. Imi we tule pul mimmileszhulilen, pul nabirin. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tegin Jesús aga e-chapinganbak ampa mas-kunpukwadgin madu chus. Tegin Jesús tog-nuedi Pab Tummadga chogzha. Tegin Jesús purwi-purwi madu pipichisgu aga e-chapinganga madu ukcha. Tegin Jesús aga e-chapinganga chogalbal: —Chu, pemal kunmal. Wedin, an-chan. Tegin Jesús-e-chapingan madu kuchamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tegin Jesús kobed chusbalgu, tog-nuedi Pab Tummadga chogzhabal. Tegin Jesús aga e-chapinganga kobed ukchabal. Tegin Jesús-e-chapingan-pel-kwapa kobed kobzhamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tegin Jesús aga e-chapinganga chogal: —Imi we kobed, an-abe. Tenal an-abedin oyonai, Pab-Tummad-kaka-pin-ukchad ib-chunchunnad tule-abonogal. Al an-abe ichejul tule-anal milenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Imi an chunchunnad pemalga chogdo: an imis-akar uva-nis pal kwen kobojul, an te ibegin Pab-neg-takmaidgin uva-nis koboedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tegin Jesús aga e-chapinganbak namakedgin Pab-otummosmalgu, ilgwen nadmal Olivo-yalzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tegin Jesús aga e-chapinganga chogal: —Imi pemal-pel-kwapa an-ebemalo, Pab-kartagin-chogzhadyob. Imi Pab Tummad e-kartagin purpal chogzhado: Antin oveja-taked-mejo, tegin ovejamal akne-akne abarmadmalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tegin Jesús chogalbal: —Tenal an kannan tullejal, an pe-iktual Provincia-Galileaje nao. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tegin Pedro Jesúsga chogal: —Imi tule-pimalad pél pe-midmalal, tenal antin pe-kwen-metojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tegin Jesús Pedroga chogal: —Imi an chunchunnad pega chogdo: imis-neg-kabgwen ampayo kallin-mastad ilbo namakeddu, pedin ilapá ankin chognoniko: ‘An Jesús-kwen-wichul.’ ");
INSERT INTO kvnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tenal Pedro Jesúsga chogal: —Imi an chunchunnad, napírra pega chogmodo: antin pegin kwen chogojul: ‘An Jesús-kwen-wichul.’ Tenal an akalzhul pebak mes purkwemogo. Tegin Jesús-e-chapingan-pimalad, ampa Pedro-chogzhad-yopí chogzhamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tegin Jesús aga e-chapinganbak nadmalzhun Getsemaní-neg-nugadzhe. Tegin Jesús Getsemaní omosmalgu, aga e-chapinganga chogal: —Imi pemal wegin peimalgwelo. Tenal antin webal Pab Tummadzhe wis kolnegwelo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tegin Jesús walapá aga e-chapingan-ches: Pedro, Jacobo, tegin Juan. Tegin Jesús ega ib-kuoedgin peyedzhe-pukib-itononikidbal, chuli-pinzhe-kual. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tegin Jesús aga e-chapingan-walapágwadga chogal: —Imi an ulubzhe-pakal peyedzhe-pukib-itogedbal ankin purkwed-ode. Imi pemal wegin an-abintagwelo. Tenal pemal melle kabmalo, pe Pabzhe kolmalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tegin Jesús iche-ukin wis nadgu, ilgwen napkin askun megwitap. Tegin Jesús Pab Tummadzhe kolalzhun: “Pe anka nabir nunmaked ochulogelen, nabirinye.” ");
INSERT INTO kvnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tegin Jesús Pab Tummadga chogal: “An-Pabye, pega pel-kwapa nabir immal kuye. Imi antu-igal-puled-chiidgin an-peyedzhe-wilegoed melle ankin kuelen, nabirinye. Tenal an-itolegedbal chul, tenal pe-itolegedbal pe an-imakoye.” ");
INSERT INTO kvnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tegin Jesús Pabzhe kochagu, kannan e-chapinganzhe nonibal. Tegin Jesús taknoni e-chapingan pato kabmamimal. Tegin Jesús aga e-chapingan otasgu, Pedroga chogal: —Simón, ¿pemal pato kabbukmalyé? ¿Imi pemal wachilgwen pel atabijulmalyé Pabzhe kolgal? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Imi pemal atagenabmal. Tegin pe Pabzhe kolenabmalbal melle imis-immal-kuoedgin wilub-taklegal, tegin pe melle an-midmalgal. Tenal pe-purpa peien Pabzhe kolgal, tenal pe-chandin lolló. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tegin Jesús kannan Pabzhe kolnadbal. Tegin Jesús tetual Pabzhe kochad-yopí, kannan Pabzhe kolalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tegin Jesús kannan e-chapinganzhe nonibalgu, e-chapingan-taknonibal pato kabbukmalbal. Tegin Jesús aga e-chapingan-otasgu, e-chapingan agus-agus chunma-pesmal, peyedzhe kin kabed nakwedbal. Tegin Jesús kannan nadbal Pabzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tegin Jesús ilapá-akpiredgin kabbuk e-chapingan-taknonigu, aga e-chapinganga chogal: —¿Imi pe ampa kabmamimal ampa ulukumamimalyé? Imi Pabzhe-koled pato pelgus. Imi an-wilub pato omos, an-Te-Tule-Chunna tule-iskanaje uklegal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Imisgin pe kwisgumaldo, nemal. Imi tule-an-ukchad pato wegin tani. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tegin Jesús ampa aga e-chapinganga chunma-kwichidgin, Judas-Jesús-e-chapingan-walambe-kakabogwad-walgwen noni. Tegin tulemal-ichejul Judasbak irmanonimalmo. Tenal tule-nonimalad es-pilacheed-annik nonimal. Tegin we tulemal chowal-oro-annik nonimalbal. Tenal tule-nonimalad: tule-irwal-Pabzhe-kolmalad-e-tummagan, tegin Moisés-igalgin-tulemal-oturdamalad, tegin Judio-chelegan-tar-palmialmalad Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Imi teun takalgu, Judas-Jesúsgin-akpitchad iktual tule-nonimaladbak igal-mezhis, we tulemalga chogzha: “Imi anmal we tule-abingujal, igal-mamikidbal e-wagal-us pe an-takel, we tule pe kao chulub-abalgin cheedgal.” ");
INSERT INTO kvnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Al Judas ilgwen Jesús-abir kwisgunonigu, Jesúsga chogal: —Anná. ¿Tule-oturdaked, pede? Tegidgin Judas Jesús-wagal us. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tegin tule-nonimalad takchagu Judas Jesús-wagal us, Jesús-kasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tenal Jesús-e-pakad-aka-kwichimogad es unnusgu, tule-irwal-Pabzhe-kolmalad-pul-tummad-e-mos-chikten, chuchubi kaledap-idirrí. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tegin Jesús tule-e-kasmaladga chogal: —¿Ibiga pemalde, es-pilacheed-annik tegin chowal-oro-annik an-kadanimal-wede, an kantikidgin-immal-aturzheed-tuleyob? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Imi antin pane-pane Pabzhe-koled-neggin tulemal-oturdadi-kus. Tegin pemal Pabzhe-koled-neggin anpak mes kudigusmalmo. Tenal pemal yabli an-kwen-kabijulmal. Tenal antin chog, nabir weob kus, Pab-kartagin nermakal maidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tenal Jesús-e-chapingan-pel-kwapa wakismal, unnila Jesúsbi walkwénna pes. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Imi teun tulemal Jesús-pakad-walgwen-takalmal, atuedgin ebirmakal kwichi. Tenal tulemal-Jesús-kasmalad atuedbal machi-kasmalgu, ");
INSERT INTO kvnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","we machi sapejul-kualidgin pel atued ebes, chwili abarmad, ilgwen wakis. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tegin tulemal-Jesús-kasmalad tule-irwal-Pabzhe-kolmalad-pul-tummadzhe Jesús-chesmal. Tegin tule-tummagan pel-kwapa nonimal; tule-irwal-Pabzhe-kolmalad-tummagan, Judio-chelegan-tummagan, tegin Moisés-igalgin-tulemal-oturdamalad, pél ormanonimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tenal Pedro untar-panku Jesús-cholbal pinna-pinna tule-tummad-neg-chiid-impabal nonimo. Tegin Pedro neg-impabal chulubmalbak chowaji-pesmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan, tegin Judio-tummagan-wala-tulapá-kakaambegwad, walabo tule-aminaigualmal yopí chogmalgal, Jesús Pab-Tummadgin-atajulidbal purkweenab. Tenal tule-tummagan tule-kwen-onoszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tenal tulemal-ichejul pinche Jesúsgin kakanzhasmalan, tenal we tulemal yopí kwen chogzhajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tegin tule-wal-walgwen pinche Jesúsgin chunmakalmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Imi anmal we Jesús-itos, choge, ede Pabzhe-koled-neg-tule-chobzhad eyarne. Tegin ede ibapágin kannan neg-pid chobbalo, tenal tule pal kwen chobojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tenal we tule-walbogid-Jesúsgin-kakanzhenanimalad yabli aga yopí kwen chogzhajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad Judio-tummagan-wagin kwisgual, Jesúszhe ekichial: —¿Imi tule-pegin-chogzhadgin pe chogojulmoyé? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tenal Jesús yabli ilgwen yakír pes, kwen abin-imaszhul-kus. Tegin tule-irwal-Pabzhe-koled-pul-tummad kannan Jesúszhe ekichialbal: —¿Pede, Pab-akpene-chogzhad-palmidagoed-tulejí? ¿Pede Pab-Tummad-pul-otummolemaid-e-Machijí? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tegin Jesús we tule-tummadga chogal: —Antin Pab-Machido. Tenal pe kujal an-Te-Tule-Chunna-takmalo, Pab-Tummad-kannaleged-nikad-nuedzhik tule-tummadga chii. Tegin pe an-takmalbalo, nikpa mogil-impabal aktedani. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad istar Jesús-chunmajad-itojadbal aga chiir mol imas. Tegin we tummad Judio-tummagan-pimaladga chogal: —Imi we tule-chunmajad istar Pab Tummadgin chunmas. ¿Ibiga anmal tule-pid-pal-amio we Jesúsgin chunmagal? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Imi pemal pato ual itosmal, ede igi istar Pab Tummadgin chunmas. ¿Pemal igi chogmalmode? Tegin Judio-tummagan-pel-kwapa chogalmal: —Imi we Jesús keg-chulgu purkweenab. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tegin tulemal Jesúsgin kwi mialmal, tegin molgin Jesús-imia etismalgu, Jesús-sakialmalzhun, tegin Jesúszhe ekichialmal: —Imisgin anka pe chogdo, ¿toa pe-sakis-wede? Tenal Jesús tule-e-sagyenanimaladga kwen chogzhajul-kus, ilgwen yakir pes. Tegin chulubmal Jesús-wagal ebiosmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tenal Pedro ampa neg-impagin-chiidgin, puna-walgwen-tule-irwal-Pabzhe-kolmalad-pul-tummad-e-mos Pedro-takal, chowaji. Tegin we puna Pedroga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","—¿Pede, Jesús-Nazaretkinedbak-naneed taklebalí? ");
INSERT INTO kvnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tegin Pedro punaga chogal: —An wichí, pedin ibigin chunmanai. An we tule-kwen-taktijuli. Tegin Pedro kwisgudgu, ilgwen wanagakche kwisgunoni. (Tegidgin Pedroga kallin-mastad namakalzhun.) ");
INSERT INTO kvnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tegin puna kannan Pedro-takalbalgu, tulemal-pukmaladga chogalbal: —We tule Jesús-pakadmo an taked. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tegin Pedro kannan chogalbal: —¡An wichíwa! Tegin apka te-cholbal, tule-walgwen-aka-chimogad, Pedroga chogalmo: —Tenal pedin chunchunnad Jesús-pakadmo taklebali, pe-kaka-chunmaked, Galilea-tol. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tegin Pedro tule-pukmaladga chogal: —An chunchunnad Pab-wagin pemalga chogdo: an we tule-kwen-wichul, pemal kin chunmananimalad. ");
INSERT INTO kvnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tegidgin, kallin-mastad kannan namakalbal, wegin ilabogus. Tegin Pedro kep wisgual, akpene igi Jesús ega chogzhagujad: “Imi yo ilbo kallin-mastad namakeddu, pedin ilapá ankin chogdago: ‘An Jesús-kwen-wichul.’ ” Tegin Pedro peyedzhe pukib-itogalgu, kep peyedzhe poalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tegin neg-oiposgu, tule-irwal-Pabzhe-kolmalad-tummagan, tegin Judio-chelegan-tummagan, tegin Moisés-igalgin-tulemal-oturdamalad tegin Judio-tummagan-wala-tulapá-kakaambegwad pel-kwapa ormasmal. Tenal Judio-tummagan Jesúsga pél igal-itosmalgu, chunkalbal-kugmakal Jesús-chesmal, Pilatoje. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tegin Judio-tummagan Pilatoga Jesús-ukchamalgu, Pilato Jesúszhe ekichial: —¿Pede, Judiomal-erreyzhí? Tegin Jesús Pilatoga chogal: —Antin pe-chogzhad-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan ampa ichejul Pilatoga Jesús-tuktinanimal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tegin Pilato kannan Jesúszhe ekichialbal chogal: —Imi we tulemal melugus pe-tuktinanimal. ¿Pe abin-imakojulmoyé? ");
INSERT INTO kvnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tenal Jesús ilgwen yakir pes, Pilato-kwen-abin-imaszhul-kus. Tegin Pilato Jesús-takchagu ilgwen yakir pes, weob pakal pesbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Imi teun Romano-igal kusgu mai, Pab-Najad-Itoged-ilbal, Judio-tulemal-chogedbal keg-chulgu tule-walgwen-oturdalemaid-onolenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Imi teun takalgu, tule-Romanomalbak-ulusmalad oturdalemamimal. Tenal we tulemal-walgwen nug Barrabás. Tenal Barrabás Romanomalbak-urwenanikidgin tule-mecha. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tegin tulemal Pilatoje nonimalgu, chogalmal: —Imi pedin, Romano-igal-mamikidyob pe imakenab. Pe anmalga tule-walgwen-onogenab. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tegin Pilato tulemalga chogal: —¿Imi pemal peimal, an pega Judiomal-errey-onogo o chul? ");
INSERT INTO kvnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tenal Pilato wisdo, Judio-tummagan Jesúsgin nobedbal, eje Jesús-cheinonimal Jesúsga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tulemalga kannan-kannan chognaigualmal: —Imi pemal Pilatoga chogmalo: ‘Pe melle Jesús-onogo, Barrabásdin pe onogo.’ Tegin tulemal Judio-tummagan-chogzhadyob Pilatoga chogalmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tegin Pilato kannan tulemalga chogalbal: —¿Imi pemal-chogmalad-Judio-errey an igi imakel nabirzhun? Anka pe chogmaldo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tegin tulemal kannan sapejul kolmakalmal chogalmal: —¡Pe nakrusgin we tule-pioko! ");
INSERT INTO kvnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tegin Pilato tulemalga chogalbal: —¿We tulede ibi-akalos-ade an tar-piokkal? Tenal we tulemal pul-sapejul kannan kolmakalmalbal: —¡Pe nakrusgin we tule-piokoma! ");
INSERT INTO kvnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tenal Pilato tulemalbak-nabir-peigal, Barrabás-onos. Tenal chulubmal yo nakrusgin Jesús-piokeddu, Pilato chulubmalzhe Jesús-palmis Jesús-ebiogal. Tenal Pilato igal-ukchabal, nakrusgin Jesús-piokkal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tegin chulubmal Gobernador-neg-impaje Jesús-cheinonimal. Tegin chulubmal pel-kwapa e-pakamalad-aka-pukwamaladzhe kochamalgu, ");
INSERT INTO kvnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesúsgin mol-erreygadgiid yosmal. Tegin chulubmal tub-iko-nikad kwilomasmalgu, Jesús-nonogin iko-kurkin chismalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tegin chulubmal yami Jesúsgin todoalmal, Jesúsga chogalmal: —Judio-erreyye, imi pe ilgwen tule-tummadga maielen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tegin chulubmal kabastongin Jesús-nonogin-iko-kurkin-chiid sakialmal. Tegin chulubmal Jesúsgin kwi mialmalbal. Tegin chulubmal yami Jesús-abir chimtinanimal. Tegin chulubmal yami Jesús-otummonanimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tegin chulubmal Jesúsgin pél todosmalgu, Jesúsgin errey-molgiid echusmal. Tegin chulubmal kannan Jesúsgin egad-mol yosmalbal. Tegin chulubmal nakrusgin-piokkal Jesús-chesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tegin chulubmal igalbal Jesús-cheinatapmaladgin, tule-walgwen-Simón-nugad-abingus. Tenal we tule, Cirenegined, Alejandro-tegin-Rufo-e-pab. Tegin chulubmal kantikidgin kannan Simón-obiris, Jesúsga nakrus chedgal Gólgota-yal-nugadzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wedin chogle: Tule-Nono-Kal-Yal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tegin Jesús Gólgota-yalzhe nonigu, chulubmal Jesúsga vino-mirrabak-obural-uknanikin kobgal, Jesús melle twagdar nakpi-itogal. Tenal Jesús yabli chulubmalga vino kwen kobzhajul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tegin chulubmal nakrusgin Jesús-piokchamalzhun. Tegin chulubmal Jesús-e-molgin todoalmal, toa pul-melu aga mol chumalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Imi teun chulubmal wachilbakebakkin nakrusgin Jesús-piokchamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tegin chulubmal nakrus-tukugin nermakal karta nazhismal tulemal wisgal ibiga Jesús-purkweenab. Imi we kartagin nermakal naido: ");
INSERT INTO kvnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Imi teun chulubmal nakrusgin egek walbo tule-immal-aturzhemalad-piokchamalmo; kwéntin Jesús-nuedzhik, kwéntin Jesús-chapilezhik. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Imi akpene Pab-kartagin nermakal-maid-yopí Jesúsgin kus. Imi Pab-kartagin Jesúsgin chogzhado: Imi tulemal, tule-iskanayob we tule-takmalo.) ");
INSERT INTO kvnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tegin tulemal-igalbal-irmamamimalad Jesúsga chagla pin-pin imakaldamal, tegin Jesúsgin todoaldamalbal. Tegin tule-irmamamimalad Jesúsga chogalmal: —¡Pe takcha! Pede chogedde. ‘Pabzhe-koled-neg eyarne, tegin an ibapágin kannan chobbalo.’ ¿Tede pede igi kudzhun? ");
INSERT INTO kvnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Imisgin pe aga tukin aga abonodo. Pe nakrusgin-naid-akar aktedo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan, tegin Moisés-igalgin-tulemal-oturdamalad ampa tule-irmamamimaladyob istar Jesúsgin aga emal-emal chunmakalmalmo chogalmal: —Imi we Jesús tule-pimalad-abonos. Tenal Jesús aga tukindin keg aga abonogus. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Imi Jesús Israel-tulemal-e-erreyel, tegin Pab-akpene-chogzhad-palmidagoedil, anmal-wagin nakrusgin-naid aktejal, anmal kep we tulegin ibzhenonimalo. Tegin tule-walbo-immal-aturzhemalad-Jesúsbak-mes-pioklesmalad, Jesúsgin todoalmalmo, tegin Jesúsgin istar chunmakalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tegin yoroku-akar wachilapáje neg-pel-kwapa chichidbi naigus. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tegin Jesús wachilapágin sapéjul kolmas, e-kakagin chogal: —Eloi, Eloi, ¿Lema sabactani? (Wedin choglege: An-Pab-Tummadye, An-Pab-Tummadye, ¿ibiga pe an-meteye?) ");
INSERT INTO kvnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tegin tule-aka-kwen-pukmalad Jesús-chogzhad itosgu, chogalmal: —Pe pito. We tule Pab-kaka-palchoged-Elías-akpenegwadzhe kolnai. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tegin tule-walgwen Jesús-kolmajad itosgu, upchanyob immal-tutugin vino-kaled wartichas. Tegin tule-Jesús-okobzhognainad chowal-tukugin immal-tutu yos Jesús-okobgal. Tegin tule Jesús-okobnaid, tule-pimaladga chogal: —Tegil meke naido; anmal takmalgwelo, Elías pule nakrusgin-naid-akar we tule-odenoniko-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tegin Jesús pul-sapejul kolmasgu, ilgwen purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tenal teun Jerusaléngin, Pabzhe-koled-neggin Pab-irwal-mol-naid, apallala islis, nikpa-akar ulpalidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tegin Romano-chulub-tummad-Jesús-abir-chiid Jesús-purkwijad takchagu, chogal: —We tule chunchunnad Pab-Machi-chunnaddo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Imi teun María Magdalena, tegin Jacobo-totogwad-tegin-José-e-nan-María, tegin Salomé tegin omegan-pimalad, panna Jesús-takpukmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tenal we omegan Jesús-Galileagin-tiidgin, Jesúsbak mes pipirmadi-kusmalad, tegin pirkin Jesús-pentadi-kusmalbalid. Tegin omegan-pimalad-ichejul Jerusalénzhe Jesúsbak-mes-nonimalad, panna Jesús-takpukmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tegin tad arkwandanigu, ulukued-ibe iktual immalmal-cheed-ibe-naidbal, ");
INSERT INTO kvnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José-Arimatea-tol tobzhulidgin Pilatoje nad, Jesús-mui ekisgal. Tenal we Josédin, Judio-tummagan-wala-tulapá-kakaambegwad-walgwen. Tenal José tule-nuedbal. Tenal José Pab-neg-takmaid takpi-kudimogan. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tenal José Pilatoje Jesús-mui ekisnatapidgin, Pilato weob pakal pes. Tegin Pilato Joséga chogal: —¿Ade Jesúsde pato purkwiszhí? Tegin José Pilatoga chogal: —Pato purkwisdo. Tegin Pilato Romano-chulub-tummad-Jesús-takchadzhe kocha ekisgal: —¿Chunnají, Jesúsde pato purkwiszhí? ");
INSERT INTO kvnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tegin chulub-tummad Pilatoga chogal: —Pato purkwisdo. Tegin Pilato Joséga igal-ukcha akalzhul Jesús-mui chedgal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tegin José algu, mol-chibu pake-al. Tegin José nakrusgin Jesús-mui-naid odesgu, mol-chibugin Jesús-mui ebirmas. Tegin José kep uanzhe Jesús-mui cheszhun tignegal. Tegin José uanzhe Jesús-mui chesmalgu, akwa-tummad-ya-akialed-yabal Jesús-mui tigzhamalzhun. Tegin José uan-ya-kakagin akwa-tummad chisbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tenal María Magdalena, tegin José-e-nan-María, panna Jesús-mui-tigzhamalad-takchamal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tegin ulukued-ibe nasgu, María Magdalena tegin María-Jacobo-e-nan tegin Salomé ti-wawad pakchamal Jesús-muigin imagal, Judio-igal-kusgu-maidyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Imi teun Maríamal tumigin wakur tad-nakwija uanzhe nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tenal Maríamal igalbal-natapidgin, aga emal-emal chunmakalmal: —¿Toa anmalga akwa-tummad-uan-ya-chaktijiid oniro-wede? ");
INSERT INTO kvnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tegin Maríamal panna-akar takchamal, akwa-tummad uan-ya-chaktijiid, pato oniral chii. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tegin omegan takchamalgu uan-ya-kagejii, uan-yabal togzhamal. Tegin omegan takalmal Jesús-megwijad-nuedzhik tule-machibi chii, mol-chibu mood-yowi. Tegin omegan peyedzhe we tulegin kwakialmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tenal machi omeganga chogal: —Pe melle tobgumalma. ¿Pemal Jesús-Nazaretkined-nakrusgin-pioklejad-amimalyé? Imi we Jesús pato kannan tulleja, wegin maichul. Pe takmaldo, tulemal wegin Jesús-mui mezhismalan. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Imi pemal nemalo Pedroga chogne, tegin Jesús-e-chapingan-pimaladgamo. Imi Jesús pe-iktual Galileaje ne. Tenal Jesús Galileagin pe-takmalo, Jesús akpene pega chogzhadyob. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tenal omegan pela-pela kwakijadbal, tutumakal-pesmal. Tegin omegan chuli-pinzhe-pesmaladbal uan-akar nosmalgu, ilgwen negzhe abarmadmal. Tenal omegan peyedzhe kwakismaladbal tulemalga apka kwen chogzhajulmal, uangin emalga igi immal kujad. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Tegin Jesús tumigin polegu kannan tullesgu, kannan-kannan tule-Jesúsbak-nanedi-kusmaladga nononida. Kepegin María Magdalenaga sanal nononi. Tenal we Maríadin, akpene Jesús kin walakugle nia-onijad. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tenal María Jesús-takchagu, tulemal-Jesúsbak-nanedi-kusmaladzhe nad. Tenal we tulemal pukib-itogedbal pobukmal. Tegin María tule-Jesúsbak-nanedi-kusmaladga chognatap: —Jesús kannan tulles. Tegin Jesús anka sanal nononi. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tegin Jesús-e-chapingan itosmalgu Jesús-kannan-tulles, Maríabal kwen ibzhaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tegin tule-walbo Jerusalén-akar igalbal natapmaladgin, Jesús tule-pidyob we tulemalga sanal nononibal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tegin tule-walbogid kannan Jerusalénzhe tule-Jesúsbak-nanedi-kusmaladga chognadmalbal. Tenal Jesús-e-chapingan tule-walbogwadbal kwen ibzhaszhulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tegin apka te-cholbal, Jesús-e-chapingan-walambe-kakagwenchakkad mas-kunpukwadgin, Jesús e-chapinganga sanal nononibal. Tegin Jesús aga e-chapinganga chogal: —¿Ibiga pe ankin ibzhejulmal-wede? ¿Imi an tullesgu, ibiga pe tulemal-an-takchamaladbal pe kwen ibzhejulmal-wede? Pemal nono-cheleganmalma. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tegin Jesús aga e-chapinganga chogalbal: “Imi pemal pel-kwapa-nap-naid-ugakche pel-kwapa tulemalga an-kaka-nuegan chognao. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Imi meke-ibi-tule ankin ibzheel, tegin an-nuggin tigin oglejal, we tule Pab-tule-oturdaleged-akar abonolego. Tenal meke-ibi-tule ankin ibzhejulil, ankin ibzhejulidbal peyedzhe oturdalego, tenal we oturdaleged ilgwen-nadguo, pal kwen pelguojul. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Tegin tule-ankin-ibzhemalad Pabbal immal-taktijulid imako, tegin an-nuggin nia-onimalo, tegin tule-ankin-ibzhemalad kaka-pimaladgin chunmamalo. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tegin tulemal-ankin-ibzhemalad chunkalgin nakpe-puled-kasmalal, kwen naklikuojulmal, kwen akalguojulmalbal. Tegin tule-ankin-ibzhemalad kobedbak ina-tule-mejed kobzhamalal, kwen akalguojulmalbal. Tegin tule-ankin-ibzhemalad chunkalgin tule-yemalad-ebusmalal, tule-yeed ilgwen nuguo.” ");
INSERT INTO kvnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tegin Jesús pél aga e-chapinganga chunmasgu, ilgwen Pab-negzhe nakwid. Tenal Jesús pul-tule-tummadiidbal Pab-Tummad-nuedzhik chigwitapchun. ");
INSERT INTO kvnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tegin Jesús-e-chapingan-pel-kwapa akne-akne aknismal, Pab-Jesús-kaka-nuegan chognadmal. Tegin Pabdin e-chapingan-pentadi-kualzhun. Tegin Jesús-e-chapingan immal-taktijulid-imajadbal mag taklenoni we igalde ib-chunchunnad. Imi Jesucristo-Pab-Tummad-Machigin chogzhad, weobdo. Pitomalgu.)");
INSERT INTO kvnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Imi teun takalgu, tulemal-ichejul anmal-abalgin immal-kujad nermasmalan. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tenal we tulemal peyedzhe alamadi-kusmal, tule-imial-takchamaladzhe tegin tulemal kepegin-Pab-Jesús-kaka-palchogmalad anmalga inniki Jesúsgin chogzhad-yopí nermasmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tummad-Teófilo, imi an-chunnad an nuekwa kepe-sagla-akar pél Jesúsgin-immal-kujad pal-amis-choggu, al an takto, antin pul nuekwa inniki-inniki Pab-Jesús-igal-kujadgin pega nermanemo. Tenal an takpaldo wedin pul ib-nued. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Imi an pega nermaneed, pe nuekwa pal wisgugal, pe Jesús-igalgin pel-kwapa turdajad, ib-chunchunnad, ib-kakanzhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Imi Errey-Herode Judea-napkin neg-takmaigu, teun tule-irwal-Pabzhe-koled-Abíaszhikid-walgwen maimo. Tenal we tuledin nug Zacarías. Tenal Zacarías-e-ome-Elisabet ampa Aarón-e-wagwamo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tenal we abirginmalad napírra nanemal, al Pab Tummad we abirginmaladgin istar-choged kwen nikchul. Tenal we abirgin pane-pane Pab-chogzhad-pallí igal-mezhijadgin nanedimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tenal Elisabettin kusgu-wichul-nuchu-amiedbal nuchu-kwen-nikchul. Tenal we abirgineddin pato chelegangus, nuchu-nikued-wilub okpis. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Imi te ibagwengin, Abíaszhikmaladga wilub noni Pabzhe-koled-neggin arpagal. Tenal teun takalgu, Zacarías Pabzhe-koled-neggin ampa tule-irwal-Pabzhe-koledga arpadimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tegidgin Zacarías tule-irwal-Pabzhe-koled-igal-maidbal chulenoni, Pabzhe-koled-neg-yabal toggal, tegin Pab Tummadga immal-wawad kuggalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tenal teun takalgu, tule-Pabga-immal-wawad-kuged-wachi omosgu, tulemal-pel-kwapa magadbal aknidamal Pabzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tegin Zacarías Pabzhe-koled-neg-yabal togzha Pabga immal-wawad kuggal. Tegin Zacarías Pabga-immal-wawad-kuged-kwichid-nuedzhik kwisgunoni. Tegidgin Pab-angel arpak Zacaríasga nononi. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tenal Zacarías Pab-angel-takchagu, weob pakal pes, tegin Zacarías angelgin kwakialbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tegin Pab-angel Zacaríasga chogal: “Zacarías, melle pe an-tobguma. Imi Pab Tummad pe-eje-koled itos. Imi pe-ome-Elisabet pega machi-nikune. Tenal pe machi-nugzhao, Juan. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tenal we machi pega mimmilenonikil, pemal we machigin welgumalo tegin pemal ulubgin pela-pela weligwal itononimalbalo. Tenal tulemal-ichejul pe-machi-mimmilejadbal peyedzhe welgumalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Imi pe-machi Pab Tummadga tule-tummadga kunoniko. Tenal we machi keg vino kobel, tegin keg inna-kabil kobbalil. Tenal we machi e-mimmilejad-akar pela-pela Pab-Purpa-Nued-nika-kudio. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tenal we machi Pab-Tummadzhe-akpirgal íchejul Israel-tulemal-imanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tenal pe-machi-Juan Pab-akpene-chogzhad-palmidagoed-tule-iktual ne, tenal Juandin Pab-kaka-palchoged-Elíasyob kannaleged nikunatapmogo. Tenal Juan aga pilalgugal pabgan-istar-aga-nuskan-taktimalad-imanoniko. Tenal Juan tule-pirkin-pirkin-tamalad-pinzheed ogwabalo tule-yer-pinzhemaladyob. Tegin Juan Pabga kuakwa tule-urpemalbalo Pab-tule-palmidagoed-abingegal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tegin Zacarías angelga chogal: —Nabir pe chogendo. ¿Tenal an igi wisguo pe-anka-chogzhad ib-chunchunnad? Imi antin tegin an-ome anmal pato cheredgusmal, anmal nuchu-nikued-wilubzhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tegin angel Zacaríasga chogal: —Imi antin, an angel-Gabriel. Tenal an Pab-Tummad-waglika arpagedga kwichi Pab-choged-pallí immal imagal. Tenal Pab Tummad peje an-palmial, pega we kakapurwa-nuegan palchoggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Imi pe ankin-pengujadbal keg-pe-chunma pe peine, an pega immal-chogzhad e-wilubganbal kunonikoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tenal tule-magadbal-Pabzhe-kolbukmalad Zacarías-abintabukmal. Tenal tulemal Pabzhe-koled-neg-yabal owed-owed Zacarías-takchagu, chogalmal: “¿Igi Zacaríasde yabal kude-wede?” ");
INSERT INTO kvnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tegin Zacarías Pabzhe-koled-neg-yabal-akar noalgu, tulemalga pato keg chunma. Tenal Zacarías kobalbi-immal-chogzhadbal tulemal mag takchamal Zacarías Pabzhe-koled-neg-yabal immal-purpaled takcha. Tenal Zacarías keg-chunma-peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tegin Zacarías Pabga-immal-uknaid-arpaged pelgusgu, aga negzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tegin Zacarías angel-takchad-cholbal, e-ome-Elisabettin ponigwal kwisgunonijun. Tenal Elisabet ponigwal-kwisgujad-akar ni-walatal aga e-neg-akar kwen noszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tenal Elisabet aga ulubgin chogalzhun: “Imi Pab Tummad imis-ibegin wilejakwa an-taknonikidbal an-pentas nuchu-nikugal, an-nuchu-nikchulidbal tulemal melle istar an-pal-takegal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tenal Elisabet ni-walanerkwa ponigwal-kwichidgin, Pab Tummad Nazaret-Galileaje e-angel-Gabriel-palminoni puna-yaeje. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tenal we puna-yaedin nug María. Tenal María ampa machered-kwen-omodijulid. Tenal puna-yae-María tule-José-nugadbak aga kaka-ukchamal aga nikumalgal. Tenal Josédin Errey-David-e-wagwa. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tegin angel puna-chiid-neg-yabal tognonigu, punaje kote chogal: —¡Anná, tegidde! Pab Tummad nugu pegin pinzhas. Tenal Pab Tummad chogdo, ede pebak kudii. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tegin María angel weob ega kaka-kolnoni itosgu, mag-itojul-pes. Tegin María aga ulubgin pinzheal: “¿Ibi chogle-wede, anka angel weob chognonikiddé?” ");
INSERT INTO kvnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tegin angel Maríaga chogalzhun: —María, pe melle an-tobguma, Pab Tummad nugu pegin pinzhas. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Imi pedin ponigwal kwisgunoniko. Tenal pe nuchu-nikunonikil, pe machi-nikunoniko. Tenal pe machi-toto-nugzhao, Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tenal we machi-toto tule-tummadga kunoniko. Tegin we machi nug-kunoniko Pab-Pul-Tummad-E-Machi. Tenal Pab Tummad akpene-Errey-David-neg-takmaid-kujadyob we machi-odomogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tenal we machi-Jesús ilagwen-nadgu Israel-neg takmaio, tenal e-neg-takmaid pal kwen pelguojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tegin María angelga chogal: —An nabir itogendo pe-anka-chognonikid. ¿Tenal pe-anka-chognonikid igi kunoniko-ade? An macherganbak kwen nanedijuli. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tegin angel Maríaga chogal: —Imi Pab Purpa Nued pegin aktenoniko, tegin Pab-Pul-Tummad-e-kannaleged pel-kwapa pe-edunoniko. Al pe machi-nikunonikoed machi-chwilidikidga kuo. Tegin machi nugzhalenonibalo Pab-Tummad-Machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tenal pe-kwenad-Elisabettin pato cherediidgin nuchu-nikunonimogo. Imi tulemal Elisabetkin chogmaldo, Elisabet kusgu keg nuchu-ami. Tenal Elisabet pato ni-walanerkwagus ponigwal-kwichid-akar. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tenal Pab Tummadgadin keg chogel immal keg ku, tenal Pab Tummadga pel-kwapa nabir immal ku. Al an-pega-chogzhadyob pega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tegin María angelga chogal: —Tegil nabirde. Tenal antin Pab-Tummad-mosga yer an itomo-choggu, al Pab Tummad akalzhul pe-chogzhadyob ankin immal imakodo. Tegidgin angel ilgwen María-akar nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tegidgin María nadzhun Judea-yalaganbal neg-kwebur-Elisabet-chiidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tegin María Zacarías-neg-maidzhe tognatapku, Elisabetche kolnatap. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tenal Elisabet María-eje-kolnoni itosgu, Elisabet-mimmi sapejul e-nan-ebus. Tegidgin Elisabet pela-pela Pab-Purpa-Nued-nikunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tegin Elisabet sapejul kolmas chogal: —¡Imi Pab Tummaddin egmal-omeganga pul nugu pe-takcha, tegin pe-nuchu-nikuoed ampamo! ");
INSERT INTO kvnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tenal ante ibi-tule-ade, an-Tummad-e-nan an-taktagal? ");
INSERT INTO kvnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tenal Elisabet Maríaga pél chogalzhun: —Imi an kepegin itononigu pe wanagakkin anche kolnai, an-nuchu weligwal-itogedbal sapejul an-ebunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tenal pe Pab-Tummadgin-penzhul-kunonikidbal, Pabdin pega ib-nued imas, tegin Pab-pega-chogzhadyob, pél pega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tegidgin María chogal: Imi antin ulubgin-akar Pab-otummonai. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tegin an-purpa Pab-an-abonogedgin weligwal-itomo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¿Ibiga an weligwal-ito? Nabir. Imi antin tule-pinchegad tenal Pabdin yabli ankin nugu pinzhas. Tenal tulemal imis-akar ukin-ukin-e-wagwagan-ampagumaloed yer an-takti-kumalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tegin Pab-pela-pela-kannaleged-nikad peyedzhe anka immal imas, tenal Pabdin, tule-chwilidikid. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tenal Pab tule-ukin-ukin-ampagumaloed-ilbal keg-chulgu wilejakwa tule-egin-atamaloed-tako. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tegin Pab Tummad aga tukin e-kannalegedgin peyedzhe immal imas. Tenal Pabdin tule-tummarba-itomalad-onis. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tegin Pab tule-tummagan-neg-takmamimalad-onos, tule-tummaganga. Tenal Pab Tummad tule-tummarba-itojulmalad-odos, tule-tummadga. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tegin Pab Tummad imme tule-ukul-mesdimalad-imas. Tenal Pab Tummad chunkal-kwabi mani-ibgan-palmisbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tenal Pab Tummad anmal-tadganga-kaka-ukchadyob immal imas. Al Pab Tummad e-mosmal-Israel-tulemal-pentas. Tenal Pab Tummad kwen igeszhulbal, ");
INSERT INTO kvnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","wilejakwa Abraham tegin e-wagwagan-ukin-ukin-ampagusmalad-takegalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tegin María e-kwenad-Elisabet-neggin ni-walapá chii-peszhun. Tegin María kep te-cholbal kannan aga e-negzhe albal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tegin Elisabet nuchu-nikued-wilubgan nonigu, machi-toto-nikunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tegin Elisabet-kwenamalad tegin e-aimal itosmalgu Pab Tummad peyedzhe wilejakwa Elisabet-takcha, Elisabetpak mes welgusmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tegin Elisabet nuchu-nikujad-ibapábakkin, e-kwenamalad tegin e-aimal Elisabetche nonimal, Moisés-igal-mamikidbal machi-toto-e-abgan-tuku chikegal. Tegin tulemal-Elisabetche-nonimalad e-pabyob machi-toto-nugzhebi-kualin, Zacarías. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tenal machi-toto-e-nan-Elisabet chogal, ede aga e-pabyob machi-kwen-nugzhenejul. Tenal Elisabet chogal: “An-machi nug-kuenab Juan.” ");
INSERT INTO kvnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tegin tule-pukmalad Elisabetka chogalmal: —¿Ibiga pe weob machi-toto nugzhebimal-wede? Imi pe-kwenamalad weob kwen nugzhul-ne. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tegin tule-pukmalad chunkalbal machi-toto-e-pabzhe ekichialmal, igi machi-toto-nugzhebi. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tegin Zacarías tulemalzhe chunkalbal akwa-matarra ekichis akwagin nermagal. Tegin tulemal akwa-matarra cheinonimalgu, Zacarías akwagin nermas: “Machi-toto nug-kuo Juan.” Tegin Zacarías akal-pakal nuchu nugzhajadbal, tulemal-pel-kwapa weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tegidgin Zacarías kannan nabir chunmanonibal. Tegin Zacarías Pab-Tummad-otummoalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tegidgin tule-aka-tikalbal-mamimalad peyedzhe Zacaríasga-ib-kujadbal kwakialmal. Tegin tulemal-Judea-yalaganbal-mamimalad-pel-kwapa Zacaríasga ib-kujadginbi chunmananimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tenal tulemal-pel-kwapa-itosmalad aga ulubgin pinzhedii-pesmal chogalmal: “¿Imi we machide ibi-tule-wede?” Tenal tulemal takchamaldo Pab-kannaleged Juanbak kudii. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Imi teun Zacarías pela-pela Pab-Purpa-Nued-nikunonikidbal, kujal-ib-kuoedgin chunmakal chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Imi Israel-tulemal-e-Pab-Tummad otummodi-kuelen, nabirinye. Imi Pab Tummad kannan aga e-tulemal-ololchasmalye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tenal Pab Tummad e-mos-David-e-wagwabal tule-pela-pela-kannaleged-nikad-palminoni anmal-abonogalye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Imi Pab Tummad akpene e-kaka-palchogmaladbal chogzhagusmo, kujal immal weopí kunonikoye.) ");
INSERT INTO kvnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tenal Pab Tummad tule-anmalbak-aichulmalad-akar anmal-abonogo, tegin tule-istar-anmal-takmalad-akar anmal-abonobaloye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Imi Pab Tummad anmal-tadganga chogzhabal ede wilejakwa anmal-tadgan-takoye. Tegin Pab Tummad anmal-tadganbak aga napírra igal-mezhijad pal kwen igeojul-kuoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tenal we igal-megwijad, Pab Tummad aga e-nuggin tad-Abrahamga kaka-ukcha, ede keg-chulgu we igal imakenabye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tegin Pab Tummad kaka-ukchabalye, tulemal-anmalbak-aichulmalad-akar anmal-abonogo, tegin Pab Tummad anmal-pentako, anmal tobzhulidgin Pab Tummadga immal-imamalgalye, ");
INSERT INTO kvnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tenal anmal chwilidikidgin tegin anmal inniki-naneedgin Pab Tummadga tula-tio, anmal purkwedzheye. Tegin Zacarías chogalbal: ");
INSERT INTO kvnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tenal pe-an-machi nugzhaoye, Pab-Pul-Tummad-e-kaka-palchogedye. Imi pedin, Pab-iktual Pabga igal-nudane ");
INSERT INTO kvnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","e-tulemal wisgunonimalgal Pab-tule-iskued-eliedbal Pab-tule-abonoged-igal igi maiye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tenal Pab-anmal-pilaledgin peyedzhe wilejakwa anmal-taknoniye. Al Pab-tule-palmied nikpa-akar noniko, neg-oipojadgin tad neg-otalonaidyobye. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tenal Pab-tule-palmied nonibalo tule-Pab-wichulmalad tegin tule-purkwed-tobmalad Pab-wisgumalgal, tadgwa tule-neg-chichidgin-mamimaladga neg-otalogedyobye. Tenal Pab-tule-palmied nonibalo anmal-pentagal anmal ulubgin-akalzhul-itoged-igal amigalbalye. Tenal teun Zacarías weob Pab-otummosdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tegin machi-Juan tunkualgu, purpal kannaleged nikunoni. Tegin Juan neg-nikchulidbal megwis, Pab-igalgin Israel-tulemalga-chunmaked-wilub-omoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Imi teun Jesús ampayo mimmilegeddu, Romano-e-sagla-César-Augusto igal-onononi pel-kwapa Romano-napa-naid-ugakche tule-pukmalad-nug weigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Tenal tule-nug-weileged naigunonikidgin, Cirenio Siria-napkin gobernadorga maiun nug-weileged-keped naigunoni.) ");
INSERT INTO kvnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tenal teun takalgu, César-Augusto igal-mezhisdo, tule-pel-kwapa aga neg-kweburzhe neenabmal aga nug mesnegal. Al tulemal-pel-kwapa aga e-neg-kweburzhe nadmalzhun nug mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Imi teun José Nazaret-Galileagin maimo. Tenal José-e-tadgan Errey-David-choggu, al David-neg-kweburzhe nadmo, Belén-Judeaje. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tenal teun José Maríabak aga kaka-ukchamal aga nikumalgal. Al José Maríabak mes Belénzhe nadmalzhun nug mesnegal. Tenal teun María Belénzhe ponigwal-kwichi-nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tenal María Beléngin-chiidgin nuchu-nikued-wilubgan Maríaga noni. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tenal tulemal-Belénzhe-ichejul-nonimaladbal kabed-neg pel algus, al María moli-neggin nuchu-keped-nikunonijun. Tegin María nuchu-nikunonigu, chamolgin aga machi-toto-ebirmas. Tegin María moli-mas-kunned-e-ulgin machi-toto-mezhiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Imi teun takalgu, Belén-tikalbal tule-oveja-takmalad mutik oveja-pukwadgin oveja-takpukmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tegidgin Pab-angel tule-oveja-takpukmaladga arpak nononi. Tegin Pab-yer-takleged tule-oveja-takpukmaladginbi ibegwal neg otalononi. Tegidgin tule-oveja-takpukmalad peyedzhe kwakialmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tegin angel tule-oveja-takpukmaladga chogal: —Pemal melle tobgumalma. Imi antin pemalga kakapurwa-nued cheidani tulemal-pel-kwapa welgumalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Imis David-neg-kwebur-Beléngin pemalga tule-abonoged mimmilenoni. Tenal we tuledin Cristo-Pab-akpene-chogzhad-palmidagoed, tenal wedin, Pul-Tule-Tummad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tenal an wisgal pemalga chogdo: imi pe we machi-toto-mimmilejad pe taknadel, moli-mas-kunned-e-ulgin pe taknatapo chamolgin-ebirmakal-mai. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tegin angel-kepe-nonikid ampa chunmanaidgin, arpakaal Pab-angelmal-íchejul nikpa-akar nononimalmo tegin Pab-Tummad-otummoalmal, chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Imi Pab Tummad immal-nued-imajadbal nikpa-neggin e-nug-otummoledi-kuo, tegin iti-napkin Pab-nued-tulemal-takmalad ulubgin akalzhul-itononimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tenal angelmal kannan nikpa aknakwidmalgu, tule-oveja-takpukmalad aga emal-emal chogalmal: —Tegil nemaldo Belénzhe, Pab-angelbal-anmalga-chognonikid taknegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tegin tule-oveja-takmalad abarmakal-abarmakal Belén-neg-kweburzhe nadmalzhun. Tegin tule-oveja-takmalad Belén omosmalgu, taknatapmal María Josébak pukwamal, tenal machi-totodin moli-mas-kunned-ulgin mai. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tegin tule-oveja-takmalad machi-toto-takchamalad-cholbal, tule-pimaladga chogzhamal, Pab-angel machi-totogin emalga chunmajad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tegin tulemal tule-oveja-takmalad-ega-chogzhad-itosmalgu, weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tenal Maríadin aga ulubgin pél immalmal-kujadgin pinzhedii-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tegin tule-oveja-takmalad kannan nadmalgu, pél immal takchadbal, pél immal itojadbal, tegin pél emalga immal kujadbal Pab-Tummad-otummoe tegin Pab Tummadga tog-nuedi-choge nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tegin machi-toto-mimmilejad ibapábakkin machibi abgan-tuku chikchamal tegin nugzhasmal Jesús. Tenal machi-nug-kunonikiddin, María-ampayo-ponigwal-kwisgueddu angel Maríaga chognonigujad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tegin María nuchu-nikujad-akar aktesgu, Moisés-igal-mamikidyob chwilimakal aga imajogal. Tenal teun takalgu, machi-toto-e-pabgan Jerusalénzhe Moisés-igal-mamikidbal Jesús-chesmal Pab Tummadga ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tenal Pab Tummad Moisésbal chogzhado: Imi tule kepe machi-nikunonikil, keg-chulgu Pabga machi-ukenab, Pabgadgabi kugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tenal María aga tukin Pabga-immal-ukegal nadmo, Pab igal-mezhijadyob. Tenal Pab-igal chogdo: Imi ome nuchu-nikujal, Pabga keg-chulgu kwabo nu-chapur-ukenab, o chulil, kwabo wag-nu-ukenab. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Imi teun takalgu, tule-walgwen Jerusaléngin mai. Tenal we tuledin nug Simeón. Tenal Simeóndin tule-napírragwad tegin Pab Tummadgin pirkin pinzhebal. Tegin Simeón Israel-neg-kwebur-pentakoed abintadii tenal Pab Purpa Nued Simeónbak pela-pela kudibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tenal Pab Purpa Nued akpene Simeónga chogzhagusdo: “Imi pedin ampayo purkweddu, pe Pab-akpene-chogzhad-palmidagoed-tule-takenab.” ");
INSERT INTO kvnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tegin Pab Purpa Nued Simeón-ches, Pabzhe-koled-negzhe. Tenal teun Jesús-e-pabgan Pabzhe-koled-negzhe Jesús-cheinonimalmo Moisés-igal-mamikidbal immal-imagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tenal Simeón Jesús-takchagu, chugnukwa Jesús-kas, tegin Pab-Tummad-otummoal-chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Pab Tummadye, imi antin pe-mosye. Tenal pedin akalzhul an-opurko pe akpene anka chogzhadyobye. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Imi antin imial tule-abonoged-takcha-choggu, al an weligwal itononiye. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tenal pedin tule-abonoged-amis, tulemal-pel-kwapa-akal-akal-pukwad-wagin ");
INSERT INTO kvnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Judiojulmalad wisgumalgal pe ibi-tuleye, kallen neg-chichidgin neg-otaloedyobye. Tegin we tule-abonogedbal Israel-tulemal-nug otummoledi-kuoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tegin Simeón Jesúsgin chognaigualgu, machi-toto-pabgan weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tegin Simeón Jesús-pabganga chogal: —Imi Pab Tummad pemalga immal-nuegan imakelen, nabirinye. Tegin Simeón machi-e-nan-Maríaga chogalbal: —Imi we machi chules Israel-napkin ichejul tulemal-tummaganga-mamikid-onogal, tegin tule-tummaganga ichejul tule-pinchemalad-odogalbal. Tenal machi-toto wilubgan-oyogal noni Pab Tummad nabir tule-abonogo. Tenal tulemal istar machi-taknonimalo. Tegin tulemal istar machigin chunmanonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tenal we machi-totobal mag taklenonimalo tulemal-ichejul igi ulubgin pinzhedimal. María, pedin peyedzhe pukib-itononimogo, tule-es-pilacheedgin-eyurulejadbal nunma-itononikoedyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Imi teun takalgu, ome-walgwen Pab-kaka-palchoged-Ana-nugad chimo. Tenal we Anadin Fanuel-e-chiskwa, Aserzhik-akar tanimal. Tenal Ana yer chelgu. Tenal Ana apka yaegin machered-nikusgu, unnila pirkakugle aga e-macheredbak wis nanas. Tegidgin Ana-e-machered purkwenoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tenal Ana e-machered-purkwed-akar walgwen tii-pes, machered-pal-kwen-nikuszhul-kus. Tenal imisgwadzhe Ana e-chelgued pirka-tulabake-kakabake nika. Tenal Ana pane-pane Pabzhe-koled-neggin chigu, tegin Pabzhe-koled-neg-akar pal noszhul-kus. Tenal Ana ibgin-mutik mas-kunchulidgin tegin Pabzhe-koledgin Pab Tummadga-maidbal pela-pela Pab-otummodi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tegin Simeón ampa Maríabak chunmanaidgin, Ana María-chiidzhe kwisgunonimo. Tegin Ana kep Pab Tummadga tog-nuedi chogalzhun. Tegin Ana pel-kwapa tule-Pab-Jerusalén-abonoged-abintabukmaladga we machi-totogin chunmakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tegin José tegin María Pab-igal-mezhijadyob pél immal-imasmalgu, kannan nadmalbal Provincia-Galileaje, e-neg-kwebur-Nazaret-nugadzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tenal machi-Jesús chana nued tunkual, tegin we machi pinzheed-nika, tegin Pab-Tummad-yer-kin-pinzheed machi-Jesúsbak kudigusbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tenal Jesús-e-pabgan pirka-ilbal keg-chulgu naddamal, Jerusalénzhe Pab-Najad-Ibe-Itoged itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Teun Jesús-e-pabgan kusgu Pab-Najad-Itogedgin nane-choggu, al Jesús pirkaambe-kakabog-nikadgin aga e-pabganbak Jerusalénzhe nadmo Pab-Najad-Ibe-Itoged-itogalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tegin Pab-Najad-Ibe-Itoged pél nasgu, Jesús-e-pabgan kannan negzhe almalbal. Tenal machi-Jesúsdin Jerusaléngin pes. Tenal Jesús-e-pabgan kwen wichulmal Jesús Jerusaléngin pejad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tegin Jesús-e-pabgan ebinzhasmaldo Jesúsde tulemalbak e-iktual nad. Tegin Jesús-e-pabgan ibagwen-nanajadgin kep e-kwenamaladzhe tegin e-aimalzhe aga e-machi-Jesús-ekichial, Jesúsde pia nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tenal Jesús-e-pabgan Jesús-kwen-onoszhul-kus. Al Jesús-e-pabgan kannan Jerusalénzhe nadmalbal Jesús-amigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tegin Jesús-e-pabgan kannan Jerusalénzhe nonimalgu, kep te pangin Pabzhe-koled-neggin tummagan-pukwad-abalgin Jesús-onosmal. Imi teun takalgu, Jesús tummagan-tulemal-oturdananimalad-itojii tegin tummaganzhe immal ekisnaibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tegin tummagan-Jesúszhe-immal-ekisnaidgin Jesús mag-immal-itogedbal, yer tummagan-abinchus. Al tulemal-pel-kwapa-itobukmalad Jesús-yer-immal-chogzhadbal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tegin Jesús-e-pabgan takchagu Jesús tummagan-abalgin chii, weob pakal pesmal. Tegin Jesús-e-nan Jesúsga chogal: —Machi, ¿ibiga pe weob anmal-ima-wede? Imi ani tegin pe-pab pukib-itoged-abalgin pe-aminai, pede igi kus-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tegin Jesús aga e-nanga chogal: —¿Ibiga pe an-aminanimal-ade? ¿Pe wichulzhí antin, an-Pab-neggin chiid-wilub? ");
INSERT INTO kvnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tenal Jesús-e-pabgan aku-itosmal Jesús ega ibi chogzhad. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tegin Jesús aga e-pabganbak mes Nazaretche nadzhun. Tenal Jesús Nazaretkin-maidgin aga e-pabgan-ulpallí nanedi-kus. Tenal Jesús-e-nan pél immal-kujadgin aga ulubgin pinzhedii-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tegin Jesús chana-nued tunkumaigus. Tegin Jesús ibe-ilbal yer pinzheed nikumai-kusbal. Tegin tulemal tegin Pab Tummad pane-pane pul yer Jesús-takti-kusmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Imi teun takalgu, César-Tiberio Romano-tummadga-togzhad-akar, pirkaambe-kakaatal kudani. Tenal teun Poncio-Pilato Provincia-Judeagin gobernadorga maimo. Tenal Herode Provincia-Galileagin gobernadorga maimo. Tenal teun Herode-e-urpa-Felipe Provincia-Itureagin tegin Provincia-Traconitegin gobernadorga maimo. Tenal teun Lisanias Provincia-Abiliniagin gobernadorga maimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tenal teun Anás tegin Caifás tule-irwal-Pabzhe-kolmalad-pul-tummadga maimo. Imi teun takalgu, Zacarías-machi-Juan-Bautista neg-nikchulidbal-maidgin, Pab Tummad Juan Bautistaga chunmanoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tegidgin Juan Bautista nadzhun Jordán-tiwalzhik. Tegin Juan Bautista tulemalga chogalzhun: “Imi pemal aga ulubgin iskuedgin pukib-itogenabmal, tegin pe-taed ogwaenabmal. Tegin pe tigin oglegenabmalbal, Pab Tummad pega iskued-nikad eligal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tenal teun Juan Bautistagin weob immal-kunaid akpene Pab-kaka-palchoged-Isaías nermajadyob kunoni. Tenal teun Isaías chogzhado: Imi neg-nikchulidbal tule-walgwen kolmakal-kolmakal chunmanoniko: “Imi pemal Tule-Tummadga neg nudakenabmal, tegin pe Tummadga inniki-inniki igal imakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tegin pe neg-kullu-kullu-takleged enzheenabmal, tegin pe yal-murre-murre-taklemalad omataroenabmal, Tegin pe igal-ebiral-mamimalad inniki-inniki onoenabmal, tegin pe igal-mullu-mullu-taklemalad chwili imakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tegin kep tulemal-pel-kwapa Pab-tule-abonoged-mag-taknonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tegin Juan Bautista pél chunmasgu, tulemal Juanzhe nonimal, Juande tigin e-ogmalgal. Tegin Juan tulemalga chogal: “Pemal nia-wagwagan, ¿toa pemalga chogzha-ade tigin-oboedbal Pab-peyedzhe-tule-oturdakoed-akar abonolego? We tigin oboedbal tule-kwen-abonogojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tenal pemal nued-naneedbal tulemalga aga oyogenabgwel, pemal chunchunnad aga ulubgin iskuedgin pukib-itononimal. “Tenal pemal melle chogdamalo: ‘Abraham an-tad-sagla-choggu, al an akalzhul yozhagu nanao.’ Tenal an chunchunnad pemalga chogdo: imi Pab Tummad chunna nabir we akwamal opinno Abraham-e-wagwaganga kugal. Al Pab Tummad pemal-kwen-napijul Abraham-wagwaganga kugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Imi Pab Tummad kuakwa mai sapejul tule-nuekwá-nanejulmalad-oturdagal, tule chapi-keg-chanmaked-chalgin akan-kani-kwichidyob, kuakwa chapi olegal. Tenal Pab peyedzhe pel-kwapa tule-iskana-oturdako, chapi-keg-chanmaked keg-chulgu olaoedyob tegin chogin chapi-okummakoedyobbal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tegin tule-itobukmalad Juanzhe ekichialmal: —¿Tegil anmal ibi imakenabzhun? ");
INSERT INTO kvnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tegin Juan tulemalga chogal: —Imi pe yogal-koabo nikamalal, tule-yogal-nikchulmaladga pe kogwen ukenab. Tegin pe mas-kunned nikamalal, tule-mas-kunned-nikchulmaladga pe mas-kunned ukmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tegin tule-Romano-tummadga-tulemalgin-mani-egwanmalad Juanzhe nonimalmo. Tenal we tulemal Juanzhe ekichialmalmo: —¿Tule-oturdaked, anmal ibi imakenabmalmo? ");
INSERT INTO kvnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tegin Juan we tulemalga chogalmo: —Pemal melle tulemalgin wilub-okpis mani pal egwanmalo, unnila igal-mamikidyob pe tulegin mani egwanmalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tegin chulubmal Juanzhe nonimalmo, Juanzhe ekichialmalmo: —¿Anmal, ibi imakenabmalmo? Tegin Juan chulubmalga chogalmo: —Imi pedin melle kantikidgin tulemalgin pal immal idiro. Tegin pe melle tulemalgin kakanzheedgin tule-tummaganga immal-chogo. Tegin pe mani-kanaidgin pe yer itogenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tegin tulemal-pukmalad kuakwa abintabukmal, Juande ega chogdago-dewa, ede Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tenal Juan tulemalga chogalzhun: “Tenal antin tiginbi unnila tule-og, oyogal pemal ulubgin chunchunnad iskuedgin pukib-itonanimal. Tenal tule-an-cholbal-tanikoed anka pul kannaleged nika. Tenal we tule anka pul tule-tummadiidbal, an kwen unnijul targa kutar-tub echikkal. Tenal tule-an-cholbal-tanikoed Pab Purpa Nuedgin tegin chogin pe-ognonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Tenal tule-an-cholbal-tanikoed kuakwa kwichi pis-pis tulemal-urpegal, tule pala-azhaled-kanikidgin trigo-omigal kuakwa kwichidyob. Tegin tule-an-cholbal-tanikoed Pab-neggin tule-nuegan-odogo, tule kwapí aga trigo-kwa chaboedyob. Tegin tule-an-cholbal-tanikoed cho-keg-akinnedgin tule-iskana-urpo, tule chogin kummagal trigo-e-uka urpoedyob.” ");
INSERT INTO kvnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tegin Juan pél chunmasgu, ichejul akal-akal tulemal-uanaisbal tegin Juan tulemalga Pab-kaka-nuegangin chunmadi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Imi teun takalgu, Herode e-urpa-Felipegin ome-Herodías-egwas. Al Juan Herodega pakal-pud chogzhagusdo: “Imi pedin noal kudii. ¿Ibiga pe aga urpa-Felipegin ome-Herodías-egwas-wede? Imi anmalga igal weob kwen maichul.” Tegin Juan Herodega Herode-immal-akalodiid pél chogzhabal. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tenal Herode ukin immal akalodiidbal, oturdaleged-neggin Juan-odos. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tenal Juan Bautista ampa tigin tulemal-ognaidgin, Juan tigin Jesús-okchamo. Tegin Jesús-Pabzhe-kolnaidgin arpak nikpa-neg arkat-nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tegidgin Pab Purpa Nued Jesúsgin nuyob aktenoni. Tegin Pab Tummad nikpa-neg-akar kolnoni, Jesúsga chogal: —Imi pedin an-Machi-Pilaled, tegin an pegin weligwal-ito. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tenal teun Jesús pirka-tulagwen-kakaambe-nikadgin kep Pab-igalbal tulemal-oturdakalzhun. Tenal tulemal ebinzhasmal Jesúsde José-e-machi. Tenal Josédin Elí-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Tegin Elídin Matat-e-machi. Tegin Matattin Leví-e-machi. Tegin Levídin Melqui-e-machi. Tegin Melquidin Jana-e-machi. Tegin Janadin José-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tegin Josédin Matatías-e-machi. Tegin Matatíasdin Amós-e-machi. Tegin Amósdin Nahúm-e-machi. Tegin Nahúmdin Esli-e-machi. Tegin Eslidin Nagai-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tegin Nagaidin Maat-e-machi. Tegin Maatdin, Matatías-e-machi. Tegin Matatíasdin Semei-e-machi. Tegin Semeidin Josec-e-machi. Tegin Josecdin Judá-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Tegin Judádin Joanán-e-machi. Tegin Joanándin Resa-e-machi. Tegin Resadin Zorobabel-e-machi. Tegin Zorobabeldin Salatiel-e-machi. Tegin Salatieldin Neri-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tegin Neridin Melqui-e-machi. Tegin Melquidin Adi-e-machi. Tegin Adidin Cosam-e-machi. Tegin Cosamdin Elmadam-e-machi. Tegin Elmadamdin Er-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tegin Erdin Josué-e-machi. Tegin Josuédin Eliezer-e-machi. Tegin Eliezerdin Jorim-e-machi. Tegin Jorimdin Matat-e-machi. Tegin Matattin Leví-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tegin Levídin Simeón-e-machi. Tegin Simeóndin Judá-e-machi. Tegin Judádin José-e-machi. Tegin Josédin Jonam-e-machi. Tegin Jonamdin Eliaquim-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Tegin Eliaquimdin Melea-e-machi. Tegin Meleadin Mena-e-machi. Tegin Menadin Matata-e-machi. Tegin Matatadin Natán-e-machi. Tegin Natándin David-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tegin Daviddin Isaí-e-machi. Tegin Isaídin Obed-e-machi. Tegin Obeddin Booz-e-machi. Tegin Boozdin Sala-e-machi. Tegin Saladin Naasón-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Tegin Naasóndin Aminadab-e-machi. Tegin Aminadabdin Admin-e-machi. Tegin Admindin, Arni-e-machi. Tegin Arnidin Esrom-e-machi. Tegin Esromdin Fares-e-machi. Tegin Faresdin Judá-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tegin Judádin Jacob-e-machi. Tegin Jacobdin Isaac-e-machi. Tegin Isaacdin Abraham-e-machi. Tegin Abrahamdin Taré-e-machi. Tegin Tarédin Nacor-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tegin Nacordin Serug-e-machi. Tegin Serugdin Ragau-e-machi. Tegin Ragaudin Peleg-e-machi. Tegin Pelegdin Heber-e-machi. Tegin Heberdin Sala-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tegin Saladin Cainán-e-machi. Tegin Cainándin Arfaxad-e-machi. Tegin Arfaxaddin Sem-e-machi. Tegin Semdin Noé-e-machi. Tegin Noédin Lamec-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tegin Lamecdin Matusalén-e-machi. Tegin Matusaléndin Enoc-e-machi. Tegin Enocdin Jared-e-machi. Tegin Jareddin Mahalaleel-e-machi. Tegin Mahalaleeldin Cainán-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tegin Cainándin Enós-e-machi. Tegin Enósdin Set-e-machi. Tegin Settin Adán-e-machi. Tegin Adándin Pab-Tummad-tar-opinnijad. Tenal Jesúsdin weob tadgan-nikusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tegin Jesús Jordán-ti-akar nakwisgu, pela-pela Pab-Purpa-Nued-nika-nad. Tegin Pab Purpa Nued Jesús-cheszhun neg-nikchulidbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tenal neg-nikchulidbal nia-sagla iba-tulabo Jesús-wilub-takti-kus. Tenal teun Jesús mas kwen kunchul-kudigus. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Al Jesús ukul-chaalgu, nia-sagla Jesúsga chogal: —Imi Pe-Pab-Machile, pe we akwamalga chogo: ‘Maduga pinno.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tegin Jesús niaga chogal: —¡Chulá! Imi Pab-kartagin nermakal maido: Imi tule mas-kunnedginbi kwen tuladijul, (tenal tule Pab-kaka-itogedbal tula-kudimal). ");
INSERT INTO kvnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tegin nia-sagla yala-tummad-pirzhe Jesús-chesbal. Tegin nia-sagla Jesúsbak yal-pir omosgu, nia-sagla ilgwen-oyoal pel-kwapa napa-naid-ugakche Jesúsga neg oyos. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tegin nia-sagla Jesúsga chogalbal: —Imi we neg-kweburgan-an-pega-oyojad, pel-kwapa anka ukles-choggu, al an akalzhul pega ukmogo, tegin neg-kweburgan-immalmal-nuegan-nikad an akalzhul pega pél ukmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tenal pe Pab Tummadyob pe an-otummoel, an kep pega pél uko. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tegin Jesús nia-saglaga chogal: —Pinche pe koltima. Tenal Pab-Tummad-kartagin nermakal maido: Pab Tummadbi pe Pab Tummadyob otummogenab, tegin pe Pab Tummadgabi pe immal imakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tegin nia-sagla Jerusalénzhe Jesús-chesbal. Tegin Jerusalén-omosgu, nia-sagla Pabzhe-koled-neg-uwas-pirzhe Jesús-onakwis. Tegin nia-sagla Jesúsga chogalbal: —Imi pe Pab-Machile, pe we-akar napche ichomado. Tenal pedin kwen akalguojul. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Imi Pab-kartagin nermakal maido: Pab Tummad aga e-angelmalga chogo pe-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tenal pe arkwatel, angelmal chugnukwa pe-kanonimalo, pe melle akwagin nag-kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tegin Jesús nia-saglaga chogalbal: —Nabir pe chogendo, tenal Pab-kartagin chogbaldo: Pe melle Pab-Tummad-wilub-tako. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tegin nia-sagla takchagu ede iskuedgin keg Jesús-egwangus, Jesús-akar ilgwen nadzhun. Tegin nia-sagla untar Jesúsgin wis owelenonijun. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tegin Jesús pela-pela Pab-Purpa-Nued-kannaleged-nikadgin Galileaje nonigu, tulemal pel-kwapa neg-kweburgan-ilbal Jesúsgin chunmaked-kibi-kualmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tegin Jesús Judio-ormaked-negmal-ilbal Pab-igalgin tulemal-oturdadi-kual. Tenal tulemal-pel-kwapa Jesús-nug-otummoalmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tegin Jesús aga e-tunkujad-neg-kwebur-Nazaretche nonibal. Tenal Jesús kusgu Judio-ormaked-negzhe nane-choggu, al ulukued-ibe-naigunonigu, Jesús Judio-ormaked-negzhe tognoni Pabzhe kolgal. Tegin Jesús kwisgus Pab-karta apchogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tegin tulemal Jesúsga Pab-kaka-palchoged-Isaías-e-karta cheinonimal. Tegin Jesús karta egasgu, epad-epad imas, nermakal-naidzhe, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Pab Purpa Nued ankin mai. Al Pab an-nugzhas tule-wiledimaladga e-kaka-nuegangin chunmagal. Tegin Pab an-palmialbal tule-kalesbukmaladga choggal: “Pedin akalzhul noo.” Tegin an nonibal tule-aku-atamalad mag atamalgal. Tegin Pab an-palmialbal tulemal-chabzhul-kunanimalad-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tegin Pab an-palmialbal tulemalga choggal: “Imi pirka naigunoni, Pab wilejakwa tule-takegal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tegin Jesús Pab-karta apchosgu, ebirmasbal. Tenal Jesús chowal-ibed-tummadga kannan Pab-karta ukchabal. Tegin Jesús kep chigwiszhun tulemal-oturdagal. Tegin tulemal-pel-kwapa-pukmalad nue Jesús-takpuk-pesmal Jesúsde igi chunmadago-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tegin Jesús chunmakalgu, chogal: —Imi akpene Isaías Pab-kartagin chogzhad, imis pemal-abalgin sanal kunoni. Imi antin, an Isaías-ankin-chogzhad-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tegin tulemal-pel-kwapa Jesúsgin chogalmal: “Imi we Jesús tule-nued.” Tenal Jesús-yer-chunmajadgin tulemal weob pakal pesmalbal. Tegin tulemal aga emal-emal ekichialmal: —¿Imi we tulede José-machijulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tegin Jesús tulemalga chogal: —Imi antin, an wisdo, pemal purpal anka chogdamalo: ‘Ina-tuled, pedin aga tukin poni-nikad nudakenab oyogal, pe tule-immal-wijiid.’ Tenal an wisbaldo, pemal anka chogdamalbalo: ‘Imi pe Capernaum-neg-kweburgin immal-taktijulid imadi-kujadyob pe aga neg-kweburgin keg-chulgu immal-taktijulid imakenabmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tegin Jesús chogalbal: “Tenal an chunchunnad pemalga chogdo: imi meke-ibi-Pab-kaka-palchoged aga neg-kweburgin kwen abingelegojul-kuo. Tenal akpene Pab-kaka-palchogmalad kwen abingaleszhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tenal an chunchunnad pemalga chogdo: imi Elías maigusgu, pirkapá-abal ti kwen wiszhul-kus, tegin mas-kunned kwen nikchul-kunonibal. “Tenal teun Israel-napkin omegan-machered-tarbi-purkwismalad ichejul nika. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tenal Elías yabli we omegan-machered-tarbi-purkwismaladzhe kwen palmileszhul. Tenal Pabdin wiis ede we omeganzhe Elías-palmijalen, we omegandin Elías-kwen-akojulmalan. Al Pab Sidón-napche neg-kwebur-Sareptaje Elías-palmis, we neg-kweburgin ome-machered-tarbi-purkwijad Elías-akwegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Teginbal, Israel-napkin Eliseo maigusgu, teun tule-lepra-poni-nikmalad ichejul nika, tenal tule-lepra-poni-nikmalad Eliseogin-kwen-ibzhejulidbal, kwen nuguszhulmal. Tenal Naaman-Siria-napkinedbi Eliseogin-ibzhejadbal lepra-ponigin wis nugus.” ");
INSERT INTO kvnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tegin tulemal-pel-kwapa-Judio-ormaked-neggin-pukmalad Jesús-chogzhad itosmalgu, pela-pela Jesúsgin ulualmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tegin tulemal kwisgudmalgu, neg-kwebur-akar kantikidgin Jesús-onodmal. Tegin tulemal yal-urchikal-kwichidzhe Jesús-chesmal, kullubal Jesús-egwangal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tenal tulemal yal-urchikal-kwichidzhe nonimalgu, Jesúsgin-kwakijadbal kullubal Jesús-kwen-egwaszhulmal. Tenal Jesús yabli tulemal-abalgin kannama-nas. Tegin Jesús ilgwen ukin nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tegin Jesús Capernaumzhe nad. Tenal Capernaum-neg-kweburdin Provincia-Galileagin chimo. Tegin ulukued-ibe omosgu, Jesús Pab-igalgin tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tenal Jesús chunchunnad igal-nikadgin tulemal-oturdanaidbal, tulemal weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Imi teun takalgu, Judio-ormaked-neggin tule-walgwen-nia-iskana-nikad chimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Tegin nia sapejul tule-okormasgu, chogal: —Jesús-Nazaretkinedye, ¿ibiga pe anmalgin yoledanimo-wede? Pe melle ankin yolema. ¿Pe anmal-opelodaniyé? Imi antin pe-wisdo, pedin toa-tule: pedin tule-chwilidikid, pe Pab-Tummad-nuggin-tanikid-tuleye. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tegin Jesús nia-tulegin-maidga chogal: —Pe yakir kuma. Pe ilgwen we tule-akar noo. Tegidgin tulemal-pel-kwapa-pukwad-wagin, nia napche tule-olasgu, tule-kwen-nakposzhulidgin tule-akar ilgwen noszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tenal tule-takpukmalad-pel-kwapa weob pakal pesmal. Tegin tulemal aga emal-emal chogalmal: —¿Ibi-tule-wede igal-nikadgin-chunmakeddé? We tule igal-nikadgin tegin kannalegedgin nia-iskanaga chogalda: ‘¡Pedin noo!’ Tegin niamal yabli ilgwen we tule-akar nomal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tegin tulemal-pel-kwapa akne-akne neg-kwebur-ilbal wisgunonimal, Jesús-tulegin-nia-onojad. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tegin Jesús Judio-ormaked-neg-akar nodgu, Simón-negzhe nad. Tegin Jesús Simón-negzhe tognonigu, taknoni Simón-e-chak-ome pela-pela uged tarmamai. Tegin tulemal-aka-pukmalad Jesúszhe wilenonimal emalga Simón-chak-ome-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tegin Jesús Simón-chak-abir kwisgunonigu, tullu imas. Tegin Jesús ugedga chogal: “Pe akino.” Tegin uged ilgwen Simón-chak-omega akiszhun. Tegidgin Simón-chak-ome ilgwen kwisgudgu, Jesúsmalga immal chaalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tegin neg-chedoalgu, tulemal Jesúszhe pel-kwapa tule akal-akal-yemalad-nikmalad-cheinonimal. Tegin Jesús chunkalgin tulemal-ebuged-ilbal pel-kwapa tulemal-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Teginbal, niamal-ichejul tulemalgin-nomamimaladgin kolmakal-kolmakal Jesúsga chogaldamal: “¡Pedin Pab-Machiye!” Tenal Jesús niagin igal-kas melle e-nug pigal. Tenal niamal nued wismaldo, Jesús Cristo-Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tegin te pangin, Jesús wakur-neg-tale-tale nad, neg-tule-nikchulidbal Pab Tummadzhe kolgal. Tegin neg-oiposgu, tulemal takalmal, Jesús taklejul. Tegin tulemal Jesús-aminadmalzhun. Tegin tulemal Jesús-onosmalgu, Jesúsgin igal-kabi-kualmal melle akne negal, e-neg-kweburgin peigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tenal Jesús tulemalga chogal: —Tenal antin neg-kweburgan-pimaladzhe neenabbal Pab-neg-takmaidgin-kaka-nuegangin tule-pukmaladga chunmagal. Imi an palmilenoni pel-kwapa tulemalga Pab-kaka-nuegangin chunmagal. Al an pemalbak keg peiel. ");
INSERT INTO kvnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tegin Jesús Provincia-Judeagin Judio-ormaked-negmalgin Pab-igalgin tulemalga chunmadi-kualzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tegin te ibagwengin, Jesús Genesaret-mata-kakpal Pab-igalgin chunma-kwichidgin, tulemal-ichejul tunnugwal Jesús-waglika kubi-kualmal nuekwa Jesús-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tegidgin Jesús walabo ul takcha, ukubgin mamimal. Tenal tule-ul-ibgan ul-yagin kwen pukchulmal, tenal tigin chaki enuknanimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tegin Jesús ulgin nakwiszhun. Tenal we uldin Simóngad. Tegin Jesús Simónga chogzha ega tije ul egwano. Tegin Jesús ulgin chigwisgu, ul-akar Pab-igalgin tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tegin Jesús tulemalga pél chunmasgu, Simónga chogal: —Nemalma ti-magadbal, wilaje chakigin ua-wis-kanegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tegin Simón Jesúsga chogal: —Tummad, anmal óipos wegin ua-kananimal, tenal anmal yabli ua-kwen-kaszhul-kusmal. Tenal pe-anka-chogzhadbal an kannan chaki opatnebal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tegin Simónmal nadmalzhun mata-magadbal. Tegin Simónmal chaki opatismalgu, ichejul ua-kasmalzhun. Tenal Simón ichejul ua-kajadbal, e-chaki pel idirbi-kual. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Al Simón chunkalbal e-pakamaladzhe kocha emal-pentadagal. Tegin Simón-e-pakamalad nonimalgu, ul-walbo-pel ua-engus-ne. Al ulmal toged-naga pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tegin Simón-Pedro takchagu emalde ichejul ua-kas, Jesús-abir chimtinoni. Tegin Simón-Pedro Jesúsga chogal: —¡Tummad, pe an-akar nema. Pedin tule-chwilidikid. Tenal antin tule-iskued-nikad! ");
INSERT INTO kvnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tenal Simón ichejul-ua-kajadbal weob pakal pes, tegin e-pakamalad-Simónbak-irmamalad ampa weob pakal pesmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tenal Simón-e-pakamalad ul-pidgin kudimalmogad, Zebedeo-machimal-Jacobo-tegin-Juan. Tenal we tulemal ichejul-ua-kajadbal ampa weob pakal pesmalmo. Tegin Jesús Simónga chogal: —Pe anpak-kudiidbal pe melle akal-itoma. Tenal pedin imis-akar ua-kajadyob, pe anka tule-aminemo ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tegin Simónmal kannan ukubzhe ul nazhinonimalgu, ilgwen pél immalmal ebesmal, tegin Jesúsbak nadmalzhun, Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Imi te ibagwengin Jesús neg-kweburgin kudiidgin, tule-walgwen-noni. Tenal we tule lepra-poni nika. Tegin tule-lepra-poni-nikad Jesús-takchagu, askun Jesús-abin akmukutap. Tegin tule-lepra-poni-nikad Jesúszhe wilenaigual chogal: —Tummad, imi antin kwen penzhuldo pedin unni an-nudagal. Tenal pe an-nudabiel, akalzhul pe an-nudakoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tegin Jesús tule-lepra-poni-nikadgin chunkal-mezhisgu, tule-yeedga chogal: —Imi antin yer itomodo pe-nudagal. Imisgin pe nugudo. Tegidgin tule-lepra-poni-nikad ilgwen nuguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tegin Jesús tule-lepra-poni-nika-nadga chogal: —Imi pedin akalzhul nao, tenal pe melle tule-pimaladga pe palchogo, antin pe-nudas. Tenal pe ilgwen tule-irwal-Pabzhe-kolmaladzhe aga pe-chan oyonao. Tegin pe tule-irwal-Pabzhe-koledga chogo: ‘Antin nugus.’ Tegin pe chwilidik peigal, Moisés-igal-mamikidbal pe immal chedbalo, Pab Tummadga ukegal, tulemal wisgumalgal pedin nugus. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tenal Jesús-e-nug pul-ichejul mimilemai-choggu, al tulemal-ichejul Jesúszhe ampagunonidamal Jesús-itogal, tegin Jesús e-poni-nikmalad-nudagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tenal Jesús tulemal-akar naddabal pidzhi Pabzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Imi te ibagwengin Jesús neg-yabal Pab-igalgin tulemal-oturdanaidgin, Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad-akne-akne-tanimalad Jesús-itobukmalmo. Tenal we tummagan Provincia-Galilea-neg-kweburgan-ilbal nonimal, kwen Provincia-Judea-akar nonimal, kwen Jerusalén-neg-kwebur-akar nonimalmo. Tenal teun Pab-Tummad-kannaleged pela-pela Jesúsbak kudimo tule-yemalad-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tenal teun takalgu, tulemal kachigin Jesúszhe tule-abgan-purkwaled-nikad-cheinonimalmogan Jesús ega nudagal. Tegin tulemal-e-ai-yeed-cheinonimalad alamasmalan Jesúszhe tule-yeed-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tenal tulemal-íchejul-pukwadbal kwen unniguszhulmal Jesús-chiidzhe tule-yeed-odogal. Al tulemal-e-ai-yeed-cheinonimalad nikpa neg-uwas-mataragwadzhe tule-yeed-onakwismalzhun. Tegin tulemal-yee-e-ai-cheinonimalad neg-uwasgin neg utusmalzhun, tegin Jesús-chiid-inniki kachigin tule-yeed-odesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tegin Jesús takchagu tule-yee-e-ai-cheinonimalad egin kwen penzhulmal, Jesús tule-abgan-purkwaledga chogal: —An-ai, pe-iskueddin pato pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tenal Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad aga ulubgin pinzhealmal: “¿Ibi-tule-wede, Pab Tummadgin kwen atajulidgin chunmakeddé? We tule Pab Tummadgin walmas. ¿Toa-tule-ade igal-nika tulega choggal: ‘Pe-iskueddin pato pelgus?’ Pab Tummadbi unnila igal-nikado, tule-iskued eligal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tenal Jesús ulubzhe mag tulemal-tak-choggu, al Jesús wiis tule-tummagan aga ulubgin igi pinzhebukmal. Tegin Jesús tule-tummaganga chogal: —¿Ibiga pemal aga ulubgin an-pengusmal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Pemal ebinzhemal antin keg tule-iskued eli? Tenal an we tulega chogzhal: ‘Pe-iskued pelgus,’ we tulega yabli iskued pelguenab. ¿Ibi pul-pulejul? ¿Tule-yeed-nudaked o tule-iskued-elied? Pog-pel ibi-puled. Al an unnigujal tule-yeed nudagal, an unnigumogo tule-iskued eligal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Al pemal wisgal an-Te-Tule-Chunna iti-napkinga igal-nika tule-iskued eligal, an imisgin we tule-yeed-nudanejun. Tegin Jesús tule-yeedga chogalzhun: —Imisgin an pega chog: pe kwisgu, aga pe kachi olma. Imisgin pe negzhe naddo. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tegidgin tule-yee-nad tulemal-pukwad-wagin ilgwen nugusgu kwisgus, tegin aga kachi cheszhun. Tegin tule-yee-nad Pab-Tummad-otummoe aga negzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tenal tulemal-pel-kwapa-takpukmalad weob pakal pesmal, tegin Pab-Tummad-otummoalmalmo. Tegin tulemal-takpukmalad keger-takedbal chogalmal: —Anmal imis immal-taktijulid-keger-takleged takchamal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tegin Jesús tule-nudajad-cholbal, kep we neg-akar nadzhun. Tegin Jesús natapidgin tule-walgwen-Leví-nugad-taknoni, Romano-tummadga mani-egwaned-neggin chii tulemalgin-mani-egwanchii. Tegin Jesús Levíga chogal: —Anpak nemalma, ankin turdagal. Tegin Leví Jesúsga chogal: —Tegil nabirde. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tegin Leví kwisgudgu, ilgwen pél immalmal ebes, tegin Jesúsbak nadzhun Jesúsgin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tegin Leví aga e-neggin ichejul mas-kunned onos, Jesús-otummogal. Imi teun, tule-Romano-tummadga-mani-egwanmalad-ichejul tegin tule-iskana-pimalad-ichejul Leví-neggin Jesúsbak mes mas kunnonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tenal Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad-Pariseomalzhik-naigusmalad Jesús-e-chapinganzhe ulualmal chogalmal: —¿Ibiga pemal tule-Romano-tummadga-mani-egwanmaladbak tegin tule-iskued-nikmalad-pimaladbak mes mas kunpukmal-wede? Wedin ib-nuedzhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tegin Jesús Pariseomalga chogalzhun: —Imi tule-yemaladdin, ina-tuled-napimal. Tenal tule-poni-nikchulmalad ina-tuled-kwen-napijulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tenal antin ina-tuledyob noni, tule-iskued-nikmalad-amigal aga e-taed ogwagal. Tenal an nonijul tule-nuegan amigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tegin tule-wal-walgwen Jesúszhe ekisnonimal chogalmal: —Imi Juan-chapingan tegin Pariseo-chapingan peyedzhe mas-kunchulidgin tegin Pabzhe-koledgin nanemal, tenal pe-chapingandin mas kunmal tegin kobed kobmalbal. ¿Ibiga pe-chapingan mas-kunchulidgin keg nanemalmo? ");
INSERT INTO kvnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tegin Jesús tulemalga chogalzhun: —Nabir. Tenal an pemalga purpal chogdo: ¿imi tule ome-nikunail, machi-ome-nikuneed ampa chiidbal, tule-irmanonimalad mas-kunchul-kuo pe ebinzhe? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tenal machi-ome-nikuneed tulemal tarbi chesmalal, we tulemal mas-kunchulidgin kep nanadamalo. Imi tulemal an-chesmalal, kep an-chapingan mas-kunchulidgin nanadamalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tegin Jesús tulemalga purpal chogalbal: —Imi tule mol-mukwagin mol-koa-pin kwen matamajulmal. Tenal tule mol-mukwagin mol-koa-pin-matamakelen, mol kaledel, pinche mol-pin izhooen, tegin mol-koa-pin mol-mukwagin-naigujad istar-taklebaloen. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tegin Jesús purpal immal-pid chogalbal: —Imi pemal wismal puglu-moli-ukagad ilkwénna wis ebule inna chigal. Al tule keg ku puglu-ebugaledgin inna-kabil-pin chigal. Tenal tule an-chogzhadyob imakelen, inna-pin kakpi-kudel, puglu-ebugaled arpídel, ilgwen marroen. Tegin inna-kabil pél perienguoen tegin puglu-moli-ukagad iskubaloen. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Al tulemal puglu-moli-ukagad-pingin inna-kabil-pin chimal. Al tule-igal-pin igal-cheredbak keg kumo. ");
INSERT INTO kvnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tegin Jesús purpal immal-pid chogalbal: —Imi tulemal kakpi-pakal-inna-kobzhadbal, inna-ochigwad pal kwen kobbijul-kudago, pul-yer inna-kakpid itojadbal. Al tulemal pul-yer igal-chered takmaladbal yapa igal-chered ebebi-kudamalo. Teun Jesús weob chogzhagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tegin te ibagwengin ulukued-ibegin, Jesús aga e-chapinganbak trigo-naidbal natapidgin, Jesús-e-chapingan trigo-kwane-natapmal. Tegin Jesús-e-chapingan chunkalgin wigi-wigi trigo-kwa imasmal e-kwa magal. Tenal teun Pariseomal-wal-walgwen Jesúsbak natapmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tegin Pariseomal-kwénna-kwénna Jesús-e-chapinganga chogalmal: —¿Ibiga pe ulukued-ibegin trigo-kwa kwananimal tegin pe ibiga wigi-wigi trigo-kwa-imananimalbal-wede? Wedin arpaged. Al ulukued-ibegin weob immal-imakeddin izhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tegin Jesús Pariseomalga chogal: “An-chapingan noal immal kwen imananijulmal. ¿Pe Pab-kartagin apchodijulzhí akpene Errey-David aga e-chapinganbak ukul-mesdanikidgin, igi kus? ");
INSERT INTO kvnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“Imi teun David aga e-chapinganbak Pabzhe-koled-neggin togzhagu, madu-Pabga-uklejad kuchamal. Tenal we madu-Pabga-uklejad unnila tule-irwal-Pabzhe-kolmaladbi igal-nika kunkal. Tenal David-madu-kuchad izheendo, tenal David yabli e-chapinganbak kwen iskuszhulmal. Tenal Pab Tummad pul yer tule-tak, pul igal-mamikidga. Al an-chapingan kwen iskuszhulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tenal an-Te-Tule-Chunna ulukued-ibe-e-ibedga mai.” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tegin ulukued-ibe-pidgin Jesús Judio-ormaked-negzhe tognoni, tegin Pab-igalgin tulemal-oturdakalzhun. Tenal teun takalgu, Judio-ormaked-neggin tule-walgwen-chakwa-nuedzhikid-tinkualed chimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Imi Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad igal-aminanimal Jesúsgin istar chunmagal Jesús noal-kudii. Al we Judio-tummagan nue Jesús-algebukmal takegal Jesúsde pule ulukued-ibegin tule-nudako-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tenal Jesús nued wisdo Judio-tummagan igi egin pinzhebukmal. Tegin Jesús tule-chakwa-tinkualedga chogal: —Kwisgu. Tage neg-abaladzhe. Tegin tule-chakwa-tinkualed kwisgudgu, neg-abaladzhe kwisgunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tegin Jesús Pariseomalga chogal: —Imi antin, an peido, pemal anka chog. ¿Imi ulukued-ibegin ib-nued immal-nued imagal, o immal-iskana imagal? ¿Tule-nudakoed o meke tule-purkoed? Anka chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tegin Jesús tule-amigwisgual toa ega chogo. Tenal tulemal Jesús-kwen-abinchuszhulmal, ilgwen yakir pesmal. Tegin Jesús tule-chakwa-tinkualedga chogal: —¡Chakwa akto! Tegin tule-chakwa-tinkualed chakwa aktosgu, e-chakwa ilgwen nugus. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tenal Pariseomal sae-itos-pesmal. Al Pariseomal aga emal-emal igal-aminaigualmal, emalde igi Jesús-imakel nabir. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tegin Jesúsdin tule-chakwa-nudajad-cholbal untaradgin, yal-pirzhe nad Pabzhe kolgal. Tegin Jesús óipos Pabzhe kolzhii. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tegin neg-oiposgu Jesús aga e-chapinganzhe kocha e-waglik amapagunonimalgal. Tegin Jesús walambe-kakabog aga e-chapingan-chus. Tenal Jesús tulemal-walambe-kakabog-chulenonimaladga nug uknoni e-nuggin-palmilegalmalad. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tenal Jesús-nuggin-palmilegalmalad nug-nemal: Simón, (tegin Jesús tar-nugzhasbal Pedro,) tegin Pedro-e-urpa-Andrés, tegin Jacobo, Juan, Felipe tegin Bartolomé, ");
INSERT INTO kvnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, tegin Alfeo-machi-Jacobo, tegin Romano-tule-onobied-Simón, ");
INSERT INTO kvnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tegin Jacobo-machi-Judas, tegin Judas-Iscariote. Tenal we Judas-Iscariotedin manibal-Jesúsgin-akpinnoed. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tegin Jesús aga e-chapinganbak yal-pir-akar aktenonimalgu, nebaje ampagunonimal. Tenal teun takalgu, tulemal-Jesúsbal-naigusmalad íchejul ampagunonimal, tegin tulemal-aknedanimalad íchejul ampagunonimalmo. Tenal tulemal-ampagunonimalad pel-kwapa-Provincia-Judea-akar nonimal, kwén Jerusalén-neg-kwebur-akar nonimal, kwén Tiro-tegin-Sidón-neg-kwebur-termal-kakpal-akar nonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tenal tulemal nonimal Jesús-itogal, tegin Jesús e-poni-nikmalad-nudagalbal. Tegin tulemal-nia-iskanaje-wiledimalad nugunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tegin Jesús-e-kannaleged-nikad-akar pela-pela tulemal-nuda, al tulemal-pel-kwapa chunkalgin Jesús-ebubi-kualdamal nugugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tegin Jesús nue aga e-chapingan-taktegu, chogal: Imi pe immal-nikchulidbal wilediil, ib-nued pemalga kus, Pab-neg-takmaid pemalgadga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tenal pe imis ukul-mesdimalal, ib-nued pemalga kus, Pab kujal imme pemal-imamalo. Tenal pe imis pukib-itogedbal podimalal, ib-nued pemalga kus, pemal kujal weligwal-itogedgin allenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tenal pe an-Te-Tule-Chunnabal-nanimaladbal tulemal istar pe-taknonikil, tegin kantikidgin ormakedgin pe-onodmalal, ib-nued pemalga kus. Tenal tulemal istar pegin chunmakalmalal, tegin immal-iskanayob pe-nug izhoel, ib-nued pemalga kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tenal tule chabzhul pe-imajal, ampa te ibegin pe ichomakal-ichomakal welguo, tegin Pab-neggin pemalga íchejul immal-nuegan uklenoniko. Tenal tulemal pemal-imajad-yopí, akpene we tulemal-e-tadgan chabzhul Pab-kaka-palchogmalad-imasmalmo. Tegin Jesús chogalbal: ");
INSERT INTO kvnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tenal pemal-mani-ibgan ampi pe wilesmalma, pe-immalmal-nikadgin pe yer itodimal, tenal Pab-neggin pemalga immalmal-nuegan pal kwen uklegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tenal pemal-imme-itodimalad ampi pe wilesmalma, pemal kujal peyedzhe ukul-mesnonimalo. Tenal pemal-imis-alledimalad ampi pe wilesmalma, pemal kujal pukib-itononikidbal peyedzhe pononimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tenal tulemal-pel-kwapa-pe-nug-otummodimalad, ampi pe wilesmalma, akpene tadgan ampa Pab-kaka-palchoged-chunchunnadzhulmalad-nug otummodi-kusmalmo. Al wegin choglejundo: pedin nuekwá kwen kudijulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tegin Jesús chogalbal: “Imi pemal-an-itobukmaladga an chogdo: imi tule-pebak-aichulmalad pe pilalguenabmal. Tegin tule-istar-pe-taktimaladga pe ib-nued imakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tegin tulemal-pe-ukapchemaladga pe chogo: ‘Pab pega immal-nuegan imakelen, nabirin.’ Tegin tulemal-istar-pegin-immal-imamaladga pe Pabzhe kolmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Tegin tule pebi-wagal ebiojal, pe we tulega wagal-konali pe oyobalo pe-ebiogalbal. Tegin tule-walgwen kantikidgin pegin chuba chujal, pe akalzhul we tulega yogal ukpalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Imi meke-ibi-tule peje immal ekisdanikil, pe we tulega immal uko. Tenal tule-walgwen pegin kantikidgin immal chujal, pe melle kannan pal ekisnao. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imi pe igi peigujídin tule pega immal ima, pemal ampa teopí tule-pimaladga pel-kwapa immal imamogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Imi pemal aga aimalbi-pilalmalal, ¿ibi-nued pega kunoniko? Keg kue. Imi tule-iskana ampa aga e-aimal-pilalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tegin tule-pega-immal-nuegan-imadimaladgabi pe immal-nuegan imadiil, ¿ibi-nued pega kunoniko? Keg kue. Imi tule-iskana ampa tule-ega-immal-nuegan-imadimaladga immal-nuegan imamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Imi pe tulega immalmal-ololchajad pega kannan uko pe takedbal, pe tulega immalmal ololchasmogal, ¿ibi-nued pega kunoniko? Keg kue. Imi tule-iskana ampa tule-ega-kannan-immal-uko-takedbal tule-iskana-pimaladga immalmal ololchenanimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Tenal pemal keg-chulgu tule-pebak-aichulmalad-pilalgumalo, tegin pe tule-pebak-aichulmaladga immal-nuegan imamalo. Tegin pe tulemalga immalmal ololchao, tenal pe melle pal pinzhao: ‘We tulemal anka kannan immalmal uknebal.’ “Imi an-chogzhadyob pemal immal imasmalal, Pab-neggin immalmal-ichejul pega uklenoniko. Tegin Pab-Pul-Tummad-naneedyob, pe kunonimogo. Imi Pab Tummad tule-keg-ega-nuedi-chogmaladbak pinnallé nane, tegin tule-iskanabak pinnallé nanebal. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tenal pe-Pab-Tummad wilejakwa tule-takedyob, pedin wilejakwa tule-taked-wilubmalmo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tegin Jesús chogalbal: “Imi pemal melle yogasal tule-pidgin chogdago: ‘We tuledin immal akalos,’ Pab pegin melle chognonigalmo: ‘Pedin iskusmo.’ Tegin pe melle tule-pidgin chogdamalbalo: ‘We tule sapejul oturdaleged-wilub,’ Pab pegin melle chognonigalmo: ‘Pedin sapejul oturdaleged-wilubmo.’ Tenal pe tulega chogzhal: ‘Pe-iskued pelgus,’ Pab pega chognonimogo: ‘Pe-iskued pelgusmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Tegin pemal tule-pimaladga immalmal ukenabmal. Imi pe tule-pidga immal ukchal, Pabdin izhe-kwamakal okpinalebaa pega immalmal ukmogo. Tenal pe ibi-wilub pe ebúdin, Pab pe-wilub-ebuged-unni pega immalmal ukmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tegin Jesús tulemalga purpal chogalbal: “¿Imi tule-aku-ataged nabir tule-aku-ataged-pid-iktuo pe ebinzhe? Chulá. ¿Tenal tule-aku-atamalad-walbo-pel aga ya-yabal arkwatmalojulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Imi tule-oturdakedbal-turdananimalad kwen unnijul tule-oturdakedga pul immal wisgugal. Tenal tule-oturdakedbal pél turdasmalal, kep unnigumogo tule-oturdakedyob immalmal wisgumalgal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tegin Jesús tulemalga purpal chogalbal: “¿Imi pe takchal, pe-kwenad aku-atagedbal iche immal wis akalos, tule imiagin turwa-totó megwijadyob nuekwa immal takchul, ibiga pe we tulegin istar chunmanonidadé? Tenal pedin aga tukin aku-itomo pe peyedzhe immal akalodimogad, tule imiagin chowal-kia-maidyob aku aga pe takmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Tenal tule imiagin chowal-kia-maid aku takel, ¿tede we tule igi kwenadga chogo: ‘Kwenad, an pe-wis-pentagwelo pe-imiagin-turwa-maid chugal?’ Keg kue. Imi pemal peyedzhe immal-akalojadbal keg aga pe kwenad-penta e-immal-akalojad wis nudagal. “¡Pemal pinche-askinbi-nued-nanemalad! Imi pemal-inzhel aga pe-taed nudakenabmal, kep pe unniguo aga pe-kwenad-pentagal e-taed nudagal, tule aga e-imiagin chowal-kia-maid chujadyob kep unniguo aga e-kwenad-imiagin turwa-maid chugal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tegin Jesús chogalbal: “Imi chapi-chan-nuegan kwen nikchul istar kulle. Tegin chapi-chan-iskana kwen nikchul yer kulle. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tenal chapimal-ilbal e-chanmakedbal mag taklenoniko ibi-chapimal. Imi wag-islub-chan, chapi-iko-nikadgin pe kwen onogojul-kuo chan-nani. Tenal uva-chan, tub-iko-nikadgin pe kwen onogojulbal chan-nanimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Imi anmal-tule ampa chapimalyobmo. Tenal tule-nuedil, aga ulubgin nugu-pinzheedbal immal-nuegan imanoniko. Tenal tule-iskanagwal, aga ulubgin istar-pinzheedbal immal-iskana imanoniko. Tenal tule aga ulubgin pinzheedbal nued chunmanoniko o istar chunmanoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Tegin Jesús chogalbal: “¿Ibiga pemal anche kolmalde: ‘Tummad,’ tede pemalde an-choged-pallí immal kwen imajulmal? Imi pemal an-choged-pallí immal imaked-wilubmalan. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Tenal an pemalga oyone tule anche tanikil tegin an-itosbalil, tegin an-chogzhad-pallí-tael, we tule igi nane. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nabir. Imi tule an-chogzhad-yopí naneel, tule nuekwa akwa-neg chobzhadyob. Tenal we tule akwa-neg chobzhogalgu, nap-ulak akwapirgin neg-kaed mezhis. Tenal ti peyedzhe noalgu, neg-odononi, tenal akwa-neg-nuekwa-choblejadbal, kwen aglaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Tenal tule an-nued-itojal, tenal an-chogzhad-pallí kwen nanejulil, we tule pollé akwa-neg chobzhadyob. Tenal we tule pinche ukubgin akwa-neg chobzhadyob. Tenal ti peyedzhe noalgu, neg odononi, tegin akwa-neg-pollé-choblejadbal ilgwen aglad, tegin we akwa-neg ilgwen pelgunonijun. Al pemal an-kaka-itosmalal, ampa an-chogzhad-pallí pe pél immal imakenabmal. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tegin Jesús tule-pukmaladga pél chunmasgu, neg-kwebur-Capernaumzhe nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Imi teun takalgu, Capernaumgin Romano-chulub-tummad-e-mos-pilaled yee-pakal mai, iche-napi purkwedani. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tegin Romano-chulub-tummad Jesús-wisgusgu, Judio-chelegan-palmis Jesúszhe wilegal e-negzhe taggal tegin e-mos-yee-maid-nudagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tegin Judio-chelegan Jesúszhe nonimalgu, Jesúszhe peyedzhe wilenaigualmal Romano-chulub-tummadga e-mos-nudagal. Tegin Judio-chelegan Jesúsga chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Imi chulub-tummad anmal-tule-pilaledbal anmalga Judio-ormaked-neg chobzha. Al pe keg-chulgu chulub-tummad-pentaked-wilubmo. Tegin Jesús Judio-cheleganga chogal: —Tegil nabirde. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tegin Jesús Judio-tummaganbak mes alzhun Romano-chulub-tummad-negzhe. Tegin Jesús chulub-tummad-neg omodanikidgin, chulub-tummad Jesús-abin aga e-aimal-palmial. Tenal chulub-tummad-e-aimal Jesús-abingusgu, Jesúsga chogalmal: “Imi Romano-chulub-tummad chogdo, pede melle e-negzhe tago. Imi ede kwen unnijul e-neggin pe-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Al chulub-tummad kwen alzhul-kusbal pebak assapin chunmagal. Tenal chulub-tummad chogbaldo, pede unnila kakagin chogzhal, e-mos nuguo, e-mos ilgwen nugunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Tenal chulub-tummad chogbal, ede tummad-nikamo tummad-ulpallí nanegal. Tenal ede aga e-chapingan-nikamo. Tenal ede e-chapingan-walgwenga chogzhal: ‘Pe nao,’ we chapin keg-chulgu neenab. Tegin ede e-chapin-pidga chogzhabalil: ‘Pede tago,’ we chapin keg-chulgu tagenab. Tegin ede e-mosga chogzhabalil: ‘Weob pe imako,’ we mos keg-chulgu immal imakenab.” ");
INSERT INTO kvnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tegin Jesús tule-chulub-tummad-kaka-chognonikid-pal-itosgu, weob pakal pes. Tegin Jesús tulemalzhik akpiridgu, tule-ebal-irmadimaladga chogalzhun: —Imi an chunchunnad pemalga chogdo: imi meke-pia, we tule-ankin-penzhulidyob an tule-kwen-taktijul, Israel-napche-pakal pel chul. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tegin chulub-tummad-tule-palmismalad kannan chulub-tummadzhe nonimalgu, pato taknonimal, chulub-tummad-e-mos pato nugus. Tenal Jesúsdin panna-akar chulub-tummad-e-mos-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tegin Jesús chulub-tummad-mos-nudajad-cholbal, Naín-neg-kweburzhe nad. Tenal Jesús-e-chapingan tegin tulemal-ichejul Jesúsbak mes natapmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tegin Jesús Naín-neg-kwebur-e-wanagak-omodanikidgin, tulemal Jesús-abin tule-mui-cheidanimal. Tenal machi-purkwijad-e-nan tanimo. Tegin tulemal-ichejul e-nanbak mes irmadanimalmo. Tenal machi-purkwijad-e-nan e-machered pato tarbi purkwis. Tenal we ome nuskan-pid-pal-nikchul-choggu, al machi-purkwijadbi aga nan-akwediin. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tegin Tummad-Jesús ome-takchagu, tule-pid-pal-nikchul ome-akwegal, wilejakwa ome-taknoni. Tegin Jesús omega chogal: —Melle pe poma. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tegin Jesús kachigin tule-purkwijad-cheidanimalad-abir kwisgunonigu, kachibal tule-purkwaled-kas. Tegin tule-cheinatapmalad kwisgusmalzhun. Tegin Jesús tule-purkwis-maidga chogal: —¡Machi, an pega chog pe kwisgu! ");
INSERT INTO kvnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tegidgin tule-purkwijad kachigin chigwis tegin chunmakalzhun. Tegin Jesús machi-e-nanga chogal: —Itigin pe-machi, an pega kannan tar-otulos. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tegin tulemal-Jesús-machi-otulojad-takchamalad-pel-kwapa Jesús-tobgualmal, tegin Pab-Tummad-otummoalmalmo, chogalmal: —Imi Pab-kaka-palchoged-pul-tummad anmal-abalgin nononi. Tegin tulemal chogalmalbal: —Imi Pab Tummad aga e-tulemal-pentanoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tegin Jesús-tule-otulojad-kaka mimmilemai-kuszhun pel-kwapa Provincia-Judeagin tegin tulemal-pel-kwapa aka-mamimaladzhe-pakal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Imi teun takalgu, Juan-e-chapingan Juanga chognonimal, Jesús pél immal imajad. Tegin Juan Jesús-immal-imajad itosgu, walbo aga e-chapingan-amis Jesúszhe palmigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tegin Juan aga e-chapinganga chogal: —Imi pemal Jesúszhe nadmalal, ka pe chogo: ‘¿Pede chunchunnad Pab-akpene-chogzhad-palmidagoed-tule-dewa o anmal tule-pid-abintakenab-dewa? Anka nuekwa kaka palmidabalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tegin Juan-e-chapingan nadmalzhun Jesúszhe. Tegin Juan-e-chapingan Jesúszhe nonimalgu, Jesúsga chogalmal: —Imi Juan Bautista anmal-palmial peje ekisgal: ‘Pede chunchunnad Pab-akpene-chogzhad-palmidagoed-tule-dewa o anmal tule-pid-abintakenabmal-dewa.’ Pede ega nuekwa kaka palmidago. Tegin Jesús Juan-e-chapinganga chogal: —Tegil nabirde. Tenal pemal an-wis-abintamalgwelo pe an-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tegin apka-tegidgin Jesús Juan-e-chapingan-wagin ichejul tulemal-nudas: poni-nikmalad, tule-yemalad, tule-nia-nikmalad, tegin tule-aku-atamalad pel-kwapa nudas. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tegin kep Jesús Juan-e-chapinganga chogal: —Imisgin pe nemalzhunno Juanzhe. Tenal pe Juan-omojal, pe Juanga chogo, pél pe imial takchad, pél ual pe itojad. Tegin pe Juanga chogbalo, tule-aku-atamalad nabir atanonimal, tegin tule-mego-mego-nanemalad nabir-nane-pesmal, tegin tule-lepra-poni-nikmalad ilgwen nugusmal, tegin tule-chuchu-yallilmalad mag-itos-pesmal, tegin tule-purkwismalad kannan tullesmal, tegin tule-wiledimaladga Pab-kaka-nuegan choglenaibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tegin pe Juanga chogbalo: ‘Imi meke-ibi-tule an-immal-imanaidbal Pab-Tummad-kwen-ebeszhulil, we tulega ib-nuedga kunoniko.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tegin Juan-e-chapingan naded-cholbal, Jesús tule-pukmaladga Juan Bautistagin chunmakal chogal: —Imi pe neg-nikchulidbal arpigusgu, ¿ibi pe takti-kusmal? ¿Tule-keg-ilgwen-chunmaked kaiki-purwabal-akpanedyobid? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tegil ibi pe takapchun? ¿Tule-mol-nuegan yowed? Chulá. Tenal tule-mol-nuegan-yomalad erreymal-ampagumalad-negmalgin, immal-nuegan-wilub-okpis-nikadgin mamimal, neg-nikchulidbal chul. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tegil ibi pe takapchun? ¿Tule-Pab-kaka-palchoged? Teobdo. Tenal an chunchunnad pemalga chogdo: Juan Bautista Pab-kaka-palchogmaladga pul-pule tule-tummad. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tenal Pab-karta Juan Bautistagin chogzhado: Imi antin pe-iktual tule-igal-nudaked-palmine, pega igal nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Tenal an chunchunnad pemalga chogdo: imi tulemal-iti-napkin-mimmilesmalad-abalgin, Juan Bautistaga pul tule-tummad kwen nikchul. Tenal Pab-neg-takmaidgin meke-ibi-tule-pul-totogwadzhe-pakal Juan Bautistaga pul tule-tummad.” ");
INSERT INTO kvnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Tenal tulemal-pel-kwapa tegin tule-Romano-tummadga-tulemalgin-mani-egwanmaladzhe-pakal, Juan Bautistabal-tigin-oglesmal. Al we tulemal Jesús-chunmajad-itosmalgu, chognonimal Pab Tummad yer igal mezhis. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tenal Pariseomal tegin Pab-igal-wismalad Juanbal-tigin-obzhajulmal. Al we tulemal Pab-ega-immal-imabied kwen abingaszhulmal.) ");
INSERT INTO kvnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tegin Jesús chogalbal: “¿Imi an ibimalayob an pemalga tule-imis-pukmalad-oyogo nabir wichul? ¿We tulemal ibiyob-takle pe ebinzhe? Nabir. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Imi tule-imis-pukmalad nuskan-purwigana tule-ampagumaladgin aga emal-emal kolbuktamaladyob. Tenal we purwigana chogdamalo: Imi anmal pemalga kammu-okochamal, tenal pemal kwen kwichajulmal. Tegin anmal pemalga pukib-itoged-namaked namasmal, Tenal pemal kwen poszhulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Imi Juan Bautista mas-kunchulidgin tegin vino-kobzhulidgin pemalzhe noni. Tenal pemal chogmal: ‘Juan Bautistade nia-nika.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tegin an-Te-Tule-Chunna nonigu, mas-kunnedgin tegin kobedgin noni. Tenal pemal ankin chogmal: ‘We tule aku-aku-mas-kunned tegin mumurgued-tule, tegin tule-Romano-tummadga-mani-egwanmaladbak ai-nued, tegin tule-iskued-nikmalad-e-aibal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Imi tule-imis-pukmalad Juan-tegin-an-kwen-abingaszhulmal. Tegil ¿igi pe wisgunoniko an-igal ib-chunchunnad o chul? Nabir. Imi tule-an-abingasmalad-e-taedbal kep kujal mag taklenoniko an-igal ib-chunchunnaddo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tegin te ibagwengin Pariseo-walgwen Jesúszhe kocha e-negzhe mas wis kuntagal. Tegin Jesús Pariseo-negzhe nadzhun mas kunkal. Tegin Jesús Pariseo-negzhe omosgu, mas kunnalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Imi teun we neg-kweburgin ome-macherganbi-wijiid kudimo. Tenal we ome wisgusgu Jesús Pariseo-neggin mas kunchii, ome alabastro-pudegin ti-wawad-annik-noni. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tegin ome Jesús-nag-tukubal poe-pakal kwisgunoni. Tegin ome Jesús-naggin imialis-tedemajad, e-chagla-kiagin Jesús-nag elisbal. Tegin ome Jesús-nag usgu, Jesús-naggin ti-wawad imas. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tegin Pariseo-Jesúszhe-kochad takchagu ome Jesús-naggin ti-wawad-imas, aga ulubgin pinzheji-kual: “Imi Jesús Pab-kaka-palchogedilen, pato wisgujan ibi-ome-wede, tegin Jesús wisgusbalin we ome macherganbi-wijiid.” ");
INSERT INTO kvnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tenal Jesús wisdo Pariseo igi aga ulubgin pinzhejii. Al Jesús Pariseoga chogal: —Simón, an kakabo pega immal wis chogbido. Tegin Pariseo-Simón Jesúsga chogal: —Tule-oturdaked, pe chogden an pe-itogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tegin Jesús purpal Simónga chogalzhun: —Imi tule-walbo tule-mani-ibedgin mani kalenai; walgwen ol-mani-tulaataled-ilatal kalenai, kwéntin ol-mani-tulabo-kakaambe kalenaimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tenal tule-mani-ibed takchagu we tule-walbogwad keg ega mani-kalenaid penukkus, mani-ibed we tule-walbogidga chogal: ‘Pemal melle anka mani-kalenaid pal penukmalo.’ Tegin Jesús chogalbal: —Simón, imisgin anka pe chogdo: ¿piti tule-mani-kalenai-nad-walbogid pul mani-ibed-pilalguo? ");
INSERT INTO kvnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tegin Pariseo-Simón Jesúsga chogal: —Antin, an chog, tule-pul-ichejul-mani-kalenai-nad pul tule-mani-ibed-pilalguo. Tegin Jesús Pariseo-Simónga chogal: —Pe nued chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tegin Jesús omezhik akpiridgu, Pariseo-Simónga chogal: —Simón, pe tak we ome. Imi an pe-negzhe tognonigu, pe anka ti kwen ukchajul nag enukkal. Tenal we ome e-imialisgin an-nag wartichas, tegin e-chagla-kiagin an-nag elisbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tenal pe igal-mamikidbal pe an-wagal-kwen-uszhul-kus. Tenal we ome an-pe-negzhe-tognonikid-akar an-nag unai. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tenal pedin an-nonogin kwallu-wawad kwen imaszhulbal. Tenal we ome an-naggin ti-wawad imasbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Al an pega chogdo, we ome peyedzhe an-pilaledbal, we omega ichejul iskued pelgunonijun. Tenal an tulega iche-iskued pelgus chogzhal, we tule iche an-pilalgunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tegin Jesús omega chogal: —Pe-iskueddin pato pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tegin tulemal-pimalad-pukmalmogad aga emal-emal ekichialmal: —¿We Jesúsdé, ibi-tule-wede, tulega iskued eliedde? ¿Pab Tummadbi nabir tule-iskued elijulzhi? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tenal Jesús omega chogalbal: —Pe-ankin-penzhulidbal pe abonolenoni. Imisgin pe akalzhul pe nejunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tegin Jesús Pariseo-neggin-mas-kuchad-cholbal, neg-kweburgangin tegin neg-kwebur-purwiganagin pipirmadi-kualzhun. Tegin Jesús we neg-kweburgangin Pab-neg-takmaid-kaka-nuegangin chunmadi-kus. Tenal teun takalgu, e-chapingan-walambe-kakabogwad Jesúsbak kudigusmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tenal teun omegan-wal-walgwen akpene nia-nikujad tegin poni-nikujad-Jesús-tar-nudajad Jesúsbak tigusmalmo. Tenal we omegan: María-pimalbalid-Magdalena. Tenal Jesús we María-akar walakugle nia-onijad. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tegin Juana tigusmo. Tenal Juanadin Chuza-ome. Tenal Chuzadin Errey-Herode-e-neg-taked-pul-tummad. Tegin Susanna tegin omegan-pimalad-ichejul Jesúsbak pipirmadi-kusmalmo. Tenal we omegan e-immal-nikadbal Jesús-pentadi-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tegin tulemal-ichejul neg-kwebur-pid-pid-akar irmanonimal Jesús-itogal. Tegidgin Jesús tulemalga purpal chunmakalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Imi te ibagwengin tule-walgwen nad mie-mie immal-kwa imagal. Tegin tule immal-kwa minaidgin, immal-kwa kwen igal-nanemaladgin apatis. Tenal we immal-kwa, tulemal kin anas-ne, tegin chikwimal we immal-kwa masmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Tegin immal-kwa kwen akwapir-ulak-naidgin apatis. Tenal we immal-kwa nisgu, neg-walajulidbal pulzhul tinkus. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Tegin immal-kwa kwen iko-kwa-naidgin apatis. Tegin we immal-kwa nisgu, iko-kwabak mes nismo. Tegin immal-kwa tunkusgu, ikodin immal-kwa-nued-nijad izhos, al keg chanmagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Tegin immal-kwa kwen napa-nuedgin apatis. Tegin we immal-kwa tunkusgu, yer chanmanoni, kal-kwengin tulaataled-ilgwen chanmas.” Tegin Jesús weob chunmasgu, sapejul kote, chogal: —Imi an-pega-chogzhad pe nuekwa itomalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tegin e-chapingan Jesúszhe ekichial: —¿Tegil we igalde igi choglejun pe immal-kwa-tiglejadgin chunmajaddé? ");
INSERT INTO kvnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tegin Jesús aga e-chapinganga chogal: —Imi Pab-neg-takmaid-igal otukal mai. Tenal Pab pemalga igal-ukcha mag we igal itogal, tenal Pab tule-pimaladgadin igal-kwen-ukchajul. Tenal an we tulemalga purpal Pab-neg-takmaid-igalgin chunma. Imi Pab-kartagin chogdo: Tule-takpukmalad aku taknonimalo, tegin tule-itobukmalad aku itononimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Al an pemalga mial immal-kwa-tiged-igal chognejun, ibi-chogle-wede. Imi immal-kwa chogle, Pab-kakapurwa-nued. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Tegin immal-kwa-igalbal-apatismalad chogle: tule-wal-walgwen Pab-kakapurwa itojal, nia-sagla ulubgin kin chunmanoniko Pab-kakapurwa igegal, melle Pabgin ibzhegal, tegin we tule melle Pabgin abonolegalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Tegin immal-kwa-akwapir-ulak-naidgin-apatismalad chogle: tule Pab-kakapurwa itojal, weligwaledgin Pab-kakapurwa abingao, tenal we tule nuekwa Pab-abingejulmal. Al we tulemal ichejal Pabbak wis kudiguo. Tenal apka te-cholbal wilub-taklenonikoedgin, ilgwen Pab-igedo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Tegin immal-kwa-iko-naidzhik-apatismalad chogle: tule Pab-kakapurwa itojal, Pab-kakapurwa abingenoniko. Tenal we tulemal Pabbak-kudiidgin iti-napkin-pinzheedbal pukib-itoged kin nakwidago. Tegin we tule immalmal-ichejul-nikuedbal tegin weligwal aga chan-imakedbal, e-pinzheed kalenoniko. Tegin we tule Pab-igenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Tegin immal-kwa nap-nuedgin apatismalad chogle: tule-nuegan tegin tule-nued-pinzhemalad. Tenal we tule Pab-kakapurwa itojal, Pab-kakapurwa-abingenoniko, tegin Pab-kwen-igeojul-kuo. Tenal we tulemal Pab-chogzhadyob pane-pane alamakedbal nued nanadamalo. Imi immal-kwa-tiged-igaldin weob chogledo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tegin Jesús chogalbal: “Imi tule-kwen-nikchul kallen ogajal mete-yabal chigal, o chulil, ulu-ulpal chigal. Tenal tule kallen ogajal, keg-chulgu kallen-kalugin chienabmal, tule-ukpomamimalad mag takegal kallen-neg-otalojii. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Al immal-otukal-maid keg-chulgu wisgulenoniko, tegin immal-otukal-kujad keg-chulgu mag taklenoniko, tegin immal otukal-kujad tulemal pél wisgunonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Al pe nuekwa pinzheenab pe igi Pab-ito-dewa. Tenal pe nuekwa Pab-itojal, Pab ukin pega e-pinzheed-pid uknonibalo. Tenal pe nuekwa Pab-itojulil, Pab pegin e-pinzheed egwannoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Imi teun takalgu, Jesús tulemal-oturdanaidgin, Jesús-e-nan Jesús-e-urpamalbak Jesús-taknonimal. Tenal tulemal-ichejul-wanagakkin-pukwadbal Jesús-e-kwenamalad keg Jesús-chiidzhe toggusmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tegin tule-takchamalad Jesúsga chognonimal: —Pe-nan pe-urpamalbak magarbal pukwamal. Emalde pebak chunmabimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tegin Jesús tulemalga chogal: —Imi tule Pab-kakapurwa itojal tenal keg-chulgu Pab-chogzhadyob nanemalal, wedin purpal an-nan tegin an-kwenamalad-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tegin te ibagwengin Jesús aga e-chapinganga chogal: —Nemal mata-opakal. Tegin Jesús aga e-chapinganbak ulgin nakwismalgu, nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tegin Jesús ulgin-natapmaladgin ul-yagin kabid. Tegidgin purwa pela-pela kolnonigu, mata peyedzhe tunkualmo. Tegin mata arwialgu ul-azhubal ti-milegalidbal ti ulgin engual. Al ul togdani-pes. Tenal Jesús-e-chapingan wichulmal emalde igi kunemal-dewa purkwenemal o tullenemal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tegidgin e-chapingan kueye-kueye Jesúszhe nonimal Jesús-otagal. Tegin e-chapingan Jesús-otasgu, Jesúsga chogalmal: —Tummad, pe tak anmalbi-ul-togdani. Anmal ogangudanimalbal. Tegin Jesús atasgu, kep purwaga tegin mata-arwedga chogal: —¡Pe wis pogiguma! Tegidgin purwa ilgwen poki nad, tegin mata ilgwen chiale-pesmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tegin Jesús aga e-chapinganga chogal: —¿Pe-ankin-penzhulidde igi pe kuddé? Tegin Jesús-e-chapingan Jesús-kwen-abinchaszhul-kus. Tenal Jesúsgin-kwakijadbal weob pakal pesmal. Tegin Jesús-e-chapingan aga emal-emal chogalmal: —¿Ibi-tule-wede? Purwa tegin mata-aroed Jesús-ega-chogzhad-pallí ibzhe. ¿Tegil we Jesús purwa-ibeddé? ");
INSERT INTO kvnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tegin Jesús aga e-chapinganbak yabli Galilea-mata-opakal omosmalzhun, Gerasaje. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tegin Jesús Gerasa-omopen naigunonimalgu, ul-akar aktesmal. Tegidgin tule-neg-kweburgined-nia-nikad-walgwen Jesús-abingusmal. Tenal teun we tule-nia-nikad pirkabalgus neggin kwen maichul. Tenal we tule uanbal chwili mai, mol pel nikchul. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tegin tule-nia-nikad Jesús-takchagu, sapejul kolmas, tegin Jesús-abir chimtinoni. Tegin tule-nia-nikad sapejul Jesúszhe kote chogal: —Jesús Pab-Pul-Tummad-e-Machiye, ¿ibiga pe ankin yoledani-wedeye? An peje wile, pe melle sapejul an-imakoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Imi teun Jesús pato niaga chogzhagusdo: “Pedin keg-chulgu we tule-akar pe noenab.” Tenal tulemal melugus ezha-tubgin chunkalgin tegin naggin tule-nia-nikad-etinmalan, melle wakingal. Tegin tulemal tule-nia-nikad-takkwisdamalbal. Tenal nia tulegin tognonikil, tule ilgwen ezha-tub-etilenaid idirda, neg-nikchulidbal wakisda.) ");
INSERT INTO kvnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tegin Jesús tule-nia-nikadzhe ekichial: —¿Igi pe nugdé? Tegin tule-nia-nikad Jesúsga chogal: —An nug Ichejulid. ¿Tenal ibiga Ichejulid nug pe ebinzhe? Imi nia we tulegin íchejul-mamikidbal weob nugdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tegin niamal kannan-kannan Jesúszhe wilenaigualmal melle Jesúsde nia-oturdaleged-negzhe e-palmidgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Imi teun takalgu, chinmal-ichejul yal-abal mas mabukmal. Al niamal Jesúszhe wilegalmal emalde nabir chinmalgin ukpoo-dewa. Tegin Jesús niamalga igal-ukchajun chingin ukpogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tegin niamal tule-akar nodmalgu, ilgwen chingin ukpotapmalzhun. Tegidgin chinmal arpak koelegalmalgu, pulal turmadmal, yal-urchikal-kwichidgin mataje pél apatismal. Tegin chinmal pél tigin ogangusmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tegin tulemal-chin-takpukmalad takchagu chin-ogangusmal, abarmadmal tulemal-igalbal-mamimaladga choge-nad tegin tule-neg-kweburginmaladga choge-nadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tegin tulemal wisgusmalgu tule-nia-nika-nad nugus tegin chinmal ogangusmal, al tulemal taknadmalzhun igi immal kujad. Tegin tulemal Jesúszhe nonimalgu, tule-nia-nika-nad-taknonimal Jesús-nabal mol-yowi nued-chii, pato koelegal-chul. Al tulemal Jesús-tobgualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tegin tule-takchamalad tule-nonimaladga palchogzhamal tule-nia-nika-nad igi nugus. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tegin Gerasa-tulemal-pel-kwapa Jesúsgin-kwakijadbal Jesúszhe wilenaigualmal ilgwen kannan Gerasa-neg-akar negal. Al Jesús kannan ulgin nakwisbal kannan negal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tegin tule-nia-nika-nad Jesúszhe wilenaigualmo, Jesúsbak mes negalmo. Tenal Jesús we tulega chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Tenal pedin keg anpak neel. Tenal pedin kannan aga negzhe neenab tulemalga pél palchoggal Pabdin igi pe-nudas. Tegin tule-nia-nika-nad nadzhun, tule-neg-kweburgin-pukmaladga pel-kwapa palchogzha Jesús e-nudasgujad. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tegin tulemal wisgusmalgu Jesús mata-opakal-akar tani, al tulemal-ichejul Jesús-abintabukmal. Tegin tulemal yer Jesús-abingasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tegidgin tule-walgwen Jesús-abir chimtinoni. Tenal we tuledin Judio-ormaked-neg-e-tummad-walgwen. Tenal we tule nug Jairo. Tegin Jairo Jesúszhe wilenoni e-negzhe negal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Imi teun takalgu, e-chiskwa-walkwénnagwad-pirkaambe-kakabo-nikad iche-napi-purkwedani-mai. Tegin Jesús Jairoga chogal: —Tegil nabirde, an pebak negzhe naodo. Tegin Jesús Jairo-negzhe nadedgin, tulemal-ichejul Jesúsbak ali-ali natapmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Imi teun takalgu, ome-walgwen Jesúsbak natapmo. Tenal we ome pirkaambe-kakabogus aga e-purpa-takedbak a-imadii. Tenal ome ina-tulganzhe ina chaabin, tenal omega yabli ina kwen kuszhul-kus, (tenal ome pinche-pakal pél aga mani misbal). ");
INSERT INTO kvnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tegin ome yankalbal-akar Jesús-mol-turpa-turpad ebusgu, apka-pakal omega e-ponigan akunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tegidgin Jesús chogal: —¿Toa an-ebusdé? Tegin tulemal-wal-walgwen Jesúsga chogalmal: —An wichíwa toa pe-ebus. Tegin Pedro Jesúsga chogal: —Tummad, ¿pe takchulzhí tulemal-ichejul pegin yolenanimal? ¿Igi pe wisguo: ‘We tule ankin walmas?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tegin Jesús kannan chogalbal: —Tenal an wisdo, tule-walgwen an-ebus. Tenal an naga mag itos, an tule-walgwen-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tegin ome itosgu Jesús e-wisgus, ome ampayo Jesús e-takeddu, tu-tu-tu-tu Jesús-abir chimtinoni. Tegidgin ome tulemal-wagin Jesúsga chogal, ede yola-pirkaambe-kakabo-kus aga poniganbak a-imadii. Tegin ome chogalbal ede Jesús-mol-tuku-ebujadgin apka-pakal ega e-ponigande akunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tegin Jesús omega chogal: —Puna, pe ulubgin ankin penzhul-kunonikidbal, pe nugus. Imisgin pe akalzhul nejunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tegin Jesús ampa ome-nugujadbak chunma-kwichidgin, tule-walgwen Jairo-neg-akar noni. Tegin we tule Jairoga chogal: —Jairo, pe-chiskwa pato purkwis. Pe melle Tule-oturdakedzhe pal wilego, pebak negzhe negal. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tenal Jesús tule-Jairoga-chognonikid itosgu, Jairoga chogal: —Pe melle akal-itogo, ankinbi pe unnila ibzhao. Tenal pe ankin ibzheel, pe-chiskwa yabli tullego. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tegin Jesús Jairo-negzhe omosgu, tule-pimalad-odogal kwen imaszhul. Tenal Jesús unnila odos; Pedro, Juan, Jacobo tegin puna-purkwijad-e-pab tegin e-nan. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tenal tulemal-neggin-pukmalad ponanimal, tegin pukib-itogedbal puna-purkwijadga okormananimalbal. Tenal Jesús tule-okormananimaladga chogal: —¡Melle pe pomalma! We puna purkwiszhuli, pinche kabmai. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tenal tulemal Jesúsga allealmal, tenal tule-ponanimalad nued wismaldo, punade purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tenal Jesús chunkalbal puna-kasgu, punaga chogal: —¡Puna, pe kwisguma! ");
INSERT INTO kvnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tegidgin puna-purpa kannan punagin tognonibalgu, puna ilgwen kwisgudzhun. Tegin Jesús puna-e-nanganga chogal: —Masgin pe puna-okunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tegin puna-kannan-tullejad-e-pabgan weob pakal pesmal. Tenal Jesús puna-e-pabganga chogal: —Pe melle tule-pimaladga pe palchogo, puna igi kannan tullejad. Imi teun Jesús weob Jairo-chiskwa-otulosdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tegin Jesús aga e-chapingan-walambe-kakabogwadzhe kocha ormagal. Tegin Jesús ormabukwadgin, aga e-chapinganga igal-ukcha kannaleged-nikugal tulegin-nia-onogal, tegin tule-yemalad-nudagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tegin Jesús aga e-chapingan-palmidzhun tulemalga Pab-neg-takmaidgin chunmagal, tegin tule-yemalad-nudagalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tenal Jesús ampayo aga e-chapingan-palmieddu, aga e-chapinganga chogal: “Imi pe nadmalal, pe melle kabaston chedo, pe melle muchila chedo, pe melle mas-kunned chedo, pe melle mani chedo, tegin pe melle mol-ogwaged chedbalo, chunkal-kwabi pe nemalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Imi meke-ibi-neg-kweburzhe pe omojal, ibi-neggin pe togdapódin, pe ilgwen we neggin peio, pe-needzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Imi meke-pia pe omos-dewa, tulemal pe-kwen-abingaszhulil, pe ilgwen we neg-kwebur-akar pe nao. Tenal pe we neg-kwebur-akar alil, pe kutargin nap-pur-nanikid pe opat-opat imako oyogal, Pab-kakapurwa pato we tulemalzhe arpi, tenal tulemal yabli Pab-kakapurwa kwen abingaszhulmal. Tenal tegi-kuo, Pab-kakapurwa we neg-kweburzhe pal kwen nonikojul-kuo.” Tenal teun Jesús weob aga e-chapingan-uanais Pab-neg-takmaidgin chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tegin Jesús-e-chapingan nadmalgu, neg-kwebur-purwigana-chijiid-ilbal Pab-kaka-nuegangin chunmake-nadmal tegin tule-yemalad-nudake-nadmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Imi teun Errey-Herode wisgus, Jesús immal imadiid. Tenal teun tulemal-wal-walgwen chogdimal, we Jesúsde Juan-Bautista-kannan-tullejad. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tenal tule kwen chogdimalmo, Jesúsde Pab-kaka-palchoged-Elías. Tegin tule kwen chogdimalmo, Jesúsde akpene-Pab-kaka-palchoged-purkwijad-walgwen-kannan-tullejad. Tenal tulemal-akal-akal-chogdiidbal, al Herode chuli-pinzhe-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tegin Herode chogalzhun: “¿Imi ante Juan-tukal-idiriszhulzhí? ¿Tede toa-tulejun an itogedde?” Tenal te-ulgin Herode sanal Jesús-takpi-kualzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tegin Jesús-nuggin-palmilegalmalad-walambe-kakabogwad kannan Jesúszhe nonimalgu, pél Jesúsga chognonimal, emalga igi immal kujad. Tegin Jesús pidzhi aga e-chapingan-walambe-kakabogwadbak Betsaida-neg-kweburzhik nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tenal tulemal wisgusmalgu Jesús Betsaidazhik nad, tulemal Jesús-cholbal nadmalmo. Tegin Jesús weligwal tulemal-abintas, tegin Pab-neg-takmaidgin tulemalga chunmas, tegin Jesús tule-nudalegoed-napimalad-nudasbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tegin neg-chedoalgu, e-chapingan-walambe-kakabogwad Jesúszhe nonimal. Tegin e-chapingan Jesúsga chogalmal: —Imi anmal neg-kweburgin pukchul-choggu, al pe tulemal-palmienabmal, we tulemal neg-kwebur-purwiganagin tegin tule-nagnugin-mamimaladzhe nemalgal, aga mas-kunned wis pakmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tenal Jesús aga e-chapingan-walambe-kakabogwadga chogal: —Tagoed. Tenal pemal we tulemalga mas-uked-wilubmal. Tegin e-chapingan Jesúsga chogal: —Tummad, anmal we tulemalga mas-kunned kwen paknejulil, mas-kunned kwen nikchul tulemal-okunkal. Imi anmalga madu-walatal tegin ua-ukabo wis mai. ¿Tede anmal igi tulemal-okunmalo? ");
INSERT INTO kvnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Imi teun tulemal-tégin-pukmalad macherganbi-miliatal, omegan tegin purwigana kwen choglejul.) Tegin Jesús aga e-chapinganga chogal: —Imi pemal tulemalga chognemalo, wala-tulabo-kakaambegin tunnul-tunnul ampagumalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tegin Jesús-e-chapingan tunnul-tunnul tulemal-urpismalzhun. Tegin tulemal Jesús-chogzhadyob pél ampagusmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tegin Jesús madu-walatal-tegin-ua-ukabo-chusgu, Pab Tummadga tog-nuedi chogzha. Tegin Jesús purwi-purwi madu pipichisgu, madu Jesúsga melgud. Tegin Jesús purwi-purwi ua-pipichisbalgu, ua Jesúsga melgudbal. Tegin Jesús aga e-chapinganga madu, ua-ukchagu, tulemalga chiapchun aga kunmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tegin tulemal-pel-kwapa immedzhe mas-kuchamalgu, ampa madu, ua-okpis. Tegin Jesús-e-chapingan mas-okpitchad ampa karpa-kwaambe-kakabog wesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Imi te ibagwengin Jesús pidzhi Pabzhe-kolnaidgin, e-chapingan Jesúsbak kudimalmo. Tegin Jesús aga e-chapinganzhe ekichial: —¿Tulemal igi ankin chogmal, ante toa-tule? ");
INSERT INTO kvnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tegin e-chapingan Jesúsga chogal: —Tulemal-kwénna-kwénna chogmaldo, pede Juan-Bautista-purkwijad. Kwéntin chogmo, pede Elías-patoun-purkwijad. Kwéntin chogmo, pede Pab-kaka-palchoged-pid-kannan-tullejad. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tegin Jesús aga e-chapinganzhe ekichialmo: —¿Anná, pemalde igi ankin chogmalmode, ante toa-tule? Tegin Pedro Jesúsga chogalzhun: —Pedin Cristo-Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tegin Jesús aga e-chapinganga chogal: —Imi pe melle tule-pimaladga pe palchogo, antin Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tegin Jesús aga e-chapinganga chogal: —Imi an-Te-Tule-Chunna peyedzhe wilegenab, tegin Judio-chelegan-tummagan an-kwen-abingaojulmal, tegin tule-irwal-Pabzhe-kolmalad-e-tummagan an-kwen-abingaojulmalbal, tegin Moisés-igalgin-tulemal-oturdamalad an-kwen-abingaojulmalmogo. Tegin tulemal an-mesmalo. Tenal an ibapágin kannan tullenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tegin Jesús pel-kwapa tule-e-itobukmaladga chogal: “Imi meke-ibi-tule anpal naigubiel, we tule pane-pane aga tukingabi pal kwen pinzhejulinab. Tenal we tule kuakwa kudiinabbal anka purkwegal, tule nakrusgin aga purkwe-natapidyob. Tenal tule an-chogzhadyob naneel, kep ankin turdanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Tenal meke-ibi-tule anpal-naidbal yapa purkwejogel we tule yabli pelgunoniko. Tenal meke-ibi-tule anpal-naidbal akalzhul purkwejogel, we tule kannan tullenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Imi tule iti-napkin pel-kwapa immalmal nikunonikilen, tenal purpa-abonoged kwen nikchulil, ¿ibi-nued we tulega kunoniko pe ebinzhe? Chulá. ¿Tenal tule ibi-immalmal-ukedgin unniguo aga purpa abonogal melle sapejul oturdalegal? Chulá. Keg kue. Tenal immal kwen nikchul tule aga purpa abonogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Imi meke-ibi-tule ankin chogzhal; ‘Ante wichí wedin toa-tule,’ tegin an-chogzhadgin chogzhabalil, ‘An we kaka wichul,’ an-Te-Tule-Chunna nugu-taklegedgin tegin an naga kannalegedgin tegin Pab-Tummad-kannalegedgin tegin angelmal-kannalegedgin iti-napche an kannan tanikil, an we tulegin chogmogo: ‘An wichí wedin toa-tule.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Tenal an chunchunnad pemalga chogdo: imi tulemal-pukwad-wal-walgwen ampayo purkweddu Pab-neg-takmaid takmalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tegin Jesús aga e-chapinganbak chunmajad ibapábak-kuchaledgin, Jesús walapá aga e-chapingan-ches: Pedro, Juan tegin Jacobo, pelugles Jesúsgin walabake. Tegin we tule-walabakegwad yal-tummad-pirzhe nadmal Pab Tummadzhe kolgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tenal teun Jesús Pabzhe-kolnaidgin, arpak e-wagal akalgunoni. Tegin Jesús-e-mol ilgwen chipú pi-pi-pip-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tegidgin tule-walbo yer-taklegedgin Jesúsbak chunmanonimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tenal we tule-walbogid, Moisés tegin Elías. Tenal we tule-walbogid Jesús-imichal-Jerusaléngin-purkoedgin chunmasmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Imi teun Pedro tegin e-pakamalad kabidzhá-pukwamal. Tenal Pedromal nued atasmalgu, takalmal, Jesús nugu-taklegedgin tule-walbogidbak chunmagwis. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tegin Moisés, Elías Jesús-akar nejogalidgin, Pedro Jesúsga chogal: —Tummad, anmal wegin nued pukwamal. Imi anmal pemalga kwapá obuneg chobnemal: pega kwagwen, Moisésga kwagwen tegin Elíasga kwagwenmo. (Tenal Pedro immal-kwen-wichulidgin chunmas, ede ibi chognai.) ");
INSERT INTO kvnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tegin Pedro ampa chunmanaidgin po aktenoni, tegin po pel-kwapa Jesúsmal-edunonimal. Tenal Pedromal po-tar-edudanikidgin kwakialmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tegin Pedromal po-yabal ukposmaladgin, tule-kakapurwa kolnoni chogal: “Wedin an-Machi, an-tar-nugzhajad anka immal-imagal. Imi pemal nue an-Machi-itogenabmal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tegin Pab-kakapurwa pél chunmasgu, Jesús-e-chapingan pato takalmal, Jesúsbi walkwénna kwichi. Tenal Jesús-e-chapingan tule-pimaladga Jesús-akalgujadgin kwen chunmaszhulmal, ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tegin te pangin, Jesús aga e-chapingan-walapágwadbak yal-akar aktenonimalgu, takalmal tulemal-íchejul Jesús-abintabukmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tegidgin tulemal-pukwad-abalgin tule-walgwen sapejul kolal chogal: —Tule-oturdaked, an-machi-walkwénna-nikadbal an peje wileye, pe an-machi-wis-pentakoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Imi an-machi nia-nika. Tenal nia an-machigin tognonikil, arpak kolmakalda. Tegin an-machi neg-owedel, pela-pela pintomakalda, tegin kaka maku-makaldabal. Tegin nia keg machi-iptakedbal pul-pule chabzhul machi-e-chan imanatap. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tenal antin pe chapinganzhe wilejan an-machigin nia-onogal, tenal pe-chapingan kwen unniguszhulmal we nia-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tegin Jesús chogal: —¿Imi pemal-ankin-penmalad tegin pe-yapa-an-itomalad, an inkwáje pemalbak kudiguenabmal-wede ankin penzhulmalgal? ¿Tegin an inkwáje pemal-abin-purtidio-wede, pemal kep ankin ibzhemalgal? Nabir. Imisgin pe anka machi-chedado, an pega nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tegin tulemal Jesúszhe machi-cheidanimaladgin, nia machi-olas. Tegin machi neg-owedgu, pintomamai-pes. Tenal Jesús niaje ulusgu, machi-nudas. Tegin Jesús machi-e-pabga nuedgin kannan machi-ukchabal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tegin tulemal-pel-kwapa-takpukmalad Pab-Tummad-kannaleged takchamalgu, weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tegin tulemal Jesús-machi-nudajadgin ampa weob pakal pejadgin, Jesús aga e-chapinganga chogal: —Machimal, an pemalga-immal-chogoed pe nuekwa itomalo pe melle igemalgal. Imi an-Te-Tule-Chunna tulemalzhe uklenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tenal Jesús-e-chapingan Jesús-chogzhad aku-itomal ibi chog. Tenal Pab Tummad Jesús-e-chapinganga igal-kwen-ukchajul Jesús-chogzhad itogal. Tegin Jesús-e-chapingan Jesús-tobgualmal Jesúszhe immal ekisgal ibi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Imi teun takalgu, Jesús-e-chapingan aga emal-emal imakalmal chogalmal, toa emal-abalgin pul tule-tummadga kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tenal Jesús wisgusgu e-chapingan aga ulubgin igi pinzhenanimal, Jesús machi-toto-amis tegin e-nabal okwisnoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tegin Jesús aga e-chapinganga chogalzhun: —Imi meke-ibi-tule an-nuggin yer machi-toto-abingajal, we tule pato weligwaledgin an-abingasmo. Tenal meke-ibi-tule yer an-abingajal, we tule pato weligwaledgin Pab-an-palmialid-abingasmo. Imi tule pemal-abalgin pul mosyob naneel, we tule pul tule-tummad. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tegin Juan Jesúsga chogal: —Tummad, anmal tule-walgwen-takcha pe-nuggin tulegin nia-onodii. Tenal tule-anmal-pakadzhulidbal anmal we tulegin igal-kasmal melle pe-nuggin nia-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tegin Jesús Juanga chogal: —Pe melle tulegin igal-kao an-nuggin tulemalgin nia-onogal. Tenal meke-ibi-tule anmalbak istar chulil, we tule anmalzhikidmogad. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tegin Jesús-e-wilubgan omosgu Pab-negzhe kannan negal, Jesús aga tukin chognoni, ede keg-chulgu Jerusalén-neg-kweburzhe neenab. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tegin Jesús igalbal-natapidgin, e-iktual Samaritano-neg-kwebur-totoje aga e-chapingan-palmis ega neg-toged amigal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tenal Jesús-Jerusalénzhe-natapidbal, Samaritano-tulemal-pukmalad Jesús-kwen-abingaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tenal Jesús-e-chapingan-Jacobo-tegin-Juan takchamalgu Samaritano-tulemal yapa Jesús-abingegusmal, Jesúsga chogalmal: —¿Tummad, imi pe pei, anmal Pabzhe kolmal nikpa-neg-akar cho palmidagal we tulemal-opelogal, (akpenegwad-Pab-kaka-palchoged-Elías imajadyob)? ");
INSERT INTO kvnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tenal Jesús Jacobo-tegin-Juanzhik akpiridgu, Juanmalga chogal: —Machimal, ¿ibiga pe tule-mejedgin pe chunmanani-wede? Pe weob chunmaked-wilubzhulmal. (¿Pe wiszhulzhí pe ibi-purpa nikamal? ");
INSERT INTO kvnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tenal an-Te-Tule-Chunna iti-napche noni tulemal-abonogal, tulemal-opelogal chul.) Tegin Jesús neg-kwebur-pidzhe nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tegin Jesús aga e-chapinganbak ampa igalbal-natapidgin, tule-walgwen Jesúsga chogal: —Tummad, meke-pia pe naódin an pebak nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tegin Jesús we tulega chogal: —Tenal pe nuekwa pinzheenabgwel. Imi chug-achu nap-ya nika meggal, tegin chikwimal ampa u nika-nemalmo meggal. Tenal an-Te-Tule-Chunnadin neg pel nikchul wis ulukugal. ¿Tenal pe anyob unnigumogojí neg-nikchul nanegal? Imi pe unnimogal, pe akalzhul anpak nemogodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tegin Jesús tule-pidga chogal: —Anpak nemalma ankin turdagal. Tegin tule Jesúsga chogal: —Tummad, an pebak nabir naoendo, tenal an pilal naga pab-taknegwelo. Tenal an-pab-purkwijad-cholbal kep an pebak nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tegin Jesús we tulega chogal: —Chuli machi. Imi tule-purkwemaloed meke tule-purkwaled-e-mui-tigmalo. Tenal pedin tulemalga Pab-neg-takmaidgin chunmanao. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tegin tule-pid Jesúsga chogalmo: —Tummad, an pebak nebimogando, tenal an pilal naga napi kwenamalad taknegwelo. Tenal an kwenamalad-takapid-cholbal kep an pebak nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tegin Jesús we tulega chogal: —Chuli machi. ¿Pe wiszhulzhí, tule nap okpinail, nuekwa takenab inniki chedgal? Tenal pe nuekwa takchulil, pega ibga kwen kunonikojul. Tenal tule-Pab-neg-takmaidga-arpaged ampamo. Imi pe igal-akpenegwad ebejulil, pega ib-nuedga kwen kunonikojul. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tegin Jesús pél chunmajad-cholbal, wala-tulapá-kakaambe-kakabog aga e-chapingan-nugzhas e-iktual negal. Tenal Jesús neg-kwebur-tummaganzhe tegin neg-kwebur-purwigana-e-naoedzhe wal-walbogin aga e-chapingan-palmijogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tegidgin Jesús aga e-chapinganga chogalzhun: “Imi tule-ichejul nika Pabbak naigugal, tenal tule walpókwa wis nika Pabga arpagal. Al an pemalga purpal chogzhundo: imi immal-kwa-weied ichejul nai weigal. Tenal tule-weimalad walpókwa wis nika. Tenal Pab immal-kwa-weied-e-ibed-choggu, al pe Pabzhe wilegenabmal tule-pimalad-palmidagal Pabbal-naigugal tule-imagal, tule immal-kwa weiedyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Imi antin purkwed-abalgin tulemalzhe pe-palmine, oveja-mimmi achu-kwegwed-abalgin kudimaladyob. Imisgin pe nadmalzhundo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tenal pe nadmalal, pe melle mani chedo, tegin pe melle muchila chedo, tegin pe melle kutar-ogwaed chedmalbalo. Tegin pe igalbal tule-takalil, pe melle kwisguo tulebak chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Tegin pe neg-togoedzhe tognatapil, pe chognatapo: ‘Anná, tegidde. Imi pemal-wegin-pukmalad akalzhul ampagumalalen, nabirin.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Tenal we neggin tule-akalzhul-itogedgin-naneed mail, pe-we-tulega-chogzhad-yopí keg-chulgu targa kued-wilub. Tenal we tule-ulubgin-akalzhul-itoged maichulil, pe-targa-chognonikidyob kwen kuojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tenal pe neg-togzhadgin tule pega meke-ibi-immala ukchal kunkal o kobgal, pe kunno pe kobo. Tenal pe melle neg ogwa-ogwa-nanemalo, pe ilgwen we neggin peio, pe needzhe. Imi tule e-arpagedbal keg-chulgu akwilegenab. Al pemal pinche akwilegenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tegin pe neg-kweburzhe nonikil, ibi-mas tulemal pega ukmalódin, te mas-kunned pe kunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tegin pe tule-yemamimalad-nudako. Tegin pe tulemalga chogo: ‘Pab-neg-takmaid pato pemal-omodani.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Tenal pe neg-kwebur-kwagwenzhe omojal, tenal tulemal-pukmalad pe-kwen-abingaszhulmalal, pe neg-kwebur-igalmalbal pe nao. Tegin pe chogo: ");
INSERT INTO kvnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Imi pemal-anmal-abingaszhulidbal anmal kutargin nap-pur-nanimaladzhe-pakal opatnemal oyogal anmal pemalzhe pal kwen tanikojul, pemalga Pab-igalgin chunmagal. Tenal pe nuekwa wisgugal an pemalga chogdo: Imi Pab-neg-takmaid pato omodani.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Imi an chunchunnad pemalga chogdo: imi Pab Tummad sapejul tule-oturdakoed-wilub nonikoedgin, we neg-kweburgin-tulemal-pe-abingaszhulmalad Sodoma-tolganga pul-pule sapejul oturdalenoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tegin Jesús chogalbal: “¡Corazín-tolgan anpi pe wilesmalma, pemal peyedzhe oturdalenoniko! ¡Betsaida-tolgan anpi pe wilesmalmoma, pemal peyedzhe oturdalenonimalmogo! Tenal Tiro-tolgan tegin Sidón-tolgan pemalyob immal-taktijulmalad takchamalalen, pato tikajulgus cho-purgin obzhamalan, tegin chagu-mol yosmalbalin, oyogal emalde aga ulubgin iskuedgin pukib-itononimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Al Pab-tulemalga-igal-itoged-ibegin pemaldin Tiro-tolganga tegin Sidón-tolganga Pab Tummadzhe pul-pule sapejul oturdalenonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tegin Jesús chogalbal: “Capernaum-tolgan, ¿pemal ebinzhebukmal peyedzhe otummoledi-kuo? Chulá. Tenal pemaldin ankin-ibzhejulidbal pul-pule nug iskunonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tegin Jesús aga e-chapinganga chogalbal: “Imi tule yer pe-chunmaked itosmalal, we tule yer an-chunmaked abingasmo. Tenal tule pe-chunmaked abingaszhulil, we tule an-chunmaked kwen abingaszhulmo. Tenal tule an-abingaszhulil, we tule-an-palmialid-kwen-abingaszhulmo.” Tegin Jesús-e-chapingan nadmalzhun Jesús-ega-chogzhadyob immal-imagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tegin Jesús-e-chapingan-wala-tulapá-kakaambe-kakabogwad weligwaledgin kannan Jesúszhe akpirnonimalgu, Jesúsga chognonimal: —Tummad, imi niamalzhe-pakal anmal-pe-nuggin-immal-imajadbal anmalbal ibzhasmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tegin Jesús aga e-chapinganga chogal: —Tenal pe melle tummarba itomalo. Imi an takchado nia-sagla-Satanás tummarba-itogedbal nikpa-neg-akar maripedyob iti-napche arkwannoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tenal an pemalga igal-ukchado, nakpemalgin tegin tiolmalgin annegal. Tegin an pemalga igal-ukchabal pemal pe-aichulid-Satanás-kannalegedgin nakwegalbal. Tenal pemal yabli kwen naklik-kunonikojulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tegin niamal-pe-chogedbal-ibzhajadbal pe melle welgumalo. Tenal Pab-neggin pe-nug-nermalejadgin pe welgumalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Imi teun Jesús Pab-Purpa-Nued-nikadbal pela-pela weligwaledgin chogal: “Pabye, an pe-otummoye. Imi pe nikpa-neggin tegin iti-napkin e-Tummadga maiye. Tenal pe tule-immal-wismalad tegin tule-nono-nikmalad an-immal-imajad aku-itogal pe imasbalye. Tenal an-immal-imajad pe mag-itogal tule-polgana-imasbalye. Al an pe-nug otummoye. Pabye, an wisdo, pe yer itos weob immal imagalye. Imi pe weob immal-imajadyob an weob peigunainye. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tegin Jesús chogalbal: “Imi an-Pabdin pel-kwapa anka immal ukcha an immal imagal. Tegin tule-kwen-nikchul nuekwa Machi-wisgugal, tenal e-Pabbi nuekwa e-Machi-wiis. Tegin tule-kwen-nikchulbal nuekwa Pab-wisgugal, tenal e-Machibi nuekwa e-Pab-wismo. Tenal e-Machi aga e-itolegedbal tule-ima e-Pab-wisgugal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tegin Jesús aga e-chapinganzhik akpiridgu, e-chapingangabi chogal: “Imi pe-imial-an-immal-imajad-takchadbal, ib-nued pemalga kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Imi an chunchunnad pemalga chogdo: Pab-kaka-palchogmalad-ichejul tegin erreymal-ichejul pe-immal-takchiidyob takpi-kusmogan, tenal we tulemal yabli kwen takchajulmal. Tegin we tulemal pe-immal-itosmalad itobi-kusmalmogan, tenal we tulemal yabli kwen itoszhulmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tegin te ibagwengin tule-pirkin-Moisés-igal-wijiid arpak kwisgual Jesús-wilub-takegal. Tegin tule-pirkin-igal-wijiid Jesúsga chogal: —Tule-oturdaked, ¿an igi imakel nabir ilagwen Pab-neggin meggal, tegin an melle pal purkwegalbal? ");
INSERT INTO kvnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tegin Jesús we tulega chogal: —Nabir. ¿Tenal Moisés-igalgin igi nermakal-mai-chogna? ¿Igi pe apcho? ");
INSERT INTO kvnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tenal tule-Moisés-igal-wijiid Jesúsga chogal: —Imi pe Pab-Pul-Tummad-pilalguenab, pél aga pe-ulubgin-itogedzhe, pél pe-purpaje, pél pe-kannaleged-nikadzhe, pél pe-pinzheedzhe, pel-kwapa. Dt. 6:5 Tegin pe aga tukin chan pilaledyob tule-pe-tikalbal-mamimalad pe pilalguenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tegin Jesús we tulega chogal: —Eye, pe nued chogzhado. Tenal pe chogzhadyob pe naneel, pe ilagwen-nadgu tullego, pe pal kwen purkojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tenal tule-Moisés-igal-wijiid, melle tule-kegeyob peigal, Jesúsga chogalbal: —Nabir pe anka chogzhando, ¿tenal toa-tulemalzhun an-tikalbal-mamimaladdé? ");
INSERT INTO kvnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tegin Jesús purpal tule-Moisés-igal-wijiidga chogal: “Nabirdo. Imi te ibagwengin tule-walgwen Jerusalén-akar Jericóje nad. Tegin tule igalbal-natapidgin tule-iskana-abingus. Tegin tule-iskana we tulegin mol chus. Tegin tule-iskana peyedzhe we tule-sakisbal. Tegin tule-iskana igalbal neg-wichul mellemai we tule-ebesbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Tegidgin tule-irwal-Pabzhe-koled-walgwen igalbal immal-kwen-wichul tanikidgin, arpak mellemai tule-taknoni. Tegin tule-irwal-Pabzhe-koled mellemai tule-takchagu, tikabal tule-mellemaid-ebiris. Tegin tule-irwal-Pabzhe-koled ilgwen ukin nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Tegin tule-pid, tule-irwal-Pabzhe-kolmalad-pentamalad-walgwen, tule-mellemaidzhe nonimo. Tenal tule-nonikid pinche imial tule-mellemaid-takchagu ilgwen ukin nadmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Tegin Samaritano-tule-walgwen ampa igalbal tanimogadgin panna tule-sakilejad-taknonimo. Tenal Samaritano-tule wilejakwa tule-sakilejad-taknonikidbal, tule-sakilejad-waglik kwisgunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tegidgin Samaritano-tule, tule-sakilejadga ina chaalzhun. Tegin Samaritano-tule, tule-sakilejad-ya-chijiidgin kwallu tegin vino imas, tegin molgin ya-ebirmasbal. Tegin Samaritano-tule aga e-moli-burrogin tule-sakilejad-onakwisgu, tule-kabmalad-negzhe tule-yeed-ches. Tegin Samaritano-tule kabmalad-neggin nuekwa tule-sakilejad-takcha. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Tegin te pangin Samaritano-tule neg-ibedga tulabo e-mani ukchagu, neg-ibedga chogalbal: ‘Imi pe anka nuekwa we tule-tako. Tenal an-pega-mani-ukchad ampa pega akuel, pedin, pe aga pe-manigin we tule-pentagwelo. Tenal an kannan tanikil, pe-mani-owejadun an kannan pega penukbalo.’ Tegin Samaritano-tule ukin nadzhun. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tegin Jesús tule-Moisés-igal-wijiidzhe ekichial: —¿Imi piti we tule-walpágwad tule-e-waglik-mamimaladyob tule-sakilejad-pentas? ");
INSERT INTO kvnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tegin tule-Moisés-igal-wijiid Jesúsga chogalzhun: —Samaritano-tule wilejakwa tule-sakilejad-taknonikidde. Tegin Jesús tule-Moisés-igal-wijiidga chogal: —Pe nued chogzhado. Tenal pe imis-akar we Samaritano-tuleyob pe tule-pentakenabmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tegin Jesús aga e-chapinganbak natapidgin, neg-kwebur-totoje omosmal. Imi teun ome-walgwen-Marta-nugad we neg-kweburgin chimo. Tegin Jesús we neg-kwebur-totoje nonigu, Marta weligwal e-neggin Jesús-abingas. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tenal Marta urpa-nika. Tenal Marta-e-urpadin nug María. Tenal Maríadin Jesús-nabal chii-pes Jesús-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tenal Marta echar-echar-immal-imanaidbal Maríagin Jesúsga chognoni: —Tummad, ¿pe akal kwen takchul, an-urpa an-kwen-pentajul? ¿Ibiga pe keg Maríaga chogde an-wis-penta? ");
INSERT INTO kvnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tegin Jesús Martaga chogal: —Marta, imi pe ichejul immalmal-cheedgin pinzheedbal, pe sae-itonai. ");
INSERT INTO kvnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tenal immal-choggwen pul-chunchoged naido. Tenal María pul-ib-nued chus an-chunmaked itogal. Tenal antin Maríaga kwen chogojul-kuo. ‘Pe we-akar nao.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Imi te ibagwengin Jesús akne Pabzhe-kolnaid pelgusgu, e-chapingan-walgwen Jesúszhe wilenaigual chogal: —Tummad, pe anmal-wis-oturdama Pabzhe-kolgal, Juan aga e-chapingan-oturdajadyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tegin Jesús aga e-chapinganga chogalzhun: —Imi pe Pabzhe kolneel, pe weob Pabzhe kolmalo: An-Pab-nikpa-neggin-maidye, imi tulemal pegin chogmalalen, nabirin: ‘Pe-nugdin chwilimakalye.’ Tenal pe-neg-takmaid nonikilen, nabirbalinye. (Imi nikpa-neggin pe-itolegedbal pél immal-kunaidyob, iti-napkin pe-itolegedbal pél immal-kunaimogalen, nabirbalinye.) ");
INSERT INTO kvnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Imi pe anka pane-pane mas-kunned ukoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pabye, imi tulemal-ankin-walmajadbal an nega iskued pelgus chogzhadyob, pe anka iskued pelgus chogmogoye. Imi pe wilub-takleged-naidzhik, pe melle an-palmioye. (Tenal pe iskuedgin-yoledanikid-akar pe an-onobaloye.) Pitogua. Imi pemal weob Pabzhe kolmalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tegin Jesús aga e-chapinganga purpal chogalbal: “Imi tule mutik-neg-kabgwen peje nonikil, tenal pe mas kwen nikchulil tule-nonikid-okunkal, ¿pe ilgwen ai-nuedzhe naojulzhí mas amigal? Tegin pe aizhe kolnatapo; ‘An-ai, an peje walapá madu wis amidani, ogwagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Imi an-ai-pid tikajul-akar anche noni. Tenal antin mas-kunned kwen nikchul an-ai-okunkal. Tenal pe madu nikale, pe anka madu wis uko.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“¿Tegin pe-ai-neggin-maid pega chogo pe ebinzhe: ‘Pe melle anche kolma. Imi an-wanagak pato chaktigal chii, tegin anmal tegin an-nuskan pato pél kabmamimal. Al an kwen kwisgunejul pega madu ukegal?’ Chulá.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tegin Jesús chogalbal: “Tenal an chunchunnad pemalga chogdo: imi ai-neggin-maid pe-aiyadbal yabli kwen kwisguojul pega madu ukegal. Tenal pe-ai-neggin-maid melle pinkegugal keg-chulgu yabli unnigualedzhe pega immalmal-napi-kujiid uko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tegin Jesús chogalbal: “Al an pega chogzhundo: imi pemal Pabzhe immal ekismalal, Pab pega uko. Tenal pemal Pabzhe immal aminanimalal, pedin we immal onomalo. Tegin pemal Pabzhe pali-pali kolmalal tule-wanagakkin-kolnanikidyob, Pab pe-itogo, tule pega wanagak egenonikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Tenal meke-ibi-tule Pabzhe immal ekisnail, we tule keg-chulgu immal-ekisnaid nikunoniko. Tenal meke-ibi-tule Pabzhe immal aminail, we tule keg-chulgu immal onogo. Tenal meke-ibi-tule Pabzhe pali-pali kolnail, tule-wanagakkin-kolnaidyob, Pab keg-chulgu we tule-itogo, tule wanagak egajadyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“(¿Imi pe-machi peje madu ekisdanikil, pe machiga akwa uko? Chulá. Teginbal,) ¿pe-machi peje ua-ekisdanikil, pe machiga nakpe-uko? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Teginbal, ¿pe-machi peje kallin-nuzha ekisdanikil, pe machiga tiol-uko? Antin chog chul. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tenal pemal tule-iskanagwando, tenal pemal yabli wiis aga nuskanga immal-nuegan ukmal. Al pe anmal-Pab-nikpa-maidzhe Pab-Purpa-Nued-ekisnail, Pabdin pemalga pul-pule E-Purpa-Nued-uko.” Teob Jesús chogzhagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tegin te ibagwengin Jesús tulegin nia-keg-chunmaked-onosgu, tule nabir chunmanoni. Tegin tulemal-Jesús-takpukmalad weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tenal tulemal-wal-walgwen chogalmal: “Imi we Jesús nia-tummad-Beelzebú-kannalegedgin tulegin nia-onimai.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tenal tule-pimalad Jesús wilub-takegal Jesúsga chogalmal: “Imi pe Pab-Tummad-akar anmalga wilub oyogenab pe Pab-nuggin nia-oni o chul-dewa.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tenal Jesús wiis we tulemal igi pinzhebukmal. Tegin Jesús tulemalga chogalzhun: “Imi meke-ibi-napa abal-marral chiil, pél neg iskunoniko. Tenal meke-ibi-neg-yaginmalad, aga abal istarmalal, kwen unniguojulmal mes pulakwa ampagugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tenal nia-Satanás aga e-chapingan-onidel, aga abal istar kunonimalo. ¿Imi Satanás aga iskudmalalen, igi Satanás-neg-takmaid unniguoen? Keg kue. Tenal pemal-ankin-chognonikidbal antin Beelzebú-kannalegedgin nia-onimai, al an pemalga weob chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“¿Tenal an Beelzebú-kannalegedgin tulegin nia-oniel, tede pe-chapingan toa-kannalegedgin tulegin niamal-onimalmójun? ¿Imi pe-chapingan ampa nia-nuggin nia-onimalmojulzhí? Tenal pemal wismal pe-chapingan nia-nuggin niamal-kwen-onijulmal. Al pe-chapingan nia-oninaidgin pemalga oyos pe-ankin-chogzhad, ib-chunchunnad-chul. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Tenal an Pab-kannalegedgin niamal-oni-choggu, al wedin choglejundo, Pab-neg-takmaid pato pemalzhe noni.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tegin Jesús purpal chogalbal: “Imi tule-kal-ibed es-annik aga neg-takmail, e-immalmal tarbi kwen aturzhelegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tenal tule-neg-takmaidga pul tule-kal-ibed nonikil, tule-kal-ibed-maidgin nako. Tenal tule-nonikid tule-kal-ibed-maidgin nakwijal, tule-kal-ibed-maidgin pél immalmal idirnoniko, esgin-penzhulidzhe-pakal tule-kal-ibed-maidgin chulenoniko. Tegin tule-nonikid tule-pimaladga pél tule-kal-ibed-maid-e-immalmal mimibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tenal tule anpak naichulil, we tule anchikid-chul, tenal we tule anpak istargad. Tenal tule anka pulakwa tulemal-urpenaichulbalil, we tule pul-kigma anka tulemal-izhonai tulemal melle anpak naigugal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tegin Jesús chogalbal: “Imi nia tule-akar nojal, neg-ti-nikchulidbal pipirmadi-peio, neg-ulukued amigal. Tenal nia neg-ulukued onoszhulidbal kannan pinzhedago: ‘An pul kannan nao akpenegwad neg-nojadzhe.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“Tegin nia tule-akar-nojadzhe kannan nonibalil, taknoniko neg turwial chii, pato kuakwa meggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tenal nia takchal neg-olobi chii, kannan nao. Tegin nia aga walakugle e-pakamalad-ega-pul-nia-iskana-amio. Tegin nia aga e-pakmalad-amijal, we niamal-pel-kwapa tulegin megnoniko. Tenal tule-nia-nikad akpenegwadga pul-pule iskunoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tegin Jesús ampa chunmanaidgin, tulemal-abalgin ome-walgwen arpak sapejul kolal, chogal: —Imi we ome-pe-nikujad tegin pe-otummojadga peyedzhe-ib-nuedga kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tenal Jesús omega chogal: —Imi pe nabir chogendo, tenal tule Pab-kaka itojal tegin Pab choged-pallí naneel, we tulega pul-pule ib-nuedga kunonikodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tegin tulemal Jesúszhe pul-pule irmanonigu, Jesús tulemalgin chogal: “Imi imisgwagwad-tulemal, tule-nuegan-chul, tule-iskana. Tenal we tulemal peigujimaldo, an-immal-taktijulid-imakedbal ega oyo an Pab-akar tani. Tenal imisgwagwad-tulemalga immal-taktijulid-pid pal kwen oyolegojul-kuo. Tenal we tulemalga akpene Jonásgin-immal-kujadbalbi oyolego an toa-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Imi Jonásgin-immal-kujad Nínive-tolganga wilub oyos Nínive-tolgan Jonás-chogzhad itogenabmal. Tenal an-Te-Tule-Chunnagin-immal-kuoed ampa teopí tule-imis-pukmaladga wilub oyomogo, tule-imis-pukmalad an-chogzhad itogenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Imi Reina-tad-chapiredzhik-neg-takmai-kujaddin nap-kaka-akar noni Salomón-pirkin-immal-wijiid-wisgugal. Al we Reina Pab-tulemalga-igal-itoged-ibegin tule-imis-pukmalad-tuktinonimogo. Imisgin pe takto, antin Salomónga pul tule-tummadga kudii, tenal pemal yabli yapa ankin ibzhemal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Teginbal, Nínive-tolgan Jonás-chunmajadbal aga ulubgin iskuedgin pukib-itononimal. Al Nínive-tolgan Pab-igal-tulemalga-itoged-ibegin tule-imis-pukmalad-tuktinonimalo. Imisgin pe takto, an Jonásga pul tule-tummadga kudii, tenal pemal yabli yapa ankin ibzhemal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tegin Jesús purpal chogalbal: “Imi tule kwen nikchul kallen ogajal, otukal kallen chigal, tegin mete-yabal chigal-chulbal. Tenal tule kallen ogajal, keg-chulgu kallen-kalugin kallen chimal pel-kwapa tule-ukpomamimalad mag takegal pia immalmal pukwa. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Imi pe-imia, pe-changa kallen-neg-otalonaidyobmo. Tenal pe-imia nuedil, pe-chan pel-kwapa mag immal tak. Tenal pe-imia-iskunonikil, pe-chan aku-ata peimogo, neg-chichidgin kudiidyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Imi pemal nue aga takermal, melle pe chogdago: ‘Antin pel-kwapa Pab-igal mag ito,’ tenal pemal yabli aku Pab-igal itomal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tenal pe chunchunnad mag Pab-igal itogel, pedin pel-kwapa Pab-igal mag itogo, kallen tale neg-imajiidyob pe pel-kwapa mag immal-tak, pe-aku-immal-taked kwen nikchul.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tegin Jesús tulemalga pél chunmasgu, Pariseo-walgwen aga negzhe Jesús-ches masgin okunkal. Tegin Jesús Pariseo-negzhe tognatapku, ilgwen mesa-nabal ampagunonimal mas kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tenal Pariseo Jesús-takchagu, Jesús ampayo mas kunneddu igal-mamikidbal chunkal kwen enukchajul, weob pakal pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tegin Jesús Pariseoga chogal: “Imi pemal-Pariseomal askinbi pate tegin muruk enukmal, tenal pe yabal pate tegin muruk kwen enukchulmal. Tenal pemal askinbi aga chunkal enuknanimal, tenal pemal ulubgindin kantikidgin immal-egwanedginbi pinzhenanimal, tegin pe istar-immal-imakedginbi pinzhenanimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“¡Pe immal kwen wichulma! ¿Pe wiszhulzhí Pab Tummad askin pe-opinnis tegin ulubgin pe-opinnisbal? ");
INSERT INTO kvnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tenal pe tule-wilemaladga pategin-mas-kunned-chiid ukenabmal. Tenal pe tule-wilemaladga pategin-mas-kunned-chiid ukchal, pemal kep pél chwilimakal kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Imi pemal-Pariseomal anpi pe wilesmalma! Imi pemal immal-polléje-pakal: menta, ruda tegin immal-kagan kwaambegwad-kwagwen Pabga ukmal. Tenal pemal yabli ampa itojulmal piti igal-nued, piti igal-iskana. “Teginbal, pemal Pab-tule-pilaledyob kwen pinzhejulmal tule-pilalgugal. Tenal pemal Pab-tule-pilaledyob tule-pilalguenabmal. Tegin pe tulemalga nuekwa immal-imakedgin pe naneenabmalbal. Tenal pemal ampa kwaambegwad-kwagwen Pabga-immal-uked-igalgin pinzheenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Imi pemal-Pariseomal anpi pe wilesmalma! Imi pemal Judio-ormaked-neggin tule-tummagan-ampagumalad-kangin ampagugal pe yer itomal. Tenal tulemal immalmal-uked-neggin tule-tummaganyob peje kolalil, pe yer itomalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Imi pemal-Pariseomal, anpi pe wilesmalma! Imi tule uan-askin wichul pipirmadiidyob, pemal askin yer-taklemal, tenal pemal aga ulubgin tule-purkwijad-nungumaidyob, pe istar nanemal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tegidgin tule-Moisés-igal-wijiid-walgwen Jesúsga chogal: —Tule-oturdaked, imi pe-chogzhadyob, pe anmalgin istar chunmanaimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tegin Jesús chogalbal: “¡Imi pemal-Moisés-igal-wismalad, anpi pe wilesmalma! Imi pemal peyedzhe-tutujul tulemalga igal-mesmal, tule pel unnijulidzhe. Tenal pemal pel-iche tulemal-kwen-pentajulmal igal-mezhijadgin nanegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Imi pemal-Moisés-igal-wismalad, anpi pe wilesmalma! Imi pemal uangin Pab-kaka-palchogmalad-akpene-purkwismaladga neg-nued chobmal. Tenal pe-tadgan Pab-kaka-palchogmalad-mechamal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","“Tenal pe uangin neg-chobzhadbal pe oyonai pemal tadgan-Pab-kaka-palchogmalad-mechamalad yer itosmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Al Pab Tummad pela-pela immal-wijiidbal pemalgin chognoni: ‘Imi an we tulemalzhe an-kaka-palchogmalad tegin an-nuggin-palmilegalmalad-palmialmal. Tenal we tulemal an-nuggin-palmilegalmalad-wal-walgwen-mesmalo, tegin an-nuggin-palmilegalmalad-wal-walgwen sapejul-imanonimalbalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Al pemal-imis-pukmalad istar tule-palmilegalmalad-imakoedbal, Pab-kaka-palchogmalad-kepe-sagla-akar-opurkwismalad pel-kwapa pemalgin chii, Abel-opurkwijad-akar Zacarías-opurkwijadzhe-pakal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tenal pe-tadgan Pabzhe-koled-neg-akar Pabga-immal-uked-kwichid-abalgin Zacarías-mechamal. Tenal an chunchunnad pemalga chogdo: imi Pab-kaka-palchogmalad-mechamalad-pel-kwapa tule-imis-pukmaladgin kunoniko, sapejul oturdalegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Imi pemal-Moisés-igal-wismalad, anpi pe wilesmalma! Imi pemal tulemalgin Pab-neg-takmaid-toged-igal otusmal. Tenal pemal aga tukin kwen togzhajulmal, tenal pemal tule-Pab-neg-takmaidzhe-togbi-kunanimaladgin igal-kasmalbal melle toggal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tegin Jesús pél chunmasgu, akne nadzhun. Tenal Pariseomal tegin Moisés-igal-wismalad istar itos-pesmal. Al Pariseomal Jesúszhe kannan-kannan immal-ekisnai-kualmal, ");
INSERT INTO kvnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ade, Jesús noal-wis-chunmanonikil, Jesús-kamalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Imi teun takalgu, tule mili-milibal Jesúszhe ali-ali irmanonimalgu, Jesús aga e-chapinganga-inzhel chunmakal chogal: “Wijira, Pariseomal-e-madu-inagin. Imi wedin choglege: pinche-askinbi-nued-nanemalad-igal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Tenal immal-otukal-maid keg-chulgu wisgulenoniko, tegin immal-otukal-kujad keg-chulgu mag taklenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tenal pe neg-chichidgin immal-chogzhad, neg-ibgin kannan choglenonibalo. Tenal pe neg-yabal aga apinni arpa-arpa chunmajad, neg-uwas-pir-akar sapejul choglenonibalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Tegin Jesús chogalbal: “An-aimal, an chunchunnad pemalga chogdo: imi tule-pe-mesbi-kunanimalad pe melle tobgumalo. Tenal tulemal pe-chan-mechad-cholbal, tule keg pe-purpa-pal-akalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tenal antin pega chogdo toa-tule pe tobguenabmal. Imi pedin, pe Pab-Tummad-tobguenab. Tenal Pab Tummad igal-nikado, pe-chan purkwijad-cholbal, cho-chaglaje pe-purpa-metkal. Al an pemalga chogdo: pemal Pab-Tummad-tobguenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Imi chikwi-purwigana kwaatalgin mani-pogwal, ibiga nabir? Keg kue. Tenal we immal-tulgan pel karkejul. Tenal Pab Tummad yabli we chikwimal-kwen-igeojul-kuo. Tenal Pab Tummad chikwimalga pul-pule pemal-takodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tenal Pab Tummad pemal-chagla-ki-kigwenzhe-pakal episal cheitii. Al pe melle tule-tobgumalo, Pab Tummad chikwi-purwigana-ichejulidga pul-pule pemal-takmal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tegin Jesús chogalbal: “Imi an chunchunnad pemalga chogdo: imi meke-ibi-tule, tulemal-wagin chogzhal: ‘An Jesúsbal nai,’ an-Te-Tule-Chunna Pab-angelmal-wagin chogmogo: ‘We tule anpal nai.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tenal meke-ibi-tule, tulemal-wagin chogzhal: ‘An Jesúsbal naichul,’ antin Pab-angelmal-wagin chogmogo: ‘An we tule kwen wichul.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Imi meke-ibi-tule istar an-Te-Tule-Chunnagin chunmajal, Pab Tummad we tulega nabir iskued elio. Tenal meke-ibi-tule Pab Purpa Nuedgin istar chunmajal, Pab Tummad meke-igi we tulega iskued pal kwen eliojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Imi tulemal pe-kasmalal, Judio-ormaked-neggin-tummagan-pukmaladzhe pe-chedmalo. O chulil, igal-itomaladzhe o tummagan-pimaladzhe pe-chedmalbalo pega igal-itogal. Tenal pe melle pukib-itomalo pe igi chunmako-dewa, o pe igi chogo-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tenal tegidgin Pab-Purpa Nued pega chogo, pe igi chunmakenab.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tegin tule-pukwad-walgwen Jesúsga chogal: —Tule-oturdaked, imi pe an-iaga chogo: an-pabgad-immalmal-pejad anka abalzhal wis ukmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tegin Jesús tule-ega-chognonikidga chogal: —Chuli machi. ¿Ante pemal-saglají-ade, pega igal-nudagal, pemalga immal mimigal? ¿Toa saglaga an-nugzhas-ade? Imi an we immalmalgin kwen yolenejul. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tegin Jesús tulemalga chogalzhun: —Wijir, nue aga pe takermal. Pe melle twagdar pel-kwapa immal-peigujiidgin pinzhemalo. Imi tule keg chogel: ‘An ichejul immalmal-nikadbal pirkabal megne.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tegin Jesús tulemalga purpal chunmakalzhun: “Imi te ibagwengin tule-mani-ibed immal tigzhagu, ichejul we tulega immal chanmanoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tegin tule-mani-ibed pinzhealzhun: ‘¿An igi pul immal imakel pul nabir? An immal-chaboed-neg-tummagan kwen nikchul immalmal chabogal’ ");
INSERT INTO kvnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Tegin tule-mani-ibed chogalzhun: ‘Aaá, imi an wiis an igi imakenab. Imi an immalmal-chaboed-neg-pukwad an eyarne, tegin an neg-pul-tummagan chobne pel-kwapa an-immalmal-nikad chabogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tegin an pél immal chabojal, an pinzhenoniko: Imisgin an kus arpas. Tenal an immalmal-ichejul nika-choggu pirkabal meggal, al an wis ulukune, an mas-kunne, an kobne tegin an yer itononibalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Tegin Pab Tummad tule-mani-ibedga chognoni: ‘¡Pe immal-kwen-wichulma! Pe imis-mutik purkwene. ¿Tede pél pe immalmal-nikad, toaga peio? Pega immal kwen peiojul.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tegin Jesús chogalbal: “Imi tule Pab Tummadgin nue pinzhejulidgin ichejul immalmal chaboel, weob kunonida-take.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tegin Jesús aga e-chapinganga chogalbal: “Al an pemalga chogdo: pe melle twagdar pukib-itogo, pe igi mego-dewa, pia pe mas-kunned amio-dewa. Tegin pe melle twagdar pukib-itomalbalo, pia pe mol amio-dewa wis yogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","¿Imi tule-tula-kudiil, pul ib-nuedzhulzhí, pul mas-kunnedga? ¿Tegin tule-chan pul chunchogedbalzhulzhí, pul mol-yomaladga? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Imi pe takto, chikwi-chichimal igi nanemal. Tenal we immal-tulgan pel immal tigdijulmal, tegin keg immal weimalbal chabogal, tegin neg pel nikchulmalbal mas-kunned chabogal. Tenal Pab Tummad yabli chikwimalga mas-kunned uk. Tenal pemal chikwimalga pul tule-nued-choggu, al Pab Tummad pemalga pul-pule mas-kunned uko. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“¿Imi toa peyedzhe-pukib-itogedbal unniguo wachilgwen e-purkwed okpingal? Chulá. Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tenal pemal immal-ichegwadgin peyedzhe-pukib-itogedbal keg pel immal ima unnigugal, ¿tede ibiga pemalde pul-pule immal-pimalad-nikuedgin peyedzhe pukib pinzhemal? Pe peyedzhe pukib-pinzheed-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Imi pe takto, tud-chapurbalid a-ito chunnemal. Tenal tudmal kwen arpajulmal, tegin tudmal pel purrejulmalbal. Tenal an pemalga chogzhundo, Errey-Salomón-e-mol pul-yer taklegendo, tenal tud, Errey-Salomónga pul yer-takle. Tenal tud-chapurbalid imis tula, tegin we tud te-pangin tinkujal, chogin yok okummakal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tenal Pab Tummad yabli tudga yer tud-oturpama, molyob. “¿Tede ibiga pemal Pabgin nuekwa ibzhejulmal? ¿Pab pemalga pul-pule mol ukojulzhí yogal? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Al pemal melle mas-kunnedginbi tegin kobedginbi pinzhemalo. Tegin pe melle we igalgin peyedzhe pukib-itomalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","“Tenal tule-Pab-wichulmalad unnila pane-pane alamananimal we immalmal nikugal. Tenal Pab Tummad pemal-nued-wismal ibi pe napi kujimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Tenal pemal kepegin alamakenabmal Pab-neg-takmaidgin immal-nuegan nikugal. Tenal pemal Pab-neg-takmaidga alamasmalal, kep pe pél immal-napi-kujiid pega uklego: mas-kunned, kobed, tegin mol.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tegin Jesús chogalbal: “Tenal pemal-an-mimmigan-walpókwagwad, pe melle tobgudamalo. Tenal Pab Tummad yer-itogedbal pemalga igal-ukcha e-neg-takmaidgin ebak mes meggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Tenal pe immalmal-nikmalad manigin pe uko, tegin pe tule-wilemaladga mani mimio. Tenal pe alamakenabmal Pab-neggin mani-chabolejiid-keg-pelgued nikugal, tegin Pab-neggin immalmal-nuegan nikugalbal. Imi tule Pab-neggin kwen togojulmal immal aturzhegal, tegin chumal immalmal kwen kunnojulmalbal izhogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Imi pe-immalmal Pab-neggin pega chabolejiil, pe Pab-neggin pinzhedago. Tenal pe-immalmal iti-napkin pega chabolejiil, pe iti-napkinbi pinzhedago.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tegin Jesús chogalbal: “Imi mosmal kuakwa mol-yoyo tegin kallen-kabuk aga e-tummad-abintajiidyob, pemal kuakwa kudiguenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imi tule-tummad machi-ome-nikunaidgin mas-kuchad-cholbal, kannan negzhe tanikil, e-mosmal kuakwa kudimal. Tenal mosmal e-tummad wanagakkin-kolnonikoedgin ilgwen e-tummadga wanagak egemaloedyob, pemal kuakwa kudiguenabmalmo pe-tummad tanikoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Tenal tule-tummad negzhe-nonikil, e-mosmal kuakwa tar-abintabukmalal, we mosmalga ib-nued kunoniko. Imi an chunchunnad pemalga chogdo: we tule-tummad mosmal-mol yojal, mesa-nabal we mosmal-ochio, tegin tule-tummad mosmalga mas-weigwiszhunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Tenal an pemalga kannan chogbaldo: imi tule-tummad meke neg-kabgwen o meke neg-wakurudzhik negzhe nonikil, tenal mosmal yabli kuakwa tar-abintabukmalal, mosmalga ib-nuedga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Tenal an wisgal pemalga chogdo: imi neg-ibed wisgujalen ibi-wachigin tule-immal-aturzheed noniko, neg-ibed pali-pali neg algenaioen, melle ebi immal aturzhalegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tenal pemal-ampa-an-kwen-abintajulidgin an-Te-Tule-Chunna pemalzhe kannan noniko-choggu, al pemal kuakwa kudiguenabmalmo an-abingegal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tegin Pedro Jesúszhe ekichial: —¿Tummad, pe-imis-immal-otukal-chogzhad anmalgabi pe chogzha, o tule-pimaladga pe otukal chogzhamo? ");
INSERT INTO kvnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tegin Jesús purpal Pedroga chogal: “Nabir. ¿Imi toa-tule-jogna inniki nanemogo, mos-immal-wijiidbal e-tummad-chogzhadyob inniki-nanajadyob? Nabir. Imi neg-ibed mos-walgwen-ebes mos-pimalad-takegal, tegin e-tummad-chogzhadyob masgin mos-pimalad-okunkal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tegin neg-ibed kannan nonikil, taknoniko, mos e-chogzhad-pallí inniki immal imanai, we mos ib-nued imas, tegin we mosga ib-nuedga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Tenal an chunchunnad pemalga chogdo: imi mos-yer-nanajadbal e-tummad pél we mosga e-immalmal ebeo ega takegal. Imi an-Te-Tule-Chunna ampa tule-tummad e-mos-imajadyob pemal-imamogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Tenal mos-iskanadin pinzhedago: ‘An-tummad imiszhul noniko.’ Tegin we mos sapejul mos-pimalad, machergan tegin omeganzhe-pakal sakidago. Tegin we mos mas-kuntago tegin inna-kobdabalo mumurguedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tenal mos-iskana-e-tummad ampa abintajulidgin e-moszhe noniko. Tegin tule-tummad nonikil koa-koa mos-iskana-imanoniko. Tegin tule-tummad mos-iskanaga igal-uko tule-Pab-wichulmaladbak mes sapejul oturdalegal. “Tenal an-Te-Tule-Chunna kannan tanikil, tule-tummad e-mos-iskana-imajadyob pemal-istar-an-chapingan-imasmalad-imanonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tenal mos wijiindo e-tummad igi peigujii ega immal imagal. Tenal we mos yabli kuakwa kudijul, tegin e-tummad peigujiidyob immal kwen imaszhulbal. Imi mosmal-wegii-tamalad peyedzhe sakilenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tenal mos immal-wichulidgin immal akalojal, oturdaleged-wiluban. Tenal we mos pul nue-peyedzhe sakilegojul-kuo. “Imi tule ichejul Pab-igal wisgunonikil, Pab we tuleje peyedzhe immal ekisnoniko. Tenal tule íche Pab-igal wisgunonikil, Pab we tuleje íche immal wis ekisnonimogo. Tegin Pab tulega ichejul immal ebejal ega takegal, Pab we tuleje pul-pule immal ekisnoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tegin Jesús purpal chogalbal: “Imi an iti-napche noni cho ogegal. Tenal an ínkwagus peigujiin cho turmagwis. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tenal ankin peyedzhe ib kuenabgwel. Tenal ankin pel-kwapa immal-peyedzhe kuoedgin, an ulubgin pukib-ito. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“¿Imi pemal pinzhemal antin noni iti-napkin-pukmaladga neg-nudagal tulemal melle aga imamalgal? Chulá. Tenal an chunchunnad pemalga chogdo, an noni pis-pis tule-neg-yaginmalad-imagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Tenal imis-akar tule neg-yagin walatal pukmalal, istar aga taktamalo, walpágwad walbogwadbak imadamalo, tegin walbogwad walpágwadbak imadamalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tegin pab aga machibak iskunonimalo, tegin machi aga pabbak iskunonimogo. Tegin nan aga chiskwabak iskunonimogo, tegin chiskwa aga nanbak iskunonimogo. Tegin chak-ome aga palabak iskunonimalo, tegin pala aga chak-omebak iskunonimogo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tegin Jesús tulemalga chogalbal: “Imi pemal tad-arkwanedzhik mogil-takalil, pemal ilgwen chogdamalo: ‘Ti-wine.’ Tegin keg-chulgu ti-winonida. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tenal pe takalil, yol-purwa kolmai, pemal chogaldamal: ‘Neg-ued pela-pela tani.’ Tegin neg-ued keg-chulgu nononida. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“¡Imi pemal pinche-askinbi-nued-nanemalad! Imi pemal nued wismaldo nikpa-neg-taklegedbal neg igi kunoniko. ¿Tede pemal igi wichul-kune, neg imis igi kunaid? Pemal pato wijiid-wilubmogan.” ");
INSERT INTO kvnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tegin Jesús chogalbal: “¿Tenal pemal-wagin-immal-kunaid ibiga keg pe chogmal wedin ib-nued o chul? ");
INSERT INTO kvnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Imi tule-walgwen ebi immal-akalojadbal igal-itogedzhe pe-chedbi-kualil, pe ampa igalbal-natapidgin pe we tulebak igal-nudakenab. “Tenal pe we tulebak igal-nudaszhulil, we tule igal-itogedzhe pe-odogo, tegin tule-igal-itoged ilgwen chulubga pe-uko oturdaleged-neggin pe-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tenal pe we tulebak igal-nudaszhulil, an chunchunnad pemalga chogdo: pél pe penukchulil, pe oturdaleged-neg-akar pal kwen noojul-kuo. Imi Pab Tummad sapejul tulemal-oturdaked pato omodani-choggu, al pe Pabbak igal-nudakenabmal. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Imi teun takalgu, tule-wal-walgwen Jesúsga chognonimal Galilea-tolgan immal-tulgan-mesnaidgin Pabga ukegal, Pilato aka-tégin we tulemal-mecha. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tegin Jesús tulemal-nonimaladga chogalzhun: “¿Imi pemal ebinzhemal Galilea-tolgan-weob-purkwijadbal Galilea-tolgan-pimaladga pul tule-iskana? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tenal an chunchunnad pemalga chogdo: imi pe iskued-nikadbal pe aga ulubgin pukib kwen itononijulil, pemal pél pe pelgunonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Teginbal, tulemal-walambe-kakapábak torre-Siloégin-kwichid kin aglajadbal purkwismal. ¿Imi tulemal-purkwismalad tule-Jerusaléngin-pukmalad-pimaladga pul tule-immal-akalosmalad pe ebinzhe? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tenal an chunchunnad pemalga chogdo: imi pe iskued-nikadbal pe aga ulubgin pukib kwen itononijulil, pemal pél pe pelgunonimalmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tegin Jesús purpal wag-islubgin chunmakal chogal: “Imi tule-walgwen e-nagnugin wag-islub tigzha. Tegin wag-islub chanmaked-wilub omosgu, e-ibed taknad aga e-chan kwangal. Tenal wag-islub-ibed wag-islub-chalzhe nonigu, taknoni e-chan saté. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Tegin wag-islub-ibed tule-nagnu-takedga chogalzhun: ‘Imi antin pirkapágus wag-islub-chan amidanigus, tenal an wag-islub-chan kwen onoszhul-kus.’ Tegin wag-islub-ibed tule-nagnu-takedga chogalzhun: ‘Imi wag-islub pinche neg-kani-kwichi-choggu, al pe akalzhul olejunno.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Tegin tule-nagnu-taked wag-islub-ibedga chogalzhun: ‘Tummad, pe melle wag-islub olegweloma, pirkagwen pe napi takkwelo. Tenal antin imis-akar nagabal chika-chika nap imane tudu-chegal. Tenal an moli-cha wis eyonebal takegal, chanmako o chul-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tegin wag-islub nabir chanmanonikil, meke kwichio, melle pe olao. Tenal wag-islub chanmanonijulil, akalzhul pe olejunnodo.’ “Tegin wag-islub-e-ibed chogalzhun: ‘Tegil nabirde.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tegin te ibagwengin Jesús ulukued-ibegin Judio-ormaked-neggin Pab-igalgin tulemal-oturdadi-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Imi teun takalgu, ome-walgwen chimo. Tenal we ome nia-nikadbal pirkaambe-kakapábakkus tulludik nanedii, keg inniki kwisgu. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tegin Jesús ome-takchagu, omeje kocha eje taggal. Tegin ome Jesúszhe nonigu, Jesús omega chogal: —Mu, pe imis-akar poni-pe-kanikid-akar pe ololgune. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tegidgin Jesús omegin chunkal mezhisgu, ome apka-pakal inniki kwisgunonijun. Tegin ome Pab-Tummad-otummoalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tegin Jesús ulukued-ibegin ome-nudajadbal, Judio-ormaked-neg-e-tummad istar-itogedbal tulemalzhe ulual chogal: —¿Imi pemal wichulzhí ibe-ibanerkwa nika arpagal? Al pe we ibemalgin tagdo nudalemalgal. Tenal pe ulukued-ibegin pe melle tagmalo nugugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tegin Tummad-Jesús Judio-ormaked-neg-e-tummadga chogalzhun: —¡Pe-askinbi-nued-nanemalad-tule! ¿Imi pemal-pel-kwapa ulukued-ibegin aga moli echiktamalzhulzhí, tije tigin moli-okobnegal? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tenal we omedin Abraham-e-wagwa. Tenal Satanás pirkaambe-kakapábakkus we ponibal we ome-kasgudii. ¿Tede ib-nuedzhulzhí, ulukued-ibegin ponigin-kalesgudiid-akar ome-onogal? Ib-nueddo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tegin Jesús pél chunmasgu, tulemal-istar-Jesús-takmalad peyedzhe pinkegusmal. Tenal tulemal-pimaladdin Jesús-immal-taktijulid-imajadbal yer itos-pesmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tegin Jesús chogalbal: “¿Imi Pab-neg-takmaid ibiyob an pega chogel-kad-wichul? ");
INSERT INTO kvnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nabir. Imi Pab-neg-takmaid, tule nagnugin chapi-mostaza-kwa tigzhadyob. Imi mostaza-kwa tunkusgu, chapiun tunkus, tegin chikwimal e-aanganbal ampagunonimal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tegin Jesús kannan chogalbal: “¿Imi Pab-neg-takmaid ibiyob an pega chogel-kad-wichul? ");
INSERT INTO kvnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nabir. Imi Pab-neg-takmaid ome-walgwen madu-pur-liber-tulapágwadgin madu-ina eyojadyob. Tenal madu-ina pinna-pinna madu-pur-kadel, pel-kwapa madu omuo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Imi teun takalgu, Jesús Jerusalén-neg-kweburzhe natapidgin neg-kwebur-tummagangin tegin neg-kwebur-purwiganagin Pab-igalgin tulemal-oturdake-nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Imi teun tule-walgwen Jesúszhe ekichial: —¿Tummad, tule-walpókwajal wis abonolenonimalo melle sapejul oturdalegal? Tegin Jesús tulemalga purpal chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nabir. Imi an chunchunnad pemalga chogdo: imi tulemal-íchejul alamananimalan wanagak-alikwágwadgin toggal. Tenal tulemal keg kugusmal toggal. Al pemal pela-pela alamakenabmal wanagak-alikwágwadgin toggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Tegin tule-neg-ibed kwisgudel, ilgwen wanagak chaktio. Tenal pemal-magadbal-pesmalad wanagakkin neg-ibedzhe kolnonimalo, wilenonimalo. Tegin pemal chogdamalo. ‘Tummadye, pe anka wanagak wis egegweloye.’ Tenal tule-neg-ibed pemal-tarzhe-kolnonimaladga chogdago: ‘An wichí pe ibi-tule, pia pe tani.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Tegin pemal-magarbal-pesmalad neg-ibedga chogdabalo: ‘¿Imi an pebak mes kobzhamalzhulzhí, tegin an pebak mes mas kuchamalbalzhulzhí? ¿Tegin pe anmal-neg-impabal Pab-igalgin tulemal-oturdadi-kusbalzhulzhí?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Tegin tule-neg-ibed pemal-magarbal-pesmaladga chogdabalzhunno: ‘Pinche pe koltima. An wichí pe ibi-tule, pia pe tani. ¡Pe-tule-iskana, pe ilgwen we-akar nao!’ ");
INSERT INTO kvnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tegin pe takalil Abraham, Isaac, Jacob tegin Pab-kaka-palchogmalad-pel-kwapa Pab-neg-takmaidgin pukwamal. Tenal pemal kwen togzhajulmalal, pe pela-pela pononimalo, tegin pe peyedzhe-wilejiidbal nugal kotamalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Tenal Pab-neg-takmaidgin tulemal-akne-akne-tanimalad, tad-nakwedzhik, tad-arkwanedzhik, tegin tad-chabiridzhik-nuedzhik, tegin tad-chabiridzhik-chapilezhik-tanimalad mesagin pel-kwapa pukmalmogo mes mas-kunkal. Tenal pemaldin saté. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Imi tule-pinchemalad-wal-walgwen tule-tummadga kunonimalo, tenal tule-tummagan-wal-walgwen tule-pinchegadga kunonimalmogo.” Imi Jesús teob chogzhagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tegidgin Pariseomal-wal-walgwen Jesúsga chognonimal: —¡Pe kueye nao! Errey-Herode pe-aminai pe-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tegin Jesús Pariseomalga chogalzhun: —Imi pe us-tad-Herodega chogo: ‘An imis, pan tulemalgin nia-onine, tegin tule-yemalad-nudanebal. Takalgu achul kep an immalmal pelogo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tenal antin keg-chulgu imis, pan, tegin achul ukin neenab. Tenal Pab-kaka-palchoged-tule keg-ku akne purkwegal, keg-chulgu Jerusaléngin purkwed-wilub. Al an Jerusalénzhe omoed-wilubmo purkwegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tegin Jesús chogalbal: —Jerusalén-tolgan, pemal Pab-kaka-palchogmalad-mechamal, tegin pe akwagin tule-peje-palmilegalmalad-mechamalbal. Tenal antin melugus peigujiin pemal-pel-kwapa anche tagmal nuekwa pe-akwegal, kallin-nan aga chakan-tarbal mimmigan-chabogedyob an pemal chabogal. Tenal pemal yabli yapa-kusmal. Al an peyedzhe pukib-itodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Imi pe-negdin mellegal-peio. Tenal an pemalga chogdo: imi pemal meke-igi an-pal-kwen-takojulmal, pemal chognonimaloedzhe: Imi pe-Pab-nuggin-tanikid-tule otummoledi-kuelen, nabirinye. Pitogua. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tegin te ibagwengin ulukued-ibegin, Jesús Pariseo-tummad-negzhe nad mas kunkal. Tegin Jesús-mas-kunchiidgin, tulemal Jesús-algebukmal, Jesúsde igi immal imako-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tenal Jesús-abir tule-walgwen chimo. Tenal we tuledin abgan-mued-poni nika. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tegidgin Jesús Pariseomalzhe tegin tule-pirkin-Moisés-igal-wismaladzhe ekichial: —¿Imi ulukued-ibegin tule-nudagal ib-nued o chul? ");
INSERT INTO kvnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tenal Judio-tummagan ilgwen yakír pesmal, Jesúsga immal kwen chogzhajulmal. Al Jesús tule-abgan-mued-poni-nikad-ebusgu, ilgwen tule-yeed-nudas. Tegin Jesús tule-yeed-palmiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tegin Jesús Judio-tummaganzhe ekichialbal: —Imi pemal-walgwen machi-nikal, o moli-peb-nikad-dewa, ulukued-ibegin pebi ya-yabal arkwatchal, ¿pe apka-pakal moli-onaknaojulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tenal Judio-tummagan Jesús-kwen-abin-imaszhulmal, ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Imi teun Jesús tule-mas-kunnonimalad-takchagu tule-tummagan-kangin chigbi-kualdamal, al Jesús tulemalga purpal chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Imi machi-ome-nikuedgin tule peje wis kochamogal-dewa e-wis-taknegal, pe melle tule-tummagan-ampagumalad-kangin chigo mas kunkal. Tenal pe kwen wichul tule-pega-pul-tule-tummad arpak noniko-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Tenal pe tule-tummagan-ampagumalad-kangin chigwijal, tenal tule-pega-pul-tummad arpak nonikil, mas-kunned-e-tummad peje noniko, tegin pega chogdago: ‘Imi pe we tummad-kan-akar pe kwisguenab, tule-tummad pe-anal chiggal.’ Imi an-pega-chogzhadyob pega kuelen, pe peyedzhe pinkeguoen, tegin pe kan-pinchegadgin chignatapchunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Tenal te ibagwengin tule peje kocha-dewa mas kunkal, pe kan-pinchegadgin chigo. mas-kunned-e-ibed pega chognonikoedzhe: ‘An-ai, pe tule-tummagan-pukwadgin pe chigmogo.’ Tenal mas-kunned-e-ibed pega teob chognonikil, kep pe tulemal-pebak-mes-mas-kunpukmalad-wagin pe otummolenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Imi meke-ibi-tule aga tukin tummarba itogel, we tule, pul tule-pinchegadga kunoniko. Tenal tule aga tukin pinchegadga imakel, pul tule-tummadga kunoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tegin Jesús tule-neg-ibedga chogal: “Imi pe íchejul mas-imabi-kualil tulemal-okunkal, pe melle aga aimalzhe kolo, pe melle aga urpamalzhe kolo, pe melle aga kwenamaladzhe kolo, pe melle tule-mani-ibgan-pe-waglik-mamimaladzhe kolbalo. Tenal pe an-chogzhadyob pe tulemalzhe kochamalal, we tulemal kujal peje kolnonimalmogoen. Wedin choglejun, pemal aga muchub-muchub masgin okunnanimaladgin aga nabonanimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Tenal pe ichejul mas imabi-kualil tulemal-okunkal, pe tule-wilemaladzhe pe kolo, pe tule-ponigwalmaladzhe pe kolo, pe tule-mego-mego-nanemaladzhe pe kolo, pe tule-aku-atamaladzhe pe kolmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","“Tenal pe masgin tule-wilemalad-okuchal, pega ib-nuedga kunoniko. Tenal tule-wiledimalad muchub pe-kwen-okunnojul-choggu, al tule-chwilidik-nanedimalad-kannan-tullegoed-ibegin Pab-neggin pega immalmal-nuegan uklenoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tegin tule-walgwen-Jesúsbak-mes-mas-kunchiid Jesús-chunmajad itosgu, Jesúsga chogal: —Imi tule Pab-neg-takmaidgin mas kunpukwal, ib-nued we tulega kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tegin Jesús we tulega chogalzhun: “Nabir pe chogendo. Tenal an pemalga purpal chog, imi te ibagwengin tule-walgwen íchejul-mas-imajogalidgin ichejul tulemalzhe kocha, ebak mes mas kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tegin tule-tummad mas-kunned ogusgu, aga e-mos-palmis tule-akpene-tarzhe-kochamaladga chognegal: ‘Tagmalo, mas pato akwigus kunkal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Tegin mos tulemalga chognatapku, tulemal-pel-kwapa yapa taggusmal. Kwéntin mosga chogal: ‘An imichal naga nagnu pakcha. Al an naga nagnu takneenab. Al tule-anche-kochadgin an wis naojulidbal walmanejun.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tegin kwéntin mosga chogal: ‘An imichal naga walambe moli-pakcha. Al an naga moli-takneenab molide nued arpamal-dewa. Al tule-anche-kochadgin an naojulidbal wis walmanejun.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tegin kwéntin mosga chogalmo: ‘An imichal ome-nikkus. Al an keg neel.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tenal mos e-tummadzhe kannan akpirnonigu, pél aga e-tummadga chognonijun, tulemal ega chogzhad. Tegin tule-tummad e-mos-ega-chognonikid itosgu tulemal yapa taggusmal, sae-itos-pes. “Tegin tule-tummad e-mosga kannan chogalbal: ‘Imi pe kueye-kueye kannan neenabbal, neg-kweburgin callebal tegin neg-chukungangin tule-wiledimaladzhe kolnegal. Tegin pe tebal nadel, tule-ponigwalmaladzhe, tule-aku-atamaladzhe, tule-mego-mego-nanemaladzhe pe kolmogo anpak mes mas kunmalgal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Tegin mos e-tummad-chogzhadyob pél pipirmasgu, e-tummadga chognoni: ‘Tummad, pél pe anka chogzhadyob an imas. Imi tulemal-ichejul irmanoni, tenal tulemalga neg ampa unni.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Tegin tule-tummad e-mosga chogal: ‘Imisgin pe nebalo, tule-igalbal-mamimalad-aminegal tegin tule-chapurbal-mamimalad-amigalbal. Tegin pe kantikidgin tulemal-chedago an-neg enzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tenal an pega chogdo, imi tulemal-an-kepe-neje-kochamalad-pel-walgwen meke-igi an-neggin mas pal kwen kunnojulmal.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Imi teun tulemal-íchejul Jesúsbak irmadimal. Tegin Jesús tulemalzhik akpiridgu, tulemalga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Imi meke-ibi-tule anpal naigubiel, aga pabga, aga nanga, aga omega, aga nuskanga, aga urpamalga, tegin aga punmalga, pul an-pilalzhulil, we tule an-chapinga keg kuel. Tenal meke-ibi-tule an-pilaledbal, yapa anka purkwel, we tule an-chapinga keg kubalil. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tenal meke-ibi-tule anpal-naigujadbal kuakwa purkwegal natapchulil, tule-aga-nakrus-cheinatapidyob, we tule an-chapinga keg kubalil. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Al an pemalga purpal chognejun, imi pe neg-tummad chobbi-kualil, ¿kepegin pe nuekwa pinzheenabgwelzhulzhí pe mani unni-dewa o chul-dewa, pél neg-tummad chobgal? ");
INSERT INTO kvnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tenal pe kepegin nuekwa pinzhaszhulil, neg-tummad mani-akujadbal abal kalenai melledo. “Tenal tulemal takchal neg abal-kalenai, pegin chogdamalo: ");
INSERT INTO kvnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘We tuledin immal-kwen-wichulma. Tenal tule neg-tummad-chobnaindo tenal kwen okuszhul-kus neg-tummad pelogal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tegin an pemalga purpal chogbaldo: ¿imi errey-walgwen errey-pidbak pila-chebi-kualil, nuekwa pinzheenabzhulzhí, ede chulub-miliambe-nikadgin unnio-dewa errey mili-tulagwen chulub-nikadbak pila-chenaidgin, nakwegal? ");
INSERT INTO kvnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tenal errey unnijulil, errey-pid ampa tikajulidgin tulemal-palmio, errey-pidbak igal-nudagal melle pila-chegal. “Imi pemal ampamalmo. Al pe nuekwa pinzheenabmal pe unnio-dewa anpal-naigugal o chul. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Teginbal, pe pél immalmal-nikad pe ebejulil anpal naigugal, keg pe an-chapinga kuel. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tenal palu ib-nueddo yer-kulle mas imagal. Tenal palu iskunonikil, keg kannan pal nudale. ");
INSERT INTO kvnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tenal palu iskujal, ibga pal kwen kunonikojul, nap-nudagal pel chul, tegin turwa-nudagal pel chulbal, unnila migal nabir. Imi an-pemalga-chogzhad, pe nuekwa itomalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Imi teun tule-Romano-tummadga-tulemalgin-mani-egwanmalad tegin tule-iskana-pimalad Jesúszhe irmanonimal Jesús-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tenal Pariseomal tegin Moisés-igalgin-tulemal-oturdamalad Jesúsgin chogalmal: —We tule yer tule-iskana-abinge, tegin tule-iskanabak mes mas kunpal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tenal Jesús Pariseomal-chogzhad itosgu, Pariseomalga purpal chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Imi pemal-walgwen oveja-wala-tulaatal-nikal, tegin oveja pebi walgwen owelejal, ¿pe moli-kagan-naidgin oveja-pimalad-ebegojulzhí, walkwénna-oveja-owelejad-aminegal onogedzhe? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","¿Tegin pe oveja-owelejad onojal, pe negzhe weligwaledgin kwikangin pirnai oveja-chedagojulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","“¿Tegin pe negzhe nonikil, pe-aimalzhe tegin pe-tikalbal-mamimaladzhe pe kolojulzhi? Teobdo. Tegin pe tulemalga chogo: ‘Imi an oveja-owelejad an kannan onojadbal, pe anpak mes welgumalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Tenal an chunchunnad pemalga chogdo: imi oveja-wala-tulabake-kakaambe-kakabakepak kwen oweleszhulmaladga pul oveja-owelejad-kannan-onojadbal pe welgumalo. Imi tule-inniki-timalad aga iskuedgin pukib-itogal kwen napijulidbal, Pab-neggin tule-inniki-timaladga pul tule-aga-iskued-pukib-itononikidgin pul welgunonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tegin Jesús purpal chogalbal: “Imi ome-walgwen kwaambe mani-chipú nikal, tegin mani-chipú omebi kwagwen owelejal, ¿we ome kallen ogao, tegin neg-turwidago tegin nuekwa mani amidagojulzhí ilgwen onogedzhe? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“Tegin ome mani-owelejad onojal, aga aimalzhe kolo tegin tule-aga-tikalbal-mamimaladzhe kolmogo. Tegin ome tulemalga chogdago: ‘Imi an mani-owelejad an kannan onojadbal, pe anpak mes welgumalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Tenal an chunchunnad pemalga chogdo: imi tule-walgwen aga ulubgin iskuedgin pukib-itononikidbal, ome aga e-aimalbak welgujadyob Pab-angelmal peyedzhe welgumalmogo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tegin Jesús purpal chogalbal: “Imi te ibagwengin, tule-walgwen machimal-walabo-nika. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tegin machi-totogwad aga e-pabga chogal: ‘Paba, imi pe-purkwijad-cholbal-anka-immalmal-uklegoed pe imis-imis anka uko.’ Tegin machi-e-pab e-machimalga pél e-immalmal-nikad mimiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tegin machi-totogwad nue-nadzhul manigin pél aga e-immalmal-nikad ukcha. Tegin we machi napa-pidzhe nadzhun. Tegin machi napa-pidzhe omosgu, kalagwenzhul nanedi-kual, inna-kobdi-kual, tegin omegangin mani midi-kualbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tegin machi pél aga e-mani misgu, mani-nikchul-kunoni. Tenal machi-maid-napkin mas-kunned-kwen-nikchul kunonigu, machi ukul mejal. Al we machi peyedzhe wilegalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Tegin machi tule-aka-mamimaladzhe nadzhun arpaged wis amigal. Tegin machi arpaged onosgu, e-tummad chapur-tikalzhe machi-palmis ega chin-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tenal we machi chin-okunnaidgin pela-pela ukul-chaal. Al we machi chinbi-mas kunpi-kual. Tenal tulemal machiga yabli chin-mas kwen ukchajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Tenal machi aga mag itononigu ede pela-pela wiledii, aga chognonijun: ‘¿Ibiga an wegin wiledi-wede? An-pab-mosmal, mas-ichejul nikamal, tenal antin itigin ukul mesdani. Al an pabzhe nejun. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tenal an pabzhe kannan nadel, an pabga chognatapo: Pabye, an Pab Tummadbak iskus, tegin an pebak iskusmoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Al an igal-kwen-nikchul choggal: An pe-machiye. Tenal pedin, pe mosyob an-takoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tegin machi aga e-pabzhe alzhun. “Tenal machi ampa untar-panku tanigu, e-pab panna-akar aga e-machi-takcha. Tegidgin e-pab peyedzhe wilejakwa machi-takchagu, ilgwen machi-abin abarmakalzhun. Tegin e-pab allakwa aga machi-kas, tegin igal-maidbal machi-wagal usbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tegin machi e-pabga chogal: ‘Pabye, an Pab Tummadbak iskus, tegin an pebak iskusmoye. Al an igal-kwen-nikchul choggal: An pe-machiye.’ Tegin machi-e-pab aga e-machiga chogalzhun: ‘Machi, pe melle weob anka chogma. Pedin ampa an-machido.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tenal machi-e-pab aga e-mosmalga chogal: ‘Pe kueye-kueye mol-pul-nued aminao, tegin pe ko-yoed tegin sapat aminebalo. Tegin pe an-machigin pél pe we immalmal yoyomalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tegin pe kueye moli-peb-nikad-chapini-kwamtikid-chunao mesgalbal. Tegin anmal weligwal-itogedgin we chan kunmalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Imi an-machi tikajulgus tule-purkwijadyob oweledi-kus, tenal imidin kannan tullejadyob anmalzhe nonibal.’ Al tulemal weligwal-itogedgin mas kunonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tenal teun takalgu, e-ia-chered neggin maichul, nagnuganbal kudii. Tenal e-ia-chered negzhe tanikidgin, panna-akar itos kal kolomajii, tegin tule kwilnanimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tegin e-ia-chered mos-walgwenzhe kocha ekisgal: ‘¿Ibiga tulemalde kwilnanimal-wede?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tegin mos machi-cheredga chogal: ‘Imi pe-urpa-akpene-nadgujad kannan chana-nued akpirnonibal. Al pe-pab moli-peb-nikad-chapini-kwamtikid-mecha, pe-urpa-nonikidbal tulemal weligwal-itogedgin mas kunmalgal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tenal machi-chered e-pab-e-urpaga-immal-imajadbal sae-itos-pes. Tegin machi-chered yapa mas-kunnanimaladgin toggus. “Tenal e-pab wisgusgu e-machi-chered noni, magadbal nod e-machi-cheredga choggal: ‘¿Ibiga pe keg wis togmodeé, mas wis itogal?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tegin machi-chered e-pabga chogalzhun: ‘Imi antin pirkabalgus pebak kudii, tegin an pe-choged-pallí pél immal imadi-kus. Tenal pe anka cabra-chapini kwen ukchajul, naga aimalbak weligwal-itogedgin wis kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Imi an-urpa omegan-machergan-wismaladgin pél pe-mani misgu, kannan negzhe noni. Tenal pedin an-urpaga moli-kwamtikid-mecha kunmalgal.’ Tenal pe an-urpaga weob immal-imaked-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tegin e-pab machi-cheredga chogal: ‘Machi, pedin anpak pane-pane kudii, tegin an-immalmal-nikad pel-kwapa ampa pegadmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tenal pe-urpadin tikajulgus tule-purkwijadyob oweledi-kus, tenal imidin pe-urpa kannan tullejadyob anmalzhe nonibal. Tenal pe-urpa owelejan, tenal imidin kannan anmalzhe nonibal. Al anmal weligwal-itogedgin mas-kunned-wilubmal.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tegin Jesús purpal aga e-chapinganga chogalbal: “Imi te ibagwengin tule-mani-ibed mai. Tenal we tule-mani-ibed tule-pid-nikbal ega pél immalmal takegal. Tenal tule-mani-ibed iche-iche wisgus, e-mos-ega-immal-takedde pinche-pinche-pakal e-mani mimai. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Al tule-mani-ibed tule-ega-immal-takedzhe kocha. Tegin tule-mani-ibed tule-ega-immal-takedga chogal: ‘Imis an wisgusdo, tulemal pegin chogmal, pede nuekwa an-immalmal kwen taknaichul. Imi an pei pe-anka-immalmal-takchiid pél pe anka chogo, melu ampa immalmal wis pukwa. Tegin pe anka chogbalo tulemal melu ankin kalenanimal. Tenal pe we arpagedgindin anka pe pal kwen arpanejul.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tegin tule-immal-taked aga pinzhealzhun: ‘Imi an-tummad arpaged-akar an-metel. Tede, ¿an igi kuojun? Imi antin unnijul nagnugin arpagal, tenal an pinkebal magadbal tulemalzhe mani ekisgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aaá! Imi an wiis an igi imakenab. Imi an tummad ankin arpaged idirijal, an akalzhul tule-neggin mego.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tegin tule-immal-taked tulemal-e-tummadgin-immalmal-kalenanimaladzhe kocha. Tenal tule-immal-taked tule-kepe-nonikidga chogal: ‘¿Pe melu an-tummadgin immalmal kalenai-chogna?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tegin tule-immal-kalenaid tule-immal-takedga chogal: ‘Kwallubi, barril-tulaatal an kalenai.’ “Tegin tule-immal-taked tule-immal-kalenaidga chogal: ‘Nued, wegin pe-karta. Tegil pe kueye chigdo nermagal. Tenal pe kartagin unnila barril-tulabo-kakaambe pe nazhiko.’ Tegin tule-immal-kalenaid tummad-immal-taked-chogzhadyob imas. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Tegin tule-immal-taked tule-pidga chogalbal: ‘¿Pe melu an-tummadgin immalmal kalenai-chogna?’ Tegin tule-immal-kalenaid-pid tule-immal-takedga chogal: ‘Trigobi quintal-tulaataled-ilatal an kalenai.’ “Tegin tule-immal-taked tule-immal-kalenaidga chogal: ‘Nued, wegin pe-karta. Tegil pe kueye chigdo nermagal. Tenal pe kartagin unnila quintal-tulaataled-ilabake pe nazhiko.’ Tegin tule-immal-kalenaid tummad-immal-taked-chogzhadyob imas. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Tegin tule-mani-ibed tule-ega-immal-taked-wisgusgu, tule-immal-taked-iskanagin chogalzhun: ‘Imi tule-immal-taked pirkin pinzheed-nika melle kujal wilegal.’ Imi tule-iti-napkin-pinzhedimalad tule-Pabgin-pinzhedimaladga pul-pirkin immal wismal, e-tulemalgin immal-imagal melle kujal wilemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Tenal an pemalga chogdo: imi pemal iti-iskued-napkined-mani pe ebugo, pe-ai-nuedga tule-imagal. Al pega we mani pelgunonikil, pe neg-keg-pelguedgin abingelenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Imi meke-ibi-tule yer immal-íchegwad akwel, we tule ampa nabir immal-ichejulid akwemogo. Tenal meke-ibi-tule wichul immal-ichegwad akwel, we tule ampa istar immal-ichejulid akwemogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Imi pe iti-napkined-iskued-manigin pe nuekwa nanejulil, tede ¿toa pega immalmal-nuegan-chunchunnad uko? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Teginbal, pe tule-pid-immalmalgin pe nuekwa nanejulil, tede ¿toa pega immalmal uko pegadga kugal? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Imi tule walbo keg tummagan-nikuel. Imi pe keg-chulgu tummad-walgwen-yer-taknoniko, tenal pe tummad-pid-istar-taknoniko. Chulil, pe tummad-walgwen-choged-pallí immal imanoniko, tenal pe tummad-pid-choged-pallí immal kwen imanonikojul. Imi pemal keg Pab-walbo nanemalal. Tenal pemal walkwénna chuenabmal pe tummadga kugal, Pab Tummad o mani.” ");
INSERT INTO kvnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Imi Pariseomal pul-peyedzhe manigin pinzhedimal-choggu, al Pariseomal pél Jesús-chunmajad itosmalgu, Jesúsgin todoalmal chogalmal: “Pinche pe koltima.” ");
INSERT INTO kvnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tenal Jesús Pariseomalga chogal: —Imi pemal tulemal-wagin aga tukin oyodimal, pemal tule-nuegan. Tenal Pab Tummad ulubzhe-pakal pemal-wiis pe igi pinzhebukmal. Imi tulemal chogmalal wedin ib-nued, Pab Tummaddin istar tegiid-immal tak. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tegin Jesús chogalbal: “Imi Moisés-igal tegin Pab-kaka-palchogmalad-chogzhad Juan-Bautista-nonikidzhe chunmaledi-kus. Tenal Juan-Bautista-nonikid-akar Pab-neg-takmaid-kaka-nuegan chunmalenoni. Tenal tulemal-pel-kwapa kantikidgin alamananimal Pab-neg-takmaidgin toggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tenal iti-nap tegin nikpa-neg pul-pulejul pelguo, Moisés-igal-pul-totógwadga. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Imi meke-ibi-tule aga ome-metel, tegin ome-pid-nikujal, pato ome-pidgin-yolejadyob iskunoni. Teginbal, tule ome-melleded-nikujal, pato ome-pidgin-yolejadyob iskunonimo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tegin Jesús chogalbal: “Imi te ibagwengin tule-mani-ibed mai. Tenal tule-mani-ibed mol-nueganbi yo, mol-kwalugiid tegin mol-chibu-karked. Tegin tule-mani-ibed pane-pane mas-nueganbi kunpal. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tenal teun tule-mani-ibed-neg-magadbal, tule-wileged-Lázaro-nugad ya-chunnabi mellejimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tenal Lázaro tule-mani-ibed-mas-kunned-apatmaid kucha-tagmogan. Tenal achumal Lázaroga ya emenonidamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tegin te ibagwengin Lázaro purkwenoni, tenal angelmal Lázaro-chunonimal Abraham-maidzhe chedgal. Tegin Lázaro-purkwijad-cholbal, tule-mani-ibed purkwenonimo. Tegin tulemal tule-mani-ibed-tigzhamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Tegin tule-mani-ibed cho-chagla-neggin peyedzhe wilejiidgin, panna-akar Lázarobak-chii tad-Abraham-takcha. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tegin tule-mani-ibed Abrahamzhe kote chogal: ‘Tad-Abrahamye, imi pe wilejakwa an-takelen, nabirinye. Tenal pe anka Lázaro-palmidagelen, nabirbalinye, Lázaro ko-tukugin anka ti wis chedagalye, Lázaro an-kwabin-tukugin ti wis nazhigalye. Imi an peyedzhe we cho-chaglagin wilenaiye.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Tenal Abraham tule-mani-ibedga chogal: ‘¿Machi, ampa pe wiis, pe napkin tigusgu, pe igi kus? Imi pe napkin tigusgu, pe ichejul immalmal-nuegan nikus, tenal Lázarodin peyedzhe wiles. Imidin Lázaro itigin nued akwilejii, tenal pedin peyedzhe wilejii. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tenal anmal-abalgin ya-tummad chibal. Al tule-anchik-pukmalad meke-igi keg peje opakel. Tenal tule-pezhik-pukmalad meke-igi keg anchik opakelmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tegin tule-mani-ibed Abrahamga chogalzhun: ‘Tad-Abraham, imi antin urpamal-walatal-nika. Al an peje wileye, pe an-kalgwenmaladzhe Lázaro-wis-palmioye. ");
INSERT INTO kvnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tenal pe Lázaro palmidel, Lázaro an-urpamalga chunmagal, melle iti-wileged-negzhe nonimalgalmoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tenal Abraham tule-mani-ibedga chogalzhun: ‘Chulá. An Lázaro-kwen-palminejul. Imi pe-urpamal Pab-karta nika-nemal, Moisés-nermajad tegin Pab-kaka-palchogmalad-nermasmogad. Al pe-urpamal akalzhul Pab-karta itomalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tegin tule-mani-ibed Abrahamga chogal: ‘Nabir pe chogendo, tenal an-urpamal Pab-karta kwen itogojulmal. Tenal tule-purkwijad kannan an-urpamalzhe nadel, an-urpamal kep e-iskuedgin pukib-itononimalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Tegin Abraham tule-mani-ibedga chogalzhun: ‘Imi pe-urpamal Moisés-karta-nermakal-maidgin tegin Pab-kaka-palchogmalad-karta-nermakal-maidgin kwen ibzhaszhulmalal, tenal imi an pe-urpamalzhe tule-purkwijad-palmijal, pe-urpamaldin ampa tule-purkwijadbal kwen ibzhaojulmalbal.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tegin Jesús aga e-chapinganga chogalbal: “Imi tulega keg-chulgu wilub-takleged nonida iskuedgin arkwangal. Tenal tule-walgwen iskuedgin tule-pid-egwannonikil, we tule peyedzhe-oturdalenoniko. Tenal we tule ampi peyedzhe wilesmalma. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tenal tukalgin-akwa-mu-edinal-nai termalzhe tule-walgwen metel, wedin pul iwen-akalzhul, pul tule-walgwen iskuedgin Pabgin-ibzheed-mimmi-egwangal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Al pemal nue aga takermal, melle iskuedgin tule-pid-egwangal. Imi pe takel, pe-kwenad iskuedgin kudii, pe kwenadga chogo: ‘Pe melle iskuedgin nane.’ Tenal pe-kwenad aga iskuedgin pukib-itononikil, pe kwenadga chogo: ‘Pe-iskueddin pato pelgus.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Tenal pe-kwenad ibagwengin ilakugle pegin walmajal, tenal pe-kwenad ilakugle pega chognonikil: ‘Antin pegin-walmajadbal pukib-itononi,’ pedin ilakugle pe kwenadga chogenabmo: ‘Pe-iskueddin pato pelgus.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tegin Jesús-nuggin-palmilegalmalad Tummad-Jesúsga chogalmal: —¿Ibiga pe keg anmal-okannode, anmal pegin pul penzhulgal? ");
INSERT INTO kvnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tegin Jesús e-nuggin-palmilegalmaladga chogalzhun: —Imi pemal mostaza-kwaun ankin penzhulil, pemal chunna we morera-chapiga chogo: ‘We-akar pe nao, tegin pe termalzhe kwisgunao.’ Tenal we chapi keg-chulgu pe-choged-pallí kuenab. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tegin Jesús chogalbal: “Imi pemal-walgwen mos-nikal, tegin pe-mos oveja-takap-dewa, o nagnugin arpajad-akar nonikil-dewa, ¿pe mosga chogo pe ebinzhe: ‘Imisgin pe chigwelo mas kunkal?’ Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Tenal pe pul-kigma mosga chogdagojulzhí? ‘Pe anka mas tuenab, tegin pe mol ogwaenab. Tegin pe anka mas-kunned tegin kobed chedabalo. Tegin pe anka-pél-immal-imajad-cholbal kep pe mas-kunchunmogo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“¿Tegin mos pe-chogzhad-pallí immal imajadbal, pe mosga chogo pe ebinzhe: ‘Tog-nued pe anka immal-imajadbal?’ Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tenal pemal ampamo. Imi pemal an-chogzhad-pallí pél immal imajal, pe melle aga tukin otummogo. Tenal pemal choged-wilubmal: ‘Antin twagdar mos-nued-chul. Tenal antin pinche an-tummad-chogzhad-pallí immal imas.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tegin Jesús Jerusalén-neg-kweburzhe natapidgin Provincia-Samaria tegin Provincia-Galilea-abingujiidgin natapmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tegin Jesús neg-kwebur-totoje togdanikidgin tule-walambe-lepra-poni-nikmalad Jesús-iktual pukmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tenal tule-lepra-poni-nikmalad panna igal-pial sapejul Jesúszhe kolalmal chogalmal: —¡Jesús tule-tummadye, imi pe wilejakwa anmal-takelen, nabirinye! ");
INSERT INTO kvnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tegin Jesús tule-lepra-poni-nikmalad-takchagu, ka chogal: —Imi pemal ilgwen tule-irwal-Pabzhe-kolmaladzhe nemalo, pemal aga chan oyomalgal, pedin nugusmal. Tegin tule-lepra-poni-nikmalad Jesús-ka-chogzhadyob ilgwen tule-irwal-Pabzhe-kolmaladzhe nadmalzhun. Tenal tule-lepra-poni-nikmalad ampa igalbal-natapidgin aga takalmal e-ponidin pato pelgus. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tegidgin tule-lepra-poni-nika-nad-walgwen aga takchagu ede nugus, kolmakal-kolmakal Pab-Tummad-otummoe Jesúszhe kannan al. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tegin we tule Jesúszhe nonigu, Jesús-abir askun chimtinoni. Tenal tule-nonikid tog-nuedi Jesúsga chognoni. Tenal takalgu, tule-tog-nuedi-chognonikiddin, Samaritano-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tenal Jesús tulemalga chogal: —¿Imi tulemal-nugujadde walambejulzhí? ¿Imi tule-walabakebakkwaddé, pia nadzhun? ");
INSERT INTO kvnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tenal we tule-kwapidbi noni Pab Tummadga tog-nuedi choggal? ¡Paaa! ¿Igi taklejun? ");
INSERT INTO kvnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tegin Jesús tule-eje-nonikidga chogal: —Kwisgu, pe akalzhul nejunno. Imi pe ankin-penzhul-kujadbal, pe nugunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tegin te ibagwengin Pariseomal Jesúszhe ekisnonimal, Pab-neg-takmaid inkwa kunoniko. Tegin Jesús Pariseomalga chogal: “Imi Pab-neg-takmaid pe kwen takojul-kuo tani. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tegin tule Pab-neg-takmaidgin kwen chogojul-kuo: ‘Wegin chii,’ o ‘Wépal chii.’ Tenal Pab-neg-takmaiddin pato tule-ulubgin mai.” ");
INSERT INTO kvnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tegin Jesús aga e-chapinganga chogalzhun: “Imi ibe nonikodo, pemal takpi-kudamalo an-Te-Tule-Chunna neg-takmai, tenal pemal kwen takojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tenal tulemal pemalga chogdamalo: ‘Wegin Cristo mai.’ Tegin tule pemalga chogdamalbalo: ‘Cristo wépal mai.’ Tenal pemal melle tak-nemalo, tegin pe melle we tule-itomalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Tenal an-Te-Tule-Chunna kannan tanikil, mariped pél nikpa-neg otalogedyob an noniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tenal an-Te-Tule-Chunna kepegin peyedzhe wilegenabgwel, tegin tulemal-imis-pukmalad an-kwen-abingaojul-kuenabmalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tegin Jesús chogalbal: “Imi akpene Noé-maigu-kujadyob an-Te-Tule-Chunna iti-napche kannan tanikil, tulemalga ampa kunonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","“Imi Noé-maigu tulemal pul mas-kunnedginbi pinzhedi-kusmal, kobedgin pul pinzhedi-kusmal, ome-nikuedgin pul pinzhedi-kusmal, tegin pabgan aga nuskan-ukedgin pul pinzhedi-kusmalbal aga nikumalgal. Tenal Noé ul-tummadzhe-togzhadzhe weob kudigusdo. Tegidgin tulemal ampa immalgin-kwen-pinzhejul-pukmaladgin mu-tummad arpak neg-odononi. Al teun tulemal pel-kwapa purkwismal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Tegin Lot-maigu ampa weob kusmodo. Imi teun tulemal mas-kunnedgin pul pinzhedi-kusmal, kobedgin pul pinzhedi-kusmal, immalmal-pakedgin pul pinzhedi-kusmal, immalmal-ukedgin pul pinzhedi-kusmal, immal-tigedgin pul pinzhedi-kusmal, tegin neg-chobedgin pul pinzhedi-kusmalbal. Tenal tulemal Pab Tummadgin kwen pinzhedi-kuszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","“Tenal Lot Sodoma-akar nodgu, tulemal ampa immalgin-kwen-pinzhejul-pukmaladgin ti tar-winaidyob nikpa-neg-akar cho-azufrebak winoni. Tenal teun tulemal-pel-kwapa ilgwen we chogin purkwismal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tenal Noé-maigu tegin Lot-maigu, tulemal ampa immalgin-kwen-pinzhejul-pukmaladgin neg kujadyob an-Te-Tule-Chunna kannan tanikoedgin, tulemalga kunonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tenal an-Te-Tule-Chunna kannan tanikil, tule neg-uwas-askin pukmalal, melle neg-yabal pal togmalo immalmal weigal, ilgwen pe-kunaid-akar pe wakinenabmal. Tenal tule nagnugangin kudimalal, melle negzhe pal tagmalo immalmal weigal, ilgwen aka pe wakinenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¿Imi pemal ampa wismalzhulzhí Lot-e-ome igi kus? Imi teun Lot-e-ome kannan-akpiridedgin ilgwen purkwenoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Imi meke-ibi-tule yapa purkwejogel, yabli pelgunoniko. Tenal meke-ibi-tule akalzhul purkwejogel, we tule kannan tullenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Tenal an chunchunnad pemalga chogdo: imi an-tanikoedgin tule-walbo mutik aga kachigin kabmamikil, walgwen chulenoniko, tegin walgwen peio. ");
INSERT INTO kvnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Teginbal, ome-walbo ob-nagnanikil, walgwen chulenoniko, tegin walgwen peio. ( ");
INSERT INTO kvnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tegin machergan-walbo nagnugin arpananikil, walgwen chulenoniko, tegin walgwen peio.)” ");
INSERT INTO kvnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tegin e-chapingan Jesúsga chogalmal: —¿Tummad, imi we immal-pe-chogzhad, pia kuo-wede? Tegin Jesús aga e-chapinganga chogalzhun: —Imi immal-purkwaled pia nungumaídin, tebal mulamal keg-chulgu ampagunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tegin Jesús aga e-chapingan-oturdakalgu, chogal: “Imi pe Pabzhe kolneel, pe keg-chulgu pali-pali Pabzhe kolmalo. Tenal pe melle chogdamalo: ‘An weje-ugak an Pabzhe kol.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Al Jesús aga e-chapinganga purpal chogalzhun: “Imi te ibagwengin tule-walgwen neg-kweburgin tulega-igal-itogedga mai. Tenal we tule Pab-Tummad-kwen-tobzhul, tegin tulemalgin pel atajulbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Tegin we neg-kweburgin, ome-tarbi-machered-purkwijad chimo. Tenal we ome pane-pane tule-igal-itogedzhe chognonida: ‘Imi tule-anpak-istargadbak pe anka igal-wis-nudakoye.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tenal tule-igal-itoged kepegin omega yapa igal-itogus. “Tegin tule-igal-itoged untaradgin pinzheal: ‘Imi antin Pab-Tummad-kwen-tobzhul, tegin tulemalgin pel atajulbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tenal ome pane-pane keg-chulgu anka immal chognonida-choggu, al an we omega igal-nudanejun, ome melle anka kannan-kannan an-pudar-itogedzhe immal pal chognonigal.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tegin Jesús aga e-chapinganga chogalbal: “¿Pe itosmal, tule-igal-itoged igi chog? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nabir. Imi tule-Pab-tar-chusmalad mutik-ibgin Pabzhe kolel, ¿Pab we tule-pentakojul pe ebinzhe igal-nudagal? Pab we tule-pentakodo. ¿Tenal Pab pane-pane tulemal-yardako pe ebinzhe melle pentalegal? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tenal an pemalga chogdo: Pab Tummad ilgwen tule-chusmaladga igal-nudanoniko. “Tenal an-Te-Tule-Chunna iti-napche kannan tanikil, ¿an iti-napkin tule-ankin-penzhulmalad-onogo-día o chul?” ");
INSERT INTO kvnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Imi teun takalgu, tule-wal-walgwen chogmal ede tule-nued, tenal tule-pimalad, tule-iskana. Al Jesús tegiid-tulemalga purpal chogalzhun: ");
INSERT INTO kvnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Imi te ibagwengin tulemal-walbo Pabzhe-koled-negzhe nadmal Pabzhe kolgal. Tenal tule-walgwen Pariseo-tule, tegin kwéntin e-tulemalgin-Romano-tummadga-mani-egwaned-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Tegin Pariseo kwisgusgu, weob Pabzhe kolaldo: ‘Pab Tummadye, an tog-nuedi pega chogye. Imi antin tule-pimaladyobzhul tule-iskanaye. Tenal antin tule-immal-aturzheed-chul, tenal an tule-immal-akaloed-chul, tegin an tule-pimaladyob ome-pidgin-yoleged-chulbalye. Tenal an we tule-mani-egwanedyob tajulbalye. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tenal antin tumigwengin ilabo mas-kunchulidgin nanedabalye, tegin an-immal-nikad-ilbal, kwaambegid an kwagwen pega ukye.’ Tenal Pariseo weob Pabzhe kochagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Tenal tule-mani-egwaneddin panna kwichi-pes Pabzhe kolgal. Tenal tule-mani-egwaned pukib-itogedbal pel nikpa atadzhul, ilgwen chagla-tukkinbi pes, tegin aga twisgal okolnai-pesbal. Tegin Pabga chogal: ‘Pab Tummadye, imi an tule-iskued-nikad-choggu, al pe wilejakwa an-takelen, nabirinye.’ Tenal tule-mani-egwaned weob Pabzhe kochagusmodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Tenal an chunchunnad pemalga chogdo: imi tule-mani-egwaned Pab-wagin iskued-nikchulidgin negzhe nad. Tenal Pariseodin iskued-kwen-elileszhul negzhe nad. “Imi meke-ibi-tule aga tukin otummoel, we tuledin, tule-pinchegadga kunoniko. Tenal meke-ibi-tule aga tukin totogwadga imakel, we tuledin tule-tummadga kunoniko.” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Imi teun takalgu, tulemal Jesúszhe nuskan-cheinonimal, Jesús chunkalgin nuskan-ebujadgin choggal: “Pab Tummad pega immal-nuegan imakelen, nabirinye.” Tenal Jesús-e-chapingan takchagu nuskan-e-pabgan Jesúszhe aga nuskan-cheidanimal, Jesús-e-chapingan nuskan-e-pabganzhe ulualmal chogalmal: “Melle Jesúszhe nuskan-pal-chedamalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tenal Jesús nuskan-e-pabganzhe kote chogal: “Pe anka nuskan-chedama.” Tegin Jesús aga e-chapinganga chogal: —Pe melle nuskangin igal-kao. Meke nuskan anche tagmalo. Imi Pab-neg-takmaid we nuskanyob-kudimaladga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tenal an chunchunnad pemalga chogdo: meke-ibi-tule we nuskanyob Pab-neg-takmaid kwen abingejulil, we tuledin Pab-neg-takmaidzhe kwen togojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tegin tule-tummad-walgwen Jesúsga chogal: —Tule-oturdaked, pedin tule-nued. ¿Imi an igi imakenabzhun an ilagwen-nadgu tullegal? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tegin Jesús tule-tummadga chogal: —Nabir. ¿Ibiga pe anka chogde, antin tule-nued? Pab Tummadbi unnila tule-nued. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Imi pe nued wiszhulzhí, Pab Tummad Moisésbal igi igal-mezhis? Imi Pab chogdo: Melle ome-pidgin yolego, melle tule-mejo, melle immal aturzhao, melle pinche-pinche kakanchao. Tenal pe aga pabgin tegin pe aga nangin atagenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tegin tule-tummad Jesúsga chogal: —Imi antin toto-akar pe-chogzhadyob nanedii. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tegin Jesús tule-tummad-chogzhad itosgu, tule-tummadga chogalzhun: —Nabir pe chogendo: ‘Pe-chogzhadyob antin pel-kwapa nanedii.’ Tenal pe immal-choggwen napido. Imi pe immalmal-nikad pel-kwapa manigin uko. Tenal pe tule-wiledimaladga pe we mani mimio. Imi pe tule-wilemaladga pel-kwapa we mani ukchal, pedin Pab-neggin ichejul immalmal-nuegan nikunoniko. Tenal pe tule-wiledimaladga mani-ukchad-cholbal kep pe anche tago, ankin turdagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tenal tule-tummad peyedzhe-immalmal-nikad-yapa-ukedbal, Jesús-ega-chogzhad itosgu, peyedzhe pukib-itogedgin-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tegin Jesús ampa nuu tule-mani-ibed-takkwichidgin tulemalga chogal: —¿Peyedzhe, pe takchulzhí, tule-mani-ibed pirkin-mani-pilaledbal Pab-neg-takmaidzhe toggal? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Imi moli-camello wag-iko-imia-yabal pul-pulejul togo, pul tule-mani-ibed Pab-neg-takmaidgin toggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tenal tule-itopukmalad Jesúszhe ekichialmal: —¿Imi tule-mani-ibed Pab-negzhe toggal ib-peyedzhe-choggu, tede toa abonolegojun? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tegin Jesús tulemalga chogal: —Imi tulega immal-keg-kued, Pabgadin pél nabir immal kunonida. Al Pab unni e-neg-takmaidgin tule-odogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tegin Pedro Jesúsga chogal: —Imi anmal pel-kwapa naga neg ebesmal pebal-naigugal. ¿Tegil ibi anmalga uklenonimalmogojun? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tegin Jesús tulemalga chogal: —Imi an chunchunnad pemalga chogdo: imi meke-ibi-tule Pab-neg-takmaidga-arpagedbal immalmal ebejal, nega, ome, kalgwenmalad, pabgan, o nuskan-dewa, ");
INSERT INTO kvnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","we tule iti-napkin keg-chulgu immal-ebejadga pul-pule immalmal nikunoniko. Tegin we tule Pab-neggin ilagwen-nadgu tullenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tegin Jesús pidzhi aga e-chapingan-walambe-kakabogwadzhe kocha. Tegin Jesús aga e-chapinganga chogal: “Imi anmal Jerusalénzhe nejogalmal. Tenal Pab-kaka-palchogmalad iktual an-Te-Tule-Chunnagin-immal-kuoedgin chogzhagujad Jerusaléngin pél kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“Imi an-Te-Tule-Chunna Judiojulmaladga uklenoniko. Tenal tule-Judiojulmalad peyedzhe ankin istar todomalo, tegin ankin istar chunmamalo. Tegin Judiojulmalad ankin kwi mimalo, tegin peyedzhe an-ebiomalo, tegin an-mesmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tenal an-Te-Tule-Chunna ibapágin kannan purkwaled-akar tullenonibalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tenal Jesús-e-chapingan aku itos-pesmal, Jesús ega ibi chogzhad. Tenal Pab Tummad aku-itogal Jesús-e-chapingan-imajadbal, Jesús-e-chapingan chichikaal-pesmal, Jesúsde ibi chogzha. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tegin Jesús Jericó-neg-kwebur omodanikidgin, teun, tule-aku-ataged igalgin mani ekichi. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tenal tule-aku-ataged itosgu tulemal ichejul egin irmamami, tulemalzhe ekichial: —¿Igi negde kunai-ade? ");
INSERT INTO kvnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tegin tulemal, tule-aku-atagedga chogalmal: —Jesús-Nazaretkined natapte. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tegin tule-aku-ataged sapejul kotegu chogal: —Jesús, pe-David-wagwaye. Imi pe wilejakwa an-takelen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tenal tule-Jesús-iktual-irmamamimalad tule-aku-atagedga chogalmal: —¡Pe melle kolmama! Pe yakir-kuma. Tenal tule-aku-ataged pul-kigma kolmakal chogal: —David-wagwaye, pe wilejakwa an-takelen, nabirinye. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tegin Jesús itosgu tule eje kol, kwisgus. Tegin Jesús tulemalga chogal: —Anka pe we tule-cheda. Tegin tulemal Jesúszhe tule-aku-ataged-cheinonigu, Jesús tule-aku-atagedga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Igi pe pei ante pe-penta? Tegin tule-aku-ataged Jesúsga chogalzhun: —Tummad, antin, an pei, pe anka imia nudaye. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tegin Jesús tule-aku-atagedga chogal: —Nabir. Imisgin pe-imia nugudo. Imi pe ankin penzhul-kujadbal, pe nugunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tegidgin tule-aku-ataged ilgwen mag atanoni-peszhun. Tegin tule-nugujad Jesús-cholbal Pab-Tummad-otummoe-nadzhun. Tenal tulemal-pel-kwapa tule-mag-atajad-takchamalgu, Pab-Tummad-otummoalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tegin Jesús Jericó-neg-kweburzhe tognonigu, ilagwen igalbal irmadmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Imi teun takalgu, Jericógin tule-walgwen-Zaqueo-nugad maimo. Tenal Zaqueodin Romano-tummadga-tulemalgin-mani-egwanmalad-e-tummadga mai, tegin tule-mani-ibedga maibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Imi Zaqueo Jesús-takpi-kudiin. Tenal Zaqueo tule-matu-choggu, al Jesús nasgu, Zaqueo tulemal-Jesúsbak-ichejul-irmamaidbal Jesús-kwen-takchajul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Al Zaqueo Jesús-iktual abarmad. Tegin Zaqueo Jesús-najoedgin sicómoro-chapigin nakwis Jesús-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tenal Jesús Zaqueo-chiid inniki-kusgu, nikpa atad. Tegin Jesús Zaqueoga chogal: —Zaqueo, pe ilgwen aktema. Imis an pe-neggin keg-chulgu togenab. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tegin Zaqueo chapi-akar ilgwen aktesgu, Jesúsbak mes aga e-negzhe nadzhun. Tegin Zaqueo weligwaledgin aga e-neggin Jesús-abingaszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tenal tulemal Jesús-takchagu, Zaqueo-neggin togzha, tulemal Jesús-uachogalmal: —Imi Jesús tule-iskana-neggin togzha. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tenal Zaqueo Jesúsbak-pukwadgin kwisgusgu Tummad-Jesúsga chogal: —Tummad, an kakabo pega immal wis chogbido. Imi antin, an-immalmal-nikad an tule-wiledimaladga abal ukne. Tegin an-tulegin-immal-aturzhajad ilabakegwad-wilub an kannan nega uknebal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tegin Jesús Zaqueoga chogalzhun: —Imis-ibegin iti-neg-yaginmaladga tule-abonoleged noni. Imi pedin ampa Abraham-e-wagwaga kannan kunonibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Imi an-Te-Tule-Chunna iti-napche nonido, tule-Pabgin-nojadbal-oweles-kudimalad-amigal tegin we tulemal-abonomalgalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Imi teun takalgu, Jesús Jerusalénzhe-omodanikidbal, tulemal ebinzhenatapmal Pab-neg-takmaid ilgwen noniko. Al tulemal ampa Jesús-itobukwadgin, Jesús purpal tulemalga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Imi te ibagwengin tule-tummad mai. Tegin tule-tummad nap-pidzhe nejogalgu, erreyga nugzhalegal. Tenal we tule-tummad kannan akpirnonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Tenal tule-tummad walambe e-mosmalzhe kocha. Tegin tule-tummad mosmal-ilbal yopí ichejul-mani ebes. Tegin tule-tummad e-mosmalga chogal: ‘Imi pemal we mani-ochanmamalo an kannan tanikoedzhe.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tenal tulemal-e-neg-kweburginmalad istar we tummad-takmal. Al tule-tummad-naded-cholbal e-neg-kweburginmalad tulemal-palmis tummaganga choggal: ‘Imi anmal we tule-kwen-peichulmal anmal-erreyga kugal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tenal tule-tummad yabli erreyga nugzhales. Tegin tule-tummad kannan e-negzhe nonibal. Tegin tule-tummad e-mosmalga-mani-ebemaladzhe kocha. Tegin tule-tummad mosmal-ilbal ekichial melu ega mani-ochanmasmal-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tegin mos-kepe-inzhel-nonikid e-tummadga chognoni: ‘Tummad, pe-anka-mani-ebejad eg-ilambe an pega mani ochanmas.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Tegin errey e-mosga chogal: ‘Pe nued imas. Imi pe immal-totogwad yer akwis-choggu, al pe neg-kweburgan-kwaambe, pe tako.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tegin mos-pid e-tummadzhe nonibalgu, chognonimo: ‘Tummad, pe-anka-mani-ebejad eg-ilatal an pega mani ochanmas.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Tegin errey e-mosga chogal: ‘Pe nued imas. Imi pe immal-totogwad yer akwis-choggu, al pe neg-kweburgan-kwaatal pe takmogo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tegin mos-pid erreyga chognonimo: ‘Tummad, wegin pe mani. Imi antin muswegin-ebirmakal pe-mani chabos. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Imi pe tule-puled-choggu, al an pe-tobgual. Imis an wisdo, pe kwen arpajul, tenal pe pinche kuakwa immal aminonida. Tegin pe immal kwen tigzhulbal, tenal pe immal weinonidabal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Tegin errey e-mosga chogal: ‘¡Pe mos-iskanama! Imi pe aga tukin chunmajadbal, an chabzhul pe-imane. ¿Imi pe nued-wijiinzhulzhí, antin tule-puled? Imi an kwen arpajul, tenal an pinche kuakwa immal aminonida. Tegin an immal kwen tigzhulbal, tenal an immal weinonidabal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tede, ¿ibiga pe bancogin an-mani chaboszhuldé? Imi pe bancogin an-mani chabojalen, an kannan akpirijadgin bancogin anka mani ochanmajan.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Tegin errey tule-e-itobukmaladga chogalzhun: ‘Imi pe we tulegin an-mani chumalo, tule-ilambe-mani-ochanmajadga pe we mani ukmalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Tegin tule-itobukmalad erreyga chogalmal: ‘¿Ibigadé? Imi we tule mani-chogambe pato nika.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Tegin errey chogalbal: ‘Imi an pemalga chogdo: imi meke-ibi-tule ichejul immalmal nikal, we tulega pul-melu immal uklego. Tenal meke-ibi-tule iché immalmal nikal, we tulegin immal-ichegwad egwalenoniko, chunkal-kwabi kwichi-peio. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tenal tulemal-anpak-istarmalad yapa erreyga an-odogusmalad, pe anka chedamalo, pemal an-wagin tar-mesmalgal.’ ” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tegin Jesús pél chunmasgu, tulemal-iktual nad Jerusalénzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tegin Jesús neg-kweburgan-Betfagé tegin Betania-omodanikidgin, Olivo-yal-inik peinoni. Tegin Jesús aga walbo e-chapingan-palmijogal neg-kweburzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tegin Jesús aga e-chapinganga chogal: —Imi pe we neg-kwebur-toto-pe-takchiidzhe, pe nemalo. Tenal pe neg-kweburzhe tognatapil, pe taknatapmalo moli-burro-chapini edinal-un. Imi we moli-chapini tule ampa kwen nakwedijul. Tenal pe moli-burro-echikchal, pe anka chedamalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tenal tule peje ekichialil: ‘¿Ibiga pe moli-burro-echiknai-wede?’ Pe we tulega chogo: ‘Tummadde choge ede we moli-pei.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tegin Jesús-e-chapingan-palmilesmalad Jesús-ka-chogzhad-yopí kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Teun Jesús-e-chapingan moli-echiknaidgin tule-moli-ibgan Jesús-e-chapinganzhe ekichialmal: —¿Ibiga pe moli-echiknanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tegin Jesús-e-chapingan tule-moli-ibganga chogalmal: —Imi Tummad chog, ede we moli-pei. Tenal tule-moli-ibgan Jesús-e-chapinganga chogalmal: —Tegil pe cheddo. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tegin e-chapingan Jesúszhe moli-cheinonimalgu, moli-yankalgin aga e-molmal okismal. Tegin e-chapingan moligin Jesús-onakwismalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tegin Jesús moli-askin-chii natapidgin, tulemal errey-tummadyob Jesús-takedbal Jesús-iktual igalgin aga e-molmal okismal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tegin Jesús-Olivo-yal-odejogalidgin Jesús-e-chapingan-pel-kwapa ichejul-immal-taktijulmalad-takchamaladbal, weligwaledgin sapejul pulal Pab-Tummad-otummoalmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","¡Imi we errey-Pab-nuggin-tanikid, ib-nued erreyga kuelen, nabirinye! ¡Imi Pab-neggin akalzhul-pukmalalen, nabirbalinye! ¡Tegin we errey nikpa-neggin nug okannoledi-kuelen, nabirbalinye! ");
INSERT INTO kvnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tegin Pariseomal-wal-walgwen-itobukmalad Jesúsga chogalmal: —Tule-oturdaked, pe-chapinganga pe chogma: ‘Melle weob kolmamal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tegin Jesús Pariseomalga chogal: —Chulá. Imi an-chapingan yakir-pejalen, we akwamal kolmamaloen Pab-otummogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tegin Jesús Jerusalén-omodanikidgin, panna Jerusalén takcha. Tegin Jesús tulemal-Jerusaléngin-pukmaladga peyedzhe poalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tenal Jesús chogal: “Imi pemal yabli imis-ibegin wisguelen pe igi imakenabmal akalzhul ampagugal, pemal akalzhul ampagumaloen. Tenal imidin Pab aku-itogal pemal-imas-choggu, al pemal wisguszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Tenal pemalga kujal ibe-puled noniko. Tenal te ibegin tulemal-pebak-aichulmalad pel-kwapa pe-neg-kwebur ebirmalo. Tegin tulemal-pebak-aichulmalad pe-neg-kwebur ebirismalal, yalyob pel-kwapa ebiris nap omurmamalbalo, pe melle nomalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tenal tule-pebak-aichulmalad napkin-ebiogal pe-mesmalo, tegin nuskan-pukmalad ugakche-pakal. “Imi Pab pemalzhe-noni pemal-abonogal. Tenal pemaldin Pab-pemalga-immal-imabied akus takchamal. Al tule-pebak-aichulmalad pel-kwapa pebi neg eyarmalo, akwa-askin chii pel peiojul, ilgwen ubibi peio.” ");
INSERT INTO kvnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tegin Jesús Pabzhe-koled-neg-impabal togzhagu, tulemal-immalmal-ukpukmalad-onis. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tegin Jesús tule-immalmal-ukpukmaladga chogal: —Imi Pab Tummad kartagin chogdo: Imi an-neg unnila anche-kolgalbi, tenal pemaldin immalmal-aturzheed-negga anche-koled-neg imanonimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tegin Jesús pane-pane Pabzhe-koled-neggin Pab-igalgin tulemal-oturdadi-kus. Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad tegin Judio-tummagan-pimalad igal-aminanimalan Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tenal tulemal yer Jesús-itosmaladbal Jesúsbak kudigusmal. Al Judio-tummagan kwen unniguszhulmal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tegin te ibagwengin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad tegin Judio-chelegan-tummagan Jesúszhe nonimal. Tenal teun Jesús Pabzhe-koled-neg-impabal tulemal-oturdadii tegin Pab-kakapurwa-nuegan palchogdibal. Tegin Judio-tummagan Jesúszhe ekichialmal: ");
INSERT INTO kvnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Imi pe toa-nuggin weob immal ima-wede? ¿Tegin toa pega igal-ukpal-wede, weob immal imagal? Imi an peido, pe anka chog. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tegin Jesús Judio-tummaganga chogal: —Tegil an pemalzhe-inzhel immal ekisnegwel. Imisgin an pei pe anka choggwel. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Imi Juan-Bautista-tigin-tulemal-ogdi-kujad pia-akar tani-jogna? ¿Pab-akar o tule-akar? Anka chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tegin Judio-tummagan aga emal-emal chunmakalmal: “Imi anmal chogzhal: ‘Juan-Bautista-tigin-tulemal-oged Pab-akar tani,’ we Jesúsde anmalga chogdago: ‘¿Tede, ibiga pemalde Juangin keg ibzhemalzhun?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tenal anmal chogzhabalil: ‘Juan-Bautista-tigin-tulemal-oged tule-akar tani,’ tulemal-pel-kwapa Juan-Pab-kaka-palchoged-takedbal, akwagin anmal-mesmalo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Al Judio-tummagan Jesúsga chogalmalzhun: —Anmal kwen wichulmal Juan-Bautista-tigin-tule-oged pia-tani. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tegin Jesús Judio-tummaganga chogal: —Tegil an pemalga kwen chogojulmodo, toa anka igal-ukcha weob immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tegin Jesús tulemalga purpal chogal: “Imi tule-walgwen nagnugin uva tigzha. Tegin tule-nagnu-ibed nejogalgu, tulemalga uva-naid ololchas, kujal uva-weied-omojal aga abal kamalgal. Tegin tule-nagnu-ibed napa-pidzhe nad pirkabal owegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Tenal uva-nabgued-ibe omosgu, tule-nagnu-ibed tule-nagnu-takchimaladzhe aga e-mos-palmial, uva-chan-abal-ega-uklegoed amigal. Tegin mos tule-nagnu-takchimaladzhe nonigu, tule-nagnu-takchimalad sapejul mos-nonikid-sakismal, tegin chunkal-kwabi kannan e-tummadzhe mos-palmismalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Tegin tule-nagnu-ibed e-mos-pid-palmialbal tule-nagnu-takchimaladzhe. Tenal mos-pid-nonigu tule-nagnu-takchimalad sapejul mos-sakismalbal, tegin mosgin istar chunmasmalbal. Tegin tule-nagnu-takchimalad chunkal-kwabi kannan e-tummadzhe mos-palmismalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tegin tule-nagnu-ibed e-mos-pid-palmialbal. Tegin mos nonigu, tule-nagnu-takchimalad mos-naklichasmal. Tegin tule-nagnu-takchimalad nagnu-akar kantikidgin mos-onodmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tegin tule-nagnu-ibed chogalzhun: ‘¿An igi imakenabzhun? Tegil an naga machi-pilaled-palminejun. Imi an chogdé we tulemal an-machigindin atamalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Tenal tule-nagnu-takchimalad takchamalgu nagnu-ibed-e-machi tani, aga emal-emal chunmakalmal chogalmal: ‘Imi we machi-tanikid e-pab purkwijal, we nagnu machigadga kunoniko. Al anmal we machi-mejenabmal, we nagnu pél anmalgadga kunonigal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tenal tule-nagnu-takchimalad machi-kasmalgu, nagnu-tikalzhe machi-chesmal. Tegin tule-nagnu-takchimalad nagnu-tikalbal kep machi-mechamalzhun.” Tegin Jesús chogalbal: “¿Imi tule-nagnu-ibed tule-ebi-machi-mechadbal, igi tule-nagnu-takchimalad-imako pe ebinzhe? ");
INSERT INTO kvnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nabir. Imi tule-nagnu-ibed tule-nagnu-takchimaladzhe nonikil, tule-nagnu-takchimalad-mesmogo, tegin tule-pimaladga nagnu-uko ega takegal.” Tegin tulemal-Jesús-itobukmalad chogalmal: —Imi pe-chogzhadyob Pab Tummad anmalgin kad weob immal imada. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tenal Jesús nuu tulemal-taktegu, tulemalga chogal: —¿Tede ibiga Pab-kartagin-nermakal-maid chogzhun: Imi tule-neg-chobmalad akwa-mete? Tenal akwa-meted akwa-pul-chunchogedga kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Imi meke-ibi-tule we akwa-askin arkwajal, ilgwen e-kalmal pisli-pisli peio. Tenal we akwa tule-askin arkwannonikil, we tule ilgwen akpudo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tenal Moisés-igalgin-tulemal-oturdamalad tegin tule-irwal-Pabzhe-kolmalad-e-tummagan mag itosmal, Jesús purpal emalgin otukal chunmas. Al Judio-tummagan igal-aminani-pesmal ilgwen Jesús-kagal. Tenal Judio-tummagan tulemal-tobedbal Jesús-kwen-kaszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tegin Judio-tummagan Jesús-algenanimal, Jesúsde iche istar wis chunmadago-dewa. Tegin Judio-tummagan tule-nueganyob tulemal-palmialmal, yami Jesúszhe immal ekisgal. Imi tule-palmilesmalad pinzhebukmal: “Imi Jesús iche wis noal chunmakelen, nabirin, anmal nabir gobernadorga Jesús-uko, gobernador igal-nikadbal sapejul Jesús-oturdagal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tegin tulemal-nonimalad Jesúszhe immal ekichialmalzhun chogalmal: —Tule-oturdaked, imi anmal nued wismaldo, pe tulemal-oturdanaidgin pe napírra inniki chunma. Tegin anmal wismalbaldo, pe tule-kwen-tobzhul, tenal pe ilgwen pakal-pud-pud Pab-igalgin tulemal-oturdabal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Imi pe inniki-immal-choged-tule-choggu, al an peido, pe anka chog: ¿imi anmal nabir Romano-Tummad-Césarga mani-egwannanimalad penuko o chul? ");
INSERT INTO kvnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tegin Jesús takchagu tulemal pinche e-wilub-takegal eje immal ekisnanimal, Jesús we tulemalga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Nabir. Imi pe anka mani wis oyogweldo. Tegin tulemal Jesúszhe mani oyosgu, Jesús tulemalga chogal: —¿We manigin, toa-wagal-purpa chii-jogna? ¿Tegin toa-nug nermakal naibal-chogna? ");
INSERT INTO kvnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tegin tulemal Jesúsga chogalmal: —Romano-Tummad-Césargadde. Tegin Jesús tulemalga chogalzhun: —Nabir. Imi immal Romano-Tummad-Césargadil, Césarga pe ukodo. Tenal immal Pab Tummadgadil, Pabga pe ukodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tenal tulemal-palmilenonimalad kwen unniguszhulmal, tulemal-wagin noal-chunmagal Jesús-imagal. Tenal tulemal-palmilenonimalad Jesús-emalga-immal-chogzhadbal pul-kigma weob pakal pesmal, al ilgwen yakir pesmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tegin Saduceomal-wal-walgwen Jesúszhe immal ekisnonimal. Imi Saduceomal chogmal: “Tule purkwijal, Pab-neggin pal kwen tullegojul.” ");
INSERT INTO kvnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tegin Saduceo-nonimalad Jesúsga chogalmal: “Tule-oturdaked, imi Moisés anmalga igal-mezhisdo: imi tule-ome-nikad nuchu-nikchul purkwijal, e-urpa keg-chulgu e-ia-omega-kujad-nikuenabmo, we omebak aga e-ia-purkwijadga nuchu-nikugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Nabir. Imi te ibagwengin tule-walgwen machimal-walakugle-nikus. Tegin machi-tummad ome-nikunoni. Tenal machi-tummad nuchu-kwen-nikchul purkwenoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tegin e-urpa-e-palid we ome-nikunonimo. Tenal e-urpa nuchu-kwen-nikchul purkwenonimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tegin e-urpa-e-palid we ome-nikunonimo. Tenal machi nuchu-kwen-nikchul purkwenonimo. Tenal we machimal-walakugled pél we ome-walkwénnagwad-nikusmal. Tenal machimal yabli tegigus nuchu-kwen-nikuszhul purkwismal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tegin we ome kep purkwenonimojun. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Imi we ome Pab-neggin kannan tullejal, ome machimal-walakugle-pél-nikujadbal, ¿piti machi-walakugled e-machered-chunchunnadga kunoniko?” ");
INSERT INTO kvnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tegin Jesús Saduceomalga chogal: “Imi pemal immal-kwen-wichul chunmajima. Imi tule iti-napkin ome-nikumal, tegin omegan machered-nikumalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tenal tule purkwaled-akar kannan tullejal, tegin Pab-neggin nabir togzhamalal, machergan ome-pal-kwen-nikuojulmal. Tegin omegandemo machered-pal-kwen-nikuojulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tegin tule-kannan-tullesmalad pal kwen purkojulmal. Tenal tule-tullesmalad angelmalyob kunonimalo, tegin tule kannan tullejadbal Pab-nuskanga kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“¿Imi anmal igi wisguo tule kannan tullego? Nabir. Imi Moisés chapi-purwi-kagwis takchadgin, teun Moisés chogzhagusdo: ‘Pab Tummadde Abraham, Isaac tegin Jacob-e-Pab-Tummadga mai.’ Al Moisés oyosdo tule-purkwaled-akar kannan tullego. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Imi Pab tule-purkwaled-e-Pab-Tummad chul. Tenal Pab Tummad tule-tulad-e-Pab-Tummadga mai. Tenal Pab pel-kwapa tuladbi tulemal-tak.” ");
INSERT INTO kvnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tegidgin Moisés-igalgin-tulemal-oturdamalad-wal-walgwen Jesúsga chogalmal: —Tule-oturdaked, pe yer chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tenal Jesús pirkin-immal-wijiidbal, tulemal Jesús-tobgualmal. Al tulemal Jesúszhe immal pal ekichiszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tegin Jesús tulemalga chogal: —¿Ibiga chogmaldé: ‘Cristo-Pab-akpene-chogzhad-palmidagoed-tulede Errey-David-e-wagwa?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Imi Errey-David aga tukin Pab-namaked-kartagin chogzhado: Imi Pab Tummad an-Tummadga chogzhado: ‘Pedin an-nuedzhik tule-tummadga chigwitapo, ");
INSERT INTO kvnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tule-pebak-aichulmaladgin nakwegal an pe-imakedzhe, pe kangin nag-onakwedyob.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tegin Jesús chogalbal: —Imi Errey-David-pel Cristoje kocha ‘Tummad,’ ¿tede Cristode, igi David-e-wagwaga kuodé? Tenal tulemal Jesús-kwen-abin-imaszhulmal, ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tegin tulemal-pel-kwapa Jesús-itobukwadgin, Jesús aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“¡Wijirmal Moisés-igalgin-tulemal-oturdamaladzhe! Imi we tulemal yer itomal mood mol yogal. Tenal we tulemal yer itomalbal, tule-immalmal-ukmaladgin tule-tummadyob eje kolgal. Tegin Moisés-igalgin-tulemal-oturdamalad yer itomalbal Judio-ormaked-neggin tule-tummagan-ampagumalad-kanmalgin chiggal. Tenal we tulemal pulal mas kunnalmalal, yer itomalbal tule-tummagan-kan-ampagumaladgin chiggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Tenal Moisés-igalgin-tulemal-oturdamalad kantikidgin omegan-tarbi-machered-purkwismaladgin immalmal egwanmal. Tenal we tulemal pinche yami yer e-takegal, ib-chunnadyob orojul Pab Tummadzhe kolmalbal. Imi an-chogzhadyob tulemal nanemalal pul-pule Pabzhe oturdalenoniko.” Teob Jesús chogzhagusdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tegin Jesús chiidgin, panna tule-mani-ibgan-takchii, ulugin Pabga mani uknanimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tegin Jesús takchabal ome-wileged-machered-tarbi-purkwijad-walgwen ulugin Pabga mani-kollogana-kwabo ukchamo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tenal Jesús tulemalga chogal: —Imi an chunchunnad pemalga chogdo: imi we ome-wileged-machered-tarbi-purkwijad pel-kwapa tule-mani-ibganga pul-pule Pabga mani ukcha. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","¿Ibiga an teob chog? Nabir. Imi tule-mani-ibgan ichejul mani ukchando, tenal we tulemal yabli aga manigwen-ukchadyob itosmal. Tenal we ome iché mani ukchando, tenal we ome-wilegeddin Pabga aga pelallé mani-napid ukcha, mas kunkal pel peszhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Imi Jesús-e-chapingan-wal-walgwen aga emal-emal Pabzhe-koled-neggin chunmakalmal, chogalmal: “Imi we Pabzhe-koled-neg yér takle-á tegin akwamal yér taklebal-á. Tegin tulemal-Pabzhe-koled-negga-immal-ukchamalad yér taklebaldo.” Tegin Jesús aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Imi pe-immal-takchimalad ibagwengin pelgunoniko. Tenal te ibegin we neg eyarismalal, akwa-aga-askin chiji pel peiojul. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tegin e-chapingan Jesúszhe ekichialmal: —¿Tule-oturdaked, imi pe-imis-chogzhadde, inkwa kuo-wede? ¿Tede igidgin anmalga oyolenoniko we neg-kunaid-wilubgan pato noni? ");
INSERT INTO kvnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tegin Jesús aga e-chapinganga chogal: “Tenal pe nue aga takermal, tulemal pe-yardadamal. Imi tulemal-ichejul yami an-nuggin nonimalo. Tenal we tulemal chognonimalo: ‘Imi antin Cristo.’ Tegin tule-pe-yardadanimalad pemalga chognonimalbalo. ‘Imi neg-tuku pato omodani.’ Tenal pemal melle we tulebal naigumalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Tenal pe itoalmalal, pila-nonai, tegin pe itoalmalbalil, tulemal aga emal-emal mesnanimal, melle pe kwakidamalo. Tenal an-pega-chogzhadyob neg-kunaid keg-chulgu iktualeba kunoniko. Tenal an-chogzhadyob neg-kunonikil, ampa neg-tukujul.” ");
INSERT INTO kvnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tegin Jesús chogalbal: “Imi tulemal kaka-akal-akal-chunmamaladbak pila-onononimalo, tegin napa, napa-pidbak pila-onononimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tegin neg-tutumaked peyedzhe naigunoniko, tegin napa-pid-pidgin mas-kunned nikchul-kunonibalo. Tegin ponigan peyedzhe akninoniko. Tenal nikpa-neg-magadbal wilubgan akal-akal oyolenonikil, tule-takmaloedbal peyedzhe kin kwakidamalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tenal an chogzhadyob ampayo immalmal-kueddu, tulemal pe-kanonimalo. Tegin tulemal sapejul pe-imanonimalbalo. Tegin tulemal Judio-ormaked-negmalzhe pe-cheinonimalo pega igal-itogal. Tegin tulemal oturdaleged-neggin pe-odomalbalo. Tenal pe anpal-naidbal, tulemal erreymalga tegin gobernadormalga pe-tuktinonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Tenal tule-tummagan pega igal-itononimalal, pemalga igal-uklenoniko ankin chunmagal, antin tule-abonoged. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Imi pe kalejal, pe aga tukin chogenabmal: ‘An iktualeba kwen pinzhenejul an igi chunmako-dewa.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tenal antin, an pega pinzheed-nued uknoniko pe chunmagal. Tenal pe chunmakoedgin, tule-pebak-aichulmalad unniguojulmal pegin nakwegal, ilgwen yakir peimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Tenal pe-pabgan, pe-urpamal, pe-kwenamalad, pe-aimal-ugakche pe-tuktimalo. Tenal tulemal wal-walgwen pemal-mesmalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tenal pe-anpal-naidbal, tulemal-pel-kwapa istar pe-taknonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tenal pe-chagla-kia-kigwen meke-igi pegin kwen owelegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tenal pe abin-purtijadbal pe-purpa abonolenoniko Pabbak meggal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tegin Jesús chogalbal: “Imi pe takalil chulubmal Jerusalén-ebiris pukwamal, pemal pato wisgunonimalodo, Jerusalén-pelgued omodani. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tenal te ibegin tulemal-Provincia-Judeagin-pukmalad ilgwen-wakinenabmal yal-tummaganzhe. Tenal tule-Jerusaléngin-pukmalad Jerusalén-akar noenabmalmo. Tenal tule-nagnuganbal-kudimalad Jerusalénzhe melle pal tognonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Tenal te ibegin Pab-kartagin-nermakal-maidyob pél neg-kunoniko peyedzhe tulemal-oturdalegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Imi Pab-peyedzhe-tulemal-oturdaked-ibegin omegan-ponigwal-kwichimalad tegin omegan-kin-nuskan-nunanimaladdin ib-kuoedbal peyedzhe wilenonimalo. Tenal te ibegin iti-napkin peyedzhe wileged noniko, tegin Pab Tummad peyedzhe tulemalzhe urwenonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Imi tulemal-wal-walgwen esgin-eyural purkwenonimalo, tegin kwéntin kalesmalal, akne-akne napa-pidzhe palmilemalo. Tenal tule-Judiojulmalad Jerusaléngin-maidgin chabzhul-immal-imanonikidbal neg-izhononimalo, Pab Tummad Judiojulmaladga wilub-nazhijadzhe.” ");
INSERT INTO kvnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tegin Jesús chogalbal: “Imi te ibegin an-Te-Tule-Chunna-kannan-tanikid omodanikil, tadgwagin, nigin, tegin iskwagin wilubgan oyolenoniko. Tenal tule-akal-akal-chunmamalad iti-napkin termal pela-pela arwed kolomamaidbal, peyedzhe kwakidamalo. Tegin tulemal chuli-pinzhe itononimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tenal neg-nikpa-kanalejiid pela-pela tutumanoniko. Tenal tulemal iti-napkin neg-kuneedgin, peyedzhe kwagyenonimalbalo. Tegin tulemal neg-owedmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Imi te ibegin tulemal taknonimalo, an-Te-Tule-Chunna mogil-impabal pela-pela kannalegedgin tegin pela-pela nugu-taklegedgin aktedani. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Imi an-pega-chogzhiidyob pe neg takalil, pe kuakwa kudigumalo. Imi Pab-pe-abonogoed-wilubgandin pato omodani.” ");
INSERT INTO kvnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tegin Jesús tulemalga purpal chogalbal: “Imi pe takto, wilubgan wag-islub-chapigin tegin chapi-pimaladgin. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Imi pe takalil chapimal ka-nial, pemal pato wismaldo, neg yol omodani. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tenal chapimalgin-kunai-yopí, an-imis-pega-chogzhadyob pe neg takalil, pe wisgunonimalmogo, Pab-neg-takmaiddin pato omodanimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Imi an chunchunnad pemalga chogdo: imi te ibegin-tule-pukmalad ampayo purkwemaladdu, an-pega-chogzhadyob keg-chulgu kued-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Imi nikpa-neg tegin iti-nap pelgunoniko, tenal an-immal-chogzhad keg-chulgu kued-wilub, an-kakapurwa kwen perienguojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Tenal pe wijirmal, pe nue aga takermal. Tenal pe melle twagdar mas-kunnedgin pinzhao, tegin pe melle mumurguedgin nanao. Tegin pe melle iti-napkin twagdar immalmal-nikuedgin pukib-itononikidbal, pe pinzheed-kalenonimalbalo. Tenal pe twagdar we immalmalgin pinzhediil, an-pega-chogzhadyob te ibe arpak pega kunoniko. Al pe we immalmalgin kalenoniko, immal-tulgan-arpakaal kalegedyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Imi an-pega-chogzhadyob neg-kunonikil, pel-kwapa tule-iti-napkin-pukmaladga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Imi pemal keg-chulgu pe pane-pane kuakwa kudigued-wilubmal, tegin pe Pabzhe kolenabmalbal, we neg-kudanikid melle peje nonigal, tegin pe Pabzhe kolenabmalbal an-Te-Tule-Chunna-assapin pe chwilimakal kwisgutapmalgalbal.” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tegin Jesús pane-pane ibgin Pabzhe-koled-neggin Pab-igalgin tulemal-oturdadi-kus. Tenal Jesús chedo nadda Olivo-yalzhe kabnegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tegin tulemal-pel-kwapa wakur Pabzhe-koled-negzhe irmanonidamal, Jesús-tulemal-oturdanaid itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Imi teun takalgu, Madu-Ina-Nikchulid-Itoged pato omodani, tenal we itoged pimalbal Pab-Najad-Itoged. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tenal teun tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad igal-aminanimal Jesús-mesgal. Tenal Judio-tummagan tulemal-tobedbal kwen unniguszhulmal Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tegin nia-Satanás Jesús-e-chapingan-walambe-kakabogwad-walgwengin tognoni. Tenal we tuledin nug Judas-Iscariote. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tegidgin Judas tule-irwal-Pabzhe-kolmalad-e-tummaganzhe tegin Pabzhe-koled-negginmalad-chulub-tummaganzhe nad, Judio-tummaganbak igal-nudagal Jesús-ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tenal Judio-tummagan yer Judas-itosmal. Tegin Judio-tummagan aga emal-emal igal-nudasmal Judasga mani ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tenal Judas weob-melgu-ega-mani-uklegoed yer itosmo. Tegin Judas igal-aminaigualzhun tulemal-pukchulidgin Judio-tummaganga Jesús-ukegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tegin Madu-Ina-Nikchulid-Itoged-ibe noni. Imi teun te ibegin kusgu igal-maidbal Pab-Najad-Itoged wisgugal oveja-chapini-mesmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Al Jesús Pedro-tegin-Juan-palmijogalidgin Pedromalga chogal: —Imi pe neg-kweburzhe nemalo. Tegin pe tebal anmalga neg nudamalo, anmal Pab-Najad-Itogedgin mas kunmalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tegin Pedro Juanbak Jesúszhe ekichialmal: —¿Pia pe pei, anmal pega neg nudamalgal Pab-Najad-Itogedgin mas kunmalgal? ");
INSERT INTO kvnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tegin Jesús Pedroga tegin Juanga chogalzhun: —Nabir. Imi pemal Jerusalén-neg-kweburzhe tognatapil, pe tule-walgwen-taknatapo, metegin ti cheimai. Tenal pe we tule-cholbal nemalo. Tegin tule-ti-cheimaid neg-togoedzhe, pe togmalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tenal pe tule-neg-ibedga chogo: ‘Imi tule-oturdaked chog: ¿Pia negde chii, an naga chapinganbak Pab-Najad-Itogedgin mas kunkal?’ ");
INSERT INTO kvnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tegin tule-neg-ibed pega nikpa neg-tummad oyogo. Tenal we neggin pél immalmal nika. Tegin pemal we neggin anmalga mas-kunned tumalo itoged itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tegin Jesús-e-chapingan-walbogid nadmalgu, Jesús-chogzhad-yopí ka kunoni. Tenal Jesús-e-chapingan we neggin Pab-Najad-Itogedga pél immalmal nudasmalzhun. Tegin Jesús kep aga e-chapingan-pimaladbak irmanonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tegin mas-kunned-wachigin nonigu, Jesús aga e-chapinganbak mesa-nabal ampagunonimal mas kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tegin Jesús aga e-chapinganga chogal: —Imi an ampayo purkweddu, an inkwagus we Pab-Najad-Itogedgin pemalbak mes mas kunpi-kudiin. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Imi an chunchunnad pemalga chogdo: an pemalbak we mas pal kwen kunnojul, Pab-neg-takmaidgin immal-purpal-chogle-maid sanal kunonikoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tegin Jesús kobed chusgu, Pab Tummadga tog-nuedi chogzha. Tegin Jesús aga e-chapinganga chogal: —We kobed-chiid pe chu, tegin pemal-ilbal we kobed kobmalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tenal an chunchunnad pemalga chogdo: imi an imis-akar uva-nis pal kwen kobojul-kuo, Pab-neg-takmaid nonikoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tegin Jesús madu chusbalgu, Pab Tummadga tog-nuedi chogzhabal. Tegin Jesús purwi-purwi madu pipichisgu, aga e-chapinganga ukcha. Tegin Jesús aga e-chapinganga chogalbal: —Imi we madu an-chan pemal-anal purkwegal ukles. Al pe we madu kunmalo, an purkwijadgin pe pinzhedi-kumalgal. Tegin Jesús-e-chapingan madu kuchamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tegin Jesús madu-imajadyob, mas-kuchad-cholbal, Jesús kobed chusbal. Tegin Jesús chogalbal: —Imi we kobed an-abe. Tenal an-abe oyonai Pab-Tummad-kaka-pin-ukchad ib-chunchunnad. Al an-abe pemalga milenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tenal tule-ankin-akpinnonikoed ampa anpak mes mesa-nabal chimo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Imi Pab Tummad akpene chogzhadyob an-Te-Tule-Chunnagin kunoniko. Tenal tule-ankin-akpinnonikoed oturdalegoedbal ampi peyedzhe wilesma. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tegin Jesús-e-chapingan aga emal-emal ekichialmal, chogalmal: —¿Toa anmal-abalgin Jesúsgin akpinnoniko-ade? Tenal e-chapingan ilgwen yakir pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Imi teun takalgu, Jesús-e-chapingan aga imakalmal, emal-abalgin toa pul tule-tummadga kudii. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tegin Jesús aga e-chapinganga chogal: “Imi erreymal-iti-napkinmalad tummarba-itogedgin sapejul tulemal-imanonida. Tenal tule-tummagan aga chogaldamal, ede tulemal-pentaked-tule. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tenal pemal melle iti-napkined-tummaganyob nanemalo. Tenal pemal-tummagan pul chapinganyob naneed-wilubmal. Tegin pemal-neg-takmamimalad pul mosyob naneed-wilubmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Imi toa pul tule-tummad, tule-mesa-nabal-chiid o tule-mesagin-immal-urped? ¿Tule-mesa-nabal-chiidzhulzhí? Teobdo. “Tenal an pemal-tummadga kudiindo, tenal an pemalga yabli mosyob immal ima. Tenal pemal anyob naneed-wilubmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Imi an-wilenaidgin, pemal ampa anpak mes wiledi-kusmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tenal an pemal-odomogo neg-takegal, Pab Tummad neg-takegal an-odojadyobmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Al an-neg-takoedgin, pemal ampa anpak mes mas kunno, tegin pe anpak mes kobmalmogo. Tenal pe tule-tummagan-kan-kwaambe-kakabogwad-pukwadgin pe chigwitapmalmogo, Israel-tulemal-chogambe-kakabogwadga igal-itogal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tegin Jesús chogalbal: —Simónye, imi nia-Satanás Pab Tummadzhe pe-ekichis, tule aros-ominaidyob pe wilub takegal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tenal antin pega Pabzhe koldi-kus, pe melle ankin pengunonigal. Tenal pe ankin-iskujad-cholbal pe kannan anpal naigunonikil, pe kwenamalad-okannogo pul nuekwa anpal naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tegin Simón-Pedro Jesúsga chogal: —Tummad, pinche pe koltima. Imi antin kuakwa kudii pebak oturdaleged-neggin mes oturdalegal. Tegin an kuakwa kudibal pebak mes purkwegalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tegin Jesús Simón-Pedroga chogalbal: —Chulá. Pedro, imi an chunchunnad pega chogdo: imis ampayo kallin-mastad namakeddu, pe ilapá ankin chogo: ‘Antin we tule-kwen-wichul.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tegin Jesús aga e-chapinganzhe ekichial: —Imi an akpene pemal-palmisgu, an immal-kwen-nikchul pemal-palmis. Imi teun pemal mani pel chedzhulmal, tegin muchila pel chedzhulmal, tegin pe kutar-ogwaed pel chedzhulmalbal. ¿Imi teun pemalga immalmal-akus o chul? Tegin e-chapingan Jesúsga chogalmal: —Chulá. Anmalga immal kwen napi-kuszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tegin Jesús aga e-chapinganga chogal: —Imi an akpene pemal-palmijadyob pemalga ib pal kwen kunejulmal. Imidin pe immalmal chedenabmalzhun. Imi pe mani nikal, pe mani chedenab. Tegin pe muchila nikal, pe muchila chedenabbal. Tenal pe es-pilacheed nikchulil, manigin aga pe-chuba uko, tegin pe we manigin aga pe es-pilacheed pako. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","¿Ibiga an teob pemalga chog? Nabir. Imi Pab-kartagin nermakal maido: Ankin choglego, antin tule-iskana. Is. 53:12 Tegin Pab-kartagin-nermakal-maidyob keg-chulgu ankin kuoed-wilub, tenal ankin pato kunai. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tegin e-chapingan Jesúsga chogalmal: —Tummad, pe tak, wegin es-pilacheed-kabo mai. Tegin Jesús aga e-chapinganga chogalzhun: —Ogus pe chunmamalma, nemal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tenal Jesús kusgu Olivo-yalzhe nadda-choggu, al Jesús Olivo-yalzhe nadzhun. Tenal Jesús-e-chapingan Jesús-cholbal irmadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tegin Jesús neg-natapidzhe omosmalgu, aga e-chapinganga chogal: —Imi pemal Pabzhe kolenabmal, melle wilub-takleged pemalzhe nonimalgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tegin Jesús aga e-chapingan-akar tule-unni-akwa-miedun-panku wis nad. Tegin Jesús yokorgin-chimtial chigwisgu Pabzhe kolal, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Pabye, imi ina-kakpidyob an-wilegoedgin nabir-noo pe an-takel, pe an-onogoye. Tenal an-itolegedbal-chul, tenal pe-itolegedbalye.” ( ");
INSERT INTO kvnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tegidgin Pab-angel-walgwen nikpa-akar Jesúszhe noni Jesús-okannogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tegin Jesús aga ulubgin peyedzhe pukib-itogedbal neg-owebi-kualedgin pul kantik Pab Tummadzhe kote. Tegin Jesús-e-wigmaked abeyob napkin tedemas.) ");
INSERT INTO kvnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tegin Jesús Pab Tummadzhe pél kochagu, kannan aga e-chapingan-pukwadzhe albal. Tenal Jesús aga e-chapingan pukwadzhe nonigu, e-chapingan-taknoni peyedzhe pukib-itogedbal kabmamimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tegin Jesús aga e-chapinganga chogal: “¿Ibiga pemal kabmamimal-wedé? Pe atamalma, Pab Tummadzhe kolgal, imis-immal-kuoedgin pe melle wilub-taklegal, tegin pe melle an-midmalgalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tegin Jesús ampa aga e-chapinganga chunma-kwichidgin tulemal-ichejul irmanonimal. Tenal Jesús-e-chapingan-walambe-kakabogwad-walgwen-Judas-nugad, tulemal-iktudani. Tegin Judas Jesús-abir kwisgunoni, tenal igal-mamikidbal Jesús-wagal-us. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tegin Jesús Judaszhe ekichial: —¿Judas, imi pe an-wagal-ujadgin pe an-Te-Tule-Chunna-uknaiyé? ");
INSERT INTO kvnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tegin Jesús-e-chapingan takchamalgu immal-akalgujogal, Jesúsga chogalmal: —¿Tummad, anmal es-pilacheedgin we tulemal itimimalmogo o chul? ");
INSERT INTO kvnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tenal Jesús ampayo e-chapinganga chogeddu: “Melle tule-chiko,” Jesús-e-chapin-walgwen es-pilacheedgin tummad-e-mos-chiktegu, chuchu-nuedzhikpi kaletap-idirrí. Tenal tule-chuchu-chiklejad tule-irwal-Pabzhe-kolmalad-pul-tummad-e-mos. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tegin Jesús chogal: —¡Melle tule-pal-chikoma! Tegin Jesús tule-chuchu-idirijad kannan nazhisgu, ilgwen tule-chuchu-idirijad-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tegin Jesús tule-irwal-Pabzhe-kolmalad-e-tummaganga tegin Pabzhe-koled-neggin-chulub-tummaganga tegin Judio-chelegan-tummagan-Jesús-kanonimaladga chogal: —¿Ibiga pemal es-pilacheed-annik tegin chowal-oro-annik an-kadanimal-wede, an-kantikidgin-immal-aturzheed-tuleyob? ");
INSERT INTO kvnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Imi antin pemalbak pane-pane Pabzhe-koled-neggin kudigus. Tenal pemal an-kwen-kabijulmal. Tenal imidin niaga-igal-uklejadbal, al pemalga ibe-noni an-kagal. Tegin chulubmal Jesús-kasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tegin chulubmal Jesús-kasmalgu, tule-irwal-Pabzhe-kolmalad-pul-tummad-e-negzhe Jesús-chesmalzhun. Tenal Pedro untar-panku Jesús-cholbal pinna-pinna nadmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tegin Pabzhe-koled-neg-takmalad neg-impagin cho ogasmalgu, cho-ebiral ampagusmal chowagal. Tegin Pedro tule-pukwad-abalgin chignonimo chowagalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tegin puna-mos-walgwen cho-kaedbal chii Pedro-takchagu, nuu Pedro-takal. Tegin puna tule-pukmaladga chogal: —¿We tule Jesúsbak-kudimogad-taklebalí? ");
INSERT INTO kvnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tegin Pedro punaga chogal: —Puna, an we tule-kwen-wichul. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tegin apka te-cholbal, tule-pid Pedro-takchagu, Pedroga chogalmo: —¿Pe tule-kalejad-e-pakadmo-taklebalí? Tegin Pedro we tulega chogal: —Chuli an-ai, antin we tule-pakad-chuli. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tegin apka te-cholbal wachi-ilgwengin, tule-pid tule-chowa-pukmaladga Pedrogin chogalmo: —Imi an chunchunnad pemalga chogdo: we tule, tule-kalejadbak kudimogan. We tule ampa Galilea-tolmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tegin Pedro tule-egin-chogzhadga chogal: —Chuli machi, an wichí pe ibigin chunmanai. Tegidgin Pedro ampa chunmanaidgin, kallin-mastad namanoni. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tegin Tummad-Jesús Pedrozhik akpiridgu, nuu Pedro-takte. Tegin Pedro kep wisgunoni, Jesús akpene ega igi chogzhagujad. Imi teun Jesús Pedroga chogzhado: “Imi ampayo kallin-mastad namakeddu, pe ilapá ankin chognoniko: ‘An Jesús-kwen-wichul.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Al Pedro ilgwen magadbal nodgu, pukib-itogedbal peyedzhe pononi. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tegin chulubmal-Jesús-takpukmalad istar Jesúsgin todoalmal. Tegin chulubmal sapejul Jesús-sakialmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tenal chulubmal Jesús-imia-etismalgu, Jesús-sakismal. Tegin chulubmal Jesúszhe ekichialmal: —Imi pe-immal-wijiidbal pe anka ilgwen chogo toa pe-sakis. Tenal Jesús immal kwen chogzhajul-kus, ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tegin chulubmal akal-akal Jesúsgin istar chunmakalmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tegin neg-oiposgu, Judio-tummagan ormanonimal, tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad. Tegin chulubmal Judio-tummagan-ormabukmaladzhe Jesús-cheinonimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tegin Judio-tummagan Jesúszhe ekichialmal: —Imi pe Pab-akpene-chogzhad-palmidagoed-tulel, pe anmalga nuekwa chogo: ‘Antin Cristo.’ Tegin Jesús Judio-tummaganga chogal: —Imi an pemalga chogzhal ‘Antin a-tule,’ pemal yabli anpal kwen ibzhaojulmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tenal an pemalzhe immal ekichial, pemal anka immal kwen chogojulmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tenal an imis-akar an-Te-Tule-Chunna Pab-Tummad-pela-pela-kannaleged-nikad-nuedzhik tule-tummadga chigwitapo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tegin Judio-tummagan Jesúszhe ekichialmal: —¿Tegil pe Pab-Tummad-e-Machidé? Tegin Jesús Judio-tummaganga chogal: —Nabir pe chogzhado, antin a-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tegin Judio-tummagan chogalmalzhun: —¿Pe itojímal igi chog? ¿Imi anmal ibiga tule-e-takchamaladzhe immal pal ekiso? We tule aga tukin chogzha, ede Pab-Machi. Al anmal keg-chulgu we tule-mejenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tegidgin Judio-tummagan-ormabukmalad-pel-kwapa aknidmalgu, ilgwen Pilatoje Jesús-chesmalzhun Jesúsga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tegin Judio-tummagan Pilatoje omosgu, Pilatoga Jesús-tuktialmal, chogalmal: —Imi anmal takalmaldo, we tule anmal-tulemal-pinzheed kadii Romano-abin-kwisgugal. Tenal we tule chogdo, anmalde melle Romano-Tummad-Césarga mani-egwannanimalad pal penuko. Tegin we tule chogbal, ede Cristo-Pab-akpene-chogzhad-palmidagoed-tule. Tegin we tule chogbal, ede Judio-erreyga maibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tegin Pilato Jesúszhe ekichial: —¿Chunnají pe Judio-erreyzhí? Tegin Jesús Pilatoga chogalzhun: —Imi pe nabir chogzhado. Antin a-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tegin Pilato tule-irwal-Pabzhe-kolmalad-e-tummaganga tegin tulemalga chogalzhun: —Imi an takto, we tule immal kwen akaloszhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tenal Judio-tummagan kannan-kannan Pilatoga chognaigual: —Tenal we tule pel-kwapa Provincia-Judeagin tulemal-oturdadiidbal, tulemal-oulusmal Romano-tummagan-abin-kwisgugal. Imi we tule kepegin Provincia-Galileagin tulemal-oulusmal, tegin itije-pakal tulemal-ournonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tegin Pilato itosgu Jesúsde kepegin Provincia-Galileagin kudigus, Judio-tummaganzhe ekichial: —¿Imi we Jesúsde Galilea-tolzhí? Tegin Judio-tummagan Pilatoga chogalmal: —Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tenal Pilato itosgu Jesús Herode-neg-takmaidgin-tani, Herodeje Jesús-palmiszhun. Imi teun takalgu, Herode Jerusaléngin maimo. Al Pilato Herodeje Jesús-palmiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tenal teun Herode Jesús-takchagu eje tani, weligwal itononi. Imi Herode itodi-kus Jesús immal-taktijulmalad imadii. Al Herode imial Jesús-takpi-kudii, Jesús e-wagin immal-taktijulid imagalmo. Al Herode tikajulgus Jesús-takpi-kudiin. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tenal Herode peyedzhe Jesúszhe immal ekisnaigual. Tenal Jesús ilgwen yakir pes, Herodega immal kwen chogzhajul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Moisés-igalgin-tulemal-oturdamalad kannan-kannan pul pela-pela Jesús-tuktigalmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tenal Herode aga e-chulubmalbak istar Jesúsgin todoalmal, tegin Jesúsgin istar chunmakalmalbal. Tegin chulubmal Jesúsgin mol-yér-takleged yosmal. Tegin Herode kannan Pilatoje Jesús-palmisbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Imi teun Herode kusgu Pilatobak aga aichulmalan. Tenal Herode Jesúsga-igal-itojad-akar Pilatobak aga ai-nuedga imanonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tegin Pilato tule-irwal-Pabzhe-kolmalad-e-tummaganzhe tegin Judio-tummagan-pimaladzhe tegin tulemal-yogasalmaladzhe pel-kwapa kocha. Tegin Pilato tulemalga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Imi pemal anche we tule-cheinonimal. Tegin pemal chogmal, we tulede tulemal-pinzheed kadii Romano-tummagangin ourwegal. Tenal antin we tuleje pél immal ekichis, ibi akalos-ade. Tenal antin we tulegin-immal-akalodiid kwen onoszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Imi Herode anmalzhe kannan Jesús-palmialidbal, al anmal wismal, Herode Jesús-immal-akalodiid kwen onoszhulmo. Al pemal mag itogenabmal we tule kwen purkwed-wilubzhul. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tenal antin we tule-wis-oturdane tegin an kannan ne-ononebal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tenal Pab-Najad-Itoged-naidbal, Pilato keg-chulgu igal-maidbal tule-walgwen-onoed-wilub. Al Pilato Jesús-onobi-kual. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tenal tulemal pulakwa kotemal chogalmal: —¡We tule pe mejo! ¡Barrabásdin pe onogo! ");
INSERT INTO kvnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Imi we Barrabás Jerusaléngin Romano-tulemalbak urwedi-kujadbal tegin tulemal-mechadbal, oturdaleged-neggin mellejii.) ");
INSERT INTO kvnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tenal Pilato Jesús-onobi-kunaidbal tulemalga kannan chogalbal: —¿An Jesús-ononeé? ");
INSERT INTO kvnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tenal tulemal kannan-kannan pulakwa kolnanimal chognanimal: —¡We Jesús nakrusgin pe tar-pioko! ");
INSERT INTO kvnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tegin Pilato ilapágus tulemalga chogedgin, chogal: —¿Ibiga an nakrusgin Jesús-pioko-ade? ¿Ibi akalos-ade purkwegal? Imi an Jesúsgin immal-akalojad kwen onoszhul purkwegal. Al an Jesús-wis-oturdane, tegin an kannan ne-ononebal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tenal tulemal sapejul kotemal chogalmal: —Imi pedin keg-chulgu nakrusgin-nai Jesús-mejenab. Tegin tulemal yabli Pilatogin nakwismal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tegin Pilato chogalzhun Judiomal akalzhul nakrusgin-nai Jesús-mesmalzhunno. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Imi Barrabás Jerusalén-neg-kweburgin Romano-tummaganbak urwedi-kus tegin tulemal-mechabal. Tenal tulemal-Pilatoje-ekichijadbal, Pilato yabli Barrabás-onos. Tenal Pilato Judio-tummaganga Jesús-ukchajun, Judio-tummagan aga itolegedbal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tegin chulubmal nakrusgin piokkal Jesús-cheinatapmaladgin, Simón-Cirenegined-kasmal Jesúsga nakrus chedgal. Imi we Simóndin a-ito Jerusalénzhe tanikin. Tenal chulubmal kantikidgin Simóngin nakrus mezhismal, Jesús-cholbal nakrus chedgal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tenal tulemal-íchejul Jesús-cholbal irmadanimalmo. Imi teun omegan pukib-itogedbal Jesúsga nakpodanimalmo, kwen okormadanimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tegidgin Jesús omeganzhik akpiridgu, omeganga chogal: “Omegan-Jerusalénginmalad, pe melle anka pomalma. Pemal aga tukin pomalma, tegin pe aga nuskanga. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Imi pemalga kujal neg-puled-noniko. Tenal pemalga neg-puled-nonikil, nuskan-peyedzhe-wilenoniko. Al pemal chogdamalo: ‘Imi omegan-kusgu-wichul-nuchu-pakmaladga, ib-nuedga kus. Tegin omegan-ampayo-nuskan-nikumaladga, ib-nuedga kusmo. Tegin omegan-nugin-nuchu-okuchajulmaladga, ib-nuedga kusmo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tegin te ibe-nonikoedgin, tulemal peyedzhe-wilenaidbal yal-tummaganga chogdamalo: ‘Imi pe ankin pel-kwapa yaswelen, nabirin,’ Tegin tulemal yal-mulluganaga chogdamalbalo: ‘Imi pe an-chaktigelen, nabirbalin.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Imi tule chapi-wal-makidgin sapejul immal imanail, tegin chapi-wal kujal tinkunonikil, ¿we tulemal pul sapejul immal imamalojulzhi? Teobdo.” Teob Jesús chogzhagus. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Imi teun chulubmal Jesúsbak walbo tule-iskana-cheimamimalmo nakrusgin piokkalmo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tegin chulubmal Tule-Nono-Kal-Yal-neg-nugadzhe Jesús-cheinonimalgu, we yalgin nakrusgin Jesús-piokchamalzhun. Tegin chulubmal nakrus-pidgin tule-iskana-piokchamalmo, kwén Jesús-nuedzhik, kwéntin Jesús-chapilezhik. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tegidgin Jesús chogal: —Pabye, we tulemal-sapejul-an-imananimaladga pe chogo: ‘Pe-iskueddin pelgusye.’ Imi we tulemal immal kwen wichulmal, ibi ankin imananimalye. Tegin chulubmal Jesús-molgin todoalmal, toa pul-melu aga mol chumalo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tenal tulemal pel-kwapa Jesús-takpukmal. Tenal Judio-tummagan istar Jesúsgin chunmakalmal chogalmal: —Imi we tule, tule-pimalad-abonos. Tenal we tule chunchunnad Pab-Tummad-akpene-chogzhad-palmidagoed-Cristol, tegin Pab we tule-chusbalil, nakrusgin-naid-akar aga tukin abonodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tegin chulubmal Jesús-waglik kwisgunonimalgu, Jesúsgin todoalmal. Tegin chulubmal Jesúsga vino-kakpid uknain, tenal Jesús yabli kwen kobzhajul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tegin chulubmal Jesúsga chogalmal: —Imi pe chunchunnad Judiomal-e-erreyel, pe aga tukin nakrusgin-naid-akar pe-abonodo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tegin Jesús-nakrus-tukugin karta (kaka-chogapá nermakal nai, Griego-kakagin, Romano-kakagin tegin Judio-kakagin nermakal-naimo). Tenal karta-nermakal-naid chognaido: ");
INSERT INTO kvnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tegin tule-immal-aturzhemalad-walgwen Jesús-yalbal-nakrusgin-naid istar Jesúsgin chunmakalmo. Tegin we tule Jesúsga chogal: —Imi pe Pab-akpene-chogzhad-palmidagoed-tule chunchunnadil, pe aga tukin nakrusgin-naid-akar pe-abonodo. Tegin pe anmal-abonomogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tenal tule-immal-aturzhemalad-piddin aga e-pakadga chogal: —¿Ibiga pe weob we tulega chogdé? Imi pe we tule-yopí pe purkwenemo. Tede, ¿ampa pe Pab-Tummad-kwen-tobzhul? ");
INSERT INTO kvnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Imi anmal-walbogid immal-akalojadbal nabir oturdalenai. Tenal we tule immal kwen akaloszhul. Al we tule weob oturdaleged-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tegin tule-immal-aturzheed-e-pakad-abin-imajad Jesúsga chogal: —Jesúsye, imi pe neg-takoed omojal, pe ankin wis pinzhemogoye. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tegin Jesús tule-immal-aturzheedga chogal: —Tegil pe imis Pab-neg-nuedgin anpak mes megwitapmogo. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tegin yorokudanikid-akar wachilapáje neg-pel-kwapa chichidbi naigus. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Imi teun tadgwa mommó kanai-pes. Tegin Pabzhe-koled-neggin mol-naid apallala islis. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tegin Jesús sapejul kotegu, chogal: —Pabye, an pega purpa ukye, pe an-takegalye. Tegin Jesús weob chogzhagu, ilgwen purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tenal chulub-tummad pél immal-kujad takchagu, Pab-Tummad-otummoal chogal: —¿We tule chunchunnad immal-kwen-akaloszhulid-taklebalí? ");
INSERT INTO kvnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tegin tule-pel-kwapa-aka-tégin-takpukmalad immal-kujad takchamalgu, pukib-itogedbal aga negzhe twisgal-ebionani nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tegin tulemal-pel-kwapa mag-Jesús-takmalad, tegin omegan-Galilea-akar-Jesúsbak-nonimalad-ugakche, panna Jesúsgin-pél-immal-kunaid takpukmal-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Imi teun tule-walgwen-José-nugad maimo. Tenal we tule neg-kwebur-Arimateagined. Tenal we neg-kweburdin Provincia-Judeagin chii. Tenal Josédin Judio-tummagan-wala-tulapá-kakaambegwad-walgwen. Tenal José tule-nued, tegin tule-innikigwad. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Tenal akpene Judio-tummagan ormasmalgu Jesús-mesgal, we José tummaganbal kwen naiguszhul. Tenal José Pab-neg-takmaid abintadimogan. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tegin José Pilatoje nad Jesús-mui-ekisgal tiggal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tegin Pilato Joséga igal-ukchagu, José nakrus-akar Jesús-mui odeszhun. Tegin José kep mol-chibugin Jesús-mui ebirmas. Tegin José akwapir-chobaled-yabal Jesús-mui-odos. Tenal we akwapir-chobaled-ya ampa-tule-kwen-tigledijulid. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Imi teun itogedga-immal-nudaked-ibe nai, tegin ulukued-ibe pato omodanibal. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tenal omegan-Galilea-akar-Jesúsbak-nonimalad José-cholbal pinna-pinna nadmal, takegal Joséde pia Jesús-mui-tigo-dewa. Tegin omegan nuekwa takchagu pia José Jesús-mui tigzha, kannan negzhe nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tegin omegan iktualeba kuakwa ina-ti-wawad amismal, tegin ina-wawad-kwamakaled imasbal, ulukued-ibe-cholbal Jesús-muigin imagal. Tegin omegan ulukued-ibegin wis ulukusmal, Pab Tummad Moisésbal igal-mezhijadyob. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tegin omegan tumigin polego uanzhe ti-wawad-amismalad-chesmal Jesús-muigin imagal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tenal omegan uanzhe omosmalgu, pato taknatapmal, akwa-tummad-uan-ya-chaktijiid oniral-chii. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tegin omegan uan-yabal togzhamalgu, Tummad-Jesús-mui kwen onoszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tegin omegan ampa Jesús-mui-onoszhulidgin pinzhebukwadgin, tule-walbo omegan-abin arpak nononimal. Tenal tule-walbogid mol-pi-pi-pip-kaed yowimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tegin omegan pela-pela kwakijadbal ilgwen tullu chigwismal. Tegin tule-walbogid omeganga chogalmal: —¿Ibiga pemal tule-purkwalmamimalad-abalgin tule-tulad-aminanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Imi Jesús itigin pato maichul, pato kannan tullesbal. ¿Imi pemal ampa wismalzhulzhí, Jesús pemalbak ampa Galileagin kudigusgu, pemalga igi chogzhagus? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Imi teun Jesús pemalga chogzhado: ‘Imi an-Te-Tule-Chunna tule-iskanaga keg-chulgu uklegenab, tegin an nakrusgin pioklegenab, tegin an ibapágin kannan tullegenabbal.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tegin omegan kep wisgud-nadmal, Jesús akpene emalga igi chogzhagujad. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tegin omegan uan-akar kannan negzhe nonimalgu, Jesús-chapingan-walambe-kakagwenchakkadga tegin tule-aka-pukmaladga pél palchogzhamal uangin emalga igi immal kujad. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tenal omegan-Jesús-nuggin-palmilegalmaladga-chognonimalad: María Magdalena, Juana, Santiago-e-nan-María, tegin omegan-pimalad. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tenal Jesús-nuggin-palmilegalmalad omegan-ega-chognonikidbal kwen ibzhaszhulmal. Tenal Jesús-e-chapingan chogalmal: “We omegan pinche chunmamalma.” ");
INSERT INTO kvnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tegin Pedro kwisgudgu, yok ilgwen uanzhe abarmad. Tegin Pedro uan-yabal tognonigu, tullu imas. Tenal Pedro Jesús-mui-kwen-onoszhul-kus, mol-Jesús-ebirmajadbi unnila pukwa. Tegin Pedro kannan algu, pinzhe-nad Jesús-muide igi kus-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Imi ampa te ibegin, tulemal-walbo-omegan-itosmalad neg-kwebur-Emaúszhe nadmal. Tenal we neg-kwebur Jerusalén-akar wachilbo-naneed-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tegin tule-walbogid Emaús-igalbal natapidgin, Jesúsgin-pél-immal-kujadgin chunmake-natapmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tenal tule-walbogid ampa Jesúsgin-immal-kujadgin aga chunmanatapidgin, Jesús tule-walbogid-palgatap. Tegin Jesús tule-walbogidbak mes nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tenal tule-walbogid Jesúsgin imia akismal, wichulmal wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tegin Jesús tule-walbogidzhe ekichial: —¿Ibigin pe chunmanatapmal-wede? Tegidgin tule-walbogid kwisgusmalgu, e-wagal pukib-takle-pes. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tenal tule-walbogid-natapid-walgwen-Cleofas-nugad Jesúsga chogal: —¿Imi pebi Jerusaléngin kwen kudijulinzhí? ¿Al pe wichulyé Jerusaléngin immal igi kujad? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tegin Jesús tule-walbogidga chogal: —¿Igi kus-ade? Tegin tule-walbogid Jesúsga chogalmal: “Imi Jesús-Nazaretkinedga weob immal kusdo. Imi we tule, Pab-kaka-palchoged. Tegin we Jesús Pab-wagin tegin tulemal-wagin pela-pela-kannalegedgin chunmadi-kus. Tegin Jesús immal-taktijulmalad imadi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin anmal-tummagan Romanomalga Jesús-ukchamal, emalga Jesús-mesgal. Tegin tule-tummagan nakrusgin-nai Jesús-mechamalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Tenal anmal abintadiindo Jesús Romanomal-akar Israel-tulemal-onogo. Imi Jesús-purkwijad-akar pato ibapágus. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Tenal anmal-omegan-wal-walgwen anmalga chognonimal, emalde wakur-polego uanzhe arpimal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tenal omegan Jesús-mui kwen onoszhul-kus. Al omegan weob pakal anmal-ebesmal. Tegin omegan anmalga chognonimalbaldo, emalde angelmal-takchamal. Tenal angelmal emalga chogzhamal, Jesúsde kannan tulles. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Tegin anmal-pakamalad-wal-walgwen uanzhe arpimalmo. Tenal anmal-pakamalad omegan-chogzhad-yopí takchamalmo, Jesús-mui kwen maichul. Tenal anmal-pakamalad Jesús-kwen-takchajulmalmo.” ");
INSERT INTO kvnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tegin Jesús tule-walbogidga chogal: —¿Teobí? Tenal pemal immal kwen wichulma. Tenal pemal Pab-kaka-palchogmalad pél chogzhamaladbal pe penmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Imi pemal wismalbalzhulzhí, Cristo ampayo nug-tunkueddu, weob wilegenab? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tegin Jesús tule-walbogwadga palchogalzhun: Pab-kartagin egin pél nermalejad; kepegin Moisés egin nermajad, tegin Pab-kaka-palchogmalad egin pél nermasmalad-ugakche. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tegin tule-walbogid neg-kwebur-natapidzhe omosmalgu, Jesús ukin-pakal nejogalbalin. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tenal tule-walbogid Jesúsga kannan-kannan chognaigualmal: —Pe melle ukin pal naoma. Imi pe tak, tad pato arkwandani. Pul pe akalzhul anmal-neggin anmalbak peio. Tegin Jesús tule-walbogwadbak peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tegin Jesús tule-walbo-nonikidbak mes mas-kunchogalgu, madu chus. Tegin Jesús Pab Tummadga tog-nuedi chogzha. Tegin Jesús pisli-pisli madu imasgu, tule-walbo-ebak-nonimaladga madu ukcha. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tegidgin tule-walbogid mag Jesús-taknonimalzhun. Tenal Jesús tule-walbogwad-abalgin ilgwen oweles-nad. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tegin tule-walbogid aga emal-emal chogalmal: —¿Imi Jesús igalbal anmalbak chunmadanikidgin, tegin anmalga Pab-karta palchogdanikidgin, anmal ulubgin yer-itole-nadzhulzhí? Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tegin tule-walbogwad ilgwen kwisgudgu, kannan Jerusalénzhe almalbal. Tegin Jerusalénzhe nonimalgu, taknonimal, Jesús-e-chapingan-walambe-kakagwenchakkad, Jesús-chapingan-pimaladbak ormabukmal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Imi teun tule-ormabukmalad chunmananimal, chogalmal: —Imi Tummad-Jesús-kannan-tullejad, wedin ib-chunchunnad. Tegin Jesús Simón-Pedroga chunchunnad-sanal nononi. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tegin tule-walbogid-nonimalad tule-pukmaladga chogalmalmo, igalbal emalga igi immal kusmogad. Tegin tule-walbogwad chogalmalmo: —Imi Jesús-pisli-pisli madu-imajadgin, anmal kep mag taknonimal, we tuledin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tegin Jesús-e-chapingan ampa Jesúsgin chunmananikidgin, Jesús-chunnad e-chapingan-abaladgin sanal kwisgunoni. Tegin Jesús aga e-chapinganga chogal: —¡Anná! ¿Pemalde? Imi pemal aga ulubgin akalzhul-itogelen, nabirin. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tegidgin Jesús-e-chapingan Jesúsgin kwakijadbal kikli nadmal. Tenal e-chapingan ebinzhasmal, wedin Jesús-e-purpa. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tegin Jesús aga e-chapinganga chogal: —¿Ibiga pe chuli-pinzhe itobukmal-wede? ¿Tegin pe ulubgin ibiga ankin penmalbal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Imi pe an-takto, an-chunkal an-nag. Antin, an Jesús. Pe an-ebudo, antin sanal, an purpajul. Tenal pe an-takto, antin chan tegin an kal nika. Tenal purpadin chan, kal pel nikchul, pinche purpabi. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tegin Jesús pél chunmasgu, aga e-chapinganzhe chunkal tegin nag-maklejad oyoal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tegin Jesús-e-chapingan weob pakal pejadbal, tegin peyedzhe weligwal-itononikidbal, neg-owesmal, Jesús sanal nononi o chul. Tegidgin Jesús-tule-pukmaladga chogal: —¿Imi pemal wegin mas-kunned wis nika an pemalga oyogal, an purpajul, antin sanal? ");
INSERT INTO kvnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tegin e-chapingan Jesúsga chogalmal: —Imi anmal ua-chelogaled wis nika, (tegin anmal acha-nis wis nikmalbal). Tegin e-chapingan Jesúsga abal-piskal ua-ukchamalgu, ");
INSERT INTO kvnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús e-chapingan-wagin pél ua-kucha. Tegin Jesús aga e-chapingan-pukmaladga chogalbal: ");
INSERT INTO kvnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","—Imi an pemalbak ti-un, weob-ankin-immal-kujad, an pél pemalga chogzhado. Imi Moisés-igalgin, tegin Pab-kaka-palchogmaladgin tegin Pab-namaked-kartagin nermakal-mai pel-kwapa ankin keg-chulgu kued-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tegin Jesús Pab-kartagin mag-itogal aga e-chapingan-imas. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tegin Jesús aga e-chapinganga chogal: “Imi Pab-kartagin nermakal maido: ‘Imi Cristo-Pab-akpene-chogzhad-palmidagoed-tule purkwene, tegin purkwaled-akar ibapágin kannan tullenonibalo.’ ");
INSERT INTO kvnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Tegin Pab-kartagin nermakal maibaldo: ‘Imi tule Cristo-nuggin pel-kwapa tule-akal-akal-chunmakedga chunmanonimalo, tulemal aga ulubgin iskuedgin pukib-itogenabmal, tegin Pab we tulemalga iskued elinoniko.’ Tenal kepegin Jerusaléngin-inzhel choglenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imi pemal pél an-takchamal an wiledi-kus, an nakrusgin-naidgin purkwis, tegin imi an kannan tullesbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tegin an pemalga Pab-Purpa-Nued-palmidago, an-Pab-kaka-ukchadyob. Tenal pemal melle we-akar nemalo. Tenal pe iti-Jerusalén-neg-kweburgin peimalo, pemal nikpa-neg-akar Pab Purpa Nuedbal pela-pela kannaleged nikanonikoedzhe.” ");
INSERT INTO kvnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tegin Jesús Betania-tikalbal aga e-chapingan-ches. Tegin Jesús Betania-tikalzhe omosgu, kusgu e-taedbal nallakwa aga chakwa imas. Tegin Jesús aga e-chapinganga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","—Imi Pab pemalga immal-nued imakelen, nabirinye. Tegidgin Jesús ampa chunmanaidgin ilgwen Pab-negzhe aknakwid. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tegin Jesús-e-chapingan Pab Tummadyob Jesús-otummosmalgu, pela-pela weligwaledgin kannan Jerusalénzhe almalbal. ");
INSERT INTO kvnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tegin Jesús-e-chapingan Pabzhe-koled-neggin pane-pane Pab-Tummad-otummodi-kusmal. Pitomalgu.");
INSERT INTO kvnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Imi kepe-saglagin ampayo iti-nap naigueddu, Pab-kakapurwabi kudiin, tenal Pab Tummadbak kudii. Tenal we kakapurwa, Pab. Wedin, Pab-Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tenal Pab-Jesús kepe-saglagin Pab Tummadbak pato purpal kudiin. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Imi Pab Tummad Jesúsbal pel-kwapa immalmal opinnis. Tenal immal-kwen-nikchul, Pab Tummad Jesúsbal kwen opinniszhulid. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tenal tule-tullejiid pel-kwapa Pab-Jesús-akar tani, tegin Jesúsbal pel-kwapa tulemal-mag-itononimal neg-talgunonikidyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Imi neg-taled neg-chichid-otalo. Tenal neg-chichid neg-taledgin keg pal nakwegus. Al Pab-Jesús neg-taledyob anmalga kunonimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Imi te ibagwengin tule-walgwen maigus, we tuledin nug Juan Bautista. Tenal we tule Pab-Tummad-tar-palmial. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tenal Juan noni tulemalga palchoggal, Jesúsdin kallen neg-otalogedyobid. Tegin Juan nonibal, tulemal-pel-kwapa ebal Jesúsgin ibzhenonimalgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tenal Juan Bautista kallen pela-pela neg-otalogedyob-chul, pinche unnila Jesúsgin chunmanoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tenal Jesúsdin neg-otaloged-chunchunnad, tenal Jesús tule-ilbal mag itogal tulemal-imanoni. Al Jesús iti-napche noni. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tenal Jesús iti-napkin tigusgu, tule-iti-napkin-pukmalad aku Jesús-takchamal, Jesúsde toa-tule. Tenal Jesús-iti-nap-opinnijadbal, tulemal mag Jesús-taked-wilubmalan. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tenal Jesús aga e-tulemal-Israelmalzhe nonigu, e-tulemal Jesús-kwen-abingaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tenal tulemal-wal-walgwen Jesúsgin-penzhul-kunonikidgin Jesús-abingasmal. Tenal Jesús tule-e-abingasmaladga igal-ukcha, Pab-Tummad-nuskanga kugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tenal Pab-nuskan tule-sanaledyob kwen mimmilenonijulmal, tegin tule-sanal-pinzheedyob-chul, tegin tule-itolegedbal-chulbal. Tenal Pab-nuskan Pab-Tummad-itolegedbal mimmilenonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Imi Pab-kakapurwa anmalga sanal kunoni. Wedin Jesús. Tenal Jesús anmal-abalgin kudigus. Tegin anmal Jesús-yer-taed-takchamal. Tenal anmal Jesús-e-taedbal mag takchamal Jesús Pab-Tummad-akar noni. Tenal anmal mag takchamalbal wedin Pab-Tummad-Machi-walkwénnagwad. Tenal Jesús tulemalbak pinnallé-naneed-wilubzhulinadbal yabli pinnallé nanedi-kus. Tenal Jesús napírra chunmadi-kusbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Imi Juan Bautista Jesúsgin chunmadi-kusgu, chogdi-kusdo: “Imi an akpene pemalga chogzhado: ‘Tule-pid kujal an-cholbal noniko. Tenal we tule anka-pul-iktual-kudigujadbal, anka pul tule-tummad.’ Imi Jesús, a-tuledo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tenal Jesús wilejakwa anmal-taked-wilubzhulinadbal yabli wilejakwa anmal-takti-kus. Al anmal ukin-ukin pentalenonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Imi Pab Tummad Moisésbal igal-mezhis tule igi naneed-wilubmal. Tenal tulemal Jesucristobal kep wisgunonimal Pab Tummad wilejakwa tule-taked-wilubzhulinadbal, napírra wilejakwa tule-tak. Tenal tulemal Jesucristobal igal-chunchunnad wisgunonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tenal Pab Tummad, tule tar-kwen-takchajul-kus, tenal e-Machi-walkwénnagwad-Jesúsbi aga mecha e-Pabbak kudigus. Al Jesús tulemalga palchognonijun, Pab Tummadde ibi-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Imi Juan Bautista kepegin Jesúsgin chunmakalgu, weob kusdo. Tenal teun Judiomal-Jerusaléngin-pukmalad tule-irwal-Pabzhe-kolmalad-tegin-e-pentamalad-palmismal Juan Bautistaje ekisgal: “¿Pede, ibi-tule?” ");
INSERT INTO kvnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tegin tule-palmilenonimalad Juan Bautistaje ekichisgu, “¿Pe ibi-tule?” Juan yakir tulemal-kwen-itoszhul. Tenal Juan tule-nonimaladga pakal-pud chogzhado: —Antin, an Cristo-Pab-Tummad-akpene-chogzhad-palmidagoed-tulejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tegin tule-palmilenonimalad kannan Juanzhe ekichialbal: —¿Tede pede toa-tulejun? ¿Tegil pe Pab-kaka-palchoged-akpenegwad-Elíasdé? Tegin Juan tulemalga chogalbal: —Antin a-tulejul. Tegin tule-palmilenonimalad kannan Juanzhe ekichialmalbal: —¿Tegil pe te Pab-kaka-palchogeddé? Tegin Juan tulemalga chogalbal: —Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tegin tule-palmilenonimalad kannan Juanzhe ekichialbalzhun: —¿Tegil pe we tulejul-choggu, tede pede toa-tulejun? Al an pei, pe anka wis chog, tule-an-palmialidga an nuekwá pebal choggal. ¿Tegil ibi pe chedanijun? ");
INSERT INTO kvnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tegin Juan Bautista tule-palmilenonimaladga Pab-kaka-palchoged-Isaías-chogzhadgin palchogalzhun: —Imi tule-walgwen neg-nikchulidbal kolmakal-kolmakal chunmanoniko: ‘Imi pe Tummadga inniki-inniki igal imakenabmal.’ Is. 40:3 Antin a-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tegin Pariseomal-tule-palminonimalad Juanzhe kannan ekichialbal: ");
INSERT INTO kvnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Imi pe Pab-akpene-chogzhad-palmidagoed-tule-chul-choggu, tegin pe Elías-chul-choggu, tegin pe te Pab-kaka-palchoged-chulbal-choggu, ¿tede pe ibiga tigin tulemal-okchun? ");
INSERT INTO kvnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tegin Juan tule-nonimaladga chogalzhun: —Imi antin tiginbi unnila tule-og, oyogal tule aga ulubgin chunchunnad iskuedgin pukib-itononi. Tenal tule-tummad-chunchunnad pemal-abalgin kudii, tenal pemal yabli aku we tule-takmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tenal tule-an-cholbal-tanikiddin anka-pul-tule-tummadiidbal, an pel-unnijul we tulega kutar-tub echikkal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tegin Juan Bautista tigin-tule-ognaidgin, teun tiwal-Jordán-opakal-Betaniagin, Juanga pel-kwapa weob immal kusdo. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tegin te pangin, Juan Bautista tani-Jesús-takalgu, chogal: “Pe tak, Oveja-Chapini-Pab-Tummad-akar-tanikid tanigu. We tule pel-kwapa tule-iti-napkin-pukwamaladga iskued-nikad pél elinoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tenal an akpene we tulegin pemalga chunmadi-kusdo. Tenal teun an chogzhado: ‘Tule-an-cholbal-tanikoed anka-pul-iktual-kudiidbal anka pul tule-tummaddo.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tenal an akpene pel-wichulmogan, Pab-akpene-chogzhad-palmidagoedde toa-tule. Tenal Israel-tulemal mag takegal piti-tule Pab-akpene-chogzhad-palmidagoed, al an tigin-tulemal-ognoni.” ");
INSERT INTO kvnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tegin Juan Bautista kannan Jesúsgin chunmakalbal: “Imi an takchado, Pab Purpa Nued nikpa-akar nuyob aktedani, tegin Jesúsgin chignoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tenal ampa an wichulmogan Jesúsde toa-tule. Tenal Pab Tummad tigin-tulemal-oggal an-palmial. Tenal Pab Tummad anka chogzhado: ‘Imi pe tule-takchal Pab Purpa Nued nuyob targin chignoni, wedin chunchunnad a-tule. We tuledin Pab-Purpa-Nuedgin-tulemal-ogoed.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tenal an chunchunnad imial takchado, Pab Purpa Nued Jesúsgin nuyob chignoni. Al an chogdo, we Jesús chunchunnad Pab-Machido.” ");
INSERT INTO kvnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tegin te pangin, Juan Bautista aga e-chapingan-walbogwadbak pukwadgin, Jesús-takalmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tegin Juan Jesúsgin chogalbal: —Pe tak, Pab-Oveja-Chapini tanigu. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tegin Juan-e-chapingan-walbogid, Juan-Jesúsgin-chogzhad itosgu, Jesús-cholbal ilgwen nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tegin Jesús chorzhik akpiridgu walbo tule-takal, e-cholbal tanimal. Tegin Jesús tule-walbogwadzhe ekichial: —¿Ibi pe peimaldé? Tegin tulemal-Jesús-cholbal-tanimalad Jesúsga chogal: —Tule-oturdaked, ¿pia pe maidé? ");
INSERT INTO kvnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tegin Jesús tule-e-cholbal-tanimaladga chogal: —Tegil pe anpak nemaldo an-neg-takegal, an pia mai. Tegin tule-walbogid Jesúsbak mes nadmalzhun, Jesús-maidzhe. Tenal teun takalgu, neg pato chedo-wachilbake nai. Al tule-walbogid aka Jesús-neggin pesmalzhun kabgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tenal tule-walbogid-Juan-itosmalad-walgwen nug Andrés. We Andrésdin Simón-Pedro-e-urpa. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tegin Andrés ilgwen aga e-ia-Simónzhe nad. Tegin Andrés e-ia-Simónzhe nonigu, Simónga chogal: —Imi anmal Pab-akpene-chogzhad-palmidagoed-tule-onosmal. Wedin, Cristo. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tegin Andrés Jesúszhe aga e-ia-Simón-cheal. Tegidgin Jesús Simón-takalgu, Simónga chogal: —Imis pe nug Juan-machi-Simón. Tenal pe kujal nug-pid nikunoniko, Cefas. (We nugdin choglege Pedro.) ");
INSERT INTO kvnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tegin te pangin Jesús Galileaje nejognaidgin, Jesús Felipe-takal. Tegin Jesús Felipega chogal: —Anpak nemalma ankin turdagal. Tegin Felipe Jesúsga chogal: —Tegil nabirde. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Tenal Felipedin, Betsaida-tol, Andrés-tegin-Pedro-e-neg-kweburginmogad. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tegin Felipe Natanael-aminad. Tegin Felipe Natanael-onosgu, ka chogal: —Imi anmal tule-walgwen-onos. Akpene-akar Moisés-kartagin nermakal maido, tule-walgwen taniko. Tenal Pab-kaka-palchogmalad ampa Moisés-chogzhadyob chogzhamalmo tule taniko. Tenal we tule Jesús-Nazaretkined. Tenal we Jesúsdin José-e-machi. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tegin Natanael Felipega chogalzhun: —¿Nazaretkinedí? ¿Imi tule-nued Nazaret-akar igi noniko-ade? Chulá. Tegin Felipe Natanaelga chogal: —Tegil nemaldo takne, pe wisgal ib-chunchunnad o chul. Tegin Natanael Felipega chogal: —Tegil an pebak naodo. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tegin Jesús Natanael-e-omodani-takchagu, Jesús Natanaelgin chunmakal, chogal: —We tule, Israel-tule-chunchunnad. Tenal we tule, tule-nued, keg tulemal-yardaged. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tegin Natanael Jesús-egin-chogzhad itosgu, Jesúszhe ekichial chogal: —¿Igi pe an-wiis-ade, an tule-yardaged-tulejul? Tegin Jesús Natanaelga chogal: —Imi Felipe ampayo peje kolneeddu, an chapi-wag-islub-ulpal-kwichi, an pe-takcha. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tegin Natanael Jesúsga chogal: —¿Teobí? Tule-oturdaked, tegil pe Pab-Tummad-Machido. Tegin pe Israel-tulemal-e-erreybaldo. Al pe nabir an-wísye. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tegin Jesús Natanaelga chogal: —Imi an chapi-wag-islub-ulpal kwichi an-pe-takchad an-pega-chogzhadbal ¿pe ankin ibzhenoniyé? Tenal an pega iché immal-imajadbal pato pe ankin ibzhenoni. Tenal an pega chogzhundo: pe kujal pul-pule immal-taktijulmalad taknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tegin Jesús kannan chogalbal: —Imi an chunchunnad pega chogdo: imi pemal kujal taktamalo, nikpa-neg arkejii. Tegin pe taktamalbalo, Pab-angelmal an-Te-Tule-Chunnaje nikpa-akar aktegwis, tegin nakwegwisbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tegin Jesús-Natanaelbak-chunmajad-ibapágin, Caná-Galileagin, tule-walgwen ome-nikunai. Imi teun Jesús-e-nan tule-ome-nikunaidgin chimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tenal teun takalgu, machi-ome-nikuneed-e-pab, Jesúszhe kochamo, Jesús aga e-chapinganbak e-machi ome-nikuoed-takegalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tegin machi-ome-nikunaidga vino akunonigu, Jesús-e-nan Jesúsga chognoni: —Machi, tulemalga vino akus. ¿Anmal igi imamalo? ");
INSERT INTO kvnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tegin Jesús aga e-nanga chogal: —Ome, ¿ibiga pe anka weob chogdé? Imi anka ampa wilub kwen omojul immal-taktijulid imagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tenal Jesús-e-nan neg-ibed-e-mosmalga chogal: —Jesús pemalga immal chogoed-yopí, pe imakenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Imi teun aka-mosmal-abir metemal-akwagad-kwanerkwa pukwamal. Tenal we metemal ti-chigal pukwamal, Judio-tulemal Moisés-igalbal chunkal-enukedgin chwilidik aga imamalgal. Tenal mete-ilbal galón-tulagwen o galón-tulagwen-kakaambe-dewa, melgu ti chei. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tegin Jesús neg-ibed-e-mosmalga chogal: —Imi we mete-kwanerkwad pél pe taka-taka ti enzhemalo. Tegin neg-ibed-e-mosmal metegin pél ti enzhasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tegin Jesús neg-ibed-e-mosmalga chogalbal: —Imisgin pe iche wis weido, itoged-tummadzhe chedgal, we tummad itogal, igi itole-dewa. Tenal neg-ibed-e-mosmal Jesús-chogzhadyob pél immal imasmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tegin tule-itoged-tummad mosmal-kobed-chejad itosgu, pato itogal, vino. Tenal tule-itoged-tummad wichul pia vino tani. Tenal neg-ibed-mosmal-ti-wesmaladdin wismal, vino ti-akar tani. Tegin tule-itoged-tummad machi-ome-nikujadzhe kocha, ");
INSERT INTO kvnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tegin machiga chogal: —Imi meke-ibi-tule keg-chulgu vino-pul-nugu-kobleged-inzhel mimimal. Tegin tulemal pela-pela vino kobalmalal, kep vino istar-kobleged tulemalga mimilegalbal. Tenal pegadin teob kwen kuszhul. Tenal pedin imisgwadzhe pe pul vino-nued chabos. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Imi Jesús weob Caná-Galileagin kepe immal-taktijulid imas. Tenal Jesús aga oyosdo, ede kannaleged nika. Tegin e-chapingan kep Jesúsgin ibzhenonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tegin Jesús vinoga-ti-opinnijad-cholbal Jesús tegin e-nan, tegin e-urpamal, tegin e-chapingan Capernaumzhe nadmalzhun. Tegin Jesúsmal Capernaumgin ipókwajal wis ampagusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Imi Judiomalga-Pab-Najad-Itoged omodanikidgin, Jesús Jerusalén-neg-kweburzhe nad. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tegin Jesús Jerusalénzhe nonigu, ilagwen Pab-Tummadzhe-koled-negzhe nad. Tegin Jesús Pabzhe-koled-negzhe tognonigu, taknatap tulemal moli-peb-nikad, ovejamal tegin numal-ukpukmal. Tegin tulemal mesa-nabal pukwamalbal, tulemalga mani-pid Judio-mani-chunnadbak ogwananimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tegidgin Jesús tulemal-takchagu immal-ukpukmal, Jesús tub-kwilomakaled amis. Tegin Jesús tub-kwilomakaledgin Pabzhe-koled-neg-akar ovejamal, moli-peb-nikmalad-pukwad-onis. Tegin Jesús tulemal-mani-ogwananimalad-e-mani misbal, tegin e-mesa okpisbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tegin Jesús tule-nu-ukpukmaladga chogal: —¡Pe magadbal numal-onimalo! ¡Imi an pal kwen peichul, pemal immal-uked-negga an-Pabzhe-koled-neg imamalgal! ");
INSERT INTO kvnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tegin Jesús-e-chapingan Jesús-chogzhad itosgu, kep itos-nadmal akpene Pab-kartagin nermakal mai: Imi an Peje-koled-neg nudagal an pela-pela arpanaidbal, an neg-owed. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tegin Judio-tummagan Jesúszhe ekichialmalzhun: —¿Imi pede ibi-tule-ade? ¿Pe igi anka oyogo, pe igal-nika weob immal-tulgan-onigal, tegin mani migalbal? Pe anmalga immal-taktijulid oyogenabgweldo, anmal wisgal pe Pab-Tummad-akar tani o chul-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tegin Jesús tule-tummaganga chogal: —Imi pemal iti-Pabzhe-koled-neg opelojal, antin ibapágin kannan iti-neg okwisbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tegin Judiomal Jesúsga chogalmal: —Pe melle anka yosgu chunmama. Imi iti-neg pirka-tulabo-kakanerkwa kales chobgal. ¿Tenal pe chog: “An ibapágin kannan chobneé?” Chulá, an pegin kwen ibzhejulá. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tenal Jesús akwa-neggin kwen chunmaszhul, tenal Jesús aga e-changin chunmas. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Al Jesús purkwaled-akar kannan tullesgu, e-chapingan kep wisgunonimal, Jesús chogzhagus e-chan ibapágin kannan kwisgunonibalo. Al Jesús-e-chapingan kep Pab-kartagin ibzhenonimalzhun. Tegin Jesús-e-chapingan kep Jesús-chogzhadgin ibzhenonimalbalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Imi Jesús Pab-Najad-Itogedgin Jerusaléngin-maidgin, Jesús-immal-taktijulmalad-imajadbal tulemal-ichejul Jesúsgin ibzhenonimal, Jesús Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tenal Jesús pakal-pud tulemal-wiis-choggu tulemal nuekwa ebal naiguszhulmal, al Jesús tulemalgin kwen ibzhejulda. ");
INSERT INTO kvnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tenal Jesús tule-kwen-napijul ega choggal, we tule, tule-nued o tule-iskana. Tenal Jesúsdin pato wiis, tule aga ulubgin igi pinzhebukmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Imi teun takalgu, tule-walgwen maido. We tule nug, Nicodemo. Tenal we tule, Pariseo-tule, tenal Judio-tummagan-wala-tulapá-kakaambegwad-walgwenga maimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tenal Nicodemo mutik Jesús-wis-taknoni Jesúsbak chunmagal. Tegin Nicodemo Jesúsga chogal: —Tule-oturdaked, anmal wismaldo, Pab Tummad pe-palmial Pab-igalgin anmal-oturdagal. ¿An igi nabir wiis? Imi Pab-tule-palmialidbi weob immal-taktijulmalad ima. Tenal Pab pebak kudijulilen, pe weob immal-taktijulid kwen imakojulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tegin Jesús Nicodemoga chogal: —Nabir. Imisgin an chunchunnad pega chogdo: imi tule kannan kwen mimmilejulil, Pab-neg-takmaid kwen takojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tegin Nicodemo Jesúsga chogal: —¿Imi tule-seredgin igi kuneé, kannan mimmilegal? Keg kue. ¿Anmal kannan nangin togenabbalzhundé, kannan mimmilegal? ¡Paaa! ¿Igi taklejun? ");
INSERT INTO kvnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tegin Jesús Nicodemoga chogal: “Imi an chunchunnad pega chogdo: imi tule tigin tegin Pab-Purpa-Nuedbal mimmilejulil, we tuledin meke-igi Pab-neg-takmaidgin keg tog. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tenal tule sanal mimmilenonikil, wedin sanal. Tenal tule Pab-Purpa-Nuedbal mimmilenonikil, wedin purpa. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tenal tule-kannan-mimmilegoed-igal an pega chogzhadgin, pe weob pakal peied-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Imi pe takto, purwa kolalil, a-itoleged nane. Tenal pe nabir purwa-koled itogo, tenal pe wichul, purwade, pia tanibal, tegin pe wichulbal, purwade, piaje nebal. Tenal tule Pab-Purpa-Nuedbal kannan mimmilenonikil ampa purwa-yopímo. Al pe mag kwen itojul tule igi Pab-Purpabal mimmilenoni. Tenal tule e-taedbal mag taklenoniko, Pab Purpa Nuedbal mimmiles.” ");
INSERT INTO kvnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tegin Nicodemo kannan Jesúszhe ekichialbal: —¿Tede igijun we immal-pe-chognaiddé? ");
INSERT INTO kvnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tegin Jesús Nicodemoga chogal: “¿Imi pe Israel-tule-oturdaked-tummadzhulzhí? ¿Tede pe wichuldé, ibigin an chunmajii? ");
INSERT INTO kvnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nabir. Imi an chunchunnad pega chogbaldo: imi anmal immal-wijiidbal we immalgin chunmadimal. Tenal anmal immal-takchadbal we immalgin chunmadimalbal, kaka-kwadigalzhul. Tenal pemal yabli anmal-chunmakedgin kwen ibzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Imi antin iti-napkined-immalmalgin pemalga chunmadimal. Tenal pemal ampa anpal kwen ibzhejulmal-choggu, ¿tede an igi pega Pab-neggined-immalmalgin chunmako? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Imi tule-pid Pab-maidzhe kwen nakwiapchul, pemalga Pab-neggined-immalmalgin chunmagal. Tenal an-Te-Tule-Chunnabi Pab-Tummad-maid-akar aktenoni. Al an igal-nika Pab-neggined-immalmalgin pega chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Tenal akpene Moisés neg-nikchulidbal chowalgin nakpe-ezha-kortigidgad-nazhis tule melle purkwemalgal. Tenal an-Te-Tule-Chunna ampa chowalgin nazhileged-wilubmo, ");
INSERT INTO kvnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tulemal-pel-kwapa an-Te-Tule-Chunnagin-penzhul-kunonikidbal, ilagwen-nadgu tula-tigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Imi Pab Tummad peyedzhe pel-kwapa tule-iti-napkin-pukmalad-pilalgus. Al Pab Tummad iti-napche e-Machi-walkwénnagwad-palminoni, tulemal-anal iskuedgin purkwegal. Al meke-ibi-tule Pab-Tummad-Machigin penzhul-kunonikil, ilagwen-nadgu tullego, e-iskuedbal Pab Tummadzhe sapejul pal kwen oturdalegojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tenal Pab Tummad aga e-Machi-palminoni, e-Machibal tule-iti-napkin-pukmalad-abonogal, sapejul tule-iti-napkin-pukmalad-oturdagal-chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Tenal meke-ibi-tule Pab-Tummad-Machigin penguszhulil, Pab Tummadzhe sapejul pal kwen oturdalegojul. Tenal tule Pab-Tummad-Machigin ibzhaszhulil, Pab-Machi-Walkwénnagwadgin-ibzhejulidbal Pab Tummadzhe pato sapejul oturdalegedzhe natapmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Imi Pab-Machi iti-napche nonikidbal, neg-otalononi, tule igi nanemalgal. Tenal tulemal pul neg-chichidgin nanebimal, pul neg-taledga. ¿Ibiga tulemal weob nanebimal? Imi tulemal pul-yer itomal istar nanegal. Al we tulemal Pab Tummadzhe sapejul oturdalenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Tenal tule-istar-nanemalad-pel-kwapa istar neg-taled takmal. Tenal tulemal-iskana yapa neg-taledzhe tagmal, e-istar-taed melle mag taklegal. Al tule-istar-timalad ampa yapa Pab-Machije tagmalmo e-istar-taedde melle mag taklegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Tenal tule-nuegan neg-taledzhe nonidamal, mag taklemalgal, e-immal-imajadde Pab-peiedyob imasmal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tegin Jesús Nicodemobak-chunmajad-cholbal Jesús aga e-chapinganbak Jerusalén-akar nadmal. Tenal Jesús ampa Provincia-Judeabal kudii-pesmal. Tegin Jesúsmal tebal tigin-tulemal-ogdi-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tenal teun Salim-omopen Enón-neg-nugadgin tulemal-ichejul Juan Bautistaje irmamamimal Juan tigin e-oggal. Tenal ti tebal ichejul nai-choggu, al Juan Bautista tigin tulemal-ognaimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Tenal teun Juan Bautista ampayo oturdaleged-neggin oturdalegeddu.) ");
INSERT INTO kvnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Imi teun Juan-e-chapingan, chwilidik-immal-imaked-igalgin Judio-walgwenbak aga imakalmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tegin e-chapingan Juanga chognonimal: —Tule-oturdaked, imi tule Jordán-tiwal-opakal pebak kudigujad, tegin pe akpene we tulegin chunmadi-kujad, tigin-tulemal-ognaimo. Tegin tulemal-pel-kwablejal we tuleje irmamaimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tegin Juan Bautista aga e-chapinganga chogal: “Nabir. Tenal ankadin iwen-kwen-akalzhul. ¿Tenal Pab Tummad pe-pentajulil immal imagal, pe igi immal imako? Keg kue. Al Jesús-immal-imanaid Pab-Tummad-itolegedbal Jesúsga kunai. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imi pemal chunchunnad an-itosmal, an igi chogzhad. Tenal an chogzhado, an Pab-akpene-chogzhad-palmidagoed-tulejul. Tenal Pab Tummad an-palmial we tulega iktualeba igal-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Imi pemal wismaldo, tule-ome-nikuedgin, igi igal-mai. Tenal puna e-machered-nikuneedgad, e-machered-e-aigad chul. Tenal machered-e-ai pinche we machered-pentanai, tegin we machi-ome-nikuneed-abintajii, inkwa noniko-dewa. Tegin e-ai machi-ome-nikuneed-itojal tani, e-ai pela-pela weligwal itononiko. Imi antin ampa we tule-e-aiyobmo. Al an weligwal itononi. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Al Jesús-e-nug pul tunkued-wilub. Tenal antin pul nug-totogwadga kued-wilub.” ");
INSERT INTO kvnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tegin Juan chogalbal: “Imi tule-Pab-Tummad-maid-akar-tanikid, pul tule-tummad. Tenal tule-iti-napkined Pab-neg-taktijulidbal Pab-neggin keg chunma. Tenal tule iti-napkined-choggu, al tule iti-napkinbi nabir chunma. Tenal tule-Pab-Tummad-maid-akar-tanikid, tule-iti-napkinedyob chul. Tenal we tule pel-kwapa immal wiis. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","“Tenal tule-Pab-maid-akar-tanikid imial-immal-takchadbal, tegin ual-immal-itojadbal, chunmakalda. Tenal tulemal yabli e-chunmakedgin kwen ibzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tenal tule Pab-maid-akar-tanikid-chunmakedgin ibzhajal, we tule chognoniko, Pab Tummad chunchunnad chunma. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tenal tule-Pab-tar-palmialid, Pab-chogzhadgin chunma. Tenal Pab Tummad tule-e-akar-tanikidga pellallé E-Purpa-Nued-ukpal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Tenal Pab Tummad e-Machi-pilaledbal pela-pela aga e-machiga igal-ukcha pellallé immal imagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Tenal meke-ibi-tule Pab-Machigin penzhul-kunonikil, ilagwen-nadgu tula-tio. Tenal meke-ibi-tule Pab-Machi-abingejulil, ilagwen-nadgu pal kwen tullegojul-kuo. Tenal tule-Pab-Machi-abingaszhulmalad ampa sapejul Pab Tummadzhe ilagwen-nadgu oturdalenonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Imi teun takalgu, Pariseomal wisgunonimal, tulemal-pul-ichejul Jesúsbal naigumamimal, Juanbal pul-iché naigumamimal. Tegin Jesús Juanga pul ichejul tigin tulemal-ognaibal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tenal Jesús tigin-tulemal-kwen-ognaichul, tenal e-chapingan tigin-tulemal-ognanimal.) ");
INSERT INTO kvnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tegin Jesús wisgusgu Pariseomal e-wisgusmal ede tigin ichejul tulemal-ognai, Jesús Provincia-Judea-akar kannan nadmalbal, Provincia-Galileaje. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Imi teun Jesús Provincia-Samariagin keg-chulgu najo-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tegin Jesús Provincia-Samariagin-natapidgin neg-kwebur-Sicar-nugad-tikalzhe nonimalzhun, tad-Jacob akpene aga e-machi-Joséga nap-ukchadzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tenal we neggin Jacob-ti-wejad-ya akial-chii. Tenal Jesús peyedzhe-nanajadbal pela-pela uluku tani-choggu, al Jesús ti-ya-akial-chiid-nabal chignoni. Tenal teun takalgu, tad pato yoroku. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tegidgin Jesús Samaritano-ome-takal, e-chiidzhe ti weidani. Tegin Jesús omega chogal: —¿Imi pe ti-wejal, anka pe wis ti udagojí? ");
INSERT INTO kvnNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Imi teun Jesús-e-chapingan pato neg-kweburzhe nadmal mas-kunned pakegal.) ");
INSERT INTO kvnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tegin Samaritano-ome Jesúsga chogal: —An pega ti kwen uknejul. ¿Imi pe Judio-tulejulzhí, tede pe igi anche ti ekisneé? ¿Pe wiszhulzhí, antin Samaritano-tule? (Imi teun Judio-tulemal Samaritano-tulemalbak kusgu aga istar takmal.) ");
INSERT INTO kvnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tegin Jesús Samaritano-omega chogal: —Imi pe wisgujalen Pab tulega ibi uko, tegin pe wisgusbalilen toa peje ti ekisnai, pe anka kwen chogzhajulin: ‘An pega ti kwen ukojul.’ Tenal pe anche ti ekichijalen, antin pega ti-ilagwen-nadgu-tule-otuloged ukoen. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tegin Samaritano-ome Jesúsga chogalzhun: —Tummad, pe pormo nikchul ti weigal, tenal ti-ya-akial-chiid-orojulbali. Al pe unnijul ti weigal. ¿Tede pe pia ti-tule-otuloged onogo-adé? ");
INSERT INTO kvnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ade pede anmal-tadgan-Jacobga pul tule-tummadzhí? Imi Jacob aga we ya akis aga ti kobgal. Tegin Jacob-e-nuskan ampa we yagin ti kobzhamalmo, tegin e-immalmal-tulgan ampa we yagin ti kobzhamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tegin Jesús Samaritano-omega chogalbal: —Imi meke-ibi-tule we ti kobzhal, ampa kannan-kannan ukul-ukul itononibalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tenal meke-ibi-tule an-ti-ukchad kobzhal, ukul-ukul pal kwen itononikojul. Tenal an-pega-chogzhad-ti tule-ulubgin ti-kammubal ti-ilagwen-nadgu-ariomaidyob kunoniko, tule ilagwen-nadgu tullegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tegin Samaritano-ome Jesúsga chogalbal: —¿Teobí? Tummad, tegil pe anka te ti udado, an melle ukul-ukul pal itogal, tegin an itije, melle ti pal weinonigalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tegin Jesús omega chogalbal: —Nabir. Tegil pe aga macheredzhe kolnaddo. Tegin pe kannan tagbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tegin ome Jesúsga chogal: —Ani, an machered-kwen-nikchuli. ¿Tede an igi naga macheredzhe kolnao? Tegin Jesús omega chogal: —Nabir pe chogendo: ‘An machered-kwen-nikchul.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tenal pe machered-walatalgus-nikugus. Tenal pe-machered-nikad ampa pe-machered-chunchunnad chulbal. Al pe anka chogzhad, ib-chunchunnaddo: ‘An machered-kwen-nikchul.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tegin ome Jesúsga chogal: —¿Tummad, igi pe an-wisgus-ade, an machered-nika? ¿Tegil pe Pab-Tummad-kaka-palchogeddé? ¿Al pe weob an-wisyé? ");
INSERT INTO kvnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Imi anmal-tadgan iti-yal-kwichidgin Pab Tummadzhe kochamal, tenal pemal-Judiomal chogmal, anmal Jerusalénginbi Pab Tummadzhe koled-wilubmal. ¿Tegidde pe igi chogmójun? ");
INSERT INTO kvnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tegin Jesús omega chogal: “Ome, pe melle ankin-penguma. Tenal ibe kujal nonikodo, meke iti-yal-kwichidgin, meke Jerusaléngin, pemal Pab Tummadzhe kwen kolojulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tenal pemal-Samaritano-tulemal Pab-Tummad-wichulmaladbal Pab Tummadzhe kolnanimal. Tenal anmal-Judiomal Pab-Tummad-wijiidbal Pab Tummadzhe kolnanimal. Imi Pab-Tummad-tule-abonoged-igal unnila Judiomalbalbi noni. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Tenal ibe noniko, tenal imi ibe pato iche-iche kunai, tule-chunchunnad-Pab-otummonanimalad purpal, tegin ib-chunchunnadgin Pab Tummadzhe kolnanimal, tenal Pabzhe-koled negginbijul. Tenal Pab Tummad tule-purpal-eje-kolmalad-ami, eje-koledgin e-otummogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tenal Pab Tummad purpaled-choggu, al tulemal chunchunnadgin purpal Pab Tummadzhe kolenabmal Pab-Tummad-otummogal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tegin ome Jesúsga chogal: —Imi antin, an wisdo, Pab-akpene-chogzhad-palmidagoed-tule noniko. Wedin nug, Cristo. Tenal Cristo nonikil, anmalga pel-kwapa immalmal palchognoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tegin Jesús omega chogalzhun: —Imi an-pebak-chunmajiid, an a-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tegidgin Jesús-e-chapingan irmanonimal, Jesúszhe. Tegin e-chapingan Jesús-omebak-chunmajii-takchagu, weob pakal pesmal. Tenal e-chapingan Jesúszhe kwen ekichiszhulmal: “¿Ibi pe omeje ekis-wede?” Tegin e-chapingan Jesúszhe ekichiszhulmalbal: “¿Ibiga pe omebak chunmajii-wede?” ");
INSERT INTO kvnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tegidgin ome aga mete-ti-weied ebes, ilgwen neg-kweburzhe nadzhun. Tegin ome neg-kwebur omosgu, tulemalga palchognatap: ");
INSERT INTO kvnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Webal tule-walgwen chii. We tule an-igi-kudiid, pel-kwapa anka chogzha. Antin, an takto, we tule, Cristo-Pab-akpene-chogzhad-palmidagoed-tule. Al an pei pe anpak nemal we tule-taknegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tegin tulemal neg-kwebur-akar almalzhun, Jesús chiidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tegin ome-neg-kweburzhe-naded-impagin Jesús-e-chapingan Jesúsgin wilenaigualmal chogalmal: —Tule-oturdaked, pe mas wis kunkwelma. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tegin Jesús aga e-chapinganga chogal: —Tenal antin, an mas nika, tenal pemal kwen wichulmal, ibi-mas. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tegidgin Jesús-e-chapingan aga emal-emal ekichialmal: —¿Tegil tulemal masgin Jesús-okuchamaldé? ¿Al Jesús yapa mas kunyé? ");
INSERT INTO kvnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tegin Jesús chogalbal: —Imi Pab-Tummad-an-palmialid-choged-pallí an immal imaked, tegin Pabga-arpaged-pelogoed, wedin anka mas-kunned-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Imi pemal chogmalzhulzhí, ampa ni-walabake napi, immal-kwa weigal? Tenal an pemalga chogdo: pe nue takmaldo, trigo pato korodik nai, kuakwa kwangalnai. Tenal Jesús purpal chogzha, tulemal pato kuakwa pukwamal, Pabbal-naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tegin Jesús chogalbal: “Imi tule Pabbal-naigugal tulemal-amijal, we tule yer itononiko, tule-e-arpajadbal ega mani penuklejadyob. Tenal tule Pabbal-naigugal tulemal-imasmalal, we tulemal ilagwen-nadgu tullemalo. Al tule-immal-tigzhad tule-immal-wesmaladbak aga mes welgumalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Imi tadgan chogedyob: ‘Imi tule immal tigzhal, tenal tule-pid we immal-tigzhad weio.’ Tenal we chogzhad, ib-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tenal tule-immal-kwa-weiedyob an pemal-palmial tulemal-amigal, anpal naigugal. Tenal pemal kwen arpaszhulmal, pemal taknonimal, we tulemal pato kuakwa pukwamal anpal-naigumalgal. Tenal tule-pimalad pato arpasmal. Tenal tule-pimalad-arpajadbal pemalga ib-nuedga kunoni. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Imi Samaritano-ome tulemalga chogzhado, Jesús ega pel-kwapa immal-akalodiid chogzha. Al we neg-kweburgin Samaritano-tolgan-ichejul Jesúsgin ibzhenonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tegin Samaritano-tolgan Jesúszhe nonimalgu, Jesúsgin wilenaigualmalzhun e-neg-kweburgin wis peigal. Al Jesús ibbo we neg-kweburgin peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Imi teun Jesús Samaritano-tolganga kakal-chunmajadbal, Samaritano-tule-pul-ichejul Jesúsgin ibzhenonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tegin Samaritano-tulemal-Jesúsgin-ibzhenonimalad omega chogalmalzhun: —Imi pe anka chognonikidbalbi an kwen ibzhaszhulmal, imi anmal ual Jesús-itojadbal pul-pule Jesúsgin ibzhenonimal. Al anmal chunchunnad wisgunonimaldo, Jesús tule-iti-napkin-pukmalad-e-abonoged-chunchunnad. Wedin Cristo. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tegin Jesús ibbo Provincia-Samariagin megwijad-cholbal, ukin Provincia-Galileaje nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Imi akpene Jesús aga tukin chogzhado: “Tule-Pab-kaka-palchogmaladdin aga e-neg-kweburginmalad tule-tummadyob kwen tar-takojulmal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tegin Jesús Provincia-Galileaje omosgu, Galilea-tolgan ampokaagwal Jesús-abingasmal. Tenal akpene Galilea-tolgan Pab-Najad-Itogedgin Jerusalénzhe arpigusgu, Jesús-takchamal, pél immal imasgujad. Al we tulemal yer Jesús-abingasmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tegin Jesús kannan Caná-Galileaje nonibal. Imi akpene Caná-neg-kweburgin Jesús vinoga ti opinnis. Tegin Jesús kannan Canáje nonikidgin, teun tule-walgwen Capernaum-neg-kweburgin maimo. Tenal we tule errey-yalbal-arpaged-walgwen. Tenal teun errey-yalbal-arpaged-e-machi Capernaumgin yee-pakal mellemai. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tegin tule-errey-yalbal-arpaged itosgu Jesús Judea-akar kannan Galileaje noni, we tule Jesúszhe al, Caná-neg-kweburzhe. Tegin tule-errey-yalbal-arpaged Canáje nonigu, Jesúsgin wilenaigual Capernaumzhe ebak negal, e-machi-purkwedani-maid nuda-negal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tegin Jesús machi-yeed-e-pabga chogal: —Imi pemal immal-taktijulid kwen takchulil, ankin kwen ibzhenonikojulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tegin tule-errey-yalbal-arpaged Jesúsga chogal: —Tummad, nabir pe chogendo. Tenal antin, an peido an-machi ampayo purkweddu, pe an-negzhe wis nao an-machi-nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tegin Jesús tule-errey-yalbal-arpagedga chogal: —Imi an pe-negzhe need-wilubzhul, tenal pedin aga negzhe nao. Tenal pe-machidin kwen purkwenejul, pato nugus. Tegin machi-yegujad-e-pab Jesús-weob-ega-chogzhad itosgu, Jesúsgin ibzhas. Tegin we tule aga negzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tegin machi-e-pab ampa igalbal-natapidgin, e-mosmal igalbal machi-e-pab-abin-almal. Tegin e-mosmal igalbal e-tummad abingusgu, machi-e-pabga chogalmal: —¡Pe machi pato nugus! ");
INSERT INTO kvnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tegin machi-e-pab e-mosmalga chogal: —¡Tegil an weli! ¿Tede an-machide ibi-wachigin wis kadi-kunoni-ade? Tegin e-mosmal e-tummadga chogal: —Sae, ibgin-wachilgwengin, uged pe-machiga akinnoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tegidgin machi-e-pab wisgud-nad we wachigin Jesús ega chogzhagus: “Pe-machi pato nugus.” Al machi-e-pab Jesúsgin ibzhenonijun, tegin e-negginmalad pel-kwapa Jesúsgin ibzhenonimalmojun. ");
INSERT INTO kvnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tenal Jesús Judea-akar Galileaje nonigu, wegin Jesús pato ilabogus immal-taktijulid imagus. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tegin Jesús machi-nudajad-cholbal, Judio-itoged-tummad-naigudanikidgin, Jesús Jerusalén-neg-kweburzhe nonimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Imi teun Jerusaléngin Oveja-Wanagak-tikalbal, ti-tummad wilagwal chii. Tenal ti-wilagwal-chiid Hebreo-kakagin nug Betzata. Tegin ti-wilagwal-chiid-tikalbal neg-matargana-kwaatal pukwamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tenal we negmalgin, tule-yemalad-ichejul mamimal, tule-aku-atamalad, tule-mego-mego-nanemalad, tegin tule-tuwa-tinkualmalad. (Imi tule-yemalad ti-mumurmadagoed abintamamimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tenal ti-chiidgin Pab-angel impa-impagin aktenonikil, ti omumurma-nonida. Tenal tule-yeed-keped ti-mumurmakedgin opchal, meke-ibi-poni we tulega nugunonida.) ");
INSERT INTO kvnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Imi teun takalgu, tule-walgwen pirka-tulagwen-kakaambe-kakapábakkus, ti-mumurmaked-nabal yee mellemai. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tegin Jesús tule-yeed-mellemai-takchagu, Jesús pato wiis we tule tikajulgus weob mellemai. Tegin Jesús tule-yeedzhe ekichial chogal: —¿Pe nugubi? ");
INSERT INTO kvnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tegin tule-yeed Jesúsga chogal: —Tummad, teobdo. Tenal an tule-kwen-nikchul an-chedgal, ti-mumurmanonikoedgin obgal. Tenal an alamanain obnegal, tenal tule-pid an-iktusda antu obgal. Al an keg nugu. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tegin Jesús tule-yeedga chogalbal: —¿Teobí? Tegil imisgin an pega chog: pe kwisgu, tegin pe-kachi aga pe olmako, tegin pe nanao. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tegidgin tule-yeed ilagwen nugunonijun. Tegin tule-yeed aga kachi olmas. Tegin tule-yeed kannamadi-kualzhun. Tenal teun ulukued-ibe nai. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Al Judiomal tule-nugujadga chogalmal: —Imi pe wichulzhí imis ulukued-ibe nai. ¿Ibiga pe olmakal kachi cheinatap-wede? Wedin izhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tegin tule-nugujad Judiomalga chogal: —Imi tule-an-nudajad anka chogzhado: ‘Nanao.’ Tegin anka chogzhabaldo: ‘Aga pe kachi chedo.’ Al an kachi cheinatapto. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tegin Judiomal tule-nugujadzhe ekichial: —¿Toa-tule pega chogzha-ade: ‘Pe nanao, aga pe kachi chedo?’ ");
INSERT INTO kvnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tenal tule-nugujad wichuldo, toa-tule e-nudas. Tenal Jesús tule-nudasgu, tule-ichejulidbal Jesús tule-nugujadgin oweles. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tegin Jesús tule-nudajad-cholbal untaradgin Jesús Pab-Tummadzhe-koled-neggin tule-nugujad-abingunonibal. Tegin Jesús tule-nugujadga chogal: —Imi pe takto, pedin nugus. Tenal pe imis-akar iskuedgin melle pal nanao, pega pul melle poni-tummad nononigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tegin tule-nugujad Judiomalzhe nad, aga chognad Jesús e-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Imi Jesús ulukued-ibegin tule-nudas-choggu, al Judiomal chabzhul Jesús-imabi-kualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tegin Jesús Judiomalga chogal: —Imi an-Pab pane-pane arpanai-choggu, al an pane-pane arpamo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tenal Jesús chogzhadbal ede Pab Tummadyob pane-pane arpanai, wedin chogle Pab Tummad Jesús-e-pab, tegin wedin choglebal Jesús Pab Tummadbak aga-a-yopí tule-tummadga maimo. Al Judiomal pul-pule Jesús-mesbi-kualmalzhun. Tenal Jesús ulukued-ibegin kwen ataszhulidbal, Judiomal Jesús-mesbi-kualmalbalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tegin Jesús Judiomalga chogalbal: “Imi an chunchunnad pemalga chogdo: imi Pab-Machi aga e-itolegedbal keg immal ima. Tenal Pab-Machi e-Pab-takel immal ima, ampa teopí Pab-Machi immal imamo. Tenal Pab Tummad meke-ibi-immalagin immal ima, e-Machi ampa teopí immal imamo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“¿Ibiga teob? Imi Pab pela-pela aga e-Machi-pilal-choggu, al e-Pab pel-kwapa e-immal-imaked oyomo. Tenal Pab kujal e-Machiga pul-pule immal oyogo, pemal keger takegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tenal Pab kannan tule-purkwalmalad-otulo-choggu, al e-Machi ampa e-Pab-yopí e-itolegedbal tule-purkwalmalad-otulomo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Teginbal, Pab Tummad tulega igal-kwen-itogojul-kuo. Tenal Pab e-Machiga igal-ukcha, tulemalga igal-itogal, tulemal piaje sapejul oturdaleged-wilubmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tenal Pab e-Machiga weob igal-ukcha, tulemalde e-Machigin atamalgal, tulemal-pel-kwapa e-Pabgin atagedyobmo. Tenal tule Pab-Machigin kwen atajulil, Pab-machi-palmialidbal ampa Pabgin kwen atajulmalmo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tegin Jesús chogalbal: “Imi an chunchunnad pemalga chogdo: meke-ibi-tule an-chunmajadgin ibzhajal, tegin Pab-an-palmialid-penguszhulil, we tule ilagwen-nadgu tullego, tegin we tule Pab Tummadzhe sapejul kwen oturdalegojulbal. Tenal tule Pabgin ibzhejal, tule-purkwed-igal-akar nos, tegin tule-ilagwen-nadgu-tulleged-igalgin tognonibal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Tenal an chunchunnad pemalga chogbaldo: tenal ibe noniko, tenal imi ibe pato naigunoni, tule-purpal-purkwalmalad mag itononiko Pab-Machi ibi chogzhad. Tenal tule-Pab-Machi-chogzhad-nued-itosmalad purpal tullenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“Tenal Pab kusgu aga e-otuloged cheitii-choggu, al Pab aga e-Machiga igal-ukchamo, kusgu aga e-otuloged cheigalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tenal Pab-Machi, Te-Tule-Chunna-choggu, al Pab e-Machiga igal-ukchabal tulemalga igal-itogal tulemal piaje sapejul oturdaleged-wilubmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Imi pemal melle an-chogzhadgin weob pakal peimalo. Tenal ibe nonikodo, tulemal-pel-kwapa-purkwismalad-uan-yabal-mamimalad Pab-Machi-chunmaked itomalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tenal te ibegin, tule-purkwismalad uan-akar kwisgunonimalo. Tenal tule-nued-nanasmalad ilagwen-nadgu tullego, tenal tule-istar-nanasmalad ilagwen oturdaleged-neggin sapejul oturdalego.” ");
INSERT INTO kvnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tegin Jesús Judiomalga chogalbal: “Imi antin, an-itolegedbal keg walgwen immal ima, tenal Pab-anka-chogzhadbal an tulega igal-ito. Tenal antin tulemalga nuekwa igal-itogo piaje sapejul oturdaleged-wilubmal. Tenal an peiedyob an kwen nanejul, Pab-an-palmialid peiedyob, an nane. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Tenal an naga walgwen chunmakelen, an chunmakeddin ib-nuedga kwen kunonikojulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tenal imidin tule-pid ankin yer chunmadii. Wedin Juan Bautista. Tenal antin wisdo, we tule-ankin-chunmadiid, ib-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Imi pemal Juan Bautistaje tulemal-palminonimal. Tenal Juan pemalga napírra chogzhado, antin a-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tenal Pab Tummad ankin chunmajadbal, tegin an immal-taktijulmalad imajadbal, al an tule-kwen-napijul ankin chunmagal antin toa-tule. Tenal Pab-sapejul-tulemal-oturdakoed-akar pemal nabir abonolegal. Al Juan-ankin-chunmajadbal, an pemalga chognonimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Imi Juan Pab-wisgugal tulemal-oturdadi-kus, achachar-tummad kanaidgin neg-otarmanaidyob. Tenal pemal yabli ichéjal yer Juan-chogzhad wis itosmal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tegin Jesús Judiomalga chogalbal: “Tenal antin, an-immal-imanaidbal Juan-ankin-chogdi-kujadga, pul-pule pemalga oyonai, antin toa-tule. Tenal Pab-anka-arpaged-ukchadbal, tegin an-Pabga-immal-imanaidbal, an oyonaido, Pab an-palmial. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tenal Pab-an-palmialid aga tukin ankin chunmadi-kus antin a-tule. Tenal pemal Pab-chunmaked-kwen-itoszhulmal, tegin pemal Pab-pel-takchajulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","“Tenal pemal kwen ibzhaszhulmal-choggu Pab an-palmial, al Pab-pemalga-chogzhaddin pemal-ulubgin kwen peszhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Tenal pemal ebinzhemal, Pab-kartagin-turdanaidbal pemal wisgune, pe igi ilagwen-nadgu tullegal. Al pemal pela-pela Pab-kartagin turdananimal. Tenal pemal nabir turdananimalando, tenal Pab-karta ankin chunmanai. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tenal pemal yabli anche yapa tagmal ilagwen-nadgu tullegal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tegin Jesús Judiomalga chogalbal: “Imi antin, an tule-an-nug-otummomalad-kwen-abingenai-chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tenal an pemal-wismal, pemal ulubgin Pab-kwen-pilalzhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tenal antin, an-Pab-nuggin nonido, tenal pemal an-kwen-abingaszhulmal. Tenal tule kujal aga tukin tanikil, pemal we tule-abingemalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Tenal pemal aga emal-emal aminanimal aga nug otummogal. Tenal pemal Pab-Tummad-walkwénnagwad-kwen-aminanijulmal pe-nug-otummogal. ¿Tede pemalde, igi ankin ibzhenonimalo-wede? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tenal pemal ankin kwen ibzhaszhulmal-choggu, al pe melle ankin pinzhemalo, an Pabga pemal-tuktinemal. Tenal pe Moisés-igalgin-pe-ibzheedbal, pe chogmal: ‘Imi anmal keg-chulgu Pab-negzhe tognemal.’ Tenal pemal-nuekwa-nanaszhulidbal Moisés Pab Tummadga pemal-tuktimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","“Tenal pemal Moisés-penzhul-kujalen, pemal ampa ankin penzhul-kunonimalmogan. ¿Ibiga an teob pemalga chog? Imi Moisés pél ankin nermas. ");
INSERT INTO kvnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tenal pe Moisés-nermajadbal, pe pengus-choggu, ¿tede pe igi an-chogzhiidgin ibzhenonimalmogo? Keg kue. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tegin Jesús chunmajad-cholbal untaradgin nad, Galilea-mata-opakal. Tenal we mata nugbal, Tiberias-mata. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Teun takalgu, tulemal takchamal Jesús tule-yemalad-nudas, al Jesús-immal-taktijulmalad-imajadbal tulemal-ichejul Jesúsbak irmadmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tegin Jesús aga e-chapinganbak yalzhe nadmal. Tegin Jesús aga e-chapinganbak yal-abaladzhe nonimalgu, yal-abal ampagunonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tenal teun Judiomalga Pab-Najad-Itoged-e-wilub pato omodani-choggu, al tulemal-ichejul irmanonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tegin Jesús panna atadgu, takal tulemal-ichejul e-chiidzhe irmadanimal. Tegin tulemal nonimalgu, Jesús Felipega chogal: —¿Anmal pia tulemalga mas-kunned paknemalo-wede, tulemal-okunkal? ");
INSERT INTO kvnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Tenal Jesús pinche Felipega weob chogzha Felipe-wilub-takegal, Felipede igi chogdago-dewa. Tenal Jesús pato wiis, ede igi tulemal-okunno masgin.) ");
INSERT INTO kvnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tegin Felipe Jesúsga chogal: —Ante wichí. Imi tule ni-walapábak arpanailen, we mani-kanaid ampa kwen unnijulin we tulemalga mas-kunned pakegal. Tenal we mas-kunned, ampa iché-iché tulemal-wis-okunmaloen. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tegin Jesús-e-chapin-pid-Andrés-nugad, Simón-Pedro-e-urpa, Jesúsga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Imi machi-toto-walgwen wegin madu-olgana-cebadagad-kwaatal wis nika, tegin ua-purwigana-ukabo-nikbal. ¿Tenal immal-ichegwaddé ibiga nabir-wede, tule-ichejul-pukwadga? We mas-kunned aku pel-kwapa tulemal-okunkal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tegin Jesús chogal: —Tenal ankadin iwen-kwen-akalzhul madu-kwaatal. Tenal antin, an pei, pemal tulemalga chognao: ‘Pe wis ampagumalo.’ Tenal teun we neggin kagan ichejul nai. Tegin Jesús-e-chapingan Jesús-chogzhadyob imasmal. Imi teun takalgu, machergan-ampagusmaladbi, miliatalzhal. Tenal omegan, tegin nuskan pel choglejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tegin Jesús kwaatal-madu-olgana tegin ua-chus. Tegin Jesús Pab Tummadga tog-nuedi chogzhagu, madu, ua Jesúsga melgudzhun. Tegin Jesús aga e-chapinganga madu-ukcha. Tegin Jesús-e-chapingan tule-ampagusmaladga madu-mimiszhun, tulemal kunpiedyob. Tegin Jesús-e-chapingan ampa teopí ua-ukabogid-imasmo, tulemal e-kunpiedbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tegin tulemal pel-kwapa immedzhe mas kuchamalgu, Jesús aga e-chapinganga chogal: —Imi pemal mas-okpitchad weimalo, melle pinche perienzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tegin Jesús-e-chapingan tulemal-kwaatal-madu-kuchamalad-okpitchad wesmalgu, ampa karpa-kwaambe-kakabog okpis. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tegin tulemal takchagu Jesús mas-kunnedgin immal-taktijulid imas, chogalmal: —We tule, Pab-kaka-palchoged-chunchunnad. Wedin Pab-chogzhad-iti-napche-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tegin Jesús mag takchagu tulemal pinzhebukmal kantikidgin erreyga e-odonemal, Jesús aka-ulak yalaganbal walgwen nadbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tegin tad-arkwatku, Jesús-e-chapingan mata-kakche ul-naidzhe aktenonimal ");
INSERT INTO kvnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tegin kep ulgin aknakwismalzhun. Tegin Jesús-e-chapingan nadmalzhun mata-opakal, Capernaumzhik. Tegin neg-chichilegalgu, Jesús ampa yalaganbal kudiid, ampa kwen taklejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Imi teun Jesús-e-chapinganga sapejul purwa kolnonigu, pela-pela mata arwialzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tegin Jesús-e-chapingan kilómetro-atal o nerkwa-dewa kammegin-nanajadbal Jesús-takalmal e-ulzhe tani. Tenal Jesús ti-askin kannamadani. Tenal e-chapingan Jesúsgin kwakialmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tegin Jesús ulzhe nonigu, aga e-chapinganga chogal: —Melle pe tobgumalma; antin, an Jesúsde. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tegin e-chapingan Jesúsga chogalmal: —Tegil pe akalzhul ulgin nakwedo. Tegin Jesús ulgin nakwisgu, pato itogalmal, neg-kwebur-natapidzhe ul-naigumaladgin pato nai. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tegin te pangin, tulemal-opakal-mas-kuchamalad wisgusmal sae ul-walkwénna nai, tenal Jesús ulgin kwen nakwiszhul. Tenal Jesús-e-chapinganbi nadmal. Tenal tulemal kwen wichulmal Jesúsde pia nad. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tegin ulmal-neg-kwebur-Tiberias-akar-nonimalad Jesús-Pabga-nuedi-chogzhadgin-tulemal-okuchad-omopen naigunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tegin tulemal takchagu Jesús taklejul, tegin Jesús-e-chapingan taklejulmo, tulemal-sae-mas-kuchamalad ulmal-nonimaladgin aknakwismal. Tegin tulemal Capernaumzhe Jesús-aminadmalzhun, Jesúsde Capernaumgin mai-dewa o chul-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tegin tulemal mata opasmalgu, we neg-kweburgin Jesús-onosmal Jesús mai. Tegin tulemal Jesúszhe ekichialmal: —Tule-oturdaked, ¿inkwa pe noni-wede, itije? ");
INSERT INTO kvnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tegin Jesús tule-nonimaladga chogal: “¿Ibiga pe an-aminanimal-ade? Imi an chunchunnad pemalga chogdo: imi pemal pela-pela immedzhe mas-kuchadbal pe an-amidanimal. Tenal pemal immal-taktijulid-takchadbal pe an-kwen-amidanijulmal ankin ibzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Tenal an pemalga chogdo: pe melle pinche iti-napkined-mas-kunned-onoedgin, pe arpamalo. Tenal pe tule-ilagwen-otuloged-mas-kunned-onoedgin, pe arpamalo. Tenal an-Te-Tule-Chunna pemalga tegiid-mas-kunned uko. Tenal Pab Tummad ankin chogzhado, ede yer an-tak.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tegin tulemal Jesúszhe ekichialmal: —¿Tegil anmal igi imakenabzhun, Pabga immal imagal? ");
INSERT INTO kvnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tegin Jesús tulemalga chogal: —Nabir. Imi pemal Pabga immal imabiel, pe penzhulinabmal Pab Tummad an-palmial. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tegin tulemal Jesúszhe ekichialmalbal: —¿Tegil pe ibi immal-taktijulid pe anmalga imako oyogal, pedin ibi-tule? Tenal anmal immal-taktijulid takalil, anmal kep pegin ibzhenonimalo. ¿Tede pe ibi anmalga imakojun? ");
INSERT INTO kvnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tenal anmal-tadgan neg-nikchulidbal maná-mas kuchamal. Tenal Pab-kartagin nermakal maimodo: Teun ad Pab-neg-akar tadganga mas-kunned ukcha, kunkal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tegin Jesús tulemalga chogalzhun: —Imi an chunchunnad pemalga chogdo: imi Moisés Pab-neg-akar, pe-tadganga maná-mas kwen ukchajul. Tenal Pab Tummad pe-tadganga maná-mas ukchamal. Tenal imidin an-Pab nikpa-akar pemalga purpal mas-chunchunnad ukmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tenal Pab-akar-mas-tanikid, wedin tule, wedin mas-chunnad-chul. Tenal we tuledin Pab-neg-akar tani. Tegin we tule ilagwen-nadgu-tullegal tule-iti-napkin-pukmalad-imada. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tegin tulemal Jesúsga chogalmal: —Tummad, tegil pe imis-akar anmalga we madu ukodo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tegin Jesús tulemalga chogalbal: “Imi antin purpal madu-tule-otuloged. Tenal tule anche nonikil anpal-naigugal, ukul pal kwen itogojul. Tenal tule ankin ibzhajal, ukul-ukul pal kwen itogojulbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Tenal antin pemalga chogzhado: pemal an-takchamal, tenal pemal yabli ankin kwen ibzhaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tenal tule-Pab-anka-ukchamalad pel-kwapa anche nonimalo anpal-naigumalgal. Tenal antin tulemal-anka-uklesmalad-ilgwen-abingene, an pal-kwen-onogojul. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Tenal antin Pab-neg-akar aktenoni, Pab-an-palmialid-itolegedbal immal imagal, an naga itolegedbal immal imagal-chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tenal Pab-an-palmialid peigujii, an nuekwa ega pel-kwapa tule-anka-uklesmalad-tako melle walgwen-pel periengugal. Tegin Pab-Tummad-peigujibal neg-tuku omojal, antin tulemal-anka-uklesmalad-otulobalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Tenal an-Pab peigujibal, meke-ibi-tule e-Machi-takalil, tegin e-Machigin ibzhajal, we tule ilagwen-nadgu tullego. Tegin neg-tuku omojal, an purkwaled-akar kannan we tule-otulobalo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tegin Judiomal Jesús-chunmajad itosmalgu ede madu-Pab-neg-akar-tanikidyobid, Judiomal aga emal-emal istar-itogedgin Jesúsgin ulualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tegin Judiomal chogalmal: —¿We Jesúsde, José-machijulzhí? ¿Imi e-pab tegin e-nan, anmal mag takmalzhulzhí? ¿Tede anmalga igi chogne: ‘An Pab-neg-akar-aktenoni?’ Chulá. Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tegin Jesús Judiomalga chogal: “Pemal melle aga emal-emal ankin istar chunmamalma. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Imi an-Pab-an-palmialid yer-ito tule-kwen-imajulil anche taggal, we tule anche kwen nonikojul. Tenal tule keg walgwen aga tukin anche tag. Tenal tule-anche-nonikid neg-tuku omojal, an kannan we tule-otulogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tenal akpene Pab-kaka-palchoged Pab-kartagin chogzhado: Tenal Pab Tummad e-igalgin pel-kwapa tulemal-oturdako. Is. 54:13 Tenal tulemal-pel-kwapa yer Pab-itojal, tegin Pabgin turdajal, we tulemal anche nonimalo anpal-naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Imi tule kwen nikchul Pab-takchad. Tenal tule-Pab-akar-tanikidbi unnila Pab-takcha. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tenal an chunchunnad pemalga chogdo: imi tule an-kwen-penguszhulil, we tule ilagwen-nadgu pato tula. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Tenal antin purpal madu-tule-otuloged. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tenal pe-tadgan neg-nikchulidbal mas-kunned-maná kuchamal. Tenal pe-tadganga we mas-kunned yabli kwen unniguszhulmal, pe-tadgan yabli purkwismal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Imi an pemalga madu-Pab-neg-akar-aktejadgin chunmanaimodo. Tenal tule we madu kuchal, ilagwen-nadgu tullego, pal kwen purkojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Tenal antin purpal we madu-tule-otuloged. Tegin antin madu-Pab-neg-akar-tanikid. Tenal tule we madu kuchal, ilagwen-nadgu tullego. Tenal we madudin an-chan. Tenal antin pel-kwapa tule-iti-napkin-pukmaladga an-chan uko tullemalgal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tegin Judiomal aga emal-emal pela-pela imakalmal chogalmal: —¿Imi we tulede igi anmalga aga e-chan ukne-ade, anmal kunmalgal? Wedin kakanma. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tegin Jesús Judiomalga chogalzhun: “Imi an chunchunnad pemalga chogdo: imi an-Te-Tule-Chunna-e-chan pe kwen kunchulil, tegin pe an-abe kwen kobzhulbalil, pedin tulajul, pedin tule-purkwal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","“Tenal meke-ibi-tule an-chan kuchal, tegin an-abe kobzhalbalil, we tule ilagwen-nadgu tullego. Tegin neg-tuku omojal, an purkwaled-akar kannan we tule-otulobalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","¿Ibiga an teob chog? Imi an-chan mas-kunned-chunchunnad, tegin an-abe kobed-chunchunnadbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tenal meke-ibi-tule an-chan kuchal, tegin an-abe kobzhabalil, we tule ilagwen ankin mai, tegin antin we tulegin ilagwen maimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tenal Pab-tulad an-palmial, tegin an Pabbal tula-tibal. Tenal tule an-chogzhadyob an-chan-kuntimogal, we tule ampa anpal tula-timogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tenal antin madu-chunnad Pab-neg-akar-aktenonikid, tule-akpene-mas-kunned-maná kuchadyob-chul. Tenal anmal-tadgan neg-nikchulidbal mas-kunned-maná kuchamal, tenal anmal-tadgan yabli purkwismal. Tenal tule iti-madu kuchal, ilagwen-nadgu tullego. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tenal Jesús Capernaumgin, Judio-ormaked-neggin, tulemal-oturdanaidgin weob chunmasdo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tegin Jesús-e-chapingan-ichejul Jesús-ega-chogzhad itosmalgu, chogalmal: —Peyedzheá. ¿Toa we igal abingao? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tenal Jesús wiis-choggu e-chapingan e-nik istar chunmakalmal, al Jesús aga e-chapinganga chogal: “¿Imi pemal ebinzhemal, an pemalga immal-chogzhad, pemalga ib-nuedzhul? Chulá. Wedin pemalga ib-nueddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Tenal pe takalil an-Te-Tule-Chunna an-akpene-maigujadzhe kannan nakwenatap, Pab-Tummad-negzhe. ¿Pe igi kujal, pe ebinzhe? Tenal pemalga tegí ib kunonikil, pemal pul-pule istar an-taknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Imi Pab Purpa Nued tule-otuloda. Tenal tule-chan ibga keg pel ku. Tenal an-chunmajad ib-purpaled, wedin tule-otuloged. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tenal pemal-wal-walgwen yabli an-chunmajadgin kwen ibzhejulmal.” Tenal Jesús kepe-sagla-akar wiis-choggu toa-tulemal egin kwen ibzhaojulmal tegin toa-tule egin akpinnonibalo, ");
INSERT INTO kvnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","al Jesús chogalbal: “Imi an pemalga chogzhundo: tule keg a-itoleged anche tagmal anpal-naigugal. Tenal Pab nabir-ito tule-imajal, we tule kep anche noniko anpal-naigugal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tenal teun-akar Jesús-e-chapingan-ichejul Jesús-midmal. Tegin tulemal Jesúsbak pal kwen nanaszhulmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Al Jesús e-walambe-kakabogwadga chogalzhun: —¿Imi pemal nebimalmodé, we chapingan-pimaladyobmo? ");
INSERT INTO kvnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tegin Simón-Pedro Jesúsga chogal: —Tummad, ¿anmal toaje pal nemalo-ade? Imi pedin, pe chunmakedbal anmal-oturdanai, anmal igi nabir ilagwen-nadgu tullegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tenal anmal pegin ibzhemal. Tegin anmal wismalbal, pedin tule-chwilidikid, tule-iskued-kwen-nikchulid, tule-Pab-Tummad-akar-tanikid. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tegin Jesús aga e-chapinganga chogal: —Teobdo. Antin a-tuledo. ¿Imi antin naga tukin pemal-walambe-kakabogwad-chuszhulzhí? Tenal pemal-walgwen yabli nia. ");
INSERT INTO kvnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tenal teun Jesús Simón-machi-Judas-Iscariotegin chunmas. Tenal we Judas, walambe-kakabogwadmogando, tenal Judas te-cholbal manibal-Jesúsgin-akpinnonikoed. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tegin Jesús-chunmajad-cholbal, Jesús Provincia-Galileagin pipirmadiidbal, Provincia-Judeaje pal kwen nebijul-kual. Imi teun Judeagin Judio-tummagan kuakwa pukwamal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tenal teun Judiomalga Chapi-Aangad-E-Itoged omodani. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Al Jesús-e-urpamal yami Jesúsga chogalmal: —¿Imi pedin iti-akar need-wilubzhulzhí, Provincia-Judeaje? Tenal pe-chapingan pe-takenabmal, pede igi immal-taktijulid ima. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tenal meke-ibi-tule aga oyobiel ede toa-tule, otukal immal imaked-wilubzhul. Tenal we tule pel-kwapa-tulemal-wagin immal imakenab. Tenal pe immal-taktijulmalad imakel, pel-kwapa tule-iti-napkin-pukmaladga oyogenabbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Imi teun takalgu, Jesús-e-urpamal Jesúsgin kwen ibzhejulmal Jesúsde Pab-akar tani. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Al Jesús aga e-urpamalga chogalzhun: “Tenal ankadin ampa ibe kwen omojul Jerusalénzhe negal. Tenal pemalgadin meke-ibi-ibe, ibe-nued Jerusalénzhe negal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tenal tule-iti-napkin-pukmalad istar pemal-kwen-takchulmal. Tenal an-tulemalgin-chogzhadbal we tulemal istar timal, al tulemal-iti-napkin-pukmalad istar an-takmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","“Tenal pemal nadmaldo, Jerusalénzhe ibe itogal. Tenal anka ampa wilub kwen omojul. Al an imis Jerusalénzhe kwen nejul ibe itogal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tenal Jesús pél e-urpamalga chunmasgu, yabli Provincia-Galileagin pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tenal Jesús-e-urpamal ibe-itogedzhe naded-cholbal, Jesús kep te-cholbal itogedzhe nadmojun. Tenal Jesús yakiri nad, tulemalga kwen chogzhajul-kus, ede Jerusalénzhe nemo. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Al Judio-tummagan itogedgin Jesús-abintabukgwadgin chogalmal: —¿Pia nade a-tulede? ¿Ampa owedyé? ");
INSERT INTO kvnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tegin tulemal-yogasalmalad aga emal-emal arpa-arpa Jesúsgin chunmananimal. Kwen choge: “We Jesúsde, tule-nued.” Tenal kwéntin chogmoga: “Chulá. We Jesúsde, tulemal-yardaged.” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tenal tulemal-chunmananimalad Judio-tummagan-tobedbal pakal-pud kwen chunmananijulmal, pinche otukal chunmananimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tegin itoged-naigujad-ibabakegin, Jesús kep Pab-Tummadzhe-koled-negzhe noni. Tegin Jesús Pab-igalbal tulemal-oturdakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tegin Jesús tulemal-oturdanaidgin, Judio-tummagan Jesúsgin weob pakal pesmal, tegin Judio-tummagan chogalmal: —¿We tulede igi pirkin immal wiis-wede, Pab-igalgin tulemal-oturdagal? We tule tummaganzhe nue kwen turdas-chuli. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tegin Jesús Judio-tummaganga chogal: “Imi an tulemal-oturdanaid, an-akar kwen tanijul. Wedin, Pab-an-palmialid-akar tani. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tenal meke-ibi-tule Pab-Tummad-chogedbal nanebiel, kep wisgunoniko, an tulemal-oturdaked, Pab-Tummadgad, o an naga tukin onojad. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Imi tule aga tukin chunmakel, pinche aga tukin nug otummobi. Tenal antin, an tule-an-palmialid-nug okannoel, an napírra-chunmaked-tule, an kakanzheed-tulejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Imi Moisés pemalga igal-mezhiszhulzhí, pe igi naneenabmal? Tenal pemal yabli Moisés-igal-mamikid-pallí kwen nanaszhulmal. Tenal pemal Moisés-igal-mamikid-pallí kwen nanaszhulmal-choggu, ¿tede pemalde ibiga an-mesbimalzhun?” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tenal tule-yogasalmalad Jesúsga chogalmal: —Nia koeles pe-imas. ¿Al pe weob chunmayé? ¿Toa pe-mesbi-ade? Pe kakanma. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tegin Jesús tulemalga chogal: “Tenal an ulukued-ibegin immal-taktijulid-choggwen imajadgin pe weob pakal pesmal. Tenal pemal chogmal, an noal immal imas. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tenal Moisés-pemalga-igal-mezhijadbal, pemal ulukued-ibegin ampa machi-abgan-tuku chikmal. (Tenal tule-abgan-tuku-chiked-igal chunchunnad Moisés-akar tanijul, we igal anmal-tadgan-Abraham-akar tani.) ");
INSERT INTO kvnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Tenal pe melle Moisés-igal-mamikidgin walmagal, pemal chwilidik machi-imagal ulukued-ibegin akalzhul machi-abgan-tuku chikmal. ¿Tede an ulukued-ibegin kwablekwá tule-nudajal, ibiga pe ankin ulualdamalzhun? Tenal pemal ankin urwed-wilubzhulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","“Tenal pe melle yogasal chogo: ‘We tule nos.’ Tenal pemal nuekwá-immal-itojadbal, kep pe we tulegin immal chogo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tegidgin Jerusalénginmalad-wal-walgwen chogalmal: “¿We tulede, tummagan tar-mesbi-kunanimaladzhulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Imi pe takto, we tule, tulemal-ichejul-pukwad-wagin chunmanai, tenal tule-tummagan ib kwen imaszhulmal. ¡Paaa! ¿Igi taklejun? ¿Tegil tule-tummagan pinzhemaldé, we tule chunchunnad Cristo-Pab-akpene-chogzhad-palmidagoed-tule? Antin chog chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Tenal anmal nued wismaldo, we tule pia-akar tani. Tenal Pab-akpene-chogzhad-palmidagoed-tule tanikil, anmal kwen wisguojul pia taniko.” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Al Jesús Pabzhe-koled-neggin ampa tulemal-oturdanaidgin, Jesús arpak sapejul kolal chogal: —Imi pemal an-nued-wismaldo, tegin pemal wismalbal, an piagwad. Tenal an pinche an-itoleged-immal-imagal an kwen nonijul. Tenal Pab-Tummad-an-palmial. Tenal Pab Tummad keg-chulgu ib-chunchunnadgin chunma. Tenal pemal Pab-kwen-wichulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tenal antin, an wisdo Pabdin toa-tule. Tenal an Pab-akar tani, tegin Pab an-palmialbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tenal Judio-tummagan Jesús-chogzhad itosgu, Jesús-kabi-kualmal. Tenal tulemal Jesús-kwen-kaszhul-kus, Jesús kaleged-wilub ampa omojulidbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tenal tulemal-ichejul Jesúsgin ibzhenonimal, tegin tulemal-Jesúsgin-ibzhenonimalad Jesúsgin chogalmal: —Imi we tule Pab-akpene-chogzhad-palmidagoed-chunchunnadil, pel-kwapa immal-taktijulid imaked-wilub. Tenal Jesús pel-kwapa immal-taktijulmalad imanai-choggu, al anmal mag taknonimaldo, we tule chunchunnad Cristo-Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tegin Pariseomal takchagu tulemal arpa-arpa Jesúsgin chunmananimal: “We Jesús, Cristo-Pab-akpene-chogzhad-palmidagoed-tule,” Pariseomal tegin tule-irwal-Pabzhe-kolmalad-e-tummagan chowal-ibgan-palmismal Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tegin Jesús chogalzhun: —Imi antin pemalbak iché-iché napi wis kudii. Tenal an kujal kannan nebal, tule-an-palmialidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tenal pemal an-amialmalal, an-kwen-onogojulmal. Tenal an-megoedgin, pemal kwen togojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tegin Judio-tummagan aga emal-emal ekichialmal: —¿Tegil we tulede, pia néjun, anmal tar-kwen-onogojuliddé? ¿Tegil anmal-Israel-tule-Griegomal-abalgin-pukwamaladzhe nedé? ¿Tegil Pab-igalgin Griegomal-oturdanedé? ");
INSERT INTO kvnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imi we tule-chunmajadde, ibi chogzhun? We tule chogzhado: ‘Imi pemal an-amialmalal, an-kwen-onogojul-kuo.’ Teginbal: ‘Pia an megódin, pemal kwen togojul-kuo.’ Tenal anmal kwen wichulmal we tule pia ne. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Imi ibe-itoged-pul-chunchoged imis-pelguedgin, Jesús kwisgudgu, sapejul kote chogal: “Imi meke-ibi-tule aga ulubgin ampa Pab-napi-itogel, anche tagmalo, an ulubgin yer ne-imako, tule ukul-ukul itogedgin, ti-kobzhadbal yer itononikoedyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Tegin meke-ibi-tule ankin ibzhenonikil, Pab-kartagin-chogzhadyob aga ulubgin pela-pela Pab-Purpa-Nued-nikadbal, ilagwen-nadgu tullego, ti-kammubal ti pela-pela ariomaidyob.” ");
INSERT INTO kvnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tenal Jesús weob chunmajadgin Pab Purpa Nuedgin chunmas. Tenal teun Jesús ampa Pab-Machiyob nug otummolejul-choggu, al tule-pel-kwapa-Jesúsgin-ibzhenonimaladga Pab Purpa Nued ampa kwen ukleszhul. Tenal tulemalga kep kujal Pab Purpa Nued uklenoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tenal tulemal-wal-walgwen Jesús-chunmajad itosgu, chogalmal: —We tule chunchunnad Pab-kaka-palchoged-chunchogeddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tenal tule-pimalad chogmo: —We tule, Cristo-Pab-akpene-chogzhad-palmidagoed. Tenal tule-kwénna-kwénna chogmalmo: —¿Ade-Cristode tule-Galileagined tanikojí? ");
INSERT INTO kvnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Tenal Pab-kartagin chogzhajulzhí, Cristode David-e-wagwa, tegin neg-kwebur-akpene-David-megwijadgin mimmilenoniko, Beléngin? Al we tule Cristojuldo. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Al tulemal Jesús-ulgin aga emal-emal iskudmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tegin tule-wal-walgwen Jesús-kabi-kualmal. Tenal tulemal Jesús-kwen-kaszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tegin chowal-ibgan kannan tule-irwal-Pabzhe-kolmalad-e-tummaganzhe tegin Pariseomalzhe nonimalbal. Tegin tule-tummagan chowal-ibganzhe ekichial: —¿Ibiga pe Jesús-cheinonijulmaldé? ");
INSERT INTO kvnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tegin chowal-ibgan tule-tummaganga chogalmal: —We tuleyob, tule kwen nikchul, yer chunmaked. Al anmal we tule-cheinonijulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tegin tule-tummagan chowal-ibganga chogal: —¿We tule pe-pinzheed kasmoyé? Tenal pemal pinzheed-kaleged-wilubzhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Imi anmal-tummagan-tegin-Pariseomal we tulegin ibzhasmalmoyé? Chulá. We tule anmal-pinzheed-kwen-kaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tenal tulemal-Jesúsbal-naigusmalad Moisés-igal-mamikid kwen wichulmal. Al Pab sapejul we tulemal-oturdanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tegin Pariseo-akpene-Jesúszhe-mutik-arpigujad-Nicodemo, e-pakamaladga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Imi anmalga igal maichulzhí, kepegin tulega igal-itogenabgwel, we tule igi chog-dewa? Tegin pe we tulega pél igal-itojad-cholbal kep pe chogo, we tule immal akalos o chul-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tegin tule-tummagan-pimalad Nicodemoga chogalmal: —¿Tegil pe Galilea-tolmodé? ¿Al pe weob chunmanaimoyé? Tenal pe pél amienab, Pab-kartagin igi chog. Tenal pe Pab-kartagin pél apchojal, kep pe wisgunonikodo, Pab-kaka-palchoged Provincia-Galileagin kwen nonikojul. ");
INSERT INTO kvnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Tegin tule-tummagan Nicodemoga pél chunmasgu, aga negzhe pél nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tegin Jesús Olivo-yalzhe nad. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tegin te pangin neg-oiposgu, Jesús kannan Pabzhe-koled-negzhe nonibal. Tegin tulemal-ichejul Jesúszhe irmanonimal. Tegin Jesús chigwiszhun Pab-igalbal tulemal-oturdagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tegin Jesús tulemal-oturdajiidgin, Moisés-igalgin-tulemal-oturdamalad tegin Pariseomal Jesúszhe ome-cheinonimal. Imi we ome machered-pidbak yosgu-kunai-taklejadbal tulemal we ome-kasmal. Tegin Pariseomal neg-abalgin ome-okwisnonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tegin Pariseomal Jesúsga chogalmal: —Tule-oturdaked, imi anmal we ome-kasmaldo, machered-pidbak yosgu-kunai. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tenal Moisés anmalga igal-mezhisdo, ome-machered-pidbak-yosgu-kunai-taklejal, akwagin sagyeal tar-mejo. ¿Imi pedin, pe igi chogmójun, we ome-mesgal ib-nued o chul? Tenal Jesús ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tenal Pariseomaldin yami Jesús-wilub-taknonimal, Jesús igi ega chogdago-dewa. Tenal Jesús istar chogzhal, we tummagan igal-nika Jesús-kagal. Tegin Pariseomal Jesúsga omegin chunmasgu, Jesús ilgwen tullu-chigwis. Tegin Jesús kogin nap-nermakalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tenal Pariseomal kannan-kannan Jesúszhe ekisnaigualmal, Jesúsde igi ome-imako. Tegin Jesús kannan inniki chignonibalgu, Pariseomalga chogal: —Imi tule-iskued-nikchulid-inzhel we omegin akwa meto. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tegin Jesús kannan tullu-chigwisbalgu, kannan kogin nap-nermakalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tegin tulemal Jesús-chogzhad itosmalgu, tulemal-ome-tuktinanimalad-wal-walgwen aknimai-kual. Kepegin chelegan-inzhel nadmal, tegin te-cholbal machimal-chapingana aknidmalmojun. Tenal Jesús omebak apinni pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tegin Jesús tullu-chiid kannan inniki chigwisgu, omeje ekichialzhun: —Ome, ¿pia naddé, tulemal-pe-tuktinanimaladdé? ¿Pegin kwen chogzhajul-kus, pe sapejul oturdaleged-wilub? ");
INSERT INTO kvnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tegin ome Jesúsga chogal: —Chulá, Tummad. Tegin Jesús omega chogalzhun: —An-pela, an pegin kwen chogojul-kuo, pe sapejul oturdalegenab. Imisgin pe akalzhul pe nejunno. Tenal pe melle iskuedgin pal nanao.) ");
INSERT INTO kvnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tegin Jesús tulemalga chogalbal: —Imi antin tule-iti-napkin-pukmaladga kallen neg-otalonaidyob igal-chunchunnad otalononi, tule igi naneenabmal. Tenal tule anpak kudiil, wisgunoniko tule igi tullenoniko, tule neg-taledgin pel-kwapa mag immal taknonikidyob. Tenal tule neg-chichidgin kudiidyob, we tule immal-kwen-wichulidgin pal kwen nanaojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tegin Pariseomal Jesúsga chogalmalzhun: —Imi pe aga tukin pe chunmajima. Al pe-chogzhad ibga keg pel ku. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tegin Jesús Pariseomalga chogal: “Chulá. Imi an naga tukin chunmajiilen, wedin ampa anka iwen-kwen-akalzhulin. ¿Ibiga an teob chog? Imi antin, an wisdo, an pia-akar tani. Tegin an wisbaldo, an piaje nebal. Tenal pemal an-kwen-wichulmal, an pia-akar tani. Tegin pemal an-kwen-wichulmalbal, an piaje nebal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tenal pemal pinche askin tuleyob pinzhemal. Tenal pe tulegin chogmal: ‘We tule, tule-nued.’ Tegin pemal chogmalbal: ‘We tule, tule-iskana.’ Tenal antin tulegin kwen chogzhul wedin tule-nued o tule-iskana. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Tenal an tulemalgin chogbielen, tule-nued o tule-iskana, wedin anka iwen-kwen-akalzhulin. Tenal antin walgwen immal kwen chogzhul. Tenal Pab-an-palmialid an-chogedyob ampa chogmo-choggu, al an-immal-chogzhad wedin ib-chunchunnaddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Tenal pemal-igal-mamikid chogdo, tule-walbogid immal takchal, tenal yopí chogzhamalal, wedin ib-napírra. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tenal antin naga tukin chunmajii, tegin Pab-an-palmialid ampa an-yopí chunmajimo. Al an-chogzhaddin, ib-chunchunnaddo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tegin Pariseomal Jesúsga chogalmalzhun: —¿Teobí? ¿Imi pia pe-pabdéjun? Tegin Jesús Pariseomalga chogal: —An-pela, pe aku an-takmal, an igi pinzhe. ¿An-Pab pulzhun, pe igi wisguo? Imi pe an-nued-wisguelen, pe an-Pab-wisgumalmogan. Pitogua. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tenal teun Jesús Pabzhe-koled-neggin tule-mani-ukmalad-neg-yabal tulemal-oturdadi-kus. Tenal Jesús ampa e-kaleged-wilub omojul-choggu, al tulemal Jesús-kwen-kaszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tegin Jesús Judio-tummaganga kannan chogalbal: —Imi antin, an ne, tenal pemal an-amialmalal, an-kwen-onogojul-kuo. Tenal pemal aka aga iskuedgin purkwemalo. Tenal an-naoedzhe, pe kwen togojul-kumalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Al Judio-tummagan aga emal-emal ekichialmal: —¿Tegil we tulede, aga tukin mesnedé? ¿Imi anmal naga tukin mesnejulmal-choggu, al we tule chogyé anmal e-naoedzhe kwen togojul-kuo? ");
INSERT INTO kvnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tegin Jesús Judio-tummaganga chogalbal: —Tenal pemal iti-napkinmalad, tenal antin nikpa-neggined. Tenal pemal nikpa-negginmalad-chul, tenal antin iti-napkined-chulmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Al an pemalga chogzhado: ‘Pemal iskued-nikadgin ampa purkwenemal.’ ¿Ibiga an teob chog? Imi an pemalga chogzhiidgin pe ibzhejulil an toa-tule, pemal aka aga iskuedgin purkwenemal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tegin Judio-tummagan Jesúsga chogalmal: —¿Tegil pe toa-tulejun? Tegin Jesús tule-tummaganga chogalzhun: —Imi an kepe-sagla-akar an pemalga chognonido, an a-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tenal pemal-noal-tiidbal, an pemalgin ichejul immal-choged nika. Tenal tule-an-palmialid napírra immal chog. Tenal tule-an-palmialidbal an turdajadbal, an tule-iti-napkin-pukmaladga chunmanoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tenal Judio-tummagan aku itosmal, Jesúsde e-Pabgin chunmadii. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tegin Jesús tule-tummaganga chogalzhun: —Imi pemal nikpa an-Te-Tule-Chunna-onakwijal, kep pe wisgunonimalo, ante toa-tule. Tenal an naga-itoleged, walgwen immal kwen imajul. Tenal an Pabbal-immal-turdajadbal, an chunmadii. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tenal tule-an-palmialid anpak mes kudii. Tenal an-Pab-peiedbal an Pabga keg-chulgu immal ima-choggu, al an-Pab walgwen an-kwen-ebejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tenal Jesús ampa chunmanaidgin, tulemal-ichejul Jesúsgin ibzhenonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tegin Jesús Judio-egin-ibzhenonimaladga chogalzhun: —Imi pemal pane-pane an-chogzhad-pallí kudimalal, pemal anpal-turdamalad-chunchunnadga kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tegin pemal igal-chunchunnad wisgunonimalbalo. Tegin pemal mag itononimalbalo, pe iskuedgin ololgusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tegin Judiomal Jesúsga chogalmal: —Anmal, Abraham-e-wagwagan. Tenal anmal tule-pimaladzhe kwen kalesgudijulmal tule-anmal-kasmalad-peiedyob immal imagal. Tenal pedin chogdo, anmal kalejad-akar kep nonemal. Pe kakanma. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tegin Jesús Judiomalga chogal: —Tenal antin chunchunnad pemalga chogdo: imi tule iskuedgin kudiil, wedin chogledo, we tule iskuedgin kalesgudii. Tenal tule pane-pane iskuedginbi kudii-choggu, al we tule keg iskuedgin no. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Imi tule-pinche-arpaged igal-kwen-nikchul, tule-neg-ibed-e-kwenadga kugal. Tenal tule-neg-ibed-e-machi igal-nika, ilagwen-nadgu neg-ibed-e-kwenadga kugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imi Pab-Machi iskuedgin pe-ololchenonikil, pe chunchunnad ololgunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tenal an wisdo, pemal Abraham-e-wagwagan, tenal pemal an-chogzhad kwen abingejulidbal, pemal yabli an-mesbimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tenal an Pab-waglik-immal-takchadbal, an chunmadido. Tenal pemal, pe-pab-itojadbal immal imamal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tegin Judiomal Jesúsga chogalmal: —Imi an-tad, Abraham. ¿Tede an igi akaldé? Tegin Jesús Judiomalga chogal: —Imi pemal Abraham-e-wagwa-chunchunnadilen, pemal Abraham-immal-imajad-pallí, pe immal imadimogan. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Imidin pemal Abrahamyob immal kwen imaszhulmal. Tenal an Pab-Tummadgin-turdajadbal an pemalga chunchunnad chogzhado. Imi antin tule-nued, tenal pemal yabli igal-aminanimal an-mesgal. Tenal Abraham pemalyob kwen pinzhaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tenal pemal, pe-pab-Satanás istar immal imaked-yopí, pemal tamalmo. Tegin Judiomal Jesúsga chogalmal: —Tenal anmal neg-chichidgined-tulejulmal; anmal-pab-chunchunnad, Pab Tummad. Tenal pe melle anmalgin chogdago, nia-Satanás anmal-pab. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tegin Jesús Judiomalga chogal: “Imi Pab Tummad pemal-pab-chunchunnadilen, pemal pela-pela an-pilalmalan. Imi antin Pab-akar noni, iti-napche. Al an wegin mai. Tenal an naga-itolegedbal kwen nonijul, tenal Pab Tummad an-palminoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imi an-pemalga-chunmajad, ibiga pe mag itojulmal pe ebinzhe? Imi pemal Pab-Tummad-nuskan chul-choggu, al pe aku-itomaldo an-chunmajad. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Tenal nia-sagla pe-pab-choggu, al pe niazhikidmalmo. Tenal nia-sagla igi peídin, pemal teob nanemalmo. Tenal nia-sagla kepe-sagla-akar tule-mes. Tegin nia-sagla keg inniki chunmabal, keg-chulgu kakanzhaal chunmada. Tenal nia-sagla tule-kakanzheed-e-sagla-choggu, al nia-sagla chunmakalil, kusgu e-taedbal kakanzhealda, keg inniki chunmada. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Tenal antin, pemalga inniki chunma-choggu, al pe ankin kwen ibzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Imi pemal-walgwen, toa ankin chogo, an immal akalos? Chulá. ¿Imi an chunchunnad chunmanaidbal, tede ibiga pe keg anpal ibzhemalzhun? Tenal pemal ankin ibzheed-wilubmalan. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Tenal tule-Pab-Tummadzhikiddin, Pab-Tummad-chunmaked mag ito. Tenal pemal Pab-Tummadzhikidzhulmalad-choggu, al pemal Pab-Tummad-chunmaked mag kwen itojulmal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tegin Judiomal Jesúsga chogalmal: —Imi pe anmalgin chogzha-choggu anmal niazhikmalad, al anmal nabir pegin chogzhado, pedin tule-iskana, anmal-Samaritano-tule-takedyob. Tegin anmal nabir pegin chogzhabal pedin nia-nika. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tenal Jesús Judiomalga chogalzhun: —Chulá. Antin, an nia-kwen-nikchul. Tenal antin, an-Pab-nug otummonai. Tenal pemal an-nug izhonanimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tenal antin naga tukin nug-onudanaichul. Tenal tule-pid an-nug-onudanai, tenal we tule nabir chogo, an tule-nued o chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tenal an chunchunnad pemalga chogdo: imi meke-ibi-tule an-chogzhad-pallí tael, we tule purkwed kwen itogojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tegin Judio-tummagan Jesúsga chogalmal: —Imi pe-immal-chogzhadbal anmal nued wismaldo, pedin nia-nika. Imi anmal-tad-Abraham purkwis, tegin Pab-kaka-palchogmalad purkwismalmo. Tenal pedin chog: ‘Tule an-chogzhad-pallí tael, purkwed kwen itogojul-kuo.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tede igijun? ¿Imi pede anmal-tad-Abrahamga pul pe tule-tummadzhí? Imi anmal-tad-Abraham purkwis, tegin Pab-kaka-palchogmalad purkwismalmo. ¿Tegil pe toa-tulejun? ");
INSERT INTO kvnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tegin Jesús Judio-tummaganga chogalbal: “Imi antin, an naga tukin okannoelen, wedin anka ibga keg pel kuoen. Tenal an-Pab an-nug-okanno. Tenal pemal chogmal, an-Pab pemal-Pab-Tummadga mai. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","“Tenal pemal aku Pab-Tummad-takmal. Tenal antin, an naga mag Pab-tak. Imi an chogzhalen an Pab-kwen-wichul, an pemalyob kakanzhenaimogan. Tenal antin, an Pab-Tummad-wisdo. Tegin an Pab-chogzhad-pallí nanegwisbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Teun pe-tad-Abraham weligwal an-itosdo, an tanikoedgin. Tegin Abraham an-tanikoed-takchadbal, aga ulubgin weligwal-itononibal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tegin Judio-tummagan Jesúsga chogalmalzhun: —Imi pe pirka-tulabo-kakaambe pel nikchuli, ¿tede pede Abraham-takchadé? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tegin Jesús Judio-tummaganga chogal: —Imi an chunchunnad pemalga chogdo: Abraham ampayo mimmilegeddu, antin pato tetuel kudii. ");
INSERT INTO kvnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tegin Judio-tummagan Jesús-chogzhad itosmalgu, akwa chualmal, akwagin Jesús-mesgal. Tenal Jesús Pabzhe-koled-neggin aga tukin otukcha. Tegin Jesús te-cholbal Pabzhe-koled-neg-akar nodzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tegin Jesús natapidgin tule-walgwen-takcha, kusgu mimmilejad-akar aku-ata. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tegidgin e-chapingan Jesúszhe ekichialmal: —Tule-oturdaked, ¿we tulede, toa-iskuedbal mimmilejad-akar aku-ata-wede? ¿E-pabganbal o aga tukin? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tegin Jesús aga e-chapinganga chogal: “Chulá. We tule e-iskuedgin aku-kwen-atajul, tegin e-pabgan-iskuedgin pel chulbal. ¿Ibiga we tulega weob kus? Nabir. Imi Pab-Tummad-immal-taktijulid-imaked, we tulebal mag taklenonigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","“¿Ibiga pe wisgubimal-ade, we tule igi kus? Imi tule ampa neg-taledgin e-tummadga arpagenab. Tenal neg-mutikid tanikil, tule mag pal kwen takojul-kuo e-tummadga arpagal. Al an ampayo purkweddu, tegin ampa an igal-nikadgin, anmal Pab-Tummad-an-palmialidga arpagenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tenal an iti-napkin ampa kudiidgin, an tule-iti-napkin-pukmaladga igal-chunchunnad oyonai, tadgwa neg-otalonaidyob.” ");
INSERT INTO kvnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tegin Jesús e-chogzhad-cholbal napkin kwi-akcha, tegin nap-kwibied wes. Tegin Jesús olma-olma nap imas. Tegin Jesús kep tule-aku-ataged-imiagin yan-yan-yan olli imas. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tegin Jesús tule-aku-atagedga chogal: —Imisgin pe naddo, Siloé-ti-tummad-wilagwal-chiidzhe, imia enukkal. (Imi Siloé choglege: Palmilegalid.) Tegin tule-aku-ataged nadzhun Siloé-ti-chiidzhe imia enukkal. Tegin tule aga imia enusgu, kannan akpirisgu, imia mag atanonijun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tegin tule-e-neg-tikalbal-mamimalad tegin tule-mani-ekichi-tar-taktimalad aga emal-emal ekichialmal: —¿We tulede anmal taktijulzhí, mani ekichii? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tegin tule-wal-walgwen chogalmal: —A-tuledo. Tegin tule-pimalad chogmalmo: —Chulá. We-tule ajuli, pinche ayob-taklege. Tegin tule-nabir-atanonikid aga tukin chogal: —Antin, an mani-ekichii-taed-tuledo. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tegin tulemal, tule-nabir-atanonikidga chogalmalzhun: —¿Pe igi nabir atanoni-adé? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tegin tule-nabir-atanonikid tulemalga chogal: —Imi tule-Jesús-nugad napkin kwi-akchagu, olma-olma nap-imas, tegin an-imiagin yan-yan-yan olli-imas. Tegin Jesús anka chogzhado: ‘Pe nad, Siloé-ti-chiidzhe imia enukne.’ Tegin an nadzhun imia enukkal. Tegin an imia enusgu, an nabir atanonijun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tegin tulemal, tule-nabir-atanonikidzhe ekichialmal: —¿Imide tule-pe-nudajadde pia naddé? Tegin tule-nabir-atanonikid tulemalga chogal: —An wichí pia nad. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tegin tulemal Pariseomalzhe tule-nabir-atanonikid-chesmal oyogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Imi teun takalgu, Jesús ulukued-ibegin tule-aku-atagedga imiagin yan-yan-yan olli imas, tegin we tulega nabir imia atanonijun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tegin Pariseomal tule-nabir-atanonikidzhe ekichialmalzhun: —¿Pe igi nabir atanoni-adé? Tegin tule-nabir-atanonikid Pariseomalga palchogalzhun: —Imi tule an-imiagin yan-yan-yan olli imasgu, an tigin imia enus. Tegin an-imia nabir atanonijun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tegin Pariseomal-wal-walgwen chogalmal: —Imi tule-pe-nudajad, Pab-Tummad-akar kwen tanijul. ¿Ibiga an teob chog? Imi we tule ulukued-ibe-igalgin kwen ataszhul. Tenal Pariseomal-pimalad chogalmal: —Chulá. ¿Imi tule-iskued-nikad igi kuneé, weob immal-taktijulid imagal? Keg kue. Imi teun Pariseomal aga yopí kwen chogzhajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tegin Pariseomal kannan tule-nabir-atanonikidzhe ekichialmalbal: —¿Imi tule-pe-imia-nudajadgin, pe igi chogmójun? Tegin tule-imia-nugujad Pariseomalga chogal: —Imi tule-an-imia-nudajad, Pab-kaka-palchoged. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tenal Pariseomal we tulegin kwen ibzhaszhulmal, we tule akpene aku-atage-nad, tenal imisdin mag atanoni. Al Pariseomal tule-nabir-atanonikid-e-pabganzhe kochamal. Tegin e-pabgan nonimalgu, Pariseomal e-pabganzhe ekichialmal chogalmal: ");
INSERT INTO kvnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Imi we, pe-machiyé? Tegin machi-e-pab tule-tummaganga chogal: Eye, an-machido. Tegin Pariseomal ekichialmalbal: —Imi tulemal chogmal, pe-machide kusgu aku-ata mimmiles. ¿Nabir chogmal o chul? ¿Tede ibiga pe-machide nabir imia atanonijun? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tegin machi-e-pabgan Pariseomalga chogalmalzhun: —Imi anmal wismaldo, wedin an-machi, tenal an-machi kusgu aku-ata mimmiles. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tenal anmal wichul, igi nabir imia-atanoni. Tenal an wichulbal, toa-tule an-machiga imia nudas. Tenal an-machi pato chered-choggu, al pe machije ekisdo. Tenal an-machi aga tukin pega chogo, toa e-nudas. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Imi teun Judio-tummagan pato igal-mezhismal, meke-ibi-tule Jesúsgin chogzhal, Jesús, Cristo-Pab-akpene-chogzhad-palmidagoed-tule, we tuledin Judio-ormaked-negzhe-naneed-akar kantikidgin tar-onomalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Al tule-nabir-atanonikid-e-pabgan Judio-tummagan-tobgualmal. Al machi-e-pabgan chogzhamaldo: “An-machi chered-choggu, al an-machije pe immal ekismaldo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tegin Pariseomal kannan tule-nabir-atanonikidzhe kochamalbal. Tegin Pariseomal tule-imia-atanonikidga chogalmal: —Imi pe Pab-wagin chunchunnad anmalga nuekwá chogenab, pe igi nugus. Tenal anmal nued wismaldo, we tule-pe-nudajad, tule-iskana. ¿Tenal pedin, pe igi chogmojun, we tule, tule-nued o tule-iskana? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tegin tule-nabir-atanonikid Pariseomalga chogalzhun: —An wichí ibi-tule, tule-nued o tule-iskana. Tenal an wisdo, an aku atagen, tenal imidin an nabir atanoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tegin Pariseomal tule-nabir-atanonikidzhe ekichialmalbal: —¿Imi tule-pe-nudajad, igi pe-imas? ¿Tegin we tule igi nabir atagal pe-imasbal? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tegin tule-nabir-atanonikid Pariseomalga chogal: —Imi an pemalga pato pellallé chogzha. ¿Pe an-itoszhulzhí, an chunmajaddé? ¿Tede ibiga pe kannan anche ekisdanibal-adé? ¿Tegil pemal e-chapinganga togbimalmodé? ¿Al pe weob chogmoyé? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tegin Pariseomal tule-nabir-atanonikidzhe ulualmal. Tegin Pariseomal tule-imia-atanonikidgin istar todoalmal chogalmal: —Imi pedin we tulebak naigus. Tenal anmaldin, anmal Moisés-igalbal-turdamalad. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tenal anmal wismaldo, Pab Tummad Moisésga chunmas. Tenal anmal we tule-kwen-wichulmal pia-akar tani. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tegin tule-nabir-atanonikid Pariseomalga chogal: “¿Teobí? ¿Igi taklebalzhun? Pemal wichulmalde, we tulede pia-akar tani. Tenal we tule yabli an-imia nudas. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tenal anmal nued wismaldo, Pab Tummad tule-iskana-kwen-itojul, eje koled. Tenal Pab tule-egin-atamalad tegin tule-e-chogzhad-pallí-tamalad ito, eje koled. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“Tenal anmal kwen itodijulmal, tule-mimmilejad-akar-imia-aku-ataged nugus. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","¿Imi we tule Pab-Tummad-akar tanijulilen, chun weob immal imakoen? Keg kue.” ");
INSERT INTO kvnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tegin Pariseomal tule-nabir-atanonikidga chogal: —Tenal pedin iskuedgin mimmiles. ¿Tede pede igi Pab-igalgin anmal-oturdaneé? Keg kue. Tegin Pariseomal Judio-ormaked-negzhe-naneed-akar kantikidgin tule-nabir-atanonikid-onodmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tegin Jesús wisgus Pariseomal kantikidgin Judio-ormaked-negzhe-naneed-akar tule-nabir-atanonikid-onodmal. Tegin Jesús te-cholbal tule-nabir-atanonikid-abingusgu, tule-imia-atanonikidga chogal: —¿Imi pe Te-Tule-Chunnagin ibzhe o chul? ");
INSERT INTO kvnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tegin tule-nabir-atanonikid Jesúsga chogal: —¿Imi Te-Tule-Chunnade toajun? Tummad, imi an pei, pe anka chog, an we tulegin ibzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tegin Jesús tule-nabir-atanonikidga chogal: —Imi pedin akpene we tule-takcha, tegin pe imis we tulebak chunmajibal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tegin tule-nabir-atanonikid Jesúsga chogal: —Tummad, an pegin ibzhedo. Tegin tule Jesús-abir chimtisgu, Pab Tummadyob Jesús-otummoal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tegin Jesús tule-nabir-atanonikidga chogalbal: —Imi antin iti-napche noni, pidzhi-pidzhi tulemal-urpegal, tulemal-purpal-aku-immal-takmalad, mag purpal immal taknonigal. Tegin tulemal-purpal-mag-immal-takmalad, purpal aku immal taknonigalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tegin Pariseomal-Jesúsbak-pukmalad Jesús-chogzhad itosgu, Jesúsga chogalmal: —¿Imi pede ebinzhe anmalde purpal aku immal takmalmo? Pe immal-kwen-wichulidyob anmal-takmalma. ");
INSERT INTO kvnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tegin Jesús Pariseomalga chogal: —Imi pemal chogmalalen: ‘An purpal aku immal tak,’ pemal iskued kwen nikchulmalan. Tenal pemal aga tukin chogmal: ‘Anmal purpal mag immal takmal,’ al pemal ampa iskued nika-nemal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tegin Jesús chogalbal: “Imi an chunchunnad pemalga purpal chogdo: imi tule oveja-kalu-emakal-chiid wanagakpal togzhulil, tegin tule oveja-kalu-emakal-chiid-yankalbal togzhal, wedin tule-iskana, tule-oveja-aturzhedanimalad. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tenal tule oveja-kalu-emakal-chiid wanagakpal togdanikil, we tuledin oveja-e-taked-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Tenal tule-wanagakkin-chiid tule-oveja-taked-chunchunnadga wanagak egao toggal. Tegin ovejamal tule-e-taked-chunnad-kakapurwa mag itomal. Tegin tule-oveja-taked ovejamal-nug-ilbal ovejamalzhe kottago, magadbal onigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Tegin tule-oveja-taked pél ovejamal-onijal, kep ovejamal-iktudo. Tegin ovejamal tule-e-taked-kakapurwa-mag-itogedbal cholbal pél irmadmalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tenal ovejamal tule-pid-kakapurwa aku itomal-choggu, al ovejamal keg tule-pid-cholbal nanemal. Tenal tule-pid ovejamalzhe kolalil, ovejamal akne-akne e-itoleged irmadmalo. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Imi Jesús oveja-taked-igalgin tulemalga chunmasdo, tenal tulemal yabli aku itomal ibi chogle-wede. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tegin Jesús kannan tulemalga chogalbal: “Imi an chunchunnad pemalga chogdo: imi antin oveja-kalu-emakal-chiid-e-wanagakyob kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tenal tule-an-iktual-tulemal-oturdamalgal-nonimalad anyob kwen nonijulmal. Tenal we tulemaldin pinche tule-iskanayob tegin tule-oveja-aturzhemaladyob nonimal. Tenal ovejamal-tule-kwapid-kwen-itodijulidyob, tule-an-iktual-nonimaladbal kwen ibzhaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Imi antin oveja-kalu-emakal-chiid-e-wanagakyob-choggu, al ovejamal wanagakpal togzhal, akalzhul mego, tegin ovejamal akalzhul magadbal nobalo mas-kunned amigal. Tenal meke-ibi-tule anpal Pab Tummadgin naigunonikil, oveja-yopí abonolenonimalo, tegin an we tule-akwenonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Tenal tule-immal-aturzhemaladdin tanimaldo oveja-aturzhegal, oveja-mesgal, tegin oveja-opelogalbal. Tenal tule-an-iktual-tulemal-oturdagal-nonimalad tulemal-opelononimal. Tenal antin nonido, tulemal purpal ukin-ukin tula-tigal, tegin tulemal anpal aga ulubgin pela-pela yer itononigalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Tegin Jesús chogalbal: “Imi antin tule-nuekwá-oveja-akwedyob noni. Tenal ovejamalga poni-tummad noalil, tule-oveja-akwed-nued akalzhul aga oveja-anal purko. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Tenal tule-manigin-oveja-takmaladdin tule-chunchunnad-oveja-takedyob kwen nanejulmal. Tenal ovejamal-emalgadzhul-choggu, al achu-kwegwed kolmadanikil, tule-manigin-oveja-takmalad ilgwen oveja-midmalo. Tegin tule-oveja-takmalad abarmadmalal, achu-kwegwed ovejamal-kanoniko. Tegin ovejamal-pimalad akne-akne abarmadmalzhunno. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","“Imi tulemal maniginbi oveja-takmal-choggu, al ovejadu abarmadmalo. Tenal we tulemalga iwen-akalzhul oveja kullego. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Tenal antin tule-manigin-oveja-takmaladyob kwen nonijul. Tenal antin oveja-akwed-chunchunnadyob noni. Tenal tule-oveja-nued-akwed aga ovejamal-nued-wismal, piti e-ovejamal. Tegin ovejamal aga e-taked-nued-wismalmo. Tenal an oveja-taked-nuedyob an naga chapingan-wismo, tegin an-chapingan ampa an-nued-wismalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","“Tenal tule-oveja-nued-takmaladyob an-Pab an-nued-wismo, tegin antemo ampa an-Pab-nued-wismo. Teginbal, an oveja-akwed-nuedyob an naga chapingan-anal akalzhul purko. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Tenal an oveja-pimalad-nikabal, tenal we kalu-yabalid-chul, aknemalad. Tenal an itije keg-chulgu oveja-aknemalad-cheinoniko. Tenal ovejamal-an-cheinonimaloed mag an-kakapurwa itononimalmogo. Tenal we ovejamal aga pulakwa ampagunonimalo, tegin antin tule-e-akwed-walkwénnagwadga kunoniko.” Tenal Jesús tulegin chunmas, ovejagin kwen chunmaszhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tegin Jesús chogalbal: “¿Imi an-Pab, ibiga an-pilal pe ebinzhe? Imi an-Pab an-wisdo, an naga tukin purkwene, tegin an kannan naga tullenebal. Al an-Pabdin an-pilal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tenal tule an-kwen-mejojul-kuo, an naga tukin purkwene. Tenal an igal-nika naga purkwegal, tegin an igal-nikabal an naga kannan tullegalbal. Tenal an-Pab anka chogzhado, an naga purkweenab, tegin an naga kannan tullegenabbal. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tegin Judiomal Jesús-chunmajad itosgu, kannan aga iskudmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tegin Judiomal pul-melu Jesúsgin chogalmal: —Imi Jesús nia-nika. ¿Ibiga pe Jesús-itomaldé? We tule koegwa. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tenal Judiomal-pimalad chogalmal: —Chulá. Imi tule-nia-nikad weob kwen chunmajul. ¿Pede pe ebinzhe niade tule-aku-ataged-nabir-nudako? Chulá. Keg kue. Tenal Judiomal aka-weob Jesús-ebesmalzhun, Jesúsgin pal kwen chogzhajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tegin ti-nigin, Jerusaléngin Pabzhe-Koled-Neg-Nudajad-Ibe naigunoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Imi teun Jesús Pabzhe-koled-neg-ubeb-Salomón-nugadgin pipirmadii. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tenal teun Judiomal pulal Jesúszhe nonimal, Jesúszhe ekichialmal: —¿Inkwaje pe anka chogne-wede: ‘An Cristo-Pab-akpene-chogzhad-palmidagoed-tule?’ Imi pe Cristol, anmalga pe ilgwen chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tegin Jesús Judiomalga chogal: “Imi antin, an pemalga pato chogzhado an Cristo. Tenal pemal yapa anpal ibzhemal. Tenal antin, an-Pab-nuggin immal-imanaidbal, an pemalga pato oyosbal an Cristo. Tenal pemal yapa anpal ibzhemalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","“Imi tule-oveja-taked ovejamalzhe kolalil, ovejamal egad-chulil, aku tule-oveja-taked-itomal. Tenal pemal ampa teopímo. Imi pemal an-chapingan-chulidbal, pemal anpal kwen ibzhejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Tenal an-chapingan, an-ovejamalyob mag an-itomal. Tenal antin mag an-chapingan-takmalmo, toa-tule. Al an-chapingan anpal naigunonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tenal antin ilagwen-nadgu tullegal an-chapingan-ima, tenal an-chapingan pal kwen purkojulmal. Tenal tulemal ankin an-chapingan-kwen-idirojul-kubalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Imi an-Pab anka chapingan-ukcha. Tenal an-Pab pul-tule-tummad-choggu, al tule an-Pabgin keg an-chapingan-pal-idir. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tenal an-Pab tegin an, anmal walkwénna kumal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tegidgin Judiomal istar Jesús-itogalgu, kannan akwa chualmalbal Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tenal Jesús Judiomalga chogal: —Tenal antin Pab-kannalegedbal pemalga ichejul immal-taktijulmalad-nuegan imas. ¿Tede an ibi-immal-taktijulid-imajadbal pemal akwagin an-mesbi-kualmalzhun? ");
INSERT INTO kvnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tegin Judiomal Jesúsga chogalmal: —Imi pe-immal-nuegan-imajadbal, anmal pe-kwen-mesbijulmal. Tenal pe Pabyob-itogedbal pe Pab Tummadgin walmas. Al anmal akwagin pe-mesbimal. Imi pedin tule, tenal pedin yabli chogzhado: ‘Antin Pab.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tegin Jesús Judiomalga chogal: “Imi an chogzhal: ‘Antin Pab’, wedin iwen-akalzhul. ¿Imi Pab-kartagin nermakal maichulzhí: Antin chogzhado, pemal pab-tummagan? Sal. 82:6 Tenal akpene Pab Tummad purpal tule-wal-walgwenga weob chunmas. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Tenal pemal nued wismaldo, pemal keg Pab-kartagin-nermakal-maid piskemalal. Tenal Pab Tummad we tulemalgin chogzhadbal, we tulemal pab-tummagan, al ankin pul-pule nabir chunmalenoniko an Pabmo. ¿Ibiga an teob chog? ");
INSERT INTO kvnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Imi Pab Tummad pidzhi an-oniris ega arpagal. Al Pab Tummad iti-napche an-palminoni. Imi an Pab-Machiye an chogzhadgin, ¿tede ibiga pemal ankin chogmal an Pab Tummadgin walmas? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Tenal antin, an-Pabyob immal imajulilen, pe melle ankin ibzhemalodo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","“Tenal antin, an-Pabyob immal imakel, tenal pe an-chunmakedgin kwen ibzhejulil, an immal-imajadbal pemal yabli ankin ibzheenabmal. Tenal pe ankin ibzheel, pe wisgunoniko, tegin pe mag itononibalo Pab ankin mai, tegin an Pabgin maimo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tegidgin Judiomal Jesús-chunmas-itosmalgu, Jesús-kabi-kualmal, tenal Jesús-kwen-kaszhul-kusmal. Tenal Jesús ilgwen Judiomalgin wakis. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tegin Jesús kannan Jordán-tiwal-opakal nad, akpene Juan Bautista tigin-tulemal-ognaigujadzhe. Tegin Jesús tebal peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tegin tulemal-íchejul Jesús-taknonimal. Tegin tulemal Jesúsgin chogalmal: —Imi Juan Bautista immal-taktijulid kwen imaszhul. Tenal Juan we tulegin-chunmajad pel-kwapa ib-chunchunnaddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tegin tulemal-ichejul-Jesús-taknonimalad aka Jesúsgin ibzhenonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Imi teun tule-walgwen-Lázaro-nugad yee-pakal mai. We tuledin Betaniagined. Tenal Betania-neg-kweburdin María-tegin-e-ia-Marta e-neg-kweburmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tenal María, Lázaro-yee-pakal-maid-e-pun. Tenal María ampa te-cholbal Jesús-naggin ti-wawad eyogoed, tegin e-saglagin Jesús-nag tinobaloed. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tegin María aga iabak yee-pakal e-yai-Lázaro-takalgu, Jesúszhe tulemal-palmis. Tegin punamal-walbogid tule-palmijogalidga chogalmal: —Imi pe Tummad-Jesús-omojal, Jesúsga pe chogo: ‘María aga e-iabak chogmal: Pede kege-chulgu tago, pe-ai-nued-Lázaro yee-pakal mai.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tegin Jesús e-ai yee-pakal-mai itosgu, chogal: —Tenal we poni ilagwen Lázaro-mesgal-chul. Tenal we poni pinche Pab-Tummad-nug-okannogal. Tegin Pab-Machi we ponibal e-nug okannolenonigalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Imi teun Jesús pirkin Marta tegin e-urpa tegin Lázaro-pilalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tenal Jesús wisgusgu Lázaro yee-pakal mai, apka kwen alzhul, ampa ibbo e-maidgin mai-pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tegin Jesús ibbogin kep aga e-chapinganga chogal: —Kannan nemalma, Provincia-Judeaje. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tegin e-chapingan Jesúsga chogal: —¿Tule-oturdaked, imi Judiomal imichal akwagin pe-mesnemalanzhulzhí? ¿Tede pe kannan nebibaldé? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tegin Jesús aga e-chapinganga chogal: —Teobdo. ¿Tenal ibede, wachilambe-kakabog nikchulzhí? Imi tule neg-ibgin kudiil, iti-napkin pel-kwapa neg-taledbal keg nag-kol. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tenal tule mutik kudiil, neg-chichidbal nag-kolnonida. Tenal an-wilub ampa omojulmo an-kamalgal, al an akalzhul Provincia-Judeaje nao, tule an-kwen-kaojulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tegin Jesús teob chogzhagu, kep aga e-chapinganga chogalbal: —Imi an-ai-Lázaro, pato kabid. Tenal antin Lázaroje neenab, an-ai-Lázaro otagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tegin e-chapingan Jesúsga chogalmal: —Tummad, ¿imi Lázaro kabidedde, pato nugudanijulzhí? ¿Tede ibiga pe nebidé? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tenal Jesús otukal chogzhado, Lázaro pato purkwis. Tenal Jesús-e-chapingan ebinzhemal, Jesús-teob-chogzhadde, pinche Lázarode kabmai. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tegin Jesús kep aga e-chapinganga pakal-pud chogalzhun: —Imi an-ai-Lázaro pato purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tenal an weli-itodo, an Lázaro-abir kudijulidbal, pemal ankin ibzhenonimalgal. Tenal anmal yabli Lázaroje neenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tegin Tomás tegin pimalbalid Tarbo-Mimmilejad Jesús-e-chapingan-pimaladga chogalzhun: —Tegil anmal Jesúsbak nemalmodo, Jesúsbak mes purkwegal. Tegin e-chapingan Jesúsbak nadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tegin Jesús Betaniaje nonigu, pato taknoni Lázaro ibabakegus tigles. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Imi Betania-neg-kwebur Jerusalénzhe, wachi-abal-naneed-wilub-panku. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tegin Judiomal-íchejul Martaje tegin Maríaje nonimal tar-pentagal, Lázaro-purkwijadbal melle twagdar pukib-pinzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tegin Marta tani-Jesús-itosgu, Jesús-abin-nad, Jesús-abintagal. Tenal Maríadin neggin chii-pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tegin Marta Jesús-abingusgu, Jesúsga chogal: —Tummad, imi pe wegin mailen, an-yai kwen purkwiszhulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tenal an wisdo, meke-ibi pe Pab Tummadzhe imis ekichial, Pab pega immal imako. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tegin Jesús Martaga chogal: —Imi pe-yaidin, ampa kannan tullego. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tegin Marta Jesúsga chogal: —Teobdo. Tenal an wisdo, an-yai neg-tukuje tule-purkwismalad-kannan-tullegedzhe, tullemogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tegin Jesús Martaga chogalzhun: —Imi an purkwaled-akar-kannan-tule-otuloged, tegin an ilagwen-nadgu tule-otullegedbal. Tenal tule ankin ibzhajal tegin meke purkwijal, kannan tullego. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tenal tule ampa tuladgin ankin ibzhediil, pal kwen purkojul-kuo. ¿Imi an-pega-chogzhadgin, pe ibzhe? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tegin Marta Jesúsga chogal: —Tummad, an pegin ibzhedo. Tenal an pe-kwen-penzhul, pedin Cristo, Pab-Tummad-Machi. Peed, pe-choglesgujad-iti-napche-tanikoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tegin Marta pél Jesúsga chunmasgu, kannan negzhe nad aga e-urpaje kolnegal. Tegin Marta aga neg omosgu, pidzhi aga e-urpa-ches e-urpabak chunmagal. Tegin Marta Maríaga chogal: —Imi tule-oturdaked noni. Tenal tule-oturdaked webal kwichi-pes. Tenal tummadde chog: ‘Pede tago.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tegin María Marta-chogzhad itosgu, ilgwen nadzhun Jesús-kwichidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tenal teun takalgu, Jesús ampayo Betania-neg-kweburzhe tog, ampa Marta-abingujadgin kwichi. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tenal teun Judiomal-María-neggin-María-pentabukmalad takchagu María kueye-kueye nad, María-cholbal nadmalmo. Tenal Judiomal ebinzhemal Maríade uanzhe ponad. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tegin María Jesús-kwichidzhe omosgu, Jesús-taknoni ampa kwichi. Tegin María Jesús-abir-chimtinoni. Tegin María Jesúsga chogal: —Tummad, imi pe wegin mailen, an-yaidin kwen purkwiszhulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tegin Jesús takchagu María pokwis tegin Judiomal-María-cholbal-tanimalad poalmalmo, al Jesús pela-pela pukib-itononimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tegin Jesús tulemalzhe ekichial: —¿Pia pe Lázaro-tigzhamaldé? Tegin tulemal Jesúsga chogalmal: —Tummad, tegil nemaldo taknegal, pia anmal Lázaro-tigzhamal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tegidgin Jesús poalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tegin Judiomal pokwis Jesús-takchagu, Jesúsgin chogalmal: —Pe tak, pule aga e-ai-pilal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tenal Judiomal-wal-walgwen chogalmal: —¿Imi Jesús-tule-aku-ataged-nudajad ampa unnigusmoganzhulzhí, melle Lázaro purkwegal? ¡Paaa! ¿Igi kuszhun? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tegin Jesús Judiomal-egin-teob-chogzhad itosgu, pul-pule pela-pela pukib-itononibal. Tegin Jesús uanzhe nadzhun. Imi teun tulemal kusgu e-igal-maidbal, akwapir-ya-tummad-yabal tule-tigmal, tegin akwa-tummadgin uan-ya chaktimalbal. Al tulemal akwa-yabal Lázaro-tigzhamalmo. Tegin Jesús Lázaro-tiglejad-nabal kwisgunonigu, chogal: ");
INSERT INTO kvnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Akwa-tummad-chiid, pe onirmaldo. Tegin tule-purkwijad-e-pun-Marta-nugad Jesúsga chogal: —Tummad, ¿ibiga pe akwa onirbidé? An-yai-nugan pato ibabakegus tigles. ¿Pato nun-yapanzhulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tegin Jesús Martaga chogal: —¿Imi an pega chogzhajulzhí, pe ankin ibzheele, pe Pab-Tummad-kannaleged-tako? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tegin tulemal akwa-tummad-uan-ya-edujiid onirismal. Tegin Jesús nikpa atadgu, chogal: —Pabye, tog-nuedi an pega chogye, Lázarogin pe anka immal imanaidbalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tenal an wisdo, pedin keg-chulgu, an peje immal ekisedbal, pe anka immal imakoye. Al an pega weob chogzhaye, tule-itigin-pukmalad ankin ibzhemalgal pedin an-palmialye. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tegin Jesús teob chogzhagu, sapejul kolal, chogal: —¡Lázaro, pe uan-yabal-maid-akar pe noma! ");
INSERT INTO kvnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tegidgin Lázaro-purkwal-maid ya-yabal-akar noalgu, pel-kwapa nono-akar nag-tukuje molgin-ebirmakal nos. Tegin Jesús tulemalga chogal: —Pe Lázarogin mol-ebirmakaled pe epatmalo, a-ito nanegal. Tegin tulemal Jesús-chogzhadyob imasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tegin Judiomal-María-taknonimalad takchagu Jesús kannan Lázaro-otulos, ichejul Jesúsgin ibzhenonimalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tenal Judiomal-wal-walgwen Pariseomalzhe nadmal, Jesúsgin chunmagal Jesúsde igi pel-kwapa immal imajad. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Al tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Pariseomal, tule-tummagan-pimaladzhe kochamal ormagal. Tegin tule-tummagan-wala-tulapá-kakaambegwad pél nonimalgu, chogalmal: —¿Imi anmal igi we tule-imamalo-wede? We tule íchejul immalmal-taktijulmalad imadii. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tenal anmal we tule-kajulmalal, tulemal-pel-kwapa we tulebal ibzhenonimalo. Tenal tulemal we tulebal naigunonimalal, Romano-tummagangin abin-kwisgunonimalo. Al Romano-tummagan anmal-Pabzhe-koled-neg opelononiko, tegin anmal-tule-opelononimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Imi teun te pirkagin, tule-tummad-walgwen-Caifás-nugad tule-irwal-Pabzhe-kolmalad-pul-tummadga mai. Tegin Caifás chogal: —¡Pemal immal kwen wichulmalma! ");
INSERT INTO kvnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Tenal pemal wismalzhulzhí, tule-pel-kwapa melle purkwegal, tule-walgwen pul-akalzhul purko? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tenal Caifás aga e-itoleged teob kwen chogzhajul, tenal Pab-Tummad-itolegedbal chunmas. Imi Caifás te pirkagin tule-irwal-Pabzhe-kolmalad-pul-tummadga mai-choggu, al Caifás iktualeba Jesúsgin-immal-kuoedgin chunmas. Tenal Caifás chogzhado, Jesúsde Judio-tulemalga purko. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tenal Jesús Judiomalgabi kwen purkojul, tenal Pab-nuskan-pel-kwapa iti-napkin akne-akne pukwamaladga purko. Tenal Jesús purkwenonibalo Pab-nuskan-pel-kwapa pulakwa ampagunonimalgal, tegin Jesús tule-choggwénnagwadga Pab-nuskan-imamalgalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Al teun-akar Judio-tummagan igal-aminanimalzhun, Jesús-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tenal Judiomal-Jesús-aminanikidbal, Jesús Judio-neg-kweburmalgin keg pal nanegus. Tegin Jesús wakiszhun neg-nikchulidzhik, neg-kwebur-totoje. Tegin Jesús Efraín-neg-nugadzhe nadzhun. Tegin Jesús aga e-chapinganbak Efraíngin peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tegin Judiomalga Pab-Najad-Itoged omodanigu, tulemal-íchejul Jerusalénzhe irmanonimal. Tenal teun Judiomal iktualeba nonimal, aga chwilidik purpa imamalgal Pab-Najad-Itoged-Ibe itogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tegin tulemal-irmanonimalad Jesús-amialmal, tegin Pabzhe-koled-neg-yabal aga emal-emal Jesús-ekisalmal: —¿Igi pe ebinzhe? ¿We tule iti-itogedzhe nonikojuldé? ");
INSERT INTO kvnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan tegin Pariseomal akpene igal-mezhismal: imi tule wisgujal, Jesúsde pia mai, we tuledin keg-chulgu Judio-tummaganga chogneenab, Judio-tummagan Jesús-kanemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Imi Pab-Najad-Itoged ibanerkwaje kuele, Jesús Betania-neg-kweburzhe noni. Tenal Betaniagin Jesús akpene purkwaled-akar kannan Lázaro-otulojad. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tegin Jesús Betaniaje nonigu, tulemal Jesúsga mas imasmal Jesús-okunkal. Tenal teun Marta tulemalga mas-kunned cheikwis. Tenal Lázarodin Jesúsbak mes mesagin mas kunchimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tegidgin María pude-walgwen ti-wawad-nardo-nugad cheinoni. Tenal we ti-wawad péyedzhe karkegu. Tegin María Jesús-naggin ti-wawad imas, tegin e-chagla-kiagin Jesús-nag-tinosbal. Tenal María Jesúsgin ti-wawad imasgu, pel-kwapa wawadik neg-kas. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Imi teun takalgu, Jesús-e-chapingan-walgwen-Judas-Iscariote-nugad chimo. Tenal we tule kujal manibal-Jesúsgin-akpinnonikoed-tule. Tegin Judas Maríaga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ibiga pe manigin ti-wawad ukchajuldé? Imi pe pirkagwen arpaged-wilub karkegu pe manigin ti-wawad ukchagalan. Tenal pe manigin ti-wawad ukchalen, pe Jesúsga we mani ukoen, anmal tule-wilemalad-pentagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tenal teun Judas Jesúsmalga mani-chaboedga kudii. Tenal Judas kusgu mani-aturzheed-choggu, al Judas tule-wilemalad-pentakedgin kwen pinzhaszhul, pinche aga mani-kaedginbi pinzhedii. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tegin Jesús aga e-chapinganga chogalzhun: —Pe melle weob omegin chunmama. We ome meke-chii. Imi an-yo-purkweddu, we ome anka iktualeba ti-wawad imas. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tenal tule-wilemaladdin keg-chulgu pemal-abalgin kudiguo, pal kwen chulguojul-kuo. Tenal antin pemalbak ilgwen kwen nadguojul, an pemalbak íche wis kudiguo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Imi teun takalgu, Judiomal-ichejul wisgusmal Jesúsde Betaniagin mai. Al Judiomal Jerusalén-akar almal Jesús-takegal. Tenal Judiomal Jesús-takegalbi kwen nonijulmal, tenal Lázaro-kannan-tullejad-takegal nonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tenal tule-irwal-Pabzhe-kolmalad-e-tummagan chogalmal, emalde Lázaro-mejenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","¿Ibiga Judio-tummagan weob chogzhamal pe ebinzhe? Imi teun Lázaro-kannan-tullejadbal Judiomal-ichejul Jesúsbal-naigunonimal, tegin Jesúsgin ibzhenonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tegin te pangin, tulemal-ichéjul-Pab-Najad-Itoged-itononimalad wisgusmal, Jesús Jerusalénzhe tanimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Al tulemal-Jesús-wisgusmalad uga-ka-annik Jesús-abin-nadmal. Tegin tulemal Jesús-abingusmalgu, kep pulal kolmanatapmal, chogalmal: —Jesúsye, pe-nug otummoledi-kuelen, nabirinye. Imi pedin Pab-nuggin-tanikid-tuleye. Tenal pe Israel-erreyga tanikidbal, Pab Tummad pega immal-nuegan imakelen, nabirbalinye. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tegin Jesús moli-burro amiapku, moligin nakwis. Imi akpene Pab-kartagin choglesgujadyob kunoni. Tenal Pab-kartagin chogdo: ");
INSERT INTO kvnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Imi pemal-punamal-Sióngin-pukmalad, pe melle tobgudamalo. Pe tak, pe-errey moli-burro-chapini-askin-chii-tani. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tenal Jesús moli-burro-askin-chiid tanigujadgin, teun e-chapingan aku-itomal, ibi chogle-wede. Tenal Jesús otummolenonigu, e-chapingan kep mag-itononimal, tulemal erreyyob Jesús-otummojad, akpene-akar Pab-kartagin choglesmai. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tegin tulemal-Jesús-takchamalad tule-pimaladga choge-natapmal: “Jesús Lázaroje kochadbal, Lázaro-otulos.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tegin tulemal wisgusmalgu Jesúsde Lázaro-otulos, Jesús-takpi-kualmal. Tenal tulemal wisgusmalgu Jesúsde tani, al tulemal-ichéjul Jesús-abin almal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Al Pariseomal aga emal-emal chogalmalzhun: —Pe tak, anmal-Jesúsgin-igal-mezhijad tar-mesgal, ibga kwen kuszhul-kus. Tenal tulemal-pel-kwapa Jesúszhe irmamamimal, Jesúsbal naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Imi teun takalgu, Pab-Najad-Itoged-Ibe itogal, Judiomal Jerusalénzhe nonimal. Tenal Judiomalbak kwénna-kwénna Griegomal nonimalmo Pab-Tummad-nug-otummogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tegin Griegomal Felipeje nonimal. Tenal Felipedin Provincia-Galileagin, Betsaida-neg-kweburgined. Tegin Griegomal Felipeje nonimalgu, Felipeje wilegal chogalmal: —Tummad, imi anmal Jesúsbak chunmabimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tegin Felipe Griegomalga chogal: —An takkwelo, Jesús pemalbak chunmako-dewa. Tegin Felipe Andrészhe nad, Andrésga choggal. Tegin Andrés kep Felipebak mes Jesúszhe nadzhun Jesúsga choggal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tegin Andrés pél Felipe-ega-chogzhad Jesúsga chogzhagu, Jesús tule-walbogidga chogal: —¿Teobí? Tegin Jesús chogalbal: “Imi an-Te-Tule-Chunnaga wilub pato naigunoni an-nug okannolegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tenal an chunchunnad pemalga chogdo: imi trigo-kwa napche arkwan-chulil, tegin trigo-kwa purkwiszhulbalil, ampa e-kwa kwakwénna peio. Tenal trigo-e-kwa purkwijal, tegin ninonikil, íchejul chanma-nonida. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Tenal anmal-tule ampa teopí tamo. Imi tule aga changin pinzheel, yapa purkwejogel, we tule pelgunoniko. Tenal tule iti-napkin-kudiidbal aga changin nue pinzhejulil, akalzhul purkwejogel, we tule unniguo ilagwen-nadgu tullegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Tenal meke-ibi-tule anka immal imabiel, an-igal-mamikid-pallí naneed-wilub. Al an pia-maídin, we tule anpak kudigumogo. Tenal tule anka immal imanail, an-Pab we tule-otummononiko.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tegin Jesús chogalbal: “Imi antin purkweenab-choggu, ¿an ulubgin chuli-pinzhe-itogedbal an igi Pabga chogenabdé? ¿An chogenabgweldé: ‘Pabye, pe an-wis-pentakelen, nabirinye, we wileged melle anche nonigalye?’ Chulá. Tenal antin iti-napche noni purkwegal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tegin Jesús chogalbal: “Pabye, pe aga nug okannogelen, nabirinye.” Tegidgin tule-kakapurwa nikpa-akar kolnoni chogal: “Imi antin pato naga nug okannos, tegin an kannan naga nug okannonebal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tenal tulemal-aka-pukmalad teob itosgu, wal-walgwen chogalmal: —Wedin, mar-koledi. Tegin tule-pimalad chogalmalmo: —¿Tegil angel Jesúsga chunmasdé? ");
INSERT INTO kvnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tegin Jesús tulemalga chogal: “Imi we kakapurwa-kolnonikid anka kwen chunmanonijul tenal pemalga chunmanoni, pemal ankin ibzhegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Tenal tule-iti-napkin-pukmaladga wilub pato naigunoni, Pab Tummad sapejul tulemal-oturdagal. Tegin nia-Satanás-iti-nap-takmaid-akar onolenonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tenal tulemal nikpa an-nazhismalal, an pel-kwapa tulemal-weine anpal naigugal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Imi Jesús weob chogzhadbal oyonai, ede nakrusgin purkwene. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tenal tulemal Jesús-chogzhad itosmalgu, chogalmal: —Tenal anmal wismaldo, Moisés-igalgin choglesmai, Cristo-Pab-akpene-chogzhad-palmidagoed-tule ilagwen-nadgu tula-tio, kwen purkojul. ¿Tede ibiga pe chogzhun: ‘Te-Tule-Chunna nikpa-naigujadgin purko?’ ¿Tede toajun, Te-Tule-Chunnadé? ");
INSERT INTO kvnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tegin Jesús tulemalga chogalzhun: “Nabirdo. Imi pemalga íche neg-tallé wis nai. Tenal neg-chichid ampayo naigueddu, pe neg-taledgin nanemalo. Tenal tule-neg-chichidgin-nanemalad, wichul pia natap. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","“Tenal pemal ampa neg-taled-naidgin, pe melle pengumalo neg-taledgin nanegal. Tegin pe melle ankin pengumalbalo tule-neg-taledgin-nanemaladbak naigugal. Tenal neg-taleddin choglege, an Jesús.” Tegin Jesús pel-kwapa chunmasgu, nadzhun. Tegin Jesús aga otukchajun tulemal melle e-onogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Imi teun Jesús tulemal-wagin ichejul immal-taktijulmalad imas, tenal tulemal yabli Jesúsgin kwen ibzhaszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tenal tulemal-Jesús-pengujad akpene-Pab-kaka-palchoged-Isaías-chogzhad-yopí kunoni. Tenal teun Isaías chogzhado: ¿Tummad, toa anmal-chognonikidgin ibzhenoni? Tulemal anmalbal pél ibzhenonijulmal. ¿Tegin Pab Tummad toaga e-kannaleged oyononi? Ampa a-tulemalgado. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tenal tulemal Jesúsbal kwen ibzhaszhulmal, akpene Isaías chogzhagujadyob: ");
INSERT INTO kvnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Imi Pab purpal we tulemal-imia akalosmal, melle purpal mag takegal. Tegin Pab purpal we tulemal-niga okannosmal, melle ulubgin Pabgin ibzhegal. Imi Pab chogzhado: “Imi an purpal weob we tulemal-imas, melle e-taed ogwalegal anpal naigugal. Tegin an purpal melle we tulemal-nudagalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","¿Tenal teun ibiga Isaías weob chogzha pe ebinzhe? Imi Isaías sanaledyob Jesús-takcha, otummolenai. Al Isaías Jesúsgin weob chunmanonida. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tenal Judio-tummagan-wal-walgwen yabli Jesúsgin ibzhenonimal. Tenal Judio-tummagan-Jesúsgin-ibzhemalad Pariseo-tobedbal kwen chogzhajulmal emalde Jesúsgin ibzhasmal. Tenal we Judio-tummagan chogzhamalalen, emalde Jesúsbal naigusmal, Judio-tummagan-pimalad kantikidgin Judio-ormaked-neg-akar Judio-tummagan-Jesúsgin-ibzhenonimalad-onodmalan. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","¿Ibiga Judio-tummagan weob imasmal pe ebinzhe? Imi Judio-tummagan-Jesúsgin-ibzhasmalad pul-pule tulemal-aminanimal e-nug-okannogal, pul Pab Tummad e-nug otummoedga. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tegin Jesús sapejul kotegu, chogalbal: “Imi tule ankin ibzhenonikil, ankinbi kwen ibzhenonijul, tenal tule-an-palmialidgin ibzhenonimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tenal tule mag an-takel, mag tule-an-palmialid-takmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","“Imi antin iti-napche kallen-kaedyob noni, tule ankin ibzhajal, we tule wisguo igi naneenab, neg-chichidgin-kudiidyob pal kwen nanaojul. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tenal tule an-chunmaked mag itogel, tenal we tule an-chogzhadyob kwen nanejulil, an kwen chogojul-kuo we tule sapejul oturdaleged-wilub. “Tenal antin iti-napche noni, tule-iti-napkin-pukmalad-abonogal tenal tule-pukmaladgin choggal-chul, we tulemal sapejul oturdaleged-wilubmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Tenal tule an-abingejulil, tegin an-chogzhad kwen abingejulbalil, we tulegin choglenoniko, wedin sapejul oturdalegenab. Tenal neg-tuku omojal, an-nega-chogzhadbal we tule Pab Tummadzhe sapejul oturdalenoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tegin Jesús chogalbal: “Tenal an naga-itolegedbal walgwen kwen chunmajul. Tenal an-Pab-an-palmialid anka chogzhado, an ibigin chunmakenab, tegin e-chogzhadbal an tulemal-oturdakenabbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Al an nued wisdo, Pab-anpal-kaka-palmialid tulemal-ilgwen-nadgu-tullegal. Al meke-ibigin an chunmajal, Pab-anka-chogzhad-yopí an chunmamo. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Teun Pab-Najad-Itoged-Ibe pan-kuele, Jesús pato wiis ega wilubgan noni iti-nap ebegal, nikpa e-Pabbak mes megnegal. Tenal Jesús tule-iti-napkin-ebal-nanimalad-pilalgus. Tenal Jesús pela-pela aga e-chapingan-pilalgus e-purkwijadzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tegin Jesús aga e-chapinganbak chedokí mas kunchiun, nia Simón-machi-Judas-Iscariotegin pato togzha Jesúsgin-akpingal. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tenal Jesús wiis, e-Pab ega igal-ukcha pel-kwapa immal imagal. Tenal Jesús wisbaldo, ede Pab-Tummad-akar noni, tegin ede kannan Pab Tummadzhe nebal. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tegin Jesús mas-kunchiid-akar kwisgudgu, aga chuba echus. Tegin Jesús toalla amiapku, aga muchil-abal toalla etis. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tegin Jesús pardegin ti eyosgu, aga e-chapinganga nag enukalzhun. Tegin Jesús muchilgin-toalla-etilenaidgin aga e-chapinganga nag elisbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tegin Jesús Simón-Pedro-nag-enukchogalgu, Pedro Jesúsga chogal: —¿Tummad, pe anka nag enuknemoyé? ¡Chulá! ");
INSERT INTO kvnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tegin Jesús Pedroga chogal: —Imi an-pega-nag-enuked ampa pe aku-ito an ibi pegin imanai. Tenal pe kujal kep mag itononiko. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tegin Pedro Jesúsga chogalbal: —Tummad, an meke-igi pega igal-kwen-uknejul, pe anka nag enukkal. Tegin Jesús Pedroga chogal: —Imi pe anka igal-kwen-ukchulil an pega nag enukkal, pe anpal-naid-tulejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tegin Simón-Pedro Jesúsga chogalbal: —Tummad, imi pe teob chogel, tegil pe melle an-nagbi enukodo. Tenal an-chunkalzhe tegin an-nonoje-pakal pe anka enuko an pega oyogal, an chunchunnad pebal nai. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tenal Jesús Pedroga chogal: —Imi tule-obzhamalad pato obed-wilubzhulmal. We tulemal pel-kwapa enukal-nemal, e-nagbi enuked-wilubmal. Tenal pemal pato chwilidik-nemal. Tenal pemal-abalgin tule-walgwen ampa iskued nika. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","¿Tenal Jesús, ibiga weob chogzha pe ebinzhe? Imi teun Jesús pato wisdo, toa-tule egin akpinnonikoedde. Al Jesús chognoni: “Pemal-pel-kwapa chwilidik-nejulmal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tegin Jesús aga e-chapinganga pel-kwapa nag enusgu, aga kannan chuba yosbal. Tegin Jesús mesaje kannan chignadbal. Tegin Jesús aga e-chapinganga chogalbal: —¿Imi an pemalga nag enukchad, ibi chogle-wede? Tegin e-chapingan Jesúsga chogal: —Anmalde wichí. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tegin Jesús aga e-chapinganga nuekwa palchogalzhun: “Nabir. Imi pemal anche kolmal: ‘Tummad’ tegin ‘Tule-oturdaked.’ Wedin ib-nued. Antin ádo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Imi antin ‘Tummad,’ tegin antin ‘Tule-oturdaked.’ Tenal antin pemalga yabli nag enusmal tule-pinchegadyob. Tenal an pemalga imis nag-enukchadyob, pemal aga muchub-muchub nag-enukedgin naneenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Tenal an pemalga chagla chis, pemal aga emal-emal pentamalgal, an pemalga imajadyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tenal an chunchunnad pemalga chogdo: imi tule-pinche-arpaged meke-igi e-ibedga pul tule-tummad chul. Teginbal, tule-palmilegalid meke-igi tule-e-palmialidga, pul tule-tummad chulmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","“Tenal an-imis-pemal-oturdajad pemal mag itononikidbal, tegin an-pega-chogzhad-yopí pe nanebi-kualil, Pab Tummad pega immal-nuegan imanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tenal an pemalgin-pel-kwapa chunmajul. Tenal an wisdo, an toamala-chus. ¿Ibiga an weob pemal-chus pe ebinzhe? Nabir. Imi akpene Pab-kartagin nermakal-maidyob kunonigal. Tenal Pab-kartagin chogdo: Imi tule-anpak-mes-mas-kuchamalad-walgwen ankin akpinnoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Tenal an pemalga iktualeba chogdo. Tenal an-pemalga-chogzhiidyob anka kunonikil, pe ankin ibzhenoniko, antin Pab-an-palmialid-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tenal an chunchunnad pemalga chogdo: meke-ibi-tule an-tule-palmialid-abingeel, we tule pato an-abingasmo. Tegin tule an-abingajal, pato Pab-an-palmialid-abingasmo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tegin Jesús pél chunmasgu, aga ulubgin pela-pela nunma-itononi. Tegin Jesús aga e-chapinganga nuekwa palchogalzhun: —Imi an chunchunnad pemalga chogdo: imi pemal-walgwen ankin akpinnoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tegin e-chapingan Jesús-chogzhad itosmalgu, weob pakal pesmal. Tegin Jesús-e-chapingan nue aga emal-emal takalmal, Jesúsde toagin chogzha-dewa. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tenal teun takalgu, Jesús-e-chapin-pul-pilaled-Juan, Jesús-waglika mas kunchii. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Al Simón-Pedro kakagin Juanga wilub imas, Jesúszhe ekisgal, Jesúsde toagin chogzha, egin akpinnoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tegin Juan Jesús-ua-nabal Jesúszhe ekichialzhun: —¿Tummad, pe toagin chogzha-ade, pegin akpinnoniko? ");
INSERT INTO kvnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tegin Jesús Juanga chogalzhun: —Imi an masgin madu wartichajal, tegin an we tulega madu ukchal, a-tule ankin akpinnonikoed. Tegidgin Jesús masgin madu wartichasgu, Simón-machi-Judas-Iscariotega madu-ukcha. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tegin Judas Jesúsgin madu chusgu, nia-Satanás Judasgin tognoni. Tegin Jesús Judasga chogalzhun: —Imi pe immal imaneed, pe kueye imanaddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tenal e-chapingan-Jesúsbak-mes-mesagin-pukmalad aku-itomal, Jesúsde ibiga Judasga weob chogzha: “Pe nao.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tenal teun takalgu, Judas Jesúsmalga mani-chaboedga kudii-choggu, al Jesús-e-chapingan ebinzhasmal, Jesúsde Judasga chogzha, itogedga immal paknegal. O chulil, ebinzhasmalbal, Jesús Judasga chogzha, tule-wilemaladga mani uknegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tegin Judas madu-ka-uklejad kuchagu, ilgwen nod. Tenal teun neg pato mutik. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tegin Judas-naded-cholbal, Jesús aga e-chapingan-pimaladga chogal: “Imi an-Te-Tule-Chunna-nug-okannoleged-wilub pato noni. Tegin an-Te-Tule-Chunnabal, Pab-Tummad-nug-okannolenonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tenal an-Te-Tule-Chunnabal Pab-Tummad-nug-okannolenonikil, Pab Tummad an-Te-Tule-Chunna-nug-okannononimogo. Tenal Pab Tummad imis-imis an-Te-Tule-Chunna-nug-okannogo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tegin Jesús chogalbal: “An-machimal, imi an pemalbak iché napi wis kudii. Tenal an akpene Judiomalga chogzhado: ‘Pemal an-amialmalal, an-kwen-onogojulmal.’ Tenal an Judiomalga-chogzhad-yopí an pemalga chogmodo. Tenal pemal an-amialmalal, an-kwen-onogojulmal. Tegin pemal imis-imis an-togoed-negzhe kwen togojulmalmo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tegin Jesús chogalbal: “Imi antin imis-akar pemalga igal-pin-mesne, pemal aga muchub-muchub pilalgumalo. Tenal an pemal-pilalgujadyob pemal aga muchub-muchub pilalguenabmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","“Tenal pemal aga muchub-muchub pilalgunonimalal, tulemal-pel-kwapa mag pemal-taknonimalo, pemal chunchunnad anpal-turdasmalad-tulemal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tegin Simón-Pedro Jesúszhe ekichial: —¿Tummad, pia pe ne-ade? Tegin Jesús Simón-Pedroga chogal: —Imis an-needzhe, keg anpak pe neel. Tenal kujaldin pe akalzhul an-cholbal nemogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tegin Pedro Jesúsga chogalbal: —¿Tummad, ibiga keg an imis pebak ne-ade? Antin, an kuakwa kudii, pega purkwegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tegin Jesús Pedroga chogal: —¿Pe kuakwa kudií, anka purkwegalá? Chulá. Imi an chunchunnad pega chogdo: ampayo kallin-mastad namakeddu, pedin ilapá ankin chogo: ‘Antin Jesús-kwen-wichul.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tegin Jesús aga e-chapinganga chogalbal: “Imi pemal melle chuli-pinzhe itononimalo. Tenal pemal Pab Tummadginbi ibzhao, tegin pe ankin ibzhemalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Imi an-Pab-neggin neg-íchejul-nika nued meggal. Tenal an neg nikchulilen, an pemalga pato chogzhan an neg kwen nikchul. Imi an pemaldu Pab-negzhe nejogalzhun, pemalga neg nudagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Tenal an pemalga neg nudane-choggu, al pemal pato wismaldo, an pemalga neg nudajal, an kannan pemal-aminonibalo pemal anpak mes negal. Al an pia megódin, pemal tebal anpak mes megmogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tenal pemal pato wismaldo an-neg-megoed pia nai.” ");
INSERT INTO kvnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tegin Tomás Jesúsga chogal: —Tummad, an wichí, pia pe ne. ¿An igi wisguo, pe-maidzhe omogal? ");
INSERT INTO kvnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tegin Jesús Tomásga chogal: —Anid, an pe-chedoed, anpalbi unnila pe Pab-Tummad-maidzhe togmalo. Imi an-chunmaked igal-chunchunnad, tegin an tule-otulogedbal. Tenal tulemal-pel-kwapa anpalbi Pabzhe omomalo, igal-pid pal kwen maichul. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tenal pemal an-wisgujalen an toa-tule, pemal pato wisgunonimogan, an-Pabdin ibi-tule. Tenal pemal imis-akar an-Pab-wisgunonimal, tegin pemal mag an-Pab-takchamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tegin Felipe Jesúsga chogal: —Tummad, tegil pe anmalzhe pe Pab-Tummad-oyodo. Agin anmal kep kus pinzhenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tegin Jesús Felipega chogal: “Felipe, ¿an ínkwagus pemalbak kudii? ¿Tede pe ampa aku an-takdé? Chulá. Tenal meke-ibi-tule mag an-takchal, we tule pato mag Pab-Tummad-takchamo. ¿Tede ibiga pe anka chogde: ‘Pe anka Pab-Tummad-oyo?’ ");
INSERT INTO kvnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Imi pe ibzhejuldé, antin Pabgin mai, tegin Pabdemo ankin maimo? Tenal an-pemalga-chunmaked an-itolegedbal kwen chunmajul, wedin Pab-itolegedbal an chunma. Tenal Pab-ankin-maid anpal e-arpaged ima. Wedin oyolenaibal, Pab Tummad ankin maimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Felipe, pe melle ankin penguma, antin Pabgin mai, tegin Pabdemo ankin maimo. Tenal an-imis-pega-chogzhadbal pe ibzhejulil, tenal an-immal-taktijulid-imajadbal, pe yabli ankin ibzhao. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Tenal an chunchunnad pemalga chogdo: imi tule ankin ibzhajal, an-immal-taktijulid-imakedyob, we tule ampa immal-taktijulid imamogo. Tenal an-Pabzhe-needbal tule-ankin-ibzheed anka pul-pule immal-taktijulmalad imako. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Tenal pemal an-nuggin Pabzhe meke-ibi-immala ekisel, antin pemalga pel-kwapa imako, Pab e-Machibal nug okannolenonigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tenal pe anche immal ekisbiel, pe akalzhul an-nuggin ekiso. Tegin pe anche immal ekised-ilbal, an pemalga immal imako.” ");
INSERT INTO kvnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tegin Jesús chogalbal: “Imi pemal an-pilalmalal, pe an-choged-pallí immal imamalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Tenal an Pabzhe ekisnedo Pab pemalga pe-pentaked-pid-palmidagal, pemalbak ilagwen-nadgu peigal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tenal we tule-pentakeddin Pab-Purpa-Nued-inniki-chunmaked. Tenal tule-iti-napkin-Pab-wichulmalad Pab-Purpa-Nued-kwen-takchulmaladbal, tegin Pab-Purpa-Nued-kwen-wichulmaladbal keg Pab-Purpa-Nued-abingeel. Tenal Pab-Purpa-Nued-pemalbak-kudiidbal tegin Pab-Purpa-Nued-pemalgin-megoedbal, pemal Pab-Purpa-Nued-wismal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Imi an walagwen pemal-kwen-metnejul, nuskan-pabgan-nikchulidyob. Tenal an pemalzhe kujal kannan nonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tenal tule-iti-napkin-pukmalad iche-iche an-napi-wis-taktimal. Tenal pemal-anpal-nanimaladdin kujal kannan an-takmalbalo. Tenal antin tulamai-choggu, al pemal tullemalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“Tenal pemal te ibegin kep nuekwa an-wisgunonimalo, antin, an-Pabgin mai, tegin pemal ankin mai, tegin an pemalgin maimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Imi tule an-igal-mezhijad igejulil, tenal an-chogzhad-pallí naneel, we tule chunchunnad an-pilal. Tenal an-Pabdin tule-an-pilaled-pilal-kunonimogo, tegin an we tule-pilal-kunonimogo. Tenal tule-an-pilaledga an oyononiko, antin ibi-tule.” ");
INSERT INTO kvnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tegin Judas-pid-Jesúsgin-akpitchulid, Jesúszhe ekichial: —Tummad, ¿ibiga pe anmalgabi oyononikodé? ¿Ibiga pe tule-iti-napkin-pukmaladgadin chuldé? ");
INSERT INTO kvnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tegin Jesús Judasga chogal: “Nabir. Imi meke-ibi-tule an-pilalel, an-chogzhad-pallí nane. Tegin an-Pabdin we tule-pilalguo, tegin an-Pab we tule-ulubgin megnoniko, tegin an we tule-ulubgin megnonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tenal meke-ibi-tule an-pilal-chulil, an-chogzhad-pallí keg nanemal. Imis an-pemalga-chogzhad, an-chunmaked-chul, wedin an-Pab-an-palmialid-e-chunmaked-chunchoged. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Imi an pemalga we immalmal chogzhad, ampa an pemalbak kudiidgin, an pemalga chogzhado. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tenal Pab Tummad an-nuggin pemalga tule-pentaked-palminoniko. Wedin Pab Purpa Nued. Tenal Pab Purpa Nued pel-kwapa an-chunmajadgin pemal-oturdanoniko. Tegin Pab Purpa Nued an-pega-chogzhad kannan wisgugal pe-imanonimalbalo pemal melle igemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tenal antin, an ne. Tenal an ulubgin akalzhul-itogal pemal-imako. Tenal tule-iti-napkin-pukmalad akalzhul-itogal pemal-imakedyob an pemal-kwen-imakojul. Tenal antin chunchunnad ulubgin-akalzhul-itogal pemal-imako. Tenal pe melle chuli-pinzhe-itononimalo, tegin pe melle kwakidamalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Imi pemal an-itosmal: ‘Antin, an ne. Tegin an pemalzhe kannan nonibalo.’ Tenal pemal chunchunnad an-pilalmalalen, an-Pabzhe-naoedbal pemal weligwal itomaloen, an-Pab anka pul tule-tummadiidbal, pemal pul-pule pentalenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Imi an-pemalga-chogzhadyob neg ampayo kuoeddu, an iktualeba pel-kwapa pemalga chogzha. Al an-pemalga-chogzhadyob neg kunonikil, pemal kep ankin ibzhenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tenal antin pemalbak keg nue pal chunmakel. Imi tule-iti-napkinmalad-e-tummad-nia-sagla pato tani. Tenal nia-sagla-tanikiddin a-itoleged keg ankin nakwe. Tenal nia-sagla pinche ankin nakwijadyob kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","“Tenal tule-iti-napkin-pukmalad turdakenabmal an naga-Pab-pilal tegin an Pab-chogzhad-pallí pél immal imabal. Pitomalgu. Tegil nemaldo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tegin Jesús kannan aga e-chapinganga chunmakalbal, chogal: “Imi antin pemalga purpal uva-chaglagin chunmane. Tenal uva-chagla-chunnad chogle, an Jesús. Tegin tule-uva-taked chogle, an-Pab. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tenal uva-tub-kigwen kwen chanmaszhulil, tule-uva-taked nagagin uva-tub chikenab. Tenal uva-tub-kigwengin chanmako-taklegel, tule-uva-taked chagla-omopen uva-tub chikenab, pul-ichejul chanmagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Tenal an-pemalga-chogzhadbal pemal pato ulubgin chwilidik-nemal. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tenal pemal pane-pane ankin kudimalal, antin pemalgin maimogo. Imi uva-tubmal e-saglagin akenaichulil, uva-tubmal keg aga tukin chanmamal. Tenal pemal ampa teopímo. Imi pe ankin maichulil, pe an-Pabga keg ib-nuedga kumo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Imi antin uva-chaglayob, tenal pemal uva-tubmalyob. Tenal tule ankin mail, tegin an we tulegin maimogo. Al tule-ankin-maid Pabga pela-pela immal imanoniko, uva chanmakedyob. Tenal tule ankin maichulil, Pabga keg immal ima, uva keg chanmakedyobmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Tenal tule ankin maichulil, Pab-igenoniko, uva-tub-sagla-nagagin chiklejadyob. Tenal tule uva-tub-itimismalal, tar-midmalo. Tegin uva-tubmal pél tinkujal, kep weinonimalo, choje-midgal okummagal. Tenal tule ankin maichulil, uva-tubmal-itimilejad-yopí kunonimogo, we tulemal Pabga ibga keg pel kunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Tenal pemal ankin mail, tegin pe an-chogzhad-pallí naneel, ibi pe peídin pe Pabzhe ekísmal, Pabdin pega immal imako. Tegin Pabdin pe-immal-ekichijad pega uknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tenal pemal pela-pela Pabga immal imanail, uva-nued-chanmakedyob kunoniko. Al pemal an-Pab-nug-otummononimalo, tegin pemal oyononimalbalo, pemal ankin-turdamalad-tule-chunchunnad.” ");
INSERT INTO kvnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tegin Jesús chogalbal: “Imi Pab an-pilalgujadyob, an pemal-pilalmo. Tenal pemal an-pilaledgin pe kudigumalo, pe melle an-pilaledgin nomalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tenal Pab-anka-chogzhad-pallí an kudiidbal, al Pab ukin-ukin an-pilal. Tenal pemal ampamo. Tenal pemal an-igal mezhijad-pallí tamalal, an ukin-ukin pemal-pilalgunatapmogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Imis an-pemalga-chogzhiid, an pemalga chogzhado, an ulubgin weligwal-itogal, tegin pemal weligwal-itomalgalmo, tenal pemal-pel-kwapa pellallé yer itogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tenal an pemalga igal-mezhijad choge: ‘Pemal aga muchub-muchub pilalgumalo, an pemal-pilalgujad-yopímo.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tenal tule-pilaled-pul-chunchoged chogle, tule akalzhul aga e-ai-anal purko. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tenal pemal an-chogzhad-pallí tamalal, pemal an-ai-nuegan. Al an pemal-anal iwen-akalzhul purko. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Tenal an imis-akar tule-pinche-arpamaladyob an pemal-pal-kwen-taknejul, an-ai-nueganyob pemal-taknejun. ¿Ibiga an teob chog? Imi tule-pinche-arpamalad wichul e-ibed ibi imane. Tenal tummad-e-ai-nuegandin wismaldo, we tummad ibi imane. Imi an-Pabgin-turdajad, an pemalga pel-kwapa chogzha-choggu, al an imis-akar an-ai-nueganyob pemal-taknemal, tule-pinche-arpamaladyob chul. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Imi pemal an-chuszhulmal. Anid, an pemal-chusmal, pe Pabga immal imanegal, uva-chan taka-chiidyob. Tenal pe-Pabga-arpaged ilgwen peinoniko, pal kwen pelguojul. Al meke-ibi pe an-nuggin Pabzhe ekisel, Pabdin pemalga imako. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tenal an pemalga igal-mezhisdo: ‘Pemal aga muchub-muchub pilalguenabmal.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Tegin Jesús chogalbal: “Imi tule-iti-napkin-pukmalad istar pe-takalil, pe ebinzhemalo, we tulemal pemal-iktual istar an-takchamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tenal pemal tule-iti-napkin-pukmaladyob nanemalalen, tulemal yer pe-taknonimaloen, aga e-pakadyob. Imidin pe we tulemalyob kwen nanejulmal, tenal an-iti-nap-akar-pe-chujadbal tulemal istar pe-taknonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Imi pemal nue pinzhemalo, an akpene pemalga igi chogzhad. Tenal an chogzhado, tule-pinche-arpaged e-ibedga, meke-igi pul tule-tummad chul. Tenal tulemal sapejul an-imadi-kusmalad sapejul pemal-imanonimalmogo. Tenal tulemal an-chogzhad-pallí nanedimalalen, pe-choged-pallí nanemalmogoen. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tenal we tulemal aku Pab-an-palmialid-takmal. Al pe-anpal-nanimaladbal tulemal istar pegin immal imanonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Tenal an tule-istar-pe-takmaladzhe nonijulilen, tegin an we tulemalga kwen chunmaszhulbalilen, iskued kwen nikchulmalan. Tenal an tule-istar-pe-takmaladzhe nonikidbal, tegin an we tulemalga chunmajadbal, iskued nika-nemal. Tenal tule-istar-pe-takmalad keg chogmalal: ‘Antin immal-wichulidgin iskuedgin nanedii.’ Al we tulemalgin e-iskued chii-peszhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Tenal tule istar an-takel, we tule istar an-Pab-takmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tenal an tule-yogsalmaladyob tulemal-abalgin immal-taktijulmalad imaszhulilen, tulemal iskued kwen nikchulmalan. Tenal we tulemal an immal-taktijulmalad takchamal, tenal we tulemal yabli istar an-takmal. Tenal we tulemal ampa istar an-Pab-takmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Tenal we immalmal imis kunaid, pato tikajulgus Pab-kartagin choglesmaido. Tenal Pab-kartagin chogdo: Imi an immal kwen akaloszhul, tenal tulemal yabli istar an-taknonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Imi antin Pab-akar pemalga Tule-Pentaked-palminoniko. Tenal Tule-Pentaked, Pab Purpa Nued, napírra immal imaked. Tenal we Purpa-Nued Pab-akar nonikil, napírra ankin chunmanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tenal pemal kepe-akar anpak kudigujadbal, pemal ankin napírra chunmanonimalo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tegin Jesús chogalbal: “Imi an pemalga pél chogzhado, pemal melle ankin pengunonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tenal tulemal Judio-ormaked-negzhe-naneed-akar kantikidgin pemal-onodmalo. Tegin pemalga ibe nonibalo, tulemal pe-mesnonimalbalo. Tenal tulemal pe-mechamalal, ebinzhenonimalo, emalde Pab Tummadga ib-nued imananimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","“Tenal we tulemal Pab-kwen-wichulidbal, tegin an-kwen-wichulidbal, chabzhul pemal-imanonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tenal an pemalga iktualeba pel-kwapa chogzhado. Al an-pemalga-chogzhiidyob kunonikil, pemal ebinzhenonimalo, an pemalga tikajulgus pel-kwapa chogzha, tulemal chabzhul pe-imanonimalo. Tenal an pemalbak-mecha-kudiidbal an kepegin pemalga weob immal-kuoed kwen chogzhajul-kus.” ");
INSERT INTO kvnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tegin Jesús chogalbal: “Antin, an Pab-an-palmialidzhe an nejogal. Tenal pemal-walgwen anche pel kwen ekiszhulmal, an pia ne. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Imi an pedu ne, tenal an-pemalga-chogzhadbal pemal aga ulubgin pela-pela pukib-itononimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tenal an chunchunnad pemalga chogdo: imi an we-akar nadel, pemalga pul ib-nuedga kunoniko. ¿Ibiga an teob chog? Imi an pemaldu nejulilen, Tule-Pentaked pemalzhe kwen nonikojulin. Al an ne, pemalga Tule-Pentaked-palmidagal. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Tenal Tule-Pentaked pemalzhe nonikil, mag ito tule-iti-napkin-pukmalad-imanoniko, emalde iskuedgin kudii. Tegin tulemal mag itononimalo, igal-napírragwad igi mai, tegin tulemal mag itononibalo, Pab chabzhul tule-oturdanoniko. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Tenal Tule-Pentaked mag-ito tule-iti-napkin-pukmalad-imanoniko, emal ankin-kwen-ibzhejulidbal iskuedgin kudii. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tenal an-naga-Pabzhe-needbal pemal an-pal-kwen-takojulmalbal. Al Tule-Pentaked mag-ito tule-iti-napkin-pukmalad-imanoniko, piti-igal pul-igal-napírragwad. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tenal Pab Tummad chabzhul iti-nap-takchiid-e-tummad-Satanás-oturdanonikoedbal, Tule-Pentaked mag-ito tule-iti-napkin-pukmalad-imanoniko Pab Tummad ampa chabzhul tule-iti-napkin-pukmalad-oturdanonimogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Tenal antin pemalga ampa ichejul immal nika pemalbak chunmagal. Tenal pemal kwen unnijulmal, pél an-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","“Tenal Pab-Purpa-Nued-napírra-immal-imakeddin pemalzhe nonikil, pinna-pinna igal-pul-chunchunnadgin pemal-oturdamaio. Tenal Pab Purpa Nued walagwen aga e-itoleged kwen chunmanejul, tenal Pab-Tummad-itojadbal, pemalga chunmanoniko. Tegin Pab Purpa Nued pemalga neg-kujal-igi-kuoedgin chognonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tenal Pab Purpa Nued pemalga an-immal-wijiidgin chunmanoniko, pemal wisgal, antin ibi-tule. Tenal Pab Purpa Nued chunmanonikidbal an-nug okannononiko. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","“Imi Pab-Tummad-pel-kwapa-immalmal-nikad, ampa ankadmo. Al an pemalga chogzhado: Pab Purpa Nued an-immal-wijiidgin, pemalga chunmanoniko. Tegin Pab Purpa Nued mag-ito pemal-imanonimalbalo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tegin Jesús chogalbal: —Imi an nue-naojul an pemalgin wis owelene, tegin an nue-naojulbal pemal kannan an-taknonimalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Al Jesús-e-chapingan-wal-walgwen aga emal-emal ekichialmalzhun, chogalmal: —¿Imi Jesús-chogzhad, ibi chogle-wede? Imi Jesús chogzhado: ‘Imi an nue-naojul an pemalgin wis owelene, tegin an-nue-naojulbal pemal kannan an-taknonimalbalo.’ ¿Ibi chogle-wede? ¿Ede aga e-Pabzhe neé? ");
INSERT INTO kvnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tegin Jesús-e-chapingan kannan-kannan aga emal-emal ekichialmalbal: —¿Ibi chogle-wede, ‘Nue-naojul?’ Anmal aku-itomal, Jesús-chogzhad. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tegin Jesús mag takchagu e-chapingan immal ekisbi-kunanimal, Jesús aga e-chapinganga chogalzhun: “¿Ibiga pemal aga emal-emal immal ekisnanimal-wede, an ibi chogzha: ‘Imi an nue-naojul an pemalgin wis owelene, tegin an nue-naojulbal, pemal kannan an-taknonimalbalo?’ Nabir. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Imi an chunchunnad pemalga chogdo: pemal pukib-itogedgin pononimalo, tenal tulemal-iti-napkin-pukmalad weligwal-itononimalo. Tenal pemal pela-pela pukib-itononimaloendo, tenal pemal te-cholbal weligwal-itononimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Imi ome nuchu-nikued-wilubgan omojal, peyedzhe nunmaked-itogo. Tenal ome nuchu-nikujad-cholbal, e-nunmajadgin pal kwen pinzhaojul. Tenal omega iti-napche nuchu mimmilejadbal, weligwal-itononiko. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tenal pemal ampa teopímo. Imi pemal imis pela-pela pukib-itomal, tegin an kannan pemal-takalbalil, pemal aga ulubgin pela-pela weligwal itononimalo. Tenal we welgued tulemal pemalgin pal kwen idirojul-kuo, pemal ilagwen weligwal pesgu-peio. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Tenal te ibe nonikil, pemal anche pal immal ekisojulmal. Tenal an chunchunnad pemalga chogdo: imi pemal an-nuggin an-Pabzhe meke-ibi ekisel, Pabdin pemalga immal-ekichijad imako. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tenal pemal ampa imisgwadzhe an-nuggin Pabzhe immal kwen ekiszhulmal. Tenal pe Pabzhe immal ekismalal, Pab pemalga immal imako, pemal aga ulubgin pela-pela weligwal-itononigal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tegin Jesús chogalbal: “Imi an pemalga chogzhad, an otukal chogzhado. Tenal pemalga ibe noniko, an pemalga inniki-inniki Pabgin chunmanoniko, an otukal pemalga pal kwen chunmakojul. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","“Tenal pemal te ibegin an-nuggin Pab Tummadzhe immal ekisnoniko. Imidin an pemalga chogzhul, an pemal-anal Pabzhe wilene Pab pemalga immal imagal. Tenal pemal an-nuggin ilagwen Pabzhe immal ekisenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","“Imi pemal-an-pilaledbal tegin pe ankin ibzhajadbal an Pab-Tummad-akar tani, Pab Tummaddin pemal-pilal. Al pe akalzhul ilagwen Pabzhe immal ekismalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Imi an Pab-maid-akar an iti-napche noni. Tenal imidin an kannan iti-nap-akar nejogalbal, an-Pab-maidzhebal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tegin e-chapingan Jesúsga chogalmal: —Imidin pe pakal-pud chunmasdo, pe otukal pal kwen chunmaszhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tenal imidin anmal mag itosmal, pedin pel-kwapa immal wiis, tegin pe wisbal, tulemal ibi peje ekisbi-kunanimalbal. Al anmal wisdo, pe Pab-Tummad-akar-tanikid-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tegin Jesús aga e-chapinganga chogal: —¿Imidin pe ankin ibzhemalá? ");
INSERT INTO kvnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tenal pemalga ibe noniko, tenal pemalga pato ibe noni, pemal-pel-kwapa pis-pis aga negzhe abarmadmalo. Tegin pemal walagwen an-ebemalo. Tenal antin walagwen yabli kwen peiojul, tenal an-Pab yabli anpak kudio. Tenal an-pemalga-immal-chogzhad pato noni. ");
INSERT INTO kvnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Imi an pemalga pel-kwapa chogzhado, pemal anpak-mecha-tiidbal, pe aga ulubgin akalzhul-itononimalgal. Tenal pemal iti-napkin-pukmaladgin pela-pela wilenonimalo. Tenal pe melle pukib-itononimalo. Tenal antin tule-iti-napkin-pukmaladgin pato nakwis-kudii.” ");
INSERT INTO kvnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tegin Jesús pél chunmasgu, nikpa atad, tegin Pabzhe kolal chogal: “Pabye, imi antin, an pe-machiye. Imi an-ibe pato noni-choggu, al pe an-nug okannogo an pe-nug okannogalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","“Imi pe anka igal-ukcha tule-pukwamalad-ugakche takegalye. Tenal pe anka wal-walgwen tule-ukcha anpal-naigugalye. Al an ilagwen-nadgu we tulemal-otulogoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tenal tule-ilagwen-nadgu-tullemaladdin nuekwa Pab-Tummad-chunchunnad-walkwénnagwadbi wisgunonimalo, tegin Jesucristo-wisgunonimalbaloye. “Pab Tummadye, imi ani-Jesucristo, tenal pedin iti-napche an-palminoniye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tenal pe-anka-arpaged-ebejad an-pél-imajadbal antin iti-napkin pe-nug okannodi-kusye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pabye, imi iti-nap-ampayo-naigueddu pe an-nug okannojad-yopí, pe imis pe-wagin pe an-nug-okannobaloye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Imi tulemal-iti-napkin-pukmalad-pe-anka-ukchamaladdin, an pe-wisgugal an ne-imasye. Tenal tulemal-pe-anka-ukchamalad akpene pegadga kudigus, tenal imidin we tulemal pe anka uknonimoye. Tenal tulemal-pe-anka-ukchamalad pe-chogzhad-pallí nanedi-kusmalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tenal tulemal-pe-anka-ukchamalad wismal, pél pe-anka-chogzhad pe-akar taniye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tenal pe-anka-chogzhad an we tulemalga ukin pel-kwapa chogzhamoye. Tegin tulemal-pe-anka-ukchamalad an-chogzhad-abingasmalmoye. Al we tulemal pe-kwen-penguszhulmal, an chunchunnad pe-akar tani, tegin pe an-palmialbalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Imi tule-pe-anka-ukchamaladga an peje wilenaiye. Tenal tule-iti-napkin-pukmaladga an peje kwen wilenaichulye. Tenal tule-pe-anka-ukchamalad ampa pegadmo-choggu, al an peje we tulemalgabi wilenaiye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tenal tulemal-an-nikad, pel-kwapa ampa pegadmoye, tegin tulemal-pe-nikad, pel-kwapa ampa ankadmoye. Tenal we tulemalbal an-nug-okannoledi-kusye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Imi antin iti-napkin pal kwen peinejul, tenal tulemal-pe-anka-ukchamalad iti-napkin peinemalye. Tenal antin, an peje natap pebak meggalye. Pab-chwilidikidye, imi pe nug-tummad nikadyob, pe anka nug-tummad ukchamoye. Tenal pe-tummadga-maidbal pe nue tulemal-pe-anka-ukchamalad-tako, pebak mecha nanegalye. Tegin pe nuekwa we tulemal-takedbal, tule-choggwénnagwadga kunoniko, an pebak mecha kudiidyobmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Imi tule-pe-anka-ukchamaladbak an iti-napkin ampa kudigusgu, pe-anka-nug-tummad-ukchadbal an we tulemal-chabos melle akalomalgalye. Tenal tule-pe-anka-ukchamalad an kwen oweszhul-kus. Tenal tule-pela-pela-aga-ulubgin-iskujad-tulebi wis owelesye, pe-karta akpene nermakal-maidyob kunonigalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Imi antin peje natapye. Tenal antin ampayo iti-nap-akar needdu, an weob pega chog, tule-pe-anka-ukchamalad anyob aga ulubgin pela-pela weligwal-itogalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tenal pe-anka-chogzhad, pel-kwapa an we tulemalga chogzhamoye. Tenal tule-pe-anka-ukchamalad ampa an-yopí tule-iti-napkin-pukmaladzhik naichulmal-choggu, al tule-iti-napkin-pukmalad istar tule-pe-anka-ukchamalad-taknonimalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Tenal an peje wilenaichul, pe iti-nap-akar tule-pe-anka-ukchamalad-chedgalye. Tenal an peje wilenai, pe anka nuekwa we tulemal-tako, nia-sagla melle we tulemalzhe walmagalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imi antin tule-iti-napkined-chul-choggu, al tule-pe-anka-ukchamalad ampa an-yopí, tule-iti-napkinmalad-chulmalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Imi pe pidzhi tule-pe-anka-ukchamalad-urpo, igal-chunchunnad-pallí inniki nanemalgalye. Tenal pe-anka-chogzhagujaddin, igal-chunchunnadye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Imi pe iti-napche an-palminonikidyob, an tule-iti-napkin-pukmaladzhe, tule-pe-anka-ukchamalad-palmismo pe-kakapurwa palchoggalye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Imi antin pane-pane pe-itolegedbalpí unnila chwilidik nanedi-kusye, tule-pe-anka-ukchamalad pane-pane pe-chogzhadbalpí unnila chwilidik nanemalgalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pabye, imi tule-pe-anka-ukchamaladgabi an peje kolnai-chul. Tenal an-chapingan-ankin-chunmanonikoedbal tulemal-pimalad ankin ibzhenonimalo. Al an we tulemal-ankin-ibzhenonimaloedga an ampa peje kolmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tenal tule-ankin-ibzhenonimaloedga an peje kolmo tule-pel-kwapa-ankin-ibzhemalad choggwénnagwadga kunonigal, pe ankin maidyob, tegin an pegin maidyobmoye. Tegin tule-ankin-ibzhenonimaloedga an peje kolbal, we tulemal anmalgin maigal tule-iti-napkin-pukmalad penzhulgal pe an-palmialidye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Imi antin, an-chapinganga nug-okannoed ukcha, pe anka nug-okannoed ukchadyobmoye, tulemal-ankin-ibzhenonimaloed choggwénnagwadga kunonigal, anmal walkwénna kudiidyobmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","“Imi antin, an-chapingangin mai, tegin pedin ankin maimoye. Tenal an-chapingan chunchunnad choggwénnagwadga kunonikil, tule-iti-napkin-pukmalad mag pe-taknonimalo, pe an-palmialid, tegin pe an-chapingan-pilalmo, pe an-pilalgujadyobmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Pabye, imi iti-nap ampayo naigueddu, pe an-pilalgudii-choggu, al pe anka nug-tummad ukchaye. Al an pei, pe-tule-anka-ukchamalad an-megoedgin megmalmogoye, an-tummadga-maid wisgumalgalmoye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Pab-innikigwadye, imi tule-iti-napkin-pukmalad pe-kwen-wichulmal. Tenal antin mag pe-takcha, tegin tule-pe-anka-ukchamalad wisgunonimal, pe an-palmialye. ");
INSERT INTO kvnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tenal antin pe-wisgugal tule-pe-anka-ukchamalad-imadi-kus, pedin ibi-tuleye. Tenal antin ampa ukin-nadgu pe-owisgugal tule-pe-anka-ukchamalad-imadi-kubaloye. Tenal pe-an-pilalgudi-kujadyob pedin tule-pe-anka-ukchamaladgin kudigumogo, tegin antin we tulemalgin maimogoye. Pitogua.” ");
INSERT INTO kvnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tegin Jesús Pab Tummadzhe pél kochagu, Jesús aga e-chapinganbak kullubal nadmalzhun, Cedrón-tian-opakal, immal-chalgan-naidzhe. Tegin Jesús aga e-chapinganbak tebal ampagutapmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tenal Judas-Iscariote-Jesúsgin-akpitchad ampa we immal-chalgan-naid wismo. Tenal Jesús aga e-chapinganbak melugus we immal-chalgan-naidbal ormadi-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Al Judas we immal-chalgan-naidzhe íchejul tulemal-cheinonimal, tegin íchejul chulubmal-cheinonimalbal. Tegin Judas tulemal-irwal-Pabzhe-kolmalad-e-mosmal, tegin Pariseomal-e-mosmal-cheinonimalbal. Tenal tulemal-nonimalad kallen-annik-nonimal, tegin achachar-ogaal cheinonimalbal. Tegin tulemal es-pilacheed tegin chowal-oro ilabal anniknonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tenal Jesús pato wiis, ega igi immalmal kuoed. Al Jesús tulemal-tanimalad-abin-nad. Tegin Jesús tulemalzhe ekichialzhun: —¿Pe toa-amimaldé? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tegin tule-nonimalad Jesúsga chogalmal: —Anmal Jesús-Nazaretkined-amidanimal. Tegin Jesús tule-nonimaladga chogal: —Anid, an Jesús-Nazaretkineddé. Imi teun takalgu, Judas-Jesúsgin-akpitchad tule-nonimaladbak kwichimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tegin Jesús aga tukin chogzhagu ede Jesús, tulemal-Jesús-kagal-nonimalad chorzhik-chorzhik nadmal, ilgwen napche aglatapmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tegin Jesús kannan tule-nonimaladzhe ekichialbal: —¿Tegil pe toa-amimalzhun? Tegin tule-nonimalad kannan Jesúsga chogalmalbal: —Anmal Jesús-Nazaretkined-amidanimaldo. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tegin Jesús kannan tule-nonimaladga chogalbal: —Imi antin, an pemalga chogzhado, ante Jesús-Nazaretkined. Tenal pe an-amidani-chogel, we an-chapingan-pukmalad, meke nemalodo. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Al Jesús-e-chapingana-immal-kujad, Jesús-akpene-chogzhad-yopí kunoni. Tenal akpene Jesús chogzhado: “Imi tule-pe-anka-ukchamalad an kwen oweszhul-kus.” ");
INSERT INTO kvnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tenal teun takalgu, Simón-Pedro es-nai kwichi. Tegin Pedro es unnusgu, tule-irwal-Pabzhe-koled-pul-tummad-e-mos-chiktegu, chuchu-nuedzhikpi kaledap-idirrí. Tenal tule-chuchu-chiklejad nug Malco. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tegin Jesús Pedroga chogal: —Es kannan uka-yabal pe yoo. Imi Pab-chogedbal anka wileged noni, kobed-kakpi-koblegedyob. Al an weob wileged-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tegin chulub-tummad aga e-chapinganga igal-ukcha, Jesús-kagal. Tegin chulubmal Judio-tummagan-e-mosmalbak Jesús-kasmalgu, Jesús-chunkal kugmasmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tegin tulemal-Jesús-kasmalad ilgwen Anás-negzhe Jesús-chesmal. Imi teun takalgu, Caifás te pirkagin tule-irwal-Pabzhe-kolmalad-pul-tummadga mai. Tenal Anásdin, Caifás-e-chak. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tenal Anás-chapin-Caifásdin akpene Judiomalga Jesúsgin chogzhagujad, tule-walgwen purkwel, pul ib-nued pul tulemal-pel-kwapa purkwemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tegin Simón-Pedro tegin Juan Jesús-cholbal nadmal. Tenal tule-irwal-Pabzhe-kolmalad-pul-tummad mag Juan-tak-choggu, al Juan Jesúsbak mes togzhamo, tule-tummagan-neg-abalgin-neg-olol-naidzhe. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tenal Pedrodin magadbal wanagakkin kwichi-pes. Tenal tule-tummad-mag-Juan-takedbal Juan puna-wanagak-takchiidbak chunmas, Pedro-odogal. Tegin Pedro kep togdemojun. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tenal puna-wanagak-takchiid Pedroje ekichial: —¿Imi pe we tule-kalejad e-chapinmojulzhí? Tegin Pedro punaga chogal: —Chulá. An we tule-e-chapin-chuli. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Imi teun takalgu, neg pela-pela tampe kunaidbal, tule-tummagan-e-mosmal tegin chowal-ibgan cho ogasmal. Tegin tule-tummagan-e-mosmal chowanonimalzhun. Tegin Pedro we tulemalbak mes chowanonimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad-Anás Jesúszhe, e-chapingan-ekichial. Tegin Anás Jesúszhe ekichialbal: “¿Pe igi aga pe-chapingan-oturdanaibaldé?” ");
INSERT INTO kvnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tegin Jesús tule-tummad-Anásga chogal: —Imi antin tulemalga pel-kwapa inniki-inniki chunmadi-kus. Tegin Judiomal ampagunonimalal, an keg-chulgu Judio-ormaked-neggin tegin Pabzhe-koled-neggin tulemal-oturdadi-kusbal. Tenal antin otukal kwen chunmaszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tede pe ibiga anche ekisdé? Imi pe tule-an-itosmaladzhe pe ekisdo. Tenal we tulemal an-wismal, an igi chunmadi-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tegin Jesús Anásga pél chunmasgu, chowal-ibed-walgwen-Jesús-abir-kwichid Jesús-wagal ebios. Tegin we chulub Jesúsga chogal: —¿Ibiga pe weob tule-irwal-Pabzhe-kolmalad-pul-tummad-abinchus-wede? Imi pe tule-irwal-Pabzhe-koled-pul-tummadga pe kaka-kochadyob igal kwen maichul. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tegin Jesús tule-e-wagal-ebiojadga chogal: —Imi an tule-tummadga istar chunmajal, anka pe chogdo, an igidgin istar chunmas. Tenal an istar kwen chunmaszhul. ¿Tede ibiga pe an-ebiosdé? Weobdin ib-nuedzhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tegin Anás chunkal-kugmakal tule-irwal-Pabzhe-kolmalad-pul-tummad-Caifászhe Jesús-palmis. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tegin Simón-Pedro ampa chowajiidgin, tule-walgwen Pedroje ekichial: —¿Imi pe tule-kalejad-e-chapinmojulzhí? Tegin Pedro chogal: —Chulá. An we tule-kalejad-e-chapin-chuli. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad-e-mos, Pedro-tarbi-chuchu-chikchad-e-kwenad Pedroje ekichialmo: —¿Imi an pe-takchamojulzhí, pe tule-kalejadbak immal-chalgan-naidgin pe kudimo? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tegin Pedro kannan chogalbal: —Chulá. An we tule-kalejad-e-chapin-chul. Tegidgin kallin-mastad kep namanonijun. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Imi tule-tummagan Caifás-neggin Jesúsga igal-itosgu, Judiomal Romano-gobernador-negzhe Jesús-chesmal, Jesúsga igal-itogal. Tenal teun, neg wakur-wakur. Al Judio-tummagan melle igal-mamikidgin iskugal tegin Judio-tummagan akalzhul Pab-Najad-Itogedgin mas kunmalgal, gobernador-negzhe kwen togzhajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tenal Judio-tummagan gobernador-negzhe togzhajulidbal, Gobernador-Pilato tule-tummagan-pukwadzhe nononijun. Tegin Pilato Judio-tummaganzhe ekichial: —¿Ibiga pe anka we tule-tuktidanimal-wede? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tegin Judio-tummagan Pilatoga chogalmal: —Imi we tule, tule-nuedilen, anmal peje we tule-kwen-cheinonijulin. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tegin Pilato Judio-tummaganga chogalzhun: —¿Teobí? Tegil pe we tule-chedmaldo, pe-igal-mamikidbal igal-itogal. Tegin Judio-tummagan Pilatoga chogalmalbal: —Pe anmalga nabir chogendo, tenal anmal yabli igal-kwen-nikchul tule-iskana-mesgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Imi Jesús akpene chogzhagusdo, e-purkoedgin ega igi kunoniko. Tenal Jesús-chogzhad-yopí Jesúsga kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tegin Pilato e-negzhe kannan togzhagu, Jesúszhe kocha. Tegin Pilato Jesúszhe ekichial: —¿Imi pede, Judiomal-erreyzhí? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tegin Jesús Pilatoga chogal: —¿Pe aga tukin aga onos an Judio-errey, o tule-pid pega chogzha? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tegin Pilato Jesúsga chogal: —¿Ante Judio-tulejí, an we immalmalgin yolegal? Chulá. Imi pe-tule-irwal-Pabzhe-kolmalad-e-tummagan tegin pe-tulemal anche pe-cheinonimal. Tegin Pilato Jesúszhe ekichialbal: —¿Tede pe ibi akaloszhun? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tegin Jesús Pilatoga chogal: —An immal kwen akaloszhul. Tenal an tule-tummadyob an neg-takchido, tenal an iti-napkingajul. Tenal an tule-tummadyob iti-napkinga neg-takmailen, an-mosmal anka pila-onosmalan, Judiomal melle an-kagal. Imidin an-chapingan pila-kwen-onoszhulmal. Tenal an tule-tummadyob neg-takmaid iti-napkinedgajul. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tegin Pilato Jesúsga chogal: —¿Tegil pe Erreydé? Tegin Jesús Pilatoga chogal: —Teobdo, an erreydo. Imi an mimmiles erreyga kugal. Tenal an iti-napche noni, igal-chunchunnadgin chunmagal. Tegin tulemal-igal-chunchunnadzhikmalad-pel-kwapa mag an-itosmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tegin Pilato Jesúsga chogal: —¿Ibi igaldin, igal-chunchunnaddé? Pinche pe chunmama. Tegin Pilato pél Jesúszhe immal ekichisgu, kannan Judiomal-pukwadzhe magadbal nosbal. Tegin Pilato Jesúsgin Judiomalga chogal: —Imi pe we tulegin chogzhamaldo immal akalos. Tenal an we tuleje immal ekichisgu, an we tulegin immal-akalojad kwen onoszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Imi pemalga kusgu igal mai-choggu Pab-Najad-Itogedgin tule-oturdalemaid-walgwen onoenab, al an wisgubi, ¿pe igi peimal, an we Judiomal-errey-onogo o chul? ");
INSERT INTO kvnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tegin Judiomal sapejul kolmakalmal chogalmal: —¡Pe melle we tule onogo! ¡Barrabásdin pe anmalga onogo! Tenal Barrabásdin, kantikidgin-tulemalgin-immal-aturzheed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tegidgin Pilato e-chulubmalga chogzha: “Pe pela-pela Jesús-ebiomalo.” Tegin Pilato-e-chulubmal sapejul Jesús-ebiosmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tegin chulubmal tub-iko-nikad kwilomasmal, tegin kep Jesús-nonogin iko-kurkin chismalzhun. Tegin chulubmal erreyyob Jesúsgin mol-kwalugiid yosmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tegin chulubmal Jesús-abir nonimalgu, Jesúsgin todoalmal chogalmal: —Judio-erreyye, imi pe ilgwen tule-tummadga-mailen, nabirinye. Tegidgin chulubmal twássa Jesús-wagal-ebiosmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tegin Pilato neg-yabal-akar kannan nononibalgu, Judiomalga chogal: —Imi an pemalga kannan we tule-cheidanibal. Tenal antin, an takto, we tule immal kwen akaloszhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tegin Jesús Pilato-neg-yabal-akar nononigu, Jesús pato nonogin iko-kurkin-chii nononi. Tenal Jesús mol-erreygadyob-yowi nononibal. Tegin Pilato Judiomalga chogal: —Imi pe takto, we tule igi-takle. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan tegin e-pentamalad Jesús-takalgu, sapejul kolmakalmal chogalmal: —¡We tule nakrusgin pe tar-piokmalo! ¡We tule nakrusgin pe tar-piokmalo! Tenal Pilato Judiomalga chogal: —Imi pemal peimalal nakrusgin we tule-pioko, pe tar-chedmaldo. Tenal antin, an takto, we tule immal kwen akaloszhul. Al an we tulegin pal kwen yolenejul. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tegin Judiomal Pilatoga chogalmal: —Chulá. We tuledin peyedzhe immal akalos. Tenal anmalga igal-maido: imi meke-ibi-tule anmal-igalgin yolejal, we tule purkwed-wilub. Tenal we tule aga chogzhadbal, ede Pab-Tummad-Machi, al purkwed-wilubdo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tegin Pilato Judiomal-chogzhad itosgu, pul-pule kwakial. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tegin Pilato kannan neg-yabal togzhabalgu, Jesúszhe kocha. Tegin Pilato Jesúszhe ekichial: —¿Pede piagwad-ade? Tenal Jesús Pilato-kwen-abinchuszhul-kus, ilgwen yakir pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tegin Pilato Jesúsga chogal: —¿Ibiga pe yapa an-abinchudé? ¿Pe wiszhulzhí, an igal-nika, pe-onogal, o nakrusgin pe-piokkal? ");
INSERT INTO kvnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tegin Jesús Pilatoga chogal: —Imi pe igal-nikado, pe weob an-imagal. Tenal Pab Tummad pega igal-ukchajulilen, pe igal-nikchulin, pe weob an-imagal. Al tulemal-pega-an-ukchamaladdin, pega pul-pule iskued nikunonimal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tegin Jesús weob chogzhagu, Pilatode igal-amijan Jesús-onogal. Tenal Judiomaldin sapejul kolmananimal, Pilatoga chognanimal: —Imi pe we tule-onojal, pe Romano-Tummad-Césarbak aichulidga kuo. Tenal meke-ibi-tule chogel, ede errey, we tuledin Césarbak istargad. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tegin Pilato Judiomal-chogzhad itosgu, neg-yabal-akar Jesús-onos. Tegin Pilato igal-itoged-kangin chigwiszhun choggal piaje Jesús oturdaleged-wilub o purkweenab. Tenal we kan Akwa-Mata-Mata-neg-nugadgin chii. Tenal kan-chiid-neg Hebreo-kakagin pimal Gabata. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Imi teun takalgu, Pab-Najad-Itogedga-immal-nudaked-ibe pato naigunoni. Imi teun tad yorokupen. Tegin Pilato Judiomalga chogalzhun: —¡Pe tak, pemal-errey igi-takle! ");
INSERT INTO kvnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tenal Judiomal sapejul kolmakalmal chogalmal: —¡Pe we tule-mesmalo, pe we tule-mesmalo; nakrusgin tar-piokmalo! Tegin Pilato Judiomalga chogal: —¿Pemal peimal, an nakrusgin pe-errey-pioko? Tegin tule-irwal-Pabzhe-kolmalad-e-tummagan Pilatoga chogalmal: —Imi we tule, anmal-errey chul. Romano-Tummad-Césarbi anmal erreyga mai. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tegin Pilato Judiomalga igal-ukchajun, nakrusgin Jesús-piokkal. Tegin chulubmal Jesús-chesmalzhun Jesús-piokkal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tegin Jesús Jerusalén-neg-kwebur-akar nodgu, aga nakrus-mai nad, Tule-Nono-Kal-Yal-neg-nugadzhe. Tenal we neg Hebreo-kakagin pimal Gólgota. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tegin chulubmal Gólgota-neg omosgu, nakrusgin Jesús-piokchamal. Tegin chulubmal Jesús-egek nakrus-pidgin walbo tule-piokchamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tegin Pilato chulubmalga chogzha: —Pemal nakrus-tukugin karta nazhimalo: ");
INSERT INTO kvnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Imi teun Jesús neg-kwebur-tikalbal nakrusgin-nai-choggu, al Judiomal-irmamamimalad-ichejul Jesús-nakrusgin-nermakal-naid apchosmal. Tenal we nermakal-naid kaka-chogapágin nermakal nai; Hebreo-kakagin, Romano-kakagin tegin Griego-kakaginmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tegin Judiomal-irwal-Pabzhe-kolmalad-e-tummagan takchagu nakrus-tukugin karta-nermakal-nai, Pilatoga chogalmal: —¿Ibiga pe weob Jesúsgin nermas-wede? Pe weob nermaked-wilubzhulin. Imi we nermakal-naid pe keg-chulgu ogwagenab. Tenal pe nermakenabdo: ‘We Jesús-Nazaretkined aga tukin chogzha, ede, Judiomal-e-Erreyye.’ ");
INSERT INTO kvnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tegin Pilato Judio-tummaganga chogal: —An kwen ogwanejul. Imi nakrusgin-nermakal-naid-yopí, ampa an ebene. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tegin chulubmal nakrusgin Jesús-piokchamalgu, Jesúsbi-mol chusmal. Tegin chulubmal pis-pis chogabake tunukwa-tunukwa Jesús-mol urpismal chulub-ilbal aga chumalgal. Tenal Jesús-mol-ulak-yowiddin, kwen echirmaszhulmal. Tenal we mol nikpa-akar-ulpalidzhe ilgwen olol, tikal pel makalzhul. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Al chulubmal chogalmal: —Anmal melle we mol echirmamalo, aka weob ebemalo. Anmal pul molgin todomalo, takegal toa pul chuo. Imi chulubmal we immalmal-imajad, akpene Pab-kartagin nermakal maid-yopí kunoni. Tenal Pab-kartagin nermakal maido: Tulemal an-molmal mimismal, tegin an-molgin todosmal, toa pul mol chumalo. Sal. 22:18 Al chulubmal teob imasmaldo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Imi teun takalgu, Jesús-nakrusgin piokal-naid-abir, Jesús-e-nan, tegin Jesús-e-nan-e-urpa kwichimo. Tegin Cleofas-e-ome-María tegin María-Magdalena pukwamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tegin Jesús aga nan-takchagu, tegin e-chapin-pilaled-takchabalgu, Jesús aga e-nanga chogal: —Ome, imi antin, an purkwene-choggu, al we Juan an-anal pe-machiyob kunejun. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tegidgin Jesús Juanga chogalmo: —Imi we ome aga pe-nanyob pe takchunno. Imi teun-akar Juan e-neggin aga e-nanyob Jesús-e-nan-akwiszhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Imi Jesús aga wiis-choggu ede Pab-chogzhadbal pél immal imas, al Jesús Juanga-chogzhad-cholbal, Pab-kartagin nermakal-maidyob kunonigal, chogalzhun: —An ukul-ukul ito. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Imi teun pude-walgwen-vino-choled Jesús-abir kwichimo. Al tule upchanyob immal-tutu cheinonigu, vinogin owartichas. Tegin tule-Jesús-okob-chognaid hisopo-chowal-tukugin immal-tutu chis, tegin Jesús-kakagin immal-tutu nazhis, Jesúsde nugal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tegin Jesús vino-choled kobzhagu, chogal: —Imi antin pato pél immal-imas. Tegin Jesús teob chogzhagu, nono yaku nad, ilgwen purkwis. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Imi teun takalgu, Pab-Najad-Itoged pan-kuele-choggu, al Judiomal peichulmal ulukued-ibe-pul-chunchogedgin tule-mui nakrusgin nanimal. Al Judiomal Pilatoje igal-amiapmal, chulubmal tule-nakrusgin-nanimalad-tuwa piskegal, ilgwen tule-opurkwemalgal. Tegin Judiomal peimalbal tule-nakrusgin-nanimalad purkwismalal, chulubmal tule-e-mui-odemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tegin Pilato Judiomalga igal-ukchagu, chulubmal tule-Jesús-abir-naid-e-tuwa pichis, tegin tule-pid-Jesús-abir-naid-e-tuwa pichismalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tenal chulubmal Jesúszhe nonimalgu, taknonimal, Jesús inkwa pato purkwal-nai. Al chulubmal Jesús-tuwa kwen pichiszhulmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tenal chulub-walgwen ezhigin Jesús-tikal-eyurusgu, apka-pakal abe tibak arioal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Imi antin, an imial takchado, chulub ezhigin Jesús-tikal-eyurus. Tenal an-immal-chogzhiid, ib-chunchunnaddo. Tenal an imial Jesús-takchadbal, an napírra chunmanai, pemal Jesúsgin ibzhegalmo Jesúsde Pab-Machi. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tenal we immalmal-kujad, akpene Pab-kartagin choglejad-yopí kunoni. Tenal Pab-kartagin nermakal maido: Imi tulemal we tule-e-kal kwen piskojul-kuo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tegin Pab kartagin nermakal maibaldo: Imi tulemal, tule-ezhigin-eyurulejad-takmalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tegin Jesús purkwijad-cholbal, José-Arimateagined Pilatoje igal-ekichiap, Jesús-mui-tignegal. Tenal Josédin, Jesúsbal-turdaked-tulemo. Tenal José Judio-tummagan-tobedbal, otukal Jesúsbal turdadi-kus. Tegin Pilato Joséga igal-ukcha, akalzhul Jesús-mui-chedgal. Tegin José Jesús-nakrusgin-naidzhe nonigu, Jesús-mui-naid-odes tignegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Imi teun takalgu, Nicodemo Josébak kunaimo. Tenal we Nicodemodin akpene-mutik-Jesúszhe-arpigujad-tule. Tegin Nicodemo immal-wawad-kwamakaled libir-tulapá-kakaambe-kakatal cheinoni, Jesús-muigin imagal. Tenal immal-wawad mirra-áloe-oburaled-ina. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tegin José, Nicodemobak kusgu Judio-igal-maidbal, mol-orojulidgin, tegin ina-wawadgin, Jesús-mui ebirmasmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Imi teun Jesús nakrusgin purkwijad-abir, nagnu nai. Tenal we nagnugin uan-ya-pin chii. Tenal we uan-yagin ampa tule kwen tigledijulid. ");
INSERT INTO kvnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tenal Pab-Najad-Itogedga immal-nudaked-ibe nai-choggu, al José Nicodemobak uan-aka-waglika-chiidbal kueye-kueye Jesús-mui tigapmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tegin Tumigin polegu, wagal ampa aku-takle, María-Magdalena uanzhe nad. Tegin María-Magdalena uanzhe omosgu, taknatapmal, akwa-tummad-uan-ya-chaktijiid pato oniral-chii. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tegin María takchagu akwa-tummad-uan-ya-chaktijiid oniral-chii, kannan ilgwen abarmakalzhun, Simón-Pedroje tegin Jesús-e-chapin-pul-pilaledzhe. Wedin an. Tegin María anmalga chogalzhun: —Imi tulemal uan-akar anmal-Tummad-mui chesmal. Tenal anmal wichulmal, pia Tummad-mui-tigzhamal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tegin Pedro anpak mes uanzhe nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tegin anmal nadgu aga mecha abarmadmal. Tenal antin pul Pedroga abarma-choggu, al an-inzhel uanzhe omos. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tegin an uan-yabal nuekwa takegal an tullu imasgu, an takchado, mol-Jesús-ebirmajadbi pukwa. Tenal an uan-yabal kwen togzhajul. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tegin Simón-Pedro, an-cholbal nonigu, ilgwen uan-yabal togzha. Tenal Simón-Pedro takchamodo, mol-Jesús-ebirmajadbi pukwamo. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tegin Simón-Pedro takchabal, mol-Jesús-mui-e-nono-ebirmajad pis pukwa, tenal nuekwa pipisal pukwa. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tegin antin uan-yabal kep togzhamo. Tegin an takchagu Jesús-mui maichul, kep an penzhul-kunoni, Jesús kannan tulles. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tenal teun anmal ampa aku-itomal, Pab-kartagin nermakal mai, Jesúsdin keg-chulgu purkwaled-akar kannan tulleged-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tegin kep anmal kannan negzhe almalbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Imi teun takalgu, María-Magdalena uan-magarbal ampa pogwis-pes. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tegin María poed-abalgin nuekwa uan-yabal takegal tullu imasgu, takal, angel-walbo mol-chibugan yoyo-pukwamal. Tenal angel-walgwen Jesús-megwijad nag-tukubal chii, tegin angel-walgwen Jesús-nono-megwijadzhik chimo. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tegin angelmal Maríaje ekichialmal: —¿Puna, ibiga pe po-wede? Tegin María angelmalga chogal: —Imi tulemal anpi-Tummad-e-mui chesmal. Tenal an wichul tulemal pia an-Tummad-tigzhamal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tegidgin María-Magdalena akpiridgu, takal Jesús e-abir kwichi. Tenal María wichul wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tegin Jesús Maríaga chogal: —¿Puna, ibiga pe po-wede? ¿Pe toa ami-ade? Tenal María ebinzhe, we tulede, nagnu-taked. Al María Jesúsga chogal: —An-ai, pe we tule-mui-chejal, anka pe chogoma, pia pe ches, an akne tignegal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tegin Jesús Maríaje kote: —¡María! Tegidgin María-Magdalena Jesúszhik akpiridgu, sapejul Hebreo-kakagin kote, chogal: —¡Rabuni! (Wedin choglege, tule-oturdaked.) ");
INSERT INTO kvnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tegin Jesús Maríaga chogal: —María, melle pe an-kama. An ampayo Pab Tummadzhe nakwe. Imidin an pei, pe ne, an-kwenadganzhe. Tegin pe an-kwennadganga chogo: “Antin, an Pab Tummadzhe nakwene. Tenal Pab Tummad, an-pab tegin pe-pabmo. Tenal Pab Tummad an-Pab-Tummadga mai tegin pe-Pab-Tummadga maimo.” ");
INSERT INTO kvnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tegin María-Magdalena, Jesús-e-chapinganzhe nadzhun. Tegin María Jesús-e-chapinganga pél palchogzhajun, ede Pab-Jesús-takcha. Tegin María palchogzhabal, Jesús ega pél chunmajad. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Imi teun ampa te Tumigin, mutik Jesús-e-chapingan Judio-tummagan-tobedbal neg-yabal pukwamal. Tenal Jesús-e-chapingan wanagakkin piir chowal mezhismal melle tulemal kin togmalgal. Tegidgin Jesús e-chapingan-abalgin nononigu, e-chapinganga chogal: —Anná, tegidde, ¿pemalde, igi kumal? ");
INSERT INTO kvnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tegin Jesús teob chogzhagu, e-chapinganga e-chunkal-eskorogin-pioklejad tegin e-tikal-eyurulejad oyos e-chapingan wisgal, ede chunchunnad Jesús. Tegin Jesús-e-chapingan Pab-Jesús-takchagu, weligwal pesmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tegin Jesús kannan aga e-chapinganga chogalbal: —Pe aga ulubgin akalzhul-itomalalen, nabirin. Imi an-Pab an-palmialidyob, an pemal-palminemalmo Pab-kaka-nuegan palchoggal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tegidgin Jesús aga e-chapingan-agnus. Tegin Jesús aga e-chapinganga chogal: —Imisgin pe Pab-Purpa-Nued-abingemalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tenal pe Pab-Purpa-Nued-abingajadbal, pe igal-nika, meke-ibi-tulega pe chogzhal, ‘Pe iskued pelgus,’ we tule-e-iskued pelguenab. Tegin pe meke-ibi-tulega chogzhal, ‘Pe iskued pelguszhul,’ we tule ampa iskuedgin kudii, e-iskued ampa pelgujul. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Imi Jesús aga e-chapinganga nononigusgu, teun Tomás Jesús-e-chapingan-pimaladbak chijul. Tenal Tomás Jesús-e-chapingan-walambe-kakabogwad-walgwenmo. Tegin tulemal Tomás-pimalbal, Tarbo-Mimmilejad. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tegin Jesús-e-chapingan-pimalad Tomásga chogzhamal, emalde Jesús-takchamal. Tegin Tomás Jesús-kannan-tullejad itosgu, e-pakamaladga chogal: —Imi we tule-pe-anka-chogmalad e-chunkalgin eskorog-ya-chiid an takchulil, tegin an ko-yojulil, tegin an e-tikal-eyurulejadgin an chunkal-yojulbalil, an kwen ibzhaojul, wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tegin Jesús-kannan-tullejad-tumigwengin Jesús-e-chapingan ampa te neggin ampagunonimalbal. Tenal teun Tomás e-pakamaladbak mes kujimo. Tenal Jesús-e-chapingan wanagakkin piir chowal mezhismalbal, melle tulemal kin toggal. Tenal teun Jesús kannan e-chapingan-abalgin nononibal. Tegin Jesús aga e-chapinganga chogal: —Anná, tegidde, ¿pemalde, igi kumal? ");
INSERT INTO kvnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tegin Jesús Tomásga chogal: —Imi pe takto, an-chunkal. Imisgin pe ko yodado. Tegin pe an-tikal-eyurulejadgin pe chunkal yobaldo. Tomás, pe melle ankin penguma, pe ankin ibzhema, antin Jesús-chunchunnaddo. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tegin kep Tomás Jesúsga chogalzhun: —Pedin, pe an-Tummad tegin pe an-Pab-Tummadbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tegin Jesús Tomásga chogalbal: —Imi pe sanal an-takchadbal pe ankin penzhul-kunoni. Tegin an chogbaldo, tule an-takchajulidbal, yabli ankin ibzheel, ib-nued we tulega kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Imi Jesús e-chapingan-wagin ichejul immal-taktijulmalad-pimalad imas. Tenal an iti-kartagin, Jesús pél immal-taktijulmalad an kwen chogzhajul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tenal antin iti-kartagin an kwénna-kwénna Jesús-immal-taktijulmalad wis nermas, pemalga pakal-pud oyogal, Jesús, Pab-Machi-chunchunnad, wedin Cristo-Pab-Tummad-akpene-chogzhad-palmidagoed-tule. Al pe Jesúsgin ibzhenonikil, pe ilagwen-nadgu tullego. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tegin Jesús-e-chapinganga-nononikid-cholbal, Tiberias-mata-kakagin e-chapinganga kannan nononibal. Imi teun takalgu, weob kusdo. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Imi teun Jesús-e-chapingan-walakugle pulakwa pukwamal: Simón-Pedro, Tomás-Tarbo-Mimmilejad, Natanael-Caná-Galileagined, Zebedeo-machimal, tegin Jesús-e-chapingan-pimalad-walbo pukwamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tegin Simón-Pedro e-pakamaladga chogal: —Imi antin, an chakigin ua-wis-kanegwelo. Tegin e-pakamalad Pedroga chogalmal: —Anmal pebak nemalmo. Tegin e-pakamalad Pedrobak nadmalmojun ua-kagal. Tegin Jesús-e-chapingan ulzhe omosgu, ulgin aknakwismalzhun. Tenal Jesús-e-chapingan oipos chakigin ua-kananimal. Tenal Jesús-e-chapingan pel ua-kwen-kaszhul-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tegin neg-oiposgu, Jesús-e-chapingan takalmal, Jesús mata-kakpal kwichi. Tenal Jesús-e-chapingan wichul, wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tegin Jesús aga e-chapinganzhe kotegu, e-chapinganzhe ekichial: —Machimal, ¿pemal ua-kasmal o chul? Tegin e-chapingan Jesúsga chogal: —¿Piawa? ¡Saté! ");
INSERT INTO kvnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tegin Jesús aga e-chapinganga chogalbal: —Imisgin pe ul-naid-nuedzhik pe chaki opato. Wezhikdin pe nabir ua-kamalo. Tegin e-chapingan chaki ebigalgu, ichejul-ua-kajadbal pel unnijul chaki ebigusmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tegin Jesús-e-chapin-pilaled, Pedroga chogal: —We tule, Pab-Jesús. Imi teun takalgu Pedro yogal-nikchul kunain. Tegin Jesús-e-chapin-pilaled Pedroga chogzhagu: “We Jesús,” Pedro mol yos. Tegin Pedro ul-akar ilgwen tije ichomadgu, Jesúszhe tomomakal nadzhun. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tegin Jesús-e-chapingan-pimalad cholbal ulgin nadmalmo. Tenal Jesús-e-chapingan mata-kaka-akar twagdar pannajul kunai, unnila tali-tulabo-kakaambe panku. Al Jesús-e-chapingan mata-kakaje chakigin ua-tak-ebidmal. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tegin Jesús-e-chapingan mata-kakaje omosgu, pato takalmal, Jesús chogin ua-chelonai, tegin Jesúsga madu maibal. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tegin Jesús aga e-chapinganga chogal: —Pe ua-pid-chedamalbaldo, imis-pe-kasmalad. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tegin Simón-Pedro kannan ulgin nakwisbalgu, pinna-pinna ua-weimaid-pakas kannan mata-kakaje chaki urpismal. Tenal teun ua-kasmalad ua-uka-tadaganbi ne, purwigwad pel nikchul. Tenal ua pelugles uka-tulakugle-kakaambe-kakapá ua-kasmal. Tenal Jesús-e-chapingan-ichejul-ua-kajadbal, chaki yabli kwen idiriszhul-kus. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tegin Jesús aga e-chapinganga chogal: —Tagmalma, mas wis itomalgal. Tenal e-chapingan Jesús-tobedbal, Jesúszhe kwen ekichiszhulmal: “¿Pede toa-tule?” Tenal e-chapingan wismaldo, wedin Pab-Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tegin Jesús madu chusgu, aga e-chapinganga ukcha. Tegin Jesús ampa madu-yopí ua-imasbal. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Imi teun takalgu, Jesús kannan tullejad-akar, wegin pato ilapágus aga e-chapinganga nogus. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tegin Jesús aga e-chapinganbak pél mas kuchad-cholbal, Jesús Simón-Pedroje ekichial: —¿Juan-machi-Simón, pe wemalga pul pe an-pilal? Tegin Pedro Jesúsga chogal: —Tummad, pe an-nued-wisdo, an pe-pilal. Tegin Jesús Simón-Pedroga chogalbal: —Tegil pe anka tule-anpal-naigusmalad-akodo, tule-oveja-taked oveja-mimmigan-akwedyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tegin Jesús kannan Simón-Pedroje ekichialbal: —¿Juan-machi-Simón, pe an-pilal? Tegin Simón-Pedro Jesúsga chogalbal: —Tummad, pe an-nued-wisdo, an pe-pilal. Tegin Jesús Pedroga chogalbal: —Tegil pe anka tule-anpal-naigusmalad-akodo, tule-oveja-taked ovejamal-akwedyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Imi Jesús wegin ilapáguo, Pedroje immal ekised. Tegin Jesús kannan Simón-Pedroje ekichialbal: —¿Juan-machi-Simón, pe an-pilal? Tegin Jesús Simón-Pedroga ilapá chogzhadbal, “¿Pe an-pilal-dewa?” al Simón-Pedro pukib-itononi. Tegin Simón-Pedro Jesúsga chogalzhun: —Tummad, pedin pel-kwapa immal wiis. Al pe an-nued-wisdo, an chunchunnad pe-pilal. Tegin Jesús Simón-Pedroga chogalbal: —Tegil pe anka tule-anpal-naigusmalad-akodo, tule-oveja-taked ovejamal-akwedyob. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tegin Jesús Simón-Pedroga chogalbal: —Imi an chunchunnad pega chogdo: imi pe machigin pe-itoleged aga pe mol yo, tegin pe-itoleged pe pia naddabal. Tenal pe sered kunonikil, pe nallakwa chakwa imakenab, tule pega mol yogal. Tegin pe-yapa-needzhe, tule pe-chedmalbalo. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tenal Jesús-Pedroga-chogzhad choglejundo, Pedro kalejal, tulemal Pedro-mesnemal. Tenal Pedro weob purkwene Pab-nug otummogal. Tegin Jesús Pedroga chogalbal: —Tenal pe melle an-igeo, tenal pe keg-chulgu anpak naiguo. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tegin Pedro akpiridgu, takal, Jesús-e-chapin-pul-tar-pilaled e-cholbal tanimo. Tenal we chapin-Jesús-cholbal-tanikid, akpene Jesús napi mas kunchiun, Jesús-abir chigujad-tule, tegin we chapin Jesúszhe ekichis-kusbalid: “¿Tummad, toa manibal-pegin-akpinnoniko-ade?” ");
INSERT INTO kvnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tegin Pedro we chapin-tanikid-takchagu, Jesúszhe ekichial: —¿Tummad, pe igi we tule-imanemo-wede? ");
INSERT INTO kvnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tegin Jesús Pedroga chogal: —Imi an peielen, we tule an-tanikoedzhe ampa tula kudii, anka ampa iwen-kwen-akalzhulin. Wedin pe-ib-chul pe wegin yolegal. Tenal pe keg-chulgu anpal-naiguoed-wilub. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Imi Jesús Simón-Pedroga weob chogzhadgin, kwenadgan-abalgin kaka nononi, we chapin-Jesús-cholbal-tanikid kwen purkwenejul. Tenal Jesús kwen chogzhajul, we chapin kwen purkwenejul. Tenal Jesús unnila chogzhado: “An peielen, we chapin an-tanikoedzhe ampa tula kudii, anka ampa iwen-kwen-akalzhulin. Wedin pe-ib-chul pe wegin yolegal.” ");
INSERT INTO kvnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tenal we chapin-Jesús-cholbal-tanikid, wedin an. Tenal antin, an pel-kwapa immal takchadbal, we immalmal-kujadgin an chunmas, tegin an pél nermasbaldo. Tegin an wisbaldo, pél-an-pega-chogzhaddin, wedin ib-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Imi Jesús ichejul immal-pimalad imadi-kus. Tenal tule Jesús-immal-imajad-ilbal pél nermakalen, an chogdé, iti-nap ampa kwen unniguojulin, we karta-nermakaled chabogal. Pitogua.");
INSERT INTO kvnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tummad-Teófilo, imi antin akpene pega pato pél nermas, Jesús megwijadgin immal imajad, tegin Jesús tulemal-oturdajadbal, Jesús Pab-negzhe nakwijadzhe. Imi Jesús Pab-negzhe-nakwijad-akar an ukin pega nermanebal kwenamaladgin immal kujad. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Imi Jesús ampayo Pab-negzhe needdu, Pab Purpa Nuedbal pela-pela e-nuggin-palmilegalmalad-uanais. Tenal Jesús-nuggin-palmilegalmalad akpene-Jesús-tar-chusmalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tegin Jesús e-purkwijad-cholbal, e-chapinganga kannan-kannan nodi-kus. Tegin Jesús aga e-chapinganga nuekwa oyos, ede chunchunnad kannan tulles. Tenal Jesús kannan-tullejad-akar ni-walgwen-eg-ibaambe nanedi-kus, aga e-chapinganga impa-impagin nononida, e-chapinganga Pab-neg-takmaidgin chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Imi teun Jesús e-nuggin-palmilegalmaladbak ampa ormabukwadgin, Jesús e-nuggin-palmilegalmaladga chogal: —Imi an pemalga chogmaldo: pemal melle Jerusalén-akar aknigwelmalo. Tenal pemal abintamalo, Pab Tummad anpal-pemalga-kaka-ukchadyob, pemalgin Pab-Purpa-Nued-nonikoedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Imi Juan Bautista chunchunnad tiginbi unnila tule-okcha, tenal pemal nue-naojulmal Pab Purpa Nuedgin oglenonimalo. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Al Jesús e-chapinganbak ormabukwadgin, e-chapingan Jesúszhe ekichialmal: —¿Tummad, tegil we ibegin pe neg-takegal Israel-tulemal-imane? ");
INSERT INTO kvnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tegin Jesús aga e-chapinganga chogal: —Pemal keg we immalmal wisguel, ibi-ibegin kunoniko. Tenal Pab Tummad chogzhado, ebi unnila igal-nika ede inkwa Israel-tulemal-neg-taknoniko. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tenal Pab Purpa Nued pemalgin nonikil, pemal Pab-kannaleged nikunonimalo. Tegin pemal ankin chunmadamalo, Jerusaléngin, pel-kwapa Judea-napkin, pel-kwapa Samaria-napkin, tegin nap-naid-ugakche. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tegin Jesús aga e-chapinganga pél chunmasgu, e-chapingan ampa Jesús-takpukwadgin, Jesús nikpa nakwidzhun. Tegin Jesús mogil-impabal togdegu, e-chapingan Jesús-pal-kwen-takchajulmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tenal Jesús-e-chapingan ampa nuu Jesús-takpukwadgin, arpak walbo tule-takalmal, e-abir pukwamal. Tenal we tulemal mol-chibu yoyomal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tenal we angelmal Jesús-e-chapinganga chogalmal: —Galilea-tolgan, ¿ibi pe nuu nikpa takmal wedega? Imi Jesús-pemal-abalgin-kudigujaddin, imis Pab-negzhe nad. Imis pe igi nikpa-nad Jesús-takchámaldin, Jesús kujal ampa weopí kannan iti-napche nonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tegin Jesús-e-chapingan Olivo-yal-nugad-akar algu, Jerusalénzhe nonimal. Tenal Olivo-yal Jerusalén-akar twagdar pannajul, unnila minuto-ambe-naneed-panku. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tegin Jesús-e-chapingan Jerusalénzhe nonigu, akpene neg-nikpa-ampagusmaladgin kannan ampagunonimalbal. Tenal te neggin Jesús-e-chapingan ampagunonimalad: Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo-machi-Jacobo, Simón-Romano-tule-onobied, Jacobo-machi-Judas. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tegin te neggin Jesús-e-chapingan, tegin María-Jesús-e-nan, tegin ome-pimalad, tegin Jesús-e-urpamal pel-kwapa pinzheed-ilgwenadgin pulakwa Pabzhe kolbukmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Imi teun kwenamalad-tulanerkwa-kuchale ormabukmal. Tegin Pedro kwenamalad-pukmaladga chunmakal chogal: ");
INSERT INTO kvnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kwenamalad, imi akpene Pab Purpa Nued Davidbal Judas-Iscariotegin chunmas. Tenal Pab-kartagin-Judasgin-chunmalejad-yopí kued-wilub. Tenal Judas-Iscariote tulemal-iktuedga kus Jesús-kagal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tenal Judas anmal-pakadmogan, anmal-arpagedgin arpagalmogan. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Imi Judas Jesús-ukchad-manigin, nap pakcha. Tegin Judas nikpa-akar sortukin nai arkwatku, sabal marid. Tenal Judas-e-samur pel-kwapa akne-akne miles. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tegin tulemal-pel-kwapa-Jerusaléngin-mamimalad, Judas-nap-pakchad wisgusgu, apka-pakal we nap nug onosmal, Acéldama. Wedin e-kakagin chogle: Abe-Nap.) ");
INSERT INTO kvnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Tenal Judasgin pél immalmal kujad, Pab-namaked-kartagin pato nermakal maido: Imi we tule-e-neggin tule melle ampaguelen, nabirin; tegin we neg metmalalen, nabirbalin, we tule-e-nug ilgwen pelgugal. Sal. 69:25 “Tegin Pab-kartagin chogbal: Tule-pid we tule-anal tummadga togenab. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Al anmal tule-walgwen-amienabmal, Judas-anal anmal-pakadga kugal. Tenal we tule anmalbak mes Jesús-kannan-tullejadgin, tulemalga chunmagal. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Al we tule-chulegoed Juan-tigin-Jesús-okchad-akar Jesúsbak pipirmadi-kujad, Jesús nikpa Pab-negzhe nadedzhe. Al we tule-chulegoed tulemalga pul-nabir Jesús-kannan-tullejadgin chunmanoniko.” ");
INSERT INTO kvnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tegin tule-Pedro-itobukmalad walbo tule-amismal. Walgwen nug José, tegin pimalbal Barsabás-Justo; tegin kwéntin nug Matías. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tegin tule-pukmalad Pabzhe kolalmalgu, Pabga chogalmal: —Pabye, imi pedin wiis we tule-walbogwad igi aga ulubgin pinzhenanimalye. Imi pe anmalga chogoye, piti-we-walbogwad pe chuo, Judas-anal toggalye. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tenal we tule pe chuo anmalbak mes arpagal, tegin Jesús-nuggin-palmilegalidga toggalye. Imi Judas Jesúsgin-akpijadbal aga tukin arpaged owes. Tegin Judas Jesúsgin-walmajadbal cho-chagla-negzhe tognadye. ");
INSERT INTO kvnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tegin tulemal-pukmalad pél Pabzhe kochamalgu, wilub takalmal, toa-tule-walbogid Jesús-nuggin-palmilegalidga togo. Tenal takalgu, Matías Barsabásgin nakwis. Tegin Matías Jesús-nuggin-palmilegalidga togzhamojun. Tegin Matías walambe-kakagwenchakkwad-e-pakadga kunonimojun. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Imi Pentecostés-Itoged-e-ibegin Jesús-e-chapingan ampa tulanerkwa-kuchale pulakwa pukwamalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tegidgin Jesús-e-chapingan arpak nikpa-akar purwa-tummad-kolomadanikidyob urma immal itogalmal. Tegin neg-yabalidzhe-pakal pél urma-pes. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tegin tule-Jesúsgin-turdananimalad takalmal, immal-cho-kaedyob aktenoni. Tegin immal-cho-kaedyob-aktenonikid tule-Jesúsgin-turdananimalad-ilbal titismadgu, tule-Jesúsgin-turdananimaladgin pél naigus-nemal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tegin Jesúsgin-turdananimalad-pel-kwapa-pukmalad pela-pela Pab-Purpa-Nued-nikunonimal. Tegin tule-Jesúsgin-turdananimalad Pab-Purpa-Nued-chogedbal kaka-pimaladgin chunmakalmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Imi teun takalgu, Judiomal napa-pimalad-ilbal-akar Jerusalénzhe nonimal. Tenal Judiomal-nonimalad Pab-Tummadgin-pirkin-pinzhemalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tenal Judiomal-nonimalad urma immal itosgu, pulakwa ampagunonimal. Tegin Judiomal-nonimalad-ilbal itosmalgu tule-Jesúsgin-turdananimalad emal-kakagin chunmananimal, mag itojul-pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tenal Judiomal-nonimalad arpakaal kalesmal-choggu, al weob pakal pesmalzhun. Tegin Judiomal-nonimalad aga emal-emal chunmakalmal: “¿We tulemal-chunmananimaladde, Galilea-tolganmalzhulzhí? ");
INSERT INTO kvnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tede igijun? Imi we tulemal anmal-kaka-mimmilejad-ilbal chunmananimal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","“Tenal anmal-pukmaladdin, kwen Partia-tol, kwen Media-tol, kwen Elam-tol, kwen Mesopotamia-tol, kwen Judea-napkined, kwen Capadocia-tol, kwen Ponto-tol, kwen Asia-tol, ");
INSERT INTO kvnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kwen Frigia-tol, kwen Panfilia-tol, kwen Egipto-tol, kwen Libia-Cirenezhikid-tol, kwen Roma-akar-tanimalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Tenal tulemal-chogbo nonimalmo, kwen Judio-chunnad, kwen tule-Judio-igalgin-togzhamalad.) Tegin anmal kwen Creta-tol, tegin Arabia-tolgan itobukmalmo. Tenal we tulemal anmal-kaka-ilbal Pab-immal-taktijulmaladgin chunmananimal.” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Al tulemal-itobukmalad weob pakal pesmal, tegin tulemal mag itojul-pesmalbal. Tegin tulemal-kwénna-kwénna, aga emal-emal chunmakalmalbal: —¿Wegidde, ibi chogle-wede, tule-kaka-ilbal chunmakeddé? ");
INSERT INTO kvnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tegin tule-pimalad tule-Jesúsgin-turdananimaladgin todoalmal chogalmal: —We tulemal vino kobnanimal, al mumurmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tegin Pedro Jesús-e-chapingan-walambe-kakagwenchak-abalgin okwichial. Tegin Pedro tulemal-itobukmaladga sapejul chunmakal, chogal: “Nabirdo. Imi pemal anmal-tulemal, tegin Jerusaléngin-pel-kwapa-pukmalad, imis an pemalga chogneed, pe nuekwa itomalo. Imi an pemalga wisgal chogdo: ");
INSERT INTO kvnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","imi pemal ebinzhemal anmal-chunmasmaladde mumurmal. Chulá. Anmal kwen mumurzhulmal. Imi neg ampa wachilbakebak nai, ¿tede, anmal igi mumurgumalo? Keg kue. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Imi pe imis-immalmal-takchad, akpene Pab-kaka-palchoged-Joel-chogzhadyob kusdo: ");
INSERT INTO kvnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Imi Pab Tummad chogdo: ‘Imi neg-tuku omodanikil, antin tulemalgin pel-kwapa An-Purpa-Nued-odeo. Tegin pe-machimal, tegin pe-punamal an-kaka palchogmalo. Tegin machimal imia-akpuredgin immal takmalo. Tegin tule-chelegan kabdakedgin immal taknonimalmogo. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Imi an pemalga chogbal: an te ibegin mos-machergangin tegin mos-omegangin An-Purpa-Nued-odeo. Tegin we tulemal an-kaka palchogmalo negde igi kujal kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tegin an mogilbal immal-taktijulmalad oyogo. Tegin an iti-napkin immal-taktijulmalad oyomogo; abe, cho, tegin wa pél neg-kao. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tegin tadgwa akinnoniko, neg-chichidbi pél peio. Tegin nidin abeyob kunoniko. Tegin we immalmal-kujad-cholbal kep Pab-ibe noniko; ibe-pul-chunchoged, pul-yer-takleged. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tenal meke-ibi-tule Pab-abingejogalidgin Pabzhe kolalil, we tule abonolenoniko.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tegin Pedro chogalbal: “Israel-tulemal, pemal nuekwa an-itomalo, imis an pemalga immal chogneed. Imi pemal nued wismal, Jesús-Nazaretkined pemal-abalgin Pab-Tummad-nug-kannalegedgin immal-taktijulmalad imas, pemal mag takegal ede toa-tule. Tegin Jesús-immal-taktijulmalad-imajadbal Pab Tummad oyos, Jesús-immal-chogzhad ib-chunchunnad, ib-kakanzhul. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Imi Pab Tummad akpene igal-mezhis, Jesús purkweenab. Al Pab Tummad iktualeba wiis, Jesúsgin igi kunoniko. Al Jesús pemalga ukles. Tegin tule-iskana-pemal-pentajadbal pemal nakrusgin-Jesús-piokchamaladgin, Jesús-mechamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tenal Pab Tummad purkwaled-nunmaked-akar Jesús-otulos. ¿Tenal Jesús ibiga kannan tulles pe ebinzhe? Nabir. Imi Jesúsgin tule-purkwed keg nakwe-kujadbal weob kusdo. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Tenal Errey-David akpene Jesúsgin chogzhagusdo: An pane-pane Pab-Tummad-taktigu an-nuedzhik chii, an-pentagal. Al an ulubgin akalzhul-ito. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Al an ulubgin weligwal-itogedbal, an namakalda. Pab Tummadye, imi an wisdo ");
INSERT INTO kvnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","pedin uangin an-chan-kwen-ebeojul, tegin pe igal-kwen-ukojulbal, Pe-Tule-Napírragwad-e-chan nungugalye. Tegin an kwen penzhulbal, an purkoedgin an-chan kwen pelguojulye. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tenal pedin igal-nued-wisgugal an-imas, an melle pulzhuli purkwegalye. Teginbal, an pe-assapin pela-pela yer weligwal-itogalbalye.” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tegin Pedro chogalbal: “Kwenamalad, imi an pemalga pakal-pud chogne. Imi David, aga tukin kwen chogzhajul e-chande kwen nunguojul. Tenal anmal nued wismaldo, anmal-tad-David inkwagus pato purkwis. Tenal David purkwisgu, tulemal tar-tigzhamal. Tegin anmal ampa wismalbal, David-e-uande pia mai. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Tenal David, Pab-Tummad-kaka-palchoged-tule. Al David wisdo, Pab Tummad e-nuggin Davidga kaka-ukcha, David-wagwagan-walgwen Davidyob tule-tummadga kuo neg-takegal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Al David iktualeba immal-takchadyob Cristo-Pab-akpene-chogzhad-palmidagoed-tulegin chunmas. Imi David chogzhado: ‘Cristodin kannan tullego.’ Tegin David chogzhabal: ‘Imi Cristo-e-purpadin, uangin kwen peiojul; tegin Cristo-e-mui kwen nunguojulbal.’ ");
INSERT INTO kvnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Tenal Jesúsdin Pab Tummad purkwaled-akar tar-otulos. Tegin anmal-pel-kwapa Jesús-kannan-tullejad-takchamalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Al Pab Tummad Jesús-otummos e-abir-nuedzhik tule-tummadga chiggal. Tenal Pab Tummad Jesúsga kaka ukchadyob, Jesús Pab-Purpa-Nued-abingas. Tegin Jesús anmalgin pela-pela Pab-Purpa-Nued-odesmo. Al Pab-Purpa-Nuedbal, anmal-imis-chogzhiid, tegin anmal-imis-immal-imanaid pemal takpukmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tenal Errey-David Pab-negzhe kwen arpijul. Tenal David yabli chogzhado: Pab Tummad an-Tummadga chogzha: ‘Pe an-nuedzhik chigo; ");
INSERT INTO kvnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tenal antin pebak-aichulmaladgin-nakwegal pe-imako, tule nag-onakwed-kanyob.’ ” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tegin Pedro chogalbal: “Imi Israel-tulemal-pel-kwapa nuekwa wisgugal, an pemalga chogdo: imi pemal nakrusgin Jesús-piokchamal. Tenal Pab Tummad Pul-Tule-Tummadga Jesús-odos, tegin Pab-akpene-chogzhad-palmidagoed-tulega Jesús-odosbal. Pitomalgua.” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tegin tule-itobukmalad Pedro-chogzhad itosmalgu, aga ulubgin peyedzhe pukib-itogalmal. Tegin tule-itobukmalad Pedroga, tegin Jesús-nuggin-palmilegalmalad-pimaladga chogalmal: —¿Kwenamalad, anmal igi imakel nabirzhun Pabbak igal-nudagal? ");
INSERT INTO kvnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tegin Pedro tulemalga chogalzhun: “Imi pemal iskued-nikadbal, pe pukib-itogenabmal, tegin pemal-ilbal tigin Jesucristo-nuggin oglegenabmalbal. Imi an-pega-chogzhadyob pe imasmalal, Pab Tummad pega iskued-pelgus chogo. Tegin Pab Tummad pemalga E-Purpa-Nued-uknonibalo. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Tenal Pab-Tummad-we-kaka-ukchad, pemalgabijul, tenal pemal-wagwaganga tegin tule-Pab-akar-panna-kudimaladga Pab kaka-ukchamo. Imi wedin choglejundo, Pab Tummad e-itolegedbal pel-kwapa-tulemalzhe-kolbiedga.” ");
INSERT INTO kvnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tegin Pedro tulemalga chowimakal Jesúsgin chunma-kwichidgin, kannan-kannan tulemalga chognaigual: —Imi pemal Jesús-abingeedbal aga tukin abonogenabmal melle tule-iskan-imis-pukmaladbak sapejul oturdalenonigal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tegin tulemal-yer-Pedro-chunmajad-itosmalad Jesús-abingasmalgu, tigin Jesús-nuggin oglesmal. Tenal teun Jesúsgin-turdananimaladbak tule-milipá mes naigunonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tegin tule-Jesúsgin-ibzhemalad, pane-pane Jesús-nuggin-palmilegalmalad-e-oturdaked-pallí kudimal. Tegin tule-Jesúsgin-ibzhemalad aga aiyagwal tigusmalbal. Tegin tule-Jesúsgin-ibzhemalad aga pulakwa mas kunpuktamal, tegin pulakwa aga Pabzhe kolaldamalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tenal tulemal-pel-kwapa immal-kujadgin weob pakal pesmal. Tegin Jesús-nuggin-palmilegalmalad ichejul immal-taktijulmalad imasmalbal wilub oyogal, Jesús-igalde ib-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tegin tule-Jesúsgin-ibzhemalad pel-kwapa pulakwa tigusmalzhun. Tenal Jesúsgin-ibzhemalad egatpígwadyob pel-kwapa immalmal-nikad kwen takchajulmal, pel-kwapa kwenamaladgadyob immalmal takchamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tegin tule-Jesúsgin-ibzhemalad manigin aga egad-egad nagnu ukchamal, tegin kwen manigin immalmal-pimalad ukchamalbal. Tegin tule-Jesúsgin-ibzhemalad aga emal-emal Jesúsgin-ibzhemalad-immal-napimaladga mani ukchamal, aga unnigualedzhe. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tegin tule-Jesúsgin-ibzhemalad pane-pane Pabzhe-koled-neggin yopí ilgwenadgin pinzhebukmal. Tegin tule-Jesúsgin-ibzhemalad muchub-muchub neg-ilbal, aga ulubgin weligwaledgin, yer-itogedgin aga masgin okunpukmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tegin tule-Jesúsgin-ibzhemalad Pab-otummodi-kusmalbal. Tegin tulemal yer tule-Jesúsgin-ibzhemalad-takchamal. Tenal Pabdin pane-pane tule-abonolesmalad-omelomai, tule-Jesúsgin-ibzhemaladbak mes naigugal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Imi te ibagwengin, Pedro Juanbak, wachilapágin Pabzhe-koled-wachigin, Pabzhe-koled-negzhe nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Imi teun takalgu, Pabzhe-koled-neg-wanagak-Nugu-takleged-nabal, tule-walgwen mellejii. Tenal we tule mimmilejad-akar-keg-naneed. Tenal tulemal kusgu pane-pane tule-iwigual-mimmilejad-cheinonidamal, tule-ukpomamimaladzhe mani wis ekisgal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tegin tule-keg-naneed takchagu Pedro Juanbak Pabzhe-koled-neg-yabal tognatap, Pedroje tegin Juanzhe kolal: —¿Anka pe wis mani ukojí? ");
INSERT INTO kvnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tegin Pedro Juanbak nuu tule-keg-naneed-taktegu, Pedro tule-keg-naneedga chogal: —Pe an-takkweldo. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tegin tule-keg-naneed Pedro-ega-chogzhad itosgu, Pedroje atad. Tenal we tule ebinzhe Pedromal ega mani ukne. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tegin Pedro tule-keg-naneedga chogal: —Tenal an ol pel nikchul, tegin an mani pel nikchulbal. Tenal an immal nikadbi, an pega ukne. Al an Jesucristo-Nazaretkined-nuggin, an pega chogdo: pe kwisgu, pe nane. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tegin Pedro tule-keg-naneedga weob chogzhagu, chunkal-nuedzhik tule-keg-naneed-kas, tegin we tule-okwichis. Tegin we tulega ilgwen kammete nugus tegin e-nag nugusbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tegin tule-keg-naneed ilgwen ichomadgu, yok kwisgus. Tegin we tule ilgwen nabir nane-pes. Tegin tule-keg-nane-nad ichomakal-ichomakal Pab-otummoalgu, Pedromalbak mes Pabzhe-koled-neg-yabal togzhamojun. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tegin tulemal-pel-kwapa-pukmalad takchamal tule-nugujad kanamadii tegin Pab-otummodibal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tegin tulemal chogalmalbal: “We tulede pane-pane Pabzhe-koled-neg-wanagak-Nugu-takleged-nabal mani-ekichi-taed-taklebali.” Tenal tule-takpukmalad tule-keg-naneed-nugujad-takchamalgu, weob pakal pesmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tegin tule-keg-naneed nugusgu, Pedro-tegin-Juan-pel-ebebijul-kual. Tegin tulemal keger tule-nugujad-takchamalgu, neg-ubeb-Salomón-nugadzhe Pedromalzhe abarmadmal takegal igi kus. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tegin Pedro takchagu tulemal-eje-abarmanonimal, Pedro tulemalga chogal: “Israel-tulemal, ¿Ibiga pe keger we tule-takmal-wede? ¿Ibiga pe nue anmal-takmalbal-wede? ¿Pemal ebinzhemal anmal naga kannalegedgin tegin anmal pirkin-Pabgin-pinzheedbal we tule-nudas? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Imi an pemalga nuekwa chognejun, igi kus. Imi Pab Tummad Abraham, Isaac, Jacob, tegin anmal-pabgan-e-Pab-Tummadga mai. Tenal Pab Tummad pul-tule-tummadga tule-ega-arpaged-imas. Wedin Jesús. Tenal pemal Pilatoga Jesús-ukchamal mesgal. Imi teun Pilato Jesús-onobi-kujan, tenal pemal chogzhagusmal: ‘Melle Jesús-onogo.’ ");
INSERT INTO kvnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tenal Jesús tule-chwilidikid, tule-napírragwad. Tenal pemal Jesús-onogal kwen imaszhulmal. Tenal pemal Pilatoje tule-mechad-ekichismal pemalga onogal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tegin pemal anmal-otulojiid-e-ibed-mechamalbal. Tenal Pab Tummad purkwal-maid-akar kannan Jesús-otulos. Tenal anmal Jesús-kannan-tullejad-e-takchamalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Tenal Jesús-nugdin kannaleged nika. Tenal we tule-pe-takchiid, pemal mag takmal. Tegin we tule Jesúsgin-penzhulidbal nugunoni. Tenal Jesús-e-nug-kannalegedgin tegin Jesúsgin-penzhulidbal we tule pel-kwablekwá nugus. Imi pe takmaldo we tule pe-assapin nued kwichi.” ");
INSERT INTO kvnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tegin Pedro chogalbal: “Kwenamalad, imi an wisdo, pemal immal-kwen-wichulidgin Jesús-mechamal, tegin pe-tummagan ampamo. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tenal akpene Pab Tummad e-kaka-palchogmaladbal chogzhad-yopí, Cristo-Pab-akpene-chogzhad-palmidagoed-tulegin kus. Al Jesús weob purkwisdo. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Al pemal aga iskuedgin pukib-itogenabmal, tegin pe Pabzhe tagenabmal Pab pemalga iskued eligal, meke Pab Tummad pemalga tamipa-neg-itoged palmidago. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","“Imi akpene Pab Tummad Cristo-nugzhas pemalga palmidagal. Wedin Jesús. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tenal Jesucristo Pab-neggin megweenab, Pab Tummad pél kannan neg-nudagedzhe, Pab akpene e-kaka-palchoged-chwilidikmaladbal chogzhagujadyob. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tenal Moisés anmal-tadganga chogzhado: Pe-Pab-Tummad, pe-tulemal-akar, tule-e-kaka-palchoged-walgwen-odogo, anyob kunoniko. Tenal we Pab-kaka-palchoged-chogzhad, pél pe itogenabmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tenal meke-ibi-tule we Pab-kaka-palchoged-itojulil, e-tulega pal kwen kuojul, ilgwen pelguodo. Dt. 18:15, 18-19 Imi Moisés-we-tulegin-chunmajad. Wedin Jesús.” ");
INSERT INTO kvnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tegin Pedro tulemalga chogalbal: “Tegin Samuel-akar ukin, Pab-kaka-palchogmalad pel-kwapa Pab-akpene-chogzhad-palmidagoed-tulegin chunmadi-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tenal Pab Tummad e-kaka-palchogmaladbal kaka-ukchaddin ampa pemalgadmo. Tegin Pab Tummad pe-tadganbak aga kaka-ukchamaladdin ampa pegadmo. Tenal Pab Tummad Abrahamga Jesúsgin chogzhado: Imi pe-wagwabal pel-kwapa-tulemal-ilbal ib-nuedga kunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Tegin Pab Tummad tule-ega-arpaged-Jesús-otulosgu, pemalga inzhel Jesús-palminoni, pemalga ib-nuedga kugal, pemal melle immalmal pal akalogalmal. Pitomalgu.” ");
INSERT INTO kvnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tegin Pedro tegin Juan ampa tulemalga chunmanaidgin, tule-irwal-Pabzhe-kolmalad tegin e-chulub-tummad tegin Saduceomal Pedroje tegin Juanzhe nonimal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Imi teun takalgu, Pedro tegin Juan tule-purkwaled-Jesúsbal-kannan-tullegoedgin tulemal-oturdananimal. Al tulemal-nonimalad sae-pakal Pedro-tegin-Juan-taknonimal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tegin tulemal-nonimalad Pedro-tegin-Juan-kasmal. Imi teun neg pato chedodani-choggu, al tule-nonimalad oturdaleged-neggin Pedro-tegin-Juan-odosmalzhun, panzhe Pedroga tegin Juanga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tenal tulemal-Pedromal-itosmalad ichejul Jesucristogin ibzhenonimal. Imi teun takalgu, Jesucristogin-ibzhasmalad-macherganbi, miliatal kunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tegin te pangin, Judio-saglagan tegin Judio-chelegan-tummagan, tegin Moisés-igalgin-tule-oturdamalad Jerusaléngin ormasmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Imi teun Anás tule-irwal-Pabzhe-kolmalad-pul-tummad chimo. Tegin Caifás, Juan, Alejandro, tegin tule-irwal-Pabzhe-kolmalad-pul-tummad-e-kwenamalad-pimalad pukwamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tegin chulubmal tule-tummagan-abaladzhe Pedro tegin Juan-cheinonimal. Tegin tule-tummagan Pedroje tegin Juanzhe immal ekichialmal: —¿Ibi-kannalegedgin o toa-nuggin, pe tule-nudas-wede? ");
INSERT INTO kvnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tenal Pedro pela-pela Pab-Purpa-Nued-nika-choggu, al Pedro tule-tummaganga chogalzhun: “Tule-tummagan tegin chelegan-tummagan, pemal Judiomal-neg-takpukmalad, ");
INSERT INTO kvnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","imi an we tule-keg-nane-nadga ib-nued imajad, pe wisgubimal-choggu, al an pemalga palchognejun, we tule igi nugus. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","“Imi pe takto, we tule-anmalbak-kwichid pato nugus, akalzhul kannamadii. Imi an pemalga tegin Israel-tulemalga pel-kwapa nuekwa chognejun. Imi pemal Jesucristo-Nazaretkined-mechamal. Tenal Pab Tummad kannan tar-otulosbal. Imi Jesucristo-kannan-tullejad-nuggin, we tule nugunoni. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Imi pemal Jesús meted, tenal imidin Jesús pul-tule-tummadga kunoni. Imi Pab-kartagin chogdo: Imi tule-neg-chobmalad akwa-mete. Tenal akwa-meted pul-akwa-chunchogedga kunoni. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Tenal tule-pid ukin pal nikchul tule-abonogal melle Pab Tummadzhe sapejul oturdalegal. ¿Ibiga an teob chog? Imi Pab Tummad, iti-napkin tule-pidga igal-kwen-ukchajul anmal-abonogal, tenal anmal unnila Jesús-nugginbi, nabir abonolenonimalo melle Pab Tummadzhe sapejul oturdalegalbal.” ");
INSERT INTO kvnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tegin tule-tummagan takchagu Pedro tegin Juan tobzhulidgin chunmananimal, weob pakal pesmal. Imi teun takalgu, tule-tummagan mag takchamal Pedro tegin Juan tule-polgana, tule-nue-turdakalzhulmalad. Tenal tule-tummagan kep mag taknonimalzhun Pedro tegin Juan, Jesúsbak-mes-kudigusmalmogad. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tenal tule-nugujad Pedromalbak mes kwichimo. Al tule-tummagan keg kwénna Pedroga tegin Juanga immal choggusmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tegin tule-tummagan ormaked-neg-akar Pedro tegin Juan-onosgu, cholbal aga emal-emal igal-itonani-pesmal, ");
INSERT INTO kvnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tegin tule-tummagan aga emal-emal chogalmal: —¿Anmal igi we tulemal-imakel nabir? Imi tulemal-Jerusaléngin-pukmalad pel-kwapa wismal, we tulemal peyedzhe immal-taktijulid imasmal. Tenal anmal keg chogel, teob kwen kuszhul. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tenal tule-pimalad we immalmal-kunaid melle wisgumalgal, anmal kantikidgin Pedroga tegin Juanga chogenabmal: ‘Pemal imis-akar melle Jesús-nug pal obiro.’ ");
INSERT INTO kvnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tegin tule-tummagan pél aga igal-itosmalgu, kannan Pedroje tegin Juanzhe kochamalbal. Tegin tule-tummagan Pedroga tegin Juanga chogalmal: —Pe imis-akar melle tulemalga Jesúsgin pal chunmako. Tegin pe melle tulemal-pal-oturdabalo, Jesús-nuggin. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tegin Pedro tegin Juan tule-tummaganga chogal: —¿Imi igi pe ebinzhemal? ¿Pab Tummad pul yer anmal-tak pemal-chogzhiid-pallí nanegal o Pab-Tummad-chogzhad-pallí nanegal? Pe anka chogdo. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tenal anmaldin keg-chulgu imial Jesús-takchamaladgin chunmakenabmal, tegin anmal ual Jesús-chunmajad itosmaladgin chunmakenabmalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Tegin tule-tummagan kannan kantikidgin Pedroga tegin Juanga chogalmalbal: —Pe melle Jesús-nuggin tulemal-pal-oturdako. Tenal pe anmal-choged-pallí ib-imaszhulmalal, anmal oturdaleged-neggin pemal-odonemal. Tenal tule-immal-taktijulidgin-nugujad, pirka-tulabo-kwena nika. Al tulemal-pel-kwapa Pab-Tummad-otummosmal. Al tule-tummagan igal-kwen-amiszhulmal sapejul Pedro-tegin-Juan-oturdagal. Al tule-tummagan yabli Pedro-tegin-Juan-onosmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tegin Pedro tegin Juan tule-tummagan-akar nosmalgu, e-pakamaladzhe nadmalzhun. Tegin Pedro tegin Juan e-pakamaladzhe nonimalgu, pel-kwapa tule-irwal-Pabzhe-kolmalad-e-tummagan, tegin Judiomal-chelegan-tummagan ega-chogzhad palchogzhi-kualzhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tegin Pedro pél chunmasgu, kwenamalad-pel-kwapa-pukmalad pulakwa Pabzhe kolalmal chogalmal: “Pabye, pedin Pul-Tule-Tummadye. Tegin pedin nikpad-neg-opinnis, tegin nikpad-neggin pel-kwapa immal-nikad opinnisbalye. Tegin pe iti-nap-opinnis, tegin iti-napkin pel-kwapa immalmal-nikad opinnisbalye. Tegin pe termal-nazhis, tegin pe termalgin pel-kwapa immalmal-nikad, opinnisbalye. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","“Pabye, imi pedin Pe-Purpa-Nuedbal pe-mos-anmal-tad-Davidbal chogzhaye: ¿Judiojulmalad ibiga urwebi-itomal-wede? ¿Ibiga tulemal pane-pane pinche aga igal-aminanimal Pab-Tummad-abin-kwisgugalye? ");
INSERT INTO kvnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Imi erreymal tegin tule-tummagan-iti-napkin-neg-takmamimalad pulal nonimal, Pab Tummad tegin Pab-akpene-chogzhad-palmidagoed-tulegin abin-kwisgunonimalgalye.” Sal. 2:1-2 Tegin Jesúsgin-ibzhemalad Pabzhe-kolnaidgin chogalmalbal: “Imi David chogzhad-yopí kusye. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Pabye, imi pedin Jesús-chwilidikid-nugzhas pega arpagalye. Tenal Herode, Poncio-Pilato, Israel-tulemal tegin Judiojulmalad, iti-neg-kwebur-Jerusaléngin, pulal igal-amismal Jesús-mesgalye. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tegin pe akpene aga itolegedbal, pe-kannalegedbal pe-chogzhagujad-yopí, we tulemal Jesús-imasmalye. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Pab Tummad, pe takye, tule-tummagan kantikidgin anmalga chogzhamalye, anmal melle Jesús-nuggin tulemalga pal chunmakoye. Pabye, al pe anmal-pe-mosmal-wis-pentakoye, anmal tobzhulidgin pe-kaka-nuegangin chunmagalye. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tegin pe anmal-pentabaloye pega-arpaged-Jesús-chwilidikid-nuggin tule-nudagal; tegin pe-immal-taktijulmalad imagalbalye oyogal Jesús-igal ib-chunchunnadye.” ");
INSERT INTO kvnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tegin Jesúsgin-ibzhemalad Pedromalbak mes Pabzhe-kolnaid pelgusgu, tulemal-pukwad-neg pél tutumas. Tegin tule-pukmalad pela-pela Pab-Purpa-Nued-nikunonimal. Tegin tule-Jesúsgin-ibzhemalad tobzhulidgin Pab-kaka-nuegangin chunmadi-kualmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tegin Jesúsgin-ibzhemalad-pel-kwapa aga ulubgin yopí-pinzheed naigunonimal. Tenal tule-Jesúsgin-ibzhemalad aga kwen chogzhajulmal, we immalmal egad, tenal pulakwa aga egadyob immalmal takmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tegin Jesús-nuggin-palmilegalmalad Pab-Purpa-Nued-kannalegedgin tulemalga Jesús-kannan-tullejadgin chunmananimalbal. Tegin Pab Tummad pela-pela Jesúsgin-ibzhemalad-pentas pul-pule tule-pidgin pinzhemalgal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Al tule-Jesúsgin-ibzhemalad-abalgin keg chogel, immal kwen napimal, pél immalmal nikadbi. ¿Ibi-ulgin teob? Imi tule-Jesúsgin-ibzhemalad aga tukin manigin nap, tegin neg-ukchamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tegin tule-Jesúsgin-ibzhemalad Jesús-nuggin-palmilegalmalad-wagin pél immalmal-ukchad-mani cheinonimal. Tegin Jesús-nuggin-palmilegalmalad tule-immal-nikchulmalad-unnidzhe, we mani mimismal. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Imi teun takalgu, tule-walgwen-José-nugad maimo. Tenal Jesús-nuggin-palmilegalmalad we José-pimalbal: Bernabé. Tenal Bernabé chogle, yer-tulemal-okannoed-tule. Tenal Bernabé Leví-e-wagwagan tenal Chipre-tol. ");
INSERT INTO kvnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tenal Bernabé nagnu nika, tenal manigin aga nagnu ukcha. Tegin Bernabé Jesús-nuggin-palmilegalmalad-wagin pél we mani cheinoni tule-Jesúsgin-ibzhemaladga mimigal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Imi teun takalgu, tule-walgwen mai. We tule nug, Ananías. E-omedin nug, Safira. Imi we abirgin manigin aga nap ukchamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tenal Ananías aga abal nap-ukchad-mani chus. Tegin Ananías Jesús-nuggin-palmilegalmaladga pel-kwapa mani-ukchadyob abal mani wis cheinoni. Tenal Ananías-e-ome nued wismogando, e-macheredde abal mani otus. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tegin Pedro Ananíasga chogal: —¿Ibiga pe nia-Satanásga igal-ukcha-wede Pab Purpa Nuedga kakanzhegal? Imi pedin abal nap-ukchad-mani chus. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Imi pe yapa Pabga mani ukel, tede ¿ibiga pe aga nap ukchadé? ¿Ade napte pegadzhulzhí? Pedin nap uked-wilubzhulin. ¿Tenal pe-nap-ukchad-mani, ampa pegadzhulzhí? ¿Tede ibiga pe anka chognonide: ‘Antin weob karkegu nap ukcha?’ Tenal pedin anka choged-wiluban: ‘An abal Pabga mani wis cheidani.’ Imi pedin anmal-tulemalga pe kakanzhaszhul, pe Pab Tummadga kakanzhas. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tegin Ananías Pedro-chogzhad itosgu, ilgwen aglad. Tegin Ananías ilgwen purkwis. Tegin tulemal wisgusmalgu Ananías Pab-Tummadga-kakanzhajadbal Pab Tummad Ananías-mecha, al tulemal-pel-kwapa tobgualmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tegin machimal Ananías-mui aminonimalgu, molgin Ananías-ebirmasmal. Tegin machimal uanzhe Ananías-mui tignadmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tegin Ananías-purkwijad-cholbal wachilapágin, Ananías-e-ome nonimo. Tenal Ananías-e-omedin ampa wichul, e-macheredde, igi kus. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tegin Pedro Safiraje ekichial: —Imisgin anka pe nuekwa chogne: ¿Imi pe-machered anka mani-cheinonikid-un, pe nap ukchamalyé? Tegin Safira Pedroga chogal: —Teobdo. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tegin Pedro Safiraga chogal: —¿Ibiga pemal-walbogwad kakanzhasmal-wede Pab-Purpa-Nued-wilub-takegal? Imi pe tak, tulemal-pe-machered-tigdimalad irmadanimal. Tenal we tulemal, tiggal pe-chenemalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tegidgin Safira Pedro-abir agladgu, ilgwen purkwismo. Tegin machimal-Ananías-tigdimalad negzhe ukpononimalgu, pato Safira-taknonimal, purkwal mellemai. Tegin machimal uanzhe Safira-mui-chesmalmo tignegal. Tegin machimal e-machered-Ananías-tigalmaid-nabal Safira-tigzhamalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tegin Jesúsgin-ibzhemalad tegin tulemal-pel-kwapa-wisgusmalad, Pab Tummad tule-mechadbal peyedzhe tobgualmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tegin Jesús-nuggin-palmilegalmalad, tulemal-wagin íchejul immal-taktijulmalad oyolenaigual. Imi teun Jesúsgin-ibzhemalad pane-pane Pabzhe-koled-neg-ubeb-Salomón-nugadgin Jesús-igal-itodi-kusmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tenal tule-pimalad Pab-Tummad-tobedbal Jesúsgin-ibzhemaladbal pél naigubijul-kualmal. Tenal tulemal yabli yer Jesúsgin-ibzhemalad-takchamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tegin tulemal-ichejul Jesúsgin ibzhasmal, machergan omegan-ugakche. Al Jesúsgin-ibzhemalad pul melguszhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Al tulemal magarbal kachigin tule-yemalad-onismal. Imi tulemal pinzhealmal: “Imi Pedro we igalbal najal, tegin tule-yemaladgin e-purpa walmajal-dewa, we tule-yemalad ilgwen nuguo.” ");
INSERT INTO kvnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tegin tule-neg-kweburgan-Jerusalén-abir-pukmalad-ichejul nonimalmo. Tegin tule-nonimalad tule-yemalad, tegin nia-nikadbal peyedzhe wilemamimalad-cheinonimalmo. Tegin Pedro e-pakamaladbak pel-kwapa tule-yemalad-nudasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad, tegin e-pakamalad-Saduceomal, nobedbal sae-pakal Pedro-takalmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Al Judio-tummagan Jesús-nuggin-palmilegalmalad-kasmalgu, neg-kwebur-oturdaleged-neggin tar-odosmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tenal Pab-angel mutik oturdaleged-neg-wanagak egenoni. Tegin angel Jesús-nuggin-palmilegalmalad-onosmalgu, Jesús-nuggin-palmilegalmaladga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pemal Pabzhe-koled-negzhe nemalo, tegin pe tulemalga pél pe palchogo, tule-abonoleged-igal igi Jesúsbal mai.” ");
INSERT INTO kvnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tegin Jesús-nuggin-palmilegalmalad angel-ega-chogzhad itosmalgu, polegu Pabzhe-koled-negzhe nadmal. Tegin Jesús-nuggin-palmilegalmalad Pab-igalgin tulemal-oturdakalzhun. Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad tegin e-pakamalad pis aga ormanonimalmo. Tegin we tule-tummagan pel-kwapa Israel-tummagan-wala-tulapá-kakaambegwadzhe kocha igal-itogal. Tegin Judio-tummagan oturdaleged-negzhe chulubmal-palmis, Jesús-nuggin-palmilegalmalad-chedagal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tegin chulubmal oturdaleged-negzhe omosmalgu, pato taknatapmal Jesús-nuggin-palmilegalmalad taklejulmal. Tegin chulubmal kannan almalbalgu, tule-tummaganga chognonimal: ");
INSERT INTO kvnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Imi tulemal-sae-pe-kasmalad wakismal. Tenal oturdaleged-neg nued chaktigal chiin, tegin chulubmal wanagakkin nued takpukmalbalin. Tegin anmal yabal togzhamalgu, pato tule taklejulmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tegin Pabzhe-koled-neg-chulub-tummad, tegin tule-irwal-Pabzhe-kolmalad-e-tummagan chulubmal-chognonikid itosmalgu, mag itojul pesmal, chogalmal: —Imi tulemal-wakijadbal neg igi kunoniko wichul. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tegidgin, tule-walgwen tule-tummaganga chognoni: —Imi pe sae-oturdaleged-neggin-tule-odosmalad pato Pabzhe-koled-neggin Jesús-igalgin tulemal-oturdananimal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tegin tule-tummagan itosmalgu Jesús-nuggin-palmilegalmalad Jesús-igalgin tulemal-oturdananimal, chulub-tummad e-chapinganbak mes Jesús-nuggin-palmilegalmalad pukwadzhe nadmal. Tenal chulubmal tobgualmal, ebinzhemal, tulemal yer Jesús-nuggin-palmilegalmalad-takedbal, egin akwa midamalo. Al chulubmal nuekwa Jesús-nuggin-palmilegalmalad-kasmal. Tegin chulubmal kannan tule-tummaganzhe Jesús-nuggin-palmilegalmalad-cheinonimalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tegin chulubmal tule-tummagan-wala-tulapá-kakaambe-pukwadzhe Jesús-nuggin-palmilegalmalad-cheinonimalgu, neg-abaladzhe Jesús-nuggin-palmilegalmalad-okwichismal, tule-irwal-Pabzhe-kolmalad-pul-tummad tarzhe immal ekisgal. Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad Jesús-nuggin-palmilegalmaladga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿An pemalga chogzhajulzhí: pe melle Jesús-nuggin tulemal-pal-oturdako? Imi pemal Jesús-igalgin pel-kwapa tulemal-Jerusaléngin-pukmalad-oturdasmal. Tegin pemal anmal uka-odobi-kunani, anmal Jesús-mechamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tegin Pedro tegin Jesús-nuggin-palmilegalmalad-pimalad, tule-tummaganga chogal: “¿Imi an pemalbal pul ibzhao, an Pab Tummadga pul immal imagal? Chulá. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Imi pemal chowal-walgin Jesús-nazhismalgu, pe tar-mechamal. Tenal Pab-Tummad-anmal-tadgangad purkwal-maid-akar Jesús-otulos. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Tegin Pab Tummad Jesús-otummosgu, e-nuedzhik Jesús-chisbal. Tegin Pab Tummad tule-neg-taked-tummadga tegin tule-abonoedga, Jesús-odosbal, Israel-tulemal e-iskuedgin pukib-pinzhegal, tegin Pab Israel-tulemalga iskued pelgus choggalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“Imi anmal nued takchamal Jesúsgin igi kus. Al anmal wegin chunmananimal. Tegin Pab Purpa Nued ampamo. Imi Pabdin tule-yer-e-pallí-tamaladga E-Purpa-Nued-ukcha.” ");
INSERT INTO kvnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tegin tule-tummagan itosmalgu, Jesús-nuggin-palmilegalmalad igi chogmal, we tulemalzhe ulualmal. Tegin tule-tummagan Jesús-nuggin-palmilegalmalad-mesbi-kualmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Imi teun takalgu, tule-tummagan-wala-tulapá-kakaambegwad-walgwen chimo. We tule nug Gamaliel. Tenal we tule Pariseo tegin Moisés-igalgin-tulemal-oturdaked. Tenal tulemal Gamalielgin chogmal: “Gamalieldin pirkin-immal-wijiid-tule.” Tegin Gamaliel ormakedgin chogal: —Pe magadbal we tulemal-onigwelo. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tegin Jesús-nuggin-palmilegalmalad magadbal aknismalgu, Gamaliel tule-tummaganga chogal: “Israel-tummagan, wijir, pe we-tulemalgin-immal-imakoedgin. ¿Ibiga an teob chog? Nabir. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Imi pemal ampa wismal, akpene Teudas egmalga pul tule-tummadyob itobi-kual. Imi teun tulemal-tulaataled-ilabake Teudasbak naigusmal. Tenal tulemal yabli Teudas-mechamal. Tegin Teudas-e-pakamalad pél akne-akne aknidmal, teje pelgunonijun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Tegin Teudas-purkwijad-cholbal, tulemal-nug-weilenaidgin, Judas-Galileagined tule-tummadga togbi-kunonimo. Tegin tulemal Judasbal naigusmalmo. Tegin Romano-tulemal Judas-mechamalmo. Tegin Judas-e-chapingan pél akne-akne aknidmalmo, teje pelgunonimojun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Al an pemalga chogdo: meke timal we tulemal, pe melle tar-mesmalo. Imi we tulemal aga itolegedbal chunmadimalal, tegin e-itolegedbal immal imadimalbalil, we igal pelgunoniko. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tenal we igal Pabgadil, pemal we igal kwen opelogojulmal. Tenal pe wijirmal, pe melle Pab-Tummad-abin-kwisgudamalo.” Tegin Judio-tummagan yer itosmal, Gamaliel ega chogzhad. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tegin tule-tummagan Jesús-nuggin-palmilegalmaladzhe kannan kochabalgu, sapejul Jesús-nuggin-palmilegalmalad-ebiosmal. Tegin tule-tummagan Jesús-nuggin-palmilegalmaladga chogalmal: —Imi an pemal-pal-peichul, pemal Jesús-nuggin tulemalga pal chunmamal. Tegin tule-tummagan kep Jesús-nuggin-palmilegalmalad-ololchasmalzhun. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tegin Jesús-nuggin-palmilegalmalad weligwal tule-tummagan-akar nadmal. ¿Ibiga Jesús-nuggin-palmilegalmalad weligwal nadmal pe ebinzhe? Nabir. Imi Pab Tummad Jesús-nuggin peyedzhe wilegal yer Jesús-nuggin-palmilegalmalad-takchadbal, Jesús-nuggin peyedzhe wilegal, al Jesús-nuggin-palmilegalmalad weligwal-ito nadmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tegin Jesús-nuggin-palmilegalmalad pane-pane Pabzhe-koled-neggin, tegin neg-ilbal, tulemal-oturdadi-kualmal, Jesús Cristo-Pab-akpene-chogzhad-palmidagoed-tule. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Imi teun tulemal-Jesúsgin-ibzhemalad ichejul melgunatapidbal, tulemal-Griego-kakagin-chunmamalad Hebreo-tulemalgin ulualmal, chogalmal: “Imi kwenamalad pane-pane immalmal mimilemaid, anmal-omegan-machered-pato-tarbi-purkwismaladdin immal kwen abingejulmal, Judio-omeganbi immalmal abingemamimal.” ");
INSERT INTO kvnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tegin Jesús-nuggin-palmilegalmalad wisgusgu immalmal nuekwa kwen mimilemaichul, pel-kwapa Jesúsgin-ibzhemaladzhe kochamal ormagal. Tegin Jesús-nuggin-palmilegalmalad pél ormanonimalgu, Jesúsgin-ibzhemaladga chogalmal: “Imi anmal wisgusdo, immalmal-mimilegedgin poni wis nai, omegan-wal-walgwen nuekwa immalmal kwen abingejulmal. Imi anmal takmaldo, anmal Jesús-igalgin tulemal-oturdanaid ebegal, pul ib-nuedzhul, kwenamaladga immalmal-mimiedga toggal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“Kwenamalad, al pemal walakugle aga pe-pakamalad-amio. Tenal we tulemal-pe-chumaloed, tulemal-kin-immal-choged-nikchulmalad, tegin pela-pela Pab-Purpa-Nued-nikmalad, tegin pinzheed-nued-nikpalid. Tegin pe walakugle pe-pakamalad amijal, pe anka chedamalo. Tegin anmal we kwenamalad-walakugled-nugzhemalzhunno kwenamaladga-immalmal-mimied takegal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","“Tenal anmal-Jesús-nuggin-palmilegalmaladdin Pabzhe-koledgin, tegin Pab-Jesús-igalgin-chunmakedginbi arpanemalmojun.” ");
INSERT INTO kvnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tegin tule-Jesúsgin-ibzhemalad Jesús-nuggin-palmilegalmalad-chogzhad pél yer-itosmalgu, walakugle Jesúsgin-kwenamalad-amismal. Imi we tule-walgwen nug Esteban. Tenal Esteban pela-pela Pabgin-penzhul, tegin Pab-Purpa-Nued-pela-pela-nikpal. Tegin tule-chulesmalad-pimaladdin nug-nemal Felipe, Prócoro, Nicanor, Timón, Parmenas, tegin Nicolás. Tenal Nicolás, Antioquíagined, tenal Judio-igalgin-togzhad-tule. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tegin Jesúsgin-ibzhemalad pél tulemal-amismalgu, Jesús-nuggin-palmilegalmaladzhe we tule-walakugled-chesmal. Tegin Jesús-nuggin-palmilegalmalad we tule-walakugledga Pabzhe kochamal. Tegin Jesús-nuggin-palmilegalmalad chunkalgin tulemal-walakugled-nono ebusmalbal oyogal, we tulemal Pab-kannalegedbal arpagedgin togzhamal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tegin Pab-kaka-nuegan pul-pule choglemaigus. Al Jerusaléngin tule-Pab-igalgin-turdamalad pul-íchejul melgunatapmal. Tegin tule-irwal-Pabzhe-kolmalad-ichejul Jesús-igalgin ibzhenonimalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tegin Esteban Pab-Purpa-Nued-kannaleged pela-pela nikadgin, tegin Pab-wiles-tulemal-takedyob nanedi-kual. Tegin Esteban tulemal-wagin peyedzhe immalmal-taktijulmalad imadi-kusbal. Tenal Esteban immal-taktijulmalad-imajadbal wilub oyos, Jesús-igalde ib-chunchunnad. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Imi teun takalgu, tulemal istar Jesúsgin-ibzhemalad-takalmal. Tegin tulemal-wal-walgwen Esteban-abin-kwisgunonimalgu, Estebanbak imakalmal. Tenal tule-Estebanbak-imakalmalad Cirene-tolgan, Alejandría-tolgan, Provincia-Cilicia-tolgan, tegin Provincia-Asiaginmalad. Tenal we tulemal e-Judio-ormaked-neg-nugad: Pinche-Arpanaid-akar-Nosmalad. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tenal Pab Purpa Nued Estebanga pinzheed-nued ukchadbal, we tulemal keg Estebangin nakwegusmal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tegin tule-Estebanbak-imasmalad otukal tule-pimalad-amismal, Estebangin kakanzhegal. Tegin tule-Estebangin-kakanzhemalad chogalmal: “Imi anmal itosdo, Esteban Moisés-igalgin, tegin Pab-Tummad-nuggin istar chunmadibal.” ");
INSERT INTO kvnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tenal tule-Estebangin-kakanzhasmalad Judio-chelegan-tummagan tegin Moisés-igalgin-tule-oturdamalad tegin tule-pimalad-o-ulusmal istar Esteban-takegal. Tegin tule-tummagan Esteban-kasmalgu, e-ormaked-negzhe Esteban-chesmalzhun, Judio-tummagan-wala-tulapá-kakaambegwad Estebanga igal-itogal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tegin tule-tummagan ormaked-negzhe tule-kakanzhemalad-cheinonimal pinche Estebangin kakanzhemalgal. Tegin tule-kakanzhemalad chogalmal: —Imi Esteban Pabzhe-koled-neg-ilgwenadgin, keg-chulgu istar chunmakalda, tegin Moisés-igalgin, keg-chulgu istar chunmakaldabal. ");
INSERT INTO kvnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","¿Ibiga an nabir wiis? Nabir. Imi anmal itosmaldo Esteban chog: ‘Jesús-Nazaretkined, iti-Pabzhe-koled-neg opelone, tegin Moisés-akpene-anmalga-igal-mezhijad o-akalonebal.’ ");
INSERT INTO kvnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tegin tule-tummagan-pel-kwapa-ormakedgin-pukmalad, nuu Esteban-takchagu, takalmal Esteban-e-wagal angel-wagalyob takle-pes. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tegin tule-irwal-Pabzhe-kolmalad-pul-tummad Estebanzhe ekichial: —¿Imi tulemal-pe-tuktinanimalad, ib-chunchunnad o chul? Tegin Esteban tule-tummaganga chogal: —We tulemal pinche ankin kakanzhenanimal. Tegin tule-tummagan Estebanga chogalbal: —Imisgin pe chogmojundo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tegin Esteban tule-tummaganga chogal: “Kwenamalad, tegin Judio-chelegan-tummagan, imi pe nuekwa an-chunmaneed itomalo. Imi anmal-tadgan-Abraham, ampayo Harángin meggweddu, ampa Mesopotamiagin-maidgin, Pab Tummad pela-pela nugu-taklegedgin, tegin pela-pela kannaleged-nikadgin Abrahamga nononi. “Tegin Pab Tummad Abrahamga chogal: ");
INSERT INTO kvnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Imi pedin aga neg-kwebur-akar nao, tegin pe aga kwenamalad-mido. Tegin an pega neg oyogo, pia pe mego. Imi pe we negzhe nejunno. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tegin Abraham Mesopotamiagin Caldea-tulemal-akar nosgu, Haránzhe megnonijun. Tegin Abraham-e-pab-purkwijad-cholbal, kep Pab Tummad Harán-neg-kwebur-akar kannan Abraham-onos, tegin iti-nap-anmal-pukmaladzhe Abraham-palminoni. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Imi teun Pab Tummad Abrahamga pel-toto nap kwen ukchajul-kus. Imi teun Abraham ampa nuchu-nikchul kudii. Tenal Pab Tummad yabli Abrahamga kaka-ukcha: ‘Iti-naptin pegadga kuo. Tenal pe-purkwijad-cholbal, iti-nap pe-wagwaganga peio.’ ");
INSERT INTO kvnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Imi teun Pab Tummad Abrahamga chogzhabal: Imi pe-wagwagan napa-pidgin tule-pidyob ampagumalo, tegin tule-we-napkin-pukmaladga pe tule-pinche-arpamaladga kumalo. Tegin pe-wagwagan pirka-tulaataled-ilabake wilemalo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Tegin Pab Tummad Abrahamga chogzhabal: Antin peyedzhe tulemal-pinche-arpaged-kanimalad-oturdako. Tegin pe-wagwagan kannan aknimalo. Tegin pe-wagwagan itije kannan nonimalbalo. Tegin pe-wagwagan itigin anche koledgin an-otummodamalo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Al Pab Tummad Abrahambak abgan-tuku-chiked-igal-mezhis oyogal, Abraham Pab-Tummad-choged-pallí nane. Tegin Abraham-wagwagan ampa abgan-tuku-chiked-igalgin naneenabmalmo. Al Abraham-e-machi-Isaac mimmilenonigu, ibapábakkin e-machi-abgan-tuku chikcha. Tegin Isaac machi-Jacob-nikunonigu, ampa teopí imasmo. Tegin Jacob machimal-walambe-kakabog-nikusgu, e-machimal-abgan-tuku chikchamo. Imi we tulemal anmal-tadgando. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tegin Jacob pul-yer e-machi-José-takedbal Jacob-machimal-walambegwad istar aga e-urpa-José-taknonimal. Al José-e-iamal manigin tule-Egiptoje-irmamamimaladga e-urpa-José-ukchamal tule-pinche-arpagedga kugal. Tenal Pab Tummad yabli Josébak kudigus. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","“Tegin Pab Tummad wilediid-akar José-onos. Tegin Pab Tummad pirkin-immal-wisgal José-imasbal. Tegin Pab Tummad yer-José-takegal Faraón-errey-Egiptogined-imasbal. Al Faraón yer José-takalzhun. Tegin Faraón kep e-cholbalidga José-odoszhun pel-kwapa Egipto-nap takegal, tegin Faraónga pel-kwapa immalmal takegalbal. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tegin Egipto-napkin, tegin Canaán-napkin pel-kwapa mas-kunned-nikchul kunonigu, peyedzhe wilegalmalzhun. Tegin anmal-tadgan mas-kunned-onojulmaladbal ampa wilegalmalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tegin Jacob wisgusgu, Egipto-napkin mas-kunned-uked nika, Jacob kep e-machimal-palmis mas-kunned paknegal. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Tegin José-e-iamal ilbo-akpiredgin mas-kunned pakegal, José kep e-iamalga chogzha ede pe-urpa-José. Tegin Faraón kep José-e-iamal-wisgunonimo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tegin José kep e-pabzhe kaka-palmiszhun: ‘Pedin tegin anmal-kwenamalad pel-kwapa anche tagmalo.’ Imi teun José-e-kwenamalad tulapá-kakaambe-kakaatal kudimal. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Tegin José-e-pab-Jacob pel-kwapa Egipto-napche megnonimalgu, pirkabal megwismal. Tegin Jacob Egipto-napkin-mai purkwiszhun. Tegin Jacob-e-machimal pél Egiptogin purkwismalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Imi akpene Abraham Siquemgin Hamor-e-machimalzhe, manigin uan-pakcha. Tegin Jacob-purkwisgu, e-kwenamalad kannan Canaán-napche Jacob-mui chesmal tiggal. Tegin Jacob-e-wagwagan Jacob-e-machimal-mui chesmalmo, Siquemzhe tiggalmo. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tegin Pab Tummad Abrahamga kaka-ukchad ibe omodanigu Abraham-e-wagwagan kannan Canaán-napche negal, Egipto-napkin Abraham-e-wagwagan íchejul melgunoni. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Imi teun Egiptogin errey-maid José akpene Egipto-napka immal-imaszhulidyob taknoni. ");
INSERT INTO kvnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Al we 